/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_16_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000016140ULL, 0x0000000000015dc0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL,
0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL,
0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL,
0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL,
0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c00010000028dULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00010000036fULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b0022000003b5ULL, 0x0000000000014510ULL, 0x0000000000000170ULL, 0x000b0022000003e8ULL,
0x0000000000014680ULL, 0x0000000000000040ULL, 0x000b002200000413ULL, 0x00000000000146c0ULL,
0x0000000000000050ULL, 0x000b00220000043dULL, 0x0000000000014710ULL, 0x00000000000000f0ULL,
0x000a0003000004abULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000004cbULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004fbULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000014800ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001451000000000ULL, 0x0000040400000000ULL, 0x810c000001740400ULL,
0x004fc40400288080ULL, 0x0000000000000000ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8608288080820828ULL, 0x2880808708288080ULL, 0x808a082880808908ULL, 0x082880808b082880ULL,
0x80808e082880808dULL, 0x90082880808f0828ULL, 0x2880809108288080ULL, 0x809a082880809208ULL,
0x162880808c082880ULL, 0x0000031028808280ULL, 0x8c92000000000000ULL, 0x0000002200288080ULL,
0x0000002cffffffffULL, 0x0000007000000000ULL, 0x0001451000000000ULL, 0x0000017000000000ULL,
0x0000480400000000ULL, 0x8083288080860900ULL, 0x0000000000002880ULL, 0x0000007cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8608288080820828ULL, 0x2880808708288080ULL, 0x808a082880808908ULL,
0x082880808d082880ULL, 0x80808f082880808eULL, 0x9108288080900828ULL, 0x2880809208288080ULL,
0x808c082880809a08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x22002880808c9200ULL,
0x0000001cffffffffULL, 0x0000013800000000ULL, 0x0001468000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8608288080820828ULL,
0x2880808708288080ULL, 0x808a082880808908ULL, 0x082880808b082880ULL, 0x80808d082880808cULL,
0x8f082880808e0828ULL, 0x2880809008288080ULL, 0x809a082880809208ULL, 0x1628808091082880ULL,
0x0000031028808280ULL, 0x9192000000000000ULL, 0x0000002200288080ULL, 0x0000002cffffffffULL,
0x000001e800000000ULL, 0x000146c000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x8090288080910900ULL, 0x0000000000002880ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8608288080820828ULL, 0x2880808708288080ULL, 0x808a082880808908ULL, 0x082880808b082880ULL,
0x80808d082880808cULL, 0x8f082880808e0828ULL, 0x2880809108288080ULL, 0x809a082880809208ULL,
0x1628808090082880ULL, 0x0000031028808280ULL, 0x9092000000000000ULL, 0x0000002200288080ULL,
0x0000001cffffffffULL, 0x000002b000000000ULL, 0x0001471000000000ULL, 0x000000f000000000ULL,
0x0000000000000000ULL, 0x0000001800082f04ULL, 0x0008230400000080ULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL,
0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL,
0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL,
0x0000001100082304ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008230400000000ULL, 0x0000000000000018ULL, 0x0000001800081204ULL, 0x0008110400000000ULL,
0x0000000000000018ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0068016000000015ULL,
0x000c170400681903ULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL, 0x0058000900000000ULL,
0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL,
0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0x00000b2000043104ULL,
0xffffffff01542904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000036001542804ULL,
0x0000055000000430ULL, 0x00002e1000001d00ULL, 0x00002fe000002ec0ULL, 0x0000335000003140ULL,
0x000033d000003380ULL, 0x00003ae000003420ULL, 0x00004ba000004b00ULL, 0x00004e3000004cd0ULL,
0x0000507000005040ULL, 0x00005110000050c0ULL, 0x0000656000005540ULL, 0x00006720000065f0ULL,
0x00006a9000006880ULL, 0x00006b1000006ac0ULL, 0x00006f7000006b60ULL, 0x000080c000008030ULL,
0x00008350000081f0ULL, 0x0000859000008560ULL, 0x00008630000085e0ULL, 0x00008b3000008b20ULL,
0x0000aef00000aeb0ULL, 0x0000b6800000b640ULL, 0x00012e5000012e10ULL, 0x00012e7000012e60ULL,
0x00012ee000012ec0ULL, 0x00012f1000012f00ULL, 0x00013b9000013b50ULL, 0x00013c2000013be0ULL,
0x00013cc000013c70ULL, 0x00013d5000013d10ULL, 0x00013de000013da0ULL, 0x00013e8000013e30ULL,
0x00013f1000013ed0ULL, 0x00013fa000013f60ULL, 0x0001404000013ff0ULL, 0x000140d000014090ULL,
0x0001416000014120ULL, 0x00014200000141b0ULL, 0x000142b000014250ULL, 0x0001437000014310ULL,
0x00014430000143d0ULL, 0x000144f000014490ULL, 0x0000046002003904ULL, 0x00013600000000ffULL,
0x000004a0003f0100ULL, 0x000136080000000fULL, 0x000004e0003f0120ULL, 0x000136880000000fULL,
0x00000b70003f0120ULL, 0x00013600000000ffULL, 0x00000d40003f0107ULL, 0x0001368c0000006aULL,
0x00000e10003f0102ULL, 0x000136880000006aULL, 0x00002b20003f0101ULL, 0x000136080000000dULL,
0x00002b40003f0101ULL, 0x0001360c0000000dULL, 0x00002d10003f0105ULL, 0x0001360c0000000dULL,
0x00003a60003f0105ULL, 0x0001368800000059ULL, 0x00004800003f0101ULL, 0x000136280000000dULL,
0x00004860003f0101ULL, 0x0001362c00000009ULL, 0x00004a30003f0105ULL, 0x0001362c00000009ULL,
0x000054c0003f0105ULL, 0x0001369000000059ULL, 0x00006260003f0101ULL, 0x0001364800000009ULL,
0x000062c0003f0101ULL, 0x0001364c00000009ULL, 0x00006490003f0105ULL, 0x0001364c00000009ULL,
0x00006f50003f0105ULL, 0x0001369800000059ULL, 0x00007d30003f0101ULL, 0x0001366800000009ULL,
0x00007d90003f0101ULL, 0x0001366c0000000bULL, 0x00007f60003f0105ULL, 0x0001366c0000000bULL,
0x000089b0003f0105ULL, 0x000136a000000059ULL, 0x0000c850003f0101ULL, 0x00013600000000ffULL,
0x0000d430003f0101ULL, 0x00013604000000ffULL, 0x0000d640003f0105ULL, 0x00013604000000ffULL,
0x00011210003f0105ULL, 0x0000000000000075ULL, 0x00011280003f0101ULL, 0x0000000400000075ULL,
0x00011450003f0105ULL, 0x0000000400000075ULL, 0x000139b0003f0105ULL, 0x0001360800000076ULL,
0x00013a10003f0101ULL, 0x0001361000000076ULL, 0x00013a70003f0101ULL, 0x0001361800000076ULL,
0x00013ae0003f0101ULL, 0x0001362000000076ULL, 0x00033803003f0101ULL, 0x0000bec000201c04ULL,
0x0000c1800000bef0ULL, 0x0000c5700000c370ULL, 0x0000d6a00000c720ULL, 0x0000040100013b20ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000354ULL, 0x0000001800000002ULL, 0x000000000000028cULL,
0x0000001800000002ULL, 0x00000000000001d4ULL, 0x0000001800000002ULL, 0x0000000000000114ULL,
0x0000001800000002ULL, 0x0000000000000044ULL, 0x0000001800000002ULL, 0x000000000000032eULL,
0x0000001800000002ULL, 0x0000000000000266ULL, 0x0000001800000002ULL, 0x00000000000001b1ULL,
0x0000001800000002ULL, 0x00000000000000eeULL, 0x0000001800000002ULL, 0x0000000000013700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000797919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff020424ULL, 0x000fe200078e00ffULL,
0x0000000179040810ULL, 0x002fca0007ffe0ffULL, 0x00005c0004040625ULL, 0x000fc800078e0002ULL,
0x00005c0079020625ULL, 0x000fe200078e0002ULL, 0x0000000604000981ULL, 0x0002aa000c1e1900ULL,
0x0000000602030981ULL, 0x0006a2000c1e1900ULL, 0x0000590000087b06ULL, 0x000f220000209000ULL,
0x00005900ff777624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000747919ULL, 0x000e620000002600ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x00005a00ff0e7624ULL, 0x000fc400078e00ffULL, 0x00000000000c7919ULL, 0x000e640000002300ULL,
0x000059000e0e7a24ULL, 0x000fe400078e02ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x0000000800087308ULL, 0x010f240000001000ULL, 0x0ffffffe08067810ULL, 0x010fcc0007ffe0ffULL,
0x0000000600077305ULL, 0x000864000021f000ULL, 0x000000ffff067224ULL, 0x010fe400078e00ffULL,
0x000000ffff097224ULL, 0x002fc800078e0a07ULL, 0x0000590009097a24ULL, 0x000fc800078e02ffULL,
0x0000000907077227ULL, 0x000fcc00078e0006ULL, 0x0000040007077a27ULL, 0x000fc800078e00ffULL,
0x000000ffff027224ULL, 0x008fc800078e0a07ULL, 0x0000040002027624ULL, 0x000fca00078e0277ULL,
0x0000590002007a0cULL, 0x000fda0003f26070ULL, 0x8000590002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x0000590002007a0cULL, 0x000fda0003f46070ULL,
0x0000000107072810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff07ba12ULL, 0x000fc800078e33ffULL,
0x0000000700027306ULL, 0x000e620000209000ULL, 0x000000ff0700720cULL, 0x000fce0003fa5070ULL,
0x0000000200027308ULL, 0x002e640000001000ULL, 0x0ffffffe02047810ULL, 0x002fcc0007ffe0ffULL,
0x0000000400057305ULL, 0x0002e4000021f000ULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x0000000507067224ULL, 0x008fc800078e02ffULL, 0x000000ffff097224ULL, 0x000fe200078e0a06ULL,
0x00000005ff067819ULL, 0x000fc6000001160bULL, 0x0000000905057227ULL, 0x000fcc00078e0004ULL,
0x00000074056d7227ULL, 0x000fe400078e00ffULL, 0x0000000000057919ULL, 0x000e640000002200ULL,
0x000000ffff027224ULL, 0x000fc800078e0a6dULL, 0x0000000207027224ULL, 0x000fca00078e0274ULL,
0x000000070200720cULL, 0x000fda0003f66070ULL, 0x0000000102023824ULL, 0x000fe200078e0a07ULL,
0x000000016d6d3810ULL, 0x000fe20007ffe0ffULL, 0x000001000c047a24ULL, 0x002fe400078e0205ULL,
0x00001fff0c0c7589ULL, 0x000fe200000e0000ULL, 0x000000070200720cULL, 0x000fe20003f86070ULL,
0x00000000040f7a24ULL, 0x000fca00078e020bULL, 0x000000ff0f00720cULL, 0x040fe40003f25270ULL,
0x0000000f0f00780cULL, 0x040fe40003f44070ULL, 0x000000030f00780cULL, 0x000fc60003f64070ULL,
0x000000016d6d4810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff6dd212ULL, 0x000fe400078e33ffULL,
0x0000007f0f00780cULL, 0x000fe40003f84070ULL, 0x3fffff80ff049424ULL, 0x000fe400078e00ffULL,
0x000000ffff0a7224ULL, 0x000fe400078e0a6dULL, 0x7fffff80ff059424ULL, 0x000fc400078e00ffULL,
0x0000000a07747224ULL, 0x000fe400078e0274ULL, 0x00001fff06077589ULL, 0x0002e200000e0000ULL,
0x3fffffc0ff08a424ULL, 0x000fe400078e00ffULL, 0x0000000474747819ULL, 0x000fe200000006ffULL,
0x01360004ff009388ULL, 0x000fe20000000a00ULL, 0x7fffffc0ff09a424ULL, 0x000fe400078e00ffULL,
0xff317217ff10c424ULL, 0x000fe400078e00ffULL, 0x3fffff60ff0ab424ULL, 0x000fe200078e00ffULL,
0x013608080f00a388ULL, 0x000fe20000008a00ULL, 0x7fffff60ff0bb424ULL, 0x000fc400078e00ffULL,
0x00000004ff067e24ULL, 0x002fe2000f8e00ffULL, 0x013400100f00c388ULL, 0x000fe80000004800ULL,
0x0136880a0f00b388ULL, 0x000fe20000008a00ULL, 0x0000000100020824ULL, 0x004fe400078e0a03ULL,
0x00005800ff028624ULL, 0x000fe400078e00ffULL, 0x0000580079038a24ULL, 0x000fc400078e02ffULL,
0x00005a00020d7a24ULL, 0x000fe400078e02ffULL, 0x0000000e03727224ULL, 0x000fe400078e02ffULL,
0x000000010d007824ULL, 0x040fe200078e0a74ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000740d00720cULL, 0x000fe20003f26070ULL, 0x00005a006d117a24ULL, 0x000fe200078e0272ULL,
0x0000001000007817ULL, 0x000fc80003800000ULL, 0x000000ff00707207ULL, 0x000fe20000800000ULL,
0x000000040c007824ULL, 0x008fc600078e0207ULL, 0x000000107000780cULL, 0x000fe20003f05270ULL,
0x0000000200007824ULL, 0x000fd800078e00ffULL, 0x000002c000008947ULL, 0x000fea0003800000ULL,
0x00005a00000a7b06ULL, 0x000e620000209000ULL, 0x0000000000057919ULL, 0x000ea20000000000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fca0003f45070ULL,
0x0000000a000a7308ULL, 0x002e620000001000ULL, 0x00000004ff047819ULL, 0x004fca0000011605ULL,
0x00000001000d7824ULL, 0x000fe200078e0204ULL, 0x0ffffffe0a097810ULL, 0x002fcc0007ffe0ffULL,
0x0000000900097305ULL, 0x000e64000021f000ULL, 0x000000ffff0b7224ULL, 0x002fc800078e0a09ULL,
0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b090b7227ULL, 0x000fc800078e0008ULL,
0x0000000174087824ULL, 0x000fc800078e020dULL, 0x000000080b0b7227ULL, 0x000fc800078e00ffULL,
0x000000ffff0f7224ULL, 0x000fc800078e0a0bULL, 0x00005a000f097a24ULL, 0x000fca00078e0208ULL,
0x00005a0009007a0cULL, 0x000fda0003f06070ULL, 0x80005a0009090a10ULL, 0x000fe40007ffe0ffULL,
0x000000010b0b0810ULL, 0x000fe40007ffe0ffULL, 0x00005a0009007a0cULL, 0x000fda0003f26070ULL,
0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff0baa12ULL, 0x000fca00078e33ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a0bULL, 0x00005a0009087a24ULL, 0x000fe200078e0208ULL,
0x0000000070097217ULL, 0x000fc60007800000ULL, 0x0000000111087824ULL, 0x000fe400078e0208ULL,
0x0000000109097824ULL, 0x000fe400078e0a00ULL, 0x0000000e0b0b7224ULL, 0x000fe400078e0208ULL,
0x0000001005087824ULL, 0x000fe200078e00ffULL, 0x000000090400720cULL, 0x000fe20003f06070ULL,
0x000001000b0a7825ULL, 0x000fc600078e00ffULL, 0x000000f0080f7812ULL, 0x000fe200078ec0ffULL,
0x000000010d007824ULL, 0x040fe400078e0205ULL, 0x000000100d0d7824ULL, 0x000fe200078e00ffULL,
0x0000000f0a0f7212ULL, 0x000fc800078efcffULL, 0xfffffff00d007812ULL, 0x000fe400078ee200ULL,
0x000060000f0a7a10ULL, 0x000fc60007f3e0ffULL, 0x0000001000097824ULL, 0x000fe200078e00ffULL,
0x000061000b0b7a10ULL, 0x000fca0000ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a097faeULL, 0x0003e2000c101c46ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x00005a00000a7b06ULL, 0x000e620000209000ULL, 0x0000000000057919ULL, 0x000ea20000000000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fca0003f45070ULL,
0x0000000a000a7308ULL, 0x002e620000001000ULL, 0x0000000005007211ULL, 0x004fca00078fe0ffULL,
0x0000000174047824ULL, 0x000fe200078e0200ULL, 0x0ffffffe0a0b7810ULL, 0x002fc80007ffe0ffULL,
0x0000000b00097305ULL, 0x000e64000021f000ULL, 0x000000ffff0d7224ULL, 0x002fc800078e0a09ULL,
0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL, 0x0000000d090d7227ULL, 0x000fcc00078e0008ULL,
0x000000040d087227ULL, 0x000fca00078e00ffULL, 0x000000ff08097210ULL, 0x000fca0007ffe1ffULL,
0x00005a0009097a24ULL, 0x000fca00078e0204ULL, 0x00005a0009007a0cULL, 0x000fda0003f06070ULL,
0x80005a0009090a10ULL, 0x000fe40007ffe0ffULL, 0x0000000108080810ULL, 0x000fe40007ffe0ffULL,
0x00005a0009007a0cULL, 0x000fda0003f26070ULL, 0x0000000108081810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff08aa12ULL, 0x000fca00078e33ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a08ULL,
0x00005a0009047a24ULL, 0x000fc800078e0204ULL, 0x0000000111097824ULL, 0x000fe400078e0204ULL,
0x0000000100047824ULL, 0x000fe400078e0205ULL, 0x0000000e08097224ULL, 0x000fe400078e0209ULL,
0x0000001005087824ULL, 0x000fe400078e00ffULL, 0x00000100090a7825ULL, 0x000fc600078e00ffULL,
0x000000f008097812ULL, 0x000fc800078ec0ffULL, 0x000000090a0a7212ULL, 0x000fe200078efcffULL,
0x0000001000097824ULL, 0x000fc600078e00ffULL, 0x000060000a0a7a10ULL, 0x000fe40007f1e0ffULL,
0xfffffff009047812ULL, 0x000fe400078ee204ULL, 0x000061000b0b7a10ULL, 0x000fc600007fe4ffULL,
0x0000001004097824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a097faeULL, 0x0003e4000b901c46ULL, 0x0000000000097919ULL, 0x002e620000000000ULL,
0x0000000000007806ULL, 0x000fe200038e0000ULL, 0x00000004ff4c7424ULL, 0x000fc600078e00ffULL,
0x0000000000047300ULL, 0x000e7000000e0000ULL, 0x00000000000a7309ULL, 0x000ea20000000000ULL,
0x000000090400720cULL, 0x002fe40003f02070ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffff047224ULL, 0x004fc400078e0a0aULL, 0x00006800790a7625ULL, 0x000fd000078e004cULL,
0x01360404ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01360000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000000060a637981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0c00720cULL, 0x000fe40003f05270ULL, 0x0000003f63717810ULL, 0x044fe40007ffe0ffULL,
0x000000ff63647810ULL, 0x000fc40007ffe0ffULL, 0x00000006ff717819ULL, 0x000fe40000011671ULL,
0x00000008ff647819ULL, 0x000fca0000011664ULL, 0x0000bab000008947ULL, 0x000fea0003800000ULL,
0x00000002ff6b7819ULL, 0x000fe20000011607ULL, 0x00000008076a7824ULL, 0x000fe400078e00ffULL,
0x00000003ff0b7424ULL, 0x000fe200078e00ffULL, 0x03ffffff6b037812ULL, 0x000fe200078ec0ffULL,
0xffffffffff097424ULL, 0x000fc800078e00ffULL, 0x0000000406007824ULL, 0x000fca00078e0203ULL,
0x000000710000720cULL, 0x000fda0003f06070ULL, 0x0000000279028824ULL, 0x000fe400078e00ffULL,
0x00006a00ff038624ULL, 0x000fc800078e00ffULL, 0x00006a0002038624ULL, 0x000fc800078e0203ULL,
0x0000000100038824ULL, 0x000fe200078e0203ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01368c0b6aff738cULL, 0x0005e20000000000ULL, 0x0000660003028625ULL, 0x000fe200078e004cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000602098981ULL, 0x000ee2000c1e1900ULL,
0x00000001060b7810ULL, 0x004fe20007ffe0ffULL, 0x000000406d667824ULL, 0x000fe200078e00ffULL,
0x00000001ff047819ULL, 0x002fe20000011607ULL, 0x00000100ff0a7424ULL, 0x000fe200078e00ffULL,
0x000000640b00720cULL, 0x000fe20003f06070ULL, 0x013688006aff7f8cULL, 0x0003e2000c80043fULL,
0x0000000107687812ULL, 0x000fe200078ec0ffULL, 0x00000020046c7824ULL, 0x000fc800078e00ffULL,
0x00000100060c7824ULL, 0x000fca00078e026cULL, 0x00000020660e7812ULL, 0x000fe200078ef80cULL,
0x0000590009097a24ULL, 0x008fc800078e02ffULL, 0x0000004009097824ULL, 0x000fc800078e00ffULL,
0x0000640009027625ULL, 0x000fe200078e000aULL, 0x0000064000008947ULL, 0x000fea0003800000ULL,
0x00000003ff187819ULL, 0x102fe20000011605ULL, 0x0000000204177824ULL, 0x000fe200078e0268ULL,
0x0000000c63097217ULL, 0x000fe40007800000ULL, 0x00000004180a7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c18167810ULL, 0x040fe40007ffe0ffULL, 0x0000000818107810ULL, 0x000fe20007ffe0ffULL,
0x000000010a0b7824ULL, 0x100fe200078e0205ULL, 0x000000090c097210ULL, 0x000fe20007ffe1ffULL,
0x000000080a127824ULL, 0x000fe200078e00ffULL, 0x00000014181c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001160d7824ULL, 0x040fe200078e0205ULL, 0x00000020090f7817ULL, 0x000fe20003800000ULL,
0x0000000816147824ULL, 0x000fe200078e00ffULL, 0xfffffff8121b7812ULL, 0x000fe200078ee20bULL,
0x00000001100c7824ULL, 0x000fe200078e0205ULL, 0x00000070080b7812ULL, 0x000fe200078ec0ffULL,
0x00000008101d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8141f7812ULL, 0x000fe200078ee20dULL,
0x000000010e0d7824ULL, 0x000fe200078e020aULL, 0x0000000f0a00720cULL, 0x080fe20003f86070ULL,
0x0000008068087824ULL, 0x000fe200078e020bULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee20cULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x00000010181a7810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0b7824ULL, 0x000fe200078e0218ULL, 0x0000000f1000720cULL, 0x080fe20003f66070ULL,
0x000001000d0c7825ULL, 0x000fe200078e0008ULL, 0x0000000f1600720cULL, 0x000fc40003f46070ULL,
0x0000000f1800720cULL, 0x000fe20003fa6070ULL, 0x000001000b0a7825ULL, 0x000fe200078e0008ULL,
0x0000000c02147210ULL, 0x000fc60007f3e0ffULL, 0x000000011c137824ULL, 0x100fe200078e0205ULL,
0x0000000a02127210ULL, 0x000fe20007f1e0ffULL, 0x000000081c207824ULL, 0x000fe400078e00ffULL,
0x000000011a117824ULL, 0x040fe400078e0205ULL, 0x000000081a1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff820257812ULL, 0x000fe200078ee213ULL, 0x0000000103157824ULL, 0x040fe200008e060dULL,
0x0000000f1a00720cULL, 0x000fe20003f26070ULL, 0x000000010e0d7824ULL, 0x000fe200078e0216ULL,
0xfffffff81e217812ULL, 0x000fe200078ee211ULL, 0x0000000103137824ULL, 0x000fe200000e060bULL,
0x0000001a0e117210ULL, 0x040fe20007ffe0ffULL, 0x000000010e0b7824ULL, 0x000fe200078e0210ULL,
0x0000b000171a7811ULL, 0x000fe200078e68ffULL, 0x0000000118107824ULL, 0x000fc400078e0205ULL,
0x000001000d0c7825ULL, 0x000fc600078e0008ULL, 0x0000000710167812ULL, 0x000fe200078ec0ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0008ULL, 0x0000000c020c7210ULL, 0x000fe40007fde0ffULL,
0x0ffffff816177812ULL, 0x000fe200078ef805ULL, 0x0000010011107825ULL, 0x000fe200078e0008ULL,
0x0000000a020a7210ULL, 0x000fc60007f1e0ffULL, 0x00000001030d7824ULL, 0x040fe200030e060dULL,
0x0000001002167210ULL, 0x000fe20007fde0ffULL, 0x00000001030b7824ULL, 0x000fe200000e060bULL,
0x0000000f1c00720cULL, 0x080fe20003f06070ULL, 0x000000010e237824ULL, 0x000fe200078e021cULL,
0x00000018181c7810ULL, 0x040fe20007ffe0ffULL, 0x0000001017197824ULL, 0x100fe200078e021aULL,
0x0000001c18187810ULL, 0x000fe20007ffe0ffULL, 0x0000000103177824ULL, 0x000fe400030e0611ULL,
0x000000101b1b7824ULL, 0x000fe200078e021aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012197faeULL, 0x0003e2000e901c46ULL, 0x0000010023107825ULL, 0x000fe200078e0008ULL,
0x0000000f1c00720cULL, 0x000fc40003fa6070ULL, 0x00000000141b7faeULL, 0x0005e2000e101c46ULL,
0x000000010e237824ULL, 0x000fe200078e021cULL, 0x0000001002107210ULL, 0x000fe20007fde0ffULL,
0x000000010e277824ULL, 0x000fe200078e0218ULL, 0x0000000f1800720cULL, 0x000fe20003f86070ULL,
0x00000100230e7825ULL, 0x000fc800078e0008ULL, 0x0000000103117824ULL, 0x000fe200030e0611ULL,
0x0000000e020e7210ULL, 0x000fe20007fde0ffULL, 0x000000011c127824ULL, 0x142fe400078e0205ULL,
0x000000081c137824ULL, 0x000fe400078e00ffULL, 0x0000000118147824ULL, 0x044fe400078e0205ULL,
0x0000000818157824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee212ULL,
0x0000010027087825ULL, 0x000fc600078e0008ULL, 0xfffffff815157812ULL, 0x000fe200078ee214ULL,
0x00000001030f7824ULL, 0x000fe200030e060fULL, 0x0000000802027210ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x100fe400078e021aULL, 0x000000101f1f7824ULL, 0x100fe200078e021aULL,
0x0000000903037210ULL, 0x000fe200037fe4ffULL, 0x0000001021217824ULL, 0x100fe200078e021aULL,
0x000000000a1d7faeULL, 0x0003e2000d901c46ULL, 0x0000001025257824ULL, 0x100fe400078e021aULL,
0x0000001013137824ULL, 0x100fe200078e021aULL, 0x000000000c1f7faeULL, 0x0003e2000d101c46ULL,
0x0000001015157824ULL, 0x000fc600078e021aULL, 0x0000000016217faeULL, 0x0003e8000c901c46ULL,
0x0000000010257faeULL, 0x0003e8000c101c46ULL, 0x000000000e137faeULL, 0x0003e8000e901c46ULL,
0x0000000002157faeULL, 0x0003e2000e101c46ULL, 0x0000057000007947ULL, 0x000fea0003800000ULL,
0x0000000405097811ULL, 0x042fe200078fe8ffULL, 0x0000000204187824ULL, 0x000fe200078e0268ULL,
0x00000008050c7811ULL, 0x000fc400078fe8ffULL, 0x0000001405127811ULL, 0x000fe200078fe8ffULL,
0x00000001090a7824ULL, 0x100fe200078e0205ULL, 0x0000001005107811ULL, 0x000fe200078fe8ffULL,
0x00000008090d7824ULL, 0x000fe200078e00ffULL, 0x0000001c05177811ULL, 0x040fe200078fe8ffULL,
0x000000010c0b7824ULL, 0x140fe200078e0205ULL, 0x0000001805147811ULL, 0x000fe200078fe8ffULL,
0x000000080c1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d1a7812ULL, 0x000fe200078ee20aULL,
0x00000001120f7824ULL, 0x040fe200078e0205ULL, 0x0000000c050a7811ULL, 0x000fe200078fe8ffULL,
0x0000000812227824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL,
0x00000001100d7824ULL, 0x100fe200078e0205ULL, 0x00000003171b7819ULL, 0x000fe200000006ffULL,
0x000000010a0b7824ULL, 0x000fe200078e0205ULL, 0xfffffff822227812ULL, 0x000fe200078ee20fULL,
0x000000080a1e7824ULL, 0x000fe200078e00ffULL, 0x0000b00018277811ULL, 0x000fe200078e68ffULL,
0x0000000810207824ULL, 0x000fc400078e00ffULL, 0x000000010e0f7824ULL, 0x000fe200078e020aULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20bULL, 0x00000001170a7824ULL, 0x000fe200078e0205ULL,
0x00000070080b7812ULL, 0x000fe200078ec0ffULL, 0x000000010e197824ULL, 0x000fe200078e0217ULL,
0x0000000505087211ULL, 0x040fe200078fe8ffULL, 0x0000000114117824ULL, 0x000fe200078e0205ULL,
0xfffffff820207812ULL, 0x000fe200078ee20dULL, 0x0000008068167824ULL, 0x000fe200078e020bULL,
0x0000000708087812ULL, 0x000fe200078ec0ffULL, 0x000000010e0b7824ULL, 0x000fe200078e0209ULL,
0x0000000e05097211ULL, 0x000fe200078fe8ffULL, 0x0000000814247824ULL, 0x000fe200078e00ffULL,
0x0ffffff808187812ULL, 0x000fe200078ef805ULL, 0x000000ffff177224ULL, 0x000fe200078e00ffULL,
0xfffffff81b267812ULL, 0x000fe200078ee20aULL, 0x000000010e0d7824ULL, 0x000fe200078e020cULL,
0xfffffff824247812ULL, 0x000fe200078ee211ULL, 0x0000010009087825ULL, 0x000fc800078e0016ULL,
0x000001000b0a7825ULL, 0x000fe200078e0016ULL, 0x0000000802087210ULL, 0x000fc60007f1e0ffULL,
0x000000010e117824ULL, 0x000fe200078e0210ULL, 0x0000000a020a7210ULL, 0x000fe20007f3e0ffULL,
0x000000010e137824ULL, 0x040fe400078e0212ULL, 0x000000010e157824ULL, 0x000fe400078e0214ULL,
0x000001000d0c7825ULL, 0x000fc800078e0016ULL, 0x000001000f0e7825ULL, 0x000fe200078e0016ULL,
0x0000000c020c7210ULL, 0x000fc60007f5e0ffULL, 0x0000010011107825ULL, 0x000fe200078e0016ULL,
0x0000000e020e7210ULL, 0x000fc60007f7e0ffULL, 0x0000010013127825ULL, 0x000fc800078e0016ULL,
0x0000010015147825ULL, 0x000fc800078e0016ULL, 0x0000010019167825ULL, 0x000fc800078e0016ULL,
0x0000000103097824ULL, 0x040fe200000e0609ULL, 0x0000001002107210ULL, 0x040fe20007f1e0ffULL,
0x00000001030b7824ULL, 0x040fe200008e060bULL, 0x0000001202127210ULL, 0x000fe20007f3e0ffULL,
0x0000001018197824ULL, 0x000fe400078e0227ULL, 0x00000001030d7824ULL, 0x040fe200010e060dULL,
0x0000001402147210ULL, 0x000fe20007f5e0ffULL, 0x000000101a1b7824ULL, 0x000fe200078e0227ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008197faeULL, 0x0003e2000b901c46ULL,
0x00000001030f7824ULL, 0x000fe200018e060fULL, 0x0000001602027210ULL, 0x000fe20007f7e0ffULL,
0x000000101c1d7824ULL, 0x100fe200078e0227ULL, 0x000000000a1b7faeULL, 0x0003e2000b901c46ULL,
0x000000101e1f7824ULL, 0x000fc400078e0227ULL, 0x0000001020217824ULL, 0x000fe200078e0227ULL,
0x000000000c1d7faeULL, 0x0003e2000b901c46ULL, 0x0000000103117824ULL, 0x040fe400000e0611ULL,
0x0000001022237824ULL, 0x000fe200078e0227ULL, 0x000000000e1f7faeULL, 0x0003e2000b901c46ULL,
0x0000000103137824ULL, 0x040fe400008e0613ULL, 0x0000001024257824ULL, 0x000fe200078e0227ULL,
0x0000000010217faeULL, 0x0003e2000b901c46ULL, 0x0000000103157824ULL, 0x000fc400010e0615ULL,
0x0000001026277824ULL, 0x000fe200078e0227ULL, 0x0000000012237faeULL, 0x0003e2000b901c46ULL,
0x0000000103037824ULL, 0x000fc600018e0617ULL, 0x0000000014257faeULL, 0x0003e8000b901c46ULL,
0x0000000002277faeULL, 0x0003e4000b901c46ULL, 0x00000300ff6f7624ULL, 0x000fe200078e00ffULL,
0x0000000300027812ULL, 0x002fe200078ec0ffULL, 0xffffffffff517424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xfffffffd4c6f7424ULL, 0x000fe200078e026fULL,
0x000000030200780cULL, 0x000fc80003f05270ULL, 0x000000016f037807ULL, 0x000fc80004000000ULL,
0x0000000300087210ULL, 0x000fc80007ffe0ffULL, 0x000000710800720cULL, 0x000fda0003f06070ULL,
0x0000000279008824ULL, 0x000fe400078e00ffULL, 0x00006a00ff038624ULL, 0x000fc800078e00ffULL,
0x00006a0000038624ULL, 0x000fc800078e0203ULL, 0x00000001034d8824ULL, 0x000fc800078e0208ULL,
0x000066004d4c8625ULL, 0x000fca00078e004cULL, 0x000000064c518981ULL, 0x000322000c1e1900ULL,
0x000000640600720cULL, 0x000fe20003f06070ULL, 0xff317217ff0a7424ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00006d6000000947ULL, 0x000fea0003800000ULL,
0x0000000279677824ULL, 0x002fe400078e00ffULL, 0x00006a00ff007624ULL, 0x000fc400078e00ffULL,
0xff317217ff0a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fe400078e00ffULL,
0x00006a0067677624ULL, 0x000fc400078e0200ULL, 0x00000010070b7824ULL, 0x000fe200078e00ffULL,
0x00000001060d7810ULL, 0x020fe20007ffe0ffULL, 0x0000590051517a24ULL, 0x010fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe00b0b7812ULL, 0x000fe200078ec0ffULL,
0x00000040510c7824ULL, 0x000fe200078e00ffULL, 0x000000640d00720cULL, 0x000fe20003f06070ULL,
0x00000100ff0d7424ULL, 0x000fe400078e00ffULL, 0x00000100060b7824ULL, 0x000fe400078e020bULL,
0x000064000c0c7625ULL, 0x000fc600078e000dULL, 0x000000400b107810ULL, 0x000fc80007ffe0ffULL,
0x00000020100b7812ULL, 0x000fca00078ec0ffULL, 0x0000000166307824ULL, 0x000fe200078e020bULL,
0x0000068000008947ULL, 0x000fea0003800000ULL, 0x00000003ff407819ULL, 0x100fe20000011605ULL,
0x00000010050f7824ULL, 0x000fe200078e00ffULL, 0x00000010630b7217ULL, 0x000fe20007800000ULL,
0x00000080070e7824ULL, 0x000fe200078e00ffULL, 0x0000000440247810ULL, 0x040fe40007ffe0ffULL,
0x000000700f117812ULL, 0x000fe200078ec0ffULL, 0x000000010b0f7824ULL, 0x000fe200078e0a10ULL,
0x00000008403e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000124107824ULL, 0x140fe200078e0205ULL,
0x00000080110e7812ULL, 0x000fe200078ef80eULL, 0x00002000070b7824ULL, 0x000fe200078e00ffULL,
0x0000000324417819ULL, 0x000fe200000006ffULL, 0x000000013e3c7824ULL, 0x100fe200078e0205ULL,
0x0000000c40427810ULL, 0x000fe20007ffe0ffULL, 0x000000083e117824ULL, 0x040fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fe200078ee210ULL, 0x000000013e257824ULL, 0x000fe200078e0230ULL,
0x000020000b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000142317824ULL, 0x040fe200078e0205ULL,
0xfffffff8113c7812ULL, 0x000fe200078ee23cULL, 0x0000000842107824ULL, 0x000fe200078e00ffULL,
0x0000001040447810ULL, 0x040fe20007ffe0ffULL, 0x0000000140117824ULL, 0x040fe200078e0230ULL,
0x000000200f3d7817ULL, 0x000fe20003800000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x0000001440467810ULL, 0x000fe20007ffe0ffULL, 0x0000400004327824ULL, 0x000fe200078e020bULL,
0xfffffff810317812ULL, 0x000fe200078ee231ULL, 0x00000001440b7824ULL, 0x000fe200078e0205ULL,
0x0000003d4200720cULL, 0x080fe20003f26070ULL, 0x0000000844127824ULL, 0x000fe200078e00ffULL,
0x0000003d2400720cULL, 0x080fe20003f66070ULL, 0x0000010011107825ULL, 0x000fe200078e000eULL,
0x0000003d3e00720cULL, 0x000fc40003f06070ULL, 0xfffffff8120b7812ULL, 0x000fe200078ee20bULL,
0x0000000146047824ULL, 0x100fe200078e0205ULL, 0x000000100c267210ULL, 0x000fe20007f5e0ffULL,
0x0000000846137824ULL, 0x000fe200078e00ffULL, 0x0000c000323e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000140127824ULL, 0x040fe200078e0205ULL, 0x0000003d4000720cULL, 0x000fe20003f86070ULL,
0x0000000142337824ULL, 0x000fe200078e0230ULL, 0xfffffff813047812ULL, 0x000fe200078ee204ULL,
0x0000000124137824ULL, 0x000fe200078e0230ULL, 0x0000000712427812ULL, 0x000fe200078ec0ffULL,
0x000000010d277824ULL, 0x000fe200010e0611ULL, 0x0000003e41417211ULL, 0x000fe200078e20ffULL,
0x0000010013107825ULL, 0x000fe200078e000eULL, 0x0ffffff8423f7812ULL, 0x000fc400078ef805ULL,
0x0000001840427810ULL, 0x000fe20007ffe0ffULL, 0x0000010025127825ULL, 0x100fe200078e000eULL,
0x000000100c327210ULL, 0x000fe40007f5e0ffULL, 0x0000001c40407810ULL, 0x000fe20007ffe0ffULL,
0x0000010033247825ULL, 0x000fe200078e000eULL, 0x000000120c107210ULL, 0x000fc60007fbe0ffULL,
0x000000010d337824ULL, 0x040fe200010e0611ULL, 0x000000240c127210ULL, 0x000fe20007fde0ffULL,
0x000000010d117824ULL, 0x000fe200028e0613ULL, 0x0000003d4400720cULL, 0x080fe20003f46070ULL,
0x000000103f3f7824ULL, 0x000fe200078e023eULL, 0x0000003d4600720cULL, 0x080fe20003fa6070ULL,
0x000000010d137824ULL, 0x000fe400030e0625ULL, 0x0000000144257824ULL, 0x100fe200078e0230ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000263f7faeULL, 0x0003e2000e101c46ULL,
0x0000000146437824ULL, 0x000fe200078e0230ULL, 0x0000003d4200720cULL, 0x080fe20003f86070ULL,
0x0000010025247825ULL, 0x000fe200078e000eULL, 0x0000000032417faeULL, 0x0005e2000d901c46ULL,
0x0000003d4000720cULL, 0x000fc40003f66070ULL, 0x00000001423d7824ULL, 0x000fe200078e0230ULL,
0x000000240c247210ULL, 0x000fe20007fde0ffULL, 0x0000001031317824ULL, 0x100fe400078e023eULL,
0x000000100b0b7824ULL, 0x000fe400078e023eULL, 0x0000010043267825ULL, 0x002fc800078e000eULL,
0x000000010d257824ULL, 0x000fe200030e0625ULL, 0x000000260c267210ULL, 0x000fe20007fde0ffULL,
0x000001003d327825ULL, 0x004fc800078e000eULL, 0x00000001403f7824ULL, 0x040fe400078e0230ULL,
0x00000001403d7824ULL, 0x000fe400078e0205ULL, 0x000000010d277824ULL, 0x000fe200030e0627ULL,
0x000000320c327210ULL, 0x000fe20007fde0ffULL, 0x0000000142307824ULL, 0x040fe400078e0205ULL,
0x0000000842417824ULL, 0x000fe400078e00ffULL, 0x0000000840407824ULL, 0x000fc400078e00ffULL,
0x000001003f0e7825ULL, 0x000fe200078e000eULL, 0xfffffff841417812ULL, 0x000fe400078ee230ULL,
0xfffffff840437812ULL, 0x000fe200078ee23dULL, 0x000000010d337824ULL, 0x000fe200030e0633ULL,
0x0000000e0c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000103c3d7824ULL, 0x100fe400078e023eULL,
0x00000010043f7824ULL, 0x100fe400078e023eULL, 0x0000001041417824ULL, 0x100fe200078e023eULL,
0x00000000103d7faeULL, 0x0003e2000c101c46ULL, 0x0000001043437824ULL, 0x000fc400078e023eULL,
0x000000010d0d7824ULL, 0x000fe200030e060fULL, 0x0000000012317faeULL, 0x0003e8000c901c46ULL,
0x00000000240b7faeULL, 0x0003e8000d101c46ULL, 0x00000000263f7faeULL, 0x0003e8000e901c46ULL,
0x0000000032417faeULL, 0x0003e8000e101c46ULL, 0x000000000c437faeULL, 0x0003e2000d901c46ULL,
0x000005b000007947ULL, 0x000fea0003800000ULL, 0x00002000070e7824ULL, 0x040fe200078e00ffULL,
0x00000007073c7819ULL, 0x000fe200000006ffULL, 0x00000010050b7824ULL, 0x040fe200078e00ffULL,
0x0000000405117811ULL, 0x000fc400078fe8ffULL, 0x000020000e0f7812ULL, 0x000fe400078ec0ffULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000811277824ULL, 0x000fe200078e00ffULL,
0x0000000805137811ULL, 0x000fe200078fe8ffULL, 0x00004000040e7824ULL, 0x000fe200078e020fULL,
0x000000800b3c7812ULL, 0x000fe200078ef83cULL, 0x0000000111047824ULL, 0x100fe200078e0205ULL,
0x0000001405317811ULL, 0x000fe200078fe8ffULL, 0x00000001130b7824ULL, 0x100fe200078e0205ULL,
0x0000000c05257811ULL, 0x000fe200078fe8ffULL, 0x0000000813407824ULL, 0x000fe200078e00ffULL,
0xfffffff8273e7812ULL, 0x000fe200078ee204ULL, 0x0000000831467824ULL, 0x000fe200078e00ffULL,
0x0000001005277811ULL, 0x000fe200078fe8ffULL, 0x00000001250f7824ULL, 0x000fe200078e0205ULL,
0xfffffff840407812ULL, 0x000fe200078ee20bULL, 0x00000001310b7824ULL, 0x100fe200078e0205ULL,
0x0000001805337811ULL, 0x000fe200078fe8ffULL, 0x0000000825427824ULL, 0x000fe200078e00ffULL,
0x0000c0000e4b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000127047824ULL, 0x040fe200078e0205ULL,
0xfffffff846467812ULL, 0x000fe200078ee20bULL, 0x00000008273d7824ULL, 0x000fe200078e00ffULL,
0x0000001c050b7811ULL, 0x000fe200078fe8ffULL, 0x0000000833487824ULL, 0x040fe200078e00ffULL,
0xfffffff842427812ULL, 0x000fe200078ee20fULL, 0x00000001330f7824ULL, 0x100fe200078e0205ULL,
0xfffffff83d447812ULL, 0x000fe200078ee204ULL, 0x000000010b107824ULL, 0x000fe200078e0205ULL,
0x0000000505047211ULL, 0x000fe200078fe8ffULL, 0x000000080b3d7824ULL, 0x000fe200078e00ffULL,
0xfffffff848487812ULL, 0x000fe200078ee20fULL, 0x0000000111117824ULL, 0x100fe200078e0230ULL,
0x00000030050f7211ULL, 0x080fe200078fe8ffULL, 0x0000000113137824ULL, 0x000fe200078e0230ULL,
0xfffffff83d4a7812ULL, 0x000fe200078ee210ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000704047812ULL, 0x000fe200078ec0ffULL, 0x0000000125257824ULL, 0x000fe200078e0230ULL,
0x0000003033337210ULL, 0x000fe20007ffe0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e003cULL,
0x0ffffff804047812ULL, 0x000fc600078ef805ULL, 0x0000010011107825ULL, 0x000fe200078e003cULL,
0x0000000e0c0e7210ULL, 0x000fc60007f1e0ffULL, 0x0000000127277824ULL, 0x000fe200078e0230ULL,
0x000000100c107210ULL, 0x000fe20007f3e0ffULL, 0x0000010013127825ULL, 0x000fc800078e003cULL,
0x0000000131317824ULL, 0x000fe200078e0230ULL, 0x000000120c127210ULL, 0x000fe20007f5e0ffULL,
0x0000010025247825ULL, 0x000fc800078e003cULL, 0x000000010b0b7824ULL, 0x000fe200078e0230ULL,
0x000000240c247210ULL, 0x000fe20007f7e0ffULL, 0x0000010027267825ULL, 0x000fc800078e003cULL,
0x0000010031307825ULL, 0x000fc800078e003cULL, 0x0000010033327825ULL, 0x000fc800078e003cULL,
0x000001000b3c7825ULL, 0x000fc800078e003cULL, 0x000000010d0f7824ULL, 0x040fe200000e060fULL,
0x000000260c267210ULL, 0x040fe20007f1e0ffULL, 0x000000010d117824ULL, 0x040fe200008e0611ULL,
0x000000300c307210ULL, 0x000fe20007f3e0ffULL, 0x00000010040b7824ULL, 0x000fe400078e024bULL,
0x000000010d137824ULL, 0x040fe200010e0613ULL, 0x000000320c327210ULL, 0x000fe20007f5e0ffULL,
0x000000103e3f7824ULL, 0x000fe200078e024bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0b7faeULL, 0x0003e2000b901c46ULL, 0x000000010d257824ULL, 0x000fe200018e0625ULL,
0x0000003c0c0c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001040417824ULL, 0x100fe200078e024bULL,
0x00000000103f7faeULL, 0x0003e2000b901c46ULL, 0x0000001042437824ULL, 0x000fc400078e024bULL,
0x0000001044457824ULL, 0x000fe200078e024bULL, 0x0000000012417faeULL, 0x0003e2000b901c46ULL,
0x000000010d277824ULL, 0x040fe400000e0627ULL, 0x0000001046477824ULL, 0x000fe200078e024bULL,
0x0000000024437faeULL, 0x0003e2000b901c46ULL, 0x000000010d317824ULL, 0x040fe400008e0631ULL,
0x0000001048497824ULL, 0x000fe200078e024bULL, 0x0000000026457faeULL, 0x0003e2000b901c46ULL,
0x000000010d337824ULL, 0x000fc400010e0633ULL, 0x000000104a4b7824ULL, 0x000fe200078e024bULL,
0x0000000030477faeULL, 0x0003e2000b901c46ULL, 0x000000010d0d7824ULL, 0x000fc600018e063dULL,
0x0000000032497faeULL, 0x0003e8000b901c46ULL, 0x000000000c4b7faeULL, 0x0003e4000b901c46ULL,
0x0000000308047812ULL, 0x000fe200078ec0ffULL, 0xffffffffff0f7424ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000030400780cULL, 0x000fc80003f05270ULL,
0x000000016f0b7807ULL, 0x000fca0004000000ULL, 0x000000010b087824ULL, 0x000fca00078e0208ULL,
0x000000710800720cULL, 0x000fda0003f06070ULL, 0x0000000400118802ULL, 0x000fe20000000f00ULL,
0x0000000167108824ULL, 0x000fc800078e0208ULL, 0x0000660010108625ULL, 0x000fca00078e0011ULL,
0x00000006100f8981ULL, 0x000322000c1e1900ULL, 0xffffffe06a0d7812ULL, 0x040fe400078ec0ffULL,
0x000000106a047812ULL, 0x040fe400078ec0ffULL, 0x000000086a0b7812ULL, 0x000fc800078ec0ffULL,
0x0000000d0b0d7210ULL, 0x000fe20007ffe004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x013608000d247f8cULL, 0x0022a4000c80043fULL, 0x0000000000107805ULL, 0x000fc40000015200ULL,
0x01360c000d0b7984ULL, 0x000ee40000000800ULL, 0x800000000bff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x00000012100b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000113127824ULL, 0x000fe200000e0e11ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011412ULL,
0x0000000b04047211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e0612ULL,
0x0000000204047819ULL, 0x000fc8000000120bULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01360c000d0b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001005697824ULL, 0x000fe200078e00ffULL, 0x00000001ff6e7819ULL, 0x000fe20000011605ULL,
0xffffffffff737424ULL, 0x000fc600078e00ffULL, 0x0000007069697812ULL, 0x000fe400078ec0ffULL,
0x0000000c6e6e7812ULL, 0x000fc600078ec0ffULL, 0x000000806b0b7824ULL, 0x000fc800078e0269ULL,
0x000000010b0b7824ULL, 0x000fca00078e026eULL, 0x013000000b137984ULL, 0x000ea80000000800ULL,
0x013200000b0e7984ULL, 0x0006620000000800ULL, 0x0000000a1300720bULL, 0x004fe20003f1d000ULL,
0x00010d227f007947ULL, 0x000fd8000b800000ULL, 0x00000000000b7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0b257812ULL, 0x000fe2000782c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff047224ULL, 0x000fe400078e000aULL,
0x0000001fff767424ULL, 0x000fc400078e00ffULL, 0xffffffffff757424ULL, 0x000fcc00078e00ffULL,
0x0000043000009947ULL, 0x000fea0003800000ULL, 0x000000076b00720cULL, 0x000fe40003f25270ULL,
0x0000000a1300720bULL, 0x000fe20003f54000ULL, 0x00010cb27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x000fc400010e0100ULL, 0x00000080070b9824ULL, 0x000fe200078e0269ULL,
0x0000000a13047209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x000099100c107816ULL, 0x000fe200000000ffULL, 0x000000016e0b9824ULL, 0x000fca00078e020bULL,
0x013400040b009388ULL, 0x0005e20000000800ULL, 0x000000ff1000720cULL, 0x000fda0003f25270ULL,
0x0000030000009947ULL, 0x000fea0003800000ULL, 0x0000000a040a7221ULL, 0x004fe20000010100ULL,
0x000000ff0cff7812ULL, 0x000fe2000782c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fcc0000410000ULL, 0x0000000a000a7308ULL, 0x000ea40000000800ULL,
0x0000000a09097220ULL, 0x004fe40000410000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000002ff0b7819ULL, 0x000fe20000011605ULL, 0x00010be27f007947ULL, 0x000fea000b800000ULL,
0x00001f0b0a0b7589ULL, 0x0004e400000e0000ULL, 0x0000000b2c2c7220ULL, 0x08cfe20000410000ULL,
0x0000000b2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000b28287220ULL, 0x080fe20000410000ULL,
0x0000000b29297220ULL, 0x080fe20000410000ULL, 0x0000000b20207220ULL, 0x080fe20000410000ULL,
0x0000000b21217220ULL, 0x080fe20000410000ULL, 0x0000000b14147220ULL, 0x080fe20000410000ULL,
0x0000000b15157220ULL, 0x080fe20000410000ULL, 0x0000000b18187220ULL, 0x080fe20000410000ULL,
0x0000000b19197220ULL, 0x080fe20000410000ULL, 0x0000000b34347220ULL, 0x080fe20000410000ULL,
0x0000000b35357220ULL, 0x080fe20000410000ULL, 0x0000000b38387220ULL, 0x080fe20000410000ULL,
0x0000000b39397220ULL, 0x080fe20000410000ULL, 0x0000000b1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000b1d1d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000cff7812ULL, 0x000fda000782c0ffULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000008050b7811ULL, 0x000fe200078ff0ffULL, 0x00010ac27f007947ULL, 0x000fea000b800000ULL,
0x00001f0b0a0b7589ULL, 0x0004e400000e0000ULL, 0x0000000b2e2e7220ULL, 0x08cfe20000410000ULL,
0x0000000b2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000b2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000b2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000b22227220ULL, 0x080fe20000410000ULL,
0x0000000b23237220ULL, 0x080fe20000410000ULL, 0x0000000b16167220ULL, 0x080fe20000410000ULL,
0x0000000b17177220ULL, 0x080fe20000410000ULL, 0x0000000b1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000b1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000b36367220ULL, 0x080fe20000410000ULL,
0x0000000b37377220ULL, 0x080fe20000410000ULL, 0x0000000b3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000b3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000b1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000b1f1f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff25ff7812ULL, 0x000fda000782600cULL, 0x8000000413131221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b13131820ULL, 0x000fc80000410000ULL,
0x0000001300031308ULL, 0x000ea40000000800ULL, 0x000000030e0e1220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x000000090e0e7221ULL, 0x002fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff097819ULL, 0x000fe40000011605ULL, 0x00005410000a7816ULL, 0x000fe20000000000ULL,
0x000108f27f007947ULL, 0x000fea000b800000ULL, 0x00001f090a027589ULL, 0x0002a400000e0000ULL,
0x00000008090b7810ULL, 0x000fe20007ffe0ffULL, 0x000109227f007947ULL, 0x000fea000b800000ULL,
0x00001f0b0a007589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010090b7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200078e000aULL,
0x000033e000117802ULL, 0x000fc40000000f00ULL, 0x000112e000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018090b7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200078e000aULL, 0x0000343000117802ULL, 0x000fc40000000f00ULL,
0x0001129000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000207597824ULL, 0x000fe200078e00ffULL, 0x00000007050b7812ULL, 0x04cfe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000805107812ULL, 0x000fc400078ec0ffULL,
0x00000004590c7812ULL, 0x000fe400078ec0ffULL, 0x000000080b0a7812ULL, 0x002fe400078ef805ULL,
0x0000000c05097211ULL, 0x000fc600078fe0ffULL, 0x000000080a657824ULL, 0x040fe400078e00ffULL,
0x000000010a627824ULL, 0x000fca00078e0209ULL, 0xfffffff865657812ULL, 0x000fca00078ee262ULL,
0x0000001065657824ULL, 0x000fc800078e00ffULL, 0x000008006b487824ULL, 0x000fca00078e0265ULL,
0x00000004ff127819ULL, 0x000fe20000011605ULL, 0x009000004848783bULL, 0x000e620000000200ULL,
0x0000000b100c7212ULL, 0x040fe200078efcffULL, 0x000059000f0f7a24ULL, 0x010fe200078e02ffULL,
0x00000001ff097819ULL, 0x000fe40000011607ULL, 0x0000001010107812ULL, 0x000fe200078efe0bULL,
0x0000000112117824ULL, 0x000fe200078e020cULL, 0xfffffff859597812ULL, 0x000fe200078ec0ffULL,
0x00000004090b7824ULL, 0x000fe200078e0212ULL, 0x0000001005607211ULL, 0x000fe200078fe0ffULL,
0x0000000209127824ULL, 0x000fe200078e0268ULL, 0x00000002115b7810ULL, 0x040fe20007ffe0ffULL,
0x000000080c247824ULL, 0x040fe200078e00ffULL, 0x00000004115a7810ULL, 0x040fe20007ffe0ffULL,
0x000000080c137824ULL, 0x040fe200078e00ffULL, 0x00000006115d7810ULL, 0x000fe20007ffe0ffULL,
0x000000080c5c7824ULL, 0x000fe200078e00ffULL, 0x000000020b0b7810ULL, 0x000fe20007ffe00aULL,
0x00002000120c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8245b7812ULL, 0x000fe200078ee25bULL,
0x000000080a127824ULL, 0x000fe200078e00ffULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee211ULL,
0x0000000810117824ULL, 0x000fe200078e00ffULL, 0x0000b0000c0a7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8135a7812ULL, 0x000fe400078ee25aULL, 0xfffffff8245d7812ULL, 0x000fe200078ee25dULL,
0x000000105b547824ULL, 0x100fe200078e020aULL, 0xfffffff8120b7812ULL, 0x000fe200078ee20bULL,
0x000000105a507824ULL, 0x100fe200078e020aULL, 0x00000002605f7810ULL, 0x000fe20007ffe0ffULL,
0x000000105c447824ULL, 0x100fe200078e020aULL, 0x000000040b587819ULL, 0x000fe200000006ffULL,
0x000000105d4c7824ULL, 0x000fe200078e020aULL, 0x000000005454783bULL, 0x000ea20000004200ULL,
0x0000000810127824ULL, 0x000fe200078e00ffULL, 0x00000004605e7810ULL, 0x000fe20007ffe0ffULL,
0x00000008100b7824ULL, 0x000fe200078e00ffULL, 0x000000005050783bULL, 0x000ee20000004200ULL,
0x0000000660617810ULL, 0x000fe20007ffe0ffULL, 0x000008006b247824ULL, 0x000fe200078e0258ULL,
0xfffffff8125f7812ULL, 0x040fe200078ee25fULL, 0x000000004444783bULL, 0x000fe20000004200ULL,
0xfffffff8115e7812ULL, 0x000fe200078ee25eULL, 0x0000000248480232ULL, 0x082fe20000000000ULL,
0xfffffff80b607812ULL, 0x000fe200078ee260ULL, 0x000000004c4c783bULL, 0x000fe20000004200ULL,
0xfffffff812617812ULL, 0x000fe200078ee261ULL, 0x000000105f107824ULL, 0x100fe200078e020aULL,
0x000000024a4a0232ULL, 0x000fe20000000000ULL, 0x009000002424783bULL, 0x000e620000000200ULL,
0x000000105e307824ULL, 0x100fe200078e020aULL, 0x0000000049490232ULL, 0x080fe20000000000ULL,
0x00000010603c7824ULL, 0x100fe200078e020aULL, 0x000000001010783bULL, 0x000e620000004200ULL,
0x0000001061407824ULL, 0x000fe200078e020aULL, 0x000000004b4b0232ULL, 0x000fe20000000000ULL,
0x00000008060a7824ULL, 0x000fe200078e0209ULL, 0x000000003030783bULL, 0x000e680000004200ULL,
0x000000003c3c783bULL, 0x000e680000004200ULL, 0x000000004040783bULL, 0x000e620000004200ULL,
0x000000544820723cULL, 0x044f700000001820ULL, 0x000000564814723cULL, 0x040f700000001814ULL,
0x000000504818723cULL, 0x008f620000001818ULL, 0x0000000224240232ULL, 0x002fc40000000000ULL,
0x0000000226260232ULL, 0x000fe40000000000ULL, 0x0000000025250232ULL, 0x080fe40000000000ULL,
0x0000000027270232ULL, 0x000fe20000000000ULL, 0x000000524834723cULL, 0x040f700000001834ULL,
0x00000044482c723cULL, 0x040f70000000182cULL, 0x000000464828723cULL, 0x040f700000001828ULL,
0x0000004c4838723cULL, 0x040f700000001838ULL, 0x0000004e481c723cULL, 0x000f70000000181cULL,
0x000000102420723cULL, 0x060b700000001820ULL, 0x000000122414723cULL, 0x040b700000001814ULL,
0x000000302418723cULL, 0x040b700000001818ULL, 0x000000322434723cULL, 0x040b700000001834ULL,
0x0000003c242c723cULL, 0x040b70000000182cULL, 0x0000003e2428723cULL, 0x040b700000001828ULL,
0x000000402438723cULL, 0x040b700000001838ULL, 0x000000422424723cULL, 0x000b62000000181cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x00000001060b7810ULL, 0x000fe20007ffe0ffULL,
0x0136880059ff7f8cULL, 0x0003e2000c80043fULL, 0x000000800a427811ULL, 0x020fe200078e28ffULL,
0x000000400f0a7824ULL, 0x000fe200078e00ffULL, 0x000000640b00720cULL, 0x000fe20003f06070ULL,
0x00000100ff117424ULL, 0x000fe200078e00ffULL, 0x00000020420f7812ULL, 0x000fc600078ec0ffULL,
0x000064000a0a7625ULL, 0x000fc800078e0011ULL, 0x00000001663c7824ULL, 0x000fe200078e020fULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000042630f7217ULL, 0x002fe20007800000ULL, 0x0000008007307824ULL, 0x040fe200078e00ffULL,
0x00000003ff3f7819ULL, 0x100fe20000011605ULL, 0x0000200007107824ULL, 0x000fe400078e00ffULL,
0x000000010f427824ULL, 0x000fe200078e0a42ULL, 0x000000043f117810ULL, 0x040fe20007ffe0ffULL,
0x000000013f137824ULL, 0x000fe200078e023cULL, 0x0000008069307812ULL, 0x000fe200078ef830ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x0000002042427817ULL, 0x000fe20003800000ULL,
0x0000000111417824ULL, 0x000fe200078e0205ULL, 0x000000083f1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000811127824ULL, 0x000fe200078e00ffULL, 0x0000200010107812ULL, 0x000fc400078ec0ffULL,
0x000000421100720cULL, 0x000fe20003f86070ULL, 0x000000011f0f7824ULL, 0x000fe200078e0205ULL,
0x0000003c11117210ULL, 0x000fe20007ffe0ffULL, 0x000000081f1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff812417812ULL, 0x000fe200078ee241ULL, 0x0000010013127825ULL, 0x000fe200078e0030ULL,
0x000000143f437810ULL, 0x040fe40007ffe0ffULL, 0x0000000c3f1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000400009407824ULL, 0x000fe200078e0210ULL, 0x000000103f457810ULL, 0x000fe20007ffe0ffULL,
0x0000010011107825ULL, 0x000fe200078e0030ULL, 0x000000120a327210ULL, 0x000fc40007f1e0ffULL,
0x000000421f00720cULL, 0x000fe20003f66070ULL, 0x0000000143097824ULL, 0x040fe200078e0205ULL,
0xfffffff81c0f7812ULL, 0x000fe200078ee20fULL, 0x00000008431e7824ULL, 0x000fe200078e00ffULL,
0x000000100a107210ULL, 0x000fe20007f3e0ffULL, 0x000000011f1f7824ULL, 0x000fe200078e023cULL,
0x000000421d00720cULL, 0x080fe20003f46070ULL, 0x000000013f127824ULL, 0x000fe200078e0205ULL,
0xfffffff81e097812ULL, 0x000fe200078ee209ULL, 0x000000011d3e7824ULL, 0x100fe200078e0205ULL,
0x000000423f00720cULL, 0x000fe20003fa6070ULL, 0x000000081d337824ULL, 0x000fe200078e00ffULL,
0x0000000712447812ULL, 0x000fe200078ec0ffULL, 0x00000001453d7824ULL, 0x040fe200078e0205ULL,
0x0000b00040407810ULL, 0x000fe20007ffe0ffULL, 0x00000008451c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8333e7812ULL, 0x000fe200078ee23eULL, 0x000000011d1d7824ULL, 0x000fe200078e023cULL,
0x000000183f477810ULL, 0x000fe20007ffe0ffULL, 0x000001001f1e7825ULL, 0x000fe200078e0030ULL,
0xfffffff81c3d7812ULL, 0x000fc400078ee23dULL, 0x0000001c3f497810ULL, 0x000fe20007ffe0ffULL,
0x000000010b337824ULL, 0x040fe200000e0613ULL, 0x0000001e0a1e7210ULL, 0x000fe20007f1e0ffULL,
0x000000010b117824ULL, 0x000fe200008e0611ULL, 0x000000424500720cULL, 0x040fe20003f26070ULL,
0x0000000145137824ULL, 0x000fe200078e023cULL, 0x0ffffff844457812ULL, 0x000fe200078ef805ULL,
0x000001001d1c7825ULL, 0x000fc800078e0030ULL, 0x0000010013127825ULL, 0x000fe200078e0030ULL,
0x0000001c0a1c7210ULL, 0x000fc60007fde0ffULL, 0x000000010b1f7824ULL, 0x000fe200000e061fULL,
0x000000424300720cULL, 0x000fe20003f06070ULL, 0x0000001045457824ULL, 0x000fe400078e0240ULL,
0x0000000143437824ULL, 0x000fe400078e023cULL, 0x000000010b1d7824ULL, 0x000fe200030e061dULL,
0x000000120a127210ULL, 0x000fe20007fde0ffULL, 0x0000001041417824ULL, 0x000fe200078e0240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000032457faeULL, 0x0003e2000e901c46ULL,
0x00000001473f7824ULL, 0x040fe200078e023cULL, 0x000000424700720cULL, 0x080fe20003fa6070ULL,
0x000000010b137824ULL, 0x000fe200030e0613ULL, 0x0000000010417faeULL, 0x0005e2000e101c46ULL,
0x000000424900720cULL, 0x040fe20003f86070ULL, 0x0000000849427824ULL, 0x000fc400078e00ffULL,
0x000000100f0f7824ULL, 0x100fe400078e0240ULL, 0x000000103d3d7824ULL, 0x000fe400078e0240ULL,
0x0000010043327825ULL, 0x002fe200078e0030ULL, 0x000000001e0f7faeULL, 0x0003e6000d901c46ULL,
0x0000000149437824ULL, 0x000fe200078e023cULL, 0x000000320a107210ULL, 0x004fe20007fde0ffULL,
0x00000001473c7824ULL, 0x000fc400078e0205ULL, 0x0000000847477824ULL, 0x000fe200078e00ffULL,
0x000000330b117210ULL, 0x000fe200037fe4ffULL, 0x000001003f327825ULL, 0x000fc600078e0030ULL,
0xfffffff847417812ULL, 0x000fe200078ee23cULL, 0x00000001493f7824ULL, 0x000fe200078e0205ULL,
0x000000320a327210ULL, 0x000fe20007fde0ffULL, 0x0000010043307825ULL, 0x000fc600078e0030ULL,
0xfffffff842437812ULL, 0x000fe200078ee23fULL, 0x000000010b337824ULL, 0x000fe200030e0633ULL,
0x000000300a0a7210ULL, 0x000fe20007fde0ffULL, 0x000000103e3f7824ULL, 0x100fe400078e0240ULL,
0x0000001009097824ULL, 0x100fe400078e0240ULL, 0x0000001041417824ULL, 0x100fe200078e0240ULL,
0x000000001c3f7faeULL, 0x0003e2000d101c46ULL, 0x0000001043437824ULL, 0x000fe400078e0240ULL,
0x000000010b0b7824ULL, 0x000fe200030e0631ULL, 0x00000000123d7faeULL, 0x0003e8000c901c46ULL,
0x0000000010097faeULL, 0x0003e8000c101c46ULL, 0x0000000032417faeULL, 0x0003e8000e901c46ULL,
0x000000000a437faeULL, 0x0003e2000e101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x00002000070f7824ULL, 0x002fe200078e00ffULL, 0x0000000c05117811ULL, 0x000fe200078fe8ffULL,
0x0000008007307824ULL, 0x000fe200078e00ffULL, 0x00000004053d7811ULL, 0x000fe200078fe8ffULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x000020000f107812ULL, 0x000fe200078ec0ffULL,
0x0000000111407824ULL, 0x100fe200078e0205ULL, 0x00000008053f7811ULL, 0x000fe200078fe8ffULL,
0x000000013d0f7824ULL, 0x100fe200078e0205ULL, 0x0000001005137811ULL, 0x000fe200078fe8ffULL,
0x0000400009127824ULL, 0x000fe200078e0210ULL, 0x0000000311097819ULL, 0x000fe200000006ffULL,
0x000000083d107824ULL, 0x000fe200078e00ffULL, 0x00000014051d7811ULL, 0x000fe200078fe8ffULL,
0x000000013f417824ULL, 0x000fe200078e0205ULL, 0xfffffff809407812ULL, 0x000fe200078ee240ULL,
0x000000083f1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8100f7812ULL, 0x000fe200078ee20fULL,
0x0000000113427824ULL, 0x000fe200078e0205ULL, 0x00000018051f7811ULL, 0x000fe200078fe8ffULL,
0x0000000813097824ULL, 0x000fe200078e00ffULL, 0xfffffff81c417812ULL, 0x000fe200078ee241ULL,
0x000000011d437824ULL, 0x100fe200078e0205ULL, 0x0000001c05457811ULL, 0x000fe200078fe8ffULL,
0x000000081d107824ULL, 0x000fe200078e00ffULL, 0xfffffff809427812ULL, 0x000fe200078ee242ULL,
0x000000011f097824ULL, 0x000fe200078e0205ULL, 0x0000008069307812ULL, 0x000fe200078ef830ULL,
0x000000081f1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff810437812ULL, 0x000fe200078ee243ULL,
0x000000013d3d7824ULL, 0x100fe200078e023cULL, 0x0000000505107211ULL, 0x000fe200078fe8ffULL,
0x000000013f3f7824ULL, 0x100fe200078e023cULL, 0x0000003c05337211ULL, 0x000fe200078fe8ffULL,
0x0000000111117824ULL, 0x100fe200078e023cULL, 0xfffffff81c097812ULL, 0x000fe200078ee209ULL,
0x00000001451c7824ULL, 0x140fe200078e0205ULL, 0x0000000710107812ULL, 0x000fe200078ec0ffULL,
0x00000008454b7824ULL, 0x000fe200078e00ffULL, 0x0000b00012467810ULL, 0x000fe20007ffe0ffULL,
0x0000000113137824ULL, 0x100fe200078e023cULL, 0x0ffffff810447812ULL, 0x000fe200078ef805ULL,
0x000000011d1d7824ULL, 0x000fe200078e023cULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee21cULL,
0x000000011f1f7824ULL, 0x100fe200078e023cULL, 0x0000004640477211ULL, 0x000fe200078e20ffULL,
0x0000000145457824ULL, 0x000fc400078e023cULL, 0x0000010033327825ULL, 0x000fc800078e0030ULL,
0x000001003d3c7825ULL, 0x000fe200078e0030ULL, 0x000000320a327210ULL, 0x000fc60007f1e0ffULL,
0x000001003f3e7825ULL, 0x000fe200078e0030ULL, 0x0000003c0a3c7210ULL, 0x000fc60007f3e0ffULL,
0x0000010011107825ULL, 0x000fe200078e0030ULL, 0x0000003e0a3e7210ULL, 0x000fc60007f5e0ffULL,
0x0000010013127825ULL, 0x000fe200078e0030ULL, 0x000000100a107210ULL, 0x000fc60007f7e0ffULL,
0x000001001d1c7825ULL, 0x000fc800078e0030ULL, 0x000001001f1e7825ULL, 0x000fc800078e0030ULL,
0x0000010045307825ULL, 0x000fc800078e0030ULL, 0x000000010b337824ULL, 0x040fe200000e0633ULL,
0x000000120a127210ULL, 0x040fe20007f1e0ffULL, 0x000000010b3d7824ULL, 0x040fe200008e063dULL,
0x0000001c0a1c7210ULL, 0x000fe20007f3e0ffULL, 0x0000001044457824ULL, 0x100fe400078e0246ULL,
0x000000010b3f7824ULL, 0x000fe200010e063fULL, 0x0000001e0a1e7210ULL, 0x040fe20007f5e0ffULL,
0x000000100f0f7824ULL, 0x100fe200078e0246ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032457faeULL, 0x0003e2000b901c46ULL, 0x000000010b117824ULL, 0x000fe200018e0611ULL,
0x000000300a0a7210ULL, 0x000fe20007f7e0ffULL, 0x0000001041417824ULL, 0x100fe200078e0246ULL,
0x000000003c0f7faeULL, 0x0003e2000b901c46ULL, 0x0000001042497824ULL, 0x000fc400078e0246ULL,
0x000000010b137824ULL, 0x000fe200000e0613ULL, 0x000000003e417faeULL, 0x0003e2000b901c46ULL,
0x0000001043437824ULL, 0x100fe400078e0246ULL, 0x000000010b1d7824ULL, 0x000fe200008e061dULL,
0x0000000010477faeULL, 0x0003e2000b901c46ULL, 0x0000001009097824ULL, 0x100fe400078e0246ULL,
0x000000010b1f7824ULL, 0x000fe200010e061fULL, 0x0000000012497faeULL, 0x0003e2000b901c46ULL,
0x000000104b4b7824ULL, 0x000fc400078e0246ULL, 0x000000010b0b7824ULL, 0x000fe200018e0631ULL,
0x000000001c437faeULL, 0x0003e8000b901c46ULL, 0x000000001e097faeULL, 0x0003e8000b901c46ULL,
0x000000000a4b7faeULL, 0x0003e4000b901c46ULL, 0x0000000308097812ULL, 0x002fe200078ec0ffULL,
0xffffffffff4d7424ULL, 0x000fc600078e00ffULL, 0x000000030900780cULL, 0x000fc80003f05270ULL,
0x000000016f097807ULL, 0x000fca0004000000ULL, 0x0000000108087824ULL, 0x000fca00078e0209ULL,
0x000000710800720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00000001670a7824ULL, 0x000fe400078e0208ULL, 0x00000004ff0b7424ULL, 0x000fc800078e00ffULL,
0x000066000a0a7625ULL, 0x000fca00078e000bULL, 0x000000060a4d7981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x013628000d0a7f8cULL, 0x0022a4000c80043fULL, 0x0000000000107805ULL, 0x000fc40000015200ULL,
0xffffffe06a097812ULL, 0x040fe400078ec0ffULL, 0x000000106a127812ULL, 0x040fe400078ec0ffULL,
0x000000086a0d7812ULL, 0x002fc800078ec0ffULL, 0x000000090d097210ULL, 0x000fca0007ffe012ULL,
0x01362c00090d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x006fe4000780480bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011413ULL,
0x000000120d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x000000020d0d7819ULL, 0x000fc80000001212ULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01362c00090d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020070a7824ULL, 0x000fca00078e00ffULL, 0xffffff800a0a7812ULL, 0x000fc800078ec0ffULL,
0x00000080690b7810ULL, 0x000fc80007ffe00aULL, 0x0000000b6e0b7210ULL, 0x000fca0007ffe0ffULL,
0x013000000b0d7984ULL, 0x000e680000000800ULL, 0x013200000b4c7984ULL, 0x0004e20000000800ULL,
0x000000040d00720bULL, 0x002fe20003f1d000ULL, 0x0000f1f27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0b137812ULL, 0x000fe2000782c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff0a7224ULL, 0x000fd400078e0004ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x000000016b0a7810ULL, 0x000fe40007ffe0ffULL, 0x000000040d00720bULL, 0x000fe40003f34000ULL,
0x000000070a00720cULL, 0x000fe20003f05270ULL, 0x0000f1927f007947ULL, 0x000fd4000b800000ULL,
0x00000000000a7806ULL, 0x000fc400008e0100ULL, 0x00000080070f8824ULL, 0x000fe200078e0269ULL,
0x000000040d0b8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x000000016e108824ULL, 0x000fe200078e020fULL, 0x000099100a0f7816ULL, 0x000fc800000000ffULL,
0x0134000b10008388ULL, 0x0003e20000000800ULL, 0x000000ff0f00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000040d0b7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0aff7812ULL, 0x000fc6000780c0ffULL,
0x000000040b0b7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL,
0x0000000b000f7308ULL, 0x000e640000000800ULL, 0x0000000f0e0e7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0b7819ULL, 0x000fe20000011605ULL,
0x0000f0b27f007947ULL, 0x000fea000b800000ULL, 0x00001f0b0f0b7589ULL, 0x0002a400000e0000ULL,
0x0000000b2c2c7220ULL, 0x084fe20000410000ULL, 0x0000000b2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000b28287220ULL, 0x080fe20000410000ULL, 0x0000000b29297220ULL, 0x080fe20000410000ULL,
0x0000000b20207220ULL, 0x080fe20000410000ULL, 0x0000000b21217220ULL, 0x080fe20000410000ULL,
0x0000000b14147220ULL, 0x080fe20000410000ULL, 0x0000000b15157220ULL, 0x080fe20000410000ULL,
0x0000000b18187220ULL, 0x080fe20000410000ULL, 0x0000000b19197220ULL, 0x080fe20000410000ULL,
0x0000000b34347220ULL, 0x080fe20000410000ULL, 0x0000000b35357220ULL, 0x080fe20000410000ULL,
0x0000000b38387220ULL, 0x080fe20000410000ULL, 0x0000000b39397220ULL, 0x080fe20000410000ULL,
0x0000000b24247220ULL, 0x080fe20000410000ULL, 0x0000000b25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000aff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008050b7811ULL, 0x000fe200078ff0ffULL,
0x0000ef927f007947ULL, 0x000fea000b800000ULL, 0x00001f0b0f0b7589ULL, 0x00046400000e0000ULL,
0x0000000b2e2e7220ULL, 0x086fe20000410000ULL, 0x0000000b2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000b2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000b2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000b22227220ULL, 0x080fe20000410000ULL, 0x0000000b23237220ULL, 0x080fe20000410000ULL,
0x0000000b16167220ULL, 0x080fe20000410000ULL, 0x0000000b17177220ULL, 0x080fe20000410000ULL,
0x0000000b1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000b1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000b36367220ULL, 0x080fe20000410000ULL, 0x0000000b37377220ULL, 0x080fe20000410000ULL,
0x0000000b3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000b3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000b26267220ULL, 0x080fe20000410000ULL, 0x0000000b27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff13ff7812ULL, 0x000fe4000780600aULL,
0x000000040d0a7209ULL, 0x000fd60007810000ULL, 0x8000000a0d0d0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL, 0x0000000d00030308ULL, 0x000e640000000800ULL,
0x000000034c4c0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x0000000e4c4c7221ULL, 0x008fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000003ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011605ULL,
0x0000541000047816ULL, 0x000fe20000000000ULL, 0x0000edc27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d04027589ULL, 0x0002a400000e0000ULL, 0x000000080d0b7810ULL, 0x000fe20007ffe0ffULL,
0x0000edf27f007947ULL, 0x000fea000b800000ULL, 0x00001f0b04007589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100d0b7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200078e0004ULL, 0x000050d000117802ULL, 0x000fc40000000f00ULL,
0x0000f5f000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180d0b7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200078e0004ULL,
0x0000512000117802ULL, 0x000fc40000000f00ULL, 0x0000f5a000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000020007047824ULL, 0x00afe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe80003800000ULL, 0xfffff80004047812ULL, 0x000fca00078ec0ffULL,
0x00000001654e7824ULL, 0x000fc800078e0204ULL, 0x0000c0000c0b7810ULL, 0x004fe20007ffe0ffULL,
0x009800004e40783bULL, 0x000e620000000200ULL, 0x0000980004047810ULL, 0x000fe20007ffe058ULL,
0x000059004d4d7a24ULL, 0x010fe200078e02ffULL, 0x0000000b5f3c7211ULL, 0x000fe200078e20ffULL,
0x000000105c547824ULL, 0x100fe400078e020bULL, 0x000000105b507824ULL, 0x100fe200078e020bULL,
0x000000000410783bULL, 0x0004e20000000200ULL, 0x000000105a487824ULL, 0x100fe400078e020bULL,
0x000000105d447824ULL, 0x100fe200078e020bULL, 0x000000005454783bULL, 0x000ee20000004200ULL,
0x00000010600c7824ULL, 0x000fc400078e020bULL, 0x000000105e1c7824ULL, 0x100fe200078e020bULL,
0x000000005050783bULL, 0x000ee20000004200ULL, 0x0000001061307824ULL, 0x000fe200078e020bULL,
0x00000001ff047819ULL, 0x004fe40000011607ULL, 0x000000004848783bULL, 0x000ea80000004200ULL,
0x000000004444783bULL, 0x000ea80000004200ULL, 0x000000000c0c783bULL, 0x000ea80000004200ULL,
0x000000003c3c783bULL, 0x000ea80000004200ULL, 0x000000001c1c783bULL, 0x000ea80000004200ULL,
0x000000003030783bULL, 0x000ea20000004200ULL, 0x0000000240400232ULL, 0x002fc40000000000ULL,
0x0000000242420232ULL, 0x000fe40000000000ULL, 0x0000000041410232ULL, 0x080fe40000000000ULL,
0x0000000043430232ULL, 0x000fe40000000000ULL, 0x0000000210100232ULL, 0x088fe40000000000ULL,
0x0000000212120232ULL, 0x000fe40000000000ULL, 0x0000000011110232ULL, 0x080fe20000000000ULL,
0x00000054402c723cULL, 0x000f62000000182cULL, 0x0000000013130232ULL, 0x000fce0000000000ULL,
0x000000564028723cULL, 0x040f700000001828ULL, 0x000000504020723cULL, 0x040f700000001820ULL,
0x000000484018723cULL, 0x044f700000001818ULL, 0x0000004a4034723cULL, 0x040f700000001834ULL,
0x000000444038723cULL, 0x040f700000001838ULL, 0x000000464024723cULL, 0x040f700000001824ULL,
0x000000524014723cULL, 0x000f700000001814ULL, 0x0000000c102c723cULL, 0x060f70000000182cULL,
0x0000000e1028723cULL, 0x040f700000001828ULL, 0x0000003c100c723cULL, 0x040f700000001820ULL,
0x0000001c1018723cULL, 0x040f700000001818ULL, 0x0000001e101c723cULL, 0x040f700000001834ULL,
0x000000301020723cULL, 0x040f700000001838ULL, 0x000000321024723cULL, 0x040f700000001824ULL,
0x0000003e1014723cULL, 0x000b6e0000001814ULL, 0x00000008063e7824ULL, 0x020fe200078e0204ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fcc0000008000ULL, 0x0000000106117810ULL, 0x000fe20007ffe0ffULL,
0x0136900059ff7f8cULL, 0x0003e2000c80043fULL, 0x000000c03e3e7811ULL, 0x000fe200078e28ffULL,
0x00000100ff137424ULL, 0x000fe200078e00ffULL, 0x000000641100720cULL, 0x000fe20003f06070ULL,
0x000000404d107824ULL, 0x000fe200078e00ffULL, 0x000000203e0b7812ULL, 0x000fc600078ec0ffULL,
0x0000640010107625ULL, 0x000fc800078e0013ULL, 0x00000001663a7824ULL, 0x000fe200078e020bULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff3f7819ULL, 0x102fe20000011605ULL, 0x0000008007367824ULL, 0x000fe200078e00ffULL,
0x0000003e630b7217ULL, 0x000fe20007800000ULL, 0x000000ffff377224ULL, 0x000fe200078e00ffULL,
0x000000043f137810ULL, 0x040fe40007ffe0ffULL, 0x0000000c3f337810ULL, 0x000fe20007ffe0ffULL,
0x000000010b3e7824ULL, 0x000fe200078e0a3eULL, 0x0000008069367812ULL, 0x000fe200078ef836ULL,
0x0000000113407824ULL, 0x100fe200078e0205ULL, 0x000000143f417810ULL, 0x000fe20007ffe0ffULL,
0x0000000813317824ULL, 0x000fe200078e00ffULL, 0x000000083f357810ULL, 0x000fe20007ffe0ffULL,
0x00000001330b7824ULL, 0x100fe200078e0205ULL, 0x0000000341397819ULL, 0x000fe200000006ffULL,
0x0000000833307824ULL, 0x000fe200078e00ffULL, 0xfffffff831407812ULL, 0x000fe200078ee240ULL,
0x000000013f317824ULL, 0x000fe200078e023aULL, 0x000000203e3e7817ULL, 0x000fe20003800000ULL,
0x00000001413c7824ULL, 0x000fe200078e0205ULL, 0xfffffff8300b7812ULL, 0x000fe200078ee20bULL,
0x0000010031307825ULL, 0x000fe200078e0036ULL, 0x000000103f457810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8393c7812ULL, 0x000fe200078ee23cULL, 0x00000001353b7824ULL, 0x140fe200078e0205ULL,
0x0000003010387210ULL, 0x000fe20007f1e0ffULL, 0x0000000835127824ULL, 0x040fe200078e00ffULL,
0x0000003e3500720cULL, 0x080fe20003f66070ULL, 0x000000013f307824ULL, 0x000fe200078e0205ULL,
0x0000003e1300720cULL, 0x080fe20003f86070ULL, 0x0000000111397824ULL, 0x000fe200000e0631ULL,
0x0000003e3300720cULL, 0x080fe20003f46070ULL, 0x0000200007317824ULL, 0x000fe200078e00ffULL,
0x0000000730427812ULL, 0x000fe200078ec0ffULL, 0x0000000135357824ULL, 0x100fe200078e023aULL,
0xfffffff8123b7812ULL, 0x000fe200078ee23bULL, 0x00000001453d7824ULL, 0x000fe200078e0205ULL,
0x0000200031437812ULL, 0x000fe200078ec0ffULL, 0x0000000845327824ULL, 0x000fe200078e00ffULL,
0x0000003e3f00720cULL, 0x000fe20003fa6070ULL, 0x0000000113137824ULL, 0x100fe200078e023aULL,
0x000000183f477810ULL, 0x000fe20007ffe0ffULL, 0x0000000133337824ULL, 0x000fe200078e023aULL,
0xfffffff8323d7812ULL, 0x000fe200078ee23dULL, 0x0000010035347825ULL, 0x000fe200078e0036ULL,
0x0000001c3f497810ULL, 0x000fc60007ffe0ffULL, 0x0000400004447824ULL, 0x000fe200078e0243ULL,
0x0ffffff842437812ULL, 0x000fe200078ef805ULL, 0x0000010013127825ULL, 0x100fe200078e0036ULL,
0x0000003410347210ULL, 0x000fe40007f1e0ffULL, 0x0000c00044427810ULL, 0x000fe20007ffe0ffULL,
0x0000010033327825ULL, 0x000fe200078e0036ULL, 0x0000001210127210ULL, 0x000fc60007f3e0ffULL,
0x0000000145317824ULL, 0x000fe200078e023aULL, 0x0000003210327210ULL, 0x000fe20007fde0ffULL,
0x0000000111357824ULL, 0x000fe200000e0635ULL, 0x0000003e4100720cULL, 0x000fe20003f06070ULL,
0x0000010031307825ULL, 0x000fc800078e0036ULL, 0x0000001043437824ULL, 0x000fe400078e0242ULL,
0x0000000141417824ULL, 0x000fe400078e023aULL, 0x0000000111137824ULL, 0x000fe200008e0613ULL,
0x0000003e4500720cULL, 0x000fe20003f26070ULL, 0x0000000111337824ULL, 0x000fe200030e0633ULL,
0x0000003010307210ULL, 0x000fe20007fde0ffULL, 0x0000001040457824ULL, 0x000fe200078e0242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038437faeULL, 0x0003e2000e901c46ULL,
0x00000001473f7824ULL, 0x040fe200078e023aULL, 0x0000003e4700720cULL, 0x080fe20003fa6070ULL,
0x0000000111317824ULL, 0x000fe200030e0631ULL, 0x0000000012457faeULL, 0x0005e2000e101c46ULL,
0x0000003e4900720cULL, 0x040fe20003f86070ULL, 0x00000001493e7824ULL, 0x000fc400078e0205ULL,
0x000000103b3b7824ULL, 0x100fe400078e0242ULL, 0x000000100b0b7824ULL, 0x000fe400078e0242ULL,
0x0000010041387825ULL, 0x002fe200078e0036ULL, 0x0000000349437819ULL, 0x040fe200000006ffULL,
0x00000000343b7faeULL, 0x0003e4000d901c46ULL, 0x0000000149417824ULL, 0x000fe200078e023aULL,
0x0000003810127210ULL, 0x004fe20007fde0ffULL, 0x00000001473a7824ULL, 0x000fe200078e0205ULL,
0xfffffff843437812ULL, 0x000fe200078ee23eULL, 0x0000000847477824ULL, 0x000fe200078e00ffULL,
0x00000000320b7faeULL, 0x0003e2000d101c46ULL, 0x0000000111137824ULL, 0x000fc400030e0639ULL,
0x000001003f387825ULL, 0x000fc800078e0036ULL, 0x0000010041367825ULL, 0x000fe200078e0036ULL,
0x0000003810387210ULL, 0x040fe40007fde0ffULL, 0xfffffff847417812ULL, 0x000fe200078ee23aULL,
0x000000103d3d7824ULL, 0x100fe400078e0242ULL, 0x0000000111397824ULL, 0x000fe200030e0639ULL,
0x0000003610107210ULL, 0x000fe20007fde0ffULL, 0x000000103c3f7824ULL, 0x100fe200078e0242ULL,
0x00000000303d7faeULL, 0x0003e2000c901c46ULL, 0x0000001041417824ULL, 0x000fc400078e0242ULL,
0x0000001043437824ULL, 0x000fe200078e0242ULL, 0x00000000123f7faeULL, 0x0003e2000c101c46ULL,
0x0000000111117824ULL, 0x000fc600030e0637ULL, 0x0000000038417faeULL, 0x0003e8000e901c46ULL,
0x0000000010437faeULL, 0x0003e2000e101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000001005317811ULL, 0x002fe200078fe8ffULL, 0x0000008007367824ULL, 0x000fe200078e00ffULL,
0x00000004053b7811ULL, 0x040fe400078fe8ffULL, 0x0000001405337811ULL, 0x000fe200078fe8ffULL,
0x0000000131427824ULL, 0x100fe200078e0205ULL, 0x00000008053d7811ULL, 0x000fe200078fe8ffULL,
0x0000000831137824ULL, 0x000fe200078e00ffULL, 0x0000000c05307811ULL, 0x000fe200078fe8ffULL,
0x000000013b3f7824ULL, 0x100fe200078e0205ULL, 0x0000001805357811ULL, 0x000fe200078fe8ffULL,
0x000000083b127824ULL, 0x000fe200078e00ffULL, 0xfffffff813427812ULL, 0x000fe200078ee242ULL,
0x00000001333e7824ULL, 0x000fe200078e0205ULL, 0x0000000d07137819ULL, 0x000fe200000006ffULL,
0x0000000833377824ULL, 0x000fe200078e00ffULL, 0xfffffff8123f7812ULL, 0x000fe200078ee23fULL,
0x000000013d407824ULL, 0x100fe200078e0205ULL, 0x0000001c05437811ULL, 0x000fe200078fe8ffULL,
0x000000083d0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8373e7812ULL, 0x000fe200078ee23eULL,
0x0000000130417824ULL, 0x140fe200078e0205ULL, 0x0000200013377812ULL, 0x000fe200078ec0ffULL,
0x0000000830127824ULL, 0x000fe200078e00ffULL, 0xfffffff80b407812ULL, 0x000fe200078ee240ULL,
0x00000001350b7824ULL, 0x000fe200078e0205ULL, 0x0000008069367812ULL, 0x000fe200078ef836ULL,
0x0000000835327824ULL, 0x000fe200078e00ffULL, 0xfffffff812417812ULL, 0x000fe200078ee241ULL,
0x0000000130137824ULL, 0x100fe200078e023aULL, 0x0000000505127211ULL, 0x040fe200078fe8ffULL,
0x0000400004307824ULL, 0x000fe200078e0237ULL, 0x0000003a05397211ULL, 0x000fe200078fe8ffULL,
0x000000013b3b7824ULL, 0x100fe200078e023aULL, 0xfffffff8320b7812ULL, 0x000fe200078ee20bULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x0000000712127812ULL, 0x000fe200078ec0ffULL,
0x000000013d3d7824ULL, 0x000fc400078e023aULL, 0x0000000143327824ULL, 0x140fe200078e0205ULL,
0x0ffffff812447812ULL, 0x000fe200078ef805ULL, 0x0000000843457824ULL, 0x000fe400078e00ffULL,
0x0000000131317824ULL, 0x100fe400078e023aULL, 0x0000000133337824ULL, 0x000fe200078e023aULL,
0xfffffff845467812ULL, 0x000fe200078ee232ULL, 0x0000000135357824ULL, 0x100fe200078e023aULL,
0x0000c00030457810ULL, 0x000fe20007ffe0ffULL, 0x0000000143437824ULL, 0x000fc400078e023aULL,
0x0000010039387825ULL, 0x000fc800078e0036ULL, 0x000001003b3a7825ULL, 0x000fe200078e0036ULL,
0x0000003810387210ULL, 0x000fc60007f1e0ffULL, 0x000001003d3c7825ULL, 0x100fe200078e0036ULL,
0x0000003a103a7210ULL, 0x040fe40007f3e0ffULL, 0x0000003911397210ULL, 0x000fe200007fe4ffULL,
0x0000010013127825ULL, 0x000fe200078e0036ULL, 0x0000003c103c7210ULL, 0x000fc60007f5e0ffULL,
0x0000010031307825ULL, 0x000fe200078e0036ULL, 0x0000001210127210ULL, 0x000fc60007f7e0ffULL,
0x0000010033327825ULL, 0x000fe200078e0036ULL, 0x0000003010307210ULL, 0x000fc60007f1e0ffULL,
0x0000010035347825ULL, 0x000fc800078e0036ULL, 0x0000010043367825ULL, 0x000fc800078e0036ULL,
0x00000001113b7824ULL, 0x040fe200008e063bULL, 0x0000003210327210ULL, 0x000fe20007f3e0ffULL,
0x0000001044437824ULL, 0x000fe400078e0245ULL, 0x00000001113d7824ULL, 0x000fe200010e063dULL,
0x0000003410347210ULL, 0x040fe20007f5e0ffULL, 0x000000103f3f7824ULL, 0x000fe200078e0245ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038437faeULL, 0x0003e2000b901c46ULL,
0x0000000111137824ULL, 0x000fe200018e0613ULL, 0x0000003610107210ULL, 0x000fe20007f7e0ffULL,
0x0000001040477824ULL, 0x100fe200078e0245ULL, 0x000000003a3f7faeULL, 0x0003e2000b901c46ULL,
0x0000001041417824ULL, 0x000fc400078e0245ULL, 0x0000001042497824ULL, 0x000fe200078e0245ULL,
0x000000003c477faeULL, 0x0003e2000b901c46ULL, 0x0000000111317824ULL, 0x040fe400000e0631ULL,
0x000000103e4b7824ULL, 0x000fe200078e0245ULL, 0x0000000012417faeULL, 0x0003e2000b901c46ULL,
0x0000000111337824ULL, 0x000fe400008e0633ULL, 0x000000100b0b7824ULL, 0x000fe200078e0245ULL,
0x0000000030497faeULL, 0x0003e2000b901c46ULL, 0x0000000111357824ULL, 0x000fc400010e0635ULL,
0x0000001046457824ULL, 0x000fe200078e0245ULL, 0x00000000324b7faeULL, 0x0003e2000b901c46ULL,
0x0000000111117824ULL, 0x000fc600018e0637ULL, 0x00000000340b7faeULL, 0x0003e8000b901c46ULL,
0x0000000010457faeULL, 0x0003e4000b901c46ULL, 0x00000003080b7812ULL, 0x002fe200078ec0ffULL,
0xffffffffff517424ULL, 0x000fc600078e00ffULL, 0x000000030b00780cULL, 0x000fc80003f05270ULL,
0x000000016f0b7807ULL, 0x000fca0004000000ULL, 0x0000000108087824ULL, 0x000fca00078e020bULL,
0x000000710800720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000167107824ULL, 0x000fe400078e0208ULL, 0x00000004ff117424ULL, 0x000fc800078e00ffULL,
0x0000660010107625ULL, 0x000fca00078e0011ULL, 0x0000000610517981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136480009107f8cULL, 0x0022a4000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0xffffffe06a097812ULL, 0x042fe400078ec0ffULL, 0x000000106a307812ULL, 0x040fe400078ec0ffULL,
0x000000086a0b7812ULL, 0x000fc800078ec0ffULL, 0x000000090b097210ULL, 0x000fca0007ffe030ULL,
0x01364c00090b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x006fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000307805ULL, 0x000fcc0000015200ULL, 0x0000003012307210ULL, 0x000fca0007f1e1ffULL,
0x0000000131317824ULL, 0x000fe200000e0e13ULL, 0x003d09003000780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403000780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011431ULL,
0x000000300b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff307224ULL, 0x000fca00000e0631ULL,
0x000000020b0b7819ULL, 0x000fc80000001230ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000132327810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01364c00090b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020070b7824ULL, 0x000fca00078e00ffULL, 0xffffff800b107812ULL, 0x000fc800078ec0ffULL,
0x00000100690b7810ULL, 0x000fca0007ffe010ULL, 0x000000016e0b7824ULL, 0x000fca00078e020bULL,
0x013000000b137984ULL, 0x000e680000000800ULL, 0x013200000b507984ULL, 0x0004e20000000800ULL,
0x0000000a1300720bULL, 0x002fe20003f1d000ULL, 0x0000d9527f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0b317812ULL, 0x000fe2000782c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x000000026b107810ULL, 0x000fe40007ffe0ffULL,
0x0000000a1300720bULL, 0x000fe40003f34000ULL, 0x000000071000720cULL, 0x000fe20003f05270ULL,
0x0000d9027f007947ULL, 0x000fd4000b800000ULL, 0x0000000000127806ULL, 0x000fc400008e0100ULL,
0x0000008007118824ULL, 0x000fe200078e0269ULL, 0x0000000a130b8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991012107816ULL, 0x000fe200000000ffULL,
0x000000016e308824ULL, 0x000fca00078e0211ULL, 0x0134000b30008388ULL, 0x0003e20000000800ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000a130b7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff12ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000a0b0b7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL, 0x0000000b00337308ULL, 0x000e640000000800ULL,
0x000000334c4c7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0b7819ULL, 0x000fe20000011605ULL, 0x0000d8227f007947ULL, 0x000fea000b800000ULL,
0x00001f0b330b7589ULL, 0x0002a400000e0000ULL, 0x0000000b2c2c7220ULL, 0x084fe20000410000ULL,
0x0000000b2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000b28287220ULL, 0x080fe20000410000ULL,
0x0000000b29297220ULL, 0x080fe20000410000ULL, 0x0000000b0c0c7220ULL, 0x080fe20000410000ULL,
0x0000000b0d0d7220ULL, 0x080fe20000410000ULL, 0x0000000b14147220ULL, 0x080fe20000410000ULL,
0x0000000b15157220ULL, 0x080fe20000410000ULL, 0x0000000b18187220ULL, 0x080fe20000410000ULL,
0x0000000b19197220ULL, 0x080fe20000410000ULL, 0x0000000b1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000b1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000b20207220ULL, 0x080fe20000410000ULL,
0x0000000b21217220ULL, 0x080fe20000410000ULL, 0x0000000b24247220ULL, 0x080fe20000410000ULL,
0x0000000b25257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0012ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008050b7811ULL, 0x000fe200078ff0ffULL, 0x0000d7027f007947ULL, 0x000fea000b800000ULL,
0x00001f0b330b7589ULL, 0x00046400000e0000ULL, 0x0000000b2e2e7220ULL, 0x086fe20000410000ULL,
0x0000000b2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000b2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000b2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000b0e0e7220ULL, 0x080fe20000410000ULL,
0x0000000b0f0f7220ULL, 0x080fe20000410000ULL, 0x0000000b16167220ULL, 0x080fe20000410000ULL,
0x0000000b17177220ULL, 0x080fe20000410000ULL, 0x0000000b1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000b1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000b1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000b1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000b22227220ULL, 0x080fe20000410000ULL,
0x0000000b23237220ULL, 0x080fe20000410000ULL, 0x0000000b26267220ULL, 0x080fe20000410000ULL,
0x0000000b27277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff31ff7812ULL, 0x000fe40007806012ULL, 0x0000000a130a7209ULL, 0x000fd60007810000ULL,
0x8000000a13130221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL,
0x0000001300030308ULL, 0x000e640000000800ULL, 0x0000000350500220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x0000004c50507221ULL, 0x008fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff137819ULL, 0x000fe40000011605ULL, 0x0000541000127816ULL, 0x000fe20000000000ULL,
0x0000d5327f007947ULL, 0x000fea000b800000ULL, 0x00001f1312027589ULL, 0x0002a400000e0000ULL,
0x00000008130b7810ULL, 0x000fe20007ffe0ffULL, 0x0000d5627f007947ULL, 0x000fea000b800000ULL,
0x00001f0b12007589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010130b7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200078e0012ULL,
0x00006b2000117802ULL, 0x000fc40000000f00ULL, 0x0000dba000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018130b7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200078e0012ULL, 0x00006b7000117802ULL, 0x000fc40000000f00ULL,
0x0000db5000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x0000000204527824ULL, 0x000fe200078e0268ULL,
0x0000000705107812ULL, 0x000fe200078ec0ffULL, 0x00a000004e44783bULL, 0x000ee20000000200ULL,
0x0000000262627810ULL, 0x000fe20007ffe0ffULL, 0x0000200052527824ULL, 0x000fe200078e00ffULL,
0x0000000810107812ULL, 0x000fe200078ef805ULL, 0x00000200070b7824ULL, 0x00cfc600078e00ffULL,
0x0000b00052347810ULL, 0x000fe20007ffe0ffULL, 0x0000000810537824ULL, 0x000fe200078e00ffULL,
0xfffff8000b307812ULL, 0x000fe400078ec0ffULL, 0x000000345e387211ULL, 0x000fe200078e20ffULL,
0x000000105a107824ULL, 0x000fe200078e0234ULL, 0xfffffff853537812ULL, 0x000fe200078ee262ULL,
0x000000105c547824ULL, 0x100fe400078e0234ULL, 0x000000105b4c7824ULL, 0x100fe200078e0234ULL,
0x000000003838783bULL, 0x000fe20000004200ULL, 0x000000105d487824ULL, 0x000fc400078e0234ULL,
0x0000001053537824ULL, 0x000fe200078e00ffULL, 0x000000001010783bULL, 0x002e620000004200ULL,
0x0000001060407824ULL, 0x100fe400078e0234ULL, 0x000000105f3c7824ULL, 0x100fe200078e0234ULL,
0x000000005454783bULL, 0x000ea20000004200ULL, 0x0000a00030307810ULL, 0x000fe20007ffe053ULL,
0x0000001061347824ULL, 0x000fe400078e0234ULL, 0x000000004c4c783bULL, 0x000fe80000004200ULL,
0x000000004848783bULL, 0x000fe80000004200ULL, 0x000000003030783bULL, 0x000ee20000000200ULL,
0x0000000244440232ULL, 0x000fc60000000000ULL, 0x000000004040783bULL, 0x000ee20000004200ULL,
0x0000000246460232ULL, 0x000fe40000000000ULL, 0x0000000045450232ULL, 0x080fe20000000000ULL,
0x000000003c3c783bULL, 0x000ee20000004200ULL, 0x0000000047470232ULL, 0x000fc60000000000ULL,
0x000000003434783bULL, 0x000ee80000004200ULL, 0x000000104418723cULL, 0x042f700000001818ULL,
0x00000054442c723cULL, 0x044f70000000182cULL, 0x000000564428723cULL, 0x000f620000001828ULL,
0x0000000230300232ULL, 0x008fc40000000000ULL, 0x0000000232320232ULL, 0x000fe40000000000ULL,
0x0000000031310232ULL, 0x080fe40000000000ULL, 0x0000000033330232ULL, 0x000fe20000000000ULL,
0x0000004c440c723cULL, 0x040f70000000180cULL, 0x0000004e4414723cULL, 0x040f700000001814ULL,
0x000000124410723cULL, 0x040f70000000181cULL, 0x000000484420723cULL, 0x040f700000001820ULL,
0x0000004a4424723cULL, 0x000f700000001824ULL, 0x000000383018723cULL, 0x060b700000001818ULL,
0x00000040302c723cULL, 0x040b70000000182cULL, 0x000000423028723cULL, 0x040b700000001828ULL,
0x0000003c300c723cULL, 0x040b70000000180cULL, 0x0000003e3014723cULL, 0x040b700000001814ULL,
0x0000003a3038723cULL, 0x040b700000001810ULL, 0x000000343020723cULL, 0x040b700000001820ULL,
0x000000363030723cULL, 0x000b620000001824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000030006117a10ULL, 0x020fe20007ffe0ffULL, 0x0136980059ff7f8cULL, 0x0003e6000c80043fULL,
0x000000641100720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00000d4000000947ULL, 0x000fea0003800000ULL, 0x00000001110b7810ULL, 0x042fe20007ffe0ffULL,
0x00000100113e7824ULL, 0x000fe400078e026cULL, 0x0000590051517a24ULL, 0x010fe200078e02ffULL,
0x000000640b00720cULL, 0x000fe20003f06070ULL, 0x00000100ff117424ULL, 0x000fe200078e00ffULL,
0x000000203e0b7812ULL, 0x000fe200078ec0ffULL, 0x0000004051107824ULL, 0x000fc800078e00ffULL,
0x0000000166367824ULL, 0x000fe400078e020bULL, 0x0000640010107625ULL, 0x000fc800078e0011ULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff3f7819ULL, 0x100fe20000011605ULL,
0x0000008007267824ULL, 0x000fe200078e00ffULL, 0x0000003e630b7217ULL, 0x000fe20007800000ULL,
0x000000ffff277224ULL, 0x000fe200078e00ffULL, 0x000000043f137810ULL, 0x040fe40007ffe0ffULL,
0x0000000c3f1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b3e7824ULL, 0x000fe200078e0a3eULL,
0x0000008069267812ULL, 0x000fe200078ef826ULL, 0x0000000113407824ULL, 0x100fe200078e0205ULL,
0x000000143f417810ULL, 0x000fe20007ffe0ffULL, 0x00000008131d7824ULL, 0x000fe200078e00ffULL,
0x000000083f257810ULL, 0x000fe20007ffe0ffULL, 0x000000011f0b7824ULL, 0x100fe200078e0205ULL,
0x0000000341357819ULL, 0x000fe200000006ffULL, 0x000000081f1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d407812ULL, 0x000fe200078ee240ULL, 0x000000013f1d7824ULL, 0x000fe200078e0236ULL,
0x000000203e3e7817ULL, 0x000fe20003800000ULL, 0x00000001413c7824ULL, 0x000fe200078e0205ULL,
0xfffffff81c0b7812ULL, 0x000fe200078ee20bULL, 0x000001001d1c7825ULL, 0x000fe200078e0026ULL,
0x000000103f457810ULL, 0x000fc40007ffe0ffULL, 0xfffffff8353c7812ULL, 0x000fe200078ee23cULL,
0x0000000125377824ULL, 0x140fe200078e0205ULL, 0x0000001c10347210ULL, 0x000fe20007f1e0ffULL,
0x0000000825127824ULL, 0x040fe200078e00ffULL, 0x0000003e2500720cULL, 0x080fe20003f66070ULL,
0x000000013f1c7824ULL, 0x000fe200078e0205ULL, 0x0000003e1300720cULL, 0x080fe20003f86070ULL,
0x0000000111357824ULL, 0x000fe200000e061dULL, 0x0000003e1f00720cULL, 0x080fe20003f46070ULL,
0x00002000071d7824ULL, 0x000fe200078e00ffULL, 0x000000071c427812ULL, 0x000fe200078ec0ffULL,
0x0000000125257824ULL, 0x100fe200078e0236ULL, 0xfffffff812377812ULL, 0x000fe200078ee237ULL,
0x00000001453d7824ULL, 0x000fe200078e0205ULL, 0x000020001d437812ULL, 0x000fe200078ec0ffULL,
0x00000008451e7824ULL, 0x000fe200078e00ffULL, 0x0000003e3f00720cULL, 0x000fe20003fa6070ULL,
0x0000000113137824ULL, 0x100fe200078e0236ULL, 0x000000183f477810ULL, 0x000fe20007ffe0ffULL,
0x000000011f1f7824ULL, 0x000fe200078e0236ULL, 0xfffffff81e3d7812ULL, 0x000fe200078ee23dULL,
0x0000010025247825ULL, 0x000fe200078e0026ULL, 0x0000001c3f497810ULL, 0x000fc60007ffe0ffULL,
0x0000400004447824ULL, 0x000fe200078e0243ULL, 0x0ffffff842437812ULL, 0x000fe200078ef805ULL,
0x0000010013127825ULL, 0x100fe200078e0026ULL, 0x0000002410247210ULL, 0x000fe40007f1e0ffULL,
0x0000b00044427810ULL, 0x000fe20007ffe0ffULL, 0x000001001f1e7825ULL, 0x000fe200078e0026ULL,
0x0000001210127210ULL, 0x000fc60007f3e0ffULL, 0x00000001451d7824ULL, 0x000fe200078e0236ULL,
0x0000001e101e7210ULL, 0x000fe20007fde0ffULL, 0x0000000111257824ULL, 0x000fe200000e0625ULL,
0x0000003e4100720cULL, 0x000fe20003f06070ULL, 0x000001001d1c7825ULL, 0x000fc800078e0026ULL,
0x0000001043437824ULL, 0x000fe400078e0242ULL, 0x0000000141417824ULL, 0x000fe400078e0236ULL,
0x0000000111137824ULL, 0x000fe200008e0613ULL, 0x0000003e4500720cULL, 0x000fe20003f26070ULL,
0x00000001111f7824ULL, 0x000fe200030e061fULL, 0x0000001c101c7210ULL, 0x000fe20007fde0ffULL,
0x0000001040457824ULL, 0x000fe200078e0242ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034437faeULL, 0x0003e2000e901c46ULL, 0x00000001473f7824ULL, 0x040fe200078e0236ULL,
0x0000003e4700720cULL, 0x080fe20003fa6070ULL, 0x00000001111d7824ULL, 0x000fe200030e061dULL,
0x0000000012457faeULL, 0x0005e2000e101c46ULL, 0x0000003e4900720cULL, 0x000fe20003f86070ULL,
0x0000001037377824ULL, 0x100fe200078e0242ULL, 0x00000005493e7210ULL, 0x000fe20007ffe0ffULL,
0x000000100b0b7824ULL, 0x000fc400078e0242ULL, 0x000000103d3d7824ULL, 0x000fe200078e0242ULL,
0x0000000024377faeULL, 0x0007e2000d901c46ULL, 0x0000010041347825ULL, 0x002fc600078e0026ULL,
0x000000001e0b7faeULL, 0x0007e2000d101c46ULL, 0x0000000149417824ULL, 0x000fe200078e0236ULL,
0x0000003410127210ULL, 0x004fe20007fde0ffULL, 0x0000000147367824ULL, 0x040fe200078e0205ULL,
0x000000001c3d7faeULL, 0x0007e2000c901c46ULL, 0x0000000847477824ULL, 0x000fe400078e00ffULL,
0x0000000111137824ULL, 0x000fe400030e0635ULL, 0x000001003f347825ULL, 0x000fc800078e0026ULL,
0x0000000849437824ULL, 0x000fe200078e00ffULL, 0x0000003410347210ULL, 0x040fe20007fde0ffULL,
0x0000010041267825ULL, 0x000fe200078e0026ULL, 0xfffffff847417812ULL, 0x000fe400078ee236ULL,
0xfffffff843437812ULL, 0x000fe200078ee23eULL, 0x0000000111357824ULL, 0x000fe200030e0635ULL,
0x0000002610107210ULL, 0x000fe20007fde0ffULL, 0x000000103c3f7824ULL, 0x100fe400078e0242ULL,
0x0000001041417824ULL, 0x000fc400078e0242ULL, 0x0000001043437824ULL, 0x000fe200078e0242ULL,
0x00000000123f7faeULL, 0x0007e2000c101c46ULL, 0x0000000111117824ULL, 0x000fc600030e0627ULL,
0x0000000034417faeULL, 0x0007e8000e901c46ULL, 0x0000000010437faeULL, 0x0007e2000e101c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x00000010051d7811ULL, 0x000fe200078fe8ffULL,
0x0000008007267824ULL, 0x000fe200078e00ffULL, 0x0000000405377811ULL, 0x040fe400078fe8ffULL,
0x00000014051f7811ULL, 0x000fe200078fe8ffULL, 0x000000011d427824ULL, 0x100fe200078e0205ULL,
0x00000008053d7811ULL, 0x000fe200078fe8ffULL, 0x000000081d137824ULL, 0x000fe200078e00ffULL,
0x0000000c051c7811ULL, 0x000fe200078fe8ffULL, 0x00000001373f7824ULL, 0x100fe200078e0205ULL,
0x0000001805257811ULL, 0x000fe200078fe8ffULL, 0x0000000837127824ULL, 0x000fe200078e00ffULL,
0xfffffff813427812ULL, 0x000fe200078ee242ULL, 0x000000011f3e7824ULL, 0x000fe200078e0205ULL,
0x0000001c05437811ULL, 0x000fe200078fe8ffULL, 0x000000081f277824ULL, 0x000fe200078e00ffULL,
0xfffffff8123f7812ULL, 0x000fe200078ee23fULL, 0x0000200007137824ULL, 0x000fe200078e00ffULL,
0x0000008069267812ULL, 0x000fe200078ef826ULL, 0x000000013d407824ULL, 0x100fe200078e0205ULL,
0xfffffff8273e7812ULL, 0x000fe200078ee23eULL, 0x000000083d0b7824ULL, 0x000fe200078e00ffULL,
0x0000200013277812ULL, 0x000fe200078ec0ffULL, 0x000000011c417824ULL, 0x040fe200078e0205ULL,
0x0000003605357211ULL, 0x000fe200078fe8ffULL, 0x000000081c127824ULL, 0x040fe200078e00ffULL,
0xfffffff80b407812ULL, 0x000fe200078ee240ULL, 0x00000008251e7824ULL, 0x040fe200078e00ffULL,
0x00000005250b7210ULL, 0x080fe20007ffe0ffULL, 0x000000011c137824ULL, 0x100fe200078e0236ULL,
0xfffffff812417812ULL, 0x000fe200078ee241ULL, 0x00004000041c7824ULL, 0x000fe200078e0227ULL,
0x0000000505127211ULL, 0x000fe200078fe8ffULL, 0x000000ffff277224ULL, 0x000fe200078e00ffULL,
0xfffffff81e0b7812ULL, 0x000fe200078ee20bULL, 0x0000000137377824ULL, 0x100fe200078e0236ULL,
0x0000000712127812ULL, 0x000fe200078ec0ffULL, 0x000000013d3d7824ULL, 0x000fc400078e0236ULL,
0x00000001431e7824ULL, 0x140fe200078e0205ULL, 0x0ffffff812447812ULL, 0x000fe200078ef805ULL,
0x0000000843457824ULL, 0x000fe400078e00ffULL, 0x000000011d1d7824ULL, 0x100fe400078e0236ULL,
0x000000011f1f7824ULL, 0x000fe200078e0236ULL, 0xfffffff845467812ULL, 0x000fe200078ee21eULL,
0x0000000125257824ULL, 0x100fe200078e0236ULL, 0x0000b0001c457810ULL, 0x000fe20007ffe0ffULL,
0x0000000143437824ULL, 0x000fc400078e0236ULL, 0x0000010035347825ULL, 0x000fe200078e0026ULL,
0x000000453e4b7211ULL, 0x000fc600078e20ffULL, 0x0000010037367825ULL, 0x000fe200078e0026ULL,
0x0000003410347210ULL, 0x000fc60007f1e0ffULL, 0x000001003d3c7825ULL, 0x000fe200078e0026ULL,
0x0000003610367210ULL, 0x000fc60007f3e0ffULL, 0x0000010013127825ULL, 0x000fe200078e0026ULL,
0x0000003c103c7210ULL, 0x000fc60007f5e0ffULL, 0x000001001d1c7825ULL, 0x000fe200078e0026ULL,
0x0000001210127210ULL, 0x000fc60007f7e0ffULL, 0x000001001f1e7825ULL, 0x000fc800078e0026ULL,
0x0000010025247825ULL, 0x000fc800078e0026ULL, 0x0000010043267825ULL, 0x000fc800078e0026ULL,
0x0000000111357824ULL, 0x040fe200000e0635ULL, 0x0000001c101c7210ULL, 0x040fe20007f1e0ffULL,
0x0000000111377824ULL, 0x040fe200008e0637ULL, 0x0000001e101e7210ULL, 0x000fe20007f3e0ffULL,
0x0000001044437824ULL, 0x000fe400078e0245ULL, 0x00000001113d7824ULL, 0x000fe200010e063dULL,
0x0000002410247210ULL, 0x040fe20007f5e0ffULL, 0x000000103f3f7824ULL, 0x000fe200078e0245ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034437faeULL, 0x0003e2000b901c46ULL,
0x0000000111137824ULL, 0x000fe200018e0613ULL, 0x0000002610107210ULL, 0x000fe20007f7e0ffULL,
0x0000001040477824ULL, 0x100fe200078e0245ULL, 0x00000000363f7faeULL, 0x0003e2000b901c46ULL,
0x0000001041417824ULL, 0x000fc400078e0245ULL, 0x0000001042497824ULL, 0x000fe200078e0245ULL,
0x000000003c477faeULL, 0x0003e2000b901c46ULL, 0x00000001111d7824ULL, 0x040fe400000e061dULL,
0x00000001111f7824ULL, 0x000fe200008e061fULL, 0x0000000012417faeULL, 0x0003e2000b901c46ULL,
0x000000100b0b7824ULL, 0x000fe400078e0245ULL, 0x0000000111257824ULL, 0x000fe200010e0625ULL,
0x000000001c497faeULL, 0x0003e2000b901c46ULL, 0x0000001046457824ULL, 0x000fc400078e0245ULL,
0x0000000111117824ULL, 0x000fe200018e0627ULL, 0x000000001e4b7faeULL, 0x0003e8000b901c46ULL,
0x00000000240b7faeULL, 0x0003e8000b901c46ULL, 0x0000000010457faeULL, 0x0003e4000b901c46ULL,
0x00000003080b7812ULL, 0x00afe200078ec0ffULL, 0xffffffffff517424ULL, 0x000fc600078e00ffULL,
0x000000030b00780cULL, 0x000fc80003f05270ULL, 0x000000016f0b7807ULL, 0x000fca0004000000ULL,
0x0000000108087824ULL, 0x000fca00078e020bULL, 0x000000710800720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000167107824ULL, 0x000fe400078e0208ULL,
0x00000004ff117424ULL, 0x000fc800078e00ffULL, 0x0000660010107625ULL, 0x000fca00078e0011ULL,
0x0000000610517981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136680009107f8cULL, 0x0002a4000c80043fULL,
0x0000000000127805ULL, 0x000fc40000015200ULL, 0xffffffe06a097812ULL, 0x042fe400078ec0ffULL,
0x000000106a1c7812ULL, 0x040fe400078ec0ffULL, 0x000000086a0b7812ULL, 0x000fc800078ec0ffULL,
0x000000090b0b7210ULL, 0x000fca0007ffe01cULL, 0x01366c000b097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x006fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c121c7210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1d7824ULL, 0x000fe200000e0e13ULL,
0x003d09001c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc8000001141dULL, 0x0000001c09097211ULL, 0x000fca00078110ffULL,
0x000000ffff1c7224ULL, 0x000fca00000e061dULL, 0x0000000209097819ULL, 0x000fc8000000121cULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01366c000b097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002007097824ULL, 0x000fca00078e00ffULL,
0xffffff8009107812ULL, 0x000fc800078ec0ffULL, 0x0000018069097810ULL, 0x000fca0007ffe010ULL,
0x000000016e097824ULL, 0x000fca00078e0209ULL, 0x0130000009137984ULL, 0x000e680000000800ULL,
0x0132000009127984ULL, 0x0004e20000000800ULL, 0x0000000a1300720bULL, 0x002fe20003f1d000ULL,
0x0000c0427f007947ULL, 0x000fd8000b800000ULL, 0x00000000000b7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0b1c7812ULL, 0x000fe2000782c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x000000036b107810ULL, 0x000fe40007ffe0ffULL, 0x0000000a1300720bULL, 0x000fe40003f34000ULL,
0x000000071000720cULL, 0x000fe20003f05270ULL, 0x0000bff27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000097806ULL, 0x000fc400008e0100ULL, 0x0000008007698824ULL, 0x000fe200078e0269ULL,
0x0000000a130b8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991009107816ULL, 0x000fe200000000ffULL, 0x000000016e6e8824ULL, 0x000fca00078e0269ULL,
0x0134000b6e008388ULL, 0x0003e20000000800ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000a130b7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff09ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000a0b0b7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL,
0x0000000b001d7308ULL, 0x000e640000000800ULL, 0x0000001d50507220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0b7819ULL, 0x000fe20000011605ULL,
0x0000bf127f007947ULL, 0x000fea000b800000ULL, 0x00001f0b1d0b7589ULL, 0x0002a400000e0000ULL,
0x0000000b2c2c7220ULL, 0x084fe20000410000ULL, 0x0000000b2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000b28287220ULL, 0x080fe20000410000ULL, 0x0000000b29297220ULL, 0x080fe20000410000ULL,
0x0000000b0c0c7220ULL, 0x080fe20000410000ULL, 0x0000000b0d0d7220ULL, 0x080fe20000410000ULL,
0x0000000b14147220ULL, 0x080fe20000410000ULL, 0x0000000b15157220ULL, 0x080fe20000410000ULL,
0x0000000b18187220ULL, 0x080fe20000410000ULL, 0x0000000b19197220ULL, 0x080fe20000410000ULL,
0x0000000b38387220ULL, 0x080fe20000410000ULL, 0x0000000b39397220ULL, 0x080fe20000410000ULL,
0x0000000b20207220ULL, 0x080fe20000410000ULL, 0x0000000b21217220ULL, 0x080fe20000410000ULL,
0x0000000b30307220ULL, 0x080fe20000410000ULL, 0x0000000b31317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0009ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008050b7811ULL, 0x000fe200078ff0ffULL,
0x0000bdf27f007947ULL, 0x000fea000b800000ULL, 0x00001f0b1d0b7589ULL, 0x00046400000e0000ULL,
0x0000000b2e2e7220ULL, 0x086fe20000410000ULL, 0x0000000b2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000b2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000b2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000b0e0e7220ULL, 0x080fe20000410000ULL, 0x0000000b0f0f7220ULL, 0x080fe20000410000ULL,
0x0000000b16167220ULL, 0x080fe20000410000ULL, 0x0000000b17177220ULL, 0x080fe20000410000ULL,
0x0000000b1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000b1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000b3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000b3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000b22227220ULL, 0x080fe20000410000ULL, 0x0000000b23237220ULL, 0x080fe20000410000ULL,
0x0000000b32327220ULL, 0x080fe20000410000ULL, 0x0000000b33337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff1cff7812ULL, 0x000fe40007806009ULL,
0x0000000a130a7209ULL, 0x000fd60007810000ULL, 0x8000000a13130221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL, 0x0000001300030308ULL, 0x000e640000000800ULL,
0x0000000312120220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x0000005012097221ULL, 0x008fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000003ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe40000011605ULL,
0x0000541000127816ULL, 0x000fe20000000000ULL, 0x0000bc227f007947ULL, 0x000fea000b800000ULL,
0x00001f1312027589ULL, 0x0002a400000e0000ULL, 0x00000008130b7810ULL, 0x000fe20007ffe0ffULL,
0x0000bc527f007947ULL, 0x000fea000b800000ULL, 0x00001f0b12007589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010130b7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200078e0012ULL, 0x000085f000117802ULL, 0x000fc40000000f00ULL,
0x0000c0d000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018130b7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200078e0012ULL,
0x0000864000117802ULL, 0x000fc40000000f00ULL, 0x0000c08000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000008006b447824ULL, 0x000fca00078e0265ULL, 0x0000c00052527810ULL, 0x000fe20007ffe0ffULL,
0x00a800004444783bULL, 0x000ee20000000200ULL, 0x000000036b1c7810ULL, 0x000fc40007ffe0ffULL,
0x000000525e347211ULL, 0x000fe200078e20ffULL, 0x000000105a107824ULL, 0x100fe200078e0252ULL,
0x0000030006067a10ULL, 0x000fe20007ffe0ffULL, 0x000000105c547824ULL, 0x100fe400078e0252ULL,
0x000000105b4c7824ULL, 0x100fe200078e0252ULL, 0x000000003434783bULL, 0x000fe20000004200ULL,
0x000000105d487824ULL, 0x100fe400078e0252ULL, 0x000008001c1c7824ULL, 0x000fe200078e0253ULL,
0x000000001010783bULL, 0x00ae620000004200ULL, 0x0000001060407824ULL, 0x000fc400078e0252ULL,
0x000000105f3c7824ULL, 0x100fe200078e0252ULL, 0x000000005454783bULL, 0x000ee20000004200ULL,
0x0000001061247824ULL, 0x000fc600078e0252ULL, 0x000000004c4c783bULL, 0x000fe80000004200ULL,
0x000000004848783bULL, 0x000fe80000004200ULL, 0x009000001c1c783bULL, 0x000ea80000000200ULL,
0x000000004040783bULL, 0x000ea80000004200ULL, 0x000000003c3c783bULL, 0x000ea40000004200ULL,
0x0000000244440232ULL, 0x004fc40000000000ULL, 0x000000002424783bULL, 0x000ea20000004200ULL,
0x0000000246460232ULL, 0x000fe40000000000ULL, 0x0000000045450232ULL, 0x080fe40000000000ULL,
0x0000000047470232ULL, 0x000fce0000000000ULL, 0x000000104418723cULL, 0x042f700000001818ULL,
0x000000124410723cULL, 0x040ff00000001838ULL, 0x00000054442c723cULL, 0x008f62000000182cULL,
0x000000021c1c0232ULL, 0x000fc40000000000ULL, 0x000000021e1e0232ULL, 0x000fe40000000000ULL,
0x000000001d1d0232ULL, 0x080fe40000000000ULL, 0x000000001f1f0232ULL, 0x000fe20000000000ULL,
0x000000564428723cULL, 0x040f700000001828ULL, 0x0000004c440c723cULL, 0x040f70000000180cULL,
0x0000004e4414723cULL, 0x040f700000001814ULL, 0x000000484438723cULL, 0x040f700000001820ULL,
0x0000004a4430723cULL, 0x000f700000001830ULL, 0x000000341c18723cULL, 0x060b700000001818ULL,
0x000000401c2c723cULL, 0x040b70000000182cULL, 0x000000421c28723cULL, 0x040b700000001828ULL,
0x0000003c1c20723cULL, 0x040b70000000180cULL, 0x0000003e1c14723cULL, 0x040b700000001814ULL,
0x000000361c34723cULL, 0x040b700000001810ULL, 0x000000241c38723cULL, 0x044b700000001838ULL,
0x000000261c1c723cULL, 0x000b620000001830ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000640600720cULL, 0x000fe20003f06070ULL, 0x0136a00059ff7f8cULL, 0x0003d8000c80043fULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff92f000007947ULL, 0x000fea000383ffffULL,
0x0000000000027919ULL, 0x002e640000002500ULL, 0x000000640200720cULL, 0x002fda0003f06070ULL,
0x0000033000000947ULL, 0x000fea0003800000ULL, 0x0180000009007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00008a80000c7802ULL, 0x020fc40000000f00ULL, 0x0000ba9000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000900007308ULL, 0x000e640000001000ULL, 0xbf80000000037423ULL, 0x002fc80000000009ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000ea40000000000ULL,
0x00000002ff037819ULL, 0x004fe40000011605ULL, 0x0000000805057811ULL, 0x000fc800078ff0ffULL,
0x00001f0300037589ULL, 0x000ea800000e0000ULL, 0x00001f0500057589ULL, 0x000ee200000e0000ULL,
0x0000002c032c7220ULL, 0x064fe20000410000ULL, 0x0000002d032d7220ULL, 0x040fe20000410000ULL,
0x0000002803287220ULL, 0x040fe20000410000ULL, 0x0000002903297220ULL, 0x040fe20000410000ULL,
0x0000002003207220ULL, 0x040fe20000410000ULL, 0x0000002103217220ULL, 0x040fe20000410000ULL,
0x0000001403147220ULL, 0x040fe20000410000ULL, 0x0000001503157220ULL, 0x040fe20000410000ULL,
0x0000001803187220ULL, 0x040fe20000410000ULL, 0x0000001903197220ULL, 0x040fe20000410000ULL,
0x0000003403347220ULL, 0x040fe20000410000ULL, 0x0000003503357220ULL, 0x040fe20000410000ULL,
0x0000003803387220ULL, 0x040fe20000410000ULL, 0x0000003903397220ULL, 0x040fe20000410000ULL,
0x0000001c031c7220ULL, 0x040fe20000410000ULL, 0x0000001d031d7220ULL, 0x000fe20000410000ULL,
0x0000002e052e7220ULL, 0x048fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000001605167220ULL, 0x040fe20000410000ULL, 0x0000001705177220ULL, 0x040fe20000410000ULL,
0x0000001a051a7220ULL, 0x040fe20000410000ULL, 0x0000001b051b7220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000003a053a7220ULL, 0x040fe20000410000ULL, 0x0000003b053b7220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x000fc20000410000ULL,
0x00000000000b7919ULL, 0x000ea20000000000ULL, 0x000000202108723eULL, 0x020fc400000000ffULL,
0x00000014150c723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000001a1b15723eULL, 0x000fe400000000ffULL, 0x00000018190d723eULL, 0x000fe400000000ffULL,
0x0000001e1f18723eULL, 0x000fc400000000ffULL, 0x0000001c1d10723eULL, 0x000fe400000000ffULL,
0x000000222313723eULL, 0x000fe400000000ffULL, 0x000000282906723eULL, 0x000fe400000000ffULL,
0x0000002c2d03723eULL, 0x000fe400000000ffULL, 0x00000002ff207819ULL, 0x004fe4000001160bULL,
0x000000080b297811ULL, 0x000fc400078ff0ffULL, 0x0000000220057810ULL, 0x040fe20007ffe0ffULL,
0x00000008201a7824ULL, 0x040fe200078e00ffULL, 0x0000000520197810ULL, 0x040fe20007ffe0ffULL,
0x00000008201e7824ULL, 0x040fe200078e00ffULL, 0x0000000120007810ULL, 0x040fe20007ffe0ffULL,
0x00000008201b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1d7812ULL, 0x000fe200078ee205ULL,
0x00000008201c7824ULL, 0x040fe200078e00ffULL, 0x0000000420057810ULL, 0x040fe20007ffe0ffULL,
0x0000000820257824ULL, 0x040fe200078e00ffULL, 0x00000006201a7810ULL, 0x040fe20007ffe0ffULL,
0x00000008201f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e237812ULL, 0x000fe200078ee219ULL,
0x0000000820197824ULL, 0x040fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL,
0x0000000820277824ULL, 0x040fe200078e00ffULL, 0x0000000320007810ULL, 0x000fe20007ffe0ffULL,
0x00000008291e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c217812ULL, 0x000fe200078ee205ULL,
0x0000100068057824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee21aULL,
0x000000040b1a7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee200ULL,
0x0000080004007824ULL, 0x000fe200078e0205ULL, 0xfffffff819197812ULL, 0x000fc400078ee220ULL,
0xffffffff201c7810ULL, 0x000fe20007ffe0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0200ULL,
0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL, 0x0000001019197824ULL, 0x000fe200078e0200ULL,
0xfffffff827277812ULL, 0x000fe200078ee21cULL, 0x000000101d1d7824ULL, 0x100fe200078e0200ULL,
0xfffffff81e297812ULL, 0x000fe200078ee229ULL, 0x000000101f1f7824ULL, 0x100fe200078e0200ULL,
0x0000000023237211ULL, 0x000fe200078e20ffULL, 0x0000001021217824ULL, 0x000fe200078e0200ULL,
0x00000034350e723eULL, 0x000fe200000000ffULL, 0x00000001191c7824ULL, 0x000fe200078e021aULL,
0x00000038390f723eULL, 0x000fe200000000ffULL, 0x000000011a1b7824ULL, 0x040fe200078e021bULL,
0x0000002e2f11723eULL, 0x000fe200000000ffULL, 0x0000001025257824ULL, 0x100fe200078e0200ULL,
0x000000031c007388ULL, 0x000fe20000000800ULL, 0x000000011a1d7824ULL, 0x040fe200078e021dULL,
0x0000002a2b12723eULL, 0x000fe200000000ffULL, 0x0000001027277824ULL, 0x100fe200078e0200ULL,
0x000000061b007388ULL, 0x0005e20000000800ULL, 0x000000011a1f7824ULL, 0x040fe200078e021fULL,
0x000000161714723eULL, 0x000fe200000000ffULL, 0x0000001029297824ULL, 0x000fe200078e0200ULL,
0x000000081d007388ULL, 0x000fe20000000800ULL, 0x000000011a1e7824ULL, 0x040fe200078e0221ULL,
0x000000363716723eULL, 0x000fe200000000ffULL, 0x000000011a237824ULL, 0x040fe200078e0223ULL,
0x0000000c1f007388ULL, 0x000fe20000000800ULL, 0x000000011a207824ULL, 0x040fe200078e0225ULL,
0x0000003a3b17723eULL, 0x000fe200000000ffULL, 0x000000011a277824ULL, 0x040fe200078e0227ULL,
0x0000000d1e007388ULL, 0x000fe20000000800ULL, 0x000000011a1a7824ULL, 0x000fc400078e0229ULL,
0x000000016c197824ULL, 0x000fe200078e020bULL, 0x0000000e23007388ULL, 0x000fe60000000800ULL,
0x0000001019067824ULL, 0x004fe200078e0205ULL, 0x0000000f20007388ULL, 0x000fe80000000800ULL,
0x0000001027007388ULL, 0x000fe80000000800ULL, 0x000000111a007388ULL, 0x000fe80000000800ULL,
0x000400121b007388ULL, 0x000fe80000000800ULL, 0x000400131d007388ULL, 0x000fe80000000800ULL,
0x000400141f007388ULL, 0x000fe80000000800ULL, 0x000400151e007388ULL, 0x000fe80000000800ULL,
0x0004001623007388ULL, 0x000fe80000000800ULL, 0x0004001720007388ULL, 0x000fe80000000800ULL,
0x0004001827007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000060c7984ULL, 0x000ea20000000c00ULL, 0x00000300ff207624ULL, 0x000fc600078e00ffULL,
0x0004000006107984ULL, 0x000ee40000000c00ULL, 0x000000012000780cULL, 0x000fe40003f05270ULL,
0x0008000006287984ULL, 0x000e680000000c00ULL, 0x000c0000062c7984ULL, 0x000e620000000c00ULL,
0x200000ff0f0f7230ULL, 0x004fe40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fc40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff13137230ULL, 0x008fe40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fe40000000000ULL, 0x200000ff10107230ULL, 0x000fc40000000000ULL,
0x0000002b0f0f7230ULL, 0x002fe40000000000ULL, 0x0000002a0e0e7230ULL, 0x000fe40000000000ULL,
0x000000290d0d7230ULL, 0x000fe40000000000ULL, 0x000000280c0c7230ULL, 0x000fe40000000000ULL,
0x0000002f13137230ULL, 0x000fe40000000000ULL, 0x0000002e12127230ULL, 0x000fe20000000000ULL,
0x0000000c06007388ULL, 0x000fe20000000c00ULL, 0x0000002d11117230ULL, 0x000fc40000000000ULL,
0x0000002c10107230ULL, 0x000fca0000000000ULL, 0x0004001006007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00002a7000008947ULL, 0x000fea0003800000ULL,
0x00000400ff037624ULL, 0x000fe200078e00ffULL, 0x00000000001e7919ULL, 0x000e620000002600ULL,
0x00000040191b7810ULL, 0x000fc40007ffe0ffULL, 0x00006c0003037a24ULL, 0x000fe200078e02ffULL,
0x00000000000d7919ULL, 0x000e680000002700ULL, 0x0000000f03087811ULL, 0x040fe200078e10ffULL,
0x0000030003037a24ULL, 0x000fe200078e02ffULL, 0x0000000006107984ULL, 0x000ea40000000c00ULL,
0xfffffff008087812ULL, 0x000fe400078ec0ffULL, 0x0004000006147984ULL, 0x0006a60000000c00ULL,
0x00000080030c7824ULL, 0x000fc800078e0208ULL, 0x0000008003037824ULL, 0x000fca00078e020cULL,
0x0000007f03037810ULL, 0x000fe20007ffe0ffULL, 0x000004000d1e7a24ULL, 0x002fc600078e021eULL,
0xffffff8003037812ULL, 0x000fe200078ec0ffULL, 0x000003001e0d7a24ULL, 0x000fc600078e02ffULL,
0x00007000030f7a10ULL, 0x000fe20007f1e0ffULL, 0x000000010d027824ULL, 0x000fca00078e0202ULL,
0x0000000f020e7211ULL, 0x000fe400078260ffULL, 0x00007100ff0f7a10ULL, 0x000fe400007fe4ffULL,
0x0000000104ff7812ULL, 0x000fe4000780f807ULL, 0x0000000f020f7211ULL, 0x000fe400008f64ffULL,
0x0000700008067a10ULL, 0x008fc60007f3e0ffULL, 0x00000800680e7825ULL, 0x000fc800078e000eULL,
0x00007100ff1f7624ULL, 0x000fe400008e06ffULL, 0x0000001019187825ULL, 0x000fc800078e000eULL,
0x000000101b0e7825ULL, 0x000fe200078e000eULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x000000100b1a7824ULL, 0x004fe200078e00ffULL, 0x00000001ff1c7819ULL, 0x000fe2000001160bULL,
0x00000080021b7824ULL, 0x000fe200078e00ffULL, 0x00000019ff027819ULL, 0x000fe40000011602ULL,
0x000000701a1d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c1c1a7812ULL, 0x000fe400078ec0ffULL,
0x000070001b1c7a10ULL, 0x000fc40007ebe00cULL, 0x000000061d1b7210ULL, 0x000fe40007a3e01bULL,
0x0000001c1a1c7210ULL, 0x000fe40007c7e01dULL, 0x00007100021d7a10ULL, 0x000fe40002fec4ffULL,
0x0000001b1a1a7210ULL, 0x000fe40007fbe0ffULL, 0x0000001fff027210ULL, 0x000fe40000fe4402ULL,
0x0000001dff1d7210ULL, 0x000fc60001fe84ffULL, 0x000000ffff1b7224ULL, 0x000fca00028e0602ULL,
0x0000000a1a007986ULL, 0x0003e8000c101906ULL, 0x000000091c007986ULL, 0x0003e4000c101906ULL,
0x000000ff0b00720cULL, 0x004fe20000705670ULL, 0x0000001018007986ULL, 0x000fe2000c101d06ULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000140e007986ULL, 0x000fe8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff0f7424ULL, 0x000fe200078e00ffULL, 0xffffffff20097810ULL, 0x002fc60007ffe0ffULL,
0x000070001e0e7625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x000000090e0e79a8ULL, 0x000ea400099ee1c6ULL, 0x000000090e00720cULL, 0x004fc80003f05270ULL,
0x00000001ff027807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000002ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff027984ULL, 0x002e640000000000ULL,
0x000000ff0200720cULL, 0x002fda0003f05270ULL, 0x000025f000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x000000100b027824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe4000001160bULL,
0x000000060d067211ULL, 0x000fe400078038ffULL, 0x0000007002077812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097812ULL, 0x000fe400078ec0ffULL, 0x0000001f0d027211ULL, 0x000fe400000f3cffULL,
0x0000000609067210ULL, 0x000fc8000791e007ULL, 0x00000002ff077210ULL, 0x000fca00007e24ffULL,
0x0000000606027981ULL, 0x000328000c1e1900ULL, 0x0000800606097981ULL, 0x000322000c1e1900ULL,
0x000000022000780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010006060f7981ULL, 0x002322000c1e1900ULL, 0x000000042000780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x0001800606117981ULL, 0x002322000c1e1900ULL,
0x000000042000780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x0002000606137981ULL, 0x002322000c1e1900ULL, 0x000000062000780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800606157981ULL, 0x002322000c1e1900ULL,
0x000000062000780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000082000780cULL, 0x002fe20003f06070ULL, 0x0003000606177981ULL, 0x000318000c1e1900ULL,
0x0003800606190981ULL, 0x000324000c1e1900ULL, 0x0000000720067810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0a7819ULL, 0x000fc80000011606ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x000000080d1d7211ULL, 0x000fe200078038ffULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1b7224ULL, 0x010fe200078e0002ULL, 0x000070001d1d7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff0d0e7211ULL, 0x000fe400000f3cffULL, 0x000007801d1d7810ULL, 0x000fc80007f5e0ffULL,
0x00007100ff0e7a10ULL, 0x000fc400017e240eULL, 0x0000030010007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x000000040a007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x0000000810067810ULL, 0x040fe40007ffe0ffULL,
0x0000000110077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001b02027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100b067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc8000001160bULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060eULL, 0xfffc8006061b7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x0000000910067810ULL, 0x042fe40007ffe0ffULL,
0x0000000210077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000902027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100b067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc8000001160bULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060eULL, 0xfffd000606097981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000310077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000f02027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100b067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc8000001160bULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060eULL, 0xfffd8006060f7981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000410077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001102027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100b067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc8000001160bULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060eULL, 0xfffe000606117981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000510077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001302027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100b067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc8000001160bULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060eULL, 0xfffe800606137981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000610077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001502027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100b067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc8000001160bULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fc80007f3e0ffULL,
0x0000000eff077210ULL, 0x000fca0000ffe4ffULL, 0xffff000606157981ULL, 0x000328000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000710077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001702027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100b067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc8000001160bULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060eULL, 0xffff800606177981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f10067810ULL, 0x002fe40007ffe0ffULL,
0x0000001902027209ULL, 0x000fe40007810000ULL, 0x0000030006007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100b067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc8000001160bULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060eULL, 0x0000000606197981ULL, 0x000326000c1e1900ULL,
0x000004001d1d7810ULL, 0x000fe40007f3e0ffULL, 0x0000000810107810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e060eULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x00000000000b7919ULL, 0x000ea40000000000ULL, 0x000000100b067824ULL, 0x006fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc8000001160bULL, 0x0000007006067812ULL, 0x000fe400078ec0ffULL,
0x0000000c07077812ULL, 0x000fca00078ec0ffULL, 0x0000000106077824ULL, 0x000fca00078e0207ULL,
0x0000000207007388ULL, 0x0103e40000000800ULL, 0x0000700003027a10ULL, 0x002fe20007f3e0ffULL,
0x0000000104197824ULL, 0x000fe200078e020dULL, 0x000000070b00780cULL, 0x000fe20003f04070ULL,
0x00000800680a7824ULL, 0x000fe200078e00ffULL, 0x000000016b097812ULL, 0x040fe200078ec0ffULL,
0x00007100ff037624ULL, 0x000fe200008e06ffULL, 0x0000700008157a10ULL, 0x000fe20007f5e0ffULL,
0x000008006b6b7824ULL, 0x000fe200078e00ffULL, 0x000000200b117810ULL, 0x000fe20007ffe0ffULL,
0x0000100019067825ULL, 0x000fe200078e0002ULL, 0x000000400b137810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000a060e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000204108824ULL, 0x140fe200078e0268ULL, 0x000008006b6b7812ULL, 0x000fe200078ec0ffULL,
0x0000200004147824ULL, 0x000fe200078e0205ULL, 0x00000001ff067819ULL, 0x000fe2000001160bULL,
0x000000ffff0f7224ULL, 0x000fe200008e0607ULL, 0x000070000c0c7a10ULL, 0x000fe20007f3e0ffULL,
0x000000100b077824ULL, 0x040fe200078e00ffULL, 0x0000000c06067812ULL, 0x000fe200078ec0ffULL,
0x00000002041e8824ULL, 0x000fe200078e0268ULL, 0x000000600b1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000210208824ULL, 0x000fe200078e0209ULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x0000000114107824ULL, 0x000fe200078e026bULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00007100ff167624ULL, 0x000fe200008e06ffULL, 0x0000000c19088211ULL, 0x000fe200078238ffULL,
0x000000021e1e8824ULL, 0x000fe200078e0209ULL, 0x0000000607177210ULL, 0x000fe20007ffe0ffULL,
0x00007100ff187624ULL, 0x000fe200010e06ffULL, 0x00000015191a8211ULL, 0x000fe200078438ffULL,
0x000000100b1f7824ULL, 0x000fe200078e0210ULL, 0x0000001619098211ULL, 0x000fe200008f3cffULL,
0x0000001011107825ULL, 0x100fe200078e000eULL, 0x0000030004007a0cULL, 0x000fe20003f26070ULL,
0x0000000017177984ULL, 0x000e620000000800ULL, 0x00000018191b8211ULL, 0x000fe200010f3cffULL,
0x0000001013127825ULL, 0x100fe200078e000eULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000101d1c7825ULL, 0x100fe200078e000eULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000100b0e7825ULL, 0x040fe200078e000eULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x000000081e1e8824ULL, 0x100fe200078e020bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000e1f7faeULL, 0x0005e2000b901c46ULL, 0x0000000820208824ULL, 0x000fe200078e020bULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x000000100b088825ULL, 0x000fe200078e0008ULL,
0x000045801e218811ULL, 0x000fe200078e20ffULL, 0x00380000101f7faeULL, 0x0007e2000b901c46ULL,
0x0000418020238811ULL, 0x000fe200078e20ffULL, 0x000000ffff197224ULL, 0x000fc400078e00ffULL,
0x00580000121f7faeULL, 0x0007e2000b901c46ULL, 0x000000100b0e8825ULL, 0x004fc600078e001aULL,
0x007800001c1f7faeULL, 0x0005e2000b901c46ULL, 0x00000000001a7805ULL, 0x000fc6000001ff00ULL,
0x0000000008218faeULL, 0x0003e8000b901c46ULL, 0x000000000e238faeULL, 0x0003e8000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000001c7805ULL, 0x004fe2000001ff00ULL,
0x00000000001e7805ULL, 0x008fe2000001ff00ULL, 0x0000000000207805ULL, 0x002fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000c6000001947ULL, 0x000fea0003800000ULL,
0x000000ffff197224ULL, 0x000fe400078e00ffULL, 0x000000ffff3b7224ULL, 0x000fca00078e0004ULL,
0x000000023b3a7810ULL, 0x000fc80007ffe0ffULL, 0x000003003a007a0cULL, 0x000fda0003f06070ULL,
0x0000029000000947ULL, 0x000fea0003800000ULL, 0x000000010d137824ULL, 0x100fe200078e023aULL,
0x000000070b00780cULL, 0x000fe40003f44070ULL, 0x00000001ff087819ULL, 0x000fe2000001163aULL,
0x0000100013067825ULL, 0x000fe200078e0002ULL, 0x000000400b417810ULL, 0x040fe40007ffe0ffULL,
0x0000000108087812ULL, 0x000fe400078ec0ffULL, 0x0000000a06107210ULL, 0x000fe20007f1e0ffULL,
0x000004003a067824ULL, 0x000fe200078e00ffULL, 0x000000600b437810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200000e0607ULL, 0x0000080006077812ULL, 0x000fe200078ec0ffULL,
0x000000020409a824ULL, 0x140fe200078e0268ULL, 0x0000000c130ea211ULL, 0x040fe200078038ffULL,
0x00000002040fa824ULL, 0x000fe200078e0268ULL, 0x000000151312a211ULL, 0x000fe200078238ffULL,
0x00000002093ea824ULL, 0x100fe200078e0208ULL, 0x000000200b097810ULL, 0x000fe20007ffe0ffULL,
0x000000020f40a824ULL, 0x000fe200078e0208ULL, 0x00000016130fa211ULL, 0x040fe200000f3cffULL,
0x0000000114067824ULL, 0x000fe200078e0207ULL, 0x000000181313a211ULL, 0x000fe200008f3cffULL,
0x000000083e3ea824ULL, 0x000fc400078e020bULL, 0x000000100b3f7824ULL, 0x040fe400078e0206ULL,
0x000000100b3c7825ULL, 0x000fc800078e0010ULL, 0x000000084040a824ULL, 0x000fe200078e020bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800003c3f7faeULL, 0x0003e2000b901c46ULL,
0x0000001009067825ULL, 0x000fc800078e0010ULL, 0x0000001041087825ULL, 0x100fe200078e0010ULL,
0x000045803e41a811ULL, 0x000fe200078e20ffULL, 0x00380000063f7faeULL, 0x0003e4000b901c46ULL,
0x0000001043107825ULL, 0x000fe200078e0010ULL, 0x000041804043a811ULL, 0x000fe200078e20ffULL,
0x00580000083f7faeULL, 0x0003e4000b901c46ULL, 0x000000100b0ea825ULL, 0x040fe400078e000eULL,
0x00780000103f7faeULL, 0x0003e4000b901c46ULL, 0x000000100b12a825ULL, 0x000fc400078e0012ULL,
0x000000000e41afaeULL, 0x0003e8000b901c46ULL, 0x000000001243afaeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000063b067819ULL, 0x002fe200000006ffULL,
0x0000000204097824ULL, 0x000fe200078e0268ULL, 0x00000001ff0e7819ULL, 0x100fe2000001160bULL,
0x000000100b077824ULL, 0x000fe200078e00ffULL, 0x0000008006067812ULL, 0x000fe400078ec0ffULL,
0x00000002ff3f7819ULL, 0x000fc4000001160bULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x0000010009087824ULL, 0x000fe200078e0006ULL, 0x0000000c0e067812ULL, 0x000fe200078ec0ffULL,
0x000000083f117824ULL, 0x040fe200078e00ffULL, 0x000000023f097810ULL, 0x040fe20007ffe0ffULL,
0x000000083f127824ULL, 0x040fe200078e00ffULL, 0x00000008060e7210ULL, 0x000fe20007ffe007ULL,
0x000000083f447824ULL, 0x040fe200078e00ffULL, 0x000000013f087810ULL, 0x040fe20007ffe0ffULL,
0x000000083f427824ULL, 0x040fe200078e00ffULL, 0x000000083f497810ULL, 0x040fe20007ffe0ffULL,
0x000000083f437824ULL, 0x000fe200078e00ffULL, 0xfffffff811117812ULL, 0x000fe200078ee208ULL,
0x000004003b087824ULL, 0x000fe200078e00ffULL, 0xfffffff8123b7812ULL, 0x000fe200078ee209ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180000e107984ULL, 0x000e620000000800ULL,
0x0000080008097812ULL, 0x000fe200078ec0ffULL, 0x000000040b087824ULL, 0x000fe200078e00ffULL,
0xfffffff8120f7812ULL, 0x000fe200078ee23fULL, 0x004580000e3c7984ULL, 0x0004e20000000800ULL,
0x0000000849127824ULL, 0x000fe200078e00ffULL, 0x000000033f3d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c08467812ULL, 0x000fe400078ec0ffULL, 0x000000043f3e7810ULL, 0x000fc40007ffe0ffULL,
0x00000180140e7810ULL, 0x004fe40007ffe009ULL, 0xfffffff812097812ULL, 0x000fe400078ee249ULL,
0xfffffff8423d7812ULL, 0x000fe200078ee23dULL, 0x000000100f087824ULL, 0x000fe200078e020eULL,
0xfffffff843437812ULL, 0x000fe200078ee23eULL, 0x0000001009097824ULL, 0x000fe200078e020eULL,
0xffffffff3f3e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000146087824ULL, 0x040fe400078e0208ULL,
0x0000000146127824ULL, 0x000fc400078e0209ULL, 0x0000001011097824ULL, 0x100fe200078e020eULL,
0x00000000080f7984ULL, 0x000ea20000000800ULL, 0x000000053f117810ULL, 0x000fe40007ffe0ffULL,
0x0000000146097824ULL, 0x000fe200078e0209ULL, 0x0000000012407984ULL, 0x000ea20000000800ULL,
0xfffffff844457812ULL, 0x000fe200078ee211ULL, 0x000000103b117824ULL, 0x000fe200078e020eULL,
0x000000063f3b7810ULL, 0x000fe20007ffe0ffULL, 0x0004000009417984ULL, 0x000fe40000000800ULL,
0x0000000146117824ULL, 0x000fe200078e0211ULL, 0x0000001017107221ULL, 0x002fc80000010100ULL,
0x0000000011127984ULL, 0x000fe20000000800ULL, 0x3fb8aa3b10107820ULL, 0x000fc60000410000ULL,
0x0004000011427984ULL, 0x0005e20000000800ULL, 0x0000001000137308ULL, 0x0002e60000000800ULL,
0x0000000009107984ULL, 0x002fe20000000800ULL, 0x0000003c13447220ULL, 0x008fe20000410000ULL,
0x000000033f3c7819ULL, 0x000fe200000006ffULL, 0x000000103d137824ULL, 0x100fe400078e020eULL,
0x000000083f3d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c477812ULL, 0x000fe200078ee23bULL,
0x00000010433c7824ULL, 0x000fe200078e020eULL, 0x00001f4944097589ULL, 0x000e6200000e0000ULL,
0x0000000146137824ULL, 0x040fe200078e0213ULL, 0xfffffff83d437812ULL, 0x000fe200078ee23eULL,
0x00000001463c7824ULL, 0x000fe200078e023cULL, 0x00001f3f44087589ULL, 0x00066200000e0000ULL,
0x00000010453d7824ULL, 0x100fe200078e020eULL, 0x0000003944397221ULL, 0x000fe20000010000ULL,
0x00000010473e7824ULL, 0x000fe200078e020eULL, 0x00000000133b7984ULL, 0x000e620000000800ULL,
0x00000001463d7824ULL, 0x000fc400078e023dULL, 0x00000001463e7824ULL, 0x040fe200078e023eULL,
0x000400003c447984ULL, 0x000fe20000000800ULL, 0x3000000fff117230ULL, 0x104fe40000004100ULL,
0x00000010433f7824ULL, 0x008fe400078e020eULL, 0x000000003c0e7984ULL, 0x000ea20000000800ULL,
0x30000040ff457230ULL, 0x000fe40000004100ULL, 0x00000001463f7824ULL, 0x000fe200078e023fULL,
0x0004000013437984ULL, 0x000ee20000000800ULL, 0x2000000fff467230ULL, 0x000fc40000004100ULL,
0x20000040ff487230ULL, 0x000fe20000004100ULL, 0x000000003d0f7984ULL, 0x000ee20000000800ULL,
0x0000000945347223ULL, 0x082fe20000010034ULL, 0x20000010ff407230ULL, 0x100fe20000004100ULL,
0x0000000811367223ULL, 0x080fe20000010036ULL, 0x000400003d137984ULL, 0x000e620000000800ULL,
0x30000010ff457230ULL, 0x000fe20000004100ULL, 0x0000000846377223ULL, 0x080fe20000010037ULL,
0x20000041ff107230ULL, 0x100fe20000004100ULL, 0x000000003e117984ULL, 0x000e620000000800ULL,
0x30000041ff417230ULL, 0x000fe20000004100ULL, 0x0000000845327223ULL, 0x080fe20000010032ULL,
0x20000042ff457230ULL, 0x000fe20000004100ULL, 0x000400003e3c7984ULL, 0x000e620000000800ULL,
0x0000000910317223ULL, 0x080fe20000010031ULL, 0x0000000941307223ULL, 0x080fe20000010030ULL,
0x20000012ff417230ULL, 0x100fe20000004100ULL, 0x000000003f107984ULL, 0x000e620000000800ULL,
0x30000012ff127230ULL, 0x000fe20000004100ULL, 0x0000000948357223ULL, 0x080fe20000010035ULL,
0x30000042ff427230ULL, 0x000fe20000004100ULL, 0x000400003f3d7984ULL, 0x0006620000000800ULL,
0x00000008412c7223ULL, 0x080fe2000001002cULL, 0x00000008122b7223ULL, 0x080fe2000001002bULL,
0x2000003bff417230ULL, 0x100fe20000004100ULL, 0x0000000840337223ULL, 0x080fe20000010033ULL,
0x3000003bff127230ULL, 0x000fe20000004100ULL, 0x00000009452a7223ULL, 0x080fe2000001002aULL,
0x0000000942297223ULL, 0x000fe20000010029ULL, 0x0000000841287223ULL, 0x000fc40000010028ULL,
0x0000000812277223ULL, 0x080fe20000010027ULL, 0x2000000eff3b7230ULL, 0x104fe40000004100ULL,
0x3000000eff0e7230ULL, 0x000fe40000004100ULL, 0x20000043ff3f7230ULL, 0x108fe20000004100ULL,
0x000000083b247223ULL, 0x080fe20000010024ULL, 0x30000043ff3e7230ULL, 0x000fe20000004100ULL,
0x000000080e237223ULL, 0x080fe20000010023ULL, 0x2000000fff3b7230ULL, 0x100fe20000004100ULL,
0x000000093f267223ULL, 0x080fe20000010026ULL, 0x3000000fff0e7230ULL, 0x000fe20000004100ULL,
0x000000093e257223ULL, 0x080fe20000010025ULL, 0x20000013ff0f7230ULL, 0x002fe20000004100ULL,
0x000000083b207223ULL, 0x080fe20000010020ULL, 0x000000ffff3b7224ULL, 0x000fe200078e003aULL,
0x000000080e1f7223ULL, 0x080fe2000001001fULL, 0x30000011ff0e7230ULL, 0x100fe20000004100ULL,
0x000000090f1e7223ULL, 0x080fe2000001001eULL, 0x20000011ff0f7230ULL, 0x000fe20000004100ULL,
0x000003003b007a0cULL, 0x000fe20003f06070ULL, 0x30000013ff127230ULL, 0x000fe20000004100ULL,
0x000000080e1b7223ULL, 0x080fe2000001001bULL, 0x2000003cff117230ULL, 0x000fe20000004100ULL,
0x000000080f1c7223ULL, 0x080fe2000001001cULL, 0x20000044ff3f7230ULL, 0x000fe20000004100ULL,
0x00000009121d7223ULL, 0x080fe2000001001dULL, 0x20000010ff0e7230ULL, 0x100fe20000004100ULL,
0x00000009111a7223ULL, 0x080fe2000001001aULL, 0x30000010ff0f7230ULL, 0x000fe20000004100ULL,
0x000000093f227223ULL, 0x080fe20000010022ULL, 0x30000044ff447230ULL, 0x000fe20000004100ULL,
0x000000080e2f7223ULL, 0x080fe2000001002fULL, 0x3000003cff117230ULL, 0x000fe20000004100ULL,
0x000000080f2e7223ULL, 0x000fe2000001002eULL, 0x2000003dff107230ULL, 0x100fe20000004100ULL,
0x0000000944217223ULL, 0x080fe20000010021ULL, 0x3000003dff127230ULL, 0x000fe20000004100ULL,
0x0000000911387223ULL, 0x000fc40000010038ULL, 0x00000009102d7223ULL, 0x080fe4000001002dULL,
0x0000000912197223ULL, 0x000fe20000010019ULL, 0xfffff3c000008947ULL, 0x000fea000383ffffULL,
0x000000ff6800720cULL, 0x000fe20003f05270ULL, 0x0000018000007945ULL, 0x000fd80003800000ULL,
0x0000008004038824ULL, 0x000fe400078e0207ULL, 0x0000000107077824ULL, 0x000fe400078e0206ULL,
0x0000000106028824ULL, 0x000fca00078e0203ULL, 0x0049803902008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0049800007037984ULL, 0x000e680000000800ULL,
0x004a000007067984ULL, 0x000ea20000000800ULL, 0x00000003ff037221ULL, 0x002fc80000010000ULL,
0x0000000603037221ULL, 0x004fca0000010000ULL, 0x0180000003067810ULL, 0x000fc80007ffe0ffULL,
0x7f80000006067812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0600780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff097224ULL, 0x000fe200078e0003ULL, 0x0000b570000c7802ULL, 0x000fc40000000f00ULL,
0x00008fa000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff027224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000300027308ULL, 0x000e640000001000ULL,
0xbf80000003067423ULL, 0x002fc80000000002ULL, 0x800000ff06077221ULL, 0x000fc80000010100ULL,
0x0000000702027223ULL, 0x000fc40000000002ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000b7919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff077819ULL, 0x104fe2000001160bULL, 0x000000016c6c7824ULL, 0x000fe200078e020bULL,
0x000000080b097811ULL, 0x002fc400078ff0ffULL, 0x00000004070c7810ULL, 0x040fe20007ffe0ffULL,
0x00001f0702037589ULL, 0x000e6200000e0000ULL, 0x0000000807157824ULL, 0x040fe200078e00ffULL,
0x0000000207087810ULL, 0x040fe20007ffe0ffULL, 0x00000008070f7824ULL, 0x040fe200078e00ffULL,
0x00001f0902067589ULL, 0x0004e200000e0000ULL, 0x0000000807117824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee20cULL, 0x00000008070c7824ULL, 0x040fe200078e00ffULL,
0x00000003070a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000807177824ULL, 0x040fe200078e00ffULL,
0x0000000307137819ULL, 0x040fe200000006ffULL, 0x0000000807397824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee208ULL, 0x0000001015157824ULL, 0x000fe200078e0200ULL,
0x0000000107027810ULL, 0x004fe20007ffe0ffULL, 0x000000106c6c7824ULL, 0x000fe200078e0205ULL,
0xfffffff813137812ULL, 0x000fe200078ee20aULL, 0x0000001011117824ULL, 0x000fe200078e0200ULL,
0xfffffff80f0f7812ULL, 0x000fc400078ee202ULL, 0x0000000507027810ULL, 0x000fe20007ffe0ffULL,
0x0000001013137824ULL, 0x100fe200078e0200ULL, 0x0000000607087810ULL, 0x000fe20007ffe0ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0200ULL, 0x0000003703377220ULL, 0x042fe20000410000ULL,
0x0000003603367220ULL, 0x040fe20000410000ULL, 0x0000003303337220ULL, 0x040fe20000410000ULL,
0x0000003203327220ULL, 0x040fe20000410000ULL, 0x0000002c032c7220ULL, 0x040fe20000410000ULL,
0x0000002b032b7220ULL, 0x040fe20000410000ULL, 0x0000002803287220ULL, 0x040fe20000410000ULL,
0x0000002703277220ULL, 0x040fe20000410000ULL, 0x0000002403247220ULL, 0x040fe20000410000ULL,
0x0000002303237220ULL, 0x040fe20000410000ULL, 0x0000002003207220ULL, 0x040fe20000410000ULL,
0x0000001f031f7220ULL, 0x040fe20000410000ULL, 0x0000001c031c7220ULL, 0x040fe20000410000ULL,
0x0000001b031b7220ULL, 0x040fe20000410000ULL, 0x0000002f032f7220ULL, 0x040fe20000410000ULL,
0x0000002e032e7220ULL, 0x000fe20000410000ULL, 0x0000003506357220ULL, 0x048fe20000410000ULL,
0x0000003406347220ULL, 0x040fe20000410000ULL, 0x0000003106317220ULL, 0x040fe20000410000ULL,
0x0000003006307220ULL, 0x040fe20000410000ULL, 0x0000002a062a7220ULL, 0x040fe20000410000ULL,
0x0000002906297220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0x0000002506257220ULL, 0x040fe20000410000ULL, 0x0000002206227220ULL, 0x040fe20000410000ULL,
0x0000002106217220ULL, 0x040fe20000410000ULL, 0x0000001e061e7220ULL, 0x040fe20000410000ULL,
0x0000001d061d7220ULL, 0x040fe20000410000ULL, 0x0000001a061a7220ULL, 0x040fe20000410000ULL,
0x0000003806037220ULL, 0x040fe20000410000ULL, 0x0000002d062d7220ULL, 0x040fe20000410000ULL,
0x0000001906067220ULL, 0x000fe20000410000ULL, 0x0000000807197824ULL, 0x040fe200078e00ffULL,
0xffffffff070a7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80c0d7812ULL, 0x000fe200078ee207ULL,
0x00000008090c7824ULL, 0x000fe200078e00ffULL, 0xfffffff817077812ULL, 0x000fe200078ee202ULL,
0x000000040b027824ULL, 0x000fe200078e00ffULL, 0xfffffff819177812ULL, 0x000fe200078ee208ULL,
0x000000100d0d7824ULL, 0x000fe200078e0200ULL, 0xfffffff839197812ULL, 0x000fe400078ee20aULL,
0x0000000c02027812ULL, 0x000fe200078ec0ffULL, 0x0000001017177824ULL, 0x100fe200078e0200ULL,
0xfffffff80c397812ULL, 0x000fe200078ee209ULL, 0x0000001007097824ULL, 0x000fe200078e0200ULL,
0x000000373636723eULL, 0x000fe200000000ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0202ULL,
0x000000333232723eULL, 0x000fe200000000ffULL, 0x0000001019197824ULL, 0x100fe200078e0200ULL,
0x0000002c2b2b723eULL, 0x000fe200000000ffULL, 0x0000001039397824ULL, 0x000fe200078e0200ULL,
0x000000282727723eULL, 0x000fe200000000ffULL, 0x0000000102077824ULL, 0x040fe200078e020fULL,
0x0000001302087210ULL, 0x040fe20007ffe0ffULL, 0x0000000102007824ULL, 0x040fe200078e0211ULL,
0x000000242323723eULL, 0x000fe200000000ffULL, 0x00000001020a7824ULL, 0x040fe200078e0215ULL,
0x0000001c1b1b723eULL, 0x000fe200000000ffULL, 0x00000001021c7824ULL, 0x040fe200078e0209ULL,
0x000000201f1f723eULL, 0x000fe200000000ffULL, 0x000000360d007388ULL, 0x000fe20000000800ULL,
0x0000001e1d1d723eULL, 0x000fe200000000ffULL, 0x00000001021e7824ULL, 0x000fe200078e0217ULL,
0x0000002f2e2e723eULL, 0x000fe200000000ffULL, 0x0000003207007388ULL, 0x000fe20000000800ULL,
0x0000000102097824ULL, 0x000fe200078e0219ULL, 0x000000353434723eULL, 0x000fe200000000ffULL,
0x0000000102397824ULL, 0x000fe200078e0239ULL, 0x0000002b00007388ULL, 0x000fe20000000800ULL,
0x000000313030723eULL, 0x000fc400000000ffULL, 0x0000002a2929723eULL, 0x000fe200000000ffULL,
0x0000002708007388ULL, 0x000fe20000000800ULL, 0x000000262525723eULL, 0x000fe400000000ffULL,
0x000000222121723eULL, 0x000fe200000000ffULL, 0x000000230a007388ULL, 0x000fe20000000800ULL,
0x0000001a0303723eULL, 0x000fe400000000ffULL, 0x0000002d0606723eULL, 0x000fe200000000ffULL,
0x0000001f1c007388ULL, 0x000fe80000000800ULL, 0x0000001b1e007388ULL, 0x000fe80000000800ULL,
0x0000002e09007388ULL, 0x000fe80000000800ULL, 0x0000003439007388ULL, 0x000fe80000000800ULL,
0x0004003007007388ULL, 0x000fe80000000800ULL, 0x0004002900007388ULL, 0x000fe80000000800ULL,
0x0004002508007388ULL, 0x000fe80000000800ULL, 0x000400210a007388ULL, 0x000fe80000000800ULL,
0x0004001d1c007388ULL, 0x000fe80000000800ULL, 0x000400031e007388ULL, 0x000fe80000000800ULL,
0x0004000609007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000006c0c7984ULL, 0x000e680000000c00ULL, 0x000400006c147984ULL, 0x000ea80000000c00ULL,
0x000800006c107984ULL, 0x000ee80000000c00ULL, 0x000c00006c187984ULL, 0x000ee20000000c00ULL,
0x200000ff0f0f7230ULL, 0x002fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff17177230ULL, 0x004fe40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fc40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x000000130f0f7230ULL, 0x008fe40000000000ULL, 0x000000120e0e7230ULL, 0x000fe40000000000ULL,
0x000000110d0d7230ULL, 0x000fe40000000000ULL, 0x000000100c0c7230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x000fc40000000000ULL, 0x0000001a16167230ULL, 0x000fe20000000000ULL,
0x0000000c6c007388ULL, 0x000fe20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fca0000000000ULL, 0x000400146c007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff0400720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff077819ULL, 0x000fc8000001160bULL,
0x000000700700720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000047b06ULL, 0x000e620000209000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x000000200b087810ULL, 0x000fe20007ffe0ffULL, 0x0000000174007824ULL, 0x000fe400078e0207ULL,
0x0000000107077824ULL, 0x000fc600078e020bULL, 0x0000000400047308ULL, 0x002e640000001000ULL,
0x0ffffffe04067810ULL, 0x002fe40007ffe0ffULL, 0x0000000707047812ULL, 0x000fc800078ec0ffULL,
0x0000000600037305ULL, 0x0002a2000021f000ULL, 0x0ffffff804047812ULL, 0x000fca00078ef80bULL,
0x0000001004047824ULL, 0x000fe200078e0205ULL, 0x00005a00ff067a12ULL, 0x002fc800078e33ffULL,
0x00000000040c7984ULL, 0x000e620000000c00ULL, 0x000000ffff097224ULL, 0x004fc800078e0a03ULL,
0x00005a0009097a24ULL, 0x000fc800078e02ffULL, 0x0000000903117227ULL, 0x000fe200078e0002ULL,
0x00000003ff097819ULL, 0x000fca0000011608ULL, 0x0000000011027227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a02ULL, 0x00005a0003037a24ULL, 0x000fca00078e0200ULL,
0x00005a0003007a0cULL, 0x000fda0003f06070ULL, 0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL,
0x0000000102020810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fe40003f26070ULL,
0x00005a00ff007a0cULL, 0x000fd60003f05070ULL, 0x0000000102021810ULL, 0x000fc80007ffe0ffULL,
0x0000000206027207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a02ULL,
0x0000590002037a24ULL, 0x000fe400078e026dULL, 0x00005a0007007a24ULL, 0x000fe200078e0200ULL,
0x000000070b077812ULL, 0x000fc600078ec0ffULL, 0x00005a0003037a24ULL, 0x000fe400078e0200ULL,
0x0000000868077824ULL, 0x000fc600078e0207ULL, 0x0000000372037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0x00005e0003027a11ULL, 0x000fc800078240ffULL,
0x00005f0003037a11ULL, 0x000fe400008f4400ULL, 0x000000700900720cULL, 0x000fc60003f26070ULL,
0x0000001007027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000174007824ULL, 0x100fe200078e0209ULL,
0x000000400b0a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000108097824ULL, 0x000fe400078e0209ULL,
0x0000000011037227ULL, 0x002fc600078e00ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a03ULL, 0x00005a0007027a24ULL, 0x000fca00078e0200ULL,
0x00005a0002007a0cULL, 0x000fda0003f26070ULL, 0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a0002007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff809027812ULL, 0x000fe400078ef808ULL, 0x00000003ff097819ULL, 0x000fe4000001160aULL,
0x0000000502047211ULL, 0x000fca00078e20ffULL, 0x00000000040c7984ULL, 0x000e640000000c00ULL,
0x0000000103032810ULL, 0x000fc80007ffe0ffULL, 0x0000000306027207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a02ULL, 0x0000590002037a24ULL, 0x000fe400078e026dULL,
0x00005a0007007a24ULL, 0x000fe200078e0200ULL, 0x0000000708077812ULL, 0x000fc600078ec0ffULL,
0x00005a0003037a24ULL, 0x000fe400078e0200ULL, 0x0000000868077824ULL, 0x000fc600078e0207ULL,
0x0000000372037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078240ffULL, 0x00005f0003037a11ULL, 0x000fe400008f4400ULL,
0x000000700900720cULL, 0x000fc60003f26070ULL, 0x0000001007027825ULL, 0x000fca00078e0002ULL,
0x0000000c02007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000174007824ULL, 0x100fe200078e0209ULL, 0x000000600b107810ULL, 0x000fe20007ffe0ffULL,
0x000000010a097824ULL, 0x000fe400078e0209ULL, 0x0000000011037227ULL, 0x002fc600078e00ffULL,
0x0000000709097812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a03ULL,
0x00005a0007027a24ULL, 0x000fca00078e0200ULL, 0x00005a0002007a0cULL, 0x000fda0003f26070ULL,
0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL, 0x0000000103031810ULL, 0x000fe40007ffe0ffULL,
0x00005a0002007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff809027812ULL, 0x000fe400078ef80aULL,
0x00000003ff097819ULL, 0x000fc60000011610ULL, 0x0000001002047824ULL, 0x000fe400078e0205ULL,
0x0000000174747824ULL, 0x000fc600078e0209ULL, 0x00000000040c7984ULL, 0x000e620000000c00ULL,
0x0000000103032810ULL, 0x000fc80007ffe0ffULL, 0x0000000306027207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a02ULL, 0x0000590002037a24ULL, 0x000fe400078e026dULL,
0x00005a0007007a24ULL, 0x000fe200078e0200ULL, 0x000000070a077812ULL, 0x000fc600078ec0ffULL,
0x00005a0003037a24ULL, 0x000fe400078e0200ULL, 0x0000000868077824ULL, 0x000fc600078e0207ULL,
0x0000000372037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078240ffULL, 0x00005f0003037a11ULL, 0x000fe400008f4400ULL,
0x000000700900720cULL, 0x000fc60003f26070ULL, 0x0000001007027825ULL, 0x000fca00078e0002ULL,
0x0000000c02007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000007411027227ULL, 0x002fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fe400078e0a02ULL,
0x0000000110097824ULL, 0x000fe400078e0209ULL, 0x00005a0003007a24ULL, 0x000fc600078e0274ULL,
0x0000000709097812ULL, 0x000fe400078ec0ffULL, 0x00005a0000007a0cULL, 0x000fda0003f26070ULL,
0x80005a0000001a10ULL, 0x000fe40007ffe0ffULL, 0x0000000102021810ULL, 0x000fe40007ffe0ffULL,
0x00005a0000007a0cULL, 0x000fe40003f46070ULL, 0xfffffff809007812ULL, 0x000fca00078ef810ULL,
0x0000001000007824ULL, 0x000fca00078e0205ULL, 0x0000000000087984ULL, 0x000e620000000c00ULL,
0x0000000102022810ULL, 0x000fc80007ffe0ffULL, 0x0000000206027207ULL, 0x000fca0004000000ULL,
0x000000ffff057224ULL, 0x000fe400078e0a02ULL, 0x0000590002037a24ULL, 0x000fe400078e026dULL,
0x00005a0005747a24ULL, 0x000fe200078e0274ULL, 0x0000000710057812ULL, 0x000fc600078ec0ffULL,
0x00005a0003037a24ULL, 0x000fe400078e0274ULL, 0x0000000868057824ULL, 0x000fc600078e0205ULL,
0x0000000372037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078040ffULL, 0x00005f0003037a11ULL, 0x000fca00000f4404ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000406617824ULL, 0x000fe200078e0207ULL,
0xffffffff00047802ULL, 0x002fc80000000f00ULL, 0x000000716100720cULL, 0x000fda0003f06070ULL,
0x0000000279008824ULL, 0x000fc800078e00ffULL, 0x00006a00000d8a24ULL, 0x000fc800078e0261ULL,
0x000066000d0c8625ULL, 0x000fe200078e004cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000060c048981ULL, 0x000ea2000c1e1900ULL, 0x0000000106097810ULL, 0x000fe20007ffe0ffULL,
0x00005800ff727624ULL, 0x000fe400078e00ffULL, 0x0000004077777824ULL, 0x000fe200078e00ffULL,
0x000000640900720cULL, 0x000fe20003f06070ULL, 0x00000100ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000001f72727810ULL, 0x000fe20007ffe0ffULL, 0x01360000ff0a7f8cULL, 0x000e62000c80043fULL,
0x0000004007787824ULL, 0x000fc400078e00ffULL, 0x000000406d007824ULL, 0x000fe200078e00ffULL,
0x00000005ff727819ULL, 0x000fe20000011672ULL, 0x0000007704097224ULL, 0x004fc800078e02ffULL,
0x00006400090c7625ULL, 0x000fe200078e000eULL, 0x0000061000008947ULL, 0x000fea0003800000ULL,
0x00000002ff247819ULL, 0x002fe20000011605ULL, 0x0000010006147824ULL, 0x000fe200078e0278ULL,
0x00000005051a7211ULL, 0x000fe400078fe8ffULL, 0x00001000071c7811ULL, 0x000fe200078e68ffULL,
0x000000406d6d7824ULL, 0x000fe200078e0224ULL, 0x0000001463097217ULL, 0x000fe40007800000ULL,
0x000000031a1a7812ULL, 0x000fe200078ec0ffULL, 0x000001006d0e7825ULL, 0x040fe200078e00ffULL,
0x000000106d127810ULL, 0x000fc40007ffe0ffULL, 0x000000086d107810ULL, 0x000fe20007ffe0ffULL,
0x0000000109097824ULL, 0x000fe200078e0a14ULL, 0x000000300e177812ULL, 0x100fe200078ef808ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000000824147810ULL, 0x000fe40007ffe0ffULL,
0x000000170c167210ULL, 0x000fe20007f1e0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x0000003012157812ULL, 0x100fe400078ef808ULL, 0x000000206d127810ULL, 0x000fe20007ffe0ffULL,
0x000000010d177824ULL, 0x000fe200000e060fULL, 0x000000150c0e7210ULL, 0x000fe20007f5e0ffULL,
0x00000004141d7824ULL, 0x000fe200078e00ffULL, 0x0000003010197812ULL, 0x000fc400078ef808ULL,
0x000000186d107810ULL, 0x000fe20007ffe0ffULL, 0x000000010d0f7824ULL, 0x040fe200010e0613ULL,
0x000000190c187210ULL, 0x000fe20007f3e0ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000092400720cULL, 0x080fe40003f06070ULL, 0x0ffffffc1a057812ULL, 0x000fe200078ef805ULL,
0x000000010d197824ULL, 0x000fe200008e0611ULL, 0x0000003012157812ULL, 0x000fe200078ef808ULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x000000091400720cULL, 0x000fc40003f26070ULL,
0x000000150c127210ULL, 0x000fe20007f7e0ffULL, 0x0000001005057824ULL, 0x000fe200078e021cULL,
0x00000030101b7812ULL, 0x000fe400078ef808ULL, 0xfffffffc1d157812ULL, 0x000fe200078ee21aULL,
0x000000010d137824ULL, 0x000fe200018e0613ULL, 0x000000286d147810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016057faeULL, 0x0003e2000c101c46ULL,
0x0000001b0c107210ULL, 0x000fe20007f5e0ffULL, 0x00000010151b7824ULL, 0x000fe200078e021cULL,
0x0000001024267810ULL, 0x000fe20007ffe0ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000001824287810ULL, 0x000fc40007ffe0ffULL, 0x00000000181b7faeULL, 0x0005e2000c901c46ULL,
0x00000020241e7810ULL, 0x000fe20007ffe0ffULL, 0x000000010d117824ULL, 0x000fe200010e0611ULL,
0x00000030141d7812ULL, 0x000fe400078ef808ULL, 0x000000306d147810ULL, 0x040fe20007ffe0ffULL,
0x0000000426057824ULL, 0x002fe200078e00ffULL, 0x0000002824207810ULL, 0x040fe40007ffe0ffULL,
0x0000003024227810ULL, 0x040fe40007ffe0ffULL, 0x0000003824247810ULL, 0x000fe20007ffe0ffULL,
0x00000004201f7824ULL, 0x000fe200078e00ffULL, 0x0000001d0c187210ULL, 0x004fe20007fde0ffULL,
0x0000000422217824ULL, 0x000fe200078e00ffULL, 0x000000386d167810ULL, 0x000fe20007ffe0ffULL,
0x0000000424237824ULL, 0x000fe200078e00ffULL, 0x000000092600720cULL, 0x080fe20003fa6070ULL,
0x000000010d197824ULL, 0x000fe200030e0615ULL, 0x000000092800720cULL, 0x080fe20003f86070ULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x000000091e00720cULL, 0x000fc40003f66070ULL,
0x000000092000720cULL, 0x080fe20003f46070ULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x000000092200720cULL, 0x080fe40003f26070ULL, 0x000000092400720cULL, 0x000fe20003f06070ULL,
0x0000000428097824ULL, 0x000fe200078e00ffULL, 0x00000030141b7812ULL, 0x000fe400078ef808ULL,
0x000000021e1d7819ULL, 0x000fe400000006ffULL, 0x0000001b0c147210ULL, 0x000fc40007fde0ffULL,
0xfffffffc05057812ULL, 0x100fe400078ee21aULL, 0xfffffffc09097812ULL, 0x000fe200078ee21aULL,
0x000000010d157824ULL, 0x000fe200030e0615ULL, 0x0000003016257812ULL, 0x000fe200078ef808ULL,
0x0000001005057824ULL, 0x000fe200078e021cULL, 0xfffffffc1d1d7812ULL, 0x000fe200078ee21aULL,
0x00000010091b7824ULL, 0x000fe200078e021cULL, 0xfffffffc1f1f7812ULL, 0x100fe400078ee21aULL,
0xfffffffc21217812ULL, 0x000fe200078ee21aULL, 0x000000101d1d7824ULL, 0x000fe200078e021cULL,
0xfffffffc23237812ULL, 0x000fe200078ee21aULL, 0x000000101f1f7824ULL, 0x100fe200078e021cULL,
0x000000250c087210ULL, 0x000fe20007fde0ffULL, 0x0000001021217824ULL, 0x100fe200078e021cULL,
0x000000000e057faeULL, 0x0003e2000e901c46ULL, 0x0000001023237824ULL, 0x000fc400078e021cULL,
0x000000010d097824ULL, 0x000fe200030e0617ULL, 0x00000000101b7faeULL, 0x0003e8000e101c46ULL,
0x00000000121d7faeULL, 0x0003e8000d901c46ULL, 0x00000000181f7faeULL, 0x0003e8000d101c46ULL,
0x0000000014217faeULL, 0x0003e8000c901c46ULL, 0x0000000008237faeULL, 0x0003e2000c101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000000805137811ULL, 0x042fe400078ff0ffULL,
0x00000005050f7211ULL, 0x000fc400078fe8ffULL, 0x00000000050e7211ULL, 0x000fe200078ff0ffULL,
0x0000000413157824ULL, 0x000fe200078e00ffULL, 0x0000001005097811ULL, 0x040fe200078ff0ffULL,
0x0000000100107824ULL, 0x000fe200078e0213ULL, 0x0000001805117811ULL, 0x040fe400078ff0ffULL,
0x0000002005177811ULL, 0x000fe200078ff0ffULL, 0x00000004091b7824ULL, 0x000fe200078e00ffULL,
0x0000002805197811ULL, 0x000fe200078ff0ffULL, 0x00000004111f7824ULL, 0x000fe200078e00ffULL,
0x0000003005277811ULL, 0x000fe200078ff0ffULL, 0x0000000417217824ULL, 0x000fe200078e00ffULL,
0x000000030f1c7812ULL, 0x000fe200078ec0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x00000038052b7811ULL, 0x000fc400078ff0ffULL, 0x0000000900127210ULL, 0x000fe20007ffe0ffULL,
0x0000000419237824ULL, 0x000fe200078e00ffULL, 0x0ffffffc1c1d7812ULL, 0x000fe200078ef805ULL,
0x0000000427257824ULL, 0x000fe200078e00ffULL, 0xfffffffc15057812ULL, 0x000fe200078ee21cULL,
0x000000042b297824ULL, 0x000fe200078e00ffULL, 0x00001000072d7811ULL, 0x000fe200078e68ffULL,
0x0000000100157824ULL, 0x000fe200078e0211ULL, 0x000000300e097812ULL, 0x000fe200078ef808ULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0xfffffffc1b147812ULL, 0x000fc400078ee21cULL,
0xfffffffc1f167812ULL, 0x100fe200078ee21cULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0xfffffffc21187812ULL, 0x100fe400078ee21cULL, 0xfffffffc231a7812ULL, 0x100fe200078ee21cULL,
0x000000101d317824ULL, 0x100fe200078e022dULL, 0xfffffffc251b7812ULL, 0x100fe200078ee21cULL,
0x0000001005057824ULL, 0x100fe200078e022dULL, 0xfffffffc291c7812ULL, 0x000fe200078ee21cULL,
0x00000010141f7824ULL, 0x100fe200078e022dULL, 0x000000090c0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000001016217824ULL, 0x100fe200078e022dULL, 0x0000003010097812ULL, 0x100fe200078ef808ULL,
0x0000001018237824ULL, 0x100fe200078e022dULL, 0x00000030121d7812ULL, 0x000fe200078ef808ULL,
0x000000101a257824ULL, 0x100fe200078e022dULL, 0x000000090c1a7210ULL, 0x000fe20007f3e0ffULL,
0x000000101b297824ULL, 0x000fc400078e022dULL, 0x000000101c2d7824ULL, 0x000fe200078e022dULL,
0x0000001d0c1c7210ULL, 0x000fe20007f5e0ffULL, 0x0000010015147825ULL, 0x000fc800078e00ffULL,
0x0000000100107824ULL, 0x000fe200078e0217ULL, 0x0000003014097812ULL, 0x000fe200078ef808ULL,
0x0000000100127824ULL, 0x040fe400078e0219ULL, 0x0000000100167824ULL, 0x040fe400078e0227ULL,
0x000000010d1b7824ULL, 0x040fe400008e0611ULL, 0x0000000100187824ULL, 0x000fe400078e022bULL,
0x000000010d1d7824ULL, 0x000fc400010e0613ULL, 0x0000010010107825ULL, 0x000fc800078e00ffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x00000030102f7812ULL, 0x000fc600078ef808ULL,
0x000000010d0f7824ULL, 0x040fe200000e060fULL, 0x000000090c147210ULL, 0x000fe20007f1e0ffULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x00000030122b7812ULL, 0x100fe400078ef808ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e317faeULL, 0x0003e2000b901c46ULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x0000003016277812ULL, 0x100fe400078ef808ULL,
0x0000002b0c107210ULL, 0x000fe20007f3e0ffULL, 0x000000010d157824ULL, 0x000fe200000e0615ULL,
0x0000003018097812ULL, 0x000fe200078ef808ULL, 0x000000001a057faeULL, 0x0003e2000b901c46ULL,
0x0000002f0c087210ULL, 0x000fc40007f1e0ffULL, 0x000000270c127210ULL, 0x040fe20007f5e0ffULL,
0x000000001c1f7faeULL, 0x0003e2000b901c46ULL, 0x000000090c0c7210ULL, 0x000fe20007f7e0ffULL,
0x000000010d097824ULL, 0x040fe400000e0611ULL, 0x000000010d117824ULL, 0x040fe200008e0613ULL,
0x000000170d137210ULL, 0x040fe200017fe4ffULL, 0x000000010d0d7824ULL, 0x000fe200018e0619ULL,
0x0000000014217faeULL, 0x0003e8000b901c46ULL, 0x0000000008237faeULL, 0x0003e8000b901c46ULL,
0x0000000010257faeULL, 0x0003e8000b901c46ULL, 0x0000000012297faeULL, 0x0003e8000b901c46ULL,
0x000000000c2d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fc40000015200ULL, 0x01360400ff057984ULL, 0x000e620000000800ULL,
0x00000072034d7224ULL, 0x000fc400078e02ffULL, 0x0000000163737824ULL, 0x000fe200078e0a02ULL,
0x8000000005ff7812ULL, 0x002fe2000780480bULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000ff00000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000062004d4c7625ULL, 0x000fe200078e004cULL, 0x00000008ff737819ULL, 0x000fe20000011673ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c080c7210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e09ULL,
0x003d09000c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001140dULL, 0x0000000c03037211ULL, 0x000fca00078110ffULL,
0x000000ffff0c7224ULL, 0x000fca00000e060dULL, 0x0000000203037819ULL, 0x000fc8000000120cULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000105057810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01360400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000640600720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000707919ULL, 0x000e620000000000ULL,
0x00006a0079797a24ULL, 0x000fe200078e02ffULL, 0x0001368807757811ULL, 0x040fe200078e18ffULL,
0x0000000272727824ULL, 0x000fe200078e00ffULL, 0xffffffff024f7810ULL, 0x040fe20007ffe0ffULL,
0x0000002007767824ULL, 0x000fe200078e00ffULL, 0x0000000902607810ULL, 0x000fc40007ffe0ffULL,
0x0000000106037810ULL, 0x040fe20007ffe0ffULL, 0x00000100ff6e7424ULL, 0x000fe200078e00ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000477137224ULL, 0x000fe200078e02ffULL,
0x000000640300720cULL, 0x000fe20003f06070ULL, 0x00000100064e7824ULL, 0x000fc400078e0278ULL,
0x0000640013127625ULL, 0x000fd400078e006eULL, 0x0000064000008947ULL, 0x00cfea0003800000ULL,
0x00000002ff1c7819ULL, 0x002fe20000011670ULL, 0x0000001070117824ULL, 0x040fe200078e00ffULL,
0x0ffffffc70107812ULL, 0x000fe400078ec0ffULL, 0x000000201c227810ULL, 0x000fe20007ffe0ffULL,
0x0000000100047824ULL, 0x000fe200078e021cULL, 0x000000081c1d7810ULL, 0x000fe40007ffe0ffULL,
0x0000003011117812ULL, 0x000fe200078ec0ffULL, 0x00000001000e7824ULL, 0x000fe200078e0222ULL,
0x000000101c1e7810ULL, 0x000fe20007ffe0ffULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x00000040111b7812ULL, 0x000fc400078efcffULL, 0x000000181c207810ULL, 0x000fe20007ffe0ffULL,
0x0000000100087824ULL, 0x000fe200078e021dULL, 0x0000001b04157212ULL, 0x000fe200078efcffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x00002000071a7811ULL, 0x000fe400078e68ffULL,
0x0000001512147210ULL, 0x000fe20007f3e0ffULL, 0x00000001000a7824ULL, 0x000fe200078e021eULL,
0x0000001b0e037212ULL, 0x000fe200078efcffULL, 0x0000010008087825ULL, 0x000fc800078e00ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000001b08177212ULL, 0x000fe400078efcffULL,
0x0000000312087210ULL, 0x000fe20007f7e0ffULL, 0x00000001000c7824ULL, 0x000fe200078e0220ULL,
0x0000001b0a197212ULL, 0x000fe200078efcffULL, 0x0000000113157824ULL, 0x000fe200008e0605ULL,
0x0000004e63037217ULL, 0x000fe20007800000ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x00000070700a7211ULL, 0x000fe400078fe8ffULL, 0x0000001712167210ULL, 0x040fe20007f3e0ffULL,
0x0000000103037824ULL, 0x000fe200078e0a4eULL, 0x0000001912187210ULL, 0x000fc40007f5e0ffULL,
0x000000030a217812ULL, 0x000fe200078ec0ffULL, 0x000000041d0a7824ULL, 0x000fe200078e00ffULL,
0x0000001b0c057212ULL, 0x000fe200078efcffULL, 0x0000000113177824ULL, 0x040fe200008e0609ULL,
0x000000281c0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000113197824ULL, 0x000fe200010e060bULL,
0x0000000512047210ULL, 0x000fe40007f3e0ffULL, 0x000000031d00720cULL, 0x000fe40003f46070ULL,
0xfffffffc0a1d7812ULL, 0x000fe200078ee221ULL, 0x00000001000a7824ULL, 0x000fe200078e020cULL,
0x0000000f13097210ULL, 0x040fe20001ffe4ffULL, 0x0000000113057824ULL, 0x000fe200008e060dULL,
0x000000031e00720cULL, 0x0c0fe20003f66070ULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x000000031c00720cULL, 0x000fe20003f26070ULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x00000010210d7212ULL, 0x000fc400078efcffULL, 0xfffffffc1e1f7812ULL, 0x000fe200078ee221ULL,
0x000000101d1d7824ULL, 0x100fe200078e021aULL, 0x0000001b0a0f7212ULL, 0x000fe200078efcffULL,
0x000000100d0d7824ULL, 0x100fe200078e021aULL, 0x000000301c1e7810ULL, 0x000fe20007ffe0ffULL,
0x000000101f1f7824ULL, 0x000fe200078e021aULL, 0x0000000f120e7210ULL, 0x000fe40007fde0ffULL,
0x000000381c1c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001000a7824ULL, 0x000fe200078e021eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e2000c901c46ULL,
0x00000001130f7824ULL, 0x000fe200030e060bULL, 0x000000032000720cULL, 0x080fe20003fa6070ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x00000000161d7faeULL, 0x0005e2000d101c46ULL,
0x000000032200720cULL, 0x000fc40003f86070ULL, 0x000000031e00720cULL, 0x080fe20003f46070ULL,
0x00000000181f7faeULL, 0x0007e2000d901c46ULL, 0x000000030c00720cULL, 0x080fe20003f66070ULL,
0x0000000420207824ULL, 0x000fe200078e00ffULL, 0x000000031c00720cULL, 0x000fe20003f26070ULL,
0x000000040c147824ULL, 0x002fe200078e00ffULL, 0x0000001b0a037212ULL, 0x000fe200078efcffULL,
0x00000001000c7824ULL, 0x000fe200078e021cULL, 0xfffffffc20157812ULL, 0x100fe200078ee221ULL,
0x0000000422227824ULL, 0x000fe200078e00ffULL, 0x00000003120a7210ULL, 0x000fe20007fde0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffffc14197812ULL, 0x008fc600078ee221ULL,
0x000000041e1e7824ULL, 0x000fe200078e00ffULL, 0x0000001b0c1b7212ULL, 0x000fe200078efcffULL,
0x000000041c1c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc22177812ULL, 0x004fe200078ee221ULL,
0x00000001130b7824ULL, 0x000fe200030e060bULL, 0xfffffffc1e1d7812ULL, 0x100fe200078ee221ULL,
0x0000001015037824ULL, 0x100fe200078e021aULL, 0xfffffffc1c217812ULL, 0x000fe200078ee221ULL,
0x0000001017157824ULL, 0x100fe200078e021aULL, 0x0000001b120c7210ULL, 0x000fe20007fde0ffULL,
0x0000001019177824ULL, 0x100fe200078e021aULL, 0x0000001a1d197211ULL, 0x000fe200078e20ffULL,
0x00000010211b7824ULL, 0x000fe200078e021aULL, 0x0000000004037faeULL, 0x0003e2000e901c46ULL,
0x00000001130d7824ULL, 0x000fc600030e060dULL, 0x0000000008157faeULL, 0x0003e8000e101c46ULL,
0x000000000e177faeULL, 0x0003e8000d901c46ULL, 0x000000000a197faeULL, 0x0003e8000d101c46ULL,
0x000000000c1b7faeULL, 0x0003e2000c901c46ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x0000000870057811ULL, 0x042fe200078ff0ffULL, 0x0000001070117824ULL, 0x040fe200078e00ffULL,
0x0000001070097811ULL, 0x000fc400078ff0ffULL, 0x00000018700b7811ULL, 0x040fe200078ff0ffULL,
0x0000000405147824ULL, 0x000fe200078e00ffULL, 0x0000002070177811ULL, 0x040fe200078ff0ffULL,
0x0000000409167824ULL, 0x000fe200078e00ffULL, 0x0000002870197811ULL, 0x040fe200078ff0ffULL,
0x000000040b187824ULL, 0x000fe200078e00ffULL, 0x0000003070297811ULL, 0x040fe200078ff0ffULL,
0x00000004171a7824ULL, 0x000fe200078e00ffULL, 0x00000038702b7811ULL, 0x040fe200078ff0ffULL,
0x00000004191c7824ULL, 0x000fe200078e00ffULL, 0x0000007070037211ULL, 0x040fe200078fe8ffULL,
0x00000004291e7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc70107812ULL, 0x000fe200078ec0ffULL,
0x000000042b207824ULL, 0x000fe200078e00ffULL, 0x0000000303037812ULL, 0x000fe200078ec0ffULL,
0x00000001000a7824ULL, 0x040fe200078e0209ULL, 0x0000003011117812ULL, 0x000fe200078ec0ffULL,
0x00000001000e7824ULL, 0x000fe200078e020bULL, 0xfffffffc140d7812ULL, 0x100fe200078ee203ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc161b7812ULL, 0x000fc400078ee203ULL,
0xfffffffc181d7812ULL, 0x000fe200078ee203ULL, 0x0000000100087824ULL, 0x000fe200078e0205ULL,
0xfffffffc1a1f7812ULL, 0x000fe200078ee203ULL, 0x0000000100147824ULL, 0x000fe200078e0219ULL,
0xfffffffc1c217812ULL, 0x100fe200078ee203ULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0xfffffffc1e237812ULL, 0x100fe400078ee203ULL, 0xfffffffc20257812ULL, 0x000fe200078ee203ULL,
0x0000000100167824ULL, 0x040fe200078e0229ULL, 0x00002000070c7811ULL, 0x000fe200078e68ffULL,
0x0000000100187824ULL, 0x000fe200078e022bULL, 0x0000001003037212ULL, 0x000fc400078efcffULL,
0x0000000070047211ULL, 0x000fe200078ff0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e020cULL,
0x0000004011277812ULL, 0x000fe200078efcffULL, 0x00000010032f7824ULL, 0x000fe200078e020cULL,
0x0000000c23237211ULL, 0x000fe200078e20ffULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x00000027080f7212ULL, 0x000fc600078efcffULL, 0x000000100d037824ULL, 0x100fe200078e020cULL,
0x000000270a0d7212ULL, 0x080fe200078efcffULL, 0x000000101d1d7824ULL, 0x100fe200078e020cULL,
0x0000002704157212ULL, 0x000fe200078efcffULL, 0x000000101f1f7824ULL, 0x100fe200078e020cULL,
0x0000000d120a7210ULL, 0x040fe20007f7e0ffULL, 0x0000001021217824ULL, 0x100fe200078e020cULL,
0x0000001512047210ULL, 0x040fe20007f3e0ffULL, 0x0000001025257824ULL, 0x000fe200078e020cULL,
0x0000000f12087210ULL, 0x000fe20007f5e0ffULL, 0x000001000e0c7825ULL, 0x000fc800078e00ffULL,
0x00000001000e7824ULL, 0x000fe200078e0217ULL, 0x000000270c157212ULL, 0x000fe200078efcffULL,
0x0000000105057824ULL, 0x000fe400008e0613ULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x00000015120c7210ULL, 0x000fe40007f3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000042f7faeULL, 0x0003e2000b901c46ULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x000000270e2d7212ULL, 0x000fc600078efcffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x00000027142b7212ULL, 0x000fc600078efcffULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x0000002716297212ULL, 0x000fc600078efcffULL, 0x000000010d0d7824ULL, 0x100fe200008e0613ULL,
0x0000002718277212ULL, 0x000fe200078efcffULL, 0x0000000109097824ULL, 0x100fe200010e0613ULL,
0x0000002d120e7210ULL, 0x040fe20007f3e0ffULL, 0x000000010b0b7824ULL, 0x100fe200018e0613ULL,
0x0000002b12147210ULL, 0x040fe40007f5e0ffULL, 0x0000002912167210ULL, 0x040fe20007f7e0ffULL,
0x000000010f0f7824ULL, 0x100fe200008e0613ULL, 0x0000002712187210ULL, 0x000fe20007f9e0ffULL,
0x0000000115157824ULL, 0x100fe200010e0613ULL, 0x0000000008037faeULL, 0x0003e2000b901c46ULL,
0x0000000117177824ULL, 0x000fc400018e0613ULL, 0x0000000119197824ULL, 0x000fe200020e0613ULL,
0x000000000a1b7faeULL, 0x0003e8000b901c46ULL, 0x000000000c1d7faeULL, 0x0003e8000b901c46ULL,
0x000000000e1f7faeULL, 0x0003e8000b901c46ULL, 0x0000000014217faeULL, 0x0003e8000b901c46ULL,
0x0000000016237faeULL, 0x0003e8000b901c46ULL, 0x0000000018257faeULL, 0x0003e4000b901c46ULL,
0x00000004ff037819ULL, 0x102fe20000011670ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000770097812ULL, 0x000fe200078ec0ffULL, 0x00002000070f7824ULL, 0x000fe200078e00ffULL,
0x00000003ff507819ULL, 0x100fe20000011670ULL, 0x0000000803047824ULL, 0x000fe200078e00ffULL,
0x0000000809627812ULL, 0x000fc400078ef870ULL, 0x000010000f0d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff804057812ULL, 0x000fe200078ee209ULL, 0x00000001030e7824ULL, 0x000fe200078e0262ULL,
0x0000000150047812ULL, 0x000fe200078ec0ffULL, 0x0000001062037824ULL, 0x040fe200078e00ffULL,
0x00000010051d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000405097824ULL, 0x040fe200078e00ffULL,
0x0000000405087211ULL, 0x040fe200078ff8ffULL, 0x0000001062237824ULL, 0x000fe200078e00ffULL,
0x00000020051f7810ULL, 0x000fe20007ffe0ffULL, 0x000000041d0a7824ULL, 0x000fe200078e00ffULL,
0x0000003005217810ULL, 0x000fe20007ffe0ffULL, 0x000000041d207824ULL, 0x000fe200078e00ffULL,
0x0000000205257819ULL, 0x000fc400000006ffULL, 0xfffffffc090c7812ULL, 0x000fe200078ee208ULL,
0x000000041f097824ULL, 0x000fe200078e00ffULL, 0x000000041d057211ULL, 0x080fe200078ff8ffULL,
0x0000000421157824ULL, 0x000fe200078e00ffULL, 0x000000041f1c7211ULL, 0x080fe200078ff8ffULL,
0x000000100c5c7824ULL, 0x000fe200078e020dULL, 0x0000000421047211ULL, 0x000fe200078ff8ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffffc0a0b7812ULL, 0x000fe200078ee205ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0xfffffff003037812ULL, 0x000fe200078ee20eULL,
0x000000005c34783bULL, 0x000fe20000000200ULL, 0xfffffffc090a7812ULL, 0x000fe200078ee21cULL,
0x000000100b5d7824ULL, 0x100fe200078e020dULL, 0xfffffffc15097812ULL, 0x000fe200078ee204ULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0x0000000205057810ULL, 0x000fe20007ffe0ffULL,
0x000000100a657824ULL, 0x100fe200078e020dULL, 0x000000005d3c783bULL, 0x000fe20000000200ULL,
0x0000001009667824ULL, 0x000fe200078e020dULL, 0xfffffffc20057812ULL, 0x000fe200078ee205ULL,
0x000000041f1f7824ULL, 0x000fe200078e00ffULL, 0x000000000314783bULL, 0x0002a20000000200ULL,
0x000000020e1e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000421207824ULL, 0x000fe200078e00ffULL,
0x0000000208087810ULL, 0x000fe20007ffe0ffULL, 0x000000006544783bULL, 0x000ee20000000200ULL,
0x000000021c1c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001005697824ULL, 0x000fe200078e020dULL,
0xfffffff0231e7812ULL, 0x000fe200078ee21eULL, 0x000000006618783bULL, 0x000f220000000200ULL,
0x0000000204037810ULL, 0x002fc40007ffe0ffULL, 0xfffffffc25087812ULL, 0x000fe200078ee208ULL,
0x000000101e1e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1f047812ULL, 0x000fe200078ee21cULL,
0x000000006924783bULL, 0x000fe20000000200ULL, 0xfffffffc20037812ULL, 0x000fe200078ee203ULL,
0x0000001008677824ULL, 0x100fe400078e020dULL, 0x00000010046b7824ULL, 0x100fe200078e020dULL,
0x000000001e1c783bULL, 0x000fe20000000200ULL, 0x00000010036c7824ULL, 0x000fc600078e020dULL,
0x000000006720783bULL, 0x000e680000000200ULL, 0x000000006b28783bULL, 0x000e680000000200ULL,
0x000000006c2c783bULL, 0x000e620000000200ULL, 0x000000341430723cULL, 0x044f7000000018ffULL,
0x0000003c1438723cULL, 0x040ff000000018ffULL, 0x000000441440723cULL, 0x048ff000000018ffULL,
0x000000361434723cULL, 0x040f7000000018ffULL, 0x0000003e143c723cULL, 0x040f7000000018ffULL,
0x000000461444723cULL, 0x040f7000000018ffULL, 0x000000181448723cULL, 0x050f7000000018ffULL,
0x0000001a1414723cULL, 0x000f7000000018ffULL, 0x000000201c30723cULL, 0x062b700000001830ULL,
0x000000221c34723cULL, 0x040b700000001834ULL, 0x000000241c38723cULL, 0x040b700000001838ULL,
0x000000261c3c723cULL, 0x040b70000000183cULL, 0x000000281c40723cULL, 0x040b700000001840ULL,
0x0000002a1c44723cULL, 0x040b700000001844ULL, 0x0000002c1c48723cULL, 0x040b700000001848ULL,
0x0000002e1c1c723cULL, 0x000b620000001814ULL, 0x0000059000008947ULL, 0x000fce0003800000ULL,
0x00000002ff2d7819ULL, 0x120fe20000011670ULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x0000008011227812ULL, 0x000fe200078efcffULL, 0x0000000150507824ULL, 0x000fe200078e0270ULL,
0x000000082d577810ULL, 0x040fe20007ffe0ffULL, 0x0000000100177824ULL, 0x000fe200078e022dULL,
0x000000102d557810ULL, 0x000fc40007ffe0ffULL, 0x00000057001b7210ULL, 0x040fe20007ffe0ffULL,
0x0000010017167825ULL, 0x000fe200078e0022ULL, 0x000000202d517810ULL, 0x000fe40007ffe0ffULL,
0x0000004e63157217ULL, 0x000fe20007800000ULL, 0x0000000100217824ULL, 0x040fe200078e0255ULL,
0x000000282d2f7810ULL, 0x000fe20007ffe0ffULL, 0x000001001b1a7825ULL, 0x000fe200078e0022ULL,
0x000000182d537810ULL, 0x040fe40007ffe0ffULL, 0x000000302d2b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100277824ULL, 0x000fe200078e0251ULL, 0x0000001a121a7210ULL, 0x040fe20007f7e0ffULL,
0x00000001152a7824ULL, 0x000fe200078e0a4eULL, 0x0000001612167210ULL, 0x000fe20007f5e0ffULL,
0x0000010021207825ULL, 0x000fc600078e0022ULL, 0x0000002a2d00720cULL, 0x000fe20003f26070ULL,
0x0000000100157824ULL, 0x000fe200078e022fULL, 0x0000002012207210ULL, 0x000fe20007f9e0ffULL,
0x0000010027267825ULL, 0x100fe200078e0022ULL, 0x000000382d2d7810ULL, 0x000fe40007ffe0ffULL,
0x0000002a2b00720cULL, 0x080fe20003fa6070ULL, 0x0000010015147825ULL, 0x000fe200078e0022ULL,
0x0000002a2d00720cULL, 0x000fc60003fc6070ULL, 0x00000001131b7824ULL, 0x040fe200018e061bULL,
0x0000002612267210ULL, 0x000fe20007f7e0ffULL, 0x0000000100257824ULL, 0x040fe400078e0253ULL,
0x0000000100197824ULL, 0x000fe400078e022bULL, 0x0000000113217824ULL, 0x040fe200020e0621ULL,
0x0000001412287210ULL, 0x000fe20007f9e0ffULL, 0x0000000100297824ULL, 0x000fe200078e022dULL,
0x0000000350147812ULL, 0x000fe200078ec0ffULL, 0x0000000113277824ULL, 0x000fe200018e0627ULL,
0x0000002a5700720cULL, 0x000fe20003f66070ULL, 0x0000010025247825ULL, 0x000fe200078e0022ULL,
0x0000001014107212ULL, 0x000fc600078efcffULL, 0x0000010019187825ULL, 0x000fc800078e0022ULL,
0x0000000457577824ULL, 0x000fe400078e00ffULL, 0x0000010029227825ULL, 0x000fc600078e0022ULL,
0xfffffffc572c7812ULL, 0x100fe200078ee214ULL, 0x0000000113297824ULL, 0x000fe200020e0615ULL,
0x0000002a5500720cULL, 0x040fe20003f86070ULL, 0x0000000455557824ULL, 0x000fe400078e00ffULL,
0x0000000113177824ULL, 0x000fe200010e0617ULL, 0x0000002412247210ULL, 0x000fe20007f5e0ffULL,
0x0000001010157824ULL, 0x100fe200078e020dULL, 0xfffffffc552e7812ULL, 0x100fe200078ee214ULL,
0x000000102c557824ULL, 0x000fe400078e020dULL, 0x0000000113257824ULL, 0x000fe200010e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016157faeULL, 0x0003e2000c901c46ULL,
0x000000102e577824ULL, 0x000fe200078e020dULL, 0x0000002a5300720cULL, 0x080fe20003f26070ULL,
0x000000042b2b7824ULL, 0x000fe200078e00ffULL, 0x000000001a557faeULL, 0x0005e2000d901c46ULL,
0x0000002a5100720cULL, 0x040fe20003f66070ULL, 0x0000000451517824ULL, 0x000fe200078e00ffULL,
0x0000000253537819ULL, 0x000fe200000006ffULL, 0x0000000020577faeULL, 0x0007e2000e101c46ULL,
0x0000001812187210ULL, 0x040fe20007f5e0ffULL, 0x000000042d2d7824ULL, 0x000fe200078e00ffULL,
0x0000002a2f00720cULL, 0x040fe20003f86070ULL, 0x000000042f2f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc532c7812ULL, 0x000fe200078ee214ULL, 0x0000000113197824ULL, 0x000fe200010e0619ULL,
0x0000002212167210ULL, 0x002fc40007f5e0ffULL, 0xfffffffc511a7812ULL, 0x104fe200078ee214ULL,
0x000000102c537824ULL, 0x000fe200078e020dULL, 0xfffffffc2d227812ULL, 0x100fe200078ee214ULL,
0x0000000113177824ULL, 0x000fe200010e0623ULL, 0xfffffffc2f207812ULL, 0x108fe200078ee214ULL,
0x000000101a1b7824ULL, 0x100fe200078e020dULL, 0xfffffffc2b1a7812ULL, 0x000fe200078ee214ULL,
0x0000000024537faeULL, 0x0003e4000c901c46ULL, 0x0000001020217824ULL, 0x100fe400078e020dULL,
0x000000101a237824ULL, 0x100fe200078e020dULL, 0x00000000261b7faeULL, 0x0005e8000d901c46ULL,
0x0000000028217faeULL, 0x0005e2000e101c46ULL, 0x0000001022257824ULL, 0x002fc600078e020dULL,
0x0000000018237faeULL, 0x0005e8000e901c46ULL, 0x0000000016257faeULL, 0x0005e2000f101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x0000000870577811ULL, 0x000fe200078ff0ffULL,
0x000000ffff297224ULL, 0x020fe200078e00ffULL, 0x0000008011287812ULL, 0x000fe200078efcffULL,
0x0000000150507824ULL, 0x000fe200078e0270ULL, 0x0000002070517811ULL, 0x000fe200078ff0ffULL,
0x0000000100197824ULL, 0x000fe200078e0257ULL, 0x00000030702b7811ULL, 0x040fe200078ff0ffULL,
0x0000000457577824ULL, 0x000fe200078e00ffULL, 0x0000000070177211ULL, 0x040fe200078ff0ffULL,
0x0000010019187825ULL, 0x000fe200078e0028ULL, 0x0000001870537811ULL, 0x000fc400078ff0ffULL,
0x0000001070557811ULL, 0x000fe200078ff0ffULL, 0x0000000100237824ULL, 0x000fe200078e0251ULL,
0x0000001812187210ULL, 0x000fe20007f5e0ffULL, 0x0000000100157824ULL, 0x000fe200078e022bULL,
0x00000028702f7811ULL, 0x040fe200078ff0ffULL, 0x0000010023227825ULL, 0x100fe200078e0028ULL,
0x0000001913197210ULL, 0x000fe400017fe4ffULL, 0x00000038702d7811ULL, 0x000fe200078ff0ffULL,
0x0000010015147825ULL, 0x000fe200078e0028ULL, 0x0000002212227210ULL, 0x000fc60007f5e0ffULL,
0x0000010017167825ULL, 0x000fc800078e0028ULL, 0x0000000113237824ULL, 0x000fe200010e0623ULL,
0x0000001412267210ULL, 0x000fe20007f5e0ffULL, 0x0000000100217824ULL, 0x000fe200078e0253ULL,
0x0000000350147812ULL, 0x000fe200078ec0ffULL, 0x00000001001b7824ULL, 0x000fe200078e0255ULL,
0x0000001612167210ULL, 0x000fe20007f3e0ffULL, 0x0000010021207825ULL, 0x000fe200078e0028ULL,
0xfffffffc572a7812ULL, 0x000fe400078ee214ULL, 0x0000001014107212ULL, 0x000fe200078efcffULL,
0x0000000453577824ULL, 0x000fc400078e00ffULL, 0x0000000100257824ULL, 0x040fe400078e022fULL,
0x0000000100277824ULL, 0x000fe400078e022dULL, 0x0000000113177824ULL, 0x000fe200008e0617ULL,
0x0000002012207210ULL, 0x000fe20007f3e0ffULL, 0x000000102a537824ULL, 0x000fe200078e020dULL,
0xfffffffc572a7812ULL, 0x000fe200078ee214ULL, 0x000001001b1a7825ULL, 0x000fc800078e0028ULL,
0x0000000455557824ULL, 0x000fe200078e00ffULL, 0x0000001a121a7210ULL, 0x000fe20007f7e0ffULL,
0x0000010025247825ULL, 0x000fc600078e0028ULL, 0xfffffffc552c7812ULL, 0x000fe200078ee214ULL,
0x0000000451517824ULL, 0x000fe400078e00ffULL, 0x0000010027287825ULL, 0x000fc800078e0028ULL,
0x0000000113277824ULL, 0x040fe400010e0615ULL, 0x0000001010157824ULL, 0x000fe400078e020dULL,
0x0000000113217824ULL, 0x000fe200008e0621ULL, 0x0000002412247210ULL, 0x000fe20007f3e0ffULL,
0x000000102a577824ULL, 0x000fe200078e020dULL, 0xfffffffc512a7812ULL, 0x000fe200078ee214ULL,
0x000000042f2f7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016157faeULL, 0x0003e2000b901c46ULL, 0x000000042b2b7824ULL, 0x000fc400078e00ffULL,
0x000000042d2d7824ULL, 0x000fe200078e00ffULL, 0x0000000018537faeULL, 0x0005e2000b901c46ULL,
0x00000001131b7824ULL, 0x040fe400018e061bULL, 0x000000102c557824ULL, 0x000fe400078e020dULL,
0x0000000113257824ULL, 0x000fe200008e0625ULL, 0x0000002812287210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc2f167812ULL, 0x102fe200078ee214ULL, 0x000000102a177824ULL, 0x000fe200078e020dULL,
0xfffffffc2d2a7812ULL, 0x100fe200078ee214ULL, 0x000000001a557faeULL, 0x0003e2000b901c46ULL,
0xfffffffc2b187812ULL, 0x004fe200078ee214ULL, 0x0000000113297824ULL, 0x000fe200008e0629ULL,
0x0000000d16197211ULL, 0x000fe200078e20ffULL, 0x0000000020577faeULL, 0x0005e8000b901c46ULL,
0x0000000022177faeULL, 0x0007e2000b901c46ULL, 0x00000010181b7824ULL, 0x002fc600078e020dULL,
0x0000000024197faeULL, 0x0007e2000b901c46ULL, 0x000000102a217824ULL, 0x004fc600078e020dULL,
0x00000000261b7faeULL, 0x0007e8000b901c46ULL, 0x0000000028217faeULL, 0x0007e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001062177824ULL, 0x00cfe200078e00ffULL,
0x000000040e167810ULL, 0x000fe40007ffe0ffULL, 0x000020000f0f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff017167812ULL, 0x000fc600078ee216ULL, 0x000000100c6a7824ULL, 0x100fe400078e020fULL,
0x0000001016167824ULL, 0x000fe400078e00ffULL, 0x000000100b687824ULL, 0x100fe400078e020fULL,
0x000000100a6d7824ULL, 0x100fe400078e020fULL, 0x0000001009177824ULL, 0x000fe200078e020fULL,
0x000000060e097810ULL, 0x000fe20007ffe0ffULL, 0x00000010620a7824ULL, 0x000fc400078e00ffULL,
0x00000010050c7824ULL, 0x100fe400078e020fULL, 0x0000001004057824ULL, 0x000fe200078e020fULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006a20783bULL, 0x000fe20000000200ULL,
0xfffffff00a097812ULL, 0x000fe200078ee209ULL, 0x0000001003037824ULL, 0x100fe400078e020fULL,
0x000000001618783bULL, 0x0002a40000000200ULL, 0x0000001009097824ULL, 0x000fe400078e00ffULL,
0x00000000682c783bULL, 0x000ee80000000200ULL, 0x000000006d24783bULL, 0x000f220000000200ULL,
0x0000001008167824ULL, 0x002fc600078e020fULL, 0x000000001728783bULL, 0x000e680000000200ULL,
0x000000001650783bULL, 0x000fe80000000200ULL, 0x000000000908783bULL, 0x000e680000000200ULL,
0x000000000c54783bULL, 0x000e680000000200ULL, 0x000000000558783bULL, 0x000e620000000200ULL,
0x000000201830723cULL, 0x044f700000001830ULL, 0x000000221834723cULL, 0x040b640000001834ULL,
0x000000000320783bULL, 0x020eac0000000200ULL, 0x0000002c1838723cULL, 0x048f700000001838ULL,
0x0000002e183c723cULL, 0x040f70000000183cULL, 0x000000241840723cULL, 0x050f700000001840ULL,
0x000000261844723cULL, 0x040f700000001844ULL, 0x000000281848723cULL, 0x042f700000001848ULL,
0x0000002a181c723cULL, 0x000f70000000181cULL, 0x000000500830723cULL, 0x040b700000001830ULL,
0x000000520834723cULL, 0x040b700000001834ULL, 0x000000540838723cULL, 0x060b700000001838ULL,
0x00000056083c723cULL, 0x040b70000000183cULL, 0x000000580840723cULL, 0x040b700000001840ULL,
0x0000005a0844723cULL, 0x040b700000001844ULL, 0x000000200848723cULL, 0x044b700000001848ULL,
0x00000022081c723cULL, 0x000b62000000181cULL, 0x0000056000008947ULL, 0x000fce0003800000ULL,
0x00000002ff2d7819ULL, 0x000fe20000011670ULL, 0x000000ffff097224ULL, 0x020fe200078e00ffULL,
0x000000c011087812ULL, 0x000fc400078efcffULL, 0x000000102d277810ULL, 0x040fe20007ffe0ffULL,
0x0000000100197824ULL, 0x040fe200078e022dULL, 0x000000082d517810ULL, 0x040fe40007ffe0ffULL,
0x000000182d297810ULL, 0x000fe20007ffe0ffULL, 0x0000010019187825ULL, 0x000fe200078e0008ULL,
0x000000202d2b7810ULL, 0x040fe40007ffe0ffULL, 0x000000282d2f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001001b7824ULL, 0x000fe200078e0227ULL, 0x0000001812207210ULL, 0x000fe20007f1e0ffULL,
0x00000001000b7824ULL, 0x000fe200078e0251ULL, 0x000000302d557810ULL, 0x000fe20007ffe0ffULL,
0x000001001b1a7825ULL, 0x000fc800078e0008ULL, 0x0000000113217824ULL, 0x000fe200000e0619ULL,
0x0000004e63197217ULL, 0x000fe20007800000ULL, 0x0000000100237824ULL, 0x000fe200078e0229ULL,
0x0000001a121a7210ULL, 0x000fe20007f1e0ffULL, 0x000001000b0a7825ULL, 0x000fc800078e0008ULL,
0x0000000119047824ULL, 0x000fe200078e0a4eULL, 0x0000000a120a7210ULL, 0x000fe20007f3e0ffULL,
0x0000010023187825ULL, 0x000fc600078e0008ULL, 0x000000045100720cULL, 0x0c0fe20003f66070ULL,
0x0000000451517824ULL, 0x000fe200078e00ffULL, 0x000000042d00720cULL, 0x000fe20003f46070ULL,
0x0000000100257824ULL, 0x040fe200078e022bULL, 0x0000000b130b7210ULL, 0x000fe20000ffe4ffULL,
0x0000000100537824ULL, 0x000fe200078e022fULL, 0xfffffffc51267812ULL, 0x000fe200078ee214ULL,
0x00000001131b7824ULL, 0x000fe200000e061bULL, 0x0000001812187210ULL, 0x000fe20007f1e0ffULL,
0x0000010025247825ULL, 0x000fe200078e0008ULL, 0x000000382d2d7810ULL, 0x000fc40007ffe0ffULL,
0x000000042700720cULL, 0x000fe20003fa6070ULL, 0x0000010053227825ULL, 0x000fe200078e0008ULL,
0x0000002412247210ULL, 0x000fe40007f3e0ffULL, 0x000000042900720cULL, 0x000fe20003f86070ULL,
0x0000001010517824ULL, 0x100fe400078e020fULL, 0x0000001026537824ULL, 0x000fe400078e020fULL,
0x0000000100577824ULL, 0x000fe200078e0255ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020517faeULL, 0x0003e2000d101c46ULL, 0x0000000113197824ULL, 0x000fe200000e0619ULL,
0x0000002212227210ULL, 0x000fe20007f1e0ffULL, 0x0000000427277824ULL, 0x000fe200078e00ffULL,
0x000000000a537faeULL, 0x0005e2000d901c46ULL, 0x000000042b00720cULL, 0x080fe20003f66070ULL,
0x0000000429297824ULL, 0x000fe200078e00ffULL, 0x000000042f00720cULL, 0x080fe20003f46070ULL,
0x0000000113257824ULL, 0x000fe200008e0625ULL, 0x000000045500720cULL, 0x080fe20003f26070ULL,
0x000000042b2b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc29107812ULL, 0x100fe200078ee214ULL,
0x0000000113237824ULL, 0x000fe200000e0623ULL, 0x000000042d00720cULL, 0x000fe20003f06070ULL,
0x000000042f2f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc27047812ULL, 0x000fe200078ee214ULL,
0x00000100570a7825ULL, 0x004fe200078e0008ULL, 0xfffffffc2b207812ULL, 0x002fc400078ee214ULL,
0xfffffffc2f267812ULL, 0x000fe200078ee214ULL, 0x0000000100577824ULL, 0x000fe200078e022dULL,
0x0000000a120a7210ULL, 0x000fe20007fde0ffULL, 0x0000000455557824ULL, 0x000fe200078e00ffULL,
0x000000022d2d7819ULL, 0x000fe200000006ffULL, 0x0000010057087825ULL, 0x000fc600078e0008ULL,
0xfffffffc55287812ULL, 0x100fe200078ee214ULL, 0x00000001130b7824ULL, 0x000fe200030e060bULL,
0xfffffffc2d2a7812ULL, 0x000fe200078ee214ULL, 0x0000001004217824ULL, 0x100fe200078e020fULL,
0x0000000812087210ULL, 0x000fe20007fde0ffULL, 0x0000001010277824ULL, 0x100fe400078e020fULL,
0x0000001020297824ULL, 0x100fe200078e020fULL, 0x000000001a217faeULL, 0x0003e2000e901c46ULL,
0x00000010262b7824ULL, 0x100fe400078e020fULL, 0x00000010282d7824ULL, 0x100fe200078e020fULL,
0x0000000018277faeULL, 0x0003e2000e101c46ULL, 0x000000102a0f7824ULL, 0x000fc400078e020fULL,
0x0000000113097824ULL, 0x000fe200030e0609ULL, 0x0000000024297faeULL, 0x0003e8000d901c46ULL,
0x00000000222b7faeULL, 0x0003e8000d101c46ULL, 0x000000000a2d7faeULL, 0x0003e8000c901c46ULL,
0x00000000080f7faeULL, 0x0003e2000c101c46ULL, 0x000004a000007947ULL, 0x000fea0003800000ULL,
0x00000008702b7811ULL, 0x040fe200078ff0ffULL, 0x000000ffff277224ULL, 0x000fe200078e00ffULL,
0x00000010702d7811ULL, 0x000fc400078ff0ffULL, 0x00000018702f7811ULL, 0x000fe200078ff0ffULL,
0x0000000100217824ULL, 0x060fe200078e022bULL, 0x000000c011267812ULL, 0x000fe200078efcffULL,
0x0000000100237824ULL, 0x000fe200078e022dULL, 0x00000000701b7211ULL, 0x000fe200078ff0ffULL,
0x0000000100257824ULL, 0x000fe200078e022fULL, 0x0000002070517811ULL, 0x040fe200078ff0ffULL,
0x0000010021207825ULL, 0x100fe200078e0026ULL, 0x0000002870537811ULL, 0x040fe400078ff0ffULL,
0x0000003070557811ULL, 0x040fe200078ff0ffULL, 0x000001001b1a7825ULL, 0x000fe200078e0026ULL,
0x0000003870577811ULL, 0x000fc400078ff0ffULL, 0x0000002012207210ULL, 0x000fe20007f3e0ffULL,
0x0000000100097824ULL, 0x000fe200078e0251ULL, 0x0000001a121a7210ULL, 0x000fe20007f1e0ffULL,
0x00000001000b7824ULL, 0x040fe200078e0253ULL, 0x0000000251517819ULL, 0x000fe200000006ffULL,
0x0000000100197824ULL, 0x000fe400078e0255ULL, 0x0000010023227825ULL, 0x000fe200078e0026ULL,
0xfffffffc512a7812ULL, 0x000fc600078ee214ULL, 0x0000000100297824ULL, 0x000fe200078e0257ULL,
0x0000002212227210ULL, 0x000fe20007f5e0ffULL, 0x0000010025247825ULL, 0x000fc800078e0026ULL,
0x000000042b2b7824ULL, 0x000fe200078e00ffULL, 0x0000002412247210ULL, 0x000fe20007f7e0ffULL,
0x000000042d2d7824ULL, 0x000fe400078e00ffULL, 0x000000042f2f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc2b047812ULL, 0x000fe200078ee214ULL, 0x0000010009087825ULL, 0x000fc600078e0026ULL,
0xfffffffc2f287812ULL, 0x000fe200078ee214ULL, 0x000001000b0a7825ULL, 0x000fc800078e0026ULL,
0x0000010019187825ULL, 0x000fc800078e0026ULL, 0x0000010029267825ULL, 0x000fc800078e0026ULL,
0x0000000453537824ULL, 0x000fe400078e00ffULL, 0x0000001010297824ULL, 0x000fe200078e020fULL,
0xfffffffc2d107812ULL, 0x100fe200078ee214ULL, 0x0000000455557824ULL, 0x000fe200078e00ffULL,
0xfffffffc532c7812ULL, 0x100fe200078ee214ULL, 0x0000000457577824ULL, 0x000fe400078e00ffULL,
0x00000001131b7824ULL, 0x040fe200000e061bULL, 0x0000000812087210ULL, 0x040fe20007f1e0ffULL,
0x0000000113217824ULL, 0x040fe200008e0621ULL, 0x0000000a120a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000113237824ULL, 0x000fe200010e0623ULL, 0xfffffffc552e7812ULL, 0x100fe200078ee214ULL,
0x00000010042b7824ULL, 0x000fe200078e020fULL, 0x0000001812187210ULL, 0x000fe20007f5e0ffULL,
0x0000000113257824ULL, 0x000fe200018e0625ULL, 0xfffffffc57507812ULL, 0x000fe200078ee214ULL,
0x00000010102d7824ULL, 0x100fe200078e020fULL, 0x0000002612127210ULL, 0x000fe20007f7e0ffULL,
0x00000010282f7824ULL, 0x100fe200078e020fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a297faeULL, 0x0003e2000b901c46ULL, 0x000000102a517824ULL, 0x000fc400078e020fULL,
0x0000000113097824ULL, 0x040fe200000e0609ULL, 0x00000000202b7faeULL, 0x0003e2000b901c46ULL,
0x000000102c537824ULL, 0x000fe400078e020fULL, 0x00000001130b7824ULL, 0x040fe200008e060bULL,
0x00000000222d7faeULL, 0x0003e2000b901c46ULL, 0x000000102e557824ULL, 0x000fe400078e020fULL,
0x0000000113197824ULL, 0x000fe200010e0619ULL, 0x00000000242f7faeULL, 0x0003e2000b901c46ULL,
0x00000010500f7824ULL, 0x000fc400078e020fULL, 0x0000000113137824ULL, 0x000fe200018e0627ULL,
0x0000000008517faeULL, 0x0003e8000b901c46ULL, 0x000000000a537faeULL, 0x0003e8000b901c46ULL,
0x0000000018557faeULL, 0x0003e8000b901c46ULL, 0x00000000120f7faeULL, 0x0003e4000b901c46ULL,
0x0000000461617810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff047424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000716100720cULL, 0x000fda0003f06070ULL,
0x0000000400138802ULL, 0x002fe20000000f00ULL, 0x0000000279128824ULL, 0x000fc800078e0261ULL,
0x0000660012128625ULL, 0x000fe200078e0013ULL, 0x000000080e087810ULL, 0x000fc60007ffe0ffULL,
0x0000001062097824ULL, 0x000fe200078e00ffULL, 0x0000000612048981ULL, 0x000ea2000c1e1900ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff009087812ULL, 0x000fe200078ee208ULL,
0x0000001062107824ULL, 0x000fe200078e00ffULL, 0x0000000a0e0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000006558783bULL, 0x000fe40000000200ULL, 0x0000001008507824ULL, 0x000fe200078e00ffULL,
0xfffffff0100f7812ULL, 0x000fe200078ee20fULL, 0x000000005c08783bULL, 0x000fe80000000200ULL,
0x000000005050783bULL, 0x000e620000000200ULL, 0x000000100f0f7824ULL, 0x000fc600078e00ffULL,
0x000000005d5c783bULL, 0x000ee80000000200ULL, 0x000000006654783bULL, 0x000f280000000200ULL,
0x000000000f18783bULL, 0x000fe80000000200ULL, 0x000000006928783bULL, 0x000f280000000200ULL,
0x00000000672c783bULL, 0x000f280000000200ULL, 0x000000006b24783bULL, 0x000f280000000200ULL,
0x000000006c20783bULL, 0x000f220000000200ULL, 0x000000085030723cULL, 0x042ff00000001830ULL,
0x0000005c5038723cULL, 0x048f700000001838ULL, 0x0000000a5034723cULL, 0x040f700000001834ULL,
0x0000005e503c723cULL, 0x040f70000000183cULL, 0x000000585040723cULL, 0x040f700000001840ULL,
0x0000005a5044723cULL, 0x040f700000001844ULL, 0x000000545048723cULL, 0x050f700000001848ULL,
0x00000056501c723cULL, 0x000f70000000181cULL, 0x000000281838723cULL, 0x060b6e0000001838ULL,
0x0000030006287a10ULL, 0x020fe20007ffe0ffULL, 0x0000002c1830723cULL, 0x000b660000001830ULL,
0x0000000128097810ULL, 0x000fc80007ffe0ffULL, 0x000000640900720cULL, 0x000fe20003f06070ULL,
0x0000002e1834723cULL, 0x040b700000001834ULL, 0x0000002a183c723cULL, 0x040b70000000183cULL,
0x000000241840723cULL, 0x040b700000001840ULL, 0x000000261844723cULL, 0x040b700000001844ULL,
0x000000201848723cULL, 0x040b700000001848ULL, 0x00000022181c723cULL, 0x000b62000000181cULL,
0x00000077046f7224ULL, 0x004fc800078e02ffULL, 0x000064006f6e7625ULL, 0x000fe200078e006eULL,
0x000005c000008947ULL, 0x000fca0003800000ULL, 0x00000002ff107819ULL, 0x020fe20000011670ULL,
0x00000100280a7824ULL, 0x000fc600078e0278ULL, 0x0000001010227810ULL, 0x000fe20007ffe0ffULL,
0x0000000100087824ULL, 0x000fe200078e0210ULL, 0x0000000810207810ULL, 0x000fe40007ffe0ffULL,
0x0000000a630b7217ULL, 0x000fe20007800000ULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000002010267810ULL, 0x040fe40007ffe0ffULL, 0x0000001810247810ULL, 0x000fe20007ffe0ffULL,
0x0000000100187824ULL, 0x000fe200078e0222ULL, 0x0000001108197212ULL, 0x000fe200078efcffULL,
0x0000000100127824ULL, 0x000fe200078e0220ULL, 0x0000002810277810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0f7824ULL, 0x000fe200078e0a0aULL, 0x000000196e087210ULL, 0x000fe20007f1e0ffULL,
0x00000100180a7825ULL, 0x000fe200078e00ffULL, 0x0000003010297810ULL, 0x000fc40007ffe0ffULL,
0x0000000f2200720cULL, 0x000fe20003fa6070ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000110a197212ULL, 0x000fe400078efcffULL, 0x0000000f2400720cULL, 0x000fe20003f86070ULL,
0x0000000109097824ULL, 0x000fe200000e066fULL, 0x00000011121b7212ULL, 0x000fe200078efcffULL,
0x00000001001a7824ULL, 0x000fe200078e0226ULL, 0x000000196e0a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000420257824ULL, 0x000fe200078e00ffULL, 0x0000001b6e127210ULL, 0x000fe20007f3e0ffULL,
0x000001001a1a7825ULL, 0x000fc800078e00ffULL, 0x000000010b0b7824ULL, 0x100fe200000e066fULL,
0x0000000f1000720cULL, 0x080fe20003f06070ULL, 0x0000000113137824ULL, 0x000fe200008e066fULL,
0x0000000f2000720cULL, 0x000fe20003f26070ULL, 0x0000000100187824ULL, 0x000fe200078e0224ULL,
0x000000111a217212ULL, 0x000fe400078efcffULL, 0xfffffffc25207812ULL, 0x000fe200078ee214ULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x000000216e1a7210ULL, 0x000fe40007f7e0ffULL,
0x0000000d20257211ULL, 0x000fe200078e20ffULL, 0x0000000100217824ULL, 0x000fe200078e0227ULL,
0x0000001118237212ULL, 0x000fe200078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008157faeULL, 0x0003e2000c101c46ULL, 0x0000003810107810ULL, 0x000fe20007ffe0ffULL,
0x0000010021207825ULL, 0x000fe200078e00ffULL, 0x000000236e187210ULL, 0x000fe20007f5e0ffULL,
0x0000000012257faeULL, 0x0005e2000c901c46ULL, 0x0000000f2900720cULL, 0x000fe20003f26070ULL,
0x000000011b1b7824ULL, 0x100fe200018e066fULL, 0x0000001120237212ULL, 0x000fe200078efcffULL,
0x0000000119197824ULL, 0x000fe200010e066fULL, 0x0000000f2600720cULL, 0x000fc40003f66070ULL,
0x000000236e207210ULL, 0x000fe20007fde0ffULL, 0x0000000422097824ULL, 0x002fe200078e00ffULL,
0x0000000f2700720cULL, 0x080fe20003f46070ULL, 0x0000000100087824ULL, 0x000fe200078e0210ULL,
0x0000000f1000720cULL, 0x000fe20003f06070ULL, 0x0000000100127824ULL, 0x004fe400078e0229ULL,
0x0000000410257824ULL, 0x000fe200078e00ffULL, 0xfffffffc09107812ULL, 0x000fe200078ee214ULL,
0x0000010012127825ULL, 0x000fc800078e00ffULL, 0x0000000424157824ULL, 0x000fe200078e00ffULL,
0x00000011120f7212ULL, 0x000fe200078efcffULL, 0x0000010008087825ULL, 0x000fc600078e00ffULL,
0xfffffffc15227812ULL, 0x100fe200078ee214ULL, 0x0000000426237824ULL, 0x000fe200078e00ffULL,
0x0000001108117212ULL, 0x000fe200078efcffULL, 0x0000000121217824ULL, 0x100fe200030e066fULL,
0x0000000f6e127210ULL, 0x000fe20007fde0ffULL, 0x0000000427277824ULL, 0x000fe200078e00ffULL,
0xfffffffc23247812ULL, 0x100fe200078ee214ULL, 0x0000000429297824ULL, 0x000fe400078e00ffULL,
0x0000000113137824ULL, 0x000fe200030e066fULL, 0xfffffffc27267812ULL, 0x100fe200078ee214ULL,
0x00000010100f7824ULL, 0x100fe200078e020dULL, 0xfffffffc292a7812ULL, 0x100fe200078ee214ULL,
0x0000001022157824ULL, 0x100fe200078e020dULL, 0xfffffffc25147812ULL, 0x000fe200078ee214ULL,
0x0000001024237824ULL, 0x100fe200078e020dULL, 0x000000116e087210ULL, 0x000fe20007fde0ffULL,
0x0000001026117824ULL, 0x100fe200078e020dULL, 0x000000000a0f7faeULL, 0x0003e2000e901c46ULL,
0x000000102a257824ULL, 0x000fc400078e020dULL, 0x00000010140d7824ULL, 0x000fe200078e020dULL,
0x0000000018157faeULL, 0x0003e2000e101c46ULL, 0x0000000109097824ULL, 0x000fc600030e066fULL,
0x000000001a237faeULL, 0x0003e8000d901c46ULL, 0x0000000020117faeULL, 0x0003e8000d101c46ULL,
0x0000000012257faeULL, 0x0003e8000c901c46ULL, 0x00000000080d7faeULL, 0x0003e2000c101c46ULL,
0x000004f000007947ULL, 0x000fea0003800000ULL, 0x0000002870257811ULL, 0x060fe400078ff0ffULL,
0x00000010700b7811ULL, 0x000fc400078ff0ffULL, 0x0000001870137811ULL, 0x040fe200078ff0ffULL,
0x0000000425217824ULL, 0x000fe200078e00ffULL, 0x0000002070237811ULL, 0x040fe400078ff0ffULL,
0x0000000870097811ULL, 0x040fe200078ff0ffULL, 0x0000000413197824ULL, 0x000fe200078e00ffULL,
0x0000003070517811ULL, 0x040fe200078ff0ffULL, 0x00000004231b7824ULL, 0x000fe200078e00ffULL,
0x0000000070087211ULL, 0x000fe200078ff0ffULL, 0x0000000100127824ULL, 0x000fe200078e0209ULL,
0x0000003870537811ULL, 0x000fe200078ff0ffULL, 0x00000004090f7824ULL, 0x000fe200078e00ffULL,
0x0000000b000a7210ULL, 0x000fe20007ffe0ffULL, 0x000000040b0b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc21247812ULL, 0x100fe200078ee214ULL, 0x0000000451277824ULL, 0x000fe200078e00ffULL,
0xfffffffc191a7812ULL, 0x100fe200078ee214ULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0xfffffffc0b187812ULL, 0x000fc400078ee214ULL, 0xfffffffc1b227812ULL, 0x100fe200078ee214ULL,
0x0000000453297824ULL, 0x000fe200078e00ffULL, 0xfffffffc0f107812ULL, 0x100fe200078ee214ULL,
0x0000000100207824ULL, 0x000fe200078e0213ULL, 0xfffffffc27267812ULL, 0x100fe200078ee214ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc29147812ULL, 0x000fe400078ee214ULL,
0x00000011080f7212ULL, 0x080fe200078efcffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000110a1b7212ULL, 0x000fc400078efcffULL, 0x0000000f6e087210ULL, 0x000fe20007f1e0ffULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x0000001112197212ULL, 0x000fe400078efcffULL,
0x0000001b6e0a7210ULL, 0x000fe20007f5e0ffULL, 0x00000010242d7824ULL, 0x100fe200078e020dULL,
0x000000196e127210ULL, 0x000fe20007f3e0ffULL, 0x000000101a297824ULL, 0x100fe200078e020dULL,
0x00000051001a7210ULL, 0x000fe20007ffe0ffULL, 0x00000010222b7824ULL, 0x000fe400078e020dULL,
0x0000000100247824ULL, 0x000fc400078e0223ULL, 0x0000000100227824ULL, 0x000fe400078e0225ULL,
0x00000010100f7824ULL, 0x100fe400078e020dULL, 0x0000001018277824ULL, 0x100fe400078e020dULL,
0x00000010262f7824ULL, 0x100fe400078e020dULL, 0x0000001014557824ULL, 0x000fe200078e020dULL,
0x00000011200d7212ULL, 0x000fe200078efcffULL, 0x0000000100187824ULL, 0x000fc400078e0253ULL,
0x0000010024247825ULL, 0x000fc800078e00ffULL, 0x0000010022227825ULL, 0x000fc800078e00ffULL,
0x0000000109097824ULL, 0x100fe200000e066fULL, 0x0000000d6e207210ULL, 0x000fe20007f1e0ffULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x00000011240d7212ULL, 0x080fe400078efcffULL,
0x0000001122517212ULL, 0x080fe200078efcffULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x000000111a537212ULL, 0x080fe200078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008157faeULL, 0x0003e4000b901c46ULL, 0x0000000121217824ULL, 0x100fe200000e066fULL,
0x0000001118117212ULL, 0x000fe200078efcffULL, 0x0000000113137824ULL, 0x100fe200008e066fULL,
0x0000000d6e107210ULL, 0x040fe20007f1e0ffULL, 0x000000010b0b7824ULL, 0x000fe200010e066fULL,
0x000000516e227210ULL, 0x000fc40007f3e0ffULL, 0x000000536e1a7210ULL, 0x040fe20007f5e0ffULL,
0x00000000120f7faeULL, 0x0003e2000b901c46ULL, 0x000000116e187210ULL, 0x000fe20007f7e0ffULL,
0x0000000125117824ULL, 0x100fe400000e066fULL, 0x0000000123237824ULL, 0x100fe200008e066fULL,
0x000000000a277faeULL, 0x0003e2000b901c46ULL, 0x000000011b1b7824ULL, 0x100fe400010e066fULL,
0x0000000119197824ULL, 0x000fe200018e066fULL, 0x0000000020297faeULL, 0x0003e8000b901c46ULL,
0x00000000102b7faeULL, 0x0003e8000b901c46ULL, 0x00000000222d7faeULL, 0x0003e8000b901c46ULL,
0x000000001a2f7faeULL, 0x0003e8000b901c46ULL, 0x0000000018557faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001062097824ULL, 0x002fe200078e00ffULL,
0x0000000c0e087810ULL, 0x000fe20007ffe0ffULL, 0x00000010620d7824ULL, 0x000fe200078e00ffULL,
0x0000000e0e0e7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff009087812ULL, 0x000fe400078ee208ULL,
0xfffffff00d0e7812ULL, 0x000fc600078ee20eULL, 0x0000001008107824ULL, 0x000fe400078e00ffULL,
0x000000100e147824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000006a08783bULL, 0x000fe80000000200ULL, 0x000000001010783bULL, 0x000e680000000200ULL,
0x000000006868783bULL, 0x000ea80000000200ULL, 0x000000006d6c783bULL, 0x000ee80000000200ULL,
0x000000001718783bULL, 0x000f280000000200ULL, 0x000000001620783bULL, 0x000fe80000000200ULL,
0x000000001414783bULL, 0x000ee80000000200ULL, 0x000000000c0c783bULL, 0x000ee80000000200ULL,
0x000000000324783bULL, 0x0003e40000000200ULL, 0x000000081030723cULL, 0x042f700000001830ULL,
0x0000000a1034723cULL, 0x040b640000001834ULL, 0x000000000508783bULL, 0x020e6c0000000200ULL,
0x000000681038723cULL, 0x044f700000001838ULL, 0x0000006a103c723cULL, 0x040f70000000183cULL,
0x0000006c1040723cULL, 0x048ff00000001840ULL, 0x0000006e1044723cULL, 0x040ff00000001844ULL,
0x000000181048723cULL, 0x050ff00000001848ULL, 0x0000001a101c723cULL, 0x000ff0000000181cULL,
0x000000201430723cULL, 0x040f700000001830ULL, 0x000000221434723cULL, 0x040f700000001834ULL,
0x0000000c1438723cULL, 0x060f700000001838ULL, 0x0000000e143c723cULL, 0x000f62000000183cULL,
0x3db504f332037820ULL, 0x000fe20000410000ULL, 0x3db504f333337820ULL, 0x000fcc0000410000ULL,
0x000000081440723cULL, 0x002f620000001840ULL, 0x3db504f336367820ULL, 0x000fce0000410000ULL,
0x0000000a1444723cULL, 0x000f640000001844ULL, 0x3db504f3382d7820ULL, 0x020fe20000410000ULL,
0x3db504f33a207820ULL, 0x000fe20000410000ULL, 0x3db504f33b3b7820ULL, 0x000fc80000410000ULL,
0x000000241448723cULL, 0x000b620000001848ULL, 0x3db504f33c297820ULL, 0x000fe20000410000ULL,
0x3db504f33e217820ULL, 0x000fe20000410000ULL, 0x3db504f33f3f7820ULL, 0x000fc80000410000ULL,
0x3db504f331257820ULL, 0x020fe20000410000ULL, 0x00000026141c723cULL, 0x000b62000000181cULL,
0x3db504f337317820ULL, 0x000fe20000410000ULL, 0x3db504f340327820ULL, 0x000fe20000410000ULL,
0x3db504f3412a7820ULL, 0x000fe20000410000ULL, 0x3db504f342227820ULL, 0x000fc60000410000ULL,
0x3db504f330177820ULL, 0x020fe20000410000ULL, 0x3db504f334267820ULL, 0x000fe20000410000ULL,
0x3db504f335307820ULL, 0x000fe20000410000ULL, 0x3db504f339277820ULL, 0x000fe20000410000ULL,
0x3db504f33d347820ULL, 0x000fe20000410000ULL, 0x3db504f343167820ULL, 0x000fe20000410000ULL,
0x3db504f3442b7820ULL, 0x000fe20000410000ULL, 0x3db504f3452f7820ULL, 0x000fe20000410000ULL,
0x3db504f346147820ULL, 0x000fe20000410000ULL, 0x3db504f347157820ULL, 0x000fe20000410000ULL,
0x3db504f3482e7820ULL, 0x000fe20000410000ULL, 0x3db504f3492c7820ULL, 0x000fe20000410000ULL,
0x3db504f34a057820ULL, 0x000fe20000410000ULL, 0x3db504f34b187820ULL, 0x000fc80000410000ULL,
0x3db504f31c237820ULL, 0x000fe20000410000ULL, 0x3db504f31d247820ULL, 0x000fe20000410000ULL,
0x3db504f31e197820ULL, 0x000fe20000410000ULL, 0x3db504f31f1a7820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000075087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1c7224ULL, 0x000fe400078e0033ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0003ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0036ULL, 0x000000ffff1f7224ULL, 0x000fc400078e003bULL,
0x000000ffff337224ULL, 0x000fc400078e003fULL, 0x00000000000a7805ULL, 0x002fca0000015200ULL,
0x0000040075037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x006fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc8000001140dULL,
0x0000000c03037211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e060dULL,
0x0000000203037819ULL, 0x000fc8000000120cULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040075037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004701b7824ULL, 0x000fe200078e00ffULL, 0x000000730600720cULL, 0x000fc80003f06070ULL,
0xfffffff01b087812ULL, 0x000fc800078ec0ffULL, 0x0000000807037211ULL, 0x000fca00078e38ffULL,
0x0134000003087984ULL, 0x0002a20000000c00ULL, 0x000014e000008947ULL, 0x000fea0003800000ULL,
0x00005a00000e7b06ULL, 0x000ee20000209000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x0000007470067211ULL, 0x040fe200078ff0ffULL, 0x0000000270357824ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f85070ULL, 0x00005a00ff127a12ULL, 0x000fe400078e33ffULL,
0x0000000635357812ULL, 0x000fca00078ec0ffULL, 0x0000000135377824ULL, 0x000fe200078e0202ULL,
0x0000000e000e7308ULL, 0x008ee40000001000ULL, 0x0ffffffe0e0f7810ULL, 0x008fcc0007ffe0ffULL,
0x0000000f000d7305ULL, 0x000ee4000021f000ULL, 0x000000ffff117224ULL, 0x008fc800078e0a0dULL,
0x00005a0011117a24ULL, 0x000fc800078e02ffULL, 0x000000110d117227ULL, 0x000fcc00078e000cULL,
0x00000006110c7227ULL, 0x000fc800078e00ffULL, 0x000000ffff0d7224ULL, 0x000fc800078e0a0cULL,
0x00005a000d0d7a24ULL, 0x000fe200078e0206ULL, 0x0000000806067810ULL, 0x000fc80007ffe0ffULL,
0x00005a000d007a0cULL, 0x000fe20003f06070ULL, 0x0000000611117227ULL, 0x000fc800078e00ffULL,
0x000000ffff0f7224ULL, 0x000fc800078e0a11ULL, 0x00005a000f0e7a24ULL, 0x000fc800078e0206ULL,
0x80005a000d0d0a10ULL, 0x000fe40007ffe0ffULL, 0x00005a000e007a0cULL, 0x000fe40003f46070ULL,
0x00005a000d007a0cULL, 0x000fe40003f26070ULL, 0x0000004e630d7217ULL, 0x000fe40007800000ULL,
0x000000010c0c0810ULL, 0x000fc60007ffe0ffULL, 0x000000010d4e7824ULL, 0x000fe400078e0a4eULL,
0x00000001600d7824ULL, 0x000fe400078e0235ULL, 0x80005a000e0e2a10ULL, 0x000fe40007ffe0ffULL,
0x000000010d067824ULL, 0x040fe200078e0a4eULL, 0x000000010c0c1810ULL, 0x000fe40007ffe0ffULL,
0x0000004e0d00720cULL, 0x000fe40003f66070ULL, 0x0000000c120c7207ULL, 0x000fc40006000000ULL,
0x00005a000e007a0cULL, 0x000fe40003f06070ULL, 0x000000064f0d7217ULL, 0x000fe20003800000ULL,
0x0000000137067824ULL, 0x000fe200078e0a4eULL, 0x0000000c4f537217ULL, 0x000fe40003800000ULL,
0x00000004ff0d7819ULL, 0x000fe4000001160dULL, 0x0000000111112810ULL, 0x000fe20007ffe0ffULL,
0x0000005372537224ULL, 0x000fe200078e02ffULL, 0x000000ff0d107207ULL, 0x000fc40001800000ULL,
0x0000004e3700720cULL, 0x000fe40003f26070ULL, 0x000000064f067217ULL, 0x000fe20003800000ULL,
0x00000001530d7824ULL, 0x000fe200078e0210ULL, 0x0000000111110810ULL, 0x000fe40007ffe0ffULL,
0x000000ff06407207ULL, 0x000fe20000800000ULL, 0x000000020d0c7825ULL, 0x000fe200078e004cULL,
0x0000001112067207ULL, 0x000fe40006000000ULL, 0x00000010353b7812ULL, 0x000fc400078efcffULL,
0x000000064f557217ULL, 0x000fe20003800000ULL, 0x000000060c467981ULL, 0x000722000c1e9500ULL,
0x00000053400f7211ULL, 0x000fc600078fe0ffULL, 0x0000005572557224ULL, 0x000fe400078e02ffULL,
0x000000020f0e7825ULL, 0x000fc800078e004cULL, 0x00000001600d7824ULL, 0x008fe200078e023bULL,
0x00000020353d7812ULL, 0x000fe200078efcffULL, 0x0000000110117824ULL, 0x000fe200078e0255ULL,
0x000000060e517981ULL, 0x000722000c1e9500ULL, 0x000000010d067824ULL, 0x000fe400078e0a4eULL,
0x0000000211107825ULL, 0x000fc600078e004cULL, 0x000000064f0c7217ULL, 0x000fe40003800000ULL,
0x0000004e0d00720cULL, 0x000fe20003f26070ULL, 0x0000000610427981ULL, 0x0042a2000c1e9500ULL,
0x00000004ff0c7819ULL, 0x000fe2000001160cULL, 0x0000000160457824ULL, 0x000fe400078e023dULL,
0x000000013b397824ULL, 0x000fe200078e0202ULL, 0x000000ff0c107207ULL, 0x002fe40000800000ULL,
0x000000454e3a7210ULL, 0x000fe20007ffe1ffULL, 0x0000000139067824ULL, 0x000fe200078e0a4eULL,
0x0000005540137211ULL, 0x000fe200078fe0ffULL, 0x00000001530d7824ULL, 0x000fe200078e0210ULL,
0x0000003a4f3a7217ULL, 0x000fe20003800000ULL, 0x000000013d417824ULL, 0x000fc400078e0202ULL,
0x000000020d0c7825ULL, 0x100fe200078e004cULL, 0x0000004e3900720cULL, 0x000fe40003f06070ULL,
0x000000064f067217ULL, 0x000fe20003800000ULL, 0x0000000213127825ULL, 0x000fe200078e004cULL,
0x0000004e4500720cULL, 0x000fe20003f26070ULL, 0x000000060c367981ULL, 0x0002a2000c1e9500ULL,
0x00000004ff3a7819ULL, 0x000fe4000001163aULL, 0x000000ff06067207ULL, 0x000fe20000000000ULL,
0x0000000612597981ULL, 0x0006a2000c1e9500ULL, 0x000000ff3a3e7207ULL, 0x000fc40000800000ULL,
0x0000003035457812ULL, 0x000fe200078efcffULL, 0x00000001410c7824ULL, 0x042fe200078e0a4eULL,
0x00000053060f7211ULL, 0x008fe200078fe0ffULL, 0x0000000110117824ULL, 0x000fe200078e0255ULL,
0x0000004e4100720cULL, 0x000fe40003f06070ULL, 0x0000005506137211ULL, 0x000fe200078fe0ffULL,
0x00000001530d7824ULL, 0x000fe200078e023eULL, 0x0000000c4f0c7217ULL, 0x000fe20003800000ULL,
0x0000000160577824ULL, 0x000fe400078e0245ULL, 0x000000020f0e7825ULL, 0x000fe200078e004cULL,
0x000000ff0c3a7207ULL, 0x000fc60000000000ULL, 0x0000000211107825ULL, 0x100fe200078e004cULL,
0x000000060e3f7981ULL, 0x0002e6000c1e9500ULL, 0x0000000213127825ULL, 0x100fe200078e004cULL,
0x0000000610387981ULL, 0x0002e6000c1e9500ULL, 0x000000020d0c7825ULL, 0x000fe200078e004cULL,
0x0000000612437981ULL, 0x0002e6000c1e9500ULL, 0x0000000157447824ULL, 0x000fe200078e0a4eULL,
0x000000060c3c7981ULL, 0x0002e2000c1e9500ULL, 0x0000000145497824ULL, 0x000fe200078e0202ULL,
0x000000533a0f7211ULL, 0x002fc400078fe0ffULL, 0x000000444f447217ULL, 0x000fe20003800000ULL,
0x000000013e117824ULL, 0x000fe200078e0255ULL, 0x000000553a137211ULL, 0x000fe200078fe0ffULL,
0x00000001490c7824ULL, 0x000fe200078e0a4eULL, 0x0000004e5700720cULL, 0x080fe40003f26070ULL,
0x00000004ff447819ULL, 0x000fe20000011644ULL, 0x000000020f0e7825ULL, 0x100fe200078e004cULL,
0x0000004e4900720cULL, 0x000fe40003f06070ULL, 0x0000000c4f0c7217ULL, 0x000fe20003800000ULL,
0x0000000211107825ULL, 0x100fe200078e004cULL, 0x000000ff44487207ULL, 0x000fe20000800000ULL,
0x000000060e477981ULL, 0x0002e4000c1e9500ULL, 0x0000000213127825ULL, 0x000fe200078e004cULL,
0x000000ff0c447207ULL, 0x000fe20000000000ULL, 0x00000006103e7981ULL, 0x0002e8000c1e9500ULL,
0x00000006124b7981ULL, 0x0002e2000c1e9500ULL, 0x00000001530d7824ULL, 0x000fe200078e0248ULL,
0x00000053440f7211ULL, 0x002fc600078fe0ffULL, 0x000000020d0c7825ULL, 0x000fc800078e004cULL,
0x000000020f0e7825ULL, 0x000fe400078e004cULL, 0x000000060c0c7981ULL, 0x0002e2000c1e9500ULL,
0x0000005544117211ULL, 0x000fc600078fe0ffULL, 0x000000060e0f7981ULL, 0x0002e2000c1e9500ULL,
0x0000000148137824ULL, 0x000fe400078e0255ULL, 0x0000000211107825ULL, 0x000fc800078e004cULL,
0x0000000213127825ULL, 0x000fe400078e004cULL, 0x0000000610107981ULL, 0x0002e8000c1e9500ULL,
0x0000000612137981ULL, 0x0002e2000c1e9500ULL, 0xfffffff040557812ULL, 0x000fe400078ec0ffULL,
0x0000000135537812ULL, 0x000fc600078efcffULL, 0x000000014e487824ULL, 0x000fe200078e0255ULL,
0x00000009350d7812ULL, 0x002fe200078efcffULL, 0x00000001ff407424ULL, 0x000fe400078e00ffULL,
0x00000001375b7824ULL, 0x000fe400078e0a48ULL, 0x0000000153577824ULL, 0x100fe400078e0202ULL,
0x000000010d117824ULL, 0x000fe200078e0202ULL, 0x0000005b405b7219ULL, 0x000fe200000006ffULL,
0x00000001575d7824ULL, 0x000fc400078e0a48ULL, 0x0000000111657824ULL, 0x000fc600078e0a48ULL,
0x0000005d405d7219ULL, 0x040fe400000006ffULL, 0x0000006540657219ULL, 0x000fe400000006ffULL,
0x00000018357b7812ULL, 0x000fca00078efcffULL, 0x000000017b127824ULL, 0x000fe200078e0202ULL,
0x00000011357d7812ULL, 0x040fe400078efcffULL, 0x00000019356f7812ULL, 0x000fca00078efcffULL,
0x000000016f0e7824ULL, 0x000fe200078e0202ULL, 0x0000002135677812ULL, 0x000fe400078efcffULL,
0xfffffff044447812ULL, 0x000fc600078ec0ffULL, 0x00000001676d7824ULL, 0x000fe400078e0202ULL,
0x000000014e667824ULL, 0x000fca00078e0244ULL, 0x8000006649547210ULL, 0x000fc80007ffe0ffULL,
0x0000005440547219ULL, 0x000fe400000006ffULL, 0x0000541051467816ULL, 0x010fe40000000046ULL,
0x0000000835517812ULL, 0x000fca00078efcffULL, 0x0000000151557824ULL, 0x000fe200078e0202ULL,
0x000000465bff7212ULL, 0x000fc6000780c0ffULL, 0x00000001555f7824ULL, 0x000fe200078e0a48ULL,
0x0000004e3700720cULL, 0x000fc80000701470ULL, 0x0000005f405f7219ULL, 0x000fe400000006ffULL,
0x000000465dff7212ULL, 0x080fe4000782c0ffULL, 0x000000465fff7212ULL, 0x080fe4000786c0ffULL,
0x0000004665ff7212ULL, 0x000fe4000788c0ffULL, 0x0000004e3500720cULL, 0x000fe400007a1070ULL,
0xfffffff006467812ULL, 0x000fc400078ec0ffULL, 0xff80000017177808ULL, 0x000fc60002800000ULL,
0x000000014e467824ULL, 0x000fe200078e0246ULL, 0x0000541059427816ULL, 0x004fc80000000042ULL,
0x000000425bff7212ULL, 0x080fe4000784c0ffULL, 0x000000425fff7212ULL, 0x080fe400078cc0ffULL,
0x0000004265ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001394a7824ULL, 0x100fe200078e0a46ULL,
0x0000004e3700720cULL, 0x080fe20001741470ULL, 0x0000000112567824ULL, 0x000fe200078e0a46ULL,
0x0000004e5500720cULL, 0x080fe400037c1470ULL, 0x0000004e1100720cULL, 0x000fc40002fa1470ULL,
0xfffffff03a487812ULL, 0x000fe400078ec0ffULL, 0x0000004e3500720cULL, 0x080fe40001741070ULL,
0x0000004e5100720cULL, 0x080fe400037c1070ULL, 0x0000004e0d00720cULL, 0x000fe40002fa1070ULL,
0x0000004a404a7219ULL, 0x040fe400000006ffULL, 0x0000005640567219ULL, 0x000fc400000006ffULL,
0x000054103f3f7816ULL, 0x008fe40000000036ULL, 0x0000541043437816ULL, 0x000fe40000000038ULL,
0x000000425dff7212ULL, 0x000fe2000780c0ffULL, 0x000000014e487824ULL, 0x000fe200078e0248ULL,
0x000000027d427210ULL, 0x000fe40007ffe0ffULL, 0xff8000001e1e7808ULL, 0x000fe40001000000ULL,
0xff8000001d1d7808ULL, 0x000fc40003000000ULL, 0xff80000031317808ULL, 0x000fe40002800000ULL,
0x0000003f4aff7212ULL, 0x040fe4000784c0ffULL, 0x000000434aff7212ULL, 0x080fe400078cc0ffULL,
0x0000004356ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000142527824ULL, 0x100fe200078e0a46ULL,
0x0000004e5700720cULL, 0x0c0fe20000f21470ULL, 0x000000010e5e7824ULL, 0x000fe200078e0a46ULL,
0x0000004e5700720cULL, 0x080fe20000701470ULL, 0x00000001415c7824ULL, 0x000fe200078e0a48ULL,
0x0000004e5500720cULL, 0x000fc40001f61470ULL, 0x0000004e1100720cULL, 0x080fe40002781470ULL,
0x0000004e3900720cULL, 0x0c0fe40001741470ULL, 0x0000004e3900720cULL, 0x080fe400037c1470ULL,
0x0000004e1200720cULL, 0x000fe40002fa1470ULL, 0x0000002835657812ULL, 0x040fe400078efcffULL,
0x00000029355f7812ULL, 0x000fc400078efcffULL, 0x0000004e5300720cULL, 0x0c0fe40000f21070ULL,
0x0000004e5300720cULL, 0x080fe40000701070ULL, 0x0000004e5100720cULL, 0x080fe40001f61070ULL,
0x0000004e0d00720cULL, 0x080fe40002781070ULL, 0x0000004e3b00720cULL, 0x0c0fe40001741070ULL,
0x0000004e3b00720cULL, 0x000fc400037c1070ULL, 0x0000004e7b00720cULL, 0x000fe40002fa1070ULL,
0x0000005240527219ULL, 0x040fe400000006ffULL, 0x0000005e405e7219ULL, 0x040fe400000006ffULL,
0x0000005c405c7219ULL, 0x000fe400000006ffULL, 0x0000541047477816ULL, 0x000fe4000000003cULL,
0x000054104b4b7816ULL, 0x000fe2000000003eULL, 0x00000001656b7824ULL, 0x100fe200078e0202ULL,
0xff80000025257808ULL, 0x000fe20000800000ULL, 0x000000015f697824ULL, 0x000fe200078e0202ULL,
0xff8000001c1c7808ULL, 0x000fc40000000000ULL, 0xff80000026267808ULL, 0x000fe40001800000ULL,
0xff80000030307808ULL, 0x000fe40002000000ULL, 0xff8000002d2d7808ULL, 0x000fe40001000000ULL,
0xff80000020207808ULL, 0x000fe40003000000ULL, 0xff80000021217808ULL, 0x000fe40002800000ULL,
0x0000003f52ff7212ULL, 0x000fc4000782c0ffULL, 0x0000003f56ff7212ULL, 0x080fe4000780c0ffULL,
0x0000003f5eff7212ULL, 0x000fe4000786c0ffULL, 0x0000004352ff7212ULL, 0x080fe4000788c0ffULL,
0x000000435eff7212ULL, 0x000fe4000784c0ffULL, 0x000000475cff7212ULL, 0x040fe400078cc0ffULL,
0x0000004b5cff7212ULL, 0x000fe200078ac0ffULL, 0x000000016d627824ULL, 0x100fe200078e0a48ULL,
0x0000004e4200720cULL, 0x0c0fe20000f21470ULL, 0x000000016b587824ULL, 0x100fe200078e0a48ULL,
0x0000004e4200720cULL, 0x080fe20002781470ULL, 0x00000001695a7824ULL, 0x000fe200078e0a48ULL,
0x0000004e1200720cULL, 0x000fc40000701470ULL, 0x0000004e0e00720cULL, 0x0c0fe40001f61470ULL,
0x0000004e0e00720cULL, 0x080fe40001741470ULL, 0x0000004e4100720cULL, 0x0c0fe400037c1470ULL,
0x0000004e4100720cULL, 0x000fe40002fa1470ULL, 0x00000031355d7812ULL, 0x040fe400078efcffULL,
0x00000038355b7812ULL, 0x000fc400078efcffULL, 0x0000003935597812ULL, 0x000fe400078efcffULL,
0x0000004e7d00720cULL, 0x0c0fe40000f21070ULL, 0x0000004e7d00720cULL, 0x080fe40002781070ULL,
0x0000004e7b00720cULL, 0x080fe40000701070ULL, 0x0000004e6f00720cULL, 0x0c0fe40001f61070ULL,
0x0000004e6f00720cULL, 0x000fc40001741070ULL, 0x0000004e3d00720cULL, 0x0c0fe400037c1070ULL,
0x0000004e3d00720cULL, 0x000fe40002fa1070ULL, 0x0000006240627219ULL, 0x040fe400000006ffULL,
0x0000005840587219ULL, 0x040fe400000006ffULL, 0x0000005a405a7219ULL, 0x000fe400000006ffULL,
0x000054100f0f7816ULL, 0x000fe2000000000cULL, 0x000000015d067824ULL, 0x100fe200078e0202ULL,
0xff80000027277808ULL, 0x000fe20000800000ULL, 0x000000015b3a7824ULL, 0x100fe200078e0202ULL,
0xff8000001f1f7808ULL, 0x000fe20002000000ULL, 0x0000000159447824ULL, 0x000fe200078e0202ULL,
0xff80000029297808ULL, 0x000fc40000000000ULL, 0xff80000034347808ULL, 0x000fe40001800000ULL,
0xff80000033337808ULL, 0x000fe40001000000ULL, 0xff80000032327808ULL, 0x000fe40003000000ULL,
0xff80000022227808ULL, 0x000fe40002800000ULL, 0x0000004762ff7212ULL, 0x080fe4000782c0ffULL,
0x0000004758ff7212ULL, 0x000fc4000788c0ffULL, 0x000000475aff7212ULL, 0x000fe4000780c0ffULL,
0x0000004b62ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004b58ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004b5aff7212ULL, 0x000fe400078cc0ffULL, 0x0000000f54ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000106507824ULL, 0x100fe200078e0a66ULL, 0x0000004e6d00720cULL, 0x0c0fe20000f21470ULL,
0x000000013a467824ULL, 0x100fe200078e0a66ULL, 0x0000004e6d00720cULL, 0x080fe20001f61470ULL,
0x0000000144487824ULL, 0x000fe200078e0a66ULL, 0x0000004e6b00720cULL, 0x000fc40002781470ULL,
0x0000004e6b00720cULL, 0x080fe40001741470ULL, 0x0000004e6900720cULL, 0x0c0fe40000701470ULL,
0x0000004e6900720cULL, 0x080fe400037c1470ULL, 0x0000004e4900720cULL, 0x080fe40002fa1470ULL,
0x0000004e6700720cULL, 0x0c0fe40000f21070ULL, 0x0000004e6700720cULL, 0x000fc40001f61070ULL,
0x0000004e6500720cULL, 0x0c0fe40002781070ULL, 0x0000004e6500720cULL, 0x080fe40001741070ULL,
0x0000004e5f00720cULL, 0x0c0fe40000701070ULL, 0x0000004e5f00720cULL, 0x080fe400037c1070ULL,
0x0000004e4500720cULL, 0x000fe40002fa1070ULL, 0x0000005040507219ULL, 0x000fc400000006ffULL,
0x0000004640467219ULL, 0x040fe400000006ffULL, 0x0000004840487219ULL, 0x000fe400000006ffULL,
0x0000541010137816ULL, 0x000fe40000000013ULL, 0xff8000002a2a7808ULL, 0x000fe40000800000ULL,
0xff80000016167808ULL, 0x000fe40001800000ULL, 0xff8000002b2b7808ULL, 0x000fc40002000000ULL,
0xff80000014147808ULL, 0x000fe40001000000ULL, 0xff8000002f2f7808ULL, 0x000fe40000000000ULL,
0xff80000015157808ULL, 0x000fe40003000000ULL, 0xff8000002e2e7808ULL, 0x000fe40002800000ULL,
0x0000000f50ff7212ULL, 0x080fe4000782c0ffULL, 0x0000000f46ff7212ULL, 0x000fc4000786c0ffULL,
0x0000000f48ff7212ULL, 0x000fe4000788c0ffULL, 0x0000001354ff7212ULL, 0x080fe4000784c0ffULL,
0x0000001350ff7212ULL, 0x080fe4000780c0ffULL, 0x0000001346ff7212ULL, 0x080fe400078cc0ffULL,
0x0000001348ff7212ULL, 0x000fe400078ac0ffULL, 0x0000004e4900720cULL, 0x000fc40001741470ULL,
0x0000004e0600720cULL, 0x0c0fe40000f21470ULL, 0x0000004e0600720cULL, 0x080fe40000701470ULL,
0x0000004e3a00720cULL, 0x0c0fe40001f61470ULL, 0x0000004e3a00720cULL, 0x080fe400037c1470ULL,
0x0000004e4400720cULL, 0x0c0fe40002781470ULL, 0x0000004e4400720cULL, 0x000fc40002fa1470ULL,
0x0000004e4500720cULL, 0x080fe40001741070ULL, 0x0000004e5d00720cULL, 0x0c0fe40000f21070ULL,
0x0000004e5d00720cULL, 0x080fe40000701070ULL, 0x0000004e5b00720cULL, 0x0c0fe40001f61070ULL,
0x0000004e5b00720cULL, 0x080fe400037c1070ULL, 0x0000004e5900720cULL, 0x000fc40002781070ULL,
0x0000004e5900720cULL, 0x000fe40002fa1070ULL, 0xff8000002c2c7808ULL, 0x000fe40000800000ULL,
0xff80000023237808ULL, 0x000fe40001800000ULL, 0xff80000024247808ULL, 0x000fe40002000000ULL,
0xff80000005057808ULL, 0x000fe40001000000ULL, 0xff80000018187808ULL, 0x000fc40000000000ULL,
0xff80000019197808ULL, 0x000fe40003000000ULL, 0xff8000001a1a7808ULL, 0x000fc40002800000ULL,
0x000000170800720bULL, 0x004fe20003f1e000ULL, 0x0000001fff117424ULL, 0x000fe200078e00ffULL,
0x0000001e0900720bULL, 0x000fe20003f3e000ULL, 0xffffffffff367424ULL, 0x000fe200078e00ffULL,
0x0000000817087208ULL, 0x000fe40004000000ULL, 0x000000091e097208ULL, 0x000fe40004800000ULL,
0x000000250800720bULL, 0x000fc40003f1e000ULL, 0x0000001c0900720bULL, 0x000fe40003f3e000ULL,
0x00000008250d7208ULL, 0x000fe40004000000ULL, 0x000000091c067208ULL, 0x000fe40004800000ULL,
0x000000260d00720bULL, 0x000fe40003f1e000ULL, 0x0000001d0600720bULL, 0x000fe40003f3e000ULL,
0x0000000d260d7208ULL, 0x000fc40004000000ULL, 0x000000061d067208ULL, 0x000fe40004800000ULL,
0x000000300d00720bULL, 0x000fe40003f1e000ULL, 0x000000310600720bULL, 0x000fe40003f3e000ULL,
0x0000000d30087208ULL, 0x000fe40004000000ULL, 0x0000000631097208ULL, 0x000fe40004800000ULL,
0x0000002d0800720bULL, 0x000fc40003f1e000ULL, 0x000000200900720bULL, 0x000fe40003f3e000ULL,
0x000000082d087208ULL, 0x000fe40004000000ULL, 0x0000000920067208ULL, 0x000fe40004800000ULL,
0x000000270800720bULL, 0x000fe40003f1e000ULL, 0x0000001f0600720bULL, 0x000fe40003f3e000ULL,
0x0000000827087208ULL, 0x000fc40004000000ULL, 0x000000061f067208ULL, 0x000fe40004800000ULL,
0x000000290800720bULL, 0x000fe40003f1e000ULL, 0x000000210600720bULL, 0x000fe40003f3e000ULL,
0x0000000829097208ULL, 0x000fe40004000000ULL, 0x0000000621067208ULL, 0x000fe40004800000ULL,
0x000000340900720bULL, 0x000fc40003f1e000ULL, 0x000000330600720bULL, 0x000fe40003f3e000ULL,
0x0000000934097208ULL, 0x000fe40004000000ULL, 0x00000006330d7208ULL, 0x000fe40004800000ULL,
0x000000320900720bULL, 0x000fe40003f1e000ULL, 0x000000220d00720bULL, 0x000fe40003f3e000ULL,
0x0000000932097208ULL, 0x000fc40004000000ULL, 0x0000000d220d7208ULL, 0x000fe40004800000ULL,
0x0000002a0900720bULL, 0x000fe40003f1e000ULL, 0x000000160d00720bULL, 0x000fe40003f3e000ULL,
0x000000092a067208ULL, 0x000fe40004000000ULL, 0x0000000d160d7208ULL, 0x000fe40004800000ULL,
0x0000002b0600720bULL, 0x000fc40003f1e000ULL, 0x000000140d00720bULL, 0x000fe40003f3e000ULL,
0x000000062b067208ULL, 0x000fe40004000000ULL, 0x0000000d14087208ULL, 0x000fe40004800000ULL,
0x0000002f0600720bULL, 0x000fe40003f1e000ULL, 0x000000150800720bULL, 0x000fe40003f3e000ULL,
0x000000062f097208ULL, 0x000fc40004000000ULL, 0x0000000815087208ULL, 0x000fe40004800000ULL,
0x0000002e0900720bULL, 0x000fe40003f1e000ULL, 0x000000050800720bULL, 0x000fe40003f3e000ULL,
0x000000092e097208ULL, 0x000fe40004000000ULL, 0x00000008050d7208ULL, 0x000fe40004800000ULL,
0x0000002c0900720bULL, 0x000fc40003f1e000ULL, 0x000000180d00720bULL, 0x000fe40003f3e000ULL,
0x000000092c067208ULL, 0x000fe40004000000ULL, 0x0000000d18087208ULL, 0x000fe40004800000ULL,
0x000000230600720bULL, 0x000fe40003f1e000ULL, 0x000000190800720bULL, 0x000fe40003f3e000ULL,
0x0000000623097208ULL, 0x000fc40004000000ULL, 0x00000008190d7208ULL, 0x000fe40004800000ULL,
0x000000240900720bULL, 0x000fe40003f1e000ULL, 0x0000001a0d00720bULL, 0x000fe40003f3e000ULL,
0x00000009240e7208ULL, 0x000fe40004000000ULL, 0x0000000d1a107208ULL, 0x000fe20004800000ULL,
0x000014227f007947ULL, 0x000fec000b800000ULL, 0x0c401f000e067f89ULL, 0x0004e400000e0000ULL,
0x000000060e00720bULL, 0x008fc80003f1e000ULL, 0x0000000e06127208ULL, 0x000fe20004000000ULL,
0x000014327f007947ULL, 0x000fea000b800000ULL, 0x0c401f0010067f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a097f89ULL, 0x000f2800000e0000ULL, 0x0c401f000b087f89ULL, 0x000e6200000e0000ULL,
0x000000061000720bULL, 0x008fc40003f1e000ULL, 0x000000090a00720bULL, 0x010fe40003f3e000ULL,
0x00000010060c7208ULL, 0x000fe40004000000ULL, 0x0000000a090d7208ULL, 0x000fe40004800000ULL,
0x0c201f0012097f89ULL, 0x000ee200000e0000ULL, 0x000000080b00720bULL, 0x002fc60003f1e000ULL,
0x0c201f000c0f7f89ULL, 0x000e6200000e0000ULL, 0x0000000b08067208ULL, 0x000fc60004000000ULL,
0x0c201f000d0e7f89ULL, 0x004ea800000e0000ULL, 0x0c201f0006357f89ULL, 0x0002a200000e0000ULL,
0x000000091200720bULL, 0x008fe40003f1e000ULL, 0x0000000f0c00720bULL, 0x002fe40003f3e000ULL,
0x0000001209087208ULL, 0x000fe40004000000ULL, 0x0000000e0d00720bULL, 0x004fc40003f5e000ULL,
0x0000000c0f097208ULL, 0x000fe40004800000ULL, 0x0000000d0e0a7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b080c7820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000370ff7812ULL, 0x000fe4000780c0ffULL, 0x3fb8aa3b290f7823ULL, 0x102fe2000001080cULL,
0x3fb8aa3b2b297823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b092b7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001082bULL,
0x0000001700177308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b270b7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b34347823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b32277823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b23237823ULL, 0x000fe2000001080cULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001082bULL,
0x00000025000e7308ULL, 0x0002e20000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b05057823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001082bULL,
0x00000026000d7308ULL, 0x0009e20000000800ULL, 0x3c003c00ff257424ULL, 0x002fe200078e00ffULL,
0x3fb8aa3b1a1a7823ULL, 0x000fe2000001082bULL, 0x000000350600720bULL, 0x004fca0003f3e000ULL,
0x0000003000107308ULL, 0x0002a20000000800ULL, 0x3fb8aa3b2c267823ULL, 0x110fe2000001080cULL,
0x3fb8aa3b242c7823ULL, 0x000fe2000001080cULL, 0x3c003c00ff247424ULL, 0x000fca00078e00ffULL,
0x0000000f00377308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2f307823ULL, 0x002fce000001080cULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000001c000f7308ULL, 0x000e700000000800ULL,
0x0000001d001d7308ULL, 0x000ff00000000800ULL, 0x0000003100127308ULL, 0x0008700000000800ULL,
0x0000000b00367308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b15317823ULL, 0x010fce000001082bULL,
0x0000002d002d7308ULL, 0x000f220000000800ULL, 0x3fb8aa3b2e0b7823ULL, 0x002fe2000001080cULL,
0x000000170e0c723eULL, 0x008fe400000000ffULL, 0x0000000d100e723eULL, 0x004fe400000000ffULL,
0x0000001e0f0d723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b141e7823ULL, 0x100fe2000001082bULL,
0x0000001d120f723eULL, 0x000fe200000000ffULL, 0x0000003400347308ULL, 0x000e620000000800ULL,
0x3fb8aa3b161d7823ULL, 0x000fca000001082bULL, 0x000000240c10723cULL, 0x000f6200000018ffULL,
0x0000002d3614723eULL, 0x010fe200000000ffULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000001f001f7308ULL, 0x000ea20000000800ULL, 0x000000373416723eULL, 0x002fce00000000ffULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x00000033001c7308ULL, 0x000e620000000800ULL,
0x000000201f15723eULL, 0x004fe400000000ffULL, 0x00000002ff207819ULL, 0x000fc80000011670ULL,
0x00000002202b7810ULL, 0x040fe20007ffe0ffULL, 0x0000001d002f7308ULL, 0x000fe20000000800ULL,
0x0000000820387824ULL, 0x040fe400078e00ffULL, 0x0000000820347824ULL, 0x040fe400078e00ffULL,
0x0000000820327824ULL, 0x040fe400078e00ffULL, 0x00000008202d7824ULL, 0x000fe200078e00ffULL,
0x000000211c17723eULL, 0x002fe200000000ffULL, 0x0000001e002e7308ULL, 0x0003e20000000800ULL,
0x0000000120217810ULL, 0x040fe20007ffe0ffULL, 0x00000008203a7824ULL, 0x000fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe200078ee22bULL, 0x00000008202b7824ULL, 0x000fe200078e00ffULL,
0xfffffff832327812ULL, 0x000fc400078ee221ULL, 0x0000000520217810ULL, 0x040fe20007ffe0ffULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x00000024141c723cULL, 0x022b6e0000001810ULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0x0000000820137824ULL, 0x060fe200078e00ffULL,
0x0000000320107810ULL, 0x000fc40007ffe0ffULL, 0x0000000420117810ULL, 0x000fe40007ffe0ffULL,
0xfffffff813367812ULL, 0x000fe400078ee210ULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0xfffffff838387812ULL, 0x000fce00078ee211ULL, 0x0000003000307308ULL, 0x000ea20000000800ULL,
0x000000272a10723eULL, 0x002fe400000000ffULL, 0xffffffff20277810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82b2a7812ULL, 0x000fe400078ee220ULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee227ULL,
0x0000002200227308ULL, 0x000e700000000800ULL, 0x0000003100317308ULL, 0x000ee20000000800ULL,
0x000000293012723eULL, 0x004fc400000000ffULL, 0x0000000820297810ULL, 0x000fe40007ffe0ffULL,
0x000000222f11723eULL, 0x002fc600000000ffULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x0000000620227810ULL, 0x000fe20007ffe0ffULL, 0x00000008293c7824ULL, 0x000fc600078e00ffULL,
0xfffffff82d307812ULL, 0x000fe400078ee222ULL, 0x0000002e3113723eULL, 0x008fe200000000ffULL,
0x0000002c002c7308ULL, 0x000e620000000800ULL, 0x00000008202e7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fc800078ee229ULL, 0x00000024101c723cULL, 0x000f62000000181cULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee221ULL, 0x0000000b000b7308ULL, 0x000ff00000000800ULL,
0x0000002600267308ULL, 0x000ea20000000800ULL, 0x000000232c22723eULL, 0x002fc400000000ffULL,
0x0000000c1b2c7812ULL, 0x000fca00078ec0ffULL, 0x0000000500057308ULL, 0x000ff00000000800ULL,
0x0000001800187308ULL, 0x000e620000000800ULL, 0x0000000b2620723eULL, 0x004fe400000000ffULL,
0x00009000070b7811ULL, 0x000fc800078e58ffULL, 0x0000000b30277211ULL, 0x000fe200078e20ffULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x00000010381b7824ULL, 0x100fe400078e020bULL,
0x000000102e267824ULL, 0x100fe400078e020bULL, 0x000000103a297824ULL, 0x000fe400078e020bULL,
0x000000012c1b7824ULL, 0x000fe200078e021bULL, 0x0000001a001a7308ULL, 0x000ea20000000800ULL,
0x000000051821723eULL, 0x002fe200000000ffULL, 0x000000102a057824ULL, 0x000fc400078e020bULL,
0x0000001032187824ULL, 0x000fe400078e020bULL, 0x000000012c057824ULL, 0x040fe400078e0205ULL,
0x000000012c187824ULL, 0x040fe400078e0218ULL, 0x000000012c267824ULL, 0x040fe200078e0226ULL,
0x0000000c05007388ULL, 0x0003e20000000800ULL, 0x000000012c277824ULL, 0x040fe400078e0227ULL,
0x000000012c297824ULL, 0x000fe200078e0229ULL, 0x0000000e18007388ULL, 0x0003e20000000800ULL,
0x000000191a23723eULL, 0x004fe200000000ffULL, 0x0000001034197824ULL, 0x000fc400078e020bULL,
0x00000010361a7824ULL, 0x000fe400078e020bULL, 0x000000012c197824ULL, 0x040fe400078e0219ULL,
0x00000024201c723cULL, 0x020b62000000181cULL, 0x000000012c1a7824ULL, 0x000fe400078e021aULL,
0x000000103c0b7824ULL, 0x000fe200078e020bULL, 0x0000001419007388ULL, 0x0003e60000000800ULL,
0x000000012c247824ULL, 0x020fe200078e020bULL, 0x000000161a007388ULL, 0x0003e20000000800ULL,
0x00000006350b7208ULL, 0x000fc60004800000ULL, 0x000000101b007388ULL, 0x0003e80000000800ULL,
0x0000001226007388ULL, 0x0003e80000000800ULL, 0x0000002027007388ULL, 0x0003e80000000800ULL,
0x0000002229007388ULL, 0x0003e20000000800ULL, 0x000000ffff1d7224ULL, 0x000fc600078e001eULL,
0x0000000d24007388ULL, 0x0003e80000000800ULL, 0x0004000f18007388ULL, 0x0003e80000000800ULL,
0x0004001519007388ULL, 0x0003e80000000800ULL, 0x000400171a007388ULL, 0x0003e80000000800ULL,
0x000400111b007388ULL, 0x0003e80000000800ULL, 0x0004001326007388ULL, 0x0003e80000000800ULL,
0x0004002127007388ULL, 0x0003e80000000800ULL, 0x0004002329007388ULL, 0x0003e80000000800ULL,
0x0130000803008388ULL, 0x0003e80000000c00ULL, 0x0132001c03008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136080076ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136100076ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136180076ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000642800720cULL, 0x000fe20003f06070ULL,
0x0136200076ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff067224ULL, 0x000fd600078e0028ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff9c0000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0b7807ULL, 0x008fe40004000000ULL,
0x00013b6000107802ULL, 0x000fc40000000f00ULL, 0x00000bb000007944ULL, 0x012fea0003c00000ULL,
0xfffef2b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x000fe40005000000ULL,
0x00013ba000107802ULL, 0x000fc40000000f00ULL, 0x00000b7000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e000bULL, 0xfffef31000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e000aULL, 0x00013bf000117802ULL, 0x000fc40000000f00ULL,
0x00000ad000007944ULL, 0x012fea0003c00000ULL, 0xfffef3f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e000aULL, 0x00013c3000117802ULL, 0x000fc40000000f00ULL,
0x00000a9000007944ULL, 0x012fea0003c00000ULL, 0xfffef51000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e000aULL, 0x00013c8000117802ULL, 0x000fe20000000f00ULL,
0x000000ffff0b7224ULL, 0x000fc400078e0009ULL, 0x00000a4000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e000bULL, 0xfffef6c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e000aULL, 0x00013cd000117802ULL, 0x000fc40000000f00ULL,
0x000009f000007944ULL, 0x016fea0003c00000ULL, 0x0000000b00007202ULL, 0x004fe20000000f00ULL,
0xfffef6a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x004fe40004000000ULL,
0x00013d2000107802ULL, 0x000fc40000000f00ULL, 0x000009f000007944ULL, 0x018fea0003c00000ULL,
0xffff0de000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x000fe40004800000ULL,
0x00013d6000107802ULL, 0x000fc40000000f00ULL, 0x000009b000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e000bULL, 0xffff0e3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e000fULL, 0x00013db000117802ULL, 0x000fc40000000f00ULL,
0x0000091000007944ULL, 0x018fea0003c00000ULL, 0xffff0f2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e000fULL, 0x00013df000117802ULL, 0x000fc40000000f00ULL,
0x000008d000007944ULL, 0x01afea0003c00000ULL, 0xffff104000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0004ULL, 0x00013e4000117802ULL, 0x000fe20000000f00ULL,
0x000000ffff0b7224ULL, 0x000fc400078e000dULL, 0x0000088000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e000bULL, 0xffff11f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0004ULL, 0x00013e9000117802ULL, 0x000fc40000000f00ULL,
0x0000083000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e000bULL,
0xffff11d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x004fe40004000000ULL,
0x00013ee000107802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x018fea0003c00000ULL,
0xffff268000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x000fe40004800000ULL,
0x00013f2000107802ULL, 0x000fc40000000f00ULL, 0x000007f000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff127224ULL, 0x000fe200078e000bULL, 0xffff26c000007947ULL, 0x000fea000383ffffULL,
0x0000003300107202ULL, 0x000fe40000000f00ULL, 0x00013f7000117802ULL, 0x000fc40000000f00ULL,
0x0000075000007944ULL, 0x018fea0003c00000ULL, 0xffff27b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0033ULL, 0x00013fb000117802ULL, 0x000fc40000000f00ULL,
0x0000071000007944ULL, 0x01afea0003c00000ULL, 0xffff28d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0012ULL, 0x0001400000117802ULL, 0x000fe20000000f00ULL,
0x000000ffff0b7224ULL, 0x000fc400078e0013ULL, 0x000006c000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e000bULL, 0xffff2a8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0012ULL, 0x0001405000117802ULL, 0x000fc40000000f00ULL,
0x0000067000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e000bULL,
0xffff2a6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x004fe40004000000ULL,
0x000140a000107802ULL, 0x000fc40000000f00ULL, 0x0000067000007944ULL, 0x018fea0003c00000ULL,
0xffff3f9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x000fe40004800000ULL,
0x000140e000107802ULL, 0x000fc40000000f00ULL, 0x0000063000007944ULL, 0x018fea0003c00000ULL,
0x0000000b00097202ULL, 0x000fe20000000f00ULL, 0xffff3fd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e001dULL, 0x0001413000117802ULL, 0x000fc40000000f00ULL,
0x0000059000007944ULL, 0x018fea0003c00000ULL, 0xffff40c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e001dULL, 0x0001417000117802ULL, 0x000fc40000000f00ULL,
0x0000055000007944ULL, 0x01afea0003c00000ULL, 0xffff41e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0012ULL, 0x000141c000117802ULL, 0x000fe20000000f00ULL,
0x000000ffff0b7224ULL, 0x000fc400078e0013ULL, 0x0000050000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e000bULL, 0xffff439000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0012ULL, 0x0001421000117802ULL, 0x000fc40000000f00ULL,
0x000004b000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e000bULL,
0xffff437000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x00014260000c7802ULL, 0x000fc40000000f00ULL, 0x0000042000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0035ULL, 0xffffeba000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x006fe200078e0010ULL, 0x000142c0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fc400078e00ffULL, 0x000003c000007944ULL, 0x000fea0003c00000ULL,
0x000000351000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x00014320000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001035107208ULL, 0x000fc80004000000ULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0x000000350a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000bULL,
0x00014380000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a350a7208ULL, 0x000fc80004000000ULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x000000350b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0012ULL,
0x000143e0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000b35067208ULL, 0x000fc80004000000ULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x000000351200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0010ULL,
0x00014440000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001235087208ULL, 0x000fc80004000000ULL, 0x0000024000007944ULL, 0x000fea0003c00000ULL,
0x000000351000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x000144a0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001035097208ULL, 0x000fc80004000000ULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0x000000350a00720bULL, 0x004fe20003f1e000ULL, 0x00000001ff0f7424ULL, 0x002fe200078e00ffULL,
0x00000006000e7202ULL, 0x000fc40000000f00ULL, 0x0000000a350a7208ULL, 0x000fe40004000000ULL,
0x00014500000c7802ULL, 0x000fc40000000f00ULL, 0x0000018000007944ULL, 0x000fea0003c00000ULL,
0xffffea7000007947ULL, 0x000fea000383ffffULL, 0x0180000009037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003067812ULL, 0x000fc800078ec0ffULL,
0x018000000600780cULL, 0x000fda0003f05070ULL, 0x0000000900038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0600720cULL, 0x040fe40003f25070ULL,
0x008000000600780cULL, 0x000fe40003f02070ULL, 0x00000001ff067807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000306ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff09ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000306ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000009067812ULL, 0x000fd600078ec0ffULL, 0x0080000006030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0006ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000900037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff0d7424ULL, 0x000fc800078e00ffULL, 0xfffeb9800c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000003600007348ULL, 0x000fe80003800000ULL,
0x0c00000f0e357389ULL, 0x0002a200000e0011ULL, 0xfffeb9400c007950ULL, 0x000fea0003c3ffffULL,
0x0000007500007348ULL, 0x000fe80003800000ULL, 0x0000000b100b7389ULL, 0x0002a400000e0076ULL,
0x000000ffff107224ULL, 0x002fc400078e0011ULL, 0x00000000ff117424ULL, 0x000fc800078e00ffULL,
0xfffeb8f010007950ULL, 0x000fea0003c3ffffULL, 0x000000010b00780cULL, 0x000fe20003f45070ULL,
0x00000000ff117424ULL, 0x000fe200078e00ffULL, 0x0000007300007348ULL, 0x000ff60003800000ULL,
0x00000000000b7806ULL, 0x000fc800050e0100ULL, 0x000000730b0b7212ULL, 0x000fe200078ec0ffULL,
0xfffeb89010007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000002ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000050aULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000668ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008c0ULL,
0x0000000000000368ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c28ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ce8ULL,
0x00000000000005d0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012b8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012c8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001358ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000135cULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001580ULL,
0x0000000000014800ULL, 0x8000001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015d80ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015dc0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000016140ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001358ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000014a28ULL,
0x0000000000014a28ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000015d80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000016140ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_16_sm_86_cubin_len = 90656;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
