/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000017640ULL, 0x00000000000172c0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL,
0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL,
0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL,
0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL,
0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c00010000028dULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00010000036fULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b0022000003b5ULL, 0x0000000000015b10ULL, 0x0000000000000170ULL, 0x000b0022000003e8ULL,
0x0000000000015c80ULL, 0x0000000000000040ULL, 0x000b002200000413ULL, 0x0000000000015cc0ULL,
0x0000000000000050ULL, 0x000b00220000043dULL, 0x0000000000015d10ULL, 0x00000000000000f0ULL,
0x000a0003000004abULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000004cbULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004fbULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000015e00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00015b1000000000ULL, 0x0000040400000000ULL, 0x810c000001740400ULL,
0x0055400400288080ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080900828808081ULL,
0xb608288080910828ULL, 0x2880808c08288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x000022002880808cULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x00015b1000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080900828808081ULL,
0xb608288080910828ULL, 0x2880808a08288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x000022002880808aULL, 0x0000001cffffffffULL, 0x000000f000000000ULL, 0x00015c8000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080900828808081ULL,
0x9108288080b60828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808091920000ULL,
0x0000000000000022ULL, 0x0000002cffffffffULL, 0x0000017000000000ULL, 0x00015cc000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8090288080910900ULL, 0x0000000000002880ULL,
0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080910828808081ULL, 0x9008288080b60828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x0028808090920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x0000020000000000ULL, 0x00015d1000000000ULL, 0x000000f000000000ULL, 0x0000000000000000ULL,
0x0000001800082f04ULL, 0x0008230400000080ULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL,
0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL, 0x0000000000000012ULL,
0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL, 0x0000001100082304ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008230400000000ULL,
0x0000000000000018ULL, 0x0000001800081204ULL, 0x0008110400000000ULL, 0x0000000000000018ULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0068016000000015ULL, 0x000c170400681903ULL,
0x0060000a00000000ULL, 0x000c17040021f000ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040081f000ULL,
0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0x00000b2000043104ULL, 0xffffffff01542904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000032001542804ULL, 0x0000054000000420ULL,
0x00002e0000001d10ULL, 0x00002fb000002e90ULL, 0x0000332000003110ULL, 0x000033c000003350ULL,
0x00003b0000003430ULL, 0x00004bc000004b20ULL, 0x00004e5000004cf0ULL, 0x0000509000005060ULL,
0x0000517000005100ULL, 0x000065c0000055a0ULL, 0x0000678000006650ULL, 0x00006af0000068e0ULL,
0x00006b9000006b20ULL, 0x0000701000006c00ULL, 0x00008160000080d0ULL, 0x000083f000008290ULL,
0x0000863000008600ULL, 0x00008710000086a0ULL, 0x00008c1000008c00ULL, 0x0000afd00000af90ULL,
0x0000b7800000b740ULL, 0x000140c000014080ULL, 0x000140e0000140d0ULL, 0x00014150000140f0ULL,
0x0001419000014170ULL, 0x00014e2000014dd0ULL, 0x00014ef000014e90ULL, 0x00014fd000014f60ULL,
0x0001508000015030ULL, 0x00015150000150f0ULL, 0x00015230000151c0ULL, 0x000152e000015290ULL,
0x000153b000015350ULL, 0x0001549000015420ULL, 0x00015540000154f0ULL, 0x00015610000155b0ULL,
0x000156f000015680ULL, 0x000157e000015760ULL, 0x000158e000015860ULL, 0x000159e000015960ULL,
0x00015ae000015a60ULL, 0x0000040002003904ULL, 0x0001b600000000ffULL, 0x00000460003f0100ULL,
0x0001b6080000000fULL, 0x000004c0003f0120ULL, 0x0001b6880000000fULL, 0x00000b90003f0120ULL,
0x0001b600000000ffULL, 0x00000d40003f0107ULL, 0x0001b68c0000006bULL, 0x00000df0003f0102ULL,
0x0001b6880000006bULL, 0x00002b20003f0101ULL, 0x0001b6080000000dULL, 0x00002b40003f0101ULL,
0x0001b60c0000000dULL, 0x00002d10003f0105ULL, 0x0001b60c0000000dULL, 0x00003a80003f0105ULL,
0x0001b6880000005aULL, 0x00004820003f0101ULL, 0x0001b6280000000dULL, 0x00004880003f0101ULL,
0x0001b62c00000009ULL, 0x00004a50003f0105ULL, 0x0001b62c00000009ULL, 0x00005520003f0105ULL,
0x0001b6900000005aULL, 0x000062c0003f0101ULL, 0x0001b64800000009ULL, 0x00006320003f0101ULL,
0x0001b64c00000009ULL, 0x000064f0003f0105ULL, 0x0001b64c00000009ULL, 0x00006ff0003f0105ULL,
0x0001b6980000005aULL, 0x00007dd0003f0101ULL, 0x0001b66800000009ULL, 0x00007e30003f0101ULL,
0x0001b66c0000000bULL, 0x00008000003f0105ULL, 0x0001b66c0000000bULL, 0x00008a90003f0105ULL,
0x0001b6a00000005aULL, 0x0000c940003f0101ULL, 0x0001b600000000ffULL, 0x0000e180003f0101ULL,
0x0001b604000000ffULL, 0x0000e390003f0105ULL, 0x0001b604000000ffULL, 0x00012410003f0105ULL,
0x0000000000000075ULL, 0x00012510003f0101ULL, 0x0000000400000075ULL, 0x000126e0003f0105ULL,
0x0000000400000075ULL, 0x00014c20003f0105ULL, 0x0001b60800000076ULL, 0x00014c80003f0101ULL,
0x0001b61000000076ULL, 0x00014ce0003f0101ULL, 0x0001b61800000076ULL, 0x00014d50003f0101ULL,
0x0001b62000000076ULL, 0x00033803003f0101ULL, 0x0000bfb000201c04ULL, 0x0000c2700000bfe0ULL,
0x0000c6600000c460ULL, 0x0000e3f00000c810ULL, 0x0000040100014d90ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x000000000000026cULL, 0x0000001800000002ULL, 0x00000000000001dcULL, 0x0000001800000002ULL,
0x000000000000015cULL, 0x0000001800000002ULL, 0x00000000000000dcULL, 0x0000001800000002ULL,
0x0000000000000044ULL, 0x0000001800000002ULL, 0x0000000000000242ULL, 0x0000001800000002ULL,
0x00000000000001b2ULL, 0x0000001800000002ULL, 0x0000000000000137ULL, 0x0000001800000002ULL,
0x00000000000000b7ULL, 0x0000001800000002ULL, 0x000000000001b700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000797919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff040424ULL, 0x000fe200078e00ffULL,
0x0000000179020810ULL, 0x002fca0007ffe0ffULL, 0x00005c0002020625ULL, 0x000fc800078e0004ULL,
0x00005c0079040625ULL, 0x000fe200078e0004ULL, 0x0000000602000981ULL, 0x0002a8000c1e1900ULL,
0x00000006040d0981ULL, 0x0006a2000c1e1900ULL, 0x0000590000087b06ULL, 0x000f220000209000ULL,
0x00005900ff777624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000747919ULL, 0x000e620000002600ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x00005a00ff0c7624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x000e640000002300ULL,
0x000059000c0c7a24ULL, 0x000fe200078e02ffULL, 0x0000000800087308ULL, 0x010f240000001000ULL,
0x0ffffffe08067810ULL, 0x010fe40007ffe0ffULL, 0x0000000000087919ULL, 0x000f280000002100ULL,
0x0000000600077305ULL, 0x0002e4000021f000ULL, 0x000000ffff067224ULL, 0x002fc400078e00ffULL,
0x000000ffff097224ULL, 0x008fc800078e0a07ULL, 0x0000590009097a24ULL, 0x000fc800078e02ffULL,
0x0000000907077227ULL, 0x000fe400078e0006ULL, 0x0000000000067919ULL, 0x000e680000002200ULL,
0x0000040007097a27ULL, 0x000fc800078e00ffULL, 0x000000ffff027224ULL, 0x000fc800078e0a09ULL,
0x0000040002027624ULL, 0x000fca00078e0277ULL, 0x0000590002007a0cULL, 0x000fda0003f26070ULL,
0x8000590002021a10ULL, 0x000fe40007ffe0ffULL, 0x0000000109091810ULL, 0x000fe40007ffe0ffULL,
0x0000590002007a0cULL, 0x000fda0003f46070ULL, 0x0000000109092810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff09ba12ULL, 0x000fc800078e33ffULL, 0x0000000900047306ULL, 0x000ee20000209000ULL,
0x000000ff0900720cULL, 0x000fce0003fa5070ULL, 0x0000000400047308ULL, 0x008ee40000001000ULL,
0x0ffffffe04027810ULL, 0x008fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000664000021f000ULL,
0x000000ffff027224ULL, 0x008fe400078e00ffULL, 0x0000000309057224ULL, 0x002fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a05ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x00000074036e7227ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a6eULL,
0x0000000309027224ULL, 0x000fe400078e0274ULL, 0x000001000b037a24ULL, 0x000fe400078e0206ULL,
0x00001fff0b0b7589ULL, 0x000fe200000e0000ULL, 0x000000090200720cULL, 0x000fe20003f66070ULL,
0x00000000030f7a24ULL, 0x010fca00078e0208ULL, 0x000000ff0f00720cULL, 0x040fe40003f25270ULL,
0x0000000f0f00780cULL, 0x000fca0003f44070ULL, 0x0000000209023210ULL, 0x000fe40007ffe1ffULL,
0x000000016e6e3810ULL, 0x000fe40007ffe0ffULL, 0x000000090200720cULL, 0x000fe40003f86070ULL,
0x3fffff80ff049424ULL, 0x000fe200078e00ffULL, 0x00000005ff027819ULL, 0x000fe20000011608ULL,
0x7fffff80ff059424ULL, 0x000fe200078e00ffULL, 0x000000030f00780cULL, 0x000fe20003f64070ULL,
0x3fffffc0ff06a424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL,
0x01b60004ff009388ULL, 0x0003e80000000a00ULL, 0x000000016e6e4810ULL, 0x000fe20007ffe0ffULL,
0x00001fff02027589ULL, 0x000ee200000e0000ULL, 0x00000009ff6ed212ULL, 0x000fe400078e33ffULL,
0x0000007f0f00780cULL, 0x000fe20003f84070ULL, 0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL,
0x01b608060f00a388ULL, 0x000fe20000008a00ULL, 0x000000ffff037224ULL, 0x000fc800078e0a6eULL,
0x0000000309747224ULL, 0x000fe200078e0274ULL, 0x7fffff600009b802ULL, 0x000fc60000000f00ULL,
0x0000001074747824ULL, 0x000fe400078e00ffULL, 0xff317217ff0ac424ULL, 0x000fe200078e00ffULL,
0x01b688080f00b388ULL, 0x000fe80000008a00ULL, 0x01b4000a0f00c388ULL, 0x000fe20000004800ULL,
0x0000000100000824ULL, 0x004fe400078e0a0dULL, 0x00005800ff008624ULL, 0x000fc400078e00ffULL,
0x00005800790d8a24ULL, 0x000fe400078e02ffULL, 0x00005a0000037a24ULL, 0x000fe400078e02ffULL,
0x0000000c0d727224ULL, 0x000fe400078e02ffULL, 0x0000000103047824ULL, 0x042fe200078e0a74ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000740300720cULL, 0x000fe20003f26070ULL,
0x00000004ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000001004047817ULL, 0x000fe20003800000ULL,
0x00005a006e137a24ULL, 0x000fc600078e0272ULL, 0x000000ff04717207ULL, 0x000fe20000800000ULL,
0x000000040b047824ULL, 0x008fc600078e0202ULL, 0x000000107100780cULL, 0x000fe20003f05270ULL,
0x0000000204077824ULL, 0x000fd800078e00ffULL, 0x000002c000008947ULL, 0x000fea0003800000ULL,
0x00005a00000a7b06ULL, 0x000e620000209000ULL, 0x0000000000067919ULL, 0x000ea20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fca0003f45070ULL,
0x0000000a000a7308ULL, 0x002e620000001000ULL, 0x00000004ff087819ULL, 0x004fca0000011606ULL,
0x0000000107097824ULL, 0x000fe200078e0208ULL, 0x0ffffffe0a057810ULL, 0x002fcc0007ffe0ffULL,
0x0000000500057305ULL, 0x000e64000021f000ULL, 0x000000ffff0f7224ULL, 0x002fc800078e0a05ULL,
0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL, 0x0000000f050f7227ULL, 0x000fe200078e0004ULL,
0x0000000974047210ULL, 0x000fca0007ffe0ffULL, 0x000000040f0f7227ULL, 0x000fc800078e00ffULL,
0x000000ffff117224ULL, 0x000fc800078e0a0fULL, 0x00005a0011057a24ULL, 0x000fca00078e0204ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x000000010f0f0810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x000000010f0f1810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff0faa12ULL, 0x000fca00078e33ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a0fULL, 0x00005a0005047a24ULL, 0x000fc800078e0204ULL,
0x00000001130a7824ULL, 0x000fe200078e0204ULL, 0x0000000771047217ULL, 0x000fc60007800000ULL,
0x0000000c0f057224ULL, 0x000fe400078e020aULL, 0x00000010060c7824ULL, 0x000fe400078e00ffULL,
0x0000000104077824ULL, 0x000fe400078e0a07ULL, 0x0000010005047825ULL, 0x000fe200078e00ffULL,
0x000000f00c0f7812ULL, 0x000fe400078ec0ffULL, 0x000000070800720cULL, 0x000fe20003f06070ULL,
0x0000000109077824ULL, 0x040fe200078e0206ULL, 0x0000000f040f7212ULL, 0x000fe200078efcffULL,
0x0000001009087824ULL, 0x000fc600078e00ffULL, 0x000060000f047a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff008077812ULL, 0x000fe400078ee207ULL, 0x0000610005057a10ULL, 0x000fc60000ffe4ffULL,
0x0000001007077824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000c101c46ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x00005a0000087b06ULL, 0x000e620000209000ULL, 0x0000000000067919ULL, 0x000ea20000000000ULL,
0x000000ff00047202ULL, 0x000fe40000000f00ULL, 0x00005a00ff007a0cULL, 0x000fc80003f45070ULL,
0x0000000800087308ULL, 0x002e620000001000ULL, 0x0000000706077211ULL, 0x004fe400078fe0ffULL,
0x0ffffffe080a7810ULL, 0x002fca0007ffe0ffULL, 0x0000000a00057305ULL, 0x000e64000021f000ULL,
0x000000ffff097224ULL, 0x002fc800078e0a05ULL, 0x00005a0009097a24ULL, 0x000fc800078e02ffULL,
0x0000000905057227ULL, 0x000fc800078e0004ULL, 0x0000000174047824ULL, 0x000fc800078e0207ULL,
0x0000000405057227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a05ULL,
0x00005a0009087a24ULL, 0x000fca00078e0204ULL, 0x00005a0008007a0cULL, 0x000fda0003f06070ULL,
0x80005a0008080a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105050810ULL, 0x000fe40007ffe0ffULL,
0x00005a0008007a0cULL, 0x000fe20003f26070ULL, 0x0000000107087824ULL, 0x040fe400078e0206ULL,
0x0000001007077824ULL, 0x000fca00078e00ffULL, 0xfffffff007087812ULL, 0x000fca00078ee208ULL,
0x0000000105051810ULL, 0x000fe20007ffe0ffULL, 0x0000001008077824ULL, 0x000fe200078e00ffULL,
0x00005a00ff05aa12ULL, 0x000fca00078e33ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a05ULL,
0x00005a0009047a24ULL, 0x000fc800078e0204ULL, 0x0000000113047824ULL, 0x000fc800078e0204ULL,
0x0000000c05047224ULL, 0x000fe400078e0204ULL, 0x00000010060c7824ULL, 0x000fe400078e00ffULL,
0x0000010004047825ULL, 0x000fc600078e00ffULL, 0x000000f00c097812ULL, 0x000fc800078ec0ffULL,
0x0000000904047212ULL, 0x000fc800078efcffULL, 0x0000600004047a10ULL, 0x000fc80007f1e0ffULL,
0x0000610005057a10ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e8000b901c46ULL, 0x0000000000087919ULL, 0x000ea20000000000ULL,
0x0000000000047806ULL, 0x002fe400038e0000ULL, 0x0000000400547802ULL, 0x000fe40000000f00ULL,
0x0000000400057300ULL, 0x000ea600000e0000ULL, 0x0000680079687625ULL, 0x000fca00078e0054ULL,
0x0000000400077309ULL, 0x000e620000000000ULL, 0x000000080500720cULL, 0x004fe20003f02070ULL,
0x000000ffff057224ULL, 0x002fe400078e0a07ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x01b60405ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000668687981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fc40003f05270ULL, 0x0000003f686a7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff68597810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff6a7819ULL, 0x000fe4000001166aULL,
0x00000008ff597819ULL, 0x000fca0000011659ULL, 0x0000bba000008947ULL, 0x000fea0003800000ULL,
0x00000002ff6c7819ULL, 0x000fe20000011602ULL, 0x00000008026b7824ULL, 0x000fe400078e00ffULL,
0x00000003ff087424ULL, 0x000fe200078e00ffULL, 0x03ffffff6c007812ULL, 0x000fca00078ec0ffULL,
0x0000000403097824ULL, 0x000fca00078e0200ULL, 0x0000006a0900720cULL, 0x000fda0003f06070ULL,
0x0000000279008824ULL, 0x000fe400078e00ffULL, 0x00006a00ff058624ULL, 0x002fc800078e00ffULL,
0x00006a0000048624ULL, 0x000fe400078e0205ULL, 0xffffffffff007424ULL, 0x000fe400078e00ffULL,
0x0000000109058824ULL, 0x000fe200078e0204ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b68c086bff738cULL, 0x0003e20000000000ULL, 0x0000660005048625ULL, 0x000fe200078e0054ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000604008981ULL, 0x000ea2000c1e1900ULL,
0x0000000103087810ULL, 0x002fe20007ffe0ffULL, 0x00000100ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fe20000011602ULL, 0x01b688006bff7f8cULL, 0x0003e2000c80043fULL,
0x000000590800720cULL, 0x000fc40003f06070ULL, 0x000000066e657819ULL, 0x000fe200000006ffULL,
0x00000020076d7824ULL, 0x000fe200078e00ffULL, 0x0000000102677812ULL, 0x000fc600078ec0ffULL,
0x00000100030d7824ULL, 0x000fca00078e026dULL, 0x0000002065117812ULL, 0x000fe200078ef80dULL,
0x0000590000007a24ULL, 0x004fc800078e02ffULL, 0x0000004000007824ULL, 0x000fc800078e00ffULL,
0x0000640000047625ULL, 0x000fe200078e000bULL, 0x0000064000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1b7819ULL, 0x102fe40000011606ULL, 0x0000000d68007217ULL, 0x000fe40007800000ULL,
0x000000081b137810ULL, 0x040fe40007ffe0ffULL, 0x0000000c1b197810ULL, 0x040fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a0dULL, 0x000000041b0b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001130d7824ULL, 0x140fe200078e0206ULL, 0x000000700c0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000813107824ULL, 0x000fe200078e00ffULL, 0x0000002000007817ULL, 0x000fe20003800000ULL,
0x00000001190e7824ULL, 0x100fe200078e0206ULL, 0x0000000a670a7211ULL, 0x000fe200078e38ffULL,
0x0000000819237824ULL, 0x000fe200078e00ffULL, 0xfffffff810217812ULL, 0x000fe200078ee20dULL,
0x000000010b087824ULL, 0x040fe200078e0206ULL, 0x000000000b00720cULL, 0x0c0fe20003f86070ULL,
0x000000080b1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee20eULL,
0x00000001110f7824ULL, 0x000fe200078e020bULL, 0x000000101b1d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001110d7824ULL, 0x000fe200078e021bULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee208ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000000141b277810ULL, 0x000fe20007ffe0ffULL,
0x000000011d087824ULL, 0x000fe200078e0206ULL, 0x000000001300720cULL, 0x080fe20003f66070ULL,
0x000001000d0c7825ULL, 0x000fe200078e000aULL, 0x000000001900720cULL, 0x000fc40003f46070ULL,
0x000000001b00720cULL, 0x000fe20003fa6070ULL, 0x000001000f0e7825ULL, 0x000fe200078e000aULL,
0x0000000c04147210ULL, 0x040fe40007f1e0ffULL, 0x0000001c1b2b7810ULL, 0x000fe20007ffe0ffULL,
0x000000081d257824ULL, 0x000fe200078e00ffULL, 0x0000000e04167210ULL, 0x000fe20007f3e0ffULL,
0x0000000105157824ULL, 0x000fe200000e060dULL, 0x00000013110d7210ULL, 0x000fe20007ffe0ffULL,
0x0000000127107824ULL, 0x000fe200078e0206ULL, 0xfffffff825257812ULL, 0x000fe200078ee208ULL,
0x0000000105177824ULL, 0x000fe200008e060fULL, 0x000000001d00720cULL, 0x000fe20003f26070ULL,
0x00000001110f7824ULL, 0x000fc400078e0219ULL, 0x0000000827297824ULL, 0x000fe400078e00ffULL,
0x000001000f0e7825ULL, 0x000fc600078e000aULL, 0xfffffff829297812ULL, 0x000fe200078ee210ULL,
0x000000011b087824ULL, 0x000fe200078e0206ULL, 0x0000000e040e7210ULL, 0x000fe20007fde0ffULL,
0x000001000d0c7825ULL, 0x000fc600078e000aULL, 0x0000000708197812ULL, 0x000fe200078ec0ffULL,
0x0000000111137824ULL, 0x000fe200078e021dULL, 0x0000000c040c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000207107824ULL, 0x000fe200078e0267ULL, 0x0ffffff819197812ULL, 0x000fe200078ef806ULL,
0x0000010013127825ULL, 0x000fc600078e000aULL, 0x0001300010087811ULL, 0x000fe200078e68ffULL,
0x00000001050f7824ULL, 0x040fe200030e060fULL, 0x0000001204187210ULL, 0x040fe20007fde0ffULL,
0x00000001050d7824ULL, 0x000fe200000e060dULL, 0x000000002700720cULL, 0x000fe20003f06070ULL,
0x0000000111277824ULL, 0x000fe200078e0227ULL, 0x000000081f1f7211ULL, 0x080fe200078e20ffULL,
0x00000010191d7824ULL, 0x000fe200078e0208ULL, 0x0000000823237211ULL, 0x000fe200078e20ffULL,
0x0000000105197824ULL, 0x000fe400030e0613ULL, 0x0000010027127825ULL, 0x000fe200078e000aULL,
0x000000181b277810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x0003e4000e901c46ULL, 0x00000001112d7824ULL, 0x040fe200078e022bULL,
0x0000001204127210ULL, 0x000fe20007fde0ffULL, 0x00000001111b7824ULL, 0x000fe200078e0227ULL,
0x00000000161f7faeULL, 0x0005e2000e101c46ULL, 0x000000002700720cULL, 0x080fe20003fa6070ULL,
0x0000001021217824ULL, 0x000fe200078e0208ULL, 0x000000002b00720cULL, 0x000fe20003f86070ULL,
0x000001001b107825ULL, 0x000fc600078e000aULL, 0x000000000c217faeULL, 0x0007e2000d901c46ULL,
0x0000000105137824ULL, 0x000fe200030e0613ULL, 0x0000001004107210ULL, 0x000fe20007fde0ffULL,
0x0000000127007824ULL, 0x140fe200078e0206ULL, 0x000000000e237faeULL, 0x0007e2000d101c46ULL,
0x0000000827157824ULL, 0x002fe400078e00ffULL, 0x000000012b147824ULL, 0x040fe400078e0206ULL,
0x000000082b177824ULL, 0x004fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee200ULL,
0x000001002d0a7825ULL, 0x000fc600078e000aULL, 0xfffffff817177812ULL, 0x000fe200078ee214ULL,
0x0000000105117824ULL, 0x000fe200030e0611ULL, 0x0000000a04047210ULL, 0x000fe20007fde0ffULL,
0x0000001025257824ULL, 0x100fe400078e0208ULL, 0x0000001029297824ULL, 0x100fe400078e0208ULL,
0x0000001015157824ULL, 0x100fe200078e0208ULL, 0x0000000018257faeULL, 0x0007e2000c901c46ULL,
0x0000001017177824ULL, 0x000fe400078e0208ULL, 0x0000000105057824ULL, 0x000fe200030e060bULL,
0x0000000012297faeULL, 0x0007e8000c101c46ULL, 0x0000000010157faeULL, 0x0007e8000e901c46ULL,
0x0000000004177faeULL, 0x0007e2000e101c46ULL, 0x0000057000007947ULL, 0x000fea0003800000ULL,
0x00000008060a7811ULL, 0x042fe200078fe8ffULL, 0x0000000207147824ULL, 0x000fe200078e0267ULL,
0x0000000406087811ULL, 0x000fc400078fe8ffULL, 0x0000000c060e7811ULL, 0x000fe200078fe8ffULL,
0x000000010a0b7824ULL, 0x100fe200078e0206ULL, 0x0000001406107811ULL, 0x000fe200078fe8ffULL,
0x000000080a1c7824ULL, 0x000fe200078e00ffULL, 0x000000700c187812ULL, 0x000fe200078ec0ffULL,
0x0000000108007824ULL, 0x100fe200078e0206ULL, 0x0000001c060c7811ULL, 0x000fe200078fe8ffULL,
0x00000008080d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL,
0x000000080e157824ULL, 0x000fe200078e00ffULL, 0x00000010060b7811ULL, 0x000fe200078fe8ffULL,
0x00000001100f7824ULL, 0x040fe200078e0206ULL, 0xfffffff80d1a7812ULL, 0x000fe200078ee200ULL,
0x0000000810227824ULL, 0x000fe200078e00ffULL, 0x000000060e007210ULL, 0x080fe20007ffe0ffULL,
0x000000010b0d7824ULL, 0x040fe200078e0206ULL, 0x0000001806127811ULL, 0x000fe200078fe8ffULL,
0x000000080b207824ULL, 0x000fe200078e00ffULL, 0xfffffff8151e7812ULL, 0x000fe200078ee200ULL,
0x000000080c197824ULL, 0x000fe200078e00ffULL, 0x0000000606007211ULL, 0x000fe200078fe8ffULL,
0x0000000112137824ULL, 0x100fe200078e0206ULL, 0xfffffff820207812ULL, 0x000fe200078ee20dULL,
0x0000000812247824ULL, 0x000fe200078e00ffULL, 0x00000007000d7812ULL, 0x000fe200078ec0ffULL,
0x000000010c007824ULL, 0x000fe200078e0206ULL, 0xfffffff822227812ULL, 0x000fe200078ee20fULL,
0x0000000111177824ULL, 0x040fe200078e020bULL, 0x00000008110f7210ULL, 0x000fe20007ffe0ffULL,
0x0000008067187824ULL, 0x000fe200078e0218ULL, 0x00000011060b7211ULL, 0x000fe200078fe8ffULL,
0x0000000111157824ULL, 0x000fe200078e020eULL, 0xfffffff819087812ULL, 0x000fe200078ee200ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee213ULL,
0x0000000111137824ULL, 0x000fe200078e020aULL, 0x0ffffff80d007812ULL, 0x000fe200078ef806ULL,
0x00000001111f7824ULL, 0x000fe200078e020cULL, 0x0001300014297811ULL, 0x000fe200078e68ffULL,
0x000001000b0a7825ULL, 0x000fc800078e0018ULL, 0x000001000f0c7825ULL, 0x000fe200078e0018ULL,
0x0000000a040a7210ULL, 0x000fc60007f1e0ffULL, 0x00000001111b7824ULL, 0x040fe200078e0210ULL,
0x0000000c040c7210ULL, 0x000fe20007f3e0ffULL, 0x00000001111d7824ULL, 0x000fe400078e0212ULL,
0x00000100130e7825ULL, 0x000fc800078e0018ULL, 0x0000010015107825ULL, 0x000fe200078e0018ULL,
0x0000000e040e7210ULL, 0x000fc60007f5e0ffULL, 0x0000010017127825ULL, 0x100fe200078e0018ULL,
0x0000001004107210ULL, 0x000fe40007f7e0ffULL, 0x0000000f050f7210ULL, 0x000fe200017fe4ffULL,
0x000001001b147825ULL, 0x000fe200078e0018ULL, 0x00000029001b7211ULL, 0x000fc600078e20ffULL,
0x000001001d167825ULL, 0x000fc800078e0018ULL, 0x000001001f187825ULL, 0x000fe200078e0018ULL,
0x0000001604167210ULL, 0x000fc60007f5e0ffULL, 0x00000001050b7824ULL, 0x040fe200000e060bULL,
0x0000001204127210ULL, 0x040fe20007f1e0ffULL, 0x00000001050d7824ULL, 0x040fe200008e060dULL,
0x0000001404147210ULL, 0x000fe20007f3e0ffULL, 0x000000101a1d7824ULL, 0x000fe200078e0229ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a1b7faeULL, 0x0003e2000b901c46ULL,
0x0000000105117824ULL, 0x000fe200018e0611ULL, 0x0000001804047210ULL, 0x000fe20007f7e0ffULL,
0x000000101c1f7824ULL, 0x100fe200078e0229ULL, 0x000000000c1d7faeULL, 0x0003e2000b901c46ULL,
0x000000101e217824ULL, 0x000fc400078e0229ULL, 0x0000001020237824ULL, 0x000fe200078e0229ULL,
0x000000000e1f7faeULL, 0x0003e2000b901c46ULL, 0x0000000105137824ULL, 0x040fe400000e0613ULL,
0x0000001022257824ULL, 0x000fe200078e0229ULL, 0x0000000010217faeULL, 0x0003e2000b901c46ULL,
0x0000000105157824ULL, 0x040fe400008e0615ULL, 0x0000001024277824ULL, 0x000fe200078e0229ULL,
0x0000000012237faeULL, 0x0003e2000b901c46ULL, 0x0000000105177824ULL, 0x000fc400010e0617ULL,
0x0000001008297824ULL, 0x000fe200078e0229ULL, 0x0000000014257faeULL, 0x0003e2000b901c46ULL,
0x0000000105057824ULL, 0x000fc600018e0619ULL, 0x0000000016277faeULL, 0x0003e8000b901c46ULL,
0x0000000004297faeULL, 0x0003e4000b901c46ULL, 0x00000300ff057624ULL, 0x00afe200078e00ffULL,
0x0000000309007812ULL, 0x000fe200078ec0ffULL, 0xffffffffff517424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xfffffffd54707424ULL, 0x000fe200078e0205ULL,
0x000000030000780cULL, 0x000fc80003f05270ULL, 0x0000000170087807ULL, 0x000fca0004000000ULL,
0x0000000109087824ULL, 0x000fca00078e0208ULL, 0x0000006a0800720cULL, 0x000fda0003f06070ULL,
0x0000000279008824ULL, 0x000fe400078e00ffULL, 0x00006a00ff058624ULL, 0x000fc800078e00ffULL,
0x00006a0000058624ULL, 0x000fca00078e0205ULL, 0x0000000805558210ULL, 0x000fca0007ffe0ffULL,
0x0000660055548625ULL, 0x000fca00078e0054ULL, 0x0000000654518981ULL, 0x000322000c1e1900ULL,
0x000000590300720cULL, 0x000fe20003f06070ULL, 0xff317217ff0a7424ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00006e4000000947ULL, 0x000fea0003800000ULL,
0x0000000279667824ULL, 0x002fe400078e00ffULL, 0x00006a00ff057624ULL, 0x000fc400078e00ffULL,
0xff317217ff0a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fe400078e00ffULL,
0x00006a0066667624ULL, 0x000fc400078e0205ULL, 0x00000010020b7824ULL, 0x000fe200078e00ffULL,
0x00000001030e7810ULL, 0x020fe20007ffe0ffULL, 0x0000590051517a24ULL, 0x010fe200078e02ffULL,
0x00000100000d7802ULL, 0x000fe20000000f00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe00b0c7812ULL, 0x000fe400078ec0ffULL, 0x000000590e00720cULL, 0x000fc60003f06070ULL,
0x00000100030c7824ULL, 0x000fca00078e020cULL, 0x000000400c0f7810ULL, 0x000fe20007ffe0ffULL,
0x00000040510c7824ULL, 0x000fc600078e00ffULL, 0x000000200f0e7812ULL, 0x000fe200078ec0ffULL,
0x000064000c0c7625ULL, 0x000fc800078e000dULL, 0x00000001650b7824ULL, 0x000fe200078e020eULL,
0x0000068000008947ULL, 0x000fea0003800000ULL, 0x0000001006117824ULL, 0x000fe200078e00ffULL,
0x0000000f680e7217ULL, 0x000fe20007800000ULL, 0x0000008002107824ULL, 0x040fe200078e00ffULL,
0x00000003ff407819ULL, 0x000fe40000011606ULL, 0x0000007011137812ULL, 0x000fe200078ec0ffULL,
0x0000200002117824ULL, 0x000fe200078e00ffULL, 0x0000000440247810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0f7824ULL, 0x000fe200078e0a0fULL, 0x00000080130e7812ULL, 0x000fc400078ef810ULL,
0x0000200011107812ULL, 0x000fe200078ec0ffULL, 0x0000000124117824ULL, 0x000fe200078e0206ULL,
0x0000000c40427810ULL, 0x000fe20007ffe0ffULL, 0x0000000824127824ULL, 0x000fe200078e00ffULL,
0x00000008403e7810ULL, 0x000fe20007ffe0ffULL, 0x0000400007307824ULL, 0x000fe200078e0210ULL,
0x000000200f3d7817ULL, 0x000fe20003800000ULL, 0x0000000142337824ULL, 0x100fe200078e0206ULL,
0xfffffff812417812ULL, 0x000fe200078ee211ULL, 0x0000000842107824ULL, 0x000fe200078e00ffULL,
0x000000033e137819ULL, 0x040fe200000006ffULL, 0x000000013e3c7824ULL, 0x100fe200078e0206ULL,
0x0000001040447810ULL, 0x040fe20007ffe0ffULL, 0x0000000140117824ULL, 0x040fe200078e020bULL,
0x0000001440467810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0xfffffff810337812ULL, 0x000fe200078ee233ULL, 0x0000000144327824ULL, 0x000fe200078e0206ULL,
0xfffffff8133c7812ULL, 0x000fe200078ee23cULL, 0x0000010011107825ULL, 0x000fe200078e000eULL,
0x0000003d2400720cULL, 0x000fc40003f66070ULL, 0x0000003d3e00720cULL, 0x080fe20003f06070ULL,
0x0000000844137824ULL, 0x000fe200078e00ffULL, 0x000000100c267210ULL, 0x000fe20007f5e0ffULL,
0x0000000146077824ULL, 0x000fe200078e0206ULL, 0x0000003d4000720cULL, 0x080fe20003f86070ULL,
0x0000000846127824ULL, 0x000fe200078e00ffULL, 0xfffffff813327812ULL, 0x000fe200078ee232ULL,
0x0000000124137824ULL, 0x100fe200078e020bULL, 0x0000003d4200720cULL, 0x000fe20003f26070ULL,
0x000000013e257824ULL, 0x000fe200078e020bULL, 0xfffffff812077812ULL, 0x000fe200078ee207ULL,
0x0000000142317824ULL, 0x000fe200078e020bULL, 0x0000000640127210ULL, 0x000fe20007ffe0ffULL,
0x000000010d277824ULL, 0x000fe200010e0611ULL, 0x00014000303e7810ULL, 0x000fe20007ffe0ffULL,
0x0000010013107825ULL, 0x000fe200078e000eULL, 0x00000007123f7812ULL, 0x000fc400078ec0ffULL,
0x0000001840427810ULL, 0x000fe20007ffe0ffULL, 0x0000010025127825ULL, 0x000fe200078e000eULL,
0x000000100c307210ULL, 0x040fe40007f5e0ffULL, 0x0ffffff83f3f7812ULL, 0x000fe200078ef806ULL,
0x0000010031247825ULL, 0x000fe200078e000eULL, 0x000000120c107210ULL, 0x000fe40007fbe0ffULL,
0x0000001c40407810ULL, 0x000fe20007ffe0ffULL, 0x000000010d317824ULL, 0x040fe200010e0611ULL,
0x000000240c127210ULL, 0x000fe20007fde0ffULL, 0x000000010d117824ULL, 0x000fe200028e0613ULL,
0x0000003d4400720cULL, 0x080fe20003f46070ULL, 0x000000103f3f7824ULL, 0x100fe200078e023eULL,
0x0000003d4600720cULL, 0x000fe20003fa6070ULL, 0x000000010d137824ULL, 0x000fe200030e0625ULL,
0x0000000b44257210ULL, 0x000fe20007ffe0ffULL, 0x0000001041417824ULL, 0x000fe200078e023eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000263f7faeULL, 0x0003e2000e101c46ULL,
0x0000000146437824ULL, 0x000fe200078e020bULL, 0x0000003d4200720cULL, 0x080fe20003f86070ULL,
0x0000010025247825ULL, 0x000fe200078e000eULL, 0x0000000030417faeULL, 0x0005e2000d901c46ULL,
0x0000003d4000720cULL, 0x000fc40003f66070ULL, 0x00000001423d7824ULL, 0x100fe200078e020bULL,
0x000000240c247210ULL, 0x000fe20007fde0ffULL, 0x00000001400b7824ULL, 0x000fe400078e020bULL,
0x0000001033337824ULL, 0x000fe400078e023eULL, 0x0000010043267825ULL, 0x002fc800078e000eULL,
0x000000010d257824ULL, 0x000fe200030e0625ULL, 0x000000260c267210ULL, 0x000fe20007fde0ffULL,
0x000001003d307825ULL, 0x004fc800078e000eULL, 0x00000001423f7824ULL, 0x140fe400078e0206ULL,
0x0000000842427824ULL, 0x000fe400078e00ffULL, 0x00000001403d7824ULL, 0x000fe400078e0206ULL,
0x000000010d277824ULL, 0x000fe200030e0627ULL, 0x000000300c307210ULL, 0x000fe20007fde0ffULL,
0x0000000840407824ULL, 0x000fe200078e00ffULL, 0xfffffff8423f7812ULL, 0x000fe200078ee23fULL,
0x000001000b0e7825ULL, 0x000fe200078e000eULL, 0x000000310d317210ULL, 0x000fc400037fe4ffULL,
0xfffffff840417812ULL, 0x000fe200078ee23dULL, 0x000000103c0b7824ULL, 0x100fe200078e023eULL,
0x0000000e0c0c7210ULL, 0x000fe20007fde0ffULL, 0x00000010323d7824ULL, 0x100fe400078e023eULL,
0x0000001007077824ULL, 0x100fe200078e023eULL, 0x00000000100b7faeULL, 0x0003e2000c101c46ULL,
0x000000103f3f7824ULL, 0x100fe400078e023eULL, 0x0000001041417824ULL, 0x000fe200078e023eULL,
0x0000000012337faeULL, 0x0003e2000c901c46ULL, 0x000000010d0d7824ULL, 0x000fc600030e060fULL,
0x00000000243d7faeULL, 0x0003e8000d101c46ULL, 0x0000000026077faeULL, 0x0003e8000e901c46ULL,
0x00000000303f7faeULL, 0x0003e8000e101c46ULL, 0x000000000c417faeULL, 0x0003e2000d901c46ULL,
0x000005b000007947ULL, 0x000fea0003800000ULL, 0x00002000020f7824ULL, 0x000fe200078e00ffULL,
0x0000000406117811ULL, 0x040fe200078fe8ffULL, 0x00000010060e7824ULL, 0x000fe200078e00ffULL,
0x00000007023d7819ULL, 0x000fc400000006ffULL, 0x000020000f107812ULL, 0x000fe200078ec0ffULL,
0x0000000811127824ULL, 0x000fe200078e00ffULL, 0x000000700e0e7812ULL, 0x000fe400078ec0ffULL,
0x0000000806137811ULL, 0x040fe200078fe8ffULL, 0x0000400007107824ULL, 0x000fe200078e0210ULL,
0x0000001006277811ULL, 0x000fe200078fe8ffULL, 0x0000000111077824ULL, 0x100fe200078e0206ULL,
0x000000800e3c7812ULL, 0x000fe200078ef83dULL, 0x00000001130e7824ULL, 0x140fe200078e0206ULL,
0x0000000c06257811ULL, 0x040fe200078fe8ffULL, 0x0000000813417824ULL, 0x000fe200078e00ffULL,
0x0000001406317811ULL, 0x000fe200078fe8ffULL, 0x0000000111117824ULL, 0x000fe200078e020bULL,
0xfffffff8123f7812ULL, 0x000fe200078ee207ULL, 0x0000000127077824ULL, 0x000fe200078e0206ULL,
0xfffffff841417812ULL, 0x000fe200078ee20eULL, 0x0000000827127824ULL, 0x000fe200078e00ffULL,
0x0000001806337811ULL, 0x000fe200078fe8ffULL, 0x00000001250f7824ULL, 0x100fe200078e0206ULL,
0x00000006310e7210ULL, 0x080fe20007ffe0ffULL, 0x0000000825247824ULL, 0x000fe200078e00ffULL,
0xfffffff812457812ULL, 0x000fe200078ee207ULL, 0x0000000831477824ULL, 0x000fe200078e00ffULL,
0x0000000606077211ULL, 0x000fe200078fe8ffULL, 0x0000000113137824ULL, 0x000fe200078e020bULL,
0xfffffff824437812ULL, 0x000fe200078ee20fULL, 0x00000001330f7824ULL, 0x000fe200078e0206ULL,
0xfffffff847477812ULL, 0x000fe200078ee20eULL, 0x0000000833247824ULL, 0x000fe200078e00ffULL,
0x0000001c060e7811ULL, 0x000fe200078fe8ffULL, 0x0000000125257824ULL, 0x100fe200078e020bULL,
0x00000007073d7812ULL, 0x000fe200078ec0ffULL, 0x0000000127277824ULL, 0x000fe200078e020bULL,
0xfffffff824497812ULL, 0x000fe200078ee20fULL, 0x0000000131317824ULL, 0x100fe200078e020bULL,
0x0000000b060f7211ULL, 0x000fe200078fe8ffULL, 0x0000000133337824ULL, 0x100fe200078e020bULL,
0x000000030e4b7819ULL, 0x040fe200000006ffULL, 0x000000010e077824ULL, 0x040fe200078e020bULL,
0x0ffffff83d0b7812ULL, 0x100fe200078ef806ULL, 0x000000010e127824ULL, 0x000fe200078e0206ULL,
0x00014000103e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3d7224ULL, 0x000fc600078e00ffULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee212ULL, 0x000001000f0e7825ULL, 0x000fc800078e003cULL,
0x0000010011107825ULL, 0x000fe200078e003cULL, 0x0000000e0c0e7210ULL, 0x000fc60007f1e0ffULL,
0x0000010013127825ULL, 0x000fe200078e003cULL, 0x000000100c107210ULL, 0x000fc60007f3e0ffULL,
0x0000010025247825ULL, 0x000fe200078e003cULL, 0x000000120c127210ULL, 0x000fc60007f5e0ffULL,
0x0000010027267825ULL, 0x000fe200078e003cULL, 0x000000240c247210ULL, 0x000fc60007f7e0ffULL,
0x0000010031307825ULL, 0x000fc800078e003cULL, 0x0000010033327825ULL, 0x000fc800078e003cULL,
0x00000100073c7825ULL, 0x000fc800078e003cULL, 0x000000010d0f7824ULL, 0x040fe200000e060fULL,
0x000000260c267210ULL, 0x040fe20007f1e0ffULL, 0x000000010d117824ULL, 0x000fe200008e0611ULL,
0x000000300c307210ULL, 0x040fe20007f3e0ffULL, 0x000000100b077824ULL, 0x100fe400078e023eULL,
0x000000010d137824ULL, 0x000fe200010e0613ULL, 0x000000320c327210ULL, 0x040fe20007f5e0ffULL,
0x000000103f0b7824ULL, 0x100fe200078e023eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e077faeULL, 0x0003e2000b901c46ULL, 0x000000010d257824ULL, 0x000fe200018e0625ULL,
0x0000003c0c0c7210ULL, 0x000fe20007f7e0ffULL, 0x00000010413f7824ULL, 0x100fe200078e023eULL,
0x00000000100b7faeULL, 0x0003e2000b901c46ULL, 0x0000001043417824ULL, 0x000fc400078e023eULL,
0x0000001045437824ULL, 0x100fe200078e023eULL, 0x00000000123f7faeULL, 0x0003e2000b901c46ULL,
0x000000010d277824ULL, 0x000fe400000e0627ULL, 0x0000001047457824ULL, 0x100fe200078e023eULL,
0x0000003e49477211ULL, 0x000fe200078e20ffULL, 0x000000010d317824ULL, 0x040fe200008e0631ULL,
0x0000000024417faeULL, 0x0003e2000b901c46ULL, 0x000000010d337824ULL, 0x000fe400010e0633ULL,
0x000000104b497824ULL, 0x000fe200078e023eULL, 0x0000000026437faeULL, 0x0003e2000b901c46ULL,
0x000000010d0d7824ULL, 0x000fc600018e063dULL, 0x0000000030457faeULL, 0x0003e8000b901c46ULL,
0x0000000032477faeULL, 0x0003e8000b901c46ULL, 0x000000000c497faeULL, 0x0003e4000b901c46ULL,
0x0000000308077812ULL, 0x002fe200078ec0ffULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000030700780cULL, 0x000fc80003f05270ULL,
0x0000000170077807ULL, 0x000fc80004000000ULL, 0x0000000807087210ULL, 0x000fc80007ffe0ffULL,
0x0000006a0800720cULL, 0x000fda0003f06070ULL, 0x0000000166108824ULL, 0x000fe400078e0208ULL,
0x00000004ff118424ULL, 0x000fc800078e00ffULL, 0x0000660010108625ULL, 0x000fca00078e0011ULL,
0x00000006100f8981ULL, 0x000322000c1e1900ULL, 0xffffffe06b0d7812ULL, 0x040fe400078ec0ffULL,
0x000000106b0c7812ULL, 0x040fe400078ec0ffULL, 0x000000086b077812ULL, 0x000fc800078ec0ffULL,
0x0000000d070d7210ULL, 0x000fe20007ffe00cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b608000d247f8cULL, 0x0022a4000c80043fULL, 0x0000000000107805ULL, 0x000fc40000015200ULL,
0x01b60c000d077984ULL, 0x000ee40000000800ULL, 0x8000000007ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x00000012100c7210ULL, 0x000fca0007f1e1ffULL,
0x0000000113127824ULL, 0x000fe200000e0e11ULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011412ULL,
0x0000000c07077211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e0612ULL,
0x0000000207077819ULL, 0x000fc8000000120cULL, 0x000000070000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b60c000d077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001006697824ULL, 0x000fe200078e00ffULL, 0x00000001ff6f7819ULL, 0x000fc80000011606ULL,
0x0000007069697812ULL, 0x000fe400078ec0ffULL, 0x0000000c6f6f7812ULL, 0x000fc600078ec0ffULL,
0x000000806c0c7824ULL, 0x000fc800078e0269ULL, 0x000000010c0c7824ULL, 0x000fca00078e026fULL,
0x01b000000c257984ULL, 0x000ea80000000800ULL, 0x01b200000c0e7984ULL, 0x0006620000000800ULL,
0x0000000a2500720bULL, 0x004fe20003f1d000ULL, 0x00011fa27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0b277812ULL, 0x000fe2000782c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff077224ULL, 0x000fd400078e000aULL, 0x0000043000009947ULL, 0x000fea0003800000ULL,
0x000000026c00720cULL, 0x000fe40003f25270ULL, 0x0000000a2500720bULL, 0x000fe20003f54000ULL,
0x00011f627f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x000fc400010e0100ULL,
0x0000008002109824ULL, 0x000fe200078e0269ULL, 0x0000000a25077209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099100c0b7816ULL, 0x000fe200000000ffULL,
0x000000016f109824ULL, 0x000fca00078e0210ULL, 0x01b4000710009388ULL, 0x0005e20000000800ULL,
0x000000ff0b00720cULL, 0x000fda0003f25270ULL, 0x0000030000009947ULL, 0x000fea0003800000ULL,
0x0000000a070a7221ULL, 0x004fe20000010100ULL, 0x000000ff0cff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0a0a7820ULL, 0x000fcc0000410000ULL,
0x0000000a000a7308ULL, 0x000ea40000000800ULL, 0x0000000a09097220ULL, 0x004fe40000410000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000002ff0b7819ULL, 0x000fe20000011606ULL,
0x00011ea27f007947ULL, 0x000fea000b800000ULL, 0x00001f0b0a0b7589ULL, 0x0004e400000e0000ULL,
0x0000000b2c2c7220ULL, 0x08cfe40000410000ULL, 0x0000000b2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000b28287220ULL, 0x080fe40000410000ULL, 0x0000000b29297220ULL, 0x000fc40000410000ULL,
0x0000000b20207220ULL, 0x080fe40000410000ULL, 0x0000000b21217220ULL, 0x080fe40000410000ULL,
0x0000000b14147220ULL, 0x080fe40000410000ULL, 0x0000000b15157220ULL, 0x080fe40000410000ULL,
0x0000000b18187220ULL, 0x080fe40000410000ULL, 0x0000000b19197220ULL, 0x000fc40000410000ULL,
0x0000000b34347220ULL, 0x080fe40000410000ULL, 0x0000000b35357220ULL, 0x080fe40000410000ULL,
0x0000000b38387220ULL, 0x080fe40000410000ULL, 0x0000000b39397220ULL, 0x080fe40000410000ULL,
0x0000000b1c1c7220ULL, 0x080fe40000410000ULL, 0x0000000b1d1d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000cff7812ULL, 0x000fda000782c0ffULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000008060b7811ULL, 0x000fe200078ff0ffULL,
0x00011da27f007947ULL, 0x000fea000b800000ULL, 0x00001f0b0a0b7589ULL, 0x0004e400000e0000ULL,
0x0000000b2e2e7220ULL, 0x08cfe40000410000ULL, 0x0000000b2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000b2a2a7220ULL, 0x080fe40000410000ULL, 0x0000000b2b2b7220ULL, 0x080fe40000410000ULL,
0x0000000b22227220ULL, 0x080fe40000410000ULL, 0x0000000b23237220ULL, 0x000fc40000410000ULL,
0x0000000b16167220ULL, 0x080fe40000410000ULL, 0x0000000b17177220ULL, 0x080fe40000410000ULL,
0x0000000b1a1a7220ULL, 0x080fe40000410000ULL, 0x0000000b1b1b7220ULL, 0x080fe40000410000ULL,
0x0000000b36367220ULL, 0x080fe40000410000ULL, 0x0000000b37377220ULL, 0x000fc40000410000ULL,
0x0000000b3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000b3b3b7220ULL, 0x080fe40000410000ULL,
0x0000000b1e1e7220ULL, 0x080fe40000410000ULL, 0x0000000b1f1f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff27ff7812ULL, 0x000fda000782600cULL,
0x8000000725251221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b25251820ULL, 0x000fc80000410000ULL, 0x0000002500051308ULL, 0x000ea40000000800ULL,
0x000000050e0e1220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x000000090e0e7221ULL, 0x002fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000005ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff097819ULL, 0x000fe40000011606ULL,
0x00005410000a7816ULL, 0x000fe20000000000ULL, 0x00011bf27f007947ULL, 0x000fea000b800000ULL,
0x00001f090a047589ULL, 0x0002a400000e0000ULL, 0x00000008090b7810ULL, 0x000fe20007ffe0ffULL,
0x00011c427f007947ULL, 0x000fea000b800000ULL, 0x00001f0b0a007589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010090b7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200078e000aULL, 0x000033d000117802ULL, 0x000fe20000000f00ULL,
0x0000001fff137424ULL, 0x000fc400078e00ffULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x000128f000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000018090b7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200078e000aULL,
0x0000344000117802ULL, 0x000fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fe400078e00ffULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x0001288000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002025a7824ULL, 0x000fe200078e00ffULL,
0x00000007060b7812ULL, 0x04cfe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000008060a7812ULL, 0x002fe400078ec0ffULL, 0x000000045a097812ULL, 0x000fc400078ec0ffULL,
0x000000080b107812ULL, 0x000fe400078ef806ULL, 0x0000000906097211ULL, 0x000fc600078fe0ffULL,
0x0000000810647824ULL, 0x040fe400078e00ffULL, 0x0000000110637824ULL, 0x000fca00078e0209ULL,
0xfffffff864647812ULL, 0x000fc800078ee263ULL, 0x0000000464647819ULL, 0x000fca00000006ffULL,
0x000008006c487824ULL, 0x000fca00078e0264ULL, 0x00000004ff127819ULL, 0x000fe20000011606ULL,
0x011000004848783bULL, 0x000e620000000200ULL, 0x0000000b0a0c7212ULL, 0x040fe200078efcffULL,
0x000059000f0f7a24ULL, 0x010fe200078e02ffULL, 0x00000001ff097819ULL, 0x000fe40000011602ULL,
0x000000100a137812ULL, 0x000fe200078efe0bULL, 0x0000000112117824ULL, 0x000fe200078e020cULL,
0xfffffff85a5a7812ULL, 0x000fe200078ec0ffULL, 0x00000002090a7824ULL, 0x040fe200078e0267ULL,
0x0000001306617211ULL, 0x000fe200078fe0ffULL, 0x00000004090b7824ULL, 0x000fe200078e0212ULL,
0x00000004115b7810ULL, 0x040fe20007ffe0ffULL, 0x000000080c257824ULL, 0x040fe200078e00ffULL,
0x00000006115e7810ULL, 0x040fe20007ffe0ffULL, 0x000000080c247824ULL, 0x040fe200078e00ffULL,
0x00000002115c7810ULL, 0x000fe20007ffe0ffULL, 0x000000080c127824ULL, 0x000fe200078e00ffULL,
0xfffffff8255e7812ULL, 0x000fe200078ee25eULL, 0x000020000a0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8245b7812ULL, 0x000fc400078ee25bULL, 0xfffffff8125d7812ULL, 0x000fe200078ee211ULL,
0x0000000813117824ULL, 0x040fe200078e00ffULL, 0x000130000c0a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000813127824ULL, 0x000fe200078e00ffULL, 0xfffffff8255c7812ULL, 0x000fe400078ee25cULL,
0x000000020b0b7810ULL, 0x000fe20007ffe010ULL, 0x000000105b507824ULL, 0x100fe200078e020aULL,
0x0000000a5c547211ULL, 0x000fe200078e20ffULL, 0x000000105d447824ULL, 0x100fe200078e020aULL,
0x00000004615f7810ULL, 0x040fe20007ffe0ffULL, 0x000000105e4c7824ULL, 0x000fe200078e020aULL,
0x0000000661627810ULL, 0x040fe20007ffe0ffULL, 0x0000000810107824ULL, 0x000fe200078e00ffULL,
0x000000005454783bULL, 0x000ea20000004200ULL, 0x0000000261607810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8125f7812ULL, 0x000fe200078ee25fULL, 0x000000005050783bULL, 0x000ee20000004200ULL,
0xfffffff8100b7812ULL, 0x000fe200078ee20bULL, 0x0000000813107824ULL, 0x000fe200078e00ffULL,
0xfffffff811607812ULL, 0x000fe200078ee260ULL, 0x000000004444783bULL, 0x000fe20000004200ULL,
0x0000000813137824ULL, 0x000fe200078e00ffULL, 0x0000000448480232ULL, 0x082fe20000000000ULL,
0x000000100b587824ULL, 0x000fe200078e00ffULL, 0x000000004c4c783bULL, 0x000fe20000004200ULL,
0xfffffff810617812ULL, 0x000fe200078ee261ULL, 0x000000105f307824ULL, 0x000fe200078e020aULL,
0xfffffff813627812ULL, 0x000fe200078ee262ULL, 0x000008006c247824ULL, 0x000fe200078e0258ULL,
0x0000000a60107211ULL, 0x000fe200078e20ffULL, 0x00000010613c7824ULL, 0x100fe200078e020aULL,
0x000000044a4a0232ULL, 0x000fe20000000000ULL, 0x0000001062407824ULL, 0x000fe200078e020aULL,
0x000000003030783bULL, 0x000fe20000004200ULL, 0x0000000049490232ULL, 0x080fe20000000000ULL,
0x00000008030a7824ULL, 0x000fe200078e0209ULL, 0x000000004b4b0232ULL, 0x000fe20000000000ULL,
0x011000002424783bULL, 0x000e680000000200ULL, 0x000000001010783bULL, 0x000e680000004200ULL,
0x000000003c3c783bULL, 0x000e680000004200ULL, 0x000000004040783bULL, 0x000e620000004200ULL,
0x000000544820723cULL, 0x044f700000001820ULL, 0x000000564814723cULL, 0x040f700000001814ULL,
0x000000504818723cULL, 0x048f700000001818ULL, 0x000000524834723cULL, 0x000f620000001834ULL,
0x0000000424240232ULL, 0x002fc40000000000ULL, 0x0000000426260232ULL, 0x000fe40000000000ULL,
0x0000000025250232ULL, 0x080fe40000000000ULL, 0x0000000027270232ULL, 0x000fe20000000000ULL,
0x00000044482c723cULL, 0x040f70000000182cULL, 0x000000464828723cULL, 0x040f700000001828ULL,
0x0000004c4838723cULL, 0x040f700000001838ULL, 0x0000004e481c723cULL, 0x000f70000000181cULL,
0x000000102420723cULL, 0x060b700000001820ULL, 0x000000122414723cULL, 0x040b700000001814ULL,
0x000000302418723cULL, 0x040b700000001818ULL, 0x000000322434723cULL, 0x040b700000001834ULL,
0x0000003c242c723cULL, 0x040b70000000182cULL, 0x0000003e2428723cULL, 0x040b700000001828ULL,
0x000000402438723cULL, 0x040b700000001838ULL, 0x000000422424723cULL, 0x000b62000000181cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000000103127810ULL, 0x020fe20007ffe0ffULL,
0x01b688005aff7f8cULL, 0x0003e2000c80043fULL, 0x000000800a117811ULL, 0x000fe200078e28ffULL,
0x00000100ff0b7424ULL, 0x000fe200078e00ffULL, 0x000000591200720cULL, 0x000fe20003f06070ULL,
0x000000400f0a7824ULL, 0x000fe200078e00ffULL, 0x0000002011107812ULL, 0x000fc600078ec0ffULL,
0x000064000a0a7625ULL, 0x000fc800078e000bULL, 0x00000001650f7824ULL, 0x000fe200078e0210ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff417819ULL, 0x002fe20000011606ULL, 0x0000200002127824ULL, 0x000fe200078e00ffULL,
0x0000001168107217ULL, 0x000fe20007800000ULL, 0x0000008002307824ULL, 0x000fe200078e00ffULL,
0x00000008411f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000141137824ULL, 0x000fe200078e020fULL,
0x0000200012127812ULL, 0x000fe200078ec0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a11ULL,
0x0000008069307812ULL, 0x000fe200078ef830ULL, 0x000000011f3e7824ULL, 0x000fe200078e0206ULL,
0x00000004411d7810ULL, 0x000fe20007ffe0ffULL, 0x000000081f117824ULL, 0x000fe200078e00ffULL,
0x0000000c41457810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0x0000002010427817ULL, 0x000fe20003800000ULL, 0x0000400009447824ULL, 0x000fe200078e0212ULL,
0xfffffff8113e7812ULL, 0x000fe200078ee23eULL, 0x0000010013127825ULL, 0x000fe200078e0030ULL,
0x000000061d437210ULL, 0x000fc40007ffe0ffULL, 0x0000001041477810ULL, 0x000fe20007ffe0ffULL,
0x000000011d117824ULL, 0x040fe200078e020fULL, 0x000000421d00720cULL, 0x040fe20003f86070ULL,
0x000000081d1c7824ULL, 0x000fe200078e00ffULL, 0x00000003451d7819ULL, 0x040fe200000006ffULL,
0x0000000145407824ULL, 0x000fe200078e0206ULL, 0x000000120a327210ULL, 0x000fe20007f1e0ffULL,
0x0000010011107825ULL, 0x000fe200078e0030ULL, 0xfffffff81c437812ULL, 0x000fe400078ee243ULL,
0x0000001441497810ULL, 0x000fe20007ffe0ffULL, 0x00000001473f7824ULL, 0x000fe200078e0206ULL,
0xfffffff81d407812ULL, 0x000fe200078ee240ULL, 0x00000008471c7824ULL, 0x000fe200078e00ffULL,
0x000000100a3c7210ULL, 0x000fe20007f3e0ffULL, 0x000000010b337824ULL, 0x000fe200000e0613ULL,
0x000000424500720cULL, 0x080fe20003f46070ULL, 0x000000011f1d7824ULL, 0x000fe200078e020fULL,
0xfffffff81c3f7812ULL, 0x000fe200078ee23fULL, 0x0000000145137824ULL, 0x000fe200078e020fULL,
0x000000421f00720cULL, 0x080fe20003f66070ULL, 0x0000000149097824ULL, 0x000fe200078e0206ULL,
0x000000424100720cULL, 0x000fe20003fa6070ULL, 0x00000008491e7824ULL, 0x000fe200078e00ffULL,
0x0001300044447810ULL, 0x000fe20007ffe0ffULL, 0x000001001d1c7825ULL, 0x000fc600078e0030ULL,
0xfffffff81e097812ULL, 0x000fe200078ee209ULL, 0x000000010b3d7824ULL, 0x000fe200008e0611ULL,
0x0000000f47117210ULL, 0x000fe20007ffe0ffULL, 0x0000000141107824ULL, 0x000fe200078e0206ULL,
0x0000001c0a1e7210ULL, 0x000fe20007f1e0ffULL, 0x0000010013127825ULL, 0x100fe200078e0030ULL,
0x000000424700720cULL, 0x000fe40003f26070ULL, 0x0000000710457812ULL, 0x000fe200078ec0ffULL,
0x0000010011107825ULL, 0x000fe200078e0030ULL, 0x000000120a1c7210ULL, 0x000fc40007fde0ffULL,
0x0ffffff845457812ULL, 0x000fe200078ef806ULL, 0x000000010b1f7824ULL, 0x000fe200000e061dULL,
0x000000424900720cULL, 0x000fe20003f06070ULL, 0x000000010b1d7824ULL, 0x000fe200030e0613ULL,
0x000000100a127210ULL, 0x040fe20007fde0ffULL, 0x0000000149477824ULL, 0x000fe200078e020fULL,
0x0000001c41497810ULL, 0x000fe20007ffe0ffULL, 0x0000001045457824ULL, 0x000fe400078e0244ULL,
0x000000010b137824ULL, 0x000fe400030e0611ULL, 0x0000010047107825ULL, 0x000fe200078e0030ULL,
0x0000001841477810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032457faeULL, 0x0003e4000e901c46ULL, 0x0000001043437824ULL, 0x000fe200078e0244ULL,
0x000000100a107210ULL, 0x000fe20007fde0ffULL, 0x0000000147417824ULL, 0x140fe200078e020fULL,
0x000000424700720cULL, 0x080fe20003fa6070ULL, 0x00000001490f7824ULL, 0x040fe200078e020fULL,
0x000000003c437faeULL, 0x0005e2000e101c46ULL, 0x000000424900720cULL, 0x000fe20003f86070ULL,
0x000000010b117824ULL, 0x000fc400030e0611ULL, 0x0000000847427824ULL, 0x000fe400078e00ffULL,
0x0000010041327825ULL, 0x002fe200078e0030ULL, 0x0000000647417210ULL, 0x000fc60007ffe0ffULL,
0x000001000f307825ULL, 0x000fe200078e0030ULL, 0x000000320a327210ULL, 0x000fe40007fde0ffULL,
0xfffffff842417812ULL, 0x000fe200078ee241ULL, 0x00000001493c7824ULL, 0x044fe400078e0206ULL,
0x0000000849437824ULL, 0x000fe400078e00ffULL, 0x000000010b337824ULL, 0x000fe200030e0633ULL,
0x000000300a0a7210ULL, 0x000fe20007fde0ffULL, 0x000000103e0f7824ULL, 0x000fe200078e0244ULL,
0xfffffff843437812ULL, 0x000fe200078ee23cULL, 0x00000010403d7824ULL, 0x000fc400078e0244ULL,
0x000000103f3f7824ULL, 0x100fe200078e0244ULL, 0x0000004443437211ULL, 0x000fe200078e20ffULL,
0x0000001009097824ULL, 0x100fe200078e0244ULL, 0x000000001e0f7faeULL, 0x0003e2000d901c46ULL,
0x0000001041417824ULL, 0x000fe400078e0244ULL, 0x000000010b0b7824ULL, 0x000fe200030e0631ULL,
0x000000001c3d7faeULL, 0x0003e8000d101c46ULL, 0x00000000123f7faeULL, 0x0003e8000c901c46ULL,
0x0000000010097faeULL, 0x0003e8000c101c46ULL, 0x0000000032417faeULL, 0x0003e8000e901c46ULL,
0x000000000a437faeULL, 0x0003e2000e101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000200002107824ULL, 0x002fe200078e00ffULL, 0x0000000c06117811ULL, 0x000fe200078fe8ffULL,
0x0000008002307824ULL, 0x000fe200078e00ffULL, 0x00000008063f7811ULL, 0x000fc400078fe8ffULL,
0x0000200010107812ULL, 0x000fe200078ec0ffULL, 0x0000000111427824ULL, 0x040fe200078e0206ULL,
0x0000001006137811ULL, 0x040fe200078fe8ffULL, 0x00000008111d7824ULL, 0x000fe200078e00ffULL,
0x00000004063d7811ULL, 0x040fe200078fe8ffULL, 0x0000400009127824ULL, 0x000fe200078e0210ULL,
0x0000000613417210ULL, 0x080fe20007ffe0ffULL, 0x000000013f437824ULL, 0x000fe200078e0206ULL,
0xfffffff81d427812ULL, 0x000fe200078ee242ULL, 0x000000083f107824ULL, 0x000fe200078e00ffULL,
0x00000014061d7811ULL, 0x040fe200078fe8ffULL, 0x000000013d447824ULL, 0x140fe200078e0206ULL,
0x00000018061f7811ULL, 0x000fe200078fe8ffULL, 0x000000083d097824ULL, 0x000fe200078e00ffULL,
0xfffffff810437812ULL, 0x000fe200078ee243ULL, 0x0000000813107824ULL, 0x000fe200078e00ffULL,
0x0000001c06457811ULL, 0x000fe200078fe8ffULL, 0x000000011d407824ULL, 0x000fe200078e0206ULL,
0xfffffff809447812ULL, 0x000fe200078ee244ULL, 0x000000081d317824ULL, 0x000fe200078e00ffULL,
0xfffffff810417812ULL, 0x000fe200078ee241ULL, 0x000000011f097824ULL, 0x040fe200078e0206ULL,
0x0000000606107211ULL, 0x000fe200078fe8ffULL, 0x000000081f1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff831407812ULL, 0x000fe200078ee240ULL, 0x00000008454b7824ULL, 0x040fe200078e00ffULL,
0x0000000710317812ULL, 0x000fe200078ec0ffULL, 0x0000000145107824ULL, 0x000fe200078e0206ULL,
0x0000000f13137210ULL, 0x080fe20007ffe0ffULL, 0x000000013d3d7824ULL, 0x100fe200078e020fULL,
0x0000000f06337211ULL, 0x000fe200078fe8ffULL, 0x000000013f3f7824ULL, 0x100fe200078e020fULL,
0x0000008069307812ULL, 0x000fe200078ef830ULL, 0x0000000111117824ULL, 0x100fe200078e020fULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee210ULL, 0x000000011d1d7824ULL, 0x100fe200078e020fULL,
0x0001300012467810ULL, 0x000fe20007ffe0ffULL, 0x000000011f1f7824ULL, 0x000fe200078e020fULL,
0xfffffff81c097812ULL, 0x000fe200078ee209ULL, 0x0000000145457824ULL, 0x000fe200078e020fULL,
0x0ffffff8310f7812ULL, 0x000fe200078ef806ULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0x0000004642477211ULL, 0x000fe200078e20ffULL, 0x0000001043437824ULL, 0x000fc400078e0246ULL,
0x0000010033327825ULL, 0x000fc800078e0030ULL, 0x000001003d3c7825ULL, 0x000fe200078e0030ULL,
0x000000320a327210ULL, 0x000fc60007f1e0ffULL, 0x000001003f3e7825ULL, 0x000fe200078e0030ULL,
0x0000003c0a3c7210ULL, 0x000fc60007f3e0ffULL, 0x0000010011107825ULL, 0x000fe200078e0030ULL,
0x0000003e0a3e7210ULL, 0x000fc60007f5e0ffULL, 0x0000010013127825ULL, 0x000fe200078e0030ULL,
0x000000100a107210ULL, 0x000fc60007f7e0ffULL, 0x000001001d1c7825ULL, 0x000fc800078e0030ULL,
0x000001001f1e7825ULL, 0x000fc800078e0030ULL, 0x0000010045307825ULL, 0x000fc800078e0030ULL,
0x000000010b337824ULL, 0x000fe200000e0633ULL, 0x000000120a127210ULL, 0x040fe20007f1e0ffULL,
0x000000100f0f7824ULL, 0x100fe400078e0246ULL, 0x000000010b3d7824ULL, 0x040fe200008e063dULL,
0x0000001c0a1c7210ULL, 0x040fe20007f3e0ffULL, 0x000000010b3f7824ULL, 0x040fe200010e063fULL,
0x0000001e0a1e7210ULL, 0x000fe20007f5e0ffULL, 0x0000001044457824ULL, 0x100fe200078e0246ULL,
0x0000001d0b1d7210ULL, 0x040fe20000ffe4ffULL, 0x000000010b117824ULL, 0x000fe200018e0611ULL,
0x000000300a0a7210ULL, 0x000fe20007f7e0ffULL, 0x0000001041417824ULL, 0x000fe200078e0246ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000320f7faeULL, 0x0003e2000b901c46ULL,
0x000000010b137824ULL, 0x000fc400000e0613ULL, 0x0000001040497824ULL, 0x100fe200078e0246ULL,
0x000000003c457faeULL, 0x0003e2000b901c46ULL, 0x0000001009097824ULL, 0x100fe400078e0246ULL,
0x000000010b1f7824ULL, 0x000fe200010e061fULL, 0x000000003e437faeULL, 0x0003e2000b901c46ULL,
0x000000104b4b7824ULL, 0x000fe400078e0246ULL, 0x000000010b0b7824ULL, 0x000fe200018e0631ULL,
0x0000000010477faeULL, 0x0003e8000b901c46ULL, 0x0000000012417faeULL, 0x0003e8000b901c46ULL,
0x000000001c497faeULL, 0x0003e8000b901c46ULL, 0x000000001e097faeULL, 0x0003e8000b901c46ULL,
0x000000000a4b7faeULL, 0x0003e4000b901c46ULL, 0x0000000308097812ULL, 0x002fe200078ec0ffULL,
0xffffffffff4d7424ULL, 0x000fc600078e00ffULL, 0x000000030900780cULL, 0x000fc80003f05270ULL,
0x0000000170097807ULL, 0x000fca0004000000ULL, 0x0000000108087824ULL, 0x000fca00078e0209ULL,
0x0000006a0800720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00000001660a7824ULL, 0x000fe400078e0208ULL, 0x00000004ff0b7424ULL, 0x000fc800078e00ffULL,
0x000066000a0a7625ULL, 0x000fca00078e000bULL, 0x000000060a4d7981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b628000d0a7f8cULL, 0x0022a4000c80043fULL, 0x0000000000107805ULL, 0x000fc40000015200ULL,
0xffffffe06b097812ULL, 0x040fe400078ec0ffULL, 0x000000106b127812ULL, 0x040fe400078ec0ffULL,
0x000000086b0d7812ULL, 0x002fc800078ec0ffULL, 0x000000090d097210ULL, 0x000fca0007ffe012ULL,
0x01b62c00090d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x006fe4000780480bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011413ULL,
0x000000120d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x000000020d0d7819ULL, 0x000fc80000001212ULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b62c00090d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000005020a7819ULL, 0x000fc800000006ffULL, 0xffffff800a0a7812ULL, 0x000fc800078ec0ffULL,
0x00000080690a7810ULL, 0x000fca0007ffe00aULL, 0x000000016f0a7824ULL, 0x000fca00078e020aULL,
0x01b000000a1c7984ULL, 0x000e680000000800ULL, 0x01b200000a4c7984ULL, 0x0004e20000000800ULL,
0x000000071c00720bULL, 0x002fe20003f1d000ULL, 0x000104e27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0b0f7812ULL, 0x000fe2000782c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff0a7224ULL, 0x000fd400078e0007ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x000000016c0b7810ULL, 0x000fe40007ffe0ffULL, 0x000000071c00720bULL, 0x000fe40003f34000ULL,
0x000000020b00720cULL, 0x000fe20003f05270ULL, 0x000104927f007947ULL, 0x000fd4000b800000ULL,
0x00000000000a7806ULL, 0x000fc400008e0100ULL, 0x0000008002108824ULL, 0x000fe200078e0269ULL,
0x000000071c0b8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x000099100a0d7816ULL, 0x000fe200000000ffULL, 0x000000016f108824ULL, 0x000fca00078e0210ULL,
0x01b4000b10008388ULL, 0x0003e20000000800ULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000071c107209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0aff7812ULL, 0x000fc6000780c0ffULL,
0x00000007100b7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL,
0x0000000b000d7308ULL, 0x000e640000000800ULL, 0x0000000d0e0e7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0b7819ULL, 0x000fe20000011606ULL,
0x000103c27f007947ULL, 0x000fea000b800000ULL, 0x00001f0b0d0b7589ULL, 0x0002a400000e0000ULL,
0x0000000b2c2c7220ULL, 0x084fe40000410000ULL, 0x0000000b2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000b28287220ULL, 0x080fe40000410000ULL, 0x0000000b29297220ULL, 0x000fc40000410000ULL,
0x0000000b20207220ULL, 0x080fe40000410000ULL, 0x0000000b21217220ULL, 0x080fe40000410000ULL,
0x0000000b14147220ULL, 0x080fe40000410000ULL, 0x0000000b15157220ULL, 0x080fe40000410000ULL,
0x0000000b18187220ULL, 0x080fe40000410000ULL, 0x0000000b19197220ULL, 0x000fc40000410000ULL,
0x0000000b34347220ULL, 0x080fe40000410000ULL, 0x0000000b35357220ULL, 0x080fe40000410000ULL,
0x0000000b38387220ULL, 0x080fe40000410000ULL, 0x0000000b39397220ULL, 0x080fe40000410000ULL,
0x0000000b24247220ULL, 0x080fe40000410000ULL, 0x0000000b25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000aff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008060b7811ULL, 0x000fe200078ff0ffULL,
0x000102c27f007947ULL, 0x000fea000b800000ULL, 0x00001f0b0d0b7589ULL, 0x00046400000e0000ULL,
0x0000000b2e2e7220ULL, 0x086fe40000410000ULL, 0x0000000b2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000b2a2a7220ULL, 0x080fe40000410000ULL, 0x0000000b2b2b7220ULL, 0x080fe40000410000ULL,
0x0000000b22227220ULL, 0x080fe40000410000ULL, 0x0000000b23237220ULL, 0x000fc40000410000ULL,
0x0000000b16167220ULL, 0x080fe40000410000ULL, 0x0000000b17177220ULL, 0x080fe40000410000ULL,
0x0000000b1a1a7220ULL, 0x080fe40000410000ULL, 0x0000000b1b1b7220ULL, 0x080fe40000410000ULL,
0x0000000b36367220ULL, 0x080fe40000410000ULL, 0x0000000b37377220ULL, 0x000fc40000410000ULL,
0x0000000b3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000b3b3b7220ULL, 0x080fe40000410000ULL,
0x0000000b26267220ULL, 0x080fe40000410000ULL, 0x0000000b27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff0fff7812ULL, 0x000fe4000780600aULL,
0x000000071c0a7209ULL, 0x000fd60007810000ULL, 0x8000000a1c1c0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b1c1c0820ULL, 0x000fc80000410000ULL, 0x0000001c00050308ULL, 0x000e640000000800ULL,
0x000000054c4c0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x0000000e4c4c7221ULL, 0x008fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000005ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011606ULL,
0x0000541000077816ULL, 0x000fe20000000000ULL, 0x000101127f007947ULL, 0x000fea000b800000ULL,
0x00001f0e07047589ULL, 0x0002a400000e0000ULL, 0x000000080e0b7810ULL, 0x000fe20007ffe0ffULL,
0x000101627f007947ULL, 0x000fea000b800000ULL, 0x00001f0b07007589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100e0b7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200078e0007ULL, 0x0000511000117802ULL, 0x000fe20000000f00ULL,
0x0000001fff137424ULL, 0x000fc400078e00ffULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x00010bb000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180e0b7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200078e0007ULL,
0x0000518000117802ULL, 0x000fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fe400078e00ffULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x00010b4000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000020002077824ULL, 0x00afe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe80003800000ULL, 0xfffff80007077812ULL, 0x000fc800078ec0ffULL,
0x00000007644e7210ULL, 0x000fc80007ffe0ffULL, 0x000140000c0b7810ULL, 0x004fe20007ffe0ffULL,
0x011800004e40783bULL, 0x000e620000000200ULL, 0x0001180007077810ULL, 0x000fe20007ffe058ULL,
0x000059004d4d7a24ULL, 0x010fe400078e02ffULL, 0x000000105d547824ULL, 0x100fe400078e020bULL,
0x000000105c507824ULL, 0x100fe200078e020bULL, 0x000000000710783bULL, 0x0004e20000000200ULL,
0x000000105b487824ULL, 0x100fe400078e020bULL, 0x000000105e447824ULL, 0x100fe200078e020bULL,
0x000000005454783bULL, 0x000ee20000004200ULL, 0x00000010610c7824ULL, 0x000fc400078e020bULL,
0x00000010603c7824ULL, 0x100fe200078e020bULL, 0x000000005050783bULL, 0x000ee20000004200ULL,
0x000000105f1c7824ULL, 0x100fe200078e020bULL, 0x00000001ff077819ULL, 0x004fe20000011602ULL,
0x0000001062307824ULL, 0x000fe200078e020bULL, 0x000000004848783bULL, 0x000ea80000004200ULL,
0x000000004444783bULL, 0x000ea80000004200ULL, 0x000000000c0c783bULL, 0x000ea80000004200ULL,
0x000000003c3c783bULL, 0x000ea80000004200ULL, 0x000000001c1c783bULL, 0x000ea80000004200ULL,
0x000000003030783bULL, 0x000ea20000004200ULL, 0x0000000440400232ULL, 0x002fc40000000000ULL,
0x0000000442420232ULL, 0x000fe40000000000ULL, 0x0000000041410232ULL, 0x080fe40000000000ULL,
0x0000000043430232ULL, 0x000fe40000000000ULL, 0x0000000410100232ULL, 0x088fe40000000000ULL,
0x0000000412120232ULL, 0x000fe40000000000ULL, 0x0000000011110232ULL, 0x080fe20000000000ULL,
0x00000054402c723cULL, 0x000f62000000182cULL, 0x0000000013130232ULL, 0x000fce0000000000ULL,
0x000000564028723cULL, 0x040f700000001828ULL, 0x000000504020723cULL, 0x040f700000001820ULL,
0x000000484018723cULL, 0x044f700000001818ULL, 0x000000524014723cULL, 0x040f700000001814ULL,
0x0000004a4034723cULL, 0x040f700000001834ULL, 0x000000444038723cULL, 0x040f700000001838ULL,
0x000000464024723cULL, 0x000f700000001824ULL, 0x0000000c102c723cULL, 0x060f70000000182cULL,
0x0000000e1028723cULL, 0x040f700000001828ULL, 0x0000003c100c723cULL, 0x040f700000001820ULL,
0x0000001c1018723cULL, 0x040f700000001818ULL, 0x0000003e1014723cULL, 0x040f700000001814ULL,
0x0000001e101c723cULL, 0x040f700000001834ULL, 0x000000301020723cULL, 0x040f700000001838ULL,
0x000000321024723cULL, 0x000b6e0000001824ULL, 0x0000000803137824ULL, 0x020fe200078e0207ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fcc0000008000ULL, 0x0000000103307810ULL, 0x000fe20007ffe0ffULL,
0x01b690005aff7f8cULL, 0x0003e2000c80043fULL, 0x000000c013137811ULL, 0x000fe200078e28ffULL,
0x000000404d107824ULL, 0x000fe200078e00ffULL, 0x000000593000720cULL, 0x000fc40003f06070ULL,
0x0000010000117802ULL, 0x000fe40000000f00ULL, 0x0000002013127812ULL, 0x000fc600078ec0ffULL,
0x0000640010107625ULL, 0x000fc800078e0011ULL, 0x00000001650b7824ULL, 0x000fe200078e0212ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff407819ULL, 0x102fe20000011606ULL, 0x000000ffff377224ULL, 0x000fe200078e00ffULL,
0x0000001368127217ULL, 0x000fe40007800000ULL, 0x0000000440307810ULL, 0x040fe40007ffe0ffULL,
0x0000000c40447810ULL, 0x000fe20007ffe0ffULL, 0x0000000112127824ULL, 0x000fe200078e0a13ULL,
0x0000000702367819ULL, 0x000fe200000006ffULL, 0x0000000130427824ULL, 0x000fe200078e0206ULL,
0x0000000840327810ULL, 0x000fe20007ffe0ffULL, 0x0000000830137824ULL, 0x000fe200078e00ffULL,
0x0000008069367812ULL, 0x000fe200078ef836ULL, 0x00000001443c7824ULL, 0x000fe200078e0206ULL,
0x0000002012417817ULL, 0x000fe20003800000ULL, 0x0000000844317824ULL, 0x000fe200078e00ffULL,
0xfffffff813427812ULL, 0x000fe200078ee242ULL, 0x0000000130137824ULL, 0x140fe200078e020bULL,
0x000000413000720cULL, 0x000fe20003f86070ULL, 0x00000001323d7824ULL, 0x000fe200078e0206ULL,
0xfffffff8313c7812ULL, 0x000fe200078ee23cULL, 0x0000000140317824ULL, 0x040fe200078e020bULL,
0x0000001440487810ULL, 0x040fe20007ffe0ffULL, 0x0000010013127825ULL, 0x000fe200078e0036ULL,
0x0000001040467810ULL, 0x000fc40007ffe0ffULL, 0x000000413200720cULL, 0x0c0fe20003f66070ULL,
0x0000000832347824ULL, 0x000fe200078e00ffULL, 0x00000012103a7210ULL, 0x000fe20007f3e0ffULL,
0x0000010031307825ULL, 0x000fe200078e0036ULL, 0x000000414400720cULL, 0x080fe40003f46070ULL,
0xfffffff8343d7812ULL, 0x000fe200078ee23dULL, 0x00000001483e7824ULL, 0x100fe200078e0206ULL,
0x0000003010387210ULL, 0x000fe20007f1e0ffULL, 0x0000000848337824ULL, 0x000fe200078e00ffULL,
0x000000414000720cULL, 0x000fe20003fa6070ULL, 0x00000001463f7824ULL, 0x000fc400078e0206ULL,
0x0000000846347824ULL, 0x000fe200078e00ffULL, 0xfffffff8333e7812ULL, 0x000fe200078ee23eULL,
0x00000001113b7824ULL, 0x040fe200008e0613ULL, 0x0000000d02137819ULL, 0x000fe200000006ffULL,
0x0000000111397824ULL, 0x000fe200000e0631ULL, 0xfffffff8343f7812ULL, 0x000fe200078ee23fULL,
0x0000000132337824ULL, 0x100fe200078e020bULL, 0x0000200013347812ULL, 0x000fe200078ec0ffULL,
0x0000000144317824ULL, 0x000fe200078e020bULL, 0x000000414600720cULL, 0x000fe20003f26070ULL,
0x0000000140127824ULL, 0x000fc400078e0206ULL, 0x0000010033327825ULL, 0x000fc600078e0036ULL,
0x0000000712437812ULL, 0x000fe200078ec0ffULL, 0x0000010031307825ULL, 0x000fc600078e0036ULL,
0x0ffffff843447812ULL, 0x000fe200078ef806ULL, 0x0000000146137824ULL, 0x000fe400078e020bULL,
0x0000400007457824ULL, 0x000fe200078e0234ULL, 0x0000003210347210ULL, 0x040fe20007f1e0ffULL,
0x0000010013127825ULL, 0x000fe200078e0036ULL, 0x0000003010327210ULL, 0x000fe40007fde0ffULL,
0x0001400045437810ULL, 0x000fe20007ffe0ffULL, 0x0000000111357824ULL, 0x040fe200000e0633ULL,
0x000000414800720cULL, 0x000fe20003f06070ULL, 0x0000000111337824ULL, 0x000fe200030e0631ULL,
0x0000001210307210ULL, 0x000fe20007fde0ffULL, 0x0000000148457824ULL, 0x000fe200078e020bULL,
0x000000433d3d7211ULL, 0x000fe200078e20ffULL, 0x0000001042497824ULL, 0x100fe200078e0243ULL,
0x0000001840427810ULL, 0x000fe20007ffe0ffULL, 0x0000001044477824ULL, 0x000fe200078e0243ULL,
0x0000001311317210ULL, 0x000fe200037fe4ffULL, 0x0000010045127825ULL, 0x000fe200078e0036ULL,
0x0000001c40447810ULL, 0x000fc40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038477faeULL, 0x0003e2000e901c46ULL, 0x0000000142457824ULL, 0x100fe200078e020bULL,
0x0000001210127210ULL, 0x000fe20007fde0ffULL, 0x00000001440b7824ULL, 0x000fe200078e020bULL,
0x000000003a497faeULL, 0x0005e2000e101c46ULL, 0x000000414200720cULL, 0x0c0fe20003fa6070ULL,
0x0000000142407824ULL, 0x000fe200078e0206ULL, 0x000000414400720cULL, 0x000fe20003f86070ULL,
0x0000000111137824ULL, 0x000fe200030e0613ULL, 0x00000000343d7faeULL, 0x0007e2000d901c46ULL,
0x0000000842417824ULL, 0x000fc400078e00ffULL, 0x0000010045387825ULL, 0x002fc600078e0036ULL,
0xfffffff841407812ULL, 0x000fe200078ee240ULL, 0x00000001443a7824ULL, 0x004fe200078e0206ULL,
0x0000003810387210ULL, 0x000fe20007fde0ffULL, 0x00000008443b7824ULL, 0x000fe400078e00ffULL,
0x000001000b367825ULL, 0x000fc600078e0036ULL, 0xfffffff83b3a7812ULL, 0x000fe200078ee23aULL,
0x0000000111397824ULL, 0x000fe200030e0639ULL, 0x0000003610107210ULL, 0x000fe20007fde0ffULL,
0x000000103c0b7824ULL, 0x100fe400078e0243ULL, 0x000000103f3f7824ULL, 0x100fe400078e0243ULL,
0x000000103e3b7824ULL, 0x100fe200078e0243ULL, 0x00000000320b7faeULL, 0x0007e2000d101c46ULL,
0x0000001040417824ULL, 0x100fe400078e0243ULL, 0x000000103a437824ULL, 0x000fe200078e0243ULL,
0x00000000303f7faeULL, 0x0007e2000c901c46ULL, 0x0000000111117824ULL, 0x000fc600030e0637ULL,
0x00000000123b7faeULL, 0x0007e8000c101c46ULL, 0x0000000038417faeULL, 0x0007e8000e901c46ULL,
0x0000000010437faeULL, 0x0007e2000e101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x00000004063b7811ULL, 0x042fe400078fe8ffULL, 0x00000008063d7811ULL, 0x000fc400078fe8ffULL,
0x0000000c06307811ULL, 0x040fe200078fe8ffULL, 0x000000013b3f7824ULL, 0x100fe200078e0206ULL,
0x000000033d137819ULL, 0x000fe200000006ffULL, 0x000000083b127824ULL, 0x000fe200078e00ffULL,
0x0000001006317811ULL, 0x040fe200078fe8ffULL, 0x000000013d407824ULL, 0x100fe200078e0206ULL,
0x0000001806357811ULL, 0x000fe200078fe8ffULL, 0x0000000130417824ULL, 0x000fe200078e0206ULL,
0xfffffff8123f7812ULL, 0x000fe200078ee23fULL, 0x0000000830127824ULL, 0x000fe200078e00ffULL,
0xfffffff813407812ULL, 0x000fe200078ee240ULL, 0x0000000131427824ULL, 0x140fe200078e0206ULL,
0x0000001406337811ULL, 0x000fe200078fe8ffULL, 0x0000000831137824ULL, 0x000fe200078e00ffULL,
0xfffffff812417812ULL, 0x000fe200078ee241ULL, 0x00000001353e7824ULL, 0x040fe200078e0206ULL,
0x0000000606127211ULL, 0x000fe200078fe8ffULL, 0x0000000835377824ULL, 0x000fe200078e00ffULL,
0xfffffff813427812ULL, 0x000fe200078ee242ULL, 0x0000200002137824ULL, 0x000fe200078e00ffULL,
0x0000001c06457811ULL, 0x000fe200078fe8ffULL, 0x0000000133437824ULL, 0x000fe200078e0206ULL,
0xfffffff8373e7812ULL, 0x000fe200078ee23eULL, 0x0000000833327824ULL, 0x000fe200078e00ffULL,
0x0000000712377812ULL, 0x000fe200078ec0ffULL, 0x00000008454b7824ULL, 0x000fe200078e00ffULL,
0x0000000702367819ULL, 0x000fe200000006ffULL, 0x000000013b3b7824ULL, 0x100fe200078e020bULL,
0x0000200013127812ULL, 0x000fe200078ec0ffULL, 0x0000000130137824ULL, 0x100fe200078e020bULL,
0x0000000b06397211ULL, 0x000fe200078fe8ffULL, 0x0000000145307824ULL, 0x000fe200078e0206ULL,
0x0000008069367812ULL, 0x000fe200078ef836ULL, 0x000000013d3d7824ULL, 0x100fe200078e020bULL,
0x0000001207127211ULL, 0x000fe200078e70ffULL, 0x0000000131317824ULL, 0x100fe200078e020bULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee230ULL, 0x0000000133337824ULL, 0x100fe200078e020bULL,
0x0001400012447810ULL, 0x000fe20007ffe0ffULL, 0x0000000135357824ULL, 0x000fe200078e020bULL,
0xfffffff832437812ULL, 0x000fe200078ee243ULL, 0x0000000145457824ULL, 0x000fe200078e020bULL,
0x0ffffff8370b7812ULL, 0x000fe200078ef806ULL, 0x000000ffff377224ULL, 0x000fc400078e00ffULL,
0x000000103f3f7824ULL, 0x000fe400078e0244ULL, 0x0000010039387825ULL, 0x000fc800078e0036ULL,
0x000001003b3a7825ULL, 0x000fe200078e0036ULL, 0x0000003810387210ULL, 0x000fc60007f1e0ffULL,
0x000001003d3c7825ULL, 0x100fe200078e0036ULL, 0x0000003a103a7210ULL, 0x040fe40007f3e0ffULL,
0x0000003911397210ULL, 0x000fe200007fe4ffULL, 0x0000010013127825ULL, 0x000fe200078e0036ULL,
0x0000003c103c7210ULL, 0x000fc60007f5e0ffULL, 0x0000010031307825ULL, 0x000fe200078e0036ULL,
0x0000001210127210ULL, 0x000fc60007f7e0ffULL, 0x0000010033327825ULL, 0x000fe200078e0036ULL,
0x0000003010307210ULL, 0x000fc60007f1e0ffULL, 0x0000010035347825ULL, 0x000fc800078e0036ULL,
0x0000010045367825ULL, 0x000fc800078e0036ULL, 0x00000001113b7824ULL, 0x000fe200008e063bULL,
0x0000003210327210ULL, 0x040fe20007f3e0ffULL, 0x000000100b0b7824ULL, 0x100fe400078e0244ULL,
0x00000001113d7824ULL, 0x040fe200010e063dULL, 0x0000003410347210ULL, 0x040fe20007f5e0ffULL,
0x0000000111137824ULL, 0x000fe200018e0613ULL, 0x0000003610107210ULL, 0x000fe20007f7e0ffULL,
0x0000001040457824ULL, 0x100fe200078e0244ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000380b7faeULL, 0x0003e2000b901c46ULL, 0x0000001041417824ULL, 0x000fc400078e0244ULL,
0x0000001042477824ULL, 0x100fe200078e0244ULL, 0x000000003a3f7faeULL, 0x0003e2000b901c46ULL,
0x0000000111317824ULL, 0x000fe400000e0631ULL, 0x0000001043437824ULL, 0x100fe200078e0244ULL,
0x000000003c457faeULL, 0x0003e2000b901c46ULL, 0x0000000111337824ULL, 0x040fe400008e0633ULL,
0x000000103e497824ULL, 0x000fe200078e0244ULL, 0x0000000012417faeULL, 0x0003e2000b901c46ULL,
0x0000000111357824ULL, 0x000fc400010e0635ULL, 0x000000104b4b7824ULL, 0x000fe200078e0244ULL,
0x0000000030477faeULL, 0x0003e2000b901c46ULL, 0x0000000111117824ULL, 0x000fc600018e0637ULL,
0x0000000032437faeULL, 0x0003e8000b901c46ULL, 0x0000000034497faeULL, 0x0003e8000b901c46ULL,
0x00000000104b7faeULL, 0x0003e4000b901c46ULL, 0x00000003080b7812ULL, 0x00afe200078ec0ffULL,
0xffffffffff517424ULL, 0x000fc600078e00ffULL, 0x000000030b00780cULL, 0x000fc80003f05270ULL,
0x00000001700b7807ULL, 0x000fca0004000000ULL, 0x0000000108087824ULL, 0x000fca00078e020bULL,
0x0000006a0800720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000866107210ULL, 0x000fe20007ffe0ffULL, 0x00000004ff117424ULL, 0x000fc800078e00ffULL,
0x0000660010107625ULL, 0x000fca00078e0011ULL, 0x0000000610517981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6480009107f8cULL, 0x0022a4000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0xffffffe06b097812ULL, 0x042fe400078ec0ffULL, 0x000000106b307812ULL, 0x040fe400078ec0ffULL,
0x000000086b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000090b097210ULL, 0x000fca0007ffe030ULL,
0x01b64c00090b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x006fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000307805ULL, 0x000fcc0000015200ULL, 0x0000003012307210ULL, 0x000fca0007f1e1ffULL,
0x0000000131317824ULL, 0x000fe200000e0e13ULL, 0x003d09003000780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403000780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011431ULL,
0x000000300b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff307224ULL, 0x000fca00000e0631ULL,
0x000000020b0b7819ULL, 0x000fc80000001230ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000132327810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b64c00090b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020020b7824ULL, 0x000fca00078e00ffULL, 0xffffff800b107812ULL, 0x000fc800078ec0ffULL,
0x0000010069107810ULL, 0x000fca0007ffe010ULL, 0x000000016f107824ULL, 0x000fca00078e0210ULL,
0x01b0000010317984ULL, 0x000e680000000800ULL, 0x01b2000010507984ULL, 0x0004e20000000800ULL,
0x0000000a3100720bULL, 0x002fe20003f1d000ULL, 0x0000eca27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0b337812ULL, 0x000fe2000782c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x000000026c0b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000a3100720bULL, 0x000fe40003f34000ULL, 0x000000020b00720cULL, 0x000fe20003f05270ULL,
0x0000ec627f007947ULL, 0x000fd4000b800000ULL, 0x0000000000307806ULL, 0x000fc400008e0100ULL,
0x0000006902108211ULL, 0x000fe200078e38ffULL, 0x0000038000017945ULL, 0x000fe20003800000ULL,
0x0000000a310b8209ULL, 0x000fc60007810000ULL, 0x000000016f128824ULL, 0x000fe200078e0210ULL,
0x0000991030107816ULL, 0x000fc800000000ffULL, 0x01b4000b12008388ULL, 0x0003e20000000800ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000a310b7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff30ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000a0b0b7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL, 0x0000000b00357308ULL, 0x000e640000000800ULL,
0x000000354c4c7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0b7819ULL, 0x000fe20000011606ULL, 0x0000eb927f007947ULL, 0x000fea000b800000ULL,
0x00001f0b350b7589ULL, 0x0002a400000e0000ULL, 0x0000000b2c2c7220ULL, 0x084fe40000410000ULL,
0x0000000b2d2d7220ULL, 0x080fe40000410000ULL, 0x0000000b28287220ULL, 0x080fe40000410000ULL,
0x0000000b29297220ULL, 0x000fc40000410000ULL, 0x0000000b0c0c7220ULL, 0x080fe40000410000ULL,
0x0000000b0d0d7220ULL, 0x080fe40000410000ULL, 0x0000000b14147220ULL, 0x080fe40000410000ULL,
0x0000000b15157220ULL, 0x080fe40000410000ULL, 0x0000000b18187220ULL, 0x080fe40000410000ULL,
0x0000000b19197220ULL, 0x000fc40000410000ULL, 0x0000000b1c1c7220ULL, 0x080fe40000410000ULL,
0x0000000b1d1d7220ULL, 0x080fe40000410000ULL, 0x0000000b20207220ULL, 0x080fe40000410000ULL,
0x0000000b21217220ULL, 0x080fe40000410000ULL, 0x0000000b24247220ULL, 0x080fe40000410000ULL,
0x0000000b25257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0030ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008060b7811ULL, 0x000fe200078ff0ffULL, 0x0000ea927f007947ULL, 0x000fea000b800000ULL,
0x00001f0b350b7589ULL, 0x00046400000e0000ULL, 0x0000000b2e2e7220ULL, 0x086fe40000410000ULL,
0x0000000b2f2f7220ULL, 0x080fe40000410000ULL, 0x0000000b2a2a7220ULL, 0x080fe40000410000ULL,
0x0000000b2b2b7220ULL, 0x080fe40000410000ULL, 0x0000000b0e0e7220ULL, 0x080fe40000410000ULL,
0x0000000b0f0f7220ULL, 0x000fc40000410000ULL, 0x0000000b16167220ULL, 0x080fe40000410000ULL,
0x0000000b17177220ULL, 0x080fe40000410000ULL, 0x0000000b1a1a7220ULL, 0x080fe40000410000ULL,
0x0000000b1b1b7220ULL, 0x080fe40000410000ULL, 0x0000000b1e1e7220ULL, 0x080fe40000410000ULL,
0x0000000b1f1f7220ULL, 0x000fc40000410000ULL, 0x0000000b22227220ULL, 0x080fe40000410000ULL,
0x0000000b23237220ULL, 0x080fe40000410000ULL, 0x0000000b26267220ULL, 0x080fe40000410000ULL,
0x0000000b27277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff33ff7812ULL, 0x000fe40007806030ULL, 0x0000000a310a7209ULL, 0x000fd60007810000ULL,
0x8000000a31310221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL,
0x0000003100050308ULL, 0x000e640000000800ULL, 0x0000000550500220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000004c50507221ULL, 0x008fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000005ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff317819ULL, 0x000fe40000011606ULL, 0x0000541000307816ULL, 0x000fe20000000000ULL,
0x0000e8e27f007947ULL, 0x000fea000b800000ULL, 0x00001f3130047589ULL, 0x0002a400000e0000ULL,
0x00000008310b7810ULL, 0x000fe20007ffe0ffULL, 0x0000e9327f007947ULL, 0x000fea000b800000ULL,
0x00001f0b30007589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010310b7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200078e0030ULL,
0x00006ba000117802ULL, 0x000fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fc400078e00ffULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x0000f12000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000018310b7810ULL, 0x00cfe20007ffe0ffULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x0000003000107202ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x000fe200078e00ffULL, 0x00006c1000117802ULL, 0x000fc40000000f00ULL,
0x0000f0b000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x00000007060b7812ULL, 0x00cfe200078ec0ffULL,
0x0000000207527824ULL, 0x000fe200078e0267ULL, 0x0000000263637810ULL, 0x000fe20007ffe0ffULL,
0x012000004e44783bULL, 0x000ea20000000200ULL, 0x000000080b0b7812ULL, 0x000fe200078ef806ULL,
0x0000200052527824ULL, 0x000fc800078e00ffULL, 0x000000080b107824ULL, 0x000fe200078e00ffULL,
0x0001300052347810ULL, 0x000fe20007ffe0ffULL, 0x00000200020b7824ULL, 0x000fc600078e00ffULL,
0xfffffff810537812ULL, 0x000fe200078ee263ULL, 0x000000105b107824ULL, 0x100fe200078e0234ULL,
0x000000345e487211ULL, 0x000fe200078e20ffULL, 0x000000105d547824ULL, 0x100fe200078e0234ULL,
0xfffff8000b307812ULL, 0x002fe200078ec0ffULL, 0x000000105c4c7824ULL, 0x100fe400078e0234ULL,
0x000000001010783bULL, 0x000e620000004200ULL, 0x0000001053537824ULL, 0x000fe400078e00ffULL,
0x0000001061407824ULL, 0x100fe200078e0234ULL, 0x000000005454783bULL, 0x000ee20000004200ULL,
0x00000010603c7824ULL, 0x100fe200078e0234ULL, 0x0001200030307810ULL, 0x000fe20007ffe053ULL,
0x000000105f387824ULL, 0x100fe200078e0234ULL, 0x000000004c4c783bULL, 0x000fe20000004200ULL,
0x0000001062347824ULL, 0x000fc600078e0234ULL, 0x000000004848783bULL, 0x000fe80000004200ULL,
0x000000003030783bULL, 0x000ee80000000200ULL, 0x000000003838783bULL, 0x000ee20000004200ULL,
0x0000000444440232ULL, 0x004fc60000000000ULL, 0x000000004040783bULL, 0x000ea20000004200ULL,
0x0000000446460232ULL, 0x000fe40000000000ULL, 0x0000000045450232ULL, 0x080fe20000000000ULL,
0x000000003c3c783bULL, 0x000ea20000004200ULL, 0x0000000047470232ULL, 0x000fc60000000000ULL,
0x000000003434783bULL, 0x000ea80000004200ULL, 0x000000104418723cULL, 0x042f700000001818ULL,
0x00000054442c723cULL, 0x048f70000000182cULL, 0x000000564428723cULL, 0x000f620000001828ULL,
0x0000000430300232ULL, 0x000fc40000000000ULL, 0x0000000432320232ULL, 0x000fe40000000000ULL,
0x0000000031310232ULL, 0x080fe40000000000ULL, 0x0000000033330232ULL, 0x000fe20000000000ULL,
0x0000004c440c723cULL, 0x040f70000000180cULL, 0x0000004e4414723cULL, 0x040f700000001814ULL,
0x000000124410723cULL, 0x040f70000000181cULL, 0x000000484420723cULL, 0x040f700000001820ULL,
0x0000004a4424723cULL, 0x000f700000001824ULL, 0x000000383018723cULL, 0x060b700000001818ULL,
0x00000040302c723cULL, 0x044b70000000182cULL, 0x000000423028723cULL, 0x040b700000001828ULL,
0x0000003c300c723cULL, 0x040b70000000180cULL, 0x0000003e3014723cULL, 0x040b700000001814ULL,
0x0000003a3038723cULL, 0x040b700000001810ULL, 0x000000343020723cULL, 0x040b700000001820ULL,
0x000000363030723cULL, 0x000b620000001824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000030003127a10ULL, 0x020fe20007ffe0ffULL, 0x01b698005aff7f8cULL, 0x0003e6000c80043fULL,
0x000000591200720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00000d4000000947ULL, 0x000fea0003800000ULL, 0x0000000112107810ULL, 0x042fe20007ffe0ffULL,
0x0000010012137824ULL, 0x000fe400078e026dULL, 0x0000590051517a24ULL, 0x010fe200078e02ffULL,
0x000000591000720cULL, 0x000fe20003f06070ULL, 0x00000100ff127424ULL, 0x000fe200078e00ffULL,
0x0000002013107812ULL, 0x000fe200078ec0ffULL, 0x0000004051117824ULL, 0x000fc800078e00ffULL,
0x00000001650b7824ULL, 0x000fe400078e0210ULL, 0x0000640011107625ULL, 0x000fc800078e0012ULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff407819ULL, 0x100fe20000011606ULL,
0x0000008002267824ULL, 0x000fe200078e00ffULL, 0x0000001368127217ULL, 0x000fe40007800000ULL,
0x00000004401c7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c40447810ULL, 0x000fe40007ffe0ffULL,
0x0000001213127210ULL, 0x000fe20007ffe1ffULL, 0x000000011c427824ULL, 0x040fe200078e0206ULL,
0x0000008069267812ULL, 0x000fe200078ef826ULL, 0x000000081c137824ULL, 0x000fe200078e00ffULL,
0x000000ff00277202ULL, 0x000fe20000000f00ULL, 0x00000001443c7824ULL, 0x000fe200078e0206ULL,
0x0000002012417817ULL, 0x000fe20003800000ULL, 0x00000008441d7824ULL, 0x000fe200078e00ffULL,
0xfffffff813427812ULL, 0x000fe200078ee242ULL, 0x000000011c137824ULL, 0x000fe200078e020bULL,
0x00000008401e7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81d3c7812ULL, 0x000fe200078ee23cULL,
0x00000001401d7824ULL, 0x000fe200078e020bULL, 0x000000411c00720cULL, 0x080fe20003f86070ULL,
0x0000010013127825ULL, 0x100fe200078e0026ULL, 0x0000001440487810ULL, 0x040fe40007ffe0ffULL,
0x0000001040467810ULL, 0x000fe20007ffe0ffULL, 0x000001001d1c7825ULL, 0x000fe200078e0026ULL,
0x0000001210367210ULL, 0x000fe40007f3e0ffULL, 0x000000411e00720cULL, 0x0c0fe20003f66070ULL,
0x000000011e3d7824ULL, 0x100fe200078e0206ULL, 0x0000001c10347210ULL, 0x000fe20007f1e0ffULL,
0x000000081e247824ULL, 0x000fe200078e00ffULL, 0x000000414400720cULL, 0x080fe20003f46070ULL,
0x00000001483e7824ULL, 0x100fe200078e0206ULL, 0x000000414000720cULL, 0x000fe20003fa6070ULL,
0x00000008481f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8243d7812ULL, 0x000fe200078ee23dULL,
0x00000001463f7824ULL, 0x000fc400078e0206ULL, 0x0000000846247824ULL, 0x040fe200078e00ffULL,
0xfffffff81f3e7812ULL, 0x000fe200078ee23eULL, 0x0000000111377824ULL, 0x040fe200008e0613ULL,
0x000000414600720cULL, 0x000fe20003f26070ULL, 0x0000200002137824ULL, 0x000fe200078e00ffULL,
0xfffffff8243f7812ULL, 0x000fe200078ee23fULL, 0x0000000111357824ULL, 0x000fe200000e061dULL,
0x0000000b441d7210ULL, 0x000fe20007ffe0ffULL, 0x000000011e1f7824ULL, 0x000fe200078e020bULL,
0x0000200013247812ULL, 0x000fe200078ec0ffULL, 0x0000000140127824ULL, 0x000fc400078e0206ULL,
0x000001001f1e7825ULL, 0x000fc600078e0026ULL, 0x0000000712437812ULL, 0x000fe200078ec0ffULL,
0x000001001d1c7825ULL, 0x000fc600078e0026ULL, 0x0ffffff843447812ULL, 0x000fe200078ef806ULL,
0x0000000146137824ULL, 0x000fe400078e020bULL, 0x0000400007457824ULL, 0x000fe200078e0224ULL,
0x0000001e10247210ULL, 0x040fe20007f1e0ffULL, 0x0000010013127825ULL, 0x000fe200078e0026ULL,
0x0000001c101e7210ULL, 0x000fe40007fde0ffULL, 0x0001300045437810ULL, 0x000fe20007ffe0ffULL,
0x0000000111257824ULL, 0x040fe200000e061fULL, 0x000000414800720cULL, 0x000fe20003f06070ULL,
0x00000001111f7824ULL, 0x000fe200030e061dULL, 0x00000012101c7210ULL, 0x000fe20007fde0ffULL,
0x0000001042497824ULL, 0x000fe200078e0243ULL, 0x0000001840427810ULL, 0x000fe20007ffe0ffULL,
0x0000000148457824ULL, 0x000fc400078e020bULL, 0x0000001044477824ULL, 0x000fe200078e0243ULL,
0x0000001c40447810ULL, 0x000fe20007ffe0ffULL, 0x00000001111d7824ULL, 0x000fe400030e0613ULL,
0x0000010045127825ULL, 0x000fe200078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034477faeULL, 0x0003e2000e901c46ULL, 0x000000414200720cULL, 0x0c0fe40003fa6070ULL,
0x0000000142457824ULL, 0x100fe200078e020bULL, 0x0000001210127210ULL, 0x000fe20007fde0ffULL,
0x00000001440b7824ULL, 0x040fe200078e020bULL, 0x0000000036497faeULL, 0x0005e2000e101c46ULL,
0x000000414400720cULL, 0x000fe20003f86070ULL, 0x0000000142407824ULL, 0x040fe200078e0206ULL,
0x0000001311137210ULL, 0x000fe200037fe4ffULL, 0x0000000842417824ULL, 0x000fc400078e00ffULL,
0x0000010045347825ULL, 0x002fc600078e0026ULL, 0xfffffff841407812ULL, 0x000fe200078ee240ULL,
0x000001000b267825ULL, 0x000fe200078e0026ULL, 0x0000003410347210ULL, 0x000fc60007fde0ffULL,
0x0000000144367824ULL, 0x044fe400078e0206ULL, 0x0000000844377824ULL, 0x000fe400078e00ffULL,
0x0000000111357824ULL, 0x000fe200030e0635ULL, 0x0000002610107210ULL, 0x000fe20007fde0ffULL,
0x000000103d3d7824ULL, 0x100fe200078e0243ULL, 0xfffffff837367812ULL, 0x000fe200078ee236ULL,
0x000000103c0b7824ULL, 0x100fe200078e0243ULL, 0x000000433e377211ULL, 0x000fe200078e20ffULL,
0x000000103f3f7824ULL, 0x100fe200078e0243ULL, 0x00000000243d7faeULL, 0x0003e2000d901c46ULL,
0x0000001040417824ULL, 0x000fc400078e0243ULL, 0x0000001036437824ULL, 0x000fe200078e0243ULL,
0x000000001e0b7faeULL, 0x0003e2000d101c46ULL, 0x0000000111117824ULL, 0x000fc600030e0627ULL,
0x000000001c3f7faeULL, 0x0003e8000c901c46ULL, 0x0000000012377faeULL, 0x0003e8000c101c46ULL,
0x0000000034417faeULL, 0x0003e8000e901c46ULL, 0x0000000010437faeULL, 0x0003e2000e101c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000406377811ULL, 0x000fe200078fe8ffULL,
0x0000008002267824ULL, 0x000fe200078e00ffULL, 0x00000008063d7811ULL, 0x000fc400078fe8ffULL,
0x0000000c061c7811ULL, 0x040fe200078fe8ffULL, 0x00000001373f7824ULL, 0x140fe200078e0206ULL,
0x00000010061d7811ULL, 0x040fe200078fe8ffULL, 0x0000000837127824ULL, 0x000fe200078e00ffULL,
0x0000001806257811ULL, 0x000fe200078fe8ffULL, 0x000000013d407824ULL, 0x100fe200078e0206ULL,
0x000000061d427210ULL, 0x080fe20007ffe0ffULL, 0x000000083d137824ULL, 0x000fe200078e00ffULL,
0xfffffff8123f7812ULL, 0x000fe200078ee23fULL, 0x000000011c417824ULL, 0x000fe200078e0206ULL,
0x00000014061f7811ULL, 0x000fe200078fe8ffULL, 0x000000081c127824ULL, 0x000fe200078e00ffULL,
0xfffffff813407812ULL, 0x000fe200078ee240ULL, 0x000000081d137824ULL, 0x000fe200078e00ffULL,
0x0000001c06457811ULL, 0x000fe200078fe8ffULL, 0x00000001253e7824ULL, 0x040fe200078e0206ULL,
0xfffffff812417812ULL, 0x000fe200078ee241ULL, 0x0000000825277824ULL, 0x000fe200078e00ffULL,
0xfffffff813427812ULL, 0x000fe200078ee242ULL, 0x0000200002137824ULL, 0x000fe200078e00ffULL,
0x0000000606127211ULL, 0x000fe200078fe8ffULL, 0x000000011f437824ULL, 0x000fe200078e0206ULL,
0xfffffff8273e7812ULL, 0x000fe200078ee23eULL, 0x000000081f1e7824ULL, 0x000fe200078e00ffULL,
0x0000000712277812ULL, 0x000fe200078ec0ffULL, 0x00000008454b7824ULL, 0x000fe200078e00ffULL,
0x0000200013127812ULL, 0x000fe200078ec0ffULL, 0x0000000137377824ULL, 0x100fe200078e020bULL,
0x0000000b1c137210ULL, 0x080fe20007ffe0ffULL, 0x00000001451c7824ULL, 0x000fe200078e0206ULL,
0x0000000b06357211ULL, 0x000fe200078fe8ffULL, 0x000000013d3d7824ULL, 0x100fe200078e020bULL,
0x0000008069267812ULL, 0x000fe200078ef826ULL, 0x000000011d1d7824ULL, 0x100fe200078e020bULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee21cULL, 0x000000011f1f7824ULL, 0x000fe200078e020bULL,
0xfffffff81e437812ULL, 0x000fe200078ee243ULL, 0x0000000125257824ULL, 0x000fc400078e020bULL,
0x0000000145457824ULL, 0x000fe200078e020bULL, 0x0ffffff8270b7812ULL, 0x000fe200078ef806ULL,
0x000000ffff277224ULL, 0x000fe400078e00ffULL, 0x0000400007127824ULL, 0x000fe400078e0212ULL,
0x0000010035347825ULL, 0x000fc600078e0026ULL, 0x0001300012447810ULL, 0x000fe20007ffe0ffULL,
0x0000010037367825ULL, 0x100fe200078e0026ULL, 0x0000003410347210ULL, 0x040fe40007f1e0ffULL,
0x000000443f3f7211ULL, 0x000fe200078e20ffULL, 0x000001003d3c7825ULL, 0x000fe200078e0026ULL,
0x0000003610367210ULL, 0x000fc60007f3e0ffULL, 0x0000010013127825ULL, 0x000fe200078e0026ULL,
0x0000003c103c7210ULL, 0x000fc60007f5e0ffULL, 0x000001001d1c7825ULL, 0x000fe200078e0026ULL,
0x0000001210127210ULL, 0x000fc60007f7e0ffULL, 0x000001001f1e7825ULL, 0x000fe200078e0026ULL,
0x0000001311137210ULL, 0x000fc60001ffe4ffULL, 0x0000010025247825ULL, 0x000fc800078e0026ULL,
0x0000010045267825ULL, 0x000fc800078e0026ULL, 0x0000000111357824ULL, 0x040fe200000e0635ULL,
0x0000001c101c7210ULL, 0x040fe20007f1e0ffULL, 0x0000000111377824ULL, 0x000fe200008e0637ULL,
0x0000001e101e7210ULL, 0x040fe20007f3e0ffULL, 0x000000100b0b7824ULL, 0x100fe400078e0244ULL,
0x00000001113d7824ULL, 0x000fe200010e063dULL, 0x0000002410247210ULL, 0x000fe20007f5e0ffULL,
0x0000001040457824ULL, 0x100fe200078e0244ULL, 0x0000002610107210ULL, 0x000fe20007f7e0ffULL,
0x0000001041417824ULL, 0x100fe200078e0244ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000340b7faeULL, 0x0003e2000b901c46ULL, 0x0000001042477824ULL, 0x000fc400078e0244ULL,
0x00000001111d7824ULL, 0x000fe200000e061dULL, 0x00000000363f7faeULL, 0x0003e2000b901c46ULL,
0x0000001043437824ULL, 0x100fe400078e0244ULL, 0x00000001111f7824ULL, 0x040fe200008e061fULL,
0x000000003c457faeULL, 0x0003e2000b901c46ULL, 0x000000103e497824ULL, 0x100fe400078e0244ULL,
0x0000000111257824ULL, 0x000fe200010e0625ULL, 0x0000000012417faeULL, 0x0003e2000b901c46ULL,
0x000000104b4b7824ULL, 0x000fc400078e0244ULL, 0x0000000111117824ULL, 0x000fe200018e0627ULL,
0x000000001c477faeULL, 0x0003e8000b901c46ULL, 0x000000001e437faeULL, 0x0003e8000b901c46ULL,
0x0000000024497faeULL, 0x0003e8000b901c46ULL, 0x00000000104b7faeULL, 0x0003e4000b901c46ULL,
0x00000003080b7812ULL, 0x002fe200078ec0ffULL, 0xffffffffff517424ULL, 0x000fc600078e00ffULL,
0x000000030b00780cULL, 0x000fc80003f05270ULL, 0x00000001700b7807ULL, 0x000fca0004000000ULL,
0x0000000108087824ULL, 0x000fca00078e020bULL, 0x0000006a0800720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000166107824ULL, 0x000fe400078e0208ULL,
0x00000004ff117424ULL, 0x000fc800078e00ffULL, 0x0000660010107625ULL, 0x000fca00078e0011ULL,
0x0000000610517981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6680009107f8cULL, 0x0002a4000c80043fULL,
0x0000000000127805ULL, 0x000fc40000015200ULL, 0xffffffe06b097812ULL, 0x042fe400078ec0ffULL,
0x000000106b1c7812ULL, 0x040fe400078ec0ffULL, 0x000000086b0b7812ULL, 0x000fc800078ec0ffULL,
0x000000090b0b7210ULL, 0x000fca0007ffe01cULL, 0x01b66c000b097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x006fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c121c7210ULL, 0x000fc80007f1e1ffULL, 0x0000001d131d7210ULL, 0x000fe400007fe5ffULL,
0x003d09001c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc8000001141dULL, 0x0000001c09097211ULL, 0x000fca00078110ffULL,
0x000000ffff1c7224ULL, 0x000fca00000e061dULL, 0x0000000209097819ULL, 0x000fc8000000121cULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b66c000b097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002002097824ULL, 0x000fca00078e00ffULL,
0xffffff8009107812ULL, 0x000fc800078ec0ffULL, 0x0000018069107810ULL, 0x000fca0007ffe010ULL,
0x000000016f107824ULL, 0x000fca00078e0210ULL, 0x01b0000010097984ULL, 0x000e680000000800ULL,
0x01b20000101c7984ULL, 0x0004e20000000800ULL, 0x0000000a0900720bULL, 0x002fe20003f1d000ULL,
0x0000d3f27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000b7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0b1e7812ULL, 0x000fe2000782c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x000000036c0b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000a0900720bULL, 0x000fe40003f34000ULL,
0x000000020b00720cULL, 0x000fe20003f05270ULL, 0x0000d3b27f007947ULL, 0x000fd4000b800000ULL,
0x00000000001d7806ULL, 0x000fc400008e0100ULL, 0x0000008002108824ULL, 0x000fe200078e0269ULL,
0x0000000a090b8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x000000016f128824ULL, 0x000fe200078e0210ULL, 0x000099101d107816ULL, 0x000fc800000000ffULL,
0x01b4000b12008388ULL, 0x0003e20000000800ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000a090b7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff1dff7812ULL, 0x000fc6000780c0ffULL,
0x0000000a0b0b7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL,
0x0000000b001f7308ULL, 0x000e640000000800ULL, 0x0000001f50507220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0b7819ULL, 0x000fe20000011606ULL,
0x0000d2e27f007947ULL, 0x000fea000b800000ULL, 0x00001f0b1f0b7589ULL, 0x0002a400000e0000ULL,
0x0000000b2c2c7220ULL, 0x084fe40000410000ULL, 0x0000000b2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000b28287220ULL, 0x080fe40000410000ULL, 0x0000000b29297220ULL, 0x000fc40000410000ULL,
0x0000000b0c0c7220ULL, 0x080fe40000410000ULL, 0x0000000b0d0d7220ULL, 0x080fe40000410000ULL,
0x0000000b14147220ULL, 0x080fe40000410000ULL, 0x0000000b15157220ULL, 0x080fe40000410000ULL,
0x0000000b18187220ULL, 0x080fe40000410000ULL, 0x0000000b19197220ULL, 0x000fc40000410000ULL,
0x0000000b38387220ULL, 0x080fe40000410000ULL, 0x0000000b39397220ULL, 0x080fe40000410000ULL,
0x0000000b20207220ULL, 0x080fe40000410000ULL, 0x0000000b21217220ULL, 0x080fe40000410000ULL,
0x0000000b30307220ULL, 0x080fe40000410000ULL, 0x0000000b31317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008060b7811ULL, 0x000fe200078ff0ffULL,
0x0000d1e27f007947ULL, 0x000fea000b800000ULL, 0x00001f0b1f0b7589ULL, 0x00046400000e0000ULL,
0x0000000b2e2e7220ULL, 0x086fe40000410000ULL, 0x0000000b2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000b2a2a7220ULL, 0x080fe40000410000ULL, 0x0000000b2b2b7220ULL, 0x080fe40000410000ULL,
0x0000000b0e0e7220ULL, 0x080fe40000410000ULL, 0x0000000b0f0f7220ULL, 0x000fc40000410000ULL,
0x0000000b16167220ULL, 0x080fe40000410000ULL, 0x0000000b17177220ULL, 0x080fe40000410000ULL,
0x0000000b1a1a7220ULL, 0x080fe40000410000ULL, 0x0000000b1b1b7220ULL, 0x080fe40000410000ULL,
0x0000000b3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000b3b3b7220ULL, 0x000fc40000410000ULL,
0x0000000b22227220ULL, 0x080fe40000410000ULL, 0x0000000b23237220ULL, 0x080fe40000410000ULL,
0x0000000b32327220ULL, 0x080fe40000410000ULL, 0x0000000b33337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff1eff7812ULL, 0x000fe4000780601dULL,
0x0000000a090a7209ULL, 0x000fd60007810000ULL, 0x8000000a09090221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b09090820ULL, 0x000fc80000410000ULL, 0x0000000900050308ULL, 0x000e640000000800ULL,
0x000000051c1c0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x000000501c097221ULL, 0x008fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000005ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff1d7819ULL, 0x000fe40000011606ULL,
0x00005410001c7816ULL, 0x000fe20000000000ULL, 0x0000d0327f007947ULL, 0x000fea000b800000ULL,
0x00001f1d1c047589ULL, 0x0002a400000e0000ULL, 0x000000081d0b7810ULL, 0x000fe20007ffe0ffULL,
0x0000d0827f007947ULL, 0x000fea000b800000ULL, 0x00001f0b1c007589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000101d0b7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200078e001cULL, 0x000086b000117802ULL, 0x000fe20000000f00ULL,
0x0000001fff137424ULL, 0x000fc400078e00ffULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x0000d61000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000181d0b7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200078e001cULL,
0x0000872000117802ULL, 0x000fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fe400078e00ffULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x0000d5a000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000646c447211ULL, 0x000fca00078e58ffULL, 0x0001400052527810ULL, 0x000fe20007ffe0ffULL,
0x012800004444783bULL, 0x000ee40000000200ULL, 0x000000036c1c7810ULL, 0x00afe40007ffe0ffULL,
0x0000030003037a10ULL, 0x000fe20007ffe0ffULL, 0x000000105b107824ULL, 0x000fc400078e0252ULL,
0x000000105d547824ULL, 0x100fe400078e0252ULL, 0x000000105c4c7824ULL, 0x100fe400078e0252ULL,
0x000000105e487824ULL, 0x100fe200078e0252ULL, 0x000000001010783bULL, 0x000e620000004200ULL,
0x000008001c1c7824ULL, 0x000fe400078e0253ULL, 0x000000105f347824ULL, 0x100fe200078e0252ULL,
0x000000005454783bULL, 0x000fe20000004200ULL, 0x0000001061407824ULL, 0x000fc400078e0252ULL,
0x00000010603c7824ULL, 0x100fe200078e0252ULL, 0x000000004c4c783bULL, 0x000fe20000004200ULL,
0x0000001062247824ULL, 0x000fc600078e0252ULL, 0x000000004848783bULL, 0x000fe80000004200ULL,
0x011000001c1c783bULL, 0x000ee80000000200ULL, 0x000000003434783bULL, 0x000ea80000004200ULL,
0x000000004040783bULL, 0x000ea80000004200ULL, 0x000000003c3c783bULL, 0x000ea40000004200ULL,
0x0000000444440232ULL, 0x004fc40000000000ULL, 0x0000000446460232ULL, 0x000fe20000000000ULL,
0x000000002424783bULL, 0x000ea20000004200ULL, 0x0000000045450232ULL, 0x080fe40000000000ULL,
0x0000000047470232ULL, 0x000fce0000000000ULL, 0x000000104418723cULL, 0x042f700000001818ULL,
0x000000124410723cULL, 0x000fe20000001838ULL, 0x000000041c1c0232ULL, 0x008fce0000000000ULL,
0x00000054442c723cULL, 0x000f62000000182cULL, 0x000000041e1e0232ULL, 0x000fe40000000000ULL,
0x000000001d1d0232ULL, 0x080fe40000000000ULL, 0x000000001f1f0232ULL, 0x000fc60000000000ULL,
0x000000564428723cULL, 0x040f700000001828ULL, 0x0000004c440c723cULL, 0x040f70000000180cULL,
0x0000004e4414723cULL, 0x040f700000001814ULL, 0x000000484438723cULL, 0x040f700000001820ULL,
0x0000004a4430723cULL, 0x000f700000001830ULL, 0x000000341c18723cULL, 0x060b700000001818ULL,
0x000000401c2c723cULL, 0x040b70000000182cULL, 0x000000421c28723cULL, 0x040b700000001828ULL,
0x0000003c1c20723cULL, 0x040b70000000180cULL, 0x0000003e1c14723cULL, 0x040b700000001814ULL,
0x000000361c34723cULL, 0x040b700000001810ULL, 0x000000241c38723cULL, 0x044b700000001838ULL,
0x000000261c1c723cULL, 0x000b620000001830ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000590300720cULL, 0x000fe20003f06070ULL, 0x01b6a0005aff7f8cULL, 0x0003d8000c80043fULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff921000007947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x002e640000002500ULL, 0x000000590300720cULL, 0x002fda0003f06070ULL,
0x0000033000000947ULL, 0x000fea0003800000ULL, 0x0180000009007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00008b60000c7802ULL, 0x020fc40000000f00ULL, 0x0000cfb000007944ULL, 0x010fea0003c00000ULL,
0x0000000400007202ULL, 0x00cfe20000000f00ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000900007308ULL, 0x000e640000001000ULL, 0xbf80000000047423ULL, 0x002fc80000000009ULL,
0x800000ff04057221ULL, 0x000fc80000010100ULL, 0x0000000500007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000ea40000000000ULL,
0x00000002ff0b7819ULL, 0x004fe40000011605ULL, 0x0000000805057811ULL, 0x000fc600078ff0ffULL,
0x00001f0b00047589ULL, 0x000ea800000e0000ULL, 0x00001f0500057589ULL, 0x000ee200000e0000ULL,
0x0000002c042c7220ULL, 0x064fe40000410000ULL, 0x0000002d042d7220ULL, 0x040fe40000410000ULL,
0x0000002804287220ULL, 0x040fe40000410000ULL, 0x0000002904297220ULL, 0x000fc40000410000ULL,
0x0000002004207220ULL, 0x040fe40000410000ULL, 0x0000002104217220ULL, 0x040fe40000410000ULL,
0x0000001404147220ULL, 0x040fe40000410000ULL, 0x0000001504157220ULL, 0x040fe40000410000ULL,
0x0000001804187220ULL, 0x040fe40000410000ULL, 0x0000001904197220ULL, 0x000fc40000410000ULL,
0x0000003404347220ULL, 0x040fe40000410000ULL, 0x0000003504357220ULL, 0x040fe40000410000ULL,
0x0000003804387220ULL, 0x040fe40000410000ULL, 0x0000003904397220ULL, 0x040fe40000410000ULL,
0x0000001c041c7220ULL, 0x040fe40000410000ULL, 0x0000001d041d7220ULL, 0x000fc40000410000ULL,
0x0000002e052e7220ULL, 0x048fe40000410000ULL, 0x0000002f052f7220ULL, 0x040fe40000410000ULL,
0x0000002a052a7220ULL, 0x040fe40000410000ULL, 0x0000002b052b7220ULL, 0x040fe40000410000ULL,
0x0000002205227220ULL, 0x040fe40000410000ULL, 0x0000002305237220ULL, 0x000fc40000410000ULL,
0x0000001605167220ULL, 0x040fe40000410000ULL, 0x0000001705177220ULL, 0x040fe40000410000ULL,
0x0000001a051a7220ULL, 0x040fe40000410000ULL, 0x0000001b051b7220ULL, 0x040fe40000410000ULL,
0x0000003605367220ULL, 0x040fe40000410000ULL, 0x0000003705377220ULL, 0x000fc40000410000ULL,
0x0000003a053a7220ULL, 0x040fe40000410000ULL, 0x0000003b053b7220ULL, 0x040fe40000410000ULL,
0x0000001e051e7220ULL, 0x040fe40000410000ULL, 0x0000001f051f7220ULL, 0x000fc40000410000ULL,
0x0000000000047919ULL, 0x000ea20000000000ULL, 0x0000001c1d10723eULL, 0x020fe400000000ffULL,
0x00000014150c723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000001a1b15723eULL, 0x000fc400000000ffULL, 0x00000018190d723eULL, 0x000fe400000000ffULL,
0x0000001e1f18723eULL, 0x000fe400000000ffULL, 0x000000222313723eULL, 0x000fe400000000ffULL,
0x00000020210b723eULL, 0x000fe400000000ffULL, 0x0000002a2b12723eULL, 0x000fe400000000ffULL,
0x000000282908723eULL, 0x000fc400000000ffULL, 0x00000002ff1d7819ULL, 0x004fe40000011604ULL,
0x00000008042a7811ULL, 0x000fe400078ff0ffULL, 0x000000021d057810ULL, 0x040fe20007ffe0ffULL,
0x000000081d1a7824ULL, 0x040fe200078e00ffULL, 0x000000011d007810ULL, 0x040fe20007ffe0ffULL,
0x000000081d197824ULL, 0x000fe200078e00ffULL, 0x0000002c2d06723eULL, 0x000fe200000000ffULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0xfffffff81a1e7812ULL, 0x000fe200078ee205ULL,
0x000000081d1b7824ULL, 0x040fe200078e00ffULL, 0x000000061d1a7810ULL, 0x040fe20007ffe0ffULL,
0x000000081d247824ULL, 0x000fe200078e00ffULL, 0xfffffff8191c7812ULL, 0x000fe200078ee200ULL,
0x000000081d227824ULL, 0x040fe200078e00ffULL, 0x000000031d007810ULL, 0x040fe20007ffe0ffULL,
0x000000081d287824ULL, 0x040fe200078e00ffULL, 0x000000051d197810ULL, 0x000fc40007ffe0ffULL,
0xfffffff81f267812ULL, 0x000fe200078ee21aULL, 0x000000081d1a7824ULL, 0x040fe200078e00ffULL,
0x000000041d057810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81b207812ULL, 0x000fe200078ee200ULL,
0x0000100067007824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee219ULL,
0x0000000404197824ULL, 0x000fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee205ULL,
0x0000080007057824ULL, 0x000fe200078e0200ULL, 0xfffffff81a1a7812ULL, 0x000fc400078ee21dULL,
0xffffffff1d1b7810ULL, 0x000fe20007ffe0ffULL, 0x000000101c1c7824ULL, 0x100fe200078e0205ULL,
0x000000032a1d7819ULL, 0x000fe200000006ffULL, 0x000000101a1a7824ULL, 0x100fe200078e0205ULL,
0x0000000c19197812ULL, 0x000fe200078ec0ffULL, 0x000000101e1e7824ULL, 0x000fe200078e0205ULL,
0xfffffff828287812ULL, 0x000fe200078ee21bULL, 0x0000001020207824ULL, 0x100fe200078e0205ULL,
0xfffffff81d2a7812ULL, 0x000fe200078ee22aULL, 0x0000001022227824ULL, 0x000fe200078e0205ULL,
0x0000000528287211ULL, 0x000fe200078e20ffULL, 0x000000011a1b7824ULL, 0x000fe200078e0219ULL,
0x00000034350e723eULL, 0x000fe200000000ffULL, 0x0000001024247824ULL, 0x100fe200078e0205ULL,
0x00000038390f723eULL, 0x000fe200000000ffULL, 0x00000001191d7824ULL, 0x000fe200078e021cULL,
0x000000061b007388ULL, 0x000fe20000000800ULL, 0x0000001026267824ULL, 0x100fe200078e0205ULL,
0x0000002e2f11723eULL, 0x000fe200000000ffULL, 0x00000001191e7824ULL, 0x000fe200078e021eULL,
0x000000081d007388ULL, 0x000fe20000000800ULL, 0x000000102a2a7824ULL, 0x000fe200078e0205ULL,
0x000000161714723eULL, 0x000fe200000000ffULL, 0x00000001191f7824ULL, 0x040fe200078e0220ULL,
0x0000000b1e007388ULL, 0x000fe20000000800ULL, 0x0000000119227824ULL, 0x040fe200078e0222ULL,
0x0000002a192a7210ULL, 0x040fe20007ffe0ffULL, 0x0000000119217824ULL, 0x040fe200078e0224ULL,
0x0000000c1f007388ULL, 0x000fe20000000800ULL, 0x0000000119267824ULL, 0x000fe200078e0226ULL,
0x000000363716723eULL, 0x000fe200000000ffULL, 0x0000000119237824ULL, 0x000fe200078e0228ULL,
0x0000000d22007388ULL, 0x000fe20000000800ULL, 0x000000016d197824ULL, 0x000fe200078e0204ULL,
0x0000003a3b17723eULL, 0x000fe200000000ffULL, 0x00000300ff207624ULL, 0x000fe200078e00ffULL,
0x0000000e21007388ULL, 0x000fe20000000800ULL, 0x00000010191a7824ULL, 0x000fc600078e0200ULL,
0x0000000f26007388ULL, 0x000fe20000000800ULL, 0x000000012000780cULL, 0x000fc60003f05270ULL,
0x0000001023007388ULL, 0x000fe80000000800ULL, 0x000000112a007388ULL, 0x000fe80000000800ULL,
0x000400121d007388ULL, 0x000fe80000000800ULL, 0x000400131e007388ULL, 0x000fe80000000800ULL,
0x000400141f007388ULL, 0x000fe80000000800ULL, 0x0004001522007388ULL, 0x000fe80000000800ULL,
0x0004001621007388ULL, 0x000fe80000000800ULL, 0x0004001726007388ULL, 0x000fe80000000800ULL,
0x0004001823007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000001a0c7984ULL, 0x000ea80000000c00ULL, 0x000400001a107984ULL, 0x000ee80000000c00ULL,
0x000800001a287984ULL, 0x000e680000000c00ULL, 0x000c00001a2c7984ULL, 0x000e620000000c00ULL,
0x200000ff0f0f7230ULL, 0x004fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff13137230ULL, 0x008fe40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fc40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x0000002b0f0f7230ULL, 0x002fe40000000000ULL, 0x0000002a0e0e7230ULL, 0x000fe40000000000ULL,
0x000000290d0d7230ULL, 0x000fe40000000000ULL, 0x000000280c0c7230ULL, 0x000fe40000000000ULL,
0x0000002f13137230ULL, 0x000fc40000000000ULL, 0x0000002e12127230ULL, 0x000fe20000000000ULL,
0x0000000c1a007388ULL, 0x000fe20000000c00ULL, 0x0000002d11117230ULL, 0x000fe40000000000ULL,
0x0000002c10107230ULL, 0x000fca0000000000ULL, 0x000400101a007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00002a8000008947ULL, 0x000fea0003800000ULL,
0x00000400ff067624ULL, 0x000fe200078e00ffULL, 0x0000000000147919ULL, 0x000e620000002600ULL,
0x00000040191b7810ULL, 0x000fc40007ffe0ffULL, 0x00006c0006067a24ULL, 0x000fe200078e02ffULL,
0x00000000000b7919ULL, 0x000e680000002700ULL, 0x0000000f06157811ULL, 0x040fe200078e10ffULL,
0x0000030006067a24ULL, 0x000fe200078e02ffULL, 0x000000001a0c7984ULL, 0x0004e40000000c00ULL,
0xfffffff015157812ULL, 0x000fe400078ec0ffULL, 0x000400001a107984ULL, 0x0004a60000000c00ULL,
0x0000008006087824ULL, 0x000fc800078e0215ULL, 0x0000008006067824ULL, 0x000fe400078e0208ULL,
0x000004000b147a24ULL, 0x002fc600078e0214ULL, 0x0000007f060b7810ULL, 0x000fe20007ffe0ffULL,
0x0000030014067a24ULL, 0x000fc600078e02ffULL, 0xffffff800b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000106037824ULL, 0x000fc600078e0203ULL, 0x000070000b167a10ULL, 0x000fc80007f1e0ffULL,
0x0000001603167211ULL, 0x000fe200078260ffULL, 0x00007100ff187624ULL, 0x000fe200000e06ffULL,
0x0000000107ff7812ULL, 0x000fc8000780f802ULL, 0x0000001803177211ULL, 0x000fe400008f64ffULL,
0x00007000151e7a10ULL, 0x000fc60007f3e0ffULL, 0x0000080067167825ULL, 0x000fc800078e0016ULL,
0x00007100ff1f7624ULL, 0x000fe400008e06ffULL, 0x0000001019187825ULL, 0x000fc800078e0016ULL,
0x000000101b167825ULL, 0x000fe200078e0016ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x00000004041a7819ULL, 0x00cfe200000006ffULL, 0x00000080031b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff1c7819ULL, 0x000fe40000011604ULL, 0x000000701a1d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c1c1a7812ULL, 0x000fe400078ec0ffULL, 0x000070001b1c7a10ULL, 0x000fe40007ebe008ULL,
0x00000019ff037819ULL, 0x000fc40000011603ULL, 0x0000001e1d1b7210ULL, 0x000fe40007a3e01bULL,
0x0000001c1a1c7210ULL, 0x040fe40007c7e01dULL, 0x00007100031d7a10ULL, 0x000fe40002fec4ffULL,
0x0000001b1a1a7210ULL, 0x000fe40007fbe0ffULL, 0x0000001fff037210ULL, 0x000fe40000fe4403ULL,
0x0000001dff1d7210ULL, 0x000fc60001fe84ffULL, 0x000000ffff1b7224ULL, 0x000fca00028e0603ULL,
0x0000000a1a007986ULL, 0x0003e8000c101906ULL, 0x000000091c007986ULL, 0x0003e4000c101906ULL,
0x000000ff0400720cULL, 0x00cfe20000705670ULL, 0x0000000c18007986ULL, 0x000fe2000c101d06ULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x0000001016007986ULL, 0x000fe8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff0d7424ULL, 0x000fe200078e00ffULL, 0xffffffff20037810ULL, 0x000fc60007ffe0ffULL,
0x00007000140c7625ULL, 0x000fe200078e000dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x000000030c0c79a8ULL, 0x000ea400099ee1c6ULL, 0x000000030c00720cULL, 0x004fc80003f05270ULL,
0x00000001ff097807ULL, 0x002fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000009ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff037984ULL, 0x000ea40000000000ULL,
0x000000ff0300720cULL, 0x004fda0003f05270ULL, 0x0000260000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001004037824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x002fe40000011604ULL,
0x0000001e06027211ULL, 0x000fe400078038ffULL, 0x0000007003097812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000001f06037211ULL, 0x000fe400000f3cffULL,
0x000000020a027210ULL, 0x000fc8000791e009ULL, 0x00000003ff037210ULL, 0x000fca00007e24ffULL,
0x0000000602097981ULL, 0x000328000c1e1900ULL, 0x00008006020a7981ULL, 0x000322000c1e1900ULL,
0x000000022000780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010006020e7981ULL, 0x002322000c1e1900ULL, 0x000000042000780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x0001800602107981ULL, 0x002322000c1e1900ULL,
0x000000042000780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x0002000602127981ULL, 0x002322000c1e1900ULL, 0x000000062000780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800602147981ULL, 0x002322000c1e1900ULL,
0x000000062000780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000082000780cULL, 0x002fe20003f06070ULL, 0x0003000602167981ULL, 0x000318000c1e1900ULL,
0x0003800602180981ULL, 0x000324000c1e1900ULL, 0x0000000720027810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0c7819ULL, 0x000fc80000011602ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x00000015060d7211ULL, 0x040fe200078038ffULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1a7224ULL, 0x010fe200078e0009ULL, 0x000070000d0d7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff060f7211ULL, 0x000fe400000f3cffULL, 0x000007800d0d7810ULL, 0x000fc80007f5e0ffULL,
0x00007100ff0f7a10ULL, 0x000fc400017e240fULL, 0x0000030011007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x000000040c007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x0000000811027810ULL, 0x040fe40007ffe0ffULL,
0x0000000111037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001a09097209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001004027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011604ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060fULL, 0xfffc8006021a7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x0000000911027810ULL, 0x042fe40007ffe0ffULL,
0x0000000211037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000000a09097209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001004027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011604ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020d027210ULL, 0x000fc80007f3e0ffULL,
0x0000000fff037210ULL, 0x000fca0000ffe4ffULL, 0xfffd0006020a7981ULL, 0x000328000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a11027810ULL, 0x042fe40007ffe0ffULL,
0x0000000311037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000000e09097209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001004027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011604ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060fULL, 0xfffd8006020e7981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b11027810ULL, 0x042fe40007ffe0ffULL,
0x0000000411037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001009097209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001004027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011604ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060fULL, 0xfffe000602107981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c11027810ULL, 0x042fe40007ffe0ffULL,
0x0000000511037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001209097209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001004027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011604ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060fULL, 0xfffe800602127981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d11027810ULL, 0x042fe40007ffe0ffULL,
0x0000000611037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001409097209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001004027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011604ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060fULL, 0xffff000602147981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e11027810ULL, 0x042fe40007ffe0ffULL,
0x0000000711037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001609097209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001004027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011604ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020d027210ULL, 0x000fc80007f3e0ffULL,
0x0000000fff037210ULL, 0x000fca0000ffe4ffULL, 0xffff800602167981ULL, 0x000328000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f11027810ULL, 0x002fe40007ffe0ffULL,
0x0000001809097209ULL, 0x000fe40007810000ULL, 0x0000030002007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001004027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011604ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020d027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e060fULL, 0x0000000602187981ULL, 0x000326000c1e1900ULL,
0x000004000d0d7810ULL, 0x000fe40007f3e0ffULL, 0x0000000811117810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000047919ULL, 0x000ea40000000000ULL, 0x0000001004027824ULL, 0x006fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011604ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fca00078ec0ffULL, 0x0000000102027824ULL, 0x000fca00078e0203ULL,
0x0000000902007388ULL, 0x0103e40000000800ULL, 0x000070000b027a10ULL, 0x002fe20007f3e0ffULL,
0x0000000107197824ULL, 0x000fe200078e0206ULL, 0x000000070400780cULL, 0x000fe20003f04070ULL,
0x0000080067127824ULL, 0x000fe200078e00ffULL, 0x000000016c097812ULL, 0x040fe200078ec0ffULL,
0x00007100ff037624ULL, 0x000fe200008e06ffULL, 0x0000700015157a10ULL, 0x000fe20007f5e0ffULL,
0x000008006c6c7824ULL, 0x000fe200078e00ffULL, 0x00000020040f7810ULL, 0x040fe20007ffe0ffULL,
0x00001000190a7825ULL, 0x000fe200078e0002ULL, 0x0000004004117810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000120a0a7210ULL, 0x000fe20007f3e0ffULL,
0x00000002070c8824ULL, 0x040fe200078e0267ULL, 0x00000067070e8211ULL, 0x040fe200078e08ffULL,
0x0000200007147824ULL, 0x000fe200078e0200ULL, 0x000008006c0d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000700008137a10ULL, 0x000fe20007f3e0ffULL,
0x000000020c1b8824ULL, 0x100fe200078e0209ULL, 0x0000006004177810ULL, 0x000fe20007ffe0ffULL,
0x000000020e238824ULL, 0x000fe200078e0209ULL, 0x00000001ff097819ULL, 0x000fe20000011604ULL,
0x0000001004087824ULL, 0x000fe200078e00ffULL, 0x00007100ff167a10ULL, 0x000fe20000ffe4ffULL,
0x00000001140d7824ULL, 0x000fe200078e020dULL, 0x0000000c09097812ULL, 0x000fe200078ec0ffULL,
0x00007100ff187624ULL, 0x000fe200010e06ffULL, 0x0000007008087812ULL, 0x000fe200078ec0ffULL,
0x00000010041d7824ULL, 0x000fe200078e020dULL, 0x00000013191e8211ULL, 0x000fe200078238ffULL,
0x000000100f0c7825ULL, 0x100fe200078e000aULL, 0x00000015191a8211ULL, 0x040fe200078438ffULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000016191f8211ULL, 0x000fe200008f3cffULL,
0x00000010110e7825ULL, 0x000fe200078e000aULL, 0x0000030007007a0cULL, 0x000fe20003f26070ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000001081c7824ULL, 0x000fe200078e0209ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000001017107825ULL, 0x100fe200078e000aULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000001c177984ULL, 0x0002a20000000800ULL,
0x00000010040a7825ULL, 0x040fe200078e000aULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x000000081b218824ULL, 0x100fe200078e0204ULL, 0x00000018191b8211ULL, 0x000fe200010f3cffULL,
0x0000000823238824ULL, 0x000fe200078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a1d7faeULL, 0x0007e2000b901c46ULL, 0x00000010041e8825ULL, 0x000fe200078e001eULL,
0x0000458021218811ULL, 0x000fe200078e20ffULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000418023238811ULL, 0x000fe200078e20ffULL, 0x003800000c1d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff197224ULL, 0x000fc400078e00ffULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x005800000e1d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff3a7224ULL, 0x000fe400078e00ffULL,
0x00000010040a8825ULL, 0x008fe200078e001aULL, 0x00780000101d7faeULL, 0x0003e2000b901c46ULL,
0x00000000001a7805ULL, 0x000fc6000001ff00ULL, 0x000000001e218faeULL, 0x0007e8000b901c46ULL,
0x000000000a238faeULL, 0x0005e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000001c7805ULL, 0x002fe2000001ff00ULL, 0x00000000001e7805ULL, 0x008fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x004fe2000001ff00ULL,
0x00000c7000001947ULL, 0x000fea0003800000ULL, 0x000000ffff197224ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fca00078e0007ULL, 0x000000023b397810ULL, 0x000fc80007ffe0ffULL,
0x0000030039007a0cULL, 0x000fda0003f06070ULL, 0x0000029000000947ULL, 0x000fea0003800000ULL,
0x0000000106117824ULL, 0x100fe200078e0239ULL, 0x000000070400780cULL, 0x040fe40003f44070ULL,
0x00000001ff0a7819ULL, 0x000fe20000011639ULL, 0x0000100011087825ULL, 0x000fe200078e0002ULL,
0x0000004004437810ULL, 0x000fe40007ffe0ffULL, 0x000000010a0a7812ULL, 0x000fe400078ec0ffULL,
0x00000012080e7210ULL, 0x000fe20007f1e0ffULL, 0x0000040039087824ULL, 0x000fe200078e00ffULL,
0x0000006004457810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e0609ULL,
0x0000080008097812ULL, 0x000fe200078ec0ffULL, 0x00000002070ba824ULL, 0x040fe200078e0267ULL,
0x000000670741a211ULL, 0x000fe200078e08ffULL, 0x00000010043c7825ULL, 0x040fe200078e000eULL,
0x00000013110ca211ULL, 0x040fe400078038ffULL, 0x000000151110a211ULL, 0x000fe200078238ffULL,
0x000000020b47a824ULL, 0x100fe200078e020aULL, 0x00000020040b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000114097824ULL, 0x000fe200078e0209ULL, 0x00000016110da211ULL, 0x000fe200000f3cffULL,
0x000000024141a824ULL, 0x000fe200078e020aULL, 0x000000181111a211ULL, 0x000fe200008f3cffULL,
0x00000010043f7824ULL, 0x000fc400078e0209ULL, 0x000000100b087825ULL, 0x000fc600078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800003c3f7faeULL, 0x0003e2000b901c46ULL,
0x00000010430a7825ULL, 0x000fc600078e000eULL, 0x00380000083f7faeULL, 0x0003e2000b901c46ULL,
0x000000084141a824ULL, 0x100fe400078e0204ULL, 0x000000084743a824ULL, 0x000fe200078e0204ULL,
0x005800000a3f7faeULL, 0x0003e2000b901c46ULL, 0x00000010450e7825ULL, 0x000fe200078e000eULL,
0x000045804141a811ULL, 0x000fe400078e20ffULL, 0x000041804343a811ULL, 0x000fe200078e20ffULL,
0x00000010040ca825ULL, 0x040fe200078e000cULL, 0x007800000e3f7faeULL, 0x0003e6000b901c46ULL,
0x000000100410a825ULL, 0x000fe200078e0010ULL, 0x000000000c41afaeULL, 0x0003e8000b901c46ULL,
0x000000001043afaeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000063b087819ULL, 0x002fe200000006ffULL, 0x00000002070b7824ULL, 0x000fe200078e0267ULL,
0x00000001ff0c7819ULL, 0x000fe20000011604ULL, 0x0000001004097824ULL, 0x000fe200078e00ffULL,
0x0000008008087812ULL, 0x000fc400078ec0ffULL, 0x00000002ff447819ULL, 0x000fc60000011604ULL,
0x000001000b0a7824ULL, 0x000fe200078e0008ULL, 0x0000007009087812ULL, 0x000fe200078ec0ffULL,
0x00000008440f7824ULL, 0x000fe200078e00ffULL, 0x0000000c0c097812ULL, 0x000fe200078ec0ffULL,
0x0000000844107824ULL, 0x040fe200078e00ffULL, 0x00000002440b7810ULL, 0x040fe20007ffe0ffULL,
0x00000008440d7824ULL, 0x040fe200078e00ffULL, 0x0000000a090c7210ULL, 0x000fe20007ffe008ULL,
0x00000008444a7824ULL, 0x040fe200078e00ffULL, 0x00000001440a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000844427824ULL, 0x040fe200078e00ffULL, 0x0000000844487810ULL, 0x040fe20007ffe0ffULL,
0x00000008443f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee20aULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180000c0e7984ULL, 0x000e620000000800ULL,
0x000004003b0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8103b7812ULL, 0x000fe200078ee20bULL,
0x0000000848117824ULL, 0x000fe200078e00ffULL, 0x004580000c3c7984ULL, 0x0004e20000000800ULL,
0xfffffff80d0d7812ULL, 0x000fe400078ee244ULL, 0x000008000a0b7812ULL, 0x000fe200078ec0ffULL,
0x00000004040a7824ULL, 0x000fe200078e00ffULL, 0x00000003443d7810ULL, 0x040fe40007ffe0ffULL,
0x00000004443e7810ULL, 0x000fc40007ffe0ffULL, 0x00000180140c7810ULL, 0x004fe40007ffe00bULL,
0x0000000c0a467812ULL, 0x000fe400078ec0ffULL, 0x0000000c0d0a7211ULL, 0x000fe400078e20ffULL,
0xfffffff8110b7812ULL, 0x000fe400078ee248ULL, 0xfffffff8423d7812ULL, 0x000fe200078ee23dULL,
0x00000001460a7824ULL, 0x000fe200078e020aULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee23eULL,
0x000000100b0b7824ULL, 0x000fe200078e020cULL, 0xffffffff443e7810ULL, 0x000fc40007ffe0ffULL,
0x000000000a0d7984ULL, 0x000ea20000000800ULL, 0x0000000146107824ULL, 0x000fe400078e020bULL,
0x000000100f0b7824ULL, 0x100fe200078e020cULL, 0x00000005440f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000010407984ULL, 0x000ea20000000800ULL, 0x00000001460b7824ULL, 0x000fe200078e020bULL,
0xfffffff84a437812ULL, 0x000fe200078ee20fULL, 0x000000103b0f7824ULL, 0x000fe200078e020cULL,
0x00000006443b7810ULL, 0x000fc40007ffe0ffULL, 0x000400000b417984ULL, 0x000fe20000000800ULL,
0x0000000e170e7221ULL, 0x002fe20000010100ULL, 0x0000000f460f7210ULL, 0x000fc60007ffe0ffULL,
0x3fb8aa3b0e0e7820ULL, 0x000fe40000410000ULL, 0x000000000f107984ULL, 0x000fe40000000800ULL,
0x0000000e00117308ULL, 0x0002e40000000800ULL, 0x000400000f427984ULL, 0x0005e80000000800ULL,
0x000000000b0e7984ULL, 0x002fe20000000800ULL, 0x0000003c11457220ULL, 0x008fc40000410000ULL,
0x00000008443c7824ULL, 0x040fe200078e00ffULL, 0x2000000dff0f7230ULL, 0x004fe20000004100ULL,
0x000000103d117824ULL, 0x100fe200078e020cULL, 0x00001f44450a7589ULL, 0x000e6200000e0000ULL,
0x00000008443d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c477812ULL, 0x000fe200078ee23bULL,
0x0000000146117824ULL, 0x040fe200078e0211ULL, 0x00001f48450b7589ULL, 0x0004e200000e0000ULL,
0x000000103f3c7824ULL, 0x000fe200078e020cULL, 0xfffffff83d3f7812ULL, 0x000fe200078ee23eULL,
0x00000010433d7824ULL, 0x000fe200078e020cULL, 0x00000000113b7984ULL, 0x000ee20000000800ULL,
0x00000001463c7824ULL, 0x000fc400078e023cULL, 0x0000003a453a7221ULL, 0x000fe20000010000ULL,
0x0000003d463d7210ULL, 0x040fe20007ffe0ffULL, 0x00000010473e7824ULL, 0x100fe200078e020cULL,
0x3000000dff457230ULL, 0x004fe20000004100ULL, 0x000000103f3f7824ULL, 0x000fe200078e020cULL,
0x0004000011437984ULL, 0x000ea20000000800ULL, 0x00000001463e7824ULL, 0x040fe400078e023eULL,
0x00000001463f7824ULL, 0x000fe200078e023fULL, 0x000000003d0d7984ULL, 0x000ea20000000800ULL,
0x20000040ff467230ULL, 0x000fc40000004100ULL, 0x30000040ff407230ULL, 0x000fe20000004100ULL,
0x000000003c0c7984ULL, 0x000ea20000000800ULL, 0x0000000a45367223ULL, 0x082fe40000010036ULL,
0x0000000a0f377223ULL, 0x000fe20000010037ULL, 0x000400003d117984ULL, 0x000e620000000800ULL,
0x0000000b40347223ULL, 0x088fe20000010034ULL, 0x2000000eff407230ULL, 0x100fe20000004100ULL,
0x0000000b46357223ULL, 0x000fe20000010035ULL, 0x000400003c447984ULL, 0x000ee20000000800ULL,
0x3000000eff457230ULL, 0x000fc40000004100ULL, 0x20000041ff0e7230ULL, 0x100fe20000004100ULL,
0x000000003e0f7984ULL, 0x000ee20000000800ULL, 0x30000041ff417230ULL, 0x000fe20000004100ULL,
0x0000000a40337223ULL, 0x080fe20000010033ULL, 0x20000042ff407230ULL, 0x100fe20000004100ULL,
0x000400003e3c7984ULL, 0x0004e20000000800ULL, 0x0000000b0e317223ULL, 0x080fe20000010031ULL,
0x30000042ff427230ULL, 0x000fe20000004100ULL, 0x0000000b41307223ULL, 0x080fe20000010030ULL,
0x000000003f0e7984ULL, 0x000ee20000000800ULL, 0x20000010ff417230ULL, 0x100fe20000004100ULL,
0x0000000a45327223ULL, 0x000fe20000010032ULL, 0x30000010ff107230ULL, 0x000fe20000004100ULL,
0x000400003f3d7984ULL, 0x0004e20000000800ULL, 0x0000000b402a7223ULL, 0x000fc4000001002aULL,
0x0000000a412c7223ULL, 0x080fe2000001002cULL, 0x2000003bff417230ULL, 0x100fe20000004100ULL,
0x0000000a102b7223ULL, 0x080fe2000001002bULL, 0x3000003bff3b7230ULL, 0x000fe20000004100ULL,
0x0000000b42297223ULL, 0x080fe20000010029ULL, 0x20000043ff107230ULL, 0x104fe20000004100ULL,
0x0000000a41287223ULL, 0x080fe20000010028ULL, 0x30000043ff3e7230ULL, 0x000fe20000004100ULL,
0x0000000a3b277223ULL, 0x080fe20000010027ULL, 0x2000000dff3b7230ULL, 0x100fe20000004100ULL,
0x0000000b10267223ULL, 0x080fe20000010026ULL, 0x3000000dff0d7230ULL, 0x000fe20000004100ULL,
0x0000000b3e257223ULL, 0x000fe20000010025ULL, 0x2000000cff3f7230ULL, 0x100fe20000004100ULL,
0x0000000a3b207223ULL, 0x000fe20000010020ULL, 0x3000000cff0c7230ULL, 0x000fe20000004100ULL,
0x000000ffff3b7224ULL, 0x000fc400078e0039ULL, 0x0000000a0d1f7223ULL, 0x080fe4000001001fULL,
0x0000000a0c237223ULL, 0x080fe20000010023ULL, 0x20000011ff0c7230ULL, 0x002fe20000004100ULL,
0x000003003b007a0cULL, 0x000fe20003f06070ULL, 0x20000044ff107230ULL, 0x108fe20000004100ULL,
0x0000000a3f247223ULL, 0x080fe20000010024ULL, 0x2000000fff0d7230ULL, 0x000fe20000004100ULL,
0x0000000b0c1e7223ULL, 0x080fe2000001001eULL, 0x30000044ff447230ULL, 0x000fe20000004100ULL,
0x0000000b10227223ULL, 0x080fe20000010022ULL, 0x2000003cff0c7230ULL, 0x000fe20000004100ULL,
0x0000000a0d1c7223ULL, 0x080fe2000001001cULL, 0x30000011ff107230ULL, 0x000fe20000004100ULL,
0x0000000b44217223ULL, 0x080fe20000010021ULL, 0x3000000eff0d7230ULL, 0x100fe20000004100ULL,
0x0000000b0c1a7223ULL, 0x080fe2000001001aULL, 0x2000000eff0c7230ULL, 0x000fe20000004100ULL,
0x0000000b101d7223ULL, 0x080fe2000001001dULL, 0x3000000fff0f7230ULL, 0x000fe20000004100ULL,
0x0000000a0d2e7223ULL, 0x080fe2000001002eULL, 0x3000003cff3c7230ULL, 0x000fe20000004100ULL,
0x0000000a0c2f7223ULL, 0x080fe2000001002fULL, 0x2000003dff0e7230ULL, 0x100fe20000004100ULL,
0x0000000a0f1b7223ULL, 0x000fe2000001001bULL, 0x3000003dff107230ULL, 0x000fe20000004100ULL,
0x0000000b3c387223ULL, 0x000fc40000010038ULL, 0x0000000b0e2d7223ULL, 0x080fe4000001002dULL,
0x0000000b10197223ULL, 0x000fe20000010019ULL, 0xfffff3b000008947ULL, 0x000fea000383ffffULL,
0x000000ff6700720cULL, 0x000fe20003f05270ULL, 0x0000018000007945ULL, 0x000fd80003800000ULL,
0x0000008007028824ULL, 0x000fe400078e0208ULL, 0x0000000108087824ULL, 0x000fe400078e0209ULL,
0x0000000109038824ULL, 0x000fca00078e0202ULL, 0x0049803a03008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0049800008027984ULL, 0x000e680000000800ULL,
0x004a000008097984ULL, 0x000ea20000000800ULL, 0x00000002ff027221ULL, 0x002fc80000010000ULL,
0x0000000902027221ULL, 0x004fca0000010000ULL, 0x0180000002047810ULL, 0x000fc80007ffe0ffULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff097224ULL, 0x000fe200078e0002ULL, 0x0000b670000c7802ULL, 0x000fc40000000f00ULL,
0x0000a4a000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff037224ULL, 0x00cfe200078e0004ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000200037308ULL, 0x000e640000001000ULL,
0xbf80000002047423ULL, 0x002fc80000000003ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000403037223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff087819ULL, 0x104fe20000011604ULL, 0x000000016d6d7824ULL, 0x000fe200078e0204ULL,
0x00000008040a7811ULL, 0x000fc400078ff0ffULL, 0x00000003080c7810ULL, 0x040fe20007ffe0ffULL,
0x00001f0803027589ULL, 0x000ea200000e0000ULL, 0x00000008080f7824ULL, 0x040fe200078e00ffULL,
0x0000000108097810ULL, 0x042fe20007ffe0ffULL, 0x00000008080e7824ULL, 0x040fe200078e00ffULL,
0x00001f0a03067589ULL, 0x0002e200000e0000ULL, 0x0000000808147824ULL, 0x040fe200078e00ffULL,
0x00000002080b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000808167824ULL, 0x040fe200078e00ffULL,
0x0000000308107819ULL, 0x040fe200000006ffULL, 0x0000000808187824ULL, 0x040fe200078e00ffULL,
0x00000004080d7810ULL, 0x000fe20007ffe0ffULL, 0x000000106d6d7824ULL, 0x000fe200078e0200ULL,
0xfffffff80f127812ULL, 0x000fc400078ee20cULL, 0xfffffff80e0e7812ULL, 0x000fe400078ee209ULL,
0xfffffff810107812ULL, 0x000fe200078ee20bULL, 0x0000001012127824ULL, 0x000fe200078e0205ULL,
0xfffffff814147812ULL, 0x000fe200078ee20dULL, 0x000000100e0e7824ULL, 0x100fe200078e0205ULL,
0xfffffff80f0c7812ULL, 0x000fe200078ee208ULL, 0x000000080a0f7824ULL, 0x000fe200078e00ffULL,
0x0000000508097810ULL, 0x000fe20007ffe0ffULL, 0x0000001014147824ULL, 0x000fe200078e0205ULL,
0x00000006080b7810ULL, 0x000fe20007ffe0ffULL, 0x0000003702377220ULL, 0x004fe20000410000ULL,
0xffffffff080d7810ULL, 0x000fe20007ffe0ffULL, 0x0000003602367220ULL, 0x000fe20000410000ULL,
0xfffffff816167812ULL, 0x000fe200078ee209ULL, 0x0000003302337220ULL, 0x000fe20000410000ULL,
0xfffffff818187812ULL, 0x000fe200078ee20bULL, 0x0000003202327220ULL, 0x040fe20000410000ULL,
0xfffffff80f0a7812ULL, 0x002fe200078ee20aULL, 0x0000002c022c7220ULL, 0x000fe20000410000ULL,
0x0000000510107211ULL, 0x000fe200078e20ffULL, 0x0000002b022b7220ULL, 0x000fe20000410000ULL,
0x000000373636723eULL, 0x000fe200000000ffULL, 0x0000002802287220ULL, 0x000fe20000410000ULL,
0x000000333232723eULL, 0x000fe200000000ffULL, 0x0000002702277220ULL, 0x040fe20000410000ULL,
0x0000002c2b2b723eULL, 0x000fe200000000ffULL, 0x0000002402247220ULL, 0x000fc40000410000ULL,
0x0000002302237220ULL, 0x040fe20000410000ULL, 0x000000282727723eULL, 0x000fe200000000ffULL,
0x0000002002207220ULL, 0x040fe40000410000ULL, 0x0000001f021f7220ULL, 0x040fe20000410000ULL,
0x000000242323723eULL, 0x000fe200000000ffULL, 0x0000001c021c7220ULL, 0x040fe40000410000ULL,
0x0000001b021b7220ULL, 0x040fe20000410000ULL, 0x000000201f1f723eULL, 0x000fe200000000ffULL,
0x0000002f022f7220ULL, 0x000fc40000410000ULL, 0x0000002e02027220ULL, 0x000fe20000410000ULL,
0x0000001c1b1b723eULL, 0x000fe200000000ffULL, 0x00000008082e7824ULL, 0x000fe400078e00ffULL,
0x0000000404087824ULL, 0x000fe200078e00ffULL, 0x0000002f0202723eULL, 0x000fe200000000ffULL,
0x000000100c0c7824ULL, 0x000fe200078e0205ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee20dULL,
0x0000001a061a7220ULL, 0x008fe20000410000ULL, 0x0000000c08097812ULL, 0x000fe200078ec0ffULL,
0x0000003806037220ULL, 0x000fc40000410000ULL, 0x0000001016167824ULL, 0x100fe400078e0205ULL,
0x0000001018087824ULL, 0x100fe200078e0205ULL, 0x0000001a0303723eULL, 0x000fe200000000ffULL,
0x000000102e2e7824ULL, 0x100fe200078e0205ULL, 0x0000001209187210ULL, 0x000fe20007ffe0ffULL,
0x000000100a0a7824ULL, 0x000fe400078e0205ULL, 0x0000001e061e7220ULL, 0x040fe40000410000ULL,
0x0000001d061d7220ULL, 0x000fc40000410000ULL, 0x000000010c057824ULL, 0x000fe400078e0209ULL,
0x00000001090d7824ULL, 0x000fe200078e020eULL, 0x0000001e1d1d723eULL, 0x000fe200000000ffULL,
0x0000000109107824ULL, 0x000fe200078e0210ULL, 0x0000003605007388ULL, 0x000fe20000000800ULL,
0x0000003506357220ULL, 0x040fe40000410000ULL, 0x0000003406347220ULL, 0x040fe20000410000ULL,
0x000000320d007388ULL, 0x000fe20000000800ULL, 0x0000003106317220ULL, 0x000fc40000410000ULL,
0x0000003006307220ULL, 0x000fe20000410000ULL, 0x0000002b10007388ULL, 0x000fe20000000800ULL,
0x00000001091a7824ULL, 0x000fe200078e0214ULL, 0x000000353434723eULL, 0x000fe200000000ffULL,
0x0000002a062a7220ULL, 0x040fe20000410000ULL, 0x0000002718007388ULL, 0x000fe20000000800ULL,
0x0000002906297220ULL, 0x000fe20000410000ULL, 0x000000313030723eULL, 0x000fe200000000ffULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x000000231a007388ULL, 0x000fe20000000800ULL,
0x0000002506257220ULL, 0x040fe20000410000ULL, 0x0000002a2929723eULL, 0x000fe200000000ffULL,
0x0000002206227220ULL, 0x000fc40000410000ULL, 0x0000002106217220ULL, 0x040fe20000410000ULL,
0x000000262525723eULL, 0x000fe200000000ffULL, 0x0000002d062d7220ULL, 0x040fe40000410000ULL,
0x00000001091c7824ULL, 0x000fe200078e0216ULL, 0x000000222121723eULL, 0x000fe200000000ffULL,
0x0000001906067220ULL, 0x000fe40000410000ULL, 0x00000001091e7824ULL, 0x040fe200078e0208ULL,
0x0000001f1c007388ULL, 0x000fe20000000800ULL, 0x0000000109197824ULL, 0x040fe200078e022eULL,
0x0000002d0606723eULL, 0x000fe200000000ffULL, 0x0000000109097824ULL, 0x000fe200078e020aULL,
0x0000001b1e007388ULL, 0x000fe80000000800ULL, 0x0000000219007388ULL, 0x000fe80000000800ULL,
0x0000003409007388ULL, 0x000fe80000000800ULL, 0x000400300d007388ULL, 0x000fe80000000800ULL,
0x0004002910007388ULL, 0x000fe80000000800ULL, 0x0004002518007388ULL, 0x000fe80000000800ULL,
0x000400211a007388ULL, 0x000fe80000000800ULL, 0x0004001d1c007388ULL, 0x000fe80000000800ULL,
0x000400031e007388ULL, 0x000fe80000000800ULL, 0x0004000619007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000006d087984ULL, 0x000e680000000c00ULL,
0x000400006d107984ULL, 0x000ea80000000c00ULL, 0x000800006d0c7984ULL, 0x000ee80000000c00ULL,
0x000c00006d147984ULL, 0x000ee20000000c00ULL, 0x200000ff0b0b7230ULL, 0x002fc40000000000ULL,
0x200000ff0a0a7230ULL, 0x000fe40000000000ULL, 0x200000ff09097230ULL, 0x000fe40000000000ULL,
0x200000ff08087230ULL, 0x000fe40000000000ULL, 0x200000ff13137230ULL, 0x004fe40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fc40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x0000000f0b0b7230ULL, 0x008fe40000000000ULL,
0x0000000e0a0a7230ULL, 0x000fe40000000000ULL, 0x0000000d09097230ULL, 0x000fe40000000000ULL,
0x0000000c08087230ULL, 0x000fe40000000000ULL, 0x0000001713137230ULL, 0x000fc40000000000ULL,
0x0000001612127230ULL, 0x000fe20000000000ULL, 0x000000086d007388ULL, 0x000fe20000000c00ULL,
0x0000001511117230ULL, 0x000fe40000000000ULL, 0x0000001410107230ULL, 0x000fca0000000000ULL,
0x000400106d007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff0700720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x000fc80000011604ULL, 0x000000710700720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000ea20000209000ULL,
0x000000ffff027224ULL, 0x000fe200078e00ffULL, 0x00005a00ff0e7a12ULL, 0x000fe400078e33ffULL,
0x0000002004117810ULL, 0x040fe40007ffe0ffULL, 0x00000007040c7812ULL, 0x000fe400078ec0ffULL,
0x0000000600067308ULL, 0x004ea40000001000ULL, 0x0ffffffe06087810ULL, 0x004fcc0007ffe0ffULL,
0x0000000800037305ULL, 0x000ea4000021f000ULL, 0x000000ffff057224ULL, 0x004fc800078e0a03ULL,
0x00005a0005057a24ULL, 0x000fc800078e02ffULL, 0x00000005030f7227ULL, 0x000fe200078e0002ULL,
0x0000000774027210ULL, 0x000fc60007ffe0ffULL, 0x0000000107077824ULL, 0x000fe400078e0204ULL,
0x000000020f037227ULL, 0x000fc600078e00ffULL, 0x0000000707077812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a03ULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103030810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x0ffffff807057812ULL, 0x000fe400078ef804ULL, 0x00005a00ff007a0cULL, 0x000fc60003f05070ULL,
0x0000001005057824ULL, 0x000fca00078e0200ULL, 0x0000000005087984ULL, 0x0022a20000000c00ULL,
0x0000000103031810ULL, 0x000fc80007ffe0ffULL, 0x000000030e037207ULL, 0x000fe20004000000ULL,
0x0000000867057824ULL, 0x002fc800078e020cULL, 0x000000ffff077224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e026eULL, 0x00005a0007027a24ULL, 0x000fc800078e0202ULL,
0x00005a0003037a24ULL, 0x000fca00078e0202ULL, 0x0000000372037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00005e0003027a11ULL, 0x000fc800078240ffULL,
0x00005f0003037a11ULL, 0x000fe400008f4406ULL, 0x00000003ff067819ULL, 0x000fc60000011611ULL,
0x0000001005027825ULL, 0x000fe200078e0002ULL, 0x000000710600720cULL, 0x000fc80003f26070ULL,
0x0000000802007986ULL, 0x0043f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000174027824ULL, 0x102fe200078e0206ULL, 0x0000004004107810ULL, 0x000fe20007ffe0ffULL,
0x0000000111067824ULL, 0x000fc400078e0206ULL, 0x000000020f077227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a07ULL,
0x00005a0003037a24ULL, 0x000fca00078e0202ULL, 0x00005a0003007a0cULL, 0x000fda0003f26070ULL,
0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806037812ULL, 0x000fe400078ef811ULL,
0x0000000711067812ULL, 0x000fe400078ec0ffULL, 0x0000000003057211ULL, 0x000fca00078e20ffULL,
0x0000000005087984ULL, 0x0002a40000000c00ULL, 0x0000000107072810ULL, 0x000fc80007ffe0ffULL,
0x000000070e077207ULL, 0x000fe20004000000ULL, 0x0000000867057824ULL, 0x002fc800078e0206ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007037a24ULL, 0x000fe200078e026eULL,
0x00000003ff077819ULL, 0x000fe20000011610ULL, 0x00005a000d027a24ULL, 0x000fc800078e0202ULL,
0x00005a0003037a24ULL, 0x000fca00078e0202ULL, 0x0000000372037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0003027a11ULL, 0x000fc800078240ffULL,
0x00005f0003037a11ULL, 0x000fe400008f440cULL, 0x000000710700720cULL, 0x000fc60003f26070ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000174027824ULL, 0x102fe200078e0207ULL,
0x00000060040d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000110077824ULL, 0x040fe200078e0207ULL,
0x0000000710047812ULL, 0x000fe200078ec0ffULL, 0x000000020f037227ULL, 0x000fc600078e00ffULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc600078e0a03ULL,
0x0ffffff807077812ULL, 0x000fe200078ef810ULL, 0x00005a0005057a24ULL, 0x000fc800078e0202ULL,
0x0000001007077824ULL, 0x000fe200078e0200ULL, 0x00005a0005007a0cULL, 0x000fc80003f26070ULL,
0x0000000007087984ULL, 0x000e720000000c00ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103031810ULL, 0x000fc40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fda0003f46070ULL,
0x0000000103032810ULL, 0x000fc80007ffe0ffULL, 0x000000030e037207ULL, 0x000fca0004000000ULL,
0x000000ffff057224ULL, 0x000fe400078e0a03ULL, 0x0000590003037a24ULL, 0x000fe400078e026eULL,
0x00005a0005027a24ULL, 0x000fe200078e0202ULL, 0x0000000467057211ULL, 0x000fc600078e18ffULL,
0x00005a0003037a24ULL, 0x000fca00078e0202ULL, 0x0000000372037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00005e0003027a11ULL, 0x000fc800078240ffULL,
0x00005f0003037a11ULL, 0x000fe400008f4406ULL, 0x00000003ff067819ULL, 0x000fc6000001160dULL,
0x0000001005027825ULL, 0x000fe200078e0002ULL, 0x000000710600720cULL, 0x000fc60003f26070ULL,
0x0000000174747824ULL, 0x000fe200078e0206ULL, 0x0000000802007986ULL, 0x0023f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000740f027227ULL, 0x002fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e0a02ULL, 0x000000010d067824ULL, 0x000fe400078e0206ULL,
0x00005a0003037a24ULL, 0x000fc600078e0274ULL, 0x0000000706067812ULL, 0x000fe400078ec0ffULL,
0x00005a0003007a0cULL, 0x000fda0003f26070ULL, 0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL,
0x0000000102021810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fe40003f46070ULL,
0xfffffff806037812ULL, 0x000fca00078ef80dULL, 0x0000001003047824ULL, 0x000fe200078e0200ULL,
0x000000070d007812ULL, 0x000fca00078ec0ffULL, 0x0000000102022810ULL, 0x000fe20007ffe0ffULL,
0x0000000004047984ULL, 0x000e620000000c00ULL, 0x0000000867677824ULL, 0x000fe400078e0200ULL,
0x000000020e037207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e026eULL, 0x00005a0009747a24ULL, 0x000fc800078e0274ULL,
0x00005a0003037a24ULL, 0x000fca00078e0274ULL, 0x0000000372037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005e0003027a11ULL, 0x000fc800078040ffULL,
0x00005f0003037a11ULL, 0x000fca00000f4408ULL, 0x0000001067027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000403047824ULL, 0x000fe200078e0202ULL, 0xffffffff00577802ULL, 0x000fc80000000f00ULL,
0x0000006a0400720cULL, 0x000fda0003f06070ULL, 0x00000002790b8824ULL, 0x000fc800078e00ffULL,
0x00006a000b0b8a24ULL, 0x000fc800078e0204ULL, 0x000066000b0a8625ULL, 0x000fe200078e0054ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000060a578981ULL, 0x000ea2000c1e1900ULL,
0x00000001030e7810ULL, 0x000fe20007ffe0ffULL, 0x00005800ff187624ULL, 0x000fe400078e00ffULL,
0x0000004077777824ULL, 0x000fe200078e00ffULL, 0x000000590e00720cULL, 0x000fe20003f06070ULL,
0x00000100ff0e7424ULL, 0x000fe200078e00ffULL, 0x0000001f18187810ULL, 0x000fe20007ffe0ffULL,
0x01b60000ff087f8cULL, 0x000ee2000c80043fULL, 0x0000004002787824ULL, 0x000fc400078e00ffULL,
0x000000406e057824ULL, 0x002fe200078e00ffULL, 0x00000005ff187819ULL, 0x000fe20000011618ULL,
0x0000007757077224ULL, 0x004fc800078e02ffULL, 0x00006400070a7625ULL, 0x000fe200078e000eULL,
0x00000c8000008947ULL, 0x000fea0003800000ULL, 0x0000010003077824ULL, 0x008fe200078e0278ULL,
0x00000003ff157819ULL, 0x000fc80000011606ULL, 0x0000000768147217ULL, 0x000fe20007800000ULL,
0x000000406e6e7824ULL, 0x000fe200078e0215ULL, 0x00000004150f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000815117810ULL, 0x040fe20007ffe0ffULL, 0x0000000114147824ULL, 0x000fe200078e0a07ULL,
0x00000018151b7810ULL, 0x000fe20007ffe0ffULL, 0x000000010f077824ULL, 0x100fe200078e0206ULL,
0x0000003815297810ULL, 0x000fe20007ffe0ffULL, 0x000000080f1a7824ULL, 0x040fe200078e00ffULL,
0x000000140f00720cULL, 0x000fe20003f46070ULL, 0x0000000811207824ULL, 0x000fe200078e00ffULL,
0x0000000c150f7810ULL, 0x000fe20007ffe0ffULL, 0x000000011b1e7824ULL, 0x000fe200078e0206ULL,
0xfffffff81a1a7812ULL, 0x000fc400078ee207ULL, 0x000000140f00720cULL, 0x040fe20003f86070ULL,
0x000000010f0e7824ULL, 0x000fe200078e0206ULL, 0x0000000611077210ULL, 0x000fe20007ffe0ffULL,
0x000000080f137824ULL, 0x000fe200078e00ffULL, 0x00000010150f7810ULL, 0x000fe40007ffe0ffULL,
0x000000141100720cULL, 0x080fe40003f66070ULL, 0xfffffff813247812ULL, 0x000fe200078ee20eULL,
0x000000010f107824ULL, 0x140fe200078e0206ULL, 0xfffffff820207812ULL, 0x000fe200078ee207ULL,
0x000000080f137824ULL, 0x000fe200078e00ffULL, 0x0000001415117810ULL, 0x040fe20007ffe0ffULL,
0x0000000115077824ULL, 0x000fe200078e0206ULL, 0x000000140f00720cULL, 0x000fe20003fa6070ULL,
0x000001006e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff813267812ULL, 0x000fc400078ee210ULL,
0x000000141100720cULL, 0x0c0fe20003f06070ULL, 0x0000000111127824ULL, 0x040fe200078e0206ULL,
0x000000046e107810ULL, 0x000fe20007ffe0ffULL, 0x0000000811177824ULL, 0x000fe200078e00ffULL,
0x0000000707117812ULL, 0x000fe400078ec0ffULL, 0x000000700e137812ULL, 0x000fe400078ef80cULL,
0x000000141500720cULL, 0x000fe40003f26070ULL, 0x0ffffff811167812ULL, 0x000fe200078ef806ULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0xfffffff817287812ULL, 0x000fc400078ee212ULL,
0x0000100002077811ULL, 0x000fe400078e70ffULL, 0x000000130a127210ULL, 0x000fe40007fde0ffULL,
0x000000086e0e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001016197824ULL, 0x000fe200078e0207ULL,
0x0000007010177812ULL, 0x000fe400078ef80cULL, 0x0000000f0b137210ULL, 0x000fe200037fe4ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x000000170a167210ULL, 0x000fc40007fde0ffULL,
0x0000000c6e107810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012197faeULL, 0x0003e2000c901c46ULL, 0x000000141b00720cULL, 0x040fe20003f26070ULL,
0x000000081b1b7824ULL, 0x000fe200078e00ffULL, 0x000000700e1d7812ULL, 0x000fe200078ef80cULL,
0x000000010b177824ULL, 0x000fe200030e0611ULL, 0x000000106e0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x0000001d0a1c7210ULL, 0x000fe40007fde0ffULL,
0xfffffff81b2a7812ULL, 0x000fc400078ee21eULL, 0x0000001c151b7810ULL, 0x000fe20007ffe0ffULL,
0x000000101a137824ULL, 0x002fe200078e0207ULL, 0x00000070101f7812ULL, 0x000fe200078ef80cULL,
0x000000010b1d7824ULL, 0x000fe200030e060fULL, 0x000000146e107810ULL, 0x000fe20007ffe0ffULL,
0x000000011b127824ULL, 0x040fe200078e0206ULL, 0x0000000016137faeULL, 0x0003e2000d101c46ULL,
0x000000141b00720cULL, 0x000fe20003f46070ULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001f0a1e7210ULL, 0x000fe40007fde0ffULL, 0x0000003c152b7810ULL, 0x000fe20007ffe0ffULL,
0x000000081b1b7824ULL, 0x000fe200078e00ffULL, 0x000000700e197812ULL, 0x000fe200078ef80cULL,
0x000000010b1f7824ULL, 0x000fc400030e0611ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0xfffffff81b2c7812ULL, 0x000fe400078ee212ULL, 0x000000186e127810ULL, 0x000fe40007ffe0ffULL,
0x000000190a0e7210ULL, 0x000fe20007fde0ffULL, 0x0000001020197824ULL, 0x000fe200078e0207ULL,
0x0000007010217812ULL, 0x000fe200078ef80cULL, 0x0000010012167825ULL, 0x002fe200078e00ffULL,
0x0000000f0b0f7210ULL, 0x000fe400037fe4ffULL, 0x0000002015137810ULL, 0x000fe20007ffe0ffULL,
0x000000001c197faeULL, 0x0003e2000d901c46ULL, 0x000000210a127210ULL, 0x000fc40007fde0ffULL,
0x0000001c6e107810ULL, 0x000fe20007ffe0ffULL, 0x00000001131b7824ULL, 0x040fe200078e0206ULL,
0x0000007016217812ULL, 0x100fe200078ef80cULL, 0x0000000813227824ULL, 0x040fe200078e00ffULL,
0x000000141300720cULL, 0x000fe20003f66070ULL, 0x000000010b137824ULL, 0x040fe200030e0611ULL,
0x000000210a1a7210ULL, 0x000fe20007fde0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe400078ee21bULL, 0x000000286e207810ULL, 0x000fe20007ffe0ffULL,
0x000000010b1b7824ULL, 0x000fe200030e0617ULL, 0x0000002415177810ULL, 0x000fe20007ffe0ffULL,
0x0000001024197824ULL, 0x002fe200078e0207ULL, 0x00000070101d7812ULL, 0x000fc400078ef80cULL,
0x000000206e107810ULL, 0x000fe20007ffe0ffULL, 0x00000001171c7824ULL, 0x040fe200078e0206ULL,
0x0000001d0a167210ULL, 0x000fe20007fde0ffULL, 0x0000000817217824ULL, 0x040fe200078e00ffULL,
0x000000001e197faeULL, 0x0003e2000e101c46ULL, 0x000000141700720cULL, 0x000fe40003f86070ULL,
0x000000010b177824ULL, 0x000fe200030e0611ULL, 0xfffffff821247812ULL, 0x000fe200078ee21cULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x000000246e1c7810ULL, 0x000fc40007ffe0ffULL,
0x00000028151d7810ULL, 0x000fe20007ffe0ffULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x0000007010237812ULL, 0x000fe400078ef80cULL, 0x0000000726197211ULL, 0x002fe200078e20ffULL,
0x000001001c1e7825ULL, 0x000fe200078e00ffULL, 0x000000230a1c7210ULL, 0x000fc60007fde0ffULL,
0x000000011d107824ULL, 0x040fe200078e0206ULL, 0x000000701e237812ULL, 0x000fe200078ef80cULL,
0x000000081d257824ULL, 0x040fe200078e00ffULL, 0x000000000e197faeULL, 0x0003e2000e901c46ULL,
0x000000141d00720cULL, 0x000fe20003fa6070ULL, 0x000000010b1d7824ULL, 0x000fe200030e0611ULL,
0x000000230a1e7210ULL, 0x000fe20007fde0ffULL, 0x0000001024277824ULL, 0x000fe200078e0207ULL,
0xfffffff825267812ULL, 0x000fe400078ee210ULL, 0x0000007020117812ULL, 0x000fe200078ef80cULL,
0x000000010b1f7824ULL, 0x000fe200030e061fULL, 0x0000002c6e107810ULL, 0x000fc40007ffe0ffULL,
0x0000002c15237810ULL, 0x000fe20007ffe0ffULL, 0x0000001028197824ULL, 0x002fe200078e0207ULL,
0x000000110a0e7210ULL, 0x000fe20007fde0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000306e207810ULL, 0x000fe40007ffe0ffULL, 0x0000000012197faeULL, 0x0003e2000c101c46ULL,
0x000000010b0f7824ULL, 0x000fe200030e0621ULL, 0x0000007010217812ULL, 0x000fe200078ef80cULL,
0x0000000123257824ULL, 0x040fe200078e0206ULL, 0x000000142300720cULL, 0x040fe20003f06070ULL,
0x0000000823287824ULL, 0x000fe200078e00ffULL, 0x000000210a107210ULL, 0x000fe20007fde0ffULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x0000003015237810ULL, 0x000fc40007ffe0ffULL,
0xfffffff828287812ULL, 0x000fe200078ee225ULL, 0x000000010b117824ULL, 0x000fe200030e0611ULL,
0x000000072a197211ULL, 0x002fe200078e20ffULL, 0x0000000123137824ULL, 0x040fe200078e0206ULL,
0x0000007020257812ULL, 0x000fe200078ef80cULL, 0x00000008232a7824ULL, 0x040fe200078e00ffULL,
0x000000346e207810ULL, 0x000fe20007ffe0ffULL, 0x000000001a197faeULL, 0x0003e2000c901c46ULL,
0x000000250a127210ULL, 0x000fe20007fde0ffULL, 0x0000001022257824ULL, 0x100fe200078e0207ULL,
0x000000142300720cULL, 0x000fe20003f26070ULL, 0x000000102c237824ULL, 0x000fe200078e0207ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee213ULL, 0x000000010b137824ULL, 0x000fc400030e0621ULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x0000000016237faeULL, 0x0005e2000d101c46ULL,
0x000000142b00720cULL, 0x080fe40003f46070ULL, 0x0000003415197810ULL, 0x002fe20007ffe0ffULL,
0x000000001c257faeULL, 0x0003e2000d901c46ULL, 0x000000386e157810ULL, 0x000fe40007ffe0ffULL,
0x00000070201b7812ULL, 0x000fe200078ef80cULL, 0x000000001e277faeULL, 0x0007e2000e101c46ULL,
0x000000141900720cULL, 0x000fc40003f86070ULL, 0x000000142900720cULL, 0x000fe20003f66070ULL,
0x0000010015147825ULL, 0x000fe200078e00ffULL, 0x0000003c6e167810ULL, 0x004fe40007ffe0ffULL,
0x0000001b0a1a7210ULL, 0x000fe20007fde0ffULL, 0x00000001191c7824ULL, 0x002fe200078e0206ULL,
0x00000070141d7812ULL, 0x000fe200078ef80cULL, 0x0000010016167825ULL, 0x000fc800078e00ffULL,
0x00000008191f7824ULL, 0x008fe200078e00ffULL, 0x0000000629197210ULL, 0x000fe20007ffe0ffULL,
0x000000010b1b7824ULL, 0x000fe200030e0621ULL, 0x0000001d0a147210ULL, 0x000fe20007fde0ffULL,
0x000000012b067824ULL, 0x000fe200078e0206ULL, 0x0000007016217812ULL, 0x000fe200078ef80cULL,
0x00000008291e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1c7812ULL, 0x000fe200078ee21cULL,
0x000000082b2b7824ULL, 0x000fe400078e00ffULL, 0x000000010b157824ULL, 0x000fe200030e0615ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee219ULL, 0x0000001026197824ULL, 0x100fe200078e0207ULL,
0xfffffff82b207812ULL, 0x000fe200078ee206ULL, 0x00000010281d7824ULL, 0x100fe200078e0207ULL,
0x000000210a067210ULL, 0x000fe20007fde0ffULL, 0x000000102a1f7824ULL, 0x100fe200078e0207ULL,
0x0000000720257211ULL, 0x000fe200078e20ffULL, 0x000000101c217824ULL, 0x100fe200078e0207ULL,
0x000000000e197faeULL, 0x0003e2000e901c46ULL, 0x000000101e237824ULL, 0x000fc400078e0207ULL,
0x000000010b077824ULL, 0x000fe200030e0617ULL, 0x00000000101d7faeULL, 0x0003e8000c101c46ULL,
0x00000000121f7faeULL, 0x0003e8000c901c46ULL, 0x000000001a217faeULL, 0x0003e8000e101c46ULL,
0x0000000014237faeULL, 0x0003e8000d901c46ULL, 0x0000000006257faeULL, 0x0003e2000d101c46ULL,
0x00000b3000007947ULL, 0x000fea0003800000ULL, 0x0000000406127811ULL, 0x048fe400078fe8ffULL,
0x0000000806167811ULL, 0x000fc400078fe8ffULL, 0x0000001006217811ULL, 0x000fe200078fe8ffULL,
0x0000000112077824ULL, 0x100fe200078e0206ULL, 0x0000000c061b7811ULL, 0x000fe200078fe8ffULL,
0x0000000812147824ULL, 0x000fe200078e00ffULL, 0x0000001406317811ULL, 0x000fe200078fe8ffULL,
0x00000008161a7824ULL, 0x000fe200078e00ffULL, 0x00000020061e7811ULL, 0x000fe200078fe8ffULL,
0x00000001210f7824ULL, 0x140fe200078e0206ULL, 0xfffffff814147812ULL, 0x000fe200078ee207ULL,
0x0000000116077824ULL, 0x100fe200078e0206ULL, 0x0000001806387811ULL, 0x000fe200078fe8ffULL,
0x0000000821307824ULL, 0x000fe200078e00ffULL, 0x0000000631107210ULL, 0x080fe20007ffe0ffULL,
0x000000011b0e7824ULL, 0x140fe200078e0206ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee207ULL,
0x000000081b117824ULL, 0x000fe200078e00ffULL, 0x0000001c06177811ULL, 0x040fe200078fe8ffULL,
0x0000000831137824ULL, 0x000fe200078e00ffULL, 0x00000024061d7811ULL, 0x000fe200078fe8ffULL,
0x000000011e077824ULL, 0x000fe200078e0206ULL, 0xfffffff830307812ULL, 0x000fe200078ee20fULL,
0x000000081e1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff811207812ULL, 0x000fe200078ee20eULL,
0x00000001380f7824ULL, 0x040fe200078e0206ULL, 0xfffffff813367812ULL, 0x000fe200078ee210ULL,
0x00000008383a7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c077812ULL, 0x000fe200078ee207ULL,
0x0000000117107824ULL, 0x140fe200078e0206ULL, 0x0000002c061c7811ULL, 0x040fe200078fe8ffULL,
0x0000000817117824ULL, 0x000fe200078e00ffULL, 0x00000028061f7811ULL, 0x040fe200078fe8ffULL,
0x000000011d0e7824ULL, 0x140fe200078e0206ULL, 0x00000034062c7811ULL, 0x040fe200078fe8ffULL,
0x000000081d357824ULL, 0x000fe200078e00ffULL, 0x0000003006327811ULL, 0x000fe200078fe8ffULL,
0x000000081c227824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee20fULL,
0x000000011c0f7824ULL, 0x000fe200078e0206ULL, 0xfffffff8113c7812ULL, 0x000fe200078ee210ULL,
0x000000081f377824ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee20eULL,
0x000000012c117824ULL, 0x140fe200078e0206ULL, 0x000000061f0e7210ULL, 0x080fe20007ffe0ffULL,
0x000000082c267824ULL, 0x000fe200078e00ffULL, 0x0000003806347811ULL, 0x000fe200078fe8ffULL,
0x0000000132107824ULL, 0x000fe200078e0206ULL, 0xfffffff822227812ULL, 0x000fe200078ee20fULL,
0x0000000832137824ULL, 0x000fe200078e00ffULL, 0xfffffff837377812ULL, 0x000fe200078ee20eULL,
0x00000001051e7824ULL, 0x040fe200078e021eULL, 0xfffffff826267812ULL, 0x000fe200078ee211ULL,
0x0000000134117824ULL, 0x000fe200078e0206ULL, 0x00000006060f7211ULL, 0x040fe200078fe8ffULL,
0x00000001053e7824ULL, 0x000fe200078e0234ULL, 0x00000005060e7211ULL, 0x000fc400078fe8ffULL,
0xfffffff813247812ULL, 0x000fe200078ee210ULL, 0x0000000105107824ULL, 0x040fe200078e0212ULL,
0x0000000334287819ULL, 0x000fe200000006ffULL, 0x0000000105127824ULL, 0x000fe200078e021bULL,
0x0000003c062e7811ULL, 0x000fe200078fe8ffULL, 0x000001003e3e7825ULL, 0x000fe200078e00ffULL,
0x000000070f137812ULL, 0x000fe400078ec0ffULL, 0xfffffff828287812ULL, 0x000fe200078ee211ULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000100002157811ULL, 0x000fc400078e70ffULL,
0x0ffffff813197812ULL, 0x000fe200078ef806ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000700e137812ULL, 0x000fe400078ef80cULL, 0x000000153c2f7211ULL, 0x000fe200078e20ffULL,
0x000000012e067824ULL, 0x000fe200078e0206ULL, 0x000000703e457812ULL, 0x100fe200078ef80cULL,
0x000000082e237824ULL, 0x000fe400078e00ffULL, 0x0000001007337824ULL, 0x100fe200078e0215ULL,
0x0000007010077812ULL, 0x000fe200078ef80cULL, 0x0000001020277824ULL, 0x000fe200078e0215ULL,
0xfffffff8232a7812ULL, 0x000fe200078ee206ULL, 0x0000000105207824ULL, 0x000fe200078e0231ULL,
0x000000130a067210ULL, 0x000fe20007f1e0ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000070a0e7210ULL, 0x000fc40007f3e0ffULL, 0x0000001605107210ULL, 0x000fe20007ffe0ffULL,
0x000000010b077824ULL, 0x040fe200000e060fULL, 0x0000007012317812ULL, 0x000fe200078ef80cULL,
0x000000010b0f7824ULL, 0x000fe400008e0611ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000310a127210ULL, 0x000fc60007f3e0ffULL, 0x0000001014237824ULL, 0x000fe200078e0215ULL,
0x00000070103b7812ULL, 0x000fe200078ef80cULL, 0x0000000105147824ULL, 0x000fe400078e0221ULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x0000003b0a107210ULL, 0x000fc60007f1e0ffULL,
0x000000101a257824ULL, 0x100fe200078e0215ULL, 0x0000007020317812ULL, 0x000fe200078ef80cULL,
0x00000001051a7824ULL, 0x000fe400078e0238ULL, 0x0000001019197824ULL, 0x100fe400078e0215ULL,
0x0000001030297824ULL, 0x100fe400078e0215ULL, 0x00000010362b7824ULL, 0x100fe200078e0215ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006197faeULL, 0x0003e2000b901c46ULL,
0x000000103a2d7824ULL, 0x000fc400078e0215ULL, 0x0000001035357824ULL, 0x100fe200078e0215ULL,
0x000000000e237faeULL, 0x0003e2000b901c46ULL, 0x0000001037377824ULL, 0x100fe400078e0215ULL,
0x0000001022227824ULL, 0x100fe400078e0215ULL, 0x0000001024247824ULL, 0x100fe400078e0215ULL,
0x0000001026267824ULL, 0x100fe400078e0215ULL, 0x0000001028287824ULL, 0x000fc400078e0215ULL,
0x000000102a2a7824ULL, 0x000fe400078e0215ULL, 0x000001001a1a7825ULL, 0x000fc800078e00ffULL,
0x000000010b117824ULL, 0x000fe200000e0611ULL, 0x000000310a167210ULL, 0x000fe20007f1e0ffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x000000701a317812ULL, 0x100fe400078ef80cULL,
0x0000000010257faeULL, 0x0003e2000b901c46ULL, 0x0000000105207824ULL, 0x000fe200078e0217ULL,
0x000000210b177210ULL, 0x000fe200007fe4ffULL, 0x0000000105387824ULL, 0x000fe200078e021fULL,
0x0000007014397812ULL, 0x000fe200078ef80cULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x000000310a1a7210ULL, 0x000fc40007f1e0ffULL, 0x000000390a147210ULL, 0x000fe20007f5e0ffULL,
0x0000000105307824ULL, 0x000fe200078e021dULL, 0x00000070203b7812ULL, 0x000fe200078ef80cULL,
0x0000010038387825ULL, 0x000fc800078e00ffULL, 0x000001001e1e7825ULL, 0x000fc800078e00ffULL,
0x000000010b1b7824ULL, 0x000fe200000e061bULL, 0x000000701e1d7812ULL, 0x000fe200078ef80cULL,
0x0000010030307825ULL, 0x000fc800078e00ffULL, 0x00000001053a7824ULL, 0x000fe200078e021cULL,
0x0000003b0a1c7210ULL, 0x000fe20007f1e0ffULL, 0x000000010b157824ULL, 0x040fe200010e0615ULL,
0x00000070383b7812ULL, 0x100fe200078ef80cULL, 0x000000010b137824ULL, 0x000fe200008e0613ULL,
0x00000070303d7812ULL, 0x000fe200078ef80cULL, 0x00000001053c7824ULL, 0x040fe200078e022cULL,
0x0000003b0a307210ULL, 0x000fe20007f5e0ffULL, 0x000001003a3a7825ULL, 0x000fe200078e00ffULL,
0x0000001d0a1e7210ULL, 0x040fe20007f3e0ffULL, 0x0000000012277faeULL, 0x0003e2000b901c46ULL,
0x0000003205387210ULL, 0x000fe20007ffe0ffULL, 0x000000010b1d7824ULL, 0x000fe200000e0621ULL,
0x0000003d0a207210ULL, 0x000fe20007f1e0ffULL, 0x0000000105407824ULL, 0x000fe200078e022eULL,
0x000000703a3d7812ULL, 0x100fe200078ef80cULL, 0x000000010b1f7824ULL, 0x040fe200008e061fULL,
0x0000000014297faeULL, 0x0003e2000b901c46ULL, 0x000000010b217824ULL, 0x040fe200000e0631ULL,
0x0000003d0a3a7210ULL, 0x040fe20007f1e0ffULL, 0x000000010b317824ULL, 0x040fe200010e0639ULL,
0x000000450a3e7210ULL, 0x000fe20007f5e0ffULL, 0x0000010038387825ULL, 0x000fe200078e00ffULL,
0x00000000162b7faeULL, 0x0003e6000b901c46ULL, 0x000001003c3c7825ULL, 0x000fe200078e00ffULL,
0x0000007038497812ULL, 0x100fe200078ef80cULL, 0x000000001a2d7faeULL, 0x0003e4000b901c46ULL,
0x0000010040407825ULL, 0x000fe200078e00ffULL, 0x000000703c477812ULL, 0x100fe200078ef80cULL,
0x000000001c2f7faeULL, 0x0003e4000b901c46ULL, 0x000000010b3b7824ULL, 0x040fe200000e063bULL,
0x0000007040437812ULL, 0x000fe200078ef80cULL, 0x000000001e337faeULL, 0x0003e2000b901c46ULL,
0x000000490a387210ULL, 0x040fe20007f1e0ffULL, 0x000000010b3f7824ULL, 0x040fe200010e063fULL,
0x000000470a3c7210ULL, 0x040fe20007f3e0ffULL, 0x0000000020357faeULL, 0x0003e2000b901c46ULL,
0x000000430a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000010b397824ULL, 0x000fc400000e0639ULL,
0x000000010b3d7824ULL, 0x040fe200008e063dULL, 0x0000000030377faeULL, 0x0003e2000b901c46ULL,
0x000000010b0b7824ULL, 0x000fc600018e0641ULL, 0x000000003a227faeULL, 0x0003e8000b901c46ULL,
0x0000000038247faeULL, 0x0003e8000b901c46ULL, 0x000000003c267faeULL, 0x0003e8000b901c46ULL,
0x000000003e287faeULL, 0x0003e8000b901c46ULL, 0x000000000a2a7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x002fc40000015200ULL,
0x01b60400ff0b7984ULL, 0x000e620000000800ULL, 0x000000180d557224ULL, 0x000fe200078e02ffULL,
0x000000ff000c7202ULL, 0x000fe20000000f00ULL, 0x0000000168737824ULL, 0x000fe200078e0a00ULL,
0x800000000bff7812ULL, 0x002fe20007804809ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000620055547625ULL, 0x000fe200078e0054ULL,
0x00000008ff737819ULL, 0x000fe20000011673ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a060d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e07ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000000d0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000590300720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000e620000000000ULL, 0x00006a0079797a24ULL, 0x000fe200078e02ffULL,
0x0001b68802757811ULL, 0x000fe200078e18ffULL, 0x00000002186b7824ULL, 0x000fe200078e00ffULL,
0xffffffff00077810ULL, 0x000fe20007ffe0ffULL, 0x0000002002767824ULL, 0x000fe200078e00ffULL,
0x0000000900087810ULL, 0x000fc40007ffe0ffULL, 0x00000001030a7810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff6c7424ULL, 0x000fe200078e00ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x00000057770d7224ULL, 0x004fe200078e02ffULL, 0x000000590a00720cULL, 0x000fe20003f06070ULL,
0x0000010003097824ULL, 0x000fc400078e0278ULL, 0x000064000d0c7625ULL, 0x000fd400078e006cULL,
0x00000bb000008947ULL, 0x008fea0003800000ULL, 0x00000003ff1d7819ULL, 0x102fe20000011606ULL,
0x00000010060a7824ULL, 0x000fe200078e00ffULL, 0x00000009681e7217ULL, 0x000fe40007800000ULL,
0x000000041d137810ULL, 0x000fe20007ffe0ffULL, 0x0000000105117824ULL, 0x000fe200078e021dULL,
0x000000081d157810ULL, 0x040fe20007ffe0ffULL, 0x000000011e1e7824ULL, 0x000fe200078e0a09ULL,
0x000000101d177810ULL, 0x000fe20007ffe0ffULL, 0x00000001130b7824ULL, 0x140fe200078e0206ULL,
0x000000700a0a7812ULL, 0x000fe200078ec0ffULL, 0x00000008130e7824ULL, 0x000fe200078e00ffULL,
0x00000006150f7210ULL, 0x040fe20007ffe0ffULL, 0x0000000815107824ULL, 0x000fe200078e00ffULL,
0x0000000c1d197810ULL, 0x000fe20007ffe0ffULL, 0x0000000117127824ULL, 0x140fe200078e0206ULL,
0xfffffff80e277812ULL, 0x000fe200078ee20bULL, 0x00000008172d7824ULL, 0x000fe200078e00ffULL,
0x0000001e1300720cULL, 0x000fe20003f86070ULL, 0x00000001190b7824ULL, 0x040fe200078e0206ULL,
0x000000800a0e7812ULL, 0x000fe200078efcffULL, 0x0000000819147824ULL, 0x000fe200078e00ffULL,
0xfffffff810297812ULL, 0x000fe200078ee20fULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x0000001305137210ULL, 0x000fc40007ffe0ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee212ULL,
0x0000010011107825ULL, 0x000fe200078e000eULL, 0x0000001e1500720cULL, 0x080fe40003f46070ULL,
0xfffffff8142b7812ULL, 0x000fe200078ee20bULL, 0x0000010013127825ULL, 0x000fe200078e000eULL,
0x000000141d1f7810ULL, 0x000fe40007ffe0ffULL, 0x0000001e1900720cULL, 0x000fe20003f66070ULL,
0x0000000105157824ULL, 0x040fe200078e0215ULL, 0x000000120c247210ULL, 0x040fe20007f3e0ffULL,
0x00000001050b7824ULL, 0x000fe200078e0217ULL, 0x000000100c107210ULL, 0x000fe20007f1e0ffULL,
0x0000010015147825ULL, 0x000fe200078e000eULL, 0x000000181d317810ULL, 0x000fc40007ffe0ffULL,
0x0000001c1d337810ULL, 0x000fe20007ffe0ffULL, 0x0000000105197824ULL, 0x040fe200078e0219ULL,
0x000000140c167210ULL, 0x000fe20007fbe0ffULL, 0x0000000105217824ULL, 0x000fe200078e021fULL,
0x00003000021c7811ULL, 0x000fe200078e70ffULL, 0x000000010d257824ULL, 0x000fe200008e0613ULL,
0x000000201d357810ULL, 0x000fe20007ffe0ffULL, 0x000001000b127825ULL, 0x000fe200078e000eULL,
0x0ffffff8060b7812ULL, 0x000fc600078ec0ffULL, 0x0000010019187825ULL, 0x000fc800078e000eULL,
0x000000010d117824ULL, 0x000fe200000e0611ULL, 0x0000001e1700720cULL, 0x000fe20003f06070ULL,
0x0000010021207825ULL, 0x000fe200078e000eULL, 0x000000180c1a7210ULL, 0x000fc60007f3e0ffULL,
0x000000010d177824ULL, 0x040fe200028e0615ULL, 0x000000120c147210ULL, 0x040fe20007fbe0ffULL,
0x000000010d1b7824ULL, 0x000fe200008e0619ULL, 0x000000200c127210ULL, 0x000fe20007fde0ffULL,
0x000000011d207824ULL, 0x100fe200078e0206ULL, 0x0000001e1f00720cULL, 0x080fe20003f26070ULL,
0x000000010d157824ULL, 0x040fe200028e0613ULL, 0x000000210d137210ULL, 0x000fe200037fe4ffULL,
0x0000000105197824ULL, 0x000fe200078e0231ULL, 0x0000001e1d00720cULL, 0x000fe20003fa6070ULL,
0x000000011f217824ULL, 0x000fc400078e0206ULL, 0x000000081f227824ULL, 0x000fe200078e00ffULL,
0x000000070b1f7812ULL, 0x000fe200078ef820ULL, 0x0000010019187825ULL, 0x000fc600078e000eULL,
0xfffffff8222f7812ULL, 0x000fe200078ee221ULL, 0x0000000105217824ULL, 0x000fe200078e0233ULL,
0x000000180c187210ULL, 0x040fe20007fde0ffULL, 0x000000101f1f7824ULL, 0x100fe400078e021cULL,
0x0000001027277824ULL, 0x000fe400078e021cULL, 0x0000010021207825ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101f7faeULL, 0x0003e2000e901c46ULL,
0x0000001e3100720cULL, 0x000fe40003fa6070ULL, 0x0000000105237824ULL, 0x000fe200078e0235ULL,
0x0000000024277faeULL, 0x0005e2000e101c46ULL, 0x000000010d197824ULL, 0x000fe200030e0619ULL,
0x000000200c207210ULL, 0x000fe20007fde0ffULL, 0x0000010023227825ULL, 0x000fe200078e000eULL,
0x0000001e3300720cULL, 0x000fc60003f86070ULL, 0x000000010d217824ULL, 0x000fe200030e0621ULL,
0x000000220c107210ULL, 0x002fe20007fde0ffULL, 0x00000010291f7824ULL, 0x000fe200078e021cULL,
0x000000241d297810ULL, 0x000fe20007ffe0ffULL, 0x0000000131267824ULL, 0x040fe200078e0206ULL,
0x0000000331317819ULL, 0x000fe200000006ffULL, 0x000000102b257824ULL, 0x004fe200078e021cULL,
0x00000000161f7faeULL, 0x0003e2000d101c46ULL, 0x0000000133287824ULL, 0x000fe200078e0206ULL,
0xfffffff831277812ULL, 0x000fe200078ee226ULL, 0x0000000833337824ULL, 0x000fe200078e00ffULL,
0x000000001a257faeULL, 0x0005e2000d901c46ULL, 0x0000001e3500720cULL, 0x0c0fe20003f66070ULL,
0x0000000135247824ULL, 0x000fe200078e0206ULL, 0x0000001e2900720cULL, 0x000fe20003f46070ULL,
0x0000000835357824ULL, 0x000fe200078e00ffULL, 0xfffffff833317812ULL, 0x000fe200078ee228ULL,
0x000000010d117824ULL, 0x000fe200030e0623ULL, 0x0000000629267210ULL, 0x000fe20007ffe0ffULL,
0x0000000105237824ULL, 0x000fe200078e0229ULL, 0x000000381d337810ULL, 0x000fe20007ffe0ffULL,
0x00000008292b7824ULL, 0x000fe200078e00ffULL, 0xfffffff835297812ULL, 0x000fe200078ee224ULL,
0x000000102d177824ULL, 0x102fe200078e021cULL, 0x0000002c1d2d7810ULL, 0x000fe20007ffe0ffULL,
0x000000102f1b7824ULL, 0x104fe200078e021cULL, 0x000000301d2f7810ULL, 0x000fe20007ffe0ffULL,
0x00000010271f7824ULL, 0x100fe200078e021cULL, 0x0000000014177faeULL, 0x0003e2000c101c46ULL,
0x0000001031257824ULL, 0x100fe200078e021cULL, 0x000000341d317810ULL, 0x000fe20007ffe0ffULL,
0x0000001029277824ULL, 0x000fe200078e021cULL, 0x000000281d297810ULL, 0x000fe20007ffe0ffULL,
0x0000010023227825ULL, 0x000fe200078e000eULL, 0x00000000121b7faeULL, 0x0005e2000c901c46ULL,
0x0000003c1d357810ULL, 0x000fc40007ffe0ffULL, 0x00000008291d7824ULL, 0x000fe200078e00ffULL,
0x00000000181f7faeULL, 0x0007e2000e901c46ULL, 0x000000220c227210ULL, 0x000fe20007fde0ffULL,
0x000000012f167824ULL, 0x000fe200078e0206ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee226ULL,
0x0000000020257faeULL, 0x0009e2000e101c46ULL, 0x000000012d147824ULL, 0x042fe200078e0206ULL,
0x0000001e2d00720cULL, 0x000fe20003fa6070ULL, 0x000000010d237824ULL, 0x000fe200030e0623ULL,
0x0000000010277faeULL, 0x0003e2000d901c46ULL, 0x0000001c2b157211ULL, 0x000fe200078e20ffULL,
0x0000000105137824ULL, 0x004fe200078e022dULL, 0x0000001e2900720cULL, 0x080fe20003fc6070ULL,
0x000000082d1f7824ULL, 0x008fe200078e00ffULL, 0x0000001e2f00720cULL, 0x080fe20003f86070ULL,
0x0000000022157faeULL, 0x0005e2000d101c46ULL, 0x0000010013127825ULL, 0x000fe200078e000eULL,
0x0000001e3100720cULL, 0x000fc40003f66070ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee214ULL,
0x000000082f217824ULL, 0x010fe200078e00ffULL, 0x0000001e3300720cULL, 0x080fe20003f26070ULL,
0x0000000129107824ULL, 0x002fe200078e0206ULL, 0x0000001e3500720cULL, 0x000fe20003f06070ULL,
0x0000000105117824ULL, 0x000fe200078e0229ULL, 0xfffffff821217812ULL, 0x000fe200078ee216ULL,
0x0000000105177824ULL, 0x000fe200078e022fULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee210ULL,
0x0000010011107825ULL, 0x000fe200078e000eULL, 0x0000000331237819ULL, 0x004fc600000006ffULL,
0x0000010017147825ULL, 0x000fe200078e000eULL, 0x000000100c107210ULL, 0x000fc60007f5e0ffULL,
0x0000000105197824ULL, 0x000fe400078e0231ULL, 0x000000010d117824ULL, 0x000fe200010e0611ULL,
0x000000120c167210ULL, 0x040fe20007f5e0ffULL, 0x0000000131127824ULL, 0x100fe400078e0206ULL,
0x00000001051b7824ULL, 0x000fe400078e0233ULL, 0x000000010d177824ULL, 0x000fe200010e0613ULL,
0x000000140c187210ULL, 0x000fe20007f5e0ffULL, 0x00000001331a7824ULL, 0x000fe200078e0206ULL,
0xfffffff823237812ULL, 0x000fe200078ee212ULL, 0x0000010019127825ULL, 0x000fc800078e000eULL,
0x000000010d197824ULL, 0x000fe200010e0615ULL, 0x000000120c127210ULL, 0x000fe20007f5e0ffULL,
0x000001001b147825ULL, 0x000fc600078e000eULL, 0x000000130d137210ULL, 0x000fe200017fe4ffULL,
0x00000001051b7824ULL, 0x000fe200078e0235ULL, 0x000000140c147210ULL, 0x000fe20007f5e0ffULL,
0x0000000833257824ULL, 0x000fe400078e00ffULL, 0x00000001351e7824ULL, 0x040fe400078e0206ULL,
0x0000000835277824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee21aULL,
0x000001001b0e7825ULL, 0x000fc600078e000eULL, 0xfffffff827277812ULL, 0x000fe200078ee21eULL,
0x000000010d157824ULL, 0x000fe200010e0615ULL, 0x0000000e0c0c7210ULL, 0x000fe20007f5e0ffULL,
0x000000101d1b7824ULL, 0x100fe400078e021cULL, 0x000000101f1d7824ULL, 0x100fe400078e021cULL,
0x00000010211f7824ULL, 0x100fe200078e021cULL, 0x00000000101b7faeULL, 0x0003e2000f101c46ULL,
0x0000001023217824ULL, 0x100fe400078e021cULL, 0x0000001025237824ULL, 0x100fe200078e021cULL,
0x00000000161d7faeULL, 0x0003e2000e901c46ULL, 0x0000001027257824ULL, 0x000fc400078e021cULL,
0x000000010d0d7824ULL, 0x000fe200010e060fULL, 0x00000000181f7faeULL, 0x0003e8000e101c46ULL,
0x0000000012217faeULL, 0x0003e8000d901c46ULL, 0x0000000014237faeULL, 0x0003e8000c901c46ULL,
0x000000000c257faeULL, 0x0003e2000c101c46ULL, 0x00000a7000007947ULL, 0x000fea0003800000ULL,
0x0000001406137811ULL, 0x042fe400078fe8ffULL, 0x00000004060e7811ULL, 0x000fc400078fe8ffULL,
0x0000000c06107811ULL, 0x040fe200078fe8ffULL, 0x0000000113147824ULL, 0x140fe200078e0206ULL,
0x0000001006117811ULL, 0x040fe200078fe8ffULL, 0x0000000813397824ULL, 0x000fe200078e00ffULL,
0x0000002406177811ULL, 0x000fe200078fe8ffULL, 0x000000010e0a7824ULL, 0x140fe200078e0206ULL,
0x000000030e317819ULL, 0x000fe200000006ffULL, 0x00000001100b7824ULL, 0x100fe200078e0206ULL,
0x00000008060f7811ULL, 0x000fe200078fe8ffULL, 0x0000000810167824ULL, 0x000fe200078e00ffULL,
0x0000002006157811ULL, 0x040fe200078fe8ffULL, 0x0000000111127824ULL, 0x000fe200078e0206ULL,
0xfffffff839397812ULL, 0x000fe200078ee214ULL, 0x0000000811377824ULL, 0x000fe200078e00ffULL,
0xfffffff831317812ULL, 0x000fe200078ee20aULL, 0x0000000117187824ULL, 0x140fe200078e0206ULL,
0x0000001c06147811ULL, 0x000fe200078fe8ffULL, 0x00000008173b7824ULL, 0x000fe200078e00ffULL,
0xfffffff816357812ULL, 0x000fe200078ee20bULL, 0x000000010f0a7824ULL, 0x000fe200078e0206ULL,
0xfffffff837377812ULL, 0x000fe200078ee212ULL, 0x000000080f337824ULL, 0x000fe200078e00ffULL,
0x0000001806127811ULL, 0x000fe200078fe8ffULL, 0x0000000115167824ULL, 0x000fe200078e0206ULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee218ULL, 0x00000008153d7824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee20aULL, 0x00000001140b7824ULL, 0x000fe200078e0206ULL,
0x0000002c06187811ULL, 0x000fe200078fe8ffULL, 0x00000008141a7824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee216ULL, 0x00000001120a7824ULL, 0x000fe200078e0206ULL,
0x00000034061e7811ULL, 0x000fe200078fe8ffULL, 0x0000000105277824ULL, 0x040fe200078e020fULL,
0x0000000312417819ULL, 0x000fe200000006ffULL, 0x00000001052b7824ULL, 0x000fe200078e0210ULL,
0x0000002806167811ULL, 0x000fe200078fe8ffULL, 0x000000011e1f7824ULL, 0x100fe200078e0206ULL,
0xfffffff81a3f7812ULL, 0x000fe200078ee20bULL, 0x00000001180b7824ULL, 0x000fe200078e0206ULL,
0x00000030061c7811ULL, 0x000fe200078fe8ffULL, 0x000000081e227824ULL, 0x000fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fe200078ee20aULL, 0x00000001160a7824ULL, 0x100fe200078e0206ULL,
0x0000000318207819ULL, 0x000fe200000006ffULL, 0x0000000816197824ULL, 0x000fe200078e00ffULL,
0xfffffff8221f7812ULL, 0x000fe200078ee21fULL, 0x000000011c1a7824ULL, 0x000fe200078e0206ULL,
0xfffffff8201b7812ULL, 0x000fe200078ee20bULL, 0x000000081c1d7824ULL, 0x000fe200078e00ffULL,
0x0000003806207811ULL, 0x040fe200078fe8ffULL, 0x00000001052d7824ULL, 0x000fe200078e0211ULL,
0xfffffff819197812ULL, 0x000fe200078ee20aULL, 0x0000000105257824ULL, 0x040fe200078e0212ULL,
0x0000003c06227811ULL, 0x000fe200078fe8ffULL, 0x0000000820217824ULL, 0x000fe200078e00ffULL,
0x00000006060a7211ULL, 0x040fe200078fe8ffULL, 0x00000001050f7824ULL, 0x000fe200078e0216ULL,
0x0ffffff8060b7812ULL, 0x000fe200078ec0ffULL, 0x0000000122237824ULL, 0x000fe200078e0206ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee21aULL, 0x00000001201a7824ULL, 0x000fe200078e0206ULL,
0x000000070b2f7812ULL, 0x000fe200078ef80aULL, 0x0000000822247824ULL, 0x000fe200078e00ffULL,
0x0000300002387811ULL, 0x000fe200078e70ffULL, 0x00000010060a7824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee21aULL, 0x0000000105117824ULL, 0x000fe200078e0218ULL,
0xfffffff824237812ULL, 0x000fe200078ee223ULL, 0x0000001031317824ULL, 0x100fe200078e0238ULL,
0x000000700a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000001033337824ULL, 0x100fe200078e0238ULL,
0x000000382f2f7211ULL, 0x080fe200078e20ffULL, 0x0000001035357824ULL, 0x100fe200078e0238ULL,
0x0000003819367211ULL, 0x000fe200078e20ffULL, 0x0000001037377824ULL, 0x100fe200078e0238ULL,
0x000000800a1a7812ULL, 0x000fe200078efcffULL, 0x0000001039397824ULL, 0x100fe200078e0238ULL,
0x0000002205437210ULL, 0x000fe20007ffe0ffULL, 0x0000001041417824ULL, 0x100fe200078e0238ULL,
0x0000001305297210ULL, 0x000fe20007ffe0ffULL, 0x000000103f3f7824ULL, 0x000fc400078e0238ULL,
0x000000103d3d7824ULL, 0x100fe400078e0238ULL, 0x000000103b3b7824ULL, 0x100fe400078e0238ULL,
0x000000101b347824ULL, 0x100fe400078e0238ULL, 0x000000101d327824ULL, 0x100fe400078e0238ULL,
0x000000101f307824ULL, 0x100fe200078e0238ULL, 0x00000005061f7211ULL, 0x000fe200078fe8ffULL,
0x00000010212e7824ULL, 0x000fc400078e0238ULL, 0x0000001023387824ULL, 0x000fe400078e0238ULL,
0x0000000105237824ULL, 0x040fe400078e020eULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x00000001051d7824ULL, 0x040fe400078e0215ULL, 0x0000000105157824ULL, 0x000fe400078e021eULL,
0x000001001f1e7825ULL, 0x000fc800078e001aULL, 0x0000010023227825ULL, 0x000fe200078e001aULL,
0x0000001e0c1e7210ULL, 0x000fc60007f1e0ffULL, 0x0000010027267825ULL, 0x000fe200078e001aULL,
0x000000220c227210ULL, 0x000fc60007f3e0ffULL, 0x000001002b2a7825ULL, 0x000fe200078e001aULL,
0x000000260c267210ULL, 0x000fc60007f5e0ffULL, 0x0000000105217824ULL, 0x040fe200078e0214ULL,
0x0000002a0c2a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000105197824ULL, 0x000fe400078e0217ULL,
0x000001002d2c7825ULL, 0x000fc800078e001aULL, 0x0000010029287825ULL, 0x000fc800078e001aULL,
0x0000000105177824ULL, 0x000fe400078e0220ULL, 0x0000010025247825ULL, 0x000fc800078e001aULL,
0x0000010021207825ULL, 0x000fc800078e001aULL, 0x000000010d1f7824ULL, 0x040fe200000e061fULL,
0x0000002c0c2c7210ULL, 0x040fe20007f1e0ffULL, 0x000000010d237824ULL, 0x000fe200008e0623ULL,
0x000000280c287210ULL, 0x040fe20007f3e0ffULL, 0x0000000105137824ULL, 0x000fe200078e021cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e2f7faeULL, 0x0003e2000b901c46ULL,
0x000000010d277824ULL, 0x000fe200010e0627ULL, 0x000000240c247210ULL, 0x040fe20007f5e0ffULL,
0x000001001d1c7825ULL, 0x100fe200078e001aULL, 0x0000000022317faeULL, 0x0003e6000b901c46ULL,
0x0000010019187825ULL, 0x000fe200078e001aULL, 0x0000000026337faeULL, 0x0003e6000b901c46ULL,
0x000000010d2b7824ULL, 0x000fe200018e062bULL, 0x000000200c207210ULL, 0x000fe20007f7e0ffULL,
0x000001000f0e7825ULL, 0x000fc600078e001aULL, 0x000000002a357faeULL, 0x0003e2000b901c46ULL,
0x0000010011107825ULL, 0x000fc800078e001aULL, 0x000000010d2d7824ULL, 0x040fe200000e062dULL,
0x0000001c0c1c7210ULL, 0x040fe20007f1e0ffULL, 0x000000010d297824ULL, 0x000fe200008e0629ULL,
0x000000180c187210ULL, 0x040fe20007f3e0ffULL, 0x0000010013127825ULL, 0x000fe200078e001aULL,
0x0000001d0d1d7210ULL, 0x040fe200007fe4ffULL, 0x000000002c377faeULL, 0x0003e4000b901c46ULL,
0x000000010d257824ULL, 0x000fe200010e0625ULL, 0x0000000e0c0e7210ULL, 0x040fe20007f5e0ffULL,
0x0000010015147825ULL, 0x000fe200078e001aULL, 0x000000120c127210ULL, 0x040fe20007f1e0ffULL,
0x0000000028397faeULL, 0x0003e4000b901c46ULL, 0x000000010d217824ULL, 0x000fe200018e0621ULL,
0x000000100c107210ULL, 0x040fe20007f7e0ffULL, 0x0000010017167825ULL, 0x100fe200078e001aULL,
0x0000000024417faeULL, 0x0003e6000b901c46ULL, 0x00000100431a7825ULL, 0x000fe200078e001aULL,
0x00000000203f7faeULL, 0x0003e6000b901c46ULL, 0x000000010d197824ULL, 0x040fe200008e0619ULL,
0x000000140c147210ULL, 0x040fe20007f3e0ffULL, 0x000000010d0f7824ULL, 0x040fe200010e060fULL,
0x000000160c167210ULL, 0x040fe20007f5e0ffULL, 0x000000010d117824ULL, 0x040fe200018e0611ULL,
0x0000001a0c0c7210ULL, 0x000fe20007f7e0ffULL, 0x000000010d137824ULL, 0x040fe200000e0613ULL,
0x000000001c3d7faeULL, 0x0003e2000b901c46ULL, 0x000000010d157824ULL, 0x000fc400008e0615ULL,
0x000000010d177824ULL, 0x040fe200010e0617ULL, 0x00000000183b7faeULL, 0x0003e2000b901c46ULL,
0x000000010d0d7824ULL, 0x000fc600018e061bULL, 0x000000000e367faeULL, 0x0003e8000b901c46ULL,
0x0000000010347faeULL, 0x0003e8000b901c46ULL, 0x0000000012327faeULL, 0x0003e8000b901c46ULL,
0x0000000014307faeULL, 0x0003e8000b901c46ULL, 0x00000000162e7faeULL, 0x0003e8000b901c46ULL,
0x000000000c387faeULL, 0x0003e4000b901c46ULL, 0x0000000404047810ULL, 0x000fe20007ffe0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff00577802ULL, 0x000fc40000000f00ULL,
0x0000006a0400720cULL, 0x000fda0003f06070ULL, 0x0000000279108824ULL, 0x002fe400078e0204ULL,
0x00000004ff118424ULL, 0x000fc800078e00ffULL, 0x0000660010108625ULL, 0x000fe200078e0011ULL,
0x0000000706157812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000610578981ULL, 0x000322000c1e1900ULL, 0x00000004ff137819ULL, 0x100fe20000011606ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000008150c7812ULL, 0x000fca00078ef806ULL,
0x00000001130f7824ULL, 0x000fe400078e020cULL, 0x000000100c0e7824ULL, 0x000fca00078e00ffULL,
0xfffffff00e0d7812ULL, 0x000fca00078ee20fULL, 0x000000100d3c7824ULL, 0x000fc600078e00ffULL,
0x0000000813307824ULL, 0x002fe200078e00ffULL, 0x00000003ff607819ULL, 0x000fe20000011606ULL,
0x00004000020d7824ULL, 0x000fe200078e00ffULL, 0x000000003c3c783bULL, 0x000fe20000000200ULL,
0x000000100c167824ULL, 0x000fe200078e00ffULL, 0xfffffff830307812ULL, 0x000fe400078ee215ULL,
0x0000000160147812ULL, 0x000fe400078ec0ffULL, 0x000010000d0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000830117824ULL, 0x040fe200078e00ffULL, 0x0000001030457810ULL, 0x000fe20007ffe0ffULL,
0x0000000114447824ULL, 0x000fe200078e0230ULL, 0x0000000330187819ULL, 0x000fc400000006ffULL,
0x000000020f157810ULL, 0x000fe20007ffe0ffULL, 0x00000001145c7824ULL, 0x000fe200078e0245ULL,
0xfffffff811587812ULL, 0x000fe200078ee244ULL, 0x0000000845177824ULL, 0x000fe200078e00ffULL,
0x00000002445f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff016157812ULL, 0x000fe200078ee215ULL,
0x0000001058107824ULL, 0x000fe200078e020eULL, 0xfffffff8185f7812ULL, 0x000fe400078ee25fULL,
0xfffffff8175c7812ULL, 0x000fe200078ee25cULL, 0x0000001015157824ULL, 0x000fe200078e00ffULL,
0x0000002030467810ULL, 0x040fe20007ffe0ffULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x000000105f4c7824ULL, 0x100fe200078e020eULL, 0x0000003030477810ULL, 0x000fe20007ffe0ffULL,
0x000000105c1c7824ULL, 0x000fe200078e020eULL, 0x000000001534783bULL, 0x0005e20000000200ULL,
0x00000001145b7824ULL, 0x000fe200078e0246ULL, 0x00000012445e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000846167824ULL, 0x000fe200078e00ffULL, 0x000000004c4c783bULL, 0x000ee20000000200ULL,
0x00000001145d7824ULL, 0x000fe200078e0247ULL, 0x0000000347147819ULL, 0x000fe200000006ffULL,
0x0000000846187824ULL, 0x000fe200078e00ffULL, 0x000000001c1c783bULL, 0x000ee20000000200ULL,
0x0000000845157824ULL, 0x004fe200078e00ffULL, 0xfffffff8165b7812ULL, 0x000fe200078ee25bULL,
0x0000000847257824ULL, 0x000fe200078e00ffULL, 0xfffffff8145d7812ULL, 0x000fc400078ee25dULL,
0xfffffff8155e7812ULL, 0x000fe200078ee25eULL, 0x000000105b287824ULL, 0x100fe200078e020eULL,
0x0000002244617810ULL, 0x040fe20007ffe0ffULL, 0x000000105d2c7824ULL, 0x100fe200078e020eULL,
0x0000003244647810ULL, 0x000fe20007ffe0ffULL, 0x000000105e147824ULL, 0x000fe200078e020eULL,
0xfffffff818617812ULL, 0x000fe200078ee261ULL, 0x000000002828783bULL, 0x000ea20000000200ULL,
0xfffffff825647812ULL, 0x000fe400078ee264ULL, 0x00000004445a7810ULL, 0x040fe20007ffe0ffULL,
0x000000002c2c783bULL, 0x000ea20000000200ULL, 0x0000001061207824ULL, 0x100fe200078e020eULL,
0x0000003444657810ULL, 0x000fe20007ffe0ffULL, 0x0000001064407824ULL, 0x000fe200078e020eULL,
0x000000001414783bULL, 0x000ea20000000200ULL, 0x000000060f317810ULL, 0x000fc40007ffe0ffULL,
0x0000001444637810ULL, 0x040fe20007ffe0ffULL, 0x000000002020783bULL, 0x000ea20000000200ULL,
0x0000002444667810ULL, 0x040fe20007ffe0ffULL, 0x000000103c38723cULL, 0x042f6400000018ffULL,
0x000000004040783bULL, 0x000e620000000200ULL, 0x0000003644697810ULL, 0x040fe40007ffe0ffULL,
0x0000000644627810ULL, 0x040fe40007ffe0ffULL, 0x0000001644567810ULL, 0x040fe20007ffe0ffULL,
0x000000123c10723cULL, 0x000f6200000018ffULL, 0x0000002644677810ULL, 0x000fde0007ffe0ffULL,
0x0000004c3438723cULL, 0x068ff00000001838ULL, 0x0000004e344c723cULL, 0x000ff00000001810ULL,
0x0000001c3c10723cULL, 0x040f7000000018ffULL, 0x0000001e3c1c723cULL, 0x040ff000000018ffULL,
0x000000283c18723cULL, 0x044f7000000018ffULL, 0x0000002a3c28723cULL, 0x040f7000000018ffULL,
0x0000002c3c24723cULL, 0x000b6e00000018ffULL, 0x00000008302d7824ULL, 0x020fe200078e00ffULL,
0x000000143410723cULL, 0x000be80000001810ULL, 0xfffffff82d5a7812ULL, 0x000fc600078ee25aULL,
0x000000100c157824ULL, 0x020fe200078e00ffULL, 0x000000040f147810ULL, 0x000fe20007ffe0ffULL,
0x000000105a507824ULL, 0x000fe200078e020eULL, 0x000000203418723cULL, 0x000fe40000001818ULL,
0xfffffff0152c7812ULL, 0x000fc600078ee214ULL, 0x000000005050783bULL, 0x000fe60000000200ULL,
0x000000163414723cULL, 0x000bee000000181cULL, 0x000000042c1c7819ULL, 0x020fe200000006ffULL,
0x0000002e3c3c723cULL, 0x000f6a00000018ffULL, 0x000000001c1c783bULL, 0x000ea60000000200ULL,
0x000000223420723cULL, 0x040bee0000001828ULL, 0x00000008472a7824ULL, 0x020fe200078e00ffULL,
0x000000403424723cULL, 0x042b620000001824ULL, 0x0000000845287824ULL, 0x040fe200078e00ffULL,
0x0000000345457819ULL, 0x000fe200000006ffULL, 0x0000000846297824ULL, 0x000fe200078e00ffULL,
0xfffffff82a657812ULL, 0x000fe200078ee265ULL, 0x0000000846467824ULL, 0x000fe200078e00ffULL,
0xfffffff828637812ULL, 0x000fe200078ee263ULL, 0x0000000830417824ULL, 0x020fe200078e00ffULL,
0x000000423434723cULL, 0x000b62000000183cULL, 0x000000100c407824ULL, 0x000fe200078e00ffULL,
0xfffffff829667812ULL, 0x000fe200078ee266ULL, 0x0000001065307824ULL, 0x000fe200078e020eULL,
0xfffffff841627812ULL, 0x000fe200078ee262ULL, 0x0000001063287824ULL, 0x000fe200078e020eULL,
0xfffffff040407812ULL, 0x000fe200078ee231ULL, 0x00000008473e7824ULL, 0x020fe200078e00ffULL,
0xfffffff845567812ULL, 0x000fe200078ee256ULL, 0x000000003030783bULL, 0x000e620000000200ULL,
0x00000010662c7824ULL, 0x100fe200078e020eULL, 0xfffffff846677812ULL, 0x000fe200078ee267ULL,
0x00000010403c7824ULL, 0x000fe200078e00ffULL, 0xfffffff83e697812ULL, 0x000fe200078ee269ULL,
0x000000002828783bULL, 0x000ee20000000200ULL, 0x0000001062407824ULL, 0x000fc400078e020eULL,
0x0000001056447824ULL, 0x100fe200078e020eULL, 0x000000002c2c783bULL, 0x000ee20000000200ULL,
0x0000001067487824ULL, 0x100fe200078e020eULL, 0x000000501c38723cULL, 0x044be40000001838ULL,
0x000000003c3c783bULL, 0x000fe80000000200ULL, 0x000000004040783bULL, 0x000fe20000000200ULL,
0x0000001069507824ULL, 0x020fe200078e020eULL, 0x000000521c4c723cULL, 0x040be4000000184cULL,
0x000000004444783bULL, 0x000fe80000000200ULL, 0x000000005050783bULL, 0x020ea80000000200ULL,
0x000000004848783bULL, 0x000ea20000000200ULL, 0x000000301c24723cULL, 0x042f700000001824ULL,
0x000000281c10723cULL, 0x048f700000001810ULL, 0x0000002a1c14723cULL, 0x040f700000001814ULL,
0x0000002c1c18723cULL, 0x040f700000001818ULL, 0x0000002e1c20723cULL, 0x040f700000001820ULL,
0x000000321c34723cULL, 0x000b6e0000001834ULL, 0x00000077571d7224ULL, 0x030fe200078e02ffULL,
0x000000503c24723cULL, 0x044b6e0000001824ULL, 0x0000030003507a10ULL, 0x020fe20007ffe0ffULL,
0x000000403c38723cULL, 0x000b660000001838ULL, 0x00000001501c7810ULL, 0x000fc80007ffe0ffULL,
0x000000591c00720cULL, 0x000fe20003f06070ULL, 0x000000423c4c723cULL, 0x000b62000000184cULL,
0x000064001d1c7625ULL, 0x000fce00078e006cULL, 0x000000443c10723cULL, 0x040b700000001810ULL,
0x000000463c14723cULL, 0x040b700000001814ULL, 0x000000483c18723cULL, 0x040b700000001818ULL,
0x0000004a3c20723cULL, 0x040b700000001820ULL, 0x000000523c34723cULL, 0x000b620000001834ULL,
0x00000c5000008947ULL, 0x000fce0003800000ULL, 0x00000004602b7810ULL, 0x040fe20007ffe0ffULL,
0x00000001601e7824ULL, 0x040fe200078e0206ULL, 0x0000001460417810ULL, 0x020fe20007ffe0ffULL,
0x00000100501f7824ULL, 0x000fe200078e0278ULL, 0x000000062b3d7210ULL, 0x040fe20007ffe0ffULL,
0x000000082b2a7824ULL, 0x000fe200078e00ffULL, 0x00000008602f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000141497824ULL, 0x000fe200078e0206ULL, 0x0000000c606d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105307824ULL, 0x000fe200078e0241ULL, 0x000000070b337812ULL, 0x000fe200078ef81eULL,
0x000000012f447824ULL, 0x140fe200078e0206ULL, 0xfffffff82a3d7812ULL, 0x000fe200078ee23dULL,
0x000000082f0b7824ULL, 0x000fe200078e00ffULL, 0x00000003412a7819ULL, 0x000fe200000006ffULL,
0x000000016d477824ULL, 0x040fe200078e0206ULL, 0x0000001c60427810ULL, 0x040fe20007ffe0ffULL,
0x000000086d1e7824ULL, 0x000fe200078e00ffULL, 0x00000020604a7810ULL, 0x000fc40007ffe0ffULL,
0x00000024604b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001423f7824ULL, 0x100fe200078e0206ULL,
0x0000001f68287217ULL, 0x000fe20007800000ULL, 0x000000014a3e7824ULL, 0x100fe200078e0206ULL,
0x0000001060537810ULL, 0x000fe20007ffe0ffULL, 0x000000014b297824ULL, 0x040fe200078e0206ULL,
0xfffffff82a497812ULL, 0x000fe200078ee249ULL, 0x00000008422a7824ULL, 0x000fe200078e00ffULL,
0x0000001860317810ULL, 0x000fe20007ffe0ffULL, 0x000000084b2c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b447812ULL, 0x000fe200078ee244ULL, 0x000000084a0b7824ULL, 0x000fe200078e00ffULL,
0x0000002860517810ULL, 0x000fe20007ffe0ffULL, 0x0000000128287824ULL, 0x000fe200078e0a1fULL,
0xfffffff81e477812ULL, 0x000fe200078ee247ULL, 0x0000000153487824ULL, 0x140fe200078e0206ULL,
0x0000002c60467810ULL, 0x000fe20007ffe0ffULL, 0x00000008531f7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a3f7812ULL, 0x000fe200078ee23fULL, 0x0000000131457824ULL, 0x040fe200078e0206ULL,
0x0000003060437810ULL, 0x000fe20007ffe0ffULL, 0x00000008311e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b3e7812ULL, 0x000fe200078ee23eULL, 0x00000008512a7824ULL, 0x000fe200078e00ffULL,
0xfffffff82c297812ULL, 0x000fe200078ee229ULL, 0x00000001052c7824ULL, 0x000fe200078e0260ULL,
0x00000006510b7210ULL, 0x000fe20007ffe0ffULL, 0x00000008462e7824ULL, 0x040fe200078e00ffULL,
0xfffffff81f487812ULL, 0x000fe200078ee248ULL, 0x00000001461f7824ULL, 0x100fe200078e0206ULL,
0xfffffff81e457812ULL, 0x000fe200078ee245ULL, 0x00000001431e7824ULL, 0x040fe200078e0206ULL,
0xfffffff82a0b7812ULL, 0x000fe200078ee20bULL, 0x00000008436f7824ULL, 0x000fe200078e00ffULL,
0xfffffff82e1f7812ULL, 0x000fe200078ee21fULL, 0x000001002c2c7825ULL, 0x000fe200078e00ffULL,
0x000000282b00720cULL, 0x000fc40003f86070ULL, 0xfffffff86f1e7812ULL, 0x000fe200078ee21eULL,
0x00000001052a7824ULL, 0x040fe200078e022fULL, 0x0000000a2c6f7212ULL, 0x000fe200078efcffULL,
0x00000001052e7824ULL, 0x000fe200078e022bULL, 0x000000286000720cULL, 0x080fe20003f26070ULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x0000006f1c2c7210ULL, 0x000fe40007f5e0ffULL,
0x000000282f00720cULL, 0x000fe20003f06070ULL, 0x000001002e2e7825ULL, 0x000fe200078e00ffULL,
0x0000000a2a6f7212ULL, 0x000fc400078efcffULL, 0x000000283100720cULL, 0x000fe20003fa6070ULL,
0x000000011d2d7824ULL, 0x000fe200010e062dULL, 0x0000006f1c2a7210ULL, 0x000fe20007f7e0ffULL,
0x00000010336f7824ULL, 0x000fe200078e020eULL, 0x0000000a2e717212ULL, 0x000fe200078efcffULL,
0x00000001052e7824ULL, 0x000fe200078e0253ULL, 0x0000003460527810ULL, 0x000fe20007ffe0ffULL,
0x000000011d2b7824ULL, 0x000fe200018e062bULL, 0x000000286d00720cULL, 0x080fe20003f66070ULL,
0x00000001056d7824ULL, 0x040fe200078e026dULL, 0x000000711c327210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c6f7faeULL, 0x0003e2000c901c46ULL,
0x00000001053c7824ULL, 0x000fe200078e0231ULL, 0x000000284100720cULL, 0x000fe20003f26070ULL,
0x0000010030307825ULL, 0x000fe200078e00ffULL, 0x0000000e47477211ULL, 0x000fc400078e20ffULL,
0x00000003527b7819ULL, 0x000fe200000006ffULL, 0x000000011d337824ULL, 0x000fe200010e062fULL,
0x000000285300720cULL, 0x000fe20003f46070ULL, 0x000001002e2e7825ULL, 0x000fc800078e00ffULL,
0x000001006d2c7825ULL, 0x002fe200078e00ffULL, 0x0000000a2e6d7212ULL, 0x000fc600078efcffULL,
0x000000103d417824ULL, 0x000fe200078e020eULL, 0x0000000a2c537212ULL, 0x000fe200078efcffULL,
0x000001003c3c7825ULL, 0x000fc600078e00ffULL, 0x000000531c2c7210ULL, 0x000fe20007fde0ffULL,
0x0000000032417faeULL, 0x0003e2000e101c46ULL, 0x0000000a30537212ULL, 0x080fe200078efcffULL,
0x00000001056c7824ULL, 0x000fe200078e0242ULL, 0x0000002d1d2d7210ULL, 0x000fe200037fe4ffULL,
0x0000001049497824ULL, 0x100fe200078e020eULL, 0x0000006d1c2e7210ULL, 0x040fe20007f9e0ffULL,
0x0000001045457824ULL, 0x100fe200078e020eULL, 0x000000531c307210ULL, 0x000fe20007fde0ffULL,
0x0000001029297824ULL, 0x000fe200078e020eULL, 0x0000000a3c537212ULL, 0x000fe200078efcffULL,
0x000000011d2f7824ULL, 0x000fe200020e062fULL, 0x000000284200720cULL, 0x000fe20003f86070ULL,
0x000001006c327825ULL, 0x002fe200078e00ffULL, 0x0000003860417810ULL, 0x000fc40007ffe0ffULL,
0x0000003c60607810ULL, 0x000fe20007ffe0ffULL, 0x000000011d317824ULL, 0x000fe200030e0631ULL,
0x000000531c3c7210ULL, 0x000fe20007fde0ffULL, 0x0000000141427824ULL, 0x140fe200078e0206ULL,
0x0000000a32537212ULL, 0x000fe200078efcffULL, 0x00000008416d7824ULL, 0x000fe400078e00ffULL,
0x000000011d3d7824ULL, 0x000fe200030e063dULL, 0x000000531c327210ULL, 0x000fe20007fde0ffULL,
0x00000001606c7824ULL, 0x040fe200078e0206ULL, 0xfffffff86d427812ULL, 0x000fe200078ee242ULL,
0x00000008606d7824ULL, 0x000fc400078e00ffULL, 0x0000001044537824ULL, 0x000fe400078e020eULL,
0x000000011d337824ULL, 0x000fe200030e0633ULL, 0xfffffff86d447812ULL, 0x000fe200078ee26cULL,
0x00000010486d7824ULL, 0x000fe200078e020eULL, 0x000000002a537faeULL, 0x0003e2000c101c46ULL,
0x000000285100720cULL, 0x080fe20003f06070ULL, 0x0000000105517824ULL, 0x000fe400078e0251ULL,
0x000000002c477faeULL, 0x0005e2000d901c46ULL, 0x000000284b00720cULL, 0x000fe20003f66070ULL,
0x00000001054b7824ULL, 0x000fc400078e024bULL, 0x000000002e6d7faeULL, 0x0007e2000d101c46ULL,
0x000000284a00720cULL, 0x080fe20003f46070ULL, 0x00000001054a7824ULL, 0x000fe400078e024aULL,
0x000001004b2a7825ULL, 0x002fe200078e00ffULL, 0x0000000030497faeULL, 0x0003e2000c901c46ULL,
0x000000284600720cULL, 0x000fe40003f26070ULL, 0x00000001052c7824ULL, 0x044fe200078e0246ULL,
0x0000000a2a477212ULL, 0x000fe200078efcffULL, 0x0000000105467824ULL, 0x000fe200078e0243ULL,
0x000000003c457faeULL, 0x0005e2000e901c46ULL, 0x000001002c2c7825ULL, 0x000fe200078e00ffULL,
0x000000471c2a7210ULL, 0x000fc60007fbe0ffULL, 0x00000100512e7825ULL, 0x008fe200078e00ffULL,
0x0000000a2c477212ULL, 0x000fe400078efcffULL, 0x0000002b1d2b7210ULL, 0x000fe20002ffe4ffULL,
0x000001004a307825ULL, 0x002fe200078e00ffULL, 0x000000471c2c7210ULL, 0x000fc60007fbe0ffULL,
0x00000100463c7825ULL, 0x004fe200078e00ffULL, 0x0000000a30497212ULL, 0x000fc600078efcffULL,
0x000000103f457824ULL, 0x000fe200078e020eULL, 0x000000491c307210ULL, 0x000fe20007fde0ffULL,
0x000000011d2d7824ULL, 0x000fe200028e062dULL, 0x0000000a2e497212ULL, 0x080fe200078efcffULL,
0x0000000105467824ULL, 0x000fe200078e0260ULL, 0x0000000a3c3f7212ULL, 0x000fe200078efcffULL,
0x000000011d317824ULL, 0x000fe200030e0631ULL, 0x0000000032457faeULL, 0x0003e2000e101c46ULL,
0x000000491c2e7210ULL, 0x000fe20007fde0ffULL, 0x00000001053c7824ULL, 0x000fe200078e0252ULL,
0x000000285200720cULL, 0x040fe20003f86070ULL, 0x0000000152407824ULL, 0x000fc400078e0206ULL,
0x000000011d2f7824ULL, 0x000fe200030e062fULL, 0x000000284300720cULL, 0x080fe20003fc6070ULL,
0x000000103e437824ULL, 0x000fe200078e020eULL, 0xfffffff87b407812ULL, 0x000fe200078ee240ULL,
0x000000101f1f7824ULL, 0x000fe200078e020eULL, 0x0000003f1c327210ULL, 0x002fe20007fbe0ffULL,
0x00000001053f7824ULL, 0x000fe200078e0241ULL, 0x0000000030437faeULL, 0x0003e6000d101c46ULL,
0x000000011d337824ULL, 0x000fe200028e063dULL, 0x000000002a297faeULL, 0x0005e2000d901c46ULL,
0x000001003c3c7825ULL, 0x000fe200078e00ffULL, 0x000000284100720cULL, 0x000fc60003f66070ULL,
0x000001003f3e7825ULL, 0x000fe200078e00ffULL, 0x0000000a3c477212ULL, 0x000fc600078efcffULL,
0x0000001042437824ULL, 0x102fe200078e020eULL, 0x0000000a3e457212ULL, 0x080fe200078efcffULL,
0x00000100462a7825ULL, 0x004fe200078e00ffULL, 0x000000471c307210ULL, 0x040fe40007fbe0ffULL,
0x000000451c3c7210ULL, 0x000fe20007f5e0ffULL, 0x000000101e297824ULL, 0x100fe200078e020eULL,
0x0000003d1d317210ULL, 0x040fe20002ffe4ffULL, 0x0000001044457824ULL, 0x100fe200078e020eULL,
0x0000000a2a417212ULL, 0x000fe200078efcffULL, 0x000000011d3d7824ULL, 0x000fe200010e063fULL,
0x000000286000720cULL, 0x000fe20003fa6070ULL, 0x000000100b3f7824ULL, 0x100fe200078e020eULL,
0x000000411c0a7210ULL, 0x000fe20007f5e0ffULL, 0x0000001040417824ULL, 0x000fc600078e020eULL,
0x000000002e3f7faeULL, 0x0003e2000c101c46ULL, 0x000000011d0b7824ULL, 0x000fc600010e062bULL,
0x000000002c1f7faeULL, 0x0003e8000c901c46ULL, 0x0000000032297faeULL, 0x0003e8000f101c46ULL,
0x0000000030417faeULL, 0x0003e8000e101c46ULL, 0x000000003c437faeULL, 0x0003e8000d901c46ULL,
0x000000000a457faeULL, 0x0003e2000e901c46ULL, 0x00000b1000007947ULL, 0x000fea0003800000ULL,
0x00000001052a7824ULL, 0x000fe200078e0260ULL, 0x0000000860707810ULL, 0x000fc40007ffe0ffULL,
0x00000004601e7810ULL, 0x000fe20007ffe0ffULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x00000006602e7210ULL, 0x040fe40007ffe0ffULL, 0x0000000c606f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001051f7824ULL, 0x040fe200078e0270ULL, 0x0000000a2a2d7212ULL, 0x000fe200078efcffULL,
0x0000000105287824ULL, 0x000fe200078e021eULL, 0x000000070b477812ULL, 0x020fe200078ef82eULL,
0x000000011e2f7824ULL, 0x000fe200078e0206ULL, 0x0000002d1c2c7210ULL, 0x000fe20007f1e0ffULL,
0x000000081e2a7824ULL, 0x000fe200078e00ffULL, 0x00000010606e7810ULL, 0x040fe20007ffe0ffULL,
0x000001001f1e7825ULL, 0x000fe200078e00ffULL, 0x0000001860537810ULL, 0x000fc40007ffe0ffULL,
0xfffffff82a0b7812ULL, 0x000fe200078ee22fULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x0000000a1e457212ULL, 0x080fe400078efcffULL, 0x0000001c60527810ULL, 0x000fe20007ffe0ffULL,
0x00000001051e7824ULL, 0x000fe200078e026fULL, 0x000000451c447210ULL, 0x000fe20007f3e0ffULL,
0x000000011d2d7824ULL, 0x000fe200000e062bULL, 0x0000000a282f7212ULL, 0x000fe200078efcffULL,
0x0000000105327824ULL, 0x000fe200078e026eULL, 0x00000014606d7810ULL, 0x000fe20007ffe0ffULL,
0x000000011d457824ULL, 0x000fe200008e061fULL, 0x0000002f1c2a7210ULL, 0x000fe20007f1e0ffULL,
0x000001001e1e7825ULL, 0x000fe200078e00ffULL, 0x0000006d05307210ULL, 0x000fc40007ffe0ffULL,
0x0000002060517810ULL, 0x000fe20007ffe0ffULL, 0x000000011d2b7824ULL, 0x000fe200000e0629ULL,
0x0000000a1e297212ULL, 0x080fe200078efcffULL, 0x0000010032327825ULL, 0x000fe200078e00ffULL,
0x00000024604a7810ULL, 0x000fe40007ffe0ffULL, 0x000000291c1e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001052e7824ULL, 0x040fe200078e0253ULL, 0x0000000a32437212ULL, 0x000fe200078efcffULL,
0x0000000105287824ULL, 0x000fe200078e0252ULL, 0x00000028604b7810ULL, 0x000fe20007ffe0ffULL,
0x000001002e2e7825ULL, 0x000fe200078e00ffULL, 0x0000000e47477211ULL, 0x000fc400078e20ffULL,
0x0000002c606c7810ULL, 0x000fe20007ffe0ffULL, 0x000000011d1f7824ULL, 0x040fe200000e061fULL,
0x000000431c427210ULL, 0x000fe20007f1e0ffULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x0000000a2e3f7212ULL, 0x080fe200078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c477faeULL, 0x0003e2000b901c46ULL, 0x0000003060717810ULL, 0x000fe20007ffe0ffULL,
0x000000011d437824ULL, 0x000fe200000e0633ULL, 0x0000003f1c3e7210ULL, 0x000fe20007f1e0ffULL,
0x0000010030307825ULL, 0x000fe200078e00ffULL, 0x0000000a283d7212ULL, 0x000fc400078efcffULL,
0x0000003460727810ULL, 0x000fe20007ffe0ffULL, 0x000000011d3f7824ULL, 0x000fe200000e062fULL,
0x0000003d1c3c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001052e7824ULL, 0x040fe200078e0251ULL,
0x0000000a30417212ULL, 0x080fe200078efcffULL, 0x0000000105287824ULL, 0x000fe200078e024aULL,
0x00000038607a7810ULL, 0x000fe20007ffe0ffULL, 0x000001002e2e7825ULL, 0x000fe200078e00ffULL,
0x000000411c407210ULL, 0x000fe40007f3e0ffULL, 0x0000003c60607810ULL, 0x000fe20007ffe0ffULL,
0x000000011d3d7824ULL, 0x000fe200000e0629ULL, 0x0000000a2e337212ULL, 0x000fe200078efcffULL,
0x0000010028287825ULL, 0x000fc600078e00ffULL, 0x000000331c327210ULL, 0x000fe20007f1e0ffULL,
0x000000011d417824ULL, 0x000fe200008e0631ULL, 0x0000000a28317212ULL, 0x000fe200078efcffULL,
0x0000000105307824ULL, 0x040fe400078e024bULL, 0x0000000105287824ULL, 0x000fe400078e026cULL,
0x00000100302c7825ULL, 0x002fe200078e00ffULL, 0x000000311c307210ULL, 0x000fc60007f3e0ffULL,
0x000000011d337824ULL, 0x040fe200000e062fULL, 0x0000000a2c2f7212ULL, 0x000fe200078efcffULL,
0x000000011d317824ULL, 0x000fe400008e0629ULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x0000002f1c2e7210ULL, 0x000fc60007f1e0ffULL, 0x000000100b0b7824ULL, 0x000fe200078e020eULL,
0x0000000a28477212ULL, 0x000fe200078efcffULL, 0x000000011d2f7824ULL, 0x000fe400000e062dULL,
0x0000000105287824ULL, 0x040fe200078e0271ULL, 0x000000471c2c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000105467824ULL, 0x040fe200078e0272ULL, 0x000000002a0b7faeULL, 0x0003e2000b901c46ULL,
0x0000000105487824ULL, 0x000fe400078e0260ULL, 0x000000011d2d7824ULL, 0x000fc400000e0629ULL,
0x0000010048487825ULL, 0x000fc800078e00ffULL, 0x00000001717d7824ULL, 0x000fe200078e0206ULL,
0x0000000a487b7212ULL, 0x000fe200078efcffULL, 0x000000086d487824ULL, 0x000fe400078e00ffULL,
0x00000100282a7825ULL, 0x002fc800078e00ffULL, 0x0000010046287825ULL, 0x000fe200078e00ffULL,
0x0000000a2a0b7212ULL, 0x000fc600078efcffULL, 0x0000000105467824ULL, 0x000fe200078e027aULL,
0x0000000a28477212ULL, 0x000fe400078efcffULL, 0x0000000b1c2a7210ULL, 0x040fe40007f1e0ffULL,
0x000000471c287210ULL, 0x000fe20007f3e0ffULL, 0x0000010046467825ULL, 0x000fe200078e00ffULL,
0x0000002b1d2b7210ULL, 0x000fc600007fe4ffULL, 0x000000011d297824ULL, 0x000fe200008e0629ULL,
0x0000000a460b7212ULL, 0x000fe200078efcffULL, 0x0000000170467824ULL, 0x000fc600078e0206ULL,
0x0000000b1c0a7210ULL, 0x040fe40007f1e0ffULL, 0x0000007b1c1c7210ULL, 0x000fc60007f3e0ffULL,
0x000000011d0b7824ULL, 0x040fe400000e0647ULL, 0x0000000870477824ULL, 0x000fe400078e00ffULL,
0x000000011d1d7824ULL, 0x000fe400008e0649ULL, 0x000000016d497824ULL, 0x000fe200078e0206ULL,
0xfffffff847477812ULL, 0x000fe400078ee246ULL, 0x000000036f467819ULL, 0x000fe400000006ffULL,
0xfffffff848497812ULL, 0x000fe200078ee249ULL, 0x00000010477b7824ULL, 0x000fc400078e020eULL,
0x000000016f477824ULL, 0x000fe400078e0206ULL, 0x000000086e6f7824ULL, 0x000fe200078e00ffULL,
0x00000000447b7faeULL, 0x0003e2000b901c46ULL, 0x0000001049497824ULL, 0x000fe200078e020eULL,
0xfffffff846477812ULL, 0x000fe200078ee247ULL, 0x000000016e467824ULL, 0x000fc800078e0206ULL,
0x0000001047477824ULL, 0x000fe200078e020eULL, 0xfffffff86f6d7812ULL, 0x000fe200078ee246ULL,
0x00000001516f7824ULL, 0x100fe400078e0206ULL, 0x0000000153467824ULL, 0x100fe200078e0206ULL,
0x0000000351447819ULL, 0x002fe200000006ffULL, 0x000000014b7b7824ULL, 0x000fe200078e0206ULL,
0x000000001e477faeULL, 0x0003e2000b901c46ULL, 0x0000000853537824ULL, 0x000fe200078e00ffULL,
0xfffffff8446f7812ULL, 0x000fe200078ee26fULL, 0x000000084b447824ULL, 0x000fc400078e00ffULL,
0x0000000152457824ULL, 0x040fe200078e0206ULL, 0xfffffff853537812ULL, 0x000fe200078ee246ULL,
0x0000000852527824ULL, 0x000fe200078e00ffULL, 0xfffffff8447b7812ULL, 0x000fe200078ee27bULL,
0x000000014a517824ULL, 0x100fe200078e0206ULL, 0x0000000e6f6f7211ULL, 0x000fe200078e20ffULL,
0x0000000871447824ULL, 0x000fe200078e00ffULL, 0xfffffff852457812ULL, 0x000fe200078ee245ULL,
0x000000084a4a7824ULL, 0x000fe400078e00ffULL, 0x000000016c4b7824ULL, 0x100fe200078e0206ULL,
0xfffffff8447d7812ULL, 0x000fe200078ee27dULL, 0x000000086c6c7824ULL, 0x000fe200078e00ffULL,
0xfffffff84a517812ULL, 0x000fe200078ee251ULL, 0x0000000172717824ULL, 0x140fe200078e0206ULL,
0x0000000372727819ULL, 0x000fe200000006ffULL, 0x000000017a467824ULL, 0x100fe200078e0206ULL,
0xfffffff86c4b7812ULL, 0x000fe200078ee24bULL, 0x000000087a7a7824ULL, 0x000fe200078e00ffULL,
0xfffffff872717812ULL, 0x000fe200078ee271ULL, 0x0000000160447824ULL, 0x000fc400078e0206ULL,
0x000000106d6d7824ULL, 0x000fe200078e020eULL, 0xfffffff87a467812ULL, 0x000fe200078ee246ULL,
0x0000000860607824ULL, 0x000fe400078e00ffULL, 0x0000001053537824ULL, 0x100fe200078e020eULL,
0x00000000426d7faeULL, 0x0003e2000b901c46ULL, 0x0000001045457824ULL, 0x000fe200078e020eULL,
0xfffffff860447812ULL, 0x000fe200078ee244ULL, 0x0000001051517824ULL, 0x100fe200078e020eULL,
0x0000000040497faeULL, 0x0003e2000b901c46ULL, 0x000000107b7b7824ULL, 0x000fc400078e020eULL,
0x000000104b4b7824ULL, 0x100fe200078e020eULL, 0x000000003e537faeULL, 0x0003e2000b901c46ULL,
0x000000107d7d7824ULL, 0x100fe400078e020eULL, 0x0000001071717824ULL, 0x100fe200078e020eULL,
0x000000003c457faeULL, 0x0003e2000b901c46ULL, 0x0000001046467824ULL, 0x100fe400078e020eULL,
0x0000001044447824ULL, 0x000fe200078e020eULL, 0x00000000326f7faeULL, 0x0003e8000b901c46ULL,
0x0000000030517faeULL, 0x0003e8000b901c46ULL, 0x000000002e7b7faeULL, 0x0003e8000b901c46ULL,
0x000000002c4b7faeULL, 0x0003e8000b901c46ULL, 0x000000002a7d7faeULL, 0x0003e8000b901c46ULL,
0x0000000028717faeULL, 0x0003e8000b901c46ULL, 0x000000000a467faeULL, 0x0003e8000b901c46ULL,
0x000000001c447faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000100c0e7824ULL, 0x000fe200078e00ffULL, 0x000000080f0b7810ULL, 0x002fc40007ffe0ffULL,
0x000030000d0a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff00e0b7812ULL, 0x000fe400078ee20bULL,
0x0000000a0f0d7810ULL, 0x000fe20007ffe0ffULL, 0x00000010581c7824ULL, 0x100fe200078e020aULL,
0x000000040b0b7819ULL, 0x000fe200000006ffULL, 0x000000105f2c7824ULL, 0x100fe200078e020aULL,
0xfffffff00e0d7812ULL, 0x000fe200078ee20dULL, 0x000000105b407824ULL, 0x100fe400078e020aULL,
0x000000105d3c7824ULL, 0x000fc400078e020aULL, 0x000000100d0d7824ULL, 0x000fe400078e00ffULL,
0x000000105c447824ULL, 0x100fe400078e020aULL, 0x000000105e487824ULL, 0x100fe400078e020aULL,
0x0000001062627824ULL, 0x000fe200078e020aULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001c1c783bULL, 0x000fe80000000200ULL, 0x000000000b30783bULL, 0x0002a80000000200ULL,
0x000000002c2c783bULL, 0x000fe80000000200ULL, 0x000000000d28783bULL, 0x000fe20000000200ULL,
0x0000000c0f0b7810ULL, 0x002fc40007ffe0ffULL, 0x0000000e0f0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000004040783bULL, 0x000e620000000200ULL, 0xfffffff00e0b7812ULL, 0x000fc600078ee20bULL,
0x000000003c3c783bULL, 0x000ee20000000200ULL, 0x000000040b0b7819ULL, 0x000fc600000006ffULL,
0x000000004444783bULL, 0x000f280000000200ULL, 0x000000004848783bULL, 0x000fe20000000200ULL,
0x0000001c3038723cULL, 0x044b6e0000001838ULL, 0x00000010611c7824ULL, 0x120fe200078e020aULL,
0x0000001e304c723cULL, 0x040b6a000000184cULL, 0x000000001c1c783bULL, 0x020ea60000000200ULL,
0x000000403018723cULL, 0x002b6e0000001818ULL, 0x0000001063407824ULL, 0x120fe200078e020aULL,
0x0000002c2838723cULL, 0x040bee0000001838ULL, 0x00000010642c7824ULL, 0x120fe200078e020aULL,
0x0000002e284c723cULL, 0x000bea000000184cULL, 0x000000002c2c783bULL, 0x020e660000000200ULL,
0x0000003c3024723cULL, 0x048f700000001824ULL, 0x000000443010723cULL, 0x050bee0000001810ULL,
0x0000001056447824ULL, 0x120fe200078e020aULL, 0x000000463014723cULL, 0x040bea0000001814ULL,
0x000000004444783bULL, 0x020fe60000000200ULL, 0x000000423020723cULL, 0x040be40000001820ULL,
0x000000004040783bULL, 0x020fec0000000200ULL, 0x0000003e3034723cULL, 0x000b640000001834ULL,
0x000000000b3c783bULL, 0x020fea0000000200ULL, 0x000000105a307824ULL, 0x100fe200078e020aULL,
0x0000001c2818723cULL, 0x044b6a0000001818ULL, 0x000000003030783bULL, 0x000ea40000000200ULL,
0x000000100c1c7824ULL, 0x020fe200078e00ffULL, 0x0000002c2824723cULL, 0x002be20000001824ULL,
0x00000010660c7824ULL, 0x000fc600078e020aULL, 0xfffffff01c1c7812ULL, 0x000fc600078ee20fULL,
0x00000010652c7824ULL, 0x020fe200078e020aULL, 0x0000002e2834723cULL, 0x000be20000001834ULL,
0x000000000c0c783bULL, 0x000e620000000200ULL, 0x000000101c1c7824ULL, 0x000fc600078e00ffULL,
0x000000002c2c783bULL, 0x020ee60000000200ULL, 0x0000001e2820723cULL, 0x040b640000001820ULL,
0x000000001c1c783bULL, 0x020fec0000000200ULL, 0x000000482810723cULL, 0x040b6e0000001810ULL,
0x0000001069487824ULL, 0x120fe200078e020aULL, 0x0000004a2814723cULL, 0x000b640000001814ULL,
0x000000006228783bULL, 0x020fe80000000200ULL, 0x000000004848783bULL, 0x000fe40000000200ULL,
0x000000303c38723cULL, 0x044bee0000001838ULL, 0x0000001067307824ULL, 0x020fe200078e020aULL,
0x000000323c4c723cULL, 0x040bea000000184cULL, 0x000000003030783bULL, 0x020ea60000000200ULL,
0x0000000c3c18723cULL, 0x042f700000001818ULL, 0x0000000e3c20723cULL, 0x040f700000001820ULL,
0x0000002c3c24723cULL, 0x048f700000001824ULL, 0x000000403c10723cULL, 0x040ff00000001810ULL,
0x000000423c14723cULL, 0x040ff00000001814ULL, 0x0000002e3c34723cULL, 0x000ff00000001834ULL,
0x000000301c18723cULL, 0x064f700000001818ULL, 0x000000321c20723cULL, 0x040f700000001820ULL,
0x000000481c24723cULL, 0x040f700000001824ULL, 0x000000281c38723cULL, 0x000f640000001838ULL,
0x3db504f3192d7820ULL, 0x020fc40000410000ULL, 0x3db504f318187820ULL, 0x000fe40000410000ULL,
0x3db504f31a0d7820ULL, 0x000fe40000410000ULL, 0x3db504f31b0e7820ULL, 0x000fe20000410000ULL,
0x0000002a1c4c723cULL, 0x000f62000000184cULL, 0x3db504f3202e7820ULL, 0x000fe40000410000ULL,
0x3db504f321327820ULL, 0x000fe40000410000ULL, 0x3db504f3220f7820ULL, 0x000fc40000410000ULL,
0x3db504f323197820ULL, 0x000fe20000410000ULL, 0x000000441c10723cULL, 0x000f620000001810ULL,
0x3db504f324317820ULL, 0x000fe40000410000ULL, 0x3db504f3252f7820ULL, 0x000fca0000410000ULL,
0x000000461c14723cULL, 0x040f620000001814ULL, 0x3db504f338387820ULL, 0x000fe40000410000ULL,
0x3db504f339297820ULL, 0x000fe40000410000ULL, 0x3db504f33a3a7820ULL, 0x000fe40000410000ULL,
0x3db504f33b3b7820ULL, 0x000fe20000410000ULL, 0x0000004a1c34723cULL, 0x000b640000001834ULL,
0x3db504f34c2a7820ULL, 0x020fc40000410000ULL, 0x3db504f34d337820ULL, 0x000fe40000410000ULL,
0x3db504f34e4e7820ULL, 0x000fe40000410000ULL, 0x3db504f3271e7820ULL, 0x000fe40000410000ULL,
0x3db504f34f4f7820ULL, 0x000fe40000410000ULL, 0x3db504f310307820ULL, 0x000fe40000410000ULL,
0x3db504f3112b7820ULL, 0x000fc40000410000ULL, 0x3db504f312127820ULL, 0x000fe40000410000ULL,
0x3db504f313137820ULL, 0x000fe40000410000ULL, 0x3db504f3142c7820ULL, 0x000fe40000410000ULL,
0x3db504f315157820ULL, 0x000fe40000410000ULL, 0x3db504f316167820ULL, 0x000fe40000410000ULL,
0x3db504f3170c7820ULL, 0x000fc40000410000ULL, 0x3db504f3261d7820ULL, 0x000fe40000410000ULL,
0x3db504f334277820ULL, 0x000fe40000410000ULL, 0x3db504f335287820ULL, 0x000fe40000410000ULL,
0x3db504f3361f7820ULL, 0x000fe40000410000ULL, 0x3db504f337207820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000750a7f8cULL, 0x0002a2000c80043fULL,
0x000000ffff357224ULL, 0x000fe200078e0018ULL, 0x0000001600257202ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fe200078e0015ULL, 0x0000003800177202ULL, 0x000fe20000000f00ULL,
0x000000ffff227224ULL, 0x000fc400078e003aULL, 0x000000ffff1a7224ULL, 0x000fe400078e003bULL,
0x000000ffff1b7224ULL, 0x000fe400078e004eULL, 0x000000ffff347224ULL, 0x000fe400078e004fULL,
0x000000ffff247224ULL, 0x000fe400078e0012ULL, 0x000000ffff237224ULL, 0x000fe400078e0013ULL,
0x000000ffff367224ULL, 0x000fc400078e000cULL, 0x000000ffff267224ULL, 0x000fe400078e000dULL,
0x000000ffff167224ULL, 0x000fe400078e000eULL, 0x000000ffff187224ULL, 0x000fc400078e000fULL,
0x00000000000c7805ULL, 0x002fca0000015200ULL, 0x00000400750f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x006fe4000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c117210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000110e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000110107810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400750f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000406217824ULL, 0x000fe200078e00ffULL,
0x000000730300720cULL, 0x000fc80003f06070ULL, 0xfffffff0210b7812ULL, 0x000fc800078ec0ffULL,
0x0000000b021c7211ULL, 0x000fca00078e38ffULL, 0x01b400001c0c7984ULL, 0x0002a20000000c00ULL,
0x000014e000008947ULL, 0x000fea0003800000ULL, 0x00005a0000117b06ULL, 0x000ee20000209000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x0000000968387217ULL, 0x000fe40007800000ULL,
0x00005a00ff007a0cULL, 0x000fc60003f85070ULL, 0x0000000138387824ULL, 0x000fe200078e0a09ULL,
0x0000001100117308ULL, 0x008ee40000001000ULL, 0x0ffffffe11127810ULL, 0x008fcc0007ffe0ffULL,
0x00000012000b7305ULL, 0x000ee4000021f000ULL, 0x000000ffff037224ULL, 0x008fc800078e0a0bULL,
0x00005a0003037a24ULL, 0x000fc800078e02ffULL, 0x000000030b147227ULL, 0x000fe200078e000aULL,
0x0000007406037211ULL, 0x000fca00078ff0ffULL, 0x00000003140a7227ULL, 0x000fc800078e00ffULL,
0x000000ffff107224ULL, 0x000fc800078e0a0aULL, 0x00005a00100b7a24ULL, 0x000fe200078e0203ULL,
0x0000000803037810ULL, 0x000fc80007ffe0ffULL, 0x00005a000b007a0cULL, 0x000fe20003f06070ULL,
0x0000000314137227ULL, 0x000fe200078e00ffULL, 0x00005a00ff147a12ULL, 0x000fc600078e33ffULL,
0x000000ffff107224ULL, 0x000fc800078e0a13ULL, 0x00005a0010117a24ULL, 0x000fe400078e0203ULL,
0x0000000206037824ULL, 0x000fe400078e00ffULL, 0x80005a000b0b0a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0011007a0cULL, 0x000fe40003f46070ULL, 0x00005a000b007a0cULL, 0x000fe40003f26070ULL,
0x0000000603037812ULL, 0x000fc400078ec0ffULL, 0x000000010a0a0810ULL, 0x000fc60007ffe0ffULL,
0x0000000108097824ULL, 0x000fc800078e0203ULL, 0x0000000109107824ULL, 0x000fe200078e0a38ULL,
0x80005a0011112a10ULL, 0x000fe40007ffe0ffULL, 0x000000010a0a1810ULL, 0x000fe40007ffe0ffULL,
0x00005a0011007a0cULL, 0x000fe40003f06070ULL, 0x0000000a140a7207ULL, 0x000fe40006000000ULL,
0x00000010070b7217ULL, 0x000fe40003800000ULL, 0x000000380900720cULL, 0x000fc40003f66070ULL,
0x0000000003097210ULL, 0x000fe40007ffe0ffULL, 0x0000000a070a7217ULL, 0x000fe40003800000ULL,
0x00000004ff0b7819ULL, 0x000fe2000001160bULL, 0x0000000109107824ULL, 0x000fe200078e0a38ULL,
0x0000000113132810ULL, 0x000fe20007ffe0ffULL, 0x0000000a6b4f7224ULL, 0x000fe200078e02ffULL,
0x000000ff0b127207ULL, 0x000fe40001800000ULL, 0x000000380900720cULL, 0x000fc40003f26070ULL,
0x0000001007107217ULL, 0x000fe20003800000ULL, 0x000000014f0b7824ULL, 0x000fe200078e0212ULL,
0x0000000113130810ULL, 0x000fe40007ffe0ffULL, 0x000000ff10467207ULL, 0x000fe20000800000ULL,
0x000000020b0a7825ULL, 0x000fe200078e0054ULL, 0x0000001314147207ULL, 0x000fe40006000000ULL,
0x00000010033b7812ULL, 0x000fe400078efcffULL, 0x0000004f46117211ULL, 0x000fe200078fe0ffULL,
0x000000060a4c7981ULL, 0x000722000c1e9500ULL, 0x0000001407147217ULL, 0x000fc60003800000ULL,
0x0000000211107825ULL, 0x000fc800078e0054ULL, 0x00000001080b7824ULL, 0x008fe200078e023bULL,
0x00000006104d7981ULL, 0x000722000c1e9500ULL, 0x000000146b517224ULL, 0x000fe400078e02ffULL,
0x000000010b0a7824ULL, 0x000fe400078e0a38ULL, 0x0000000112137824ULL, 0x000fe200078e0251ULL,
0x00000020033d7812ULL, 0x000fe200078efcffULL, 0x000000013b397824ULL, 0x000fe200078e0200ULL,
0x0000000a07107217ULL, 0x008fe20003800000ULL, 0x0000000213127825ULL, 0x000fe200078e0054ULL,
0x000000380b00720cULL, 0x000fc40003f26070ULL, 0x00000004ff107819ULL, 0x000fe20000011610ULL,
0x00000001390a7824ULL, 0x140fe200078e0a38ULL, 0x0000000612487981ULL, 0x0046a2000c1e9500ULL,
0x0000000108457824ULL, 0x000fe200078e023dULL, 0x0000005146157211ULL, 0x000fe400078fe0ffULL,
0x000000383900720cULL, 0x000fe20003f06070ULL, 0x0000000145407824ULL, 0x000fe200078e0a38ULL,
0x0000000a070a7217ULL, 0x000fe40003800000ULL, 0x000000ff10127207ULL, 0x008fe20000800000ULL,
0x0000000215147825ULL, 0x000fe200078e0054ULL, 0x000000ff0a3a7207ULL, 0x000fc60000000000ULL,
0x000000014f0b7824ULL, 0x000fe200078e0212ULL, 0x0000004007407217ULL, 0x000fe20003800000ULL,
0x00000006145b7981ULL, 0x0006a4000c1e9500ULL, 0x000000020b0a7825ULL, 0x000fe200078e0054ULL,
0x000000384500720cULL, 0x000fe40003f26070ULL, 0x00000004ff407819ULL, 0x000fe20000011640ULL,
0x000000013d417824ULL, 0x000fe200078e0200ULL, 0x000000060a3c7981ULL, 0x0002a2000c1e9500ULL,
0x0000003003457812ULL, 0x000fc400078efcffULL, 0x000000ff40447207ULL, 0x000fe40000800000ULL,
0x0000004f3a117211ULL, 0x000fe200078fe0ffULL, 0x00000001410a7824ULL, 0x002fe200078e0a38ULL,
0x0000005112137210ULL, 0x080fe40007ffe0ffULL, 0x000000513a157211ULL, 0x008fe200078fe0ffULL,
0x000000014f0b7824ULL, 0x000fe200078e0244ULL, 0x000000384100720cULL, 0x000fe40003f06070ULL,
0x0000000a070a7217ULL, 0x000fe20003800000ULL, 0x0000000108537824ULL, 0x000fc400078e0245ULL,
0x0000000211107825ULL, 0x000fe200078e0054ULL, 0x000000ff0a407207ULL, 0x000fc60000000000ULL,
0x0000000213127825ULL, 0x100fe200078e0054ULL, 0x0000000045497210ULL, 0x000fe20007ffe0ffULL,
0x00000006103f7981ULL, 0x0002e4000c1e9500ULL, 0x0000000215147825ULL, 0x100fe400078e0054ULL,
0x00000006123e7981ULL, 0x0002e4000c1e9500ULL, 0x000000020b0a7825ULL, 0x000fe400078e0054ULL,
0x0000000614437981ULL, 0x0002e4000c1e9500ULL, 0x00000001534a7824ULL, 0x000fc400078e0a38ULL,
0x000000060a427981ULL, 0x0002e4000c1e9500ULL, 0x0000004f40117211ULL, 0x002fe400078fe0ffULL,
0x0000004a074a7217ULL, 0x000fe20003800000ULL, 0x0000000144137824ULL, 0x000fe200078e0251ULL,
0x0000005140157211ULL, 0x000fe200078fe0ffULL, 0x00000001490a7824ULL, 0x000fe200078e0a38ULL,
0x000000385300720cULL, 0x080fe40003f26070ULL, 0x00000004ff4a7819ULL, 0x000fe2000001164aULL,
0x0000000211107825ULL, 0x000fe200078e0054ULL, 0x000000384900720cULL, 0x000fc40003f06070ULL,
0x0000000a070a7217ULL, 0x000fe20003800000ULL, 0x0000000213127825ULL, 0x100fe200078e0054ULL,
0x000000ff4a4e7207ULL, 0x000fe20000800000ULL, 0x0000000610477981ULL, 0x0002e4000c1e9500ULL,
0x0000000215147825ULL, 0x000fe200078e0054ULL, 0x000000ff0a4a7207ULL, 0x000fe20000000000ULL,
0x0000000612447981ULL, 0x0002e8000c1e9500ULL, 0x00000006144b7981ULL, 0x0002e2000c1e9500ULL,
0x000000014f0b7824ULL, 0x000fe200078e024eULL, 0x0000004f4a117211ULL, 0x002fc600078fe0ffULL,
0x000000020b0a7825ULL, 0x000fc800078e0054ULL, 0x0000000211107825ULL, 0x000fe400078e0054ULL,
0x000000060a0a7981ULL, 0x0002e2000c1e9500ULL, 0x000000514a137211ULL, 0x000fc600078fe0ffULL,
0x0000000610117981ULL, 0x0002e2000c1e9500ULL, 0x000000014e157824ULL, 0x000fe400078e0251ULL,
0x0000000213127825ULL, 0x000fc800078e0054ULL, 0x0000000215147825ULL, 0x000fe400078e0054ULL,
0x0000000612127981ULL, 0x0002e8000c1e9500ULL, 0x0000000614157981ULL, 0x0002e2000c1e9500ULL,
0xfffffff046517812ULL, 0x000fe200078ec0ffULL, 0x00000001ff467424ULL, 0x000fc800078e00ffULL,
0x00000001384e7824ULL, 0x000fc800078e0251ULL, 0x00000001095d7824ULL, 0x000fe200078e0a4eULL,
0x00000001034f7812ULL, 0x040fe400078efcffULL, 0x00000009030b7812ULL, 0x002fe400078efcffULL,
0x0000005d465d7219ULL, 0x000fe200000006ffULL, 0x000000014f537824ULL, 0x000fe200078e0200ULL,
0x000000000b137210ULL, 0x000fc60007ffe0ffULL, 0x00000001535f7824ULL, 0x100fe400078e0a4eULL,
0x0000000113637824ULL, 0x000fc600078e0a4eULL, 0x0000005f465f7219ULL, 0x040fe400000006ffULL,
0x0000006346637219ULL, 0x000fe400000006ffULL, 0x0000001803717812ULL, 0x000fca00078efcffULL,
0x0000000171107824ULL, 0x000fe200078e0200ULL, 0x00000011037b7812ULL, 0x040fe400078efcffULL,
0x00000019036f7812ULL, 0x000fc600078efcffULL, 0x000000017b147824ULL, 0x100fe400078e0200ULL,
0x000000016f7d7824ULL, 0x000fe200078e0200ULL, 0x0000002103657812ULL, 0x000fe400078efcffULL,
0xfffffff04a4a7812ULL, 0x000fc600078ec0ffULL, 0x00000001656d7824ULL, 0x000fe400078e0200ULL,
0x0000000138667824ULL, 0x000fc800078e024aULL, 0x0000000149587824ULL, 0x000fca00078e0a66ULL,
0x0000005846587219ULL, 0x000fe400000006ffULL, 0x000054104d4c7816ULL, 0x010fe4000000004cULL,
0x00000008034d7812ULL, 0x000fe400078efcffULL, 0x0000004c5dff7212ULL, 0x000fc6000780c0ffULL,
0x000000014d517824ULL, 0x000fe200078e0200ULL, 0x000000380900720cULL, 0x000fc60000701470ULL,
0x0000000151617824ULL, 0x000fe200078e0a4eULL, 0x000000380300720cULL, 0x000fc800007a1070ULL,
0x0000006146617219ULL, 0x000fe400000006ffULL, 0xff80000017177808ULL, 0x000fe40002800000ULL,
0x000054105b487816ULL, 0x004fc80000000048ULL, 0x000000485dff7212ULL, 0x080fe4000784c0ffULL,
0x000000485fff7212ULL, 0x080fe4000780c0ffULL, 0x0000004861ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004863ff7212ULL, 0x000fe400078ac0ffULL, 0xfffffff03a487812ULL, 0x000fca00078ec0ffULL,
0x0000000138487824ULL, 0x000fe200078e0248ULL, 0x000000380900720cULL, 0x080fe40001741470ULL,
0x000000385100720cULL, 0x080fe200037c1470ULL, 0x00000001394e7824ULL, 0x100fe200078e0a48ULL,
0x000000381300720cULL, 0x000fe20002fa1470ULL, 0x00000001105a7824ULL, 0x000fe200078e0a48ULL,
0x0000004c5fff7212ULL, 0x080fe4000782c0ffULL, 0x0000004c61ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004c63ff7212ULL, 0x000fc4000788c0ffULL, 0xfffffff0404c7812ULL, 0x000fe400078ec0ffULL,
0x000000380300720cULL, 0x080fe40001741070ULL, 0x000000384d00720cULL, 0x080fe400037c1070ULL,
0x000000380b00720cULL, 0x000fe40002fa1070ULL, 0x0000004e464e7219ULL, 0x040fe400000006ffULL,
0x0000005a465a7219ULL, 0x000fc400000006ffULL, 0x000054103f3f7816ULL, 0x008fe4000000003cULL,
0x0000541043437816ULL, 0x000fe2000000003eULL, 0x00000001384c7824ULL, 0x000fe200078e024cULL,
0xff80000022227808ULL, 0x000fe40001000000ULL, 0xff8000001b1b7808ULL, 0x000fe40003000000ULL,
0xff80000034347808ULL, 0x000fe40002800000ULL, 0x0000003f4eff7212ULL, 0x000fc4000784c0ffULL,
0x000000434eff7212ULL, 0x080fe400078cc0ffULL, 0x000000435aff7212ULL, 0x000fe200078ac0ffULL,
0x0000000114567824ULL, 0x000fe200078e0a48ULL, 0x000000385300720cULL, 0x080fe20000f21470ULL,
0x0000000141607824ULL, 0x000fe200078e0a4cULL, 0x000000385300720cULL, 0x080fe40000701470ULL,
0x000000385100720cULL, 0x080fe40001f61470ULL, 0x000000381300720cULL, 0x000fc40002781470ULL,
0x000000383900720cULL, 0x0c0fe40001741470ULL, 0x000000383900720cULL, 0x080fe400037c1470ULL,
0x000000381000720cULL, 0x000fe40002fa1470ULL, 0x0000007d48627210ULL, 0x000fe40007ffe1ffULL,
0x0000002803637812ULL, 0x040fe400078efcffULL, 0x0000002903617812ULL, 0x000fc400078efcffULL,
0x000000384f00720cULL, 0x0c0fe40000f21070ULL, 0x000000384f00720cULL, 0x080fe40000701070ULL,
0x000000384d00720cULL, 0x080fe40001f61070ULL, 0x000000380b00720cULL, 0x080fe40002781070ULL,
0x000000383b00720cULL, 0x0c0fe40001741070ULL, 0x000000383b00720cULL, 0x000fc400037c1070ULL,
0x000000387100720cULL, 0x000fe40002fa1070ULL, 0x0000005646567219ULL, 0x040fe400000006ffULL,
0x0000006246627219ULL, 0x040fe400000006ffULL, 0x0000006046607219ULL, 0x000fe400000006ffULL,
0x0000541047477816ULL, 0x000fe40000000042ULL, 0x000054104b4b7816ULL, 0x000fe20000000044ULL,
0x0000000163697824ULL, 0x000fe200078e0200ULL, 0x0000000061677210ULL, 0x000fc40007ffe0ffULL,
0xff80000029297808ULL, 0x000fe40000800000ULL, 0xff8000001a1a7808ULL, 0x000fe40000000000ULL,
0xff8000002a2a7808ULL, 0x000fe40001800000ULL, 0xff80000033337808ULL, 0x000fe40002000000ULL,
0xff80000030307808ULL, 0x000fe40001000000ULL, 0xff80000024247808ULL, 0x000fc40003000000ULL,
0xff80000025257808ULL, 0x000fe40002800000ULL, 0x0000003f56ff7212ULL, 0x080fe4000782c0ffULL,
0x0000003f5aff7212ULL, 0x080fe4000780c0ffULL, 0x0000003f62ff7212ULL, 0x000fe4000786c0ffULL,
0x0000004356ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004362ff7212ULL, 0x000fc4000784c0ffULL,
0x0000004760ff7212ULL, 0x040fe400078cc0ffULL, 0x0000004b60ff7212ULL, 0x000fe200078ac0ffULL,
0x000000016d647824ULL, 0x100fe200078e0a4cULL, 0x000000381400720cULL, 0x0c0fe20000f21470ULL,
0x00000001695c7824ULL, 0x100fe200078e0a4cULL, 0x000000381400720cULL, 0x080fe20002781470ULL,
0x00000001675e7824ULL, 0x000fe200078e0a4cULL, 0x000000381000720cULL, 0x080fe40000701470ULL,
0x000000387d00720cULL, 0x000fc40001f61470ULL, 0x000000387d00720cULL, 0x080fe40001741470ULL,
0x000000384100720cULL, 0x0c0fe400037c1470ULL, 0x000000384100720cULL, 0x000fe40002fa1470ULL,
0x00000031035f7812ULL, 0x040fe400078efcffULL, 0x00000038035d7812ULL, 0x040fe400078efcffULL,
0x00000039035b7812ULL, 0x000fc400078efcffULL, 0x000000387b00720cULL, 0x0c0fe40000f21070ULL,
0x000000387b00720cULL, 0x080fe40002781070ULL, 0x000000387100720cULL, 0x080fe40000701070ULL,
0x000000386f00720cULL, 0x0c0fe40001f61070ULL, 0x000000386f00720cULL, 0x080fe40001741070ULL,
0x000000383d00720cULL, 0x000fc400037c1070ULL, 0x000000383d00720cULL, 0x000fe40002fa1070ULL,
0x0000006446647219ULL, 0x040fe400000006ffULL, 0x0000005c465c7219ULL, 0x040fe400000006ffULL,
0x0000005e465e7219ULL, 0x000fe400000006ffULL, 0x0000541011117816ULL, 0x000fe2000000000aULL,
0x000000015f3a7824ULL, 0x100fe200078e0200ULL, 0xff8000002b2b7808ULL, 0x000fe20000800000ULL,
0x000000015d407824ULL, 0x100fe200078e0200ULL, 0xff80000023237808ULL, 0x000fe20002000000ULL,
0x000000015b487824ULL, 0x000fe200078e0200ULL, 0xff8000002c2c7808ULL, 0x000fc40000000000ULL,
0xff80000037377808ULL, 0x000fe40001800000ULL, 0xff80000036367808ULL, 0x000fe40001000000ULL,
0xff80000035357808ULL, 0x000fe40003000000ULL, 0xff80000026267808ULL, 0x000fe40002800000ULL,
0x0000004764ff7212ULL, 0x080fe4000782c0ffULL, 0x000000475cff7212ULL, 0x000fc4000788c0ffULL,
0x000000475eff7212ULL, 0x000fe4000780c0ffULL, 0x0000004b64ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004b5cff7212ULL, 0x080fe4000784c0ffULL, 0x0000004b5eff7212ULL, 0x000fe400078cc0ffULL,
0x0000001158ff7212ULL, 0x000fe200078ac0ffULL, 0x000000013a527824ULL, 0x100fe200078e0a66ULL,
0x000000386d00720cULL, 0x0c0fe20000f21470ULL, 0x00000001404a7824ULL, 0x000fe200078e0a66ULL,
0x000000386d00720cULL, 0x000fc40001f61470ULL, 0x000000386900720cULL, 0x0c0fe40002781470ULL,
0x000000386900720cULL, 0x080fe40001741470ULL, 0x000000386700720cULL, 0x0c0fe40000701470ULL,
0x000000386700720cULL, 0x080fe400037c1470ULL, 0x000000384900720cULL, 0x000fe40002fa1470ULL,
0x00000048664c7210ULL, 0x000fc40007ffe1ffULL, 0x000000386500720cULL, 0x0c0fe40000f21070ULL,
0x000000386500720cULL, 0x080fe40001f61070ULL, 0x000000386300720cULL, 0x0c0fe40002781070ULL,
0x000000386300720cULL, 0x080fe40001741070ULL, 0x000000386100720cULL, 0x0c0fe40000701070ULL,
0x000000386100720cULL, 0x000fc400037c1070ULL, 0x000000384500720cULL, 0x000fe40002fa1070ULL,
0x0000005246527219ULL, 0x040fe400000006ffULL, 0x0000004a464a7219ULL, 0x040fe400000006ffULL,
0x0000004c464c7219ULL, 0x000fe400000006ffULL, 0x0000541012157816ULL, 0x000fe40000000015ULL,
0xff8000002d2d7808ULL, 0x000fc40000800000ULL, 0xff80000016167808ULL, 0x000fe40001800000ULL,
0xff8000002e2e7808ULL, 0x000fe40002000000ULL, 0xff80000018187808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fe40000000000ULL, 0xff80000019197808ULL, 0x000fe40003000000ULL,
0xff80000031317808ULL, 0x000fc40002800000ULL, 0x0000001152ff7212ULL, 0x080fe4000782c0ffULL,
0x000000114aff7212ULL, 0x080fe4000786c0ffULL, 0x000000114cff7212ULL, 0x000fe4000788c0ffULL,
0x0000001558ff7212ULL, 0x080fe4000784c0ffULL, 0x0000001552ff7212ULL, 0x080fe4000780c0ffULL,
0x000000154aff7212ULL, 0x000fc400078cc0ffULL, 0x000000154cff7212ULL, 0x000fe400078ac0ffULL,
0x000000384900720cULL, 0x080fe40001741470ULL, 0x000000383a00720cULL, 0x0c0fe40000f21470ULL,
0x000000383a00720cULL, 0x080fe40000701470ULL, 0x000000384000720cULL, 0x0c0fe40001f61470ULL,
0x000000384000720cULL, 0x000fc400037c1470ULL, 0x000000384800720cULL, 0x0c0fe40002781470ULL,
0x000000384800720cULL, 0x080fe40002fa1470ULL, 0x000000384500720cULL, 0x080fe40001741070ULL,
0x000000385f00720cULL, 0x0c0fe40000f21070ULL, 0x000000385f00720cULL, 0x080fe40000701070ULL,
0x000000385d00720cULL, 0x000fc40001f61070ULL, 0x000000385d00720cULL, 0x080fe400037c1070ULL,
0x000000385b00720cULL, 0x0c0fe40002781070ULL, 0x000000385b00720cULL, 0x000fe40002fa1070ULL,
0xff8000002f2f7808ULL, 0x000fe40000800000ULL, 0xff80000027277808ULL, 0x000fe40001800000ULL,
0xff80000028287808ULL, 0x000fc40002000000ULL, 0xff8000001d1d7808ULL, 0x000fe40001000000ULL,
0xff8000001e1e7808ULL, 0x000fe40000000000ULL, 0xff8000001f1f7808ULL, 0x000fe40003000000ULL,
0xff80000020207808ULL, 0x000fc40002800000ULL, 0x000000170c00720bULL, 0x004fe40003f1e000ULL,
0x000000220d00720bULL, 0x000fe40003f3e000ULL, 0x0000000c170c7208ULL, 0x000fc40004000000ULL,
0x0000000d220d7208ULL, 0x000fe40004800000ULL, 0x000000290c00720bULL, 0x000fe40003f1e000ULL,
0x0000001a0d00720bULL, 0x000fe40003f3e000ULL, 0x0000000c29037208ULL, 0x000fe40004000000ULL,
0x0000000d1a0a7208ULL, 0x000fe40004800000ULL, 0x0000002a0300720bULL, 0x000fc40003f1e000ULL,
0x0000001b0a00720bULL, 0x000fe40003f3e000ULL, 0x000000032a0c7208ULL, 0x000fe40004000000ULL,
0x0000000a1b037208ULL, 0x000fe40004800000ULL, 0x000000330c00720bULL, 0x000fe40003f1e000ULL,
0x000000340300720bULL, 0x000fe40003f3e000ULL, 0x0000000c33097208ULL, 0x000fc40004000000ULL,
0x0000000334037208ULL, 0x000fe40004800000ULL, 0x000000300900720bULL, 0x000fe40003f1e000ULL,
0x000000240300720bULL, 0x000fe40003f3e000ULL, 0x00000009300a7208ULL, 0x000fe40004000000ULL,
0x00000003240c7208ULL, 0x000fe40004800000ULL, 0x0000002b0a00720bULL, 0x000fc40003f1e000ULL,
0x000000230c00720bULL, 0x000fe40003f3e000ULL, 0x0000000a2b037208ULL, 0x000fe40004000000ULL,
0x0000000c230c7208ULL, 0x000fe40004800000ULL, 0x0000002c0300720bULL, 0x000fe40003f1e000ULL,
0x000000250c00720bULL, 0x000fe40003f3e000ULL, 0x000000032c0a7208ULL, 0x000fc40004000000ULL,
0x0000000c25037208ULL, 0x000fe40004800000ULL, 0x000000370a00720bULL, 0x000fe40003f1e000ULL,
0x000000360300720bULL, 0x000fe40003f3e000ULL, 0x0000000a370a7208ULL, 0x000fe40004000000ULL,
0x0000000336037208ULL, 0x000fe40004800000ULL, 0x000000350a00720bULL, 0x000fc40003f1e000ULL,
0x000000260300720bULL, 0x000fe40003f3e000ULL, 0x0000000a350a7208ULL, 0x000fe40004000000ULL,
0x0000000326037208ULL, 0x000fe40004800000ULL, 0x0000002d0a00720bULL, 0x000fe40003f1e000ULL,
0x000000160300720bULL, 0x000fe40003f3e000ULL, 0x0000000a2d097208ULL, 0x000fc40004000000ULL,
0x0000000316037208ULL, 0x000fe40004800000ULL, 0x0000002e0900720bULL, 0x000fe40003f1e000ULL,
0x000000180300720bULL, 0x000fe40003f3e000ULL, 0x000000092e097208ULL, 0x000fe40004000000ULL,
0x00000003180a7208ULL, 0x000fe40004800000ULL, 0x000000320900720bULL, 0x000fc40003f1e000ULL,
0x000000190a00720bULL, 0x000fe40003f3e000ULL, 0x00000009320c7208ULL, 0x000fe40004000000ULL,
0x0000000a190a7208ULL, 0x000fe40004800000ULL, 0x000000310c00720bULL, 0x000fe40003f1e000ULL,
0x0000001d0a00720bULL, 0x000fe40003f3e000ULL, 0x0000000c310c7208ULL, 0x000fc40004000000ULL,
0x0000000a1d037208ULL, 0x000fe40004800000ULL, 0x0000002f0c00720bULL, 0x000fe40003f1e000ULL,
0x0000001e0300720bULL, 0x000fe40003f3e000ULL, 0x0000000c2f0c7208ULL, 0x000fe40004000000ULL,
0x000000031e0a7208ULL, 0x000fe40004800000ULL, 0x000000270c00720bULL, 0x000fc40003f1e000ULL,
0x0000001f0a00720bULL, 0x000fe40003f3e000ULL, 0x0000000c27037208ULL, 0x000fe40004000000ULL,
0x0000000a1f097208ULL, 0x000fe40004800000ULL, 0x000000280300720bULL, 0x000fe40003f1e000ULL,
0x000000200900720bULL, 0x000fe40003f3e000ULL, 0x0000000328107208ULL, 0x000fc40004000000ULL,
0x0000000920147208ULL, 0x000fe20004800000ULL, 0x000016a27f007947ULL, 0x000fec000b800000ULL,
0x0c401f0010037f89ULL, 0x0004e400000e0000ULL, 0x000000031000720bULL, 0x008fc80003f1e000ULL,
0x0000001003137208ULL, 0x000fe20004000000ULL, 0x000016d27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0014037f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e0b7f89ULL, 0x000f2800000e0000ULL,
0x0c401f000f0a7f89ULL, 0x000e6800000e0000ULL, 0x0c201f00130c7f89ULL, 0x000ea200000e0000ULL,
0x000000031400720bULL, 0x008fc40003f1e000ULL, 0x0000000b0e00720bULL, 0x010fe40003f3e000ULL,
0x0000001403097208ULL, 0x000fe40004000000ULL, 0x0000000e0b0b7208ULL, 0x000fe40004800000ULL,
0x0000000a0f00720bULL, 0x002fe20003f1e000ULL, 0x0c201f0009107f89ULL, 0x004e6600000e0000ULL,
0x0000000f0a037208ULL, 0x000fe20004000000ULL, 0x0c201f000b127f89ULL, 0x000ea200000e0000ULL,
0x0000000c1300720bULL, 0x000fc60003f1e000ULL, 0x0c201f00030a7f89ULL, 0x0006e200000e0000ULL,
0x000000130c0c7208ULL, 0x000fe40004000000ULL, 0x000000100900720bULL, 0x002fe40003f3e000ULL,
0x000000120b00720bULL, 0x004fe40003f5e000ULL, 0x00000009100d7208ULL, 0x000fe40004800000ULL,
0x0000000b120e7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b0c107820ULL, 0x00afe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000306ff7812ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b270f7823ULL, 0x100fe20000010810ULL, 0x0000000a0300720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b0d277820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b17177823ULL, 0x100fe40000010810ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010810ULL, 0x0000000f000f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b22227823ULL, 0x000fe40000010827ULL, 0x3fb8aa3b2a2a7823ULL, 0x000fc40000010810ULL,
0x3fb8aa3b33337823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010827ULL,
0x0000001700177308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b34347823ULL, 0x100fe40000010827ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe40000010827ULL, 0x3fb8aa3b30307823ULL, 0x100fe40000010810ULL,
0x3fb8aa3b2c097823ULL, 0x000fe20000010810ULL, 0x0000002900127308ULL, 0x0002a20000000800ULL,
0x3fb8aa3b23237823ULL, 0x000fc40000010827ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe40000010810ULL,
0x3fb8aa3b37377823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b350b7823ULL, 0x100fe20000010810ULL,
0x0000002a00117308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b2e297823ULL, 0x102fe40000010810ULL,
0x3fb8aa3b2d2c7823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b282e7823ULL, 0x000fc40000010810ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010827ULL, 0x0000003300147308ULL, 0x000e620000000800ULL,
0x3fb8aa3b2f2a7823ULL, 0x008fe40000010810ULL, 0x3fb8aa3b25257823ULL, 0x100fe40000010827ULL,
0x3fb8aa3b36367823ULL, 0x100fe40000010827ULL, 0x3fb8aa3b162f7823ULL, 0x100fe20000010827ULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b26267823ULL, 0x000fc40000010827ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe40000010827ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe40000010827ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010827ULL, 0x0000001a00137308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b20207823ULL, 0x000fce0000010827ULL, 0x0000001b001b7308ULL, 0x000ff00000000800ULL,
0x0000003400347308ULL, 0x000f300000000800ULL, 0x0000003000387308ULL, 0x0003f00000000800ULL,
0x0000000900397308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b32307823ULL, 0x002fc40000010810ULL,
0x3fb8aa3b19327823ULL, 0x000fca0000010827ULL, 0x00000023002d7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b31097823ULL, 0x004fe20000010810ULL, 0x000000171210723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b18317823ULL, 0x000fe20000010827ULL, 0x000000111412723eULL, 0x000fe400000000ffULL,
0x000000221311723eULL, 0x008fe200000000ffULL, 0x3c003c00ff227424ULL, 0x000fe200078e00ffULL,
0x0000001b3413723eULL, 0x010fe200000000ffULL, 0x3c003c00ff237424ULL, 0x002fe200078e00ffULL,
0x0000002b002b7308ULL, 0x000e6c0000000800ULL, 0x000000221014723cULL, 0x000f6400000018ffULL,
0x00000037003a7308ULL, 0x000eb00000000800ULL, 0x0000002400247308ULL, 0x000ee20000000800ULL,
0x000000382b18723eULL, 0x002fc400000000ffULL, 0x00000002ff2b7819ULL, 0x000fc80000011606ULL,
0x000000032b347819ULL, 0x040fe200000006ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x000000393a1a723eULL, 0x004fe200000000ffULL, 0x000000082b3a7824ULL, 0x040fe200078e00ffULL,
0x000000022b337810ULL, 0x040fe20007ffe0ffULL, 0x000000082b3c7824ULL, 0x000fc800078e00ffULL,
0x0000003600367308ULL, 0x000e620000000800ULL, 0x000000242d19723eULL, 0x008fe400000000ffULL,
0x000000012b2d7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff834347812ULL, 0x000fe200078ee22dULL,
0x0000002600287308ULL, 0x0005e20000000800ULL, 0x000000082b2d7810ULL, 0x000fca0007ffe0ffULL,
0x000000082d3e7824ULL, 0x000fe200078e00ffULL, 0x00000025361b723eULL, 0x002fe200000000ffULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x000000082b367824ULL, 0x000fe400078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fc600078ee22dULL, 0x000000221824723cULL, 0x024b620000001814ULL,
0xfffffff836367812ULL, 0x000fe200078ee233ULL, 0x0000002c002c7308ULL, 0x000e6a0000000800ULL,
0x000000082b177824ULL, 0x060fe200078e00ffULL, 0x000000032b147810ULL, 0x040fe40007ffe0ffULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x000000042b157810ULL, 0x000fc40007ffe0ffULL,
0xfffffff817387812ULL, 0x000fe400078ee214ULL, 0xfffffff83a3a7812ULL, 0x000fc600078ee215ULL,
0x0000003000307308ULL, 0x000ea20000000800ULL, 0x0000000b2c14723eULL, 0x002fe200000000ffULL,
0x000000082b2c7824ULL, 0x040fe200078e00ffULL, 0x000000052b0b7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee22bULL, 0x0000002f002f7308ULL, 0x000e700000000800ULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x000000293016723eULL, 0x004fe200000000ffULL,
0x000000082b307824ULL, 0x040fe200078e00ffULL, 0xffffffff2b297810ULL, 0x000fc80007ffe0ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee229ULL, 0x0000003200327308ULL, 0x000ea20000000800ULL,
0x000000282f15723eULL, 0x002fe200000000ffULL, 0x000000082b2f7824ULL, 0x040fe200078e00ffULL,
0x000000062b287810ULL, 0x000fe40007ffe0ffULL, 0xfffffff830307812ULL, 0x000fc600078ee20bULL,
0x0000000900097308ULL, 0x000fe20000000800ULL, 0x000000313217723eULL, 0x004fce00000000ffULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0xfffffff82f327812ULL, 0x000fe200078ee228ULL,
0x000000221424723cULL, 0x000f6c0000001824ULL, 0x0000002e002e7308ULL, 0x000eb00000000800ULL,
0x0000001d001d7308ULL, 0x000fe20000000800ULL, 0x000000092a28723eULL, 0x002fc400000000ffULL,
0x0001100002097811ULL, 0x000fc800078e58ffULL, 0x000000092c0b7211ULL, 0x000fe200078e20ffULL,
0x0000001e001e7308ULL, 0x000e620000000800ULL, 0x0000000f2e2a723eULL, 0x004fe200000000ffULL,
0x00000010340f7824ULL, 0x100fe200078e0209ULL, 0x0000000c212e7812ULL, 0x000fe200078ec0ffULL,
0x0000001032217824ULL, 0x100fe200078e0209ULL, 0x000000093e2d7211ULL, 0x000fe200078e20ffULL,
0x000000103c2c7824ULL, 0x000fe400078e0209ULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x000000012e0b7824ULL, 0x000fc400078e020bULL, 0x000000012e217824ULL, 0x040fe400078e0221ULL,
0x000000012e2c7824ULL, 0x000fe200078e022cULL, 0x000000100b007388ULL, 0x0005e40000000800ULL,
0x0000002000207308ULL, 0x000ee20000000800ULL, 0x0000001d1e29723eULL, 0x002fe200000000ffULL,
0x00000010361d7824ULL, 0x100fe400078e0209ULL, 0x00000010381e7824ULL, 0x000fe400078e0209ULL,
0x000000012e1d7824ULL, 0x000fc400078e021dULL, 0x000000012e1e7824ULL, 0x000fe200078e021eULL,
0x0000001f202b723eULL, 0x008fe200000000ffULL, 0x000000103a1f7824ULL, 0x100fe400078e0209ULL,
0x0000001030207824ULL, 0x000fe400078e0209ULL, 0x000000012e097824ULL, 0x000fe200078e020fULL,
0x000000030a0f7208ULL, 0x000fe20004800000ULL, 0x000000222824723cULL, 0x020b620000001824ULL,
0x000000012e1f7824ULL, 0x040fe400078e021fULL, 0x000000012e207824ULL, 0x040fe200078e0220ULL,
0x0000001209007388ULL, 0x0005e60000000800ULL, 0x000000012e227824ULL, 0x020fe200078e022dULL,
0x000000181d007388ULL, 0x0005e80000000800ULL, 0x0000001a1e007388ULL, 0x0005e80000000800ULL,
0x000000141f007388ULL, 0x0005e80000000800ULL, 0x0000001620007388ULL, 0x0005e80000000800ULL,
0x0000002821007388ULL, 0x0005e20000000800ULL, 0x0000002600257202ULL, 0x000fc60000000f00ULL,
0x0000002a2c007388ULL, 0x0005e80000000800ULL, 0x0000001122007388ULL, 0x0005e80000000800ULL,
0x0004001309007388ULL, 0x0005e80000000800ULL, 0x000400191d007388ULL, 0x0005e80000000800ULL,
0x0004001b1e007388ULL, 0x0005e80000000800ULL, 0x000400151f007388ULL, 0x0005e80000000800ULL,
0x0004001720007388ULL, 0x0005e80000000800ULL, 0x0004002921007388ULL, 0x0005e80000000800ULL,
0x0004002b2c007388ULL, 0x0005e80000000800ULL, 0x01b0000c1c008388ULL, 0x0005e80000000c00ULL,
0x01b200241c008388ULL, 0x0005e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6080076ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6100076ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6180076ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000595000720cULL, 0x000fe20003f06070ULL, 0x01b6200076ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff037224ULL, 0x000fd600078e0050ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff96e000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff0b7807ULL, 0x008fe40004000000ULL, 0xffffffff00117802ULL, 0x000fe40000000f00ULL,
0x00014de000107802ULL, 0x000fc40000000f00ULL, 0x00000f3000007944ULL, 0x012fea0003c00000ULL,
0xfffee02000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x000fe20005000000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x00014e3000107802ULL, 0x000fc40000000f00ULL,
0x00000ee000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000bULL,
0xfffee05000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e000aULL,
0x00014ea000117802ULL, 0x000fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fe400078e00ffULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x00000e2000007944ULL, 0x012fea0003c00000ULL,
0xfffee11000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e000aULL,
0x0000001f00137802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x000fe200078e00ffULL,
0x00014f0000117802ULL, 0x000fc40000000f00ULL, 0x00000dc000007944ULL, 0x012fea0003c00000ULL,
0xfffee21000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e000aULL,
0x00014f7000117802ULL, 0x000fe20000000f00ULL, 0x000000ffff0b7224ULL, 0x000fc400078e0009ULL,
0x0000001fff137424ULL, 0x000fe400078e00ffULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x00000d5000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e000bULL,
0xfffee3a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e000aULL,
0x00014fe000117802ULL, 0x000fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fe400078e00ffULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x00000ce000007944ULL, 0x016fea0003c00000ULL,
0x0000000b00007202ULL, 0x004fe20000000f00ULL, 0xfffee36000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x004fe20004000000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x0001504000107802ULL, 0x000fc40000000f00ULL, 0x00000cd000007944ULL, 0x018fea0003c00000ULL,
0xfffefae000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x000fe20004800000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x0001509000107802ULL, 0x000fc40000000f00ULL,
0x00000c8000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e000bULL,
0xfffefb2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e000dULL,
0xffffffff00127802ULL, 0x000fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x0001510000117802ULL, 0x000fc40000000f00ULL, 0x00000bc000007944ULL, 0x018fea0003c00000ULL,
0xfffefbf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e000dULL,
0x0001516000117802ULL, 0x000fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fc400078e00ffULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x00000b6000007944ULL, 0x01afea0003c00000ULL,
0xfffefcf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0007ULL,
0x000151d000117802ULL, 0x000fe20000000f00ULL, 0x000000ffff0b7224ULL, 0x000fe400078e000eULL,
0x0000001fff137424ULL, 0x000fe400078e00ffULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x00000af000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e000bULL,
0xfffefe8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0007ULL,
0x0000001f00137802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x000fe200078e00ffULL,
0x0001524000117802ULL, 0x000fc40000000f00ULL, 0x00000a8000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e000bULL, 0xfffefe4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x004fe20004000000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x000152a000107802ULL, 0x000fc40000000f00ULL, 0x00000a7000007944ULL, 0x018fea0003c00000ULL,
0xffff132000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x000fe20004800000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x000152f000107802ULL, 0x000fc40000000f00ULL,
0x00000a2000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff307224ULL, 0x000fe200078e000bULL,
0xffff135000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0035ULL,
0x0001536000117802ULL, 0x000fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fc400078e00ffULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x0000096000007944ULL, 0x018fea0003c00000ULL,
0xffff142000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0035ULL,
0x000153c000117802ULL, 0x000fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fe400078e00ffULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x0000090000007944ULL, 0x01afea0003c00000ULL,
0xffff152000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0030ULL,
0x0000001f00137802ULL, 0x000fe20000000f00ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0031ULL,
0x0001543000117802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x0000089000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e000bULL,
0xffff16b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0030ULL,
0x000154a000117802ULL, 0x000fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fc400078e00ffULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x0000082000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e000bULL, 0xffff167000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0b7807ULL, 0x004fe20004000000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x0001550000107802ULL, 0x000fc40000000f00ULL, 0x0000081000007944ULL, 0x018fea0003c00000ULL,
0xffff2bd000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x000fe20004800000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x0001555000107802ULL, 0x000fc40000000f00ULL,
0x000007c000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e000bULL,
0xffff2c0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e001fULL,
0x0000001f00137802ULL, 0x000fe20000000f00ULL, 0xffffffffff127424ULL, 0x000fe200078e00ffULL,
0x000155c000117802ULL, 0x000fc40000000f00ULL, 0x0000070000007944ULL, 0x018fea0003c00000ULL,
0xffff2cd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e001fULL,
0x0001562000117802ULL, 0x000fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fc400078e00ffULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x000006a000007944ULL, 0x01afea0003c00000ULL,
0xffff2dd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e001cULL,
0x0001569000117802ULL, 0x000fe20000000f00ULL, 0x000000ffff0b7224ULL, 0x000fe400078e001dULL,
0x0000001fff137424ULL, 0x000fe400078e00ffULL, 0xffffffffff127424ULL, 0x000fc400078e00ffULL,
0x0000063000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e000bULL,
0xffff2f6000007947ULL, 0x000fea000383ffffULL, 0x0000001c00107202ULL, 0x000fe20000000f00ULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x0001570000117802ULL, 0x000fe20000000f00ULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x000005c000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e000bULL, 0xffff2f2000007947ULL, 0x000fea000383ffffULL,
0x00000002ff117424ULL, 0x000fe200078e00ffULL, 0x00015770000a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff097424ULL, 0x000fc400078e00ffULL, 0xffffffffff387424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e0009ULL,
0xffffe90000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x006fe200078e0014ULL,
0x000157f0000a7802ULL, 0x000fe20000000f00ULL, 0x00000002ff117424ULL, 0x000fe400078e00ffULL,
0x0000001fff097424ULL, 0x000fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x000000091400720bULL, 0x004fe20003f1e000ULL,
0x00000002ff117424ULL, 0x002fe200078e00ffULL, 0x0000000e00107202ULL, 0x000fe20000000f00ULL,
0xffffffffff387424ULL, 0x000fe200078e00ffULL, 0x0000001409127208ULL, 0x000fe20004000000ULL,
0x0000001fff097424ULL, 0x000fe200078e00ffULL, 0x00015870000a7802ULL, 0x000fc40000000f00ULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x000000090e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e000fULL, 0x000158f0000a7802ULL, 0x000fe20000000f00ULL,
0x00000002ff117424ULL, 0x000fe200078e00ffULL, 0x0000000e090e7208ULL, 0x000fe20004000000ULL,
0x0000001fff097424ULL, 0x000fc400078e00ffULL, 0xffffffffff387424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x000000090f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e0013ULL, 0x0000000100117802ULL, 0x000fe20000000f00ULL,
0xffffffffff387424ULL, 0x000fe200078e00ffULL, 0x0000000f09037208ULL, 0x000fe20004000000ULL,
0x0000001fff097424ULL, 0x000fe200078e00ffULL, 0x00015970000a7802ULL, 0x000fc40000000f00ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000091300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e0012ULL, 0x000159f0000a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x00000013090c7208ULL, 0x000fe20004000000ULL,
0x0000001fff097424ULL, 0x000fc400078e00ffULL, 0xffffffffff387424ULL, 0x000fc400078e00ffULL,
0x0000029000007944ULL, 0x000fea0003c00000ULL, 0x000000091200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e000eULL, 0x00015a70000a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x00000012090d7208ULL, 0x000fe20004000000ULL,
0xffffffffff387424ULL, 0x000fe200078e00ffULL, 0x0000001f00097802ULL, 0x000fc40000000f00ULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000090e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e0003ULL, 0x00015af0000a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x0000000e090e7208ULL, 0x000fe20004000000ULL,
0x0000001fff097424ULL, 0x000fc400078e00ffULL, 0xffffffffff387424ULL, 0x000fc400078e00ffULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e0009ULL,
0xffffe6e000007947ULL, 0x000fea000383ffffULL, 0x0180000009047810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000004067812ULL, 0x000fc800078ec0ffULL,
0x018000000600780cULL, 0x000fda0003f05070ULL, 0x0000000900048308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0600720cULL, 0x040fe40003f25070ULL,
0x008000000600780cULL, 0x000fe40003f02070ULL, 0x00000001ff0b7807ULL, 0x000fe40000800000ULL,
0x00000001ff047807ULL, 0x004fc80004000000ULL, 0x000000040bff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff09ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000009067812ULL, 0x000fe400078ec0ffULL, 0x00000001ff047807ULL, 0x000fc80000000000ULL,
0x000000040bff7212ULL, 0x000fda000780c0ffULL, 0x0080000006040812ULL, 0x000fe200078efcffULL,
0x000000ffff048224ULL, 0x000fe200078e0006ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000900047308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff0d7424ULL, 0x000fc800078e00ffULL, 0xfffea3800c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000003800007348ULL, 0x000fe80003800000ULL,
0x0c00001110097389ULL, 0x0002a200000e0009ULL, 0xfffea3400a007950ULL, 0x000fea0003c3ffffULL,
0x0000001200007348ULL, 0x000fe80003800000ULL, 0x0000000b100b7389ULL, 0x0002a400000e0013ULL,
0x000000ffff107224ULL, 0x002fc400078e0011ULL, 0x00000000ff117424ULL, 0x000fc800078e00ffULL,
0xfffea2f010007950ULL, 0x000fea0003c3ffffULL, 0x000000010b00780cULL, 0x000fe20003f45070ULL,
0x0000001100007348ULL, 0x000fd80003800000ULL, 0x00000000000b7806ULL, 0x000fc800050e0100ULL,
0x000000110b0b7212ULL, 0x000fe200078ec0ffULL, 0x00000000ff117424ULL, 0x000fc800078e00ffULL,
0xfffea29010007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000050aULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000668ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008c0ULL,
0x0000000000000280ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b40ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c00ULL,
0x00000000000005d0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000011d0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000011e0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001270ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001274ULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001480ULL,
0x0000000000015e00ULL, 0x8000001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000017280ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x00000000000172c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000017640ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001270ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000016010ULL,
0x0000000000016010ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000017280ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000017640ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_16_sm_80_cubin_len = 96032;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
