/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000012cf8ULL, 0x0000000000012878ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x0000000000011780ULL, 0x0000000000000280ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000011a00ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001178000000000ULL, 0x0000540400000000ULL, 0x0400288080810c00ULL, 0x0000000000004580ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808292ULL, 0x0000001cffffffffULL, 0x0000006800000000ULL, 0x0001178000000000ULL,
0x0000028000000000ULL, 0x0000000000000000ULL, 0x0000000e00082f04ULL, 0x000812040000007fULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL,
0x0000000e00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL, 0x0000007c00043704ULL,
0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00801b0380005003ULL, 0x000086c000183104ULL, 0x00010bf000008c90ULL, 0x00010c1000010c00ULL,
0x00fc290400010c20ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0500000e05000009ULL, 0x050000090500000eULL, 0x0500000905000009ULL, 0x0500002b0500002bULL,
0x0500002b0500002bULL, 0x0500002b0500002bULL, 0x0500002b0500002bULL, 0x0500002b0500002bULL,
0x00fc28040500002bULL, 0x00000130000000c0ULL, 0x00002bd000001970ULL, 0x00002d0000002cb0ULL,
0x000032c000002d20ULL, 0x0000358000003300ULL, 0x0000413000004080ULL, 0x000041e0000041c0ULL,
0x0000453000004500ULL, 0x00005380000047e0ULL, 0x000054a000005440ULL, 0x00005880000054e0ULL,
0x00005ae000005890ULL, 0x0000654000006480ULL, 0x000065e0000065c0ULL, 0x00006900000068f0ULL,
0x00006c8000006c70ULL, 0x00008c90000086c0ULL, 0x0000916000009130ULL, 0x0000977000009750ULL,
0x0001052000010510ULL, 0x0001054000010530ULL, 0x0001059000010570ULL, 0x000105c0000105b0ULL,
0x00010c0000010be0ULL, 0x00010c5000010c10ULL, 0x00010c7000010c60ULL, 0x0001131000011280ULL,
0x000113d000011370ULL, 0x000114a000011440ULL, 0x0001156000011500ULL, 0x000116a000011600ULL,
0x01f0390400011740ULL, 0x000000ff000001a0ULL, 0x000501000001b600ULL, 0x0000000000000280ULL,
0x003f01000001b608ULL, 0x0000000000000390ULL, 0x003f01000001b688ULL, 0x000000ff00000640ULL,
0x000701070001b600ULL, 0x0000000500000840ULL, 0x000701010001b688ULL, 0x0000000c00002ab0ULL,
0x001301010001b608ULL, 0x0000000900002af0ULL, 0x001301090001b608ULL, 0x0000001000003530ULL,
0x000701010001b688ULL, 0x0000000c00003fd0ULL, 0x001301010001b628ULL, 0x0000001100004000ULL,
0x001301090001b628ULL, 0x0000001100004790ULL, 0x000701010001b690ULL, 0x0000000f000052c0ULL,
0x001301010001b648ULL, 0x0000001100005310ULL, 0x001301090001b648ULL, 0x0000001100005a80ULL,
0x000701010001b698ULL, 0x0000000300006400ULL, 0x001301010001b668ULL, 0x0000000700006430ULL,
0x001301090001b668ULL, 0x0000000300006a30ULL, 0x000701010001b6a0ULL, 0x000000ff0000a040ULL,
0x000701010001b600ULL, 0x000000ff0000bdd0ULL, 0x000701090001b600ULL, 0x000000ff0000fb90ULL,
0x001501010001b688ULL, 0x000000ff0000fbe0ULL, 0x001501090001b688ULL, 0x000000ff00010f80ULL,
0x001701010001b608ULL, 0x000000ff00010f90ULL, 0x001701010001b610ULL, 0x000000ff00010fa0ULL,
0x001701010001b618ULL, 0x000000ff00010fb0ULL, 0x001701010001b620ULL, 0x000000ff00010fe0ULL,
0x002401090001b608ULL, 0x000000ff00011040ULL, 0x002401090001b628ULL, 0x000000ff000110a0ULL,
0x002401090001b648ULL, 0x000000ff00011100ULL, 0x002401090001b668ULL, 0x000000ff00011160ULL,
0x000701090001b600ULL, 0x000000ff000111c0ULL, 0x001501090001b688ULL, 0x00141c0400033803ULL,
0x0000a00000009d90ULL, 0x0000bea00000be00ULL, 0x000c050400010fd0ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0058190300000000ULL, 0x0000000f00080a04ULL, 0x0004360400580210ULL,
0x0000000000000008ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL,
0x00000000fffffffcULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000000ULL, 0x00000000000000c4ULL,
0x0000000e00000002ULL, 0x0000000000011780ULL, 0x0000000000000044ULL, 0x0000000e00000002ULL,
0x0000000000000000ULL, 0x00000000000000a0ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000097919ULL, 0x000eae0000002100ULL,
0x00000000000579c3ULL, 0x000ee20000002500ULL, 0x000001b000007945ULL, 0x000fe20003800000ULL,
0x0000000000067919ULL, 0x000f220000002300ULL, 0x0000000000077919ULL, 0x000f2a0000002200ULL,
0x00008800ff027b82ULL, 0x000f620000000a00ULL, 0x00000000000b7919ULL, 0x000f6e0000000000ULL,
0x00000000000479c3ULL, 0x000f700000002700ULL, 0x00000000000a79c3ULL, 0x000f620000002600ULL,
0x00000005ff5b7e24ULL, 0x008fe2000f8e00ffULL, 0x00000005ff057819ULL, 0x004fcc0000011609ULL,
0x00001fff05057589ULL, 0x000ea200000e0000ULL, 0x0000000106007824ULL, 0x010fc800078e0207ULL,
0x0000008000047824ULL, 0x000fca00078e0209ULL, 0x000000ff0400720cULL, 0x040fe40003f05270ULL,
0x0000000f0400780cULL, 0x040fe40003f24070ULL, 0x000000030400780cULL, 0x000fe40003f44070ULL,
0x00000000051e72caULL, 0x004fe400000e0000ULL, 0x00001fff06057589ULL, 0x0004ea00000e0000ULL,
0x0000000000240947ULL, 0x022ff00003800000ULL, 0x00000000000679c3ULL, 0x000e620000008800ULL,
0x0000040000057882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065406057896ULL, 0x002fc60008000005ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e6e0000000000ULL,
0x01b60006053f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000679c3ULL, 0x000e620000008800ULL,
0x0000040000057882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x7ffe000000077882ULL, 0x000fe20000000000ULL, 0x0000065406057896ULL, 0x002fc60008000005ULL,
0x001fff8000067882ULL, 0x000fc60000000000ULL, 0x0000000504007c11ULL, 0x000fe2000f8e18ffULL,
0x0000000000007918ULL, 0x004fcc0000000000ULL, 0x00000000000512caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000f240000000000ULL, 0x01b60806053f75b2ULL, 0x0043300008000100ULL,
0xfffffffd00e81947ULL, 0x010fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00000000000679c3ULL, 0x002e620000008800ULL, 0x0000040000057882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x7ffb000000077882ULL, 0x000fe20000000000ULL,
0x0000065406057896ULL, 0x002fc60008000005ULL, 0x001ffec000067882ULL, 0x000fc60000000000ULL,
0x0000000504007c11ULL, 0x000fe2000f8e18ffULL, 0x0000000000007918ULL, 0x004fcc0000000000ULL,
0x00000000000512caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f240000000000ULL,
0x01b68806053f75b2ULL, 0x0043300008000100ULL, 0xfffffffd00e81947ULL, 0x010fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000879c3ULL, 0x000f220000008800ULL,
0x0000001e05007c11ULL, 0x008fe2000f8e10ffULL, 0x0000040000077882ULL, 0x002fe20000000000ULL,
0x0000007f0400780cULL, 0x000fe20003f04070ULL, 0x00008400000e7ab9ULL, 0x000fe20000000800ULL,
0x00000004ff067819ULL, 0x004fe2000001160bULL, 0x0000000200007824ULL, 0x000fe200078e00ffULL,
0x000000030a057899ULL, 0x000fe4000800063fULL, 0x000000030e067899ULL, 0x000fe2000800063fULL,
0x0000000100087824ULL, 0x040fe200078e0206ULL, 0x0000000800077848ULL, 0x000fe20007fe0000ULL,
0x0000820000187ab9ULL, 0x000fe20000000a00ULL, 0x00000004060572a4ULL, 0x000fc4000f8e0205ULL,
0x00000007080a7812ULL, 0x040fe200078ec0ffULL, 0x0000000107077824ULL, 0x000fe400078e0a00ULL,
0x000000100b007824ULL, 0x000fe400078e00ffULL, 0x0000000508097c36ULL, 0x000fe20008000000ULL,
0x000000070600720cULL, 0x000fe20003f26070ULL, 0xff317217ff078424ULL, 0x000fe200078e00ffULL,
0x000000f0000d7812ULL, 0x000fe200078ec0ffULL, 0x0000065408077896ULL, 0x010fe20008000007ULL,
0x0000010009027825ULL, 0x000fe200078e0002ULL, 0x0000000f0a097812ULL, 0x000fc400078e780bULL,
0x0001b60007057890ULL, 0x000fe4000fffe03fULL, 0x0000000704048c11ULL, 0x000fe2000f8e10ffULL,
0x0000001008097824ULL, 0x000fe200078e0209ULL, 0x0000000d02027210ULL, 0x000fc60007f5e0ffULL,
0x01b4000704008388ULL, 0x0003e20000000800ULL, 0x0000000709097c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff037224ULL, 0x000fe200010e0603ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e2000c901c58ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffffff79a7ULL, 0x000fe40008200405ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a85ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00008e0000087ab9ULL, 0x000fc40000000a00ULL, 0x00000004040878a5ULL, 0x000fcc000f8e0008ULL,
0x00000008ff027e24ULL, 0x002fe4000f8e00ffULL, 0x00000009ff037e24ULL, 0x000fca000f8e00ffULL,
0x0000001802027981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0500720cULL, 0x000fe20003f05270ULL,
0x00000300001f7ab9ULL, 0x000fe20000000800ULL, 0x00000000022372caULL, 0x004fda00000e0000ULL,
0x0000007f23057890ULL, 0x000fe4000fffe03fULL, 0x000000ff23087890ULL, 0x000fe4000fffe03fULL,
0x000000073f057899ULL, 0x000fe40008011605ULL, 0x000000083f087899ULL, 0x000fe20008011608ULL,
0x0000009800308947ULL, 0x000ff60003800000ULL, 0x000000005b0f72caULL, 0x000fe200000e0000ULL,
0x000000033f067899ULL, 0x000fe2000801161eULL, 0x00000004ff007424ULL, 0x000fc600078e00ffULL,
0x01ffffff06067892ULL, 0x000fd0000f8ec03fULL, 0x000000060f097291ULL, 0x000fc8000f8e083fULL,
0x000000050900728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x0000000104068899ULL, 0x000fe2000800063fULL, 0x00009000000b8ab9ULL, 0x000fe20000000800ULL,
0x00008c00000c8ab9ULL, 0x000fe40000000a00ULL, 0x0000000b060682a4ULL, 0x000fe4000f8e020bULL,
0x000000031e0b7899ULL, 0x000fe4000800063fULL, 0x0000000609068290ULL, 0x000fc8000fffe03fULL,
0x00000004060c88a5ULL, 0x000fe2000f8e000cULL, 0x0000000bff057e24ULL, 0x000fc8000f8e00ffULL,
0x01b6880005ff79a7ULL, 0x0003e20008500007ULL, 0x0000000cff027e24ULL, 0x000fe4000f8e00ffULL,
0x0000000dff037e24ULL, 0x000fca000f8e00ffULL, 0x0000001802028981ULL, 0x000ea2000c1e1900ULL,
0x000000013f067899ULL, 0x000fe2000801161eULL, 0x000000015b007836ULL, 0x002fe20000000000ULL,
0xffffffff00167882ULL, 0x000fe20000000000ULL, 0x000000070a0a7899ULL, 0x000fe4000800063fULL,
0x00000005060b7899ULL, 0x000fe4000800063fULL, 0x000000011e227892ULL, 0x000fe4000f8ec03fULL,
0x0000000b0f0c7291ULL, 0x000fc8000f8e403fULL, 0x000000600a107892ULL, 0x000fe2000f8ef80cULL,
0x00000000020d82caULL, 0x004fe400000e0000ULL, 0x0000000800007c0cULL, 0x000fd6000bf06070ULL,
0x0000000d00168c82ULL, 0x000fe40008000000ULL, 0x0000000e160b72a4ULL, 0x000fc8000f8e023fULL,
0x000000070b0d7899ULL, 0x000fe2000800063fULL, 0x0000000400dc8947ULL, 0x000ff60003800000ULL,
0x00000003ff0a7819ULL, 0x000fe2000001160bULL, 0x0000000c2300728cULL, 0x000fe4000bf01070ULL,
0x8000000cff007e24ULL, 0x000fe2000f8e02ffULL, 0x00008a00000e7ab9ULL, 0x000fe20000000a00ULL,
0x000000040a047836ULL, 0x040fe20000000000ULL, 0x0000000c230b7287ULL, 0x000fe2000c000000ULL,
0x000000080a067836ULL, 0x000fe20000000000ULL, 0x00000003220c7899ULL, 0x000fe2000800063fULL,
0x0000000804057824ULL, 0x040fe200078e00ffULL, 0x0000000b04027212ULL, 0x000fe200078e3cffULL,
0x0000000806097824ULL, 0x000fc400078e00ffULL, 0x000000100a117836ULL, 0x000fe20000000000ULL,
0xfffffff805147812ULL, 0x000fe200078ee202ULL, 0x0000000bff037e24ULL, 0x000fe2000f8e00ffULL,
0x0000000b06027212ULL, 0x080fe200078e3cffULL, 0x000000140a137836ULL, 0x040fe20000000000ULL,
0x0000000b11057212ULL, 0x0c0fe200078e3cffULL, 0x0000000c0a077836ULL, 0x040fe20000000000ULL,
0xfffffff809167812ULL, 0x000fe200078ee202ULL, 0x00000008111a7824ULL, 0x000fe200078e00ffULL,
0x0000002003007446ULL, 0x000fe20003800000ULL, 0x000000100a027c36ULL, 0x040fe20008000000ULL,
0x0000000b13087212ULL, 0x0c0fe200078e3cffULL, 0x00000008130d7824ULL, 0x000fe200078e00ffULL,
0x0000000b07037212ULL, 0x0c0fe200078e3cffULL, 0x0000000807187824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee205ULL, 0x000000180a197836ULL, 0x040fe20000000000ULL,
0x0000000d02097c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001c0a1b7836ULL, 0x000fe20000000000ULL,
0xfffffff80d1c7812ULL, 0x000fe200078ee208ULL, 0x0000001004057c36ULL, 0x000fe20008000000ULL,
0xfffffff818187812ULL, 0x000fe200078ee203ULL, 0x00000008190e7824ULL, 0x040fe200078e00ffULL,
0x0000000b19037212ULL, 0x080fe200078e3cffULL, 0x000000081b0d7824ULL, 0x040fe200078e00ffULL,
0x0000000b1b087212ULL, 0x000fe200078e3cffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x0000000e09027c11ULL, 0x000fe2000f8040ffULL, 0x00000007060b7291ULL, 0x000fe2000f8e703fULL,
0x0000000d05057c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000cff207e24ULL, 0x000fe2000f8e00ffULL,
0x000000000600720cULL, 0x0c0fe20003f26070ULL, 0x0000001006067c36ULL, 0x000fe20008000000ULL,
0xfffffff80e1d7812ULL, 0x000fe200078ee203ULL, 0x0000000b220b7291ULL, 0x000fe2000f8e683fULL,
0xfffffff80d1e7812ULL, 0x000fe200078ee208ULL, 0x0000001007087c36ULL, 0x000fe20008000000ULL,
0x0000000f09037c11ULL, 0x000fe200080f440cULL, 0x000000ffff0c7224ULL, 0x000fe200010e06ffULL,
0x000000000700720cULL, 0x080fe20003f46070ULL, 0x0000001011097c36ULL, 0x000fe20008000000ULL,
0x000000000400720cULL, 0x000fe20003f06070ULL, 0x000130000b0b7890ULL, 0x000fe2000fffe03fULL,
0x0000000d06077c10ULL, 0x000fc4000ff9e0ffULL, 0x0000000e05047c11ULL, 0x040fe4000f8640ffULL,
0x0000000d080e7c10ULL, 0x000fe2000ffbe0ffULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x0000000f05057c11ULL, 0x000fe200098f440cULL, 0x00000010130c7c36ULL, 0x000fe20008000000ULL,
0x0000000e07067c11ULL, 0x040fe2000f8640ffULL, 0x000000ffff0f7224ULL, 0x000fe200028e06ffULL,
0x0000000e0e087c11ULL, 0x000fe4000f8840ffULL, 0x0000000f07077c11ULL, 0x000fc400098f4410ULL,
0x0000000d090d7c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000f0e097c11ULL, 0x000fe4000a0f440fULL,
0x0000000d0c0f7c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0x0000000e0d0c7c11ULL, 0x000fe4000f8640ffULL, 0x000000000a00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff107224ULL, 0x000fe200020e06ffULL, 0x0000000e0f0e7c11ULL, 0x000fc4000f8840ffULL,
0x000000070a0a7812ULL, 0x000fe400078e480bULL, 0x0000000f0f0f7c11ULL, 0x000fe2000a0f4410ULL,
0x0000001019107c36ULL, 0x000fe20008000000ULL, 0x0000000f0d0d7c11ULL, 0x000fe200098f4412ULL,
0x000000101b127c36ULL, 0x000fe20008000000ULL, 0x0ffffff80a0a7812ULL, 0x000fe400078ef80bULL,
0x0000000d101f7c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000b0a177c11ULL, 0x000fc4000f8e20ffULL,
0x0000000d120a7c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0xfffffff820157812ULL, 0x000fe400078ee20bULL, 0x0000000e1f107c11ULL, 0x000fe4000f8c40ffULL,
0x000000001100720cULL, 0x080fe20003f66070ULL, 0x0000001015027825ULL, 0x000fe200078e0002ULL,
0x0000000f1f117c11ULL, 0x000fe4000b0f4412ULL, 0x000000001300720cULL, 0x080fe20003fc6070ULL,
0x000000ffff1f7224ULL, 0x000fe200020e06ffULL, 0x0000000e0a127c11ULL, 0x040fe2000f8840ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002177faeULL, 0x0003e2000e901c58ULL,
0x000000001900720cULL, 0x000fe20003fa6070ULL, 0x0000001015047825ULL, 0x000fe200078e0004ULL,
0x0000000f0a137c11ULL, 0x000fc4000a0f441fULL, 0x000000001b00720cULL, 0x000fe20003f86070ULL,
0x0000001015067825ULL, 0x040fe200078e0006ULL, 0x0000000b14197c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b161b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001015087825ULL, 0x000fe200078e0008ULL,
0x0000000b1d1d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000004197faeULL, 0x0005e2000c101c58ULL,
0x0000000b1c177c11ULL, 0x002fe2000f8e20ffULL, 0x0000001015027825ULL, 0x040fe200078e000eULL,
0x0000000b1e1f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000061b7faeULL, 0x0005e4000c901c58ULL,
0x00000010150e7825ULL, 0x000fc800078e0010ULL, 0x0000001015107825ULL, 0x000fe200078e0012ULL,
0x0000000b18137c11ULL, 0x000fc6000f8e20ffULL, 0x00000010150c7825ULL, 0x000fe200078e000cULL,
0x0000000b1a157c11ULL, 0x000fe2000f8e20ffULL, 0x0000000008137faeULL, 0x0005e8000d101c58ULL,
0x000000000c157faeULL, 0x0005e8000d901c58ULL, 0x0000000002177faeULL, 0x0005e8000f101c58ULL,
0x000000000e1d7faeULL, 0x0005e8000e901c58ULL, 0x00000000101f7faeULL, 0x0005e2000e101c58ULL,
0x0000000400a47947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe2000001160bULL,
0x00008a00000e7ab9ULL, 0x000fe20000000a00ULL, 0x00000007060b7291ULL, 0x000fe4000f8e703fULL,
0x00000003220c7899ULL, 0x000fe2000800063fULL, 0x0000000400067836ULL, 0x040fe20000000000ULL,
0x0000000b220b7291ULL, 0x000fe2000f8e683fULL, 0x0000000800087836ULL, 0x000fe40000000000ULL,
0x0000000806057824ULL, 0x040fe200078e00ffULL, 0x0000000b06027212ULL, 0x080fe200078e3cffULL,
0x0000000808147824ULL, 0x040fe200078e00ffULL, 0x0000000b08037212ULL, 0x080fe200078e3cffULL,
0x0000000c000c7836ULL, 0x040fe20000000000ULL, 0xfffffff8050a7812ULL, 0x000fe200078ee202ULL,
0x00000010000e7836ULL, 0x000fe20000000000ULL, 0xfffffff814147812ULL, 0x000fe200078ee203ULL,
0x000000080c057824ULL, 0x040fe200078e00ffULL, 0x0000000b0c027212ULL, 0x080fe200078e3cffULL,
0x000000080e187824ULL, 0x040fe200078e00ffULL, 0x0000000b0e037212ULL, 0x080fe200078e3cffULL,
0x0000001400107836ULL, 0x040fe20000000000ULL, 0xfffffff805167812ULL, 0x000fe200078ee202ULL,
0x0000001800127836ULL, 0x000fe20000000000ULL, 0xfffffff818187812ULL, 0x000fe200078ee203ULL,
0x00000008101c7824ULL, 0x040fe200078e00ffULL, 0x0000000b10037212ULL, 0x080fe200078e3cffULL,
0x0000001000027c36ULL, 0x000fe20008000000ULL, 0x0000000b12047212ULL, 0x0c0fe200078e3cffULL,
0x00000008121d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee203ULL,
0x0000001c001a7836ULL, 0x000fe20000000000ULL, 0x0000000d02037c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001008087c36ULL, 0x000fe20008000000ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee204ULL,
0x000000081a1e7824ULL, 0x040fe200078e00ffULL, 0x0000000b1a057212ULL, 0x000fe200078e3cffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x0000000e03027c11ULL, 0x040fe2000f8040ffULL,
0x0000001006067c36ULL, 0x000fe20008000000ULL, 0xfffffff81e1f7812ULL, 0x000fe200078ee205ULL,
0x000000100c097c36ULL, 0x000fe20008000000ULL, 0x0000000f03037c11ULL, 0x000fe200080f4404ULL,
0x000130000b0b7890ULL, 0x000fe2000fffe03fULL, 0x0000000d08077c10ULL, 0x000fe2000ff3e0ffULL,
0x000000100e0e7c36ULL, 0x000fe20008000000ULL, 0x0000000d06057c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001010107c36ULL, 0x000fe20008000000ULL, 0x0000000d09097c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x0000000e07067c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000e05047c11ULL, 0x000fe2000f8040ffULL,
0x0000001012127c36ULL, 0x000fe20008000000ULL, 0x0000000700007812ULL, 0x000fe200078e480bULL,
0x000000101a1a7c36ULL, 0x000fe20008000000ULL, 0x0000000f07077c11ULL, 0x000fe200088f440cULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x0000000f05057c11ULL, 0x000fe200080f4408ULL,
0x0000000cff1e7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000e09087c11ULL, 0x000fc4000f8040ffULL,
0x0ffffff800007812ULL, 0x000fe400078ef80bULL, 0x0000000f09097c11ULL, 0x000fe400080f440cULL,
0x0000000b00177c11ULL, 0x000fe4000f8e20ffULL, 0x0000000d0e007c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000d100f7c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000d12117c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x0000000d1a137c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0xfffffff81e157812ULL, 0x000fe200078ee20bULL,
0x000000ffff1e7224ULL, 0x000fe200010e06ffULL, 0x0000000e000c7c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff207224ULL, 0x000fe200018e06ffULL, 0x0000000e0f0e7c11ULL, 0x000fe2000f8240ffULL,
0x0000001015027825ULL, 0x000fe200078e0002ULL, 0x0000000e11107c11ULL, 0x000fc4000f8440ffULL,
0x0000000e13127c11ULL, 0x000fe2000f8640ffULL, 0x0000001015047825ULL, 0x000fe200078e0004ULL,
0x0000000f000d7c11ULL, 0x000fe200080f440dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002177faeULL, 0x0003e2000b901c58ULL, 0x0000000f0f0f7c11ULL, 0x000fe200088f441aULL,
0x0000001015067825ULL, 0x000fe200078e0006ULL, 0x0000000f11117c11ULL, 0x000fe400090f441eULL,
0x0000000f13137c11ULL, 0x000fe200098f4420ULL, 0x0000001015087825ULL, 0x000fe200078e0008ULL,
0x0000000b0a197c11ULL, 0x000fc4000f8e20ffULL, 0x0000000b141b7c11ULL, 0x000fe2000f8e20ffULL,
0x00000010150c7825ULL, 0x000fe200078e000cULL, 0x0000000b1d1d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000004197faeULL, 0x0005e2000b901c58ULL, 0x0000000b16037c11ULL, 0x002fe2000f8e20ffULL,
0x00000010150e7825ULL, 0x000fe200078e000eULL, 0x0000000b1c177c11ULL, 0x000fe2000f8e20ffULL,
0x00000000061b7faeULL, 0x0005e2000b901c58ULL, 0x0000000b1f1f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001015107825ULL, 0x040fe400078e0010ULL, 0x0000000008037faeULL, 0x0005e4000b901c58ULL,
0x0000001015127825ULL, 0x000fe200078e0012ULL, 0x0000000b18157c11ULL, 0x000fca000f8e20ffULL,
0x000000000c157faeULL, 0x0005e8000b901c58ULL, 0x000000000e177faeULL, 0x0005e8000b901c58ULL,
0x00000000101d7faeULL, 0x0005e8000b901c58ULL, 0x00000000121f7faeULL, 0x0005e4000b901c58ULL,
0x000000085b007c0cULL, 0x000fe2000bf06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff5a7424ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff597224ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fc4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000005000a40947ULL, 0x000fec0003800000ULL, 0x00000001040b7899ULL, 0x000fe2000800063fULL,
0xff317217ff5a7424ULL, 0x000fe400078e00ffULL, 0x0000900000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff277224ULL, 0x000fe200078e00ffULL, 0x000000040b0b72a4ULL, 0x000fc6000f8e0204ULL,
0x0000003f00047c82ULL, 0x000fd20008000000ULL, 0x000001005b007824ULL, 0x000fca00078e00ffULL,
0x0000002300007c0cULL, 0x000fda000bf06070ULL, 0x0000005000740947ULL, 0x000fea0003800000ULL,
0x000000005b0d72caULL, 0x040fe200000e0000ULL, 0x000000015b007836ULL, 0x000fe20000000000ULL,
0x000000041e0c7899ULL, 0x000fe2000800063fULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0xffffffe00c0f7892ULL, 0x000fe2000f8ec03fULL, 0x0000000800007c0cULL, 0x000fe2000bf06070ULL,
0x00000009000e7c82ULL, 0x000fe20008000000ULL, 0x00008400000c7ab9ULL, 0x000fc80000000800ULL,
0x0000000f0d0f7291ULL, 0x000fe4000f8e403fULL, 0x0000000c161672a4ULL, 0x000fe4000f8e023fULL,
0x000000400f117890ULL, 0x000fe4000fffe03fULL, 0x0000000716137899ULL, 0x000fe4000800063fULL,
0x000000600a147892ULL, 0x000fe2000f8ef811ULL, 0x00000004000d7c82ULL, 0x000fe20008000000ULL,
0x0000000400f48947ULL, 0x000ff40003800000ULL, 0x00000003ff007819ULL, 0x000fe2000001160bULL,
0x000000112300728cULL, 0x000fe4000bf01070ULL, 0x80000011ff097e24ULL, 0x004fe2000f8e02ffULL,
0x00008a0000207ab9ULL, 0x000fe20000000a00ULL, 0x0000000d1e167899ULL, 0x000fe2000800063fULL,
0x0000000400027836ULL, 0x040fe20000000000ULL, 0x0000001123107287ULL, 0x000fe2000c000000ULL,
0x0000001400067836ULL, 0x000fe20000000000ULL, 0x0000000c04127899ULL, 0x000fe2000800063fULL,
0x0000000802057824ULL, 0x040fe200078e00ffULL, 0x0000000b026a7212ULL, 0x080fe200078e3cffULL,
0x00000008060d7824ULL, 0x040fe200078e00ffULL, 0x0000000b06667212ULL, 0x000fe200078e3cffULL,
0x00000010ff047e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff8056a7812ULL, 0x000fe200078ee26aULL,
0x0000001000057836ULL, 0x040fe20000000000ULL, 0xfffffff80d667812ULL, 0x000fe200078ee266ULL,
0x0000000800037836ULL, 0x000fe20000000000ULL, 0x0000002004097446ULL, 0x000fe20003800009ULL,
0x00000008050a7824ULL, 0x040fe200078e00ffULL, 0x0000000b05677212ULL, 0x080fe200078e3cffULL,
0x0000000c00047836ULL, 0x000fe20000000000ULL, 0x0000000b03697212ULL, 0x0c0fe200078e3cffULL,
0x0000000803087824ULL, 0x000fe200078e00ffULL, 0xfffffff80a677812ULL, 0x000fe200078ee267ULL,
0x0000000804077824ULL, 0x040fe200078e00ffULL, 0x0000000b04687212ULL, 0x080fe200078e3cffULL,
0x00000014000a7c36ULL, 0x040fe20008000000ULL, 0xfffffff808697812ULL, 0x000fe200078ee269ULL,
0x0000001c00087836ULL, 0x040fe20000000000ULL, 0xfffffff807687812ULL, 0x000fe200078ee268ULL,
0x0000001800077836ULL, 0x000fe20000000000ULL, 0x000000130a0c7c10ULL, 0x000fe2000ff3e0ffULL,
0x00000008080f7824ULL, 0x040fe200078e00ffULL, 0x0000000b08647212ULL, 0x080fe200078e3cffULL,
0x00000008070a7824ULL, 0x040fe200078e00ffULL, 0x0000000b07657212ULL, 0x080fe200078e3cffULL,
0x000000ffff0d7224ULL, 0x000fe200008e06ffULL, 0x000000200c147c11ULL, 0x000fe2000f8240ffULL,
0x0000000322157899ULL, 0x000fe2000800063fULL, 0xfffffff80a657812ULL, 0x000fe200078ee265ULL,
0x00000014020a7c36ULL, 0x000fe20008000000ULL, 0x000000210c157c11ULL, 0x000fe200088f440dULL,
0x00000014030c7c36ULL, 0x000fe20008000000ULL, 0xfffffff80f647812ULL, 0x000fe200078ee264ULL,
0x00000014040d7c36ULL, 0x000fe20008000000ULL, 0x000000130a107c10ULL, 0x000fe2000ff3e0ffULL,
0x00000014050a7c36ULL, 0x000fe20008000000ULL, 0x000000130c0e7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000706107291ULL, 0x000fe2000f8e703fULL, 0x000000130d0c7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e06ffULL, 0x0000002010187c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x000000200e167c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e06ffULL, 0x000000130a0d7c10ULL, 0x000fe2000ff9e0ffULL,
0x00000014060a7c36ULL, 0x000fe20008000000ULL, 0x000000200c127c11ULL, 0x000fe2000f8640ffULL,
0x0000200016117892ULL, 0x000fe2000f8ec03fULL, 0x0000002110197c11ULL, 0x000fe200088f4413ULL,
0x0000100012127892ULL, 0x000fe2000f8e0c3fULL, 0x000000210e177c11ULL, 0x000fe200090f4411ULL,
0x000000ffff0e7224ULL, 0x000fe200020e06ffULL, 0x000000210c137c11ULL, 0x000fe200098f440fULL,
0x00000015ff1b7e24ULL, 0x000fe2000f8e00ffULL, 0x000000200d0c7c11ULL, 0x000fe2000f8240ffULL,
0x0000001012127290ULL, 0x000fe2000fffe011ULL, 0x0000000b001a7212ULL, 0x000fc400078e3cffULL,
0x000000210d0d7c11ULL, 0x000fe200088f440eULL, 0x0001300012127890ULL, 0x000fe2000fffe03fULL,
0x000000130a0e7c10ULL, 0x000fe4000ff3e0ffULL, 0x000000070b0a7812ULL, 0x000fe400078ec0ffULL,
0x000000071a1c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e06ffULL,
0x000000200e107c11ULL, 0x000fe2000f8240ffULL, 0x00000014081a7c36ULL, 0x000fe20008000000ULL,
0x000000090200720cULL, 0x000fc40003f46070ULL, 0x000000210e117c11ULL, 0x000fe200088f440fULL,
0x00000014070e7c36ULL, 0x000fe20008000000ULL, 0x000000090000720cULL, 0x080fe40003f26070ULL,
0x000000090300720cULL, 0x000fe40003f66070ULL, 0x000000130e0f7c10ULL, 0x000fe4000ff9e0ffULL,
0x000000081b587812ULL, 0x000fe400078ee20aULL, 0x0ffffff81c6b7812ULL, 0x000fe200078ef80bULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x000000200f0e7c11ULL, 0x000fe2000f8840ffULL,
0x0000001058147825ULL, 0x000fe200078e0014ULL, 0x000000126b1d7c11ULL, 0x000fc4000f8e20ffULL,
0x000000126a1f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001058187825ULL, 0x040fe200078e0018ULL,
0x0000001269217c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x000fe2000c901c58ULL, 0x000000210f0f7c11ULL, 0x000fe2000a0f441cULL,
0x0000001058167825ULL, 0x000fe200078e0016ULL, 0x000000131a1b7c10ULL, 0x000fe2000ff9e0ffULL,
0x00000000181f7faeULL, 0x0003e2000d101c58ULL, 0x000000090400720cULL, 0x080fe20003f26070ULL,
0x0000001058127825ULL, 0x000fe200078e0012ULL, 0x000000090500720cULL, 0x080fe20003f46070ULL,
0x0000000016217faeULL, 0x0005e2000d901c58ULL, 0x000000090600720cULL, 0x080fe20003f66070ULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x000000201b1a7c11ULL, 0x000fe2000f8c40ffULL,
0x00000010580c7825ULL, 0x000fe200078e000cULL, 0x000000090700720cULL, 0x000fc40003f86070ULL,
0x000000090800720cULL, 0x000fe20003fa6070ULL, 0x0000001058107825ULL, 0x000fe200078e0010ULL,
0x000000211b1b7c11ULL, 0x000fe4000b0f441cULL, 0x0000001268097c11ULL, 0x000fe2000f8e20ffULL,
0x00000010580e7825ULL, 0x000fe200078e000eULL, 0x0000001267197c11ULL, 0x002fe4000f8e20ffULL,
0x0000001266177c11ULL, 0x004fe2000f8e20ffULL, 0x0000001058147825ULL, 0x000fe200078e001aULL,
0x00000012651d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000012097faeULL, 0x0003e2000c901c58ULL,
0x00000012641f7c11ULL, 0x000fc6000f8e20ffULL, 0x000000000c197faeULL, 0x0003e8000d101c58ULL,
0x0000000010177faeULL, 0x0003e8000d901c58ULL, 0x000000000e1d7faeULL, 0x0003e8000e101c58ULL,
0x00000000141f7faeULL, 0x0003e2000e901c58ULL, 0x0000000400bc7947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe2000001160bULL, 0x00008a0000207ab9ULL, 0x000fe20000000a00ULL,
0x0000000322157899ULL, 0x000fe4000800063fULL, 0x0000000d1e167899ULL, 0x000fe2000800063fULL,
0x0000000800037836ULL, 0x044fe20000000000ULL, 0x0000000c04127899ULL, 0x000fe2000800063fULL,
0x0000000400027836ULL, 0x000fe20000000000ULL, 0x0000000706107291ULL, 0x000fe2000f8e703fULL,
0x0000000803067824ULL, 0x040fe200078e00ffULL, 0x0000000b03697212ULL, 0x080fe200078e3cffULL,
0x0000000802057824ULL, 0x040fe200078e00ffULL, 0x0000000b026a7212ULL, 0x080fe200078e3cffULL,
0x0000000c00047836ULL, 0x040fe20000000000ULL, 0xfffffff806697812ULL, 0x000fe200078ee269ULL,
0x0000001400067836ULL, 0x000fe20000000000ULL, 0xfffffff8056a7812ULL, 0x000fe200078ee26aULL,
0x0000000804077824ULL, 0x040fe200078e00ffULL, 0x0000000b04687212ULL, 0x080fe200078e3cffULL,
0x0000001000057836ULL, 0x000fe20000000000ULL, 0x0000000b06667212ULL, 0x0c0fe200078e3cffULL,
0x0000000806097824ULL, 0x000fe200078e00ffULL, 0xfffffff807687812ULL, 0x000fe200078ee268ULL,
0x00000008050a7824ULL, 0x040fe200078e00ffULL, 0x0000000b05677212ULL, 0x080fe200078e3cffULL,
0x0000001c00087836ULL, 0x040fe20000000000ULL, 0xfffffff809667812ULL, 0x000fe200078ee266ULL,
0x0000001800077836ULL, 0x040fe20000000000ULL, 0xfffffff80a677812ULL, 0x000fe200078ee267ULL,
0x0000001400097c36ULL, 0x000fe20008000000ULL, 0x0000000b08647212ULL, 0x0c0fe200078e3cffULL,
0x00000008080d7824ULL, 0x000fe200078e00ffULL, 0x0000000b07657212ULL, 0x040fe200078e3cffULL,
0x00000008070c7824ULL, 0x000fe200078e00ffULL, 0x0000001309097c10ULL, 0x000fe2000ff5e0ffULL,
0x00000014020a7c36ULL, 0x000fe20008000000ULL, 0xfffffff80d647812ULL, 0x000fe200078ee264ULL,
0x00000014040e7c36ULL, 0x000fe20008000000ULL, 0xfffffff80c657812ULL, 0x000fe200078ee265ULL,
0x00000014030c7c36ULL, 0x000fe20008000000ULL, 0x000000130a0d7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200010e06ffULL, 0x000000130e157c10ULL, 0x000fe2000ff3e0ffULL,
0x00000015ff197e24ULL, 0x000fe2000f8e00ffULL, 0x0000002009127c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff147224ULL, 0x000fe200018e06ffULL, 0x000000130c0f7c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff187224ULL, 0x000fe200008e06ffULL, 0x000000200d107c11ULL, 0x000fe2000f8640ffULL,
0x0000200016117892ULL, 0x000fe2000f8ec03fULL, 0x0000002109137c11ULL, 0x000fe200090f440aULL,
0x0000001405097c36ULL, 0x000fe20008000000ULL, 0x00000020150c7c11ULL, 0x000fe2000f8240ffULL,
0x00000014060a7c36ULL, 0x000fe20008000000ULL, 0x000000210d117c11ULL, 0x000fe200098f4414ULL,
0x000000ffff167224ULL, 0x000fe200020e06ffULL, 0x00000021150d7c11ULL, 0x000fe200088f4418ULL,
0x0000100012127892ULL, 0x000fe2000f8e0c3fULL, 0x0000001309097c10ULL, 0x000fe2000ff3e0ffULL,
0x00000014081a7c36ULL, 0x000fe20008000000ULL, 0x000000200f0e7c11ULL, 0x040fe2000f8840ffULL,
0x0000001012127290ULL, 0x000fe2000fffe011ULL, 0x000000130a157c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x000000210f0f7c11ULL, 0x000fe2000a0f4416ULL,
0x0001300012127890ULL, 0x000fe2000fffe03fULL, 0x0000002009167c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x0000002015147c11ULL, 0x000fc4000f8440ffULL,
0x0000002109177c11ULL, 0x000fe400088f440aULL, 0x0000000b00097212ULL, 0x000fe400078e3cffULL,
0x0000002115157c11ULL, 0x000fe400090f4418ULL, 0x0000000709187812ULL, 0x000fe200078ec0ffULL,
0x0000001407097c36ULL, 0x000fe20008000000ULL, 0x000000070b0a7812ULL, 0x000fe400078ec0ffULL,
0x000000131a1e7c10ULL, 0x000fc4000ff5e0ffULL, 0x0000000819587812ULL, 0x000fe400078ee20aULL,
0x0000001309197c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff217224ULL, 0x000fe200010e06ffULL,
0x0ffffff8186b7812ULL, 0x000fe200078ef80bULL, 0x0000001058127825ULL, 0x000fe200078e0012ULL,
0x000000201e187c11ULL, 0x000fe4000f8440ffULL, 0x000000126b097c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff1c7224ULL, 0x000fe200008e06ffULL, 0x00000020191a7c11ULL, 0x040fe2000f8240ffULL,
0x0000001058107825ULL, 0x000fe200078e0010ULL, 0x000000126a1d7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012097faeULL, 0x0003e2000b901c58ULL,
0x00000021191b7c11ULL, 0x000fe200088f441cULL, 0x00000010580e7825ULL, 0x000fe200078e000eULL,
0x00000012691f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000101d7faeULL, 0x0003e2000b901c58ULL,
0x000000211e197c11ULL, 0x000fe200090f4421ULL, 0x00000010580c7825ULL, 0x000fe200078e000cULL,
0x0000001268217c11ULL, 0x000fe2000f8e20ffULL, 0x000000000e1f7faeULL, 0x0003e2000b901c58ULL,
0x0000001267237c11ULL, 0x000fe2000f8e20ffULL, 0x0000001058167825ULL, 0x000fe200078e0016ULL,
0x0000001266297c11ULL, 0x000fe2000f8e20ffULL, 0x000000000c217faeULL, 0x0003e2000b901c58ULL,
0x00000012652b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001058147825ULL, 0x000fe200078e0014ULL,
0x0000001264497c11ULL, 0x000fe2000f8e20ffULL, 0x0000000016237faeULL, 0x0003e4000b901c58ULL,
0x00000010581a7825ULL, 0x000fc400078e001aULL, 0x0000000014297faeULL, 0x0003e4000b901c58ULL,
0x0000001058187825ULL, 0x000fe400078e0018ULL, 0x000000001a2b7faeULL, 0x0003e8000b901c58ULL,
0x0000000018497faeULL, 0x0003e4000b901c58ULL, 0x0000000109127892ULL, 0x000fe2000f8ec03fULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff1f157891ULL, 0x000fe4000f8e083fULL,
0x000000011200788cULL, 0x000fc8000bf05070ULL, 0x0000000115157887ULL, 0x000fc8000c000000ULL,
0x0000001509097290ULL, 0x000fc8000fffe03fULL, 0x000000050900728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fca0003f2f008ULL, 0x000000150b148290ULL, 0x000fe2000fffe00eULL,
0x00008c0000128ab9ULL, 0x000fc60000000a00ULL, 0x00000004141288a5ULL, 0x000fcc000f8e0012ULL,
0x00000012ff6e7e24ULL, 0x000fe2000f8e00ffULL, 0x000000031e127899ULL, 0x000fe2000800063fULL,
0x00000013ff6f7e24ULL, 0x000fc6000f8e00ffULL, 0xffffffe012137892ULL, 0x000fe4000f8ec03fULL,
0x0000001012147892ULL, 0x000fe2000f8ec03fULL, 0x00000001ff6d7424ULL, 0x000fe200078e00ffULL,
0x0000000812127892ULL, 0x000fe2000f8ec03fULL, 0x000000186e6e9981ULL, 0x000562000c1e1900ULL,
0x0000000714137290ULL, 0x000fe2000fffe013ULL, 0x000000100b577824ULL, 0x000fe200078e00ffULL,
0x000000051e147899ULL, 0x000fe2000800063fULL, 0x00000001ff567819ULL, 0x000fe2000001160bULL,
0x00000012ff0c7e24ULL, 0x002fe2000f8e00ffULL, 0x0000001213247290ULL, 0x000fc4000fffe03fULL,
0x00000012ff097e24ULL, 0x000fe2000f8e00ffULL, 0xffffff8014147892ULL, 0x000fe2000f8ec03fULL,
0x0000007057577812ULL, 0x000fe200078ec0ffULL, 0x01b6086d0c0c79a7ULL, 0x000e640008500013ULL,
0x0000001407147290ULL, 0x000fe2000fffe03fULL, 0x0000000c56567812ULL, 0x000fca00078ec0ffULL,
0x0000001456707c10ULL, 0x000fe2000fffe057ULL, 0x01b6080d090075a7ULL, 0x002e640008040153ULL,
0x000000e40034a947ULL, 0x006fea0003800000ULL, 0x01b0000070097984ULL, 0x000e620000000800ULL,
0x000000011e1b7899ULL, 0x000fe2000800063fULL, 0x00000004ff177819ULL, 0x000fe2000001160bULL,
0x000000091e1a7899ULL, 0x000fe2000800063fULL, 0x01b2000070707984ULL, 0x000ea20000000800ULL,
0x000000041b1c7892ULL, 0x000fe2000f8ec03fULL, 0x000000080a107812ULL, 0x000fe200078ef80bULL,
0xffffc00016167892ULL, 0x000fe4000f8ec03fULL, 0x0000001022177291ULL, 0x000fe4000f8e683fULL,
0x0000001c17117c36ULL, 0x000fc80008000000ULL, 0x0000000211137836ULL, 0x000fe20000000000ULL,
0x0000005a0900720bULL, 0x002fda0003f5d000ULL, 0x00000000000c7806ULL, 0x000fc800010e0100ULL,
0x0000ffff0c127812ULL, 0x000fe2000784c0ffULL, 0x00000001ff0c7424ULL, 0x000fd800078e00ffULL,
0x0000000000e4a947ULL, 0x004fea0003800000ULL, 0x0000005a0900720bULL, 0x000fe20003f54000ULL,
0x000000023f1c7899ULL, 0x000fe2000801161eULL, 0x000000095a147209ULL, 0x040fe40007810000ULL,
0x00000002ff0e7819ULL, 0x000fe2000001160bULL, 0x0000001e1c00728cULL, 0x000fe4000bf25270ULL,
0x800000145a0c7221ULL, 0x100fe20000010000ULL, 0x000000ffff5a7224ULL, 0x000fe400078e0014ULL,
0x000000080e0f7836ULL, 0x000fc40000000000ULL, 0x3fb8aa3b0c0d7820ULL, 0x000fe20000410000ULL,
0x000000000000781cULL, 0x000fe40003f6f018ULL, 0x00000000000c7806ULL, 0x000fe200010e0100ULL,
0x0000000d00167308ULL, 0x000e620000000800ULL, 0x000000071e1c9291ULL, 0x000fe4000f8e383fULL,
0x0000ffff0c157812ULL, 0x000fc800078e3cffULL, 0x0000001512ff7212ULL, 0x000fe2000784c0ffULL,
0x00001f0f160f7589ULL, 0x002e6200000e0000ULL, 0x0000001659597220ULL, 0x000fc60000410000ULL,
0x00001f0e160e7589ULL, 0x000eb000000e0000ULL, 0x80000014090c2221ULL, 0x000fe20000010000ULL,
0x0000001c5609bc10ULL, 0x000fc6000fffe057ULL, 0x3fb8aa3b0c0c2820ULL, 0x000fe40000410000ULL,
0x01b400140900b388ULL, 0x0007e40000000800ULL, 0x0000000c00552308ULL, 0x0008a40000000800ULL,
0x00000001ff0c7807ULL, 0x010fe20001000000ULL, 0x0000000f27277220ULL, 0x082fe20000410000ULL,
0x0000000f26267220ULL, 0x080fe20000410000ULL, 0x0000000f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000f33337220ULL, 0x080fe20000410000ULL,
0x0000000f32327220ULL, 0x080fe20000410000ULL, 0x0000000f37377220ULL, 0x080fe20000410000ULL,
0x0000000f36367220ULL, 0x080fe20000410000ULL, 0x0000000f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000f3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000f43437220ULL, 0x080fe20000410000ULL,
0x0000000f42427220ULL, 0x080fe20000410000ULL, 0x0000000f47477220ULL, 0x080fe20000410000ULL,
0x0000000f46467220ULL, 0x000fe20000410000ULL, 0x0000000e25257220ULL, 0x084fe20000410000ULL,
0x0000000e24247220ULL, 0x080fe20000410000ULL, 0x0000000e2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000e2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000e31317220ULL, 0x080fe20000410000ULL,
0x0000000e30307220ULL, 0x080fe20000410000ULL, 0x0000000e35357220ULL, 0x080fe20000410000ULL,
0x0000000e34347220ULL, 0x080fe20000410000ULL, 0x0000000e39397220ULL, 0x080fe20000410000ULL,
0x0000000e38387220ULL, 0x080fe20000410000ULL, 0x0000000e3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000e3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000e41417220ULL, 0x080fe20000410000ULL,
0x0000000e40407220ULL, 0x080fe20000410000ULL, 0x0000000e45457220ULL, 0x080fe20000410000ULL,
0x0000000e44447220ULL, 0x000fe20000410000ULL, 0x0000005570702220ULL, 0x008fce0000410000ULL,
0x00000016071c7290ULL, 0x000fe2000fffe03fULL, 0x0000000711117812ULL, 0x000fe200078e7810ULL,
0xfffff8001a167892ULL, 0x000fe2000f8ec03fULL, 0x0000000713137812ULL, 0x000fe200078e7810ULL,
0x00000004170f7836ULL, 0x000fe20000000000ULL, 0x00000055ff09723eULL, 0x000fe200000000ffULL,
0x0000000810117824ULL, 0x040fe200078e0211ULL, 0x0000001607167290ULL, 0x000fe2000fffe03fULL,
0x0000000810107824ULL, 0x000fe200078e0213ULL, 0x00005410090d7816ULL, 0x000fe20000000009ULL,
0x0000000217097836ULL, 0x040fe20000000000ULL, 0x0000001c221a7291ULL, 0x000fe2000f8e683fULL,
0x0000000617137836ULL, 0x000fe20000000000ULL, 0x000000080a0a7812ULL, 0x000fe200078ef80bULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000001611547c11ULL, 0x000fe2000f8e20ffULL,
0x0000001a041c7291ULL, 0x000fe2000f8e603fULL, 0x00000007175f7812ULL, 0x000fe200078e780aULL,
0x00000017041d7291ULL, 0x000fe2000f8e603fULL, 0x0000000709117812ULL, 0x000fe200078e780aULL,
0x000130001c1c7890ULL, 0x000fe2000fffe03fULL, 0x000000070f5d7812ULL, 0x000fe200078e780aULL,
0x000000080a637824ULL, 0x040fe200078e025fULL, 0x0000000713137812ULL, 0x000fe200078e780aULL,
0x000000080a627824ULL, 0x040fe200078e0211ULL, 0x011000005420783bULL, 0x000fe20000000200ULL,
0x000000080a617824ULL, 0x040fe200078e025dULL, 0x0000001c63507c11ULL, 0x000fe2000f8e20ffULL,
0x000000080a607824ULL, 0x000fe200078e0213ULL, 0x0000001c624c7c11ULL, 0x000fe2000f8e20ffULL,
0x000130001d1d7890ULL, 0x000fe2000fffe03fULL, 0x0000001c61487c11ULL, 0x000fe2000f8e20ffULL,
0xfffffff81b1b7892ULL, 0x000fe2000f8ec03fULL, 0x0000001c60287c11ULL, 0x000fe2000f8e20ffULL,
0x000000005050783bULL, 0x000fe20000004200ULL, 0x00000002ff6c7819ULL, 0x000fe2000001160bULL,
0x0000000104047892ULL, 0x000fe2000f8e0c3fULL, 0x000000800a5c7811ULL, 0x000fe200078e18ffULL,
0x000000004c4c783bULL, 0x000fe20000004200ULL, 0x000099100c0c7816ULL, 0x000fe200000000ffULL,
0x000000086c097836ULL, 0x000fe20000000000ULL, 0x00000016100a7c11ULL, 0x000fe2000f8e20ffULL,
0x000000004848783bULL, 0x000fe20000004200ULL, 0x000000015f5f7824ULL, 0x100fe200078e025cULL,
0x000000ff0c00720cULL, 0x000fe20003f45270ULL, 0x00000001115e7824ULL, 0x100fe200078e025cULL,
0x000000002828783bULL, 0x000fe20000004200ULL, 0x000000015d5d7824ULL, 0x100fe200078e025cULL,
0x0000001d5f1c7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001135c7824ULL, 0x000fe200078e025cULL,
0x00001f6c0d6f7589ULL, 0x000e6200000e0000ULL, 0x0000001d5e187c11ULL, 0x000fe2000f8e20ffULL,
0xffffffff00167882ULL, 0x000fe20000000000ULL, 0x0000001d5d147c11ULL, 0x000fe2000f8e20ffULL,
0x00001f090d727589ULL, 0x000ea200000e0000ULL, 0x0000001d5c107c11ULL, 0x000fe2000f8e20ffULL,
0x0000005970597221ULL, 0x000fe20000010000ULL, 0x000000006e1c92caULL, 0x020fe200000e0000ULL,
0x011000000a0c783bULL, 0x000ee80000000200ULL, 0x000000001c1c783bULL, 0x000f280000004200ULL,
0x000000001818783bULL, 0x000f680000004200ULL, 0x000000001414783bULL, 0x000f220000004200ULL,
0x0000001c00168c82ULL, 0x000fc60008000000ULL, 0x000000001010783bULL, 0x000f220000004200ULL,
0x0000006f2020a232ULL, 0x082fe40000000000ULL, 0x0000006f2222a232ULL, 0x000fe40000000000ULL,
0x000000722121a232ULL, 0x084fe40000000000ULL, 0x000000722323a232ULL, 0x000fce0000000000ULL,
0x000000502044723cULL, 0x000fec0000001844ULL, 0x000000522040723cULL, 0x000fe20000001840ULL,
0x0000006f0c0ca232ULL, 0x008fca0000000000ULL, 0x0000004c203c723cULL, 0x000fe2000000183cULL,
0x0000006f0e0ea232ULL, 0x000fe40000000000ULL, 0x000000720d0da232ULL, 0x080fe40000000000ULL,
0x000000720f0fa232ULL, 0x000fe20000000000ULL, 0x0000004e2038723cULL, 0x000fec0000001838ULL,
0x000000482034723cULL, 0x000fec0000001834ULL, 0x0000004a2030723cULL, 0x000fec0000001830ULL,
0x00000028202c723cULL, 0x000fec000000182cULL, 0x0000002a2024723cULL, 0x000fec0000001824ULL,
0x0000001c0c44723cULL, 0x010fec0000001844ULL, 0x0000001e0c40723cULL, 0x000fec0000001840ULL,
0x000000180c3c723cULL, 0x020fec000000183cULL, 0x0000001a0c38723cULL, 0x000fec0000001838ULL,
0x000000140c34723cULL, 0x000fec0000001834ULL, 0x000000160c30723cULL, 0x000fec0000001830ULL,
0x000000100c2c723cULL, 0x000fec000000182cULL, 0x000000120c24723cULL, 0x000fe20000001824ULL,
0x0000001bff107e24ULL, 0x000fc8000f8e00ffULL, 0x01b6886d10ff79a7ULL, 0x0003e40008500007ULL,
0x000000405b0c7811ULL, 0x000fc800078e40ffULL, 0x000000230c007c0cULL, 0x000fda000bf26070ULL,
0x0000003400681947ULL, 0x002fea0003800000ULL, 0x000000800f1c7890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000c160472a4ULL, 0x000fe4000f8e023fULL,
0x000000600a1d7892ULL, 0x000fe4000f8ef81cULL, 0x0000000704267899ULL, 0x000fe2000800063fULL,
0x0000000400548947ULL, 0x000ff60003800000ULL, 0x0000001d000c7c36ULL, 0x000fe20008000000ULL,
0x0000001c2300728cULL, 0x000fe2000bf01070ULL, 0x0000001d020d7c36ULL, 0x000fe40008000000ULL,
0x8000001cff1d7e24ULL, 0x000fe2000f8e02ffULL, 0x000000260c0c7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001c23047287ULL, 0x000fe2000c000000ULL, 0x000000260d0d7c10ULL, 0x000fc6000ff5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e06ffULL, 0x000000200c1a7c11ULL, 0x040fe2000f8240ffULL,
0x000000ffff0e7224ULL, 0x000fe200010e06ffULL, 0x000000200d187c11ULL, 0x000fe2000f8440ffULL,
0x00000004ff107e24ULL, 0x000fe2000f8e00ffULL, 0x000000210c1b7c11ULL, 0x000fe200088f440fULL,
0x0000001d030c7c36ULL, 0x000fe20008000000ULL, 0x000000210d197c11ULL, 0x000fe200090f440eULL,
0x0000001d040d7c36ULL, 0x000fe20008000000ULL, 0x000000201d1d7446ULL, 0x000fe20003800010ULL,
0x0000001d050e7c36ULL, 0x000fe20008000000ULL, 0x000000260c117c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001d060c7c36ULL, 0x000fe20008000000ULL, 0x000000260d0f7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000c0d047899ULL, 0x000fe2000800063fULL, 0x000000260e0d7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200008e06ffULL, 0x0000002011167c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff0e7224ULL, 0x000fe200010e06ffULL, 0x000000200f147c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x0000002111177c11ULL, 0x000fe200088f441cULL,
0x00001000041c7892ULL, 0x000fe2000f8ec03fULL, 0x000000210f157c11ULL, 0x000fe200090f440eULL,
0x00000010581a7825ULL, 0x000fe200078e001aULL, 0x000000260c0e7c10ULL, 0x000fc4000ff3e0ffULL,
0x000000200d127c11ULL, 0x000fe2000f8640ffULL, 0x0000001d070c7c36ULL, 0x000fe40008000000ULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x000000210d137c11ULL, 0x000fe200098f4410ULL,
0x0000001d080d7c36ULL, 0x000fe20008000000ULL, 0x000000200e107c11ULL, 0x000fe2000f8240ffULL,
0x000000101c1d7290ULL, 0x000fe2000fffe011ULL, 0x000000260c0f7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001058187825ULL, 0x000fe200078e0018ULL, 0x000000210e117c11ULL, 0x000fe200088f4411ULL,
0x000130001d1d7890ULL, 0x000fe2000fffe03fULL, 0x000000260d0d7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff1e7224ULL, 0x000fe200010e06ffULL, 0x0000001d0200720cULL, 0x080fe20003f46070ULL,
0x0000001058167825ULL, 0x000fe200078e0016ULL, 0x0000001d0300720cULL, 0x000fc40003f66070ULL,
0x0000001d6b777c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff1c7224ULL, 0x000fe200008e06ffULL,
0x0000001d0000720cULL, 0x000fe20003f26070ULL, 0x0000001058147825ULL, 0x000fe200078e0014ULL,
0x0000001d6a767c11ULL, 0x000fe4000f8e20ffULL, 0x0000001d69757c11ULL, 0x000fe2000f8e20ffULL,
0x0000001058127825ULL, 0x040fe200078e0012ULL, 0x000000200f0e7c11ULL, 0x000fe4000f8840ffULL,
0x000000200d0c7c11ULL, 0x000fe2000f8a40ffULL, 0x0000001058107825ULL, 0x000fe200078e0010ULL,
0x000000210f0f7c11ULL, 0x000fc4000a0f441eULL, 0x000000210d0d7c11ULL, 0x000fe2000a8f441cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a777faeULL, 0x0003e2000c901c58ULL,
0x0000001d0400720cULL, 0x080fe20003f26070ULL, 0x00000010580e7825ULL, 0x040fe200078e000eULL,
0x0000001d0700720cULL, 0x080fe20003f86070ULL, 0x0000000018767faeULL, 0x0003e2000d101c58ULL,
0x0000001d0500720cULL, 0x080fe20003f46070ULL, 0x00000010580c7825ULL, 0x000fe200078e000cULL,
0x0000001d0800720cULL, 0x080fe20003fa6070ULL, 0x0000000016757faeULL, 0x0003e2000d901c58ULL,
0x0000001d0600720cULL, 0x000fc40003f66070ULL, 0x0000001d68747c11ULL, 0x000fe4000f8e20ffULL,
0x0000001d67737c11ULL, 0x000fe4000f8e20ffULL, 0x0000001d66727c11ULL, 0x000fe2000f8e20ffULL,
0x0000000014747faeULL, 0x0003e2000c901c58ULL, 0x0000001d65717c11ULL, 0x000fe4000f8e20ffULL,
0x0000001d64707c11ULL, 0x000fe2000f8e20ffULL, 0x0000000012737faeULL, 0x0003e8000d101c58ULL,
0x0000000010727faeULL, 0x0003e8000d901c58ULL, 0x000000000e717faeULL, 0x0003e8000e101c58ULL,
0x000000000c707faeULL, 0x0003e2000e901c58ULL, 0x00000004001c7947ULL, 0x000fea0003800000ULL,
0x0000001d000c7c36ULL, 0x000fe20008000000ULL, 0x0000000c0d047899ULL, 0x000fe2000800063fULL,
0x0000001d020d7c36ULL, 0x000fe40008000000ULL, 0x0000001d06137c36ULL, 0x000fe20008000000ULL,
0x000000260c0c7c10ULL, 0x000fe2000ff3e0ffULL, 0x00001000041c7892ULL, 0x000fe2000f8ec03fULL,
0x000000260d0e7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001d081c7c36ULL, 0x000fe40008000000ULL,
0x000000ffff0d7224ULL, 0x000fe200008e06ffULL, 0x000000200c1a7c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e06ffULL, 0x000000200e187c11ULL, 0x000fc4000f8440ffULL,
0x000000210c1b7c11ULL, 0x000fe200088f440dULL, 0x0000001d030c7c36ULL, 0x000fe20008000000ULL,
0x000000210e197c11ULL, 0x000fe200090f440fULL, 0x0000001d040d7c36ULL, 0x000fe40008000000ULL,
0x0000001d050f7c36ULL, 0x000fe20008000000ULL, 0x000000260c0c7c10ULL, 0x000fe2000ff3e0ffULL,
0x00000010581a7825ULL, 0x000fe200078e001aULL, 0x000000260d0e7c10ULL, 0x000fe4000ff5e0ffULL,
0x000000260f107c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e06ffULL,
0x000000200c167c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e06ffULL,
0x000000200e147c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x000000210c177c11ULL, 0x000fe200088f440dULL, 0x0000001058187825ULL, 0x000fe200078e0018ULL,
0x00000026130c7c10ULL, 0x000fc4000ff3e0ffULL, 0x0000002010127c11ULL, 0x000fe2000f8640ffULL,
0x0000001058167825ULL, 0x000fe200078e0016ULL, 0x000000210e157c11ULL, 0x000fe400090f440fULL,
0x0000002110137c11ULL, 0x000fe200098f4411ULL, 0x0000001d070e7c36ULL, 0x000fe20008000000ULL,
0x000000101c1d7290ULL, 0x000fe2000fffe011ULL, 0x000000ffff0d7224ULL, 0x000fe200008e06ffULL,
0x000000200c107c11ULL, 0x000fe2000f8240ffULL, 0x0000001058147825ULL, 0x000fe200078e0014ULL,
0x000000260e0f7c10ULL, 0x000fe2000ff5e0ffULL, 0x000130001d1d7890ULL, 0x000fe2000fffe03fULL,
0x000000210c117c11ULL, 0x000fe200088f440dULL, 0x0000001058127825ULL, 0x000fe200078e0012ULL,
0x000000261c0d7c10ULL, 0x000fc4000ff7e0ffULL, 0x000000200f0e7c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x000000200d0c7c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff1e7224ULL, 0x000fe200018e06ffULL, 0x0000001d6b777c11ULL, 0x000fe2000f8e20ffULL,
0x0000001058107825ULL, 0x000fe200078e0010ULL, 0x0000001d6a767c11ULL, 0x000fe4000f8e20ffULL,
0x000000210f0f7c11ULL, 0x000fe200088f441cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a777faeULL, 0x0003e2000b901c58ULL, 0x0000001d69757c11ULL, 0x000fc4000f8e20ffULL,
0x000000210d0d7c11ULL, 0x000fe200090f441eULL, 0x0000000018767faeULL, 0x0003e2000b901c58ULL,
0x0000001d68747c11ULL, 0x000fe2000f8e20ffULL, 0x00000010580e7825ULL, 0x000fe200078e000eULL,
0x0000001d67737c11ULL, 0x000fe2000f8e20ffULL, 0x0000000016757faeULL, 0x0003e2000b901c58ULL,
0x0000001d66727c11ULL, 0x000fe2000f8e20ffULL, 0x00000010580c7825ULL, 0x000fe200078e000cULL,
0x0000001d65717c11ULL, 0x000fe2000f8e20ffULL, 0x0000000014747faeULL, 0x0003e2000b901c58ULL,
0x0000001d64707c11ULL, 0x000fc6000f8e20ffULL, 0x0000000012737faeULL, 0x0003e8000b901c58ULL,
0x0000000010727faeULL, 0x0003e8000b901c58ULL, 0x000000000e717faeULL, 0x0003e8000b901c58ULL,
0x000000000c707faeULL, 0x0003e4000b901c58ULL, 0x00000012ff0c7e24ULL, 0x002fe2000f8e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000012ff117e24ULL, 0x000fe4000f8e00ffULL,
0x00000014ff0e7e24ULL, 0x000fe4000f8e00ffULL, 0x01b6286d0c0c79a7ULL, 0x000e660008500013ULL,
0x00000080570f7810ULL, 0x000fca0007ffe00eULL, 0x00000001560f7824ULL, 0x000fe200078e020fULL,
0x01b6280d110075a7ULL, 0x002e640008020153ULL, 0x000000d000089947ULL, 0x002fea0003800000ULL,
0x01b000000f0d7984ULL, 0x000e620000000800ULL, 0x0000100004257892ULL, 0x000fe2000f8e0c3fULL,
0x00000001ff107424ULL, 0x000fe400078e00ffULL, 0x01b200000f4c7984ULL, 0x0004a20000000800ULL,
0x000130001a1d7890ULL, 0x000fe2000fffe025ULL, 0x0000005a0d00720bULL, 0x002fda0003f3d000ULL,
0x00000000000c7806ULL, 0x000fc800008e0100ULL, 0x0000ffff0c117812ULL, 0x000fda000782c0ffULL,
0x0000000000dc9947ULL, 0x004fea0003800000ULL, 0x0000005a0d00720bULL, 0x000fe20003f34000ULL,
0x000000011e047891ULL, 0x000fe2000f8ff03fULL, 0x0000000d5a127209ULL, 0x000fc60007810000ULL,
0x0000001e0400728cULL, 0x000fe4000bf05270ULL, 0x800000125a0c7221ULL, 0x100fe20000010000ULL,
0x000000ffff5a7224ULL, 0x000fc600078e0012ULL, 0x3fb8aa3b0c0e7820ULL, 0x000fe20000410000ULL,
0x000000000000781cULL, 0x000fe40003f4f008ULL, 0x00000000000c7806ULL, 0x000fe400008e0100ULL,
0x000000071e048291ULL, 0x000fe2000f8e383fULL, 0x0000000e000e7308ULL, 0x000e620000000800ULL,
0x0000ffff0c107812ULL, 0x000fc800078e3cffULL, 0x0000001011ff7212ULL, 0x000fc6000782c0ffULL,
0x000000045611ac10ULL, 0x000fe4000fffe057ULL, 0x00000001ff107807ULL, 0x000fc60000800000ULL,
0x01b400121100a388ULL, 0x000fe20000000800ULL, 0x0000000e59597220ULL, 0x002fc60000410000ULL,
0x00001f6c0e0c7589ULL, 0x000e6200000e0000ULL, 0x800000120d0f1221ULL, 0x000fc60000010000ULL,
0x00001f090e0d7589ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b0f0f1820ULL, 0x000fc80000410000ULL,
0x0000000f00551308ULL, 0x000ee20000000800ULL, 0x0000000c44447220ULL, 0x082fe20000410000ULL,
0x0000000c45457220ULL, 0x080fe20000410000ULL, 0x0000000c40407220ULL, 0x080fe20000410000ULL,
0x0000000c41417220ULL, 0x080fe20000410000ULL, 0x0000000c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000000c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000c38387220ULL, 0x080fe20000410000ULL,
0x0000000c39397220ULL, 0x080fe20000410000ULL, 0x0000000c34347220ULL, 0x080fe20000410000ULL,
0x0000000c35357220ULL, 0x080fe20000410000ULL, 0x0000000c30307220ULL, 0x080fe20000410000ULL,
0x0000000c31317220ULL, 0x080fe20000410000ULL, 0x0000000c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c24247220ULL, 0x080fe20000410000ULL,
0x0000000c25257220ULL, 0x000fe20000410000ULL, 0x0000000d46467220ULL, 0x084fe20000410000ULL,
0x0000000d47477220ULL, 0x080fe20000410000ULL, 0x0000000d42427220ULL, 0x080fe20000410000ULL,
0x0000000d43437220ULL, 0x080fe20000410000ULL, 0x0000000d3e3e7220ULL, 0x080fe20000410000ULL,
0x0000000d3f3f7220ULL, 0x080fe20000410000ULL, 0x0000000d3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000d3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000d36367220ULL, 0x080fe20000410000ULL,
0x0000000d37377220ULL, 0x080fe20000410000ULL, 0x0000000d32327220ULL, 0x080fe20000410000ULL,
0x0000000d33337220ULL, 0x080fe20000410000ULL, 0x0000000d2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000d2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000d26267220ULL, 0x080fe20000410000ULL,
0x0000000d27277220ULL, 0x000fe20000410000ULL, 0x0000004c554c1220ULL, 0x008fce0000410000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x01180000541c783bULL, 0x000fe20000000200ULL,
0x0000001d636f7c11ULL, 0x000fe2000f8e20ffULL, 0x0001300017047890ULL, 0x000fe2000fffe025ULL,
0x00000055ff11723eULL, 0x000fe200000000ffULL, 0x00000001ff7c7424ULL, 0x000fe200078e00ffULL,
0x0000001d626e7c11ULL, 0x000fe2000f8e20ffULL, 0x000000006f0c783bULL, 0x000fe20000004200ULL,
0x0000541011157816ULL, 0x000fe20000000011ULL, 0x000000594c597221ULL, 0x000fe20000010000ULL,
0x0000991010147816ULL, 0x000fe400000000ffULL, 0x000000006e10783bULL, 0x000fe20000004200ULL,
0x0000001d616d7c11ULL, 0x000fc4000f8e20ffULL, 0x000000ff1400720cULL, 0x000fe20003f25270ULL,
0x00001f6c154d7589ULL, 0x0002a200000e0000ULL, 0x000000045f787c11ULL, 0x000fe4000f8e20ffULL,
0x000000045e7b7c11ULL, 0x000fe2000f8e20ffULL, 0x00001f09154e7589ULL, 0x000ee200000e0000ULL,
0x000000045d7a7c11ULL, 0x000fe4000f8e20ffULL, 0x000000045c797c11ULL, 0x000fe2000f8e20ffULL,
0x000000006d20783bULL, 0x000f220000004200ULL, 0x0000001d606c7c11ULL, 0x002fe2000f8e20ffULL,
0x000000010d1d7892ULL, 0x000fc4000f8ec03fULL, 0x000000007848783bULL, 0x000fe80000004200ULL,
0x000000006c28783bULL, 0x000e620000004200ULL, 0x0000001d00047c82ULL, 0x000fc60008000000ULL,
0x000000007b18783bULL, 0x000fe80000004200ULL, 0x000000007a14783bULL, 0x000fe20000004200ULL,
0x0000004d1c1c9232ULL, 0x084fe40000000000ULL, 0x0000004d1e1e9232ULL, 0x000fe40000000000ULL,
0x0000004e1d1d9232ULL, 0x088fe40000000000ULL, 0x0000004e1f1f9232ULL, 0x000fce0000000000ULL,
0x0000000c1c44723cULL, 0x000fec0000001844ULL, 0x0000000e1c40723cULL, 0x000fe20000001840ULL,
0x011800000a0c783bULL, 0x000eaa0000000200ULL, 0x000000101c3c723cULL, 0x000fec000000183cULL,
0x000000121c38723cULL, 0x000fe20000001838ULL, 0x000000007910783bULL, 0x000eea0000004200ULL,
0x000000201c34723cULL, 0x010fec0000001834ULL, 0x000000221c30723cULL, 0x000fec0000001830ULL,
0x000000281c2c723cULL, 0x002fec000000182cULL, 0x0000002a1c24723cULL, 0x000fe20000001824ULL,
0x0000004d0c0c9232ULL, 0x004fc40000000000ULL, 0x0000004d0e0e9232ULL, 0x000fe40000000000ULL,
0x0000004e0d0d9232ULL, 0x080fe40000000000ULL, 0x0000004e0f0f9232ULL, 0x000fce0000000000ULL,
0x000000480c44723cULL, 0x000fec0000001844ULL, 0x0000004a0c40723cULL, 0x000fec0000001840ULL,
0x000000180c3c723cULL, 0x000fec000000183cULL, 0x0000001a0c38723cULL, 0x000fec0000001838ULL,
0x000000140c34723cULL, 0x000fec0000001834ULL, 0x000000160c30723cULL, 0x000fec0000001830ULL,
0x000000100c2c723cULL, 0x008fec000000182cULL, 0x000000120c24723cULL, 0x000fe20000001824ULL,
0x0000001bff117e24ULL, 0x000fc8000f8e00ffULL, 0x01b6907c11ff79a7ULL, 0x0003e40008500007ULL,
0x000000805b0c7811ULL, 0x000fc800078e40ffULL, 0x000000230c007c0cULL, 0x000fda000bf26070ULL,
0x0000002000d01947ULL, 0x002fea0003800000ULL, 0x000000c00f0f7890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x000000600a097892ULL, 0x000fe2000f8ef80fULL,
0x00000004004c8947ULL, 0x000ff60003800000ULL, 0x00000009000c7c36ULL, 0x000fe20008000000ULL,
0x0000000f2300728cULL, 0x000fe4000bf01070ULL, 0x8000000fff1d7e24ULL, 0x000fe2000f8e02ffULL,
0x0000001025107290ULL, 0x000fe2000fffe011ULL, 0x0000000908197c36ULL, 0x000fe20008000000ULL,
0x000000260c0d7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000009020c7c36ULL, 0x000fe20008000000ULL,
0x0000000f23047287ULL, 0x000fe4000c000000ULL, 0x0001300010107890ULL, 0x000fe2000fffe03fULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x000000200d167c11ULL, 0x000fc4000f8040ffULL,
0x0000002619197c10ULL, 0x000fe4000ff9e0ffULL, 0x000000210d177c11ULL, 0x000fe200080f440eULL,
0x00000004ff0e7e24ULL, 0x000fe2000f8e00ffULL, 0x000000260c0f7c10ULL, 0x000fe2000ff1e0ffULL,
0x00000009030c7c36ULL, 0x000fe20008000000ULL, 0x000000106b6b7c11ULL, 0x000fe2000f8e20ffULL,
0x00000009040d7c36ULL, 0x000fe20008000000ULL, 0x000000201d1d7446ULL, 0x000fe2000380000eULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x000000260c117c10ULL, 0x000fe2000ff3e0ffULL,
0x00000009050c7c36ULL, 0x000fe20008000000ULL, 0x000000200f147c11ULL, 0x000fe2000f8040ffULL,
0x0000001058167825ULL, 0x000fe200078e0016ULL, 0x000000260d0e7c10ULL, 0x000fc4000ff5e0ffULL,
0x000000210f157c11ULL, 0x000fe200080f4410ULL, 0x000000ffff187224ULL, 0x000fe200008e06ffULL,
0x0000002011127c11ULL, 0x040fe2000f8040ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e06ffULL,
0x000000200e107c11ULL, 0x000fe2000f8240ffULL, 0x00000009060d7c36ULL, 0x000fe20008000000ULL,
0x0000002111137c11ULL, 0x000fe200080f4418ULL, 0x0000000907187c36ULL, 0x000fe20008000000ULL,
0x000000210e117c11ULL, 0x000fe200088f440fULL, 0x0000001058147825ULL, 0x000fe200078e0014ULL,
0x000000260d0d7c10ULL, 0x000fc4000ff3e0ffULL, 0x000000260c0f7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001058127825ULL, 0x000fe200078e0012ULL, 0x0000001d0200720cULL, 0x000fe40003f46070ULL,
0x000000106a1f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x000000200d0c7c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x000000200f0e7c11ULL, 0x000fe2000f8040ffULL, 0x0000001058107825ULL, 0x000fe200078e0010ULL,
0x000000210d0d7c11ULL, 0x000fc400088f441aULL, 0x0000001d0000720cULL, 0x080fe40003f26070ULL,
0x000000210f0f7c11ULL, 0x000fe200080f441cULL, 0x000000ffff1c7224ULL, 0x000fe200020e06ffULL,
0x00000026181b7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000010580c7825ULL, 0x040fe200078e000cULL,
0x0000002019187c11ULL, 0x000fe4000f8840ffULL, 0x000000201b1a7c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff1e7224ULL, 0x000fe200000e06ffULL, 0x0000001d0300720cULL, 0x080fe20003f06070ULL,
0x00000010580e7825ULL, 0x000fe200078e000eULL, 0x0000002119197c11ULL, 0x000fe2000a0f441cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000166b7faeULL, 0x000fe2000c901c58ULL,
0x0000001d0400720cULL, 0x000fc40003f26070ULL, 0x000000211b1b7c11ULL, 0x000fe200098f441eULL,
0x00000000141f7faeULL, 0x0003e2000d101c58ULL, 0x0000001d0500720cULL, 0x080fe20003f46070ULL,
0x0000001058187825ULL, 0x000fe200078e0018ULL, 0x0000001d0600720cULL, 0x080fe40003f66070ULL,
0x0000001d0700720cULL, 0x080fe20003f86070ULL, 0x00000010581a7825ULL, 0x000fe200078e001aULL,
0x0000001d0800720cULL, 0x000fe40003fa6070ULL, 0x0000001069697c11ULL, 0x000fc4000f8e20ffULL,
0x00000010681d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001067677c11ULL, 0x000fe2000f8e20ffULL,
0x0000000012697faeULL, 0x0007e2000c101c58ULL, 0x0000001066157c11ULL, 0x002fe4000f8e20ffULL,
0x0000001065657c11ULL, 0x000fe2000f8e20ffULL, 0x00000000101d7faeULL, 0x0007e2000c901c58ULL,
0x0000001064177c11ULL, 0x000fc6000f8e20ffULL, 0x000000000e677faeULL, 0x0007e8000d101c58ULL,
0x000000000c157faeULL, 0x0007e8000d901c58ULL, 0x000000001a657faeULL, 0x0007e8000e101c58ULL,
0x0000000018177faeULL, 0x0007e2000e901c58ULL, 0x0000000400147947ULL, 0x000fea0003800000ULL,
0x00000009000c7c36ULL, 0x000fe20008000000ULL, 0x0000001025107290ULL, 0x000fe2000fffe011ULL,
0x00000009020d7c36ULL, 0x000fe40008000000ULL, 0x0000000903107c36ULL, 0x000fe20008000000ULL,
0x000000260c0c7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000904127c36ULL, 0x000fe20008000000ULL,
0x000000260d0e7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000907197c36ULL, 0x000fe20008000000ULL,
0x0000002610117c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x000000200c167c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e06ffULL,
0x000000200e147c11ULL, 0x000fe2000f8240ffULL, 0x00000009081b7c36ULL, 0x000fe20008000000ULL,
0x000000210c177c11ULL, 0x000fe200080f440dULL, 0x000000ffff0c7224ULL, 0x000fe200010e06ffULL,
0x00000026120d7c10ULL, 0x000fe2000ff7e0ffULL, 0x0001300010107890ULL, 0x000fe2000fffe03fULL,
0x0000002011127c11ULL, 0x000fe2000f8040ffULL, 0x0000001058167825ULL, 0x000fe200078e0016ULL,
0x000000210e157c11ULL, 0x000fc400088f440fULL, 0x0000002111137c11ULL, 0x000fe200080f440cULL,
0x000000ffff0e7224ULL, 0x000fe200018e06ffULL, 0x000000200d107c11ULL, 0x000fe2000f8240ffULL,
0x00000009050f7c36ULL, 0x000fe20008000000ULL, 0x000000106b6b7c11ULL, 0x000fe2000f8e20ffULL,
0x00000009060c7c36ULL, 0x000fe20008000000ULL, 0x000000210d117c11ULL, 0x000fe200088f440eULL,
0x0000001058147825ULL, 0x040fe200078e0014ULL, 0x000000260f0f7c10ULL, 0x000fe2000ff1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000166b7faeULL, 0x0003e2000b901c58ULL,
0x000000260c0d7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001058127825ULL, 0x000fe200078e0012ULL,
0x000000106a1d7c11ULL, 0x000fc4000f8e20ffULL, 0x0000001069697c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff187224ULL, 0x000fe200000e06ffULL, 0x000000200f0e7c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x000000200d0c7c11ULL, 0x000fe2000f8240ffULL,
0x0000001058107825ULL, 0x040fe200078e0010ULL, 0x000000210f0f7c11ULL, 0x000fe200080f4418ULL,
0x00000000141d7faeULL, 0x0003e2000b901c58ULL, 0x000000210d0d7c11ULL, 0x000fe400088f441aULL,
0x0000002619197c10ULL, 0x000fe2000ff1e0ffULL, 0x00000010580e7825ULL, 0x000fe200078e000eULL,
0x000000261b1e7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000012697faeULL, 0x0003e2000b901c58ULL,
0x0000001067677c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x00000020191a7c11ULL, 0x040fe2000f8040ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e06ffULL,
0x000000201e187c11ULL, 0x000fe2000f8240ffULL, 0x00000010580c7825ULL, 0x000fe200078e000cULL,
0x00000021191b7c11ULL, 0x000fc400080f441cULL, 0x000000211e197c11ULL, 0x000fe400088f441fULL,
0x00000010681f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000010581a7825ULL, 0x000fe200078e001aULL,
0x0000001066217c11ULL, 0x000fe4000f8e20ffULL, 0x0000001065657c11ULL, 0x000fe2000f8e20ffULL,
0x0000001058187825ULL, 0x000fe200078e0018ULL, 0x0000001064237c11ULL, 0x000fe2000f8e20ffULL,
0x00000000101f7faeULL, 0x0003e8000b901c58ULL, 0x000000000e677faeULL, 0x0003e8000b901c58ULL,
0x000000000c217faeULL, 0x0003e8000b901c58ULL, 0x000000001a657faeULL, 0x0003e8000b901c58ULL,
0x0000000018237faeULL, 0x0003e4000b901c58ULL, 0x000000150e097290ULL, 0x000fe2000fffe03fULL,
0x00000012ff0f7e24ULL, 0x00afe2000f8e00ffULL, 0xffffffff1f047891ULL, 0x000fe4000f8e083fULL,
0x00000001090e7892ULL, 0x000fe2000f8ec03fULL, 0xffffffff00167882ULL, 0x000fc60000000000ULL,
0x000000010e00788cULL, 0x000fc8000bf05070ULL, 0x0000000104047887ULL, 0x000fc8000c000000ULL,
0x0000000409097290ULL, 0x000fc8000fffe03fULL, 0x000000050900728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x0000000b09047290ULL, 0x000fe2000fffe03fULL, 0x00008c00000e7ab9ULL, 0x000fc60000000a00ULL,
0x00000004040e78a5ULL, 0x000fcc000f8e000eULL, 0x0000000eff0c7e24ULL, 0x000fe4000f8e00ffULL,
0x0000000fff0d7e24ULL, 0x000fca000f8e00ffULL, 0x000000180c0c7981ULL, 0x000ea4000c1e1900ULL,
0x000000000c1672caULL, 0x004fde00000e0000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01b6487c0f0c79a7ULL, 0x0002a20008500013ULL, 0x00000012ff117e24ULL, 0x000fe4000f8e00ffULL,
0x00000014ff0e7e24ULL, 0x000fca000f8e00ffULL, 0x00000100570f7810ULL, 0x002fca0007ffe00eULL,
0x00000001560f7824ULL, 0x000fe200078e020fULL, 0x01b6480d110075a7ULL, 0x004e640008000153ULL,
0x000000bc005c8947ULL, 0x002fea0003800000ULL, 0x01b000000f0d7984ULL, 0x000e620000000800ULL,
0x000130001a1a7890ULL, 0x000fe2000fffe01cULL, 0x00000002ff647819ULL, 0x000fe4000001160bULL,
0x01b200000f667984ULL, 0x0004a20000000800ULL, 0x0000005a0d00720bULL, 0x002fda0003f1d000ULL,
0x00000000000c7806ULL, 0x000fc800000e0100ULL, 0x0000ffff0c117812ULL, 0x000fe2000780c0ffULL,
0x00000001ff0c7424ULL, 0x000fd800078e00ffULL, 0x0000000000dc8947ULL, 0x004fea0003800000ULL,
0x0000005a0d00720bULL, 0x000fe20003f14000ULL, 0x000000021e047891ULL, 0x000fe2000f8ff03fULL,
0x0000000d5a0e7209ULL, 0x000fc60007810000ULL, 0x0000001e0400728cULL, 0x000fe4000bf05270ULL,
0x8000000e5a0c7221ULL, 0x100fe20000010000ULL, 0x000000ffff5a7224ULL, 0x000fc600078e000eULL,
0x3fb8aa3b0c0f7820ULL, 0x000fe20000410000ULL, 0x000000000000781cULL, 0x000fe40003f2f008ULL,
0x00000000000c7806ULL, 0x000fe200000e0100ULL, 0x0000000f00107308ULL, 0x000e620000000800ULL,
0x000000071e048291ULL, 0x000fe4000f8e383fULL, 0x0000ffff0c127812ULL, 0x000fc800078e3cffULL,
0x0000001211ff7212ULL, 0x000fc6000780c0ffULL, 0x0000000456139c10ULL, 0x000fe2000fffe057ULL,
0x00001f64100c7589ULL, 0x002e6200000e0000ULL, 0x0000001059597220ULL, 0x000fc60000410000ULL,
0x01b4000e13009388ULL, 0x000fea0000000800ULL, 0x8000000e0d110221ULL, 0x000fe40000010000ULL,
0x00001f09100d7589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL,
0x0000001100550308ULL, 0x000ee20000000800ULL, 0x0000000c44447220ULL, 0x082fe20000410000ULL,
0x0000000c45457220ULL, 0x080fe20000410000ULL, 0x0000000c40407220ULL, 0x080fe20000410000ULL,
0x0000000c41417220ULL, 0x080fe20000410000ULL, 0x0000000c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000000c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000c38387220ULL, 0x080fe20000410000ULL,
0x0000000c39397220ULL, 0x080fe20000410000ULL, 0x0000000c34347220ULL, 0x080fe20000410000ULL,
0x0000000c35357220ULL, 0x080fe20000410000ULL, 0x0000000c30307220ULL, 0x080fe20000410000ULL,
0x0000000c31317220ULL, 0x080fe20000410000ULL, 0x0000000c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c24247220ULL, 0x080fe20000410000ULL,
0x0000000c25257220ULL, 0x000fe20000410000ULL, 0x00000001ff0c7807ULL, 0x000fe20000000000ULL,
0x0000000d46467220ULL, 0x084fe20000410000ULL, 0x0000000d47477220ULL, 0x080fe20000410000ULL,
0x0000000d42427220ULL, 0x080fe20000410000ULL, 0x0000000d43437220ULL, 0x080fe20000410000ULL,
0x0000000d3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000d3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000d3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000d3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000d36367220ULL, 0x080fe20000410000ULL, 0x0000000d37377220ULL, 0x080fe20000410000ULL,
0x0000000d32327220ULL, 0x080fe20000410000ULL, 0x0000000d33337220ULL, 0x080fe20000410000ULL,
0x0000000d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000d26267220ULL, 0x080fe20000410000ULL, 0x0000000d27277220ULL, 0x000fe20000410000ULL,
0x0000006655660220ULL, 0x008fce0000410000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x012000005420783bULL, 0x000fe20000000200ULL, 0x0000001a63507c11ULL, 0x000fe2000f8e20ffULL,
0x0001300017177890ULL, 0x000fe2000fffe01cULL, 0x0000001a624c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000010d047892ULL, 0x000fe2000f8e0c3fULL, 0x0000001a61487c11ULL, 0x000fe2000f8e20ffULL,
0x0000005966597221ULL, 0x000fe20000010000ULL, 0x0000001a60287c11ULL, 0x000fe2000f8e20ffULL,
0x000000005050783bULL, 0x000fe20000004200ULL, 0x00000055ff0d723eULL, 0x000fe400000000ffULL,
0x000099100c107816ULL, 0x000fe200000000ffULL, 0x000000004c4c783bULL, 0x000fe20000004200ULL,
0x000054100d117816ULL, 0x000fc4000000000dULL, 0x000000ff1000720cULL, 0x000fe20003f05270ULL,
0x000000004848783bULL, 0x000fe20000004200ULL, 0x000000175f1c7c11ULL, 0x000fe4000f8e20ffULL,
0x000000175e187c11ULL, 0x000fe2000f8e20ffULL, 0x000000002828783bULL, 0x000fe20000004200ULL,
0x000000175d147c11ULL, 0x000fe4000f8e20ffULL, 0x000000175c107c11ULL, 0x000fe2000f8e20ffULL,
0x00001f6411617589ULL, 0x000e6800000e0000ULL, 0x00001f0911607589ULL, 0x000ea800000e0000ULL,
0x012000000a0c783bULL, 0x000ee80000000200ULL, 0x000000001c1c783bULL, 0x000f280000004200ULL,
0x000000001818783bULL, 0x000f680000004200ULL, 0x000000001414783bULL, 0x000f280000004200ULL,
0x000000001010783bULL, 0x000f220000004200ULL, 0x0000006120208232ULL, 0x002fc40000000000ULL,
0x0000006122228232ULL, 0x000fe40000000000ULL, 0x0000006021218232ULL, 0x084fe40000000000ULL,
0x0000006023238232ULL, 0x000fce0000000000ULL, 0x000000502044723cULL, 0x000fec0000001844ULL,
0x000000522040723cULL, 0x000fe20000001840ULL, 0x000000610c0c8232ULL, 0x008fca0000000000ULL,
0x0000004c203c723cULL, 0x000fe2000000183cULL, 0x000000610e0e8232ULL, 0x000fe40000000000ULL,
0x000000600d0d8232ULL, 0x080fe40000000000ULL, 0x000000600f0f8232ULL, 0x000fe20000000000ULL,
0x0000004e2038723cULL, 0x000fec0000001838ULL, 0x000000482034723cULL, 0x000fec0000001834ULL,
0x0000004a2030723cULL, 0x000fec0000001830ULL, 0x00000028202c723cULL, 0x000fec000000182cULL,
0x0000002a2024723cULL, 0x000fec0000001824ULL, 0x0000001c0c44723cULL, 0x010fec0000001844ULL,
0x0000001e0c40723cULL, 0x000fec0000001840ULL, 0x000000180c3c723cULL, 0x020fec000000183cULL,
0x0000001a0c38723cULL, 0x000fec0000001838ULL, 0x000000140c34723cULL, 0x000fec0000001834ULL,
0x000000160c30723cULL, 0x000fec0000001830ULL, 0x000000100c2c723cULL, 0x000fec000000182cULL,
0x000000120c24723cULL, 0x000fe20000001824ULL, 0x0000001bff117e24ULL, 0x000fc8000f8e00ffULL,
0x01b6987c11ff79a7ULL, 0x0003e40008500007ULL, 0x000000c05b0c7811ULL, 0x000fc800078e40ffULL,
0x000000230c007c0cULL, 0x000fda000bf06070ULL, 0x0000001000140947ULL, 0x002fea0003800000ULL,
0x000000005b0472caULL, 0x000fe200000e0000ULL, 0x00000005060d7899ULL, 0x000fe2000800063fULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000c160c72a4ULL, 0x000fc8000f8e023fULL,
0x000000070c0c7899ULL, 0x000fcc000800063fULL, 0x000000041f047290ULL, 0x000fc8000fffe03fULL,
0x00000001040e7890ULL, 0x000fe4000fffe03fULL, 0x0000000d04047291ULL, 0x000fe4000f8e403fULL,
0x000000080e00728cULL, 0x000fe4000bf06070ULL, 0x000000600a0e7892ULL, 0x000fc8000f8ef804ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000400248947ULL, 0x000fea0003800000ULL,
0x000000042300728cULL, 0x000fe4000bf01070ULL, 0x80000004ff1d7e24ULL, 0x000fe4000f8e02ffULL,
0x0000000e020d7c36ULL, 0x000fe20008000000ULL, 0x00000004230d7287ULL, 0x000fe2000c000000ULL,
0x0000000e000c7c36ULL, 0x000fe40008000000ULL, 0x0000000e040f7c36ULL, 0x000fe20008000000ULL,
0x0000000c0d137c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000dff0e7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000c0c157c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000c0f0d7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x000000200e1d7446ULL, 0x000fe2000380001dULL,
0x0000000e030e7c36ULL, 0x000fe20008000000ULL, 0x0000002013187c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff167224ULL, 0x000fe200000e06ffULL, 0x00000020151a7c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x0000000c0e117c10ULL, 0x000fe4000ff5e0ffULL,
0x000000200d0c7c11ULL, 0x000fc4000f8640ffULL, 0x00000021151b7c11ULL, 0x000fe200080f4416ULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x00000020110e7c11ULL, 0x000fe4000f8440ffULL,
0x000000210d0d7c11ULL, 0x000fe200098f4410ULL, 0x0000000e06107c36ULL, 0x000fe20008000000ULL,
0x00000021110f7c11ULL, 0x000fe200090f4412ULL, 0x0000000e07117c36ULL, 0x000fe20008000000ULL,
0x0000001d0000720cULL, 0x000fe20003f06070ULL, 0x0000000e05007c36ULL, 0x000fe20008000000ULL,
0x0000002113197c11ULL, 0x000fe200088f4414ULL, 0x0000000e08127c36ULL, 0x000fe20008000000ULL,
0x0000000c11137c10ULL, 0x000fe2000ff9e0ffULL, 0x00000010581a7825ULL, 0x000fe200078e001aULL,
0x0000000c10157c10ULL, 0x000fc4000ff7e0ffULL, 0x0000000c00177c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x0000000c12007c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff1e7224ULL, 0x000fe200018e06ffULL, 0x0000002013127c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff207224ULL, 0x000fe200010e06ffULL, 0x0000002015147c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x0000002017167c11ULL, 0x000fe2000f8440ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a777faeULL, 0x0003e2000c101c58ULL,
0x0000002000107c11ULL, 0x000fe2000f8240ffULL, 0x0000001058187825ULL, 0x000fe200078e0018ULL,
0x0000002113137c11ULL, 0x000fc4000a0f441cULL, 0x0000001d0200720cULL, 0x080fe20003fa6070ULL,
0x00000010580e7825ULL, 0x040fe200078e000eULL, 0x0000002115157c11ULL, 0x000fe400098f441eULL,
0x0000001d0300720cULL, 0x080fe20003f86070ULL, 0x00000010580c7825ULL, 0x000fe200078e000cULL,
0x0000002117177c11ULL, 0x000fe400090f4420ULL, 0x0000001d0400720cULL, 0x000fe20003f66070ULL,
0x0000001058147825ULL, 0x000fe200078e0014ULL, 0x0000002100117c11ULL, 0x000fc400088f4411ULL,
0x0000001d0500720cULL, 0x080fe20003f46070ULL, 0x0000001058167825ULL, 0x000fe200078e0016ULL,
0x0000001d0600720cULL, 0x080fe20003f26070ULL, 0x0000000018767faeULL, 0x0003e2000e901c58ULL,
0x0000001d0700720cULL, 0x080fe20003f06070ULL, 0x0000001058127825ULL, 0x000fe200078e0012ULL,
0x0000001d0800720cULL, 0x000fe20003fc6070ULL, 0x000000000e757faeULL, 0x0003e4000e101c58ULL,
0x0000001058107825ULL, 0x000fe400078e0010ULL, 0x000000000c747faeULL, 0x0003e8000d901c58ULL,
0x0000000016737faeULL, 0x0003e8000d101c58ULL, 0x0000000014727faeULL, 0x0003e8000c901c58ULL,
0x0000000012717faeULL, 0x0003e8000c101c58ULL, 0x0000000010707faeULL, 0x0003e2000f101c58ULL,
0x0000000000ec7947ULL, 0x000fea0003800000ULL, 0x0000000e00007c36ULL, 0x000fe40008000000ULL,
0x0000000e02027c36ULL, 0x000fe40008000000ULL, 0x0000000e03037c36ULL, 0x000fe20008000000ULL,
0x0000000c00007c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000e040c7c36ULL, 0x000fe20008000000ULL,
0x0000000c02047c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000e05057c36ULL, 0x000fe20008000000ULL,
0x0000000c03127c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x0000000c0c147c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e06ffULL,
0x0000002000107c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x00000020040e7c11ULL, 0x000fe2000f8240ffULL, 0x0000000e06067c36ULL, 0x000fe20008000000ULL,
0x0000002100117c11ULL, 0x000fe200080f4403ULL, 0x000000ffff157224ULL, 0x000fe200018e06ffULL,
0x00000020120c7c11ULL, 0x000fe2000f8440ffULL, 0x0000000e07007c36ULL, 0x000fe20008000000ULL,
0x0000002014027c11ULL, 0x000fe2000f8640ffULL, 0x0000000e08087c36ULL, 0x000fe20008000000ULL,
0x00000021040f7c11ULL, 0x000fe200088f440dULL, 0x0000001058107825ULL, 0x000fe200078e0010ULL,
0x0000000c05057c10ULL, 0x000fc4000ff1e0ffULL, 0x00000021120d7c11ULL, 0x000fe200090f4413ULL,
0x00000010580e7825ULL, 0x000fe200078e000eULL, 0x0000000c06077c10ULL, 0x000fe2000ff3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010777faeULL, 0x0003e2000b901c58ULL,
0x0000002114037c11ULL, 0x000fe200098f4415ULL, 0x00000010580c7825ULL, 0x000fe200078e000cULL,
0x0000000c00167c10ULL, 0x000fe2000ff5e0ffULL, 0x000000000e767faeULL, 0x0003e2000b901c58ULL,
0x0000000c08187c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x0000002005147c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x0000002007127c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0x0000002016067c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff197224ULL, 0x000fe200018e06ffULL,
0x0000002018047c11ULL, 0x000fe2000f8640ffULL, 0x0000001058027825ULL, 0x000fe200078e0002ULL,
0x0000002105157c11ULL, 0x000fe200080f4400ULL, 0x000000000c757faeULL, 0x0003e2000b901c58ULL,
0x0000002107137c11ULL, 0x000fc400088f4408ULL, 0x0000002116077c11ULL, 0x000fe200090f4417ULL,
0x0000001058147825ULL, 0x000fe200078e0014ULL, 0x0000002118057c11ULL, 0x000fe200098f4419ULL,
0x0000000002747faeULL, 0x0003e4000b901c58ULL, 0x0000001058127825ULL, 0x040fe400078e0012ULL,
0x0000000014737faeULL, 0x0003e4000b901c58ULL, 0x0000001058067825ULL, 0x040fe400078e0006ULL,
0x0000000012727faeULL, 0x0003e4000b901c58ULL, 0x0000001058047825ULL, 0x000fc400078e0004ULL,
0x0000000006717faeULL, 0x0003e8000b901c58ULL, 0x0000000004707faeULL, 0x0003e4000b901c58ULL,
0x00000012ff037e24ULL, 0x002fe2000f8e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000012ff077e24ULL, 0x000fe4000f8e00ffULL, 0x00000014ff007e24ULL, 0x000fe4000f8e00ffULL,
0x01b6687c030279a7ULL, 0x000e660008500013ULL, 0x0000018057057810ULL, 0x000fca0007ffe000ULL,
0x0000000156057824ULL, 0x000fe200078e0205ULL, 0x01b66803070075a7ULL, 0x002e640008000153ULL,
0x000000ac002c8947ULL, 0x002fea0003800000ULL, 0x01b0000005037984ULL, 0x000e620000000800ULL,
0x00000001ff027424ULL, 0x000fe200078e00ffULL, 0x0000005a0300720bULL, 0x002fda0003f1d000ULL,
0x0000000000007806ULL, 0x000fc800000e0100ULL, 0x0000ffff00067812ULL, 0x000fe4000780c0ffULL,
0x01b2000005007984ULL, 0x0002b60000000800ULL, 0x0000000000dc8947ULL, 0x002fea0003800000ULL,
0x0000005a0300720bULL, 0x000fe20003f14000ULL, 0x000000031e047891ULL, 0x000fe2000f8ff03fULL,
0x000000035a077209ULL, 0x000fc60007810000ULL, 0x0000001e0400728cULL, 0x000fe4000bf05270ULL,
0x800000075a027221ULL, 0x100fe20000010000ULL, 0x000000ffff5a7224ULL, 0x000fc600078e0007ULL,
0x3fb8aa3b02047820ULL, 0x000fe20000410000ULL, 0x000000000000781cULL, 0x000fe40003f2f008ULL,
0x0000000000027806ULL, 0x000fe400000e0100ULL, 0x000000071e048291ULL, 0x000fe2000f8e383fULL,
0x0000000400047308ULL, 0x000e620000000800ULL, 0x0000ffff02057812ULL, 0x000fc800078e3cffULL,
0x0000000506ff7212ULL, 0x000fc6000780c0ffULL, 0x0000000456569c10ULL, 0x000fca000fffe057ULL,
0x01b4000756009388ULL, 0x000fe20000000800ULL, 0x0000000459597220ULL, 0x002fc60000410000ULL,
0x00001f6404027589ULL, 0x000e6200000e0000ULL, 0x8000000703050221ULL, 0x000fc60000010000ULL,
0x00001f0904037589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b05050820ULL, 0x000fc80000410000ULL,
0x0000000500550308ULL, 0x000f220000000800ULL, 0x0000000244447220ULL, 0x082fe20000410000ULL,
0x0000000245457220ULL, 0x080fe20000410000ULL, 0x0000000240407220ULL, 0x080fe20000410000ULL,
0x0000000241417220ULL, 0x080fe20000410000ULL, 0x000000023c3c7220ULL, 0x080fe20000410000ULL,
0x000000023d3d7220ULL, 0x080fe20000410000ULL, 0x0000000238387220ULL, 0x080fe20000410000ULL,
0x0000000239397220ULL, 0x080fe20000410000ULL, 0x0000000234347220ULL, 0x080fe20000410000ULL,
0x0000000235357220ULL, 0x080fe20000410000ULL, 0x0000000230307220ULL, 0x080fe20000410000ULL,
0x0000000231317220ULL, 0x080fe20000410000ULL, 0x000000022c2c7220ULL, 0x080fe20000410000ULL,
0x000000022d2d7220ULL, 0x080fe20000410000ULL, 0x0000000224247220ULL, 0x080fe20000410000ULL,
0x0000000225257220ULL, 0x000fe20000410000ULL, 0x00000001ff027807ULL, 0x000fe20000000000ULL,
0x0000000346467220ULL, 0x088fe20000410000ULL, 0x0000000347477220ULL, 0x080fe20000410000ULL,
0x0000000342427220ULL, 0x080fe20000410000ULL, 0x0000000343437220ULL, 0x080fe20000410000ULL,
0x000000033e3e7220ULL, 0x080fe20000410000ULL, 0x000000033f3f7220ULL, 0x080fe20000410000ULL,
0x000000033a3a7220ULL, 0x080fe20000410000ULL, 0x000000033b3b7220ULL, 0x080fe20000410000ULL,
0x0000000336367220ULL, 0x080fe20000410000ULL, 0x0000000337377220ULL, 0x080fe20000410000ULL,
0x0000000332327220ULL, 0x080fe20000410000ULL, 0x0000000333337220ULL, 0x080fe20000410000ULL,
0x000000032e2e7220ULL, 0x080fe20000410000ULL, 0x000000032f2f7220ULL, 0x080fe20000410000ULL,
0x0000000326267220ULL, 0x080fe20000410000ULL, 0x0000000327277220ULL, 0x000fe20000410000ULL,
0x0000000055000220ULL, 0x014fce0000410000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x012800005404783bULL, 0x000fe20000000200ULL, 0x00000055ff03723eULL, 0x000fe200000000ffULL,
0x0000005900597221ULL, 0x004fe20000010000ULL, 0x0000991002027816ULL, 0x000fe200000000ffULL,
0x000000006f0c783bULL, 0x000fe20000004200ULL, 0x0000541003507816ULL, 0x000fe20000000003ULL,
0x0000001d00047c82ULL, 0x000fe20008000000ULL, 0x000000ff0200720cULL, 0x000fe20003f05270ULL,
0x000000006e10783bULL, 0x000fe80000004200ULL, 0x000000006d14783bULL, 0x000fe80000004200ULL,
0x000000006c18783bULL, 0x000fe80000004200ULL, 0x00001f6450037589ULL, 0x000e6800000e0000ULL,
0x00001f0950087589ULL, 0x000ea800000e0000ULL, 0x012800000a1c783bULL, 0x000ee80000000200ULL,
0x000000007820783bULL, 0x000f280000004200ULL, 0x000000007b28783bULL, 0x000f680000004200ULL,
0x000000007a48783bULL, 0x000f280000004200ULL, 0x00000000794c783bULL, 0x000f220000004200ULL,
0x0000000304048232ULL, 0x002fc40000000000ULL, 0x0000000306068232ULL, 0x000fe40000000000ULL,
0x0000000805058232ULL, 0x084fe40000000000ULL, 0x0000000807078232ULL, 0x000fce0000000000ULL,
0x0000000c0444723cULL, 0x000fec0000001844ULL, 0x0000000e0440723cULL, 0x000fe20000001840ULL,
0x000000031c1c8232ULL, 0x008fca0000000000ULL, 0x00000010043c723cULL, 0x000fe2000000183cULL,
0x000000031e1e8232ULL, 0x000fe40000000000ULL, 0x0000001bff037e24ULL, 0x000fe4000f8e00ffULL,
0x000000081d1d8232ULL, 0x080fe40000000000ULL, 0x000000081f1f8232ULL, 0x000fe20000000000ULL,
0x000000120438723cULL, 0x000fe20000001838ULL, 0x01b6a07c03ff79a7ULL, 0x0003ea0008500007ULL,
0x000000140434723cULL, 0x000fec0000001834ULL, 0x000000160430723cULL, 0x000fec0000001830ULL,
0x00000018042c723cULL, 0x000fec000000182cULL, 0x0000001a0424723cULL, 0x000fec0000001824ULL,
0x000000201c44723cULL, 0x010fec0000001844ULL, 0x000000221c40723cULL, 0x000fec0000001840ULL,
0x000000281c3c723cULL, 0x020fec000000183cULL, 0x0000002a1c38723cULL, 0x000fec0000001838ULL,
0x000000481c34723cULL, 0x000fec0000001834ULL, 0x0000004a1c30723cULL, 0x000fec0000001830ULL,
0x0000004c1c2c723cULL, 0x000fec000000182cULL, 0x0000004e1c24723cULL, 0x002fde0000001824ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000001f5b5b7c36ULL, 0x000fca0008000000ULL,
0x000000085b007c0cULL, 0x000fda000bf06070ULL, 0xffffffac00748947ULL, 0x004fea000383ffffULL,
0x00000000001279c3ULL, 0x000e640000002500ULL, 0x000000081200728cULL, 0x002fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000c40947ULL, 0x000fea0003800000ULL,
0x0180000059007836ULL, 0x000fca0000000000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x00006be000027802ULL, 0x004fce0000000f00ULL, 0x000000a800e87944ULL, 0x000fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000005900007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x006fc80000000059ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fce0000000000ULL, 0x0000000000037919ULL, 0x000f240000000000ULL,
0x00000002ff057819ULL, 0x010fe40000011603ULL, 0x0000000803037811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x00cfea0003800000ULL, 0x00001f0500027589ULL, 0x000ea800000e0000ULL,
0x00001f0300037589ULL, 0x000ee200000e0000ULL, 0x0000004402447220ULL, 0x044fe20000410000ULL,
0x0000004502457220ULL, 0x040fe20000410000ULL, 0x0000004002407220ULL, 0x040fe20000410000ULL,
0x0000004102417220ULL, 0x040fe20000410000ULL, 0x0000003c023c7220ULL, 0x040fe20000410000ULL,
0x0000003d023d7220ULL, 0x040fe20000410000ULL, 0x0000003802387220ULL, 0x040fe20000410000ULL,
0x0000003902397220ULL, 0x040fe20000410000ULL, 0x0000003402347220ULL, 0x040fe20000410000ULL,
0x0000003502357220ULL, 0x040fe20000410000ULL, 0x0000003002307220ULL, 0x040fe20000410000ULL,
0x0000003102317220ULL, 0x040fe20000410000ULL, 0x0000002c022c7220ULL, 0x040fe20000410000ULL,
0x0000002d022d7220ULL, 0x040fe20000410000ULL, 0x0000002402247220ULL, 0x040fe20000410000ULL,
0x0000002502257220ULL, 0x000fe20000410000ULL, 0x0000004603467220ULL, 0x048fe20000410000ULL,
0x0000004703477220ULL, 0x040fe20000410000ULL, 0x0000004203427220ULL, 0x040fe20000410000ULL,
0x0000004303437220ULL, 0x040fe20000410000ULL, 0x0000003e033e7220ULL, 0x040fe20000410000ULL,
0x0000003f033f7220ULL, 0x040fe20000410000ULL, 0x0000003a033a7220ULL, 0x040fe20000410000ULL,
0x0000003b033b7220ULL, 0x040fe20000410000ULL, 0x0000003603367220ULL, 0x040fe20000410000ULL,
0x0000003703377220ULL, 0x040fe20000410000ULL, 0x0000003203327220ULL, 0x040fe20000410000ULL,
0x0000003303337220ULL, 0x040fe20000410000ULL, 0x0000002e032e7220ULL, 0x040fe20000410000ULL,
0x0000002f032f7220ULL, 0x040fe20000410000ULL, 0x0000002603267220ULL, 0x040fe20000410000ULL,
0x0000002703277220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x0000000722077291ULL, 0x000fe2000f8e603fULL, 0x0000002c2d0a723eULL, 0x000fe200000000ffULL,
0x0000000506147899ULL, 0x000fe2000800063fULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000706137291ULL, 0x000fe2000f8e583fULL, 0x00000046470c723eULL, 0x004fe200000000ffULL,
0x000000011f00788cULL, 0x000fe2000bf05270ULL, 0x00000042430d723eULL, 0x000fe400000000ffULL,
0x0000003e3f0e723eULL, 0x000fc400000000ffULL, 0x0000003a3b0f723eULL, 0x000fe400000000ffULL,
0x000000363710723eULL, 0x000fe400000000ffULL, 0x000000323311723eULL, 0x000fe400000000ffULL,
0x0000002e2f12723eULL, 0x000fe400000000ffULL, 0x000000262713723eULL, 0x000fe400000000ffULL,
0x000000000000781cULL, 0x000fc40003f0f008ULL, 0x00000003ff037819ULL, 0x008fe20000011600ULL,
0x0000001400177c36ULL, 0x000fe20008000000ULL, 0xfffffff8ff057812ULL, 0x000fe400078ee200ULL,
0x0000000303027812ULL, 0x000fe400078ec0ffULL, 0x0000000717187c11ULL, 0x000fe2000f8e20ffULL,
0x0000000805097836ULL, 0x040fe20000000000ULL, 0x0000000402067812ULL, 0x000fe200078efcffULL,
0x0000000805047824ULL, 0x000fe200078e00ffULL, 0x0000000702077812ULL, 0x000fe200078e7805ULL,
0x0000000809087824ULL, 0x000fe200078e00ffULL, 0x0000000706057812ULL, 0x000fc400078e7805ULL,
0x00000007020b7812ULL, 0x000fe400078e7809ULL, 0x0000000706097812ULL, 0x000fe400078e7809ULL,
0x0000000407027212ULL, 0x080fe400078efcffULL, 0x0000000405147212ULL, 0x000fe400078efcffULL,
0x000000080b157212ULL, 0x080fe400078efcffULL, 0x0000000809167212ULL, 0x000fc400078efcffULL,
0x000000444504723eULL, 0x000fe400000000ffULL, 0x000000404105723eULL, 0x000fe400000000ffULL,
0x0000003c3d06723eULL, 0x000fe400000000ffULL, 0x000000383907723eULL, 0x000fe400000000ffULL,
0x0000001302027c11ULL, 0x000fe4000f8e20ffULL, 0x000000343508723eULL, 0x000fc400000000ffULL,
0x000000303109723eULL, 0x000fe200000000ffULL, 0x0000000402007844ULL, 0x000fe20000000200ULL,
0x00000024250b723eULL, 0x000fe400000000ffULL, 0x0000001314147c11ULL, 0x000fe4000f8e20ffULL,
0x0000001315157c11ULL, 0x000fe4000f8e20ffULL, 0x0000001316167c11ULL, 0x000fe2000f8e20ffULL,
0x0000000814007844ULL, 0x000fe80000000200ULL, 0x0000000c15007844ULL, 0x000fe80000000200ULL,
0x0000001016007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000181c7984ULL, 0x000ea80000000c00ULL, 0x0004000018247984ULL, 0x000ee80000000c00ULL,
0x0008000018207984ULL, 0x000f280000000c00ULL, 0x000c000018287984ULL, 0x000f620000000c00ULL,
0x200000ff1f1f7230ULL, 0x004fc40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fe40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x008fe40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fc40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x010fe40000000000ULL, 0x000000221e1e7230ULL, 0x000fe40000000000ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x020fc40000000000ULL, 0x0000002a26267230ULL, 0x000fe20000000000ULL,
0x0000001c18007388ULL, 0x0005e20000000c00ULL, 0x0000002925257230ULL, 0x000fe40000000000ULL,
0x0000002824247230ULL, 0x000fca0000000000ULL, 0x0004002418007388ULL, 0x0005e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000002800988947ULL, 0x000fea0003800000ULL,
0x0000000018187984ULL, 0x004ea20000000c00ULL, 0x00000000000a79c3ULL, 0x000fe20000002700ULL,
0x00000001063f7892ULL, 0x000fe2000f80f81eULL, 0x0000840000087ab9ULL, 0x000fe20000000800ULL,
0x0000920000097ab9ULL, 0x000fe20000000800ULL, 0x000000081f0472a4ULL, 0x000fc6000f8e023fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x00000000000579c3ULL, 0x000ee20000002600ULL,
0x00000009040972a4ULL, 0x000fc8000f8e023fULL, 0x01ffffff09157892ULL, 0x000fe4000f8ec03fULL,
0x000000080a0a72a4ULL, 0x008fc8000f8e0205ULL, 0x0000001f0a0872a4ULL, 0x000fc8000f8e023fULL,
0x00000012080b7290ULL, 0x000fe2000fffe03fULL, 0x0000000000380947ULL, 0x004ff60003800000ULL,
0x000000150b0c7290ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x0000980000047ab9ULL, 0x000fe20000000a00ULL, 0x00000001ff047819ULL, 0x000fe20000011600ULL,
0x000000800b0e78a5ULL, 0x000fe4000f8e0004ULL, 0x000000800c0478a5ULL, 0x000fe2000f8e0004ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c04077812ULL, 0x000fc800078ec0ffULL,
0x0000000e07047c10ULL, 0x140fe4000fa3e002ULL, 0x0000000407067c10ULL, 0x000fe4000fc7e002ULL,
0x0000000fff057c10ULL, 0x000fe40008fe44ffULL, 0x00000005ff077c10ULL, 0x000fc60009fe84ffULL,
0x0000005a04007986ULL, 0x0005e8000c101918ULL, 0x0000005906007986ULL, 0x0005e4000c101918ULL,
0x000007ff09097891ULL, 0x000fe2000f8e403fULL, 0x000000ff0000720cULL, 0x000fe20000705670ULL,
0x0000980000107ab9ULL, 0x000fe20000000a00ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x0000000b09047291ULL, 0x000fc8000f8fa83fULL, 0x00000800040478a5ULL, 0x000fc8000f8e0010ULL,
0x00000400220478a5ULL, 0x000fcc000f8e0004ULL, 0x00000004ff047e24ULL, 0x004fe4000f8e00ffULL,
0x00000005ff057e24ULL, 0x000fe4000f8e00ffULL, 0x0000001017047825ULL, 0x000fca00078e0004ULL,
0x0000001804007986ULL, 0x0005e2000c101d18ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000580947ULL, 0x000fea0003800000ULL, 0x0000960000047ab9ULL, 0x000fe20000000a00ULL,
0xffffffff1f0b7890ULL, 0x000fe4000fffe03fULL, 0x000000040a0478a5ULL, 0x000fc8000f8e0004ULL,
0x0000000bff077e24ULL, 0x000fe4000f8e00ffULL, 0x00000004ff047e24ULL, 0x004fe4000f8e00ffULL,
0x00000005ff057e24ULL, 0x000fe2000f8e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0005ec0000008000ULL,
0x0000000000007992ULL, 0x004fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000007040479a8ULL, 0x000ea800099ee1d8ULL,
0x00000000ff00798fULL, 0x004fe20002000000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fc40000000000ULL, 0x0000065405047896ULL, 0x004fe20008000004ULL,
0x0000000b04007c0cULL, 0x000fc8000bf05270ULL, 0x00000001ff027807ULL, 0x000fca0000000000ULL,
0x00000002ff007988ULL, 0x0005e80008000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ef00000008800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000400000a7882ULL, 0x000fc40000000000ULL, 0x00000654040a7896ULL, 0x008fd2000800000aULL,
0x0000000aff027984ULL, 0x004ea40008000000ULL, 0x000000ff0200720cULL, 0x004fda0003f05270ULL,
0x00000024007c8947ULL, 0x000fea0003800000ULL, 0x0000001eff007c0cULL, 0x000fda000bf05270ULL,
0x0000000c008c0947ULL, 0x000fea0003800000ULL, 0x0000001fff007c0cULL, 0x000fda000bf05270ULL,
0x0000000000f08947ULL, 0x000fea0003800000ULL, 0x0000000108047890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe20000011600ULL,
0x00000080080c78a5ULL, 0x000fe4000f8e0010ULL, 0x00000080040478a5ULL, 0x000fe2000f8e0010ULL,
0x0000007002087812ULL, 0x000fe400078ec0ffULL, 0x0000000c03117812ULL, 0x000fc800078ec0ffULL,
0x0000000c11027c10ULL, 0x140fe4000f91e008ULL, 0x0000000411047c10ULL, 0x000fe4000fb5e008ULL,
0x0000000dff037c10ULL, 0x000fe400087e24ffULL, 0x00000005ff057c10ULL, 0x000fc600097e64ffULL,
0x0000001802067981ULL, 0x000568000c1e1900ULL, 0x0000001804077981ULL, 0x000562000c1e1900ULL,
0x000000021f00788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000b08947ULL, 0x004fea0003800000ULL, 0x0000000208047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e0010ULL, 0x0000000411027c10ULL, 0x000fc8000f91e008ULL,
0x00000005ff037c10ULL, 0x000fca00087e24ffULL, 0x0000001802097981ULL, 0x000562000c1e1900ULL,
0x000000041f00788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000908947ULL, 0x004fea0003800000ULL, 0x0000000308047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e0010ULL, 0x0000000411027c10ULL, 0x000fc8000f91e008ULL,
0x00000005ff037c10ULL, 0x000fca00087e24ffULL, 0x00000018020b7981ULL, 0x000562000c1e1900ULL,
0x000000041f00788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000708947ULL, 0x004fea0003800000ULL, 0x0000000408047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e0010ULL, 0x0000000411027c10ULL, 0x000fc8000f91e008ULL,
0x00000005ff037c10ULL, 0x000fca00087e24ffULL, 0x00000018020d7981ULL, 0x000562000c1e1900ULL,
0x000000061f00788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000508947ULL, 0x004fea0003800000ULL, 0x0000000508047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e0010ULL, 0x0000000411027c10ULL, 0x000fc8000f91e008ULL,
0x00000005ff037c10ULL, 0x000fca00087e24ffULL, 0x00000018020f7981ULL, 0x000562000c1e1900ULL,
0x000000061f00788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000308947ULL, 0x004fea0003800000ULL, 0x000000081f00788cULL, 0x000fe4000bf06070ULL,
0x0000000608047890ULL, 0x000fc8000fffe03fULL, 0x000000000000781cULL, 0x000fe20003f8f008ULL,
0x00000080040478a5ULL, 0x000fc8000f8e0010ULL, 0x00000007080c0890ULL, 0x000fe4000fffe03fULL,
0x0000000411027c10ULL, 0x000fe4000f91e008ULL, 0x000000800c0c08a5ULL, 0x000fe4000f8e0010ULL,
0x00000005ff037c10ULL, 0x000fc800087e24ffULL, 0x0000000c11044c10ULL, 0x000fe4000fb5e008ULL,
0x0000001802117981ULL, 0x000564000c1e1900ULL, 0x0000000dff054c10ULL, 0x000fca00097e64ffULL,
0x0000001804134981ULL, 0x000568000c1e1900ULL, 0x000000071f0b7890ULL, 0x000fc8000fffe03fULL,
0x000000033f0b7899ULL, 0x000fcc000801160bULL, 0x0000000bff007c0cULL, 0x000fda000bf05270ULL,
0x0000000800688947ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x024fe200078e0006ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x00000008000c7c82ULL, 0x000fe20008000000ULL,
0x0000003f00057c82ULL, 0x000fe20008000000ULL, 0x0000980000167ab9ULL, 0x000fca0000000a00ULL,
0x0000001f0400728cULL, 0x000fe4000bf06070ULL, 0x0000000105057890ULL, 0x000fc8000fffe03fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000b0500728cULL, 0x000fd8000bf06070ULL,
0x0000000800300947ULL, 0x024fea0003800000ULL, 0x00000008040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000506067209ULL, 0x000fe20007810000ULL, 0x00000001040e7890ULL, 0x000fe4000fffe03fULL,
0x0000001f0d00728cULL, 0x000fe4000bf26070ULL, 0x0000001f0e00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x000000080c0e7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800e0e78a5ULL, 0x000fe4000f8e0016ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000e03027c10ULL, 0x000fc8000f91e002ULL,
0x0000000fff037c10ULL, 0x000fca00087e24ffULL, 0x0000001802057981ULL, 0x000568000c1e1900ULL,
0x0000000400e82947ULL, 0x000fea0003800000ULL, 0x00000009040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000706067209ULL, 0x000fe20007810000ULL, 0x00000002040e7890ULL, 0x000fe4000fffe03fULL,
0x0000001f0d00728cULL, 0x000fe4000bf26070ULL, 0x0000001f0e00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x000000090c0e7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x004fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800e0e78a5ULL, 0x000fe4000f8e0016ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000e03027c10ULL, 0x000fc8000f91e002ULL,
0x0000000fff037c10ULL, 0x000fca00087e24ffULL, 0x0000001802077981ULL, 0x000568000c1e1900ULL,
0x0000000400a02947ULL, 0x000fea0003800000ULL, 0x0000000a040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000906067209ULL, 0x000fe20007810000ULL, 0x00000003040e7890ULL, 0x000fe4000fffe03fULL,
0x0000001f0d00728cULL, 0x000fe4000bf26070ULL, 0x0000001f0e00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000a0c0e7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x004fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800e0e78a5ULL, 0x000fe4000f8e0016ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000e03027c10ULL, 0x000fc8000f91e002ULL,
0x0000000fff037c10ULL, 0x000fca00087e24ffULL, 0x0000001802097981ULL, 0x000568000c1e1900ULL,
0x0000000400582947ULL, 0x000fea0003800000ULL, 0x0000000b040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000b06067209ULL, 0x000fe20007810000ULL, 0x00000004040e7890ULL, 0x000fe4000fffe03fULL,
0x0000001f0d00728cULL, 0x000fe4000bf26070ULL, 0x0000001f0e00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000b0c0e7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x004fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800e0e78a5ULL, 0x000fe4000f8e0016ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000e03027c10ULL, 0x000fc8000f91e002ULL,
0x0000000fff037c10ULL, 0x000fca00087e24ffULL, 0x00000018020b7981ULL, 0x000568000c1e1900ULL,
0x0000000400102947ULL, 0x000fea0003800000ULL, 0x0000000c040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000d06067209ULL, 0x000fe20007810000ULL, 0x00000005040e7890ULL, 0x000fe4000fffe03fULL,
0x0000001f0d00728cULL, 0x000fe4000bf26070ULL, 0x0000001f0e00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000c0c0e7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x004fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800e0e78a5ULL, 0x000fe4000f8e0016ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000e03027c10ULL, 0x000fc8000f91e002ULL,
0x0000000fff037c10ULL, 0x000fca00087e24ffULL, 0x00000018020d7981ULL, 0x000568000c1e1900ULL,
0x0000000000c82947ULL, 0x000fea0003800000ULL, 0x0000000d040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000f06067209ULL, 0x000fe20007810000ULL, 0x00000006040e7890ULL, 0x000fe4000fffe03fULL,
0x0000001f0d00728cULL, 0x000fe4000bf26070ULL, 0x0000001f0e00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000d0c0e7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x004fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800e0e78a5ULL, 0x000fe4000f8e0016ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000e03027c10ULL, 0x000fc8000f91e002ULL,
0x0000000fff037c10ULL, 0x000fca00087e24ffULL, 0x00000018020f7981ULL, 0x000568000c1e1900ULL,
0x0000000000802947ULL, 0x000fea0003800000ULL, 0x0000000e040d7890ULL, 0x000fe2000fffe03fULL,
0x0000001106067209ULL, 0x000fe20007810000ULL, 0x00000007040e7890ULL, 0x000fe4000fffe03fULL,
0x0000001f0d00728cULL, 0x000fe4000bf26070ULL, 0x0000001f0e00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000e0c0e7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x004fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800e0e78a5ULL, 0x000fe4000f8e0016ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000e03027c10ULL, 0x000fc8000f91e002ULL,
0x0000000fff037c10ULL, 0x000fca00087e24ffULL, 0x0000001802117981ULL, 0x000568000c1e1900ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x0000000f040d7890ULL, 0x000fe2000fffe03fULL,
0x0000001306067209ULL, 0x000fc60007810000ULL, 0x0000001f0d00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000f0c0e7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x004fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800e0e78a5ULL, 0x000fe4000f8e0016ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000e03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000fff037c10ULL, 0x000fca00087e24ffULL,
0x0000001802137981ULL, 0x000568000c1e1900ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000804047890ULL, 0x000fe4000fffe03fULL, 0x000000080c0c7890ULL, 0x000fd4000fffe03fULL,
0xfffffff400ac8947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ee40000000000ULL,
0x0000001000027824ULL, 0x00cfe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000a03037c10ULL, 0x000fca000fffe002ULL, 0x0000000603007388ULL, 0x0205e40000000800ULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x0000000806167290ULL, 0x000fe2000fffe03fULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000a06047291ULL, 0x000fe2000f8e683fULL,
0x0000001000027824ULL, 0x040fe200078e00ffULL, 0x00000016090e7291ULL, 0x000fe2000f8fa83fULL,
0x00000001ff037819ULL, 0x004fe20000011600ULL, 0x000000091e0b7899ULL, 0x000fe2000800063fULL,
0x0000002000077836ULL, 0x000fe20000000000ULL, 0x00009800000c7ab9ULL, 0x000fe20000000a00ULL,
0x000000023f057899ULL, 0x000fe2000801161eULL, 0x0000007002027812ULL, 0x000fe200078ec0ffULL,
0x000008000e0e78a5ULL, 0x000fe2000f8e000cULL, 0x0000000c03037812ULL, 0x000fe200078ec0ffULL,
0x00000000003f7886ULL, 0x000fe20000000000ULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x00000400220e78a5ULL, 0x000fe2000f8e000eULL, 0x0000000a03147c10ULL, 0x000fe2000fffe002ULL,
0x0000000422047291ULL, 0x000fe2000f8e603fULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000016151a8290ULL, 0x000fe2000fffe03fULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000a061b8291ULL, 0x000fe2000f8e483fULL, 0x0000000eff047e24ULL, 0x000fe2000f8e00ffULL,
0x0000000a061c8291ULL, 0x000fe2000f8e483fULL, 0x0000000fff057e24ULL, 0x000fe2000f8e00ffULL,
0x000008000b0b7892ULL, 0x000fe2000f8ec03fULL, 0x0000000014147984ULL, 0x000ea20000000800ULL,
0x00000080161688a5ULL, 0x000fe2000f8e000cULL, 0x0000001007067825ULL, 0x100fe200078e0004ULL,
0x0000000105057892ULL, 0x000fe2000f8ec03fULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000801a0c88a5ULL, 0x000fe2000f8e000cULL, 0x0000001000047825ULL, 0x040fe200078e0004ULL,
0x0000001b221b8291ULL, 0x000fe2000f8e403fULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000001c221c8291ULL, 0x000fe2000f8e403fULL, 0x00000016ff0a7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000b040b7290ULL, 0x000fe2000fffe03fULL, 0x0000000cff087e24ULL, 0x000fe2000f8e00ffULL,
0x0000001b051b8291ULL, 0x000fe2000f8e383fULL, 0x0000000dff097e24ULL, 0x000fe2000f8e00ffULL,
0x0000001c051c8291ULL, 0x000fe2000f8e383fULL, 0x00000017ff0b7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000b000d7c11ULL, 0x040fe2000f8e20ffULL, 0x0000001000088825ULL, 0x040fe200078e0008ULL,
0x0000001b000f8c11ULL, 0x040fe2000f8e20ffULL, 0x0000001f0600728cULL, 0x000fe2000bf06070ULL,
0x0000001c00118c11ULL, 0x040fe2000f8e20ffULL, 0x00000010000a8825ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000040d7faeULL, 0x0005e2000b901c58ULL,
0x0000000000287805ULL, 0x000fc4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00380000060d7faeULL, 0x0005e2000b901c58ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x04580000080f8faeULL, 0x0005e2000b901c58ULL,
0x00000000002e7805ULL, 0x000fc4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x041800000a118faeULL, 0x0005e2000b901c58ULL,
0x000000000000781cULL, 0x000fe40003f0f008ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000347805ULL, 0x000fce000001ff00ULL, 0x0000000800980947ULL, 0x004fea0003800000ULL,
0x00000003ff047819ULL, 0x100fe20000011600ULL, 0x0000000a06057291ULL, 0x000fe2000f8e483fULL,
0xfffffff8ff057812ULL, 0x000fe200078ee200ULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x0000000304047812ULL, 0x000fe200078ec0ffULL, 0x0000000522057291ULL, 0x000fe2000f8e403fULL,
0x00000002ff377819ULL, 0x000fe20000011600ULL, 0x0000000805097836ULL, 0x040fe20000000000ULL,
0x0000000404067812ULL, 0x000fe200078efcffULL, 0x0000000805387824ULL, 0x000fe200078e00ffULL,
0x0000000704077812ULL, 0x000fe200078e7805ULL, 0x00000008373b7836ULL, 0x000fe20000000000ULL,
0x0000000704047812ULL, 0x000fe200078e7809ULL, 0x00000005ff3d7e24ULL, 0x000fe2000f8e00ffULL,
0x00000007063a7812ULL, 0x000fe200078e7809ULL, 0x0000000809097824ULL, 0x000fe200078e00ffULL,
0x0000000706057812ULL, 0x000fe200078e7805ULL, 0x0000000600057c82ULL, 0x000fe20008000000ULL,
0x0000003807367212ULL, 0x080fe200078efcffULL, 0x00009800001c7ab9ULL, 0x000fe20000000a00ULL,
0x0000003805387212ULL, 0x000fc400078efcffULL, 0x0000000904397212ULL, 0x080fe400078efcffULL,
0x000000093a3a7212ULL, 0x000fce00078efcffULL, 0x00000002050b7890ULL, 0x000fc8000fffe03fULL,
0x0000001f0b00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000b00947ULL, 0x000fea0003800000ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x0000000b08167290ULL, 0x000fe2000fffe03fULL, 0x0000002000077836ULL, 0x000fe20000000000ULL,
0x0000000a0b0e7899ULL, 0x000fe4000800063fULL, 0x000000013f0c7899ULL, 0x000fe4000801160bULL,
0x00000016090d7291ULL, 0x000fe4000f8fa83fULL, 0x000008000e0e7892ULL, 0x000fe4000f8ec03fULL,
0x000000010c1b7892ULL, 0x000fc4000f8ec03fULL, 0x00000000003f7886ULL, 0x000fe20000000000ULL,
0x000008000d0c78a5ULL, 0x000fe4000f8e001cULL, 0x0000000e041a7290ULL, 0x000fe2000fffe03fULL,
0x0000001bff0c7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000a060f8291ULL, 0x000fe4000f8e483fULL,
0x0000000a06208291ULL, 0x000fe4000f8e483fULL, 0x0000000f22218291ULL, 0x000fe2000f8e403fULL,
0x0000001a000d7c11ULL, 0x000fe2000f8e20ffULL, 0x00000016150e8290ULL, 0x000fc4000fffe03fULL,
0x00000400220c78a5ULL, 0x000fe4000f8e000cULL, 0x0000002022208291ULL, 0x000fe2000f8e403fULL,
0x00000021ff3d8e24ULL, 0x000fe2000f8e00ffULL, 0x000000800e0e88a5ULL, 0x000fe4000f8e001cULL,
0x00000080161688a5ULL, 0x000fe2000f8e001cULL, 0x000000800c0f8824ULL, 0x000fe400078e023dULL,
0x0000000cff047e24ULL, 0x000fe4000f8e00ffULL, 0x0000000dff057e24ULL, 0x000fc4000f8e00ffULL,
0x00000020ff3d8e24ULL, 0x000fe4000f8e00ffULL, 0x0000000eff087e24ULL, 0x000fe4000f8e00ffULL,
0x0000000fff097e24ULL, 0x000fe4000f8e00ffULL, 0x00000016ff0a7e24ULL, 0x000fe4000f8e00ffULL,
0x00000017ff0b7e24ULL, 0x000fe4000f8e00ffULL, 0x0000001007067825ULL, 0x000fc800078e0004ULL,
0x000000800c118824ULL, 0x000fe400078e023dULL, 0x0000001000047825ULL, 0x000fc800078e0004ULL,
0x0000001000088825ULL, 0x040fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000040d7faeULL, 0x0005e6000b901c58ULL, 0x00000010000f8824ULL, 0x040fe200078e020fULL,
0x00380000060d7faeULL, 0x0005e2000b901c58ULL, 0x00000010000a8825ULL, 0x000fc600078e000aULL,
0x04580000080f8faeULL, 0x0005e2000b901c58ULL, 0x0000001000118824ULL, 0x000fca00078e0211ULL,
0x041800000a118faeULL, 0x0005e4000b901c58ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000005000c7c82ULL, 0x000fe40008000000ULL, 0x000000060c057899ULL, 0x000fc8000800063fULL,
0x0000008005057892ULL, 0x000fcc000f8ec03fULL, 0x0000000502047c10ULL, 0x004fe2000fffe03dULL,
0x0000000a0c057899ULL, 0x000fc8000800063fULL, 0x00000001033c7824ULL, 0x000fe200078e0204ULL,
0x0000080005057892ULL, 0x000fc8000f8ec03fULL, 0x0000018004057890ULL, 0x000fe2000fffe005ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180003c0d7984ULL, 0x000ea20000000800ULL,
0x0000000536047c11ULL, 0x000fe4000f8e20ffULL, 0x0000000538087c11ULL, 0x000fe2000f8e20ffULL,
0x004580003c3f7984ULL, 0x000fe20000000800ULL, 0x00000005390c7c11ULL, 0x000fe4000f8e20ffULL,
0x000000053a107c11ULL, 0x000fe2000f8e20ffULL, 0x000000000404783bULL, 0x000ee20000000200ULL,
0x0000000b00057c82ULL, 0x000fe40008000000ULL, 0x0000001f0500728cULL, 0x000fe2000bf06070ULL,
0x000000000808783bULL, 0x000f2a0000000200ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000d14117221ULL, 0x004fc40000010100ULL, 0x000000000c0c783bULL, 0x000ea40000000200ULL,
0x3fb8aa3b11407820ULL, 0x000fe40000410000ULL, 0x000000001010783bULL, 0x000f620000000200ULL,
0x20000005ff417230ULL, 0x008fc60000004100ULL, 0x0000004000407308ULL, 0x000ee20000000800ULL,
0x30000005ff3c7230ULL, 0x000fe40000004100ULL, 0x20000007ff437230ULL, 0x000fe40000004100ULL,
0x30000007ff3e7230ULL, 0x000fe40000004100ULL, 0x20000009ff457230ULL, 0x010fe40000004100ULL,
0x2000000bff477230ULL, 0x000fe40000004100ULL, 0x3000000bff427230ULL, 0x000fc40000004100ULL,
0x20000006ff057230ULL, 0x000fe40000004100ULL, 0x0000003f404c7220ULL, 0x008fe20000410000ULL,
0x30000009ff407230ULL, 0x000fe40000004100ULL, 0x20000004ff3f7230ULL, 0x000fe40000004100ULL,
0x000000354c357221ULL, 0x000fe20000010000ULL, 0x00001f374c4e7589ULL, 0x000ee200000e0000ULL,
0x20000008ff077230ULL, 0x000fe40000004100ULL, 0x2000000aff097230ULL, 0x000fe20000004100ULL,
0x00001f3b4c507589ULL, 0x000f2200000e0000ULL, 0x30000004ff047230ULL, 0x000fc40000004100ULL,
0x30000006ff067230ULL, 0x000fe40000004100ULL, 0x30000008ff087230ULL, 0x000fe40000004100ULL,
0x3000000aff0a7230ULL, 0x000fe40000004100ULL, 0x2000000dff497230ULL, 0x004fe40000004100ULL,
0x3000000dff447230ULL, 0x000fe40000004100ULL, 0x2000000fff4b7230ULL, 0x000fc40000004100ULL,
0x3000000fff467230ULL, 0x000fe40000004100ULL, 0x20000011ff4d7230ULL, 0x020fe40000004100ULL,
0x30000011ff487230ULL, 0x000fe40000004100ULL, 0x0000004e3f347223ULL, 0x088fe20000010034ULL,
0x2000000cff0b7230ULL, 0x000fe40000004100ULL, 0x0000004e04337223ULL, 0x000fe20000010033ULL,
0x2000000eff0d7230ULL, 0x000fc40000004100ULL, 0x0000004e41327223ULL, 0x080fe20000010032ULL,
0x20000010ff0f7230ULL, 0x000fe40000004100ULL, 0x0000004e3c317223ULL, 0x080fe20000010031ULL,
0x20000012ff117230ULL, 0x000fe40000004100ULL, 0x0000004e05307223ULL, 0x080fe20000010030ULL,
0x3000000cff0c7230ULL, 0x000fe40000004100ULL, 0x0000004e062f7223ULL, 0x000fe2000001002fULL,
0x3000000eff0e7230ULL, 0x000fc40000004100ULL, 0x0000004e432e7223ULL, 0x080fe2000001002eULL,
0x30000010ff107230ULL, 0x000fe40000004100ULL, 0x0000004e3e2d7223ULL, 0x080fe2000001002dULL,
0x30000012ff127230ULL, 0x000fe40000004100ULL, 0x0000004e072c7223ULL, 0x080fe2000001002cULL,
0x20000013ff4f7230ULL, 0x000fe40000004100ULL, 0x0000004e082b7223ULL, 0x000fe2000001002bULL,
0x30000013ff4a7230ULL, 0x000fc40000004100ULL, 0x0000004e452a7223ULL, 0x080fe2000001002aULL,
0x0000004e40297223ULL, 0x080fe20000010029ULL, 0x0000004e09287223ULL, 0x080fe20000010028ULL,
0x0000004e0a277223ULL, 0x080fe20000010027ULL, 0x0000004e47267223ULL, 0x080fe20000010026ULL,
0x0000004e42257223ULL, 0x000fe20000010025ULL, 0x000000500b247223ULL, 0x090fe20000010024ULL,
0x000000500c237223ULL, 0x080fe20000010023ULL, 0x0000005049227223ULL, 0x080fe20000010022ULL,
0x0000005044217223ULL, 0x080fe20000010021ULL, 0x000000500d207223ULL, 0x080fe20000010020ULL,
0x000000500e1f7223ULL, 0x080fe2000001001fULL, 0x000000504b1e7223ULL, 0x080fe2000001001eULL,
0x00000050461d7223ULL, 0x080fe2000001001dULL, 0x000000500f1c7223ULL, 0x080fe2000001001cULL,
0x00000050101b7223ULL, 0x080fe2000001001bULL, 0x000000504d1a7223ULL, 0x080fe2000001001aULL,
0x0000005048197223ULL, 0x080fe20000010019ULL, 0x0000005011187223ULL, 0x080fe20000010018ULL,
0x0000005012177223ULL, 0x080fe20000010017ULL, 0x000000504f167223ULL, 0x080fe20000010016ULL,
0x000000504a157223ULL, 0x000fe20000010015ULL, 0xfffffff400c48947ULL, 0x000fec000383ffffULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x00000022ff007c0cULL, 0x000fe2000bf05270ULL,
0x000049800a047890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x004fe200078e00ffULL,
0x00000001ff007819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c00037812ULL, 0x000fc800078ec0ffULL, 0x0000000403027c10ULL, 0x000fe2000fffe002ULL,
0x0000000000200947ULL, 0x000fec0003800000ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000000a060a7291ULL, 0x000fe2000f8e383fULL, 0x0000001000037824ULL, 0x004fe200078e00ffULL,
0x00000001ff047819ULL, 0x000fc80000011600ULL, 0x0000007003007812ULL, 0x000fe400078ec0ffULL,
0x0000000c04037812ULL, 0x000fc800078ec0ffULL, 0x0000000a03007c10ULL, 0x000fca000fffe000ULL,
0x0049803500007388ULL, 0x0005e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000002007984ULL, 0x004ea80000000800ULL, 0x0000800002037984ULL, 0x000ee20000000800ULL,
0x00000000ff007221ULL, 0x004fc80000010000ULL, 0x0000000300007221ULL, 0x008fc80000010000ULL,
0x0180000000037836ULL, 0x000fca0000000000ULL, 0x7f80000003037812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff597224ULL, 0x002fe200078e0000ULL,
0x000096a000027802ULL, 0x000fce0000000f00ULL, 0x0000008000387944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x00cfe200078e0000ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000000037308ULL, 0x000ea40000001000ULL, 0xbf80000000027423ULL, 0x004fc80000000003ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000203027223ULL, 0x000fce0000000003ULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x00000002ff097819ULL, 0x104fe40000011600ULL,
0x00000008000d7811ULL, 0x000fe400078ff0ffULL, 0x00000003ff037819ULL, 0x000fe20000011600ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0902047589ULL, 0x000ea200000e0000ULL,
0xfffffff8ff0f7812ULL, 0x000fc600078ee200ULL, 0x00001f0d020d7589ULL, 0x00072400000e0000ULL,
0x000000080f137836ULL, 0x040fe20000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000080f0e7824ULL, 0x000fe400078e00ffULL, 0x0000003404347220ULL, 0x044fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000003204057220ULL, 0x040fe20000410000ULL,
0x0000003104067220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000002e04077220ULL, 0x040fe20000410000ULL,
0x0000002d04087220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002a04097220ULL, 0x040fe20000410000ULL,
0x0000002904027220ULL, 0x048fe20000410000ULL, 0x00000028040a7220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x00000026040b7220ULL, 0x040fe20000410000ULL,
0x00000025040c7220ULL, 0x000fe20000410000ULL, 0x0000000303047812ULL, 0x000fe200078ec0ffULL,
0x000000240d247220ULL, 0x050fe20000410000ULL, 0x000000230d237220ULL, 0x040fe20000410000ULL,
0x000000220d227220ULL, 0x040fe20000410000ULL, 0x0000000404107812ULL, 0x000fe200078efcffULL,
0x000000210d217220ULL, 0x040fe20000410000ULL, 0x000000200d207220ULL, 0x040fe20000410000ULL,
0x0000001f0d1f7220ULL, 0x040fe20000410000ULL, 0x0000001e0d1e7220ULL, 0x040fe20000410000ULL,
0x0000001d0d1d7220ULL, 0x040fe20000410000ULL, 0x0000001c0d1c7220ULL, 0x040fe20000410000ULL,
0x0000001b0d1b7220ULL, 0x040fe20000410000ULL, 0x0000001a0d1a7220ULL, 0x040fe20000410000ULL,
0x000000190d197220ULL, 0x040fe20000410000ULL, 0x000000180d187220ULL, 0x040fe20000410000ULL,
0x000000170d177220ULL, 0x040fe20000410000ULL, 0x000000160d167220ULL, 0x040fe20000410000ULL,
0x000000150d0d7220ULL, 0x000fe20000410000ULL, 0x0000000704117812ULL, 0x000fc400078e780fULL,
0x0000000704157812ULL, 0x000fe200078e7813ULL, 0x0000000813047824ULL, 0x000fe200078e00ffULL,
0x00000007100f7812ULL, 0x000fe400078e780fULL, 0x0000000710137812ULL, 0x000fe400078e7813ULL,
0x0000000e11117212ULL, 0x080fe400078efcffULL, 0x0000000e0f0f7212ULL, 0x000fe400078efcffULL,
0x0000000415157212ULL, 0x000fc400078efcffULL, 0x0000000413137212ULL, 0x000fe400078efcffULL,
0x000000050605723eULL, 0x000fe400000000ffULL, 0x000000090209723eULL, 0x000fe400000000ffULL,
0x000000343304723eULL, 0x000fe400000000ffULL, 0x000000302f06723eULL, 0x000fe400000000ffULL,
0x000000070807723eULL, 0x000fc400000000ffULL, 0x000000201f26723eULL, 0x000fe400000000ffULL,
0x0000001311027c11ULL, 0x000fe4000f8e20ffULL, 0x0000002c2b08723eULL, 0x000fe400000000ffULL,
0x0000000a270a723eULL, 0x000fe200000000ffULL, 0x0000000402007844ULL, 0x000fe20000000200ULL,
0x0000000b0c0b723eULL, 0x000fe200000000ffULL, 0x00000014000c7c36ULL, 0x000fe20008000000ULL,
0x000000222125723eULL, 0x000fc400000000ffULL, 0x000000130f207c11ULL, 0x000fe4000f8e20ffULL,
0x000000242324723eULL, 0x000fe400000000ffULL, 0x0000001e1d27723eULL, 0x000fe200000000ffULL,
0x0000000820007844ULL, 0x000fe20000000200ULL, 0x0000001315217c11ULL, 0x000fe4000f8e20ffULL,
0x0000001c1b1c723eULL, 0x000fe400000000ffULL, 0x0000001a191d723eULL, 0x000fe200000000ffULL,
0x0000002421007844ULL, 0x000fe20000000200ULL, 0x00000018171e723eULL, 0x000fc400000000ffULL,
0x000000160d1f723eULL, 0x000fe400000000ffULL, 0x0000001313227c11ULL, 0x000fe4000f8e20ffULL,
0x000000070c237c11ULL, 0x000fc6000f8e20ffULL, 0x0000001c22007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000230c7984ULL, 0x000ea80000000c00ULL,
0x0004000023147984ULL, 0x000ee80000000c00ULL, 0x0008000023107984ULL, 0x000f280000000c00ULL,
0x000c000023187984ULL, 0x000f620000000c00ULL, 0x200000ff0f0f7230ULL, 0x004fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x008fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x000000130f0f7230ULL, 0x010fe40000000000ULL,
0x000000120e0e7230ULL, 0x000fe40000000000ULL, 0x000000110d0d7230ULL, 0x000fe40000000000ULL,
0x000000100c0c7230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x020fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000c23007388ULL, 0x0005e20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001423007388ULL, 0x0005e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000006ff007c0cULL, 0x000fda000bf05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000ee20000002600ULL, 0x0000002000137836ULL, 0x000fe20000000000ULL,
0x0000000703057812ULL, 0x000fe200078e4800ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x0000000322067899ULL, 0x000fe2000800063fULL,
0x00000003ff047819ULL, 0x000fe20000011613ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0ffffff805077812ULL, 0x000fe200078ef800ULL, 0x0000860000087ab9ULL, 0x000fe20000000a00ULL,
0x0000000704027812ULL, 0x000fe200078e4813ULL, 0x00000006ff127e24ULL, 0x000fc6000f8e00ffULL,
0x0ffffff802057812ULL, 0x000fe400078ef813ULL, 0x0000000707027c11ULL, 0x000fe4000f8e20ffULL,
0x0000000705057c11ULL, 0x000fc6000f8e20ffULL, 0x0000000002087984ULL, 0x000f680000000c00ULL,
0x00000000050c7984ULL, 0x0045620000000c00ULL, 0x00000005040472a4ULL, 0x010fe4000f8e023fULL,
0x0000000322057899ULL, 0x000fe2000800063fULL, 0x0000000806107824ULL, 0x048fe400078e00ffULL,
0x0000000806077824ULL, 0x000fc600078e00ffULL, 0x00000005ff117e24ULL, 0x000fe2000f8e00ffULL,
0xfffffff810037812ULL, 0x000fe400078ee203ULL, 0xfffffff807047812ULL, 0x000fe400078ee204ULL,
0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000404057c10ULL, 0x004fe4000ff3e0ffULL,
0xfffffff811117812ULL, 0x000fe200078ee200ULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x0000000803027c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x0000000805047c11ULL, 0x000fc4000f8240ffULL, 0x0000000903037c11ULL, 0x000fe400080f4410ULL,
0x0000000905057c11ULL, 0x000fe400088f4406ULL, 0xfffffff812077812ULL, 0x000fe200078ee213ULL,
0x0000001011027825ULL, 0x000fc800078e0002ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x020fe8000c101d18ULL, 0x0000000c04007986ULL, 0x002fe2000c101d18ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000005b0f72caULL, 0x000fe200000e0000ULL,
0x000000013f067899ULL, 0x000fe2000801161eULL, 0x00000001ff027424ULL, 0x000fcc00078e00ffULL,
0x01b60002ff0279a7ULL, 0x000e6a0008500007ULL, 0x000000060f067291ULL, 0x000fc8000f8e083fULL,
0x000000050600728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x0000000104098899ULL, 0x000fe2000800063fULL, 0x00009000000b8ab9ULL, 0x000fe20000000800ULL,
0x00008c00000c8ab9ULL, 0x000fe40000000a00ULL, 0x0000000b090982a4ULL, 0x000fc8000f8e0206ULL,
0x00000004090c88a5ULL, 0x000fcc000f8e000cULL, 0x0000000cff047e24ULL, 0x000fe4000f8e00ffULL,
0x0000000dff057e24ULL, 0x000fca000f8e00ffULL, 0x0000001804048981ULL, 0x000ea2000c1e1900ULL,
0x000000015b067836ULL, 0x000fe20000000000ULL, 0x000000061e117899ULL, 0x000fe4000800063fULL,
0x000000070a0a7899ULL, 0x000fe4000800063fULL, 0x000000110f0c7291ULL, 0x000fe4000f8e403fULL,
0x000000070e097899ULL, 0x000fe2000800063fULL, 0xffffffff00147882ULL, 0x000fe20000000000ULL,
0x000000400a0d7892ULL, 0x000fe2000f8ef80cULL, 0x00000000040b82caULL, 0x004fc400000e0000ULL,
0x0000000806007c0cULL, 0x000fd6000bf06070ULL, 0x0000000b00148c82ULL, 0x000fe40008000000ULL,
0x00000009140e72a4ULL, 0x000fe2000f8e023fULL, 0x0000000c00a88947ULL, 0x002ff60003800000ULL,
0x00000003ff047819ULL, 0x000fe2000001160bULL, 0x0000000c2300728cULL, 0x000fe2000bf01070ULL,
0x0000007000007812ULL, 0x000fe200078ec0ffULL, 0x00008a0000127ab9ULL, 0x000fe40000000a00ULL,
0x00000008040a7836ULL, 0x040fe20000000000ULL, 0x0000000c230b7287ULL, 0x000fe2000c000000ULL,
0x0000000d04057c36ULL, 0x000fe40008000000ULL, 0x000000080a0d7824ULL, 0x040fe200078e00ffULL,
0x0000000b0c0b7290ULL, 0x000fe2000fffe13fULL, 0x0000000b0a087212ULL, 0x080fe200078e3cffULL,
0x0000000404067836ULL, 0x040fe20000000000ULL, 0x000000071e0c7291ULL, 0x000fe2000f8e703fULL,
0x0000000c040c7836ULL, 0x000fe20000000000ULL, 0xfffffff80d187812ULL, 0x000fe200078ee208ULL,
0x0000000806167824ULL, 0x040fe200078e00ffULL, 0x0000000e05087c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000d06057c36ULL, 0x040fe20008000000ULL, 0x0000000b06077212ULL, 0x080fe200078e3cffULL,
0x0000001004107836ULL, 0x000fe20000000000ULL, 0x0000000b06007c0cULL, 0x000fe2000bf46070ULL,
0x0000000d0a067c36ULL, 0x000fe20008000000ULL, 0xfffffff816167812ULL, 0x000fe200078ee207ULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x00000012080f7c11ULL, 0x000fe2000f8240ffULL,
0x000000080c1a7824ULL, 0x000fe200078e00ffULL, 0x0000000e06147c10ULL, 0x000fe2000ff9e0ffULL,
0x0000000d10067c36ULL, 0x000fe20008000000ULL, 0x0000000b0a007c0cULL, 0x000fe2000bf06070ULL,
0x00000014041e7836ULL, 0x000fe20000000000ULL, 0x0000001308087c11ULL, 0x000fe200088f4407ULL,
0x000000ffff077224ULL, 0x000fe200020e06ffULL, 0x0000000e050a7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000d0c057c36ULL, 0x040fe20008000000ULL, 0x0000000b0c097212ULL, 0x000fe200078e3cffULL,
0x000010000c0c7890ULL, 0x000fe2000fffe03fULL, 0x0000001214157c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee209ULL,
0x000000081e207824ULL, 0x000fe200078e00ffULL, 0x000000120a097c11ULL, 0x000fe2000f8640ffULL,
0x0000001c04227836ULL, 0x000fe20000000000ULL, 0x0000001314147c11ULL, 0x000fc4000a0f4407ULL,
0x0000000e06067c10ULL, 0x000fe4000ff9e0ffULL, 0x000000130a0a7c11ULL, 0x000fe200098f440dULL,
0x00000008100d7824ULL, 0x000fe200078e00ffULL, 0x0000000e050e7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff057224ULL, 0x000fe200020e06ffULL, 0x0000001206197c11ULL, 0x000fe4000f8a40ffULL,
0x0000000b0c007c0cULL, 0x000fe2000bf26070ULL, 0x000000ffff077224ULL, 0x000fe200018e06ffULL,
0x0000001306127c11ULL, 0x000fe2000a8f4405ULL, 0x0000000d1e057c36ULL, 0x000fe20008000000ULL,
0x000000120e117c11ULL, 0x000fc4000f8640ffULL, 0x0000000f00067210ULL, 0x000fe40007fbe0ffULL,
0x0000000b100c7212ULL, 0x000fe400078e3cffULL, 0x000000130e0e7c11ULL, 0x000fe200098f4407ULL,
0x000000ffff077224ULL, 0x000fe200028e0608ULL, 0xfffffff80d1c7812ULL, 0x000fe400078ee20cULL,
0x00000007040c7812ULL, 0x000fe400078e480bULL, 0x0000000900087210ULL, 0x000fc40007fbe0ffULL,
0x0000000b10007c0cULL, 0x000fe4000bf86070ULL, 0x0000000e05107c10ULL, 0x000fe2000ffde0ffULL,
0x000000ffff097224ULL, 0x000fe200028e060aULL, 0x0000000b04007c0cULL, 0x000fe4000bf66070ULL,
0x0000000b1e057212ULL, 0x040fe200078e3cffULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0x0ffffff80c0c7812ULL, 0x000fe400078ef80bULL, 0x0000000b1e007c0cULL, 0x000fc4000bfa6070ULL,
0xfffffff8201e7812ULL, 0x000fe400078ee205ULL, 0x0000000c0c057c11ULL, 0x000fe2000f8e20ffULL,
0x00000018040c7836ULL, 0x000fe20000000000ULL, 0x0000000c160f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001210137c11ULL, 0x000fe2000f8c40ffULL, 0x0000000d0c0a7c36ULL, 0x040fe20008000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e2000d901c58ULL,
0x000000080c177824ULL, 0x000fe200078e00ffULL, 0x0000001310107c11ULL, 0x000fc4000b0f440dULL,
0x00000000080f7faeULL, 0x0005e2000d101c58ULL, 0x0000000e0a0a7c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000b0c167212ULL, 0x000fe400078e3cffULL, 0x000000120a1d7c11ULL, 0x000fe2000f8c40ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e06ffULL, 0xfffffff817207812ULL, 0x000fe200078ee216ULL,
0x0000000d22057c36ULL, 0x002fe20008000000ULL, 0x0000000b0c007c0cULL, 0x000fe4000bf66070ULL,
0x000000130a167c11ULL, 0x000fe2000b0f440dULL, 0x00000008220a7824ULL, 0x000fe200078e00ffULL,
0x0000000e05177c10ULL, 0x000fc4000ffde0ffULL, 0x00000015000c7210ULL, 0x000fe40007f5e0ffULL,
0x0000000b22057212ULL, 0x000fe200078e3cffULL, 0x000000ffff087224ULL, 0x004fe200030e06ffULL,
0x0000001217157c11ULL, 0x040fe2000f8c40ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e0614ULL,
0x0000001100067210ULL, 0x000fe40007f5e0ffULL, 0x0000001317177c11ULL, 0x000fe2000b0f4408ULL,
0x0000002004087836ULL, 0x000fe20000000000ULL, 0xfffffff80a217812ULL, 0x000fe200078ee205ULL,
0x000000ffff077224ULL, 0x000fe200010e060eULL, 0x0000000c18057c11ULL, 0x000fe2000f8e20ffULL,
0x0000000d08097c36ULL, 0x000fe20008000000ULL, 0x0000000c1a0f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000024040e7836ULL, 0x000fe20000000000ULL, 0x0000000b22007c0cULL, 0x000fe2000bf46070ULL,
0x000000000c057faeULL, 0x0003e2000c101c58ULL, 0x0000000b08007c0cULL, 0x040fe2000bf06070ULL,
0x00000008080a7824ULL, 0x000fc400078e00ffULL, 0x00000000060f7faeULL, 0x0005e2000c901c58ULL,
0x0000000e091a7c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000b08097212ULL, 0x000fe400078e3cffULL,
0x000000121a1f7c11ULL, 0x000fe2000f8c40ffULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x0000001900087210ULL, 0x000fe20007f3e0ffULL, 0x0000000d0e057c36ULL, 0x042fe20008000000ULL,
0xfffffff80a0a7812ULL, 0x000fe200078ee209ULL, 0x000000080e0c7824ULL, 0x000fe200078e00ffULL,
0x000000131a1a7c11ULL, 0x000fe2000b0f4411ULL, 0x000000ffff097224ULL, 0x000fe200008e0612ULL,
0x0000001300067210ULL, 0x004fe20007f3e0ffULL, 0x0000002c04127836ULL, 0x000fe20000000000ULL,
0x0000000e05187c10ULL, 0x000fc4000ffde0ffULL, 0x0000000b0e057212ULL, 0x040fe200078e3cffULL,
0x000000ffff077224ULL, 0x000fe200008e0610ULL, 0x0000000b0e007c0cULL, 0x000fe2000bf26070ULL,
0x000000ffff0d7224ULL, 0x000fe200030e06ffULL, 0x00000012181b7c11ULL, 0x000fe4000f8c40ffULL,
0xfffffff80c0e7812ULL, 0x000fe200078ee205ULL, 0x00000028040c7836ULL, 0x000fe20000000000ULL,
0x0000000c1c057c11ULL, 0x000fe4000f8e20ffULL, 0x0000001318187c11ULL, 0x000fe2000b0f440dULL,
0x0000000d0c0d7c36ULL, 0x000fe20008000000ULL, 0x0000000c1e0f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000008057faeULL, 0x0003e2000e101c58ULL, 0x0000000b0c007c0cULL, 0x040fe2000bf86070ULL,
0x000000080c107824ULL, 0x000fc400078e00ffULL, 0x00000000060f7faeULL, 0x0005e2000e901c58ULL,
0x0000000e0d197c10ULL, 0x000fe4000ffbe0ffULL, 0x0000000b0c0d7212ULL, 0x000fe400078e3cffULL,
0x0000001219137c11ULL, 0x040fe2000f8c40ffULL, 0x000000ffff147224ULL, 0x000fe200028e06ffULL,
0x0000001d000c7210ULL, 0x000fe20007fbe0ffULL, 0x0000000d12057c36ULL, 0x042fe20008000000ULL,
0xfffffff810107812ULL, 0x000fe200078ee20dULL, 0x0000000812087824ULL, 0x000fe200078e00ffULL,
0x0000001319197c11ULL, 0x000fe2000b0f4414ULL, 0x000000ffff0d7224ULL, 0x000fe200028e0616ULL,
0x0000000e05167c10ULL, 0x000fc4000ffde0ffULL, 0x0000000b12057212ULL, 0x080fe400078e3cffULL,
0x0000001500067210ULL, 0x004fe20007fbe0ffULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x00000012161d7c11ULL, 0x000fe4000f8c40ffULL, 0xfffffff808117812ULL, 0x000fe200078ee205ULL,
0x0000003004087836ULL, 0x000fe20000000000ULL, 0x0000000c20057c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff077224ULL, 0x000fe200028e0617ULL, 0x0000001316167c11ULL, 0x000fe2000b0f4409ULL,
0x0000000d08097c36ULL, 0x000fe20008000000ULL, 0x0000000c210f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000000c057faeULL, 0x0003e2000d901c58ULL, 0x0000000b12007c0cULL, 0x000fe2000bfa6070ULL,
0x0000003404127836ULL, 0x000fe20000000000ULL, 0x0000000b08007c0cULL, 0x040fe2000bf66070ULL,
0x00000000060f7faeULL, 0x0005e2000d101c58ULL, 0x0000000e09177c10ULL, 0x000fe2000ff5e0ffULL,
0x00000008081c7824ULL, 0x040fe200078e00ffULL, 0x0000000b08097212ULL, 0x000fc400078e3cffULL,
0x0000001217157c11ULL, 0x040fe2000f8c40ffULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x0000001f00087210ULL, 0x000fe20007f5e0ffULL, 0x0000000d12057c36ULL, 0x042fe20008000000ULL,
0xfffffff81c0c7812ULL, 0x000fe400078ee209ULL, 0x0000001317177c11ULL, 0x000fe2000b0f4414ULL,
0x000000ffff097224ULL, 0x000fe200010e061aULL, 0x0000000e051a7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000812147824ULL, 0x000fe200078e00ffULL, 0x0000001b00067210ULL, 0x004fc40007f5e0ffULL,
0x0000000b12057212ULL, 0x080fe200078e3cffULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x000000121a1b7c11ULL, 0x000fe2000f8c40ffULL, 0x000000ffff077224ULL, 0x000fe200010e0618ULL,
0x0000000c0a0d7c11ULL, 0x000fe2000f8e20ffULL, 0x00000038040a7836ULL, 0x000fe20000000000ULL,
0x000000131a1a7c11ULL, 0x000fe4000b0f440fULL, 0x0000000b12007c0cULL, 0x000fe2000bf46070ULL,
0x00000000080d7faeULL, 0x0003e2000c101c58ULL, 0x0000000c0e0f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000080a1f7824ULL, 0x040fe200078e00ffULL, 0xfffffff814127812ULL, 0x000fe200078ee205ULL,
0x0000000d0a057c36ULL, 0x040fe20008000000ULL, 0x0000000b0a0e7212ULL, 0x000fe200078e3cffULL,
0x00000000060f7faeULL, 0x0005e2000c901c58ULL, 0x0000003c04147836ULL, 0x000fe20000000000ULL,
0x0000001300047210ULL, 0x000fc40007f3e0ffULL, 0x0000000e05187c10ULL, 0x000fe4000ffde0ffULL,
0x0000000b0a007c0cULL, 0x000fe2000bf06070ULL, 0x000000ffff057224ULL, 0x000fe200008e0619ULL,
0x0000001d00087210ULL, 0x002fe20007f3e0ffULL, 0x000000ffff137224ULL, 0x000fe200030e06ffULL,
0x0000001218197c11ULL, 0x000fe2000f8c40ffULL, 0x0000000d14067c36ULL, 0x004fe20008000000ULL,
0xfffffff81f0a7812ULL, 0x000fe200078ee20eULL, 0x000000ffff097224ULL, 0x000fe200008e0616ULL,
0x0000001318187c11ULL, 0x000fe2000b0f4413ULL, 0x00000008140e7824ULL, 0x000fe200078e00ffULL,
0x0000000e06167c10ULL, 0x000fc4000ffde0ffULL, 0x0000001500067210ULL, 0x000fe40007f3e0ffULL,
0x0000000c10137c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff157224ULL, 0x000fe200030e06ffULL,
0x00000012160f7c11ULL, 0x000fe2000f8c40ffULL, 0x000000ffff077224ULL, 0x000fe200008e0617ULL,
0x0000000c0c177c11ULL, 0x000fe2000f8e20ffULL, 0x0000000004137faeULL, 0x0003e2000e101c58ULL,
0x0000001316167c11ULL, 0x000fe4000b0f4415ULL, 0x0000000c11157c11ULL, 0x000fc4000f8e20ffULL,
0x0000000b140d7212ULL, 0x040fe400078e3cffULL, 0x0000000b14007c0cULL, 0x000fe2000bf26070ULL,
0x0000000008157faeULL, 0x0003e2000e901c58ULL, 0xfffffff80e147812ULL, 0x000fe400078ee20dULL,
0x00000019000e7210ULL, 0x000fe20007f9e0ffULL, 0x0000000006177faeULL, 0x0003e2000d901c58ULL,
0x0000001b000c7210ULL, 0x000fe40007f7e0ffULL, 0x0000000f00107210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200020e0618ULL, 0x0000000c12197c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e061aULL, 0x0000000c0a1b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff117224ULL, 0x000fe200028e0616ULL, 0x0000000c141d7c11ULL, 0x000fc4000f8e20ffULL,
0x000000000c197faeULL, 0x0003e8000d101c58ULL, 0x000000000e1b7faeULL, 0x0003e8000c101c58ULL,
0x00000000101d7faeULL, 0x0003e2000c901c58ULL, 0x0000000c00587947ULL, 0x000fea0003800000ULL,
0x00000003ff147819ULL, 0x000fe2000001160bULL, 0x00008a0000127ab9ULL, 0x000fe20000000a00ULL,
0x0000007000337812ULL, 0x000fe200078ec0ffULL, 0x000000071e0b7291ULL, 0x000fe4000f8e703fULL,
0x0000000414167836ULL, 0x040fe40000000000ULL, 0x0000000c14207836ULL, 0x000fe20000000000ULL,
0x000010000b0b7890ULL, 0x000fe2000fffe03fULL, 0x0000000816057824ULL, 0x040fe200078e00ffULL,
0x0000000b16087212ULL, 0x080fe200078e3cffULL, 0x0000001014227836ULL, 0x000fe20000000000ULL,
0x0000000b20107212ULL, 0x080fe200078e3cffULL, 0x0000001c142e7836ULL, 0x000fe20000000000ULL,
0xfffffff805087812ULL, 0x000fe200078ee208ULL, 0x0000000820057824ULL, 0x000fe200078e00ffULL,
0x0000000b220f7212ULL, 0x0c0fe200078e3cffULL, 0x0000000822067824ULL, 0x000fe200078e00ffULL,
0x0000000b2e0c7212ULL, 0x080fe200078e3cffULL, 0x0000001414247836ULL, 0x000fe20000000000ULL,
0xfffffff805107812ULL, 0x000fe200078ee210ULL, 0x000000082e057824ULL, 0x000fe200078e00ffULL,
0xfffffff8060f7812ULL, 0x000fe200078ee20fULL, 0x0000002414327836ULL, 0x000fe20000000000ULL,
0x0000000b240e7212ULL, 0x080fe200078e3cffULL, 0x0000002c14387836ULL, 0x000fe20000000000ULL,
0xfffffff8050c7812ULL, 0x000fe200078ee20cULL, 0x0000000824077824ULL, 0x000fe200078e00ffULL,
0x0000000b32097212ULL, 0x0c0fe200078e3cffULL, 0x0000000832067824ULL, 0x000fe200078e00ffULL,
0x0000000b38057212ULL, 0x0c0fe200078e3cffULL, 0x0000000838127824ULL, 0x000fe200078e00ffULL,
0xfffffff8070e7812ULL, 0x000fe200078ee20eULL, 0x00000030143a7836ULL, 0x040fe20000000000ULL,
0xfffffff806097812ULL, 0x000fe200078ee209ULL, 0x0000002014307836ULL, 0x040fe20000000000ULL,
0xfffffff812057812ULL, 0x000fe200078ee205ULL, 0x00000008141e7836ULL, 0x000fe20000000000ULL,
0x0000000b3a067212ULL, 0x0c0fe200078e3cffULL, 0x000000083a157824ULL, 0x000fe200078e00ffULL,
0x0000000b300a7212ULL, 0x0c0fe200078e3cffULL, 0x0000000830077824ULL, 0x000fe200078e00ffULL,
0x0000000b1e117212ULL, 0x080fe200078e3cffULL, 0x0000000d14127c36ULL, 0x040fe20008000000ULL,
0xfffffff815067812ULL, 0x000fe200078ee206ULL, 0x00000034143c7836ULL, 0x000fe20000000000ULL,
0xfffffff8070a7812ULL, 0x000fe200078ee20aULL, 0x000000081e047824ULL, 0x000fe200078e00ffULL,
0x0000000e12157c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000d16167c36ULL, 0x000fe20008000000ULL,
0x0000000b3c077212ULL, 0x080fe200078e3cffULL, 0x00000018142c7836ULL, 0x000fe20000000000ULL,
0xfffffff804117812ULL, 0x000fe200078ee211ULL, 0x000000083c187824ULL, 0x000fe200078e00ffULL,
0x0000000e16177c10ULL, 0x000fe2000ff3e0ffULL, 0x000000082c047824ULL, 0x040fe200078e00ffULL,
0x0000000b2c0d7212ULL, 0x080fe200078e3cffULL, 0x0000002814367836ULL, 0x000fe20000000000ULL,
0xfffffff818077812ULL, 0x000fe200078ee207ULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x0000001215187c11ULL, 0x000fe2000f8040ffULL, 0x0000000d1e1e7c36ULL, 0x000fe20008000000ULL,
0xfffffff8040d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x00000012171c7c11ULL, 0x000fe2000f8240ffULL, 0x0000000836137824ULL, 0x040fe200078e00ffULL,
0x0000000b36047212ULL, 0x080fe200078e3cffULL, 0x0000000d20207c36ULL, 0x000fe20008000000ULL,
0x0000001315167c11ULL, 0x000fe200080f4416ULL, 0x0000000d22227c36ULL, 0x000fe20008000000ULL,
0x0000000e1e1e7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000003814447836ULL, 0x040fe20000000000ULL,
0x0000001317177c11ULL, 0x000fe200088f441aULL, 0x0000003c14467836ULL, 0x000fe20000000000ULL,
0xfffffff813047812ULL, 0x000fe200078ee204ULL, 0x0000000d24247c36ULL, 0x000fe20008000000ULL,
0x0000000e20207c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000844267824ULL, 0x000fe200078e00ffULL,
0x0000000e221d7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000846197824ULL, 0x000fe200078e00ffULL,
0x0000000b44137212ULL, 0x080fe200078e3cffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x0000000b46127212ULL, 0x000fe200078e3cffULL, 0x0000000d2c2c7c36ULL, 0x000fe20008000000ULL,
0x0000000e241f7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200008e06ffULL,
0x000000121e1a7c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff247224ULL, 0x000fe200010e06ffULL,
0xfffffff826137812ULL, 0x000fe200078ee213ULL, 0x0000000d2e2e7c36ULL, 0x000fe20008000000ULL,
0x0000001220227c11ULL, 0x000fe2000f8240ffULL, 0x0000000d30307c36ULL, 0x000fe20008000000ULL,
0x000000121d267c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0xfffffff819127812ULL, 0x000fe200078ee212ULL, 0x0000000d32327c36ULL, 0x000fe20008000000ULL,
0x000000131e197c11ULL, 0x000fe200080f4415ULL, 0x0000000d36367c36ULL, 0x000fe20008000000ULL,
0x0000000e2c2c7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000d38387c36ULL, 0x000fe20008000000ULL,
0x000000121f2a7c11ULL, 0x000fe2000f8640ffULL, 0x0000000d3a3a7c36ULL, 0x000fe20008000000ULL,
0x00000013201b7c11ULL, 0x000fe200088f441bULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x000000131d1d7c11ULL, 0x000fe200090f4424ULL, 0x0000000d3c3c7c36ULL, 0x000fe20008000000ULL,
0x0000000e2e2e7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000d44447c36ULL, 0x000fe20008000000ULL,
0x0000000e30307c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000d46467c36ULL, 0x000fe20008000000ULL,
0x000000131f1f7c11ULL, 0x000fe200098f4428ULL, 0x000000ffff217224ULL, 0x000fe200008e06ffULL,
0x0000000e32327c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff237224ULL, 0x000fe200010e06ffULL,
0x000000122c207c11ULL, 0x000fc4000f8040ffULL, 0x000000122e247c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff257224ULL, 0x000fe200018e06ffULL, 0x0000001230287c11ULL, 0x000fe4000f8440ffULL,
0x000000132c2c7c11ULL, 0x000fe400080f4415ULL, 0x0000000e36367c10ULL, 0x000fe4000ff1e0ffULL,
0x0000001232347c11ULL, 0x000fe4000f8640ffULL, 0x000000132e2e7c11ULL, 0x000fe200088f4421ULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x0000001330307c11ULL, 0x000fc400090f4423ULL,
0x0000000e381e7c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000e3a237c10ULL, 0x000fe4000ff5e0ffULL,
0x0000001332327c11ULL, 0x000fe200098f4425ULL, 0x000000ffff217224ULL, 0x000fe200008e06ffULL,
0x0000000e3c257c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x0000001236387c11ULL, 0x000fe4000f8040ffULL, 0x000000121e3a7c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff407224ULL, 0x000fe200018e06ffULL, 0x00000012233e7c11ULL, 0x000fc4000f8440ffULL,
0x0000001336367c11ULL, 0x000fe400080f4415ULL, 0x0000000e44447c10ULL, 0x000fe4000ff1e0ffULL,
0x000000131e317c11ULL, 0x000fe400088f4421ULL, 0x00000013233c7c11ULL, 0x000fe200090f443cULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x0000000714147812ULL, 0x000fe400078e480bULL,
0x0000000e461e7c10ULL, 0x000fc4000ff5e0ffULL, 0x0ffffff814007812ULL, 0x000fe400078ef80bULL,
0x0000001244467c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff217224ULL, 0x000fe200010e06ffULL,
0x0000001833147210ULL, 0x000fe40007f1e0ffULL, 0x000000121e487c11ULL, 0x000fe4000f8440ffULL,
0x0000001225427c11ULL, 0x000fe4000f8640ffULL, 0x0000001344447c11ULL, 0x000fe200088f4415ULL,
0x000000ffff157224ULL, 0x000fe200000e0616ULL, 0x000000131e357c11ULL, 0x000fc400090f4421ULL,
0x0000001c33167210ULL, 0x000fe40007f3e0ffULL, 0x0000001325407c11ULL, 0x000fe400098f4440ULL,
0x0000001a33187210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e0617ULL,
0x00000022331a7210ULL, 0x000fe40007f7e0ffULL, 0x00000026331c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff197224ULL, 0x000fe200010e0619ULL, 0x0000000b00277c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e061bULL, 0x0000002a331e7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200028e061dULL, 0x0000002033207210ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014277faeULL, 0x0003e2000b901c58ULL,
0x0000000b082b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff1f7224ULL, 0x000fe200020e061fULL,
0x0000002433227210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff217224ULL, 0x000fe200000e062cULL,
0x0000000b11117c11ULL, 0x000fe2000f8e20ffULL, 0x00000000162b7faeULL, 0x0005e2000b901c58ULL,
0x0000002833247210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff237224ULL, 0x000fe200008e062eULL,
0x0000000b102d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000018117faeULL, 0x000fe2000b901c58ULL,
0x0000003433287210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff257224ULL, 0x000fe200010e0630ULL,
0x0000000b0f0f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000001a2d7faeULL, 0x0007e2000b901c58ULL,
0x0000003833267210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff297224ULL, 0x000fe200018e0632ULL,
0x0000000b0e2f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000001c0f7faeULL, 0x000fe2000b901c58ULL,
0x0000003a332a7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff277224ULL, 0x002fe200028e0636ULL,
0x0000000b0d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000001e2f7faeULL, 0x0003e2000b901c58ULL,
0x0000003e332c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff2b7224ULL, 0x004fe200020e0631ULL,
0x0000000b0c157c11ULL, 0x000fe2000f8e20ffULL, 0x00000000200d7faeULL, 0x000fe2000b901c58ULL,
0x00000042332e7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff2d7224ULL, 0x008fe200000e063cULL,
0x0000000b0a177c11ULL, 0x000fe2000f8e20ffULL, 0x0000000022157faeULL, 0x000fe2000b901c58ULL,
0x0000004633307210ULL, 0x000fc40007f5e0ffULL, 0x0000000b09097c11ULL, 0x000fe2000f8e20ffULL,
0x0000000024177faeULL, 0x000fe2000b901c58ULL, 0x0000004833327210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2f7224ULL, 0x002fe200008e0640ULL, 0x0000000b04117c11ULL, 0x000fe2000f8e20ffULL,
0x0000000028097faeULL, 0x0003e2000b901c58ULL, 0x0000000b05057c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff317224ULL, 0x000fe200010e0644ULL, 0x0000000b060f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000026117faeULL, 0x0005e2000b901c58ULL, 0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff337224ULL, 0x000fe200018e0635ULL, 0x0000000b13137c11ULL, 0x000fe2000f8e20ffULL,
0x000000002a057faeULL, 0x0005e2000b901c58ULL, 0x0000000b12097c11ULL, 0x002fc6000f8e20ffULL,
0x000000002c0f7faeULL, 0x0005e8000b901c58ULL, 0x000000002e077faeULL, 0x0005e8000b901c58ULL,
0x0000000030137faeULL, 0x0005e8000b901c58ULL, 0x0000000032097faeULL, 0x0005e4000b901c58ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01b60003ff0075a7ULL, 0x000ee20008000147ULL,
0x000000085b007c0cULL, 0x000fe2000bf26070ULL, 0x0000005000d88947ULL, 0x008fd80003800000ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x00009000000b7ab9ULL, 0x000fe20000000800ULL,
0x000000071e157291ULL, 0x000fe4000f8e183fULL, 0xffffffff08167890ULL, 0x000fe4000fffe03fULL,
0x000000071e177291ULL, 0x000fe4000f8e283fULL, 0x0000000b040b72a4ULL, 0x000fd8000f8e023fULL,
0x000000005b0e72caULL, 0x000fda00000e0000ULL, 0x000000110e0e7291ULL, 0x000fc8000f8e403fULL,
0x0000000e2300728cULL, 0x000fcc000bf04070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x000000015b007836ULL, 0x000fe20000000000ULL,
0x000000400e047892ULL, 0x000fe4000f8ec03fULL, 0x00000014090d72a4ULL, 0x000fe4000f8e023fULL,
0x0000000800007c0cULL, 0x000fe2000bf06070ULL, 0x000000040a047290ULL, 0x000fd8000fffe03fULL,
0x0000000c00688947ULL, 0x000fea0003800000ULL, 0x00000003ff667819ULL, 0x000fe2000001160bULL,
0x00008a0000127ab9ULL, 0x000fe20000000a00ULL, 0x8000000e230c7290ULL, 0x000fe2000fffe03fULL,
0x000000070b647812ULL, 0x000fe200078ec0ffULL, 0x000000071e0f7291ULL, 0x000fe2000f8e703fULL,
0x0000000466627836ULL, 0x040fe40000000000ULL, 0x0000000c665e7836ULL, 0x000fe20000000000ULL,
0x000030000f1a7890ULL, 0x000fe2000fffe03fULL, 0x0000000862007824ULL, 0x040fe200078e00ffULL,
0x0000000b62617212ULL, 0x080fe200078e3cffULL, 0x0000001866587836ULL, 0x000fe20000000000ULL,
0x0000000b5e5d7212ULL, 0x080fe200078e3cffULL, 0x0000000866607836ULL, 0x000fe20000000000ULL,
0xfffffff800617812ULL, 0x000fe200078ee261ULL, 0x000000085e007824ULL, 0x000fe200078e00ffULL,
0x0000000b58557212ULL, 0x080fe200078e3cffULL, 0x00000014665a7836ULL, 0x000fe20000000000ULL,
0x0000000b605f7212ULL, 0x0c0fe200078e3cffULL, 0x0000000860027824ULL, 0x000fe200078e00ffULL,
0xfffffff8005d7812ULL, 0x000fe200078ee25dULL, 0x0000000858007824ULL, 0x000fe200078e00ffULL,
0x0000000b5a577212ULL, 0x0c0fe200078e3cffULL, 0x000000085a047824ULL, 0x002fe200078e00ffULL,
0xfffffff8025f7812ULL, 0x000fe200078ee25fULL, 0x00000010665c7836ULL, 0x040fe20000000000ULL,
0xfffffff800557812ULL, 0x000fe200078ee255ULL, 0x0000002066547836ULL, 0x040fe20000000000ULL,
0xfffffff804577812ULL, 0x000fe200078ee257ULL, 0x0000002c66007836ULL, 0x000fe20000000000ULL,
0x0000000b5c597212ULL, 0x0c0fe200078e3cffULL, 0x000000085c027824ULL, 0x000fe200078e00ffULL,
0x0000000b54517212ULL, 0x0c0fe200078e3cffULL, 0x0000000854047824ULL, 0x000fe200078e00ffULL,
0x0000000b00037212ULL, 0x080fe200078e3cffULL, 0x0000001c66567836ULL, 0x040fe20000000000ULL,
0xfffffff802597812ULL, 0x000fe200078ee259ULL, 0x0000002466527836ULL, 0x000fe20000000000ULL,
0xfffffff804517812ULL, 0x000fe200078ee251ULL, 0x0000000800067824ULL, 0x000fe200078e00ffULL,
0x0000000b56537212ULL, 0x0c0fe200078e3cffULL, 0x0000000856027824ULL, 0x000fe200078e00ffULL,
0x0000000b520f7212ULL, 0x0c4fe200078e3cffULL, 0x0000000852047824ULL, 0x000fe200078e00ffULL,
0xfffffff806037812ULL, 0x000fe200078ee203ULL, 0x0000002866507836ULL, 0x040fe20000000000ULL,
0xfffffff802537812ULL, 0x000fe200078ee253ULL, 0x0000003466067836ULL, 0x000fe20000000000ULL,
0xfffffff8040f7812ULL, 0x000fe200078ee20fULL, 0x0000000850057824ULL, 0x040fe200078e00ffULL,
0x0000000b50027212ULL, 0x080fe200078e3cffULL, 0x0000003066047836ULL, 0x000fe20000000000ULL,
0x0000000b06077212ULL, 0x0c0fe200078e3cffULL, 0x00000008060c7824ULL, 0x000fe200078e00ffULL,
0xfffffff805027812ULL, 0x000fe200078ee202ULL, 0x00000008040a7824ULL, 0x040fe200078e00ffULL,
0x0000000b04057212ULL, 0x080fe200078e3cffULL, 0x0000003866087836ULL, 0x040fe20000000000ULL,
0xfffffff80c077812ULL, 0x000fe200078ee207ULL, 0x00000004660c7c36ULL, 0x040fe20008000000ULL,
0xfffffff80a057812ULL, 0x000fe200078ee205ULL, 0x0000003c660a7836ULL, 0x000fe20000000000ULL,
0x0000000b08097212ULL, 0x0c0fe200078e3cffULL, 0x00000008080e7824ULL, 0x000fe200078e00ffULL,
0x0000000d0c117c10ULL, 0x000fe2000ff1e0ffULL, 0x00000004620c7c36ULL, 0x000fe20008000000ULL,
0x0000000b0a107212ULL, 0x040fe200078e3cffULL, 0x000000080a137824ULL, 0x000fe200078e00ffULL,
0xfffffff80e097812ULL, 0x000fe200078ee209ULL, 0x00000004600d7c36ULL, 0x000fe20008000000ULL,
0x0000000d0c0e7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0xfffffff8130c7812ULL, 0x000fc400078ee210ULL, 0x00000012112a7c11ULL, 0x040fe2000f8040ffULL,
0x000000ffff137224ULL, 0x000fe200008e06ffULL, 0x0000000d0d107c10ULL, 0x000fe2000ff5e0ffULL,
0x000000045e0d7c36ULL, 0x000fe20008000000ULL, 0x00000013112b7c11ULL, 0x000fe400080f4412ULL,
0x000000120e2c7c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x0000001210287c11ULL, 0x000fe4000f8240ffULL, 0x000000130e2d7c11ULL, 0x000fe200080f4413ULL,
0x000000045c0e7c36ULL, 0x000fe20008000000ULL, 0x0000001310297c11ULL, 0x000fc400088f4411ULL,
0x0000000d0d107c10ULL, 0x000fe2000ff1e0ffULL, 0x000000045a0d7c36ULL, 0x000fe20008000000ULL,
0x0000000d0e117c10ULL, 0x000fe2000ff3e0ffULL, 0x00000004580e7c36ULL, 0x000fe20008000000ULL,
0x0000001a61337c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x00000012102e7c11ULL, 0x040fe2000f8040ffULL, 0x000000ffff147224ULL, 0x000fe200008e06ffULL,
0x0000001211247c11ULL, 0x000fe4000f8240ffULL, 0x00000013102f7c11ULL, 0x000fc400080f4413ULL,
0x0000000d0d127c10ULL, 0x000fe2000ff5e0ffULL, 0x00000004560d7c36ULL, 0x000fe20008000000ULL,
0x0000000d0e107c10ULL, 0x000fe2000ff7e0ffULL, 0x00000004540e7c36ULL, 0x000fe20008000000ULL,
0x0000001311257c11ULL, 0x000fe200088f4414ULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x0000001212267c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x0000001210227c11ULL, 0x000fe4000f8240ffULL, 0x0000001312277c11ULL, 0x000fc400080f4413ULL,
0x0000001310237c11ULL, 0x000fe400088f4411ULL, 0x0000000d0d107c10ULL, 0x000fe2000ff1e0ffULL,
0x00000004520d7c36ULL, 0x000fe20008000000ULL, 0x0000000d0e117c10ULL, 0x000fe2000ff3e0ffULL,
0x00000004500e7c36ULL, 0x000fe20008000000ULL, 0x0000001a5f357c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff137224ULL, 0x000fe200000e06ffULL, 0x0000001210207c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x0000000d0d127c10ULL, 0x000fe2000ff5e0ffULL,
0x00000004000d7c36ULL, 0x000fe20008000000ULL, 0x0000001310217c11ULL, 0x000fc400080f4413ULL,
0x00000012111e7c11ULL, 0x040fe2000f8240ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x0000000d0e107c10ULL, 0x000fe2000ff7e0ffULL, 0x00000004040e7c36ULL, 0x000fe20008000000ULL,
0x00000013111f7c11ULL, 0x000fe400088f4414ULL, 0x00000012121c7c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff117224ULL, 0x000fe200018e06ffULL, 0x00000012101a7c11ULL, 0x000fe4000f8240ffULL,
0x00000013121d7c11ULL, 0x000fc400080f4413ULL, 0x00000013101b7c11ULL, 0x000fe400088f4411ULL,
0x0000000d0d127c10ULL, 0x000fe2000ff1e0ffULL, 0x00000004060d7c36ULL, 0x000fe20008000000ULL,
0x0000000d0e107c10ULL, 0x000fe2000ff3e0ffULL, 0x00000004080e7c36ULL, 0x000fe20008000000ULL,
0x0000001a5d377c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x0000001212187c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff137224ULL, 0x000fe200008e06ffULL,
0x0000000d0d117c10ULL, 0x000fc4000ff5e0ffULL, 0x0000000d0e0e7c10ULL, 0x000fe4000ff7e0ffULL,
0x0000001210167c11ULL, 0x000fe4000f8240ffULL, 0x0000001312197c11ULL, 0x000fe200080f4415ULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x0000001310177c11ULL, 0x000fe200088f4413ULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x0000001211147c11ULL, 0x000fe4000f8040ffULL,
0x000000120e107c11ULL, 0x000fc4000f8240ffULL, 0x0000001311157c11ULL, 0x000fe400080f4412ULL,
0x000000130e117c11ULL, 0x000fe200088f440dULL, 0x000000040a0e7c36ULL, 0x000fe20008000000ULL,
0x0000000b660d7212ULL, 0x040fe400078e3cffULL, 0x0000000c66007c0cULL, 0x000fe4000bf06070ULL,
0x000000070d127812ULL, 0x000fe400078ec0ffULL, 0x0000000c62007c0cULL, 0x000fc4000bf26070ULL,
0x0000000c60007c0cULL, 0x000fe4000bf46070ULL, 0x00000008640d7812ULL, 0x000fe400078efcffULL,
0x0000000c5e007c0cULL, 0x000fe4000bf66070ULL, 0x0ffffff812637812ULL, 0x000fe200078ef80bULL,
0x000000100d2a7825ULL, 0x000fe200078e002aULL, 0x0000000d0e0e7c10ULL, 0x000fe4000ff9e0ffULL,
0x0000001a63317c11ULL, 0x000fe2000f8e20ffULL, 0x000000100d2c7825ULL, 0x000fe200078e002cULL,
0x0000001a59397c11ULL, 0x000fc4000f8e20ffULL, 0x0000001a573b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100d287825ULL, 0x040fe200078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a317faeULL, 0x0003e2000c101c58ULL, 0x0000000c5c007c0cULL, 0x000fe4000bf06070ULL,
0x000000100d2e7825ULL, 0x040fe200078e002eULL, 0x000000002c337faeULL, 0x0005e2000c901c58ULL,
0x0000000c5a007c0cULL, 0x000fe4000bf26070ULL, 0x000000ffff137224ULL, 0x000fe200020e06ffULL,
0x000000120e127c11ULL, 0x000fe2000f8840ffULL, 0x0000000028357faeULL, 0x0007e2000d101c58ULL,
0x0000000c58007c0cULL, 0x000fe2000bf46070ULL, 0x000000100d247825ULL, 0x040fe200078e0024ULL,
0x000000130e137c11ULL, 0x000fe2000a0f4413ULL, 0x000000002e377faeULL, 0x000fe2000d901c58ULL,
0x0000000c56007c0cULL, 0x000fe2000bf66070ULL, 0x000000100d267825ULL, 0x000fe200078e0026ULL,
0x0000000c54007c0cULL, 0x000fe2000bf86070ULL, 0x0000000024397faeULL, 0x000be2000c101c58ULL,
0x0000001a552b7c11ULL, 0x002fe2000f8e20ffULL, 0x000000100d227825ULL, 0x000fe200078e0022ULL,
0x0000001a532d7c11ULL, 0x004fe2000f8e20ffULL, 0x00000000263b7faeULL, 0x000fe2000c901c58ULL,
0x0000001a51297c11ULL, 0x008fe2000f8e20ffULL, 0x000000100d207825ULL, 0x040fe200078e0020ULL,
0x0000000c52007c0cULL, 0x000fe2000bf06070ULL, 0x00000000222b7faeULL, 0x0003e2000d101c58ULL,
0x0000000c50007c0cULL, 0x000fe2000bf26070ULL, 0x000000100d1e7825ULL, 0x040fe200078e001eULL,
0x0000000c00007c0cULL, 0x000fe2000bf46070ULL, 0x00000000202d7faeULL, 0x0005e2000d901c58ULL,
0x0000000c04007c0cULL, 0x000fe2000bf66070ULL, 0x000000100d1c7825ULL, 0x040fe200078e001cULL,
0x0000000c08007c0cULL, 0x000fe2000bfa6070ULL, 0x000000001e297faeULL, 0x0007e2000e101c58ULL,
0x0000000c06007c0cULL, 0x000fe2000bf86070ULL, 0x000000100d1a7825ULL, 0x000fe200078e001aULL,
0x0000000c0a007c0cULL, 0x000fc4000bfc6070ULL, 0x0000001a0f257c11ULL, 0x020fe2000f8e20ffULL,
0x000000100d187825ULL, 0x000fe200078e0018ULL, 0x0000001a02237c11ULL, 0x002fe4000f8e20ffULL,
0x0000001a07217c11ULL, 0x004fe2000f8e20ffULL, 0x000000100d167825ULL, 0x000fe200078e0016ULL,
0x000000001c257faeULL, 0x0009e2000c101c58ULL, 0x0000001a051f7c11ULL, 0x008fe4000f8e20ffULL,
0x000000100d147825ULL, 0x000fe200078e0014ULL, 0x0000001a09277c11ULL, 0x000fe2000f8e20ffULL,
0x000000001a237faeULL, 0x0009e2000c901c58ULL, 0x0000001a0c297c11ULL, 0x000fe2000f8e20ffULL,
0x000000100d107825ULL, 0x000fc800078e0010ULL, 0x000000100d127825ULL, 0x000fe200078e0012ULL,
0x0000001a030d7c11ULL, 0x000fca000f8e20ffULL, 0x00000000180d7faeULL, 0x0009e8000d101c58ULL,
0x00000000161f7faeULL, 0x0009e8000d901c58ULL, 0x0000000014217faeULL, 0x0009e8000e101c58ULL,
0x0000000010277faeULL, 0x0009e8000e901c58ULL, 0x0000000012297faeULL, 0x0009e2000f101c58ULL,
0x0000000c00207947ULL, 0x000fea0003800000ULL, 0x00000003ff667819ULL, 0x000fe2000001160bULL,
0x00008a0000127ab9ULL, 0x000fe20000000a00ULL, 0x000000071e0f7291ULL, 0x000fe2000f8e703fULL,
0x000000070b647812ULL, 0x000fe400078ec0ffULL, 0x0000000466627836ULL, 0x040fe20000000000ULL,
0x000030000f1a7890ULL, 0x000fe2000fffe03fULL, 0x0000000866607836ULL, 0x000fe40000000000ULL,
0x0000000862007824ULL, 0x040fe200078e00ffULL, 0x0000000b62617212ULL, 0x080fe200078e3cffULL,
0x0000000c665e7836ULL, 0x000fe20000000000ULL, 0x0000000b605f7212ULL, 0x080fe200078e3cffULL,
0x00000010665c7836ULL, 0x000fe20000000000ULL, 0xfffffff800617812ULL, 0x000fe200078ee261ULL,
0x0000000860007824ULL, 0x000fe200078e00ffULL, 0x0000000b5e5d7212ULL, 0x0c0fe200078e3cffULL,
0x000000085e027824ULL, 0x000fe200078e00ffULL, 0x0000000b5c597212ULL, 0x080fe200078e3cffULL,
0x0000001866587836ULL, 0x040fe20000000000ULL, 0xfffffff8005f7812ULL, 0x000fe200078ee25fULL,
0x0000001c66567836ULL, 0x000fe20000000000ULL, 0xfffffff8025d7812ULL, 0x000fe200078ee25dULL,
0x000000085c047824ULL, 0x002fe200078e00ffULL, 0x0000000b58557212ULL, 0x080fe200078e3cffULL,
0x00000014665a7836ULL, 0x000fe20000000000ULL, 0x0000000b56537212ULL, 0x080fe200078e3cffULL,
0x0000000858007824ULL, 0x000fe200078e00ffULL, 0xfffffff804597812ULL, 0x000fe200078ee259ULL,
0x0000000856027824ULL, 0x000fe200078e00ffULL, 0x0000000b5a577212ULL, 0x080fe200078e3cffULL,
0x0000002066547836ULL, 0x040fe20000000000ULL, 0xfffffff800557812ULL, 0x000fe200078ee255ULL,
0x0000002866507836ULL, 0x000fe20000000000ULL, 0xfffffff802537812ULL, 0x000fe200078ee253ULL,
0x000000085a067824ULL, 0x000fe200078e00ffULL, 0x0000000b54517212ULL, 0x0c0fe200078e3cffULL,
0x0000000854047824ULL, 0x000fe200078e00ffULL, 0x0000000b50027212ULL, 0x0c0fe200078e3cffULL,
0x0000000850097824ULL, 0x004fe200078e00ffULL, 0xfffffff806577812ULL, 0x000fe200078ee257ULL,
0x0000002466527836ULL, 0x040fe20000000000ULL, 0xfffffff804517812ULL, 0x000fe200078ee251ULL,
0x0000002c66007836ULL, 0x000fe20000000000ULL, 0xfffffff809027812ULL, 0x000fe200078ee202ULL,
0x0000000852067824ULL, 0x040fe200078e00ffULL, 0x0000000b520f7212ULL, 0x080fe200078e3cffULL,
0x0000000800087824ULL, 0x040fe200078e00ffULL, 0x0000000b00037212ULL, 0x080fe200078e3cffULL,
0x0000003066047836ULL, 0x040fe20000000000ULL, 0xfffffff8060f7812ULL, 0x000fe200078ee20fULL,
0x0000000466097c36ULL, 0x000fe20008000000ULL, 0xfffffff808037812ULL, 0x000fe200078ee203ULL,
0x00000008040a7824ULL, 0x040fe200078e00ffULL, 0x0000000b04057212ULL, 0x080fe200078e3cffULL,
0x0000003466067836ULL, 0x040fe20000000000ULL, 0x0000000d090d7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000003866087836ULL, 0x000fe20000000000ULL, 0xfffffff80a057812ULL, 0x000fe200078ee205ULL,
0x00000008060c7824ULL, 0x040fe200078e00ffULL, 0x0000000b06077212ULL, 0x080fe200078e3cffULL,
0x0000000808107824ULL, 0x040fe200078e00ffULL, 0x0000000b08097212ULL, 0x080fe200078e3cffULL,
0x0000003c660a7836ULL, 0x000fe20000000000ULL, 0xfffffff80c077812ULL, 0x000fe200078ee207ULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x000000120d167c11ULL, 0x040fe2000f8040ffULL,
0x000000080a117824ULL, 0x000fe200078e00ffULL, 0xfffffff810097812ULL, 0x000fe200078ee209ULL,
0x0000000462107c36ULL, 0x000fe20008000000ULL, 0x0000000b0a0c7212ULL, 0x000fe200078e3cffULL,
0x000000045c147c36ULL, 0x000fe20008000000ULL, 0x000000130d177c11ULL, 0x000fe200080f440eULL,
0x00000004600d7c36ULL, 0x000fe20008000000ULL, 0xfffffff8110c7812ULL, 0x000fe200078ee20cULL,
0x000000045e117c36ULL, 0x000fe20008000000ULL, 0x0000000d10107c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000d0d0e7c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000d11127c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x0000001210267c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x000000120e187c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x0000001310277c11ULL, 0x000fe200080f440dULL,
0x0000000458107c36ULL, 0x000fe20008000000ULL, 0x0000000d14147c10ULL, 0x000fc4000ff1e0ffULL,
0x000000130e197c11ULL, 0x000fe200088f4411ULL, 0x000000045a0e7c36ULL, 0x000fe20008000000ULL,
0x00000012121e7c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x0000001214287c11ULL, 0x000fe2000f8040ffULL, 0x0000000456117c36ULL, 0x000fe20008000000ULL,
0x0000000d0e0e7c10ULL, 0x000fe4000ff3e0ffULL, 0x0000001314297c11ULL, 0x000fe200080f440dULL,
0x0000000400147c36ULL, 0x000fe20008000000ULL, 0x00000013121f7c11ULL, 0x000fe200090f4413ULL,
0x000000ffff0d7224ULL, 0x000fe200008e06ffULL, 0x0000000d10107c10ULL, 0x000fc4000ff5e0ffULL,
0x000000120e2e7c11ULL, 0x040fe4000f8040ffULL, 0x0000000d11127c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x000000130e2f7c11ULL, 0x000fe200080f440dULL,
0x00000004540d7c36ULL, 0x000fe20008000000ULL, 0x00000012102a7c11ULL, 0x000fe2000f8240ffULL,
0x00000004520e7c36ULL, 0x000fe20008000000ULL, 0x00000012122c7c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x00000013102b7c11ULL, 0x000fe200088f4411ULL,
0x0000000450117c36ULL, 0x000fe20008000000ULL, 0x0000000d0d0d7c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000d0e107c10ULL, 0x000fe4000ff3e0ffULL, 0x00000013122d7c11ULL, 0x000fe200090f4413ULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x0000000d11127c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x000000120d247c11ULL, 0x040fe4000f8040ffULL,
0x0000000d14147c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x000000130d257c11ULL, 0x000fc400080f440eULL, 0x0000001210227c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x0000001212207c11ULL, 0x000fe4000f8440ffULL,
0x00000012141c7c11ULL, 0x000fe4000f8040ffULL, 0x0000000b660e7212ULL, 0x000fe400078e3cffULL,
0x0000001310237c11ULL, 0x000fe200088f4411ULL, 0x0000000404107c36ULL, 0x000fe20008000000ULL,
0x0000001312217c11ULL, 0x000fe200090f4413ULL, 0x0000000406117c36ULL, 0x000fe20008000000ULL,
0x00000013141d7c11ULL, 0x000fe200080f440dULL, 0x0000000408127c36ULL, 0x000fe20008000000ULL,
0x000000070e0e7812ULL, 0x000fe200078ec0ffULL, 0x000000040a147c36ULL, 0x000fe20008000000ULL,
0x0000000d11137c10ULL, 0x000fc4000ff3e0ffULL, 0x0ffffff80e637812ULL, 0x000fe400078ef80bULL,
0x0000000d100e7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x0000000d12347c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000d14367c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x000000120e1a7c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff357224ULL, 0x000fe200010e06ffULL, 0x0000001213147c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff377224ULL, 0x000fe200018e06ffULL, 0x0000001234107c11ULL, 0x000fc4000f8440ffULL,
0x0000001236127c11ULL, 0x000fe4000f8640ffULL, 0x00000008640d7812ULL, 0x000fe400078efcffULL,
0x000000130e1b7c11ULL, 0x000fe400080f4411ULL, 0x0000001313157c11ULL, 0x000fe200088f4432ULL,
0x000000100d307825ULL, 0x040fe200078e0016ULL, 0x0000001334117c11ULL, 0x000fe400090f4435ULL,
0x0000001336137c11ULL, 0x000fe200098f4437ULL, 0x000000100d167825ULL, 0x000fe200078e0026ULL,
0x0000001a63337c11ULL, 0x000fc4000f8e20ffULL, 0x0000001a57357c11ULL, 0x000fe2000f8e20ffULL,
0x000000100d267825ULL, 0x000fe200078e0028ULL, 0x0000001a55377c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030337faeULL, 0x0003e2000b901c58ULL,
0x0000001a53397c11ULL, 0x000fe2000f8e20ffULL, 0x000000100d187825ULL, 0x000fe200078e0018ULL,
0x0000001a513b7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001a0f3d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100d1e7825ULL, 0x000fe200078e001eULL, 0x0000001a023f7c11ULL, 0x000fc6000f8e20ffULL,
0x000000100d287825ULL, 0x000fe200078e002eULL, 0x0000001a5f2f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001a5d317c11ULL, 0x002fe2000f8e20ffULL, 0x000000100d2a7825ULL, 0x000fe200078e002aULL,
0x0000001a59337c11ULL, 0x000fc6000f8e20ffULL, 0x000000100d2c7825ULL, 0x000fc800078e002cULL,
0x000000100d247825ULL, 0x000fc800078e0024ULL, 0x000000100d227825ULL, 0x000fc800078e0022ULL,
0x000000100d207825ULL, 0x000fc800078e0020ULL, 0x000000100d1c7825ULL, 0x000fc800078e001cULL,
0x000000100d1a7825ULL, 0x000fc800078e001aULL, 0x000000100d147825ULL, 0x000fc800078e0014ULL,
0x000000100d107825ULL, 0x000fc800078e0010ULL, 0x000000100d127825ULL, 0x000fe200078e0012ULL,
0x0000001a610d7c11ULL, 0x000fca000f8e20ffULL, 0x00000000160d7faeULL, 0x0003e8000b901c58ULL,
0x00000000182f7faeULL, 0x0005e8000b901c58ULL, 0x000000001e317faeULL, 0x0007e8000b901c58ULL,
0x0000000026337faeULL, 0x0009e2000b901c58ULL, 0x0000001a030d7c11ULL, 0x002fc4000f8e20ffULL,
0x0000001a05177c11ULL, 0x000fe2000f8e20ffULL, 0x0000000028357faeULL, 0x0003e2000b901c58ULL,
0x0000001a07197c11ULL, 0x004fc6000f8e20ffULL, 0x000000002a377faeULL, 0x0003e2000b901c58ULL,
0x0000001a091f7c11ULL, 0x008fc6000f8e20ffULL, 0x000000002c397faeULL, 0x0003e2000b901c58ULL,
0x0000001a0c277c11ULL, 0x010fc6000f8e20ffULL, 0x00000000243b7faeULL, 0x0003e8000b901c58ULL,
0x00000000223d7faeULL, 0x0003e8000b901c58ULL, 0x00000000203f7faeULL, 0x0003e8000b901c58ULL,
0x000000001c0d7faeULL, 0x0003e8000b901c58ULL, 0x000000001a177faeULL, 0x0003e8000b901c58ULL,
0x0000000014197faeULL, 0x0003e8000b901c58ULL, 0x00000000101f7faeULL, 0x0003e8000b901c58ULL,
0x0000000012277faeULL, 0x0003e4000b901c58ULL, 0x000000061f067291ULL, 0x000fe2000f8e083fULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000050600728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fca0003f0f008ULL, 0x000000060b048291ULL, 0x000fe2000f8e083fULL,
0x00008c00000c8ab9ULL, 0x000fc60000000a00ULL, 0x00000004040c88a5ULL, 0x000fcc000f8e000cULL,
0x0000000cff6a7e24ULL, 0x000fe2000f8e00ffULL, 0x00000004ff0d7819ULL, 0x012fe2000001160bULL,
0x0000000dff6b7e24ULL, 0x000fe2000f8e00ffULL, 0x00000008640e7812ULL, 0x000fe200078ef80bULL,
0x000010000f107890ULL, 0x000fe2000fffe03fULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000186a6a8981ULL, 0x0002a2000c1e1900ULL, 0x000000080d117824ULL, 0x040fe200078e00ffULL,
0x0000000166787812ULL, 0x000fe200078ec0ffULL, 0x000000020d137836ULL, 0x000fe20000000000ULL,
0x000000005b0c72caULL, 0x000fe200000e0000ULL, 0x000000040d217836ULL, 0x000fe20000000000ULL,
0xfffffff8111c7812ULL, 0x000fe200078ee264ULL, 0xffffffff00147882ULL, 0x000fe20000000000ULL,
0x000000070d117812ULL, 0x000fe400078e780eULL, 0x000000071c457812ULL, 0x040fe200078ec0ffULL,
0x000000081c737824ULL, 0x000fe200078e00ffULL, 0x0000000713137812ULL, 0x000fe200078e780eULL,
0x000000100e117824ULL, 0x000fe200078e0211ULL, 0x0000000145687812ULL, 0x000fe200078e7866ULL,
0x000000201c757836ULL, 0x000fe20000000000ULL, 0x0000000245107812ULL, 0x000fe200078e1e78ULL,
0x000000100e137824ULL, 0x000fe200078e0213ULL, 0x0000007368687212ULL, 0x080fe200078efcffULL,
0x000000101c767836ULL, 0x040fe20000000000ULL, 0x0000000711117c11ULL, 0x000fe2000f8e20ffULL,
0x000000301c747836ULL, 0x000fe20000000000ULL, 0x0000001068187c11ULL, 0x000fe2000f8e20ffULL,
0x0000000c1f0c7290ULL, 0x000fe2000fffe03fULL, 0x0000007310657212ULL, 0x000fe200078efcffULL,
0x000000001134783bULL, 0x000fe20000000200ULL, 0x0000000713137c11ULL, 0x000fe2000f8e20ffULL,
0x000000010c0f7890ULL, 0x000fe2000fffe03fULL, 0x0000001065147c11ULL, 0x000fe2000f8e20ffULL,
0x000000001818783bULL, 0x000ee20000000200ULL, 0x0000000775797812ULL, 0x040fe200078ec0ffULL,
0x0000000875757824ULL, 0x000fe200078e00ffULL, 0x00000007767b7812ULL, 0x040fe200078ec0ffULL,
0x000000001310783bULL, 0x000fe20000000200ULL, 0x00000001791c7812ULL, 0x000fe200078e7866ULL,
0x0000000876767824ULL, 0x000fe200078e00ffULL, 0x0000000774777812ULL, 0x000fe200078ec0ffULL,
0x000000001414783bULL, 0x000fe20000000200ULL, 0x000000751c697212ULL, 0x000fe200078efcffULL,
0x0000000874747824ULL, 0x000fe200078e00ffULL, 0x000000017b677812ULL, 0x000fe200078e7866ULL,
0x000000080f00728cULL, 0x000fe2000bf26070ULL, 0x0000001069387c11ULL, 0x000fe2000f8e20ffULL,
0x000000110c0d7291ULL, 0x000fe2000f8e403fULL, 0x00000001771d7812ULL, 0x000fc400078e7866ULL,
0x0000007667677212ULL, 0x000fe200078efcffULL, 0x000000400d047892ULL, 0x000fe2000f8ec03fULL,
0x000000003838783bULL, 0x000f220000000200ULL, 0x000000741d6c7212ULL, 0x000fe400078efcffULL,
0x00000010673c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000040a0f7290ULL, 0x000fe2000fffe03fULL,
0x000000106c1c7c11ULL, 0x000fe4000f8e20ffULL, 0x000000027b6b7812ULL, 0x002fe400078e1e78ULL,
0x000000003c3c783bULL, 0x000fe20000000200ULL, 0x0000000721217812ULL, 0x000fc400078e780eULL,
0x000000766b6b7212ULL, 0x000fe200078efcffULL, 0x000000001c1c783bULL, 0x000e620000000200ULL,
0x0000000445207812ULL, 0x000fe200078e1e78ULL, 0x000000100e217824ULL, 0x000fe200078e0221ULL,
0x000000106b307c11ULL, 0x000fe4000f8e20ffULL, 0x00000073206f7212ULL, 0x000fe400078efcffULL,
0x0000000721407c11ULL, 0x000fe2000f8e20ffULL, 0x000000183428723cULL, 0x008fe200000018ffULL,
0x000000003030783bULL, 0x000fe20000000200ULL, 0x000000106f2c7c11ULL, 0x000fc4000f8e20ffULL,
0x000000047b477812ULL, 0x000fe200078e1e78ULL, 0x000000004040783bULL, 0x000fe20000000200ULL,
0x0000001a3418723cULL, 0x000fe200000018ffULL, 0x000000067b7b7812ULL, 0x000fe400078e1e78ULL,
0x000000002c2c783bULL, 0x000ee20000000200ULL, 0x0000007647707212ULL, 0x080fe400078efcffULL,
0x000000767b767212ULL, 0x000fe200078efcffULL, 0x00000038344c723cULL, 0x010ff600000018ffULL,
0x000000141028723cULL, 0x000fec0000001828ULL, 0x0000003a3438723cULL, 0x000fe200000018ffULL,
0x0000000279147812ULL, 0x000fc800078e1e78ULL, 0x00000075146d7212ULL, 0x000fe200078efcffULL,
0x0000001c3420723cULL, 0x002fe600000018ffULL, 0x000000106d487c11ULL, 0x000fc6000f8e20ffULL,
0x000000161014723cULL, 0x000fe20000001818ULL, 0x00000010701c7c11ULL, 0x000fe4000f8e20ffULL,
0x000000004848783bULL, 0x000e660000000200ULL, 0x0000002c4028723cULL, 0x008fe20000001828ULL,
0x0000000277197812ULL, 0x000fc800078e1e78ULL, 0x00000074196e7212ULL, 0x000fe400078efcffULL,
0x0000003c3418723cULL, 0x000fe200000018ffULL, 0x00000006792c7812ULL, 0x000fe400078e1e78ULL,
0x000000106e247c11ULL, 0x000fc6000f8e20ffULL, 0x0000003e343c723cULL, 0x000fe600000018ffULL,
0x000000002424783bULL, 0x000ee60000000200ULL, 0x0000001e3434723cULL, 0x000fe200000018ffULL,
0x000000001c1c783bULL, 0x000f2a0000000200ULL, 0x0000002e4014723cULL, 0x000fec0000001814ULL,
0x000000301018723cULL, 0x000fec0000001818ULL, 0x00000048104c723cULL, 0x002fec000000184cULL,
0x0000004a1048723cULL, 0x000fec0000001838ULL, 0x000000321030723cULL, 0x000fe2000000183cULL,
0x0000000477397812ULL, 0x000fc400078e1e78ULL, 0x0000000479387812ULL, 0x000fe400078e1e78ULL,
0x0000007439727212ULL, 0x080fe400078efcffULL, 0x0000007538717212ULL, 0x080fe200078efcffULL,
0x000000241020723cULL, 0x008fe20000001820ULL, 0x0000001072447c11ULL, 0x000fe4000f8e20ffULL,
0x0000001071387c11ULL, 0x000fe4000f8e20ffULL, 0x0000000677777812ULL, 0x000fe200078e1e78ULL,
0x000000261024723cULL, 0x000fe20000001834ULL, 0x000000752c757212ULL, 0x000fe200078efcffULL,
0x000000003810783bULL, 0x0002e20000000200ULL, 0x0000007477747212ULL, 0x000fc600078efcffULL,
0x0000001c4018723cULL, 0x010fe20000001818ULL, 0x0000000645347812ULL, 0x000fe200078e1e78ULL,
0x000000060d357836ULL, 0x000fe20000000000ULL, 0x000000004444783bULL, 0x000f220000000200ULL,
0x0000001076387c11ULL, 0x002fe4000f8e20ffULL, 0x0000007334737212ULL, 0x000fe200078efcffULL,
0x0000001e401c723cULL, 0x000fe20000001830ULL, 0x00000007352d7812ULL, 0x000fe400078e780eULL,
0x00000010733c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000003838783bULL, 0x000fe20000000200ULL,
0x0000001075347c11ULL, 0x000fe2000f8e20ffULL, 0x000000100e2d7824ULL, 0x000fe200078e022dULL,
0x0000001074777c11ULL, 0x000fc4000f8e20ffULL, 0x000000003c3c783bULL, 0x000fe40000000200ULL,
0x000000072d2d7c11ULL, 0x000fe4000f8e20ffULL, 0x000000003434783bULL, 0x000fe80000000200ULL,
0x000000002d2c783bULL, 0x000e680000000200ULL, 0x000000007730783bULL, 0x000f620000000200ULL,
0x00000010404c723cULL, 0x008fec000000184cULL, 0x000000124048723cULL, 0x000fec0000001848ULL,
0x000000444020723cULL, 0x010fec0000001820ULL, 0x000000464024723cULL, 0x000fec0000001824ULL,
0x0000003c2c28723cULL, 0x002fec0000001828ULL, 0x0000003e2c14723cULL, 0x000fec0000001814ULL,
0x000000382c18723cULL, 0x000fec0000001818ULL, 0x0000003a2c1c723cULL, 0x000fec000000181cULL,
0x000000342c4c723cULL, 0x000fec000000184cULL, 0x000000362c48723cULL, 0x000fec0000001848ULL,
0x000000302c20723cULL, 0x020fec0000001820ULL, 0x000000322c24723cULL, 0x000fe20000001824ULL,
0x000000006a1b82caULL, 0x004fc400000e0000ULL, 0x000000000000781cULL, 0x000fd60003f0f018ULL,
0x0000001b00148c82ULL, 0x000fe40008000000ULL, 0x00000009141b72a4ULL, 0x000fe2000f8e023fULL,
0x0000000800a48947ULL, 0x000ff60003800000ULL, 0x0000000f66107c36ULL, 0x000fe20008000000ULL,
0x0000000d2300728cULL, 0x000fe2000bf01070ULL, 0x0000000f60117c36ULL, 0x000fe20008000000ULL,
0x0000001063637c11ULL, 0x000fe2000f8e20ffULL, 0x000000100b2e7824ULL, 0x000fe200078e00ffULL,
0x0000001b102c7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000f62107c36ULL, 0x000fe20008000000ULL,
0x0000001b11117c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000d23047287ULL, 0x000fe2000c000000ULL,
0x000000702e2e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x000000122c2f7c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x0000001b10347c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000f5e107c36ULL, 0x000fe20008000000ULL,
0x000000132c2c7c11ULL, 0x000fe200080f4413ULL, 0x000000040d047290ULL, 0x000fe2000fffe13fULL,
0x0000001234337c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff137224ULL, 0x000fe200008e06ffULL,
0x0000001211317c11ULL, 0x000fc4000f8240ffULL, 0x0000001061617c11ULL, 0x000fe4000f8e20ffULL,
0x0000001334347c11ULL, 0x000fe400080f4413ULL, 0x0000001b10387c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000f5c107c36ULL, 0x000fe20008000000ULL, 0x0000001311377c11ULL, 0x000fe200088f4412ULL,
0x0000000f5a127c36ULL, 0x000fe20008000000ULL, 0x00000012382d7c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x0000000466007c0cULL, 0x000fc4000bf06070ULL,
0x0000001b10327c10ULL, 0x000fe4000ffbe0ffULL, 0x0000001338387c11ULL, 0x000fe400088f4411ULL,
0x0000002f2e107210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff137224ULL, 0x000fe200028e06ffULL,
0x0000000462007c0cULL, 0x000fe4000bf66070ULL, 0x0000001232357c11ULL, 0x000fe2000f8c40ffULL,
0x000000ffff117224ULL, 0x000fe200008e062cULL, 0x0000001b122f7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000f582c7c36ULL, 0x000fe20008000000ULL, 0x0000001332327c11ULL, 0x000fc4000b0f4413ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010637faeULL, 0x0003e2000c101c58ULL,
0x000000332e127210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff307224ULL, 0x000fe200008e06ffULL,
0x0000001b2c367c10ULL, 0x000fe2000ffde0ffULL, 0x0000000f562c7c36ULL, 0x000fe20008000000ULL,
0x000000122f3b7c11ULL, 0x040fe2000f8240ffULL, 0x000000ffff137224ULL, 0x000fe200000e0634ULL,
0x0000000460007c0cULL, 0x000fe4000bf86070ULL, 0x000000132f2f7c11ULL, 0x000fe200088f4430ULL,
0x0000000f52307c36ULL, 0x000fe20008000000ULL, 0x0000001236337c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff117224ULL, 0x002fe200030e06ffULL, 0x000000045e007c0cULL, 0x000fe2000bf46070ULL,
0x0000000012617faeULL, 0x0003e2000d901c58ULL, 0x0000001b2c347c10ULL, 0x000fc4000ff7e0ffULL,
0x000000312e2c7210ULL, 0x000fe40007fde0ffULL, 0x0000001336367c11ULL, 0x000fe200088f4411ULL,
0x000000ffff317224ULL, 0x000fe200018e06ffULL, 0x0000002d2e107210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200030e0637ULL, 0x000000105f5f7c11ULL, 0x000fe4000f8e20ffULL,
0x000000105d5d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff117224ULL, 0x000fe200008e0638ULL,
0x000000045c007c0cULL, 0x000fe2000bfa6070ULL, 0x0000000f54127c36ULL, 0x002fe20008000000ULL,
0x000000002c5f7faeULL, 0x0003e2000e101c58ULL, 0x0000001234377c11ULL, 0x000fc4000f8c40ffULL,
0x0000001059597c11ULL, 0x000fe2000f8e20ffULL, 0x00000000105d7faeULL, 0x0005e2000d101c58ULL,
0x0000001b123a7c10ULL, 0x000fe4000ff9e0ffULL, 0x000000352e127210ULL, 0x000fe40007f5e0ffULL,
0x0000001334347c11ULL, 0x000fe2000b0f4431ULL, 0x000000ffff317224ULL, 0x000fe200020e06ffULL,
0x000000123a397c11ULL, 0x000fe2000f8840ffULL, 0x000000ffff137224ULL, 0x000fe200010e0632ULL,
0x0000001b30327c10ULL, 0x000fe2000ffde0ffULL, 0x0000000f502c7c36ULL, 0x002fe20008000000ULL,
0x000000045a007c0cULL, 0x000fe2000bf06070ULL, 0x0000000f00107c36ULL, 0x004fe20008000000ULL,
0x000000133a3a7c11ULL, 0x000fe2000a0f4431ULL, 0x000000ffff117224ULL, 0x000fe200030e06ffULL,
0x0000000012597faeULL, 0x0003e2000e901c58ULL, 0x0000001232357c11ULL, 0x000fc4000f8840ffULL,
0x0000001b2c387c10ULL, 0x000fe4000ffbe0ffULL, 0x0000003b2e307210ULL, 0x000fe40007fde0ffULL,
0x0000000458007c0cULL, 0x000fe4000bf66070ULL, 0x0000001332327c11ULL, 0x000fe2000a0f4411ULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x000000332e2c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x000fe200030e062fULL, 0x0000001238337c11ULL, 0x000fe2000f8a40ffULL,
0x0000000f04127c36ULL, 0x002fe20008000000ULL, 0x0000001057577c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2d7224ULL, 0x000fe200020e0636ULL, 0x0000001338387c11ULL, 0x000fc4000a8f4411ULL,
0x0000000456007c0cULL, 0x000fe2000bf26070ULL, 0x0000000030577faeULL, 0x0003e2000c101c58ULL,
0x0000001b10367c10ULL, 0x000fe4000ffbe0ffULL, 0x0000001055557c11ULL, 0x000fe4000f8e20ffULL,
0x000000372e107210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200028e06ffULL,
0x0000001053537c11ULL, 0x000fe2000f8e20ffULL, 0x000000002c557faeULL, 0x0005e2000d901c58ULL,
0x0000001236377c11ULL, 0x000fe2000f8640ffULL, 0x000000ffff117224ULL, 0x000fe200000e0634ULL,
0x0000001b12347c10ULL, 0x000fc4000ffbe0ffULL, 0x0000000400007c0cULL, 0x000fe2000bf06070ULL,
0x0000000f06007c36ULL, 0x000fe20008000000ULL, 0x0000001336367c11ULL, 0x000fe200098f4413ULL,
0x000000ffff137224ULL, 0x000fe200028e06ffULL, 0x0000001234317c11ULL, 0x002fe2000f8640ffULL,
0x0000000010537faeULL, 0x0003e2000c901c58ULL, 0x0000001b00007c10ULL, 0x000fe4000ffbe0ffULL,
0x000000392e127210ULL, 0x000fe40007f3e0ffULL, 0x0000000454007c0cULL, 0x000fe2000bf46070ULL,
0x000000ffff2f7224ULL, 0x000fe200028e06ffULL, 0x0000001334347c11ULL, 0x000fe200098f4413ULL,
0x000000ffff137224ULL, 0x000fe200008e063aULL, 0x000000352e2c7210ULL, 0x004fc40007f7e0ffULL,
0x0000001200357c11ULL, 0x040fe4000f8240ffULL, 0x0000001051517c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2d7224ULL, 0x000fe200018e0632ULL, 0x0000001300327c11ULL, 0x000fe200088f442fULL,
0x0000000f08007c36ULL, 0x000fe20008000000ULL, 0x0000000452007c0cULL, 0x000fe2000bf86070ULL,
0x0000000012517faeULL, 0x0005e2000d101c58ULL, 0x0000000406007c0cULL, 0x000fe4000bf66070ULL,
0x0000001b00067c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000f0a007c36ULL, 0x000fe20008000000ULL,
0x000000332e107210ULL, 0x002fc40007f5e0ffULL, 0x000000100f2f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e06ffULL, 0x0000001206337c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff117224ULL, 0x000fe200010e0638ULL, 0x0000001b00007c10ULL, 0x000fe2000ff5e0ffULL,
0x000000002c2f7faeULL, 0x0003e2000e101c58ULL, 0x0000000450007c0cULL, 0x000fe4000bfc6070ULL,
0x0000001306067c11ULL, 0x000fe200088f440fULL, 0x000000ffff0f7224ULL, 0x000fe200010e06ffULL,
0x0000000404007c0cULL, 0x000fc4000bfa6070ULL, 0x000000372e307210ULL, 0x000fe40007f9e0ffULL,
0x000000312e127210ULL, 0x004fe40007f3e0ffULL, 0x0000001005377c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff317224ULL, 0x000fe200020e0636ULL, 0x00000012002f7c11ULL, 0x002fe2000f8440ffULL,
0x000000ffff137224ULL, 0x000fe200008e0634ULL, 0x00000010022d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001300007c11ULL, 0x000fc400090f440fULL, 0x00000010030f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000102d7faeULL, 0x0003e2000f101c58ULL, 0x0000000408007c0cULL, 0x000fe4000bf86070ULL,
0x000000040a007c0cULL, 0x000fe2000bf26070ULL, 0x00000000300f7faeULL, 0x0003e2000c101c58ULL,
0x000000352e027210ULL, 0x000fe40007f1e0ffULL, 0x000000332e047210ULL, 0x000fe20007f5e0ffULL,
0x0000000012377faeULL, 0x0003e2000e901c58ULL, 0x0000002f2e2e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff037224ULL, 0x000fe200000e0632ULL, 0x0000001007077c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff057224ULL, 0x000fe200010e0606ULL, 0x0000001009097c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2f7224ULL, 0x000fe200028e0600ULL, 0x000000100c337c11ULL, 0x000fe2000f8e20ffULL,
0x0000000002077faeULL, 0x0003e8000d901c58ULL, 0x0000000004097faeULL, 0x0003e8000e101c58ULL,
0x000000002e337faeULL, 0x0003e2000c901c58ULL, 0x0000000800547947ULL, 0x000fea0003800000ULL,
0x0000000f66107c36ULL, 0x000fe20008000000ULL, 0x0000001063637c11ULL, 0x000fe2000f8e20ffULL,
0x0000000f62627c36ULL, 0x000fe20008000000ULL, 0x0000001061617c11ULL, 0x000fe2000f8e20ffULL,
0x0000000f60607c36ULL, 0x000fe20008000000ULL, 0x0000001b10107c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000f5e5e7c36ULL, 0x000fe20008000000ULL, 0x0000001b62627c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000f5c5c7c36ULL, 0x000fe20008000000ULL, 0x0000001b60607c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x0000001210407c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff137224ULL, 0x000fe200008e06ffULL, 0x00000012623e7c11ULL, 0x000fe2000f8240ffULL,
0x0000000f5a5a7c36ULL, 0x000fe20008000000ULL, 0x0000001310347c11ULL, 0x000fe200080f4411ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x0000001362107c11ULL, 0x000fe200088f4413ULL,
0x0000000f58587c36ULL, 0x000fe20008000000ULL, 0x00000012603c7c11ULL, 0x000fe2000f8040ffULL,
0x0000000f56567c36ULL, 0x000fe20008000000ULL, 0x0000001b5e5e7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000f54547c36ULL, 0x000fe20008000000ULL, 0x0000001360127c11ULL, 0x000fe200080f4411ULL,
0x0000000f50507c36ULL, 0x000fe20008000000ULL, 0x0000001b5c5c7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x0000001b5a5a7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000f00007c36ULL, 0x000fe20008000000ULL, 0x000000125e3a7c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x000000125c387c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff2d7224ULL, 0x000fe200018e06ffULL, 0x000000135e2c7c11ULL, 0x000fe200080f4411ULL,
0x0000000f04047c36ULL, 0x000fe20008000000ULL, 0x0000001b58587c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000f08087c36ULL, 0x000fe20008000000ULL, 0x000000125a367c11ULL, 0x000fe2000f8440ffULL,
0x0000000f06067c36ULL, 0x000fe20008000000ULL, 0x000000135c2e7c11ULL, 0x000fe200088f4413ULL,
0x000000ffff317224ULL, 0x000fe200000e06ffULL, 0x000000135a307c11ULL, 0x000fe200090f442dULL,
0x0000000f522d7c36ULL, 0x000fe20008000000ULL, 0x0000001b56117c10ULL, 0x000fe2000ff3e0ffULL,
0x000000100b457824ULL, 0x000fe200078e00ffULL, 0x0000001258567c11ULL, 0x000fc4000f8040ffULL,
0x0000001b54137c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x0000001358317c11ULL, 0x000fe400080f4431ULL, 0x0000001211547c11ULL, 0x040fe2000f8240ffULL,
0x000000ffff427224ULL, 0x000fe200010e06ffULL, 0x0000001b2d2d7c10ULL, 0x000fe4000ff1e0ffULL,
0x0000001311117c11ULL, 0x000fe400088f4432ULL, 0x0000001213527c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x000000122d467c11ULL, 0x000fc4000f8040ffULL,
0x0000001313137c11ULL, 0x000fe400090f4442ULL, 0x0000001b502f7c10ULL, 0x000fe4000ff3e0ffULL,
0x000000132d2d7c11ULL, 0x000fe400080f4432ULL, 0x0000001b00327c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0x0000001b04357c10ULL, 0x000fe4000ff7e0ffULL,
0x000000122f507c11ULL, 0x040fe2000f8040ffULL, 0x000000ffff337224ULL, 0x000fe200010e06ffULL,
0x0000001232447c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff427224ULL, 0x000fe200018e06ffULL,
0x000000132f2f7c11ULL, 0x000fc400080f4400ULL, 0x0000001332007c11ULL, 0x000fe200088f4433ULL,
0x0000000f0a327c36ULL, 0x000fe20008000000ULL, 0x0000001235047c11ULL, 0x040fe4000f8440ffULL,
0x0000001b060a7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000001335337c11ULL, 0x000fe400090f4442ULL,
0x0000001b32437c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff357224ULL, 0x000fe200000e06ffULL,
0x0000001b08427c10ULL, 0x000fc4000ff3e0ffULL, 0x0000007045457812ULL, 0x000fe200078ec0ffULL,
0x000000ffff587224ULL, 0x000fe200010e06ffULL, 0x0000001243327c11ULL, 0x040fe2000f8440ffULL,
0x000000ffff377224ULL, 0x000fe200008e06ffULL, 0x0000001242087c11ULL, 0x000fe4000f8240ffULL,
0x000000120a067c11ULL, 0x000fe4000f8040ffULL, 0x0000001343437c11ULL, 0x000fe400090f4458ULL,
0x0000004045407210ULL, 0x000fc40007f5e0ffULL, 0x0000001342427c11ULL, 0x000fe400088f4437ULL,
0x0000003e453e7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff417224ULL, 0x000fe200010e0634ULL,
0x000000130a0a7c11ULL, 0x000fe400080f4435ULL, 0x0000003c453c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e0610ULL, 0x0000003a453a7210ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040637faeULL, 0x000fe2000b901c58ULL,
0x0000003845387210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff3d7224ULL, 0x000fe200008e0612ULL,
0x0000003645367210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e062cULL,
0x0000005645347210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff397224ULL, 0x000fe200028e062eULL,
0x0000005445107210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff377224ULL, 0x000fe200020e0630ULL,
0x000000105f5f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff357224ULL, 0x000fe200018e0631ULL,
0x0000005245127210ULL, 0x000fe20007f3e0ffULL, 0x000000003e617faeULL, 0x000fe2000b901c58ULL,
0x000000105d5d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0x00000046452c7210ULL, 0x000fe20007f1e0ffULL, 0x000000003c5f7faeULL, 0x000fe2000b901c58ULL,
0x0000001059597c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff137224ULL, 0x000fe200008e0613ULL,
0x0000001057577c11ULL, 0x000fe2000f8e20ffULL, 0x000000003a5d7faeULL, 0x0005e2000b901c58ULL,
0x0000001055557c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff2d7224ULL, 0x000fe200000e062dULL,
0x00000050452e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000038597faeULL, 0x000fe2000b901c58ULL,
0x0000001053537c11ULL, 0x000fc4000f8e20ffULL, 0x0000004445307210ULL, 0x000fe20007f9e0ffULL,
0x0000000036577faeULL, 0x0007e2000b901c58ULL, 0x0000001051517c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2f7224ULL, 0x000fe200028e062fULL, 0x0000000445047210ULL, 0x000fe20007f7e0ffULL,
0x0000000034557faeULL, 0x000fe2000b901c58ULL, 0x000000100f0f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff317224ULL, 0x000fe200020e0600ULL, 0x0000000645067210ULL, 0x000fe20007f5e0ffULL,
0x0000000010537faeULL, 0x0009e2000b901c58ULL, 0x0000000845087210ULL, 0x000fc40007f3e0ffULL,
0x0000003245327210ULL, 0x000fe20007f1e0ffULL, 0x0000000012517faeULL, 0x000be2000b901c58ULL,
0x00000010023b7c11ULL, 0x004fe4000f8e20ffULL, 0x0000001003037c11ULL, 0x000fe2000f8e20ffULL,
0x000000002c0f7faeULL, 0x0005e2000b901c58ULL, 0x0000001005377c11ULL, 0x008fe2000f8e20ffULL,
0x000000ffff057224ULL, 0x000fe200018e0633ULL, 0x0000001007117c11ULL, 0x010fe2000f8e20ffULL,
0x000000ffff077224ULL, 0x000fe200010e060aULL, 0x000000002e3b7faeULL, 0x0003e2000b901c58ULL,
0x000000ffff337224ULL, 0x000fe200000e0643ULL, 0x000000100c137c11ULL, 0x020fc4000f8e20ffULL,
0x0000000030037faeULL, 0x0003e2000b901c58ULL, 0x00000010090f7c11ULL, 0x004fe2000f8e20ffULL,
0x000000ffff097224ULL, 0x000fe400008e0642ULL, 0x0000000004377faeULL, 0x0003e8000b901c58ULL,
0x0000000006117faeULL, 0x0003e8000b901c58ULL, 0x00000000080f7faeULL, 0x0003e8000b901c58ULL,
0x0000000032137faeULL, 0x0003e4000b901c58ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000080d037836ULL, 0x042fe20000000000ULL, 0x0000001a68047c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a0d097836ULL, 0x000fe20000000000ULL, 0x0000001a672c7c11ULL, 0x000fe2000f8e20ffULL,
0x00000001ff007424ULL, 0x000fe200078e00ffULL, 0x0000000703037812ULL, 0x000fe200078e780eULL,
0x000000040b087824ULL, 0x000fe200078e00ffULL, 0x0000001a69307c11ULL, 0x000fe2000f8e20ffULL,
0x000000071e0d7291ULL, 0x000fe2000f8e383fULL, 0x0000000709097812ULL, 0x000fe200078e780eULL,
0x000000100e037824ULL, 0x000fe200078e0203ULL, 0x0000001a6c347c11ULL, 0x000fc4000f8e20ffULL,
0x0000001a65387c11ULL, 0x000fe2000f8e20ffULL, 0x000000100e097824ULL, 0x000fe200078e0209ULL,
0x0000000703037c11ULL, 0x000fe4000f8e20ffULL, 0x0000001a6b6b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001a6e6e7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001a6f6f7c11ULL, 0x000fe2000f8e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000404783bULL, 0x000fe20000000200ULL,
0x0000001a71407c11ULL, 0x000fe4000f8e20ffULL, 0x0000001a723c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000000310783bULL, 0x0002a20000000200ULL, 0x0000001a76767c11ULL, 0x000fe4000f8e20ffULL,
0x0000001a75757c11ULL, 0x000fe2000f8e20ffULL, 0x000000002c2c783bULL, 0x000ee20000000200ULL,
0xfffffff008087812ULL, 0x000fc600078ec0ffULL, 0x000000003030783bULL, 0x000f220000000200ULL,
0x0000000c0d037836ULL, 0x042fe40000000000ULL, 0x0000000e0d0d7836ULL, 0x000fe20000000000ULL,
0x000000003434783bULL, 0x000e640000000200ULL, 0x0000000703037812ULL, 0x000fe400078e780eULL,
0x000000003838783bULL, 0x000fe20000000200ULL, 0x000000070d0d7812ULL, 0x000fe400078e780eULL,
0x000000100e037824ULL, 0x040fe200078e0203ULL, 0x000000004040783bULL, 0x000fe40000000200ULL,
0x000000100e0d7824ULL, 0x000fc400078e020dULL, 0x0000000703037c11ULL, 0x000fe2000f8e20ffULL,
0x000000003c3c783bULL, 0x000fe40000000200ULL, 0x000000070d0d7c11ULL, 0x000fcc000f8e20ffULL,
0x000000000d0c783bULL, 0x000fe20000000200ULL, 0x000000041028723cULL, 0x004fec0000001828ULL,
0x000000061014723cULL, 0x000fe20000001814ULL, 0x0000000709047c11ULL, 0x000fca000f8e20ffULL,
0x0000002c1018723cULL, 0x008fe20000001818ULL, 0x000000000404783bULL, 0x000eaa0000000200ULL,
0x0000002e102c723cULL, 0x000fe2000000181cULL, 0x000000006b1c783bULL, 0x000eea0000000200ULL,
0x00000030104c723cULL, 0x010fec000000184cULL, 0x000000321048723cULL, 0x000fe20000001848ULL,
0x0000001a6d307c11ULL, 0x000fca000f8e20ffULL, 0x000000341020723cULL, 0x002fe20000001820ULL,
0x000000003030783bULL, 0x000e6a0000000200ULL, 0x000000361024723cULL, 0x000fe20000001824ULL,
0x000000006e10783bULL, 0x000f280000000200ULL, 0x000000000334783bULL, 0x000fe20000000200ULL,
0x000000380428723cULL, 0x004fec0000001828ULL, 0x0000003a0438723cULL, 0x000fe20000001814ULL,
0x000000006f14783bULL, 0x000eaa0000000200ULL, 0x0000001c0418723cULL, 0x008fec0000001818ULL,
0x0000001e042c723cULL, 0x000fe2000000182cULL, 0x0000001a701c7c11ULL, 0x000fca000f8e20ffULL,
0x00000030044c723cULL, 0x002fe2000000184cULL, 0x000000001c1c783bULL, 0x000e6a0000000200ULL,
0x000000100420723cULL, 0x010fe20000001820ULL, 0x0000001a73307c11ULL, 0x000fca000f8e20ffULL,
0x000000120410723cULL, 0x000fec0000001824ULL, 0x000000320448723cULL, 0x000fe20000001848ULL,
0x0000001a74247c11ULL, 0x000fe2000f8e20ffULL, 0x000000003030783bULL, 0x000fe80000000200ULL,
0x000000143444723cULL, 0x004fe20000001828ULL, 0x000000007604783bULL, 0x000ea80000000200ULL,
0x000000007528783bULL, 0x000ee20000000200ULL, 0x000000163438723cULL, 0x000fe60000001838ULL,
0x000000002424783bULL, 0x000f220000000200ULL, 0x01b68800ff0279a7ULL, 0x000f640008500015ULL,
0x00000040344c723cULL, 0x000fec000000184cULL, 0x0000001c3418723cULL, 0x002fec0000001818ULL,
0x0000001e342c723cULL, 0x000fec000000182cULL, 0x000000423414723cULL, 0x000fe20000001848ULL,
0x01b68803ff0075a7ULL, 0x020e6a0008000155ULL, 0x0000003c3420723cULL, 0x000fec0000001820ULL,
0x0000003e3434723cULL, 0x000fec0000001810ULL, 0x000000040c1c723cULL, 0x004fec0000001818ULL,
0x000000060c18723cULL, 0x000fec000000182cULL, 0x000000300c44723cULL, 0x000fec0000001844ULL,
0x000000320c38723cULL, 0x000fec0000001838ULL, 0x000000280c10723cULL, 0x008fe2000000184cULL,
0x3db504f31c1c7820ULL, 0x000fe20000410000ULL, 0x3db504f31d1d7820ULL, 0x000fe20000410000ULL,
0x3db504f31e1e7820ULL, 0x000fe20000410000ULL, 0x3db504f31f1f7820ULL, 0x000fc40000410000ULL,
0x0000002a0c14723cULL, 0x000fe20000001814ULL, 0x3db504f318187820ULL, 0x000fe20000410000ULL,
0x3db504f319197820ULL, 0x000fe20000410000ULL, 0x3db504f31a1a7820ULL, 0x000fe20000410000ULL,
0x3db504f31b1b7820ULL, 0x000fe40000410000ULL, 0x000000240c04723cULL, 0x010fe20000001820ULL,
0x3db504f344097820ULL, 0x000fe20000410000ULL, 0x3db504f3450a7820ULL, 0x000fc80000410000ULL,
0x000000260c0c723cULL, 0x000fe20000001834ULL, 0x3db504f346207820ULL, 0x000fe20000410000ULL,
0x3db504f347217820ULL, 0x000fe20000410000ULL, 0x3db504f338387820ULL, 0x000fe20000410000ULL,
0x3db504f339397820ULL, 0x000fe20000410000ULL, 0x3db504f33a3a7820ULL, 0x000fe20000410000ULL,
0x3db504f310227820ULL, 0x000fe20000410000ULL, 0x3db504f311237820ULL, 0x000fe20000410000ULL,
0x3db504f33b3b7820ULL, 0x000fe20000410000ULL, 0x3db504f312127820ULL, 0x000fe20000410000ULL,
0x3db504f313137820ULL, 0x000fc40000410000ULL, 0x3db504f314147820ULL, 0x000fe20000410000ULL,
0x3db504f315157820ULL, 0x000fe20000410000ULL, 0x3db504f316167820ULL, 0x000fe20000410000ULL,
0x3db504f317177820ULL, 0x000fc60000410000ULL, 0x3db504f304247820ULL, 0x000fe20000410000ULL,
0x3db504f305257820ULL, 0x000fe20000410000ULL, 0x3db504f306107820ULL, 0x000fe20000410000ULL,
0x3db504f307117820ULL, 0x000fc60000410000ULL, 0x3db504f30c0c7820ULL, 0x000fe20000410000ULL,
0x3db504f30d0d7820ULL, 0x000fe20000410000ULL, 0x3db504f30e0e7820ULL, 0x000fe20000410000ULL,
0x3db504f30f0f7820ULL, 0x000fe20000410000ULL, 0x0000001000c88947ULL, 0x002fec0003800000ULL,
0x01b4000d08047984ULL, 0x0002a20008000c00ULL, 0x000000165b007c0cULL, 0x000fda000bf05270ULL,
0x0000000400080947ULL, 0x002fea0003800000ULL, 0x000000020b027824ULL, 0x000fe200078e00ffULL,
0x8000000e230e7290ULL, 0x000fc8000fffe03fULL, 0x0000000602027812ULL, 0x000fc800078ec0ffULL,
0x0000000102037812ULL, 0x040fe400078efcffULL, 0x0000000802267812ULL, 0x040fe400078efcffULL,
0x0000000e03007c0cULL, 0x000fe4000bf26070ULL, 0x0000001002037812ULL, 0x000fe400078efcffULL,
0x0000000e26007c0cULL, 0x000fe4000bf06070ULL, 0x0000000e03007c0cULL, 0x000fc4000bfc6070ULL,
0x0000001102267812ULL, 0x040fe400078efcffULL, 0x0000001802037812ULL, 0x040fe400078efcffULL,
0x0000000e02007c0cULL, 0x000fe4000bf46070ULL, 0x0000000e26007c0cULL, 0x000fe4000bfa6070ULL,
0x0000000e03007c0cULL, 0x000fe4000bf66070ULL, 0x0000000902277812ULL, 0x000fc400078efcffULL,
0x0000001902267812ULL, 0x040fe400078efcffULL, 0x0000002002037812ULL, 0x000fe400078efcffULL,
0xff7fffff20207808ULL, 0x000fe40005000000ULL, 0xff7fffff09097808ULL, 0x000fe40005000000ULL,
0xff7fffff21217808ULL, 0x000fe40004800000ULL, 0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL,
0x0000000e27007c0cULL, 0x000fe4000bf86070ULL, 0x0000000e26007c0cULL, 0x000fe4000bf46070ULL,
0x0000000e03007c0cULL, 0x000fe4000bf26070ULL, 0x0000002102267812ULL, 0x040fe400078efcffULL,
0x0000002802037812ULL, 0x000fe400078efcffULL, 0xff7fffff3a3a7808ULL, 0x000fc40004000000ULL,
0xff7fffff38387808ULL, 0x000fe40004000000ULL, 0xff7fffff3b3b7808ULL, 0x000fe40006000000ULL,
0xff7fffff39397808ULL, 0x000fe40006000000ULL, 0x0000000e26007c0cULL, 0x000fe4000bf06070ULL,
0x0000000e03007c0cULL, 0x000fe4000bf86070ULL, 0x0000002902267812ULL, 0x000fc400078efcffULL,
0x0000003002037812ULL, 0x000fe400078efcffULL, 0xff7fffff1e1e7808ULL, 0x000fe40007000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40007000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40006800000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40006800000ULL, 0x0000000e26007c0cULL, 0x000fc4000bfc6070ULL,
0x0000000e03007c0cULL, 0x000fe4000bfa6070ULL, 0x0000003102267812ULL, 0x040fe400078efcffULL,
0x0000003802037812ULL, 0x040fe400078efcffULL, 0x0000003902027812ULL, 0x000fe400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40005800000ULL, 0xff7fffff18187808ULL, 0x000fc40005800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005000000ULL, 0xff7fffff19197808ULL, 0x000fe40005000000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0xff7fffff22227808ULL, 0x000fe40004800000ULL,
0x0000000e26007c0cULL, 0x000fe4000bf66070ULL, 0x0000000e03007c0cULL, 0x000fc4000bf46070ULL,
0x0000000e02007c0cULL, 0x000fe4000bf26070ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff23237808ULL, 0x000fe40004000000ULL, 0xff7fffff16167808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff17177808ULL, 0x000fc40007000000ULL,
0xff7fffff15157808ULL, 0x000fe40007000000ULL, 0xff7fffff10107808ULL, 0x000fe40006800000ULL,
0xff7fffff24247808ULL, 0x000fe40006800000ULL, 0xff7fffff11117808ULL, 0x000fe40005800000ULL,
0xff7fffff25257808ULL, 0x000fe40005800000ULL, 0xff7fffff0e0e7808ULL, 0x000fc40005000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40005000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40004800000ULL,
0xff7fffff0d0d7808ULL, 0x000fce0004800000ULL, 0x0000000904037209ULL, 0x004fe20007810000ULL,
0xffffffff00047882ULL, 0x000fe20000000000ULL, 0x0000002005027209ULL, 0x000fe40007810000ULL,
0x0000000a03037209ULL, 0x000fe40007810000ULL, 0x0000002102057209ULL, 0x000fe40007810000ULL,
0x0000003803027209ULL, 0x000fe40007810000ULL, 0x0000003a05047209ULL, 0x000fc40007810000ULL,
0x0000003902037209ULL, 0x000fe40007810000ULL, 0x0000003b04057209ULL, 0x000fe40007810000ULL,
0x0000001c03027209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000001d02037209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fc40007810000ULL,
0x0000001803027209ULL, 0x000fe40007810000ULL, 0x0000001a05047209ULL, 0x000fe40007810000ULL,
0x0000001902037209ULL, 0x000fe40007810000ULL, 0x0000001b04057209ULL, 0x000fe40007810000ULL,
0x0000002203027209ULL, 0x000fe40007810000ULL, 0x0000001205047209ULL, 0x000fc40007810000ULL,
0x0000002302037209ULL, 0x000fe40007810000ULL, 0x0000001304057209ULL, 0x000fe40007810000ULL,
0x0000001403027209ULL, 0x000fe40007810000ULL, 0x0000001605047209ULL, 0x000fe40007810000ULL,
0x0000001502037209ULL, 0x000fe40007810000ULL, 0x0000001704057209ULL, 0x000fc40007810000ULL,
0x0000002403027209ULL, 0x000fe40007810000ULL, 0x0000001005047209ULL, 0x000fe40007810000ULL,
0x0000002502037209ULL, 0x000fe40007810000ULL, 0x0000001104057209ULL, 0x000fe40007810000ULL,
0x0000000c03027209ULL, 0x000fe40007810000ULL, 0x0000000e05047209ULL, 0x000fc40007810000ULL,
0x0000000d02037209ULL, 0x000fe40007810000ULL, 0x0000000f04047209ULL, 0x000fe20007810000ULL,
0x0000000e04447947ULL, 0x000fec000b800000ULL, 0x0c401f0003027f89ULL, 0x000e6800000e0000ULL,
0x0c401f0004057f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006297f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007287f89ULL, 0x000f2200000e0000ULL, 0x0000000203267209ULL, 0x002fc40007810000ULL,
0x0000000504277209ULL, 0x004fc60007810000ULL, 0x0c201f0026057f89ULL, 0x000e6200000e0000ULL,
0x0000002906297209ULL, 0x008fc60007810000ULL, 0x0c201f00272a7f89ULL, 0x000ea200000e0000ULL,
0x0000002807027209ULL, 0x010fc60007810000ULL, 0x0c201f00292c7f89ULL, 0x000ee800000e0000ULL,
0x0c201f0002037f89ULL, 0x00092200000e0000ULL, 0x0000000526047209ULL, 0x002fe40007810000ULL,
0x0000002a27057209ULL, 0x004fe40007810000ULL, 0x0000002c29067209ULL, 0x008fce0007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b052d7820ULL, 0x000fc60000410000ULL,
0x3fb8aa3b09097823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b21217823ULL, 0x000fe2000001082dULL,
0x0000001d00277308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL,
0x0000001800287308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0d077823ULL, 0x000fe20000010807ULL,
0x3c003c00ff0d7424ULL, 0x000fc400078e00ffULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b12127823ULL, 0x100fe2000001082dULL,
0x0000000900097308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b0f0f7823ULL, 0x000fca000001082dULL,
0x0000000a000a7308ULL, 0x000ff00000000800ULL, 0x0000003800387308ULL, 0x000ff00000000800ULL,
0x0000003900397308ULL, 0x000ff00000000800ULL, 0x00000020001d7308ULL, 0x000ff00000000800ULL,
0x0000002100187308ULL, 0x000e700000000800ULL, 0x0000003a003a7308ULL, 0x000fe20000000800ULL,
0x0000001d181d723eULL, 0x002fce00000000ffULL, 0x0000003b003b7308ULL, 0x000e700000000800ULL,
0x0000001900297308ULL, 0x0005f00000000800ULL, 0x00000022002a7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b1e197823ULL, 0x004fe2000001082dULL, 0x00000038391e723eULL, 0x000fcc00000000ffULL,
0x0000001c00267308ULL, 0x0005620000000800ULL, 0x3fb8aa3b1f227823ULL, 0x008fe2000001082dULL,
0x0000003a3b1f723eULL, 0x002fcc00000000ffULL, 0x0000000c002c7308ULL, 0x0003e20000000800ULL,
0x000000090a1c723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b1a097823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b1b0a7823ULL, 0x000fe2000001082dULL, 0x000000262720723eULL, 0x020fc800000000ffULL,
0x00000023002b7308ULL, 0x000fe20000000800ULL, 0x3c003c00ff0c7424ULL, 0x002fce00078e00ffULL,
0x0000001900237308ULL, 0x0003f00000000800ULL, 0x00000022002e7308ULL, 0x0004e20000000800ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000c1c18723cULL, 0x002fe400000018ffULL,
0x0000000900097308ULL, 0x000fe20000000800ULL, 0x000000282922723eULL, 0x004fc400000000ffULL,
0x000000232e21723eULL, 0x008fca00000000ffULL, 0x0000000a000a7308ULL, 0x000e700000000800ULL,
0x0000001400147308ULL, 0x000fe20000000800ULL, 0x000000090a23723eULL, 0x002fce00000000ffULL,
0x0000001500157308ULL, 0x000e620000000800ULL, 0x3fb8aa3b10097823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b110a7823ULL, 0x000fe2000001082dULL, 0x0000002a2b10723eULL, 0x000fe200000000ffULL,
0x0000000c2018723cULL, 0x000fe80000001818ULL, 0x00000012002f7308ULL, 0x0003f00000000800ULL,
0x0000001300307308ULL, 0x000ea20000000800ULL, 0x000000141512723eULL, 0x002fce00000000ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x0000002f3011723eULL, 0x004fce00000000ffULL,
0x0000001700177308ULL, 0x000e700000000800ULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x000000161713723eULL, 0x002fce00000000ffULL, 0x0000002500257308ULL, 0x000e620000000800ULL,
0x0000000c1018723cULL, 0x000fee0000001818ULL, 0x0000000700077308ULL, 0x000ea20000000800ULL,
0x000000242514723eULL, 0x002fce00000000ffULL, 0x0000000900097308ULL, 0x000fe20000000800ULL,
0x0000002c0716723eULL, 0x004fce00000000ffULL, 0x0000000a000a7308ULL, 0x000e620000000800ULL,
0xfffffffc0b077812ULL, 0x000fce00078ec0ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x000000090a15723eULL, 0x002fce00000000ffULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x0000000fff0a7424ULL, 0x000fca00078e00ffULL, 0x000000070a097219ULL, 0x000fe400000006ffULL,
0x0000000302077209ULL, 0x010fe40007810000ULL, 0x0000000e0f17723eULL, 0x002fce00000000ffULL,
0x0000000c1418723cULL, 0x000fde0000001818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x001c1fff180c7589ULL, 0x00026200000e0000ULL, 0x00000000000e7806ULL, 0x000fe200038e0100ULL,
0x00000000090a73a1ULL, 0x000eb000000e8000ULL, 0x00000000090473c4ULL, 0x000ee20000004000ULL,
0x00000000000e7886ULL, 0x000fc400038e0100ULL, 0x0000000e09ff7c12ULL, 0x004fda000f80400aULL,
0x0000000a04588947ULL, 0x00afea000b800000ULL, 0x001c1fff1a0d7589ULL, 0x0002a800000e0000ULL,
0x001c1fff0e0e7589ULL, 0x000ee800000e0000ULL, 0x001c1fff000f7589ULL, 0x00032400000e0000ULL,
0xfffffff8ff647812ULL, 0x000fe200078ee264ULL, 0x000000071e047291ULL, 0x000fe2000f8e583fULL,
0x0000000366197812ULL, 0x000fe200078ec0ffULL, 0x000000ffff247224ULL, 0x000fe200078e001cULL,
0x000000030bff7812ULL, 0x000fe2000780c0ffULL, 0x00000008640a7836ULL, 0x040fe20000000000ULL,
0x00000004191b7812ULL, 0x000fe200078efcffULL, 0x0000000864027824ULL, 0x000fe200078e00ffULL,
0x0000000719037812ULL, 0x000fe200078e7864ULL, 0x00000004ff1a7e24ULL, 0x002fe2000f8e00ffULL,
0x000000071b097812ULL, 0x000fe200078e7864ULL, 0x000000080a187824ULL, 0x000fe200078e00ffULL,
0x0000000719197812ULL, 0x000fe200078e780aULL, 0x000000ffff257224ULL, 0x000fe200078e001eULL,
0x000000071b1b7812ULL, 0x000fe200078e780aULL, 0x000110001a0a7836ULL, 0x000fe20000000000ULL,
0x0000000203037212ULL, 0x080fe200078efcffULL, 0x000000ffff267224ULL, 0x000fe200078e0020ULL,
0x0000000209097212ULL, 0x000fe200078efcffULL, 0x000000ffff277224ULL, 0x000fe200078e0022ULL,
0x0000001819197212ULL, 0x080fe200078efcffULL, 0x0000001003037824ULL, 0x000fe200078e020aULL,
0x000000181b1b7212ULL, 0x000fe200078efcffULL, 0x000000ffff287224ULL, 0x000fc400078e0010ULL,
0x000000ffff1c7224ULL, 0x000fe200078e001dULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000002403007844ULL, 0x0003e20000000200ULL, 0x0000001009097824ULL, 0x000fe400078e020aULL,
0x000000ffff297224ULL, 0x000fe400078e0012ULL, 0x000000ffff2a7224ULL, 0x000fc400078e0014ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0016ULL, 0x000000ffff1d7224ULL, 0x000fe400078e001fULL,
0x000000ffff107224ULL, 0x000fe200078e0011ULL, 0x0000002809007844ULL, 0x0003e20000000200ULL,
0x0000001019197824ULL, 0x000fe400078e020aULL, 0x000000ffff1e7224ULL, 0x000fe400078e0021ULL,
0x000000ffff1f7224ULL, 0x000fc400078e0023ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000101b1b7824ULL, 0x000fe200078e020aULL, 0x0000001c19007844ULL, 0x0003e20000000200ULL,
0x000000ffff127224ULL, 0x000fe400078e0015ULL, 0x000000ffff137224ULL, 0x000fe400078e0017ULL,
0x0000000cff5b7e24ULL, 0x000fc6000f8e00ffULL, 0x000000101b007844ULL, 0x0003e20000000200ULL,
0x000000080c00728cULL, 0x000fc6000bf06070ULL, 0x01b0000408008988ULL, 0x0003e80008000c0dULL,
0x01b2000c08008988ULL, 0x01c3e20008000c0dULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x01b60800ffff79a7ULL, 0x0003e20008500017ULL, 0x01b61000ffff79a7ULL, 0x0003e20008500017ULL,
0x01b61800ffff79a7ULL, 0x0003e20008500017ULL, 0x01b62000ffff79a7ULL, 0x0003f20008500017ULL,
0xffffffac00a48947ULL, 0x002fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x01b6080dff0075a7ULL, 0x0002620008040164ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x01b6080dff00a5a7ULL, 0x000e640008040064ULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xffffff1800b47947ULL, 0x020fea000383ffffULL,
0x01b6280dff0075a7ULL, 0x0002620008020164ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01b6280dff0095a7ULL, 0x000e640008020064ULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff2c00e07947ULL, 0x000fea000383ffffULL,
0x01b6480dff0075a7ULL, 0x0002620008000164ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01b6480dff0085a7ULL, 0x000e640008000064ULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff40008c7947ULL, 0x000fea000383ffffULL,
0x01b66803ff0075a7ULL, 0x0002620008000164ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01b66803ff0085a7ULL, 0x000e640008000064ULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff5000bc7947ULL, 0x000fea000383ffffULL,
0x01b60003ff0075a7ULL, 0x0006e20008000147ULL, 0x0000b0000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01b60003ff0085a7ULL, 0x000e640008000047ULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffffac00107947ULL, 0x006fea000383ffffULL,
0x01b68803ff0075a7ULL, 0x0002620008000155ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01b68803ff0085a7ULL, 0x000e640008000055ULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffffec00207947ULL, 0x000fea000383ffffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0003ULL,
0x00000002ff2f7424ULL, 0x000fe400078e00ffULL, 0x0000001fff307424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fce00078e00ffULL, 0x000000002b087348ULL, 0x000fea0003c00000ULL,
0x0c00002f2e2d7389ULL, 0x0006e40000000030ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ffff2e7224ULL, 0x002fe400078e0004ULL,
0x00000002ff2f7424ULL, 0x000fe400078e00ffULL, 0x0000001fff307424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff027224ULL, 0x004fce00078e002dULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00002f2e2d7389ULL, 0x0002640000000030ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000000203267209ULL, 0x000fe20007810000ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0006ULL, 0x000000ffff057224ULL, 0x000fce00078e002dULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00002f2e2d7389ULL, 0x0002640000000030ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000000504277209ULL, 0x000fe20007810000ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0007ULL, 0x000000ffff297224ULL, 0x000fce00078e002dULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00002f2e2d7389ULL, 0x0002640000000030ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002906297209ULL, 0x000fe20007810000ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0026ULL, 0x00000001ff2f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff287224ULL, 0x000fce00078e002dULL, 0x000000002b087348ULL, 0x000fea0003c00000ULL,
0x0c00002f2e2d7389ULL, 0x0002640000000030ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002807027209ULL, 0x000fe20007810000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0027ULL,
0x000000ffff057224ULL, 0x000fce00078e002dULL, 0x000000002b087348ULL, 0x000fea0003c00000ULL,
0x0c00002f2e2d7389ULL, 0x0002640000000030ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000000526047209ULL, 0x000fe20007810000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0029ULL,
0x000000ffff2a7224ULL, 0x000fce00078e002dULL, 0x000000002b087348ULL, 0x000fea0003c00000ULL,
0x0c00002f2e2d7389ULL, 0x0002640000000030ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002a27057209ULL, 0x000fe20007810000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0002ULL,
0x000000ffff2c7224ULL, 0x000fce00078e002dULL, 0x000000002b087348ULL, 0x000fea0003c00000ULL,
0x0c00002f2e2d7389ULL, 0x0002640000000030ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002c29067209ULL, 0x000fe20007810000ULL, 0x000000ffff037224ULL, 0x000fe200078e002dULL,
0xfffffff000147947ULL, 0x000fec000383ffffULL, 0x0000007000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff027424ULL, 0x000fe400078e00ffULL,
0x000000ffff2b7224ULL, 0x000fce00078e0009ULL, 0x000000002b087348ULL, 0x000fea0003c00000ULL,
0x0000000f1a0f7389ULL, 0x0006e40000000002ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0d7224ULL, 0x004fe400078e000fULL, 0x000000ffff1a7224ULL, 0x002fe400078e000eULL,
0x000000ffff0f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff027424ULL, 0x000fe400078e00ffULL,
0x000000ffff2b7224ULL, 0x000fce00078e0009ULL, 0x000000002b087348ULL, 0x000fea0003c00000ULL,
0x0000000f1a0f7389ULL, 0x0006e40000000002ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x004fe400078e000fULL, 0x000000ffff1a7224ULL, 0x002fe400078e0000ULL,
0x000000ffff0f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff027424ULL, 0x000fe400078e00ffULL,
0x000000ffff2b7224ULL, 0x000fce00078e0009ULL, 0x000000002b087348ULL, 0x000fea0003c00000ULL,
0x0000000f1a0f7389ULL, 0x0006e40000000002ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff400407947ULL, 0x006fea000383ffffULL,
0x0180000059007836ULL, 0x000fe20000000000ULL, 0x0000016000007945ULL, 0x000fe80003800000ULL,
0x7f80000000037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000005900008308ULL, 0x0002a20000001000ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x008000000300780cULL, 0x040fe40003f22070ULL, 0x000000ff0300720cULL, 0x000fe40003f05070ULL,
0xffffffffff007807ULL, 0x004fe40004800000ULL, 0x00000001ff037807ULL, 0x000fc60000000000ULL,
0x000000ffff007224ULL, 0x000fca00078e0a00ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000000000248947ULL, 0x000fea0003800000ULL, 0x007fffff59007812ULL, 0x000fc800078ec0ffULL,
0x000000ff0000720cULL, 0x000fc80003f02070ULL, 0xffffffffff007807ULL, 0x000fca0004000000ULL,
0x000000ffff007224ULL, 0x000fca00078e0a00ULL, 0x0000000003ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000059037812ULL, 0x000fd600078ec0ffULL, 0x0080000003000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0003ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000005900007308ULL, 0x0004e40000001000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffee402b87950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL,
0x0000000e00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000d8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000610ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000658ULL, 0x00000000000004ecULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b44ULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000b68ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000b68ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000b98ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000be0ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000be8ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000c00ULL, 0x0000000000011a00ULL,
0x0000000e00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000012600ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000012610ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000012610ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000012610ULL, 0x0000000000000268ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000012cf8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000012cf8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000be0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000011a00ULL, 0x0000000000011a00ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000012600ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000414ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000012610ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_8_m_8_sm_90_cubin_len = 77384;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
