/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000014b90ULL, 0x0000000000014710ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000013270ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x00000000000133e0ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000013420ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000013460ULL,
0x0000000000000120ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000013580ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001327000000000ULL, 0x0000040400000000ULL, 0x810c0000011c0400ULL,
0x004b740400288080ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0xaa08288080940828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080aa920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001327000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0x9408288080aa0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808094920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000000f000000000ULL, 0x000133e000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0x9408288080aa0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808094920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000017000000000ULL, 0x0001342000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0x9408288080aa0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808094920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000001f000000000ULL, 0x0001346000000000ULL,
0x0000012000000000ULL, 0x0000000000000000ULL, 0x0000001200082f04ULL, 0x0008120400000080ULL,
0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000eULL, 0x000c170400581903ULL,
0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL,
0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00000030001c3104ULL, 0x00011e2000011aa0ULL, 0x00011ea000011e30ULL, 0x00011ec000011eb0ULL,
0xffffffff01702904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x05000029ffffffffULL, 0x0500002905000029ULL,
0xffffffff05000029ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01702804ffffffffULL, 0x00000120000000f0ULL,
0x00002890000016a0ULL, 0x000029e000002920ULL, 0x00002d0000002a10ULL, 0x00002d7000002d10ULL,
0x0000343000002dd0ULL, 0x0000451000004480ULL, 0x00004700000045e0ULL, 0x00004900000048f0ULL,
0x000049c000004960ULL, 0x00005ed000004dc0ULL, 0x0000603000005f60ULL, 0x0000634000006150ULL,
0x000063b000006350ULL, 0x0000681000006410ULL, 0x000078c000007830ULL, 0x00007ab000007990ULL,
0x00007cb000007ca0ULL, 0x00007d7000007d10ULL, 0x000081f0000081e0ULL, 0x0000aa700000a950ULL,
0x0000b1a00000b170ULL, 0x000117a000011770ULL, 0x000117c0000117b0ULL, 0x00011810000117f0ULL,
0x0001183000011820ULL, 0x00011ef000011e90ULL, 0x00011f1000011f00ULL, 0x0001267000012620ULL,
0x00012750000126e0ULL, 0x00012820000127b0ULL, 0x000128c000012870ULL, 0x0001298000012920ULL,
0x00012a30000129d0ULL, 0x00012ad000012a80ULL, 0x00012b9000012b30ULL, 0x00012c4000012be0ULL,
0x00012ce000012c90ULL, 0x00012da000012d40ULL, 0x00012e5000012df0ULL, 0x00012f0000012ea0ULL,
0x00012fa000012f50ULL, 0x0001304000012ff0ULL, 0x000130e000013090ULL, 0x000131b000013140ULL,
0x0001325000013200ULL, 0x000001f002003904ULL, 0x00013600000000ffULL, 0x00000270003f0100ULL,
0x000136080000000bULL, 0x00000330003f0120ULL, 0x000136880000000bULL, 0x00000400003f0120ULL,
0x00013600000000ffULL, 0x000005d0003f0107ULL, 0x0001368c00000054ULL, 0x00000680003f0102ULL,
0x0001368800000054ULL, 0x000026d0003f0101ULL, 0x000136080000000aULL, 0x000026e0003f0101ULL,
0x0001360c0000000aULL, 0x00002780003f0105ULL, 0x0001360c0000000eULL, 0x000033e0003f0105ULL,
0x0001368800000077ULL, 0x00004330003f0101ULL, 0x000136280000000aULL, 0x00004340003f0101ULL,
0x0001362c0000000aULL, 0x000043d0003f0105ULL, 0x0001362c0000000aULL, 0x00004d70003f0105ULL,
0x0001369000000077ULL, 0x00005d40003f0101ULL, 0x000136480000000aULL, 0x00005d50003f0101ULL,
0x0001364c0000000aULL, 0x00005e20003f0105ULL, 0x0001364c00000015ULL, 0x000067b0003f0105ULL,
0x0001369800000077ULL, 0x000076e0003f0101ULL, 0x000136680000000aULL, 0x000076f0003f0101ULL,
0x0001366c0000000aULL, 0x00007780003f0105ULL, 0x0001366c0000000aULL, 0x00008030003f0105ULL,
0x000136a000000077ULL, 0x0000bf20003f0101ULL, 0x00013600000000ffULL, 0x0000ccd0003f0101ULL,
0x00013604000000ffULL, 0x0000cd70003f0105ULL, 0x00013604000000ffULL, 0x00010dd0003f0105ULL,
0x0000000000000056ULL, 0x00010e10003f0101ULL, 0x0000000400000056ULL, 0x00011070003f0105ULL,
0x0000000400000056ULL, 0x00012480003f0105ULL, 0x0001360800000006ULL, 0x000124e0003f0101ULL,
0x0001361000000006ULL, 0x00012540003f0101ULL, 0x0001361800000006ULL, 0x000125b0003f0101ULL,
0x0001362000000006ULL, 0x00033803003f0101ULL, 0x0000bba000141c04ULL, 0x0000cdd00000bdf0ULL,
0x000125f00000ce60ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL,
0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x000000000000025cULL,
0x0000001200000002ULL, 0x00000000000001dcULL, 0x0000001200000002ULL, 0x000000000000015cULL,
0x0000001200000002ULL, 0x00000000000000dcULL, 0x0000001200000002ULL, 0x0000000000000044ULL,
0x0000001200000002ULL, 0x0000000000000232ULL, 0x0000001200000002ULL, 0x00000000000001b2ULL,
0x0000001200000002ULL, 0x0000000000000132ULL, 0x0000001200000002ULL, 0x00000000000000b2ULL,
0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x00005800ff127624ULL, 0x000fe200078e00ffULL, 0x0000000000147806ULL, 0x000fe200038e0000ULL,
0x00000100ff097424ULL, 0x000fe200078e00ffULL, 0x00000000000d7919ULL, 0x000ea20000002300ULL,
0x0000000812057824ULL, 0x000fe200078e00ffULL, 0x0000001400067300ULL, 0x000fe200000e0000ULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000007919ULL, 0x000ea80000002200ULL,
0x00000000000e7919ULL, 0x000ee40000002600ULL, 0x0000001400147309ULL, 0x000f240000000000ULL,
0x0000000000637919ULL, 0x000f680000002700ULL, 0x0000000000077919ULL, 0x000f620000000000ULL,
0x00000005ff627819ULL, 0x002fcc000001160bULL, 0x00001fff62627589ULL, 0x000fe200000e0000ULL,
0x000000ffff147224ULL, 0x010fe400078e0a14ULL, 0x000000010d007824ULL, 0x004fe400078e0200ULL,
0x00001fff0d0d7589ULL, 0x000e6200000e0000ULL, 0x000000080e047824ULL, 0x008fe400078e00ffULL,
0x00000080000b7824ULL, 0x000fe400078e020bULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000006305047224ULL, 0x020fc400078e0204ULL, 0x000000ff0b00720cULL, 0x040fe40003f05270ULL,
0x0000000f0b00780cULL, 0x040fe40003f24070ULL, 0x0000007f0b00780cULL, 0x000fe40003f44070ULL,
0x000000070600720cULL, 0x000fce0003f82070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x000000040d057824ULL, 0x002fe400078e0262ULL,
0x3fffffc0ff069424ULL, 0x000fe200078e00ffULL, 0x01360002ff008388ULL, 0x0003e20000000a00ULL,
0x00000004ff0a7819ULL, 0x004fe20000011600ULL, 0x0000000205057824ULL, 0x000fe200078e00ffULL,
0x000000030b00780cULL, 0x000fe20003f04070ULL, 0x7fffffc0ff079424ULL, 0x000fc400078e00ffULL,
0x00000001050f7824ULL, 0x040fe200078e020aULL, 0x0000000805087817ULL, 0x000fe20007800000ULL,
0xff317217ff10a424ULL, 0x000fe200078e00ffULL, 0x013608060b009388ULL, 0x0005e20000008a00ULL,
0x0000000104027824ULL, 0x002fe200078e020fULL, 0x000000070f117812ULL, 0x000fe200078ec0ffULL,
0x0000000108057824ULL, 0x000fe200078e0a05ULL, 0x013400100b00a388ULL, 0x0003e20000004800ULL,
0x00005c0002027625ULL, 0x000fc600078e0009ULL, 0x000000050a00720cULL, 0x000fe20003f26070ULL,
0x3fffff60ff088424ULL, 0x000fe200078e00ffULL, 0x0000000f110a7812ULL, 0x000fe200078e7800ULL,
0x7fffff60ff098424ULL, 0x000fe400078e00ffULL, 0x00000010000c7824ULL, 0x000fe400078e00ffULL,
0x000000100f0a7824ULL, 0x000fe200078e020aULL, 0x013688080b008388ULL, 0x0003e20000008a00ULL,
0x00000004ff067424ULL, 0x004fe200078e00ffULL, 0x000000f00c137812ULL, 0x000fe200078ec0ffULL,
0x000000100a077824ULL, 0x000fc400078e00ffULL, 0x000000ffff0a7224ULL, 0x000fe200078e0014ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000001302047210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff057224ULL, 0x000fe400018e0603ULL, 0x0000620063027625ULL, 0x000fc600078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000c901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0136040affff438cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01360000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000602607981ULL, 0x000ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x00000004ff647e24ULL, 0x008fe2000f8e00ffULL,
0x0000007f60617810ULL, 0x004fc40007ffe0ffULL, 0x000000ff60577810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff617819ULL, 0x000fe40000011661ULL, 0x00000008ff577819ULL, 0x000fca0000011657ULL,
0x0000b8f000008947ULL, 0x000fea0003800000ULL, 0x00000003ff027819ULL, 0x000fe20000011662ULL,
0x0000000862547824ULL, 0x000fe400078e00ffULL, 0x00000003ff097424ULL, 0x002fe200078e00ffULL,
0x01ffffff02037812ULL, 0x000fca00078ec0ffULL, 0x0000000264027824ULL, 0x000fca00078e0203ULL,
0x000000610200720cULL, 0x000fda0003f06070ULL, 0x0000000263038824ULL, 0x000fe400078e00ffULL,
0x00006400ff048624ULL, 0x000fc800078e00ffULL, 0x0000640003058624ULL, 0x000fe400078e0204ULL,
0xffffffffff037424ULL, 0x000fe400078e00ffULL, 0x0000000102058824ULL, 0x000fe200078e0205ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01368c0954ff738cULL, 0x0003e20000000000ULL,
0x0000600005068625ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000606038981ULL, 0x000ea2000c1e1900ULL, 0x0000000164087810ULL, 0x000fe20007ffe0ffULL,
0x000000800e057824ULL, 0x000fe200078e00ffULL, 0x00000001ff557819ULL, 0x000fe20000011662ULL,
0x0136880054ff7f8cULL, 0x0007e2000c80043fULL, 0x000000570800720cULL, 0x000fc40003f06070ULL,
0x0000000162567812ULL, 0x000fe200078ec0ffULL, 0x0000002055047824ULL, 0x000fc800078e00ffULL,
0x00000100640d7824ULL, 0x000fca00078e0204ULL, 0x0000006005147812ULL, 0x000fe200078ef80dULL,
0x0000580003087a24ULL, 0x004fc800078e02ffULL, 0x00000080081c7824ULL, 0x000fe200078e00ffULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x00000003ff117819ULL, 0x008fe20000011600ULL,
0x0000000856197824ULL, 0x000fe200078e00ffULL, 0x0000000d60067217ULL, 0x000fe40007800000ULL,
0x0000000411097810ULL, 0x042fe40007ffe0ffULL, 0x00000008110b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000106067824ULL, 0x000fe200078e0a0dULL, 0x0000000009077212ULL, 0x0c0fe200078e3cffULL,
0x00000008090a7824ULL, 0x000fe200078e00ffULL, 0x000000000b087212ULL, 0x040fe200078e3cffULL,
0x000000080b1d7824ULL, 0x000fe200078e00ffULL, 0x0000002006167817ULL, 0x000fc40003800000ULL,
0xfffffff80a1b7812ULL, 0x000fe200078ee207ULL, 0x0000000114077824ULL, 0x040fe200078e0211ULL,
0x0000000c11157810ULL, 0x000fe40007ffe0ffULL, 0x000000160900720cULL, 0x080fe20003f06070ULL,
0x0000000114097824ULL, 0x000fe200078e0209ULL, 0x000000071c077210ULL, 0x000fe20007f5e0ffULL,
0x0000000114067824ULL, 0x040fe200078e0215ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee208ULL,
0x00000008151f7824ULL, 0x000fe200078e00ffULL, 0x000000160b00720cULL, 0x000fe20003f26070ULL,
0x000000ffff0a7224ULL, 0x000fe200010e06ffULL, 0x00005e0007087a11ULL, 0x000fe200078440ffULL,
0x00000001140b7824ULL, 0x000fe200078e020bULL, 0x000000091c0f7210ULL, 0x000fc40007f7e0ffULL,
0x00005f0007097a11ULL, 0x000fe400010f440aULL, 0x0000000b1c0d7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff127224ULL, 0x000fe200018e06ffULL, 0x000000061c077210ULL, 0x000fe40007fbe0ffULL,
0x0000001011217810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x00005e0007067a11ULL, 0x000fe200078840ffULL, 0x000000ffff0e7224ULL, 0x000fe200028e06ffULL,
0x00005e000f0a7a11ULL, 0x000fc400078440ffULL, 0x0000001411237810ULL, 0x000fe40007ffe0ffULL,
0x00005f0007077a11ULL, 0x000fe200020f440eULL, 0x00000001140e7824ULL, 0x040fe200078e0221ULL,
0x00005f000f0b7a11ULL, 0x000fe200010f4412ULL, 0x00000001140f7824ULL, 0x000fe200078e0223ULL,
0x00005e000d0c7a11ULL, 0x000fe400078640ffULL, 0x0000001811257810ULL, 0x040fe40007ffe0ffULL,
0x0000001c11277810ULL, 0x000fc40007ffe0ffULL, 0x0000000e1c137210ULL, 0x000fe40007f5e0ffULL,
0x00005f000d0d7a11ULL, 0x000fe200018f4410ULL, 0x0000000114107824ULL, 0x040fe200078e0225ULL,
0x00005e00130e7a11ULL, 0x040fe200078840ffULL, 0x0000000114127824ULL, 0x000fe200078e0227ULL,
0x0000000f1c147210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0x000000101c1e7210ULL, 0x040fe40007f7e0ffULL, 0x000000121c1c7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200028e06ffULL, 0x00005f00130f7a11ULL, 0x000fe200020f4418ULL,
0x0000000255187824ULL, 0x000fe200078e0256ULL, 0x00005e0014107a11ULL, 0x000fe200078a40ffULL,
0x000000ffff297224ULL, 0x000fe200010e06ffULL, 0x0000000711137812ULL, 0x000fc400078e4800ULL,
0x000000161100720cULL, 0x000fe40003f86070ULL, 0x00005f0014117a11ULL, 0x000fe400028f4417ULL,
0x0000b00018187811ULL, 0x000fe400078e68ffULL, 0x0ffffff813137812ULL, 0x100fe400078ef800ULL,
0xfffffff819177812ULL, 0x000fe200078ee200ULL, 0x000000101b1b7824ULL, 0x100fe200078e0218ULL,
0x00005e001c147a11ULL, 0x000fe200078a40ffULL, 0x0000001013197824ULL, 0x000fe200078e0218ULL,
0x00000000151a7212ULL, 0x000fe200078e3cffULL, 0x000000ffff137224ULL, 0x000fe200018e06ffULL,
0x00005e001e127a11ULL, 0x000fe200078640ffULL, 0x0000001017087825ULL, 0x000fe200078e0008ULL,
0x000000161500720cULL, 0x000fc40003f46070ULL, 0x00005f001e137a11ULL, 0x000fe200018f4413ULL,
0x000000101d1d7824ULL, 0x000fe200078e0218ULL, 0x00005f001c157a11ULL, 0x000fe200028f4429ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008197faeULL, 0x0003e2000e101c46ULL,
0x000000162100720cULL, 0x080fe20003f66070ULL, 0x0000001017067825ULL, 0x000fe200078e0006ULL,
0x000000162300720cULL, 0x080fe40003f86070ULL, 0x000000162500720cULL, 0x080fe40003fa6070ULL,
0x000000162700720cULL, 0x000fc40003fc6070ULL, 0x0000000021167212ULL, 0x0c0fe200078e3cffULL,
0x0000000821217824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe400078ee21aULL,
0x00000000231a7212ULL, 0x0c0fe200078e3cffULL, 0x0000000823237824ULL, 0x000fe200078e00ffULL,
0x00000000251c7212ULL, 0x0c0fe200078e3cffULL, 0x0000000825257824ULL, 0x000fe200078e00ffULL,
0x0000000027087212ULL, 0x042fe200078e3cffULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0xfffffff821097812ULL, 0x000fe200078ee216ULL, 0x000000101f1f7824ULL, 0x000fe200078e0218ULL,
0xfffffff823217812ULL, 0x000fc400078ee21aULL, 0xfffffff825237812ULL, 0x000fe200078ee21cULL,
0x0000001009197824ULL, 0x000fe200078e0218ULL, 0xfffffff827257812ULL, 0x000fe200078ee208ULL,
0x0000001017087825ULL, 0x000fc800078e000aULL, 0x00000010170a7825ULL, 0x040fe200078e000cULL,
0x00000000081b7faeULL, 0x0003e6000c101c46ULL, 0x00000010170c7825ULL, 0x000fe200078e000eULL,
0x000000000a1d7faeULL, 0x0003e6000c901c46ULL, 0x0000001021217824ULL, 0x000fe200078e0218ULL,
0x00000000061f7faeULL, 0x0003e2000d101c46ULL, 0x00000010170e7825ULL, 0x000fc600078e0010ULL,
0x000000000c197faeULL, 0x0003e2000d901c46ULL, 0x0000001023237824ULL, 0x000fe400078e0218ULL,
0x0000001017107825ULL, 0x000fe200078e0012ULL, 0x000000000e217faeULL, 0x0003e6000e101c46ULL,
0x0000001025257824ULL, 0x000fe200078e0218ULL, 0x0000000010237faeULL, 0x0003e2000e901c46ULL,
0x0000001017127825ULL, 0x000fca00078e0014ULL, 0x0000000012257faeULL, 0x0003e2000f101c46ULL,
0x0000066000007947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x00afc80000011600ULL,
0x00000004090b7810ULL, 0x040fe40007ffe0ffULL, 0x00000008090d7810ULL, 0x000fe40007ffe0ffULL,
0x000000000b067212ULL, 0x0c0fe200078e3cffULL, 0x000000080b077824ULL, 0x000fe200078e00ffULL,
0x000000000d087212ULL, 0x040fe200078e3cffULL, 0x000000080d0f7824ULL, 0x000fe200078e00ffULL,
0x0000001009137810ULL, 0x000fe20007ffe0ffULL, 0x00000001140b7824ULL, 0x040fe200078e020bULL,
0xfffffff8070e7812ULL, 0x000fe200078ee206ULL, 0x0000000114077824ULL, 0x040fe200078e0209ULL,
0xfffffff80f107812ULL, 0x000fe200078ee208ULL, 0x0000000813197824ULL, 0x000fe200078e00ffULL,
0x0000000c090f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001140d7824ULL, 0x000fe200078e020dULL,
0x000000071c077210ULL, 0x000fc40007f1e0ffULL, 0x000000000f0a7212ULL, 0x0c0fe200078e3cffULL,
0x000000080f177824ULL, 0x000fe200078e00ffULL, 0x0000001409157810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00000000130c7212ULL, 0x000fe200078e3cffULL,
0x0000000114137824ULL, 0x000fe200078e0213ULL, 0xfffffff817127812ULL, 0x000fe200078ee20aULL,
0x0000000815187824ULL, 0x000fe200078e00ffULL, 0x00005e0007067a11ULL, 0x000fe200078040ffULL,
0x00000002550a7824ULL, 0x000fe200078e0256ULL, 0x0000001809177810ULL, 0x000fc40007ffe0ffULL,
0x0000000015117212ULL, 0x080fe200078e3cffULL, 0x0000000114157824ULL, 0x040fe200078e0215ULL,
0xfffffff819167812ULL, 0x000fe200078ee20cULL, 0x0000000114197824ULL, 0x000fe200078e0217ULL,
0x00005f0007077a11ULL, 0x000fe400000f4408ULL, 0x0000001c091b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000017087212ULL, 0x040fe200078e3cffULL, 0x0000000817177824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee211ULL, 0x0000000114117824ULL, 0x000fe200078e020fULL,
0x0000000b1c0c7210ULL, 0x000fe20007fde0ffULL, 0x00000001141d7824ULL, 0x000fe200078e021bULL,
0x0000000709097812ULL, 0x000fe200078e4800ULL, 0x000000081b1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff817147812ULL, 0x000fc400078ee208ULL, 0x0000b0000a0b7811ULL, 0x000fe400078e68ffULL,
0x0000000d1c0f7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0x000000001b177212ULL, 0x000fe200078e3cffULL, 0x000000100e1b7824ULL, 0x100fe200078e020bULL,
0x0ffffff8090a7812ULL, 0x000fe200078ef800ULL, 0x000000ffff0e7224ULL, 0x000fe200028e06ffULL,
0x000000111c117210ULL, 0x000fe20007f9e0ffULL, 0x00000010121f7824ULL, 0x100fe200078e020bULL,
0x00005e000c087a11ULL, 0x000fe200078c40ffULL, 0x0000001016217824ULL, 0x100fe200078e020bULL,
0x000000131c137210ULL, 0x000fe20007f7e0ffULL, 0x0000001018237824ULL, 0x100fe200078e020bULL,
0x000000151c157210ULL, 0x000fe20007f1e0ffULL, 0x0000001014277824ULL, 0x100fe200078e020bULL,
0x000000191c1a7210ULL, 0x000fe20007f3e0ffULL, 0x000000100a197824ULL, 0x100fe200078e020bULL,
0x0000001d1c1c7210ULL, 0x000fe20007f5e0ffULL, 0x00000010101d7824ULL, 0x000fe200078e020bULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee217ULL, 0x0000000856177824ULL, 0x000fe200078e00ffULL,
0x00005f000c097a11ULL, 0x000fe200030f440dULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x00005e000f0a7a11ULL, 0x000fe200078a40ffULL, 0x000000101e2b7824ULL, 0x000fe200078e020bULL,
0x00005e00110c7a11ULL, 0x000fe200078840ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x00005f000f0b7a11ULL, 0x000fe200028f440eULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x00005f00110d7a11ULL, 0x000fe200020f4410ULL, 0x000000ffff257224ULL, 0x000fe200008e06ffULL,
0xfffffff817177812ULL, 0x000fe200078ee200ULL, 0x000000ffff297224ULL, 0x000fe200010e06ffULL,
0x00005e00130e7a11ULL, 0x000fc400078640ffULL, 0x00005e0015107a11ULL, 0x000fe200078040ffULL,
0x0000001017067825ULL, 0x040fe200078e0006ULL, 0x00005e001a127a11ULL, 0x000fe400078240ffULL,
0x00005e001c147a11ULL, 0x000fe200078440ffULL, 0x0000001017087825ULL, 0x000fe200078e0008ULL,
0x00005f00130f7a11ULL, 0x000fe200018f4416ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006197faeULL, 0x0003e2000b901c46ULL, 0x00005f0015117a11ULL, 0x000fe200000f4418ULL,
0x00000010170a7825ULL, 0x040fe200078e000aULL, 0x00005f001a137a11ULL, 0x000fe200008f4425ULL,
0x00000000081b7faeULL, 0x0003e2000b901c46ULL, 0x00005f001c157a11ULL, 0x000fe200010f4429ULL,
0x00000010170c7825ULL, 0x000fc400078e000cULL, 0x000000000a1d7faeULL, 0x0003e4000b901c46ULL,
0x00000010170e7825ULL, 0x040fe400078e000eULL, 0x000000000c1f7faeULL, 0x0003e4000b901c46ULL,
0x0000001017107825ULL, 0x040fe400078e0010ULL, 0x000000000e217faeULL, 0x0003e4000b901c46ULL,
0x0000001017127825ULL, 0x000fc400078e0012ULL, 0x0000000010237faeULL, 0x0003e4000b901c46ULL,
0x0000001017147825ULL, 0x000fe400078e0014ULL, 0x0000000012277faeULL, 0x0003e8000b901c46ULL,
0x00000000142b7faeULL, 0x0003e4000b901c46ULL, 0x000000576400720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff067424ULL, 0x002fe200078e00ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00006ab000000947ULL, 0x000fea0003800000ULL,
0x0000000263097824ULL, 0x000fe400078e00ffULL, 0x00006400ff087624ULL, 0x000fc400078e00ffULL,
0xff317217ff067424ULL, 0x000fe400078e00ffULL, 0x000000ffff7b7224ULL, 0x000fe400078e00ffULL,
0x0000640009097624ULL, 0x000fe400078e0208ULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x00000100640b7824ULL, 0x000fca00078e00ffULL, 0x000000600b00720cULL, 0x000fda0003f06070ULL,
0x000069e000000947ULL, 0x020fea0003800000ULL, 0x0000001062087824ULL, 0x000fe200078e00ffULL,
0x00000001640a7810ULL, 0x000fe20007ffe0ffULL, 0x0000580003037a24ULL, 0x000fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000570a00720cULL, 0x000fe20003f06070ULL,
0x000000ffff797224ULL, 0x000fe200078e0002ULL, 0xffffffe0080b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fe400078e007bULL, 0x0000008003257824ULL, 0x000fe400078e00ffULL,
0x00000100640b7824ULL, 0x000fca00078e020bULL, 0x000000400b0a7810ULL, 0x000fc80007ffe0ffULL,
0x00000060051d7812ULL, 0x000fe200078ef80aULL, 0x0000077000008947ULL, 0x000fea0003800000ULL,
0x0000000a60037217ULL, 0x000fe20007800000ULL, 0x00002000620b7824ULL, 0x000fe200078e00ffULL,
0x00000003ff207819ULL, 0x000fe20000011600ULL, 0x0000000856217824ULL, 0x000fe400078e00ffULL,
0x0000000103037824ULL, 0x000fe200078e0a0aULL, 0x0000000420127810ULL, 0x000fe20007ffe0ffULL,
0x000010007b0d7824ULL, 0x000fe200078e00ffULL, 0x00000007000a7812ULL, 0x000fe400078ec0ffULL,
0x000020000b0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000812107824ULL, 0x000fe200078e00ffULL,
0x0000000821217812ULL, 0x000fe200078ee20aULL, 0x00000001200a7824ULL, 0x000fe200078e021dULL,
0x00000000120b7212ULL, 0x000fe200078e3cffULL, 0x00004000550c7824ULL, 0x000fe200078e020cULL,
0x000010000d0d7812ULL, 0x000fc400078e0cffULL, 0xfffffff810297812ULL, 0x000fe400078ee20bULL,
0x0000000a250b7210ULL, 0x000fe20007f1e0ffULL, 0x00000001120a7824ULL, 0x000fe200078e021dULL,
0x0000b0000c0e7810ULL, 0x000fe40007ffe00dULL, 0x0000000820147810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x0000002003037817ULL, 0x000fe40003800000ULL,
0x00005e000b107a11ULL, 0x000fe200078040ffULL, 0x0000000814167824ULL, 0x000fe200078e00ffULL,
0x000000031200720cULL, 0x000fc40003f46070ULL, 0x00005f000b117a11ULL, 0x000fe200000f440cULL,
0x00000001140b7824ULL, 0x040fe200078e021dULL, 0x0000000a25127210ULL, 0x000fe40007f1e0ffULL,
0x00000000140d7212ULL, 0x000fe200078e3cffULL, 0x0000001021107825ULL, 0x000fe200078e0010ULL,
0x0000000c20247810ULL, 0x040fe40007ffe0ffULL, 0x0000001020267810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200000e06ffULL, 0xfffffff8162b7812ULL, 0x000fe200078ee20dULL,
0x00000001240c7824ULL, 0x100fe200078e021dULL, 0x00005e00120a7a11ULL, 0x000fe200078040ffULL,
0x00000001260d7824ULL, 0x000fe200078e021dULL, 0x0000000b25157210ULL, 0x000fe20007f7e0ffULL,
0x00000008242e7824ULL, 0x000fe200078e00ffULL, 0x00005f00120b7a11ULL, 0x000fc400000f4413ULL,
0x0000000c25137210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x0000000d250d7210ULL, 0x000fe20007fbe0ffULL, 0x00000010210a7825ULL, 0x000fe200078e000aULL,
0x0000001420287810ULL, 0x000fe40007ffe0ffULL, 0x000000031400720cULL, 0x000fe20003f26070ULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x00005e000d0c7a11ULL, 0x000fe200078840ffULL,
0x000000ffff167224ULL, 0x000fe200028e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078040ffULL,
0x00000008282d7824ULL, 0x000fe200078e00ffULL, 0x00005e0013127a11ULL, 0x000fc400078640ffULL,
0x00005f000d0d7a11ULL, 0x000fe200020f4416ULL, 0x0000000128167824ULL, 0x000fe200078e021dULL,
0x00000018202a7810ULL, 0x040fe40007ffe0ffULL, 0x0000001c202c7810ULL, 0x000fe20007ffe0ffULL,
0x00000010210c7825ULL, 0x000fe200078e000cULL, 0x00005f0015157a11ULL, 0x000fe400000f441eULL,
0x00005f0013137a11ULL, 0x000fe200018f441cULL, 0x000000012a177824ULL, 0x100fe200078e021dULL,
0x00000016251e7210ULL, 0x040fe20007f1e0ffULL, 0x000000012c1c7824ULL, 0x000fe200078e021dULL,
0x0000000720277812ULL, 0x000fe200078e4800ULL, 0x000000082a2f7824ULL, 0x000fe200078e00ffULL,
0x000000032000720cULL, 0x000fe20003f66070ULL, 0x000000ffff237224ULL, 0x000fe200000e06ffULL,
0x00005e001e167a11ULL, 0x000fe200078040ffULL, 0x000000082c317824ULL, 0x000fe200078e00ffULL,
0x00000017251f7210ULL, 0x000fe20007f9e0ffULL, 0x0000001021147825ULL, 0x000fe200078e0014ULL,
0x0000001c251d7210ULL, 0x000fc40007fbe0ffULL, 0x0ffffff827277812ULL, 0x000fe200078ef800ULL,
0x000000ffff227224ULL, 0x000fe200020e06ffULL, 0x00005f001e177a11ULL, 0x000fe200000f4423ULL,
0x000000ffff207224ULL, 0x000fe200028e06ffULL, 0x00005e001f1e7a11ULL, 0x000fe200078840ffULL,
0x0000001027237824ULL, 0x000fe200078e020eULL, 0x00005e001d1c7a11ULL, 0x000fe200078a40ffULL,
0x0000001021127825ULL, 0x000fe200078e0012ULL, 0x00005f001f1f7a11ULL, 0x000fe400020f4422ULL,
0x00005f001d1d7a11ULL, 0x000fe200028f4420ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010237faeULL, 0x0003e2000d901c46ULL, 0x000000032400720cULL, 0x080fe20003f06070ULL,
0x0000001021167825ULL, 0x000fe200078e0016ULL, 0x000000032600720cULL, 0x000fc40003f66070ULL,
0x000000032800720cULL, 0x080fe20003f86070ULL, 0x00000010211e7825ULL, 0x040fe200078e001eULL,
0x000000032a00720cULL, 0x080fe40003fa6070ULL, 0x000000032c00720cULL, 0x000fe20003fc6070ULL,
0x00000010211c7825ULL, 0x000fe200078e001cULL, 0x0000000026037212ULL, 0x080fe400078e3cffULL,
0x0000000024257212ULL, 0x080fe200078e3cffULL, 0x0000000826267824ULL, 0x000fe200078e00ffULL,
0x0000000028207212ULL, 0x080fe200078e3cffULL, 0x000000102b117824ULL, 0x002fe200078e020eULL,
0x000000002a227212ULL, 0x000fc400078e3cffULL, 0xfffffff82e257812ULL, 0x000fe400078ee225ULL,
0x000000002c107212ULL, 0x000fe400078e3cffULL, 0xfffffff826277812ULL, 0x000fe200078ee203ULL,
0x0000001029037824ULL, 0x000fe200078e020eULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee220ULL,
0x0000001025237824ULL, 0x000fe200078e020eULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee222ULL,
0x0000001027257824ULL, 0x000fe200078e020eULL, 0xfffffff831317812ULL, 0x000fe200078ee210ULL,
0x000000102d277824ULL, 0x100fe200078e020eULL, 0x000000000a037faeULL, 0x0003e2000d101c46ULL,
0x000000102f297824ULL, 0x000fc400078e020eULL, 0x00000010312b7824ULL, 0x000fe200078e020eULL,
0x0000000014117faeULL, 0x0003e8000c901c46ULL, 0x0000000012237faeULL, 0x0003e8000c101c46ULL,
0x000000000c257faeULL, 0x0003e8000d901c46ULL, 0x0000000016277faeULL, 0x0003e8000e101c46ULL,
0x000000001e297faeULL, 0x0003e8000e901c46ULL, 0x000000001c2b7faeULL, 0x0003e2000f101c46ULL,
0x000006b000007947ULL, 0x000fea0003800000ULL, 0x00000003ff037819ULL, 0x000fe20000011600ULL,
0x00002000620b7824ULL, 0x000fe200078e00ffULL, 0x00000007000a7812ULL, 0x000fe200078ec0ffULL,
0x0000000856217824ULL, 0x000fe200078e00ffULL, 0x0000000403107810ULL, 0x000fe20007ffe0ffULL,
0x000010007b0d7824ULL, 0x000fe200078e00ffULL, 0x000020000b0c7812ULL, 0x000fc400078ec0ffULL,
0x0000000821217812ULL, 0x000fe200078ee20aULL, 0x0000000810147824ULL, 0x040fe200078e00ffULL,
0x00000000100b7212ULL, 0x040fe200078e3cffULL, 0x00000001030a7824ULL, 0x140fe200078e021dULL,
0x0000000803127810ULL, 0x000fe20007ffe0ffULL, 0x00004000550c7824ULL, 0x000fe200078e020cULL,
0x00000014031c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000110107824ULL, 0x000fe200078e021dULL,
0x000010000d0d7812ULL, 0x000fe200078e0cffULL, 0x0000000812167824ULL, 0x000fe200078e00ffULL,
0xfffffff814117812ULL, 0x000fe200078ee20bULL, 0x000000081c2b7824ULL, 0x000fe200078e00ffULL,
0x0000000a250b7210ULL, 0x000fc40007f1e0ffULL, 0x0000b0000c0e7810ULL, 0x000fe40007ffe00dULL,
0x0000000012137212ULL, 0x0c0fe200078e3cffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x0000000c030d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000112127824ULL, 0x000fe200078e021dULL,
0x0000001003147810ULL, 0x000fe40007ffe0ffULL, 0x000000001c1e7212ULL, 0x000fe200078e3cffULL,
0x000000080d207824ULL, 0x000fe200078e00ffULL, 0x00005e000b0a7a11ULL, 0x000fe200078040ffULL,
0x00000008141f7824ULL, 0x000fe200078e00ffULL, 0xfffffff816157812ULL, 0x000fe200078ee213ULL,
0x000000011c1c7824ULL, 0x000fe200078e021dULL, 0xfffffff82b2b7812ULL, 0x000fc400078ee21eULL,
0x0000000014167212ULL, 0x0c0fe200078e3cffULL, 0x0000000114147824ULL, 0x100fe200078e021dULL,
0x00000018031e7810ULL, 0x000fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e020eULL,
0x0000001c03237810ULL, 0x000fe40007ffe0ffULL, 0x000000000d137212ULL, 0x000fe200078e3cffULL,
0x000000011e227824ULL, 0x100fe200078e021dULL, 0x00005f000b0b7a11ULL, 0x000fe200000f440cULL,
0x000000010d0c7824ULL, 0x100fe200078e021dULL, 0x0000001025107210ULL, 0x000fe20007fde0ffULL,
0x0000000123247824ULL, 0x000fe200078e021dULL, 0xfffffff820177812ULL, 0x000fe200078ee213ULL,
0x000000081e2d7824ULL, 0x040fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee216ULL,
0x00000008232f7824ULL, 0x000fe200078e00ffULL, 0x0000001225137210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e06ffULL, 0x00000014251d7210ULL, 0x000fe20007f7e0ffULL,
0x0000001017277824ULL, 0x100fe200078e020eULL, 0x0000000c25167210ULL, 0x000fe20007f9e0ffULL,
0x000000101f297824ULL, 0x000fe200078e020eULL, 0x0000000703037812ULL, 0x000fe200078e4800ULL,
0x00000010210a7825ULL, 0x000fe200078e000aULL, 0x000000001e127212ULL, 0x000fc400078e3cffULL,
0x0000000023147212ULL, 0x000fe200078e3cffULL, 0x0000001011237824ULL, 0x100fe200078e020eULL,
0x00005e00100c7a11ULL, 0x040fe400078c40ffULL, 0x0000001c25207210ULL, 0x040fe40007f1e0ffULL,
0x0000002225227210ULL, 0x040fe40007f3e0ffULL, 0x0000002425247210ULL, 0x000fe20007f5e0ffULL,
0x0000001015257824ULL, 0x000fe200078e020eULL, 0x0ffffff803037812ULL, 0x000fe200078ef800ULL,
0x000000ffff157224ULL, 0x000fe200020e06ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee212ULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee214ULL,
0x000000ffff147224ULL, 0x000fe200028e06ffULL, 0x00005f00100d7a11ULL, 0x000fe200030f440dULL,
0x0000001003037824ULL, 0x100fe200078e020eULL, 0x00005e0013107a11ULL, 0x000fe200078a40ffULL,
0x000000102d2d7824ULL, 0x100fe200078e020eULL, 0x00005e0016127a11ULL, 0x040fe200078840ffULL,
0x000000102f317824ULL, 0x000fe200078e020eULL, 0x00005f0013117a11ULL, 0x000fe200028f4414ULL,
0x000000ffff0e7224ULL, 0x000fe200018e06ffULL, 0x00005f0016137a11ULL, 0x000fe200020f4415ULL,
0x000000ffff1f7224ULL, 0x000fe200008e06ffULL, 0x00005e001d147a11ULL, 0x000fe200078640ffULL,
0x000000ffff2f7224ULL, 0x000fe200010e06ffULL, 0x00005e0020167a11ULL, 0x000fe200078040ffULL,
0x00000010210c7825ULL, 0x040fe200078e000cULL, 0x00005e00221c7a11ULL, 0x000fe200078240ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a037faeULL, 0x0003e2000b901c46ULL,
0x00005e00241e7a11ULL, 0x000fe200078440ffULL, 0x0000001021107825ULL, 0x000fe200078e0010ULL,
0x00005f001d157a11ULL, 0x000fe200018f440eULL, 0x000000000c237faeULL, 0x0003e2000b901c46ULL,
0x00005f0020177a11ULL, 0x000fe200000f4417ULL, 0x0000001021127825ULL, 0x040fe200078e0012ULL,
0x00005f00221d7a11ULL, 0x000fe200008f441fULL, 0x0000000010257faeULL, 0x0003e2000b901c46ULL,
0x00005f00241f7a11ULL, 0x000fe200010f442fULL, 0x0000001021147825ULL, 0x000fc400078e0014ULL,
0x0000000012277faeULL, 0x0003e4000b901c46ULL, 0x0000001021167825ULL, 0x040fe400078e0016ULL,
0x0000000014297faeULL, 0x0003e4000b901c46ULL, 0x00000010211c7825ULL, 0x040fe400078e001cULL,
0x00000000162b7faeULL, 0x0003e4000b901c46ULL, 0x00000010211e7825ULL, 0x000fc400078e001eULL,
0x000000001c2d7faeULL, 0x0003e8000b901c46ULL, 0x000000001e317faeULL, 0x0003e4000b901c46ULL,
0x00000300ff767624ULL, 0x000fe200078e00ffULL, 0x0000000102037812ULL, 0x002fe200078ec0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000010300780cULL, 0x000fe20003f05070ULL,
0xffffffffff037424ULL, 0x000fe200078e00ffULL, 0xffffffff76767811ULL, 0x000fc800078e08ffULL,
0x0000000176767807ULL, 0x000fca0004000000ULL, 0x0000000102027824ULL, 0x000fca00078e0276ULL,
0x000000610200720cULL, 0x000fda0003f06070ULL, 0x00000076090c8210ULL, 0x000fe20007ffe079ULL,
0x00000004ff0d8424ULL, 0x000fc800078e00ffULL, 0x000060000c0c8625ULL, 0x000fca00078e000dULL,
0x000000060c038981ULL, 0x000362000c1e1900ULL, 0xffffffe0540a7812ULL, 0x040fe400078ec0ffULL,
0x00000010540b7812ULL, 0x000fca00078ec0ffULL, 0x000000010a0b7824ULL, 0x000fe200078e020bULL,
0x00000008540a7812ULL, 0x000fca00078ec0ffULL, 0x000000010b0a7824ULL, 0x000fe200078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x013608000a0c7f8cULL, 0x002fe8000c80043fULL,
0x01360c000a117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x00000008560e7824ULL, 0x000fe400078e020bULL,
0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL, 0x0000000b00107305ULL, 0x0002a4000021f000ULL,
0x3fa000000b0b7823ULL, 0x002fe200000100ffULL, 0x000000100000735dULL, 0x004fe20003800000ULL,
0x01360c000e117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010000b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011600ULL, 0x00000020620c7824ULL, 0x000fe400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fe200078e00ffULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0xffffff800c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0d107210ULL, 0x000fca0007ffe00bULL, 0x0130000010117984ULL, 0x000e680000000800ULL,
0x0132000010127984ULL, 0x0004e20000000800ULL, 0x000000061100720bULL, 0x002fe20003f1d000ULL,
0x0000fd727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x004fc800000e0100ULL,
0x0000ffff101c7812ULL, 0x000fe2000780c0ffULL, 0x000003e000007945ULL, 0x000fe20003800000ULL,
0x00000001ff177424ULL, 0x000fd600078e00ffULL, 0x000003b000008947ULL, 0x000fea0003800000ULL,
0x00000002ff137819ULL, 0x000fe40000011662ULL, 0x000000061100720bULL, 0x000fe40003f34000ULL,
0x000000621300720cULL, 0x000fe20003f05270ULL, 0x0000fd327f007947ULL, 0x000ff4000b800000ULL,
0x0000000000107806ULL, 0x000fe400008e0100ULL, 0x00000011061d7209ULL, 0x000fe20007810000ULL,
0x0000008062148824ULL, 0x000fe200078e020bULL, 0x0000ffff10137812ULL, 0x000fe400078e3cffULL,
0x00000002ff107819ULL, 0x000fe20000011600ULL, 0x8000001d06067221ULL, 0x000fe20000010000ULL,
0x000000010d148824ULL, 0x000fc600078e0214ULL, 0x3fb8aa3b06067820ULL, 0x000fe40000410000ULL,
0x0134001d14008388ULL, 0x0003e20000000800ULL, 0x000000131cff7212ULL, 0x000fe2000780c0ffULL,
0x00000006002b7308ULL, 0x0002a20000000800ULL, 0x0000fcc27f007947ULL, 0x000ff2000b800000ULL,
0x00001f102b067589ULL, 0x0062a400000e0000ULL, 0x0000000810107810ULL, 0x002fe20007ffe0ffULL,
0x0000fd027f007947ULL, 0x000fea000b800000ULL, 0x00001f102b277589ULL, 0x00032400000e0000ULL,
0x8000001d11110221ULL, 0x100fe20000010000ULL, 0x0000000619197220ULL, 0x084fe20000410000ULL,
0x0000000618187220ULL, 0x080fe20000410000ULL, 0x0000000635357220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b11110820ULL, 0x000fe20000410000ULL, 0x0000000634347220ULL, 0x080fe20000410000ULL,
0x0000000639397220ULL, 0x080fe20000410000ULL, 0x0000000638387220ULL, 0x080fe20000410000ULL,
0x00000011000f0308ULL, 0x000ea20000000800ULL, 0x000000063d3d7220ULL, 0x080fe20000410000ULL,
0x000000063c3c7220ULL, 0x080fe20000410000ULL, 0x0000000641417220ULL, 0x080fe20000410000ULL,
0x0000000640407220ULL, 0x080fe20000410000ULL, 0x0000000645457220ULL, 0x080fe20000410000ULL,
0x0000000644447220ULL, 0x080fe20000410000ULL, 0x0000000649497220ULL, 0x080fe20000410000ULL,
0x0000000648487220ULL, 0x080fe20000410000ULL, 0x000000064d4d7220ULL, 0x080fe20000410000ULL,
0x000000064c4c7220ULL, 0x000fe20000410000ULL, 0x0000002b07077220ULL, 0x000fe20000410000ULL,
0x000000271b1b7220ULL, 0x090fe20000410000ULL, 0x000000271a1a7220ULL, 0x080fe20000410000ULL,
0x0000002737377220ULL, 0x080fe20000410000ULL, 0x0000002736367220ULL, 0x080fe20000410000ULL,
0x000000273b3b7220ULL, 0x080fe20000410000ULL, 0x000000273a3a7220ULL, 0x080fe20000410000ULL,
0x000000273f3f7220ULL, 0x080fe20000410000ULL, 0x000000273e3e7220ULL, 0x080fe20000410000ULL,
0x0000002743437220ULL, 0x080fe20000410000ULL, 0x0000002742427220ULL, 0x080fe20000410000ULL,
0x0000002747477220ULL, 0x080fe20000410000ULL, 0x0000002746467220ULL, 0x080fe20000410000ULL,
0x000000274b4b7220ULL, 0x080fe20000410000ULL, 0x000000274a4a7220ULL, 0x080fe20000410000ULL,
0x000000274f4f7220ULL, 0x080fe20000410000ULL, 0x000000274e4e7220ULL, 0x000fe20000410000ULL,
0x00000001ff177807ULL, 0x000fe20000000000ULL, 0x000000ffff067224ULL, 0x000fe200078e001dULL,
0x0000000f12120220ULL, 0x00cfc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000fff10723eULL, 0x002fe200000000ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff1c7819ULL, 0x000fe40000011600ULL, 0x00005410102b7816ULL, 0x000fe20000000010ULL,
0x0000fa827f007947ULL, 0x000fea000b800000ULL, 0x000000081c107810ULL, 0x000fe20007ffe0ffULL,
0x00001f1c2b6f7589ULL, 0x0002a800000e0000ULL, 0x00001f102b6e7589ULL, 0x00032400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000101c287810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff167424ULL, 0x000fe200078e00ffULL, 0x00002d8000147802ULL, 0x000fe20000000f00ULL,
0xffffffffff297424ULL, 0x000fc400078e00ffULL, 0x000106a000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000181c287810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff167424ULL, 0x000fe200078e00ffULL, 0x00002de000147802ULL, 0x000fe20000000f00ULL,
0xffffffffff297424ULL, 0x000fc400078e00ffULL, 0x0001064000007944ULL, 0x03cfea0003c00000ULL,
0x0000000262777824ULL, 0x040fe200078e00ffULL, 0x00000004ff677819ULL, 0x100fe20000011600ULL,
0x0000020062167824ULL, 0x002fe200078e00ffULL, 0x0000000700117812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000477137812ULL, 0x000fe200078ec0ffULL,
0x0000000712077221ULL, 0x008fe20000010000ULL, 0x0000000811147812ULL, 0x000fc400078ef800ULL,
0xfffff800161d7812ULL, 0x000fe200078ec0ffULL, 0x0000000167157824ULL, 0x000fca00078e0213ULL,
0x0000000715137812ULL, 0x000fca00078e7814ULL, 0x0000000814167824ULL, 0x000fe200078e0213ULL,
0x0000000800137812ULL, 0x000fc600078ec0ffULL, 0x0000001016127824ULL, 0x000fc600078e021dULL,
0x00002000621f7824ULL, 0x000fe200078e00ffULL, 0x0000000713167812ULL, 0x000fe200078ec800ULL,
0x00900000122c783bULL, 0x000e620000000200ULL, 0x0000000267217810ULL, 0x000fe20007ffe0ffULL,
0x0000200056687824ULL, 0x040fe200078e00ffULL, 0xffffc0001f1f7812ULL, 0x000fe400078ec0ffULL,
0x0000000467237810ULL, 0x040fe40007ffe0ffULL, 0x0000000667257810ULL, 0x000fe20007ffe0ffULL,
0x00002000566c7824ULL, 0x000fe200078e021fULL, 0x0000006716677212ULL, 0x000fc400078e3cffULL,
0x0000002116217212ULL, 0x040fe400078e3cffULL, 0x0000002316237212ULL, 0x040fe400078e3cffULL,
0x0000002516257212ULL, 0x000fe400078e3cffULL, 0x0000000713167812ULL, 0x000fe200078ef800ULL,
0x000010007b137824ULL, 0x000fe200078e026cULL, 0x0000000215157810ULL, 0x000fe40007ffe0ffULL,
0x00009910171f7816ULL, 0x000fe200000000ffULL, 0x00000008166d7824ULL, 0x040fe200078e0267ULL,
0x0000b000131c7810ULL, 0x000fe20007ffe0ffULL, 0x00000008166b7824ULL, 0x040fe200078e0221ULL,
0x0000000715157812ULL, 0x000fe200078e7814ULL, 0x00000008166a7824ULL, 0x040fe200078e0223ULL,
0x000000ff1f00720cULL, 0x000fe20003f05270ULL, 0x0000000816697824ULL, 0x000fe200078e0225ULL,
0xfffffff877777812ULL, 0x000fe200078ec0ffULL, 0x000000106d5c7824ULL, 0x000fc400078e021cULL,
0x000000106b587824ULL, 0x100fe400078e021cULL, 0x000000106a507824ULL, 0x100fe400078e021cULL,
0x0000001069307824ULL, 0x000fe200078e021cULL, 0x000000005c5c783bULL, 0x000ee20000004200ULL,
0x0000000814147824ULL, 0x000fe200078e0215ULL, 0x00000080161c7811ULL, 0x000fe200078e18ffULL,
0x0000006f2c2c8232ULL, 0x086fe20000000000ULL, 0x000000005858783bULL, 0x000e620000004200ULL,
0x0000001014137824ULL, 0x000fe200078e021dULL, 0x0000006f2e2e8232ULL, 0x000fe20000000000ULL,
0x0000400055147824ULL, 0x000fe200078e0268ULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x0000000167677824ULL, 0x000fe200078e021cULL, 0x0000006e2d2d8232ULL, 0x090fe20000000000ULL,
0x000010007b1d7824ULL, 0x000fe200078e0214ULL, 0x000000003030783bULL, 0x000fe20000004200ULL,
0x0000000121667824ULL, 0x100fe200078e021cULL, 0x0000006e2f2f8232ULL, 0x000fe20000000000ULL,
0x0000000123657824ULL, 0x100fe200078e021cULL, 0x0000b0001d1e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000125637824ULL, 0x000fe200078e021cULL, 0x009000001314783bULL, 0x000ea60000000200ULL,
0x0000001067287824ULL, 0x000fc400078e021eULL, 0x0000001066247824ULL, 0x100fe400078e021eULL,
0x0000001065207824ULL, 0x100fe400078e021eULL, 0x00000010631e7824ULL, 0x000fe200078e021eULL,
0x000000002828783bULL, 0x000f280000004200ULL, 0x000000002424783bULL, 0x000f280000004200ULL,
0x000000002020783bULL, 0x000f280000004200ULL, 0x000000001e1c783bULL, 0x000f220000004200ULL,
0x0000005c2c4c723cULL, 0x048ff0000000184cULL, 0x0000005e2c48723cULL, 0x040ff00000001848ULL,
0x000000582c44723cULL, 0x002fe20000001844ULL, 0x0000006f14148232ULL, 0x004fc40000000000ULL,
0x0000006f16168232ULL, 0x000fe40000000000ULL, 0x0000006e15158232ULL, 0x080fe40000000000ULL,
0x0000006e17178232ULL, 0x000fe20000000000ULL, 0x0000005a2c40723cULL, 0x040ff00000001840ULL,
0x000000502c3c723cULL, 0x040ff0000000183cULL, 0x000000522c38723cULL, 0x040ff00000001838ULL,
0x000000302c34723cULL, 0x040ff00000001834ULL, 0x000000322c18723cULL, 0x000ff00000001818ULL,
0x00000028144c723cULL, 0x050ff0000000184cULL, 0x0000002a1448723cULL, 0x040ff00000001848ULL,
0x000000241444723cULL, 0x040ff00000001844ULL, 0x000000261440723cULL, 0x040ff00000001840ULL,
0x00000020143c723cULL, 0x040ff0000000183cULL, 0x000000221438723cULL, 0x040ff00000001838ULL,
0x0000001c1434723cULL, 0x040ff00000001834ULL, 0x0000001e1418723cULL, 0x000fe20000001818ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0000004064157811ULL, 0x000fe200078e40ffULL,
0x0136880077ff7f8cULL, 0x0003e2000c80043fULL, 0x000000017b7b7812ULL, 0x000fc400078e0cffULL,
0x000000601500720cULL, 0x000fda0003f06070ULL, 0x00004c3000000947ULL, 0x000fea0003800000ULL,
0x0000001062147824ULL, 0x002fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe014157812ULL, 0x000fe200078ec0ffULL, 0x0000580003787a24ULL, 0x020fe200078e02ffULL,
0x0000000164147810ULL, 0x000fc60007ffe0ffULL, 0x0000010064157824ULL, 0x000fe200078e0215ULL,
0x000000571400720cULL, 0x000fe20003f06070ULL, 0x0000008078787824ULL, 0x000fc600078e00ffULL,
0x0000008015167810ULL, 0x000fc80007ffe0ffULL, 0x00000060051e7812ULL, 0x000fca00078ef816ULL,
0x0000076000008947ULL, 0x000fea0003800000ULL, 0x0000200062157824ULL, 0x000fe200078e00ffULL,
0x00000003ff2b7819ULL, 0x000fe20000011600ULL, 0x0000100008147824ULL, 0x000fc600078e00ffULL,
0x00002000151c7812ULL, 0x000fe200078ec0ffULL, 0x000000012b177824ULL, 0x040fe200078e021eULL,
0x0000001660157217ULL, 0x000fe40007800000ULL, 0x000000042b1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000400055297824ULL, 0x000fe200078e021cULL, 0x0000001778177210ULL, 0x000fe20007f3e0ffULL,
0x0000000115157824ULL, 0x000fe200078e0a16ULL, 0x0000100014147812ULL, 0x000fe200078ec0ffULL,
0x000000081d307824ULL, 0x000fe200078e00ffULL, 0x000000082b217810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1c7224ULL, 0x000fe200008e06ffULL, 0x0000002015287817ULL, 0x000fe20003800000ULL,
0x000000011d157824ULL, 0x000fe200078e021eULL, 0x0000b00029297810ULL, 0x000fe20007ffe014ULL,
0x0000000821327824ULL, 0x000fe200078e00ffULL, 0x00005e0017267a11ULL, 0x000fc400078240ffULL,
0x0000001578157210ULL, 0x000fe40007f5e0ffULL, 0x000000142b317810ULL, 0x000fe40007ffe0ffULL,
0x00005f0017277a11ULL, 0x000fe200008f441cULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x00005e0015167a11ULL, 0x000fe400078440ffULL, 0x000000001d1f7212ULL, 0x040fe400078e3cffULL,
0x000000281d00720cULL, 0x000fc40003f06070ULL, 0x00005f0015177a11ULL, 0x000fe200010f4414ULL,
0x0000000121157824ULL, 0x140fe200078e021eULL, 0x00000000211d7212ULL, 0x040fe400078e3cffULL,
0x000000282100720cULL, 0x000fe20003f26070ULL, 0x0000000131217824ULL, 0x100fe200078e021eULL,
0x0000000c2b2d7810ULL, 0x040fe40007ffe0ffULL, 0x000000102b2f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff832327812ULL, 0x000fe200078ee21dULL, 0x000000012d1d7824ULL, 0x140fe200078e021eULL,
0x0000001578157210ULL, 0x000fe20007f9e0ffULL, 0x000000082d597824ULL, 0x000fe200078e00ffULL,
0xfffffff830307812ULL, 0x000fe200078ee21fULL, 0x000000012f1f7824ULL, 0x000fe200078e021eULL,
0x0000002178217210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff2e7224ULL, 0x000fe200020e06ffULL,
0x0000001d781d7210ULL, 0x000fc40007fbe0ffULL, 0x00005e0015247a11ULL, 0x000fe200078840ffULL,
0x000000ffff207224ULL, 0x000fe200018e06ffULL, 0x0000001f781f7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200028e06ffULL, 0x00005e0021147a11ULL, 0x000fe400078640ffULL,
0x00005f0015257a11ULL, 0x000fe200020f442eULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x00005f0021157a11ULL, 0x000fe200018f4420ULL, 0x0000000856207824ULL, 0x000fe200078e00ffULL,
0x00005e001d227a11ULL, 0x000fc400078a40ffULL, 0x00005e001f1c7a11ULL, 0x000fe400078440ffULL,
0x000000182b337810ULL, 0x040fe40007ffe0ffULL, 0x000000072b217812ULL, 0x040fe400078e4800ULL,
0x0000001c2b537810ULL, 0x000fe40007ffe0ffULL, 0x00005f001d237a11ULL, 0x000fe400028f442cULL,
0x00005f001f1d7a11ULL, 0x000fe200010f442aULL, 0x00000001331f7824ULL, 0x000fe200078e021eULL,
0x0000000820517812ULL, 0x000fc400078ee211ULL, 0x0ffffff821207812ULL, 0x000fe200078ef800ULL,
0x0000000153217824ULL, 0x000fe200078e021eULL, 0x000000282b00720cULL, 0x080fe20003f66070ULL,
0x0000001051267825ULL, 0x000fe200078e0026ULL, 0x0000001f782c7210ULL, 0x040fe40007f5e0ffULL,
0x00000021781f7210ULL, 0x000fe20007fbe0ffULL, 0x00000010202b7824ULL, 0x000fe200078e0229ULL,
0x00005e002c207a11ULL, 0x040fe200078840ffULL, 0x000000ffff217224ULL, 0x000fe200010e06ffULL,
0x000000282d00720cULL, 0x080fe20003f46070ULL, 0x000000ffff2a7224ULL, 0x000fe200028e06ffULL,
0x00005e001f1e7a11ULL, 0x000fe200078a40ffULL, 0x0000001051167825ULL, 0x000fe200078e0016ULL,
0x00005f002c217a11ULL, 0x000fe200020f4421ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262b7faeULL, 0x0003e2000d901c46ULL, 0x00005f001f1f7a11ULL, 0x000fe200028f442aULL,
0x0000001051247825ULL, 0x000fe200078e0024ULL, 0x000000282f00720cULL, 0x000fc40003f66070ULL,
0x000000283100720cULL, 0x080fe20003f86070ULL, 0x0000001051227825ULL, 0x000fe200078e0022ULL,
0x000000283300720cULL, 0x080fe40003fa6070ULL, 0x000000285300720cULL, 0x000fe20003fc6070ULL,
0x00000010511c7825ULL, 0x000fe200078e001cULL, 0x000000002f287212ULL, 0x080fe400078e3cffULL,
0x000000002d2e7212ULL, 0x080fe200078e3cffULL, 0x000000082f2f7824ULL, 0x000fe200078e00ffULL,
0x00000000312a7212ULL, 0x0c0fe200078e3cffULL, 0x0000000831317824ULL, 0x000fe200078e00ffULL,
0x00000000332c7212ULL, 0x0c0fe200078e3cffULL, 0x0000000833337824ULL, 0x000fe200078e00ffULL,
0x0000000053267212ULL, 0x042fe200078e3cffULL, 0x0000000853537824ULL, 0x000fe200078e00ffULL,
0xfffffff8592e7812ULL, 0x000fe200078ee22eULL, 0x0000001030277824ULL, 0x100fe200078e0229ULL,
0xfffffff82f287812ULL, 0x000fe200078ee228ULL, 0x00000010322b7824ULL, 0x100fe200078e0229ULL,
0xfffffff8312a7812ULL, 0x000fe200078ee22aULL, 0x000000102e2d7824ULL, 0x100fe200078e0229ULL,
0xfffffff8332c7812ULL, 0x000fe200078ee22cULL, 0x00000010282f7824ULL, 0x100fe200078e0229ULL,
0xfffffff853267812ULL, 0x000fe200078ee226ULL, 0x000000102a317824ULL, 0x000fe200078e0229ULL,
0x0000000016277faeULL, 0x0003e2000c101c46ULL, 0x0000001051147825ULL, 0x000fc600078e0014ULL,
0x00000000242b7faeULL, 0x0003e2000c901c46ULL, 0x000000102c337824ULL, 0x000fe400078e0229ULL,
0x0000001051207825ULL, 0x040fe200078e0020ULL, 0x00000000222d7faeULL, 0x0003e6000d101c46ULL,
0x0000001026297824ULL, 0x000fe200078e0229ULL, 0x000000001c2f7faeULL, 0x0003e2000d901c46ULL,
0x00000010511e7825ULL, 0x000fc600078e001eULL, 0x0000000014317faeULL, 0x0003e8000e101c46ULL,
0x0000000020337faeULL, 0x0003e8000e901c46ULL, 0x000000001e297faeULL, 0x0003e2000f101c46ULL,
0x000006a000007947ULL, 0x000fea0003800000ULL, 0x0000200062147824ULL, 0x000fe200078e00ffULL,
0x00000003ff177819ULL, 0x000fe20000011600ULL, 0x0000100008157824ULL, 0x000fc400078e00ffULL,
0x0000000856267824ULL, 0x000fe200078e00ffULL, 0x0000200014147812ULL, 0x000fe400078ec0ffULL,
0x0000000c17277810ULL, 0x000fe40007ffe0ffULL, 0x0000100015157812ULL, 0x000fe200078ec0ffULL,
0x0000400055147824ULL, 0x000fe200078e0214ULL, 0x00000004171f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000827207824ULL, 0x000fe200078e00ffULL, 0x00000010172b7810ULL, 0x000fe40007ffe0ffULL,
0x0000b000141c7810ULL, 0x000fe20007ffe015ULL, 0x000000081f217824ULL, 0x000fe200078e00ffULL,
0x0000000027157212ULL, 0x080fe200078e3cffULL, 0x000000082b517824ULL, 0x000fe200078e00ffULL,
0x000000001f167212ULL, 0x0c0fe200078e3cffULL, 0x000000011f1f7824ULL, 0x100fe200078e021eULL,
0xfffffff820297812ULL, 0x000fe200078ee215ULL, 0x0000000117157824ULL, 0x140fe200078e021eULL,
0x0000000817237810ULL, 0x000fe20007ffe0ffULL, 0x0000000127277824ULL, 0x100fe200078e021eULL,
0x00000014172d7810ULL, 0x000fe20007ffe0ffULL, 0x000000012b337824ULL, 0x000fe200078e021eULL,
0xfffffff821217812ULL, 0x000fe200078ee216ULL, 0x0000000823257824ULL, 0x000fe200078e00ffULL,
0x000000002b167212ULL, 0x080fe200078e3cffULL, 0x000000082d227824ULL, 0x040fe200078e00ffULL,
0x0000001578157210ULL, 0x000fe20007f1e0ffULL, 0x000000012d537824ULL, 0x100fe200078e021eULL,
0x0000000023147212ULL, 0x0c0fe200078e3cffULL, 0x0000000123237824ULL, 0x000fe200078e021eULL,
0x000000002d1d7212ULL, 0x000fe200078e3cffULL, 0x00000010212d7824ULL, 0x000fe200078e021cULL,
0x00000018172f7810ULL, 0x000fc40007ffe0ffULL, 0x0000001c17317810ULL, 0x000fe40007ffe0ffULL,
0xfffffff851517812ULL, 0x000fe200078ee216ULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0xfffffff825257812ULL, 0x000fe200078ee214ULL, 0x000000012f5b7824ULL, 0x100fe200078e021eULL,
0xfffffff822597812ULL, 0x000fe200078ee21dULL, 0x00000001315f7824ULL, 0x000fe200078e021eULL,
0x00005e0015147a11ULL, 0x000fe200078040ffULL, 0x000000082f207824ULL, 0x000fe200078e00ffULL,
0x00000007171d7812ULL, 0x000fe200078e4800ULL, 0x00000008316f7824ULL, 0x000fe200078e00ffULL,
0x000000002f177212ULL, 0x080fe200078e3cffULL, 0x00000010252f7824ULL, 0x100fe200078e021cULL,
0x00000000311e7212ULL, 0x000fe200078e3cffULL, 0x0000001029317824ULL, 0x000fe200078e021cULL,
0x00005f0015157a11ULL, 0x000fe200000f4416ULL, 0x0000001051517824ULL, 0x100fe200078e021cULL,
0x0000001f781f7210ULL, 0x000fe20007f1e0ffULL, 0x0000001059597824ULL, 0x000fe200078e021cULL,
0xfffffff820177812ULL, 0x000fc400078ee217ULL, 0x0ffffff81d1d7812ULL, 0x000fe200078ef800ULL,
0x000000ffff207224ULL, 0x000fe200000e06ffULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee21eULL,
0x00000010175d7824ULL, 0x100fe200078e021cULL, 0x0000002378237210ULL, 0x040fe20007f3e0ffULL,
0x000000101d2b7824ULL, 0x100fe200078e021cULL, 0x0000002778277210ULL, 0x000fe20007f5e0ffULL,
0x000000106f6f7824ULL, 0x000fe200078e021cULL, 0x00005e001f1e7a11ULL, 0x000fe200078040ffULL,
0x000000ffff227224ULL, 0x000fe200008e06ffULL, 0x00005e00231c7a11ULL, 0x000fe200078240ffULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x00005e0027167a11ULL, 0x000fc400078440ffULL,
0x00005f001f1f7a11ULL, 0x000fe400000f4420ULL, 0x00005f00231d7a11ULL, 0x000fe400008f4422ULL,
0x0000003378337210ULL, 0x040fe40007f1e0ffULL, 0x00005f0027177a11ULL, 0x000fe400010f4424ULL,
0x0000005378537210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff287224ULL, 0x000fe200000e06ffULL,
0x0000005b785b7210ULL, 0x000fc40007f5e0ffULL, 0x0000005f785f7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x0000000826297812ULL, 0x000fe200078ee211ULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x00005e0033267a11ULL, 0x000fe200078040ffULL,
0x000000ffff2e7224ULL, 0x000fe200018e06ffULL, 0x00005e0053247a11ULL, 0x000fe200078240ffULL,
0x0000001029147825ULL, 0x000fe200078e0014ULL, 0x00005e005b227a11ULL, 0x000fe400078440ffULL,
0x00005e005f207a11ULL, 0x000fe200078640ffULL, 0x00000010291e7825ULL, 0x000fe200078e001eULL,
0x00005f0033277a11ULL, 0x000fe200000f4428ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000142b7faeULL, 0x0003e2000b901c46ULL, 0x00005f0053257a11ULL, 0x000fe200008f442aULL,
0x00000010291c7825ULL, 0x000fe200078e001cULL, 0x00005f005b237a11ULL, 0x000fe200010f442cULL,
0x000000001e2d7faeULL, 0x0003e2000b901c46ULL, 0x00005f005f217a11ULL, 0x000fe200018f442eULL,
0x0000001029167825ULL, 0x000fc400078e0016ULL, 0x000000001c2f7faeULL, 0x0003e4000b901c46ULL,
0x0000001029267825ULL, 0x040fe400078e0026ULL, 0x0000000016317faeULL, 0x0003e4000b901c46ULL,
0x0000001029247825ULL, 0x040fe400078e0024ULL, 0x0000000026517faeULL, 0x0003e4000b901c46ULL,
0x0000001029227825ULL, 0x000fc400078e0022ULL, 0x0000000024597faeULL, 0x0003e4000b901c46ULL,
0x0000001029207825ULL, 0x000fe400078e0020ULL, 0x00000000225d7faeULL, 0x0003e8000b901c46ULL,
0x00000000206f7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x013628000a167f8cULL, 0x002fe8000c80043fULL,
0x01362c000a157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fc40007804817ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff147424ULL, 0x000fc800078e00ffULL,
0x0000001400157305ULL, 0x0002a4000021f000ULL, 0x3fa0000014147823ULL, 0x002fe200000100ffULL,
0x000000150000735dULL, 0x004fe40003800000ULL, 0x01362c000a157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000800b147810ULL, 0x000fca0007ffe00cULL, 0x000000010d147824ULL, 0x000fca00078e0214ULL,
0x0130000014177984ULL, 0x000e680000000800ULL, 0x01320000141c7984ULL, 0x0004e20000000800ULL,
0x000000061700720bULL, 0x002fe20003f1d000ULL, 0x0000e3d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x004fc800000e0100ULL, 0x0000ffff141e7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1d7424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000162157811ULL, 0x000fe400078ff0ffULL,
0x000000061700720bULL, 0x000fe40003f34000ULL, 0x000000621500720cULL, 0x000fe20003f05270ULL,
0x0000e3927f007947ULL, 0x000ff4000b800000ULL, 0x0000000000147806ULL, 0x000fe400008e0100ULL,
0x00000017061f7209ULL, 0x000fe20007810000ULL, 0x0000008062168824ULL, 0x000fe200078e020bULL,
0x0000ffff14157812ULL, 0x000fe400078e3cffULL, 0x00000002ff287819ULL, 0x000fe20000011600ULL,
0x8000001f06067221ULL, 0x000fe20000010000ULL, 0x000000010d168824ULL, 0x000fc600078e0216ULL,
0x3fb8aa3b06067820ULL, 0x000fe40000410000ULL, 0x0134001f16008388ULL, 0x0003e20000000800ULL,
0x000000151eff7212ULL, 0x000fe2000780c0ffULL, 0x00000006002b7308ULL, 0x000ea40000000800ULL,
0x0000002b07077220ULL, 0x004fe20000410000ULL, 0x0000e3127f007947ULL, 0x000fee000b800000ULL,
0x00001f282b277589ULL, 0x0022a400000e0000ULL, 0x000000274c4c7220ULL, 0x084fe20000410000ULL,
0x000000274d4d7220ULL, 0x080fe20000410000ULL, 0x0000002748487220ULL, 0x080fe20000410000ULL,
0x0000002749497220ULL, 0x080fe20000410000ULL, 0x0000002744447220ULL, 0x080fe20000410000ULL,
0x0000002745457220ULL, 0x080fe20000410000ULL, 0x0000002740407220ULL, 0x080fe20000410000ULL,
0x0000002741417220ULL, 0x080fe20000410000ULL, 0x000000273c3c7220ULL, 0x080fe20000410000ULL,
0x000000273d3d7220ULL, 0x080fe20000410000ULL, 0x0000002738387220ULL, 0x080fe20000410000ULL,
0x0000002739397220ULL, 0x080fe20000410000ULL, 0x0000002734347220ULL, 0x080fe20000410000ULL,
0x0000002735357220ULL, 0x080fe20000410000ULL, 0x0000002718187220ULL, 0x080fe20000410000ULL,
0x0000002719197220ULL, 0x000fe20000410000ULL, 0x0000e2427f007947ULL, 0x000fea000b800000ULL,
0x00001f102b277589ULL, 0x00052400000e0000ULL, 0x8000001f17170221ULL, 0x100fe20000010000ULL,
0x00000001ff1d7807ULL, 0x000fe20000000000ULL, 0x000000274e4e7220ULL, 0x094fe20000410000ULL,
0x000000274f4f7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b17170820ULL, 0x000fe20000410000ULL,
0x000000274a4a7220ULL, 0x080fe20000410000ULL, 0x000000274b4b7220ULL, 0x080fe20000410000ULL,
0x0000002746467220ULL, 0x080fe20000410000ULL, 0x00000017000f0308ULL, 0x000ea20000000800ULL,
0x0000002747477220ULL, 0x080fe20000410000ULL, 0x0000002742427220ULL, 0x080fe20000410000ULL,
0x0000002743437220ULL, 0x080fe20000410000ULL, 0x000000273e3e7220ULL, 0x080fe20000410000ULL,
0x000000273f3f7220ULL, 0x080fe20000410000ULL, 0x000000273a3a7220ULL, 0x080fe20000410000ULL,
0x000000273b3b7220ULL, 0x080fe20000410000ULL, 0x0000002736367220ULL, 0x080fe20000410000ULL,
0x0000002737377220ULL, 0x080fe20000410000ULL, 0x000000271a1a7220ULL, 0x080fe20000410000ULL,
0x000000271b1b7220ULL, 0x000fe20000410000ULL, 0x000000ffff067224ULL, 0x000fe200078e001fULL,
0x0000001c0f1c0220ULL, 0x00cfc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000fff14723eULL, 0x000fe200000000ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff287819ULL, 0x002fe40000011600ULL, 0x00005410142b7816ULL, 0x000fe40000000014ULL,
0x0000001828177810ULL, 0x040fe40007ffe0ffULL, 0x00000010281e7810ULL, 0x000fe20007ffe0ffULL,
0x0000e0b27f007947ULL, 0x000fea000b800000ULL, 0x00001f282b7b7589ULL, 0x0002a800000e0000ULL,
0x00001f102b7a7589ULL, 0x00032400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff287224ULL, 0x002fe200078e001eULL, 0x0000497000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff167424ULL, 0x000fc400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x0000eab000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff287224ULL, 0x002fe200078e0017ULL, 0x000049d000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff167424ULL, 0x000fe400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x0000ea5000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000071c077221ULL, 0x008fe20000010000ULL, 0x00001000087d7824ULL, 0x000fe200078e00ffULL,
0x00980000122c783bULL, 0x000ee20000000200ULL, 0x00000002551c7824ULL, 0x000fe200078e0256ULL,
0x000099101d1d7816ULL, 0x000fe400000000ffULL, 0x000010007d7d7812ULL, 0x000fe200078e0cffULL,
0x009800001314783bULL, 0x002e620000000200ULL, 0x000000ff1d00720cULL, 0x000fc40003f05270ULL,
0x0000b0006c727810ULL, 0x100fe20007ffe07dULL, 0x000020001c1c7824ULL, 0x000fc800078e007dULL,
0x000000106d757824ULL, 0x100fe200078e0272ULL, 0x0000b0001c1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000106b747824ULL, 0x100fe400078e0272ULL, 0x000000106a737824ULL, 0x100fe200078e0272ULL,
0x00000000755c783bULL, 0x000f620000004200ULL, 0x0000001069727824ULL, 0x000fe400078e0272ULL,
0x0000001067717824ULL, 0x100fe200078e021cULL, 0x000000007458783bULL, 0x000f220000004200ULL,
0x0000001066707824ULL, 0x000fc400078e021cULL, 0x00000010656f7824ULL, 0x100fe200078e021cULL,
0x000000007350783bULL, 0x000ea20000004200ULL, 0x00000010636e7824ULL, 0x000fc600078e021cULL,
0x000000007230783bULL, 0x000ea80000004200ULL, 0x000000007128783bULL, 0x000ea80000004200ULL,
0x000000007024783bULL, 0x004ea20000004200ULL, 0x0000007b2c2c8232ULL, 0x008fc60000000000ULL,
0x000000006f20783bULL, 0x000ee20000004200ULL, 0x0000007b2e2e8232ULL, 0x080fe40000000000ULL,
0x0000007a2d2d8232ULL, 0x090fe20000000000ULL, 0x000000006e1c783bULL, 0x000f220000004200ULL,
0x0000007a2f2f8232ULL, 0x080fe40000000000ULL, 0x0000007b14148232ULL, 0x082fe40000000000ULL,
0x0000007b16168232ULL, 0x000fe40000000000ULL, 0x0000007a15158232ULL, 0x000fc40000000000ULL,
0x0000007a17178232ULL, 0x000fe20000000000ULL, 0x0000005c2c4c723cULL, 0x060ff0000000184cULL,
0x0000005e2c48723cULL, 0x040ff00000001848ULL, 0x000000582c44723cULL, 0x040ff00000001844ULL,
0x0000005a2c40723cULL, 0x040ff00000001840ULL, 0x000000502c3c723cULL, 0x040ff0000000183cULL,
0x000000522c38723cULL, 0x040ff00000001838ULL, 0x000000302c34723cULL, 0x040ff00000001834ULL,
0x000000322c18723cULL, 0x000ff00000001818ULL, 0x00000028144c723cULL, 0x040ff0000000184cULL,
0x0000002a1448723cULL, 0x040ff00000001848ULL, 0x000000241444723cULL, 0x044ff00000001844ULL,
0x000000261440723cULL, 0x040ff00000001840ULL, 0x00000020143c723cULL, 0x048ff0000000183cULL,
0x000000221438723cULL, 0x040ff00000001838ULL, 0x0000001c1434723cULL, 0x050ff00000001834ULL,
0x0000001e1418723cULL, 0x000fe20000001818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0000008064157811ULL, 0x000fe200078e40ffULL, 0x0136900077ff7f8cULL, 0x0003e2000c80043fULL,
0x00000001087b7812ULL, 0x000fc400078ec0ffULL, 0x000000601500720cULL, 0x000fda0003f06070ULL,
0x000032a000000947ULL, 0x000fea0003800000ULL, 0x0000001062027824ULL, 0x002fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe002037812ULL, 0x000fe400078ec0ffULL,
0x0000000164027810ULL, 0x000fc60007ffe0ffULL, 0x0000010064037824ULL, 0x000fe200078e0203ULL,
0x000000570200720cULL, 0x000fc80003f06070ULL, 0x000000c003037810ULL, 0x000fc80007ffe0ffULL,
0x0000006005167812ULL, 0x000fca00078ef803ULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x0000200062147824ULL, 0x000fe200078e00ffULL, 0x0000000360027217ULL, 0x000fe20007800000ULL,
0x00000008562e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff277819ULL, 0x000fe40000011600ULL,
0x0000200014147812ULL, 0x000fe200078ec0ffULL, 0x0000000102027824ULL, 0x000fe200078e0a03ULL,
0x0000000427177810ULL, 0x040fe20007ffe0ffULL, 0x0000000127037824ULL, 0x040fe200078e0216ULL,
0x00000008271d7810ULL, 0x000fe20007ffe0ffULL, 0x0000400055147824ULL, 0x000fe200078e0214ULL,
0x0000000017157212ULL, 0x040fe200078e3cffULL, 0x00000008172a7824ULL, 0x000fe200078e00ffULL,
0x0000002002267817ULL, 0x000fe20003800000ULL, 0x000000081d1f7824ULL, 0x000fe200078e00ffULL,
0x0000b000147d7810ULL, 0x000fc40007ffe07dULL, 0x0000000378147210ULL, 0x000fe20007f1e0ffULL,
0x0000000117037824ULL, 0x000fe200078e0216ULL, 0xfffffff82a2a7812ULL, 0x000fe400078ee215ULL,
0x000000001d027212ULL, 0x000fe200078e3cffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x00005e0014247a11ULL, 0x040fe400078040ffULL, 0xfffffff81f2c7812ULL, 0x000fe400078ee202ULL,
0x00005f0014257a11ULL, 0x000fc400000f4415ULL, 0x0000000378027210ULL, 0x040fe20007f1e0ffULL,
0x000000011d037824ULL, 0x100fe200078e0216ULL, 0x0000000c27297810ULL, 0x040fe40007ffe0ffULL,
0x00000010272d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x000000261700720cULL, 0x080fe20003f46070ULL, 0x0000000129177824ULL, 0x100fe200078e0216ULL,
0x000000261d00720cULL, 0x000fe20003f26070ULL, 0x000000012d1d7824ULL, 0x000fe200078e0216ULL,
0x0000000378037210ULL, 0x000fc40007f7e0ffULL, 0x00005e0002147a11ULL, 0x000fe400078040ffULL,
0x0000001778177210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x00005f0002157a11ULL, 0x000fe400000f4415ULL, 0x0000001d781d7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x00005e0003227a11ULL, 0x000fe400078040ffULL,
0x00000014272f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff027224ULL, 0x000fe200028e06ffULL,
0x00005f0003237a11ULL, 0x000fc400000f4428ULL, 0x00005e001d1e7a11ULL, 0x000fe200078840ffULL,
0x000000012f037824ULL, 0x000fe200078e0216ULL, 0x0000001827337810ULL, 0x000fe40007ffe0ffULL,
0x00005f001d1f7a11ULL, 0x000fe400020f4402ULL, 0x0000000378027210ULL, 0x000fe20007f1e0ffULL,
0x0000000133037824ULL, 0x000fe200078e0216ULL, 0x00005e0017207a11ULL, 0x000fe200078640ffULL,
0x0000000833307824ULL, 0x000fe200078e00ffULL, 0x0000001c27517810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1d7224ULL, 0x000fe200000e06ffULL, 0x00005f0017217a11ULL, 0x000fc400018f441cULL,
0x000000262700720cULL, 0x000fe20003f66070ULL, 0x0000000151177824ULL, 0x040fe200078e0216ULL,
0x00005e00021c7a11ULL, 0x000fe200078040ffULL, 0x0000000851327824ULL, 0x000fe200078e00ffULL,
0x0000000727277812ULL, 0x100fe400078e4800ULL, 0x0000000378287210ULL, 0x000fe40007f9e0ffULL,
0x00005f00021d7a11ULL, 0x000fe400000f441dULL, 0x0000001778787210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff177224ULL, 0x000fe200020e06ffULL, 0x0ffffff827027812ULL, 0x000fc400078ef800ULL,
0x000000082e317812ULL, 0x000fe200078ee211ULL, 0x000000ffff037224ULL, 0x000fe200028e06ffULL,
0x00005e0028167a11ULL, 0x000fe200078840ffULL, 0x0000001002277824ULL, 0x000fe200078e027dULL,
0x00005e0078027a11ULL, 0x000fe200078a40ffULL, 0x0000001031247825ULL, 0x000fe200078e0024ULL,
0x00005f0028177a11ULL, 0x000fe400020f4417ULL, 0x00005f0078037a11ULL, 0x000fe200028f4403ULL,
0x00000008292e7824ULL, 0x040fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e2000d901c46ULL, 0x000000262900720cULL, 0x080fe20003f06070ULL,
0x0000001031147825ULL, 0x000fe200078e0014ULL, 0x000000262d00720cULL, 0x000fc40003f66070ULL,
0x000000262f00720cULL, 0x080fe20003f86070ULL, 0x0000001031227825ULL, 0x000fe200078e0022ULL,
0x000000263300720cULL, 0x080fe40003fa6070ULL, 0x000000265100720cULL, 0x000fe20003fc6070ULL,
0x0000001031207825ULL, 0x000fe200078e0020ULL, 0x000000002d267212ULL, 0x080fe400078e3cffULL,
0x00000000292b7212ULL, 0x080fe200078e3cffULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0x000000002f287212ULL, 0x0c0fe200078e3cffULL, 0x000000082f2f7824ULL, 0x000fe200078e00ffULL,
0x0000000033297212ULL, 0x080fe200078e3cffULL, 0x000000102c277824ULL, 0x002fe200078e027dULL,
0x0000000051257212ULL, 0x000fe200078e3cffULL, 0x00000010311e7825ULL, 0x000fe200078e001eULL,
0xfffffff82e2e7812ULL, 0x000fc400078ee22bULL, 0xfffffff82d267812ULL, 0x000fe200078ee226ULL,
0x00000010311c7825ULL, 0x000fe200078e001cULL, 0xfffffff830247812ULL, 0x000fe400078ee229ULL,
0xfffffff82f287812ULL, 0x000fe200078ee228ULL, 0x000000102e297824ULL, 0x000fe200078e027dULL,
0xfffffff832307812ULL, 0x000fe200078ee225ULL, 0x000000102a257824ULL, 0x100fe400078e027dULL,
0x00000010262b7824ULL, 0x100fe400078e027dULL, 0x00000010282d7824ULL, 0x100fe200078e027dULL,
0x0000000014257faeULL, 0x0003e2000d101c46ULL, 0x00000010242f7824ULL, 0x000fc400078e027dULL,
0x0000001031167825ULL, 0x040fe200078e0016ULL, 0x0000000022277faeULL, 0x0003e6000c901c46ULL,
0x00000010307d7824ULL, 0x000fe200078e027dULL, 0x0000000020297faeULL, 0x0003e2000c101c46ULL,
0x0000001031027825ULL, 0x000fc600078e0002ULL, 0x000000001e2b7faeULL, 0x0003e8000d901c46ULL,
0x000000001c2d7faeULL, 0x0003e8000e101c46ULL, 0x00000000162f7faeULL, 0x0003e8000e901c46ULL,
0x00000000027d7faeULL, 0x0003e2000f101c46ULL, 0x0000068000007947ULL, 0x000fea0003800000ULL,
0x00000003ff157819ULL, 0x000fe20000011600ULL, 0x0000200062027824ULL, 0x000fc400078e00ffULL,
0x00000008562e7824ULL, 0x000fe200078e00ffULL, 0x00000008151d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000415177810ULL, 0x000fe40007ffe0ffULL, 0x000000001d147212ULL, 0x0c0fe200078e3cffULL,
0x000000081d1f7824ULL, 0x000fe200078e00ffULL, 0x0000000017037212ULL, 0x0c0fe200078e3cffULL,
0x00000008171e7824ULL, 0x000fe200078e00ffULL, 0x0000001415257810ULL, 0x000fe20007ffe0ffULL,
0x0000000117177824ULL, 0x000fe200078e0216ULL, 0xfffffff81f207812ULL, 0x000fe200078ee214ULL,
0x000000011d1d7824ULL, 0x100fe200078e0216ULL, 0x0000000c151f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000825297824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee203ULL,
0x0000000115037824ULL, 0x100fe200078e0216ULL, 0x000000001f1c7212ULL, 0x040fe200078e3cffULL,
0x000000081f277824ULL, 0x040fe200078e00ffULL, 0x0000200002027812ULL, 0x000fe200078ec0ffULL,
0x000000011f1f7824ULL, 0x000fe200078e0216ULL, 0x0000001015217810ULL, 0x000fc40007ffe0ffULL,
0xfffffff827227812ULL, 0x000fe200078ee21cULL, 0x0000400055027824ULL, 0x000fe200078e0202ULL,
0x0000000025267212ULL, 0x080fe200078e3cffULL, 0x0000000821247824ULL, 0x000fe200078e00ffULL,
0x0000001815277810ULL, 0x000fe20007ffe0ffULL, 0x0000000125257824ULL, 0x100fe200078e0216ULL,
0x0000001c152b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000378037210ULL, 0x000fe40007f1e0ffULL,
0x0000000021237212ULL, 0x0c0fe200078e3cffULL, 0x0000000121217824ULL, 0x000fe200078e0216ULL,
0xfffffff829267812ULL, 0x000fe200078ee226ULL, 0x0000000127297824ULL, 0x100fe200078e0216ULL,
0x0000b000027d7810ULL, 0x000fe20007ffe07dULL, 0x000000012b2d7824ULL, 0x000fe200078e0216ULL,
0x0000000027167212ULL, 0x040fe200078e3cffULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x0000000715157812ULL, 0x000fe200078e4800ULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x00005e0003027a11ULL, 0x000fe200078040ffULL, 0x000000082b2c7824ULL, 0x000fe200078e00ffULL,
0x0000001778177210ULL, 0x000fe20007fde0ffULL, 0x0000001026337824ULL, 0x100fe200078e027dULL,
0xfffffff827287812ULL, 0x000fe200078ee216ULL, 0x00000010222f7824ULL, 0x100fe200078e027dULL,
0x0000001f781f7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200030e06ffULL,
0x0ffffff815167812ULL, 0x000fe200078ef800ULL, 0x0000001028517824ULL, 0x000fe200078e027dULL,
0xfffffff824247812ULL, 0x000fc400078ee223ULL, 0x00005f0003037a11ULL, 0x000fe400000f4414ULL,
0x0000001d781d7210ULL, 0x000fe20007fbe0ffULL, 0x0000001024317824ULL, 0x100fe200078e027dULL,
0x0000002178217210ULL, 0x040fe40007f7e0ffULL, 0x0000002578237210ULL, 0x040fe40007f1e0ffULL,
0x00000029782a7210ULL, 0x000fe20007f3e0ffULL, 0x0000001016297824ULL, 0x100fe200078e027dULL,
0x0000002d78787210ULL, 0x000fe20007f5e0ffULL, 0x00000010202d7824ULL, 0x100fe200078e027dULL,
0x00005e0017147a11ULL, 0x000fe200078c40ffULL, 0x000000ffff207224ULL, 0x000fe200020e06ffULL,
0x000000002b257212ULL, 0x000fe200078e3cffULL, 0x000000101e2b7824ULL, 0x000fe200078e027dULL,
0x00005e001f167a11ULL, 0x000fe200078840ffULL, 0x000000ffff1e7224ULL, 0x000fe200028e06ffULL,
0x00005f0017157a11ULL, 0x000fe200030f441cULL, 0x000000ffff267224ULL, 0x000fe200018e06ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078a40ffULL, 0x000000ffff287224ULL, 0x000fe200000e06ffULL,
0x00005f001f177a11ULL, 0x000fe200020f4420ULL, 0x000000ffff1f7224ULL, 0x000fe200008e06ffULL,
0x000000082e277812ULL, 0x000fe200078ee211ULL, 0x000000ffff537224ULL, 0x000fe200010e06ffULL,
0x00005e0021247a11ULL, 0x000fc400078640ffULL, 0x00005e0023227a11ULL, 0x000fe200078040ffULL,
0x0000001027027825ULL, 0x000fe200078e0002ULL, 0x00005f001d1d7a11ULL, 0x000fe400028f441eULL,
0x00005e002a207a11ULL, 0x000fe200078240ffULL, 0x0000001027147825ULL, 0x040fe200078e0014ULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee225ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002297faeULL, 0x0003e2000b901c46ULL, 0x00005e00781e7a11ULL, 0x000fe200078440ffULL,
0x00000010271c7825ULL, 0x000fe200078e001cULL, 0x00005f0021257a11ULL, 0x000fe200018f4426ULL,
0x00000000142b7faeULL, 0x0003e2000b901c46ULL, 0x00005f0023237a11ULL, 0x000fe200000f4428ULL,
0x0000001027167825ULL, 0x040fe200078e0016ULL, 0x00005f002a217a11ULL, 0x000fe200008f441fULL,
0x000000001c2d7faeULL, 0x0003e2000b901c46ULL, 0x00005f00781f7a11ULL, 0x000fe200010f4453ULL,
0x0000001027247825ULL, 0x000fc400078e0024ULL, 0x00000000162f7faeULL, 0x0003e4000b901c46ULL,
0x0000001027227825ULL, 0x040fe400078e0022ULL, 0x0000000024317faeULL, 0x0003e4000b901c46ULL,
0x0000001027207825ULL, 0x000fe400078e0020ULL, 0x0000000022337faeULL, 0x0003e4000b901c46ULL,
0x000000102c7d7824ULL, 0x000fc400078e027dULL, 0x00000010271e7825ULL, 0x000fe200078e001eULL,
0x0000000020517faeULL, 0x0003e8000b901c46ULL, 0x000000001e7d7faeULL, 0x0003e4000b901c46ULL,
0x0000000179027824ULL, 0x002fe400078e0276ULL, 0x00000300ff037624ULL, 0x000fc600078e00ffULL,
0x0000000102147812ULL, 0x000fe400078ec0ffULL, 0xffffffff03037811ULL, 0x000fe400078e08ffULL,
0x000000011400780cULL, 0x000fc80003f05070ULL, 0x0000000103037807ULL, 0x000fca0004000000ULL,
0x0000000102027824ULL, 0x000fe400078e0203ULL, 0xffffffffff037424ULL, 0x000fc600078e00ffULL,
0x000000610200720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000102147824ULL, 0x000fe400078e0209ULL, 0x00000004ff157424ULL, 0x000fc800078e00ffULL,
0x0000600014147625ULL, 0x000fca00078e0015ULL, 0x0000000614037981ULL, 0x000364000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x013648000a167f8cULL, 0x000fe8000c80043fULL, 0x01364c000a157984ULL, 0x002e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0xffffffe054157812ULL, 0x040fe200078ec0ffULL, 0x3e000000ff147424ULL, 0x000fe200078e00ffULL,
0x00000010541c7812ULL, 0x000fc400078ec0ffULL, 0x00000008541d7812ULL, 0x000fc800078ec0ffULL,
0x000000151d157210ULL, 0x000fe40007ffe01cULL, 0x00000014001c7305ULL, 0x0002a4000021f000ULL,
0x3fa0000014147823ULL, 0x002fe200000100ffULL, 0x0000001c0000735dULL, 0x004fe20003800000ULL,
0x01364c00151d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001000b147810ULL, 0x000fca0007ffe00cULL,
0x000000010d147824ULL, 0x000fca00078e0214ULL, 0x0130000014177984ULL, 0x000e680000000800ULL,
0x01320000141c7984ULL, 0x0004e20000000800ULL, 0x000000061700720bULL, 0x002fe20003f1d000ULL,
0x0000cb927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x004fc800000e0100ULL,
0x0000ffff141e7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff1d7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000262157811ULL, 0x000fe400078ff0ffULL, 0x000000061700720bULL, 0x000fe40003f34000ULL,
0x000000621500720cULL, 0x000fe20003f05270ULL, 0x0000cb527f007947ULL, 0x000ff4000b800000ULL,
0x0000000000147806ULL, 0x000fe400008e0100ULL, 0x0000001706157209ULL, 0x000fe20007810000ULL,
0x0000008062208824ULL, 0x000fe200078e020bULL, 0x0000ffff141d7812ULL, 0x000fe400078e3cffULL,
0x00000002ff287819ULL, 0x000fe20000011600ULL, 0x8000001506167221ULL, 0x000fe20000010000ULL,
0x000000010d208824ULL, 0x000fc600078e0220ULL, 0x3fb8aa3b16167820ULL, 0x000fe40000410000ULL,
0x0134001520008388ULL, 0x0003e20000000800ULL, 0x0000001d1eff7212ULL, 0x000fe2000780c0ffULL,
0x00000016002b7308ULL, 0x000ea40000000800ULL, 0x0000002b07077220ULL, 0x004fe20000410000ULL,
0x0000cad27f007947ULL, 0x000fee000b800000ULL, 0x00001f282b277589ULL, 0x0022a400000e0000ULL,
0x000000274c4c7220ULL, 0x084fe20000410000ULL, 0x000000274d4d7220ULL, 0x080fe20000410000ULL,
0x0000002748487220ULL, 0x080fe20000410000ULL, 0x0000002749497220ULL, 0x080fe20000410000ULL,
0x0000002744447220ULL, 0x080fe20000410000ULL, 0x0000002745457220ULL, 0x080fe20000410000ULL,
0x0000002740407220ULL, 0x080fe20000410000ULL, 0x0000002741417220ULL, 0x080fe20000410000ULL,
0x000000273c3c7220ULL, 0x080fe20000410000ULL, 0x000000273d3d7220ULL, 0x080fe20000410000ULL,
0x0000002738387220ULL, 0x080fe20000410000ULL, 0x0000002739397220ULL, 0x080fe20000410000ULL,
0x0000002734347220ULL, 0x080fe20000410000ULL, 0x0000002735357220ULL, 0x080fe20000410000ULL,
0x0000002718187220ULL, 0x080fe20000410000ULL, 0x0000002719197220ULL, 0x000fe20000410000ULL,
0x0000ca027f007947ULL, 0x000fea000b800000ULL, 0x00001f102b277589ULL, 0x00052400000e0000ULL,
0x0000001706067209ULL, 0x000fe20007810000ULL, 0x000000274e4e7220ULL, 0x094fe20000410000ULL,
0x00000001ff1d7807ULL, 0x000fe20000000000ULL, 0x000000274f4f7220ULL, 0x080fe20000410000ULL,
0x000000274a4a7220ULL, 0x080fe20000410000ULL, 0x8000000617170221ULL, 0x000fe20000010000ULL,
0x000000274b4b7220ULL, 0x080fe20000410000ULL, 0x0000002746467220ULL, 0x080fe20000410000ULL,
0x0000002747477220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b17170820ULL, 0x000fe20000410000ULL,
0x0000002742427220ULL, 0x080fe20000410000ULL, 0x0000002743437220ULL, 0x080fe20000410000ULL,
0x000000273e3e7220ULL, 0x080fe20000410000ULL, 0x00000017000f0308ULL, 0x000ea20000000800ULL,
0x000000273f3f7220ULL, 0x080fe20000410000ULL, 0x000000273a3a7220ULL, 0x080fe20000410000ULL,
0x000000273b3b7220ULL, 0x080fe20000410000ULL, 0x0000002736367220ULL, 0x080fe20000410000ULL,
0x0000002737377220ULL, 0x080fe20000410000ULL, 0x000000271a1a7220ULL, 0x080fe20000410000ULL,
0x000000271b1b7220ULL, 0x000fe20000410000ULL, 0x0000001c0f1c0220ULL, 0x00cfc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000fff14723eULL, 0x000fe200000000ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff287819ULL, 0x002fe40000011600ULL,
0x00005410142b7816ULL, 0x000fe40000000014ULL, 0x0000001828177810ULL, 0x040fe40007ffe0ffULL,
0x00000010281e7810ULL, 0x000fe20007ffe0ffULL, 0x0000c8727f007947ULL, 0x000fea000b800000ULL,
0x00001f282b797589ULL, 0x0002a800000e0000ULL, 0x00001f102b767589ULL, 0x00032400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff287224ULL, 0x002fe200078e001eULL,
0x000063c000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff167424ULL, 0x000fc400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x0000d06000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff287224ULL, 0x002fe200078e0017ULL,
0x0000642000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff167424ULL, 0x000fe400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x0000d00000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000071c077221ULL, 0x008fe20000010000ULL,
0x0000100008147824ULL, 0x000fe200078e00ffULL, 0x00a00000122c783bULL, 0x000ee20000000200ULL,
0x00004000551c7824ULL, 0x000fe200078e0268ULL, 0x000099101d1d7816ULL, 0x000fe400000000ffULL,
0x00001000141f7812ULL, 0x000fc400078ec0ffULL, 0x00a000001314783bULL, 0x002e620000000200ULL,
0x000000ff1d00720cULL, 0x000fe40003f05270ULL, 0x0000b0006c6c7810ULL, 0x100fe40007ffe01fULL,
0x0000b0001c1c7810ULL, 0x000fc60007ffe01fULL, 0x000000106d5c7824ULL, 0x100fe400078e026cULL,
0x000000106b587824ULL, 0x100fe400078e026cULL, 0x000000106a507824ULL, 0x100fe400078e026cULL,
0x0000001069307824ULL, 0x000fe200078e026cULL, 0x000000005c5c783bULL, 0x000f220000004200ULL,
0x0000001067287824ULL, 0x100fe400078e021cULL, 0x0000001066247824ULL, 0x100fe200078e021cULL,
0x000000005858783bULL, 0x000ea20000004200ULL, 0x0000001065207824ULL, 0x000fc400078e021cULL,
0x00000010631c7824ULL, 0x000fe200078e021cULL, 0x000000005050783bULL, 0x000ea80000004200ULL,
0x000000003030783bULL, 0x000ea80000004200ULL, 0x000000002828783bULL, 0x000ea40000004200ULL,
0x000000792c2c8232ULL, 0x00cfc40000000000ULL, 0x000000002424783bULL, 0x000ea20000004200ULL,
0x000000792e2e8232ULL, 0x080fe40000000000ULL, 0x000000762d2d8232ULL, 0x090fe20000000000ULL,
0x000000002020783bULL, 0x000ee20000004200ULL, 0x000000762f2f8232ULL, 0x080fe40000000000ULL,
0x0000007914148232ULL, 0x082fe20000000000ULL, 0x000000001c1c783bULL, 0x000e620000004200ULL,
0x0000007916168232ULL, 0x000fe40000000000ULL, 0x0000007615158232ULL, 0x000fc40000000000ULL,
0x0000007617178232ULL, 0x000fe20000000000ULL, 0x0000005c2c4c723cULL, 0x040ff0000000184cULL,
0x0000005e2c48723cULL, 0x040ff00000001848ULL, 0x000000582c44723cULL, 0x040ff00000001844ULL,
0x0000005a2c40723cULL, 0x040ff00000001840ULL, 0x000000502c3c723cULL, 0x040ff0000000183cULL,
0x000000522c38723cULL, 0x040ff00000001838ULL, 0x000000302c34723cULL, 0x040ff00000001834ULL,
0x000000322c18723cULL, 0x000ff00000001818ULL, 0x00000028144c723cULL, 0x040ff0000000184cULL,
0x0000002a1448723cULL, 0x040ff00000001848ULL, 0x000000241444723cULL, 0x044ff00000001844ULL,
0x000000261440723cULL, 0x040ff00000001840ULL, 0x00000020143c723cULL, 0x048ff0000000183cULL,
0x000000221438723cULL, 0x040ff00000001838ULL, 0x0000001c1434723cULL, 0x042ff00000001834ULL,
0x0000001e1418723cULL, 0x000fe20000001818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000c064157811ULL, 0x000fe200078e40ffULL, 0x0136980077ff7f8cULL, 0x0003e2000c80043fULL,
0x00000001087b7812ULL, 0x000fc400078e0cffULL, 0x000000601500720cULL, 0x000fda0003f06070ULL,
0x0000186000000947ULL, 0x000fea0003800000ULL, 0x0000030064157a10ULL, 0x002fe20007ffe0ffULL,
0x0000580003237a24ULL, 0x020fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000115147810ULL, 0x040fe20007ffe0ffULL, 0x0000010015157824ULL, 0x000fe400078e0204ULL,
0x0000008023237824ULL, 0x000fe200078e00ffULL, 0x000000571400720cULL, 0x000fe40003f06070ULL,
0x0000006005227812ULL, 0x000fd600078ef815ULL, 0x0000076000008947ULL, 0x000fea0003800000ULL,
0x0000001560147217ULL, 0x000fe20007800000ULL, 0x0000200062167824ULL, 0x000fe200078e00ffULL,
0x00000003ff257819ULL, 0x000fe20000011600ULL, 0x00000008561c7824ULL, 0x000fe400078e00ffULL,
0x0000000114147824ULL, 0x000fe200078e0a15ULL, 0x0000200016167812ULL, 0x000fe200078ec0ffULL,
0x0000100008157824ULL, 0x000fe200078e00ffULL, 0x000000081c117812ULL, 0x000fe400078ee211ULL,
0x0000000425177810ULL, 0x000fe20007ffe0ffULL, 0x00004000551c7824ULL, 0x000fe200078e0216ULL,
0x0000100015157812ULL, 0x000fe200078ec0ffULL, 0x0000000125167824ULL, 0x000fe200078e0222ULL,
0x00000000171d7212ULL, 0x040fe200078e3cffULL, 0x00000008171e7824ULL, 0x000fe200078e00ffULL,
0x0000b0001c2e7810ULL, 0x000fc40007ffe015ULL, 0x0000001623157210ULL, 0x000fe20007f1e0ffULL,
0x0000000117167824ULL, 0x000fe200078e0222ULL, 0x00000008251f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81e2d7812ULL, 0x000fe200078ee21dULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x0000002014287817ULL, 0x000fe20003800000ULL, 0x000000081f1e7824ULL, 0x000fe200078e00ffULL,
0x00005e0015147a11ULL, 0x000fe200078040ffULL, 0x000000102d2d7824ULL, 0x000fe200078e022eULL,
0x000000001f1d7212ULL, 0x000fc400078e3cffULL, 0x0000000c25317810ULL, 0x040fe40007ffe0ffULL,
0x0000001025337810ULL, 0x000fe40007ffe0ffULL, 0x000000281700720cULL, 0x000fe20003f46070ULL,
0x0000000831307824ULL, 0x000fe200078e00ffULL, 0x00005f0015157a11ULL, 0x000fe200000f441cULL,
0x0000000133207824ULL, 0x100fe200078e0222ULL, 0xfffffff81e2f7812ULL, 0x000fe200078ee21dULL,
0x00000001311e7824ULL, 0x100fe200078e0222ULL, 0x0000001623177210ULL, 0x000fe20007f1e0ffULL,
0x000000011f1c7824ULL, 0x040fe200078e0222ULL, 0x000000281f00720cULL, 0x000fe20003f26070ULL,
0x0000001011147825ULL, 0x000fe200078e0014ULL, 0x0000001e231f7210ULL, 0x000fc40007f9e0ffULL,
0x00000020231d7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff247224ULL, 0x000fe200000e06ffULL,
0x00005e0017167a11ULL, 0x000fe200078040ffULL, 0x000000ffff267224ULL, 0x000fe200020e06ffULL,
0x0000001c23217210ULL, 0x000fe20007f7e0ffULL, 0x000000102f2f7824ULL, 0x000fe200078e022eULL,
0x00005f0017177a11ULL, 0x000fe200000f4424ULL, 0x000000ffff247224ULL, 0x000fe200028e06ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078840ffULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x0000001425517810ULL, 0x000fe20007ffe0ffULL, 0x0000001011167825ULL, 0x000fe200078e0016ULL,
0x00005f001d1d7a11ULL, 0x000fc400020f4424ULL, 0x00005e0021207a11ULL, 0x000fe200078040ffULL,
0x0000000151247824ULL, 0x000fe200078e0222ULL, 0x00005e001f1e7a11ULL, 0x000fe200078640ffULL,
0x00000010111c7825ULL, 0x000fe200078e001cULL, 0x0000001825537810ULL, 0x040fe40007ffe0ffULL,
0x0000001c25597810ULL, 0x000fe40007ffe0ffULL, 0x00005f0021217a11ULL, 0x000fe400000f442aULL,
0x00005f001f1f7a11ULL, 0x000fe200018f4426ULL, 0x0000000159267824ULL, 0x100fe200078e0222ULL,
0x0000002423297210ULL, 0x000fe20007f1e0ffULL, 0x0000000153247824ULL, 0x000fe200078e0222ULL,
0x00000007252b7812ULL, 0x000fe200078e4800ULL, 0x0000001011207825ULL, 0x000fe200078e0020ULL,
0x000000282500720cULL, 0x000fc40003f66070ULL, 0x0000002423277210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200000e06ffULL, 0x00005e0029227a11ULL, 0x000fe200078040ffULL,
0x00000010111e7825ULL, 0x000fe200078e001eULL, 0x0000002623257210ULL, 0x000fe40007fbe0ffULL,
0x0ffffff82b2b7812ULL, 0x000fe200078ef800ULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x00005f0029237a11ULL, 0x000fe200000f442aULL, 0x000000ffff2a7224ULL, 0x000fe200028e06ffULL,
0x00005e0027267a11ULL, 0x000fe200078840ffULL, 0x000000102b2b7824ULL, 0x000fe200078e022eULL,
0x00005e0025247a11ULL, 0x000fe200078a40ffULL, 0x0000001011227825ULL, 0x000fe200078e0022ULL,
0x00005f0027277a11ULL, 0x000fc400020f442cULL, 0x00005f0025257a11ULL, 0x000fe200028f442aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000142b7faeULL, 0x0003e2000d901c46ULL,
0x000000283100720cULL, 0x080fe20003f06070ULL, 0x0000001011267825ULL, 0x000fe200078e0026ULL,
0x000000283300720cULL, 0x080fe20003f66070ULL, 0x00000000162d7faeULL, 0x0005e2000d101c46ULL,
0x000000285100720cULL, 0x080fe20003f86070ULL, 0x0000001011247825ULL, 0x000fe200078e0024ULL,
0x000000285300720cULL, 0x080fe20003fa6070ULL, 0x00000000202f7faeULL, 0x0005e2000c901c46ULL,
0x000000285900720cULL, 0x000fc40003fc6070ULL, 0x0000000033287212ULL, 0x0c0fe200078e3cffULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x0000000031297212ULL, 0x080fe200078e3cffULL,
0x0000000853317824ULL, 0x000fe200078e00ffULL, 0x00000000512a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000851517824ULL, 0x000fe200078e00ffULL, 0x0000000059147212ULL, 0x0c2fe200078e3cffULL,
0x0000000859597824ULL, 0x000fe200078e00ffULL, 0x00000000532c7212ULL, 0x000fe400078e3cffULL,
0xfffffff830297812ULL, 0x000fc400078ee229ULL, 0xfffffff833157812ULL, 0x000fe400078ee228ULL,
0xfffffff8512b7812ULL, 0x000fe200078ee22aULL, 0x0000001029297824ULL, 0x000fe200078e022eULL,
0xfffffff831317812ULL, 0x000fe200078ee22cULL, 0x0000001015157824ULL, 0x000fe200078e022eULL,
0xfffffff859337812ULL, 0x000fe200078ee214ULL, 0x000000102b2b7824ULL, 0x100fe200078e022eULL,
0x000000001e297faeULL, 0x0005e2000c101c46ULL, 0x0000001031317824ULL, 0x100fe400078e022eULL,
0x0000001033337824ULL, 0x000fe200078e022eULL, 0x000000001c157faeULL, 0x0005e8000d901c46ULL,
0x00000000222b7faeULL, 0x0005e8000e101c46ULL, 0x0000000026317faeULL, 0x0005e8000e901c46ULL,
0x0000000024337faeULL, 0x0005e2000f101c46ULL, 0x000006a000007947ULL, 0x000fea0003800000ULL,
0x0000200062157824ULL, 0x000fe200078e00ffULL, 0x00000003ff177819ULL, 0x000fe20000011600ULL,
0x0000100008147824ULL, 0x000fc400078e00ffULL, 0x00000008561e7824ULL, 0x000fe200078e00ffULL,
0x0000200015167812ULL, 0x000fe400078ec0ffULL, 0x00000004171f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000817217810ULL, 0x000fe20007ffe0ffULL, 0x0000400055157824ULL, 0x000fe200078e0216ULL,
0x0000100014147812ULL, 0x000fe200078ec0ffULL, 0x000000081f257824ULL, 0x040fe200078e00ffULL,
0x000000001f167212ULL, 0x080fe200078e3cffULL, 0x0000000821277824ULL, 0x040fe200078e00ffULL,
0x00000000211c7212ULL, 0x000fc400078e3cffULL, 0x0000b000151d7810ULL, 0x000fe20007ffe014ULL,
0x0000000117147824ULL, 0x000fe200078e0222ULL, 0xfffffff825207812ULL, 0x000fe400078ee216ULL,
0xfffffff827247812ULL, 0x000fe400078ee21cULL, 0x0000000c17257810ULL, 0x040fe40007ffe0ffULL,
0x0000001017277810ULL, 0x040fe40007ffe0ffULL, 0x0000001417297810ULL, 0x000fe20007ffe0ffULL,
0x00000008252b7824ULL, 0x000fe200078e00ffULL, 0x0000001423157210ULL, 0x000fe20007f1e0ffULL,
0x00000008272d7824ULL, 0x000fe200078e00ffULL, 0x000000081e117812ULL, 0x000fe200078ee211ULL,
0x00000008292f7824ULL, 0x000fe200078e00ffULL, 0x00000000251c7212ULL, 0x080fe200078e3cffULL,
0x000000ffff167224ULL, 0x000fe200000e06ffULL, 0x00000000271e7212ULL, 0x0c0fe200078e3cffULL,
0x00000001272a7824ULL, 0x000fe200078e0222ULL, 0xfffffff82b287812ULL, 0x000fe200078ee21cULL,
0x00000001211c7824ULL, 0x100fe200078e0222ULL, 0x0000000029267212ULL, 0x040fe200078e3cffULL,
0x00000001292e7824ULL, 0x000fe200078e0222ULL, 0x00005e0015147a11ULL, 0x000fc400078040ffULL,
0xfffffff82d2c7812ULL, 0x000fe400078ee21eULL, 0x00000018172b7810ULL, 0x040fe40007ffe0ffULL,
0x0000001c172d7810ULL, 0x000fe20007ffe0ffULL, 0x000000102c317824ULL, 0x100fe200078e021dULL,
0xfffffff82f307812ULL, 0x000fe200078ee226ULL, 0x0000000125267824ULL, 0x000fe200078e0222ULL,
0x00005f0015157a11ULL, 0x000fe200000f4416ULL, 0x000000011f167824ULL, 0x000fe200078e0222ULL,
0x0000000717177812ULL, 0x000fe200078e4800ULL, 0x000000012b327824ULL, 0x100fe200078e0222ULL,
0x0000001c23217210ULL, 0x000fe20007fbe0ffULL, 0x000000012d227824ULL, 0x000fe200078e0222ULL,
0x00000016231e7210ULL, 0x000fe20007fde0ffULL, 0x000000082d527824ULL, 0x000fe200078e00ffULL,
0x0000002623267210ULL, 0x040fe20007f9e0ffULL, 0x00000010282f7824ULL, 0x100fe200078e021dULL,
0x0000002223507210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200030e06ffULL,
0x000000002b227212ULL, 0x040fe200078e3cffULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0x00005e001e167a11ULL, 0x000fe200078c40ffULL, 0x0000001030337824ULL, 0x000fe200078e021dULL,
0x0000002a232a7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff537224ULL, 0x000fe200010e06ffULL,
0x0000002e232e7210ULL, 0x000fe20007f1e0ffULL, 0x0000001011147825ULL, 0x000fe200078e0014ULL,
0x0000003223327210ULL, 0x000fc40007f3e0ffULL, 0x000000002d237212ULL, 0x000fe200078e3cffULL,
0x00000010242d7824ULL, 0x100fe200078e021dULL, 0x0ffffff8171c7812ULL, 0x000fe200078ef800ULL,
0x000000ffff257224ULL, 0x000fe200000e06ffULL, 0xfffffff82b227812ULL, 0x000fe200078ee222ULL,
0x00000010202b7824ULL, 0x000fe200078e021dULL, 0x00005f001e177a11ULL, 0x000fe200030f441fULL,
0x000000ffff207224ULL, 0x000fe200028e06ffULL, 0x00005e00211e7a11ULL, 0x040fe200078a40ffULL,
0x000000101c297824ULL, 0x000fe200078e021dULL, 0xfffffff852527812ULL, 0x000fe200078ee223ULL,
0x000000ffff237224ULL, 0x000fe200020e06ffULL, 0x00005e00261c7a11ULL, 0x000fe200078840ffULL,
0x0000001022517824ULL, 0x100fe200078e021dULL, 0x00005f00211f7a11ULL, 0x000fe200028f4420ULL,
0x000000ffff217224ULL, 0x000fe200018e06ffULL, 0x00005e002a227a11ULL, 0x000fe200078640ffULL,
0x0000001052597824ULL, 0x000fe200078e021dULL, 0x00005f00261d7a11ULL, 0x000fe200020f4423ULL,
0x000000ffff277224ULL, 0x000fe200008e06ffULL, 0x00005e002e247a11ULL, 0x000fe200078040ffULL,
0x0000001011167825ULL, 0x040fe200078e0016ULL, 0x00005e0032267a11ULL, 0x000fe200078240ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014297faeULL, 0x0003e2000b901c46ULL,
0x00005e0050207a11ULL, 0x000fe200078440ffULL, 0x00000010111e7825ULL, 0x040fe200078e001eULL,
0x00005f002a237a11ULL, 0x000fe200018f4421ULL, 0x00000000162b7faeULL, 0x0003e2000b901c46ULL,
0x00005f002e257a11ULL, 0x000fe200000f4425ULL, 0x00000010111c7825ULL, 0x040fe200078e001cULL,
0x00005f0032277a11ULL, 0x000fe200008f4427ULL, 0x000000001e2d7faeULL, 0x0003e2000b901c46ULL,
0x00005f0050217a11ULL, 0x000fe200010f4453ULL, 0x0000001011227825ULL, 0x000fc400078e0022ULL,
0x000000001c2f7faeULL, 0x0003e4000b901c46ULL, 0x0000001011247825ULL, 0x040fe400078e0024ULL,
0x0000000022317faeULL, 0x0003e4000b901c46ULL, 0x0000001011267825ULL, 0x040fe400078e0026ULL,
0x0000000024337faeULL, 0x0003e4000b901c46ULL, 0x0000001011207825ULL, 0x000fc400078e0020ULL,
0x0000000026517faeULL, 0x0003e8000b901c46ULL, 0x0000000020597faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x013668000a147f8cULL, 0x006fe8000c80043fULL, 0x01366c000a117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007804815ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff117424ULL, 0x000fc800078e00ffULL, 0x0000001100167305ULL, 0x0002a4000021f000ULL,
0x3fa0000011117823ULL, 0x002fe200000100ffULL, 0x000000160000735dULL, 0x004fe20003800000ULL,
0x01366c000a177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001800b0c7810ULL, 0x000fca0007ffe00cULL,
0x000000010d0c7824ULL, 0x000fca00078e020cULL, 0x013000000c117984ULL, 0x000e680000000800ULL,
0x013200000c0a7984ULL, 0x0004e20000000800ULL, 0x000000061100720bULL, 0x002fe20003f1d000ULL,
0x0000b4427f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0c177812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0c7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000362157811ULL, 0x000fe400078ff0ffULL, 0x000000061100720bULL, 0x000fe40003f34000ULL,
0x000000621500720cULL, 0x000fe20003f05270ULL, 0x0000b4027f007947ULL, 0x000ff4000b800000ULL,
0x00000000000c7806ULL, 0x000fe400008e0100ULL, 0x00000011060e7209ULL, 0x000fe20007810000ULL,
0x0000008062148824ULL, 0x000fe200078e020bULL, 0x0000ffff0c0c7812ULL, 0x000fe400078e3cffULL,
0x00000002ff287819ULL, 0x000fe20000011600ULL, 0x8000000e06067221ULL, 0x000fe20000010000ULL,
0x000000010d0d8824ULL, 0x000fc600078e0214ULL, 0x3fb8aa3b06067820ULL, 0x000fe40000410000ULL,
0x0134000e0d008388ULL, 0x0003e20000000800ULL, 0x0000000c17ff7212ULL, 0x000fe2000780c0ffULL,
0x00000006002b7308ULL, 0x000ea40000000800ULL, 0x0000002b07077220ULL, 0x004fe20000410000ULL,
0x0000b3827f007947ULL, 0x000fee000b800000ULL, 0x00001f282b277589ULL, 0x0022a400000e0000ULL,
0x000000274c4c7220ULL, 0x084fe20000410000ULL, 0x000000274d4d7220ULL, 0x080fe20000410000ULL,
0x0000002748487220ULL, 0x080fe20000410000ULL, 0x0000002749497220ULL, 0x080fe20000410000ULL,
0x0000002744447220ULL, 0x080fe20000410000ULL, 0x0000002745457220ULL, 0x080fe20000410000ULL,
0x0000002740407220ULL, 0x080fe20000410000ULL, 0x0000002741417220ULL, 0x080fe20000410000ULL,
0x000000273c3c7220ULL, 0x080fe20000410000ULL, 0x000000273d3d7220ULL, 0x080fe20000410000ULL,
0x0000002738387220ULL, 0x080fe20000410000ULL, 0x0000002739397220ULL, 0x080fe20000410000ULL,
0x0000002734347220ULL, 0x080fe20000410000ULL, 0x0000002735357220ULL, 0x080fe20000410000ULL,
0x0000002718187220ULL, 0x080fe20000410000ULL, 0x0000002719197220ULL, 0x000fe20000410000ULL,
0x0000b2b27f007947ULL, 0x000fea000b800000ULL, 0x00001f102b277589ULL, 0x00052400000e0000ULL,
0x8000000e11110221ULL, 0x100fe20000010000ULL, 0x00000001ff0c7807ULL, 0x000fe20000000000ULL,
0x000000274e4e7220ULL, 0x094fe20000410000ULL, 0x000000274f4f7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b11110820ULL, 0x000fe20000410000ULL, 0x000000274a4a7220ULL, 0x080fe20000410000ULL,
0x000000274b4b7220ULL, 0x080fe20000410000ULL, 0x0000002746467220ULL, 0x080fe20000410000ULL,
0x00000011000f0308ULL, 0x000ea20000000800ULL, 0x0000002747477220ULL, 0x080fe20000410000ULL,
0x0000002742427220ULL, 0x080fe20000410000ULL, 0x0000002743437220ULL, 0x080fe20000410000ULL,
0x000000273e3e7220ULL, 0x080fe20000410000ULL, 0x000000273f3f7220ULL, 0x080fe20000410000ULL,
0x000000273a3a7220ULL, 0x080fe20000410000ULL, 0x000000273b3b7220ULL, 0x080fe20000410000ULL,
0x0000002736367220ULL, 0x080fe20000410000ULL, 0x0000002737377220ULL, 0x080fe20000410000ULL,
0x000000271a1a7220ULL, 0x080fe20000410000ULL, 0x000000271b1b7220ULL, 0x000fe20000410000ULL,
0x000000ffff067224ULL, 0x000fe200078e000eULL, 0x0000000a0f0a0220ULL, 0x00cfc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000fff0b723eULL, 0x000fe200000000ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff287819ULL, 0x002fe40000011600ULL,
0x000054100b2b7816ULL, 0x000fe4000000000bULL, 0x00000018280d7810ULL, 0x040fe40007ffe0ffULL,
0x00000010280e7810ULL, 0x000fe20007ffe0ffULL, 0x0000b1227f007947ULL, 0x000fea000b800000ULL,
0x00001f282b0b7589ULL, 0x0002a800000e0000ULL, 0x00001f102b107589ULL, 0x00032400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff287224ULL, 0x002fe200078e000eULL,
0x00007d2000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff167424ULL, 0x000fc400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x0000b70000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff287224ULL, 0x002fe200078e000dULL,
0x00007d8000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff167424ULL, 0x000fe400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x0000b6a000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000070a077221ULL, 0x008fe20000010000ULL,
0x00a800001214783bULL, 0x002e620000000200ULL, 0x000099100c0a7816ULL, 0x000fc600000000ffULL,
0x00000000751c783bULL, 0x000ee20000004200ULL, 0x000000ff0a00720cULL, 0x000fc60003f05270ULL,
0x000000007420783bULL, 0x000fe80000004200ULL, 0x000000007324783bULL, 0x004fe80000004200ULL,
0x000000007228783bULL, 0x000fe80000004200ULL, 0x00a80000132c783bULL, 0x000ea80000000200ULL,
0x000000007130783bULL, 0x000f680000004200ULL, 0x000000007050783bULL, 0x000f280000004200ULL,
0x000000006f58783bULL, 0x000f280000004200ULL, 0x000000006e5c783bULL, 0x000f220000004200ULL,
0x0000000b14148232ULL, 0x002fc40000000000ULL, 0x0000000b16168232ULL, 0x000fe40000000000ULL,
0x0000001015158232ULL, 0x090fe40000000000ULL, 0x0000001017178232ULL, 0x000fce0000000000ULL,
0x0000001c144c723cULL, 0x008fe2000000184cULL, 0x0000000b2c2c8232ULL, 0x004fce0000000000ULL,
0x0000001e1448723cULL, 0x000fe20000001848ULL, 0x0000000b2e2e8232ULL, 0x000fe40000000000ULL,
0x000000102d2d8232ULL, 0x080fe40000000000ULL, 0x000000102f2f8232ULL, 0x000fc60000000000ULL,
0x000000201444723cULL, 0x040ff00000001844ULL, 0x000000221440723cULL, 0x040ff00000001840ULL,
0x00000024143c723cULL, 0x040ff0000000183cULL, 0x000000261438723cULL, 0x040ff00000001838ULL,
0x000000281434723cULL, 0x040ff00000001834ULL, 0x0000002a1418723cULL, 0x000ff00000001818ULL,
0x000000302c4c723cULL, 0x060ff0000000184cULL, 0x000000322c48723cULL, 0x040ff00000001848ULL,
0x000000502c44723cULL, 0x040ff00000001844ULL, 0x000000522c40723cULL, 0x040ff00000001840ULL,
0x000000582c3c723cULL, 0x040ff0000000183cULL, 0x0000005a2c38723cULL, 0x040ff00000001838ULL,
0x0000005c2c34723cULL, 0x040ff00000001834ULL, 0x0000005e2c18723cULL, 0x000fe20000001818ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0136a00077ff7f8cULL, 0x0003e2000c80043fULL,
0x00000001087b7812ULL, 0x000fce00078ec0ffULL, 0x0000030064647a10ULL, 0x002fc80007ffe0ffULL,
0x000000576400720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff95b000007947ULL, 0x000fea000383ffffULL, 0x0000000000087919ULL, 0x000e640000002500ULL,
0x000000570800720cULL, 0x002fda0003f06070ULL, 0x0000034000000947ULL, 0x000fea0003800000ULL,
0x0180000007007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x00008130002a7802ULL, 0x000fe40000000f00ULL,
0x0000b14000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000700007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000007ULL, 0x800000ff02037221ULL, 0x020fc80000010100ULL,
0x0000000300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000027919ULL, 0x000ee20000000000ULL,
0x0000000803037811ULL, 0x004fe400078ff0ffULL, 0x00000002ff057819ULL, 0x008fc80000011602ULL,
0x00001f0300037589ULL, 0x000ea800000e0000ULL, 0x00001f0500027589ULL, 0x000ee200000e0000ULL,
0x0000004e034e7220ULL, 0x044fe20000410000ULL, 0x0000004f034f7220ULL, 0x040fe20000410000ULL,
0x0000004a034a7220ULL, 0x040fe20000410000ULL, 0x0000004b034b7220ULL, 0x040fe20000410000ULL,
0x0000004c024c7220ULL, 0x048fe20000410000ULL, 0x0000004d024d7220ULL, 0x040fe20000410000ULL,
0x0000004802487220ULL, 0x040fe20000410000ULL, 0x0000004902497220ULL, 0x040fe20000410000ULL,
0x0000004402447220ULL, 0x040fe20000410000ULL, 0x0000004502457220ULL, 0x040fe20000410000ULL,
0x0000004002407220ULL, 0x040fe20000410000ULL, 0x0000004102417220ULL, 0x040fe20000410000ULL,
0x0000003c023c7220ULL, 0x040fe20000410000ULL, 0x0000003d023d7220ULL, 0x040fe20000410000ULL,
0x0000003802387220ULL, 0x040fe20000410000ULL, 0x0000003902397220ULL, 0x040fe20000410000ULL,
0x0000003402347220ULL, 0x040fe20000410000ULL, 0x0000003502357220ULL, 0x040fe20000410000ULL,
0x0000001802187220ULL, 0x040fe20000410000ULL, 0x0000001902197220ULL, 0x000fe20000410000ULL,
0x0000004603467220ULL, 0x040fe20000410000ULL, 0x0000004703477220ULL, 0x040fe20000410000ULL,
0x0000004203427220ULL, 0x040fe20000410000ULL, 0x0000004303437220ULL, 0x040fe20000410000ULL,
0x0000003e033e7220ULL, 0x040fe20000410000ULL, 0x0000003f033f7220ULL, 0x040fe20000410000ULL,
0x0000003a033a7220ULL, 0x040fe20000410000ULL, 0x0000003b033b7220ULL, 0x040fe20000410000ULL,
0x0000003603367220ULL, 0x040fe20000410000ULL, 0x0000003703377220ULL, 0x040fe20000410000ULL,
0x0000001a031a7220ULL, 0x040fe20000410000ULL, 0x0000001b031b7220ULL, 0x000fc40000410000ULL,
0x0000000000037919ULL, 0x020ea20000000000ULL, 0x00000018190f723eULL, 0x000fc400000000ffULL,
0x0000001a1b17723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000034350e723eULL, 0x000fe400000000ffULL, 0x0000004c4d05723eULL, 0x000fe400000000ffULL,
0x000000484909723eULL, 0x000fe400000000ffULL, 0x00000044450a723eULL, 0x000fe400000000ffULL,
0x00000040410b723eULL, 0x000fc400000000ffULL, 0x0000003c3d0c723eULL, 0x000fe400000000ffULL,
0x00000038390d723eULL, 0x000fe400000000ffULL, 0x0000004e4f10723eULL, 0x000fe400000000ffULL,
0x0000004a4b11723eULL, 0x000fe400000000ffULL, 0x000000464712723eULL, 0x000fe400000000ffULL,
0x00000002ff257819ULL, 0x004fc40000011603ULL, 0x0000000803337811ULL, 0x000fe400078ff0ffULL,
0x0000000725007812ULL, 0x040fe200078ec0ffULL, 0x0000000825027824ULL, 0x040fe200078e00ffULL,
0x00000025ff277212ULL, 0x000fe200078e33ffULL, 0x0000000825187824ULL, 0x000fe200078e00ffULL,
0x00000033ff357212ULL, 0x000fe200078e33ffULL, 0x00000008331a7824ULL, 0x000fe200078e00ffULL,
0xfffffff802197812ULL, 0x000fe400078ee225ULL, 0x0000000100027812ULL, 0x000fc400078e3cffULL,
0xfffffff818277812ULL, 0x000fe400078ee227ULL, 0xfffffff81a357812ULL, 0x000fe200078ee235ULL,
0x00000008251b7824ULL, 0x040fe200078e0202ULL, 0x0000000200187812ULL, 0x000fe200078e3cffULL,
0x0000100056027824ULL, 0x000fe200078e00ffULL, 0x00000003001a7812ULL, 0x040fe400078e3cffULL,
0x00000004001c7812ULL, 0x040fe200078e3cffULL, 0x00000008251d7824ULL, 0x040fe200078e0218ULL,
0x00000005001e7812ULL, 0x040fe200078e3cffULL, 0x00000008251f7824ULL, 0x040fe200078e021aULL,
0x0000000600007812ULL, 0x000fe200078e3cffULL, 0x0000000825217824ULL, 0x000fe200078e021cULL,
0x00000007331a7812ULL, 0x000fe200078ec0ffULL, 0x0000000825237824ULL, 0x000fe200078e021eULL,
0x000000424313723eULL, 0x000fe200000000ffULL, 0x0000000403187824ULL, 0x000fe200078e00ffULL,
0x000000021a1e7812ULL, 0x040fe200078e3cffULL, 0x0000000825257824ULL, 0x000fe200078e0200ULL,
0x000000031a207812ULL, 0x000fe200078e3cffULL, 0x0000080055007824ULL, 0x000fe200078e0202ULL,
0x0000000c18187812ULL, 0x000fe200078ec0ffULL, 0x00000008331c7824ULL, 0x000fe200078e00ffULL,
0x000000041a227812ULL, 0x040fe200078e3cffULL, 0x0000001019197824ULL, 0x100fe200078e0200ULL,
0x000000051a247812ULL, 0x000fe200078e3cffULL, 0x000000101b1b7824ULL, 0x100fe200078e0200ULL,
0xfffffff81c297812ULL, 0x000fe200078ee233ULL, 0x000000101d1d7824ULL, 0x100fe200078e0200ULL,
0x000000011a1c7812ULL, 0x040fe200078e3cffULL, 0x000000101f1f7824ULL, 0x000fe200078e0200ULL,
0x000000061a267812ULL, 0x000fe200078e3cffULL, 0x00000001191a7824ULL, 0x000fe200078e0218ULL,
0x0000003e3f14723eULL, 0x000fe200000000ffULL, 0x0000001021217824ULL, 0x000fe200078e0200ULL,
0x0000003a3b15723eULL, 0x000fe200000000ffULL, 0x00000008332b7824ULL, 0x000fe200078e021cULL,
0x000000051a007388ULL, 0x0005e20000000800ULL, 0x0000001023237824ULL, 0x000fe200078e0200ULL,
0x000000363716723eULL, 0x000fe200000000ffULL, 0x00000008332d7824ULL, 0x000fc400078e021eULL,
0x0000001025257824ULL, 0x000fe400078e0200ULL, 0x00000001181d7824ULL, 0x040fe400078e021dULL,
0x00000008332f7824ULL, 0x000fe400078e0220ULL, 0x00000001181a7824ULL, 0x044fe400078e021bULL,
0x0000001027277824ULL, 0x000fe400078e0200ULL, 0x00000001181c7824ULL, 0x000fe200078e021fULL,
0x000000091a007388ULL, 0x0005e20000000800ULL, 0x0000000833197824ULL, 0x000fc400078e0222ULL,
0x0000001029297824ULL, 0x000fe200078e0200ULL, 0x0000000a1d007388ULL, 0x000fe20000000800ULL,
0x0000000118217824ULL, 0x040fe400078e0221ULL, 0x0000000833317824ULL, 0x000fe200078e0224ULL,
0x0000000b1c007388ULL, 0x000fe20000000800ULL, 0x000000102b2b7824ULL, 0x000fe400078e0200ULL,
0x00000001181e7824ULL, 0x000fe200078e0223ULL, 0x0000000c21007388ULL, 0x000fe20000000800ULL,
0x0000000833337824ULL, 0x000fc400078e0226ULL, 0x000000102d2d7824ULL, 0x100fe200078e0200ULL,
0x0000000d1e007388ULL, 0x000fe20000000800ULL, 0x0000000118257824ULL, 0x040fe400078e0225ULL,
0x0000000118207824ULL, 0x040fe400078e0227ULL, 0x000000102f2f7824ULL, 0x100fe200078e0200ULL,
0x0000000e25007388ULL, 0x000fe20000000800ULL, 0x0000000118297824ULL, 0x000fe400078e0229ULL,
0x0000001019197824ULL, 0x100fe200078e0200ULL, 0x0000000f20007388ULL, 0x000fe20000000800ULL,
0x0000001031317824ULL, 0x000fc400078e0200ULL, 0x0000000118227824ULL, 0x040fe200078e022bULL,
0x0000001029007388ULL, 0x000fe20000000800ULL, 0x0000001033337824ULL, 0x100fe400078e0200ULL,
0x00000001182d7824ULL, 0x040fe200078e022dULL, 0x0000001122007388ULL, 0x000fe20000000800ULL,
0x0000001035357824ULL, 0x000fe400078e0200ULL, 0x0000000118247824ULL, 0x040fe200078e022fULL,
0x000000122d007388ULL, 0x000fe20000000800ULL, 0x0000000118197824ULL, 0x000fc400078e0219ULL,
0x0000000118267824ULL, 0x040fe200078e0231ULL, 0x0000001324007388ULL, 0x000fe20000000800ULL,
0x0000000118337824ULL, 0x040fe400078e0233ULL, 0x0000000118287824ULL, 0x000fe200078e0235ULL,
0x0000001419007388ULL, 0x000fe20000000800ULL, 0x00000001041b7824ULL, 0x000fe400078e0203ULL,
0x00000001ff057424ULL, 0x000fe200078e00ffULL, 0x0000001526007388ULL, 0x000fe20000000800ULL,
0x000000101b097824ULL, 0x004fc600078e0202ULL, 0x0000001633007388ULL, 0x000fe20000000800ULL,
0x0000030005007a0cULL, 0x000fc60003f05270ULL, 0x0000001728007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000090c7984ULL, 0x000ea80000000c00ULL,
0x0004000009207984ULL, 0x000ee80000000c00ULL, 0x00080000091c7984ULL, 0x000f280000000c00ULL,
0x000c0000092c7984ULL, 0x000e620000000c00ULL, 0x200000ff0f0f7230ULL, 0x004fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff23237230ULL, 0x008fe40000000000ULL,
0x200000ff22227230ULL, 0x000fe40000000000ULL, 0x200000ff21217230ULL, 0x000fc40000000000ULL,
0x200000ff20207230ULL, 0x000fe40000000000ULL, 0x0000001f0f0f7230ULL, 0x010fe40000000000ULL,
0x0000001e0e0e7230ULL, 0x000fe40000000000ULL, 0x0000001d0d0d7230ULL, 0x000fe40000000000ULL,
0x0000001c0c0c7230ULL, 0x000fe40000000000ULL, 0x0000002f23237230ULL, 0x002fc40000000000ULL,
0x0000002e22227230ULL, 0x000fe20000000000ULL, 0x0000000c09007388ULL, 0x0003e20000000c00ULL,
0x0000002d21217230ULL, 0x000fe40000000000ULL, 0x0000002c20207230ULL, 0x000fca0000000000ULL,
0x0004002009007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00002f0000008947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x000ea20000002700ULL,
0x00005800ff0a7624ULL, 0x000fe200078e00ffULL, 0x0000000155ff7812ULL, 0x000fe2000780f862ULL,
0x00000800ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000000057919ULL, 0x000ea20000002600ULL,
0x000003000a0a7a24ULL, 0x000fe200078e02ffULL, 0x000000ff0300720cULL, 0x000fc40000725670ULL,
0x0000000009147984ULL, 0x0007220000000c00ULL, 0x000066000a0c7a24ULL, 0x002fca00078e02ffULL,
0x01ffffff0c097812ULL, 0x008fe200078ec0ffULL, 0x0000580010107a24ULL, 0x004fc800078e0205ULL,
0x0000030010057a24ULL, 0x000fc800078e02ffULL, 0x00000001050d7824ULL, 0x000fe200078e0208ULL,
0x000007ff0c087811ULL, 0x000fc800078e40ffULL, 0x0000000d080a7211ULL, 0x000fca00078fa8ffULL,
0x00006c000a0a7625ULL, 0x000fcc00078e000bULL, 0x00000400560a7825ULL, 0x000fcc00078e000aULL,
0x000000101b0e7825ULL, 0x000fe200078e000aULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010030a7824ULL, 0x010fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011603ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x000000010d0c7824ULL, 0x000fe200078e0209ULL,
0x000000700a137812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b127812ULL, 0x000fe200078ec0ffULL,
0x00006c000d0a7625ULL, 0x000fc800078e0011ULL, 0x00006c000c0c7625ULL, 0x000fe200078e0011ULL,
0x0000000a120a7210ULL, 0x000fc80007a1e013ULL, 0x0000000c120c7210ULL, 0x000fe40007c7e013ULL,
0x0000000bff0b7210ULL, 0x000fe400007e44ffULL, 0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL,
0x000000060a007986ULL, 0x0003e8000c101906ULL, 0x000000070c007986ULL, 0x0003e4000c101906ULL,
0x000000140e007986ULL, 0x0105e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x00000001ff0b7424ULL, 0x002fe400078e00ffULL, 0x00000004ff077424ULL, 0x000fc600078e00ffULL,
0x000003000b0b7a10ULL, 0x000fe20007ffe1ffULL, 0x00006a0010067625ULL, 0x000fe200078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b060679a8ULL, 0x000ee400099ee1c6ULL, 0x0000000b0600720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0a7807ULL, 0x000fca0000000000ULL,
0x0000000aff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff067984ULL, 0x002e640000000000ULL,
0x000000ff0600720cULL, 0x002fda0003f05270ULL, 0x00002b7000008947ULL, 0x000fea0003800000ULL,
0x000000ff6200720cULL, 0x000fda0003f05270ULL, 0x00000d6000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000038000008947ULL, 0x000fea0003800000ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fe20000011603ULL,
0x00000080ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000001050a7810ULL, 0x000fe40007ffe0ffULL,
0x0000007006177812ULL, 0x004fe400078ec0ffULL, 0x0000000c070e7812ULL, 0x000fe200078ec0ffULL,
0x00006c0005067625ULL, 0x000fc800078e000dULL, 0x00006c000a0a7625ULL, 0x000fe200078e000dULL,
0x000000060e067210ULL, 0x000fc8000791e017ULL, 0x0000000a0e0a7210ULL, 0x000fe40007b5e017ULL,
0x00000007ff077210ULL, 0x000fe400007e24ffULL, 0x0000000bff0b7210ULL, 0x000fc600017e64ffULL,
0x0000000606067981ULL, 0x000368000c1e1900ULL, 0x000000060a0f7981ULL, 0x000362000c1e1900ULL,
0x00000300ff0c7624ULL, 0x000fca00078e00ffULL, 0x000000020c00780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002050a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000dULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a077981ULL, 0x000362000c1e1900ULL,
0x000000040c00780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003050a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a117981ULL, 0x000362000c1e1900ULL, 0x000000040c00780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004050a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000dULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a137981ULL, 0x000362000c1e1900ULL,
0x000000060c00780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005050a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a157981ULL, 0x000362000c1e1900ULL, 0x000000060c00780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000080c00780cULL, 0x002fe40003f06070ULL,
0x00000006050a7810ULL, 0x000fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a0e0a7210ULL, 0x000fe40007a3e017ULL, 0x00000007050c0810ULL, 0x000fe40007ffe0ffULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x00006c000c0c0625ULL, 0x000fca00078e000dULL,
0x0000000c0e0c0210ULL, 0x000fe40007c7e017ULL, 0x000000060a177981ULL, 0x000364000c1e1900ULL,
0x0000000dff0d0210ULL, 0x000fcc0001fe84ffULL, 0x000000060c0d0981ULL, 0x000366000c1e1900ULL,
0x0000030000047ab9ULL, 0x002fe40000000800ULL, 0x0000000704047890ULL, 0x000fc8000fffe03fULL,
0x000000033f047899ULL, 0x000fcc0008011604ULL, 0x00000004ff007c0cULL, 0x000fda000bf05270ULL,
0x0000090000008947ULL, 0x000fea0003800000ULL, 0x000000ffff127224ULL, 0x000fe400078e00ffULL,
0x000000ffff0c7224ULL, 0x000fe400078e0005ULL, 0x000000ffff197224ULL, 0x020fe400078e0006ULL,
0x000000ffff147224ULL, 0x004fc600078e00ffULL, 0x0000030012007a0cULL, 0x000fe40003f26070ULL,
0x0000000114147810ULL, 0x000fc80007ffe0ffULL, 0x0000000414007c0cULL, 0x000fce000bf06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x00000008120a7810ULL, 0x040fe40007ffe0ffULL,
0x00000001120b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001906067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x000000080c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000010030e7824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c10107812ULL, 0x000fe400078ec0ffULL, 0x000000700e197812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e019ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a197981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x00000009120a7810ULL, 0x042fe40007ffe0ffULL, 0x00000002120b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000000f06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x000000090c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000010030e7824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c10107812ULL, 0x000fe400078ec0ffULL,
0x000000700e0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a0f7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a120a7810ULL, 0x042fe40007ffe0ffULL,
0x00000003120b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000706067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000a0c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x0000001003077824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x0000007007077812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fc80007b3e007ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a077981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b120a7810ULL, 0x042fe40007ffe0ffULL, 0x00000004120b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001106067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000b0c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000010030e7824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c10107812ULL, 0x000fe400078ec0ffULL,
0x000000700e117812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a117981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c120a7810ULL, 0x042fe40007ffe0ffULL,
0x00000005120b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001306067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000c0c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000010030e7824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c10107812ULL, 0x000fe400078ec0ffULL, 0x000000700e137812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e013ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a137981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d120a7810ULL, 0x042fe40007ffe0ffULL, 0x00000006120b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001506067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000d0c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000010030e7824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c10107812ULL, 0x000fe400078ec0ffULL,
0x000000700e157812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e015ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a157981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e120a7810ULL, 0x042fe40007ffe0ffULL,
0x00000007120b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001706067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000e0c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000010030e7824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c10107812ULL, 0x000fe400078ec0ffULL, 0x000000700e177812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e017ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a177981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f120a7810ULL, 0x002fe40007ffe0ffULL, 0x0000000d06067209ULL, 0x000fe40007810000ULL,
0x000003000a007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000f0c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000010030d7824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fc80007a3e00dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL, 0x000000060a0d7981ULL, 0x000368000c1e1900ULL,
0x0000000812127810ULL, 0x000fe40007ffe0ffULL, 0x000000080c0c7810ULL, 0x000fe20007ffe0ffULL,
0xfffff74000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ee40000000000ULL,
0x0000001003077824ULL, 0x028fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x002fc80000011603ULL,
0x0000007007077812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fca00078ec0ffULL,
0x0000000107077824ULL, 0x000fca00078e020aULL, 0x0000000607007388ULL, 0x0003e40000000800ULL,
0x000000070300780cULL, 0x040fe20003f04070ULL, 0x0000001003067824ULL, 0x002fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fe20000011603ULL, 0x00000001550e7824ULL, 0x004fe200078e0205ULL,
0x00000002ff0a7819ULL, 0x000fe20000011662ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x00000800ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000c07077812ULL, 0x000fe200078ec0ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000002003137810ULL, 0x000fe20007ffe0ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000030055007a0cULL, 0x040fe20003f26070ULL, 0x0000000106187824ULL, 0x000fe200078e0207ULL,
0x000000010a067812ULL, 0x000fe200078ec0ffULL, 0x0000000255078824ULL, 0x140fe200078e0256ULL,
0x0000000e080a7211ULL, 0x000fe200078fa8ffULL, 0x00000002550d8824ULL, 0x000fe200078e0256ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000207128824ULL, 0x100fe200078e0206ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000020062077824ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000080007077812ULL, 0x000fe200078ec0ffULL, 0x000000020d1a8824ULL, 0x000fc400078e0206ULL,
0x0000200055067824ULL, 0x000fe400078e0202ULL, 0x00000001090c8824ULL, 0x000fe400078e020eULL,
0x00000080ff0d8424ULL, 0x000fe400078e00ffULL, 0x00000080ff0f8424ULL, 0x000fe400078e00ffULL,
0x00000400560a7825ULL, 0x000fc800078e000aULL, 0x0000000106107824ULL, 0x000fe400078e0207ULL,
0x00006c000c0c8625ULL, 0x000fe200078e000dULL, 0x0000000018077984ULL, 0x0002a60000000800ULL,
0x00006c000e0e8625ULL, 0x000fc800078e000fULL, 0x0000000812168824ULL, 0x100fe400078e0203ULL,
0x000000081a1a8824ULL, 0x000fe400078e0203ULL, 0x0000001003197824ULL, 0x040fe400078e0210ULL,
0x0000001003107825ULL, 0x000fe200078e000aULL, 0x000041801a1b8811ULL, 0x000fc600078e20ffULL,
0x0000001013127825ULL, 0x000fe200078e000aULL, 0x00004580160b8811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000010197faeULL, 0x0007e4000b901c46ULL,
0x0000001003148825ULL, 0x040fe400078e000cULL, 0x0038000012197faeULL, 0x0009e2000b901c46ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000001003168825ULL, 0x000fe400078e000eULL,
0x00000000140b8faeULL, 0x000be2000b901c46ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff2a7224ULL, 0x000fc400078e00ffULL, 0x00000000161b8faeULL, 0x0005e2000b901c46ULL,
0x0000000000107805ULL, 0x008fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000127805ULL, 0x010fe2000001ff00ULL, 0x0000000000187805ULL, 0x002fe2000001ff00ULL,
0x00000000000a7805ULL, 0x020fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x004fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000d3000001947ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fe400078e00ffULL,
0x000000ffff2b7224ULL, 0x000fca00078e0055ULL, 0x000000022b2c7810ULL, 0x000fc80007ffe0ffULL,
0x000003002c007a0cULL, 0x000fda0003f06070ULL, 0x0000025000000947ULL, 0x000fea0003800000ULL,
0x000000070300780cULL, 0x000fe20003f04070ULL, 0x000004002c2e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff2d7819ULL, 0x100fe2000001162cULL, 0x0000000105347824ULL, 0x000fe200078e022cULL,
0x0000002003377810ULL, 0x000fe20007ffe0ffULL, 0x00000800ff2f7424ULL, 0x000fe200078e00ffULL,
0x000000012d317812ULL, 0x000fe400078ec0ffULL, 0x000008002e2d7812ULL, 0x000fe400078ec0ffULL,
0x00000034082e7211ULL, 0x000fc600078fa8ffULL, 0x0000000255368824ULL, 0x140fe400078e0256ULL,
0x0000000255328824ULL, 0x000fe400078e0256ULL, 0x00006c002e2e7625ULL, 0x000fc800078e002fULL,
0x0000000109308824ULL, 0x000fe400078e0234ULL, 0x00000080ff338424ULL, 0x000fe400078e00ffULL,
0x0000000236368824ULL, 0x100fe400078e0231ULL, 0x0000000232388824ULL, 0x000fe400078e0231ULL,
0x00006c0030308625ULL, 0x000fc800078e0033ULL, 0x00000080ff358424ULL, 0x000fe400078e00ffULL,
0x0000000106327824ULL, 0x000fe400078e022dULL, 0x00000400562e7825ULL, 0x000fc800078e002eULL,
0x00006c0034348625ULL, 0x000fc800078e0035ULL, 0x00000010032d7824ULL, 0x040fe400078e0232ULL,
0x0000000836368824ULL, 0x000fe400078e0203ULL, 0x0000001003328825ULL, 0x000fc800078e0030ULL,
0x0000000838388824ULL, 0x000fe400078e0203ULL, 0x0000001037307825ULL, 0x100fe200078e002eULL,
0x0000458036378811ULL, 0x000fe400078e20ffULL, 0x0000418038398811ULL, 0x000fe200078e20ffULL,
0x00000010032e7825ULL, 0x000fc800078e002eULL, 0x0000001003348825ULL, 0x000fe200078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800002e2d7faeULL, 0x0003e8000b901c46ULL,
0x00380000302d7faeULL, 0x0003e8000b901c46ULL, 0x0000000032378faeULL, 0x0003e8000b901c46ULL,
0x0000000034398faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff327224ULL, 0x002fe200078e002bULL, 0x00000001ff2f7819ULL, 0x100fe20000011603ULL,
0x00000002552e7824ULL, 0x000fe200078e0256ULL, 0x00000002ff347819ULL, 0x000fe20000011603ULL,
0x00000040322b7824ULL, 0x000fe200078e00ffULL, 0x0000000c2f2f7812ULL, 0x000fe200078ec0ffULL,
0x00000010032d7824ULL, 0x000fe200078e00ffULL, 0x0000000734367812ULL, 0x040fe200078ec0ffULL,
0x0000000834387824ULL, 0x000fe200078e00ffULL, 0x000000802b2b7812ULL, 0x000fca00078ec0ffULL,
0x000001002e2b7824ULL, 0x000fe200078e002bULL, 0x000000702d2e7812ULL, 0x000fe200078ec0ffULL,
0x00000008342d7824ULL, 0x000fc600078e00ffULL, 0x0000002b2f2e7210ULL, 0x000fe20007ffe02eULL,
0x00000008342f7824ULL, 0x000fe200078e00ffULL, 0x00000034ff2b7212ULL, 0x000fe200078e33ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180002e307984ULL, 0x000e620000000800ULL,
0xfffffff8384d7812ULL, 0x000fe400078ee22bULL, 0x0000000834387810ULL, 0x000fe20007ffe0ffULL,
0x004580002e4b7984ULL, 0x0004e20000000800ULL, 0xfffffff82f2b7812ULL, 0x100fe400078ee236ULL,
0x00000038ff497212ULL, 0x000fe200078e33ffULL, 0x00000008383b7824ULL, 0x040fe200078e00ffULL,
0x000000012d2f7812ULL, 0x140fe200078ef636ULL, 0x00000008383d7824ULL, 0x040fe200078e00ffULL,
0x000000022d317812ULL, 0x140fe200078ef636ULL, 0x00000008382e7824ULL, 0x004fe200078e00ffULL,
0x000000032d337812ULL, 0x000fc400078ef636ULL, 0x000000042d357812ULL, 0x140fe400078ef636ULL,
0x000000052d377812ULL, 0x140fe400078ef636ULL, 0x000000062d397812ULL, 0x000fe200078ef636ULL,
0x00000400322d7824ULL, 0x000fe200078e00ffULL, 0xfffffff82e497812ULL, 0x000fe200078ee249ULL,
0x00000004032e7824ULL, 0x000fc600078e00ffULL, 0x000008002d2d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c2e367812ULL, 0x000fe400078ec0ffULL, 0x00000180062e7810ULL, 0x000fca0007ffe02dULL,
0x000000102b2b7824ULL, 0x100fe400078e022eULL, 0x000000102f2f7824ULL, 0x000fe400078e022eULL,
0x00000001362b7824ULL, 0x040fe200078e022bULL, 0x0000003007307221ULL, 0x002fe20000010100ULL,
0x0000001031317824ULL, 0x100fe400078e022eULL, 0x00000001362f7824ULL, 0x000fe200078e022fULL,
0x3fb8aa3b30327820ULL, 0x000fe20000410000ULL, 0x0000000738307812ULL, 0x000fe200078ec0ffULL,
0x000000002b2b7984ULL, 0x000e620000000800ULL, 0x000000104d2d7824ULL, 0x000fc400078e022eULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee230ULL, 0x0000003200327308ULL, 0x000ee20000000800ULL,
0x0000001033337824ULL, 0x000fe200078e022eULL, 0x000000002f2f7984ULL, 0x000fe20000000800ULL,
0x0000000136317824ULL, 0x040fe200078e0231ULL, 0x000000013d3f7812ULL, 0x140fe200078ef630ULL,
0x00000001362d7824ULL, 0x040fe200078e022dULL, 0x000000023d417812ULL, 0x000fe200078ef630ULL,
0x000000103b3b7824ULL, 0x000fe200078e022eULL, 0x000000033d437812ULL, 0x000fe200078ef630ULL,
0x0000000136337824ULL, 0x040fe200078e0233ULL, 0x0000000031317984ULL, 0x000fe20000000800ULL,
0x0000001037377824ULL, 0x000fe200078e022eULL, 0x000000043d457812ULL, 0x000fe200078ef630ULL,
0x00000001363b7824ULL, 0x000fe200078e023bULL, 0x000000002d2d7984ULL, 0x000ea20000000800ULL,
0x000000103f3f7824ULL, 0x100fe200078e022eULL, 0x0000004b324b7220ULL, 0x008fe20000410000ULL,
0x0000000136377824ULL, 0x040fe200078e0237ULL, 0x0000000033337984ULL, 0x000fe20000000800ULL,
0x0000001039397824ULL, 0x000fe200078e022eULL, 0x000000053d477812ULL, 0x140fe200078ef630ULL,
0x00000001363f7824ULL, 0x040fe200078e023fULL, 0x000000003b3b7984ULL, 0x000fe20000000800ULL,
0x0000000136397824ULL, 0x040fe200078e0239ULL, 0x000000063d3d7812ULL, 0x000fe200078ef630ULL,
0x0000001035357824ULL, 0x100fe200078e022eULL, 0x0000000037377984ULL, 0x000fe20000000800ULL,
0x0000001041417824ULL, 0x000fe200078e022eULL, 0x0000002a4b2a7221ULL, 0x000fe20000010000ULL,
0x0000000136357824ULL, 0x000fe200078e0235ULL, 0x00001f344b307589ULL, 0x000ee200000e0000ULL,
0x0000001043437824ULL, 0x000fc400078e022eULL, 0x0000000136417824ULL, 0x040fe200078e0241ULL,
0x000000003f3f7984ULL, 0x000fe20000000800ULL, 0x0000000136437824ULL, 0x000fe400078e0243ULL,
0x0000001045457824ULL, 0x100fe200078e022eULL, 0x0000000039397984ULL, 0x000fe20000000800ULL,
0x000000103d3d7824ULL, 0x100fe400078e022eULL, 0x0000001049497824ULL, 0x100fe200078e022eULL,
0x0000000035357984ULL, 0x000fe20000000800ULL, 0x0000001047477824ULL, 0x000fc400078e022eULL,
0x0000000136457824ULL, 0x040fe200078e0245ULL, 0x0000000041417984ULL, 0x000fe20000000800ULL,
0x00000001363d7824ULL, 0x040fe400078e023dULL, 0x0000000136497824ULL, 0x040fe200078e0249ULL,
0x0000000043437984ULL, 0x000fe20000000800ULL, 0x0000000136477824ULL, 0x000fe400078e0247ULL,
0x2000002bff2e7230ULL, 0x102fe20000004100ULL, 0x00001f384b4b7589ULL, 0x000e6200000e0000ULL,
0x3000002bff2b7230ULL, 0x000fc40000004100ULL, 0x3000002dff327230ULL, 0x004fe20000004100ULL,
0x0000000045457984ULL, 0x000ea20000000800ULL, 0x000000302e177223ULL, 0x088fe20000010017ULL,
0x2000002fff2e7230ULL, 0x000fe20000004100ULL, 0x000000302b1a7223ULL, 0x080fe2000001001aULL,
0x000000003d3d7984ULL, 0x000fe20000000800ULL, 0x20000031ff2b7230ULL, 0x000fe20000004100ULL,
0x0000003032237223ULL, 0x080fe20000010023ULL, 0x000000302e197223ULL, 0x080fe20000010019ULL,
0x0000000049497984ULL, 0x000ee20000000800ULL, 0x20000033ff2e7230ULL, 0x000fe20000004100ULL,
0x000000302b107223ULL, 0x080fe20000010010ULL, 0x2000003bff2b7230ULL, 0x000fe20000004100ULL,
0x0000000047477984ULL, 0x000f220000000800ULL, 0x3000002fff327230ULL, 0x000fe20000004100ULL,
0x000000302e1b7223ULL, 0x000fe2000001001bULL, 0x20000037ff2e7230ULL, 0x000fc40000004100ULL,
0x2000002dff4d7230ULL, 0x000fe20000004100ULL, 0x0000003032297223ULL, 0x080fe20000010029ULL,
0x30000033ff327230ULL, 0x000fe20000004100ULL, 0x0000004b2b0e7223ULL, 0x082fe2000001000eULL,
0x2000003fff2b7230ULL, 0x000fe20000004100ULL, 0x000000302e137223ULL, 0x080fe20000010013ULL,
0x20000039ff2e7230ULL, 0x000fe20000004100ULL, 0x0000003032277223ULL, 0x080fe20000010027ULL,
0x20000035ff347230ULL, 0x000fe20000004100ULL, 0x0000004b2b187223ULL, 0x080fe20000010018ULL,
0x000000ffff2b7224ULL, 0x000fe200078e002cULL, 0x000000302e0d7223ULL, 0x080fe2000001000dULL,
0x30000031ff317230ULL, 0x000fe20000004100ULL, 0x000000304d0c7223ULL, 0x080fe2000001000cULL,
0x30000035ff357230ULL, 0x000fe20000004100ULL, 0x000003002b007a0cULL, 0x000fe20003f06070ULL,
0x30000037ff327230ULL, 0x000fe20000004100ULL, 0x0000003031287223ULL, 0x080fe20000010028ULL,
0x30000039ff397230ULL, 0x000fe20000004100ULL, 0x00000030340b7223ULL, 0x080fe2000001000bULL,
0x3000003fff2e7230ULL, 0x000fe20000004100ULL, 0x0000003035267223ULL, 0x080fe20000010026ULL,
0x0000003032257223ULL, 0x080fe20000010025ULL, 0x0000003039247223ULL, 0x000fe20000010024ULL,
0x20000041ff2d7230ULL, 0x000fe20000004100ULL, 0x0000004b2e217223ULL, 0x000fe20000010021ULL,
0x20000043ff307230ULL, 0x000fc40000004100ULL, 0x30000043ff2e7230ULL, 0x000fe20000004100ULL,
0x0000004b2d167223ULL, 0x080fe20000010016ULL, 0x20000045ff2d7230ULL, 0x004fe20000004100ULL,
0x0000004b30157223ULL, 0x080fe20000010015ULL, 0x20000049ff307230ULL, 0x008fe20000004100ULL,
0x0000004b2e1f7223ULL, 0x080fe2000001001fULL, 0x2000003dff2e7230ULL, 0x000fe20000004100ULL,
0x0000004b2d147223ULL, 0x080fe20000010014ULL, 0x3000003bff3b7230ULL, 0x000fe20000004100ULL,
0x0000004b300f7223ULL, 0x080fe2000001000fULL, 0x30000041ff417230ULL, 0x000fe20000004100ULL,
0x0000004b2e117223ULL, 0x080fe20000010011ULL, 0x30000045ff457230ULL, 0x000fe20000004100ULL,
0x0000004b3b227223ULL, 0x080fe20000010022ULL, 0x20000047ff2f7230ULL, 0x110fe20000004100ULL,
0x0000004b41207223ULL, 0x080fe20000010020ULL, 0x30000047ff2c7230ULL, 0x000fe20000004100ULL,
0x0000004b451e7223ULL, 0x080fe2000001001eULL, 0x3000003dff3d7230ULL, 0x000fe20000004100ULL,
0x0000004b2f127223ULL, 0x080fe20000010012ULL, 0x30000049ff497230ULL, 0x000fe20000004100ULL,
0x0000004b2c1d7223ULL, 0x000fc4000001001dULL, 0x0000004b3d1c7223ULL, 0x080fe4000001001cULL,
0x0000004b490a7223ULL, 0x000fe2000001000aULL, 0xfffff2f000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x000000ff5600720cULL, 0x000fe20003f05270ULL,
0x0000001003057824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011603ULL,
0x0000007005057812ULL, 0x000fe400078ec0ffULL, 0x0000000c03067812ULL, 0x000fca00078ec0ffULL,
0x0000000105077824ULL, 0x000fe200078e0206ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000001003057824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011603ULL, 0x0000007005067812ULL, 0x000fe400078ec0ffULL,
0x0000000c03087812ULL, 0x000fc600078ec0ffULL, 0x0000008055037824ULL, 0x000fc800078e0206ULL,
0x0000000108037824ULL, 0x000fca00078e0203ULL, 0x0049802a03007388ULL, 0x0003e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0049800007037984ULL, 0x002e680000000800ULL, 0x004a000007067984ULL, 0x000ea20000000800ULL,
0x00000003ff037221ULL, 0x002fc80000010000ULL, 0x0000000603037221ULL, 0x004fca0000010000ULL,
0x0180000003057810ULL, 0x000fc80007ffe0ffULL, 0x7f80000005057812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0500780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e0003ULL,
0x0000b0c0002a7802ULL, 0x000fe40000000f00ULL, 0x000081b000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000300067308ULL, 0x000e640000001000ULL, 0xbf80000003057423ULL, 0x002fc80000000006ULL,
0x800000ff05057221ULL, 0x000fc80000010100ULL, 0x0000000506057223ULL, 0x000fe40000000006ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000008032e7811ULL, 0x004fe400078ff0ffULL,
0x00000002ff2c7819ULL, 0x000fc60000011603ULL, 0x00001f2e05097589ULL, 0x000ea200000e0000ULL,
0x000000082e327824ULL, 0x000fe400078e00ffULL, 0x000000082c307824ULL, 0x000fe200078e00ffULL,
0x00001f2c05067589ULL, 0x00072200000e0000ULL, 0x0000000e090e7220ULL, 0x044fe20000410000ULL,
0x0000002209057220ULL, 0x048fe20000410000ULL, 0x0000000f090f7220ULL, 0x040fe20000410000ULL,
0x0000000a090a7220ULL, 0x040fe20000410000ULL, 0x0000002806077220ULL, 0x052fe20000410000ULL,
0x0000001706177220ULL, 0x040fe20000410000ULL, 0x0000001a061a7220ULL, 0x040fe20000410000ULL,
0x0000001906197220ULL, 0x040fe20000410000ULL, 0x0000002906087220ULL, 0x040fe20000410000ULL,
0x0000001006107220ULL, 0x040fe20000410000ULL, 0x0000001b061b7220ULL, 0x040fe20000410000ULL,
0x0000002706287220ULL, 0x040fe20000410000ULL, 0x0000000b060b7220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000001306137220ULL, 0x040fe20000410000ULL,
0x00000025062a7220ULL, 0x040fe20000410000ULL, 0x0000000d060d7220ULL, 0x040fe20000410000ULL,
0x0000002406247220ULL, 0x040fe20000410000ULL, 0x0000000c060c7220ULL, 0x040fe20000410000ULL,
0x0000002306237220ULL, 0x000fe20000410000ULL, 0x0000001f09067220ULL, 0x040fe20000410000ULL,
0x0000001809187220ULL, 0x040fe20000410000ULL, 0x0000002109217220ULL, 0x040fe20000410000ULL,
0x0000001509157220ULL, 0x040fe20000410000ULL, 0x0000001409147220ULL, 0x040fe20000410000ULL,
0x0000001e091f7220ULL, 0x040fe20000410000ULL, 0x0000001209127220ULL, 0x040fe20000410000ULL,
0x0000001d091d7220ULL, 0x000fe20000410000ULL, 0x0000000e0505723eULL, 0x000fe200000000ffULL,
0x0000001609167220ULL, 0x040fe20000410000ULL, 0x000000072c0e7812ULL, 0x040fe200078ec0ffULL,
0x0000002009257220ULL, 0x040fe20000410000ULL, 0x0000001109117220ULL, 0x040fe20000410000ULL,
0x0000001c091c7220ULL, 0x000fe20000410000ULL, 0x000000082c097824ULL, 0x000fe200078e00ffULL,
0x0000002eff297212ULL, 0x000fc400078e33ffULL, 0x000000100707723eULL, 0x000fe400000000ffULL,
0x0000000f0a0a723eULL, 0x000fe400000000ffULL, 0x000000190808723eULL, 0x000fe400000000ffULL,
0x000000182118723eULL, 0x000fe400000000ffULL, 0x000000150606723eULL, 0x000fe400000000ffULL,
0x000000141f14723eULL, 0x000fc400000000ffULL, 0x000000121d12723eULL, 0x000fe400000000ffULL,
0x000000072e107812ULL, 0x000fe400078ec0ffULL, 0x000000010e0f7812ULL, 0x040fe400078e3cffULL,
0x000000020e157812ULL, 0x040fe400078e3cffULL, 0x000000030e197812ULL, 0x000fe200078e3cffULL,
0x000000082c0f7824ULL, 0x000fe200078e020fULL, 0x000000040e1d7812ULL, 0x000fe200078e3cffULL,
0x000000082c157824ULL, 0x000fe200078e0215ULL, 0x000000050e1f7812ULL, 0x000fe200078e3cffULL,
0x000000082c197824ULL, 0x000fe200078e0219ULL, 0x000000060e217812ULL, 0x000fe200078e3cffULL,
0x00000004030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c230c723eULL, 0x000fe200000000ffULL,
0x000000082e237824ULL, 0x000fe200078e00ffULL, 0xfffffff832337812ULL, 0x000fe200078ee229ULL,
0x000000082c1d7824ULL, 0x040fe200078e021dULL, 0x000000162516723eULL, 0x000fe200000000ffULL,
0x000000082c1f7824ULL, 0x040fe200078e021fULL, 0xfffffff809097812ULL, 0x000fe200078ee22cULL,
0x000000082c217824ULL, 0x000fe200078e0221ULL, 0x0000002cff277212ULL, 0x000fe200078e33ffULL,
0x000000100f0f7824ULL, 0x100fe200078e0200ULL, 0x0000000110257812ULL, 0x040fe200078e3cffULL,
0x0000001009097824ULL, 0x100fe200078e0200ULL, 0x0000000210297812ULL, 0x040fe200078e3cffULL,
0x0000001015157824ULL, 0x000fe200078e0200ULL, 0x00000003102b7812ULL, 0x000fe200078e3cffULL,
0x000000082e257824ULL, 0x000fe200078e0225ULL, 0x00000004102d7812ULL, 0x000fe200078e3cffULL,
0x000000082e297824ULL, 0x000fe200078e0229ULL, 0x00000005102f7812ULL, 0x000fe200078e3cffULL,
0x000000082e2b7824ULL, 0x000fe200078e022bULL, 0x0000000610317812ULL, 0x000fe200078e3cffULL,
0x000000082e2d7824ULL, 0x000fe200078e022dULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x000000082e2f7824ULL, 0x000fe200078e022fULL, 0xfffffff830277812ULL, 0x000fe200078ee227ULL,
0x000000082e317824ULL, 0x000fe200078e0231ULL, 0xfffffff823237812ULL, 0x000fe200078ee22eULL,
0x0000001019197824ULL, 0x000fe200078e0200ULL, 0x000000171a17723eULL, 0x000fe200000000ffULL,
0x0000000109107824ULL, 0x000fe200078e020eULL, 0x0000001b281b723eULL, 0x000fe200000000ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0200ULL, 0x000000111c11723eULL, 0x000fe200000000ffULL,
0x0000001027277824ULL, 0x100fe200078e0200ULL, 0x0000000b260b723eULL, 0x000fe200000000ffULL,
0x0000001023237824ULL, 0x100fe200078e0200ULL, 0x000000132a13723eULL, 0x000fe200000000ffULL,
0x0000001033337824ULL, 0x100fe200078e0200ULL, 0x0000001710007388ULL, 0x0003e20000000800ULL,
0x000000101f1f7824ULL, 0x100fe200078e0200ULL, 0x0000000d240d723eULL, 0x000fe200000000ffULL,
0x0000001021217824ULL, 0x000fc400078e0200ULL, 0x0000001025257824ULL, 0x100fe400078e0200ULL,
0x0000001029297824ULL, 0x100fe400078e0200ULL, 0x000000102b2b7824ULL, 0x100fe400078e0200ULL,
0x000000102d2d7824ULL, 0x100fe400078e0200ULL, 0x000000102f2f7824ULL, 0x100fe400078e0200ULL,
0x0000001031317824ULL, 0x000fc400078e0200ULL, 0x000000010e0f7824ULL, 0x040fe400078e020fULL,
0x000000010e007824ULL, 0x040fe400078e0215ULL, 0x000000010e1a7824ULL, 0x040fe200078e0219ULL,
0x000000080f007388ULL, 0x000fe20000000800ULL, 0x000000010e1c7824ULL, 0x040fe400078e021dULL,
0x000000010e1e7824ULL, 0x040fe200078e021fULL, 0x0000000700007388ULL, 0x000fe20000000800ULL,
0x000000010e207824ULL, 0x000fc400078e0221ULL, 0x000000010e277824ULL, 0x040fe200078e0227ULL,
0x0000001b1a007388ULL, 0x000fe20000000800ULL, 0x000000010e227824ULL, 0x040fe400078e0223ULL,
0x000000010e257824ULL, 0x040fe200078e0225ULL, 0x0000000b1c007388ULL, 0x000fe20000000800ULL,
0x000000010e297824ULL, 0x040fe400078e0229ULL, 0x000000010e2b7824ULL, 0x040fe200078e022bULL,
0x000000131e007388ULL, 0x000fe20000000800ULL, 0x000000010e2d7824ULL, 0x000fc400078e022dULL,
0x000000010e2f7824ULL, 0x040fe200078e022fULL, 0x0000000d20007388ULL, 0x000fe20000000800ULL,
0x000000010e107824ULL, 0x042fe400078e0231ULL, 0x000000010e337824ULL, 0x000fe200078e0233ULL,
0x0000000c27007388ULL, 0x000fe20000000800ULL, 0x0000000104097824ULL, 0x000fc600078e0203ULL,
0x0000000522007388ULL, 0x000fe20000000800ULL, 0x0000001009097824ULL, 0x000fc600078e0202ULL,
0x0000001825007388ULL, 0x000fe80000000800ULL, 0x0000001629007388ULL, 0x000fe80000000800ULL,
0x000000062b007388ULL, 0x000fe80000000800ULL, 0x000000142d007388ULL, 0x000fe80000000800ULL,
0x000000122f007388ULL, 0x000fe80000000800ULL, 0x0000001110007388ULL, 0x000fe80000000800ULL,
0x0000000a33007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000090c7984ULL, 0x000e680000000c00ULL, 0x00040000091c7984ULL, 0x000ea80000000c00ULL,
0x0008000009187984ULL, 0x000ee80000000c00ULL, 0x000c000009207984ULL, 0x000f220000000c00ULL,
0x200000ff0f0f7230ULL, 0x002fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x004fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fc40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x0000001b0f0f7230ULL, 0x008fe40000000000ULL, 0x0000001a0e0e7230ULL, 0x000fe40000000000ULL,
0x000000190d0d7230ULL, 0x000fe40000000000ULL, 0x000000180c0c7230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x010fc40000000000ULL, 0x000000221e1e7230ULL, 0x000fe20000000000ULL,
0x0000000c09007388ULL, 0x0003e20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fca0000000000ULL, 0x0004001c09007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff5500720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002003117810ULL, 0x000fe20007ffe0ffULL,
0x0000000000067919ULL, 0x000ee20000002600ULL, 0x00000003ff107819ULL, 0x000fe20000011603ULL,
0x00000000000579c3ULL, 0x000f220000002700ULL, 0x00000003ff047819ULL, 0x000fe20000011611ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000710087812ULL, 0x000fe200078e4803ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000704007812ULL, 0x000fe400078e4811ULL,
0x0ffffff808077812ULL, 0x000fc400078ef803ULL, 0x0ffffff800057812ULL, 0x000fc600078ef811ULL,
0x0000001007007824ULL, 0x100fe400078e0202ULL, 0x0000001005057824ULL, 0x000fc600078e0202ULL,
0x0000000000087984ULL, 0x0023680000000c00ULL, 0x00000000050c7984ULL, 0x0045620000000c00ULL,
0x0000000806077824ULL, 0x048fe400078e00ffULL, 0x0000000806137824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x010fe2000f8e023fULL, 0x0000000856007824ULL, 0x042fe200078e00ffULL,
0xfffffff807027812ULL, 0x000fe200078ee210ULL, 0x0000000856567824ULL, 0x000fe200078e00ffULL,
0xfffffff813047812ULL, 0x000fc400078ee204ULL, 0x0000000402107c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000404027c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff800037812ULL, 0x000fe200078ee203ULL,
0x000000ffff057224ULL, 0x004fe200000e06ffULL, 0x00005a0010047a11ULL, 0x000fe200078040ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005a0002067a11ULL, 0x000fe400078240ffULL,
0x00005b0010057a11ULL, 0x000fc400000f4405ULL, 0x00005b0002077a11ULL, 0x000fe400008f4407ULL,
0xfffffff856117812ULL, 0x000fe200078ee211ULL, 0x0000001003027825ULL, 0x000fc800078e0004ULL,
0x0000001011047825ULL, 0x000fe200078e0006ULL, 0x0000000802007986ULL, 0x020fe8000c101d06ULL,
0x0000000c04007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff037819ULL, 0x000fe20000011662ULL, 0xffffffffff6c7424ULL, 0x000fc800078e00ffULL,
0x0000000264027824ULL, 0x000fca00078e0203ULL, 0x000000610200720cULL, 0x000fda0003f06070ULL,
0x0000000263038824ULL, 0x000fc800078e00ffULL, 0x0000640003088a24ULL, 0x002fc800078e0202ULL,
0x0000600008088625ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000006086c8981ULL, 0x000ea2000c1e1900ULL, 0x0000000164047810ULL, 0x000fe20007ffe0ffULL,
0x0000004062037824ULL, 0x000fe400078e00ffULL, 0x0000008012057824ULL, 0x000fe200078e00ffULL,
0x000000570400720cULL, 0x000fe20003f06070ULL, 0x000000800e047824ULL, 0x000fe200078e00ffULL,
0x01360000ff067f8cULL, 0x000e62000c80043fULL, 0x00000100640b7824ULL, 0x000fca00078e0203ULL,
0x00000040041a7812ULL, 0x000fe200078ef80bULL, 0x000000056c237224ULL, 0x004fc800078e02ffULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1f7819ULL, 0x102fe40000011600ULL,
0x0000000b60087217ULL, 0x000fe40007800000ULL, 0x000000181f257810ULL, 0x040fe20007ffe0ffULL,
0x000000011a097824ULL, 0x000fe200078e021fULL, 0x000000081f137810ULL, 0x040fe20007ffe0ffULL,
0x00000001080e7824ULL, 0x000fe200078e0a0bULL, 0x000000101f197810ULL, 0x000fe40007ffe0ffULL,
0x0000000923097210ULL, 0x000fe20007f1e0ffULL, 0x000000011a087824ULL, 0x000fe200078e0213ULL,
0x00000003ff0f7819ULL, 0x000fc40000011600ULL, 0x0000100062117811ULL, 0x000fe200078e68ffULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x00005e0009187a11ULL, 0x000fe400078040ffULL,
0x000000030f0f7812ULL, 0x000fe400078e4800ULL, 0x00005f0009157a11ULL, 0x000fe200000f440aULL,
0x000000011a0a7824ULL, 0x040fe200078e0225ULL, 0x0000000823087210ULL, 0x000fe20007f1e0ffULL,
0x000000011a097824ULL, 0x000fe200078e0219ULL, 0x0ffffffc0f007812ULL, 0x000fc400078ef800ULL,
0x0000000a230a7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0x0000000923147210ULL, 0x000fe40007f3e0ffULL, 0x00005e0008107a11ULL, 0x000fe200078040ffULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x00005e000a127a11ULL, 0x000fe200078440ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e06ffULL, 0x00005e00140d7a11ULL, 0x000fe400078240ffULL,
0x00005f000a167a11ULL, 0x000fe200010f4409ULL, 0x00000004130a7824ULL, 0x000fe200078e00ffULL,
0x000000300c217812ULL, 0x000fe200078ec0ffULL, 0x00000004190c7824ULL, 0x000fe200078e00ffULL,
0x00005f0008177a11ULL, 0x000fc400000f4417ULL, 0x00005f0014147a11ULL, 0x000fe400008f440bULL,
0x0000000e1f00720cULL, 0x080fe40003f06070ULL, 0x0000000e1300720cULL, 0x000fe20003f26070ULL,
0x0000001000137824ULL, 0x000fe200078e0211ULL, 0x0000001821087210ULL, 0x000fe40007f7e0ffULL,
0x0000000e1900720cULL, 0x000fe40003f46070ULL, 0xfffffffc0a007812ULL, 0x000fe200078ee20fULL,
0x000000ffff097224ULL, 0x000fe200018e0615ULL, 0x000000201f197810ULL, 0x000fc40007ffe0ffULL,
0x00000021100a7210ULL, 0x080fe20007f7e0ffULL, 0x0000001000157824ULL, 0x000fe200078e0211ULL,
0xfffffffc0c107812ULL, 0x000fe200078ee20fULL, 0x000000011a007824ULL, 0x000fe200078e0219ULL,
0x000000210d0c7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200018e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e2000c101c46ULL,
0x0000001010177824ULL, 0x000fe200078e0211ULL, 0x000000281f1b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000425107824ULL, 0x040fe200078e00ffULL, 0x000000000a157faeULL, 0x0005e2000c901c46ULL,
0x000000ffff0d7224ULL, 0x000fe200020e0614ULL, 0x0000000e2500720cULL, 0x000fc40003f86070ULL,
0x000000301f1d7810ULL, 0x040fe40007ffe0ffULL, 0x000000381f1f7810ULL, 0x000fe20007ffe0ffULL,
0x000000000c177faeULL, 0x0007e2000d101c46ULL, 0x0000000023097210ULL, 0x002fe40007f1e0ffULL,
0x0000002112087210ULL, 0x000fe40007fbe0ffULL, 0x00005e0009147a11ULL, 0x000fe200078c40ffULL,
0x000000ffff0a7224ULL, 0x004fe200000e06ffULL, 0xfffffffc10007812ULL, 0x000fc400078ee20fULL,
0x0000000e1900720cULL, 0x080fe40003f66070ULL, 0x0000000e1b00720cULL, 0x080fe20003f46070ULL,
0x00000010000b7824ULL, 0x000fe200078e0211ULL, 0x0000000e1d00720cULL, 0x080fe20003f26070ULL,
0x000000011a007824ULL, 0x040fe200078e021bULL, 0x0000000e1f00720cULL, 0x000fe20003f06070ULL,
0x000000011a0c7824ULL, 0x048fe200078e021fULL, 0x00005f00090e7a11ULL, 0x000fe200030f440aULL,
0x000000ffff097224ULL, 0x000fe200028e0616ULL, 0x0000000023127210ULL, 0x040fe20007fbe0ffULL,
0x000000011a0a7824ULL, 0x000fe200078e021dULL, 0x0000000c230d7210ULL, 0x000fe20007fde0ffULL,
0x0000000419007824ULL, 0x000fe200078e00ffULL, 0x00000000080b7faeULL, 0x0003e2000e101c46ULL,
0x000000041d0c7824ULL, 0x000fe200078e00ffULL, 0x0000000a23107210ULL, 0x000fe20007f9e0ffULL,
0x000000041b0a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc00007812ULL, 0x100fe200078ee20fULL,
0x000000041f167824ULL, 0x000fe200078e00ffULL, 0xfffffffc0c0c7812ULL, 0x000fc400078ee20fULL,
0xfffffffc0a0a7812ULL, 0x000fe200078ee20fULL, 0x0000001000137824ULL, 0x100fe400078e0211ULL,
0x000000100c177824ULL, 0x000fe200078e0211ULL, 0xfffffffc16087812ULL, 0x002fe200078ee20fULL,
0x000000ffff097224ULL, 0x000fe200028e06ffULL, 0x00005e00120b7a11ULL, 0x000fe200078a40ffULL,
0x000000100a157824ULL, 0x100fe400078e0211ULL, 0x0000001008117824ULL, 0x000fe200078e0211ULL,
0x00005f0012127a11ULL, 0x000fe200028f4409ULL, 0x000000ffff0f7224ULL, 0x000fe200020e06ffULL,
0x0000002114087210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff007224ULL, 0x000fe200030e06ffULL,
0x00005e00100c7a11ULL, 0x000fc600078840ffULL, 0x000000ffff097224ULL, 0x000fe200028e060eULL,
0x000000210b0a7210ULL, 0x080fe40007fbe0ffULL, 0x00005e000d0e7a11ULL, 0x040fe400078c40ffULL,
0x00005f00100f7a11ULL, 0x000fe200020f440fULL, 0x000000ffff0b7224ULL, 0x000fe200028e0612ULL,
0x000000210c0c7210ULL, 0x080fe20007f9e0ffULL, 0x0000000008137faeULL, 0x0003e2000d901c46ULL,
0x00005f000d007a11ULL, 0x000fe400030f4400ULL, 0x000000210e0e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e060fULL, 0x000000000a157faeULL, 0x0003e6000d101c46ULL,
0x000000ffff0f7224ULL, 0x000fe200028e0600ULL, 0x000000000c177faeULL, 0x0003e8000c901c46ULL,
0x000000000e117faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000001a00087211ULL, 0x042fe400078ff0ffULL, 0x00000020000e7811ULL, 0x000fc400078ff0ffULL,
0x0000000823087210ULL, 0x000fe40007f1e0ffULL, 0x00000008001b7811ULL, 0x000fe200078ff0ffULL,
0x000000011a0f7824ULL, 0x000fe200078e020eULL, 0x00000003ff177819ULL, 0x100fe20000011600ULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e0008247a11ULL, 0x000fe200078040ffULL,
0x000000040e0e7824ULL, 0x000fe200078e00ffULL, 0x00000018000b7811ULL, 0x000fe400078ff0ffULL,
0x00005f0008267a11ULL, 0x000fe200000f4409ULL, 0x000000011a087824ULL, 0x000fe200078e021bULL,
0x0000001000097811ULL, 0x040fe200078ff0ffULL, 0x000000040b167824ULL, 0x000fe200078e00ffULL,
0x0000002800107811ULL, 0x000fe200078ff0ffULL, 0x000000011a0d7824ULL, 0x040fe200078e020bULL,
0x0000000317197812ULL, 0x000fe200078e4800ULL, 0x000000011a0a7824ULL, 0x000fe200078e0209ULL,
0x0000003000127811ULL, 0x000fe200078ff0ffULL, 0x000000011a117824ULL, 0x000fe200078e0210ULL,
0x0000003800147811ULL, 0x000fe200078ff0ffULL, 0x0000000410187824ULL, 0x000fe200078e00ffULL,
0x0000000f230f7210ULL, 0x000fe20007f3e0ffULL, 0x000000011a137824ULL, 0x000fe200078e0212ULL,
0x0000100062257811ULL, 0x000fe200078e68ffULL, 0x000000011a157824ULL, 0x000fe200078e0214ULL,
0x0ffffffc19107812ULL, 0x000fe200078ef800ULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0x0000000823227210ULL, 0x000fe20007fde0ffULL, 0x000000041b087824ULL, 0x000fe200078e00ffULL,
0x0000000a231e7210ULL, 0x000fe20007fbe0ffULL, 0x00000004090a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc16097812ULL, 0x000fe200078ee219ULL, 0x0000001010277824ULL, 0x000fe200078e0225ULL,
0x0000000d231c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0xfffffffc180b7812ULL, 0x000fe200078ee219ULL, 0x000000ffff177224ULL, 0x000fe200030e06ffULL,
0x00005e000f107a11ULL, 0x000fe200078240ffULL, 0x00000010091d7824ULL, 0x000fe200078e0225ULL,
0xfffffffc08007812ULL, 0x000fe200078ee219ULL, 0x000000100b217824ULL, 0x000fe200078e0225ULL,
0xfffffffc0a087812ULL, 0x100fe200078ee219ULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0xfffffffc0e0a7812ULL, 0x000fe200078ee219ULL, 0x0000000414147824ULL, 0x000fe200078e00ffULL,
0x00005e0022207a11ULL, 0x000fe200078c40ffULL, 0x00000010081b7824ULL, 0x000fe200078e0225ULL,
0xfffffffc120d7812ULL, 0x000fe200078ee219ULL, 0x000000100a1f7824ULL, 0x000fe200078e0225ULL,
0x0000001123117210ULL, 0x000fc40007f5e0ffULL, 0x0000001323137210ULL, 0x000fe40007f7e0ffULL,
0x00005e001c0b7a11ULL, 0x000fe200078040ffULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0x00005f000f1a7a11ULL, 0x000fe200008f441aULL, 0x000000ffff0a7224ULL, 0x000fe200018e06ffULL,
0x000000300c0f7812ULL, 0x000fe400078ec0ffULL, 0x0000001523157210ULL, 0x000fe20007f9e0ffULL,
0x000000100d237824ULL, 0x000fe200078e0225ULL, 0x00005f0022227a11ULL, 0x000fe200030f4417ULL,
0x000000ffff177224ULL, 0x000fe200028e06ffULL, 0x00005f001c1c7a11ULL, 0x000fc400000f4409ULL,
0xfffffffc140e7812ULL, 0x000fe200078ee219ULL, 0x0000001000197824ULL, 0x100fe200078e0225ULL,
0x00005e001e0d7a11ULL, 0x000fe200078a40ffULL, 0x000000ffff007224ULL, 0x000fe200020e06ffULL,
0x000000240f087210ULL, 0x000fe20007f1e0ffULL, 0x000000100e257824ULL, 0x000fe200078e0225ULL,
0x00005e0013147a11ULL, 0x000fe400078440ffULL, 0x00005e0011127a11ULL, 0x000fe200078240ffULL,
0x000000ffff097224ULL, 0x000fe200000e0626ULL, 0x00005f001e1e7a11ULL, 0x000fc400028f4417ULL,
0x00005e0015167a11ULL, 0x000fe400078640ffULL, 0x00005f0013177a11ULL, 0x000fe200010f440aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008277faeULL, 0x0003e2000b901c46ULL,
0x00005f0011187a11ULL, 0x000fe400008f4418ULL, 0x000000200f0a7210ULL, 0x040fe40007f1e0ffULL,
0x0000000d0f0c7210ULL, 0x000fe40007f3e0ffULL, 0x00005f0015007a11ULL, 0x000fc400018f4400ULL,
0x0000000b0f0e7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0622ULL,
0x000000100f107210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e061eULL,
0x000000120f127210ULL, 0x040fe40007f9e0ffULL, 0x000000140f147210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200018e061aULL, 0x000000160f167210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e061cULL, 0x000000000a197faeULL, 0x0003e2000b901c46ULL,
0x000000ffff137224ULL, 0x000fc400020e0618ULL, 0x000000ffff157224ULL, 0x000fe200028e0617ULL,
0x000000000c1b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff177224ULL, 0x000fc600000e0600ULL,
0x000000000e1d7faeULL, 0x0003e8000b901c46ULL, 0x00000000101f7faeULL, 0x0003e8000b901c46ULL,
0x0000000012217faeULL, 0x0003e8000b901c46ULL, 0x0000000014237faeULL, 0x0003e8000b901c46ULL,
0x0000000016257faeULL, 0x0003e4000b901c46ULL, 0x01360400ff097984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000009ff7812ULL, 0x002fc60007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000087305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000080000735dULL, 0x004fe20003800000ULL, 0x01360400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000576400720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x0000640063637a24ULL, 0x000fe200078e02ffULL,
0x0001368862567811ULL, 0x040fe200078e18ffULL, 0x0000002062067824ULL, 0x000fe200078e00ffULL,
0xffffffff57557810ULL, 0x000fe40007ffe0ffULL, 0x0000010064077824ULL, 0x008fe200078e0203ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000076000720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x014fea0003800000ULL, 0x0000000164087810ULL, 0x000fe20007ffe0ffULL,
0x0000006c056c7224ULL, 0x000fe200078e02ffULL, 0x00000040076f7812ULL, 0x000fe400078ec0ffULL,
0x000000570800720cULL, 0x000fc60003f06070ULL, 0x00000001046f7824ULL, 0x000fd400078e026fULL,
0x000006a000008947ULL, 0x000fea0003800000ULL, 0x00000002ff177819ULL, 0x002fe40000011600ULL,
0x0000000300707812ULL, 0x000fe400078ec0ffULL, 0x0000001817237810ULL, 0x040fe20007ffe0ffULL,
0x0000000117097824ULL, 0x140fe200078e026fULL, 0x0000001017227810ULL, 0x040fe40007ffe0ffULL,
0x0000002017247810ULL, 0x000fe20007ffe0ffULL, 0x00000001230d7824ULL, 0x100fe200078e026fULL,
0x000000096c097210ULL, 0x000fe20007f3e0ffULL, 0x00000001220b7824ULL, 0x100fe200078e026fULL,
0x0000000817197810ULL, 0x000fe20007ffe0ffULL, 0x00000001240f7824ULL, 0x000fe200078e026fULL,
0x0000000d6c0d7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00005e0009107a11ULL, 0x000fc400078240ffULL, 0x0000000b6c0b7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200020e06ffULL, 0x00005f0009117a11ULL, 0x000fe200008f4408ULL,
0x0000000119097824ULL, 0x000fe200078e026fULL, 0x0000000f6c087210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff167224ULL, 0x000fe200018e06ffULL, 0x00005e000d0e7a11ULL, 0x000fe400078840ffULL,
0x000000096c137210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x00005e000b147a11ULL, 0x000fc400078640ffULL, 0x00005e00080a7a11ULL, 0x040fe200078240ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x00005f000d0f7a11ULL, 0x000fe400020f440cULL,
0x00000003ff0d7819ULL, 0x000fe40000011600ULL, 0x00005f000b157a11ULL, 0x000fe200018f4416ULL,
0x0000000419167824ULL, 0x000fe200078e00ffULL, 0x00005f00080b7a11ULL, 0x000fe200008f4409ULL,
0x0000000160087824ULL, 0x000fe200078e0a07ULL, 0x00005e0013127a11ULL, 0x000fc400078440ffULL,
0x000000000d097212ULL, 0x000fe400078e3cffULL, 0x0000002817257810ULL, 0x040fe40007ffe0ffULL,
0x0000003017267810ULL, 0x040fe40007ffe0ffULL, 0x0000003817277810ULL, 0x000fe40007ffe0ffULL,
0x00005f0013137a11ULL, 0x000fe400010f4418ULL, 0x000000081700720cULL, 0x080fe20003f46070ULL,
0x0000000125177824ULL, 0x100fe200078e026fULL, 0x0000000309097812ULL, 0x000fe200078ec0ffULL,
0x00000001271b7824ULL, 0x100fe200078e026fULL, 0x000000081900720cULL, 0x000fe20003f26070ULL,
0x0000000126197824ULL, 0x000fe200078e026fULL, 0x00002000620c7811ULL, 0x000fc400078e68ffULL,
0x00000004701d7812ULL, 0x000fe400078efcffULL, 0x0ffffffc096d7812ULL, 0x000fe400078ef800ULL,
0xfffffffc16217812ULL, 0x000fe200078ee209ULL, 0x000000101d107825ULL, 0x000fe200078e0010ULL,
0x000000176c177210ULL, 0x040fe40007f9e0ffULL, 0x000000196c197210ULL, 0x040fe20007fbe0ffULL,
0x000000106d1f7824ULL, 0x100fe200078e020cULL, 0x0000001b6c1b7210ULL, 0x000fe20007f7e0ffULL,
0x0000001021217824ULL, 0x000fe200078e020cULL, 0x000000082700720cULL, 0x080fe20003fc6070ULL,
0x000000101d127825ULL, 0x000fe200078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101f7faeULL, 0x0003e2000d101c46ULL, 0x000000082300720cULL, 0x000fc40003f46070ULL,
0x000000ffff207224ULL, 0x000fe200020e06ffULL, 0x00005e0017167a11ULL, 0x000fe200078840ffULL,
0x000000ffff1e7224ULL, 0x000fe200028e06ffULL, 0x00005e0019187a11ULL, 0x000fe200078a40ffULL,
0x000000ffff1c7224ULL, 0x000fe200018e06ffULL, 0x00005e001b1a7a11ULL, 0x000fe200078640ffULL,
0x0000000012217faeULL, 0x0005e2000c901c46ULL, 0x00005f0017177a11ULL, 0x000fe200020f4420ULL,
0x000000101d0e7825ULL, 0x000fe200078e000eULL, 0x00005f0019197a11ULL, 0x000fe400028f441eULL,
0x00005f001b1b7a11ULL, 0x000fe200018f441cULL, 0x0000000425107824ULL, 0x042fe200078e00ffULL,
0x000000082200720cULL, 0x0c0fe20003f26070ULL, 0x0000000422227824ULL, 0x000fe200078e00ffULL,
0x000000082400720cULL, 0x0c0fe20003f66070ULL, 0x0000000424247824ULL, 0x000fe200078e00ffULL,
0x000000082500720cULL, 0x080fe20003f86070ULL, 0x0000000427127824ULL, 0x004fe200078e00ffULL,
0x000000082600720cULL, 0x000fe20003fa6070ULL, 0x0000000423087824ULL, 0x000fe200078e00ffULL,
0xfffffffc221f7812ULL, 0x100fe200078ee209ULL, 0x0000000426267824ULL, 0x000fe200078e00ffULL,
0xfffffffc24237812ULL, 0x000fe200078ee209ULL, 0x000000101d0a7825ULL, 0x000fe200078e000aULL,
0xfffffffc08217812ULL, 0x000fc400078ee209ULL, 0xfffffffc10257812ULL, 0x100fe200078ee209ULL,
0x000000101f1f7824ULL, 0x000fe200078e020cULL, 0xfffffffc26277812ULL, 0x000fe200078ee209ULL,
0x000000101d107825ULL, 0x000fe200078e0014ULL, 0xfffffffc12297812ULL, 0x000fc600078ee209ULL,
0x0000001021217824ULL, 0x100fe200078e020cULL, 0x00000000101f7faeULL, 0x0003e2000c901c46ULL,
0x0000001023237824ULL, 0x100fe400078e020cULL, 0x0000001025257824ULL, 0x000fe200078e020cULL,
0x000000000e217faeULL, 0x0003e2000d101c46ULL, 0x000000101d127825ULL, 0x000fc600078e0016ULL,
0x000000000a237faeULL, 0x0003e2000d901c46ULL, 0x0000001027277824ULL, 0x000fe400078e020cULL,
0x000000101d147825ULL, 0x000fe200078e0018ULL, 0x0000000012257faeULL, 0x0003e6000e101c46ULL,
0x0000001029297824ULL, 0x000fe200078e020cULL, 0x0000000014277faeULL, 0x0003e2000e901c46ULL,
0x000000101d167825ULL, 0x000fca00078e001aULL, 0x0000000016297faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x042fe400078ff0ffULL,
0x0000001000207811ULL, 0x040fe400078ff0ffULL, 0x0000006f00097211ULL, 0x000fe200078ff0ffULL,
0x000000011e0b7824ULL, 0x100fe200078e026fULL, 0x0000001800227811ULL, 0x000fe200078ff0ffULL,
0x00000001200d7824ULL, 0x000fe200078e026fULL, 0x000000096c097210ULL, 0x000fe20007f3e0ffULL,
0x000000041e1e7824ULL, 0x000fe200078e00ffULL, 0x0000000b6c0b7210ULL, 0x000fe20007f5e0ffULL,
0x0000000420207824ULL, 0x000fe200078e00ffULL, 0x0000000d6c0d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x00005e0009107a11ULL, 0x000fe200078240ffULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x00005e000b0e7a11ULL, 0x000fe200078440ffULL,
0x000000ffff087224ULL, 0x000fe200018e06ffULL, 0x00005e000d0a7a11ULL, 0x000fc400078640ffULL,
0x0000002000247811ULL, 0x040fe400078ff0ffULL, 0x0000003000287811ULL, 0x040fe400078ff0ffULL,
0x0000002800267811ULL, 0x000fe400078ff0ffULL, 0x00005f0009117a11ULL, 0x000fe200008f4412ULL,
0x0000000122097824ULL, 0x100fe200078e026fULL, 0x00005f000b0f7a11ULL, 0x000fe200010f440cULL,
0x0000000128157824ULL, 0x100fe200078e026fULL, 0x00005f000d0b7a11ULL, 0x000fe200018f4408ULL,
0x00000001240d7824ULL, 0x100fe200078e026fULL, 0x000000096c197210ULL, 0x000fe20007f5e0ffULL,
0x0000000126137824ULL, 0x000fe200078e026fULL, 0x000000156c087210ULL, 0x000fe20007f3e0ffULL,
0x0000000422227824ULL, 0x000fe200078e00ffULL, 0x0000000d6c177210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x000000136c0c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x00005e0019127a11ULL, 0x000fe200078440ffULL,
0x000000ffff1a7224ULL, 0x000fe200018e06ffULL, 0x00005e0017147a11ULL, 0x000fe200078640ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e06ffULL, 0x00005e0008187a11ULL, 0x000fe200078240ffULL,
0x0000000424247824ULL, 0x000fe200078e00ffULL, 0x00005e000c167a11ULL, 0x000fe200078840ffULL,
0x0000000426267824ULL, 0x000fe200078e00ffULL, 0x00005f0019137a11ULL, 0x000fe200010f441cULL,
0x0000000428287824ULL, 0x000fe200078e00ffULL, 0x00005f0017157a11ULL, 0x000fc400018f441aULL,
0x00005f0008197a11ULL, 0x000fe400008f4409ULL, 0x00005f000c177a11ULL, 0x000fe400020f440dULL,
0x0000003800087811ULL, 0x040fe400078ff0ffULL, 0x00000003ff0d7819ULL, 0x000fe40000011600ULL,
0x0000000300707812ULL, 0x000fe200078ec0ffULL, 0x00000001081b7824ULL, 0x040fe200078e026fULL,
0x000000000d097212ULL, 0x000fe200078e3cffULL, 0x0000000408087824ULL, 0x000fe200078e00ffULL,
0x00002000620c7811ULL, 0x000fc400078e68ffULL, 0x0000000309097812ULL, 0x000fe400078ec0ffULL,
0x0000001b6c1b7210ULL, 0x000fe40007f3e0ffULL, 0x00000004702b7812ULL, 0x000fe400078efcffULL,
0x0ffffffc096d7812ULL, 0x000fe400078ef800ULL, 0xfffffffc1e1d7812ULL, 0x000fe200078ee209ULL,
0x000000102b107825ULL, 0x000fe200078e0010ULL, 0xfffffffc08297812ULL, 0x000fc400078ee209ULL,
0xfffffffc201f7812ULL, 0x100fe200078ee209ULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0xfffffffc22217812ULL, 0x100fe200078ee209ULL, 0x000000106d2d7824ULL, 0x100fe200078e020cULL,
0x00005e001b1a7a11ULL, 0x000fe200078240ffULL, 0x000000101d1d7824ULL, 0x000fe200078e020cULL,
0xfffffffc24237812ULL, 0x000fe200078ee209ULL, 0x000000102b0e7825ULL, 0x000fe200078e000eULL,
0xfffffffc26257812ULL, 0x100fe200078ee209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000102d7faeULL, 0x0003e2000b901c46ULL, 0xfffffffc28277812ULL, 0x000fe200078ee209ULL,
0x000000101f1f7824ULL, 0x000fe200078e020cULL, 0x00005f001b1b7a11ULL, 0x000fe200008f4408ULL,
0x000000102b0a7825ULL, 0x000fe200078e000aULL, 0x000000000e1d7faeULL, 0x0003e6000b901c46ULL,
0x0000001021217824ULL, 0x000fe200078e020cULL, 0x000000000a1f7faeULL, 0x0003e2000b901c46ULL,
0x000000102b127825ULL, 0x000fc800078e0012ULL, 0x0000001023237824ULL, 0x000fe200078e020cULL,
0x0000000012217faeULL, 0x0003e2000b901c46ULL, 0x000000102b147825ULL, 0x000fc800078e0014ULL,
0x0000001025257824ULL, 0x000fe200078e020cULL, 0x0000000014237faeULL, 0x0003e2000b901c46ULL,
0x000000102b167825ULL, 0x000fc800078e0016ULL, 0x0000001027277824ULL, 0x000fe200078e020cULL,
0x0000000016257faeULL, 0x0003e2000b901c46ULL, 0x000000102b187825ULL, 0x000fc800078e0018ULL,
0x0000001029297824ULL, 0x000fe200078e020cULL, 0x0000000018277faeULL, 0x0003e2000b901c46ULL,
0x000000102b1a7825ULL, 0x000fca00078e001aULL, 0x000000001a297faeULL, 0x0003e4000b901c46ULL,
0x00000004ff087819ULL, 0x000fe20000011600ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000007000b7812ULL, 0x002fe200078ec0ffULL, 0x0000200062727824ULL, 0x000fe200078e00ffULL,
0x0000000208207810ULL, 0x040fe20007ffe0ffULL, 0x00000008080c7824ULL, 0x000fc600078e00ffULL,
0x0000100072547810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80c0c7812ULL, 0x000fe400078ee20bULL,
0x000000080b0b7812ULL, 0x000fe400078ef800ULL, 0x000000100c0f7810ULL, 0x040fe20007ffe0ffULL,
0x000000040c147824ULL, 0x040fe200078e00ffULL, 0x000000200c107810ULL, 0x040fe40007ffe0ffULL,
0x000000300c117810ULL, 0x000fe20007ffe0ffULL, 0x000000040f167824ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe2000001160cULL, 0x00000004101a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe2000001160fULL, 0x00000004111e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fe20000011610ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000001ff107819ULL, 0x000fe20000011611ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000030e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000030c0c7812ULL, 0x000fe400078ec0ffULL,
0x000000030f187812ULL, 0x000fe400078ec0ffULL, 0x00000003101c7812ULL, 0x000fe400078ec0ffULL,
0x00000007080a7812ULL, 0x000fc400078e780bULL, 0x000000010e477812ULL, 0x100fe400078e780dULL,
0x000000010c417812ULL, 0x100fe200078e780dULL, 0x000000100b0a7824ULL, 0x000fe200078e020aULL,
0x0000000118437812ULL, 0x100fe400078e780dULL, 0x000000011c457812ULL, 0x000fe200078e780dULL,
0x000000100a0a7824ULL, 0x000fe200078e00ffULL, 0x0000001447477212ULL, 0x000fe400078efcffULL,
0x0000001641417212ULL, 0x000fc400078efcffULL, 0x0000001a43437212ULL, 0x000fe200078efcffULL,
0x00000010476e7824ULL, 0x100fe200078e0254ULL, 0x0000001e45457212ULL, 0x000fe200078efcffULL,
0x00000010416b7824ULL, 0x100fe200078e0254ULL, 0x000000000a10783bULL, 0x000fe20000000200ULL,
0x00000010436a7824ULL, 0x100fe200078e0254ULL, 0x000000010d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000001045697824ULL, 0x000fe200078e0254ULL, 0x000000006e34783bULL, 0x000e640000000200ULL,
0x000000020e737812ULL, 0x000fc400078e1e0dULL, 0x000000006b30783bULL, 0x000ea20000000200ULL,
0x00000007200e7812ULL, 0x000fe400078e780bULL, 0x000000020c3f7812ULL, 0x100fe200078e1e0dULL,
0x000000006a2c783bULL, 0x000ee20000000200ULL, 0x00000002183d7812ULL, 0x100fe200078e1e0dULL,
0x000000100b0e7824ULL, 0x000fe200078e020eULL, 0x000000021c717812ULL, 0x000fe200078e1e0dULL,
0x000000006938783bULL, 0x000f220000000200ULL, 0x0000001473737212ULL, 0x000fe200078efcffULL,
0x000000100e247824ULL, 0x000fe200078e00ffULL, 0x000000163f3f7212ULL, 0x000fc400078efcffULL,
0x0000001a3d3d7212ULL, 0x000fe200078efcffULL, 0x0000001073687824ULL, 0x100fe200078e0254ULL,
0x0000001e71717212ULL, 0x000fe200078efcffULL, 0x000000103f677824ULL, 0x100fe200078e0254ULL,
0x000000002424783bULL, 0x000fe20000000200ULL, 0x000000103d667824ULL, 0x100fe400078e0254ULL,
0x0000001071657824ULL, 0x000fe200078e0254ULL, 0x000000006858783bULL, 0x000f680000000200ULL,
0x000000006714783bULL, 0x000f280000000200ULL, 0x00000000661c783bULL, 0x000f280000000200ULL,
0x00000000650c783bULL, 0x000f220000000200ULL, 0x000000341028723cULL, 0x042ff000000018ffULL,
0x000000301050723cULL, 0x044ff000000018ffULL, 0x0000002c1018723cULL, 0x048ff000000018ffULL,
0x000000361034723cULL, 0x040ff000000018ffULL, 0x000000321030723cULL, 0x040ff000000018ffULL,
0x0000002e102c723cULL, 0x040ff000000018ffULL, 0x000000381020723cULL, 0x050ff000000018ffULL,
0x0000003a1010723cULL, 0x000ff000000018ffULL, 0x000000582428723cULL, 0x060ff00000001828ULL,
0x000000142450723cULL, 0x040ff00000001850ULL, 0x0000001c2418723cULL, 0x040ff00000001818ULL,
0x0000005a2458723cULL, 0x040ff00000001834ULL, 0x000000162414723cULL, 0x040ff00000001830ULL,
0x0000001e241c723cULL, 0x040ff0000000182cULL, 0x0000000c2420723cULL, 0x040ff00000001820ULL,
0x0000000e2424723cULL, 0x000fe20000001810ULL, 0x0000064000008947ULL, 0x000fee0003800000ULL,
0x00000002ff127819ULL, 0x000fc80000011600ULL, 0x0000000812137810ULL, 0x040fe20007ffe0ffULL,
0x00000001120d7824ULL, 0x140fe200078e026fULL, 0x0000001012367810ULL, 0x040fe40007ffe0ffULL,
0x0000001812387810ULL, 0x000fe20007ffe0ffULL, 0x00000001130f7824ULL, 0x100fe200078e026fULL,
0x0000000d6c0d7210ULL, 0x000fe20007f5e0ffULL, 0x0000000136117824ULL, 0x100fe200078e026fULL,
0x00000020123a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001382d7824ULL, 0x000fe200078e026fULL,
0x0000000f6c0f7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200010e06ffULL,
0x000000116c2f7210ULL, 0x000fc40007f9e0ffULL, 0x0000002d6c317210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200018e06ffULL, 0x00005e000d2c7a11ULL, 0x000fe200078440ffULL,
0x000000ffff307224ULL, 0x000fe200020e06ffULL, 0x00005e000f107a11ULL, 0x000fe200078640ffULL,
0x000000ffff327224ULL, 0x000fe200008e06ffULL, 0x00005e002f0e7a11ULL, 0x000fe400078840ffULL,
0x00005e00310c7a11ULL, 0x000fe400078240ffULL, 0x00000028123c7810ULL, 0x000fc40007ffe0ffULL,
0x00005f000d2d7a11ULL, 0x000fe200010f440aULL, 0x00000001600a7824ULL, 0x000fe200078e0a07ULL,
0x00005f000f117a11ULL, 0x000fe400018f442eULL, 0x00005f002f0f7a11ULL, 0x000fe200020f4430ULL,
0x000000013a2f7824ULL, 0x100fe200078e026fULL, 0x00005f00310d7a11ULL, 0x000fe200008f4432ULL,
0x000000013c317824ULL, 0x000fe200078e026fULL, 0x00000030123e7810ULL, 0x000fe40007ffe0ffULL,
0x0000002f6c2f7210ULL, 0x000fc40007f5e0ffULL, 0x000000316c317210ULL, 0x000fe20007f7e0ffULL,
0x000000013e337824ULL, 0x100fe200078e026fULL, 0x0000003812427810ULL, 0x040fe40007ffe0ffULL,
0x0000000a1200720cULL, 0x000fe20003f26070ULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x00005e002f327a11ULL, 0x000fe200078440ffULL, 0x000000ffff347224ULL, 0x000fe200018e06ffULL,
0x00005e0031307a11ULL, 0x000fe200078640ffULL, 0x0000000142377824ULL, 0x000fe200078e026fULL,
0x000000336c357210ULL, 0x000fc40007f9e0ffULL, 0x00005f002f337a11ULL, 0x000fe400010f4412ULL,
0x00005f0031317a11ULL, 0x000fe200018f4434ULL, 0x0000000413347824ULL, 0x040fe200078e00ffULL,
0x000000376c127210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff407224ULL, 0x000fe200020e06ffULL,
0x0000000870377812ULL, 0x000fe400078efcffULL, 0x0000000a1300720cULL, 0x000fe20003f46070ULL,
0x000000106d137824ULL, 0x000fe200078e0254ULL, 0xfffffffc34397812ULL, 0x000fe200078ee209ULL,
0x00000010372c7825ULL, 0x000fe200078e002cULL, 0x00005e00352e7a11ULL, 0x000fc400078840ffULL,
0x0000000a3e00720cULL, 0x080fe20003fa6070ULL, 0x0000001039397824ULL, 0x000fe200078e0254ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c137faeULL, 0x0003e2000c901c46ULL,
0x00005f00352f7a11ULL, 0x000fe200020f4440ULL, 0x0000001037107825ULL, 0x000fe200078e0010ULL,
0x0000000a3600720cULL, 0x080fe40003f26070ULL, 0x0000000a3c00720cULL, 0x080fe20003f86070ULL,
0x000000ffff357224ULL, 0x000fe200018e06ffULL, 0x00005e0012347a11ULL, 0x000fe200078640ffULL,
0x0000000436367824ULL, 0x000fe200078e00ffULL, 0x0000000010397faeULL, 0x0005e2000d101c46ULL,
0x0000000a3800720cULL, 0x0c0fe20003f46070ULL, 0x0000000438387824ULL, 0x000fe200078e00ffULL,
0x00005f0012357a11ULL, 0x000fe200018f4435ULL, 0x000000043c3c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc363b7812ULL, 0x000fe200078ee209ULL, 0x000000043e3e7824ULL, 0x000fe200078e00ffULL,
0x0000000a3a00720cULL, 0x0c0fe20003f66070ULL, 0x000000043a3a7824ULL, 0x000fe200078e00ffULL,
0x0000000a4200720cULL, 0x000fe20003fc6070ULL, 0x000000103b3b7824ULL, 0x000fc400078e0254ULL,
0x00000010370e7825ULL, 0x040fe200078e000eULL, 0xfffffffc38117812ULL, 0x104fe400078ee209ULL,
0xfffffffc3a2d7812ULL, 0x102fe200078ee209ULL, 0x0000000442427824ULL, 0x000fe200078e00ffULL,
0xfffffffc3e397812ULL, 0x000fe200078ee209ULL, 0x00000010370c7825ULL, 0x040fe200078e000cULL,
0x000000000e3b7faeULL, 0x0003e4000c901c46ULL, 0xfffffffc42497812ULL, 0x000fe200078ee209ULL,
0x0000001037327825ULL, 0x000fc800078e0032ULL, 0x0000001037307825ULL, 0x000fc800078e0030ULL,
0x00000010372e7825ULL, 0x000fc800078e002eULL, 0x0000001037347825ULL, 0x000fe200078e0034ULL,
0xfffffffc3c377812ULL, 0x000fc600078ee209ULL, 0x00000010110f7824ULL, 0x102fe400078e0254ULL,
0x000000102d117824ULL, 0x100fe400078e0254ULL, 0x00000010372d7824ULL, 0x100fe200078e0254ULL,
0x000000000c0f7faeULL, 0x0003e2000d101c46ULL, 0x0000001039377824ULL, 0x100fe400078e0254ULL,
0x0000001049397824ULL, 0x000fe200078e0254ULL, 0x0000000032117faeULL, 0x0003e8000d901c46ULL,
0x00000000302d7faeULL, 0x0003e8000e101c46ULL, 0x000000002e377faeULL, 0x0003e8000e901c46ULL,
0x0000000034397faeULL, 0x0003e2000f101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000000800127811ULL, 0x040fe400078ff0ffULL, 0x0000006f000d7211ULL, 0x000fc400078ff0ffULL,
0x0000001000327811ULL, 0x000fe200078ff0ffULL, 0x00000001120f7824ULL, 0x100fe200078e026fULL,
0x0000000d6c0d7210ULL, 0x000fe20007f3e0ffULL, 0x0000000412407824ULL, 0x000fe200078e00ffULL,
0x0000001800367811ULL, 0x000fe200078ff0ffULL, 0x0000000432427824ULL, 0x000fe200078e00ffULL,
0x0000000f6c0f7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e000d2c7a11ULL, 0x000fe200078240ffULL, 0x0000000136117824ULL, 0x100fe200078e026fULL,
0x0000002000387811ULL, 0x000fe200078ff0ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0x00005e000f0c7a11ULL, 0x000fe200078440ffULL, 0x0000000436367824ULL, 0x000fe200078e00ffULL,
0x00005f000d2d7a11ULL, 0x000fe200008f440aULL, 0x00000001382f7824ULL, 0x100fe200078e026fULL,
0x00005f000f0d7a11ULL, 0x000fe200010f440eULL, 0x00000001320f7824ULL, 0x000fe200078e026fULL,
0x00000028003a7811ULL, 0x000fe200078ff0ffULL, 0x0000000438387824ULL, 0x000fe200078e00ffULL,
0x000000116c137210ULL, 0x000fc40007f5e0ffULL, 0x0000000f6c0f7210ULL, 0x000fe20007f3e0ffULL,
0x000000013a317824ULL, 0x000fe200078e026fULL, 0x0000002f6c2f7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x00005e00130e7a11ULL, 0x000fe200078440ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x00005e000f107a11ULL, 0x040fe200078240ffULL,
0x000000043a3a7824ULL, 0x000fe200078e00ffULL, 0x000000316c337210ULL, 0x000fe40007f9e0ffULL,
0x00005f000f117a11ULL, 0x000fe200008f440aULL, 0x000000ffff0a7224ULL, 0x000fe200018e06ffULL,
0x00005f00130f7a11ULL, 0x000fe200010f442eULL, 0x000000ffff347224ULL, 0x000fe200020e06ffULL,
0x00005e002f307a11ULL, 0x000fe200078240ffULL, 0x000000106d137824ULL, 0x000fe200078e0254ULL,
0x00005e00332e7a11ULL, 0x000fc400078440ffULL, 0x00000030003c7811ULL, 0x040fe400078ff0ffULL,
0x00000038003e7811ULL, 0x000fe400078ff0ffULL, 0x00005f002f317a11ULL, 0x000fe400008f440aULL,
0x00005f00332f7a11ULL, 0x000fe200010f4434ULL, 0x000000013c337824ULL, 0x100fe200078e026fULL,
0x00000008703b7812ULL, 0x000fe200078efcffULL, 0x000000013e357824ULL, 0x000fe200078e026fULL,
0xfffffffc40377812ULL, 0x000fe200078ee209ULL, 0x000000043c3c7824ULL, 0x000fe200078e00ffULL,
0x000000336c337210ULL, 0x040fe20007f3e0ffULL, 0x000000103b2c7825ULL, 0x000fe200078e002cULL,
0x000000356c127210ULL, 0x000fc40007f5e0ffULL, 0xfffffffc42397812ULL, 0x000fe200078ee209ULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x00005e0033347a11ULL, 0x040fe200078240ffULL,
0x000000ffff497224ULL, 0x000fe200010e06ffULL, 0x00005e0012327a11ULL, 0x040fe200078440ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c137faeULL, 0x0003e2000b901c46ULL,
0x00005f0033357a11ULL, 0x000fe200008f440aULL, 0x0000001037377824ULL, 0x000fe200078e0254ULL,
0x00005f0012337a11ULL, 0x000fe200010f4449ULL, 0x000000103b0c7825ULL, 0x000fe200078e000cULL,
0xfffffffc3a497812ULL, 0x000fc400078ee209ULL, 0xfffffffc3c4b7812ULL, 0x000fe200078ee209ULL,
0x000000043e3e7824ULL, 0x000fe200078e00ffULL, 0x000000000c377faeULL, 0x0005e2000b901c46ULL,
0x0000001039397824ULL, 0x000fe400078e0254ULL, 0x000000103b107825ULL, 0x040fe200078e0010ULL,
0xfffffffc362d7812ULL, 0x102fe400078ee209ULL, 0xfffffffc3e4d7812ULL, 0x000fe200078ee209ULL,
0x000000103b0e7825ULL, 0x040fe200078e000eULL, 0x0000000010397faeULL, 0x0003e6000b901c46ULL,
0x000000103b307825ULL, 0x000fc800078e0030ULL, 0x000000103b2e7825ULL, 0x000fc800078e002eULL,
0x000000103b347825ULL, 0x000fc800078e0034ULL, 0x000000103b327825ULL, 0x000fe200078e0032ULL,
0xfffffffc383b7812ULL, 0x000fc600078ee209ULL, 0x000000102d0d7824ULL, 0x104fe400078e0254ULL,
0x000000103b117824ULL, 0x102fe400078e0254ULL, 0x00000010492d7824ULL, 0x100fe200078e0254ULL,
0x000000000e0d7faeULL, 0x0003e2000b901c46ULL, 0x000000104b377824ULL, 0x100fe400078e0254ULL,
0x000000104d397824ULL, 0x000fe200078e0254ULL, 0x0000000030117faeULL, 0x0003e8000b901c46ULL,
0x000000002e2d7faeULL, 0x0003e8000b901c46ULL, 0x0000000034377faeULL, 0x0003e8000b901c46ULL,
0x0000000032397faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000004080a7810ULL, 0x000fc40007ffe0ffULL, 0x0000200072727810ULL, 0x000fe40007ffe0ffULL,
0x000000070a0a7812ULL, 0x100fe400078e780bULL, 0x00000006080e7810ULL, 0x002fe20007ffe0ffULL,
0x0000001047127824ULL, 0x000fe400078e0272ULL, 0x000000100b0a7824ULL, 0x000fe200078e020aULL,
0x000000070e0e7812ULL, 0x000fe200078e780bULL, 0x00000010430c7824ULL, 0x000fe400078e0272ULL,
0x000000100a407824ULL, 0x000fc400078e00ffULL, 0x00000010410a7824ULL, 0x100fe400078e0272ULL,
0x00000010450d7824ULL, 0x000fe400078e0272ULL, 0x000000100b0f7824ULL, 0x000fe400078e020eULL,
0x00000010730e7824ULL, 0x000fe200078e0272ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000000125c783bULL, 0x000fe20000000200ULL, 0x000000100f2c7824ULL, 0x000fe400078e00ffULL,
0x000000103f0f7824ULL, 0x100fe200078e0272ULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x000000103d107824ULL, 0x100fe400078e0272ULL, 0x0000001071117824ULL, 0x000fe200078e0272ULL,
0x000000000a4c783bULL, 0x000ea80000000200ULL, 0x000000000c48783bULL, 0x000ee80000000200ULL,
0x000000000d44783bULL, 0x000f280000000200ULL, 0x000000000e3c783bULL, 0x000fe80000000200ULL,
0x000000002c2c783bULL, 0x000f680000000200ULL, 0x000000000f38783bULL, 0x000ee80000000200ULL,
0x000000001034783bULL, 0x000ee80000000200ULL, 0x000000001130783bULL, 0x000ee20000000200ULL,
0x0000005c4028723cULL, 0x042ff00000001828ULL, 0x0000005e4058723cULL, 0x040ff00000001858ULL,
0x0000004c4050723cULL, 0x044ff00000001850ULL, 0x0000004e4014723cULL, 0x040ff00000001814ULL,
0x000000484018723cULL, 0x048ff00000001818ULL, 0x0000004a401c723cULL, 0x040ff0000000181cULL,
0x000000444020723cULL, 0x050ff00000001820ULL, 0x000000464024723cULL, 0x000ff00000001824ULL,
0x0000003c2c28723cULL, 0x060ff00000001828ULL, 0x0000003e2c58723cULL, 0x040ff00000001858ULL,
0x000000382c50723cULL, 0x040ff00000001850ULL, 0x0000003a2c14723cULL, 0x040ff00000001814ULL,
0x000000342c18723cULL, 0x040ff00000001818ULL, 0x000000362c1c723cULL, 0x040ff0000000181cULL,
0x000000302c20723cULL, 0x040ff00000001820ULL, 0x000000322c2c723cULL, 0x000fe20000001824ULL,
0x0000064000008947ULL, 0x000fee0003800000ULL, 0x00000002ff307819ULL, 0x000fe20000011600ULL,
0x00000001603c7824ULL, 0x000fe200078e0a07ULL, 0x0000000c703d7812ULL, 0x000fe200078efcffULL,
0x000000106d6d7824ULL, 0x000fe200078e0272ULL, 0x00000010303f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000130257824ULL, 0x040fe200078e026fULL, 0x00000008303e7810ULL, 0x000fc40007ffe0ffULL,
0x0000001830407810ULL, 0x000fe20007ffe0ffULL, 0x000000013f317824ULL, 0x100fe200078e026fULL,
0x000000256c257210ULL, 0x000fe20007f1e0ffULL, 0x000000013e277824ULL, 0x100fe200078e026fULL,
0x0000002030417810ULL, 0x000fe40007ffe0ffULL, 0x000000316c317210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x000000276c277210ULL, 0x000fe20007f3e0ffULL,
0x0000000141337824ULL, 0x000fe200078e026fULL, 0x00005e0025387a11ULL, 0x000fe200078040ffULL,
0x000000ffff367224ULL, 0x000fe200010e06ffULL, 0x00005e0031247a11ULL, 0x000fe200078440ffULL,
0x000000ffff347224ULL, 0x000fe200008e06ffULL, 0x00005f0025397a11ULL, 0x000fc400000f4432ULL,
0x00005f0031257a11ULL, 0x000fe200010f4436ULL, 0x0000000140317824ULL, 0x000fe200078e026fULL,
0x00005e0027267a11ULL, 0x000fe200078240ffULL, 0x000000103d387825ULL, 0x040fe200078e0038ULL,
0x0000002830437810ULL, 0x040fe40007ffe0ffULL, 0x0000003030457810ULL, 0x040fe20007ffe0ffULL,
0x000000103d247825ULL, 0x000fe200078e0024ULL, 0x0000003830477810ULL, 0x000fe40007ffe0ffULL,
0x00005f0027277a11ULL, 0x000fe200008f4434ULL, 0x0000000143377824ULL, 0x100fe200078e026fULL,
0x000000316c317210ULL, 0x000fe20007f3e0ffULL, 0x00000001453b7824ULL, 0x100fe200078e026fULL,
0x0000003c3000720cULL, 0x000fe20003f06070ULL, 0x00000001476f7824ULL, 0x000fe200078e026fULL,
0x000000336c357210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff307224ULL, 0x000fe200008e06ffULL,
0x00005e0031327a11ULL, 0x000fe200078640ffULL, 0x000000103d267825ULL, 0x000fe200078e0026ULL,
0x0000003b6c467210ULL, 0x000fc40007f5e0ffULL, 0x0000006f6c6f7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff427224ULL, 0x000fe200020e06ffULL, 0x000000376c377210ULL, 0x000fe40007fbe0ffULL,
0x00005f0031337a11ULL, 0x000fe200018f4430ULL, 0x000000ffff317224ULL, 0x000fe200010e06ffULL,
0x00005e00353a7a11ULL, 0x000fe200078640ffULL, 0x000000ffff487224ULL, 0x000fe200008e06ffULL,
0x00005e0046347a11ULL, 0x000fe200078240ffULL, 0x000000ffff447224ULL, 0x000fe200028e06ffULL,
0x00005e0037367a11ULL, 0x000fe200078840ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000386d7faeULL, 0x0003e2000c101c46ULL, 0x00005e006f307a11ULL, 0x000fe200078440ffULL,
0x000000103d327825ULL, 0x000fe200078e0032ULL, 0x00005f00353b7a11ULL, 0x000fc400018f4442ULL,
0x00005f0046357a11ULL, 0x000fe200008f4431ULL, 0x0000000443427824ULL, 0x000fe200078e00ffULL,
0x00005f0037377a11ULL, 0x000fe200020f4444ULL, 0x0000000445447824ULL, 0x000fe200078e00ffULL,
0x00005f006f317a11ULL, 0x000fe200010f4448ULL, 0x0000000447467824ULL, 0x000fe200078e00ffULL,
0x0000003c3e00720cULL, 0x0c0fe20003f06070ULL, 0x000000043e3e7824ULL, 0x000fe200078e00ffULL,
0x0000003c3f00720cULL, 0x080fe20003f26070ULL, 0x0000000441387824ULL, 0x042fe200078e00ffULL,
0x0000003c4000720cULL, 0x0c0fe20003f46070ULL, 0x0000000440407824ULL, 0x000fe200078e00ffULL,
0x0000003c4100720cULL, 0x080fe20003f66070ULL, 0x000000103d3a7825ULL, 0x000fe200078e003aULL,
0x0000003c4300720cULL, 0x000fc40003f86070ULL, 0x0000003c4500720cULL, 0x080fe20003fa6070ULL,
0x000000103d367825ULL, 0x000fe200078e0036ULL, 0x0000003c4700720cULL, 0x000fe40003fc6070ULL,
0xfffffffc3e397812ULL, 0x100fe200078ee209ULL, 0x000000043f3c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc40417812ULL, 0x000fe200078ee209ULL, 0x000000103d347825ULL, 0x000fe200078e0034ULL,
0xfffffffc38437812ULL, 0x100fe400078ee209ULL, 0xfffffffc3c3f7812ULL, 0x100fe200078ee209ULL,
0x0000001039397824ULL, 0x100fe200078e0272ULL, 0xfffffffc42457812ULL, 0x100fe200078ee209ULL,
0x0000001041417824ULL, 0x100fe200078e0272ULL, 0xfffffffc44477812ULL, 0x100fe200078ee209ULL,
0x000000103f3f7824ULL, 0x100fe200078e0272ULL, 0xfffffffc46497812ULL, 0x000fe200078ee209ULL,
0x0000001043437824ULL, 0x100fe200078e0272ULL, 0x0000000026397faeULL, 0x0003e2000c101c46ULL,
0x0000001045457824ULL, 0x000fc400078e0272ULL, 0x0000001047477824ULL, 0x100fe200078e0272ULL,
0x00000000243f7faeULL, 0x0003e2000c901c46ULL, 0x0000001049497824ULL, 0x000fe400078e0272ULL,
0x000000103d307825ULL, 0x000fe200078e0030ULL, 0x0000000032417faeULL, 0x0003e8000d101c46ULL,
0x000000003a437faeULL, 0x0003e8000d901c46ULL, 0x0000000036457faeULL, 0x0003e8000e101c46ULL,
0x0000000034477faeULL, 0x0003e8000e901c46ULL, 0x0000000030497faeULL, 0x0003e2000f101c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000800307811ULL, 0x040fe200078ff0ffULL,
0x000000106d6d7824ULL, 0x000fe200078e0272ULL, 0x0000006f00257211ULL, 0x000fc400078ff0ffULL,
0x0000001000347811ULL, 0x000fe200078ff0ffULL, 0x0000000130277824ULL, 0x100fe200078e026fULL,
0x000000256c257210ULL, 0x000fe20007f1e0ffULL, 0x0000000430307824ULL, 0x000fe200078e00ffULL,
0x0000001800367811ULL, 0x000fe200078ff0ffULL, 0x0000000134317824ULL, 0x100fe200078e026fULL,
0x00000030003c7811ULL, 0x000fe200078ff0ffULL, 0x000000ffff267224ULL, 0x000fe200000e06ffULL,
0x000000276c277210ULL, 0x000fe20007f7e0ffULL, 0x0000000136337824ULL, 0x100fe200078e026fULL,
0x00005e0025247a11ULL, 0x040fe200078040ffULL, 0x0000000434347824ULL, 0x000fe200078e00ffULL,
0x0000002000387811ULL, 0x000fe200078ff0ffULL, 0x000000013c3d7824ULL, 0x100fe200078e026fULL,
0x00000028003a7811ULL, 0x040fe200078ff0ffULL, 0x000000ffff327224ULL, 0x000fe200018e06ffULL,
0x00000038003e7811ULL, 0x000fe200078ff0ffULL, 0x0000000436367824ULL, 0x000fe200078e00ffULL,
0x00005f0025257a11ULL, 0x000fe200000f4426ULL, 0x0000000138377824ULL, 0x100fe200078e026fULL,
0x000000316c317210ULL, 0x000fe20007f3e0ffULL, 0x000000013a397824ULL, 0x100fe200078e026fULL,
0x000000336c357210ULL, 0x000fe20007f1e0ffULL, 0x000000013e6f7824ULL, 0x000fe200078e026fULL,
0x00005e0027267a11ULL, 0x040fe200078c40ffULL, 0x000000043c3c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc343f7812ULL, 0x100fe200078ee209ULL, 0x000000ffff347224ULL, 0x000fe200008e06ffULL,
0x0000003d6c407210ULL, 0x000fe20007fbe0ffULL, 0x0000000438387824ULL, 0x000fe200078e00ffULL,
0x00005f0027277a11ULL, 0x000fe200030f4432ULL, 0x000000043e3e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc36417812ULL, 0x100fe200078ee209ULL, 0x000000ffff367224ULL, 0x000fe200000e06ffULL,
0x000000376c377210ULL, 0x000fe20007f5e0ffULL, 0x000000043a3a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc303d7812ULL, 0x000fe200078ee209ULL, 0x000000103f3f7824ULL, 0x100fe200078e0272ULL,
0x00005e0031327a11ULL, 0x000fe200078240ffULL, 0x0000001041417824ULL, 0x100fe200078e0272ULL,
0x000000396c3b7210ULL, 0x000fe20007f7e0ffULL, 0x000000103d3d7824ULL, 0x000fe200078e0272ULL,
0x00005e0035307a11ULL, 0x000fc400078040ffULL, 0x0000006f6c6f7210ULL, 0x000fe40007f9e0ffULL,
0xfffffffc3c477812ULL, 0x100fe200078ee209ULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x00005f0031337a11ULL, 0x000fe200008f4434ULL, 0x000000ffff427224ULL, 0x000fe200020e06ffULL,
0xfffffffc38437812ULL, 0x100fe200078ee209ULL, 0x0000001047477824ULL, 0x000fe200078e0272ULL,
0xfffffffc3e497812ULL, 0x100fe200078ee209ULL, 0x000000ffff3e7224ULL, 0x000fe200018e06ffULL,
0x00005f0035317a11ULL, 0x000fe200000f4436ULL, 0x000000ffff357224ULL, 0x000fe200028e06ffULL,
0xfffffffc3a457812ULL, 0x000fe200078ee209ULL, 0x0000001043437824ULL, 0x100fe200078e0272ULL,
0x0000000c704b7812ULL, 0x000fe200078efcffULL, 0x0000001049497824ULL, 0x100fe200078e0272ULL,
0x00005e0037387a11ULL, 0x000fe200078040ffULL, 0x0000001045457824ULL, 0x000fe200078e0272ULL,
0x00005e003b3a7a11ULL, 0x000fe200078240ffULL, 0x000000104b247825ULL, 0x000fe200078e0024ULL,
0x00005e0040367a11ULL, 0x000fc400078440ffULL, 0x00005e006f347a11ULL, 0x000fe200078640ffULL,
0x000000104b267825ULL, 0x000fe200078e0026ULL, 0x00005f0037397a11ULL, 0x000fe200000f443cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000246d7faeULL, 0x0003e2000b901c46ULL,
0x00005f003b3b7a11ULL, 0x000fe200008f443eULL, 0x000000104b327825ULL, 0x000fe200078e0032ULL,
0x00005f0040377a11ULL, 0x000fe200010f4435ULL, 0x00000000263d7faeULL, 0x0003e2000b901c46ULL,
0x00005f006f357a11ULL, 0x000fe200018f4442ULL, 0x000000104b307825ULL, 0x040fe400078e0030ULL,
0x00000000323f7faeULL, 0x0003e4000b901c46ULL, 0x000000104b387825ULL, 0x000fc400078e0038ULL,
0x0000000030417faeULL, 0x0003e4000b901c46ULL, 0x000000104b3a7825ULL, 0x040fe400078e003aULL,
0x0000000038437faeULL, 0x0003e4000b901c46ULL, 0x000000104b367825ULL, 0x040fe400078e0036ULL,
0x000000003a457faeULL, 0x0003e4000b901c46ULL, 0x000000104b347825ULL, 0x000fc400078e0034ULL,
0x0000000036477faeULL, 0x0003e8000b901c46ULL, 0x0000000034497faeULL, 0x0003e4000b901c46ULL,
0x00000300ff257624ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff6c7424ULL, 0x000fe400078e00ffULL, 0x0000000225027824ULL, 0x000fca00078e0202ULL,
0x000000610200720cULL, 0x000fda0003f06070ULL, 0x0000000263308824ULL, 0x000fe400078e0202ULL,
0x00000004ff318424ULL, 0x000fe200078e00ffULL, 0x0000000808247810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000600030308625ULL, 0x000fe200078e0031ULL,
0x0000000724247812ULL, 0x000fe200078e780bULL, 0x000000006b5c783bULL, 0x000fe80000000200ULL,
0x00000006306c8981ULL, 0x0002a2000c1e1900ULL, 0x000000100b247824ULL, 0x000fc600078e0224ULL,
0x000000006a4c783bULL, 0x000fe20000000200ULL, 0x0000001024447824ULL, 0x000fc600078e00ffULL,
0x000000006e24783bULL, 0x000fe20000000200ULL, 0x0000000a08307810ULL, 0x002fc60007ffe0ffULL,
0x000000004444783bULL, 0x000e620000000200ULL, 0x0000000730307812ULL, 0x000fc600078e780bULL,
0x000000006948783bULL, 0x000ee40000000200ULL, 0x000000100b307824ULL, 0x000fe400078e0230ULL,
0x000000006840783bULL, 0x000fe40000000200ULL, 0x0000001030307824ULL, 0x000fe400078e00ffULL,
0x00000000673c783bULL, 0x000fe80000000200ULL, 0x000000006638783bULL, 0x000fe80000000200ULL,
0x000000003030783bULL, 0x000f280000000200ULL, 0x000000006534783bULL, 0x000f620000000200ULL,
0x000000244428723cULL, 0x042ff00000001828ULL, 0x000000264458723cULL, 0x040ff00000001858ULL,
0x0000005c4450723cULL, 0x040fee0000001850ULL, 0x00000300645c7a10ULL, 0x000fe20007ffe0ffULL,
0x0000005e4414723cULL, 0x000fe60000001814ULL, 0x000000015c247810ULL, 0x040fe20007ffe0ffULL,
0x000001005c277824ULL, 0x000fc600078e0203ULL, 0x000000572400720cULL, 0x000fe20003f06070ULL,
0x0000004c4418723cULL, 0x000fe20000001818ULL, 0x0000004027257812ULL, 0x000fce00078ec0ffULL,
0x0000004e441c723cULL, 0x040ff0000000181cULL, 0x000000484420723cULL, 0x048ff00000001820ULL,
0x0000004a442c723cULL, 0x000ff0000000182cULL, 0x000000403028723cULL, 0x050ff00000001828ULL,
0x000000423058723cULL, 0x040ff00000001858ULL, 0x0000003c3050723cULL, 0x040ff00000001850ULL,
0x0000003e3014723cULL, 0x040ff00000001814ULL, 0x000000383018723cULL, 0x040fee0000001818ULL,
0x0000000104397824ULL, 0x000fe200078e0225ULL, 0x0000003a301c723cULL, 0x040ff0000000181cULL,
0x000000343020723cULL, 0x060ff00000001820ULL, 0x00000036302c723cULL, 0x000fe2000000182cULL,
0x000000056c3a7224ULL, 0x004fe200078e02ffULL, 0x000006d000008947ULL, 0x000fec0003800000ULL,
0x00000002ff3b7819ULL, 0x000fe20000011600ULL, 0x00000010003c7824ULL, 0x000fe200078e00ffULL,
0x0000002760247217ULL, 0x000fc40007800000ULL, 0x000000083b3e7810ULL, 0x040fe20007ffe0ffULL,
0x000000013b257824ULL, 0x040fe200078e0239ULL, 0x000000103b3f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000124327824ULL, 0x000fe200078e0a27ULL, 0x000000183b407810ULL, 0x000fe20007ffe0ffULL,
0x000000013e247824ULL, 0x100fe200078e0239ULL, 0x000000253a387210ULL, 0x000fe20007f1e0ffULL,
0x000000013f257824ULL, 0x100fe200078e0239ULL, 0x000000303c3d7812ULL, 0x000fe200078ec0ffULL,
0x0000000140267824ULL, 0x000fe200078e0239ULL, 0x000000243a337210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff277224ULL, 0x000fe200000e06ffULL, 0x000000253a257210ULL, 0x000fc40007f5e0ffULL,
0x00005e0038377a11ULL, 0x000fe200078040ffULL, 0x000000ffff367224ULL, 0x000fe200008e06ffULL,
0x000000263a267210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff247224ULL, 0x000fe200010e06ffULL,
0x00005f0038387a11ULL, 0x000fe400000f4427ULL, 0x00005e0025307a11ULL, 0x000fe200078240ffULL,
0x000000ffff357224ULL, 0x000fe200018e06ffULL, 0x00005e0033277a11ULL, 0x000fe400078040ffULL,
0x00005f0025317a11ULL, 0x000fc400008f4424ULL, 0x00005e0026347a11ULL, 0x040fe400078440ffULL,
0x00005f0033337a11ULL, 0x000fe200000f4436ULL, 0x000000043f367824ULL, 0x000fe200078e00ffULL,
0x0000003d37247210ULL, 0x000fe40007f7e0ffULL, 0x000000323b00720cULL, 0x080fe40003f06070ULL,
0x00005f0026357a11ULL, 0x000fe200010f4435ULL, 0x000000ffff257224ULL, 0x000fe200018e0638ULL,
0x000000323e00720cULL, 0x0c0fe20003f26070ULL, 0x000000043e3e7824ULL, 0x000fe200078e00ffULL,
0x000000323f00720cULL, 0x000fc40003f46070ULL, 0x0000003d27267210ULL, 0x080fe40007f7e0ffULL,
0xfffffffc363f7812ULL, 0x000fe400078ee209ULL, 0x000000203b367810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff277224ULL, 0x000fe200018e0633ULL, 0xfffffffc3e377812ULL, 0x000fe200078ee209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024137faeULL, 0x0003e2000c101c46ULL,
0x0000003d30307210ULL, 0x000fe20007f9e0ffULL, 0x0000000136337824ULL, 0x000fe200078e0239ULL,
0x000000283b387810ULL, 0x000fe20007ffe0ffULL, 0x0000001037377824ULL, 0x100fe200078e0254ULL,
0x000000303b3c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff317224ULL, 0x000fe200020e0631ULL,
0x000000324000720cULL, 0x000fe20003f86070ULL, 0x000000103f3f7824ULL, 0x000fe200078e0254ULL,
0x000000333a337210ULL, 0x000fe20007f1e0ffULL, 0x0000000440407824ULL, 0x000fe200078e00ffULL,
0x0000000026377faeULL, 0x0005e2000c901c46ULL, 0x000000383b3b7810ULL, 0x000fc40007ffe0ffULL,
0x0000003d34247210ULL, 0x002fe20007fbe0ffULL, 0x00000000303f7faeULL, 0x0003e2000d101c46ULL,
0xfffffffc40137812ULL, 0x000fe400078ee209ULL, 0x000000323600720cULL, 0x080fe20003f66070ULL,
0x000000ffff257224ULL, 0x000fe200028e0635ULL, 0x000000323800720cULL, 0x080fe20003f46070ULL,
0x0000000436367824ULL, 0x000fe200078e00ffULL, 0x000000323c00720cULL, 0x080fe20003f26070ULL,
0x000000ffff267224ULL, 0x004fe200000e06ffULL, 0x000000323b00720cULL, 0x040fe20003f06070ULL,
0x000000013b277824ULL, 0x000fe200078e0239ULL, 0xfffffffc36357812ULL, 0x000fc400078ee209ULL,
0x00005e0033307a11ULL, 0x002fc600078c40ffULL, 0x0000001035357824ULL, 0x000fe200078e0254ULL,
0x00005f0033327a11ULL, 0x000fe200030f4426ULL, 0x0000001013337824ULL, 0x100fe200078e0254ULL,
0x000000273a277210ULL, 0x000fe20007fde0ffULL, 0x0000000138137824ULL, 0x100fe400078e0239ULL,
0x000000013c267824ULL, 0x000fe200078e0239ULL, 0x0000000024337faeULL, 0x0003e2000e101c46ULL,
0x0000000438387824ULL, 0x000fe200078e00ffULL, 0x000000133a317210ULL, 0x000fe20007fbe0ffULL,
0x000000043c3c7824ULL, 0x000fe200078e00ffULL, 0x000000263a137210ULL, 0x000fe20007f9e0ffULL,
0x000000043b267824ULL, 0x000fe200078e00ffULL, 0xfffffffc38377812ULL, 0x100fe200078ee209ULL,
0x000000ffff347224ULL, 0x000fe200030e06ffULL, 0xfffffffc3c397812ULL, 0x100fe200078ee209ULL,
0x000000ffff367224ULL, 0x000fe200020e06ffULL, 0xfffffffc26097812ULL, 0x000fe200078ee209ULL,
0x0000001037377824ULL, 0x000fc400078e0254ULL, 0x000000ffff247224ULL, 0x002fe200028e06ffULL,
0x00005e0031267a11ULL, 0x000fe200078a40ffULL, 0x00000010093b7824ULL, 0x100fe400078e0254ULL,
0x0000001039397824ULL, 0x000fe200078e0254ULL, 0x00005f0031317a11ULL, 0x000fe400028f4424ULL,
0x0000003d30247210ULL, 0x000fe40007fbe0ffULL, 0x00005e0013307a11ULL, 0x000fc600078840ffULL,
0x000000ffff257224ULL, 0x000fe200028e0632ULL, 0x00005e0027327a11ULL, 0x000fe400078c40ffULL,
0x0000003d26267210ULL, 0x080fe40007fbe0ffULL, 0x00005f0013137a11ULL, 0x000fe200020f4436ULL,
0x0000000024357faeULL, 0x0003e2000d901c46ULL, 0x00005f0027097a11ULL, 0x000fe200030f4434ULL,
0x000000ffff277224ULL, 0x000fe200028e0631ULL, 0x0000003d30307210ULL, 0x080fe40007f9e0ffULL,
0x0000003d32327210ULL, 0x000fc40007fbe0ffULL, 0x0000000026377faeULL, 0x0003e2000d101c46ULL,
0x000000ffff317224ULL, 0x000fe400020e0613ULL, 0x000000ffff337224ULL, 0x000fc600028e0609ULL,
0x0000000030397faeULL, 0x0003e8000c901c46ULL, 0x00000000323b7faeULL, 0x0003e2000c101c46ULL,
0x0000061000007947ULL, 0x000fea0003800000ULL, 0x0000003900247211ULL, 0x040fe400078ff0ffULL,
0x0000000800267811ULL, 0x040fe400078ff0ffULL, 0x0000001000307811ULL, 0x040fe400078ff0ffULL,
0x0000001800327811ULL, 0x000fe200078ff0ffULL, 0x00000004263e7824ULL, 0x000fe200078e00ffULL,
0x0000002000347811ULL, 0x000fe200078ff0ffULL, 0x0000000130257824ULL, 0x100fe200078e0239ULL,
0x0000002800367811ULL, 0x000fe200078ff0ffULL, 0x0000000430427824ULL, 0x000fe200078e00ffULL,
0x0000003000387811ULL, 0x000fe200078ff0ffULL, 0x0000000432447824ULL, 0x000fe200078e00ffULL,
0x00000038003c7811ULL, 0x000fe200078ff0ffULL, 0x0000000134277824ULL, 0x100fe200078e0239ULL,
0x000000243a407210ULL, 0x000fe20007f1e0ffULL, 0x0000000126247824ULL, 0x000fe200078e0239ULL,
0xfffffffc3e357812ULL, 0x000fe200078ee209ULL, 0x0000000132267824ULL, 0x000fe200078e0239ULL,
0xfffffffc42377812ULL, 0x000fe200078ee209ULL, 0x0000000136307824ULL, 0x100fe200078e0239ULL,
0x000000243a247210ULL, 0x000fe20007fde0ffULL, 0x0000000138317824ULL, 0x000fe200078e0239ULL,
0xfffffffc443b7812ULL, 0x100fe200078ee209ULL, 0x0000000434347824ULL, 0x000fe200078e00ffULL,
0x000000273a277210ULL, 0x000fe20007f3e0ffULL, 0x0000000436367824ULL, 0x000fe200078e00ffULL,
0x000000253a257210ULL, 0x000fe20007fbe0ffULL, 0x0000000438387824ULL, 0x000fe200078e00ffULL,
0xfffffffc343d7812ULL, 0x000fe200078ee209ULL, 0x000000013c327824ULL, 0x000fe200078e0239ULL,
0xfffffffc36417812ULL, 0x100fe200078ee209ULL, 0x000000043c3c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc384d7812ULL, 0x100fe200078ee209ULL, 0x000000ffff337224ULL, 0x000fe200000e06ffULL,
0x00005e0040397a11ULL, 0x000fe200078040ffULL, 0x000000ffff3f7224ULL, 0x000fe200030e06ffULL,
0xfffffffc3c097812ULL, 0x000fe200078ee209ULL, 0x000000103b477824ULL, 0x100fe200078e0254ULL,
0x00005f0040407a11ULL, 0x000fe200000f4433ULL, 0x00000010414b7824ULL, 0x100fe200078e0254ULL,
0x000000263a267210ULL, 0x000fe20007f1e0ffULL, 0x00000010094f7824ULL, 0x100fe200078e0254ULL,
0x00005e00243e7a11ULL, 0x000fe200078c40ffULL, 0x0000001000097824ULL, 0x000fe200078e00ffULL,
0x000000303a307210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e06ffULL,
0x00005f00243f7a11ULL, 0x000fe200030f443fULL, 0x000000ffff247224ULL, 0x000fe200008e06ffULL,
0x000000313a317210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff367224ULL, 0x000fe200028e06ffULL,
0x00005e0026337a11ULL, 0x000fe200078040ffULL, 0x0000001035437824ULL, 0x100fe200078e0254ULL,
0x00005e0027347a11ULL, 0x000fe200078240ffULL, 0x0000001037457824ULL, 0x100fe200078e0254ULL,
0x0000003009417812ULL, 0x000fe200078ec0ffULL, 0x000000103d497824ULL, 0x100fe200078e0254ULL,
0x000000323a327210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff377224ULL, 0x000fe200010e06ffULL,
0x00005e00253c7a11ULL, 0x000fe200078a40ffULL, 0x000000104d4d7824ULL, 0x000fe200078e0254ULL,
0x00005f00263b7a11ULL, 0x000fe200000f443bULL, 0x000000ffff267224ULL, 0x000fe200018e06ffULL,
0x00005f0027357a11ULL, 0x000fe200008f4424ULL, 0x000000ffff097224ULL, 0x000fe200020e06ffULL,
0x0000004139247210ULL, 0x000fc40007f1e0ffULL, 0x00005f00253d7a11ULL, 0x000fe400028f4436ULL,
0x00005e0031387a11ULL, 0x040fe200078440ffULL, 0x000000ffff257224ULL, 0x000fe200000e0640ULL,
0x00005e0030367a11ULL, 0x000fe400078240ffULL, 0x00005e00323a7a11ULL, 0x000fe400078640ffULL,
0x00005f0031397a11ULL, 0x000fe200010f4426ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024137faeULL, 0x0003e2000b901c46ULL, 0x00005f0030377a11ULL, 0x000fc400008f4437ULL,
0x000000413e267210ULL, 0x080fe40007f1e0ffULL, 0x00005f0032097a11ULL, 0x000fe400018f4409ULL,
0x000000413c307210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e063fULL,
0x0000004133327210ULL, 0x080fe40007f5e0ffULL, 0x0000004134347210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff317224ULL, 0x000fe200008e063dULL, 0x0000004136367210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff337224ULL, 0x000fe200010e063bULL, 0x0000004138387210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff357224ULL, 0x000fe200018e0635ULL, 0x000000413a3a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff377224ULL, 0x000fe200020e0637ULL, 0x0000000026437faeULL, 0x0003e2000b901c46ULL,
0x000000ffff397224ULL, 0x000fc400028e0639ULL, 0x000000ffff3b7224ULL, 0x000fe200000e0609ULL,
0x0000000030457faeULL, 0x0003e8000b901c46ULL, 0x0000000032477faeULL, 0x0003e8000b901c46ULL,
0x0000000034497faeULL, 0x0003e8000b901c46ULL, 0x00000000364b7faeULL, 0x0003e8000b901c46ULL,
0x00000000384d7faeULL, 0x0003e8000b901c46ULL, 0x000000003a4f7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000c08247810ULL, 0x002fc40007ffe0ffULL,
0x0000000e08087810ULL, 0x000fe40007ffe0ffULL, 0x0000000724247812ULL, 0x100fe400078e780bULL,
0x0000000708087812ULL, 0x000fc600078e780bULL, 0x000000100b247824ULL, 0x040fe400078e0224ULL,
0x000000100b087824ULL, 0x000fe400078e0208ULL, 0x0000001024307824ULL, 0x000fe400078e00ffULL,
0x0000001008407824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000003030783bULL, 0x000fe80000000200ULL, 0x000000000a34783bULL, 0x000e680000000200ULL,
0x000000000c38783bULL, 0x000ea80000000200ULL, 0x000000000d3c783bULL, 0x000ee80000000200ULL,
0x000000001224783bULL, 0x000f280000000200ULL, 0x000000004040783bULL, 0x000fe80000000200ULL,
0x000000000f48783bULL, 0x000f680000000200ULL, 0x00000000104c783bULL, 0x000f280000000200ULL,
0x000000001108783bULL, 0x000f680000000200ULL, 0x000000000e44783bULL, 0x0003640000000200ULL,
0x000000343050723cULL, 0x042ff00000001850ULL, 0x000000383018723cULL, 0x044ff00000001818ULL,
0x0000003c3020723cULL, 0x048ff00000001820ULL, 0x000000243028723cULL, 0x050ff00000001828ULL,
0x000000263058723cULL, 0x040ff00000001858ULL, 0x000000363014723cULL, 0x040ff00000001814ULL,
0x0000003a301c723cULL, 0x040ff0000000181cULL, 0x0000003e302c723cULL, 0x000ff0000000182cULL,
0x000000484050723cULL, 0x060ff00000001850ULL, 0x0000004c400c723cULL, 0x040ff00000001818ULL,
0x000000084010723cULL, 0x040ff00000001820ULL, 0x000000444028723cULL, 0x040ff00000001828ULL,
0x000000464058723cULL, 0x040ff00000001858ULL, 0x0000004a4048723cULL, 0x040ff00000001814ULL,
0x0000004e404c723cULL, 0x040ff0000000181cULL, 0x0000000a4008723cULL, 0x000fe2000000182cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0000000056147f8cULL, 0x000fe2000c80043fULL,
0x3db504f3282f7820ULL, 0x000fe20000410000ULL, 0x3db504f3292e7820ULL, 0x000fe20000410000ULL,
0x3db504f32a1e7820ULL, 0x000fe20000410000ULL, 0x0000040056317984ULL, 0x000e620000000800ULL,
0x3db504f32b1d7820ULL, 0x000fe20000410000ULL, 0x3db504f30c277820ULL, 0x000fe20000410000ULL,
0x3db504f30d267820ULL, 0x000fe20000410000ULL, 0x3db504f30e187820ULL, 0x000fe20000410000ULL,
0x3db504f30f197820ULL, 0x000fe20000410000ULL, 0x3db504f312167820ULL, 0x000fe20000410000ULL,
0x3db504f313177820ULL, 0x000fe20000410000ULL, 0x3db504f3582d7820ULL, 0x000fe20000410000ULL,
0x3db504f3592c7820ULL, 0x000fe20000410000ULL, 0x3db504f35a1f7820ULL, 0x000fe20000410000ULL,
0x3db504f35b207820ULL, 0x000fe20000410000ULL, 0x3db504f3502b7820ULL, 0x000fe20000410000ULL,
0x3db504f3512a7820ULL, 0x000fe20000410000ULL, 0x3db504f352217820ULL, 0x000fe20000410000ULL,
0x3db504f353227820ULL, 0x000fe20000410000ULL, 0x3db504f348297820ULL, 0x000fe20000410000ULL,
0x3db504f349287820ULL, 0x000fe20000410000ULL, 0x3db504f34a237820ULL, 0x000fe20000410000ULL,
0x3db504f34b1b7820ULL, 0x000fe20000410000ULL, 0x3db504f34c257820ULL, 0x000fe20000410000ULL,
0x3db504f34d247820ULL, 0x000fe20000410000ULL, 0x3db504f34e1a7820ULL, 0x000fe20000410000ULL,
0x3db504f34f1c7820ULL, 0x000fe20000410000ULL, 0x3db504f3100c7820ULL, 0x000fe20000410000ULL,
0x3db504f3110d7820ULL, 0x000fe20000410000ULL, 0x3db504f3080e7820ULL, 0x000fe20000410000ULL,
0x3db504f3090f7820ULL, 0x000fe20000410000ULL, 0x3db504f30a127820ULL, 0x000fe20000410000ULL,
0x3db504f30b137820ULL, 0x000fe20000410000ULL, 0x8000000031ff7812ULL, 0x002fe20007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff087424ULL, 0x000fc800078e00ffULL,
0x0000000800097305ULL, 0x0002a4000021f000ULL, 0x3fa0000008087823ULL, 0x002fe200000100ffULL,
0x000000090000735dULL, 0x004fe40003800000ULL, 0x0000040056097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000400107824ULL, 0x000fe200078e00ffULL, 0x000000556400720cULL, 0x000fc80003f05270ULL,
0xfffffff010117812ULL, 0x000fca00078ec0ffULL, 0x0000008062117824ULL, 0x000fca00078e0211ULL,
0x0134000011087984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000200147824ULL, 0x000fe400078e00ffULL, 0x0000000160327824ULL, 0x000fc600078e0a07ULL,
0x0000000614147812ULL, 0x000fc800078ec0ffULL, 0x0000000114077812ULL, 0x040fe400078efcffULL,
0x0000000814157812ULL, 0x040fe400078efcffULL, 0x000000320700720cULL, 0x080fe40003f26070ULL,
0x0000001014077812ULL, 0x000fe400078efcffULL, 0x000000321500720cULL, 0x080fe40003f06070ULL,
0x000000320700720cULL, 0x000fc40003fc6070ULL, 0x0000001114157812ULL, 0x040fe400078efcffULL,
0x0000001814077812ULL, 0x040fe400078efcffULL, 0x000000321400720cULL, 0x0c0fe40003f46070ULL,
0x000000321500720cULL, 0x080fe40003fa6070ULL, 0x000000320700720cULL, 0x000fe40003f66070ULL,
0x0000000914307812ULL, 0x000fc400078efcffULL, 0x0000001914157812ULL, 0x040fe400078efcffULL,
0x0000002014077812ULL, 0x000fe400078efcffULL, 0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40005000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL,
0xff7fffff2e2e7808ULL, 0x000fc40004800000ULL, 0x000000323000720cULL, 0x080fe40003f86070ULL,
0x000000321500720cULL, 0x080fe40003f46070ULL, 0x000000320700720cULL, 0x000fe40003f26070ULL,
0x0000002114157812ULL, 0x040fe400078efcffULL, 0x0000002814077812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fc40004000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40004000000ULL,
0xff7fffff20207808ULL, 0x000fe40006000000ULL, 0xff7fffff2c2c7808ULL, 0x000fe40006000000ULL,
0x000000321500720cULL, 0x080fe40003f06070ULL, 0x000000320700720cULL, 0x000fe40003f86070ULL,
0x0000002914157812ULL, 0x000fc400078efcffULL, 0x0000003014077812ULL, 0x000fe400078efcffULL,
0xff7fffff21217808ULL, 0x000fe40007000000ULL, 0xff7fffff2b2b7808ULL, 0x000fe40007000000ULL,
0xff7fffff22227808ULL, 0x000fe40006800000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40006800000ULL,
0x000000321500720cULL, 0x000fc40003fc6070ULL, 0x000000320700720cULL, 0x000fe40003fa6070ULL,
0x0000003114157812ULL, 0x040fe400078efcffULL, 0x0000003814077812ULL, 0x040fe400078efcffULL,
0x0000003914147812ULL, 0x000fe400078efcffULL, 0xff7fffff23237808ULL, 0x000fe40005800000ULL,
0xff7fffff29297808ULL, 0x000fc40005800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40005000000ULL,
0xff7fffff28287808ULL, 0x000fe40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40004800000ULL,
0xff7fffff27277808ULL, 0x000fe40004800000ULL, 0x000000321500720cULL, 0x080fe40003f66070ULL,
0x000000320700720cULL, 0x000fc40003f46070ULL, 0x000000321400720cULL, 0x000fe40003f26070ULL,
0xff7fffff19197808ULL, 0x000fe40004000000ULL, 0xff7fffff26267808ULL, 0x000fe40004000000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40006000000ULL, 0xff7fffff25257808ULL, 0x000fe40006000000ULL,
0xff7fffff1c1c7808ULL, 0x000fc40007000000ULL, 0xff7fffff24247808ULL, 0x000fe40007000000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40006800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40005800000ULL,
0xff7fffff12127808ULL, 0x000fc40005000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40005000000ULL,
0xff7fffff13137808ULL, 0x000fe40004800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40004800000ULL,
0x0000002f08077209ULL, 0x004fe20007810000ULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x0000001e09147209ULL, 0x000fe20007810000ULL, 0xffffffffff367424ULL, 0x000fe200078e00ffULL,
0x0000002e07087209ULL, 0x000fe40007810000ULL, 0x0000001d14147209ULL, 0x000fc40007810000ULL,
0x0000002d08077209ULL, 0x000fe40007810000ULL, 0x0000001f14097209ULL, 0x000fe40007810000ULL,
0x0000002c07087209ULL, 0x000fe40007810000ULL, 0x0000002009147209ULL, 0x000fe40007810000ULL,
0x0000002b08077209ULL, 0x000fe40007810000ULL, 0x0000002114097209ULL, 0x000fc40007810000ULL,
0x0000002a07087209ULL, 0x000fe40007810000ULL, 0x0000002209147209ULL, 0x000fe40007810000ULL,
0x0000002908077209ULL, 0x000fe40007810000ULL, 0x0000002314147209ULL, 0x000fe40007810000ULL,
0x0000002807087209ULL, 0x000fe40007810000ULL, 0x0000001b14077209ULL, 0x000fc40007810000ULL,
0x0000002708097209ULL, 0x000fe40007810000ULL, 0x0000001807087209ULL, 0x000fe40007810000ULL,
0x0000002609147209ULL, 0x000fe40007810000ULL, 0x0000001908077209ULL, 0x000fe40007810000ULL,
0x0000002514097209ULL, 0x000fe40007810000ULL, 0x0000001a07077209ULL, 0x000fc40007810000ULL,
0x0000002409097209ULL, 0x000fe40007810000ULL, 0x0000001c07077209ULL, 0x000fe40007810000ULL,
0x0000000c09087209ULL, 0x000fe40007810000ULL, 0x0000001607147209ULL, 0x000fe40007810000ULL,
0x0000000d08077209ULL, 0x000fe40007810000ULL, 0x0000001714097209ULL, 0x000fc40007810000ULL,
0x0000000e07087209ULL, 0x000fe40007810000ULL, 0x0000001209147209ULL, 0x000fe40007810000ULL,
0x0000000f08307209ULL, 0x000fe40007810000ULL, 0x0000001314337209ULL, 0x000fe20007810000ULL,
0x000017127f007947ULL, 0x000fea000b800000ULL, 0x0c401f0030077f89ULL, 0x0004e400000e0000ULL,
0x0000000730347209ULL, 0x008fe20007810000ULL, 0x000017327f007947ULL, 0x000fea000b800000ULL,
0x0c401f0033077f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a097f89ULL, 0x000f2800000e0000ULL,
0x0c401f000b087f89ULL, 0x000f6200000e0000ULL, 0x0000000733147209ULL, 0x008fc40007810000ULL,
0x000000090a157209ULL, 0x010fc60007810000ULL, 0x0c201f0014317f89ULL, 0x002fe200000e0000ULL,
0x000000080b077209ULL, 0x020fc60007810000ULL, 0x0c201f0034097f89ULL, 0x000e6800000e0000ULL,
0x0c201f0015307f89ULL, 0x004ea800000e0000ULL, 0x0c201f0007327f89ULL, 0x00072200000e0000ULL,
0x0000000934087209ULL, 0x002fe40007810000ULL, 0x0000003114097209ULL, 0x000fc40007810000ULL,
0x00000030150a7209ULL, 0x004fe40007810000ULL, 0x3fb8aa3b080b7820ULL, 0x008fe20000410000ULL,
0x3fb8aa3b09357820ULL, 0x002fe20000410000ULL, 0x3c003c00ff147424ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b2c2c7823ULL, 0x000fe2000001080bULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b1f1f7823ULL, 0x000fe20000010835ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b0f0b7823ULL, 0x000fe2000001080bULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x3c003c00ff157424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b23377823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010835ULL, 0x0000002e002e7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b13137823ULL, 0x000fe20000010835ULL,
0x0000000000057886ULL, 0x000fca00038e0100ULL, 0x0000002d002d7308ULL, 0x000ff00000000800ULL,
0x0000002c002c7308ULL, 0x000ff00000000800ULL, 0x0000001e001e7308ULL, 0x000ff00000000800ULL,
0x0000001d001d7308ULL, 0x000ff00000000800ULL, 0x0000001f000f7308ULL, 0x0007f00000000800ULL,
0x0000002000207308ULL, 0x000f620000000800ULL, 0x3fb8aa3b191f7823ULL, 0x008fce0000010835ULL,
0x0000000c00307308ULL, 0x0003f00000000800ULL, 0x0000000d00317308ULL, 0x0007e20000000800ULL,
0x0000002f2e0c723eULL, 0x002fe400000000ffULL, 0x0000000f200f723eULL, 0x020fca00000000ffULL,
0x0000000e00337308ULL, 0x0003e20000000800ULL, 0x0000001e1d0d723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b181d7823ULL, 0x000fcc0000010835ULL, 0x0000000b00347308ULL, 0x000fe20000000800ULL,
0x0000002d2c0e723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b1a2d7823ULL, 0x000fcc0000010835ULL,
0x0000002100367308ULL, 0x000ff00000000800ULL, 0x00000022000b7308ULL, 0x0002f00000000800ULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x000000140c20723cULL, 0x002fee00000018ffULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0x000000360b19723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b1c0b7823ULL, 0x000fcc0000010835ULL, 0x0000002900297308ULL, 0x000ff00000000800ULL,
0x0000002800287308ULL, 0x000ee20000000800ULL, 0x0000002b2a18723eULL, 0x002fce00000000ffULL,
0x0000003700377308ULL, 0x000ff00000000800ULL, 0x0000001b001e7308ULL, 0x000e620000000800ULL,
0x00000029281a723eULL, 0x008fce00000000ffULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x000000371e1b723eULL, 0x002fce00000000ffULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x000000141820723cULL, 0x000fee0000001820ULL, 0x0000002500257308ULL, 0x000ff00000000800ULL,
0x0000002400247308ULL, 0x000ee20000000800ULL, 0x00000027261c723eULL, 0x002fce00000000ffULL,
0x0000001d001d7308ULL, 0x000ff00000000800ULL, 0x0000001f002c7308ULL, 0x000e620000000800ULL,
0x00000025241e723eULL, 0x008fce00000000ffULL, 0x0000002d002d7308ULL, 0x000ff00000000800ULL,
0x0000000b00287308ULL, 0x0007620000000800ULL, 0x0000001d2c1d723eULL, 0x002fce00000000ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0xfffffffc000b7812ULL, 0x008fe400078ec0ffULL,
0x0000002d281f723eULL, 0x020fca00000000ffULL, 0x0000001700177308ULL, 0x000e640000000800ULL,
0x000000141c24723cULL, 0x000fec0000001820ULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x0000000fff207424ULL, 0x000fe200078e00ffULL, 0x000000333422723eULL, 0x000fcc00000000ffULL,
0x0000001300137308ULL, 0x000ee20000000800ULL, 0x000000161721723eULL, 0x002fe400000000ffULL,
0x0000000b20297219ULL, 0x000fe400000006ffULL, 0x000000303120723eULL, 0x000fe400000000ffULL,
0x00000000292873a1ULL, 0x000e6200000e8000ULL, 0x00000000290473c4ULL, 0x000f620000004000ULL,
0x00000007320b7209ULL, 0x014fe40007810000ULL, 0x000000121323723eULL, 0x008fce00000000ffULL,
0x00000014202c723cULL, 0x000fe20000001824ULL, 0x0000000529ff7c12ULL, 0x002fda000f804028ULL,
0x0000127204008947ULL, 0x020ff4000b800000ULL, 0x001c1fff2c247589ULL, 0x0002a400000e0000ULL,
0x00000000291273a1ULL, 0x000ee200000e8000ULL, 0x00000000290473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x0000000529ff7c12ULL, 0x008fda000f804012ULL,
0x0000128204008947ULL, 0x010fea000b800000ULL, 0x001c1fff2e257589ULL, 0x00072800000e0000ULL,
0x001c1fff26267589ULL, 0x00066800000e0000ULL, 0x001c1fff00277589ULL, 0x0006a400000e0000ULL,
0x00000002ff077819ULL, 0x000fe40000011600ULL, 0x0000000c10377812ULL, 0x000fc400078ec0ffULL,
0x0000000707127812ULL, 0x040fe200078ec0ffULL, 0x0000000807177824ULL, 0x040fe200078e00ffULL,
0x00000007ff157212ULL, 0x000fe200078e33ffULL, 0x0000000807137824ULL, 0x040fe200078e00ffULL,
0x0000000300ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000807327824ULL, 0x040fe200078e00ffULL,
0x0000000807077810ULL, 0x000fe40007ffe0ffULL, 0xfffffff817147812ULL, 0x100fe400078ee212ULL,
0x0000000113167812ULL, 0x102fe200078ef612ULL, 0x0000000807427824ULL, 0x000fe200078e00ffULL,
0x0000000213287812ULL, 0x100fe200078ef612ULL, 0x0000000807177824ULL, 0x000fe200078e00ffULL,
0x00000003132a7812ULL, 0x000fc400078ef612ULL, 0x00000004132c7812ULL, 0x140fe400078ef612ULL,
0x00000005132e7812ULL, 0x148fe400078ef612ULL, 0x0000000613307812ULL, 0x000fe200078ef612ULL,
0x0000000807137824ULL, 0x040fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe400078ee215ULL,
0x00000007ff157212ULL, 0x000fe400078e33ffULL, 0x0000000707127812ULL, 0x000fc400078ec0ffULL,
0x0000900062077811ULL, 0x000fe400078e58ffULL, 0xfffffff817347812ULL, 0x100fe400078ee212ULL,
0x0000000113367812ULL, 0x140fe200078ef612ULL, 0x0000001014107824ULL, 0x000fe200078e0207ULL,
0xfffffff842427812ULL, 0x000fe200078ee215ULL, 0x0000001028147824ULL, 0x100fe200078e0207ULL,
0x0000000213387812ULL, 0x140fe200078ef612ULL, 0x000000102c287824ULL, 0x100fe200078e0207ULL,
0x00000003133a7812ULL, 0x140fe200078ef612ULL, 0x00000010302c7824ULL, 0x100fe200078e0207ULL,
0x00000004133c7812ULL, 0x140fe200078ef612ULL, 0x0000001036307824ULL, 0x100fe200078e0207ULL,
0x00000005133e7812ULL, 0x140fe200078ef612ULL, 0x0000001038317824ULL, 0x100fe200078e0207ULL,
0x0000000613407812ULL, 0x000fe200078ef612ULL, 0x0000001016127824ULL, 0x000fc400078e0207ULL,
0x000000102a167824ULL, 0x100fe400078e0207ULL, 0x000000102e2a7824ULL, 0x100fe400078e0207ULL,
0x0000000137137824ULL, 0x000fe400078e0210ULL, 0x00000010322e7824ULL, 0x100fe400078e0207ULL,
0x0000001034107824ULL, 0x100fe200078e0207ULL, 0x0000000c13007388ULL, 0x0003e20000000800ULL,
0x000000103a327824ULL, 0x000fc400078e0207ULL, 0x000000103c337824ULL, 0x100fe400078e0207ULL,
0x000000103e347824ULL, 0x100fe400078e0207ULL, 0x0000001040357824ULL, 0x100fe400078e0207ULL,
0x0000001042367824ULL, 0x000fe400078e0207ULL, 0x0000000137077824ULL, 0x040fe400078e0212ULL,
0x0000000137157824ULL, 0x000fc400078e0214ULL, 0x0000000137177824ULL, 0x040fe200078e0216ULL,
0x0000000e07007388ULL, 0x0007e20000000800ULL, 0x0000000137297824ULL, 0x040fe400078e0228ULL,
0x00000001372b7824ULL, 0x040fe200078e022aULL, 0x0000001815007388ULL, 0x0007e20000000800ULL,
0x00000001372d7824ULL, 0x040fe400078e022cULL, 0x00000001372f7824ULL, 0x040fe200078e022eULL,
0x0000001a17007388ULL, 0x0007e20000000800ULL, 0x0000000137107824ULL, 0x000fc400078e0210ULL,
0x0000000137307824ULL, 0x040fe200078e0230ULL, 0x0000001c29007388ULL, 0x0007e20000000800ULL,
0x0000000137127824ULL, 0x040fe400078e0231ULL, 0x0000000137327824ULL, 0x040fe200078e0232ULL,
0x0000001e2b007388ULL, 0x0007e20000000800ULL, 0x00000001370c7824ULL, 0x042fe400078e0233ULL,
0x0000000137347824ULL, 0x040fe200078e0234ULL, 0x000000202d007388ULL, 0x0007e20000000800ULL,
0x0000000137147824ULL, 0x000fc400078e0235ULL, 0x0000000137367824ULL, 0x000fe200078e0236ULL,
0x000000222f007388ULL, 0x0007e80000000800ULL, 0x0000000d10007388ULL, 0x0007e80000000800ULL,
0x0000000f30007388ULL, 0x0007e80000000800ULL, 0x0000001912007388ULL, 0x0007e80000000800ULL,
0x0000001b32007388ULL, 0x0007e80000000800ULL, 0x0000001d0c007388ULL, 0x0007e80000000800ULL,
0x0000001f34007388ULL, 0x0007e80000000800ULL, 0x0000002114007388ULL, 0x0007e80000000800ULL,
0x0000002336007388ULL, 0x0007e80000000800ULL, 0x0130000811008388ULL, 0x0007e80000000c00ULL,
0x0132002411008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136080006ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136100006ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136180006ff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000575c00720cULL, 0x000fe20003f06070ULL, 0x0136200006ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff647224ULL, 0x000fd600078e005cULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffa84000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff157807ULL, 0x004fe40004000000ULL, 0x0001263000147802ULL, 0x000fe40000000f00ULL,
0x00000e3000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0016ULL,
0xffff025000007947ULL, 0x000fea000383ffffULL, 0x00000001ff157807ULL, 0x000fe40004800000ULL,
0x0001268000147802ULL, 0x000fe40000000f00ULL, 0x00000de000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0016ULL, 0xffff029000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0010ULL, 0x000126f000147802ULL, 0x002fe20000000f00ULL,
0x0000001fff167424ULL, 0x000fe400078e00ffULL, 0xffffffffff297424ULL, 0x000fc400078e00ffULL,
0x00000d3000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0027ULL,
0xffff02e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0010ULL,
0x0001276000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff167424ULL, 0x000fc400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x00000cc000007944ULL, 0x02cfea0003c00000ULL,
0xffff02b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e001cULL,
0x000127c000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff167424ULL, 0x000fe400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x00000c6000007944ULL, 0x028fea0003c00000ULL,
0x000000081c107810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff6f7224ULL, 0x004fe200078e0027ULL,
0x0001283000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff167424ULL, 0x002fe400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x000000ffff287224ULL, 0x000fc400078e0010ULL,
0x00000bf000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff6e7224ULL, 0x004fe200078e0027ULL,
0xffff04d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff157807ULL, 0x004fe40004000000ULL,
0x0001288000147802ULL, 0x000fc40000000f00ULL, 0x00000be000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0016ULL, 0xffff1bf000007947ULL, 0x000fea000383ffffULL,
0x00000001ff157807ULL, 0x000fe40004800000ULL, 0x000128d000147802ULL, 0x000fc40000000f00ULL,
0x00000b9000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0016ULL,
0xffff1c3000007947ULL, 0x000fea000383ffffULL, 0x0000001fff167424ULL, 0x002fe200078e00ffULL,
0x0001293000147802ULL, 0x000fe20000000f00ULL, 0xffffffffff297424ULL, 0x000fc400078e00ffULL,
0x00000af000007944ULL, 0x008fea0003c00000ULL, 0xffff1cb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x002fe200078e0010ULL, 0x0001299000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff167424ULL, 0x000fc400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x00000a9000007944ULL, 0x008fea0003c00000ULL, 0xffff1d7000007947ULL, 0x000fea000383ffffULL,
0x0000001fff167424ULL, 0x000fe200078e00ffULL, 0x000129e000147802ULL, 0x000fe20000000f00ULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x00000a4000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff7b7224ULL, 0x004fe200078e0027ULL, 0x00012a4000147802ULL, 0x000fe20000000f00ULL,
0x000000ffff287224ULL, 0x002fe400078e0010ULL, 0x0000001fff167424ULL, 0x000fe400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x000009e000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff7a7224ULL, 0x004fe200078e0027ULL, 0xffff1eb000007947ULL, 0x000fea000383ffffULL,
0x00000001ff157807ULL, 0x004fe40004000000ULL, 0x00012a9000147802ULL, 0x000fc40000000f00ULL,
0x000009d000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0016ULL,
0xffff343000007947ULL, 0x000fea000383ffffULL, 0x00000001ff157807ULL, 0x000fe40004800000ULL,
0x00012ae000147802ULL, 0x000fc40000000f00ULL, 0x0000098000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0016ULL, 0xffff347000007947ULL, 0x000fea000383ffffULL,
0x0000001fff167424ULL, 0x002fe200078e00ffULL, 0x00012b4000147802ULL, 0x000fe20000000f00ULL,
0xffffffffff297424ULL, 0x000fc400078e00ffULL, 0x000008e000007944ULL, 0x028fea0003c00000ULL,
0xffff34f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x002fe200078e0010ULL,
0x00012ba000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff167424ULL, 0x000fc400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x0000088000007944ULL, 0x028fea0003c00000ULL,
0xffff35b000007947ULL, 0x000fea000383ffffULL, 0x0000001fff167424ULL, 0x000fe200078e00ffULL,
0x00012bf000147802ULL, 0x000fe20000000f00ULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x0000083000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff797224ULL, 0x004fe200078e0027ULL,
0x00012c5000147802ULL, 0x000fe20000000f00ULL, 0x000000ffff287224ULL, 0x002fe400078e0010ULL,
0x0000001fff167424ULL, 0x000fe400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x000007d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff767224ULL, 0x004fe200078e0027ULL,
0xffff36f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff157807ULL, 0x004fe40004000000ULL,
0x00012ca000147802ULL, 0x000fc40000000f00ULL, 0x000007c000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0016ULL, 0xffff4b8000007947ULL, 0x000fea000383ffffULL,
0x00000001ff157807ULL, 0x000fe40004800000ULL, 0x00012cf000147802ULL, 0x000fc40000000f00ULL,
0x0000077000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0016ULL,
0xffff4bc000007947ULL, 0x000fea000383ffffULL, 0x0000001fff167424ULL, 0x002fe200078e00ffULL,
0x00012d5000147802ULL, 0x000fe20000000f00ULL, 0xffffffffff297424ULL, 0x000fc400078e00ffULL,
0x000006d000007944ULL, 0x008fea0003c00000ULL, 0xffff4c4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x002fe200078e0010ULL, 0x00012db000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff167424ULL, 0x000fc400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x0000067000007944ULL, 0x008fea0003c00000ULL, 0xffff4d0000007947ULL, 0x000fea000383ffffULL,
0x0000001fff167424ULL, 0x000fe200078e00ffULL, 0x00012e0000147802ULL, 0x000fe20000000f00ULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x0000062000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0027ULL, 0x00012e6000147802ULL, 0x000fe20000000f00ULL,
0x000000ffff287224ULL, 0x002fe400078e0010ULL, 0x0000001fff167424ULL, 0x000fe400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x000005c000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0027ULL, 0xffff4e4000007947ULL, 0x000fea000383ffffULL,
0x00000002ff317424ULL, 0x000fe200078e00ffULL, 0x00012eb000147802ULL, 0x000fc40000000f00ULL,
0x0000053000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0032ULL,
0xffffe8b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x006fe200078e0033ULL,
0x00012f1000147802ULL, 0x000fe20000000f00ULL, 0x00000002ff317424ULL, 0x000fc400078e00ffULL,
0x000004d000007944ULL, 0x000fea0003c00000ULL, 0x0000003233097209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x002fe200078e000aULL, 0x00012f6000147802ULL, 0x000fe20000000f00ULL,
0x00000002ff317424ULL, 0x000fc400078e00ffULL, 0x0000048000007944ULL, 0x000fea0003c00000ULL,
0x000000320a337209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x002fe200078e000bULL,
0x00012fb000147802ULL, 0x000fe20000000f00ULL, 0x00000002ff317424ULL, 0x000fc400078e00ffULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x000000320b077209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x002fe200078e0034ULL, 0x0001300000147802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fc400078e00ffULL, 0x000003e000007944ULL, 0x000fea0003c00000ULL,
0x0000003234087209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x002fe200078e0009ULL,
0x0001305000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff317424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x0000003209097209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x002fe200078e0033ULL, 0x000130a000147802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fc400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0x00000032330a7209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x002fe200078e0007ULL,
0x000130f000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff317424ULL, 0x000fc400078e00ffULL,
0x000002f000007944ULL, 0x000fea0003c00000ULL, 0xffffe77000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x000fe200078e002cULL, 0x0001315000147802ULL, 0x000fe20000000f00ULL,
0x000000ffff287224ULL, 0x000fc400078e00ffULL, 0x00001c1fff167424ULL, 0x000fe400078e00ffULL,
0x000002d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e0027ULL,
0xffffed3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e002eULL,
0x000131c000147802ULL, 0x000fe20000000f00ULL, 0x000000ffff287224ULL, 0x000fe400078e00ffULL,
0x00001c1fff167424ULL, 0x000fe400078e00ffULL, 0x0000026000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff287224ULL, 0x002fe200078e00ffULL, 0x0001321000147802ULL, 0x000fe20000000f00ULL,
0x00001c1fff167424ULL, 0x000fe400078e00ffULL, 0x000000ffff257224ULL, 0x004fe400078e0027ULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff287224ULL, 0x002fe200078e00ffULL,
0x0001326000147802ULL, 0x000fe20000000f00ULL, 0x00001c1fff167424ULL, 0x000fc400078e00ffULL,
0x000000ffff267224ULL, 0x004fe400078e0027ULL, 0x000001c000007944ULL, 0x000fea0003c00000ULL,
0xffffecb000007947ULL, 0x000fea000383ffffULL, 0x0180000007037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000700038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff2c7807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x000000032cff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000007057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x000000032cff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff2b7424ULL, 0x000fc800078e00ffULL, 0xfffecc202a007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff157424ULL, 0x000fe200078e00ffULL, 0x0000003600007348ULL, 0x000fe80003800000ULL,
0x0c00003130327389ULL, 0x0002a200000e0035ULL, 0xfffecbe014007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff157424ULL, 0x000fe200078e00ffULL, 0x0000002900007348ULL, 0x000fe80003800000ULL,
0x000000282b277389ULL, 0x0002a200000e0016ULL, 0xfffecba014007950ULL, 0x000fea0003c3ffffULL,
0x000000011500780cULL, 0x000fe20003f25070ULL, 0x0000000e00007348ULL, 0x000fd80003800000ULL,
0x0000000000157806ULL, 0x000fc800048e0100ULL, 0x0000000e15167212ULL, 0x000fe200078ec0ffULL,
0x00000000ff157424ULL, 0x000fc800078e00ffULL, 0xfffecb4014007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000013700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000270ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000850ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000008e0ULL, 0x00000000000005e4ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ec4ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ee8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ef8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f18ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000fa8ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000fb0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000fc0ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000013580ULL, 0x8000001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014700ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000014710ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014710ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000014b90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000fa8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000013758ULL, 0x0000000000013758ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000014b90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_8_m_8_sm_86_cubin_len = 85104;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
