/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_16_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x00000000000120f8ULL, 0x0000000000011c78ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x0000000000010c50ULL, 0x00000000000002b0ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000010f00ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00010c5000000000ULL, 0x0000140400000000ULL, 0x0408288080810c00ULL, 0x00000000000042f4ULL,
0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080c90828808081ULL, 0x8016288080860828ULL, 0x0000000310288082ULL,
0x8086920000000000ULL, 0x0000000022002880ULL, 0x0000002cffffffffULL, 0x0000006800000000ULL,
0x00010c5000000000ULL, 0x000002b000000000ULL, 0x0000680400000000ULL, 0x8082288080860900ULL,
0x0000000000002880ULL, 0x0000000e00082f04ULL, 0x0008120400000080ULL, 0x000000080000000bULL,
0x0000000b00081104ULL, 0x0008120400000008ULL, 0x000000080000000eULL, 0x0000000e00081104ULL,
0x0008120400000008ULL, 0x000000080000000eULL, 0x0000007c00043704ULL, 0x00000000000c1704ULL,
0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL,
0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x00801b0380005003ULL,
0x000085d000183104ULL, 0x0001014000008c20ULL, 0x0001016000010150ULL, 0x00cc290400010170ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500001c05000003ULL, 0x050000030500001cULL, 0x0500000305000003ULL,
0x0500002b0500002bULL, 0x0500002b0500002bULL, 0x0500002b0500002bULL, 0x0500002b0500002bULL,
0x0500002b0500002bULL, 0x00cc28040500002bULL, 0x000000d0000000b0ULL, 0x00003ec000002420ULL,
0x00003fe000003f80ULL, 0x0000441000004020ULL, 0x00004bf000004450ULL, 0x00005c0000005b20ULL,
0x00005cc000005ca0ULL, 0x0000602000005ff0ULL, 0x0000681000006800ULL, 0x00006b6000006b50ULL,
0x00008c20000085d0ULL, 0x0000913000009100ULL, 0x0000974000009720ULL, 0x0000fa800000fa70ULL,
0x0000faa00000fa90ULL, 0x0000faf00000fad0ULL, 0x0000fb200000fb10ULL, 0x0001015000010130ULL,
0x000101a000010160ULL, 0x000101c0000101b0ULL, 0x000107e000010750ULL, 0x000108a000010840ULL,
0x0001097000010910ULL, 0x00010a30000109d0ULL, 0x00010b7000010ad0ULL, 0x0100390400010c10ULL,
0x000000ff00000180ULL, 0x0005010000023600ULL, 0x0000000200000270ULL, 0x003f010000023608ULL,
0x00000002000002e0ULL, 0x003f010000023610ULL, 0x000000ff000006b0ULL, 0x0005010700023600ULL,
0x000000ff000008a0ULL, 0x0006010100023610ULL, 0x000000ff00003d70ULL, 0x001c010a00023608ULL,
0x000000ff00004b50ULL, 0x001c010100023610ULL, 0x000000ff000059c0ULL, 0x001c010a00023628ULL,
0x000000ff00006450ULL, 0x001c010100023630ULL, 0x000000ff0000bc80ULL, 0x0010010a00023600ULL,
0x000000ff0000f160ULL, 0x001b010a00023610ULL, 0x000000ff000104e0ULL, 0x001b010100023608ULL,
0x000000ff00010530ULL, 0x001c010a00023608ULL, 0x000000ff000105b0ULL, 0x001c010a00023628ULL,
0x000000ff00010610ULL, 0x0010010a00023600ULL, 0x000000ff00010690ULL, 0x001b010a00023610ULL,
0x00141c0400033803ULL, 0x0000a1f000009d70ULL, 0x0000bd500000bcb0ULL, 0x000c050400010500ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0058190300000000ULL, 0x0000000f00080a04ULL,
0x0004360400580210ULL, 0x0000000000000008ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL,
0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000000ULL,
0x00000000000000ccULL, 0x0000000e00000002ULL, 0x0000000000010c50ULL, 0x0000000000000044ULL,
0x0000000e00000002ULL, 0x0000000000000000ULL, 0x00000000000000a5ULL, 0x0000000e00000002ULL,
0x0000000000000000ULL, 0x0000004043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000057919ULL, 0x000eae0000002100ULL,
0x00000000000579c3ULL, 0x000ee20000002500ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0xfffffff801017836ULL, 0x002fe20000000000ULL, 0x0000000000087919ULL, 0x000e620000002300ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x00000000000479c3ULL, 0x000f300000002700ULL,
0x00000000000979c3ULL, 0x000f220000002600ULL, 0x00000005ff4a7e24ULL, 0x008fe2000f8e00ffULL,
0x00000005ff027819ULL, 0x004fcc0000011605ULL, 0x00001fff02027589ULL, 0x000ea200000e0000ULL,
0x0000000108007824ULL, 0x002fc600078e0203ULL, 0x00001fff08087589ULL, 0x000e6200000e0000ULL,
0x0000008000007824ULL, 0x000fca00078e0205ULL, 0x000000ff0000720cULL, 0x040fe40003f05270ULL,
0x000000030000780cULL, 0x000fe40003f24070ULL, 0x00000000021472caULL, 0x004fd200000e0000ULL,
0x0000000000240947ULL, 0x012fec0003800000ULL, 0x00000000000679c3ULL, 0x000ea20000008800ULL,
0x0000040000057882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065406057896ULL, 0x004fc60008000005ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000eae0000000000ULL,
0x02360006053f75b2ULL, 0x0004a40008000100ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000030000157ab9ULL, 0x000fe20000000800ULL,
0x000001a000007945ULL, 0x000fe80003800000ULL, 0x0000000000601947ULL, 0x000fea0003800000ULL,
0x00000000000679c3ULL, 0x000ea20000008800ULL, 0x0000040000057882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x7fff000000077882ULL, 0x000fe20000000000ULL,
0x0000065406057896ULL, 0x004fc60008000005ULL, 0x001fffc000067882ULL, 0x000fc60000000000ULL,
0x0000000500027c11ULL, 0x000fe2000f8e20ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000020512caULL, 0x004fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f240000000000ULL,
0x02360806053f75b2ULL, 0x0085300008000100ULL, 0xfffffffd00e81947ULL, 0x010fea000393ffffULL,
0x0000000000007918ULL, 0x008fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x001fff8000067882ULL, 0x004fe20000000000ULL, 0x7ffe000000077882ULL, 0x000fd60000000000ULL,
0x00000000020512caULL, 0x004fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f240000000000ULL,
0x02361006053f75b2ULL, 0x0085300008000100ULL, 0xfffffffd00e81947ULL, 0x010fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000007f0000780cULL, 0x000fe20003f04070ULL,
0x00008e0000067ab9ULL, 0x004fe20000000a00ULL, 0x000000ff0800720cULL, 0x002fe20003f25270ULL,
0x00000004040678a5ULL, 0x000fe2000f8e0006ULL, 0x0000820000127ab9ULL, 0x000fe20000000a00ULL,
0x00008400000a7ab9ULL, 0x000fc80000000800ULL, 0x00000006ff067e24ULL, 0x000fe4000f8e00ffULL,
0x00000007ff077e24ULL, 0x000fe4000f8e00ffULL, 0x0000000000038919ULL, 0x000e620000008800ULL,
0x0000040000028802ULL, 0x000fc80000000f00ULL, 0x0000065403058816ULL, 0x002fe20000000002ULL,
0xff317217ff038424ULL, 0x000fc800078e00ffULL, 0x0000000400008824ULL, 0x000fca00078e0205ULL,
0x0234000300008388ULL, 0x0003e20000000800ULL, 0x0000000000007b1dULL, 0x008fec0000010000ULL,
0x0000000000981947ULL, 0x002fea0003800000ULL, 0x00000000000d7919ULL, 0x000e620000000000ULL,
0x00008800ff047b82ULL, 0x000ea20000000a00ULL, 0x0000000214087899ULL, 0x000fe4000800063fULL,
0x000000040a057899ULL, 0x000fe4000800063fULL, 0x0000000409067899ULL, 0x000fc6000800063fULL,
0x00000000000779c3ULL, 0x000ee20000008800ULL, 0x00000004050572a4ULL, 0x000fe2000f8e0206ULL,
0x000000080d007c11ULL, 0x002fc8000f8fe0ffULL, 0x00000007000a7812ULL, 0x040fe200078ec0ffULL,
0x00000002000b7836ULL, 0x040fe40000000000ULL, 0x0000000500037c36ULL, 0x000fe40008000000ULL,
0x000000050b097c36ULL, 0x040fe20008000000ULL, 0x000000070b0c7812ULL, 0x000fe200078ec0ffULL,
0x0000010003027825ULL, 0x104fe200078e0004ULL, 0x0000040000057882ULL, 0x000fe40000000000ULL,
0x0000000f0c0c7812ULL, 0x000fe200078e780dULL, 0x0000010009047825ULL, 0x000fe200078e0004ULL,
0x0000065407057896ULL, 0x008fc60008000005ULL, 0x000000100d097824ULL, 0x000fe400078e00ffULL,
0x000000100b0c7824ULL, 0x000fc600078e020cULL, 0x000000f0090f7812ULL, 0x000fe400078ec0ffULL,
0x0000000f0a097812ULL, 0x000fe400078e780dULL, 0x0000000f02027210ULL, 0x000fe40007f1e0ffULL,
0x0000000f04047210ULL, 0x000fe20007f3e0ffULL, 0x0000001000097824ULL, 0x000fe200078e0209ULL,
0x000000050c0b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x000000ffff057224ULL, 0x000fe200008e0605ULL, 0x0000000509097c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000b901c52ULL,
0x00000000040b7faeULL, 0x0003e2000b901c52ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0002360005057890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x0000001206067981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0800720cULL, 0x000fe40003f05270ULL, 0x00000000061772caULL, 0x004fda00000e0000ULL,
0x0000007f17077890ULL, 0x000fe4000fffe03fULL, 0x000000ff17057890ULL, 0x000fe4000fffe03fULL,
0x000000073f077899ULL, 0x000fe40008011607ULL, 0x000000083f057899ULL, 0x000fe20008011605ULL,
0x0000009800a48947ULL, 0x000ff60003800000ULL, 0x000000004a0f72caULL, 0x000fe200000e0000ULL,
0x000000023f067899ULL, 0x000fe20008011614ULL, 0x00000000000b79c3ULL, 0x000e620000008800ULL,
0x00000002ff007424ULL, 0x000fe400078e00ffULL, 0x01ffffff06067892ULL, 0x000fd0000f8ec03fULL,
0x000000060f0e7291ULL, 0x000fc8000f8e083fULL, 0x000000070e00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fca0003f0f008ULL, 0x0000000104068899ULL, 0x000fe2000800063fULL,
0x0000900000088ab9ULL, 0x000fe20000000800ULL, 0x00008c00000c8ab9ULL, 0x000fe40000000a00ULL,
0x00000008060682a4ULL, 0x000fc6000f8e0208ULL, 0x0000040000087882ULL, 0x000fe20000000000ULL,
0x000000060e068290ULL, 0x000fe4000fffe03fULL, 0x000006540b087896ULL, 0x002fe40008000008ULL,
0x00000004060c88a5ULL, 0x000fe4000f8e000cULL, 0x0000000814067291ULL, 0x000fc8000f8e203fULL,
0x0000000cff027e24ULL, 0x000fe4000f8e00ffULL, 0x0000000dff037e24ULL, 0x000fc6000f8e00ffULL,
0x02361000ffff79a7ULL, 0x0003e40008500006ULL, 0x0000001202028981ULL, 0x000ea2000c1e1900ULL,
0x000000013f067899ULL, 0x000fe40008011614ULL, 0x0000000709097899ULL, 0x000fe4000800063fULL,
0x000000060f0b7291ULL, 0x000fe2000f8e103fULL, 0x000000014a007836ULL, 0x002fe20000000000ULL,
0x0000000114167892ULL, 0x000fe4000f8ec03fULL, 0x000000060b0c7899ULL, 0x000fc4000800063fULL,
0x000000070a0b7899ULL, 0x000fe4000800063fULL, 0x00000040090d7892ULL, 0x000fe2000f8ef80cULL,
0xffffffff000a7882ULL, 0x000fe20000000000ULL, 0x00000000020f82caULL, 0x004fe400000e0000ULL,
0x0000000500007c0cULL, 0x000fd6000bf06070ULL, 0x0000000f000a8c82ULL, 0x000fe40008000000ULL,
0x0000000c00088947ULL, 0x000fea0003800000ULL, 0x0000000000257919ULL, 0x000e620000000000ULL,
0x0000000c1700728cULL, 0x000fe4000bf01070ULL, 0x8000000cff097e24ULL, 0x000fe2000f8e02ffULL,
0x0000000a0b0a72a4ULL, 0x000fe4000f8e020dULL, 0x0000000c170f7287ULL, 0x000fe4000c000000ULL,
0x00000008060b7291ULL, 0x000fe4000f8e783fULL, 0x00000003160c7899ULL, 0x000fc4000800063fULL,
0x0000000fff007e24ULL, 0x000fe2000f8e00ffULL, 0x0000000b160b7291ULL, 0x000fc8000f8e703fULL,
0x0000004000097446ULL, 0x000fe20003800009ULL, 0x000130000b0b7890ULL, 0x000fe2000fffe03fULL,
0x00000003ff0a7819ULL, 0x002fe40000011625ULL, 0x0ffffff825037812ULL, 0x000fe400078ec0ffULL,
0x000000250a007212ULL, 0x0c0fe200078e3cffULL, 0x000000080a107836ULL, 0x040fe20000000000ULL,
0x0000007f0a087812ULL, 0x040fe200078ec0ffULL, 0x000000140a1c7836ULL, 0x000fe20000000000ULL,
0x00000007030b7812ULL, 0x000fe200078ef800ULL, 0x0000000810077824ULL, 0x040fe200078e00ffULL,
0x0000002510047212ULL, 0x080fe200078e3cffULL, 0x000000040a0c7836ULL, 0x000fe20000000000ULL,
0x000000251c037212ULL, 0x080fe200078e3cffULL, 0x000000100a187836ULL, 0x000fe20000000000ULL,
0xfffffff807147812ULL, 0x000fe200078ee204ULL, 0x000000081c047824ULL, 0x000fe200078e00ffULL,
0x000000250c027212ULL, 0x040fe200078e3cffULL, 0x000000080c057824ULL, 0x040fe200078e00ffULL,
0x000000090c00720cULL, 0x000fe20003f26070ULL, 0x000000200a227836ULL, 0x000fe20000000000ULL,
0xfffffff8041d7812ULL, 0x000fe200078ee203ULL, 0x0000000818077824ULL, 0x000fe200078e00ffULL,
0xfffffff8050e7812ULL, 0x000fe200078ee202ULL, 0x0000000822047824ULL, 0x000fe200078e00ffULL,
0x0000002518027212ULL, 0x080fe200078e3cffULL, 0x0000001c0a207836ULL, 0x000fe20000000000ULL,
0x0000002522037212ULL, 0x080fe200078e3cffULL, 0x000000240a247836ULL, 0x040fe20000000000ULL,
0xfffffff8071a7812ULL, 0x000fe200078ee202ULL, 0x0000000c0a127836ULL, 0x000fe20000000000ULL,
0xfffffff804237812ULL, 0x000fe200078ee203ULL, 0x0000000820217824ULL, 0x040fe200078e00ffULL,
0x0000002520027212ULL, 0x080fe200078e3cffULL, 0x0000000824037824ULL, 0x040fe200078e00ffULL,
0x0000002524067212ULL, 0x080fe200078e3cffULL, 0x0000000812057824ULL, 0x040fe200078e00ffULL,
0x0000002512007212ULL, 0x080fe200078e3cffULL, 0x000000180a1e7836ULL, 0x040fe20000000000ULL,
0xfffffff821217812ULL, 0x000fe200078ee202ULL, 0x000000280a267836ULL, 0x000fe20000000000ULL,
0xfffffff803067812ULL, 0x000fe200078ee206ULL, 0x000000081e1f7824ULL, 0x000fe200078e00ffULL,
0x00008a00ff027b82ULL, 0x000e620000000a00ULL, 0xfffffff805167812ULL, 0x000fe200078ee200ULL,
0x0000002c0a287836ULL, 0x000fe20000000000ULL, 0x000000251e007212ULL, 0x080fe200078e3cffULL,
0x000000300a2a7836ULL, 0x000fe20000000000ULL, 0x0000002526077212ULL, 0x080fe200078e3cffULL,
0x0000000828057824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee200ULL,
0x0000000826007824ULL, 0x000fe200078e00ffULL, 0x0000002528047212ULL, 0x000fe200078e3cffULL,
0x000000082a0d7824ULL, 0x000fe200078e00ffULL, 0x0000007f0c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000340a2c7836ULL, 0x000fe20000000000ULL, 0xfffffff800077812ULL, 0x000fc400078ee207ULL,
0x000000252a007212ULL, 0x000fe200078e3cffULL, 0x0000000a0c0f7c36ULL, 0x000fe20008000000ULL,
0x000000091000720cULL, 0x080fe20003f46070ULL, 0x000000082c1b7824ULL, 0x000fe200078e00ffULL,
0x0000007f10107812ULL, 0x000fe400078ec0ffULL, 0x000000091200720cULL, 0x080fe40003f66070ULL,
0xfffffff805047812ULL, 0x000fe200078ee204ULL, 0x0000000cff057e24ULL, 0x000fe2000f8e00ffULL,
0xfffffff80d007812ULL, 0x000fe200078ee200ULL, 0x0000000a080d7c36ULL, 0x000fe20008000000ULL,
0x0000007f12127812ULL, 0x000fe200078ec0ffULL, 0x0000000a10117c36ULL, 0x000fe20008000000ULL,
0x000000090a00720cULL, 0x000fe20003f06070ULL, 0x000001000d0c7825ULL, 0x002fe200078e0002ULL,
0x0000000b0e157c11ULL, 0x000fc4000f8e20ffULL, 0xfffffff805057812ULL, 0x000fe200078ee225ULL,
0x0000000a12137c36ULL, 0x000fe20008000000ULL, 0x0000000b0b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x000001000f0e7825ULL, 0x100fe200078e0002ULL, 0x0000000b14177c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b16197c11ULL, 0x000fe2000f8e20ffULL, 0x0000010011107825ULL, 0x100fe200078e0002ULL,
0x000000252c087212ULL, 0x000fe400078e3cffULL, 0x000000092200720cULL, 0x000fe20003f86070ULL,
0x0000010013127825ULL, 0x000fe200078e0002ULL, 0xfffffff81b087812ULL, 0x000fc400078ee208ULL,
0x0000007f22227812ULL, 0x000fe200078ec0ffULL, 0x00000010050c7825ULL, 0x000fe200078e000cULL,
0x0000000b1d1d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000b1f1f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000010050e7825ULL, 0x040fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0b7faeULL, 0x0003e2000c101c52ULL, 0x000000091800720cULL, 0x040fe40003f06070ULL,
0x0000001005107825ULL, 0x000fe200078e0010ULL, 0x000000000e157faeULL, 0x000fe2000c901c52ULL,
0x0000007f18187812ULL, 0x000fc400078ec0ffULL, 0x0000001005127825ULL, 0x000fe200078e0012ULL,
0x000000091c00720cULL, 0x0c0fe20003f26070ULL, 0x0000000010177faeULL, 0x0005e2000d101c52ULL,
0x0000007f1c1c7812ULL, 0x000fe200078ec0ffULL, 0x0000000a181b7c36ULL, 0x000fe20008000000ULL,
0x000000091e00720cULL, 0x0c0fe20003f46070ULL, 0x0000000012197faeULL, 0x0007e2000d901c52ULL,
0x0000007f1e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000a1c0b7c36ULL, 0x002fe20008000000ULL,
0x000000092000720cULL, 0x040fe20003f66070ULL, 0x000001001b0c7825ULL, 0x000fe200078e0002ULL,
0x0000007f20207812ULL, 0x000fc400078ec0ffULL, 0x0000000b21217c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a1e117c36ULL, 0x004fe20008000000ULL, 0x0000000b23237c11ULL, 0x000fe2000f8e20ffULL,
0x000001000b0e7825ULL, 0x100fe200078e0002ULL, 0x0000000b1a0b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a20137c36ULL, 0x008fe20008000000ULL,
0x0000000b00177c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a22157c36ULL, 0x000fe20008000000ULL,
0x0000000b08197c11ULL, 0x000fe2000f8e20ffULL, 0x0000010011107825ULL, 0x000fc800078e0002ULL,
0x0000010013127825ULL, 0x000fc800078e0002ULL, 0x0000010015147825ULL, 0x000fc800078e0002ULL,
0x00000010050c7825ULL, 0x000fc800078e000cULL, 0x00000010050e7825ULL, 0x040fe200078e000eULL,
0x000000000c0b7faeULL, 0x0003e2000c101c52ULL, 0x000000092400720cULL, 0x080fe40003f06070ULL,
0x0000001005107825ULL, 0x040fe200078e0010ULL, 0x000000000e1d7faeULL, 0x0005e2000c901c52ULL,
0x000000092600720cULL, 0x080fe40003f26070ULL, 0x0000001005127825ULL, 0x000fe200078e0012ULL,
0x00000000101f7faeULL, 0x0007e2000d101c52ULL, 0x000000092800720cULL, 0x000fc40003f46070ULL,
0x0000001005147825ULL, 0x000fe200078e0014ULL, 0x0000000012217faeULL, 0x0009e2000d901c52ULL,
0x000000092a00720cULL, 0x080fe40003f66070ULL, 0x000000380a0c7836ULL, 0x042fe20000000000ULL,
0x0000000014237faeULL, 0x0003e2000e101c52ULL, 0x0000003c0a0e7836ULL, 0x004fe20000000000ULL,
0x000000092c00720cULL, 0x000fe20003f86070ULL, 0x000000080c0d7824ULL, 0x040fe200078e00ffULL,
0x000000250c0a7212ULL, 0x000fe200078e3cffULL, 0x000000080e187824ULL, 0x000fe200078e00ffULL,
0x000000090c00720cULL, 0x000fc40003fa6070ULL, 0x000000250e0b7212ULL, 0x040fe400078e3cffULL,
0x000000090e00720cULL, 0x000fe40003fc6070ULL, 0x0000007f24247812ULL, 0x000fe400078ec0ffULL,
0x0000007f26267812ULL, 0x000fe400078ec0ffULL, 0x0000007f28287812ULL, 0x000fe400078ec0ffULL,
0x0000007f2a2a7812ULL, 0x000fc400078ec0ffULL, 0x0000007f2c2c7812ULL, 0x000fe200078ec0ffULL,
0x0000000a280f7c36ULL, 0x000fe20008000000ULL, 0x0000007f0c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000a2a117c36ULL, 0x008fe20008000000ULL, 0x0000007f0e0e7812ULL, 0x000fe200078ec0ffULL,
0x0000000a2c137c36ULL, 0x010fe20008000000ULL, 0xfffffff80d167812ULL, 0x000fe200078ee20aULL,
0x0000000a260d7c36ULL, 0x000fe20008000000ULL, 0xfffffff818187812ULL, 0x000fe200078ee20bULL,
0x0000000a240b7c36ULL, 0x000fe20008000000ULL, 0x0000000b161b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a0c157c36ULL, 0x002fe20008000000ULL, 0x0000000b181d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a0e097c36ULL, 0x000fc40008000000ULL, 0x000001000b0a7825ULL, 0x000fc800078e0002ULL,
0x000001000d0c7825ULL, 0x000fc800078e0002ULL, 0x000001000f0e7825ULL, 0x000fc800078e0002ULL,
0x0000010011107825ULL, 0x000fc800078e0002ULL, 0x0000010013127825ULL, 0x000fc800078e0002ULL,
0x0000010015147825ULL, 0x000fc800078e0002ULL, 0x0000010009027825ULL, 0x000fe200078e0002ULL,
0x0000000b06097c11ULL, 0x000fc6000f8e20ffULL, 0x00000010050a7825ULL, 0x000fc800078e000aULL,
0x00000010050c7825ULL, 0x040fe200078e000cULL, 0x000000000a097faeULL, 0x0003e6000c101c52ULL,
0x00000010050e7825ULL, 0x040fe200078e000eULL, 0x000000000c077faeULL, 0x0003e6000c901c52ULL,
0x0000001005107825ULL, 0x000fc800078e0010ULL, 0x0000001005127825ULL, 0x000fc800078e0012ULL,
0x0000001005147825ULL, 0x000fc800078e0014ULL, 0x0000001005027825ULL, 0x000fe200078e0002ULL,
0x0000000b04057c11ULL, 0x000fca000f8e20ffULL, 0x000000000e057faeULL, 0x0003e8000d101c52ULL,
0x0000000010177faeULL, 0x0003e8000d901c52ULL, 0x0000000012197faeULL, 0x0003e8000e101c52ULL,
0x00000000141b7faeULL, 0x0003e8000e901c52ULL, 0x00000000021d7faeULL, 0x0003e2000f101c52ULL,
0x0000000800b07947ULL, 0x000fea0003800000ULL, 0x0000000000187919ULL, 0x000e620000000000ULL,
0x00000003160f7899ULL, 0x000fe4000800063fULL, 0x00000008060c7291ULL, 0x000fe4000f8e783fULL,
0x0000000a0b0a72a4ULL, 0x000fe4000f8e020dULL, 0x0000000c160c7291ULL, 0x000fc8000f8e703fULL,
0x000130000c0c7890ULL, 0x000fe2000fffe03fULL, 0x00000003ff027819ULL, 0x002fe40000011618ULL,
0x0ffffff818037812ULL, 0x000fe400078ec0ffULL, 0x0000001802007212ULL, 0x0c0fe200078e3cffULL,
0x0000000c02177836ULL, 0x040fe20000000000ULL, 0x0000007f02137812ULL, 0x040fe200078ec0ffULL,
0x0000000402157836ULL, 0x040fe20000000000ULL, 0x0000000703147812ULL, 0x000fe200078ef800ULL,
0x0000000802167836ULL, 0x000fe20000000000ULL, 0x0000001817107212ULL, 0x0c0fe200078e3cffULL,
0x0000000817037824ULL, 0x000fe200078e00ffULL, 0x0000001815097212ULL, 0x0c0fe200078e3cffULL,
0x0000000815047824ULL, 0x000fe200078e00ffULL, 0x0000001816117212ULL, 0x080fe200078e3cffULL,
0x00000014021b7836ULL, 0x040fe20000000000ULL, 0xfffffff803107812ULL, 0x000fe200078ee210ULL,
0x0000001002197836ULL, 0x000fe20000000000ULL, 0xfffffff804097812ULL, 0x000fe200078ee209ULL,
0x0000000816007824ULL, 0x000fe200078e00ffULL, 0x000000181b0e7212ULL, 0x080fe200078e3cffULL,
0x0000001c021f7836ULL, 0x040fe20000000000ULL, 0x00000018190f7212ULL, 0x080fe200078e3cffULL,
0x00000018021d7836ULL, 0x040fe20000000000ULL, 0xfffffff800117812ULL, 0x000fe200078ee211ULL,
0x000000081b037824ULL, 0x000fe200078e00ffULL, 0x000000181f0c7212ULL, 0x080fe200078e3cffULL,
0x0000000819047824ULL, 0x000fe200078e00ffULL, 0x000000181d0d7212ULL, 0x080fe200078e3cffULL,
0x000000081f057824ULL, 0x000fe200078e00ffULL, 0xfffffff8030e7812ULL, 0x000fe200078ee20eULL,
0x0000002402237836ULL, 0x040fe20000000000ULL, 0xfffffff8040f7812ULL, 0x000fe200078ee20fULL,
0x000000081d007824ULL, 0x000fe200078e00ffULL, 0xfffffff8050c7812ULL, 0x000fe200078ee20cULL,
0x0000002002217836ULL, 0x040fe20000000000ULL, 0x00000018230a7212ULL, 0x0c0fe200078e3cffULL,
0x0000002802257836ULL, 0x040fe20000000000ULL, 0xfffffff8000d7812ULL, 0x000fe200078ee20dULL,
0x0000000823037824ULL, 0x000fe200078e00ffULL, 0x00000018210b7212ULL, 0x0c0fe200078e3cffULL,
0x0000000821047824ULL, 0x000fe200078e00ffULL, 0x0000001825007212ULL, 0x0c0fe200078e3cffULL,
0x0000000825057824ULL, 0x000fe200078e00ffULL, 0xfffffff8030a7812ULL, 0x000fe200078ee20aULL,
0x0000002c02277836ULL, 0x040fe20000000000ULL, 0xfffffff8040b7812ULL, 0x000fe200078ee20bULL,
0x0000003002297836ULL, 0x040fe20000000000ULL, 0xfffffff805007812ULL, 0x000fe200078ee200ULL,
0x0000000827037824ULL, 0x040fe200078e00ffULL, 0x0000001827047212ULL, 0x080fe200078e3cffULL,
0x0000000829087824ULL, 0x040fe200078e00ffULL, 0x0000001829057212ULL, 0x080fe200078e3cffULL,
0x0000003c022f7836ULL, 0x040fe20000000000ULL, 0xfffffff803047812ULL, 0x000fe200078ee204ULL,
0x00000034022b7836ULL, 0x040fe20000000000ULL, 0xfffffff808057812ULL, 0x000fe200078ee205ULL,
0x00000038022d7836ULL, 0x000fe20000000000ULL, 0x000000032f037819ULL, 0x000fe200000006ffULL,
0x000000082b077824ULL, 0x000fe200078e00ffULL, 0x000000182f087212ULL, 0x080fe200078e3cffULL,
0x000000082d127824ULL, 0x000fe200078e00ffULL, 0x000000182b067212ULL, 0x000fe200078e3cffULL,
0x0000000a13137c36ULL, 0x000fe20008000000ULL, 0xfffffff803087812ULL, 0x000fc400078ee208ULL,
0x00008a00ff027b82ULL, 0x000e620000000a00ULL, 0xfffffff807067812ULL, 0x000fe400078ee206ULL,
0x000000182d077212ULL, 0x000fe400078e3cffULL, 0x0000007f15157812ULL, 0x000fe400078ec0ffULL,
0xfffffff812077812ULL, 0x000fe200078ee207ULL, 0x0000000fff127e24ULL, 0x000fe2000f8e00ffULL,
0x0000007f16167812ULL, 0x000fe400078ec0ffULL, 0x0000007f191a7812ULL, 0x000fc400078ec0ffULL,
0xfffffff812127812ULL, 0x000fe200078ee218ULL, 0x0000000a16197c36ULL, 0x000fe20008000000ULL,
0x0000007f17187812ULL, 0x000fe200078ec0ffULL, 0x0000000a15177c36ULL, 0x000fe20008000000ULL,
0x0000007f1b1c7812ULL, 0x000fe400078ec0ffULL, 0x0000007f1d1e7812ULL, 0x000fe200078ec0ffULL,
0x0000000a181b7c36ULL, 0x000fe20008000000ULL, 0x0000007f1f207812ULL, 0x000fe200078ec0ffULL,
0x0000000a1a1d7c36ULL, 0x000fe20008000000ULL, 0x0000007f21227812ULL, 0x000fe200078ec0ffULL,
0x0000000a1c1f7c36ULL, 0x000fe20008000000ULL, 0x0000007f23247812ULL, 0x000fe200078ec0ffULL,
0x0000010017167825ULL, 0x002fe200078e0002ULL, 0x0000007f25267812ULL, 0x000fc400078ec0ffULL,
0x0000007f27287812ULL, 0x000fe200078ec0ffULL, 0x0000000a1e217c36ULL, 0x000fe20008000000ULL,
0x0000007f292a7812ULL, 0x000fe200078ec0ffULL, 0x0000010019187825ULL, 0x100fe200078e0002ULL,
0x0000007f2b2c7812ULL, 0x000fe400078ec0ffULL, 0x0000007f2d2e7812ULL, 0x000fe200078ec0ffULL,
0x0000000a20237c36ULL, 0x000fe20008000000ULL, 0x0000000c14337c11ULL, 0x000fe2000f8e20ffULL,
0x0000010013147825ULL, 0x000fe200078e0002ULL, 0x0000007f2f307812ULL, 0x000fc400078ec0ffULL,
0x0000000c09097c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a22257c36ULL, 0x000fe20008000000ULL,
0x0000000c11117c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a24277c36ULL, 0x000fe20008000000ULL,
0x0000000c0f0f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a26297c36ULL, 0x000fe20008000000ULL,
0x0000000c0d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a282b7c36ULL, 0x000fe20008000000ULL,
0x0000000c0b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a2a2d7c36ULL, 0x000fe20008000000ULL,
0x0000000c0a357c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a2c2f7c36ULL, 0x000fe20008000000ULL,
0x0000000c00377c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a2e317c36ULL, 0x000fe20008000000ULL,
0x0000000c05057c11ULL, 0x000fe2000f8e20ffULL, 0x000001001b1a7825ULL, 0x000fe200078e0002ULL,
0x0000000c07077c11ULL, 0x000fc6000f8e20ffULL, 0x0000000a30137c36ULL, 0x000fe40008000000ULL,
0x000001001d1c7825ULL, 0x000fc800078e0002ULL, 0x0000001012147825ULL, 0x000fc800078e0014ULL,
0x000001001f1e7825ULL, 0x100fe200078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014337faeULL, 0x0003e6000b901c52ULL, 0x0000010021207825ULL, 0x000fc800078e0002ULL,
0x0000010023227825ULL, 0x000fc800078e0002ULL, 0x0000010025247825ULL, 0x100fe200078e0002ULL,
0x0000000c0e157c11ULL, 0x002fe4000f8e20ffULL, 0x0000000c0c337c11ULL, 0x000fe2000f8e20ffULL,
0x0000010027267825ULL, 0x000fc800078e0002ULL, 0x0000010029287825ULL, 0x000fc800078e0002ULL,
0x000001002b2a7825ULL, 0x000fc800078e0002ULL, 0x000001002d2c7825ULL, 0x000fc800078e0002ULL,
0x000001002f2e7825ULL, 0x000fc800078e0002ULL, 0x0000010031307825ULL, 0x000fc800078e0002ULL,
0x0000001012167825ULL, 0x000fc800078e0016ULL, 0x0000010013027825ULL, 0x000fe200078e0002ULL,
0x0000000c10137c11ULL, 0x000fe2000f8e20ffULL, 0x0000000016097faeULL, 0x0003e4000b901c52ULL,
0x0000001012187825ULL, 0x000fc800078e0018ULL, 0x00000010121a7825ULL, 0x040fe200078e001aULL,
0x0000000018117faeULL, 0x0005e6000b901c52ULL, 0x00000010121c7825ULL, 0x000fe200078e001cULL,
0x000000001a137faeULL, 0x000fe2000b901c52ULL, 0x0000000c04097c11ULL, 0x002fe4000f8e20ffULL,
0x00000010121e7825ULL, 0x040fe200078e001eULL, 0x000000001c0f7faeULL, 0x0003e6000b901c52ULL,
0x0000001012207825ULL, 0x000fe200078e0020ULL, 0x000000001e157faeULL, 0x0007e2000b901c52ULL,
0x0000000c08117c11ULL, 0x004fc4000f8e20ffULL, 0x0000001012227825ULL, 0x040fe200078e0022ULL,
0x00000000200d7faeULL, 0x0007e6000b901c52ULL, 0x0000001012247825ULL, 0x000fe200078e0024ULL,
0x0000000022337faeULL, 0x0007e2000b901c52ULL, 0x0000000c060f7c11ULL, 0x002fe4000f8e20ffULL,
0x0000001012267825ULL, 0x040fe200078e0026ULL, 0x00000000240b7faeULL, 0x0007e6000b901c52ULL,
0x0000001012287825ULL, 0x040fe200078e0028ULL, 0x0000000026357faeULL, 0x0007e6000b901c52ULL,
0x00000010122a7825ULL, 0x040fe200078e002aULL, 0x0000000028377faeULL, 0x0007e6000b901c52ULL,
0x00000010122c7825ULL, 0x040fe200078e002cULL, 0x000000002a097faeULL, 0x0007e6000b901c52ULL,
0x00000010122e7825ULL, 0x040fe200078e002eULL, 0x000000002c057faeULL, 0x0007e6000b901c52ULL,
0x0000001012307825ULL, 0x040fe200078e0030ULL, 0x000000002e0f7faeULL, 0x0007e6000b901c52ULL,
0x0000001012027825ULL, 0x000fe200078e0002ULL, 0x0000000030077faeULL, 0x0007e8000b901c52ULL,
0x0000000002117faeULL, 0x0007e4000b901c52ULL, 0x000000010e0a7892ULL, 0x000fe2000f8ec03fULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff151a7891ULL, 0x000fe4000f8e083fULL,
0x000000010a00788cULL, 0x000fc8000bf05070ULL, 0x000000011a0a7887ULL, 0x000fc8000c000000ULL,
0x0000000a0e0a7290ULL, 0x000fc8000fffe03fULL, 0x000000070a00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fca0003f0f008ULL, 0x00000001040b8899ULL, 0x000fe2000800063fULL,
0x00009000000c8ab9ULL, 0x000fc60000000800ULL, 0x0000000c0b0b82a4ULL, 0x000fc6000f8e020cULL,
0x00008c00000c8ab9ULL, 0x000fe20000000a00ULL, 0x0000000a0b0b8290ULL, 0x000fc8000fffe03fULL,
0x000000040b0c88a5ULL, 0x000fcc000f8e000cULL, 0x0000000cff027e24ULL, 0x00afe4000f8e00ffULL,
0x0000000dff037e24ULL, 0x000fca000f8e00ffULL, 0x0000001202028981ULL, 0x000ea2000c1e1900ULL,
0xffffffff00187882ULL, 0x000fe20000000000ULL, 0xff317217ff007424ULL, 0x000fe200078e00ffULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x000000ffff497224ULL, 0x000fe200078e00ffULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fc4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000020b82caULL, 0x004fc400000e0000ULL,
0x000000054a007c0cULL, 0x000fd6000bf06070ULL, 0x0000000b00188c82ULL, 0x000fe40008000000ULL,
0x0000004000b00947ULL, 0x000fea0003800000ULL, 0x00007610ff027816ULL, 0x000fe20000000002ULL,
0x00000001040b7899ULL, 0x000fe2000800063fULL, 0xff317217ff007424ULL, 0x000fe200078e00ffULL,
0x00000008061c7291ULL, 0x000fe2000f8e203fULL, 0x000000ffff337224ULL, 0x000fe200078e00ffULL,
0x0000040201007387ULL, 0x0003e20000100600ULL, 0x0000900000047ab9ULL, 0x000fe40000000800ULL,
0x000000040b0b72a4ULL, 0x000fc6000f8e0204ULL, 0x0000003f00047c82ULL, 0x000fd20008000000ULL,
0x000000004a0d72caULL, 0x000fe200000e0000ULL, 0x00000005140f7899ULL, 0x000fc8000800063fULL,
0xffffffc00f0f7892ULL, 0x000fd0000f8ec03fULL, 0x0000000f0d0d7291ULL, 0x000fc8000f8e403fULL,
0x000000170d00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000004000540947ULL, 0x000fea0003800000ULL, 0x000000014a027836ULL, 0x002fe20000000000ULL,
0x0000000000427919ULL, 0x000e620000000000ULL, 0x000000800d0d7890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000502007c0cULL, 0x000fe2000bf06070ULL,
0x00000004000c7c82ULL, 0x000fe20008000000ULL, 0x0000000104047892ULL, 0x000fe4000f8e0c3fULL,
0x0000004009107892ULL, 0x000fd2000f8ef80dULL, 0x0000000c00248947ULL, 0x000fea0003800000ULL,
0x0000000d1700728cULL, 0x000fe2000bf01070ULL, 0x00000003ff027819ULL, 0x002fe20000011642ULL,
0x8000000dff3d7e24ULL, 0x000fe2000f8e02ffULL, 0x0000000316197899ULL, 0x000fe2000800063fULL,
0x0000000742407812ULL, 0x000fe200078ec0ffULL, 0x0000000d170e7287ULL, 0x000fe2000c000000ULL,
0x0000000402037836ULL, 0x040fe20000000000ULL, 0x0000840000117ab9ULL, 0x000fe20000000800ULL,
0x0000001402077836ULL, 0x040fe20000000000ULL, 0x0000000711117899ULL, 0x000fe2000800063fULL,
0x0000000803057824ULL, 0x040fe200078e00ffULL, 0x0000004203667212ULL, 0x080fe200078e3cffULL,
0x0000000eff047e24ULL, 0x000fe2000f8e00ffULL, 0x0000004207557212ULL, 0x0c0fe200078e3cffULL,
0x00000008070e7824ULL, 0x000fe200078e00ffULL, 0xfffffff805667812ULL, 0x000fe200078ee266ULL,
0x0000001002067836ULL, 0x000fe20000000000ULL, 0x00000040043d7446ULL, 0x000fe2000380003dULL,
0x0000000802047836ULL, 0x040fe20000000000ULL, 0xfffffff80e557812ULL, 0x000fe200078ee255ULL,
0x0000000c02057836ULL, 0x000fe20000000000ULL, 0x0000004206577212ULL, 0x080fe200078e3cffULL,
0x0000000804087824ULL, 0x040fe200078e00ffULL, 0x00000042045b7212ULL, 0x080fe200078e3cffULL,
0x0000001c02097836ULL, 0x000fe20000000000ULL, 0x0000000e140e7899ULL, 0x000fe2000800063fULL,
0x00000008060c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8085b7812ULL, 0x000fe200078ee25bULL,
0x00000008050a7824ULL, 0x040fe200078e00ffULL, 0x0000004205597212ULL, 0x080fe200078e3cffULL,
0x00000008090e7824ULL, 0x040fe200078e00ffULL, 0x0000004209517212ULL, 0x080fe200078e3cffULL,
0x0000001802087836ULL, 0x040fe20000000000ULL, 0xfffffff80c577812ULL, 0x000fe200078ee257ULL,
0x0000002c02367836ULL, 0x000fe20000000000ULL, 0x00000008060d7291ULL, 0x000fe2000f8e783fULL,
0xfffffff80a597812ULL, 0x000fe200078ee259ULL, 0x000040000e0e7892ULL, 0x000fe2000f8ec03fULL,
0x00000008080c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e517812ULL, 0x000fe200078ee251ULL,
0x00000020020a7836ULL, 0x000fe20000000000ULL, 0x0000004208537212ULL, 0x080fe200078e3cffULL,
0x00000008360e7824ULL, 0x000fe200078e00ffULL, 0x00000042020d7212ULL, 0x0c0fe200078e3cffULL,
0x00000019ff2d7e24ULL, 0x000fe2000f8e00ffULL, 0x00000018111872a4ULL, 0x000fe2000f8e0210ULL,
0x0000002802377836ULL, 0x000fe20000000000ULL, 0x00000042366f7212ULL, 0x080fe200078e3cffULL,
0x0000000e0d107290ULL, 0x000fe2000fffe03fULL, 0x0000007f025d7812ULL, 0x000fe200078ec0ffULL,
0x000000080a2c7824ULL, 0x040fe200078e00ffULL, 0xfffffff80c537812ULL, 0x000fe200078ee253ULL,
0x00008a00001e7ab9ULL, 0x000fe20000000a00ULL, 0x000000070d647812ULL, 0x000fe200078ec0ffULL,
0x00000008370c7824ULL, 0x000fe200078e00ffULL, 0x000000420a4f7212ULL, 0x080fe200078e3cffULL,
0x0000001fff0f7e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff80e6f7812ULL, 0x000fe200078ee26fULL,
0x0000001eff0e7e24ULL, 0x000fe2000f8e00ffULL, 0x000000082d0d7812ULL, 0x000fe200078ee240ULL,
0x000000185d2d7c36ULL, 0x000fe20008000000ULL, 0x00000042374b7212ULL, 0x080fe200078e3cffULL,
0x0000001004107291ULL, 0x000fe2000f8e683fULL, 0x0000003d0200720cULL, 0x040fe20003f06070ULL,
0x0000003402347836ULL, 0x040fe20000000000ULL, 0xfffffff82c4f7812ULL, 0x000fe200078ee24fULL,
0x000001002d2c7825ULL, 0x000fe200078e000eULL, 0xfffffff80c4b7812ULL, 0x000fe200078ee24bULL,
0x0001300010107890ULL, 0x000fe2000fffe03fULL, 0x0ffffff864647812ULL, 0x000fe200078ef842ULL,
0x0000003c020c7836ULL, 0x000fe20000000000ULL, 0x00000042346a7212ULL, 0x080fe200078e3cffULL,
0x0000002402447836ULL, 0x040fe20000000000ULL, 0x0000007f035c7812ULL, 0x000fe200078ec0ffULL,
0x00000038020b7836ULL, 0x000fe20000000000ULL, 0x000000420c687212ULL, 0x000fe200078e3cffULL,
0x0000000834397824ULL, 0x000fe200078e00ffULL, 0x00000010642f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000080c3b7824ULL, 0x000fe200078e00ffULL, 0x0000007f04657812ULL, 0x000fe200078ec0ffULL,
0x000000100d2c7825ULL, 0x000fe200078e002cULL, 0x0000007f055a7812ULL, 0x000fc400078ec0ffULL,
0x00000042444d7212ULL, 0x0c0fe200078e3cffULL, 0x00000008442e7824ULL, 0x000fe200078e00ffULL,
0x000000420b697212ULL, 0x040fe200078e3cffULL, 0x000000080b387824ULL, 0x000fe200078e00ffULL,
0xfffffff8396a7812ULL, 0x000fe200078ee26aULL, 0x0000003002357836ULL, 0x000fe20000000000ULL,
0xfffffff83b687812ULL, 0x000fe200078ee268ULL, 0x000000185c397c36ULL, 0x000fe20008000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000c101c52ULL,
0x0000007f06587812ULL, 0x000fe200078ec0ffULL, 0x00000018653b7c36ULL, 0x000fe20008000000ULL,
0x0000003d0300720cULL, 0x080fe20003f06070ULL, 0x000000185a3f7c36ULL, 0x000fe20008000000ULL,
0xfffffff82e4d7812ULL, 0x000fe200078ee24dULL, 0x00000008352e7824ULL, 0x000fe200078e00ffULL,
0xfffffff838697812ULL, 0x000fe200078ee269ULL, 0x0000010039387825ULL, 0x000fe200078e000eULL,
0x0000003d0400720cULL, 0x000fc40003f26070ULL, 0x0000003d0500720cULL, 0x000fe20003f46070ULL,
0x000001003b3a7825ULL, 0x100fe200078e000eULL, 0x00000042356b7212ULL, 0x000fe400078e3cffULL,
0x0000007f07567812ULL, 0x000fe200078ec0ffULL, 0x0000001858417c36ULL, 0x000fe20008000000ULL,
0xfffffff82e6b7812ULL, 0x000fe200078ee26bULL, 0x000001003f2c7825ULL, 0x102fe200078e000eULL,
0x00000010663f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001059437c11ULL, 0x000fe2000f8e20ffULL,
0x00000100412e7825ULL, 0x000fe200078e000eULL, 0x000000105b417c11ULL, 0x000fc4000f8e20ffULL,
0x0000003d0600720cULL, 0x080fe20003f66070ULL, 0x000000100d387825ULL, 0x000fe200078e0038ULL,
0x0000007f08547812ULL, 0x000fe400078ec0ffULL, 0x0000007f09527812ULL, 0x000fe200078ec0ffULL,
0x000000100d3a7825ULL, 0x000fe200078e003aULL, 0x00000000383f7faeULL, 0x0003e2000c101c52ULL,
0x0000003d0700720cULL, 0x000fe40003f06070ULL, 0x000000100d2c7825ULL, 0x000fe200078e002cULL,
0x000000003a417faeULL, 0x0005e2000c901c52ULL, 0x0000007f0a507812ULL, 0x000fc400078ec0ffULL,
0x0000001856477c36ULL, 0x000fe20008000000ULL, 0x000000002c437faeULL, 0x0007e2000d101c52ULL,
0x000000100d2e7825ULL, 0x000fe200078e002eULL, 0x0000001057457c11ULL, 0x000fe4000f8e20ffULL,
0x0000007f444e7812ULL, 0x000fe200078ec0ffULL, 0x0000001854397c36ULL, 0x002fe20008000000ULL,
0x00000010553f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000002e457faeULL, 0x0003e2000d901c52ULL,
0x00000018523b7c36ULL, 0x004fe20008000000ULL, 0x0000003d0800720cULL, 0x080fe20003f26070ULL,
0x0000001850417c36ULL, 0x000fe20008000000ULL, 0x0000003d0900720cULL, 0x080fe20003f46070ULL,
0x00000100472c7825ULL, 0x008fe200078e000eULL, 0x0000003d0a00720cULL, 0x000fc40003f66070ULL,
0x0000001051437c11ULL, 0x000fe2000f8e20ffULL, 0x000000184e477c36ULL, 0x000fe20008000000ULL,
0x0000007f374c7812ULL, 0x000fe200078ec0ffULL, 0x000000100d2c7825ULL, 0x000fe200078e002cULL,
0x000000104f457c11ULL, 0x002fe4000f8e20ffULL, 0x0000007f36637812ULL, 0x000fe200078ec0ffULL,
0x00000100392e7825ULL, 0x100fe200078e000eULL, 0x000000002c3f7faeULL, 0x0003e2000c101c52ULL,
0x0000003d4400720cULL, 0x000fe40003f06070ULL, 0x000001003b387825ULL, 0x000fe200078e000eULL,
0x0000007f35627812ULL, 0x000fc400078ec0ffULL, 0x0000007f34617812ULL, 0x000fe200078ec0ffULL,
0x00000100413a7825ULL, 0x000fe200078e000eULL, 0x0000001053417c11ULL, 0x000fe4000f8e20ffULL,
0x0000007f0b607812ULL, 0x000fe200078ec0ffULL, 0x000000100d2e7825ULL, 0x000fe200078e002eULL,
0x000000104d3f7c11ULL, 0x002fe4000f8e20ffULL, 0x0000007f0c5e7812ULL, 0x000fe200078ec0ffULL,
0x00000100472c7825ULL, 0x000fe200078e000eULL, 0x000000002e417faeULL, 0x0003e2000c901c52ULL,
0x0000003d3700720cULL, 0x000fc40003f26070ULL, 0x000000100d387825ULL, 0x000fe200078e0038ULL,
0x0000003d3400720cULL, 0x080fe40003f86070ULL, 0x0000003d0b00720cULL, 0x080fe20003fa6070ULL,
0x000000100d3a7825ULL, 0x040fe200078e003aULL, 0x0000000038437faeULL, 0x0005e2000d101c52ULL,
0x0000003d3600720cULL, 0x080fe40003f46070ULL, 0x000000100d2c7825ULL, 0x000fe200078e002cULL,
0x000000003a457faeULL, 0x0007e2000d901c52ULL, 0x0000003d3500720cULL, 0x000fc40003f66070ULL,
0x000000184c2f7c36ULL, 0x002fe20008000000ULL, 0x0000003d0c00720cULL, 0x000fe20003fc6070ULL,
0x000000002c3f7faeULL, 0x0003e2000c101c52ULL, 0x00000018613d7c36ULL, 0x000fe20008000000ULL,
0x000000104b417c11ULL, 0x000fe2000f8e20ffULL, 0x0000001863397c36ULL, 0x004fe20008000000ULL,
0x000000106a477c11ULL, 0x000fe2000f8e20ffULL, 0x000001002f2e7825ULL, 0x000fe200078e000eULL,
0x00000010695f7c11ULL, 0x000fe4000f8e20ffULL, 0x000000106b457c11ULL, 0x008fe2000f8e20ffULL,
0x00000018623b7c36ULL, 0x000fe20008000000ULL, 0x0000001068677c11ULL, 0x000fe2000f8e20ffULL,
0x000000185e437c36ULL, 0x000fc40008000000ULL, 0x00000018603f7c36ULL, 0x002fe40008000000ULL,
0x00000100392c7825ULL, 0x000fc800078e000eULL, 0x000001003b387825ULL, 0x000fc800078e000eULL,
0x000001003d3a7825ULL, 0x000fc800078e000eULL, 0x000001003f3c7825ULL, 0x000fc800078e000eULL,
0x00000100433e7825ULL, 0x000fe200078e000eULL, 0x000000106f437c11ULL, 0x000fc6000f8e20ffULL,
0x000000100d2e7825ULL, 0x000fc800078e002eULL, 0x000000100d2c7825ULL, 0x040fe200078e002cULL,
0x000000002e417faeULL, 0x0003e6000c901c52ULL, 0x000000100d387825ULL, 0x040fe200078e0038ULL,
0x000000002c437faeULL, 0x0003e6000d101c52ULL, 0x000000100d3a7825ULL, 0x040fe200078e003aULL,
0x0000000038457faeULL, 0x0003e6000d901c52ULL, 0x000000100d3c7825ULL, 0x040fe200078e003cULL,
0x000000003a477faeULL, 0x0003e6000e101c52ULL, 0x000000100d3e7825ULL, 0x000fe200078e003eULL,
0x000000003c5f7faeULL, 0x0003e8000e901c52ULL, 0x000000003e677faeULL, 0x0003e2000f101c52ULL,
0x0000000800c47947ULL, 0x000fea0003800000ULL, 0x00000003ff027819ULL, 0x002fe20000011642ULL,
0x0000000316197899ULL, 0x000fe2000800063fULL, 0x0000000742407812ULL, 0x000fe200078ec0ffULL,
0x0000840000117ab9ULL, 0x000fe20000000800ULL, 0x0000000e140e7899ULL, 0x000fe2000800063fULL,
0x0000000402037836ULL, 0x040fe20000000000ULL, 0x0000000711117899ULL, 0x000fe2000800063fULL,
0x0000001c02097836ULL, 0x040fe20000000000ULL, 0x00000008060d7291ULL, 0x000fe2000f8e783fULL,
0x0000000803077824ULL, 0x040fe200078e00ffULL, 0x0000004203667212ULL, 0x080fe200078e3cffULL,
0x0000000802047836ULL, 0x040fe20000000000ULL, 0x0000004209517212ULL, 0x080fe200078e3cffULL,
0x0000000c02057836ULL, 0x040fe20000000000ULL, 0xfffffff807667812ULL, 0x000fe200078ee266ULL,
0x0000001402077836ULL, 0x000fe20000000000ULL, 0x00000042045b7212ULL, 0x0c0fe200078e3cffULL,
0x0000000804087824ULL, 0x000fe200078e00ffULL, 0x0000004205597212ULL, 0x080fe200078e3cffULL,
0x00000008070e7824ULL, 0x040fe200078e00ffULL, 0x0000004207557212ULL, 0x080fe200078e3cffULL,
0x0000001002067836ULL, 0x000fe20000000000ULL, 0xfffffff8085b7812ULL, 0x000fe200078ee25bULL,
0x00000008050a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e557812ULL, 0x000fe200078ee255ULL,
0x00000008090e7824ULL, 0x000fe200078e00ffULL, 0x0000004206577212ULL, 0x0c0fe200078e3cffULL,
0x00000008060c7824ULL, 0x000fe200078e00ffULL, 0x0000001802087810ULL, 0x000fe20007ffe0ffULL,
0x000040000e0e7892ULL, 0x000fe2000f8ec03fULL, 0xfffffff80e517812ULL, 0x000fe200078ee251ULL,
0x0000002802377836ULL, 0x040fe20000000000ULL, 0x00008a00ff0e7b82ULL, 0x000e620000000a00ULL,
0xfffffff80a597812ULL, 0x000fe200078ee259ULL, 0x00000020020a7836ULL, 0x000fe20000000000ULL,
0xfffffff80c577812ULL, 0x000fe200078ee257ULL, 0x00000008080c7824ULL, 0x040fe200078e00ffULL,
0x0000004208537212ULL, 0x080fe200078e3cffULL, 0x000000080a2c7824ULL, 0x040fe200078e00ffULL,
0x000000420a4f7212ULL, 0x080fe200078e3cffULL, 0x0000002c02367836ULL, 0x040fe20000000000ULL,
0x00000042020d7212ULL, 0x0c0fe200078e3cffULL, 0x00000019ff2d7e24ULL, 0x000fe2000f8e00ffULL,
0x00000018111072a4ULL, 0x000fe2000f8e0210ULL, 0x0000007f025d7812ULL, 0x000fe200078ec0ffULL,
0x0000000e0d187290ULL, 0x000fe2000fffe03fULL, 0xfffffff80c537812ULL, 0x000fe200078ee253ULL,
0x00000008370c7824ULL, 0x040fe200078e00ffULL, 0xfffffff82c4f7812ULL, 0x000fe200078ee24fULL,
0x00000008362c7824ULL, 0x000fe200078e00ffULL, 0x00000042374b7212ULL, 0x080fe200078e3cffULL,
0x0000001804187291ULL, 0x000fe2000f8e683fULL, 0x000000070d647812ULL, 0x000fe200078ec0ffULL,
0x0000003402347836ULL, 0x000fe20000000000ULL, 0x00000042366f7212ULL, 0x000fe200078e3cffULL,
0x0001300018187890ULL, 0x000fe2000fffe03fULL, 0x000000082d0d7812ULL, 0x000fe200078ee240ULL,
0x000000105d2d7c36ULL, 0x000fe20008000000ULL, 0xfffffff80c4b7812ULL, 0x000fe200078ee24bULL,
0x0000003c020c7836ULL, 0x000fe20000000000ULL, 0xfffffff82c6f7812ULL, 0x000fe200078ee26fULL,
0x000001002d2c7825ULL, 0x002fe200078e000eULL, 0x0ffffff864647812ULL, 0x000fc400078ef842ULL,
0x00000042346a7212ULL, 0x080fe200078e3cffULL, 0x0000002402447836ULL, 0x000fe20000000000ULL,
0x0000007f035c7812ULL, 0x000fe200078ec0ffULL, 0x0000000834397824ULL, 0x000fe200078e00ffULL,
0x000000420c687212ULL, 0x080fe200078e3cffULL, 0x00000038020b7836ULL, 0x000fe20000000000ULL,
0x0000007f04657812ULL, 0x000fe200078ec0ffULL, 0x000000080c3b7824ULL, 0x000fe200078e00ffULL,
0x0000007f055a7812ULL, 0x000fe200078ec0ffULL, 0x00000008442e7824ULL, 0x000fe200078e00ffULL,
0x00000018642f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100d2c7825ULL, 0x000fe200078e002cULL,
0x00000042444d7212ULL, 0x000fc400078e3cffULL, 0xfffffff8396a7812ULL, 0x000fe200078ee26aULL,
0x000000080b387824ULL, 0x040fe200078e00ffULL, 0x000000420b697212ULL, 0x080fe200078e3cffULL,
0x0000003002357836ULL, 0x000fe20000000000ULL, 0xfffffff83b687812ULL, 0x000fe200078ee268ULL,
0x000000105c397c36ULL, 0x000fe20008000000ULL, 0x0000007f06587812ULL, 0x000fe200078ec0ffULL,
0x00000010653b7c36ULL, 0x000fe20008000000ULL, 0x0000007f07567812ULL, 0x000fe200078ec0ffULL,
0x000000105a3d7c36ULL, 0x000fe20008000000ULL, 0xfffffff82e4d7812ULL, 0x000fe200078ee24dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000b901c52ULL,
0x00000008352e7824ULL, 0x040fe200078e00ffULL, 0xfffffff838697812ULL, 0x000fe200078ee269ULL,
0x00000010583f7c36ULL, 0x000fe20008000000ULL, 0x00000042356b7212ULL, 0x000fe200078e3cffULL,
0x0000001056417c36ULL, 0x000fe20008000000ULL, 0x0000007f08547812ULL, 0x000fe200078ec0ffULL,
0x000001003d3c7825ULL, 0x000fe200078e000eULL, 0xfffffff82e6b7812ULL, 0x000fc400078ee26bULL,
0x0000007f09527812ULL, 0x000fe200078ec0ffULL, 0x00000010545f7c36ULL, 0x000fe20008000000ULL,
0x0000001859437c11ULL, 0x000fe2000f8e20ffULL, 0x00000100392c7825ULL, 0x102fe200078e000eULL,
0x0000007f0a507812ULL, 0x000fe400078ec0ffULL, 0x0000007f444e7812ULL, 0x000fe200078ec0ffULL,
0x000001003b387825ULL, 0x100fe200078e000eULL, 0x0000001857457c11ULL, 0x000fe4000f8e20ffULL,
0x0000007f374c7812ULL, 0x000fe200078ec0ffULL, 0x000001003f3a7825ULL, 0x000fe200078e000eULL,
0x00000018663f7c11ULL, 0x000fc4000f8e20ffULL, 0x0000001855477c11ULL, 0x000fe2000f8e20ffULL,
0x00000100412e7825ULL, 0x000fe200078e000eULL, 0x000000185b417c11ULL, 0x000fe4000f8e20ffULL,
0x0000007f36637812ULL, 0x000fe200078ec0ffULL, 0x000000100d2c7825ULL, 0x000fe200078e002cULL,
0x0000007f35627812ULL, 0x000fe400078ec0ffULL, 0x0000007f34617812ULL, 0x000fe200078ec0ffULL,
0x000000100d387825ULL, 0x000fe200078e0038ULL, 0x000000002c3f7faeULL, 0x0003e2000b901c52ULL,
0x0000007f0b607812ULL, 0x000fc400078ec0ffULL, 0x000000100d3c7825ULL, 0x040fe200078e003cULL,
0x0000000038417faeULL, 0x0005e2000b901c52ULL, 0x0000007f0c5e7812ULL, 0x000fe400078ec0ffULL,
0x000000100d3a7825ULL, 0x040fe200078e003aULL, 0x000000003c437faeULL, 0x0007e6000b901c52ULL,
0x000000100d2e7825ULL, 0x000fe200078e002eULL, 0x000000003a457faeULL, 0x000fe6000b901c52ULL,
0x00000010523f7c36ULL, 0x002fe20008000000ULL, 0x000000002e477faeULL, 0x0003e2000b901c52ULL,
0x0000001050417c36ULL, 0x004fc40008000000ULL, 0x000001005f2c7825ULL, 0x000fc800078e000eULL,
0x000000104e437c36ULL, 0x008fe40008000000ULL, 0x000001003f387825ULL, 0x100fe200078e000eULL,
0x00000018533f7c11ULL, 0x000fe4000f8e20ffULL, 0x000000184b477c11ULL, 0x002fe2000f8e20ffULL,
0x00000100413c7825ULL, 0x000fe200078e000eULL, 0x0000001851417c11ULL, 0x000fc6000f8e20ffULL,
0x000000104c457c36ULL, 0x000fe40008000000ULL, 0x00000100433a7825ULL, 0x000fe200078e000eULL,
0x000000184f437c11ULL, 0x000fc6000f8e20ffULL, 0x000000100d2c7825ULL, 0x000fc800078e002cULL,
0x00000100452e7825ULL, 0x000fe200078e000eULL, 0x000000184d457c11ULL, 0x000fe2000f8e20ffULL,
0x000000002c3f7faeULL, 0x0003e4000b901c52ULL, 0x000000100d387825ULL, 0x000fc800078e0038ULL,
0x000000100d3c7825ULL, 0x040fe200078e003cULL, 0x0000000038417faeULL, 0x0005e6000b901c52ULL,
0x000000100d3a7825ULL, 0x000fe200078e003aULL, 0x000000003c437faeULL, 0x0007e6000b901c52ULL,
0x00000010635f7c36ULL, 0x000fe20008000000ULL, 0x000000003a457faeULL, 0x0009e2000b901c52ULL,
0x00000010623f7c36ULL, 0x002fc40008000000ULL, 0x000000100d2e7825ULL, 0x000fc800078e002eULL,
0x0000001061417c36ULL, 0x004fe20008000000ULL, 0x000000002e477faeULL, 0x0003e2000b901c52ULL,
0x0000001060437c36ULL, 0x008fe40008000000ULL, 0x000001005f2c7825ULL, 0x000fc800078e000eULL,
0x000000105e457c36ULL, 0x010fe40008000000ULL, 0x000001003f387825ULL, 0x100fe200078e000eULL,
0x000000186f3f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001868477c11ULL, 0x002fe2000f8e20ffULL,
0x00000100413c7825ULL, 0x000fe200078e000eULL, 0x000000186b417c11ULL, 0x000fc6000f8e20ffULL,
0x00000100433a7825ULL, 0x000fe200078e000eULL, 0x000000186a437c11ULL, 0x000fc6000f8e20ffULL,
0x00000100452e7825ULL, 0x000fe200078e000eULL, 0x0000001869457c11ULL, 0x000fc6000f8e20ffULL,
0x000000100d2c7825ULL, 0x000fc800078e002cULL, 0x000000100d387825ULL, 0x040fe200078e0038ULL,
0x000000002c3f7faeULL, 0x0003e6000b901c52ULL, 0x000000100d3c7825ULL, 0x040fe200078e003cULL,
0x0000000038417faeULL, 0x0003e6000b901c52ULL, 0x000000100d3a7825ULL, 0x040fe200078e003aULL,
0x000000003c437faeULL, 0x0003e6000b901c52ULL, 0x000000100d2e7825ULL, 0x000fe200078e002eULL,
0x000000003a457faeULL, 0x0003e8000b901c52ULL, 0x000000002e477faeULL, 0x0003e4000b901c52ULL,
0x00000400012c7983ULL, 0x002ea20000100800ULL, 0x000000010a107892ULL, 0x000fc6000f8ec03fULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000011000788cULL, 0x000fc8000bf05070ULL,
0x000000011a187887ULL, 0x000fc8000c000000ULL, 0x000000180a0a7290ULL, 0x000fc8000fffe03fULL,
0x000000070a00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x0000000a0b1b8290ULL, 0x000fe2000fffe03fULL, 0x00008c0000188ab9ULL, 0x000fc60000000a00ULL,
0x000000041b1888a5ULL, 0x000fcc000f8e0018ULL, 0x00000019ff2d7e24ULL, 0x000fe2000f8e00ffULL,
0x00000001ff2e7819ULL, 0x000fe20000011642ULL, 0x00000010422f7824ULL, 0x000fe200078e00ffULL,
0x0000ffff2c2c7812ULL, 0x004fc800078ec0ffULL, 0x000000002c1072caULL, 0x000fe200000e0000ULL,
0x00000018ff2c7e24ULL, 0x000fca000f8e00ffULL, 0x000000122c678981ULL, 0x00036e000c1e1900ULL,
0x0000888010107896ULL, 0x000fc8000800003fULL, 0x0000001f101b7899ULL, 0x000fcc000800063fULL,
0x0000001bff387e24ULL, 0x000fc8000f8e00ffULL, 0x02360838ff0075a7ULL, 0x000ea2000802015cULL,
0x0000000806187291ULL, 0x000fe2000f8e383fULL, 0x000000702f2d7812ULL, 0x002fe400078ec0ffULL,
0x0000000c2e2c7812ULL, 0x000fc800078ec0ffULL, 0x000000182c5f7c10ULL, 0x000fe2000fffe02dULL,
0x000000c400d09947ULL, 0x004fec0003800000ULL, 0x023000005f2d7984ULL, 0x000e620000000800ULL,
0x0000000d161d7291ULL, 0x000fe2000f8e703fULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x00000008061b7291ULL, 0x000fe2000f8e583fULL, 0x0000000000737919ULL, 0x000ea20000000000ULL,
0x0000001d0c187291ULL, 0x000fe2000f8e683fULL, 0x023200005f5f7984ULL, 0x000ee20000000800ULL,
0x0000000840457812ULL, 0x004fe400078ef873ULL, 0x00000004ff417819ULL, 0x000fe40000011673ULL,
0x000000002d00720bULL, 0x002fc40003f3d000ULL, 0x00000008732f7812ULL, 0x000fe400078ec0ffULL,
0x0000000741787812ULL, 0x000fe400078e7845ULL, 0x000000402f487212ULL, 0x000fe400078efcffULL,
0x000000072f407812ULL, 0x000fe200078ec840ULL, 0x0000000845787824ULL, 0x000fc800078e0278ULL,
0x00000000002c7806ULL, 0x000fc800008e0100ULL, 0x0000ffff2c397812ULL, 0x000fda000782c0ffULL,
0x0000000000f49947ULL, 0x008fea0003800000ULL, 0x000000002d00720bULL, 0x000fe20003f34000ULL,
0x00000000003c7919ULL, 0x000e620000000000ULL, 0x0000002d003b7209ULL, 0x000fe20007810000ULL,
0x000000140600728cULL, 0x000fe2000bf25270ULL, 0x00000002ff2e7819ULL, 0x000fc60000011673ULL,
0x8000003b002c7221ULL, 0x000fe40000010000ULL, 0x000000082e2f7836ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f4f018ULL, 0x3fb8aa3b2c2c7820ULL, 0x000fe40000410000ULL,
0x0000000000007806ULL, 0x000fe200008e0100ULL, 0x0000000814069291ULL, 0x000fc6000f8e383fULL,
0x0000ffff00007812ULL, 0x000fe200078e3cffULL, 0x0000002c002c7308ULL, 0x000ea60000000800ULL,
0x0000000039ff7212ULL, 0x000fc8000782c0ffULL, 0x00000001ff387807ULL, 0x000fe20000800000ULL,
0x00001f2f2c2f7589ULL, 0x004eb000000e0000ULL, 0x8000003b2d2d1221ULL, 0x000fe20000010000ULL,
0x00000001ff3a7819ULL, 0x002fe2000001163cULL, 0x000000103c3c7824ULL, 0x000fe200078e00ffULL,
0x00001f2e2c2e7589ULL, 0x000e6200000e0000ULL, 0x3fb8aa3b2d2d1820ULL, 0x000fe20000410000ULL,
0x0000000c3a3a7812ULL, 0x000fe200078ec0ffULL, 0x0000002c49497220ULL, 0x000fe20000410000ULL,
0x000000703c3c7812ULL, 0x000fe200078ec0ffULL, 0x0000002d00701308ULL, 0x000ee60000000800ULL,
0x000000063a00ac10ULL, 0x000fca000fffe03cULL, 0x0234003b0000a388ULL, 0x0009e20000000800ULL,
0x0000002f33337220ULL, 0x084fe20000410000ULL, 0x0000002f32327220ULL, 0x080fe20000410000ULL,
0x0000002f13137220ULL, 0x080fe20000410000ULL, 0x0000002f12127220ULL, 0x080fe20000410000ULL,
0x0000002f17177220ULL, 0x080fe20000410000ULL, 0x0000002f16167220ULL, 0x080fe20000410000ULL,
0x0000002f1b1b7220ULL, 0x080fe20000410000ULL, 0x0000002f1a1a7220ULL, 0x080fe20000410000ULL,
0x0000002f1f1f7220ULL, 0x080fe20000410000ULL, 0x0000002f1e1e7220ULL, 0x080fe20000410000ULL,
0x0000002f23237220ULL, 0x080fe20000410000ULL, 0x0000002f22227220ULL, 0x080fe20000410000ULL,
0x0000002f27277220ULL, 0x080fe20000410000ULL, 0x0000002f26267220ULL, 0x080fe20000410000ULL,
0x0000002f2b2b7220ULL, 0x080fe20000410000ULL, 0x0000002f2a2a7220ULL, 0x000fe20000410000ULL,
0x0000002e31317220ULL, 0x082fe20000410000ULL, 0x0000002e30307220ULL, 0x080fe20000410000ULL,
0x0000002e11117220ULL, 0x080fe20000410000ULL, 0x0000002e10107220ULL, 0x080fe20000410000ULL,
0x0000002e15157220ULL, 0x080fe20000410000ULL, 0x0000002e14147220ULL, 0x080fe20000410000ULL,
0x0000002e19197220ULL, 0x080fe20000410000ULL, 0x0000002e18187220ULL, 0x080fe20000410000ULL,
0x0000002e1d1d7220ULL, 0x080fe20000410000ULL, 0x0000002e1c1c7220ULL, 0x080fe20000410000ULL,
0x0000002e21217220ULL, 0x080fe20000410000ULL, 0x0000002e20207220ULL, 0x080fe20000410000ULL,
0x0000002e25257220ULL, 0x080fe20000410000ULL, 0x0000002e24247220ULL, 0x080fe20000410000ULL,
0x0000002e29297220ULL, 0x080fe20000410000ULL, 0x0000002e28287220ULL, 0x000fe20000410000ULL,
0x000000ffff007224ULL, 0x010fc400078e003bULL, 0x000000705f5f1220ULL, 0x008fce0000410000ULL,
0x0000004140727212ULL, 0x000fe200078e3cffULL, 0x0001300018187890ULL, 0x000fe2000fffe03fULL,
0x0000001b782c7c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000848777824ULL, 0x000fe200078e0272ULL, 0x011000002c2c783bULL, 0x000fe20000000200ULL,
0x00000002ff3e7819ULL, 0x000fe20000011673ULL, 0x0000000241717836ULL, 0x040fe20000000000ULL,
0x00009910383d7816ULL, 0x000fe200000000ffULL, 0x00000006416d7836ULL, 0x000fe20000000000ULL,
0x0000001877397c11ULL, 0x000fe2000f8e20ffULL, 0x000000083e437836ULL, 0x000fe20000000000ULL,
0x00000070ff3c723eULL, 0x000fe200000000ffULL, 0x000000495f497221ULL, 0x000fe20000010000ULL,
0x000000ff3d00720cULL, 0x000fe20003f25270ULL, 0x000000013f067899ULL, 0x000fe20008011614ULL,
0x000000003938783bULL, 0x000fe20000004200ULL, 0x000054103c427816ULL, 0x000fc4000000003cULL,
0x00000071406e7212ULL, 0x040fe200078e3cffULL, 0x00000008061c7291ULL, 0x000fe2000f8e203fULL,
0x0000006d406d7212ULL, 0x000fe200078e3cffULL, 0x00001f4342467589ULL, 0x000e6200000e0000ULL,
0x00000000671982caULL, 0x020fe200000e0000ULL, 0x00000008487b7824ULL, 0x040fe200078e026eULL,
0x00000180485f7811ULL, 0x040fe200078e18ffULL, 0x00001f3e42477589ULL, 0x000ea200000e0000ULL,
0x00000008487c7824ULL, 0x000fe400078e026dULL, 0x000000187b3c7c11ULL, 0x000fcc000f8e20ffULL,
0x000000003c3c783bULL, 0x000ee20000004200ULL, 0x000000462d2d9232ULL, 0x082fe40000000000ULL,
0x000000462f2f9232ULL, 0x000fe40000000000ULL, 0x000000472c2c9232ULL, 0x084fe40000000000ULL,
0x000000472e2e9232ULL, 0x000fce0000000000ULL, 0x000000382c28723cULL, 0x000fec0000001828ULL,
0x0000003a2c24723cULL, 0x000fe20000001824ULL, 0x0000000441397836ULL, 0x000fe20000000000ULL,
0x000000187c387c11ULL, 0x000fc8000f8e20ffULL, 0x00000039406c7212ULL, 0x000fe400078e3cffULL,
0x000000003838783bULL, 0x000e620000004200ULL, 0x0000003c2c20723cULL, 0x008fe40000001820ULL,
0x00000008487a7824ULL, 0x000fca00078e026cULL, 0x000000187a417c11ULL, 0x000fe2000f8e20ffULL,
0x0000003e2c1c723cULL, 0x000fe2000000181cULL, 0x00000007713c7812ULL, 0x000fc800078e7845ULL,
0x000000004140783bULL, 0x000ea20000004200ULL, 0x00000008453c7824ULL, 0x000fca00078e023cULL,
0x0000001b3c747c11ULL, 0x000fca000f8e20ffULL, 0x0000007401007387ULL, 0x000fe20000100800ULL,
0x000000382c10723cULL, 0x002fec0000001810ULL, 0x0000003a2c30723cULL, 0x000fec0000001830ULL,
0x000000402c18723cULL, 0x004fec0000001818ULL, 0x000000422c14723cULL, 0x000fe20000001814ULL,
0x0000008048407811ULL, 0x000fe200078e18ffULL, 0x01100000742c783bULL, 0x0002a80000000200ULL,
0x0000000172767824ULL, 0x000fc400078e0240ULL, 0x000000016e797824ULL, 0x100fe400078e0240ULL,
0x000000016c757824ULL, 0x100fe200078e0240ULL, 0x0000001876387c11ULL, 0x000fe2000f8e20ffULL,
0x000000016d747824ULL, 0x002fe200078e0240ULL, 0x0000001879417c11ULL, 0x000fe2000f8e20ffULL,
0x0000000172437824ULL, 0x100fe400078e025fULL, 0x000000016e427824ULL, 0x100fe200078e025fULL,
0x000000003838783bULL, 0x000e680000004200ULL, 0x00000000413c783bULL, 0x0007240000004200ULL,
0x000000016c417824ULL, 0x008fc400078e025fULL, 0x000000016d5f7824ULL, 0x000fe400078e025fULL,
0x000000472c2c9232ULL, 0x084fe40000000000ULL, 0x000000472e2e9232ULL, 0x000fe40000000000ULL,
0x000000462d2d9232ULL, 0x080fe40000000000ULL, 0x000000462f2f9232ULL, 0x000fce0000000000ULL,
0x000000382c28723cULL, 0x002fec0000001828ULL, 0x0000003c2c20723cULL, 0x010fe20000001820ULL,
0x0000001875387c11ULL, 0x000fca000f8e20ffULL, 0x0000003a2c24723cULL, 0x000fe20000001824ULL,
0x00000018743d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000003838783bULL, 0x000e680000004200ULL,
0x0000003e2c1c723cULL, 0x000fe2000000181cULL, 0x000000003d3c783bULL, 0x000eaa0000004200ULL,
0x000000382c18723cULL, 0x002fec0000001818ULL, 0x0000003a2c14723cULL, 0x000fec0000001814ULL,
0x0000003c2c10723cULL, 0x004fec0000001810ULL, 0x0000003e2c30723cULL, 0x000fe20000001830ULL,
0x00000100483c7811ULL, 0x000fca00078e18ffULL, 0x000000016e717824ULL, 0x100fe200078e023cULL,
0x00000004732c7811ULL, 0x000fe200078fe0ffULL, 0x0000000172737824ULL, 0x100fe400078e023cULL,
0x000000016c677824ULL, 0x100fe200078e023cULL, 0x000000072c2c7812ULL, 0x000fe200078e7845ULL,
0x000000016d487824ULL, 0x000fe200078e023cULL, 0x00000018733d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000000727919ULL, 0x000e620000000000ULL, 0x00000018713e7c11ULL, 0x000fe2000f8e20ffULL,
0x00000008452c7824ULL, 0x000fe200078e022cULL, 0x00000018483c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000003d38783bULL, 0x0005e20000004200ULL, 0x00000001ff6c7424ULL, 0x000fc400078e00ffULL,
0x0000001b2c7d7c11ULL, 0x000fca000f8e20ffULL, 0x011000007d2c783bULL, 0x000ee20000000200ULL,
0x00000018673d7c11ULL, 0x004fe2000f8e20ffULL, 0x000000472c2c9232ULL, 0x088fe40000000000ULL,
0x000000472e2e9232ULL, 0x000fe40000000000ULL, 0x000000462d2d9232ULL, 0x080fe40000000000ULL,
0x000000462f2f9232ULL, 0x000fce0000000000ULL, 0x000000382c28723cULL, 0x000fec0000001828ULL,
0x0000003a2c24723cULL, 0x000fe20000001824ULL, 0x000000003e38783bULL, 0x000eaa0000004200ULL,
0x000000382c20723cULL, 0x004fec0000001820ULL, 0x0000003a2c1c723cULL, 0x000fe2000000181cULL,
0x000000003d38783bULL, 0x000eaa0000004200ULL, 0x000000382c18723cULL, 0x004fec0000001818ULL,
0x0000003a2c14723cULL, 0x000fe20000001814ULL, 0x000000003c38783bULL, 0x000eaa0000004200ULL,
0x000000382c10723cULL, 0x004fec0000001810ULL, 0x0000003a2c2c723cULL, 0x000fe20000001830ULL,
0x0000001843387c11ULL, 0x000fcc000f8e20ffULL, 0x0000000672307811ULL, 0x002fe200078fe0ffULL,
0x000000003838783bULL, 0x000fe60000004200ULL, 0x0000000730307812ULL, 0x000fca00078e7845ULL,
0x0000000845307824ULL, 0x000fe200078e0230ULL, 0x0000001842457c11ULL, 0x000fc8000f8e20ffULL,
0x0000001b30407c11ULL, 0x000fe2000f8e20ffULL, 0x00000000453c783bULL, 0x000fe80000004200ULL,
0x011000004030783bULL, 0x000e640000000200ULL, 0x0000004730309232ULL, 0x082fe40000000000ULL,
0x0000004732329232ULL, 0x000fe40000000000ULL, 0x0000004631319232ULL, 0x000fc40000000000ULL,
0x0000004633339232ULL, 0x000fce0000000000ULL, 0x000000383028723cULL, 0x000fec0000001828ULL,
0x0000003c3020723cULL, 0x000fe20000001820ULL, 0x0000001841397c11ULL, 0x000fca000f8e20ffULL,
0x0000003a3024723cULL, 0x000fe20000001824ULL, 0x000000185f3c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000003938783bULL, 0x000e620000004200ULL, 0xffffffff00187882ULL, 0x000fe20000000000ULL,
0x0000001900188c82ULL, 0x000fe40008000000ULL, 0x0000003e301c723cULL, 0x000fe2000000181cULL,
0x000000003c3c783bULL, 0x000ea20000004200ULL, 0x0236106cffff79a7ULL, 0x0007e8000850001cULL,
0x000000383018723cULL, 0x002fec0000001818ULL, 0x0000003a3014723cULL, 0x000fec0000001814ULL,
0x0000003c3010723cULL, 0x004fec0000001810ULL, 0x0000003e3030723cULL, 0x000fee000000182cULL,
0x000000064a2c7c11ULL, 0x000fc8000f8e10ffULL, 0x000000802c2c7811ULL, 0x000fc800078e30ffULL,
0x000000172c007c0cULL, 0x000fda000bf06070ULL, 0x0000001800580947ULL, 0x008fea0003800000ULL,
0x000000004a1972caULL, 0x000fe200000e0000ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000001915197290ULL, 0x000fc8000fffe03fULL, 0x00000001191b7890ULL, 0x000fe4000fffe03fULL,
0x0000000f19197291ULL, 0x000fe4000f8e403fULL, 0x000000051b00728cULL, 0x000fe4000bf06070ULL,
0x00000040091b7892ULL, 0x000fc8000f8ef819ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000400b88947ULL, 0x000fea0003800000ULL, 0x000000191700728cULL, 0x000fe4000bf01070ULL,
0x80000019ff2e7e24ULL, 0x000fe2000f8e02ffULL, 0x0000000d0c0f7899ULL, 0x000fe4000800063fULL,
0x00000019171e7287ULL, 0x000fe4000c000000ULL, 0x00000018111172a4ULL, 0x000fe4000f8e021bULL,
0x000020000f0f7892ULL, 0x000fe4000f8ec03fULL, 0x0000001eff2d7e24ULL, 0x000fc4000f8e00ffULL,
0x000000115d5d7c36ULL, 0x000fe20008000000ULL, 0x0000000d0f0f7290ULL, 0x000fe2000fffe00eULL,
0x000000115a477c36ULL, 0x000fe20008000000ULL, 0x000000402e2e7446ULL, 0x000fe2000380002dULL,
0x000000115c2d7c36ULL, 0x000fe20008000000ULL, 0x000130000f0f7890ULL, 0x000fe2000fffe03fULL,
0x00000011583f7c36ULL, 0x000fe20008000000ULL, 0x0000002e0200720cULL, 0x080fe20003f46070ULL,
0x000001002d2c7825ULL, 0x100fe200078e000eULL, 0x0000002e0300720cULL, 0x080fe40003f26070ULL,
0x0000002e0500720cULL, 0x000fe20003f86070ULL, 0x000001005d027825ULL, 0x000fe200078e000eULL,
0x0000000f64057c11ULL, 0x000fc4000f8e20ffULL, 0x0000002e0400720cULL, 0x080fe20003f06070ULL,
0x00000011655d7c36ULL, 0x000fe20008000000ULL, 0x0000000f662f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100d027825ULL, 0x000fe200078e0002ULL, 0x0000002e0700720cULL, 0x080fe40003fa6070ULL,
0x0000002e0600720cULL, 0x080fe20003fc6070ULL, 0x000000100d2c7825ULL, 0x000fe200078e002cULL,
0x0000002e0800720cULL, 0x080fe20003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000d101c52ULL, 0x0000002e0900720cULL, 0x080fe20003f46070ULL,
0x00000011563d7c36ULL, 0x000fe20008000000ULL, 0x0000000f59597c11ULL, 0x000fe2000f8e20ffULL,
0x00000011543b7c36ULL, 0x000fe20008000000ULL, 0x000000002c2f7faeULL, 0x0005e2000c901c52ULL,
0x0000001150077c36ULL, 0x000fe20008000000ULL, 0x0000002e0a00720cULL, 0x000fe20003f26070ULL,
0x000001005d5c7825ULL, 0x000fe200078e000eULL, 0x0000000f57577c11ULL, 0x000fc4000f8e20ffULL,
0x0000000f55557c11ULL, 0x000fe2000f8e20ffULL, 0x0000001152397c36ULL, 0x000fe20008000000ULL,
0x0000000f53537c11ULL, 0x000fe2000f8e20ffULL, 0x0000001163637c36ULL, 0x000fe20008000000ULL,
0x0000000f51517c11ULL, 0x000fe2000f8e20ffULL, 0x0000010047467825ULL, 0x100fe200078e000eULL,
0x0000001162037c10ULL, 0x002fe4000fffe0ffULL, 0x0000000f4f4f7c11ULL, 0x000fe2000f8e20ffULL,
0x000001003f3e7825ULL, 0x000fe200078e000eULL, 0x0000000f4d4d7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000f4b4b7c11ULL, 0x000fe2000f8e20ffULL, 0x000001003d3c7825ULL, 0x100fe200078e000eULL,
0x0000000f6f6f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000f6b6b7c11ULL, 0x000fe2000f8e20ffULL,
0x000001003b3a7825ULL, 0x000fe200078e000eULL, 0x0000000f69697c11ULL, 0x000fc6000f8e20ffULL,
0x00000100072c7825ULL, 0x004fc800078e000eULL, 0x0000010039387825ULL, 0x000fc800078e000eULL,
0x0000010063067825ULL, 0x000fe200078e000eULL, 0x0000000f5b637c11ULL, 0x000fc6000f8e20ffULL,
0x000000100d5c7825ULL, 0x000fc800078e005cULL, 0x000000100d467825ULL, 0x040fe200078e0046ULL,
0x000000005c637faeULL, 0x0003e2000c101c52ULL, 0x0000002e4400720cULL, 0x080fe40003f06070ULL,
0x000000100d3e7825ULL, 0x000fe200078e003eULL, 0x0000000046597faeULL, 0x0003e2000e101c52ULL,
0x0000002e3700720cULL, 0x080fe40003f86070ULL, 0x000000100d3c7825ULL, 0x000fe200078e003cULL,
0x000000003e577faeULL, 0x0003e2000f101c52ULL, 0x0000002e3600720cULL, 0x000fc40003fc6070ULL,
0x000000114e097c36ULL, 0x000fe20008000000ULL, 0x000000003c557faeULL, 0x0003e2000e901c52ULL,
0x000000100d3a7825ULL, 0x000fe200078e003aULL, 0x0000002e3500720cULL, 0x000fc60003fa6070ULL,
0x000000114c057c36ULL, 0x000fe20008000000ULL, 0x000000003a537faeULL, 0x0003e2000d901c52ULL,
0x000000100d387825ULL, 0x000fe200078e0038ULL, 0x0000002e3400720cULL, 0x000fc60003f66070ULL,
0x000000100d2c7825ULL, 0x000fe200078e002cULL, 0x0000000038517faeULL, 0x0003e2000d101c52ULL,
0x0000002e0b00720cULL, 0x080fe40003f46070ULL, 0x0000001161617c36ULL, 0x000fe20008000000ULL,
0x000000002c4f7faeULL, 0x0003e2000c901c52ULL, 0x0000001160457c36ULL, 0x000fe20008000000ULL,
0x0000002e0c00720cULL, 0x000fe20003f26070ULL, 0x0000010009087825ULL, 0x000fe200078e000eULL,
0x0000000f6a0b7c11ULL, 0x000fc6000f8e20ffULL, 0x000000115e2f7c36ULL, 0x000fe40008000000ULL,
0x0000010005047825ULL, 0x000fc800078e000eULL, 0x0000010003027825ULL, 0x000fc800078e000eULL,
0x0000010061607825ULL, 0x000fc800078e000eULL, 0x00000100455a7825ULL, 0x000fc800078e000eULL,
0x000001002f0e7825ULL, 0x000fc800078e000eULL, 0x000000100d087825ULL, 0x000fc800078e0008ULL,
0x000000100d047825ULL, 0x040fe200078e0004ULL, 0x00000000084d7faeULL, 0x0003e6000c101c52ULL,
0x000000100d067825ULL, 0x040fe200078e0006ULL, 0x00000000044b7faeULL, 0x0003e6000e101c52ULL,
0x000000100d027825ULL, 0x040fe200078e0002ULL, 0x00000000066f7faeULL, 0x0003e6000f101c52ULL,
0x000000100d607825ULL, 0x040fe200078e0060ULL, 0x00000000026b7faeULL, 0x0003e6000e901c52ULL,
0x000000100d5a7825ULL, 0x040fe200078e005aULL, 0x00000000600b7faeULL, 0x0003e6000d901c52ULL,
0x000000100d0e7825ULL, 0x000fe200078e000eULL, 0x0000000f680d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000005a697faeULL, 0x0003e8000d101c52ULL, 0x000000000e0d7faeULL, 0x0003e2000c901c52ULL,
0x0000000400607947ULL, 0x000fea0003800000ULL, 0x0000000d0c0f7899ULL, 0x000fe4000800063fULL,
0x00000018111172a4ULL, 0x000fe4000f8e021bULL, 0x000020000f0f7892ULL, 0x000fc8000f8ec03fULL,
0x000000115d477c36ULL, 0x000fe20008000000ULL, 0x0000000d0f0f7290ULL, 0x000fe2000fffe00eULL,
0x000000115c037c36ULL, 0x000fe40008000000ULL, 0x0000001165377c36ULL, 0x000fe20008000000ULL,
0x000130000f0f7890ULL, 0x000fe2000fffe03fULL, 0x000000115a3f7c36ULL, 0x000fe40008000000ULL,
0x00000011583d7c36ULL, 0x000fe40008000000ULL, 0x00000011563b7c36ULL, 0x000fe20008000000ULL,
0x0000000f5b5b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001154397c36ULL, 0x000fe20008000000ULL,
0x0000000f59597c11ULL, 0x000fe2000f8e20ffULL, 0x0000001152097c36ULL, 0x000fe20008000000ULL,
0x0000000f57577c11ULL, 0x000fe2000f8e20ffULL, 0x0000001150357c36ULL, 0x000fe20008000000ULL,
0x0000000f55557c11ULL, 0x000fe2000f8e20ffULL, 0x000000114e2f7c36ULL, 0x000fe20008000000ULL,
0x0000000f53537c11ULL, 0x000fe2000f8e20ffULL, 0x000000114c2d7c36ULL, 0x000fe20008000000ULL,
0x0000000f51517c11ULL, 0x000fe2000f8e20ffULL, 0x00000011630b7c36ULL, 0x000fe20008000000ULL,
0x0000000f4f4f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001162457c36ULL, 0x000fe20008000000ULL,
0x0000000f4d4d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001161077c36ULL, 0x000fe20008000000ULL,
0x0000000f4b4b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001160057c36ULL, 0x000fe20008000000ULL,
0x0000000f6f6f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000115e5d7c36ULL, 0x000fe20008000000ULL,
0x0000000f6b6b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000010047467825ULL, 0x000fe200078e000eULL,
0x0000000f69697c11ULL, 0x000fc6000f8e20ffULL, 0x0000010003027825ULL, 0x000fc800078e000eULL,
0x0000010037367825ULL, 0x000fc800078e000eULL, 0x000001003f3e7825ULL, 0x000fc800078e000eULL,
0x000001003d3c7825ULL, 0x000fc800078e000eULL, 0x000001003b3a7825ULL, 0x000fc800078e000eULL,
0x0000010039387825ULL, 0x000fc800078e000eULL, 0x0000010009087825ULL, 0x000fc800078e000eULL,
0x0000010035347825ULL, 0x000fc800078e000eULL, 0x000001002f2e7825ULL, 0x000fc800078e000eULL,
0x000001002d2c7825ULL, 0x000fc800078e000eULL, 0x000001000b0a7825ULL, 0x000fc800078e000eULL,
0x0000010045447825ULL, 0x000fc800078e000eULL, 0x0000010007067825ULL, 0x000fc800078e000eULL,
0x0000010005047825ULL, 0x000fc800078e000eULL, 0x000001005d0e7825ULL, 0x000fe200078e000eULL,
0x0000000f645d7c11ULL, 0x000fc6000f8e20ffULL, 0x000000100d467825ULL, 0x000fc800078e0046ULL,
0x000000100d027825ULL, 0x040fe200078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000465d7faeULL, 0x000fe6000b901c52ULL, 0x000000100d367825ULL, 0x000fc800078e0036ULL,
0x000000100d3e7825ULL, 0x000fc800078e003eULL, 0x000000100d3c7825ULL, 0x000fc800078e003cULL,
0x000000100d3a7825ULL, 0x000fc800078e003aULL, 0x000000100d387825ULL, 0x000fc800078e0038ULL,
0x000000100d087825ULL, 0x000fc800078e0008ULL, 0x000000100d347825ULL, 0x000fc800078e0034ULL,
0x000000100d2e7825ULL, 0x000fc800078e002eULL, 0x000000100d2c7825ULL, 0x000fc800078e002cULL,
0x000000100d0a7825ULL, 0x000fc800078e000aULL, 0x000000100d447825ULL, 0x000fc800078e0044ULL,
0x000000100d067825ULL, 0x000fc800078e0006ULL, 0x000000100d047825ULL, 0x000fc800078e0004ULL,
0x000000100d0e7825ULL, 0x000fe200078e000eULL, 0x0000000f660d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000020d7faeULL, 0x0005e8000b901c52ULL, 0x00000000365b7faeULL, 0x0003e8000b901c52ULL,
0x000000003e597faeULL, 0x0003e8000b901c52ULL, 0x000000003c577faeULL, 0x0003e2000b901c52ULL,
0x0000000f6a037c11ULL, 0x004fc4000f8e20ffULL, 0x0000000f680d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000003a557faeULL, 0x0003e8000b901c52ULL, 0x0000000038537faeULL, 0x0003e8000b901c52ULL,
0x0000000008517faeULL, 0x0003e8000b901c52ULL, 0x00000000344f7faeULL, 0x0003e8000b901c52ULL,
0x000000002e4d7faeULL, 0x0003e8000b901c52ULL, 0x000000002c4b7faeULL, 0x0003e8000b901c52ULL,
0x000000000a6f7faeULL, 0x0003e8000b901c52ULL, 0x00000000446b7faeULL, 0x0003e8000b901c52ULL,
0x0000000006037faeULL, 0x0003e8000b901c52ULL, 0x0000000004697faeULL, 0x0003e8000b901c52ULL,
0x000000000e0d7faeULL, 0x0003e4000b901c52ULL, 0x000000010a0d7892ULL, 0x000fe2000f8ec03fULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001f10107899ULL, 0x000fe4000800063fULL,
0x000000010d00788cULL, 0x000fc8000bf05070ULL, 0x000000011a0d7887ULL, 0x000fe2000c000000ULL,
0x00000010ff057e24ULL, 0x002fc6000f8e00ffULL, 0x0000000d0a0a7290ULL, 0x000fc8000fffe03fULL,
0x000000070a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fca0003f0f018ULL,
0x0000000a0b0d9290ULL, 0x000fe2000fffe03fULL, 0x00008c00000e9ab9ULL, 0x000fc60000000a00ULL,
0x000000040d0e98a5ULL, 0x000fcc000f8e000eULL, 0x0000000eff027e24ULL, 0x000fe4000f8e00ffULL,
0x0000000fff037e24ULL, 0x000fca000f8e00ffULL, 0x0000001202028981ULL, 0x000362000c1e1900ULL,
0x02362805ff0075a7ULL, 0x000ea2000802015cULL, 0x00000006140d7899ULL, 0x000fe2000800063fULL,
0x0000001072067824ULL, 0x000fe200078e00ffULL, 0x00000001ff047819ULL, 0x000fe40000011672ULL,
0xffffff800d0d7892ULL, 0x000fe4000f8ec03fULL, 0x0000000c04047812ULL, 0x000fe400078ec0ffULL,
0x00000100080d7890ULL, 0x000fe2000fffe00dULL, 0x0000007006067812ULL, 0x000fca00078ec0ffULL,
0x0000000d04047c10ULL, 0x000fe2000fffe006ULL, 0x000000a800cc9947ULL, 0x006fec0003800000ULL,
0x0230000004057984ULL, 0x000e620000000800ULL, 0x0000000a140d7899ULL, 0x000fe2000800063fULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000001d04047291ULL, 0x000fe2000f8e683fULL,
0x00000000000a7919ULL, 0x000ea20000000000ULL, 0xfffff8000d0d7892ULL, 0x000fe4000f8ec03fULL,
0x0001300004047890ULL, 0x000fe4000fffe03fULL, 0x0000000d080d7290ULL, 0x000fcc000fffe03fULL,
0x0000000d78787c11ULL, 0x000fe4000f8e20ffULL, 0x00000002ff0f7819ULL, 0x004fe4000001160aULL,
0x000000000500720bULL, 0x002fc60003f3d000ULL, 0x000000080f457836ULL, 0x000fd40000000000ULL,
0x0000000000037806ULL, 0x000fc800008e0100ULL, 0x0000ffff03077812ULL, 0x000fe4000782c0ffULL,
0x0232000004037984ULL, 0x0002b60000000800ULL, 0x0000000000ec9947ULL, 0x002fea0003800000ULL,
0x000000000500720bULL, 0x000fe20003f34000ULL, 0x00000002140d7891ULL, 0x000fe2000f8ff83fULL,
0x0000000500047209ULL, 0x000fe40007810000ULL, 0x00000001ff097819ULL, 0x000fe2000001160aULL,
0x000000140d00728cULL, 0x000fe2000bf05270ULL, 0x000000100a0a7824ULL, 0x000fe400078e00ffULL,
0x8000000400067221ULL, 0x000fe20000010000ULL, 0x0000000c09097812ULL, 0x000fc600078ec0ffULL,
0x3fb8aa3b06067820ULL, 0x000fe20000410000ULL, 0x000000000000781cULL, 0x000fe40003f4f008ULL,
0x0000000000007806ULL, 0x000fe200008e0100ULL, 0x00000008140d8291ULL, 0x000fe4000f8e383fULL,
0x0000000600067308ULL, 0x000e620000000800ULL, 0x0000ffff00087812ULL, 0x000fe400078e3cffULL,
0x000000700a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000000807ff7212ULL, 0x000fc6000782c0ffULL,
0x0000000d0909ac10ULL, 0x000fe4000fffe00aULL, 0x00000001ff0c7807ULL, 0x000fc60000800000ULL,
0x023400040900a388ULL, 0x000fe20000000800ULL, 0x0000000649497220ULL, 0x002fc60000410000ULL,
0x00001f0f06007589ULL, 0x000e6200000e0000ULL, 0x8000000405071221ULL, 0x000fc60000010000ULL,
0x00001f4506057589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b07071820ULL, 0x000fc80000410000ULL,
0x0000000700701308ULL, 0x000f220000000800ULL, 0x0000000028287220ULL, 0x082fe20000410000ULL,
0x0000000029297220ULL, 0x080fe20000410000ULL, 0x0000000024247220ULL, 0x080fe20000410000ULL,
0x0000000025257220ULL, 0x080fe20000410000ULL, 0x0000000020207220ULL, 0x080fe20000410000ULL,
0x0000000021217220ULL, 0x080fe20000410000ULL, 0x000000001c1c7220ULL, 0x080fe20000410000ULL,
0x000000001d1d7220ULL, 0x080fe20000410000ULL, 0x0000000018187220ULL, 0x080fe20000410000ULL,
0x0000000019197220ULL, 0x080fe20000410000ULL, 0x0000000014147220ULL, 0x080fe20000410000ULL,
0x0000000015157220ULL, 0x080fe20000410000ULL, 0x0000000010107220ULL, 0x080fe20000410000ULL,
0x0000000011117220ULL, 0x080fe20000410000ULL, 0x0000000030307220ULL, 0x080fe20000410000ULL,
0x0000000031317220ULL, 0x000fe20000410000ULL, 0x000000052a2a7220ULL, 0x088fe20000410000ULL,
0x000000052b2b7220ULL, 0x080fe20000410000ULL, 0x0000000526267220ULL, 0x080fe20000410000ULL,
0x0000000527277220ULL, 0x080fe20000410000ULL, 0x0000000522227220ULL, 0x080fe20000410000ULL,
0x0000000523237220ULL, 0x080fe20000410000ULL, 0x000000051e1e7220ULL, 0x080fe20000410000ULL,
0x000000051f1f7220ULL, 0x080fe20000410000ULL, 0x000000051a1a7220ULL, 0x080fe20000410000ULL,
0x000000051b1b7220ULL, 0x080fe20000410000ULL, 0x0000000516167220ULL, 0x080fe20000410000ULL,
0x0000000517177220ULL, 0x080fe20000410000ULL, 0x0000000512127220ULL, 0x080fe20000410000ULL,
0x0000000513137220ULL, 0x080fe20000410000ULL, 0x0000000532327220ULL, 0x080fe20000410000ULL,
0x0000000533337220ULL, 0x000fe20000410000ULL, 0x000000ffff007224ULL, 0x000fc400078e0004ULL,
0x0000000370031220ULL, 0x014fce0000410000ULL, 0x00000000010e7983ULL, 0x000ee20000300800ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x012000007804783bULL, 0x000fe20000000200ULL,
0x0000000477087c11ULL, 0x000fe2000f8e20ffULL, 0x0000004903497221ULL, 0x004fe20000010000ULL,
0x00000070ff0d723eULL, 0x000fe200000000ffULL, 0xffffffff00187882ULL, 0x000fe20000000000ULL,
0x000000047b387c11ULL, 0x000fe4000f8e20ffULL, 0x000000000808783bULL, 0x000fe20000004200ULL,
0x000054100d3c7816ULL, 0x000fe4000000000dULL, 0x000000047a347c11ULL, 0x000fe2000f8e20ffULL,
0x000000003838783bULL, 0x000fe20000004200ULL, 0x000099100c0c7816ULL, 0x000fc400000000ffULL,
0x000000047c2c7c11ULL, 0x000fe2000f8e20ffULL, 0x00001f0f3c447589ULL, 0x000e6200000e0000ULL,
0x000000ff0c00720cULL, 0x000fe40003f25270ULL, 0x0000000479797c11ULL, 0x000fe2000f8e20ffULL,
0x00001f453c457589ULL, 0x00052200000e0000ULL, 0x00000004714c7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000448507c11ULL, 0x000fe2000f8e20ffULL, 0x000000003434783bULL, 0x000f220000004200ULL,
0x0000000443437c11ULL, 0x000fc4000f8e20ffULL, 0x00000000020d82caULL, 0x020fe200000e0000ULL,
0x000000002c2c783bULL, 0x000f620000004200ULL, 0x00000004763c7c11ULL, 0x004fc6000f8e20ffULL,
0x000000004c4c783bULL, 0x000fe80000004200ULL, 0x000000003c3c783bULL, 0x000fe80000004200ULL,
0x000000005050783bULL, 0x000fe20000004200ULL, 0x0000004404049232ULL, 0x082fe20000000000ULL,
0x0000000d00189c82ULL, 0x000fe20008000000ULL, 0x0000004406069232ULL, 0x000fc40000000000ULL,
0x0000004505059232ULL, 0x090fe40000000000ULL, 0x0000004507079232ULL, 0x000fce0000000000ULL,
0x000000080428723cULL, 0x000fec0000001828ULL, 0x0000000a0408723cULL, 0x000fe20000001824ULL,
0x000000007924783bULL, 0x000fea0000004200ULL, 0x000000380420723cULL, 0x000fec0000001820ULL,
0x000000340418723cULL, 0x000fe20000001818ULL, 0x0000000475387c11ULL, 0x000fca000f8e20ffULL,
0x0000003a041c723cULL, 0x000fe2000000181cULL, 0x0000000474347c11ULL, 0x000fe2000f8e20ffULL,
0x000000003838783bULL, 0x000fe80000004200ULL, 0x000000360414723cULL, 0x000fe20000001814ULL,
0x000000003434783bULL, 0x000fea0000004200ULL, 0x0000002c0410723cULL, 0x020fec0000001810ULL,
0x0000002e0404723cULL, 0x000fe20000001830ULL, 0x012000007d2c783bULL, 0x000e680000000200ULL,
0x012000004030783bULL, 0x000ea20000000200ULL, 0x000000442c2c9232ULL, 0x002fc40000000000ULL,
0x000000442e2e9232ULL, 0x080fe40000000000ULL, 0x000000452d2d9232ULL, 0x080fe40000000000ULL,
0x000000452f2f9232ULL, 0x080fe40000000000ULL, 0x0000004430309232ULL, 0x084fe40000000000ULL,
0x0000004432329232ULL, 0x000fe40000000000ULL, 0x0000004531319232ULL, 0x000fc40000000000ULL,
0x0000004533339232ULL, 0x080fe20000000000ULL, 0x012000000e0c783bULL, 0x008e640000000200ULL,
0x000000440c0c9232ULL, 0x082fe40000000000ULL, 0x000000440e0e9232ULL, 0x000fe40000000000ULL,
0x000000450d0d9232ULL, 0x080fe40000000000ULL, 0x000000450f0f9232ULL, 0x000fce0000000000ULL,
0x0000003c0c28723cULL, 0x000fec0000001828ULL, 0x000000240c20723cULL, 0x000fe20000001820ULL,
0x00000004673c7c11ULL, 0x000fca000f8e20ffULL, 0x0000003e0c08723cULL, 0x000fe20000001808ULL,
0x0000000473247c11ULL, 0x000fe2000f8e20ffULL, 0x000000003c3c783bULL, 0x000fe80000004200ULL,
0x000000260c1c723cULL, 0x000fe2000000181cULL, 0x000000002424783bULL, 0x000e6a0000004200ULL,
0x000000380c18723cULL, 0x000fec0000001818ULL, 0x0000003a0c14723cULL, 0x000fe20000001814ULL,
0x0000000442387c11ULL, 0x000fca000f8e20ffULL, 0x000000340c10723cULL, 0x000fe20000001810ULL,
0x000000003838783bULL, 0x000fea0000004200ULL, 0x000000360c34723cULL, 0x000fec0000001804ULL,
0x0000004c2c20723cULL, 0x000fe20000001820ULL, 0x00000004410c7c11ULL, 0x000fc4000f8e20ffULL,
0x000000045f047c11ULL, 0x000fe2000f8e20ffULL, 0x000000004340783bULL, 0x000ea20000004200ULL,
0x000000010c047892ULL, 0x000fe2000f8ec03fULL, 0x0000004e2c1c723cULL, 0x000fe4000000181cULL,
0x000000000c0c783bULL, 0x000ee80000004200ULL, 0x000000000404783bULL, 0x000f220000004200ULL,
0x000000242c28723cULL, 0x002fe20000001828ULL, 0x0236306cffff79a7ULL, 0x0003ea000850001cULL,
0x000000262c08723cULL, 0x000fec0000001808ULL, 0x0000003c2c18723cULL, 0x000fec0000001818ULL,
0x0000003e2c14723cULL, 0x000fec0000001814ULL, 0x000000502c10723cULL, 0x000fec0000001810ULL,
0x000000522c34723cULL, 0x000fec0000001834ULL, 0x000000403028723cULL, 0x004fec0000001828ULL,
0x000000423024723cULL, 0x000fec0000001808ULL, 0x000000383020723cULL, 0x000fec0000001820ULL,
0x0000003a301c723cULL, 0x000fec000000181cULL, 0x0000000c3018723cULL, 0x008fec0000001818ULL,
0x0000000e3014723cULL, 0x000fec0000001814ULL, 0x000000043010723cULL, 0x010fec0000001810ULL,
0x000000063030723cULL, 0x002fde0000001834ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000040001027983ULL, 0x002ea20000300800ULL, 0x000000154a4a7c36ULL, 0x000fca0008000000ULL,
0x000000054a007c0cULL, 0x000fe4000bf26070ULL, 0x000000ff02ff7812ULL, 0x004fc8000780c0ffULL,
0x00000001ff027807ULL, 0x000fca0000000000ULL, 0x0000040201007387ULL, 0x0003e40000100600ULL,
0xffffffbc00749947ULL, 0x002fea000383ffffULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0002300008047890ULL, 0x000fe2000fffe03fULL, 0x00000000001779c3ULL, 0x000ea20000002500ULL,
0x0000000106077899ULL, 0x000fce000800063fULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000414097291ULL, 0x000fe4000f8e383fULL, 0x0000000207077892ULL, 0x000fc8000f8e0c3fULL,
0x0000000107077892ULL, 0x000fc8000f8ef814ULL, 0x0000000407077291ULL, 0x000fcc000f8e383fULL,
0x00000007ff0b7e24ULL, 0x000fe2000f8e00ffULL, 0x000000051700728cULL, 0x004fe2000bf06070ULL,
0x0000001002037824ULL, 0x002fe200078e00ffULL, 0x00000001ff047819ULL, 0x100fe40000011602ULL,
0x00000002ff077819ULL, 0x000fe40000011602ULL, 0x0000007003087812ULL, 0x000fe200078ec0ffULL,
0x00000009ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000000c04097812ULL, 0x000fe400078ec0ffULL,
0x000000000000781cULL, 0x000fc40003f0f008ULL, 0x0000020008047810ULL, 0x000fe40007ffe003ULL,
0x0000000909037c10ULL, 0x140fe4000fffe008ULL, 0x0000000709057c10ULL, 0x040fe2000fffe008ULL,
0x0000000109047824ULL, 0x000fe400078e0204ULL, 0x0000000003007388ULL, 0x0003e80000000800ULL,
0x0000004904007388ULL, 0x000fe20000000800ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000802037811ULL, 0x002fca00078ff0ffULL, 0x0000000005057984ULL, 0x000e640000000800ULL,
0x00000000050d7209ULL, 0x002fca0007810000ULL, 0x000000000d067221ULL, 0x000fe20000010100ULL,
0x0000020008007810ULL, 0x000fe20007ffe00bULL, 0x8000000d05057221ULL, 0x000fe40000010000ULL,
0x3fb8aa3b06067820ULL, 0x000fe40000410000ULL, 0x0000000109007824ULL, 0x000fe400078e0200ULL,
0x3fb8aa3b05057820ULL, 0x000fe40000410000ULL, 0x0000000600067308ULL, 0x000e640000000800ULL,
0x0000000000007984ULL, 0x000fec0000000800ULL, 0x0000000500057308ULL, 0x000ea20000000800ULL,
0x00001f0706077589ULL, 0x002e6800000e0000ULL, 0x00001f0306037589ULL, 0x000ee200000e0000ULL,
0x0000002807047220ULL, 0x042fe20000410000ULL, 0x0000002907297220ULL, 0x040fe20000410000ULL,
0x0000002407247220ULL, 0x040fe20000410000ULL, 0x0000000500057220ULL, 0x004fe20000410000ULL,
0x0000002507257220ULL, 0x040fe20000410000ULL, 0x0000002007207220ULL, 0x040fe20000410000ULL,
0x0000002107217220ULL, 0x040fe20000410000ULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x0000001d071d7220ULL, 0x040fe20000410000ULL, 0x0000001807087220ULL, 0x040fe20000410000ULL,
0x0000001907197220ULL, 0x040fe20000410000ULL, 0x0000001407097220ULL, 0x040fe20000410000ULL,
0x00000015070a7220ULL, 0x040fe20000410000ULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0x0000001107117220ULL, 0x040fe20000410000ULL, 0x00000030070b7220ULL, 0x040fe20000410000ULL,
0x00000031070c7220ULL, 0x000fe20000410000ULL, 0x0000002a032a7220ULL, 0x048fe20000410000ULL,
0x0000002b032b7220ULL, 0x040fe20000410000ULL, 0x0000002603267220ULL, 0x040fe20000410000ULL,
0x0000002703277220ULL, 0x040fe20000410000ULL, 0x0000002203227220ULL, 0x040fe20000410000ULL,
0x0000002303237220ULL, 0x040fe20000410000ULL, 0x0000001e031e7220ULL, 0x040fe20000410000ULL,
0x0000001f031f7220ULL, 0x040fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000001b031b7220ULL, 0x040fe20000410000ULL, 0x0000001603167220ULL, 0x040fe20000410000ULL,
0x0000001703177220ULL, 0x040fe20000410000ULL, 0x0000001203007220ULL, 0x040fe20000410000ULL,
0x00000013030f7220ULL, 0x040fe20000410000ULL, 0x0000003203327220ULL, 0x040fe20000410000ULL,
0x0000003303337220ULL, 0x000fe20000410000ULL, 0x0000004906497223ULL, 0x000fe20000010005ULL,
0x0000000000c80947ULL, 0x000fec0003800000ULL, 0x0180000049027836ULL, 0x000fca0000000000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00006ab000067802ULL, 0x000fce0000000f00ULL,
0x000000a000687944ULL, 0x000fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e0005ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000004900027308ULL, 0x000e640000001000ULL,
0xbf80000049037423ULL, 0x002fc80000000002ULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000302037223ULL, 0x000fce0000000002ULL, 0x0000000000027919ULL, 0x000ea40000000000ULL,
0x00000002ff0e7819ULL, 0x004fe40000011602ULL, 0x0000000802067811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0e03057589ULL, 0x000ea800000e0000ULL,
0x00001f0603067589ULL, 0x000ee200000e0000ULL, 0x0000000504047220ULL, 0x084fe20000410000ULL,
0x0000000529297220ULL, 0x080fe20000410000ULL, 0x0000000524247220ULL, 0x080fe20000410000ULL,
0x0000000525257220ULL, 0x080fe20000410000ULL, 0x0000000520207220ULL, 0x080fe20000410000ULL,
0x0000000521217220ULL, 0x080fe20000410000ULL, 0x000000051c1c7220ULL, 0x080fe20000410000ULL,
0x000000051d1d7220ULL, 0x080fe20000410000ULL, 0x0000000508087220ULL, 0x080fe20000410000ULL,
0x0000000519197220ULL, 0x080fe20000410000ULL, 0x0000000509097220ULL, 0x080fe20000410000ULL,
0x000000050a0a7220ULL, 0x080fe20000410000ULL, 0x0000000510107220ULL, 0x080fe20000410000ULL,
0x0000000511117220ULL, 0x080fe20000410000ULL, 0x000000050b0b7220ULL, 0x080fe20000410000ULL,
0x000000050c0c7220ULL, 0x000fe20000410000ULL, 0x000000062a2a7220ULL, 0x088fe20000410000ULL,
0x000000062b2b7220ULL, 0x080fe20000410000ULL, 0x0000000626267220ULL, 0x080fe20000410000ULL,
0x0000000627277220ULL, 0x080fe20000410000ULL, 0x0000000622227220ULL, 0x080fe20000410000ULL,
0x0000000623237220ULL, 0x080fe20000410000ULL, 0x000000061e1e7220ULL, 0x080fe20000410000ULL,
0x000000061f1f7220ULL, 0x080fe20000410000ULL, 0x000000061a1a7220ULL, 0x080fe20000410000ULL,
0x000000061b1b7220ULL, 0x080fe20000410000ULL, 0x0000000616167220ULL, 0x080fe20000410000ULL,
0x0000000617177220ULL, 0x080fe20000410000ULL, 0x0000000600007220ULL, 0x080fe20000410000ULL,
0x000000060f0f7220ULL, 0x080fe20000410000ULL, 0x0000000632327220ULL, 0x080fe20000410000ULL,
0x0000000633337220ULL, 0x000fce0000410000ULL, 0x00000003ff037819ULL, 0x000fe20000011602ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0xfffffff8ff067812ULL, 0x000fe200078ee202ULL,
0x0000000816077291ULL, 0x000fe2000f8e603fULL, 0x0000000303057812ULL, 0x000fe200078ec0ffULL,
0x000000011500788cULL, 0x000fe2000bf05270ULL, 0x000000042904723eULL, 0x000fe200000000ffULL,
0x0000000806127836ULL, 0x040fe20000000000ULL, 0x0000000405137812ULL, 0x000fe200078efcffULL,
0x0000000806077824ULL, 0x000fe200078e00ffULL, 0x00000007050e7812ULL, 0x000fe200078e7806ULL,
0x0000000706187291ULL, 0x000fe2000f8e583fULL, 0x0000000705147812ULL, 0x000fe200078e7812ULL,
0x0000000812057824ULL, 0x000fe200078e00ffULL, 0x0000000713067812ULL, 0x000fc400078e7806ULL,
0x0000000713127812ULL, 0x000fe400078e7812ULL, 0x000000070e0e7212ULL, 0x080fe400078efcffULL,
0x0000000706187212ULL, 0x000fe400078efcffULL, 0x0000000514287212ULL, 0x080fe400078efcffULL,
0x00000005122c7212ULL, 0x000fe400078efcffULL, 0x000000242505723eULL, 0x000fc400000000ffULL,
0x000000202106723eULL, 0x000fe400000000ffULL, 0x0000001c1d07723eULL, 0x000fe400000000ffULL,
0x000000090a09723eULL, 0x000fe400000000ffULL, 0x000000180e0e7c11ULL, 0x000fe4000f8e20ffULL,
0x000000081908723eULL, 0x000fe400000000ffULL, 0x00000010110a723eULL, 0x000fe200000000ffULL,
0x000000040e007844ULL, 0x000fe20000000200ULL, 0x0000000b0c0b723eULL, 0x000fc400000000ffULL,
0x0000001818187c11ULL, 0x000fe4000f8e20ffULL, 0x0000002a2b10723eULL, 0x000fe400000000ffULL,
0x000000262711723eULL, 0x000fe200000000ffULL, 0x0000000818007844ULL, 0x000fe20000000200ULL,
0x000000222312723eULL, 0x000fe400000000ffULL, 0x0000001e1f13723eULL, 0x000fe400000000ffULL,
0x000000161715723eULL, 0x000fc400000000ffULL, 0x0000001828287c11ULL, 0x000fe4000f8e20ffULL,
0x0000001a1b14723eULL, 0x000fe400000000ffULL, 0x000000000f16723eULL, 0x000fe200000000ffULL,
0x0000001028007844ULL, 0x000fe20000000200ULL, 0x000000323317723eULL, 0x000fe200000000ffULL,
0x00000006ff0f7e24ULL, 0x000fe2000f8e00ffULL, 0x000000182c2c7c11ULL, 0x000fe4000f8e20ffULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000000200f0f7824ULL, 0x000fc400078e0202ULL,
0x000000142c007844ULL, 0x000fe60000000200ULL, 0x000000070f007c11ULL, 0x000fe2000f8e20ffULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000001c7984ULL, 0x000ea80000000c00ULL,
0x0004000000247984ULL, 0x000ee80000000c00ULL, 0x0008000000207984ULL, 0x000f280000000c00ULL,
0x000c000000307984ULL, 0x000f620000000c00ULL, 0x200000ff1f1f7230ULL, 0x004fc40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fe40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x008fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fc40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x000000231f1f7230ULL, 0x010fe40000000000ULL,
0x000000221e1e7230ULL, 0x000fe40000000000ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fe40000000000ULL, 0x0000003327277230ULL, 0x020fc40000000000ULL,
0x0000003226267230ULL, 0x000fe20000000000ULL, 0x0000001c00007388ULL, 0x0005e20000000c00ULL,
0x0000003125257230ULL, 0x000fe40000000000ULL, 0x0000003024247230ULL, 0x000fca0000000000ULL,
0x0004002400007388ULL, 0x0005e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000002800dc8947ULL, 0x000fea0003800000ULL, 0x0000000000087984ULL, 0x0006e20000000c00ULL,
0x00000000000a79c3ULL, 0x000fe20000002700ULL, 0x00000001063f7892ULL, 0x000fe4000f80f814ULL,
0x0004000000107984ULL, 0x0006620000000c00ULL, 0x0000840000087ab9ULL, 0x000fe20000000800ULL,
0x0000920000097ab9ULL, 0x000fe20000000800ULL, 0x00000008150472a4ULL, 0x000fe2000f8e023fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x00000000000579c3ULL, 0x000f240000002600ULL,
0x00000009040972a4ULL, 0x000fc8000f8e023fULL, 0x01ffffff09197892ULL, 0x000fe4000f8ec03fULL,
0x000000080a0a72a4ULL, 0x010fc8000f8e0205ULL, 0x000000150a0872a4ULL, 0x000fc8000f8e023fULL,
0x00000017080b7290ULL, 0x000fe2000fffe03fULL, 0x0000000000380947ULL, 0x008ff60003800000ULL,
0x000000190b0c7290ULL, 0x000fe2000fffe03fULL, 0x0000001002007824ULL, 0x004fe200078e00ffULL,
0x0000980000047ab9ULL, 0x000fe20000000a00ULL, 0x00000001ff047819ULL, 0x000fe20000011602ULL,
0x000000800b0e78a5ULL, 0x000fe4000f8e0004ULL, 0x000000800c0478a5ULL, 0x000fe2000f8e0004ULL,
0x0000007000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c04077812ULL, 0x000fc800078ec0ffULL,
0x0000000e07047c10ULL, 0x140fe4000fa3e000ULL, 0x0000000407067c10ULL, 0x000fe4000fc7e000ULL,
0x0000000fff057c10ULL, 0x000fe40008fe44ffULL, 0x00000005ff077c10ULL, 0x000fc60009fe84ffULL,
0x0000000d04007986ULL, 0x0005e8000c101912ULL, 0x0000004906007986ULL, 0x0005e4000c101912ULL,
0x00000fff09097891ULL, 0x000fe2000f8e403fULL, 0x000000ff0200720cULL, 0x000fe20000705670ULL,
0x0000980000107ab9ULL, 0x000fe20000000a00ULL, 0x000000400f0d7836ULL, 0x004fe20000000000ULL,
0x0000000b09047291ULL, 0x000fe2000f8fa03fULL, 0x0000021000007945ULL, 0x000fe60003800000ULL,
0x00001000040478a5ULL, 0x000fc8000f8e0010ULL, 0x00000800160478a5ULL, 0x000fcc000f8e0004ULL,
0x00000004ff067e24ULL, 0x000fe4000f8e00ffULL, 0x00000005ff077e24ULL, 0x000fe4000f8e00ffULL,
0x000000100f047825ULL, 0x000fc800078e0006ULL, 0x000000100d067825ULL, 0x000fe200078e0006ULL,
0x0000000804007986ULL, 0x0005e8000c101d12ULL, 0x0000001006007986ULL, 0x0025e2000c101d12ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000000580947ULL, 0x000fea0003800000ULL,
0x0000960000047ab9ULL, 0x000fe20000000a00ULL, 0xffffffff150b7890ULL, 0x000fe4000fffe03fULL,
0x000000040a0478a5ULL, 0x000fc8000f8e0004ULL, 0x0000000bff077e24ULL, 0x004fe4000f8e00ffULL,
0x00000004ff047e24ULL, 0x000fe4000f8e00ffULL, 0x00000005ff057e24ULL, 0x000fe2000f8e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x0003ec0000008000ULL, 0x0000000000007992ULL, 0x002fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000007040479a8ULL, 0x000ea800099ee1d2ULL, 0x00000000ff00798fULL, 0x004fe20002000000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fc40000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000b04007c0cULL, 0x000fc8000bf05270ULL,
0x00000001ff007807ULL, 0x000fca0000000000ULL, 0x00000000ff007988ULL, 0x0003e80008000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ef00000008800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000400000a7882ULL, 0x000fc40000000000ULL,
0x00000654040a7896ULL, 0x008fd2000800000aULL, 0x0000000aff007984ULL, 0x002e640008000000ULL,
0x000000ff0000720cULL, 0x002fda0003f05270ULL, 0x0000002400b08947ULL, 0x000fea0003800000ULL,
0x00000014ff007c0cULL, 0x000fda000bf05270ULL, 0x0000000c008c0947ULL, 0x000fea0003800000ULL,
0x00000015ff007c0cULL, 0x000fda000bf05270ULL, 0x0000000000f08947ULL, 0x000fea0003800000ULL,
0x0000000108047890ULL, 0x000fe2000fffe03fULL, 0x0000001002007824ULL, 0x000fe200078e00ffULL,
0x00000001ff047819ULL, 0x004fe20000011602ULL, 0x00000080080c78a5ULL, 0x000fe4000f8e0010ULL,
0x00000080040478a5ULL, 0x000fe2000f8e0010ULL, 0x0000007000037812ULL, 0x000fe400078ec0ffULL,
0x0000000c04087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08047c10ULL, 0x140fe4000f91e003ULL,
0x0000000408067c10ULL, 0x000fe4000fb5e003ULL, 0x0000000dff057c10ULL, 0x000fe400087e24ffULL,
0x00000005ff077c10ULL, 0x000fc600097e64ffULL, 0x0000001204007981ULL, 0x000368000c1e1900ULL,
0x0000001206097981ULL, 0x000362000c1e1900ULL, 0x000000021500788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x0000000208047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e0010ULL,
0x0000000408047c10ULL, 0x000fc8000f91e003ULL, 0x00000005ff057c10ULL, 0x000fca00087e24ffULL,
0x00000012040b7981ULL, 0x000362000c1e1900ULL, 0x000000041500788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000908947ULL, 0x002fea0003800000ULL,
0x0000000308047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e0010ULL,
0x0000000408047c10ULL, 0x000fc8000f91e003ULL, 0x00000005ff057c10ULL, 0x000fca00087e24ffULL,
0x00000012040d7981ULL, 0x000362000c1e1900ULL, 0x000000041500788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000708947ULL, 0x002fea0003800000ULL,
0x0000000408047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e0010ULL,
0x0000000408047c10ULL, 0x000fc8000f91e003ULL, 0x00000005ff057c10ULL, 0x000fca00087e24ffULL,
0x00000012040f7981ULL, 0x000362000c1e1900ULL, 0x000000061500788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000508947ULL, 0x002fea0003800000ULL,
0x0000000508047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e0010ULL,
0x0000000408047c10ULL, 0x000fc8000f91e003ULL, 0x00000005ff057c10ULL, 0x000fca00087e24ffULL,
0x0000001204117981ULL, 0x000362000c1e1900ULL, 0x000000061500788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000308947ULL, 0x002fea0003800000ULL,
0x000000081500788cULL, 0x000fe4000bf06070ULL, 0x0000000608047890ULL, 0x000fc8000fffe03fULL,
0x000000000000781cULL, 0x000fe20003f8f008ULL, 0x00000080040478a5ULL, 0x000fc8000f8e0010ULL,
0x00000007080c0890ULL, 0x000fe4000fffe03fULL, 0x0000000408047c10ULL, 0x000fe4000f91e003ULL,
0x000000800c0c08a5ULL, 0x000fe4000f8e0010ULL, 0x00000005ff057c10ULL, 0x000fc800087e24ffULL,
0x0000000c08064c10ULL, 0x000fe2000fb5e003ULL, 0x0000001204137981ULL, 0x000366000c1e1900ULL,
0x0000000dff074c10ULL, 0x000fca00097e64ffULL, 0x0000001206154981ULL, 0x000368000c1e1900ULL,
0x00000007150b7890ULL, 0x000fc8000fffe03fULL, 0x000000033f0b7899ULL, 0x000fcc000801160bULL,
0x0000000bff007c0cULL, 0x000fda000bf05270ULL, 0x0000000800688947ULL, 0x000fea0003800000ULL,
0x000000ffff037224ULL, 0x020fe200078e0000ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x00000008000c7c82ULL, 0x000fe20008000000ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x00009800001a7ab9ULL, 0x000fca0000000a00ULL, 0x000000150400728cULL, 0x000fe4000bf06070ULL,
0x0000000105057890ULL, 0x000fc8000fffe03fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000b0500728cULL, 0x000fd8000bf06070ULL, 0x0000000800300947ULL, 0x022fea0003800000ULL,
0x00000008040d7890ULL, 0x000fe2000fffe03fULL, 0x0000000300007209ULL, 0x000fe20007810000ULL,
0x00000001040e7890ULL, 0x000fe4000fffe03fULL, 0x000000150d00728cULL, 0x000fe4000bf26070ULL,
0x000000150e00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x000000080c0e7890ULL, 0x000fe2000fffe03fULL, 0x0000001002037824ULL, 0x000fe200078e00ffULL,
0x00000001ff047819ULL, 0x006fe40000011602ULL, 0x000000800e0e78a5ULL, 0x000fe4000f8e001aULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ec0ffULL,
0x0000000e04047c10ULL, 0x000fc8000f91e003ULL, 0x0000000fff057c10ULL, 0x000fca00087e24ffULL,
0x0000001204037981ULL, 0x000368000c1e1900ULL, 0x0000000400e82947ULL, 0x000fea0003800000ULL,
0x00000009040d7890ULL, 0x000fe2000fffe03fULL, 0x0000000900007209ULL, 0x000fe20007810000ULL,
0x00000002040e7890ULL, 0x000fe4000fffe03fULL, 0x000000150d00728cULL, 0x000fe4000bf26070ULL,
0x000000150e00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x000000090c0e7890ULL, 0x000fe2000fffe03fULL, 0x0000001002047824ULL, 0x006fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fe40000011602ULL, 0x000000800e0e78a5ULL, 0x000fe4000f8e001aULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000000e05047c10ULL, 0x000fc8000f91e004ULL, 0x0000000fff057c10ULL, 0x000fca00087e24ffULL,
0x0000001204097981ULL, 0x000368000c1e1900ULL, 0x0000000400a02947ULL, 0x000fea0003800000ULL,
0x0000000a040d7890ULL, 0x000fe2000fffe03fULL, 0x0000000b00007209ULL, 0x000fe20007810000ULL,
0x00000003040e7890ULL, 0x000fe4000fffe03fULL, 0x000000150d00728cULL, 0x000fe4000bf26070ULL,
0x000000150e00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000a0c0e7890ULL, 0x000fe2000fffe03fULL, 0x0000001002047824ULL, 0x006fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fe40000011602ULL, 0x000000800e0e78a5ULL, 0x000fe4000f8e001aULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000000e05047c10ULL, 0x000fc8000f91e004ULL, 0x0000000fff057c10ULL, 0x000fca00087e24ffULL,
0x00000012040b7981ULL, 0x000368000c1e1900ULL, 0x0000000400582947ULL, 0x000fea0003800000ULL,
0x0000000b040d7890ULL, 0x000fe2000fffe03fULL, 0x0000000d00007209ULL, 0x000fe20007810000ULL,
0x00000004040e7890ULL, 0x000fe4000fffe03fULL, 0x000000150d00728cULL, 0x000fe4000bf26070ULL,
0x000000150e00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000b0c0e7890ULL, 0x000fe2000fffe03fULL, 0x0000001002047824ULL, 0x006fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fe40000011602ULL, 0x000000800e0e78a5ULL, 0x000fe4000f8e001aULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000000e05047c10ULL, 0x000fc8000f91e004ULL, 0x0000000fff057c10ULL, 0x000fca00087e24ffULL,
0x00000012040d7981ULL, 0x000368000c1e1900ULL, 0x0000000400102947ULL, 0x000fea0003800000ULL,
0x0000000c040d7890ULL, 0x000fe2000fffe03fULL, 0x0000000f00007209ULL, 0x000fe20007810000ULL,
0x00000005040e7890ULL, 0x000fe4000fffe03fULL, 0x000000150d00728cULL, 0x000fe4000bf26070ULL,
0x000000150e00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000c0c0e7890ULL, 0x000fe2000fffe03fULL, 0x0000001002047824ULL, 0x006fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fe40000011602ULL, 0x000000800e0e78a5ULL, 0x000fe4000f8e001aULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000000e05047c10ULL, 0x000fc8000f91e004ULL, 0x0000000fff057c10ULL, 0x000fca00087e24ffULL,
0x00000012040f7981ULL, 0x000368000c1e1900ULL, 0x0000000000c82947ULL, 0x000fea0003800000ULL,
0x0000000d040d7890ULL, 0x000fe2000fffe03fULL, 0x0000001100007209ULL, 0x000fe20007810000ULL,
0x00000006040e7890ULL, 0x000fe4000fffe03fULL, 0x000000150d00728cULL, 0x000fe4000bf26070ULL,
0x000000150e00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000d0c0e7890ULL, 0x000fe2000fffe03fULL, 0x0000001002047824ULL, 0x006fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fe40000011602ULL, 0x000000800e0e78a5ULL, 0x000fe4000f8e001aULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000000e05047c10ULL, 0x000fc8000f91e004ULL, 0x0000000fff057c10ULL, 0x000fca00087e24ffULL,
0x0000001204117981ULL, 0x000368000c1e1900ULL, 0x0000000000802947ULL, 0x000fea0003800000ULL,
0x0000000e040d7890ULL, 0x000fe2000fffe03fULL, 0x0000001300007209ULL, 0x000fe20007810000ULL,
0x00000007040e7890ULL, 0x000fe4000fffe03fULL, 0x000000150d00728cULL, 0x000fe4000bf26070ULL,
0x000000150e00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000e0c0e7890ULL, 0x000fe2000fffe03fULL, 0x0000001002047824ULL, 0x006fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fe40000011602ULL, 0x000000800e0e78a5ULL, 0x000fe4000f8e001aULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000000e05047c10ULL, 0x000fc8000f91e004ULL, 0x0000000fff057c10ULL, 0x000fca00087e24ffULL,
0x0000001204137981ULL, 0x000368000c1e1900ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x0000000f040d7890ULL, 0x000fe2000fffe03fULL, 0x0000001500007209ULL, 0x000fc60007810000ULL,
0x000000150d00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000f0c0e7890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x000000800e0e78a5ULL, 0x000fe4000f8e001aULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000e05047c10ULL, 0x000fc8000f91e004ULL,
0x0000000fff057c10ULL, 0x000fca00087e24ffULL, 0x0000001204157981ULL, 0x000368000c1e1900ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000804047890ULL, 0x000fe4000fffe03fULL,
0x000000080c0c7890ULL, 0x000fd4000fffe03fULL, 0xfffffff400ac8947ULL, 0x000fea000383ffffULL,
0x0000000000027919ULL, 0x000ee40000000000ULL, 0x0000001002037824ULL, 0x028fe200078e00ffULL,
0x00000001ff047819ULL, 0x006fc80000011602ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ec0ffULL, 0x0000000a04037c10ULL, 0x000fca000fffe003ULL,
0x0000000003007388ULL, 0x0003e40000000800ULL, 0x000000070200780cULL, 0x040fe20003f04070ULL,
0x00000008060e7290ULL, 0x000fe2000fffe03fULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000023f0b7899ULL, 0x000fe20008011614ULL, 0x0000001002007824ULL, 0x042fe200078e00ffULL,
0x0000000e090c7291ULL, 0x000fe2000f8fa03fULL, 0x00000001ff037819ULL, 0x000fe20000011602ULL,
0x000000010b057892ULL, 0x000fe2000f8ec03fULL, 0x0000002002077836ULL, 0x004fe20000000000ULL,
0x00009800001a7ab9ULL, 0x000fe20000000a00ULL, 0x0000000a06047291ULL, 0x000fe2000f8e683fULL,
0x0000007000007812ULL, 0x000fe200078ec0ffULL, 0x000010000c0c78a5ULL, 0x000fe2000f8e001aULL,
0x0000000c03037812ULL, 0x000fe200078ec0ffULL, 0x00000000003f7886ULL, 0x000fe20000000000ULL,
0x0000004002097836ULL, 0x040fe20000000000ULL, 0x0000000b0b0b7899ULL, 0x000fe2000800063fULL,
0x00000060020b7836ULL, 0x040fe20000000000ULL, 0x00000800160c78a5ULL, 0x000fe2000f8e000cULL,
0x0000000a03147c10ULL, 0x000fe2000fffe000ULL, 0x0000000416047291ULL, 0x000fe2000f8e603fULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x000008000b0b7892ULL, 0x000fe2000f8ec03fULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000e191c8290ULL, 0x000fe2000fffe03fULL,
0x0000000cff047e24ULL, 0x000fe2000f8e00ffULL, 0x0000000a061d8291ULL, 0x000fe2000f8e483fULL,
0x0000000dff057e24ULL, 0x000fe2000f8e00ffULL, 0x0000000a061e8291ULL, 0x000fe2000f8e483fULL,
0x0000000014147984ULL, 0x000e620000000800ULL, 0x0000000b040b7290ULL, 0x000fe2000fffe03fULL,
0x0000001007067825ULL, 0x100fe200078e0004ULL, 0x000000801c0c88a5ULL, 0x000fe2000f8e001aULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000001d161d8291ULL, 0x000fe2000f8e403fULL,
0x0000001009087825ULL, 0x100fe200078e0004ULL, 0x000000800e0e88a5ULL, 0x000fe2000f8e001aULL,
0x0000000b02117c11ULL, 0x040fe2000f8e20ffULL, 0x0000001e161e8291ULL, 0x000fe2000f8e403fULL,
0x000000100b0a7825ULL, 0x100fe200078e0004ULL, 0x0000001d051d8291ULL, 0x000fe2000f8e383fULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000001e051e8291ULL, 0x000fe2000f8e383fULL,
0x0000001002047825ULL, 0x000fe200078e0004ULL, 0x000000150600728cULL, 0x000fe2000bf06070ULL,
0x00000000001c7805ULL, 0x000fc4000001ff00ULL, 0x0000001d02138c11ULL, 0x040fe2000f8e20ffULL,
0x0000000cff0c7e24ULL, 0x000fe2000f8e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000004117faeULL, 0x000fe2000b901c52ULL, 0x0000000dff0d7e24ULL, 0x000fe2000f8e00ffULL,
0x0000001e02218c11ULL, 0x040fe2000f8e20ffULL, 0x0000000eff0e7e24ULL, 0x000fe2000f8e00ffULL,
0x0038000006117faeULL, 0x000fe2000b901c52ULL, 0x0000000fff0f7e24ULL, 0x000fe2000f8e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000010020c8825ULL, 0x000fe200078e000cULL,
0x0058000008117faeULL, 0x000fe2000b901c52ULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000010020e8825ULL, 0x000fe200078e000eULL,
0x007800000a117faeULL, 0x000fe2000b901c52ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x045800000c138faeULL, 0x000fe2000b901c52ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x041800000e218faeULL, 0x0005e2000b901c52ULL, 0x000000000000781cULL, 0x000fe40003f0f008ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000207805ULL, 0x004fce000001ff00ULL,
0x0000000800b00947ULL, 0x002fea0003800000ULL, 0x00000003ff047819ULL, 0x100fe20000011602ULL,
0x0000000a06057291ULL, 0x000fe2000f8e483fULL, 0xfffffff8ff057812ULL, 0x000fe200078ee202ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x0000000304047812ULL, 0x000fe200078ec0ffULL,
0x0000000516057291ULL, 0x000fe2000f8e403fULL, 0x00000002ff397819ULL, 0x000fe20000011602ULL,
0x0000000805097836ULL, 0x040fe20000000000ULL, 0x0000000404067812ULL, 0x000fe200078efcffULL,
0x0000000805387824ULL, 0x000fe200078e00ffULL, 0x0000000704077812ULL, 0x000fe200078e7805ULL,
0x00000008393c7836ULL, 0x000fe20000000000ULL, 0x0000000706057812ULL, 0x000fe200078e7805ULL,
0x00000005ff377e24ULL, 0x000fe2000f8e00ffULL, 0x00000007043a7812ULL, 0x000fe200078e7809ULL,
0x0000000600057c82ULL, 0x000fe20008000000ULL, 0x0000000706067812ULL, 0x000fe200078e7809ULL,
0x0000000809097824ULL, 0x000fe200078e00ffULL, 0x0000003807367212ULL, 0x080fe200078efcffULL,
0x00009800001e7ab9ULL, 0x000fe20000000a00ULL, 0x0000003805387212ULL, 0x000fc400078efcffULL,
0x000000093a3a7212ULL, 0x080fe400078efcffULL, 0x00000009063b7212ULL, 0x000fce00078efcffULL,
0x00000002050b7890ULL, 0x000fc8000fffe03fULL, 0x000000150b00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000c80947ULL, 0x000fea0003800000ULL,
0x000000070200780cULL, 0x040fe20003f04070ULL, 0x0000000b081a7290ULL, 0x000fe2000fffe03fULL,
0x0000002002077836ULL, 0x040fe20000000000ULL, 0x000000013f0c7899ULL, 0x000fe2000801160bULL,
0x0000004002097836ULL, 0x040fe20000000000ULL, 0x0000000a0b0e7899ULL, 0x000fe2000800063fULL,
0x00000060023d7836ULL, 0x000fe20000000000ULL, 0x0000001a090d7291ULL, 0x000fe4000f8fa03fULL,
0x000000010c1d7892ULL, 0x000fe4000f8ec03fULL, 0x000008000e0e7892ULL, 0x000fc4000f8ec03fULL,
0x00000000003f7886ULL, 0x000fe20000000000ULL, 0x000010000d0c78a5ULL, 0x000fe2000f8e001eULL,
0x0000001dff107e24ULL, 0x000fe2000f8e00ffULL, 0x0000000e041c7290ULL, 0x000fe4000fffe03fULL,
0x0000000a06208291ULL, 0x000fe4000f8e483fULL, 0x0000000a06218291ULL, 0x000fe4000f8e483fULL,
0x0000002016208291ULL, 0x000fe2000f8e403fULL, 0x0000001c02117c11ULL, 0x000fe2000f8e20ffULL,
0x00000800160c78a5ULL, 0x000fc4000f8e000cULL, 0x0000001a190e8290ULL, 0x000fe4000fffe03fULL,
0x0000002116218291ULL, 0x000fe2000f8e403fULL, 0x0000002000378c02ULL, 0x000fe20008000f00ULL,
0x000000800e0e88a5ULL, 0x000fe2000f8e001eULL, 0x0000000cff0a7e24ULL, 0x000fe2000f8e00ffULL,
0x000000801a1a88a5ULL, 0x000fe2000f8e001eULL, 0x0000000dff0b7e24ULL, 0x000fe4000f8e00ffULL,
0x0000008010138824ULL, 0x000fe400078e0237ULL, 0x00000021ff378e24ULL, 0x000fc4000f8e00ffULL,
0x0000001007067825ULL, 0x000fc800078e000aULL, 0x0000001002047825ULL, 0x000fc800078e000aULL,
0x0000001009087825ULL, 0x100fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000004117faeULL, 0x0003e6000b901c52ULL, 0x0000000eff0c7e24ULL, 0x000fe2000f8e00ffULL,
0x0038000006117faeULL, 0x0003e2000b901c52ULL, 0x0000000fff0d7e24ULL, 0x000fe4000f8e00ffULL,
0x000000103d0a7825ULL, 0x000fe200078e000aULL, 0x0058000008117faeULL, 0x0003e6000b901c52ULL,
0x0000001aff0e7e24ULL, 0x000fe2000f8e00ffULL, 0x007800000a117faeULL, 0x0003e2000b901c52ULL,
0x0000001bff0f7e24ULL, 0x000fc4000f8e00ffULL, 0x00000080103d8824ULL, 0x000fe400078e0237ULL,
0x00000010020c8825ULL, 0x000fc800078e000cULL, 0x0000001002138824ULL, 0x040fe400078e0213ULL,
0x00000010020e8825ULL, 0x000fc600078e000eULL, 0x045800000c138faeULL, 0x0003e2000b901c52ULL,
0x00000010023d8824ULL, 0x000fca00078e023dULL, 0x041800000e3d8faeULL, 0x0003e4000b901c52ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000005000c7c82ULL, 0x000fe40008000000ULL,
0x000000060c057899ULL, 0x000fc8000800063fULL, 0x0000008005057892ULL, 0x000fcc000f8ec03fULL,
0x0000000500047c10ULL, 0x002fe2000fffe037ULL, 0x0000000a0c057899ULL, 0x000fc8000800063fULL,
0x00000001033d7824ULL, 0x000fe200078e0204ULL, 0x0000080005057892ULL, 0x000fc8000f8ec03fULL,
0x0000018004057890ULL, 0x000fe2000fffe005ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180003d0d7984ULL, 0x000e620000000800ULL, 0x0000000536047c11ULL, 0x000fe4000f8e20ffULL,
0x0000000538087c11ULL, 0x000fe2000f8e20ffULL, 0x004580003d3f7984ULL, 0x000fe20000000800ULL,
0x000000053a0c7c11ULL, 0x000fe4000f8e20ffULL, 0x000000053b107c11ULL, 0x000fe2000f8e20ffULL,
0x000000000404783bULL, 0x000ea20000000200ULL, 0x0000000b00057c82ULL, 0x000fe40008000000ULL,
0x000000150500728cULL, 0x000fe2000bf06070ULL, 0x000000000808783bULL, 0x000eea0000000200ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000d14117221ULL, 0x002fc40000010100ULL,
0x000000000c0c783bULL, 0x000e640000000200ULL, 0x3fb8aa3b11427820ULL, 0x000fe40000410000ULL,
0x000000001010783bULL, 0x000f220000000200ULL, 0x30000005ff3e7230ULL, 0x004fc60000004100ULL,
0x0000004200427308ULL, 0x000ea20000000800ULL, 0x20000007ff417230ULL, 0x000fe40000004100ULL,
0x30000007ff407230ULL, 0x000fe40000004100ULL, 0x20000009ff437230ULL, 0x008fe40000004100ULL,
0x2000000bff457230ULL, 0x000fe40000004100ULL, 0x3000000bff447230ULL, 0x000fe40000004100ULL,
0x20000004ff3d7230ULL, 0x000fc40000004100ULL, 0x20000008ff077230ULL, 0x000fe40000004100ULL,
0x0000003f424e7220ULL, 0x004fe20000410000ULL, 0x20000005ff3f7230ULL, 0x000fe40000004100ULL,
0x30000009ff427230ULL, 0x000fe40000004100ULL, 0x000000354e357221ULL, 0x000fe20000010000ULL,
0x00001f394e4f7589ULL, 0x000ea200000e0000ULL, 0x20000006ff057230ULL, 0x000fe40000004100ULL,
0x2000000aff097230ULL, 0x000fe20000004100ULL, 0x00001f3c4e507589ULL, 0x000ee200000e0000ULL,
0x30000004ff047230ULL, 0x000fc40000004100ULL, 0x30000006ff067230ULL, 0x000fe40000004100ULL,
0x30000008ff087230ULL, 0x000fe40000004100ULL, 0x3000000aff0a7230ULL, 0x000fe40000004100ULL,
0x2000000dff477230ULL, 0x002fe40000004100ULL, 0x3000000dff467230ULL, 0x000fe40000004100ULL,
0x2000000fff497230ULL, 0x000fc40000004100ULL, 0x3000000fff487230ULL, 0x000fe40000004100ULL,
0x20000011ff4b7230ULL, 0x010fe40000004100ULL, 0x30000011ff4a7230ULL, 0x000fe40000004100ULL,
0x0000004f3d347223ULL, 0x084fe20000010034ULL, 0x2000000cff0b7230ULL, 0x000fe40000004100ULL,
0x0000004f04337223ULL, 0x000fe20000010033ULL, 0x2000000eff0d7230ULL, 0x000fc40000004100ULL,
0x0000004f3f327223ULL, 0x080fe20000010032ULL, 0x20000010ff0f7230ULL, 0x000fe40000004100ULL,
0x0000004f3e2f7223ULL, 0x080fe2000001002fULL, 0x20000012ff117230ULL, 0x000fe40000004100ULL,
0x0000004f052e7223ULL, 0x080fe2000001002eULL, 0x3000000cff0c7230ULL, 0x000fe40000004100ULL,
0x0000004f062b7223ULL, 0x000fe2000001002bULL, 0x3000000eff0e7230ULL, 0x000fc40000004100ULL,
0x0000004f412a7223ULL, 0x080fe2000001002aULL, 0x30000010ff107230ULL, 0x000fe40000004100ULL,
0x0000004f40277223ULL, 0x080fe20000010027ULL, 0x30000012ff127230ULL, 0x000fe40000004100ULL,
0x0000004f07267223ULL, 0x080fe20000010026ULL, 0x20000013ff4d7230ULL, 0x000fe40000004100ULL,
0x0000004f08237223ULL, 0x000fe20000010023ULL, 0x30000013ff4c7230ULL, 0x000fc40000004100ULL,
0x0000004f43227223ULL, 0x080fe20000010022ULL, 0x0000004f421f7223ULL, 0x080fe2000001001fULL,
0x0000004f091e7223ULL, 0x080fe2000001001eULL, 0x0000004f0a1b7223ULL, 0x080fe2000001001bULL,
0x0000004f451a7223ULL, 0x080fe2000001001aULL, 0x0000004f44177223ULL, 0x000fe20000010017ULL,
0x000000500b167223ULL, 0x088fe20000010016ULL, 0x000000500c317223ULL, 0x080fe20000010031ULL,
0x0000005047307223ULL, 0x080fe20000010030ULL, 0x00000050462d7223ULL, 0x080fe2000001002dULL,
0x000000500d2c7223ULL, 0x080fe2000001002cULL, 0x000000500e297223ULL, 0x080fe20000010029ULL,
0x0000005049287223ULL, 0x080fe20000010028ULL, 0x0000005048257223ULL, 0x080fe20000010025ULL,
0x000000500f247223ULL, 0x080fe20000010024ULL, 0x0000005010217223ULL, 0x080fe20000010021ULL,
0x000000504b207223ULL, 0x080fe20000010020ULL, 0x000000504a1d7223ULL, 0x080fe2000001001dULL,
0x00000050111c7223ULL, 0x080fe2000001001cULL, 0x0000005012197223ULL, 0x080fe20000010019ULL,
0x000000504d187223ULL, 0x080fe20000010018ULL, 0x000000504c157223ULL, 0x000fe20000010015ULL,
0xfffffff400ac8947ULL, 0x000fec000383ffffULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x00000016ff007c0cULL, 0x000fe2000bf05270ULL, 0x000049800a047890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002007812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000403007c10ULL, 0x000fe2000fffe000ULL, 0x0000000000200947ULL, 0x000fec0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x0000000a060a7291ULL, 0x000fe2000f8e383fULL,
0x0000001002037824ULL, 0x002fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fc80000011602ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ec0ffULL,
0x0000000a02027c10ULL, 0x000fca000fffe003ULL, 0x0049803502007388ULL, 0x0003e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000000027984ULL, 0x002e680000000800ULL,
0x0000800000037984ULL, 0x000ea20000000800ULL, 0x00000002ff027221ULL, 0x002fc80000010000ULL,
0x0000000302027221ULL, 0x004fc80000010000ULL, 0x0180000002037836ULL, 0x000fca0000000000ULL,
0x7f80000003037812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000000000140947ULL, 0x000fea0003800000ULL,
0x000000ffff497224ULL, 0x000fe200078e0002ULL, 0x0000967000067802ULL, 0x000fce0000000f00ULL,
0x0000007400787944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0005ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000200037308ULL, 0x000e640000001000ULL,
0xbf80000002007423ULL, 0x002fc80000000003ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000027919ULL, 0x000ea40000000000ULL,
0x00000002ff097819ULL, 0x104fe40000011602ULL, 0x00000008020d7811ULL, 0x000fe400078ff0ffULL,
0x00000003ff037819ULL, 0x000fe20000011602ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0900047589ULL, 0x000ea200000e0000ULL, 0xfffffff8ff117812ULL, 0x000fc600078ee202ULL,
0x00001f0d000d7589ULL, 0x00072400000e0000ULL, 0x0000000811137836ULL, 0x000fe20000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000003404347220ULL, 0x044fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000003204057220ULL, 0x040fe20000410000ULL,
0x0000002f04067220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002a04077220ULL, 0x040fe20000410000ULL,
0x0000002704087220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000002204097220ULL, 0x040fe20000410000ULL,
0x0000001f04007220ULL, 0x048fe20000410000ULL, 0x0000001e040a7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000001a040b7220ULL, 0x040fe20000410000ULL,
0x00000017040c7220ULL, 0x000fe20000410000ULL, 0x0000000303047812ULL, 0x000fe200078ec0ffULL,
0x000000160d167220ULL, 0x050fe20000410000ULL, 0x000000310d317220ULL, 0x040fe20000410000ULL,
0x000000300d307220ULL, 0x040fe20000410000ULL, 0x0000000404147812ULL, 0x000fe200078efcffULL,
0x0000002d0d2d7220ULL, 0x040fe20000410000ULL, 0x0000002c0d0e7220ULL, 0x040fe20000410000ULL,
0x000000290d297220ULL, 0x040fe20000410000ULL, 0x000000280d0f7220ULL, 0x040fe20000410000ULL,
0x000000250d107220ULL, 0x040fe20000410000ULL, 0x000000240d247220ULL, 0x040fe20000410000ULL,
0x000000210d217220ULL, 0x040fe20000410000ULL, 0x000000200d207220ULL, 0x040fe20000410000ULL,
0x0000001d0d1d7220ULL, 0x040fe20000410000ULL, 0x0000001c0d1c7220ULL, 0x040fe20000410000ULL,
0x000000190d197220ULL, 0x040fe20000410000ULL, 0x000000180d187220ULL, 0x040fe20000410000ULL,
0x000000150d157220ULL, 0x000fe20000410000ULL, 0x00000008110d7824ULL, 0x000fe200078e00ffULL,
0x0000000704127812ULL, 0x000fe200078e7811ULL, 0x0000000813177824ULL, 0x000fe200078e00ffULL,
0x00000007041a7812ULL, 0x000fc400078e7813ULL, 0x0000000714047812ULL, 0x000fe400078e7811ULL,
0x0000000714147812ULL, 0x000fe200078e7813ULL, 0x00000006ff137e24ULL, 0x000fe2000f8e00ffULL,
0x0000000d12127212ULL, 0x080fe400078efcffULL, 0x0000000d04117212ULL, 0x000fe400078efcffULL,
0x000000171a1a7212ULL, 0x080fe400078efcffULL, 0x0000001714147212ULL, 0x000fc400078efcffULL,
0x000000050605723eULL, 0x000fe400000000ffULL, 0x000000090009723eULL, 0x000fe400000000ffULL,
0x000000343304723eULL, 0x000fe400000000ffULL, 0x0000002e2b06723eULL, 0x000fe400000000ffULL,
0x000000070807723eULL, 0x000fe400000000ffULL, 0x000000201d25723eULL, 0x000fc400000000ffULL,
0x0000001812007c11ULL, 0x000fe4000f8e20ffULL, 0x000000262308723eULL, 0x000fe400000000ffULL,
0x0000000a1b0a723eULL, 0x000fe200000000ffULL, 0x0000000400007844ULL, 0x000fe20000000200ULL,
0x0000000b0c0b723eULL, 0x000fe400000000ffULL, 0x000000242124723eULL, 0x000fe400000000ffULL,
0x0000001811207c11ULL, 0x000fc4000f8e20ffULL, 0x00000016310c723eULL, 0x000fe400000000ffULL,
0x000000302d0d723eULL, 0x000fe200000000ffULL, 0x0000000820007844ULL, 0x000fe20000000200ULL,
0x0000000e290e723eULL, 0x000fe400000000ffULL, 0x0000000f100f723eULL, 0x000fe200000000ffULL,
0x0000002013107824ULL, 0x000fe200078e0202ULL, 0x000000181a217c11ULL, 0x000fe4000f8e20ffULL,
0x0000001c1926723eULL, 0x000fc400000000ffULL, 0x000000181527723eULL, 0x000fe200000000ffULL,
0x0000000c21007844ULL, 0x000fe20000000200ULL, 0x0000001814227c11ULL, 0x000fe4000f8e20ffULL,
0x0000000710237c11ULL, 0x000fc6000f8e20ffULL, 0x0000002422007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000023107984ULL, 0x000ea80000000c00ULL,
0x0004000023187984ULL, 0x000ee80000000c00ULL, 0x0008000023147984ULL, 0x000f280000000c00ULL,
0x000c0000231c7984ULL, 0x000f620000000c00ULL, 0x200000ff13137230ULL, 0x004fc40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fe40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x200000ff1b1b7230ULL, 0x008fe40000000000ULL,
0x200000ff1a1a7230ULL, 0x000fe40000000000ULL, 0x200000ff19197230ULL, 0x000fc40000000000ULL,
0x200000ff18187230ULL, 0x000fe40000000000ULL, 0x0000001713137230ULL, 0x010fe40000000000ULL,
0x0000001612127230ULL, 0x000fe40000000000ULL, 0x0000001511117230ULL, 0x000fe40000000000ULL,
0x0000001410107230ULL, 0x000fe40000000000ULL, 0x0000001f1b1b7230ULL, 0x020fc40000000000ULL,
0x0000001e1a1a7230ULL, 0x000fe20000000000ULL, 0x0000001023007388ULL, 0x0005e20000000c00ULL,
0x0000001d19197230ULL, 0x000fe40000000000ULL, 0x0000001c18187230ULL, 0x000fca0000000000ULL,
0x0004001823007388ULL, 0x0005e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000006ff007c0cULL, 0x000fda000bf05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x000e620000002600ULL, 0x0000000316067899ULL, 0x000fe2000800063fULL,
0x0000002002047836ULL, 0x044fe20000000000ULL, 0x0000000316087899ULL, 0x000fe2000800063fULL,
0x00000040021d7836ULL, 0x040fe20000000000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x00000060021f7836ULL, 0x000fe20000000000ULL, 0x0000840000057ab9ULL, 0x000fe20000000800ULL,
0x00000006ff217e24ULL, 0x000fe2000f8e00ffULL, 0x00000003ff157819ULL, 0x000fe2000001161dULL,
0x00000008ff1b7e24ULL, 0x000fe2000f8e00ffULL, 0x00000003ff167819ULL, 0x000fe2000001161fULL,
0x0000000405057899ULL, 0x000fe2000800063fULL, 0xfffffff821217812ULL, 0x000fe200078ee202ULL,
0x0000860000087ab9ULL, 0x000fe20000000a00ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee204ULL,
0x00000006ff1a7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000716067812ULL, 0x000fc800078e481fULL,
0x0ffffff806067812ULL, 0x000fc800078ef81fULL, 0x0000000706107c11ULL, 0x000fe2000f8e20ffULL,
0x00000004050472a4ULL, 0x004fca000f8e023fULL, 0x0000000010107984ULL, 0x000fe20000000c00ULL,
0x0000001017007824ULL, 0x042fe200078e00ffULL, 0x0000000316057899ULL, 0x000fe2000800063fULL,
0x0000001017147824ULL, 0x040fe400078e00ffULL, 0x0000001017187824ULL, 0x040fe200078e00ffULL,
0xfffffff000007812ULL, 0x000fe200078ee203ULL, 0x0000001017177824ULL, 0x000fe200078e00ffULL,
0x0000000703037812ULL, 0x000fe200078e4802ULL, 0x00000005ff1e7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000400007c10ULL, 0x000fc4000ff1e0ffULL, 0x0ffffff803077812ULL, 0x000fe400078ef802ULL,
0x00000003ff037819ULL, 0x000fe40000011604ULL, 0xfffffff017167812ULL, 0x000fe400078ee216ULL,
0x0000000703027812ULL, 0x000fe400078e4804ULL, 0xfffffff014147812ULL, 0x000fe200078ee203ULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x0ffffff802027812ULL, 0x000fc400078ef804ULL,
0x0000000715047812ULL, 0x000fe400078e481dULL, 0x0000000702027c11ULL, 0x000fe4000f8e20ffULL,
0x0ffffff804057812ULL, 0x000fe400078ef81dULL, 0x0000000707047c11ULL, 0x000fe2000f8e20ffULL,
0x0000000002087984ULL, 0x0003e20000000c00ULL, 0x00000007050c7c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff018157812ULL, 0x000fc400078ee215ULL, 0x0000000004047984ULL, 0x000ea20000000c00ULL,
0xfffffff81a1d7812ULL, 0x000fe400078ee21dULL, 0x0000000800027c11ULL, 0x042fe2000f8040ffULL,
0x000000000c0c7984ULL, 0x000e620000000c00ULL, 0x0000000415177c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000900037c11ULL, 0x000fe400080f4403ULL, 0x00000004141c7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x0000000416007c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001021027825ULL, 0x000fe200078e0002ULL, 0x0000000817167c11ULL, 0x000fc4000f8240ffULL,
0xfffffff81e1f7812ULL, 0x000fe200078ee21fULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x000000081c147c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x0000000800187c11ULL, 0x000fe4000f8440ffULL, 0x000000091c157c11ULL, 0x000fe400080f4415ULL,
0x0000000917177c11ULL, 0x000fe400088f441aULL, 0x0000000900197c11ULL, 0x000fe200090f4419ULL,
0x000000101b147825ULL, 0x000fc800078e0014ULL, 0x000000101d167825ULL, 0x000fc800078e0016ULL,
0x000000101f187825ULL, 0x000fe200078e0018ULL, 0x0000000402007986ULL, 0x004fe8000c101d12ULL,
0x0000000814007986ULL, 0x000fe8000c101d12ULL, 0x0000000c16007986ULL, 0x002fe8000c101d12ULL,
0x0000001018007986ULL, 0x000fe2000c101d12ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000004a0e72caULL, 0x000fe200000e0000ULL, 0x000000013f067899ULL, 0x000fc80008011614ULL,
0x01ffffff06067892ULL, 0x000fd0000f8ec03fULL, 0x000000060e067291ULL, 0x000fc8000f8e083fULL,
0x000000070600728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x0000000104088899ULL, 0x000fe2000800063fULL, 0x00009000000b8ab9ULL, 0x000fe20000000800ULL,
0x00008c00000c8ab9ULL, 0x000fe40000000a00ULL, 0x0000000b080882a4ULL, 0x000fc8000f8e0206ULL,
0x00000004080c88a5ULL, 0x000fcc000f8e000cULL, 0x0000000cff027e24ULL, 0x000fe4000f8e00ffULL,
0x0000000dff037e24ULL, 0x000fca000f8e00ffULL, 0x0000001202028981ULL, 0x000ea2000c1e1900ULL,
0x000000014a007836ULL, 0x000fe20000000000ULL, 0x0000000614167899ULL, 0x000fe4000800063fULL,
0x0000000709097899ULL, 0x000fe4000800063fULL, 0x000000160e0c7291ULL, 0x000fe2000f8e403fULL,
0xffffffff00087882ULL, 0x000fe20000000000ULL, 0x000000070a0a7899ULL, 0x000fe4000800063fULL,
0x00000040090d7892ULL, 0x000fe2000f8ef80cULL, 0x00000000020b82caULL, 0x004fc400000e0000ULL,
0x0000000500007c0cULL, 0x000fd6000bf06070ULL, 0x0000000b00088c82ULL, 0x000fe40008000000ULL,
0x0000000c00448947ULL, 0x000fea0003800000ULL, 0x00000000007d7919ULL, 0x000e620000000000ULL,
0x0000000c1700728cULL, 0x000fe2000bf01070ULL, 0x00000000000e79c3ULL, 0x000ea60000008800ULL,
0x0000000c170b7287ULL, 0x000fc8000c000000ULL, 0x0000000b0c0b7290ULL, 0x000fe4000fffe13fULL,
0x0000000a080c72a4ULL, 0x000fc6000f8e020dULL, 0x00000400000d7882ULL, 0x000fe40000000000ULL,
0x000006540e107896ULL, 0x004fc8000800000dULL, 0x00000010140d7291ULL, 0x000fe2000f8e703fULL,
0x00000003ff087819ULL, 0x002fe4000001167dULL, 0x0ffffff87d037812ULL, 0x040fe200078ec0ffULL,
0x000010000d0d7890ULL, 0x000fe2000fffe03fULL, 0x0000007d08007212ULL, 0x0c0fe200078e3cffULL,
0x0000000408047836ULL, 0x040fe40000000000ULL, 0x0000000c080a7836ULL, 0x000fe20000000000ULL,
0x00000007030c7812ULL, 0x000fe200078ef800ULL, 0x0000000804177824ULL, 0x040fe200078e00ffULL,
0x0000007d04027212ULL, 0x080fe200078e3cffULL, 0x0000000808067836ULL, 0x000fe20000000000ULL,
0x0000007d0a057212ULL, 0x0c0fe200078e3cffULL, 0x000000080a0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee202ULL, 0x0000000806077824ULL, 0x040fe200078e00ffULL,
0x00008a00ff027b82ULL, 0x000e620000000a00ULL, 0x0000007d06007212ULL, 0x000fe200078e3cffULL,
0x0000001008147836ULL, 0x040fe20000000000ULL, 0xfffffff80e1b7812ULL, 0x000fe200078ee205ULL,
0x0000001c08167836ULL, 0x040fe20000000000ULL, 0x0000007f08057812ULL, 0x000fe200078ec0ffULL,
0x00000008141c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8071a7812ULL, 0x000fe200078ee200ULL,
0x000000107d007824ULL, 0x000fe200078e00ffULL, 0x0000007f04077812ULL, 0x000fe200078ec0ffULL,
0x0000000c05057c36ULL, 0x000fe20008000000ULL, 0x0000007f060b7812ULL, 0x000fe200078ec0ffULL,
0x0000002808207836ULL, 0x000fe20000000000ULL, 0x0000000b04007c0cULL, 0x000fe2000bf46070ULL,
0x0000000c07077c36ULL, 0x000fe20008000000ULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x0000000c0b0b7c36ULL, 0x000fe20008000000ULL, 0x0000000b06007c0cULL, 0x000fe2000bf06070ULL,
0x0000002c08227836ULL, 0x000fe20000000000ULL, 0x0000007f0a097812ULL, 0x000fe200078ec0ffULL,
0x0000003008247836ULL, 0x000fe20000000000ULL, 0x0000007f140d7812ULL, 0x000fc400078ec0ffULL,
0x0000000b0a007c0cULL, 0x000fe2000bf26070ULL, 0x0000010005047825ULL, 0x002fe200078e0002ULL,
0x0000000d17177c11ULL, 0x000fc6000f8e20ffULL, 0x0000010007067825ULL, 0x000fe200078e0002ULL,
0x00000004000e7210ULL, 0x000fc60007f7e0ffULL, 0x000001000b0a7825ULL, 0x000fe200078e0002ULL,
0x0000000600107210ULL, 0x000fc60007f9e0ffULL, 0x0000000c09097c36ULL, 0x000fe40008000000ULL,
0x0000000c0d0d7c36ULL, 0x000fe40008000000ULL, 0x000000ffff0f7224ULL, 0x000fe200018e0605ULL,
0x0000000a00187210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe400020e0607ULL,
0x0000010009047825ULL, 0x000fe200078e0002ULL, 0x0000007d14097212ULL, 0x000fc600078e3cffULL,
0x000001000d067825ULL, 0x000fe200078e0002ULL, 0xfffffff81c1c7812ULL, 0x000fe400078ee209ULL,
0x0000007f160d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff197224ULL, 0x000fe200018e060bULL,
0x0000000400127210ULL, 0x000fe20007f7e0ffULL, 0x00000014080a7836ULL, 0x000fe20000000000ULL,
0x0000000600047210ULL, 0x000fe20007f9e0ffULL, 0x0000000c0d0d7c36ULL, 0x000fe20008000000ULL,
0x0000000d0c097c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff137224ULL, 0x000fe200018e0605ULL,
0x0000007f0a067812ULL, 0x040fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fe200020e0607ULL,
0x0000000b0a007c0cULL, 0x040fe2000bfa6070ULL, 0x000001000d0c7825ULL, 0x000fe200078e0002ULL,
0x0000007d0a0b7212ULL, 0x000fc400078e3cffULL, 0x0000000b14007c0cULL, 0x000fe2000bf86070ULL,
0x000000080a0a7824ULL, 0x000fe200078e00ffULL, 0x0000000b08007c0cULL, 0x040fe2000bf66070ULL,
0x0000001808147836ULL, 0x000fe40000000000ULL, 0x0000000c06077c36ULL, 0x000fe20008000000ULL,
0xfffffff80a1d7812ULL, 0x000fe200078ee20bULL, 0x00000008141e7824ULL, 0x040fe200078e00ffULL,
0x0000007f140b7812ULL, 0x040fe200078ec0ffULL, 0x0000010007067825ULL, 0x000fe200078e0002ULL,
0x0000007d14157212ULL, 0x000fc600078e3cffULL, 0x0000000c0b0b7c36ULL, 0x000fe20008000000ULL,
0x0000000600067210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e097faeULL, 0x0003e2000d901c52ULL, 0x0000000b14007c0cULL, 0x000fe2000bf66070ULL,
0x000001000b0a7825ULL, 0x000fe200078e0002ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee215ULL,
0x0000000010177faeULL, 0x0005e2000d101c52ULL, 0x0000000b16007c0cULL, 0x040fe2000bf46070ULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x0000000a00147210ULL, 0x000fe20007fde0ffULL,
0x00000008160a7824ULL, 0x040fe200078e00ffULL, 0x0000007d16097212ULL, 0x002fc600078e3cffULL,
0x000000ffff157224ULL, 0x000fe200030e060bULL, 0x0000000c00167210ULL, 0x000fe20007fde0ffULL,
0x00000020080c7836ULL, 0x000fe20000000000ULL, 0xfffffff80a1f7812ULL, 0x000fe400078ee209ULL,
0x0000000d1a097c11ULL, 0x000fe2000f8e20ffULL, 0x00000024081a7836ULL, 0x000fe20000000000ULL,
0x0000007f0c0b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff177224ULL, 0x004fe200030e060dULL,
0x0000007f200f7812ULL, 0x000fe200078ec0ffULL, 0x0000000018097faeULL, 0x0003e2000c101c52ULL,
0x0000007f1a0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000c0b0b7c36ULL, 0x000fe20008000000ULL,
0x0000007d0c0e7212ULL, 0x040fe200078e3cffULL, 0x000000080c117824ULL, 0x040fe200078e00ffULL,
0x0000000b0c007c0cULL, 0x000fe2000bf06070ULL, 0x000001000b0a7825ULL, 0x000fc800078e0002ULL,
0x0000000c0d0d7c36ULL, 0x000fe20008000000ULL, 0x0000000a000a7210ULL, 0x000fe20007fde0ffULL,
0x0000000c0f0f7c36ULL, 0x000fe20008000000ULL, 0x0000000d1b097c11ULL, 0x002fe2000f8e20ffULL,
0x000001000d0c7825ULL, 0x000fe200078e0002ULL, 0x0000007d1a197212ULL, 0x040fe400078e3cffULL,
0xfffffff811187812ULL, 0x000fe200078ee20eULL, 0x0000000012097faeULL, 0x0003e2000c901c52ULL,
0x0000000b1a007c0cULL, 0x040fe2000bf26070ULL, 0x000000081a1a7824ULL, 0x000fe200078e00ffULL,
0x0000007f22117812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x0000000c000c7210ULL, 0x000fe20007fde0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0002ULL,
0xfffffff81a1a7812ULL, 0x000fc400078ee219ULL, 0x0000000d1c197c11ULL, 0x000fe2000f8e20ffULL,
0x0000000c11117c36ULL, 0x000fe20008000000ULL, 0x0000007d201b7212ULL, 0x080fe200078e3cffULL,
0x000000ffff0d7224ULL, 0x000fe200030e060dULL, 0x0000000d1d097c11ULL, 0x002fe2000f8e20ffULL,
0x0000000004197faeULL, 0x0003e2000e101c52ULL, 0x0000007f24137812ULL, 0x000fe200078ec0ffULL,
0x0000010011107825ULL, 0x000fe200078e0002ULL, 0x0000000b20007c0cULL, 0x040fe2000bf86070ULL,
0x0000000006097faeULL, 0x0005e2000e901c52ULL, 0x0000000e000e7210ULL, 0x000fe20007fde0ffULL,
0x0000000820207824ULL, 0x000fe200078e00ffULL, 0x0000000b22007c0cULL, 0x040fe2000bfa6070ULL,
0x0000000c13137c36ULL, 0x000fe20008000000ULL, 0x0000007d221c7212ULL, 0x080fe200078e3cffULL,
0x000000ffff0f7224ULL, 0x000fe200030e060fULL, 0xfffffff8201b7812ULL, 0x000fe200078ee21bULL,
0x0000003c08207836ULL, 0x000fe20000000000ULL, 0x0000000d1e057c11ULL, 0x002fe2000f8e20ffULL,
0x00000038081e7836ULL, 0x040fe20000000000ULL, 0x0000001000107210ULL, 0x000fe20007fde0ffULL,
0x0000003408067836ULL, 0x004fe20000000000ULL, 0x0000000d1f077c11ULL, 0x000fe2000f8e20ffULL,
0x0000010013127825ULL, 0x000fe200078e0002ULL, 0x0000007f1e047812ULL, 0x000fe200078ec0ffULL,
0x0000000014057faeULL, 0x0003e2000d901c52ULL, 0x0000007f06097812ULL, 0x040fe200078ec0ffULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x0000001200127210ULL, 0x000fe20007fde0ffULL,
0x0000000016077faeULL, 0x0005e2000d101c52ULL, 0x0000000b06007c0cULL, 0x000fe2000bf46070ULL,
0x0000000c09097c36ULL, 0x000fe20008000000ULL, 0x00000013ff137210ULL, 0x000fe200037fe4ffULL,
0x0000000824197824ULL, 0x040fe200078e00ffULL, 0x0000007d24087212ULL, 0x080fe200078e3cffULL,
0x00000008221d7824ULL, 0x000fe200078e00ffULL, 0x0000000b24007c0cULL, 0x000fe2000bf66070ULL,
0x0000000c04157c36ULL, 0x002fe20008000000ULL, 0x0000007f20147812ULL, 0x000fe200078ec0ffULL,
0x0000010009047825ULL, 0x000fe200078e0002ULL, 0x0000007d06097212ULL, 0x000fc400078e3cffULL,
0xfffffff819087812ULL, 0x000fe200078ee208ULL, 0x0000000806167824ULL, 0x004fe200078e00ffULL,
0x0000000400047210ULL, 0x000fe20007fde0ffULL, 0x0000010015067825ULL, 0x000fe200078e0002ULL,
0xfffffff81d1c7812ULL, 0x000fc600078ee21cULL, 0x0000000c14157c36ULL, 0x000fe20008000000ULL,
0xfffffff816147812ULL, 0x000fe200078ee209ULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x0000000d18097c11ULL, 0x000fe2000f8e20ffULL, 0x0000010015027825ULL, 0x000fe200078e0002ULL,
0x0000000d1a157c11ULL, 0x000fe4000f8e20ffULL, 0x0000000600067210ULL, 0x000fe20007fde0ffULL,
0x000000081e177824ULL, 0x040fe200078e00ffULL, 0x000000000a097faeULL, 0x0003e2000c101c52ULL,
0x0000007d1e167212ULL, 0x080fe200078e3cffULL, 0x0000000820197824ULL, 0x000fe200078e00ffULL,
0x0000000b1e007c0cULL, 0x000fe2000bf06070ULL, 0x000000000c157faeULL, 0x0005e2000c901c52ULL,
0x0000000b20007c0cULL, 0x040fe2000bf26070ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000007d20187212ULL, 0x000fc400078e3cffULL, 0xfffffff817167812ULL, 0x000fe400078ee216ULL,
0x0000000200027210ULL, 0x000fe40007fde0ffULL, 0x0000000d1b177c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff819187812ULL, 0x000fe200078ee218ULL, 0x000000ffff037224ULL, 0x000fe200030e0603ULL,
0x0000000d1c097c11ULL, 0x002fe2000f8e20ffULL, 0x000000000e177faeULL, 0x0003e2000e101c52ULL,
0x0000000d080b7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000d140d7c11ULL, 0x004fe2000f8e20ffULL,
0x0000000010097faeULL, 0x0003e2000e901c52ULL, 0x0000000d16157c11ULL, 0x000fe4000f8e20ffULL,
0x0000000d18197c11ULL, 0x000fe2000f8e20ffULL, 0x00000000120b7faeULL, 0x0003e8000d901c52ULL,
0x00000000040d7faeULL, 0x0003e8000d101c52ULL, 0x0000000006157faeULL, 0x0003e8000c101c52ULL,
0x0000000002197faeULL, 0x0003e2000c901c52ULL, 0x0000000800f47947ULL, 0x000fea0003800000ULL,
0x00000000007d7919ULL, 0x000e620000000000ULL, 0x0000000a080d72a4ULL, 0x000fe2000f8e020dULL,
0x00000000000b79c3ULL, 0x000ea20000008800ULL, 0x0000040000107882ULL, 0x000fe40000000000ULL,
0x000006540b107896ULL, 0x004fc80008000010ULL, 0x00000010140b7291ULL, 0x000fe2000f8e703fULL,
0x00000003ff027819ULL, 0x002fe4000001167dULL, 0x0ffffff87d007812ULL, 0x000fe200078ec0ffULL,
0x000010000b0b7890ULL, 0x000fe2000fffe03fULL, 0x0000007d020b7212ULL, 0x0c0fe200078e3cffULL,
0x0000000402167836ULL, 0x040fe40000000000ULL, 0x0000000802187836ULL, 0x000fe20000000000ULL,
0x00000007000b7812ULL, 0x000fe200078ef80bULL, 0x0000000816037824ULL, 0x040fe200078e00ffULL,
0x0000007d160a7212ULL, 0x080fe200078e3cffULL, 0x0000000818057824ULL, 0x040fe200078e00ffULL,
0x0000007d180c7212ULL, 0x080fe200078e3cffULL, 0x0000001802207836ULL, 0x040fe20000000000ULL,
0xfffffff8030a7812ULL, 0x000fe200078ee20aULL, 0x0000001c02227836ULL, 0x000fe20000000000ULL,
0xfffffff8050c7812ULL, 0x000fe200078ee20cULL, 0x0000000820037824ULL, 0x040fe200078e00ffULL,
0x0000007d20107212ULL, 0x080fe200078e3cffULL, 0x0000000822057824ULL, 0x040fe200078e00ffULL,
0x0000007d220e7212ULL, 0x080fe200078e3cffULL, 0x0000002402267836ULL, 0x040fe20000000000ULL,
0xfffffff803107812ULL, 0x000fe200078ee210ULL, 0x0000002802287836ULL, 0x000fe20000000000ULL,
0xfffffff8050e7812ULL, 0x000fe200078ee20eULL, 0x0000000826037824ULL, 0x040fe200078e00ffULL,
0x0000007d26127212ULL, 0x080fe200078e3cffULL, 0x0000000828057824ULL, 0x040fe200078e00ffULL,
0x0000007d28087212ULL, 0x080fe200078e3cffULL, 0x00000034022e7836ULL, 0x040fe20000000000ULL,
0xfffffff803127812ULL, 0x000fe200078ee212ULL, 0x00000030022c7836ULL, 0x040fe20000000000ULL,
0xfffffff805087812ULL, 0x000fe200078ee208ULL, 0x0000000c021a7836ULL, 0x000fe20000000000ULL,
0x0000007d2e057212ULL, 0x0c0fe200078e3cffULL, 0x000000082e147824ULL, 0x000fe200078e00ffULL,
0x0000007d2c067212ULL, 0x0c0fe200078e3cffULL, 0x000000082c037824ULL, 0x000fe200078e00ffULL,
0x0000007d1a097212ULL, 0x0c0fe200078e3cffULL, 0x000000081a047824ULL, 0x000fe200078e00ffULL,
0xfffffff814057812ULL, 0x000fe200078ee205ULL, 0x00000010021c7836ULL, 0x040fe20000000000ULL,
0xfffffff803067812ULL, 0x000fe200078ee206ULL, 0x00000014021e7836ULL, 0x040fe20000000000ULL,
0x0000007f02147812ULL, 0x040fe200078ec0ffULL, 0x0000002002247836ULL, 0x040fe20000000000ULL,
0xfffffff804097812ULL, 0x000fe200078ee209ULL, 0x0000002c022a7836ULL, 0x000fe20000000000ULL,
0x0000007d1c0d7212ULL, 0x080fe200078e3cffULL, 0x0000003802307836ULL, 0x000fe20000000000ULL,
0x0000007d1e0f7212ULL, 0x080fe200078e3cffULL, 0x0000003c02327836ULL, 0x000fe20000000000ULL,
0x0000007d24117212ULL, 0x080fe200078e3cffULL, 0x00008a00ff027b82ULL, 0x000e620000000a00ULL,
0x000000081c007824ULL, 0x000fe200078e00ffULL, 0x0000007d2a077212ULL, 0x080fe200078e3cffULL,
0x000000081e047824ULL, 0x000fe200078e00ffULL, 0x0000007f16167812ULL, 0x000fe200078ec0ffULL,
0x0000000830137824ULL, 0x000fe200078e00ffULL, 0xfffffff8000d7812ULL, 0x000fe200078ee20dULL,
0x0000000824007824ULL, 0x000fe200078e00ffULL, 0xfffffff8040f7812ULL, 0x000fe200078ee20fULL,
0x000000082a047824ULL, 0x000fe200078e00ffULL, 0x0000007f18187812ULL, 0x000fe200078ec0ffULL,
0x0000000832157824ULL, 0x000fe200078e00ffULL, 0xfffffff800117812ULL, 0x000fe200078ee211ULL,
0x0000000d16177c36ULL, 0x000fe20008000000ULL, 0xfffffff804077812ULL, 0x000fe200078ee207ULL,
0x0000000d18197c36ULL, 0x000fe20008000000ULL, 0x0000007d30047212ULL, 0x000fc400078e3cffULL,
0x0000007d32007212ULL, 0x000fe400078e3cffULL, 0xfffffff813047812ULL, 0x000fe200078ee204ULL,
0x000000107d137824ULL, 0x000fe200078e00ffULL, 0xfffffff815007812ULL, 0x000fe200078ee200ULL,
0x0000000d14157c36ULL, 0x000fe20008000000ULL, 0x0000007f1a1a7812ULL, 0x000fe200078ec0ffULL,
0x0000010017167825ULL, 0x102fe200078e0002ULL, 0x0000007f1c1c7812ULL, 0x000fe400078ec0ffULL,
0x0000007f1e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000010015147825ULL, 0x000fe200078e0002ULL,
0x0000007f20207812ULL, 0x000fc400078ec0ffULL, 0x0000007f22227812ULL, 0x000fe200078ec0ffULL,
0x0000000d1a1b7c36ULL, 0x000fe20008000000ULL, 0x0000007f24247812ULL, 0x000fe200078ec0ffULL,
0x0000000d1c1d7c36ULL, 0x000fe20008000000ULL, 0x0000007f26267812ULL, 0x000fe200078ec0ffULL,
0x0000000d1e1f7c36ULL, 0x000fe20008000000ULL, 0x0000007f28287812ULL, 0x000fe200078ec0ffULL,
0x0000000d20217c36ULL, 0x000fe20008000000ULL, 0x0000007f2a2a7812ULL, 0x000fe200078ec0ffULL,
0x0000000d22237c36ULL, 0x000fe20008000000ULL, 0x0000007f2c2c7812ULL, 0x000fe200078ec0ffULL,
0x0000000d24257c36ULL, 0x000fe20008000000ULL, 0x0000007f2e2e7812ULL, 0x000fe200078ec0ffULL,
0x0000000d26277c36ULL, 0x000fe20008000000ULL, 0x0000007f30307812ULL, 0x000fe200078ec0ffULL,
0x0000000d28297c36ULL, 0x000fe20008000000ULL, 0x0000007f32327812ULL, 0x000fe200078ec0ffULL,
0x0000000d2a2b7c36ULL, 0x000fe20008000000ULL, 0x0000007013137812ULL, 0x000fe200078ec0ffULL,
0x0000000d2c2d7c36ULL, 0x000fe20008000000ULL, 0x0000000b0b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000d2e2f7c36ULL, 0x000fe20008000000ULL, 0x0000001413147210ULL, 0x000fe20007f1e0ffULL,
0x0000000d30317c36ULL, 0x000fe20008000000ULL, 0x0000000b09097c11ULL, 0x000fe2000f8e20ffULL,
0x0000000d32337c36ULL, 0x000fe20008000000ULL, 0x0000000b0d0d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000010019187825ULL, 0x000fe200078e0002ULL, 0x0000000b0f0f7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000b10357c11ULL, 0x000fe2000f8e20ffULL, 0x000001001b1a7825ULL, 0x100fe200078e0002ULL,
0x0000000b11117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL,
0x000001001d1c7825ULL, 0x000fe200078e0002ULL, 0x0000000b05057c11ULL, 0x000fc6000f8e20ffULL,
0x000001001f1e7825ULL, 0x000fc800078e0002ULL, 0x0000010021207825ULL, 0x000fc800078e0002ULL,
0x0000010023227825ULL, 0x000fc800078e0002ULL, 0x0000010025247825ULL, 0x000fc800078e0002ULL,
0x0000010027267825ULL, 0x000fc800078e0002ULL, 0x0000010029287825ULL, 0x000fc800078e0002ULL,
0x000001002b2a7825ULL, 0x000fc800078e0002ULL, 0x000001002d2c7825ULL, 0x000fc800078e0002ULL,
0x000001002f2e7825ULL, 0x000fc800078e0002ULL, 0x0000010031307825ULL, 0x000fc800078e0002ULL,
0x0000010033327825ULL, 0x000fe200078e0002ULL, 0x0000001613027210ULL, 0x000fe40007f3e0ffULL,
0x0000001813167210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x0000001a13187210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff037224ULL, 0x000fe200008e0617ULL,
0x0000001c131a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140b7faeULL, 0x0003e2000b901c52ULL,
0x000000ffff197224ULL, 0x000fe200000e061bULL, 0x0000001e131c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e061dULL, 0x00000020131e7210ULL, 0x000fc40007f5e0ffULL,
0x0000002213207210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e061fULL,
0x0000002413227210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1f7224ULL, 0x000fe400010e0621ULL,
0x000000ffff217224ULL, 0x000fe200008e0623ULL, 0x0000002613247210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff237224ULL, 0x000fe200000e0625ULL, 0x0000002813267210ULL, 0x000fe40007f1e0ffULL,
0x0000000b0e0b7c11ULL, 0x002fe2000f8e20ffULL, 0x000000ffff257224ULL, 0x000fe200008e0627ULL,
0x0000002a13287210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0629ULL,
0x0000002c132a7210ULL, 0x000fc60007f1e0ffULL, 0x000000ffff297224ULL, 0x000fe200008e062bULL,
0x0000002e132c7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200000e062dULL,
0x00000030132e7210ULL, 0x000fe40007f1e0ffULL, 0x0000003213307210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200008e062fULL, 0x0000000b0a137c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2f7224ULL, 0x000fe400000e0631ULL, 0x000000ffff317224ULL, 0x000fe200010e0633ULL,
0x0000000b0c337c11ULL, 0x000fe2000f8e20ffULL, 0x0000000002137faeULL, 0x0003e8000b901c52ULL,
0x0000000016337faeULL, 0x000fe8000b901c52ULL, 0x0000000018097faeULL, 0x0007e8000b901c52ULL,
0x000000001a0d7faeULL, 0x0009e2000b901c52ULL, 0x0000000b12037c11ULL, 0x002fc6000f8e20ffULL,
0x000000001c0f7faeULL, 0x0003e2000b901c52ULL, 0x0000000b08097c11ULL, 0x008fc6000f8e20ffULL,
0x000000001e357faeULL, 0x000fe2000b901c52ULL, 0x0000000b060d7c11ULL, 0x010fc6000f8e20ffULL,
0x00000000200b7faeULL, 0x0007e2000b901c52ULL, 0x0000000b000f7c11ULL, 0x002fc6000f8e20ffULL,
0x0000000022117faeULL, 0x0005e8000b901c52ULL, 0x0000000024037faeULL, 0x0005e2000b901c52ULL,
0x0000000b040b7c11ULL, 0x008fc6000f8e20ffULL, 0x0000000026097faeULL, 0x0005e8000b901c52ULL,
0x0000000028077faeULL, 0x0005e8000b901c52ULL, 0x000000002a0d7faeULL, 0x0005e8000b901c52ULL,
0x000000002c057faeULL, 0x0005e8000b901c52ULL, 0x000000002e0b7faeULL, 0x0005e8000b901c52ULL,
0x00000000300f7faeULL, 0x0005e4000b901c52ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x023600ffff0075a7ULL, 0x000ee20008000150ULL, 0x000000054a007c0cULL, 0x000fe2000bf26070ULL,
0x0000004800588947ULL, 0x008fd80003800000ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x00007610ff7c7816ULL, 0x000fe2000000007cULL, 0x00009000000b7ab9ULL, 0x000fe20000000800ULL,
0x00000010141b7291ULL, 0x000fe4000f8e203fULL, 0xffffffff05187890ULL, 0x000fe4000fffe03fULL,
0x0000000b040b72a4ULL, 0x000fd8000f8e023fULL, 0x000000004a0e72caULL, 0x000fda00000e0000ULL,
0x000000160e0e7291ULL, 0x000fc8000f8e403fULL, 0x0000000e1700728cULL, 0x000fcc000bf04070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x000000014a007836ULL, 0x000fe20000000000ULL, 0x000000400e047892ULL, 0x000fc8000f8ec03fULL,
0x0000000500007c0cULL, 0x000fe2000bf06070ULL, 0x0000000409047290ULL, 0x000fd8000fffe03fULL,
0x0000000800f48947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe2000001167dULL,
0x000000080a0872a4ULL, 0x000fe2000f8e0204ULL, 0x000000077d447812ULL, 0x000fe200078ec0ffULL,
0x8000000e170d7290ULL, 0x000fe2000fffe03fULL, 0x0000007f00537812ULL, 0x040fe200078ec0ffULL,
0x0000000c00047836ULL, 0x042fe20000000000ULL, 0x0000007d00147212ULL, 0x0c0fe200078e3cffULL,
0x0000000400027836ULL, 0x000fe20000000000ULL, 0x00008a00001c7ab9ULL, 0x000fe20000000a00ULL,
0x0000000804077824ULL, 0x044fe200078e00ffULL, 0x0000007d04527212ULL, 0x080fe200078e3cffULL,
0x0000000800037836ULL, 0x000fe20000000000ULL, 0x0000007d02687212ULL, 0x0c0fe200078e3cffULL,
0x0000000802057824ULL, 0x000fe200078e00ffULL, 0xfffffff807527812ULL, 0x000fe200078ee252ULL,
0x0000001800077836ULL, 0x040fe20000000000ULL, 0x0000007d03677212ULL, 0x0c0fe200078e3cffULL,
0x0000000803067824ULL, 0x000fe200078e00ffULL, 0xfffffff805687812ULL, 0x000fe200078ee268ULL,
0x00000008070a7824ULL, 0x040fe200078e00ffULL, 0x0000007d074f7212ULL, 0x080fe200078e3cffULL,
0x0000001000057836ULL, 0x040fe20000000000ULL, 0xfffffff806677812ULL, 0x000fe200078ee267ULL,
0x00000038000f7836ULL, 0x040fe20000000000ULL, 0x0000001400067810ULL, 0x000fe20007ffe0ffULL,
0x0000000805087824ULL, 0x040fe200078e00ffULL, 0xfffffff80a4f7812ULL, 0x000fe200078ee24fULL,
0x00000024000a7836ULL, 0x000fe20000000000ULL, 0x0000007d05517212ULL, 0x080fe200078e3cffULL,
0x0000000806097824ULL, 0x040fe200078e00ffULL, 0x0000007d06507212ULL, 0x080fe200078e3cffULL,
0x000000080a0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff808517812ULL, 0x000fe200078ee251ULL,
0x0000001c00087836ULL, 0x000fe20000000000ULL, 0x0000007d0a4c7212ULL, 0x080fe200078e3cffULL,
0x00000010140c7291ULL, 0x000fe2000f8e703fULL, 0xfffffff809507812ULL, 0x000fe200078ee250ULL,
0x0000002000097836ULL, 0x000fe20000000000ULL, 0xfffffff80d4c7812ULL, 0x000fe200078ee24cULL,
0x00000008080b7824ULL, 0x040fe200078e00ffULL, 0x0000007d084e7212ULL, 0x080fe200078e3cffULL,
0x00000030000d7836ULL, 0x040fe20000000000ULL, 0x0000007d094d7212ULL, 0x0c0fe200078e3cffULL,
0x00000008090c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b4e7812ULL, 0x000fe200078ee24eULL,
0x000000080d117824ULL, 0x040fe200078e00ffULL, 0x0000007d0d487212ULL, 0x080fe200078e3cffULL,
0x00000028000b7836ULL, 0x000fe20000000000ULL, 0x0000007f025b7812ULL, 0x000fe200078ec0ffULL,
0x0000001cff127e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff80c4d7812ULL, 0x000fe200078ee24dULL,
0x000000080b0e7824ULL, 0x000fe200078e00ffULL, 0x0000007f035a7812ULL, 0x000fe200078ec0ffULL,
0x0000002c000c7836ULL, 0x000fe20000000000ULL, 0xfffffff811487812ULL, 0x000fe200078ee248ULL,
0x000000080f117824ULL, 0x000fe200078e00ffULL, 0x0000007f04597812ULL, 0x000fe200078ec0ffULL,
0x0000001dff137e24ULL, 0x000fe2000f8e00ffULL, 0x0000007d0b4b7212ULL, 0x080fe200078e3cffULL,
0x0000000853157c36ULL, 0x000fe20008000000ULL, 0x0000007d0f467212ULL, 0x080fe200078e3cffULL,
0x000000085b177c36ULL, 0x000fe20008000000ULL, 0x0000000714167812ULL, 0x000fe200078ec0ffULL,
0x000000080c107824ULL, 0x000fe200078e00ffULL, 0x0000000d00007c0cULL, 0x000fe2000bf06070ULL,
0x000000085a197c36ULL, 0x000fe20008000000ULL, 0xfffffff80e4b7812ULL, 0x000fe200078ee24bULL,
0x00000008591b7c36ULL, 0x000fe20008000000ULL, 0x0000007d0c497212ULL, 0x000fe200078e3cffULL,
0x00000034000e7836ULL, 0x000fe20000000000ULL, 0x0000000d02007c0cULL, 0x000fe2000bf26070ULL,
0x000030000c197890ULL, 0x000fe2000fffe03fULL, 0xfffffff811467812ULL, 0x000fe200078ee246ULL,
0x0000010015147825ULL, 0x000fe200078e0012ULL, 0x0000000d03007c0cULL, 0x000fc4000bf46070ULL,
0x0ffffff816697812ULL, 0x000fe200078ef87dULL, 0x0000010017167825ULL, 0x100fe200078e0012ULL,
0x0000000844117812ULL, 0x000fe400078efcffULL, 0x0000000d04007c0cULL, 0x000fe2000bf66070ULL,
0x0000010019187825ULL, 0x100fe200078e0012ULL, 0xfffffff810497812ULL, 0x000fe400078ee249ULL,
0x0000007d0e477212ULL, 0x000fe200078e3cffULL, 0x000001001b1a7825ULL, 0x000fe200078e0012ULL,
0x00000019691d7c11ULL, 0x000fc4000f8e20ffULL, 0x00000019681f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000080e107824ULL, 0x000fe200078e00ffULL, 0x0000007f05587812ULL, 0x000fe200078ec0ffULL,
0x0000001011147825ULL, 0x000fe200078e0014ULL, 0x0000001967217c11ULL, 0x000fe4000f8e20ffULL,
0x0000007f06577812ULL, 0x000fe200078ec0ffULL, 0x0000001011167825ULL, 0x040fe200078e0016ULL,
0xfffffff810477812ULL, 0x000fe200078ee247ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x0003e2000c101c52ULL, 0x0000001952237c11ULL, 0x000fe2000f8e20ffULL,
0x0000001011187825ULL, 0x000fe200078e0018ULL, 0x0000007f07567812ULL, 0x000fe200078ec0ffULL,
0x00000000161f7faeULL, 0x0005e2000c901c52ULL, 0x0000007f08557812ULL, 0x000fe200078ec0ffULL,
0x00000010111a7825ULL, 0x000fe200078e001aULL, 0x0000007f09547812ULL, 0x000fe200078ec0ffULL,
0x0000000018217faeULL, 0x0007e2000d101c52ULL, 0x0000000d05007c0cULL, 0x000fe2000bf06070ULL,
0x0000003c00107836ULL, 0x000fe20000000000ULL, 0x0000000d06007c0cULL, 0x000fe2000bf26070ULL,
0x0000000858157c36ULL, 0x002fe20008000000ULL, 0x000000001a237faeULL, 0x0003e2000d901c52ULL,
0x00000008101c7824ULL, 0x040fe200078e00ffULL, 0x0000007d10457212ULL, 0x000fe200078e3cffULL,
0x0000000857177c36ULL, 0x004fe20008000000ULL, 0x0000000d07007c0cULL, 0x000fe2000bf46070ULL,
0x00000008541d7c36ULL, 0x000fe20008000000ULL, 0x0000000d08007c0cULL, 0x000fe2000bf66070ULL,
0x0000000856197c36ULL, 0x008fe20008000000ULL, 0x0000000d09007c0cULL, 0x000fe2000bf86070ULL,
0x0000010015147825ULL, 0x000fe200078e0012ULL, 0xfffffff81c457812ULL, 0x000fc400078ee245ULL,
0x00000019511f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000008551b7c36ULL, 0x002fe20008000000ULL,
0x0000001950217c11ULL, 0x000fe2000f8e20ffULL, 0x0000010017167825ULL, 0x100fe200078e0012ULL,
0x000000194f237c11ULL, 0x000fe4000f8e20ffULL, 0x000000194e257c11ULL, 0x000fe2000f8e20ffULL,
0x0000010019187825ULL, 0x100fe200078e0012ULL, 0x000000194d277c11ULL, 0x000fe4000f8e20ffULL,
0x0000007f0a627812ULL, 0x000fe200078ec0ffULL, 0x000001001b1a7825ULL, 0x000fe200078e0012ULL,
0x0000007f0b617812ULL, 0x000fc400078ec0ffULL, 0x0000007f0c607812ULL, 0x000fe200078ec0ffULL,
0x000001001d1c7825ULL, 0x000fe200078e0012ULL, 0x0000007f0d5f7812ULL, 0x000fe400078ec0ffULL,
0x0000007f0e5e7812ULL, 0x000fe200078ec0ffULL, 0x0000001011147825ULL, 0x000fe200078e0014ULL,
0x0000007f0f5d7812ULL, 0x000fe400078ec0ffULL, 0x0000007f105c7812ULL, 0x000fe200078ec0ffULL,
0x0000001011167825ULL, 0x000fe200078e0016ULL, 0x00000000141f7faeULL, 0x0003e2000c101c52ULL,
0x0000000d0a007c0cULL, 0x000fc4000bf06070ULL, 0x0000001011187825ULL, 0x000fe200078e0018ULL,
0x0000000016217faeULL, 0x0005e2000c901c52ULL, 0x0000000d0b007c0cULL, 0x000fe4000bf26070ULL,
0x00000010111a7825ULL, 0x040fe200078e001aULL, 0x0000000018237faeULL, 0x0007e2000d101c52ULL,
0x0000000d0c007c0cULL, 0x000fe4000bf46070ULL, 0x00000010111c7825ULL, 0x000fe200078e001cULL,
0x000000001a257faeULL, 0x0009e2000d901c52ULL, 0x0000000d0d007c0cULL, 0x000fc4000bf66070ULL,
0x0000000862157c36ULL, 0x002fe20008000000ULL, 0x000000001c277faeULL, 0x0003e2000e101c52ULL,
0x00000008601f7c36ULL, 0x000fe20008000000ULL, 0x0000000d0e007c0cULL, 0x000fe2000bf86070ULL,
0x000000085f217c36ULL, 0x004fe20008000000ULL, 0x0000000d0f007c0cULL, 0x000fe2000bfa6070ULL,
0x0000000861197c36ULL, 0x008fe20008000000ULL, 0x0000000d10007c0cULL, 0x000fe2000bfc6070ULL,
0x000000085c177c36ULL, 0x000fe20008000000ULL, 0x000000194c237c11ULL, 0x000fe2000f8e20ffULL,
0x000000085d1b7c36ULL, 0x010fe20008000000ULL, 0x000000194b257c11ULL, 0x000fe2000f8e20ffULL,
0x0000010015147825ULL, 0x000fe200078e0012ULL, 0x0000001948277c11ULL, 0x002fc4000f8e20ffULL,
0x0000001947297c11ULL, 0x000fe2000f8e20ffULL, 0x000000085e1d7c36ULL, 0x000fe20008000000ULL,
0x00000019462b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000010019187825ULL, 0x000fe200078e0012ULL,
0x00000019452d7c11ULL, 0x000fc6000f8e20ffULL, 0x000001001f1e7825ULL, 0x000fc800078e0012ULL,
0x0000010021207825ULL, 0x000fc800078e0012ULL, 0x000001001d1c7825ULL, 0x000fc800078e0012ULL,
0x000001001b1a7825ULL, 0x000fc800078e0012ULL, 0x0000010017167825ULL, 0x000fc800078e0012ULL,
0x0000001011147825ULL, 0x000fc800078e0014ULL, 0x0000001011187825ULL, 0x040fe200078e0018ULL,
0x0000000014237faeULL, 0x0003e6000c101c52ULL, 0x00000010111e7825ULL, 0x040fe200078e001eULL,
0x0000000018257faeULL, 0x0003e6000c901c52ULL, 0x0000001011207825ULL, 0x000fc800078e0020ULL,
0x00000010111c7825ULL, 0x000fc800078e001cULL, 0x00000010111a7825ULL, 0x000fc800078e001aULL,
0x0000001011167825ULL, 0x000fe200078e0016ULL, 0x0000001949117c11ULL, 0x000fca000f8e20ffULL,
0x000000001e117faeULL, 0x0003e8000d101c52ULL, 0x0000000020277faeULL, 0x0003e8000d901c52ULL,
0x000000001c297faeULL, 0x0003e8000e101c52ULL, 0x000000001a2b7faeULL, 0x0003e8000e901c52ULL,
0x00000000162d7faeULL, 0x0003e2000f101c52ULL, 0x0000000800a47947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe2000001167dULL, 0x00008a00ff127b82ULL, 0x002e620000000a00ULL,
0x000000080a0472a4ULL, 0x000fe2000f8e0204ULL, 0x000000077d447812ULL, 0x000fe200078ec0ffULL,
0x00000010140c7291ULL, 0x000fe2000f8e703fULL, 0x0000000400027836ULL, 0x040fe20000000000ULL,
0x0000007f00537812ULL, 0x040fe200078ec0ffULL, 0x0000000800037836ULL, 0x044fe20000000000ULL,
0x0000007d00147212ULL, 0x080fe200078e3cffULL, 0x0000000802057824ULL, 0x040fe200078e00ffULL,
0x0000007d02687212ULL, 0x080fe200078e3cffULL, 0x0000000803067824ULL, 0x040fe200078e00ffULL,
0x0000007d03677212ULL, 0x080fe200078e3cffULL, 0x0000000c00047836ULL, 0x040fe20000000000ULL,
0xfffffff805687812ULL, 0x000fe200078ee268ULL, 0x0000001000057836ULL, 0x040fe20000000000ULL,
0xfffffff806677812ULL, 0x000fe200078ee267ULL, 0x0000001400067836ULL, 0x000fe20000000000ULL,
0x0000007d04527212ULL, 0x0c0fe200078e3cffULL, 0x0000000804077824ULL, 0x000fe200078e00ffULL,
0x0000007d05517212ULL, 0x0c0fe200078e3cffULL, 0x0000000805087824ULL, 0x000fe200078e00ffULL,
0x0000007d06507212ULL, 0x0c0fe200078e3cffULL, 0x0000000806097824ULL, 0x000fe200078e00ffULL,
0xfffffff807527812ULL, 0x000fe200078ee252ULL, 0x0000001800077836ULL, 0x040fe20000000000ULL,
0xfffffff808517812ULL, 0x000fe200078ee251ULL, 0x0000001c00087836ULL, 0x040fe20000000000ULL,
0xfffffff809507812ULL, 0x000fe200078ee250ULL, 0x0000002000097836ULL, 0x000fe20000000000ULL,
0x0000007d074f7212ULL, 0x0c0fe200078e3cffULL, 0x00000008070a7824ULL, 0x000fe200078e00ffULL,
0x0000007d084e7212ULL, 0x0c0fe200078e3cffULL, 0x00000008080b7824ULL, 0x000fe200078e00ffULL,
0x0000007d094d7212ULL, 0x0c0fe200078e3cffULL, 0x00000008090c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a4f7812ULL, 0x000fe200078ee24fULL, 0x00000024000a7836ULL, 0x040fe20000000000ULL,
0xfffffff80b4e7812ULL, 0x000fe200078ee24eULL, 0x00000028000b7836ULL, 0x040fe20000000000ULL,
0xfffffff80c4d7812ULL, 0x000fe200078ee24dULL, 0x0000002c000c7836ULL, 0x000fe20000000000ULL,
0x0000007d0a4c7212ULL, 0x0c0fe200078e3cffULL, 0x000000080a0d7824ULL, 0x000fe200078e00ffULL,
0x0000007d0b4b7212ULL, 0x0c0fe200078e3cffULL, 0x000000080b0e7824ULL, 0x000fe200078e00ffULL,
0x0000007d0c497212ULL, 0x040fe200078e3cffULL, 0x000000080c107824ULL, 0x000fe200078e00ffULL,
0x0000000714167812ULL, 0x000fe200078ec0ffULL, 0x0000000453157c36ULL, 0x000fe20008000000ULL,
0x000030000c197890ULL, 0x000fe2000fffe03fULL, 0xfffffff80d4c7812ULL, 0x000fe200078ee24cULL,
0x00000030000d7836ULL, 0x000fe20000000000ULL, 0xfffffff80e4b7812ULL, 0x000fe200078ee24bULL,
0x0000010015147825ULL, 0x002fe200078e0012ULL, 0xfffffff810497812ULL, 0x000fc400078ee249ULL,
0x0000000844117812ULL, 0x000fe200078efcffULL, 0x00000034000e7836ULL, 0x040fe20000000000ULL,
0x0ffffff816697812ULL, 0x000fe200078ef87dULL, 0x00000038000f7836ULL, 0x040fe20000000000ULL,
0x0000007d0d487212ULL, 0x080fe200078e3cffULL, 0x0000003c00107836ULL, 0x000fe20000000000ULL,
0x0000001969177c11ULL, 0x000fe2000f8e20ffULL, 0x000000080d197824ULL, 0x000fe200078e00ffULL,
0x0000007d0f467212ULL, 0x040fe200078e3cffULL, 0x000000080f1b7824ULL, 0x000fe200078e00ffULL,
0x0000007f025b7812ULL, 0x000fe200078ec0ffULL, 0x0000001011147825ULL, 0x000fe200078e0014ULL,
0x0000007f035a7812ULL, 0x000fc400078ec0ffULL, 0x0000007f04597812ULL, 0x000fe200078ec0ffULL,
0x000000080e187824ULL, 0x000fe200078e00ffULL, 0x0000007f05587812ULL, 0x000fe200078ec0ffULL,
0x0000000810167824ULL, 0x000fe200078e00ffULL, 0x0000007f06577812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000b901c52ULL,
0x0000007f07567812ULL, 0x000fe400078ec0ffULL, 0x0000007f08557812ULL, 0x000fe200078ec0ffULL,
0x00000004571d7c36ULL, 0x000fe20008000000ULL, 0x0000007f09547812ULL, 0x000fe200078ec0ffULL,
0x00000004561f7c36ULL, 0x000fe20008000000ULL, 0x0000007f0a627812ULL, 0x000fe200078ec0ffULL,
0x0000000455217c36ULL, 0x000fe20008000000ULL, 0x0000007f0b617812ULL, 0x000fe200078ec0ffULL,
0x0000000454237c36ULL, 0x000fe20008000000ULL, 0x0000007f0c607812ULL, 0x000fe200078ec0ffULL,
0x000000045b157c36ULL, 0x002fe20008000000ULL, 0x0000007f0d5f7812ULL, 0x000fe200078ec0ffULL,
0x000000045a177c36ULL, 0x000fe20008000000ULL, 0x0000007f0e5e7812ULL, 0x000fe200078ec0ffULL,
0x0000000462257c36ULL, 0x000fe20008000000ULL, 0x0000007f0f5d7812ULL, 0x000fe200078ec0ffULL,
0x0000000461277c36ULL, 0x000fe20008000000ULL, 0x0000007f105c7812ULL, 0x000fe200078ec0ffULL,
0x0000000460297c36ULL, 0x000fe20008000000ULL, 0x0000007d0e477212ULL, 0x080fe200078e3cffULL,
0x000000045f2b7c36ULL, 0x000fe20008000000ULL, 0x0000007d10457212ULL, 0x000fe200078e3cffULL,
0x000000045e2d7c36ULL, 0x000fe20008000000ULL, 0xfffffff819487812ULL, 0x000fe200078ee248ULL,
0x0000000459197c36ULL, 0x000fe20008000000ULL, 0xfffffff81b467812ULL, 0x000fe200078ee246ULL,
0x00000004581b7c36ULL, 0x000fe20008000000ULL, 0xfffffff818477812ULL, 0x000fe200078ee247ULL,
0x000000045d2f7c36ULL, 0x000fe20008000000ULL, 0xfffffff816457812ULL, 0x000fe200078ee245ULL,
0x000000045c317c36ULL, 0x000fe20008000000ULL, 0x0000001967337c11ULL, 0x000fe2000f8e20ffULL,
0x0000010015147825ULL, 0x000fe200078e0012ULL, 0x0000001952357c11ULL, 0x000fc4000f8e20ffULL,
0x0000001951377c11ULL, 0x000fe2000f8e20ffULL, 0x0000010017167825ULL, 0x100fe200078e0012ULL,
0x0000001950397c11ULL, 0x000fe4000f8e20ffULL, 0x000000194f3b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000010019187825ULL, 0x100fe200078e0012ULL, 0x000000194e3d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000194d3f7c11ULL, 0x000fe2000f8e20ffULL, 0x000001001b1a7825ULL, 0x000fe200078e0012ULL,
0x000000194c417c11ULL, 0x000fc4000f8e20ffULL, 0x000000194b437c11ULL, 0x000fe2000f8e20ffULL,
0x000001001d1c7825ULL, 0x000fc800078e0012ULL, 0x000001001f1e7825ULL, 0x000fc800078e0012ULL,
0x0000010021207825ULL, 0x000fc800078e0012ULL, 0x0000010023227825ULL, 0x000fc800078e0012ULL,
0x0000010025247825ULL, 0x000fc800078e0012ULL, 0x0000010027267825ULL, 0x000fc800078e0012ULL,
0x0000010029287825ULL, 0x000fc800078e0012ULL, 0x000001002b2a7825ULL, 0x000fc800078e0012ULL,
0x000001002d2c7825ULL, 0x000fc800078e0012ULL, 0x000001002f2e7825ULL, 0x000fc800078e0012ULL,
0x0000010031307825ULL, 0x000fc800078e0012ULL, 0x0000001011147825ULL, 0x000fc800078e0014ULL,
0x0000001011167825ULL, 0x000fc800078e0016ULL, 0x0000001011187825ULL, 0x000fc800078e0018ULL,
0x00000010111a7825ULL, 0x000fc800078e001aULL, 0x00000010111c7825ULL, 0x000fc800078e001cULL,
0x00000010111e7825ULL, 0x000fc800078e001eULL, 0x0000001011207825ULL, 0x000fc800078e0020ULL,
0x0000001011227825ULL, 0x000fc800078e0022ULL, 0x0000001011247825ULL, 0x000fc800078e0024ULL,
0x0000001011267825ULL, 0x000fc800078e0026ULL, 0x0000001011287825ULL, 0x000fc800078e0028ULL,
0x00000010112a7825ULL, 0x000fc800078e002aULL, 0x00000010112c7825ULL, 0x000fc800078e002cULL,
0x00000010112e7825ULL, 0x000fc800078e002eULL, 0x0000001011307825ULL, 0x000fe200078e0030ULL,
0x0000001968117c11ULL, 0x000fca000f8e20ffULL, 0x0000000014117faeULL, 0x0003e8000b901c52ULL,
0x0000000016337faeULL, 0x0005e8000b901c52ULL, 0x0000000018357faeULL, 0x0007e8000b901c52ULL,
0x000000001a377faeULL, 0x0009e2000b901c52ULL, 0x0000001949117c11ULL, 0x002fc4000f8e20ffULL,
0x0000001948157c11ULL, 0x000fe2000f8e20ffULL, 0x000000001c397faeULL, 0x0003e2000b901c52ULL,
0x0000001947177c11ULL, 0x004fc6000f8e20ffULL, 0x000000001e3b7faeULL, 0x0003e2000b901c52ULL,
0x0000001946197c11ULL, 0x008fc6000f8e20ffULL, 0x00000000203d7faeULL, 0x0003e2000b901c52ULL,
0x00000019451b7c11ULL, 0x010fc6000f8e20ffULL, 0x00000000223f7faeULL, 0x0003e8000b901c52ULL,
0x0000000024417faeULL, 0x0003e8000b901c52ULL, 0x0000000026437faeULL, 0x0003e8000b901c52ULL,
0x0000000028117faeULL, 0x0003e8000b901c52ULL, 0x000000002a157faeULL, 0x0003e8000b901c52ULL,
0x000000002c177faeULL, 0x0003e8000b901c52ULL, 0x000000002e197faeULL, 0x0003e8000b901c52ULL,
0x00000000301b7faeULL, 0x0003e4000b901c52ULL, 0x00000004ff6a7819ULL, 0x000fe2000001167dULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000844117812ULL, 0x002fe200078ef87dULL,
0x000010000c117890ULL, 0x000fe2000fffe03fULL, 0x000000036a157819ULL, 0x040fe200000006ffULL,
0x000000026a167836ULL, 0x000fe20000000000ULL, 0x000000076a147812ULL, 0x000fe200078e7811ULL,
0x0000000615067291ULL, 0x000fe2000f8e083fULL, 0xfffffff815157812ULL, 0x000fe400078ee244ULL,
0x0000000100727812ULL, 0x000fe200078ec0ffULL, 0x0000001011147824ULL, 0x000fe200078e0214ULL,
0x00000007156c7812ULL, 0x040fe200078ec0ffULL, 0x0000000815667824ULL, 0x040fe200078e00ffULL,
0x0000000716167812ULL, 0x000fe200078e7811ULL, 0x0000001015657836ULL, 0x040fe20000000000ULL,
0x000000016c7b7812ULL, 0x000fe200078e7800ULL, 0x00000020156d7836ULL, 0x040fe20000000000ULL,
0x0000001014147c11ULL, 0x000fe2000f8e20ffULL, 0x0000003015157836ULL, 0x000fe20000000000ULL,
0x000000667b7b7212ULL, 0x000fe200078efcffULL, 0x0000001011167824ULL, 0x000fe200078e0216ULL,
0x0000000765637812ULL, 0x000fe200078ec0ffULL, 0x00000008156e7824ULL, 0x000fe200078e00ffULL,
0x000000117b247c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001438783bULL, 0x0003e20000000200ULL, 0x0000000715647812ULL, 0x000fe200078ec0ffULL,
0x0000000865657824ULL, 0x000fe200078e00ffULL, 0x000000076d6b7812ULL, 0x040fe200078ec0ffULL,
0x000000002424783bULL, 0x000ea20000000200ULL, 0x00000001641d7812ULL, 0x000fe200078e7800ULL,
0x000000086d6d7824ULL, 0x000fe200078e00ffULL, 0x000000026c777812ULL, 0x000fe200078e1e72ULL,
0x000000070600728cULL, 0x000fe2000bf06070ULL, 0x00000001637a7812ULL, 0x000fe400078e7800ULL,
0x000000016b147812ULL, 0x002fc400078e7800ULL, 0x0000006e1d787212ULL, 0x000fe400078efcffULL,
0x0000006677777212ULL, 0x000fe400078efcffULL, 0x000000657a7a7212ULL, 0x000fe400078efcffULL,
0x0000006d14797212ULL, 0x000fe200078efcffULL, 0x000000060b048291ULL, 0x000fe2000f8e083fULL,
0x0000001178307c11ULL, 0x000fe2000f8e20ffULL, 0x00008c00000c8ab9ULL, 0x000fe20000000a00ULL,
0x0000001016167c11ULL, 0x000fe2000f8e20ffULL, 0x00000004040c88a5ULL, 0x000fe2000f8e000cULL,
0x0000001177187c11ULL, 0x000fc4000f8e20ffULL, 0x000000117a347c11ULL, 0x000fe2000f8e20ffULL,
0x000000003030783bULL, 0x000e620000000200ULL, 0x0000001179287c11ULL, 0x000fe4000f8e20ffULL,
0x000000026b2c7812ULL, 0x000fe200078e1e72ULL, 0x000000001614783bULL, 0x000fe20000000200ULL,
0x000000000000781cULL, 0x000fe40003f0f008ULL, 0x0000006d2c757212ULL, 0x000fe200078efcffULL,
0x000000001818783bULL, 0x000ee20000000200ULL, 0x0000000263767812ULL, 0x000fc400078e1e72ULL,
0x0000000264737812ULL, 0x000fe200078e1e72ULL, 0x000000003434783bULL, 0x000f220000000200ULL,
0x0000006576767212ULL, 0x000fe400078efcffULL, 0x0000006e73737212ULL, 0x000fe200078efcffULL,
0x000000002828783bULL, 0x000f620000000200ULL, 0x00000024381c723cULL, 0x004fe200000018ffULL,
0x0000001176207c11ULL, 0x000fe4000f8e20ffULL, 0x00000011733c7c11ULL, 0x000fc6000f8e20ffULL,
0x000000263824723cULL, 0x000fe200000018ffULL, 0x000000002020783bULL, 0x000ea80000000200ULL,
0x000000003c3c783bULL, 0x000fe20000000200ULL, 0x00000030382c723cULL, 0x002fee00000018ffULL,
0x0000001175307c11ULL, 0x000fca000f8e20ffULL, 0x00000018141c723cULL, 0x008fec000000181cULL,
0x0000001a1418723cULL, 0x000fec0000001824ULL, 0x000000343840723cULL, 0x010fec00000018ffULL,
0x000000283824723cULL, 0x020fec00000018ffULL, 0x000000363834723cULL, 0x000fec00000018ffULL,
0x0000002a3828723cULL, 0x000fec00000018ffULL, 0x000000323838723cULL, 0x000fe200000018ffULL,
0x000000003030783bULL, 0x000e620000000200ULL, 0x000000046c717812ULL, 0x000fc800078e1e72ULL,
0x000000201440723cULL, 0x004fec0000001840ULL, 0x000000301424723cULL, 0x002fec0000001824ULL,
0x000000321428723cULL, 0x000fe20000001828ULL, 0x0000000cff307e24ULL, 0x000fc4000f8e00ffULL,
0x0000000dff317e24ULL, 0x000fe2000f8e00ffULL, 0x0000006671717212ULL, 0x000fe400078efcffULL,
0x000000221420723cULL, 0x000fe40000001834ULL, 0x0000001230748981ULL, 0x0002a2000c1e1900ULL,
0x000000046a327836ULL, 0x000fe20000000000ULL, 0x0000000463707812ULL, 0x000fe200078e1e72ULL,
0xffffffff00087882ULL, 0x000fe20000000000ULL, 0x0000003c142c723cULL, 0x000fe2000000182cULL,
0x000000004a0d72caULL, 0x000fc400000e0000ULL, 0x0000000732327812ULL, 0x000fe400078e7811ULL,
0x0000006570707212ULL, 0x000fe200078efcffULL, 0x0000003e1414723cULL, 0x000fe20000001838ULL,
0x00000011713c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001011327824ULL, 0x000fe200078e0232ULL,
0x00000011703d7c11ULL, 0x000fc8000f8e20ffULL, 0x0000001032347c11ULL, 0x000fe2000f8e20ffULL,
0x0000000d150d7290ULL, 0x000fe2000fffe03fULL, 0x000000003c30783bULL, 0x0023e60000000200ULL,
0x000000010d047890ULL, 0x000fe2000fffe03fULL, 0x000000003434783bULL, 0x000ee20000000200ULL,
0x000000160d0c7291ULL, 0x000fe4000f8e403fULL, 0x000000050400728cULL, 0x000fe2000bf26070ULL,
0x00000004ff3c7819ULL, 0x002fe2000001167dULL, 0x000000400c047892ULL, 0x000fc8000f8ec03fULL,
0x00000004090f7290ULL, 0x000fe2000fffe03fULL, 0x00000030341c723cULL, 0x008fec000000181cULL,
0x000000323418723cULL, 0x000fe20000001818ULL, 0x000000046b307812ULL, 0x000fc800078e1e72ULL,
0x0000006d306f7212ULL, 0x000fe400078efcffULL, 0x000000003d30783bULL, 0x000e640000000200ULL,
0x000000116f387c11ULL, 0x000fcc000f8e20ffULL, 0x000000003838783bULL, 0x000ee20000000200ULL,
0x000000303440723cULL, 0x002fec0000001840ULL, 0x000000323420723cULL, 0x000fe20000001820ULL,
0x0000000464317812ULL, 0x000fc800078e1e72ULL, 0x0000006e316a7212ULL, 0x000fe200078efcffULL,
0x000000383424723cULL, 0x008fec0000001824ULL, 0x0000003a3428723cULL, 0x000fe20000001828ULL,
0x000000116a397c11ULL, 0x000fca000f8e20ffULL, 0x000000003930783bULL, 0x0002e20000000200ULL,
0x00000006633a7812ULL, 0x000fc800078e1e72ULL, 0x000000653a657212ULL, 0x000fe400078efcffULL,
0x000000066b3a7812ULL, 0x000fe400078e1e72ULL, 0x0000000664397812ULL, 0x002fe400078e1e72ULL,
0x0000006d3a637212ULL, 0x000fe400078efcffULL, 0x0000006e39647212ULL, 0x000fe200078efcffULL,
0x00000030342c723cULL, 0x008fec000000182cULL, 0x000000323430723cULL, 0x000fee0000001814ULL,
0x000000063c147836ULL, 0x000fe20000000000ULL, 0x000000066c157812ULL, 0x000fc400078e1e72ULL,
0x00000011643c7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000714147812ULL, 0x000fe400078e7811ULL,
0x0000006615667212ULL, 0x000fe400078efcffULL, 0x000000003c3c783bULL, 0x000fe20000000200ULL,
0x0000001011147824ULL, 0x000fe200078e0214ULL, 0x0000001166387c11ULL, 0x000fc8000f8e20ffULL,
0x0000001014347c11ULL, 0x000fe4000f8e20ffULL, 0x000000003814783bULL, 0x0003e80000000200ULL,
0x000000003434783bULL, 0x000ee20000000200ULL, 0x0000001163387c11ULL, 0x002fcc000f8e20ffULL,
0x000000003838783bULL, 0x000e620000000200ULL, 0x00000014341c723cULL, 0x008fec000000181cULL,
0x000000163418723cULL, 0x000fe20000001818ULL, 0x0000001165147c11ULL, 0x000fca000f8e20ffULL,
0x000000383424723cULL, 0x002fe20000001824ULL, 0x000000001414783bULL, 0x000e6a0000000200ULL,
0x0000003a3428723cULL, 0x000fec0000001828ULL, 0x0000003c342c723cULL, 0x000fec000000182cULL,
0x0000003e3430723cULL, 0x000fe20000001830ULL, 0x00000000741a82caULL, 0x004fc400000e0000ULL,
0x000000000000781cULL, 0x000fc60003f0f018ULL, 0x000000143440723cULL, 0x002fec0000001840ULL,
0x000000163420723cULL, 0x000fe40000001820ULL, 0x0000001a00088c82ULL, 0x000fe40008000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0000000400e88947ULL, 0x000fde0003800000ULL,
0x0000000c1700728cULL, 0x000fe2000bf01070ULL, 0x0000001169697c11ULL, 0x000fe4000f8e20ffULL,
0x0000001167677c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c17047287ULL, 0x000fe2000c000000ULL,
0x0000001151517c11ULL, 0x000fe4000f8e20ffULL, 0x000000114f4f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000040c047290ULL, 0x000fe2000fffe13fULL, 0x000000114d4d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a080c72a4ULL, 0x000fe2000f8e020fULL, 0x000000114b4b7c11ULL, 0x000fc4000f8e20ffULL,
0x0000001149497c11ULL, 0x000fe4000f8e20ffULL, 0x0000000402007c0cULL, 0x000fe2000bfc6070ULL,
0x000000107d027824ULL, 0x000fe200078e00ffULL, 0x0000000403007c0cULL, 0x000fe2000bf46070ULL,
0x0000000c53037c36ULL, 0x000fe20008000000ULL, 0x0000000405007c0cULL, 0x000fe2000bfa6070ULL,
0x0000000c5f357c36ULL, 0x000fe20008000000ULL, 0x0000007002537812ULL, 0x000fe200078ec0ffULL,
0x0000000c5d057c36ULL, 0x000fe20008000000ULL, 0x0000000400007c0cULL, 0x000fe2000bf66070ULL,
0x0000000c5c5f7c36ULL, 0x000fe20008000000ULL, 0x0000000404007c0cULL, 0x000fe2000bf26070ULL,
0x00000100035c7825ULL, 0x000fe200078e0012ULL, 0x0000000406007c0cULL, 0x000fc4000bf06070ULL,
0x0000001147477c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c5b5b7c36ULL, 0x000fe20008000000ULL,
0x0000005c535c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000c5a3f7c36ULL, 0x000fe20008000000ULL,
0x0000001145457c11ULL, 0x000fe2000f8e20ffULL, 0x000001005b5a7825ULL, 0x000fc800078e0012ULL,
0x0000000c58377c36ULL, 0x000fe40008000000ULL, 0x0000000c563b7c36ULL, 0x000fe40008000000ULL,
0x0000000c59597c36ULL, 0x000fe40008000000ULL, 0x0000000c57397c36ULL, 0x000fe40008000000ULL,
0x0000000c553d7c36ULL, 0x000fe40008000000ULL, 0x0000000c546b7c36ULL, 0x000fc40008000000ULL,
0x0000000c626d7c36ULL, 0x000fe40008000000ULL, 0x0000000c61617c36ULL, 0x000fe40008000000ULL,
0x0000000c60157c36ULL, 0x000fe40008000000ULL, 0x0000000c5e177c36ULL, 0x000fe40008000000ULL,
0x000000ffff5d7224ULL, 0x000fe200020e065dULL, 0x0000005a535a7210ULL, 0x000fe20007f9e0ffULL,
0x000001003f3e7825ULL, 0x000fc600078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000005c697faeULL, 0x000fe2000d901c52ULL, 0x0000010037567825ULL, 0x000fe200078e0012ULL,
0x0000003e53067210ULL, 0x000fc60007f7e0ffULL, 0x000001003b547825ULL, 0x000fc800078e0012ULL,
0x0000010059587825ULL, 0x000fc800078e0012ULL, 0x0000010039387825ULL, 0x000fc800078e0012ULL,
0x000001003d3c7825ULL, 0x000fc800078e0012ULL, 0x000001006b027825ULL, 0x000fc800078e0012ULL,
0x000001006d3a7825ULL, 0x000fc800078e0012ULL, 0x0000010061367825ULL, 0x000fc800078e0012ULL,
0x0000010015147825ULL, 0x000fc800078e0012ULL, 0x0000010035347825ULL, 0x000fc800078e0012ULL,
0x0000010017167825ULL, 0x000fc800078e0012ULL, 0x0000010005047825ULL, 0x000fc800078e0012ULL,
0x000001005f127825ULL, 0x000fe200078e0012ULL, 0x00000011685f7c11ULL, 0x000fc6000f8e20ffULL,
0x000000ffff5b7224ULL, 0x000fe200020e065bULL, 0x0000000407007c0cULL, 0x000fe2000bf86070ULL,
0x000000ffff077224ULL, 0x000fe200018e063fULL, 0x0000000408007c0cULL, 0x000fe4000bf66070ULL,
0x000000005a5f7faeULL, 0x000fe2000f101c52ULL, 0x00000058533e7210ULL, 0x000fc60007fde0ffULL,
0x0000000006677faeULL, 0x0005e2000d101c52ULL, 0x0000000409007c0cULL, 0x000fe2000bf46070ULL,
0x000000ffff3f7224ULL, 0x000fe200030e0659ULL, 0x0000001152597c11ULL, 0x000fca000f8e20ffULL,
0x000000003e597faeULL, 0x000fe2000c901c52ULL, 0x0000003853087210ULL, 0x000fe40007f3e0ffULL,
0x0000005653067210ULL, 0x004fc60007fde0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0639ULL,
0x000000040a007c0cULL, 0x000fe2000bf26070ULL, 0x000000ffff077224ULL, 0x000fe200030e0657ULL,
0x0000005453387210ULL, 0x000fc80007fde0ffULL, 0x0000000006517faeULL, 0x0005e2000e901c52ULL,
0x000000ffff397224ULL, 0x000fe200030e0655ULL, 0x0000001150557c11ULL, 0x000fe4000f8e20ffULL,
0x0000000253027210ULL, 0x000fc60007fbe0ffULL, 0x0000000008557faeULL, 0x0007e2000c101c52ULL,
0x000000040b007c0cULL, 0x000fe2000bf06070ULL, 0x000000ffff037224ULL, 0x000fe200028e0603ULL,
0x000000040c007c0cULL, 0x000fe2000bfa6070ULL, 0x00000000384f7faeULL, 0x000fe2000e101c52ULL,
0x0000003c53067210ULL, 0x004fe40007fde0ffULL, 0x00000036530a7210ULL, 0x000fc60007f9e0ffULL,
0x000000ffff077224ULL, 0x000fe200030e063dULL, 0x0000003a53087210ULL, 0x008fe20007fde0ffULL,
0x000000ffff0b7224ULL, 0x000fc800020e0637ULL, 0x000000ffff097224ULL, 0x000fe200030e063bULL,
0x000000114e3b7c11ULL, 0x000fe4000f8e20ffULL, 0x00000014530c7210ULL, 0x000fe40007fde0ffULL,
0x0000003453147210ULL, 0x000fe20007f9e0ffULL, 0x00000000063b7faeULL, 0x0005e2000d901c52ULL,
0x000000040d007c0cULL, 0x000fe2000bf66070ULL, 0x000000ffff0d7224ULL, 0x000fe200030e0615ULL,
0x000000040e007c0cULL, 0x000fe2000bfc6070ULL, 0x000000ffff157224ULL, 0x000fe200020e0635ULL,
0x000000114c357c11ULL, 0x000fe2000f8e20ffULL, 0x00000000024d7faeULL, 0x0007e2000d101c52ULL,
0x0000000453047210ULL, 0x000fc60007f9e0ffULL, 0x0000000008357faeULL, 0x0009e2000c901c52ULL,
0x000000040f007c0cULL, 0x000fe2000bf26070ULL, 0x000000ffff057224ULL, 0x000fe200020e0605ULL,
0x0000001653067210ULL, 0x004fe20007f5e0ffULL, 0x000000000a4b7faeULL, 0x0003e2000c101c52ULL,
0x0000000410007c0cULL, 0x000fc6000bf86070ULL, 0x000000ffff077224ULL, 0x000fe200010e0617ULL,
0x00000012530e7210ULL, 0x000fe20007f5e0ffULL, 0x000000000c497faeULL, 0x0003e2000e901c52ULL,
0x0000001148037c11ULL, 0x008fe4000f8e20ffULL, 0x0000001146097c11ULL, 0x010fe2000f8e20ffULL,
0x000000ffff0f7224ULL, 0x000fe400010e0613ULL, 0x0000000014037faeULL, 0x0003e8000d901c52ULL,
0x0000000006477faeULL, 0x0003e8000f101c52ULL, 0x0000000004097faeULL, 0x0003e8000c901c52ULL,
0x000000000e457faeULL, 0x0003e2000e101c52ULL, 0x0000000400987947ULL, 0x000fea0003800000ULL,
0x0000000a080f72a4ULL, 0x000fe2000f8e020fULL, 0x000000107d107824ULL, 0x000fe200078e00ffULL,
0x0000001169697c11ULL, 0x000fe4000f8e20ffULL, 0x0000001167677c11ULL, 0x000fe4000f8e20ffULL,
0x0000000f533f7c36ULL, 0x000fe20008000000ULL, 0x0000007010107812ULL, 0x000fe200078ec0ffULL,
0x0000000f5b397c36ULL, 0x000fe20008000000ULL, 0x0000001151517c11ULL, 0x000fe2000f8e20ffULL,
0x000001003f3e7825ULL, 0x000fe200078e0012ULL, 0x000000114f4f7c11ULL, 0x000fc4000f8e20ffULL,
0x000000114d4d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000010039387825ULL, 0x100fe200078e0012ULL,
0x0000003e103e7210ULL, 0x000fe40007f1e0ffULL, 0x000000114b4b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000f5a377c36ULL, 0x000fe20008000000ULL, 0x0000003810387210ULL, 0x000fe20007f3e0ffULL,
0x0000000f58357c36ULL, 0x000fe20008000000ULL, 0x0000001149497c11ULL, 0x000fe2000f8e20ffULL,
0x0000010037367825ULL, 0x000fe200078e0012ULL, 0x0000001147477c11ULL, 0x000fc4000f8e20ffULL,
0x0000001145457c11ULL, 0x000fe2000f8e20ffULL, 0x0000010035347825ULL, 0x000fc800078e0012ULL,
0x0000000f57157c36ULL, 0x000fe20008000000ULL, 0x0000001150577c11ULL, 0x000fe2000f8e20ffULL,
0x0000000f560f7c36ULL, 0x000fe40008000000ULL, 0x0000000f593b7c36ULL, 0x000fe40008000000ULL,
0x000000ffff3f7224ULL, 0x000fe200000e063fULL, 0x0000003610367210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff397224ULL, 0x000fe200008e0639ULL, 0x0000003410347210ULL, 0x000fe20007f3e0ffULL,
0x0000010015147825ULL, 0x100fe200078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e697faeULL, 0x0003e6000b901c52ULL, 0x000001000f0e7825ULL, 0x000fc800078e0012ULL,
0x0000000f540d7c36ULL, 0x000fe40008000000ULL, 0x000001003b3a7825ULL, 0x000fe200078e0012ULL,
0x000000114e3f7c11ULL, 0x002fc6000f8e20ffULL, 0x0000000f62097c36ULL, 0x000fe20008000000ULL,
0x0000003a103a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000f55177c36ULL, 0x000fe20008000000ULL,
0x0000001152557c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff377224ULL, 0x000fe200000e0637ULL,
0x0000001410147210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff357224ULL, 0x000fe200008e0635ULL,
0x0000000e100e7210ULL, 0x000fe20007f3e0ffULL, 0x000001000d0c7825ULL, 0x000fc800078e0012ULL,
0x0000010009087825ULL, 0x000fc800078e0012ULL, 0x0000000f61077c36ULL, 0x000fe40008000000ULL,
0x0000010017167825ULL, 0x000fc800078e0012ULL, 0x0000000f5f037c36ULL, 0x000fe40008000000ULL,
0x0000000f600b7c36ULL, 0x000fe40008000000ULL, 0x0000000f5e057c36ULL, 0x000fe40008000000ULL,
0x0000000f5d3d7c36ULL, 0x000fe40008000000ULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x0000000c100c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000f5c537c36ULL, 0x000fc40008000000ULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x0000000810087210ULL, 0x000fe20007f3e0ffULL,
0x0000010007067825ULL, 0x000fc800078e0012ULL, 0x000000ffff3b7224ULL, 0x000fe200010e063bULL,
0x0000001610167210ULL, 0x000fe20007f5e0ffULL, 0x0000010003027825ULL, 0x000fc800078e0012ULL,
0x000001000b0a7825ULL, 0x000fc800078e0012ULL, 0x0000010005047825ULL, 0x000fc800078e0012ULL,
0x000001003d3c7825ULL, 0x000fc800078e0012ULL, 0x0000010053127825ULL, 0x000fe200078e0012ULL,
0x0000001168537c11ULL, 0x000fc6000f8e20ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000000610067210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x0000000210027210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200010e0617ULL,
0x0000000a100a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000038537faeULL, 0x000fe2000b901c52ULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x0000000410047210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff037224ULL, 0x000fe200008e0603ULL, 0x0000000036677faeULL, 0x0005e2000b901c52ULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000003c103c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x000000003a557faeULL, 0x000fe2000b901c52ULL,
0x0000001210127210ULL, 0x000fc40007f5e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200008e063dULL,
0x0000000034517faeULL, 0x000fe4000b901c52ULL, 0x000000ffff137224ULL, 0x000fe200010e0613ULL,
0x000000114c377c11ULL, 0x004fe2000f8e20ffULL, 0x0000000014577faeULL, 0x0005e8000b901c52ULL,
0x000000000e4f7faeULL, 0x0007e8000b901c52ULL, 0x00000000163f7faeULL, 0x0003e2000b901c52ULL,
0x0000001148157c11ULL, 0x004fc6000f8e20ffULL, 0x000000000c4d7faeULL, 0x0003e2000b901c52ULL,
0x00000011460f7c11ULL, 0x008fc6000f8e20ffULL, 0x0000000008377faeULL, 0x0003e8000b901c52ULL,
0x00000000064b7faeULL, 0x0003e8000b901c52ULL, 0x000000000a497faeULL, 0x0003e8000b901c52ULL,
0x0000000002157faeULL, 0x0003e8000b901c52ULL, 0x0000000004477faeULL, 0x0003e8000b901c52ULL,
0x000000003c0f7faeULL, 0x0003e8000b901c52ULL, 0x0000000012457faeULL, 0x0003e4000b901c52ULL,
0x00000004ff037819ULL, 0x002fe2000001167dULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000197b087c11ULL, 0x000fe2000f8e20ffULL, 0x00000010140c7291ULL, 0x000fe2000f8e383fULL,
0x000000197a0c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000803027836ULL, 0x000fe20000000000ULL,
0x0000001979147c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a03107836ULL, 0x000fe20000000000ULL,
0x0000001978347c11ULL, 0x000fe4000f8e20ffULL, 0x0000000702027812ULL, 0x000fc400078e7811ULL,
0x0000000710107812ULL, 0x000fe400078e7811ULL, 0x0000001977387c11ULL, 0x000fe2000f8e20ffULL,
0x0000001011027824ULL, 0x040fe200078e0202ULL, 0x0000001011107211ULL, 0x000fe400078e20ffULL,
0x0000001963637c11ULL, 0x000fe4000f8e20ffULL, 0x0000001002027c11ULL, 0x000fe4000f8e20ffULL,
0x0000001010107c11ULL, 0x000fc4000f8e20ffULL, 0x00000019664c7c11ULL, 0x000fe2000f8e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000808783bULL, 0x000fe80000000200ULL,
0x000000000204783bULL, 0x0002a80000000200ULL, 0x000000000c0c783bULL, 0x000ee80000000200ULL,
0x000000001414783bULL, 0x000f220000000200ULL, 0x0000000c03027836ULL, 0x002fc60000000000ULL,
0x000000003434783bULL, 0x000e640000000200ULL, 0x0000000702027812ULL, 0x000fe400078e7811ULL,
0x00000000103c783bULL, 0x000be60000000200ULL, 0x0000001011027824ULL, 0x000fe200078e0202ULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x0000001002027c11ULL, 0x000fe2000f8e20ffULL,
0x0000000e03107836ULL, 0x020fe20000000000ULL, 0x000000004c4c783bULL, 0x000fe20000000200ULL,
0x00000008041c723cULL, 0x004fec000000181cULL, 0x0000000a0418723cULL, 0x000fe20000001818ULL,
0x0000001976087c11ULL, 0x000fca000f8e20ffULL, 0x0000000c0440723cULL, 0x008fe20000001840ULL,
0x000000000808783bULL, 0x000eaa0000000200ULL, 0x0000000e0420723cULL, 0x000fe20000001820ULL,
0x00000019750c7c11ULL, 0x000fca000f8e20ffULL, 0x000000140424723cULL, 0x010fe20000001824ULL,
0x000000000c0c783bULL, 0x000eea0000000200ULL, 0x000000160428723cULL, 0x000fe20000001828ULL,
0x0000001973147c11ULL, 0x000fca000f8e20ffULL, 0x00000034042c723cULL, 0x002fe2000000182cULL,
0x000000001414783bULL, 0x000e6a0000000200ULL, 0x000000360430723cULL, 0x000fe20000001830ULL,
0x000000000234783bULL, 0x0009ea0000000200ULL, 0x000000383c1c723cULL, 0x000fe2000000181cULL,
0x0000001971047c11ULL, 0x000fc4000f8e20ffULL, 0x0000ffff7c027812ULL, 0x010fc600078ec0ffULL,
0x000000083c40723cULL, 0x004fe20000001840ULL, 0x000000000404783bULL, 0x000ea20000000200ULL,
0x0000001970387c11ULL, 0x000fe4000f8e20ffULL, 0x0000888002027816ULL, 0x000fe400000000ffULL,
0x0000000a3c20723cULL, 0x000fe20000001820ULL, 0x000000196f087c11ULL, 0x000fca000f8e20ffULL,
0x0000000c3c24723cULL, 0x008fe20000001824ULL, 0x000000000808783bULL, 0x000eea0000000200ULL,
0x0000000e3c28723cULL, 0x000fe20000001828ULL, 0x00000007100c7812ULL, 0x000fe400078e7811ULL,
0x000000196a107c11ULL, 0x000fc6000f8e20ffULL, 0x00000010110c7824ULL, 0x000fe200078e020cULL,
0x0000003a3c18723cULL, 0x000fe20000001818ULL, 0x000000003838783bULL, 0x000f260000000200ULL,
0x000000100c0c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000001010783bULL, 0x000f620000000200ULL,
0x000000143c2c723cULL, 0x002fe8000000182cULL, 0x000000000c0c783bULL, 0x000fe40000000200ULL,
0x000000163c30723cULL, 0x000fe20000001830ULL, 0x0000001965147c11ULL, 0x000fca000f8e20ffULL,
0x00000004343c723cULL, 0x004fe2000000181cULL, 0x00000000631c783bULL, 0x000e680000000200ULL,
0x000000001414783bULL, 0x000ea20000000200ULL, 0x000000063404723cULL, 0x000fec0000001818ULL,
0x000000083424723cULL, 0x008fe20000001824ULL, 0x0000001964187c11ULL, 0x000fca000f8e20ffULL,
0x0000000a3408723cULL, 0x000fe20000001828ULL, 0x000000001818783bULL, 0x000eea0000000200ULL,
0x000000383440723cULL, 0x010fec0000001840ULL, 0x0000003a3438723cULL, 0x000fec0000001820ULL,
0x00000010342c723cULL, 0x020fec000000182cULL, 0x0000001e0c08723cULL, 0x002fec0000001808ULL,
0x000000123430723cULL, 0x000fe20000001830ULL, 0x000000ffff1f7224ULL, 0x000fc400078e0002ULL,
0x000000047d027824ULL, 0x000fe400078e00ffULL, 0x800000001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000004c0c3c723cULL, 0x000fe4000000183cULL, 0xfffffff002027812ULL, 0x000fe200078ec0ffULL,
0x0236101fff0075a7ULL, 0x000e66000800015bULL, 0x0000004e0c4c723cULL, 0x000fec0000001804ULL,
0x000000140c20723cULL, 0x004fe20000001840ULL, 0x3db504f30a0a7820ULL, 0x000fe20000410000ULL,
0x3db504f30b0b7820ULL, 0x000fc80000410000ULL, 0x000000160c14723cULL, 0x000fec0000001838ULL,
0x0000001c0c10723cULL, 0x000fe20000001824ULL, 0x3db504f33c037820ULL, 0x000fca0000410000ULL,
0x000000180c04723cULL, 0x008fe2000000182cULL, 0x3db504f3091c7820ULL, 0x000fe20000410000ULL,
0x3db504f34c4c7820ULL, 0x000fe20000410000ULL, 0x3db504f34d4d7820ULL, 0x000fe20000410000ULL,
0x3db504f34e4e7820ULL, 0x000fe20000410000ULL, 0x3db504f34f4f7820ULL, 0x000fe20000410000ULL,
0x0000001a0c0c723cULL, 0x000fe20000001830ULL, 0x3db504f33d187820ULL, 0x000fe20000410000ULL,
0x3db504f33f197820ULL, 0x000fe20000410000ULL, 0x3db504f320207820ULL, 0x000fe20000410000ULL,
0x3db504f321217820ULL, 0x000fe20000410000ULL, 0x3db504f322227820ULL, 0x000fe20000410000ULL,
0x3db504f323237820ULL, 0x000fe20000410000ULL, 0x3db504f3081b7820ULL, 0x000fe20000410000ULL,
0x3db504f33e1a7820ULL, 0x000fe20000410000ULL, 0x3db504f314147820ULL, 0x000fe20000410000ULL,
0x3db504f315157820ULL, 0x000fe20000410000ULL, 0x3db504f316167820ULL, 0x000fe20000410000ULL,
0x3db504f317177820ULL, 0x000fe20000410000ULL, 0x3db504f310107820ULL, 0x000fe20000410000ULL,
0x3db504f311117820ULL, 0x000fe20000410000ULL, 0x3db504f312127820ULL, 0x000fe20000410000ULL,
0x3db504f313137820ULL, 0x000fc40000410000ULL, 0x3db504f3041d7820ULL, 0x000fe20000410000ULL,
0x3db504f3051e7820ULL, 0x000fe20000410000ULL, 0x3db504f306087820ULL, 0x000fe20000410000ULL,
0x3db504f307097820ULL, 0x000fc60000410000ULL, 0x3db504f30c0c7820ULL, 0x000fe20000410000ULL,
0x3db504f30d0d7820ULL, 0x000fe20000410000ULL, 0x3db504f30e0e7820ULL, 0x000fe20000410000ULL,
0x3db504f30f0f7820ULL, 0x000fe20000410000ULL, 0x0000001000a48947ULL, 0x002fec0003800000ULL,
0x0234000c02047984ULL, 0x0002a20008000c00ULL, 0x000000184a007c0cULL, 0x000fda000bf05270ULL,
0x0000000400080947ULL, 0x002fea0003800000ULL, 0x000000027d1f7824ULL, 0x000fe200078e00ffULL,
0x8000000e170e7290ULL, 0x000fc8000fffe03fULL, 0x000000061f1f7812ULL, 0x000fc800078ec0ffULL,
0x000000011f247812ULL, 0x040fe400078efcffULL, 0x000000081f257812ULL, 0x040fe400078efcffULL,
0x0000000e24007c0cULL, 0x000fe4000bf26070ULL, 0x000000101f247812ULL, 0x000fe400078efcffULL,
0x0000000e25007c0cULL, 0x000fe4000bf06070ULL, 0x0000000e24007c0cULL, 0x000fc4000bfc6070ULL,
0x000000111f257812ULL, 0x040fe400078efcffULL, 0x000000181f247812ULL, 0x040fe400078efcffULL,
0x0000000e1f007c0cULL, 0x000fe4000bf46070ULL, 0x0000000e25007c0cULL, 0x000fe4000bfa6070ULL,
0x0000000e24007c0cULL, 0x000fe4000bf66070ULL, 0x000000091f267812ULL, 0x000fc400078efcffULL,
0x000000191f257812ULL, 0x040fe400078efcffULL, 0x000000201f247812ULL, 0x000fe400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff03037808ULL, 0x000fe40005000000ULL,
0xff7fffff19197808ULL, 0x000fe40004800000ULL, 0xff7fffff18187808ULL, 0x000fc40004800000ULL,
0x0000000e26007c0cULL, 0x000fe4000bf86070ULL, 0x0000000e25007c0cULL, 0x000fe4000bf46070ULL,
0x0000000e24007c0cULL, 0x000fe4000bf26070ULL, 0x000000211f257812ULL, 0x040fe400078efcffULL,
0x000000281f247812ULL, 0x000fe400078efcffULL, 0xff7fffff4e4e7808ULL, 0x000fc40004000000ULL,
0xff7fffff4c4c7808ULL, 0x000fe40004000000ULL, 0xff7fffff4f4f7808ULL, 0x000fe40006000000ULL,
0xff7fffff4d4d7808ULL, 0x000fe40006000000ULL, 0x0000000e25007c0cULL, 0x000fe4000bf06070ULL,
0x0000000e24007c0cULL, 0x000fe4000bf86070ULL, 0x000000291f257812ULL, 0x000fc400078efcffULL,
0x000000301f247812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40007000000ULL, 0xff7fffff23237808ULL, 0x000fe40006800000ULL,
0xff7fffff21217808ULL, 0x000fe40006800000ULL, 0x0000000e25007c0cULL, 0x000fc4000bfc6070ULL,
0x0000000e24007c0cULL, 0x000fe4000bfa6070ULL, 0x000000311f257812ULL, 0x040fe400078efcffULL,
0x000000381f247812ULL, 0x040fe400078efcffULL, 0x000000391f1f7812ULL, 0x000fe400078efcffULL,
0xff7fffff16167808ULL, 0x000fe40005800000ULL, 0xff7fffff14147808ULL, 0x000fc40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0xff7fffff10107808ULL, 0x000fe40004800000ULL,
0x0000000e25007c0cULL, 0x000fe4000bf66070ULL, 0x0000000e24007c0cULL, 0x000fc4000bf46070ULL,
0x0000000e1f007c0cULL, 0x000fe4000bf26070ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff11117808ULL, 0x000fe40004000000ULL, 0xff7fffff0a0a7808ULL, 0x000fe40006000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40006000000ULL, 0xff7fffff0b0b7808ULL, 0x000fc40007000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40007000000ULL, 0xff7fffff08087808ULL, 0x000fe40006800000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40006800000ULL, 0xff7fffff09097808ULL, 0x000fe40005800000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40005800000ULL, 0xff7fffff0e0e7808ULL, 0x000fc40005000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40005000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40004800000ULL,
0xff7fffff0d0d7808ULL, 0x000fce0004800000ULL, 0x00000003041f7209ULL, 0x004fe20007810000ULL,
0xffffffff00047882ULL, 0x000fe20000000000ULL, 0x0000001a05047209ULL, 0x000fe40007810000ULL,
0x000000181f1f7209ULL, 0x000fe40007810000ULL, 0x0000001904057209ULL, 0x000fe40007810000ULL,
0x0000004c1f047209ULL, 0x000fe40007810000ULL, 0x0000004e05247209ULL, 0x000fc40007810000ULL,
0x0000004d04057209ULL, 0x000fe40007810000ULL, 0x0000004f241f7209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x000000221f247209ULL, 0x000fe40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x00000023241f7209ULL, 0x000fc40007810000ULL,
0x0000001405047209ULL, 0x000fe40007810000ULL, 0x000000161f247209ULL, 0x000fe40007810000ULL,
0x0000001504057209ULL, 0x000fe40007810000ULL, 0x00000017241f7209ULL, 0x000fe40007810000ULL,
0x0000001005047209ULL, 0x000fe40007810000ULL, 0x000000121f247209ULL, 0x000fc40007810000ULL,
0x0000001104047209ULL, 0x000fe40007810000ULL, 0x0000001324057209ULL, 0x000fe40007810000ULL,
0x0000001b041f7209ULL, 0x000fe40007810000ULL, 0x0000000a05047209ULL, 0x000fe40007810000ULL,
0x0000001c1f247209ULL, 0x000fe40007810000ULL, 0x0000000b04057209ULL, 0x000fc40007810000ULL,
0x0000001d241f7209ULL, 0x000fe40007810000ULL, 0x0000000805047209ULL, 0x000fe40007810000ULL,
0x0000001e1f1f7209ULL, 0x000fe40007810000ULL, 0x0000000904057209ULL, 0x000fe40007810000ULL,
0x000000ff7cff7812ULL, 0x000fe4000780c0ffULL, 0x0000000c1f047209ULL, 0x000fc40007810000ULL,
0x0000000e05247209ULL, 0x000fe40007810000ULL, 0x00000001ff7c7807ULL, 0x000fe40000000000ULL,
0x0000000d04047209ULL, 0x000fe40007810000ULL, 0x0000000f24057209ULL, 0x000fe20007810000ULL,
0x0000000e04207947ULL, 0x000fec000b800000ULL, 0x0c401f00041f7f89ULL, 0x000e6800000e0000ULL,
0x0c401f0005247f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006277f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007287f89ULL, 0x000f2200000e0000ULL, 0x0000001f04257209ULL, 0x002fc40007810000ULL,
0x0000002405267209ULL, 0x004fc60007810000ULL, 0x0c201f00252a7f89ULL, 0x000e6200000e0000ULL,
0x0000002706277209ULL, 0x008fc60007810000ULL, 0x0c201f0026297f89ULL, 0x000ea200000e0000ULL,
0x00000028071f7209ULL, 0x010fc60007810000ULL, 0x0c201f00272c7f89ULL, 0x000ee800000e0000ULL,
0x0c201f001f247f89ULL, 0x00092200000e0000ULL, 0x0000002a25047209ULL, 0x002fe40007810000ULL,
0x0000002926057209ULL, 0x004fe40007810000ULL, 0x0000002c27067209ULL, 0x008fce0007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b052b7820ULL, 0x000fc60000410000ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b03037823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4d4d7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b4f4f7823ULL, 0x000fe2000001082bULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010807ULL, 0x0000001000277308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0d077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b132d7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b0f0f7823ULL, 0x000fe2000001082bULL, 0x0000001b00297308ULL, 0x000ff00000000800ULL,
0x0000000c002a7308ULL, 0x000ff00000000800ULL, 0x0000001a000d7308ULL, 0x000ff00000000800ULL,
0x0000001900107308ULL, 0x000e700000000800ULL, 0x0000004e001b7308ULL, 0x000fe20000000800ULL,
0x0000000d1019723eULL, 0x002fce00000000ffULL, 0x0000004f000c7308ULL, 0x000e620000000800ULL,
0x3c003c00ff0d7424ULL, 0x000fce00078e00ffULL, 0x0000000300037308ULL, 0x000fe20000000800ULL,
0x0000001b0c1b723eULL, 0x002fce00000000ffULL, 0x0000001800187308ULL, 0x000e620000000800ULL,
0x3c003c00ff0c7424ULL, 0x000fce00078e00ffULL, 0x0000004c004c7308ULL, 0x000fe20000000800ULL,
0x000000031818723eULL, 0x002fce00000000ffULL, 0x0000004d004d7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b16037823ULL, 0x000fce000001082bULL, 0x0000001100287308ULL, 0x000fe20000000800ULL,
0x0000004c4d1a723eULL, 0x002fce00000000ffULL, 0x0000002200117308ULL, 0x0003f00000000800ULL,
0x0000001400257308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b17227823ULL, 0x002fce000001082bULL,
0x0000001500267308ULL, 0x0003f00000000800ULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000c1814723cULL, 0x002fe400000018ffULL,
0x0000002100217308ULL, 0x000e700000000800ULL, 0x00000023002c7308ULL, 0x0004e20000000800ULL,
0x000000202110723eULL, 0x002fce00000000ffULL, 0x0000000300037308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b12237823ULL, 0x104fe2000001082bULL, 0x000000252612723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b08217823ULL, 0x100fe2000001082bULL, 0x000000272808723eULL, 0x000fe400000000ffULL,
0x000000112c11723eULL, 0x008fe400000000ffULL, 0x0000002200227308ULL, 0x000e700000000800ULL,
0x0000001c001c7308ULL, 0x000fe20000000800ULL, 0x000000032213723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b0b037823ULL, 0x000fcc000001082bULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b09227823ULL, 0x000fe2000001082bULL, 0x0000000c1014723cULL, 0x000fec0000001814ULL,
0x0000002d002e7308ULL, 0x000e700000000800ULL, 0x0000000a00207308ULL, 0x0005e20000000800ULL,
0x000000232e09723eULL, 0x002fce00000000ffULL, 0x0000000300037308ULL, 0x000e620000000800ULL,
0x000000291c0a723eULL, 0x004fce00000000ffULL, 0x0000001d001d7308ULL, 0x000fe20000000800ULL,
0x00000020030b723eULL, 0x002fce00000000ffULL, 0x0000001e001e7308ULL, 0x000e620000000800ULL,
0xfffffffc7d037812ULL, 0x000fe200078ec0ffULL, 0x0000000c082c723cULL, 0x000fec0000001814ULL,
0x0000000700077308ULL, 0x000ea20000000800ULL, 0x0000001d1e14723eULL, 0x002fce00000000ffULL,
0x0000002100217308ULL, 0x000fe20000000800ULL, 0x0000002a0716723eULL, 0x004fce00000000ffULL,
0x0000002200227308ULL, 0x000e620000000800ULL, 0x000000241f077209ULL, 0x010fce0007810000ULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x000000212215723eULL, 0x002fce00000000ffULL,
0x0000000f000f7308ULL, 0x000e640000000800ULL, 0x0000000e0f17723eULL, 0x002fce00000000ffULL,
0x0000000c142c723cULL, 0x000fee000000182cULL, 0x0000000fff0c7424ULL, 0x000fca00078e00ffULL,
0x000000030c037219ULL, 0x000fd600000006ffULL, 0x001c1fff2c0c7589ULL, 0x00026200000e0000ULL,
0x00000000001c7806ULL, 0x000fe200038e0100ULL, 0x00000000030e73a1ULL, 0x000eb000000e8000ULL,
0x00000000030473c4ULL, 0x000ee20000004000ULL, 0x00000000000e7886ULL, 0x000fc400038e0100ULL,
0x0000000e03ff7c12ULL, 0x004fda000f80400eULL, 0x0000000a04388947ULL, 0x00afea000b800000ULL,
0x001c1fff2e0d7589ULL, 0x0002a800000e0000ULL, 0x001c1fff0e0e7589ULL, 0x000ee800000e0000ULL,
0x001c1fff000f7589ULL, 0x00032400000e0000ULL, 0xfffffff8ff447812ULL, 0x000fe200078ee244ULL,
0x0000001014047291ULL, 0x000fe2000f8e583fULL, 0x00000003001f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff247224ULL, 0x000fe200078e0018ULL, 0x000000037dff7812ULL, 0x000fe2000780c0ffULL,
0x00000008441c7836ULL, 0x040fe20000000000ULL, 0x000000041f217812ULL, 0x000fe200078efcffULL,
0x0000000844007824ULL, 0x002fe200078e00ffULL, 0x000000071f037812ULL, 0x000fe200078e7844ULL,
0x00000004ff207e24ULL, 0x000fe2000f8e00ffULL, 0x00000007211d7812ULL, 0x000fe200078e7844ULL,
0x000000081c1e7824ULL, 0x000fe200078e00ffULL, 0x000000071f1f7812ULL, 0x000fe200078e781cULL,
0x000000ffff257224ULL, 0x000fe200078e001aULL, 0x0000000721217812ULL, 0x000fe200078e781cULL,
0x00011000201c7836ULL, 0x000fe20000000000ULL, 0x0000000003037212ULL, 0x080fe200078efcffULL,
0x000000ffff267224ULL, 0x000fe200078e0010ULL, 0x000000001d1d7212ULL, 0x000fe200078efcffULL,
0x000000ffff277224ULL, 0x000fe200078e0012ULL, 0x0000001e1f1f7212ULL, 0x080fe200078efcffULL,
0x0000001003037824ULL, 0x000fe200078e021cULL, 0x0000001e21217212ULL, 0x000fe200078efcffULL,
0x000000ffff287224ULL, 0x000fc400078e0008ULL, 0x000000ffff187224ULL, 0x000fe200078e0019ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000002403007844ULL, 0x0003e20000000200ULL,
0x000000101d1d7824ULL, 0x000fe400078e021cULL, 0x000000ffff297224ULL, 0x000fe400078e000aULL,
0x000000ffff2a7224ULL, 0x000fc400078e0014ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0016ULL,
0x000000ffff197224ULL, 0x000fe400078e001bULL, 0x000000ffff087224ULL, 0x000fe200078e0009ULL,
0x000000281d007844ULL, 0x0003e20000000200ULL, 0x000000101f1f7824ULL, 0x000fe400078e021cULL,
0x000000ffff1a7224ULL, 0x000fe400078e0011ULL, 0x000000ffff1b7224ULL, 0x000fc400078e0013ULL,
0x000000ffff097224ULL, 0x000fe400078e000bULL, 0x0000001021217824ULL, 0x000fe200078e021cULL,
0x000000181f007844ULL, 0x0003e20000000200ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0015ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0017ULL, 0x00000001ff007424ULL, 0x000fe400078e00ffULL,
0x0000000dff4a7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000821007844ULL, 0x0003e20000000200ULL,
0x000000050d00728cULL, 0x000fc6000bf06070ULL, 0x0230000402008988ULL, 0x0003e80008000c0cULL,
0x0232000c02008988ULL, 0x01c3e20008000c0cULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x02360800ffff79a7ULL, 0x0003d8000850001bULL, 0xffffffb800048947ULL, 0x002fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000001bff2c7e24ULL, 0x000fe4000f8e00ffULL,
0x0000001bff2d7e24ULL, 0x000fce000f8e00ffULL, 0x0236082dff0075a7ULL, 0x000262000802015cULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0236082dff0095a7ULL, 0x000e64000802005cULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff3800107947ULL, 0x020fea000383ffffULL, 0x00000010ff067e24ULL, 0x000fe4000f8e00ffULL,
0x00000010ff077e24ULL, 0x000fce000f8e00ffULL, 0x02362807ff0075a7ULL, 0x000262000802015cULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x02362807ff0095a7ULL, 0x000e64000802005cULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff5400147947ULL, 0x020fea000383ffffULL, 0x023600ffff0075a7ULL, 0x000ee20008000150ULL,
0x0000b0000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x023600ffff0085a7ULL, 0x000e640008000050ULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffb400907947ULL, 0x006fea000383ffffULL, 0x000000ffff047224ULL, 0x100fe400078e001fULL,
0x000000ffff057224ULL, 0x000fce00078e001fULL, 0x02361005ff0075a7ULL, 0x000262000800015bULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x02361005ff0085a7ULL, 0x000e64000800005bULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffec003c7947ULL, 0x000fea000383ffffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0004ULL, 0x00000002ff2f7424ULL, 0x000fe400078e00ffULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fce00078e00ffULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00002f2e2d7389ULL, 0x0006e40000000030ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff2e7224ULL, 0x002fe400078e0005ULL, 0x00000002ff2f7424ULL, 0x000fe400078e00ffULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x004fce00078e002dULL, 0x000000002b087348ULL, 0x000fea0003c00000ULL,
0x0c00002f2e2d7389ULL, 0x0002640000000030ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001f04257209ULL, 0x000fe20007810000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0006ULL,
0x000000ffff247224ULL, 0x000fce00078e002dULL, 0x000000002b087348ULL, 0x000fea0003c00000ULL,
0x0c00002f2e2d7389ULL, 0x0002640000000030ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002405267209ULL, 0x000fe20007810000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0007ULL,
0x000000ffff277224ULL, 0x000fce00078e002dULL, 0x000000002b087348ULL, 0x000fea0003c00000ULL,
0x0c00002f2e2d7389ULL, 0x0002640000000030ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002706277209ULL, 0x000fe20007810000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0025ULL,
0x00000001ff2f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff287224ULL, 0x000fce00078e002dULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00002f2e2d7389ULL, 0x0002640000000030ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x00000028071f7209ULL, 0x000fe20007810000ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0026ULL, 0x000000ffff2a7224ULL, 0x000fce00078e002dULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00002f2e2d7389ULL, 0x0002640000000030ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002a25047209ULL, 0x000fe20007810000ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0027ULL, 0x000000ffff297224ULL, 0x000fce00078e002dULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00002f2e2d7389ULL, 0x0002640000000030ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002926057209ULL, 0x000fe20007810000ULL,
0x000000ffff2e7224ULL, 0x000fe400078e001fULL, 0x000000ffff2c7224ULL, 0x000fce00078e002dULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00002f2e2d7389ULL, 0x0002640000000030ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002c27067209ULL, 0x000fe20007810000ULL,
0x000000ffff247224ULL, 0x000fe200078e002dULL, 0xfffffff000387947ULL, 0x000fec000383ffffULL,
0x0000007000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff1c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fce00078e0003ULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0000000f2e0f7389ULL, 0x0006e4000000001cULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0d7224ULL, 0x004fe400078e000fULL,
0x000000ffff2e7224ULL, 0x002fe400078e000eULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff1c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fce00078e0003ULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0000000f2e0f7389ULL, 0x0006e4000000001cULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x004fe400078e000fULL,
0x000000ffff2e7224ULL, 0x002fe400078e0000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff1c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fce00078e0003ULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0000000f2e0f7389ULL, 0x0006e4000000001cULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff400607947ULL, 0x006fea000383ffffULL, 0x0180000049027836ULL, 0x000fe20000000000ULL,
0x0000016000007945ULL, 0x000fe80003800000ULL, 0x7f80000002037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000004900028308ULL, 0x0002a20000001000ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x008000000300780cULL, 0x040fe40003f22070ULL,
0x000000ff0300720cULL, 0x000fe40003f05070ULL, 0xffffffffff027807ULL, 0x004fe40004800000ULL,
0x00000001ff037807ULL, 0x000fc60000000000ULL, 0x000000ffff027224ULL, 0x000fca00078e0a02ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000000000248947ULL, 0x000fea0003800000ULL,
0x007fffff49027812ULL, 0x000fc800078ec0ffULL, 0x000000ff0200720cULL, 0x000fc80003f02070ULL,
0xffffffffff027807ULL, 0x000fca0004000000ULL, 0x000000ffff027224ULL, 0x000fca00078e0a02ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000049037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000004900027308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0006ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffef0027c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000023680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL,
0x0000000e00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000f0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000628ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000670ULL, 0x000000000000039cULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a0cULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000a30ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000a30ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000a60ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000aa8ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000ab0ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000b00ULL, 0x0000000000010f00ULL,
0x0000000e00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000011a00ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000011a10ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000011a10ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000011a10ULL, 0x0000000000000268ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x00000000000120f8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000120f8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000aa8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000b00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000010f00ULL, 0x0000000000010f00ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000011a00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000414ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000011a10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_16_m_16_sm_90_cubin_len = 74312;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
