/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_16_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000013510ULL, 0x0000000000013090ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000011f20ULL, 0x0000000000000190ULL, 0x000e002200000106ULL, 0x00000000000120b0ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x00000000000120f0ULL, 0x0000000000000110ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000012200ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00011f2000000000ULL, 0x0000040400000000ULL, 0x810c0000007c0400ULL, 0x00473c0400288080ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0xb7082880808d0828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080b7920000ULL, 0x0000000000000022ULL,
0x0000002cffffffffULL, 0x0000007000000000ULL, 0x00011f2000000000ULL, 0x0000019000000000ULL,
0x00005c0400000000ULL, 0x8082288080b70900ULL, 0x0000000000002880ULL, 0x00000054ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8c08288080860828ULL, 0x288080aa08288080ULL, 0x80a808288080ac08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080a89200ULL, 0x0000001cffffffffULL,
0x0000010000000000ULL, 0x000120b000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8c08288080860828ULL, 0x288080a808288080ULL,
0x80ac08288080aa08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080ac9200ULL,
0x0000001cffffffffULL, 0x0000018800000000ULL, 0x000120f000000000ULL, 0x0000011000000000ULL,
0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000a8ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL,
0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000dULL, 0x000c170400581903ULL,
0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL,
0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00010c9000183104ULL, 0x0001115000011140ULL, 0x000112b0000112a0ULL, 0x00c82904000112c0ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0500001c0500001cULL, 0x0500001c0500001cULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000009000c82804ULL, 0x000020b000000100ULL, 0x00003b2000003a60ULL,
0x00003c0000003bd0ULL, 0x000040a000004040ULL, 0x0000628000004880ULL, 0x000063f000006330ULL,
0x0000688000006440ULL, 0x0000702000006890ULL, 0x0000739000007050ULL, 0x00009f80000073a0ULL,
0x0000a48000009fa0ULL, 0x00010b600000a4b0ULL, 0x00010ba000010b90ULL, 0x00010bd000010bb0ULL,
0x00010c1000010bf0ULL, 0x0001129000010c20ULL, 0x00011300000112f0ULL, 0x0001194000011310ULL,
0x00011a20000119b0ULL, 0x00011b1000011aa0ULL, 0x00011bf000011b80ULL, 0x00011cd000011c60ULL,
0x00011db000011d40ULL, 0x00011e9000011e30ULL, 0x0110390400011ef0ULL, 0x000000ff00000170ULL,
0x003f010000023600ULL, 0x0000000b000001b0ULL, 0x003f013000023608ULL, 0x0000000b000001d0ULL,
0x003f013000023610ULL, 0x000000ff000003f0ULL, 0x003f010700023600ULL, 0x00000005000005f0ULL,
0x003f010200000004ULL, 0x00000005000006b0ULL, 0x003f010100000000ULL, 0x0000000900003830ULL,
0x003f01060002360cULL, 0x0000000900003990ULL, 0x003f01060002360cULL, 0x0000001400004810ULL,
0x003f010100000000ULL, 0x0000000900006020ULL, 0x003f01060002362cULL, 0x0000000900006180ULL,
0x003f01060002362cULL, 0x0000000e00006d60ULL, 0x003f010100000000ULL, 0x000000ff0000cc30ULL,
0x003f010600023604ULL, 0x000000ff0000ccc0ULL, 0x003f010600023604ULL, 0x0000008800010120ULL,
0x003f010600023614ULL, 0x0000008800010460ULL, 0x003f010600023614ULL, 0x0000008800011890ULL,
0x003f010100023608ULL, 0x00141c0400033803ULL, 0x0000b2e00000aea0ULL, 0x0000cdc00000cd10ULL,
0x00000401000118f0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001fcULL, 0x0000001100000002ULL,
0x0000000000000174ULL, 0x0000001100000002ULL, 0x00000000000000dcULL, 0x0000001100000002ULL,
0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001d9ULL, 0x0000001100000002ULL,
0x0000000000000151ULL, 0x0000001100000002ULL, 0x00000000000000b2ULL, 0x0000001100000002ULL,
0x0000004043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000a7919ULL, 0x000e620000002300ULL,
0x0000460000067ab9ULL, 0x000fe40000000a00ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x0000000000077919ULL, 0x000ea80000002100ULL,
0x0000000000897919ULL, 0x000ee80000002700ULL, 0x00000000007e7919ULL, 0x000f220000002600ULL,
0x000000010a007824ULL, 0x002fc600078e0203ULL, 0x00001fff0a0a7589ULL, 0x000e6200000e0000ULL,
0x00000080000b7824ULL, 0x104fe200078e0207ULL, 0x00000005ff8e7819ULL, 0x000fe20000011607ULL,
0x00000004ff007424ULL, 0x000fc600078e00ffULL, 0x000000ff0b00720cULL, 0x000fe20003f05270ULL,
0x0000620089067625ULL, 0x008fe200078e0000ULL, 0x000000030b00780cULL, 0x040fe20003f24070ULL,
0x00001fff8e8e7589ULL, 0x000ea200000e0000ULL, 0x0000007f0b00780cULL, 0x000fd20003f44070ULL,
0x3fffff80ff028424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff038424ULL, 0x000fe200078e00ffULL,
0x3fffffc000089802ULL, 0x000fe20000000f00ULL, 0x3fffffe0ff049424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff059424ULL, 0x000fe200078e00ffULL, 0x02360002ff008388ULL, 0x0007e20000000a00ULL,
0x000000ff0a00720cULL, 0x002fe20003f05270ULL, 0xff317217ff0ca424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff099424ULL, 0x000fe200078e00ffULL, 0x023608040b009388ULL, 0x0007e8000000ca00ULL,
0x0234000c0b00a388ULL, 0x0007e80000004800ULL, 0x023610080b009388ULL, 0x0007e8000000ca00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000026000000947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x014e620000000000ULL, 0x000000048e037824ULL, 0x008fe200078e00ffULL,
0x0000000404057899ULL, 0x000fe2000800063fULL, 0x000000107e027824ULL, 0x000fc400078e00ffULL,
0x00000100ff107424ULL, 0x000fc600078e00ffULL, 0x0000000589027c24ULL, 0x000fe2000f8e0202ULL,
0x000000030e097211ULL, 0x042fe200078fe0ffULL, 0x000000100e047824ULL, 0x000fc600078e00ffULL,
0x00000002090b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000102037824ULL, 0x040fe200078e0209ULL,
0x0000000709057812ULL, 0x000fe400078ec0ffULL, 0x000000070b0d7812ULL, 0x000fe200078ec0ffULL,
0x00000001020c7824ULL, 0x000fe200078e020bULL, 0x000000f0040f7812ULL, 0x000fe200078ec0ffULL,
0x00005c0003027625ULL, 0x000fe200078e0010ULL, 0x0000000f05087812ULL, 0x000fc600078e780eULL,
0x00005c000c047625ULL, 0x000fe200078e0010ULL, 0x0000000f0d0c7812ULL, 0x000fe400078e780eULL,
0x0000000f02027210ULL, 0x080fe40007f1e0ffULL, 0x0000000809087211ULL, 0x000fe200078e20ffULL,
0x000000100b0c7824ULL, 0x000fe200078e020cULL, 0x0000000f04047210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff037224ULL, 0x000fe400000e0603ULL, 0x0000001008097824ULL, 0x000fc400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400008e0605ULL, 0x000000100c0b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000b901c46ULL,
0x00000000040b7faeULL, 0x0003e8000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x02360000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006068f7981ULL, 0x014ea2000c1e1900ULL, 0x00000000000579c3ULL, 0x000f220000002500ULL,
0x000000ff0a00720cULL, 0x000fe20003f05270ULL, 0x00000005ff907e24ULL, 0x010fe2000f8e00ffULL,
0x0000007f8f8d7810ULL, 0x004fc40007ffe0ffULL, 0x000000ff8f8b7810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff8d7819ULL, 0x000fe4000001168dULL, 0x00000008ff8b7819ULL, 0x000fca000001168bULL,
0x0000ae0000008947ULL, 0x000fea0003800000ULL, 0x00000002ff027819ULL, 0x00afe2000001168eULL,
0x00000001ff067424ULL, 0x000fe200078e00ffULL, 0x000236108e057811ULL, 0x000fe200078e20ffULL,
0xffffffffff097424ULL, 0x000fe200078e00ffULL, 0x01ffffff02037812ULL, 0x000fca00078ec0ffULL,
0x0000000290047824ULL, 0x000fca00078e0203ULL, 0x0000008d0400720cULL, 0x000fda0003f06070ULL,
0x0000640000038a02ULL, 0x000fe20000000f00ULL, 0x0000000289028824ULL, 0x000fc800078e00ffULL,
0x0000640002038624ULL, 0x000fc800078e0203ULL, 0x0000000104038824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040605ff738cULL, 0x0003e20000000000ULL,
0x0000600003028625ULL, 0x000fe200078e0000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000190067810ULL, 0x002fe20007ffe0ffULL, 0x0000000602098981ULL, 0x000362000c1e1900ULL,
0x00000001ff627819ULL, 0x000fe2000001168eULL, 0x000000807e087824ULL, 0x000fe200078e00ffULL,
0x0000008b0600720cULL, 0x000fe20003f06070ULL, 0x0000000005ff7f8cULL, 0x0003e2000c80043fULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x0000000490077824ULL, 0x000fc800078e0262ULL,
0x00000040070b7824ULL, 0x000fe200078e00ffULL, 0x000000018e077812ULL, 0x000fc800078ec0ffULL,
0x00000040080c7812ULL, 0x000fe200078ef80bULL, 0x00000be000008947ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x002e620000000000ULL, 0x0000000b8f027217ULL, 0x000fe20007800000ULL,
0x0000000409097c24ULL, 0x020fe2000f8e020cULL, 0x0000010000277802ULL, 0x000fc60000000f00ULL,
0x0000000102027824ULL, 0x000fe200078e0a0bULL, 0x00000003ff057819ULL, 0x002fe40000011606ULL,
0x0ffffff8060a7812ULL, 0x000fe400078ec0ffULL, 0x0000000605037212ULL, 0x040fe400078e3cffULL,
0x0000000c050f7810ULL, 0x040fe40007ffe0ffULL, 0x00000008050d7810ULL, 0x040fe40007ffe0ffULL,
0x00000004050b7810ULL, 0x000fe20007ffe0ffULL, 0x000000080f157824ULL, 0x000fe200078e00ffULL,
0x000000070a0c7812ULL, 0x000fc400078ef803ULL, 0x000000060d0a7212ULL, 0x080fe200078e3cffULL,
0x000000080b107824ULL, 0x000fe200078e00ffULL, 0x000000030d137819ULL, 0x000fe400000006ffULL,
0x0000001805217810ULL, 0x000fe40007ffe0ffULL, 0x000000060f0e7212ULL, 0x000fe400078e3cffULL,
0x0000001c05237810ULL, 0x040fe40007ffe0ffULL, 0x00000014051e7810ULL, 0x000fc40007ffe0ffULL,
0x0000001005117810ULL, 0x000fe40007ffe0ffULL, 0x000000060b037212ULL, 0x080fe200078e3cffULL,
0x000000081e207824ULL, 0x000fe200078e00ffULL, 0xfffffff813147812ULL, 0x000fe200078ee20aULL,
0x0000000821137824ULL, 0x000fe200078e00ffULL, 0xfffffff815187812ULL, 0x000fe200078ee20eULL,
0x0000000823157824ULL, 0x000fe200078e00ffULL, 0x00000006210a7212ULL, 0x080fe200078e3cffULL,
0x0000000811177824ULL, 0x000fe200078e00ffULL, 0x00000006230e7212ULL, 0x000fc400078e3cffULL,
0xfffffff810107812ULL, 0x000fe400078ee203ULL, 0x000000061e037212ULL, 0x080fe400078e3cffULL,
0x0000000611127212ULL, 0x000fe400078e3cffULL, 0x0000002005257810ULL, 0x000fe40007ffe0ffULL,
0xfffffff813227812ULL, 0x000fe200078ee20aULL, 0x0000000807137824ULL, 0x000fe200078e00ffULL,
0xfffffff815247812ULL, 0x000fe200078ee20eULL, 0x0000000262157824ULL, 0x000fe200078e0207ULL,
0x0000007f050a7812ULL, 0x000fc400078ec0ffULL, 0xfffffff820207812ULL, 0x000fe400078ee203ULL,
0xfffffff8171c7812ULL, 0x000fe200078ee212ULL, 0x0000000825177824ULL, 0x000fe200078e00ffULL,
0x0000004002037817ULL, 0x000fe20003800000ULL, 0x00000001090a7824ULL, 0x000fe200078e020aULL,
0x0000000625127212ULL, 0x000fe400078e3cffULL, 0x0001300015157811ULL, 0x000fe400078e70ffULL,
0x000000030500720cULL, 0x000fc40003f06070ULL, 0x0000007f0b0e7812ULL, 0x040fe200078ec0ffULL,
0x0000001010197824ULL, 0x100fe200078e0215ULL, 0x000000030b00720cULL, 0x000fe20003f26070ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0027ULL, 0xfffffff817267812ULL, 0x000fe400078ee212ULL,
0xfffffff813027812ULL, 0x000fe200078ee206ULL, 0x000000100c177824ULL, 0x000fe200078e0215ULL,
0x0000007f0d127812ULL, 0x000fe200078ec0ffULL, 0x00000001090c7824ULL, 0x000fe200078e020eULL,
0x0000007f0f167812ULL, 0x000fe200078ec0ffULL, 0x00000010020a7825ULL, 0x000fe200078e000aULL,
0x000000030d00720cULL, 0x000fc40003f46070ULL, 0x000000031100720cULL, 0x080fe20003f86070ULL,
0x00000001090e7824ULL, 0x000fe200078e0212ULL, 0x0000007f111a7812ULL, 0x000fe200078ec0ffULL,
0x0000000109117824ULL, 0x000fe200078e0216ULL, 0x000000030f00720cULL, 0x000fe20003f66070ULL,
0x00005e000c0c7625ULL, 0x000fe200078e0027ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a177faeULL, 0x0003e2000c101c46ULL, 0x000000031e00720cULL, 0x000fe40003f06070ULL,
0x00005e000e0e7625ULL, 0x000fe200078e0027ULL, 0x0000007f1e1e7812ULL, 0x000fc400078ec0ffULL,
0x00000015181d7211ULL, 0x000fe200078e20ffULL, 0x00005e0011107625ULL, 0x000fe200078e0027ULL,
0x0000007f23167812ULL, 0x000fe400078ec0ffULL, 0x0000007f25187812ULL, 0x000fe200078ec0ffULL,
0x0000000109127824ULL, 0x000fe400078e021aULL, 0x00000010141b7824ULL, 0x000fe200078e0215ULL,
0x0000007f21147812ULL, 0x000fe200078ec0ffULL, 0x00000010020c7825ULL, 0x000fc800078e000cULL,
0x00005e0012127625ULL, 0x000fe200078e0027ULL, 0x000000000c197faeULL, 0x0005e2000c901c46ULL,
0x000000032100720cULL, 0x000fe40003f26070ULL, 0x00000010020e7825ULL, 0x000fc800078e000eULL,
0x0000001002107825ULL, 0x000fe200078e0010ULL, 0x000000000e1b7faeULL, 0x0007e2000d101c46ULL,
0x000000032300720cULL, 0x080fe40003f46070ULL, 0x00000001090a7824ULL, 0x042fe200078e021eULL,
0x00000000101d7faeULL, 0x0003e2000d901c46ULL, 0x00000001090c7824ULL, 0x004fe200078e0214ULL,
0x000000032500720cULL, 0x000fe20003f66070ULL, 0x000000101c1f7824ULL, 0x000fe200078e0215ULL,
0x0000002805147810ULL, 0x040fe20007ffe0ffULL, 0x0000001002127825ULL, 0x000fe200078e0012ULL,
0x00000034051c7810ULL, 0x000fc40007ffe0ffULL, 0x00000015261b7211ULL, 0x008fe200078e20ffULL,
0x00000001090e7824ULL, 0x000fe200078e0216ULL, 0x00000000121f7faeULL, 0x0005e2000e101c46ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0027ULL, 0x0000002c05167810ULL, 0x000fe40007ffe0ffULL,
0x000000031c00720cULL, 0x000fe20003f86070ULL, 0x0000000109107824ULL, 0x002fe200078e0218ULL,
0x0000003005187810ULL, 0x000fe20007ffe0ffULL, 0x00005e000c0c7625ULL, 0x000fc800078e0027ULL,
0x00005e000e0e7625ULL, 0x000fe200078e0027ULL, 0x0000002405127810ULL, 0x004fc60007ffe0ffULL,
0x00005e0010107625ULL, 0x000fc800078e0027ULL, 0x0000001020137824ULL, 0x000fe400078e0215ULL,
0x00000010020a7825ULL, 0x000fc800078e000aULL, 0x0000001022177824ULL, 0x000fe200078e0215ULL,
0x000000000a137faeULL, 0x0003e2000c101c46ULL, 0x00000010020c7825ULL, 0x000fe200078e000cULL,
0x000000031200720cULL, 0x000fc60003f06070ULL, 0x0000001024197824ULL, 0x000fe200078e0215ULL,
0x000000000c177faeULL, 0x0005e2000c901c46ULL, 0x00000010020e7825ULL, 0x000fe200078e000eULL,
0x000000031400720cULL, 0x000fc60003f26070ULL, 0x0000001002107825ULL, 0x000fe200078e0010ULL,
0x00000038050b7810ULL, 0x042fe20007ffe0ffULL, 0x000000000e197faeULL, 0x0003e2000d101c46ULL,
0x0000003c05137810ULL, 0x000fe20007ffe0ffULL, 0x00000008181a7824ULL, 0x000fe200078e00ffULL,
0x00000006140a7212ULL, 0x0c0fe200078e3cffULL, 0x00000000101b7faeULL, 0x0007e2000d901c46ULL,
0x00000008140d7824ULL, 0x004fe200078e00ffULL, 0x0000000612057212ULL, 0x040fe200078e3cffULL,
0x00000008120c7824ULL, 0x000fe200078e00ffULL, 0x000000031600720cULL, 0x080fe20003f46070ULL,
0x000000080b227824ULL, 0x000fe200078e00ffULL, 0x000000031800720cULL, 0x080fe20003f66070ULL,
0x0000000813267824ULL, 0x000fe200078e00ffULL, 0x000000030b00720cULL, 0x080fe20003fa6070ULL,
0x000000081c0f7824ULL, 0x002fe200078e00ffULL, 0x000000031300720cULL, 0x000fe20003fc6070ULL,
0x0000000816107824ULL, 0x008fe200078e00ffULL, 0xfffffff80d0e7812ULL, 0x000fc400078ee20aULL,
0x0000000616037212ULL, 0x080fe400078e3cffULL, 0xfffffff80c0c7812ULL, 0x000fe400078ee205ULL,
0x000000061c0a7212ULL, 0x080fe400078e3cffULL, 0x000000060b0d7212ULL, 0x080fe400078e3cffULL,
0x0000007f12127812ULL, 0x000fe400078ec0ffULL, 0x0000000618057212ULL, 0x000fc400078e3cffULL,
0x0000007f14147812ULL, 0x000fe400078ec0ffULL, 0x0000007f16167812ULL, 0x000fe400078ec0ffULL,
0x0000007f18187812ULL, 0x000fe400078ec0ffULL, 0xfffffff810107812ULL, 0x000fe400078ee203ULL,
0xfffffff80f1e7812ULL, 0x000fe200078ee20aULL, 0x00000001090a7824ULL, 0x040fe200078e0212ULL,
0xfffffff822227812ULL, 0x000fe200078ee20dULL, 0x00000001090f7824ULL, 0x040fe200078e0216ULL,
0x0000007f1c1c7812ULL, 0x000fe200078ec0ffULL, 0x0000000109117824ULL, 0x000fe200078e0218ULL,
0x0000000613037212ULL, 0x000fe200078e3cffULL, 0x000000101e1b7824ULL, 0x000fe200078e0215ULL,
0x0000007f0b207812ULL, 0x000fe200078ec0ffULL, 0x0000000109127824ULL, 0x000fe200078e021cULL,
0x0000007f13247812ULL, 0x000fe200078ec0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0027ULL,
0x00000014090d7210ULL, 0x000fc40007ffe0ffULL, 0xfffffff826187812ULL, 0x000fe200078ee203ULL,
0x000000100c037824ULL, 0x000fe200078e0215ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee205ULL,
0x0000000109147824ULL, 0x040fe400078e0220ULL, 0x0000000109167824ULL, 0x000fe200078e0224ULL,
0x000000151a197211ULL, 0x000fe200078e20ffULL, 0x000000100e057824ULL, 0x000fe400078e0215ULL,
0x00005e000d0c7625ULL, 0x000fc800078e0027ULL, 0x0000001010097824ULL, 0x000fe400078e0215ULL,
0x00005e000f0e7625ULL, 0x000fc800078e0027ULL, 0x00005e0011107625ULL, 0x000fc800078e0027ULL,
0x00000010221d7824ULL, 0x100fe400078e0215ULL, 0x00000010181f7824ULL, 0x000fe400078e0215ULL,
0x00005e0012127625ULL, 0x000fc800078e0027ULL, 0x00005e0014147625ULL, 0x000fc800078e0027ULL,
0x00005e0016167625ULL, 0x000fc800078e0027ULL, 0x00000010020a7825ULL, 0x000fc800078e000aULL,
0x00000010020c7825ULL, 0x040fe200078e000cULL, 0x000000000a037faeULL, 0x0003e6000c101c46ULL,
0x00000010020e7825ULL, 0x040fe200078e000eULL, 0x000000000c057faeULL, 0x0003e6000c901c46ULL,
0x0000001002107825ULL, 0x040fe200078e0010ULL, 0x000000000e097faeULL, 0x0003e6000d101c46ULL,
0x0000001002127825ULL, 0x040fe200078e0012ULL, 0x0000000010197faeULL, 0x0003e6000d901c46ULL,
0x0000001002147825ULL, 0x040fe200078e0014ULL, 0x00000000121b7faeULL, 0x0003e6000e101c46ULL,
0x0000001002167825ULL, 0x000fe200078e0016ULL, 0x00000000141d7faeULL, 0x0003e8000e901c46ULL,
0x00000000161f7faeULL, 0x0003e2000f101c46ULL, 0x00000aa000007947ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x002e620000000000ULL, 0x0000000409097c24ULL, 0x020fe2000f8e020cULL,
0x00000003ff037819ULL, 0x002fc40000011606ULL, 0x0ffffff806057812ULL, 0x000fe400078ec0ffULL,
0x00000008030f7810ULL, 0x040fe40007ffe0ffULL, 0x0000000603027212ULL, 0x080fe400078e3cffULL,
0x000000060f107212ULL, 0x040fe200078e3cffULL, 0x000000080f117824ULL, 0x000fe200078e00ffULL,
0x00000007050a7812ULL, 0x000fe400078ef802ULL, 0x0000001803177810ULL, 0x000fc40007ffe0ffULL,
0xfffffff811127812ULL, 0x000fe400078ee210ULL, 0x0000000c03117810ULL, 0x040fe40007ffe0ffULL,
0x00000004030d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000611027212ULL, 0x040fe200078e3cffULL,
0x0000000811197824ULL, 0x000fe200078e00ffULL, 0x00000028031f7810ULL, 0x000fe20007ffe0ffULL,
0x000000080d0e7824ULL, 0x000fe200078e00ffULL, 0x0000001003137810ULL, 0x000fc40007ffe0ffULL,
0xfffffff819167812ULL, 0x000fe200078ee202ULL, 0x000000081f237824ULL, 0x000fe200078e00ffULL,
0x0000001c03197810ULL, 0x000fe20007ffe0ffULL, 0x00000008131a7824ULL, 0x000fe200078e00ffULL,
0x00000006170c7212ULL, 0x080fe400078e3cffULL, 0x0000000619027212ULL, 0x040fe200078e3cffULL,
0x0000000819217824ULL, 0x000fe200078e00ffULL, 0x00000003171b7819ULL, 0x000fe400000006ffULL,
0x0000001403157810ULL, 0x000fc40007ffe0ffULL, 0xfffffff821267812ULL, 0x000fe400078ee202ULL,
0x0000002c03217810ULL, 0x000fe20007ffe0ffULL, 0x00000008151e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81b227812ULL, 0x000fe400078ee20cULL, 0x000000060d0b7212ULL, 0x080fe200078e3cffULL,
0x0000000821257824ULL, 0x000fe200078e00ffULL, 0x00000020031b7810ULL, 0x000fe40007ffe0ffULL,
0x000000061f0c7212ULL, 0x000fc400078e3cffULL, 0x0000000613057212ULL, 0x080fe200078e3cffULL,
0x000000081b2a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe400078ee20bULL,
0x00000024031d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823327812ULL, 0x000fe400078ee20cULL,
0x0000003803297810ULL, 0x000fe20007ffe0ffULL, 0x000000081d2e7824ULL, 0x000fe200078e00ffULL,
0x0000000621027212ULL, 0x000fc400078e3cffULL, 0x00000006150b7212ULL, 0x080fe200078e3cffULL,
0x00000008292b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe400078ee205ULL,
0x0000003003237810ULL, 0x000fe40007ffe0ffULL, 0x000000061b057212ULL, 0x000fe400078e3cffULL,
0xfffffff825367812ULL, 0x000fe200078ee202ULL, 0x00000008233a7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20bULL, 0x00000100ff257424ULL, 0x000fe200078e00ffULL,
0x0000003403277810ULL, 0x000fc40007ffe0ffULL, 0x0000007f03027812ULL, 0x000fe400078ec0ffULL,
0x000000061d0b7212ULL, 0x080fe200078e3cffULL, 0x00000008273e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee205ULL, 0x0000000109027824ULL, 0x000fe200078e0202ULL,
0x00000006290c7212ULL, 0x080fe400078e3cffULL, 0x0000003c03037810ULL, 0x000fe40007ffe0ffULL,
0x0000000623057212ULL, 0x000fc400078e3cffULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee20bULL,
0x0000000803467824ULL, 0x000fe200078e00ffULL, 0xfffffff82b427812ULL, 0x000fe200078ee20cULL,
0x00000008072b7824ULL, 0x000fe200078e00ffULL, 0x00000006270b7212ULL, 0x000fe400078e3cffULL,
0xfffffff83a3a7812ULL, 0x000fe400078ee205ULL, 0x0000007f0d0c7812ULL, 0x000fe400078ec0ffULL,
0x0000000762057211ULL, 0x000fc400078e08ffULL, 0x00000006030d7212ULL, 0x000fe200078e3cffULL,
0x00000001090c7824ULL, 0x000fe200078e020cULL, 0x0000007f0f107812ULL, 0x000fe400078ec0ffULL,
0xfffffff83e3e7812ULL, 0x000fe400078ee20bULL, 0x0000007f11147812ULL, 0x000fe200078ec0ffULL,
0x0000000109107824ULL, 0x000fe200078e0210ULL, 0x0000007f151c7812ULL, 0x000fe400078ec0ffULL,
0x0000007f17207812ULL, 0x000fe200078ec0ffULL, 0x0000000109147824ULL, 0x000fe200078e0214ULL,
0x0000007f19247812ULL, 0x000fe200078ec0ffULL, 0x00000001091c7824ULL, 0x000fe200078e021cULL,
0x0000007f1b287812ULL, 0x000fe200078ec0ffULL, 0x0000000109207824ULL, 0x000fe200078e0220ULL,
0x0000007f1d2c7812ULL, 0x000fe200078ec0ffULL, 0x0000000109247824ULL, 0x000fe200078e0224ULL,
0x0000007f1f307812ULL, 0x000fe200078ec0ffULL, 0x0000000109287824ULL, 0x000fe200078e0228ULL,
0x0000007f21347812ULL, 0x000fe200078ec0ffULL, 0x00000001092c7824ULL, 0x000fe200078e022cULL,
0x0000007f273c7812ULL, 0x000fe200078ec0ffULL, 0x0000000109307824ULL, 0x000fe200078e0230ULL,
0x0000007f29407812ULL, 0x000fe200078ec0ffULL, 0x0000000109347824ULL, 0x000fe200078e0234ULL,
0x0000007f03447812ULL, 0x000fe200078ec0ffULL, 0x00005e0002027625ULL, 0x000fe200078e0025ULL,
0x00013000050b7811ULL, 0x000fc400078e70ffULL, 0x0000007f13187812ULL, 0x000fe200078ec0ffULL,
0x00000001093c7824ULL, 0x000fe200078e023cULL, 0x0000007f23387812ULL, 0x000fe200078ec0ffULL,
0x0000000109407824ULL, 0x040fe200078e0240ULL, 0xfffffff846467812ULL, 0x000fe200078ee20dULL,
0x0000000109447824ULL, 0x000fe200078e0244ULL, 0xfffffff82b057812ULL, 0x000fe200078ee206ULL,
0x000000100e277824ULL, 0x100fe200078e020bULL, 0x0000001809187210ULL, 0x040fe20007ffe0ffULL,
0x0000001012297824ULL, 0x100fe200078e020bULL, 0x0000003809387210ULL, 0x000fe20007ffe0ffULL,
0x000000100a097824ULL, 0x100fe200078e020bULL, 0x0000000b1a2d7211ULL, 0x080fe200078e20ffULL,
0x00000010162b7824ULL, 0x100fe200078e020bULL, 0x0000000b3a3d7211ULL, 0x000fe200078e20ffULL,
0x000000101e2f7824ULL, 0x000fc400078e020bULL, 0x0000001022317824ULL, 0x100fe400078e020bULL,
0x0000001026337824ULL, 0x100fe400078e020bULL, 0x000000102a357824ULL, 0x100fe400078e020bULL,
0x000000102e377824ULL, 0x100fe400078e020bULL, 0x0000001032397824ULL, 0x100fe400078e020bULL,
0x00000010363b7824ULL, 0x000fc400078e020bULL, 0x000000103e3f7824ULL, 0x100fe400078e020bULL,
0x0000001042417824ULL, 0x100fe400078e020bULL, 0x0000001046437824ULL, 0x000fe400078e020bULL,
0x00005e000c0a7625ULL, 0x000fc800078e0025ULL, 0x00005e00100c7625ULL, 0x000fc800078e0025ULL,
0x00005e00140e7625ULL, 0x000fc800078e0025ULL, 0x00005e0018107625ULL, 0x000fc800078e0025ULL,
0x0000001005027825ULL, 0x000fc800078e0002ULL, 0x00005e001c127625ULL, 0x080fe200078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e6000b901c46ULL,
0x00005e0020147625ULL, 0x000fc800078e0025ULL, 0x00005e0024167625ULL, 0x000fc800078e0025ULL,
0x00000010050a7825ULL, 0x000fc800078e000aULL, 0x00005e0028187625ULL, 0x000fe200078e0025ULL,
0x000000000a277faeULL, 0x0005e6000b901c46ULL, 0x00000010050c7825ULL, 0x000fc800078e000cULL,
0x00005e002c1a7625ULL, 0x000fe200078e0025ULL, 0x000000000c297faeULL, 0x0005e6000b901c46ULL,
0x00000010050e7825ULL, 0x000fc800078e000eULL, 0x00005e00301c7625ULL, 0x000fe200078e0025ULL,
0x000000000e2b7faeULL, 0x0005e6000b901c46ULL, 0x0000001005107825ULL, 0x000fc800078e0010ULL,
0x00005e0034027625ULL, 0x002fe200078e0025ULL, 0x00000000102d7faeULL, 0x0005e6000b901c46ULL,
0x0000001005127825ULL, 0x000fc800078e0012ULL, 0x00005e00381e7625ULL, 0x000fe200078e0025ULL,
0x00000000122f7faeULL, 0x0005e6000b901c46ULL, 0x0000001005147825ULL, 0x000fc800078e0014ULL,
0x00005e003c207625ULL, 0x000fe200078e0025ULL, 0x0000000014317faeULL, 0x0005e6000b901c46ULL,
0x0000001005167825ULL, 0x000fc800078e0016ULL, 0x00005e0040227625ULL, 0x000fe200078e0025ULL,
0x0000000016337faeULL, 0x0005e6000b901c46ULL, 0x0000001005187825ULL, 0x000fc800078e0018ULL,
0x00005e0044247625ULL, 0x000fe200078e0025ULL, 0x0000000018357faeULL, 0x0005e6000b901c46ULL,
0x00000010051a7825ULL, 0x000fc800078e001aULL, 0x00000010051c7825ULL, 0x040fe200078e001cULL,
0x000000001a377faeULL, 0x0005e6000b901c46ULL, 0x0000001005027825ULL, 0x040fe200078e0002ULL,
0x000000001c397faeULL, 0x0005e6000b901c46ULL, 0x00000010051e7825ULL, 0x040fe200078e001eULL,
0x00000000023b7faeULL, 0x0005e6000b901c46ULL, 0x0000001005207825ULL, 0x040fe200078e0020ULL,
0x000000001e3d7faeULL, 0x0005e6000b901c46ULL, 0x0000001005227825ULL, 0x040fe200078e0022ULL,
0x00000000203f7faeULL, 0x0005e6000b901c46ULL, 0x0000001005247825ULL, 0x000fe200078e0024ULL,
0x0000000022417faeULL, 0x0005e8000b901c46ULL, 0x0000000024437faeULL, 0x0005e4000b901c46ULL,
0x00000300ff057624ULL, 0x002fe200078e00ffULL, 0x0000000104027812ULL, 0x004fe200078ec0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000010200780cULL, 0x000fc40003f05070ULL,
0xffffffff05057811ULL, 0x000fc800078e08ffULL, 0x0000000105037807ULL, 0x000fca0004000000ULL,
0x0000000104047824ULL, 0x000fca00078e0203ULL, 0x0000008d0400720cULL, 0x000fda0003f06070ULL,
0x0000000289028824ULL, 0x000fe400078e00ffULL, 0x00006400ff038624ULL, 0x000fc800078e00ffULL,
0x0000640002038624ULL, 0x000fca00078e0203ULL, 0x00000004030b8210ULL, 0x000fe20007ffe0ffULL,
0xffffffffff037424ULL, 0x000fc800078e00ffULL, 0x000060000b0a8625ULL, 0x000fca00078e0000ULL,
0x000000060a038981ULL, 0x000362000c1e1900ULL, 0x0000008b9000720cULL, 0x000fe20003f06070ULL,
0xff317217ff027424ULL, 0x000fe200078e00ffULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x00004e2000000947ULL, 0x000fea0003800000ULL, 0x00000002890b7824ULL, 0x002fe200078e00ffULL,
0x000000ff006e7202ULL, 0x000fe20000000f00ULL, 0x00006400ff0a7624ULL, 0x000fc400078e00ffULL,
0x0000001062097824ULL, 0x000fe400078e00ffULL, 0x000064000b0b7624ULL, 0x000fe200078e020aULL,
0x00007610ff0a7816ULL, 0x000fe2000000000aULL, 0xff317217ff027424ULL, 0x000fe400078e00ffULL,
0x000000ffff377224ULL, 0x000fe400078e00ffULL, 0x000000208e0c7824ULL, 0x000fca00078e00ffULL,
0xffffffc00c0f7812ULL, 0x000fca00078ec0ffULL, 0x00000100900e7824ULL, 0x000fca00078e020fULL,
0x0000008f0e00720cULL, 0x000fda0003f06070ULL, 0x00004cf000000947ULL, 0x000fea0003800000ULL,
0x00000001900c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000008b0c00720cULL, 0x000fe20003f06070ULL, 0x000000ffff0c7224ULL, 0x000fe200078e006eULL,
0x000000800e0f7810ULL, 0x000fe40007ffe0ffULL, 0x000000016e6e7812ULL, 0x000fe400078e0cffULL,
0x0000004008147812ULL, 0x000fce00078ef80fULL, 0x00000c2000008947ULL, 0x000fea0003800000ULL,
0x00000003ff177819ULL, 0x000fe20000011606ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000f8f0e7217ULL, 0x000fe20007800000ULL, 0x0000000704047899ULL, 0x000fe2000800063fULL,
0x0000000c173f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000807117824ULL, 0x000fe200078e00ffULL,
0x00000004173b7810ULL, 0x040fe20007ffe0ffULL, 0x000000010e127824ULL, 0x000fe200078e0a0fULL,
0x00000008173d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000403157c24ULL, 0x020fe2000f8e0214ULL,
0x00000014174d7810ULL, 0x000fe20007ffe0ffULL, 0x000000083f167824ULL, 0x000fe200078e00ffULL,
0x000000063d0e7212ULL, 0x080fe200078e3cffULL, 0x000000083b147824ULL, 0x000fe200078e00ffULL,
0x000000033d457819ULL, 0x000fe200000006ffULL, 0x000000084d4f7824ULL, 0x000fe200078e00ffULL,
0x000000063f0f7212ULL, 0x000fe200078e3cffULL, 0x000040008e137824ULL, 0x000fe200078e00ffULL,
0x0000001817517810ULL, 0x000fc40007ffe0ffULL, 0x000000063b037212ULL, 0x080fe400078e3cffULL,
0x0000001017497810ULL, 0x000fe40007ffe0ffULL, 0xfffffff845457812ULL, 0x000fe400078ee20eULL,
0xfffffff816477812ULL, 0x000fe200078ee20fULL, 0x0000000851167824ULL, 0x000fe200078e00ffULL,
0x0000002017617810ULL, 0x000fe40007ffe0ffULL, 0xfffffff814437812ULL, 0x000fe200078ee203ULL,
0x0000000849147824ULL, 0x000fe200078e00ffULL, 0x000000064d0e7212ULL, 0x080fe200078e3cffULL,
0x0000000861637824ULL, 0x000fe200078e00ffULL, 0x00000006510f7212ULL, 0x000fc400078e3cffULL,
0x0000002417197810ULL, 0x000fe40007ffe0ffULL, 0x0000000706107812ULL, 0x000fe400078ec0ffULL,
0x0000000649037212ULL, 0x000fe400078e3cffULL, 0x0000001c175d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff84f4f7812ULL, 0x000fe400078ee20eULL, 0x0000002c171f7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff816537812ULL, 0x000fe200078ee20fULL, 0x0000000819167824ULL, 0x000fe200078e00ffULL,
0x00000006610e7212ULL, 0x080fe200078e3cffULL, 0x000000081f397824ULL, 0x000fe200078e00ffULL,
0x0000000811107812ULL, 0x000fe400078ee210ULL, 0xfffffff8144b7812ULL, 0x000fe200078ee203ULL,
0x000000085d147824ULL, 0x000fe200078e00ffULL, 0x0000000619117212ULL, 0x000fe400078e3cffULL,
0x00000030171b7810ULL, 0x000fc40007ffe0ffULL, 0x000000065d037212ULL, 0x080fe400078e3cffULL,
0xfffffff863637812ULL, 0x000fe400078ee20eULL, 0x000000061f0e7212ULL, 0x000fe400078e3cffULL,
0x00000028171d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff816117812ULL, 0x000fe200078ee211ULL,
0x000000081b167824ULL, 0x000fe200078e00ffULL, 0x0000400013137812ULL, 0x000fc400078ec0ffULL,
0xfffffff8145f7812ULL, 0x000fe400078ee203ULL, 0x000000061b037212ULL, 0x080fe200078e3cffULL,
0x0000800062137824ULL, 0x000fe200078e0213ULL, 0xfffffff8390e7812ULL, 0x000fe400078ee20eULL,
0x000000061d0f7212ULL, 0x040fe400078e3cffULL, 0x000000031d147819ULL, 0x000fe400000006ffULL,
0x0000000717397812ULL, 0x000fc400078e4806ULL, 0x0000007f17187812ULL, 0x000fe400078ec0ffULL,
0xfffffff816037812ULL, 0x000fe400078ee203ULL, 0x0000004012167817ULL, 0x000fe20003800000ULL,
0x000020006e127824ULL, 0x000fe200078e0213ULL, 0xfffffff8140f7812ULL, 0x000fe200078ee20fULL,
0x00000100ff147424ULL, 0x000fe200078e00ffULL, 0x0ffffff839417812ULL, 0x000fe200078ef806ULL,
0x0000000118397824ULL, 0x000fe200078e0215ULL, 0x0000007f3b1a7812ULL, 0x000fc400078ec0ffULL,
0x000000161700720cULL, 0x000fe20003f06070ULL, 0x00005e0039387625ULL, 0x000fe200078e0014ULL,
0x0000007f3d1c7812ULL, 0x000fe400078ec0ffULL, 0x0000007f3f187812ULL, 0x000fe400078ec0ffULL,
0x0001300012127810ULL, 0x000fe20007ffe0ffULL, 0x0000001010387825ULL, 0x000fe200078e0038ULL,
0x000000163b00720cULL, 0x080fe40003f26070ULL, 0x000000163d00720cULL, 0x080fe20003f46070ULL,
0x000000011a3b7824ULL, 0x100fe200078e0215ULL, 0x000000163f00720cULL, 0x000fe20003f66070ULL,
0x000000011c3d7824ULL, 0x100fe200078e0215ULL, 0x0000003417657810ULL, 0x000fe20007ffe0ffULL,
0x00000001183f7824ULL, 0x000fe200078e0215ULL, 0x0000007f49187812ULL, 0x000fe200078ec0ffULL,
0x0000001041417824ULL, 0x000fe200078e0212ULL, 0x0000000665137212ULL, 0x000fe200078e3cffULL,
0x00005e003b3a7625ULL, 0x000fe200078e0014ULL, 0x00000003651e7819ULL, 0x000fc400000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038417faeULL, 0x0003e2000c101c46ULL,
0x00005e003d3c7625ULL, 0x000fe200078e0014ULL, 0x000000164900720cULL, 0x000fe40003f06070ULL,
0x0000007f511a7812ULL, 0x000fe200078ec0ffULL, 0x00005e003f3e7625ULL, 0x000fe200078e0014ULL,
0xfffffff81e137812ULL, 0x000fe400078ee213ULL, 0x0000007f5d1c7812ULL, 0x000fe200078ec0ffULL,
0x0000001043437824ULL, 0x000fe200078e0212ULL, 0x0000007f611e7812ULL, 0x000fe200078ec0ffULL,
0x00000010103a7825ULL, 0x000fe200078e003aULL, 0x0000001518397210ULL, 0x002fc40007ffe0ffULL,
0x0000007f4d187812ULL, 0x000fe200078ec0ffULL, 0x0000001045457824ULL, 0x000fe200078e0212ULL,
0x000000003a437faeULL, 0x0003e2000c901c46ULL, 0x00000010103c7825ULL, 0x040fe200078e003cULL,
0x000000164d00720cULL, 0x080fe40003f26070ULL, 0x000000166100720cULL, 0x080fe20003f86070ULL,
0x0000001047477824ULL, 0x000fe200078e0212ULL, 0x000000003c457faeULL, 0x0005e2000d101c46ULL,
0x00000010103e7825ULL, 0x000fe200078e003eULL, 0x000000165100720cULL, 0x000fc40003f46070ULL,
0x000000125f497211ULL, 0x000fe200078e20ffULL, 0x00005e0039387625ULL, 0x000fe200078e0014ULL,
0x000000003e477faeULL, 0x0007e2000d901c46ULL, 0x000000165d00720cULL, 0x000fe40003f66070ULL,
0x00000001183b7824ULL, 0x102fe400078e0215ULL, 0x000000011e417824ULL, 0x100fe200078e0215ULL,
0x0000007f651e7812ULL, 0x000fe200078ec0ffULL, 0x000000011a3d7824ULL, 0x004fe200078e0215ULL,
0x0000007f1f1a7812ULL, 0x000fe200078ec0ffULL, 0x000000104b437824ULL, 0x000fc400078e0212ULL,
0x0000001010387825ULL, 0x000fc800078e0038ULL, 0x000000011c3f7824ULL, 0x008fe200078e0215ULL,
0x0000000038437faeULL, 0x0003e2000c101c46ULL, 0x00005e003b3a7625ULL, 0x000fe200078e0014ULL,
0x000000161900720cULL, 0x000fe40003f06070ULL, 0x0000007f1b1c7812ULL, 0x000fe200078ec0ffULL,
0x00005e003d3c7625ULL, 0x000fc800078e0014ULL, 0x00005e003f3e7625ULL, 0x000fe200078e0014ULL,
0x0000003817397810ULL, 0x002fc60007ffe0ffULL, 0x00005e0041407625ULL, 0x000fe200078e0014ULL,
0x0000003c17437810ULL, 0x000fe40007ffe0ffULL, 0x0000000639177212ULL, 0x000fe200078e3cffULL,
0x000000104f457824ULL, 0x000fe200078e0212ULL, 0x000000163900720cULL, 0x080fe20003fa6070ULL,
0x00000010103a7825ULL, 0x040fe200078e003aULL, 0x000000164300720cULL, 0x080fe40003fc6070ULL,
0x0000007f39387812ULL, 0x000fe200078ec0ffULL, 0x0000001053477824ULL, 0x000fe200078e0212ULL,
0x000000003a457faeULL, 0x0003e2000c901c46ULL, 0x00000010103c7825ULL, 0x000fe200078e003cULL,
0x000000161d00720cULL, 0x000fc60003f26070ULL, 0x00000010103e7825ULL, 0x040fe200078e003eULL,
0x000000003c477faeULL, 0x0005e2000d101c46ULL, 0x000000161f00720cULL, 0x080fe40003f46070ULL,
0x00000010634b7824ULL, 0x000fe200078e0212ULL, 0x000000003e497faeULL, 0x0007e2000d901c46ULL,
0x0000001010407825ULL, 0x000fe200078e0040ULL, 0x000000161b00720cULL, 0x080fe40003f66070ULL,
0x0000007f433a7812ULL, 0x002fe200078ec0ffULL, 0x0000000839187824ULL, 0x000fe200078e00ffULL,
0x00000000404b7faeULL, 0x0003e2000e101c46ULL, 0x000000166500720cULL, 0x000fe20003f86070ULL,
0x000000011a1b7824ULL, 0x100fe200078e0215ULL, 0x0000007f19167812ULL, 0x000fe200078ec0ffULL,
0x0000000138397824ULL, 0x000fe200078e0215ULL, 0xfffffff8183d7812ULL, 0x004fe200078ee217ULL,
0x00000008433c7824ULL, 0x000fe200078e00ffULL, 0x0000007f1d187812ULL, 0x000fe200078ec0ffULL,
0x0000000116177824ULL, 0x100fe200078e0215ULL, 0x000000151e1f7210ULL, 0x000fe20007ffe0ffULL,
0x000000011c1d7824ULL, 0x100fe200078e0215ULL, 0x00000006433b7212ULL, 0x000fe200078e3cffULL,
0x0000000118197824ULL, 0x000fe200078e0215ULL, 0x000000123d3d7211ULL, 0x000fe200078e20ffULL,
0x00005e0017167625ULL, 0x000fe200078e0014ULL, 0xfffffff83c3f7812ULL, 0x008fc600078ee23bULL,
0x00005e0019187625ULL, 0x000fc800078e0014ULL, 0x000000013a157824ULL, 0x000fe400078e0215ULL,
0x00005e001b1a7625ULL, 0x000fc800078e0014ULL, 0x00005e001d1c7625ULL, 0x000fc800078e0014ULL,
0x00005e001f1e7625ULL, 0x000fc800078e0014ULL, 0x00005e0039387625ULL, 0x000fc800078e0014ULL,
0x00005e0015147625ULL, 0x000fc800078e0014ULL, 0x0000001010167825ULL, 0x000fc800078e0016ULL,
0x0000001011117824ULL, 0x000fe400078e0212ULL, 0x0000001010187825ULL, 0x000fc600078e0018ULL,
0x0000000016117faeULL, 0x0003e2000c101c46ULL, 0x000000100f0f7824ULL, 0x000fe400078e0212ULL,
0x00000010101a7825ULL, 0x000fc600078e001aULL, 0x00000000180f7faeULL, 0x0003e2000c901c46ULL,
0x000000100e3b7824ULL, 0x000fe400078e0212ULL, 0x00000010101c7825ULL, 0x000fc600078e001cULL,
0x000000001a3b7faeULL, 0x0003e2000d101c46ULL, 0x0000001003037824ULL, 0x000fe400078e0212ULL,
0x00000010101e7825ULL, 0x000fc600078e001eULL, 0x000000001c037faeULL, 0x0003e2000d901c46ULL,
0x0000001013137824ULL, 0x000fe400078e0212ULL, 0x0000001010387825ULL, 0x000fc600078e0038ULL,
0x000000001e137faeULL, 0x0003e2000e101c46ULL, 0x0000001010147825ULL, 0x000fc600078e0014ULL,
0x00000000383d7faeULL, 0x0003e2000e901c46ULL, 0x000000103f3f7824ULL, 0x000fca00078e0212ULL,
0x00000000143f7faeULL, 0x0003e2000f101c46ULL, 0x00000ae000007947ULL, 0x000fea0003800000ULL,
0x00000003ff0f7819ULL, 0x000fe20000011606ULL, 0x00000008070e7824ULL, 0x000fe200078e00ffULL,
0x0000000706497812ULL, 0x000fe200078ec0ffULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x000000080f197810ULL, 0x000fe20007ffe0ffULL, 0x0000000704047899ULL, 0x000fe2000800063fULL,
0x000000080e497812ULL, 0x000fe400078ee249ULL, 0x0000000619477212ULL, 0x040fe200078e3cffULL,
0x00000008190e7824ULL, 0x000fe200078e00ffULL, 0x000000100f1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000403147c24ULL, 0x020fe2000f8e0214ULL, 0x000000040f177810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80e477812ULL, 0x000fe200078ee247ULL, 0x000000081d0e7824ULL, 0x040fe200078e00ffULL,
0x000000061d457212ULL, 0x080fe200078e3cffULL, 0x0000000817117824ULL, 0x000fe200078e00ffULL,
0x000000180f397810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80e457812ULL, 0x000fe400078ee245ULL,
0x0000000639437212ULL, 0x040fe400078e3cffULL, 0x00000003390e7819ULL, 0x000fc400000006ffULL,
0x000000280f4f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000617487212ULL, 0x080fe400078e3cffULL,
0x000000140f1f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80e437812ULL, 0x000fe200078ee243ULL,
0x000000084f0e7824ULL, 0x000fe200078e00ffULL, 0x0000000c0f1b7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff811487812ULL, 0x000fe200078ee248ULL, 0x000000081f117824ULL, 0x000fe200078e00ffULL,
0x000000064f3f7212ULL, 0x000fe200078e3cffULL, 0x000000081b037824ULL, 0x000fe200078e00ffULL,
0x000000300f537810ULL, 0x000fc40007ffe0ffULL, 0x000000061f447212ULL, 0x080fe400078e3cffULL,
0x0000002c0f517810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80e3f7812ULL, 0x000fe200078ee23fULL,
0x00000008530e7824ULL, 0x000fe200078e00ffULL, 0x000000061b467212ULL, 0x080fe400078e3cffULL,
0x0000001c0f3b7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff811447812ULL, 0x000fe200078ee244ULL,
0x0000000851117824ULL, 0x000fe200078e00ffULL, 0x00000006533d7212ULL, 0x000fc400078e3cffULL,
0x00000006513e7212ULL, 0x080fe400078e3cffULL, 0x000000340f5d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff803467812ULL, 0x000fe200078ee246ULL, 0x000000083b037824ULL, 0x000fe200078e00ffULL,
0xfffffff80e3d7812ULL, 0x000fe200078ee23dULL, 0x000040008e0e7824ULL, 0x000fe200078e00ffULL,
0x000000200f4b7810ULL, 0x000fe40007ffe0ffULL, 0x000000063b427212ULL, 0x000fc400078e3cffULL,
0x000000240f4d7810ULL, 0x000fe20007ffe0ffULL, 0x000000084b107824ULL, 0x000fe200078e00ffULL,
0xfffffff8113e7812ULL, 0x000fe200078ee23eULL, 0x000000085d117824ULL, 0x040fe200078e00ffULL,
0x000000065d3c7212ULL, 0x080fe400078e3cffULL, 0xfffffff803427812ULL, 0x000fe200078ee242ULL,
0x000000084d037824ULL, 0x000fe200078e00ffULL, 0x000040000e157812ULL, 0x000fe400078ec0ffULL,
0x000000064b417212ULL, 0x000fc400078e3cffULL, 0x000000064d407212ULL, 0x000fe200078e3cffULL,
0x0000800062157824ULL, 0x000fe200078e0215ULL, 0x000000380f5f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8113c7812ULL, 0x000fe200078ee23cULL, 0x000020006e157824ULL, 0x000fe200078e0215ULL,
0x000000070f137812ULL, 0x040fe400078e4806ULL, 0x0000007f0f117812ULL, 0x040fe400078ec0ffULL,
0x0000003c0f0f7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff810417812ULL, 0x000fe200078ee241ULL,
0x0000000111117824ULL, 0x000fe200078e0214ULL, 0xfffffff803407812ULL, 0x000fe200078ee240ULL,
0x000000080f637824ULL, 0x000fe200078e00ffULL, 0x000000065f037212ULL, 0x040fe400078e3cffULL,
0x000000035f107819ULL, 0x000fe400000006ffULL, 0x0000007f5d5d7812ULL, 0x000fe400078ec0ffULL,
0x0000007f17177812ULL, 0x000fc400078ec0ffULL, 0x0000007f19197812ULL, 0x000fe400078ec0ffULL,
0x0000007f1b1b7812ULL, 0x000fe200078ec0ffULL, 0x0000000117177824ULL, 0x100fe200078e0214ULL,
0x0000007f1d1d7812ULL, 0x000fe400078ec0ffULL, 0x0000007f1f1f7812ULL, 0x000fe200078ec0ffULL,
0x000000011b1b7824ULL, 0x100fe200078e0214ULL, 0x0000007f39397812ULL, 0x000fe200078ec0ffULL,
0x000000011d1d7824ULL, 0x100fe200078e0214ULL, 0x0000007f3b3b7812ULL, 0x000fe200078ec0ffULL,
0x000000011f1f7824ULL, 0x100fe200078e0214ULL, 0x0000007f4b4b7812ULL, 0x000fe200078ec0ffULL,
0x0000000139397824ULL, 0x100fe200078e0214ULL, 0x0000007f4d4d7812ULL, 0x000fe200078ec0ffULL,
0x000000013b3b7824ULL, 0x100fe200078e0214ULL, 0x0000007f4f4f7812ULL, 0x000fe200078ec0ffULL,
0x000000014b4b7824ULL, 0x100fe200078e0214ULL, 0x0000007f51517812ULL, 0x000fe200078ec0ffULL,
0x000000014d4d7824ULL, 0x000fe200078e0214ULL, 0x0000007f53537812ULL, 0x000fc400078ec0ffULL,
0x0000007f5f5f7812ULL, 0x000fe200078ec0ffULL, 0x0000000151517824ULL, 0x100fe200078e0214ULL,
0x0000007f0f617812ULL, 0x000fe200078ec0ffULL, 0x0000000153537824ULL, 0x100fe200078e0214ULL,
0xfffffff810037812ULL, 0x000fe200078ee203ULL, 0x00000100ff107424ULL, 0x000fe200078e00ffULL,
0x000000060f5c7212ULL, 0x000fe200078e3cffULL, 0x000000015d0f7824ULL, 0x100fe200078e0214ULL,
0x0000001419197210ULL, 0x080fe20007ffe0ffULL, 0x000000015f5f7824ULL, 0x100fe200078e0214ULL,
0x000000144f4f7210ULL, 0x000fe20007ffe0ffULL, 0x0000000161617824ULL, 0x000fe200078e0214ULL,
0x00013000155e7810ULL, 0x000fe20007ffe0ffULL, 0x00005e000f147625ULL, 0x000fe200078e0010ULL,
0x0ffffff8135d7812ULL, 0x000fc400078ef806ULL, 0x0000005e47477211ULL, 0x000fe200078e20ffULL,
0x00005e0011127625ULL, 0x000fe200078e0010ULL, 0xfffffff8635c7812ULL, 0x000fe400078ee25cULL,
0x0000005e3f3f7211ULL, 0x000fe200078e20ffULL, 0x00005e0017167625ULL, 0x000fc800078e0010ULL,
0x00005e0019187625ULL, 0x000fc800078e0010ULL, 0x00005e001b1a7625ULL, 0x000fc800078e0010ULL,
0x00005e001d1c7625ULL, 0x000fc800078e0010ULL, 0x00005e001f1e7625ULL, 0x000fc800078e0010ULL,
0x00005e0039387625ULL, 0x000fc800078e0010ULL, 0x00005e003b3a7625ULL, 0x000fc800078e0010ULL,
0x00005e004b4a7625ULL, 0x000fc800078e0010ULL, 0x00005e004d4c7625ULL, 0x000fc800078e0010ULL,
0x00005e004f4e7625ULL, 0x000fc800078e0010ULL, 0x00005e0051507625ULL, 0x000fc800078e0010ULL,
0x00005e0053527625ULL, 0x000fc800078e0010ULL, 0x00005e005f0e7625ULL, 0x000fc800078e0010ULL,
0x00005e0061107625ULL, 0x000fc800078e0010ULL, 0x0000001049127825ULL, 0x000fc800078e0012ULL,
0x0000001049167825ULL, 0x000fc800078e0016ULL, 0x0000001049187825ULL, 0x000fc800078e0018ULL,
0x00000010491a7825ULL, 0x000fc800078e001aULL, 0x00000010491c7825ULL, 0x000fc800078e001cULL,
0x00000010491e7825ULL, 0x000fc800078e001eULL, 0x0000001049387825ULL, 0x000fc800078e0038ULL,
0x00000010493a7825ULL, 0x000fc800078e003aULL, 0x00000010494a7825ULL, 0x000fc800078e004aULL,
0x00000010494c7825ULL, 0x000fc800078e004cULL, 0x00000010494e7825ULL, 0x000fc800078e004eULL,
0x0000001049507825ULL, 0x000fc800078e0050ULL, 0x0000001049527825ULL, 0x000fc800078e0052ULL,
0x0000001049147825ULL, 0x000fc800078e0014ULL, 0x00000010490e7825ULL, 0x000fc800078e000eULL,
0x0000001049107825ULL, 0x000fc800078e0010ULL, 0x000000105d5d7824ULL, 0x100fe400078e025eULL,
0x0000001048497824ULL, 0x100fe400078e025eULL, 0x00000010465f7824ULL, 0x100fe200078e025eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000125d7faeULL, 0x0003e2000b901c46ULL,
0x0000001045457824ULL, 0x100fe400078e025eULL, 0x0000001044617824ULL, 0x100fe200078e025eULL,
0x0000000016497faeULL, 0x0003e2000b901c46ULL, 0x0000001043437824ULL, 0x000fc400078e025eULL,
0x0000001042637824ULL, 0x100fe200078e025eULL, 0x0000000018477faeULL, 0x0003e2000b901c46ULL,
0x0000001041417824ULL, 0x100fe400078e025eULL, 0x0000001040657824ULL, 0x100fe200078e025eULL,
0x000000001a5f7faeULL, 0x0003e2000b901c46ULL, 0x000000103e677824ULL, 0x100fe400078e025eULL,
0x000000103d3d7824ULL, 0x100fe200078e025eULL, 0x000000001c457faeULL, 0x0003e2000b901c46ULL,
0x000000103c697824ULL, 0x000fc400078e025eULL, 0x0000001003037824ULL, 0x100fe200078e025eULL,
0x000000001e617faeULL, 0x0003e2000b901c46ULL, 0x000000105c6b7824ULL, 0x000fc600078e025eULL,
0x0000000038437faeULL, 0x0003e8000b901c46ULL, 0x000000003a637faeULL, 0x0003e8000b901c46ULL,
0x000000004a417faeULL, 0x0003e8000b901c46ULL, 0x000000004c657faeULL, 0x0003e8000b901c46ULL,
0x000000004e3f7faeULL, 0x0003e8000b901c46ULL, 0x0000000050677faeULL, 0x0003e8000b901c46ULL,
0x00000000523d7faeULL, 0x0003e8000b901c46ULL, 0x0000000014697faeULL, 0x0003e8000b901c46ULL,
0x000000000e037faeULL, 0x0003e8000b901c46ULL, 0x00000000106b7faeULL, 0x0003e4000b901c46ULL,
0x0000000104037812ULL, 0x002fe200078ec0ffULL, 0x02360c0009127984ULL, 0x000e660000000800ULL,
0x000000010300780cULL, 0x000fe20003f05070ULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x0000000105037807ULL, 0x000fca0004000000ULL, 0x0000000104047824ULL, 0x000fe400078e0203ULL,
0xffffffffff037424ULL, 0x000fc600078e00ffULL, 0x0000008d0400720cULL, 0x000fda0003f06070ULL,
0x00000004000f8802ULL, 0x000fe20000000f00ULL, 0x000000010b0e8824ULL, 0x000fc800078e0204ULL,
0x000060000e0e8625ULL, 0x000fca00078e000fULL, 0x000000060e038981ULL, 0x000562000c1e1900ULL,
0x0000ffff0a107812ULL, 0x000fc800078ec0ffULL, 0x0000888010107816ULL, 0x000fca00000000ffULL,
0x8000000010117824ULL, 0x000fca00078e00ffULL, 0x8000000012ff7812ULL, 0x002fe20007804811ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x004fea0003800000ULL,
0x8000000010107824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL,
0x0000000e000f7305ULL, 0x0002a4000021f000ULL, 0x3fa000000e0e7823ULL, 0x002fe200000100ffULL,
0x0000000f0000735dULL, 0x004fe40003800000ULL, 0x02360c00090f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fc40007804810ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000010060f7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fc80000011606ULL, 0x000000700f0f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc600078ec0ffULL, 0x00000080620f7824ULL, 0x000fc800078e020fULL,
0x000000010f0e7824ULL, 0x000fca00078e020eULL, 0x023000000e0f7984ULL, 0x000e680000000800ULL,
0x023200000e6c7984ULL, 0x0004e20000000800ULL, 0x000000020f00720bULL, 0x002fda0003f1d000ULL,
0x0000000000107806ULL, 0x000fc800000e0100ULL, 0x0000ffff10127812ULL, 0x000fe4000780c0ffULL,
0x0000000100107802ULL, 0x000fd60000000f00ULL, 0x000003d000008947ULL, 0x000fea0003800000ULL,
0x0000000f02157209ULL, 0x00cfe40007810000ULL, 0x000000020f00720bULL, 0x000fe40003f34000ULL,
0x0000008e6200720cULL, 0x000fe20003f05270ULL, 0x8000001502027221ULL, 0x000fe20000010000ULL,
0x00000002ff107819ULL, 0x000fc60000011606ULL, 0x3fb8aa3b020e7820ULL, 0x000fe20000410000ULL,
0x0000000810117810ULL, 0x000fc60007ffe0ffULL, 0x0000000e00177308ULL, 0x0002a40000000800ULL,
0x0000000000027806ULL, 0x000fc800008e0100ULL, 0x0000ffff02137812ULL, 0x000fe200078e3cffULL,
0x0000007000000947ULL, 0x000fea0003800000ULL, 0x00000010060e7824ULL, 0x002fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011606ULL, 0x000000700e1b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c02197812ULL, 0x000fc600078ec0ffULL, 0x000000808e027824ULL, 0x000fc800078e021bULL,
0x0000000119027824ULL, 0x000fca00078e0202ULL, 0x0234001502007388ULL, 0x0003e40000000800ULL,
0x0000001312ff7212ULL, 0x000fe2000780c0ffULL, 0x00001f1017107589ULL, 0x004ea200000e0000ULL,
0x0000001700007220ULL, 0x000fe40000410000ULL, 0x00000001ff0e7807ULL, 0x002fe20000000000ULL,
0x00001f1117117589ULL, 0x000e6200000e0000ULL, 0x000000ffff027224ULL, 0x000fce00078e0015ULL,
0x800000150f0f0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL,
0x0000000f000d0308ULL, 0x000ee20000000800ULL, 0x0000001035357220ULL, 0x084fe40000410000ULL,
0x0000001034347220ULL, 0x080fe40000410000ULL, 0x0000001021217220ULL, 0x080fe40000410000ULL,
0x0000001020207220ULL, 0x080fe40000410000ULL, 0x0000001025257220ULL, 0x080fe40000410000ULL,
0x0000001024247220ULL, 0x000fc40000410000ULL, 0x0000001029297220ULL, 0x080fe40000410000ULL,
0x0000001028287220ULL, 0x080fe40000410000ULL, 0x000000102d2d7220ULL, 0x080fe40000410000ULL,
0x000000102c2c7220ULL, 0x080fe40000410000ULL, 0x0000001031317220ULL, 0x080fe40000410000ULL,
0x0000001030307220ULL, 0x000fc40000410000ULL, 0x0000001055557220ULL, 0x080fe40000410000ULL,
0x0000001054547220ULL, 0x080fe40000410000ULL, 0x0000001059597220ULL, 0x080fe40000410000ULL,
0x0000001058587220ULL, 0x000fe20000410000ULL, 0x000076100e107816ULL, 0x000fe20000000010ULL,
0x0000001137377220ULL, 0x082fe40000410000ULL, 0x0000001136367220ULL, 0x000fc40000410000ULL,
0x0000001123237220ULL, 0x080fe40000410000ULL, 0x0000001122227220ULL, 0x080fe40000410000ULL,
0x0000001127277220ULL, 0x080fe40000410000ULL, 0x0000001126267220ULL, 0x080fe40000410000ULL,
0x000000112b2b7220ULL, 0x080fe40000410000ULL, 0x000000112a2a7220ULL, 0x000fc40000410000ULL,
0x000000112f2f7220ULL, 0x080fe40000410000ULL, 0x000000112e2e7220ULL, 0x080fe40000410000ULL,
0x0000001133337220ULL, 0x080fe40000410000ULL, 0x0000001132327220ULL, 0x080fe40000410000ULL,
0x0000001157577220ULL, 0x080fe40000410000ULL, 0x0000001156567220ULL, 0x000fc40000410000ULL,
0x000000115b5b7220ULL, 0x080fe40000410000ULL, 0x000000115a5a7220ULL, 0x000fe40000410000ULL,
0x0000000d6c6c0220ULL, 0x008fe40000410000ULL, 0x00000007060e7812ULL, 0x00cfe200078ec0ffULL,
0x0000000262137824ULL, 0x000fe200078e0207ULL, 0x00000004ff0f7819ULL, 0x000fe20000011606ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000080e427812ULL, 0x000fe400078ef806ULL,
0x0000000806417812ULL, 0x000fe400078ec0ffULL, 0x000000070f117812ULL, 0x000fe400078e7842ULL,
0x00000007415c7812ULL, 0x040fe400078ec80eULL, 0x0000000e41417212ULL, 0x000fe200078efcffULL,
0x0000000842117824ULL, 0x000fe200078e0211ULL, 0x0000000c13407211ULL, 0x000fc400078e08ffULL,
0x0000000f5c5f7212ULL, 0x000fe200078e3cffULL, 0x00000010116b7824ULL, 0x000fe200078e00ffULL,
0x000000020f397810ULL, 0x000fe40007ffe0ffULL, 0x0001300040407811ULL, 0x000fe200078e68ffULL,
0x0000080062147824ULL, 0x000fe200078e026bULL, 0x000000395c5e7212ULL, 0x000fe200078e3cffULL,
0x0000000841697824ULL, 0x000fe200078e025fULL, 0x0000000dff0e723eULL, 0x000fe400000000ffULL,
0x00000002ff6d7819ULL, 0x000fe20000011606ULL, 0x011000001414783bULL, 0x000fe20000000200ULL,
0x00000010691c7824ULL, 0x000fe200078e0240ULL, 0x000054100e187816ULL, 0x000fe2000000000eULL,
0x0000000841687824ULL, 0x000fe200078e025eULL, 0x00009910100e7816ULL, 0x000fc400000000ffULL,
0x000000086d197810ULL, 0x000fe20007ffe0ffULL, 0x000000001c1c783bULL, 0x000fe20000004200ULL,
0x0000001068107824ULL, 0x000fe200078e0240ULL, 0x000000040f5d7810ULL, 0x040fe40007ffe0ffULL,
0x00001f6d186d7589ULL, 0x000e6200000e0000ULL, 0x000000ff0e00720cULL, 0x000fe40003f05270ULL,
0x0000005d5c5d7212ULL, 0x000fe200078e3cffULL, 0x000000001010783bULL, 0x000fe20000004200ULL,
0x000000060f0f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000739397812ULL, 0x000fe200078e7842ULL,
0x00001f19186a7589ULL, 0x0004e200000e0000ULL, 0x0000000841677824ULL, 0x040fe200078e025dULL,
0x0000000f5c5c7212ULL, 0x000fe400078e3cffULL, 0x0000000842397824ULL, 0x000fe200078e0239ULL,
0x0000008041607811ULL, 0x040fe400078e18ffULL, 0x0000005c41667211ULL, 0x000fe200078e18ffULL,
0x0000001039657824ULL, 0x000fe200078e00ffULL, 0x00000004060f7811ULL, 0x000fe200078fe0ffULL,
0x0000001067187824ULL, 0x004fc400078e0240ULL, 0x0000001066387824ULL, 0x000fe200078e0240ULL,
0x000000070f0f7812ULL, 0x000fe200078e7842ULL, 0x000000015e637824ULL, 0x100fe400078e0260ULL,
0x000000001818783bULL, 0x000ea20000004200ULL, 0x000000015d617824ULL, 0x100fe400078e0260ULL,
0x000000015f647824ULL, 0x100fe200078e0260ULL, 0x000000003838783bULL, 0x000f220000004200ULL,
0x0000006d14148232ULL, 0x082fe20000000000ULL, 0x000000015c607824ULL, 0x000fe200078e0260ULL,
0x0000006d16168232ULL, 0x000fe20000000000ULL, 0x00000010643c7824ULL, 0x000fe200078e0240ULL,
0x0000006a15158232ULL, 0x088fe20000000000ULL, 0x00000008420e7824ULL, 0x000fe200078e020fULL,
0x0000006a17178232ULL, 0x000fc60000000000ULL, 0x000000003c3c783bULL, 0x000fe20000004200ULL,
0x000000100e0e7824ULL, 0x000fc600078e00ffULL, 0x0000001c1458723cULL, 0x000fe20000001858ULL,
0x0000080062447824ULL, 0x000fcc00078e020eULL, 0x00000800621c7824ULL, 0x000fe200078e0265ULL,
0x0000001e1454723cULL, 0x040fe20000001854ULL, 0x011000004444783bULL, 0x000e680000000200ULL,
0x011000001c1c783bULL, 0x000ee60000000200ULL, 0x000000101430723cULL, 0x040fee0000001830ULL,
0x0000004063107211ULL, 0x000fe200078e20ffULL, 0x00000012142c723cULL, 0x040fea000000182cULL,
0x000000001010783bULL, 0x000ee60000004200ULL, 0x000000181428723cULL, 0x044fee0000001828ULL,
0x0000001061187824ULL, 0x000fe200078e0240ULL, 0x0000001a1424723cULL, 0x040fea0000001824ULL,
0x000000001818783bULL, 0x000ea60000004200ULL, 0x000000381420723cULL, 0x010fe20000001820ULL,
0x0000006d44448232ULL, 0x002fc40000000000ULL, 0x0000006d46468232ULL, 0x080fe40000000000ULL,
0x0000006d1c1c8232ULL, 0x088fe40000000000ULL, 0x0000001060387824ULL, 0x000fe200078e0240ULL,
0x0000003a1434723cULL, 0x000fe20000001834ULL, 0x0000006d1e1e8232ULL, 0x000fe40000000000ULL,
0x0000006a1d1d8232ULL, 0x080fe40000000000ULL, 0x0000006a1f1f8232ULL, 0x080fe20000000000ULL,
0x000000003838783bULL, 0x000e620000004200ULL, 0x0000006a45458232ULL, 0x000fc40000000000ULL,
0x0000006a47478232ULL, 0x000fc60000000000ULL, 0x0000003c1c58723cULL, 0x040ff00000001858ULL,
0x000000101c30723cULL, 0x040fee0000001830ULL, 0x0000000606117811ULL, 0x000fe200078fe0ffULL,
0x000000121c2c723cULL, 0x040fee000000182cULL, 0x0000010041127811ULL, 0x000fe200078e18ffULL,
0x000000181c28723cULL, 0x004fe20000001828ULL, 0x0000000711137812ULL, 0x000fc400078e7842ULL,
0x000000125f0f7210ULL, 0x000fe20007ffe0ffULL, 0x000000015e107824ULL, 0x100fe200078e0212ULL,
0x0000018041417811ULL, 0x000fe200078e18ffULL, 0x000000015d117824ULL, 0x100fe400078e0212ULL,
0x000000015c127824ULL, 0x000fe200078e0212ULL, 0x0000003e1c54723cULL, 0x000fe20000001854ULL,
0x000000100f147824ULL, 0x100fe400078e0240ULL, 0x0000001010507824ULL, 0x100fe200078e0240ULL,
0x0000004012487211ULL, 0x000fe200078e20ffULL, 0x00000010114c7824ULL, 0x000fc400078e0240ULL,
0x000000001414783bULL, 0x000ea20000004200ULL, 0x0000000842137824ULL, 0x000fe200078e0213ULL,
0x0000001a1c24723cULL, 0x040fe20000001824ULL, 0x000000015e5e7824ULL, 0x100fe200078e0241ULL,
0x000000004848783bULL, 0x000ee20000004200ULL, 0x0000001013137824ULL, 0x000fe400078e00ffULL,
0x000000015f5f7824ULL, 0x000fe200078e0241ULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x0000080062187824ULL, 0x000fe200078e0213ULL, 0x000000381c20723cULL, 0x042fe20000001820ULL,
0x000000015d5d7824ULL, 0x100fe200078e0241ULL, 0x000000004c4c783bULL, 0x000fe20000004200ULL,
0x000000015c5c7824ULL, 0x000fe200078e0241ULL, 0x000000405e3c7211ULL, 0x000fe200078e20ffULL,
0x000000105f417824ULL, 0x100fe200078e0240ULL, 0x011000001818783bULL, 0x000e620000000200ULL,
0x000000105d387824ULL, 0x100fe200078e0240ULL, 0x0000003a1c1c723cULL, 0x000fe20000001834ULL,
0x000000105c627824ULL, 0x000fe200078e0240ULL, 0x000000003c3c783bULL, 0x000fe80000004200ULL,
0x000000006234783bULL, 0x0008680000004200ULL, 0x000000004140783bULL, 0x000e680000004200ULL,
0x000000003838783bULL, 0x000e620000004200ULL, 0x00000001ff627819ULL, 0x010fe2000001168eULL,
0x000000144458723cULL, 0x044fee0000001858ULL, 0x0002361062147811ULL, 0x000fe200078e20ffULL,
0x000000484420723cULL, 0x048ff00000001820ULL, 0x000000164454723cULL, 0x000fe20000001854ULL,
0x0000006d18188232ULL, 0x002fc40000000000ULL, 0x0000006d1a1a8232ULL, 0x000fe40000000000ULL,
0x0000006a19198232ULL, 0x080fe40000000000ULL, 0x0000006a1b1b8232ULL, 0x000fe20000000000ULL,
0x000000504430723cULL, 0x040ff00000001830ULL, 0x00000052442c723cULL, 0x040ff0000000182cULL,
0x0000004c4428723cULL, 0x040ff00000001828ULL, 0x0000004e4424723cULL, 0x040ff00000001824ULL,
0x0000004a441c723cULL, 0x000ff0000000181cULL, 0x000000341820723cULL, 0x040ff00000001820ULL,
0x000000401858723cULL, 0x040ff00000001858ULL, 0x000000421854723cULL, 0x040ff00000001854ULL,
0x0000003c1830723cULL, 0x040ff00000001830ULL, 0x0000003e182c723cULL, 0x040ff0000000182cULL,
0x000000381828723cULL, 0x040ff00000001828ULL, 0x0000003a1824723cULL, 0x040ff00000001824ULL,
0x000000361834723cULL, 0x000fe2000000181cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0000000490167824ULL, 0x000fe200078e0262ULL, 0x0000000014ff7f8cULL, 0x0003e2000c80043fULL,
0x000000006c007221ULL, 0x000fc60000010000ULL, 0x0000008016167811ULL, 0x000fc800078e30ffULL,
0x0000008f1600720cULL, 0x000fda0003f06070ULL, 0x0000253000000947ULL, 0x000fea0003800000ULL,
0x000000208e147824ULL, 0x002fe200078e00ffULL, 0x0000030090157a10ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffc014167812ULL, 0x000fe400078ec0ffULL,
0x0000000115147810ULL, 0x000fc60007ffe0ffULL, 0x0000010015157824ULL, 0x000fe200078e0216ULL,
0x0000008b1400720cULL, 0x000fc80003f06070ULL, 0x0000004008387812ULL, 0x000fd200078ef815ULL,
0x00000c3000008947ULL, 0x000fea0003800000ULL, 0x00000003ff397819ULL, 0x000fe20000011606ULL,
0x000040008e167824ULL, 0x000fe200078e00ffULL, 0x000000158f147217ULL, 0x000fe20007800000ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000439197810ULL, 0x040fe20007ffe0ffULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x0000400016177812ULL, 0x000fe200078ec0ffULL,
0x00000001143a7824ULL, 0x000fe200078e0a15ULL, 0x0000001439777810ULL, 0x000fe20007ffe0ffULL,
0x000020000c147824ULL, 0x000fe200078e00ffULL, 0x00000007061f7812ULL, 0x000fe200078ec0ffULL,
0x0000000807167824ULL, 0x000fe200078e00ffULL, 0x00000010396d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000819187824ULL, 0x040fe200078e00ffULL, 0x0000000619157212ULL, 0x000fe200078e3cffULL,
0x0000000877797824ULL, 0x000fe200078e00ffULL, 0x00000008391b7810ULL, 0x000fe20007ffe0ffULL,
0x000000086d1a7824ULL, 0x000fe200078e00ffULL, 0x0000000c391d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000403387c24ULL, 0x020fe2000f8e0238ULL, 0x0000001762177211ULL, 0x000fc400078e78ffULL,
0x0000200014147812ULL, 0x000fe200078ec0ffULL, 0x000000081d737824ULL, 0x000fe200078e00ffULL,
0x00000008161f7812ULL, 0x000fe400078ee21fULL, 0xfffffff8186f7812ULL, 0x000fe200078ee215ULL,
0x000000081b187824ULL, 0x000fe200078e00ffULL, 0x0000000677167212ULL, 0x080fe400078e3cffULL,
0x0000001c397d7810ULL, 0x000fe40007ffe0ffULL, 0x000000066d157212ULL, 0x000fc400078e3cffULL,
0x0000002439457810ULL, 0x000fe40007ffe0ffULL, 0x00013000171e7810ULL, 0x000fe40007ffe014ULL,
0x000000061b037212ULL, 0x080fe400078e3cffULL, 0x000000061d147212ULL, 0x000fe200078e3cffULL,
0x000000106f6f7824ULL, 0x000fe200078e021eULL, 0x00000020397f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff879797812ULL, 0x000fe200078ee216ULL, 0x000000087d167824ULL, 0x000fe200078e00ffULL,
0x00000018397b7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81a757812ULL, 0x000fe200078ee215ULL,
0x00000008451a7824ULL, 0x000fe200078e00ffULL, 0x000000067d517212ULL, 0x080fe400078e3cffULL,
0x0000002c39477810ULL, 0x000fe20007ffe0ffULL, 0x0000001075757824ULL, 0x000fe200078e021eULL,
0xfffffff818717812ULL, 0x000fe200078ee203ULL, 0x000000087f187824ULL, 0x000fe200078e00ffULL,
0xfffffff873737812ULL, 0x000fe400078ee214ULL, 0x0000000645437212ULL, 0x000fc400078e3cffULL,
0x0000003439497810ULL, 0x000fe20007ffe0ffULL, 0x0000001073737824ULL, 0x000fe200078e021eULL,
0x000000067b537212ULL, 0x0c0fe400078e3cffULL, 0x000000037b147819ULL, 0x000fe400000006ffULL,
0x00000028394d7810ULL, 0x000fe40007ffe0ffULL, 0x000000403a3a7817ULL, 0x000fe40003800000ULL,
0x000000067f4f7212ULL, 0x000fc400078e3cffULL, 0x00000030394b7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff816517812ULL, 0x000fe200078ee251ULL, 0x0000000847167824ULL, 0x000fe200078e00ffULL,
0xfffffff81a437812ULL, 0x000fe200078ee243ULL, 0x00000008491a7824ULL, 0x000fe200078e00ffULL,
0x0000000739177812ULL, 0x000fe200078e4806ULL, 0x0000001051517824ULL, 0x100fe200078e021eULL,
0xfffffff814537812ULL, 0x000fe200078ee253ULL, 0x000000084d147824ULL, 0x000fe200078e00ffULL,
0x00000006473f7212ULL, 0x000fe200078e3cffULL, 0x0000001043437824ULL, 0x000fe200078e021eULL,
0x0000007f39157812ULL, 0x000fc400078ec0ffULL, 0x0000003a1900720cULL, 0x000fe40003f26070ULL,
0xfffffff8184f7812ULL, 0x000fe200078ee24fULL, 0x000000084b187824ULL, 0x000fe200078e00ffULL,
0x00000006493b7212ULL, 0x000fe400078e3cffULL, 0x0000007f19197812ULL, 0x000fe200078ec0ffULL,
0x000000104f4f7824ULL, 0x000fe200078e021eULL, 0x0000003a1b00720cULL, 0x080fe40003f46070ULL,
0x0000003a6d00720cULL, 0x000fc40003f86070ULL, 0x000000064d417212ULL, 0x000fe400078e3cffULL,
0x0000007f1b1b7812ULL, 0x000fe400078ec0ffULL, 0x0000003a1d00720cULL, 0x000fe40003f66070ULL,
0x0000007f6d6d7812ULL, 0x000fe200078ec0ffULL, 0x000000011b1c7824ULL, 0x000fe200078e0238ULL,
0x000000064b3d7212ULL, 0x000fe400078e3cffULL, 0x0ffffff817177812ULL, 0x000fc400078ef806ULL,
0x0000007f1d1d7812ULL, 0x000fe400078ec0ffULL, 0xfffffff8163f7812ULL, 0x000fe200078ee23fULL,
0x0000000115167824ULL, 0x100fe200078e0238ULL, 0x0000010000037802ULL, 0x000fe40000000f00ULL,
0xfffffff81a3b7812ULL, 0x000fe200078ee23bULL, 0x00000001191a7824ULL, 0x100fe200078e0238ULL,
0xfffffff814417812ULL, 0x000fe200078ee241ULL, 0x000000016d147824ULL, 0x100fe200078e0238ULL,
0xfffffff8183d7812ULL, 0x000fe200078ee23dULL, 0x000000011d187824ULL, 0x000fe200078e0238ULL,
0x0000003a3900720cULL, 0x000fe20003f06070ULL, 0x00000010176d7824ULL, 0x000fe200078e021eULL,
0x0000001e71717211ULL, 0x080fe200078e20ffULL, 0x00005e0016167625ULL, 0x000fe200078e0003ULL,
0x0000001e53537211ULL, 0x000fc600078e20ffULL, 0x00005e001a1a7625ULL, 0x000fc800078e0003ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0003ULL, 0x00005e0018187625ULL, 0x000fc800078e0003ULL,
0x000000101f167825ULL, 0x000fc800078e0016ULL, 0x000000101f1a7825ULL, 0x000fe200078e001aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000166d7faeULL, 0x0003e2000c101c46ULL,
0x0000003a7700720cULL, 0x080fe40003f06070ULL, 0x000000101f1c7825ULL, 0x000fe200078e001cULL,
0x000000001a6f7faeULL, 0x0005e2000c901c46ULL, 0x0000007f77777812ULL, 0x000fe400078ec0ffULL,
0x000000101f187825ULL, 0x000fe200078e0018ULL, 0x000000001c717faeULL, 0x0007e2000d101c46ULL,
0x0000003a7b00720cULL, 0x000fc40003f26070ULL, 0x00005e0014147625ULL, 0x080fe200078e0003ULL,
0x0000000018737faeULL, 0x0009e2000d901c46ULL, 0x0000007f7b7b7812ULL, 0x000fe400078ec0ffULL,
0x0000003a7d00720cULL, 0x080fe20003f46070ULL, 0x0000000177167824ULL, 0x002fe200078e0238ULL,
0x0000007f7d7d7812ULL, 0x000fe200078ec0ffULL, 0x000000101f147825ULL, 0x000fe200078e0014ULL,
0x0000003a7f00720cULL, 0x0c0fe40003f66070ULL, 0x0000007f7f7f7812ULL, 0x000fe200078ec0ffULL,
0x000000017d1a7824ULL, 0x104fe200078e0238ULL, 0x0000000014757faeULL, 0x0003e2000e101c46ULL,
0x000000017b187824ULL, 0x110fe200078e0238ULL, 0x00000038396d7810ULL, 0x000fe20007ffe0ffULL,
0x000000017f1c7824ULL, 0x008fe200078e0238ULL, 0x0000003c39397810ULL, 0x000fe20007ffe0ffULL,
0x00005e001a1a7625ULL, 0x000fe200078e0003ULL, 0x0000003a4900720cULL, 0x000fc40003f86070ULL,
0x0000003a6d00720cULL, 0x080fe20003fa6070ULL, 0x00000010791d7824ULL, 0x000fe200078e021eULL,
0x0000007f49497812ULL, 0x000fe200078ec0ffULL, 0x000000101f1a7825ULL, 0x000fe200078e001aULL,
0x0000003a3900720cULL, 0x000fc60003fc6070ULL, 0x00005e0016147625ULL, 0x002fc800078e0003ULL,
0x00005e0018167625ULL, 0x000fc800078e0003ULL, 0x00005e001c187625ULL, 0x000fe200078e0003ULL,
0x000000066d1c7212ULL, 0x000fc600078e3cffULL, 0x000000101f147825ULL, 0x000fc800078e0014ULL,
0x000000101f167825ULL, 0x000fe200078e0016ULL, 0x00000000141d7faeULL, 0x0003e2000c101c46ULL,
0x0000003a4500720cULL, 0x080fe40003f06070ULL, 0x000000101f187825ULL, 0x000fe200078e0018ULL,
0x0000000016537faeULL, 0x0005e2000c901c46ULL, 0x0000003a4d00720cULL, 0x080fe40003f26070ULL,
0x000000086d6f7824ULL, 0x000fe200078e00ffULL, 0x000000001a517faeULL, 0x0007e2000d101c46ULL,
0x0000007f45457812ULL, 0x000fe200078ec0ffULL, 0x00000008393e7824ULL, 0x000fe200078e00ffULL,
0x0000003a4700720cULL, 0x080fe20003f46070ULL, 0x00000000184f7faeULL, 0x0009e2000d901c46ULL,
0x0000007f4d4d7812ULL, 0x000fe200078ec0ffULL, 0x0000000145147824ULL, 0x002fe200078e0238ULL,
0x0000003a4b00720cULL, 0x000fe20003f66070ULL, 0x0000001041417824ULL, 0x000fe200078e021eULL,
0x0000007f47477812ULL, 0x000fe200078ec0ffULL, 0x000000014d167824ULL, 0x004fe200078e0238ULL,
0xfffffff86f157812ULL, 0x000fe200078ee21cULL, 0x00000001491c7824ULL, 0x000fe200078e0238ULL,
0x0000007f4b4b7812ULL, 0x000fe200078ec0ffULL, 0x000000103f3f7824ULL, 0x000fe200078e021eULL,
0x0000007f39177812ULL, 0x000fe200078ec0ffULL, 0x0000000147187824ULL, 0x010fe200078e0238ULL,
0x0000000639197212ULL, 0x000fe200078e3cffULL, 0x0000001015477824ULL, 0x000fe200078e021eULL,
0x0000007f6d6d7812ULL, 0x000fe200078ec0ffULL, 0x00000001173c7824ULL, 0x000fe200078e0238ULL,
0xfffffff83e197812ULL, 0x000fe200078ee219ULL, 0x00005e0014147625ULL, 0x000fe200078e0003ULL,
0x000000384b1a7210ULL, 0x008fc40007ffe0ffULL, 0x0000001e3b457211ULL, 0x000fe200078e20ffULL,
0x000000016d3a7824ULL, 0x000fe400078e0238ULL, 0x0000001019497824ULL, 0x000fe400078e021eULL,
0x00005e0016167625ULL, 0x000fc800078e0003ULL, 0x00005e0018187625ULL, 0x000fc800078e0003ULL,
0x00005e001a1a7625ULL, 0x000fc800078e0003ULL, 0x00005e001c1c7625ULL, 0x000fc800078e0003ULL,
0x00005e003a387625ULL, 0x000fc800078e0003ULL, 0x00005e003c3a7625ULL, 0x000fc800078e0003ULL,
0x000000101f147825ULL, 0x000fc800078e0014ULL, 0x000000101f167825ULL, 0x040fe200078e0016ULL,
0x0000000014437faeULL, 0x0003e6000c101c46ULL, 0x000000101f187825ULL, 0x000fe200078e0018ULL,
0x0000000016417faeULL, 0x0003e6000c901c46ULL, 0x000000103d3d7824ULL, 0x000fe200078e021eULL,
0x00000000183f7faeULL, 0x0003e2000d101c46ULL, 0x000000101f1a7825ULL, 0x000fc800078e001aULL,
0x000000101f1c7825ULL, 0x040fe200078e001cULL, 0x000000001a3d7faeULL, 0x0003e6000d901c46ULL,
0x000000101f387825ULL, 0x040fe200078e0038ULL, 0x000000001c457faeULL, 0x0003e6000e101c46ULL,
0x000000101f3a7825ULL, 0x000fe200078e003aULL, 0x0000000038477faeULL, 0x0003e8000e901c46ULL,
0x000000003a497faeULL, 0x0003e2000f101c46ULL, 0x00000af000007947ULL, 0x000fea0003800000ULL,
0x000040008e147824ULL, 0x000fe200078e00ffULL, 0x00000003ff157819ULL, 0x000fe20000011606ULL,
0x0000000807167824ULL, 0x000fe200078e00ffULL, 0x00000007064d7812ULL, 0x000fe200078ec0ffULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000400014177812ULL, 0x000fe200078ec0ffULL,
0x000020000c147824ULL, 0x000fe200078e00ffULL, 0x0000000415197810ULL, 0x000fe20007ffe0ffULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x00000008164d7812ULL, 0x000fe200078ee24dULL,
0x0000800062177824ULL, 0x000fe200078e0217ULL, 0x0000200014147812ULL, 0x000fe200078ec0ffULL,
0x00000008191d7824ULL, 0x000fe200078e00ffULL, 0x0000001415397810ULL, 0x000fe20007ffe0ffULL,
0x0000000403037c24ULL, 0x020fe2000f8e0238ULL, 0x0000000619167212ULL, 0x000fc400078e3cffULL,
0x00000008151b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008393d7824ULL, 0x000fe200078e00ffULL,
0x0001300017837810ULL, 0x000fe40007ffe014ULL, 0xfffffff81d147812ULL, 0x000fe400078ee216ULL,
0x0000000c151d7810ULL, 0x000fe40007ffe0ffULL, 0x00000006391a7212ULL, 0x080fe400078e3cffULL,
0x000000061b187212ULL, 0x000fe200078e3cffULL, 0x000000081d3b7824ULL, 0x000fe200078e00ffULL,
0x000000031b1f7819ULL, 0x000fc400000006ffULL, 0x00000020153f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff83d427812ULL, 0x000fe400078ee21aULL, 0xfffffff81f167812ULL, 0x000fe200078ee218ULL,
0x000000083f437824ULL, 0x000fe200078e00ffULL, 0x0000001c153d7810ULL, 0x040fe20007ffe0ffULL,
0x00000010426f7824ULL, 0x000fe200078e0283ULL, 0x00000010151f7810ULL, 0x000fe40007ffe0ffULL,
0x000000061d187212ULL, 0x080fe200078e3cffULL, 0x000000083d417824ULL, 0x000fe200078e00ffULL,
0x000000063f1c7212ULL, 0x000fe200078e3cffULL, 0x000000081f3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b187812ULL, 0x000fc400078ee218ULL, 0x0000002c15457810ULL, 0x040fe40007ffe0ffULL,
0x00000018153b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001018537824ULL, 0x100fe200078e0283ULL,
0x000000063d1a7212ULL, 0x080fe200078e3cffULL, 0x0000000845497824ULL, 0x000fe200078e00ffULL,
0xfffffff8434e7812ULL, 0x000fe200078ee21cULL, 0x000000083b467824ULL, 0x000fe200078e00ffULL,
0x000000061f177212ULL, 0x000fe400078e3cffULL, 0x0000002815437810ULL, 0x000fe20007ffe0ffULL,
0x000000104e757824ULL, 0x000fe200078e0283ULL, 0xfffffff8414a7812ULL, 0x000fc400078ee21aULL,
0xfffffff83e3e7812ULL, 0x000fe400078ee217ULL, 0x0000002415417810ULL, 0x000fe20007ffe0ffULL,
0x000000104a737824ULL, 0x100fe200078e0283ULL, 0x00000006431a7212ULL, 0x0c0fe200078e3cffULL,
0x000000103e6d7824ULL, 0x000fe200078e0283ULL, 0x0000000343477819ULL, 0x000fe200000006ffULL,
0x0000000841527824ULL, 0x000fe200078e00ffULL, 0x00000006451c7212ULL, 0x080fe400078e3cffULL,
0x000000063b177212ULL, 0x000fc400078e3cffULL, 0xfffffff8476a7812ULL, 0x000fe400078ee21aULL,
0xfffffff849707812ULL, 0x000fe400078ee21cULL, 0xfffffff846467812ULL, 0x000fe200078ee217ULL,
0x000000106a797824ULL, 0x100fe200078e0283ULL, 0x0000003015477810ULL, 0x040fe20007ffe0ffULL,
0x00000010707b7824ULL, 0x100fe200078e0283ULL, 0x0000003415497810ULL, 0x000fe20007ffe0ffULL,
0x0000001046717824ULL, 0x000fe200078e0283ULL, 0x0000000641177212ULL, 0x080fe200078e3cffULL,
0x0000000847747824ULL, 0x000fe200078e00ffULL, 0x00000006491a7212ULL, 0x040fe200078e3cffULL,
0x00000008494f7824ULL, 0x000fe200078e00ffULL, 0xfffffff852527812ULL, 0x000fc400078ee217ULL,
0x0000000647177212ULL, 0x000fe400078e3cffULL, 0x00000038154b7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff874747812ULL, 0x000fe400078ee217ULL, 0xfffffff84f787812ULL, 0x000fe200078ee21aULL,
0x000000084b517824ULL, 0x000fe200078e00ffULL, 0x0000000715177812ULL, 0x040fe200078e4806ULL,
0x00000010747d7824ULL, 0x100fe200078e0283ULL, 0x0000007f151a7812ULL, 0x040fe200078ec0ffULL,
0x00000010787f7824ULL, 0x000fe200078e0283ULL, 0x0000003c15157810ULL, 0x000fc40007ffe0ffULL,
0x000000064b1c7212ULL, 0x080fe400078e3cffULL, 0x0000007f3f4c7812ULL, 0x000fe200078ec0ffULL,
0x0000000815807824ULL, 0x040fe200078e00ffULL, 0x00000006154f7212ULL, 0x000fe400078e3cffULL,
0x0000007f191e7812ULL, 0x000fe200078ec0ffULL, 0x000000011a197824ULL, 0x000fe200078e0203ULL,
0xfffffff8517c7812ULL, 0x000fe200078ee21cULL, 0x0000001016517824ULL, 0x000fe200078e0283ULL,
0x0000007f1b387812ULL, 0x000fe200078ec0ffULL, 0x000000011e1b7824ULL, 0x000fe200078e0203ULL,
0x0000007f1d3a7812ULL, 0x000fe200078ec0ffULL, 0x000000107c817824ULL, 0x000fe200078e0283ULL,
0x0000007f1f3c7812ULL, 0x000fc400078ec0ffULL, 0x0000007f39407812ULL, 0x000fe400078ec0ffULL,
0x0000007f3b447812ULL, 0x000fe200078ec0ffULL, 0x000000013a3b7824ULL, 0x100fe200078e0203ULL,
0x0000007f3d487812ULL, 0x000fe200078ec0ffULL, 0x000000013c3f7824ULL, 0x100fe200078e0203ULL,
0x0000007f41507812ULL, 0x000fe400078ec0ffULL, 0x0000007f456c7812ULL, 0x000fe400078ec0ffULL,
0x0000007f47727812ULL, 0x000fe200078ec0ffULL, 0x0000000144477824ULL, 0x100fe200078e0203ULL,
0x0000007f49767812ULL, 0x000fe200078ec0ffULL, 0x000000014c497824ULL, 0x100fe200078e0203ULL,
0x0000007f4b7a7812ULL, 0x000fe200078ec0ffULL, 0x00000100ff4c7424ULL, 0x000fe200078e00ffULL,
0x0000007f157e7812ULL, 0x000fe200078ec0ffULL, 0x00000001484b7824ULL, 0x100fe200078e0203ULL,
0x0ffffff8171c7812ULL, 0x000fe200078ef806ULL, 0x0000000150457824ULL, 0x100fe200078e0203ULL,
0x0000007f43627812ULL, 0x000fe200078ec0ffULL, 0x0000000140437824ULL, 0x000fe200078e0203ULL,
0xfffffff8801a7812ULL, 0x000fe200078ee24fULL, 0x000000016c3d7824ULL, 0x100fe200078e0203ULL,
0x00000003381f7210ULL, 0x080fe20007ffe0ffULL, 0x0000000172397824ULL, 0x100fe200078e0203ULL,
0x0000000362417210ULL, 0x000fe20007ffe0ffULL, 0x00000001761d7824ULL, 0x100fe200078e0203ULL,
0x00000083144f7211ULL, 0x080fe200078e20ffULL, 0x000000017a157824ULL, 0x100fe200078e0203ULL,
0x0000008352777211ULL, 0x000fe200078e20ffULL, 0x000000017e177824ULL, 0x000fc400078e0203ULL,
0x000000101c037824ULL, 0x100fe400078e0283ULL, 0x000000101a837824ULL, 0x000fe400078e0283ULL,
0x00005e0019187625ULL, 0x000fc800078e004cULL, 0x00005e001b1a7625ULL, 0x000fc800078e004cULL,
0x00005e001f1e7625ULL, 0x000fc800078e004cULL, 0x00005e003b3a7625ULL, 0x000fc800078e004cULL,
0x00005e003f3e7625ULL, 0x000fc800078e004cULL, 0x00005e0043427625ULL, 0x000fc800078e004cULL,
0x00005e0047467625ULL, 0x000fc800078e004cULL, 0x000000104d187825ULL, 0x000fc800078e0018ULL,
0x00005e004b4a7625ULL, 0x000fe200078e004cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018037faeULL, 0x0003e6000b901c46ULL, 0x000000104d1a7825ULL, 0x000fc800078e001aULL,
0x00005e0049487625ULL, 0x000fe200078e004cULL, 0x000000001a4f7faeULL, 0x0003e6000b901c46ULL,
0x000000104d1e7825ULL, 0x000fc800078e001eULL, 0x00005e0045447625ULL, 0x000fe200078e004cULL,
0x000000001e517faeULL, 0x0003e6000b901c46ULL, 0x000000104d3a7825ULL, 0x000fc800078e003aULL,
0x00005e0041407625ULL, 0x000fe200078e004cULL, 0x000000003a537faeULL, 0x0003e6000b901c46ULL,
0x000000104d3e7825ULL, 0x000fc800078e003eULL, 0x00005e003d3c7625ULL, 0x000fe200078e004cULL,
0x000000003e6d7faeULL, 0x0003e6000b901c46ULL, 0x000000104d427825ULL, 0x000fc800078e0042ULL,
0x00005e0039387625ULL, 0x000fe200078e004cULL, 0x00000000426f7faeULL, 0x0003e6000b901c46ULL,
0x000000104d467825ULL, 0x000fc800078e0046ULL, 0x00005e001d1c7625ULL, 0x000fe200078e004cULL,
0x0000000046717faeULL, 0x0003e6000b901c46ULL, 0x000000104d4a7825ULL, 0x000fc800078e004aULL,
0x00005e0015147625ULL, 0x000fe200078e004cULL, 0x000000004a737faeULL, 0x0003e6000b901c46ULL,
0x000000104d487825ULL, 0x000fc800078e0048ULL, 0x00005e0017167625ULL, 0x000fe200078e004cULL,
0x0000000048757faeULL, 0x0003e6000b901c46ULL, 0x000000104d447825ULL, 0x000fc800078e0044ULL,
0x000000104d407825ULL, 0x040fe200078e0040ULL, 0x0000000044777faeULL, 0x0003e6000b901c46ULL,
0x000000104d3c7825ULL, 0x040fe200078e003cULL, 0x0000000040797faeULL, 0x0003e6000b901c46ULL,
0x000000104d387825ULL, 0x040fe200078e0038ULL, 0x000000003c7b7faeULL, 0x0003e6000b901c46ULL,
0x000000104d1c7825ULL, 0x040fe200078e001cULL, 0x00000000387d7faeULL, 0x0003e6000b901c46ULL,
0x000000104d147825ULL, 0x040fe200078e0014ULL, 0x000000001c7f7faeULL, 0x0003e6000b901c46ULL,
0x000000104d167825ULL, 0x000fe200078e0016ULL, 0x0000000014817faeULL, 0x0003e8000b901c46ULL,
0x0000000016837faeULL, 0x0003e4000b901c46ULL, 0x0000000104037812ULL, 0x002fe200078ec0ffULL,
0x02362c0009167984ULL, 0x000e660000000800ULL, 0x000000010300780cULL, 0x000fe20003f05070ULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x0000000105037807ULL, 0x000fca0004000000ULL,
0x0000000104047824ULL, 0x000fe400078e0203ULL, 0xffffffffff037424ULL, 0x000fc600078e00ffULL,
0x0000008d0400720cULL, 0x000fda0003f06070ULL, 0x000000040b148210ULL, 0x000fe20007ffe0ffULL,
0x00000004ff158424ULL, 0x000fc800078e00ffULL, 0x0000600014148625ULL, 0x000fca00078e0015ULL,
0x0000000614038981ULL, 0x000562000c1e1900ULL, 0x0000ffff0a177812ULL, 0x000fc800078ec0ffULL,
0x0000888017177816ULL, 0x000fca00000000ffULL, 0x8000000017197824ULL, 0x000fca00078e00ffULL,
0x8000000016ff7812ULL, 0x002fe20007804819ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x004fea0003800000ULL, 0x8000000017157824ULL, 0x000fe400078e00ffULL,
0x3e000000ff147424ULL, 0x000fc800078e00ffULL, 0x0000001400167305ULL, 0x0002a4000021f000ULL,
0x3fa0000014147823ULL, 0x002fe200000100ffULL, 0x000000160000735dULL, 0x004fe40003800000ULL,
0x02362c0009167984ULL, 0x000e640000000800ULL, 0x8000000016ff7812ULL, 0x002fc40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000001006167824ULL, 0x000fe200078e00ffULL, 0x00000001ff157819ULL, 0x000fe20000011606ULL,
0x000000408e147824ULL, 0x000fe400078e00ffULL, 0x00000001ff187424ULL, 0x000fe200078e00ffULL,
0x0000007016177812ULL, 0x000fe400078ec0ffULL, 0xffffff8014147812ULL, 0x000fe400078ec0ffULL,
0x0000000c15157812ULL, 0x000fe400078ec0ffULL, 0x0000010017147810ULL, 0x000fc80007ffe014ULL,
0x0000001415147210ULL, 0x000fca0007ffe0ffULL, 0x0230000014157984ULL, 0x000e680000000800ULL,
0x0232000014507984ULL, 0x0004e20000000800ULL, 0x000000021500720bULL, 0x002fda0003f1d000ULL,
0x0000000000167806ULL, 0x000fc800000e0100ULL, 0x0000ffff16197812ULL, 0x000fda000780c0ffULL,
0x000003e000008947ULL, 0x000fea0003800000ULL, 0x00000015021a7209ULL, 0x00cfe40007810000ULL,
0x000000028e177811ULL, 0x000fe400078ff8ffULL, 0x000000021500720bULL, 0x000fe20003f34000ULL,
0x8000001a02147221ULL, 0x000fe20000010000ULL, 0x0000008e1700720cULL, 0x000fe40003f05270ULL,
0x00000002ff1c7819ULL, 0x000fe20000011606ULL, 0x3fb8aa3b14167820ULL, 0x000fc80000410000ULL,
0x00000016001b7308ULL, 0x0002a80000000800ULL, 0x0000000000147806ULL, 0x000fc800008e0100ULL,
0x0000ffff14187812ULL, 0x000fe200078e3cffULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000001006167824ULL, 0x002fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fc80000011606ULL,
0x0000007016177812ULL, 0x000fe400078ec0ffULL, 0x0000000c14167812ULL, 0x000fe400078ec0ffULL,
0x0000001502147209ULL, 0x000fe20007810000ULL, 0x000000808e177824ULL, 0x000fc800078e0217ULL,
0x0000000116177824ULL, 0x000fca00078e0217ULL, 0x0234001417007388ULL, 0x0003e40000000800ULL,
0x0000001819ff7212ULL, 0x002fe2000780c0ffULL, 0x00001f1c1b147589ULL, 0x004e6200000e0000ULL,
0x000000081c167810ULL, 0x000fe20007ffe0ffULL, 0x0000001b00007220ULL, 0x000fe20000410000ULL,
0x0000001502027209ULL, 0x000fe40007810000ULL, 0x00000001ff187807ULL, 0x000fe40000000000ULL,
0x00001f161b167589ULL, 0x000eaa00000e0000ULL, 0x8000001a15170221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b17170820ULL, 0x000fc80000410000ULL, 0x00000017000d0308ULL, 0x000ee20000000800ULL,
0x0000001458587220ULL, 0x082fe40000410000ULL, 0x0000001459597220ULL, 0x080fe40000410000ULL,
0x0000001454547220ULL, 0x080fe40000410000ULL, 0x0000001455557220ULL, 0x080fe40000410000ULL,
0x0000001430307220ULL, 0x080fe40000410000ULL, 0x0000001431317220ULL, 0x000fc40000410000ULL,
0x000000142c2c7220ULL, 0x080fe40000410000ULL, 0x000000142d2d7220ULL, 0x080fe40000410000ULL,
0x0000001428287220ULL, 0x080fe40000410000ULL, 0x0000001429297220ULL, 0x080fe40000410000ULL,
0x0000001424247220ULL, 0x080fe40000410000ULL, 0x0000001425257220ULL, 0x000fc40000410000ULL,
0x0000001420207220ULL, 0x080fe40000410000ULL, 0x0000001421217220ULL, 0x080fe40000410000ULL,
0x0000001434347220ULL, 0x080fe40000410000ULL, 0x0000001435357220ULL, 0x000fe40000410000ULL,
0x000000165a5a7220ULL, 0x084fe40000410000ULL, 0x000000165b5b7220ULL, 0x000fc40000410000ULL,
0x0000001656567220ULL, 0x080fe40000410000ULL, 0x0000001657577220ULL, 0x080fe40000410000ULL,
0x0000001632327220ULL, 0x080fe40000410000ULL, 0x0000001633337220ULL, 0x080fe40000410000ULL,
0x000000162e2e7220ULL, 0x080fe40000410000ULL, 0x000000162f2f7220ULL, 0x000fc40000410000ULL,
0x000000162a2a7220ULL, 0x080fe40000410000ULL, 0x000000162b2b7220ULL, 0x080fe40000410000ULL,
0x0000001626267220ULL, 0x080fe40000410000ULL, 0x0000001627277220ULL, 0x080fe40000410000ULL,
0x0000001622227220ULL, 0x080fe40000410000ULL, 0x0000001623237220ULL, 0x000fc40000410000ULL,
0x0000001636367220ULL, 0x080fe40000410000ULL, 0x0000001637377220ULL, 0x000fe40000410000ULL,
0x000000500d500220ULL, 0x008fe40000410000ULL, 0x00000001ff627819ULL, 0x00cfe2000001168eULL,
0x000004008e147824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000262537824ULL, 0x000fe200078e0207ULL, 0xfffff80014147812ULL, 0x000fe200078ec0ffULL,
0x00000800620e7824ULL, 0x000fe200078e020eULL, 0x00000002ff517819ULL, 0x000fe20000011606ULL,
0x0000000253537824ULL, 0x000fe200078e026eULL, 0x0001200014387810ULL, 0x000fe20007ffe06bULL,
0x0000080062137824ULL, 0x000fe200078e0213ULL, 0x0000000dff19723eULL, 0x000fe400000000ffULL,
0x0001300053537811ULL, 0x000fe400078e68ffULL, 0x000000003838783bULL, 0x000fe20000000200ULL,
0x0000000851527810ULL, 0x000fc40007ffe0ffULL, 0x0000005369147211ULL, 0x080fe200078e20ffULL,
0x0000001068447824ULL, 0x000fe200078e0253ULL, 0x0000541019197816ULL, 0x000fe20000000019ULL,
0x0000001067407824ULL, 0x100fe200078e0253ULL, 0x0000991018187816ULL, 0x000fe200000000ffULL,
0x00000010663c7824ULL, 0x100fe200078e0253ULL, 0x000000001414783bULL, 0x000fe20000004200ULL,
0x00000010641c7824ULL, 0x000fe200078e0253ULL, 0x000000ff1800720cULL, 0x000fe20003f05270ULL,
0x0000080062187824ULL, 0x000fe200078e0265ULL, 0x000000004444783bULL, 0x000fe20000004200ULL,
0x0000001063487824ULL, 0x100fe200078e0253ULL, 0x0000005360607211ULL, 0x080fe200078e20ffULL,
0x00000010614c7824ULL, 0x000fe200078e0253ULL, 0x000000004040783bULL, 0x000fe20000004200ULL,
0x000000535e5e7211ULL, 0x000fc600078e20ffULL, 0x000000003c3c783bULL, 0x000fe80000004200ULL,
0x00001f5119517589ULL, 0x000e6800000e0000ULL, 0x00001f5219527589ULL, 0x000ea800000e0000ULL,
0x012000001818783bULL, 0x000ee80000000200ULL, 0x000000001c1c783bULL, 0x000f280000004200ULL,
0x000000004848783bULL, 0x000f280000004200ULL, 0x000000004c4c783bULL, 0x000f220000004200ULL,
0x0000005138388232ULL, 0x002fc40000000000ULL, 0x000000513a3a8232ULL, 0x000fe40000000000ULL,
0x0000005239398232ULL, 0x084fe40000000000ULL, 0x000000523b3b8232ULL, 0x000fce0000000000ULL,
0x000000143858723cULL, 0x040ff00000001858ULL, 0x000000163814723cULL, 0x000fe20000001854ULL,
0x0000005118188232ULL, 0x088fe40000000000ULL, 0x000000511a1a8232ULL, 0x000fc40000000000ULL,
0x0000005219198232ULL, 0x000fc60000000000ULL, 0x000000443830723cULL, 0x000fe20000001830ULL,
0x000000521b1b8232ULL, 0x000fe20000000000ULL, 0x000000105f547824ULL, 0x000fca00078e0253ULL,
0x0000001010447824ULL, 0x100fe200078e0253ULL, 0x00000046382c723cULL, 0x040fe2000000182cULL,
0x000000005454783bULL, 0x000fe80000004200ULL, 0x000000004444783bULL, 0x000fe60000004200ULL,
0x000000403828723cULL, 0x040fee0000001828ULL, 0x0000001011407824ULL, 0x100fe200078e0253ULL,
0x000000423824723cULL, 0x040fea0000001824ULL, 0x000000004040783bULL, 0x000fe60000004200ULL,
0x0000003c3820723cULL, 0x040fee0000001820ULL, 0x000000100f3c7824ULL, 0x000fe200078e0253ULL,
0x0000003e3838723cULL, 0x000fe20000001834ULL, 0x000000006034783bULL, 0x000e680000004200ULL,
0x000000003c3c783bULL, 0x000fe60000004200ULL, 0x0000001c1858723cULL, 0x050ff00000001858ULL,
0x0000001e1814723cULL, 0x040fe20000001814ULL, 0x012000000e1c783bULL, 0x0004ee0000000200ULL,
0x000000481830723cULL, 0x000fe20000001830ULL, 0x00023630620e7811ULL, 0x004fcc00078e20ffULL,
0x0000001012487824ULL, 0x000fe200078e0253ULL, 0x0000004a182c723cULL, 0x040fe2000000182cULL,
0x012000001310783bULL, 0x000ea80000000200ULL, 0x000000004848783bULL, 0x000f260000004200ULL,
0x0000004c1828723cULL, 0x040ff00000001828ULL, 0x0000004e1824723cULL, 0x040ff00000001824ULL,
0x000000341820723cULL, 0x002fe20000001820ULL, 0x000000511c1c8232ULL, 0x008fc40000000000ULL,
0x000000511e1e8232ULL, 0x000fe40000000000ULL, 0x000000521d1d8232ULL, 0x080fe40000000000ULL,
0x000000105c347824ULL, 0x000fe200078e0253ULL, 0x00000036184c723cULL, 0x000fe20000001838ULL,
0x000000005e38783bULL, 0x000fe20000004200ULL, 0x000000521f1f8232ULL, 0x000fc60000000000ULL,
0x000000003434783bULL, 0x000e640000004200ULL, 0x000000105d187824ULL, 0x000fe400078e0253ULL,
0x0000003c1c58723cULL, 0x040fe20000001858ULL, 0x0000005110108232ULL, 0x084fe40000000000ULL,
0x0000005112128232ULL, 0x000fe20000000000ULL, 0x000000001818783bULL, 0x000ea20000004200ULL,
0x0000005211118232ULL, 0x080fe40000000000ULL, 0x0000005213138232ULL, 0x000fe20000000000ULL,
0x000000481c20723cULL, 0x050ff00000001820ULL, 0x0000003e1c14723cULL, 0x040ff00000001814ULL,
0x000000441c30723cULL, 0x040ff00000001830ULL, 0x000000461c2c723cULL, 0x040ff0000000182cULL,
0x000000401c28723cULL, 0x040ff00000001828ULL, 0x000000421c24723cULL, 0x040ff00000001824ULL,
0x0000004a1c4c723cULL, 0x000ff0000000184cULL, 0x000000541058723cULL, 0x040ff00000001858ULL,
0x000000341020723cULL, 0x042ff00000001820ULL, 0x000000561054723cULL, 0x040ff00000001814ULL,
0x000000381030723cULL, 0x040ff00000001830ULL, 0x0000003a102c723cULL, 0x040ff0000000182cULL,
0x000000181028723cULL, 0x044ff00000001828ULL, 0x0000001a1024723cULL, 0x040ff00000001824ULL,
0x000000361034723cULL, 0x000fe2000000184cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fdc0000008000ULL,
0x000000000eff7f8cULL, 0x0003e2000c80043fULL, 0x0000000050007221ULL, 0x000fe20000010000ULL,
0x000000010c6e7812ULL, 0x000fce00078ec0ffULL, 0x0000030090907a10ULL, 0x002fe40007ffe0ffULL,
0x000000ff0aff7812ULL, 0x000fc4000780c0ffULL, 0x0000008b9000720cULL, 0x000fe40003f26070ULL,
0x00000001ff0a7807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffffb26000007947ULL, 0x000fea000383ffffULL, 0x00000000000c7919ULL, 0x002e620000000000ULL,
0x0000000262037824ULL, 0x020fc600078e00ffULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x0000000203057812ULL, 0x000fe200078e0cffULL, 0x000000808e037824ULL, 0x000fc600078e00ffULL,
0x0000000105057812ULL, 0x000fe200078ef88eULL, 0x000000100c047824ULL, 0x002fe200078e00ffULL,
0x00000001ff067819ULL, 0x100fe4000001160cULL, 0x00000002ff117819ULL, 0x000fe4000001160cULL,
0x00000070040d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c060f7812ULL, 0x000fe200078ec0ffULL,
0x0000008005067824ULL, 0x000fe200078e00ffULL, 0x000230000d047810ULL, 0x000fc40007ffe003ULL,
0x000232000d037810ULL, 0x040fe40007ffe003ULL, 0x000230000d087810ULL, 0x000fe20007ffe006ULL,
0x000000010f057824ULL, 0x040fe200078e0204ULL, 0x000000030f097210ULL, 0x000fe20007ffe0ffULL,
0x0000000000047919ULL, 0x000e620000002500ULL, 0x000232000d067810ULL, 0x000fe20007ffe006ULL,
0x000000010f087824ULL, 0x040fe400078e0208ULL, 0x0000000205007388ULL, 0x000fe40000000800ULL,
0x000000010f067824ULL, 0x000fc400078e0206ULL, 0x0000000009007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000008b0400720cULL, 0x002fca0003f06070ULL,
0x0000000008087984ULL, 0x000e680000000800ULL, 0x0000000006067984ULL, 0x000ea20000000800ULL,
0x00000002080b7209ULL, 0x002fca0007810000ULL, 0x000000020b037221ULL, 0x000fe40000010100ULL,
0x8000000b08087221ULL, 0x000fe40000010000ULL, 0x3fb8aa3b030a7820ULL, 0x000fe40000410000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x3fb8aa3b08087820ULL, 0x000fc60000410000ULL,
0x0000000a000a7308ULL, 0x000ef00000000800ULL, 0x00000008000d7308ULL, 0x000ea20000000800ULL,
0x00001f110a027589ULL, 0x008ee200000e0000ULL, 0x0000000803057811ULL, 0x002fe200078ff0ffULL,
0x0000000d060d7220ULL, 0x004fc80000410000ULL, 0x00001f050a097589ULL, 0x000e6200000e0000ULL,
0x000000000a067223ULL, 0x000fe4000001000dULL, 0x0000005802587220ULL, 0x048fe40000410000ULL,
0x0000005902597220ULL, 0x040fe40000410000ULL, 0x0000005402547220ULL, 0x040fe40000410000ULL,
0x0000005502557220ULL, 0x040fe40000410000ULL, 0x0000003002307220ULL, 0x000fc40000410000ULL,
0x0000005a095a7220ULL, 0x042fe40000410000ULL, 0x0000005b095b7220ULL, 0x040fe40000410000ULL,
0x0000005609567220ULL, 0x040fe40000410000ULL, 0x0000005709577220ULL, 0x040fe40000410000ULL,
0x0000003209327220ULL, 0x040fe40000410000ULL, 0x0000003309337220ULL, 0x000fc40000410000ULL,
0x0000002e092e7220ULL, 0x040fe40000410000ULL, 0x0000002f092f7220ULL, 0x040fe40000410000ULL,
0x0000002a092a7220ULL, 0x040fe40000410000ULL, 0x0000002b092b7220ULL, 0x040fe40000410000ULL,
0x0000002609267220ULL, 0x040fe40000410000ULL, 0x0000002709277220ULL, 0x000fc40000410000ULL,
0x0000002209227220ULL, 0x040fe40000410000ULL, 0x0000002309237220ULL, 0x040fe40000410000ULL,
0x0000003609367220ULL, 0x000fe40000410000ULL, 0x0000003102317220ULL, 0x040fe40000410000ULL,
0x0000002c022c7220ULL, 0x040fe40000410000ULL, 0x0000002d022d7220ULL, 0x000fc40000410000ULL,
0x0000002802287220ULL, 0x040fe40000410000ULL, 0x0000002902297220ULL, 0x040fe40000410000ULL,
0x0000002402247220ULL, 0x040fe40000410000ULL, 0x0000002502257220ULL, 0x040fe40000410000ULL,
0x0000002002207220ULL, 0x040fe40000410000ULL, 0x0000002102217220ULL, 0x000fc40000410000ULL,
0x0000003402347220ULL, 0x040fe40000410000ULL, 0x0000003502357220ULL, 0x000fe40000410000ULL,
0x0000003709097220ULL, 0x000fe20000410000ULL, 0x0000033000000947ULL, 0x000fea0003800000ULL,
0x0180000006007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000072f000377802ULL, 0x000fe40000000f00ULL,
0x0000ac3000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0008ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000600037308ULL, 0x000e640000001000ULL,
0xbf80000006007423ULL, 0x002fc80000000003ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x00000002ff0d7819ULL, 0x004fe40000011603ULL,
0x0000000803057811ULL, 0x000fc600078ff0ffULL, 0x00001f0d00027589ULL, 0x000ea800000e0000ULL,
0x00001f0500087589ULL, 0x000ee200000e0000ULL, 0x0000000258587220ULL, 0x084fe40000410000ULL,
0x0000000259597220ULL, 0x080fe40000410000ULL, 0x0000000254547220ULL, 0x080fe40000410000ULL,
0x0000000255557220ULL, 0x000fc40000410000ULL, 0x0000000230307220ULL, 0x080fe40000410000ULL,
0x0000000231317220ULL, 0x080fe40000410000ULL, 0x000000022c2c7220ULL, 0x080fe40000410000ULL,
0x000000022d2d7220ULL, 0x080fe40000410000ULL, 0x0000000228287220ULL, 0x080fe40000410000ULL,
0x0000000229297220ULL, 0x000fc40000410000ULL, 0x0000000224247220ULL, 0x080fe40000410000ULL,
0x0000000225257220ULL, 0x080fe40000410000ULL, 0x0000000220207220ULL, 0x080fe40000410000ULL,
0x0000000221217220ULL, 0x080fe40000410000ULL, 0x0000000234347220ULL, 0x080fe40000410000ULL,
0x0000000235357220ULL, 0x000fc40000410000ULL, 0x000000085a5a7220ULL, 0x088fe40000410000ULL,
0x000000085b5b7220ULL, 0x080fe40000410000ULL, 0x0000000856567220ULL, 0x080fe40000410000ULL,
0x0000000857577220ULL, 0x080fe40000410000ULL, 0x0000000832327220ULL, 0x080fe40000410000ULL,
0x0000000833337220ULL, 0x000fc40000410000ULL, 0x000000082e2e7220ULL, 0x080fe40000410000ULL,
0x000000082f2f7220ULL, 0x080fe40000410000ULL, 0x000000082a2a7220ULL, 0x080fe40000410000ULL,
0x000000082b2b7220ULL, 0x080fe40000410000ULL, 0x0000000826267220ULL, 0x080fe40000410000ULL,
0x0000000827277220ULL, 0x000fc40000410000ULL, 0x0000000822227220ULL, 0x080fe40000410000ULL,
0x0000000823237220ULL, 0x080fe40000410000ULL, 0x0000000836367220ULL, 0x080fe40000410000ULL,
0x0000000809097220ULL, 0x000fe40000410000ULL, 0x00000002ff197819ULL, 0x000fe20000011603ULL,
0x00000008050a7824ULL, 0x000fe200078e00ffULL, 0x0000002a2b2a723eULL, 0x000fe200000000ffULL,
0x0000000805087824ULL, 0x000fe200078e00ffULL, 0x00000005ff2b7212ULL, 0x000fe200078e33ffULL,
0x0000000819027824ULL, 0x000fe200078e00ffULL, 0x0000000705007812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000019ff1b7212ULL, 0x000fc400078e33ffULL,
0xfffffff80a2b7812ULL, 0x000fe400078ee22bULL, 0x00000003000a7812ULL, 0x000fe400078e3cffULL,
0xfffffff8021b7812ULL, 0x000fe400078ee21bULL, 0xfffffff8081d7812ULL, 0x000fe400078ee205ULL,
0x0000000100027812ULL, 0x040fe400078e3cffULL, 0x0000000200087812ULL, 0x000fc400078e3cffULL,
0x00000004000c7812ULL, 0x040fe200078e3cffULL, 0x00000008051f7824ULL, 0x000fe200078e0202ULL,
0x00000005000e7812ULL, 0x040fe400078e3cffULL, 0x0000000600007812ULL, 0x000fe400078e3cffULL,
0x000000222322723eULL, 0x000fe200000000ffULL, 0x0000000805237824ULL, 0x000fe200078e020aULL,
0x000000202120723eULL, 0x000fe200000000ffULL, 0x00000008190a7824ULL, 0x000fe200078e00ffULL,
0x000000282928723eULL, 0x000fe200000000ffULL, 0x0000000805297824ULL, 0x040fe200078e0200ULL,
0x0000000805217211ULL, 0x000fe200078e18ffULL, 0x0000000403007824ULL, 0x000fe200078e00ffULL,
0x000000242524723eULL, 0x000fe200000000ffULL, 0x0000000805257824ULL, 0x000fe200078e020cULL,
0x000000262726723eULL, 0x000fe200000000ffULL, 0x0000000805277824ULL, 0x000fe200078e020eULL,
0x0000000719087812ULL, 0x000fe200078ec0ffULL, 0x0000100007057824ULL, 0x000fe200078e00ffULL,
0xfffffff80a0d7812ULL, 0x000fc400078ee219ULL, 0x00000001080a7812ULL, 0x040fe400078e3cffULL,
0x00000002080c7812ULL, 0x000fe400078e3cffULL, 0x0000000c00027812ULL, 0x000fe200078ec0ffULL,
0x00000008190f7824ULL, 0x040fe200078e020aULL, 0x00000003080e7812ULL, 0x040fe200078e3cffULL,
0x0000000819117824ULL, 0x040fe200078e020cULL, 0x0000000508127812ULL, 0x000fe400078e3cffULL,
0x0000000562007211ULL, 0x000fe200078e58ffULL, 0x0000000819137824ULL, 0x040fe200078e020eULL,
0x0000000408107812ULL, 0x040fe200078e3cffULL, 0x0000000819177824ULL, 0x000fe200078e0212ULL,
0x0000000608087812ULL, 0x000fe200078e3cffULL, 0x000000100d0d7824ULL, 0x000fe200078e0200ULL,
0x000000585958723eULL, 0x000fe200000000ffULL, 0x0000000819157824ULL, 0x040fe200078e0210ULL,
0x0000000819197211ULL, 0x000fe200078e18ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0200ULL,
0x0000000017177211ULL, 0x000fe200078e20ffULL, 0x0000001011117824ULL, 0x100fe200078e0200ULL,
0x000000545554723eULL, 0x000fe200000000ffULL, 0x0000001013137824ULL, 0x000fe200078e0200ULL,
0x000000303130723eULL, 0x000fe200000000ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0202ULL,
0x0000002c2d2c723eULL, 0x000fe200000000ffULL, 0x0000001015157824ULL, 0x100fe200078e0200ULL,
0x000000343534723eULL, 0x000fe200000000ffULL, 0x00000001020f7824ULL, 0x040fe200078e020fULL,
0x000000580d007388ULL, 0x000fe20000000800ULL, 0x0000001019197824ULL, 0x100fe200078e0200ULL,
0x0000000025257211ULL, 0x000fe200078e20ffULL, 0x0000000102117824ULL, 0x040fe200078e0211ULL,
0x000000540f007388ULL, 0x000fe20000000800ULL, 0x000000101b1b7824ULL, 0x100fe200078e0200ULL,
0x0000005a5b5a723eULL, 0x000fe200000000ffULL, 0x0000000102137824ULL, 0x040fe200078e0213ULL,
0x0000003011007388ULL, 0x000fe20000000800ULL, 0x000000101d1d7824ULL, 0x100fe200078e0200ULL,
0x000000565756723eULL, 0x000fe200000000ffULL, 0x0000000102157824ULL, 0x040fe200078e0215ULL,
0x0000002c13007388ULL, 0x000fe20000000800ULL, 0x000000101f1f7824ULL, 0x100fe200078e0200ULL,
0x000000323332723eULL, 0x000fe200000000ffULL, 0x0000000102177824ULL, 0x040fe200078e0217ULL,
0x0000002815007388ULL, 0x000fe20000000800ULL, 0x0000001021217824ULL, 0x100fe200078e0200ULL,
0x0000002e2f2e723eULL, 0x000fe200000000ffULL, 0x0000000102197824ULL, 0x040fe200078e0219ULL,
0x0000002417007388ULL, 0x000fe20000000800ULL, 0x0000001023237824ULL, 0x000fe200078e0200ULL,
0x000000360909723eULL, 0x000fe200000000ffULL, 0x00000001021b7824ULL, 0x040fe200078e021bULL,
0x0000002019007388ULL, 0x000fe20000000800ULL, 0x00000001021d7824ULL, 0x000fc400078e021dULL,
0x0000001027277824ULL, 0x100fe200078e0200ULL, 0x000000341b007388ULL, 0x000fe20000000800ULL,
0x0000001029297824ULL, 0x100fe400078e0200ULL, 0x00000001021f7824ULL, 0x040fe200078e021fULL,
0x0000005a1d007388ULL, 0x000fe20000000800ULL, 0x0000000102217824ULL, 0x040fe200078e0221ULL,
0x0000002902297210ULL, 0x040fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0200ULL,
0x000000561f007388ULL, 0x000fe20000000800ULL, 0x0000000102237824ULL, 0x000fc400078e0223ULL,
0x0000000102257824ULL, 0x040fe200078e0225ULL, 0x0000003221007388ULL, 0x000fe20000000800ULL,
0x0000000102277824ULL, 0x040fe400078e0227ULL, 0x0000000102087824ULL, 0x000fe200078e022bULL,
0x0000002e23007388ULL, 0x000fe20000000800ULL, 0x0000002062107824ULL, 0x000fe400078e0203ULL,
0x00000001ff027424ULL, 0x000fe200078e00ffULL, 0x0000002a25007388ULL, 0x000fe40000000800ULL,
0x00000005100a7211ULL, 0x000fc400078e20ffULL, 0x0000002627007388ULL, 0x000fe20000000800ULL,
0x0000030002007a0cULL, 0x000fc60003f05270ULL, 0x0000002229007388ULL, 0x000fe80000000800ULL,
0x0000000908007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000000a0c7984ULL, 0x000ea80000000c00ULL, 0x000400000a187984ULL, 0x000ee80000000c00ULL,
0x000800000a147984ULL, 0x000f280000000c00ULL, 0x000c00000a1c7984ULL, 0x000f620000000c00ULL,
0x200000ff0f0f7230ULL, 0x004fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff1b1b7230ULL, 0x008fe40000000000ULL, 0x200000ff1a1a7230ULL, 0x000fe40000000000ULL,
0x200000ff19197230ULL, 0x000fc40000000000ULL, 0x200000ff18187230ULL, 0x000fe40000000000ULL,
0x000000170f0f7230ULL, 0x010fe40000000000ULL, 0x000000160e0e7230ULL, 0x000fe40000000000ULL,
0x000000150d0d7230ULL, 0x000fe40000000000ULL, 0x000000140c0c7230ULL, 0x000fe40000000000ULL,
0x0000001f1b1b7230ULL, 0x020fc40000000000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000000000ULL,
0x0000000c0a007388ULL, 0x0005e20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000000000ULL,
0x0000001c18187230ULL, 0x000fca0000000000ULL, 0x000400180a007388ULL, 0x0005e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000307000008947ULL, 0x000fea0003800000ULL,
0x0000000000147919ULL, 0x000ee20000002700ULL, 0x00005800ff027624ULL, 0x000fe200078e00ffULL,
0x0000000162ff7812ULL, 0x000fe2000780f88eULL, 0x00001000ff0d7424ULL, 0x004fe200078e00ffULL,
0x0000000000097919ULL, 0x000ee20000002600ULL, 0x0000030002027a24ULL, 0x000fe200078e02ffULL,
0x0000004010137810ULL, 0x000fc40007ffe0ffULL, 0x000000000a187984ULL, 0x0005220000000c00ULL,
0x0000660002087a24ULL, 0x000fe200078e02ffULL, 0x000000ff0300720cULL, 0x000fe40000725670ULL,
0x000400000a1c7984ULL, 0x0004640000000c00ULL, 0x00000fff08027811ULL, 0x000fe200078e40ffULL,
0x0000580014147a24ULL, 0x008fc800078e0209ULL, 0x0000030014097a24ULL, 0x000fc800078e02ffULL,
0x00000001090f7824ULL, 0x000fe200078e0204ULL, 0x01ffffff08047812ULL, 0x000fc800078ec0ffULL,
0x0000000f020c7211ULL, 0x000fca00078fa0ffULL, 0x00006c000c0c7625ULL, 0x000fcc00078e000dULL,
0x00000800070c7825ULL, 0x000fcc00078e000cULL, 0x0000001010107825ULL, 0x000fc800078e000cULL,
0x0000001013127825ULL, 0x000fe200078e000cULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010030a7824ULL, 0x016fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011603ULL,
0x00000080ff087424ULL, 0x000fe400078e00ffULL, 0x000000010f0e7824ULL, 0x040fe200078e0204ULL,
0x000000700a157812ULL, 0x000fe400078ec0ffULL, 0x0000000c0c0a7812ULL, 0x000fe200078ec0ffULL,
0x00006c000f0c7625ULL, 0x000fc800078e0008ULL, 0x00006c000e0e7625ULL, 0x000fe200078e0008ULL,
0x0000000c0a0c7210ULL, 0x000fc80007a1e015ULL, 0x0000000e0a0e7210ULL, 0x000fe40007c7e015ULL,
0x0000000dff0d7210ULL, 0x000fe400007e44ffULL, 0x0000000fff0f7210ULL, 0x000fc60001fe84ffULL,
0x0000000b0c007986ULL, 0x0003e8000c101906ULL, 0x000000060e007986ULL, 0x0003e4000c101906ULL,
0x0000001810007986ULL, 0x0163e2000c101d06ULL, 0x0000013000007945ULL, 0x000fe60003800000ULL,
0x0000001c12007986ULL, 0x0003e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x00000001000d7802ULL, 0x000fe20000000f00ULL,
0x00000004ff0b7424ULL, 0x000fc600078e00ffULL, 0x000003000d0d7a10ULL, 0x000fe20007ffe1ffULL,
0x00006a00140a7625ULL, 0x000fe200078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000d0a0a79a8ULL, 0x000ea400099ee1c6ULL,
0x0000000d0a00720cULL, 0x004fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff067807ULL, 0x000fca0000000000ULL, 0x00000006ff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff067984ULL, 0x004ea40000000000ULL, 0x000000ff0600720cULL, 0x004fda0003f05270ULL,
0x00002ca000008947ULL, 0x000fea0003800000ULL, 0x000000ff8e00720cULL, 0x000fda0003f05270ULL,
0x00000d6000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000038000008947ULL, 0x000fea0003800000ULL, 0x00000001090c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fe20000011603ULL,
0x00000080ff197424ULL, 0x002fc600078e00ffULL, 0x00000070061b7812ULL, 0x000fe200078ec0ffULL,
0x00006c00090a7625ULL, 0x000fe200078e0019ULL, 0x0000000c08087812ULL, 0x000fc600078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fe200078e0019ULL, 0x0000000a080a7210ULL, 0x000fc8000791e01bULL,
0x0000000c080c7210ULL, 0x000fe40007b5e01bULL, 0x0000000bff0b7210ULL, 0x000fe400007e24ffULL,
0x0000000dff0d7210ULL, 0x000fc600017e64ffULL, 0x000000060a067981ULL, 0x000368000c1e1900ULL,
0x000000060c0f7981ULL, 0x000362000c1e1900ULL, 0x00000300ff0e7624ULL, 0x000fca00078e00ffULL,
0x000000020e00780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002090a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a080a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a117981ULL, 0x000362000c1e1900ULL, 0x000000040e00780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003090a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a080a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a137981ULL, 0x000362000c1e1900ULL,
0x000000040e00780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004090a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a080a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a157981ULL, 0x000362000c1e1900ULL, 0x000000060e00780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005090a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a080a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a177981ULL, 0x000362000c1e1900ULL,
0x000000060e00780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000080e00780cULL, 0x002fe40003f06070ULL, 0x00000006090a7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a080a7210ULL, 0x000fe40007a3e01bULL,
0x00000007090c0810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL,
0x00006c000c0c0625ULL, 0x000fe400078e0019ULL, 0x000000060a197981ULL, 0x000366000c1e1900ULL,
0x0000000c080c0210ULL, 0x000fc80007c7e01bULL, 0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL,
0x000000060c1b0981ULL, 0x000368000c1e1900ULL, 0x0000030000047ab9ULL, 0x002fe40000000800ULL,
0x0000000704047890ULL, 0x000fc8000fffe03fULL, 0x000000033f047899ULL, 0x000fcc0008011604ULL,
0x00000004ff007c0cULL, 0x000fda000bf05270ULL, 0x0000090000008947ULL, 0x000fea0003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x000000ff00127202ULL, 0x000fe20000000f00ULL,
0x000000ffff087224ULL, 0x000fe400078e0009ULL, 0x000000ffff0d7224ULL, 0x020fe400078e0006ULL,
0x0000030010007a0cULL, 0x000fe40003f26070ULL, 0x0000000112127810ULL, 0x000fc80007ffe0ffULL,
0x0000000412007c0cULL, 0x000fce000bf06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x00000008100a7810ULL, 0x040fe40007ffe0ffULL, 0x00000001100b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000000d06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000008080a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000010030c7824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fc80007b3e00dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a0d7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x00000009100a7810ULL, 0x042fe40007ffe0ffULL,
0x00000002100b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000f06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000009080a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000010030c7824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a0f7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a100a7810ULL, 0x042fe40007ffe0ffULL, 0x00000003100b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001106067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000a080a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000010030c7824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c117812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a117981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b100a7810ULL, 0x042fe40007ffe0ffULL,
0x00000004100b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001306067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000b080a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000004030c7819ULL, 0x000fe400000006ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x000000700c137812ULL, 0x000fe400078ec0ffULL, 0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fc80007b3e013ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a137981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c100a7810ULL, 0x042fe40007ffe0ffULL, 0x00000005100b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001506067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000c080a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000010030c7824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c157812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fc80007b3e015ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a157981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d100a7810ULL, 0x042fe40007ffe0ffULL,
0x00000006100b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001706067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000d080a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000010030c7824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c177812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fc80007b3e017ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a177981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e100a7810ULL, 0x042fe40007ffe0ffULL, 0x00000007100b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001906067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000e080a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000010030c7824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c197812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fc80007b3e019ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a197981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f100a7810ULL, 0x002fe40007ffe0ffULL,
0x0000001b06067209ULL, 0x000fe40007810000ULL, 0x000003000a007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000f080a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000004030c7819ULL, 0x000fe400000006ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x000000700c1b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fc80007a3e01bULL, 0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL,
0x000000060a1b7981ULL, 0x000368000c1e1900ULL, 0x0000000810107810ULL, 0x000fe40007ffe0ffULL,
0x0000000808087810ULL, 0x000fe20007ffe0ffULL, 0xfffff74000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x0000001003087824ULL, 0x004fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x002fc80000011603ULL, 0x0000007008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a0b7812ULL, 0x000fca00078ec0ffULL, 0x00000001080b7824ULL, 0x000fca00078e020bULL,
0x000000060b007388ULL, 0x0203e40000000800ULL, 0x0000001003067824ULL, 0x042fe200078e00ffULL,
0x00000001ff087819ULL, 0x000fe20000011603ULL, 0x0000000162177824ULL, 0x000fe200078e0209ULL,
0x000000070300780cULL, 0x040fe20003f04070ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000c080b7812ULL, 0x000fe200078ec0ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000017020a7211ULL, 0x000fe200078fa0ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000002ff087819ULL, 0x000fe2000001168eULL, 0x0000000106187824ULL, 0x000fe200078e020bULL,
0x0000004003117810ULL, 0x040fe20007ffe0ffULL, 0x00001000ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000108067812ULL, 0x000fe200078ec0ffULL, 0x00000002620d8824ULL, 0x040fe200078e0207ULL,
0x00000007620f8211ULL, 0x000fe200078e08ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000006003137810ULL, 0x000fe20007ffe0ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000030062007a0cULL, 0x000fe20003f26070ULL, 0x0000080008087824ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000020d148824ULL, 0x100fe200078e0206ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000000020f1a8824ULL, 0x000fe200078e0206ULL,
0x00000800080d7812ULL, 0x000fe200078ec0ffULL, 0x00000800070a7825ULL, 0x000fe200078e000aULL,
0x00000020030f7810ULL, 0x000fc60007ffe0ffULL, 0x0000200062067824ULL, 0x000fe400078e0205ULL,
0x0000000104108824ULL, 0x000fe400078e0217ULL, 0x00000080ff158424ULL, 0x000fe400078e00ffULL,
0x0000000106087824ULL, 0x000fe400078e020dULL, 0x00000080ff168424ULL, 0x000fe400078e00ffULL,
0x000000100f0c7825ULL, 0x000fe200078e000aULL, 0x0000000803197211ULL, 0x000fc400078e20ffULL,
0x0000000018087984ULL, 0x0002a20000000800ULL, 0x00000010110e7825ULL, 0x000fc800078e000aULL,
0x00006c0010108625ULL, 0x000fc800078e0015ULL, 0x0000001013127825ULL, 0x000fc800078e000aULL,
0x00006c0017168625ULL, 0x000fc800078e0016ULL, 0x00000008141b8824ULL, 0x000fe400078e0203ULL,
0x00000010030a7825ULL, 0x000fc600078e000aULL, 0x000045801b1b8811ULL, 0x000fe200078e20ffULL,
0x000000081a1a8824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a197faeULL, 0x0007e2000b901c46ULL, 0x0000001003148825ULL, 0x040fe400078e0010ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x000041801a1d8811ULL, 0x000fe200078e20ffULL,
0x0000001003168825ULL, 0x000fe200078e0016ULL, 0x003800000c197faeULL, 0x0009e6000b901c46ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x005800000e197faeULL, 0x000be2000b901c46ULL,
0x00000000000a7805ULL, 0x008fc6000001ff00ULL, 0x0078000012197faeULL, 0x0007e8000b901c46ULL,
0x00000000141b8faeULL, 0x0005e2000b901c46ULL, 0x00000000000c7805ULL, 0x010fc6000001ff00ULL,
0x00000000161d8faeULL, 0x0009e2000b901c46ULL, 0x00000000000e7805ULL, 0x020fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000127805ULL, 0x008fe2000001ff00ULL,
0x0000000000187805ULL, 0x002fe2000001ff00ULL, 0x0000000000147805ULL, 0x004fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x010fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000df000001947ULL, 0x000fea0003800000ULL,
0x00000de000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe400078e00ffULL,
0x000000ffff2f7224ULL, 0x000fca00078e0062ULL, 0x000000022f2e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff417224ULL, 0x000fe200078e002fULL, 0x00000002ff2c7819ULL, 0x002fe20000011603ULL,
0x0000041000017945ULL, 0x000fe20003800000ULL, 0x000003002e007a0cULL, 0x000fe20003f06070ULL,
0x00000040412d7824ULL, 0x000fe200078e00ffULL, 0x000000072c487812ULL, 0x040fe200078ec0ffULL,
0x000000082c317824ULL, 0x008fe200078e00ffULL, 0x0000000762307211ULL, 0x000fe200078e08ffULL,
0x000000082c2b7824ULL, 0x040fe200078e00ffULL, 0x000000802d2d7812ULL, 0x000fe200078ec0ffULL,
0x000000082c4e7824ULL, 0x000fe200078e00ffULL, 0x0000002cff2f7212ULL, 0x000fe200078e33ffULL,
0x0000001003437824ULL, 0x000fe200078e00ffULL, 0xfffffff8313c7812ULL, 0x100fe200078ee248ULL,
0x00000100303f7824ULL, 0x000fe200078e002dULL, 0x000000012b3e7812ULL, 0x000fc400078ef648ULL,
0x000000022b407812ULL, 0x140fe400078ef648ULL, 0x000000032b427812ULL, 0x140fe400078ef648ULL,
0x000000042b447812ULL, 0x140fe400078ef648ULL, 0x000000052b467812ULL, 0x140fe400078ef648ULL,
0x000000062b487812ULL, 0x000fe400078ef648ULL, 0xfffffff84e4e7812ULL, 0x000fc400078ee22fULL,
0x000000082c2b7810ULL, 0x000fe20007ffe0ffULL, 0x000002b000000947ULL, 0x000fea0003800000ULL,
0x000000070300780cULL, 0x000fe20003f04070ULL, 0x00000001093b7824ULL, 0x100fe200078e022eULL,
0x00000001ff2d7819ULL, 0x000fe4000001162eULL, 0x0000100000317802ULL, 0x000fe40000000f00ULL,
0x000000012d2d7812ULL, 0x000fe400078ec0ffULL, 0x0000003b02307211ULL, 0x000fe400078fa0ffULL,
0x0000002003357810ULL, 0x000fc40007ffe0ffULL, 0x0000004003377810ULL, 0x040fe20007ffe0ffULL,
0x00000002624a8824ULL, 0x140fe200078e0207ULL, 0x00000060032f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000262328824ULL, 0x000fe400078e0207ULL, 0x000000024a4a8824ULL, 0x100fe400078e022dULL,
0x00000002324c8824ULL, 0x000fe400078e022dULL, 0x000004002e2d7824ULL, 0x000fe400078e00ffULL,
0x00006c0030307625ULL, 0x000fc600078e0031ULL, 0x000008002d2d7812ULL, 0x000fe200078ec0ffULL,
0x0000000104388824ULL, 0x000fe400078e023bULL, 0x0000080007307825ULL, 0x000fe200078e0030ULL,
0x0000002d06327210ULL, 0x000fc60007ffe0ffULL, 0x00000080ff398424ULL, 0x000fe400078e00ffULL,
0x00000080ff3a8424ULL, 0x000fe400078e00ffULL, 0x00000010032d7824ULL, 0x040fe400078e0232ULL,
0x0000001003327825ULL, 0x000fc800078e0030ULL, 0x0000001035347825ULL, 0x100fe200078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000322d7faeULL, 0x0003e6000b901c46ULL,
0x0000001037367825ULL, 0x100fe200078e0030ULL, 0x00380000342d7faeULL, 0x0003e6000b901c46ULL,
0x00006c0038388625ULL, 0x000fe200078e0039ULL, 0x00580000362d7faeULL, 0x0003e6000b901c46ULL,
0x000000102f307825ULL, 0x000fc800078e0030ULL, 0x00006c003b3a8625ULL, 0x000fe200078e003aULL,
0x00780000302d7faeULL, 0x0003e6000b901c46ULL, 0x000000084a2f8824ULL, 0x100fe400078e0203ULL,
0x000000084c3d8824ULL, 0x000fe400078e0203ULL, 0x0000001003388825ULL, 0x000fe200078e0038ULL,
0x000045802f2f8811ULL, 0x000fe400078e20ffULL, 0x000041803d3d8811ULL, 0x000fe200078e20ffULL,
0x00000010033a8825ULL, 0x000fc400078e003aULL, 0x00000000382f8faeULL, 0x0003e8000b901c46ULL,
0x000000003a3d8faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000001ff307819ULL, 0x002fe20000011603ULL,
0x00000400412d7824ULL, 0x000fe200078e00ffULL, 0x00000070434c7812ULL, 0x000fe200078ec0ffULL,
0x000000082b347824ULL, 0x040fe200078e00ffULL, 0x0000000c30317812ULL, 0x000fe200078ec0ffULL,
0x000000082b327824ULL, 0x040fe200078e00ffULL, 0x000000072b2f7812ULL, 0x040fe200078ec0ffULL,
0x000000082b337824ULL, 0x000fe200078e00ffULL, 0x0000003f313f7210ULL, 0x000fc40007ffe04cULL,
0x000008002d2d7812ULL, 0x000fe400078ec0ffULL, 0xfffffff834307812ULL, 0x100fe400078ee22fULL,
0x0000000132347812ULL, 0x140fe400078ef62fULL, 0x0000000232367812ULL, 0x140fe400078ef62fULL,
0x0000000332387812ULL, 0x140fe400078ef62fULL, 0x00000004323a7812ULL, 0x000fc400078ef62fULL,
0x00000005324a7812ULL, 0x000fe200078ef62fULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180003f317984ULL, 0x000fe20000000800ULL, 0x0000000632327812ULL, 0x000fe400078ef62fULL,
0x0000002bff4c7212ULL, 0x000fe400078e33ffULL, 0x00000002032f7819ULL, 0x000fe400000006ffULL,
0x00000180062d7810ULL, 0x000fe40007ffe02dULL, 0xfffffff8334c7812ULL, 0x000fe400078ee24cULL,
0x0000000c2f337812ULL, 0x000fe200078ec0ffULL, 0x000000103c3c7824ULL, 0x100fe200078e022dULL,
0x0000002d48487211ULL, 0x080fe200078e20ffULL, 0x000000103e3e7824ULL, 0x100fe200078e022dULL,
0x0000002d4e2f7211ULL, 0x000fe200078e20ffULL, 0x0000001040407824ULL, 0x100fe200078e022dULL,
0x0000004833487210ULL, 0x000fe20007ffe0ffULL, 0x0000001042427824ULL, 0x100fe200078e022dULL,
0x004580003f4e7984ULL, 0x000fe20000000800ULL, 0x0000001044447824ULL, 0x000fc400078e022dULL,
0x0000001046467824ULL, 0x100fe200078e022dULL, 0x0000000048487984ULL, 0x000e620000000800ULL,
0x0000001036367824ULL, 0x100fe400078e022dULL, 0x0000001038387824ULL, 0x100fe400078e022dULL,
0x000000103a3a7824ULL, 0x100fe400078e022dULL, 0x000000104a4a7824ULL, 0x100fe400078e022dULL,
0x0000001032327824ULL, 0x000fc400078e022dULL, 0x000000104c4c7824ULL, 0x100fe400078e022dULL,
0x0000001030307824ULL, 0x100fe200078e022dULL, 0x0000003233327210ULL, 0x040fe20007ffe0ffULL,
0x0000001034347824ULL, 0x000fe400078e022dULL, 0x00000001333c7824ULL, 0x040fe400078e023cULL,
0x00000001333e7824ULL, 0x040fe200078e023eULL, 0x0000000032327984ULL, 0x000ea20000000800ULL,
0x0000000133407824ULL, 0x000fc400078e0240ULL, 0x0000000133427824ULL, 0x040fe200078e0242ULL,
0x000000003c3c7984ULL, 0x000ee20000000800ULL, 0x0000000133447824ULL, 0x040fe400078e0244ULL,
0x0000000133467824ULL, 0x040fe200078e0246ULL, 0x000000003e3e7984ULL, 0x000f220000000800ULL,
0x0000000133367824ULL, 0x040fe400078e0236ULL, 0x0000000133387824ULL, 0x040fe200078e0238ULL,
0x0000000040407984ULL, 0x000f620000000800ULL, 0x00000001333a7824ULL, 0x000fc400078e023aULL,
0x00000001334a7824ULL, 0x040fe200078e024aULL, 0x0000000042427984ULL, 0x000f620000000800ULL,
0x00000001334c7824ULL, 0x040fe400078e024cULL, 0x0000000133307824ULL, 0x040fe200078e0230ULL,
0x0000000044447984ULL, 0x000f620000000800ULL, 0x0000000133347824ULL, 0x040fe200078e0234ULL,
0x30000048ff457230ULL, 0x002fe20000004100ULL, 0x00000001332f7824ULL, 0x000fe200078e022fULL,
0x0000000046467984ULL, 0x000e620000000800ULL, 0x0000003108317221ULL, 0x000fc60000010100ULL,
0x0000000036367984ULL, 0x000e620000000800ULL, 0x3fb8aa3b31317820ULL, 0x000fc60000410000ULL,
0x0000000038387984ULL, 0x000e660000000800ULL, 0x0000003100317308ULL, 0x000f220000000800ULL,
0x000000003a3a7984ULL, 0x000e680000000800ULL, 0x000000004a4a7984ULL, 0x000e620000000800ULL,
0x20000032ff587230ULL, 0x104fe40000004100ULL, 0x30000032ff4d7230ULL, 0x000fe20000004100ULL,
0x000000004c4c7984ULL, 0x000ea20000000800ULL, 0x2000003cff357230ULL, 0x008fc40000004100ULL,
0x3000003cff377230ULL, 0x000fe20000004100ULL, 0x000000002f2d7984ULL, 0x0006a20000000800ULL,
0x2000003eff397230ULL, 0x110fe20000004100ULL, 0x0000004e31317220ULL, 0x000fe40000410000ULL,
0x0000000030307984ULL, 0x000f220000000800ULL, 0x3000003eff3b7230ULL, 0x000fe40000004100ULL,
0x20000040ff3c7230ULL, 0x120fe20000004100ULL, 0x0000000034347984ULL, 0x000f620000000800ULL,
0x000000ffff2f7224ULL, 0x008fe200078e002eULL, 0x30000040ff3d7230ULL, 0x000fe20000004100ULL,
0x0000002a312a7221ULL, 0x000fe20000010000ULL, 0x20000042ff3e7230ULL, 0x000fc40000004100ULL,
0x30000042ff3f7230ULL, 0x000fe20000004100ULL, 0x000003002f007a0cULL, 0x000fe20003f06070ULL,
0x20000044ff407230ULL, 0x100fe40000004100ULL, 0x30000044ff417230ULL, 0x000fe40000004100ULL,
0x20000046ff427230ULL, 0x102fe40000004100ULL, 0x30000046ff437230ULL, 0x000fe40000004100ULL,
0x20000048ff447230ULL, 0x000fc40000004100ULL, 0x20000036ff507230ULL, 0x000fe40000004100ULL,
0x20000038ff527230ULL, 0x000fe40000004100ULL, 0x2000003aff547230ULL, 0x000fe40000004100ULL,
0x2000004aff567230ULL, 0x000fe40000004100ULL, 0x30000036ff367230ULL, 0x000fe40000004100ULL,
0x2000004cff5a7230ULL, 0x004fc40000004100ULL, 0x30000038ff387230ULL, 0x000fe40000004100ULL,
0x2000002dff467230ULL, 0x100fe40000004100ULL, 0x3000002dff477230ULL, 0x000fe40000004100ULL,
0x20000030ff487230ULL, 0x110fe40000004100ULL, 0x30000030ff497230ULL, 0x000fe40000004100ULL,
0x20000034ff4e7230ULL, 0x020fc40000004100ULL, 0x30000034ff4b7230ULL, 0x000fe40000004100ULL,
0x3000003aff3a7230ULL, 0x000fe40000004100ULL, 0x3000004aff4a7230ULL, 0x000fe40000004100ULL,
0x3000004cff4c7230ULL, 0x000fe20000004100ULL, 0x000079827f007947ULL, 0x000fea000b800000ULL,
0x00001f2c312e7589ULL, 0x0002a400000e0000ULL, 0x000079d27f007947ULL, 0x000fea000b800000ULL,
0x00001f2b312b7589ULL, 0x00072400000e0000ULL, 0x0000002e35297223ULL, 0x084fe40000010029ULL,
0x0000002e37287223ULL, 0x080fe40000010028ULL, 0x0000002e39257223ULL, 0x000fc40000010025ULL,
0x0000002e3b247223ULL, 0x080fe40000010024ULL, 0x0000002e3c217223ULL, 0x080fe40000010021ULL,
0x0000002e3d207223ULL, 0x080fe40000010020ULL, 0x0000002e3e1d7223ULL, 0x080fe4000001001dULL,
0x0000002e3f1c7223ULL, 0x080fe4000001001cULL, 0x0000002e40197223ULL, 0x000fc40000010019ULL,
0x0000002e41187223ULL, 0x080fe40000010018ULL, 0x0000002e42157223ULL, 0x080fe40000010015ULL,
0x0000002e43147223ULL, 0x080fe40000010014ULL, 0x0000002e44117223ULL, 0x080fe40000010011ULL,
0x0000002e45107223ULL, 0x080fe40000010010ULL, 0x0000002e460d7223ULL, 0x000fc4000001000dULL,
0x0000002e470c7223ULL, 0x000fe4000001000cULL, 0x0000002b48277223ULL, 0x090fe40000010027ULL,
0x0000002b49267223ULL, 0x080fe40000010026ULL, 0x0000002b4e237223ULL, 0x080fe40000010023ULL,
0x0000002b4b227223ULL, 0x080fe40000010022ULL, 0x0000002b501f7223ULL, 0x000fc4000001001fULL,
0x0000002b361e7223ULL, 0x080fe4000001001eULL, 0x0000002b521b7223ULL, 0x080fe4000001001bULL,
0x0000002b381a7223ULL, 0x080fe4000001001aULL, 0x0000002b54177223ULL, 0x080fe40000010017ULL,
0x0000002b3a167223ULL, 0x080fe40000010016ULL, 0x0000002b56137223ULL, 0x000fc40000010013ULL,
0x0000002b4a127223ULL, 0x080fe40000010012ULL, 0x0000002b580f7223ULL, 0x080fe4000001000fULL,
0x0000002b4d0e7223ULL, 0x080fe4000001000eULL, 0x0000002b5a0b7223ULL, 0x080fe4000001000bULL,
0x0000002b4c0a7223ULL, 0x000fe2000001000aULL, 0xfffff25000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000ea20000000000ULL,
0x000000ff0700720cULL, 0x000fe20003f05270ULL, 0x0000001002037824ULL, 0x004fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011602ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c02027812ULL, 0x000fca00078ec0ffULL, 0x0000000103047824ULL, 0x000fe200078e0202ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000ea40000000000ULL,
0x0000001002037824ULL, 0x004fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fc80000011602ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c02027812ULL, 0x000fc600078ec0ffULL,
0x0000008062037824ULL, 0x000fc800078e0203ULL, 0x0000000103037824ULL, 0x000fca00078e0202ULL,
0x0049802a03007388ULL, 0x0005e40000000800ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0049800004027984ULL, 0x000f280000000800ULL, 0x004a000004037984ULL, 0x004ea20000000800ULL,
0x00000002ff027221ULL, 0x010fc80000010000ULL, 0x0000000302027221ULL, 0x004fca0000010000ULL,
0x0180000002037810ULL, 0x000fc80007ffe0ffULL, 0x7f80000003037812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x0000000200067202ULL, 0x000fe40000000f00ULL,
0x0000a3c000377802ULL, 0x000fe40000000f00ULL, 0x00007b6000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff047224ULL, 0x000fe200078e0008ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000200037308ULL, 0x000ea40000001000ULL, 0xbf80000002047423ULL, 0x004fc80000000003ULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x0000000403047223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000008032b7811ULL, 0x004fe400078ff0ffULL,
0x00000002ff097819ULL, 0x000fe40000011603ULL, 0x0000002bff087212ULL, 0x000fe200078e33ffULL,
0x00001f2b04067589ULL, 0x002e6200000e0000ULL, 0x000000082b2f7824ULL, 0x000fc400078e00ffULL,
0x00000008092d7824ULL, 0x000fe200078e00ffULL, 0x00001f0904027589ULL, 0x00052200000e0000ULL,
0x000000082b2e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee208ULL,
0x0000000809087824ULL, 0x000fc800078e00ffULL, 0x000000102f2f7824ULL, 0x000fe200078e0200ULL,
0x00000009ff047212ULL, 0x004fc800078e33ffULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee204ULL,
0x0000000709047812ULL, 0x000fc600078ec0ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0200ULL,
0x00000004042a7812ULL, 0x000fe200078e3cffULL, 0x0000002706277220ULL, 0x002fe20000410000ULL,
0x00000005042c7812ULL, 0x000fe200078e3cffULL, 0x0000002606267220ULL, 0x040fe40000410000ULL,
0x0000002306237220ULL, 0x040fe40000410000ULL, 0x0000002206227220ULL, 0x000fe20000410000ULL,
0x000000272626723eULL, 0x000fe200000000ffULL, 0x0000001f061f7220ULL, 0x000fc40000410000ULL,
0x0000001e061e7220ULL, 0x000fe20000410000ULL, 0x000000232222723eULL, 0x000fe200000000ffULL,
0x0000001b061b7220ULL, 0x040fe40000410000ULL, 0x0000001a061a7220ULL, 0x000fe20000410000ULL,
0x0000001f1e1e723eULL, 0x000fe200000000ffULL, 0x0000001706177220ULL, 0x040fe40000410000ULL,
0x0000001606167220ULL, 0x000fe20000410000ULL, 0x0000001b1a1a723eULL, 0x000fe200000000ffULL,
0x0000001306137220ULL, 0x000fc40000410000ULL, 0x0000001206127220ULL, 0x000fe20000410000ULL,
0x000000171616723eULL, 0x000fe200000000ffULL, 0x0000000f060f7220ULL, 0x000fe20000410000ULL,
0xfffffff82e177812ULL, 0x000fe200078ee22bULL, 0x0000000e060e7220ULL, 0x000fe20000410000ULL,
0x000000131212723eULL, 0x000fe200000000ffULL, 0x0000000b060b7220ULL, 0x040fe40000410000ULL,
0x0000000a06067220ULL, 0x000fe20000410000ULL, 0x00000002040a7812ULL, 0x000fe200078e3cffULL,
0x0000002902297220ULL, 0x010fe20000410000ULL, 0x0000000f0e0e723eULL, 0x000fe200000000ffULL,
0x0000002802287220ULL, 0x000fe20000410000ULL, 0x0000000b0606723eULL, 0x000fe200000000ffULL,
0x0000002502257220ULL, 0x000fe20000410000ULL, 0xfffffff8080b7812ULL, 0x000fe200078ee209ULL,
0x0000002402247220ULL, 0x000fe20000410000ULL, 0x0000000104087812ULL, 0x000fe200078e3cffULL,
0x0000002102217220ULL, 0x000fe20000410000ULL, 0x000000292828723eULL, 0x000fe200000000ffULL,
0x0000002002207220ULL, 0x000fe20000410000ULL, 0x000000252424723eULL, 0x000fe200000000ffULL,
0x0000001d021d7220ULL, 0x000fc40000410000ULL, 0x0000001c021c7220ULL, 0x000fe20000410000ULL,
0x000000212020723eULL, 0x000fe200000000ffULL, 0x0000001902197220ULL, 0x040fe40000410000ULL,
0x0000001802187220ULL, 0x000fe20000410000ULL, 0x0000001d1c1c723eULL, 0x000fe200000000ffULL,
0x0000001502157220ULL, 0x040fe40000410000ULL, 0x0000001402147220ULL, 0x000fe20000410000ULL,
0x000000191818723eULL, 0x000fe200000000ffULL, 0x0000001102117220ULL, 0x040fe20000410000ULL,
0x000000072b197812ULL, 0x000fe200078ec0ffULL, 0x0000001002107220ULL, 0x000fe20000410000ULL,
0x000000151414723eULL, 0x000fe200000000ffULL, 0x0000000d020d7220ULL, 0x040fe20000410000ULL,
0x00000006192e7812ULL, 0x000fe200078e3cffULL, 0x0000000c02027220ULL, 0x000fe20000410000ULL,
0x00000003040c7812ULL, 0x040fe200078e3cffULL, 0x00000008090f7824ULL, 0x040fe200078e020aULL,
0x0000000604047812ULL, 0x000fe200078e3cffULL, 0x0000000809137824ULL, 0x040fe200078e022aULL,
0x000000111010723eULL, 0x000fe200000000ffULL, 0x0000000809157824ULL, 0x040fe200078e022cULL,
0x0000000d0202723eULL, 0x000fe200000000ffULL, 0x00000008090d7824ULL, 0x040fe200078e0208ULL,
0x0000000c09117211ULL, 0x040fe200078e18ffULL, 0x0000000809097824ULL, 0x000fe200078e0204ULL,
0x0000000119087812ULL, 0x000fe200078e3cffULL, 0x0000000403047824ULL, 0x000fe200078e00ffULL,
0x00000003190c7812ULL, 0x000fe200078e3cffULL, 0x000000100b0b7824ULL, 0x100fe200078e0200ULL,
0x000000000d0d7211ULL, 0x000fe200078e20ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0200ULL,
0x0000000c04047812ULL, 0x000fe200078ec0ffULL, 0x0000001011117824ULL, 0x100fe200078e0200ULL,
0x00000002190a7812ULL, 0x000fe200078e3cffULL, 0x0000001013137824ULL, 0x000fe200078e0200ULL,
0x00000004192a7812ULL, 0x000fe200078e3cffULL, 0x000000010b0b7824ULL, 0x000fe200078e0204ULL,
0x00000005192c7812ULL, 0x000fe200078e3cffULL, 0x000000082b197824ULL, 0x040fe200078e0208ULL,
0x0000002a2b1f7211ULL, 0x040fe200078e18ffULL, 0x000000082b1d7824ULL, 0x000fe200078e020cULL,
0x0000000f040f7210ULL, 0x040fe20007ffe0ffULL, 0x0000001015157824ULL, 0x000fe200078e0200ULL,
0x000000280b007388ULL, 0x000fe20000000800ULL, 0x00000001040d7824ULL, 0x000fe200078e020dULL,
0x000000001d1d7211ULL, 0x000fe200078e20ffULL, 0x000000082b1b7824ULL, 0x000fc400078e020aULL,
0x0000001009097824ULL, 0x100fe200078e0200ULL, 0x000000240d007388ULL, 0x000fe20000000800ULL,
0x0000000104117824ULL, 0x040fe400078e0211ULL, 0x0000001017177824ULL, 0x000fe200078e0200ULL,
0x000000200f007388ULL, 0x000fe20000000800ULL, 0x0000000104137824ULL, 0x000fe400078e0213ULL,
0x000000082b217824ULL, 0x000fe200078e022cULL, 0x0000001c11007388ULL, 0x000fe20000000800ULL,
0x0000001019197824ULL, 0x000fc400078e0200ULL, 0x0000000104157824ULL, 0x040fe200078e0215ULL,
0x0000001813007388ULL, 0x000fe20000000800ULL, 0x000000082b2b7824ULL, 0x000fe400078e022eULL,
0x000000101b1b7824ULL, 0x100fe200078e0200ULL, 0x0000001415007388ULL, 0x000fe20000000800ULL,
0x0000000104097824ULL, 0x040fe400078e0209ULL, 0x000000101f1f7824ULL, 0x000fe400078e0200ULL,
0x00000001042d7824ULL, 0x040fe200078e022dULL, 0x0000001009007388ULL, 0x000fe20000000800ULL,
0x0000000104177824ULL, 0x000fc400078e0217ULL, 0x0000001021217824ULL, 0x100fe200078e0200ULL,
0x000000022d007388ULL, 0x000fe20000000800ULL, 0x0000000104197824ULL, 0x040fe400078e0219ULL,
0x000000102b237824ULL, 0x000fe200078e0200ULL, 0x0000001f042b7210ULL, 0x040fe20007ffe0ffULL,
0x00000001041b7824ULL, 0x040fe200078e021bULL, 0x0000002617007388ULL, 0x000fe20000000800ULL,
0x0000000104297824ULL, 0x040fe400078e021dULL, 0x0000000104337824ULL, 0x040fe200078e022fULL,
0x0000002219007388ULL, 0x000fe20000000800ULL, 0x00000001042f7824ULL, 0x000fc400078e0221ULL,
0x0000000104317824ULL, 0x008fe200078e0223ULL, 0x0000001e1b007388ULL, 0x000fe20000000800ULL,
0x0000002062007824ULL, 0x000fc600078e0203ULL, 0x0000001a29007388ULL, 0x000fe20000000800ULL,
0x0000001000007824ULL, 0x000fc600078e0205ULL, 0x000000162b007388ULL, 0x000fe80000000800ULL,
0x000000122f007388ULL, 0x000fe80000000800ULL, 0x0000000e31007388ULL, 0x000fe80000000800ULL,
0x0000000633007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000087984ULL, 0x000e680000000c00ULL, 0x0004000000247984ULL, 0x000ea80000000c00ULL,
0x0008000000207984ULL, 0x000ee80000000c00ULL, 0x000c0000001c7984ULL, 0x000f220000000c00ULL,
0x200000ff0b0b7230ULL, 0x002fc40000000000ULL, 0x200000ff0a0a7230ULL, 0x000fe40000000000ULL,
0x200000ff09097230ULL, 0x000fe40000000000ULL, 0x200000ff08087230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x004fe40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fc40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x000000230b0b7230ULL, 0x008fe40000000000ULL, 0x000000220a0a7230ULL, 0x000fe40000000000ULL,
0x0000002109097230ULL, 0x000fe40000000000ULL, 0x0000002008087230ULL, 0x000fe40000000000ULL,
0x0000001f27277230ULL, 0x010fc40000000000ULL, 0x0000001e26267230ULL, 0x000fe20000000000ULL,
0x0000000800007388ULL, 0x0003e20000000c00ULL, 0x0000001d25257230ULL, 0x000fe40000000000ULL,
0x0000001c24247230ULL, 0x000fca0000000000ULL, 0x0004002400007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff6200720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000197919ULL, 0x006e620000002600ULL,
0x00000020031b7810ULL, 0x040fe20007ffe0ffULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x00000040031d7810ULL, 0x040fe20007ffe0ffULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x00000060031f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x00000003ff027819ULL, 0x000fe20000011603ULL, 0x00000008071a7824ULL, 0x040fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fe2000001161bULL, 0x00000008071c7824ULL, 0x040fe200078e00ffULL,
0x00000003ff067819ULL, 0x000fe2000001161dULL, 0x00000008071e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff187819ULL, 0x000fc4000001161fULL, 0x00000007020a7812ULL, 0x000fe400078e4803ULL,
0x0000000706087812ULL, 0x000fe400078e481dULL, 0x0ffffff80a0e7812ULL, 0x000fe400078ef803ULL,
0x0ffffff8080a7812ULL, 0x000fe400078ef81dULL, 0xfffffff81a217812ULL, 0x000fe200078ee203ULL,
0x0000001019097824ULL, 0x042fe200078e00ffULL, 0x000000050a107211ULL, 0x000fe200078e20ffULL,
0x000000100e087824ULL, 0x000fe200078e0205ULL, 0x00000004050472a4ULL, 0x004fe2000f8e023fULL,
0x0000001019237824ULL, 0x000fe200078e00ffULL, 0xfffffff009007812ULL, 0x000fc400078ee202ULL,
0x0000000704027812ULL, 0x000fe200078e481bULL, 0x0000000010107984ULL, 0x000fe20000000c00ULL,
0x0000000718097812ULL, 0x000fe400078e481fULL, 0x0ffffff802027812ULL, 0x000fe400078ef81bULL,
0x0ffffff8090c7812ULL, 0x000fe400078ef81fULL, 0x0000000008087984ULL, 0x000e620000000c00ULL,
0x0000001002027824ULL, 0x100fe200078e0205ULL, 0x0000000400007c10ULL, 0x000fe2000ff1e0ffULL,
0x000000100c147824ULL, 0x000fe200078e0205ULL, 0xfffffff023067812ULL, 0x000fe200078ee206ULL,
0x0000001019057824ULL, 0x040fe200078e00ffULL, 0x00000000020c7984ULL, 0x0004e20000000c00ULL,
0x0000001019197824ULL, 0x000fe200078e00ffULL, 0x000000ffff037210ULL, 0x000fc400007fe4ffULL,
0x0000000014147984ULL, 0x000f220000000c00ULL, 0xfffffff005047812ULL, 0x000fe400078ee204ULL,
0xfffffff019187812ULL, 0x000fe400078ee218ULL, 0x00005a0000027a11ULL, 0x004fe400078040ffULL,
0x0000000406077c10ULL, 0x000fe4000ff3e0ffULL, 0x00005b0000037a11ULL, 0x000fe400000f4403ULL,
0x0000000404057c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x0000000418007c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001021027825ULL, 0x000fe200078e0002ULL,
0xfffffff81c1b7812ULL, 0x000fc400078ee21bULL, 0x00005a0007067a11ULL, 0x000fe200078240ffULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x00005a0005047a11ULL, 0x040fe200078040ffULL,
0x000000ffff197224ULL, 0x000fe200010e06ffULL, 0x00005a0000187a11ULL, 0x000fe400078440ffULL,
0x00005b0005057a11ULL, 0x000fe400000f441cULL, 0xfffffff81e1d7812ULL, 0x040fe400078ee21dULL,
0x00005b0007077a11ULL, 0x000fe200008f441aULL, 0x000000101b047825ULL, 0x000fe200078e0004ULL,
0xfffffff81e1f7812ULL, 0x000fe200078ee21fULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x00005b0000197a11ULL, 0x000fe200010f4419ULL, 0x000000101d067825ULL, 0x000fc800078e0006ULL,
0x000000101f187825ULL, 0x000fe200078e0018ULL, 0x0000000c04007986ULL, 0x008fe8000c101d06ULL,
0x0000001006007986ULL, 0x000fe8000c101d06ULL, 0x0000001418007986ULL, 0x010fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff037819ULL, 0x00afe2000001168eULL,
0xffffffffff8a7424ULL, 0x000fc600078e00ffULL, 0x01ffffff03037812ULL, 0x000fca00078ec0ffULL,
0x00000002908c7824ULL, 0x000fca00078e0203ULL, 0x0000008d8c00720cULL, 0x000fda0003f06070ULL,
0x0000000289038824ULL, 0x000fc800078e00ffULL, 0x0000640003038a24ULL, 0x000fc800078e028cULL,
0x0000600003028625ULL, 0x000fe200078e0000ULL, 0x0000000190007810ULL, 0x000fc80007ffe0ffULL,
0x00000006028a8981ULL, 0x000362000c1e1900ULL, 0x0000008b0000720cULL, 0x000fe20003f06070ULL,
0x000000408e7f7824ULL, 0x000fe200078e00ffULL, 0x000000077e7e7819ULL, 0x000fe200000006ffULL,
0x0000000704047899ULL, 0x000fe4000800063fULL, 0x0000010090057824ULL, 0x000fca00078e027fULL,
0x000000407e197812ULL, 0x000fc600078ef805ULL, 0x00000cb000008947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x002e620000000000ULL, 0x000000058f007217ULL, 0x000fe20007800000ULL,
0x000000048a197c24ULL, 0x020fe2000f8e0219ULL, 0x000010008e1a7811ULL, 0x000fc600078e70ffULL,
0x0000000100187824ULL, 0x000fe200078e0a05ULL, 0x00000003ff217819ULL, 0x002fc80000011602ULL,
0x0000000421077810ULL, 0x040fe40007ffe0ffULL, 0x0000000c21097810ULL, 0x000fe40007ffe0ffULL,
0x0000000207037212ULL, 0x0c0fe200078e3cffULL, 0x0000000807047824ULL, 0x000fe200078e00ffULL,
0x00000010210b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000809067824ULL, 0x000fe200078e00ffULL,
0x0000001421117810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8041d7812ULL, 0x000fe200078ee203ULL,
0x000000080b257824ULL, 0x000fe200078e00ffULL, 0x0000000209037212ULL, 0x000fc400078e3cffULL,
0x0000000821057810ULL, 0x000fe20007ffe0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e021aULL,
0x000000020b047212ULL, 0x080fe400078e3cffULL, 0xfffffff806237812ULL, 0x000fe200078ee203ULL,
0x0000000811067824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee204ULL,
0x00000008051f7824ULL, 0x000fe200078e00ffULL, 0x0000000211037212ULL, 0x000fe400078e3cffULL,
0x0000007f21047812ULL, 0x000fc400078ec0ffULL, 0x0000000205007212ULL, 0x000fe400078e3cffULL,
0xfffffff806277812ULL, 0x000fe200078ee203ULL, 0x00000100ff037424ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee200ULL, 0x0000000104047824ULL, 0x000fe200078e0219ULL,
0x0000007f05087812ULL, 0x040fe400078ec0ffULL, 0x0000000402007819ULL, 0x000fe400000006ffULL,
0x000000180500720cULL, 0x000fe20003fa6070ULL, 0x00005e0004047625ULL, 0x000fe200078e0003ULL,
0x0000007000007812ULL, 0x000fc400078ec0ffULL, 0x0000007f090a7812ULL, 0x040fe200078ec0ffULL,
0x0000000108087824ULL, 0x100fe200078e0219ULL, 0x000000180900720cULL, 0x000fe40003f06070ULL,
0x0000007f07067812ULL, 0x000fe200078ec0ffULL, 0x00005e0008087625ULL, 0x080fe200078e0003ULL,
0x00000004000c7210ULL, 0x000fe40007f3e0ffULL, 0x0000007f0b0e7812ULL, 0x000fe200078ec0ffULL,
0x000000010a047824ULL, 0x100fe200078e0219ULL, 0x0000000800087210ULL, 0x000fe20007f7e0ffULL,
0x0000000106067824ULL, 0x000fe200078e0219ULL, 0x000000180700720cULL, 0x080fe20003f86070ULL,
0x000000ffff0d7224ULL, 0x000fe200008e0605ULL, 0x000000180b00720cULL, 0x000fe20003f46070ULL,
0x00005e0004047625ULL, 0x000fe200078e0003ULL, 0x0000001821177810ULL, 0x000fc40007ffe0ffULL,
0x0000001c212b7810ULL, 0x040fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x080fe200078e0003ULL,
0x0000000721137812ULL, 0x000fe400078e4802ULL, 0x0000007f2b147812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fe200018e0609ULL, 0x0000000400107210ULL, 0x000fe20007f7e0ffULL,
0x000000010e0a7824ULL, 0x000fe200078e0219ULL, 0x0000007f11047812ULL, 0x000fe200078ec0ffULL,
0x0000000817297824ULL, 0x040fe200078e00ffULL, 0x00000006000e7210ULL, 0x000fe20007f3e0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0003ULL, 0x0000007f17067812ULL, 0x000fc400078ec0ffULL,
0x00000007ff0f7210ULL, 0x000fe20000ffe4ffULL, 0x0000000104047824ULL, 0x000fe200078e0219ULL,
0x000000181100720cULL, 0x000fe20003f26070ULL, 0x000000ffff117224ULL, 0x000fe200018e0605ULL,
0x0000000a000a7210ULL, 0x000fe20007fde0ffULL, 0x00005e0004047625ULL, 0x080fe200078e0003ULL,
0x00000020212d7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffff8131b7812ULL, 0x000fe200078ef802ULL,
0x0000000106067824ULL, 0x000fe200078e0219ULL, 0x0000007f2d167812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x0000000400127210ULL, 0x000fe20007fde0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0003ULL, 0x000000182100720cULL, 0x000fc40003f66070ULL,
0x00000024212f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000114047824ULL, 0x000fe200078e0219ULL,
0x0000001a1b1b7211ULL, 0x000fe200078e20ffULL, 0x000000ffff137224ULL, 0x000fe200030e0605ULL,
0x0000000600147210ULL, 0x000fe20007fde0ffULL, 0x00005e0004047625ULL, 0x000fe200078e0003ULL,
0x000000022d1c7212ULL, 0x000fc600078e3cffULL, 0x0000000116067824ULL, 0x000fe400078e0219ULL,
0x000000ffff157224ULL, 0x000fe200030e0607ULL, 0x0000000400167210ULL, 0x000fe20007fde0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0003ULL, 0x0000000217047212ULL, 0x040fe200078e3cffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c1b7faeULL, 0x0003e2000d901c46ULL,
0x000000181700720cULL, 0x000fe20003f66070ULL, 0x000000ffff177224ULL, 0x000fe200030e0605ULL,
0xfffffff829297812ULL, 0x000fe200078ee204ULL, 0x000000082b1e7824ULL, 0x000fe200078e00ffULL,
0x0000007f2f047812ULL, 0x000fe200078ec0ffULL, 0x000000000e1d7faeULL, 0x0005e2000e101c46ULL,
0x0000000600067210ULL, 0x000fc40007fde0ffULL, 0x0000001904047210ULL, 0x000fe40007ffe0ffULL,
0x000000182b00720cULL, 0x000fe20003f86070ULL, 0x000000101f1b7824ULL, 0x002fe200078e021aULL,
0x000000022b0d7212ULL, 0x000fe200078e3cffULL, 0x00005e0004047625ULL, 0x000fc600078e0003ULL,
0x00000000081b7faeULL, 0x0003e2000e901c46ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x00000004000c7210ULL, 0x000fe20007fde0ffULL, 0x000000082d1f7824ULL, 0x040fe200078e00ffULL,
0x000000182d00720cULL, 0x000fe20003fa6070ULL, 0x00000010230f7824ULL, 0x004fe200078e021aULL,
0xfffffff81e1d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff0d7224ULL, 0x000fe200030e0605ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee21cULL, 0x0000001025057824ULL, 0x100fe200078e021aULL,
0x0000001a1d1d7211ULL, 0x000fe200078e20ffULL, 0x00000000100f7faeULL, 0x0005e2000c101c46ULL,
0x0000001027097824ULL, 0x102fe200078e021aULL, 0x0000002821237810ULL, 0x000fe20007ffe0ffULL,
0x00000010291b7824ULL, 0x100fe200078e021aULL, 0x000000000a057faeULL, 0x0003e2000d101c46ULL,
0x000000101f1f7824ULL, 0x000fe200078e021aULL, 0x0000003021257810ULL, 0x000fc40007ffe0ffULL,
0x0000000012097faeULL, 0x0007e2000c901c46ULL, 0x000000022f047212ULL, 0x040fe400078e3cffULL,
0x000000182f00720cULL, 0x000fe20003fc6070ULL, 0x00000000141b7faeULL, 0x0009e2000d901c46ULL,
0x0000002c21117810ULL, 0x044fe40007ffe0ffULL, 0x0000003421277810ULL, 0x000fe20007ffe0ffULL,
0x00000000161d7faeULL, 0x0005e2000e101c46ULL, 0x000000082f0b7824ULL, 0x002fe200078e00ffULL,
0x0000000223057212ULL, 0x000fe200078e3cffULL, 0x0000000811087824ULL, 0x000fe200078e00ffULL,
0x00000000061f7faeULL, 0x0003e2000e901c46ULL, 0x0000007f250a7812ULL, 0x000fe200078ec0ffULL,
0x00000008270e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee204ULL,
0x0000000825157824ULL, 0x010fe200078e00ffULL, 0x0000007f23047812ULL, 0x000fc400078ec0ffULL,
0x0000000227097212ULL, 0x088fe200078e3cffULL, 0x000000100b0b7824ULL, 0x000fe200078e021aULL,
0x0000003821297810ULL, 0x000fe20007ffe0ffULL, 0x0000000104047824ULL, 0x000fe200078e0219ULL,
0xfffffff80e177812ULL, 0x004fe200078ee209ULL, 0x0000000823067824ULL, 0x002fe200078e00ffULL,
0x000000000c0b7faeULL, 0x0003e2000f101c46ULL, 0x0000003c21217810ULL, 0x000fe40007ffe0ffULL,
0x0000007f290e7812ULL, 0x000fe400078ec0ffULL, 0xfffffff8060f7812ULL, 0x000fe200078ee205ULL,
0x00000008211b7824ULL, 0x000fe200078e00ffULL, 0x0000000225067212ULL, 0x000fc400078e3cffULL,
0x0000000211057212ULL, 0x000fe200078e3cffULL, 0x000000100f0f7824ULL, 0x000fe200078e021aULL,
0xfffffff815157812ULL, 0x000fe400078ee206ULL, 0x0000007f11067812ULL, 0x000fe400078ec0ffULL,
0xfffffff808137812ULL, 0x000fe200078ee205ULL, 0x00005e0004047625ULL, 0x000fe200078e0003ULL,
0x0000001906067210ULL, 0x000fe40007ffe0ffULL, 0x0000007f270c7812ULL, 0x002fc400078ec0ffULL,
0x0000000400087210ULL, 0x000fe20007fde0ffULL, 0x00005e0006067625ULL, 0x080fe200078e0003ULL,
0x0000007f21107812ULL, 0x000fe400078ec0ffULL, 0x000000182300720cULL, 0x080fe20003fa6070ULL,
0x000000010a047824ULL, 0x000fe200078e0219ULL, 0x000000181100720cULL, 0x000fe20003f86070ULL,
0x000000ffff097224ULL, 0x000fe200030e0605ULL, 0x00000006000a7210ULL, 0x000fe20007fde0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0003ULL, 0x000000182500720cULL, 0x000fc40003f66070ULL,
0x000000182700720cULL, 0x080fe20003f46070ULL, 0x000000010c067824ULL, 0x000fe200078e0219ULL,
0x000000182900720cULL, 0x000fe20003f26070ULL, 0x000000ffff0b7224ULL, 0x000fe200030e0607ULL,
0x00000004000c7210ULL, 0x000fe20007fde0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0003ULL,
0x000000182100720cULL, 0x000fe20003f06070ULL, 0x00000000080f7faeULL, 0x0003e2000e901c46ULL,
0x00000005ff0d7210ULL, 0x000fe200037fe4ffULL, 0x000000010e047824ULL, 0x100fe200078e0219ULL,
0x0000000600067210ULL, 0x000fe20007fde0ffULL, 0x00000001100e7824ULL, 0x000fe200078e0219ULL,
0x0000000229107212ULL, 0x080fe200078e3cffULL, 0x00005e0004047625ULL, 0x000fe200078e0003ULL,
0x0000000221027212ULL, 0x000fc600078e3cffULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000000400047210ULL, 0x000fe20007fde0ffULL, 0x0000000829197824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee202ULL, 0x00005e000e027625ULL, 0x000fc600078e0003ULL,
0xfffffff819197812ULL, 0x000fe200078ee210ULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x0000000200027210ULL, 0x000fe20007fde0ffULL, 0x0000001013117824ULL, 0x100fe400078e021aULL,
0x0000001015137824ULL, 0x100fe200078e021aULL, 0x0000001a17157211ULL, 0x000fe200078e20ffULL,
0x0000001019177824ULL, 0x100fe200078e021aULL, 0x000000000a117faeULL, 0x0003e2000e101c46ULL,
0x000000101b197824ULL, 0x000fe400078e021aULL, 0x000000ffff037224ULL, 0x000fe200030e0603ULL,
0x000000000c137faeULL, 0x0003e8000d901c46ULL, 0x0000000006157faeULL, 0x0003e8000d101c46ULL,
0x0000000004177faeULL, 0x0003e8000c901c46ULL, 0x0000000002197faeULL, 0x0003e2000c101c46ULL,
0x00000b8000007947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x002e620000000000ULL,
0x000000048a197c24ULL, 0x020fc4000f8e0219ULL, 0x00000100ff217424ULL, 0x000fe200078e00ffULL,
0x00000003ff037819ULL, 0x002fc80000011600ULL, 0x0000000403077810ULL, 0x040fe40007ffe0ffULL,
0x00000008030b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c030f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000807097824ULL, 0x040fe200078e00ffULL, 0x0000000007027212ULL, 0x000fe200078e3cffULL,
0x000000080b0d7824ULL, 0x000fe200078e00ffULL, 0x0000001403177810ULL, 0x000fe20007ffe0ffULL,
0x000000080f117824ULL, 0x000fe200078e00ffULL, 0xfffffff809097812ULL, 0x000fc400078ee202ULL,
0x0000001003137810ULL, 0x040fe40007ffe0ffULL, 0x0000001c03237810ULL, 0x000fe40007ffe0ffULL,
0x000000000b047212ULL, 0x080fe200078e3cffULL, 0x0000000813157824ULL, 0x000fe200078e00ffULL,
0x000000000f027212ULL, 0x080fe200078e3cffULL, 0x0000000823337824ULL, 0x000fe200078e00ffULL,
0x0000000017057212ULL, 0x040fe400078e3cffULL, 0x0000000317087819ULL, 0x000fc400000006ffULL,
0x0000002403277810ULL, 0x040fe40007ffe0ffULL, 0x00000018031d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80d0d7812ULL, 0x000fe400078ee204ULL, 0xfffffff811117812ULL, 0x000fe200078ee202ULL,
0x000000081d1f7824ULL, 0x000fe200078e00ffULL, 0x0000002003257810ULL, 0x040fe40007ffe0ffULL,
0x0000002c032b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000013047212ULL, 0x080fe200078e3cffULL,
0x0000000825357824ULL, 0x000fe200078e00ffULL, 0xfffffff8081b7812ULL, 0x000fe200078ee205ULL,
0x0000000827087824ULL, 0x000fe200078e00ffULL, 0x0000000023027212ULL, 0x080fe200078e3cffULL,
0x000000082b3b7824ULL, 0x000fe200078e00ffULL, 0x0000000027057212ULL, 0x000fe400078e3cffULL,
0x0000002803297810ULL, 0x040fe40007ffe0ffULL, 0x00000034032f7810ULL, 0x000fc40007ffe0ffULL,
0x000000001d067212ULL, 0x080fe200078e3cffULL, 0x0000000829397824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe400078ee204ULL, 0xfffffff833337812ULL, 0x000fe400078ee202ULL,
0x00000030032d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000025047212ULL, 0x080fe400078e3cffULL,
0x000000002b027212ULL, 0x000fe200078e3cffULL, 0x000000082d3d7824ULL, 0x000fe200078e00ffULL,
0xfffffff808377812ULL, 0x000fc400078ee205ULL, 0x000000002f057212ULL, 0x0c0fe400078e3cffULL,
0x000000032f087819ULL, 0x000fe400000006ffULL, 0xfffffff81f1f7812ULL, 0x000fe400078ee206ULL,
0x0000003803317810ULL, 0x000fe40007ffe0ffULL, 0x0000000029067212ULL, 0x000fe400078e3cffULL,
0xfffffff835357812ULL, 0x000fe200078ee204ULL, 0x0000000831417824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fc400078ee202ULL, 0x000000002d047212ULL, 0x000fe400078e3cffULL,
0x0000007f03027812ULL, 0x040fe400078ec0ffULL, 0xfffffff8083f7812ULL, 0x000fe400078ee205ULL,
0x0000000703057812ULL, 0x000fe200078e4800ULL, 0x0000000102027824ULL, 0x000fe200078e0219ULL,
0xfffffff839397812ULL, 0x000fe400078ee206ULL, 0x0000003c03037810ULL, 0x000fc40007ffe0ffULL,
0x0000000031067212ULL, 0x080fe400078e3cffULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee204ULL,
0x0000001000047824ULL, 0x000fe200078e00ffULL, 0x0000007f07087812ULL, 0x000fe200078ec0ffULL,
0x0000000803247824ULL, 0x000fe200078e00ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef800ULL,
0x0000000003077212ULL, 0x000fe200078e3cffULL, 0x0000000108087824ULL, 0x000fe200078e0219ULL,
0xfffffff841417812ULL, 0x000fc400078ee206ULL, 0x0000007f03007812ULL, 0x000fe200078ec0ffULL,
0x00005e0002027625ULL, 0x080fe200078e0021ULL, 0x000010008e067811ULL, 0x000fe400078e70ffULL,
0x0000007f23147812ULL, 0x000fe200078ec0ffULL, 0x0000000100007824ULL, 0x000fe200078e0219ULL,
0x0000007004237812ULL, 0x000fe200078ec0ffULL, 0x0000001033337824ULL, 0x100fe200078e0206ULL,
0x0000007f0b0a7812ULL, 0x000fe200078ec0ffULL, 0x0000001035357824ULL, 0x100fe200078e0206ULL,
0x0000007f130e7812ULL, 0x000fe200078ec0ffULL, 0x0000001037377824ULL, 0x100fe200078e0206ULL,
0x0000007f25167812ULL, 0x000fe200078ec0ffULL, 0x0000001005257824ULL, 0x000fe200078e0206ULL,
0xfffffff824077812ULL, 0x000fe200078ee207ULL, 0x00005e0008047625ULL, 0x000fe200078e0021ULL,
0x0000000223027210ULL, 0x000fc40007f1e0ffULL, 0x0000007f0f0c7812ULL, 0x000fe200078ec0ffULL,
0x000000010a0a7824ULL, 0x100fe200078e0219ULL, 0x0000007f17107812ULL, 0x000fe200078ec0ffULL,
0x000000010e0e7824ULL, 0x000fe200078e0219ULL, 0x0000007f1d127812ULL, 0x000fe200078ec0ffULL,
0x0000001039397824ULL, 0x100fe200078e0206ULL, 0x0000007f27187812ULL, 0x000fe200078ec0ffULL,
0x0000001009277824ULL, 0x100fe200078e0206ULL, 0x0000007f291a7812ULL, 0x000fe200078ec0ffULL,
0x000000100d297824ULL, 0x100fe200078e0206ULL, 0x0000007f2b1c7812ULL, 0x000fe200078ec0ffULL,
0x000000103d3d7824ULL, 0x100fe200078e0206ULL, 0x0000007f2d1e7812ULL, 0x000fe200078ec0ffULL,
0x00000010152d7824ULL, 0x100fe200078e0206ULL, 0x0000007f2f207812ULL, 0x000fe200078ec0ffULL,
0x000000101b2f7824ULL, 0x100fe200078e0206ULL, 0x0000007f31227812ULL, 0x000fe200078ec0ffULL,
0x000000101f317824ULL, 0x100fe200078e0206ULL, 0x00000006112b7211ULL, 0x080fe200078e20ffULL,
0x000000103f3f7824ULL, 0x100fe200078e0206ULL, 0x000000063b3b7211ULL, 0x000fe200078e20ffULL,
0x0000001041417824ULL, 0x100fe200078e0206ULL, 0x000000190c0c7210ULL, 0x080fe20007ffe0ffULL,
0x0000001007437824ULL, 0x000fe200078e0206ULL, 0x000000191c1c7210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000000423047210ULL, 0x000fe20007f1e0ffULL,
0x00005e000a067625ULL, 0x000fc600078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002257faeULL, 0x0003e2000b901c46ULL, 0x00005e000e0a7625ULL, 0x000fe200078e0021ULL,
0x0000000623067210ULL, 0x000fc60007f3e0ffULL, 0x0000000110107824ULL, 0x100fe400078e0219ULL,
0x0000000112127824ULL, 0x000fe400078e0219ULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000000a230a7210ULL, 0x000fe20007f1e0ffULL, 0x00005e000c087625ULL, 0x000fc600078e0021ULL,
0x0000000004277faeULL, 0x0003e2000b901c46ULL, 0x00005e00100c7625ULL, 0x000fe200078e0021ULL,
0x0000000823087210ULL, 0x000fc60007f5e0ffULL, 0x00005e00120e7625ULL, 0x000fe200078e0021ULL,
0x00000009ff097210ULL, 0x000fc600017fe4ffULL, 0x0000000114147824ULL, 0x100fe400078e0219ULL,
0x0000000116167824ULL, 0x000fe400078e0219ULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000000c230c7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000000e230e7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0014107625ULL, 0x080fe200078e0021ULL,
0x0000000006297faeULL, 0x0003e6000b901c46ULL, 0x00005e0016127625ULL, 0x000fe200078e0021ULL,
0x00000000082b7faeULL, 0x0003e6000b901c46ULL, 0x0000000118187824ULL, 0x100fe200078e0219ULL,
0x000000000a2d7faeULL, 0x0003e2000b901c46ULL, 0x000000011a1a7824ULL, 0x000fc400078e0219ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x0000001023107210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e060fULL, 0x0000001223127210ULL, 0x000fe20007f1e0ffULL,
0x000000011e1e7824ULL, 0x100fe200078e0219ULL, 0x000000000c2f7faeULL, 0x0003e2000b901c46ULL,
0x0000000120207824ULL, 0x100fe400078e0219ULL, 0x0000000122227824ULL, 0x000fe200078e0219ULL,
0x000000000e317faeULL, 0x0003e2000b901c46ULL, 0x00005e0018147625ULL, 0x000fc800078e0021ULL,
0x00005e001c187625ULL, 0x000fc800078e0021ULL, 0x00005e001a167625ULL, 0x000fc800078e0021ULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x0000001423147210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x0000001823187210ULL, 0x040fe20007f1e0ffULL,
0x00005e001e1a7625ULL, 0x000fe200078e0021ULL, 0x0000001623167210ULL, 0x040fe20007f5e0ffULL,
0x0000000010337faeULL, 0x0003e2000b901c46ULL, 0x00000019ff197210ULL, 0x000fe200007fe4ffULL,
0x00005e00201c7625ULL, 0x080fe200078e0021ULL, 0x0000001a231a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000012357faeULL, 0x0003e4000b901c46ULL, 0x00005e00221e7625ULL, 0x000fc800078e0021ULL,
0x00005e0000207625ULL, 0x000fc800078e0021ULL, 0x000000ffff157224ULL, 0x000fe200008e0615ULL,
0x0000001c231c7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200010e0617ULL,
0x0000001e231e7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200000e061bULL,
0x0000002023207210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e061dULL,
0x0000000014377faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1f7224ULL, 0x000fe400010e061fULL,
0x000000ffff217224ULL, 0x000fe200018e0621ULL, 0x0000000016397faeULL, 0x0003e8000b901c46ULL,
0x00000000183b7faeULL, 0x0003e8000b901c46ULL, 0x000000001a3d7faeULL, 0x0003e8000b901c46ULL,
0x000000001c3f7faeULL, 0x0003e8000b901c46ULL, 0x000000001e417faeULL, 0x0003e8000b901c46ULL,
0x0000000020437faeULL, 0x0003e4000b901c46ULL, 0x02360400ff007984ULL, 0x000ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000000ff7812ULL, 0x004fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x02360400ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000008b9000720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000007d7919ULL, 0x000ea20000000000ULL, 0x0000640089897a24ULL, 0x000fe200078e02ffULL,
0xffffffff8b877810ULL, 0x000fe20007ffe0ffULL, 0x000000108e887824ULL, 0x000fe200078e00ffULL,
0x00007610ff867816ULL, 0x000fe20000000086ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000704047899ULL, 0x000fe4000800063fULL, 0x0000010090807824ULL, 0x000fe200078e027fULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000808f00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x008fea0003800000ULL, 0x0000000190007810ULL, 0x000fe20007ffe0ffULL,
0x0000167000007945ULL, 0x000fe20003800000ULL, 0x0000004080037812ULL, 0x002fe400078ec0ffULL,
0x0000008b0000720cULL, 0x000fe40003f06070ULL, 0x000000037e037210ULL, 0x000fd60007ffe0ffULL,
0x00000ba000008947ULL, 0x000fea0003800000ULL, 0x00000003ff7c7819ULL, 0x004fe2000001167dULL,
0x000000048a8a7c24ULL, 0x000fe2000f8e0203ULL, 0x000000077d367812ULL, 0x000fe200078ec0ffULL,
0x000000018f137824ULL, 0x000fe200078e0a80ULL, 0x000000087c757810ULL, 0x040fe20007ffe0ffULL,
0x00000100ff7a7424ULL, 0x000fe200078e00ffULL, 0x0000000c7c727810ULL, 0x040fe40007ffe0ffULL,
0x000000047c787810ULL, 0x040fe20007ffe0ffULL, 0x0000000875007824ULL, 0x040fe200078e00ffULL,
0x000000187c697810ULL, 0x000fe20007ffe0ffULL, 0x0000000872057824ULL, 0x000fe200078e00ffULL,
0x000000107c6f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000878037824ULL, 0x000fe200078e00ffULL,
0x0000007d75737212ULL, 0x080fe200078e3cffULL, 0x0000000869047824ULL, 0x000fe200078e00ffULL,
0x0000007d72707212ULL, 0x000fe200078e3cffULL, 0x000000086f027824ULL, 0x000fe200078e00ffULL,
0x000000147c6c7810ULL, 0x000fc40007ffe0ffULL, 0x0000007d78767212ULL, 0x080fe400078e3cffULL,
0xfffffff800737812ULL, 0x000fe400078ee273ULL, 0xfffffff805707812ULL, 0x000fe200078ee270ULL,
0x000000086c057824ULL, 0x000fe200078e00ffULL, 0x0000001c7c667810ULL, 0x040fe40007ffe0ffULL,
0x000000207c007810ULL, 0x000fe40007ffe0ffULL, 0x0000007d69677212ULL, 0x080fe200078e3cffULL,
0x0000000866077824ULL, 0x000fe200078e00ffULL, 0x0000007d6f6d7212ULL, 0x000fc400078e3cffULL,
0x0000007d6c6a7212ULL, 0x080fe400078e3cffULL, 0x0000007f7c7b7812ULL, 0x000fe400078ec0ffULL,
0xfffffff803767812ULL, 0x000fe400078ee276ULL, 0x0000007d00037212ULL, 0x040fe400078e3cffULL,
0x0000000300067819ULL, 0x000fe400000006ffULL, 0xfffffff804677812ULL, 0x000fc400078ee267ULL,
0xfffffff8026d7812ULL, 0x000fe400078ee26dULL, 0x0000007d7c047212ULL, 0x080fe400078e3cffULL,
0x0000007d66027212ULL, 0x000fe400078e3cffULL, 0xfffffff8056a7812ULL, 0x000fe200078ee26aULL,
0x000000017b057824ULL, 0x000fe200078e028aULL, 0x0000007f78777812ULL, 0x000fe400078ec0ffULL,
0x0000007f75747812ULL, 0x000fc400078ec0ffULL, 0xfffffff806037812ULL, 0x000fe400078ee203ULL,
0x000000137c00720cULL, 0x000fe20003f06070ULL, 0x0000000174097824ULL, 0x000fe200078e028aULL,
0x0000000704067812ULL, 0x000fe200078ec0ffULL, 0x00005e0005047625ULL, 0x080fe200078e007aULL,
0xfffffff807027812ULL, 0x000fe400078ee202ULL, 0x0000007f72717812ULL, 0x000fe200078ec0ffULL,
0x0000000177077824ULL, 0x000fe200078e028aULL, 0x00000008361d7812ULL, 0x000fe200078efcffULL,
0x00005e0009087625ULL, 0x000fe200078e007aULL, 0x000030008e1c7811ULL, 0x000fc400078e70ffULL,
0x000000137800720cULL, 0x080fe20003f26070ULL, 0x00000001710b7824ULL, 0x000fe200078e028aULL,
0x0ffffff806797812ULL, 0x000fe200078ef87dULL, 0x00005e0007067625ULL, 0x000fe200078e007aULL,
0x000000137500720cULL, 0x080fe40003f46070ULL, 0x0000007f6f6e7812ULL, 0x000fe200078ec0ffULL,
0x000000101d047825ULL, 0x000fe200078e0004ULL, 0x0000001c790f7211ULL, 0x000fe400078e20ffULL,
0x000000137200720cULL, 0x080fe20003f66070ULL, 0x00005e000b0a7625ULL, 0x000fe200078e007aULL,
0x0000007f6c6b7812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040f7faeULL, 0x0003e2000c101c46ULL, 0x0000007f69687812ULL, 0x000fe200078ec0ffULL,
0x0000001076117824ULL, 0x000fe200078e021cULL, 0x000000136f00720cULL, 0x000fe20003f86070ULL,
0x000000101d067825ULL, 0x000fe200078e0006ULL, 0x0000007f66657812ULL, 0x000fc400078ec0ffULL,
0x000000136c00720cULL, 0x080fe20003f06070ULL, 0x000000016e0d7824ULL, 0x000fe200078e028aULL,
0x0000000006117faeULL, 0x0005e2000c901c46ULL, 0x0000001073157824ULL, 0x000fe200078e021cULL,
0x000000136900720cULL, 0x000fe20003f26070ULL, 0x000000101d087825ULL, 0x000fe200078e0008ULL,
0x0000007f00047812ULL, 0x002fc600078ec0ffULL, 0x000000016b057824ULL, 0x000fe200078e028aULL,
0x0000000008157faeULL, 0x0003e2000d101c46ULL, 0x00005e000d0c7625ULL, 0x000fe200078e007aULL,
0x000000136600720cULL, 0x000fc60003f46070ULL, 0x0000001070177824ULL, 0x000fe400078e021cULL,
0x000000101d0a7825ULL, 0x000fc800078e000aULL, 0x00005e0005067625ULL, 0x004fe200078e007aULL,
0x0000008a04057210ULL, 0x000fe20007ffe0ffULL, 0x000000000a177faeULL, 0x0005e2000d901c46ULL,
0x000000130000720cULL, 0x000fe20003f66070ULL, 0x0000000168097824ULL, 0x102fe400078e028aULL,
0x00000001650f7824ULL, 0x000fe400078e028aULL, 0x000000106d197824ULL, 0x000fe400078e021cULL,
0x000000101d0c7825ULL, 0x000fc800078e000cULL, 0x00005e0009087625ULL, 0x080fe200078e007aULL,
0x000000000c197faeULL, 0x0003e6000e101c46ULL, 0x00005e000f0e7625ULL, 0x000fc800078e007aULL,
0x000000101d0a7825ULL, 0x004fc800078e0006ULL, 0x00005e0005067625ULL, 0x000fe200078e007aULL,
0x000000247c057810ULL, 0x000fc60007ffe0ffULL, 0x000000106a157824ULL, 0x100fe400078e021cULL,
0x0000001067177824ULL, 0x000fe400078e021cULL, 0x000000101d0c7825ULL, 0x042fe200078e0008ULL,
0x000000000a157faeULL, 0x0003e2000c101c46ULL, 0x000000307c087810ULL, 0x000fe40007ffe0ffULL,
0x0000001002197824ULL, 0x000fe200078e021cULL, 0x000000000c177faeULL, 0x0005e2000c901c46ULL,
0x000000101d0e7825ULL, 0x000fe200078e000eULL, 0x000000347c097810ULL, 0x000fc40007ffe0ffULL,
0x000000130500720cULL, 0x000fe20003f06070ULL, 0x00000010031b7824ULL, 0x000fe200078e021cULL,
0x000000000e197faeULL, 0x0007e2000d101c46ULL, 0x000000101d107825ULL, 0x000fe200078e0006ULL,
0x000000287c067810ULL, 0x040fe40007ffe0ffULL, 0x0000002c7c077810ULL, 0x040fe40007ffe0ffULL,
0x00000000101b7faeULL, 0x0009e2000d901c46ULL, 0x000000387c0a7810ULL, 0x042fe40007ffe0ffULL,
0x0000003c7c0b7810ULL, 0x000fc40007ffe0ffULL, 0x0000007d050c7212ULL, 0x0c4fe200078e3cffULL,
0x00000008050f7824ULL, 0x008fe200078e00ffULL, 0x0000007d060d7212ULL, 0x080fe200078e3cffULL,
0x000000080a167824ULL, 0x000fe200078e00ffULL, 0x0000007d070e7212ULL, 0x000fe200078e3cffULL,
0x000000080b157824ULL, 0x000fe200078e00ffULL, 0x000000130600720cULL, 0x0c0fe20003f26070ULL,
0x0000000806107824ULL, 0x010fe200078e00ffULL, 0x000000130700720cULL, 0x0c0fe20003f46070ULL,
0x0000000807117824ULL, 0x000fe200078e00ffULL, 0x000000130800720cULL, 0x000fc40003f66070ULL,
0x000000130900720cULL, 0x080fe40003f86070ULL, 0x000000130a00720cULL, 0x080fe40003fa6070ULL,
0x000000130b00720cULL, 0x000fe20003fc6070ULL, 0x0000000809137824ULL, 0x000fe200078e00ffULL,
0xfffffff80f0c7812ULL, 0x000fe400078ee20cULL, 0xfffffff8100d7812ULL, 0x000fe400078ee20dULL,
0xfffffff8110e7812ULL, 0x000fe200078ee20eULL, 0x000000100c2d7824ULL, 0x100fe200078e021cULL,
0x0000007d080f7212ULL, 0x040fe200078e3cffULL, 0x000000100d2f7824ULL, 0x000fe200078e021cULL,
0x0000000308147819ULL, 0x000fc400000006ffULL, 0x0000007d09107212ULL, 0x080fe400078e3cffULL,
0x0000007d0a117212ULL, 0x080fe400078e3cffULL, 0x0000007d0b127212ULL, 0x000fe400078e3cffULL,
0xfffffff8140f7812ULL, 0x000fe400078ee20fULL, 0xfffffff813107812ULL, 0x000fe400078ee210ULL,
0xfffffff816117812ULL, 0x000fc400078ee211ULL, 0xfffffff815127812ULL, 0x000fe400078ee212ULL,
0x0000007f05137812ULL, 0x000fe400078ec0ffULL, 0x0000007f06147812ULL, 0x000fe200078ec0ffULL,
0x0000001012337824ULL, 0x000fe200078e021cULL, 0x0000007f07157812ULL, 0x000fe200078ec0ffULL,
0x0000000113197824ULL, 0x100fe200078e028aULL, 0x0000007f08167812ULL, 0x000fe200078ec0ffULL,
0x00000001141b7824ULL, 0x100fe200078e028aULL, 0x0000007f09177812ULL, 0x000fe200078ec0ffULL,
0x0000000115237824ULL, 0x100fe200078e028aULL, 0x0000007f0a607812ULL, 0x000fe200078ec0ffULL,
0x0000000116257824ULL, 0x000fe200078e028aULL, 0x0000007f0b617812ULL, 0x000fe200078ec0ffULL,
0x00005e0019187625ULL, 0x000fe200078e007aULL, 0x0000008a17277210ULL, 0x000fc40007ffe0ffULL,
0x0000001c11317211ULL, 0x000fe200078e20ffULL, 0x0000000160297824ULL, 0x100fe400078e028aULL,
0x00000001612b7824ULL, 0x000fe400078e028aULL, 0x00005e001b1a7625ULL, 0x000fc800078e007aULL,
0x00005e0023227625ULL, 0x000fc800078e007aULL, 0x00005e0025247625ULL, 0x000fc800078e007aULL,
0x00005e0027267625ULL, 0x000fc800078e007aULL, 0x00005e0029287625ULL, 0x000fc800078e007aULL,
0x00005e002b2a7625ULL, 0x000fc800078e007aULL, 0x000000101d1e7825ULL, 0x000fc800078e0018ULL,
0x000000101d207825ULL, 0x040fe200078e001aULL, 0x000000001e2d7faeULL, 0x0003e6000c101c46ULL,
0x000000101d187825ULL, 0x040fe200078e0022ULL, 0x00000000202f7faeULL, 0x0003e6000c901c46ULL,
0x000000101d1a7825ULL, 0x000fc800078e0024ULL, 0x000000101d267825ULL, 0x000fc800078e0026ULL,
0x000000101d287825ULL, 0x000fc800078e0028ULL, 0x000000101d2a7825ULL, 0x000fc800078e002aULL,
0x000000100e1d7824ULL, 0x100fe400078e021cULL, 0x000000100f237824ULL, 0x100fe400078e021cULL,
0x0000001010257824ULL, 0x000fe200078e021cULL, 0x00000000181d7faeULL, 0x0003e8000d101c46ULL,
0x000000001a237faeULL, 0x0003e8000d901c46ULL, 0x0000000026257faeULL, 0x0003e8000e101c46ULL,
0x0000000028317faeULL, 0x0003e8000e901c46ULL, 0x000000002a337faeULL, 0x0003e2000f101c46ULL,
0x00000a8000007947ULL, 0x000fea0003800000ULL, 0x00000003ff7c7819ULL, 0x004fe2000001167dULL,
0x000000048a8a7c24ULL, 0x000fe2000f8e0203ULL, 0x000000077d367812ULL, 0x000fe200078ec0ffULL,
0x00000100ff7a7424ULL, 0x000fe200078e00ffULL, 0x000000087c757810ULL, 0x000fc40007ffe0ffULL,
0x000000107c6f7810ULL, 0x040fe40007ffe0ffULL, 0x0000007d75737212ULL, 0x0c0fe200078e3cffULL,
0x0000000875007824ULL, 0x000fe200078e00ffULL, 0x000000047c787810ULL, 0x040fe40007ffe0ffULL,
0x000000187c697810ULL, 0x000fe40007ffe0ffULL, 0xfffffff800737812ULL, 0x000fe200078ee273ULL,
0x000000086f007824ULL, 0x040fe200078e00ffULL, 0x000000147c6c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000878057824ULL, 0x000fe200078e00ffULL, 0x0000007d6f6d7212ULL, 0x080fe200078e3cffULL,
0x0000000869047824ULL, 0x000fe200078e00ffULL, 0x0000000c7c727810ULL, 0x000fe20007ffe0ffULL,
0x000000086c037824ULL, 0x000fe200078e00ffULL, 0x0000007d78767212ULL, 0x000fc400078e3cffULL,
0xfffffff8006d7812ULL, 0x000fe200078ee26dULL, 0x0000000872077824ULL, 0x000fe200078e00ffULL,
0x0000001c7c667810ULL, 0x040fe40007ffe0ffULL, 0x0000007d69677212ULL, 0x080fe400078e3cffULL,
0x000000207c007810ULL, 0x000fe40007ffe0ffULL, 0x0000007d6c6a7212ULL, 0x080fe400078e3cffULL,
0x0000007d72707212ULL, 0x000fc400078e3cffULL, 0xfffffff805767812ULL, 0x000fe400078ee276ULL,
0x0000007d66027212ULL, 0x0c0fe400078e3cffULL, 0x0000000366057819ULL, 0x000fe400000006ffULL,
0xfffffff804677812ULL, 0x000fe200078ee267ULL, 0x0000000800047824ULL, 0x040fe200078e00ffULL,
0xfffffff8036a7812ULL, 0x000fe400078ee26aULL, 0x0000007d00037212ULL, 0x000fc400078e3cffULL,
0xfffffff807707812ULL, 0x000fe400078ee270ULL, 0xfffffff805027812ULL, 0x000fe400078ee202ULL,
0x000000287c067810ULL, 0x040fe40007ffe0ffULL, 0x0000002c7c077810ULL, 0x040fe40007ffe0ffULL,
0x000000247c057810ULL, 0x000fe20007ffe0ffULL, 0x0000000806087824ULL, 0x000fe200078e00ffULL,
0x0000007f7c7b7812ULL, 0x000fe200078ec0ffULL, 0x00000008070b7824ULL, 0x000fe200078e00ffULL,
0xfffffff804037812ULL, 0x000fe200078ee203ULL, 0x0000000805097824ULL, 0x000fe200078e00ffULL,
0x0000007d7c047212ULL, 0x080fe200078e3cffULL, 0x000000017b117824ULL, 0x000fe200078e028aULL,
0x0000007d060d7212ULL, 0x000fc400078e3cffULL, 0x0000007d070e7212ULL, 0x080fe200078e3cffULL,
0x00005e0011107625ULL, 0x000fe200078e007aULL, 0x0000007d050c7212ULL, 0x000fe400078e3cffULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0xfffffff8080d7812ULL, 0x000fe400078ee20dULL,
0xfffffff80b0e7812ULL, 0x000fe400078ee20eULL, 0xfffffff8090c7812ULL, 0x000fc400078ee20cULL,
0x000030008e377811ULL, 0x000fe400078e70ffULL, 0x0000000836397812ULL, 0x000fe400078efcffULL,
0x000000307c087810ULL, 0x040fe20007ffe0ffULL, 0x00000010733b7824ULL, 0x000fe200078e0237ULL,
0x000000387c0a7810ULL, 0x040fe20007ffe0ffULL, 0x0000001039167825ULL, 0x000fe200078e0010ULL,
0x0000003c7c0b7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffff804797812ULL, 0x000fe200078ef87dULL,
0x0000000808147824ULL, 0x000fe200078e00ffULL, 0x000000347c097810ULL, 0x000fe20007ffe0ffULL,
0x000000080a187824ULL, 0x000fe200078e00ffULL, 0x0000007d080f7212ULL, 0x080fe200078e3cffULL,
0x000000080b1b7824ULL, 0x000fe200078e00ffULL, 0x0000007d09127212ULL, 0x080fe200078e3cffULL,
0x0000001079157824ULL, 0x100fe200078e0237ULL, 0x0000000309197819ULL, 0x000fe200000006ffULL,
0x00000010703d7824ULL, 0x100fe200078e0237ULL, 0x0000007d0a137212ULL, 0x080fe200078e3cffULL,
0x000000106d3f7824ULL, 0x100fe200078e0237ULL, 0x0000007d0b047212ULL, 0x000fe200078e3cffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016157faeULL, 0x0003e2000b901c46ULL,
0xfffffff819107812ULL, 0x000fe200078ee212ULL, 0x000000106a417824ULL, 0x000fe200078e0237ULL,
0xfffffff8140f7812ULL, 0x000fe200078ee20fULL, 0x0000001002457824ULL, 0x000fe200078e0237ULL,
0xfffffff818117812ULL, 0x000fe200078ee213ULL, 0x0000001003477824ULL, 0x100fe200078e0237ULL,
0xfffffff81b127812ULL, 0x000fe200078ee204ULL, 0x000000100c497824ULL, 0x100fe200078e0237ULL,
0x0000007f78777812ULL, 0x000fe200078ec0ffULL, 0x000000100d4b7824ULL, 0x000fe200078e0237ULL,
0x0000007f75747812ULL, 0x000fc400078ec0ffULL, 0x0000007f72717812ULL, 0x000fe200078ec0ffULL,
0x0000000177237824ULL, 0x100fe200078e028aULL, 0x0000007f6f6e7812ULL, 0x000fe200078ec0ffULL,
0x0000000174257824ULL, 0x100fe200078e028aULL, 0x0000007f6c6b7812ULL, 0x000fe200078ec0ffULL,
0x0000000171277824ULL, 0x100fe200078e028aULL, 0x0000007f69687812ULL, 0x000fe200078ec0ffULL,
0x000000016e297824ULL, 0x000fe200078e028aULL, 0x0000007f66657812ULL, 0x000fe200078ec0ffULL,
0x00005e0023227625ULL, 0x000fe200078e007aULL, 0x0000007f00047812ULL, 0x000fc400078ec0ffULL,
0x0000007f05137812ULL, 0x000fe200078ec0ffULL, 0x00000001682f7824ULL, 0x100fe200078e028aULL,
0x0000007f06147812ULL, 0x000fe200078ec0ffULL, 0x0000000165337824ULL, 0x100fe200078e028aULL,
0x0000007f07157812ULL, 0x002fe200078ec0ffULL, 0x0000000104357824ULL, 0x100fe200078e028aULL,
0x0000007f08167812ULL, 0x000fe200078ec0ffULL, 0x0000000113317824ULL, 0x100fe200078e028aULL,
0x0000007f09177812ULL, 0x000fe200078ec0ffULL, 0x00000001142d7824ULL, 0x100fe200078e028aULL,
0x0000007f0a607812ULL, 0x000fe200078ec0ffULL, 0x0000000115197824ULL, 0x100fe200078e028aULL,
0x0000007f0b617812ULL, 0x000fe200078ec0ffULL, 0x00000001161b7824ULL, 0x100fe200078e028aULL,
0x0000008a6b2b7210ULL, 0x080fe20007ffe0ffULL, 0x00000001601f7824ULL, 0x100fe200078e028aULL,
0x0000008a171d7210ULL, 0x000fe20007ffe0ffULL, 0x0000000161217824ULL, 0x000fe200078e028aULL,
0x0000003767437211ULL, 0x000fe200078e20ffULL, 0x00005e0025247625ULL, 0x000fc800078e007aULL,
0x00005e0027267625ULL, 0x000fc800078e007aULL, 0x00005e0029287625ULL, 0x000fc800078e007aULL,
0x00005e002b2a7625ULL, 0x000fc800078e007aULL, 0x00005e002f2e7625ULL, 0x000fc800078e007aULL,
0x00005e0033327625ULL, 0x000fc800078e007aULL, 0x00005e0035347625ULL, 0x000fc800078e007aULL,
0x00005e0031307625ULL, 0x000fc800078e007aULL, 0x00005e002d2c7625ULL, 0x000fc800078e007aULL,
0x00005e0019187625ULL, 0x000fc800078e007aULL, 0x00005e001b1a7625ULL, 0x000fc800078e007aULL,
0x00005e001d1c7625ULL, 0x000fc800078e007aULL, 0x00005e001f1e7625ULL, 0x000fc800078e007aULL,
0x00005e0021207625ULL, 0x000fc800078e007aULL, 0x0000001039227825ULL, 0x000fc800078e0022ULL,
0x0000001039247825ULL, 0x000fc800078e0024ULL, 0x0000001039267825ULL, 0x000fc800078e0026ULL,
0x0000001039287825ULL, 0x000fc800078e0028ULL, 0x00000010392a7825ULL, 0x000fc800078e002aULL,
0x00000010392e7825ULL, 0x000fc800078e002eULL, 0x0000001039327825ULL, 0x000fc800078e0032ULL,
0x0000001039347825ULL, 0x000fc800078e0034ULL, 0x0000001039307825ULL, 0x000fc800078e0030ULL,
0x00000010392c7825ULL, 0x000fc800078e002cULL, 0x0000001039187825ULL, 0x000fc800078e0018ULL,
0x00000010391a7825ULL, 0x000fc800078e001aULL, 0x00000010391c7825ULL, 0x000fc800078e001cULL,
0x00000010391e7825ULL, 0x000fc800078e001eULL, 0x0000001039207825ULL, 0x000fc800078e0020ULL,
0x0000001076397824ULL, 0x000fca00078e0237ULL, 0x0000000022397faeULL, 0x0003e8000b901c46ULL,
0x00000000243b7faeULL, 0x0005e8000b901c46ULL, 0x00000000263d7faeULL, 0x0007e8000b901c46ULL,
0x00000000283f7faeULL, 0x0009e2000b901c46ULL, 0x000000100e237824ULL, 0x002fc600078e0237ULL,
0x000000002a417faeULL, 0x0003e2000b901c46ULL, 0x000000100f257824ULL, 0x004fc600078e0237ULL,
0x000000002e437faeULL, 0x0003e2000b901c46ULL, 0x0000001010277824ULL, 0x008fc600078e0237ULL,
0x0000000032457faeULL, 0x0003e2000b901c46ULL, 0x0000003711297211ULL, 0x010fe200078e20ffULL,
0x0000001012377824ULL, 0x000fe400078e0237ULL, 0x0000000034477faeULL, 0x0003e8000b901c46ULL,
0x0000000030497faeULL, 0x0003e8000b901c46ULL, 0x000000002c4b7faeULL, 0x0003e8000b901c46ULL,
0x0000000018237faeULL, 0x0003e8000b901c46ULL, 0x000000001a257faeULL, 0x0003e8000b901c46ULL,
0x000000001c277faeULL, 0x0003e8000b901c46ULL, 0x000000001e297faeULL, 0x0003e8000b901c46ULL,
0x0000000020377faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000300ff197624ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff8a7424ULL, 0x000fc400078e00ffULL, 0x00000002198c7824ULL, 0x000fca00078e028cULL,
0x0000008d8c00720cULL, 0x000fda0003f06070ULL, 0x0000000289188824ULL, 0x000fe400078e028cULL,
0x00000004ff198424ULL, 0x000fe200078e00ffULL, 0x00000004ff627819ULL, 0x000fe2000001167dULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000600018188625ULL, 0x000fca00078e0019ULL,
0x00000006188a8981ULL, 0x000362000c1e1900ULL, 0x0000000836637812ULL, 0x000fe200078ef87dULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x00000007621a7812ULL, 0x000fca00078e7863ULL,
0x00000010631a7824ULL, 0x000fca00078e021aULL, 0x000000041a1a7819ULL, 0x000fe400000006ffULL,
0x0000000862197824ULL, 0x042fe200078e00ffULL, 0x0000000262207810ULL, 0x000fe20007ffe0ffULL,
0x000040008e647824ULL, 0x000fe200078e00ffULL, 0x000000017c407812ULL, 0x000fe200078ec0ffULL,
0x0000163000007945ULL, 0x000fe20003800000ULL, 0xfffffff819187812ULL, 0x000fe400078ee236ULL,
0x0000100064847810ULL, 0x000fe20007ffe0ffULL, 0x000000001a34783bULL, 0x000fe20000000200ULL,
0x0000000718477812ULL, 0x040fe200078ec0ffULL, 0x0000000818997824ULL, 0x040fe200078e00ffULL,
0x0000001018927810ULL, 0x000fc40007ffe0ffULL, 0x00000001471c7812ULL, 0x000fe400078e787cULL,
0x0000002018a57810ULL, 0x000fe40007ffe0ffULL, 0x000000991c857212ULL, 0x000fe400078efcffULL,
0x0000003018187810ULL, 0x000fe40007ffe0ffULL, 0x0000000792457812ULL, 0x000fe200078ec0ffULL,
0x00000010851c7824ULL, 0x000fe200078e0284ULL, 0x0000000718417812ULL, 0x040fe200078ec0ffULL,
0x0000000818a37824ULL, 0x000fe200078e00ffULL, 0x0000000720227812ULL, 0x000fc400078e7863ULL,
0x0000000141187812ULL, 0x000fe200078e787cULL, 0x000000001c1c783bULL, 0x000e620000000200ULL,
0x0000000247207812ULL, 0x000fe200078e1e40ULL, 0x0000001063197824ULL, 0x000fe200078e0222ULL,
0x0000000392927819ULL, 0x000fe400000006ffULL, 0x0000000145837812ULL, 0x000fe200078e787cULL,
0x0000001019197824ULL, 0x000fe200078e00ffULL, 0x000000a318917212ULL, 0x000fe400078efcffULL,
0x00000007a5437812ULL, 0x040fe200078ec0ffULL, 0x00000008a5a57824ULL, 0x000fe200078e00ffULL,
0x0000009920817212ULL, 0x000fe200078efcffULL, 0x0000001091387824ULL, 0x000fe200078e0284ULL,
0x0000009283837212ULL, 0x080fe200078efcffULL, 0x000000001930783bULL, 0x000fe20000000200ULL,
0x0000000143827812ULL, 0x000fe200078e787cULL, 0x0000001081587824ULL, 0x000fe200078e0284ULL,
0x0000000245937812ULL, 0x000fe200078e1e40ULL, 0x00000010833c7824ULL, 0x000fe200078e0284ULL,
0x000000a582827212ULL, 0x000fe200078efcffULL, 0x000000003838783bULL, 0x000ea20000000200ULL,
0x0000009293937212ULL, 0x000fc400078efcffULL, 0x0000000243247812ULL, 0x000fe200078e1e40ULL,
0x000000005858783bULL, 0x000ee20000000200ULL, 0x0000001082187824ULL, 0x100fe200078e0284ULL,
0x0000000662427810ULL, 0x000fe20007ffe0ffULL, 0x0000001093207824ULL, 0x000fe200078e0284ULL,
0x000000003c3c783bULL, 0x000f220000000200ULL, 0x000000a524957212ULL, 0x000fe400078efcffULL,
0x00000004459f7812ULL, 0x140fe200078e1e40ULL, 0x000000001818783bULL, 0x000f220000000200ULL,
0x0000000645457812ULL, 0x000fe200078e1e40ULL, 0x0000001095287824ULL, 0x100fe200078e0284ULL,
0x000000929f9f7212ULL, 0x080fe200078efcffULL, 0x000000002020783bULL, 0x000f220000000200ULL,
0x0000009245927212ULL, 0x000fe200078efcffULL, 0x0000001c345c723cULL, 0x002fe400000018ffULL,
0x000000002828783bULL, 0x000e620000000200ULL, 0x000000109f547824ULL, 0x000fca00078e0284ULL,
0x0000001e341c723cULL, 0x040fe200000018ffULL, 0x000000005454783bULL, 0x000fee0000000200ULL,
0x00000038342c723cULL, 0x004fee00000018ffULL, 0x0000000241387812ULL, 0x000fe200078e1e40ULL,
0x00000058305c723cULL, 0x008fe6000000185cULL, 0x000000a338977212ULL, 0x000fc800078efcffULL,
0x0000008497387211ULL, 0x000fe200078e20ffULL, 0x0000005a3058723cULL, 0x000ff0000000181cULL,
0x0000003c341c723cULL, 0x050ff000000018ffULL, 0x0000003e343c723cULL, 0x040ff000000018ffULL,
0x000000183424723cULL, 0x040ff000000018ffULL, 0x0000001a3418723cULL, 0x040ff000000018ffULL,
0x0000003a3434723cULL, 0x000fe200000018ffULL, 0x000000003838783bULL, 0x000eae0000000200ULL,
0x00000020301c723cULL, 0x040ff0000000181cULL, 0x000000223020723cULL, 0x040fee000000183cULL,
0x00000004623c7810ULL, 0x000fe20007ffe0ffULL, 0x000000283024723cULL, 0x002fe20000001824ULL,
0x00000004413e7812ULL, 0x000fc800078e1e40ULL, 0x000000a33e9b7212ULL, 0x000fe400078efcffULL,
0x000000073c287812ULL, 0x000fe400078e7863ULL, 0x00000006473e7812ULL, 0x000fe200078e1e40ULL,
0x000000109b4c7824ULL, 0x000fe400078e0284ULL, 0x00000010633c7824ULL, 0x000fe400078e0228ULL,
0x0000002a3028723cULL, 0x040fe40000001818ULL, 0x000000103c3c7824ULL, 0x000fe200078e00ffULL,
0x000000004c4c783bULL, 0x000fe80000000200ULL, 0x000000003c48783bULL, 0x0002e20000000200ULL,
0x0000000447187812ULL, 0x100fe200078e1e40ULL, 0x00000038302c723cULL, 0x004fe2000000182cULL,
0x00000004431a7812ULL, 0x000fc400078e1e40ULL, 0x0000009918a17212ULL, 0x080fe400078efcffULL,
0x000000993e997212ULL, 0x000fe400078efcffULL, 0x0000000643387812ULL, 0x000fe200078e1e40ULL,
0x00000010a1187824ULL, 0x000fe200078e0284ULL, 0x00000007423e7812ULL, 0x000fe200078e7863ULL,
0x0000003a3030723cULL, 0x000fe20000001834ULL, 0x0000000641407812ULL, 0x000fe200078e1e40ULL,
0x0000001099447824ULL, 0x000fe200078e0284ULL, 0x000000a51a9d7212ULL, 0x000fe200078efcffULL,
0x00000010633e7824ULL, 0x000fe200078e023eULL, 0x000000a340a37212ULL, 0x000fe200078efcffULL,
0x000000001818783bULL, 0x000ea20000000200ULL, 0x000000a538a57212ULL, 0x000fe200078efcffULL,
0x000000109d507824ULL, 0x100fe200078e0284ULL, 0x000000043e947819ULL, 0x000fe200000006ffULL,
0x00000010a3387824ULL, 0x100fe200078e0284ULL, 0x000000004444783bULL, 0x000fe20000000200ULL,
0x0000001092407824ULL, 0x000fc400078e0284ULL, 0x00000010a53c7824ULL, 0x002fe200078e0284ULL,
0x000000005050783bULL, 0x000e680000000200ULL, 0x000000009434783bULL, 0x000fe80000000200ULL,
0x000000003838783bULL, 0x000f280000000200ULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x0000004c482c723cULL, 0x048fe6000000182cULL, 0x000000003c3c783bULL, 0x000eea0000000200ULL,
0x0000004e4830723cULL, 0x040ff00000001830ULL, 0x00000054481c723cULL, 0x040ff0000000181cULL,
0x00000018485c723cULL, 0x044ff0000000185cULL, 0x0000001a4858723cULL, 0x040ff00000001858ULL,
0x000000564820723cULL, 0x040ff00000001820ULL, 0x000000504824723cULL, 0x042ff00000001824ULL,
0x000000524828723cULL, 0x000ff00000001828ULL, 0x00000038342c723cULL, 0x050fee000000182cULL,
0x0000030090387a10ULL, 0x000fe20007ffe0ffULL, 0x0000003a3430723cULL, 0x000fe60000001830ULL,
0x0000000138187810ULL, 0x000fc80007ffe0ffULL, 0x0000008b1800720cULL, 0x000fe20003f06070ULL,
0x00000100383a7824ULL, 0x000fe200078e027fULL, 0x00000044345c723cULL, 0x000fe8000000185cULL,
0x000000403a197812ULL, 0x000fc800078ec0ffULL, 0x000000463458723cULL, 0x000fe20000001858ULL,
0x000000017e197824ULL, 0x000fce00078e0219ULL, 0x00000040341c723cULL, 0x040ff0000000181cULL,
0x000000423420723cULL, 0x040ff00000001820ULL, 0x0000003c3424723cULL, 0x048ff00000001824ULL,
0x0000003e3428723cULL, 0x000fe20000001828ULL, 0x0000079000008947ULL, 0x000fee0003800000ULL,
0x000000048a367c24ULL, 0x020fe2000f8e0219ULL, 0x0000003a8f417217ULL, 0x000fe20007800000ULL,
0x00000010113d7824ULL, 0x000fe200078e0284ULL, 0x000000047d437819ULL, 0x000fe200000006ffULL,
0x0000000177117824ULL, 0x000fe200078e0236ULL, 0x000000840c1a7211ULL, 0x000fe200078e20ffULL,
0x000000100d347824ULL, 0x100fe200078e0284ULL, 0x000000367b0d7210ULL, 0x000fe20007ffe0ffULL,
0x00000010103c7824ULL, 0x000fe200078e0284ULL, 0x0000007043437812ULL, 0x000fe200078ec0ffULL,
0x0000000141417824ULL, 0x000fe200078e0a3aULL, 0x0000008476477211ULL, 0x000fe200078e20ffULL,
0x00005e0011107625ULL, 0x000fe200078e007aULL, 0x00000036044f7210ULL, 0x000fc40007ffe0ffULL,
0x000000417c00720cULL, 0x080fe20003f46070ULL, 0x0000001003187824ULL, 0x000fe200078e0284ULL,
0x000000417800720cULL, 0x080fe20003f66070ULL, 0x0000000171037824ULL, 0x000fe200078e0236ULL,
0x000000417500720cULL, 0x080fe20003f26070ULL, 0x0000001079797824ULL, 0x100fe200078e0284ULL,
0x000000417200720cULL, 0x080fe20003f06070ULL, 0x0000001073737824ULL, 0x100fe200078e0284ULL,
0x000000416f00720cULL, 0x000fe20003fa6070ULL, 0x00000010703f7824ULL, 0x100fe400078e0284ULL,
0x000000106d6d7824ULL, 0x000fc400078e0284ULL, 0x000000106a197824ULL, 0x100fe400078e0284ULL,
0x0000001067677824ULL, 0x100fe400078e0284ULL, 0x00000010021b7824ULL, 0x100fe400078e0284ULL,
0x000000100e357824ULL, 0x100fe400078e0284ULL, 0x000000100f397824ULL, 0x000fe400078e0284ULL,
0x00005e000d0c7625ULL, 0x000fc800078e007aULL, 0x0000001012847824ULL, 0x000fe200078e0284ULL,
0x0000001043127210ULL, 0x040fe20007fde0ffULL, 0x00000001740f7824ULL, 0x000fe200078e0236ULL,
0x0000000c430c7210ULL, 0x000fe20007f9e0ffULL, 0x00005e0003027625ULL, 0x000fc800078e007aULL,
0x000000016b6b7824ULL, 0x100fe400078e0236ULL, 0x0000000113517824ULL, 0x000fe400078e0236ULL,
0x00005e000f0e7625ULL, 0x000fc800078e007aULL, 0x000000016e377824ULL, 0x100fe400078e0236ULL,
0x000000ffff137224ULL, 0x000fe200030e0611ULL, 0x0000000243027210ULL, 0x000fe20007fde0ffULL,
0x0000000114537824ULL, 0x100fe400078e0236ULL, 0x00000001154d7824ULL, 0x000fe400078e0236ULL,
0x00005e006b147625ULL, 0x000fc800078e007aULL, 0x000000ffff0d7224ULL, 0x000fe200020e060dULL,
0x0000000e430e7210ULL, 0x000fe20007f9e0ffULL, 0x00000001683b7824ULL, 0x100fe400078e0236ULL,
0x00005e0037107625ULL, 0x000fe200078e007aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c797faeULL, 0x0003e6000d101c46ULL, 0x000000ffff037224ULL, 0x000fe200030e0603ULL,
0x0000001443147210ULL, 0x000fe20007fde0ffULL, 0x0000000165657824ULL, 0x100fe200078e0236ULL,
0x0000001043107210ULL, 0x000fe20007f5e0ffULL, 0x00000001164b7824ULL, 0x100fe200078e0236ULL,
0x0000000012477faeULL, 0x0005e2000d901c46ULL, 0x0000000117497824ULL, 0x100fe200078e0236ULL,
0x000000416900720cULL, 0x000fe20003f66070ULL, 0x0000000160457824ULL, 0x000fc400078e0236ULL,
0x0000000161617824ULL, 0x000fe400078e0236ULL, 0x00005e003b367625ULL, 0x000fc800078e007aULL,
0x000000ffff0f7224ULL, 0x000fe200020e060fULL, 0x000000416c00720cULL, 0x080fe20003f86070ULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x00000036430c7210ULL, 0x002fe20007fde0ffULL,
0x00005e00653a7625ULL, 0x080fe200078e007aULL, 0x000000000e737faeULL, 0x0003e2000c901c46ULL,
0x000000410000720cULL, 0x000fe40003f26070ULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0x00000000023f7faeULL, 0x0007e2000c101c46ULL, 0x00005e004f167625ULL, 0x000fe200078e007aULL,
0x0000003a43127210ULL, 0x004fc40007f1e0ffULL, 0x00000000106d7faeULL, 0x0005e2000e901c46ULL,
0x000000ffff0d7224ULL, 0x000fe200030e0637ULL, 0x0000001643047210ULL, 0x000fe20007fde0ffULL,
0x00005e00510e7625ULL, 0x002fe200078e007aULL, 0x0000003bff137210ULL, 0x000fe200007fe4ffULL,
0x0000000014197faeULL, 0x0003e2000e101c46ULL, 0x000000410500720cULL, 0x080fe20003f06070ULL,
0x000000ffff057224ULL, 0x000fe200030e0617ULL, 0x0000000e43027210ULL, 0x008fe20007fbe0ffULL,
0x00005e0053167625ULL, 0x080fe200078e007aULL, 0x000000410600720cULL, 0x080fe20003f86070ULL,
0x000000000c677faeULL, 0x0007e2000d901c46ULL, 0x000000416600720cULL, 0x080fe20003f46070ULL,
0x000000ffff037224ULL, 0x000fe200028e060fULL, 0x000000410700720cULL, 0x000fe20003fa6070ULL,
0x00005e004d067625ULL, 0x000fe200078e007aULL, 0x00000016430e7210ULL, 0x000fc60007fde0ffULL,
0x00005e0049107625ULL, 0x004fe200078e007aULL, 0x0000000643367210ULL, 0x000fc60007f7e0ffULL,
0x000000ffff0f7224ULL, 0x000fe400030e0617ULL, 0x00005e004b167625ULL, 0x000fe200078e007aULL,
0x00000000121b7faeULL, 0x0005e2000d101c46ULL, 0x000000410800720cULL, 0x000fe40003f46070ULL,
0x000000ffff377224ULL, 0x000fe200018e0607ULL, 0x0000001643147210ULL, 0x002fe20007fde0ffULL,
0x00005e0045067625ULL, 0x000fe200078e007aULL, 0x0000000004187faeULL, 0x0005e2000c901c46ULL,
0x0000001043087210ULL, 0x000fc40007f7e0ffULL, 0x000000ffff157224ULL, 0x000fe200030e0617ULL,
0x0000000643067210ULL, 0x000fe20007f3e0ffULL, 0x00000000021a7faeULL, 0x0005e2000c101c46ULL,
0x000000410900720cULL, 0x080fe20003fc6070ULL, 0x00005e00617a7625ULL, 0x000fe200078e007aULL,
0x000000410a00720cULL, 0x080fe20003f06070ULL, 0x000000000e347faeULL, 0x0005e4000e101c46ULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x000000410b00720cULL, 0x000fe20003f26070ULL,
0x000000ffff097224ULL, 0x000fe200018e0611ULL, 0x0000007a430c7210ULL, 0x008fe20007f7e0ffULL,
0x0000000036357faeULL, 0x0005e6000e901c46ULL, 0x0000007bff0d7210ULL, 0x000fe20001ffe4ffULL,
0x0000000014397faeULL, 0x0005e8000d101c46ULL, 0x00000000083c7faeULL, 0x0005e8000f101c46ULL,
0x00000000063d7faeULL, 0x0005e8000c101c46ULL, 0x000000000c847faeULL, 0x0005e2000c901c46ULL,
0x0000066000007947ULL, 0x000fea0003800000ULL, 0x000000048a007c24ULL, 0x020fe2000f8e0219ULL,
0x0000008402417211ULL, 0x080fe200078e20ffULL, 0x0000001003457824ULL, 0x000fe200078e0284ULL,
0x00000084114f7211ULL, 0x000fe200078e20ffULL, 0x000000107d3b7824ULL, 0x000fe200078e00ffULL,
0x0000000060577210ULL, 0x000fe20007ffe0ffULL, 0x000000017b037824ULL, 0x000fc400078e0200ULL,
0x0000000177057824ULL, 0x000fe200078e0200ULL, 0x000000703b3b7812ULL, 0x000fe200078ec0ffULL,
0x00005e0003027625ULL, 0x000fc800078e007aULL, 0x0000000104197824ULL, 0x000fe200078e0200ULL,
0x000000023b027210ULL, 0x000fe20007f1e0ffULL, 0x00005e0005047625ULL, 0x000fc800078e007aULL,
0x0000000174077824ULL, 0x100fe400078e0200ULL, 0x000000016e0b7824ULL, 0x000fe400078e0200ULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x000000043b047210ULL, 0x000fe20007f1e0ffULL,
0x000000100f4d7824ULL, 0x000fe200078e0284ULL, 0x00000000680f7210ULL, 0x000fe20007ffe0ffULL,
0x00005e0007067625ULL, 0x000fc800078e007aULL, 0x00005e000b0a7625ULL, 0x000fe200078e007aULL,
0x000000063b067210ULL, 0x000fc60007f3e0ffULL, 0x000000100d497824ULL, 0x000fe400078e0284ULL,
0x000000016b0d7824ULL, 0x000fe400078e0200ULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000000a3b0a7210ULL, 0x000fe20007f1e0ffULL, 0x000000100c437824ULL, 0x100fe400078e0284ULL,
0x000000100e477824ULL, 0x000fe400078e0284ULL, 0x00005e000d0c7625ULL, 0x000fc800078e007aULL,
0x00005e000f0e7625ULL, 0x000fc800078e007aULL, 0x0000000165117824ULL, 0x000fe400078e0200ULL,
0x0000001012517824ULL, 0x000fe400078e0284ULL, 0x0000000171097824ULL, 0x100fe400078e0200ULL,
0x00000001131b7824ULL, 0x000fe400078e0200ULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000000c3b0c7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000000e3b0e7210ULL, 0x000fe20007f1e0ffULL, 0x00000010104b7824ULL, 0x000fc400078e0284ULL,
0x00005e0019127625ULL, 0x000fe200078e007aULL, 0x0000000fff0f7210ULL, 0x000fc600007fe4ffULL,
0x00005e0011107625ULL, 0x000fe200078e007aULL, 0x000000123b127210ULL, 0x000fc60007f1e0ffULL,
0x0000000115377824ULL, 0x000fe400078e0200ULL, 0x00005e0009087625ULL, 0x000fc800078e007aULL,
0x0000000114357824ULL, 0x000fe200078e0200ULL, 0x000000083b087210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x000000103b107210ULL, 0x000fe20007f3e0ffULL,
0x00005e0037187625ULL, 0x000fc800078e007aULL, 0x00005e001b147625ULL, 0x000fc800078e007aULL,
0x0000000116537824ULL, 0x100fe400078e0200ULL, 0x0000000117557824ULL, 0x000fe400078e0200ULL,
0x00005e0035167625ULL, 0x000fc800078e007aULL, 0x0000001079797824ULL, 0x100fe400078e0284ULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x000000183b187210ULL, 0x000fe20007f1e0ffULL,
0x0000001076397824ULL, 0x000fe200078e0284ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002797faeULL, 0x0003e2000b901c46ULL, 0x00000001617b7824ULL, 0x000fe400078e0200ULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x000000143b147210ULL, 0x000fe20007f3e0ffULL,
0x0000001073737824ULL, 0x000fe200078e0284ULL, 0x0000000004397faeULL, 0x0003e2000b901c46ULL,
0x00005e0053367625ULL, 0x000fc600078e007aULL, 0x0000000006737faeULL, 0x0003e2000b901c46ULL,
0x00000010703d7824ULL, 0x000fe400078e0284ULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x000000163b167210ULL, 0x000fe20007f5e0ffULL, 0x00005e0055347625ULL, 0x000fc600078e007aULL,
0x00000000083d7faeULL, 0x0003e2000b901c46ULL, 0x000000106d6d7824ULL, 0x000fe400078e0284ULL,
0x00005e00571a7625ULL, 0x000fc600078e007aULL, 0x000000000a6d7faeULL, 0x0003e2000b901c46ULL,
0x000000106a3f7824ULL, 0x000fe400078e0284ULL, 0x00005e007b7a7625ULL, 0x000fc600078e007aULL,
0x000000000c3f7faeULL, 0x0003e2000b901c46ULL, 0x0000001067677824ULL, 0x000fe200078e0284ULL,
0x0000007a3b3a7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff197224ULL, 0x000fe200000e0619ULL,
0x000000363b367210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200008e0615ULL,
0x000000343b347210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200010e0617ULL,
0x0000001a3b1a7210ULL, 0x000fe20007f5e0ffULL, 0x000000000e677faeULL, 0x0003e2000b901c46ULL,
0x000000ffff377224ULL, 0x000fc400000e0637ULL, 0x000000ffff357224ULL, 0x000fe200008e0635ULL,
0x0000000010417faeULL, 0x0003e2000b901c46ULL, 0x0000001bff1b7210ULL, 0x000fe200017fe4ffULL,
0x000000ffff3b7224ULL, 0x000fe400018e067bULL, 0x0000000012457faeULL, 0x0003e8000b901c46ULL,
0x0000000014437faeULL, 0x0003e8000b901c46ULL, 0x0000000016497faeULL, 0x0003e8000b901c46ULL,
0x0000000018477faeULL, 0x0003e8000b901c46ULL, 0x00000000364d7faeULL, 0x0003e8000b901c46ULL,
0x00000000344b7faeULL, 0x0003e8000b901c46ULL, 0x000000001a4f7faeULL, 0x0003e8000b901c46ULL,
0x000000003a517faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000862007810ULL, 0x000fc40007ffe0ffULL,
0x0000300064647810ULL, 0x000fe40007ffe0ffULL, 0x0000000700007812ULL, 0x100fe400078e7863ULL,
0x0000000a62027810ULL, 0x006fe20007ffe0ffULL, 0x00000010830c7824ULL, 0x000fe200078e0264ULL,
0x00000064a5407211ULL, 0x000fe200078e20ffULL, 0x0000001063007824ULL, 0x000fe200078e0200ULL,
0x0000000702027812ULL, 0x000fe200078e7863ULL, 0x0000001085087824ULL, 0x100fe400078e0264ULL,
0x0000001000007824ULL, 0x000fe200078e00ffULL, 0x0000000263027211ULL, 0x000fe200078e20ffULL,
0x0000001082107824ULL, 0x000fc400078e0264ULL, 0x0000001091147824ULL, 0x100fe400078e0264ULL,
0x0000001002027824ULL, 0x000fe400078e00ffULL, 0x0000001095347824ULL, 0x000fe200078e0264ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000004783bULL, 0x0003e20000000200ULL,
0x00000010993c7824ULL, 0x000fc600078e0264ULL, 0x000000000c0c783bULL, 0x000ea80000000200ULL,
0x000000000808783bULL, 0x000ee20000000200ULL, 0x0000000c62007810ULL, 0x042fe40007ffe0ffULL,
0x0000000e62627810ULL, 0x000fe20007ffe0ffULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x0000000700007812ULL, 0x100fe400078e7863ULL, 0x0000000762627812ULL, 0x000fe200078e7863ULL,
0x000000001414783bULL, 0x000f240000000200ULL, 0x0000001063007824ULL, 0x000fc400078e0200ULL,
0x000000000218783bULL, 0x000fe20000000200ULL, 0x0000001063627824ULL, 0x000fe400078e0262ULL,
0x0000000400007819ULL, 0x000fe200000006ffULL, 0x000000003434783bULL, 0x000fe80000000200ULL,
0x000000004040783bULL, 0x000fe80000000200ULL, 0x000000003c3c783bULL, 0x000fe20000000200ULL,
0x0000000c041c723cULL, 0x044fee000000181cULL, 0x00000010930c7824ULL, 0x100fe200078e0264ULL,
0x0000000e0420723cULL, 0x040fea0000001820ULL, 0x000000000c0c783bULL, 0x000ea60000000200ULL,
0x00000008045c723cULL, 0x048fee000000185cULL, 0x0000001081087824ULL, 0x100fe200078e0264ULL,
0x0000000a0458723cULL, 0x040fea0000001858ULL, 0x000000000808783bULL, 0x000ee60000000200ULL,
0x000000100424723cULL, 0x042fee0000001824ULL, 0x0000001097107824ULL, 0x100fe200078e0264ULL,
0x000000120428723cULL, 0x040fea0000001828ULL, 0x000000001010783bULL, 0x000e660000000200ULL,
0x00000014042c723cULL, 0x050ff0000000182cULL, 0x000000160430723cULL, 0x000fe20000001830ULL,
0x000000000014783bULL, 0x0009ec0000000200ULL, 0x00000010a1047824ULL, 0x000fe200078e0264ULL,
0x0000000c181c723cULL, 0x004fe2000000181cULL, 0x0000ffff86007812ULL, 0x010fc800078ec0ffULL,
0x000000000404783bULL, 0x000ea20000000200ULL, 0x0000888000027816ULL, 0x000fe200000000ffULL,
0x000000109d0c7824ULL, 0x100fe200078e0264ULL, 0x0000000e1820723cULL, 0x040fe60000001820ULL,
0x8000000002007824ULL, 0x000fe400078e00ffULL, 0x000000000c0c783bULL, 0x000f260000000200ULL,
0x00000008185c723cULL, 0x048fee000000185cULL, 0x000000109f087824ULL, 0x100fe200078e0264ULL,
0x000000341824723cULL, 0x040fee0000001824ULL, 0x000000109b347824ULL, 0x100fe200078e0264ULL,
0x0000000a1858723cULL, 0x040fe20000001858ULL, 0x000000000808783bULL, 0x000eee0000000200ULL,
0x000000361828723cULL, 0x040fe20000001828ULL, 0x000000003434783bULL, 0x000f6e0000000200ULL,
0x00000010182c723cULL, 0x042fee000000182cULL, 0x0000001062107824ULL, 0x000fe200078e00ffULL,
0x000000121830723cULL, 0x000fea0000001830ULL, 0x000000001010783bULL, 0x000e640000000200ULL,
0x0000001092187824ULL, 0x100fe200078e0264ULL, 0x00000004145c723cULL, 0x044fea000000185cULL,
0x000000001818783bULL, 0x000ea40000000200ULL, 0x00000010a3047824ULL, 0x000fe200078e0264ULL,
0x000000061458723cULL, 0x040fea0000001858ULL, 0x000000000404783bULL, 0x000e660000000200ULL,
0x0000000c1424723cULL, 0x050ff00000001824ULL, 0x0000000e1428723cULL, 0x040ff00000001828ULL,
0x00000008141c723cULL, 0x048ff0000000181cULL, 0x0000000a1420723cULL, 0x040ff00000001820ULL,
0x000000341408723cULL, 0x060ff0000000182cULL, 0x000000361430723cULL, 0x000ff00000001830ULL,
0x00000040100c723cULL, 0x042ff00000001824ULL, 0x000000421040723cULL, 0x040fe20000001828ULL,
0x0236140088297984ULL, 0x000e6e0000000800ULL, 0x000000181014723cULL, 0x044ff0000000181cULL,
0x0000001a1018723cULL, 0x000fe20000001820ULL, 0x3db504f30c1e7820ULL, 0x000fc40000410000ULL,
0x3db504f30d1d7820ULL, 0x000fca0000410000ULL, 0x000000041008723cULL, 0x000fe20000001808ULL,
0x3db504f3401c7820ULL, 0x000fce0000410000ULL, 0x0000003c105c723cULL, 0x040fe2000000185cULL,
0x3db504f315217820ULL, 0x000fe40000410000ULL, 0x3db504f316157820ULL, 0x000fe40000410000ULL,
0x3db504f317167820ULL, 0x000fe40000410000ULL, 0x3db504f314227820ULL, 0x000fe20000410000ULL,
0x0000003e1058723cULL, 0x000fe20000001858ULL, 0x3db504f31a177820ULL, 0x000fe20000410000ULL,
0x8000000029ff7812ULL, 0x002fe20007804800ULL, 0x3db504f318207820ULL, 0x000fc40000410000ULL,
0x3db504f3191f7820ULL, 0x000fc60000410000ULL, 0x000000061004723cULL, 0x000fe20000001830ULL,
0x3db504f3081a7820ULL, 0x000fe40000410000ULL, 0x3db504f309197820ULL, 0x000fe40000410000ULL,
0x3db504f30a0d7820ULL, 0x000fe40000410000ULL, 0x3db504f31b137820ULL, 0x000fe40000410000ULL,
0x3db504f30e107820ULL, 0x000fe40000410000ULL, 0x3db504f30f117820ULL, 0x000fc40000410000ULL,
0x3db504f35c277820ULL, 0x000fe40000410000ULL, 0x3db504f35d267820ULL, 0x000fe40000410000ULL,
0x3db504f35e5e7820ULL, 0x000fe40000410000ULL, 0x3db504f35f5f7820ULL, 0x000fe40000410000ULL,
0x3db504f358257820ULL, 0x000fe40000410000ULL, 0x3db504f359237820ULL, 0x000fc40000410000ULL,
0x3db504f35a5a7820ULL, 0x000fe40000410000ULL, 0x3db504f35b5b7820ULL, 0x000fe40000410000ULL,
0x3db504f3411b7820ULL, 0x000fe40000410000ULL, 0x3db504f342127820ULL, 0x000fe40000410000ULL,
0x3db504f3430f7820ULL, 0x000fe40000410000ULL, 0x3db504f30b0e7820ULL, 0x000fc40000410000ULL,
0x3db504f304187820ULL, 0x000fe40000410000ULL, 0x3db504f305087820ULL, 0x000fe40000410000ULL,
0x3db504f306037820ULL, 0x000fe40000410000ULL, 0x3db504f3070c7820ULL, 0x000fe20000410000ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe400078e005eULL, 0x000000ffff097224ULL, 0x000fc400078e005fULL,
0x000000ffff0b7224ULL, 0x000fe400078e005aULL, 0x000000ffff147224ULL, 0x000fe200078e005bULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000002057824ULL, 0x000fe200078e00ffULL,
0x3e00000000007802ULL, 0x000fc80000000f00ULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x0236140088027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000047d007824ULL, 0x000fe200078e00ffULL,
0x000000879000720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff000057812ULL, 0x000fca00078ec0ffULL, 0x000000808e027824ULL, 0x000fca00078e0205ULL,
0x0234000002047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x000000027d247824ULL, 0x000fe400078e00ffULL, 0x000000018f2b7824ULL, 0x000fc600078e0a80ULL,
0x0000000624247812ULL, 0x000fc800078ec0ffULL, 0x0000000124287812ULL, 0x040fe400078efcffULL,
0x0000000824297812ULL, 0x000fe400078efcffULL, 0x0000002b2800720cULL, 0x080fe40003f26070ULL,
0x0000001024287812ULL, 0x000fe400078efcffULL, 0x0000002b2900720cULL, 0x080fe40003f06070ULL,
0x0000002b2800720cULL, 0x000fc40003fc6070ULL, 0x0000001124297812ULL, 0x040fe400078efcffULL,
0x0000001824287812ULL, 0x040fe400078efcffULL, 0x0000002b2400720cULL, 0x080fe40003f46070ULL,
0x0000002b2900720cULL, 0x080fe40003fa6070ULL, 0x0000002b2800720cULL, 0x000fe40003f66070ULL,
0x00000009242a7812ULL, 0x000fc400078efcffULL, 0x0000001924297812ULL, 0x040fe400078efcffULL,
0x0000002024287812ULL, 0x000fe400078efcffULL, 0xff7fffff0a0a7808ULL, 0x000fe40005000000ULL,
0xff7fffff27277808ULL, 0x000fe40005000000ULL, 0xff7fffff09097808ULL, 0x000fe40004800000ULL,
0xff7fffff26267808ULL, 0x000fc40004800000ULL, 0x0000002b2a00720cULL, 0x080fe40003f86070ULL,
0x0000002b2900720cULL, 0x080fe40003f46070ULL, 0x0000002b2800720cULL, 0x000fe40003f26070ULL,
0x0000002124297812ULL, 0x040fe400078efcffULL, 0x0000002824287812ULL, 0x000fe400078efcffULL,
0xff7fffff0b0b7808ULL, 0x000fc40004000000ULL, 0xff7fffff25257808ULL, 0x000fe40004000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff23237808ULL, 0x000fe40006000000ULL,
0x0000002b2900720cULL, 0x080fe40003f06070ULL, 0x0000002b2800720cULL, 0x000fe40003f86070ULL,
0x0000002924297812ULL, 0x000fc400078efcffULL, 0x0000003024287812ULL, 0x000fe400078efcffULL,
0xff7fffff15157808ULL, 0x000fe40007000000ULL, 0xff7fffff22227808ULL, 0x000fe40007000000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff21217808ULL, 0x000fe40006800000ULL,
0x0000002b2900720cULL, 0x000fc40003fc6070ULL, 0x0000002b2800720cULL, 0x000fe40003fa6070ULL,
0x0000003124297812ULL, 0x040fe400078efcffULL, 0x0000003824287812ULL, 0x040fe400078efcffULL,
0x0000003924247812ULL, 0x000fe400078efcffULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff20207808ULL, 0x000fc40005800000ULL, 0xff7fffff13137808ULL, 0x000fe40005000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40005000000ULL, 0xff7fffff10107808ULL, 0x000fe40004800000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40004800000ULL, 0x0000002b2900720cULL, 0x080fe40003f66070ULL,
0x0000002b2800720cULL, 0x000fc40003f46070ULL, 0x0000002b2400720cULL, 0x000fe40003f26070ULL,
0xff7fffff11117808ULL, 0x000fe40004000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004000000ULL,
0xff7fffff12127808ULL, 0x000fe40006000000ULL, 0xff7fffff1c1c7808ULL, 0x000fe40006000000ULL,
0xff7fffff0f0f7808ULL, 0x000fc40007000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40007000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40006800000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40005800000ULL, 0xff7fffff19197808ULL, 0x000fe40005800000ULL,
0xff7fffff03037808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40004800000ULL, 0xff7fffff08087808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002704297209ULL, 0x004fe40007810000ULL,
0x0000000a05247209ULL, 0x000fe40007810000ULL, 0x0000002629047209ULL, 0x000fe40007810000ULL,
0x0000000924247209ULL, 0x000fc40007810000ULL, 0x0000002504047209ULL, 0x000fe40007810000ULL,
0x0000000b24057209ULL, 0x000fe40007810000ULL, 0x0000002304297209ULL, 0x000fe40007810000ULL,
0x0000001405047209ULL, 0x000fe40007810000ULL, 0x0000002229247209ULL, 0x000fe40007810000ULL,
0x0000001504057209ULL, 0x000fc40007810000ULL, 0x0000002124297209ULL, 0x000fe40007810000ULL,
0x0000001605047209ULL, 0x000fe40007810000ULL, 0x0000002029247209ULL, 0x000fe40007810000ULL,
0x0000001704047209ULL, 0x000fe40007810000ULL, 0x0000001f24057209ULL, 0x000fe40007810000ULL,
0x0000001304297209ULL, 0x000fc40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000001029247209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000001124297209ULL, 0x000fe40007810000ULL, 0x0000001c05047209ULL, 0x000fe40007810000ULL,
0x0000001229247209ULL, 0x000fc40007810000ULL, 0x0000001b04057209ULL, 0x000fe40007810000ULL,
0x0000000f24247209ULL, 0x000fe40007810000ULL, 0x0000001a05047209ULL, 0x000fe40007810000ULL,
0x0000000d24057209ULL, 0x000fe40007810000ULL, 0x0000001904297209ULL, 0x000fe40007810000ULL,
0x0000000e05047209ULL, 0x000fc40007810000ULL, 0x0000001829297209ULL, 0x000fe40007810000ULL,
0x0000000304057209ULL, 0x000fe40007810000ULL, 0x00000008292a7209ULL, 0x000fe40007810000ULL,
0x0000000c052c7209ULL, 0x000fe20007810000ULL, 0x00000e827f007947ULL, 0x000fea000b800000ULL,
0x0c401f002a047f89ULL, 0x0004e400000e0000ULL, 0x000000042a2d7209ULL, 0x008fe20007810000ULL,
0x00000ec27f007947ULL, 0x000fea000b800000ULL, 0x0c401f002c047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007247f89ULL, 0x000f6200000e0000ULL,
0x000000042c287209ULL, 0x008fc60007810000ULL, 0x0c201f002d047f89ULL, 0x000ee200000e0000ULL,
0x0000000506297209ULL, 0x010fc60007810000ULL, 0x0c201f0028057f89ULL, 0x000f2200000e0000ULL,
0x0000002407247209ULL, 0x020fc60007810000ULL, 0x0c201f00292a7f89ULL, 0x006e6800000e0000ULL,
0x0c201f00242b7f89ULL, 0x0004a200000e0000ULL, 0x000000042d047209ULL, 0x008fe40007810000ULL,
0x0000000528057209ULL, 0x010fe40007810000ULL, 0x0000002a29067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b052e7820ULL, 0x002fe20000410000ULL, 0x0000000000087886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b23237823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b27277823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL, 0x0000002300287308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b25257823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1a1a7823ULL, 0x000fe40000010807ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe4000001082eULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001082eULL,
0x0000001a00237308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0a0a7823ULL, 0x000fc4000001082eULL,
0x3fb8aa3b09097823ULL, 0x000fe4000001082eULL, 0x3fb8aa3b19197823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010807ULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b21217823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b20207823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b1f1f7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010807ULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL, 0x0000002500257308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b08077823ULL, 0x000fc40000010807ULL, 0x3c003c00ff307424ULL, 0x000fe400078e00ffULL,
0x3c003c00ff317424ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001082eULL,
0x0000000a002d7308ULL, 0x0007e20000000800ULL, 0x000000272608723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b16167823ULL, 0x100fe4000001082eULL, 0x3fb8aa3b13137823ULL, 0x100fe4000001082eULL,
0x3fb8aa3b11267823ULL, 0x000fc4000001082eULL, 0x00000009001a7308ULL, 0x000e620000000800ULL,
0x00000025280a723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b10257823ULL, 0x100fe4000001082eULL,
0x3fb8aa3b12277823ULL, 0x100fe4000001082eULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe4000001082eULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe4000001082eULL,
0x3fb8aa3b0e0e7823ULL, 0x000fc4000001082eULL, 0x3fb8aa3b03037823ULL, 0x000fc6000001082eULL,
0x0000001400147308ULL, 0x000ee20000000800ULL, 0x0000002d1a09723eULL, 0x002fce00000000ffULL,
0x00000019002a7308ULL, 0x0003220000000800ULL, 0x0000000b140b723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b17197823ULL, 0x002fcc000001082eULL, 0x0000001800297308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0c2e7823ULL, 0x000fe2000001082eULL, 0x000000232a0c723eULL, 0x010fcc00000000ffULL,
0x00000007002c7308ULL, 0x000ff00000000800ULL, 0x0000001500187308ULL, 0x000ff00000000800ULL,
0x0000001600077308ULL, 0x0002f00000000800ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x000000300814723cULL, 0x002fee00000018ffULL, 0x0000002100217308ULL, 0x000e620000000800ULL,
0x000000180711723eULL, 0x008fc400000000ffULL, 0xfffffffc7d077812ULL, 0x000fca00078ec0ffULL,
0x0000002000207308ULL, 0x000ff00000000800ULL, 0x0000001f001f7308ULL, 0x000ee20000000800ULL,
0x000000222110723eULL, 0x002fce00000000ffULL, 0x0000001900197308ULL, 0x000ff00000000800ULL,
0x00000013001a7308ULL, 0x000e620000000800ULL, 0x000000201f12723eULL, 0x008fce00000000ffULL,
0x0000001c001c7308ULL, 0x000fe20000000800ULL, 0x000000191a13723eULL, 0x002fce00000000ffULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x000000301014723cULL, 0x000fee0000001814ULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000001d001d7308ULL, 0x000ee20000000800ULL,
0x0000001c1b1a723eULL, 0x002fe200000000ffULL, 0x0000000fff1c7424ULL, 0x000fca00078e00ffULL,
0x000000071c1c7219ULL, 0x000fe200000006ffULL, 0x0000002500257308ULL, 0x000fe60000000800ULL,
0x000000001c0773a1ULL, 0x000e6200000e8000ULL, 0x000000001c0573c4ULL, 0x000f280000004000ULL,
0x0000002600267308ULL, 0x000f620000000800ULL, 0x0000001e1d18723eULL, 0x008fce00000000ffULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000000f00207308ULL, 0x000ee20000000800ULL,
0x000000252619723eULL, 0x020fe400000000ffULL, 0x000000081cff7c12ULL, 0x002fc4000f804007ULL,
0x000000242b077209ULL, 0x004fc60007810000ULL, 0x0000000d000d7308ULL, 0x000fe20000000800ULL,
0x00000027201b723eULL, 0x008fce00000000ffULL, 0x0000000e00227308ULL, 0x0002a20000000800ULL,
0x000000301814723cULL, 0x000fee0000001814ULL, 0x0000000300037308ULL, 0x000fe20000000800ULL,
0x000000292c0e723eULL, 0x002fce00000000ffULL, 0x0000002e002e7308ULL, 0x000e620000000800ULL,
0x0000000d220d723eULL, 0x004fe400000000ffULL, 0x000000032e0f723eULL, 0x002fce00000000ffULL,
0x000000300c20723cULL, 0x000fe20000001814ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000ad205008947ULL, 0x010fde000b800000ULL, 0x001c1fff20147589ULL, 0x0002a400000e0000ULL,
0x000000001c0373a1ULL, 0x000ee200000e8000ULL, 0x000000001c0573c4ULL, 0x000f220000004000ULL,
0x0000000000087886ULL, 0x000fe400038e0100ULL, 0x000000081cff7c12ULL, 0x008fda000f804003ULL,
0x00000af205008947ULL, 0x010fea000b800000ULL, 0x001c1fff22157589ULL, 0x00072800000e0000ULL,
0x001c1fff01167589ULL, 0x00066800000e0000ULL, 0x001c1fff17177589ULL, 0x0006a400000e0000ULL,
0x00000002ff037819ULL, 0x000fe4000001167dULL, 0x0000000c00317812ULL, 0x002fc400078ec0ffULL,
0x00000007031c7812ULL, 0x048fe200078ec0ffULL, 0x0000000803217824ULL, 0x040fe200078e00ffULL,
0x00000003ff1f7212ULL, 0x000fe200078e33ffULL, 0x00000008031d7824ULL, 0x000fe200078e00ffULL,
0x000000037dff7812ULL, 0x000fe2000780c0ffULL, 0x00000008032c7824ULL, 0x040fe200078e00ffULL,
0x0000000803037810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8211e7812ULL, 0x100fe400078ee21cULL,
0x000000011d207812ULL, 0x100fe200078ef61cULL, 0x00000008033e7824ULL, 0x000fe200078e00ffULL,
0x000000021d227812ULL, 0x100fe200078ef61cULL, 0x0000000803217824ULL, 0x000fe200078e00ffULL,
0x000000031d247812ULL, 0x000fc400078ef61cULL, 0x000000041d267812ULL, 0x140fe400078ef61cULL,
0x000000051d287812ULL, 0x140fe400078ef61cULL, 0x000000061d2a7812ULL, 0x000fe200078ef61cULL,
0x00000008031d7824ULL, 0x040fe200078e00ffULL, 0xfffffff82c2c7812ULL, 0x000fe400078ee21fULL,
0x00000003ff1f7212ULL, 0x000fe400078e33ffULL, 0x00000007031c7812ULL, 0x000fc400078ec0ffULL,
0x000110008e037811ULL, 0x000fe400078e58ffULL, 0xfffffff8212e7812ULL, 0x100fe400078ee21cULL,
0x000000011d307812ULL, 0x140fe400078ef61cULL, 0x000000031e007211ULL, 0x080fe200078e20ffULL,
0x00000010221e7824ULL, 0x100fe200078e0203ULL, 0x000000021d327812ULL, 0x140fe200078ef61cULL,
0x0000001026227824ULL, 0x100fe200078e0203ULL, 0x000000031d347812ULL, 0x140fe200078ef61cULL,
0x000000102a267824ULL, 0x100fe200078e0203ULL, 0x000000041d367812ULL, 0x140fe200078ef61cULL,
0x00000010302a7824ULL, 0x100fe200078e0203ULL, 0x000000051d3a7812ULL, 0x140fe200078ef61cULL,
0x00000010322b7824ULL, 0x100fe200078e0203ULL, 0x000000061d3c7812ULL, 0x000fe200078ef61cULL,
0x00000010201c7824ULL, 0x000fe200078e0203ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee21fULL,
0x0000001024207824ULL, 0x100fe200078e0203ULL, 0x00000000311d7210ULL, 0x000fe20007ffe0ffULL,
0x0000001028247824ULL, 0x100fe200078e0203ULL, 0x000000033e307211ULL, 0x000fe200078e20ffULL,
0x000000102c287824ULL, 0x000fc400078e0203ULL, 0x000000102e007824ULL, 0x100fe200078e0203ULL,
0x000000081d007388ULL, 0x0003e20000000800ULL, 0x00000010342c7824ULL, 0x100fe400078e0203ULL,
0x00000010362d7824ULL, 0x100fe200078e0203ULL, 0x0000000031007210ULL, 0x040fe20007ffe0ffULL,
0x000000103a2e7824ULL, 0x100fe400078e0203ULL, 0x000000103c2f7824ULL, 0x000fe400078e0203ULL,
0x0000000131037824ULL, 0x000fc400078e021cULL, 0x00000001311f7824ULL, 0x040fe400078e021eULL,
0x0000000131217824ULL, 0x040fe200078e0220ULL, 0x0000000a03007388ULL, 0x0007e20000000800ULL,
0x0000000131237824ULL, 0x040fe400078e0222ULL, 0x0000000131257824ULL, 0x040fe200078e0224ULL,
0x000000101f007388ULL, 0x0007e20000000800ULL, 0x0000000131277824ULL, 0x040fe400078e0226ULL,
0x0000000131297824ULL, 0x040fe200078e0228ULL, 0x0000001221007388ULL, 0x0007e20000000800ULL,
0x00000001312a7824ULL, 0x000fc400078e022aULL, 0x00000001311c7824ULL, 0x040fe200078e022bULL,
0x0000001823007388ULL, 0x0007e20000000800ULL, 0x00000001312c7824ULL, 0x040fe400078e022cULL,
0x0000000131087824ULL, 0x042fe200078e022dULL, 0x0000001a25007388ULL, 0x0007e20000000800ULL,
0x00000001312e7824ULL, 0x040fe400078e022eULL, 0x00000001311e7824ULL, 0x040fe200078e022fULL,
0x0000000c27007388ULL, 0x0007e20000000800ULL, 0x0000000131307824ULL, 0x000fc600078e0230ULL,
0x0000000e29007388ULL, 0x0007e80000000800ULL, 0x0000000900007388ULL, 0x0007e80000000800ULL,
0x0000000b2a007388ULL, 0x0007e80000000800ULL, 0x000000111c007388ULL, 0x0007e80000000800ULL,
0x000000132c007388ULL, 0x0007e80000000800ULL, 0x0000001908007388ULL, 0x0007e80000000800ULL,
0x0000001b2e007388ULL, 0x0007e80000000800ULL, 0x0000000d1e007388ULL, 0x0007e80000000800ULL,
0x0000000f30007388ULL, 0x0007e80000000800ULL, 0x0230000402008388ULL, 0x0007e80000000c00ULL,
0x0232001402008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008b3800720cULL, 0x000fe20003f26070ULL, 0x0236080088ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff86ff7812ULL, 0x000fc4000780c0ffULL, 0x0000003800907202ULL, 0x000fe40000000f00ULL,
0x00000001ff867807ULL, 0x000fce0000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffb4a000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff327224ULL, 0x000fe200078e002cULL, 0x00011950002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fe400078e00ffULL,
0x000007a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2e7224ULL, 0x004fe200078e0030ULL,
0xffff862000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x002fe200078e002bULL,
0x0000001f00337802ULL, 0x000fe20000000f00ULL, 0xffffffffff347424ULL, 0x000fe200078e00ffULL,
0x000119c0002c7802ULL, 0x000fe40000000f00ULL, 0x0000073000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff2b7224ULL, 0x004fe200078e0030ULL, 0xffff85d000007947ULL, 0x000fea000383ffffULL,
0x00000002ff2b7424ULL, 0x000fe200078e00ffULL, 0x00011a3000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff2e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2f7424ULL, 0x000fe400078e00ffULL,
0x0000068000007944ULL, 0x002fea0003c00000ULL, 0x0000002b00047202ULL, 0x004fe20000000f00ULL,
0xfffff12000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x006fe200078e002cULL,
0x00011ab000287802ULL, 0x000fe20000000f00ULL, 0x00000002ff2b7424ULL, 0x000fe400078e00ffULL,
0x0000001fff2e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2f7424ULL, 0x000fe400078e00ffULL,
0x0000060000007944ULL, 0x000fea0003c00000ULL, 0x0000002b2c2c7209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x002fe200078e0006ULL, 0xffffffff002f7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2b7424ULL, 0x000fe200078e00ffULL, 0x00011b2000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff2e7424ULL, 0x000fc400078e00ffULL, 0x0000059000007944ULL, 0x000fea0003c00000ULL,
0x0000002b06067209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x002fe200078e0007ULL,
0x00011b9000287802ULL, 0x000fe20000000f00ULL, 0x00000002ff2b7424ULL, 0x000fc400078e00ffULL,
0x0000001fff2e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2f7424ULL, 0x000fe400078e00ffULL,
0x0000052000007944ULL, 0x000fea0003c00000ULL, 0x0000002b07247209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x002fe200078e002dULL, 0xffffffff002f7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2b7424ULL, 0x000fe200078e00ffULL, 0x00011c0000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff2e7424ULL, 0x000fe400078e00ffULL, 0x000004b000007944ULL, 0x000fea0003c00000ULL,
0x0000002b2d047209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x002fe200078e002cULL,
0x00011c7000287802ULL, 0x000fe20000000f00ULL, 0x00000001ff2b7424ULL, 0x000fc400078e00ffULL,
0x0000001fff2e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2f7424ULL, 0x000fe400078e00ffULL,
0x0000044000007944ULL, 0x000fea0003c00000ULL, 0x0000002b2c057209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x002fe200078e0006ULL, 0xffffffff002f7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2b7424ULL, 0x000fe200078e00ffULL, 0x00011ce000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff2e7424ULL, 0x000fe400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x0000002b06067209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x002fe200078e0024ULL,
0x00011d5000287802ULL, 0x000fe20000000f00ULL, 0x00000001ff2b7424ULL, 0x000fc400078e00ffULL,
0x0000001fff2e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2f7424ULL, 0x000fe400078e00ffULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0xffffef0000007947ULL, 0x000fea000383ffffULL,
0x0000002000317202ULL, 0x000fe20000000f00ULL, 0x000000ffff327224ULL, 0x000fe200078e00ffULL,
0x00011dc0002c7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff337424ULL, 0x000fe400078e00ffULL,
0x000000ffff347224ULL, 0x000fe400078e001cULL, 0x0000033000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0030ULL, 0xfffff4c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff317224ULL, 0x002fe200078e0022ULL, 0x0000001c00347202ULL, 0x000fe20000000f00ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x00011e40002c7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff337424ULL, 0x000fc400078e00ffULL, 0x000002b000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff327224ULL, 0x002fe200078e00ffULL, 0x00011ea0002c7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff337424ULL, 0x000fc400078e00ffULL, 0x000000ffff347224ULL, 0x000fe400078e001cULL,
0x000000ffff157224ULL, 0x004fe400078e0030ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff347224ULL, 0x002fe200078e001cULL, 0x0000003000167202ULL, 0x004fe20000000f00ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x00011f00002c7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff337424ULL, 0x000fe400078e00ffULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0030ULL, 0xfffff40000007947ULL, 0x000fea000383ffffULL,
0x0180000006027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000000600028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff06ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000006037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000600027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff087224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0037ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffedf5002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff297424ULL, 0x000fe200078e00ffULL,
0x0000002f00007348ULL, 0x000fe80003800000ULL, 0x0c00002b2a2b7389ULL, 0x0002a200000e002eULL,
0xfffedf1028007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff2d7424ULL, 0x000fe200078e00ffULL,
0x0000003400007348ULL, 0x000fe80003800000ULL, 0x0000003231307389ULL, 0x0002a200000e0033ULL,
0xfffeded02c007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000023680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x0000000000000210ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000007a8ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000820ULL, 0x00000000000003a0ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000bc0ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000be0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000bf0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000c10ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000c80ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000c88ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000c98ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000e80ULL, 0x0000000000012200ULL, 0xa800001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013080ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000013090ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013090ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000013510ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000c80ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012400ULL, 0x0000000000012400ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013080ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000013510ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_16_m_16_sm_80_cubin_len = 79344;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
