/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001cf40ULL, 0x000000000001cbc0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL,
0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL,
0x616e7265746e695fULL, 0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL,
0x705f796c66625f63ULL, 0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL,
0x6c6668735f30376dULL, 0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL,
0x616475635f5f245fULL, 0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL,
0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL,
0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL,
0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000028ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b00220000036fULL, 0x000000000001b380ULL, 0x0000000000000170ULL, 0x000b0022000003a2ULL,
0x000000000001b4f0ULL, 0x0000000000000040ULL, 0x000b0022000003cdULL, 0x000000000001b530ULL,
0x0000000000000050ULL, 0x000b0022000003f7ULL, 0x000000000001b580ULL, 0x0000000000000100ULL,
0x000a000300000465ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000485ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004b5ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001b680ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001b38000000000ULL, 0x0000040400000000ULL, 0x810c000001740400ULL,
0x006b600400288080ULL, 0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808692ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x0001b38000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80809f0828808081ULL, 0xd208288080a00828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x00288080d2920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x000000e000000000ULL, 0x0001b4f000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080a00828808081ULL, 0x80162880809f0828ULL, 0x0000000310288082ULL,
0x809f920000000000ULL, 0x0000000022002880ULL, 0x0000002cffffffffULL, 0x0000016000000000ULL,
0x0001b53000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL, 0x80a02880809f0900ULL,
0x0000000000002880ULL, 0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80809f0828808081ULL, 0x8016288080a00828ULL,
0x0000000310288082ULL, 0x80a0920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL,
0x000001e800000000ULL, 0x0001b58000000000ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000001700082f04ULL, 0x00082304000000deULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000011ULL,
0x0000001100081204ULL, 0x0008110400000000ULL, 0x0000000000000011ULL, 0x0000001000082304ULL,
0x0008120400000000ULL, 0x0000000000000010ULL, 0x0000001000081104ULL, 0x0008230400000000ULL,
0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0068016000000014ULL, 0x000c170400681903ULL,
0x0060000a00000000ULL, 0x000c17040021f000ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040081f000ULL,
0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000e6000043104ULL, 0xffffffff01cc2904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000019001cc2804ULL, 0x000005a000000360ULL, 0x0000319000002060ULL,
0x0000334000003230ULL, 0x00003620000034b0ULL, 0x0000399000003780ULL, 0x000039e0000039d0ULL,
0x0000437000003a10ULL, 0x00005360000052c0ULL, 0x000055f000005480ULL, 0x000058c000005760ULL,
0x00005b0000005ac0ULL, 0x00005b4000005b10ULL, 0x000071f0000061e0ULL, 0x000073a000007280ULL,
0x0000768000007510ULL, 0x000079e0000077e0ULL, 0x00007a3000007a20ULL, 0x0000807000007a60ULL,
0x0000910000009070ULL, 0x0000939000009220ULL, 0x0000966000009500ULL, 0x000098a000009860ULL,
0x000098e0000098b0ULL, 0x0000a0400000a020ULL, 0x0000a0600000a050ULL, 0x0000ce800000ce40ULL,
0x0000cec00000ce90ULL, 0x0000da800000da40ULL, 0x0000dae00000dab0ULL, 0x00018b7000018b30ULL,
0x00018b9000018b80ULL, 0x00018c0000018be0ULL, 0x00018c3000018c20ULL, 0x00019ff000019f90ULL,
0x0001a0c00001a060ULL, 0x0001a1800001a120ULL, 0x0001a2600001a1f0ULL, 0x0001a3400001a2d0ULL,
0x0001a4000001a3a0ULL, 0x0001a4d00001a470ULL, 0x0001a5900001a530ULL, 0x0001a6700001a600ULL,
0x0001a7500001a6e0ULL, 0x0001a8100001a7b0ULL, 0x0001a8e00001a880ULL, 0x0001a9a00001a940ULL,
0x0001aa800001aa10ULL, 0x0001ab600001aaf0ULL, 0x0001ac200001abc0ULL, 0x0001acf00001ac90ULL,
0x0001adb00001ad50ULL, 0x0001ae900001ae20ULL, 0x0001af700001af00ULL, 0x0001b0600001afe0ULL,
0x0001b1600001b0e0ULL, 0x0001b2600001b1e0ULL, 0x0001b3600001b2e0ULL, 0x0000045002003904ULL,
0x0001e600000000ffULL, 0x00000480003f0100ULL, 0x0001e6080000000dULL, 0x00000550003f0120ULL,
0x0001e6880000000dULL, 0x00000e80003f0120ULL, 0x0001e600000000ffULL, 0x00001080003f0107ULL,
0x0001e68c00000080ULL, 0x00001130003f0102ULL, 0x0001e68800000080ULL, 0x00002ea0003f0101ULL,
0x0001e60800000008ULL, 0x00002ec0003f0101ULL, 0x0001e60c00000008ULL, 0x00003090003f0105ULL,
0x0001e60c00000008ULL, 0x00004310003f0105ULL, 0x0001e6880000001cULL, 0x00005000003f0101ULL,
0x0001e6280000001bULL, 0x00005020003f0101ULL, 0x0001e62c0000001bULL, 0x000051f0003f0105ULL,
0x0001e62c0000001bULL, 0x00006190003f0105ULL, 0x000000000000001eULL, 0x00006f30003f0101ULL,
0x0001e6480000001cULL, 0x00006f50003f0101ULL, 0x0001e64c0000001cULL, 0x00007120003f0105ULL,
0x0001e64c0000001cULL, 0x00008050003f0105ULL, 0x000000000000001fULL, 0x00008dc0003f0101ULL,
0x0001e66800000066ULL, 0x00008de0003f0101ULL, 0x0001e66c00000066ULL, 0x00008fb0003f0105ULL,
0x0001e66c00000066ULL, 0x00009ea0003f0105ULL, 0x0000000000000002ULL, 0x0000fa60003f0101ULL,
0x0001e600000000ffULL, 0x00011290003f0101ULL, 0x0001e604000000ffULL, 0x000114a0003f0105ULL,
0x0001e604000000ffULL, 0x00015e20003f0105ULL, 0x00000000000000a0ULL, 0x00015ec0003f0101ULL,
0x00000004000000a0ULL, 0x00016090003f0105ULL, 0x00000004000000a0ULL, 0x00019de0003f0105ULL,
0x0001e608000000a1ULL, 0x00019e40003f0101ULL, 0x0001e610000000a1ULL, 0x00019ea0003f0101ULL,
0x0001e618000000a1ULL, 0x00019f10003f0101ULL, 0x0001e620000000a1ULL, 0x00033803003f0101ULL,
0x0000e8e000301c04ULL, 0x0000eba00000e910ULL, 0x0000ef800000ed90ULL, 0x0000f3600000f170ULL,
0x0000f7500000f550ULL, 0x000115000000f900ULL, 0x0000040100019f50ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x000000000000024cULL, 0x0000001700000002ULL, 0x00000000000001c4ULL, 0x0000001700000002ULL,
0x000000000000014cULL, 0x0000001700000002ULL, 0x00000000000000ccULL, 0x0000001700000002ULL,
0x0000000000000044ULL, 0x0000001700000002ULL, 0x0000000000000225ULL, 0x0000001700000002ULL,
0x000000000000019dULL, 0x0000001700000002ULL, 0x0000000000000122ULL, 0x0000001700000002ULL,
0x00000000000000a8ULL, 0x0000001700000002ULL, 0x000000000001e700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000a57919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff020424ULL, 0x000fe200078e00ffULL,
0x00000001a5040810ULL, 0x002fca0007ffe0ffULL, 0x00005c0004040625ULL, 0x000fc800078e0002ULL,
0x00005c00a5020625ULL, 0x000fe200078e0002ULL, 0x0000000604090981ULL, 0x0002aa000c1e1900ULL,
0x0000000602020981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ffa27624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x00000000009c7919ULL, 0x000e620000002600ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x00005a00ff117624ULL, 0x000fc400078e00ffULL, 0x00000000000a7919ULL, 0x000ee40000002300ULL,
0x0000590011117a24ULL, 0x000fe400078e02ffULL, 0x0000000000087919ULL, 0x000ee20000002100ULL,
0x0000000000007308ULL, 0x010f220000001000ULL, 0x00000004ff997e24ULL, 0x002fe2000f8e00ffULL,
0x0ffffffe00067810ULL, 0x010fe40007ffe0ffULL, 0x00000005ff9d7819ULL, 0x008fc80000011608ULL,
0x0000000600077305ULL, 0x0002e4000021f000ULL, 0x00001fff9d9d7589ULL, 0x000fe200000e0000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x008fc800078e0a07ULL,
0x000059000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b07077227ULL, 0x000fcc00078e0006ULL,
0x00000400070b7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a0bULL,
0x0000040003007624ULL, 0x000fca00078e02a2ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x000000010b0b2810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff0bba12ULL, 0x000fc800078e33ffULL, 0x0000000b00007306ULL, 0x000e620000209000ULL,
0x000000ff0b00720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00047810ULL, 0x002fcc0007ffe0ffULL, 0x0000000400057305ULL, 0x0002e4000021f000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000050b037224ULL, 0x008fc800078e02ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a03ULL, 0x0000000305057227ULL, 0x000fe400078e0004ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x0000009c05817227ULL, 0x000fca00078e00ffULL,
0x000000ff81007210ULL, 0x000fca0007ffe1ffULL, 0x000000000b007224ULL, 0x000fca00078e029cULL,
0x0000000b0000720cULL, 0x000fe20003f66070ULL, 0x000001000a037a24ULL, 0x002fe400078e0203ULL,
0x00001fff0a0a7589ULL, 0x000e6400000e0000ULL, 0x00000000030d7a24ULL, 0x000fd000078e0208ULL,
0x0000000100003824ULL, 0x000fe200078e0a0bULL, 0x0000000181813810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0d00720cULL, 0x040fe40003f25270ULL, 0x0000000b0000720cULL, 0x000fe40003f86070ULL,
0x0000000f0d00780cULL, 0x040fe40003f44070ULL, 0x000000030d00780cULL, 0x000fce0003f64070ULL,
0x3fffff80ff049424ULL, 0x000fe400078e00ffULL, 0x0000000181814810ULL, 0x000fe20007ffe0ffULL,
0x7fffff80ff059424ULL, 0x000fe200078e00ffULL, 0x0000000bff81d212ULL, 0x000fe200078e33ffULL,
0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL, 0x0000007f0d00780cULL, 0x000fe20003f84070ULL,
0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL, 0x01e60004ff009388ULL, 0x000fe20000000a00ULL,
0x000000ffff007224ULL, 0x000fe400078e0a81ULL, 0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL,
0x01e608060d00a388ULL, 0x000fe20000008a00ULL, 0x000000000b9c7224ULL, 0x000fc800078e029cULL,
0x000000209c9c7824ULL, 0x000fe400078e00ffULL, 0xff317217000cc802ULL, 0x000fca0000000f00ULL,
0x01e4000c0d00c388ULL, 0x000fe20000004800ULL, 0x00000001099e0824ULL, 0x004fe400078e0a02ULL,
0x00005800ff9e8624ULL, 0x000fe400078e00ffULL, 0x00005800a5028a24ULL, 0x000fe400078e02ffULL,
0x00005a009e037a24ULL, 0x000fe400078e02ffULL, 0x7fffff60ff09b424ULL, 0x000fe400078e00ffULL,
0x0000000103007824ULL, 0x040fe200078e0a9cULL, 0x0000009c0300720cULL, 0x000fe20003f26070ULL,
0x0000001102847224ULL, 0x000fe200078e02ffULL, 0x01e688080d00b388ULL, 0x000fe40000008a00ULL,
0x0000002000007817ULL, 0x000fe20003800000ULL, 0x00005a0081107a24ULL, 0x000fc600078e0284ULL,
0x000000ff00837207ULL, 0x000fe20000800000ULL, 0x000000040a007824ULL, 0x002fe200078e029dULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000208300780cULL, 0x000fe20003f05270ULL,
0x0000000400037824ULL, 0x000fd800078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00005a0000077b06ULL, 0x000e620000209000ULL, 0x0000000000007919ULL, 0x000eae0000000000ULL,
0x0000000700077308ULL, 0x002e620000001000ULL, 0x00000004ff067819ULL, 0x004fc80000011600ULL,
0x0000000206097810ULL, 0x000fe20007ffe0ffULL, 0x00000001030b7824ULL, 0x000fe200078e0206ULL,
0x0ffffffe07047810ULL, 0x002fc60007ffe0ffULL, 0x00000001030d7824ULL, 0x000fe200078e0209ULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x000000ffff047224ULL, 0x002fe200078e00ffULL,
0x80000005ff0f7210ULL, 0x004fca0007ffe0ffULL, 0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL,
0x0000000f05087227ULL, 0x000fc800078e0004ULL, 0x000000019c057824ULL, 0x040fe400078e020bULL,
0x000000019c0f7824ULL, 0x000fe400078e020dULL, 0x0000000508047227ULL, 0x000fc800078e00ffULL,
0x0000000f080c7227ULL, 0x000fc800078e00ffULL, 0x000000ffff087224ULL, 0x000fe400078e0a04ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0a0cULL, 0x00005a0008077a24ULL, 0x000fe400078e0205ULL,
0x00005a000e087a24ULL, 0x000fc600078e020fULL, 0x00005a0007007a0cULL, 0x000fe40003f06070ULL,
0x00005a0008007a0cULL, 0x000fd60003f46070ULL, 0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL,
0x80005a0008082a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0007007a0cULL, 0x000fe40003f26070ULL,
0x00005a0008007a0cULL, 0x000fe40003f66070ULL, 0x0000000104040810ULL, 0x000fe40007ffe0ffULL,
0x000000010c0c2810ULL, 0x000fc40007ffe0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x00005a00ff077a12ULL, 0x000fc600078e33ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x000000010c0c3810ULL, 0x000fe40007ffe0ffULL, 0x0000000407087207ULL, 0x040fe40004000000ULL,
0x0000000c07077207ULL, 0x000fe40004000000ULL, 0x0000000383047217ULL, 0x000fe20007800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0a08ULL, 0x000000ff070e7210ULL, 0x000fc60007ffe1ffULL,
0x00005a000c057a24ULL, 0x000fe400078e0205ULL, 0x00005a000e0f7a24ULL, 0x000fe400078e020fULL,
0x0000000110057824ULL, 0x040fe400078e0205ULL, 0x00000001100c7824ULL, 0x000fe400078e020fULL,
0x0000000104047824ULL, 0x000fe400078e0a03ULL, 0x0000001108057224ULL, 0x000fc400078e0205ULL,
0x0000001000037824ULL, 0x000fe200078e00ffULL, 0x000000040600720cULL, 0x080fe20003f06070ULL,
0x0000001107077224ULL, 0x000fe200078e020cULL, 0x000000040900720cULL, 0x000fe20003f26070ULL,
0x0000010005047825ULL, 0x000fe200078e00ffULL, 0x000000f003097812ULL, 0x000fc600078ec0ffULL,
0x0000010007067825ULL, 0x000fe200078e00ffULL, 0x0000000904047212ULL, 0x000fc600078efcffULL,
0x000000010b087824ULL, 0x140fe200078e0200ULL, 0x0000000906067212ULL, 0x000fe200078efcffULL,
0x000000100b0f7824ULL, 0x000fe200078e00ffULL, 0x0000600004047a10ULL, 0x000fe20007f5e0ffULL,
0x000000010d0b7824ULL, 0x040fe200078e0200ULL, 0x0000600006067a10ULL, 0x000fe20007f7e0ffULL,
0x000000100d0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff00f087812ULL, 0x000fe400078ee208ULL,
0x0000610005057a10ULL, 0x000fe400017fe4ffULL, 0xfffffff00c0b7812ULL, 0x000fc400078ee20bULL,
0x0000000408097819ULL, 0x000fe400000006ffULL, 0x0000610007077a10ULL, 0x000fe20001ffe4ffULL,
0x000000100b0b7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e8000c101c46ULL, 0x00000000060b7faeULL, 0x0003e2000c901c46ULL,
0x0000040000007947ULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000000007919ULL, 0x000eae0000000000ULL, 0x0000000600067308ULL, 0x002e620000001000ULL,
0x0000000300097211ULL, 0x004fc800078fe0ffULL, 0x00000002090b7810ULL, 0x040fe20007ffe0ffULL,
0x00000010090f7824ULL, 0x000fe200078e00ffULL, 0x0ffffffe06057810ULL, 0x002fc60007ffe0ffULL,
0x000000019c067824ULL, 0x000fe400078e020bULL, 0x000000100b0c7824ULL, 0x000fe200078e00ffULL,
0x0000000500057305ULL, 0x000e64000021f000ULL, 0x000000ffff047224ULL, 0x002fc800078e0a05ULL,
0x00005a0004037a24ULL, 0x000fe400078e02ffULL, 0x000000ffff047224ULL, 0x000fc800078e00ffULL,
0x0000000305077227ULL, 0x000fc800078e0004ULL, 0x000000019c037824ULL, 0x000fc800078e0209ULL,
0x0000000307047227ULL, 0x000fc800078e00ffULL, 0x0000000607077227ULL, 0x000fc800078e00ffULL,
0x000000ffff087224ULL, 0x000fe400078e0a04ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x00005a0008057a24ULL, 0x000fe400078e0203ULL, 0x00005a000d087a24ULL, 0x000fc600078e0206ULL,
0x00005a0005007a0cULL, 0x000fe40003f06070ULL, 0x00005a0008007a0cULL, 0x000fd60003f46070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0008082a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x00005a0008007a0cULL, 0x000fe40003f66070ULL,
0x0000000104040810ULL, 0x000fe40007ffe0ffULL, 0x0000000107072810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff057a12ULL, 0x000fc600078e33ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x0000000107073810ULL, 0x000fe40007ffe0ffULL,
0x0000000405047207ULL, 0x040fe40004000000ULL, 0x0000000705077207ULL, 0x000fc60004000000ULL,
0x000000ffff087224ULL, 0x000fe200078e0a04ULL, 0x000000ff07057210ULL, 0x000fc60007ffe1ffULL,
0x00005a0008037a24ULL, 0x000fe400078e0203ULL, 0x00005a0005067a24ULL, 0x000fe400078e0206ULL,
0x0000000110057824ULL, 0x040fe400078e0203ULL, 0x0000000110067824ULL, 0x000fe400078e0206ULL,
0x0000001000037824ULL, 0x000fe400078e00ffULL, 0x0000001104057224ULL, 0x000fc400078e0205ULL,
0x0000001107067224ULL, 0x000fe200078e0206ULL, 0x000000f0030d7812ULL, 0x000fe200078ec0ffULL,
0x0000010005047825ULL, 0x000fc800078e00ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000d04047212ULL, 0x000fc600078efcffULL, 0x0000000109087824ULL, 0x100fe200078e0200ULL,
0x0000000d06067212ULL, 0x000fe200078efcffULL, 0x000000010b097824ULL, 0x000fe200078e0200ULL,
0x0000600004047a10ULL, 0x000fe40007f1e0ffULL, 0xfffffff00f087812ULL, 0x000fe400078ee208ULL,
0x0000600006067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff00c0b7812ULL, 0x000fe200078ee209ULL,
0x0000001008097824ULL, 0x000fe200078e00ffULL, 0x0000610005057a10ULL, 0x000fc400007fe4ffULL,
0x0000610007077a10ULL, 0x000fe40000ffe4ffULL, 0x000000040b0b7819ULL, 0x000fe200000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e8000b901c46ULL,
0x00000000060b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000067806ULL, 0x000fe200038e0000ULL, 0x00000004ff9a7424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000600047300ULL, 0x000e7000000e0000ULL,
0x0000000600077309ULL, 0x000ea20000000000ULL, 0x000000050400720cULL, 0x002fe20003f02070ULL,
0x00006800a5047625ULL, 0x000fc800078e009aULL, 0x000000ffff077224ULL, 0x004fd000078e0a07ULL,
0x01e60407ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01e60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000604987981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0a00720cULL, 0x000fe40003f05270ULL, 0x0000007f98237810ULL, 0x044fe40007ffe0ffULL,
0x000000ff98227810ULL, 0x000fc40007ffe0ffULL, 0x00000007ff237819ULL, 0x000fe40000011623ULL,
0x00000008ff227819ULL, 0x000fca0000011622ULL, 0x0000e95000008947ULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x000fe2000001169dULL, 0x000000089d807824ULL, 0x000fe400078e00ffULL,
0x00000003ff077424ULL, 0x002fe200078e00ffULL, 0x01ffffff02027812ULL, 0x000fe200078ec0ffULL,
0xffffffffff197424ULL, 0x000fc800078e00ffULL, 0x00000002991a7824ULL, 0x000fca00078e0202ULL,
0x000000231a00720cULL, 0x000fda0003f06070ULL, 0x00000002a5028824ULL, 0x000fe400078e00ffULL,
0x00006a00ff058624ULL, 0x000fc800078e00ffULL, 0x00006a0002058624ULL, 0x000fca00078e0205ULL,
0x000000051a058210ULL, 0x000fe20007ffe0ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e68c0780ff738cULL, 0x0003e20000000000ULL, 0x00006600059a8625ULL, 0x000fe200078e009aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000069a198981ULL, 0x000ea2000c1e1900ULL,
0x0000000199057810ULL, 0x000fe20007ffe0ffULL, 0x0000008081167824ULL, 0x000fe200078e00ffULL,
0x00000001ff187819ULL, 0x000fe2000001169dULL, 0x01e6880080ff7f8cULL, 0x0007e2000c80043fULL,
0x000000220500720cULL, 0x000fe20003f06070ULL, 0x00000100ff057424ULL, 0x000fe200078e00ffULL,
0x000000019d157812ULL, 0x000fe200078ec0ffULL, 0x0000002018177824ULL, 0x000fc800078e00ffULL,
0x0000010099077824ULL, 0x002fca00078e0217ULL, 0x00000060162b7812ULL, 0x000fe200078ef807ULL,
0x0000590019027a24ULL, 0x004fc800078e02ffULL, 0x0000008002027824ULL, 0x000fc800078e00ffULL,
0x0000640002047625ULL, 0x000fe200078e0005ULL, 0x0000064000008947ULL, 0x000fea0003800000ULL,
0x00000003ff127819ULL, 0x108fe40000011600ULL, 0x0000000798027217ULL, 0x000fe40007800000ULL,
0x0000000412087810ULL, 0x040fe40007ffe0ffULL, 0x00000008120a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000102027824ULL, 0x000fe200078e0a07ULL, 0x0000000c120b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000108067824ULL, 0x100fe200078e0200ULL, 0x000000000a077210ULL, 0x000fe20007ffe0ffULL,
0x00000008081d7824ULL, 0x000fe200078e00ffULL, 0x0000002002137817ULL, 0x000fe20003800000ULL,
0x000000080a0c7824ULL, 0x000fe200078e00ffULL, 0x0000001012107810ULL, 0x000fe20007ffe0ffULL,
0x000000010b097824ULL, 0x000fe200078e0200ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL,
0x000000080b0e7824ULL, 0x000fe200078e00ffULL, 0x0000007003067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff037224ULL, 0x000fe200078e00ffULL, 0xfffffff80c1f7812ULL, 0x000fe200078ee207ULL,
0x000000012b077824ULL, 0x000fe200078e0212ULL, 0xfffffff80e217812ULL, 0x000fe200078ee209ULL,
0x0000008015027824ULL, 0x000fe200078e0206ULL, 0x000000130800720cULL, 0x000fe20003f86070ULL,
0x000000012b097824ULL, 0x000fe200078e0208ULL, 0x00000014121c7810ULL, 0x000fe20007ffe0ffULL,
0x0000010007067825ULL, 0x000fe200078e0002ULL, 0x0000000310147819ULL, 0x000fc400000006ffULL,
0x000000130a00720cULL, 0x080fe20003f66070ULL, 0x0000010009087825ULL, 0x000fe200078e0002ULL,
0x00000006040c7210ULL, 0x000fe40007f1e0ffULL, 0x000000130b00720cULL, 0x080fe20003f46070ULL,
0x00000001100d7824ULL, 0x100fe200078e0200ULL, 0x00000008040e7210ULL, 0x000fe20007f3e0ffULL,
0x000000011c0f7824ULL, 0x000fe200078e0200ULL, 0x000000131200720cULL, 0x000fe20003fa6070ULL,
0x000000081c1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff814257812ULL, 0x000fe200078ee20dULL,
0x00000001050d7824ULL, 0x000fc400000e0607ULL, 0x000000012b077824ULL, 0x000fe200078e020aULL,
0xfffffff81e277812ULL, 0x000fe200078ee20fULL, 0x00000001050f7824ULL, 0x000fe200008e0609ULL,
0x000000131000720cULL, 0x000fe20003f26070ULL, 0x000000012b097824ULL, 0x040fe200078e020bULL,
0x000000102b0b7210ULL, 0x000fe20007ffe0ffULL, 0x0000010007067825ULL, 0x000fe200078e0002ULL,
0x0000001c121e7810ULL, 0x000fc60007ffe0ffULL, 0x00000001120a7824ULL, 0x000fe200078e0200ULL,
0x0000000604107210ULL, 0x000fe20007f1e0ffULL, 0x0000010009087825ULL, 0x000fc600078e0002ULL,
0x000000070a1b7812ULL, 0x000fe200078ec0ffULL, 0x0000000218147824ULL, 0x000fe200078e0215ULL,
0x0000000804087210ULL, 0x000fe20007fde0ffULL, 0x000001000b0a7825ULL, 0x000fe200078e0002ULL,
0x0ffffff81b1b7812ULL, 0x000fe400078ef800ULL, 0x0001600014147811ULL, 0x000fe200078e68ffULL,
0x0000000105117824ULL, 0x000fe200000e0607ULL, 0x000000131c00720cULL, 0x000fe20003f06070ULL,
0x000000012b077824ULL, 0x000fe200078e021cULL, 0x00000018121c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105097824ULL, 0x000fe200030e0609ULL, 0x0000000a040a7210ULL, 0x000fe20007fde0ffULL,
0x0000010007067825ULL, 0x000fe200078e0002ULL, 0x0000001427277211ULL, 0x000fc600078e20ffULL,
0x000000101b1b7824ULL, 0x100fe400078e0214ULL, 0x000000101d1d7824ULL, 0x000fe400078e0214ULL,
0x00000001050b7824ULL, 0x000fe200030e060bULL, 0x0000000604127210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c1b7faeULL, 0x0003e2000e901c46ULL,
0x000000012b297824ULL, 0x000fe200078e021cULL, 0x000000131c00720cULL, 0x080fe20003fa6070ULL,
0x000000101f1f7824ULL, 0x000fe200078e0214ULL, 0x000000000e1d7faeULL, 0x0005e2000e101c46ULL,
0x000000131e00720cULL, 0x000fe20003f86070ULL, 0x0000000105137824ULL, 0x000fe200030e0607ULL,
0x0000001e2b2b7210ULL, 0x000fe20007ffe0ffULL, 0x0000010029067825ULL, 0x000fe200078e0002ULL,
0x00000000101f7faeULL, 0x0007e6000d901c46ULL, 0x000000011c0c7824ULL, 0x002fe200078e0200ULL,
0x0000000604067210ULL, 0x000fe20007fde0ffULL, 0x000000081c0d7824ULL, 0x000fc400078e00ffULL,
0x000000011e0e7824ULL, 0x044fe400078e0200ULL, 0x000000081e0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL, 0x000001002b027825ULL, 0x000fc600078e0002ULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee20eULL, 0x0000000105077824ULL, 0x000fe200030e0607ULL,
0x0000000204027210ULL, 0x000fe20007fde0ffULL, 0x0000001021217824ULL, 0x100fe400078e0214ULL,
0x0000001025257824ULL, 0x100fe400078e0214ULL, 0x000000100d0d7824ULL, 0x100fe200078e0214ULL,
0x0000000008217faeULL, 0x0007e2000d101c46ULL, 0x000000100f0f7824ULL, 0x000fe400078e0214ULL,
0x0000000105037824ULL, 0x000fe200030e0603ULL, 0x000000000a257faeULL, 0x0007e8000c901c46ULL,
0x0000000012277faeULL, 0x0007e8000c101c46ULL, 0x00000000060d7faeULL, 0x0007e8000e901c46ULL,
0x00000000020f7faeULL, 0x0007e2000e101c46ULL, 0x0000057000007947ULL, 0x000fea0003800000ULL,
0x0000000400097811ULL, 0x048fe400078fe8ffULL, 0x00000008000b7811ULL, 0x000fc400078fe8ffULL,
0x0000000c000d7811ULL, 0x040fe200078fe8ffULL, 0x0000000109027824ULL, 0x140fe200078e0200ULL,
0x0000001400117811ULL, 0x040fe200078fe8ffULL, 0x0000000809077824ULL, 0x000fe200078e00ffULL,
0x0000001800137811ULL, 0x040fe200078fe8ffULL, 0x000000010b067824ULL, 0x000fe200078e0200ULL,
0x000000030d1b7819ULL, 0x000fe200000006ffULL, 0x000000080b0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8071c7812ULL, 0x000fe200078ee202ULL, 0x000000010d027824ULL, 0x100fe200078e0200ULL,
0x0000007003127812ULL, 0x000fe200078ec0ffULL, 0x0000000111077824ULL, 0x000fe200078e0200ULL,
0xfffffff80f1e7812ULL, 0x000fe200078ee206ULL, 0x0000000811267824ULL, 0x000fe200078e00ffULL,
0x00000010000f7811ULL, 0x040fe200078fe8ffULL, 0x0000000113087824ULL, 0x000fe200078e0200ULL,
0xfffffff81b207812ULL, 0x000fe200078ee202ULL, 0x00000008131f7824ULL, 0x000fe200078e00ffULL,
0x0000000000027211ULL, 0x040fe200078fe8ffULL, 0x000000010f067824ULL, 0x040fe200078e0200ULL,
0x0000001c00037811ULL, 0x000fe200078fe8ffULL, 0x000000080f1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee207ULL, 0x000000012b1b7824ULL, 0x000fe200078e0213ULL,
0xfffffff81f287812ULL, 0x000fe200078ee208ULL, 0x00000008031f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d247812ULL, 0x000fe200078ee206ULL, 0x0000000218067824ULL, 0x000fe200078e0215ULL,
0x0000000702077812ULL, 0x000fe200078ec0ffULL, 0x0000000103027824ULL, 0x000fe200078e0200ULL,
0x000000092b097210ULL, 0x040fe20007ffe0ffULL, 0x000000012b1d7824ULL, 0x000fe200078e0203ULL,
0x0000002b00037211ULL, 0x000fe200078fe8ffULL, 0x0000008015127824ULL, 0x000fe200078e0212ULL,
0x000000ff00137202ULL, 0x000fe20000000f00ULL, 0x000000012b0b7824ULL, 0x000fe200078e020bULL,
0xfffffff81f2a7812ULL, 0x000fe200078ee202ULL, 0x000000012b0d7824ULL, 0x000fe200078e020dULL,
0x0ffffff807147812ULL, 0x000fe200078ef800ULL, 0x000000012b0f7824ULL, 0x000fc400078e020fULL,
0x000000012b117824ULL, 0x000fe200078e0211ULL, 0x00016000062b7811ULL, 0x000fe200078e68ffULL,
0x0000010003027825ULL, 0x000fc800078e0012ULL, 0x0000010009067825ULL, 0x000fe200078e0012ULL,
0x0000000204027210ULL, 0x000fc60007f1e0ffULL, 0x000001000b087825ULL, 0x100fe200078e0012ULL,
0x0000000604067210ULL, 0x040fe40007f3e0ffULL, 0x0000000305037210ULL, 0x000fe200007fe4ffULL,
0x000001000d0a7825ULL, 0x000fe200078e0012ULL, 0x0000000804087210ULL, 0x000fc60007f5e0ffULL,
0x000001000f0c7825ULL, 0x000fe200078e0012ULL, 0x0000000a040a7210ULL, 0x000fc60007f7e0ffULL,
0x00000100110e7825ULL, 0x000fe200078e0012ULL, 0x0000000c040c7210ULL, 0x000fc60007f1e0ffULL,
0x000001001b107825ULL, 0x000fc800078e0012ULL, 0x000001001d127825ULL, 0x000fc800078e0012ULL,
0x0000000105077824ULL, 0x040fe200008e0607ULL, 0x0000000e040e7210ULL, 0x000fe20007f3e0ffULL,
0x00000010141b7824ULL, 0x000fe400078e022bULL, 0x0000000105097824ULL, 0x040fe200010e0609ULL,
0x0000001004107210ULL, 0x000fe20007f5e0ffULL, 0x000000101c1d7824ULL, 0x000fe200078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000021b7faeULL, 0x0003e2000b901c46ULL,
0x00000001050b7824ULL, 0x000fe200018e060bULL, 0x0000001204047210ULL, 0x000fe20007f7e0ffULL,
0x000000101e1f7824ULL, 0x100fe200078e022bULL, 0x00000000061d7faeULL, 0x0003e2000b901c46ULL,
0x0000001020217824ULL, 0x000fc400078e022bULL, 0x0000001024257824ULL, 0x000fe200078e022bULL,
0x00000000081f7faeULL, 0x0003e2000b901c46ULL, 0x00000001050d7824ULL, 0x040fe400000e060dULL,
0x0000001026277824ULL, 0x000fe200078e022bULL, 0x000000000a217faeULL, 0x0003e2000b901c46ULL,
0x00000001050f7824ULL, 0x040fe400008e060fULL, 0x0000001028297824ULL, 0x000fe200078e022bULL,
0x000000000c257faeULL, 0x0003e2000b901c46ULL, 0x0000000105117824ULL, 0x000fc400010e0611ULL,
0x000000102a2b7824ULL, 0x000fe200078e022bULL, 0x000000000e277faeULL, 0x0003e2000b901c46ULL,
0x0000000105057824ULL, 0x000fc600018e0613ULL, 0x0000000010297faeULL, 0x0003e8000b901c46ULL,
0x00000000042b7faeULL, 0x0003e4000b901c46ULL, 0x000000229900720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff1b7424ULL, 0x002fe200078e00ffULL,
0x000000ff001d7202ULL, 0x000fe20000000f00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x008fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00007ef000000947ULL, 0x000fea0003800000ULL,
0x00000002a5147824ULL, 0x000fe400078e00ffULL, 0x00006a00ff037624ULL, 0x000fc400078e00ffULL,
0xff317217ff1b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff5f7224ULL, 0x000fe400078e00ffULL,
0x00006a0014147624ULL, 0x000fc400078e0203ULL, 0x000000109d027824ULL, 0x000fe200078e00ffULL,
0x0000000199037810ULL, 0x000fe20007ffe0ffULL, 0x0000590019197a24ULL, 0x010fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe002027812ULL, 0x000fe400078ec0ffULL,
0x000000220300720cULL, 0x000fe20003f06070ULL, 0x00000100ff037424ULL, 0x000fe400078e00ffULL,
0x0000010099027824ULL, 0x000fca00078e0202ULL, 0x0000004002077810ULL, 0x020fe20007ffe0ffULL,
0x0000008019027824ULL, 0x000fc600078e00ffULL, 0x0000006007057812ULL, 0x000fe200078ec0ffULL,
0x0000640002027625ULL, 0x000fc600078e0003ULL, 0x0000000516677210ULL, 0x000fe20007ffe0ffULL,
0x0000068000008947ULL, 0x000fea0003800000ULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x00000003ff207819ULL, 0x000fe20000011600ULL, 0x000000809d067824ULL, 0x000fe200078e00ffULL,
0x0000000798047217ULL, 0x000fe40007800000ULL, 0x0000007005097812ULL, 0x000fe400078ec0ffULL,
0x00000004200a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000104057824ULL, 0x000fe200078e0a07ULL,
0x0000008009047812ULL, 0x000fe200078ef806ULL, 0x000020009d077824ULL, 0x000fe200078e00ffULL,
0x0000000c201e7810ULL, 0x000fe20007ffe0ffULL, 0x000000010a067824ULL, 0x100fe200078e0200ULL,
0x00000008201c7810ULL, 0x000fe20007ffe0ffULL, 0x000000080a657824ULL, 0x000fe200078e00ffULL,
0x0000200007077812ULL, 0x000fe200078ec0ffULL, 0x000000081e6b7824ULL, 0x000fe200078e00ffULL,
0x0000001420667810ULL, 0x000fe20007ffe0ffULL, 0x000000011c087824ULL, 0x000fe200078e0200ULL,
0xfffffff865657812ULL, 0x000fe200078ee206ULL, 0x000000011e067824ULL, 0x000fe200078e0200ULL,
0x0000000718187211ULL, 0x000fe200078e70ffULL, 0x0000000120077824ULL, 0x040fe200078e0267ULL,
0x0000002005137817ULL, 0x000fe20003800000ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000001020647810ULL, 0x000fe20007ffe0ffULL, 0x000000081c697824ULL, 0x000fe200078e00ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee206ULL, 0x0000000166097824ULL, 0x000fe200078e0200ULL,
0x000000131c00720cULL, 0x080fe20003f06070ULL, 0x00000008660c7824ULL, 0x000fe200078e00ffULL,
0xfffffff869697812ULL, 0x000fe200078ee208ULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x000000132000720cULL, 0x000fc40003f86070ULL, 0xfffffff80c6f7812ULL, 0x000fe200078ee209ULL,
0x0000000164087824ULL, 0x000fe200078e0200ULL, 0x00000006020c7210ULL, 0x000fe20007f5e0ffULL,
0x00000008646d7824ULL, 0x000fe200078e00ffULL, 0x000000130a00720cULL, 0x0c0fe20003f66070ULL,
0x000000010a097824ULL, 0x000fe200078e0267ULL, 0x000000131e00720cULL, 0x000fe20003f26070ULL,
0x00000001030d7824ULL, 0x000fe200010e0607ULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee208ULL,
0x000000011c0b7824ULL, 0x000fe200078e0267ULL, 0x0000000020087210ULL, 0x000fe20007ffe0ffULL,
0x0000010009067825ULL, 0x000fe200078e0004ULL, 0x00017000181c7810ULL, 0x000fc40007ffe0ffULL,
0x00000007081f7812ULL, 0x000fe200078ec0ffULL, 0x000001000b087825ULL, 0x000fe200078e0004ULL,
0x0000000602187210ULL, 0x000fe40007f5e0ffULL, 0x0ffffff81f217812ULL, 0x000fe200078ef800ULL,
0x000000011e197824ULL, 0x000fe200078e0267ULL, 0x00000008021e7210ULL, 0x000fe40007fbe0ffULL,
0x0000001c65657211ULL, 0x000fe200078e20ffULL, 0x00000100190a7825ULL, 0x000fe200078e0004ULL,
0x0000001c20687810ULL, 0x000fc60007ffe0ffULL, 0x0000000103197824ULL, 0x040fe200010e0607ULL,
0x0000000a020a7210ULL, 0x000fe20007fde0ffULL, 0x0000000164077824ULL, 0x040fe200078e0267ULL,
0x000000136400720cULL, 0x080fe20003f46070ULL, 0x00000001031f7824ULL, 0x000fe200028e0609ULL,
0x0000001820647810ULL, 0x000fe20007ffe0ffULL, 0x0000001021097824ULL, 0x000fe200078e021cULL,
0x000000136600720cULL, 0x000fe20003fa6070ULL, 0x0000010007067825ULL, 0x000fc600078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c097faeULL, 0x0003e2000e101c46ULL,
0x0000000166217824ULL, 0x000fe200078e0267ULL, 0x000000136400720cULL, 0x080fe20003f86070ULL,
0x00000001030b7824ULL, 0x000fe200030e060bULL, 0x0000000602207210ULL, 0x000fe20007fde0ffULL,
0x0000000018657faeULL, 0x0005e2000d901c46ULL, 0x000000136800720cULL, 0x000fe20003f66070ULL,
0x0000000164137824ULL, 0x000fe400078e0267ULL, 0x0000010021087825ULL, 0x002fc800078e0004ULL,
0x0000000103217824ULL, 0x000fe200030e0607ULL, 0x0000000802087210ULL, 0x000fe20007fde0ffULL,
0x0000010013067825ULL, 0x000fc800078e0004ULL, 0x00000001680d7824ULL, 0x000fe400078e0267ULL,
0x00000001640c7824ULL, 0x140fe400078e0200ULL, 0x0000000864677824ULL, 0x000fe400078e00ffULL,
0x0000000103097824ULL, 0x000fe200030e0609ULL, 0x0000000602067210ULL, 0x000fe20007fde0ffULL,
0x0000000168137824ULL, 0x040fe200078e0200ULL, 0x0000000368687819ULL, 0x000fe200000006ffULL,
0x000001000d047825ULL, 0x000fe200078e0004ULL, 0xfffffff867677812ULL, 0x000fc400078ee20cULL,
0xfffffff868717812ULL, 0x000fe200078ee213ULL, 0x0000000103077824ULL, 0x000fe200030e0607ULL,
0x0000000402027210ULL, 0x000fe20007fde0ffULL, 0x00000010690d7824ULL, 0x100fe400078e021cULL,
0x000000106b137824ULL, 0x100fe200078e021cULL, 0x0000000503037210ULL, 0x000fe200037fe4ffULL,
0x000000106d197824ULL, 0x104fe200078e021cULL, 0x000000001e0d7faeULL, 0x0003e2000c101c46ULL,
0x000000106f657824ULL, 0x100fe400078e021cULL, 0x0000001067677824ULL, 0x100fe200078e021cULL,
0x000000000a137faeULL, 0x0003e2000c901c46ULL, 0x0000001071697824ULL, 0x000fc600078e021cULL,
0x0000000020197faeULL, 0x0003e8000d101c46ULL, 0x0000000008657faeULL, 0x0003e8000e901c46ULL,
0x0000000006677faeULL, 0x0003e8000e101c46ULL, 0x0000000002697faeULL, 0x0003e2000d901c46ULL,
0x000005b000007947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x040fe200078e00ffULL,
0x0000000400077811ULL, 0x040fe200078fe8ffULL, 0x000000809d217824ULL, 0x040fe200078e00ffULL,
0x0000000c000b7811ULL, 0x000fe200078fe8ffULL, 0x000020009d057824ULL, 0x000fe200078e00ffULL,
0x0000007004047812ULL, 0x000fe200078ec0ffULL, 0x00000008070d7824ULL, 0x000fe200078e00ffULL,
0x000000000b067210ULL, 0x0c0fe20007ffe0ffULL, 0x000000080b137824ULL, 0x000fe200078e00ffULL,
0x0000008004207812ULL, 0x000fe200078ef821ULL, 0x0000000107047824ULL, 0x000fe200078e0200ULL,
0x0000200005057812ULL, 0x000fe200078ec0ffULL, 0x0000000107077824ULL, 0x100fe200078e0267ULL,
0x0000000800097811ULL, 0x000fe200078fe8ffULL, 0x000000010b0b7824ULL, 0x000fe200078e0267ULL,
0xfffffff80d647812ULL, 0x000fe200078ee204ULL, 0x0000400018187824ULL, 0x000fe200078e0205ULL,
0x00000010000d7811ULL, 0x040fe200078fe8ffULL, 0x0000000109057824ULL, 0x000fe200078e0200ULL,
0xfffffff813687812ULL, 0x000fe200078ee206ULL, 0x0000000809667824ULL, 0x000fe200078e00ffULL,
0x00000018001f7811ULL, 0x040fe200078fe8ffULL, 0x000000010d047824ULL, 0x140fe200078e0200ULL,
0x0000001400197811ULL, 0x000fe200078fe8ffULL, 0x000000080d137824ULL, 0x000fe200078e00ffULL,
0xfffffff866667812ULL, 0x000fe200078ee205ULL, 0x000000011f067824ULL, 0x000fe200078e0200ULL,
0x0000006709097210ULL, 0x080fe20007ffe0ffULL, 0x000000081f217824ULL, 0x000fe200078e00ffULL,
0xfffffff8136a7812ULL, 0x000fe200078ee204ULL, 0x0000000119057824ULL, 0x040fe200078e0200ULL,
0x0000000000047211ULL, 0x040fe200078fe8ffULL, 0x00000008196c7824ULL, 0x000fe200078e00ffULL,
0x0000001c00137811ULL, 0x000fe200078fe8ffULL, 0x000000010d0d7824ULL, 0x100fe200078e0267ULL,
0xfffffff8216e7812ULL, 0x000fe200078ee206ULL, 0x0000000119197824ULL, 0x000fe200078e0267ULL,
0x0000000704217812ULL, 0x000fe200078ec0ffULL, 0x0000000113047824ULL, 0x140fe200078e0200ULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee205ULL, 0x0000000813657824ULL, 0x000fe200078e00ffULL,
0x0000006700057211ULL, 0x000fe200078fe8ffULL, 0x000000011f1f7824ULL, 0x100fe200078e0267ULL,
0x0ffffff8211c7812ULL, 0x000fe200078ef800ULL, 0x000000ffff217224ULL, 0x000fe200078e00ffULL,
0xfffffff865707812ULL, 0x000fe200078ee204ULL, 0x0000000113137824ULL, 0x000fe200078e0267ULL,
0x0001700018717810ULL, 0x000fe20007ffe0ffULL, 0x0000010005047825ULL, 0x000fc800078e0020ULL,
0x0000010007067825ULL, 0x000fe200078e0020ULL, 0x0000000402047210ULL, 0x000fc60007f1e0ffULL,
0x0000010009087825ULL, 0x000fe200078e0020ULL, 0x0000000602067210ULL, 0x000fc60007f3e0ffULL,
0x000001000b0a7825ULL, 0x100fe200078e0020ULL, 0x0000000802087210ULL, 0x040fe40007f5e0ffULL,
0x0000000703077210ULL, 0x000fe20000ffe4ffULL, 0x000001000d0c7825ULL, 0x000fe200078e0020ULL,
0x0000000a020a7210ULL, 0x000fc60007f7e0ffULL, 0x0000010019187825ULL, 0x000fc800078e0020ULL,
0x000001001f1e7825ULL, 0x000fe200078e0020ULL, 0x0000001802187210ULL, 0x000fc60007f3e0ffULL,
0x0000010013207825ULL, 0x000fe200078e0020ULL, 0x000000711c137211ULL, 0x000fc600078e20ffULL,
0x0000000103057824ULL, 0x040fe200000e0605ULL, 0x0000000c020c7210ULL, 0x040fe20007f1e0ffULL,
0x0000000103097824ULL, 0x040fe200010e0609ULL, 0x0000001e021e7210ULL, 0x000fe20007f5e0ffULL,
0x0000001064657824ULL, 0x000fe200078e0271ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004137faeULL, 0x0003e2000b901c46ULL, 0x00000001030b7824ULL, 0x000fe200018e060bULL,
0x0000002002027210ULL, 0x000fe20007f7e0ffULL, 0x0000001066677824ULL, 0x100fe200078e0271ULL,
0x0000000006657faeULL, 0x0003e2000b901c46ULL, 0x0000001068697824ULL, 0x000fc400078e0271ULL,
0x000000106a6b7824ULL, 0x000fe200078e0271ULL, 0x0000000008677faeULL, 0x0003e2000b901c46ULL,
0x00000001030d7824ULL, 0x040fe400000e060dULL, 0x000000106c6d7824ULL, 0x000fe200078e0271ULL,
0x000000000a697faeULL, 0x0003e2000b901c46ULL, 0x0000000103197824ULL, 0x040fe400008e0619ULL,
0x000000106e6f7824ULL, 0x000fe200078e0271ULL, 0x000000000c6b7faeULL, 0x0003e2000b901c46ULL,
0x00000001031f7824ULL, 0x000fc400010e061fULL, 0x0000001070717824ULL, 0x000fe200078e0271ULL,
0x00000000186d7faeULL, 0x0003e2000b901c46ULL, 0x0000000103037824ULL, 0x000fc600018e0621ULL,
0x000000001e6f7faeULL, 0x0003e8000b901c46ULL, 0x0000000002717faeULL, 0x0003e4000b901c46ULL,
0x00000300ff027624ULL, 0x002fe200078e00ffULL, 0x000000011a037812ULL, 0x000fe200078ec0ffULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000010300780cULL, 0x000fe40003f05070ULL, 0xffffffff02027811ULL, 0x000fc800078e08ffULL,
0x0000000102037807ULL, 0x000fca0004000000ULL, 0x00000001031a7824ULL, 0x000fca00078e021aULL,
0x000000231a00720cULL, 0x000fda0003f06070ULL, 0x0000001a14028210ULL, 0x000fe20007ffe0ffULL,
0x00000004ff038424ULL, 0x000fc800078e00ffULL, 0x0000660002028625ULL, 0x000fca00078e0003ULL,
0x0000000602198981ULL, 0x000322000c1e1900ULL, 0xffffffe080047812ULL, 0x040fe400078ec0ffULL,
0x0000001080057812ULL, 0x040fe400078ec0ffULL, 0x0000000880067812ULL, 0x000fc800078ec0ffULL,
0x0000000406087210ULL, 0x000fe20007ffe005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e6080008067f8cULL, 0x0022a4000c80043fULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x01e60c0008057984ULL, 0x000ee40000000800ULL, 0x8000000005ff7812ULL, 0x00cfe40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402097210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000904047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e60c0008057984ULL, 0x000ea40000000800ULL,
0x8000000005ff7812ULL, 0x004fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000137824ULL, 0x000fe200078e00ffULL, 0x00000001ff827819ULL, 0x000fe20000011600ULL,
0x000000209d027824ULL, 0x000fc600078e00ffULL, 0x0000007013137812ULL, 0x000fe400078ec0ffULL,
0xffffff8002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c82827812ULL, 0x000fc800078ec0ffULL,
0x0000000282027210ULL, 0x000fca0007ffe013ULL, 0x01e0000002047984ULL, 0x000ea80000000800ULL,
0x01e2000002037984ULL, 0x0006620000000800ULL, 0x0000001b0400720bULL, 0x004fe20003f1d000ULL,
0x00016dd27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000027806ULL, 0x008fc800000e0100ULL,
0x000000ff0200720cULL, 0x000fe20003f25270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff187224ULL, 0x000fd400078e001bULL,
0x0000071000009947ULL, 0x000fea0003800000ULL, 0x00000002ff067819ULL, 0x000fe4000001169dULL,
0x0000001b0400720bULL, 0x000fe40003f54000ULL, 0x0000009d0600720cULL, 0x000fe20003f25270ULL,
0x00016d927f007947ULL, 0x000fd4000b800000ULL, 0x0000000000057806ULL, 0x000fc400010e0100ULL,
0x000000809d079824ULL, 0x000fe200078e0213ULL, 0x0000001b04187209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000182079824ULL, 0x000fca00078e0207ULL,
0x01e4001807009388ULL, 0x0005e20000000800ULL, 0x000000ff0500720cULL, 0x000fda0003f25270ULL,
0x000005e000009947ULL, 0x000fea0003800000ULL, 0x0000001b18067221ULL, 0x004fe20000010100ULL,
0x000000ff05ff7812ULL, 0x000fe2000782c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b06067820ULL, 0x000fc80000410000ULL, 0x0000000600077308ULL, 0x000ea40000000800ULL,
0x000000071d1d7220ULL, 0x004fc80000410000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x000fe20000011600ULL, 0x00016ce27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e071e7589ULL, 0x0004e400000e0000ULL, 0x0000001e60607220ULL, 0x08cfe40000410000ULL,
0x0000001e61617220ULL, 0x080fe40000410000ULL, 0x0000001e24247220ULL, 0x080fe40000410000ULL,
0x0000001e25257220ULL, 0x080fe40000410000ULL, 0x0000001e28287220ULL, 0x080fe40000410000ULL,
0x0000001e29297220ULL, 0x000fc40000410000ULL, 0x0000001e2c2c7220ULL, 0x080fe40000410000ULL,
0x0000001e2d2d7220ULL, 0x080fe40000410000ULL, 0x0000001e30307220ULL, 0x080fe40000410000ULL,
0x0000001e31317220ULL, 0x080fe40000410000ULL, 0x0000001e34347220ULL, 0x080fe40000410000ULL,
0x0000001e35357220ULL, 0x000fc40000410000ULL, 0x0000001e38387220ULL, 0x080fe40000410000ULL,
0x0000001e39397220ULL, 0x080fe40000410000ULL, 0x0000001e3c3c7220ULL, 0x080fe40000410000ULL,
0x0000001e3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0005ff7812ULL, 0x000fe2000782c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x000fe200078ff0ffULL,
0x00016bd27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e071e7589ULL, 0x0004e400000e0000ULL,
0x0000001e62627220ULL, 0x08cfe40000410000ULL, 0x0000001e63637220ULL, 0x080fe40000410000ULL,
0x0000001e26267220ULL, 0x080fe40000410000ULL, 0x0000001e27277220ULL, 0x080fe40000410000ULL,
0x0000001e2a2a7220ULL, 0x080fe40000410000ULL, 0x0000001e2b2b7220ULL, 0x000fc40000410000ULL,
0x0000001e2e2e7220ULL, 0x080fe40000410000ULL, 0x0000001e2f2f7220ULL, 0x080fe40000410000ULL,
0x0000001e32327220ULL, 0x080fe40000410000ULL, 0x0000001e33337220ULL, 0x080fe40000410000ULL,
0x0000001e36367220ULL, 0x080fe40000410000ULL, 0x0000001e37377220ULL, 0x000fc40000410000ULL,
0x0000001e3a3a7220ULL, 0x080fe40000410000ULL, 0x0000001e3b3b7220ULL, 0x080fe40000410000ULL,
0x0000001e3e3e7220ULL, 0x080fe40000410000ULL, 0x0000001e3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000005ff7812ULL, 0x000fe2000782c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000010001e7811ULL, 0x000fe200078ff0ffULL, 0x00016ac27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e071e7589ULL, 0x0004e400000e0000ULL, 0x0000001e40407220ULL, 0x08cfe40000410000ULL,
0x0000001e41417220ULL, 0x080fe40000410000ULL, 0x0000001e44447220ULL, 0x080fe40000410000ULL,
0x0000001e45457220ULL, 0x080fe40000410000ULL, 0x0000001e48487220ULL, 0x080fe40000410000ULL,
0x0000001e49497220ULL, 0x000fc40000410000ULL, 0x0000001e4c4c7220ULL, 0x080fe40000410000ULL,
0x0000001e4d4d7220ULL, 0x080fe40000410000ULL, 0x0000001e50507220ULL, 0x080fe40000410000ULL,
0x0000001e51517220ULL, 0x080fe40000410000ULL, 0x0000001e54547220ULL, 0x080fe40000410000ULL,
0x0000001e55557220ULL, 0x000fc40000410000ULL, 0x0000001e58587220ULL, 0x080fe40000410000ULL,
0x0000001e59597220ULL, 0x080fe40000410000ULL, 0x0000001e5c5c7220ULL, 0x080fe40000410000ULL,
0x0000001e5d5d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000005ff7812ULL, 0x000fda000782c0ffULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000018001e7811ULL, 0x000fe200078ff0ffULL, 0x000169c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e071e7589ULL, 0x0004e400000e0000ULL, 0x0000001e42427220ULL, 0x08cfe40000410000ULL,
0x0000001e43437220ULL, 0x080fe40000410000ULL, 0x0000001e46467220ULL, 0x080fe40000410000ULL,
0x0000001e47477220ULL, 0x080fe40000410000ULL, 0x0000001e4a4a7220ULL, 0x080fe40000410000ULL,
0x0000001e4b4b7220ULL, 0x000fc40000410000ULL, 0x0000001e4e4e7220ULL, 0x080fe40000410000ULL,
0x0000001e4f4f7220ULL, 0x080fe40000410000ULL, 0x0000001e52527220ULL, 0x080fe40000410000ULL,
0x0000001e53537220ULL, 0x080fe40000410000ULL, 0x0000001e56567220ULL, 0x080fe40000410000ULL,
0x0000001e57577220ULL, 0x000fc40000410000ULL, 0x0000001e5a5a7220ULL, 0x080fe40000410000ULL,
0x0000001e5b5b7220ULL, 0x080fe40000410000ULL, 0x0000001e5e5e7220ULL, 0x080fe40000410000ULL,
0x0000001e5f5f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000000502ff7212ULL, 0x000fda00078230ffULL, 0x8000001804041221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b04041820ULL, 0x000fc80000410000ULL,
0x0000000400121308ULL, 0x000ea40000000800ULL, 0x0000001203031220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000001d031d7221ULL, 0x002fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000012ff02723eULL, 0x000fe400000000ffULL,
0x00000002ff037819ULL, 0x000fe40000011600ULL, 0x0000541002027816ULL, 0x000fe20000000002ULL,
0x000168127f007947ULL, 0x000fea000b800000ULL, 0x00001f0302117589ULL, 0x0002a400000e0000ULL,
0x00000008031e7810ULL, 0x000fe20007ffe0ffULL, 0x000168627f007947ULL, 0x000fea000b800000ULL,
0x00000010030f7810ULL, 0x000fe20007ffe0ffULL, 0x00001f1e02107589ULL, 0x00066a00000e0000ULL,
0x00001f0f020f7589ULL, 0x0006a400000e0000ULL, 0x00000018031e7810ULL, 0x008fe20007ffe0ffULL,
0x000168f27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e020e7589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000029d1c7824ULL, 0x040fe200078e00ffULL,
0x0000000800037812ULL, 0x002fe200078ec0ffULL, 0x000020009d1b7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000002c000007945ULL, 0x000fe20003800000ULL,
0x000000041c1f7812ULL, 0x000fc400078ec0ffULL, 0x0000000703037812ULL, 0x000fe400078ef800ULL,
0x0000001f00027211ULL, 0x048fe400078fe0ffULL, 0x0000001003217812ULL, 0x040fe200078efcffULL,
0x00000008031e7824ULL, 0x040fe200078e00ffULL, 0x0000000300047211ULL, 0x000fe200078fe0ffULL,
0x00000001030d7824ULL, 0x040fe200078e0202ULL, 0x0000000303067819ULL, 0x000fe200000006ffULL,
0x00000001020c7824ULL, 0x000fe200078e0221ULL, 0x0000000404097810ULL, 0x040fe20007ffe0ffULL,
0x000004009d027824ULL, 0x000fe200078e00ffULL, 0x00000002040b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000821057824ULL, 0x000fe200078e00ffULL, 0xfffffff81e097812ULL, 0x000fe200078ee209ULL,
0x0000000803077824ULL, 0x000fe200078e00ffULL, 0xfffff00002027812ULL, 0x000fc400078ec0ffULL,
0xfffffff8060d7812ULL, 0x040fe400078ee20dULL, 0xfffffff8050c7812ULL, 0x000fe200078ee20cULL,
0x0000000803057824ULL, 0x000fe200078e00ffULL, 0xfffffff8060b7812ULL, 0x000fe400078ee20bULL,
0x00012000021e7810ULL, 0x000fe40007ffe0ffULL, 0xffffc0001b067812ULL, 0x000fe400078ec0ffULL,
0xfffffff8050a7812ULL, 0x000fe200078ee204ULL, 0x000000100d747824ULL, 0x100fe200078e021eULL,
0x0000000615067211ULL, 0x000fe200078e68ffULL, 0x000000100c647824ULL, 0x000fe200078e021eULL,
0x0000000604087810ULL, 0x000fc40007ffe0ffULL, 0x0001600006067810ULL, 0x000fe20007ffe0ffULL,
0x000000007474783bULL, 0x000e620000000200ULL, 0xfffffff807087812ULL, 0x000fc600078ee208ULL,
0x000000006464783bULL, 0x000ee20000000200ULL, 0x000000100a707824ULL, 0x100fe400078e0206ULL,
0x000000100b6c7824ULL, 0x100fe400078e0206ULL, 0x0000001009047824ULL, 0x000fe200078e0206ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000001174747232ULL, 0x086fe40000000000ULL,
0x0000001176767232ULL, 0x000fe40000000000ULL, 0x0000001075757232ULL, 0x000fc40000000000ULL,
0x0000001077777232ULL, 0x000fe40000000000ULL, 0x0000000f64647232ULL, 0x088fe40000000000ULL,
0x0000000f66667232ULL, 0x000fe40000000000ULL, 0x0000000e65657232ULL, 0x080fe40000000000ULL,
0x0000000e67677232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001008687824ULL, 0x000fe200078e0206ULL, 0x000000007070783bULL, 0x000ee20000004200ULL,
0x000000021f1f7812ULL, 0x000fe200078efcffULL, 0x0000039000007945ULL, 0x000fe20003800000ULL,
0x00000001ff207819ULL, 0x000fe2000001169dULL, 0x000000000404783bULL, 0x000ea20000004200ULL,
0x0000001f00027211ULL, 0x000fc600078fe0ffULL, 0x000000006868783bULL, 0x000e620000004200ULL,
0x00000002201f7824ULL, 0x000fc600078e0215ULL, 0x000000006c6c783bULL, 0x000e640000004200ULL,
0x000160001f1f7811ULL, 0x000fe200078e68ffULL, 0x000000706440723cULL, 0x008f700000001840ULL,
0x000000047430723cULL, 0x086f700000001830ULL, 0x000000046450723cULL, 0x000b6e0000001850ULL,
0x0000000803047824ULL, 0x020fe200078e00ffULL, 0x000000067434723cULL, 0x000f620000001834ULL,
0x0000000821057824ULL, 0x000fce00078e00ffULL, 0x000000066454723cULL, 0x000b6e0000001854ULL,
0x0000000203077210ULL, 0x020fe20007ffe0ffULL, 0x0000000121067824ULL, 0x000fe200078e0202ULL,
0x0000002100027211ULL, 0x000fe200078fe0ffULL, 0x000000687438723cULL, 0x000f620000001838ULL,
0xfffffff804077812ULL, 0x000fc400078ee207ULL, 0xfffffff805067812ULL, 0x000fe400078ee206ULL,
0x0000000402037810ULL, 0x040fe20007ffe0ffULL, 0x0000001007787824ULL, 0x100fe200078e021eULL,
0x0000000202047810ULL, 0x000fe20007ffe0ffULL, 0x000000686458723cULL, 0x040b620000001858ULL,
0x00000010061e7824ULL, 0x000fe200078e021eULL, 0xfffffff805057812ULL, 0x000fe400078ee202ULL,
0x0000000602027810ULL, 0x000fe20007ffe0ffULL, 0x000000007878783bULL, 0x000e640000000200ULL,
0x0000000821687824ULL, 0x060fe200078e00ffULL, 0x000000726444723cULL, 0x000f620000001844ULL,
0x0000000821697824ULL, 0x000fc400078e00ffULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0xfffffff868037812ULL, 0x000fe400078ee203ULL, 0xfffffff869047812ULL, 0x000fe400078ee204ULL,
0x0000006c6448723cULL, 0x000f620000001848ULL, 0xfffffff821027812ULL, 0x000fce00078ee202ULL,
0x0000006e644c723cULL, 0x040f70000000184cULL, 0x0000006a645c723cULL, 0x000b64000000185cULL,
0x000000001e64783bULL, 0x0204ec0000000200ULL, 0x000000707460723cULL, 0x040b6e0000001860ULL,
0x0000001003707824ULL, 0x120fe200078e021fULL, 0x000000727424723cULL, 0x040f700000001824ULL,
0x0000006c7428723cULL, 0x040b6e0000001828ULL, 0x00000010056c7824ULL, 0x020fe200078e021fULL,
0x0000006e742c723cULL, 0x040f70000000182cULL, 0x0000006a743c723cULL, 0x000b6e000000183cULL,
0x0000001f04747211ULL, 0x020fe200078e20ffULL, 0x0000008000008947ULL, 0x000fd60003800000ULL,
0x0000001178787232ULL, 0x08efe40000000000ULL, 0x000000117a7a7232ULL, 0x000fc40000000000ULL,
0x0000001079797232ULL, 0x080fe40000000000ULL, 0x000000107b7b7232ULL, 0x000fe40000000000ULL,
0x0000000f64647232ULL, 0x080fe40000000000ULL, 0x0000000f66667232ULL, 0x000fe40000000000ULL,
0x0000000e65657232ULL, 0x080fe40000000000ULL, 0x0000000e67677232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x00efea0003800000ULL, 0x0000001002687824ULL, 0x000fe200078e021fULL,
0x000000006c6c783bULL, 0x000e620000004200ULL, 0x0000590019197a24ULL, 0x010fe200078e02ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ec0ffULL, 0x00000008991e7824ULL, 0x000fe200078e0220ULL,
0x000000007474783bULL, 0x000ea80000004200ULL, 0x000000007070783bULL, 0x000ee80000004200ULL,
0x000000006868783bULL, 0x000ea20000004200ULL, 0x0000006c7860723cULL, 0x042b700000001860ULL,
0x0000006e7824723cULL, 0x040b700000001824ULL, 0x000000747828723cULL, 0x044b700000001828ULL,
0x00000076782c723cULL, 0x040b70000000182cULL, 0x000000707830723cULL, 0x048b700000001830ULL,
0x000000727834723cULL, 0x040b700000001834ULL, 0x000000687838723cULL, 0x040b700000001838ULL,
0x0000006a783c723cULL, 0x000b70000000183cULL, 0x000000746448723cULL, 0x040b700000001848ULL,
0x00000076644c723cULL, 0x040b70000000184cULL, 0x000000706450723cULL, 0x040b700000001850ULL,
0x000000726454723cULL, 0x040b700000001854ULL, 0x0000006c6440723cULL, 0x040b700000001840ULL,
0x0000006e6444723cULL, 0x040b700000001844ULL, 0x000000686458723cULL, 0x040b700000001858ULL,
0x0000006a645c723cULL, 0x000b62000000185cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000001991f7810ULL, 0x000fe20007ffe0ffULL, 0x0000008019647824ULL, 0x020fe200078e00ffULL,
0x000000801e1e7811ULL, 0x000fe200078e28ffULL, 0x01e688001cff7f8cULL, 0x0003e2000c80043fULL,
0x000000221f00720cULL, 0x000fe20003f06070ULL, 0x00000100ff657424ULL, 0x000fe200078e00ffULL,
0x000000601e197812ULL, 0x000fc600078ec0ffULL, 0x0000640064647625ULL, 0x000fc800078e0065ULL,
0x0000000116797824ULL, 0x000fe200078e0219ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1c7819ULL, 0x102fe40000011600ULL,
0x000020001b1b7812ULL, 0x000fe400078ec0ffULL, 0x000000081c687810ULL, 0x040fe20007ffe0ffULL,
0x000000011c217824ULL, 0x000fe200078e0279ULL, 0x0000001e98197217ULL, 0x000fe20007800000ULL,
0x0000400020707824ULL, 0x000fe200078e021bULL, 0x000000041c667810ULL, 0x000fe20007ffe0ffULL,
0x00000001681f7824ULL, 0x000fe200078e0200ULL, 0x000000141c7c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000868747824ULL, 0x000fe200078e00ffULL, 0x0000000366727819ULL, 0x000fe200000006ffULL,
0x000000809d207824ULL, 0x000fe200078e00ffULL, 0x0000000c1c6e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000119197824ULL, 0x000fe200078e0a1eULL, 0xfffffff874747812ULL, 0x000fe200078ee21fULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x00000080131e7812ULL, 0x000fe200078ef820ULL,
0x0000000166677824ULL, 0x040fe200078e0279ULL, 0x0000002019197817ULL, 0x000fe20003800000ULL,
0x00000001661b7824ULL, 0x000fe200078e0200ULL, 0x000000101c787810ULL, 0x000fe20007ffe0ffULL,
0x0000010021207825ULL, 0x000fe200078e001eULL, 0x000000196600720cULL, 0x000fc40003f86070ULL,
0xfffffff872727812ULL, 0x000fe200078ee21bULL, 0x0000010067667825ULL, 0x000fe200078e001eULL,
0x00000020646a7210ULL, 0x000fe40007f1e0ffULL, 0x000000036e767819ULL, 0x000fe200000006ffULL,
0x000000017c6b7824ULL, 0x100fe200078e0200ULL, 0x00000066646c7210ULL, 0x000fe20007f3e0ffULL,
0x000000087c7e7824ULL, 0x000fe200078e00ffULL, 0x000000196e00720cULL, 0x0c0fe20003f46070ULL,
0x000000016e1b7824ULL, 0x100fe200078e0200ULL, 0x000000196800720cULL, 0x080fe20003f66070ULL,
0x00000001656d7824ULL, 0x040fe200008e0667ULL, 0xfffffff87e7e7812ULL, 0x000fe200078ee26bULL,
0x00000001656b7824ULL, 0x000fe200000e0621ULL, 0xfffffff876767812ULL, 0x000fe200078ee21bULL,
0x0000000168217824ULL, 0x100fe200078e0279ULL, 0x000000001c1b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000178697824ULL, 0x000fe200078e0200ULL, 0x000000191c00720cULL, 0x000fe20003fa6070ULL,
0x00000008787a7824ULL, 0x000fe200078e00ffULL, 0x000000071b717812ULL, 0x000fe200078ec0ffULL,
0x000000016e677824ULL, 0x000fe200078e0279ULL, 0x00016000701b7810ULL, 0x000fe20007ffe0ffULL,
0x0000010021207825ULL, 0x000fe200078e001eULL, 0xfffffff87a7a7812ULL, 0x000fc400078ee269ULL,
0x000000197800720cULL, 0x080fe20003f26070ULL, 0x0000010067667825ULL, 0x000fe200078e001eULL,
0x00000020646e7210ULL, 0x000fe40007f1e0ffULL, 0x0ffffff871207812ULL, 0x000fe200078ef800ULL,
0x0000000178697824ULL, 0x000fe200078e0279ULL, 0x0000006664667210ULL, 0x000fe20007fde0ffULL,
0x00000001656f7824ULL, 0x000fe200000e0621ULL, 0x0000001c1c787810ULL, 0x000fe20007ffe0ffULL,
0x0000010069687825ULL, 0x000fe200078e001eULL, 0x000000197c00720cULL, 0x000fc60003f06070ULL,
0x000000017c217824ULL, 0x000fe400078e0279ULL, 0x0000000165677824ULL, 0x000fe200030e0667ULL,
0x0000006864687210ULL, 0x000fe20007fde0ffULL, 0x0000001020737824ULL, 0x100fe400078e021bULL,
0x0000001072757824ULL, 0x000fe200078e021bULL, 0x000000181c727810ULL, 0x000fe20007ffe0ffULL,
0x0000010021207825ULL, 0x000fe200078e001eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a737faeULL, 0x0003e4000e901c46ULL, 0x000000197200720cULL, 0x080fe20003fa6070ULL,
0x0000000165697824ULL, 0x040fe200030e0669ULL, 0x0000002064707210ULL, 0x000fe20007fde0ffULL,
0x0000000172777824ULL, 0x100fe200078e0279ULL, 0x000000006c757faeULL, 0x0005e2000e101c46ULL,
0x000000197800720cULL, 0x040fe20003f86070ULL, 0x0000000178197824ULL, 0x000fe200078e0279ULL,
0x0000002165717210ULL, 0x000fe200037fe4ffULL, 0x0000010077207825ULL, 0x000fc800078e001eULL,
0x00000001721c7824ULL, 0x100fe200078e0200ULL, 0x0000002064207210ULL, 0x000fe20007fde0ffULL,
0x00000008726b7824ULL, 0x002fe400078e00ffULL, 0x00000001786a7824ULL, 0x040fe400078e0200ULL,
0x00000008786d7824ULL, 0x004fe200078e00ffULL, 0xfffffff86b1c7812ULL, 0x000fe200078ee21cULL,
0x00000100191e7825ULL, 0x000fc600078e001eULL, 0xfffffff86d6a7812ULL, 0x000fe200078ee26aULL,
0x0000000165217824ULL, 0x040fe200030e0621ULL, 0x0000001e641e7210ULL, 0x000fe20007fde0ffULL,
0x0000001074197824ULL, 0x100fe200078e021bULL, 0x0000001b7a6d7211ULL, 0x000fe200078e20ffULL,
0x00000010766b7824ULL, 0x100fe400078e021bULL, 0x000000107e737824ULL, 0x100fe200078e021bULL,
0x000000006e197faeULL, 0x0003e2000d901c46ULL, 0x000000101c757824ULL, 0x100fe400078e021bULL,
0x000000106a1b7824ULL, 0x000fe200078e021bULL, 0x00000000666b7faeULL, 0x0003e2000d101c46ULL,
0x00000001651f7824ULL, 0x000fc600030e061fULL, 0x00000000686d7faeULL, 0x0003e8000c901c46ULL,
0x0000000070737faeULL, 0x0003e8000c101c46ULL, 0x0000000020757faeULL, 0x0003e8000e901c46ULL,
0x000000001e1b7faeULL, 0x0003e2000e101c46ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x0000000400217811ULL, 0x042fe200078fe8ffULL, 0x000000ffff717224ULL, 0x000fe200078e00ffULL,
0x0000000c00697811ULL, 0x000fc400078fe8ffULL, 0x00000010006b7811ULL, 0x040fe200078fe8ffULL,
0x0000000121197824ULL, 0x100fe200078e0200ULL, 0x000020001b1b7812ULL, 0x000fe200078ec0ffULL,
0x00000008211e7824ULL, 0x000fe200078e00ffULL, 0x0000000800677811ULL, 0x040fe200078fe8ffULL,
0x00000001691c7824ULL, 0x140fe200078e0200ULL, 0x00000018006f7811ULL, 0x000fe200078fe8ffULL,
0x0000000869777824ULL, 0x000fe200078e00ffULL, 0xfffffff81e737812ULL, 0x000fe200078ee219ULL,
0x000000016b197824ULL, 0x000fe200078e0200ULL, 0x0000000367667819ULL, 0x000fe200000006ffULL,
0x0000400020207824ULL, 0x000fe200078e021bULL, 0xfffffff877777812ULL, 0x000fe200078ee21cULL,
0x000000086b1c7824ULL, 0x000fe200078e00ffULL, 0x00000014006d7811ULL, 0x000fe200078fe8ffULL,
0x00000001671b7824ULL, 0x100fe200078e0200ULL, 0x000000079d707819ULL, 0x000fe200000006ffULL,
0x000000086f7f7824ULL, 0x040fe200078e00ffULL, 0xfffffff81c7b7812ULL, 0x000fe200078ee219ULL,
0x000000016f1c7824ULL, 0x100fe200078e0200ULL, 0xfffffff866757812ULL, 0x000fe200078ee21bULL,
0x000000016d1b7824ULL, 0x040fe200078e0200ULL, 0x0000000000197211ULL, 0x040fe200078fe8ffULL,
0x000000086d1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff87f7f7812ULL, 0x000fe200078ee21cULL,
0x0000000121217824ULL, 0x100fe200078e0279ULL, 0x0000001c001c7811ULL, 0x000fe200078fe8ffULL,
0x0000000167677824ULL, 0x000fe200078e0279ULL, 0xfffffff81e7d7812ULL, 0x000fe200078ee21bULL,
0x0000000169697824ULL, 0x100fe200078e0279ULL, 0x0000008013707812ULL, 0x000fe200078ef870ULL,
0x000000011c1e7824ULL, 0x000fe200078e0200ULL, 0x00000079001f7211ULL, 0x080fe200078fe8ffULL,
0x000000081c857824ULL, 0x040fe200078e00ffULL, 0x00000007191b7812ULL, 0x000fe200078ec0ffULL,
0x000000016b6b7824ULL, 0x000fe200078e0279ULL, 0x000000791c197210ULL, 0x000fe20007ffe0ffULL,
0x0000010067667825ULL, 0x000fe200078e0070ULL, 0xfffffff885857812ULL, 0x000fc400078ee21eULL,
0x00016000201c7810ULL, 0x000fe20007ffe0ffULL, 0x000001001f1e7825ULL, 0x000fe200078e0070ULL,
0x0ffffff81b1b7812ULL, 0x000fe400078ef800ULL, 0x0000006664667210ULL, 0x040fe20007f5e0ffULL,
0x0000010021207825ULL, 0x000fe200078e0070ULL, 0x0000001e641e7210ULL, 0x000fc60007f1e0ffULL,
0x000000016d6d7824ULL, 0x000fe200078e0279ULL, 0x0000002064207210ULL, 0x000fe20007f3e0ffULL,
0x0000010069687825ULL, 0x000fc800078e0070ULL, 0x000000016f6f7824ULL, 0x000fe200078e0279ULL,
0x0000006864687210ULL, 0x000fe20007f7e0ffULL, 0x000001006b6a7825ULL, 0x000fc800078e0070ULL,
0x000001006d6c7825ULL, 0x000fc800078e0070ULL, 0x000001006f6e7825ULL, 0x000fc800078e0070ULL,
0x0000010019707825ULL, 0x000fc800078e0070ULL, 0x00000001651f7824ULL, 0x040fe200000e061fULL,
0x0000006a646a7210ULL, 0x040fe20007f1e0ffULL, 0x0000000165217824ULL, 0x000fe200008e0621ULL,
0x0000006c646c7210ULL, 0x040fe20007f3e0ffULL, 0x000000101b197824ULL, 0x100fe400078e021cULL,
0x0000000165677824ULL, 0x000fe200010e0667ULL, 0x0000006e646e7210ULL, 0x040fe20007f5e0ffULL,
0x00000010731b7824ULL, 0x100fe200078e021cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e197faeULL, 0x0003e2000b901c46ULL, 0x0000000165697824ULL, 0x000fe200018e0669ULL,
0x0000007064707210ULL, 0x000fe20007f7e0ffULL, 0x0000001075737824ULL, 0x100fe200078e021cULL,
0x00000000201b7faeULL, 0x0003e2000b901c46ULL, 0x0000001077757824ULL, 0x000fc400078e021cULL,
0x000000107b777824ULL, 0x100fe200078e021cULL, 0x0000000066737faeULL, 0x0003e2000b901c46ULL,
0x00000001656b7824ULL, 0x000fe400000e066bULL, 0x000000107d797824ULL, 0x100fe200078e021cULL,
0x0000001c857d7211ULL, 0x000fe200078e20ffULL, 0x00000001656d7824ULL, 0x000fe200008e066dULL,
0x0000000068757faeULL, 0x0003e2000b901c46ULL, 0x000000107f7b7824ULL, 0x000fe400078e021cULL,
0x00000001656f7824ULL, 0x040fe200010e066fULL, 0x000000006a777faeULL, 0x0003e2000b901c46ULL,
0x0000000165717824ULL, 0x000fc600018e0671ULL, 0x000000006c797faeULL, 0x0003e8000b901c46ULL,
0x000000006e7b7faeULL, 0x0003e8000b901c46ULL, 0x00000000707d7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe080197812ULL, 0x042fe400078ec0ffULL,
0x00000010801c7812ULL, 0x000fc400078ec0ffULL, 0x00000008801b7812ULL, 0x000fc800078ec0ffULL,
0x000000191b1b7210ULL, 0x000fe20007ffe01cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e628001b667f8cULL, 0x0002a4000c80043fULL, 0x00000000001e7805ULL, 0x000fc40000015200ULL,
0x01e62c001b197984ULL, 0x000ee40000000800ULL, 0x8000000019ff7812ULL, 0x00cfe40007804867ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ff00687202ULL, 0x000fe20000000f00ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000201e1c7210ULL, 0x000fca0007f1e1ffULL,
0x0000000121207824ULL, 0x000fe200000e0e1fULL, 0x003d09001c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2000720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2000720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff197819ULL, 0x000fc80000011420ULL,
0x0000001c19197211ULL, 0x000fca00078110ffULL, 0x000000ffff1c7224ULL, 0x000fca00000e0620ULL,
0x0000000219197819ULL, 0x000fc8000000121cULL, 0x000000190000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000168687810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e62c001b197984ULL, 0x000ea40000000800ULL,
0x8000000019ff7812ULL, 0x004fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000209d197824ULL, 0x000fca00078e00ffULL, 0xffffff80191c7812ULL, 0x000fc800078ec0ffULL,
0x0000008013197810ULL, 0x000fca0007ffe01cULL, 0x0000000182197824ULL, 0x000fca00078e0219ULL,
0x01e0000019697984ULL, 0x000ea80000000800ULL, 0x01e20000191c7984ULL, 0x0006620000000800ULL,
0x000000186900720bULL, 0x004fe20003f1d000ULL, 0x000150b27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000197806ULL, 0x008fc800000e0100ULL, 0x000000ff1900720cULL, 0x000fe20003f25270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff1b7224ULL, 0x002fd400078e0018ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x000000019d1e7811ULL, 0x000fe400078ff0ffULL, 0x000000186900720bULL, 0x000fe40003f34000ULL,
0x0000009d1e00720cULL, 0x000fe20003f05270ULL, 0x000150727f007947ULL, 0x000fd4000b800000ULL,
0x0000000000667806ULL, 0x000fc400008e0100ULL, 0x000000809d1f8824ULL, 0x000fe200078e0213ULL,
0x00000018691b8209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x00000001821e8824ULL, 0x000fca00078e021fULL, 0x01e4001b1e008388ULL, 0x0003e20000000800ULL,
0x000000ff6600720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x00000018691b7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff66ff7812ULL, 0x000fc6000780c0ffULL, 0x000000181b1b7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1b1b7820ULL, 0x000fc80000410000ULL, 0x0000001b00687308ULL, 0x000e640000000800ULL,
0x000000681d1d7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x000fe20000011600ULL, 0x00014fb27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x0002a400000e0000ULL, 0x0000001e60607220ULL, 0x084fe40000410000ULL,
0x0000001e61617220ULL, 0x080fe40000410000ULL, 0x0000001e24247220ULL, 0x080fe40000410000ULL,
0x0000001e25257220ULL, 0x000fc40000410000ULL, 0x0000001e28287220ULL, 0x080fe40000410000ULL,
0x0000001e29297220ULL, 0x080fe40000410000ULL, 0x0000001e2c2c7220ULL, 0x080fe40000410000ULL,
0x0000001e2d2d7220ULL, 0x080fe40000410000ULL, 0x0000001e30307220ULL, 0x080fe40000410000ULL,
0x0000001e31317220ULL, 0x000fc40000410000ULL, 0x0000001e34347220ULL, 0x080fe40000410000ULL,
0x0000001e35357220ULL, 0x080fe40000410000ULL, 0x0000001e38387220ULL, 0x080fe40000410000ULL,
0x0000001e39397220ULL, 0x080fe40000410000ULL, 0x0000001e3c3c7220ULL, 0x080fe40000410000ULL,
0x0000001e3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0066ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x000fe200078ff0ffULL,
0x00014ea27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e681e7589ULL, 0x0004e400000e0000ULL,
0x0000001e62627220ULL, 0x08cfe40000410000ULL, 0x0000001e63637220ULL, 0x080fe40000410000ULL,
0x0000001e26267220ULL, 0x080fe40000410000ULL, 0x0000001e27277220ULL, 0x080fe40000410000ULL,
0x0000001e2a2a7220ULL, 0x080fe40000410000ULL, 0x0000001e2b2b7220ULL, 0x000fc40000410000ULL,
0x0000001e2e2e7220ULL, 0x080fe40000410000ULL, 0x0000001e2f2f7220ULL, 0x080fe40000410000ULL,
0x0000001e32327220ULL, 0x080fe40000410000ULL, 0x0000001e33337220ULL, 0x080fe40000410000ULL,
0x0000001e36367220ULL, 0x080fe40000410000ULL, 0x0000001e37377220ULL, 0x000fc40000410000ULL,
0x0000001e3a3a7220ULL, 0x080fe40000410000ULL, 0x0000001e3b3b7220ULL, 0x080fe40000410000ULL,
0x0000001e3e3e7220ULL, 0x080fe40000410000ULL, 0x0000001e3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000066ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000010001e7811ULL, 0x000fe200078ff0ffULL, 0x00014d927f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x0004e400000e0000ULL, 0x0000001e40407220ULL, 0x08cfe40000410000ULL,
0x0000001e41417220ULL, 0x080fe40000410000ULL, 0x0000001e44447220ULL, 0x080fe40000410000ULL,
0x0000001e45457220ULL, 0x080fe40000410000ULL, 0x0000001e48487220ULL, 0x080fe40000410000ULL,
0x0000001e49497220ULL, 0x000fc40000410000ULL, 0x0000001e4c4c7220ULL, 0x080fe40000410000ULL,
0x0000001e4d4d7220ULL, 0x080fe40000410000ULL, 0x0000001e50507220ULL, 0x080fe40000410000ULL,
0x0000001e51517220ULL, 0x080fe40000410000ULL, 0x0000001e54547220ULL, 0x080fe40000410000ULL,
0x0000001e55557220ULL, 0x000fc40000410000ULL, 0x0000001e58587220ULL, 0x080fe40000410000ULL,
0x0000001e59597220ULL, 0x080fe40000410000ULL, 0x0000001e5c5c7220ULL, 0x080fe40000410000ULL,
0x0000001e5d5d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000066ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000018001e7811ULL, 0x000fe200078ff0ffULL, 0x00014c927f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x0004e400000e0000ULL, 0x0000001e42427220ULL, 0x08cfe40000410000ULL,
0x0000001e43437220ULL, 0x080fe40000410000ULL, 0x0000001e46467220ULL, 0x080fe40000410000ULL,
0x0000001e47477220ULL, 0x080fe40000410000ULL, 0x0000001e4a4a7220ULL, 0x080fe40000410000ULL,
0x0000001e4b4b7220ULL, 0x000fc40000410000ULL, 0x0000001e4e4e7220ULL, 0x080fe40000410000ULL,
0x0000001e4f4f7220ULL, 0x080fe40000410000ULL, 0x0000001e52527220ULL, 0x080fe40000410000ULL,
0x0000001e53537220ULL, 0x080fe40000410000ULL, 0x0000001e56567220ULL, 0x080fe40000410000ULL,
0x0000001e57577220ULL, 0x000fc40000410000ULL, 0x0000001e5a5a7220ULL, 0x080fe40000410000ULL,
0x0000001e5b5b7220ULL, 0x080fe40000410000ULL, 0x0000001e5e5e7220ULL, 0x080fe40000410000ULL,
0x0000001e5f5f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006619ff7212ULL, 0x000fe400078030ffULL, 0x00000018691b7209ULL, 0x000fd60007810000ULL,
0x8000001b69690221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b69690820ULL, 0x000fc80000410000ULL,
0x0000006900120308ULL, 0x000e640000000800ULL, 0x000000121c1c0220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000001d1c1d7221ULL, 0x000fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000012ff0e723eULL, 0x000fe400000000ffULL, 0x00000002ff197819ULL, 0x000fe40000011600ULL,
0x000054100e0e7816ULL, 0x000fe2000000000eULL, 0x00014af27f007947ULL, 0x000fea000b800000ULL,
0x00001f190e117589ULL, 0x0002a400000e0000ULL, 0x00000008191e7810ULL, 0x000fe20007ffe0ffULL,
0x00014b427f007947ULL, 0x000fea000b800000ULL, 0x00000010190f7810ULL, 0x000fe20007ffe0ffULL,
0x00001f1e0e107589ULL, 0x00066a00000e0000ULL, 0x00001f0f0e0f7589ULL, 0x0006a400000e0000ULL,
0x00000018191e7810ULL, 0x008fe20007ffe0ffULL, 0x00014bd27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e0e0e7589ULL, 0x0022e400000e0000ULL, 0x000004009d187824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000020009d197824ULL, 0x000fe200078e00ffULL,
0x0000016000007945ULL, 0x000fe40003800000ULL, 0xfffff00018187812ULL, 0x000fc400078ec0ffULL,
0xffffc000191c7812ULL, 0x000fe400078ec0ffULL, 0x0001300018187810ULL, 0x000fc60007ffe0ffULL,
0x00002000151c7824ULL, 0x000fe400078e021cULL, 0x000000100d7c7824ULL, 0x000fe200078e0218ULL,
0x000000180c187211ULL, 0x000fe400078e20ffULL, 0x000170001c1c7810ULL, 0x000fc60007ffe0ffULL,
0x000000007c7c783bULL, 0x000e640000000200ULL, 0x000000100a787824ULL, 0x100fe400078e021cULL,
0x000000001868783bULL, 0x0006a20000000200ULL, 0x000000100b747824ULL, 0x100fe400078e021cULL,
0x0000001009707824ULL, 0x000fe200078e021cULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x000000117c7c7232ULL, 0x086fe40000000000ULL, 0x000000117e7e7232ULL, 0x000fc40000000000ULL,
0x000000107d7d7232ULL, 0x080fe40000000000ULL, 0x000000107f7f7232ULL, 0x000fe40000000000ULL,
0x0000000f68687232ULL, 0x080fe40000000000ULL, 0x0000000f6a6a7232ULL, 0x000fe40000000000ULL,
0x0000000e69697232ULL, 0x088fe40000000000ULL, 0x0000000e6b6b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010086c7824ULL, 0x000fe200078e021cULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x00000002ff1c7819ULL, 0x100fe2000001169dULL,
0x0000029000007945ULL, 0x000fe20003800000ULL, 0x00000001ff187819ULL, 0x008fe2000001169dULL,
0x000000007474783bULL, 0x000ee20000004200ULL, 0x000130001c1e7811ULL, 0x002fc600078e60ffULL,
0x000000007070783bULL, 0x000e620000004200ULL, 0x00000002181f7824ULL, 0x000fc600078e0215ULL,
0x000000006c6c783bULL, 0x000ea40000004200ULL, 0x000170001f1f7811ULL, 0x000fe200078e68ffULL,
0x000000787c60723cULL, 0x050f700000001860ULL, 0x0000007a7c24723cULL, 0x040f700000001824ULL,
0x000000747c28723cULL, 0x048f700000001828ULL, 0x000000767c2c723cULL, 0x040f70000000182cULL,
0x000000707c30723cULL, 0x042f700000001830ULL, 0x000000727c34723cULL, 0x040f700000001834ULL,
0x0000006c7c38723cULL, 0x044f700000001838ULL, 0x0000006e7c3c723cULL, 0x000b6e000000183cULL,
0x00000010077c7824ULL, 0x120fe200078e021eULL, 0x000000786840723cULL, 0x000b620000001840ULL,
0x00000010061e7824ULL, 0x000fc800078e021eULL, 0x000000007c7c783bULL, 0x000e640000000200ULL,
0x0000001005787824ULL, 0x120fe200078e021fULL, 0x0000007a6844723cULL, 0x040f700000001844ULL,
0x000000746848723cULL, 0x040b6e0000001848ULL, 0x0000001f04747211ULL, 0x020fe200078e20ffULL,
0x00000076684c723cULL, 0x040f70000000184cULL, 0x000000706850723cULL, 0x040b6e0000001850ULL,
0x0000001003707824ULL, 0x020fe200078e021fULL, 0x000000726854723cULL, 0x040f700000001854ULL,
0x0000006c6858723cULL, 0x040f700000001858ULL, 0x0000006e685c723cULL, 0x000b64000000185cULL,
0x000000001e68783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000008947ULL, 0x000fde0003800000ULL, 0x000000117c7c7232ULL, 0x082fe40000000000ULL,
0x000000117e7e7232ULL, 0x000fc40000000000ULL, 0x000000107d7d7232ULL, 0x080fe40000000000ULL,
0x000000107f7f7232ULL, 0x000fe40000000000ULL, 0x0000000f68687232ULL, 0x088fe40000000000ULL,
0x0000000f6a6a7232ULL, 0x000fe40000000000ULL, 0x0000000e69697232ULL, 0x080fe40000000000ULL,
0x0000000e6b6b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x002fea0003800000ULL,
0x00000010026c7824ULL, 0x000fe200078e021fULL, 0x000000007878783bULL, 0x000e620000004200ULL,
0x0000000899217824ULL, 0x000fe200078e0218ULL, 0x0001e6901c1e7811ULL, 0x004fc400078e18ffULL,
0x000000007474783bULL, 0x000ea80000004200ULL, 0x000000007070783bULL, 0x000f280000004200ULL,
0x000000006c6c783bULL, 0x000ee20000004200ULL, 0x000000787c60723cULL, 0x042b700000001860ULL,
0x0000007a7c24723cULL, 0x040b700000001824ULL, 0x000000747c28723cULL, 0x044b700000001828ULL,
0x000000767c2c723cULL, 0x040b70000000182cULL, 0x000000707c30723cULL, 0x050b700000001830ULL,
0x000000727c34723cULL, 0x040b700000001834ULL, 0x0000006c7c38723cULL, 0x048b700000001838ULL,
0x0000006e7c3c723cULL, 0x000b70000000183cULL, 0x000000786840723cULL, 0x040b700000001840ULL,
0x0000007a6844723cULL, 0x040b700000001844ULL, 0x000000746848723cULL, 0x040b700000001848ULL,
0x00000076684c723cULL, 0x040b70000000184cULL, 0x000000706850723cULL, 0x040b700000001850ULL,
0x000000726854723cULL, 0x040b700000001854ULL, 0x0000006c6858723cULL, 0x040b700000001858ULL,
0x0000006e685c723cULL, 0x000b62000000185cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000000199677810ULL, 0x000fe20007ffe0ffULL, 0x000000001eff7f8cULL, 0x0003e2000c80043fULL,
0x000000c021217811ULL, 0x000fc400078e28ffULL, 0x000000226700720cULL, 0x000fe40003f06070ULL,
0x00000060211f7812ULL, 0x000fca00078ec0ffULL, 0x0000000116737824ULL, 0x020fe200078e021fULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000065000008947ULL, 0x000fea0003800000ULL,
0x00000003ff707819ULL, 0x102fe40000011600ULL, 0x00000021981e7217ULL, 0x000fe40007800000ULL,
0x0000000470207810ULL, 0x040fe40007ffe0ffULL, 0x0000000c706e7810ULL, 0x000fe20007ffe0ffULL,
0x000000011e1f7824ULL, 0x000fe200078e0a21ULL, 0x0000000870687810ULL, 0x000fe20007ffe0ffULL,
0x0000000120217824ULL, 0x100fe200078e0200ULL, 0x0000001070747810ULL, 0x000fe20007ffe0ffULL,
0x00000008206a7824ULL, 0x000fe200078e00ffULL, 0x000000201f717817ULL, 0x000fe20003800000ULL,
0x000000809d1e7824ULL, 0x000fe200078e00ffULL, 0x0000000368797819ULL, 0x000fe200000006ffULL,
0x000000016e677824ULL, 0x000fe200078e0200ULL, 0xfffffff86a777812ULL, 0x000fe200078ee221ULL,
0x000000086e6c7824ULL, 0x000fe200078e00ffULL, 0x00000080131e7812ULL, 0x000fe200078ef81eULL,
0x0000000168667824ULL, 0x000fe200078e0200ULL, 0x0000001470767810ULL, 0x040fe20007ffe0ffULL,
0x0000000170217824ULL, 0x000fe200078e0273ULL, 0xfffffff86c7b7812ULL, 0x000fe200078ee267ULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x000000712000720cULL, 0x040fe20003f86070ULL,
0x0000000120677824ULL, 0x000fe200078e0273ULL, 0xfffffff879797812ULL, 0x000fe200078ee266ULL,
0x0000010021207825ULL, 0x000fe200078e001eULL, 0x00000000766b7210ULL, 0x000fc40007ffe0ffULL,
0x0000200019197812ULL, 0x000fe200078ec0ffULL, 0x0000000174697824ULL, 0x000fe200078e0200ULL,
0x00000020646a7210ULL, 0x000fe20007f1e0ffULL, 0x00000008746c7824ULL, 0x000fe200078e00ffULL,
0x000000716e00720cULL, 0x080fe20003f46070ULL, 0x0000010067667825ULL, 0x000fe200078e001eULL,
0x000000716800720cULL, 0x080fe40003f66070ULL, 0xfffffff86c7d7812ULL, 0x000fe200078ee269ULL,
0x0000000876727824ULL, 0x000fe200078e00ffULL, 0x00000066646c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000174697824ULL, 0x000fe200078e0273ULL, 0x000000717000720cULL, 0x000fc40003fa6070ULL,
0xfffffff8727f7812ULL, 0x000fe200078ee26bULL, 0x00000001656b7824ULL, 0x040fe400000e0621ULL,
0x0000000168217824ULL, 0x000fe400078e0273ULL, 0x00000001656d7824ULL, 0x000fe200008e0667ULL,
0x000000717400720cULL, 0x000fe20003f26070ULL, 0x000000016e677824ULL, 0x000fe200078e0273ULL,
0x0000001870747810ULL, 0x000fe20007ffe0ffULL, 0x0000010021207825ULL, 0x000fc800078e001eULL,
0x0000400018727824ULL, 0x000fe200078e0219ULL, 0x00000020646e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000170197824ULL, 0x000fe400078e0200ULL, 0x0000010067667825ULL, 0x100fe200078e001eULL,
0x00000021656f7210ULL, 0x000fe400007fe4ffULL, 0x0000000719197812ULL, 0x000fe200078ec0ffULL,
0x0000010069687825ULL, 0x000fe200078e001eULL, 0x0000006664667210ULL, 0x000fe40007fde0ffULL,
0x0001700072727810ULL, 0x000fe20007ffe0ffULL, 0x0000000176217824ULL, 0x000fe200078e0273ULL,
0x0ffffff819197812ULL, 0x000fe200078ef800ULL, 0x0000000165677824ULL, 0x000fe200030e0667ULL,
0x0000006864687210ULL, 0x000fe20007fde0ffULL, 0x0000010021207825ULL, 0x000fe200078e001eULL,
0x000000717600720cULL, 0x000fc40003f06070ULL, 0x0000001c70767810ULL, 0x000fe20007ffe0ffULL,
0x0000001019757824ULL, 0x100fe400078e0272ULL, 0x0000001077777824ULL, 0x000fe400078e0272ULL,
0x0000000165697824ULL, 0x040fe200030e0669ULL, 0x0000002064707210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a757faeULL, 0x0003e2000e901c46ULL,
0x0000000174197824ULL, 0x140fe200078e0273ULL, 0x000000717400720cULL, 0x080fe20003fa6070ULL,
0x0000000176737824ULL, 0x040fe200078e0273ULL, 0x000000006c777faeULL, 0x0005e2000e101c46ULL,
0x000000717600720cULL, 0x000fe20003f86070ULL, 0x0000000165717824ULL, 0x000fc400030e0621ULL,
0x0000010019207825ULL, 0x000fe200078e001eULL, 0x0000000074197210ULL, 0x000fc60007ffe0ffULL,
0x0000000874747824ULL, 0x000fe200078e00ffULL, 0x0000002064207210ULL, 0x000fe20007fde0ffULL,
0x00000001766a7824ULL, 0x042fe400078e0200ULL, 0x00000008766b7824ULL, 0x000fe200078e00ffULL,
0xfffffff874197812ULL, 0x000fe200078ee219ULL, 0x00000100731e7825ULL, 0x000fc600078e001eULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee26aULL, 0x0000000165217824ULL, 0x000fe200030e0621ULL,
0x0000001e641e7210ULL, 0x000fe20007fde0ffULL, 0x0000001079797824ULL, 0x100fe200078e0272ULL,
0x0000007219197211ULL, 0x000fe200078e20ffULL, 0x000000107b7b7824ULL, 0x100fe400078e0272ULL,
0x000000107d7d7824ULL, 0x100fe200078e0272ULL, 0x000000006e797faeULL, 0x0005e2000d901c46ULL,
0x000000107f7f7824ULL, 0x100fe400078e0272ULL, 0x000000106b6b7824ULL, 0x000fe200078e0272ULL,
0x00000000667b7faeULL, 0x0005e2000d101c46ULL, 0x00000001651f7824ULL, 0x000fc600030e061fULL,
0x00000000687d7faeULL, 0x0005e8000c901c46ULL, 0x00000000707f7faeULL, 0x0005e8000c101c46ULL,
0x0000000020197faeULL, 0x0005e8000e901c46ULL, 0x000000001e6b7faeULL, 0x0005e2000e101c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000400217811ULL, 0x042fe200078fe8ffULL,
0x000000809d707824ULL, 0x000fe200078e00ffULL, 0x0000000800677811ULL, 0x000fc400078fe8ffULL,
0x00000010006b7811ULL, 0x040fe200078fe8ffULL, 0x00000001211e7824ULL, 0x140fe200078e0200ULL,
0x00000014006d7811ULL, 0x040fe200078fe8ffULL, 0x0000000821697824ULL, 0x000fe200078e00ffULL,
0x00000018006f7811ULL, 0x040fe200078fe8ffULL, 0x00000001671f7824ULL, 0x000fe200078e0200ULL,
0x0000008013707812ULL, 0x000fe200078ef870ULL, 0x0000000867767824ULL, 0x000fe200078e00ffULL,
0xfffffff869747812ULL, 0x000fe200078ee21eULL, 0x000000086b7a7824ULL, 0x000fe200078e00ffULL,
0x0000000c00697811ULL, 0x000fe200078fe8ffULL, 0x000000016d207824ULL, 0x140fe200078e0200ULL,
0xfffffff876767812ULL, 0x000fe200078ee21fULL, 0x000000086d757824ULL, 0x000fe200078e00ffULL,
0x000000006b1f7210ULL, 0x080fe20007ffe0ffULL, 0x00000001691e7824ULL, 0x100fe200078e0200ULL,
0x0000007367677210ULL, 0x080fe20007ffe0ffULL, 0x0000000869717824ULL, 0x000fe200078e00ffULL,
0xfffffff87a7a7812ULL, 0x000fe200078ee21fULL, 0x000000016f667824ULL, 0x000fe200078e0200ULL,
0x00002000191f7812ULL, 0x000fe200078ec0ffULL, 0x000000086f777824ULL, 0x000fe200078e00ffULL,
0x0000000000197211ULL, 0x000fe200078fe8ffULL, 0x0000000121217824ULL, 0x000fe200078e0273ULL,
0xfffffff871787812ULL, 0x000fe200078ee21eULL, 0x00004000181e7824ULL, 0x000fe200078e021fULL,
0xfffffff8757c7812ULL, 0x000fe200078ee220ULL, 0x0000000169697824ULL, 0x100fe200078e0273ULL,
0x0000001c00207811ULL, 0x000fe200078fe8ffULL, 0x000000016b6b7824ULL, 0x100fe200078e0273ULL,
0x0000000719717812ULL, 0x000fe200078ec0ffULL, 0x000000016d6d7824ULL, 0x000fe200078e0273ULL,
0xfffffff8777e7812ULL, 0x000fe200078ee266ULL, 0x0000000120667824ULL, 0x100fe200078e0200ULL,
0x00000073001f7211ULL, 0x000fe200078fe8ffULL, 0x0000000820757824ULL, 0x000fe200078e00ffULL,
0x0ffffff871727812ULL, 0x000fe200078ef800ULL, 0x000000ffff717224ULL, 0x000fc400078e00ffULL,
0x000000016f6f7824ULL, 0x100fe200078e0273ULL, 0xfffffff875867812ULL, 0x000fe200078ee266ULL,
0x0000000120197824ULL, 0x000fe200078e0273ULL, 0x000170001e737810ULL, 0x000fe20007ffe0ffULL,
0x000001001f1e7825ULL, 0x000fc800078e0070ULL, 0x0000010021207825ULL, 0x000fe200078e0070ULL,
0x0000001e641e7210ULL, 0x000fc60007f1e0ffULL, 0x0000010067667825ULL, 0x000fe200078e0070ULL,
0x0000002064207210ULL, 0x000fc60007f3e0ffULL, 0x0000010069687825ULL, 0x100fe200078e0070ULL,
0x0000006664667210ULL, 0x040fe40007f5e0ffULL, 0x0000002165217210ULL, 0x000fe20000ffe4ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0070ULL, 0x0000006864687210ULL, 0x000fc60007f7e0ffULL,
0x000001006d6c7825ULL, 0x000fc800078e0070ULL, 0x000001006f6e7825ULL, 0x000fe200078e0070ULL,
0x0000006c646c7210ULL, 0x000fc60007f3e0ffULL, 0x0000010019707825ULL, 0x000fe200078e0070ULL,
0x0000007372197211ULL, 0x000fc600078e20ffULL, 0x00000001651f7824ULL, 0x040fe200000e061fULL,
0x0000006a646a7210ULL, 0x040fe20007f1e0ffULL, 0x0000000165677824ULL, 0x040fe200010e0667ULL,
0x0000006e646e7210ULL, 0x000fe20007f5e0ffULL, 0x0000001074757824ULL, 0x000fe200078e0273ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e197faeULL, 0x0003e2000b901c46ULL,
0x0000000165697824ULL, 0x000fe200018e0669ULL, 0x0000007064647210ULL, 0x000fe20007f7e0ffULL,
0x0000001076777824ULL, 0x100fe200078e0273ULL, 0x0000000020757faeULL, 0x0003e2000b901c46ULL,
0x0000001078797824ULL, 0x000fc400078e0273ULL, 0x000000107a7b7824ULL, 0x000fe200078e0273ULL,
0x0000000066777faeULL, 0x0003e2000b901c46ULL, 0x00000001656b7824ULL, 0x040fe400000e066bULL,
0x000000107c7d7824ULL, 0x000fe200078e0273ULL, 0x0000000068797faeULL, 0x0003e2000b901c46ULL,
0x00000001656d7824ULL, 0x040fe400008e066dULL, 0x000000107e7f7824ULL, 0x000fe200078e0273ULL,
0x000000006a7b7faeULL, 0x0003e2000b901c46ULL, 0x00000001656f7824ULL, 0x000fc400010e066fULL,
0x0000001086737824ULL, 0x000fe200078e0273ULL, 0x000000006c7d7faeULL, 0x0003e2000b901c46ULL,
0x0000000165657824ULL, 0x000fc600018e0671ULL, 0x000000006e7f7faeULL, 0x0003e8000b901c46ULL,
0x0000000064737faeULL, 0x0003e4000b901c46ULL, 0x00000300ff197624ULL, 0x006fe200078e00ffULL,
0x000000011a1e7812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000011e00780cULL, 0x000fe40003f05070ULL, 0xffffffff19197811ULL, 0x000fc800078e08ffULL,
0x0000000119197807ULL, 0x000fca0004000000ULL, 0x000000011a1a7824ULL, 0x000fe400078e0219ULL,
0xffffffffff197424ULL, 0x000fc600078e00ffULL, 0x000000231a00720cULL, 0x000fda0003f06070ULL,
0x000000141a1e8210ULL, 0x000fe20007ffe0ffULL, 0x00000004ff1f8424ULL, 0x000fc800078e00ffULL,
0x000066001e1e8625ULL, 0x000fca00078e001fULL, 0x000000061e198981ULL, 0x000322000c1e1900ULL,
0x0000001080217812ULL, 0x000fca00078ec0ffULL, 0x000000201c1c7824ULL, 0x000fe200078e0221ULL,
0x0000000880217812ULL, 0x000fca00078ec0ffULL, 0x00000001211c7824ULL, 0x000fe200078e021cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e648001c647f8cULL, 0x0022a4000c80043fULL,
0x00000000001e7805ULL, 0x000fc40000015200ULL, 0x01e64c001c217984ULL, 0x000ee40000000800ULL,
0x8000000021ff7812ULL, 0x00cfe40007804865ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff667224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x000000201e677210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e1fULL,
0x003d09006700780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406700780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff207819ULL, 0x000fc80000011421ULL, 0x0000006720207211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0621ULL, 0x0000000220207819ULL, 0x000fc80000001221ULL,
0x000000200000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000166667810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e64c001c217984ULL, 0x000ea40000000800ULL, 0x8000000021ff7812ULL, 0x004fe40007804865ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000209d1c7824ULL, 0x002fca00078e00ffULL,
0xffffff801c1c7812ULL, 0x000fc800078ec0ffULL, 0x00000100131f7810ULL, 0x000fc80007ffe01cULL,
0x0000001f821f7210ULL, 0x000fca0007ffe0ffULL, 0x01e000001f1c7984ULL, 0x000e680000000800ULL,
0x01e200001f647984ULL, 0x0004e20000000800ULL, 0x0000001b1c00720bULL, 0x002fe20003f1d000ULL,
0x000135927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000657806ULL, 0x004fc800000e0100ULL,
0x000000ff6500720cULL, 0x000fe20003f25270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x000000029d1e7811ULL, 0x000fe400078ff0ffULL, 0x0000001b1c00720bULL, 0x000fe40003f34000ULL,
0x0000009d1e00720cULL, 0x000fe20003f05270ULL, 0x000135627f007947ULL, 0x000fd4000b800000ULL,
0x0000000000667806ULL, 0x000fc400008e0100ULL, 0x000000809d1f8824ULL, 0x000fe200078e0213ULL,
0x0000001b1c1e8209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x00000001821f8824ULL, 0x000fca00078e021fULL, 0x01e4001e1f008388ULL, 0x0003e20000000800ULL,
0x000000ff6600720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000001b1c1e7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff66ff7812ULL, 0x000fc6000780c0ffULL, 0x0000001b1e1e7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL, 0x0000001e00687308ULL, 0x000e640000000800ULL,
0x000000681d1d7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x000fe20000011600ULL, 0x000134a27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x0002a400000e0000ULL, 0x0000001e60607220ULL, 0x084fe40000410000ULL,
0x0000001e61617220ULL, 0x080fe40000410000ULL, 0x0000001e24247220ULL, 0x080fe40000410000ULL,
0x0000001e25257220ULL, 0x000fc40000410000ULL, 0x0000001e28287220ULL, 0x080fe40000410000ULL,
0x0000001e29297220ULL, 0x080fe40000410000ULL, 0x0000001e2c2c7220ULL, 0x080fe40000410000ULL,
0x0000001e2d2d7220ULL, 0x080fe40000410000ULL, 0x0000001e30307220ULL, 0x080fe40000410000ULL,
0x0000001e31317220ULL, 0x000fc40000410000ULL, 0x0000001e34347220ULL, 0x080fe40000410000ULL,
0x0000001e35357220ULL, 0x080fe40000410000ULL, 0x0000001e38387220ULL, 0x080fe40000410000ULL,
0x0000001e39397220ULL, 0x080fe40000410000ULL, 0x0000001e3c3c7220ULL, 0x080fe40000410000ULL,
0x0000001e3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0066ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x000fe200078ff0ffULL,
0x000133927f007947ULL, 0x000fea000b800000ULL, 0x00001f1e681e7589ULL, 0x00046400000e0000ULL,
0x0000001e62627220ULL, 0x086fe40000410000ULL, 0x0000001e63637220ULL, 0x080fe40000410000ULL,
0x0000001e26267220ULL, 0x080fe40000410000ULL, 0x0000001e27277220ULL, 0x080fe40000410000ULL,
0x0000001e2a2a7220ULL, 0x080fe40000410000ULL, 0x0000001e2b2b7220ULL, 0x000fc40000410000ULL,
0x0000001e2e2e7220ULL, 0x080fe40000410000ULL, 0x0000001e2f2f7220ULL, 0x080fe40000410000ULL,
0x0000001e32327220ULL, 0x080fe40000410000ULL, 0x0000001e33337220ULL, 0x080fe40000410000ULL,
0x0000001e36367220ULL, 0x080fe40000410000ULL, 0x0000001e37377220ULL, 0x000fc40000410000ULL,
0x0000001e3a3a7220ULL, 0x080fe40000410000ULL, 0x0000001e3b3b7220ULL, 0x080fe40000410000ULL,
0x0000001e3e3e7220ULL, 0x080fe40000410000ULL, 0x0000001e3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000066ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000010001e7811ULL, 0x000fe200078ff0ffULL, 0x000132827f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x00046400000e0000ULL, 0x0000001e40407220ULL, 0x086fe40000410000ULL,
0x0000001e41417220ULL, 0x080fe40000410000ULL, 0x0000001e44447220ULL, 0x080fe40000410000ULL,
0x0000001e45457220ULL, 0x080fe40000410000ULL, 0x0000001e48487220ULL, 0x080fe40000410000ULL,
0x0000001e49497220ULL, 0x000fc40000410000ULL, 0x0000001e4c4c7220ULL, 0x080fe40000410000ULL,
0x0000001e4d4d7220ULL, 0x080fe40000410000ULL, 0x0000001e50507220ULL, 0x080fe40000410000ULL,
0x0000001e51517220ULL, 0x080fe40000410000ULL, 0x0000001e54547220ULL, 0x080fe40000410000ULL,
0x0000001e55557220ULL, 0x000fc40000410000ULL, 0x0000001e58587220ULL, 0x080fe40000410000ULL,
0x0000001e59597220ULL, 0x080fe40000410000ULL, 0x0000001e5c5c7220ULL, 0x080fe40000410000ULL,
0x0000001e5d5d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000066ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000018001e7811ULL, 0x000fe200078ff0ffULL, 0x000131827f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x00046400000e0000ULL, 0x0000001e42427220ULL, 0x086fe40000410000ULL,
0x0000001e43437220ULL, 0x080fe40000410000ULL, 0x0000001e46467220ULL, 0x080fe40000410000ULL,
0x0000001e47477220ULL, 0x080fe40000410000ULL, 0x0000001e4a4a7220ULL, 0x080fe40000410000ULL,
0x0000001e4b4b7220ULL, 0x000fc40000410000ULL, 0x0000001e4e4e7220ULL, 0x080fe40000410000ULL,
0x0000001e4f4f7220ULL, 0x080fe40000410000ULL, 0x0000001e52527220ULL, 0x080fe40000410000ULL,
0x0000001e53537220ULL, 0x080fe40000410000ULL, 0x0000001e56567220ULL, 0x080fe40000410000ULL,
0x0000001e57577220ULL, 0x000fc40000410000ULL, 0x0000001e5a5a7220ULL, 0x080fe40000410000ULL,
0x0000001e5b5b7220ULL, 0x080fe40000410000ULL, 0x0000001e5e5e7220ULL, 0x080fe40000410000ULL,
0x0000001e5f5f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006665ff7212ULL, 0x000fe400078030ffULL, 0x0000001b1c1b7209ULL, 0x000fd60007810000ULL,
0x8000001b1c1c0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1c1c0820ULL, 0x000fc80000410000ULL,
0x0000001c00120308ULL, 0x000e640000000800ULL, 0x0000001264640220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000001d641d7221ULL, 0x008fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000012ff0e723eULL, 0x000fe400000000ffULL, 0x00000002ff657819ULL, 0x000fe40000011600ULL,
0x000054100e0e7816ULL, 0x000fe2000000000eULL, 0x00012fe27f007947ULL, 0x000fea000b800000ULL,
0x00001f650e117589ULL, 0x0002a400000e0000ULL, 0x00000008651e7810ULL, 0x000fe20007ffe0ffULL,
0x000130327f007947ULL, 0x000fea000b800000ULL, 0x00000010650f7810ULL, 0x000fe20007ffe0ffULL,
0x00001f1e0e107589ULL, 0x00066a00000e0000ULL, 0x00001f0f0e0f7589ULL, 0x0006a400000e0000ULL,
0x00000018651e7810ULL, 0x008fe20007ffe0ffULL, 0x000130c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e0e0e7589ULL, 0x0022e400000e0000ULL, 0x0000000a9d1c7819ULL, 0x000fe200000006ffULL,
0x00000002181f7824ULL, 0x000fe200078e0215ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0xfffff0001c1e7812ULL, 0x002fe200078ec0ffULL,
0x000020001f1c7824ULL, 0x000fc600078e00ffULL, 0x000140001e1e7810ULL, 0x000fe40007ffe0ffULL,
0x000160001c1f7810ULL, 0x000fc60007ffe0ffULL, 0x000000100d687824ULL, 0x100fe400078e021eULL,
0x000000100c1e7824ULL, 0x000fe400078e021eULL, 0x000000100a6c7824ULL, 0x100fe400078e021fULL,
0x000000006868783bULL, 0x000e620000000200ULL, 0x000000100b707824ULL, 0x100fe400078e021fULL,
0x0000001009747824ULL, 0x000fe200078e021fULL, 0x000000001e64783bULL, 0x0006a20000000200ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000001168687232ULL, 0x086fe40000000000ULL,
0x000000116a6a7232ULL, 0x000fc40000000000ULL, 0x0000001069697232ULL, 0x080fe40000000000ULL,
0x000000106b6b7232ULL, 0x000fe40000000000ULL, 0x0000000f64647232ULL, 0x080fe40000000000ULL,
0x0000000f66667232ULL, 0x000fe40000000000ULL, 0x0000000e65657232ULL, 0x088fe40000000000ULL,
0x0000000e67677232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001008787824ULL, 0x000fe200078e021fULL, 0x000000006c6c783bULL, 0x000ee40000004200ULL,
0x00000002ff1e7819ULL, 0x008fe2000001169dULL, 0x0000025000007945ULL, 0x000fe20003800000ULL,
0x000000007070783bULL, 0x000fe40000004200ULL, 0x000140001e207811ULL, 0x000fc400078e60ffULL,
0x000000007878783bULL, 0x000ee80000004200ULL, 0x000000007474783bULL, 0x000ea40000004200ULL,
0x0000006c6440723cULL, 0x004f700000001840ULL, 0x000000786838723cULL, 0x04af700000001838ULL,
0x0000007a683c723cULL, 0x000f70000000183cULL, 0x000000786458723cULL, 0x040f700000001858ULL,
0x0000006e6444723cULL, 0x040f700000001844ULL, 0x000000706448723cULL, 0x040f700000001848ULL,
0x00000072644c723cULL, 0x040f70000000184cULL, 0x000000746450723cULL, 0x040f700000001850ULL,
0x000000766454723cULL, 0x040f700000001854ULL, 0x0000007a6478723cULL, 0x000b6e000000185cULL,
0x0000002007647211ULL, 0x020fe200078e20ffULL, 0x0000001006207824ULL, 0x000fe200078e0220ULL,
0x0000006c6860723cULL, 0x040b680000001860ULL, 0x000000006464783bULL, 0x000e660000000200ULL,
0x00000010046c7824ULL, 0x120fe200078e021fULL, 0x0000006e6824723cULL, 0x040f620000001824ULL,
0x00000000205c783bULL, 0x0004ee0000000200ULL, 0x000000706828723cULL, 0x040b6e0000001828ULL,
0x0000001003707824ULL, 0x120fe200078e021fULL, 0x00000072682c723cULL, 0x040f70000000182cULL,
0x000000746830723cULL, 0x040f700000001830ULL, 0x000000766834723cULL, 0x000b6e0000001834ULL,
0x0000001005687824ULL, 0x020fe200078e021fULL, 0x0000008000008947ULL, 0x000fd60003800000ULL,
0x0000001164647232ULL, 0x086fe40000000000ULL, 0x0000001166667232ULL, 0x000fc40000000000ULL,
0x0000001065657232ULL, 0x080fe40000000000ULL, 0x0000001067677232ULL, 0x000fe40000000000ULL,
0x0000000f5c5c7232ULL, 0x088fe40000000000ULL, 0x0000000f5e5e7232ULL, 0x000fe40000000000ULL,
0x0000000e5d5d7232ULL, 0x080fe40000000000ULL, 0x0000000e5f5f7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x006fea0003800000ULL, 0x0000001002747824ULL, 0x000fe200078e021fULL,
0x000000006868783bULL, 0x000e620000004200ULL, 0x0001e6981e1f7811ULL, 0x000fc600078e18ffULL,
0x000000006c6c783bULL, 0x000ea80000004200ULL, 0x000000007070783bULL, 0x000ee80000004200ULL,
0x000000007474783bULL, 0x000ea20000004200ULL, 0x000000685c40723cULL, 0x04ab700000001840ULL,
0x0000006a5c44723cULL, 0x040b700000001844ULL, 0x0000006c5c48723cULL, 0x044b700000001848ULL,
0x0000006e5c4c723cULL, 0x040b70000000184cULL, 0x000000705c50723cULL, 0x040b700000001850ULL,
0x000000725c54723cULL, 0x040b700000001854ULL, 0x000000745c58723cULL, 0x000b700000001858ULL,
0x000000686460723cULL, 0x040b700000001860ULL, 0x0000006a6424723cULL, 0x040b700000001824ULL,
0x0000006c6428723cULL, 0x040b700000001828ULL, 0x0000006e642c723cULL, 0x040b70000000182cULL,
0x000000706430723cULL, 0x040b700000001830ULL, 0x000000726434723cULL, 0x040b700000001834ULL,
0x000000746438723cULL, 0x040b700000001838ULL, 0x00000076643c723cULL, 0x080b70000000183cULL,
0x000000765c5c723cULL, 0x000b620000001878ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000030099997a10ULL, 0x000fe20007ffe0ffULL, 0x000000001fff7f8cULL, 0x0003e6000c80043fULL,
0x000000229900720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00000c9000000947ULL, 0x000fea0003800000ULL, 0x0000000199217810ULL, 0x002fe20007ffe0ffULL,
0x00005900191f7a24ULL, 0x010fe400078e02ffULL, 0x0000010099647824ULL, 0x020fe200078e0217ULL,
0x000000222100720cULL, 0x000fe20003f06070ULL, 0x000000801f207824ULL, 0x000fe400078e00ffULL,
0x00000100ff217424ULL, 0x000fe200078e00ffULL, 0x00000060641f7812ULL, 0x000fc600078ec0ffULL,
0x0000640020207625ULL, 0x000fe200078e0021ULL, 0x0000001f16777210ULL, 0x000fca0007ffe0ffULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff727819ULL, 0x000fe40000011600ULL,
0x00000064981f7217ULL, 0x000fe40007800000ULL, 0x0000000472667810ULL, 0x040fe40007ffe0ffULL,
0x0000000c72707810ULL, 0x040fe20007ffe0ffULL, 0x000000011f1f7824ULL, 0x000fe200078e0a64ULL,
0x00000008726a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000166647824ULL, 0x100fe200078e0200ULL,
0x0000001472767810ULL, 0x000fe20007ffe0ffULL, 0x0000000866757824ULL, 0x000fe200078e00ffULL,
0x000000201f1f7817ULL, 0x000fe20003800000ULL, 0x0000000170677824ULL, 0x000fe200078e0200ULL,
0x0000001072747810ULL, 0x000fe20007ffe0ffULL, 0x00000008706c7824ULL, 0x000fe200078e00ffULL,
0xfffffff875757812ULL, 0x000fe200078ee264ULL, 0x000000016a657824ULL, 0x000fe200078e0200ULL,
0x0000001f6600720cULL, 0x000fe20003f86070ULL, 0x000000086a687824ULL, 0x000fe200078e00ffULL,
0xfffffff86c7f7812ULL, 0x000fe200078ee267ULL, 0x000000809d647824ULL, 0x000fe200078e00ffULL,
0x0000007772677210ULL, 0x000fe20007ffe0ffULL, 0x0000000166697824ULL, 0x000fe200078e0277ULL,
0xfffffff8687d7812ULL, 0x000fe200078ee265ULL, 0x000000ffff657224ULL, 0x000fe200078e00ffULL,
0x0000008013647812ULL, 0x000fe200078ef864ULL, 0x00000001766d7824ULL, 0x000fe200078e0200ULL,
0x0000001f7000720cULL, 0x080fe20003f46070ULL, 0x00000008767a7824ULL, 0x000fe200078e00ffULL,
0x0000001f6a00720cULL, 0x080fe20003f66070ULL, 0x0000010067667825ULL, 0x000fe200078e0064ULL,
0x0000001f7200720cULL, 0x000fc40003fa6070ULL, 0xfffffff87a877812ULL, 0x000fe200078ee26dULL,
0x0000010069687825ULL, 0x000fe200078e0064ULL, 0x00000066206c7210ULL, 0x000fe40007f1e0ffULL,
0x0000000d9d667819ULL, 0x000fe200000006ffULL, 0x00000001746b7824ULL, 0x100fe200078e0200ULL,
0x00000068206e7210ULL, 0x000fe20007f3e0ffULL, 0x00000001216d7824ULL, 0x000fe200000e0667ULL,
0x0000200066717812ULL, 0x000fe200078ec0ffULL, 0x000000016a677824ULL, 0x000fe400078e0277ULL,
0x0000000172687824ULL, 0x000fc400078e0200ULL, 0x00000001216f7824ULL, 0x000fe200008e0669ULL,
0x0000001f7400720cULL, 0x040fe20003f26070ULL, 0x0000000874787824ULL, 0x000fe200078e00ffULL,
0x0000000768737812ULL, 0x000fe200078ec0ffULL, 0x0000000170697824ULL, 0x000fe400078e0277ULL,
0x0000010067667825ULL, 0x000fe200078e0064ULL, 0xfffffff878857812ULL, 0x000fe400078ee26bULL,
0x0ffffff873737812ULL, 0x000fe200078ef800ULL, 0x0000010069687825ULL, 0x000fe200078e0064ULL,
0x0000006620707210ULL, 0x000fc40007f1e0ffULL, 0x0000001c72787810ULL, 0x000fe20007ffe0ffULL,
0x00000001746b7824ULL, 0x000fe200078e0277ULL, 0x0000006820687210ULL, 0x000fe20007fde0ffULL,
0x0000400018747824ULL, 0x000fe400078e0271ULL, 0x000001006b6a7825ULL, 0x000fc600078e0064ULL,
0x0001600074747810ULL, 0x000fe20007ffe0ffULL, 0x0000000121717824ULL, 0x040fe200000e0667ULL,
0x0000007776677210ULL, 0x000fe20007ffe0ffULL, 0x0000000121697824ULL, 0x000fe200030e0669ULL,
0x0000006a206a7210ULL, 0x000fe20007fde0ffULL, 0x0000001073797824ULL, 0x000fe200078e0274ULL,
0x0000001f7600720cULL, 0x080fe20003f06070ULL, 0x0000010067667825ULL, 0x000fe200078e0064ULL,
0x0000001872767810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c797faeULL, 0x0003e2000e901c46ULL, 0x00000001216b7824ULL, 0x000fe200030e066bULL,
0x0000006620727210ULL, 0x000fe20007fde0ffULL, 0x00000010757b7824ULL, 0x000fe200078e0274ULL,
0x0000001f7600720cULL, 0x040fe20003fa6070ULL, 0x0000000176757824ULL, 0x000fc400078e0277ULL,
0x0000000121737824ULL, 0x000fe200030e0667ULL, 0x000000006e7b7faeULL, 0x0005e2000e101c46ULL,
0x0000010075667825ULL, 0x000fe200078e0064ULL, 0x0000001f7800720cULL, 0x000fc60003f86070ULL,
0x00000001781f7824ULL, 0x000fe200078e0277ULL, 0x0000006620667210ULL, 0x000fe20007fde0ffULL,
0x00000001766c7824ULL, 0x142fe400078e0200ULL, 0x0000000876757824ULL, 0x000fe400078e00ffULL,
0x00000001786d7824ULL, 0x040fe200078e0200ULL, 0x0000000378787819ULL, 0x000fe200000006ffULL,
0x000001001f647825ULL, 0x000fe200078e0064ULL, 0xfffffff8751f7812ULL, 0x000fe400078ee26cULL,
0xfffffff8786d7812ULL, 0x000fe200078ee26dULL, 0x0000000121677824ULL, 0x000fe200030e0667ULL,
0x0000006420207210ULL, 0x000fe20007fde0ffULL, 0x000000107d7d7824ULL, 0x000fc400078e0274ULL,
0x000000107f7f7824ULL, 0x100fe400078e0274ULL, 0x0000001085857824ULL, 0x100fe200078e0274ULL,
0x00000000707d7faeULL, 0x0005e2000d901c46ULL, 0x0000001087877824ULL, 0x100fe400078e0274ULL,
0x000000101f1f7824ULL, 0x100fe200078e0274ULL, 0x00000000687f7faeULL, 0x0005e2000d101c46ULL,
0x000000106d6d7824ULL, 0x000fe400078e0274ULL, 0x0000000121217824ULL, 0x000fe200030e0665ULL,
0x000000006a857faeULL, 0x0005e8000c901c46ULL, 0x0000000072877faeULL, 0x0005e8000c101c46ULL,
0x00000000661f7faeULL, 0x0005e8000e901c46ULL, 0x00000000206d7faeULL, 0x0005e2000e101c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000800697811ULL, 0x040fe200078fe8ffULL,
0x000000809d727824ULL, 0x000fe200078e00ffULL, 0x0000000400677811ULL, 0x000fc400078fe8ffULL,
0x00000010006d7811ULL, 0x040fe200078fe8ffULL, 0x0000000169647824ULL, 0x000fe200078e0200ULL,
0x00000000671f7210ULL, 0x080fe20007ffe0ffULL, 0x0000000869657824ULL, 0x000fe200078e00ffULL,
0x0000000c006b7811ULL, 0x040fe200078fe8ffULL, 0x0000000867767824ULL, 0x000fe200078e00ffULL,
0x00000014006f7811ULL, 0x000fe200078fe8ffULL, 0x000000086d737824ULL, 0x000fe200078e00ffULL,
0xfffffff865787812ULL, 0x000fe200078ee264ULL, 0x000000016d647824ULL, 0x100fe200078e0200ULL,
0xfffffff876767812ULL, 0x000fe200078ee21fULL, 0x000000016b1f7824ULL, 0x140fe200078e0200ULL,
0x0000001800717811ULL, 0x000fe200078fe8ffULL, 0x000000086b7a7824ULL, 0x000fe200078e00ffULL,
0x000000036f7e7819ULL, 0x040fe200000006ffULL, 0x000000016f657824ULL, 0x000fe200078e0200ULL,
0xfffffff8737c7812ULL, 0x000fe200078ee264ULL, 0x0000000171667824ULL, 0x040fe200078e0200ULL,
0xfffffff87a7a7812ULL, 0x000fe200078ee21fULL, 0x0000000871757824ULL, 0x000fe200078e00ffULL,
0x0000000000647211ULL, 0x000fe200078fe8ffULL, 0x000020009d1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff87e7e7812ULL, 0x000fe200078ee265ULL, 0x0000000167677824ULL, 0x100fe200078e0277ULL,
0x0000001c00657811ULL, 0x000fe200078fe8ffULL, 0x0000000169697824ULL, 0x100fe200078e0277ULL,
0x0000000764737812ULL, 0x000fe200078ec0ffULL, 0x000000016b6b7824ULL, 0x100fe200078e0277ULL,
0xfffffff875867812ULL, 0x000fe200078ee266ULL, 0x0000000165647824ULL, 0x000fe200078e0200ULL,
0x000020001f757812ULL, 0x000fe200078ec0ffULL, 0x0000000865797824ULL, 0x000fe200078e00ffULL,
0x0000008013727812ULL, 0x000fe200078ef872ULL, 0x00000001651f7824ULL, 0x100fe200078e0277ULL,
0x0000007700657211ULL, 0x080fe200078fe8ffULL, 0x000000016d6d7824ULL, 0x000fe200078e0277ULL,
0x0ffffff873747812ULL, 0x000fe200078ef800ULL, 0x000000ffff737224ULL, 0x000fe200078e00ffULL,
0xfffffff879887812ULL, 0x000fe200078ee264ULL, 0x0000400018757824ULL, 0x000fe200078e0275ULL,
0x000000776f6f7210ULL, 0x000fe20007ffe0ffULL, 0x0000010065647825ULL, 0x000fc600078e0072ULL,
0x0001600075757810ULL, 0x000fe20007ffe0ffULL, 0x0000010067667825ULL, 0x100fe200078e0072ULL,
0x0000006420647210ULL, 0x000fe40007f1e0ffULL, 0x0000007578797211ULL, 0x000fe200078e20ffULL,
0x0000010069687825ULL, 0x000fe200078e0072ULL, 0x0000006620667210ULL, 0x000fc60007f3e0ffULL,
0x0000000171717824ULL, 0x000fe200078e0277ULL, 0x0000006820687210ULL, 0x000fe20007f5e0ffULL,
0x000001006b6a7825ULL, 0x000fc800078e0072ULL, 0x000001006d6c7825ULL, 0x000fe200078e0072ULL,
0x0000006a206a7210ULL, 0x000fc60007f7e0ffULL, 0x000001006f6e7825ULL, 0x000fe200078e0072ULL,
0x0000006b216b7210ULL, 0x000fc60001ffe4ffULL, 0x0000010071707825ULL, 0x000fc800078e0072ULL,
0x000001001f727825ULL, 0x000fc800078e0072ULL, 0x0000000121657824ULL, 0x040fe200000e0665ULL,
0x0000006c206c7210ULL, 0x040fe20007f1e0ffULL, 0x0000000121677824ULL, 0x040fe200008e0667ULL,
0x0000006e206e7210ULL, 0x000fe20007f3e0ffULL, 0x00000010741f7824ULL, 0x000fe400078e0275ULL,
0x0000000121697824ULL, 0x000fe200010e0669ULL, 0x0000007020707210ULL, 0x000fe20007f5e0ffULL,
0x0000001076777824ULL, 0x100fe200078e0275ULL, 0x0000007220207210ULL, 0x000fe20007f7e0ffULL,
0x000000107a7b7824ULL, 0x100fe200078e0275ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000641f7faeULL, 0x0003e2000b901c46ULL, 0x000000107c7d7824ULL, 0x000fc400078e0275ULL,
0x00000001216d7824ULL, 0x040fe200000e066dULL, 0x0000000066777faeULL, 0x0003e2000b901c46ULL,
0x000000107e7f7824ULL, 0x000fe400078e0275ULL, 0x00000001216f7824ULL, 0x040fe200008e066fULL,
0x0000000068797faeULL, 0x0003e2000b901c46ULL, 0x0000001086857824ULL, 0x000fe400078e0275ULL,
0x0000000121717824ULL, 0x000fe200010e0671ULL, 0x000000006a7b7faeULL, 0x0003e2000b901c46ULL,
0x0000001088757824ULL, 0x000fc400078e0275ULL, 0x0000000121217824ULL, 0x000fe200018e0673ULL,
0x000000006c7d7faeULL, 0x0003e8000b901c46ULL, 0x000000006e7f7faeULL, 0x0003e8000b901c46ULL,
0x0000000070857faeULL, 0x0003e8000b901c46ULL, 0x0000000020757faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x002e220000000000ULL, 0x00000010801f7812ULL, 0x004fc400078ec0ffULL,
0x0000000880207812ULL, 0x000fc600078ec0ffULL, 0x000000201e1f7824ULL, 0x000fc800078e021fULL,
0x0000000120667824ULL, 0x020fe200078e021fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e6680066647f8cULL, 0x0002a4000c80043fULL, 0x00000000001e7805ULL, 0x000fc40000015200ULL,
0x01e66c0066217984ULL, 0x000ee40000000800ULL, 0x8000000021ff7812ULL, 0x00cfe40007804865ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff687224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000201e677210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e1fULL, 0x003d09006700780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406700780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff207819ULL, 0x000fc80000011421ULL,
0x0000006720207211ULL, 0x000fc800078110ffULL, 0x00000021ff217210ULL, 0x000fc800007fe4ffULL,
0x0000000220207819ULL, 0x000fc80000001221ULL, 0x000000200000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000168687810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e66c0066217984ULL, 0x000ea40000000800ULL,
0x8000000021ff7812ULL, 0x004fe40007804865ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000039d1e7811ULL, 0x000fca00078ff0ffULL, 0x000000801e1f7824ULL, 0x000fc800078e0213ULL,
0x00000001821f7824ULL, 0x000fca00078e021fULL, 0x01e000001f647984ULL, 0x000ea80000000800ULL,
0x01e200001f657984ULL, 0x0006620000000800ULL, 0x0000001b6400720bULL, 0x004fe20003f1d000ULL,
0x00011b227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000667806ULL, 0x00afc800000e0100ULL,
0x000000ff6600720cULL, 0x000fe20003f25270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x000000039d1e7811ULL, 0x000fe400078ff0ffULL, 0x0000001b6400720bULL, 0x000fe40003f34000ULL,
0x0000009d1e00720cULL, 0x000fe20003f05270ULL, 0x00011af27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000697806ULL, 0x000fc400008e0100ULL, 0x000000809d1f8824ULL, 0x000fe200078e0213ULL,
0x0000001b64138209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000182828824ULL, 0x000fca00078e021fULL, 0x01e4001382008388ULL, 0x0003e20000000800ULL,
0x000000ff6900720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000001b641e7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff69ff7812ULL, 0x000fc6000780c0ffULL, 0x0000001b1e137221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL, 0x0000001300687308ULL, 0x000e640000000800ULL,
0x000000681d1d7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x000fe20000011600ULL, 0x00011a327f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x0002a400000e0000ULL, 0x0000001e60607220ULL, 0x084fe40000410000ULL,
0x0000001e61617220ULL, 0x080fe40000410000ULL, 0x0000001e24247220ULL, 0x080fe40000410000ULL,
0x0000001e25257220ULL, 0x000fc40000410000ULL, 0x0000001e28287220ULL, 0x080fe40000410000ULL,
0x0000001e29297220ULL, 0x080fe40000410000ULL, 0x0000001e2c2c7220ULL, 0x080fe40000410000ULL,
0x0000001e2d2d7220ULL, 0x080fe40000410000ULL, 0x0000001e30307220ULL, 0x080fe40000410000ULL,
0x0000001e31317220ULL, 0x000fc40000410000ULL, 0x0000001e34347220ULL, 0x080fe40000410000ULL,
0x0000001e35357220ULL, 0x080fe40000410000ULL, 0x0000001e38387220ULL, 0x080fe40000410000ULL,
0x0000001e39397220ULL, 0x080fe40000410000ULL, 0x0000001e3c3c7220ULL, 0x080fe40000410000ULL,
0x0000001e3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0069ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x000fe200078ff0ffULL,
0x000119227f007947ULL, 0x000fea000b800000ULL, 0x00001f1e681e7589ULL, 0x0004e400000e0000ULL,
0x0000001e62627220ULL, 0x08cfe40000410000ULL, 0x0000001e63637220ULL, 0x080fe40000410000ULL,
0x0000001e26267220ULL, 0x080fe40000410000ULL, 0x0000001e27277220ULL, 0x080fe40000410000ULL,
0x0000001e2a2a7220ULL, 0x080fe40000410000ULL, 0x0000001e2b2b7220ULL, 0x000fc40000410000ULL,
0x0000001e2e2e7220ULL, 0x080fe40000410000ULL, 0x0000001e2f2f7220ULL, 0x080fe40000410000ULL,
0x0000001e32327220ULL, 0x080fe40000410000ULL, 0x0000001e33337220ULL, 0x080fe40000410000ULL,
0x0000001e36367220ULL, 0x080fe40000410000ULL, 0x0000001e37377220ULL, 0x000fc40000410000ULL,
0x0000001e3a3a7220ULL, 0x080fe40000410000ULL, 0x0000001e3b3b7220ULL, 0x080fe40000410000ULL,
0x0000001e3e3e7220ULL, 0x080fe40000410000ULL, 0x0000001e3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000069ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000010001e7811ULL, 0x000fe200078ff0ffULL, 0x000118127f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x0004e400000e0000ULL, 0x0000001e40407220ULL, 0x08cfe40000410000ULL,
0x0000001e41417220ULL, 0x080fe40000410000ULL, 0x0000001e44447220ULL, 0x080fe40000410000ULL,
0x0000001e45457220ULL, 0x080fe40000410000ULL, 0x0000001e48487220ULL, 0x080fe40000410000ULL,
0x0000001e49497220ULL, 0x000fc40000410000ULL, 0x0000001e4c4c7220ULL, 0x080fe40000410000ULL,
0x0000001e4d4d7220ULL, 0x080fe40000410000ULL, 0x0000001e50507220ULL, 0x080fe40000410000ULL,
0x0000001e51517220ULL, 0x080fe40000410000ULL, 0x0000001e54547220ULL, 0x080fe40000410000ULL,
0x0000001e55557220ULL, 0x000fc40000410000ULL, 0x0000001e58587220ULL, 0x080fe40000410000ULL,
0x0000001e59597220ULL, 0x080fe40000410000ULL, 0x0000001e5c5c7220ULL, 0x080fe40000410000ULL,
0x0000001e5d5d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000069ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000018001e7811ULL, 0x000fe200078ff0ffULL, 0x000117127f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x0004e400000e0000ULL, 0x0000001e42427220ULL, 0x08cfe40000410000ULL,
0x0000001e43437220ULL, 0x080fe40000410000ULL, 0x0000001e46467220ULL, 0x080fe40000410000ULL,
0x0000001e47477220ULL, 0x080fe40000410000ULL, 0x0000001e4a4a7220ULL, 0x080fe40000410000ULL,
0x0000001e4b4b7220ULL, 0x000fc40000410000ULL, 0x0000001e4e4e7220ULL, 0x080fe40000410000ULL,
0x0000001e4f4f7220ULL, 0x080fe40000410000ULL, 0x0000001e52527220ULL, 0x080fe40000410000ULL,
0x0000001e53537220ULL, 0x080fe40000410000ULL, 0x0000001e56567220ULL, 0x080fe40000410000ULL,
0x0000001e57577220ULL, 0x000fc40000410000ULL, 0x0000001e5a5a7220ULL, 0x080fe40000410000ULL,
0x0000001e5b5b7220ULL, 0x080fe40000410000ULL, 0x0000001e5e5e7220ULL, 0x080fe40000410000ULL,
0x0000001e5f5f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006966ff7212ULL, 0x000fe400078030ffULL, 0x0000001b641b7209ULL, 0x000fd60007810000ULL,
0x8000001b64640221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b64640820ULL, 0x000fc80000410000ULL,
0x0000006400120308ULL, 0x000e640000000800ULL, 0x0000001265650220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000001d651d7221ULL, 0x000fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000012ff0e723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe40000011600ULL,
0x000054100e0e7816ULL, 0x000fe2000000000eULL, 0x000115727f007947ULL, 0x000fea000b800000ULL,
0x00001f130e117589ULL, 0x0002a400000e0000ULL, 0x00000008131e7810ULL, 0x000fe20007ffe0ffULL,
0x000115c27f007947ULL, 0x000fea000b800000ULL, 0x00000010130f7810ULL, 0x000fe20007ffe0ffULL,
0x00001f1e0e107589ULL, 0x00066a00000e0000ULL, 0x00001f0f0e0f7589ULL, 0x0006a400000e0000ULL,
0x00000018131e7810ULL, 0x008fe20007ffe0ffULL, 0x000116527f007947ULL, 0x000fea000b800000ULL,
0x00001f1e0e0e7589ULL, 0x0022e400000e0000ULL, 0x000000039d137811ULL, 0x000fe200078ff0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000170001c1c7810ULL, 0x000fe20007ffe0ffULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0x0001200013137811ULL, 0x000fc600078e60ffULL,
0x000000100a707824ULL, 0x100fe400078e021cULL, 0x000000100d0d7824ULL, 0x100fe400078e0213ULL,
0x000000100c0c7824ULL, 0x000fe400078e0213ULL, 0x000000100b6c7824ULL, 0x100fe200078e021cULL,
0x000000000d74783bULL, 0x0002e20000000200ULL, 0x0000001009687824ULL, 0x000fc600078e021cULL,
0x000000000c64783bULL, 0x0002a20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000001174747232ULL, 0x08cfe40000000000ULL, 0x0000001176767232ULL, 0x000fe40000000000ULL,
0x0000001075757232ULL, 0x080fe40000000000ULL, 0x0000001077777232ULL, 0x000fe40000000000ULL,
0x0000000f64647232ULL, 0x080fe40000000000ULL, 0x0000000f66667232ULL, 0x000fc40000000000ULL,
0x0000000e65657232ULL, 0x080fe40000000000ULL, 0x0000000e67677232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001008087824ULL, 0x100fe200078e021cULL,
0x000000007070783bULL, 0x000e620000004200ULL, 0x0000001306067211ULL, 0x000fe200078e20ffULL,
0x00000010050c7824ULL, 0x102fe200078e021cULL, 0x0000023000007945ULL, 0x000fe20003800000ULL,
0x000000006c6c783bULL, 0x000fe20000004200ULL, 0x00000010040d7824ULL, 0x100fe400078e021cULL,
0x0000001003037824ULL, 0x000fe200078e021cULL, 0x000000000808783bULL, 0x000e680000004200ULL,
0x000000006868783bULL, 0x000ee40000004200ULL, 0x000000707460723cULL, 0x048f700000001860ULL,
0x000000087438723cULL, 0x082f700000001838ULL, 0x000000086458723cULL, 0x004b6e0000001858ULL,
0x0000001007087824ULL, 0x020fe200078e0213ULL, 0x0000000a743c723cULL, 0x080f62000000183cULL,
0x000000000604783bULL, 0x000e6e0000000200ULL, 0x0000000a645c723cULL, 0x000b64000000185cULL,
0x000000000808783bULL, 0x020eac0000000200ULL, 0x000000727424723cULL, 0x040b700000001824ULL,
0x0000006c7428723cULL, 0x040b700000001828ULL, 0x0000006e742c723cULL, 0x040b70000000182cULL,
0x000000687430723cULL, 0x040b700000001830ULL, 0x0000006a7434723cULL, 0x000b700000001834ULL,
0x000000706440723cULL, 0x040b700000001840ULL, 0x000000726444723cULL, 0x040b700000001844ULL,
0x0000006c6448723cULL, 0x040b700000001848ULL, 0x0000006e644c723cULL, 0x040b70000000184cULL,
0x000000686450723cULL, 0x040b700000001850ULL, 0x0000006a6454723cULL, 0x000b620000001854ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000008000008947ULL, 0x000fde0003800000ULL,
0x0000001108087232ULL, 0x086fe40000000000ULL, 0x000000110a0a7232ULL, 0x000fc40000000000ULL,
0x0000001009097232ULL, 0x080fe40000000000ULL, 0x000000100b0b7232ULL, 0x000fe40000000000ULL,
0x0000000f04047232ULL, 0x080fe40000000000ULL, 0x0000000f06067232ULL, 0x000fe40000000000ULL,
0x0000000e05057232ULL, 0x080fe40000000000ULL, 0x0000000e07077232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x006fea0003800000ULL, 0x0000001002027824ULL, 0x000fe200078e021cULL,
0x000000000c64783bULL, 0x020e680000004200ULL, 0x000000000d68783bULL, 0x000ea80000004200ULL,
0x00000000036c783bULL, 0x000ee80000004200ULL, 0x000000000270783bULL, 0x0002a40000004200ULL,
0x00000002ff027819ULL, 0x002fc8000001169dULL, 0x0001e6a002027811ULL, 0x000fe200078e18ffULL,
0x000000640860723cULL, 0x040b700000001860ULL, 0x000000660824723cULL, 0x040b700000001824ULL,
0x000000680828723cULL, 0x044b700000001828ULL, 0x0000006a082c723cULL, 0x040b70000000182cULL,
0x0000006c0830723cULL, 0x048b700000001830ULL, 0x0000006e0834723cULL, 0x040b700000001834ULL,
0x000000700838723cULL, 0x040b700000001838ULL, 0x00000072083c723cULL, 0x000b70000000183cULL,
0x000000640440723cULL, 0x040b700000001840ULL, 0x000000660444723cULL, 0x040b700000001844ULL,
0x000000680448723cULL, 0x040b700000001848ULL, 0x0000006a044c723cULL, 0x040b70000000184cULL,
0x0000006c0450723cULL, 0x040b700000001850ULL, 0x0000006e0454723cULL, 0x040b700000001854ULL,
0x000000700458723cULL, 0x040b700000001858ULL, 0x00000072045c723cULL, 0x000b62000000185cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000229900720cULL, 0x000fe20003f06070ULL,
0x0000000002ff7f8cULL, 0x0003d8000c80043fULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff816000007947ULL, 0x000fea000383ffffULL, 0x0000000000057919ULL, 0x020e640000002500ULL,
0x000000220500720cULL, 0x002fda0003f06070ULL, 0x0000057000000947ULL, 0x000fea0003800000ULL,
0x018000001d007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x000fe200078e001dULL,
0x00009f8000067802ULL, 0x000fc40000000f00ULL, 0x0001140000007944ULL, 0x010fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001d00007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc8000000001dULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x00000002ff077819ULL, 0x002fe40000011603ULL,
0x00000018030d7811ULL, 0x040fe400078ff0ffULL, 0x0000000803097811ULL, 0x040fe200078ff0ffULL,
0x00001f0700027589ULL, 0x00ce6200000e0000ULL, 0x00000010030b7811ULL, 0x000fc600078ff0ffULL,
0x00001f0d00067589ULL, 0x000ea800000e0000ULL, 0x00001f0900037589ULL, 0x000ee800000e0000ULL,
0x00001f0b00047589ULL, 0x000ea200000e0000ULL, 0x0000006002607220ULL, 0x042fe40000410000ULL,
0x0000006102617220ULL, 0x000fc40000410000ULL, 0x0000002402247220ULL, 0x040fe40000410000ULL,
0x0000002502257220ULL, 0x040fe40000410000ULL, 0x0000002802287220ULL, 0x040fe40000410000ULL,
0x0000002902297220ULL, 0x040fe40000410000ULL, 0x0000002c022c7220ULL, 0x040fe40000410000ULL,
0x0000002d022d7220ULL, 0x000fc40000410000ULL, 0x0000003002307220ULL, 0x040fe40000410000ULL,
0x0000003102317220ULL, 0x040fe40000410000ULL, 0x0000003402347220ULL, 0x040fe40000410000ULL,
0x0000003502357220ULL, 0x040fe40000410000ULL, 0x0000003802387220ULL, 0x040fe40000410000ULL,
0x0000003902397220ULL, 0x000fc40000410000ULL, 0x0000003c023c7220ULL, 0x040fe40000410000ULL,
0x0000003d023d7220ULL, 0x000fe40000410000ULL, 0x0000004206427220ULL, 0x044fe40000410000ULL,
0x0000004306437220ULL, 0x040fe40000410000ULL, 0x0000004606467220ULL, 0x040fe40000410000ULL,
0x0000004706477220ULL, 0x000fc40000410000ULL, 0x0000004a064a7220ULL, 0x040fe40000410000ULL,
0x0000004b064b7220ULL, 0x040fe40000410000ULL, 0x0000004e064e7220ULL, 0x040fe40000410000ULL,
0x0000004f064f7220ULL, 0x040fe40000410000ULL, 0x0000005206527220ULL, 0x040fe40000410000ULL,
0x0000005306537220ULL, 0x000fc40000410000ULL, 0x0000005606567220ULL, 0x040fe40000410000ULL,
0x0000005706577220ULL, 0x040fe40000410000ULL, 0x0000005a065a7220ULL, 0x040fe40000410000ULL,
0x0000005b065b7220ULL, 0x040fe40000410000ULL, 0x0000005e065e7220ULL, 0x040fe40000410000ULL,
0x0000005f065f7220ULL, 0x000fc40000410000ULL, 0x0000000362627220ULL, 0x088fe40000410000ULL,
0x0000000363637220ULL, 0x080fe40000410000ULL, 0x0000000326267220ULL, 0x080fe40000410000ULL,
0x0000000327277220ULL, 0x080fe40000410000ULL, 0x000000032a2a7220ULL, 0x080fe40000410000ULL,
0x000000032b2b7220ULL, 0x000fc40000410000ULL, 0x000000032e2e7220ULL, 0x080fe40000410000ULL,
0x000000032f2f7220ULL, 0x080fe40000410000ULL, 0x0000000332327220ULL, 0x080fe40000410000ULL,
0x0000000333337220ULL, 0x080fe40000410000ULL, 0x0000000336367220ULL, 0x080fe40000410000ULL,
0x0000000337377220ULL, 0x000fc40000410000ULL, 0x000000033a3a7220ULL, 0x080fe40000410000ULL,
0x000000033b3b7220ULL, 0x080fe40000410000ULL, 0x000000033e3e7220ULL, 0x080fe40000410000ULL,
0x000000033f3f7220ULL, 0x000fe40000410000ULL, 0x0000000440407220ULL, 0x080fe40000410000ULL,
0x0000000441417220ULL, 0x000fc40000410000ULL, 0x0000000444447220ULL, 0x080fe40000410000ULL,
0x0000000445457220ULL, 0x080fe40000410000ULL, 0x0000000448487220ULL, 0x080fe40000410000ULL,
0x0000000449497220ULL, 0x080fe40000410000ULL, 0x000000044c4c7220ULL, 0x080fe40000410000ULL,
0x000000044d4d7220ULL, 0x000fc40000410000ULL, 0x0000000450507220ULL, 0x080fe40000410000ULL,
0x0000000451517220ULL, 0x080fe40000410000ULL, 0x0000000454547220ULL, 0x080fe40000410000ULL,
0x0000000455557220ULL, 0x080fe40000410000ULL, 0x0000000458587220ULL, 0x080fe40000410000ULL,
0x0000000459597220ULL, 0x000fc40000410000ULL, 0x000000045c5c7220ULL, 0x080fe40000410000ULL,
0x000000045d5d7220ULL, 0x000fc40000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000262726723eULL, 0x000fe400000000ffULL, 0x0000002c2d08723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002a2b2a723eULL, 0x000fc400000000ffULL,
0x000000242506723eULL, 0x000fe400000000ffULL, 0x000000282907723eULL, 0x000fe400000000ffULL,
0x0000002e2f2e723eULL, 0x000fe400000000ffULL, 0x000000606104723eULL, 0x000fe400000000ffULL,
0x000000303109723eULL, 0x000fe400000000ffULL, 0x00000034350a723eULL, 0x000fc400000000ffULL,
0x00000002ff1a7819ULL, 0x002fe40000011600ULL, 0x00000008002d7811ULL, 0x000fe400078ff0ffULL,
0x000000011a027810ULL, 0x040fe20007ffe0ffULL, 0x000000081a1f7824ULL, 0x040fe200078e00ffULL,
0x000000021a037810ULL, 0x040fe20007ffe0ffULL, 0x000000081a1c7824ULL, 0x040fe200078e00ffULL,
0x000000031a167810ULL, 0x040fe20007ffe0ffULL, 0x000000081a237824ULL, 0x040fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee202ULL, 0x000000081a277824ULL, 0x000fe200078e00ffULL,
0xfffffff81c217812ULL, 0x000fe200078ee203ULL, 0x000000081a2b7824ULL, 0x040fe200078e00ffULL,
0x000000051a027810ULL, 0x000fc40007ffe0ffULL, 0x000000041a197810ULL, 0x050fe40007ffe0ffULL,
0x000000031a1e7819ULL, 0x040fe400000006ffULL, 0x000000061a037810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823237812ULL, 0x000fe400078ee216ULL, 0xfffffff827277812ULL, 0x000fe200078ee202ULL,
0x000000082d027824ULL, 0x000fe200078e00ffULL, 0xfffffff81e257812ULL, 0x000fe200078ee219ULL,
0x000000081a197824ULL, 0x040fe200078e00ffULL, 0xffffffff1a167810ULL, 0x000fc40007ffe0ffULL,
0xfffffff81c297812ULL, 0x000fe200078ee203ULL, 0x0000200015037824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee216ULL, 0x0000000400167824ULL, 0x000fe200078e00ffULL,
0xfffffff8022d7812ULL, 0x000fe400078ee22dULL, 0xfffffff819197812ULL, 0x000fe400078ee21aULL,
0x0000000318027211ULL, 0x000fe400078e60ffULL, 0x0000000c16167812ULL, 0x000fc400078ec0ffULL,
0x00000010002f7811ULL, 0x040fe200078ff0ffULL, 0x0000001019197824ULL, 0x100fe200078e0202ULL,
0x000000022d2d7211ULL, 0x000fe200078e20ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0202ULL,
0x0000001800317811ULL, 0x000fe200078ff0ffULL, 0x0000001021217824ULL, 0x100fe200078e0202ULL,
0x00000038390b723eULL, 0x000fe200000000ffULL, 0x0000001023237824ULL, 0x100fe200078e0202ULL,
0x0000003c3d0c723eULL, 0x000fe200000000ffULL, 0x0000001025257824ULL, 0x000fe200078e0202ULL,
0x000000626362723eULL, 0x000fe200000000ffULL, 0x0000000119197824ULL, 0x000fe200078e0216ULL,
0x000000323332723eULL, 0x000fe200000000ffULL, 0x0000001027277824ULL, 0x100fe200078e0202ULL,
0x000000363736723eULL, 0x000fe200000000ffULL, 0x0000001029297824ULL, 0x100fe200078e0202ULL,
0x0000000419007388ULL, 0x000fe20000000800ULL, 0x00000001161f7824ULL, 0x040fe200078e021fULL,
0x0000003a3b3a723eULL, 0x000fe200000000ffULL, 0x000000082f1a7824ULL, 0x000fe200078e00ffULL,
0x0000002916297210ULL, 0x040fe20007ffe0ffULL, 0x0000000116217824ULL, 0x000fe200078e0221ULL,
0x000000061f007388ULL, 0x000fe20000000800ULL, 0x000000102b2b7824ULL, 0x100fe200078e0202ULL,
0xfffffff81a2f7812ULL, 0x000fe200078ee22fULL, 0x0000000116237824ULL, 0x040fe200078e0223ULL,
0x0000000721007388ULL, 0x000fe20000000800ULL, 0x0000000116257824ULL, 0x040fe200078e0225ULL,
0x0000003e3f3e723eULL, 0x000fe200000000ffULL, 0x0000000116277824ULL, 0x040fe200078e0227ULL,
0x0000000823007388ULL, 0x0003e20000000800ULL, 0x00000001162b7824ULL, 0x040fe200078e022bULL,
0x000000404140723eULL, 0x000fe200000000ffULL, 0x00000001162d7824ULL, 0x000fe200078e022dULL,
0x0000000925007388ULL, 0x000fe20000000800ULL, 0x00000008311c7824ULL, 0x000fe200078e00ffULL,
0x000000444544723eULL, 0x000fe200000000ffULL, 0x000000102f2f7824ULL, 0x000fe200078e0202ULL,
0x0000000a27007388ULL, 0x000fe20000000800ULL, 0x000000484948723eULL, 0x000fe200000000ffULL,
0x0000000117087824ULL, 0x002fe200078e0200ULL, 0xfffffff81c317812ULL, 0x000fe200078ee231ULL,
0x0000000b29007388ULL, 0x000fe20000000800ULL, 0x00000001162f7824ULL, 0x000fe200078e022fULL,
0x0000004c4d4c723eULL, 0x000fe200000000ffULL, 0x0000001008077824ULL, 0x000fe200078e0203ULL,
0x0000000c2b007388ULL, 0x000fe20000000800ULL, 0x000000505150723eULL, 0x000fe200000000ffULL,
0x0000001031317824ULL, 0x000fe200078e0202ULL, 0x000000545554723eULL, 0x000fe200000000ffULL,
0x000000622d007388ULL, 0x000fe20000000800ULL, 0x000000585958723eULL, 0x000fe200000000ffULL,
0x0000000116167824ULL, 0x000fe200078e0231ULL, 0x0000005c5d5c723eULL, 0x000fe200000000ffULL,
0x000400261f007388ULL, 0x000fe20000000800ULL, 0x00000042430d723eULL, 0x000fc400000000ffULL,
0x00000046470e723eULL, 0x000fe200000000ffULL, 0x0004002a21007388ULL, 0x000fe20000000800ULL,
0x0000004a4b0f723eULL, 0x000fe400000000ffULL, 0x0000004e4f10723eULL, 0x000fe200000000ffULL,
0x0004002e23007388ULL, 0x000fe20000000800ULL, 0x000000525311723eULL, 0x000fe400000000ffULL,
0x000000565712723eULL, 0x000fe200000000ffULL, 0x0004003225007388ULL, 0x000fe20000000800ULL,
0x0000005a5b13723eULL, 0x000fc400000000ffULL, 0x0000005e5f14723eULL, 0x000fe200000000ffULL,
0x0004003627007388ULL, 0x000fe80000000800ULL, 0x0004003a29007388ULL, 0x000fe80000000800ULL,
0x0004003e2b007388ULL, 0x000fe80000000800ULL, 0x000000402f007388ULL, 0x000fe80000000800ULL,
0x000800441f007388ULL, 0x000fe80000000800ULL, 0x0008004821007388ULL, 0x000fe80000000800ULL,
0x0008004c23007388ULL, 0x000fe80000000800ULL, 0x0008005025007388ULL, 0x000fe80000000800ULL,
0x0008005427007388ULL, 0x000fe80000000800ULL, 0x0008005829007388ULL, 0x000fe80000000800ULL,
0x0008005c2b007388ULL, 0x000fe80000000800ULL, 0x0000000d16007388ULL, 0x0003e80000000800ULL,
0x000c000e1f007388ULL, 0x000fe80000000800ULL, 0x000c000f21007388ULL, 0x000fe20000000800ULL,
0x00000300ff167624ULL, 0x002fc600078e00ffULL, 0x000c001023007388ULL, 0x000fe40000000800ULL,
0x000000011600780cULL, 0x000fe40003f05270ULL, 0x000c001125007388ULL, 0x000fe80000000800ULL,
0x000c001227007388ULL, 0x000fe80000000800ULL, 0x000c001329007388ULL, 0x000fe80000000800ULL,
0x000c00142b007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000072c7984ULL, 0x000e680000000c00ULL, 0x00040000070c7984ULL, 0x000ea80000000c00ULL,
0x0008000007207984ULL, 0x000ee80000000c00ULL, 0x000c000007247984ULL, 0x000ee80000000c00ULL,
0x0010000007307984ULL, 0x000ee80000000c00ULL, 0x0014000007347984ULL, 0x000ee80000000c00ULL,
0x0018000007387984ULL, 0x000ee80000000c00ULL, 0x001c0000073c7984ULL, 0x000ee20000000c00ULL,
0x200000ff2f2f7230ULL, 0x002fc40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fe40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x200000ff0f0f7230ULL, 0x004fe40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fc40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff23237230ULL, 0x008fe40000000000ULL, 0x200000ff22227230ULL, 0x000fe40000000000ULL,
0x200000ff21217230ULL, 0x000fe40000000000ULL, 0x200000ff20207230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x000fc40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fe40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x000000332f2f7230ULL, 0x000fe40000000000ULL, 0x000000322e2e7230ULL, 0x000fe40000000000ULL,
0x000000312d2d7230ULL, 0x000fc40000000000ULL, 0x000000302c2c7230ULL, 0x000fe40000000000ULL,
0x000000370f0f7230ULL, 0x000fe40000000000ULL, 0x000000360e0e7230ULL, 0x000fe20000000000ULL,
0x0000002c07007388ULL, 0x000fe20000000c00ULL, 0x000000350d0d7230ULL, 0x000fe40000000000ULL,
0x000000340c0c7230ULL, 0x000fe40000000000ULL, 0x0000003b23237230ULL, 0x000fc40000000000ULL,
0x0000003a22227230ULL, 0x000fe20000000000ULL, 0x0004000c07007388ULL, 0x000fe20000000c00ULL,
0x0000003921217230ULL, 0x000fe40000000000ULL, 0x0000003820207230ULL, 0x000fe40000000000ULL,
0x0000003f27277230ULL, 0x000fe40000000000ULL, 0x0000003e26267230ULL, 0x000fe20000000000ULL,
0x0008002007007388ULL, 0x000fe20000000c00ULL, 0x0000003d25257230ULL, 0x000fc40000000000ULL,
0x0000003c24247230ULL, 0x000fca0000000000ULL, 0x000c002407007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000397000008947ULL, 0x000fea0003800000ULL,
0x00000400ff047624ULL, 0x000fe200078e00ffULL, 0x0000000000127919ULL, 0x000e620000002600ULL,
0x00000040080b7810ULL, 0x000fc40007ffe0ffULL, 0x00006c0004047a24ULL, 0x000fe200078e02ffULL,
0x0000000000097919ULL, 0x000e620000002700ULL, 0x00000080080d7810ULL, 0x000fc60007ffe0ffULL,
0x0000000f04067811ULL, 0x040fe200078e10ffULL, 0x0000030004047a24ULL, 0x000fe200078e02ffULL,
0x0000000007207984ULL, 0x000ea40000000c00ULL, 0xfffffff006197812ULL, 0x000fe400078ec0ffULL,
0x0004000007287984ULL, 0x000ee40000000c00ULL, 0x0000001904277211ULL, 0x040fe400078e38ffULL,
0x00080000072c7984ULL, 0x000ea60000000c00ULL, 0x0000008004047824ULL, 0x000fe200078e0227ULL,
0x000c000007307984ULL, 0x0008a80000000c00ULL, 0x0000007f04047810ULL, 0x000fe20007ffe0ffULL,
0x0000040009127a24ULL, 0x002fc600078e0212ULL, 0xffffff8004137812ULL, 0x000fe200078ec0ffULL,
0x0000030012067a24ULL, 0x000fe200078e02ffULL, 0x000000c008077810ULL, 0x010fc60007ffe0ffULL,
0x00000001060e7824ULL, 0x000fe200078e0205ULL, 0x0000700013057a10ULL, 0x000fc80007f1e0ffULL,
0x000000050e047211ULL, 0x000fe200078268ffULL, 0x00007100ff057624ULL, 0x000fe200000e06ffULL,
0x0000000118ff7812ULL, 0x000fc8000780f89dULL, 0x000000050e057211ULL, 0x000fe400008f6cffULL,
0x00007000191f7a10ULL, 0x000fc60007f3e0ffULL, 0x0000100015047825ULL, 0x000fc800078e0004ULL,
0x00007100ff147624ULL, 0x000fe400008e06ffULL, 0x0000001008087825ULL, 0x000fc800078e0004ULL,
0x000000100b0a7825ULL, 0x000fc800078e0004ULL, 0x000000100d0c7825ULL, 0x000fc800078e0004ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x0000001000077824ULL, 0x00cfe200078e00ffULL, 0x00000001ff0f7819ULL, 0x000fe20000011600ULL,
0x000000800e107824ULL, 0x000fc600078e00ffULL, 0x00000070071a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0f0f7812ULL, 0x000fe400078ec0ffULL, 0x0000700010117a10ULL, 0x000fe40007ebe027ULL,
0x00000019ff077819ULL, 0x000fe4000001160eULL, 0x0000001f1a0e7210ULL, 0x000fe40007a3e010ULL,
0x000000110f107210ULL, 0x000fc40007c7e01aULL, 0x0000710007117a10ULL, 0x000fe40002fec4ffULL,
0x0000000e0f0e7210ULL, 0x000fe40007fbe0ffULL, 0x00000014ff077210ULL, 0x000fe40000fe4407ULL,
0x00000011ff117210ULL, 0x000fc60001fe84ffULL, 0x000000ffff0f7224ULL, 0x000fca00028e0607ULL,
0x0000001b0e007986ULL, 0x0003e8000c101906ULL, 0x0000001d10007986ULL, 0x0003e4000c101906ULL,
0x000000ff0000720cULL, 0x00cfe20000705670ULL, 0x0000002008007986ULL, 0x000fe2000c101d06ULL,
0x0000017000007945ULL, 0x000fe60003800000ULL, 0x000000280a007986ULL, 0x000fe8000c101d06ULL,
0x0000002c0c007986ULL, 0x000fe8000c101d06ULL, 0x0000003004007986ULL, 0x000fe8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0xffffffff16077810ULL, 0x000fc60007ffe0ffULL,
0x0000700012047625ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000007040479a8ULL, 0x000ea400099ee1c6ULL, 0x000000070400720cULL, 0x004fc80003f05270ULL,
0x00000001ff087807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000008ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff047984ULL, 0x000ee40000000000ULL,
0x000000ff0400720cULL, 0x008fda0003f05270ULL, 0x0000347000008947ULL, 0x000fea0003800000ULL,
0x000000ff9d00720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000000400057819ULL, 0x000fe400000006ffULL, 0x00000001ff087819ULL, 0x004fe40000011600ULL,
0x0000001f06047211ULL, 0x000fe400078038ffULL, 0x0000007005077812ULL, 0x000fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fe400078ec0ffULL, 0x0000001406057211ULL, 0x000fc400000f3cffULL,
0x0000000408047210ULL, 0x000fc8000791e007ULL, 0x00000005ff057210ULL, 0x000fca00007e24ffULL,
0x0000000604087981ULL, 0x000528000c1e1900ULL, 0x0000800604097981ULL, 0x000522000c1e1900ULL,
0x000000021600780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010006040b7981ULL, 0x004522000c1e1900ULL, 0x000000041600780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x00018006040d7981ULL, 0x004522000c1e1900ULL,
0x000000041600780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x00020006040f7981ULL, 0x006322000c1e1900ULL, 0x000000061600780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800604117981ULL, 0x002322000c1e1900ULL,
0x000000061600780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081600780cULL, 0x002fe20003f06070ULL, 0x00030006041b7981ULL, 0x000318000c1e1900ULL,
0x00038006041d0981ULL, 0x000324000c1e1900ULL, 0x0000000716047810ULL, 0x006fc80007ffe0ffULL,
0x00000003ff077819ULL, 0x000fc80000011604ULL, 0x000000ff0700720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x0000001906217211ULL, 0x040fe200078038ffULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1f7224ULL, 0x010fe200078e0008ULL, 0x0000700021217a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff060a7211ULL, 0x000fe400000f3cffULL, 0x0000078021217810ULL, 0x000fc80007f5e0ffULL,
0x00007100ff0a7a10ULL, 0x000fc400017e240aULL, 0x000003000c007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000407007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x000000080c047810ULL, 0x040fe40007ffe0ffULL,
0x000000010c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001f08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000421047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffc8006041f7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x000000090c047810ULL, 0x042fe40007ffe0ffULL,
0x000000020c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000908087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000421047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffd000604097981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a0c047810ULL, 0x042fe40007ffe0ffULL,
0x000000030c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000b08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000421047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffd8006040b7981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b0c047810ULL, 0x042fe40007ffe0ffULL,
0x000000040c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000d08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000400047819ULL, 0x000fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe40000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000421047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffe0006040d7981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c0c047810ULL, 0x042fe40007ffe0ffULL,
0x000000050c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000f08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000421047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffe8006040f7981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d0c047810ULL, 0x042fe40007ffe0ffULL,
0x000000060c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001108087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000421047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xffff000604117981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e0c047810ULL, 0x042fe40007ffe0ffULL,
0x000000070c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001b08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000421047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xffff8006041b7981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f0c047810ULL, 0x002fe40007ffe0ffULL,
0x0000001d08087209ULL, 0x000fe40007810000ULL, 0x0000030004007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000421047210ULL, 0x000fc80007f3e0ffULL,
0x0000000aff057210ULL, 0x000fca0000ffe4ffULL, 0x00000006041d7981ULL, 0x000328000c1e1900ULL,
0x0000040021217810ULL, 0x000fe40007f3e0ffULL, 0x000000080c0c7810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e060aULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x0000001000047824ULL, 0x006fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fca00078ec0ffULL, 0x0000000104057824ULL, 0x000fca00078e0205ULL,
0x0000000805007388ULL, 0x0103e40000000800ULL, 0x0000700013047a10ULL, 0x000fe20007f3e0ffULL,
0x0000000118297824ULL, 0x000fe200078e0206ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x0000100015077824ULL, 0x000fe200078e00ffULL, 0x00000002ff0b7819ULL, 0x000fe2000001169dULL,
0x00007100ff057624ULL, 0x002fe200008e06ffULL, 0x0000002000137810ULL, 0x040fe20007ffe0ffULL,
0x00000010000f7824ULL, 0x040fe200078e00ffULL, 0x000000010b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000200029087825ULL, 0x004fe200078e0004ULL, 0x00000040001b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002180c8824ULL, 0x100fe200078e0215ULL,
0x00000007080a7210ULL, 0x000fe20007f3e0ffULL, 0x00000002180e8824ULL, 0x000fe200078e0215ULL,
0x00000060001d7810ULL, 0x000fe20007ffe0ffULL, 0x0000400018087824ULL, 0x000fe200078e0203ULL,
0x0000000b0c2d8211ULL, 0x000fe200078e08ffULL, 0x000000020e2f8824ULL, 0x000fe200078e020bULL,
0x00000001ff0e7819ULL, 0x000fe20000011600ULL, 0x000000ffff0b7224ULL, 0x000fe200008e0609ULL,
0x00000080001f7810ULL, 0x040fe20007ffe0ffULL, 0x000004009d097824ULL, 0x000fe200078e00ffULL,
0x000000a000217810ULL, 0x040fe20007ffe0ffULL, 0x0000001013127825ULL, 0x100fe200078e000aULL,
0x000000c000237810ULL, 0x040fe20007ffe0ffULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000100009097812ULL, 0x000fe200078ec0ffULL, 0x000000101b1a7825ULL, 0x000fe200078e000aULL,
0x000000e000257810ULL, 0x000fe20007ffe0ffULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x000000700f0f7812ULL, 0x000fe200078ec0ffULL, 0x0000000108097824ULL, 0x000fe200078e0209ULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x000000101d1c7825ULL, 0x100fe200078e000aULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x000000101f1e7825ULL, 0x100fe200078e000aULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000001021207825ULL, 0x100fe200078e000aULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000001023227825ULL, 0x100fe200078e000aULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000001025247825ULL, 0x100fe200078e000aULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000001000107825ULL, 0x040fe200078e000aULL,
0x00007000270a7a10ULL, 0x000fe20007f3e0ffULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00007000190b7a10ULL, 0x000fe20007f5e0ffULL, 0x000000010f147824ULL, 0x000fe200078e020eULL,
0x00007100ff0c7a10ULL, 0x000fe20000ffe4ffULL, 0x00000010002b7824ULL, 0x000fe200078e0209ULL,
0x0000000a29268211ULL, 0x040fe200078238ffULL, 0x00007100ff0d7624ULL, 0x000fe200010e06ffULL,
0x0000000014097984ULL, 0x0002a20000000800ULL, 0x0000000b29288211ULL, 0x000fe200078438ffULL,
0x000000082f2f8824ULL, 0x000fe200078e0200ULL, 0x0000000c29278211ULL, 0x040fe200008f3cffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000102b7faeULL, 0x0007e2000b901c46ULL,
0x0000030018007a0cULL, 0x000fe20003f26070ULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x0000000d29298211ULL, 0x000fe200010f3cffULL, 0x00380000122b7faeULL, 0x0009e2000b901c46ULL,
0x000000ffff147224ULL, 0x002fc400078e00ffULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x005800001a2b7faeULL, 0x0003e8000b901c46ULL, 0x007800001c2b7faeULL, 0x0003e2000b901c46ULL,
0x0000000000107805ULL, 0x008fc6000001ff00ULL, 0x009800001e2b7faeULL, 0x0007e2000b901c46ULL,
0x0000000000127805ULL, 0x010fe2000001ff00ULL, 0x000000082d1b8824ULL, 0x002fe400078e0200ULL,
0x00b80000202b7faeULL, 0x0003e2000b901c46ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000010001c8825ULL, 0x040fe200078e0026ULL, 0x000085801b1b8811ULL, 0x000fe200078e20ffULL,
0x00d80000222b7faeULL, 0x0009e2000b901c46ULL, 0x000081802f278811ULL, 0x000fe200078e20ffULL,
0x00000010001e8825ULL, 0x008fe200078e0028ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00f80000242b7faeULL, 0x0007e2000b901c46ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x002fc4000001ff00ULL, 0x000000001c1b8faeULL, 0x0003e8000b901c46ULL,
0x000000001e278faeULL, 0x0005e2000b901c46ULL, 0x0000000000227805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000002a7805ULL, 0x008fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x002fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x004fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000130000001947ULL, 0x000fea0003800000ULL,
0x000000ffff107224ULL, 0x000fe400078e00ffULL, 0x000000ffff547224ULL, 0x000fca00078e0018ULL,
0x0000000254557810ULL, 0x000fc80007ffe0ffULL, 0x0000030055007a0cULL, 0x000fda0003f06070ULL,
0x0000035000000947ULL, 0x000fea0003800000ULL, 0x000000070000780cULL, 0x000fe40003f44070ULL,
0x00000001ff567819ULL, 0x000fe40000011655ULL, 0x0000005506677210ULL, 0x000fe40007ffe0ffULL,
0x0000000156577812ULL, 0x000fe200078ec0ffULL, 0x0000080055567824ULL, 0x000fe200078e00ffULL,
0x0000002000597810ULL, 0x040fe20007ffe0ffULL, 0x00002000670e7825ULL, 0x000fe200078e0004ULL,
0x00000040005b7810ULL, 0x000fc40007ffe0ffULL, 0x00000060005d7810ULL, 0x000fe20007ffe0ffULL,
0x000000021858a824ULL, 0x100fe200078e0215ULL, 0x000000070e0e7210ULL, 0x000fe20007f1e0ffULL,
0x00000002185aa824ULL, 0x000fe200078e0215ULL, 0x00000080005f7810ULL, 0x000fe20007ffe0ffULL,
0x00000002586ba824ULL, 0x100fe200078e0257ULL, 0x000000a000617810ULL, 0x000fe20007ffe0ffULL,
0x000000025a6da824ULL, 0x000fe200078e0257ULL, 0x0000100056577812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e060fULL, 0x000000c000637810ULL, 0x040fe20007ffe0ffULL,
0x000000086d6da824ULL, 0x000fe200078e0200ULL, 0x000000e000657810ULL, 0x000fe20007ffe0ffULL,
0x0000000108577824ULL, 0x000fe200078e0257ULL, 0x0000000a6764a211ULL, 0x000fe200078038ffULL,
0x0000001059587825ULL, 0x000fe200078e000eULL, 0x0000000b6766a211ULL, 0x000fc400078238ffULL,
0x000000006b6ba211ULL, 0x000fe200078e18ffULL, 0x0000001000697824ULL, 0x040fe400078e0257ULL,
0x0000001000567825ULL, 0x000fe200078e000eULL, 0x000085806b6ba811ULL, 0x000fc600078e20ffULL,
0x000000105b5a7825ULL, 0x100fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000056697faeULL, 0x0003e6000b901c46ULL, 0x000000105d5c7825ULL, 0x100fe200078e000eULL,
0x0038000058697faeULL, 0x0005e6000b901c46ULL, 0x000000105f5e7825ULL, 0x100fe200078e000eULL,
0x005800005a697faeULL, 0x0007e6000b901c46ULL, 0x0000001061607825ULL, 0x100fe200078e000eULL,
0x007800005c697faeULL, 0x0007e6000b901c46ULL, 0x0000001063627825ULL, 0x000fe200078e000eULL,
0x009800005e697faeULL, 0x0007e2000b901c46ULL, 0x000081806d59a811ULL, 0x004fc400078e20ffULL,
0x00000010650e7825ULL, 0x000fe200078e000eULL, 0x0000000c6765a211ULL, 0x040fe200000f3cffULL,
0x00b8000060697faeULL, 0x0007e2000b901c46ULL, 0x0000000d6767a211ULL, 0x000fc600008f3cffULL,
0x000000100064a825ULL, 0x040fe200078e0064ULL, 0x00d8000062697faeULL, 0x0007e6000b901c46ULL,
0x000000100056a825ULL, 0x002fe200078e0066ULL, 0x00f800000e697faeULL, 0x0007e8000b901c46ULL,
0x00000000646bafaeULL, 0x0007e8000b901c46ULL, 0x000000005659afaeULL, 0x0007e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff577224ULL, 0x008fe200078e0054ULL,
0x00000001ff567819ULL, 0x100fe20000011600ULL, 0x0000000218597824ULL, 0x000fe200078e0215ULL,
0x00000002ff6b7819ULL, 0x000fe20000011600ULL, 0x00000040570e7824ULL, 0x000fc400078e00ffULL,
0x00000010000f7824ULL, 0x000fe200078e00ffULL, 0x000000046b5a7810ULL, 0x040fe20007ffe0ffULL,
0x000000086b5b7824ULL, 0x040fe200078e00ffULL, 0x000000800e0e7812ULL, 0x000fe200078ec0ffULL,
0x000000086b607824ULL, 0x000fe200078e00ffULL, 0x000000700f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000086b6e7824ULL, 0x040fe200078e00ffULL, 0x000000036b5d7819ULL, 0x000fe200000006ffULL,
0x0000010059547824ULL, 0x000fe200078e000eULL, 0x0000000c560e7812ULL, 0x000fe200078ec0ffULL,
0x000000086b6a7824ULL, 0x040fe200078e00ffULL, 0x000000026b597810ULL, 0x000fc40007ffe0ffULL,
0x000000540e567210ULL, 0x000fe40007ffe00fULL, 0x000000016b547810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0081800056587984ULL, 0x000e620000000800ULL,
0xfffffff85b5e7812ULL, 0x000fe400078ee254ULL, 0x000000036b547810ULL, 0x000fe20007ffe0ffULL,
0x00858000565c7984ULL, 0x0004e20000000800ULL, 0xfffffff85d667812ULL, 0x000fe200078ee25aULL,
0x000000086b5a7824ULL, 0x000fe200078e00ffULL, 0xfffffff85b627812ULL, 0x000fe200078ee254ULL,
0x0000080057547824ULL, 0x000fe200078e00ffULL, 0x000000086b697810ULL, 0x000fe40007ffe0ffULL,
0xfffffff860607812ULL, 0x000fe200078ee259ULL, 0x0000000400597824ULL, 0x000fe200078e00ffULL,
0x0000100054577812ULL, 0x000fe200078ec0ffULL, 0x0000000869567824ULL, 0x004fe200078e00ffULL,
0xfffffff85a547812ULL, 0x000fc400078ee26bULL, 0x0000018008577810ULL, 0x000fe40007ffe057ULL,
0x0000000c59677812ULL, 0x000fe400078ec0ffULL, 0xfffffff856567812ULL, 0x000fe200078ee269ULL,
0x0000001054547824ULL, 0x100fe200078e0257ULL, 0x000000186b6f7810ULL, 0x040fe40007ffe0ffULL,
0x000000106b6d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001056567824ULL, 0x000fe200078e0257ULL,
0x000000036f647819ULL, 0x000fe200000006ffULL, 0x0000000167547824ULL, 0x000fe200078e0254ULL,
0x000000066b5f7810ULL, 0x000fe20007ffe0ffULL, 0x000000086d5a7824ULL, 0x000fe200078e00ffULL,
0x000000056b5b7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff86e6e7812ULL, 0x000fe200078ee25fULL,
0x0000000054547984ULL, 0x000ea20000000800ULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee26dULL,
0x000000086b5f7824ULL, 0x000fe200078e00ffULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee25bULL,
0x00000010625b7824ULL, 0x100fe400078e0257ULL, 0x0000005809587221ULL, 0x002fe40000010100ULL,
0x000000105a5a7824ULL, 0x000fe400078e0257ULL, 0x3fb8aa3b58597820ULL, 0x000fc40000410000ULL,
0x0000000167587824ULL, 0x040fe200078e0256ULL, 0xfffffff864567812ULL, 0x000fe200078ee26fULL,
0x00000001675a7824ULL, 0x040fe400078e025aULL, 0x0000005900597308ULL, 0x000ee20000000800ULL,
0x0000000058637984ULL, 0x0003220000000800ULL, 0x0000001056567824ULL, 0x000fe400078e0257ULL,
0x00000001675b7824ULL, 0x040fe200078e025bULL, 0x000000005a647984ULL, 0x000fe20000000800ULL,
0x00000001675d7824ULL, 0x000fc400078e0256ULL, 0x000000105e567824ULL, 0x000fe200078e0257ULL,
0x0000005760587211ULL, 0x002fe400078e20ffULL, 0x000000005d657984ULL, 0x000e620000000800ULL,
0x0000000167567824ULL, 0x000fe200078e0256ULL, 0xffffffff6b5e7810ULL, 0x000fe20007ffe0ffULL,
0x0000005c59687220ULL, 0x008fc60000410000ULL, 0xfffffff85f607812ULL, 0x000fe200078ee25eULL,
0x0000000167597824ULL, 0x040fe200078e0258ULL, 0x000000576e5f7211ULL, 0x000fe200078e20ffULL,
0x0000000056587984ULL, 0x000fe20000000800ULL, 0x00000010665c7824ULL, 0x100fe400078e0257ULL,
0x000000106a5e7824ULL, 0x100fe200078e0257ULL, 0x00000000595a7984ULL, 0x000fe20000000800ULL,
0x0000001060617824ULL, 0x000fe200078e0257ULL, 0x20000054ff627230ULL, 0x004fe20000004100ULL,
0x0000000167607824ULL, 0x040fe200078e025fULL, 0x000000005b577984ULL, 0x000fe20000000800ULL,
0x00000001675c7824ULL, 0x000fc400078e025cULL, 0x00000001675e7824ULL, 0x040fe200078e025eULL,
0x00001f6b686b7589ULL, 0x000ea200000e0000ULL, 0x0000000167617824ULL, 0x000fe200078e0261ULL,
0x30000054ff677230ULL, 0x000fe20000004100ULL, 0x0000005368537221ULL, 0x000fe20000010000ULL,
0x00001f69686c7589ULL, 0x0002e800000e0000ULL, 0x00001f6d686d7589ULL, 0x000ee200000e0000ULL,
0x20000063ff667230ULL, 0x010fc60000004100ULL, 0x0000000060547984ULL, 0x000fe80000000800ULL,
0x00001f6f686e7589ULL, 0x0008e200000e0000ULL, 0x30000065ff697230ULL, 0x002fc60000004100ULL,
0x000000005c5d7984ULL, 0x000e680000000800ULL, 0x000000005e5f7984ULL, 0x000e620000000800ULL,
0x0000006b67507223ULL, 0x084fe20000010050ULL, 0x20000064ff687230ULL, 0x110fe20000004100ULL,
0x0000006b62517223ULL, 0x000fe20000010051ULL, 0x30000064ff677230ULL, 0x000fe20000004100ULL,
0x0000006c664f7223ULL, 0x088fe2000001004fULL, 0x30000063ff667230ULL, 0x000fe20000004100ULL,
0x0000000061627984ULL, 0x000ea20000000800ULL, 0x20000065ff647230ULL, 0x000fe20000004100ULL,
0x0000006d67307223ULL, 0x000fe20000010030ULL, 0x20000058ff657230ULL, 0x100fe20000004100ULL,
0x0004000056637984ULL, 0x000ee20000000800ULL, 0x30000058ff677230ULL, 0x000fe20000004100ULL,
0x0000006c66317223ULL, 0x000fe20000010031ULL, 0x2000005aff667230ULL, 0x100fe20000004100ULL,
0x000400005b587984ULL, 0x000f220000000800ULL, 0x0000006b652e7223ULL, 0x000fe2000001002eULL,
0x3000005aff5a7230ULL, 0x000fe20000004100ULL, 0x0000006e642f7223ULL, 0x000fe2000001002fULL,
0x000400005c657984ULL, 0x000f220000000800ULL, 0x0000006d684d7223ULL, 0x000fe2000001004dULL,
0x20000057ff687230ULL, 0x100fe20000004100ULL, 0x0000006b664b7223ULL, 0x080fe2000001004bULL,
0x0004000059647984ULL, 0x000f220000000800ULL, 0x30000057ff577230ULL, 0x000fe20000004100ULL,
0x0000006b674c7223ULL, 0x000fc4000001004cULL, 0x000400005e667984ULL, 0x000f220000000800ULL,
0x0000006b5a417223ULL, 0x080fe20000010041ULL, 0x20000054ff5a7230ULL, 0x100fe20000004100ULL,
0x0000006b57447223ULL, 0x080fe20000010044ULL, 0x30000054ff677230ULL, 0x000fe20000004100ULL,
0x0004000060577984ULL, 0x000f220000000800ULL, 0x0000006b68477223ULL, 0x080fe40000010047ULL,
0x0000006b5a3b7223ULL, 0x080fe2000001003bULL, 0x0004000061547984ULL, 0x000f220000000800ULL,
0x2000005dff6a7230ULL, 0x102fe20000004100ULL, 0x0000006b67387223ULL, 0x000fe20000010038ULL,
0x3000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00080000565a7984ULL, 0x000e620000000800ULL,
0x0000006e69467223ULL, 0x000fc40000010046ULL, 0x0000006b6a437223ULL, 0x080fe40000010043ULL,
0x0000006b5d407223ULL, 0x080fe20000010040ULL, 0x2000005fff5d7230ULL, 0x100fe40000004100ULL,
0x3000005fff5f7230ULL, 0x000fe40000004100ULL, 0x30000062ff677230ULL, 0x104fe20000004100ULL,
0x0000006b5d207223ULL, 0x080fe20000010020ULL, 0x20000062ff5d7230ULL, 0x000fe20000004100ULL,
0x0000006b5f3c7223ULL, 0x080fe2000001003cULL, 0x30000063ff687230ULL, 0x108fe20000004100ULL,
0x000c0000565f7984ULL, 0x000ea20000000800ULL, 0x20000063ff627230ULL, 0x000fe20000004100ULL,
0x0000006b5d4a7223ULL, 0x080fe2000001004aULL, 0x30000058ff637230ULL, 0x110fe20000004100ULL,
0x0000006c68497223ULL, 0x080fe20000010049ULL, 0x00080000595d7984ULL, 0x000ee20000000800ULL,
0x20000058ff687230ULL, 0x000fe20000004100ULL, 0x0000006c62337223ULL, 0x080fe20000010033ULL,
0x20000065ff587230ULL, 0x100fe20000004100ULL, 0x000800005b567984ULL, 0x000f220000000800ULL,
0x20000064ff627230ULL, 0x100fe20000004100ULL, 0x0000006b67347223ULL, 0x000fe20000010034ULL,
0x30000064ff647230ULL, 0x000fe20000004100ULL, 0x0000006c583f7223ULL, 0x080fe2000001003fULL,
0x30000066ff677230ULL, 0x100fe20000004100ULL, 0x000800005c587984ULL, 0x000f220000000800ULL,
0x0000006c621b7223ULL, 0x080fe2000001001bULL, 0x30000065ff657230ULL, 0x000fe20000004100ULL,
0x0000006c64357223ULL, 0x080fe20000010035ULL, 0x000c000059627984ULL, 0x0003220000000800ULL,
0x20000066ff647230ULL, 0x000fe20000004100ULL, 0x0000006c63267223ULL, 0x080fe20000010026ULL,
0x20000057ff667230ULL, 0x100fe20000004100ULL, 0x000c00005b637984ULL, 0x000f220000000800ULL,
0x0000006c65247223ULL, 0x080fe20000010024ULL, 0x20000054ff657230ULL, 0x100fe20000004100ULL,
0x0000006c673a7223ULL, 0x080fe2000001003aULL, 0x30000057ff597230ULL, 0x002fe20000004100ULL,
0x000c00005e5b7984ULL, 0x000fe20000000800ULL, 0x30000054ff677230ULL, 0x000fe20000004100ULL,
0x0000006c643d7223ULL, 0x000fc4000001003dULL, 0x000800005e577984ULL, 0x0003220000000800ULL,
0x0000006c59367223ULL, 0x080fe20000010036ULL, 0x2000005aff597230ULL, 0x100fe20000004100ULL,
0x0000006c66257223ULL, 0x080fe20000010025ULL, 0x0008000060547984ULL, 0x000f220000000800ULL,
0x0000006c651c7223ULL, 0x080fe4000001001cULL, 0x0000006d59167223ULL, 0x080fe20000010016ULL,
0x000c00005c647984ULL, 0x0003220000000800ULL, 0x2000005fff657230ULL, 0x104fe20000004100ULL,
0x0000006c68457223ULL, 0x000fe20000010045ULL, 0x3000005fff667230ULL, 0x000fe20000004100ULL,
0x0008000061597984ULL, 0x000ea20000000800ULL, 0x2000005dff5f7230ULL, 0x108fe20000004100ULL,
0x0000006e652c7223ULL, 0x000fe2000001002cULL, 0x3000005dff5e7230ULL, 0x002fe20000004100ULL,
0x0000006c67327223ULL, 0x000fe20000010032ULL, 0x3000005aff5c7230ULL, 0x000fe20000004100ULL,
0x0000006d5f2a7223ULL, 0x080fe2000001002aULL, 0x000c0000605a7984ULL, 0x0002e20000000800ULL,
0x20000056ff5d7230ULL, 0x110fe20000004100ULL, 0x0000006d5e377223ULL, 0x080fe20000010037ULL,
0x30000056ff567230ULL, 0x000fe20000004100ULL, 0x0000006d5c2d7223ULL, 0x000fc4000001002dULL,
0x000c0000615c7984ULL, 0x000f220000000800ULL, 0x0000006d5d3e7223ULL, 0x080fe2000001003eULL,
0x20000058ff5d7230ULL, 0x100fe20000004100ULL, 0x0000006d56297223ULL, 0x080fe20000010029ULL,
0x30000058ff587230ULL, 0x000fe20000004100ULL, 0x0000006e662b7223ULL, 0x080fe2000001002bULL,
0x20000062ff657230ULL, 0x100fe20000004100ULL, 0x0000006d5d227223ULL, 0x080fe20000010022ULL,
0x30000062ff627230ULL, 0x000fe20000004100ULL, 0x0000006d581f7223ULL, 0x080fe2000001001fULL,
0x20000063ff5e7230ULL, 0x100fe20000004100ULL, 0x0000006e65287223ULL, 0x080fe20000010028ULL,
0x30000063ff607230ULL, 0x002fe20000004100ULL, 0x0000006e62277223ULL, 0x080fe20000010027ULL,
0x20000057ff5d7230ULL, 0x100fe20000004100ULL, 0x0000006e5e217223ULL, 0x080fe20000010021ULL,
0x30000057ff567230ULL, 0x000fe20000004100ULL, 0x0000006e60237223ULL, 0x080fe20000010023ULL,
0x2000005bff577230ULL, 0x100fe20000004100ULL, 0x0000006d5d1e7223ULL, 0x080fe2000001001eULL,
0x3000005bff5b7230ULL, 0x000fe20000004100ULL, 0x0000006d561d7223ULL, 0x080fe2000001001dULL,
0x20000054ff567230ULL, 0x100fe20000004100ULL, 0x0000006e574e7223ULL, 0x080fe2000001004eULL,
0x30000054ff577230ULL, 0x000fe20000004100ULL, 0x000000ffff547224ULL, 0x000fe200078e0055ULL,
0x20000064ff5f7230ULL, 0x100fe20000004100ULL, 0x0000006d56117223ULL, 0x080fe20000010011ULL,
0x20000059ff557230ULL, 0x104fe20000004100ULL, 0x0000006e5b427223ULL, 0x080fe20000010042ULL,
0x0000030054007a0cULL, 0x000fe20003f06070ULL, 0x0000006d571a7223ULL, 0x080fe2000001001aULL,
0x30000059ff567230ULL, 0x000fe20000004100ULL, 0x0000006e5f487223ULL, 0x080fe20000010048ULL,
0x30000064ff647230ULL, 0x000fe20000004100ULL, 0x0000006d55147223ULL, 0x080fe20000010014ULL,
0x2000005aff587230ULL, 0x108fe20000004100ULL, 0x0000006d56137223ULL, 0x000fe20000010013ULL,
0x3000005aff577230ULL, 0x000fe20000004100ULL, 0x0000006e64397223ULL, 0x080fe20000010039ULL,
0x2000005cff597230ULL, 0x110fe20000004100ULL, 0x0000006e58197223ULL, 0x080fe20000010019ULL,
0x3000005cff5b7230ULL, 0x000fe20000004100ULL, 0x0000006e57527223ULL, 0x000fc40000010052ULL,
0x0000006e59127223ULL, 0x080fe40000010012ULL, 0x0000006e5b107223ULL, 0x000fe20000010010ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffed2000007947ULL, 0x000fea000383ffffULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x0000017000007945ULL, 0x000fd80003800000ULL,
0x0000008018058824ULL, 0x000fc800078e020fULL, 0x000000010e008824ULL, 0x000fe400078e0205ULL,
0x000000010f0e7824ULL, 0x000fc600078e020eULL, 0x0089805300008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x008980000e047984ULL, 0x000e680000000800ULL,
0x008a00000e057984ULL, 0x000ea20000000800ULL, 0x00000004ff047221ULL, 0x002fc80000010000ULL,
0x0000000504047221ULL, 0x004fca0000010000ULL, 0x0180000004057810ULL, 0x000fc80007ffe0ffULL,
0x7f80000005057812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0500780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000d98000067802ULL, 0x000fc40000000f00ULL, 0x0000da0000007944ULL, 0x000fea0003c00000ULL,
0x0000000000057202ULL, 0x00cfe20000000f00ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000400057308ULL, 0x000e640000001000ULL, 0xbf80000004007423ULL, 0x002fc80000000005ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000005057223ULL, 0x000fc40000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff0e7819ULL, 0x004fc40000011600ULL,
0x0000001000567811ULL, 0x040fe400078ff0ffULL, 0x0000000800547811ULL, 0x040fe200078ff0ffULL,
0x00001f0e05077589ULL, 0x000ea200000e0000ULL, 0x0000001800587811ULL, 0x000fe200078ff0ffULL,
0x000000080e577824ULL, 0x000fe200078e00ffULL, 0x00000003565b7819ULL, 0x000fe200000006ffULL,
0x00001f56050d7589ULL, 0x000ee200000e0000ULL, 0x000000080e557824ULL, 0x000fe400078e00ffULL,
0x0000000854597824ULL, 0x000fe200078e00ffULL, 0x00001f5405067589ULL, 0x000f2200000e0000ULL,
0x00000008585d7824ULL, 0x000fe200078e00ffULL, 0xfffffff85b5b7812ULL, 0x000fc400078ee256ULL,
0x00001f58050f7589ULL, 0x00026200000e0000ULL, 0xfffffff859597812ULL, 0x000fe400078ee254ULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee258ULL, 0x000000105b5b7824ULL, 0x100fe400078e0202ULL,
0x0000001059597824ULL, 0x100fe400078e0202ULL, 0x000000105d5d7824ULL, 0x000fe400078e0202ULL,
0x0000005107517220ULL, 0x004fc40000410000ULL, 0x0000005007507220ULL, 0x040fe40000410000ULL,
0x0000002e072e7220ULL, 0x040fe40000410000ULL, 0x0000004c07097220ULL, 0x040fe20000410000ULL,
0x000000515050723eULL, 0x000fe200000000ffULL, 0x0000004b074b7220ULL, 0x040fe40000410000ULL,
0x0000004107047220ULL, 0x002fe20000410000ULL, 0x0000002e0909723eULL, 0x000fe200000000ffULL,
0x0000004707477220ULL, 0x000fc40000410000ULL, 0x0000004407447220ULL, 0x040fe20000410000ULL,
0x0000004b0404723eULL, 0x000fe200000000ffULL, 0x0000004307437220ULL, 0x040fe40000410000ULL,
0x0000004007407220ULL, 0x040fe20000410000ULL, 0x000000474444723eULL, 0x000fe200000000ffULL,
0x0000002007207220ULL, 0x040fe40000410000ULL, 0x0000003c070b7220ULL, 0x040fe20000410000ULL,
0x000000434040723eULL, 0x000fe200000000ffULL, 0x0000003b073b7220ULL, 0x000fc40000410000ULL,
0x0000003807387220ULL, 0x000fe20000410000ULL, 0x000000200b0b723eULL, 0x000fe200000000ffULL,
0x0000004a074a7220ULL, 0x040fe40000410000ULL, 0x0000003407077220ULL, 0x000fe20000410000ULL,
0x000000030e347810ULL, 0x040fe20007ffe0ffULL, 0x000000080e417824ULL, 0x000fe200078e00ffULL,
0x0000003b3838723eULL, 0x000fe200000000ffULL, 0x0000004d0d4d7220ULL, 0x008fe20000410000ULL,
0x0000004a0707723eULL, 0x000fe200000000ffULL, 0x000000300d307220ULL, 0x000fe20000410000ULL,
0xfffffff841417812ULL, 0x000fe200078ee234ULL, 0x000000160d167220ULL, 0x000fc40000410000ULL,
0x0000002d0d2d7220ULL, 0x040fe20000410000ULL, 0x0000004d3030723eULL, 0x000fe200000000ffULL,
0x0000002a0d2a7220ULL, 0x040fe40000410000ULL, 0x000000370d377220ULL, 0x000fe20000410000ULL,
0x000000162d16723eULL, 0x000fe200000000ffULL, 0x0000003e0d3e7220ULL, 0x040fe40000410000ULL,
0x000000290d297220ULL, 0x000fe20000410000ULL, 0x0000002a372a723eULL, 0x000fe200000000ffULL,
0x000000220d227220ULL, 0x000fc40000410000ULL, 0x0000001f0d1f7220ULL, 0x000fe20000410000ULL,
0x0000003e2929723eULL, 0x000fe200000000ffULL, 0x0000001e0d1e7220ULL, 0x040fe40000410000ULL,
0x0000001d0d1d7220ULL, 0x000fe20000410000ULL, 0x000000221f1f723eULL, 0x000fe200000000ffULL,
0x000000110d117220ULL, 0x040fe40000410000ULL, 0x0000001a0d1a7220ULL, 0x000fe20000410000ULL,
0x0000001e1d1d723eULL, 0x000fe200000000ffULL, 0x000000140d147220ULL, 0x000fc40000410000ULL,
0x0000004f064f7220ULL, 0x010fe20000410000ULL, 0x000000111a11723eULL, 0x000fe200000000ffULL,
0x0000003106087220ULL, 0x000fe20000410000ULL, 0x000000010e317810ULL, 0x000fe20007ffe0ffULL,
0x0000003306337220ULL, 0x040fe40000410000ULL, 0x00000049060a7220ULL, 0x000fe20000410000ULL,
0x0000004f0808723eULL, 0x000fe200000000ffULL, 0x0000001b061b7220ULL, 0x040fe40000410000ULL,
0x00000035060c7220ULL, 0x000fe20000410000ULL, 0x000000330a0a723eULL, 0x000fe200000000ffULL,
0x0000004506457220ULL, 0x000fc40000410000ULL, 0x0000002606267220ULL, 0x000fe20000410000ULL,
0x0000001b0c0c723eULL, 0x000fe200000000ffULL, 0x0000003f063f7220ULL, 0x040fe40000410000ULL,
0x0000002406247220ULL, 0x000fe20000410000ULL, 0x000000452626723eULL, 0x000fe200000000ffULL,
0x0000003d063d7220ULL, 0x040fe40000410000ULL, 0x0000003a063a7220ULL, 0x000fe20000410000ULL,
0x0000003f2424723eULL, 0x000fe200000000ffULL, 0x0000002506257220ULL, 0x000fc40000410000ULL,
0x0000003606367220ULL, 0x000fe20000410000ULL, 0x0000003d3a3a723eULL, 0x000fe200000000ffULL,
0x0000001c061c7220ULL, 0x040fe40000410000ULL, 0x0000003206057220ULL, 0x000fe20000410000ULL,
0x000000020e327810ULL, 0x000fe20007ffe0ffULL, 0x000000130d0d7220ULL, 0x000fe20000410000ULL,
0x000000253625723eULL, 0x000fe200000000ffULL, 0x0000002f0f2f7220ULL, 0x000fe20000410000ULL,
0x0000001c0505723eULL, 0x000fe200000000ffULL, 0x000000460f467220ULL, 0x000fe20000410000ULL,
0x000000140d0d723eULL, 0x000fe200000000ffULL, 0x0000002c0f2c7220ULL, 0x000fc40000410000ULL,
0x0000002b0f2b7220ULL, 0x040fe20000410000ULL, 0x0000002f462f723eULL, 0x000fe200000000ffULL,
0x000000280f287220ULL, 0x040fe40000410000ULL, 0x000000270f277220ULL, 0x000fe20000410000ULL,
0x0000002c2b2b723eULL, 0x000fe200000000ffULL, 0x000000210f217220ULL, 0x040fe40000410000ULL,
0x000000230f067220ULL, 0x040fe20000410000ULL, 0x000000050e237810ULL, 0x000fe20007ffe0ffULL,
0x000000480f487220ULL, 0x000fe20000410000ULL, 0x000000282727723eULL, 0x000fe200000000ffULL,
0x000000390f397220ULL, 0x040fe20000410000ULL, 0x000000210606723eULL, 0x000fe200000000ffULL,
0x0000004e0f4e7220ULL, 0x000fc40000410000ULL, 0x000000420f137220ULL, 0x000fe20000410000ULL,
0x000000483939723eULL, 0x000fe200000000ffULL, 0x000000190f197220ULL, 0x040fe40000410000ULL,
0x000000520f527220ULL, 0x000fe20000410000ULL, 0x0000004e1313723eULL, 0x000fe200000000ffULL,
0x000000120f127220ULL, 0x040fe40000410000ULL, 0x000000080e357824ULL, 0x000fe200078e00ffULL,
0x000000195219723eULL, 0x000fe200000000ffULL, 0x000000100f0f7220ULL, 0x000fe20000410000ULL,
0x000000040e107810ULL, 0x040fe20007ffe0ffULL, 0x000000080e497824ULL, 0x040fe200078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee232ULL, 0x000000080e347824ULL, 0x040fe200078e00ffULL,
0x000000060e327810ULL, 0x040fe20007ffe0ffULL, 0x000000080e3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee210ULL, 0x0000001035357824ULL, 0x100fe200078e0202ULL,
0xfffffff834537812ULL, 0x000fe200078ee223ULL, 0x0000001041417824ULL, 0x100fe200078e0202ULL,
0xffffffff0e107810ULL, 0x000fe20007ffe0ffULL, 0x0000001049497824ULL, 0x000fe200078e0202ULL,
0xfffffff857237812ULL, 0x000fe200078ee20eULL, 0x00000004000e7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c317812ULL, 0x000fe200078ee231ULL, 0x0000001053537824ULL, 0x000fe200078e0202ULL,
0xfffffff855557812ULL, 0x000fe200078ee232ULL, 0x0000001023237824ULL, 0x100fe200078e0202ULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x0000001031317824ULL, 0x000fe200078e0202ULL,
0xfffffff857577812ULL, 0x000fc400078ee210ULL, 0x0000000255557211ULL, 0x000fe200078e20ffULL,
0x0000000123237824ULL, 0x000fe200078e020eULL, 0x000000490e497210ULL, 0x040fe20007ffe0ffULL,
0x000000010e317824ULL, 0x040fe200078e0231ULL, 0x000000120f0f723eULL, 0x000fe200000000ffULL,
0x000000010e357824ULL, 0x040fe200078e0235ULL, 0x0000005023007388ULL, 0x000fe20000000800ULL,
0x0000001057577824ULL, 0x000fe400078e0202ULL, 0x000000010e417824ULL, 0x040fe200078e0241ULL,
0x0000000931007388ULL, 0x000fe20000000800ULL, 0x000000010e027824ULL, 0x000fc400078e0253ULL,
0x000000010e147824ULL, 0x040fe200078e0255ULL, 0x0000000435007388ULL, 0x0003e20000000800ULL,
0x000000010e1a7824ULL, 0x040fe400078e0257ULL, 0x000000010e597824ULL, 0x040fe200078e0259ULL,
0x0000004441007388ULL, 0x000fe20000000800ULL, 0x000000010e5b7824ULL, 0x040fe400078e025bULL,
0x000000010e0e7824ULL, 0x000fe200078e025dULL, 0x0000004049007388ULL, 0x000fe20000000800ULL,
0x0000000117047824ULL, 0x002fc600078e0200ULL, 0x0000000b02007388ULL, 0x000fe80000000800ULL,
0x0000003814007388ULL, 0x000fe80000000800ULL, 0x000000071a007388ULL, 0x000fe80000000800ULL,
0x0000000859007388ULL, 0x000fe80000000800ULL, 0x0004000a31007388ULL, 0x000fe80000000800ULL,
0x0004000c35007388ULL, 0x0003e80000000800ULL, 0x0004002641007388ULL, 0x000fe80000000800ULL,
0x0004002449007388ULL, 0x000fe20000000800ULL, 0x00000010040c7824ULL, 0x002fc600078e0203ULL,
0x0004003a02007388ULL, 0x000fe80000000800ULL, 0x0004002514007388ULL, 0x000fe80000000800ULL,
0x000400051a007388ULL, 0x000fe80000000800ULL, 0x000000305b007388ULL, 0x000fe80000000800ULL,
0x0008001631007388ULL, 0x000fe80000000800ULL, 0x0008002a35007388ULL, 0x000fe80000000800ULL,
0x0008002941007388ULL, 0x000fe80000000800ULL, 0x0008001f49007388ULL, 0x000fe80000000800ULL,
0x0008001d02007388ULL, 0x000fe80000000800ULL, 0x0008001114007388ULL, 0x000fe80000000800ULL,
0x0008000d1a007388ULL, 0x000fe80000000800ULL, 0x0000002f0e007388ULL, 0x000fe80000000800ULL,
0x000c002b31007388ULL, 0x000fe80000000800ULL, 0x000c002735007388ULL, 0x000fe80000000800ULL,
0x000c000641007388ULL, 0x000fe80000000800ULL, 0x000c003949007388ULL, 0x000fe80000000800ULL,
0x000c001302007388ULL, 0x000fe80000000800ULL, 0x000c001914007388ULL, 0x000fe80000000800ULL,
0x000c000f1a007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000c087984ULL, 0x000e680000000c00ULL, 0x000400000c207984ULL, 0x000ea80000000c00ULL,
0x000800000c047984ULL, 0x000ee80000000c00ULL, 0x000c00000c107984ULL, 0x000f280000000c00ULL,
0x001000000c1c7984ULL, 0x000ee80000000c00ULL, 0x001400000c247984ULL, 0x000f280000000c00ULL,
0x001800000c287984ULL, 0x000f280000000c00ULL, 0x001c00000c2c7984ULL, 0x000f220000000c00ULL,
0x200000ff0b0b7230ULL, 0x002fc40000000000ULL, 0x200000ff0a0a7230ULL, 0x000fe40000000000ULL,
0x200000ff09097230ULL, 0x000fe40000000000ULL, 0x200000ff08087230ULL, 0x000fe40000000000ULL,
0x200000ff23237230ULL, 0x004fe40000000000ULL, 0x200000ff22227230ULL, 0x000fe40000000000ULL,
0x200000ff21217230ULL, 0x000fc40000000000ULL, 0x200000ff20207230ULL, 0x000fe40000000000ULL,
0x200000ff07077230ULL, 0x008fe40000000000ULL, 0x200000ff06067230ULL, 0x000fe40000000000ULL,
0x200000ff05057230ULL, 0x000fe40000000000ULL, 0x200000ff04047230ULL, 0x000fe40000000000ULL,
0x200000ff13137230ULL, 0x010fc40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fe40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x0000001f0b0b7230ULL, 0x000fe40000000000ULL, 0x0000001e0a0a7230ULL, 0x000fe40000000000ULL,
0x0000001d09097230ULL, 0x000fc40000000000ULL, 0x0000001c08087230ULL, 0x000fe40000000000ULL,
0x0000002723237230ULL, 0x000fe40000000000ULL, 0x0000002622227230ULL, 0x000fe20000000000ULL,
0x000000080c007388ULL, 0x000fe20000000c00ULL, 0x0000002521217230ULL, 0x000fe40000000000ULL,
0x0000002420207230ULL, 0x000fe40000000000ULL, 0x0000002b07077230ULL, 0x000fc40000000000ULL,
0x0000002a06067230ULL, 0x000fe20000000000ULL, 0x000400200c007388ULL, 0x000fe20000000c00ULL,
0x0000002905057230ULL, 0x000fe40000000000ULL, 0x0000002804047230ULL, 0x000fe40000000000ULL,
0x0000002f13137230ULL, 0x000fe40000000000ULL, 0x0000002e12127230ULL, 0x000fe20000000000ULL,
0x000800040c007388ULL, 0x000fe20000000c00ULL, 0x0000002d11117230ULL, 0x000fc40000000000ULL,
0x0000002c10107230ULL, 0x000fca0000000000ULL, 0x000c00100c007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff1800720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff077819ULL, 0x000fc80000011600ULL,
0x000000830700720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000067b06ULL, 0x000ee20000209000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00005a00ff0e7a12ULL, 0x002fe200078e33ffULL, 0x000000019c027824ULL, 0x000fe200078e0207ULL,
0x00000020000f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000107077824ULL, 0x000fe200078e0200ULL,
0x00000007000c7812ULL, 0x000fc800078ec0ffULL, 0x0000000707077812ULL, 0x000fe200078ec0ffULL,
0x0000000600067308ULL, 0x008e640000001000ULL, 0x0ffffffe06087810ULL, 0x006fe40007ffe0ffULL,
0x0ffffff807067812ULL, 0x000fc800078ef800ULL, 0x0000000800057305ULL, 0x000e62000021f000ULL,
0x0000001006067824ULL, 0x000fe200078e0203ULL, 0x80000005ff097210ULL, 0x002fca0007ffe0ffULL,
0x00005a0009097a24ULL, 0x000fc800078e02ffULL, 0x00000009050d7227ULL, 0x000fe400078e0004ULL,
0x0000000006087984ULL, 0x000e680000000c00ULL, 0x000000020d047227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104040810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x00005a00ff007a0cULL, 0x000fd60003f05070ULL, 0x0000000104041810ULL, 0x000fc80007ffe0ffULL,
0x000000040e047207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a04ULL,
0x0000590004057a24ULL, 0x000fe400078e0281ULL, 0x00005a0007027a24ULL, 0x000fe400078e0202ULL,
0x0000000815077824ULL, 0x000fe400078e020cULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x0000000584057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff027224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f4402ULL,
0x00000003ff027819ULL, 0x000fc6000001160fULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000830200720cULL, 0x000fc80003f26070ULL, 0x0000000804007986ULL, 0x0023f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000029c047210ULL, 0x002fe20007ffe0ffULL,
0x000000010f027824ULL, 0x000fe200078e0202ULL, 0x0000004000117810ULL, 0x000fc60007ffe0ffULL,
0x000000040d057227ULL, 0x000fe200078e00ffULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x000000ffff077224ULL, 0x000fe200078e0a05ULL, 0x0ffffff802027812ULL, 0x000fc600078ef80fULL,
0x00005a0007067a24ULL, 0x000fe400078e0204ULL, 0x0000001002027824ULL, 0x000fc600078e0203ULL,
0x00005a0006007a0cULL, 0x000fe40003f26070ULL, 0x0000000002087984ULL, 0x0002a40000000c00ULL,
0x00000003ff027819ULL, 0x002fd20000011611ULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fda0003f46070ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x000000050e067207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a06ULL, 0x0000590006057a24ULL, 0x000fe200078e0281ULL,
0x000000070f067812ULL, 0x000fe200078ec0ffULL, 0x00005a0007047a24ULL, 0x000fc800078e0204ULL,
0x00005a0005057a24ULL, 0x000fe400078e0204ULL, 0x0000000815077824ULL, 0x000fc600078e0206ULL,
0x0000000584057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f440cULL,
0x000000830200720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019c047824ULL, 0x002fe200078e0202ULL, 0x0000000211027210ULL, 0x000fe40007ffe0ffULL,
0x00000060000f7810ULL, 0x000fe20007ffe0ffULL, 0x000000040d057227ULL, 0x000fe200078e00ffULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x000000ffff077224ULL, 0x000fe200078e0a05ULL,
0x0ffffff802027812ULL, 0x000fc600078ef811ULL, 0x00005a0007067a24ULL, 0x000fe400078e0204ULL,
0x0000001002027824ULL, 0x000fc600078e0203ULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x0000000002087984ULL, 0x0002a40000000c00ULL, 0x00000003ff027819ULL, 0x002fd2000001160fULL,
0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fda0003f46070ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x000000050e067207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a06ULL,
0x0000590006057a24ULL, 0x000fe200078e0281ULL, 0x0000000711067812ULL, 0x000fe200078ec0ffULL,
0x00005a0007047a24ULL, 0x000fc800078e0204ULL, 0x00005a0005057a24ULL, 0x000fe400078e0204ULL,
0x0000000815077824ULL, 0x000fc600078e0206ULL, 0x0000000584057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f440cULL, 0x000000830200720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000019c047824ULL, 0x102fe200078e0202ULL,
0x0000008000117810ULL, 0x000fe20007ffe0ffULL, 0x000000010f027824ULL, 0x000fe400078e0202ULL,
0x000000040d057227ULL, 0x000fc600078e00ffULL, 0x0000000702027812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff802027812ULL, 0x000fe200078ef80fULL,
0x00005a0007067a24ULL, 0x000fc800078e0204ULL, 0x0000001002027824ULL, 0x000fe200078e0203ULL,
0x00005a0006007a0cULL, 0x000fc80003f26070ULL, 0x0000000002087984ULL, 0x0002a40000000c00ULL,
0x00000003ff027819ULL, 0x002fce0000011611ULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fda0003f46070ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x000000050e067207ULL, 0x000fc80004000000ULL,
0x000000ff06077210ULL, 0x040fe20007ffe1ffULL, 0x0000590006057a24ULL, 0x000fe200078e0281ULL,
0x000000070f067812ULL, 0x000fc600078ec0ffULL, 0x00005a0007047a24ULL, 0x000fe400078e0204ULL,
0x0000000815077824ULL, 0x000fe400078e0206ULL, 0x00005a0005057a24ULL, 0x000fca00078e0204ULL,
0x0000000584057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f440cULL,
0x000000830200720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019c047824ULL, 0x102fe200078e0202ULL, 0x000000a0000f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111027824ULL, 0x000fe400078e0202ULL, 0x000000040d057227ULL, 0x000fc600078e00ffULL,
0x0000000702027812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc600078e0a05ULL,
0x0ffffff802027812ULL, 0x000fe200078ef811ULL, 0x00005a0007067a24ULL, 0x000fc800078e0204ULL,
0x0000001002027824ULL, 0x000fe200078e0203ULL, 0x00005a0006007a0cULL, 0x000fc80003f26070ULL,
0x0000000002087984ULL, 0x0002a40000000c00ULL, 0x00000003ff027819ULL, 0x002fce000001160fULL,
0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fda0003f46070ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x000000050e067207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a06ULL,
0x0000590006057a24ULL, 0x000fe200078e0281ULL, 0x0000000711067812ULL, 0x000fe200078ec0ffULL,
0x00005a0007047a24ULL, 0x000fc600078e0204ULL, 0x0000000615077211ULL, 0x000fe200078e18ffULL,
0x00005a0005057a24ULL, 0x000fca00078e0204ULL, 0x0000000584057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f440cULL, 0x000000830200720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000019c047824ULL, 0x102fe200078e0202ULL,
0x000000c000117810ULL, 0x000fe20007ffe0ffULL, 0x000000010f027824ULL, 0x000fe400078e0202ULL,
0x000000040d057227ULL, 0x000fc600078e00ffULL, 0x0000000702027812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff802027812ULL, 0x000fe200078ef80fULL,
0x00005a0007067a24ULL, 0x000fc800078e0204ULL, 0x0000001002027824ULL, 0x000fe200078e0203ULL,
0x00005a0006007a0cULL, 0x000fc80003f26070ULL, 0x0000000002087984ULL, 0x0002a40000000c00ULL,
0x00000003ff027819ULL, 0x002fce0000011611ULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fda0003f46070ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x000000050e067207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a06ULL, 0x0000590006057a24ULL, 0x000fe200078e0281ULL,
0x000000070f067812ULL, 0x000fe200078ec0ffULL, 0x00005a0007047a24ULL, 0x000fc800078e0204ULL,
0x00005a0005057a24ULL, 0x000fe400078e0204ULL, 0x0000000815077824ULL, 0x000fc600078e0206ULL,
0x0000000584057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f440cULL,
0x000000830200720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019c047824ULL, 0x102fe200078e0202ULL, 0x000000e0000f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111027824ULL, 0x040fe200078e0202ULL, 0x0000000711007812ULL, 0x000fe200078ec0ffULL,
0x000000040d057227ULL, 0x000fc600078e00ffULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x000000ff05077210ULL, 0x000fe40007ffe1ffULL, 0x0ffffff802027812ULL, 0x000fc600078ef811ULL,
0x00005a0007067a24ULL, 0x000fe400078e0204ULL, 0x0000001002027824ULL, 0x000fc600078e0203ULL,
0x00005a0006007a0cULL, 0x000fe40003f26070ULL, 0x0000000002087984ULL, 0x0002a40000000c00ULL,
0x00000003ff027819ULL, 0x002fd2000001160fULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe20007ffe0ffULL, 0x000000019c9c7824ULL, 0x000fe200078e0202ULL,
0x00005a0006007a0cULL, 0x000fda0003f46070ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x000000050e067207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a06ULL,
0x0000590006057a24ULL, 0x000fe400078e0281ULL, 0x00005a0007047a24ULL, 0x000fe400078e0204ULL,
0x0000000815077824ULL, 0x000fe400078e0200ULL, 0x00005a0005057a24ULL, 0x000fca00078e0204ULL,
0x0000000584057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f4406ULL,
0x000000830200720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000009c0d007227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x002fe400078e0a00ULL,
0x000000010f027824ULL, 0x000fe400078e0202ULL, 0x00005a0005047a24ULL, 0x000fc600078e029cULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f26070ULL,
0xfffffff802027812ULL, 0x000fd600078ef80fULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000100001810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0000000302047211ULL, 0x000fcc00078e20ffULL, 0x0000000004047984ULL, 0x000e6a0000000c00ULL,
0x0000000100002810ULL, 0x000fc80007ffe0ffULL, 0x000000000e007207ULL, 0x000fca0004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a00ULL, 0x0000590000037a24ULL, 0x000fe200078e0281ULL,
0x000000070f007812ULL, 0x000fe200078ec0ffULL, 0x00005a00099c7a24ULL, 0x000fc800078e029cULL,
0x00005a0003037a24ULL, 0x000fe400078e029cULL, 0x0000000815157824ULL, 0x000fc600078e0200ULL,
0x0000000384037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078040ffULL, 0x00005f0003037a11ULL, 0x000fca00000f4408ULL,
0x0000001015027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff047819ULL, 0x000fe2000001169dULL,
0xffffffffff207424ULL, 0x000fc800078e00ffULL, 0x0000000299217824ULL, 0x000fca00078e0204ULL,
0x000000232100720cULL, 0x000fda0003f06070ULL, 0x00000002a5048824ULL, 0x000fc800078e00ffULL,
0x00006a0004078a24ULL, 0x002fc800078e0221ULL, 0x0000660007068625ULL, 0x000fe200078e009aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000606208981ULL, 0x000ea2000c1e1900ULL,
0x0000000199097810ULL, 0x000fe20007ffe0ffULL, 0x00005800ff1d7624ULL, 0x000fe200078e00ffULL,
0x000000069da37819ULL, 0x000fe200000006ffULL, 0x00000080a2a27824ULL, 0x000fe200078e00ffULL,
0x000000220900720cULL, 0x000fe20003f06070ULL, 0x00000080811f7824ULL, 0x000fe200078e00ffULL,
0x0000001f1d1d7810ULL, 0x000fe20007ffe0ffULL, 0x00000100990b7824ULL, 0x000fe200078e02a3ULL,
0x01e60000ff047f8cULL, 0x000e62000c80043fULL, 0x00000100ff0d7424ULL, 0x000fe200078e00ffULL,
0x00000005ff1d7819ULL, 0x000fc4000001161dULL, 0x000000401f097812ULL, 0x000fe200078ef80bULL,
0x000000a220067224ULL, 0x004fc800078e02ffULL, 0x0000640006067625ULL, 0x000fe200078e000dULL,
0x00000c7000008947ULL, 0x000fea0003800000ULL, 0x00000003ff397819ULL, 0x102fe40000011600ULL,
0x0000000b98087217ULL, 0x000fe40007800000ULL, 0x00000004390d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001090a7824ULL, 0x000fe200078e0239ULL, 0x0000001039137810ULL, 0x040fe20007ffe0ffULL,
0x0000000108087824ULL, 0x000fe200078e0a0bULL, 0x00000008390f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010d0b7824ULL, 0x000fe200078e0200ULL, 0x0000000c39117810ULL, 0x000fe20007ffe0ffULL,
0x000000080d107824ULL, 0x040fe200078e00ffULL, 0x000000080d00720cULL, 0x000fe20003fa6070ULL,
0x00000008133b7824ULL, 0x000fe200078e00ffULL, 0x000000030f357819ULL, 0x000fe200000006ffULL,
0x00000001090c7824ULL, 0x000fe200078e020dULL, 0xfffffff8102b7812ULL, 0x000fe200078ee20bULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000001839337810ULL, 0x000fc40007ffe0ffULL,
0x0000001439277810ULL, 0x040fe20007ffe0ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x000000700a157812ULL, 0x100fe400078ef803ULL, 0x0000001c39417810ULL, 0x000fe20007ffe0ffULL,
0x00000001130a7824ULL, 0x100fe200078e0200ULL, 0x0000001506147210ULL, 0x000fe20007f1e0ffULL,
0x000000010f0e7824ULL, 0x000fe200078e0200ULL, 0x000000700c177812ULL, 0x000fe200078ef803ULL,
0x0000000811377824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee20aULL,
0x00000001090a7824ULL, 0x000fe200078e020fULL, 0xfffffff835357812ULL, 0x000fe200078ee20eULL,
0x0000000107157824ULL, 0x000fe200000e060bULL, 0x0000001706167210ULL, 0x000fe20007f3e0ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x00000011090c7210ULL, 0x000fc40007ffe0ffULL,
0x000000081300720cULL, 0x080fe20003f06070ULL, 0x00000001110e7824ULL, 0x000fe200078e0200ULL,
0x000000700a197812ULL, 0x000fe200078ef803ULL, 0x0000000109127824ULL, 0x000fe200078e0233ULL,
0x000000081100720cULL, 0x080fe20003f46070ULL, 0x0000000107177824ULL, 0x000fe200008e060dULL,
0xfffffff837377812ULL, 0x000fe200078ee20eULL, 0x00000001090e7824ULL, 0x000fe200078e0213ULL,
0x0000001906187210ULL, 0x000fe20007f7e0ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x000000080f00720cULL, 0x000fc40003f26070ULL, 0x00000020392d7810ULL, 0x040fe20007ffe0ffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x000000700c1b7812ULL, 0x000fe400078ef803ULL,
0x00000024392f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107197824ULL, 0x000fe200018e060bULL,
0x00000070120b7812ULL, 0x000fe200078ef803ULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001b061a7210ULL, 0x040fe40007f9e0ffULL, 0x0000000b06127210ULL, 0x000fe20007fde0ffULL,
0x0000000109107824ULL, 0x040fe200078e0227ULL, 0x000000700e257812ULL, 0x000fe200078ef803ULL,
0x00000001090a7824ULL, 0x000fe200078e0241ULL, 0x0000001307137210ULL, 0x000fe200037fe4ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x00000025060e7210ULL, 0x000fc40007f7e0ffULL,
0x000020009d1c7811ULL, 0x000fe200078e70ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002839317810ULL, 0x000fe40007ffe0ffULL, 0x00000003333f7819ULL, 0x000fe200000006ffULL,
0x00000001071b7824ULL, 0x000fe200020e060dULL, 0x00000070100d7812ULL, 0x100fe200078ef803ULL,
0x00000001390c7824ULL, 0x100fe200078e0200ULL, 0x000000700a257812ULL, 0x000fe200078ef803ULL,
0x00000001090a7824ULL, 0x000fe200078e022dULL, 0x0000000d06107210ULL, 0x040fe20007f9e0ffULL,
0x00000008273d7824ULL, 0x000fe200078e00ffULL, 0x0000002506247210ULL, 0x000fe20007fde0ffULL,
0x00000001070f7824ULL, 0x040fe200018e060fULL, 0x000000070c0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000107117824ULL, 0x000fe200020e0611ULL, 0x000000083900720cULL, 0x080fe20003f86070ULL,
0x00000001270c7824ULL, 0x100fe200078e0200ULL, 0x0ffffff80d0d7812ULL, 0x000fe200078ef800ULL,
0x0000000107257824ULL, 0x000fe200030e060bULL, 0x000000082700720cULL, 0x000fe20003f66070ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff83d3d7812ULL, 0x000fc600078ee20cULL,
0x00000001090c7824ULL, 0x000fe200078e022fULL, 0x000000700a277812ULL, 0x000fe200078ef803ULL,
0x000000100d297824ULL, 0x000fe400078e021cULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000002706267210ULL, 0x000fe40007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014297faeULL, 0x0003e2000e101c46ULL, 0x00000001090a7824ULL, 0x000fe200078e0231ULL,
0x000000083300720cULL, 0x000fe20003f86070ULL, 0x0000000107277824ULL, 0x000fc400030e060bULL,
0x000001000a0a7825ULL, 0x000fc800078e00ffULL, 0x00000001331e7824ULL, 0x000fe200078e0200ULL,
0x0000002c39337810ULL, 0x000fe40007ffe0ffULL, 0x000000700c157812ULL, 0x102fe200078ef803ULL,
0x000000102b297824ULL, 0x000fe200078e021cULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee21eULL,
0x00000001411e7824ULL, 0x000fe200078e0200ULL, 0x00000015060c7210ULL, 0x000fe20007fde0ffULL,
0x00000010352b7824ULL, 0x000fe200078e021cULL, 0x000000700a157812ULL, 0x000fe200078ef803ULL,
0x0000000016297faeULL, 0x0003e2000e901c46ULL, 0x00000001090a7824ULL, 0x000fe200078e0233ULL,
0x000000084100720cULL, 0x080fe20003fa6070ULL, 0x00000001070d7824ULL, 0x000fe200030e060dULL,
0x0000001506147210ULL, 0x000fe20007fde0ffULL, 0x0000000841417824ULL, 0x000fe200078e00ffULL,
0x00000000182b7faeULL, 0x0005e2000c901c46ULL, 0x000000082d00720cULL, 0x000fc40003f26070ULL,
0x0000000b07157210ULL, 0x000fe200037fe4ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fe400078ee21eULL, 0x0000003439357810ULL, 0x000fe20007ffe0ffULL,
0x0000001037297824ULL, 0x002fe200078e021cULL, 0x0000003839377810ULL, 0x000fe20007ffe0ffULL,
0x000000012d177824ULL, 0x140fe400078e0200ULL, 0x000000082d1e7824ULL, 0x000fe200078e00ffULL,
0x000000001a297faeULL, 0x0003e2000d101c46ULL, 0x000000700a2d7812ULL, 0x000fe200078ef803ULL,
0x000000012f0a7824ULL, 0x040fe200078e0200ULL, 0x000000082f00720cULL, 0x040fe20003f46070ULL,
0x000000082f2f7824ULL, 0x000fe200078e00ffULL, 0x0000002d06167210ULL, 0x000fe20007fde0ffULL,
0x000000103b197824ULL, 0x004fe200078e021cULL, 0xfffffff81e2b7812ULL, 0x000fc400078ee217ULL,
0xfffffff82f2d7812ULL, 0x000fe200078ee20aULL, 0x0000000107177824ULL, 0x000fe200030e060bULL,
0x00000030392f7810ULL, 0x000fe20007ffe0ffULL, 0x000000103d0b7824ULL, 0x100fe200078e021cULL,
0x0000001c3f1b7211ULL, 0x002fe200078e20ffULL, 0x0000001041297824ULL, 0x100fe200078e021cULL,
0x000000000e197faeULL, 0x0003e2000c101c46ULL, 0x00000001090a7824ULL, 0x000fe200078e022fULL,
0x0000003c39397810ULL, 0x000fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x100fe200078e021cULL,
0x00000000100b7faeULL, 0x0005e2000d901c46ULL, 0x000000102d2d7824ULL, 0x000fe200078e021cULL,
0x000000082f00720cULL, 0x000fc40003f66070ULL, 0x00000000121b7faeULL, 0x0007e2000e101c46ULL,
0x000000083300720cULL, 0x080fe40003f86070ULL, 0x000000083900720cULL, 0x080fe20003f06070ULL,
0x0000000024297faeULL, 0x0009e2000e901c46ULL, 0x00000001310f7824ULL, 0x042fe200078e0200ULL,
0x000000083100720cULL, 0x080fe20003fa6070ULL, 0x000000082f197824ULL, 0x000fe200078e00ffULL,
0x00000000262b7faeULL, 0x0003e2000c901c46ULL, 0x000001000a0a7825ULL, 0x004fe200078e00ffULL,
0x000000083700720cULL, 0x000fc40003f26070ULL, 0x000000000c2d7faeULL, 0x0005e2000d101c46ULL,
0x0000000109107824ULL, 0x000fe200078e0235ULL, 0x000000083500720cULL, 0x000fe20003f46070ULL,
0x0000000831127824ULL, 0x008fe200078e00ffULL, 0x0000000033087210ULL, 0x040fe20007ffe0ffULL,
0x0000000833137824ULL, 0x000fe400078e00ffULL, 0x0000000837257824ULL, 0x010fe200078e00ffULL,
0xfffffff812117812ULL, 0x000fe200078ee20fULL, 0x0000000839277824ULL, 0x002fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fc400078ee208ULL, 0x000000700a0d7812ULL, 0x004fe200078ef803ULL,
0x000000012f0a7824ULL, 0x000fe200078e0200ULL, 0x0000000037127210ULL, 0x000fe20007ffe0ffULL,
0x0000001011117824ULL, 0x000fe200078e021cULL, 0x0000000d060e7210ULL, 0x000fe20007fde0ffULL,
0x00000100100c7825ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe400078ee20aULL,
0xfffffff825257812ULL, 0x000fe200078ee212ULL, 0x00000001070f7824ULL, 0x000fe200030e060bULL,
0x000000700c0b7812ULL, 0x000fe200078ef803ULL, 0x0000000135107824ULL, 0x000fe200078e0200ULL,
0x0000001c25257211ULL, 0x000fe200078e20ffULL, 0x0000000835357824ULL, 0x000fe200078e00ffULL,
0x0000000b060c7210ULL, 0x000fe20007fde0ffULL, 0x00000001090b7824ULL, 0x040fe200078e0237ULL,
0x0000000014117faeULL, 0x0003e2000e901c46ULL, 0x0000000109097824ULL, 0x000fc400078e0239ULL,
0x000001000b0a7825ULL, 0x000fc800078e00ffULL, 0x0000010009087825ULL, 0x000fe200078e00ffULL,
0x000000700a1b7812ULL, 0x000fc600078ef803ULL, 0x00000001070d7824ULL, 0x000fe200030e060dULL,
0x0000001b060a7210ULL, 0x000fe20007fde0ffULL, 0x0000000139007824ULL, 0x000fe200078e0200ULL,
0x0000007008037812ULL, 0x000fe200078ef803ULL, 0x0000001013137824ULL, 0x000fe200078e021cULL,
0xfffffff8351b7812ULL, 0x000fe200078ee210ULL, 0x00000001070b7824ULL, 0x000fe200030e060bULL,
0xfffffff827277812ULL, 0x000fe200078ee200ULL, 0x0000001019197824ULL, 0x100fe200078e021cULL,
0x0000000306067210ULL, 0x000fe20007fde0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e021cULL,
0x0000000016137faeULL, 0x0003e2000e101c46ULL, 0x0000001027277824ULL, 0x000fc400078e021cULL,
0x0000000107077824ULL, 0x000fe200030e0609ULL, 0x000000000e197faeULL, 0x0003e8000d901c46ULL,
0x000000000c1b7faeULL, 0x0003e8000d101c46ULL, 0x000000000a257faeULL, 0x0003e8000c901c46ULL,
0x0000000006277faeULL, 0x0003e2000c101c46ULL, 0x00000b3000007947ULL, 0x000fea0003800000ULL,
0x0000000c00117811ULL, 0x042fe400078fe8ffULL, 0x0000000800107811ULL, 0x000fc400078fe8ffULL,
0x00000004000f7811ULL, 0x040fe200078fe8ffULL, 0x00000001110b7824ULL, 0x140fe200078e0200ULL,
0x0000001800247811ULL, 0x040fe200078fe8ffULL, 0x00000008110c7824ULL, 0x000fe200078e00ffULL,
0x00000014001e7811ULL, 0x000fe200078fe8ffULL, 0x00000001100a7824ULL, 0x100fe200078e0200ULL,
0x0000001c00267811ULL, 0x000fe200078fe8ffULL, 0x0000000810357824ULL, 0x000fe200078e00ffULL,
0xfffffff80c377812ULL, 0x000fe200078ee20bULL, 0x000000010f087824ULL, 0x040fe200078e0200ULL,
0x00000010001c7811ULL, 0x000fe200078fe8ffULL, 0x000000080f337824ULL, 0x000fe200078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee20aULL, 0x00000001240b7824ULL, 0x100fe200078e0200ULL,
0x00000024000d7811ULL, 0x000fe200078fe8ffULL, 0x00000008240e7824ULL, 0x000fe200078e00ffULL,
0x0000002800127811ULL, 0x000fe200078fe8ffULL, 0x000000011e0a7824ULL, 0x040fe200078e0200ULL,
0xfffffff833337812ULL, 0x000fe200078ee208ULL, 0x000000081e3b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e3d7812ULL, 0x000fe200078ee20bULL, 0x00000001260c7824ULL, 0x000fe200078e0200ULL,
0x0000002c00167811ULL, 0x000fe200078fe8ffULL, 0x00000008263f7824ULL, 0x000fe200078e00ffULL,
0x000000001c087210ULL, 0x0c0fe20007ffe0ffULL, 0x000000081c397824ULL, 0x000fe200078e00ffULL,
0x00000020000b7811ULL, 0x000fe200078fe8ffULL, 0x000000080d157824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee20aULL, 0x000000010d0a7824ULL, 0x000fe200078e0200ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee20cULL, 0x00000001120c7824ULL, 0x040fe200078e0200ULL,
0xfffffff839397812ULL, 0x000fe200078ee208ULL, 0x0000000812177824ULL, 0x000fe200078e00ffULL,
0x000000030b137819ULL, 0x000fe200000006ffULL, 0x00000001160e7824ULL, 0x040fe200078e0200ULL,
0xfffffff815147812ULL, 0x000fe200078ee20aULL, 0x0000000816197824ULL, 0x000fe200078e00ffULL,
0xfffffff817157812ULL, 0x000fe200078ee20cULL, 0x000000010b087824ULL, 0x000fe200078e0200ULL,
0x00000000000a7211ULL, 0x000fe200078fe8ffULL, 0x00000001100c7824ULL, 0x100fe200078e0209ULL,
0xfffffff819177812ULL, 0x000fe200078ee20eULL, 0x000000011e107824ULL, 0x000fe200078e0209ULL,
0xfffffff813137812ULL, 0x000fe200078ee208ULL, 0x00000001091e7824ULL, 0x040fe200078e020bULL,
0x0000003400197811ULL, 0x040fe200078fe8ffULL, 0x0000000109287824ULL, 0x040fe200078e020dULL,
0x00000038001a7811ULL, 0x040fe200078fe8ffULL, 0x0000000109297824ULL, 0x040fe200078e0212ULL,
0x0000000900087211ULL, 0x0c0fe200078fe8ffULL, 0x00000001092a7824ULL, 0x040fe200078e0216ULL,
0x0000003000187811ULL, 0x040fe200078fe8ffULL, 0x0000000109327824ULL, 0x040fe200078e0219ULL,
0x0000003c001b7811ULL, 0x000fe200078fe8ffULL, 0x0000000109347824ULL, 0x000fe200078e021aULL,
0x000000070a257812ULL, 0x000fe200078ec0ffULL, 0x000000010f0a7824ULL, 0x100fe200078e0209ULL,
0x00000009110e7210ULL, 0x000fe20007ffe0ffULL, 0x000000011c0f7824ULL, 0x100fe200078e0209ULL,
0x0000001809307210ULL, 0x040fe20007ffe0ffULL, 0x0000000124117824ULL, 0x100fe200078e0209ULL,
0x0000001b09367210ULL, 0x000fe20007ffe0ffULL, 0x00000001261c7824ULL, 0x000fe200078e0209ULL,
0x0ffffff825257812ULL, 0x100fe200078ef800ULL, 0x00000001180b7824ULL, 0x000fc400078e0200ULL,
0x0000010008087825ULL, 0x000fc800078e00ffULL, 0x0000000818187824ULL, 0x000fe400078e00ffULL,
0x00000001190d7824ULL, 0x140fe400078e0200ULL, 0x0000000819167824ULL, 0x000fe400078e00ffULL,
0x000000011a127824ULL, 0x140fe400078e0200ULL, 0x000000081a277824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee20dULL, 0x000000011b197824ULL, 0x040fe200078e0200ULL,
0xfffffff818007812ULL, 0x000fe200078ee20bULL, 0x000000081b1a7824ULL, 0x000fe200078e00ffULL,
0x00000070081b7812ULL, 0x000fe200078ef803ULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x000020009d087811ULL, 0x000fc400078e70ffULL, 0xfffffff827187812ULL, 0x000fe200078ee212ULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000001b06127210ULL, 0x000fe40007f1e0ffULL,
0xfffffff81a197812ULL, 0x000fe200078ee219ULL, 0x0000001015457824ULL, 0x100fe200078e0208ULL,
0x000000700a157812ULL, 0x100fe200078ef803ULL, 0x0000001014437824ULL, 0x100fe200078e0208ULL,
0x000000083d3d7211ULL, 0x080fe200078e20ffULL, 0x0000001013417824ULL, 0x100fe200078e0208ULL,
0x0000001506147210ULL, 0x000fe20007f3e0ffULL, 0x0000001017477824ULL, 0x100fe200078e0208ULL,
0x00000008194f7211ULL, 0x000fe200078e20ffULL, 0x0000001025317824ULL, 0x100fe200078e0208ULL,
0x000000700c177812ULL, 0x000fe200078ef803ULL, 0x0000001033337824ULL, 0x000fc400078e0208ULL,
0x0000001035357824ULL, 0x100fe400078e0208ULL, 0x0000001037377824ULL, 0x100fe400078e0208ULL,
0x0000001039397824ULL, 0x100fe400078e0208ULL, 0x000000103b3b7824ULL, 0x100fe400078e0208ULL,
0x000000103f3f7824ULL, 0x100fe400078e0208ULL, 0x0000001000497824ULL, 0x000fc400078e0208ULL,
0x00000010164b7824ULL, 0x100fe400078e0208ULL, 0x00000010184d7824ULL, 0x000fe400078e0208ULL,
0x0000000107137824ULL, 0x000fe200000e0609ULL, 0x0000001706167210ULL, 0x000fe20007f1e0ffULL,
0x000001000e087825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012317faeULL, 0x0003e2000b901c46ULL, 0x0000000107157824ULL, 0x000fe200008e060bULL,
0x0000007008197812ULL, 0x000fe200078ef803ULL, 0x000001000f0a7825ULL, 0x000fc600078e00ffULL,
0x0000000014337faeULL, 0x0003e2000b901c46ULL, 0x0000000107177824ULL, 0x000fe200000e060dULL,
0x000000700a1b7812ULL, 0x100fe200078ef803ULL, 0x00000100100e7825ULL, 0x000fe200078e00ffULL,
0x0000001906187210ULL, 0x040fe40007f1e0ffULL, 0x0000001b061a7210ULL, 0x000fe20007f3e0ffULL,
0x0000010011107825ULL, 0x000fe200078e00ffULL, 0x000000700e257812ULL, 0x000fe200078ef803ULL,
0x0000000016357faeULL, 0x0003e4000b901c46ULL, 0x0000000107197824ULL, 0x000fe200000e0609ULL,
0x0000007010277812ULL, 0x000fe200078ef803ULL, 0x000001001c087825ULL, 0x000fe200078e00ffULL,
0x0000002506247210ULL, 0x000fc40007f1e0ffULL, 0x0000002706267210ULL, 0x000fe20007f5e0ffULL,
0x00000001071b7824ULL, 0x040fe200008e060bULL, 0x00000070082d7812ULL, 0x100fe200078ef803ULL,
0x000001001e0a7825ULL, 0x000fe200078e00ffULL, 0x0000000018377faeULL, 0x0003e6000b901c46ULL,
0x00000100280c7825ULL, 0x000fe200078e00ffULL, 0x000000700a2b7812ULL, 0x000fe200078ef803ULL,
0x000000001a397faeULL, 0x0003e4000b901c46ULL, 0x0000000107257824ULL, 0x000fe200000e060fULL,
0x0000002d06287210ULL, 0x000fe20007f1e0ffULL, 0x00000100290e7825ULL, 0x000fe200078e00ffULL,
0x000000700c2d7812ULL, 0x000fc400078ef803ULL, 0x00000000243b7faeULL, 0x0003e2000b901c46ULL,
0x0000000107277824ULL, 0x040fe200010e0611ULL, 0x000000700e2f7812ULL, 0x000fe200078ef803ULL,
0x000001002a107825ULL, 0x000fe200078e00ffULL, 0x0000002b062a7210ULL, 0x040fe40007f3e0ffULL,
0x0000002f062e7210ULL, 0x040fe20007f5e0ffULL, 0x0000000107297824ULL, 0x040fe200000e0609ULL,
0x0000002d062c7210ULL, 0x000fe20007f1e0ffULL, 0x0000010030087825ULL, 0x000fe200078e00ffULL,
0x0000000b072b7210ULL, 0x040fe20000ffe4ffULL, 0x00000000263d7faeULL, 0x0003e2000b901c46ULL,
0x00000070100b7812ULL, 0x000fe200078ef803ULL, 0x00000001072d7824ULL, 0x040fe200000e060dULL,
0x0000007008557812ULL, 0x000fe200078ef803ULL, 0x00000001072f7824ULL, 0x040fe200010e060fULL,
0x0000000b06107210ULL, 0x000fe20007f1e0ffULL, 0x00000100320a7825ULL, 0x000fe200078e00ffULL,
0x00000000283f7faeULL, 0x0003e6000b901c46ULL, 0x00000100340c7825ULL, 0x000fe200078e00ffULL,
0x000000700a537812ULL, 0x100fe200078ef803ULL, 0x000000002a417faeULL, 0x0003e4000b901c46ULL,
0x00000100360e7825ULL, 0x000fe200078e00ffULL, 0x000000700c517812ULL, 0x000fe200078ef803ULL,
0x000000002c437faeULL, 0x0003e2000b901c46ULL, 0x00000053060a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000107117824ULL, 0x040fe200000e0611ULL, 0x000000700e037812ULL, 0x000fe200078ef803ULL,
0x000000002e457faeULL, 0x0003e2000b901c46ULL, 0x0000005506087210ULL, 0x040fe20007f1e0ffULL,
0x00000001070b7824ULL, 0x040fe200008e060bULL, 0x00000051060c7210ULL, 0x040fe20007f5e0ffULL,
0x0000000010477faeULL, 0x0003e2000b901c46ULL, 0x0000000306067210ULL, 0x000fe20007f7e0ffULL,
0x0000000107097824ULL, 0x000fc400000e0609ULL, 0x00000001070d7824ULL, 0x040fe400010e060dULL,
0x0000000107077824ULL, 0x000fe200018e060fULL, 0x0000000008497faeULL, 0x0003e8000b901c46ULL,
0x000000000a4b7faeULL, 0x0003e8000b901c46ULL, 0x000000000c4d7faeULL, 0x0003e8000b901c46ULL,
0x00000000064f7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x002fc40000015200ULL, 0x01e60400ff037984ULL, 0x000e620000000800ULL,
0x0000001d029b7224ULL, 0x000fe200078e02ffULL, 0x000000ff00087202ULL, 0x000fe20000000f00ULL,
0x00000001989f7824ULL, 0x000fe200078e0a9eULL, 0x8000000003ff7812ULL, 0x002fe20007804805ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000062009b9a7625ULL, 0x000fe200078e009aULL, 0x00000008ff9f7819ULL, 0x000fe2000001169fULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000027805ULL, 0x000fcc0000015200ULL,
0x0000000206097210ULL, 0x000fca0007f1e1ffULL, 0x0000000103037824ULL, 0x000fe200000e0e07ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011403ULL, 0x0000000900007211ULL, 0x000fca00078110ffULL,
0x000000ffff037224ULL, 0x000fca00000e0603ULL, 0x0000000200007819ULL, 0x000fc80000001203ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000229900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000001e7919ULL, 0x000e620000000000ULL,
0x00006a00a5a57a24ULL, 0x000fe200078e02ffULL, 0x0001e6889da07811ULL, 0x000fe200078e18ffULL,
0x000000021d1d7824ULL, 0x000fe200078e00ffULL, 0xffffffff9e1c7810ULL, 0x040fe20007ffe0ffULL,
0x000000209da17824ULL, 0x000fe200078e00ffULL, 0x000000099e1b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000199037810ULL, 0x044fe20007ffe0ffULL, 0x00000100991a7824ULL, 0x000fe200078e02a3ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000100ffa47424ULL, 0x000fe200078e00ffULL,
0x000000220300720cULL, 0x000fe20003f06070ULL, 0x00000020a2037224ULL, 0x000fe200078e02ffULL,
0x000000401a007812ULL, 0x000fc600078ec0ffULL, 0x0000640003027625ULL, 0x000fc800078e00a4ULL,
0x000000011f2f7824ULL, 0x000fc800078e0200ULL, 0x00000bb000008947ULL, 0x008fea0003800000ULL,
0x00000003ff2b7819ULL, 0x102fe2000001161eULL, 0x000000101e197824ULL, 0x000fe200078e00ffULL,
0x0000001a98097217ULL, 0x000fe40007800000ULL, 0x000000082b0d7810ULL, 0x040fe20007ffe0ffULL,
0x000000012b077824ULL, 0x000fe200078e022fULL, 0x0000007019197812ULL, 0x000fe200078ec0ffULL,
0x000000012b177824ULL, 0x140fe200078e021eULL, 0x000000042b0b7810ULL, 0x000fe20007ffe0ffULL,
0x000000010d057824ULL, 0x000fe200078e021eULL, 0x0000008019047812ULL, 0x000fe200078efcffULL,
0x000000080d067824ULL, 0x000fe200078e00ffULL, 0x0000000c2b117810ULL, 0x000fe20007ffe0ffULL,
0x000000080b297824ULL, 0x040fe200078e00ffULL, 0x0000001e0b007210ULL, 0x000fc40007ffe0ffULL,
0xfffffff8062d7812ULL, 0x000fe200078ee205ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee200ULL, 0x0000000111087824ULL, 0x000fe200078e021eULL,
0x000000102b137810ULL, 0x000fe20007ffe0ffULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x000000142b257810ULL, 0x000fe40007ffe0ffULL, 0x0000000313337819ULL, 0x000fe200000006ffULL,
0x0000000811317824ULL, 0x000fe200078e00ffULL, 0x00000006020e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000109007824ULL, 0x000fe200078e0a1aULL, 0x000000182b377810ULL, 0x000fe20007ffe0ffULL,
0x000000010d097824ULL, 0x000fe200078e022fULL, 0xfffffff831317812ULL, 0x000fe200078ee208ULL,
0x00000001030f7824ULL, 0x000fe200000e0607ULL, 0x000000000d00720cULL, 0x080fe20003f46070ULL,
0x000000010b077824ULL, 0x040fe200078e022fULL, 0x000000000b00720cULL, 0x080fe20003f86070ULL,
0x0000010009087825ULL, 0x000fe200078e0004ULL, 0x000000001100720cULL, 0x000fc40003f66070ULL,
0x000000001300720cULL, 0x000fe20003f06070ULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x0000000802127210ULL, 0x000fe40007fbe0ffULL, 0x0ffffff81e187812ULL, 0x000fe200078ec0ffULL,
0x00000001130d7824ULL, 0x140fe200078e022fULL, 0x0000000602107210ULL, 0x000fe20007f3e0ffULL,
0x00000001130a7824ULL, 0x000fe200078e021eULL, 0x000040009d207811ULL, 0x000fe200078e70ffULL,
0x00000001110b7824ULL, 0x000fe200078e022fULL, 0x0000000718277812ULL, 0x000fe200078ef817ULL,
0x0000000125137824ULL, 0x000fe200078e022fULL, 0xfffffff833337812ULL, 0x000fe200078ee20aULL,
0x0000000103117824ULL, 0x000fe200008e0607ULL, 0x0000002027277211ULL, 0x000fe200078e20ffULL,
0x000001000d067825ULL, 0x000fe200078e0004ULL, 0x000000202b397810ULL, 0x000fc60007ffe0ffULL,
0x00000100130c7825ULL, 0x100fe200078e0004ULL, 0x0000000903137210ULL, 0x000fe40002ffe4ffULL,
0x0000000602147210ULL, 0x040fe20007fbe0ffULL, 0x000001000b0a7825ULL, 0x000fe200078e0004ULL,
0x0000000c020c7210ULL, 0x000fc60007fde0ffULL, 0x0000000137097824ULL, 0x000fe200078e022fULL,
0x0000000a020a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000103157824ULL, 0x000fe200028e0607ULL,
0x000000002b00720cULL, 0x000fe20003fa6070ULL, 0x0000010009067825ULL, 0x000fc800078e0004ULL,
0x00000001030b7824ULL, 0x000fe200008e060bULL, 0x000000002500720cULL, 0x000fe20003f26070ULL,
0x00000001030d7824ULL, 0x000fe200030e060dULL, 0x0000000602167210ULL, 0x000fe20007fde0ffULL,
0x0000000125087824ULL, 0x040fe400078e021eULL, 0x0000000825357824ULL, 0x000fe200078e00ffULL,
0x0000001c2b257810ULL, 0x000fe20007ffe0ffULL, 0x0000000103177824ULL, 0x000fe200030e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e277faeULL, 0x0003e2000e901c46ULL,
0x0000001029297824ULL, 0x000fe200078e0220ULL, 0x000000003700720cULL, 0x080fe20003fa6070ULL,
0x0000000125077824ULL, 0x100fe200078e022fULL, 0xfffffff835357812ULL, 0x000fe200078ee208ULL,
0x0000000139097824ULL, 0x000fe200078e022fULL, 0x0000000010297faeULL, 0x0005e2000e101c46ULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x000000002500720cULL, 0x000fc60003f86070ULL,
0x0000000137267824ULL, 0x040fe200078e021eULL, 0x0000000602247210ULL, 0x000fe20007fde0ffULL,
0x0000000837377824ULL, 0x000fe400078e00ffULL, 0x0000010009087825ULL, 0x000fe200078e0004ULL,
0x000000202d117211ULL, 0x004fc600078e20ffULL, 0x0000000125067824ULL, 0x000fe200078e021eULL,
0x000000242b2d7810ULL, 0x000fe20007ffe0ffULL, 0x00000008250f7824ULL, 0x002fe200078e00ffULL,
0xfffffff837297812ULL, 0x000fe200078ee226ULL, 0x0000000103257824ULL, 0x000fe200030e0607ULL,
0x0000000802087210ULL, 0x000fe20007fde0ffULL, 0x000000012d077824ULL, 0x000fe200078e022fULL,
0xfffffff80f377812ULL, 0x000fe200078ee206ULL, 0x0000001031277824ULL, 0x000fe200078e0220ULL,
0x0000000012117faeULL, 0x0003e2000d101c46ULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x000000002d00720cULL, 0x000fc40003f46070ULL, 0x000000000a277faeULL, 0x0005e2000d901c46ULL,
0x00000001390f7824ULL, 0x140fe200078e021eULL, 0x000000003900720cULL, 0x040fe20003f66070ULL,
0x0000000839267824ULL, 0x000fe400078e00ffULL, 0x0000000103097824ULL, 0x000fe200030e0609ULL,
0x00000006020e7210ULL, 0x000fe20007fde0ffULL, 0x000000012d107824ULL, 0x040fe400078e021eULL,
0x000000082d317824ULL, 0x000fe200078e00ffULL, 0xfffffff8262d7812ULL, 0x000fe200078ee20fULL,
0x0000001033117824ULL, 0x102fe200078e0220ULL, 0x00000007030f7210ULL, 0x000fe200037fe4ffULL,
0x00000010290b7824ULL, 0x104fe200078e0220ULL, 0x000000282b297810ULL, 0x000fe20007ffe0ffULL,
0x0000001035077824ULL, 0x000fe200078e0220ULL, 0x0000000014117faeULL, 0x0003e2000c101c46ULL,
0xfffffff831317812ULL, 0x000fe200078ee210ULL, 0x0000001037137824ULL, 0x000fe200078e0220ULL,
0x000000302b337810ULL, 0x000fe20007ffe0ffULL, 0x0000000129067824ULL, 0x000fe200078e021eULL,
0x000000000c077faeULL, 0x0005e2000c901c46ULL, 0x000000102d277824ULL, 0x000fe200078e0220ULL,
0x0000002c2b2d7810ULL, 0x000fc40007ffe0ffULL, 0x00000000160b7faeULL, 0x0007e2000e901c46ULL,
0x000000342b357810ULL, 0x000fe20007ffe0ffULL, 0x0000000829157824ULL, 0x002fe400078e00ffULL,
0x0000000024137faeULL, 0x0003e2000e101c46ULL, 0x0000000133117824ULL, 0x100fe200078e022fULL,
0x000000382b377810ULL, 0x000fe20007ffe0ffULL, 0x0000000129077824ULL, 0x004fe200078e022fULL,
0xfffffff815157812ULL, 0x000fe200078ee206ULL, 0x00000010310d7824ULL, 0x000fe200078e0220ULL,
0x0000000008277faeULL, 0x0005e2000d901c46ULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x0000003c2b2b7810ULL, 0x000fc40007ffe0ffULL, 0x000000000e0d7faeULL, 0x0009e2000d101c46ULL,
0x00000001330b7824ULL, 0x048fe200078e021eULL, 0x00000006020a7210ULL, 0x000fe20007f5e0ffULL,
0x00000008330c7824ULL, 0x000fe200078e00ffULL, 0x000000002900720cULL, 0x080fe20003fc6070ULL,
0x000000082d177824ULL, 0x040fe200078e00ffULL, 0x000000002d00720cULL, 0x080fe20003fa6070ULL,
0x000000012b137824ULL, 0x002fe200078e022fULL, 0x0000002f2d097210ULL, 0x084fe20007ffe0ffULL,
0x0000000835277824ULL, 0x000fe200078e00ffULL, 0xfffffff80c257812ULL, 0x000fe200078ee20bULL,
0x00000001030b7824ULL, 0x000fe200010e0607ULL, 0x0000002f350f7210ULL, 0x010fe20007ffe0ffULL,
0x0000010009087825ULL, 0x000fe200078e0004ULL, 0x000000003300720cULL, 0x000fc40003f86070ULL,
0x000000003500720cULL, 0x000fe20003f66070ULL, 0x0000010011067825ULL, 0x000fe200078e0004ULL,
0x00000008020c7210ULL, 0x040fe40007f5e0ffULL, 0x000000003700720cULL, 0x0c0fe20003f26070ULL,
0x0000000137117824ULL, 0x000fe200078e022fULL, 0x000000002b00720cULL, 0x000fe20003f06070ULL,
0x000000012d007824ULL, 0x000fe400078e021eULL, 0x00000001030d7824ULL, 0x000fe200010e0609ULL,
0x00000006020e7210ULL, 0x000fe20007f5e0ffULL, 0x000001000f087825ULL, 0x000fe200078e0004ULL,
0xfffffff817177812ULL, 0x000fc600078ee200ULL, 0x0000000135007824ULL, 0x000fe400078e021eULL,
0x00000001030f7824ULL, 0x000fe200010e0607ULL, 0x0000000802087210ULL, 0x040fe20007f5e0ffULL,
0x0000010011067825ULL, 0x000fe200078e0004ULL, 0xfffffff827277812ULL, 0x000fe400078ee200ULL,
0x0000000903097210ULL, 0x000fe200017fe4ffULL, 0x0000000137007824ULL, 0x040fe200078e021eULL,
0x0000000602067210ULL, 0x000fe20007f5e0ffULL, 0x0000000837297824ULL, 0x000fc400078e00ffULL,
0x000000012b107824ULL, 0x040fe400078e021eULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee200ULL, 0x0000010013047825ULL, 0x000fc600078e0004ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee210ULL, 0x0000000103077824ULL, 0x000fe200010e0607ULL,
0x0000000402027210ULL, 0x000fe20007f5e0ffULL, 0x0000001015117824ULL, 0x100fe400078e0220ULL,
0x0000001017137824ULL, 0x100fe400078e0220ULL, 0x0000001025157824ULL, 0x100fe200078e0220ULL,
0x000000000a117faeULL, 0x0003e2000f101c46ULL, 0x0000001027177824ULL, 0x100fe400078e0220ULL,
0x0000001029257824ULL, 0x100fe200078e0220ULL, 0x000000000c137faeULL, 0x0003e2000e901c46ULL,
0x000000102b277824ULL, 0x000fc400078e0220ULL, 0x0000000103037824ULL, 0x000fe200010e0605ULL,
0x000000000e157faeULL, 0x0003e8000e101c46ULL, 0x0000000008177faeULL, 0x0003e8000d901c46ULL,
0x0000000006257faeULL, 0x0003e8000c901c46ULL, 0x0000000002277faeULL, 0x0003e2000c101c46ULL,
0x00000a7000007947ULL, 0x000fea0003800000ULL, 0x000000041e077811ULL, 0x042fe200078fe8ffULL,
0x000000101e197824ULL, 0x040fe200078e00ffULL, 0x000000141e0f7811ULL, 0x000fc400078fe8ffULL,
0x0000001e07007210ULL, 0x0c0fe20007ffe0ffULL, 0x0000000807337824ULL, 0x000fe200078e00ffULL,
0x0000000c1e0b7811ULL, 0x040fe200078fe8ffULL, 0x000000010f057824ULL, 0x100fe200078e021eULL,
0x000000081e097811ULL, 0x040fe200078fe8ffULL, 0x0000000107077824ULL, 0x000fe200078e022fULL,
0x000000030f067819ULL, 0x000fe200000006ffULL, 0x000000080b377824ULL, 0x000fe200078e00ffULL,
0x000000201e157811ULL, 0x040fe200078fe8ffULL, 0x0000000109047824ULL, 0x000fe200078e021eULL,
0xfffffff833337812ULL, 0x000fe200078ee200ULL, 0x000000010b007824ULL, 0x100fe200078e021eULL,
0x000000181e117811ULL, 0x000fe200078fe8ffULL, 0x0000000809357824ULL, 0x000fe200078e00ffULL,
0xfffffff8063b7812ULL, 0x000fe200078ee205ULL, 0x0000000115057824ULL, 0x040fe200078e021eULL,
0x000000101e0d7811ULL, 0x040fe200078fe8ffULL, 0x0000000815067824ULL, 0x000fe200078e00ffULL,
0x0000002c1e277811ULL, 0x040fe200078fe8ffULL, 0x00000008113d7824ULL, 0x000fe200078e00ffULL,
0xfffffff837377812ULL, 0x000fe200078ee200ULL, 0x0000000111007824ULL, 0x000fe200078e021eULL,
0xfffffff835357812ULL, 0x000fe200078ee204ULL, 0x000000010d047824ULL, 0x140fe200078e021eULL,
0x000000241e177811ULL, 0x000fe200078fe8ffULL, 0x000000080d397824ULL, 0x000fe200078e00ffULL,
0xfffffff806417812ULL, 0x000fe200078ee205ULL, 0x0000000127057824ULL, 0x040fe200078e021eULL,
0x0000001c1e137811ULL, 0x040fe200078fe8ffULL, 0x0000000827067824ULL, 0x000fe200078e00ffULL,
0x000000381e2d7811ULL, 0x040fe200078fe8ffULL, 0x0000000817437824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee200ULL, 0x0000000117007824ULL, 0x000fe200078e021eULL,
0xfffffff839397812ULL, 0x000fe200078ee204ULL, 0x0000000113047824ULL, 0x140fe200078e021eULL,
0x000000281e257811ULL, 0x040fe200078fe8ffULL, 0x00000008133f7824ULL, 0x000fe200078e00ffULL,
0x000000301e297811ULL, 0x000fe200078fe8ffULL, 0x0000000109097824ULL, 0x000fe200078e022fULL,
0xfffffff806477812ULL, 0x000fe200078ee205ULL, 0x000000012d057824ULL, 0x040fe200078e021eULL,
0x000000032d067819ULL, 0x000fe200000006ffULL, 0x0000000825457824ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fe200078ee200ULL, 0x0000000129007824ULL, 0x000fe200078e021eULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee204ULL, 0x0000000829497824ULL, 0x000fe200078e00ffULL,
0x0000001e25047210ULL, 0x080fe20007ffe0ffULL, 0x000000010b0b7824ULL, 0x100fe200078e022fULL,
0x000000341e2b7811ULL, 0x040fe200078fe8ffULL, 0x000000010d0d7824ULL, 0x100fe200078e022fULL,
0x0000003c1e4f7811ULL, 0x000fe200078fe8ffULL, 0x000000010f0f7824ULL, 0x000fe200078e022fULL,
0xfffffff8064d7812ULL, 0x000fe200078ee205ULL, 0x000000082b4b7824ULL, 0x000fe200078e00ffULL,
0x0000001e1e057211ULL, 0x040fe200078fe8ffULL, 0x000000084f517824ULL, 0x000fe200078e00ffULL,
0x0ffffff81e187812ULL, 0x000fe200078ec0ffULL, 0x0000000113137824ULL, 0x100fe200078e022fULL,
0x0000007019197812ULL, 0x000fe200078ec0ffULL, 0x0000000115157824ULL, 0x000fe200078e022fULL,
0xfffffff845457812ULL, 0x000fe200078ee204ULL, 0x000000012b047824ULL, 0x000fe200078e021eULL,
0xfffffff849497812ULL, 0x000fe200078ee200ULL, 0x000000014f007824ULL, 0x000fe200078e021eULL,
0x0000000718317812ULL, 0x000fe200078ef805ULL, 0x0000000117177824ULL, 0x100fe200078e022fULL,
0x0000002f11117210ULL, 0x080fe20007ffe0ffULL, 0x0000000125257824ULL, 0x100fe200078e022fULL,
0x0000002f4f4f7210ULL, 0x080fe20007ffe0ffULL, 0x0000000127277824ULL, 0x100fe200078e022fULL,
0x0000002f1e057211ULL, 0x000fe200078fe8ffULL, 0x0000000129297824ULL, 0x100fe200078e022fULL,
0x00000080192e7812ULL, 0x000fe200078efcffULL, 0x000000012b2b7824ULL, 0x100fe200078e022fULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee204ULL, 0x000000012d2d7824ULL, 0x000fe200078e022fULL,
0xfffffff851517812ULL, 0x000fe200078ee200ULL, 0x000000ffff2f7224ULL, 0x000fe200078e00ffULL,
0x000040009d007811ULL, 0x000fc600078e70ffULL, 0x0000010005047825ULL, 0x000fe200078e002eULL,
0x0000000041417211ULL, 0x000fc600078e20ffULL, 0x0000010007067825ULL, 0x000fe200078e002eULL,
0x0000000402047210ULL, 0x000fc60007f1e0ffULL, 0x0000010009087825ULL, 0x100fe200078e002eULL,
0x0000000602067210ULL, 0x040fe40007f3e0ffULL, 0x0000000503057210ULL, 0x000fe200007fe4ffULL,
0x000001000b0a7825ULL, 0x000fe200078e002eULL, 0x0000000802087210ULL, 0x000fc60007f5e0ffULL,
0x000001000d0c7825ULL, 0x000fe200078e002eULL, 0x0000000a020a7210ULL, 0x000fc60007f7e0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e002eULL, 0x0000000c020c7210ULL, 0x000fc60007f1e0ffULL,
0x0000010011107825ULL, 0x000fc800078e002eULL, 0x0000010013127825ULL, 0x000fc800078e002eULL,
0x0000010015147825ULL, 0x000fc800078e002eULL, 0x0000000103077824ULL, 0x040fe200008e0607ULL,
0x0000000e020e7210ULL, 0x040fe20007f3e0ffULL, 0x0000000103097824ULL, 0x040fe200010e0609ULL,
0x0000001002107210ULL, 0x040fe20007f5e0ffULL, 0x00000001030b7824ULL, 0x000fe200018e060bULL,
0x0000001202127210ULL, 0x000fe20007f7e0ffULL, 0x0000010017167825ULL, 0x000fc800078e002eULL,
0x0000010025247825ULL, 0x000fc800078e002eULL, 0x0000010027267825ULL, 0x000fc800078e002eULL,
0x0000001031317824ULL, 0x100fe400078e0200ULL, 0x00000001030d7824ULL, 0x000fe200000e060dULL,
0x0000001402147210ULL, 0x040fe20007f1e0ffULL, 0x0000001033337824ULL, 0x100fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004317faeULL, 0x0003e2000b901c46ULL,
0x0000001035357824ULL, 0x000fe400078e0200ULL, 0x0000010029287825ULL, 0x000fe200078e002eULL,
0x0000000006337faeULL, 0x0003e6000b901c46ULL, 0x00000001030f7824ULL, 0x040fe200008e060fULL,
0x0000001602167210ULL, 0x040fe20007f3e0ffULL, 0x0000000103117824ULL, 0x000fe200010e0611ULL,
0x0000002402247210ULL, 0x040fe20007f5e0ffULL, 0x0000001037377824ULL, 0x000fe200078e0200ULL,
0x0000001703177210ULL, 0x000fe20000ffe4ffULL, 0x000001002b2a7825ULL, 0x000fe200078e002eULL,
0x0000000008357faeULL, 0x0003e6000b901c46ULL, 0x0000000103137824ULL, 0x000fe200018e0613ULL,
0x0000002602267210ULL, 0x040fe20007f7e0ffULL, 0x0000001039397824ULL, 0x000fe200078e0200ULL,
0x0000002a022a7210ULL, 0x000fe20007f3e0ffULL, 0x000001002d2c7825ULL, 0x000fe200078e002eULL,
0x000000000a377faeULL, 0x0003e6000b901c46ULL, 0x000000103b3b7824ULL, 0x000fe200078e0200ULL,
0x000000000c397faeULL, 0x0003e2000b901c46ULL, 0x000001004f2e7825ULL, 0x000fc600078e002eULL,
0x000000000e3b7faeULL, 0x0003e2000b901c46ULL, 0x000000103d3d7824ULL, 0x100fe400078e0200ULL,
0x0000000103157824ULL, 0x000fe200000e0615ULL, 0x0000002802287210ULL, 0x040fe20007f1e0ffULL,
0x000000103f3f7824ULL, 0x100fe200078e0200ULL, 0x00000000103d7faeULL, 0x0003e2000b901c46ULL,
0x0000000103257824ULL, 0x000fe200010e0625ULL, 0x0000002c022c7210ULL, 0x040fe20007f5e0ffULL,
0x0000001043437824ULL, 0x100fe200078e0200ULL, 0x00000000123f7faeULL, 0x0003e2000b901c46ULL,
0x0000000103277824ULL, 0x000fe200018e0627ULL, 0x0000002e02027210ULL, 0x000fe20007f7e0ffULL,
0x0000001045457824ULL, 0x100fe200078e0200ULL, 0x0000000014417faeULL, 0x0003e2000b901c46ULL,
0x0000001047477824ULL, 0x000fc400078e0200ULL, 0x0000001049497824ULL, 0x100fe200078e0200ULL,
0x0000000016437faeULL, 0x0003e2000b901c46ULL, 0x0000000103297824ULL, 0x000fe400000e0629ULL,
0x000000104b4b7824ULL, 0x100fe200078e0200ULL, 0x0000000024457faeULL, 0x0003e2000b901c46ULL,
0x00000001032b7824ULL, 0x000fe400008e062bULL, 0x000000104d4d7824ULL, 0x000fe200078e0200ULL,
0x0000000026477faeULL, 0x0003e2000b901c46ULL, 0x00000001032d7824ULL, 0x000fc400010e062dULL,
0x0000001051517824ULL, 0x000fe200078e0200ULL, 0x0000000028497faeULL, 0x0003e2000b901c46ULL,
0x0000000103037824ULL, 0x000fc600018e062fULL, 0x000000002a4b7faeULL, 0x0003e8000b901c46ULL,
0x000000002c4d7faeULL, 0x0003e8000b901c46ULL, 0x0000000002517faeULL, 0x0003e4000b901c46ULL,
0x0000000221217810ULL, 0x000fe20007ffe0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff00207802ULL, 0x000fc40000000f00ULL, 0x000000232100720cULL, 0x000fda0003f06070ULL,
0x00000002a5028824ULL, 0x002fe400078e0221ULL, 0x00000004ff038424ULL, 0x000fc800078e00ffULL,
0x0000660002028625ULL, 0x000fe200078e0003ULL, 0x000000081e177812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000602208981ULL, 0x000322000c1e1900ULL,
0x00000004ff107819ULL, 0x100fe2000001161eULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000717177812ULL, 0x000fe400078ef81eULL, 0x000000071e6c7812ULL, 0x000fc600078ec0ffULL,
0x0000000110167824ULL, 0x000fe400078e0217ULL, 0x0000001017057824ULL, 0x000fca00078e00ffULL,
0xfffffff005007812ULL, 0x000fca00078ee216ULL, 0x0000001000647824ULL, 0x000fc400078e00ffULL,
0x0000001017137812ULL, 0x042fe200078efcffULL, 0x0000000810037824ULL, 0x040fe200078e00ffULL,
0x00000003ff157819ULL, 0x000fe2000001161eULL, 0x0000001017087824ULL, 0x000fe200078e00ffULL,
0x0000000413077819ULL, 0x000fe200000006ffULL, 0x0000000110107824ULL, 0x000fe200078e0213ULL,
0xfffffff8036c7812ULL, 0x000fe200078ee26cULL, 0x000040009d147824ULL, 0x000fe200078e00ffULL,
0x0000000216037810ULL, 0x000fe20007ffe0ffULL, 0x0000001013097824ULL, 0x000fe200078e00ffULL,
0xfffffff007027812ULL, 0x000fe200078ee210ULL, 0x000000086c117824ULL, 0x000fe200078e00ffULL,
0xfffffff008087812ULL, 0x000fe200078ee203ULL, 0x000000006464783bULL, 0x000fe20000000200ULL,
0x0000000115057812ULL, 0x000fe200078ec0ffULL, 0x00000010023c7824ULL, 0x000fe200078e00ffULL,
0x000000106c7c7810ULL, 0x040fe20007ffe0ffULL, 0x000000086c257824ULL, 0x040fe200078e00ffULL,
0x000000206c037810ULL, 0x040fe20007ffe0ffULL, 0x0000000105007824ULL, 0x040fe200078e026cULL,
0x000000306c027810ULL, 0x000fe20007ffe0ffULL, 0x00000001050f7824ULL, 0x040fe200078e027cULL,
0x0000200014127810ULL, 0x000fe20007ffe0ffULL, 0x00000001050e7824ULL, 0x000fe200078e0203ULL,
0xfffffff811117812ULL, 0x000fe200078ee200ULL, 0x00000001050d7824ULL, 0x000fe200078e0202ULL,
0x0000000303057819ULL, 0x000fe200000006ffULL, 0x000000087c067824ULL, 0x000fe200078e00ffULL,
0x0000000210047810ULL, 0x000fe20007ffe0ffULL, 0x00000008020a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8050e7812ULL, 0x000fe200078ee20eULL, 0x0000001011607824ULL, 0x100fe200078e0212ULL,
0xfffffff8060f7812ULL, 0x000fe200078ee20fULL, 0x000000003c3c783bULL, 0x000fe20000000200ULL,
0xfffffff80a0d7812ULL, 0x000fe200078ee20dULL, 0x000000100e787824ULL, 0x000fe200078e0212ULL,
0xfffffff009097812ULL, 0x000fe200078ee204ULL, 0x000000100f047824ULL, 0x100fe200078e0212ULL,
0x000000006060783bULL, 0x000e620000000200ULL, 0x000000100d687824ULL, 0x100fe200078e0212ULL,
0x00000012000b7810ULL, 0x000fe20007ffe0ffULL, 0x000000087c0a7824ULL, 0x000fe200078e00ffULL,
0x000000007878783bULL, 0x000fe20000000200ULL, 0x0000001009247824ULL, 0x000fe200078e00ffULL,
0x0000003200287810ULL, 0x000fe20007ffe0ffULL, 0x0000000803297824ULL, 0x000fe200078e00ffULL,
0x000000000404783bULL, 0x000ea20000000200ULL, 0xfffffff80a0b7812ULL, 0x000fe200078ee20bULL,
0x0000000802097824ULL, 0x000fe200078e00ffULL, 0x00000022000a7810ULL, 0x040fe20007ffe0ffULL,
0x000000006868783bULL, 0x000ee20000000200ULL, 0x00000002000c7810ULL, 0x000fe20007ffe0ffULL,
0x000000100b5c7824ULL, 0x000fe200078e0212ULL, 0xfffffff8290a7812ULL, 0x000fe200078ee20aULL,
0x0000001008087824ULL, 0x000fe200078e00ffULL, 0xfffffff809097812ULL, 0x000fe200078ee228ULL,
0x000000086c717824ULL, 0x000fe200078e00ffULL, 0xfffffff8250c7812ULL, 0x000fe200078ee20cULL,
0x000000100a747824ULL, 0x100fe200078e0212ULL, 0x000000000854783bULL, 0x0003e20000000200ULL,
0x0000001009287824ULL, 0x000fe200078e0212ULL, 0x000000120c387211ULL, 0x000fe200078e20ffULL,
0x000000087c887824ULL, 0x000fe200078e00ffULL, 0x000000005c5c783bULL, 0x000fe20000000200ULL,
0x00000008038a7824ULL, 0x000fe200078e00ffULL, 0x0000002600877810ULL, 0x000fe20007ffe0ffULL,
0x0000000802897824ULL, 0x000fe200078e00ffULL, 0x000000003838783bULL, 0x000ee20000000200ULL,
0x0000000416087810ULL, 0x002fc60007ffe0ffULL, 0x000000007474783bULL, 0x000e680000000200ULL,
0x000000002828783bULL, 0x000e620000000200ULL, 0x00000060642c723cULL, 0x040f6600000018ffULL,
0x000000002424783bULL, 0x000e6a0000000200ULL, 0x000000626434723cULL, 0x040f7000000018ffULL,
0x000000046440723cULL, 0x044f7000000018ffULL, 0x000000066444723cULL, 0x040f7000000018ffULL,
0x000000786448723cULL, 0x040f7000000018ffULL, 0x0000007a644c723cULL, 0x040f7000000018ffULL,
0x000000686450723cULL, 0x048f7000000018ffULL, 0x0000006a6464723cULL, 0x000f7000000018ffULL,
0x000000043c58723cULL, 0x040f7000000018ffULL, 0x000000063c04723cULL, 0x040ff000000018ffULL,
0x000000603c30723cULL, 0x040f7000000018ffULL, 0x000000623c60723cULL, 0x000f7000000018ffULL,
0x00000038542c723cULL, 0x060ff0000000182cULL, 0x0000003a5434723cULL, 0x040ff00000001834ULL,
0x0000005c5440723cULL, 0x040ff00000001840ULL, 0x0000005e5444723cULL, 0x040ff00000001844ULL,
0x000000745448723cULL, 0x042ff00000001848ULL, 0x00000076544c723cULL, 0x040ff0000000184cULL,
0x000000285450723cULL, 0x040ff00000001850ULL, 0x0000002a5454723cULL, 0x000bee0000001864ULL,
0x0000001017657824ULL, 0x020fe200078e00ffULL, 0x000000683c80723cULL, 0x000be200000018ffULL,
0x0000001013677824ULL, 0x000fe200078e00ffULL, 0x0000000610667810ULL, 0x000fc40007ffe0ffULL,
0xfffffff065647812ULL, 0x000fe400078ee208ULL, 0x0000000400087810ULL, 0x000fe20007ffe0ffULL,
0x0000001017687824ULL, 0x020fe200078e00ffULL, 0x0000005c2458723cULL, 0x000be20000001858ULL,
0x0000000413697819ULL, 0x000fe200000006ffULL, 0x0000001064647824ULL, 0x000fc600078e00ffULL,
0xfffffff069867812ULL, 0x000fe200078ee266ULL, 0x0000000802667824ULL, 0x000fe200078e00ffULL,
0x00000006165d7810ULL, 0x020fe20007ffe0ffULL, 0x000000382430723cULL, 0x040fe20000001830ULL,
0x00000004105c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000803697824ULL, 0x000fe200078e00ffULL,
0xfffffff068857812ULL, 0x000fe400078ee25dULL, 0xfffffff067657812ULL, 0x000fe200078ee25cULL,
0x000000086c677824ULL, 0x000fe200078e00ffULL, 0x0000001600037810ULL, 0x000fe20007ffe0ffULL,
0x0000005e245c723cULL, 0x000be20000001804ULL, 0x0000001085857824ULL, 0x000fe200078e00ffULL,
0x00000004868c7819ULL, 0x000fe200000006ffULL, 0x00000010656c7824ULL, 0x000fe200078e00ffULL,
0xfffffff867087812ULL, 0x000fc400078ee208ULL, 0xfffffff888037812ULL, 0x000fe200078ee203ULL,
0x000000087c047824ULL, 0x020fe200078e00ffULL, 0x0000001400077810ULL, 0x040fe20007ffe0ffULL,
0x0000003a2438723cULL, 0x000fe20000001860ULL, 0x0000003400057810ULL, 0x000fe20007ffe0ffULL,
0x000000006c6c783bULL, 0x000fe20000000200ULL, 0xfffffff804077812ULL, 0x000fe200078ee207ULL,
0x0000001008687824ULL, 0x100fe200078e0212ULL, 0xfffffff866057812ULL, 0x000fe200078ee205ULL,
0x0000001003907824ULL, 0x100fe200078e0212ULL, 0x0000001207707211ULL, 0x000fe200078e20ffULL,
0x000000783c60723cULL, 0x000f6200000018ffULL, 0x0000000600047810ULL, 0x040fe20007ffe0ffULL,
0x00000010057d7824ULL, 0x000fe200078e0212ULL, 0x000000006464783bULL, 0x000fe20000000200ULL,
0x0000002400067810ULL, 0x000fc40007ffe0ffULL, 0xfffffff871047812ULL, 0x000fe200078ee204ULL,
0x000000008c8c783bULL, 0x000fe20000000200ULL, 0x0000007a3c78723cULL, 0x040f6200000018ffULL,
0xfffffff869067812ULL, 0x000fe400078ee206ULL, 0x000000007070783bULL, 0x000e620000000200ULL,
0x0000003600007810ULL, 0x000fe20007ffe0ffULL, 0x0000001004887824ULL, 0x100fe200078e0212ULL,
0xfffffff88a027812ULL, 0x000fe200078ee287ULL, 0x000000007d7c783bULL, 0x000ea20000000200ULL,
0x0000006a3c3c723cULL, 0x000b6200000018ffULL, 0x0000001006847824ULL, 0x000fe200078e0212ULL,
0xfffffff889007812ULL, 0x000fe200078ee200ULL, 0x000000006868783bULL, 0x020ee20000000200ULL,
0x0000001002947824ULL, 0x000fc600078e0212ULL, 0x000000009090783bULL, 0x000fe20000000200ULL,
0x000000742460723cULL, 0x040fe60000001860ULL, 0x000000008888783bULL, 0x000fe80000000200ULL,
0x000000009494783bULL, 0x000fe20000000200ULL, 0x000000762474723cULL, 0x040be60000001878ULL,
0x000000008478783bULL, 0x020ee80000000200ULL, 0x000000008584783bULL, 0x000ee20000000200ULL,
0x000000282480723cULL, 0x040b6e0000001880ULL, 0x0000001000287824ULL, 0x020fe200078e0212ULL,
0x0000002a243c723cULL, 0x000b68000000183cULL, 0x000000002824783bULL, 0x020ee80000000200ULL,
0x000000706440723cULL, 0x082f700000001840ULL, 0x000000706c58723cULL, 0x000f700000001858ULL,
0x0000007c6450723cULL, 0x084f700000001850ULL, 0x0000007c6c80723cULL, 0x000f700000001880ULL,
0x0000007e6454723cULL, 0x080f700000001854ULL, 0x0000007e6c3c723cULL, 0x000f70000000183cULL,
0x00000068642c723cULL, 0x088f70000000182cULL, 0x000000686c30723cULL, 0x000f700000001830ULL,
0x0000006a6434723cULL, 0x080f700000001834ULL, 0x0000006a6c38723cULL, 0x000f700000001838ULL,
0x000000726444723cULL, 0x040f700000001844ULL, 0x000000786448723cULL, 0x040f700000001848ULL,
0x0000007a644c723cULL, 0x000f70000000184cULL, 0x000000726c5c723cULL, 0x040f70000000185cULL,
0x000000786c60723cULL, 0x040f700000001860ULL, 0x0000007a6c74723cULL, 0x000f700000001874ULL,
0x000000908440723cULL, 0x0a0f700000001840ULL, 0x000000908c58723cULL, 0x000b6e0000001858ULL,
0x0000030099907a10ULL, 0x020fe20007ffe0ffULL, 0x000000248450723cULL, 0x080f700000001850ULL,
0x000000248c80723cULL, 0x000b6e0000001880ULL, 0x0000000190257810ULL, 0x020fe20007ffe0ffULL,
0x000000268454723cULL, 0x000f660000001854ULL, 0x000000222500720cULL, 0x000fe20003f06070ULL,
0x000000a220257224ULL, 0x010fc800078e02ffULL, 0x000000268c3c723cULL, 0x000b62000000183cULL,
0x0000640025247625ULL, 0x000fcc00078e00a4ULL, 0x0000010090277824ULL, 0x020fe200078e02a3ULL,
0x00000088842c723cULL, 0x000b68000000182cULL, 0x0000004027667812ULL, 0x000fc800078ec0ffULL,
0x000000888c30723cULL, 0x000b620000001830ULL, 0x000000011f667824ULL, 0x000fce00078e0266ULL,
0x0000008a8434723cULL, 0x080b700000001834ULL, 0x0000008a8c38723cULL, 0x000b700000001838ULL,
0x000000928444723cULL, 0x040b700000001844ULL, 0x000000948448723cULL, 0x040b700000001848ULL,
0x00000096844c723cULL, 0x000b70000000184cULL, 0x000000928c5c723cULL, 0x040b70000000185cULL,
0x000000948c60723cULL, 0x040b700000001860ULL, 0x000000968c74723cULL, 0x000b620000001874ULL,
0x00000c4000008947ULL, 0x000fce0003800000ULL, 0x00000004152b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000115297824ULL, 0x040fe200078e021eULL, 0x0000000815677810ULL, 0x000fc40007ffe0ffULL,
0x000000032b717819ULL, 0x040fe200000006ffULL, 0x000000012b267824ULL, 0x100fe200078e021eULL,
0x00000027986a7217ULL, 0x000fe20007800000ULL, 0x0000000167287824ULL, 0x000fe200078e021eULL,
0x00000010156f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000867737824ULL, 0x000fe200078e00ffULL,
0xfffffff871717812ULL, 0x000fe200078ee226ULL, 0x0000000115267824ULL, 0x000fe200078e0266ULL,
0x00000007186b7812ULL, 0x000fe200078ef829ULL, 0x000000016a6a7824ULL, 0x000fe200078e0a27ULL,
0xfffffff873737812ULL, 0x000fe200078ee228ULL, 0x0000010026267825ULL, 0x000fe200078e00ffULL,
0x0000001e6f297210ULL, 0x000fc40007ffe0ffULL, 0x00000014157d7810ULL, 0x000fe20007ffe0ffULL,
0x000000086f2a7824ULL, 0x000fe200078e00ffULL, 0x0000000c156d7810ULL, 0x000fe20007ffe0ffULL,
0x000000012b287824ULL, 0x000fe200078e0266ULL, 0x0000001926657212ULL, 0x000fe200078efcffULL,
0x000000017d267824ULL, 0x000fe200078e021eULL, 0xfffffff82a7b7812ULL, 0x000fe200078ee229ULL,
0x0000010028287825ULL, 0x000fe200078e00ffULL, 0x0000006524647210ULL, 0x000fe40007f1e0ffULL,
0x0000006a2b00720cULL, 0x080fe20003f46070ULL, 0x000000087d7f7824ULL, 0x000fe200078e00ffULL,
0x0000001928697212ULL, 0x000fe200078efcffULL, 0x000000016d2a7824ULL, 0x040fe200078e0266ULL,
0x0000006a6d00720cULL, 0x000fe20003fa6070ULL, 0x0000000125657824ULL, 0x000fe200000e0627ULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee226ULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x0000006924687210ULL, 0x000fc40007f1e0ffULL, 0x0000006a6f00720cULL, 0x080fe20003f86070ULL,
0x0000000167267824ULL, 0x100fe200078e0266ULL, 0x0000002925697210ULL, 0x000fe200007fe4ffULL,
0x000000016f287824ULL, 0x000fe200078e0266ULL, 0x0000006a6700720cULL, 0x080fe20003f66070ULL,
0x000000016d187824ULL, 0x000fe200078e021eULL, 0x0000006a1500720cULL, 0x000fe20003f26070ULL,
0x000000086d797824ULL, 0x000fe200078e00ffULL, 0x000000192a6d7212ULL, 0x000fe200078efcffULL,
0x0000010026267825ULL, 0x000fe200078e00ffULL, 0x0000001815857810ULL, 0x020fc40007ffe0ffULL,
0x0000006d246c7210ULL, 0x000fe20007fde0ffULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x00000019266f7212ULL, 0x080fe400078efcffULL, 0x00000066852a7210ULL, 0x000fe20007ffe0ffULL,
0x00000001256d7824ULL, 0x000fe200030e062bULL, 0x0000001928677212ULL, 0x000fe200078efcffULL,
0x000000017d287824ULL, 0x000fe200078e0266ULL, 0x0000006f246e7210ULL, 0x040fe20007f1e0ffULL,
0x000000106b2b7824ULL, 0x000fe200078e0212ULL, 0x0000006724267210ULL, 0x000fe20007fde0ffULL,
0x0000000885877824ULL, 0x000fe200078e00ffULL, 0xfffffff879797812ULL, 0x000fe200078ee218ULL,
0x00000001256f7824ULL, 0x040fe200000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000642b7faeULL, 0x0003e2000c901c46ULL, 0x0000000125277824ULL, 0x000fe200030e0629ULL,
0x0000006a7d00720cULL, 0x000fe20003f06070ULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x0000001c157d7810ULL, 0x000fc40007ffe0ffULL, 0x0000002015897810ULL, 0x000fe20007ffe0ffULL,
0x0000000185187824ULL, 0x040fe200078e021eULL, 0x0000001928677212ULL, 0x000fe400078efcffULL,
0x0000006a8500720cULL, 0x000fe20003f26070ULL, 0x000000087d857824ULL, 0x000fe200078e00ffULL,
0x0000006724287210ULL, 0x000fe20007fde0ffULL, 0x000001002a2a7825ULL, 0x002fe200078e00ffULL,
0xfffffff887877812ULL, 0x000fe400078ee218ULL, 0x000000667d647210ULL, 0x040fe20007ffe0ffULL,
0x000000017d187824ULL, 0x000fe200078e021eULL, 0x000000192a657212ULL, 0x000fe200078efcffULL,
0x0000000125297824ULL, 0x000fc400030e0629ULL, 0x00000001896b7824ULL, 0x040fe200078e021eULL,
0x00000065242a7210ULL, 0x000fe20007fde0ffULL, 0x0000000889707824ULL, 0x000fe200078e00ffULL,
0xfffffff885857812ULL, 0x000fe200078ee218ULL, 0x0000001071677824ULL, 0x000fe400078e0212ULL,
0x0000010064647825ULL, 0x000fe200078e00ffULL, 0xfffffff8708b7812ULL, 0x000fe400078ee26bULL,
0x0000000068677faeULL, 0x0003e2000d101c46ULL, 0x0000000189187824ULL, 0x000fe200078e0266ULL,
0x0000001964717212ULL, 0x000fe200078efcffULL, 0x00000010736b7824ULL, 0x000fe200078e0212ULL,
0x0000002415737810ULL, 0x000fe20007ffe0ffULL, 0x00000001252b7824ULL, 0x000fe200030e062bULL,
0x0000007124647210ULL, 0x000fc40007fde0ffULL, 0x000000006e6b7faeULL, 0x0005e2000d901c46ULL,
0x0000006a7d00720cULL, 0x080fe40003f46070ULL, 0x0000000125657824ULL, 0x000fe200030e0665ULL,
0x00000030157d7810ULL, 0x000fe20007ffe0ffULL, 0x0000010018687825ULL, 0x002fe200078e00ffULL,
0x0000006a8900720cULL, 0x000fc60003f66070ULL, 0x0000001079677824ULL, 0x000fe400078e0212ULL,
0x0000000173187824ULL, 0x040fe200078e0266ULL, 0x00000019686b7212ULL, 0x004fe200078efcffULL,
0x00000001736e7824ULL, 0x040fe200078e021eULL, 0x000000006c677faeULL, 0x0003e2000e901c46ULL,
0x00000008736f7824ULL, 0x040fe200078e00ffULL, 0x0000006a7300720cULL, 0x000fe20003fa6070ULL,
0x000000017d707824ULL, 0x000fe200078e0266ULL, 0x0000006b24687210ULL, 0x000fe40007fde0ffULL,
0xfffffff86f737812ULL, 0x000fe200078ee26eULL, 0x0000010070707825ULL, 0x000fe200078e00ffULL,
0x000000127b6b7211ULL, 0x000fc400078e20ffULL, 0x00000028156f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000125697824ULL, 0x000fe400030e0669ULL, 0x00000100186c7825ULL, 0x002fe200078e00ffULL,
0x00000000266b7faeULL, 0x0003e2000e101c46ULL, 0x0000006a6f00720cULL, 0x040fe40003f86070ULL,
0x000000016f6e7824ULL, 0x040fe200078e021eULL, 0x000000196c677212ULL, 0x000fe200078efcffULL,
0x000000086f797824ULL, 0x040fe400078e00ffULL, 0x000000016f187824ULL, 0x000fe200078e0266ULL,
0x0000002c156f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001073737824ULL, 0x100fe200078e0212ULL,
0x00000067246c7210ULL, 0x000fe20007fde0ffULL, 0x000000107f677824ULL, 0x000fe200078e0212ULL,
0xfffffff879797812ULL, 0x000fe200078ee26eULL, 0x0000010018267825ULL, 0x002fe200078e00ffULL,
0x0000001e6f187210ULL, 0x000fc40007ffe0ffULL, 0x0000000028677faeULL, 0x0003e2000c101c46ULL,
0x000000016f6e7824ULL, 0x040fe200078e0266ULL, 0x00000019266b7212ULL, 0x000fe200078efcffULL,
0x000000086f7b7824ULL, 0x040fe200078e00ffULL, 0x0000006a6f00720cULL, 0x000fe20003f06070ULL,
0x000001006e6e7825ULL, 0x000fe200078e00ffULL, 0x00000034157f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee218ULL, 0x00000001256d7824ULL, 0x000fe200030e066dULL,
0x0000006b24267210ULL, 0x000fe20007fde0ffULL, 0x000000017d187824ULL, 0x000fe200078e021eULL,
0x000000196e297212ULL, 0x082fe200078efcffULL, 0x0000001087677824ULL, 0x000fe200078e0212ULL,
0x00000019706b7212ULL, 0x000fe200078efcffULL, 0x0000000125277824ULL, 0x000fe200030e0627ULL,
0x0000002924287210ULL, 0x000fc40007fde0ffULL, 0x000000002a677faeULL, 0x0003e2000c901c46ULL,
0x0000003c15877810ULL, 0x000fe40007ffe0ffULL, 0x0000000125297824ULL, 0x000fe200030e066fULL,
0x0000006b246e7210ULL, 0x000fe40007fde0ffULL, 0x00000012856b7211ULL, 0x000fe400078e20ffULL,
0x0000003815857810ULL, 0x000fe20007ffe0ffULL, 0x00000001256f7824ULL, 0x000fe200030e0671ULL,
0x0000006a7d00720cULL, 0x080fe20003f26070ULL, 0x00000000646b7faeULL, 0x0005e2000d101c46ULL,
0x000000017f2a7824ULL, 0x002fe200078e0266ULL, 0x0000006a8700720cULL, 0x000fe20003f46070ULL,
0x000000087d7d7824ULL, 0x000fc400078e00ffULL, 0x000001002a2a7825ULL, 0x000fc600078e00ffULL,
0xfffffff87d7d7812ULL, 0x000fe200078ee218ULL, 0x000000108b677824ULL, 0x000fe200078e0212ULL,
0x000000192a717212ULL, 0x000fe200078efcffULL, 0x00000001852a7824ULL, 0x100fe200078e0266ULL,
0x000000037f6b7819ULL, 0x004fe200000006ffULL, 0x0000000187647824ULL, 0x000fe200078e0266ULL,
0x0000007124707210ULL, 0x000fe20007fde0ffULL, 0x0000000068677faeULL, 0x0003e2000d901c46ULL,
0x000000017f187824ULL, 0x000fe200078e021eULL, 0x0000006a8500720cULL, 0x080fe20003f66070ULL,
0x0000010064647825ULL, 0x000fe200078e00ffULL, 0x000000006c737faeULL, 0x0005e2000e901c46ULL,
0x0000006a7f00720cULL, 0x000fc40003fa6070ULL, 0x0000000125717824ULL, 0x000fe200030e062bULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee218ULL, 0x000001002a2a7825ULL, 0x000fc800078e00ffULL,
0x0000000185667824ULL, 0x100fe200078e021eULL, 0x000000192a157212ULL, 0x080fe200078efcffULL,
0x0000000187677824ULL, 0x002fe200078e021eULL, 0x0000001964197212ULL, 0x000fe200078efcffULL,
0x00000008856d7824ULL, 0x004fe200078e00ffULL, 0x00000015242a7210ULL, 0x000fe20007fde0ffULL,
0x0000000887687824ULL, 0x000fe400078e00ffULL, 0x0000001079157824ULL, 0x000fe200078e0212ULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee266ULL, 0x00000001252b7824ULL, 0x000fe200030e062bULL,
0xfffffff868737812ULL, 0x000fe200078ee267ULL, 0x000000107d697824ULL, 0x100fe200078e0212ULL,
0x0000001924187210ULL, 0x000fe20007fde0ffULL, 0x000000106b6b7824ULL, 0x100fe200078e0212ULL,
0x000000127b677211ULL, 0x000fe200078e20ffULL, 0x000000106d6d7824ULL, 0x100fe200078e0212ULL,
0x0000000026157faeULL, 0x0003e2000e101c46ULL, 0x0000001073737824ULL, 0x000fc400078e0212ULL,
0x0000000125197824ULL, 0x000fe200030e0665ULL, 0x0000000028677faeULL, 0x0003e8000c101c46ULL,
0x000000006e697faeULL, 0x0003e8000c901c46ULL, 0x00000000706b7faeULL, 0x0003e8000e901c46ULL,
0x000000002a6d7faeULL, 0x0003e8000d901c46ULL, 0x0000000018737faeULL, 0x0003e2000d101c46ULL,
0x00000b1000007947ULL, 0x000fea0003800000ULL, 0x00000004152b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000115277824ULL, 0x040fe200078e021eULL, 0x0000000c156b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000815677810ULL, 0x000fe20007ffe0ffULL, 0x000000012b267824ULL, 0x140fe200078e021eULL,
0x000000032b657819ULL, 0x000fe200000006ffULL, 0x000000016b2a7824ULL, 0x100fe200078e021eULL,
0x0000001415717810ULL, 0x000fe20007ffe0ffULL, 0x000000086b6d7824ULL, 0x000fe200078e00ffULL,
0x0000001c157d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000167287824ULL, 0x000fe200078e021eULL,
0xfffffff865657812ULL, 0x000fe200078ee226ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x0000001815797810ULL, 0x000fe20007ffe0ffULL, 0x0000000171267824ULL, 0x000fe200078e021eULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee22aULL, 0x000000017d2a7824ULL, 0x000fe200078e021eULL,
0x0000000371737819ULL, 0x000fe200000006ffULL, 0x000000087d7f7824ULL, 0x000fe200078e00ffULL,
0x0000002415877810ULL, 0x020fe20007ffe0ffULL, 0x00000008797b7824ULL, 0x000fe200078e00ffULL,
0x0000002c158b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001796a7824ULL, 0x000fe200078e0266ULL,
0xfffffff869697812ULL, 0x000fe200078ee228ULL, 0x0000000179287824ULL, 0x000fe200078e021eULL,
0xfffffff873737812ULL, 0x000fe200078ee226ULL, 0x0000000187267824ULL, 0x000fe200078e021eULL,
0x0000002815897810ULL, 0x000fe20007ffe0ffULL, 0x000000088bab7824ULL, 0x000fe200078e00ffULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee22aULL, 0x000000018b2a7824ULL, 0x000fe200078e021eULL,
0x0000000387a77819ULL, 0x000fe200000006ffULL, 0x0000000889a97824ULL, 0x000fe200078e00ffULL,
0x0000000718297812ULL, 0x000fe200078ef827ULL, 0x0000000187707824ULL, 0x100fe200078e0266ULL,
0x0000001015277810ULL, 0x000fe20007ffe0ffULL, 0x0000000171687824ULL, 0x000fe200078e0266ULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee228ULL, 0x0000000189287824ULL, 0x100fe200078e021eULL,
0x00000030158d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000127187824ULL, 0x000fe200078e021eULL,
0xfffffff8a7a77812ULL, 0x000fe200078ee226ULL, 0x0000000115267824ULL, 0x000fe200078e0266ULL,
0xfffffff8abab7812ULL, 0x000fe200078ee22aULL, 0x00000001672a7824ULL, 0x100fe200078e0266ULL,
0x0000002015857810ULL, 0x000fe20007ffe0ffULL, 0x00000008276f7824ULL, 0x000fe200078e00ffULL,
0x00000034158f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000127677824ULL, 0x000fe200078e0266ULL,
0x0000003815917810ULL, 0x000fe20007ffe0ffULL, 0x000000088d867824ULL, 0x000fe200078e00ffULL,
0x0000003c15937810ULL, 0x000fe20007ffe0ffULL, 0x000000018d157824ULL, 0x000fe200078e021eULL,
0xfffffff8a9a97812ULL, 0x000fe200078ee228ULL, 0x0000010026267825ULL, 0x000fe200078e00ffULL,
0x000000666b647210ULL, 0x000fc40007ffe0ffULL, 0xfffffff8866b7812ULL, 0x000fe200078ee215ULL,
0x000000012b287824ULL, 0x000fe200078e0266ULL, 0x0000001926157212ULL, 0x000fe200078efcffULL,
0x00000001912b7824ULL, 0x000fe200078e021eULL, 0x000000668b787210ULL, 0x080fe20007ffe0ffULL,
0x0000000891887824ULL, 0x000fe200078e00ffULL, 0x0000001524267210ULL, 0x000fe20007f1e0ffULL,
0x0000001029877824ULL, 0x000fe200078e0212ULL, 0x0000006693847210ULL, 0x000fe20007ffe0ffULL,
0x0000010028287825ULL, 0x000fe200078e00ffULL, 0xfffffff888797812ULL, 0x000fc400078ee22bULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee218ULL, 0x000000017d6c7824ULL, 0x100fe200078e0266ULL,
0x0000001928157212ULL, 0x000fe200078efcffULL, 0x00000001856e7824ULL, 0x100fe200078e0266ULL,
0x00000012abab7211ULL, 0x080fe200078e20ffULL, 0x0000000189727824ULL, 0x100fe200078e0266ULL,
0x0000001524287210ULL, 0x000fe20007f3e0ffULL, 0x000000018d7a7824ULL, 0x100fe200078e0266ULL,
0x000000126d8d7211ULL, 0x000fe200078e20ffULL, 0x000000018f7c7824ULL, 0x100fe400078e0266ULL,
0x00000001917e7824ULL, 0x000fc400078e0266ULL, 0x000001002a2a7825ULL, 0x000fc800078e00ffULL,
0x0000000193667824ULL, 0x040fe200078e021eULL, 0x000000192a157212ULL, 0x000fe200078efcffULL,
0x00000008937d7824ULL, 0x000fe400078e00ffULL, 0x0000001065897824ULL, 0x000fe400078e0212ULL,
0x0000000185187824ULL, 0x000fe200078e021eULL, 0xfffffff87d7d7812ULL, 0x000fe200078ee266ULL,
0x0000000885977824ULL, 0x000fe400078e00ffULL, 0x0000010064647825ULL, 0x000fc600078e00ffULL,
0xfffffff897977812ULL, 0x000fe200078ee218ULL, 0x0000010067667825ULL, 0x000fc800078e00ffULL,
0x0000000125277824ULL, 0x000fe200000e0627ULL, 0x00000015242a7210ULL, 0x000fe20007f1e0ffULL,
0x00000010698b7824ULL, 0x000fe200078e0212ULL, 0x0000001964157212ULL, 0x080fe200078efcffULL,
0x0000010068687825ULL, 0x000fe200078e00ffULL, 0x00000019666d7212ULL, 0x000fe200078efcffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026877faeULL, 0x0003e4000b901c46ULL,
0x000000018f187824ULL, 0x040fe400078e021eULL, 0x000000088f717824ULL, 0x000fc400078e00ffULL,
0x000000106bad7824ULL, 0x000fe400078e0212ULL, 0x000001006a6a7825ULL, 0x000fe200078e00ffULL,
0xfffffff871717812ULL, 0x000fc600078ee218ULL, 0x00000001252b7824ULL, 0x040fe200000e062bULL,
0x0000001524647210ULL, 0x000fe20007f1e0ffULL, 0x0000000125297824ULL, 0x000fe200008e0629ULL,
0x0000001968157212ULL, 0x000fe200078efcffULL, 0x000000106f8f7824ULL, 0x100fe200078e0212ULL,
0x0000006d24667210ULL, 0x000fe20007f3e0ffULL, 0x000001006c6c7825ULL, 0x000fe200078e00ffULL,
0x000000196a6f7212ULL, 0x000fe200078efcffULL, 0x0000000028897faeULL, 0x0003e2000b901c46ULL,
0x0000006525657210ULL, 0x000fe200007fe4ffULL, 0x0000001071b17824ULL, 0x100fe200078e0212ULL,
0x0000001524687210ULL, 0x000fe20007f1e0ffULL, 0x0000010070707825ULL, 0x000fe200078e00ffULL,
0x000000196c157212ULL, 0x000fe200078efcffULL, 0x000000002a8b7faeULL, 0x0003e2000b901c46ULL,
0x0000006f246a7210ULL, 0x000fe20007f5e0ffULL, 0x0000001073917824ULL, 0x000fc400078e0212ULL,
0x000001006e6e7825ULL, 0x000fe200078e00ffULL, 0x00000000648d7faeULL, 0x0003e6000b901c46ULL,
0x0000000125697824ULL, 0x000fe200000e0669ULL, 0x00000015246c7210ULL, 0x000fe20007f1e0ffULL,
0x0000010072727825ULL, 0x000fe200078e00ffULL, 0x0000001970157212ULL, 0x000fc600078efcffULL,
0x000000107b937824ULL, 0x100fe200078e0212ULL, 0x000000196e7b7212ULL, 0x080fe200078efcffULL,
0x0000001079b57824ULL, 0x100fe400078e0212ULL, 0x000000107db77824ULL, 0x000fe200078e0212ULL,
0x00000019727d7212ULL, 0x000fe200078efcffULL, 0x0000010078787825ULL, 0x000fc800078e00ffULL,
0x00000001256d7824ULL, 0x040fe200000e066dULL, 0x0000001524707210ULL, 0x040fe20007f1e0ffULL,
0x0000000125677824ULL, 0x040fe200008e0667ULL, 0x0000007b246e7210ULL, 0x040fe20007f3e0ffULL,
0x00000001256b7824ULL, 0x000fe200010e066bULL, 0x0000007d24727210ULL, 0x000fe20007f5e0ffULL,
0x000001007a7a7825ULL, 0x000fe200078e00ffULL, 0x0000001978157212ULL, 0x000fe200078efcffULL,
0x00000000668f7faeULL, 0x0003e4000b901c46ULL, 0x000000107f957824ULL, 0x000fc400078e0212ULL,
0x000001007c7c7825ULL, 0x000fe200078e00ffULL, 0x0000000068917faeULL, 0x0003e6000b901c46ULL,
0x000001007e7e7825ULL, 0x000fe200078e00ffULL, 0x000000197caf7212ULL, 0x000fe200078efcffULL,
0x000000006a937faeULL, 0x0003e4000b901c46ULL, 0x0000000125717824ULL, 0x040fe200000e0671ULL,
0x0000001524787210ULL, 0x000fe20007f1e0ffULL, 0x0000010084847825ULL, 0x000fe200078e00ffULL,
0x000000197a157212ULL, 0x080fe200078efcffULL, 0x000000006c957faeULL, 0x0003e2000b901c46ULL,
0x000000197eb37212ULL, 0x000fe200078efcffULL, 0x00000001256f7824ULL, 0x040fe200008e066fULL,
0x0000007925797210ULL, 0x000fe200007fe4ffULL, 0x0000001097977824ULL, 0x100fe200078e0212ULL,
0x0000001984197212ULL, 0x000fe200078efcffULL, 0x0000000125737824ULL, 0x000fe200010e0673ULL,
0x0000001524187210ULL, 0x040fe20007f1e0ffULL, 0x00000010a7a77824ULL, 0x100fe200078e0212ULL,
0x000000af247a7210ULL, 0x040fe20007f3e0ffULL, 0x00000010a9a97824ULL, 0x000fe200078e0212ULL,
0x000000b3247c7210ULL, 0x040fe20007f5e0ffULL, 0x000000006e977faeULL, 0x0003e2000b901c46ULL,
0x0000001924247210ULL, 0x000fe20007f7e0ffULL, 0x0000000125197824ULL, 0x000fc400000e067bULL,
0x00000001257b7824ULL, 0x040fe200008e067dULL, 0x0000000070a77faeULL, 0x0003e2000b901c46ULL,
0x00000001257d7824ULL, 0x040fe400010e067fULL, 0x0000000125257824ULL, 0x000fe200018e0685ULL,
0x0000000072a97faeULL, 0x0003e8000b901c46ULL, 0x0000000078ab7faeULL, 0x0003e8000b901c46ULL,
0x0000000018ad7faeULL, 0x0003e8000b901c46ULL, 0x000000007ab17faeULL, 0x0003e8000b901c46ULL,
0x000000007cb57faeULL, 0x0003e8000b901c46ULL, 0x0000000024b77faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001013187824ULL, 0x002fe200078e00ffULL,
0x0000000810157810ULL, 0x000fe20007ffe0ffULL, 0x0000001017197824ULL, 0x000fe200078e00ffULL,
0x0000000816127810ULL, 0x000fc40007ffe0ffULL, 0x0000400014147810ULL, 0x000fe40007ffe0ffULL,
0xfffffff018157812ULL, 0x000fe400078ee215ULL, 0xfffffff019127812ULL, 0x000fe200078ee212ULL,
0x0000001011247824ULL, 0x100fe400078e0214ULL, 0x0000001015157824ULL, 0x000fe200078e00ffULL,
0x0000000412127819ULL, 0x000fe200000006ffULL, 0x000000100e6c7824ULL, 0x100fe400078e0214ULL,
0x000000100d687824ULL, 0x000fe200078e0214ULL, 0x0000000a160d7810ULL, 0x000fe20007ffe0ffULL,
0x00000010170e7824ULL, 0x000fc400078e00ffULL, 0x0000001013117824ULL, 0x000fe400078e00ffULL,
0x000000100f707824ULL, 0x000fe200078e0214ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002424783bULL, 0x000fe20000000200ULL, 0xfffffff00e0d7812ULL, 0x000fe200078ee20dULL,
0x000000100c0c7824ULL, 0x100fe200078e0214ULL, 0x0000000a100e7810ULL, 0x000fe20007ffe0ffULL,
0x000000001228783bULL, 0x0002a20000000200ULL, 0x000000040d787819ULL, 0x000fe200000006ffULL,
0x000000100b7c7824ULL, 0x000fe200078e0214ULL, 0xfffffff011117812ULL, 0x000fe200078ee20eULL,
0x000000001564783bULL, 0x0007220000000200ULL, 0x000000100a887824ULL, 0x100fe400078e0214ULL,
0x00000010098c7824ULL, 0x100fe200078e0214ULL, 0x000000007070783bULL, 0x000f220000000200ULL,
0x0000001011117824ULL, 0x000fe200078e00ffULL, 0x0000000c16097810ULL, 0x040fe20007ffe0ffULL,
0x00000010170a7824ULL, 0x000fe200078e00ffULL, 0x000000006c6c783bULL, 0x000f220000000200ULL,
0x0000000413127819ULL, 0x002fe200000006ffULL, 0x0000001017177824ULL, 0x000fe200078e00ffULL,
0x0000000e16167810ULL, 0x000fe20007ffe0ffULL, 0x000000006868783bULL, 0x000e620000000200ULL,
0xfffffff00a097812ULL, 0x000fe200078ee209ULL, 0x0000001004047824ULL, 0x000fe200078e0214ULL,
0x0000000413137819ULL, 0x000fe200000006ffULL, 0x000000000c0c783bULL, 0x000fe20000000200ULL,
0xfffffff017167812ULL, 0x000fe200078ee216ULL, 0x0000001009097824ULL, 0x000fc400078e00ffULL,
0x000000007878783bULL, 0x000e620000000200ULL, 0x0000001002157824ULL, 0x008fc600078e0214ULL,
0x000000001184783bULL, 0x0006680000000200ULL, 0x000000007c7c783bULL, 0x000e680000000200ULL,
0x000000008888783bULL, 0x000e620000000200ULL, 0x0000000c10117810ULL, 0x048fe40007ffe0ffULL,
0x0000000e10107810ULL, 0x000fe20007ffe0ffULL, 0x00000024282c723cULL, 0x004f62000000182cULL,
0x000000008c8c783bULL, 0x000ea20000000200ULL, 0xfffffff012117812ULL, 0x000fe200078ee211ULL,
0x0000001003127824ULL, 0x000fe200078e0214ULL, 0xfffffff013037812ULL, 0x000fc600078ee210ULL,
0x0000001011117824ULL, 0x000fe200078e00ffULL, 0x000000246430723cULL, 0x010b620000001830ULL,
0x0000001003037824ULL, 0x000fcc00078e00ffULL, 0x0000001007247824ULL, 0x120fe200078e0214ULL,
0x000000262834723cULL, 0x080f700000001834ULL, 0x000000266438723cULL, 0x000b640000001838ULL,
0x000000002424783bULL, 0x020fec0000000200ULL, 0x000000722844723cULL, 0x040f700000001844ULL,
0x0000006c2848723cULL, 0x040f700000001848ULL, 0x0000006e284c723cULL, 0x000f70000000184cULL,
0x0000006c6460723cULL, 0x000b6e0000001860ULL, 0x00000010166c7824ULL, 0x020fe200078e00ffULL,
0x000000702840723cULL, 0x040f700000001840ULL, 0x000000682850723cULL, 0x042f700000001850ULL,
0x0000006a2854723cULL, 0x000bee0000001854ULL, 0x0000001006287824ULL, 0x120fe200078e0214ULL,
0x000000706458723cULL, 0x040f6a0000001858ULL, 0x000000002828783bULL, 0x000fe60000000200ULL,
0x00000072645c723cULL, 0x040b64000000185cULL, 0x000000000370783bULL, 0x020fec0000000200ULL,
0x0000006e6474723cULL, 0x040b640000001874ULL, 0x000000006c6c783bULL, 0x020fec0000000200ULL,
0x000000686480723cULL, 0x000b6e0000001880ULL, 0x0000001005687824ULL, 0x120fe200078e0214ULL,
0x0000000c782c723cULL, 0x080fe2000000182cULL, 0x000000000404783bULL, 0x000fee0000000200ULL,
0x0000000c8430723cULL, 0x000bee0000001830ULL, 0x00000010080c7824ULL, 0x120fe200078e0214ULL,
0x0000006a643c723cULL, 0x000b62000000183cULL, 0x000000000908783bULL, 0x000e680000000200ULL,
0x000000001164783bULL, 0x020fe60000000200ULL, 0x0000000e7834723cULL, 0x080fe20000001834ULL,
0x000000006868783bULL, 0x000fe80000000200ULL, 0x000000001210783bULL, 0x000fe60000000200ULL,
0x0000000e8438723cULL, 0x000be40000001838ULL, 0x000000000c0c783bULL, 0x020eec0000000200ULL,
0x0000007e7844723cULL, 0x040f700000001844ULL, 0x000000887848723cULL, 0x040f700000001848ULL,
0x0000008a784c723cULL, 0x000f70000000184cULL, 0x000000888460723cULL, 0x000f700000001860ULL,
0x0000007c7840723cULL, 0x040f700000001840ULL, 0x0000008c7850723cULL, 0x004f700000001850ULL,
0x0000007c8458723cULL, 0x040f700000001858ULL, 0x0000007e845c723cULL, 0x040f70000000185cULL,
0x0000008a8474723cULL, 0x040f700000001874ULL, 0x0000008c8480723cULL, 0x000f700000001880ULL,
0x0000008e7854723cULL, 0x080b6e0000001854ULL, 0x0000001000787824ULL, 0x020fe200078e0214ULL,
0x0000008e843c723cULL, 0x000f62000000183cULL, 0x000000001514783bULL, 0x000ea80000000200ULL,
0x000000007878783bULL, 0x000f260000000200ULL, 0x000000260844723cULL, 0x042f700000001844ULL,
0x0000000c082c723cULL, 0x048f70000000182cULL, 0x0000000e0834723cULL, 0x040f700000001834ULL,
0x000000280848723cULL, 0x040f700000001848ULL, 0x0000002a084c723cULL, 0x000ff0000000184cULL,
0x0000000c6430723cULL, 0x040ff00000001830ULL, 0x0000000e6438723cULL, 0x040ff00000001838ULL,
0x000000286460723cULL, 0x000ff00000001860ULL, 0x000000240840723cULL, 0x040ff00000001840ULL,
0x000000680850723cULL, 0x000ff00000001850ULL, 0x000000246458723cULL, 0x040ff00000001858ULL,
0x00000026645c723cULL, 0x040ff0000000185cULL, 0x0000002a6474723cULL, 0x040ff00000001874ULL,
0x000000686480723cULL, 0x000ff00000001880ULL, 0x0000006a0854723cULL, 0x080ff00000001854ULL,
0x0000006a643c723cULL, 0x020ff0000000183cULL, 0x000000126c44723cULL, 0x040f700000001844ULL,
0x000000046c2c723cULL, 0x040f70000000182cULL, 0x000000066c34723cULL, 0x040f700000001834ULL,
0x000000146c48723cULL, 0x004f640000001848ULL, 0x3db504f347287820ULL, 0x020fc40000410000ULL,
0x3db504f3440d7820ULL, 0x000fe40000410000ULL, 0x3db504f3450e7820ULL, 0x000fe40000410000ULL,
0x3db504f346277820ULL, 0x000fe20000410000ULL, 0x000000166c4c723cULL, 0x000f62000000184cULL,
0x3db504f32c037820ULL, 0x000fe40000410000ULL, 0x3db504f32d087820ULL, 0x000fe40000410000ULL,
0x3db504f32e187820ULL, 0x000fc40000410000ULL, 0x3db504f32f2f7820ULL, 0x000fe20000410000ULL,
0x000000047030723cULL, 0x040f620000001830ULL, 0x3db504f334097820ULL, 0x000fe40000410000ULL,
0x3db504f3350a7820ULL, 0x000fe40000410000ULL, 0x3db504f336197820ULL, 0x000fe40000410000ULL,
0x3db504f337247820ULL, 0x000fe20000410000ULL, 0x000000067038723cULL, 0x000f620000001838ULL,
0x3db504f34a297820ULL, 0x000fc40000410000ULL, 0x3db504f3480f7820ULL, 0x000fe40000410000ULL,
0x3db504f34b2a7820ULL, 0x000fc60000410000ULL, 0x000000147060723cULL, 0x000f640000001860ULL,
0x3db504f34e2b7820ULL, 0x020fe40000410000ULL, 0x3db504f34f2c7820ULL, 0x000fc80000410000ULL,
0x000000106c40723cULL, 0x040f620000001840ULL, 0x3db504f333477820ULL, 0x000fe40000410000ULL,
0x3db504f330007820ULL, 0x000fe40000410000ULL, 0x3db504f331027820ULL, 0x000fe40000410000ULL,
0x3db504f332487820ULL, 0x000fe20000410000ULL, 0x000000786c50723cULL, 0x010f620000001850ULL,
0x3db504f338337820ULL, 0x000fe40000410000ULL, 0x3db504f339347820ULL, 0x000fc40000410000ULL,
0x3db504f33a4a7820ULL, 0x000fc60000410000ULL, 0x000000107058723cULL, 0x040b620000001858ULL,
0x3db504f360397820ULL, 0x000fe40000410000ULL, 0x3db504f3613a7820ULL, 0x000fe40000410000ULL,
0x3db504f3624b7820ULL, 0x000fe40000410000ULL, 0x3db504f34c117820ULL, 0x020fe20000410000ULL,
0x00000012705c723cULL, 0x000b62000000185cULL, 0x3db504f3400b7820ULL, 0x000fe40000410000ULL,
0x3db504f3410c7820ULL, 0x000fc40000410000ULL, 0x3db504f342257820ULL, 0x000fe40000410000ULL,
0x3db504f343267820ULL, 0x000fe20000410000ULL, 0x000000167014723cULL, 0x040f620000001874ULL,
0x3db504f349107820ULL, 0x000fe40000410000ULL, 0x3db504f34d127820ULL, 0x020fe40000410000ULL,
0x3db504f350137820ULL, 0x000fe40000410000ULL, 0x3db504f33b4c7820ULL, 0x000fe20000410000ULL,
0x000000787004723cULL, 0x000fe20000001880ULL, 0x3db504f351517820ULL, 0x000fc40000410000ULL,
0x3db504f3522d7820ULL, 0x000fe40000410000ULL, 0x3db504f3532e7820ULL, 0x000fe40000410000ULL,
0x3db504f358357820ULL, 0x000fe20000410000ULL, 0x0000007a6c54723cULL, 0x000f620000001854ULL,
0x3db504f359367820ULL, 0x000fe40000410000ULL, 0x3db504f35a4e7820ULL, 0x000fe40000410000ULL,
0x3db504f35b4f7820ULL, 0x000fc40000410000ULL, 0x3db504f35c377820ULL, 0x000fe20000410000ULL,
0x0000007a7070723cULL, 0x000b62000000183cULL, 0x3db504f35d387820ULL, 0x000fe40000410000ULL,
0x3db504f35e507820ULL, 0x000fe40000410000ULL, 0x3db504f35f4d7820ULL, 0x000fe40000410000ULL,
0x3db504f3633c7820ULL, 0x020fe40000410000ULL, 0x3db504f3143b7820ULL, 0x000fc40000410000ULL,
0x3db504f3153d7820ULL, 0x000fe40000410000ULL, 0x3db504f3163e7820ULL, 0x000fe40000410000ULL,
0x3db504f3173f7820ULL, 0x000fe40000410000ULL, 0x3db504f354547820ULL, 0x000fe40000410000ULL,
0x3db504f355557820ULL, 0x000fe40000410000ULL, 0x3db504f356567820ULL, 0x000fc40000410000ULL,
0x3db504f357577820ULL, 0x000fe40000410000ULL, 0x3db504f304407820ULL, 0x000fe40000410000ULL,
0x3db504f305417820ULL, 0x000fe40000410000ULL, 0x3db504f306427820ULL, 0x000fe40000410000ULL,
0x3db504f307447820ULL, 0x000fe40000410000ULL, 0x3db504f370437820ULL, 0x000fc40000410000ULL,
0x3db504f371457820ULL, 0x000fe40000410000ULL, 0x3db504f372467820ULL, 0x000fe40000410000ULL,
0x3db504f373497820ULL, 0x000fe20000410000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000a0527f8cULL, 0x0002a2000c80043fULL, 0x0000002f00177202ULL, 0x000fe20000000f00ULL,
0x000000ffff147224ULL, 0x000fe400078e0051ULL, 0x000000ffff157224ULL, 0x000fe400078e0054ULL,
0x000000ffff167224ULL, 0x000fc400078e0055ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0056ULL,
0x000000ffff307224ULL, 0x000fe400078e0057ULL, 0x000000ffff317224ULL, 0x000fe400078e0000ULL,
0x000000ffff327224ULL, 0x000fc400078e0002ULL, 0x0000000000047805ULL, 0x002fca0000015200ULL,
0x00000400a0077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fe40007804853ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff027224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604517210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09005100780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c405100780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011407ULL,
0x0000005100007211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000200007819ULL, 0x000fc80000001207ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000102027810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400a0077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804853ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000021e027819ULL, 0x000fe400000006ffULL, 0x0000009f9900720cULL, 0x000fe40003f06070ULL,
0xfffffff002007812ULL, 0x000fca00078ec0ffULL, 0x000000809d007824ULL, 0x000fca00078e0200ULL,
0x01e4000000047984ULL, 0x0002a20000000c00ULL, 0x000021e000008947ULL, 0x000fea0003800000ULL,
0x00005a0000557b06ULL, 0x000ee20000209000ULL, 0x000000ffff527224ULL, 0x000fe200078e00ffULL,
0x0000009c1e517211ULL, 0x000fe400078ff0ffULL, 0x0000001a985b7217ULL, 0x000fe40007800000ULL,
0x0000001051567810ULL, 0x000fe40007ffe0ffULL, 0x0000005b1a1a7210ULL, 0x000fe40007ffe1ffULL,
0x00005a00ff5d7a12ULL, 0x000fe200078e33ffULL, 0x0000005500557308ULL, 0x008ee40000001000ULL,
0x0ffffffe55577810ULL, 0x008fcc0007ffe0ffULL, 0x0000005700537305ULL, 0x000ee4000021f000ULL,
0x000000ffff597224ULL, 0x008fc800078e0a53ULL, 0x00005a0059597a24ULL, 0x000fc800078e02ffULL,
0x00000059535e7227ULL, 0x000fe200078e0052ULL, 0x0000000851537810ULL, 0x000fca0007ffe0ffULL,
0x000000535e547227ULL, 0x000fc800078e00ffULL, 0x000000515e527227ULL, 0x000fc800078e00ffULL,
0x000000ffff5c7224ULL, 0x000fe400078e0a54ULL, 0x000000ffff5a7224ULL, 0x000fe400078e0a52ULL,
0x00005a005c557a24ULL, 0x000fe400078e0253ULL, 0x00005a005a537a24ULL, 0x000fe200078e0251ULL,
0x0000001851517810ULL, 0x000fe20007ffe0ffULL, 0x000000565e587227ULL, 0x000fe200078e00ffULL,
0x00005a0055007a0cULL, 0x000fe40003fa6070ULL, 0x00005a0053007a0cULL, 0x000fe20003f06070ULL,
0x000000ffff577224ULL, 0x000fc400078e0a58ULL, 0x000000515e597227ULL, 0x000fc800078e00ffULL,
0x00005a0057567a24ULL, 0x000fe400078e0256ULL, 0x000000ffff5a7224ULL, 0x000fe400078e0a59ULL,
0x80005a0055555a10ULL, 0x000fe40007ffe0ffULL, 0x00005a005a577a24ULL, 0x000fe200078e0251ULL,
0x00005a0056007a0cULL, 0x000fe20003f26070ULL, 0x000000021e517824ULL, 0x000fe200078e00ffULL,
0x80005a0053530a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0057007a0cULL, 0x000fc40003f66070ULL,
0x00005a0053007a0cULL, 0x000fe40003f46070ULL, 0x0000000651517812ULL, 0x000fe400078ec0ffULL,
0x00005a0055007a0cULL, 0x000fe40003fc6070ULL, 0x0000000152520810ULL, 0x000fe20007ffe0ffULL,
0x00000001515b7824ULL, 0x000fe200078e029eULL, 0x80005a0056561a10ULL, 0x000fe20007ffe0ffULL,
0x000000011b557824ULL, 0x000fe200078e0251ULL, 0x0000000154545810ULL, 0x000fe20007ffe0ffULL,
0x000000015b537824ULL, 0x000fe200078e0a1aULL, 0x00005a0056007a0cULL, 0x000fc40003f86070ULL,
0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL, 0x0000001a5500720cULL, 0x040fe20003f06070ULL,
0x0000000155557824ULL, 0x000fe200078e0a1aULL, 0x80005a0057573a10ULL, 0x000fe40007ffe0ffULL,
0x0000000152522810ULL, 0x000fe40007ffe0ffULL, 0x000000531c6a7217ULL, 0x000fe40003800000ULL,
0x00005a0057007a0cULL, 0x000fc40003f46070ULL, 0x000000525d537207ULL, 0x000fe40006800000ULL,
0x000000551c557217ULL, 0x000fe40003800000ULL, 0x0000000154546810ULL, 0x000fe40007ffe0ffULL,
0x000000531c527217ULL, 0x000fe40003800000ULL, 0x0000000158581810ULL, 0x000fe40007ffe0ffULL,
0x0000001a5b00720cULL, 0x000fe20003fc6070ULL, 0x000000521d817224ULL, 0x000fe200078e02ffULL,
0x00000004ff557819ULL, 0x000fc40000011655ULL, 0x000000545d577207ULL, 0x000fe40006800000ULL,
0x0000000159593810ULL, 0x000fe40007ffe0ffULL, 0x0000000158584810ULL, 0x000fe40007ffe0ffULL,
0x000000ff6a6a7207ULL, 0x000fe40003000000ULL, 0x000000ff55567207ULL, 0x000fe40000000000ULL,
0x000000571c547217ULL, 0x000fc40003800000ULL, 0x0000000159592810ULL, 0x000fe20007ffe0ffULL,
0x0000000181557824ULL, 0x000fe200078e0256ULL, 0x000000585d577207ULL, 0x000fe20006800000ULL,
0x000000541d857224ULL, 0x000fe200078e02ffULL, 0x000000816a537211ULL, 0x000fe200078fe0ffULL,
0x0000000255547825ULL, 0x100fe200078e009aULL, 0x000000595d5d7207ULL, 0x000fe40006800000ULL,
0x000000571c5c7217ULL, 0x040fe20003800000ULL, 0x0000000253527825ULL, 0x000fe200078e009aULL,
0x0000005d1c5e7217ULL, 0x000fe20003800000ULL, 0x00000006545a7981ULL, 0x000722000c1e9500ULL,
0x0000001051697812ULL, 0x000fe200078efcffULL, 0x0000000156597824ULL, 0x000fc400078e0285ULL,
0x0000005c1d877224ULL, 0x000fe200078e02ffULL, 0x00000006525d7981ULL, 0x000322000c1e9500ULL,
0x0000000259587825ULL, 0x000fe200078e009aULL, 0x000000856a577211ULL, 0x000fe400078fe0ffULL,
0x0000008756637210ULL, 0x080fe20007ffe0ffULL, 0x0000005e1d897224ULL, 0x000fe200078e02ffULL,
0x000000876a5f7211ULL, 0x000fe200078fe0ffULL, 0x000000011b6d7824ULL, 0x000fe200078e0269ULL,
0x00000006585c7981ULL, 0x000522000c1e9500ULL, 0x0000000156657824ULL, 0x000fe200078e0289ULL,
0x000000896a617211ULL, 0x000fe200078fe0ffULL, 0x0000000257567825ULL, 0x000fc800078e009aULL,
0x0000000263627825ULL, 0x000fc800078e009aULL, 0x000000016d597824ULL, 0x004fe200078e0a1aULL,
0x00000006625e7981ULL, 0x000522000c1e9500ULL, 0x000000025f547825ULL, 0x008fc600078e009aULL,
0x000000591c587217ULL, 0x040fe20003800000ULL, 0x0000000169677824ULL, 0x000fe200078e029eULL,
0x00000006565f7981ULL, 0x000722000c1e9500ULL, 0x0000000261527825ULL, 0x002fe200078e009aULL,
0x0000001a6d00720cULL, 0x080fe40003f26070ULL, 0x0000000654617981ULL, 0x000322000c1e9500ULL,
0x0000000167597824ULL, 0x040fe200078e0a1aULL, 0x00000004ff587819ULL, 0x000fe40000011658ULL,
0x0000001a6700720cULL, 0x000fe20003f06070ULL, 0x0000000265647825ULL, 0x000fe200078e009aULL,
0x000000591c597217ULL, 0x000fe20003800000ULL, 0x00000006526b7981ULL, 0x000322000c1e9500ULL,
0x000000ff58567207ULL, 0x008fc40000800000ULL, 0x000000ff59747207ULL, 0x000fe20000000000ULL,
0x0000000664607981ULL, 0x000722000c1e9500ULL, 0x0000002051737812ULL, 0x000fe200078efcffULL,
0x0000000156597824ULL, 0x000fe200078e0285ULL, 0x0000008574577211ULL, 0x040fe400078fe0ffULL,
0x0000008174537211ULL, 0x042fe200078fe0ffULL, 0x0000000259587825ULL, 0x000fe200078e009aULL,
0x00000089746f7211ULL, 0x000fc600078fe0ffULL, 0x0000000181557824ULL, 0x000fe200078e0256ULL,
0x0000000658687981ULL, 0x000322000c1e9500ULL, 0x000000011b797824ULL, 0x000fe200078e0273ULL,
0x0000008756657210ULL, 0x008fe20007ffe0ffULL, 0x0000000253527825ULL, 0x000fc800078e009aULL,
0x0000000156717824ULL, 0x000fe200078e0289ULL, 0x00000006526d7981ULL, 0x000722000c1e9500ULL,
0x0000000255547825ULL, 0x000fc800078e009aULL, 0x0000000257567825ULL, 0x000fe200078e009aULL,
0x0000000654667981ULL, 0x000526000c1e9500ULL, 0x0000000179597824ULL, 0x002fe400078e0a1aULL,
0x0000000173757824ULL, 0x000fe400078e029eULL, 0x000000026f527825ULL, 0x008fe200078e009aULL,
0x000000591c587217ULL, 0x000fe20003800000ULL, 0x00000006566f7981ULL, 0x0002e4000c1e9500ULL,
0x0000000175597824ULL, 0x000fe200078e0a1aULL, 0x0000008774637211ULL, 0x004fe200078fe0ffULL,
0x0000000265647825ULL, 0x100fe200078e009aULL, 0x0000001a7500720cULL, 0x080fe20003f06070ULL,
0x0000000652777981ULL, 0x0004e2000c1e9500ULL, 0x000000591c597217ULL, 0x000fe20003800000ULL,
0x0000000263627825ULL, 0x000fe200078e009aULL, 0x0000001a7900720cULL, 0x000fe20003f26070ULL,
0x00000006646c7981ULL, 0x0004e2000c1e9500ULL, 0x00000004ff587819ULL, 0x000fe20000011658ULL,
0x0000000271547825ULL, 0x000fe200078e009aULL, 0x000000ff59787207ULL, 0x000fe20000000000ULL,
0x0000000662717981ULL, 0x0004e2000c1e9500ULL, 0x000000ff58587207ULL, 0x000fc40000800000ULL,
0x0000008178577211ULL, 0x002fe200078fe0ffULL, 0x00000006546e7981ULL, 0x0002e4000c1e9500ULL,
0x0000000158657824ULL, 0x004fe200078e0285ULL, 0x0000008578637211ULL, 0x000fe200078fe0ffULL,
0x0000000257567825ULL, 0x000fc800078e009aULL, 0x0000000181557824ULL, 0x002fe200078e0258ULL,
0x00000089787b7211ULL, 0x000fe200078fe0ffULL, 0x0000000265647825ULL, 0x100fe200078e009aULL,
0x0000000656797981ULL, 0x0002a6000c1e9500ULL, 0x0000000255547825ULL, 0x100fe200078e009aULL,
0x0000000664727981ULL, 0x0002a6000c1e9500ULL, 0x0000000263627825ULL, 0x000fe200078e009aULL,
0x0000000654707981ULL, 0x0002a6000c1e9500ULL, 0x00000001587d7824ULL, 0x000fc400078e0289ULL,
0x000000027b567825ULL, 0x102fe400078e009aULL, 0x00000006627b7981ULL, 0x0002a4000c1e9500ULL,
0x000000027d547825ULL, 0x000fe200078e009aULL, 0x00000030517d7812ULL, 0x000fe200078efcffULL,
0x0000000656d97981ULL, 0x0002a2000c1e9500ULL, 0x0000008758597210ULL, 0x080fe40007ffe0ffULL,
0x0000008778537211ULL, 0x000fe200078fe0ffULL, 0x000000011b837824ULL, 0x000fe200078e027dULL,
0x0000000654867981ULL, 0x0002a2000c1e9500ULL, 0x0000000259587825ULL, 0x000fc800078e009aULL,
0x0000000253527825ULL, 0x000fe200078e009aULL, 0x0000000658767981ULL, 0x0002a6000c1e9500ULL,
0x0000000183657824ULL, 0x000fe200078e0a1aULL, 0x0000000652d57981ULL, 0x0002a2000c1e9500ULL,
0x000000017d7f7824ULL, 0x000fc600078e029eULL, 0x000000651c647217ULL, 0x040fe20003800000ULL,
0x000000017f657824ULL, 0x000fe200078e0a1aULL, 0x0000001a8300720cULL, 0x080fe40003f26070ULL,
0x0000001a7f00720cULL, 0x000fe40003f06070ULL, 0x00000004ff647819ULL, 0x000fe40000011664ULL,
0x000000651c657217ULL, 0x000fe40003800000ULL, 0x000000ff647c7207ULL, 0x000fc40000800000ULL,
0x000000ff657a7207ULL, 0x000fe40000000000ULL, 0x000000877c577210ULL, 0x002fe20007ffe0ffULL,
0x0000000181637824ULL, 0x000fe200078e027cULL, 0x000000817a657211ULL, 0x040fe400078fe0ffULL,
0x000000877a597211ULL, 0x000fe200078fe0ffULL, 0x0000000263627825ULL, 0x000fc800078e009aULL,
0x0000000265647825ULL, 0x100fe200078e009aULL, 0x00000006627e7981ULL, 0x0002a6000c1e9500ULL,
0x0000000257567825ULL, 0x100fe200078e009aULL, 0x0000000664bd7981ULL, 0x0002a6000c1e9500ULL,
0x0000000259587825ULL, 0x000fe200078e009aULL, 0x0000000656847981ULL, 0x0002a2000c1e9500ULL,
0x000000857a557211ULL, 0x000fc600078fe0ffULL, 0x0000000658d77981ULL, 0x0002a2000c1e9500ULL,
0x000000017c537824ULL, 0x000fe400078e0285ULL, 0x0000000255547825ULL, 0x000fc800078e009aULL,
0x0000000253527825ULL, 0x000fe200078e009aULL, 0x0000000654d37981ULL, 0x0002a4000c1e9500ULL,
0x000000897a637211ULL, 0x002fe400078fe0ffULL, 0x0000000652827981ULL, 0x0002a2000c1e9500ULL,
0x000000017c657824ULL, 0x000fe400078e0289ULL, 0x0000000263627825ULL, 0x000fc800078e009aULL,
0x0000000265647825ULL, 0x000fe200078e009aULL, 0x0000000662db7981ULL, 0x0002a8000c1e9500ULL,
0x0000000664887981ULL, 0x0002a4000c1e9500ULL, 0xfffffff06a537812ULL, 0x002fe200078ec0ffULL,
0x00000001ffd17424ULL, 0x000fc800078e00ffULL, 0x000000011a527824ULL, 0x000fe200078e0253ULL,
0x0000000151817812ULL, 0x000fc800078efcffULL, 0x800000525b537210ULL, 0x000fc80007ffe0ffULL,
0x00000053d1537219ULL, 0x000fe200000006ffULL, 0x0000000181557824ULL, 0x000fe200078e029eULL,
0xfffffff074577812ULL, 0x000fc600078ec0ffULL, 0x0000000155547824ULL, 0x000fe200078e0a52ULL,
0x0000000851837812ULL, 0x040fe200078efcffULL, 0x000000011a587824ULL, 0x000fe200078e0257ULL,
0x0000000951857812ULL, 0x000fe400078efcffULL, 0x00000054d1577219ULL, 0x000fe200000006ffULL,
0x0000000183597824ULL, 0x100fe400078e029eULL, 0x0000000185657824ULL, 0x000fe200078e029eULL,
0xfffffff078637812ULL, 0x000fe200078ec0ffULL, 0x0000000159567824ULL, 0x100fe200078e0a52ULL,
0xfffffff07a877812ULL, 0x000fe200078ec0ffULL, 0x0000000165527824ULL, 0x000fe200078e0a52ULL,
0x00000011518b7812ULL, 0x000fe200078efcffULL, 0x000000011a627824ULL, 0x040fe200078e0263ULL,
0x00000056d1637219ULL, 0x040fe200000006ffULL, 0x000000011a787824ULL, 0x000fe200078e0287ULL,
0x00000052d1877219ULL, 0x000fe200000006ffULL, 0x000000018b8d7824ULL, 0x000fc400078e029eULL,
0x0000000167527824ULL, 0x000fe200078e0a58ULL, 0x0000001851917812ULL, 0x040fe400078efcffULL,
0x0000008d58547210ULL, 0x000fe40007ffe1ffULL, 0x0000001951977812ULL, 0x000fe400078efcffULL,
0x00000052d1897219ULL, 0x040fe400000006ffULL, 0x00000054d18f7219ULL, 0x000fe200000006ffULL,
0x0000000191937824ULL, 0x000fe200078e029eULL, 0x0000009e97997210ULL, 0x000fc40007ffe0ffULL,
0x000054105d5a7816ULL, 0x010fc8000000005aULL, 0x0000005a53ff7212ULL, 0x000fc800078ac0ffULL,
0x0000001a5b00720cULL, 0x000fc80002fa1470ULL, 0x0000001a5100720cULL, 0x000fe40002fa1070ULL,
0x0000005a57ff7212ULL, 0x000fe4000782c0ffULL, 0xff80000003037808ULL, 0x000fe40002800000ULL,
0x0000001a5500720cULL, 0x000fe40000f21470ULL, 0x000054105f5c7816ULL, 0x000fe4000000005cULL,
0x00005410615e7816ULL, 0x000fc4000000005eULL, 0x0000005c53ff7212ULL, 0x040fe4000784c0ffULL,
0x0000005e53ff7212ULL, 0x000fe4000788c0ffULL, 0x0000005c57ff7212ULL, 0x000fe400078ac0ffULL,
0x0000001a5b00720cULL, 0x0c0fe40001741470ULL, 0x0000001a5b00720cULL, 0x080fe40002781470ULL,
0x0000001a5500720cULL, 0x000fc40002fa1470ULL, 0x0000001a5100720cULL, 0x0c0fe40001741070ULL,
0x0000001a5100720cULL, 0x080fe40002781070ULL, 0x0000001a8100720cULL, 0x0c0fe40000f21070ULL,
0x0000001a8100720cULL, 0x000fe40002fa1070ULL, 0x000054106b607816ULL, 0x000fe40000000060ULL,
0xff80000018187808ULL, 0x000fc40001000000ULL, 0xff80000031317808ULL, 0x000fe40002000000ULL,
0xff80000008087808ULL, 0x000fe40000800000ULL, 0xff80000017177808ULL, 0x000fe40002800000ULL,
0x0000005a63ff7212ULL, 0x000fe4000786c0ffULL, 0x0000006053ff7212ULL, 0x000fe4000780c0ffULL,
0x0000005e57ff7212ULL, 0x000fc4000784c0ffULL, 0x0000006057ff7212ULL, 0x000fe4000788c0ffULL,
0x0000005c87ff7212ULL, 0x000fe4000782c0ffULL, 0x0000005e63ff7212ULL, 0x000fe400078ac0ffULL,
0x0000001a5b00720cULL, 0x080fe40000701470ULL, 0x0000001a5500720cULL, 0x0c0fe40001741470ULL,
0x0000001a5500720cULL, 0x000fc40002781470ULL, 0x0000001a5900720cULL, 0x0c0fe40001f61470ULL,
0x0000001a5900720cULL, 0x080fe40002fa1470ULL, 0x0000001a6500720cULL, 0x080fe40000f21470ULL,
0x0000001a5100720cULL, 0x080fe40000701070ULL, 0x0000001a8100720cULL, 0x0c0fe40001741070ULL,
0x0000001a8100720cULL, 0x000fc40002781070ULL, 0x0000001a8300720cULL, 0x0c0fe40001f61070ULL,
0x0000001a8300720cULL, 0x080fe40002fa1070ULL, 0x0000001a8500720cULL, 0x000fe40000f21070ULL,
0x000054106d667816ULL, 0x000fe40000000066ULL, 0x000054106f687816ULL, 0x008fe40000000068ULL,
0xff80000048487808ULL, 0x000fc40000000000ULL, 0xff80000032327808ULL, 0x000fe40001000000ULL,
0xff80000047477808ULL, 0x000fe40002000000ULL, 0xff80000009097808ULL, 0x000fe40001800000ULL,
0xff80000033337808ULL, 0x000fe40002800000ULL, 0xff80000024247808ULL, 0x000fe40000800000ULL,
0x0000005c63ff7212ULL, 0x000fc4000780c0ffULL, 0x0000005e87ff7212ULL, 0x000fe4000784c0ffULL,
0x0000006063ff7212ULL, 0x080fe4000788c0ffULL, 0x0000006087ff7212ULL, 0x000fe4000786c0ffULL,
0x000000668fff7212ULL, 0x000fe400078ac0ffULL, 0x0000006889ff7212ULL, 0x000fe2000782c0ffULL,
0x0000000193567824ULL, 0x100fe200078e0a58ULL, 0x0000001a5900720cULL, 0x080fe20000701470ULL,
0x0000000199587824ULL, 0x000fe200078e0a58ULL, 0x0000001a5900720cULL, 0x000fc40002781470ULL,
0x0000001a6500720cULL, 0x0c0fe40001741470ULL, 0x0000001a6500720cULL, 0x080fe40001f61470ULL,
0x0000001a6700720cULL, 0x080fe40000f21470ULL, 0x0000001a8d00720cULL, 0x080fe40002fa1470ULL,
0x0000001a8300720cULL, 0x0c0fe40000701070ULL, 0x0000001a8300720cULL, 0x000fc40002781070ULL,
0x0000001a8500720cULL, 0x0c0fe40001741070ULL, 0x0000001a8500720cULL, 0x080fe40001f61070ULL,
0x0000001a6900720cULL, 0x080fe40000f21070ULL, 0x0000001a8b00720cULL, 0x000fe40002fa1070ULL,
0x00000056d1957219ULL, 0x040fe400000006ffULL, 0x00000058d1a77219ULL, 0x000fc400000006ffULL,
0x00005410716c7816ULL, 0x000fe4000000006cULL, 0x00005410776e7816ULL, 0x000fe4000000006eULL,
0xff80000019197808ULL, 0x000fe40000000000ULL, 0xff8000004a4a7808ULL, 0x000fe40002000000ULL,
0xff80000034347808ULL, 0x000fe40001000000ULL, 0xff8000004c4c7808ULL, 0x000fc40001800000ULL,
0xff80000025257808ULL, 0x000fe40000800000ULL, 0xff8000000c0c7808ULL, 0x000fe40002800000ULL,
0x0000006689ff7212ULL, 0x080fe4000780c0ffULL, 0x0000006695ff7212ULL, 0x000fe4000788c0ffULL,
0x0000006c89ff7212ULL, 0x040fe4000784c0ffULL, 0x0000006e89ff7212ULL, 0x000fc4000786c0ffULL,
0x0000006c8fff7212ULL, 0x000fe4000782c0ffULL, 0x00000068a7ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000175647824ULL, 0x000fe200078e0a62ULL, 0x0000001a6700720cULL, 0x0c0fe40000701470ULL,
0x0000001a6700720cULL, 0x0c0fe40001741470ULL, 0x0000001a6700720cULL, 0x080fe40001f61470ULL,
0x0000001a8d00720cULL, 0x000fc40000f21470ULL, 0x0000001a9300720cULL, 0x080fe40002781470ULL,
0x0000001a9900720cULL, 0x080fe40002fa1470ULL, 0x0000002151ab7812ULL, 0x000fe400078efcffULL,
0x0000001a6900720cULL, 0x0c0fe40000701070ULL, 0x0000001a6900720cULL, 0x0c0fe40001741070ULL,
0x0000001a6900720cULL, 0x000fc40001f61070ULL, 0x0000001a8b00720cULL, 0x080fe40000f21070ULL,
0x0000001a9100720cULL, 0x080fe40002781070ULL, 0x0000001a9700720cULL, 0x000fe40002fa1070ULL,
0x00000064d1a97219ULL, 0x000fe400000006ffULL, 0x000054107b727816ULL, 0x004fe20000000072ULL,
0x00000001abad7824ULL, 0x000fe200078e029eULL, 0xff8000000b0b7808ULL, 0x000fc40000000000ULL,
0xff80000035357808ULL, 0x000fe40001000000ULL, 0xff8000004e4e7808ULL, 0x000fe40001800000ULL,
0xff80000036367808ULL, 0x000fe40000800000ULL, 0xff8000000d0d7808ULL, 0x000fe40002000000ULL,
0xff80000028287808ULL, 0x000fe40002800000ULL, 0x000000688fff7212ULL, 0x000fc4000780c0ffULL,
0x0000006e8fff7212ULL, 0x000fe4000784c0ffULL, 0x0000006895ff7212ULL, 0x000fe4000786c0ffULL,
0x0000006ca7ff7212ULL, 0x040fe4000782c0ffULL, 0x0000006ea7ff7212ULL, 0x000fe4000788c0ffULL,
0x00000072a9ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001ad6a7824ULL, 0x000fe200078e0a62ULL,
0x0000001a8d00720cULL, 0x000fc40000701470ULL, 0x0000001a8d00720cULL, 0x080fe40001741470ULL,
0x0000001a9300720cULL, 0x080fe40001f61470ULL, 0x0000001a9900720cULL, 0x0c0fe40000f21470ULL,
0x0000001a9900720cULL, 0x080fe40002781470ULL, 0x0000001a7500720cULL, 0x000fe40002fa1470ULL,
0x0000002851b17812ULL, 0x000fc400078efcffULL, 0x0000002951b77812ULL, 0x000fe400078efcffULL,
0x0000001a8b00720cULL, 0x0c0fe40000701070ULL, 0x0000001a8b00720cULL, 0x080fe40001741070ULL,
0x0000001a9100720cULL, 0x080fe40001f61070ULL, 0x0000001a9700720cULL, 0x0c0fe40000f21070ULL,
0x0000001a9700720cULL, 0x000fc40002781070ULL, 0x0000001a7300720cULL, 0x000fe40002fa1070ULL,
0x0000006ad1af7219ULL, 0x000fe400000006ffULL, 0x0000541079707816ULL, 0x000fe40000000070ULL,
0x00005410d5767816ULL, 0x000fe40000000076ULL, 0x00005410d9867816ULL, 0x000fe20000000086ULL,
0x00000001b1b37824ULL, 0x100fe200078e029eULL, 0xff80000026267808ULL, 0x000fe20000000000ULL,
0x00000001b7b97824ULL, 0x000fe200078e029eULL, 0xff8000004f4f7808ULL, 0x000fc40001000000ULL,
0xff80000027277808ULL, 0x000fe40001800000ULL, 0xff80000038387808ULL, 0x000fe40000800000ULL,
0xff8000004d4d7808ULL, 0x000fe40002000000ULL, 0xff80000029297808ULL, 0x000fe40002800000ULL,
0x0000005a87ff7212ULL, 0x000fe400078cc0ffULL, 0x0000006c95ff7212ULL, 0x000fc4000780c0ffULL,
0x0000006e95ff7212ULL, 0x000fe4000784c0ffULL, 0x00000070a9ff7212ULL, 0x040fe4000786c0ffULL,
0x00000076a9ff7212ULL, 0x040fe4000782c0ffULL, 0x00000086a9ff7212ULL, 0x000fe4000788c0ffULL,
0x00000076afff7212ULL, 0x000fe200078ac0ffULL, 0x00000001b3747824ULL, 0x100fe200078e0a62ULL,
0x0000001a6500720cULL, 0x080fe200037c1470ULL, 0x00000001b9627824ULL, 0x000fe200078e0a62ULL,
0x0000001a9300720cULL, 0x000fc40000701470ULL, 0x0000001a9300720cULL, 0x080fe40001741470ULL,
0x0000001a7500720cULL, 0x0c0fe40001f61470ULL, 0x0000001a7500720cULL, 0x0c0fe40000f21470ULL,
0x0000001a7500720cULL, 0x080fe40002781470ULL, 0x0000001aad00720cULL, 0x080fe40002fa1470ULL,
0x0000001a8500720cULL, 0x000fc400037c1070ULL, 0x0000001a9100720cULL, 0x0c0fe40000701070ULL,
0x0000001a9100720cULL, 0x080fe40001741070ULL, 0x0000001a7300720cULL, 0x0c0fe40001f61070ULL,
0x0000001a7300720cULL, 0x0c0fe40000f21070ULL, 0x0000001a7300720cULL, 0x080fe40002781070ULL,
0x0000001aab00720cULL, 0x000fc40002fa1070ULL, 0x00000074d1b57219ULL, 0x040fe400000006ffULL,
0x00000062d1bb7219ULL, 0x000fe400000006ffULL, 0xff8000000a0a7808ULL, 0x000fe40003000000ULL,
0xff80000037377808ULL, 0x000fe40000000000ULL, 0xff80000050507808ULL, 0x000fe40001000000ULL,
0xff8000000f0f7808ULL, 0x000fc40001800000ULL, 0xff80000039397808ULL, 0x000fe40000800000ULL,
0xff8000004b4b7808ULL, 0x000fe40002000000ULL, 0xff8000003a3a7808ULL, 0x000fe40002800000ULL,
0x00000066a7ff7212ULL, 0x000fe400078cc0ffULL, 0x00000070afff7212ULL, 0x080fe4000780c0ffULL,
0x00000070b5ff7212ULL, 0x000fc4000784c0ffULL, 0x00000072afff7212ULL, 0x040fe4000786c0ffULL,
0x00000086afff7212ULL, 0x000fe4000782c0ffULL, 0x00000072b5ff7212ULL, 0x000fe4000788c0ffULL,
0x00000076bbff7212ULL, 0x000fe200078ac0ffULL, 0x000000017f7a7824ULL, 0x000fe200078e0a78ULL,
0x0000001a9900720cULL, 0x080fe400037c1470ULL, 0x0000001aad00720cULL, 0x000fc40000701470ULL,
0x0000001aad00720cULL, 0x0c0fe40001f61470ULL, 0x0000001aad00720cULL, 0x080fe40000f21470ULL,
0x0000001ab300720cULL, 0x0c0fe40001741470ULL, 0x0000001ab300720cULL, 0x080fe40002781470ULL,
0x0000001ab900720cULL, 0x000fe40002fa1470ULL, 0x0000003151c17812ULL, 0x000fc400078efcffULL,
0x0000003851c77812ULL, 0x040fe400078efcffULL, 0x0000003951cd7812ULL, 0x000fe400078efcffULL,
0x0000001a9700720cULL, 0x080fe400037c1070ULL, 0x0000001aab00720cULL, 0x0c0fe40000701070ULL,
0x0000001aab00720cULL, 0x0c0fe40001f61070ULL, 0x0000001aab00720cULL, 0x000fc40000f21070ULL,
0x0000001ab100720cULL, 0x0c0fe40001741070ULL, 0x0000001ab100720cULL, 0x080fe40002781070ULL,
0x0000001ab700720cULL, 0x000fe40002fa1070ULL, 0x0000007ad1bf7219ULL, 0x000fe400000006ffULL,
0x00005410bd7e7816ULL, 0x000fe4000000007eULL, 0x00005410d7847816ULL, 0x000fe20000000084ULL,
0x00000001c1c37824ULL, 0x100fe200078e029eULL, 0xff8000000e0e7808ULL, 0x000fe20003000000ULL,
0x00000001c7c97824ULL, 0x100fe200078e029eULL, 0xff80000010107808ULL, 0x000fe20000000000ULL,
0x00000001cdcf7824ULL, 0x000fe200078e029eULL, 0xff8000002a2a7808ULL, 0x000fc40001800000ULL,
0xff8000003c3c7808ULL, 0x000fe40000800000ULL, 0xff80000011117808ULL, 0x000fe40001000000ULL,
0xff8000002b2b7808ULL, 0x000fe40002000000ULL, 0xff8000003d3d7808ULL, 0x000fe40002800000ULL,
0x00000070bbff7212ULL, 0x040fe400078cc0ffULL, 0x00000072bbff7212ULL, 0x000fc4000780c0ffULL,
0x00000076b5ff7212ULL, 0x040fe4000786c0ffULL, 0x00000086b5ff7212ULL, 0x080fe4000782c0ffULL,
0x00000086bbff7212ULL, 0x000fe4000784c0ffULL, 0x0000007ebfff7212ULL, 0x040fe4000788c0ffULL,
0x00000084bfff7212ULL, 0x000fe200078ac0ffULL, 0x00000001c9807824ULL, 0x100fe200078e0a78ULL,
0x000000c3787c7210ULL, 0x000fe20007ffe1ffULL, 0x00000001cf787824ULL, 0x000fe200078e0a78ULL,
0x0000001ab300720cULL, 0x000fc40001f61470ULL, 0x0000001ab300720cULL, 0x080fe40000f21470ULL,
0x0000001ab900720cULL, 0x0c0fe400037c1470ULL, 0x0000001ab900720cULL, 0x0c0fe40000701470ULL,
0x0000001ab900720cULL, 0x080fe40001741470ULL, 0x0000001a7f00720cULL, 0x0c0fe40002781470ULL,
0x0000001a7f00720cULL, 0x000fc40002fa1470ULL, 0x0000007cd1c57219ULL, 0x040fe400000006ffULL,
0x00000080d1cb7219ULL, 0x000fe400000006ffULL, 0x0000001ab100720cULL, 0x0c0fe40001f61070ULL,
0x0000001ab100720cULL, 0x080fe40000f21070ULL, 0x0000001ab700720cULL, 0x0c0fe400037c1070ULL,
0x0000001ab700720cULL, 0x000fc40000701070ULL, 0x0000001ab700720cULL, 0x080fe40001741070ULL,
0x0000001a7d00720cULL, 0x0c0fe40002781070ULL, 0x0000001a7d00720cULL, 0x000fe40002fa1070ULL,
0x00000078d1d17219ULL, 0x000fe400000006ffULL, 0x00005410d3827816ULL, 0x000fe40000000082ULL,
0xff8000003b3b7808ULL, 0x000fc40001800000ULL, 0xff8000003e3e7808ULL, 0x000fe40000800000ULL,
0xff80000012127808ULL, 0x000fe40003000000ULL, 0xff8000002c2c7808ULL, 0x000fe40000000000ULL,
0xff8000003f3f7808ULL, 0x000fe40001000000ULL, 0xff80000013137808ULL, 0x000fe40002000000ULL,
0xff80000040407808ULL, 0x000fc40002800000ULL, 0x0000007ec5ff7212ULL, 0x080fe4000786c0ffULL,
0x0000007ecbff7212ULL, 0x080fe4000782c0ffULL, 0x0000007ed1ff7212ULL, 0x000fe400078cc0ffULL,
0x00000082bfff7212ULL, 0x080fe4000780c0ffULL, 0x00000082c5ff7212ULL, 0x080fe4000784c0ffULL,
0x00000082cbff7212ULL, 0x000fc4000788c0ffULL, 0x00000084c5ff7212ULL, 0x000fe400078ac0ffULL,
0x0000001a7f00720cULL, 0x080fe40000701470ULL, 0x0000001ac300720cULL, 0x0c0fe40001f61470ULL,
0x0000001ac300720cULL, 0x0c0fe40001741470ULL, 0x0000001ac300720cULL, 0x080fe40002fa1470ULL,
0x0000001ac900720cULL, 0x000fc40000f21470ULL, 0x0000001acf00720cULL, 0x080fe400037c1470ULL,
0x0000001ac900720cULL, 0x080fe40002781470ULL, 0x0000001a7d00720cULL, 0x080fe40000701070ULL,
0x0000001ac100720cULL, 0x0c0fe40001f61070ULL, 0x0000001ac100720cULL, 0x0c0fe40001741070ULL,
0x0000001ac100720cULL, 0x000fc40002fa1070ULL, 0x0000001ac700720cULL, 0x080fe40000f21070ULL,
0x0000001acd00720cULL, 0x080fe400037c1070ULL, 0x0000001ac700720cULL, 0x000fe40002781070ULL,
0x00005410db887816ULL, 0x000fe40000000088ULL, 0xff8000002d2d7808ULL, 0x000fe40000000000ULL,
0xff80000014147808ULL, 0x000fc40001800000ULL, 0xff8000002e2e7808ULL, 0x000fe40001000000ULL,
0xff80000041417808ULL, 0x000fe40002800000ULL, 0xff80000015157808ULL, 0x000fe40000800000ULL,
0xff80000016167808ULL, 0x000fe40003000000ULL, 0xff8000002f2f7808ULL, 0x000fe40002000000ULL,
0x00000082d1ff7212ULL, 0x000fc4000780c0ffULL, 0x00000084cbff7212ULL, 0x080fe4000786c0ffULL,
0x00000084d1ff7212ULL, 0x000fe4000784c0ffULL, 0x00000088bfff7212ULL, 0x080fe400078ac0ffULL,
0x00000088c5ff7212ULL, 0x080fe4000782c0ffULL, 0x00000088cbff7212ULL, 0x080fe400078cc0ffULL,
0x00000088d1ff7212ULL, 0x000fc4000788c0ffULL, 0x0000001a7f00720cULL, 0x080fe40002fa1470ULL,
0x0000001ac300720cULL, 0x080fe40000f21470ULL, 0x0000001ac900720cULL, 0x0c0fe40001f61470ULL,
0x0000001ac900720cULL, 0x080fe400037c1470ULL, 0x0000001acf00720cULL, 0x0c0fe40000701470ULL,
0x0000001acf00720cULL, 0x000fc40001741470ULL, 0x0000001acf00720cULL, 0x080fe40002781470ULL,
0x0000001a7d00720cULL, 0x080fe40002fa1070ULL, 0x0000001ac100720cULL, 0x080fe40000f21070ULL,
0x0000001acd00720cULL, 0x080fe40000701070ULL, 0x0000001ac700720cULL, 0x0c0fe40001f61070ULL,
0x0000001ac700720cULL, 0x000fc400037c1070ULL, 0x0000001acd00720cULL, 0x0c0fe40001741070ULL,
0x0000001acd00720cULL, 0x000fe40002781070ULL, 0xff80000030307808ULL, 0x000fe40000000000ULL,
0xff80000043437808ULL, 0x000fe40001800000ULL, 0xff80000045457808ULL, 0x000fe40001000000ULL,
0xff80000042427808ULL, 0x000fc40002800000ULL, 0xff80000044447808ULL, 0x000fe40000800000ULL,
0xff80000046467808ULL, 0x000fe40003000000ULL, 0xff80000049497808ULL, 0x000fc40002000000ULL,
0x000000030400720bULL, 0x004fe40003f1e000ULL, 0x000000180500720bULL, 0x000fe40003f3e000ULL,
0x000000310600720bULL, 0x000fe40003f5e000ULL, 0x000000480700720bULL, 0x000fc40003f7e000ULL,
0x0000000403517208ULL, 0x000fe40004000000ULL, 0x0000000518047208ULL, 0x000fe40004800000ULL,
0x0000000631057208ULL, 0x000fe40005000000ULL, 0x0000000748067208ULL, 0x000fe40005800000ULL,
0x000000085100720bULL, 0x000fe40003f1e000ULL, 0x000000170400720bULL, 0x000fc40003f3e000ULL,
0x000000320500720bULL, 0x000fe40003f5e000ULL, 0x000000470600720bULL, 0x000fe40003f7e000ULL,
0x00000051081a7208ULL, 0x000fe40004000000ULL, 0x0000000417047208ULL, 0x000fe40004800000ULL,
0x0000000532527208ULL, 0x000fe40005000000ULL, 0x0000000647057208ULL, 0x000fc40005800000ULL,
0x000000091a00720bULL, 0x000fe40003f1e000ULL, 0x000000190400720bULL, 0x000fe40003f3e000ULL,
0x000000335200720bULL, 0x000fe40003f5e000ULL, 0x0000004a0500720bULL, 0x000fe40003f7e000ULL,
0x0000001a09077208ULL, 0x000fe40004000000ULL, 0x0000000419517208ULL, 0x000fc40004800000ULL,
0x0000005233537208ULL, 0x000fe40005000000ULL, 0x000000054a057208ULL, 0x000fe40005800000ULL,
0x0000000a0700720bULL, 0x000fe40003f1e000ULL, 0x000000245100720bULL, 0x000fe40003f3e000ULL,
0x000000345300720bULL, 0x000fe40003f5e000ULL, 0x0000004c0500720bULL, 0x000fc40003f7e000ULL,
0x000000070a047208ULL, 0x000fe40004000000ULL, 0x0000005124067208ULL, 0x000fe40004800000ULL,
0x00000053341a7208ULL, 0x000fe40005000000ULL, 0x000000054c057208ULL, 0x000fe40005800000ULL,
0x0000000b0400720bULL, 0x000fe40003f1e000ULL, 0x000000250600720bULL, 0x000fc40003f3e000ULL,
0x000000351a00720bULL, 0x000fe40003f5e000ULL, 0x0000004e0500720bULL, 0x000fe40003f7e000ULL,
0x000000040b077208ULL, 0x000fe40004000000ULL, 0x0000000625517208ULL, 0x000fe40004800000ULL,
0x0000001a35537208ULL, 0x000fe40005000000ULL, 0x000000054e047208ULL, 0x000fc40005800000ULL,
0x0000000c0700720bULL, 0x000fe40003f1e000ULL, 0x000000265100720bULL, 0x000fe40003f3e000ULL,
0x000000365300720bULL, 0x000fe40003f5e000ULL, 0x0000004f0400720bULL, 0x000fe40003f7e000ULL,
0x000000070c067208ULL, 0x000fe40004000000ULL, 0x00000051261a7208ULL, 0x000fc40004800000ULL,
0x0000005336527208ULL, 0x000fe40005000000ULL, 0x000000044f057208ULL, 0x000fe40005800000ULL,
0x0000000d0600720bULL, 0x000fe40003f1e000ULL, 0x000000271a00720bULL, 0x000fe40003f3e000ULL,
0x000000375200720bULL, 0x000fe40003f5e000ULL, 0x000000500500720bULL, 0x000fc40003f7e000ULL,
0x000000060d077208ULL, 0x000fe40004000000ULL, 0x0000001a27517208ULL, 0x000fe40004800000ULL,
0x0000005237537208ULL, 0x000fe40005000000ULL, 0x0000000550047208ULL, 0x000fe40005800000ULL,
0x0000000e0700720bULL, 0x000fe40003f1e000ULL, 0x000000285100720bULL, 0x000fc40003f3e000ULL,
0x000000385300720bULL, 0x000fe40003f5e000ULL, 0x0000004d0400720bULL, 0x000fe40003f7e000ULL,
0x000000070e067208ULL, 0x000fe40004000000ULL, 0x00000051281a7208ULL, 0x000fe40004800000ULL,
0x0000005338527208ULL, 0x000fe40005000000ULL, 0x000000044d047208ULL, 0x000fc40005800000ULL,
0x0000000f0600720bULL, 0x000fe40003f1e000ULL, 0x000000291a00720bULL, 0x000fe40003f3e000ULL,
0x000000395200720bULL, 0x000fe40003f5e000ULL, 0x0000004b0400720bULL, 0x000fe40003f7e000ULL,
0x000000060f057208ULL, 0x000fe40004000000ULL, 0x0000001a29077208ULL, 0x000fc40004800000ULL,
0x0000005239517208ULL, 0x000fe40005000000ULL, 0x000000044b537208ULL, 0x000fe40005800000ULL,
0x000000100500720bULL, 0x000fe40003f1e000ULL, 0x0000002a0700720bULL, 0x000fe40003f3e000ULL,
0x0000003a5100720bULL, 0x000fe40003f5e000ULL, 0x0000003c5300720bULL, 0x000fc40003f7e000ULL,
0x0000000510047208ULL, 0x000fe40004000000ULL, 0x000000072a067208ULL, 0x000fe40004800000ULL,
0x000000513a1a7208ULL, 0x000fe40005000000ULL, 0x000000533c537208ULL, 0x000fe40005800000ULL,
0x000000110400720bULL, 0x000fe40003f1e000ULL, 0x0000002b0600720bULL, 0x000fc40003f3e000ULL,
0x0000003b1a00720bULL, 0x000fe40003f5e000ULL, 0x0000003e5300720bULL, 0x000fe40003f7e000ULL,
0x0000000411057208ULL, 0x000fe40004000000ULL, 0x000000062b077208ULL, 0x000fe40004800000ULL,
0x0000001a3b1a7208ULL, 0x000fe40005000000ULL, 0x000000533e047208ULL, 0x000fc40005800000ULL,
0x000000120500720bULL, 0x000fe40003f1e000ULL, 0x0000002c0700720bULL, 0x000fe40003f3e000ULL,
0x0000003d1a00720bULL, 0x000fe40003f5e000ULL, 0x0000003f0400720bULL, 0x000fe40003f7e000ULL,
0x0000000512067208ULL, 0x000fe40004000000ULL, 0x000000072c527208ULL, 0x000fc40004800000ULL,
0x0000001a3d057208ULL, 0x000fe40005000000ULL, 0x000000043f077208ULL, 0x000fe40005800000ULL,
0x000000130600720bULL, 0x000fe40003f1e000ULL, 0x0000002d5200720bULL, 0x000fe40003f3e000ULL,
0x000000400500720bULL, 0x000fe40003f5e000ULL, 0x000000420700720bULL, 0x000fc40003f7e000ULL,
0x0000000613517208ULL, 0x000fe40004000000ULL, 0x000000522d537208ULL, 0x000fe40004800000ULL,
0x0000000540047208ULL, 0x000fe40005000000ULL, 0x0000000742077208ULL, 0x000fe40005800000ULL,
0x000000145100720bULL, 0x000fe40003f1e000ULL, 0x0000002e5300720bULL, 0x000fc40003f3e000ULL,
0x000000410400720bULL, 0x000fe40003f5e000ULL, 0x000000440700720bULL, 0x000fe40003f7e000ULL,
0x0000005114067208ULL, 0x000fe40004000000ULL, 0x000000532e1a7208ULL, 0x000fe40004800000ULL,
0x0000000441047208ULL, 0x000fe40005000000ULL, 0x0000000744077208ULL, 0x000fc40005800000ULL,
0x000000150600720bULL, 0x000fe40003f1e000ULL, 0x0000002f1a00720bULL, 0x000fe40003f3e000ULL,
0x000000430400720bULL, 0x000fe40003f5e000ULL, 0x000000460700720bULL, 0x000fe40003f7e000ULL,
0x0000000615057208ULL, 0x000fe40004000000ULL, 0x0000001a2f517208ULL, 0x000fc40004800000ULL,
0x0000000443047208ULL, 0x000fe40005000000ULL, 0x0000000746067208ULL, 0x000fe40005800000ULL,
0x000000160500720bULL, 0x000fe40003f1e000ULL, 0x000000305100720bULL, 0x000fe40003f3e000ULL,
0x000000450400720bULL, 0x000fe40003f5e000ULL, 0x000000490600720bULL, 0x000fc40003f7e000ULL,
0x0000000516077208ULL, 0x000fe40004000000ULL, 0x0000005130557208ULL, 0x000fe40004800000ULL,
0x0000000445547208ULL, 0x000fe40005000000ULL, 0x0000000649597208ULL, 0x000fe20005800000ULL,
0x000024727f007947ULL, 0x000fea000b800000ULL, 0x0c401f0007047f89ULL, 0x0004e400000e0000ULL,
0x000000040700720bULL, 0x008fc80003f1e000ULL, 0x00000007045b7208ULL, 0x000fe20004000000ULL,
0x000024a27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0055047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0054057f89ULL, 0x000f2800000e0000ULL, 0x0c401f0059067f89ULL, 0x000e6200000e0000ULL,
0x000000045500720bULL, 0x008fc40003f1e000ULL, 0x000000055400720bULL, 0x010fe40003f3e000ULL,
0x0000005504077208ULL, 0x006fe40004000000ULL, 0x00000054051a7208ULL, 0x000fe20004800000ULL,
0x0c201f005b047f89ULL, 0x000e6200000e0000ULL, 0x000000065900720bULL, 0x000fc60003f1e000ULL,
0x0c201f0007527f89ULL, 0x000ea200000e0000ULL, 0x0000005906577208ULL, 0x000fc60004000000ULL,
0x0c201f001a517f89ULL, 0x000ee800000e0000ULL, 0x0c201f0057587f89ULL, 0x0002e400000e0000ULL,
0x000000045b00720bULL, 0x002fe40003f1e000ULL, 0x000000520700720bULL, 0x004fe40003f3e000ULL,
0x0000005b04047208ULL, 0x000fc40004000000ULL, 0x000000511a00720bULL, 0x008fe40003f5e000ULL,
0x0000000752057208ULL, 0x000fe40004800000ULL, 0x0000001a51067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL, 0x000000585700720bULL, 0x004fe20003f1e000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x3fb8aa3b03037823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b08087823ULL, 0x000fc40000010807ULL, 0x0000000300597308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b09097823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x0000000800087308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b0e0e7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b0f037823ULL, 0x102fe40000010807ULL,
0x3fb8aa3b10527823ULL, 0x100fe20000010807ULL, 0x0000000c005b7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b11517823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b12547823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b13557823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b14567823ULL, 0x100fe20000010807ULL,
0x0000000d005c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b151a7823ULL, 0x100fe20000010807ULL,
0x000000590808723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b16537823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b05077820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b060c7820ULL, 0x002fe20000410000ULL,
0x0000000900097308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b18187823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b19197823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL, 0x0000000a000a7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b25257823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b26267823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b27277823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010807ULL,
0x0000002500157308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b29297823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b2b2b7823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010807ULL, 0x0000000b005a7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL, 0x000000090a0a723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b30077823ULL, 0x000fe20000010807ULL, 0x0000002c00627308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b34347823ULL, 0x000fc4000001080cULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b31317823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001080cULL,
0x0000000700667308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b33337823ULL, 0x000fe2000001080cULL,
0x00000002ff2c7819ULL, 0x002fe2000001161eULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001080cULL,
0x0000005a5b14723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b36367823ULL, 0x100fe2000001080cULL,
0x000000032c597819ULL, 0x000fe200000006ffULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001080cULL,
0x00000034000d7308ULL, 0x000fe20000000800ULL, 0x0000005758077208ULL, 0x008fe20004000000ULL,
0x3fb8aa3b38387823ULL, 0x100fe2000001080cULL, 0x000000022c107810ULL, 0x040fe20007ffe0ffULL,
0x3fb8aa3b39397823ULL, 0x100fe2000001080cULL, 0x000000032c117810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b07257820ULL, 0x000fe20000410000ULL, 0x000000031eff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b3b3b7823ULL, 0x000fe2000001080cULL, 0x0000000e005d7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b48487823ULL, 0x000fc40000010825ULL, 0x3fb8aa3b47477823ULL, 0x100fe40000010825ULL,
0x3fb8aa3b4c4c7823ULL, 0x000fe40000010825ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe2000001080cULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b40407823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b41417823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b43437823ULL, 0x000fc4000001080cULL,
0x3fb8aa3b450c7823ULL, 0x000fe2000001080cULL, 0x0000001700177308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010825ULL, 0x0000005c5d16723eULL, 0x002fe200000000ffULL,
0x000000082c697824ULL, 0x040fe400078e00ffULL, 0x000000082c577824ULL, 0x040fe400078e00ffULL,
0x000000082c127824ULL, 0x040fe200078e00ffULL, 0x0000003a00347308ULL, 0x000fe20000000800ULL,
0x000000082c6b7824ULL, 0x000fe200078e00ffULL, 0xfffffff857577812ULL, 0x000fe200078ee210ULL,
0x3fb8aa3b4e4e7823ULL, 0x000fe20000010825ULL, 0xfffffff812677812ULL, 0x000fe200078ee211ULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe20000010825ULL, 0x000000052c107810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010825ULL, 0x00000019000b7308ULL, 0x0003e20000000800ULL,
0x000000181709723eULL, 0x004fe200000000ffULL, 0x3c003c00ff187424ULL, 0x000fe200078e00ffULL,
0x000000062c117810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe20000010825ULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee210ULL, 0x3fb8aa3b4b4b7823ULL, 0x000fe20000010825ULL,
0xfffffff8126d7812ULL, 0x000fe200078ee211ULL, 0x0000002400247308ULL, 0x000ea20000000800ULL,
0x3c003c00ff197424ULL, 0x002fc400078e00ffULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe40000010825ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe40000010825ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010825ULL,
0x00000033000e7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b42427823ULL, 0x100fe40000010825ULL,
0x3fb8aa3b44447823ULL, 0x100fe40000010825ULL, 0x3fb8aa3b46467823ULL, 0x000fc40000010825ULL,
0x3fb8aa3b49497823ULL, 0x000fe20000010825ULL, 0x00000043003a7308ULL, 0x0007e20000000800ULL,
0x0000000b240b723eULL, 0x004fce00000000ffULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0x000000082c437824ULL, 0x048fe200078e00ffULL, 0x0000000e0d0e723eULL, 0x002fe200000000ffULL,
0x000000180810723cULL, 0x000f6a00000018ffULL, 0x0000003200327308ULL, 0x000ff00000000800ULL,
0x0000000c00457308ULL, 0x0002b00000000800ULL, 0x0000004800487308ULL, 0x000fe20000000800ULL,
0x000000012c0c7810ULL, 0x002fc80007ffe0ffULL, 0xfffffff843437812ULL, 0x000fe400078ee20cULL,
0x000000042c0c7810ULL, 0x040fe20007ffe0ffULL, 0x0000004700477308ULL, 0x000e620000000800ULL,
0x0000003a453a723eULL, 0x004fe400000000ffULL, 0xfffffff869697812ULL, 0x000fe400078ee20cULL,
0xffffffff2c0c7810ULL, 0x000fc60007ffe0ffULL, 0x0000004a000f7308ULL, 0x000fe20000000800ULL,
0xfffffff859597812ULL, 0x000fe400078ee20cULL, 0x00000031320c723eULL, 0x000fca00000000ffULL,
0x0000004c004c7308ULL, 0x000ea20000000800ULL, 0x00000048470d723eULL, 0x002fce00000000ffULL,
0x00000028005e7308ULL, 0x000fe20000000800ULL, 0x0000000f4c0f723eULL, 0x004fce00000000ffULL,
0x00000029005f7308ULL, 0x000ff00000000800ULL, 0x0000002a00607308ULL, 0x000ff00000000800ULL,
0x0000002b00617308ULL, 0x0003f00000000800ULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x000000180c28723cULL, 0x002f6e00000018ffULL, 0x0000002700277308ULL, 0x000e700000000800ULL,
0x0000003500357308ULL, 0x000fe20000000800ULL, 0x000000152615723eULL, 0x004fce00000000ffULL,
0x0000003600367308ULL, 0x000ea20000000800ULL, 0x000000275e17723eULL, 0x002fce00000000ffULL,
0x0000003700377308ULL, 0x000fe20000000800ULL, 0x000000181410723cULL, 0x020fee0000001810ULL,
0x0000003800387308ULL, 0x000e620000000800ULL, 0x000000353624723eULL, 0x004fce00000000ffULL,
0x0000004e004e7308ULL, 0x000ff00000000800ULL, 0x0000004f004f7308ULL, 0x000ea20000000800ULL,
0x000000373826723eULL, 0x002fce00000000ffULL, 0x0000005000507308ULL, 0x000ff00000000800ULL,
0x0000004d004d7308ULL, 0x000e620000000800ULL, 0x0000004e4f25723eULL, 0x004fce00000000ffULL,
0x0000003d00687308ULL, 0x0005e20000000800ULL, 0x000000504d27723eULL, 0x002fe200000000ffULL,
0x000000082c3d7824ULL, 0x004fcc00078e00ffULL, 0x0000000300037308ULL, 0x000fe20000000800ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee22cULL, 0x000000182428723cULL, 0x000f6c0000001828ULL,
0x0000005200527308ULL, 0x000ff00000000800ULL, 0x0000005100517308ULL, 0x000ff00000000800ULL,
0x0000005400547308ULL, 0x000ff00000000800ULL, 0x0000003900397308ULL, 0x000e700000000800ULL,
0x0000003b003b7308ULL, 0x000eb00000000800ULL, 0x0000004b004b7308ULL, 0x000fe20000000800ULL,
0x000000393434723eULL, 0x002fce00000000ffULL, 0x0000003c003c7308ULL, 0x000e620000000800ULL,
0x0000003b6836723eULL, 0x004fce00000000ffULL, 0x0000003e003e7308ULL, 0x000ff00000000800ULL,
0x0000003f00377308ULL, 0x000ea20000000800ULL, 0x0000004b3c35723eULL, 0x002fe400000000ffULL,
0x0000000c024b7812ULL, 0x000fca00078ec0ffULL, 0x0000002d00637308ULL, 0x0003f00000000800ULL,
0x0000002e00647308ULL, 0x0007220000000800ULL, 0x000000082c2d7810ULL, 0x002fe40007ffe0ffULL,
0x0000003e3737723eULL, 0x004fc600000000ffULL, 0x000000082d307824ULL, 0x000fe400078e00ffULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x000000102c2e7810ULL, 0x048fe20007ffe0ffULL,
0x000000183428723cULL, 0x020fe20000001828ULL, 0x000000182c2c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8304d7812ULL, 0x000fe200078ee22dULL, 0x000000082e4f7824ULL, 0x000fe200078e00ffULL,
0x0000005f602d723eULL, 0x000fe200000000ffULL, 0x000000082c5b7824ULL, 0x000fe200078e00ffULL,
0x0000005300537308ULL, 0x000e620000000800ULL, 0x000000636431723eULL, 0x010fc400000000ffULL,
0xfffffff84f4f7812ULL, 0x000fe400078ee22eULL, 0xfffffff85b5b7812ULL, 0x000fe400078ee22cULL,
0x00000003522c723eULL, 0x000fe200000000ffULL, 0x0000002f00657308ULL, 0x0004e20000000800ULL,
0x00000051542e723eULL, 0x000fce00000000ffULL, 0x0000005500557308ULL, 0x000fe20000000800ULL,
0x00000061622f723eULL, 0x004fe400000000ffULL, 0x0000001a5332723eULL, 0x002fe400000000ffULL,
0x000120009d1a7811ULL, 0x000fc600078e60ffULL, 0x000000182c10723cULL, 0x000f620000001810ULL,
0x0000005600567308ULL, 0x000e620000000800ULL, 0x000000103d387824ULL, 0x100fe200078e021aULL,
0x0000001a433c7211ULL, 0x080fe200078e20ffULL, 0x00000010573e7824ULL, 0x100fe200078e021aULL,
0x000000656633723eULL, 0x008fe200000000ffULL, 0x00000010673f7824ULL, 0x100fe200078e021aULL,
0x0000001a4d487211ULL, 0x000fe200078e20ffULL, 0x0000001069437824ULL, 0x000fe200078e021aULL,
0x0000004000407308ULL, 0x000fe20000000800ULL, 0x000000014b3d7824ULL, 0x000fc400078e0238ULL,
0x000000014b3c7824ULL, 0x040fe400078e023cULL, 0x000000014b3e7824ULL, 0x000fe200078e023eULL,
0x000000083d007388ULL, 0x0005e20000000800ULL, 0x0000001059477824ULL, 0x000fe200078e021aULL,
0x0000004100417308ULL, 0x000ee20000000800ULL, 0x000000555630723eULL, 0x002fe200000000ffULL,
0x000000014b3f7824ULL, 0x040fe200078e023fULL, 0x0000000a3c007388ULL, 0x0005e20000000800ULL,
0x000000014b437824ULL, 0x040fe400078e0243ULL, 0x000000014b477824ULL, 0x040fe200078e0247ULL,
0x000000143e007388ULL, 0x0005e20000000800ULL, 0x0000004200427308ULL, 0x000fe20000000800ULL,
0x000000183010723cULL, 0x020f620000001810ULL, 0x000000014b487824ULL, 0x000fe200078e0248ULL,
0x000000163f007388ULL, 0x0005e20000000800ULL, 0x000000104f4a7824ULL, 0x000fc600078e021aULL,
0x0000002c43007388ULL, 0x0005e20000000800ULL, 0x0000004400037308ULL, 0x0003220000000800ULL,
0x000000404138723eULL, 0x008fce00000000ffULL, 0x00000046003b7308ULL, 0x0007e20000000800ULL,
0x000000106b447824ULL, 0x002fc800078e021aULL, 0x000000014b447824ULL, 0x000fc600078e0244ULL,
0x0000004900027308ULL, 0x000e620000000800ULL, 0x000000106d467824ULL, 0x008fe200078e021aULL,
0x000000420339723eULL, 0x010fe200000000ffULL, 0x0000002e44007388ULL, 0x0005e20000000800ULL,
0x000000014b037824ULL, 0x040fe400078e024aULL, 0x000000464b467210ULL, 0x000fe20007ffe0ffULL,
0x000000105b1a7824ULL, 0x000fe400078e021aULL, 0x000000ffff117224ULL, 0x020fe400078e0012ULL,
0x0000003046007388ULL, 0x0005e20000000800ULL, 0x000000014b1a7824ULL, 0x000fc600078e021aULL,
0x0000003247007388ULL, 0x0005e20000000800ULL, 0x0000003b023b723eULL, 0x002fc600000000ffULL,
0x0000000948007388ULL, 0x0005e80000000800ULL, 0x000000183828723cULL, 0x000f620000001828ULL,
0x0004000b3c007388ULL, 0x0005e80000000800ULL, 0x000400153e007388ULL, 0x0005e80000000800ULL,
0x000400173f007388ULL, 0x0005e80000000800ULL, 0x0004002d43007388ULL, 0x0005e80000000800ULL,
0x0004002f44007388ULL, 0x0005e80000000800ULL, 0x0004003146007388ULL, 0x0005e60000000800ULL,
0x000000ffff127224ULL, 0x020fe200078e0028ULL, 0x0004003347007388ULL, 0x0005e20000000800ULL,
0x000000ffff137224ULL, 0x000fc600078e002aULL, 0x0000000c03007388ULL, 0x0005e80000000800ULL,
0x0008000e3c007388ULL, 0x0005e80000000800ULL, 0x000800243e007388ULL, 0x0005e80000000800ULL,
0x000800263f007388ULL, 0x0005e80000000800ULL, 0x0008003443007388ULL, 0x0005e80000000800ULL,
0x0008003644007388ULL, 0x0005e80000000800ULL, 0x0008003846007388ULL, 0x0005e80000000800ULL,
0x0008003a47007388ULL, 0x0005e80000000800ULL, 0x0000000d1a007388ULL, 0x0005e80000000800ULL,
0x000c000f3c007388ULL, 0x0005e80000000800ULL, 0x000c00253e007388ULL, 0x0005e80000000800ULL,
0x000c00273f007388ULL, 0x0005e80000000800ULL, 0x000c003543007388ULL, 0x0005e80000000800ULL,
0x000c003744007388ULL, 0x0005e80000000800ULL, 0x000c003946007388ULL, 0x0005e80000000800ULL,
0x000c003b47007388ULL, 0x0005e80000000800ULL, 0x01e0000400008388ULL, 0x0005e80000000c00ULL,
0x01e2001000008388ULL, 0x0005e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e60800a1ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e61000a1ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e61800a1ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000229000720cULL, 0x000fe20003f06070ULL, 0x01e62000a1ff7f8cULL, 0x0003e2000c80043fULL,
0x0000009000997202ULL, 0x000fd60000000f00ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff763000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff1e7807ULL, 0x008fe20004000000ULL, 0xffffffffff1f7424ULL, 0x000fe200078e00ffULL,
0x00019fa000207802ULL, 0x000fc40000000f00ULL, 0x000015e000007944ULL, 0x012fea0003c00000ULL,
0x0000001e00027202ULL, 0x000fe20000000f00ULL, 0xfffe91e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1e7807ULL, 0x000fe20005000000ULL, 0xffffffffff1f7424ULL, 0x000fe200078e00ffULL,
0x0001a00000207802ULL, 0x000fc40000000f00ULL, 0x0000158000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff057224ULL, 0x000fe200078e001eULL, 0xfffe922000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0007ULL, 0x0001a070001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x000014c000007944ULL, 0x012fea0003c00000ULL, 0xfffe92d000007947ULL, 0x000fea000383ffffULL,
0x0000000700207202ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe200078e00ffULL,
0x0001a0d0001f7802ULL, 0x000fe20000000f00ULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x0000146000007944ULL, 0x012fea0003c00000ULL, 0xfffe93e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0007ULL, 0x0001a130001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x0000140000007944ULL, 0x012fea0003c00000ULL, 0xfffe94f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0007ULL, 0x0001a190001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x000013a000007944ULL, 0x012fea0003c00000ULL, 0xfffe95f000007947ULL, 0x000fea000383ffffULL,
0x0000000200207202ULL, 0x000fe20000000f00ULL, 0x000000ffff1e7224ULL, 0x000fe200078e0003ULL,
0x0001a200001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x0000133000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e001eULL, 0xfffe978000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0002ULL, 0x0001a270001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x000012c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e001eULL,
0x00000010031e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff677424ULL, 0x000fe200078e00ffULL,
0x0000000200207202ULL, 0x000fe20000000f00ULL, 0xffffffffff217424ULL, 0x000fe200078e00ffULL,
0x0001a2e0001f7802ULL, 0x000fc40000000f00ULL, 0x0000125000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e001eULL, 0xfffe96f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0002ULL, 0x0001a350001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x000011e000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e001eULL,
0xfffe96b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1e7807ULL, 0x008fe20004000000ULL,
0xffffffffff1f7424ULL, 0x000fe200078e00ffULL, 0x0001a3b000207802ULL, 0x000fc40000000f00ULL,
0x000011d000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff197224ULL, 0x000fe200078e001eULL,
0xfffeaf0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1e7807ULL, 0x000fe20004800000ULL,
0xffffffffff1f7424ULL, 0x000fe200078e00ffULL, 0x0001a41000207802ULL, 0x000fc40000000f00ULL,
0x0000117000007944ULL, 0x000fea0003c00000ULL, 0x0000001e00667202ULL, 0x000fe20000000f00ULL,
0xfffeaf4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x0001a480001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fc400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x000010b000007944ULL, 0x000fea0003c00000ULL,
0xfffeb00000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x0001a4e0001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x0000105000007944ULL, 0x002fea0003c00000ULL,
0xfffeb11000007947ULL, 0x000fea000383ffffULL, 0x0000006800207202ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe200078e00ffULL, 0x0001a540001f7802ULL, 0x000fe20000000f00ULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x00000ff000007944ULL, 0x002fea0003c00000ULL,
0xfffeb22000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x0001a5a0001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x00000f9000007944ULL, 0x002fea0003c00000ULL,
0xfffeb32000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0xffffffff00217802ULL, 0x000fe20000000f00ULL, 0x000000ffff1e7224ULL, 0x000fe200078e0019ULL,
0x0001a610001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fc400078e00ffULL,
0x00000f2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e001eULL,
0xfffeb4a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x0001a680001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fc400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x00000eb000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e001eULL, 0x00000010191e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff207224ULL, 0x000fe200078e000eULL, 0x0001a6f0001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x00000e4000007944ULL, 0x000fea0003c00000ULL, 0x0000001e000f7202ULL, 0x004fe20000000f00ULL,
0xfffeb41000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x0001a760001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x00000dd000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e001eULL, 0xfffeb3d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1e7807ULL, 0x004fe20004000000ULL, 0xffffffffff1f7424ULL, 0x000fe200078e00ffULL,
0x0001a7c000207802ULL, 0x000fc40000000f00ULL, 0x00000dc000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff657224ULL, 0x000fe200078e001eULL, 0xfffeca2000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1e7807ULL, 0x000fe20004800000ULL, 0xffffffffff1f7424ULL, 0x000fe200078e00ffULL,
0x0001a82000207802ULL, 0x000fc40000000f00ULL, 0x00000d6000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff667224ULL, 0x000fe200078e001eULL, 0xfffeca5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0068ULL, 0xffffffff00217802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe200078e00ffULL, 0x0001a890001f7802ULL, 0x000fc40000000f00ULL,
0x00000ca000007944ULL, 0x018fea0003c00000ULL, 0xfffecb1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0068ULL, 0x0001a8f0001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x00000c4000007944ULL, 0x01afea0003c00000ULL, 0xfffecc2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0068ULL, 0x0001a950001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x00000be000007944ULL, 0x01afea0003c00000ULL, 0xfffecd3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0068ULL, 0xffffffff00217802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe200078e00ffULL, 0x0001a9b0001f7802ULL, 0x000fc40000000f00ULL,
0x00000b8000007944ULL, 0x01afea0003c00000ULL, 0xfffece3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e000eULL, 0x0001aa20001f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0065ULL, 0x0000001fff677424ULL, 0x000fc400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x00000b1000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e001eULL, 0xfffecfb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e000eULL, 0x0001aa90001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x00000aa000007944ULL, 0x016fea0003c00000ULL, 0x0000001e00107202ULL, 0x004fe20000000f00ULL,
0x000000ffff207224ULL, 0x000fe200078e000eULL, 0x00000010651e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff677424ULL, 0x000fe200078e00ffULL, 0x0001ab00001f7802ULL, 0x000fe20000000f00ULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x00000a3000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e001eULL, 0xfffecf2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e000eULL, 0x0001ab70001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x000009c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e001eULL,
0xfffecee000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1e7807ULL, 0x008fe20004000000ULL,
0xffffffffff1f7424ULL, 0x000fe200078e00ffULL, 0x0001abd000207802ULL, 0x000fc40000000f00ULL,
0x000009b000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff667224ULL, 0x000fe200078e001eULL,
0xfffee49000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1e7807ULL, 0x000fe20004800000ULL,
0xffffffffff1f7424ULL, 0x000fe200078e00ffULL, 0x0001ac3000207802ULL, 0x000fc40000000f00ULL,
0x0000095000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff697224ULL, 0x000fe200078e001eULL,
0xfffee4c000007947ULL, 0x000fea000383ffffULL, 0x0000006800207202ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe200078e00ffULL, 0x0001aca0001f7802ULL, 0x000fe20000000f00ULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x0000089000007944ULL, 0x010fea0003c00000ULL,
0xfffee58000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x0001ad00001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fc400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x0000083000007944ULL, 0x012fea0003c00000ULL,
0xfffee69000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x0001ad60001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x000007d000007944ULL, 0x012fea0003c00000ULL,
0xfffee7a000007947ULL, 0x000fea000383ffffULL, 0x0000006800207202ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe200078e00ffULL, 0x0001adc0001f7802ULL, 0x000fe20000000f00ULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x0000077000007944ULL, 0x012fea0003c00000ULL,
0xfffee8a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x0001ae30001f7802ULL, 0x000fe20000000f00ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0013ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x0000070000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e001eULL,
0xfffeea2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x0000001f00677802ULL, 0x000fe20000000f00ULL, 0xffffffffff217424ULL, 0x000fe200078e00ffULL,
0x0001aea0001f7802ULL, 0x000fc40000000f00ULL, 0x0000069000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e001eULL, 0x00000010131e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff207224ULL, 0x000fe200078e000eULL, 0x0001af10001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x0000062000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e001eULL,
0xfffee99000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0xffffffff00217802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe200078e00ffULL,
0x0001af80001f7802ULL, 0x000fc40000000f00ULL, 0x000005b000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e001eULL, 0xfffee95000007947ULL, 0x000fea000383ffffULL,
0x00000002ff1a7424ULL, 0x000fe200078e00ffULL, 0x0001aff000527802ULL, 0x000fe20000000f00ULL,
0x0000001fff587424ULL, 0x000fc400078e00ffULL, 0xffffffffff5d7424ULL, 0x000fc400078e00ffULL,
0x0000050000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0058ULL,
0xffffdb3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x006fe200078e0055ULL,
0x00000002001a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff587424ULL, 0x000fe200078e00ffULL,
0x0001b07000527802ULL, 0x000fe20000000f00ULL, 0xffffffffff5d7424ULL, 0x000fc400078e00ffULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x000000585500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0054ULL, 0x0001b0f000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff1a7424ULL, 0x000fe200078e00ffULL, 0x0000005558057208ULL, 0x000fe20004000000ULL,
0x0000001fff587424ULL, 0x000fc400078e00ffULL, 0xffffffffff5d7424ULL, 0x000fc400078e00ffULL,
0x0000040000007944ULL, 0x000fea0003c00000ULL, 0x000000585400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0059ULL, 0x00000002001a7802ULL, 0x000fe20000000f00ULL,
0xffffffffff5d7424ULL, 0x000fe200078e00ffULL, 0x0000005458517208ULL, 0x000fe20004000000ULL,
0x0000001fff587424ULL, 0x000fe200078e00ffULL, 0x0001b17000527802ULL, 0x000fc40000000f00ULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x000000585900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e005bULL, 0x0001b1f000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff1a7424ULL, 0x000fe200078e00ffULL, 0x0000005958577208ULL, 0x000fe20004000000ULL,
0x0000001fff587424ULL, 0x000fc400078e00ffULL, 0xffffffffff5d7424ULL, 0x000fc400078e00ffULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0x000000585b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0005ULL, 0x00000001001a7802ULL, 0x000fe20000000f00ULL,
0xffffffffff5d7424ULL, 0x000fe200078e00ffULL, 0x0000005b58047208ULL, 0x000fe20004000000ULL,
0x0000001fff587424ULL, 0x000fe200078e00ffULL, 0x0001b27000527802ULL, 0x000fc40000000f00ULL,
0x0000028000007944ULL, 0x000fea0003c00000ULL, 0x000000580500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0051ULL, 0x0001b2f000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff1a7424ULL, 0x000fe200078e00ffULL, 0x0000000558057208ULL, 0x000fe20004000000ULL,
0x0000001fff587424ULL, 0x000fc400078e00ffULL, 0xffffffffff5d7424ULL, 0x000fc400078e00ffULL,
0x0000020000007944ULL, 0x000fea0003c00000ULL, 0x000000585100720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0057ULL, 0x00000001001a7802ULL, 0x000fe20000000f00ULL,
0xffffffffff5d7424ULL, 0x000fe200078e00ffULL, 0x0000005158067208ULL, 0x000fe20004000000ULL,
0x0000001fff587424ULL, 0x000fe200078e00ffULL, 0x0001b37000527802ULL, 0x000fc40000000f00ULL,
0x0000018000007944ULL, 0x000fea0003c00000ULL, 0xffffd92000007947ULL, 0x000fea000383ffffULL,
0x0180000004007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000000400008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff077807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000007ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff04ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000004047812ULL, 0x002fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000007ff7212ULL, 0x000fda000780c0ffULL,
0x0080000004000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0004ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000400007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffe4b1006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff537424ULL, 0x000fe200078e00ffULL,
0x0000005d00007348ULL, 0x000fe80003800000ULL, 0x0c00001a07587389ULL, 0x0002a200000e0058ULL,
0xfffe4ad052007950ULL, 0x000fea0003c3ffffULL, 0x0000002100007348ULL, 0x000fe80003800000ULL,
0x0000001e201e7389ULL, 0x0002a400000e0067ULL, 0x000000ffff207224ULL, 0x002fc400078e001fULL,
0x00000000ff217424ULL, 0x000fc800078e00ffULL, 0xfffe4a8020007950ULL, 0x000fea0003c3ffffULL,
0x000000011e00780cULL, 0x000fe20003f45070ULL, 0x00000000ff217424ULL, 0x000fe200078e00ffULL,
0x0000001f00007348ULL, 0x000ff60003800000ULL, 0x00000000001e7806ULL, 0x000fc800050e0100ULL,
0x0000001f1e1e7212ULL, 0x000fe200078ec0ffULL, 0xfffe4a2020007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000100000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x00000000000004c4ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000620ULL,
0x0000000000000240ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000860ULL,
0x0000000000000260ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ac0ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b80ULL,
0x00000000000006d0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001250ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001260ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012f0ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012f4ULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001500ULL,
0x000000000001b680ULL, 0xde00001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001cb80ULL,
0x0000000000000038ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001cbc0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001cf40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000012f0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001b890ULL,
0x000000000001b890ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001cb80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001cf40ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_0_m_32_sm_80_cubin_len = 118816;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
