/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000017540ULL, 0x00000000000171c0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL,
0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL,
0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL,
0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL,
0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c00010000028dULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00010000036fULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b0022000003b5ULL, 0x0000000000015930ULL, 0x0000000000000170ULL, 0x000b0022000003e8ULL,
0x0000000000015aa0ULL, 0x0000000000000040ULL, 0x000b002200000413ULL, 0x0000000000015ae0ULL,
0x0000000000000050ULL, 0x000b00220000043dULL, 0x0000000000015b30ULL, 0x0000000000000150ULL,
0x000a0003000004abULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000004cbULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004fbULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000015c80ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001593000000000ULL, 0x0000040400000000ULL, 0x810c000001740400ULL,
0x0054c80400288080ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL,
0x8e082880808c0828ULL, 0x2880808f08288080ULL, 0x809a082880809808ULL, 0x08288080b4082880ULL,
0x80808808288080bbULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808892ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001593000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8e082880808a0828ULL,
0x2880808f08288080ULL, 0x8098082880809008ULL, 0x082880809a082880ULL, 0x80808c08288080b4ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808c92ULL, 0x0000001cffffffffULL,
0x0000010800000000ULL, 0x00015aa000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8c082880808a0828ULL, 0x2880808e08288080ULL,
0x809a082880809808ULL, 0x08288080b4082880ULL, 0x808280162880808fULL, 0x0000000000031028ULL,
0x2880808f92000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL, 0x000001a000000000ULL,
0x00015ae000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL, 0x808e2880808f0900ULL,
0x0000000000002880ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8c082880808a0828ULL,
0x2880808f08288080ULL, 0x809a082880809808ULL, 0x08288080b4082880ULL, 0x808280162880808eULL,
0x0000000000031028ULL, 0x2880808e92000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x0000024800000000ULL, 0x00015b3000000000ULL, 0x0000015000000000ULL, 0x0000000000000000ULL,
0x0000001800082f04ULL, 0x0008230400000080ULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL,
0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL, 0x0000000000000012ULL,
0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL, 0x0000001100082304ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008230400000000ULL,
0x0000000000000018ULL, 0x0000001800081204ULL, 0x0008110400000000ULL, 0x0000000000000018ULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0068016000000015ULL, 0x000c170400681903ULL,
0x0060000a00000000ULL, 0x000c17040021f000ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040081f000ULL,
0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0x00000b2000043104ULL, 0xffffffff01542904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000033001542804ULL, 0x00000540000003c0ULL,
0x00002d5000001c20ULL, 0x00002f1000002df0ULL, 0x0000327000003070ULL, 0x00003310000032a0ULL,
0x00003a7000003380ULL, 0x00004a50000049c0ULL, 0x00004ce000004b80ULL, 0x00004f2000004ef0ULL,
0x0000500000004f90ULL, 0x000063f0000053e0ULL, 0x000065b000006480ULL, 0x0000692000006710ULL,
0x000069c000006950ULL, 0x00006e4000006a30ULL, 0x00007ed000007e30ULL, 0x0000816000008000ULL,
0x000083a000008370ULL, 0x0000848000008410ULL, 0x000089e0000089d0ULL, 0x0000ad900000ad50ULL,
0x0000b5200000b4e0ULL, 0x00013ef000013eb0ULL, 0x00013f1000013f00ULL, 0x00013f8000013f60ULL,
0x00013fb000013fa0ULL, 0x00014c5000014c00ULL, 0x00014d2000014cc0ULL, 0x00014e0000014d90ULL,
0x00014eb000014e60ULL, 0x00014f8000014f20ULL, 0x0001506000014ff0ULL, 0x00015110000150c0ULL,
0x000151e000015180ULL, 0x000152c000015250ULL, 0x0001537000015320ULL, 0x00015440000153e0ULL,
0x00015520000154b0ULL, 0x0001560000015590ULL, 0x0001570000015680ULL, 0x0001580000015780ULL,
0x0001590000015880ULL, 0x0000044002003904ULL, 0x0001b600000000ffULL, 0x00000490003f0100ULL,
0x0001b6080000000fULL, 0x00000510003f0120ULL, 0x0001b6880000000fULL, 0x00000b40003f0120ULL,
0x0001b600000000ffULL, 0x00000d40003f0107ULL, 0x0001b68c0000006eULL, 0x00000de0003f0102ULL,
0x0001b6880000006eULL, 0x00002a60003f0101ULL, 0x0001b6080000000aULL, 0x00002a80003f0101ULL,
0x0001b60c0000000aULL, 0x00002c50003f0105ULL, 0x0001b60c0000000aULL, 0x000039f0003f0105ULL,
0x0001b6880000004eULL, 0x00004720003f0101ULL, 0x0001b62800000034ULL, 0x00004740003f0101ULL,
0x0001b62c00000034ULL, 0x00004910003f0105ULL, 0x0001b62c00000034ULL, 0x00005390003f0105ULL,
0x000000000000000eULL, 0x00006150003f0101ULL, 0x0001b64800000009ULL, 0x00006170003f0101ULL,
0x0001b64c00000009ULL, 0x00006340003f0105ULL, 0x0001b64c00000009ULL, 0x00006e20003f0105ULL,
0x000000000000000cULL, 0x00007b90003f0101ULL, 0x0001b6680000001eULL, 0x00007bb0003f0101ULL,
0x0001b66c0000001eULL, 0x00007d80003f0105ULL, 0x0001b66c0000001eULL, 0x00008870003f0105ULL,
0x0000000000000008ULL, 0x0000c700003f0101ULL, 0x0001b600000000ffULL, 0x0000df60003f0101ULL,
0x0001b604000000ffULL, 0x0000e170003f0105ULL, 0x0001b604000000ffULL, 0x00012250003f0105ULL,
0x0000000000000073ULL, 0x00012340003f0101ULL, 0x0000000400000073ULL, 0x00012510003f0105ULL,
0x0000000400000073ULL, 0x00014a50003f0105ULL, 0x0001b60800000074ULL, 0x00014ab0003f0101ULL,
0x0001b61000000074ULL, 0x00014b10003f0101ULL, 0x0001b61800000074ULL, 0x00014b80003f0101ULL,
0x0001b62000000074ULL, 0x00033803003f0101ULL, 0x0000bd7000201c04ULL, 0x0000c0300000bda0ULL,
0x0000c4200000c220ULL, 0x0000e1d00000c5d0ULL, 0x0000040100014bc0ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x00000000000002ccULL, 0x0000001800000002ULL, 0x0000000000000224ULL, 0x0000001800000002ULL,
0x000000000000018cULL, 0x0000001800000002ULL, 0x00000000000000f4ULL, 0x0000001800000002ULL,
0x0000000000000044ULL, 0x0000001800000002ULL, 0x00000000000002a3ULL, 0x0000001800000002ULL,
0x00000000000001fbULL, 0x0000001800000002ULL, 0x0000000000000168ULL, 0x0000001800000002ULL,
0x00000000000000d0ULL, 0x0000001800000002ULL, 0x000000000001b700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000797919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff0a0424ULL, 0x000fe200078e00ffULL,
0x0000000179020810ULL, 0x002fca0007ffe0ffULL, 0x00005c0002020625ULL, 0x000fc800078e000aULL,
0x00005c00790a0625ULL, 0x000fe200078e000aULL, 0x0000000602090981ULL, 0x0002aa000c1e1900ULL,
0x000000060a0a0981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff777624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000727919ULL, 0x000e620000002600ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x00005a00ff117624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x008ee40000002300ULL,
0x0000590011117a24ULL, 0x000fe200078e02ffULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00047810ULL, 0x010fcc0007ffe0ffULL, 0x0000000400057305ULL, 0x000864000021f000ULL,
0x000000ffff047224ULL, 0x010fe400078e00ffULL, 0x000000ffff077224ULL, 0x002fc800078e0a05ULL,
0x0000590007077a24ULL, 0x000fc800078e02ffULL, 0x0000000705057227ULL, 0x000fcc00078e0004ULL,
0x00000400050d7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff027224ULL, 0x000fc800078e0a0dULL,
0x0000040002007624ULL, 0x000fca00078e0277ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d1810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x000000010d0d2810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff0dba12ULL, 0x000fc800078e33ffULL, 0x0000000d00007306ULL, 0x000e620000209000ULL,
0x000000ff0d00720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000030d047224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000ee40000002200ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000007203717227ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000e640000002100ULL, 0x000000ffff007224ULL, 0x000fc800078e0a71ULL,
0x000000000d007224ULL, 0x000fca00078e0272ULL, 0x0000000d0000720cULL, 0x000fe20003f66070ULL,
0x000001000b027a24ULL, 0x008fe400078e0204ULL, 0x00001fff0b0b7589ULL, 0x000ff400000e0000ULL,
0x000000000d003210ULL, 0x000fe20007ffe1ffULL, 0x00000000020f7a24ULL, 0x002fe200078e0203ULL,
0x0000000171713810ULL, 0x000fc40007ffe0ffULL, 0x0000000d0000720cULL, 0x000fe40003f86070ULL,
0x000000ff0f00720cULL, 0x040fe40003f25270ULL, 0x00000005ff027819ULL, 0x000fe40000011603ULL,
0x0000000f0f00780cULL, 0x040fe40003f44070ULL, 0x000000030f00780cULL, 0x000fe40003f64070ULL,
0x00001fff02027589ULL, 0x000e6600000e0000ULL, 0x0000000171714810ULL, 0x000fc40007ffe0ffULL,
0x0000000dff71d212ULL, 0x000fe200078e33ffULL, 0x3fffff80ff049424ULL, 0x000fe200078e00ffULL,
0x0000007f0f00780cULL, 0x000fe20003f84070ULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x000fe400078e0a71ULL, 0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL,
0x01b60004ff009388ULL, 0x0007e20000000a00ULL, 0x000000080d727224ULL, 0x000fe400078e0272ULL,
0x7fffffc0ff07a424ULL, 0x000fc400078e00ffULL, 0x0000001072727824ULL, 0x000fe400078e00ffULL,
0xff317217ff0cc424ULL, 0x000fe200078e00ffULL, 0x01b608060f00a388ULL, 0x000fe20000008a00ULL,
0x3fffff60ff08b424ULL, 0x000fc600078e00ffULL, 0x01b4000c0f00c388ULL, 0x000fe20000004800ULL,
0x0000000109000824ULL, 0x004fe200078e0a0aULL, 0x7fffff600009b802ULL, 0x000fe20000000f00ULL,
0x00005800ff008624ULL, 0x000fe400078e00ffULL, 0x00005800790a8a24ULL, 0x000fe400078e02ffULL,
0x00005a0000037a24ULL, 0x000fe200078e02ffULL, 0x01b688080f00b388ULL, 0x000fe20000008a00ULL,
0x000000110a747224ULL, 0x000fe400078e02ffULL, 0x0000000103047824ULL, 0x048fe200078e0a72ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000720300720cULL, 0x000fe20003f26070ULL,
0x00000004ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000001004047817ULL, 0x000fe20003800000ULL,
0x00005a0071137a24ULL, 0x000fc600078e0274ULL, 0x000000ff04737207ULL, 0x000fe20000800000ULL,
0x000000040b047824ULL, 0x002fc600078e0202ULL, 0x000000107300780cULL, 0x000fe20003f05270ULL,
0x0000000204047824ULL, 0x000fd800078e00ffULL, 0x000002c000008947ULL, 0x000fea0003800000ULL,
0x00005a00000c7b06ULL, 0x000e620000209000ULL, 0x0000000000057919ULL, 0x000ea20000000000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fca0003f45070ULL,
0x0000000c000c7308ULL, 0x002e620000001000ULL, 0x00000004ff097819ULL, 0x004fca0000011605ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x0ffffffe0c077810ULL, 0x002fe20007ffe0ffULL,
0x00000010050c7824ULL, 0x000fca00078e00ffULL, 0x0000000700077305ULL, 0x000e64000021f000ULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a07ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d070d7227ULL, 0x000fe200078e0006ULL, 0x0000000872067210ULL, 0x000fca0007ffe0ffULL,
0x000000060d0d7227ULL, 0x000fc800078e00ffULL, 0x000000ffff0f7224ULL, 0x000fc800078e0a0dULL,
0x00005a000f077a24ULL, 0x000fca00078e0206ULL, 0x00005a0007007a0cULL, 0x000fda0003f06070ULL,
0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d0810ULL, 0x000fe40007ffe0ffULL,
0x00005a0007007a0cULL, 0x000fda0003f26070ULL, 0x000000010d0d1810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff0daa12ULL, 0x000fca00078e33ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a0dULL,
0x00005a0007067a24ULL, 0x000fe200078e0206ULL, 0x0000000473077217ULL, 0x000fc60007800000ULL,
0x0000000113067824ULL, 0x000fe400078e0206ULL, 0x0000000107047824ULL, 0x000fe400078e0a04ULL,
0x000000110d067224ULL, 0x000fe200078e0206ULL, 0x000000f00c0d7812ULL, 0x000fe400078ec0ffULL,
0x000000040900720cULL, 0x000fe20003f06070ULL, 0x0000010006067825ULL, 0x000fc800078e00ffULL,
0x0000000108047824ULL, 0x000fe200078e0205ULL, 0x0000000d060d7212ULL, 0x000fe200078efcffULL,
0x0000001008097824ULL, 0x000fc600078e00ffULL, 0x000060000d067a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff009047812ULL, 0x000fe400078ee204ULL, 0x0000610007077a10ULL, 0x000fc60000ffe4ffULL,
0x0000001004097824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c46ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x00005a0000087b06ULL, 0x000e620000209000ULL, 0x0000000000057919ULL, 0x000ea20000000000ULL,
0x000000ff00067202ULL, 0x000fe40000000f00ULL, 0x00005a00ff007a0cULL, 0x000fc80003f45070ULL,
0x0000000800087308ULL, 0x002e620000001000ULL, 0x0000000405047211ULL, 0x004fe400078fe0ffULL,
0x0ffffffe080c7810ULL, 0x002fca0007ffe0ffULL, 0x0000000c00077305ULL, 0x0002a4000021f000ULL,
0x00000010050c7824ULL, 0x002fe400078e00ffULL, 0x000000ffff097224ULL, 0x004fc800078e0a07ULL,
0x00005a0009097a24ULL, 0x000fc800078e02ffULL, 0x0000000907077227ULL, 0x000fc800078e0006ULL,
0x0000000172067824ULL, 0x000fc800078e0204ULL, 0x0000000607077227ULL, 0x000fc800078e00ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a07ULL, 0x00005a0009087a24ULL, 0x000fca00078e0206ULL,
0x00005a0008007a0cULL, 0x000fda0003f06070ULL, 0x80005a0008080a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x00005a0008007a0cULL, 0x000fe20003f26070ULL,
0x0000000104087824ULL, 0x000fd800078e0205ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff07aa12ULL, 0x000fca00078e33ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a07ULL,
0x00005a0009067a24ULL, 0x000fe200078e0206ULL, 0x000000f00c097812ULL, 0x000fc600078ec0ffULL,
0x0000000113067824ULL, 0x000fc800078e0206ULL, 0x0000001107067224ULL, 0x000fc800078e0206ULL,
0x0000010006067825ULL, 0x000fca00078e00ffULL, 0x0000000906067212ULL, 0x000fe200078efcffULL,
0x0000001004097824ULL, 0x000fc600078e00ffULL, 0x0000600006067a10ULL, 0x000fe40007f1e0ffULL,
0xfffffff009087812ULL, 0x000fe400078ee208ULL, 0x0000610007077a10ULL, 0x000fc600007fe4ffULL,
0x0000001008097824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e4000b901c46ULL, 0x0000000000077919ULL, 0x002e620000000000ULL,
0x0000000000047806ULL, 0x000fe400038e0000ULL, 0x0000000400547802ULL, 0x000fe20000000f00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400067300ULL, 0x000e7000000e0000ULL,
0x0000000400087309ULL, 0x000ea20000000000ULL, 0x000000070600720cULL, 0x002fe20003f02070ULL,
0x0000680079067625ULL, 0x000fc800078e0054ULL, 0x000000ffff087224ULL, 0x004fd000078e0a08ULL,
0x01b60408ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000606697981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000007f696d7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff695e7810ULL, 0x000fc40007ffe0ffULL, 0x00000007ff6d7819ULL, 0x000fe4000001166dULL,
0x00000008ff5e7819ULL, 0x000fca000001165eULL, 0x0000b96000008947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe20000011602ULL, 0x00000008026e7824ULL, 0x000fe400078e00ffULL,
0xffffffffff597424ULL, 0x000fe200078e00ffULL, 0x01ffffff00007812ULL, 0x000fca00078ec0ffULL,
0x00000002030b7824ULL, 0x000fca00078e0200ULL, 0x0000006d0b00720cULL, 0x000fda0003f06070ULL,
0x0000000279008824ULL, 0x000fe400078e00ffULL, 0x00006a00ff078624ULL, 0x000fc800078e00ffULL,
0x00006a0000008624ULL, 0x000fe400078e0207ULL, 0x00000003ff077424ULL, 0x000fe400078e00ffULL,
0x000000010b558824ULL, 0x000fe200078e0200ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b68c076eff738cULL, 0x0005e20000000000ULL, 0x0000660055548625ULL, 0x000fe200078e0054ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000654598981ULL, 0x000ee2000c1e1900ULL,
0x0000000103077810ULL, 0x004fe40007ffe0ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011602ULL,
0x01b688006eff7f8cULL, 0x0005e2000c80043fULL, 0x0000005e0700720cULL, 0x000fe20003f06070ULL,
0x00000100ff077424ULL, 0x000fe200078e00ffULL, 0x0000000771687819ULL, 0x000fe200000006ffULL,
0x000000200a6f7824ULL, 0x000fe200078e00ffULL, 0x00000001026b7812ULL, 0x000fc600078ec0ffULL,
0x00000100030d7824ULL, 0x000fe400078e026fULL, 0x0000590059007a24ULL, 0x008fc800078e02ffULL,
0x0000008000067824ULL, 0x000fe200078e00ffULL, 0x0000006068007812ULL, 0x000fc600078ef80dULL,
0x0000640006067625ULL, 0x000fe200078e0007ULL, 0x0000064000008947ULL, 0x000fea0003800000ULL,
0x00000003ff197819ULL, 0x004fe20000011605ULL, 0x000000020a1a7824ULL, 0x000fe200078e026bULL,
0x0000000d69047217ULL, 0x000fe40007800000ULL, 0x0000000419097810ULL, 0x040fe40007ffe0ffULL,
0x0000000819117810ULL, 0x040fe20007ffe0ffULL, 0x0000000104047824ULL, 0x000fe200078e0a0dULL,
0x0000000c19177810ULL, 0x000fe20007ffe0ffULL, 0x0000000109087824ULL, 0x102fe200078e0205ULL,
0x0000001419257810ULL, 0x000fe20007ffe0ffULL, 0x00000008091d7824ULL, 0x000fe200078e00ffULL,
0x0000002004047817ULL, 0x000fe20003800000ULL, 0x00000001110d7824ULL, 0x100fe200078e0205ULL,
0x00000010191b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000811107824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee208ULL, 0x00000001170e7824ULL, 0x040fe200078e0205ULL,
0x000000700c087812ULL, 0x000fe200078ec0ffULL, 0x0000000817217824ULL, 0x000fe200078e00ffULL,
0xfffffff8101f7812ULL, 0x000fe200078ee20dULL, 0x00000001000f7824ULL, 0x040fe200078e0209ULL,
0x000000086b087211ULL, 0x000fe200078e38ffULL, 0x00000001000d7824ULL, 0x000fe200078e0219ULL,
0x000000040900720cULL, 0x080fe20003f86070ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee20eULL, 0x0000000125137824ULL, 0x000fe200078e0205ULL,
0x000000041100720cULL, 0x080fe20003f66070ULL, 0x000001000d0c7825ULL, 0x000fe200078e0008ULL,
0x000000041700720cULL, 0x000fc40003f46070ULL, 0x000130001a1a7811ULL, 0x000fe200078e68ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0008ULL, 0x0000000c06127210ULL, 0x040fe40007f1e0ffULL,
0x000000041900720cULL, 0x000fe20003fa6070ULL, 0x0000000825167824ULL, 0x000fe200078e00ffULL,
0x0000000e06147210ULL, 0x000fe20007f3e0ffULL, 0x000000011b107824ULL, 0x000fe200078e0205ULL,
0x0000001c192b7810ULL, 0x000fe20007ffe0ffULL, 0x000000081b237824ULL, 0x000fe200078e00ffULL,
0xfffffff816277812ULL, 0x000fe200078ee213ULL, 0x0000000107137824ULL, 0x040fe200000e060dULL,
0x00000011000d7210ULL, 0x040fe20007ffe0ffULL, 0x0000000107157824ULL, 0x000fe200008e060fULL,
0xfffffff823237812ULL, 0x000fe200078ee210ULL, 0x00000001000f7824ULL, 0x000fe200078e0217ULL,
0x000000041b00720cULL, 0x000fe20003f26070ULL, 0x0000000119107824ULL, 0x000fe200078e0205ULL,
0x0000001a1d1d7211ULL, 0x080fe200078e20ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0008ULL,
0x0000001a21217211ULL, 0x000fc400078e20ffULL, 0x0000000710167812ULL, 0x000fe200078ec0ffULL,
0x000001000d0c7825ULL, 0x000fe200078e0008ULL, 0x0000000e060e7210ULL, 0x000fe40007fde0ffULL,
0x0ffffff816177812ULL, 0x000fe200078ef805ULL, 0x0000000100117824ULL, 0x000fe200078e021bULL,
0x0000000c060c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001070f7824ULL, 0x000fe400030e060fULL,
0x0000010011107825ULL, 0x000fc800078e0008ULL, 0x00000001070d7824ULL, 0x000fe200000e060dULL,
0x0000001006167210ULL, 0x000fe20007fde0ffULL, 0x00000010171b7824ULL, 0x000fe200078e021aULL,
0x000000042500720cULL, 0x000fe20003f06070ULL, 0x0000000100257824ULL, 0x040fe400078e0225ULL,
0x0000000107177824ULL, 0x000fe200030e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121b7faeULL, 0x0003e2000e901c46ULL, 0x0000010025107825ULL, 0x000fe200078e0008ULL,
0x0000001819257810ULL, 0x000fe40007ffe0ffULL, 0x00000000141d7faeULL, 0x0005e2000e101c46ULL,
0x00000001002d7824ULL, 0x000fe200078e022bULL, 0x0000001006187210ULL, 0x000fe20007fde0ffULL,
0x0000000100297824ULL, 0x000fe200078e0225ULL, 0x000000042500720cULL, 0x0c0fe20003fa6070ULL,
0x0000000125007824ULL, 0x000fe200078e0205ULL, 0x000000042b00720cULL, 0x000fe20003f86070ULL,
0x0000000107197824ULL, 0x000fc400030e0611ULL, 0x0000010029107825ULL, 0x000fc800078e0008ULL,
0x0000000825137824ULL, 0x002fe200078e00ffULL, 0x0000001006107210ULL, 0x000fe20007fde0ffULL,
0x000000012b047824ULL, 0x040fe400078e0205ULL, 0x000000082b157824ULL, 0x004fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee200ULL, 0x000001002d087825ULL, 0x000fc600078e0008ULL,
0xfffffff815157812ULL, 0x000fe200078ee204ULL, 0x0000000107117824ULL, 0x000fe200030e0611ULL,
0x0000000806067210ULL, 0x000fe20007fde0ffULL, 0x000000101f1f7824ULL, 0x100fe400078e021aULL,
0x0000001023237824ULL, 0x100fe400078e021aULL, 0x0000001027277824ULL, 0x100fe200078e021aULL,
0x000000000c1f7faeULL, 0x0003e2000d901c46ULL, 0x0000001013137824ULL, 0x100fe400078e021aULL,
0x0000001015157824ULL, 0x000fe200078e021aULL, 0x000000000e217faeULL, 0x0003e2000d101c46ULL,
0x0000000107077824ULL, 0x000fc600030e0609ULL, 0x0000000016237faeULL, 0x0003e8000c901c46ULL,
0x0000000018277faeULL, 0x0003e8000c101c46ULL, 0x0000000010137faeULL, 0x0003e8000e901c46ULL,
0x0000000006157faeULL, 0x0003e2000e101c46ULL, 0x0000057000007947ULL, 0x000fea0003800000ULL,
0x0000000805097811ULL, 0x044fe200078fe8ffULL, 0x000000020a167824ULL, 0x000fe200078e026bULL,
0x0000000405087811ULL, 0x002fc400078fe8ffULL, 0x0000001005107811ULL, 0x000fe200078fe8ffULL,
0x00000001090d7824ULL, 0x100fe200078e0205ULL, 0x0000001405127811ULL, 0x000fe200078fe8ffULL,
0x00000008091c7824ULL, 0x000fe200078e00ffULL, 0x0000000c050e7811ULL, 0x040fe200078fe8ffULL,
0x0000000108047824ULL, 0x040fe200078e0205ULL, 0x0000001805147811ULL, 0x040fe200078fe8ffULL,
0x00000008080f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee20dULL,
0x00000001100d7824ULL, 0x100fe200078e0205ULL, 0x000000700c187812ULL, 0x000fe200078ec0ffULL,
0x0000000810207824ULL, 0x000fe200078e00ffULL, 0x0000001c050c7811ULL, 0x000fe200078fe8ffULL,
0x0000000812227824ULL, 0x040fe200078e00ffULL, 0xfffffff80f1a7812ULL, 0x000fe200078ee204ULL,
0x00000001120f7824ULL, 0x000fe200078e0205ULL, 0xfffffff820207812ULL, 0x000fe200078ee20dULL,
0x000000080e137824ULL, 0x040fe200078e00ffULL, 0x000000050e047210ULL, 0x080fe20007ffe0ffULL,
0x0000000114117824ULL, 0x000fe200078e0205ULL, 0x00000008000d7210ULL, 0x000fe20007ffe0ffULL,
0x0000000814247824ULL, 0x000fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee20fULL,
0x000000010c087824ULL, 0x040fe200078e0205ULL, 0xfffffff8131e7812ULL, 0x000fe200078ee204ULL,
0x000000080c197824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee211ULL,
0x00000001000f7824ULL, 0x040fe200078e0209ULL, 0x0000000005097211ULL, 0x040fe200078fe8ffULL,
0x0000000100117824ULL, 0x040fe200078e020eULL, 0x0000000505047211ULL, 0x000fe200078fe8ffULL,
0x0000000100137824ULL, 0x000fe200078e0210ULL, 0x0001300016297811ULL, 0x000fe200078e68ffULL,
0x0000000100157824ULL, 0x000fe200078e0212ULL, 0x0000000704047812ULL, 0x000fe200078ec0ffULL,
0x0000000100177824ULL, 0x000fc400078e0214ULL, 0x00000001001b7824ULL, 0x000fe200078e020cULL,
0xfffffff819007812ULL, 0x000fe200078ee208ULL, 0x000000806b187824ULL, 0x000fe200078e0218ULL,
0x0ffffff804047812ULL, 0x000fe200078ef805ULL, 0x000000ffff197224ULL, 0x000fe400078e00ffULL,
0x000000101a1d7824ULL, 0x000fe400078e0229ULL, 0x0000010009087825ULL, 0x000fc800078e0018ULL,
0x000001000d0c7825ULL, 0x000fe200078e0018ULL, 0x0000000806087210ULL, 0x000fc60007f1e0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0018ULL, 0x0000000c060c7210ULL, 0x000fc60007f3e0ffULL,
0x0000010011107825ULL, 0x000fe200078e0018ULL, 0x0000000e060e7210ULL, 0x000fc60007f5e0ffULL,
0x0000010013127825ULL, 0x100fe200078e0018ULL, 0x0000001006107210ULL, 0x000fe40007f7e0ffULL,
0x0000000f070f7210ULL, 0x000fe200017fe4ffULL, 0x0000010015147825ULL, 0x000fc800078e0018ULL,
0x0000010017167825ULL, 0x000fc800078e0018ULL, 0x000001001b187825ULL, 0x000fe200078e0018ULL,
0x00000029041b7211ULL, 0x000fe400078e20ffULL, 0x0000001606167210ULL, 0x040fe20007f5e0ffULL,
0x0000000107097824ULL, 0x040fe200000e0609ULL, 0x0000001206127210ULL, 0x040fe20007f1e0ffULL,
0x00000001070d7824ULL, 0x040fe200008e060dULL, 0x0000001406147210ULL, 0x040fe20007f3e0ffULL,
0x0000000107117824ULL, 0x000fe200018e0611ULL, 0x0000001806067210ULL, 0x000fe20007f7e0ffULL,
0x000000101c1f7824ULL, 0x100fe200078e0229ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000081b7faeULL, 0x0003e2000b901c46ULL, 0x000000101e217824ULL, 0x000fc400078e0229ULL,
0x0000001020237824ULL, 0x000fe200078e0229ULL, 0x000000000c1d7faeULL, 0x0003e2000b901c46ULL,
0x0000000107137824ULL, 0x040fe400000e0613ULL, 0x0000001022257824ULL, 0x000fe200078e0229ULL,
0x000000000e1f7faeULL, 0x0003e2000b901c46ULL, 0x0000000107157824ULL, 0x040fe400008e0615ULL,
0x0000001024277824ULL, 0x000fe200078e0229ULL, 0x0000000010217faeULL, 0x0003e2000b901c46ULL,
0x0000000107177824ULL, 0x000fc400010e0617ULL, 0x0000001000297824ULL, 0x000fe200078e0229ULL,
0x0000000012237faeULL, 0x0003e2000b901c46ULL, 0x0000000107077824ULL, 0x000fc600018e0619ULL,
0x0000000014257faeULL, 0x0003e8000b901c46ULL, 0x0000000016277faeULL, 0x0003e8000b901c46ULL,
0x0000000006297faeULL, 0x0003e4000b901c46ULL, 0x0000005e0300720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff0c7424ULL, 0x002fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00006d0000000947ULL, 0x000fea0003800000ULL,
0x00000002796c7824ULL, 0x000fe200078e00ffULL, 0xff317217000c7802ULL, 0x000fe20000000f00ULL,
0x00006a00ff097624ULL, 0x000fc400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fe400078e00ffULL,
0x00006a006c6c7624ULL, 0x000fc400078e0209ULL, 0x0000001002087824ULL, 0x000fe200078e00ffULL,
0x0000000103097810ULL, 0x000fe20007ffe0ffULL, 0x0000590059597a24ULL, 0x010fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe008087812ULL, 0x000fe400078ec0ffULL,
0x0000005e0900720cULL, 0x000fe20003f06070ULL, 0x00000100ff097424ULL, 0x000fe400078e00ffULL,
0x0000010003087824ULL, 0x000fca00078e0208ULL, 0x0000004008247810ULL, 0x020fe20007ffe0ffULL,
0x0000008059087824ULL, 0x000fc600078e00ffULL, 0x00000060240d7812ULL, 0x000fe200078ec0ffULL,
0x0000640008087625ULL, 0x000fc800078e0009ULL, 0x0000000168307824ULL, 0x000fe200078e020dULL,
0x0000068000008947ULL, 0x000fea0003800000ULL, 0x00000010050f7824ULL, 0x000fe200078e00ffULL,
0x00000024690d7217ULL, 0x000fe20007800000ULL, 0x00000080020e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff387819ULL, 0x000fe40000011605ULL, 0x000000700f257812ULL, 0x000fe200078ec0ffULL,
0x000000010d0f7824ULL, 0x000fe200078e0a24ULL, 0x0000000438287810ULL, 0x000fe40007ffe0ffULL,
0x0000000d020d7819ULL, 0x000fc400000006ffULL, 0x0000000838367810ULL, 0x000fe20007ffe0ffULL,
0x0000000128247824ULL, 0x140fe200078e0205ULL, 0x00000080250e7812ULL, 0x000fe200078ef80eULL,
0x0000000828397824ULL, 0x000fe200078e00ffULL, 0x000020000d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000136257824ULL, 0x000fe200078e0205ULL, 0x0000000c383a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000836267824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee224ULL,
0x000040000a347824ULL, 0x000fe200078e020dULL, 0x000000200f337817ULL, 0x000fe20003800000ULL,
0x000000013a317824ULL, 0x000fe200078e0205ULL, 0xfffffff8260d7812ULL, 0x000fe200078ee225ULL,
0x000000083a247824ULL, 0x000fe200078e00ffULL, 0x00000010383c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000138257824ULL, 0x040fe200078e0230ULL, 0x00000014383e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0xfffffff824317812ULL, 0x000fe200078ee231ULL,
0x000000013c327824ULL, 0x000fe200078e0205ULL, 0x000000053e0a7210ULL, 0x000fe20007ffe0ffULL,
0x0000010025247825ULL, 0x000fe200078e000eULL, 0x000000333a00720cULL, 0x000fc40003f26070ULL,
0x000000332800720cULL, 0x080fe20003f66070ULL, 0x000000083c277824ULL, 0x000fe200078e00ffULL,
0x00000024082a7210ULL, 0x000fe20007f5e0ffULL, 0x000000083e297824ULL, 0x000fe200078e00ffULL,
0x000000333600720cULL, 0x080fe20003f06070ULL, 0x0000000138267824ULL, 0x000fe200078e0205ULL,
0xfffffff827327812ULL, 0x000fe200078ee232ULL, 0x0000000128277824ULL, 0x000fe200078e0230ULL,
0xfffffff8290a7812ULL, 0x000fe200078ee20aULL, 0x0000000136297824ULL, 0x100fe200078e0230ULL,
0x0001400034367810ULL, 0x000fe20007ffe0ffULL, 0x000000013a357824ULL, 0x000fe200078e0230ULL,
0x00000007263a7812ULL, 0x000fe200078ec0ffULL, 0x00000001092b7824ULL, 0x000fe200010e0625ULL,
0x000000333800720cULL, 0x000fe20003f86070ULL, 0x0000010027247825ULL, 0x000fe200078e000eULL,
0x0ffffff83a377812ULL, 0x000fc400078ef805ULL, 0x00000018383a7810ULL, 0x000fe20007ffe0ffULL,
0x0000010029267825ULL, 0x100fe200078e000eULL, 0x0000002408347210ULL, 0x000fe40007f5e0ffULL,
0x0000001c38387810ULL, 0x000fe20007ffe0ffULL, 0x0000010035287825ULL, 0x000fe200078e000eULL,
0x0000002608247210ULL, 0x000fc60007fbe0ffULL, 0x0000000109357824ULL, 0x000fe200010e0625ULL,
0x0000002808267210ULL, 0x000fe20007fde0ffULL, 0x0000001037377824ULL, 0x100fe200078e0236ULL,
0x0000002709257210ULL, 0x000fe20002ffe4ffULL, 0x0000001039397824ULL, 0x000fe200078e0236ULL,
0x000000333c00720cULL, 0x0c0fe20003f46070ULL, 0x0000000109277824ULL, 0x000fe200030e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a377faeULL, 0x0003e2000e101c46ULL,
0x000000013c297824ULL, 0x100fe200078e0230ULL, 0x000000333e00720cULL, 0x0c0fe20003fa6070ULL,
0x000000013e3b7824ULL, 0x000fe200078e0230ULL, 0x0000000034397faeULL, 0x0005e2000d901c46ULL,
0x0000010029287825ULL, 0x000fe200078e000eULL, 0x000000333a00720cULL, 0x000fc40003f86070ULL,
0x000000333800720cULL, 0x000fe20003f66070ULL, 0x000000013a337824ULL, 0x000fe200078e0230ULL,
0x0000002808287210ULL, 0x000fe20007fde0ffULL, 0x000000100d0d7824ULL, 0x000fe400078e0236ULL,
0x000001003b2a7825ULL, 0x002fe200078e000eULL, 0x000000033a397819ULL, 0x004fc600000006ffULL,
0x0000000109297824ULL, 0x000fe200030e0629ULL, 0x0000002a082a7210ULL, 0x000fe20007fde0ffULL,
0x0000010033347825ULL, 0x000fe200078e000eULL, 0x00000000240d7faeULL, 0x0003e6000c101c46ULL,
0x0000000138377824ULL, 0x000fe400078e0230ULL, 0x00000001092b7824ULL, 0x000fe200030e062bULL,
0x0000003408347210ULL, 0x000fe20007fde0ffULL, 0x000000013a307824ULL, 0x000fc400078e0205ULL,
0x0000000138337824ULL, 0x000fe400078e0205ULL, 0x00000100370e7825ULL, 0x000fe200078e000eULL,
0xfffffff839397812ULL, 0x000fc600078ee230ULL, 0x0000000838387824ULL, 0x000fe400078e00ffULL,
0x0000000109357824ULL, 0x000fe200030e0635ULL, 0x0000000e08087210ULL, 0x000fe20007fde0ffULL,
0x0000001031317824ULL, 0x100fe200078e0236ULL, 0xfffffff8383b7812ULL, 0x000fe200078ee233ULL,
0x0000001032337824ULL, 0x100fe400078e0236ULL, 0x000000100a377824ULL, 0x100fe200078e0236ULL,
0x000000363b3b7211ULL, 0x000fe200078e20ffULL, 0x0000001039397824ULL, 0x000fe200078e0236ULL,
0x0000000026317faeULL, 0x0003e2000c901c46ULL, 0x0000000109097824ULL, 0x000fc600030e060fULL,
0x0000000028337faeULL, 0x0003e8000d101c46ULL, 0x000000002a377faeULL, 0x0003e8000e901c46ULL,
0x0000000034397faeULL, 0x0003e8000e101c46ULL, 0x00000000083b7faeULL, 0x0003e2000d901c46ULL,
0x000005b000007947ULL, 0x000fea0003800000ULL, 0x00002000020e7824ULL, 0x040fe200078e00ffULL,
0x0000000405257811ULL, 0x040fe200078fe8ffULL, 0x00000010050d7824ULL, 0x040fe200078e00ffULL,
0x0000000805277811ULL, 0x000fe200078fe8ffULL, 0x0000008002347824ULL, 0x000fe200078e00ffULL,
0x000020000e0f7812ULL, 0x000fe200078ec0ffULL, 0x00000008252b7824ULL, 0x000fe200078e00ffULL,
0x000000700d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000827387824ULL, 0x000fe200078e00ffULL,
0x0000001405317811ULL, 0x000fe200078fe8ffULL, 0x000040000a0e7824ULL, 0x000fe200078e020fULL,
0x000000800d347812ULL, 0x000fe200078ef834ULL, 0x00000001250a7824ULL, 0x100fe200078e0205ULL,
0x0000000c05297811ULL, 0x000fe200078fe8ffULL, 0x00000001270d7824ULL, 0x000fe200078e0205ULL,
0x0000001805337811ULL, 0x000fe200078fe8ffULL, 0x00000008313e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82b367812ULL, 0x000fe200078ee20aULL, 0x00000008293a7824ULL, 0x000fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee20dULL, 0x00000001310d7824ULL, 0x000fe200078e0205ULL,
0x00000010052b7811ULL, 0x000fe200078fe8ffULL, 0x0000000833407824ULL, 0x000fe200078e00ffULL,
0x00000005290f7210ULL, 0x080fe20007ffe0ffULL, 0x0000000125257824ULL, 0x000fe200078e0230ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL, 0x000000012b0a7824ULL, 0x000fe200078e0205ULL,
0x0000001c050d7811ULL, 0x000fe200078fe8ffULL, 0x000000082b357824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee20fULL, 0x00000001330f7824ULL, 0x100fe200078e0205ULL,
0x0000003029297210ULL, 0x080fe20007ffe0ffULL, 0x000000010d247824ULL, 0x000fe200078e0205ULL,
0xfffffff8353c7812ULL, 0x000fe200078ee20aULL, 0x000000080d357824ULL, 0x000fe200078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee20fULL, 0x0000000127277824ULL, 0x100fe200078e0230ULL,
0x00000030050f7211ULL, 0x000fe200078fe8ffULL, 0x000000012b2b7824ULL, 0x000fe200078e0230ULL,
0xfffffff835427812ULL, 0x000fe200078ee224ULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x00000005050a7211ULL, 0x000fe200078fe8ffULL, 0x0000000131317824ULL, 0x000fe200078e0230ULL,
0x000140000e437810ULL, 0x000fe20007ffe0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0034ULL,
0x000000070a0a7812ULL, 0x000fc400078ec0ffULL, 0x0000004338397211ULL, 0x000fe200078e20ffULL,
0x0000010025247825ULL, 0x000fe200078e0034ULL, 0x0000000e080e7210ULL, 0x000fe40007f1e0ffULL,
0x0ffffff80a0a7812ULL, 0x000fe200078ef805ULL, 0x0000010027267825ULL, 0x000fe200078e0034ULL,
0x0000002408247210ULL, 0x000fc60007f3e0ffULL, 0x0000010029287825ULL, 0x000fe200078e0034ULL,
0x0000002608267210ULL, 0x000fc60007f5e0ffULL, 0x0000000133337824ULL, 0x100fe200078e0230ULL,
0x0000002808287210ULL, 0x000fe20007f7e0ffULL, 0x000000010d0d7824ULL, 0x000fe400078e0230ULL,
0x000001002b2a7825ULL, 0x000fc800078e0034ULL, 0x0000010031307825ULL, 0x000fc800078e0034ULL,
0x0000010033327825ULL, 0x000fc800078e0034ULL, 0x000001000d347825ULL, 0x000fc800078e0034ULL,
0x00000001090f7824ULL, 0x040fe200000e060fULL, 0x0000002a082a7210ULL, 0x040fe20007f1e0ffULL,
0x0000000109257824ULL, 0x040fe200008e0625ULL, 0x0000003008307210ULL, 0x000fe20007f3e0ffULL,
0x000000100a0d7824ULL, 0x000fe200078e0243ULL, 0x0000002b092b7210ULL, 0x040fe200007fe4ffULL,
0x0000000109277824ULL, 0x040fe200010e0627ULL, 0x0000003208327210ULL, 0x000fe20007f5e0ffULL,
0x0000001036377824ULL, 0x000fe200078e0243ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0d7faeULL, 0x0003e2000b901c46ULL, 0x0000000109297824ULL, 0x000fe200018e0629ULL,
0x0000003408087210ULL, 0x000fe20007f7e0ffULL, 0x000000103a3b7824ULL, 0x100fe200078e0243ULL,
0x0000000024377faeULL, 0x0003e2000b901c46ULL, 0x000000103c3d7824ULL, 0x000fc400078e0243ULL,
0x000000103e3f7824ULL, 0x000fe200078e0243ULL, 0x0000000026397faeULL, 0x0003e2000b901c46ULL,
0x0000000109317824ULL, 0x040fe400008e0631ULL, 0x0000001040417824ULL, 0x000fe200078e0243ULL,
0x00000000283b7faeULL, 0x0003e2000b901c46ULL, 0x0000000109337824ULL, 0x040fe400010e0633ULL,
0x0000001042437824ULL, 0x000fe200078e0243ULL, 0x000000002a3d7faeULL, 0x0003e2000b901c46ULL,
0x0000000109097824ULL, 0x000fc600018e0635ULL, 0x00000000303f7faeULL, 0x0003e8000b901c46ULL,
0x0000000032417faeULL, 0x0003e8000b901c46ULL, 0x0000000008437faeULL, 0x0003e4000b901c46ULL,
0x00000300ff087624ULL, 0x002fe200078e00ffULL, 0x000000010b097812ULL, 0x000fe200078ec0ffULL,
0xffffffffff4c7424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000010900780cULL, 0x000fc40003f05070ULL, 0xffffffff08087811ULL, 0x000fc800078e08ffULL,
0x0000000108087807ULL, 0x000fca0004000000ULL, 0x00000001080b7824ULL, 0x000fca00078e020bULL,
0x0000006d0b00720cULL, 0x000fda0003f06070ULL, 0x000000016c088824ULL, 0x000fe400078e020bULL,
0x00000004ff098424ULL, 0x000fc800078e00ffULL, 0x0000660008088625ULL, 0x000fca00078e0009ULL,
0x00000006084c8981ULL, 0x000322000c1e1900ULL, 0xffffffe06e0a7812ULL, 0x040fe400078ec0ffULL,
0x000000106e0d7812ULL, 0x040fe400078ec0ffULL, 0x000000086e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fe20007ffe00dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b608000a247f8cULL, 0x0022a4000c80043fULL, 0x0000000000087805ULL, 0x000fc40000015200ULL,
0x01b60c000a0d7984ULL, 0x000ee40000000800ULL, 0x800000000dff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff267224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e080e7210ULL, 0x000fc80007f1e1ffULL,
0x0000000f090f7210ULL, 0x000fe400007fe5ffULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc8000001140fULL,
0x0000000e0d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e060fULL,
0x000000020d0d7819ULL, 0x000fc8000000120eULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000126267810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b60c000a0d7984ULL, 0x000ea40000000800ULL,
0x800000000dff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010056a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff707819ULL, 0x000fe20000011605ULL,
0x00000020025c7824ULL, 0x000fc600078e00ffULL, 0x000000706a6a7812ULL, 0x000fe400078ec0ffULL,
0xffffff805c5c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c70707812ULL, 0x000fc800078ec0ffULL,
0x0000005c70087210ULL, 0x000fca0007ffe06aULL, 0x01b00000080d7984ULL, 0x000ea80000000800ULL,
0x01b20000080a7984ULL, 0x0022e20000000800ULL, 0x0000000c0d00720bULL, 0x004fe20003f1d000ULL,
0x00011e827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000097806ULL, 0x002fc800000e0100ULL,
0x0000ffff09257812ULL, 0x000fe2000782c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff087224ULL, 0x000fd400078e000cULL,
0x0000043000009947ULL, 0x000fea0003800000ULL, 0x00000002ff097819ULL, 0x000fe40000011602ULL,
0x0000000c0d00720bULL, 0x000fe40003f34000ULL, 0x000000020900720cULL, 0x000fe20003f05270ULL,
0x00011e327f007947ULL, 0x000fd4000b800000ULL, 0x0000000000247806ULL, 0x000fc400008e0100ULL,
0x0000008002098824ULL, 0x000fe200078e026aULL, 0x0000000c0d087209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x00009910240e7816ULL, 0x000fe200000000ffULL,
0x0000000170098824ULL, 0x000fca00078e0209ULL, 0x01b4000809008388ULL, 0x0003e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000c08097221ULL, 0x002fe20000010100ULL, 0x000000ff24ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x00000009000c7308ULL, 0x000e640000000800ULL, 0x0000000c07077220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff097819ULL, 0x000fe20000011605ULL,
0x00011d727f007947ULL, 0x000fea000b800000ULL, 0x00001f090c097589ULL, 0x0002a400000e0000ULL,
0x0000000910107220ULL, 0x084fe40000410000ULL, 0x0000000911117220ULL, 0x080fe40000410000ULL,
0x0000000914147220ULL, 0x080fe40000410000ULL, 0x0000000915157220ULL, 0x080fe40000410000ULL,
0x0000000918187220ULL, 0x080fe40000410000ULL, 0x0000000919197220ULL, 0x000fc40000410000ULL,
0x0000000950507220ULL, 0x080fe40000410000ULL, 0x0000000951517220ULL, 0x080fe40000410000ULL,
0x0000000954547220ULL, 0x080fe40000410000ULL, 0x0000000955557220ULL, 0x080fe40000410000ULL,
0x000000092c2c7220ULL, 0x080fe40000410000ULL, 0x000000092d2d7220ULL, 0x000fc40000410000ULL,
0x0000000920207220ULL, 0x080fe40000410000ULL, 0x0000000921217220ULL, 0x080fe40000410000ULL,
0x000000091c1c7220ULL, 0x080fe40000410000ULL, 0x000000091d1d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0024ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000805097811ULL, 0x000fe200078ff0ffULL,
0x00011c727f007947ULL, 0x000fea000b800000ULL, 0x00001f090c097589ULL, 0x00046400000e0000ULL,
0x0000000912127220ULL, 0x086fe40000410000ULL, 0x0000000913137220ULL, 0x080fe40000410000ULL,
0x0000000916167220ULL, 0x080fe40000410000ULL, 0x0000000917177220ULL, 0x080fe40000410000ULL,
0x000000091a1a7220ULL, 0x080fe40000410000ULL, 0x000000091b1b7220ULL, 0x000fc40000410000ULL,
0x0000000952527220ULL, 0x080fe40000410000ULL, 0x0000000953537220ULL, 0x080fe40000410000ULL,
0x0000000956567220ULL, 0x080fe40000410000ULL, 0x0000000957577220ULL, 0x080fe40000410000ULL,
0x000000092e2e7220ULL, 0x080fe40000410000ULL, 0x000000092f2f7220ULL, 0x000fc40000410000ULL,
0x0000000922227220ULL, 0x080fe40000410000ULL, 0x0000000923237220ULL, 0x080fe40000410000ULL,
0x000000091e1e7220ULL, 0x080fe40000410000ULL, 0x000000091f1f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff25ff7812ULL, 0x000fda0007806024ULL,
0x800000080d0d0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL,
0x0000000d00000308ULL, 0x000e640000000800ULL, 0x000000000a0a0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x000000070a077221ULL, 0x008fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000000ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011605ULL, 0x00005410040a7816ULL, 0x000fe20000000004ULL,
0x00011ad27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0a047589ULL, 0x0002a400000e0000ULL,
0x000000080d097810ULL, 0x000fe20007ffe0ffULL, 0x00011b227f007947ULL, 0x000fea000b800000ULL,
0x00001f090a067589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100d097810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000aULL,
0x00003320000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x000127c000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180d097810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0xffffffff00347802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x00003390000f7802ULL, 0x000fc40000000f00ULL,
0x0001275000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002024e7824ULL, 0x040fe200078e00ffULL, 0x00000007050d7812ULL, 0x002fe200078ec0ffULL,
0x0000020002097824ULL, 0x00cfe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x000000044e0a7812ULL, 0x000fe400078ec0ffULL, 0x000000080d0c7812ULL, 0x000fc400078ef805ULL,
0x0000000a05677211ULL, 0x000fe400078fe0ffULL, 0xfffff800090e7812ULL, 0x000fe200078ec0ffULL,
0x000000080c0a7824ULL, 0x040fe400078e00ffULL, 0x000000010c677824ULL, 0x000fca00078e0267ULL,
0xfffffff80a5d7812ULL, 0x000fe400078ee267ULL, 0x00000008050a7812ULL, 0x000fc600078ec0ffULL,
0x000000105d5d7824ULL, 0x000fc800078e020eULL, 0x00000004ff267819ULL, 0x000fe20000011605ULL,
0x011000005d38783bULL, 0x000e620000000200ULL, 0x0000000d0a0f7212ULL, 0x000fe200078efcffULL,
0x000059004c4c7a24ULL, 0x010fe200078e02ffULL, 0x00000001ff097819ULL, 0x000fe40000011602ULL,
0x000000100a287812ULL, 0x000fe200078efe0dULL, 0x0000000126247824ULL, 0x000fe200078e020fULL,
0xfffffff84e4e7812ULL, 0x000fe200078ec0ffULL, 0x00000002090a7824ULL, 0x000fe200078e026bULL,
0x0000002805657211ULL, 0x000fe200078fe0ffULL, 0x000000080f617824ULL, 0x000fe200078e00ffULL,
0x0000000224607810ULL, 0x040fe20007ffe0ffULL, 0x00000004090d7824ULL, 0x000fe200078e0226ULL,
0x000000030f267819ULL, 0x040fe200000006ffULL, 0x000000080f257824ULL, 0x000fe200078e00ffULL,
0x00000004245f7810ULL, 0x000fe20007ffe0ffULL, 0x000020000a0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff861617812ULL, 0x000fe200078ee224ULL, 0x000000080f0f7824ULL, 0x000fe200078e00ffULL,
0x0000000624627810ULL, 0x000fe20007ffe0ffULL, 0x000000080c247824ULL, 0x000fe200078e00ffULL,
0x000000020d0d7810ULL, 0x000fe20007ffe00cULL, 0x0000000828307824ULL, 0x040fe200078e00ffULL,
0xfffffff825607812ULL, 0x000fe200078ee260ULL, 0x00000008282a7824ULL, 0x000fe200078e00ffULL,
0x000130000a0c7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff8265f7812ULL, 0x000fe400078ee25fULL,
0xfffffff80f627812ULL, 0x000fe200078ee262ULL, 0x0000001060587824ULL, 0x100fe200078e020cULL,
0xfffffff8240d7812ULL, 0x000fe200078ee20dULL, 0x000000105f447824ULL, 0x100fe200078e020cULL,
0x0000000465637810ULL, 0x000fe20007ffe0ffULL, 0x0000001061407824ULL, 0x100fe200078e020cULL,
0x000000040d4d7819ULL, 0x000fe200000006ffULL, 0x00000010623c7824ULL, 0x000fe200078e020cULL,
0x000000005858783bULL, 0x000ea20000004200ULL, 0x00000008280f7824ULL, 0x040fe200078e00ffULL,
0x0000000265647810ULL, 0x040fe20007ffe0ffULL, 0x00000008280d7824ULL, 0x000fe200078e00ffULL,
0x000000004444783bULL, 0x000ee20000004200ULL, 0x0000000665667810ULL, 0x000fe20007ffe0ffULL,
0x0000000438380232ULL, 0x082fe20000000000ULL, 0x000110000e0e7810ULL, 0x000fe20007ffe04dULL,
0x000000004040783bULL, 0x000fe20000004200ULL, 0xfffffff830637812ULL, 0x000fe200078ee263ULL,
0x000000043a3a0232ULL, 0x000fe20000000000ULL, 0xfffffff80f647812ULL, 0x000fe200078ee264ULL,
0x000000003c3c783bULL, 0x000fe20000004200ULL, 0xfffffff82a657812ULL, 0x000fe200078ee265ULL,
0x0000001063307824ULL, 0x000fe200078e020cULL, 0xfffffff80d667812ULL, 0x000fe200078ee266ULL,
0x000000000e24783bULL, 0x000e620000000200ULL, 0x0000001064347824ULL, 0x100fe200078e020cULL,
0x0000000639390232ULL, 0x080fe20000000000ULL, 0x0000001065287824ULL, 0x100fe200078e020cULL,
0x000000003030783bULL, 0x000e620000004200ULL, 0x00000010660c7824ULL, 0x000fe200078e020cULL,
0x000000063b3b0232ULL, 0x000fc40000000000ULL, 0x000000003434783bULL, 0x000fe80000004200ULL,
0x000000002828783bULL, 0x000e680000004200ULL, 0x000000000c0c783bULL, 0x000e620000004200ULL,
0x000000583848723cULL, 0x044ff00000001818ULL, 0x000000443818723cULL, 0x048ff00000001854ULL,
0x00000046382c723cULL, 0x000f62000000182cULL, 0x0000000424240232ULL, 0x002fc40000000000ULL,
0x0000000426260232ULL, 0x000fe40000000000ULL, 0x0000000625250232ULL, 0x080fe40000000000ULL,
0x0000000627270232ULL, 0x000fe20000000000ULL, 0x000000403844723cULL, 0x040f700000001810ULL,
0x0000005a3850723cULL, 0x040f700000001850ULL, 0x000000423840723cULL, 0x040f700000001814ULL,
0x0000003c3820723cULL, 0x040f700000001820ULL, 0x0000003e3838723cULL, 0x000f70000000181cULL,
0x00000032241c723cULL, 0x060f70000000182cULL, 0x00000028242c723cULL, 0x040f700000001844ULL,
0x000000342410723cULL, 0x040f700000001848ULL, 0x000000362414723cULL, 0x040f700000001850ULL,
0x000000302418723cULL, 0x040f700000001818ULL, 0x0000002a2428723cULL, 0x040f700000001840ULL,
0x0000000c2420723cULL, 0x040b6e0000001820ULL, 0x00000008030c7824ULL, 0x020fe200078e0209ULL,
0x0000000e2424723cULL, 0x000b620000001838ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000001030d7810ULL, 0x000fe20007ffe0ffULL, 0x01b688004eff7f8cULL, 0x0003e2000c80043fULL,
0x000000800c307811ULL, 0x000fe200078e28ffULL, 0x00000100ff317424ULL, 0x000fe200078e00ffULL,
0x0000005e0d00720cULL, 0x000fc40003f06070ULL, 0x000000074c0c7819ULL, 0x000fe400000006ffULL,
0x00000060300f7812ULL, 0x020fc600078ec0ffULL, 0x000064000c0c7625ULL, 0x000fc800078e0031ULL,
0x00000001683c7824ULL, 0x000fe200078e020fULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff3f7819ULL, 0x102fe20000011605ULL,
0x00002000020f7824ULL, 0x040fe200078e00ffULL, 0x00000030690e7217ULL, 0x000fe20007800000ULL,
0x0000008002317824ULL, 0x000fe200078e00ffULL, 0x000000043f357810ULL, 0x040fe20007ffe0ffULL,
0x000000013f367824ULL, 0x140fe200078e0205ULL, 0x000000083f377810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0e7824ULL, 0x000fe200078e0a30ULL, 0x000020000f307812ULL, 0x000fe200078ec0ffULL,
0x00000001353a7824ULL, 0x100fe200078e0205ULL, 0x0000003c3f337210ULL, 0x000fe20007ffe0ffULL,
0x00000008350f7824ULL, 0x000fe200078e00ffULL, 0x000000200e427817ULL, 0x000fe20003800000ULL,
0x00000001373d7824ULL, 0x000fe200078e0205ULL, 0x0000000c3f3b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000837327824ULL, 0x000fe200078e00ffULL, 0xfffffff80f3a7812ULL, 0x000fe200078ee23aULL,
0x0000400009417824ULL, 0x000fe200078e0230ULL, 0x000000806a307812ULL, 0x000fe200078ef831ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0xfffffff8323d7812ULL, 0x000fe200078ee23dULL,
0x00000001350f7824ULL, 0x000fe200078e023cULL, 0x000000103f437810ULL, 0x000fe20007ffe0ffULL,
0x0000010033327825ULL, 0x000fe200078e0030ULL, 0x000000423500720cULL, 0x000fc40003f86070ULL,
0x000000143f457810ULL, 0x000fe20007ffe0ffULL, 0x000000013b407824ULL, 0x040fe200078e0205ULL,
0x000000320c387210ULL, 0x040fe20007f1e0ffULL, 0x000000083b357824ULL, 0x000fe200078e00ffULL,
0x000000423700720cULL, 0x080fe20003f66070ULL, 0x000001000f0e7825ULL, 0x000fe200078e0030ULL,
0x000000423b00720cULL, 0x000fe40003f46070ULL, 0xfffffff835407812ULL, 0x000fe200078ee240ULL,
0x00000001433e7824ULL, 0x140fe200078e0205ULL, 0x0000000e0c327210ULL, 0x000fe20007f3e0ffULL,
0x0000000843397824ULL, 0x000fe200078e00ffULL, 0x0000003c37357210ULL, 0x000fe20007ffe0ffULL,
0x0000000145097824ULL, 0x040fe200078e0205ULL, 0x0000000736447812ULL, 0x000fe200078ec0ffULL,
0x0000000845347824ULL, 0x000fe200078e00ffULL, 0xfffffff8393e7812ULL, 0x000fe200078ee23eULL,
0x000000013b377824ULL, 0x000fe200078e023cULL, 0x000000423f00720cULL, 0x000fe20003fa6070ULL,
0x000000010d397824ULL, 0x040fe200000e0633ULL, 0xfffffff834097812ULL, 0x000fe200078ee209ULL,
0x000000010d337824ULL, 0x000fe200008e060fULL, 0x0001300041417810ULL, 0x000fe20007ffe0ffULL,
0x00000100350e7825ULL, 0x000fe200078e0030ULL, 0x0ffffff844447812ULL, 0x000fc400078ef805ULL,
0x000000183f497810ULL, 0x000fe20007ffe0ffULL, 0x0000010037347825ULL, 0x000fe200078e0030ULL,
0x0000000e0c0e7210ULL, 0x040fe40007f1e0ffULL, 0x000000424300720cULL, 0x040fe20003f26070ULL,
0x00000001433b7824ULL, 0x000fe200078e023cULL, 0x000000340c347210ULL, 0x000fe20007fde0ffULL,
0x000000010d0f7824ULL, 0x000fe200000e060fULL, 0x000000424500720cULL, 0x000fe20003f06070ULL,
0x000001003b367825ULL, 0x000fe200078e0030ULL, 0x0000001c3f4b7810ULL, 0x000fc60007ffe0ffULL,
0x00000001453b7824ULL, 0x000fe200078e023cULL, 0x000000413a457211ULL, 0x000fe200078e20ffULL,
0x000000010d357824ULL, 0x000fe200030e0635ULL, 0x000000360c367210ULL, 0x000fe20007fde0ffULL,
0x0000001044437824ULL, 0x000fe400078e0241ULL, 0x000001003b3a7825ULL, 0x000fc600078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038437faeULL, 0x0003e2000e901c46ULL,
0x00000001493f7824ULL, 0x140fe200078e023cULL, 0x000000424900720cULL, 0x000fe20003fa6070ULL,
0x000000010d377824ULL, 0x000fe200030e0637ULL, 0x0000003a0c3a7210ULL, 0x000fe20007fde0ffULL,
0x0000000032457faeULL, 0x0005e2000e101c46ULL, 0x000000014b477824ULL, 0x040fe200078e023cULL,
0x000000424b00720cULL, 0x000fe20003f86070ULL, 0x00000001493c7824ULL, 0x000fe400078e0205ULL,
0x000000010d3b7824ULL, 0x000fc400030e063bULL, 0x000001003f387825ULL, 0x002fc800078e0030ULL,
0x000000084b427824ULL, 0x040fe200078e00ffULL, 0x000000380c327210ULL, 0x004fe20007fde0ffULL,
0x000000014b337824ULL, 0x000fe400078e0205ULL, 0x0000000849497824ULL, 0x000fe400078e00ffULL,
0x0000010047307825ULL, 0x000fe200078e0030ULL, 0xfffffff842387812ULL, 0x000fe400078ee233ULL,
0xfffffff8493c7812ULL, 0x000fe200078ee23cULL, 0x000000010d337824ULL, 0x000fe200030e0639ULL,
0x000000300c307210ULL, 0x000fe20007fde0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0241ULL,
0x0000004140397211ULL, 0x000fe200078e20ffULL, 0x000000103e3f7824ULL, 0x000fc400078e0241ULL,
0x0000001009097824ULL, 0x100fe200078e0241ULL, 0x000000000e3d7faeULL, 0x0003e2000d901c46ULL,
0x000000103c437824ULL, 0x100fe400078e0241ULL, 0x0000001038417824ULL, 0x000fe200078e0241ULL,
0x0000000034397faeULL, 0x0003e2000d101c46ULL, 0x000000010d317824ULL, 0x000fc600030e0631ULL,
0x00000000363f7faeULL, 0x0003e8000c901c46ULL, 0x000000003a097faeULL, 0x0003e8000c101c46ULL,
0x0000000032437faeULL, 0x0003e8000e901c46ULL, 0x0000000030417faeULL, 0x0003e2000e101c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000c053b7811ULL, 0x042fe200078fe8ffULL,
0x00002000020e7824ULL, 0x000fe200078e00ffULL, 0x00000010050f7811ULL, 0x000fc400078fe8ffULL,
0x00000008053d7811ULL, 0x000fe200078fe8ffULL, 0x000000013b3f7824ULL, 0x100fe200078e0205ULL,
0x0000001805337811ULL, 0x000fe200078fe8ffULL, 0x000000083b327824ULL, 0x000fe200078e00ffULL,
0x000020000e0e7812ULL, 0x000fe200078ec0ffULL, 0x000000010f407824ULL, 0x000fe200078e0205ULL,
0x0000000405397811ULL, 0x000fe200078fe8ffULL, 0x000000080f357824ULL, 0x000fe200078e00ffULL,
0x000000053d3e7210ULL, 0x0c0fe20007ffe0ffULL, 0x000000083d317824ULL, 0x000fe200078e00ffULL,
0xfffffff8323f7812ULL, 0x000fe200078ee23fULL, 0x0000000133327824ULL, 0x100fe200078e0205ULL,
0xfffffff835407812ULL, 0x000fe200078ee240ULL, 0x0000000833377824ULL, 0x000fe200078e00ffULL,
0x0000000702357819ULL, 0x000fe200000006ffULL, 0x0000400009307824ULL, 0x000fe200078e020eULL,
0x0000001c05437811ULL, 0x000fe200078fe8ffULL, 0x0000000139097824ULL, 0x100fe200078e0205ULL,
0xfffffff8313e7812ULL, 0x000fe200078ee23eULL, 0x00000008390e7824ULL, 0x000fe200078e00ffULL,
0x0000001405317811ULL, 0x000fe200078fe8ffULL, 0x0000000139397824ULL, 0x000fe200078e023cULL,
0xfffffff837447812ULL, 0x000fe200078ee232ULL, 0x0000000143327824ULL, 0x040fe200078e0205ULL,
0x000000806a347812ULL, 0x000fe200078ef835ULL, 0x0000000843357824ULL, 0x000fe200078e00ffULL,
0xfffffff80e097812ULL, 0x000fe200078ee209ULL, 0x0000000131417824ULL, 0x000fe200078e0205ULL,
0x0000003c05377211ULL, 0x000fe200078fe8ffULL, 0x00000008310e7824ULL, 0x000fe200078e00ffULL,
0xfffffff835467812ULL, 0x000fe200078ee232ULL, 0x000000013d3d7824ULL, 0x100fe200078e023cULL,
0x000000ff00357202ULL, 0x000fe20000000f00ULL, 0x000000013b3b7824ULL, 0x100fe200078e023cULL,
0xfffffff80e417812ULL, 0x000fe200078ee241ULL, 0x000000010f0f7824ULL, 0x000fe200078e023cULL,
0x00000005050e7211ULL, 0x000fe200078fe8ffULL, 0x0000010037367825ULL, 0x000fe200078e0034ULL,
0x00013000304b7810ULL, 0x000fc40007ffe0ffULL, 0x000000070e0e7812ULL, 0x000fe200078ec0ffULL,
0x0000000131317824ULL, 0x100fe200078e023cULL, 0x000000360c367210ULL, 0x000fe20007f1e0ffULL,
0x0000000133337824ULL, 0x100fe200078e023cULL, 0x0ffffff80e427812ULL, 0x000fe200078ef805ULL,
0x0000000143437824ULL, 0x000fe400078e023cULL, 0x0000010039387825ULL, 0x000fc800078e0034ULL,
0x000001003d3c7825ULL, 0x000fe200078e0034ULL, 0x000000380c387210ULL, 0x000fc60007f3e0ffULL,
0x000001003b3a7825ULL, 0x100fe200078e0034ULL, 0x0000003c0c3c7210ULL, 0x040fe40007f5e0ffULL,
0x000000390d397210ULL, 0x000fe20000ffe4ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0034ULL,
0x0000003a0c3a7210ULL, 0x000fc60007f7e0ffULL, 0x0000010031307825ULL, 0x000fc800078e0034ULL,
0x0000010033327825ULL, 0x000fe200078e0034ULL, 0x000000300c307210ULL, 0x000fc60007f3e0ffULL,
0x0000010043347825ULL, 0x000fc800078e0034ULL, 0x000000010d377824ULL, 0x040fe200000e0637ULL,
0x0000000e0c0e7210ULL, 0x000fe20007f1e0ffULL, 0x0000001042437824ULL, 0x000fe400078e024bULL,
0x000000010d3d7824ULL, 0x000fe200010e063dULL, 0x000000320c327210ULL, 0x040fe20007f5e0ffULL,
0x0000001009097824ULL, 0x000fe200078e024bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000036437faeULL, 0x0003e2000b901c46ULL, 0x000000010d3b7824ULL, 0x000fe200018e063bULL,
0x000000340c347210ULL, 0x000fe20007f7e0ffULL, 0x000000103e457824ULL, 0x100fe200078e024bULL,
0x0000000038097faeULL, 0x0003e2000b901c46ULL, 0x000000103f3f7824ULL, 0x000fc400078e024bULL,
0x0000001040477824ULL, 0x000fe200078e024bULL, 0x000000003c457faeULL, 0x0003e2000b901c46ULL,
0x000000010d0f7824ULL, 0x000fe400000e060fULL, 0x0000001041417824ULL, 0x000fe200078e024bULL,
0x000000003a3f7faeULL, 0x0003e2000b901c46ULL, 0x000000010d317824ULL, 0x040fe400008e0631ULL,
0x0000001044497824ULL, 0x000fe200078e024bULL, 0x000000000e477faeULL, 0x0003e2000b901c46ULL,
0x000000010d337824ULL, 0x000fc400010e0633ULL, 0x00000010464b7824ULL, 0x000fe200078e024bULL,
0x0000000030417faeULL, 0x0003e2000b901c46ULL, 0x000000010d357824ULL, 0x000fc600018e0635ULL,
0x0000000032497faeULL, 0x0003e8000b901c46ULL, 0x00000000344b7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe06e097812ULL, 0x042fe400078ec0ffULL,
0x000000106e0e7812ULL, 0x040fe400078ec0ffULL, 0x000000086e0f7812ULL, 0x000fc800078ec0ffULL,
0x000000090f347210ULL, 0x000fe20007ffe00eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6280034307f8cULL, 0x0002a4000c80043fULL, 0x00000000000e7805ULL, 0x000fc40000015200ULL,
0x01b62c0034097984ULL, 0x000ee40000000800ULL, 0x8000000009ff7812ULL, 0x00cfe40007804831ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x000000320e327210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e0fULL, 0x003d09003200780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403200780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc80000011433ULL,
0x0000003209097211ULL, 0x000fca00078110ffULL, 0x000000ffff327224ULL, 0x000fca00000e0633ULL,
0x0000000209097819ULL, 0x000fc80000001232ULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000135357810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b62c0034097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000806a097810ULL, 0x000fc80007ffe05cULL, 0x0000000970097210ULL, 0x000fca0007ffe0ffULL,
0x01b0000009317984ULL, 0x000ea80000000800ULL, 0x01b2000009307984ULL, 0x0006620000000800ULL,
0x000000083100720bULL, 0x004fe20003f1d000ULL, 0x000104727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000097806ULL, 0x008fc800000e0100ULL, 0x0000ffff09337812ULL, 0x000fe2000782c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x0000000102097811ULL, 0x000fe400078ff0ffULL,
0x000000083100720bULL, 0x000fe40003f34000ULL, 0x000000020900720cULL, 0x000fe20003f05270ULL,
0x000104327f007947ULL, 0x000fd4000b800000ULL, 0x0000000000327806ULL, 0x000fc400008e0100ULL,
0x00000080020f8824ULL, 0x000fe200078e026aULL, 0x0000000831098209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x00009910320e7816ULL, 0x000fe200000000ffULL,
0x0000000170348824ULL, 0x002fca00078e020fULL, 0x01b4000934008388ULL, 0x0003e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000831097209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff32ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000809097221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x0000000900367308ULL, 0x000e640000000800ULL,
0x0000003607077220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff097819ULL, 0x000fe20000011605ULL, 0x000103627f007947ULL, 0x000fea000b800000ULL,
0x00001f0936097589ULL, 0x0002a400000e0000ULL, 0x000000092c2c7220ULL, 0x084fe40000410000ULL,
0x000000092d2d7220ULL, 0x080fe40000410000ULL, 0x0000000928287220ULL, 0x080fe40000410000ULL,
0x0000000929297220ULL, 0x000fc40000410000ULL, 0x0000000910107220ULL, 0x080fe40000410000ULL,
0x0000000911117220ULL, 0x080fe40000410000ULL, 0x0000000914147220ULL, 0x080fe40000410000ULL,
0x0000000915157220ULL, 0x080fe40000410000ULL, 0x0000000918187220ULL, 0x080fe40000410000ULL,
0x0000000919197220ULL, 0x000fc40000410000ULL, 0x000000091c1c7220ULL, 0x080fe40000410000ULL,
0x000000091d1d7220ULL, 0x080fe40000410000ULL, 0x0000000920207220ULL, 0x080fe40000410000ULL,
0x0000000921217220ULL, 0x080fe40000410000ULL, 0x0000000924247220ULL, 0x080fe40000410000ULL,
0x0000000925257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0032ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000805097811ULL, 0x000fe200078ff0ffULL, 0x000102627f007947ULL, 0x000fea000b800000ULL,
0x00001f0936097589ULL, 0x0004e400000e0000ULL, 0x000000092e2e7220ULL, 0x08cfe40000410000ULL,
0x000000092f2f7220ULL, 0x080fe40000410000ULL, 0x000000092a2a7220ULL, 0x080fe40000410000ULL,
0x000000092b2b7220ULL, 0x080fe40000410000ULL, 0x0000000912127220ULL, 0x080fe40000410000ULL,
0x0000000913137220ULL, 0x000fc40000410000ULL, 0x0000000916167220ULL, 0x080fe40000410000ULL,
0x0000000917177220ULL, 0x080fe40000410000ULL, 0x000000091a1a7220ULL, 0x080fe40000410000ULL,
0x000000091b1b7220ULL, 0x080fe40000410000ULL, 0x000000091e1e7220ULL, 0x080fe40000410000ULL,
0x000000091f1f7220ULL, 0x000fc40000410000ULL, 0x0000000922227220ULL, 0x080fe40000410000ULL,
0x0000000923237220ULL, 0x080fe40000410000ULL, 0x0000000926267220ULL, 0x080fe40000410000ULL,
0x0000000927277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff33ff7812ULL, 0x000fe40007806032ULL, 0x0000000831087209ULL, 0x000fd60007810000ULL,
0x8000000831310221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL,
0x0000003100000308ULL, 0x000e640000000800ULL, 0x0000000030300220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000000730077221ULL, 0x002fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000000ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff317819ULL, 0x000fe40000011605ULL, 0x0000541004307816ULL, 0x000fe20000000004ULL,
0x000100b27f007947ULL, 0x000fea000b800000ULL, 0x00001f3130047589ULL, 0x0002a400000e0000ULL,
0x0000000831097810ULL, 0x000fe20007ffe0ffULL, 0x000101027f007947ULL, 0x000fea000b800000ULL,
0x00001f0930067589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001031097810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0030ULL,
0x00004fa0000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x00010b4000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001831097810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x00005010000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00010ad000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x000140000a0a7810ULL, 0x000fe20007ffe0ffULL,
0x011800005d44783bULL, 0x000f220000000200ULL, 0x00000002ff097819ULL, 0x00cfe40000011602ULL,
0x0000000a62487211ULL, 0x000fe200078e20ffULL, 0x0000001061547824ULL, 0x100fe200078e020aULL,
0x0001b690090e7811ULL, 0x000fe200078e18ffULL, 0x0000001060507824ULL, 0x000fc400078e020aULL,
0x000000105f587824ULL, 0x100fe200078e020aULL, 0x000000004848783bULL, 0x000fe20000004200ULL,
0x0000080009307824ULL, 0x002fe400078e024dULL, 0x0000001065407824ULL, 0x100fe200078e020aULL,
0x000000005454783bULL, 0x000e620000004200ULL, 0x00000010643c7824ULL, 0x100fe400078e020aULL,
0x0000001063387824ULL, 0x100fe200078e020aULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x0000001066347824ULL, 0x000fe200078e020aULL, 0x00000001ff0a7819ULL, 0x000fc40000011602ULL,
0x000000005858783bULL, 0x000fe80000004200ULL, 0x011800003030783bULL, 0x000ea80000000200ULL,
0x000000004040783bULL, 0x000ee80000004200ULL, 0x000000003c3c783bULL, 0x000ee80000004200ULL,
0x000000003838783bULL, 0x000ee20000004200ULL, 0x0000000444440232ULL, 0x010fc60000000000ULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x0000000446460232ULL, 0x000fe40000000000ULL,
0x0000000645450232ULL, 0x080fe40000000000ULL, 0x0000000647470232ULL, 0x000fce0000000000ULL,
0x00000054442c723cULL, 0x042f70000000182cULL, 0x000000564428723cULL, 0x000f620000001828ULL,
0x0000000430300232ULL, 0x084fe40000000000ULL, 0x0000000432320232ULL, 0x000fca0000000000ULL,
0x00000050444c723cULL, 0x000f620000001810ULL, 0x0000000631310232ULL, 0x080fe40000000000ULL,
0x0000000633330232ULL, 0x000fca0000000000ULL, 0x000000524450723cULL, 0x040f700000001814ULL,
0x000000584454723cULL, 0x040f700000001818ULL, 0x0000005a441c723cULL, 0x040f70000000181cULL,
0x000000484420723cULL, 0x040f700000001820ULL, 0x0000004a4424723cULL, 0x000f700000001824ULL,
0x000000403010723cULL, 0x068f70000000182cULL, 0x000000423014723cULL, 0x040f700000001828ULL,
0x0000003c3018723cULL, 0x040f70000000184cULL, 0x0000003e3050723cULL, 0x040f700000001850ULL,
0x000000383054723cULL, 0x040f700000001854ULL, 0x0000003a301c723cULL, 0x040f70000000181cULL,
0x000000343020723cULL, 0x050f700000001820ULL, 0x000000363030723cULL, 0x000b6e0000001824ULL,
0x0000000803247824ULL, 0x020fe200078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fcc0000008000ULL,
0x0000000103257810ULL, 0x000fe20007ffe0ffULL, 0x000000000eff7f8cULL, 0x0003e2000c80043fULL,
0x000000c024247811ULL, 0x000fc400078e28ffULL, 0x0000005e2500720cULL, 0x000fe40003f06070ULL,
0x00000060240f7812ULL, 0x000fca00078ec0ffULL, 0x0000000168347824ULL, 0x000fe200078e020fULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff397819ULL, 0x102fe40000011605ULL, 0x00000024690e7217ULL, 0x000fe40007800000ULL,
0x0000000439257810ULL, 0x040fe40007ffe0ffULL, 0x0000000839297810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0e7824ULL, 0x000fe200078e0a24ULL, 0x00000003250f7819ULL, 0x040fe200000006ffULL,
0x00000001252e7824ULL, 0x100fe200078e0205ULL, 0x00000014393d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000129367824ULL, 0x140fe200078e0205ULL, 0x000000200e3a7817ULL, 0x000fe20003800000ULL,
0x0000000829277824ULL, 0x000fe200078e00ffULL, 0xfffffff80f2e7812ULL, 0x000fe200078ee22eULL,
0x00000080020f7824ULL, 0x000fe200078e00ffULL, 0x0000000c392b7810ULL, 0x000fe20007ffe0ffULL,
0x000000013d377824ULL, 0x000fe200078e0205ULL, 0xfffffff827367812ULL, 0x000fe200078ee236ULL,
0x0000000139277824ULL, 0x040fe200078e0234ULL, 0x000000806a0e7812ULL, 0x000fe200078ef80fULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x00000010393b7810ULL, 0x000fe20007ffe0ffULL,
0x000000083d287824ULL, 0x000fe200078e00ffULL, 0x0000003a2500720cULL, 0x000fe20003f86070ULL,
0x0000010027267825ULL, 0x000fe200078e000eULL, 0x000000033b2d7819ULL, 0x000fc400000006ffULL,
0xfffffff828377812ULL, 0x000fe200078ee237ULL, 0x000000012b357824ULL, 0x140fe200078e0205ULL,
0x000000260c2c7210ULL, 0x000fe20007f1e0ffULL, 0x000000082b247824ULL, 0x000fe200078e00ffULL,
0x0000003a2900720cULL, 0x080fe20003f66070ULL, 0x000000013b387824ULL, 0x000fe200078e0205ULL,
0x0000003a2b00720cULL, 0x080fe20003f46070ULL, 0x0000000125257824ULL, 0x000fe200078e0234ULL,
0xfffffff824357812ULL, 0x000fe200078ee235ULL, 0x0000200002287824ULL, 0x000fe200078e00ffULL,
0xfffffff82d387812ULL, 0x000fe200078ee238ULL, 0x0000010025247825ULL, 0x000fe200078e000eULL,
0x0000003a3900720cULL, 0x000fc40003fa6070ULL, 0x00002000282f7812ULL, 0x000fe200078ec0ffULL,
0x000000010d2d7824ULL, 0x000fe200000e0627ULL, 0x000000240c247210ULL, 0x000fe20007f3e0ffULL,
0x0000000129277824ULL, 0x100fe200078e0234ULL, 0x0000002f0a2f7211ULL, 0x000fe200078e70ffULL,
0x000000012b297824ULL, 0x000fe200078e0234ULL, 0x0000001839437810ULL, 0x040fe20007ffe0ffULL,
0x0000000139267824ULL, 0x040fe200078e0205ULL, 0x0000001c39457810ULL, 0x000fe20007ffe0ffULL,
0x0000010029287825ULL, 0x000fc600078e000eULL, 0x00000007263c7812ULL, 0x000fe200078ec0ffULL,
0x000000013b2b7824ULL, 0x000fe200078e0234ULL, 0x000000280c287210ULL, 0x000fe20007fde0ffULL,
0x000000010d257824ULL, 0x000fe200008e0625ULL, 0x0000003a3b00720cULL, 0x000fe20003f26070ULL,
0x000001002b2a7825ULL, 0x000fe200078e000eULL, 0x000140002f3b7810ULL, 0x000fe40007ffe0ffULL,
0x0ffffff83c3c7812ULL, 0x000fe200078ef805ULL, 0x0000010027267825ULL, 0x000fc800078e000eULL,
0x000000013d2f7824ULL, 0x000fe200078e0234ULL, 0x000000260c267210ULL, 0x040fe20007f1e0ffULL,
0x000000010d297824ULL, 0x000fe200030e0629ULL, 0x0000002a0c2a7210ULL, 0x000fe20007fde0ffULL,
0x000000102e417824ULL, 0x100fe400078e023bULL, 0x000000103c3f7824ULL, 0x000fe400078e023bULL,
0x000001002f2e7825ULL, 0x000fc600078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c3f7faeULL, 0x0003e2000e901c46ULL, 0x0000000143397824ULL, 0x140fe200078e0234ULL,
0x0000003a4300720cULL, 0x000fe20003fa6070ULL, 0x000000010d2b7824ULL, 0x040fe200030e062bULL,
0x0000002e0c2e7210ULL, 0x000fe20007fde0ffULL, 0x000000010d277824ULL, 0x000fe200000e0627ULL,
0x0000003a3d00720cULL, 0x080fe20003f06070ULL, 0x0000000024417faeULL, 0x0005e2000e101c46ULL,
0x00000001453d7824ULL, 0x040fe200078e0234ULL, 0x0000003a4500720cULL, 0x000fe20003f86070ULL,
0x000000010d2f7824ULL, 0x000fe200030e062fULL, 0x0000000543347210ULL, 0x000fe20007ffe0ffULL,
0x00000100392c7825ULL, 0x002fc800078e000eULL, 0x00000008453a7824ULL, 0x000fe400078e00ffULL,
0x0000000843437824ULL, 0x000fe200078e00ffULL, 0x0000002c0c247210ULL, 0x004fe20007fde0ffULL,
0x0000000145257824ULL, 0x000fe400078e0205ULL, 0x000001003d0e7825ULL, 0x000fe200078e000eULL,
0xfffffff843347812ULL, 0x000fe400078ee234ULL, 0xfffffff83a2c7812ULL, 0x000fe200078ee225ULL,
0x000000010d257824ULL, 0x000fe200030e062dULL, 0x0000000e0c0c7210ULL, 0x000fe20007fde0ffULL,
0x00000010362d7824ULL, 0x000fc400078e023bULL, 0x0000001035357824ULL, 0x100fe400078e023bULL,
0x0000001038397824ULL, 0x100fe200078e023bULL, 0x00000000262d7faeULL, 0x0003e2000d901c46ULL,
0x0000001037377824ULL, 0x100fe400078e023bULL, 0x00000010343d7824ULL, 0x000fe200078e023bULL,
0x0000003b2c3b7211ULL, 0x000fe200078e20ffULL, 0x000000010d0d7824ULL, 0x000fe200030e060fULL,
0x0000000028357faeULL, 0x0003e8000d101c46ULL, 0x000000002a397faeULL, 0x0003e8000c901c46ULL,
0x000000002e377faeULL, 0x0003e8000c101c46ULL, 0x00000000243d7faeULL, 0x0003e8000e901c46ULL,
0x000000000c3b7faeULL, 0x0003e2000e101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000000805357811ULL, 0x042fe400078fe8ffULL, 0x0000001005247811ULL, 0x000fc400078fe8ffULL,
0x0000001805277811ULL, 0x000fe200078fe8ffULL, 0x00000001353a7824ULL, 0x100fe200078e0205ULL,
0x00000004052d7811ULL, 0x000fe200078fe8ffULL, 0x00000008350f7824ULL, 0x000fe200078e00ffULL,
0x0000001c053d7811ULL, 0x040fe200078fe8ffULL, 0x0000000124387824ULL, 0x140fe200078e0205ULL,
0x0000000c052f7811ULL, 0x000fe200078fe8ffULL, 0x0000000127367824ULL, 0x100fe200078e0205ULL,
0xfffffff80f3a7812ULL, 0x000fe200078ee23aULL, 0x00000008240f7824ULL, 0x000fe200078e00ffULL,
0x0000001405257811ULL, 0x000fe200078fe8ffULL, 0x0000000827297824ULL, 0x000fe200078e00ffULL,
0x00000034052b7211ULL, 0x000fe200078fe8ffULL, 0x000000012d3b7824ULL, 0x000fe200078e0205ULL,
0xfffffff80f387812ULL, 0x000fe200078ee238ULL, 0x00002000020f7824ULL, 0x040fe200078e00ffULL,
0xfffffff829367812ULL, 0x000fe200078ee236ULL, 0x0000008002297824ULL, 0x000fe200078e00ffULL,
0x0000000525377210ULL, 0x000fe20007ffe0ffULL, 0x000000082d0e7824ULL, 0x000fe200078e00ffULL,
0x000020000f3f7812ULL, 0x000fe200078ec0ffULL, 0x00000001240f7824ULL, 0x000fe200078e0234ULL,
0x000000806a287812ULL, 0x000fe200078ef829ULL, 0x000000013d247824ULL, 0x040fe200078e0205ULL,
0xfffffff80e3b7812ULL, 0x000fe200078ee23bULL, 0x000000083d297824ULL, 0x000fc400078e00ffULL,
0x000000012f397824ULL, 0x040fe400078e0205ULL, 0x000000082f0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8293e7812ULL, 0x000fe200078ee224ULL, 0x000000ffff297224ULL, 0x000fe400078e00ffULL,
0x000000012d2d7824ULL, 0x100fe200078e0234ULL, 0xfffffff80e397812ULL, 0x000fe200078ee239ULL,
0x0000000135357824ULL, 0x100fe200078e0234ULL, 0x00000005050e7211ULL, 0x000fe200078fe8ffULL,
0x000000012f2f7824ULL, 0x000fc400078e0234ULL, 0x0000000825267824ULL, 0x000fe200078e00ffULL,
0x000000070e0e7812ULL, 0x000fe200078ec0ffULL, 0x000001002b2a7825ULL, 0x000fe200078e0028ULL,
0x0000003425257210ULL, 0x000fe40007ffe0ffULL, 0x0ffffff80e3c7812ULL, 0x000fe200078ef805ULL,
0x0000000127277824ULL, 0x100fe200078e0234ULL, 0x0000002a0c2a7210ULL, 0x000fe20007f1e0ffULL,
0x000000013d3d7824ULL, 0x000fe200078e0234ULL, 0xfffffff826377812ULL, 0x000fe200078ee237ULL,
0x000040000a3f7824ULL, 0x000fc400078e023fULL, 0x000001002d2c7825ULL, 0x000fc600078e0028ULL,
0x000140003f3f7810ULL, 0x000fe20007ffe0ffULL, 0x0000010035347825ULL, 0x100fe200078e0028ULL,
0x0000002c0c2c7210ULL, 0x040fe40007f3e0ffULL, 0x0000003f39397211ULL, 0x000fe200078e20ffULL,
0x000001002f2e7825ULL, 0x000fe200078e0028ULL, 0x000000340c347210ULL, 0x000fc60007f5e0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0028ULL, 0x0000002e0c2e7210ULL, 0x000fc60007f7e0ffULL,
0x0000010025247825ULL, 0x000fc800078e0028ULL, 0x0000010027267825ULL, 0x000fc800078e0028ULL,
0x000001003d287825ULL, 0x000fc800078e0028ULL, 0x000000010d2b7824ULL, 0x040fe200000e062bULL,
0x0000000e0c0e7210ULL, 0x000fe20007f1e0ffULL, 0x000000103c3d7824ULL, 0x000fe400078e023fULL,
0x000000010d2d7824ULL, 0x040fe200008e062dULL, 0x000000240c247210ULL, 0x040fe20007f3e0ffULL,
0x000000010d357824ULL, 0x000fe200010e0635ULL, 0x000000260c267210ULL, 0x040fe20007f5e0ffULL,
0x000000103b3b7824ULL, 0x000fe200078e023fULL, 0x000000250d257210ULL, 0x040fe20000ffe4ffULL,
0x000000010d2f7824ULL, 0x000fe200018e062fULL, 0x000000280c0c7210ULL, 0x000fe20007f7e0ffULL,
0x000000103a417824ULL, 0x100fe200078e023fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3d7faeULL, 0x0003e2000b901c46ULL, 0x0000001038437824ULL, 0x000fc400078e023fULL,
0x000000010d0f7824ULL, 0x000fe200000e060fULL, 0x000000002c3b7faeULL, 0x0003e2000b901c46ULL,
0x0000001037377824ULL, 0x100fe400078e023fULL, 0x0000001036457824ULL, 0x000fe200078e023fULL,
0x0000000034417faeULL, 0x0003e2000b901c46ULL, 0x000000010d277824ULL, 0x040fe400010e0627ULL,
0x000000103e3f7824ULL, 0x000fe200078e023fULL, 0x000000002e397faeULL, 0x0003e2000b901c46ULL,
0x000000010d0d7824ULL, 0x000fc600018e0629ULL, 0x000000000e437faeULL, 0x0003e8000b901c46ULL,
0x0000000024377faeULL, 0x0003e8000b901c46ULL, 0x0000000026457faeULL, 0x0003e8000b901c46ULL,
0x000000000c3f7faeULL, 0x0003e4000b901c46ULL, 0x00000300ff0c7624ULL, 0x002fe200078e00ffULL,
0x000000010b0d7812ULL, 0x000fe200078ec0ffULL, 0xffffffffff597424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000010d00780cULL, 0x000fc40003f05070ULL,
0xffffffff0c0c7811ULL, 0x000fc800078e08ffULL, 0x000000010c0c7807ULL, 0x000fca0004000000ULL,
0x000000010b0b7824ULL, 0x000fca00078e020cULL, 0x0000006d0b00720cULL, 0x000fda0003f06070ULL,
0x000000010b0c8824ULL, 0x000fe400078e026cULL, 0x00000004ff0d8424ULL, 0x000fc800078e00ffULL,
0x000066000c0c8625ULL, 0x000fca00078e000dULL, 0x000000060c598981ULL, 0x000322000c1e1900ULL,
0x000000106e0e7812ULL, 0x000fca00078ec0ffULL, 0x0000002009097824ULL, 0x000fe200078e020eULL,
0x000000086e0e7812ULL, 0x000fca00078ec0ffULL, 0x000000010e097824ULL, 0x000fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b64800090e7f8cULL, 0x0022a4000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x01b64c0009257984ULL, 0x000ee40000000800ULL,
0x8000000025ff7812ULL, 0x00cfe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ff00267202ULL, 0x000fe20000000f00ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x000000240c277210ULL, 0x000fca0007f1e1ffULL, 0x0000000125257824ULL, 0x000fe200000e0e0dULL,
0x003d09002700780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402700780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011425ULL, 0x0000002724247211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x0000000224247819ULL, 0x000fc80000001225ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000126267810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b64c0009257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x004fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001006a097810ULL, 0x002fca0007ffe05cULL,
0x0000000170097824ULL, 0x000fca00078e0209ULL, 0x01b00000090d7984ULL, 0x000e680000000800ULL,
0x01b20000090c7984ULL, 0x0004e20000000800ULL, 0x000000080d00720bULL, 0x002fe20003f1d000ULL,
0x0000eca27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000097806ULL, 0x004fc800000e0100ULL,
0x0000ffff09257812ULL, 0x000fe2000782c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x0000000202097811ULL, 0x000fe400078ff0ffULL, 0x000000080d00720bULL, 0x000fe40003f34000ULL,
0x000000020900720cULL, 0x000fe20003f05270ULL, 0x0000ec627f007947ULL, 0x000fd4000b800000ULL,
0x0000000000247806ULL, 0x000fc400008e0100ULL, 0x00000080020f8824ULL, 0x000fe200078e026aULL,
0x000000080d098209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x00009910240e7816ULL, 0x000fe200000000ffULL, 0x0000000170268824ULL, 0x000fca00078e020fULL,
0x01b4000926008388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000080d097209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff24ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000809097221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x0000000900267308ULL, 0x000e640000000800ULL, 0x0000002607077220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff097819ULL, 0x000fe20000011605ULL,
0x0000eb927f007947ULL, 0x000fea000b800000ULL, 0x00001f0926097589ULL, 0x0002a400000e0000ULL,
0x0000000910107220ULL, 0x084fe40000410000ULL, 0x0000000911117220ULL, 0x080fe40000410000ULL,
0x0000000914147220ULL, 0x080fe40000410000ULL, 0x0000000915157220ULL, 0x000fc40000410000ULL,
0x0000000918187220ULL, 0x080fe40000410000ULL, 0x0000000919197220ULL, 0x080fe40000410000ULL,
0x0000000950507220ULL, 0x080fe40000410000ULL, 0x0000000951517220ULL, 0x080fe40000410000ULL,
0x0000000954547220ULL, 0x080fe40000410000ULL, 0x0000000955557220ULL, 0x000fc40000410000ULL,
0x000000091c1c7220ULL, 0x080fe40000410000ULL, 0x000000091d1d7220ULL, 0x080fe40000410000ULL,
0x0000000920207220ULL, 0x080fe40000410000ULL, 0x0000000921217220ULL, 0x080fe40000410000ULL,
0x0000000930307220ULL, 0x080fe40000410000ULL, 0x0000000931317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0024ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000805097811ULL, 0x000fe200078ff0ffULL,
0x0000ea927f007947ULL, 0x000fea000b800000ULL, 0x00001f0926097589ULL, 0x00046400000e0000ULL,
0x0000000912127220ULL, 0x086fe40000410000ULL, 0x0000000913137220ULL, 0x080fe40000410000ULL,
0x0000000916167220ULL, 0x080fe40000410000ULL, 0x0000000917177220ULL, 0x080fe40000410000ULL,
0x000000091a1a7220ULL, 0x080fe40000410000ULL, 0x000000091b1b7220ULL, 0x000fc40000410000ULL,
0x0000000952527220ULL, 0x080fe40000410000ULL, 0x0000000953537220ULL, 0x080fe40000410000ULL,
0x0000000956567220ULL, 0x080fe40000410000ULL, 0x0000000957577220ULL, 0x080fe40000410000ULL,
0x000000091e1e7220ULL, 0x080fe40000410000ULL, 0x000000091f1f7220ULL, 0x000fc40000410000ULL,
0x0000000922227220ULL, 0x080fe40000410000ULL, 0x0000000923237220ULL, 0x080fe40000410000ULL,
0x0000000932327220ULL, 0x080fe40000410000ULL, 0x0000000933337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff25ff7812ULL, 0x000fe40007806024ULL,
0x000000080d087209ULL, 0x000fd60007810000ULL, 0x800000080d0d0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL, 0x0000000d00000308ULL, 0x000e640000000800ULL,
0x000000000c0c0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x000000070c077221ULL, 0x008fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000000ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011605ULL,
0x00005410040c7816ULL, 0x000fe20000000004ULL, 0x0000e8e27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0c047589ULL, 0x0002a400000e0000ULL, 0x000000080d097810ULL, 0x000fe20007ffe0ffULL,
0x0000e9327f007947ULL, 0x000fea000b800000ULL, 0x00001f090c067589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100d097810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x000069d0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000f11000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180d097810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000cULL,
0x00006a40000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000f0a000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000006b0a487211ULL, 0x000fe200078e08ffULL, 0x012000005d3c783bULL, 0x000ee40000000200ULL,
0x00000007050c7812ULL, 0x00afe400078ec0ffULL, 0x0000000267097810ULL, 0x004fe20007ffe0ffULL,
0x0000200048487824ULL, 0x000fe200078e00ffULL, 0x000000080c0c7812ULL, 0x000fc800078ef805ULL,
0x0001300048287810ULL, 0x000fe20007ffe0ffULL, 0x000000080c0c7824ULL, 0x000fc600078e00ffULL,
0x0000002864347211ULL, 0x000fe200078e20ffULL, 0x00000010614c7824ULL, 0x100fe200078e0228ULL,
0xfffffff80c587812ULL, 0x000fe200078ee209ULL, 0x000000105f0c7824ULL, 0x000fe200078e0228ULL,
0x00000002ff097819ULL, 0x000fe20000011602ULL, 0x0000001060447824ULL, 0x100fe200078e0228ULL,
0x000000003434783bULL, 0x000fe20000004200ULL, 0x0000001062407824ULL, 0x100fe400078e0228ULL,
0x0000001058587824ULL, 0x000fe200078e00ffULL, 0x000000000c0c783bULL, 0x000e620000004200ULL,
0x0000001065387824ULL, 0x000fc400078e0228ULL, 0x0000080009247824ULL, 0x000fe200078e0258ULL,
0x000000004c4c783bULL, 0x000ea20000004200ULL, 0x00000010632c7824ULL, 0x100fe400078e0228ULL,
0x0000001066287824ULL, 0x000fe200078e0228ULL, 0x000000004444783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000fe80000004200ULL, 0x012000002424783bULL, 0x000ee20000000200ULL,
0x000000043c3c0232ULL, 0x000fc40000000000ULL, 0x000000043e3e0232ULL, 0x000fe20000000000ULL,
0x000000002c2c783bULL, 0x000ee20000004200ULL, 0x000000063d3d0232ULL, 0x080fe40000000000ULL,
0x000000063f3f0232ULL, 0x000fe20000000000ULL, 0x000000003838783bULL, 0x000ee80000004200ULL,
0x000000002828783bULL, 0x000ee40000004200ULL, 0x0000000c3c54723cULL, 0x042f700000001854ULL,
0x0000004c3c10723cULL, 0x044f700000001810ULL, 0x0000004e3c14723cULL, 0x000f620000001814ULL,
0x0000000424240232ULL, 0x008fc40000000000ULL, 0x0000000426260232ULL, 0x000fe40000000000ULL,
0x0000000625250232ULL, 0x080fe40000000000ULL, 0x0000000627270232ULL, 0x000fe20000000000ULL,
0x000000443c18723cULL, 0x040f700000001818ULL, 0x000000463c50723cULL, 0x040f700000001850ULL,
0x0000000e3c0c723cULL, 0x040f70000000181cULL, 0x000000403c20723cULL, 0x040f700000001820ULL,
0x000000423c30723cULL, 0x000f700000001830ULL, 0x0000002c2454723cULL, 0x060f700000001854ULL,
0x000000382410723cULL, 0x040f700000001810ULL, 0x0000003a2414723cULL, 0x040f700000001814ULL,
0x000000342418723cULL, 0x040f700000001818ULL, 0x000000362450723cULL, 0x040f700000001850ULL,
0x0000002e242c723cULL, 0x040b6e000000180cULL, 0x0001b698090c7811ULL, 0x020fe200078e18ffULL,
0x000000282420723cULL, 0x040b700000001820ULL, 0x0000002a2424723cULL, 0x000b620000001830ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x00000300030e7a10ULL, 0x000fe20007ffe0ffULL,
0x000000000cff7f8cULL, 0x0003e6000c80043fULL, 0x0000005e0e00720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x00000c9000000947ULL, 0x000fea0003800000ULL,
0x000000010e0d7810ULL, 0x042fe20007ffe0ffULL, 0x000001000e0f7824ULL, 0x000fe400078e026fULL,
0x00005900590c7a24ULL, 0x010fe200078e02ffULL, 0x0000005e0d00720cULL, 0x000fe20003f06070ULL,
0x00000100ff1d7424ULL, 0x000fe200078e00ffULL, 0x000000600f0d7812ULL, 0x000fe200078ec0ffULL,
0x000000800c0c7824ULL, 0x000fc800078e00ffULL, 0x0000000168347824ULL, 0x000fe400078e020dULL,
0x000064000c0c7625ULL, 0x000fc800078e001dULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff397819ULL, 0x000fe40000011605ULL, 0x0000000f690e7217ULL, 0x000fe40007800000ULL,
0x00000004391d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c393b7810ULL, 0x040fe20007ffe0ffULL,
0x000000010e0e7824ULL, 0x000fe200078e0a0fULL, 0x0000000839317810ULL, 0x020fe20007ffe0ffULL,
0x000000011d327824ULL, 0x100fe200078e0205ULL, 0x00000010393d7810ULL, 0x000fe20007ffe0ffULL,
0x000000081d0f7824ULL, 0x000fe200078e00ffULL, 0x000000200e3a7817ULL, 0x000fe20003800000ULL,
0x000000013b357824ULL, 0x000fe200078e0205ULL, 0x0000000531367210ULL, 0x000fe20007ffe0ffULL,
0x000000083b1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f327812ULL, 0x000fe200078ee232ULL,
0x00000080020f7824ULL, 0x000fe200078e00ffULL, 0x0000003a1d00720cULL, 0x080fe20003f86070ULL,
0x00000008311f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c357812ULL, 0x000fe200078ee235ULL,
0x000000011d1d7824ULL, 0x000fe200078e0234ULL, 0x000000806a0e7812ULL, 0x000fe200078ef80fULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0xfffffff81f367812ULL, 0x000fe200078ee236ULL,
0x00000001391f7824ULL, 0x040fe200078e0234ULL, 0x0000001439417810ULL, 0x000fe20007ffe0ffULL,
0x000001001d1c7825ULL, 0x000fe200078e000eULL, 0x0000003a3100720cULL, 0x000fc40003f66070ULL,
0x0000000541377210ULL, 0x000fe20007ffe0ffULL, 0x000000013d387824ULL, 0x040fe200078e0205ULL,
0x0000001c0c287210ULL, 0x040fe20007f3e0ffULL, 0x000000083d297824ULL, 0x000fe200078e00ffULL,
0x0000003a3900720cULL, 0x080fe20003fa6070ULL, 0x000001001f1e7825ULL, 0x000fe200078e000eULL,
0x0000003a3b00720cULL, 0x000fe40003f46070ULL, 0xfffffff829387812ULL, 0x000fe200078ee238ULL,
0x000000010d297824ULL, 0x000fe200008e061dULL, 0x0000001e0c2a7210ULL, 0x000fe20007f1e0ffULL,
0x00002000021d7824ULL, 0x000fe200078e00ffULL, 0x0000001839437810ULL, 0x040fe20007ffe0ffULL,
0x00000001391c7824ULL, 0x040fe200078e0205ULL, 0x0000001c39457810ULL, 0x000fe20007ffe0ffULL,
0x000000010d2b7824ULL, 0x000fe200000e061fULL, 0x000020001d337812ULL, 0x000fe200078ec0ffULL,
0x00000001311f7824ULL, 0x100fe200078e0234ULL, 0x000000071c3c7812ULL, 0x000fe200078ec0ffULL,
0x000000013b1d7824ULL, 0x000fe200078e0234ULL, 0x0000003a3d00720cULL, 0x000fe20003f26070ULL,
0x0000000841307824ULL, 0x000fe200078e00ffULL, 0x0ffffff83c3c7812ULL, 0x000fe200078ef805ULL,
0x000001001f1e7825ULL, 0x000fc600078e000eULL, 0xfffffff830377812ULL, 0x000fe200078ee237ULL,
0x000001001d1c7825ULL, 0x000fe200078e000eULL, 0x0000001e0c1e7210ULL, 0x000fc60007f1e0ffULL,
0x000040000a337824ULL, 0x000fe200078e0233ULL, 0x0000001c0c1c7210ULL, 0x000fe20007fde0ffULL,
0x000000013d317824ULL, 0x100fe200078e0234ULL, 0x0000001f0d1f7210ULL, 0x000fe200007fe4ffULL,
0x0000000143397824ULL, 0x000fe200078e0234ULL, 0x00013000333b7810ULL, 0x000fe20007ffe0ffULL,
0x0000010031307825ULL, 0x000fe200078e000eULL, 0x0000003a4100720cULL, 0x000fc60003f06070ULL,
0x0000000141337824ULL, 0x000fe400078e0234ULL, 0x000000010d1d7824ULL, 0x000fe200030e061dULL,
0x000000300c307210ULL, 0x000fe20007fde0ffULL, 0x0000001032417824ULL, 0x100fe400078e023bULL,
0x000000103c3f7824ULL, 0x000fe400078e023bULL, 0x0000010033327825ULL, 0x000fc600078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a3f7faeULL, 0x0003e2000e901c46ULL,
0x000000010d317824ULL, 0x000fe200030e0631ULL, 0x000000320c327210ULL, 0x000fe20007fde0ffULL,
0x00000001453d7824ULL, 0x000fe200078e0234ULL, 0x0000000028417faeULL, 0x0005e2000e101c46ULL,
0x0000003a4300720cULL, 0x0c0fe20003fa6070ULL, 0x0000000143347824ULL, 0x000fe200078e0205ULL,
0x0000003a4500720cULL, 0x000fe20003f86070ULL, 0x000000010d337824ULL, 0x000fe200030e0633ULL,
0x0000000343437819ULL, 0x000fe200000006ffULL, 0x00000008453a7824ULL, 0x000fc400078e00ffULL,
0x00000100392a7825ULL, 0x002fe200078e000eULL, 0xfffffff843347812ULL, 0x000fc600078ee234ULL,
0x0000000145297824ULL, 0x004fe200078e0205ULL, 0x0000002a0c287210ULL, 0x000fe20007fde0ffULL,
0x000001003d0e7825ULL, 0x000fc600078e000eULL, 0xfffffff83a2a7812ULL, 0x000fe200078ee229ULL,
0x000000010d297824ULL, 0x000fe200030e062bULL, 0x0000000e0c0c7210ULL, 0x000fe20007fde0ffULL,
0x00000010362b7824ULL, 0x100fe400078e023bULL, 0x0000001035357824ULL, 0x100fe200078e023bULL,
0x0000000f0d0d7210ULL, 0x000fe200037fe4ffULL, 0x0000001038397824ULL, 0x100fe200078e023bULL,
0x000000001e2b7faeULL, 0x0003e2000d901c46ULL, 0x0000001037377824ULL, 0x100fe400078e023bULL,
0x00000010343d7824ULL, 0x100fe200078e023bULL, 0x000000001c357faeULL, 0x0003e2000d101c46ULL,
0x000000102a3b7824ULL, 0x000fc600078e023bULL, 0x0000000030397faeULL, 0x0003e8000c901c46ULL,
0x0000000032377faeULL, 0x0003e8000c101c46ULL, 0x00000000283d7faeULL, 0x0003e8000e901c46ULL,
0x000000000c3b7faeULL, 0x0003e2000e101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000000805357811ULL, 0x040fe400078fe8ffULL, 0x00000010051d7811ULL, 0x000fc400078fe8ffULL,
0x0000001805297811ULL, 0x020fe200078fe8ffULL, 0x00000001353a7824ULL, 0x100fe200078e0205ULL,
0x0000000405337811ULL, 0x000fe200078fe8ffULL, 0x00000008350f7824ULL, 0x000fe200078e00ffULL,
0x0000000c051c7811ULL, 0x000fe200078fe8ffULL, 0x000000011d387824ULL, 0x100fe200078e0205ULL,
0x0000001c053d7811ULL, 0x000fe200078fe8ffULL, 0x0000000129367824ULL, 0x100fe200078e0205ULL,
0xfffffff80f3a7812ULL, 0x000fe200078ee23aULL, 0x000000081d0f7824ULL, 0x000fe200078e00ffULL,
0x00000014051f7811ULL, 0x000fe200078fe8ffULL, 0x00000008292b7824ULL, 0x000fe200078e00ffULL,
0x0000003405317211ULL, 0x080fe200078fe8ffULL, 0x00000001333b7824ULL, 0x000fe200078e0205ULL,
0xfffffff80f387812ULL, 0x000fe200078ee238ULL, 0x00000008330e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82b367812ULL, 0x000fe200078ee236ULL, 0x00002000020f7824ULL, 0x040fe200078e00ffULL,
0x000000031f1e7819ULL, 0x000fe200000006ffULL, 0x00000080022b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e3b7812ULL, 0x000fe200078ee23bULL, 0x000000011c397824ULL, 0x040fe200078e0205ULL,
0x000020000f3f7812ULL, 0x000fe200078ec0ffULL, 0x000000081c0e7824ULL, 0x000fe200078e00ffULL,
0x000000806a2a7812ULL, 0x000fe200078ef82bULL, 0x000000011c0f7824ULL, 0x100fe200078e0234ULL,
0x0000003429297210ULL, 0x000fe20007ffe0ffULL, 0x000000013d1c7824ULL, 0x040fe200078e0205ULL,
0xfffffff80e397812ULL, 0x000fe200078ee239ULL, 0x000000083d2b7824ULL, 0x000fe200078e00ffULL,
0x00000005050e7211ULL, 0x000fe200078fe8ffULL, 0x0000000133337824ULL, 0x000fc400078e0234ULL,
0x0000000135357824ULL, 0x000fe200078e0234ULL, 0xfffffff82b3e7812ULL, 0x000fe200078ee21cULL,
0x000000ffff2b7224ULL, 0x000fe200078e00ffULL, 0x000000070e0e7812ULL, 0x000fe200078ec0ffULL,
0x000000011f377824ULL, 0x000fe400078e0205ULL, 0x0000010031307825ULL, 0x000fe200078e002aULL,
0x0ffffff80e3c7812ULL, 0x000fe400078ef805ULL, 0xfffffff81e377812ULL, 0x000fe200078ee237ULL,
0x000000011d1d7824ULL, 0x100fe200078e0234ULL, 0x000000300c307210ULL, 0x000fe20007f1e0ffULL,
0x000000011f1f7824ULL, 0x000fc400078e0234ULL, 0x000000013d3d7824ULL, 0x000fe400078e0234ULL,
0x0000010033327825ULL, 0x000fc800078e002aULL, 0x000040000a3f7824ULL, 0x000fe200078e023fULL,
0x000000320c327210ULL, 0x000fe20007f3e0ffULL, 0x0000010035347825ULL, 0x000fc600078e002aULL,
0x000130003f3f7810ULL, 0x000fe20007ffe0ffULL, 0x000001000f0e7825ULL, 0x100fe200078e002aULL,
0x000000340c347210ULL, 0x000fe40007f5e0ffULL, 0x0000003f38437211ULL, 0x000fe200078e20ffULL,
0x000001001d1c7825ULL, 0x000fe200078e002aULL, 0x0000000e0c0e7210ULL, 0x000fc60007f7e0ffULL,
0x000001001f1e7825ULL, 0x000fc800078e002aULL, 0x0000010029287825ULL, 0x000fc800078e002aULL,
0x000001003d2a7825ULL, 0x000fc800078e002aULL, 0x000000010d317824ULL, 0x040fe200000e0631ULL,
0x0000001c0c1c7210ULL, 0x040fe20007f1e0ffULL, 0x000000010d337824ULL, 0x040fe200008e0633ULL,
0x0000001e0c1e7210ULL, 0x000fe20007f3e0ffULL, 0x000000103c3d7824ULL, 0x000fe400078e023fULL,
0x000000010d357824ULL, 0x000fe200010e0635ULL, 0x000000280c287210ULL, 0x040fe20007f5e0ffULL,
0x000000103b3b7824ULL, 0x000fe200078e023fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000303d7faeULL, 0x0003e2000b901c46ULL, 0x000000010d0f7824ULL, 0x040fe200018e060fULL,
0x0000002a0c0c7210ULL, 0x000fe20007f7e0ffULL, 0x000000103a417824ULL, 0x100fe200078e023fULL,
0x000000290d297210ULL, 0x000fe200017fe4ffULL, 0x0000001039397824ULL, 0x000fe200078e023fULL,
0x00000000323b7faeULL, 0x0003e2000b901c46ULL, 0x000000010d1d7824ULL, 0x000fc400000e061dULL,
0x0000001037377824ULL, 0x000fe200078e023fULL, 0x0000000034417faeULL, 0x0003e2000b901c46ULL,
0x000000010d1f7824ULL, 0x040fe400008e061fULL, 0x0000001036457824ULL, 0x100fe200078e023fULL,
0x000000000e397faeULL, 0x0003e2000b901c46ULL, 0x000000103e3f7824ULL, 0x000fe400078e023fULL,
0x000000010d0d7824ULL, 0x000fe200018e062bULL, 0x000000001c437faeULL, 0x0003e8000b901c46ULL,
0x000000001e377faeULL, 0x0003e8000b901c46ULL, 0x0000000028457faeULL, 0x0003e8000b901c46ULL,
0x000000000c3f7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x000000106e0c7812ULL, 0x000fc400078ec0ffULL, 0x000000086e0d7812ULL, 0x000fc600078ec0ffULL,
0x00000020090c7824ULL, 0x000fc800078e020cULL, 0x000000010d1e7824ULL, 0x000fe200078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b668001e0e7f8cULL, 0x0002a4000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x01b66c001e097984ULL, 0x000ee40000000800ULL,
0x8000000009ff7812ULL, 0x00cfe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c0c1c7210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1d7824ULL, 0x000fe200000e0e0dULL,
0x003d09001c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc8000001141dULL, 0x0000001c09097211ULL, 0x000fca00078110ffULL,
0x000000ffff1c7224ULL, 0x000fca00000e061dULL, 0x0000000209097819ULL, 0x000fc8000000121cULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b66c001e097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001806a097810ULL, 0x000fca0007ffe05cULL,
0x0000000170097824ULL, 0x000fca00078e0209ULL, 0x01b00000090d7984ULL, 0x000ea80000000800ULL,
0x01b20000091c7984ULL, 0x0006620000000800ULL, 0x000000080d00720bULL, 0x004fe20003f1d000ULL,
0x0000d4c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000097806ULL, 0x008fc800000e0100ULL,
0x0000ffff091d7812ULL, 0x000fe2000782c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff0c7224ULL, 0x000fd400078e0008ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x0000000302097811ULL, 0x000fe400078ff0ffULL,
0x000000080d00720bULL, 0x000fe40003f34000ULL, 0x000000020900720cULL, 0x000fe20003f05270ULL,
0x0000d4727f007947ULL, 0x000fd4000b800000ULL, 0x00000000000c7806ULL, 0x000fc400008e0100ULL,
0x00000080020f8824ULL, 0x000fe200078e026aULL, 0x000000080d098209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x000099100c0e7816ULL, 0x000fe200000000ffULL,
0x0000000170708824ULL, 0x000fca00078e020fULL, 0x01b4000970008388ULL, 0x0005e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x000000080d097209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0cff7812ULL, 0x000fc6000780c0ffULL, 0x0000000809097221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x00000009001e7308ULL, 0x002e640000000800ULL,
0x0000001e07077220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff097819ULL, 0x000fe20000011605ULL, 0x0000d3a27f007947ULL, 0x000fea000b800000ULL,
0x00001f091e097589ULL, 0x0002a400000e0000ULL, 0x0000000910107220ULL, 0x084fe40000410000ULL,
0x0000000911117220ULL, 0x080fe40000410000ULL, 0x0000000914147220ULL, 0x080fe40000410000ULL,
0x0000000915157220ULL, 0x000fc40000410000ULL, 0x0000000918187220ULL, 0x080fe40000410000ULL,
0x0000000919197220ULL, 0x080fe40000410000ULL, 0x0000000950507220ULL, 0x080fe40000410000ULL,
0x0000000951517220ULL, 0x080fe40000410000ULL, 0x0000000954547220ULL, 0x080fe40000410000ULL,
0x0000000955557220ULL, 0x000fc40000410000ULL, 0x000000092c2c7220ULL, 0x080fe40000410000ULL,
0x000000092d2d7220ULL, 0x080fe40000410000ULL, 0x0000000920207220ULL, 0x0a0fe40000410000ULL,
0x0000000921217220ULL, 0x080fe40000410000ULL, 0x0000000924247220ULL, 0x080fe40000410000ULL,
0x0000000925257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000805097811ULL, 0x000fe200078ff0ffULL, 0x0000d2a27f007947ULL, 0x000fea000b800000ULL,
0x00001f091e097589ULL, 0x0004e400000e0000ULL, 0x0000000912127220ULL, 0x08cfe40000410000ULL,
0x0000000913137220ULL, 0x080fe40000410000ULL, 0x0000000916167220ULL, 0x080fe40000410000ULL,
0x0000000917177220ULL, 0x080fe40000410000ULL, 0x000000091a1a7220ULL, 0x080fe40000410000ULL,
0x000000091b1b7220ULL, 0x000fc40000410000ULL, 0x0000000952527220ULL, 0x080fe40000410000ULL,
0x0000000953537220ULL, 0x080fe40000410000ULL, 0x0000000956567220ULL, 0x080fe40000410000ULL,
0x0000000957577220ULL, 0x080fe40000410000ULL, 0x000000092e2e7220ULL, 0x080fe40000410000ULL,
0x000000092f2f7220ULL, 0x000fc40000410000ULL, 0x0000000922227220ULL, 0x0a0fe40000410000ULL,
0x0000000923237220ULL, 0x080fe40000410000ULL, 0x0000000926267220ULL, 0x080fe40000410000ULL,
0x0000000927277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff1dff7812ULL, 0x000fe4000780600cULL, 0x000000080d0c7209ULL, 0x000fd60007810000ULL,
0x8000000c0d0d0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL,
0x0000000d00000308ULL, 0x000ea40000000800ULL, 0x000000001c1c0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x000000071c077221ULL, 0x002fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000000ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011605ULL, 0x0000541004087816ULL, 0x000fe20000000004ULL,
0x0000d0f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d08047589ULL, 0x0002a400000e0000ULL,
0x000000080d097810ULL, 0x000fe20007ffe0ffULL, 0x0000d1427f007947ULL, 0x000fea000b800000ULL,
0x00001f0908067589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100d097810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0008ULL,
0x0000001f00357802ULL, 0x000fe20000000f00ULL, 0xffffffffff347424ULL, 0x000fe200078e00ffULL,
0x00008420000f7802ULL, 0x000fc40000000f00ULL, 0x0000d6c000007944ULL, 0x036fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180d097810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0008ULL, 0x00008490000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000d65000007944ULL, 0x032fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000705087812ULL, 0x00afe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x0000000808087812ULL, 0x000fca00078ef805ULL, 0x00000008080e7824ULL, 0x000fe200078e00ffULL,
0x00000002ff087819ULL, 0x000fc80000011602ULL, 0xfffffff80e677812ULL, 0x000fca00078ee267ULL,
0x0000008008407824ULL, 0x000fca00078e0267ULL, 0x0001280040407811ULL, 0x000fca00078e20ffULL,
0x00014000480d7810ULL, 0x000fe20007ffe0ffULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x0000000302097811ULL, 0x004fe400078ff0ffULL, 0x0000000d62447211ULL, 0x000fe200078e20ffULL,
0x00000010614c7824ULL, 0x100fe200078e020dULL, 0x0000030003037a10ULL, 0x000fe20007ffe0ffULL,
0x0000001060487824ULL, 0x100fe200078e020dULL, 0x0001b6a008087811ULL, 0x000fe200078e18ffULL,
0x000000105f3c7824ULL, 0x000fe200078e020dULL, 0x000000004444783bULL, 0x000fe20000004200ULL,
0x00000800091c7824ULL, 0x000fc400078e0258ULL, 0x0000001065387824ULL, 0x100fe200078e020dULL,
0x000000004c4c783bULL, 0x000ea20000004200ULL, 0x0000001064347824ULL, 0x100fe400078e020dULL,
0x0000001063307824ULL, 0x120fe200078e020dULL, 0x000000004848783bULL, 0x000fe20000004200ULL,
0x0000001066287824ULL, 0x000fc600078e020dULL, 0x000000003c3c783bULL, 0x000fe80000004200ULL,
0x011000001c1c783bULL, 0x000ee80000000200ULL, 0x000000003838783bULL, 0x000ee80000004200ULL,
0x000000003434783bULL, 0x000ee80000004200ULL, 0x000000003030783bULL, 0x000ee20000004200ULL,
0x0000000440400232ULL, 0x002fc60000000000ULL, 0x000000002828783bULL, 0x000e620000004200ULL,
0x0000000442420232ULL, 0x000fe40000000000ULL, 0x0000000641410232ULL, 0x080fe40000000000ULL,
0x0000000643430232ULL, 0x000fce0000000000ULL, 0x0000004c4010723cULL, 0x044f700000001810ULL,
0x0000004e4014723cULL, 0x000f620000001814ULL, 0x000000041c1c0232ULL, 0x088fe40000000000ULL,
0x000000041e1e0232ULL, 0x000fca0000000000ULL, 0x000000484018723cULL, 0x000f620000001818ULL,
0x000000061d1d0232ULL, 0x080fe40000000000ULL, 0x000000061f1f0232ULL, 0x000fca0000000000ULL,
0x0000004a4050723cULL, 0x040f700000001850ULL, 0x0000003c4054723cULL, 0x040f700000001854ULL,
0x0000003e402c723cULL, 0x040f70000000182cULL, 0x000000444020723cULL, 0x040f700000001820ULL,
0x000000464024723cULL, 0x000f700000001824ULL, 0x000000381c10723cULL, 0x060b700000001810ULL,
0x0000003a1c14723cULL, 0x040b700000001814ULL, 0x000000341c18723cULL, 0x040b700000001818ULL,
0x000000361c50723cULL, 0x040b700000001850ULL, 0x000000301c54723cULL, 0x040b700000001854ULL,
0x000000321c2c723cULL, 0x040b70000000182cULL, 0x000000281c20723cULL, 0x042b700000001820ULL,
0x0000002a1c1c723cULL, 0x000b620000001824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000005e0300720cULL, 0x000fe20003f06070ULL, 0x0000000008ff7f8cULL, 0x0003d8000c80043fULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff935000007947ULL, 0x000fea000383ffffULL,
0x0000000000047919ULL, 0x000e640000002500ULL, 0x0000005e0400720cULL, 0x002fda0003f06070ULL,
0x0000032000000947ULL, 0x000fea0003800000ULL, 0x0180000007007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000894000087802ULL, 0x000fc40000000f00ULL, 0x0000cff000007944ULL, 0x030fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000700007308ULL, 0x000e640000001000ULL,
0xbf80000000037423ULL, 0x002fc80000000007ULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x00000002ff037819ULL, 0x002fe40000011605ULL,
0x0000000805057811ULL, 0x000fc800078ff0ffULL, 0x00001f0300037589ULL, 0x00ce6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000001003107220ULL, 0x062fe40000410000ULL,
0x0000001103117220ULL, 0x040fe40000410000ULL, 0x0000001403147220ULL, 0x040fe40000410000ULL,
0x0000001503157220ULL, 0x000fc40000410000ULL, 0x0000001803187220ULL, 0x040fe40000410000ULL,
0x0000001903197220ULL, 0x040fe40000410000ULL, 0x0000005003507220ULL, 0x040fe40000410000ULL,
0x0000005103517220ULL, 0x040fe40000410000ULL, 0x0000005403547220ULL, 0x040fe40000410000ULL,
0x0000005503557220ULL, 0x000fc40000410000ULL, 0x0000002c032c7220ULL, 0x040fe40000410000ULL,
0x0000002d032d7220ULL, 0x040fe40000410000ULL, 0x0000002003207220ULL, 0x040fe40000410000ULL,
0x0000002103217220ULL, 0x040fe40000410000ULL, 0x0000001c031c7220ULL, 0x040fe40000410000ULL,
0x0000001d031d7220ULL, 0x000fc40000410000ULL, 0x0000001205127220ULL, 0x044fe40000410000ULL,
0x0000001305137220ULL, 0x040fe40000410000ULL, 0x0000001605167220ULL, 0x040fe40000410000ULL,
0x0000001705177220ULL, 0x040fe40000410000ULL, 0x0000001a051a7220ULL, 0x040fe40000410000ULL,
0x0000001b051b7220ULL, 0x000fc40000410000ULL, 0x0000005205527220ULL, 0x040fe40000410000ULL,
0x0000005305537220ULL, 0x040fe40000410000ULL, 0x0000005605567220ULL, 0x040fe40000410000ULL,
0x0000005705577220ULL, 0x040fe40000410000ULL, 0x0000002e052e7220ULL, 0x040fe40000410000ULL,
0x0000002f052f7220ULL, 0x000fc40000410000ULL, 0x0000002205227220ULL, 0x040fe40000410000ULL,
0x0000002305237220ULL, 0x040fe40000410000ULL, 0x0000001e051e7220ULL, 0x040fe40000410000ULL,
0x0000001f051f7220ULL, 0x000fc40000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x00000020210f723eULL, 0x020fe400000000ffULL, 0x000000101105723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000121311723eULL, 0x000fc400000000ffULL,
0x0000001a1b13723eULL, 0x000fe400000000ffULL, 0x000000181909723eULL, 0x000fe400000000ffULL,
0x0000001c1d10723eULL, 0x000fe400000000ffULL, 0x0000001e1f18723eULL, 0x000fe400000000ffULL,
0x000000161712723eULL, 0x000fe400000000ffULL, 0x000000222317723eULL, 0x000fc400000000ffULL,
0x00000002ff207819ULL, 0x002fe40000011600ULL, 0x0000000800297811ULL, 0x000fe400078ff0ffULL,
0x0000000120037810ULL, 0x040fe20007ffe0ffULL, 0x00000008201a7824ULL, 0x040fe200078e00ffULL,
0x0000000520197810ULL, 0x040fe20007ffe0ffULL, 0x00000008201d7824ULL, 0x040fe200078e00ffULL,
0x00000003201e7819ULL, 0x040fe200000006ffULL, 0x00000008201c7824ULL, 0x040fe200078e00ffULL,
0x0000000220067810ULL, 0x040fe20007ffe0ffULL, 0x0000000820257824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1b7812ULL, 0x000fe200078ee203ULL, 0x0000000820217824ULL, 0x040fe200078e00ffULL,
0x0000000320037810ULL, 0x040fe20007ffe0ffULL, 0x0000000820277824ULL, 0x040fe200078e00ffULL,
0x00000006201a7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81e237812ULL, 0x000fe200078ee219ULL,
0x0000000820197824ULL, 0x040fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL,
0x00000008291e7824ULL, 0x000fe200078e00ffULL, 0x0000000420067810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81c1f7812ULL, 0x000fe200078ee203ULL, 0x000010006b037824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee21aULL, 0x00000004001a7824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee206ULL, 0x000008000a067824ULL, 0x000fe200078e0203ULL,
0xfffffff819197812ULL, 0x000fc400078ee220ULL, 0xffffffff201c7810ULL, 0x000fe20007ffe0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0206ULL, 0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL,
0x0000001019197824ULL, 0x100fe200078e0206ULL, 0x000000061d1d7211ULL, 0x000fe200078e20ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0206ULL, 0xfffffff827277812ULL, 0x000fe200078ee21cULL,
0x0000001021217824ULL, 0x000fe200078e0206ULL, 0xfffffff81e297812ULL, 0x000fe200078ee229ULL,
0x00000001191c7824ULL, 0x000fe200078e021aULL, 0x000000141508723eULL, 0x000fe200000000ffULL,
0x0000001023237824ULL, 0x100fe200078e0206ULL, 0x00000050510b723eULL, 0x000fe200000000ffULL,
0x000000011a1b7824ULL, 0x040fe200078e021bULL, 0x0000001f1a1f7210ULL, 0x040fe20007ffe0ffULL,
0x0000001025257824ULL, 0x100fe200078e0206ULL, 0x00000054550d723eULL, 0x000fe200000000ffULL,
0x000000011a1e7824ULL, 0x040fe200078e021dULL, 0x0000002c2d0e723eULL, 0x000fe200000000ffULL,
0x0000001027277824ULL, 0x100fe200078e0206ULL, 0x000000051c007388ULL, 0x0003e20000000800ULL,
0x0000001029297824ULL, 0x000fe200078e0206ULL, 0x000000525314723eULL, 0x000fe200000000ffULL,
0x000000011a207824ULL, 0x040fe200078e0221ULL, 0x000000081b007388ULL, 0x000fe20000000800ULL,
0x000000011a237824ULL, 0x040fe200078e0223ULL, 0x000000565715723eULL, 0x000fe200000000ffULL,
0x000000011a227824ULL, 0x040fe200078e0225ULL, 0x000000091e007388ULL, 0x000fe20000000800ULL,
0x000000011a277824ULL, 0x040fe200078e0227ULL, 0x0000002e2f16723eULL, 0x000fe200000000ffULL,
0x000000011a1a7824ULL, 0x000fe200078e0229ULL, 0x0000000b1f007388ULL, 0x0005e20000000800ULL,
0x000000016f1c7824ULL, 0x002fc400078e0200ULL, 0x00000300ff217624ULL, 0x000fe200078e00ffULL,
0x0000000d20007388ULL, 0x000fe80000000800ULL, 0x0000000e23007388ULL, 0x000fe20000000800ULL,
0x000000012100780cULL, 0x000fe20003f05270ULL, 0x000000101c0b7824ULL, 0x004fe400078e0203ULL,
0x0000000f22007388ULL, 0x000fe80000000800ULL, 0x0000001027007388ULL, 0x000fe80000000800ULL,
0x000000111a007388ULL, 0x000fe80000000800ULL, 0x000400121b007388ULL, 0x000fe80000000800ULL,
0x000400131e007388ULL, 0x000fe80000000800ULL, 0x000400141f007388ULL, 0x000fe80000000800ULL,
0x0004001520007388ULL, 0x000fe80000000800ULL, 0x0004001623007388ULL, 0x000fe80000000800ULL,
0x0004001722007388ULL, 0x000fe80000000800ULL, 0x0004001827007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000b287984ULL, 0x000e680000000c00ULL,
0x000400000b107984ULL, 0x000ea80000000c00ULL, 0x000800000b2c7984ULL, 0x000ee80000000c00ULL,
0x000c00000b307984ULL, 0x000ee20000000c00ULL, 0x200000ff2b2b7230ULL, 0x002fc40000000000ULL,
0x200000ff2a2a7230ULL, 0x000fe40000000000ULL, 0x200000ff29297230ULL, 0x000fe40000000000ULL,
0x200000ff28287230ULL, 0x000fe40000000000ULL, 0x200000ff13137230ULL, 0x004fe40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fc40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x0000002f2b2b7230ULL, 0x008fe40000000000ULL,
0x0000002e2a2a7230ULL, 0x000fe40000000000ULL, 0x0000002d29297230ULL, 0x000fe40000000000ULL,
0x0000002c28287230ULL, 0x000fe40000000000ULL, 0x0000003313137230ULL, 0x000fc40000000000ULL,
0x0000003212127230ULL, 0x000fe20000000000ULL, 0x000000280b007388ULL, 0x000fe20000000c00ULL,
0x0000003111117230ULL, 0x000fe40000000000ULL, 0x0000003010107230ULL, 0x000fca0000000000ULL,
0x000400100b007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00002a7000008947ULL, 0x000fea0003800000ULL, 0x00000400ff057624ULL, 0x000fe200078e00ffULL,
0x00000000000d7919ULL, 0x000e660000002600ULL, 0x00006c0005057a24ULL, 0x000fe200078e02ffULL,
0x0000000000187919ULL, 0x000e680000002700ULL, 0x0000000f050e7811ULL, 0x040fe200078e10ffULL,
0x0000030005057a24ULL, 0x000fe200078e02ffULL, 0x000000000b107984ULL, 0x000ea40000000c00ULL,
0xfffffff00e0e7812ULL, 0x000fc400078ec0ffULL, 0x000400000b147984ULL, 0x0006a40000000c00ULL,
0x0000000e05087211ULL, 0x000fca00078e38ffULL, 0x0000008005057824ULL, 0x000fe200078e0208ULL,
0x000000401c0b7810ULL, 0x008fc80007ffe0ffULL, 0x0000007f05057810ULL, 0x000fe20007ffe0ffULL,
0x00000400180d7a24ULL, 0x002fc600078e020dULL, 0xffffff8005057812ULL, 0x000fe200078ec0ffULL,
0x000003000d097a24ULL, 0x000fc600078e02ffULL, 0x0000700005197a10ULL, 0x000fe20007f1e0ffULL,
0x0000000109047824ULL, 0x000fc800078e0204ULL, 0x00007100ff0f7624ULL, 0x000fe200000e06ffULL,
0x000000010aff7812ULL, 0x000fe4000780f802ULL, 0x0000001904187211ULL, 0x000fc800078260ffULL,
0x0000000f04197211ULL, 0x000fe400008f64ffULL, 0x000070000e207a10ULL, 0x000fc60007f3e0ffULL,
0x000008006b187825ULL, 0x000fc800078e0018ULL, 0x00007100ff0f7624ULL, 0x000fe400008e06ffULL,
0x000000101c1a7825ULL, 0x000fc800078e0018ULL, 0x000000100b187825ULL, 0x000fe200078e0018ULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x00000010001c7824ULL, 0x004fe200078e00ffULL,
0x00000001ff1d7819ULL, 0x000fe20000011600ULL, 0x00000080040b7824ULL, 0x000fe200078e00ffULL,
0x00000019ff047819ULL, 0x000fe40000011604ULL, 0x000000701c1f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c1d1c7812ULL, 0x000fe400078ec0ffULL, 0x000070000b1e7a10ULL, 0x000fc40007ebe008ULL,
0x000000201f0b7210ULL, 0x000fe40007a3e00bULL, 0x0000001e1c1e7210ULL, 0x000fe40007c7e01fULL,
0x00007100041d7a10ULL, 0x000fe40002fec4ffULL, 0x0000000b1c1c7210ULL, 0x000fe40007fbe0ffULL,
0x0000000fff047210ULL, 0x000fe40000fe4404ULL, 0x0000001dff1f7210ULL, 0x000fc60001fe84ffULL,
0x000000ffff1d7224ULL, 0x000fca00028e0604ULL, 0x0000000c1c007986ULL, 0x0003e8000c101906ULL,
0x000000071e007986ULL, 0x0003e4000c101906ULL, 0x000000ff0000720cULL, 0x004fe20000705670ULL,
0x000000101a007986ULL, 0x000fe2000c101d06ULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x0000001418007986ULL, 0x000fe8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000004ff0c7424ULL, 0x002fe200078e00ffULL,
0xffffffff21077810ULL, 0x000fc60007ffe0ffULL, 0x000070000d0c7625ULL, 0x000fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x000000070c0c79a8ULL, 0x000ea400099ee1c6ULL,
0x000000070c00720cULL, 0x004fc80003f05270ULL, 0x00000001ff047807ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000004ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000ff047984ULL, 0x002e640000000000ULL, 0x000000ff0400720cULL, 0x002fda0003f05270ULL,
0x000025f000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x000fda0003f05270ULL,
0x00000a5000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x000001b000008947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fe40000011600ULL, 0x00000020090c7211ULL, 0x000fe400078038ffULL,
0x00000070040d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c07077812ULL, 0x000fe400078ec0ffULL,
0x0000000f09047211ULL, 0x000fe400000f3cffULL, 0x0000000c070c7210ULL, 0x000fc8000791e00dULL,
0x00000004ff0d7210ULL, 0x000fca00007e24ffULL, 0x000000060c047981ULL, 0x000328000c1e1900ULL,
0x000080060c077981ULL, 0x000322000c1e1900ULL, 0x000000022100780cULL, 0x000fda0003f05270ULL,
0x000000f000008947ULL, 0x000fea0003800000ULL, 0x000100060c0b7981ULL, 0x002322000c1e1900ULL,
0x000000042100780cULL, 0x000fda0003f06070ULL, 0x000000c000008947ULL, 0x000fea0003800000ULL,
0x000180060c0f7981ULL, 0x002322000c1e1900ULL, 0x000000042100780cULL, 0x000fda0003f05270ULL,
0x0000009000008947ULL, 0x000fea0003800000ULL, 0x000200060c117981ULL, 0x002322000c1e1900ULL,
0x000000062100780cULL, 0x000fda0003f06070ULL, 0x0000006000008947ULL, 0x000fea0003800000ULL,
0x000280060c137981ULL, 0x002322000c1e1900ULL, 0x000000062100780cULL, 0x000fda0003f05270ULL,
0x0000003000008947ULL, 0x000fea0003800000ULL, 0x000000082100780cULL, 0x002fe20003f06070ULL,
0x000300060c157981ULL, 0x000318000c1e1900ULL, 0x000380060c170981ULL, 0x000324000c1e1900ULL,
0x00000007210c7810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff107819ULL, 0x000fc8000001160cULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x000007d000008947ULL, 0x000fea0003800000ULL,
0x0000000e091b7211ULL, 0x000fe200078038ffULL, 0x000000ffff197224ULL, 0x010fe200078e0004ULL,
0x000000ff00147202ULL, 0x000fe20000000f00ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000070001b1b7a10ULL, 0x000fe40007f3e0ffULL, 0x000000ff09127211ULL, 0x000fe400000f3cffULL,
0x000007801b1b7810ULL, 0x000fc80007f5e0ffULL, 0x00007100ff127a10ULL, 0x000fc400017e2412ULL,
0x0000030014007a0cULL, 0x000fe20003f26070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x0000000410007c0cULL, 0x000fcc000bf03070ULL, 0x000006d000001947ULL, 0x012fea0003800000ULL,
0x00000008140c7810ULL, 0x040fe40007ffe0ffULL, 0x00000001140d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001904047209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011600ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1b0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0612ULL,
0xfffc80060c197981ULL, 0x000326000c1e1900ULL, 0x000005f000002947ULL, 0x000fea0003800000ULL,
0x00000009140c7810ULL, 0x042fe40007ffe0ffULL, 0x00000002140d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000000704047209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000077824ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fc80000011600ULL,
0x0000007007077812ULL, 0x000fc800078ec0ffULL, 0x0000000c070c7812ULL, 0x000fc800078ef80cULL,
0x0000000c1b0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0612ULL,
0xfffd00060c077981ULL, 0x000326000c1e1900ULL, 0x0000051000002947ULL, 0x000fea0003800000ULL,
0x0000000a140c7810ULL, 0x042fe40007ffe0ffULL, 0x00000003140d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000000b04047209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010000b7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fc80000011600ULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0b0c7812ULL, 0x000fc800078ef80cULL,
0x0000000c1b0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0612ULL,
0xfffd80060c0b7981ULL, 0x000326000c1e1900ULL, 0x0000043000002947ULL, 0x000fea0003800000ULL,
0x0000000b140c7810ULL, 0x042fe40007ffe0ffULL, 0x00000004140d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000000f04047209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011600ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1b0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0612ULL,
0xfffe00060c0f7981ULL, 0x000326000c1e1900ULL, 0x0000035000002947ULL, 0x000fea0003800000ULL,
0x0000000c140c7810ULL, 0x042fe40007ffe0ffULL, 0x00000005140d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001104047209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000004000c7819ULL, 0x000fe400000006ffULL, 0x00000001ff0d7819ULL, 0x000fe40000011600ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1b0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0612ULL,
0xfffe80060c117981ULL, 0x000326000c1e1900ULL, 0x0000027000002947ULL, 0x000fea0003800000ULL,
0x0000000d140c7810ULL, 0x042fe40007ffe0ffULL, 0x00000006140d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001304047209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011600ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1b0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0612ULL,
0xffff00060c137981ULL, 0x000326000c1e1900ULL, 0x0000019000002947ULL, 0x000fea0003800000ULL,
0x0000000e140c7810ULL, 0x042fe40007ffe0ffULL, 0x00000007140d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001504047209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011600ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1b0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0612ULL,
0xffff80060c157981ULL, 0x000326000c1e1900ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000000f140c7810ULL, 0x002fe40007ffe0ffULL, 0x0000001704047209ULL, 0x000fe40007810000ULL,
0x000003000c007a0cULL, 0x000fda0003f26070ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011600ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1b0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0612ULL,
0x000000060c177981ULL, 0x000326000c1e1900ULL, 0x000004001b1b7810ULL, 0x000fe40007f3e0ffULL,
0x0000000814147810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200008e0612ULL,
0xfffff8b000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x0000001000077824ULL, 0x014fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fc80000011600ULL,
0x0000007007077812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b0c7812ULL, 0x002fc800078ec0ffULL,
0x0000000c07077210ULL, 0x000fca0007ffe0ffULL, 0x0000000407007388ULL, 0x0003e40000000800ULL,
0x000000070000780cULL, 0x000fe20003f04070ULL, 0x000000010a197824ULL, 0x040fe200078e0209ULL,
0x0000700005047a10ULL, 0x002fe20007f3e0ffULL, 0x000008006b077824ULL, 0x000fe200078e00ffULL,
0x00000002ff0b7819ULL, 0x000fe20000011602ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00007100ff057624ULL, 0x000fe200008e06ffULL, 0x000000010b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000020a128824ULL, 0x000fe200078e026bULL, 0x0000002000137810ULL, 0x040fe20007ffe0ffULL,
0x00001000190c7825ULL, 0x000fe200078e0004ULL, 0x0000004000157810ULL, 0x040fe20007ffe0ffULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000060001d7810ULL, 0x000fe20007ffe0ffULL,
0x000000020a148824ULL, 0x000fe200078e026bULL, 0x000000070c107210ULL, 0x000fe20007f3e0ffULL,
0x00000002121b8824ULL, 0x100fe200078e020bULL, 0x00000001ff0c7819ULL, 0x000fe20000011600ULL,
0x0000000214238824ULL, 0x000fe200078e020bULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000200020b7824ULL, 0x000fe200078e00ffULL, 0x0000000c0c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff117224ULL, 0x000fe200008e060dULL, 0x0000700008027a10ULL, 0x000fe20007f3e0ffULL,
0x00000010000d7824ULL, 0x000fe200078e00ffULL, 0x000000030a087211ULL, 0x000fe200078e68ffULL,
0x0000001013127825ULL, 0x000fe200078e0010ULL, 0x000008000b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000000700d0d7812ULL, 0x000fe200078ec0ffULL,
0x00007100ff167624ULL, 0x000fe200008e06ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000001080b7824ULL, 0x000fe200078e020bULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000010d177824ULL, 0x000fe200078e020cULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000010001f7824ULL, 0x000fe200078e020bULL, 0x000070000e0b7a10ULL, 0x000fe20007f5e0ffULL,
0x0000001015147825ULL, 0x100fe200078e0010ULL, 0x00000002190e8211ULL, 0x040fe200078238ffULL,
0x0000000017177984ULL, 0x000e620000000800ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00007100ff187624ULL, 0x000fe200010e06ffULL, 0x0000000b191a8211ULL, 0x000fe200078438ffULL,
0x000000101d1c7825ULL, 0x100fe200078e0010ULL, 0x00000016190f8211ULL, 0x000fe200008f3cffULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x000003000a007a0cULL, 0x000fe20003f26070ULL,
0x0000001000107825ULL, 0x040fe200078e0010ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x000000081b218824ULL, 0x100fe200078e0200ULL, 0x00000018191b8211ULL, 0x000fe200010f3cffULL,
0x0000000823238824ULL, 0x000fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000101f7faeULL, 0x0005e2000b901c46ULL, 0x00000010000e8825ULL, 0x000fe200078e000eULL,
0x0000458021218811ULL, 0x000fc400078e20ffULL, 0x0000418023238811ULL, 0x000fe200078e20ffULL,
0x00380000121f7faeULL, 0x0007e2000b901c46ULL, 0x000000ffff197224ULL, 0x000fc600078e00ffULL,
0x00580000141f7faeULL, 0x0007e2000b901c46ULL, 0x0000001000108825ULL, 0x004fc600078e001aULL,
0x007800001c1f7faeULL, 0x0005e2000b901c46ULL, 0x00000000001a7805ULL, 0x000fc6000001ff00ULL,
0x000000000e218faeULL, 0x0003e8000b901c46ULL, 0x0000000010238faeULL, 0x0003e8000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000001c7805ULL, 0x004fe2000001ff00ULL,
0x00000000001e7805ULL, 0x008fe2000001ff00ULL, 0x0000000000207805ULL, 0x002fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000c6000001947ULL, 0x000fea0003800000ULL,
0x000000ff00197202ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fca00078e000aULL,
0x000000023b3a7810ULL, 0x000fc80007ffe0ffULL, 0x000003003a007a0cULL, 0x000fda0003f06070ULL,
0x0000029000000947ULL, 0x000fea0003800000ULL, 0x0000000109157824ULL, 0x100fe200078e023aULL,
0x000000070000780cULL, 0x040fe40003f44070ULL, 0x00000001ff0e7819ULL, 0x000fe2000001163aULL,
0x00001000150c7825ULL, 0x000fe200078e0004ULL, 0x0000004000437810ULL, 0x000fe40007ffe0ffULL,
0x000000010e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000070c127210ULL, 0x000fe20007f1e0ffULL,
0x000004003a0c7824ULL, 0x000fe200078e00ffULL, 0x0000006000457810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200000e060dULL, 0x000008000c0d7812ULL, 0x000fe200078ec0ffULL,
0x000000020a0fa824ULL, 0x140fe200078e026bULL, 0x000000021510a211ULL, 0x040fe200078038ffULL,
0x000000020a41a824ULL, 0x000fe200078e026bULL, 0x0000000b1514a211ULL, 0x000fe200078238ffULL,
0x000000020f47a824ULL, 0x100fe200078e020eULL, 0x00000020000f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001080d7824ULL, 0x000fe200078e020dULL, 0x000000161511a211ULL, 0x000fe200000f3cffULL,
0x000000024141a824ULL, 0x000fe200078e020eULL, 0x000000181515a211ULL, 0x000fe200008f3cffULL,
0x00000010003c7825ULL, 0x040fe200078e0012ULL, 0x0000000d003f7211ULL, 0x000fc600078e20ffULL,
0x000000100f0c7825ULL, 0x100fe400078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800003c3f7faeULL, 0x0003e4000b901c46ULL, 0x00000010430e7825ULL, 0x000fe400078e0012ULL,
0x003800000c3f7faeULL, 0x0003e4000b901c46ULL, 0x000000084141a824ULL, 0x100fe400078e0200ULL,
0x000000084743a824ULL, 0x000fe200078e0200ULL, 0x005800000e3f7faeULL, 0x0003e2000b901c46ULL,
0x0000001045127825ULL, 0x000fe200078e0012ULL, 0x000045804141a811ULL, 0x000fc400078e20ffULL,
0x000041804343a811ULL, 0x000fe200078e20ffULL, 0x000000100010a825ULL, 0x040fe200078e0010ULL,
0x00780000123f7faeULL, 0x0003e6000b901c46ULL, 0x000000100014a825ULL, 0x000fe200078e0014ULL,
0x000000001041afaeULL, 0x0003e8000b901c46ULL, 0x000000001443afaeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000403b0c7824ULL, 0x002fe200078e00ffULL,
0x00000001ff107819ULL, 0x100fe20000011600ULL, 0x000000020a0f7824ULL, 0x000fe200078e026bULL,
0x00000002ff3f7819ULL, 0x000fe20000011600ULL, 0x00000010000d7824ULL, 0x000fe200078e00ffULL,
0x000000800c0c7812ULL, 0x000fc400078ec0ffULL, 0x000000083f497810ULL, 0x040fe20007ffe0ffULL,
0x000000083f137824ULL, 0x000fe200078e00ffULL, 0x000000700d0d7812ULL, 0x000fe200078ec0ffULL,
0x000001000f0e7824ULL, 0x000fe200078e000cULL, 0x0000000c100c7812ULL, 0x000fe200078ec0ffULL,
0x000000083f147824ULL, 0x040fe200078e00ffULL, 0x000000023f0f7810ULL, 0x040fe20007ffe0ffULL,
0x000000083f447824ULL, 0x040fe200078e00ffULL, 0x0000000e0c107210ULL, 0x000fe20007ffe00dULL,
0x000000083f427824ULL, 0x040fe200078e00ffULL, 0x000000013f0e7810ULL, 0x040fe20007ffe0ffULL,
0x000000083f437824ULL, 0x000fe200078e00ffULL, 0xfffffff814117812ULL, 0x000fc400078ee23fULL,
0xfffffff813137812ULL, 0x000fe200078ee20eULL, 0x000004003b0e7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800010127984ULL, 0x000e620000000800ULL,
0xfffffff8143b7812ULL, 0x000fe200078ee20fULL, 0x0000000849147824ULL, 0x000fe200078e00ffULL,
0x000008000e0f7812ULL, 0x000fe200078ec0ffULL, 0x00458000103c7984ULL, 0x0004e20000000800ULL,
0x00000002000e7819ULL, 0x000fe400000006ffULL, 0x000000033f3d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000c0e467812ULL, 0x000fe400078ec0ffULL, 0xfffffff8423d7812ULL, 0x000fc400078ee23dULL,
0x0000018008107810ULL, 0x004fe40007ffe00fULL, 0xfffffff8140f7812ULL, 0x000fe400078ee249ULL,
0x000000043f3e7810ULL, 0x000fe20007ffe0ffULL, 0x00000010110e7824ULL, 0x100fe400078e0210ULL,
0x000000100f0f7824ULL, 0x000fe200078e0210ULL, 0xfffffff843437812ULL, 0x000fe200078ee23eULL,
0x00000001460e7824ULL, 0x040fe200078e020eULL, 0xffffffff3f3e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000146147824ULL, 0x000fc400078e020fULL, 0x00000010130f7824ULL, 0x000fe200078e0210ULL,
0x000000000e117984ULL, 0x000ea20000000800ULL, 0x000000053f137810ULL, 0x000fc60007ffe0ffULL,
0x0000000014407984ULL, 0x000ea20000000800ULL, 0x0000000f460f7210ULL, 0x000fe40007ffe0ffULL,
0xfffffff844457812ULL, 0x000fe200078ee213ULL, 0x000000103b137824ULL, 0x000fe200078e0210ULL,
0x000000063f3b7810ULL, 0x000fe20007ffe0ffULL, 0x000400000f417984ULL, 0x000fe40000000800ULL,
0x0000000146137824ULL, 0x000fe400078e0213ULL, 0x0000001217127221ULL, 0x002fc60000010100ULL,
0x0000000013147984ULL, 0x000fe20000000800ULL, 0x3fb8aa3b12127820ULL, 0x000fc60000410000ULL,
0x0004000013427984ULL, 0x0005e20000000800ULL, 0x0000001200157308ULL, 0x0002e60000000800ULL,
0x000000000f127984ULL, 0x002fe20000000800ULL, 0x0000003c15447220ULL, 0x008fe40000410000ULL,
0x000000083f3c7824ULL, 0x000fe200078e00ffULL, 0x20000011ff137230ULL, 0x104fe20000004100ULL,
0x000000103d157824ULL, 0x100fe200078e0210ULL, 0x00001f3f440e7589ULL, 0x0002a200000e0000ULL,
0x000000083f3d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c477812ULL, 0x000fe200078ee23bULL,
0x0000000146157824ULL, 0x040fe200078e0215ULL, 0x00001f49440f7589ULL, 0x000ee200000e0000ULL,
0x00000010433c7824ULL, 0x000fe200078e0210ULL, 0xfffffff83d437812ULL, 0x000fe200078ee23eULL,
0x00000010453d7824ULL, 0x000fe200078e0210ULL, 0x00000000153b7984ULL, 0x000ee20000000800ULL,
0x00000001463c7824ULL, 0x040fe200078e023cULL, 0x30000011ff457230ULL, 0x000fe20000004100ULL,
0x00000001463d7824ULL, 0x000fe200078e023dULL, 0x00000010473e7211ULL, 0x000fe200078e20ffULL,
0x00000010433f7824ULL, 0x002fc400078e0210ULL, 0x000000003c107984ULL, 0x000e620000000800ULL,
0x0000003944397221ULL, 0x000fe40000010000ULL, 0x00000001463e7824ULL, 0x040fe200078e023eULL,
0x000000003d117984ULL, 0x000e620000000800ULL, 0x00000001463f7824ULL, 0x000fe200078e023fULL,
0x20000040ff467230ULL, 0x100fe40000004100ULL, 0x0004000015437984ULL, 0x000e620000000800ULL,
0x30000040ff407230ULL, 0x000fe20000004100ULL, 0x0000000e45367223ULL, 0x004fc40000010036ULL,
0x000400003d157984ULL, 0x000ea20000000800ULL, 0x0000000e13377223ULL, 0x080fe20000010037ULL,
0x30000012ff457230ULL, 0x100fe20000004100ULL, 0x0000000f40347223ULL, 0x088fe20000010034ULL,
0x000400003c447984ULL, 0x000ee20000000800ULL, 0x20000012ff407230ULL, 0x000fe20000004100ULL,
0x0000000f46357223ULL, 0x080fe20000010035ULL, 0x20000041ff127230ULL, 0x100fe20000004100ULL,
0x000000003e137984ULL, 0x000ee20000000800ULL, 0x30000041ff417230ULL, 0x000fe20000004100ULL,
0x0000000e40337223ULL, 0x080fe20000010033ULL, 0x20000042ff407230ULL, 0x100fe20000004100ULL,
0x000400003e3c7984ULL, 0x000ee20000000800ULL, 0x0000000f12317223ULL, 0x080fe20000010031ULL,
0x30000042ff427230ULL, 0x000fe20000004100ULL, 0x0000000f41307223ULL, 0x080fe20000010030ULL,
0x000000003f127984ULL, 0x000ee20000000800ULL, 0x20000014ff417230ULL, 0x100fe20000004100ULL,
0x0000000e45327223ULL, 0x000fe20000010032ULL, 0x30000014ff147230ULL, 0x000fe20000004100ULL,
0x000400003f3d7984ULL, 0x0002e20000000800ULL, 0x0000000f402a7223ULL, 0x000fc4000001002aULL,
0x0000000e412c7223ULL, 0x080fe2000001002cULL, 0x2000003bff417230ULL, 0x100fe20000004100ULL,
0x0000000e142b7223ULL, 0x080fe2000001002bULL, 0x3000003bff3b7230ULL, 0x000fe20000004100ULL,
0x0000000f42297223ULL, 0x080fe20000010029ULL, 0x20000010ff3f7230ULL, 0x102fe20000004100ULL,
0x0000000e41287223ULL, 0x080fe20000010028ULL, 0x30000010ff107230ULL, 0x000fe20000004100ULL,
0x0000000e3b277223ULL, 0x080fe20000010027ULL, 0x20000011ff3b7230ULL, 0x100fe20000004100ULL,
0x0000000e3f247223ULL, 0x080fe20000010024ULL, 0x30000011ff117230ULL, 0x000fe20000004100ULL,
0x0000000e10237223ULL, 0x080fe20000010023ULL, 0x20000043ff147230ULL, 0x100fe20000004100ULL,
0x0000000e3b207223ULL, 0x000fe20000010020ULL, 0x30000043ff3e7230ULL, 0x000fe20000004100ULL,
0x000000ffff3b7224ULL, 0x000fe200078e003aULL, 0x20000015ff107230ULL, 0x004fe20000004100ULL,
0x0000000f14267223ULL, 0x000fc40000010026ULL, 0x0000000e111f7223ULL, 0x080fe2000001001fULL,
0x20000044ff147230ULL, 0x108fe20000004100ULL, 0x000003003b007a0cULL, 0x000fe20003f06070ULL,
0x0000000f101e7223ULL, 0x080fe2000001001eULL, 0x30000044ff447230ULL, 0x000fe20000004100ULL,
0x0000000f3e257223ULL, 0x080fe20000010025ULL, 0x20000013ff117230ULL, 0x000fe20000004100ULL,
0x0000000f14227223ULL, 0x080fe20000010022ULL, 0x30000015ff147230ULL, 0x000fe20000004100ULL,
0x0000000f44217223ULL, 0x080fe20000010021ULL, 0x2000003cff107230ULL, 0x000fe20000004100ULL,
0x0000000e111c7223ULL, 0x080fe2000001001cULL, 0x30000013ff137230ULL, 0x000fe20000004100ULL,
0x0000000f141d7223ULL, 0x080fe2000001001dULL, 0x30000012ff117230ULL, 0x100fe20000004100ULL,
0x0000000f101a7223ULL, 0x080fe2000001001aULL, 0x20000012ff107230ULL, 0x000fe20000004100ULL,
0x0000000e131b7223ULL, 0x080fe2000001001bULL, 0x3000003cff3c7230ULL, 0x000fe20000004100ULL,
0x0000000e112e7223ULL, 0x080fe2000001002eULL, 0x2000003dff127230ULL, 0x100fe20000004100ULL,
0x0000000e102f7223ULL, 0x000fe2000001002fULL, 0x3000003dff147230ULL, 0x000fe20000004100ULL,
0x0000000f3c387223ULL, 0x000fc40000010038ULL, 0x0000000f122d7223ULL, 0x080fe4000001002dULL,
0x0000000f14197223ULL, 0x000fe20000010019ULL, 0xfffff3c000008947ULL, 0x000fea000383ffffULL,
0x000000ff6b00720cULL, 0x000fe20003f05270ULL, 0x0000018000007945ULL, 0x000fd80003800000ULL,
0x000000800a058824ULL, 0x000fc800078e020dULL, 0x000000010c008824ULL, 0x000fe400078e0205ULL,
0x000000010d0c7824ULL, 0x000fc600078e020cULL, 0x0049803900008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x004980000c027984ULL, 0x000e680000000800ULL,
0x004a00000c057984ULL, 0x000ea20000000800ULL, 0x00000002ff027221ULL, 0x002fc80000010000ULL,
0x0000000502027221ULL, 0x004fca0000010000ULL, 0x0180000002047810ULL, 0x000fc80007ffe0ffULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x000fe200078e0002ULL, 0x0000b43000087802ULL, 0x000fc40000000f00ULL,
0x0000a50000007944ULL, 0x010fea0003c00000ULL, 0x0000000000047202ULL, 0x00cfe20000000f00ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000200057308ULL, 0x000e640000001000ULL,
0xbf80000002007423ULL, 0x002fc80000000005ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000005047223ULL, 0x000fc40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000008000b7811ULL, 0x004fc400078ff0ffULL, 0x00000002ff097819ULL, 0x000fc60000011600ULL,
0x00001f0b04057589ULL, 0x000ea200000e0000ULL, 0x0000000209087810ULL, 0x040fe20007ffe0ffULL,
0x00000008090f7824ULL, 0x040fe200078e00ffULL, 0x00000003090c7810ULL, 0x040fe20007ffe0ffULL,
0x00001f0904027589ULL, 0x00066200000e0000ULL, 0x0000000809107824ULL, 0x040fe200078e00ffULL,
0x00000004090e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000809117824ULL, 0x000fe200078e00ffULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee208ULL, 0x0000000809137824ULL, 0x040fe200078e00ffULL,
0x0000000509087810ULL, 0x040fe20007ffe0ffULL, 0x0000000809157824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee20cULL, 0x0000000809177824ULL, 0x000fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee20eULL, 0x000000100f0f7824ULL, 0x100fe200078e0206ULL,
0x00000006090c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001011117824ULL, 0x100fe200078e0206ULL,
0xffffffff090e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001013137824ULL, 0x000fc400078e0206ULL,
0x0000003505357220ULL, 0x044fe40000410000ULL, 0x0000003405347220ULL, 0x040fe40000410000ULL,
0x0000003105317220ULL, 0x040fe40000410000ULL, 0x0000003005307220ULL, 0x040fe20000410000ULL,
0x000000353434723eULL, 0x000fe200000000ffULL, 0x0000002a052a7220ULL, 0x040fe40000410000ULL,
0x0000002905297220ULL, 0x040fe20000410000ULL, 0x000000313030723eULL, 0x000fe200000000ffULL,
0x0000002605267220ULL, 0x000fc40000410000ULL, 0x0000002505257220ULL, 0x000fe20000410000ULL,
0x0000002a2929723eULL, 0x000fe200000000ffULL, 0x0000002205227220ULL, 0x040fe40000410000ULL,
0x0000002105217220ULL, 0x000fe20000410000ULL, 0x000000262525723eULL, 0x000fe200000000ffULL,
0x0000001e051e7220ULL, 0x040fe40000410000ULL, 0x0000001d051d7220ULL, 0x000fe20000410000ULL,
0x000000222121723eULL, 0x000fe200000000ffULL, 0x0000001a051a7220ULL, 0x000fc40000410000ULL,
0x0000003805077220ULL, 0x002fe20000410000ULL, 0x0000001e1d1d723eULL, 0x000fe200000000ffULL,
0x0000002d052d7220ULL, 0x040fe40000410000ULL, 0x0000001905047220ULL, 0x008fe20000410000ULL,
0x0000000109057810ULL, 0x040fe20007ffe0ffULL, 0x0000000809197824ULL, 0x000fe200078e00ffULL,
0x0000001a0707723eULL, 0x000fe200000000ffULL, 0x0000003702377220ULL, 0x000fe20000410000ULL,
0xfffffff8100d7812ULL, 0x000fe200078ee205ULL, 0x0000003602367220ULL, 0x000fe20000410000ULL,
0xfffffff810057812ULL, 0x000fe200078ee209ULL, 0x000000080b107824ULL, 0x000fe200078e00ffULL,
0xfffffff815097812ULL, 0x000fe200078ee208ULL, 0x0000000400087824ULL, 0x000fe200078e00ffULL,
0xfffffff817157812ULL, 0x000fe200078ee20cULL, 0x0000003302337220ULL, 0x040fe20000410000ULL,
0xfffffff819177812ULL, 0x000fe200078ee20eULL, 0x0000003202327220ULL, 0x000fe20000410000ULL,
0x0000000c08087812ULL, 0x000fe200078ec0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0206ULL,
0x0000000605057211ULL, 0x000fe200078e20ffULL, 0x0000002c022c7220ULL, 0x000fe20000410000ULL,
0xfffffff810197812ULL, 0x000fe200078ee20bULL, 0x0000002b022b7220ULL, 0x000fe20000410000ULL,
0x000000373636723eULL, 0x000fe200000000ffULL, 0x0000001c021c7220ULL, 0x000fe20000410000ULL,
0x000000333232723eULL, 0x000fe200000000ffULL, 0x0000001b021b7220ULL, 0x040fe20000410000ULL,
0x0000002c2b2b723eULL, 0x000fe200000000ffULL, 0x0000002802287220ULL, 0x000fe20000410000ULL,
0x0000002d0404723eULL, 0x000fe200000000ffULL, 0x0000002702277220ULL, 0x040fe20000410000ULL,
0x0000001c1b1b723eULL, 0x000fe200000000ffULL, 0x0000002402247220ULL, 0x000fc40000410000ULL,
0x0000002302237220ULL, 0x040fe20000410000ULL, 0x000000282727723eULL, 0x000fe200000000ffULL,
0x0000002002207220ULL, 0x040fe40000410000ULL, 0x0000001f021f7220ULL, 0x000fe20000410000ULL,
0x000000242323723eULL, 0x000fe200000000ffULL, 0x00000010090b7824ULL, 0x000fe200078e0206ULL,
0x0000000d08097210ULL, 0x000fe20007ffe0ffULL, 0x0000000105057824ULL, 0x000fe200078e0208ULL,
0x000000201f1f723eULL, 0x000fe200000000ffULL, 0x0000002f022f7220ULL, 0x000fc40000410000ULL,
0x0000001015157824ULL, 0x100fe200078e0206ULL, 0x0000003605007388ULL, 0x000fe20000000800ULL,
0x0000001017177824ULL, 0x100fe400078e0206ULL, 0x0000001019197824ULL, 0x000fe200078e0206ULL,
0x0000003209007388ULL, 0x000fe20000000800ULL, 0x0000002e02027220ULL, 0x000fe40000410000ULL,
0x0000000108067824ULL, 0x040fe400078e020fULL, 0x00000001081c7824ULL, 0x000fe200078e0211ULL,
0x0000002f0202723eULL, 0x000fe200000000ffULL, 0x00000001081e7824ULL, 0x040fe200078e0213ULL,
0x0000002b06007388ULL, 0x000fe20000000800ULL, 0x0000000108207824ULL, 0x000fc400078e020bULL,
0x0000000108227824ULL, 0x040fe200078e0215ULL, 0x000000271c007388ULL, 0x000fe20000000800ULL,
0x00000001080b7824ULL, 0x040fe400078e0217ULL, 0x0000000108197824ULL, 0x000fe200078e0219ULL,
0x000000231e007388ULL, 0x000fe20000000800ULL, 0x000000016f087824ULL, 0x000fc600078e0200ULL,
0x0000001f20007388ULL, 0x000fe20000000800ULL, 0x0000001008087824ULL, 0x000fc600078e0203ULL,
0x0000001b22007388ULL, 0x000fe80000000800ULL, 0x000000020b007388ULL, 0x000fe80000000800ULL,
0x0000003419007388ULL, 0x000fe80000000800ULL, 0x0004003009007388ULL, 0x000fe80000000800ULL,
0x0004002906007388ULL, 0x000fe80000000800ULL, 0x000400251c007388ULL, 0x000fe80000000800ULL,
0x000400211e007388ULL, 0x000fe80000000800ULL, 0x0004001d20007388ULL, 0x000fe80000000800ULL,
0x0004000722007388ULL, 0x000fe80000000800ULL, 0x000400040b007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000080c7984ULL, 0x000e680000000c00ULL,
0x0004000008147984ULL, 0x000ea80000000c00ULL, 0x0008000008107984ULL, 0x000ee80000000c00ULL,
0x000c000008187984ULL, 0x000ee20000000c00ULL, 0x200000ff0f0f7230ULL, 0x002fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x004fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x000000130f0f7230ULL, 0x008fe40000000000ULL,
0x000000120e0e7230ULL, 0x000fe40000000000ULL, 0x000000110d0d7230ULL, 0x000fe40000000000ULL,
0x000000100c0c7230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x000fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000c08007388ULL, 0x000fe20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001408007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x000fc80000011600ULL, 0x000000730700720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00005a00ff0e7a12ULL, 0x000fe200078e33ffULL,
0x0000000172027824ULL, 0x000fe200078e0207ULL, 0x00000020000f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000107077824ULL, 0x000fe200078e0200ULL, 0x00000007000c7812ULL, 0x000fc800078ec0ffULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x0000000600067308ULL, 0x002e640000001000ULL,
0x0ffffffe06087810ULL, 0x002fe40007ffe0ffULL, 0x0ffffff807067812ULL, 0x000fc800078ef800ULL,
0x0000000800057305ULL, 0x000e62000021f000ULL, 0x0000001006067824ULL, 0x000fe200078e0203ULL,
0x80000005ff097210ULL, 0x002fca0007ffe0ffULL, 0x00005a0009097a24ULL, 0x000fc800078e02ffULL,
0x00000009050d7227ULL, 0x000fe400078e0004ULL, 0x0000000006087984ULL, 0x000e680000000c00ULL,
0x000000020d047227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a04ULL,
0x00005a0005057a24ULL, 0x000fca00078e0202ULL, 0x00005a0005007a0cULL, 0x000fda0003f06070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104040810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x00005a00ff007a0cULL, 0x000fd60003f05070ULL,
0x0000000104041810ULL, 0x000fc80007ffe0ffULL, 0x000000040e047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000590004057a24ULL, 0x000fe400078e0271ULL,
0x00005a0007027a24ULL, 0x000fe400078e0202ULL, 0x000000086b077824ULL, 0x000fe400078e020cULL,
0x00005a0005057a24ULL, 0x000fca00078e0202ULL, 0x0000000574057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f4402ULL, 0x00000003ff027819ULL, 0x000fc6000001160fULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000730200720cULL, 0x000fc80003f26070ULL,
0x0000000804007986ULL, 0x0023f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000172047824ULL, 0x102fe200078e0202ULL, 0x0000004000117810ULL, 0x000fe20007ffe0ffULL,
0x000000010f027824ULL, 0x000fc400078e0202ULL, 0x000000040d057227ULL, 0x000fc600078e00ffULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x000000ff05077210ULL, 0x000fe40007ffe1ffULL,
0x0ffffff802027812ULL, 0x000fc600078ef80fULL, 0x00005a0007067a24ULL, 0x000fe400078e0204ULL,
0x0000001002027824ULL, 0x000fc600078e0203ULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x0000000002087984ULL, 0x0002a40000000c00ULL, 0x00000003ff027819ULL, 0x002fd20000011611ULL,
0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fda0003f46070ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x000000050e067207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a06ULL,
0x0000590006057a24ULL, 0x000fe200078e0271ULL, 0x000000070f067812ULL, 0x000fe200078ec0ffULL,
0x00005a0007047a24ULL, 0x000fc800078e0204ULL, 0x00005a0005057a24ULL, 0x000fe400078e0204ULL,
0x000000086b077824ULL, 0x000fc600078e0206ULL, 0x0000000574057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f440cULL, 0x000000730200720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000172047824ULL, 0x102fe200078e0202ULL,
0x00000060000f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000111027824ULL, 0x040fe200078e0202ULL,
0x0000000711007812ULL, 0x000fe200078ec0ffULL, 0x000000040d057227ULL, 0x000fc600078e00ffULL,
0x0000000702027812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc600078e0a05ULL,
0x0ffffff802027812ULL, 0x000fe200078ef811ULL, 0x00005a0007067a24ULL, 0x000fc800078e0204ULL,
0x0000001002027824ULL, 0x000fe200078e0203ULL, 0x00005a0006007a0cULL, 0x000fc80003f26070ULL,
0x0000000002087984ULL, 0x0002a40000000c00ULL, 0x00000003ff027819ULL, 0x002fce000001160fULL,
0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe20007ffe0ffULL,
0x0000000172727824ULL, 0x000fe200078e0202ULL, 0x00005a0006007a0cULL, 0x000fda0003f46070ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x000000050e067207ULL, 0x000fc80004000000ULL,
0x000000ff06077210ULL, 0x040fe20007ffe1ffULL, 0x0000590006057a24ULL, 0x000fc800078e0271ULL,
0x00005a0007047a24ULL, 0x000fe400078e0204ULL, 0x000000086b077824ULL, 0x000fe400078e0200ULL,
0x00005a0005057a24ULL, 0x000fca00078e0204ULL, 0x0000000574057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f4406ULL, 0x000000730200720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000720d007227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x002fe400078e0a00ULL, 0x000000010f027824ULL, 0x000fe400078e0202ULL,
0x00005a0005047a24ULL, 0x000fc600078e0272ULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f26070ULL, 0xfffffff802027812ULL, 0x000fd600078ef80fULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000100001810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe20003f46070ULL, 0x0000001002047824ULL, 0x000fcc00078e0203ULL,
0x0000000004047984ULL, 0x000e6c0000000c00ULL, 0x0000000100002810ULL, 0x000fc80007ffe0ffULL,
0x000000000e007207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a00ULL,
0x0000590000037a24ULL, 0x000fe200078e0271ULL, 0x000000070f007812ULL, 0x000fe200078ec0ffULL,
0x00005a0009727a24ULL, 0x000fc800078e0272ULL, 0x00005a0003037a24ULL, 0x000fe400078e0272ULL,
0x000000086b6b7824ULL, 0x000fc600078e0200ULL, 0x0000000374037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005e0003027a11ULL, 0x000fc800078040ffULL,
0x00005f0003037a11ULL, 0x000fca00000f4408ULL, 0x000000106b027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff047819ULL, 0x000fe20000011602ULL, 0xffffffffff0f7424ULL, 0x000fc600078e00ffULL,
0x0000000403047211ULL, 0x000fc800078e08ffULL, 0x0000006d0400720cULL, 0x000fda0003f06070ULL,
0x0000000279098824ULL, 0x000fc800078e00ffULL, 0x00006a0009098a24ULL, 0x000fc800078e0204ULL,
0x0000660009088625ULL, 0x002fe200078e0054ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000006080f8981ULL, 0x000ea2000c1e1900ULL, 0x00000001030b7810ULL, 0x000fe20007ffe0ffULL,
0x0000004002787824ULL, 0x000fe400078e00ffULL, 0x0000008077777824ULL, 0x000fe200078e00ffULL,
0x0000005e0b00720cULL, 0x000fe20003f06070ULL, 0x00005800ff0b7624ULL, 0x000fe200078e00ffULL,
0x01b60000ff067f8cULL, 0x000e62000c80043fULL, 0x0000008071687824ULL, 0x000fe400078e00ffULL,
0x00000100030d7824ULL, 0x000fe200078e0278ULL, 0x0000001f0b0b7810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff117424ULL, 0x000fc600078e00ffULL, 0x00000005ff0b7819ULL, 0x000fe4000001160bULL,
0x00000040680e7812ULL, 0x000fe200078ef80dULL, 0x000000770f087224ULL, 0x004fc800078e02ffULL,
0x0000640008087625ULL, 0x000fe200078e0011ULL, 0x00000c7000008947ULL, 0x000fea0003800000ULL,
0x00000003ff237819ULL, 0x002fe40000011605ULL, 0x0000000d69227217ULL, 0x000fe40007800000ULL,
0x0000000823157810ULL, 0x040fe40007ffe0ffULL, 0x0000000423117810ULL, 0x040fe20007ffe0ffULL,
0x0000000122227824ULL, 0x000fe200078e0a0dULL, 0x0000000c23177810ULL, 0x000fe20007ffe0ffULL,
0x0000000115137824ULL, 0x040fe200078e0205ULL, 0x000000230e107210ULL, 0x040fe20007ffe0ffULL,
0x00000008152c7824ULL, 0x000fe200078e00ffULL, 0x000000221100720cULL, 0x000fe20003fa6070ULL,
0x000000010e127824ULL, 0x000fe200078e0211ULL, 0x00000010231b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000117147824ULL, 0x000fe200078e0205ULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee213ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000001423257810ULL, 0x000fc40007ffe0ffULL,
0x0000001823297810ULL, 0x000fe20007ffe0ffULL, 0x00000008171d7824ULL, 0x000fe200078e00ffULL,
0x0000007012197812ULL, 0x000fe200078ef80cULL, 0x00000001110d7824ULL, 0x000fe200078e0205ULL,
0x0000001c23337810ULL, 0x000fe20007ffe0ffULL, 0x00000008112a7824ULL, 0x000fe200078e00ffULL,
0x0000001908187210ULL, 0x000fe20007f3e0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0xfffffff81d2e7812ULL, 0x000fe400078ee214ULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee20dULL,
0x000000010e147824ULL, 0x000fe200078e0217ULL, 0x00000070100d7812ULL, 0x000fe200078ef80cULL,
0x0000000109197824ULL, 0x000fe200008e0613ULL, 0x000000221500720cULL, 0x080fe20003f26070ULL,
0x000000010e127824ULL, 0x000fe200078e0215ULL, 0x0000000d08107210ULL, 0x000fe20007f1e0ffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x000000221700720cULL, 0x000fc40003f46070ULL,
0x0000001109117210ULL, 0x000fe200007fe4ffULL, 0x000000011b267824ULL, 0x040fe200078e0205ULL,
0x0000007014217812ULL, 0x000fe200078ef80cULL, 0x000000081b1f7824ULL, 0x040fe200078e00ffULL,
0x000000221b00720cULL, 0x000fe20003f06070ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000002108207210ULL, 0x000fe40007f9e0ffULL, 0xfffffff81f267812ULL, 0x000fe200078ee226ULL,
0x000000010e1a7824ULL, 0x000fe200078e0225ULL, 0x00000070121f7812ULL, 0x000fe200078ef80cULL,
0x000000010e167824ULL, 0x000fe200078e021bULL, 0x00000020232b7810ULL, 0x000fe20007ffe0ffULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x0000001f081e7210ULL, 0x000fc40007f7e0ffULL,
0x00000024232d7810ULL, 0x040fe20007ffe0ffULL, 0x000000010e1c7824ULL, 0x000fe200078e0229ULL,
0x00000028232f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109217824ULL, 0x040fe200020e0615ULL,
0x000000701a157812ULL, 0x100fe200078ef80cULL, 0x000001001c1c7825ULL, 0x000fe200078e00ffULL,
0x000000330e1a7210ULL, 0x000fe40007ffe0ffULL, 0x0000001508147210ULL, 0x000fe20007f9e0ffULL,
0x00000001091f7824ULL, 0x000fe200018e0613ULL, 0x000000701c137812ULL, 0x000fe200078ef80cULL,
0x00000001231c7824ULL, 0x000fe200078e0205ULL, 0x0000000529317210ULL, 0x000fe20007ffe0ffULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x0000001308127210ULL, 0x000fc40007fde0ffULL,
0x000000071c1c7812ULL, 0x000fe200078ec0ffULL, 0x0000000109157824ULL, 0x040fe200020e061bULL,
0x00000070160d7812ULL, 0x100fe200078ef80cULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x0ffffff81c247812ULL, 0x000fe400078ef805ULL, 0x0000000d08167210ULL, 0x000fe20007f7e0ffULL,
0x0000000109137824ULL, 0x000fe200030e061dULL, 0x000000701a1d7812ULL, 0x000fe200078ef80cULL,
0x000000010e1c7824ULL, 0x000fe200078e022bULL, 0x00001000020d7811ULL, 0x000fe200078e70ffULL,
0x0000000125277824ULL, 0x040fe200078e0205ULL, 0x0000001d081a7210ULL, 0x000fe20007fde0ffULL,
0x0000000825307824ULL, 0x000fe200078e00ffULL, 0x000000222300720cULL, 0x000fe20003f86070ULL,
0x000001001c1c7825ULL, 0x000fc600078e00ffULL, 0xfffffff830307812ULL, 0x000fe200078ee227ULL,
0x0000000109177824ULL, 0x000fe200018e0617ULL, 0x000000222500720cULL, 0x080fe20003f66070ULL,
0x0000001024277824ULL, 0x000fe200078e020dULL, 0x000000701c257812ULL, 0x000fe200078ef80cULL,
0x000000010e247824ULL, 0x000fe400078e022dULL, 0x00000001091b7824ULL, 0x000fe200030e061bULL,
0x00000025081c7210ULL, 0x000fe20007fde0ffULL, 0x0000010024247825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010277faeULL, 0x0003e2000e101c46ULL,
0x000000222900720cULL, 0x000fc40003f86070ULL, 0x000000010e287824ULL, 0x000fe400078e022fULL,
0x0000000829327824ULL, 0x000fe200078e00ffULL, 0x0000007024297812ULL, 0x000fe200078ef80cULL,
0x00000001091d7824ULL, 0x000fc600030e061dULL, 0x0000002908247210ULL, 0x000fe20007fde0ffULL,
0x000000102a277824ULL, 0x002fe200078e020dULL, 0xfffffff832327812ULL, 0x000fe200078ee231ULL,
0x0000010028107825ULL, 0x000fe200078e00ffULL, 0x0000002c23317810ULL, 0x000fe40007ffe0ffULL,
0x0000000018277faeULL, 0x0003e2000e901c46ULL, 0x000000223300720cULL, 0x040fe20003fa6070ULL,
0x0000000133287824ULL, 0x040fe200078e0205ULL, 0x0000007010297812ULL, 0x000fe200078ef80cULL,
0x0000000833337824ULL, 0x000fc400078e00ffULL, 0x0000000109257824ULL, 0x000fe200030e0625ULL,
0x0000002908107210ULL, 0x000fe20007fde0ffULL, 0x000000102c297824ULL, 0x000fe200078e020dULL,
0xfffffff833347812ULL, 0x000fe200078ee228ULL, 0x000000012b287824ULL, 0x000fe200078e0205ULL,
0x0000001109117210ULL, 0x000fe200037fe4ffULL, 0x000000082b337824ULL, 0x040fe200078e00ffULL,
0x000000001e297faeULL, 0x0005e2000c901c46ULL, 0x000000102e277824ULL, 0x002fe200078e020dULL,
0x000000222b00720cULL, 0x080fe20003f26070ULL, 0x000000010e187824ULL, 0x000fe200078e0231ULL,
0xfffffff833287812ULL, 0x000fe200078ee228ULL, 0x000000012d2a7824ULL, 0x000fe200078e0205ULL,
0x0000003023337810ULL, 0x000fe20007ffe0ffULL, 0x0000000020277faeULL, 0x0003e2000d101c46ULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x000000222d00720cULL, 0x000fc60003f46070ULL,
0x00000010261f7824ULL, 0x104fe200078e020dULL, 0x00000070182b7812ULL, 0x000fe200078ef80cULL,
0x000000082d2d7824ULL, 0x000fe200078e00ffULL, 0x0000000d34297211ULL, 0x000fe400078e20ffULL,
0x00000000161f7faeULL, 0x0005e2000c101c46ULL, 0x0000002b08187210ULL, 0x000fe20007fde0ffULL,
0x0000001030217824ULL, 0x102fe200078e020dULL, 0xfffffff82d2a7812ULL, 0x000fe200078ee22aULL,
0x0000001032277824ULL, 0x000fe400078e020dULL, 0x0000000109197824ULL, 0x000fe200030e0619ULL,
0x0000000014217faeULL, 0x0003e2000d901c46ULL, 0x00000010282b7824ULL, 0x100fe200078e020dULL,
0x000000223300720cULL, 0x000fe20003f66070ULL, 0x000000102a2d7824ULL, 0x000fe200078e020dULL,
0x0000000012277faeULL, 0x0007e2000e101c46ULL, 0x000000010e167824ULL, 0x004fe200078e0233ULL,
0x0000003423177810ULL, 0x000fc40007ffe0ffULL, 0x000000001a297faeULL, 0x0005e2000e901c46ULL,
0x000000222f00720cULL, 0x080fe40003fa6070ULL, 0x00000038231f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010e147824ULL, 0x002fe200078e0217ULL, 0x000000001c2b7faeULL, 0x0003e2000c901c46ULL,
0x000000223100720cULL, 0x080fe20003f86070ULL, 0x0000010016127825ULL, 0x008fe200078e00ffULL,
0x0000003c23237810ULL, 0x000fe20007ffe0ffULL, 0x00000000242d7faeULL, 0x0007e2000d101c46ULL,
0x000000221700720cULL, 0x080fe20003f46070ULL, 0x000000012f167824ULL, 0x040fe200078e0205ULL,
0x0000007012157812ULL, 0x000fe200078ef80cULL, 0x000000082f2f7824ULL, 0x000fe200078e00ffULL,
0x000000221f00720cULL, 0x000fe20003f26070ULL, 0x000000010e217824ULL, 0x000fe200078e021fULL,
0x0000001508127210ULL, 0x000fe20007fde0ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0xfffffff82f1c7812ULL, 0x002fc400078ee216ULL, 0x000000222300720cULL, 0x000fe20003f06070ULL,
0x0000000109137824ULL, 0x000fe200030e0613ULL, 0x00000070141b7812ULL, 0x004fe200078ef80cULL,
0x0000000131167824ULL, 0x100fe200078e0205ULL, 0x0000000533147210ULL, 0x040fe20007ffe0ffULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x0000001b081a7210ULL, 0x000fe20007fde0ffULL,
0x0000000831317824ULL, 0x000fe200078e00ffULL, 0x0000000323267819ULL, 0x000fe200000006ffULL,
0x00000001171d7824ULL, 0x000fe200078e0205ULL, 0xfffffff833207812ULL, 0x000fe200078ee214ULL,
0x00000001091b7824ULL, 0x000fe200030e0615ULL, 0xfffffff8311e7812ULL, 0x000fe200078ee216ULL,
0x0000010021147825ULL, 0x000fc800078e00ffULL, 0x000000010e167824ULL, 0x000fe400078e0223ULL,
0x0000000817227824ULL, 0x000fe400078e00ffULL, 0x000000011f217824ULL, 0x040fe400078e0205ULL,
0x000000081f247824ULL, 0x008fe200078e00ffULL, 0x00000070141f7812ULL, 0x100fe200078ef80cULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0xfffffff8220e7812ULL, 0x000fe400078ee21dULL,
0x0000001f08147210ULL, 0x000fe20007fde0ffULL, 0x0000000123057824ULL, 0x000fe200078e0205ULL,
0xfffffff824227812ULL, 0x000fe200078ee221ULL, 0x000000101e1d7824ULL, 0x000fe200078e020dULL,
0x0000007016217812ULL, 0x000fe200078ef80cULL, 0x0000000109157824ULL, 0x000fe200030e0615ULL,
0xfffffff826247812ULL, 0x000fe200078ee205ULL, 0x000000101c057824ULL, 0x100fe200078e020dULL,
0x0000002108087210ULL, 0x000fe20007fde0ffULL, 0x00000010201f7824ULL, 0x000fc400078e020dULL,
0x000000100e217824ULL, 0x100fe200078e020dULL, 0x0000000010057faeULL, 0x0003e2000e901c46ULL,
0x0000001022237824ULL, 0x100fe400078e020dULL, 0x00000010240d7824ULL, 0x000fe200078e020dULL,
0x00000000181d7faeULL, 0x0003e2000e101c46ULL, 0x0000000109097824ULL, 0x000fc600030e0617ULL,
0x00000000121f7faeULL, 0x0003e8000d901c46ULL, 0x000000001a217faeULL, 0x0003e8000d101c46ULL,
0x0000000014237faeULL, 0x0003e8000c901c46ULL, 0x00000000080d7faeULL, 0x0003e2000c101c46ULL,
0x00000b3000007947ULL, 0x000fea0003800000ULL, 0x0000000805157811ULL, 0x042fe400078fe8ffULL,
0x0000000405147811ULL, 0x000fc400078fe8ffULL, 0x0000000c05167811ULL, 0x000fe200078fe8ffULL,
0x0000000115107824ULL, 0x100fe200078e0205ULL, 0x0000001c05207811ULL, 0x000fe200078fe8ffULL,
0x0000000815137824ULL, 0x000fe200078e00ffULL, 0x00000014051a7811ULL, 0x040fe200078fe8ffULL,
0x00000001140d7824ULL, 0x140fe200078e0205ULL, 0x0000000314367819ULL, 0x000fe200000006ffULL,
0x0000000116117824ULL, 0x140fe200078e0205ULL, 0x0000001005187811ULL, 0x000fe200078fe8ffULL,
0x00000008163c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8133a7812ULL, 0x000fe200078ee210ULL,
0x0000000120127824ULL, 0x140fe200078e0205ULL, 0x00000018051c7811ULL, 0x040fe200078fe8ffULL,
0x0000000820177824ULL, 0x000fe200078e00ffULL, 0x00000028051e7811ULL, 0x040fe200078fe8ffULL,
0x000000011a107824ULL, 0x000fe200078e0205ULL, 0xfffffff836367812ULL, 0x000fe200078ee20dULL,
0x000000081a137824ULL, 0x000fe200078e00ffULL, 0x0000002c05387811ULL, 0x000fe200078fe8ffULL,
0x00000001180d7824ULL, 0x000fe200078e0205ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee211ULL,
0x00000008183e7824ULL, 0x000fe200078e00ffULL, 0xfffffff817447812ULL, 0x000fe200078ee212ULL,
0x000000011c117824ULL, 0x140fe200078e0205ULL, 0x000000031c427819ULL, 0x000fe200000006ffULL,
0x000000011e127824ULL, 0x140fe200078e0205ULL, 0xfffffff813407812ULL, 0x000fe200078ee210ULL,
0x000000081e377824ULL, 0x000fe200078e00ffULL, 0x00000024051f7811ULL, 0x040fe200078fe8ffULL,
0x0000000138137824ULL, 0x000fe200078e0205ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL,
0x0000000116167824ULL, 0x100fe200078e020eULL, 0x00000020050d7811ULL, 0x000fe200078fe8ffULL,
0x000000081f227824ULL, 0x040fe200078e00ffULL, 0x0000000338247819ULL, 0x000fe200000006ffULL,
0x0000000118187824ULL, 0x000fe200078e020eULL, 0xfffffff842427812ULL, 0x000fe200078ee211ULL,
0x000000011f117824ULL, 0x100fe200078e0205ULL, 0xfffffff837377812ULL, 0x000fe200078ee212ULL,
0x000000010d107824ULL, 0x000fe200078e0205ULL, 0x0000000505127211ULL, 0x000fe200078fe8ffULL,
0x000000080d337824ULL, 0x000fe200078e00ffULL, 0xfffffff824177812ULL, 0x000fe200078ee213ULL,
0x000000011a1a7824ULL, 0x100fe200078e020eULL, 0x0000003405137811ULL, 0x040fe200078fe8ffULL,
0x000000011c1c7824ULL, 0x100fe200078e020eULL, 0x0000003805197811ULL, 0x000fe200078fe8ffULL,
0x0000000120207824ULL, 0x100fe200078e020eULL, 0x0000000712247812ULL, 0x000fe200078ec0ffULL,
0x0000000114127824ULL, 0x100fe200078e020eULL, 0xfffffff822357812ULL, 0x000fe200078ee211ULL,
0x0000000115147824ULL, 0x000fe200078e020eULL, 0x0000003005117811ULL, 0x000fe200078fe8ffULL,
0x000000010e2e7824ULL, 0x040fe200078e0213ULL, 0xfffffff833337812ULL, 0x000fe200078ee210ULL,
0x0000000113157824ULL, 0x100fe200078e0205ULL, 0x0000003c051b7811ULL, 0x000fe200078fe8ffULL,
0x00000008132c7824ULL, 0x000fe200078e00ffULL, 0x0000000e05107211ULL, 0x000fe200078fe8ffULL,
0x0000000119137824ULL, 0x040fe200078e0205ULL, 0x0000000319307819ULL, 0x000fe200000006ffULL,
0x000000010e227824ULL, 0x000fe200078e020dULL, 0x0ffffff824247812ULL, 0x100fe200078ef805ULL,
0x00000001110d7824ULL, 0x040fe200078e0205ULL, 0xfffffff830307812ULL, 0x000fe200078ee213ULL,
0x000000010e347824ULL, 0x040fe200078e0211ULL, 0x0000001e0e1e7210ULL, 0x000fe20007ffe0ffULL,
0x0000000811287824ULL, 0x000fe200078e00ffULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee215ULL,
0x000000010e2a7824ULL, 0x000fe200078e0219ULL, 0x0000100002197811ULL, 0x000fe200078e70ffULL,
0x000000011b057824ULL, 0x040fe200078e0205ULL, 0xfffffff828287812ULL, 0x000fe200078ee20dULL,
0x000000081b327824ULL, 0x000fe200078e00ffULL, 0x00000019420d7211ULL, 0x000fe200078e20ffULL,
0x0000010010107825ULL, 0x000fc600078e00ffULL, 0xfffffff832327812ULL, 0x000fe200078ee205ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000007010057812ULL, 0x000fc600078ef80cULL,
0x000000010e1f7824ULL, 0x000fe200078e021fULL, 0x0000000508107210ULL, 0x000fe20007f1e0ffULL,
0x000000010e387824ULL, 0x040fe400078e0238ULL, 0x000000010e267824ULL, 0x000fe200078e021bULL,
0x0000001109117210ULL, 0x000fe200007fe4ffULL, 0x0000010014147825ULL, 0x000fc800078e00ffULL,
0x00000010170e7824ULL, 0x000fe200078e0219ULL, 0x0000007012177812ULL, 0x100fe200078ef80cULL,
0x000001001c1c7825ULL, 0x000fe200078e00ffULL, 0x00000070141b7812ULL, 0x000fe400078ef80cULL,
0x0000001708127210ULL, 0x000fe20007f3e0ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x0000001b08147210ULL, 0x000fc60007f1e0ffULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x0000007016217812ULL, 0x000fc600078ef80cULL, 0x0000000109157824ULL, 0x000fe200000e0615ULL,
0x0000002108167210ULL, 0x000fe20007f1e0ffULL, 0x0000001024317824ULL, 0x100fe200078e0219ULL,
0x000000701c217812ULL, 0x100fe200078ef80cULL, 0x00000010362f7824ULL, 0x100fe200078e0219ULL,
0x000000701a237812ULL, 0x000fe200078ef80cULL, 0x000000103a2d7824ULL, 0x100fe200078e0219ULL,
0x00000021081c7210ULL, 0x000fe20007f5e0ffULL, 0x000000103c2b7824ULL, 0x100fe200078e0219ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010317faeULL, 0x0003e2000b901c46ULL,
0x000000103e297824ULL, 0x000fc400078e0219ULL, 0x0000001040277824ULL, 0x100fe400078e0219ULL,
0x0000001044057824ULL, 0x100fe400078e0219ULL, 0x0000001033337824ULL, 0x100fe400078e0219ULL,
0x0000001035357824ULL, 0x100fe400078e0219ULL, 0x0000001037377824ULL, 0x100fe400078e0219ULL,
0x0000001028287824ULL, 0x000fc400078e0219ULL, 0x000000102c2c7824ULL, 0x100fe400078e0219ULL,
0x0000001030307824ULL, 0x100fe400078e0219ULL, 0x0000001032327824ULL, 0x000fe400078e0219ULL,
0x0000010018187825ULL, 0x000fc800078e00ffULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x0000007018257812ULL, 0x000fc600078ef80cULL, 0x0000000109177824ULL, 0x040fe200000e0617ULL,
0x00000023081a7210ULL, 0x040fe20007f1e0ffULL, 0x0000000109137824ULL, 0x000fe200008e0613ULL,
0x0000002508187210ULL, 0x000fe20007f3e0ffULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x00000070203d7812ULL, 0x100fe400078ef80cULL, 0x00000000122f7faeULL, 0x0003e2000b901c46ULL,
0x000001001f247825ULL, 0x000fe200078e00ffULL, 0x00000070221f7812ULL, 0x100fe400078ef80cULL,
0x00000000142d7faeULL, 0x0003e2000b901c46ULL, 0x00000001091b7824ULL, 0x040fe200000e061bULL,
0x00000070243f7812ULL, 0x100fe200078ef80cULL, 0x000001001e3a7825ULL, 0x000fe200078e00ffULL,
0x0000003d081e7210ULL, 0x000fe20007f1e0ffULL, 0x00000000162b7faeULL, 0x0003e4000b901c46ULL,
0x0000000109197824ULL, 0x000fe200008e0619ULL, 0x000000703a3d7812ULL, 0x000fe200078ef80cULL,
0x0000010038387825ULL, 0x000fe200078e00ffULL, 0x0000001f08207210ULL, 0x000fc40007f3e0ffULL,
0x0000000018297faeULL, 0x0003e2000b901c46ULL, 0x00000001091f7824ULL, 0x040fe200000e0621ULL,
0x0000003f08227210ULL, 0x040fe20007f1e0ffULL, 0x00000001091d7824ULL, 0x040fe200010e061dULL,
0x0000003d08247210ULL, 0x000fe20007f5e0ffULL, 0x0000000109217824ULL, 0x040fe200008e0623ULL,
0x00000070383d7812ULL, 0x100fe200078ef80cULL, 0x0000000109237824ULL, 0x040fe200000e0625ULL,
0x0000003b09257210ULL, 0x040fe200017fe4ffULL, 0x00000100343a7825ULL, 0x000fe200078e00ffULL,
0x0000003d08387210ULL, 0x000fe20007f1e0ffULL, 0x000000001a277faeULL, 0x0003e4000b901c46ULL,
0x000001002e3c7825ULL, 0x000fe200078e00ffULL, 0x000000703a497812ULL, 0x100fe200078ef80cULL,
0x000000001c0d7faeULL, 0x0003e4000b901c46ULL, 0x000001002a3e7825ULL, 0x000fe200078e00ffULL,
0x000000703c477812ULL, 0x100fe200078ef80cULL, 0x000000001e057faeULL, 0x0003e4000b901c46ULL,
0x0000010026407825ULL, 0x000fe200078e00ffULL, 0x000000703e457812ULL, 0x100fe200078ef80cULL,
0x0000000020337faeULL, 0x0003e2000b901c46ULL, 0x00000047083c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000109397824ULL, 0x040fe200000e0639ULL, 0x0000007040437812ULL, 0x000fe200078ef80cULL,
0x0000000022357faeULL, 0x0003e2000b901c46ULL, 0x00000049083a7210ULL, 0x040fe20007f1e0ffULL,
0x00000001093d7824ULL, 0x040fe200008e063dULL, 0x00000045083e7210ULL, 0x040fe20007f5e0ffULL,
0x0000000024377faeULL, 0x0003e2000b901c46ULL, 0x0000004308087210ULL, 0x000fe20007f7e0ffULL,
0x00000001093b7824ULL, 0x000fc400000e063bULL, 0x00000001093f7824ULL, 0x040fe200010e063fULL,
0x00000000380e7faeULL, 0x0003e2000b901c46ULL, 0x0000000109097824ULL, 0x000fc600018e0641ULL,
0x000000003a287faeULL, 0x0003e8000b901c46ULL, 0x000000003c2c7faeULL, 0x0003e8000b901c46ULL,
0x000000003e307faeULL, 0x0003e8000b901c46ULL, 0x0000000008327faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000087805ULL, 0x002fc40000015200ULL,
0x01b60400ff057984ULL, 0x000e620000000800ULL, 0x0000000b0a557224ULL, 0x000fc400078e02ffULL,
0x0000000169717824ULL, 0x000fe400078e0a00ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x8000000005ff7812ULL, 0x002fe20007804807ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000620055547625ULL, 0x000fe200078e0054ULL,
0x00000008ff717819ULL, 0x000fe20000011671ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c080a7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0c7824ULL, 0x000fe200000e0e09ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140cULL,
0x0000000a05057211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e060cULL,
0x0000000205057819ULL, 0x000fc8000000120aULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000005e0300720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x00006a0079797a24ULL, 0x000fe200078e02ffULL,
0x000000010b6a7819ULL, 0x000fe200000006ffULL, 0x0000002002747824ULL, 0x040fe200078e00ffULL,
0x0001b68802737811ULL, 0x000fe400078e18ffULL, 0xffffffff00067810ULL, 0x040fe40007ffe0ffULL,
0x0000000900077810ULL, 0x000fc40007ffe0ffULL, 0x0000000103097810ULL, 0x040fe20007ffe0ffULL,
0x0000010003087824ULL, 0x000fe200078e0278ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x00000100ff6b7424ULL, 0x000fe200078e00ffULL, 0x0000005e0900720cULL, 0x000fe20003f06070ULL,
0x0000000f770c7224ULL, 0x000fe200078e02ffULL, 0x0000004008097812ULL, 0x000fc600078ec0ffULL,
0x000064000c0c7625ULL, 0x000fc800078e006bULL, 0x0000000168107824ULL, 0x000fc800078e0209ULL,
0x00000bb000008947ULL, 0x00cfea0003800000ULL, 0x00000003ff117819ULL, 0x102fe20000011605ULL,
0x0000001005097824ULL, 0x000fe200078e00ffULL, 0x0000000869137217ULL, 0x000fe40007800000ULL,
0x0000000811177810ULL, 0x040fe20007ffe0ffULL, 0x0000000111217824ULL, 0x140fe200078e0205ULL,
0x0000000411157810ULL, 0x000fe20007ffe0ffULL, 0x0000000113207824ULL, 0x000fe200078e0a08ULL,
0x0000007009097812ULL, 0x000fe200078ec0ffULL, 0x00000001170b7824ULL, 0x100fe200078e0205ULL,
0x0000000c11197810ULL, 0x000fe20007ffe0ffULL, 0x0000000817267824ULL, 0x000fe200078e00ffULL,
0x00000080090e7812ULL, 0x000fe200078efcffULL, 0x00000001150a7824ULL, 0x000fe200078e0205ULL,
0x00000010111b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008150f7824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee20bULL, 0x0000000119147824ULL, 0x100fe200078e0205ULL,
0x00000010110b7210ULL, 0x000fe20007ffe0ffULL, 0x00000008191d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f227812ULL, 0x000fe200078ee20aULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x000000201500720cULL, 0x080fe20003f86070ULL, 0x000000011b167824ULL, 0x000fe200078e0205ULL,
0x0000001411237810ULL, 0x000fe20007ffe0ffULL, 0x000001000b0a7825ULL, 0x000fe200078e000eULL,
0x000000201700720cULL, 0x000fc40003f46070ULL, 0x000000201900720cULL, 0x000fe20003f66070ULL,
0x000000081b1f7824ULL, 0x000fe200078e00ffULL, 0x0000000a0c127210ULL, 0x000fe20007f1e0ffULL,
0x00000008232c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d287812ULL, 0x000fe400078ee214ULL,
0xfffffff81f2a7812ULL, 0x000fe200078ee216ULL, 0x000000010d137824ULL, 0x000fe200000e060bULL,
0x000000201b00720cULL, 0x000fe20003f06070ULL, 0x00000001150b7824ULL, 0x100fe200078e0210ULL,
0x0000001811297810ULL, 0x000fe20007ffe0ffULL, 0x0000000117157824ULL, 0x000fe200078e0210ULL,
0x0000001019177210ULL, 0x000fe20007ffe0ffULL, 0x000001000b0a7825ULL, 0x000fe200078e000eULL,
0x0000001c112d7810ULL, 0x000fc40007ffe0ffULL, 0x00000020112f7810ULL, 0x000fe20007ffe0ffULL,
0x000000011b197824ULL, 0x000fe200078e0210ULL, 0x0000000a0c247210ULL, 0x000fe20007f3e0ffULL,
0x0000010015147825ULL, 0x000fe200078e000eULL, 0x0000003c11317810ULL, 0x000fc60007ffe0ffULL,
0x00000001231b7824ULL, 0x000fe200078e0210ULL, 0x000000140c1a7210ULL, 0x000fe20007fbe0ffULL,
0x000000010d257824ULL, 0x000fe400008e060bULL, 0x00000100190a7825ULL, 0x000fc800078e000eULL,
0x000001001b187825ULL, 0x000fc800078e000eULL, 0x0000010017167825ULL, 0x000fe200078e000eULL,
0x000000180c147210ULL, 0x000fc60007fde0ffULL, 0x000000010d1b7824ULL, 0x000fe200028e0615ULL,
0x000000160c1c7210ULL, 0x040fe20007f3e0ffULL, 0x00000001291f7824ULL, 0x000fe200078e0210ULL,
0x0000000a0c167210ULL, 0x000fe20007fbe0ffULL, 0x000000010d157824ULL, 0x000fe200030e0619ULL,
0x0ffffff8050a7812ULL, 0x000fe200078ec0ffULL, 0x000000010d1d7824ULL, 0x000fe200008e0617ULL,
0x000000202300720cULL, 0x080fe20003f26070ULL, 0x000001001f187825ULL, 0x000fe200078e000eULL,
0x00000005231f7210ULL, 0x000fe40007ffe0ffULL, 0x000000070a1e7812ULL, 0x000fe200078ef821ULL,
0x000000010d177824ULL, 0x000fe200028e060bULL, 0x000000201100720cULL, 0x000fe20003fa6070ULL,
0x000000012f237824ULL, 0x100fe200078e0210ULL, 0x00003000020b7811ULL, 0x000fe200078e70ffULL,
0x00000001292b7824ULL, 0x000fe200078e0205ULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee21fULL,
0x000000012d1f7824ULL, 0x000fe200078e0210ULL, 0x000000180c187210ULL, 0x000fe20007fde0ffULL,
0x000000101e217824ULL, 0x000fc400078e020bULL, 0x000001001f1e7825ULL, 0x000fc800078e000eULL,
0x0000001022277824ULL, 0x000fe200078e020bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012217faeULL, 0x0003e2000e901c46ULL, 0x000000010d197824ULL, 0x000fe200030e0619ULL,
0x0000001e0c1e7210ULL, 0x040fe20007fde0ffULL, 0x0000010023227825ULL, 0x000fe200078e000eULL,
0x0000000024277faeULL, 0x0005e2000e101c46ULL, 0x000000202900720cULL, 0x080fe40003fa6070ULL,
0x000000010d1f7824ULL, 0x000fe200030e061fULL, 0x000000202d00720cULL, 0x000fe20003f86070ULL,
0x00000008292e7824ULL, 0x000fe200078e00ffULL, 0x000000052d297210ULL, 0x0c0fe20007ffe0ffULL,
0x000000082d307824ULL, 0x000fe200078e00ffULL, 0x000000220c127210ULL, 0x002fe20007fde0ffULL,
0x0000001026217824ULL, 0x000fe200078e020bULL, 0x00000030112d7810ULL, 0x000fe20007ffe0ffULL,
0x000000012f267824ULL, 0x000fe200078e0205ULL, 0x0000002411277810ULL, 0x004fe20007ffe0ffULL,
0x0000001028257824ULL, 0x000fe200078e020bULL, 0x000000001a217faeULL, 0x0003e2000d101c46ULL,
0x000000010d137824ULL, 0x000fe200030e0623ULL, 0xfffffff82e247812ULL, 0x000fe200078ee22bULL,
0x0000000127237824ULL, 0x000fe200078e0210ULL, 0x000000001c257faeULL, 0x0005e2000d901c46ULL,
0x000000202f00720cULL, 0x0c0fe20003f66070ULL, 0x000000082f2f7824ULL, 0x000fe200078e00ffULL,
0x000000202700720cULL, 0x000fe20003f46070ULL, 0x0000010023227825ULL, 0x000fe200078e000eULL,
0x0000000527287210ULL, 0x000fc40007ffe0ffULL, 0xfffffff8302e7812ULL, 0x000fe200078ee229ULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0xfffffff82f267812ULL, 0x000fe200078ee226ULL,
0x000000102a1b7824ULL, 0x102fe200078e020bULL, 0x0000002811297810ULL, 0x000fe20007ffe0ffULL,
0x000000102c1d7824ULL, 0x104fe200078e020bULL, 0xfffffff827287812ULL, 0x000fe200078ee228ULL,
0x0000001024217824ULL, 0x100fe200078e020bULL, 0x00000000161b7faeULL, 0x0003e2000c101c46ULL,
0x000000102e257824ULL, 0x100fe200078e020bULL, 0x000000220c227210ULL, 0x000fe20007fde0ffULL,
0x0000001026277824ULL, 0x000fe200078e020bULL, 0x00000000141d7faeULL, 0x0005e2000c901c46ULL,
0x0000002c112b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000831247824ULL, 0x000fe200078e00ffULL,
0x00000038112f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000018217faeULL, 0x0007e2000e901c46ULL,
0x000000010d237824ULL, 0x000fe200030e0623ULL, 0x000000202b00720cULL, 0x000fc40003fa6070ULL,
0x000000001e257faeULL, 0x0009e2000e101c46ULL, 0x00000034111b7810ULL, 0x002fe20007ffe0ffULL,
0x0000001028117824ULL, 0x000fe200078e020bULL, 0x000000202d00720cULL, 0x080fe20003f86070ULL,
0x0000000012277faeULL, 0x0003e2000d901c46ULL, 0x000000012b157824ULL, 0x104fe200078e0210ULL,
0x000000202900720cULL, 0x080fe20003fc6070ULL, 0x000000012d177824ULL, 0x040fe200078e0210ULL,
0x0000000022117faeULL, 0x0005e2000d101c46ULL, 0x000000012d187824ULL, 0x108fe200078e0205ULL,
0x000000201b00720cULL, 0x080fe20003f66070ULL, 0x000000012b167824ULL, 0x100fe200078e0205ULL,
0x000000202f00720cULL, 0x080fe20003f26070ULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0x000000203100720cULL, 0x000fe20003f06070ULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0x0000000329137819ULL, 0x042fe200000006ffULL, 0x0000000129127824ULL, 0x000fe200078e0205ULL,
0xfffffff82d1e7812ULL, 0x010fe200078ee218ULL, 0x0000010015147825ULL, 0x000fe200078e000eULL,
0xfffffff82b1c7812ULL, 0x000fc400078ee216ULL, 0xfffffff8131a7812ULL, 0x000fe200078ee212ULL,
0x0000000129137824ULL, 0x000fe200078e0210ULL, 0x000000032f227819ULL, 0x004fe200000006ffULL,
0x0000010017167825ULL, 0x000fc800078e000eULL, 0x0000010013127825ULL, 0x000fc800078e000eULL,
0x000000081b1d7824ULL, 0x040fe200078e00ffULL, 0x000000120c127210ULL, 0x040fe20007f5e0ffULL,
0x000000011b117824ULL, 0x100fe400078e0210ULL, 0x000000012f1f7824ULL, 0x100fe200078e0205ULL,
0x000000130d137210ULL, 0x000fe400017fe4ffULL, 0x000000140c187210ULL, 0x000fe20007f5e0ffULL,
0x000000011b147824ULL, 0x000fe200078e0205ULL, 0xfffffff822227812ULL, 0x000fe200078ee21fULL,
0x000000012f1b7824ULL, 0x000fc400078e0210ULL, 0x000000010d197824ULL, 0x000fe200010e0615ULL,
0x000000160c167210ULL, 0x000fe20007f5e0ffULL, 0x000000101e1f7824ULL, 0x000fe200078e020bULL,
0xfffffff81d207812ULL, 0x000fe200078ee214ULL, 0x0000010011147825ULL, 0x000fe200078e000eULL,
0x0000000b22237211ULL, 0x000fc600078e20ffULL, 0x000000010d177824ULL, 0x000fe200010e0617ULL,
0x000000140c147210ULL, 0x000fe20007f5e0ffULL, 0x00000001311d7824ULL, 0x000fe400078e0210ULL,
0x000001001b107825ULL, 0x000fc800078e000eULL, 0x000000010d157824ULL, 0x000fe200010e0615ULL,
0x000000100c107210ULL, 0x000fe20007f5e0ffULL, 0x00000001311b7824ULL, 0x000fe400078e0205ULL,
0x000001001d0e7825ULL, 0x000fc600078e000eULL, 0xfffffff824247812ULL, 0x000fe200078ee21bULL,
0x000000010d117824ULL, 0x040fe200010e0611ULL, 0x0000000e0c0c7210ULL, 0x000fe20007f5e0ffULL,
0x000000101a1b7824ULL, 0x100fe400078e020bULL, 0x000000101c1d7824ULL, 0x100fe400078e020bULL,
0x0000001020217824ULL, 0x100fe200078e020bULL, 0x00000000121b7faeULL, 0x0003e2000f101c46ULL,
0x00000010240b7824ULL, 0x000fe400078e020bULL, 0x000000010d0d7824ULL, 0x000fe200010e060fULL,
0x00000000181d7faeULL, 0x0003e8000e901c46ULL, 0x00000000161f7faeULL, 0x0003e8000e101c46ULL,
0x0000000014217faeULL, 0x0003e8000d901c46ULL, 0x0000000010237faeULL, 0x0003e8000c901c46ULL,
0x000000000c0b7faeULL, 0x0003e2000c101c46ULL, 0x00000a7000007947ULL, 0x000fea0003800000ULL,
0x0000000405237811ULL, 0x042fe400078fe8ffULL, 0x0000000c05297811ULL, 0x000fc400078fe8ffULL,
0x0000001805257811ULL, 0x000fe200078fe8ffULL, 0x0000000123097824ULL, 0x100fe200078e0205ULL,
0x0000000805277811ULL, 0x000fe200078fe8ffULL, 0x00000008230e7824ULL, 0x000fe200078e00ffULL,
0x0000002405197811ULL, 0x000fe200078fe8ffULL, 0x0000000123237824ULL, 0x000fe200078e0210ULL,
0x00000010052b7811ULL, 0x000fe200078fe8ffULL, 0x00000001270a7824ULL, 0x000fe200078e0205ULL,
0xfffffff80e2f7812ULL, 0x000fe200078ee209ULL, 0x0000000129097824ULL, 0x000fe200078e0205ULL,
0x0000003005137811ULL, 0x000fe200078fe8ffULL, 0x00000008290e7824ULL, 0x000fe200078e00ffULL,
0x0000001c05217811ULL, 0x000fe200078fe8ffULL, 0x0000000827317824ULL, 0x000fe200078e00ffULL,
0x00000014052d7811ULL, 0x000fe200078fe8ffULL, 0x000000082b357824ULL, 0x000fe200078e00ffULL,
0xfffffff80e337812ULL, 0x000fe200078ee209ULL, 0x0000000125097824ULL, 0x100fe200078e0205ULL,
0xfffffff831317812ULL, 0x000fe200078ee20aULL, 0x00000008250e7824ULL, 0x000fe200078e00ffULL,
0x000000052b0a7210ULL, 0x080fe20007ffe0ffULL, 0x00000008213b7824ULL, 0x000fe200078e00ffULL,
0x0000003c05417811ULL, 0x000fe200078fe8ffULL, 0x000000012d0b7824ULL, 0x000fe200078e0205ULL,
0xfffffff80e397812ULL, 0x000fe200078ee209ULL, 0x0000000119097824ULL, 0x100fe200078e0205ULL,
0xfffffff835357812ULL, 0x000fe200078ee20aULL, 0x00000008190e7824ULL, 0x000fe200078e00ffULL,
0x00000028050f7811ULL, 0x000fe200078fe8ffULL, 0x00000001210a7824ULL, 0x000fe200078e0205ULL,
0x00000020051d7811ULL, 0x000fe200078fe8ffULL, 0x000000082d127824ULL, 0x000fe200078e00ffULL,
0xfffffff80e3f7812ULL, 0x000fe200078ee209ULL, 0x0000000113097824ULL, 0x000fe200078e0205ULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee20aULL, 0x00000008130e7824ULL, 0x000fe200078e00ffULL,
0xfffffff812377812ULL, 0x000fe200078ee20bULL, 0x00000008414b7824ULL, 0x000fe200078e00ffULL,
0x000000031d127819ULL, 0x000fe200000006ffULL, 0x000000010f0a7824ULL, 0x000fe200078e0205ULL,
0xfffffff80e457812ULL, 0x000fe200078ee209ULL, 0x00000001410e7824ULL, 0x100fe200078e0205ULL,
0x0000002c05117811ULL, 0x000fe200078fe8ffULL, 0x000000080f1b7824ULL, 0x000fe200078e00ffULL,
0x0000003405157811ULL, 0x000fe200078fe8ffULL, 0x000000011d0b7824ULL, 0x000fe200078e0205ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee20eULL, 0x0000001005097824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee20aULL, 0x0000000815477824ULL, 0x000fe200078e00ffULL,
0x00003000020e7811ULL, 0x000fe200078e70ffULL, 0x0000000127277824ULL, 0x000fe200078e0210ULL,
0xfffffff8123d7812ULL, 0x000fe200078ee20bULL, 0x00000001110b7824ULL, 0x000fe200078e0205ULL,
0x0000007009097812ULL, 0x000fe200078ec0ffULL, 0x0000000811127824ULL, 0x000fe200078e00ffULL,
0x0000003805177811ULL, 0x000fe200078fe8ffULL, 0x000000101b2e7824ULL, 0x000fe200078e020eULL,
0x00000010051f7211ULL, 0x080fe200078fe8ffULL, 0x000000ffff1b7224ULL, 0x000fe200078e00ffULL,
0x00000080091a7812ULL, 0x000fe200078efcffULL, 0x000000012b2b7824ULL, 0x000fe200078e0210ULL,
0xfffffff812437812ULL, 0x000fe200078ee20bULL, 0x00000001170b7824ULL, 0x000fe200078e0205ULL,
0x00000005150a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000817127824ULL, 0x000fe200078e00ffULL,
0x0000001029297210ULL, 0x000fe20007ffe0ffULL, 0x000001001f1e7825ULL, 0x000fe200078e001aULL,
0xfffffff847477812ULL, 0x000fc400078ee20aULL, 0xfffffff812497812ULL, 0x000fe200078ee20bULL,
0x0000010023227825ULL, 0x000fe200078e001aULL, 0x00000005050b7211ULL, 0x040fe400078fe8ffULL,
0x0ffffff8050a7812ULL, 0x000fe200078ec0ffULL, 0x000000012d2d7824ULL, 0x000fe200078e0210ULL,
0x0000001e0c1e7210ULL, 0x040fe20007f1e0ffULL, 0x0000010027267825ULL, 0x000fe200078e001aULL,
0x000000220c227210ULL, 0x000fe40007f3e0ffULL, 0x000000070a0b7812ULL, 0x000fe200078ef80bULL,
0x0000010029287825ULL, 0x000fe200078e001aULL, 0x000000260c267210ULL, 0x000fc40007f5e0ffULL,
0x0000001013137210ULL, 0x000fe20007ffe0ffULL, 0x0000000125257824ULL, 0x100fe200078e0210ULL,
0x000000280c287210ULL, 0x000fe20007f7e0ffULL, 0x0000000121217824ULL, 0x000fe200078e0210ULL,
0x0000000e37377211ULL, 0x080fe200078e20ffULL, 0x000001002b2a7825ULL, 0x000fe200078e001aULL,
0x0000000e49367211ULL, 0x000fc600078e20ffULL, 0x000001002d2c7825ULL, 0x000fc800078e001aULL,
0x000000011d1d7824ULL, 0x100fe400078e0210ULL, 0x0000000119197824ULL, 0x000fe400078e0210ULL,
0x0000010025247825ULL, 0x000fc800078e001aULL, 0x000000010f0f7824ULL, 0x000fe400078e0210ULL,
0x0000010021207825ULL, 0x000fc800078e001aULL, 0x000000010d1f7824ULL, 0x040fe200000e061fULL,
0x0000002a0c2a7210ULL, 0x040fe20007f1e0ffULL, 0x000000010d237824ULL, 0x000fe200008e0623ULL,
0x0000002c0c2c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000111117824ULL, 0x000fe400078e0210ULL,
0x0000001043307824ULL, 0x000fe400078e020eULL, 0x000001001d1c7825ULL, 0x000fc800078e001aULL,
0x000000100b0b7824ULL, 0x100fe400078e020eULL, 0x000000102f2f7824ULL, 0x100fe400078e020eULL,
0x0000001031317824ULL, 0x100fe200078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e0b7faeULL, 0x0003e2000b901c46ULL, 0x0000001033337824ULL, 0x100fe400078e020eULL,
0x0000001035357824ULL, 0x100fe200078e020eULL, 0x00000000222f7faeULL, 0x0003e2000b901c46ULL,
0x0000001039397824ULL, 0x000fc400078e020eULL, 0x000000103b3b7824ULL, 0x100fe400078e020eULL,
0x000000103d3d7824ULL, 0x100fe400078e020eULL, 0x000000103f3f7824ULL, 0x100fe400078e020eULL,
0x0000001045327824ULL, 0x100fe400078e020eULL, 0x0000001047347824ULL, 0x100fe400078e020eULL,
0x000000104b437824ULL, 0x000fc400078e020eULL, 0x0000010019187825ULL, 0x000fc800078e001aULL,
0x000000010d277824ULL, 0x000fe200010e0627ULL, 0x000000240c247210ULL, 0x000fe20007f5e0ffULL,
0x000001000f0e7825ULL, 0x000fc600078e001aULL, 0x000000250d257210ULL, 0x040fe200017fe4ffULL,
0x000000010d297824ULL, 0x000fe200018e0629ULL, 0x000000200c207210ULL, 0x040fe20007f7e0ffULL,
0x0000000115157824ULL, 0x100fe200078e0210ULL, 0x0000000e0c0e7210ULL, 0x040fe20007f5e0ffULL,
0x0000000117177824ULL, 0x100fe200078e0210ULL, 0x0000000026317faeULL, 0x0003e2000b901c46ULL,
0x0000000141417824ULL, 0x000fe400078e0210ULL, 0x0000010011107825ULL, 0x000fe200078e001aULL,
0x0000000028337faeULL, 0x0003e6000b901c46ULL, 0x000000010d2b7824ULL, 0x040fe200000e062bULL,
0x0000001c0c1c7210ULL, 0x040fe20007f1e0ffULL, 0x000000010d2d7824ULL, 0x000fe200008e062dULL,
0x000000180c187210ULL, 0x040fe20007f3e0ffULL, 0x0000010013127825ULL, 0x100fe200078e001aULL,
0x000000002a357faeULL, 0x0003e6000b901c46ULL, 0x0000010015147825ULL, 0x100fe200078e001aULL,
0x000000002c377faeULL, 0x0003e6000b901c46ULL, 0x0000010017167825ULL, 0x000fe200078e001aULL,
0x0000000024397faeULL, 0x0003e6000b901c46ULL, 0x000000010d217824ULL, 0x000fe200018e0621ULL,
0x000000100c107210ULL, 0x000fe20007f7e0ffULL, 0x00000100411a7825ULL, 0x000fc600078e001aULL,
0x00000000203b7faeULL, 0x0003e2000b901c46ULL, 0x000000010d1d7824ULL, 0x040fe200000e061dULL,
0x000000120c127210ULL, 0x040fe20007f1e0ffULL, 0x000000010d197824ULL, 0x040fe200008e0619ULL,
0x000000140c147210ULL, 0x040fe20007f3e0ffULL, 0x000000010d0f7824ULL, 0x040fe200010e060fULL,
0x000000160c167210ULL, 0x040fe20007f5e0ffULL, 0x000000010d117824ULL, 0x040fe200018e0611ULL,
0x0000001a0c0c7210ULL, 0x000fe20007f7e0ffULL, 0x000000010d137824ULL, 0x040fe200000e0613ULL,
0x000000001c3d7faeULL, 0x0003e2000b901c46ULL, 0x000000010d157824ULL, 0x000fc400008e0615ULL,
0x000000010d177824ULL, 0x040fe200010e0617ULL, 0x00000000183f7faeULL, 0x0003e2000b901c46ULL,
0x0000001b0d0d7210ULL, 0x000fc60001ffe4ffULL, 0x000000000e2e7faeULL, 0x0003e8000b901c46ULL,
0x0000000010307faeULL, 0x0003e8000b901c46ULL, 0x0000000012327faeULL, 0x0003e8000b901c46ULL,
0x0000000014347faeULL, 0x0003e8000b901c46ULL, 0x0000000016367faeULL, 0x0003e8000b901c46ULL,
0x000000000c437faeULL, 0x0003e4000b901c46ULL, 0x0000000204047810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0f7424ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000006d0400720cULL, 0x000fda0003f06070ULL, 0x0000000279108824ULL, 0x000fe400078e0204ULL,
0x00000004ff118424ULL, 0x000fc800078e00ffULL, 0x0000660010108625ULL, 0x000fe200078e0011ULL,
0x0000000705307812ULL, 0x000fe400078ec0ffULL, 0x00000004ff0e7819ULL, 0x000fe20000011605ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000006100f8981ULL, 0x000322000c1e1900ULL,
0x00000008300b7812ULL, 0x000fe200078ef805ULL, 0xffffffff00007948ULL, 0x000fe80003800000ULL,
0x000000010e0c7824ULL, 0x000fe400078e020bULL, 0x000000100b0d7824ULL, 0x000fca00078e00ffULL,
0xfffffff00d0d7812ULL, 0x000fca00078ee20cULL, 0x000000100d3c7824ULL, 0x000fc800078e00ffULL,
0x000000080e0d7824ULL, 0x002fe200078e00ffULL, 0x00000003ff607819ULL, 0x000fe20000011605ULL,
0x000000003c3c783bULL, 0x000fe20000000200ULL, 0x000000100b167824ULL, 0x000fe200078e00ffULL,
0x000000020c157810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80d307812ULL, 0x000fe200078ee230ULL,
0x00004000020d7824ULL, 0x000fe200078e00ffULL, 0x0000000160147812ULL, 0x000fe400078ec0ffULL,
0x0000001030457810ULL, 0x040fe20007ffe0ffULL, 0x0000000830117824ULL, 0x000fe200078e00ffULL,
0x0000003014447210ULL, 0x000fe20007ffe0ffULL, 0x0000000830187824ULL, 0x000fe200078e00ffULL,
0x000010000d0e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001145a7824ULL, 0x000fe200078e0245ULL,
0xfffffff811587812ULL, 0x000fe200078ee244ULL, 0x0000000845177824ULL, 0x000fe200078e00ffULL,
0x00000002445d7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff016157812ULL, 0x000fe200078ee215ULL,
0x0000001058107824ULL, 0x000fe200078e020eULL, 0xfffffff8185d7812ULL, 0x000fe400078ee25dULL,
0xfffffff8175a7812ULL, 0x000fe200078ee25aULL, 0x0000001015157824ULL, 0x000fe200078e00ffULL,
0x0000002030467810ULL, 0x000fe20007ffe0ffULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x000000105d4c7824ULL, 0x000fe200078e020eULL, 0x0000000e5a1c7211ULL, 0x000fe400078e20ffULL,
0x000000001534783bULL, 0x0005e20000000200ULL, 0x0000003030477810ULL, 0x000fe20007ffe0ffULL,
0x0000000114597824ULL, 0x000fe200078e0246ULL, 0x00000012445c7810ULL, 0x000fe20007ffe0ffULL,
0x000000004c4c783bULL, 0x000ee20000000200ULL, 0x0000000846167824ULL, 0x000fe200078e00ffULL,
0x0000002244617810ULL, 0x000fe20007ffe0ffULL, 0x00000001145b7824ULL, 0x000fe200078e0247ULL,
0x000000001c1c783bULL, 0x000ee20000000200ULL, 0x0000000847147824ULL, 0x000fe200078e00ffULL,
0xfffffff816597812ULL, 0x000fe200078ee259ULL, 0x0000000845157824ULL, 0x004fe200078e00ffULL,
0x0000000346187819ULL, 0x000fe200000006ffULL, 0x0000000847247824ULL, 0x000fe200078e00ffULL,
0xfffffff8145b7812ULL, 0x000fe200078ee25bULL, 0x0000001059287824ULL, 0x000fe200078e020eULL,
0xfffffff8155c7812ULL, 0x000fc400078ee25cULL, 0xfffffff818617812ULL, 0x000fe200078ee261ULL,
0x000000105b2c7824ULL, 0x100fe200078e020eULL, 0x0000003244657810ULL, 0x000fe20007ffe0ffULL,
0x000000105c147824ULL, 0x100fe200078e020eULL, 0x000000002828783bULL, 0x000ea20000000200ULL,
0x0000001061207824ULL, 0x100fe200078e020eULL, 0xfffffff824657812ULL, 0x000fe400078ee265ULL,
0x000000002c2c783bULL, 0x000ea20000000200ULL, 0x0000000444627810ULL, 0x040fe40007ffe0ffULL,
0x0000001065407824ULL, 0x000fe200078e020eULL, 0x000000001414783bULL, 0x000ea20000000200ULL,
0x0000003444677810ULL, 0x000fc40007ffe0ffULL, 0x000000060c317810ULL, 0x000fe20007ffe0ffULL,
0x000000002020783bULL, 0x000ea20000000200ULL, 0x0000001444637810ULL, 0x040fe20007ffe0ffULL,
0x000000103c38723cULL, 0x042f6200000018ffULL, 0x0000002444667810ULL, 0x040fe20007ffe0ffULL,
0x000000004040783bULL, 0x000e620000000200ULL, 0x0000003644567810ULL, 0x040fe40007ffe0ffULL,
0x00000016445f7810ULL, 0x040fe40007ffe0ffULL, 0x0000000644647810ULL, 0x040fe20007ffe0ffULL,
0x000000123c10723cULL, 0x000f6200000018ffULL, 0x0000002644577810ULL, 0x000fde0007ffe0ffULL,
0x0000004c3438723cULL, 0x068ff00000001838ULL, 0x0000004e344c723cULL, 0x000ff00000001810ULL,
0x0000001c3c10723cULL, 0x040f7000000018ffULL, 0x0000001e3c1c723cULL, 0x040ff000000018ffULL,
0x000000283c18723cULL, 0x044f7000000018ffULL, 0x0000002a3c28723cULL, 0x040f7000000018ffULL,
0x0000002c3c24723cULL, 0x000b6e00000018ffULL, 0x00000008302d7824ULL, 0x020fe200078e00ffULL,
0x000000143410723cULL, 0x000be80000001810ULL, 0xfffffff82d627812ULL, 0x000fc600078ee262ULL,
0x000000100b157824ULL, 0x020fe200078e00ffULL, 0x000000040c147810ULL, 0x000fe20007ffe0ffULL,
0x0000001062507824ULL, 0x000fe200078e020eULL, 0x000000203418723cULL, 0x000fe40000001818ULL,
0xfffffff0152c7812ULL, 0x000fc600078ee214ULL, 0x000000005050783bULL, 0x000fe60000000200ULL,
0x000000163414723cULL, 0x040bee000000181cULL, 0x000000102c1c7824ULL, 0x020fe200078e00ffULL,
0x000000223420723cULL, 0x000bea0000001828ULL, 0x000000001c1c783bULL, 0x000ea40000000200ULL,
0x00000008472a7824ULL, 0x020fe200078e00ffULL, 0x0000002e3c3c723cULL, 0x000f6200000018ffULL,
0x0000000845287824ULL, 0x000fe200078e00ffULL, 0x0000000346297819ULL, 0x040fe200000006ffULL,
0x0000000846467824ULL, 0x000fe200078e00ffULL, 0xfffffff82a677812ULL, 0x000fc400078ee267ULL,
0x0000000347477819ULL, 0x000fe400000006ffULL, 0x000000403424723cULL, 0x002b620000001824ULL,
0xfffffff828637812ULL, 0x000fe400078ee263ULL, 0xfffffff829667812ULL, 0x000fe400078ee266ULL,
0xfffffff847567812ULL, 0x000fe200078ee256ULL, 0x0000001063287824ULL, 0x000fe200078e020eULL,
0xfffffff846577812ULL, 0x000fe200078ee257ULL, 0x0000000830417824ULL, 0x020fc400078e00ffULL,
0x000000100b407824ULL, 0x000fe400078e00ffULL, 0x0000001067307824ULL, 0x100fe200078e020eULL,
0x000000002828783bULL, 0x000e620000000200ULL, 0x00000010662c7824ULL, 0x000fe200078e020eULL,
0xfffffff040407812ULL, 0x000fe200078ee231ULL, 0x000000423434723cULL, 0x000b62000000183cULL,
0xfffffff841647812ULL, 0x000fe200078ee264ULL, 0x000000003030783bULL, 0x000ee20000000200ULL,
0x0000001057487824ULL, 0x000fc600078e020eULL, 0x000000002c2c783bULL, 0x000ee20000000200ULL,
0x00000008453c7824ULL, 0x020fc600078e00ffULL, 0x000000004848783bULL, 0x000fe40000000200ULL,
0xfffffff83c5f7812ULL, 0x000fe200078ee25fULL, 0x000000501c38723cULL, 0x044be20000001838ULL,
0x00000010403c7824ULL, 0x000fe400078e00ffULL, 0x0000001064407824ULL, 0x100fe400078e020eULL,
0x000000105f447824ULL, 0x100fe400078e020eULL, 0x0000001056507824ULL, 0x020fe200078e020eULL,
0x000000521c4c723cULL, 0x040be2000000184cULL, 0x000000003c3c783bULL, 0x000fe80000000200ULL,
0x000000005050783bULL, 0x020ea80000000200ULL, 0x000000004040783bULL, 0x000ea80000000200ULL,
0x000000004444783bULL, 0x000ea20000000200ULL, 0x000000281c10723cULL, 0x042ff00000001810ULL,
0x000000301c24723cULL, 0x048f700000001824ULL, 0x0000002a1c14723cULL, 0x040f700000001814ULL,
0x0000002c1c18723cULL, 0x040f700000001818ULL, 0x0000002e1c20723cULL, 0x040f700000001820ULL,
0x000000321c34723cULL, 0x000b6e0000001834ULL, 0x000000770f1c7224ULL, 0x030fe200078e02ffULL,
0x000000503c24723cULL, 0x044b6e0000001824ULL, 0x0000030003507a10ULL, 0x020fe20007ffe0ffULL,
0x000000403c38723cULL, 0x000f660000001838ULL, 0x00000001501d7810ULL, 0x040fe20007ffe0ffULL,
0x00000100501e7824ULL, 0x000fc600078e0278ULL, 0x0000005e1d00720cULL, 0x000fe20003f06070ULL,
0x000000423c4c723cULL, 0x000f62000000184cULL, 0x000000401e1f7812ULL, 0x000fe200078ec0ffULL,
0x000064001c1c7625ULL, 0x000fcc00078e006bULL, 0x000000443c10723cULL, 0x040f700000001810ULL,
0x000000463c14723cULL, 0x040b6e0000001814ULL, 0x0000000168467824ULL, 0x020fe200078e021fULL,
0x000000483c18723cULL, 0x040b700000001818ULL, 0x0000004a3c20723cULL, 0x040b700000001820ULL,
0x000000523c34723cULL, 0x000b620000001834ULL, 0x00000c4000008947ULL, 0x000fce0003800000ULL,
0x00000008602d7810ULL, 0x040fe20007ffe0ffULL, 0x00000001603d7824ULL, 0x020fe200078e0205ULL,
0x0000001e693c7217ULL, 0x000fc40007800000ULL, 0x00000004601f7810ULL, 0x040fe20007ffe0ffULL,
0x000000012d417824ULL, 0x040fe200078e0205ULL, 0x0000001460437810ULL, 0x000fe20007ffe0ffULL,
0x000000082d2a7824ULL, 0x000fe200078e00ffULL, 0x000000051f317210ULL, 0x040fe20007ffe0ffULL,
0x000000013c3c7824ULL, 0x000fe200078e0a1eULL, 0x000000070a3d7812ULL, 0x000fe200078ef83dULL,
0x00000001601e7824ULL, 0x100fe200078e0246ULL, 0xfffffff82a417812ULL, 0x000fe200078ee241ULL,
0x000000081f287824ULL, 0x040fe200078e00ffULL, 0x0000003c1f00720cULL, 0x040fe20003f46070ULL,
0x000000011f2a7824ULL, 0x000fe200078e0246ULL, 0x0000000c602f7810ULL, 0x000fe20007ffe0ffULL,
0x000001001e1e7825ULL, 0x000fe200078e00ffULL, 0xfffffff828317812ULL, 0x000fc400078ee231ULL,
0x0000001060477810ULL, 0x000fe20007ffe0ffULL, 0x00000001430a7824ULL, 0x140fe200078e0205ULL,
0x000000091e297212ULL, 0x000fe200078efcffULL, 0x00000008432b7824ULL, 0x000fe200078e00ffULL,
0x0000003c2f00720cULL, 0x040fe20003fa6070ULL, 0x000000012f3f7824ULL, 0x040fe200078e0205ULL,
0x000000291c1e7210ULL, 0x000fe20007f1e0ffULL, 0x000000082f287824ULL, 0x000fe200078e00ffULL,
0xfffffff82b0a7812ULL, 0x000fe200078ee20aULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x0000000547337210ULL, 0x000fc40007ffe0ffULL, 0xfffffff8283f7812ULL, 0x000fe200078ee23fULL,
0x000000012d2e7824ULL, 0x100fe200078e0246ULL, 0x000000092a297212ULL, 0x000fe200078efcffULL,
0x000000012f287824ULL, 0x000fe200078e0246ULL, 0x0000003c6000720cULL, 0x080fe20003f26070ULL,
0x000001002e2e7825ULL, 0x000fe200078e00ffULL, 0x0000003c4700720cULL, 0x080fe40003f86070ULL,
0x0000003c2d00720cULL, 0x000fe20003f66070ULL, 0x000000011d1f7824ULL, 0x000fe200000e061fULL,
0x000000291c2a7210ULL, 0x000fe20007f1e0ffULL, 0x00000008472c7824ULL, 0x000fe200078e00ffULL,
0x000000092e497212ULL, 0x000fe200078efcffULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x0000001860457810ULL, 0x000fc40007ffe0ffULL, 0xfffffff82c337812ULL, 0x000fe200078ee233ULL,
0x000000011d2b7824ULL, 0x000fe200000e062bULL, 0x000000491c2e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001472c7824ULL, 0x000fe200078e0246ULL, 0x0000000928477212ULL, 0x000fe200078efcffULL,
0x000000103d3d7824ULL, 0x000fe200078e020eULL, 0x0000000545327210ULL, 0x000fe20007ffe0ffULL,
0x000001002c2c7825ULL, 0x000fe200078e00ffULL, 0x000000471c287210ULL, 0x000fe40007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e3d7faeULL, 0x0003e2000c901c46ULL,
0x000000011d2f7824ULL, 0x000fe200000e062fULL, 0x0000003c4300720cULL, 0x0c0fe20003f06070ULL,
0x0000000143437824ULL, 0x000fe200078e0246ULL, 0x000000092c477212ULL, 0x000fe200078efcffULL,
0x000000011d297824ULL, 0x000fe200030e0629ULL, 0x0000002060497810ULL, 0x000fe20007ffe0ffULL,
0x00000008454b7824ULL, 0x000fe200078e00ffULL, 0x000000471c2c7210ULL, 0x000fe20007fde0ffULL,
0x0000001041417824ULL, 0x000fe200078e020eULL, 0x0000001c60477810ULL, 0x000fe20007ffe0ffULL,
0x0000000149407824ULL, 0x000fe200078e0205ULL, 0xfffffff84b327812ULL, 0x000fe200078ee232ULL,
0x00000100431e7825ULL, 0x002fe200078e00ffULL, 0x0000003c4500720cULL, 0x000fc40003f26070ULL,
0x00000003474b7819ULL, 0x000fe200000006ffULL, 0x000000011d2d7824ULL, 0x000fe200030e062dULL,
0x000000091e437212ULL, 0x000fe200078efcffULL, 0x00000001473e7824ULL, 0x000fe200078e0205ULL,
0x0000000e3f3f7211ULL, 0x000fe200078e20ffULL, 0x0000000145457824ULL, 0x000fe200078e0246ULL,
0x000000431c307210ULL, 0x000fe20007fde0ffULL, 0x0000000849517824ULL, 0x000fe200078e00ffULL,
0xfffffff84b3d7812ULL, 0x000fe200078ee23eULL, 0x0000001031437824ULL, 0x000fe400078e020eULL,
0x000000011d317824ULL, 0x000fe200030e061fULL, 0xfffffff8513e7812ULL, 0x000fe200078ee240ULL,
0x00000100451e7825ULL, 0x000fe200078e00ffULL, 0x000000002a437faeULL, 0x0003e2000d101c46ULL,
0x0000003c4700720cULL, 0x000fc40003f46070ULL, 0x0000000147407824ULL, 0x100fe200078e0246ULL,
0x000000091e457212ULL, 0x000fe200078efcffULL, 0x000000002e417faeULL, 0x0005e2000d901c46ULL,
0x0000000149427824ULL, 0x040fe200078e0246ULL, 0x0000003c4900720cULL, 0x080fe20003f66070ULL,
0x0000001033337824ULL, 0x000fe200078e020eULL, 0x000000451c1e7210ULL, 0x000fe20007fde0ffULL,
0x00000000283f7faeULL, 0x0007e2000e901c46ULL, 0x0000002460457810ULL, 0x000fe20007ffe0ffULL,
0x00000100422a7825ULL, 0x002fe200078e00ffULL, 0x0000003060497810ULL, 0x000fe20007ffe0ffULL,
0x000000002c337faeULL, 0x0003e2000e101c46ULL, 0x0000003c4500720cULL, 0x000fe20003fa6070ULL,
0x000000011d1f7824ULL, 0x000fe200030e061fULL, 0x000000092a417212ULL, 0x004fe200078efcffULL,
0x00000100402e7825ULL, 0x000fe200078e00ffULL, 0x0000003c60517810ULL, 0x000fc60007ffe0ffULL,
0x0000000145407824ULL, 0x040fe200078e0205ULL, 0x000000092e437212ULL, 0x000fe200078efcffULL,
0x00000001452e7824ULL, 0x140fe400078e0246ULL, 0x0000000845477824ULL, 0x000fe200078e00ffULL,
0x000000431c287210ULL, 0x008fe20007fde0ffULL, 0x0000000149337824ULL, 0x042fe200078e0246ULL,
0x0000002860437810ULL, 0x000fe20007ffe0ffULL, 0x00000008494b7824ULL, 0x000fe400078e00ffULL,
0x000000011d297824ULL, 0x000fe200030e062fULL, 0x000000411c2a7210ULL, 0x000fe20007fde0ffULL,
0x000001002e2e7825ULL, 0x000fe200078e00ffULL, 0xfffffff847417812ULL, 0x000fc400078ee240ULL,
0x0000002c60477810ULL, 0x000fe20007ffe0ffULL, 0x0000000143407824ULL, 0x040fe200078e0205ULL,
0x000000092e3f7212ULL, 0x000fe200078efcffULL, 0x0000000843457824ULL, 0x040fe200078e00ffULL,
0x00000046432e7210ULL, 0x000fe20007ffe0ffULL, 0x000000011d2b7824ULL, 0x000fe200030e062bULL,
0x0000003f1c2c7210ULL, 0x000fe20007fde0ffULL, 0x000000103d3d7824ULL, 0x000fe200078e020eULL,
0xfffffff8453f7812ULL, 0x000fe200078ee240ULL, 0x000000100a457824ULL, 0x000fe200078e020eULL,
0x0000003c4300720cULL, 0x000fe20003f86070ULL, 0x000000011d2d7824ULL, 0x000fe200030e062fULL,
0x0000000e3f3f7211ULL, 0x000fe200078e20ffULL, 0x000001002e2e7825ULL, 0x000fe200078e00ffULL,
0x0000000030457faeULL, 0x0003e2000c101c46ULL, 0x0000003c4700720cULL, 0x000fc40003f06070ULL,
0x00000001470a7824ULL, 0x040fe200078e0246ULL, 0x000000092e437212ULL, 0x000fe200078efcffULL,
0x0000000147407824ULL, 0x040fe400078e0205ULL, 0x0000000847477824ULL, 0x000fe200078e00ffULL,
0x000000431c2e7210ULL, 0x000fe20007fde0ffULL, 0x0000001041417824ULL, 0x000fe400078e020eULL,
0x000001000a307825ULL, 0x002fe200078e00ffULL, 0xfffffff847437812ULL, 0x000fe400078ee240ULL,
0x00000005490a7210ULL, 0x000fe20007ffe0ffULL, 0x0000001032477824ULL, 0x000fe200078e020eULL,
0x0000000930457212ULL, 0x000fe200078efcffULL, 0x0000010033327825ULL, 0x000fc600078e00ffULL,
0x000000001e477faeULL, 0x0003e2000c901c46ULL, 0x000000011d2f7824ULL, 0x000fe200030e062fULL,
0x0000003c4900720cULL, 0x080fe20003f26070ULL, 0x0000001043437824ULL, 0x000fe200078e020eULL,
0x0000003460497810ULL, 0x000fe20007ffe0ffULL, 0x00000000283d7faeULL, 0x0005e2000d101c46ULL,
0x0000003c5100720cULL, 0x000fe40003f46070ULL, 0x000000451c1e7210ULL, 0x002fe40007fde0ffULL,
0x0000000932457212ULL, 0x000fe200078efcffULL, 0x0000000149327824ULL, 0x000fc400078e0205ULL,
0x000000011d1f7824ULL, 0x000fe200030e0631ULL, 0x000000451c307210ULL, 0x000fe40007fde0ffULL,
0xfffffff84b457812ULL, 0x000fe200078ee20aULL, 0x00000001490a7824ULL, 0x000fe200078e0246ULL,
0x00000038604b7810ULL, 0x000fe20007ffe0ffULL, 0x000000011d317824ULL, 0x000fe400030e0633ULL,
0x000000103e337824ULL, 0x000fe400078e020eULL, 0x000001000a287825ULL, 0x004fc600078e00ffULL,
0x000000002a337faeULL, 0x0003e2000d901c46ULL, 0x000000014b0a7824ULL, 0x040fe200078e0246ULL,
0x0000000928477212ULL, 0x000fe200078efcffULL, 0x000000084b3d7824ULL, 0x000fe200078e00ffULL,
0x000000002c417faeULL, 0x0005e2000e901c46ULL, 0x0000003c4900720cULL, 0x0c0fe20003fa6070ULL,
0x0000000849497824ULL, 0x000fe200078e00ffULL, 0x000000471c287210ULL, 0x000fe20007fde0ffULL,
0x0000001045457824ULL, 0x000fe200078e020eULL, 0x0000003c4b00720cULL, 0x000fe20003f66070ULL,
0x00000001513c7824ULL, 0x100fe200078e0205ULL, 0x000000291d297210ULL, 0x000fe200037fe4ffULL,
0x000001000a2a7825ULL, 0x002fe200078e00ffULL, 0x000000002e3f7faeULL, 0x0003e6000e101c46ULL,
0x00000001512c7824ULL, 0x004fe200078e0246ULL, 0x000000092a337212ULL, 0x000fe200078efcffULL,
0x000000014b0a7824ULL, 0x000fe200078e0205ULL, 0x000000001e437faeULL, 0x0003e2000c101c46ULL,
0x000001002c2c7825ULL, 0x000fe200078e00ffULL, 0x000000331c2a7210ULL, 0x000fc40007fde0ffULL,
0xfffffff849337812ULL, 0x000fe200078ee232ULL, 0x0000000851417824ULL, 0x000fe200078e00ffULL,
0x000000092c097212ULL, 0x000fe200078efcffULL, 0x000000011d2b7824ULL, 0x000fe200030e062bULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee20aULL, 0x0000000030457faeULL, 0x0003e2000c901c46ULL,
0xfffffff841417812ULL, 0x000fe400078ee23cULL, 0x000000091c1c7210ULL, 0x000fe20007fde0ffULL,
0x0000001033097824ULL, 0x100fe400078e020eULL, 0x000000103d337824ULL, 0x000fc400078e020eULL,
0x00000010413d7824ULL, 0x000fe200078e020eULL, 0x0000000028097faeULL, 0x0003e2000e901c46ULL,
0x000000011d1d7824ULL, 0x000fc600030e062dULL, 0x000000002a337faeULL, 0x0003e8000d901c46ULL,
0x000000001c3d7faeULL, 0x0003e2000d101c46ULL, 0x00000b1000007947ULL, 0x000fea0003800000ULL,
0x00000001602a7824ULL, 0x040fe200078e0246ULL, 0x0000000c606f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000160457824ULL, 0x040fe200078e0205ULL, 0x00000004601e7810ULL, 0x000fe20007ffe0ffULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x0000000860707810ULL, 0x000fc40007ffe0ffULL,
0x000000461e287210ULL, 0x080fe20007ffe0ffULL, 0x000000016f1f7824ULL, 0x100fe200078e0246ULL,
0x00000010606e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001702c7824ULL, 0x000fe200078e0246ULL,
0x000000092a2f7212ULL, 0x000fe200078efcffULL, 0x000000011e447824ULL, 0x000fe200078e0205ULL,
0x000000466e3c7210ULL, 0x020fe20007ffe0ffULL, 0x000000081e317824ULL, 0x000fe200078e00ffULL,
0x0000002f1c2a7210ULL, 0x000fe20007f1e0ffULL, 0x000001001f1e7825ULL, 0x000fe200078e00ffULL,
0x0000001860527810ULL, 0x000fc40007ffe0ffULL, 0xfffffff831447812ULL, 0x000fe200078ee244ULL,
0x0000010028287825ULL, 0x000fe200078e00ffULL, 0x000000091e2f7212ULL, 0x080fe400078efcffULL,
0x000000070a457812ULL, 0x000fe200078ef845ULL, 0x000001002c2c7825ULL, 0x000fe200078e00ffULL,
0x0000000928317212ULL, 0x080fe400078efcffULL, 0x00000014606c7810ULL, 0x000fe20007ffe0ffULL,
0x000001003c3c7825ULL, 0x000fe200078e00ffULL, 0x000000092c437212ULL, 0x000fc400078efcffULL,
0x0000001c60517810ULL, 0x000fe20007ffe0ffULL, 0x000000011d2b7824ULL, 0x040fe200000e062bULL,
0x0000002f1c1e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000152307824ULL, 0x100fe200078e0246ULL,
0x00000020600a7810ULL, 0x000fe20007ffe0ffULL, 0x000000016c327824ULL, 0x100fe200078e0246ULL,
0x000000311c287210ULL, 0x000fe20007f3e0ffULL, 0x0000010030307825ULL, 0x000fe200078e00ffULL,
0x000000093c417212ULL, 0x000fe400078efcffULL, 0x000000431c427210ULL, 0x040fe20007f5e0ffULL,
0x000000011d1f7824ULL, 0x000fe200000e061fULL, 0x000000411c407210ULL, 0x000fe20007f1e0ffULL,
0x00000001512e7824ULL, 0x100fe200078e0246ULL, 0x0000000930477212ULL, 0x000fe200078efcffULL,
0x000000010a2c7824ULL, 0x000fe200078e0246ULL, 0x00000024604a7810ULL, 0x000fe20007ffe0ffULL,
0x000000011d437824ULL, 0x000fe200010e062dULL, 0x0000000e45457211ULL, 0x000fe200078e20ffULL,
0x0000010032327825ULL, 0x000fe200078e00ffULL, 0x00000028604b7810ULL, 0x000fc40007ffe0ffULL,
0x0000002c60537810ULL, 0x000fe20007ffe0ffULL, 0x000001002e2e7825ULL, 0x000fe200078e00ffULL,
0x00000009323f7212ULL, 0x080fe200078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a457faeULL, 0x0003e2000b901c46ULL, 0x00000030606b7810ULL, 0x000fe20007ffe0ffULL,
0x000001002c2c7825ULL, 0x000fe200078e00ffULL, 0x000000092e497212ULL, 0x000fe400078efcffULL,
0x0000003460767810ULL, 0x000fe20007ffe0ffULL, 0x000000011d417824ULL, 0x040fe200000e063dULL,
0x000000471c3c7210ULL, 0x000fe20007f1e0ffULL, 0x000000011d297824ULL, 0x040fe200008e0629ULL,
0x000000092c477212ULL, 0x000fe200078efcffULL, 0x000000014a2c7824ULL, 0x000fe200078e0246ULL,
0x0000003f1c3e7210ULL, 0x040fe20007f3e0ffULL, 0x000000011d3d7824ULL, 0x000fe200000e0631ULL,
0x000000491c327210ULL, 0x000fe20007f5e0ffULL, 0x000001002c2a7825ULL, 0x002fe200078e00ffULL,
0x000000471c307210ULL, 0x000fc40007f1e0ffULL, 0x0000003860757810ULL, 0x040fe20007ffe0ffULL,
0x000000011d3f7824ULL, 0x040fe200008e0633ULL, 0x0000003c60607810ULL, 0x000fe20007ffe0ffULL,
0x000000011d337824ULL, 0x040fe200010e062fULL, 0x000000092a2f7212ULL, 0x000fe200078efcffULL,
0x000000011d317824ULL, 0x000fe400000e062dULL, 0x000000014b2d7824ULL, 0x000fe200078e0246ULL,
0x0000002f1c2e7210ULL, 0x000fe20007f1e0ffULL, 0x0000001044477824ULL, 0x000fe400078e020eULL,
0x000001002d2c7825ULL, 0x000fc600078e00ffULL, 0x0000000028477faeULL, 0x0003e2000b901c46ULL,
0x0000000153447824ULL, 0x000fe200078e0246ULL, 0x000000092c457212ULL, 0x000fe200078efcffULL,
0x000000011d2f7824ULL, 0x000fe400000e062bULL, 0x00000100442a7825ULL, 0x000fe200078e00ffULL,
0x000000451c2c7210ULL, 0x000fc60007f1e0ffULL, 0x000000016b487824ULL, 0x100fe200078e0246ULL,
0x000000092a457212ULL, 0x000fe200078efcffULL, 0x0000000176447824ULL, 0x000fe400078e0246ULL,
0x0000010048287825ULL, 0x002fc800078e00ffULL, 0x000000011d2d7824ULL, 0x040fe200000e062dULL,
0x000000451c2a7210ULL, 0x000fe20007f1e0ffULL, 0x0000010044447825ULL, 0x000fe200078e00ffULL,
0x0000000928477212ULL, 0x000fe400078efcffULL, 0x0000002b1d2b7210ULL, 0x000fe200007fe4ffULL,
0x0000000160487824ULL, 0x000fe200078e0246ULL, 0x000000471c287210ULL, 0x000fe20007f3e0ffULL,
0x000000010a7d7824ULL, 0x000fe200078e0205ULL, 0x0000000944477212ULL, 0x000fe200078efcffULL,
0x0000010048487825ULL, 0x000fc600078e00ffULL, 0x000000471c447210ULL, 0x000fe20007f1e0ffULL,
0x0000000175477824ULL, 0x000fe400078e0246ULL, 0x000000011d297824ULL, 0x000fe400008e0629ULL,
0x0000010047467825ULL, 0x000fc800078e00ffULL, 0x000000011d457824ULL, 0x000fe200000e0645ULL,
0x00000009467b7212ULL, 0x080fe200078efcffULL, 0x000000080a0a7824ULL, 0x000fe200078e00ffULL,
0x0000000948097212ULL, 0x000fe200078efcffULL, 0x000000086f487824ULL, 0x000fe200078e00ffULL,
0x0000007b1c467210ULL, 0x040fe40007f1e0ffULL, 0x000000091c1c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000170097824ULL, 0x040fe200078e0205ULL, 0x0000000370707819ULL, 0x000fe200000006ffULL,
0x000000011d477824ULL, 0x000fe200000e0647ULL, 0xfffffff80a7d7812ULL, 0x000fe200078ee27dULL,
0x000000014b0a7824ULL, 0x000fe200078e0205ULL, 0xfffffff870097812ULL, 0x000fe200078ee209ULL,
0x000000011d1d7824ULL, 0x000fc400008e0649ULL, 0x000000016c497824ULL, 0x100fe400078e0205ULL,
0x00000010097b7824ULL, 0x000fe400078e020eULL, 0x000000016f097824ULL, 0x100fe400078e0205ULL,
0x000000016e6f7824ULL, 0x040fe200078e0205ULL, 0x00000000427b7faeULL, 0x0003e2000b901c46ULL,
0x000000086e6e7824ULL, 0x000fe200078e00ffULL, 0xfffffff848097812ULL, 0x000fe200078ee209ULL,
0x0000000152487824ULL, 0x000fc400078e0205ULL, 0x000000086c6c7824ULL, 0x000fe200078e00ffULL,
0xfffffff86e6f7812ULL, 0x000fe200078ee26fULL, 0x0000001009097824ULL, 0x100fe400078e020eULL,
0x000000107d7d7824ULL, 0x100fe200078e020eULL, 0xfffffff86c497812ULL, 0x000fe200078ee249ULL,
0x000000106f6f7824ULL, 0x000fe200078e020eULL, 0x00000003527b7819ULL, 0x002fe200000006ffULL,
0x0000000151437824ULL, 0x140fe200078e0205ULL, 0x000000001e097faeULL, 0x0003e2000b901c46ULL,
0x0000000851427824ULL, 0x000fe200078e00ffULL, 0xfffffff87b517812ULL, 0x000fe200078ee248ULL,
0x0000000853487824ULL, 0x000fe200078e00ffULL, 0x00000000406f7faeULL, 0x0003e2000b901c46ULL,
0x000000014a7b7824ULL, 0x000fe200078e0205ULL, 0xfffffff842437812ULL, 0x000fe200078ee243ULL,
0x000000084b427824ULL, 0x000fe200078e00ffULL, 0x00000005534b7210ULL, 0x000fe20007ffe0ffULL,
0x000000084a4a7824ULL, 0x000fc400078e00ffULL, 0x0000001049497824ULL, 0x000fe200078e020eULL,
0xfffffff842537812ULL, 0x000fe200078ee20aULL, 0x000000016b0a7824ULL, 0x040fe200078e0205ULL,
0xfffffff8484b7812ULL, 0x000fe200078ee24bULL, 0x000000086b427824ULL, 0x000fe200078e00ffULL,
0xfffffff84a7b7812ULL, 0x000fe200078ee27bULL, 0x00000001766b7824ULL, 0x140fe200078e0205ULL,
0x000000003e497faeULL, 0x0003e2000b901c46ULL, 0x0000000876767824ULL, 0x000fe200078e00ffULL,
0xfffffff8420a7812ULL, 0x000fe200078ee20aULL, 0x0000000175427824ULL, 0x000fe200078e0205ULL,
0x0000000e4b4b7211ULL, 0x000fe200078e20ffULL, 0x0000000875487824ULL, 0x000fe200078e00ffULL,
0xfffffff8766b7812ULL, 0x000fe200078ee26bULL, 0x0000000160757824ULL, 0x040fe200078e0205ULL,
0x0000000360607819ULL, 0x000fe200000006ffULL, 0x0000001051517824ULL, 0x000fe200078e020eULL,
0xfffffff848427812ULL, 0x000fe200078ee242ULL, 0x0000001043437824ULL, 0x100fe200078e020eULL,
0xfffffff860757812ULL, 0x000fe200078ee275ULL, 0x000000107b7b7824ULL, 0x100fe200078e020eULL,
0x000000003c517faeULL, 0x0003e2000b901c46ULL, 0x0000001053537824ULL, 0x000fc400078e020eULL,
0x000000100a0a7824ULL, 0x100fe200078e020eULL, 0x0000000032437faeULL, 0x0003e2000b901c46ULL,
0x000000106b6b7824ULL, 0x100fe400078e020eULL, 0x0000001042427824ULL, 0x100fe200078e020eULL,
0x00000000307d7faeULL, 0x0003e2000b901c46ULL, 0x0000001075757824ULL, 0x000fc600078e020eULL,
0x000000002e7b7faeULL, 0x0003e8000b901c46ULL, 0x000000002c537faeULL, 0x0003e8000b901c46ULL,
0x000000002a4b7faeULL, 0x0003e8000b901c46ULL, 0x00000000280a7faeULL, 0x0003e8000b901c46ULL,
0x00000000446b7faeULL, 0x0003e8000b901c46ULL, 0x0000000046427faeULL, 0x0003e8000b901c46ULL,
0x000000001c757faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000100b0a7824ULL, 0x042fe200078e00ffULL, 0x000000080c097810ULL, 0x000fe20007ffe0ffULL,
0x000000100b297824ULL, 0x000fe200078e00ffULL, 0x000030000d0d7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff00a097812ULL, 0x000fe400078ee209ULL, 0x0000000a0c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000010581c7824ULL, 0x100fe200078e020dULL, 0x0000000d59407211ULL, 0x000fe200078e20ffULL,
0x0000001009097824ULL, 0x000fe200078e00ffULL, 0xfffffff0290a7812ULL, 0x000fe200078ee20aULL,
0x000000105d2c7824ULL, 0x100fe400078e020dULL, 0x000000105a447824ULL, 0x100fe400078e020dULL,
0x000000105b3c7824ULL, 0x000fc400078e020dULL, 0x000000100a0a7824ULL, 0x000fe400078e00ffULL,
0x000000105c487824ULL, 0x100fe400078e020dULL, 0x0000001056587824ULL, 0x000fe200078e020dULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000001c1c783bULL, 0x000fe80000000200ULL,
0x000000000930783bULL, 0x0002a80000000200ULL, 0x000000004040783bULL, 0x000ee80000000200ULL,
0x000000002c2c783bULL, 0x000fe20000000200ULL, 0x0000000c0c097810ULL, 0x002fc40007ffe0ffULL,
0x0000000e0c0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000000a28783bULL, 0x0003280000000200ULL,
0x000000004444783bULL, 0x000ee80000000200ULL, 0x000000003c3c783bULL, 0x000f220000000200ULL,
0x000000100b0a7824ULL, 0x002fc400078e00ffULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0x000000004848783bULL, 0x000fe40000000200ULL, 0xfffffff00a097812ULL, 0x000fe400078ee209ULL,
0xfffffff00b0c7812ULL, 0x000fe200078ee20cULL, 0x000000005858783bULL, 0x000fe40000000200ULL,
0x0000001009097824ULL, 0x000fe400078e00ffULL, 0x000000100c0c7824ULL, 0x000fe200078e00ffULL,
0x0000001c3038723cULL, 0x044b6e0000001838ULL, 0x00000010611c7824ULL, 0x120fe200078e020dULL,
0x0000001e304c723cULL, 0x040b6a000000184cULL, 0x000000001c1c783bULL, 0x020e660000000200ULL,
0x000000403018723cULL, 0x008b6e0000001818ULL, 0x0000001063407824ULL, 0x120fe200078e020dULL,
0x0000002c2838723cULL, 0x010bee0000001838ULL, 0x00000010652c7824ULL, 0x120fe200078e020dULL,
0x000000443010723cULL, 0x040bee0000001810ULL, 0x0000001067447824ULL, 0x120fe200078e020dULL,
0x000000463014723cULL, 0x040bea0000001814ULL, 0x000000004444783bULL, 0x020fe60000000200ULL,
0x000000423020723cULL, 0x040b640000001820ULL, 0x000000004040783bULL, 0x020fec0000000200ULL,
0x0000003c3024723cULL, 0x040f700000001824ULL, 0x0000003e3034723cULL, 0x000b640000001834ULL,
0x00000000093c783bULL, 0x020fea0000000200ULL, 0x0000000d62307211ULL, 0x080fe200078e20ffULL,
0x0000002e284c723cULL, 0x040b64000000184cULL, 0x000000002c2c783bULL, 0x020ea80000000200ULL,
0x000000003030783bULL, 0x000ee40000000200ULL, 0x0000001c2818723cULL, 0x042b6e0000001818ULL,
0x00000010661c7824ULL, 0x120fe200078e020dULL, 0x0000001e2820723cULL, 0x040bea0000001820ULL,
0x000000001c1c783bULL, 0x020e660000000200ULL, 0x000000482810723cULL, 0x040bee0000001810ULL,
0x000000105f487824ULL, 0x120fe200078e020dULL, 0x0000004a2814723cULL, 0x040bea0000001814ULL,
0x000000004848783bULL, 0x020fe60000000200ULL, 0x0000002c2824723cULL, 0x044b6e0000001824ULL,
0x00000010642c7824ULL, 0x020fe200078e020dULL, 0x0000002e2834723cULL, 0x000b640000001834ULL,
0x000000000c28783bULL, 0x020fe80000000200ULL, 0x000000002c2c783bULL, 0x000fe40000000200ULL,
0x000000303c38723cULL, 0x048bee0000001838ULL, 0x0000000d57307211ULL, 0x020fe200078e20ffULL,
0x000000323c4c723cULL, 0x040bea000000184cULL, 0x000000003030783bULL, 0x020ea60000000200ULL,
0x0000001c3c18723cULL, 0x042f700000001818ULL, 0x000000443c24723cULL, 0x040f700000001824ULL,
0x000000403c10723cULL, 0x040ff00000001810ULL, 0x000000423c14723cULL, 0x040ff00000001814ULL,
0x0000001e3c20723cULL, 0x040ff00000001820ULL, 0x000000463c34723cULL, 0x000ff00000001834ULL,
0x000000302818723cULL, 0x064f700000001818ULL, 0x000000582824723cULL, 0x040f700000001824ULL,
0x0000002c2838723cULL, 0x040b700000001838ULL, 0x0000002e284c723cULL, 0x000b64000000184cULL,
0x3db504f3192c7820ULL, 0x020fc40000410000ULL, 0x3db504f318187820ULL, 0x000fe40000410000ULL,
0x3db504f31a0c7820ULL, 0x000fe40000410000ULL, 0x3db504f31b0d7820ULL, 0x000fe20000410000ULL,
0x000000482810723cULL, 0x000f620000001810ULL, 0x3db504f3261c7820ULL, 0x000fe40000410000ULL,
0x3db504f3271d7820ULL, 0x000fe40000410000ULL, 0x3db504f324307820ULL, 0x000fc40000410000ULL,
0x3db504f3252e7820ULL, 0x000fe20000410000ULL, 0x0000004a2814723cULL, 0x000f620000001814ULL,
0x3db504f338387820ULL, 0x000fe40000410000ULL, 0x3db504f33a3a7820ULL, 0x000fe40000410000ULL,
0x3db504f33b3b7820ULL, 0x000fc60000410000ULL, 0x000000322820723cULL, 0x000b620000001820ULL,
0x3db504f34e4e7820ULL, 0x000fcc0000410000ULL, 0x3db504f34d327820ULL, 0x020fe20000410000ULL,
0x0000005a2834723cULL, 0x000b620000001834ULL, 0x3db504f34f337820ULL, 0x000fe40000410000ULL,
0x3db504f3102f7820ULL, 0x000fe40000410000ULL, 0x3db504f312127820ULL, 0x000fe40000410000ULL,
0x3db504f339287820ULL, 0x020fe40000410000ULL, 0x3db504f34c297820ULL, 0x000fc40000410000ULL,
0x3db504f3112a7820ULL, 0x000fe40000410000ULL, 0x3db504f313137820ULL, 0x000fe40000410000ULL,
0x3db504f3142b7820ULL, 0x000fe40000410000ULL, 0x3db504f315157820ULL, 0x000fe40000410000ULL,
0x3db504f316167820ULL, 0x000fe40000410000ULL, 0x3db504f317097820ULL, 0x000fc40000410000ULL,
0x3db504f3202d7820ULL, 0x000fe40000410000ULL, 0x3db504f321317820ULL, 0x000fe40000410000ULL,
0x3db504f3220e7820ULL, 0x000fe40000410000ULL, 0x3db504f323197820ULL, 0x000fe40000410000ULL,
0x3db504f334267820ULL, 0x000fe40000410000ULL, 0x3db504f335277820ULL, 0x000fc40000410000ULL,
0x3db504f3361e7820ULL, 0x000fe40000410000ULL, 0x3db504f3371f7820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000730a7f8cULL, 0x0002a2000c80043fULL,
0x000000ffff347224ULL, 0x000fe200078e0018ULL, 0x0000001300217202ULL, 0x000fe20000000f00ULL,
0x000000ffff247224ULL, 0x000fe400078e0016ULL, 0x000000ffff177224ULL, 0x000fe400078e0038ULL,
0x000000ffff367224ULL, 0x000fc400078e0015ULL, 0x000000ffff227224ULL, 0x000fe400078e003aULL,
0x000000ffff1a7224ULL, 0x000fe400078e003bULL, 0x000000ffff1b7224ULL, 0x000fe400078e004eULL,
0x000000ffff237224ULL, 0x000fe400078e0012ULL, 0x000000ffff357224ULL, 0x000fe400078e0009ULL,
0x000000ffff257224ULL, 0x000fc400078e000cULL, 0x000000ffff167224ULL, 0x000fe400078e000dULL,
0x000000ffff187224ULL, 0x000fc400078e000eULL, 0x00000000000c7805ULL, 0x002fca0000015200ULL,
0x0000040073097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x006fe4000780480bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100c0e7210ULL, 0x000fca0007f1e1ffULL,
0x0000000111107824ULL, 0x000fe200000e0e0dULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1000720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1000720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc80000011410ULL,
0x0000000e09097211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e0610ULL,
0x0000000209097819ULL, 0x000fc8000000120eULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040073097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000205207819ULL, 0x000fe400000006ffULL, 0x000000710300720cULL, 0x000fe40003f06070ULL,
0xfffffff020097812ULL, 0x000fca00078ec0ffULL, 0x00000080020e7824ULL, 0x000fca00078e0209ULL,
0x01b400000e107984ULL, 0x0002a20000000c00ULL, 0x000014e000008947ULL, 0x000fea0003800000ULL,
0x00005a00000c7b06ULL, 0x000ee20000209000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fcc0003f85070ULL, 0x0000000c000c7308ULL, 0x008ee40000001000ULL,
0x0ffffffe0c0b7810ULL, 0x008fcc0007ffe0ffULL, 0x0000000b000b7305ULL, 0x000ee4000021f000ULL,
0x000000ffff037224ULL, 0x008fc800078e0a0bULL, 0x00005a0003037a24ULL, 0x000fc800078e02ffULL,
0x000000030b147227ULL, 0x000fe200078e000aULL, 0x0000007205037211ULL, 0x000fe400078ff0ffULL,
0x00000008690b7217ULL, 0x000fc60007800000ULL, 0x0000000314097227ULL, 0x000fc800078e00ffULL,
0x000000ffff0a7224ULL, 0x000fe400078e0a09ULL, 0x000000010b387824ULL, 0x000fe400078e0a08ULL,
0x00005a000a0a7a24ULL, 0x000fe200078e0203ULL, 0x0000000803037810ULL, 0x000fc80007ffe0ffULL,
0x00005a000a007a0cULL, 0x000fe20003f06070ULL, 0x00000003140d7227ULL, 0x000fe200078e00ffULL,
0x00005a00ff147a12ULL, 0x000fc600078e33ffULL, 0x000000ffff0c7224ULL, 0x000fc800078e0a0dULL,
0x00005a000c0c7a24ULL, 0x000fe400078e0203ULL, 0x0000000205037824ULL, 0x000fe400078e00ffULL,
0x80005a000a0a0a10ULL, 0x000fe40007ffe0ffULL, 0x00005a000c007a0cULL, 0x000fe40003f46070ULL,
0x00005a000a007a0cULL, 0x000fe40003f26070ULL, 0x0000000603037812ULL, 0x000fc400078ec0ffULL,
0x0000000109090810ULL, 0x000fc60007ffe0ffULL, 0x00000001070b7824ULL, 0x000fe400078e0203ULL,
0x0000000103377824ULL, 0x000fe400078e0200ULL, 0x80005a000c0c2a10ULL, 0x000fe40007ffe0ffULL,
0x000000380b00720cULL, 0x000fe40003f66070ULL, 0x0000000109091810ULL, 0x000fe40007ffe0ffULL,
0x0000000b380b7210ULL, 0x000fc40007ffe1ffULL, 0x0000000914097207ULL, 0x000fe40006000000ULL,
0x00005a000c007a0cULL, 0x000fe40003f06070ULL, 0x0000000b06087217ULL, 0x040fe20003800000ULL,
0x00000001370b7824ULL, 0x040fe200078e0a38ULL, 0x0000000906097217ULL, 0x000fe40003800000ULL,
0x00000004ff087819ULL, 0x000fe40000011608ULL, 0x000000383700720cULL, 0x000fe20003f26070ULL,
0x000000096a4f7224ULL, 0x000fe200078e02ffULL, 0x0000000b060b7217ULL, 0x000fc40003800000ULL,
0x000000ff080c7207ULL, 0x000fe40001800000ULL, 0x000000010d0d2810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0b467207ULL, 0x000fe20000800000ULL, 0x000000014f097824ULL, 0x000fe200078e020cULL,
0x000000010d0d0810ULL, 0x000fe40007ffe0ffULL, 0x0000004f460b7211ULL, 0x000fe200078fe0ffULL,
0x0000000209087825ULL, 0x000fe200078e0054ULL, 0x0000000d140d7207ULL, 0x000fc40006000000ULL,
0x00000010033b7812ULL, 0x000fe200078efcffULL, 0x000000020b0a7825ULL, 0x000fe200078e0054ULL,
0x0000000d060d7217ULL, 0x000fe20003800000ULL, 0x00000006084c7981ULL, 0x000728000c1e9500ULL,
0x000000060a4d7981ULL, 0x000322000c1e9500ULL, 0x0000000d6a517224ULL, 0x000fe400078e02ffULL,
0x000000013b397824ULL, 0x000fc400078e0200ULL, 0x000000010c0d7824ULL, 0x000fe200078e0251ULL,
0x00000020033d7812ULL, 0x000fe200078efcffULL, 0x0000000107097824ULL, 0x008fe200078e023bULL,
0x0000005146157211ULL, 0x000fe200078fe0ffULL, 0x000000020d0c7825ULL, 0x000fc800078e0054ULL,
0x00000001090b7824ULL, 0x142fe200078e0a38ULL, 0x000000380900720cULL, 0x080fe20003f26070ULL,
0x0000000139097824ULL, 0x040fe200078e0a38ULL, 0x000000060c487981ULL, 0x0002e2000c1e9500ULL,
0x000000383900720cULL, 0x000fe20003f06070ULL, 0x0000000107457824ULL, 0x000fe200078e023dULL,
0x0000000b060b7217ULL, 0x000fe20003800000ULL, 0x000000013d417824ULL, 0x000fe400078e0200ULL,
0x0000000215147825ULL, 0x000fe200078e0054ULL, 0x00000004ff0b7819ULL, 0x000fc4000001160bULL,
0x0000000906097217ULL, 0x040fe40003800000ULL, 0x000000ff0b0c7207ULL, 0x002fe20000800000ULL,
0x0000000145437824ULL, 0x000fe200078e0a38ULL, 0x000000ff093a7207ULL, 0x000fe20000000000ULL,
0x0000000614577981ULL, 0x0002e2000c1e9500ULL, 0x0000000c4f097210ULL, 0x000fe40007ffe0ffULL,
0x0000004306407217ULL, 0x000fc60003800000ULL, 0x0000000209087825ULL, 0x000fe200078e0054ULL,
0x000000384500720cULL, 0x080fe40003f26070ULL, 0x00000004ff407819ULL, 0x000fe40000011640ULL,
0x00000006083c7981ULL, 0x0004e2000c1e9500ULL, 0x000000384100720cULL, 0x040fe40003f06070ULL,
0x000000ff40447207ULL, 0x000fe20000800000ULL, 0x0000000141097824ULL, 0x004fe200078e0a38ULL,
0x0000003003457812ULL, 0x000fc800078efcffULL, 0x0000000906097217ULL, 0x000fe20003800000ULL,
0x000000010c0d7824ULL, 0x000fe200078e0251ULL, 0x0000004f3a0b7211ULL, 0x040fe400078fe0ffULL,
0x000000513a157211ULL, 0x002fe400078fe0ffULL, 0x000000ff09407207ULL, 0x000fe20000000000ULL,
0x000000014f097824ULL, 0x000fe400078e0244ULL, 0x0000000107537824ULL, 0x000fe400078e0245ULL,
0x000000020b0a7825ULL, 0x000fc800078e0054ULL, 0x000000020d0c7825ULL, 0x100fe200078e0054ULL,
0x00000053384b7210ULL, 0x000fe20007ffe1ffULL, 0x000000060a3f7981ULL, 0x0002a4000c1e9500ULL,
0x0000000215147825ULL, 0x100fe400078e0054ULL, 0x000000060c3e7981ULL, 0x0002a4000c1e9500ULL,
0x0000000209087825ULL, 0x000fe400078e0054ULL, 0x0000000614437981ULL, 0x0002a4000c1e9500ULL,
0x0000000145497824ULL, 0x000fe200078e0200ULL, 0x0000004b064a7217ULL, 0x000fe20003800000ULL,
0x0000000608427981ULL, 0x0002a4000c1e9500ULL, 0x0000004f400b7211ULL, 0x002fe200078fe0ffULL,
0x00000001440d7824ULL, 0x000fe200078e0251ULL, 0x000000385300720cULL, 0x000fc40003f26070ULL,
0x0000005140157211ULL, 0x000fe200078fe0ffULL, 0x0000000149097824ULL, 0x000fe200078e0a38ULL,
0x00000004ff4a7819ULL, 0x000fe2000001164aULL, 0x000000020b0a7825ULL, 0x100fe200078e0054ULL,
0x000000384900720cULL, 0x000fe40003f06070ULL, 0x0000000906097217ULL, 0x000fe20003800000ULL,
0x000000020d0c7825ULL, 0x100fe200078e0054ULL, 0x000000ff4a4e7207ULL, 0x000fe20000800000ULL,
0x000000060a477981ULL, 0x0002a4000c1e9500ULL, 0x0000000215147825ULL, 0x000fe200078e0054ULL,
0x000000ff094a7207ULL, 0x000fe20000000000ULL, 0x000000060c447981ULL, 0x0002a8000c1e9500ULL,
0x00000006144b7981ULL, 0x0002a2000c1e9500ULL, 0x000000014f097824ULL, 0x000fe200078e024eULL,
0x0000004f4a0b7211ULL, 0x002fc600078fe0ffULL, 0x0000000209087825ULL, 0x000fc800078e0054ULL,
0x000000020b0a7825ULL, 0x000fe400078e0054ULL, 0x0000000608087981ULL, 0x0002a2000c1e9500ULL,
0x000000514a0d7211ULL, 0x000fc600078fe0ffULL, 0x000000060a0b7981ULL, 0x0002a2000c1e9500ULL,
0x000000014e157824ULL, 0x000fe400078e0251ULL, 0x000000020d0c7825ULL, 0x000fc800078e0054ULL,
0x0000000215147825ULL, 0x000fe400078e0054ULL, 0x000000060c0c7981ULL, 0x0002a8000c1e9500ULL,
0x0000000614157981ULL, 0x0002a2000c1e9500ULL, 0xfffffff046517812ULL, 0x000fe200078ec0ffULL,
0x00000001ff467424ULL, 0x000fc800078e00ffULL, 0x00000001384e7824ULL, 0x000fc800078e0251ULL,
0x0000000137597824ULL, 0x000fe200078e0a4eULL, 0x00000001034f7812ULL, 0x040fe400078efcffULL,
0x0000000903097812ULL, 0x002fe400078efcffULL, 0x0000005946597219ULL, 0x000fe200000006ffULL,
0x000000014f537824ULL, 0x100fe400078e0200ULL, 0x00000001090d7824ULL, 0x000fe400078e0200ULL,
0x00000001535b7824ULL, 0x000fc400078e0a4eULL, 0x000000010d5f7824ULL, 0x000fe200078e0a4eULL,
0x00000018036f7812ULL, 0x000fe400078efcffULL, 0x0000005b465b7219ULL, 0x040fe400000006ffULL,
0x0000005f465f7219ULL, 0x000fe400000006ffULL, 0xfffffff03a3a7812ULL, 0x000fe200078ec0ffULL,
0x000000016f7d7824ULL, 0x000fe200078e0200ULL, 0x0000001103757812ULL, 0x040fe400078efcffULL,
0x00000019036b7812ULL, 0x000fc600078efcffULL, 0x00000001750a7824ULL, 0x100fe400078e0200ULL,
0x000000016b7b7824ULL, 0x000fe200078e0200ULL, 0x0000002103617812ULL, 0x000fe400078efcffULL,
0xfffffff04a4a7812ULL, 0x000fc600078ec0ffULL, 0x0000000161677824ULL, 0x000fe400078e0200ULL,
0x00000001384a7824ULL, 0x000fc800078e024aULL, 0x0000000149567824ULL, 0x000fca00078e0a4aULL,
0x0000005646567219ULL, 0x000fe400000006ffULL, 0x000054104d4c7816ULL, 0x010fe4000000004cULL,
0x00000008034d7812ULL, 0x000fe400078efcffULL, 0x0000004c59ff7212ULL, 0x000fe4000780c0ffULL,
0x000000004d517210ULL, 0x000fe40007ffe0ffULL, 0x000000383700720cULL, 0x000fc60000701470ULL,
0x00000001515d7824ULL, 0x000fe200078e0a4eULL, 0x000000380300720cULL, 0x000fc800007a1070ULL,
0x0000005d465d7219ULL, 0x000fe400000006ffULL, 0xff80000017177808ULL, 0x000fe40002800000ULL,
0x0000004c5bff7212ULL, 0x000fe4000782c0ffULL, 0x0000541057487816ULL, 0x008fc80000000048ULL,
0x0000004859ff7212ULL, 0x080fe4000784c0ffULL, 0x000000485bff7212ULL, 0x080fe4000780c0ffULL,
0x000000485dff7212ULL, 0x080fe400078cc0ffULL, 0x000000485fff7212ULL, 0x000fe400078ac0ffULL,
0xfffffff040487812ULL, 0x000fe200078ec0ffULL, 0x0000000138407824ULL, 0x000fe200078e023aULL,
0x0000004c5dff7212ULL, 0x000fc4000786c0ffULL, 0x0000004c5fff7212ULL, 0x000fe2000788c0ffULL,
0x00000001394c7824ULL, 0x000fe200078e0a40ULL, 0x000000383700720cULL, 0x080fe40001741470ULL,
0x000000385100720cULL, 0x080fe400037c1470ULL, 0x000000380d00720cULL, 0x080fe40002fa1470ULL,
0x0000007d40587210ULL, 0x000fe40007ffe1ffULL, 0x000000380300720cULL, 0x000fc40001741070ULL,
0x000000384d00720cULL, 0x080fe400037c1070ULL, 0x000000380900720cULL, 0x000fe40002fa1070ULL,
0x0000004c464c7219ULL, 0x040fe400000006ffULL, 0x0000005846587219ULL, 0x000fe200000006ffULL,
0x0000000138487824ULL, 0x000fe200078e0248ULL, 0xff80000022227808ULL, 0x000fe40001000000ULL,
0xff8000001b1b7808ULL, 0x000fc40003000000ULL, 0xff80000033337808ULL, 0x000fe40002800000ULL,
0x000054103f3f7816ULL, 0x004fc8000000003cULL, 0x0000003f4cff7212ULL, 0x000fe4000784c0ffULL,
0x0000541043437816ULL, 0x000fc8000000003eULL, 0x000000434cff7212ULL, 0x080fe400078cc0ffULL,
0x0000004358ff7212ULL, 0x000fe200078ac0ffULL, 0x000000010a527824ULL, 0x100fe200078e0a40ULL,
0x000000385300720cULL, 0x080fe20000f21470ULL, 0x000000017b627824ULL, 0x000fe200078e0a40ULL,
0x000000385300720cULL, 0x080fe20000701470ULL, 0x0000000141607824ULL, 0x000fe200078e0a48ULL,
0x000000385100720cULL, 0x080fe40001f61470ULL, 0x000000380d00720cULL, 0x000fc40002781470ULL,
0x000000383900720cULL, 0x0c0fe40001741470ULL, 0x000000383900720cULL, 0x080fe400037c1470ULL,
0x000000387d00720cULL, 0x080fe40002fa1470ULL, 0x00000028035f7812ULL, 0x040fe400078efcffULL,
0x00000029035d7812ULL, 0x000fe400078efcffULL, 0x000000384f00720cULL, 0x000fc40000f21070ULL,
0x000000384f00720cULL, 0x080fe40000701070ULL, 0x000000384d00720cULL, 0x080fe40001f61070ULL,
0x000000380900720cULL, 0x080fe40002781070ULL, 0x000000383b00720cULL, 0x0c0fe40001741070ULL,
0x000000383b00720cULL, 0x080fe400037c1070ULL, 0x000000386f00720cULL, 0x000fc40002fa1070ULL,
0x0000005246527219ULL, 0x040fe400000006ffULL, 0x0000006246627219ULL, 0x040fe400000006ffULL,
0x0000006046607219ULL, 0x000fe400000006ffULL, 0x0000541047477816ULL, 0x000fe40000000042ULL,
0x000054104b4b7816ULL, 0x000fe20000000044ULL, 0x000000015d637824ULL, 0x000fe200078e0200ULL,
0x000000005f657210ULL, 0x000fc40007ffe0ffULL, 0xff80000028287808ULL, 0x000fe40000800000ULL,
0xff8000001a1a7808ULL, 0x000fe40000000000ULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff80000032327808ULL, 0x000fe40002000000ULL, 0xff8000002f2f7808ULL, 0x000fe40001000000ULL,
0xff80000023237808ULL, 0x000fc40003000000ULL, 0xff80000024247808ULL, 0x000fe40002800000ULL,
0x0000003f52ff7212ULL, 0x080fe4000782c0ffULL, 0x0000003f58ff7212ULL, 0x080fe4000780c0ffULL,
0x0000003f62ff7212ULL, 0x000fe4000786c0ffULL, 0x0000004352ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004362ff7212ULL, 0x000fc4000784c0ffULL, 0x0000004760ff7212ULL, 0x040fe400078cc0ffULL,
0x0000004b60ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000167647824ULL, 0x100fe200078e0a48ULL,
0x000000380a00720cULL, 0x0c0fe20000f21470ULL, 0x00000001655a7824ULL, 0x100fe200078e0a48ULL,
0x000000380a00720cULL, 0x080fe20002781470ULL, 0x00000001635c7824ULL, 0x000fe200078e0a48ULL,
0x000000387d00720cULL, 0x080fe40000701470ULL, 0x000000387b00720cULL, 0x000fc40001f61470ULL,
0x000000387b00720cULL, 0x080fe40001741470ULL, 0x000000384100720cULL, 0x0c0fe400037c1470ULL,
0x000000384100720cULL, 0x000fe40002fa1470ULL, 0x0000003803597812ULL, 0x040fe400078efcffULL,
0x00000031035b7812ULL, 0x040fe400078efcffULL, 0x0000003903577812ULL, 0x000fc400078efcffULL,
0x000000387500720cULL, 0x0c0fe40000f21070ULL, 0x000000387500720cULL, 0x080fe40002781070ULL,
0x000000386f00720cULL, 0x080fe40000701070ULL, 0x000000386b00720cULL, 0x0c0fe40001f61070ULL,
0x000000386b00720cULL, 0x080fe40001741070ULL, 0x000000383d00720cULL, 0x000fc400037c1070ULL,
0x000000383d00720cULL, 0x000fe40002fa1070ULL, 0x0000006446647219ULL, 0x040fe400000006ffULL,
0x0000005a465a7219ULL, 0x040fe400000006ffULL, 0x0000005c465c7219ULL, 0x000fe400000006ffULL,
0x000054100b0b7816ULL, 0x000fe20000000008ULL, 0x00000001593a7824ULL, 0x100fe200078e0200ULL,
0xff8000002a2a7808ULL, 0x000fe20000800000ULL, 0x000000015b147824ULL, 0x100fe200078e0200ULL,
0xff80000021217808ULL, 0x000fe20002000000ULL, 0x0000000157407824ULL, 0x000fe200078e0200ULL,
0xff8000002b2b7808ULL, 0x000fc40000000000ULL, 0xff80000036367808ULL, 0x000fe40001800000ULL,
0xff80000035357808ULL, 0x000fe40001000000ULL, 0xff80000034347808ULL, 0x000fe40003000000ULL,
0xff80000025257808ULL, 0x000fe40002800000ULL, 0x0000004764ff7212ULL, 0x080fe4000782c0ffULL,
0x000000475aff7212ULL, 0x000fc4000788c0ffULL, 0x000000475cff7212ULL, 0x000fe4000780c0ffULL,
0x0000004b64ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004b5aff7212ULL, 0x080fe4000784c0ffULL,
0x0000004b5cff7212ULL, 0x000fe400078cc0ffULL, 0x0000000b56ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001144e7824ULL, 0x100fe200078e0a4aULL, 0x0000003a4a487210ULL, 0x000fe20007ffe1ffULL,
0x00000001404a7824ULL, 0x000fe200078e0a4aULL, 0x000000386700720cULL, 0x000fc40000f21470ULL,
0x000000386700720cULL, 0x080fe40001f61470ULL, 0x000000386500720cULL, 0x0c0fe40002781470ULL,
0x000000386500720cULL, 0x080fe40001741470ULL, 0x000000386300720cULL, 0x0c0fe40000701470ULL,
0x000000386300720cULL, 0x080fe400037c1470ULL, 0x000000384900720cULL, 0x000fc40002fa1470ULL,
0x000000386100720cULL, 0x0c0fe40000f21070ULL, 0x000000386100720cULL, 0x080fe40001f61070ULL,
0x000000385f00720cULL, 0x0c0fe40002781070ULL, 0x000000385f00720cULL, 0x080fe40001741070ULL,
0x000000385d00720cULL, 0x0c0fe40000701070ULL, 0x000000385d00720cULL, 0x000fc400037c1070ULL,
0x000000384500720cULL, 0x000fe40002fa1070ULL, 0x0000004e464e7219ULL, 0x040fe400000006ffULL,
0x0000004846487219ULL, 0x040fe400000006ffULL, 0x0000004a464a7219ULL, 0x000fe400000006ffULL,
0x000054100c157816ULL, 0x000fe40000000015ULL, 0xff8000002c2c7808ULL, 0x000fc40000800000ULL,
0xff80000016167808ULL, 0x000fe40001800000ULL, 0xff8000002d2d7808ULL, 0x000fe40002000000ULL,
0xff80000018187808ULL, 0x000fe40001000000ULL, 0xff80000031317808ULL, 0x000fe40000000000ULL,
0xff80000019197808ULL, 0x000fe40003000000ULL, 0xff80000030307808ULL, 0x000fc40002800000ULL,
0x0000000b4eff7212ULL, 0x080fe4000782c0ffULL, 0x0000000b48ff7212ULL, 0x080fe4000786c0ffULL,
0x0000000b4aff7212ULL, 0x000fe4000788c0ffULL, 0x0000001556ff7212ULL, 0x080fe4000784c0ffULL,
0x000000154eff7212ULL, 0x080fe4000780c0ffULL, 0x0000001548ff7212ULL, 0x000fc400078cc0ffULL,
0x000000154aff7212ULL, 0x000fe400078ac0ffULL, 0x000000384900720cULL, 0x080fe40001741470ULL,
0x000000381400720cULL, 0x0c0fe40000f21470ULL, 0x000000381400720cULL, 0x080fe40000701470ULL,
0x000000383a00720cULL, 0x0c0fe40001f61470ULL, 0x000000383a00720cULL, 0x000fc400037c1470ULL,
0x000000384000720cULL, 0x0c0fe40002781470ULL, 0x000000384000720cULL, 0x080fe40002fa1470ULL,
0x000000384500720cULL, 0x080fe40001741070ULL, 0x000000385b00720cULL, 0x0c0fe40000f21070ULL,
0x000000385b00720cULL, 0x080fe40000701070ULL, 0x000000385900720cULL, 0x000fc40001f61070ULL,
0x000000385900720cULL, 0x080fe400037c1070ULL, 0x000000385700720cULL, 0x0c0fe40002781070ULL,
0x000000385700720cULL, 0x000fe40002fa1070ULL, 0xff8000002e2e7808ULL, 0x000fe40000800000ULL,
0xff80000026267808ULL, 0x000fe40001800000ULL, 0xff80000027277808ULL, 0x000fc40002000000ULL,
0xff8000001c1c7808ULL, 0x000fe40001000000ULL, 0xff8000001d1d7808ULL, 0x000fe40000000000ULL,
0xff8000001e1e7808ULL, 0x000fe40003000000ULL, 0xff8000001f1f7808ULL, 0x000fc40002800000ULL,
0x000000171000720bULL, 0x004fe40003f1e000ULL, 0x000000221100720bULL, 0x000fe40003f3e000ULL,
0x0000001017037208ULL, 0x000fc40004000000ULL, 0x0000001122117208ULL, 0x000fe40004800000ULL,
0x000000280300720bULL, 0x000fe40003f1e000ULL, 0x0000001a1100720bULL, 0x000fe40003f3e000ULL,
0x0000000328087208ULL, 0x000fe40004000000ULL, 0x000000111a0a7208ULL, 0x000fe40004800000ULL,
0x000000290800720bULL, 0x000fc40003f1e000ULL, 0x0000001b0a00720bULL, 0x000fe40003f3e000ULL,
0x0000000829037208ULL, 0x000fe40004000000ULL, 0x0000000a1b0a7208ULL, 0x000fe40004800000ULL,
0x000000320300720bULL, 0x000fe40003f1e000ULL, 0x000000330a00720bULL, 0x000fe40003f3e000ULL,
0x0000000332087208ULL, 0x000fc40004000000ULL, 0x0000000a330a7208ULL, 0x000fe40004800000ULL,
0x0000002f0800720bULL, 0x000fe40003f1e000ULL, 0x000000230a00720bULL, 0x000fe40003f3e000ULL,
0x000000082f037208ULL, 0x000fe40004000000ULL, 0x0000000a230a7208ULL, 0x000fe40004800000ULL,
0x0000002a0300720bULL, 0x000fc40003f1e000ULL, 0x000000210a00720bULL, 0x000fe40003f3e000ULL,
0x000000032a087208ULL, 0x000fe40004000000ULL, 0x0000000a21037208ULL, 0x000fe40004800000ULL,
0x0000002b0800720bULL, 0x000fe40003f1e000ULL, 0x000000240300720bULL, 0x000fe40003f3e000ULL,
0x000000082b097208ULL, 0x000fc40004000000ULL, 0x0000000324087208ULL, 0x000fe40004800000ULL,
0x000000360900720bULL, 0x000fe40003f1e000ULL, 0x000000350800720bULL, 0x000fe40003f3e000ULL,
0x0000000936097208ULL, 0x000fe40004000000ULL, 0x0000000835087208ULL, 0x000fe40004800000ULL,
0x000000340900720bULL, 0x000fc40003f1e000ULL, 0x000000250800720bULL, 0x000fe40003f3e000ULL,
0x0000000934097208ULL, 0x000fe40004000000ULL, 0x0000000825037208ULL, 0x000fe40004800000ULL,
0x0000002c0900720bULL, 0x000fe40003f1e000ULL, 0x000000160300720bULL, 0x000fe40003f3e000ULL,
0x000000092c087208ULL, 0x000fc40004000000ULL, 0x0000000316037208ULL, 0x000fe40004800000ULL,
0x0000002d0800720bULL, 0x000fe40003f1e000ULL, 0x000000180300720bULL, 0x000fe40003f3e000ULL,
0x000000082d087208ULL, 0x000fe40004000000ULL, 0x00000003180a7208ULL, 0x000fe40004800000ULL,
0x000000310800720bULL, 0x000fc40003f1e000ULL, 0x000000190a00720bULL, 0x000fe40003f3e000ULL,
0x0000000831037208ULL, 0x000fe40004000000ULL, 0x0000000a19097208ULL, 0x000fe40004800000ULL,
0x000000300300720bULL, 0x000fe40003f1e000ULL, 0x0000001c0900720bULL, 0x000fe40003f3e000ULL,
0x0000000330037208ULL, 0x000fc40004000000ULL, 0x000000091c087208ULL, 0x000fe40004800000ULL,
0x0000002e0300720bULL, 0x000fe40003f1e000ULL, 0x0000001d0800720bULL, 0x000fe40003f3e000ULL,
0x000000032e037208ULL, 0x000fe40004000000ULL, 0x000000081d097208ULL, 0x000fe40004800000ULL,
0x000000260300720bULL, 0x000fc40003f1e000ULL, 0x0000001e0900720bULL, 0x000fe40003f3e000ULL,
0x0000000326087208ULL, 0x000fe40004000000ULL, 0x000000091e0a7208ULL, 0x000fe40004800000ULL,
0x000000270800720bULL, 0x000fe40003f1e000ULL, 0x0000001f0a00720bULL, 0x000fe40003f3e000ULL,
0x0000000827107208ULL, 0x000fc40004000000ULL, 0x0000000a1f147208ULL, 0x000fe20004800000ULL,
0x000016a27f007947ULL, 0x000fec000b800000ULL, 0x0c401f0010037f89ULL, 0x0004e400000e0000ULL,
0x000000031000720bULL, 0x00cfc80003f1e000ULL, 0x0000001003387208ULL, 0x000fe20004000000ULL,
0x000016c27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0014037f89ULL, 0x000ea800000e0000ULL,
0x0c401f0012097f89ULL, 0x000ee800000e0000ULL, 0x0c401f0013087f89ULL, 0x000f2200000e0000ULL,
0x000000031400720bULL, 0x004fc40003f1e000ULL, 0x000000091200720bULL, 0x008fe40003f3e000ULL,
0x0000001403037208ULL, 0x000fe40004000000ULL, 0x00000012090d7208ULL, 0x000fe40004800000ULL,
0x0c201f0038097f89ULL, 0x000ea200000e0000ULL, 0x000000081300720bULL, 0x010fc60003f1e000ULL,
0x0c201f00030a7f89ULL, 0x000ee200000e0000ULL, 0x00000013080b7208ULL, 0x000fc60004000000ULL,
0x0c201f000d107f89ULL, 0x002e6800000e0000ULL, 0x0c201f000b0c7f89ULL, 0x00026200000e0000ULL,
0x000000093800720bULL, 0x004fe40003f1e000ULL, 0x0000000a0300720bULL, 0x008fe40003f3e000ULL,
0x0000003809087208ULL, 0x000fe40004000000ULL, 0x000000100d00720bULL, 0x002fc40003f5e000ULL,
0x000000030a097208ULL, 0x000fe40004800000ULL, 0x0000000d100a7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b08117820ULL, 0x002fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000305ff7812ULL, 0x000fe4000780c0ffULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010811ULL,
0x0000000c0b00720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b29297823ULL, 0x100fe40000010811ULL,
0x0000002800137308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b2a037823ULL, 0x100fe20000010811ULL,
0x0000000b0c0b7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b17177823ULL, 0x000fc40000010811ULL,
0x3fb8aa3b32327823ULL, 0x100fe40000010811ULL, 0x3fb8aa3b2c2a7823ULL, 0x100fe20000010811ULL,
0x0000002900127308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b2e287823ULL, 0x102fe40000010811ULL,
0x3fb8aa3b092e7820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b2f2f7823ULL, 0x000fe40000010811ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082eULL, 0x0000000300387308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b1b1b7823ULL, 0x000fc4000001082eULL, 0x3fb8aa3b22227823ULL, 0x100fe4000001082eULL,
0x3fb8aa3b33337823ULL, 0x000fe4000001082eULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010811ULL,
0x0000001700107308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b36367823ULL, 0x100fe40000010811ULL,
0x3fb8aa3b340d7823ULL, 0x100fe40000010811ULL, 0x3fb8aa3b2d297823ULL, 0x004fc40000010811ULL,
0x3fb8aa3b312c7823ULL, 0x100fe20000010811ULL, 0x0000003200157308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b30037823ULL, 0x102fe40000010811ULL, 0x3fb8aa3b26267823ULL, 0x100fe40000010811ULL,
0x3fb8aa3b27277823ULL, 0x000fe40000010811ULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001082eULL,
0x0000002200117308ULL, 0x0003e20000000800ULL, 0x000000101310723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b21217823ULL, 0x000fc4000001082eULL, 0x3fb8aa3b24247823ULL, 0x100fe4000001082eULL,
0x3fb8aa3b35357823ULL, 0x100fe4000001082eULL, 0x0000001a001a7308ULL, 0x000ee20000000800ULL,
0x000000121512723eULL, 0x004fe200000000ffULL, 0x3c003c00ff227424ULL, 0x002fe400078e00ffULL,
0x3fb8aa3b18317823ULL, 0x100fe4000001082eULL, 0x3fb8aa3b25257823ULL, 0x000fc4000001082eULL,
0x0000001b001b7308ULL, 0x000ff00000000800ULL, 0x0000003300147308ULL, 0x0002a20000000800ULL,
0x000000111a11723eULL, 0x008fce00000000ffULL, 0x00000023002d7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b19337823ULL, 0x002fe2000001082eULL, 0x0000001b1413723eULL, 0x004fe200000000ffULL,
0x3c003c00ff237424ULL, 0x008fca00078e00ffULL, 0x0000002100307308ULL, 0x0002b00000000800ULL,
0x0000002f002f7308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b16217823ULL, 0x102fe4000001082eULL,
0x000000221014723cULL, 0x000f6a00000018ffULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x0000002d3019723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b1f2d7823ULL, 0x000fcc000001082eULL,
0x0000003600367308ULL, 0x000e620000000800ULL, 0x0000002f3818723eULL, 0x008fe400000000ffULL,
0x00000002ff2f7819ULL, 0x000fc80000011605ULL, 0x000000012f307810ULL, 0x040fe20007ffe0ffULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x000000082f3a7824ULL, 0x040fe400078e00ffULL,
0x000000082f3c7824ULL, 0x000fca00078e00ffULL, 0x0000003500357308ULL, 0x000ea20000000800ULL,
0x0000002b361a723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b1e2b7823ULL, 0x000fe4000001082eULL,
0x000000082f367824ULL, 0x000fc800078e00ffULL, 0x0000002100327308ULL, 0x0003e20000000800ULL,
0x00000024351b723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b1c217823ULL, 0x002fcc000001082eULL,
0x0000000d000d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1d247823ULL, 0x000fe2000001082eULL,
0x000000032f357819ULL, 0x000fe200000006ffULL, 0x00000022181c723cULL, 0x020b660000001814ULL,
0xfffffff835307812ULL, 0x000fe400078ee230ULL, 0x0000002a002a7308ULL, 0x000e640000000800ULL,
0x000000082f177824ULL, 0x060fe200078e00ffULL, 0x000000032f147810ULL, 0x000fc40007ffe0ffULL,
0x000000042f157810ULL, 0x000fc60007ffe0ffULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0xfffffff817387812ULL, 0x000fe400078ee214ULL, 0xfffffff83a3a7812ULL, 0x000fca00078ee215ULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x0000000d2a14723eULL, 0x002fe400000000ffULL,
0x000000052f0d7810ULL, 0x000fca0007ffe0ffULL, 0x0000002500257308ULL, 0x000e700000000800ULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x000000292c16723eULL, 0x004fe200000000ffULL,
0x000000082f2c7824ULL, 0x040fe200078e00ffULL, 0x000000082f297810ULL, 0x000fc80007ffe0ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee22fULL, 0x0000003300347308ULL, 0x0004e20000000800ULL,
0x000000253215723eULL, 0x002fe200000000ffULL, 0x000000082f327824ULL, 0x040fe200078e00ffULL,
0xffffffff2f257810ULL, 0x000fe20007ffe0ffULL, 0x00000008293e7824ULL, 0x000fc600078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee225ULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x000000022f337810ULL, 0x044fe40007ffe0ffULL, 0xfffffff832327812ULL, 0x000fe400078ee20dULL,
0xfffffff836367812ULL, 0x000fe400078ee233ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee229ULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x000000313417723eULL, 0x008fe200000000ffULL,
0x000000082f317824ULL, 0x000fcc00078e00ffULL, 0x00000022141c723cULL, 0x000f62000000181cULL,
0x0000000300037308ULL, 0x000fe20000000800ULL, 0x000000262726723eULL, 0x002fce00000000ffULL,
0x0000002800287308ULL, 0x000e700000000800ULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x00000024002e7308ULL, 0x0004f00000000800ULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x000000062f247810ULL, 0x004fc80007ffe0ffULL, 0xfffffff831347812ULL, 0x000fe400078ee224ULL,
0x000000032824723eULL, 0x002fe200000000ffULL, 0x0000002d002a7308ULL, 0x000e620000000800ULL,
0x000000212e25723eULL, 0x008fe400000000ffULL, 0x0001100002037811ULL, 0x000fe400078e58ffULL,
0x0000000c202e7812ULL, 0x000fe400078ec0ffULL, 0x000000032c0d7211ULL, 0x000fe200078e20ffULL,
0x0000001030207824ULL, 0x000fc400078e0203ULL, 0x0000001036217824ULL, 0x100fe400078e0203ULL,
0x0000001038287824ULL, 0x100fe400078e0203ULL, 0x000000103a297824ULL, 0x000fe200078e0203ULL,
0x0000002b2a27723eULL, 0x002fe200000000ffULL, 0x000000012e0d7824ULL, 0x000fe400078e020dULL,
0x00000010322a7824ULL, 0x100fe400078e0203ULL, 0x000000012e207824ULL, 0x000fe200078e0220ULL,
0x000000100d007388ULL, 0x0003e20000000800ULL, 0x00000022241c723cULL, 0x020b62000000181cULL,
0x00000010342b7824ULL, 0x000fc400078e0203ULL, 0x000000103c2c7824ULL, 0x000fe200078e0203ULL,
0x000000033e037211ULL, 0x000fe200078e20ffULL, 0x000000012e217824ULL, 0x040fe200078e0221ULL,
0x0000001220007388ULL, 0x0003e20000000800ULL, 0x000000012e287824ULL, 0x040fe400078e0228ULL,
0x000000012e297824ULL, 0x040fe200078e0229ULL, 0x0000001821007388ULL, 0x0003e20000000800ULL,
0x000000012e2a7824ULL, 0x040fe400078e022aULL, 0x000000012e2b7824ULL, 0x040fe200078e022bULL,
0x0000001a28007388ULL, 0x0003e20000000800ULL, 0x000000012e2c7824ULL, 0x000fc400078e022cULL,
0x000000012e227824ULL, 0x020fe200078e0203ULL, 0x0000001429007388ULL, 0x0003e80000000800ULL,
0x000000162a007388ULL, 0x0003e40000000800ULL, 0x0000001e001d7202ULL, 0x000fe40000000f00ULL,
0x000000242b007388ULL, 0x0003e80000000800ULL, 0x000000262c007388ULL, 0x0003e80000000800ULL,
0x0000001122007388ULL, 0x0003e80000000800ULL, 0x0004001320007388ULL, 0x0003e80000000800ULL,
0x0004001921007388ULL, 0x0003e80000000800ULL, 0x0004001b28007388ULL, 0x0003e80000000800ULL,
0x0004001529007388ULL, 0x0003e80000000800ULL, 0x000400172a007388ULL, 0x0003e80000000800ULL,
0x000400252b007388ULL, 0x0003e80000000800ULL, 0x000400272c007388ULL, 0x0003e80000000800ULL,
0x01b000080e008388ULL, 0x0003e80000000c00ULL, 0x01b2001c0e008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6080074ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6100074ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6180074ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000005e5000720cULL, 0x000fe20003f06070ULL,
0x01b6200074ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff037224ULL, 0x000fd600078e0050ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff969000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff097807ULL, 0x002fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00014c10000e7802ULL, 0x000fc40000000f00ULL,
0x00000f2000007944ULL, 0x018fea0003c00000ULL, 0xfffee14000007947ULL, 0x000fea000383ffffULL,
0x00000001ff097807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014c60000e7802ULL, 0x000fc40000000f00ULL, 0x00000ed000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0009ULL, 0xfffee18000007947ULL, 0x000fea000383ffffULL,
0x0000000c000e7202ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x00014cd0000f7802ULL, 0x000fe20000000f00ULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000e1000007944ULL, 0x018fea0003c00000ULL, 0xfffee24000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x00014d30000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000db000007944ULL, 0x01afea0003c00000ULL, 0xfffee34000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0x00014da0000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fe400078e000dULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x00000d4000007944ULL, 0x010fea0003c00000ULL,
0x0000000900047202ULL, 0x004fe20000000f00ULL, 0xfffee4c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0x00014e10000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000cd000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xfffee48000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x008fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00014e70000e7802ULL, 0x000fc40000000f00ULL,
0x00000cc000007944ULL, 0x002fea0003c00000ULL, 0xfffefb5000007947ULL, 0x000fea000383ffffULL,
0x00000001ff097807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014ec0000e7802ULL, 0x000fc40000000f00ULL, 0x00000c7000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff327224ULL, 0x000fe200078e0009ULL, 0xfffefb8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0036ULL, 0x00014f30000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000bb000007944ULL, 0x000fea0003c00000ULL, 0xfffefc5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0036ULL, 0x0000001f00357802ULL, 0x000fe20000000f00ULL,
0xffffffffff347424ULL, 0x000fe200078e00ffULL, 0x00014f90000f7802ULL, 0x000fc40000000f00ULL,
0x00000b5000007944ULL, 0x002fea0003c00000ULL, 0xfffefd5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x00015000000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fe400078e0031ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x00000ae000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0009ULL, 0xfffefee000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x00015070000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000a7000007944ULL, 0x006fea0003c00000ULL, 0x0000000900067202ULL, 0x004fe20000000f00ULL,
0xfffefea000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x004fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x000150d0000e7802ULL, 0x000fc40000000f00ULL,
0x00000a6000007944ULL, 0x018fea0003c00000ULL, 0xffff132000007947ULL, 0x000fea000383ffffULL,
0x00000001ff097807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00015120000e7802ULL, 0x000fc40000000f00ULL, 0x00000a1000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0009ULL, 0xffff135000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0026ULL, 0x0000001f00357802ULL, 0x000fe20000000f00ULL,
0xffffffffff347424ULL, 0x000fe200078e00ffULL, 0x00015190000f7802ULL, 0x000fc40000000f00ULL,
0x0000095000007944ULL, 0x018fea0003c00000ULL, 0xffff142000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0026ULL, 0x000151f0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x000008f000007944ULL, 0x01afea0003c00000ULL, 0xffff152000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x00015260000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fe400078e000dULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000088000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0009ULL, 0xffff16b000007947ULL, 0x000fea000383ffffULL,
0x0000000c000e7202ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x000152d0000f7802ULL, 0x000fe20000000f00ULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000081000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xffff167000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x008fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00015330000e7802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x032fea0003c00000ULL, 0xffff2b0000007947ULL, 0x000fea000383ffffULL,
0x00000001ff097807ULL, 0x000fe40004800000ULL, 0xffffffff000f7802ULL, 0x000fc40000000f00ULL,
0x00015380000e7802ULL, 0x000fc40000000f00ULL, 0x000007b000007944ULL, 0x032fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0009ULL, 0xffff2b4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e001eULL, 0x000153f0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x000006f000007944ULL, 0x030fea0003c00000ULL, 0xffff2c1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e001eULL, 0x00015450000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000069000007944ULL, 0x032fea0003c00000ULL, 0xffff2d1000007947ULL, 0x000fea000383ffffULL,
0x00000008000e7202ULL, 0x000fe20000000f00ULL, 0x000000ffff097224ULL, 0x000fe200078e000dULL,
0x000154c0000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000062000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0009ULL, 0xffff2ea000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0008ULL, 0x00015530000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x000005b000007944ULL, 0x036fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xffff2e6000007947ULL, 0x000fea000383ffffULL, 0x00000002ff117424ULL, 0x000fe200078e00ffULL,
0x000155a0000c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff037424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000050000007944ULL, 0x002fea0003c00000ULL,
0xffffe91000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x002fe200078e0014ULL,
0x00015610000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff117424ULL, 0x000fc400078e00ffULL,
0x0000001fff037424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x000000031400720bULL, 0x004fe20003f1e000ULL,
0x00000002ff117424ULL, 0x002fe200078e00ffULL, 0x0000001200107202ULL, 0x000fe20000000f00ULL,
0xffffffffff3a7424ULL, 0x000fe200078e00ffULL, 0x00000014030a7208ULL, 0x000fe20004000000ULL,
0x0000001fff037424ULL, 0x000fe200078e00ffULL, 0x00015690000c7802ULL, 0x000fc40000000f00ULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x000000031200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e0013ULL, 0x00015710000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff117424ULL, 0x000fe200078e00ffULL, 0x0000001203127208ULL, 0x000fe20004000000ULL,
0x0000001fff037424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x000000031300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e0038ULL, 0x0000000100117802ULL, 0x000fe20000000f00ULL,
0xffffffffff3a7424ULL, 0x000fe200078e00ffULL, 0x00000013030b7208ULL, 0x000fe20004000000ULL,
0x0000001fff037424ULL, 0x000fe200078e00ffULL, 0x00015790000c7802ULL, 0x000fc40000000f00ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000033800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e000aULL, 0x00015810000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x0000003803087208ULL, 0x000fe20004000000ULL,
0x0000001fff037424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0000029000007944ULL, 0x000fea0003c00000ULL, 0x000000030a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e0012ULL, 0x00015890000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x0000000a03097208ULL, 0x000fe20004000000ULL,
0xffffffffff3a7424ULL, 0x000fe200078e00ffULL, 0x0000001f00037802ULL, 0x000fc40000000f00ULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000031200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e000bULL, 0x00015910000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x00000012030a7208ULL, 0x000fe20004000000ULL,
0x0000001fff037424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0003ULL,
0xffffe6f000007947ULL, 0x000fea000383ffffULL, 0x0180000007007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000700008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000005ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000005ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000007057812ULL, 0x000fd600078ec0ffULL, 0x0080000005000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffea56008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000003a00007348ULL, 0x000fe80003800000ULL,
0x0c00001110037389ULL, 0x0002a200000e0003ULL, 0xfffea5200c007950ULL, 0x000fea0003c3ffffULL,
0x0000003400007348ULL, 0x000fe80003800000ULL, 0x000000090e097389ULL, 0x0002a400000e0035ULL,
0x000000ffff0e7224ULL, 0x002fc400078e000fULL, 0x00000000ff0f7424ULL, 0x000fc800078e00ffULL,
0xfffea4d00e007950ULL, 0x000fea0003c3ffffULL, 0x000000010900780cULL, 0x000fe20003f25070ULL,
0x0000000f00007348ULL, 0x000fd80003800000ULL, 0x0000000000097806ULL, 0x000fc800048e0100ULL,
0x0000000f09097212ULL, 0x000fe200078ec0ffULL, 0x00000000ff0f7424ULL, 0x000fc800078e00ffULL,
0xfffea4700e007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000050aULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000668ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008c0ULL,
0x00000000000002e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ba0ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c60ULL,
0x00000000000005d0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001230ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001240ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012d0ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012d4ULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001500ULL,
0x0000000000015c80ULL, 0x8000001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000017180ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x00000000000171c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000017540ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000012d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000015eb0ULL,
0x0000000000015eb0ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000017180ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000017540ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_0_m_16_sm_80_cubin_len = 95776;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
