/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000010270ULL, 0x000000000000fdf0ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x000000000000ece0ULL, 0x00000000000002a0ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x000000000000ef80ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000ece000000000ULL, 0x00006c0400000000ULL, 0x0400288080810c00ULL, 0x0000000000003ac0ULL,
0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8016288080870828ULL, 0x0000000310288082ULL,
0x8087920000000000ULL, 0x0000000022002880ULL, 0x00000034ffffffffULL, 0x0000006800000000ULL,
0x0000ece000000000ULL, 0x000002a000000000ULL, 0x00002c0400000000ULL, 0x8084288080840900ULL,
0x090000003c042880ULL, 0x2880808428808087ULL, 0x0000000e00082f04ULL, 0x0008120400000080ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL,
0x0000000e00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL, 0x0000007c00043704ULL,
0x00000000000c1704ULL, 0x0021f00000480007ULL, 0x00000000000c1704ULL, 0x0021f00000400006ULL,
0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL,
0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00801b0380005003ULL, 0x0000e17000103104ULL, 0x0000e1900000e180ULL, 0x00f429040000e1a0ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500002205000019ULL, 0x0500001905000022ULL,
0x0500001905000019ULL, 0x0500001305000013ULL, 0x0500001305000013ULL, 0x0500001305000013ULL,
0x0500001305000013ULL, 0x0500001305000013ULL, 0x00f4280405000013ULL, 0x00000100000000f0ULL,
0x00002210000014e0ULL, 0x00002350000022e0ULL, 0x000027e000002380ULL, 0x00002bf000002810ULL,
0x00003470000033c0ULL, 0x00003510000034e0ULL, 0x0000391000003860ULL, 0x000042b000003b40ULL,
0x000043c000004350ULL, 0x0000473000004400ULL, 0x000049f000004780ULL, 0x0000520000005150ULL,
0x000052b000005270ULL, 0x000055f0000055e0ULL, 0x0000597000005960ULL, 0x00007b1000007ae0ULL,
0x0000816000008140ULL, 0x0000dab00000daa0ULL, 0x0000dad00000dac0ULL, 0x0000db200000db00ULL,
0x0000db500000db40ULL, 0x0000e1800000e160ULL, 0x0000e1d00000e190ULL, 0x0000e1f00000e1e0ULL,
0x0000e8800000e7f0ULL, 0x0000e9400000e8e0ULL, 0x0000ea100000e9b0ULL, 0x0000ead00000ea70ULL,
0x0000ec000000eb60ULL, 0x01f039040000eca0ULL, 0x000000ff00000200ULL, 0x000401000001b600ULL,
0x00000007000002e0ULL, 0x003f01000001b608ULL, 0x00000007000003f0ULL, 0x003f01000001b688ULL,
0x000000ff00000660ULL, 0x000901070001b600ULL, 0x0000000200000760ULL, 0x000901010001b688ULL,
0x0000006200002120ULL, 0x003f01010001b608ULL, 0x0000005400002190ULL, 0x003f01090001b608ULL,
0x0000005f00002ab0ULL, 0x000901010001b688ULL, 0x00000062000032f0ULL, 0x003f01010001b628ULL,
0x0000005400003340ULL, 0x003f01090001b628ULL, 0x0000005f00003a40ULL, 0x000901010001b690ULL,
0x00000062000041a0ULL, 0x003f01010001b648ULL, 0x0000000f00004230ULL, 0x003f01090001b648ULL,
0x0000005f000048a0ULL, 0x000901010001b698ULL, 0x0000006200005090ULL, 0x003f01010001b668ULL,
0x00000062000050e0ULL, 0x003f01090001b668ULL, 0x0000005f00005660ULL, 0x000901010001b6a0ULL,
0x000000ff00008a60ULL, 0x000901010001b600ULL, 0x000000ff0000a090ULL, 0x000901090001b600ULL,
0x0000007b0000d100ULL, 0x003f01010001b688ULL, 0x0000007b0000d150ULL, 0x003f01090001b688ULL,
0x000000770000e4e0ULL, 0x003f01010001b608ULL, 0x000000770000e4f0ULL, 0x003f01010001b610ULL,
0x000000770000e500ULL, 0x003f01010001b618ULL, 0x000000770000e510ULL, 0x003f01010001b620ULL,
0x000000540000e540ULL, 0x003f01090001b608ULL, 0x000000540000e5a0ULL, 0x003f01090001b628ULL,
0x0000000f0000e600ULL, 0x003f01090001b648ULL, 0x000000620000e660ULL, 0x003f01090001b668ULL,
0x000000050000e6d0ULL, 0x003f01090001b600ULL, 0x0000007b0000e730ULL, 0x003f01090001b688ULL,
0x00141c0400033803ULL, 0x000089d000008780ULL, 0x0000a1200000a0c0ULL, 0x000c05040000e530ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0050190300000000ULL, 0x0000000f00080a04ULL,
0x0004360400500210ULL, 0x0000000000000008ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL,
0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000000ULL,
0x00000000000000ccULL, 0x0000000e00000002ULL, 0x000000000000ece0ULL, 0x0000000000000044ULL,
0x0000000e00000002ULL, 0x0000000000000000ULL, 0x00000000000000a5ULL, 0x0000000e00000002ULL,
0x0000000000000000ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000077919ULL, 0x000eae0000002100ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x0000040000047802ULL, 0x000fe20000000f00ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x0000000000057919ULL, 0x000f220000002300ULL,
0x0000000000007919ULL, 0x000f680000002200ULL, 0x00008400ff0a7b82ULL, 0x000f620000000800ULL,
0x0000000000097919ULL, 0x000f620000008800ULL, 0x0000000000757919ULL, 0x000f6c0000002700ULL,
0x00008800ff027b82ULL, 0x000f620000000a00ULL, 0x00000000007a7919ULL, 0x000f6e0000000000ULL,
0x00000000000879c3ULL, 0x000f620000002600ULL, 0x00000004ff5c7e24ULL, 0x008fe2000f8e00ffULL,
0x00000005ff4d7819ULL, 0x004fe20000011607ULL, 0x00001fff05067589ULL, 0x010fea00000e0000ULL,
0x00001fff4d4d7589ULL, 0x000ea200000e0000ULL, 0x0000000105007824ULL, 0x020fe200078e0200ULL,
0x0000065409097816ULL, 0x002fc60000000004ULL, 0x0000008000047824ULL, 0x000fe200078e0207ULL,
0x000000030a007819ULL, 0x000fe400000006ffULL, 0x00000000090972caULL, 0x000fe400000e0000ULL,
0x000000ff0400720cULL, 0x040fe40003f05270ULL, 0x0000000f0400780cULL, 0x040fe40003f24070ULL,
0x000000030400780cULL, 0x000fe20003f44070ULL, 0x0000000406057824ULL, 0x004fd000078e024dULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01b60006043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404077c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000070612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x01b60804063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000404077c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x004fca0000000000ULL,
0x00000000070612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x01b68804063f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000007f0400780cULL, 0x000fe20003f04070ULL,
0x0000000308047899ULL, 0x002fe2000800063fULL, 0x0000000105057819ULL, 0x000fe200000006ffULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x00000004ff077819ULL, 0x000fe2000001167aULL,
0x00008c00ff5e7b82ULL, 0x000e620000000a00ULL, 0x0000000805087848ULL, 0x040fe20007fe0000ULL,
0x0000000400007e24ULL, 0x000fe2000f8e0275ULL, 0x0001b60009047890ULL, 0x000fe2000fffe03fULL,
0x0000000105097824ULL, 0x000fe400078e0207ULL, 0x0000000108087824ULL, 0x000fc400078e0a05ULL,
0x0000000904048c11ULL, 0x000fe2000f8e10ffULL, 0xff317217ff0b8424ULL, 0x000fe200078e00ffULL,
0x0000000900057210ULL, 0x000fe20007ffe0ffULL, 0x000000107a007824ULL, 0x000fe200078e00ffULL,
0x000000080700720cULL, 0x000fe40003f26070ULL, 0x01b4000b04008388ULL, 0x0007e20000000800ULL,
0x0000010005027825ULL, 0x000fe200078e0002ULL, 0x0000000709057812ULL, 0x000fe400078ec0ffULL,
0x000000f000077812ULL, 0x000fc400078ec0ffULL, 0x0000000f05087812ULL, 0x000fe200078e787aULL,
0x0000000000007b1dULL, 0x004fe20000010000ULL, 0x0000000702027210ULL, 0x000fe40007f5e0ffULL,
0x0000000809087211ULL, 0x000fe200078e20ffULL, 0x00000004755e7825ULL, 0x002fc600078e005eULL,
0x0000000908057c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff037224ULL, 0x000fca00010e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0007e2000c901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffffff79a7ULL, 0x000fe40008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000065e5e7981ULL, 0x000ea2000c1e1900ULL, 0x00000300ff517b82ULL, 0x000e620000000800ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x000000ff5e787836ULL, 0x004fca0000000000ULL,
0x00000008ff787819ULL, 0x000fce0000011678ULL, 0x0000008000b88947ULL, 0x002fea0003800000ULL,
0x000000015c037836ULL, 0x008fe20000000000ULL, 0x000000034d027819ULL, 0x000fe200000006ffULL,
0x00000004ff007424ULL, 0x000fe200078e00ffULL, 0x00000001ff747819ULL, 0x000fe2000001164dULL,
0x0000000275757824ULL, 0x000fe200078e00ffULL, 0x000000780300720cULL, 0x000fe20003f06070ULL,
0x01b6880002ff79a7ULL, 0x0003e20008500009ULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x000000014d797812ULL, 0x000fe200078ec0ffULL, 0x0000002074027824ULL, 0x002fe200078e00ffULL,
0x000000080a007c10ULL, 0x000fc8000fffe0ffULL, 0x000000025c057211ULL, 0x000fe200078e40ffULL,
0x0000000a75757224ULL, 0x000fc800078e0200ULL, 0x00000004750a7c24ULL, 0x000fe2000f8e0205ULL,
0x0000000400708947ULL, 0x000fec0003800000ULL, 0x00008a00ff027b82ULL, 0x000e620000000a00ULL,
0x000000055e007248ULL, 0x000fe20007fe0000ULL, 0x000000ffff057224ULL, 0x000fe200078e0a05ULL,
0x0000000974047c11ULL, 0x000fe2000f8e70ffULL, 0x0000000879117824ULL, 0x040fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fe4000001167aULL, 0x0000002000007446ULL, 0x000fe40003800005ULL,
0x0000000479047211ULL, 0x000fe200078e68ffULL, 0x000000010a057824ULL, 0x000fe200078e0207ULL,
0x0000000707097812ULL, 0x000fe200078e487aULL, 0x00000004070b7836ULL, 0x040fe20000000000ULL,
0x000000000700720cULL, 0x040fe20003f06070ULL, 0x0001300004067836ULL, 0x000fe20000000000ULL,
0xfffffff811117812ULL, 0x000fe200078ee27aULL, 0x00000008070d7836ULL, 0x040fe20000000000ULL,
0x0ffffff809097812ULL, 0x000fe200078ef87aULL, 0x0000001007137836ULL, 0x040fe20000000000ULL,
0x0000000c070f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001407157836ULL, 0x000fe20000000000ULL,
0x0000000609097211ULL, 0x000fe200078e20ffULL, 0x0000001c071d7836ULL, 0x000fe20000000000ULL,
0x0000001807197810ULL, 0x000fe20007ffe0ffULL, 0x0000010005047825ULL, 0x002fe200078e0002ULL,
0x000000030d0c7819ULL, 0x000fc400000006ffULL, 0x0000007a0f087212ULL, 0x000fe200078e3cffULL,
0x000000080b077824ULL, 0x000fe200078e00ffULL, 0x000000000d00720cULL, 0x080fe20003f26070ULL,
0x0000001011047825ULL, 0x000fe200078e0004ULL, 0x000000000f00720cULL, 0x080fe40003f46070ULL,
0x000000001300720cULL, 0x080fe20003f66070ULL, 0x000000080f177824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e2000c101c46ULL,
0x000000000b00720cULL, 0x080fe20003f06070ULL, 0x000000010a1b7824ULL, 0x040fe200078e0215ULL,
0x000000001500720cULL, 0x080fe20003f86070ULL, 0x000000010a0f7824ULL, 0x040fe200078e020fULL,
0x000000001900720cULL, 0x080fe20003fa6070ULL, 0x000000010a237824ULL, 0x000fe200078e021dULL,
0x000000001d00720cULL, 0x000fe20003fc6070ULL, 0x0000000819217824ULL, 0x000fe200078e00ffULL,
0x0000007a13007212ULL, 0x000fc400078e3cffULL, 0x000000190a1f7210ULL, 0x000fe40007ffe0ffULL,
0x0000007a0b047212ULL, 0x082fe400078e3cffULL, 0x0000007a0d057212ULL, 0x080fe400078e3cffULL,
0xfffffff807077812ULL, 0x000fe400078ee204ULL, 0xfffffff80c097812ULL, 0x000fe200078ee205ULL,
0x000000010a057824ULL, 0x040fe200078e020bULL, 0x0000007a15047212ULL, 0x040fe200078e3cffULL,
0x000000010a0b7824ULL, 0x000fe200078e0213ULL, 0x0000000d0a0d7210ULL, 0x000fe20007ffe0ffULL,
0x0000000815157824ULL, 0x000fe200078e00ffULL, 0xfffffff817177812ULL, 0x000fc400078ee208ULL,
0x0000000313137819ULL, 0x000fe400000006ffULL, 0x0000007a1d0a7212ULL, 0x0c0fe400078e3cffULL,
0x000000031d257819ULL, 0x000fe400000006ffULL, 0x0000007a19087212ULL, 0x000fe400078e3cffULL,
0xfffffff813197812ULL, 0x000fe200078ee200ULL, 0x0000001007137824ULL, 0x100fe200078e0206ULL,
0xfffffff8151d7812ULL, 0x000fe200078ee204ULL, 0x0000001009157824ULL, 0x100fe200078e0206ULL,
0xfffffff825257812ULL, 0x000fe200078ee20aULL, 0x0000001019197824ULL, 0x100fe200078e0206ULL,
0xfffffff821217812ULL, 0x000fe200078ee208ULL, 0x000000101d1d7824ULL, 0x100fe200078e0206ULL,
0x0000000617177211ULL, 0x080fe200078e20ffULL, 0x0000001025257824ULL, 0x000fe200078e0206ULL,
0x0000000621217211ULL, 0x000fe200078e20ffULL, 0x0000010005047825ULL, 0x000fc800078e0002ULL,
0x000001000d067825ULL, 0x000fc800078e0002ULL, 0x000001000f087825ULL, 0x000fc800078e0002ULL,
0x000001000b0a7825ULL, 0x000fc800078e0002ULL, 0x000001001b0c7825ULL, 0x000fc800078e0002ULL,
0x000001001f0e7825ULL, 0x000fc800078e0002ULL, 0x0000010023027825ULL, 0x000fc800078e0002ULL,
0x0000001011047825ULL, 0x000fc800078e0004ULL, 0x0000001011067825ULL, 0x040fe200078e0006ULL,
0x0000000004137faeULL, 0x0003e6000c101c46ULL, 0x0000001011087825ULL, 0x040fe200078e0008ULL,
0x0000000006157faeULL, 0x0003e6000c901c46ULL, 0x00000010110a7825ULL, 0x040fe200078e000aULL,
0x0000000008177faeULL, 0x0003e6000d101c46ULL, 0x00000010110c7825ULL, 0x040fe200078e000cULL,
0x000000000a197faeULL, 0x0003e6000d901c46ULL, 0x00000010110e7825ULL, 0x040fe200078e000eULL,
0x000000000c1d7faeULL, 0x0003e6000e101c46ULL, 0x0000001011027825ULL, 0x000fe200078e0002ULL,
0x000000000e217faeULL, 0x0003e8000e901c46ULL, 0x0000000002257faeULL, 0x0003e2000f101c46ULL,
0x0000000400407947ULL, 0x000fea0003800000ULL, 0x00000003ff057819ULL, 0x000fc8000001167aULL,
0x00000008050f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000c05137836ULL, 0x040fe20000000000ULL,
0x0000001405177810ULL, 0x000fe20007ffe0ffULL, 0x00000004050b7836ULL, 0x000fe20000000000ULL,
0x0000007a0f027212ULL, 0x080fe200078e3cffULL, 0x0000000813047824ULL, 0x040fe200078e00ffULL,
0x0000007a13037212ULL, 0x080fe200078e3cffULL, 0x0000001805197836ULL, 0x000fe20000000000ULL,
0x000000030f117819ULL, 0x000fe200000006ffULL, 0x000000080b0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8041d7812ULL, 0x000fe200078ee203ULL, 0x0000000819087824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee202ULL, 0x0000001005157836ULL, 0x000fe20000000000ULL,
0x00008a00ff027b82ULL, 0x000e620000000a00ULL, 0x0000007a0b007212ULL, 0x080fe200078e3cffULL,
0x000000010a1b7824ULL, 0x000fe200078e0213ULL, 0x0000007a19077212ULL, 0x080fe200078e3cffULL,
0x0000000815217824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee200ULL,
0x0000000879137824ULL, 0x040fe200078e00ffULL, 0x0000000974007c11ULL, 0x000fe2000f8e70ffULL,
0x000000010a0b7824ULL, 0x040fe200078e020bULL, 0xfffffff808297812ULL, 0x000fe200078ee207ULL,
0x000000010a1f7824ULL, 0x000fe200078e0215ULL, 0x0000000705097812ULL, 0x000fe200078e487aULL,
0x0000200079007824ULL, 0x000fe200078e0200ULL, 0x000000050a077210ULL, 0x000fe20007ffe0ffULL,
0x0000001c05057836ULL, 0x000fe20000000000ULL, 0x0000007a15047212ULL, 0x080fe200078e3cffULL,
0x0001300000007836ULL, 0x000fe20000000000ULL, 0x0000007a17067212ULL, 0x080fe200078e3cffULL,
0x000000010a2b7824ULL, 0x040fe200078e0205ULL, 0xfffffff821217812ULL, 0x000fe200078ee204ULL,
0x000000010a277824ULL, 0x000fe200078e0219ULL, 0x0000007a05047212ULL, 0x000fe200078e3cffULL,
0x0000001011197824ULL, 0x000fe200078e0200ULL, 0x00000003052d7819ULL, 0x000fe200000006ffULL,
0x0000010027107825ULL, 0x002fe200078e0002ULL, 0x0000000317257819ULL, 0x000fc400000006ffULL,
0x0000000f0a0f7210ULL, 0x000fe20007ffe0ffULL, 0x0000001021217824ULL, 0x000fe200078e0200ULL,
0x0ffffff809097812ULL, 0x000fe400078ef87aULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee204ULL,
0x0000010007047825ULL, 0x100fe200078e0002ULL, 0xfffffff825257812ULL, 0x000fe400078ee206ULL,
0x000000170a237210ULL, 0x000fe20007ffe0ffULL, 0x000001000b067825ULL, 0x000fe200078e0002ULL,
0xfffffff813137812ULL, 0x000fc400078ee27aULL, 0x0000000009157211ULL, 0x080fe200078e20ffULL,
0x000001000f087825ULL, 0x000fe200078e0002ULL, 0x000000001d1d7211ULL, 0x080fe400078e20ffULL,
0x0000000029297211ULL, 0x000fe200078e20ffULL, 0x000000100d177824ULL, 0x000fe400078e0200ULL,
0x000001001b0a7825ULL, 0x000fc800078e0002ULL, 0x000001001f0c7825ULL, 0x000fc800078e0002ULL,
0x00000100230e7825ULL, 0x000fc800078e0002ULL, 0x0000001013047825ULL, 0x000fc800078e0004ULL,
0x000001002b027825ULL, 0x000fe200078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004157faeULL, 0x0003e6000b901c46ULL, 0x0000001013067825ULL, 0x000fc800078e0006ULL,
0x0000001013087825ULL, 0x040fe200078e0008ULL, 0x0000000006177faeULL, 0x0003e6000b901c46ULL,
0x00000010130a7825ULL, 0x040fe200078e000aULL, 0x0000000008197faeULL, 0x0003e6000b901c46ULL,
0x00000010130c7825ULL, 0x000fe200078e000cULL, 0x000000000a1d7faeULL, 0x0003e6000b901c46ULL,
0x0000001025257824ULL, 0x000fe200078e0200ULL, 0x000000000c217faeULL, 0x0003e2000b901c46ULL,
0x00000010130e7825ULL, 0x000fc800078e000eULL, 0x0000001013107825ULL, 0x000fe200078e0010ULL,
0x000000000e257faeULL, 0x0003e6000b901c46ULL, 0x000000102d2d7824ULL, 0x000fe200078e0200ULL,
0x0000000010297faeULL, 0x0003e2000b901c46ULL, 0x0000001013027825ULL, 0x000fca00078e0002ULL,
0x00000000022d7faeULL, 0x0003e4000b901c46ULL, 0x000000785c00720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff007424ULL, 0x000fe200078e00ffULL,
0x000000ff00027202ULL, 0x002fe40000000f00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fc4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fc4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x00000000003a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000004400080947ULL, 0x000fec0003800000ULL,
0xff317217ff007424ULL, 0x000fe200078e00ffULL, 0x000000ff00277202ULL, 0x000fe20000000f00ULL,
0x000000ffff497224ULL, 0x000fce00078e00ffULL, 0x000001005c037824ULL, 0x000fca00078e00ffULL,
0x0000005e0300720cULL, 0x000fda0003f06070ULL, 0x0000004000e40947ULL, 0x000fea0003800000ULL,
0x000000015c037836ULL, 0x000fe20000000000ULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x0000002074047824ULL, 0x000fe200078e00ffULL, 0x0000004900657202ULL, 0x000fe40000000f00ULL,
0x000000780300720cULL, 0x000fe40003f06070ULL, 0x000000045c557211ULL, 0x000fca00078e40ffULL,
0x0000004055047836ULL, 0x000fc80000000000ULL, 0x00000004750c7c24ULL, 0x000fe2000f8e0204ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400848947ULL, 0x000fea0003800000ULL,
0x000000045e037248ULL, 0x000fe20007fe0000ULL, 0x000000ffff047224ULL, 0x000fe200078e0a04ULL,
0x0000000974487c11ULL, 0x000fe2000f8e70ffULL, 0x00008a00000a7ab9ULL, 0x000fe20000000a00ULL,
0x00000003791d7819ULL, 0x000fe200000006ffULL, 0x0000000aff4e7e24ULL, 0x000fe2000f8e00ffULL,
0x00000020030d7446ULL, 0x000fe20003800004ULL, 0x0000100049047824ULL, 0x000fe200078e00ffULL,
0x00000003ff037819ULL, 0x000fe2000001167aULL, 0x0000200079487824ULL, 0x000fe200078e0248ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee27aULL, 0x0000000bff4f7e24ULL, 0x000fe2000f8e00ffULL,
0x0000007a03057212ULL, 0x040fe200078e3cffULL, 0x0000000103077824ULL, 0x000fe200078e020cULL,
0x00001000040b7812ULL, 0x000fc400078e0cffULL, 0x0000000403047810ULL, 0x000fe20007ffe0ffULL,
0x0000010007067825ULL, 0x000fe200078e004eULL, 0x0000000705057812ULL, 0x000fe400078ec0ffULL,
0x0000000d0300720cULL, 0x080fe20003f26070ULL, 0x00000008040a7824ULL, 0x000fe200078e00ffULL,
0x0000000c04097210ULL, 0x000fe20007ffe0ffULL, 0x000000101d0e7825ULL, 0x000fe200078e0006ULL,
0x00013000480b7810ULL, 0x000fe40007ffe00bULL, 0x0ffffff805567812ULL, 0x000fe200078ef87aULL,
0x0000010009087825ULL, 0x000fe200078e004eULL, 0x0000000d0400720cULL, 0x000fc40003f46070ULL,
0x0000007a04537212ULL, 0x080fe200078e3cffULL, 0x0000001056177824ULL, 0x000fe200078e020bULL,
0x0000001003077810ULL, 0x000fe20007ffe0ffULL, 0x0000000803057836ULL, 0x000fe20000000000ULL,
0xfffffff80a537812ULL, 0x000fe200078ee253ULL, 0x000000101d147825ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e177faeULL, 0x0003e2000c901c46ULL,
0x0000001c030a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000b53197211ULL, 0x000fe200078e20ffULL,
0x0000000c03067836ULL, 0x000fe20000000000ULL, 0x0000007a05527212ULL, 0x080fe200078e3cffULL,
0x0000001403087836ULL, 0x000fe20000000000ULL, 0x0000000d0500720cULL, 0x080fe20003f26070ULL,
0x0000001803097836ULL, 0x000fe20000000000ULL, 0x0000000014197faeULL, 0x0005e2000d101c46ULL,
0x0000000d0600720cULL, 0x0c0fe20003f46070ULL, 0x00000008050f7824ULL, 0x002fe200078e00ffULL,
0x0000000d0700720cULL, 0x080fe20003f66070ULL, 0x00000008060e7824ULL, 0x000fe200078e00ffULL,
0x0000000d0800720cULL, 0x000fe20003f86070ULL, 0x0000000106177824ULL, 0x040fe200078e020cULL,
0x0000007a065b7212ULL, 0x000fc400078e3cffULL, 0x0000000d0900720cULL, 0x080fe20003fa6070ULL,
0x0000010017167825ULL, 0x000fe200078e004eULL, 0x0000000d0a00720cULL, 0x000fe40003fc6070ULL,
0xfffffff80f527812ULL, 0x000fe200078ee252ULL, 0x00000008090f7824ULL, 0x000fe200078e00ffULL,
0x0000007a075a7212ULL, 0x0c0fe200078e3cffULL, 0x0000000108197824ULL, 0x104fe200078e020cULL,
0x00000003070d7819ULL, 0x000fe200000006ffULL, 0x0000000109157824ULL, 0x040fe200078e020cULL,
0x0000007a09587212ULL, 0x000fe200078e3cffULL, 0x0000010019187825ULL, 0x000fe200078e004eULL,
0xfffffff80e5b7812ULL, 0x000fc400078ee25bULL, 0xfffffff80d5a7812ULL, 0x000fe200078ee25aULL,
0x00000008080e7824ULL, 0x040fe200078e00ffULL, 0x0000007a08597212ULL, 0x080fe200078e3cffULL,
0x000000101d167825ULL, 0x000fe200078e0016ULL, 0x0000007a0a577212ULL, 0x040fe400078e3cffULL,
0x000000030a147819ULL, 0x000fe200000006ffULL, 0x00000010521f7824ULL, 0x000fe200078e020bULL,
0xfffffff80f587812ULL, 0x000fe200078ee258ULL, 0x00000001050f7824ULL, 0x000fe200078e020cULL,
0x0000000c071b7210ULL, 0x000fe20007ffe0ffULL, 0x000000101d187825ULL, 0x000fe200078e0018ULL,
0x0000000c0a0d7210ULL, 0x000fc40007ffe0ffULL, 0xfffffff80e597812ULL, 0x000fe200078ee259ULL,
0x000001000f0e7825ULL, 0x100fe200078e004eULL, 0xfffffff814577812ULL, 0x000fe400078ee257ULL,
0x0000000b5a217211ULL, 0x000fe200078e20ffULL, 0x000001001b1a7825ULL, 0x000fc800078e004eULL,
0x0000010015147825ULL, 0x000fc800078e004eULL, 0x000001000d0c7825ULL, 0x000fc800078e004eULL,
0x000000101d0e7825ULL, 0x000fc800078e000eULL, 0x000000101d1a7825ULL, 0x040fe200078e001aULL,
0x000000000e1f7faeULL, 0x0003e6000c901c46ULL, 0x000000101d147825ULL, 0x000fc800078e0014ULL,
0x000000101d0c7825ULL, 0x000fc800078e000cULL, 0x000000105b1d7824ULL, 0x100fe400078e020bULL,
0x0000001059237824ULL, 0x100fe400078e020bULL, 0x0000001058417824ULL, 0x000fe200078e020bULL,
0x0000000b570b7211ULL, 0x000fe200078e20ffULL, 0x00000000161d7faeULL, 0x0003e8000d101c46ULL,
0x000000001a217faeULL, 0x0003e8000d901c46ULL, 0x0000000018237faeULL, 0x0003e8000e101c46ULL,
0x0000000014417faeULL, 0x0003e8000e901c46ULL, 0x000000000c0b7faeULL, 0x0003e2000f101c46ULL,
0x00000004004c7947ULL, 0x000fea0003800000ULL, 0x00000003ff037819ULL, 0x000fe2000001167aULL,
0x00008a00ff4e7b82ULL, 0x000e620000000a00ULL, 0x00000008790f7824ULL, 0x000fe200078e00ffULL,
0x0000000974487c11ULL, 0x000fe4000f8e70ffULL, 0x0000000803057836ULL, 0x040fe20000000000ULL,
0x0000000c03067810ULL, 0x000fe20007ffe0ffULL, 0x0000001003077836ULL, 0x040fe20000000000ULL,
0x0000007a030d7212ULL, 0x0c0fe200078e3cffULL, 0x0000000403047836ULL, 0x000fe20000000000ULL,
0x0000007a05527212ULL, 0x080fe200078e3cffULL, 0x00000008070b7824ULL, 0x000fe200078e00ffULL,
0x0000000305097819ULL, 0x000fe200000006ffULL, 0x0000000804087824ULL, 0x000fe200078e00ffULL,
0x0000007a075a7212ULL, 0x080fe200078e3cffULL, 0x00000008060a7824ULL, 0x000fe200078e00ffULL,
0xfffffff809527812ULL, 0x000fe200078ee252ULL, 0x0000001803097836ULL, 0x000fe20000000000ULL,
0xfffffff80b5a7812ULL, 0x000fe200078ee25aULL, 0x0000200079487824ULL, 0x000fe200078e0248ULL,
0x0000007a04537212ULL, 0x0c0fe200078e3cffULL, 0x00000008090b7824ULL, 0x040fe200078e00ffULL,
0x0000007a09587212ULL, 0x000fe200078e3cffULL, 0x0000000104177824ULL, 0x100fe200078e020cULL,
0xfffffff808537812ULL, 0x000fe200078ee253ULL, 0x0000000105197824ULL, 0x100fe200078e020cULL,
0xfffffff80b587812ULL, 0x000fe200078ee258ULL, 0x00000001071f7824ULL, 0x000fe200078e020cULL,
0x0000000c490b7819ULL, 0x000fe200000006ffULL, 0x0000010017167825ULL, 0x002fe200078e004eULL,
0x0000001403087810ULL, 0x000fc40007ffe0ffULL, 0x0000007a065b7212ULL, 0x080fe200078e3cffULL,
0x0000010019187825ULL, 0x000fe200078e004eULL, 0x000010000b157812ULL, 0x000fe400078e0cffULL,
0xfffffff80f0b7812ULL, 0x000fe200078ee27aULL, 0x00000001081b7824ULL, 0x040fe200078e020cULL,
0x0000007a08597212ULL, 0x040fe200078e3cffULL, 0x000001001f1e7825ULL, 0x100fe200078e004eULL,
0x00000003080e7819ULL, 0x000fe400000006ffULL, 0x0000000c030f7210ULL, 0x000fe20007ffe0ffULL,
0x000001001b1a7825ULL, 0x000fe200078e004eULL, 0xfffffff80a5b7812ULL, 0x000fc400078ee25bULL,
0xfffffff80e597812ULL, 0x000fe200078ee259ULL, 0x0000001c030a7836ULL, 0x000fe20000000000ULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e004eULL,
0x0001300048207810ULL, 0x000fe40007ffe015ULL, 0x0000000c09157210ULL, 0x000fe20007ffe0ffULL,
0x000000080a147824ULL, 0x040fe200078e00ffULL, 0x0000007a0a577212ULL, 0x040fe200078e3cffULL,
0x000000010a217824ULL, 0x000fe200078e020cULL, 0x0000000c061d7210ULL, 0x000fe20007ffe0ffULL,
0x000000100b167825ULL, 0x000fe200078e0016ULL, 0x0ffffff80d567812ULL, 0x000fc400078ef87aULL,
0xfffffff814577812ULL, 0x000fe200078ee257ULL, 0x000000100b0c7825ULL, 0x000fe200078e000eULL,
0x0000002053237211ULL, 0x080fe400078e20ffULL, 0x000000205a437211ULL, 0x080fe200078e20ffULL,
0x00000100150e7825ULL, 0x000fe200078e004eULL, 0x00000020574b7211ULL, 0x000fc600078e20ffULL,
0x000001001d1c7825ULL, 0x000fc800078e004eULL, 0x0000010021147825ULL, 0x000fc800078e004eULL,
0x0000001056217824ULL, 0x100fe400078e0220ULL, 0x0000001052417824ULL, 0x000fe400078e0220ULL,
0x000000100b187825ULL, 0x040fe200078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c217faeULL, 0x0003e6000b901c46ULL, 0x000000100b1c7825ULL, 0x040fe200078e001cULL,
0x0000000016237faeULL, 0x0003e6000b901c46ULL, 0x000000100b1e7825ULL, 0x040fe200078e001eULL,
0x0000000018417faeULL, 0x0003e6000b901c46ULL, 0x000000100b1a7825ULL, 0x000fc800078e001aULL,
0x000000100b0e7825ULL, 0x000fc800078e000eULL, 0x000000100b147825ULL, 0x000fc800078e0014ULL,
0x000000105b0b7824ULL, 0x100fe400078e0220ULL, 0x0000001059457824ULL, 0x100fe400078e0220ULL,
0x0000001058477824ULL, 0x000fe200078e0220ULL, 0x000000001c0b7faeULL, 0x0003e8000b901c46ULL,
0x000000001e437faeULL, 0x0003e8000b901c46ULL, 0x000000001a457faeULL, 0x0003e8000b901c46ULL,
0x000000000e477faeULL, 0x0003e8000b901c46ULL, 0x00000000144b7faeULL, 0x0003e4000b901c46ULL,
0x000000084d0b7824ULL, 0x002fe200078e00ffULL, 0x00000001000c7802ULL, 0x000fe20000000f00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000010740e7824ULL, 0x000fe400078e00ffULL,
0xffffffe00b7d7812ULL, 0x040fe200078ec0ffULL, 0x000000107a7b7824ULL, 0x000fe200078e00ffULL,
0x000000100b7c7812ULL, 0x040fe400078ec0ffULL, 0x000000080b0d7812ULL, 0x000fe200078ec0ffULL,
0x000000097d0b7c36ULL, 0x000fe20008000000ULL, 0x000000100e0e7812ULL, 0x000fc400078ec0ffULL,
0x000000707b7b7812ULL, 0x000fe400078ec0ffULL, 0x0000000b0d627210ULL, 0x000fe20007ffe07cULL,
0x000000010b0e7824ULL, 0x000fe400078e020eULL, 0x000000204d0b7824ULL, 0x000fe200078e00ffULL,
0x01b6080c620c79a7ULL, 0x000e64000850003fULL, 0x0000000e79547211ULL, 0x000fe400078e18ffULL,
0x00000001ff0e7819ULL, 0x000fc4000001167aULL, 0xffffff800b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0e0f7812ULL, 0x000fe400078ec0ffULL, 0x000000090b617c10ULL, 0x000fc8000fffe0ffULL,
0x000000610f0b7210ULL, 0x000fe20007ffe07bULL, 0x01b6080d540075a7ULL, 0x002e64000802017fULL,
0x000000c000e49947ULL, 0x002fea0003800000ULL, 0x01b000000b0d7984ULL, 0x000e620000000800ULL,
0x0000000474217824ULL, 0x000fe200078e00ffULL, 0x000000077a5d7812ULL, 0x000fe400078ec0ffULL,
0x01b200000b4b7984ULL, 0x0004a40000000800ULL, 0x0000000421217812ULL, 0x000fe400078ec0ffULL,
0x000000000d00720bULL, 0x002fda0003f3d000ULL, 0x00000000000c7806ULL, 0x000fc800008e0100ULL,
0x0000ffff0c147812ULL, 0x000fe2000782c0ffULL, 0x00000001ff0c7424ULL, 0x000fd800078e00ffULL,
0x0000000000e89947ULL, 0x004fea0003800000ULL, 0x000000000d00720bULL, 0x000fe40003f34000ULL,
0x0000000d00157209ULL, 0x040fe40007810000ULL, 0x00000002ff0e7819ULL, 0x100fe4000001167aULL,
0x00000001ff167819ULL, 0x000fe2000001167aULL, 0x80000015000b7221ULL, 0x000fe20000010000ULL,
0x000000080e0f7810ULL, 0x000fe40007ffe0ffULL, 0x00000002ff007819ULL, 0x000fe2000001164dULL,
0x3fb8aa3b0b0c7820ULL, 0x000fe20000410000ULL, 0x0000000c16167812ULL, 0x000fc400078ec0ffULL,
0x00000000000b7806ULL, 0x000fe200008e0100ULL, 0x0000000c00177308ULL, 0x0002a20000000800ULL,
0x0000004d0000720cULL, 0x000fe40003f25270ULL, 0x0000ffff0b0b7812ULL, 0x000fc800078e3cffULL,
0x0000000b14ff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff0c7807ULL, 0x002fc60001000000ULL,
0x000000094d009c11ULL, 0x000fe2000f8e38ffULL, 0x00001f0f170f7589ULL, 0x004e6200000e0000ULL,
0x0000001702027220ULL, 0x000fe40000410000ULL, 0x0000000016009210ULL, 0x000fe20007ffe07bULL,
0x00001f0e170e7589ULL, 0x000ea200000e0000ULL, 0x800000150d0d2221ULL, 0x000fc60000010000ULL,
0x01b4001500009388ULL, 0x0007e20000000800ULL, 0x3fb8aa3b0d0d2820ULL, 0x000fc80000410000ULL,
0x0000000d00502308ULL, 0x000f220000000800ULL, 0x000000ffff007224ULL, 0x008fe400078e0015ULL,
0x0000000f27277220ULL, 0x082fe20000410000ULL, 0x0000000f26267220ULL, 0x080fe20000410000ULL,
0x0000000f33337220ULL, 0x080fe20000410000ULL, 0x0000000f32327220ULL, 0x080fe20000410000ULL,
0x0000000f2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000f2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000f2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000f2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000f13137220ULL, 0x080fe20000410000ULL, 0x0000000f12127220ULL, 0x080fe20000410000ULL,
0x0000000f37377220ULL, 0x080fe20000410000ULL, 0x0000000f36367220ULL, 0x080fe20000410000ULL,
0x0000000f3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000f3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000f3f3f7220ULL, 0x080fe20000410000ULL, 0x0000000f3e3e7220ULL, 0x000fe20000410000ULL,
0x0000000e25257220ULL, 0x084fe20000410000ULL, 0x0000000e24247220ULL, 0x080fe20000410000ULL,
0x0000000e31317220ULL, 0x080fe20000410000ULL, 0x0000000e30307220ULL, 0x080fe20000410000ULL,
0x0000000e2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000e2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000e29297220ULL, 0x080fe20000410000ULL, 0x0000000e28287220ULL, 0x080fe20000410000ULL,
0x0000000e11117220ULL, 0x080fe20000410000ULL, 0x0000000e10107220ULL, 0x080fe20000410000ULL,
0x0000000e35357220ULL, 0x080fe20000410000ULL, 0x0000000e34347220ULL, 0x080fe20000410000ULL,
0x0000000e39397220ULL, 0x080fe20000410000ULL, 0x0000000e38387220ULL, 0x080fe20000410000ULL,
0x0000000e3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000e3c3c7220ULL, 0x000fe20000410000ULL,
0x000000504b4b2220ULL, 0x010fce0000410000ULL, 0x000002004d0e7824ULL, 0x000fe200078e00ffULL,
0x000000085d227812ULL, 0x000fe200078ef87aULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000217a0d7211ULL, 0x040fe200078fe0ffULL, 0x00000001ff607424ULL, 0x000fe200078e00ffULL,
0x000000087a0b7812ULL, 0x000fe200078ec0ffULL, 0x000000024b027221ULL, 0x000fe20000010000ULL,
0xfffff8000e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000070d0d7812ULL, 0x000fe400078e7822ULL,
0x00000004ff407819ULL, 0x000fe2000001167aULL, 0x000000090e637c36ULL, 0x000fe20008000000ULL,
0x000000070b697812ULL, 0x000fe200078ec87aULL, 0x0000000822647824ULL, 0x000fe200078e020dULL,
0x00000048494c7211ULL, 0x000fe200078e60ffULL, 0x00000004400e7836ULL, 0x000fe20000000000ULL,
0x000000070b207812ULL, 0x000fe200078ef87aULL, 0x0000001064647824ULL, 0x000fe200078e0263ULL,
0x0000004069667212ULL, 0x000fc400078e3cffULL, 0x000130004c4c7810ULL, 0x000fe40007ffe0ffULL,
0x011000006418783bULL, 0x000fe20000000200ULL, 0x0000000820727824ULL, 0x000fe200078e0266ULL,
0x00000002ff147819ULL, 0x000fe4000001167aULL, 0x00000050ff0b723eULL, 0x000fe200000000ffULL,
0x00000010721c7824ULL, 0x000fe200078e024cULL, 0x0000000240687810ULL, 0x000fe20007ffe0ffULL,
0x00000008140f7836ULL, 0x000fe20000000000ULL, 0x000054100b237816ULL, 0x000fc4000000000bULL,
0x0000006869687212ULL, 0x040fe200078e3cffULL, 0x000000001c1c783bULL, 0x000fe20000004200ULL,
0x0000000e69677212ULL, 0x000fe400078e3cffULL, 0x0000006820737211ULL, 0x040fe200078e18ffULL,
0x00001f14230b7589ULL, 0x0002a200000e0000ULL, 0x0000006720777211ULL, 0x000fe400078e18ffULL,
0x0000000221217810ULL, 0x000fe20007ffe040ULL, 0x00001f0f234a7589ULL, 0x000ee200000e0000ULL,
0x00000010730d7824ULL, 0x000fe200078e024cULL, 0x000000014d5f7819ULL, 0x000fc400000006ffULL,
0x0000000721217812ULL, 0x000fe400078e7822ULL, 0x000099100c147816ULL, 0x002fe400000000ffULL,
0x000000000d0c783bULL, 0x000e620000004200ULL, 0x0000000822227824ULL, 0x000fe200078e0221ULL,
0x000000ff1400720cULL, 0x000fe20003f25270ULL, 0x0000001077147824ULL, 0x000fe200078e024cULL,
0xfffffff85f5f7812ULL, 0x000fe400078ec0ffULL, 0x0000006322637211ULL, 0x000fc400078e20ffULL,
0x0000000149497812ULL, 0x000fe200078e0cffULL, 0x000000001414783bULL, 0x000f2c0000004200ULL,
0x0000000b18189232ULL, 0x084fe40000000000ULL, 0x0000000b1a1a9232ULL, 0x000fe40000000000ULL,
0x0000004a19199232ULL, 0x008fc40000000000ULL, 0x0000004a1b1b9232ULL, 0x000fce0000000000ULL,
0x0000001c183c723cULL, 0x000fec000000183cULL, 0x0000001e1838723cULL, 0x000fe20000001838ULL,
0x00000006401c7836ULL, 0x000fca0000000000ULL, 0x0000001c69697212ULL, 0x000fe200078e3cffULL,
0x0000000c1834723cULL, 0x002fe60000001834ULL, 0x0000006920767211ULL, 0x040fe400078e18ffULL,
0x0000008020207811ULL, 0x000fe200078e18ffULL, 0x0000000e1810723cULL, 0x000fe20000001810ULL,
0x01100000630c783bULL, 0x000e620000000200ULL, 0x0000001076407824ULL, 0x000fe200078e024cULL,
0x0000002067677210ULL, 0x000fe20007ffe0ffULL, 0x0000000166667824ULL, 0x100fe200078e0220ULL,
0x0000002069697210ULL, 0x000fe20007ffe0ffULL, 0x0000000168687824ULL, 0x000fe200078e0220ULL,
0x000000141828723cULL, 0x010fe20000001828ULL, 0x000000004040783bULL, 0x000ea20000004200ULL,
0x0000001066447824ULL, 0x000fc400078e024cULL, 0x0000001068217824ULL, 0x100fe400078e024cULL,
0x00000010671c7824ULL, 0x100fe200078e024cULL, 0x00000016182c723cULL, 0x000fe2000000182cULL,
0x0000001069147824ULL, 0x000fe200078e024cULL, 0x000000004444783bULL, 0x000ee80000004200ULL,
0x000000002120783bULL, 0x000f280000004200ULL, 0x000000001c1c783bULL, 0x000f680000004200ULL,
0x000000001414783bULL, 0x000f220000004200ULL, 0x01b688605fff79a7ULL, 0x0003e40008500009ULL,
0x0000000b0c0c9232ULL, 0x002fc40000000000ULL, 0x0000000b0e0e9232ULL, 0x000fe20000000000ULL,
0x000000405c0b7811ULL, 0x000fe200078e40ffULL, 0x0000004a0d0d9232ULL, 0x080fe40000000000ULL,
0x0000004a0f0f9232ULL, 0x000fe20000000000ULL, 0x000000401830723cULL, 0x004fe20000001830ULL,
0x0000005e0b00720cULL, 0x000fca0003f26070ULL, 0x000000421824723cULL, 0x000fec0000001824ULL,
0x000000440c3c723cULL, 0x008fec000000183cULL, 0x000000460c38723cULL, 0x000fec0000001838ULL,
0x000000200c34723cULL, 0x010fec0000001834ULL, 0x000000220c10723cULL, 0x000fec0000001810ULL,
0x0000001c0c28723cULL, 0x020fec0000001828ULL, 0x0000001e0c2c723cULL, 0x000fec000000182cULL,
0x000000140c30723cULL, 0x000fec0000001830ULL, 0x000000160c24723cULL, 0x000fe20000001824ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000002c00041947ULL, 0x000fde0003800000ULL,
0x00000080550c7836ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000475147c24ULL, 0x000fe2000f8e020cULL, 0x0000000000f08947ULL, 0x000fec0003800000ULL,
0x0000000c5e0b7248ULL, 0x000fe20007fe0000ULL, 0x00001000651c7824ULL, 0x000fe200078e00ffULL,
0x000000ff0c0c7210ULL, 0x000fe20007ffe1ffULL, 0x00000008790e7824ULL, 0x000fe200078e00ffULL,
0x00000014030f7210ULL, 0x000fe20007ffe0ffULL, 0x00000001040d7824ULL, 0x100fe200078e0214ULL,
0x000000200b157446ULL, 0x000fe2000380000cULL, 0x00000001051b7824ULL, 0x000fe200078e0214ULL,
0x000010001c177812ULL, 0x000fe200078ec0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e004eULL,
0x000000150300720cULL, 0x000fc40003f26070ULL, 0xfffffff80e0b7812ULL, 0x000fe200078ee25dULL,
0x000001000f0e7825ULL, 0x000fe200078e004eULL, 0x000000150400720cULL, 0x080fe40003f46070ULL,
0x00013000484c7810ULL, 0x000fe20007ffe017ULL, 0x000000100b0c7825ULL, 0x000fe200078e000cULL,
0x000000150700720cULL, 0x080fe40003f66070ULL, 0x0000004c53197211ULL, 0x000fe200078e20ffULL,
0x000000100b0e7825ULL, 0x000fe200078e000eULL, 0x000000150800720cULL, 0x000fc40003f86070ULL,
0x000000150900720cULL, 0x0c0fe20003fa6070ULL, 0x0000001056177824ULL, 0x000fe200078e024cULL,
0x000000150a00720cULL, 0x080fe20003fc6070ULL, 0x00000001091f7824ULL, 0x000fe200078e0214ULL,
0x000000140a217210ULL, 0x000fe20007ffe0ffULL, 0x00000010521d7824ULL, 0x100fe200078e024cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e177faeULL, 0x0003e2000c901c46ULL,
0x000000150500720cULL, 0x080fe20003f26070ULL, 0x0000001059237824ULL, 0x000fe200078e024cULL,
0x0000004c57437211ULL, 0x000fe200078e20ffULL, 0x000000000c197faeULL, 0x0005e2000d101c46ULL,
0x000000150600720cULL, 0x040fe20003f46070ULL, 0x0000000106157824ULL, 0x000fc400078e0214ULL,
0x0000001058417824ULL, 0x000fe200078e024cULL, 0x0000001407177210ULL, 0x002fe20007ffe0ffULL,
0x000001001b0e7825ULL, 0x000fc800078e004eULL, 0x00000001081b7824ULL, 0x000fe400078e0214ULL,
0x00000100150c7825ULL, 0x004fc800078e004eULL, 0x0000010017147825ULL, 0x000fc800078e004eULL,
0x000001001b167825ULL, 0x000fc800078e004eULL, 0x000001001f187825ULL, 0x000fc800078e004eULL,
0x00000100211a7825ULL, 0x000fe200078e004eULL, 0x0000004c5a217211ULL, 0x000fc600078e20ffULL,
0x000000100b0e7825ULL, 0x000fc800078e000eULL, 0x000000100b0c7825ULL, 0x000fe200078e000cULL,
0x000000000e1d7faeULL, 0x0003e6000c901c46ULL, 0x000000105b1f7824ULL, 0x000fe400078e024cULL,
0x000000100b147825ULL, 0x000fc600078e0014ULL, 0x000000000c1f7faeULL, 0x0003e2000d101c46ULL,
0x000000100b167825ULL, 0x000fc600078e0016ULL, 0x0000000014217faeULL, 0x0003e2000d901c46ULL,
0x000000100b187825ULL, 0x000fc600078e0018ULL, 0x0000000016237faeULL, 0x0003e2000e101c46ULL,
0x000000100b1a7825ULL, 0x000fc600078e001aULL, 0x0000000018417faeULL, 0x0003e8000e901c46ULL,
0x000000001a437faeULL, 0x0003e2000f101c46ULL, 0x0000000000c07947ULL, 0x000fea0003800000ULL,
0x00001000651c7824ULL, 0x000fe200078e00ffULL, 0x00000003790c7819ULL, 0x000fe200000006ffULL,
0x00000001030f7824ULL, 0x100fe200078e0214ULL, 0x0000001405177210ULL, 0x000fe20007ffe0ffULL,
0x00000001040d7824ULL, 0x000fe200078e0214ULL, 0x000010001c157812ULL, 0x000fe200078ec0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e004eULL, 0xfffffff80c0b7812ULL, 0x000fe400078ee25dULL,
0x00013000484c7810ULL, 0x000fe20007ffe015ULL, 0x000001000d0c7825ULL, 0x000fe200078e004eULL,
0x000000140a237210ULL, 0x000fc40007ffe0ffULL, 0x0000004c57437211ULL, 0x000fe200078e20ffULL,
0x000000100b0e7825ULL, 0x000fc800078e000eULL, 0x0000001056157824ULL, 0x000fe400078e024cULL,
0x000000100b0c7825ULL, 0x000fc600078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e157faeULL, 0x0003e2000b901c46ULL, 0x00000010531b7824ULL, 0x000fe400078e024cULL,
0x0000000106197824ULL, 0x100fe400078e0214ULL, 0x00000001081f7824ULL, 0x100fe200078e0214ULL,
0x000000000c1b7faeULL, 0x0005e2000b901c46ULL, 0x0000000109217824ULL, 0x000fe400078e0214ULL,
0x00000010521d7824ULL, 0x100fe400078e024cULL, 0x0000001058417824ULL, 0x000fc400078e024cULL,
0x00000100170e7825ULL, 0x002fe200078e004eULL, 0x0000001407177210ULL, 0x000fc60007ffe0ffULL,
0x00000100190c7825ULL, 0x004fc800078e004eULL, 0x0000010017147825ULL, 0x000fc800078e004eULL,
0x000001001f167825ULL, 0x000fc800078e004eULL, 0x0000010021187825ULL, 0x000fe200078e004eULL,
0x0000004c5a217211ULL, 0x000fc600078e20ffULL, 0x00000100231a7825ULL, 0x000fc800078e004eULL,
0x000000100b0e7825ULL, 0x000fc800078e000eULL, 0x000000100b0c7825ULL, 0x000fe200078e000cULL,
0x000000000e1d7faeULL, 0x0003e6000b901c46ULL, 0x000000105b1f7824ULL, 0x000fe400078e024cULL,
0x000000100b147825ULL, 0x000fc600078e0014ULL, 0x000000000c1f7faeULL, 0x0003e2000b901c46ULL,
0x000000100b167825ULL, 0x000fc600078e0016ULL, 0x0000000014217faeULL, 0x0003e2000b901c46ULL,
0x0000001059237824ULL, 0x000fe400078e024cULL, 0x000000100b187825ULL, 0x000fc600078e0018ULL,
0x0000000016237faeULL, 0x0003e2000b901c46ULL, 0x000000100b1a7825ULL, 0x000fc600078e001aULL,
0x0000000018417faeULL, 0x0003e8000b901c46ULL, 0x000000001a437faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01b62860620c79a7ULL, 0x002e62000850003fULL,
0x00000001ff0f7819ULL, 0x000fe4000001167aULL, 0x000000807b0e7810ULL, 0x000fe40007ffe061ULL,
0x0000000c0f0f7812ULL, 0x000fca00078ec0ffULL, 0x000000010f0e7824ULL, 0x000fe200078e020eULL,
0x01b6280d540075a7ULL, 0x002e64000802017fULL, 0x000000b000909947ULL, 0x002fea0003800000ULL,
0x01b000000e0d7984ULL, 0x000e620000000800ULL, 0x00000002ff417819ULL, 0x000fe4000001167aULL,
0x000010001c157812ULL, 0x000fe200078e0cffULL, 0x01b200000e437984ULL, 0x0004a20000000800ULL,
0x0000000841167810ULL, 0x000fe40007ffe0ffULL, 0x000000000d00720bULL, 0x002fda0003f3d000ULL,
0x00000000000c7806ULL, 0x000fc800008e0100ULL, 0x0000ffff0c147812ULL, 0x000fe2000782c0ffULL,
0x00000001ff0c7424ULL, 0x000fd800078e00ffULL, 0x0000000000e49947ULL, 0x004fea0003800000ULL,
0x000000000d00720bULL, 0x000fe40003f34000ULL, 0x0000000d000e7209ULL, 0x000fe40007810000ULL,
0x00000001ff187819ULL, 0x000fc6000001167aULL, 0x8000000e000c7221ULL, 0x000fe20000010000ULL,
0x000000014d007811ULL, 0x000fe400078ff0ffULL, 0x0000000c18187812ULL, 0x000fe200078ec0ffULL,
0x3fb8aa3b0c0f7820ULL, 0x000fe40000410000ULL, 0x00000000000c7806ULL, 0x000fe400008e0100ULL,
0x0000004d0000720cULL, 0x000fe40003f25270ULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x0000ffff0c177812ULL, 0x000fc800078e3cffULL, 0x0000001714ff7212ULL, 0x000fcc000784c0ffULL,
0x000000094d0c9c11ULL, 0x000fc8000f8e38ffULL, 0x0000000c18179210ULL, 0x000fe20007ffe07bULL,
0x00001f410f007589ULL, 0x002e6200000e0000ULL, 0x0000000f02027220ULL, 0x000fe20000410000ULL,
0x8000000e0d0d2221ULL, 0x100fe40000010000ULL, 0x00001f160f0c7589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b0d0d2820ULL, 0x000fe40000410000ULL, 0x01b4000e17009388ULL, 0x0007e40000000800ULL,
0x0000000d00502308ULL, 0x0009640000000800ULL, 0x00000001ff0d7807ULL, 0x010fe20001000000ULL,
0x000000003c3c7220ULL, 0x082fe20000410000ULL, 0x000000003d3d7220ULL, 0x080fe20000410000ULL,
0x0000000038387220ULL, 0x080fe20000410000ULL, 0x0000000039397220ULL, 0x080fe20000410000ULL,
0x0000000034347220ULL, 0x080fe20000410000ULL, 0x0000000035357220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x080fe20000410000ULL,
0x0000000028287220ULL, 0x080fe20000410000ULL, 0x0000000029297220ULL, 0x080fe20000410000ULL,
0x000000002c2c7220ULL, 0x080fe20000410000ULL, 0x000000002d2d7220ULL, 0x080fe20000410000ULL,
0x0000000030307220ULL, 0x080fe20000410000ULL, 0x0000000031317220ULL, 0x080fe20000410000ULL,
0x0000000024247220ULL, 0x080fe20000410000ULL, 0x0000000025257220ULL, 0x000fe20000410000ULL,
0x0000000c3e3e7220ULL, 0x084fe20000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000c36367220ULL, 0x080fe20000410000ULL, 0x0000000c37377220ULL, 0x080fe20000410000ULL,
0x0000000c12127220ULL, 0x080fe20000410000ULL, 0x0000000c13137220ULL, 0x080fe20000410000ULL,
0x0000000c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c32327220ULL, 0x080fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c26267220ULL, 0x080fe20000410000ULL, 0x0000000c27277220ULL, 0x000fe20000410000ULL,
0x000000ffff007224ULL, 0x000fe200078e000eULL, 0x000076100d0c7816ULL, 0x000fe2000000000cULL,
0x0000004350432220ULL, 0x028fce0000410000ULL, 0x0001300048407810ULL, 0x000fe20007ffe015ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x011800006418783bULL, 0x000fe20000000200ULL,
0x00000050ff0d723eULL, 0x000fe200000000ffULL, 0x00000010776f7824ULL, 0x100fe200078e0240ULL,
0x000099100c147816ULL, 0x000fe200000000ffULL, 0x0000001072717824ULL, 0x100fe200078e0240ULL,
0x000054100d447816ULL, 0x000fe2000000000dULL, 0x00000010766e7824ULL, 0x100fe200078e0240ULL,
0x000000006f0c783bULL, 0x000fe20000004200ULL, 0x0000004073707211ULL, 0x080fe200078e20ffULL,
0x00000010686c7824ULL, 0x100fe200078e0240ULL, 0x000000ff1400720cULL, 0x000fe20003f25270ULL,
0x00001f1644427589ULL, 0x000e6200000e0000ULL, 0x00000040666d7211ULL, 0x080fe200078e20ffULL,
0x00000010676b7824ULL, 0x000fe200078e0240ULL, 0x00000040696a7211ULL, 0x000fe200078e20ffULL,
0x000000007120783bULL, 0x000fe20000004200ULL, 0x00000001ff467424ULL, 0x000fe200078e00ffULL,
0x0000000165607812ULL, 0x000fe200078ec0ffULL, 0x0000000243027221ULL, 0x000fe20000010000ULL,
0x00000000701c783bULL, 0x000fe60000004200ULL, 0x000000ffff497224ULL, 0x000fe200078e0060ULL,
0x000000006e14783bULL, 0x000fe80000004200ULL, 0x00001f4144417589ULL, 0x000ea200000e0000ULL,
0x0000004219199232ULL, 0x002fc40000000000ULL, 0x000000421b1b9232ULL, 0x000fe40000000000ULL,
0x0000004118189232ULL, 0x084fe40000000000ULL, 0x000000411a1a9232ULL, 0x000fce0000000000ULL,
0x0000000c1828723cULL, 0x000fec0000001828ULL, 0x0000000e182c723cULL, 0x000fe2000000182cULL,
0x01180000630c783bULL, 0x000e6a0000000200ULL, 0x00000020183c723cULL, 0x000fec000000183cULL,
0x000000221838723cULL, 0x000fe20000001838ULL, 0x000000006d20783bULL, 0x000eaa0000004200ULL,
0x0000001c1834723cULL, 0x000fec0000001834ULL, 0x0000001e1810723cULL, 0x000fe20000001810ULL,
0x000000006c1c783bULL, 0x000eea0000004200ULL, 0x000000141830723cULL, 0x000fec0000001830ULL,
0x000000161824723cULL, 0x000fe20000001824ULL, 0x000000006b18783bULL, 0x000f280000004200ULL,
0x000000006a14783bULL, 0x000f620000004200ULL, 0x000000410c0c9232ULL, 0x082fe20000000000ULL,
0x01b690465fff79a7ULL, 0x0003e20008500009ULL, 0x000000410e0e9232ULL, 0x000fc40000000000ULL,
0x000000420d0d9232ULL, 0x080fe40000000000ULL, 0x000000420f0f9232ULL, 0x000fce0000000000ULL,
0x000000200c3c723cULL, 0x004fec000000183cULL, 0x000000220c38723cULL, 0x000fec0000001838ULL,
0x0000001c0c34723cULL, 0x008fec0000001834ULL, 0x0000001e0c10723cULL, 0x000fec0000001810ULL,
0x000000180c28723cULL, 0x010fec0000001828ULL, 0x0000001a0c2c723cULL, 0x000fec000000182cULL,
0x000000140c30723cULL, 0x020fec0000001830ULL, 0x000000160c24723cULL, 0x000fee0000001824ULL,
0x000000805c0d7811ULL, 0x000fc800078e40ffULL, 0x0000005e0d00720cULL, 0x000fda0003f26070ULL,
0x0000001c00301947ULL, 0x002fea0003800000ULL, 0x000000c055177810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0000000475167c24ULL, 0x000fe2000f8e0217ULL,
0x0000000000dc8947ULL, 0x000fec0003800000ULL, 0x000000175e0c7248ULL, 0x000fe20007fe0000ULL,
0x000000ffff177224ULL, 0x000fe200078e0a17ULL, 0x00000016040d7210ULL, 0x000fe20007ffe0ffULL,
0x00000001030f7824ULL, 0x100fe200078e0216ULL, 0x0000004053237211ULL, 0x000fe200078e20ffULL,
0x0000000105157824ULL, 0x000fe200078e0216ULL, 0x000000200c177446ULL, 0x000fe20003800017ULL,
0x000001000f0e7825ULL, 0x100fe200078e004eULL, 0x000000160a457210ULL, 0x000fe40007ffe0ffULL,
0x000000170300720cULL, 0x080fe20003f46070ULL, 0x000001000d0c7825ULL, 0x000fe200078e004eULL,
0x000000170400720cULL, 0x000fc40003f26070ULL, 0x000000170500720cULL, 0x080fe20003f06070ULL,
0x0000001056197824ULL, 0x000fe200078e0240ULL, 0x000000170700720cULL, 0x080fe20003f66070ULL,
0x000000100b0e7825ULL, 0x000fe200078e000eULL, 0x000000170800720cULL, 0x080fe40003f86070ULL,
0x000000170900720cULL, 0x080fe20003fa6070ULL, 0x0000010015147825ULL, 0x000fe200078e004eULL,
0x000000170a00720cULL, 0x080fe20003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e197faeULL, 0x0003e2000d101c46ULL, 0x000000170600720cULL, 0x000fe20003f46070ULL,
0x000000100b0c7825ULL, 0x000fe200078e000cULL, 0x0000001607177210ULL, 0x000fc40007ffe0ffULL,
0x00000040591f7211ULL, 0x000fe200078e20ffULL, 0x0000001052417824ULL, 0x000fe200078e0240ULL,
0x000000000c237faeULL, 0x0005e2000c901c46ULL, 0x000000100b147825ULL, 0x000fc800078e0014ULL,
0x00000001060f7824ULL, 0x102fe200078e0216ULL, 0x0000000014417faeULL, 0x0003e2000c101c46ULL,
0x0000000108197824ULL, 0x100fe400078e0216ULL, 0x0000000109437824ULL, 0x000fe400078e0216ULL,
0x000000105b1b7824ULL, 0x000fe400078e0240ULL, 0x000001000f0c7825ULL, 0x004fc800078e004eULL,
0x00000100170e7825ULL, 0x000fc800078e004eULL, 0x0000010019147825ULL, 0x002fc800078e004eULL,
0x0000010043167825ULL, 0x000fc800078e004eULL, 0x0000010045187825ULL, 0x000fc800078e004eULL,
0x000000100b0c7825ULL, 0x000fc800078e000cULL, 0x000000105a1d7824ULL, 0x000fe200078e0240ULL,
0x000000000c1b7faeULL, 0x0003e2000d101c46ULL, 0x000000100b0e7825ULL, 0x000fc800078e000eULL,
0x000000100b147825ULL, 0x040fe200078e0014ULL, 0x000000000e1d7faeULL, 0x0003e6000d901c46ULL,
0x0000001058217824ULL, 0x000fe200078e0240ULL, 0x00000000141f7faeULL, 0x0003e2000e101c46ULL,
0x000000100b167825ULL, 0x000fc800078e0016ULL, 0x0000001057237824ULL, 0x000fe200078e0240ULL,
0x0000000016217faeULL, 0x0003e2000e901c46ULL, 0x000000100b187825ULL, 0x000fca00078e0018ULL,
0x0000000018237faeULL, 0x0003e2000f101c46ULL, 0x0000000000ac7947ULL, 0x000fea0003800000ULL,
0x00000016030d7210ULL, 0x000fe20007ffe0ffULL, 0x0000000104157824ULL, 0x100fe200078e0216ULL,
0x0000004056177211ULL, 0x080fe200078e20ffULL, 0x00000001050f7824ULL, 0x000fe200078e0216ULL,
0x0000001606417210ULL, 0x000fe20007ffe0ffULL, 0x000001000d0c7825ULL, 0x100fe200078e004eULL,
0x0000001609477210ULL, 0x000fe40007ffe0ffULL, 0x000000405a1d7211ULL, 0x000fe200078e20ffULL,
0x0000010015147825ULL, 0x000fc800078e004eULL, 0x000001000f0e7825ULL, 0x000fc800078e004eULL,
0x000000100b0c7825ULL, 0x000fc800078e000cULL, 0x0000001053197824ULL, 0x000fe200078e0240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c177faeULL, 0x0003e2000b901c46ULL,
0x000000100b147825ULL, 0x000fc800078e0014ULL, 0x0000001052237824ULL, 0x000fe200078e0240ULL,
0x0000000014197faeULL, 0x0005e2000b901c46ULL, 0x000000100b0e7825ULL, 0x000fc800078e000eULL,
0x0000000107437824ULL, 0x100fe200078e0216ULL, 0x000000000e237faeULL, 0x0007e2000b901c46ULL,
0x0000000108457824ULL, 0x100fe400078e0216ULL, 0x000000010a497824ULL, 0x000fe400078e0216ULL,
0x00000100410c7825ULL, 0x002fc800078e004eULL, 0x0000010045147825ULL, 0x004fe200078e004eULL,
0x0000004057237211ULL, 0x008fc600078e20ffULL, 0x00000100430e7825ULL, 0x000fc800078e004eULL,
0x0000010047167825ULL, 0x000fc800078e004eULL, 0x0000010049187825ULL, 0x000fc800078e004eULL,
0x000000105b1b7824ULL, 0x000fe400078e0240ULL, 0x000000100b0c7825ULL, 0x000fc800078e000cULL,
0x000000100b0e7825ULL, 0x000fe200078e000eULL, 0x000000000c1b7faeULL, 0x0003e6000b901c46ULL,
0x00000010591f7824ULL, 0x000fe200078e0240ULL, 0x000000000e1d7faeULL, 0x0003e2000b901c46ULL,
0x000000100b147825ULL, 0x000fc800078e0014ULL, 0x0000001058217824ULL, 0x000fe200078e0240ULL,
0x00000000141f7faeULL, 0x0003e2000b901c46ULL, 0x000000100b167825ULL, 0x000fc800078e0016ULL,
0x000000100b187825ULL, 0x000fe200078e0018ULL, 0x0000000016217faeULL, 0x0003e8000b901c46ULL,
0x0000000018237faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01b64846620c79a7ULL, 0x002e62000850003fULL, 0x000000084d0e7824ULL, 0x000fe200078e00ffULL,
0x000000097c7c7c10ULL, 0x000fe4000fffe07dULL, 0x00000001ff147819ULL, 0x000fe4000001167aULL,
0x000000080e0e7812ULL, 0x000fe400078ec0ffULL, 0x0000000c14147812ULL, 0x000fc600078ec0ffULL,
0x000000010e0f7824ULL, 0x000fe200078e027cULL, 0x000001007b0e7810ULL, 0x000fc80007ffe061ULL,
0x0000000e140e7210ULL, 0x000fe20007ffe0ffULL, 0x01b6480d0f0075a7ULL, 0x002e64000800017fULL,
0x000000a000ec8947ULL, 0x002fea0003800000ULL, 0x01b000000e0d7984ULL, 0x000e620000000800ULL,
0x00000002ff177819ULL, 0x000fe2000001167aULL, 0x00000001ff147424ULL, 0x000fe400078e00ffULL,
0x01b200000e5d7984ULL, 0x0004a40000000800ULL, 0x00000008171a7836ULL, 0x000fe20000000000ULL,
0x000000000d00720bULL, 0x002fda0003f1d000ULL, 0x00000000000c7806ULL, 0x000fc800000e0100ULL,
0x0000ffff0c157812ULL, 0x000fda000780c0ffULL, 0x0000000000e08947ULL, 0x004fea0003800000ULL,
0x000000000d00720bULL, 0x000fe40003f14000ULL, 0x0000000d000e7209ULL, 0x000fe40007810000ULL,
0x00000001ff167819ULL, 0x000fc6000001167aULL, 0x8000000e000c7221ULL, 0x000fe20000010000ULL,
0x000000024d007811ULL, 0x000fe400078ff0ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x3fb8aa3b0c0f7820ULL, 0x000fe40000410000ULL, 0x00000000000c7806ULL, 0x000fe400000e0100ULL,
0x0000004d0000720cULL, 0x000fe40003f05270ULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x0000ffff0c0c7812ULL, 0x000fc800078e3cffULL, 0x0000000c15ff7212ULL, 0x000fc8000782c0ffULL,
0x00000001ff147807ULL, 0x000fe40000800000ULL, 0x000000094d0c8c11ULL, 0x000fe2000f8e38ffULL,
0x00001f170f007589ULL, 0x002e6600000e0000ULL, 0x0000000c16158210ULL, 0x000fe20007ffe07bULL,
0x0000000f02027220ULL, 0x000fe40000410000ULL, 0x8000000e0d0d1221ULL, 0x000fe20000010000ULL,
0x00001f1a0f0c7589ULL, 0x000ea600000e0000ULL, 0x3fb8aa3b0d0d1820ULL, 0x000fe20000410000ULL,
0x01b4000e15008388ULL, 0x0007e60000000800ULL, 0x0000000d00501308ULL, 0x000f220000000800ULL,
0x000000003c3c7220ULL, 0x082fe20000410000ULL, 0x000000003d3d7220ULL, 0x080fe20000410000ULL,
0x0000000038387220ULL, 0x080fe20000410000ULL, 0x0000000039397220ULL, 0x080fe20000410000ULL,
0x0000000034347220ULL, 0x080fe20000410000ULL, 0x0000000035357220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x080fe20000410000ULL,
0x0000000028287220ULL, 0x080fe20000410000ULL, 0x0000000029297220ULL, 0x080fe20000410000ULL,
0x000000002c2c7220ULL, 0x080fe20000410000ULL, 0x000000002d2d7220ULL, 0x080fe20000410000ULL,
0x0000000030307220ULL, 0x080fe20000410000ULL, 0x0000000031317220ULL, 0x080fe20000410000ULL,
0x0000000024247220ULL, 0x080fe20000410000ULL, 0x0000000025257220ULL, 0x000fe20000410000ULL,
0x0000000c3e3e7220ULL, 0x084fe20000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000c36367220ULL, 0x080fe20000410000ULL, 0x0000000c37377220ULL, 0x080fe20000410000ULL,
0x0000000c12127220ULL, 0x080fe20000410000ULL, 0x0000000c13137220ULL, 0x080fe20000410000ULL,
0x0000000c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c32327220ULL, 0x080fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c26267220ULL, 0x080fe20000410000ULL, 0x0000000c27277220ULL, 0x000fe20000410000ULL,
0x0000000e00007202ULL, 0x000fe20000000f00ULL, 0x0000005d505d1220ULL, 0x018fce0000410000ULL,
0x00000050ff16723eULL, 0x000fe200000000ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x012000006420783bULL, 0x000fe20000000200ULL, 0x00000010720c7824ULL, 0x000fe200078e024cULL,
0x0000541016197816ULL, 0x000fe20000000016ULL, 0x0000001073157824ULL, 0x100fe200078e024cULL,
0x0000991014187816ULL, 0x000fe200000000ffULL, 0x0000001076407824ULL, 0x100fe200078e024cULL,
0x0000004c77447211ULL, 0x080fe200078e20ffULL, 0x000000000c0c783bULL, 0x000fe20000004200ULL,
0x000000ff1800720cULL, 0x000fe20003f05270ULL, 0x0000001066487824ULL, 0x100fe200078e024cULL,
0x0000004c681c7211ULL, 0x000fe200078e20ffULL, 0x00001f1719547589ULL, 0x000e6200000e0000ULL,
0x0000001067187824ULL, 0x000fe200078e024cULL, 0x0000000100727802ULL, 0x000fe20000000f00ULL,
0x000000025d027221ULL, 0x000fe20000010000ULL, 0x000000001514783bULL, 0x000fe80000004200ULL,
0x00001f1a19557589ULL, 0x000ea800000e0000ULL, 0x000000004444783bULL, 0x000ee80000004200ULL,
0x000000004040783bULL, 0x000f280000004200ULL, 0x000000004848783bULL, 0x000fe80000004200ULL,
0x000000001c1c783bULL, 0x000fe80000004200ULL, 0x000000001818783bULL, 0x000fe20000004200ULL,
0x0000005420208232ULL, 0x002fc40000000000ULL, 0x0000005422228232ULL, 0x000fe40000000000ULL,
0x0000005521218232ULL, 0x084fe40000000000ULL, 0x0000005523238232ULL, 0x000fce0000000000ULL,
0x0000000c203c723cULL, 0x000fec000000183cULL, 0x0000000e2038723cULL, 0x000fe20000001838ULL,
0x01200000630c783bULL, 0x000e6a0000000200ULL, 0x000000142034723cULL, 0x000fec0000001834ULL,
0x000000162010723cULL, 0x000fe20000001810ULL, 0x0000001069147824ULL, 0x000fca00078e024cULL,
0x000000442028723cULL, 0x008fe20000001828ULL, 0x000000001414783bULL, 0x000ea20000004200ULL,
0x01b698725fff79a7ULL, 0x0007e80008500009ULL, 0x00000046202c723cULL, 0x000fec000000182cULL,
0x000000402030723cULL, 0x010fec0000001830ULL, 0x000000422024723cULL, 0x000fe20000001824ULL,
0x000000540c0c8232ULL, 0x002fc40000000000ULL, 0x000000540e0e8232ULL, 0x000fe40000000000ULL,
0x000000550d0d8232ULL, 0x080fe40000000000ULL, 0x000000550f0f8232ULL, 0x000fce0000000000ULL,
0x000000480c3c723cULL, 0x000fec000000183cULL, 0x0000004a0c38723cULL, 0x000fe20000001838ULL,
0x0000000165497812ULL, 0x000fca00078e0cffULL, 0x0000001c0c34723cULL, 0x000fec0000001834ULL,
0x0000001e0c10723cULL, 0x000fec0000001810ULL, 0x000000180c28723cULL, 0x000fec0000001828ULL,
0x0000001a0c2c723cULL, 0x000fec000000182cULL, 0x000000140c30723cULL, 0x004fec0000001830ULL,
0x000000160c24723cULL, 0x000fee0000001824ULL, 0x000000c05c0d7811ULL, 0x000fc800078e40ffULL,
0x0000005e0d00720cULL, 0x000fda0003f06070ULL, 0x0000000c00840947ULL, 0x008fea0003800000ULL,
0x00000001510c7824ULL, 0x000fe200078e025cULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x000000010c0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000002074737824ULL, 0x000fc600078e00ffULL,
0x000000780d00720cULL, 0x000fe20003f06070ULL, 0x000001000c0e7824ULL, 0x000fc800078e0273ULL,
0x0000000475147c24ULL, 0x000fd0000f8e020eULL, 0x0000000000dc8947ULL, 0x000fea0003800000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0a0eULL, 0x0000000e5e0c7248ULL, 0x000fe20007fe0000ULL,
0x00000001031d7824ULL, 0x100fe200078e0214ULL, 0x00000014041b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000106197824ULL, 0x000fe200078e0214ULL, 0x000000200c1e7446ULL, 0x000fe2000380000dULL,
0x000001001d1c7825ULL, 0x000fe200078e004eULL, 0x0000004c56417211ULL, 0x000fe400078e20ffULL,
0x0000001e0300720cULL, 0x080fe20003fc6070ULL, 0x00000001050d7824ULL, 0x000fe200078e0214ULL,
0x0000001407177210ULL, 0x000fe20007ffe0ffULL, 0x000000100b1c7825ULL, 0x000fe200078e001cULL,
0x0000001e0400720cULL, 0x000fc40003fa6070ULL, 0x0000001e0500720cULL, 0x080fe20003f86070ULL,
0x0000000108157824ULL, 0x000fe200078e0214ULL, 0x0000001e0600720cULL, 0x080fe20003f66070ULL,
0x000001001b1a7825ULL, 0x000fe200078e004eULL, 0x000000140a037210ULL, 0x000fe40007ffe0ffULL,
0x0000001e0700720cULL, 0x080fe20003f46070ULL, 0x00000001090f7824ULL, 0x000fe200078e0214ULL,
0x0000001e0800720cULL, 0x080fe20003f26070ULL, 0x000001000d0c7825ULL, 0x100fe200078e004eULL,
0x0000001e0900720cULL, 0x080fe20003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c417faeULL, 0x0003e2000f101c46ULL, 0x0000001e0a00720cULL, 0x000fe20003fc6070ULL,
0x0000010019187825ULL, 0x000fe200078e004eULL, 0x0000004c5b5b7211ULL, 0x000fc400078e20ffULL,
0x0000004c58237211ULL, 0x000fe200078e20ffULL, 0x0000010017167825ULL, 0x000fc800078e004eULL,
0x0000010015147825ULL, 0x000fc800078e004eULL, 0x000001000f0e7825ULL, 0x000fc800078e004eULL,
0x0000001053537824ULL, 0x000fe400078e024cULL, 0x00000100034e7825ULL, 0x000fc800078e004eULL,
0x000000100b1a7825ULL, 0x000fc800078e001aULL, 0x00000010521f7824ULL, 0x000fe200078e024cULL,
0x000000001a537faeULL, 0x0003e2000e901c46ULL, 0x000000100b0c7825ULL, 0x000fc800078e000cULL,
0x000000100b187825ULL, 0x040fe200078e0018ULL, 0x000000000c1f7faeULL, 0x0003e6000e101c46ULL,
0x000000105a217824ULL, 0x000fe200078e024cULL, 0x00000000185b7faeULL, 0x0003e2000d901c46ULL,
0x000000100b167825ULL, 0x000fc800078e0016ULL, 0x0000001059597824ULL, 0x000fe200078e024cULL,
0x0000000016217faeULL, 0x0003e2000d101c46ULL, 0x000000100b147825ULL, 0x000fc800078e0014ULL,
0x000000100b0e7825ULL, 0x000fe200078e000eULL, 0x0000000014597faeULL, 0x0003e6000c901c46ULL,
0x0000001057577824ULL, 0x000fe200078e024cULL, 0x000000000e237faeULL, 0x0003e2000c101c46ULL,
0x000000100b4e7825ULL, 0x000fca00078e004eULL, 0x000000004e577faeULL, 0x0003e2000f101c46ULL,
0x0000000000ac7947ULL, 0x000fea0003800000ULL, 0x00000001030d7824ULL, 0x100fe200078e0214ULL,
0x0000001405157210ULL, 0x000fe20007ffe0ffULL, 0x00000001040f7824ULL, 0x100fe200078e0214ULL,
0x0000001408057210ULL, 0x000fe20007ffe0ffULL, 0x0000000106177824ULL, 0x100fe200078e0214ULL,
0x0000004c56037211ULL, 0x080fe200078e20ffULL, 0x0000000107077824ULL, 0x000fe200078e0214ULL,
0x0000004c5b5b7211ULL, 0x080fe200078e20ffULL, 0x000001000d0c7825ULL, 0x000fe200078e004eULL,
0x0000004c581f7211ULL, 0x000fc600078e20ffULL, 0x00000001091d7824ULL, 0x100fe400078e0214ULL,
0x000000010a217824ULL, 0x000fe400078e0214ULL, 0x000001000f0e7825ULL, 0x000fc800078e004eULL,
0x0000010015147825ULL, 0x000fc800078e004eULL, 0x0000010017167825ULL, 0x000fc800078e004eULL,
0x0000010007087825ULL, 0x000fc800078e004eULL, 0x0000010005047825ULL, 0x000fc800078e004eULL,
0x000001001d067825ULL, 0x000fc800078e004eULL, 0x000000100b0c7825ULL, 0x000fc800078e000cULL,
0x0000001053537824ULL, 0x000fe200078e024cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c037faeULL, 0x0003e2000b901c46ULL, 0x00000100214e7825ULL, 0x000fc800078e004eULL,
0x000000100b0e7825ULL, 0x000fc800078e000eULL, 0x0000001052197824ULL, 0x000fe200078e024cULL,
0x000000000e537faeULL, 0x0003e2000b901c46ULL, 0x000000100b147825ULL, 0x000fc800078e0014ULL,
0x000000100b167825ULL, 0x040fe200078e0016ULL, 0x0000000014197faeULL, 0x0003e6000b901c46ULL,
0x000000105a1b7824ULL, 0x000fe200078e024cULL, 0x00000000165b7faeULL, 0x0003e2000b901c46ULL,
0x000000100b087825ULL, 0x000fc800078e0008ULL, 0x0000001059597824ULL, 0x000fe200078e024cULL,
0x00000000081b7faeULL, 0x0003e2000b901c46ULL, 0x000000100b047825ULL, 0x000fc800078e0004ULL,
0x000000100b067825ULL, 0x000fe200078e0006ULL, 0x0000000004597faeULL, 0x0003e6000b901c46ULL,
0x0000001057577824ULL, 0x000fe200078e024cULL, 0x00000000061f7faeULL, 0x0003e2000b901c46ULL,
0x000000100b4e7825ULL, 0x000fca00078e004eULL, 0x000000004e577faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01b66872620479a7ULL, 0x002e62000850003fULL,
0x00000001ff037819ULL, 0x000fe4000001167aULL, 0x000001807b617810ULL, 0x000fe40007ffe061ULL,
0x0000000c03037812ULL, 0x000fca00078ec0ffULL, 0x0000000103617824ULL, 0x000fe200078e0261ULL,
0x01b66805620075a7ULL, 0x002e64000800017fULL, 0x0000009400588947ULL, 0x002fea0003800000ULL,
0x01b0000061057984ULL, 0x000e620000000800ULL, 0x00000002ff167819ULL, 0x000fe4000001167aULL,
0x0000000100147802ULL, 0x000fc60000000f00ULL, 0x0000000816157836ULL, 0x000fe20000000000ULL,
0x000000000500720bULL, 0x002fda0003f1d000ULL, 0x0000000000037806ULL, 0x000fc800000e0100ULL,
0x0000ffff03087812ULL, 0x000fe4000780c0ffULL, 0x01b2000061037984ULL, 0x0002b60000000800ULL,
0x0000000000e08947ULL, 0x002fea0003800000ULL, 0x000000000500720bULL, 0x000fe40003f14000ULL,
0x00000005000a7209ULL, 0x000fe40007810000ULL, 0x00000001ff0b7819ULL, 0x000fc6000001167aULL,
0x8000000a00047221ULL, 0x000fe20000010000ULL, 0x000000034d007811ULL, 0x000fe400078ff0ffULL,
0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b04067820ULL, 0x000fe40000410000ULL,
0x0000000000047806ULL, 0x000fe400000e0100ULL, 0x0000004d0000720cULL, 0x000fe20003f05270ULL,
0x0000000600077308ULL, 0x000e620000000800ULL, 0x0000ffff04097812ULL, 0x000fc800078e3cffULL,
0x0000000908ff7212ULL, 0x000fc8000782c0ffULL, 0x00000001ff147807ULL, 0x000fc60000800000ULL,
0x000000094d048c11ULL, 0x000fe2000f8e38ffULL, 0x00001f1607007589ULL, 0x002e6600000e0000ULL,
0x000000040b7b8210ULL, 0x000fe20007ffe07bULL, 0x0000000702027220ULL, 0x000fe20000410000ULL,
0x8000000a05051221ULL, 0x100fe20000010000ULL, 0x00001f1507047589ULL, 0x000ee600000e0000ULL,
0x3fb8aa3b05051820ULL, 0x000fe20000410000ULL, 0x01b4000a7b008388ULL, 0x0009e60000000800ULL,
0x0000000500501308ULL, 0x000f620000000800ULL, 0x000000003c3c7220ULL, 0x082fe20000410000ULL,
0x000000003d3d7220ULL, 0x080fe20000410000ULL, 0x0000000038387220ULL, 0x080fe20000410000ULL,
0x0000000039397220ULL, 0x080fe20000410000ULL, 0x0000000034347220ULL, 0x080fe20000410000ULL,
0x0000000035357220ULL, 0x080fe20000410000ULL, 0x0000000010107220ULL, 0x080fe20000410000ULL,
0x0000000011117220ULL, 0x080fe20000410000ULL, 0x0000000028287220ULL, 0x080fe20000410000ULL,
0x0000000029297220ULL, 0x080fe20000410000ULL, 0x000000002c2c7220ULL, 0x080fe20000410000ULL,
0x000000002d2d7220ULL, 0x080fe20000410000ULL, 0x0000000030307220ULL, 0x080fe20000410000ULL,
0x0000000031317220ULL, 0x080fe20000410000ULL, 0x0000000024247220ULL, 0x080fe20000410000ULL,
0x0000000025257220ULL, 0x000fe20000410000ULL, 0x000000043e3e7220ULL, 0x088fe20000410000ULL,
0x000000043f3f7220ULL, 0x080fe20000410000ULL, 0x000000043a3a7220ULL, 0x080fe20000410000ULL,
0x000000043b3b7220ULL, 0x080fe20000410000ULL, 0x0000000436367220ULL, 0x080fe20000410000ULL,
0x0000000437377220ULL, 0x080fe20000410000ULL, 0x0000000412127220ULL, 0x080fe20000410000ULL,
0x0000000413137220ULL, 0x080fe20000410000ULL, 0x000000042a2a7220ULL, 0x080fe20000410000ULL,
0x000000042b2b7220ULL, 0x080fe20000410000ULL, 0x000000042e2e7220ULL, 0x080fe20000410000ULL,
0x000000042f2f7220ULL, 0x080fe20000410000ULL, 0x0000000432327220ULL, 0x080fe20000410000ULL,
0x0000000433337220ULL, 0x080fe20000410000ULL, 0x0000000426267220ULL, 0x080fe20000410000ULL,
0x0000000427277220ULL, 0x000fe20000410000ULL, 0x000000ffff007224ULL, 0x000fc400078e000aULL,
0x0000000350031220ULL, 0x034fce0000410000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x012800006464783bULL, 0x000fe20000000200ULL, 0x00000050ff08723eULL, 0x000fe200000000ffULL,
0x0000000203027221ULL, 0x004fe20000010000ULL, 0x0000991014187816ULL, 0x000fe200000000ffULL,
0x000000007104783bULL, 0x000fe20000004200ULL, 0x0000541008227816ULL, 0x000fe20000000008ULL,
0x000000ffff497224ULL, 0x000fe200078e0060ULL, 0x000000ff1800720cULL, 0x000fe20003f05270ULL,
0x000000007070783bULL, 0x000fe20000004200ULL, 0x0000000100237802ULL, 0x000fc60000000f00ULL,
0x000000006f08783bULL, 0x000fe80000004200ULL, 0x000000006e0c783bULL, 0x000fe80000004200ULL,
0x00001f1622207589ULL, 0x000e6800000e0000ULL, 0x00001f1522217589ULL, 0x000ea800000e0000ULL,
0x012800006314783bULL, 0x000ee80000000200ULL, 0x000000006d18783bULL, 0x000f280000004200ULL,
0x000000006b1c783bULL, 0x000fe80000004200ULL, 0x000000006c6c783bULL, 0x000f680000004200ULL,
0x000000006a68783bULL, 0x000f220000004200ULL, 0x0000002064648232ULL, 0x082fe20000000000ULL,
0x01b6a0235fff79a7ULL, 0x0003e20008500009ULL, 0x0000002066668232ULL, 0x000fc40000000000ULL,
0x0000002165658232ULL, 0x084fe40000000000ULL, 0x0000002167678232ULL, 0x000fce0000000000ULL,
0x00000004643c723cULL, 0x000fec000000183cULL, 0x000000066438723cULL, 0x000fe20000001838ULL,
0x0000002014148232ULL, 0x008fca0000000000ULL, 0x000000706434723cULL, 0x000fe20000001834ULL,
0x0000002016168232ULL, 0x000fe40000000000ULL, 0x0000002115158232ULL, 0x080fe40000000000ULL,
0x0000002117178232ULL, 0x000fe20000000000ULL, 0x000000726410723cULL, 0x000fec0000001810ULL,
0x000000086428723cULL, 0x000fec0000001828ULL, 0x0000000a642c723cULL, 0x000fec000000182cULL,
0x0000000c6430723cULL, 0x000fec0000001830ULL, 0x0000000e6424723cULL, 0x000fec0000001824ULL,
0x00000018143c723cULL, 0x010fec000000183cULL, 0x0000001a1438723cULL, 0x000fec0000001838ULL,
0x0000006c1434723cULL, 0x020fec0000001834ULL, 0x0000006e1410723cULL, 0x000fec0000001810ULL,
0x0000001c1428723cULL, 0x000fec0000001828ULL, 0x0000001e142c723cULL, 0x000fec000000182cULL,
0x000000681430723cULL, 0x000fec0000001830ULL, 0x0000006a1424723cULL, 0x002fde0000001824ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x00000001515c7824ULL, 0x000fca00078e025cULL,
0x000000785c00720cULL, 0x000fda0003f06070ULL, 0xffffffbc00048947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000e620000002500ULL, 0x0000001200147202ULL, 0x000fe40000000f00ULL,
0x000000780300720cULL, 0x002fda0003f06070ULL, 0x0000000000c80947ULL, 0x000fea0003800000ULL,
0x0180000002047836ULL, 0x000fca0000000000ULL, 0x7f80000004047812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x000058c000077802ULL, 0x000fce0000000f00ULL, 0x0000009400087944ULL, 0x000fea0003c00000ULL,
0x000000ffff047224ULL, 0x000fe200078e0006ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000200057308ULL, 0x000e640000001000ULL, 0xbf80000005047423ULL, 0x002fc80000000002ULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x0000000405047223ULL, 0x000fce0000000005ULL,
0x0000000000077919ULL, 0x000ea40000000000ULL, 0x00000002ff057819ULL, 0x004fe40000011607ULL,
0x0000000807077811ULL, 0x000fe200078ff0ffULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0504057589ULL, 0x000ea800000e0000ULL, 0x00001f0704077589ULL, 0x000ee200000e0000ULL,
0x0000003c053c7220ULL, 0x044fe20000410000ULL, 0x0000003d053d7220ULL, 0x040fe20000410000ULL,
0x0000003805387220ULL, 0x040fe20000410000ULL, 0x0000003905397220ULL, 0x040fe20000410000ULL,
0x0000003405347220ULL, 0x040fe20000410000ULL, 0x0000003505357220ULL, 0x040fe20000410000ULL,
0x0000001005107220ULL, 0x040fe20000410000ULL, 0x0000001105117220ULL, 0x040fe20000410000ULL,
0x0000002805287220ULL, 0x040fe20000410000ULL, 0x0000002905297220ULL, 0x040fe20000410000ULL,
0x0000002c052c7220ULL, 0x040fe20000410000ULL, 0x0000002d052d7220ULL, 0x040fe20000410000ULL,
0x0000003005307220ULL, 0x040fe20000410000ULL, 0x0000003105317220ULL, 0x040fe20000410000ULL,
0x0000002405247220ULL, 0x040fe20000410000ULL, 0x0000002505257220ULL, 0x000fe20000410000ULL,
0x0000003e073e7220ULL, 0x048fe20000410000ULL, 0x0000003f073f7220ULL, 0x040fe20000410000ULL,
0x0000003a073a7220ULL, 0x040fe20000410000ULL, 0x0000003b073b7220ULL, 0x040fe20000410000ULL,
0x0000003607367220ULL, 0x040fe20000410000ULL, 0x0000003707377220ULL, 0x040fe20000410000ULL,
0x0000001407147220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000002a072a7220ULL, 0x040fe20000410000ULL, 0x0000002b072b7220ULL, 0x040fe20000410000ULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0x0000002f072f7220ULL, 0x040fe20000410000ULL,
0x0000003207327220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x040fe20000410000ULL,
0x0000002607267220ULL, 0x040fe20000410000ULL, 0x0000002707277220ULL, 0x000fce0000410000ULL,
0x0000000000177919ULL, 0x000ea20000000000ULL, 0x0000000979157c11ULL, 0x000fe2000f8e60ffULL,
0x0000002074167824ULL, 0x040fe200078e00ffULL, 0x000000141313723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000001574147211ULL, 0x000fe400078e58ffULL,
0x00000038390d723eULL, 0x000fe400000000ffULL, 0x00000034350e723eULL, 0x000fe400000000ffULL,
0x00000010110f723eULL, 0x000fc400000000ffULL, 0x0000003e3f10723eULL, 0x000fe400000000ffULL,
0x0000003a3b11723eULL, 0x000fe400000000ffULL, 0x000000363712723eULL, 0x000fe400000000ffULL,
0x0000002a2b18723eULL, 0x000fe400000000ffULL, 0x0000002e2f19723eULL, 0x000fe400000000ffULL,
0x00000032331a723eULL, 0x000fc400000000ffULL, 0x00000026271b723eULL, 0x000fe400000000ffULL,
0x000000015100780cULL, 0x000fe40003f05270ULL, 0x00000003ff047819ULL, 0x004fe40000011617ULL,
0xfffffff8ff067812ULL, 0x000fe400078ee217ULL, 0x0000000304057812ULL, 0x000fe400078ec0ffULL,
0x00000008060a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000806077824ULL, 0x000fe200078e00ffULL,
0x0000000405097812ULL, 0x000fc400078efcffULL, 0x0000000705087812ULL, 0x000fe200078e7806ULL,
0x000000080a0b7824ULL, 0x000fe200078e00ffULL, 0x0000000709067812ULL, 0x000fe400078e7806ULL,
0x00000007050c7812ULL, 0x000fe400078e780aULL, 0x00000007090a7812ULL, 0x000fe400078e780aULL,
0x0000000708057212ULL, 0x080fe400078efcffULL, 0x0000000706077212ULL, 0x000fc400078efcffULL,
0x0000000b0c1d7212ULL, 0x080fe200078efcffULL, 0x0000001005057824ULL, 0x100fe200078e0214ULL,
0x0000000b0a1f7212ULL, 0x000fe200078efcffULL, 0x0000001007077824ULL, 0x100fe200078e0214ULL,
0x0000003c3d0c723eULL, 0x000fe200000000ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0214ULL,
0x000000282908723eULL, 0x000fe400000000ffULL, 0x0000002c2d09723eULL, 0x000fe200000000ffULL,
0x0000000c05007844ULL, 0x000fe20000000200ULL, 0x00000030310a723eULL, 0x000fc400000000ffULL,
0x00000024250b723eULL, 0x000fe400000000ffULL, 0x000000141f1f7211ULL, 0x000fe400078e20ffULL,
0x00000017161c7210ULL, 0x000fe20007ffe0ffULL, 0x0000000807007844ULL, 0x000fe80000000200ULL,
0x000000101d007844ULL, 0x000fe20000000200ULL, 0x000000101c1e7824ULL, 0x000fc600078e0215ULL,
0x000000181f007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000001e207984ULL, 0x000ea80000000c00ULL, 0x000400001e287984ULL, 0x000ee80000000c00ULL,
0x000800001e247984ULL, 0x000f280000000c00ULL, 0x000c00001e2c7984ULL, 0x000f620000000c00ULL,
0x200000ff23237230ULL, 0x004fc40000000000ULL, 0x200000ff22227230ULL, 0x000fe40000000000ULL,
0x200000ff21217230ULL, 0x000fe40000000000ULL, 0x200000ff20207230ULL, 0x000fe40000000000ULL,
0x200000ff2b2b7230ULL, 0x008fe40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fe40000000000ULL,
0x200000ff29297230ULL, 0x000fc40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x0000002723237230ULL, 0x010fe40000000000ULL, 0x0000002622227230ULL, 0x000fe40000000000ULL,
0x0000002521217230ULL, 0x000fe40000000000ULL, 0x0000002420207230ULL, 0x000fe40000000000ULL,
0x0000002f2b2b7230ULL, 0x020fc40000000000ULL, 0x0000002e2a2a7230ULL, 0x000fe20000000000ULL,
0x000000201e007388ULL, 0x0005e20000000c00ULL, 0x0000002d29297230ULL, 0x000fe40000000000ULL,
0x0000002c28287230ULL, 0x000fca0000000000ULL, 0x000400281e007388ULL, 0x0005e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000002400dc8947ULL, 0x000fea0003800000ULL,
0x0000000000127919ULL, 0x000ee20000002700ULL, 0x00008400ff087b82ULL, 0x000ee20000000800ULL,
0x0000000174ff7812ULL, 0x000fe2000780f84dULL, 0x0000000000057919ULL, 0x000ee20000002600ULL,
0x0000000a79187819ULL, 0x000fe400000006ffULL, 0x00000400001b7802ULL, 0x000fe20000000f00ULL,
0x00000000000e7919ULL, 0x000f240000008800ULL, 0x00009000ff0c7b82ULL, 0x000f700000000800ULL,
0x00009600ff067b82ULL, 0x000f620000000a00ULL, 0x0000000812127224ULL, 0x008fc400078e0205ULL,
0x0000000851057224ULL, 0x000fe400078e02ffULL, 0x000000001e087984ULL, 0x0006a20000000c00ULL,
0x0000005112197224ULL, 0x000fe200078e02ffULL, 0x000006540e1b7816ULL, 0x010fe2000000001bULL,
0x0000000c05057224ULL, 0x020fe400078e02ffULL, 0x0000000119037824ULL, 0x000fc600078e0203ULL,
0x000007ff05167811ULL, 0x040fe400078e40ffULL, 0x01ffffff051a7812ULL, 0x000fe400078ec0ffULL,
0x00000003160d7211ULL, 0x000fca00078fa8ffULL, 0x000008000d0c7825ULL, 0x002fc600078e0006ULL,
0x000000180c107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e060dULL,
0x000000ff1700720cULL, 0x000fe20000725670ULL, 0x000000101c107825ULL, 0x000fe200078e0010ULL,
0x0000000000380947ULL, 0x008ff60003800000ULL, 0x00009600ff0e7b82ULL, 0x000e620000000a00ULL,
0x0000000103057824ULL, 0x000fe200078e021aULL, 0x0000000417137819ULL, 0x000fe400000006ffULL,
0x00000001ff1c7819ULL, 0x000fe40000011617ULL, 0x0000007013137812ULL, 0x000fe400078ec0ffULL,
0x0000000c1c1c7812ULL, 0x000fe200078ec0ffULL, 0x00000080030c7825ULL, 0x002fc800078e000eULL,
0x00000080050e7825ULL, 0x000fe200078e000eULL, 0x0000000c1c0c7210ULL, 0x140fe40007a1e013ULL,
0x0000000e1c0e7210ULL, 0x000fe40007c7e013ULL, 0x0000000dff0d7210ULL, 0x000fe400007e44ffULL,
0x0000000fff0f7210ULL, 0x000fc60001fe84ffULL, 0x000000000c007986ULL, 0x0003e8000c101906ULL,
0x000000020e007986ULL, 0x0003e4000c101906ULL, 0x0000000810007986ULL, 0x0045e2000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000004c1947ULL, 0x000fea0003800000ULL,
0x00009400ff027b82ULL, 0x002e620000000a00ULL, 0xffffffff51057836ULL, 0x000fe40000000000ULL,
0x0000000412027825ULL, 0x002fe200078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0003ec0000008000ULL,
0x0000000000007992ULL, 0x002fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000005020279a8ULL, 0x000ee800099ee1c6ULL,
0x00000000ff00798fULL, 0x008fe20002000000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fc40000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x000000050200720cULL, 0x000fc80003f05270ULL, 0x00000001ff007807ULL, 0x000fca0000000000ULL,
0x00000000ff007988ULL, 0x0003e80008000004ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000001b007984ULL, 0x002e640000000000ULL,
0x000000ff0000720cULL, 0x002fda0003f05270ULL, 0x0000002000d48947ULL, 0x000fea0003800000ULL,
0x000000ff4d00720cULL, 0x000fda0003f05270ULL, 0x0000000c00300947ULL, 0x000fea0003800000ULL,
0x000000ff5100720cULL, 0x000fda0003f05270ULL, 0x0000000000d88947ULL, 0x000fea0003800000ULL,
0x00000001ff047819ULL, 0x000fe20000011617ULL, 0x0000001017007824ULL, 0x000fe200078e00ffULL,
0x0000000119057810ULL, 0x000fe20007ffe0ffULL, 0x0000008019027825ULL, 0x100fe200078e0006ULL,
0x0000000c04087812ULL, 0x004fe400078ec0ffULL, 0x0000007000137812ULL, 0x000fe200078ec0ffULL,
0x0000008005047825ULL, 0x000fc600078e0006ULL, 0x0000000208027210ULL, 0x140fe4000791e013ULL,
0x0000000408047210ULL, 0x000fe40007b5e013ULL, 0x00000003ff037210ULL, 0x000fe400007e24ffULL,
0x00000005ff057210ULL, 0x000fc600017e64ffULL, 0x0000000602007981ULL, 0x000368000c1e1900ULL,
0x0000000604097981ULL, 0x000362000c1e1900ULL, 0x000000025100780cULL, 0x000fda0003f05270ULL,
0x00000000009c8947ULL, 0x002fea0003800000ULL, 0x0000000219037836ULL, 0x000fc80000000000ULL,
0x0000008003027825ULL, 0x000fc600078e0006ULL, 0x0000000208027210ULL, 0x000fc8000791e013ULL,
0x00000003ff037210ULL, 0x000fca00007e24ffULL, 0x00000006020b7981ULL, 0x000362000c1e1900ULL,
0x000000045100780cULL, 0x000fda0003f06070ULL, 0x0000000000808947ULL, 0x002fea0003800000ULL,
0x0000000319037836ULL, 0x000fc80000000000ULL, 0x0000008003027825ULL, 0x000fc600078e0006ULL,
0x0000000208027210ULL, 0x000fc8000791e013ULL, 0x00000003ff037210ULL, 0x000fca00007e24ffULL,
0x00000006020d7981ULL, 0x000362000c1e1900ULL, 0x000000045100780cULL, 0x000fda0003f05270ULL,
0x0000000000648947ULL, 0x002fea0003800000ULL, 0x0000000419037810ULL, 0x000fca0007ffe0ffULL,
0x0000008003027825ULL, 0x000fc600078e0006ULL, 0x0000000208027210ULL, 0x000fc8000791e013ULL,
0x00000003ff037210ULL, 0x000fca00007e24ffULL, 0x00000006020f7981ULL, 0x000362000c1e1900ULL,
0x000000065100780cULL, 0x000fda0003f06070ULL, 0x0000000000488947ULL, 0x002fea0003800000ULL,
0x0000000519037836ULL, 0x000fc80000000000ULL, 0x0000008003027825ULL, 0x000fc600078e0006ULL,
0x0000000208027210ULL, 0x000fc8000791e013ULL, 0x00000003ff037210ULL, 0x000fca00007e24ffULL,
0x0000000602117981ULL, 0x000362000c1e1900ULL, 0x000000065100780cULL, 0x000fda0003f05270ULL,
0x00000000002c8947ULL, 0x002fea0003800000ULL, 0x000000085100780cULL, 0x000fe20003f06070ULL,
0x0000000619037836ULL, 0x000fc80000000000ULL, 0x0000008003027825ULL, 0x000fc600078e0006ULL,
0x0000000208027210ULL, 0x000fca0007a3e013ULL, 0x0000000719050810ULL, 0x000fe40007ffe0ffULL,
0x00000003ff037210ULL, 0x000fc60000fe44ffULL, 0x0000008005060825ULL, 0x000fc600078e0006ULL,
0x0000000608040210ULL, 0x000fc80007c7e013ULL, 0x00000007ff050210ULL, 0x000fe40001fe84ffULL,
0x0000000602077981ULL, 0x000368000c1e1900ULL, 0x0000000604130981ULL, 0x000366000c1e1900ULL,
0x0000000751027836ULL, 0x002fca0000000000ULL, 0x00000003ff067819ULL, 0x000fc80000011602ULL,
0x000000ff0600720cULL, 0x000fda0003f05270ULL, 0x0000000800248947ULL, 0x000fea0003800000ULL,
0x00009600ff027b82ULL, 0x000e620000000a00ULL, 0x000000ffff087224ULL, 0x004fe200078e0019ULL,
0x00000000001d7202ULL, 0x020fe20000000f00ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x0000003f00057c82ULL, 0x000fca0008000000ULL, 0x0000000451007c0cULL, 0x000fe2000bf23070ULL,
0x0000000105057890ULL, 0x000fcc000fffe03fULL, 0x0000000506007c0cULL, 0x000fcc000bf03070ULL,
0x0000000400f41947ULL, 0x022fee0003800000ULL, 0x0000000804087890ULL, 0x000fe2000fffe03fULL,
0x0000001d00007209ULL, 0x000fe20007810000ULL, 0x0000000104097890ULL, 0x000fc8000fffe03fULL,
0x0000000851007c0cULL, 0x040fe4000bf23070ULL, 0x0000000951007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x0000001017047824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011617ULL, 0x0000000808057836ULL, 0x000fc60000000000ULL,
0x00000070041d7812ULL, 0x000fe200078ec0ffULL, 0x0000008005047825ULL, 0x002fe200078e0002ULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000040a047210ULL, 0x000fc80007b3e01dULL,
0x00000005ff057210ULL, 0x000fca0000fe64ffULL, 0x00000006041d7981ULL, 0x000368000c1e1900ULL,
0x0000000400b42947ULL, 0x000fea0003800000ULL, 0x0000000904087890ULL, 0x000fe2000fffe03fULL,
0x0000000900007209ULL, 0x000fe20007810000ULL, 0x0000000204097890ULL, 0x000fc8000fffe03fULL,
0x0000000851007c0cULL, 0x040fe4000bf23070ULL, 0x0000000951007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x0000000417047819ULL, 0x002fe200000006ffULL,
0x0000000908057836ULL, 0x000fe20000000000ULL, 0x00000001ff0a7819ULL, 0x000fe40000011617ULL,
0x0000007004097812ULL, 0x000fe200078ec0ffULL, 0x0000008005047825ULL, 0x000fe200078e0002ULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000040a047210ULL, 0x000fc80007b3e009ULL,
0x00000005ff057210ULL, 0x000fca0000fe64ffULL, 0x0000000604097981ULL, 0x000368000c1e1900ULL,
0x0000000400742947ULL, 0x000fea0003800000ULL, 0x0000000a04087890ULL, 0x000fe2000fffe03fULL,
0x0000000b00007209ULL, 0x000fe20007810000ULL, 0x0000000304097890ULL, 0x000fc8000fffe03fULL,
0x0000000851007c0cULL, 0x040fe4000bf23070ULL, 0x0000000951007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x0000001017047824ULL, 0x002fe200078e00ffULL,
0x0000000a08057810ULL, 0x000fe40007ffe0ffULL, 0x00000001ff0a7819ULL, 0x000fe40000011617ULL,
0x00000070040b7812ULL, 0x000fe200078ec0ffULL, 0x0000008005047825ULL, 0x000fe200078e0002ULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000040a047210ULL, 0x000fc80007b3e00bULL,
0x00000005ff057210ULL, 0x000fca0000fe64ffULL, 0x00000006040b7981ULL, 0x000368000c1e1900ULL,
0x0000000400342947ULL, 0x000fea0003800000ULL, 0x0000000b04087890ULL, 0x000fe2000fffe03fULL,
0x0000000d00007209ULL, 0x000fe20007810000ULL, 0x0000000404097890ULL, 0x000fc8000fffe03fULL,
0x0000000851007c0cULL, 0x040fe4000bf23070ULL, 0x0000000951007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x0000001017047824ULL, 0x002fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011617ULL, 0x0000000b08057836ULL, 0x000fc60000000000ULL,
0x00000070040d7812ULL, 0x000fe200078ec0ffULL, 0x0000008005047825ULL, 0x000fe200078e0002ULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000040a047210ULL, 0x000fc80007b3e00dULL,
0x00000005ff057210ULL, 0x000fca0000fe64ffULL, 0x00000006040d7981ULL, 0x000368000c1e1900ULL,
0x0000000000f42947ULL, 0x000fea0003800000ULL, 0x0000000c04087890ULL, 0x000fe2000fffe03fULL,
0x0000000f00007209ULL, 0x000fe20007810000ULL, 0x0000000504097890ULL, 0x000fc8000fffe03fULL,
0x0000000851007c0cULL, 0x040fe4000bf23070ULL, 0x0000000951007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x0000000417047819ULL, 0x002fe200000006ffULL,
0x0000000c08057836ULL, 0x000fe20000000000ULL, 0x00000001ff0a7819ULL, 0x000fe40000011617ULL,
0x00000070040f7812ULL, 0x000fe200078ec0ffULL, 0x0000008005047825ULL, 0x000fe200078e0002ULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000040a047210ULL, 0x000fc80007b3e00fULL,
0x00000005ff057210ULL, 0x000fca0000fe64ffULL, 0x00000006040f7981ULL, 0x000368000c1e1900ULL,
0x0000000000b42947ULL, 0x000fea0003800000ULL, 0x0000000d04087890ULL, 0x000fe2000fffe03fULL,
0x0000001100007209ULL, 0x000fe20007810000ULL, 0x0000000604097890ULL, 0x000fc8000fffe03fULL,
0x0000000851007c0cULL, 0x040fe4000bf23070ULL, 0x0000000951007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x0000001017047824ULL, 0x002fe200078e00ffULL,
0x0000000d08057810ULL, 0x000fe40007ffe0ffULL, 0x00000001ff0a7819ULL, 0x000fe40000011617ULL,
0x0000007004117812ULL, 0x000fe200078ec0ffULL, 0x0000008005047825ULL, 0x000fe200078e0002ULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000040a047210ULL, 0x000fc80007b3e011ULL,
0x00000005ff057210ULL, 0x000fca0000fe64ffULL, 0x0000000604117981ULL, 0x000368000c1e1900ULL,
0x0000000000742947ULL, 0x000fea0003800000ULL, 0x0000000e04087890ULL, 0x000fe2000fffe03fULL,
0x0000000700007209ULL, 0x000fe20007810000ULL, 0x0000000704097890ULL, 0x000fc8000fffe03fULL,
0x0000000851007c0cULL, 0x040fe4000bf23070ULL, 0x0000000951007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x0000001017047824ULL, 0x002fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011617ULL, 0x0000000e08057836ULL, 0x000fc60000000000ULL,
0x0000007004077812ULL, 0x000fe200078ec0ffULL, 0x0000008005047825ULL, 0x000fe200078e0002ULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000040a047210ULL, 0x000fc80007b3e007ULL,
0x00000005ff057210ULL, 0x000fca0000fe64ffULL, 0x0000000604077981ULL, 0x000368000c1e1900ULL,
0x0000000000342947ULL, 0x000fea0003800000ULL, 0x0000000f04087890ULL, 0x000fe2000fffe03fULL,
0x0000001300007209ULL, 0x000fca0007810000ULL, 0x0000000851007c0cULL, 0x000fda000bf23070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x0000000417047819ULL, 0x002fe200000006ffULL,
0x0000000f08057836ULL, 0x000fe20000000000ULL, 0x00000001ff0a7819ULL, 0x000fe40000011617ULL,
0x0000007004137812ULL, 0x000fe200078ec0ffULL, 0x0000008005047825ULL, 0x000fe200078e0002ULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000040a047210ULL, 0x000fc80007a3e013ULL,
0x00000005ff057210ULL, 0x000fca0000fe44ffULL, 0x0000000604137981ULL, 0x000368000c1e1900ULL,
0x0000000804047890ULL, 0x000fe2000fffe03fULL, 0x0000000808087836ULL, 0x000fe20000000000ULL,
0xfffffff400f08947ULL, 0x000ff4000383ffffULL, 0x0000000000177919ULL, 0x000ee40000000000ULL,
0x0000000417027819ULL, 0x00afe400000006ffULL, 0x00000001ff037819ULL, 0x000fe40000011617ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000001b03037210ULL, 0x000fca0007ffe002ULL, 0x0000000003007388ULL, 0x0203e40000000800ULL,
0x00009600ff067b82ULL, 0x000ee20000000a00ULL, 0x000000071700780cULL, 0x040fe20003f04070ULL,
0x0000000174097824ULL, 0x004fe200078e0219ULL, 0x00000002ff007819ULL, 0x002fe2000001164dULL,
0x00000010171c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff1d7819ULL, 0x000fe20000011617ULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x0000000100007812ULL, 0x000fe400078ec0ffULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000916037211ULL, 0x000fc400078fa8ffULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000020170d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x000000701c1c7812ULL, 0x000fe200078ec0ffULL,
0x0000020074048824ULL, 0x040fe200078e021bULL, 0x0000001b74088211ULL, 0x000fe400078e48ffULL,
0x0000000000207805ULL, 0x000fc4000001ff00ULL, 0x0000000c1d1d7812ULL, 0x000fe200078ec0ffULL,
0x0000010079058824ULL, 0x040fe200078e0204ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000100790b8824ULL, 0x000fe200078e0208ULL, 0x0000001b1d1e7210ULL, 0x000fe20007ffe01cULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000005000a8211ULL, 0x040fe200078e38ffULL,
0x00000080000c8824ULL, 0x000fe200078e020bULL, 0x000000094d057819ULL, 0x000fe200000006ffULL,
0x0000200074007824ULL, 0x000fe200078e021bULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000080003027825ULL, 0x008fe200078e0006ULL, 0x0000080005057812ULL, 0x000fc400078ec0ffULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000c170f8211ULL, 0x000fe200078e20ffULL,
0x0000100079007824ULL, 0x000fe200078e0200ULL, 0x0000001802027210ULL, 0x000fe20007f3e0ffULL,
0x000000011a0b8824ULL, 0x000fe200078e0209ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000008009088825ULL, 0x000fe200078e0006ULL, 0x0000000500047210ULL, 0x000fe40007ffe0ffULL,
0x00000000003e7805ULL, 0x000fc4000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x000000ffff037224ULL, 0x000fe200008e0603ULL, 0x000000517400720cULL, 0x000fe20003f26070ULL,
0x000000800b068825ULL, 0x000fe200078e0006ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000010170b7824ULL, 0x000fe200078e0204ULL, 0x000000001e1e7984ULL, 0x000e620000000800ULL,
0x000000100d047825ULL, 0x000fe200078e0002ULL, 0x00000000003c7805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000001017027825ULL, 0x000fc800078e0002ULL, 0x0000001017068825ULL, 0x040fe200078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000020b7faeULL, 0x0005e6000b901c46ULL,
0x00000010170d8824ULL, 0x040fe200078e020aULL, 0x00380000040b7faeULL, 0x0005e2000b901c46ULL,
0x0000001017088825ULL, 0x000fc600078e0008ULL, 0x04580000060d8faeULL, 0x0005e8000b901c46ULL,
0x04180000080f8faeULL, 0x0005e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000800641947ULL, 0x000fea0003800000ULL, 0x00000003ff027819ULL, 0x004fe20000011617ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0074ULL, 0xfffffff8ff057812ULL, 0x000fe400078ee217ULL,
0x0000000302047812ULL, 0x000fe400078ec0ffULL, 0x00009600ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000805077836ULL, 0x040fe20000000000ULL, 0x0000000404087812ULL, 0x000fe400078efcffULL,
0x0000000305437819ULL, 0x000fe200000006ffULL, 0x0000000807457824ULL, 0x000fe200078e00ffULL,
0x0000000704067812ULL, 0x000fc400078e7805ULL, 0x0000000704447812ULL, 0x000fe400078e7807ULL,
0x0000000708047812ULL, 0x000fe400078e7805ULL, 0x0000004306417212ULL, 0x080fe400078efcffULL,
0x0000004304437212ULL, 0x000fe200078efcffULL, 0x0000020074047824ULL, 0x000fe200078e021bULL,
0x0000000708087812ULL, 0x000fe400078e7807ULL, 0x00000002ff467819ULL, 0x000fe20000011617ULL,
0x0000010079477824ULL, 0x000fe200078e0204ULL, 0x0000004544447212ULL, 0x000fc400078efcffULL,
0x0000004508457212ULL, 0x000fe400078efcffULL, 0x000000ff001f7202ULL, 0x000fe40000000f00ULL,
0x0000000846407810ULL, 0x004fce0007ffe0ffULL, 0x000000020c427836ULL, 0x000fca0000000000ULL,
0x000000514200720cULL, 0x000fda0003f06070ULL, 0x00000000008c0947ULL, 0x000fea0003800000ULL,
0x00000001190b7824ULL, 0x000fe200078e0242ULL, 0x000000071700780cULL, 0x000fe20003f24070ULL,
0x0000040042067824ULL, 0x000fc600078e00ffULL, 0x0000000b16057211ULL, 0x000fe400078fa8ffULL,
0x0000080006077812ULL, 0x000fc600078ec0ffULL, 0x0000080005047825ULL, 0x000fc800078e0002ULL,
0x0000001b740a9211ULL, 0x040fe200078e48ffULL, 0x0000020074069824ULL, 0x000fe200078e021bULL,
0x0000001804087210ULL, 0x000fe40007f1e0ffULL, 0x00000001ff047819ULL, 0x000fe20000011642ULL,
0x0000010079479824ULL, 0x000fe200078e020aULL, 0x00000005ff097210ULL, 0x000fe400007fe4ffULL,
0x0000000104107812ULL, 0x000fe200078ec0ffULL, 0x000000800b049825ULL, 0x000fc600078e0002ULL,
0x00000047100e9211ULL, 0x000fe200078e38ffULL, 0x000000011a0b9824ULL, 0x000fe400078e020bULL,
0x0000010079479824ULL, 0x000fe200078e0206ULL, 0x0000000e170f9211ULL, 0x000fe200078e20ffULL,
0x0000000100067824ULL, 0x000fe200078e0207ULL, 0x0000002017077810ULL, 0x000fe20007ffe0ffULL,
0x000000800b0a9825ULL, 0x000fc800078e0002ULL, 0x00000010170d7824ULL, 0x000fe400078e0206ULL,
0x0000008010109824ULL, 0x000fe400078e0247ULL, 0x0000001007067825ULL, 0x000fc800078e0008ULL,
0x0000001017087825ULL, 0x000fc800078e0008ULL, 0x00000010170a9825ULL, 0x040fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000080d7faeULL, 0x0005e6000b901c46ULL,
0x0000001017049825ULL, 0x040fe200078e0004ULL, 0x00380000060d7faeULL, 0x0005e6000b901c46ULL,
0x0000001017119824ULL, 0x000fe200078e0210ULL, 0x045800000a0f9faeULL, 0x0005e8000b901c46ULL,
0x0418000004119faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000400c047824ULL, 0x004fca00078e00ffULL, 0x0000008004047812ULL, 0x000fc800078ec0ffULL,
0x000000471c047210ULL, 0x000fc80007ffe004ULL, 0x000000041d487210ULL, 0x000fe20007ffe0ffULL,
0x000004000c047824ULL, 0x000fca00078e00ffULL, 0x0000080004057812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00418000480d7984ULL, 0x000ea20000000800ULL,
0x0000018000107810ULL, 0x000fc60007ffe005ULL, 0x0045800048497984ULL, 0x000fe20000000800ULL,
0x0000001043087211ULL, 0x000fe200078e20ffULL, 0x00000010440c7824ULL, 0x100fe400078e0210ULL,
0x0000001041047824ULL, 0x100fe400078e0210ULL, 0x0000001045107824ULL, 0x000fe200078e0210ULL,
0x000000000808783bULL, 0x000ee80000000200ULL, 0x000000000404783bULL, 0x000f220000000200ULL,
0x0000000d1e117221ULL, 0x006fc60000010100ULL, 0x000000000c0c783bULL, 0x000e620000000200ULL,
0x3fb8aa3b114c7820ULL, 0x000fc60000410000ULL, 0x000000001010783bULL, 0x000ea60000000200ULL,
0x0000004c004c7308ULL, 0x000f620000000800ULL, 0x2000000aff4e7230ULL, 0x008fe40000004100ULL,
0x3000000aff4f7230ULL, 0x000fe40000004100ULL, 0x2000000bff537230ULL, 0x000fe40000004100ULL,
0x3000000bff0a7230ULL, 0x000fc40000004100ULL, 0x20000004ff487230ULL, 0x010fe40000004100ULL,
0x20000006ff4a7230ULL, 0x000fe40000004100ULL, 0x30000006ff4b7230ULL, 0x000fe40000004100ULL,
0x000000494c5d7220ULL, 0x020fe20000410000ULL, 0x30000004ff497230ULL, 0x000fe40000004100ULL,
0x20000008ff4c7230ULL, 0x000fe40000004100ULL, 0x0000003f5d3f7221ULL, 0x000fe20000010000ULL,
0x00001f405d5a7589ULL, 0x000ee200000e0000ULL, 0x30000008ff4d7230ULL, 0x000fc40000004100ULL,
0x20000005ff047230ULL, 0x000fe20000004100ULL, 0x00001f465d587589ULL, 0x000f2200000e0000ULL,
0x20000007ff067230ULL, 0x000fe40000004100ULL, 0x20000009ff087230ULL, 0x000fe40000004100ULL,
0x30000005ff057230ULL, 0x000fe40000004100ULL, 0x30000007ff077230ULL, 0x000fe40000004100ULL,
0x2000000cff0b7230ULL, 0x002fc40000004100ULL, 0x3000000cff0c7230ULL, 0x000fe40000004100ULL,
0x2000000dff557230ULL, 0x000fe40000004100ULL, 0x3000000dff507230ULL, 0x000fe40000004100ULL,
0x20000010ff527230ULL, 0x004fe40000004100ULL, 0x30000010ff597230ULL, 0x000fe40000004100ULL,
0x0000005a0c3d7223ULL, 0x008fe2000001003dULL, 0x00000042000c7202ULL, 0x000fe20000000f00ULL,
0x2000000eff0d7230ULL, 0x000fc40000004100ULL, 0x0000005a0b2e7223ULL, 0x000fe2000001002eULL,
0x2000000fff577230ULL, 0x000fe20000004100ULL, 0x000000510c00720cULL, 0x000fe20003f06070ULL,
0x20000011ff107230ULL, 0x000fe40000004100ULL, 0x00000058482d7223ULL, 0x090fe2000001002dULL,
0x20000012ff547230ULL, 0x000fe40000004100ULL, 0x00000058492c7223ULL, 0x080fe2000001002cULL,
0x30000009ff097230ULL, 0x000fe40000004100ULL, 0x00000058042b7223ULL, 0x000fe2000001002bULL,
0x3000000eff0e7230ULL, 0x000fc40000004100ULL, 0x00000058052a7223ULL, 0x080fe2000001002aULL,
0x3000000fff0f7230ULL, 0x000fe40000004100ULL, 0x000000584a297223ULL, 0x080fe20000010029ULL,
0x30000011ff117230ULL, 0x000fe40000004100ULL, 0x000000584b287223ULL, 0x080fe20000010028ULL,
0x30000012ff127230ULL, 0x000fe40000004100ULL, 0x0000005806277223ULL, 0x000fe20000010027ULL,
0x20000013ff5b7230ULL, 0x000fc40000004100ULL, 0x0000005807267223ULL, 0x080fe20000010026ULL,
0x30000013ff567230ULL, 0x000fe40000004100ULL, 0x000000584c257223ULL, 0x080fe20000010025ULL,
0x000000584d247223ULL, 0x080fe20000010024ULL, 0x0000005808237223ULL, 0x080fe20000010023ULL,
0x0000005809227223ULL, 0x080fe20000010022ULL, 0x000000584e217223ULL, 0x080fe20000010021ULL,
0x000000584f207223ULL, 0x080fe20000010020ULL, 0x0000005853327223ULL, 0x080fe20000010032ULL,
0x000000580a2f7223ULL, 0x000fe2000001002fULL, 0x0000005a553c7223ULL, 0x080fe2000001003cULL,
0x0000005a503b7223ULL, 0x080fe2000001003bULL, 0x0000005a0d3a7223ULL, 0x080fe2000001003aULL,
0x0000005a0e397223ULL, 0x080fe20000010039ULL, 0x0000005a57387223ULL, 0x080fe20000010038ULL,
0x0000005a0f3e7223ULL, 0x080fe2000001003eULL, 0x0000005a52377223ULL, 0x080fe20000010037ULL,
0x0000005a59367223ULL, 0x080fe20000010036ULL, 0x0000005a10357223ULL, 0x080fe20000010035ULL,
0x0000005a11347223ULL, 0x080fe20000010034ULL, 0x0000005a54337223ULL, 0x080fe20000010033ULL,
0x0000005a12317223ULL, 0x080fe20000010031ULL, 0x0000005a5b307223ULL, 0x080fe20000010030ULL,
0x0000005a561f7223ULL, 0x000fe2000001001fULL, 0xfffffff400f48947ULL, 0x000fec000383ffffULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x000000ff7900720cULL, 0x000fe20003f05270ULL,
0x0000001000027824ULL, 0x00cfe200078e00ffULL, 0x00000001ff047819ULL, 0x000fe20000011600ULL,
0x000049801b007836ULL, 0x000fc60000000000ULL, 0x0000007002037812ULL, 0x000fe400078ec0ffULL,
0x0000000c04027812ULL, 0x000fc800078ec0ffULL, 0x0000000002027210ULL, 0x000fe20007ffe003ULL,
0x0000000000200947ULL, 0x000fec0003800000ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x00000080741b7824ULL, 0x000fe200078e021bULL, 0x0000000400037819ULL, 0x004fe400000006ffULL,
0x00000001ff047819ULL, 0x000fe40000011600ULL, 0x0000007003007812ULL, 0x000fe400078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ec0ffULL, 0x0000001b04007210ULL, 0x000fca0007ffe000ULL,
0x0049803f00007388ULL, 0x0005e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000002007984ULL, 0x004ea80000000800ULL, 0x0000800002037984ULL, 0x000ee20000000800ULL,
0x00000000ff007221ULL, 0x004fc80000010000ULL, 0x0000000300007221ULL, 0x008fc80000010000ULL,
0x0180000000037836ULL, 0x000fca0000000000ULL, 0x7f80000003037812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x0000000000027202ULL, 0x000fe40000000f00ULL,
0x0000808000077802ULL, 0x000fce0000000f00ULL, 0x0000006c00187944ULL, 0x002fea0003c00000ULL,
0x000000ffff027224ULL, 0x002fe200078e0006ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000000037308ULL, 0x000ea40000001000ULL, 0xbf80000000027423ULL, 0x004fc80000000003ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000203027223ULL, 0x000fce0000000003ULL,
0x0000000000177919ULL, 0x000ea20000000000ULL, 0x0000000574127819ULL, 0x000fe400000006ffULL,
0x00000002ff077819ULL, 0x104fe40000011617ULL, 0x00000008170d7811ULL, 0x000fe400078ff0ffULL,
0x00000003ff047819ULL, 0x000fe20000011617ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0702007589ULL, 0x000ea200000e0000ULL, 0xfffffff8ff137812ULL, 0x000fc600078ee217ULL,
0x00001f0d02067589ULL, 0x00072400000e0000ULL, 0x00000008131b7836ULL, 0x000fe20000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000304027812ULL, 0x008fc800078ec0ffULL,
0x0000000402107812ULL, 0x000fe400078efcffULL, 0x0000000702197812ULL, 0x000fe400078e7813ULL,
0x00000007021d7812ULL, 0x000fe200078e781bULL, 0x000000081b027824ULL, 0x000fe400078e00ffULL,
0x0000002d00087220ULL, 0x044fe20000410000ULL, 0x0000002c00037220ULL, 0x040fe20000410000ULL,
0x0000002b00097220ULL, 0x040fe20000410000ULL, 0x0000002a002a7220ULL, 0x040fe20000410000ULL,
0x00000029000a7220ULL, 0x040fe20000410000ULL, 0x0000002800057220ULL, 0x040fe20000410000ULL,
0x00000027000b7220ULL, 0x040fe20000410000ULL, 0x0000002600267220ULL, 0x040fe20000410000ULL,
0x00000025000c7220ULL, 0x040fe20000410000ULL, 0x0000002400077220ULL, 0x040fe20000410000ULL,
0x00000023000d7220ULL, 0x040fe20000410000ULL, 0x0000002200227220ULL, 0x040fe20000410000ULL,
0x00000021000e7220ULL, 0x040fe20000410000ULL, 0x00000020000f7220ULL, 0x040fe20000410000ULL,
0x0000003200327220ULL, 0x040fe20000410000ULL, 0x0000002f002f7220ULL, 0x000fe20000410000ULL,
0x0000002e062e7220ULL, 0x050fe20000410000ULL, 0x0000003d063d7220ULL, 0x040fe20000410000ULL,
0x0000003c063c7220ULL, 0x040fe20000410000ULL, 0x0000003b063b7220ULL, 0x040fe20000410000ULL,
0x0000003a063a7220ULL, 0x040fe20000410000ULL, 0x0000003906397220ULL, 0x040fe20000410000ULL,
0x0000003806387220ULL, 0x040fe20000410000ULL, 0x0000003e06117220ULL, 0x040fe20000410000ULL,
0x0000003706377220ULL, 0x040fe20000410000ULL, 0x0000003606367220ULL, 0x040fe20000410000ULL,
0x0000003506357220ULL, 0x040fe20000410000ULL, 0x0000003406347220ULL, 0x040fe20000410000ULL,
0x0000003306337220ULL, 0x040fe20000410000ULL, 0x0000003106007220ULL, 0x040fe20000410000ULL,
0x0000003006307220ULL, 0x040fe20000410000ULL, 0x0000001f061f7220ULL, 0x000fe20000410000ULL,
0x0000000313067819ULL, 0x000fc400000006ffULL, 0x0000000710137812ULL, 0x000fe400078e7813ULL,
0x00000007101b7812ULL, 0x000fe400078e781bULL, 0x0000000619197212ULL, 0x080fe400078efcffULL,
0x0000000613137212ULL, 0x000fe400078efcffULL, 0x000000021d1d7212ULL, 0x080fe400078efcffULL,
0x000000021b1b7212ULL, 0x000fe200078efcffULL, 0x0000001019027824ULL, 0x100fe200078e0214ULL,
0x000000141d167211ULL, 0x000fe200078e20ffULL, 0x0000001013067824ULL, 0x100fe200078e0214ULL,
0x000000080308723eULL, 0x000fe200000000ffULL, 0x000000101b147824ULL, 0x000fe200078e0214ULL,
0x000000092a09723eULL, 0x000fc400000000ffULL, 0x0000000a050a723eULL, 0x000fe400000000ffULL,
0x0000000b260b723eULL, 0x000fe400000000ffULL, 0x0000000e0f0e723eULL, 0x000fe400000000ffULL,
0x0000000c070c723eULL, 0x000fe200000000ffULL, 0x0000000802007844ULL, 0x000fe20000000200ULL,
0x0000000d220d723eULL, 0x000fe400000000ffULL, 0x000000322f0f723eULL, 0x000fc400000000ffULL,
0x0000002e3d18723eULL, 0x000fe400000000ffULL, 0x0000003c3b19723eULL, 0x000fe200000000ffULL,
0x0000000c06007844ULL, 0x000fe20000000200ULL, 0x0000003a391a723eULL, 0x000fe400000000ffULL,
0x00000038111b723eULL, 0x000fe400000000ffULL, 0x00000037361c723eULL, 0x000fe400000000ffULL,
0x00000035341d723eULL, 0x000fe200000000ffULL, 0x0000001816007844ULL, 0x000fe20000000200ULL,
0x00000033001e723eULL, 0x002fe200000000ffULL, 0x0000000112007824ULL, 0x000fe200078e0217ULL,
0x000000301f1f723eULL, 0x000fc600000000ffULL, 0x0000001000007824ULL, 0x000fe400078e0215ULL,
0x0000001c14007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000107984ULL, 0x000e680000000c00ULL, 0x0004000000247984ULL, 0x000ea80000000c00ULL,
0x0008000000207984ULL, 0x000ee80000000c00ULL, 0x000c000000287984ULL, 0x000f220000000c00ULL,
0x200000ff13137230ULL, 0x002fc40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fe40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x004fe40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fc40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x0000002313137230ULL, 0x008fe40000000000ULL, 0x0000002212127230ULL, 0x000fe40000000000ULL,
0x0000002111117230ULL, 0x000fe40000000000ULL, 0x0000002010107230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x010fc40000000000ULL, 0x0000002a26267230ULL, 0x000fe20000000000ULL,
0x0000001000007388ULL, 0x0003e20000000c00ULL, 0x0000002925257230ULL, 0x000fe40000000000ULL,
0x0000002824247230ULL, 0x000fca0000000000ULL, 0x0004002400007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff7400720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ee20000002600ULL,
0x0000002017077810ULL, 0x000fe20007ffe0ffULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x0000000704067812ULL, 0x000fe200078e4817ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x00000003ff027819ULL, 0x002fe20000011607ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0ffffff806087812ULL, 0x004fe200078ef817ULL, 0x0000000879107824ULL, 0x040fe200078e00ffULL,
0x0000000702007812ULL, 0x000fe200078e4807ULL, 0x0000000879127824ULL, 0x000fc600078e00ffULL,
0x0ffffff800067812ULL, 0x000fe200078ef807ULL, 0x0000001008007824ULL, 0x100fe200078e0215ULL,
0xfffffff810177812ULL, 0x000fe400078ee217ULL, 0xfffffff812077812ULL, 0x000fe200078ee207ULL,
0x0000001006067824ULL, 0x000fe200078e0215ULL, 0x0000000000087984ULL, 0x0002a80000000c00ULL,
0x00000000060c7984ULL, 0x000aa20000000c00ULL, 0x00000005040472a4ULL, 0x010fe2000f8e023fULL,
0x0000000303057819ULL, 0x048fe200000006ffULL, 0x0000000803037824ULL, 0x000fc600078e00ffULL,
0xfffffff805047812ULL, 0x000fe400078ee204ULL, 0xfffffff803027812ULL, 0x000fe400078ee202ULL,
0x0000000404037c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000402007c10ULL, 0x002fe2000ff3e0ffULL,
0x0000860000047ab9ULL, 0x000fe20000000a00ULL, 0x000000ffff067210ULL, 0x020fe400007fe4ffULL,
0x0000000403027c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x0000000400047c11ULL, 0x000fc4000f8240ffULL, 0x0000000503037c11ULL, 0x000fe400080f4406ULL,
0x0000000500057c11ULL, 0x000fe200088f4405ULL, 0x0000001017027825ULL, 0x000fc800078e0002ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x004fe8000c101d06ULL,
0x0000000c04007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000015c057836ULL, 0x048fe20000000000ULL, 0x000000064d797819ULL, 0x000fe200000006ffULL,
0x0000000275757824ULL, 0x000fe200078e00ffULL, 0x0000000100027802ULL, 0x000fe20000000f00ULL,
0x00008e0000047ab9ULL, 0x000fe20000000800ULL, 0x000000780500720cULL, 0x000fe20003f06070ULL,
0x000001005c1c7824ULL, 0x000fe400078e0279ULL, 0x0000000875757e24ULL, 0x000fe2000f8e020aULL,
0x01b60002ff0279a7ULL, 0x000e660008500009ULL, 0x0000000475067c24ULL, 0x000fcc000f8e021cULL,
0x0000000800e48947ULL, 0x000fea0003800000ULL, 0x00008a00ff047b82ULL, 0x000ea20000000a00ULL,
0x00000003ff297819ULL, 0x000fe4000001167aULL, 0x0000001c5e077248ULL, 0x000fe40007fe0000ULL,
0x0000007000007812ULL, 0x000fe200078ec0ffULL, 0x00000004290b7836ULL, 0x040fe20000000000ULL,
0x00000018291b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000c290d7836ULL, 0x000fe40000000000ULL,
0x00000001071c7824ULL, 0x000fe200078e0a1cULL, 0x0000007a0b087212ULL, 0x080fe200078e3cffULL,
0x000000080d137824ULL, 0x000fe200078e00ffULL, 0x000000030b097819ULL, 0x000fe200000006ffULL,
0x0000000829077836ULL, 0x000fe20000000000ULL, 0x0000007a0d0c7212ULL, 0x080fe200078e3cffULL,
0x00000010290f7836ULL, 0x040fe20000000000ULL, 0xfffffff809107812ULL, 0x000fe200078ee208ULL,
0x0000001c29257836ULL, 0x000fe20000000000ULL, 0x0000002906097210ULL, 0x000fe20007ffe0ffULL,
0x000000080f157824ULL, 0x000fe200078e00ffULL, 0xfffffff813207812ULL, 0x000fe200078ee20cULL,
0x0000002029217836ULL, 0x000fe20000000000ULL, 0x0000007a070a7212ULL, 0x000fe200078e3cffULL,
0x0000010009087825ULL, 0x004fe200078e0004ULL, 0x0000000307117819ULL, 0x000fc400000006ffULL,
0x0000001c0b00720cULL, 0x000fe20003f86070ULL, 0x000000081b267824ULL, 0x000fe200078e00ffULL,
0x0000000800127210ULL, 0x000fe20007f1e0ffULL, 0x0000003829277836ULL, 0x040fe20000000000ULL,
0xfffffff8111e7812ULL, 0x000fe200078ee20aULL, 0x0000001429117836ULL, 0x000fe20000000000ULL,
0x00000009ff137210ULL, 0x000fe200007fe4ffULL, 0x0000000106097824ULL, 0x000fe200078e020bULL,
0x00000007060b7210ULL, 0x000fe40007ffe0ffULL, 0x0000007a0f0e7212ULL, 0x000fe200078e3cffULL,
0x0000010009087825ULL, 0x000fe200078e0004ULL, 0x0000001c0700720cULL, 0x000fc40003f46070ULL,
0x0000001c0f00720cULL, 0x080fe20003f06070ULL, 0x000001000b0a7825ULL, 0x000fe200078e0004ULL,
0x0000000800147210ULL, 0x000fe40007f3e0ffULL, 0xfffffff815227812ULL, 0x000fe200078ee20eULL,
0x0000000106077824ULL, 0x040fe200078e020fULL, 0x00000011060f7210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200008e0609ULL, 0x0000001c0d00720cULL, 0x000fe20003f66070ULL,
0x00000001060d7824ULL, 0x000fe200078e020dULL, 0x0000000a00167210ULL, 0x000fe20007fbe0ffULL,
0x0000010007087825ULL, 0x000fe200078e0004ULL, 0x000000094d077c11ULL, 0x000fc4000f8e70ffULL,
0x0000007a111a7212ULL, 0x080fe200078e3cffULL, 0x000001000f0e7825ULL, 0x100fe200078e0004ULL,
0x0000100007077810ULL, 0x000fe40007ffe0ffULL, 0x0000007a1b237212ULL, 0x000fe200078e3cffULL,
0x000001000d0c7825ULL, 0x000fc600078e0004ULL, 0xfffffff826267812ULL, 0x000fe200078ee223ULL,
0x000000ffff177224ULL, 0x000fe200028e060bULL, 0x00000008000a7210ULL, 0x000fe20007fbe0ffULL,
0x00000010101f7824ULL, 0x000fe200078e0207ULL, 0x0000000e00087210ULL, 0x000fe20007fde0ffULL,
0x0000003029237836ULL, 0x040fe20000000000ULL, 0x0000000c00187210ULL, 0x000fe40007f3e0ffULL,
0x00000009ff0b7210ULL, 0x000fe20002ffe4ffULL, 0x000000ffff097224ULL, 0x000fe200030e060fULL,
0x00000007290f7812ULL, 0x000fe200078e487aULL, 0x000000ffff197224ULL, 0x000fe200008e060dULL,
0x0000001c2900720cULL, 0x000fe20003fa6070ULL, 0x00000001060d7824ULL, 0x000fe200078e021bULL,
0x0ffffff80f0e7812ULL, 0x000fc400078ef87aULL, 0x00000025060f7210ULL, 0x000fe20007ffe0ffULL,
0x000001000d0c7825ULL, 0x100fe200078e0004ULL, 0x000000070e1d7211ULL, 0x000fe400078e20ffULL,
0x0000001c1100720cULL, 0x0c0fe20003f26070ULL, 0x0000000811117824ULL, 0x000fe200078e00ffULL,
0x0000000c000c7210ULL, 0x000fe20007fde0ffULL, 0x000001000f0e7825ULL, 0x000fe400078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000121d7faeULL, 0x0005e2000e901c46ULL,
0xfffffff811247812ULL, 0x000fe200078ee21aULL, 0x000000ffff0d7224ULL, 0x000fe200030e060dULL,
0x0000000e001a7210ULL, 0x000fe20007fde0ffULL, 0x00000000141f7faeULL, 0x0007e2000e101c46ULL,
0x0000000106117824ULL, 0x000fe200078e0221ULL, 0x0000001c1b00720cULL, 0x000fc40003fa6070ULL,
0x0000001c2500720cULL, 0x040fe20003f86070ULL, 0x000000ffff1b7224ULL, 0x000fe200030e060fULL,
0x0000007a250e7212ULL, 0x080fe200078e3cffULL, 0x0000010011107825ULL, 0x000fe200078e0004ULL,
0x0000007a21127212ULL, 0x004fe400078e3cffULL, 0x0000000325257819ULL, 0x000fe200000006ffULL,
0x000000101e137824ULL, 0x100fe200078e0207ULL, 0x00000028291f7810ULL, 0x008fe20007ffe0ffULL,
0x0000001020157824ULL, 0x000fe200078e0207ULL, 0xfffffff825287812ULL, 0x000fe200078ee20eULL,
0x00000024291d7836ULL, 0x000fe20000000000ULL, 0x0000000016137faeULL, 0x0005e2000d101c46ULL,
0x0000001000107210ULL, 0x000fc40007fde0ffULL, 0x0000003429257810ULL, 0x000fe20007ffe0ffULL,
0x0000000018157faeULL, 0x0007e2000d901c46ULL, 0x0000001c2100720cULL, 0x0c0fe20003f66070ULL,
0x0000000821217824ULL, 0x000fe200078e00ffULL, 0x0000001d060f7210ULL, 0x000fe40007ffe0ffULL,
0x0000001c1d00720cULL, 0x040fe40003f46070ULL, 0x0000007a1d147212ULL, 0x040fe200078e3cffULL,
0x000000081d1d7824ULL, 0x000fe200078e00ffULL, 0x0000000722137211ULL, 0x004fe200078e20ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0004ULL, 0xfffffff821127812ULL, 0x000fc400078ee212ULL,
0x0000000726177211ULL, 0x000fe200078e20ffULL, 0x0000001024157824ULL, 0x108fe200078e0207ULL,
0x000000000a137faeULL, 0x0005e2000c101c46ULL, 0xfffffff81d147812ULL, 0x000fe200078ee214ULL,
0x0000001028197824ULL, 0x100fe200078e0207ULL, 0x00000011ff117210ULL, 0x000fe200037fe4ffULL,
0x0000000008157faeULL, 0x0007e2000c901c46ULL, 0x00000010121d7824ULL, 0x000fe200078e0207ULL,
0x0000000e000e7210ULL, 0x000fe20007fde0ffULL, 0x0000002c29217836ULL, 0x000fe20000000000ULL,
0x000000000c177faeULL, 0x0009e2000e901c46ULL, 0x0000001c2700720cULL, 0x000fc40003f26070ULL,
0x000000ffff0f7224ULL, 0x000fe200030e060fULL, 0x000000001a197faeULL, 0x000fe2000e101c46ULL,
0x00000021060b7210ULL, 0x004fe20007ffe0ffULL, 0x0000000106137824ULL, 0x040fe200078e0223ULL,
0x0000001c2300720cULL, 0x000fe20003f86070ULL, 0x00000000101d7faeULL, 0x0005e2000d901c46ULL,
0x0000007a1f087212ULL, 0x088fe200078e3cffULL, 0x000001000b0a7825ULL, 0x000fe200078e0004ULL,
0x000000031f097819ULL, 0x000fe400000006ffULL, 0x0000007a210d7212ULL, 0x010fe200078e3cffULL,
0x0000003c29157836ULL, 0x000fe20000000000ULL, 0xfffffff809127812ULL, 0x000fe200078ee208ULL,
0x0000000106097824ULL, 0x040fe200078e021fULL, 0x0000001c2500720cULL, 0x080fe20003f66070ULL,
0x0000000106177824ULL, 0x000fe200078e0215ULL, 0x0000001c1f00720cULL, 0x000fe20003fc6070ULL,
0x0000001014117824ULL, 0x004fe200078e0207ULL, 0x0000007a23107212ULL, 0x000fe200078e3cffULL,
0x0000010009087825ULL, 0x000fe200078e0004ULL, 0x0000000323237819ULL, 0x000fc400000006ffULL,
0x000000000e117faeULL, 0x0005e2000d101c46ULL, 0x0000000821147824ULL, 0x040fe200078e00ffULL,
0x00000008000c7210ULL, 0x000fe40007f5e0ffULL, 0xfffffff823167812ULL, 0x000fe400078ee210ULL,
0xfffffff814147812ULL, 0x000fe200078ee20dULL, 0x000000ffff0d7224ULL, 0x000fe200010e0609ULL,
0x0000001c2100720cULL, 0x000fe20003fa6070ULL, 0x0000010013087825ULL, 0x000fe200078e0004ULL,
0x00000003151a7819ULL, 0x000fc400000006ffULL, 0x0000000a000e7210ULL, 0x004fe20007f5e0ffULL,
0x0000000825117824ULL, 0x040fe200078e00ffULL, 0x0000007a250a7212ULL, 0x080fe200078e3cffULL,
0x0000000106137824ULL, 0x000fe200078e0227ULL, 0x0000002506257210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e060bULL, 0xfffffff811187812ULL, 0x000fe400078ee20aULL,
0x0000000800107210ULL, 0x000fe20007f5e0ffULL, 0x00000100250a7825ULL, 0x000fe200078e0004ULL,
0x0000007a27067212ULL, 0x000fc400078e3cffULL, 0x00000009ff117210ULL, 0x000fe200017fe4ffULL,
0x0000010013087825ULL, 0x000fe200078e0004ULL, 0x0000000a000a7210ULL, 0x000fe40007f5e0ffULL,
0x0000007a15137212ULL, 0x000fe200078e3cffULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x0000001c1500720cULL, 0x000fe20003f06070ULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x0000000800087210ULL, 0x000fe20007f5e0ffULL, 0x0000010017047825ULL, 0x000fe200078e0004ULL,
0xfffffff827067812ULL, 0x000fc400078ee206ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee213ULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x0000000712137211ULL, 0x080fe200078e20ffULL,
0x0000001014157824ULL, 0x100fe200078e0207ULL, 0x0000000400047210ULL, 0x000fe20007f5e0ffULL,
0x0000001016177824ULL, 0x100fe200078e0207ULL, 0x0000000718197211ULL, 0x000fe200078e20ffULL,
0x00000010061b7824ULL, 0x100fe200078e0207ULL, 0x00000005ff057210ULL, 0x000fe200017fe4ffULL,
0x000000101a077824ULL, 0x000fe200078e0207ULL, 0x000000000c137faeULL, 0x0005e8000f101c46ULL,
0x000000000e157faeULL, 0x0005e8000e901c46ULL, 0x0000000010177faeULL, 0x0005e8000e101c46ULL,
0x000000000a197faeULL, 0x0005e8000d901c46ULL, 0x00000000081b7faeULL, 0x0005e8000c901c46ULL,
0x0000000004077faeULL, 0x0005e2000c101c46ULL, 0x0000000800987947ULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x000fc8000001167aULL, 0x0000000c07137810ULL, 0x000fe20007ffe0ffULL,
0x00000004070f7836ULL, 0x040fe20000000000ULL, 0x0000001807197810ULL, 0x000fe20007ffe0ffULL,
0x0000000807117836ULL, 0x000fe20000000000ULL, 0x0000007a13087212ULL, 0x080fe200078e3cffULL,
0x000000080f097824ULL, 0x040fe200078e00ffULL, 0x0000007a0f047212ULL, 0x080fe200078e3cffULL,
0x00000008110c7824ULL, 0x040fe200078e00ffULL, 0x0000007a11057212ULL, 0x080fe200078e3cffULL,
0x0000001007157836ULL, 0x000fe20000000000ULL, 0x00000003130b7819ULL, 0x000fe200000006ffULL,
0x0000001407177836ULL, 0x000fe20000000000ULL, 0xfffffff8090a7812ULL, 0x000fe200078ee204ULL,
0x0000000815097824ULL, 0x000fe200078e00ffULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee205ULL,
0x0000000817127824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0e7812ULL, 0x000fe200078ee208ULL,
0x0000001c071b7836ULL, 0x000fe20000000000ULL, 0x0000007a15047212ULL, 0x080fe200078e3cffULL,
0x00000020071d7836ULL, 0x000fe20000000000ULL, 0x0000007a17057212ULL, 0x080fe200078e3cffULL,
0x0000002807217836ULL, 0x000fe20000000000ULL, 0x0000007a19087212ULL, 0x080fe200078e3cffULL,
0x000000081d187824ULL, 0x000fe200078e00ffULL, 0x00000003190b7819ULL, 0x000fe200000006ffULL,
0x0000002c07237836ULL, 0x040fe20000000000ULL, 0x00000024071f7810ULL, 0x000fe20007ffe0ffULL,
0x0000003807297836ULL, 0x000fe20000000000ULL, 0xfffffff809107812ULL, 0x000fe200078ee204ULL,
0x000000081b097824ULL, 0x000fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee205ULL,
0x00000008231e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b147812ULL, 0x000fe200078ee208ULL,
0x0000003c072b7836ULL, 0x000fe20000000000ULL, 0x0000007a1b047212ULL, 0x080fe200078e3cffULL,
0x0000000106117824ULL, 0x040fe200078e0211ULL, 0x0000007a1d057212ULL, 0x080fe200078e3cffULL,
0x0000000106137824ULL, 0x040fe200078e0213ULL, 0x0000007a1f087212ULL, 0x0c0fe200078e3cffULL,
0x0000000106177824ULL, 0x040fe200078e0217ULL, 0x000000031f0b7819ULL, 0x000fe200000006ffULL,
0x0000000106197824ULL, 0x040fe200078e0219ULL, 0xfffffff809167812ULL, 0x000fe200078ee204ULL,
0x00000001061d7824ULL, 0x040fe200078e021dULL, 0xfffffff818187812ULL, 0x000fe200078ee205ULL,
0x00000001061f7824ULL, 0x000fe200078e021fULL, 0xfffffff80b1a7812ULL, 0x000fe200078ee208ULL,
0x00000008210b7824ULL, 0x040fe200078e00ffULL, 0x0000007a21047212ULL, 0x000fc400078e3cffULL,
0x0000007a23057212ULL, 0x080fe200078e3cffULL, 0x0000000106237824ULL, 0x000fe200078e0223ULL,
0xfffffff80b1c7812ULL, 0x000fe400078ee204ULL, 0xfffffff81e1e7812ULL, 0x000fe400078ee205ULL,
0x00008a00ff047b82ULL, 0x000ea20000000a00ULL, 0x0000003007257810ULL, 0x000fe40007ffe0ffULL,
0x000000094d087c11ULL, 0x000fe4000f8e70ffULL, 0x0000007a25097212ULL, 0x000fc400078e3cffULL,
0x0000000325207819ULL, 0x000fe200000006ffULL, 0x00001000080d7836ULL, 0x000fe20000000000ULL,
0x0000003407277810ULL, 0x000fe20007ffe0ffULL, 0x0000000106257824ULL, 0x040fe200078e0225ULL,
0xfffffff820207812ULL, 0x000fe200078ee209ULL, 0x0000000106097824ULL, 0x000fe200078e0207ULL,
0x00000007070b7812ULL, 0x000fe200078e487aULL, 0x0000000827087824ULL, 0x040fe200078e00ffULL,
0x0000002706417210ULL, 0x000fe20007ffe0ffULL, 0x00000010102f7824ULL, 0x000fe200078e020dULL,
0x0000007a27077212ULL, 0x080fe200078e3cffULL, 0x0000000106277824ULL, 0x000fe200078e0229ULL,
0x0000007a29227212ULL, 0x0c0fe200078e3cffULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0x0000002b06477210ULL, 0x000fe20007ffe0ffULL, 0x0000001012317824ULL, 0x100fe200078e020dULL,
0x0000007a2b247212ULL, 0x040fe200078e3cffULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0x0000000f060f7210ULL, 0x000fe20007ffe0ffULL, 0x0000001016357824ULL, 0x100fe200078e020dULL,
0x0000001506157210ULL, 0x000fe20007ffe0ffULL, 0x0000001018377824ULL, 0x100fe200078e020dULL,
0x0000001b061b7210ULL, 0x000fe20007ffe0ffULL, 0x000000101c3b7824ULL, 0x100fe200078e020dULL,
0x0000002106217210ULL, 0x000fe20007ffe0ffULL, 0x000000101e3d7824ULL, 0x000fe200078e020dULL,
0xfffffff808087812ULL, 0x000fc400078ee207ULL, 0xfffffff829227812ULL, 0x000fe200078ee222ULL,
0x000000100a297824ULL, 0x100fe200078e020dULL, 0x0ffffff80b067812ULL, 0x000fe200078ef87aULL,
0x0000001008437824ULL, 0x100fe200078e020dULL, 0xfffffff82b247812ULL, 0x000fe200078ee224ULL,
0x000000100c2b7824ULL, 0x100fe200078e020dULL, 0x0000000d06067211ULL, 0x080fe200078e20ffULL,
0x0000001022457824ULL, 0x000fe200078e020dULL, 0x0000000d0e2d7211ULL, 0x080fe200078e20ffULL,
0x000001000f0a7825ULL, 0x004fe200078e0004ULL, 0x0000000d14337211ULL, 0x000fc400078e20ffULL,
0x0000000d1a397211ULL, 0x080fe200078e20ffULL, 0x00000100130e7825ULL, 0x100fe200078e0004ULL,
0x0000000d203f7211ULL, 0x080fe400078e20ffULL, 0x0000000d24497211ULL, 0x000fe200078e20ffULL,
0x00000100110c7825ULL, 0x000fe200078e0004ULL, 0x0000007000077812ULL, 0x000fc600078ec0ffULL,
0x0000010015107825ULL, 0x000fc800078e0004ULL, 0x0000010019147825ULL, 0x000fc800078e0004ULL,
0x0000010009087825ULL, 0x000fc800078e0004ULL, 0x0000010017127825ULL, 0x000fc800078e0004ULL,
0x000001001d187825ULL, 0x000fc800078e0004ULL, 0x000001001b167825ULL, 0x000fc800078e0004ULL,
0x00000100211c7825ULL, 0x000fc800078e0004ULL, 0x000001001f1a7825ULL, 0x000fc800078e0004ULL,
0x0000010025207825ULL, 0x000fc800078e0004ULL, 0x00000100231e7825ULL, 0x000fc800078e0004ULL,
0x0000010027247825ULL, 0x000fc800078e0004ULL, 0x0000010041227825ULL, 0x000fc800078e0004ULL,
0x0000010047267825ULL, 0x000fe200078e0004ULL, 0x0000000807047210ULL, 0x000fe40007f1e0ffULL,
0x0000000a07087210ULL, 0x000fe40007f3e0ffULL, 0x0000000c070a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0609ULL, 0x0000000e070c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e060bULL, 0x00000010070e7210ULL, 0x000fe40007f1e0ffULL,
0x0000000dff0b7210ULL, 0x000fe200017fe4ffULL, 0x000000ffff0d7224ULL, 0x000fe200018e060fULL,
0x0000001207107210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e0611ULL,
0x0000001407127210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004067faeULL, 0x0005e2000b901c46ULL, 0x0000001607147210ULL, 0x000fc40007f7e0ffULL,
0x00000013ff117210ULL, 0x000fe20000ffe4ffULL, 0x000000ffff137224ULL, 0x000fe200010e0615ULL,
0x0000001807167210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200018e0617ULL,
0x0000001a07187210ULL, 0x000fe20007f3e0ffULL, 0x0000000008297faeULL, 0x0005e2000b901c46ULL,
0x0000001c071a7210ULL, 0x000fe40007f5e0ffULL, 0x0000001e071c7210ULL, 0x000fe20007f7e0ffULL,
0x000000000a2b7faeULL, 0x0005e2000b901c46ULL, 0x00000019ff177210ULL, 0x000fe200007fe4ffULL,
0x000000ffff197224ULL, 0x000fe200008e061bULL, 0x00000020071e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e061dULL, 0x0000002207207210ULL, 0x000fe20007f3e0ffULL,
0x000000000c2d7faeULL, 0x0005e2000b901c46ULL, 0x0000001fff1d7210ULL, 0x000fe20001ffe4ffULL,
0x000000ffff1f7224ULL, 0x000fe200000e0621ULL, 0x0000002407227210ULL, 0x000fe20007f5e0ffULL,
0x000000000e2f7faeULL, 0x0005e2000b901c46ULL, 0x0000002607247210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff217224ULL, 0x000fe200008e0623ULL, 0x00000025ff237210ULL, 0x000fe200017fe4ffULL,
0x0000000010317faeULL, 0x0005e4000b901c46ULL, 0x000000ffff257224ULL, 0x000fc400018e0627ULL,
0x0000000012337faeULL, 0x0005e8000b901c46ULL, 0x0000000014357faeULL, 0x0005e8000b901c46ULL,
0x0000000016377faeULL, 0x0005e8000b901c46ULL, 0x0000000018397faeULL, 0x0005e8000b901c46ULL,
0x000000001a3b7faeULL, 0x0005e8000b901c46ULL, 0x000000001c3d7faeULL, 0x0005e8000b901c46ULL,
0x000000001e3f7faeULL, 0x0005e8000b901c46ULL, 0x0000000020437faeULL, 0x0005e8000b901c46ULL,
0x0000000022457faeULL, 0x0005e8000b901c46ULL, 0x0000000024497faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01b60003ff0075a7ULL, 0x002e620008000149ULL,
0x000000785c00720cULL, 0x000fe20003f26070ULL, 0x0000004400808947ULL, 0x002fd80003800000ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000094d7b7c11ULL, 0x040fe4000f8e18ffULL,
0xffffffff787d7810ULL, 0x000fe40007ffe0ffULL, 0x000000094d777c11ULL, 0x000fce000f8e28ffULL,
0x000001005c5f7824ULL, 0x000fca00078e0279ULL, 0x0000005f5e00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x000000015c037836ULL, 0x000fe20000000000ULL,
0x00008e0000047ab9ULL, 0x000fe40000000800ULL, 0x0000000475147c24ULL, 0x004fe4000f8e025fULL,
0x000000780300720cULL, 0x000fda0003f06070ULL, 0x0000000800b08947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe2000001167aULL, 0x000000015e157824ULL, 0x000fe200078e0a5fULL,
0x00008a00000a7ab9ULL, 0x000fe20000000a00ULL, 0x000000077a4a7812ULL, 0x000fe200078ec0ffULL,
0x0000000aff127e24ULL, 0x000fe2000f8e00ffULL, 0x0000001000057810ULL, 0x000fe20007ffe0ffULL,
0x0000000800037836ULL, 0x040fe20000000000ULL, 0x0000000400027810ULL, 0x000fe20007ffe0ffULL,
0x0000000c00047836ULL, 0x000fe20000000000ULL, 0x0000007a05587212ULL, 0x080fe200078e3cffULL,
0x0000000803077824ULL, 0x040fe200078e00ffULL, 0x0000007a035a7212ULL, 0x080fe200078e3cffULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0x0000007a04597212ULL, 0x080fe200078e3cffULL,
0x0000000802067824ULL, 0x000fe200078e00ffULL, 0xfffffff8075a7812ULL, 0x000fe200078ee25aULL,
0x0000000bff137e24ULL, 0x000fe2000f8e00ffULL, 0x0000001800077810ULL, 0x000fe20007ffe0ffULL,
0x0000000103197824ULL, 0x100fe200078e0214ULL, 0x0000000304087819ULL, 0x040fe200000006ffULL,
0x00000001041b7824ULL, 0x000fe200078e0214ULL, 0xfffffff809587812ULL, 0x000fe200078ee258ULL,
0x0000002000097836ULL, 0x000fe20000000000ULL, 0x0000007a025b7212ULL, 0x080fe200078e3cffULL,
0x00000008070b7824ULL, 0x040fe200078e00ffULL, 0x0000007a07567212ULL, 0x000fe200078e3cffULL,
0x0000010019187825ULL, 0x000fe200078e0012ULL, 0xfffffff808597812ULL, 0x000fc400078ee259ULL,
0xfffffff8065b7812ULL, 0x000fe200078ee25bULL, 0x0000001c00087836ULL, 0x040fe20000000000ULL,
0x0000007a09547212ULL, 0x0c0fe200078e3cffULL, 0x0000001400067836ULL, 0x000fe20000000000ULL,
0x00000003090d7819ULL, 0x000fe200000006ffULL, 0x00000008080c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b567812ULL, 0x000fe200078ee256ULL, 0x000001001b1a7825ULL, 0x000fe200078e0012ULL,
0x0000007a000b7212ULL, 0x080fe400078e3cffULL, 0x0000007a08557212ULL, 0x080fe200078e3cffULL,
0x0000000107277824ULL, 0x100fe200078e0214ULL, 0xfffffff80d547812ULL, 0x000fe200078ee254ULL,
0x00000001000d7824ULL, 0x100fe200078e0214ULL, 0x0000007a06577212ULL, 0x000fe200078e3cffULL,
0x0000000108297824ULL, 0x000fe200078e0214ULL, 0x00000003060a7819ULL, 0x000fe200000006ffULL,
0x0000002400497836ULL, 0x040fe20000000000ULL, 0x000000094d107c11ULL, 0x000fe2000f8e70ffULL,
0x0000003c000e7836ULL, 0x000fe20000000000ULL, 0x000000070b0b7812ULL, 0x000fc400078ec0ffULL,
0x000000150000720cULL, 0x000fe40003f06070ULL, 0x0000001402177210ULL, 0x000fe40007ffe0ffULL,
0xfffffff80c557812ULL, 0x000fe200078ee255ULL, 0x000001000d0c7825ULL, 0x100fe200078e0012ULL,
0xfffffff80a577812ULL, 0x000fe400078ee257ULL, 0x000000084a0f7812ULL, 0x000fe200078efcffULL,
0x0000010017167825ULL, 0x000fe200078e0012ULL, 0x00003000100a7810ULL, 0x000fc40007ffe0ffULL,
0x000000150200720cULL, 0x080fe20003f26070ULL, 0x000000100f0c7825ULL, 0x000fe200078e000cULL,
0x0ffffff80b5d7812ULL, 0x000fe400078ef87aULL, 0x000000150300720cULL, 0x080fe20003f46070ULL,
0x000000100f167825ULL, 0x000fe200078e0016ULL, 0x00000014051d7210ULL, 0x000fe40007ffe0ffULL,
0x000000150400720cULL, 0x080fe20003f66070ULL, 0x000000105d0b7824ULL, 0x000fe200078e020aULL,
0x000000150500720cULL, 0x000fe20003f86070ULL, 0x000001001d1c7825ULL, 0x000fe200078e0012ULL,
0x0000001406257210ULL, 0x000fc40007ffe0ffULL, 0x0000000a5a1f7211ULL, 0x000fe200078e20ffULL,
0x000000105b117824ULL, 0x000fe200078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0b7faeULL, 0x0003e2000c101c46ULL, 0x000000100f187825ULL, 0x040fe200078e0018ULL,
0x000000150600720cULL, 0x080fe40003f06070ULL, 0x0000000016117faeULL, 0x000fe2000c901c46ULL,
0x000000100f1a7825ULL, 0x000fe200078e001aULL, 0x00000014092b7210ULL, 0x000fe40007ffe0ffULL,
0x00000000181f7faeULL, 0x0005e2000d101c46ULL, 0x0000001059217824ULL, 0x000fe200078e020aULL,
0x000000150700720cULL, 0x080fe20003f26070ULL, 0x000000100f1c7825ULL, 0x000fe200078e001cULL,
0x000000150800720cULL, 0x000fc40003f46070ULL, 0x000000001a217faeULL, 0x0007e2000d901c46ULL,
0x0000001058237824ULL, 0x000fe200078e020aULL, 0x000000150900720cULL, 0x080fe20003f66070ULL,
0x00000100250c7825ULL, 0x102fe200078e0012ULL, 0x0000002800487810ULL, 0x000fe40007ffe0ffULL,
0x000000001c237faeULL, 0x0003e2000e101c46ULL, 0x0000010027187825ULL, 0x004fe200078e0012ULL,
0x0000007a48527212ULL, 0x000fe400078e3cffULL, 0x000000150e00720cULL, 0x000fe20003fc6070ULL,
0x000000100f167825ULL, 0x000fe200078e000cULL, 0x0000000a55217211ULL, 0x008fc400078e20ffULL,
0x00000034000c7810ULL, 0x000fe20007ffe0ffULL, 0x00000100291a7825ULL, 0x100fe200078e0012ULL,
0x0000007a49537212ULL, 0x080fe400078e3cffULL, 0x000000150c00720cULL, 0x040fe20003f86070ULL,
0x000001002b1c7825ULL, 0x002fe200078e0012ULL, 0x0000007a0c4e7212ULL, 0x080fe400078e3cffULL,
0x0000007a0e4b7212ULL, 0x000fe200078e3cffULL, 0x00000010570d7824ULL, 0x000fe400078e020aULL,
0x000000100f187825ULL, 0x000fc600078e0018ULL, 0x00000000160d7faeULL, 0x0003e2000c101c46ULL,
0x00000010561f7824ULL, 0x000fe200078e020aULL, 0x000000154900720cULL, 0x000fe20003f06070ULL,
0x000000100f1a7825ULL, 0x000fc600078e001aULL, 0x00000000181f7faeULL, 0x0005e2000c901c46ULL,
0x000000100f1c7825ULL, 0x000fe200078e001cULL, 0x000000154800720cULL, 0x080fe40003f26070ULL,
0x000000001a217faeULL, 0x0007e2000d101c46ULL, 0x0000001054237824ULL, 0x000fe200078e020aULL,
0x0000000349167819ULL, 0x002fe200000006ffULL, 0x0000002c00117836ULL, 0x040fe40000000000ULL,
0x00000030000b7836ULL, 0x040fe20000000000ULL, 0x000000001c237faeULL, 0x0003e2000d901c46ULL,
0x00000038000d7836ULL, 0x000fe20000000000ULL, 0x000000151100720cULL, 0x080fe20003f46070ULL,
0x0000000848177824ULL, 0x000fe200078e00ffULL, 0x000000150b00720cULL, 0x080fe20003f66070ULL,
0x0000000811197824ULL, 0x004fe200078e00ffULL, 0x000000150d00720cULL, 0x040fe20003fa6070ULL,
0x000000080c157824ULL, 0x000fe200078e00ffULL, 0xfffffff817527812ULL, 0x000fe200078ee252ULL,
0x000000080d177824ULL, 0x000fe200078e00ffULL, 0x0000007a11507212ULL, 0x080fe200078e3cffULL,
0x00000001481b7824ULL, 0x108fe200078e0214ULL, 0x0000007a0d4c7212ULL, 0x000fe200078e3cffULL,
0x000000010b1f7824ULL, 0x100fe200078e0214ULL, 0xfffffff816537812ULL, 0x000fe200078ee253ULL,
0x000000010c217824ULL, 0x000fe200078e0214ULL, 0xfffffff819507812ULL, 0x000fe200078ee250ULL,
0x000001001b1a7825ULL, 0x000fe200078e0012ULL, 0xfffffff8154e7812ULL, 0x000fc400078ee24eULL,
0x0000007a0b4f7212ULL, 0x000fe200078e3cffULL, 0x0000000149157824ULL, 0x000fe200078e0214ULL,
0x000000030b167819ULL, 0x000fe200000006ffULL, 0x000001001f1e7825ULL, 0x000fe200078e0012ULL,
0x000000030e187819ULL, 0x040fe400000006ffULL, 0xfffffff8174c7812ULL, 0x000fe200078ee24cULL,
0x000000010e177824ULL, 0x000fe200078e0214ULL, 0x00000014111d7210ULL, 0x002fe20007ffe0ffULL,
0x0000010021207825ULL, 0x000fe200078e0012ULL, 0x000000140d197210ULL, 0x000fc40007ffe0ffULL,
0xfffffff8164f7812ULL, 0x000fe200078ee24fULL, 0x0000010015147825ULL, 0x100fe200078e0012ULL,
0xfffffff8184b7812ULL, 0x000fe400078ee24bULL, 0x0000000a52257211ULL, 0x080fe200078e20ffULL,
0x000001001d1c7825ULL, 0x000fe200078e0012ULL, 0x0000000a4e297211ULL, 0x000fc600078e20ffULL,
0x0000010019187825ULL, 0x000fc800078e0012ULL, 0x0000010017167825ULL, 0x000fc800078e0012ULL,
0x000000100f147825ULL, 0x000fc800078e0014ULL, 0x0000001053237824ULL, 0x000fe400078e020aULL,
0x000000100f1a7825ULL, 0x000fc600078e001aULL, 0x0000000014237faeULL, 0x0003e2000c101c46ULL,
0x000000100f1c7825ULL, 0x000fc600078e001cULL, 0x000000001a257faeULL, 0x0003e2000c901c46ULL,
0x000000100f1e7825ULL, 0x000fc800078e001eULL, 0x000000100f207825ULL, 0x000fc800078e0020ULL,
0x000000100f187825ULL, 0x000fc800078e0018ULL, 0x000000100f167825ULL, 0x000fc800078e0016ULL,
0x00000010500f7824ULL, 0x100fe400078e020aULL, 0x000000104f277824ULL, 0x100fe400078e020aULL,
0x000000104c2b7824ULL, 0x100fe200078e020aULL, 0x000000001c0f7faeULL, 0x0003e2000d101c46ULL,
0x000000104b2d7824ULL, 0x000fc600078e020aULL, 0x000000001e277faeULL, 0x0003e8000d901c46ULL,
0x0000000020297faeULL, 0x0003e8000e101c46ULL, 0x00000000182b7faeULL, 0x0003e8000e901c46ULL,
0x00000000162d7faeULL, 0x0003e2000f101c46ULL, 0x0000000800607947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe2000001167aULL, 0x00008a00ff127b82ULL, 0x000e620000000a00ULL,
0x000000077a4a7812ULL, 0x000fe400078ec0ffULL, 0x0000001000057810ULL, 0x000fe20007ffe0ffULL,
0x0000000800037836ULL, 0x040fe20000000000ULL, 0x0000000400027810ULL, 0x000fe20007ffe0ffULL,
0x0000000c00047836ULL, 0x000fe20000000000ULL, 0x0000007a05587212ULL, 0x0c0fe200078e3cffULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0x0000007a035a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000803077824ULL, 0x000fe200078e00ffULL, 0x0000007a04597212ULL, 0x080fe200078e3cffULL,
0x0000002800487836ULL, 0x040fe20000000000ULL, 0xfffffff809587812ULL, 0x000fe200078ee258ULL,
0x0000002000097836ULL, 0x000fe20000000000ULL, 0xfffffff8075a7812ULL, 0x000fe200078ee25aULL,
0x0000000802067824ULL, 0x000fe200078e00ffULL, 0x0000000304087819ULL, 0x000fe200000006ffULL,
0x0000002400497836ULL, 0x040fe20000000000ULL, 0x0000007a09547212ULL, 0x0c0fe200078e3cffULL,
0x0000003c000e7836ULL, 0x000fe20000000000ULL, 0x00000003090d7819ULL, 0x000fe200000006ffULL,
0x0000000102177824ULL, 0x100fe200078e0214ULL, 0x0000001800077810ULL, 0x000fe20007ffe0ffULL,
0x0000000104317824ULL, 0x100fe200078e0214ULL, 0xfffffff80d547812ULL, 0x000fe200078ee254ULL,
0x00000001052d7824ULL, 0x100fe200078e0214ULL, 0x0000007a48527212ULL, 0x0c0fe200078e3cffULL,
0x00000008070b7824ULL, 0x040fe200078e00ffULL, 0x00000003480d7819ULL, 0x000fe200000006ffULL,
0x00000001072b7824ULL, 0x100fe200078e0214ULL, 0xfffffff808597812ULL, 0x000fe200078ee259ULL,
0x0000001c00087836ULL, 0x000fe20000000000ULL, 0x0000007a025b7212ULL, 0x080fe200078e3cffULL,
0x0000000149257824ULL, 0x100fe200078e0214ULL, 0x0000007a07567212ULL, 0x080fe200078e3cffULL,
0x00000008080c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d527812ULL, 0x000fe200078ee252ULL,
0x00000038000d7836ULL, 0x040fe20000000000ULL, 0xfffffff8065b7812ULL, 0x000fe200078ee25bULL,
0x0000001400067836ULL, 0x000fe20000000000ULL, 0x0000007a08557212ULL, 0x080fe200078e3cffULL,
0x000000080d157824ULL, 0x040fe200078e00ffULL, 0xfffffff80b567812ULL, 0x000fe200078ee256ULL,
0x00000030000b7836ULL, 0x000fe20000000000ULL, 0x0000007a0d4c7212ULL, 0x080fe200078e3cffULL,
0x0000000108217824ULL, 0x100fe200078e0214ULL, 0xfffffff80c557812ULL, 0x000fe200078ee255ULL,
0x000000080b0c7824ULL, 0x040fe200078e00ffULL, 0x0000007a06577212ULL, 0x0c0fe200078e3cffULL,
0x000000010b1b7824ULL, 0x140fe200078e0214ULL, 0x00000003060a7819ULL, 0x000fe200000006ffULL,
0x0000000148277824ULL, 0x100fe200078e0214ULL, 0x0000002c00117810ULL, 0x000fe20007ffe0ffULL,
0x000000010e357824ULL, 0x000fe200078e0214ULL, 0x0000007a0b4f7212ULL, 0x000fe200078e3cffULL,
0x0000010031307825ULL, 0x002fe200078e0012ULL, 0xfffffff8154c7812ULL, 0x000fc400078ee24cULL,
0x0000007a00157212ULL, 0x080fe200078e3cffULL, 0x00000008110f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a577812ULL, 0x000fe200078ee257ULL, 0x00000008490a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c4f7812ULL, 0x000fe200078ee24fULL, 0x000001002d2c7825ULL, 0x100fe200078e0012ULL,
0x0000007a49537212ULL, 0x080fe400078e3cffULL, 0x0000007a11507212ULL, 0x000fe200078e3cffULL,
0x000001002b2a7825ULL, 0x000fe200078e0012ULL, 0x00000034000c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000715157812ULL, 0x000fe200078ec0ffULL, 0x0000010021207825ULL, 0x000fe200078e0012ULL,
0x000000140d1d7210ULL, 0x000fe40007ffe0ffULL, 0xfffffff80a537812ULL, 0x000fe200078ee253ULL,
0x000000080e0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f507812ULL, 0x000fe200078ee250ULL,
0x000000010c1f7824ULL, 0x000fe200078e0214ULL, 0x0000001400197210ULL, 0x000fe20007ffe0ffULL,
0x0000010025247825ULL, 0x000fe200078e0012ULL, 0x0000001403337210ULL, 0x000fc40007ffe0ffULL,
0x00000014062f7210ULL, 0x000fe20007ffe0ffULL, 0x0000010019187825ULL, 0x100fe200078e0012ULL,
0x0000001409297210ULL, 0x000fe40007ffe0ffULL, 0x0000001411237210ULL, 0x000fe20007ffe0ffULL,
0x0000010033327825ULL, 0x100fe200078e0012ULL, 0x0000007a0c4e7212ULL, 0x040fe400078e3cffULL,
0x000000030c0f7819ULL, 0x000fe200000006ffULL, 0x000001002f2e7825ULL, 0x000fe200078e0012ULL,
0x0ffffff8155d7812ULL, 0x000fc400078ef87aULL, 0x0000007a0e4b7212ULL, 0x000fe200078e3cffULL,
0x0000010017147825ULL, 0x100fe200078e0012ULL, 0x000000094d107c11ULL, 0x000fe4000f8e70ffULL,
0xfffffff80f4e7812ULL, 0x000fe200078ee24eULL, 0x000001001b167825ULL, 0x100fe200078e0012ULL,
0xfffffff80a4b7812ULL, 0x000fe400078ee24bULL, 0x000000084a0f7812ULL, 0x000fe200078efcffULL,
0x000001001d1a7825ULL, 0x000fc800078e0012ULL, 0x0000010029287825ULL, 0x000fc800078e0012ULL,
0x0000010027267825ULL, 0x000fc800078e0012ULL, 0x0000010023227825ULL, 0x000fc800078e0012ULL,
0x000001001f1e7825ULL, 0x000fc800078e0012ULL, 0x00000100351c7825ULL, 0x000fc800078e0012ULL,
0x00003000100a7836ULL, 0x000fe40000000000ULL, 0x000000100f187825ULL, 0x000fc600078e0018ULL,
0x0000000a583b7211ULL, 0x080fe200078e20ffULL, 0x000000105d357824ULL, 0x000fe200078e020aULL,
0x0000000a52437211ULL, 0x000fe200078e20ffULL, 0x000000100f147825ULL, 0x000fc600078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018357faeULL, 0x0003e2000b901c46ULL,
0x000000100f327825ULL, 0x000fc800078e0032ULL, 0x000000100f307825ULL, 0x000fc800078e0030ULL,
0x000000100f2c7825ULL, 0x000fe200078e002cULL, 0x0000000a55357211ULL, 0x002fc600078e20ffULL,
0x000000100f2e7825ULL, 0x000fc800078e002eULL, 0x000000100f2a7825ULL, 0x000fc800078e002aULL,
0x000000100f207825ULL, 0x000fc800078e0020ULL, 0x000000100f287825ULL, 0x000fc800078e0028ULL,
0x000000100f247825ULL, 0x000fc800078e0024ULL, 0x000000100f267825ULL, 0x000fc800078e0026ULL,
0x000000100f227825ULL, 0x000fc800078e0022ULL, 0x000000100f167825ULL, 0x000fc800078e0016ULL,
0x000000100f1e7825ULL, 0x000fc800078e001eULL, 0x000000100f1a7825ULL, 0x000fc800078e001aULL,
0x000000100f1c7825ULL, 0x000fe200078e001cULL, 0x0000000a5b0f7211ULL, 0x000fc600078e20ffULL,
0x000000105a377824ULL, 0x100fe400078e020aULL, 0x0000001059397824ULL, 0x100fe200078e020aULL,
0x00000000140f7faeULL, 0x0003e2000b901c46ULL, 0x00000010573d7824ULL, 0x100fe400078e020aULL,
0x0000001056197824ULL, 0x100fe200078e020aULL, 0x0000000032377faeULL, 0x000fe2000b901c46ULL,
0x00000010543f7824ULL, 0x100fe400078e020aULL, 0x0000001053417824ULL, 0x100fe200078e020aULL,
0x0000000030397faeULL, 0x0007e8000b901c46ULL, 0x000000002c3b7faeULL, 0x0009e2000b901c46ULL,
0x00000010500f7824ULL, 0x002fc400078e020aULL, 0x000000104f157824ULL, 0x100fe200078e020aULL,
0x000000002e3d7faeULL, 0x0003e8000b901c46ULL, 0x000000002a197faeULL, 0x0005e2000b901c46ULL,
0x000000104b317824ULL, 0x008fc600078e020aULL, 0x0000000020357faeULL, 0x0005e2000b901c46ULL,
0x0000000a4e2d7211ULL, 0x010fc600078e20ffULL, 0x00000000283f7faeULL, 0x0005e2000b901c46ULL,
0x000000104c2f7824ULL, 0x002fc600078e020aULL, 0x0000000024417faeULL, 0x0005e8000b901c46ULL,
0x0000000026437faeULL, 0x0005e8000b901c46ULL, 0x00000000220f7faeULL, 0x0005e8000b901c46ULL,
0x0000000016157faeULL, 0x0005e8000b901c46ULL, 0x000000001e2d7faeULL, 0x0005e8000b901c46ULL,
0x000000001a2f7faeULL, 0x0005e8000b901c46ULL, 0x000000001c317faeULL, 0x0005e4000b901c46ULL,
0x00000004ff767819ULL, 0x000fe2000001167aULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000084a0f7812ULL, 0x006fe400078ef87aULL, 0x0000000376157819ULL, 0x000fe400000006ffULL,
0x0000000776147812ULL, 0x000fe400078e780fULL, 0xfffffff815157812ULL, 0x000fe400078ee24aULL,
0x0000100010107810ULL, 0x000fe20007ffe0ffULL, 0x000000100f147824ULL, 0x000fe200078e0214ULL,
0x0000000715677812ULL, 0x040fe200078ec0ffULL, 0x0000000815667824ULL, 0x040fe200078e00ffULL,
0x0000000100687812ULL, 0x000fe200078ec0ffULL, 0x0000001015637836ULL, 0x040fe20000000000ULL,
0x00000001676b7812ULL, 0x000fe200078e7800ULL, 0x0000002015647836ULL, 0x040fe20000000000ULL,
0x0000000914147c11ULL, 0x000fe2000f8e20ffULL, 0x0000003015157836ULL, 0x000fe20000000000ULL,
0x000000666b6b7212ULL, 0x000fc400078efcffULL, 0x0000000763627812ULL, 0x040fe200078ec0ffULL,
0x0000000863637824ULL, 0x000fe200078e00ffULL, 0x0000000715607812ULL, 0x000fe200078ec0ffULL,
0x000000106b187824ULL, 0x000fe200078e0210ULL, 0x00000001626c7812ULL, 0x000fe200078e7800ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000636c6c7212ULL, 0x000fe200078efcffULL,
0x00000000142c783bULL, 0x0003e20000000200ULL, 0x0000000815657824ULL, 0x000fe200078e00ffULL,
0x0000000276167810ULL, 0x000fe40007ffe0ffULL, 0x000000001818783bULL, 0x000ea20000000200ULL,
0x000000106c247824ULL, 0x000fe200078e0210ULL, 0x0000000764617812ULL, 0x000fe400078ec0ffULL,
0x0000000160147812ULL, 0x002fe400078e7800ULL, 0x0000000267717812ULL, 0x000fe200078e1e68ULL,
0x000000002424783bULL, 0x000e620000000200ULL, 0x00000065146f7212ULL, 0x000fc400078efcffULL,
0x0000000716167812ULL, 0x000fe400078e780fULL, 0x0000000364647819ULL, 0x000fe200000006ffULL,
0x000000106f347824ULL, 0x100fe200078e0210ULL, 0x00000001616d7812ULL, 0x000fe400078e7800ULL,
0x0000006671717212ULL, 0x000fe400078efcffULL, 0x000000160f167211ULL, 0x000fe200078e20ffULL,
0x000000003434783bULL, 0x000ee20000000200ULL, 0x000000646d6d7212ULL, 0x000fe200078efcffULL,
0x0000001071407824ULL, 0x000fe200078e0210ULL, 0x0000000262747812ULL, 0x000fc400078e1e68ULL,
0x0000000916287c11ULL, 0x000fe4000f8e20ffULL, 0x000000106d1c7211ULL, 0x000fe200078e20ffULL,
0x000000004040783bULL, 0x000fe20000000200ULL, 0x0000006374747212ULL, 0x000fe400078efcffULL,
0x0000000260727812ULL, 0x000fe200078e1e68ULL, 0x000000002828783bULL, 0x000f220000000200ULL,
0x00000004626e7812ULL, 0x000fe200078e1e68ULL, 0x0000001074147824ULL, 0x000fe200078e0210ULL,
0x0000006572727212ULL, 0x000fe200078efcffULL, 0x000000001c1c783bULL, 0x000f620000000200ULL,
0x000000636e6e7212ULL, 0x000fc400078efcffULL, 0x0000000467737812ULL, 0x000fe200078e1e68ULL,
0x000000001414783bULL, 0x000f620000000200ULL, 0x000000182c20723cULL, 0x004fe200000018ffULL,
0x0000000667677812ULL, 0x000fe400078e1e68ULL, 0x0000006673737212ULL, 0x080fe400078efcffULL,
0x0000006667667212ULL, 0x000fe200078efcffULL, 0x0000001a2c18723cULL, 0x000fe200000018ffULL,
0x0000000662627812ULL, 0x000fe200078e1e68ULL, 0x0000001073447824ULL, 0x000fc600078e0210ULL,
0x0000006362627212ULL, 0x000fe200078efcffULL, 0x000000242c3c723cULL, 0x002fe200000018ffULL,
0x0000001066637824ULL, 0x100fe200078e0210ULL, 0x000000004444783bULL, 0x000fe80000000200ULL,
0x000000262c24723cULL, 0x000fec00000018ffULL, 0x000000342c30723cULL, 0x008fee00000018ffULL,
0x0000000261357812ULL, 0x000fe200078e1e68ULL, 0x000000402820723cULL, 0x010fe20000001820ULL,
0x0000001072347824ULL, 0x000fc400078e0210ULL, 0x0000006435707212ULL, 0x000fc600078efcffULL,
0x000000422840723cULL, 0x000fe20000001818ULL, 0x0000001070387211ULL, 0x000fca00078e20ffULL,
0x0000001c2c18723cULL, 0x020fe200000018ffULL, 0x000000003838783bULL, 0x000e6a0000000200ULL,
0x0000001e2c1c723cULL, 0x000fec00000018ffULL, 0x000000362c2c723cULL, 0x000fec00000018ffULL,
0x00000014283c723cULL, 0x000fe2000000183cULL, 0x0000000476367836ULL, 0x000fca0000000000ULL,
0x000000162814723cULL, 0x000fee0000001824ULL, 0x0000000736247812ULL, 0x000fe400078e780fULL,
0x000000003434783bULL, 0x000ea40000000200ULL, 0x000000240f247211ULL, 0x000fc800078e20ffULL,
0x0000000924247c11ULL, 0x000fe2000f8e20ffULL, 0x000000382818723cULL, 0x002fea0000001818ULL,
0x000000002424783bULL, 0x000e620000000200ULL, 0x0000003a281c723cULL, 0x000fe2000000181cULL,
0x000000106e387824ULL, 0x000fcc00078e0210ULL, 0x000000003838783bULL, 0x000ee20000000200ULL,
0x000000342830723cULL, 0x004fec0000001830ULL, 0x000000362828723cULL, 0x000fec000000182cULL,
0x000000442420723cULL, 0x002fe20000001820ULL, 0x00000004612d7812ULL, 0x000fc400078e1e68ULL,
0x00000004602c7812ULL, 0x000fe400078e1e68ULL, 0x000000642d6a7212ULL, 0x000fe200078efcffULL,
0x000000462440723cULL, 0x000fe20000001840ULL, 0x000000652c697212ULL, 0x080fe400078efcffULL,
0x000000106a347211ULL, 0x000fe400078e20ffULL, 0x0000000660607812ULL, 0x000fe200078e1e68ULL,
0x00000010692c7824ULL, 0x000fe200078e0210ULL, 0x0000003a2414723cULL, 0x008fe20000001814ULL,
0x0000000661617812ULL, 0x000fe200078e1e68ULL, 0x000000003434783bULL, 0x000e620000000200ULL,
0x0000006560607212ULL, 0x000fc400078efcffULL, 0x0000006461617212ULL, 0x000fe200078efcffULL,
0x000000002c2c783bULL, 0x000ea20000000200ULL, 0x00000006763a7836ULL, 0x000fe20000000000ULL,
0x00000038243c723cULL, 0x000fe2000000183cULL, 0x0000001060447824ULL, 0x000fcc00078e0210ULL,
0x0000001061387211ULL, 0x000fe200078e20ffULL, 0x000000004444783bULL, 0x000fe20000000200ULL,
0x000000342418723cULL, 0x002fec0000001818ULL, 0x0000002c2430723cULL, 0x004fe20000001830ULL,
0x000000073a347812ULL, 0x000fe400078e780fULL, 0x000000003838783bULL, 0x000fe40000000200ULL,
0x000000340f347211ULL, 0x000fe200078e20ffULL, 0x00000036241c723cULL, 0x000fe6000000181cULL,
0x00000009342c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001062347824ULL, 0x000fc400078e0210ULL,
0x0000002e2428723cULL, 0x000fe20000001828ULL, 0x000000006324783bULL, 0x000fe80000000200ULL,
0x000000002c2c783bULL, 0x000e680000000200ULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x000000262c40723cULL, 0x002fec0000001840ULL, 0x000000242c20723cULL, 0x000fe20000001820ULL,
0x0000000151267824ULL, 0x000fca00078e025cULL, 0x000000342c3c723cULL, 0x004fe2000000183cULL,
0x0000000126257810ULL, 0x000fc80007ffe0ffULL, 0x000000782500720cULL, 0x000fe20003f06070ULL,
0x000000362c14723cULL, 0x000fec0000001814ULL, 0x000000382c18723cULL, 0x000fec0000001818ULL,
0x0000003a2c1c723cULL, 0x000fec000000181cULL, 0x000000442c30723cULL, 0x000fec0000001830ULL,
0x000000462c28723cULL, 0x000fee0000001828ULL, 0x00000100262e7824ULL, 0x000fc800078e0279ULL,
0x0000000475367c24ULL, 0x000fe2000f8e022eULL, 0x0000000400e08947ULL, 0x000fd80003800000ULL,
0x0000000100257824ULL, 0x100fe200078e0236ULL, 0x000000047a2c7819ULL, 0x000fe200000006ffULL,
0x00000001022f7824ULL, 0x000fe200078e0236ULL, 0x0000002e5e277248ULL, 0x000fe20007fe0000ULL,
0x0000010025247825ULL, 0x000fe200078e0012ULL, 0x000000702c2c7812ULL, 0x000fe400078ec0ffULL,
0x0000003604397210ULL, 0x000fe20007ffe0ffULL, 0x0000000127277824ULL, 0x000fe200078e0a2eULL,
0x000000242c247210ULL, 0x000fe20007f1e0ffULL, 0x0000000103357824ULL, 0x000fe200078e0236ULL,
0x000000105a5a7211ULL, 0x000fe200078e20ffULL, 0x000000105d5d7824ULL, 0x000fe200078e0210ULL,
0x000000270200720cULL, 0x080fe20003f26070ULL, 0x0000010035347825ULL, 0x000fe200078e0012ULL,
0x000000270300720cULL, 0x000fc40003f46070ULL, 0x00000025ff257210ULL, 0x000fe200007fe4ffULL,
0x000001002f027825ULL, 0x100fe200078e0012ULL, 0x000000270000720cULL, 0x080fe40003f06070ULL,
0x000000270400720cULL, 0x080fe20003f66070ULL, 0x00000100392e7825ULL, 0x000fe200078e0012ULL,
0x000000022c027210ULL, 0x000fe40007f9e0ffULL, 0x000000342c347210ULL, 0x000fe20007fbe0ffULL,
0x0000000105397824ULL, 0x000fe200078e0236ULL, 0x0000002e2c2e7210ULL, 0x000fe20007fde0ffULL,
0x000000105b5b7824ULL, 0x100fe200078e0210ULL, 0x000000104f2d7211ULL, 0x000fe200078e20ffULL,
0x000000ffff037224ULL, 0x000fe200020e0603ULL, 0x0000002fff2f7210ULL, 0x000fe200037fe4ffULL,
0x000000ffff357224ULL, 0x000fe200028e0635ULL, 0x000000270500720cULL, 0x080fe20003fa6070ULL,
0x0000001059377824ULL, 0x000fe200078e0210ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000245d7faeULL, 0x000fe2000c101c46ULL, 0x0000010039387825ULL, 0x000fe200078e0012ULL,
0x000000270600720cULL, 0x000fc40003f86070ULL, 0x00000000025b7faeULL, 0x0003e2000c901c46ULL,
0x0000000106057824ULL, 0x100fe200078e0236ULL, 0x000000382c067210ULL, 0x000fe20007f3e0ffULL,
0x0000000108457824ULL, 0x100fe200078e0236ULL, 0x00000000345a7faeULL, 0x000fe2000d101c46ULL,
0x00000036073b7210ULL, 0x000fe20007ffe0ffULL, 0x00000001094f7824ULL, 0x000fe200078e0236ULL,
0x0000003649477210ULL, 0x000fe20007ffe0ffULL, 0x000000002e377faeULL, 0x0005e2000d901c46ULL,
0x000000270700720cULL, 0x080fe20003f66070ULL, 0x000000104e597824ULL, 0x000fe200078e0210ULL,
0x000000270800720cULL, 0x000fe20003f46070ULL, 0x0000010005027825ULL, 0x002fe200078e0012ULL,
0x0000001056567211ULL, 0x000fc400078e20ffULL, 0x0000001053537211ULL, 0x000fe200078e20ffULL,
0x000000ffff077224ULL, 0x000fe200008e0639ULL, 0x000000022c027210ULL, 0x000fe20007f1e0ffULL,
0x000001004f4e7825ULL, 0x000fe200078e0012ULL, 0x000000360b377210ULL, 0x004fc60007ffe0ffULL,
0x00000100452e7825ULL, 0x000fc800078e0012ULL, 0x000001003b047825ULL, 0x000fe200078e0012ULL,
0x0000002e2c2e7210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x0000004e2c087210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200008e062fULL,
0x000000042c047210ULL, 0x000fe20007fde0ffULL, 0x0000010047467825ULL, 0x000fe200078e0012ULL,
0x000000270900720cULL, 0x000fe40003f26070ULL, 0x00000005ff057210ULL, 0x000fe200037fe4ffULL,
0x0000000148257824ULL, 0x100fe200078e0236ULL, 0x000000462c387210ULL, 0x000fe20007fde0ffULL,
0x0000000111357824ULL, 0x000fc400078e0236ULL, 0x0000001058587824ULL, 0x100fe200078e0210ULL,
0x00000047ff397210ULL, 0x000fe200037fe4ffULL, 0x000000ffff097224ULL, 0x000fe200000e064fULL,
0x000000274900720cULL, 0x080fe20003f06070ULL, 0x0000001057577824ULL, 0x100fe200078e0210ULL,
0x0000000006587faeULL, 0x0003e2000e901c46ULL, 0x0000001055557824ULL, 0x100fe200078e0210ULL,
0x000000274800720cULL, 0x000fe20003fa6070ULL, 0x0000001054547824ULL, 0x100fe200078e0210ULL,
0x0000000002577faeULL, 0x0005e2000e101c46ULL, 0x0000001052527824ULL, 0x000fc400078e0210ULL,
0x0000001050507824ULL, 0x100fe200078e0210ULL, 0x0000000004567faeULL, 0x0007e2000d901c46ULL,
0x000000104c4c7824ULL, 0x000fe200078e0210ULL, 0x000000104b107211ULL, 0x000fe200078e20ffULL,
0x000000010d5d7824ULL, 0x000fe200078e0236ULL, 0x000000360e4b7210ULL, 0x000fe20007ffe0ffULL,
0x0000010025447825ULL, 0x000fe200078e0012ULL, 0x000000002e557faeULL, 0x000fe2000d101c46ULL,
0x000000270b00720cULL, 0x080fe40003f46070ULL, 0x000000010c5b7824ULL, 0x000fe200078e0236ULL,
0x000000442c067210ULL, 0x002fe20007fde0ffULL, 0x00000100353a7825ULL, 0x100fe200078e0012ULL,
0x0000000008547faeULL, 0x0003e6000c901c46ULL, 0x0000010037367825ULL, 0x100fe200078e0012ULL,
0x0000003a2c027210ULL, 0x004fe20007f9e0ffULL, 0x0000000038537faeULL, 0x0005e2000c101c46ULL,
0x000000270d00720cULL, 0x000fe20003f06070ULL, 0x000001005d247825ULL, 0x000fe200078e0012ULL,
0x000000362c047210ULL, 0x008fc60007f7e0ffULL, 0x000001005b347825ULL, 0x000fe200078e0012ULL,
0x000000242c087210ULL, 0x002fe40007f3e0ffULL, 0x00000037ff057210ULL, 0x000fe20001ffe4ffULL,
0x000000ffff077224ULL, 0x000fe200030e0645ULL, 0x000000271100720cULL, 0x080fe20003fc6070ULL,
0x000000ffff037224ULL, 0x000fe200020e063bULL, 0x000000342c2e7210ULL, 0x000fe20007f9e0ffULL,
0x000001004b127825ULL, 0x000fe200078e0012ULL, 0x000000270c00720cULL, 0x080fe20003f66070ULL,
0x0000000006527faeULL, 0x0005e4000e901c46ULL, 0x000000ffff097224ULL, 0x000fe200008e0625ULL,
0x000000270e00720cULL, 0x000fe20003f26070ULL, 0x000000ffff2f7224ULL, 0x000fe200020e0635ULL,
0x000000122c0c7210ULL, 0x000fc60007f9e0ffULL, 0x0000000002507faeULL, 0x0005e2000f101c46ULL,
0x00000013ff0d7210ULL, 0x000fc600027fe4ffULL, 0x00000000042d7faeULL, 0x0005e8000d101c46ULL,
0x000000002e597faeULL, 0x0005e8000d901c46ULL, 0x00000000084c7faeULL, 0x0005e8000c101c46ULL,
0x000000000c107faeULL, 0x0005e2000c901c46ULL, 0x0000000400947947ULL, 0x000fea0003800000ULL,
0x0000000102257824ULL, 0x100fe200078e0236ULL, 0x000000047a027819ULL, 0x000fe200000006ffULL,
0x0000000100657824ULL, 0x100fe200078e0236ULL, 0x0000003603467210ULL, 0x000fe20007ffe0ffULL,
0x00000001492c7824ULL, 0x000fe200078e0236ULL, 0x0000007002027812ULL, 0x000fe200078ec0ffULL,
0x0000010065647825ULL, 0x000fe200078e0012ULL, 0x0000003606387210ULL, 0x000fe40007ffe0ffULL,
0x00000036092e7210ULL, 0x000fe20007ffe0ffULL, 0x0000000148247824ULL, 0x000fe200078e0236ULL,
0x0000006402647210ULL, 0x000fe20007f1e0ffULL, 0x0000010025487825ULL, 0x000fe200078e0012ULL,
0x0000003611117210ULL, 0x000fc40007ffe0ffULL, 0x00000065ff657210ULL, 0x000fe200007fe4ffULL,
0x0000010046467825ULL, 0x000fe200078e0012ULL, 0x0000004802487210ULL, 0x000fe40007f1e0ffULL,
0x000000105b5b7211ULL, 0x080fe200078e20ffULL, 0x0000000104447824ULL, 0x000fe200078e0236ULL,
0x000000360d047210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200000e0649ULL,
0x0000004602467210ULL, 0x000fe20007f1e0ffULL, 0x0000010044447825ULL, 0x000fe200078e0012ULL,
0x0000001058587211ULL, 0x000fc400078e20ffULL, 0x00000047ff477210ULL, 0x000fe200007fe4ffULL,
0x00000001053a7824ULL, 0x000fe200078e0236ULL, 0x0000004402447210ULL, 0x000fe20007f1e0ffULL,
0x0000010038387825ULL, 0x100fe200078e0012ULL, 0x0000001055557211ULL, 0x080fe400078e20ffULL,
0x0000001052527211ULL, 0x080fe200078e20ffULL, 0x000001003a3a7825ULL, 0x000fe200078e0012ULL,
0x000000104c4c7211ULL, 0x000fc600078e20ffULL, 0x000000ffff457224ULL, 0x000fe200000e0645ULL,
0x0000003a023a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000107377824ULL, 0x100fe400078e0236ULL,
0x0000000108347824ULL, 0x100fe200078e0236ULL, 0x0000003bff3b7210ULL, 0x000fe200007fe4ffULL,
0x000000010b087824ULL, 0x100fe200078e0236ULL, 0x0000003802387210ULL, 0x000fe20007f1e0ffULL,
0x000000010c067824ULL, 0x100fe400078e0236ULL, 0x000000010e0e7824ULL, 0x000fc400078e0236ULL,
0x0000010037367825ULL, 0x000fc800078e0012ULL, 0x000000ffff397224ULL, 0x000fe200000e0639ULL,
0x0000003602367210ULL, 0x000fe20007f1e0ffULL, 0x0000010034347825ULL, 0x000fc600078e0012ULL,
0x00000037ff377210ULL, 0x000fe200007fe4ffULL, 0x000001002e2e7825ULL, 0x000fe200078e0012ULL,
0x0000003402347210ULL, 0x000fc60007f1e0ffULL, 0x000001002c2c7825ULL, 0x000fc800078e0012ULL,
0x000000ffff357224ULL, 0x000fe200000e0635ULL, 0x0000002e022e7210ULL, 0x000fe20007f1e0ffULL,
0x0000010024247825ULL, 0x000fc600078e0012ULL, 0x0000002fff2f7210ULL, 0x000fe200007fe4ffULL,
0x00000100110c7825ULL, 0x000fe200078e0012ULL, 0x0000002c022c7210ULL, 0x000fc60007f1e0ffULL,
0x0000010008087825ULL, 0x000fc800078e0012ULL, 0x000000ffff2d7224ULL, 0x000fe200000e062dULL,
0x0000002402247210ULL, 0x000fe20007f1e0ffULL, 0x0000010006067825ULL, 0x000fc600078e0012ULL,
0x00000025ff257210ULL, 0x000fe200007fe4ffULL, 0x000000105d5d7824ULL, 0x100fe200078e0210ULL,
0x0000000c020c7210ULL, 0x000fe20007f1e0ffULL, 0x000000105a5a7824ULL, 0x100fe400078e0210ULL,
0x0000001059597824ULL, 0x000fe200078e0210ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000645d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000000802087210ULL, 0x000fe20007f1e0ffULL, 0x0000010004047825ULL, 0x000fe200078e0012ULL,
0x00000000485b7faeULL, 0x0003e4000b901c46ULL, 0x00000009ff097210ULL, 0x000fe200007fe4ffULL,
0x0000001057577824ULL, 0x000fe200078e0210ULL, 0x0000000602067210ULL, 0x000fe20007f1e0ffULL,
0x000001000e127825ULL, 0x000fe200078e0012ULL, 0x00000000465a7faeULL, 0x0003e6000b901c46ULL,
0x0000001056567824ULL, 0x100fe200078e0210ULL, 0x0000000044597faeULL, 0x0003e2000b901c46ULL,
0x0000001054547824ULL, 0x000fc400078e0210ULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000000402047210ULL, 0x000fe20007f1e0ffULL, 0x0000001053537824ULL, 0x100fe200078e0210ULL,
0x000000003a587faeULL, 0x0003e2000b901c46ULL, 0x0000001202027210ULL, 0x000fe20007f3e0ffULL,
0x0000001050507824ULL, 0x100fe200078e0210ULL, 0x00000005ff057210ULL, 0x000fe200007fe4ffULL,
0x0000000038577faeULL, 0x0003e2000b901c46ULL, 0x000000104f4f7824ULL, 0x100fe400078e0210ULL,
0x000000104e4e7824ULL, 0x100fe200078e0210ULL, 0x0000000036567faeULL, 0x0003e2000b901c46ULL,
0x000000104b107824ULL, 0x000fc400078e0210ULL, 0x000000ffff037224ULL, 0x000fe200008e0613ULL,
0x0000000034557faeULL, 0x0003e8000b901c46ULL, 0x000000002e547faeULL, 0x0003e8000b901c46ULL,
0x000000002c537faeULL, 0x0003e8000b901c46ULL, 0x0000000024527faeULL, 0x0003e8000b901c46ULL,
0x000000000c507faeULL, 0x0003e8000b901c46ULL, 0x00000000084f7faeULL, 0x0003e8000b901c46ULL,
0x00000000064e7faeULL, 0x0003e8000b901c46ULL, 0x00000000044c7faeULL, 0x0003e8000b901c46ULL,
0x0000000002107faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000876027810ULL, 0x006fe20007ffe0ffULL, 0x000000106c387824ULL, 0x100fe200078e020aULL,
0x0000000a6b047211ULL, 0x080fe200078e20ffULL, 0x0000000a76087836ULL, 0x000fe20000000000ULL,
0x0000000702027812ULL, 0x000fe200078e780fULL, 0x0000001062647824ULL, 0x000fe200078e020aULL,
0x0000000a6d107211ULL, 0x080fe200078e20ffULL, 0x000000047a037824ULL, 0x000fe200078e00ffULL,
0x0000000708087812ULL, 0x000fe200078e780fULL, 0x000000100f027824ULL, 0x000fe200078e0202ULL,
0x0000000a6f2c7211ULL, 0x000fc400078e20ffULL, 0x0000000a71447211ULL, 0x080fe200078e20ffULL,
0x000000100f087824ULL, 0x000fe200078e0208ULL, 0x0000000902027c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a690c7211ULL, 0x000fe400078e20ffULL, 0x0000000908087c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff003037812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000404783bULL, 0x000fe80000000200ULL, 0x000000000234783bULL, 0x0002a80000000200ULL,
0x000000003838783bULL, 0x000ee80000000200ULL, 0x000000001010783bULL, 0x000f220000000200ULL,
0x0000000c76027836ULL, 0x002fe20000000000ULL, 0x0000000e76767810ULL, 0x000fc40007ffe0ffULL,
0x000000002c2c783bULL, 0x000e640000000200ULL, 0x0000000702027812ULL, 0x000fe400078e780fULL,
0x000000000854783bULL, 0x000be20000000200ULL, 0x0000000776767812ULL, 0x000fe400078e780fULL,
0x000000100f027824ULL, 0x040fe200078e0202ULL, 0x000000004444783bULL, 0x000e640000000200ULL,
0x000000100f767824ULL, 0x000fc400078e0276ULL, 0x0000000902027c11ULL, 0x000fe2000f8e20ffULL,
0x000000000c0c783bULL, 0x000fe20000000200ULL, 0x0000000a61087211ULL, 0x020fe400078e20ffULL,
0x0000000976587c11ULL, 0x000fcc000f8e20ffULL, 0x000000005858783bULL, 0x000fe20000000200ULL,
0x000000043420723cULL, 0x004fec0000001820ULL, 0x000000063440723cULL, 0x000fe20000001840ULL,
0x0000001074047824ULL, 0x000fca00078e020aULL, 0x00000038343c723cULL, 0x008fe2000000183cULL,
0x000000000404783bULL, 0x000eaa0000000200ULL, 0x000000103418723cULL, 0x010fec0000001818ULL,
0x0000003a3414723cULL, 0x000fe20000001814ULL, 0x0000000a70107211ULL, 0x000fe200078e20ffULL,
0x000000000238783bULL, 0x0007e80000000200ULL, 0x00000012341c723cULL, 0x000fe2000000181cULL,
0x000000001010783bULL, 0x000f220000000200ULL, 0x0000000100027802ULL, 0x008fc80000000f00ULL,
0x0000002c3430723cULL, 0x002fec0000001830ULL, 0x0000002e3428723cULL, 0x000fe20000001828ULL,
0x0000000a722c7211ULL, 0x000fca00078e20ffULL, 0x000000445420723cULL, 0x000fe20000001820ULL,
0x000000002c2c783bULL, 0x000e620000000200ULL, 0x0000000a73347211ULL, 0x000fc800078e20ffULL,
0x00000004543c723cULL, 0x004fe2000000183cULL, 0x000000106e447824ULL, 0x100fe200078e020aULL,
0x000000003434783bULL, 0x000ea80000000200ULL, 0x000000065414723cULL, 0x000fe20000001814ULL,
0x000000106a047824ULL, 0x000fca00078e020aULL, 0x000000465440723cULL, 0x000fe20000001840ULL,
0x000000000404783bULL, 0x000ee80000000200ULL, 0x000000004444783bULL, 0x000f620000000200ULL,
0x000000105418723cULL, 0x010fec0000001818ULL, 0x00000012541c723cULL, 0x000fe2000000181cULL,
0x0000000a66107211ULL, 0x000fc400078e20ffULL, 0x000000006464783bULL, 0x000fe80000000200ULL,
0x000000001010783bULL, 0x000f220000000200ULL, 0x0000002c5430723cULL, 0x002fec0000001830ULL,
0x0000002e5428723cULL, 0x000fe20000001828ULL, 0x00000010602c7824ULL, 0x000fc400078e020aULL,
0x000000000808783bULL, 0x000e660000000200ULL, 0x000000343820723cULL, 0x004fe20000001820ULL,
0x000000002c2c783bULL, 0x000eaa0000000200ULL, 0x000000043818723cULL, 0x008fe20000001818ULL,
0x01b688027b0479a7ULL, 0x000eea000850003fULL, 0x000000363840723cULL, 0x000fec0000001840ULL,
0x00000044383c723cULL, 0x020fec000000183cULL, 0x000000463814723cULL, 0x000fec0000001814ULL,
0x00000006381c723cULL, 0x000fe2000000181cULL, 0x01b688057b0075a7ULL, 0x008eea000800017fULL,
0x0000000c3830723cULL, 0x000fe20000001830ULL, 0x000000094d067c11ULL, 0x000fc8000f8e38ffULL,
0x0000000306037210ULL, 0x000fe20007ffe0ffULL, 0x0000000e3828723cULL, 0x000fec0000001828ULL,
0x000000105820723cULL, 0x010fec0000001820ULL, 0x000000125840723cULL, 0x000fec0000001840ULL,
0x00000064583c723cULL, 0x000fec000000183cULL, 0x000000665814723cULL, 0x000fec0000001814ULL,
0x000000085818723cULL, 0x002fe20000001818ULL, 0x3db504f321217820ULL, 0x000fe20000410000ULL,
0x3db504f322227820ULL, 0x000fe20000410000ULL, 0x3db504f323237820ULL, 0x000fc60000410000ULL,
0x0000000a581c723cULL, 0x000fe2000000181cULL, 0x3db504f320097820ULL, 0x000fe20000410000ULL,
0x3db504f340407820ULL, 0x000fe20000410000ULL, 0x3db504f341417820ULL, 0x000fe20000410000ULL,
0x3db504f342427820ULL, 0x000fe20000410000ULL, 0x3db504f343437820ULL, 0x000fe20000410000ULL,
0x0000002c5830723cULL, 0x004fe20000001830ULL, 0x3db504f33c3c7820ULL, 0x000fe20000410000ULL,
0x3db504f33d3d7820ULL, 0x000fe20000410000ULL, 0x3db504f33e3e7820ULL, 0x000fe20000410000ULL,
0x3db504f33f3f7820ULL, 0x000fc40000410000ULL, 0x0000002e5828723cULL, 0x000fe20000001828ULL,
0x3db504f314147820ULL, 0x000fe20000410000ULL, 0x3db504f315157820ULL, 0x000fe20000410000ULL,
0x3db504f316167820ULL, 0x000fe20000410000ULL, 0x3db504f317177820ULL, 0x000fe40000410000ULL,
0x3db504f318187820ULL, 0x000fe20000410000ULL, 0x3db504f319197820ULL, 0x000fe20000410000ULL,
0x3db504f31a1a7820ULL, 0x000fe20000410000ULL, 0x3db504f31b1b7820ULL, 0x000fc60000410000ULL,
0x3db504f31c1c7820ULL, 0x000fe20000410000ULL, 0x3db504f31d1d7820ULL, 0x000fe20000410000ULL,
0x3db504f31e1e7820ULL, 0x000fe20000410000ULL, 0x3db504f31f1f7820ULL, 0x000fc60000410000ULL,
0x3db504f330307820ULL, 0x000fe20000410000ULL, 0x3db504f331317820ULL, 0x000fe20000410000ULL,
0x3db504f332327820ULL, 0x000fe20000410000ULL, 0x3db504f333337820ULL, 0x000fc60000410000ULL,
0x3db504f328287820ULL, 0x000fe20000410000ULL, 0x3db504f329297820ULL, 0x000fe20000410000ULL,
0x3db504f32a2a7820ULL, 0x000fe20000410000ULL, 0x3db504f32b2b7820ULL, 0x000fe20000410000ULL,
0x0000001000c08947ULL, 0x008fec0003800000ULL, 0x01b4000003047984ULL, 0x0002a20000000c00ULL,
0x0000007d5c00720cULL, 0x000fda0003f05270ULL, 0x0000000400080947ULL, 0x002fea0003800000ULL,
0x000000027a087824ULL, 0x000fe200078e00ffULL, 0x8000005f5e5f7210ULL, 0x000fc80007ffe0ffULL,
0x0000000608087812ULL, 0x000fc800078ec0ffULL, 0x00000001080a7812ULL, 0x040fe400078efcffULL,
0x00000008080b7812ULL, 0x000fe400078efcffULL, 0x0000005f0a00720cULL, 0x080fe40003f26070ULL,
0x00000010080a7812ULL, 0x000fe400078efcffULL, 0x0000005f0b00720cULL, 0x080fe40003f06070ULL,
0x0000005f0a00720cULL, 0x000fc40003fc6070ULL, 0x00000011080b7812ULL, 0x040fe400078efcffULL,
0x00000018080a7812ULL, 0x040fe400078efcffULL, 0x0000005f0800720cULL, 0x080fe40003f46070ULL,
0x0000005f0b00720cULL, 0x080fe40003fa6070ULL, 0x0000005f0a00720cULL, 0x000fe40003f66070ULL,
0x00000009080c7812ULL, 0x000fc400078efcffULL, 0x00000019080b7812ULL, 0x040fe400078efcffULL,
0x00000020080a7812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff09097808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff21217808ULL, 0x000fc40004800000ULL, 0x0000005f0c00720cULL, 0x080fe40003f86070ULL,
0x0000005f0b00720cULL, 0x080fe40003f46070ULL, 0x0000005f0a00720cULL, 0x000fe40003f26070ULL,
0x00000021080b7812ULL, 0x040fe400078efcffULL, 0x00000028080a7812ULL, 0x000fe400078efcffULL,
0xff7fffff42427808ULL, 0x000fc40004000000ULL, 0xff7fffff40407808ULL, 0x000fe40004000000ULL,
0xff7fffff43437808ULL, 0x000fe40006000000ULL, 0xff7fffff41417808ULL, 0x000fe40006000000ULL,
0x0000005f0b00720cULL, 0x080fe40003f06070ULL, 0x0000005f0a00720cULL, 0x000fe40003f86070ULL,
0x00000029080b7812ULL, 0x000fc400078efcffULL, 0x00000030080a7812ULL, 0x000fe400078efcffULL,
0xff7fffff3e3e7808ULL, 0x000fe40007000000ULL, 0xff7fffff3c3c7808ULL, 0x000fe40007000000ULL,
0xff7fffff3f3f7808ULL, 0x000fe40006800000ULL, 0xff7fffff3d3d7808ULL, 0x000fe40006800000ULL,
0x0000005f0b00720cULL, 0x000fc40003fc6070ULL, 0x0000005f0a00720cULL, 0x000fe40003fa6070ULL,
0x00000031080b7812ULL, 0x040fe400078efcffULL, 0x00000038080a7812ULL, 0x040fe400078efcffULL,
0x0000003908087812ULL, 0x000fe400078efcffULL, 0xff7fffff16167808ULL, 0x000fe40005800000ULL,
0xff7fffff14147808ULL, 0x000fc40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005000000ULL,
0xff7fffff15157808ULL, 0x000fe40005000000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40004800000ULL,
0xff7fffff18187808ULL, 0x000fe40004800000ULL, 0x0000005f0b00720cULL, 0x080fe40003f66070ULL,
0x0000005f0a00720cULL, 0x000fc40003f46070ULL, 0x0000005f0800720cULL, 0x000fe40003f26070ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004000000ULL, 0xff7fffff19197808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff1c1c7808ULL, 0x000fe40006000000ULL,
0xff7fffff1f1f7808ULL, 0x000fc40007000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40007000000ULL,
0xff7fffff32327808ULL, 0x000fe40006800000ULL, 0xff7fffff30307808ULL, 0x000fe40006800000ULL,
0xff7fffff33337808ULL, 0x000fe40005800000ULL, 0xff7fffff31317808ULL, 0x000fe40005800000ULL,
0xff7fffff2a2a7808ULL, 0x000fc40005000000ULL, 0xff7fffff28287808ULL, 0x000fe40005000000ULL,
0xff7fffff2b2b7808ULL, 0x000fe40004800000ULL, 0xff7fffff29297808ULL, 0x000fce0004800000ULL,
0x0000000904047209ULL, 0x004fe20007810000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000002205087209ULL, 0x000fe40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x00000023080b7209ULL, 0x000fe40007810000ULL, 0x0000004005047209ULL, 0x000fe40007810000ULL,
0x000000420b087209ULL, 0x000fc40007810000ULL, 0x0000004104057209ULL, 0x000fe40007810000ULL,
0x00000043080b7209ULL, 0x000fe40007810000ULL, 0x0000003c05047209ULL, 0x000fe40007810000ULL,
0x0000003e0b087209ULL, 0x000fe40007810000ULL, 0x0000003d04057209ULL, 0x000fe40007810000ULL,
0x0000003f080b7209ULL, 0x000fc40007810000ULL, 0x0000001405047209ULL, 0x000fe40007810000ULL,
0x000000160b087209ULL, 0x000fe40007810000ULL, 0x0000001504057209ULL, 0x000fe40007810000ULL,
0x00000017080b7209ULL, 0x000fe40007810000ULL, 0x0000001805047209ULL, 0x000fe40007810000ULL,
0x0000001a0b087209ULL, 0x000fc40007810000ULL, 0x0000001904057209ULL, 0x000fe40007810000ULL,
0x0000001b080b7209ULL, 0x000fe40007810000ULL, 0x0000001c05047209ULL, 0x000fe40007810000ULL,
0x0000001e0b087209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000001f080b7209ULL, 0x000fc40007810000ULL, 0x0000003005047209ULL, 0x000fe40007810000ULL,
0x000000320b087209ULL, 0x000fe40007810000ULL, 0x0000003104057209ULL, 0x000fe40007810000ULL,
0x00000033080b7209ULL, 0x000fe40007810000ULL, 0x0000002805047209ULL, 0x000fe40007810000ULL,
0x0000002a0b087209ULL, 0x000fc40007810000ULL, 0x0000002904047209ULL, 0x000fe40007810000ULL,
0x0000002b08087209ULL, 0x000fe20007810000ULL, 0x0000000e043c7947ULL, 0x000fec000b800000ULL,
0x0c401f0004057f89ULL, 0x000e6800000e0000ULL, 0x0c401f00080b7f89ULL, 0x000ea800000e0000ULL,
0x0c401f00060d7f89ULL, 0x000ee800000e0000ULL, 0x0c401f0007207f89ULL, 0x000f2200000e0000ULL,
0x00000005040a7209ULL, 0x002fc40007810000ULL, 0x0000000b080b7209ULL, 0x004fc60007810000ULL,
0x0c201f000a057f89ULL, 0x000e6200000e0000ULL, 0x0000000d060d7209ULL, 0x008fc60007810000ULL,
0x0c201f000b0c7f89ULL, 0x000ea200000e0000ULL, 0x0000002007207209ULL, 0x010fc60007810000ULL,
0x0c201f000d0e7f89ULL, 0x000ee800000e0000ULL, 0x0c201f0020257f89ULL, 0x00092200000e0000ULL,
0x000000050a047209ULL, 0x002fe40007810000ULL, 0x0000000c0b057209ULL, 0x004fe40007810000ULL,
0x0000000e0d067209ULL, 0x008fce0007810000ULL, 0x3fb8aa3b04087820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b05277820ULL, 0x000fc60000410000ULL, 0x3fb8aa3b09097823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b41417823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b43437823ULL, 0x100fe20000010827ULL, 0x0000000900097308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010808ULL, 0x00000021000a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b29087823ULL, 0x000fe20000010808ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010827ULL, 0x0000004000407308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010827ULL, 0x0000004100417308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b2b277823ULL, 0x000fca0000010827ULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x00000042000b7308ULL, 0x000ff00000000800ULL,
0x0000004300107308ULL, 0x000e700000000800ULL, 0x0000000800217308ULL, 0x0005e20000000800ULL,
0x0000000b100b723eULL, 0x002fce00000000ffULL, 0x0000001800077308ULL, 0x0003e20000000800ULL,
0x000000090a08723eULL, 0x004fe400000000ffULL, 0x00000040410a723eULL, 0x000fe400000000ffULL,
0x000000222309723eULL, 0x000fc600000000ffULL, 0x0000001900247308ULL, 0x0005e20000000800ULL,
0x3c003c00ff187424ULL, 0x002fce00078e00ffULL, 0x00000014000e7308ULL, 0x000fe20000000800ULL,
0x3c003c0000197802ULL, 0x004fe20000000f00ULL, 0x0000000000007948ULL, 0x000fec0003800000ULL,
0x000000180810723cULL, 0x000fe200000018ffULL, 0x0000003c000c7308ULL, 0x000ff00000000800ULL,
0x0000003d003d7308ULL, 0x000e700000000800ULL, 0x0000001500157308ULL, 0x000ea20000000800ULL,
0x0000000c3d0c723eULL, 0x002fce00000000ffULL, 0x0000003e000d7308ULL, 0x000fe20000000800ULL,
0x0000000e150e723eULL, 0x004fce00000000ffULL, 0x0000003f00147308ULL, 0x000e700000000800ULL,
0x00000016000f7308ULL, 0x000fe20000000800ULL, 0x0000000d140d723eULL, 0x002fce00000000ffULL,
0x0000001700227308ULL, 0x000e620000000800ULL, 0x000000072414723eULL, 0x000fe400000000ffULL,
0xfffffffc7a077812ULL, 0x000fca00078ec0ffULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x0000000f220f723eULL, 0x002fce00000000ffULL, 0x0000001d001d7308ULL, 0x000e620000000800ULL,
0x000000180c10723cULL, 0x000fee0000001810ULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x0000001c1d16723eULL, 0x002fce00000000ffULL, 0x0000001b001b7308ULL, 0x000e700000000800ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x0000001a1b15723eULL, 0x002fce00000000ffULL,
0x0000001f00177308ULL, 0x000e700000000800ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x0000001e1717723eULL, 0x002fce00000000ffULL, 0x0000003100317308ULL, 0x000e620000000800ULL,
0x000000181410723cULL, 0x000fee0000001810ULL, 0x0000002800287308ULL, 0x000ea20000000800ULL,
0x00000030311c723eULL, 0x002fce00000000ffULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x00000028211e723eULL, 0x004fce00000000ffULL, 0x0000003300337308ULL, 0x000e700000000800ULL,
0x0000002a001f7308ULL, 0x000fe20000000800ULL, 0x00000032331d723eULL, 0x002fce00000000ffULL,
0x00000027001a7308ULL, 0x000e640000000800ULL, 0x0000001f1a1f723eULL, 0x002fce00000000ffULL,
0x000000181c18723cULL, 0x000fee0000001810ULL, 0x0000000fff107424ULL, 0x000fda00078e00ffULL,
0x0000000710197219ULL, 0x000fe400000006ffULL, 0x0000002520077209ULL, 0x010fe20007810000ULL,
0x001c1fff18107589ULL, 0x00026200000e0000ULL, 0x0000000000227806ULL, 0x000fe200038e0100ULL,
0x00000000191273a1ULL, 0x000eb000000e8000ULL, 0x00000000190473c4ULL, 0x000ee20000004000ULL,
0x0000000000057886ULL, 0x000fc400038e0100ULL, 0x0000000519ff7c12ULL, 0x004fda000f804012ULL,
0x0000000a04508947ULL, 0x00afea000b800000ULL, 0x001c1fff1a117589ULL, 0x0002a800000e0000ULL,
0x001c1fff12127589ULL, 0x000ee800000e0000ULL, 0x001c1fff00137589ULL, 0x00032400000e0000ULL,
0xfffffff8ff4a7812ULL, 0x000fe200078ee24aULL, 0x000000ffff287224ULL, 0x000fe200078e0008ULL,
0x0000000300217812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x000000094d187c11ULL, 0x000fe2000f8e58ffULL, 0x000000084a1a7836ULL, 0x042fe20000000000ULL,
0x0000000421237812ULL, 0x000fe200078efcffULL, 0x000000ffff087224ULL, 0x000fe200078e0009ULL,
0x0000000721197812ULL, 0x000fe200078e784aULL, 0x000000ffff2c7224ULL, 0x000fe200078e0014ULL,
0x00000007231b7812ULL, 0x000fe200078e784aULL, 0x000000ffff2e7224ULL, 0x000fe200078e001cULL,
0x000000034a007819ULL, 0x000fe200000006ffULL, 0x000000ffff0c7224ULL, 0x000fe200078e0015ULL,
0x0000000721217812ULL, 0x000fe200078e781aULL, 0x000000ffff5c7224ULL, 0x000fe200078e0026ULL,
0x0000000723237812ULL, 0x000fe200078e781aULL, 0x000000081a1a7824ULL, 0x000fe200078e00ffULL,
0x0001100018187810ULL, 0x000fc40007ffe0ffULL, 0x0000000019197212ULL, 0x080fe400078efcffULL,
0x000000037aff7812ULL, 0x000fe4000780c0ffULL, 0x000000001b1b7212ULL, 0x000fe200078efcffULL,
0x0000001019197824ULL, 0x100fe200078e0218ULL, 0x0000001a21217212ULL, 0x080fe400078efcffULL,
0x0000001a23237212ULL, 0x000fe400078efcffULL, 0x0000000a00297202ULL, 0x000fe20000000f00ULL,
0x0000001021217824ULL, 0x000fe200078e0218ULL, 0x0000000e002b7202ULL, 0x000fe20000000f00ULL,
0x000000ffff0a7224ULL, 0x000fe200078e000dULL, 0x000000181b1b7211ULL, 0x000fe200078e20ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e001dULL, 0x00000016002d7202ULL, 0x000fe20000000f00ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000002819007844ULL, 0x0003e20000000200ULL,
0x0000001e002f7202ULL, 0x000fc40000000f00ULL, 0x0000000b00097202ULL, 0x000fe40000000f00ULL,
0x0000000f000b7202ULL, 0x000fe20000000f00ULL, 0x0000002c1b007844ULL, 0x0003e20000000200ULL,
0x0000001823237211ULL, 0x000fe400078e20ffULL, 0x00000017000d7202ULL, 0x000fe20000000f00ULL,
0x0000000821007844ULL, 0x0003e20000000200ULL, 0x0000001f000f7202ULL, 0x000fca0000000f00ULL,
0x0000000c23007844ULL, 0x0003e80000000200ULL, 0x01b0000403008388ULL, 0x0003e80000000c00ULL,
0x01b2001003008388ULL, 0x01c3e20000000c00ULL, 0x000000782600720cULL, 0x000fe20003f06070ULL,
0x01b6080277ff79a7ULL, 0x0003e2000850003fULL, 0x01b6100277ff79a7ULL, 0x0003e2000850003fULL,
0x01b6180277ff79a7ULL, 0x0003e2000850003fULL, 0x01b6200277ff79a7ULL, 0x0003f2000850003fULL,
0xffffffb800f48947ULL, 0x002fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x01b6080d540075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01b6080d540095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff3c00047947ULL, 0x000fea000383ffffULL,
0x01b6280d540075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01b6280d540095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff4c00587947ULL, 0x000fea000383ffffULL,
0x01b6480d0f0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01b6480d0f0085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff5800fc7947ULL, 0x000fea000383ffffULL,
0x01b66805620075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01b66805620085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff6800907947ULL, 0x000fea000383ffffULL,
0x00000009ff057e24ULL, 0x004fc8000f8e00ffULL, 0x01b60003050075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01b60003050085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffffb800647947ULL, 0x000fea000383ffffULL, 0x01b688057b0075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01b688057b0085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffec00287947ULL, 0x000fea000383ffffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e0004ULL, 0x00000002000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff127424ULL, 0x000fe200078e00ffULL, 0xffffffff00137802ULL, 0x000fce0000000f00ULL,
0x0000000013087348ULL, 0x000fea0003c00000ULL, 0x0c00000f10257389ULL, 0x0006e40000000012ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000800107202ULL, 0x002fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001f00127802ULL, 0x000fe20000000f00ULL, 0xffffffffff137424ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fce00078e0025ULL, 0x0000000013087348ULL, 0x000fea0003c00000ULL,
0x0c00000f10257389ULL, 0x0002640000000012ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x00000005040a7209ULL, 0x000fe20007810000ULL, 0x000000ffff107224ULL, 0x000fe200078e0006ULL,
0x00000025000b7202ULL, 0x000fce0000000f00ULL, 0x0000000013087348ULL, 0x000fea0003c00000ULL,
0x0c00000f10257389ULL, 0x0002640000000012ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000000b080b7209ULL, 0x000fe20007810000ULL, 0x000000ffff107224ULL, 0x000fe200078e0007ULL,
0x00000025000d7202ULL, 0x000fce0000000f00ULL, 0x0000000013087348ULL, 0x000fea0003c00000ULL,
0x0c00000f10257389ULL, 0x0002640000000012ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000000d060d7209ULL, 0x000fe20007810000ULL, 0x000000ffff107224ULL, 0x000fe200078e000aULL,
0x00000001000f7802ULL, 0x000fe40000000f00ULL, 0x0000002500207202ULL, 0x000fce0000000f00ULL,
0x0000000013087348ULL, 0x000fea0003c00000ULL, 0x0c00000f10257389ULL, 0x0002640000000012ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002007207209ULL, 0x000fe40007810000ULL,
0x0000000b00107202ULL, 0x000fe20000000f00ULL, 0x000000ffff057224ULL, 0x000fce00078e0025ULL,
0x0000000013087348ULL, 0x000fea0003c00000ULL, 0x0c00000f10257389ULL, 0x0002640000000012ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000050a047209ULL, 0x000fe40007810000ULL,
0x0000000d00107202ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fce00078e0025ULL,
0x0000000013087348ULL, 0x000fea0003c00000ULL, 0x0c00000f10257389ULL, 0x0002640000000012ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000000c0b057209ULL, 0x000fe40007810000ULL,
0x0000002000107202ULL, 0x000fe20000000f00ULL, 0x000000ffff0e7224ULL, 0x000fce00078e0025ULL,
0x0000000013087348ULL, 0x000fea0003c00000ULL, 0x0c00000f10257389ULL, 0x0002640000000012ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000000e0d067209ULL, 0x000fe20007810000ULL,
0xfffffff000207947ULL, 0x000fec000383ffffULL, 0x0000007000007945ULL, 0x000fe20003800000ULL,
0x000000ff00187202ULL, 0x000fe20000000f00ULL, 0x00001c1fff1b7424ULL, 0x000fe200078e00ffULL,
0x0000001900137202ULL, 0x000fce0000000f00ULL, 0x0000000013087348ULL, 0x000fea0003c00000ULL,
0x000000181a137389ULL, 0x0006e4000000001bULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0x000000ffff117224ULL, 0x004fe200078e0013ULL, 0x00000012001a7202ULL, 0x002fe20000000f00ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x00001c1f001b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fce00078e0019ULL, 0x0000000013087348ULL, 0x000fea0003c00000ULL,
0x000000181a137389ULL, 0x0006e4000000001bULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0x0000001300127202ULL, 0x004fe20000000f00ULL, 0x000000ffff1a7224ULL, 0x002fe200078e0000ULL,
0x000000ff00187202ULL, 0x000fe20000000f00ULL, 0x00001c1fff1b7424ULL, 0x000fe200078e00ffULL,
0x0000001900137202ULL, 0x000fce0000000f00ULL, 0x0000000013087348ULL, 0x000fea0003c00000ULL,
0x000000181a137389ULL, 0x0006e4000000001bULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff400487947ULL, 0x006fea000383ffffULL,
0x0180000002047810ULL, 0x000fe20007ffe0ffULL, 0x0000016000007945ULL, 0x000fe60003800000ULL,
0x7f80000004057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000000200048308ULL, 0x0002a20000001000ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x008000000500780cULL, 0x040fe40003f22070ULL, 0x000000ff0500720cULL, 0x000fe40003f05070ULL,
0xffffffffff047807ULL, 0x004fe40004800000ULL, 0x00000001ff057807ULL, 0x000fc60000000000ULL,
0x000000ffff047224ULL, 0x000fca00078e0a04ULL, 0x0000000405ff7212ULL, 0x000fda000780fcffULL,
0x0000000000248947ULL, 0x000fea0003800000ULL, 0x007fffff02047812ULL, 0x000fc800078ec0ffULL,
0x000000ff0400720cULL, 0x000fc80003f02070ULL, 0xffffffffff047807ULL, 0x000fc80004000000ULL,
0x000000ff04047210ULL, 0x000fc80007ffe1ffULL, 0x0000000405ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000002057812ULL, 0x000fd600078ec0ffULL, 0x0080000005040812ULL, 0x000fe200078efcffULL,
0x000000ffff048224ULL, 0x000fe200078e0005ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000200047308ULL, 0x0004e40000001000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000400067202ULL, 0x00cfe20000000f00ULL, 0x000000ffff047224ULL, 0x000fe200078e0007ULL,
0x0000000000057802ULL, 0x000fc80000000f00ULL, 0xffffff1004587950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL, 0x0000000e00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000f8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000630ULL, 0x0000000000000048ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000678ULL, 0x00000000000004d4ULL, 0x0000000d00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000b4cULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000b70ULL, 0x0000000000000000ULL, 0x0000000d00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000b70ULL, 0x0000000000000030ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ba0ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000be8ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000bf0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000c00ULL, 0x000000000000ef80ULL, 0x0000000e00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000000fb80ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x000000000000fb90ULL, 0x0000000000000400ULL, 0x0000000d00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000000fb90ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x000000000000fb90ULL, 0x0000000000000260ULL, 0x0000000d00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000010270ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000010270ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000000be8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000000c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000ef80ULL,
0x000000000000ef80ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000000fb80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL, 0x0000000000000414ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x000000000000fb90ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000260ULL, 0x0000000000000260ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_8_m_8_sm_90_cubin_len = 66496;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
