/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000013490ULL, 0x0000000000013010ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000011a50ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000011bc0ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000011c00ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000011c40ULL,
0x0000000000000140ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000011d80ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00011a5000000000ULL, 0x0000040400000000ULL, 0x810c000001180400ULL,
0x0045700400288080ULL, 0x0000000000000000ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8708288080860828ULL, 0x2880808c08288080ULL, 0x809d082880809408ULL, 0x08288080a2082880ULL,
0x8080a508288080a4ULL, 0xab08288080aa0828ULL, 0x288080b008288080ULL, 0x80b408288080b108ULL,
0x1628808084082880ULL, 0x0000031028808280ULL, 0x8492000000000000ULL, 0x0000002200288080ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x00011a5000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8608288080840828ULL,
0x2880808708288080ULL, 0x8094082880808c08ULL, 0x0828808095082880ULL, 0x8080a2082880809dULL,
0xa508288080a40828ULL, 0x288080ab08288080ULL, 0x80b408288080b008ULL, 0x16288080aa082880ULL,
0x0000031028808280ULL, 0xaa92000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x0000012800000000ULL, 0x00011bc000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8608288080840828ULL, 0x2880808708288080ULL,
0x809d082880808c08ULL, 0x08288080a2082880ULL, 0x8080a508288080a4ULL, 0xab08288080aa0828ULL,
0x288080b008288080ULL, 0x809408288080b408ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080949200ULL, 0x0000001cffffffffULL, 0x000001e000000000ULL, 0x00011c0000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8608288080840828ULL, 0x2880808708288080ULL, 0x8094082880808c08ULL, 0x082880809c082880ULL,
0x8080a408288080a2ULL, 0xaa08288080a50828ULL, 0x288080ab08288080ULL, 0x80b408288080b008ULL,
0x162880809d082880ULL, 0x0000031028808280ULL, 0x9d92000000000000ULL, 0x0000002200288080ULL,
0x0000002cffffffffULL, 0x0000029000000000ULL, 0x00011c4000000000ULL, 0x0000014000000000ULL,
0x0000140400000000ULL, 0x80942880809d0900ULL, 0x0000000000002880ULL, 0x0000001200082f04ULL,
0x00081204000000a0ULL, 0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005001600000000eULL,
0x000c170400501903ULL, 0x0048000700000000ULL, 0x000c17040021f000ULL, 0x0040000600000000ULL,
0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x000103500000fe40ULL, 0x0001043000010360ULL,
0x0001045000010440ULL, 0xffffffff01702904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x05000016ffffffffULL,
0x0500001605000016ULL, 0xffffffff05000016ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01702804ffffffffULL,
0x00000100000000e0ULL, 0x0000206000001280ULL, 0x000021b0000020f0ULL, 0x000024d0000021e0ULL,
0x00002540000024e0ULL, 0x00002bc0000025a0ULL, 0x00003950000038c0ULL, 0x00003b4000003a20ULL,
0x00003d4000003d30ULL, 0x00003e0000003da0ULL, 0x00004e30000041d0ULL, 0x00004f9000004ec0ULL,
0x000052a0000050b0ULL, 0x00005310000052b0ULL, 0x0000574000005370ULL, 0x00006440000063b0ULL,
0x0000663000006510ULL, 0x0000683000006820ULL, 0x000068f000006890ULL, 0x00006df000006de0ULL,
0x000097c000009500ULL, 0x00009de000009db0ULL, 0x0000fd200000fcf0ULL, 0x0000fd400000fd30ULL,
0x0000fd800000fd60ULL, 0x0000fdb00000fda0ULL, 0x0001048000010420ULL, 0x000104a000010490ULL,
0x00010c2000010bc0ULL, 0x00010d0000010c90ULL, 0x00010de000010d70ULL, 0x00010ea000010e40ULL,
0x00010f7000010f00ULL, 0x0001103000010fd0ULL, 0x000110f000011090ULL, 0x000111c000011150ULL,
0x0001128000011220ULL, 0x00011340000112e0ULL, 0x00011410000113a0ULL, 0x000114d000011470ULL,
0x000115d000011550ULL, 0x000116b000011640ULL, 0x0001179000011720ULL, 0x0001187000011800ULL,
0x00011970000118f0ULL, 0x00011a30000119d0ULL, 0x0000020002003904ULL, 0x0001b600000000ffULL,
0x00000240003f0100ULL, 0x0001b60800000005ULL, 0x00000310003f0120ULL, 0x0001b68800000005ULL,
0x000003f0003f0120ULL, 0x0001b600000000ffULL, 0x00000510003f0107ULL, 0x0001b68c00000061ULL,
0x000005a0003f0102ULL, 0x0001b68800000061ULL, 0x00001e90003f0101ULL, 0x0001b60800000005ULL,
0x00001ea0003f0101ULL, 0x0001b60c00000005ULL, 0x00001f60003f0105ULL, 0x0001b60c00000007ULL,
0x00002b70003f0105ULL, 0x0001b6880000006aULL, 0x00003730003f0101ULL, 0x0001b62800000005ULL,
0x00003740003f0101ULL, 0x0001b62c00000005ULL, 0x00003810003f0105ULL, 0x0001b62c0000001cULL,
0x00004180003f0105ULL, 0x0001b6900000006aULL, 0x00004ce0003f0101ULL, 0x0001b64800000005ULL,
0x00004cf0003f0101ULL, 0x0001b64c00000005ULL, 0x00004d80003f0105ULL, 0x0001b64c00000005ULL,
0x000056f0003f0105ULL, 0x0001b6980000006aULL, 0x00006260003f0101ULL, 0x0001b66800000005ULL,
0x00006270003f0101ULL, 0x0001b66c00000005ULL, 0x00006300003f0105ULL, 0x0001b66c00000005ULL,
0x00006c30003f0105ULL, 0x0001b6a00000006aULL, 0x0000aac0003f0101ULL, 0x0001b600000000ffULL,
0x0000c0d0003f0101ULL, 0x0001b604000000ffULL, 0x0000c170003f0105ULL, 0x0001b604000000ffULL,
0x0000f310003f0105ULL, 0x000000000000007aULL, 0x0000f340003f0101ULL, 0x000000040000007aULL,
0x0000f610003f0105ULL, 0x000000040000007aULL, 0x00010a10003f0105ULL, 0x0001b60800000072ULL,
0x00010a70003f0101ULL, 0x0001b61000000072ULL, 0x00010ad0003f0101ULL, 0x0001b61800000072ULL,
0x00010b40003f0101ULL, 0x0001b62000000072ULL, 0x00033803003f0101ULL, 0x0000a7e000141c04ULL,
0x0000c1d00000aa30ULL, 0x00010b800000c250ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL,
0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x0000000000000334ULL, 0x0000001200000002ULL, 0x000000000000027cULL, 0x0000001200000002ULL,
0x00000000000001ccULL, 0x0000001200000002ULL, 0x0000000000000114ULL, 0x0000001200000002ULL,
0x0000000000000044ULL, 0x0000001200000002ULL, 0x000000000000030eULL, 0x0000001200000002ULL,
0x0000000000000259ULL, 0x0000001200000002ULL, 0x00000000000001a6ULL, 0x0000001200000002ULL,
0x00000000000000eeULL, 0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000057919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x00005800ff077624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000c7919ULL, 0x000ea20000002300ULL,
0x0000001300067300ULL, 0x000ee200000e0000ULL, 0x0000000807077824ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000ea80000002200ULL, 0x0000000000097919ULL, 0x000ee20000000000ULL,
0x0000001300137309ULL, 0x000f260000000000ULL, 0x0000000000107919ULL, 0x000f680000002600ULL,
0x0000000000607919ULL, 0x000f220000002700ULL, 0x00000005ff657819ULL, 0x002fcc0000011605ULL,
0x00001fff65657589ULL, 0x000fe200000e0000ULL, 0x000000010c007824ULL, 0x004fc600078e0203ULL,
0x00001fff0c0c7589ULL, 0x000e6200000e0000ULL, 0x0000008000057824ULL, 0x000fe200078e0205ULL,
0x000000090600720cULL, 0x008fe40003f82070ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000000310047819ULL, 0x020fe400000006ffULL, 0x000000ff0500720cULL, 0x040fe40003f05270ULL,
0x0000000f0500780cULL, 0x000fe20003f24070ULL, 0x0000006007077224ULL, 0x010fe200078e0204ULL,
0x0000007f0500780cULL, 0x000fe20003f44070ULL, 0x00000100ff047424ULL, 0x000fd000078e00ffULL,
0x3fffff80ff028424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff038424ULL, 0x000fe200078e00ffULL,
0x3fffffc000089802ULL, 0x000fe20000000f00ULL, 0x000000040c067824ULL, 0x002fe200078e0265ULL,
0xff3172170012a802ULL, 0x000fe20000000f00ULL, 0x7fffffc0ff099424ULL, 0x000fe200078e00ffULL,
0x01b60002ff008388ULL, 0x0003e20000000a00ULL, 0x000000030500780cULL, 0x000fe20003f04070ULL,
0x0000000206067824ULL, 0x000fe200078e00ffULL, 0x00000004ff0d7819ULL, 0x004fe20000011600ULL,
0x01b6080805009388ULL, 0x0005e20000008a00ULL, 0x00000010000f7824ULL, 0x000fc400078e00ffULL,
0x00000008060b7817ULL, 0x040fe20007800000ULL, 0x00000001060e7824ULL, 0x000fe200078e020dULL,
0x01b400120500a388ULL, 0x0007e20000004800ULL, 0x000000f00f117812ULL, 0x000fe400078ec0ffULL,
0x000000010b067824ULL, 0x000fe400078e0a06ULL, 0x3fffff60ff0a8424ULL, 0x000fe400078e00ffULL,
0x7fffff60ff0b8424ULL, 0x000fe200078e00ffULL, 0x000000060d00720cULL, 0x000fe20003f26070ULL,
0x0000000107037824ULL, 0x002fe200078e020eULL, 0x000000070e077812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x004fe200078e0a13ULL, 0x01b6880a05008388ULL, 0x0007e20000008a00ULL,
0x00005c0003027625ULL, 0x000fe200078e0004ULL, 0x0000000f07077812ULL, 0x000fc400078e7800ULL,
0x0000000000007b1dULL, 0x000fe40000010000ULL, 0x0000001102067210ULL, 0x000fe20007f7e0ffULL,
0x000000100e0e7824ULL, 0x000fc800078e0207ULL, 0x000000ffff077224ULL, 0x000fe200018e0603ULL,
0x000000040e097819ULL, 0x000fe200000006ffULL, 0x00000004ff037424ULL, 0x000fc800078e00ffULL,
0x0000600060027625ULL, 0x000fe200078e0003ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0007e8000c901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x01b60408ffff438cULL, 0x0007e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000602647981ULL, 0x000ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000e620000002500ULL, 0x000000ff0c00720cULL, 0x000fe20003f05270ULL,
0x00000004ff667e24ULL, 0x002fe2000f8e00ffULL, 0x000000ff64637810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff637819ULL, 0x000fce0000011663ULL, 0x0000a56000008947ULL, 0x000fea0003800000ULL,
0x0000000865617824ULL, 0x000fe400078e00ffULL, 0x00000003ff027424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b68c0261ff738cULL, 0x0003e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000166027810ULL, 0x002fe20007ffe0ffULL,
0x0000000260607824ULL, 0x000fe200078e00ffULL, 0x00000001ff577819ULL, 0x000fe20000011665ULL,
0x01b6880061ff7f8cULL, 0x0003e2000c80043fULL, 0x000000630200720cULL, 0x000fe40003f06070ULL,
0x0000580010037a10ULL, 0x000fc40007ffe0ffULL, 0x0000000557567819ULL, 0x000fe400000006ffULL,
0x0000000165627812ULL, 0x000fe200078ec0ffULL, 0x0000580060607a24ULL, 0x000fe400078e0203ULL,
0x0000010066057824ULL, 0x008fc800078e0256ULL, 0x0000620060217a24ULL, 0x000fe200078e0205ULL,
0x000005a000008947ULL, 0x000fea0003800000ULL, 0x0000000564027217ULL, 0x002fe20007800000ULL,
0x0000000257107824ULL, 0x000fe200078e0262ULL, 0x00000003ff067819ULL, 0x000fe20000011600ULL,
0x0000000862117824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fe200078e0a05ULL,
0x00000008060a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000121037824ULL, 0x000fe200078e0206ULL,
0x0000000c060c7810ULL, 0x000fe40007ffe0ffULL, 0x0000002002057817ULL, 0x000fe20003800000ULL,
0x00005e0003027625ULL, 0x000fe200078e0004ULL, 0x0000000706077812ULL, 0x000fc400078e4800ULL,
0x000000050600720cULL, 0x000fe20003f06070ULL, 0x000000080a127824ULL, 0x000fe200078e00ffULL,
0x0000000406087810ULL, 0x000fe20007ffe0ffULL, 0x000000080c147824ULL, 0x000fe200078e00ffULL,
0x0001300010107811ULL, 0x000fe400078e68ffULL, 0xfffffff811117812ULL, 0x100fe400078ee200ULL,
0x0ffffff807077812ULL, 0x000fe400078ef800ULL, 0x000000000a0b7212ULL, 0x080fe200078e3cffULL,
0x0000001011027825ULL, 0x000fe200078e0002ULL, 0x000000000c0d7212ULL, 0x000fc400078e3cffULL,
0x0000000008097212ULL, 0x0c0fe200078e3cffULL, 0x0000001007077824ULL, 0x100fe200078e0210ULL,
0x00000003080e7819ULL, 0x000fe400000006ffULL, 0xfffffff812157812ULL, 0x000fe400078ee20bULL,
0xfffffff814177812ULL, 0x000fe200078ee20dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002077faeULL, 0x0003e2000c101c46ULL, 0x00000010060b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001015157824ULL, 0x100fe200078e0210ULL, 0xfffffff80e137812ULL, 0x000fe200078ee209ULL,
0x0000001017177824ULL, 0x100fe200078e0210ULL, 0x00000014060d7810ULL, 0x040fe20007ffe0ffULL,
0x000000080b197824ULL, 0x000fe200078e00ffULL, 0x00000018060e7810ULL, 0x040fe20007ffe0ffULL,
0x0000001013137824ULL, 0x000fe200078e0210ULL, 0x0000001c06127810ULL, 0x000fe20007ffe0ffULL,
0x000000080d1b7824ULL, 0x000fe200078e00ffULL, 0x000000050800720cULL, 0x080fe20003f06070ULL,
0x0000000121037824ULL, 0x002fe200078e0208ULL, 0x000000000b027212ULL, 0x080fe200078e3cffULL,
0x000000080e1f7824ULL, 0x000fe200078e00ffULL, 0x000000000d067212ULL, 0x000fe200078e3cffULL,
0x0000000121077824ULL, 0x040fe200078e020aULL, 0x000000050a00720cULL, 0x080fe20003f26070ULL,
0x0000000812237824ULL, 0x000fe200078e00ffULL, 0x0000000c21097210ULL, 0x040fe20007ffe0ffULL,
0x00000001210f7824ULL, 0x040fe200078e020dULL, 0x000000000e087212ULL, 0x000fe200078e3cffULL,
0x00000001211d7824ULL, 0x000fe200078e020eULL, 0x000000050c00720cULL, 0x000fc40003f46070ULL,
0x000000050b00720cULL, 0x080fe40003f66070ULL, 0x000000050d00720cULL, 0x080fe20003f86070ULL,
0x00005e000f0c7625ULL, 0x000fe200078e0004ULL, 0x000000050e00720cULL, 0x080fe40003fa6070ULL,
0x000000051200720cULL, 0x040fe20003fc6070ULL, 0x0000000121057824ULL, 0x000fe200078e020bULL,
0x00000000120a7212ULL, 0x000fe200078e3cffULL, 0x00005e001d0e7625ULL, 0x000fe200078e0004ULL,
0xfffffff819197812ULL, 0x000fc400078ee202ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee206ULL,
0x00005e0003027625ULL, 0x000fe200078e0004ULL, 0x0000001221217210ULL, 0x000fe40007ffe0ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee208ULL, 0x00005e0007067625ULL, 0x000fe200078e0004ULL,
0xfffffff823237812ULL, 0x000fe400078ee20aULL, 0x0000001019197211ULL, 0x000fe200078e20ffULL,
0x00005e0009087625ULL, 0x000fc800078e0004ULL, 0x00005e00050a7625ULL, 0x000fc800078e0004ULL,
0x00005e0021047625ULL, 0x000fc800078e0004ULL, 0x0000001011027825ULL, 0x000fc800078e0002ULL,
0x0000001011067825ULL, 0x040fe200078e0006ULL, 0x0000000002137faeULL, 0x0003e6000c101c46ULL,
0x0000001011087825ULL, 0x040fe200078e0008ULL, 0x0000000006157faeULL, 0x0003e6000c901c46ULL,
0x00000010110a7825ULL, 0x040fe200078e000aULL, 0x0000000008177faeULL, 0x0003e6000d101c46ULL,
0x00000010110c7825ULL, 0x000fe200078e000cULL, 0x000000000a197faeULL, 0x0003e6000d901c46ULL,
0x000000101b1b7824ULL, 0x000fc400078e0210ULL, 0x00000010110e7825ULL, 0x000fc600078e000eULL,
0x000000000c1b7faeULL, 0x0003e2000e101c46ULL, 0x000000101f1f7824ULL, 0x000fe400078e0210ULL,
0x0000001011047825ULL, 0x000fc600078e0004ULL, 0x000000000e1f7faeULL, 0x0003e2000e901c46ULL,
0x0000001023237824ULL, 0x000fca00078e0210ULL, 0x0000000004237faeULL, 0x0003e2000f101c46ULL,
0x000004e000007947ULL, 0x000fea0003800000ULL, 0x00000003ff027819ULL, 0x002fe20000011600ULL,
0x0000000862137824ULL, 0x000fc600078e00ffULL, 0x0000000402067810ULL, 0x040fe40007ffe0ffULL,
0x0000000802087810ULL, 0x000fe40007ffe0ffULL, 0x0000000006037212ULL, 0x0c0fe200078e3cffULL,
0x00000008060c7824ULL, 0x000fe200078e00ffULL, 0x0000000c020a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000121097824ULL, 0x000fe200078e0208ULL, 0x0000000008057212ULL, 0x080fe400078e3cffULL,
0xfffffff80c177812ULL, 0x000fe200078ee203ULL, 0x00000008080c7824ULL, 0x000fe200078e00ffULL,
0x000000000a077212ULL, 0x040fe200078e3cffULL, 0x0000000257037824ULL, 0x000fe200078e0262ULL,
0x000000030a0e7819ULL, 0x000fc400000006ffULL, 0xfffffff80c197812ULL, 0x000fe400078ee205ULL,
0xfffffff80e1b7812ULL, 0x000fe200078ee207ULL, 0x0000000121077824ULL, 0x040fe200078e0206ULL,
0x00000010020c7810ULL, 0x040fe40007ffe0ffULL, 0x00000014020e7810ULL, 0x040fe40007ffe0ffULL,
0x0000001802107810ULL, 0x000fe20007ffe0ffULL, 0x000000080c1d7824ULL, 0x000fe200078e00ffULL,
0x0000001c02147810ULL, 0x000fe20007ffe0ffULL, 0x00000001210d7824ULL, 0x000fe200078e020cULL,
0x0001300003127811ULL, 0x000fe200078e68ffULL, 0x0000000121037824ULL, 0x040fe200078e0202ULL,
0x0000000a210b7210ULL, 0x040fe20007ffe0ffULL, 0x00000001210f7824ULL, 0x040fe200078e020eULL,
0x000000000c067212ULL, 0x000fe200078e3cffULL, 0x000000080e1f7824ULL, 0x000fe200078e00ffULL,
0x0000001421237210ULL, 0x040fe20007ffe0ffULL, 0x0000000121117824ULL, 0x000fe200078e0210ULL,
0x0000000702057812ULL, 0x000fe200078e4800ULL, 0x0000000810217824ULL, 0x000fe200078e00ffULL,
0x000000000e087212ULL, 0x080fe200078e3cffULL, 0x0000000814257824ULL, 0x000fe200078e00ffULL,
0x00000000100a7212ULL, 0x000fe200078e3cffULL, 0x00005e0003027625ULL, 0x000fe200078e0004ULL,
0x00000000140c7212ULL, 0x000fc400078e3cffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL,
0x00005e0007067625ULL, 0x080fe200078e0004ULL, 0xfffffff813137812ULL, 0x100fe400078ee200ULL,
0x0ffffff805057812ULL, 0x000fe200078ef800ULL, 0x00005e000f0e7625ULL, 0x080fe200078e0004ULL,
0xfffffff81f1f7812ULL, 0x000fe400078ee208ULL, 0xfffffff821217812ULL, 0x000fe200078ee20aULL,
0x00005e0009087625ULL, 0x000fe200078e0004ULL, 0xfffffff825257812ULL, 0x000fc400078ee20cULL,
0x000000121b1b7211ULL, 0x000fe200078e20ffULL, 0x00005e000b0a7625ULL, 0x000fc800078e0004ULL,
0x00005e000d0c7625ULL, 0x000fc800078e0004ULL, 0x0000001005157824ULL, 0x000fe400078e0212ULL,
0x0000001013027825ULL, 0x000fc800078e0002ULL, 0x00005e0011107625ULL, 0x080fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002157faeULL, 0x0003e6000b901c46ULL,
0x00005e0023047625ULL, 0x000fc800078e0004ULL, 0x0000001013067825ULL, 0x000fc800078e0006ULL,
0x0000001017177824ULL, 0x000fe400078e0212ULL, 0x0000001013087825ULL, 0x000fc600078e0008ULL,
0x0000000006177faeULL, 0x0003e2000b901c46ULL, 0x0000001019197824ULL, 0x000fe400078e0212ULL,
0x00000010130a7825ULL, 0x000fc600078e000aULL, 0x0000000008197faeULL, 0x0003e2000b901c46ULL,
0x00000010130c7825ULL, 0x000fc600078e000cULL, 0x000000000a1b7faeULL, 0x0003e2000b901c46ULL,
0x000000101d1d7824ULL, 0x000fe400078e0212ULL, 0x00000010130e7825ULL, 0x000fc600078e000eULL,
0x000000000c1d7faeULL, 0x0003e2000b901c46ULL, 0x000000101f1f7824ULL, 0x000fe400078e0212ULL,
0x0000001013107825ULL, 0x000fc600078e0010ULL, 0x000000000e1f7faeULL, 0x0003e2000b901c46ULL,
0x0000001021217824ULL, 0x000fe400078e0212ULL, 0x0000001013047825ULL, 0x000fc600078e0004ULL,
0x0000000010217faeULL, 0x0003e2000b901c46ULL, 0x0000001025257824ULL, 0x000fca00078e0212ULL,
0x0000000004257faeULL, 0x0003e4000b901c46ULL, 0x000000636600720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff557424ULL, 0x000fe200078e00ffULL,
0x000000ff00547202ULL, 0x000fe20000000f00ULL, 0x00000000001a7805ULL, 0x002fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00005a9000000947ULL, 0x000fea0003800000ULL,
0xff317217ff557424ULL, 0x000fe400078e00ffULL, 0x000000ffff6c7224ULL, 0x000fc400078e00ffULL,
0x000000ffff1b7224ULL, 0x000fe400078e00ffULL, 0x0000010066037824ULL, 0x000fca00078e00ffULL,
0x000000640300720cULL, 0x000fda0003f06070ULL, 0x000059f000000947ULL, 0x000fea0003800000ULL,
0x0000000166027810ULL, 0x040fe20007ffe0ffULL, 0x0000010066697824ULL, 0x000fe200078e0256ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000630200720cULL, 0x000fe40003f06070ULL,
0x0000004069057810ULL, 0x000fe40007ffe0ffULL, 0x0000006c00047202ULL, 0x000fc60000000f00ULL,
0x0000620060127a24ULL, 0x000fcc00078e0205ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000000564027217ULL, 0x000fe20007800000ULL, 0x000010006c037824ULL, 0x000fe200078e00ffULL,
0x00000003ff0b7819ULL, 0x000fe20000011600ULL, 0x0000000257067824ULL, 0x000fe200078e0262ULL,
0x0000010000137802ULL, 0x000fe20000000f00ULL, 0x0000000102027824ULL, 0x000fe200078e0a05ULL,
0x0000100003037812ULL, 0x000fe200078e0cffULL, 0x0000000862157824ULL, 0x000fe200078e00ffULL,
0x000000070b077812ULL, 0x100fe400078e4800ULL, 0x0000002002057817ULL, 0x000fe20003800000ULL,
0x0000200006067824ULL, 0x000fe200078e0003ULL, 0xfffffff815157812ULL, 0x000fe200078ee200ULL,
0x000000010b037824ULL, 0x040fe200078e0212ULL, 0x000000050b00720cULL, 0x000fc40003f06070ULL,
0x0ffffff807077812ULL, 0x000fe200078ef800ULL, 0x00005e0003027625ULL, 0x000fe200078e0013ULL,
0x0001300006087810ULL, 0x000fe40007ffe0ffULL, 0x000000040b0d7810ULL, 0x040fe40007ffe0ffULL,
0x000000080b0f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001015027825ULL, 0x000fe200078e0002ULL,
0x0000000c0b117810ULL, 0x040fe40007ffe0ffULL, 0x000000100b217810ULL, 0x000fe20007ffe0ffULL,
0x0000001007077824ULL, 0x000fe200078e0208ULL, 0x000000140b237810ULL, 0x000fe20007ffe0ffULL,
0x000000080d177824ULL, 0x000fe200078e00ffULL, 0x000000180b257810ULL, 0x000fe20007ffe0ffULL,
0x000000080f1d7824ULL, 0x000fe200078e00ffULL, 0x0000001c0b0b7810ULL, 0x000fe20007ffe0ffULL,
0x00000008111f7824ULL, 0x000fe200078e00ffULL, 0x000000000d0a7212ULL, 0x080fe200078e3cffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e2000c101c46ULL,
0x000000000f0c7212ULL, 0x080fe200078e3cffULL, 0x0000000821147824ULL, 0x000fe200078e00ffULL,
0x0000000011067212ULL, 0x000fe200078e3cffULL, 0x00000008251c7824ULL, 0x000fe200078e00ffULL,
0x000000050d00720cULL, 0x000fe20003f06070ULL, 0x000000080b1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee20aULL, 0x00000001110a7824ULL, 0x000fe200078e0212ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee20cULL, 0x00000001210c7824ULL, 0x000fe200078e0212ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee206ULL, 0x000000010f067824ULL, 0x100fe200078e0212ULL,
0x000000120d027210ULL, 0x002fe20007ffe0ffULL, 0x00000001230e7824ULL, 0x100fe200078e0212ULL,
0x0000000021037212ULL, 0x080fe200078e3cffULL, 0x0000000125107824ULL, 0x140fe200078e0212ULL,
0x0000000025077212ULL, 0x080fe200078e3cffULL, 0x000000010b127824ULL, 0x040fe200078e0212ULL,
0x000000000b0d7212ULL, 0x000fc400078e3cffULL, 0x000000052100720cULL, 0x080fe40003f66070ULL,
0x000000052500720cULL, 0x080fe40003fa6070ULL, 0x000000050f00720cULL, 0x000fe20003f26070ULL,
0x00005e000e0e7625ULL, 0x000fe200078e0013ULL, 0x000000051100720cULL, 0x080fe40003f46070ULL,
0x000000050b00720cULL, 0x000fe20003fc6070ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0013ULL,
0xfffffff814217812ULL, 0x000fc400078ee203ULL, 0xfffffff81c257812ULL, 0x000fe200078ee207ULL,
0x00005e0002027625ULL, 0x000fe200078e0013ULL, 0xfffffff81e277812ULL, 0x000fe400078ee20dULL,
0x000000052300720cULL, 0x040fe20003f86070ULL, 0x00005e0006067625ULL, 0x080fe200078e0013ULL,
0x0000000023057212ULL, 0x040fe400078e3cffULL, 0x0000000323167819ULL, 0x000fe200000006ffULL,
0x00005e000c0c7625ULL, 0x000fc600078e0013ULL, 0xfffffff816237812ULL, 0x000fe200078ee205ULL,
0x00005e0010107625ULL, 0x000fc800078e0013ULL, 0x00005e0012127625ULL, 0x000fc800078e0013ULL,
0x0000001015027825ULL, 0x000fc800078e0002ULL, 0x0000001015067825ULL, 0x000fc800078e0006ULL,
0x00000010150a7825ULL, 0x000fc800078e000aULL, 0x00000010150c7825ULL, 0x000fc800078e000cULL,
0x00000010150e7825ULL, 0x000fc800078e000eULL, 0x0000001015107825ULL, 0x000fc800078e0010ULL,
0x0000001015127825ULL, 0x000fe200078e0012ULL, 0x000000081d157211ULL, 0x000fc600078e20ffULL,
0x0000001017057824ULL, 0x100fe400078e0208ULL, 0x000000101f177824ULL, 0x100fe400078e0208ULL,
0x00000010211d7824ULL, 0x100fe200078e0208ULL, 0x0000000002057faeULL, 0x0003e2000c101c46ULL,
0x00000010231f7824ULL, 0x100fe400078e0208ULL, 0x0000001025217824ULL, 0x100fe200078e0208ULL,
0x0000000006157faeULL, 0x0003e2000c901c46ULL, 0x0000001027237824ULL, 0x000fc600078e0208ULL,
0x000000000a177faeULL, 0x0003e8000d101c46ULL, 0x000000000c1d7faeULL, 0x0003e8000d901c46ULL,
0x000000000e1f7faeULL, 0x0003e8000e101c46ULL, 0x0000000010217faeULL, 0x0003e8000e901c46ULL,
0x0000000012237faeULL, 0x0003e2000f101c46ULL, 0x0000052000007947ULL, 0x000fea0003800000ULL,
0x0000000c6c057819ULL, 0x000fe200000006ffULL, 0x0000000257027824ULL, 0x000fe200078e0262ULL,
0x00000003ff037819ULL, 0x000fc40000011600ULL, 0x0000100005057812ULL, 0x000fe400078e0cffULL,
0x00000004030b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c030d7810ULL, 0x040fe20007ffe0ffULL,
0x0000200002067824ULL, 0x000fe200078e0005ULL, 0x0000000803057810ULL, 0x000fe20007ffe0ffULL,
0x000000080b167824ULL, 0x040fe200078e00ffULL, 0x000000000b077212ULL, 0x080fe200078e3cffULL,
0x000000080d1e7824ULL, 0x000fe200078e00ffULL, 0x0000001403117810ULL, 0x000fe20007ffe0ffULL,
0x0000000805137824ULL, 0x000fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee207ULL,
0x000000010d0e7824ULL, 0x100fe200078e0212ULL, 0x0000000005027212ULL, 0x080fe200078e3cffULL,
0x0000000811177824ULL, 0x000fe200078e00ffULL, 0x00000010030f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111147824ULL, 0x000fe200078e0212ULL, 0x000000000d077212ULL, 0x000fc400078e3cffULL,
0xfffffff8131c7812ULL, 0x000fe200078ee202ULL, 0x0000000103027824ULL, 0x100fe200078e0212ULL,
0x000000000f087212ULL, 0x0c0fe200078e3cffULL, 0x000000010f107824ULL, 0x040fe200078e0212ULL,
0x000000030f157819ULL, 0x000fe400000006ffULL, 0x00000000110a7212ULL, 0x000fe400078e3cffULL,
0xfffffff81e1e7812ULL, 0x000fe400078ee207ULL, 0x0000001803137810ULL, 0x000fc40007ffe0ffULL,
0x0000000703077812ULL, 0x040fe400078e4800ULL, 0x0000001c03037810ULL, 0x000fe20007ffe0ffULL,
0x0000000113247824ULL, 0x000fe200078e0212ULL, 0xfffffff815207812ULL, 0x000fe200078ee208ULL,
0x00000100ff157424ULL, 0x000fe200078e00ffULL, 0xfffffff817227812ULL, 0x000fe200078ee20aULL,
0x0000000862177824ULL, 0x000fe200078e00ffULL, 0x0000000013087212ULL, 0x000fe200078e3cffULL,
0x000000010b0a7824ULL, 0x100fe200078e0212ULL, 0x0000000313137819ULL, 0x000fe200000006ffULL,
0x00000008032a7824ULL, 0x000fe200078e00ffULL, 0x00000012050c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000103287824ULL, 0x040fe200078e0212ULL, 0x00000000030b7212ULL, 0x000fe200078e3cffULL,
0x00005e0002027625ULL, 0x000fe200078e0015ULL, 0xfffffff817057812ULL, 0x000fc400078ee200ULL,
0xfffffff813267812ULL, 0x000fe200078ee208ULL, 0x00005e0024127625ULL, 0x080fe200078e0015ULL,
0x0ffffff807087812ULL, 0x000fe400078ef800ULL, 0x0001300006177810ULL, 0x000fe20007ffe0ffULL,
0x00005e000a067625ULL, 0x000fe200078e0015ULL, 0xfffffff82a2a7812ULL, 0x000fe400078ee20bULL,
0x0000001720237211ULL, 0x000fe200078e20ffULL, 0x00005e000c0a7625ULL, 0x000fc800078e0015ULL,
0x00005e000e0c7625ULL, 0x000fc800078e0015ULL, 0x00005e00100e7625ULL, 0x000fc800078e0015ULL,
0x00005e0014107625ULL, 0x000fc800078e0015ULL, 0x00005e0028147625ULL, 0x000fc800078e0015ULL,
0x0000001005027825ULL, 0x000fc800078e0002ULL, 0x0000001005067825ULL, 0x000fc800078e0006ULL,
0x00000010050a7825ULL, 0x000fc800078e000aULL, 0x00000010050c7825ULL, 0x000fc800078e000cULL,
0x00000010050e7825ULL, 0x000fc800078e000eULL, 0x0000001005107825ULL, 0x000fc800078e0010ULL,
0x0000001005127825ULL, 0x000fc800078e0012ULL, 0x0000001005147825ULL, 0x000fc800078e0014ULL,
0x0000001008057824ULL, 0x100fe400078e0217ULL, 0x00000010161d7824ULL, 0x100fe400078e0217ULL,
0x000000101c1f7824ULL, 0x100fe200078e0217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000b901c46ULL, 0x000000101e217824ULL, 0x100fe400078e0217ULL,
0x0000001022257824ULL, 0x100fe200078e0217ULL, 0x00000000061d7faeULL, 0x0003e2000b901c46ULL,
0x0000001026277824ULL, 0x000fc400078e0217ULL, 0x000000102a177824ULL, 0x000fe200078e0217ULL,
0x000000000a1f7faeULL, 0x0003e8000b901c46ULL, 0x000000000c217faeULL, 0x0003e8000b901c46ULL,
0x000000000e237faeULL, 0x0003e8000b901c46ULL, 0x0000000010257faeULL, 0x0003e8000b901c46ULL,
0x0000000012277faeULL, 0x0003e8000b901c46ULL, 0x0000000014177faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001057027824ULL, 0x002fe200078e00ffULL,
0xffffffe061067812ULL, 0x000fc800078ec0ffULL, 0x0000001002037812ULL, 0x000fca00078ec0ffULL,
0x0000000106037824ULL, 0x000fca00078e0203ULL, 0x0000000362057211ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6080005027f8cULL, 0x000fe8000c80043fULL,
0x01b60c0005077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000b000000947ULL, 0x000fea0003800000ULL, 0x0000001061077812ULL, 0x040fe200078ec0ffULL,
0x3e000000ff0a7424ULL, 0x000fe200078e00ffULL, 0x0000000861087812ULL, 0x000fc800078ec0ffULL,
0x0000000608077210ULL, 0x000fe40007ffe007ULL, 0x0000000a00067305ULL, 0x0002a4000021f000ULL,
0x3fa000000a0a7823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x01b60c00070b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000001ff087819ULL, 0x000fe20000011600ULL, 0x0000002065077824ULL, 0x000fc600078e00ffULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0xffffff8007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fc800078ec0ffULL, 0x0000000708027210ULL, 0x000fca0007ffe006ULL,
0x01b00000020a7984ULL, 0x000e680000000800ULL, 0x01b2000002037984ULL, 0x0004e20000000800ULL,
0x000000550a00720bULL, 0x002fe20003f1d000ULL, 0x0000eb327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000027806ULL, 0x004fc800000e0100ULL, 0x0000ffff020d7812ULL, 0x000fe2000780c0ffULL,
0x000003e000007945ULL, 0x000fe20003800000ULL, 0x0000000100027802ULL, 0x000fd60000000f00ULL,
0x000003b000008947ULL, 0x000fea0003800000ULL, 0x00000002ff027819ULL, 0x000fe40000011665ULL,
0x000000550a00720bULL, 0x000fe40003f34000ULL, 0x000000650200720cULL, 0x000fe20003f05270ULL,
0x0000eb027f007947ULL, 0x000ff4000b800000ULL, 0x0000000000027806ULL, 0x000fe400008e0100ULL,
0x0000000a550e7209ULL, 0x000fe20007810000ULL, 0x00000080650b8824ULL, 0x000fe200078e0206ULL,
0x0000ffff02027812ULL, 0x000fc600078e3cffULL, 0x8000000e550c7221ULL, 0x000fe40000010000ULL,
0x00000001080b8824ULL, 0x000fe400078e020bULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc60000410000ULL,
0x01b4000e0b008388ULL, 0x0003e20000000800ULL, 0x0000000c00247308ULL, 0x0002a20000000800ULL,
0x000000020dff7212ULL, 0x000fe4000780c0ffULL, 0x00000002ff027819ULL, 0x000fe20000011600ULL,
0x0000eaa27f007947ULL, 0x000ff0000b800000ULL, 0x00001f02240b7589ULL, 0x0062a400000e0000ULL,
0x0000000802027810ULL, 0x002fe20007ffe0ffULL, 0x0000eae27f007947ULL, 0x000fea000b800000ULL,
0x00001f0224027589ULL, 0x00032400000e0000ULL, 0x8000000e0a0a0221ULL, 0x000fe40000010000ULL,
0x000000021b1b7220ULL, 0x010fe40000410000ULL, 0x3fb8aa3b0a0a0820ULL, 0x000fc40000410000ULL,
0x000000021a1a7220ULL, 0x080fe40000410000ULL, 0x0000000a00090308ULL, 0x000f220000000800ULL,
0x0000000237377220ULL, 0x080fe40000410000ULL, 0x0000000236367220ULL, 0x080fe40000410000ULL,
0x000000023b3b7220ULL, 0x080fe40000410000ULL, 0x000000023a3a7220ULL, 0x080fe40000410000ULL,
0x000000023f3f7220ULL, 0x000fc40000410000ULL, 0x000000023e3e7220ULL, 0x080fe40000410000ULL,
0x0000000243437220ULL, 0x080fe40000410000ULL, 0x0000000242427220ULL, 0x080fe40000410000ULL,
0x0000000247477220ULL, 0x080fe40000410000ULL, 0x0000000246467220ULL, 0x080fe40000410000ULL,
0x000000024b4b7220ULL, 0x000fc40000410000ULL, 0x000000024a4a7220ULL, 0x080fe40000410000ULL,
0x000000024f4f7220ULL, 0x080fe40000410000ULL, 0x000000024e4e7220ULL, 0x000fe20000410000ULL,
0x00000001ff027807ULL, 0x000fe20000000000ULL, 0x0000002454547220ULL, 0x000fe40000410000ULL,
0x0000000b19197220ULL, 0x084fe40000410000ULL, 0x0000000b18187220ULL, 0x000fc40000410000ULL,
0x0000000b35357220ULL, 0x080fe40000410000ULL, 0x0000000b34347220ULL, 0x080fe40000410000ULL,
0x0000000b39397220ULL, 0x080fe40000410000ULL, 0x0000000b38387220ULL, 0x080fe40000410000ULL,
0x0000000b3d3d7220ULL, 0x080fe40000410000ULL, 0x0000000b3c3c7220ULL, 0x000fc40000410000ULL,
0x0000000b41417220ULL, 0x080fe40000410000ULL, 0x0000000b40407220ULL, 0x080fe40000410000ULL,
0x0000000b45457220ULL, 0x080fe40000410000ULL, 0x0000000b44447220ULL, 0x080fe40000410000ULL,
0x0000000b49497220ULL, 0x080fe40000410000ULL, 0x0000000b48487220ULL, 0x000fc40000410000ULL,
0x0000000b4d4d7220ULL, 0x080fe40000410000ULL, 0x0000000b4c4c7220ULL, 0x000fe40000410000ULL,
0x000000ffff557224ULL, 0x000fe400078e000eULL, 0x0000000903030220ULL, 0x018fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000009ff0a723eULL, 0x000fe200000000ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff0b7819ULL, 0x000fe40000011600ULL,
0x000054100a247816ULL, 0x002fe2000000000aULL, 0x0000e8727f007947ULL, 0x000fea000b800000ULL,
0x000000080b0a7810ULL, 0x000fe20007ffe0ffULL, 0x00001f0b246b7589ULL, 0x0002a800000e0000ULL,
0x00001f0a24687589ULL, 0x00032400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000100b257810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff267424ULL, 0x000fe200078e00ffULL,
0x0000255000147802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000f6b000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000180b257810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0000001f00267802ULL, 0x000fc40000000f00ULL, 0x000025b000147802ULL, 0x000fe40000000f00ULL,
0x0000f65000007944ULL, 0x01cfea0003c00000ULL, 0x00000004570c7824ULL, 0x000fe200078e00ffULL,
0x00000007000b7812ULL, 0x002fe200078ec0ffULL, 0x00000200650e7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000005403547221ULL, 0x008fe20000010000ULL,
0x000000040c0d7812ULL, 0x000fe400078ec0ffULL, 0x000000080b117812ULL, 0x000fe400078ef800ULL,
0x0000000d000c7211ULL, 0x000fe400078fe0ffULL, 0xfffff8000e137812ULL, 0x000fc400078ec0ffULL,
0x000000070c0c7812ULL, 0x000fe400078e7811ULL, 0x0000000800037812ULL, 0x000fc600078ec0ffULL,
0x00000008110c7824ULL, 0x000fc800078e020cULL, 0x000000100c0c7824ULL, 0x000fc800078e0213ULL,
0x0000000703127812ULL, 0x100fe200078ef800ULL, 0x011000000c2c783bULL, 0x000e620000000200ULL,
0x0000006257677211ULL, 0x000fe200078e08ffULL, 0x00000002656a7824ULL, 0x000fe200078e00ffULL,
0x00000004ff167819ULL, 0x100fe40000011600ULL, 0x0000000703037812ULL, 0x000fe200078ec800ULL,
0x0000200067677824ULL, 0x000fe200078e00ffULL, 0x000000020d1c7810ULL, 0x000fe40007ffe016ULL,
0x0000000216107810ULL, 0x000fe20007ffe0ffULL, 0x000010006c0e7824ULL, 0x000fe200078e0267ULL,
0x0000000416147810ULL, 0x000fc40007ffe0ffULL, 0x00000016031d7212ULL, 0x040fe400078e3cffULL,
0x0000000616167810ULL, 0x000fe40007ffe0ffULL, 0x00000010031f7212ULL, 0x040fe200078e3cffULL,
0x00000008120d7824ULL, 0x000fe200078e021dULL, 0x0000001403217212ULL, 0x040fe400078e3cffULL,
0x0000001603037212ULL, 0x000fe400078e3cffULL, 0x000130000e1e7810ULL, 0x000fe20007ffe0ffULL,
0x00000008120e7824ULL, 0x000fe200078e021fULL, 0x000000071c1c7812ULL, 0x000fe200078e7811ULL,
0x00000008120f7824ULL, 0x040fe200078e0221ULL, 0x0000001e0d5c7211ULL, 0x000fe200078e20ffULL,
0x0000000812107824ULL, 0x000fe200078e0203ULL, 0x0000991002027816ULL, 0x000fe200000000ffULL,
0x000000100e587824ULL, 0x100fe200078e021eULL, 0xfffffff86a6a7812ULL, 0x000fe200078ec0ffULL,
0x000000100f507824ULL, 0x100fe200078e021eULL, 0x000000005c5c783bULL, 0x000ee20000004200ULL,
0x0000001010307824ULL, 0x000fe200078e021eULL, 0x000000ff0200720cULL, 0x000fe20003f05270ULL,
0x00000008111c7824ULL, 0x000fe200078e021cULL, 0x000000005858783bULL, 0x000f680000004200ULL,
0x000000005050783bULL, 0x000fe20000004200ULL, 0x000000131c117211ULL, 0x000fc400078e20ffULL,
0x00000080121c7811ULL, 0x000fe200078e18ffULL, 0x000000003030783bULL, 0x000fe60000004200ULL,
0x0000006b2c2c8232ULL, 0x086fe20000000000ULL, 0x000000011f137824ULL, 0x100fe200078e021cULL,
0x011000001114783bULL, 0x000e620000000200ULL, 0x000000011d127824ULL, 0x100fe200078e021cULL,
0x0000006b2e2e8232ULL, 0x000fe20000000000ULL, 0x0000000121027824ULL, 0x100fe200078e021cULL,
0x0000001e13247211ULL, 0x000fe200078e20ffULL, 0x0000000103037824ULL, 0x000fe200078e021cULL,
0x000000682d2d8232ULL, 0x090fe20000000000ULL, 0x0000001012287824ULL, 0x100fe200078e021eULL,
0x000000682f2f8232ULL, 0x000fe20000000000ULL, 0x0000001002207824ULL, 0x100fe200078e021eULL,
0x000000002424783bULL, 0x000fe20000004200ULL, 0x00000010031c7824ULL, 0x000fc600078e021eULL,
0x000000002828783bULL, 0x000ea80000004200ULL, 0x000000002020783bULL, 0x000f280000004200ULL,
0x000000001c1c783bULL, 0x000ea20000004200ULL, 0x0000005c2c4c723cULL, 0x048ff0000000184cULL,
0x0000005e2c48723cULL, 0x040ff00000001848ULL, 0x000000582c44723cULL, 0x020fe20000001844ULL,
0x0000006b14148232ULL, 0x002fc40000000000ULL, 0x0000006b16168232ULL, 0x000fe40000000000ULL,
0x0000006815158232ULL, 0x080fe40000000000ULL, 0x0000006817178232ULL, 0x000fe20000000000ULL,
0x0000005a2c40723cULL, 0x040ff00000001840ULL, 0x000000502c3c723cULL, 0x040ff0000000183cULL,
0x000000522c38723cULL, 0x040ff00000001838ULL, 0x000000302c34723cULL, 0x040ff00000001834ULL,
0x000000322c18723cULL, 0x000ff00000001818ULL, 0x00000028144c723cULL, 0x044ff0000000184cULL,
0x0000002a1448723cULL, 0x040ff00000001848ULL, 0x000000241444723cULL, 0x040ff00000001844ULL,
0x000000261440723cULL, 0x040ff00000001840ULL, 0x00000020143c723cULL, 0x050ff0000000183cULL,
0x000000221438723cULL, 0x040ff00000001838ULL, 0x0000001c1434723cULL, 0x040ff00000001834ULL,
0x0000001e1418723cULL, 0x000fe20000001818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0000004066157811ULL, 0x000fe200078e40ffULL, 0x01b688006aff7f8cULL, 0x0003e2000c80043fULL,
0x000000016c6c7812ULL, 0x000fc400078e0cffULL, 0x000000641500720cULL, 0x000fda0003f06070ULL,
0x000040a000000947ULL, 0x000fea0003800000ULL, 0x0000000166147810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000631400720cULL, 0x000fe40003f06070ULL,
0x0000008069177810ULL, 0x000fca0007ffe0ffULL, 0x0000620060247a24ULL, 0x000fcc00078e0217ULL,
0x000005c000008947ULL, 0x000fea0003800000ULL, 0x0000001764157217ULL, 0x000fe20007800000ULL,
0x0000000862167824ULL, 0x000fe200078e00ffULL, 0x00000003ff1d7819ULL, 0x000fe20000011600ULL,
0x0000100004147824ULL, 0x000fe200078e00ffULL, 0x0000001517157210ULL, 0x000fe20007ffe1ffULL,
0x00000100ff257424ULL, 0x000fe200078e00ffULL, 0xfffffff816277812ULL, 0x000fe400078ee20bULL,
0x0000002015167817ULL, 0x000fe40003800000ULL, 0x00001000141c7812ULL, 0x000fe200078ec0ffULL,
0x000000011d147824ULL, 0x040fe200078e0224ULL, 0x000000071d177812ULL, 0x000fc400078e4800ULL,
0x000000161d00720cULL, 0x040fe20003f06070ULL, 0x00005e0014147625ULL, 0x000fe200078e0025ULL,
0x0000000c1d237810ULL, 0x000fe40007ffe0ffULL, 0x0001300067267810ULL, 0x000fe40007ffe01cULL,
0x0ffffff817177812ULL, 0x000fe200078ef800ULL, 0x0000001027147825ULL, 0x000fe200078e0014ULL,
0x000000041d1f7810ULL, 0x040fe40007ffe0ffULL, 0x000000081d217810ULL, 0x000fe20007ffe0ffULL,
0x00000008232d7824ULL, 0x000fe200078e00ffULL, 0x0000002617177211ULL, 0x000fe200078e20ffULL,
0x000000081f297824ULL, 0x000fe200078e00ffULL, 0x000000101d2f7810ULL, 0x000fe20007ffe0ffULL,
0x00000008212b7824ULL, 0x000fe200078e00ffULL, 0x000000141d317810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000c101c46ULL,
0x000000181d337810ULL, 0x000fe20007ffe0ffULL, 0x000000082f287824ULL, 0x000fe200078e00ffULL,
0x0000001c1d517810ULL, 0x000fe20007ffe0ffULL, 0x00000008312a7824ULL, 0x000fe200078e00ffULL,
0x0000000023207212ULL, 0x080fe200078e3cffULL, 0x00000008332c7824ULL, 0x000fe200078e00ffULL,
0x000000001f1c7212ULL, 0x080fe200078e3cffULL, 0x00000008512e7824ULL, 0x000fe200078e00ffULL,
0x00000000211e7212ULL, 0x000fe200078e3cffULL, 0x0000000133227824ULL, 0x000fe200078e0224ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee220ULL, 0x000000011f147824ULL, 0x042fe200078e0224ULL,
0x000000161f00720cULL, 0x000fc40003f06070ULL, 0xfffffff829297812ULL, 0x000fe200078ee21cULL,
0x00000001231c7824ULL, 0x000fe200078e0224ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee21eULL,
0x000000012f1e7824ULL, 0x000fe200078e0224ULL, 0x000000162100720cULL, 0x080fe40003f26070ULL,
0x000000162300720cULL, 0x080fe20003f46070ULL, 0x00005e0022227625ULL, 0x000fe200078e0025ULL,
0x000000162f00720cULL, 0x080fe40003f66070ULL, 0x000000163100720cULL, 0x000fc40003f86070ULL,
0x000000163300720cULL, 0x080fe20003fa6070ULL, 0x0000001027227825ULL, 0x000fe200078e0022ULL,
0x000000165100720cULL, 0x000fe40003fc6070ULL, 0x000000002f157212ULL, 0x000fe200078e3cffULL,
0x0000000121167824ULL, 0x100fe200078e0224ULL, 0x0000002431207210ULL, 0x000fe20007ffe0ffULL,
0x0000000151247824ULL, 0x000fe200078e0224ULL, 0x0000000031177212ULL, 0x080fe400078e3cffULL,
0x00000000331d7212ULL, 0x080fe200078e3cffULL, 0x00005e0020207625ULL, 0x000fe200078e0025ULL,
0x00000000511f7212ULL, 0x000fc400078e3cffULL, 0xfffffff8282f7812ULL, 0x000fe200078ee215ULL,
0x00005e0014147625ULL, 0x080fe200078e0025ULL, 0xfffffff82a317812ULL, 0x000fe400078ee217ULL,
0xfffffff82c337812ULL, 0x000fe200078ee21dULL, 0x00005e0016167625ULL, 0x000fe200078e0025ULL,
0xfffffff82e517812ULL, 0x000fc600078ee21fULL, 0x00005e001c1c7625ULL, 0x000fc800078e0025ULL,
0x00005e001e1e7625ULL, 0x000fc800078e0025ULL, 0x00005e0024247625ULL, 0x000fc800078e0025ULL,
0x0000001027147825ULL, 0x000fc800078e0014ULL, 0x0000001027167825ULL, 0x000fc800078e0016ULL,
0x00000010271c7825ULL, 0x000fc800078e001cULL, 0x00000010271e7825ULL, 0x000fc800078e001eULL,
0x0000001027207825ULL, 0x000fc800078e0020ULL, 0x0000001027247825ULL, 0x000fe200078e0024ULL,
0x0000002629277211ULL, 0x000fc600078e20ffULL, 0x000000102b297824ULL, 0x100fe400078e0226ULL,
0x000000102d2b7824ULL, 0x100fe200078e0226ULL, 0x0000000014277faeULL, 0x0003e2000c101c46ULL,
0x000000102f2d7824ULL, 0x100fe400078e0226ULL, 0x00000010312f7824ULL, 0x100fe200078e0226ULL,
0x0000000016297faeULL, 0x0003e2000c901c46ULL, 0x0000001033317824ULL, 0x000fe200078e0226ULL,
0x0000002651337211ULL, 0x000fe400078e20ffULL, 0x000000001c2b7faeULL, 0x0003e8000d101c46ULL,
0x000000001e2d7faeULL, 0x0003e8000d901c46ULL, 0x00000000202f7faeULL, 0x0003e8000e101c46ULL,
0x0000000022317faeULL, 0x0003e8000e901c46ULL, 0x0000000024337faeULL, 0x0003e2000f101c46ULL,
0x0000050000007947ULL, 0x000fea0003800000ULL, 0x00000003ff157819ULL, 0x000fe20000011600ULL,
0x00000008621c7824ULL, 0x000fe200078e00ffULL, 0x0000010000277802ULL, 0x000fc40000000f00ULL,
0x00000004151d7810ULL, 0x040fe40007ffe0ffULL, 0x00000008151f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c15217810ULL, 0x000fe20007ffe0ffULL, 0x000000081d2d7824ULL, 0x040fe200078e00ffULL,
0x000000001d147212ULL, 0x080fe200078e3cffULL, 0x000000081f2f7824ULL, 0x040fe200078e00ffULL,
0x000000001f167212ULL, 0x080fe200078e3cffULL, 0x00000008211e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee214ULL, 0x0000100004147824ULL, 0x000fe200078e00ffULL,
0x0000000021177212ULL, 0x000fc400078e3cffULL, 0xfffffff82f2f7812ULL, 0x000fe400078ee216ULL,
0xfffffff81e317812ULL, 0x000fe200078ee217ULL, 0x00000001211e7824ULL, 0x100fe200078e0224ULL,
0x0000100014167812ULL, 0x000fe200078ec0ffULL, 0x0000000115147824ULL, 0x040fe200078e0224ULL,
0x0000000715177812ULL, 0x040fe400078e4800ULL, 0x0000001015237810ULL, 0x040fe40007ffe0ffULL,
0x0000001415257810ULL, 0x000fc40007ffe0ffULL, 0x00000018152b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000123207824ULL, 0x100fe200078e0224ULL, 0x0000001c15337810ULL, 0x000fe20007ffe0ffULL,
0x0000000125227824ULL, 0x000fe200078e0224ULL, 0x0001300067287810ULL, 0x000fe20007ffe016ULL,
0x000000011d167824ULL, 0x000fe200078e0224ULL, 0x0ffffff817177812ULL, 0x000fe200078ef800ULL,
0x00000008252e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c297812ULL, 0x000fe200078ee20bULL,
0x000000011f1c7824ULL, 0x100fe200078e0224ULL, 0x00000000231d7212ULL, 0x080fe200078e3cffULL,
0x000000012b267824ULL, 0x100fe200078e0224ULL, 0x00000003232c7819ULL, 0x000fe200000006ffULL,
0x00000001332a7824ULL, 0x000fe200078e0224ULL, 0x00000000251f7212ULL, 0x080fe200078e3cffULL,
0x000000082b247824ULL, 0x040fe200078e00ffULL, 0x000000002b217212ULL, 0x080fe200078e3cffULL,
0x00005e0014147625ULL, 0x000fe200078e0027ULL, 0x0000000033237212ULL, 0x000fc400078e3cffULL,
0x0000000333307819ULL, 0x000fe200000006ffULL, 0x00000010172b7824ULL, 0x000fe200078e0228ULL,
0xfffffff82c337812ULL, 0x000fe200078ee21dULL, 0x00005e0016167625ULL, 0x080fe200078e0027ULL,
0xfffffff82e517812ULL, 0x000fe400078ee21fULL, 0xfffffff824537812ULL, 0x000fe200078ee221ULL,
0x00005e001c1c7625ULL, 0x080fe200078e0027ULL, 0xfffffff830597812ULL, 0x000fe400078ee223ULL,
0x0000002851517211ULL, 0x000fe200078e20ffULL, 0x00005e001e1e7625ULL, 0x000fc800078e0027ULL,
0x00005e0020207625ULL, 0x000fc800078e0027ULL, 0x00005e0022227625ULL, 0x000fc800078e0027ULL,
0x0000001029147825ULL, 0x000fc800078e0014ULL, 0x00005e0026247625ULL, 0x080fe200078e0027ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000142b7faeULL, 0x0003e6000b901c46ULL,
0x00005e002a267625ULL, 0x000fc800078e0027ULL, 0x0000001029167825ULL, 0x000fc800078e0016ULL,
0x000000102d2d7824ULL, 0x000fe400078e0228ULL, 0x00000010291c7825ULL, 0x000fc600078e001cULL,
0x00000000162d7faeULL, 0x0003e2000b901c46ULL, 0x000000102f2f7824ULL, 0x000fe400078e0228ULL,
0x00000010291e7825ULL, 0x000fc600078e001eULL, 0x000000001c2f7faeULL, 0x0003e2000b901c46ULL,
0x0000001031317824ULL, 0x000fe400078e0228ULL, 0x0000001029207825ULL, 0x000fc600078e0020ULL,
0x000000001e317faeULL, 0x0003e2000b901c46ULL, 0x0000001033337824ULL, 0x000fe400078e0228ULL,
0x0000001029227825ULL, 0x000fc600078e0022ULL, 0x0000000020337faeULL, 0x0003e2000b901c46ULL,
0x0000001029247825ULL, 0x000fc600078e0024ULL, 0x0000000022517faeULL, 0x0003e2000b901c46ULL,
0x0000001053537824ULL, 0x000fe400078e0228ULL, 0x0000001029267825ULL, 0x000fc600078e0026ULL,
0x0000000024537faeULL, 0x0003e2000b901c46ULL, 0x0000001059597824ULL, 0x000fca00078e0228ULL,
0x0000000026597faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6280005147f8cULL, 0x002fe8000c80043fULL,
0x01b62c0005177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0xffffffe061177812ULL, 0x040fe200078ec0ffULL,
0x3e000000ff167424ULL, 0x000fe200078e00ffULL, 0x00000010611c7812ULL, 0x000fc400078ec0ffULL,
0x00000008611d7812ULL, 0x000fc800078ec0ffULL, 0x000000171d1c7210ULL, 0x000fe40007ffe01cULL,
0x0000001600177305ULL, 0x0002a4000021f000ULL, 0x3fa0000016167823ULL, 0x002fe200000100ffULL,
0x000000170000735dULL, 0x004fe40003800000ULL, 0x01b62c001c177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008006157810ULL, 0x000fca0007ffe007ULL, 0x0000000108157824ULL, 0x000fca00078e0215ULL,
0x01b0000015167984ULL, 0x000e680000000800ULL, 0x01b2000015177984ULL, 0x0004e20000000800ULL,
0x000000551600720bULL, 0x002fe20003f1d000ULL, 0x0000d5527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x004fc800000e0100ULL, 0x0000ffff141e7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1c7424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000165147811ULL, 0x000fe400078ff0ffULL,
0x000000551600720bULL, 0x000fe40003f34000ULL, 0x000000651400720cULL, 0x000fe20003f05270ULL,
0x0000d5227f007947ULL, 0x000ff4000b800000ULL, 0x0000000000147806ULL, 0x000fe400008e0100ULL,
0x00000016551c7209ULL, 0x000fe20007810000ULL, 0x00000080651d8824ULL, 0x000fe200078e0206ULL,
0x00000002ff257819ULL, 0x000fc60000011600ULL, 0x8000001c55157221ULL, 0x000fe40000010000ULL,
0x00000001081f8824ULL, 0x000fe200078e021dULL, 0x0000ffff141d7812ULL, 0x000fe200078e3cffULL,
0x3fb8aa3b15157820ULL, 0x000fc60000410000ULL, 0x01b4001c1f008388ULL, 0x0003e20000000800ULL,
0x0000001500247308ULL, 0x000ea20000000800ULL, 0x0000001d1eff7212ULL, 0x000fe2000780c0ffULL,
0x0000002454547220ULL, 0x004fe20000410000ULL, 0x0000d4b27f007947ULL, 0x000ff2000b800000ULL,
0x00001f2524147589ULL, 0x0022a400000e0000ULL, 0x000000144c4c7220ULL, 0x084fe40000410000ULL,
0x000000144d4d7220ULL, 0x080fe40000410000ULL, 0x0000001448487220ULL, 0x080fe40000410000ULL,
0x0000001449497220ULL, 0x000fc40000410000ULL, 0x0000001444447220ULL, 0x080fe40000410000ULL,
0x0000001445457220ULL, 0x080fe40000410000ULL, 0x0000001440407220ULL, 0x080fe40000410000ULL,
0x0000001441417220ULL, 0x080fe40000410000ULL, 0x000000143c3c7220ULL, 0x080fe40000410000ULL,
0x000000143d3d7220ULL, 0x000fc40000410000ULL, 0x0000001438387220ULL, 0x080fe40000410000ULL,
0x0000001439397220ULL, 0x080fe40000410000ULL, 0x0000001434347220ULL, 0x080fe40000410000ULL,
0x0000001435357220ULL, 0x080fe40000410000ULL, 0x0000001418187220ULL, 0x080fe40000410000ULL,
0x0000001419197220ULL, 0x000fe20000410000ULL, 0x0000d3f27f007947ULL, 0x000fea000b800000ULL,
0x00001f0a24147589ULL, 0x00052400000e0000ULL, 0x0000001655557209ULL, 0x000fe20007810000ULL,
0x000000144e4e7220ULL, 0x090fe20000410000ULL, 0x00000001ff1c7807ULL, 0x000fe20000000000ULL,
0x000000144f4f7220ULL, 0x000fc40000410000ULL, 0x8000005516160221ULL, 0x000fe40000010000ULL,
0x000000144a4a7220ULL, 0x080fe40000410000ULL, 0x3fb8aa3b16160820ULL, 0x000fe40000410000ULL,
0x000000144b4b7220ULL, 0x080fe40000410000ULL, 0x0000001600090308ULL, 0x000f220000000800ULL,
0x0000001446467220ULL, 0x080fe40000410000ULL, 0x0000001447477220ULL, 0x000fc40000410000ULL,
0x0000001442427220ULL, 0x080fe40000410000ULL, 0x0000001443437220ULL, 0x080fe40000410000ULL,
0x000000143e3e7220ULL, 0x080fe40000410000ULL, 0x000000143f3f7220ULL, 0x080fe40000410000ULL,
0x000000143a3a7220ULL, 0x080fe40000410000ULL, 0x000000143b3b7220ULL, 0x000fc40000410000ULL,
0x0000001436367220ULL, 0x080fe40000410000ULL, 0x0000001437377220ULL, 0x080fe40000410000ULL,
0x000000141a1a7220ULL, 0x080fe40000410000ULL, 0x000000141b1b7220ULL, 0x000fe40000410000ULL,
0x0000001709170220ULL, 0x018fe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000009ff14723eULL, 0x000fe200000000ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff257819ULL, 0x002fe40000011600ULL, 0x0000001000167811ULL, 0x000fe400078ff0ffULL,
0x00000018251d7810ULL, 0x000fe40007ffe0ffULL, 0x0000541014247816ULL, 0x004fe20000000014ULL,
0x0000d2727f007947ULL, 0x000fea000b800000ULL, 0x00001f25246b7589ULL, 0x0002a800000e0000ULL,
0x00001f0a246c7589ULL, 0x00032400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff257224ULL, 0x002fe200078e0016ULL, 0x00003db000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff267424ULL, 0x000fc400078e00ffULL, 0xffffffffff277424ULL, 0x000fe400078e00ffULL,
0x0000de5000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff257224ULL, 0x002fe200078e001dULL, 0x0000001f00267802ULL, 0x000fe20000000f00ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x00003e1000147802ULL, 0x000fe40000000f00ULL,
0x0000ddf000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000005417547221ULL, 0x008fe40000010000ULL, 0x0000100004687824ULL, 0x000fe200078e00ffULL,
0x011800000c2c783bULL, 0x000ee20000000200ULL, 0x000099101c1c7816ULL, 0x000fc600000000ffULL,
0x0000100068687812ULL, 0x000fe200078e0cffULL, 0x011800001114783bULL, 0x000f620000000200ULL,
0x000000ff1c00720cULL, 0x000fe40003f05270ULL, 0x0001300067687810ULL, 0x000fc80007ffe068ULL,
0x0000006810307211ULL, 0x000fe200078e20ffULL, 0x000000100d5c7824ULL, 0x100fe400078e0268ULL,
0x000000100e587824ULL, 0x100fe400078e0268ULL, 0x000000100f507824ULL, 0x100fe200078e0268ULL,
0x000000003030783bULL, 0x000e620000004200ULL, 0x0000001012287824ULL, 0x100fe400078e0268ULL,
0x0000001013247824ULL, 0x102fe200078e0268ULL, 0x000000005c5c783bULL, 0x000e620000004200ULL,
0x0000001002207824ULL, 0x000fc400078e0268ULL, 0x00000010031c7824ULL, 0x000fe200078e0268ULL,
0x000000005858783bULL, 0x000f280000004200ULL, 0x000000005050783bULL, 0x000ea80000004200ULL,
0x000000002828783bULL, 0x000ea80000004200ULL, 0x000000002424783bULL, 0x000ea40000004200ULL,
0x0000006b2c2c8232ULL, 0x00cfc40000000000ULL, 0x000000002020783bULL, 0x000ea20000004200ULL,
0x0000006b2e2e8232ULL, 0x080fe40000000000ULL, 0x0000006c2d2d8232ULL, 0x090fe20000000000ULL,
0x000000001c1c783bULL, 0x000ee20000004200ULL, 0x0000006c2f2f8232ULL, 0x080fe40000000000ULL,
0x0000006b14148232ULL, 0x0a0fe40000000000ULL, 0x0000006b16168232ULL, 0x000fe40000000000ULL,
0x0000006c15158232ULL, 0x000fc40000000000ULL, 0x0000006c17178232ULL, 0x000fe20000000000ULL,
0x000000302c34723cULL, 0x040ff00000001834ULL, 0x0000005c2c4c723cULL, 0x042ff0000000184cULL,
0x0000005e2c48723cULL, 0x040ff00000001848ULL, 0x000000582c44723cULL, 0x040ff00000001844ULL,
0x0000005a2c40723cULL, 0x040ff00000001840ULL, 0x000000502c3c723cULL, 0x040ff0000000183cULL,
0x000000522c38723cULL, 0x040ff00000001838ULL, 0x000000322c18723cULL, 0x000ff00000001818ULL,
0x00000028144c723cULL, 0x040ff0000000184cULL, 0x0000002a1448723cULL, 0x040ff00000001848ULL,
0x000000241444723cULL, 0x040ff00000001844ULL, 0x000000261440723cULL, 0x040ff00000001840ULL,
0x00000020143c723cULL, 0x044ff0000000183cULL, 0x000000221438723cULL, 0x040ff00000001838ULL,
0x0000001c1434723cULL, 0x048ff00000001834ULL, 0x0000001e1418723cULL, 0x000fe20000001818ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0000008066157811ULL, 0x000fe200078e40ffULL,
0x01b690006aff7f8cULL, 0x0003e2000c80043fULL, 0x00000001046c7812ULL, 0x000fc400078ec0ffULL,
0x000000641500720cULL, 0x000fda0003f06070ULL, 0x00002a9000000947ULL, 0x000fea0003800000ULL,
0x0000000166147810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000631400720cULL, 0x000fe40003f06070ULL, 0x000000c069697810ULL, 0x000fca0007ffe0ffULL,
0x0000620060247a24ULL, 0x000fcc00078e0269ULL, 0x0000059000008947ULL, 0x000fea0003800000ULL,
0x0000006964147217ULL, 0x000fe20007800000ULL, 0x0000000862167824ULL, 0x000fe200078e00ffULL,
0x00000003ff1d7819ULL, 0x000fe20000011600ULL, 0x00000100ff257424ULL, 0x000fe200078e00ffULL,
0x0000001469147210ULL, 0x000fe40007ffe1ffULL, 0xfffffff8162b7812ULL, 0x000fe200078ee20bULL,
0x000000011d157824ULL, 0x040fe200078e0224ULL, 0x0000002014167817ULL, 0x000fe40003800000ULL,
0x000000071d177812ULL, 0x000fe200078e4800ULL, 0x00005e0015147625ULL, 0x000fe200078e0025ULL,
0x000000161d00720cULL, 0x000fc40003f06070ULL, 0x0000000c1d237810ULL, 0x000fe40007ffe0ffULL,
0x0ffffff817177812ULL, 0x000fe200078ef800ULL, 0x000000102b147825ULL, 0x000fe200078e0014ULL,
0x000000041d1f7810ULL, 0x040fe40007ffe0ffULL, 0x000000081d217810ULL, 0x000fe20007ffe0ffULL,
0x00000008232d7824ULL, 0x000fe200078e00ffULL, 0x0000006817177211ULL, 0x000fe200078e20ffULL,
0x000000081f277824ULL, 0x000fe200078e00ffULL, 0x000000101d2f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000821297824ULL, 0x000fe200078e00ffULL, 0x000000141d317810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000c101c46ULL,
0x000000181d337810ULL, 0x000fe20007ffe0ffULL, 0x000000082f267824ULL, 0x000fe200078e00ffULL,
0x0000001c1d517810ULL, 0x000fe20007ffe0ffULL, 0x0000000831287824ULL, 0x000fe200078e00ffULL,
0x0000000023207212ULL, 0x080fe200078e3cffULL, 0x00000008332a7824ULL, 0x000fe200078e00ffULL,
0x000000001f1c7212ULL, 0x080fe200078e3cffULL, 0x00000008512c7824ULL, 0x000fe200078e00ffULL,
0x00000000211e7212ULL, 0x000fe200078e3cffULL, 0x0000000133227824ULL, 0x000fe200078e0224ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee220ULL, 0x000000011f147824ULL, 0x042fe200078e0224ULL,
0x000000161f00720cULL, 0x000fc40003f06070ULL, 0xfffffff827277812ULL, 0x000fe200078ee21cULL,
0x00000001231c7824ULL, 0x000fe200078e0224ULL, 0xfffffff829297812ULL, 0x000fe200078ee21eULL,
0x000000012f1e7824ULL, 0x000fe200078e0224ULL, 0x000000162100720cULL, 0x080fe40003f26070ULL,
0x000000162300720cULL, 0x080fe20003f46070ULL, 0x00005e0022227625ULL, 0x000fe200078e0025ULL,
0x000000162f00720cULL, 0x080fe40003f66070ULL, 0x000000163100720cULL, 0x080fe20003f86070ULL,
0x0000001029297824ULL, 0x000fe200078e0268ULL, 0x000000163300720cULL, 0x080fe20003fa6070ULL,
0x000000102b227825ULL, 0x000fe200078e0022ULL, 0x000000165100720cULL, 0x000fc40003fc6070ULL,
0x000000002f157212ULL, 0x000fe200078e3cffULL, 0x0000000121167824ULL, 0x100fe200078e0224ULL,
0x0000002431207210ULL, 0x000fe20007ffe0ffULL, 0x0000000151247824ULL, 0x000fe200078e0224ULL,
0x0000000031177212ULL, 0x080fe400078e3cffULL, 0x00000000331d7212ULL, 0x080fe200078e3cffULL,
0x00005e0020207625ULL, 0x080fe200078e0025ULL, 0x00000000511f7212ULL, 0x000fe400078e3cffULL,
0xfffffff8262f7812ULL, 0x000fe200078ee215ULL, 0x00005e0014147625ULL, 0x000fe200078e0025ULL,
0xfffffff828317812ULL, 0x000fc400078ee217ULL, 0xfffffff82a337812ULL, 0x000fe200078ee21dULL,
0x00005e0016167625ULL, 0x080fe200078e0025ULL, 0xfffffff82c517812ULL, 0x000fe400078ee21fULL,
0x0000006827277211ULL, 0x000fe200078e20ffULL, 0x00005e001c1c7625ULL, 0x000fc800078e0025ULL,
0x00005e001e1e7625ULL, 0x000fc800078e0025ULL, 0x00005e0024247625ULL, 0x000fc800078e0025ULL,
0x000000102b147825ULL, 0x000fc800078e0014ULL, 0x000000102b167825ULL, 0x040fe200078e0016ULL,
0x0000000014277faeULL, 0x0003e6000c101c46ULL, 0x000000102b1c7825ULL, 0x040fe200078e001cULL,
0x0000000016297faeULL, 0x0003e6000c901c46ULL, 0x000000102b1e7825ULL, 0x000fc800078e001eULL,
0x000000102b207825ULL, 0x000fc800078e0020ULL, 0x000000102b247825ULL, 0x000fc800078e0024ULL,
0x000000102d2b7824ULL, 0x100fe400078e0268ULL, 0x000000102f2d7824ULL, 0x100fe400078e0268ULL,
0x00000010312f7824ULL, 0x100fe200078e0268ULL, 0x000000001c2b7faeULL, 0x0003e2000d101c46ULL,
0x0000001033317824ULL, 0x000fe200078e0268ULL, 0x0000006851337211ULL, 0x000fe400078e20ffULL,
0x000000001e2d7faeULL, 0x0003e8000d901c46ULL, 0x00000000202f7faeULL, 0x0003e8000e101c46ULL,
0x0000000022317faeULL, 0x0003e8000e901c46ULL, 0x0000000024337faeULL, 0x0003e2000f101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x00000003ff157819ULL, 0x000fe20000011600ULL,
0x00000100ff277424ULL, 0x000fc600078e00ffULL, 0x00000004151d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c15217810ULL, 0x000fe40007ffe0ffULL, 0x000000001d147212ULL, 0x0c0fe200078e3cffULL,
0x000000081d2d7824ULL, 0x000fe200078e00ffULL, 0x00000008151f7810ULL, 0x000fe20007ffe0ffULL,
0x00000008211c7824ULL, 0x040fe200078e00ffULL, 0x0000000021177212ULL, 0x0c0fe200078e3cffULL,
0x00000001211e7824ULL, 0x000fe200078e0224ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee214ULL,
0x0000000862147824ULL, 0x000fe200078e00ffULL, 0xfffffff81c317812ULL, 0x000fe200078ee217ULL,
0x000000081f2f7824ULL, 0x040fe200078e00ffULL, 0x000000001f167212ULL, 0x040fe200078e3cffULL,
0x000000011f1c7824ULL, 0x000fe200078e0224ULL, 0x0000000715177812ULL, 0x000fe200078e4800ULL,
0x000000102d2d7824ULL, 0x000fe200078e0268ULL, 0x0000001415257810ULL, 0x000fc40007ffe0ffULL,
0x0000001015237810ULL, 0x040fe40007ffe0ffULL, 0x00000018152b7810ULL, 0x000fe20007ffe0ffULL,
0x00000008252c7824ULL, 0x000fe200078e00ffULL, 0x0000001c15337810ULL, 0x000fe20007ffe0ffULL,
0x0000000123207824ULL, 0x100fe200078e0224ULL, 0xfffffff814297812ULL, 0x000fe200078ee20bULL,
0x0000000125227824ULL, 0x000fe200078e0224ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee216ULL,
0x000000011d167824ULL, 0x100fe200078e0224ULL, 0x0000002415147210ULL, 0x000fe20007ffe0ffULL,
0x000000012b267824ULL, 0x000fe200078e0224ULL, 0x0ffffff817177812ULL, 0x000fe200078ef800ULL,
0x0000000133287824ULL, 0x000fe200078e0224ULL, 0x00000000231d7212ULL, 0x080fe200078e3cffULL,
0x00000008332e7824ULL, 0x000fe200078e00ffULL, 0x00000003232a7819ULL, 0x000fe200000006ffULL,
0x00005e0014147625ULL, 0x000fe200078e0027ULL, 0x00000000251f7212ULL, 0x000fc400078e3cffULL,
0x000000002b217212ULL, 0x080fe200078e3cffULL, 0x000000102f2f7824ULL, 0x100fe200078e0268ULL,
0x000000032b247819ULL, 0x000fe200000006ffULL, 0x00000010172b7824ULL, 0x000fe200078e0268ULL,
0x0000000033237212ULL, 0x000fe200078e3cffULL, 0x00005e0016167625ULL, 0x080fe200078e0027ULL,
0xfffffff82a337812ULL, 0x000fe400078ee21dULL, 0xfffffff82c517812ULL, 0x000fe200078ee21fULL,
0x00005e001c1c7625ULL, 0x000fe200078e0027ULL, 0xfffffff824537812ULL, 0x000fc400078ee221ULL,
0xfffffff82e597812ULL, 0x000fe200078ee223ULL, 0x00005e001e1e7625ULL, 0x000fe200078e0027ULL,
0x0000006831317211ULL, 0x000fc600078e20ffULL, 0x00005e0020207625ULL, 0x000fc800078e0027ULL,
0x00005e0022227625ULL, 0x000fc800078e0027ULL, 0x0000001029147825ULL, 0x000fc800078e0014ULL,
0x00005e0026247625ULL, 0x080fe200078e0027ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000142b7faeULL, 0x0003e6000b901c46ULL, 0x00005e0028267625ULL, 0x000fc800078e0027ULL,
0x0000001029167825ULL, 0x000fc800078e0016ULL, 0x00000010291c7825ULL, 0x040fe200078e001cULL,
0x00000000162d7faeULL, 0x0003e6000b901c46ULL, 0x00000010291e7825ULL, 0x040fe200078e001eULL,
0x000000001c2f7faeULL, 0x0003e6000b901c46ULL, 0x0000001029207825ULL, 0x000fe200078e0020ULL,
0x000000001e317faeULL, 0x0003e6000b901c46ULL, 0x0000001033337824ULL, 0x000fc400078e0268ULL,
0x0000001029227825ULL, 0x000fc600078e0022ULL, 0x0000000020337faeULL, 0x0003e2000b901c46ULL,
0x0000001051517824ULL, 0x000fe400078e0268ULL, 0x0000001029247825ULL, 0x000fc600078e0024ULL,
0x0000000022517faeULL, 0x0003e2000b901c46ULL, 0x0000001053537824ULL, 0x000fe400078e0268ULL,
0x0000001029267825ULL, 0x000fc600078e0026ULL, 0x0000000024537faeULL, 0x0003e2000b901c46ULL,
0x0000001059597824ULL, 0x000fca00078e0268ULL, 0x0000000026597faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6480005147f8cULL, 0x002fe8000c80043fULL, 0x01b64c0005177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e00000000167802ULL, 0x000fc80000000f00ULL, 0x0000001600177305ULL, 0x0002a4000021f000ULL,
0x3fa0000016167823ULL, 0x002fe200000100ffULL, 0x000000170000735dULL, 0x004fe40003800000ULL,
0x01b64c0005177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fc40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010006157810ULL, 0x000fca0007ffe007ULL,
0x0000000108157824ULL, 0x000fca00078e0215ULL, 0x01b0000015167984ULL, 0x000e680000000800ULL,
0x01b2000015177984ULL, 0x0004e20000000800ULL, 0x000000551600720bULL, 0x002fe20003f1d000ULL,
0x0000c2327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x004fc800000e0100ULL,
0x0000ffff141e7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff1c7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000265147811ULL, 0x000fe400078ff0ffULL, 0x000000551600720bULL, 0x000fe40003f34000ULL,
0x000000651400720cULL, 0x000fe20003f05270ULL, 0x0000c2027f007947ULL, 0x000ff4000b800000ULL,
0x0000000000147806ULL, 0x000fe400008e0100ULL, 0x00000016551c7209ULL, 0x000fe20007810000ULL,
0x00000080651d8824ULL, 0x000fe200078e0206ULL, 0x00000002ff257819ULL, 0x000fc60000011600ULL,
0x8000001c55157221ULL, 0x000fe40000010000ULL, 0x00000001081f8824ULL, 0x000fe200078e021dULL,
0x0000ffff141d7812ULL, 0x000fe200078e3cffULL, 0x3fb8aa3b15157820ULL, 0x000fc60000410000ULL,
0x01b4001c1f008388ULL, 0x0003e20000000800ULL, 0x0000001500247308ULL, 0x000ea20000000800ULL,
0x0000001d1eff7212ULL, 0x000fe2000780c0ffULL, 0x0000002454547220ULL, 0x004fe20000410000ULL,
0x0000c1927f007947ULL, 0x000ff2000b800000ULL, 0x00001f2524147589ULL, 0x0022a400000e0000ULL,
0x000000144c4c7220ULL, 0x084fe40000410000ULL, 0x000000144d4d7220ULL, 0x080fe40000410000ULL,
0x0000001448487220ULL, 0x080fe40000410000ULL, 0x0000001449497220ULL, 0x000fc40000410000ULL,
0x0000001444447220ULL, 0x080fe40000410000ULL, 0x0000001445457220ULL, 0x080fe40000410000ULL,
0x0000001440407220ULL, 0x080fe40000410000ULL, 0x0000001441417220ULL, 0x080fe40000410000ULL,
0x000000143c3c7220ULL, 0x080fe40000410000ULL, 0x000000143d3d7220ULL, 0x000fc40000410000ULL,
0x0000001438387220ULL, 0x080fe40000410000ULL, 0x0000001439397220ULL, 0x080fe40000410000ULL,
0x0000001434347220ULL, 0x080fe40000410000ULL, 0x0000001435357220ULL, 0x080fe40000410000ULL,
0x0000001418187220ULL, 0x080fe40000410000ULL, 0x0000001419197220ULL, 0x000fe20000410000ULL,
0x0000c0d27f007947ULL, 0x000fea000b800000ULL, 0x00001f0a24147589ULL, 0x00052400000e0000ULL,
0x0000001655557209ULL, 0x000fe20007810000ULL, 0x000000144e4e7220ULL, 0x090fe20000410000ULL,
0x00000001ff1c7807ULL, 0x000fe20000000000ULL, 0x000000144f4f7220ULL, 0x000fc40000410000ULL,
0x8000005516160221ULL, 0x000fe40000010000ULL, 0x000000144a4a7220ULL, 0x080fe40000410000ULL,
0x3fb8aa3b16160820ULL, 0x000fe40000410000ULL, 0x000000144b4b7220ULL, 0x080fe40000410000ULL,
0x0000001600090308ULL, 0x000f220000000800ULL, 0x0000001446467220ULL, 0x080fe40000410000ULL,
0x0000001447477220ULL, 0x000fc40000410000ULL, 0x0000001442427220ULL, 0x080fe40000410000ULL,
0x0000001443437220ULL, 0x080fe40000410000ULL, 0x000000143e3e7220ULL, 0x080fe40000410000ULL,
0x000000143f3f7220ULL, 0x080fe40000410000ULL, 0x000000143a3a7220ULL, 0x080fe40000410000ULL,
0x000000143b3b7220ULL, 0x000fc40000410000ULL, 0x0000001436367220ULL, 0x080fe40000410000ULL,
0x0000001437377220ULL, 0x080fe40000410000ULL, 0x000000141a1a7220ULL, 0x080fe40000410000ULL,
0x000000141b1b7220ULL, 0x000fe40000410000ULL, 0x0000001709170220ULL, 0x018fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000009ff14723eULL, 0x000fe200000000ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff257819ULL, 0x002fe40000011600ULL,
0x0000001000167811ULL, 0x000fe400078ff0ffULL, 0x00000018251d7810ULL, 0x000fe40007ffe0ffULL,
0x0000541014247816ULL, 0x004fe20000000014ULL, 0x0000bf527f007947ULL, 0x000fea000b800000ULL,
0x00001f2524697589ULL, 0x0002a800000e0000ULL, 0x00001f0a246c7589ULL, 0x00032400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff257224ULL, 0x002fe200078e0016ULL,
0xffffffff00277802ULL, 0x000fe20000000f00ULL, 0x0000001fff267424ULL, 0x000fe200078e00ffULL,
0x0000532000147802ULL, 0x000fc40000000f00ULL, 0x0000c8e000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff257224ULL, 0x002fe200078e001dULL,
0x0000538000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff267424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fe400078e00ffULL, 0x0000c88000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000005417547221ULL, 0x008fe40000010000ULL,
0x0000100004147824ULL, 0x000fe200078e00ffULL, 0x012000000c2c783bULL, 0x000ee20000000200ULL,
0x000099101c1c7816ULL, 0x000fc600000000ffULL, 0x0000100014147812ULL, 0x000fe400078ec0ffULL,
0x000000ff1c00720cULL, 0x000fe40003f05270ULL, 0x0001300067677810ULL, 0x000fe40007ffe014ULL,
0x012000001114783bULL, 0x000f640000000200ULL, 0x000000670d5c7211ULL, 0x080fe200078e20ffULL,
0x000000100e587824ULL, 0x100fe200078e0267ULL, 0x0000006713247211ULL, 0x002fe200078e20ffULL,
0x000000100f507824ULL, 0x000fc400078e0267ULL, 0x0000001010307824ULL, 0x100fe200078e0267ULL,
0x000000005c5c783bULL, 0x000e620000004200ULL, 0x0000001012287824ULL, 0x100fe400078e0267ULL,
0x0000001002207824ULL, 0x100fe200078e0267ULL, 0x000000005858783bULL, 0x000f220000004200ULL,
0x00000010031c7824ULL, 0x000fc600078e0267ULL, 0x000000005050783bULL, 0x000ea80000004200ULL,
0x000000003030783bULL, 0x000ea80000004200ULL, 0x000000002828783bULL, 0x000ea80000004200ULL,
0x000000002424783bULL, 0x000ea40000004200ULL, 0x000000692c2c8232ULL, 0x00cfc40000000000ULL,
0x000000002020783bULL, 0x000ea20000004200ULL, 0x000000692e2e8232ULL, 0x080fe40000000000ULL,
0x0000006c2d2d8232ULL, 0x090fe20000000000ULL, 0x000000001c1c783bULL, 0x000ee20000004200ULL,
0x0000006c2f2f8232ULL, 0x080fe40000000000ULL, 0x0000006914148232ULL, 0x0a0fe40000000000ULL,
0x0000006916168232ULL, 0x000fe40000000000ULL, 0x0000006c15158232ULL, 0x000fc40000000000ULL,
0x0000006c17178232ULL, 0x000fe20000000000ULL, 0x0000005c2c4c723cULL, 0x042ff0000000184cULL,
0x0000005e2c48723cULL, 0x040ff00000001848ULL, 0x000000582c44723cULL, 0x040ff00000001844ULL,
0x0000005a2c40723cULL, 0x040ff00000001840ULL, 0x000000502c3c723cULL, 0x040ff0000000183cULL,
0x000000522c38723cULL, 0x040ff00000001838ULL, 0x000000302c34723cULL, 0x040ff00000001834ULL,
0x000000322c18723cULL, 0x000ff00000001818ULL, 0x00000028144c723cULL, 0x040ff0000000184cULL,
0x0000002a1448723cULL, 0x040ff00000001848ULL, 0x000000241444723cULL, 0x040ff00000001844ULL,
0x000000261440723cULL, 0x040ff00000001840ULL, 0x00000020143c723cULL, 0x044ff0000000183cULL,
0x000000221438723cULL, 0x040ff00000001838ULL, 0x0000001c1434723cULL, 0x048ff00000001834ULL,
0x0000001e1418723cULL, 0x000fe20000001818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000c066157811ULL, 0x000fe200078e40ffULL, 0x01b698006aff7f8cULL, 0x0003e2000c80043fULL,
0x00000001046c7812ULL, 0x000fc400078e0cffULL, 0x000000641500720cULL, 0x000fda0003f06070ULL,
0x0000152000000947ULL, 0x000fea0003800000ULL, 0x0000030066157a10ULL, 0x002fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000115147810ULL, 0x040fe20007ffe0ffULL,
0x0000010015157824ULL, 0x000fc600078e0256ULL, 0x000000631400720cULL, 0x000fe20003f06070ULL,
0x0000620060247a24ULL, 0x000fd800078e0215ULL, 0x0000059000008947ULL, 0x000fea0003800000ULL,
0x0000001564147217ULL, 0x000fe20007800000ULL, 0x0000000862167824ULL, 0x000fe200078e00ffULL,
0x00000003ff1d7819ULL, 0x000fe20000011600ULL, 0x00000100ff257424ULL, 0x000fe200078e00ffULL,
0x0000001415147210ULL, 0x000fe40007ffe1ffULL, 0xfffffff816277812ULL, 0x000fe200078ee20bULL,
0x000000011d157824ULL, 0x040fe200078e0224ULL, 0x00000020140b7817ULL, 0x000fe40003800000ULL,
0x000000041d1f7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0015147625ULL, 0x000fe200078e0025ULL,
0x000000081d217810ULL, 0x000fc40007ffe0ffULL, 0x000000071d177812ULL, 0x000fe200078e4800ULL,
0x000000081f297824ULL, 0x000fe200078e00ffULL, 0x0000000c1d237810ULL, 0x000fe20007ffe0ffULL,
0x00000008212b7824ULL, 0x000fe200078e00ffULL, 0x0000000b1d00720cULL, 0x000fe20003f06070ULL,
0x0000001027147825ULL, 0x000fe200078e0014ULL, 0x0ffffff817167812ULL, 0x000fe400078ef800ULL,
0x000000001f1c7212ULL, 0x080fe400078e3cffULL, 0x00000000211e7212ULL, 0x080fe200078e3cffULL,
0x0000001016177824ULL, 0x000fe200078e0267ULL, 0x0000000023207212ULL, 0x000fe200078e3cffULL,
0x0000000121167824ULL, 0x000fe200078e0224ULL, 0x00000003232d7819ULL, 0x000fc400000006ffULL,
0xfffffff829267812ULL, 0x000fe200078ee21cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000c101c46ULL, 0xfffffff82b287812ULL, 0x000fe200078ee21eULL,
0x00000001231c7824ULL, 0x000fe200078e0224ULL, 0xfffffff82d2a7812ULL, 0x000fe400078ee220ULL,
0x000000101d297810ULL, 0x040fe40007ffe0ffULL, 0x000000141d2b7810ULL, 0x040fe40007ffe0ffULL,
0x000000181d2d7810ULL, 0x000fe20007ffe0ffULL, 0x00000008292c7824ULL, 0x000fe200078e00ffULL,
0x0000001c1d1d7810ULL, 0x000fe20007ffe0ffULL, 0x000000011f147824ULL, 0x142fe200078e0224ULL,
0x0000000b1f00720cULL, 0x000fe20003f06070ULL, 0x000000082b2e7824ULL, 0x000fe200078e00ffULL,
0x00000024291e7210ULL, 0x000fe20007ffe0ffULL, 0x000000082d307824ULL, 0x000fe200078e00ffULL,
0x000000002b157212ULL, 0x080fe200078e3cffULL, 0x000000081d327824ULL, 0x000fe200078e00ffULL,
0x000000002d177212ULL, 0x080fe200078e3cffULL, 0x000000012b207824ULL, 0x100fe200078e0224ULL,
0x000000001d1f7212ULL, 0x000fe200078e3cffULL, 0x000000012d227824ULL, 0x000fe200078e0224ULL,
0x000000241d247210ULL, 0x000fc40007ffe0ffULL, 0x0000000b2100720cULL, 0x000fe20003f26070ULL,
0x00005e0020207625ULL, 0x000fe200078e0025ULL, 0x0000000b2300720cULL, 0x080fe40003f46070ULL,
0x0000000b1d00720cULL, 0x000fe20003fc6070ULL, 0x00005e001c1c7625ULL, 0x080fe200078e0025ULL,
0xfffffff82e2e7812ULL, 0x000fe400078ee215ULL, 0xfffffff830307812ULL, 0x000fe200078ee217ULL,
0x00005e0014147625ULL, 0x000fe200078e0025ULL, 0xfffffff832327812ULL, 0x000fc400078ee21fULL,
0x0000000b2900720cULL, 0x000fe20003f66070ULL, 0x00005e0016167625ULL, 0x000fe200078e0025ULL,
0x0000000b2b00720cULL, 0x080fe40003f86070ULL, 0x0000000b2d00720cULL, 0x000fe20003fa6070ULL,
0x00005e001e1e7625ULL, 0x000fe200078e0025ULL, 0x00000000290b7212ULL, 0x000fe400078e3cffULL,
0x000000672a297211ULL, 0x000fe200078e20ffULL, 0x00005e0022227625ULL, 0x000fe200078e0025ULL,
0xfffffff82c2c7812ULL, 0x000fc600078ee20bULL, 0x00005e0024247625ULL, 0x000fc800078e0025ULL,
0x0000001027147825ULL, 0x000fc800078e0014ULL, 0x0000001027167825ULL, 0x000fc800078e0016ULL,
0x00000010271c7825ULL, 0x000fc800078e001cULL, 0x00000010271e7825ULL, 0x000fc800078e001eULL,
0x0000001027207825ULL, 0x000fc800078e0020ULL, 0x0000001027227825ULL, 0x000fc800078e0022ULL,
0x0000001027247825ULL, 0x000fc800078e0024ULL, 0x00000010260b7824ULL, 0x100fe400078e0267ULL,
0x0000001028277824ULL, 0x100fe400078e0267ULL, 0x000000102c2b7824ULL, 0x100fe200078e0267ULL,
0x00000000140b7faeULL, 0x0003e2000c101c46ULL, 0x000000102e2d7824ULL, 0x100fe400078e0267ULL,
0x00000010302f7824ULL, 0x100fe200078e0267ULL, 0x0000000016277faeULL, 0x0003e2000c901c46ULL,
0x0000001032677824ULL, 0x000fc600078e0267ULL, 0x000000001c297faeULL, 0x0003e8000d101c46ULL,
0x000000001e2b7faeULL, 0x0003e8000d901c46ULL, 0x00000000202d7faeULL, 0x0003e8000e101c46ULL,
0x00000000222f7faeULL, 0x0003e8000e901c46ULL, 0x0000000024677faeULL, 0x0003e2000f101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x00000003ff157819ULL, 0x000fe20000011600ULL,
0x00000100ff277424ULL, 0x000fe200078e00ffULL, 0x00000003621c7819ULL, 0x000fc400000006ffULL,
0x00000008151f7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c15217810ULL, 0x040fe40007ffe0ffULL,
0x00000004151d7810ULL, 0x000fe20007ffe0ffULL, 0x000000081f257824ULL, 0x040fe200078e00ffULL,
0x000000001f167212ULL, 0x080fe200078e3cffULL, 0x00000008212c7824ULL, 0x040fe200078e00ffULL,
0x0000000021177212ULL, 0x080fe200078e3cffULL, 0x000000081d237824ULL, 0x040fe200078e00ffULL,
0x000000001d147212ULL, 0x000fe200078e3cffULL, 0x000000011f1e7824ULL, 0x000fe200078e0224ULL,
0xfffffff8252a7812ULL, 0x000fe200078ee216ULL, 0x0000000121207824ULL, 0x000fe200078e0224ULL,
0xfffffff82c2c7812ULL, 0x000fc400078ee217ULL, 0xfffffff823287812ULL, 0x000fe400078ee214ULL,
0x0000000715177812ULL, 0x040fe400078e4800ULL, 0x0000001415257810ULL, 0x040fe40007ffe0ffULL,
0x0000001015237810ULL, 0x040fe40007ffe0ffULL, 0x0000001c152b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000825307824ULL, 0x000fe200078e00ffULL, 0x0000001815297810ULL, 0x000fe20007ffe0ffULL,
0x0000000123227824ULL, 0x100fe200078e0224ULL, 0xfffffff81c0b7812ULL, 0x000fe200078ee20bULL,
0x000000011d1c7824ULL, 0x000fe200078e0224ULL, 0x0ffffff817167812ULL, 0x000fe200078ef800ULL,
0x000000082b587824ULL, 0x000fe200078e00ffULL, 0x0000000023177212ULL, 0x000fe200078e3cffULL,
0x0000000129327824ULL, 0x100fe200078e0224ULL, 0x00000003232e7819ULL, 0x000fe200000006ffULL,
0x0000000125267824ULL, 0x100fe200078e0224ULL, 0x0000002415147210ULL, 0x000fe20007ffe0ffULL,
0x000000012b527824ULL, 0x000fe200078e0224ULL, 0x00000000251d7212ULL, 0x080fe200078e3cffULL,
0x00005e0032247625ULL, 0x000fe200078e0027ULL, 0x00000000291f7212ULL, 0x000fc400078e3cffULL,
0x0000000329507819ULL, 0x000fe200000006ffULL, 0x0000001016297824ULL, 0x000fe200078e0267ULL,
0x000000002b217212ULL, 0x000fe200078e3cffULL, 0x00005e0014147625ULL, 0x080fe200078e0027ULL,
0xfffffff82e2e7812ULL, 0x000fe400078ee217ULL, 0xfffffff830307812ULL, 0x000fe200078ee21dULL,
0x00005e001c167625ULL, 0x080fe200078e0027ULL, 0xfffffff850507812ULL, 0x000fe400078ee21fULL,
0xfffffff858587812ULL, 0x000fe200078ee221ULL, 0x00005e001e1c7625ULL, 0x000fc800078e0027ULL,
0x00005e00201e7625ULL, 0x000fc800078e0027ULL, 0x00005e0022207625ULL, 0x000fc800078e0027ULL,
0x00005e0026227625ULL, 0x000fc800078e0027ULL, 0x00005e0052267625ULL, 0x000fc800078e0027ULL,
0x000000100b147825ULL, 0x000fc800078e0014ULL, 0x000000100b167825ULL, 0x040fe200078e0016ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014297faeULL, 0x0003e6000b901c46ULL,
0x000000100b1c7825ULL, 0x000fc800078e001cULL, 0x000000100b1e7825ULL, 0x000fc800078e001eULL,
0x000000100b207825ULL, 0x000fe200078e0020ULL, 0x000000672c297211ULL, 0x002fc600078e20ffULL,
0x000000100b227825ULL, 0x000fc800078e0022ULL, 0x000000100b247825ULL, 0x000fc800078e0024ULL,
0x000000100b267825ULL, 0x000fc800078e0026ULL, 0x00000010280b7824ULL, 0x100fe400078e0267ULL,
0x000000102a157824ULL, 0x100fe400078e0267ULL, 0x000000102e2b7824ULL, 0x100fe200078e0267ULL,
0x00000000160b7faeULL, 0x0003e2000b901c46ULL, 0x00000010302d7824ULL, 0x100fe400078e0267ULL,
0x00000010502f7824ULL, 0x100fe200078e0267ULL, 0x000000001c157faeULL, 0x0003e2000b901c46ULL,
0x0000001058677824ULL, 0x000fc600078e0267ULL, 0x000000001e297faeULL, 0x0003e8000b901c46ULL,
0x00000000202b7faeULL, 0x0003e8000b901c46ULL, 0x00000000222d7faeULL, 0x0003e8000b901c46ULL,
0x00000000242f7faeULL, 0x0003e8000b901c46ULL, 0x0000000026677faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6680005147f8cULL, 0x002fe8000c80043fULL, 0x01b66c00050b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fc40007804815ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000000b7802ULL, 0x000fc80000000f00ULL, 0x0000000b00167305ULL, 0x0002a4000021f000ULL,
0x3fa000000b0b7823ULL, 0x002fe200000100ffULL, 0x000000160000735dULL, 0x004fe20003800000ULL,
0x01b66c0005177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018006077810ULL, 0x000fca0007ffe007ULL,
0x0000000108077824ULL, 0x000fca00078e0207ULL, 0x01b0000007167984ULL, 0x000e680000000800ULL,
0x01b2000007057984ULL, 0x0004e20000000800ULL, 0x000000551600720bULL, 0x002fe20003f1d000ULL,
0x0000af027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000077806ULL, 0x004fc800000e0100ULL,
0x0000ffff070b7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff077424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000365147811ULL, 0x000fe400078ff0ffULL, 0x000000551600720bULL, 0x000fe40003f34000ULL,
0x000000651400720cULL, 0x000fe20003f05270ULL, 0x0000aed27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000077806ULL, 0x000fe400008e0100ULL, 0x0000001655177209ULL, 0x000fe20007810000ULL,
0x0000008065158824ULL, 0x000fe200078e0206ULL, 0x00000002ff257819ULL, 0x000fc60000011600ULL,
0x8000001755067221ULL, 0x000fe40000010000ULL, 0x0000000108148824ULL, 0x000fe200078e0215ULL,
0x0000ffff07087812ULL, 0x000fe200078e3cffULL, 0x3fb8aa3b06067820ULL, 0x000fc60000410000ULL,
0x01b4001714008388ULL, 0x0003e20000000800ULL, 0x0000000600247308ULL, 0x000ea20000000800ULL,
0x000000080bff7212ULL, 0x000fe2000780c0ffULL, 0x0000002454547220ULL, 0x004fe20000410000ULL,
0x0000ae627f007947ULL, 0x000ff2000b800000ULL, 0x00001f2524067589ULL, 0x0022a400000e0000ULL,
0x000000064c4c7220ULL, 0x084fe40000410000ULL, 0x000000064d4d7220ULL, 0x080fe40000410000ULL,
0x0000000648487220ULL, 0x080fe40000410000ULL, 0x0000000649497220ULL, 0x000fc40000410000ULL,
0x0000000644447220ULL, 0x080fe40000410000ULL, 0x0000000645457220ULL, 0x080fe40000410000ULL,
0x0000000640407220ULL, 0x080fe40000410000ULL, 0x0000000641417220ULL, 0x080fe40000410000ULL,
0x000000063c3c7220ULL, 0x080fe40000410000ULL, 0x000000063d3d7220ULL, 0x000fc40000410000ULL,
0x0000000638387220ULL, 0x080fe40000410000ULL, 0x0000000639397220ULL, 0x080fe40000410000ULL,
0x0000000634347220ULL, 0x080fe40000410000ULL, 0x0000000635357220ULL, 0x080fe40000410000ULL,
0x0000000618187220ULL, 0x080fe40000410000ULL, 0x0000000619197220ULL, 0x000fe20000410000ULL,
0x0000ada27f007947ULL, 0x000fea000b800000ULL, 0x00001f0a24067589ULL, 0x00052400000e0000ULL,
0x8000001716160221ULL, 0x000fe20000010000ULL, 0x00000001ff077807ULL, 0x000fe20000000000ULL,
0x000000064e4e7220ULL, 0x010fc40000410000ULL, 0x3fb8aa3b16160820ULL, 0x000fe40000410000ULL,
0x000000064f4f7220ULL, 0x080fe40000410000ULL, 0x0000001600090308ULL, 0x000f220000000800ULL,
0x000000064a4a7220ULL, 0x080fe40000410000ULL, 0x000000064b4b7220ULL, 0x080fe40000410000ULL,
0x0000000646467220ULL, 0x080fe40000410000ULL, 0x0000000647477220ULL, 0x000fc40000410000ULL,
0x0000000642427220ULL, 0x080fe40000410000ULL, 0x0000000643437220ULL, 0x080fe40000410000ULL,
0x000000063e3e7220ULL, 0x080fe40000410000ULL, 0x000000063f3f7220ULL, 0x080fe40000410000ULL,
0x000000063a3a7220ULL, 0x080fe40000410000ULL, 0x000000063b3b7220ULL, 0x000fc40000410000ULL,
0x0000000636367220ULL, 0x080fe40000410000ULL, 0x0000000637377220ULL, 0x080fe40000410000ULL,
0x000000061a1a7220ULL, 0x080fe40000410000ULL, 0x000000061b1b7220ULL, 0x000fe40000410000ULL,
0x000000ffff557224ULL, 0x000fe400078e0017ULL, 0x0000000509050220ULL, 0x018fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000009ff0b723eULL, 0x000fe200000000ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff257819ULL, 0x002fe40000011600ULL,
0x0000001000067811ULL, 0x000fe400078ff0ffULL, 0x0000001825087810ULL, 0x000fe40007ffe0ffULL,
0x000054100b247816ULL, 0x004fe2000000000bULL, 0x0000ac227f007947ULL, 0x000fea000b800000ULL,
0x00001f25240b7589ULL, 0x0002a800000e0000ULL, 0x00001f0a240a7589ULL, 0x00032400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff257224ULL, 0x002fe200078e0006ULL,
0x0000001f00267802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x000068a000147802ULL, 0x000fc40000000f00ULL, 0x0000b36000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff257224ULL, 0x002fe200078e0008ULL,
0x0000690000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff267424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fe400078e00ffULL, 0x0000b30000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000005405547221ULL, 0x008fe40000010000ULL,
0x012800000c14783bULL, 0x000ee20000000200ULL, 0x000000680d1c7211ULL, 0x080fe200078e20ffULL,
0x000000100e207824ULL, 0x100fe200078e0268ULL, 0x0000991007057816ULL, 0x000fe200000000ffULL,
0x000000100f287824ULL, 0x100fe200078e0268ULL, 0x0000006813507211ULL, 0x000fe200078e20ffULL,
0x0000001010247824ULL, 0x102fe200078e0268ULL, 0x000000001c1c783bULL, 0x000e620000004200ULL,
0x0000001012587824ULL, 0x100fe200078e0268ULL, 0x000000ff0500720cULL, 0x000fe20003f05270ULL,
0x00000010032c7824ULL, 0x100fe200078e0268ULL, 0x000000002020783bULL, 0x004fe20000004200ULL,
0x0000001002307824ULL, 0x000fc600078e0268ULL, 0x000000002828783bULL, 0x000fe80000004200ULL,
0x000000002424783bULL, 0x000fe80000004200ULL, 0x01280000110c783bULL, 0x000ea80000000200ULL,
0x000000005858783bULL, 0x000f680000004200ULL, 0x000000005050783bULL, 0x000f280000004200ULL,
0x000000003030783bULL, 0x000f280000004200ULL, 0x000000002c2c783bULL, 0x000f220000004200ULL,
0x0000000b14148232ULL, 0x008fc40000000000ULL, 0x0000000b16168232ULL, 0x000fe40000000000ULL,
0x0000000a15158232ULL, 0x090fe40000000000ULL, 0x0000000a17178232ULL, 0x000fce0000000000ULL,
0x0000001c144c723cULL, 0x042ff0000000184cULL, 0x0000001e1448723cULL, 0x000fe20000001848ULL,
0x0000000b0c0c8232ULL, 0x084fe40000000000ULL, 0x0000000b0e0e8232ULL, 0x000fc40000000000ULL,
0x0000000a0d0d8232ULL, 0x000fc60000000000ULL, 0x000000201444723cULL, 0x000fe20000001844ULL,
0x0000000a0f0f8232ULL, 0x000fce0000000000ULL, 0x000000221440723cULL, 0x040ff00000001840ULL,
0x00000028143c723cULL, 0x040ff0000000183cULL, 0x0000002a1438723cULL, 0x040ff00000001838ULL,
0x000000241434723cULL, 0x040ff00000001834ULL, 0x000000261418723cULL, 0x000ff00000001818ULL,
0x000000580c4c723cULL, 0x060ff0000000184cULL, 0x0000005a0c48723cULL, 0x040ff00000001848ULL,
0x000000500c44723cULL, 0x040ff00000001844ULL, 0x000000520c40723cULL, 0x040ff00000001840ULL,
0x000000300c3c723cULL, 0x040ff0000000183cULL, 0x000000320c38723cULL, 0x040ff00000001838ULL,
0x0000002c0c34723cULL, 0x040ff00000001834ULL, 0x0000002e0c18723cULL, 0x000fe20000001818ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01b6a0006aff7f8cULL, 0x0003e2000c80043fULL,
0x00000001046c7812ULL, 0x000fce00078ec0ffULL, 0x0000030066667a10ULL, 0x002fc80007ffe0ffULL,
0x000000636600720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffa5a000007947ULL, 0x000fea000383ffffULL, 0x00000000000579c3ULL, 0x000e640000002500ULL,
0x0000000563007c0cULL, 0x002fda000bf03070ULL, 0x0000034000000947ULL, 0x000fea0003800000ULL,
0x0180000054007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x00006d3000047802ULL, 0x000fe40000000f00ULL,
0x0000ad2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000005400037308ULL, 0x000e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000054ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000027919ULL, 0x000ee20000000000ULL,
0x0000000803037811ULL, 0x004fe400078ff0ffULL, 0x00000002ff057819ULL, 0x008fc80000011602ULL,
0x00001f0300037589ULL, 0x000ea800000e0000ULL, 0x00001f0500027589ULL, 0x000ee200000e0000ULL,
0x0000004e034e7220ULL, 0x044fe40000410000ULL, 0x0000004f034f7220ULL, 0x000fe40000410000ULL,
0x0000004c024c7220ULL, 0x048fe40000410000ULL, 0x0000004d024d7220ULL, 0x000fc40000410000ULL,
0x0000004802487220ULL, 0x040fe40000410000ULL, 0x0000004902497220ULL, 0x040fe40000410000ULL,
0x0000004402447220ULL, 0x040fe40000410000ULL, 0x0000004502457220ULL, 0x040fe40000410000ULL,
0x0000004002407220ULL, 0x040fe40000410000ULL, 0x0000004102417220ULL, 0x000fc40000410000ULL,
0x0000003c023c7220ULL, 0x040fe40000410000ULL, 0x0000003d023d7220ULL, 0x040fe40000410000ULL,
0x0000003802387220ULL, 0x040fe40000410000ULL, 0x0000003902397220ULL, 0x040fe40000410000ULL,
0x0000003402347220ULL, 0x040fe40000410000ULL, 0x0000003502357220ULL, 0x000fc40000410000ULL,
0x0000001802187220ULL, 0x040fe40000410000ULL, 0x0000001902197220ULL, 0x000fe40000410000ULL,
0x0000004a034a7220ULL, 0x040fe40000410000ULL, 0x0000004b034b7220ULL, 0x040fe40000410000ULL,
0x0000004603467220ULL, 0x040fe40000410000ULL, 0x0000004703477220ULL, 0x000fc40000410000ULL,
0x0000004203427220ULL, 0x040fe40000410000ULL, 0x0000004303437220ULL, 0x040fe40000410000ULL,
0x0000003e033e7220ULL, 0x040fe40000410000ULL, 0x0000003f033f7220ULL, 0x040fe40000410000ULL,
0x0000003a033a7220ULL, 0x040fe40000410000ULL, 0x0000003b033b7220ULL, 0x000fc40000410000ULL,
0x0000003603367220ULL, 0x040fe40000410000ULL, 0x0000003703377220ULL, 0x040fe40000410000ULL,
0x0000001a031a7220ULL, 0x040fe40000410000ULL, 0x0000001b031b7220ULL, 0x000fe40000410000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x00000018190b723eULL, 0x000fe400000000ffULL,
0x0000001a1b13723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000004c4d04723eULL, 0x000fc400000000ffULL, 0x000000484905723eULL, 0x000fe400000000ffULL,
0x000000444506723eULL, 0x000fe400000000ffULL, 0x000000404107723eULL, 0x000fe400000000ffULL,
0x0000003c3d08723eULL, 0x000fe400000000ffULL, 0x000000383909723eULL, 0x000fe400000000ffULL,
0x00000034350a723eULL, 0x000fc400000000ffULL, 0x0000004e4f0c723eULL, 0x000fe400000000ffULL,
0x0000004a4b0d723eULL, 0x000fe400000000ffULL, 0x00000046470e723eULL, 0x000fe400000000ffULL,
0x00000002ff217819ULL, 0x004fe40000011603ULL, 0x0000000803317811ULL, 0x000fe400078ff0ffULL,
0x0000000721007812ULL, 0x040fe200078ec0ffULL, 0x0000000821027824ULL, 0x040fe200078e00ffULL,
0x00000021ff237212ULL, 0x000fe200078e33ffULL, 0x0000000821147824ULL, 0x000fe200078e00ffULL,
0x00000031ff337212ULL, 0x000fc400078e33ffULL, 0x0000000331167819ULL, 0x000fe400000006ffULL,
0xfffffff802157812ULL, 0x000fe400078ee221ULL, 0x0000000100027812ULL, 0x000fe400078e3cffULL,
0xfffffff814237812ULL, 0x000fe400078ee223ULL, 0xfffffff816337812ULL, 0x000fe200078ee233ULL,
0x0000000821177824ULL, 0x000fe200078e0202ULL, 0x0000000200147812ULL, 0x000fe200078e3cffULL,
0x0000100062027824ULL, 0x000fe200078e00ffULL, 0x0000000300167812ULL, 0x000fc400078e3cffULL,
0x0000000400187812ULL, 0x040fe200078e3cffULL, 0x0000000821197824ULL, 0x040fe200078e0214ULL,
0x00000005001a7812ULL, 0x040fe200078e3cffULL, 0x00000008211b7824ULL, 0x000fe200078e0216ULL,
0x0000000600007812ULL, 0x000fe200078e3cffULL, 0x0000000403147824ULL, 0x000fe200078e00ffULL,
0x00000018211d7211ULL, 0x040fe200078e18ffULL, 0x00000008211f7824ULL, 0x000fe200078e021aULL,
0x0000000331187819ULL, 0x000fe200000006ffULL, 0x0000000821217824ULL, 0x000fe200078e0200ULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x0000080057007824ULL, 0x000fe200078e0202ULL,
0x0000000731167812ULL, 0x000fc400078ec0ffULL, 0xfffffff818257812ULL, 0x000fe200078ee231ULL,
0x0000001015157824ULL, 0x100fe200078e0200ULL, 0x0000000116187812ULL, 0x040fe200078e3cffULL,
0x0000001017177824ULL, 0x000fe200078e0200ULL, 0x00000002161a7812ULL, 0x040fe200078e3cffULL,
0x0000000115157824ULL, 0x000fe200078e0214ULL, 0x00000003161c7812ULL, 0x040fe200078e3cffULL,
0x0000001019197824ULL, 0x100fe200078e0200ULL, 0x00000004161e7812ULL, 0x040fe200078e3cffULL,
0x000000101d1d7824ULL, 0x000fe200078e0200ULL, 0x0000000516207812ULL, 0x040fe200078e3cffULL,
0x0000000415007388ULL, 0x0005e20000000800ULL, 0x0000000616167812ULL, 0x000fe200078e3cffULL,
0x0000000831277824ULL, 0x000fe200078e0218ULL, 0x000000001b1b7211ULL, 0x000fe200078e20ffULL,
0x0000000831297824ULL, 0x040fe200078e021aULL, 0x0000001c312b7211ULL, 0x040fe200078e18ffULL,
0x00000008312d7824ULL, 0x000fe200078e021eULL, 0x0000000023237211ULL, 0x000fe200078e20ffULL,
0x00000008312f7824ULL, 0x000fe200078e0220ULL, 0x00000042430f723eULL, 0x000fe200000000ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0200ULL, 0x0000003e3f10723eULL, 0x000fe200000000ffULL,
0x0000000114047824ULL, 0x044fe200078e0217ULL, 0x000000002f2f7211ULL, 0x000fe200078e20ffULL,
0x0000000831317824ULL, 0x000fe200078e0216ULL, 0x0000001b14167210ULL, 0x040fe20007ffe0ffULL,
0x0000001021217824ULL, 0x100fe200078e0200ULL, 0x0000000504007388ULL, 0x000fe20000000800ULL,
0x0000000114197824ULL, 0x040fe200078e0219ULL, 0x0000003a3b11723eULL, 0x000fe200000000ffULL,
0x0000001025257824ULL, 0x100fe200078e0200ULL, 0x000000363712723eULL, 0x000fe200000000ffULL,
0x00000001141d7824ULL, 0x040fe200078e021dULL, 0x0000000619007388ULL, 0x000fe20000000800ULL,
0x0000001027277824ULL, 0x100fe200078e0200ULL, 0x0000002514257210ULL, 0x040fe20007ffe0ffULL,
0x0000001029297824ULL, 0x100fe200078e0200ULL, 0x0000000716007388ULL, 0x0005e20000000800ULL,
0x0000000114187824ULL, 0x000fe200078e021fULL, 0x0000000356157210ULL, 0x000fe20007ffe0ffULL,
0x0000000114217824ULL, 0x040fe200078e0221ULL, 0x000000081d007388ULL, 0x000fe20000000800ULL,
0x00000001141a7824ULL, 0x040fe200078e0223ULL, 0x0000002914297210ULL, 0x000fe20007ffe0ffULL,
0x000000102b2b7824ULL, 0x100fe200078e0200ULL, 0x0000000918007388ULL, 0x000fe20000000800ULL,
0x000000102d2d7824ULL, 0x000fc400078e0200ULL, 0x00000001141c7824ULL, 0x040fe200078e0227ULL,
0x0000000a21007388ULL, 0x000fe20000000800ULL, 0x0000001031317824ULL, 0x100fe400078e0200ULL,
0x0000001033337824ULL, 0x000fe200078e0200ULL, 0x0000000b1a007388ULL, 0x000fe20000000800ULL,
0x00000001141e7824ULL, 0x040fe400078e022bULL, 0x00000001142d7824ULL, 0x040fe200078e022dULL,
0x0000000c25007388ULL, 0x000fe20000000800ULL, 0x0000000114207824ULL, 0x000fc400078e022fULL,
0x0000000114317824ULL, 0x040fe200078e0231ULL, 0x0000000d1c007388ULL, 0x000fe20000000800ULL,
0x0000000114227824ULL, 0x000fe400078e0233ULL, 0x0000001015077824ULL, 0x004fe200078e0202ULL,
0x0000000e29007388ULL, 0x000fe20000000800ULL, 0x00000001ff047424ULL, 0x000fc600078e00ffULL,
0x0000000f1e007388ULL, 0x000fe40000000800ULL, 0x0000030004007a0cULL, 0x000fe40003f05270ULL,
0x000000102d007388ULL, 0x000fe80000000800ULL, 0x0000001120007388ULL, 0x000fe80000000800ULL,
0x0000001231007388ULL, 0x000fe80000000800ULL, 0x0000001322007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000007087984ULL, 0x000ea80000000c00ULL,
0x0004000007247984ULL, 0x000ee80000000c00ULL, 0x0008000007187984ULL, 0x000f280000000c00ULL,
0x000c000007287984ULL, 0x000f620000000c00ULL, 0x200000ff0b0b7230ULL, 0x004fc40000000000ULL,
0x200000ff0a0a7230ULL, 0x000fe40000000000ULL, 0x200000ff09097230ULL, 0x000fe40000000000ULL,
0x200000ff08087230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x008fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fc40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x0000001b0b0b7230ULL, 0x010fe40000000000ULL,
0x0000001a0a0a7230ULL, 0x000fe40000000000ULL, 0x0000001909097230ULL, 0x000fe40000000000ULL,
0x0000001808087230ULL, 0x000fe40000000000ULL, 0x0000002b27277230ULL, 0x020fc40000000000ULL,
0x0000002a26267230ULL, 0x000fe20000000000ULL, 0x0000000807007388ULL, 0x0005e20000000c00ULL,
0x0000002925257230ULL, 0x000fe40000000000ULL, 0x0000002824247230ULL, 0x000fca0000000000ULL,
0x0004002407007388ULL, 0x0005e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00002f4000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x000ee20000002700ULL,
0x00005800ff047624ULL, 0x000fe200078e00ffULL, 0x0000000157ff7812ULL, 0x000fe2000780f865ULL,
0x00000800ff097424ULL, 0x004fe200078e00ffULL, 0x0000000000057919ULL, 0x000ee20000002600ULL,
0x0000000a62067819ULL, 0x000fc400000006ffULL, 0x000000ff0300720cULL, 0x000fe20000725670ULL,
0x0000000007187984ULL, 0x0005220000000c00ULL, 0x000058000e0e7a24ULL, 0x008fe400078e0205ULL,
0x0000030004057a24ULL, 0x000fe400078e02ffULL, 0x000003000e047a24ULL, 0x000fe400078e02ffULL,
0x00006400050a7a24ULL, 0x000fc600078e02ffULL, 0x0000000504107c10ULL, 0x000fe4000fffe0ffULL,
0x000007ff0a057811ULL, 0x040fe400078e40ffULL, 0x01ffffff0a077812ULL, 0x004fe400078ec0ffULL,
0x0000001005087211ULL, 0x000fca00078fa8ffULL, 0x00006a0008087625ULL, 0x000fca00078e0009ULL,
0x00000006080c7210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fc800010e0609ULL,
0x00000010150c7825ULL, 0x000fe200078e000cULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001003087824ULL, 0x010fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000001100a7824ULL, 0x000fe200078e0207ULL,
0x00000070080f7812ULL, 0x000fe400078ec0ffULL, 0x0000000c09117812ULL, 0x000fe200078ec0ffULL,
0x00006a0010087625ULL, 0x000fc800078e000bULL, 0x00006a000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000811087210ULL, 0x000fc80007a1e00fULL, 0x0000000a110a7210ULL, 0x000fe40007c7e00fULL,
0x00000009ff097210ULL, 0x000fe400007e44ffULL, 0x0000000bff0b7210ULL, 0x000fc60001fe84ffULL,
0x0000005508007986ULL, 0x0005e8000c101906ULL, 0x000000540a007986ULL, 0x0005e4000c101906ULL,
0x000000180c007986ULL, 0x0107e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x00000001000b7802ULL, 0x004fe20000000f00ULL, 0x00000004ff097424ULL, 0x000fc600078e00ffULL,
0x000003000b0b7a10ULL, 0x000fe20007ffe1ffULL, 0x000068000e087625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b080879a8ULL, 0x000ea400099ee1c6ULL, 0x0000000b0800720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0a7807ULL, 0x000fca0000000000ULL,
0x0000000aff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff087984ULL, 0x004ea40000000000ULL,
0x000000ff0800720cULL, 0x004fda0003f05270ULL, 0x00002b9000008947ULL, 0x000fea0003800000ULL,
0x000000ff6500720cULL, 0x000fda0003f05270ULL, 0x00000d6000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000038000008947ULL, 0x000fea0003800000ULL,
0x0000001003087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011603ULL,
0x00000080ff0d7424ULL, 0x008fe200078e00ffULL, 0x00000001040a7810ULL, 0x000fe40007ffe0ffULL,
0x0000007008177812ULL, 0x000fe400078ec0ffULL, 0x0000000c090e7812ULL, 0x000fe200078ec0ffULL,
0x00006a0004087625ULL, 0x000fc800078e000dULL, 0x00006a000a0a7625ULL, 0x000fe200078e000dULL,
0x000000080e087210ULL, 0x000fc8000791e017ULL, 0x0000000a0e0a7210ULL, 0x000fe40007b5e017ULL,
0x00000009ff097210ULL, 0x000fe400007e24ffULL, 0x0000000bff0b7210ULL, 0x000fc600017e64ffULL,
0x0000000608087981ULL, 0x000568000c1e1900ULL, 0x000000060a0f7981ULL, 0x000562000c1e1900ULL,
0x00000300ff0c7624ULL, 0x000fca00078e00ffULL, 0x000000020c00780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002040a7810ULL, 0x004fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e000dULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a097981ULL, 0x000562000c1e1900ULL,
0x000000040c00780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003040a7810ULL, 0x004fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a117981ULL, 0x000562000c1e1900ULL, 0x000000040c00780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004040a7810ULL, 0x004fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e000dULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a137981ULL, 0x000562000c1e1900ULL,
0x000000060c00780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005040a7810ULL, 0x004fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a157981ULL, 0x000562000c1e1900ULL, 0x000000060c00780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000080c00780cULL, 0x004fe40003f06070ULL,
0x00000006040a7810ULL, 0x000fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a0e0a7210ULL, 0x000fe40007a3e017ULL, 0x00000007040c0810ULL, 0x000fe40007ffe0ffULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x00006a000c0c0625ULL, 0x000fca00078e000dULL,
0x0000000c0e0c0210ULL, 0x000fe40007c7e017ULL, 0x000000060a177981ULL, 0x000564000c1e1900ULL,
0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL, 0x000000060c190981ULL, 0x000568000c1e1900ULL,
0x0000030000047ab9ULL, 0x004fe40000000800ULL, 0x0000000704047890ULL, 0x000fc8000fffe03fULL,
0x000000033f047899ULL, 0x000fcc0008011604ULL, 0x00000004ff007c0cULL, 0x000fda000bf05270ULL,
0x0000090000008947ULL, 0x000fea0003800000ULL, 0x000000ff00127202ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x008fe400078e0004ULL, 0x000000ffff0d7224ULL, 0x020fe400078e0008ULL,
0x000000ffff147224ULL, 0x000fc600078e00ffULL, 0x0000030012007a0cULL, 0x000fe40003f26070ULL,
0x0000000114147810ULL, 0x000fc80007ffe0ffULL, 0x0000000414007c0cULL, 0x000fce000bf06070ULL,
0x0000085000001947ULL, 0x024fea0003800000ULL, 0x00000008120a7810ULL, 0x040fe40007ffe0ffULL,
0x00000001120b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000d08087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x000000080c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000004030d7819ULL, 0x000fe400000006ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00006a000a0a7625ULL, 0x000fe200078e000bULL,
0x000000700d0d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fc80007b3e00dULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a0d7981ULL, 0x000568000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x00000009120a7810ULL, 0x044fe40007ffe0ffULL, 0x00000002120b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000000f08087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x000000090c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000010030e7824ULL, 0x000fe400078e00ffULL,
0x00006a000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c10107812ULL, 0x000fe400078ec0ffULL,
0x000000700e0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a0f7981ULL, 0x000568000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a120a7810ULL, 0x044fe40007ffe0ffULL,
0x00000003120b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000908087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000a0c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x0000001003097824ULL, 0x000fe400078e00ffULL, 0x00006a000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x0000007009097812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fc80007b3e009ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a097981ULL, 0x000568000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b120a7810ULL, 0x044fe40007ffe0ffULL, 0x00000004120b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001108087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000b0c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x00000080000b7802ULL, 0x000fe40000000f00ULL, 0x00000001ff107819ULL, 0x000fe40000011603ULL,
0x000000700e117812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c10107812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a117981ULL, 0x000568000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c120a7810ULL, 0x044fe40007ffe0ffULL,
0x00000005120b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001308087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000c0c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000010030e7824ULL, 0x000fe400078e00ffULL, 0x00006a000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c10107812ULL, 0x000fe400078ec0ffULL, 0x000000700e137812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e013ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a137981ULL, 0x000568000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d120a7810ULL, 0x044fe40007ffe0ffULL, 0x00000006120b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001508087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000d0c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000004030e7819ULL, 0x000fe400000006ffULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00006a000a0a7625ULL, 0x000fe200078e000bULL, 0x000000700e157812ULL, 0x000fe400078ec0ffULL,
0x0000000c10107812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e015ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a157981ULL, 0x000568000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e120a7810ULL, 0x044fe40007ffe0ffULL,
0x00000007120b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001708087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000e0c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000010030e7824ULL, 0x000fe400078e00ffULL, 0x00006a000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c10107812ULL, 0x000fe400078ec0ffULL, 0x000000700e177812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e017ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a177981ULL, 0x000568000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f120a7810ULL, 0x004fe40007ffe0ffULL, 0x0000001908087209ULL, 0x000fe40007810000ULL,
0x000003000a007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000f0c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000010030e7824ULL, 0x000fe400078e00ffULL,
0x00006a000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c10107812ULL, 0x000fe400078ec0ffULL,
0x000000700e197812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007a3e019ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL, 0x000000060a197981ULL, 0x000568000c1e1900ULL,
0x0000000812127810ULL, 0x000fe40007ffe0ffULL, 0x000000080c0c7810ULL, 0x000fe20007ffe0ffULL,
0xfffff74000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000f240000000000ULL,
0x0000000403097819ULL, 0x030fe400000006ffULL, 0x00000001ff0a7819ULL, 0x004fe40000011603ULL,
0x0000007009097812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fca00078ec0ffULL,
0x0000000109097824ULL, 0x000fca00078e020aULL, 0x0000000809007388ULL, 0x0005e40000000800ULL,
0x0000000157107824ULL, 0x000fe200078e0204ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x0000001003097824ULL, 0x004fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011603ULL,
0x00000800ff0d7424ULL, 0x008fe200078e00ffULL, 0x0000001005087211ULL, 0x000fe200078fa8ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000070090a7812ULL, 0x000fe200078ec0ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fe200078e000dULL, 0x00000002ff0c7819ULL, 0x000fe20000011665ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000b0a187210ULL, 0x000fe20007ffe0ffULL,
0x0000000257128824ULL, 0x140fe200078e0262ULL, 0x000000010c0b7812ULL, 0x000fe200078ec0ffULL,
0x00000002570c8824ULL, 0x000fe200078e0262ULL, 0x00000006080a7210ULL, 0x000fe20007f3e0ffULL,
0x0000020065657824ULL, 0x000fe200078e00ffULL, 0x0000008000118802ULL, 0x000fe20000000f00ULL,
0x0000000212128824ULL, 0x000fe200078e020bULL, 0x0000000b0c168211ULL, 0x000fe200078e08ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e0609ULL, 0x0000080065097812ULL, 0x000fe200078ec0ffULL,
0x0000200057087824ULL, 0x000fe200078e0202ULL, 0x0000002003137810ULL, 0x000fe20007ffe0ffULL,
0x00000001070c8824ULL, 0x000fe200078e0210ULL, 0x0000030057007a0cULL, 0x000fe20003f26070ULL,
0x00000080ff0d8424ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000001080e7824ULL, 0x000fe200078e0209ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00006a000c0c8625ULL, 0x000fe200078e000dULL, 0x0000000018097984ULL, 0x0004e20000000800ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00006a0010108625ULL, 0x000fe200078e0011ULL, 0x000000ff002a7202ULL, 0x000fc60000000f00ULL,
0x00000008121b8824ULL, 0x100fe400078e0203ULL, 0x00000008161d8824ULL, 0x000fe400078e0203ULL,
0x0000001003197824ULL, 0x000fe200078e020eULL, 0x000045801b1b8811ULL, 0x000fe200078e20ffULL,
0x00000010030e7825ULL, 0x000fe200078e000aULL, 0x000041801d1d8811ULL, 0x000fc600078e20ffULL,
0x0000001013127825ULL, 0x000fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000e197faeULL, 0x0009e2000b901c46ULL, 0x00000000000a7805ULL, 0x000fe4000001ff00ULL,
0x0000001003148825ULL, 0x040fe200078e000cULL, 0x0038000012197faeULL, 0x000be2000b901c46ULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x0000001003168825ULL, 0x000fe200078e0010ULL,
0x00000000141b8faeULL, 0x0003e2000b901c46ULL, 0x0000000000107805ULL, 0x000fc6000001ff00ULL,
0x00000000161d8faeULL, 0x0007e2000b901c46ULL, 0x00000000000e7805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000127805ULL, 0x020fe2000001ff00ULL,
0x0000000000187805ULL, 0x004fe2000001ff00ULL, 0x0000000000147805ULL, 0x002fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x008fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000d4000001947ULL, 0x000fea0003800000ULL,
0x000000ffff0a7224ULL, 0x000fe400078e00ffULL, 0x000000ffff347224ULL, 0x000fca00078e0057ULL,
0x00000002342b7810ULL, 0x000fc80007ffe0ffULL, 0x000003002b007a0cULL, 0x000fda0003f06070ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x000000070300780cULL, 0x000fe20003f24070ULL,
0x0000000104327824ULL, 0x100fe200078e022bULL, 0x00000001ff2c7819ULL, 0x000fe2000001162bULL,
0x00000800ff367424ULL, 0x000fe200078e00ffULL, 0x0000000a2b2e7819ULL, 0x000fe400000006ffULL,
0x00000032052d7211ULL, 0x000fe400078fa8ffULL, 0x000000012c307812ULL, 0x000fe400078ec0ffULL,
0x0000002003377810ULL, 0x000fe20007ffe0ffULL, 0x00006a002d2c7625ULL, 0x000fc800078e0036ULL,
0x0000000257319824ULL, 0x140fe200078e0262ULL, 0x000000062c2c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000257339824ULL, 0x000fe400078e0262ULL, 0x00000001072f9824ULL, 0x000fe200078e0232ULL,
0x0000003031369211ULL, 0x000fe200078e08ffULL, 0x00000080ff389424ULL, 0x000fe200078e00ffULL,
0x000008002e317812ULL, 0x000fe200078ec0ffULL, 0x00000002333a9824ULL, 0x000fe400078e0230ULL,
0x00006a002f2e9625ULL, 0x000fc800078e0038ULL, 0x0000000108307824ULL, 0x000fe400078e0231ULL,
0x00000080ff339424ULL, 0x000fe400078e00ffULL, 0x000000ffff2d7224ULL, 0x000fe200000e062dULL,
0x0000003003357211ULL, 0x000fe200078e20ffULL, 0x00006a0032329625ULL, 0x000fc800078e0033ULL,
0x0000000836369824ULL, 0x000fe400078e0203ULL, 0x0000001003309825ULL, 0x000fc800078e002eULL,
0x000000083a399824ULL, 0x000fe400078e0203ULL, 0x00000010372e7825ULL, 0x100fe200078e002cULL,
0x0000458036379811ULL, 0x000fe400078e20ffULL, 0x0000418039399811ULL, 0x000fe200078e20ffULL,
0x00000010032c7825ULL, 0x000fc800078e002cULL, 0x0000001003329825ULL, 0x000fe200078e0032ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800002c357faeULL, 0x0003e8000b901c46ULL,
0x003800002e357faeULL, 0x0003e8000b901c46ULL, 0x0000000030379faeULL, 0x0003e8000b901c46ULL,
0x0000000032399faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff317224ULL, 0x002fe200078e0034ULL, 0x00000062572f7211ULL, 0x000fe200078e08ffULL,
0x00000010032d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff2e7819ULL, 0x100fe20000011603ULL,
0x00000040312c7824ULL, 0x000fe200078e00ffULL, 0x00000002ff4c7819ULL, 0x000fc40000011603ULL,
0x000000702d2d7812ULL, 0x000fe400078ec0ffULL, 0x000000802c2c7812ULL, 0x000fe200078ec0ffULL,
0x000000084c357824ULL, 0x000fe200078e00ffULL, 0x0000000c2e2e7812ULL, 0x000fe200078ec0ffULL,
0x000000084c337824ULL, 0x040fe200078e00ffULL, 0x000000074c3a7812ULL, 0x040fe200078ec0ffULL,
0x000001002f2c7824ULL, 0x000fe200078e002cULL, 0x000000084c507810ULL, 0x000fc80007ffe0ffULL,
0x0000002c2e2f7210ULL, 0x000fe40007ffe02dULL, 0x000000034c2d7819ULL, 0x000fe200000006ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180002f387984ULL, 0x000e620000000800ULL,
0x000000012d2e7812ULL, 0x140fe400078ef63aULL, 0x000000022d307812ULL, 0x140fe200078ef63aULL,
0x004580002f4a7984ULL, 0x0002a20000000800ULL, 0x000000032d327812ULL, 0x140fe400078ef63aULL,
0x000000042d347812ULL, 0x140fe400078ef63aULL, 0x000000052d367812ULL, 0x000fe400078ef63aULL,
0x0000004cff2c7212ULL, 0x000fc400078e33ffULL, 0x00000050ff487212ULL, 0x000fe400078e33ffULL,
0xfffffff8354e7812ULL, 0x000fe200078ee22cULL, 0x0000000403357824ULL, 0x000fe200078e00ffULL,
0xfffffff8332c7812ULL, 0x000fe200078ee23aULL, 0x0000000850337824ULL, 0x040fe200078e00ffULL,
0x00000003503c7819ULL, 0x040fe400000006ffULL, 0x0000000c35357812ULL, 0x000fe400078ec0ffULL,
0xfffffff833487812ULL, 0x000fe200078ee248ULL, 0x00000038092f7221ULL, 0x002fe20000010100ULL,
0x000000062d387812ULL, 0x000fe200078ef63aULL, 0x00000400312d7824ULL, 0x000fe200078e00ffULL,
0x0000000750317812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b2f2f7820ULL, 0x000fc40000410000ULL,
0x00000008503a7824ULL, 0x000fe200078e00ffULL, 0x000008002d2d7812ULL, 0x000fe200078ec0ffULL,
0x0000002f00337308ULL, 0x000ea20000000800ULL, 0x000000013c3e7812ULL, 0x000fe400078ef631ULL,
0x00000180082d7810ULL, 0x000fe40007ffe02dULL, 0xfffffff83a3a7812ULL, 0x000fe400078ee231ULL,
0x0000002d2e2e7211ULL, 0x080fe200078e20ffULL, 0x000000102c2c7824ULL, 0x000fe200078e022dULL,
0x000000023c407812ULL, 0x000fe200078ef631ULL, 0x0000001032327824ULL, 0x000fe200078e022dULL,
0x0000002e352e7210ULL, 0x040fe20007ffe0ffULL, 0x00000001352c7824ULL, 0x040fe200078e022cULL,
0x000000033c427812ULL, 0x140fe200078ef631ULL, 0x0000000135327824ULL, 0x040fe200078e0232ULL,
0x000000043c447812ULL, 0x000fe200078ef631ULL, 0x0000001036367824ULL, 0x100fe200078e022dULL,
0x000000002e2e7984ULL, 0x000fe20000000800ULL, 0x0000001034347824ULL, 0x000fe200078e022dULL,
0x000000053c467812ULL, 0x000fe200078ef631ULL, 0x0000000135367824ULL, 0x000fe200078e0236ULL,
0x000000002c2c7984ULL, 0x000e620000000800ULL, 0x0000001038387824ULL, 0x000fe200078e022dULL,
0x000000063c3c7812ULL, 0x000fe200078ef631ULL, 0x0000004a33337220ULL, 0x004fe20000410000ULL,
0x0000000032327984ULL, 0x000fe20000000800ULL, 0x0000000135347824ULL, 0x040fe200078e0234ULL,
0x0000002d40407211ULL, 0x080fe200078e20ffULL, 0x0000000135387824ULL, 0x040fe200078e0238ULL,
0x0000000036367984ULL, 0x000fe20000000800ULL, 0x000000103a3a7824ULL, 0x100fe200078e022dULL,
0x0000002d3c3c7211ULL, 0x000fe200078e20ffULL, 0x000000103e3e7824ULL, 0x100fe200078e022dULL,
0x00001f4c33317589ULL, 0x000ea200000e0000ULL, 0x0000001042427824ULL, 0x000fe200078e022dULL,
0x0000003a353a7210ULL, 0x040fe20007ffe0ffULL, 0x00000001353e7824ULL, 0x040fe200078e023eULL,
0x0000000034347984ULL, 0x000ee20000000800ULL, 0x0000000135407824ULL, 0x000fc400078e0240ULL,
0x0000000135427824ULL, 0x040fe200078e0242ULL, 0x0000000038387984ULL, 0x000fe20000000800ULL,
0x0000001046467824ULL, 0x100fe400078e022dULL, 0x0000001044447824ULL, 0x100fe200078e022dULL,
0x000000003a3a7984ULL, 0x000f220000000800ULL, 0x000000104e2f7824ULL, 0x100fe200078e022dULL,
0x0000004635467210ULL, 0x040fe20007ffe0ffULL, 0x0000000135447824ULL, 0x000fe200078e0244ULL,
0x000000003e3e7984ULL, 0x000f620000000800ULL, 0x0000001030307824ULL, 0x000fc400078e022dULL,
0x0000001048487824ULL, 0x000fe200078e022dULL, 0x0000000040407984ULL, 0x000fe20000000800ULL,
0x00000001352f7824ULL, 0x040fe400078e022fULL, 0x0000000135307824ULL, 0x040fe200078e0230ULL,
0x0000000042427984ULL, 0x000fe20000000800ULL, 0x00000001353c7824ULL, 0x040fe400078e023cULL,
0x0000000135487824ULL, 0x000fe200078e0248ULL, 0x2000002cff4a7230ULL, 0x102fe20000004100ULL,
0x0000000044447984ULL, 0x000fe20000000800ULL, 0x3000002cff2c7230ULL, 0x000fe20000004100ULL,
0x0000002a332a7221ULL, 0x000fc40000010000ULL, 0x0000000046467984ULL, 0x000fe20000000800ULL,
0x000000314a297223ULL, 0x084fe40000010029ULL, 0x000000312c287223ULL, 0x000fe20000010028ULL,
0x2000002eff2c7230ULL, 0x100fe20000004100ULL, 0x000000002f2f7984ULL, 0x000fe20000000800ULL,
0x3000002eff2e7230ULL, 0x000fc60000004100ULL, 0x0000000030307984ULL, 0x000fe20000000800ULL,
0x000000312c257223ULL, 0x080fe20000010025ULL, 0x20000032ff2c7230ULL, 0x000fe20000004100ULL,
0x000000312e247223ULL, 0x080fe20000010024ULL, 0x000000003c3c7984ULL, 0x000fe20000000800ULL,
0x20000034ff2e7230ULL, 0x008fe40000004100ULL, 0x000000312c1d7223ULL, 0x080fe2000001001dULL,
0x0000000048487984ULL, 0x000fe20000000800ULL, 0x20000036ff2c7230ULL, 0x000fe20000004100ULL,
0x000000312e197223ULL, 0x080fe20000010019ULL, 0x30000034ff347230ULL, 0x000fe20000004100ULL,
0x00001f50332d7589ULL, 0x000e6200000e0000ULL, 0x2000003aff2e7230ULL, 0x010fe20000004100ULL,
0x000000312c157223ULL, 0x080fe20000010015ULL, 0x20000038ff2c7230ULL, 0x000fe20000004100ULL,
0x0000003134187223ULL, 0x080fe20000010018ULL, 0x30000032ff327230ULL, 0x000fe20000004100ULL,
0x000000ffff347224ULL, 0x000fe200078e002bULL, 0x30000036ff367230ULL, 0x000fe20000004100ULL,
0x000000312c117223ULL, 0x080fe20000010011ULL, 0x2000003eff2c7230ULL, 0x020fe20000004100ULL,
0x00000031321c7223ULL, 0x080fe2000001001cULL, 0x0000030034007a0cULL, 0x000fe20003f06070ULL,
0x30000038ff387230ULL, 0x000fe20000004100ULL, 0x0000003136147223ULL, 0x000fe20000010014ULL,
0x3000003aff3a7230ULL, 0x000fc40000004100ULL, 0x3000003eff3e7230ULL, 0x000fe20000004100ULL,
0x0000003138107223ULL, 0x000fe40000010010ULL, 0x0000002d2e277223ULL, 0x082fe20000010027ULL,
0x20000040ff2e7230ULL, 0x000fe20000004100ULL, 0x0000002d2c237223ULL, 0x080fe20000010023ULL,
0x20000042ff2c7230ULL, 0x000fe20000004100ULL, 0x0000002d3a267223ULL, 0x080fe20000010026ULL,
0x2000002fff4c7230ULL, 0x100fe20000004100ULL, 0x0000002d2e1f7223ULL, 0x080fe2000001001fULL,
0x20000046ff2e7230ULL, 0x000fe20000004100ULL, 0x0000002d2c1b7223ULL, 0x000fe2000001001bULL,
0x20000044ff2c7230ULL, 0x000fe20000004100ULL, 0x000000314c0d7223ULL, 0x000fe2000001000dULL,
0x20000030ff4a7230ULL, 0x000fe20000004100ULL, 0x0000002d2e137223ULL, 0x080fe20000010013ULL,
0x20000048ff2e7230ULL, 0x000fe20000004100ULL, 0x0000002d2c177223ULL, 0x000fe20000010017ULL,
0x2000003cff2c7230ULL, 0x000fe20000004100ULL, 0x000000314a217223ULL, 0x000fe20000010021ULL,
0x3000002fff2f7230ULL, 0x000fe20000004100ULL, 0x0000002d3e227223ULL, 0x080fe20000010022ULL,
0x30000030ff307230ULL, 0x000fe20000004100ULL, 0x0000002d2c0f7223ULL, 0x000fe2000001000fULL,
0x30000040ff407230ULL, 0x000fe20000004100ULL, 0x000000312f0c7223ULL, 0x080fe2000001000cULL,
0x30000042ff427230ULL, 0x000fe20000004100ULL, 0x0000003130207223ULL, 0x000fe20000010020ULL,
0x30000044ff447230ULL, 0x000fe20000004100ULL, 0x0000002d401e7223ULL, 0x080fe2000001001eULL,
0x30000046ff467230ULL, 0x000fe20000004100ULL, 0x0000002d421a7223ULL, 0x080fe2000001001aULL,
0x3000003cff3c7230ULL, 0x000fe20000004100ULL, 0x0000002d44167223ULL, 0x080fe20000010016ULL,
0x30000048ff487230ULL, 0x000fe20000004100ULL, 0x0000002d46127223ULL, 0x000fc40000010012ULL,
0x0000002d3c0e7223ULL, 0x080fe4000001000eULL, 0x0000002d2e0b7223ULL, 0x080fe4000001000bULL,
0x0000002d480a7223ULL, 0x000fe2000001000aULL, 0xfffff2e000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x000000ff6200720cULL, 0x000fe20003f05270ULL,
0x0000001003047824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011603ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000304057210ULL, 0x000fe20007ffe0ffULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000001003047824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011603ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c03067812ULL, 0x000fc600078ec0ffULL, 0x0000008057037824ULL, 0x000fc800078e0204ULL,
0x0000000106037824ULL, 0x000fca00078e0203ULL, 0x0049802a03007388ULL, 0x0003e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0049800005037984ULL, 0x002e680000000800ULL, 0x004a000005047984ULL, 0x000ea20000000800ULL,
0x00000003ff037221ULL, 0x002fc80000010000ULL, 0x0000000403037221ULL, 0x004fca0000010000ULL,
0x0180000003047810ULL, 0x000fc80007ffe0ffULL, 0x7f80000004047812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0400780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff547224ULL, 0x000fe200078e0003ULL,
0x00009d0000047802ULL, 0x000fe40000000f00ULL, 0x00007d5000007944ULL, 0x000fea0003c00000ULL,
0x0000000300047202ULL, 0x00cfe20000000f00ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000300047308ULL, 0x000e640000001000ULL, 0xbf80000003057423ULL, 0x002fc80000000004ULL,
0x800000ff05057221ULL, 0x000fc80000010100ULL, 0x0000000504047223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff077819ULL, 0x004fe40000011603ULL,
0x0000000803097811ULL, 0x000fc600078ff0ffULL, 0x00001f0704057589ULL, 0x000ea200000e0000ULL,
0x00000008072b7824ULL, 0x000fe400078e00ffULL, 0x0000000809087824ULL, 0x040fe200078e00ffULL,
0x00001f0904067589ULL, 0x00072200000e0000ULL, 0x0000000809307824ULL, 0x000fe200078e00ffULL,
0x00000007ff047212ULL, 0x008fc800078e33ffULL, 0xfffffff82b2b7812ULL, 0x000fe400078ee204ULL,
0x0000000707047812ULL, 0x000fc600078ec0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0200ULL,
0x00000003042a7812ULL, 0x040fe200078e3cffULL, 0x0000002905297220ULL, 0x044fe20000410000ULL,
0x00000004042c7812ULL, 0x040fe200078e3cffULL, 0x0000002805287220ULL, 0x040fe20000410000ULL,
0x00000005042e7812ULL, 0x000fe200078e3cffULL, 0x0000002505257220ULL, 0x040fe40000410000ULL,
0x0000002405247220ULL, 0x040fe20000410000ULL, 0x000000292828723eULL, 0x000fe200000000ffULL,
0x0000002105217220ULL, 0x000fc40000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x000000252424723eULL, 0x000fe200000000ffULL, 0x0000001d051d7220ULL, 0x040fe40000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x000000212020723eULL, 0x000fe200000000ffULL,
0x0000001905197220ULL, 0x040fe40000410000ULL, 0x0000001805187220ULL, 0x040fe20000410000ULL,
0x0000001d1c1c723eULL, 0x000fe200000000ffULL, 0x0000001505157220ULL, 0x000fc40000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x000000191818723eULL, 0x000fe200000000ffULL,
0x0000001105117220ULL, 0x040fe40000410000ULL, 0x0000001005107220ULL, 0x040fe20000410000ULL,
0x000000151414723eULL, 0x000fe200000000ffULL, 0x0000000d050d7220ULL, 0x040fe20000410000ULL,
0xfffffff830157812ULL, 0x000fe200078ee209ULL, 0x0000000c050c7220ULL, 0x000fe20000410000ULL,
0x00000009ff057212ULL, 0x000fe200078e33ffULL, 0x0000002706277220ULL, 0x010fe20000410000ULL,
0x000000111010723eULL, 0x000fe200000000ffULL, 0x0000002606267220ULL, 0x000fe20000410000ULL,
0xfffffff8082d7812ULL, 0x000fe200078ee205ULL, 0x0000000807087824ULL, 0x000fe200078e00ffULL,
0x0000000d0c0c723eULL, 0x000fe200000000ffULL, 0x0000002306237220ULL, 0x040fe20000410000ULL,
0x0000000015157211ULL, 0x000fe200078e20ffULL, 0x0000002206227220ULL, 0x000fe20000410000ULL,
0xfffffff808057812ULL, 0x000fe200078ee207ULL, 0x0000001f061f7220ULL, 0x000fe20000410000ULL,
0x0000000104087812ULL, 0x000fe200078e3cffULL, 0x0000001e061e7220ULL, 0x000fe20000410000ULL,
0x000000272626723eULL, 0x000fe200000000ffULL, 0x0000001b061b7220ULL, 0x000fe20000410000ULL,
0x000000232222723eULL, 0x000fe200000000ffULL, 0x0000001a061a7220ULL, 0x000fe20000410000ULL,
0x0000001f1e1e723eULL, 0x000fe200000000ffULL, 0x0000001706177220ULL, 0x000fc40000410000ULL,
0x0000001606167220ULL, 0x000fe20000410000ULL, 0x0000001b1a1a723eULL, 0x000fe200000000ffULL,
0x0000001306137220ULL, 0x040fe40000410000ULL, 0x0000001206127220ULL, 0x000fe20000410000ULL,
0x000000171616723eULL, 0x000fe200000000ffULL, 0x0000000f060f7220ULL, 0x040fe20000410000ULL,
0x0000000709177812ULL, 0x000fe200078ec0ffULL, 0x0000000e060e7220ULL, 0x000fe20000410000ULL,
0x000000131212723eULL, 0x000fe200000000ffULL, 0x0000000b060b7220ULL, 0x040fe20000410000ULL,
0x0000000617307812ULL, 0x000fe200078e3cffULL, 0x0000000a06067220ULL, 0x000fe20000410000ULL,
0x00000002040a7812ULL, 0x040fe200078e3cffULL, 0x0000000807117824ULL, 0x040fe200078e022cULL,
0x0000000604047812ULL, 0x000fe200078e3cffULL, 0x0000000807137824ULL, 0x040fe200078e022eULL,
0x0000000f0e0e723eULL, 0x000fe200000000ffULL, 0x00000008070d7824ULL, 0x040fe200078e020aULL,
0x0000000b0606723eULL, 0x000fe200000000ffULL, 0x00000008070f7824ULL, 0x040fe200078e022aULL,
0x00000008070b7211ULL, 0x000fe200078e18ffULL, 0x0000001005057824ULL, 0x100fe200078e0200ULL,
0x0000000407077211ULL, 0x000fe200078e18ffULL, 0x0000000403047824ULL, 0x000fe200078e00ffULL,
0x0000000117087812ULL, 0x000fe200078e3cffULL, 0x000000100b0b7824ULL, 0x100fe200078e0200ULL,
0x00000002170a7812ULL, 0x000fe200078e3cffULL, 0x000000100d0d7824ULL, 0x100fe200078e0200ULL,
0x0000000c04047812ULL, 0x000fe200078ec0ffULL, 0x0000001011117824ULL, 0x000fe200078e0200ULL,
0x00000003172a7812ULL, 0x000fe200078e3cffULL, 0x0000000809197824ULL, 0x000fe200078e020aULL,
0x00000004172c7812ULL, 0x000fe200078e3cffULL, 0x0000000105057824ULL, 0x000fe200078e0204ULL,
0x000000000f0f7211ULL, 0x000fe200078e20ffULL, 0x0000001013137824ULL, 0x000fe200078e0200ULL,
0x00000005172e7812ULL, 0x000fe200078e3cffULL, 0x0000000809177824ULL, 0x040fe200078e0208ULL,
0x0000002c091d7211ULL, 0x000fe200078e18ffULL, 0x00000001040b7824ULL, 0x040fe200078e020bULL,
0x0000000f040f7210ULL, 0x040fe20007ffe0ffULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x0000002805007388ULL, 0x0005e20000000800ULL, 0x00000001040d7824ULL, 0x040fe200078e020dULL,
0x0000000019197211ULL, 0x000fe200078e20ffULL, 0x00000008091b7824ULL, 0x040fe200078e022aULL,
0x000000240b007388ULL, 0x000fe20000000800ULL, 0x0000000104117824ULL, 0x040fe200078e0211ULL,
0x0000002b042b7210ULL, 0x040fe20007ffe0ffULL, 0x00000008091f7824ULL, 0x000fe200078e022eULL,
0x000000200d007388ULL, 0x000fe20000000800ULL, 0x0000001017177824ULL, 0x000fe200078e0200ULL,
0x0000001904197210ULL, 0x040fe20007ffe0ffULL, 0x0000000104137824ULL, 0x000fe200078e0213ULL,
0x0000001c0f007388ULL, 0x000fe20000000800ULL, 0x0000000809097824ULL, 0x000fc400078e0230ULL,
0x0000000104077824ULL, 0x040fe200078e0207ULL, 0x0000001811007388ULL, 0x000fe20000000800ULL,
0x000000101b1b7824ULL, 0x100fe400078e0200ULL, 0x000000101d1d7824ULL, 0x100fe200078e0200ULL,
0x0000001413007388ULL, 0x000fe20000000800ULL, 0x0000000104157824ULL, 0x000fe400078e0215ULL,
0x000000102d2d7824ULL, 0x100fe200078e0200ULL, 0x0000001007007388ULL, 0x000fe20000000800ULL,
0x000000101f1f7824ULL, 0x000fc400078e0200ULL, 0x0000000104177824ULL, 0x040fe200078e0217ULL,
0x0000000c2b007388ULL, 0x000fe20000000800ULL, 0x0000001009097824ULL, 0x000fe400078e0200ULL,
0x00000001041b7824ULL, 0x040fe200078e021bULL, 0x0000002615007388ULL, 0x000fe20000000800ULL,
0x0000000104057824ULL, 0x044fe400078e021dULL, 0x00000001042f7824ULL, 0x040fe200078e022dULL,
0x0000002217007388ULL, 0x000fe20000000800ULL, 0x0000000104297824ULL, 0x000fc400078e021fULL,
0x00000001042d7824ULL, 0x000fe200078e0209ULL, 0x0000001e19007388ULL, 0x000fe20000000800ULL,
0x0000000356097210ULL, 0x000fc60007ffe0ffULL, 0x0000001a1b007388ULL, 0x000fe40000000800ULL,
0x0000001009007824ULL, 0x000fe400078e0202ULL, 0x0000001605007388ULL, 0x000fe80000000800ULL,
0x0000001229007388ULL, 0x000fe80000000800ULL, 0x0000000e2d007388ULL, 0x000fe80000000800ULL,
0x000000062f007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000087984ULL, 0x000ea80000000c00ULL, 0x0004000000247984ULL, 0x000ee80000000c00ULL,
0x0008000000207984ULL, 0x000f280000000c00ULL, 0x000c0000001c7984ULL, 0x000f620000000c00ULL,
0x200000ff0b0b7230ULL, 0x004fc40000000000ULL, 0x200000ff0a0a7230ULL, 0x000fe40000000000ULL,
0x200000ff09097230ULL, 0x000fe40000000000ULL, 0x200000ff08087230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x008fe40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fc40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x000000230b0b7230ULL, 0x010fe40000000000ULL, 0x000000220a0a7230ULL, 0x000fe40000000000ULL,
0x0000002109097230ULL, 0x000fe40000000000ULL, 0x0000002008087230ULL, 0x000fe40000000000ULL,
0x0000001f27277230ULL, 0x020fc40000000000ULL, 0x0000001e26267230ULL, 0x000fe20000000000ULL,
0x0000000800007388ULL, 0x0005e20000000c00ULL, 0x0000001d25257230ULL, 0x000fe40000000000ULL,
0x0000001c24247230ULL, 0x000fca0000000000ULL, 0x0004002400007388ULL, 0x0005e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff5700720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002003117810ULL, 0x000fe20007ffe0ffULL,
0x0000000000067919ULL, 0x000f220000002600ULL, 0x00000003ff107819ULL, 0x000fe20000011603ULL,
0x00000000000579c3ULL, 0x000f620000002700ULL, 0x00000003ff047819ULL, 0x000fe20000011611ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000710087812ULL, 0x004fe200078e4803ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000704007812ULL, 0x000fe400078e4811ULL,
0x0ffffff808077812ULL, 0x000fc400078ef803ULL, 0x0ffffff800057812ULL, 0x000fc600078ef811ULL,
0x0000001007007824ULL, 0x100fe400078e0202ULL, 0x0000001005057824ULL, 0x000fc600078e0202ULL,
0x0000000000087984ULL, 0x0004680000000c00ULL, 0x00000000050c7984ULL, 0x0086620000000c00ULL,
0x0000000806077824ULL, 0x050fe200078e00ffULL, 0x0000000306137819ULL, 0x000fe200000006ffULL,
0x00000005040472a4ULL, 0x020fe2000f8e023fULL, 0x0000000862007824ULL, 0x044fe400078e00ffULL,
0xfffffff807027812ULL, 0x000fe200078ee210ULL, 0x0000000862627824ULL, 0x000fe200078e00ffULL,
0xfffffff813047812ULL, 0x000fc400078ee204ULL, 0x0000000402107c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000404027c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff800037812ULL, 0x000fe200078ee203ULL,
0x000000ffff057224ULL, 0x008fe200000e06ffULL, 0x00005a0010047a11ULL, 0x000fe200078040ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005a0002067a11ULL, 0x000fe400078240ffULL,
0x00005b0010057a11ULL, 0x000fc400000f4405ULL, 0x00005b0002077a11ULL, 0x000fe400008f4407ULL,
0xfffffff862117812ULL, 0x000fe200078ee211ULL, 0x0000001003027825ULL, 0x000fc800078e0004ULL,
0x0000001011047825ULL, 0x000fe200078e0006ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000000c04007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000166027810ULL, 0x000fe20007ffe0ffULL,
0x0000004065037824ULL, 0x000fe200078e00ffULL, 0x0000000160057819ULL, 0x008fe200000006ffULL,
0x01b60000ff067f8cULL, 0x000e62000c80043fULL, 0x000000630200720cULL, 0x000fe20003f06070ULL,
0x0000010066097824ULL, 0x000fc400078e0203ULL, 0x0000580005027a24ULL, 0x000fc800078e0210ULL,
0x0000620002057a24ULL, 0x000fcc00078e0209ULL, 0x00000b7000008947ULL, 0x000fea0003800000ULL,
0x00000003ff2b7819ULL, 0x000fe40000011600ULL, 0x0000000964087217ULL, 0x000fe40007800000ULL,
0x000000042b0b7810ULL, 0x040fe40007ffe0ffULL, 0x000000082b0d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001081c7824ULL, 0x000fe200078e0a09ULL, 0x000000000b087212ULL, 0x0c0fe200078e3cffULL,
0x000000080b097824ULL, 0x000fe200078e00ffULL, 0x000000000d0a7212ULL, 0x000fc400078e3cffULL,
0x000000030d117819ULL, 0x000fe400000006ffULL, 0xfffffff8091a7812ULL, 0x000fe200078ee208ULL,
0x0000000105097824ULL, 0x000fe200078e022bULL, 0x0000000c2b137810ULL, 0x000fe40007ffe0ffULL,
0x000000700f2d7812ULL, 0x000fe200078ec0ffULL, 0x00005e0009087625ULL, 0x000fe200078e0004ULL,
0xfffffff8111e7812ULL, 0x000fe400078ee20aULL, 0x00000000130a7212ULL, 0x040fe200078e3cffULL,
0x0000000813117824ULL, 0x000fe200078e00ffULL, 0x000000102b157810ULL, 0x000fc40007ffe0ffULL,
0x000000082d107210ULL, 0x000fe40007f1e0ffULL, 0x0000001c0b00720cULL, 0x000fe20003f86070ULL,
0x00000001050b7824ULL, 0x000fe200078e020bULL, 0xfffffff811207812ULL, 0x000fe200078ee20aULL,
0x00000008150f7824ULL, 0x000fe200078e00ffULL, 0x00000009ff117210ULL, 0x000fe200007fe4ffULL,
0x00005e000b087625ULL, 0x000fe200078e0004ULL, 0x00000000150a7212ULL, 0x000fe400078e3cffULL,
0x0000001c0d00720cULL, 0x000fe20003f46070ULL, 0x00000001050d7824ULL, 0x000fe200078e020dULL,
0xfffffff80f227812ULL, 0x000fe200078ee20aULL, 0x00000001050f7824ULL, 0x000fe200078e0213ULL,
0x000000142b1b7810ULL, 0x000fe20007ffe0ffULL, 0x00005e000d0a7625ULL, 0x000fe200078e0004ULL,
0x000000082d127210ULL, 0x000fc40007f3e0ffULL, 0x0000001c1300720cULL, 0x080fe20003f66070ULL,
0x00000001050d7824ULL, 0x000fe200078e0215ULL, 0x0000001c1500720cULL, 0x000fe20003f06070ULL,
0x0000000105157824ULL, 0x000fe200078e021bULL, 0x00000009ff137210ULL, 0x000fe20000ffe4ffULL,
0x00005e000f087625ULL, 0x000fe200078e0004ULL, 0x0000000a2d147210ULL, 0x000fe40007f3e0ffULL,
0x000000182b257810ULL, 0x000fe20007ffe0ffULL, 0x00005e00150e7625ULL, 0x000fe200078e0004ULL,
0x000000001b0a7212ULL, 0x000fc400078e3cffULL, 0x000000072b197812ULL, 0x000fe200078e4800ULL,
0x000000ffff157224ULL, 0x000fe200008e060bULL, 0x000000082d167210ULL, 0x000fe20007f3e0ffULL,
0x00005e000d0c7625ULL, 0x000fe200078e0004ULL, 0x0000000e2d0e7210ULL, 0x000fe40007fde0ffULL,
0x00001000651d7811ULL, 0x000fe200078e70ffULL, 0x00000001050b7824ULL, 0x000fe200078e0225ULL,
0x0000000c2d0c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff177224ULL, 0x000fe200008e0609ULL,
0x0000001c1b00720cULL, 0x000fe20003f26070ULL, 0x00005e000b087625ULL, 0x000fe200078e0004ULL,
0x0000000fff0f7210ULL, 0x000fc400037fe4ffULL, 0x000000202b237810ULL, 0x000fe20007ffe0ffULL,
0x000000081b1b7824ULL, 0x000fe200078e00ffULL, 0x000000082d187210ULL, 0x000fe20007fde0ffULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x0000001c2b00720cULL, 0x000fe20003fa6070ULL,
0x000000101a217824ULL, 0x000fe200078e021dULL, 0xfffffff81b247812ULL, 0x000fe200078ee20aULL,
0x00000001050b7824ULL, 0x000fe200078e0223ULL, 0x0000001c2b1b7810ULL, 0x000fe40007ffe0ffULL,
0x0ffffff819087812ULL, 0x000fe200078ef800ULL, 0x000000ffff197224ULL, 0x000fe200030e0609ULL,
0x0000001b05097210ULL, 0x000fe20007ffe0ffULL, 0x00005e000b0a7625ULL, 0x000fe200078e0004ULL,
0x0000000025267212ULL, 0x000fc400078e3cffULL, 0x000000342b277810ULL, 0x040fe20007ffe0ffULL,
0x00000010081f7824ULL, 0x000fe200078e021dULL, 0x000000382b297810ULL, 0x000fe20007ffe0ffULL,
0x00005e0009087625ULL, 0x000fc600078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101f7faeULL, 0x0005e2000e901c46ULL, 0x0000001c2500720cULL, 0x040fe20003fa6070ULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0x000000082d1a7210ULL, 0x000fe20007fde0ffULL,
0x0000000012217faeULL, 0x0007e2000e101c46ULL, 0x0000001c1b00720cULL, 0x040fe40003f86070ULL,
0x000000001b087212ULL, 0x000fe400078e3cffULL, 0xfffffff825267812ULL, 0x000fe400078ee226ULL,
0x000000302b257810ULL, 0x000fe20007ffe0ffULL, 0x000000081b117824ULL, 0x004fc400078e00ffULL,
0x000000ffff1b7224ULL, 0x000fe200030e0609ULL, 0x0000000a2d0a7210ULL, 0x000fe20007fde0ffULL,
0x00000010201f7824ULL, 0x000fe200078e021dULL, 0x000000242b217810ULL, 0x008fe40007ffe0ffULL,
0xfffffff811287812ULL, 0x000fe200078ee208ULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x0000001d1e137211ULL, 0x000fe200078e20ffULL, 0x0000000105097824ULL, 0x000fe200078e0221ULL,
0x0000000023117212ULL, 0x0c0fe200078e3cffULL, 0x00000008231e7824ULL, 0x000fe200078e00ffULL,
0x0000000021127212ULL, 0x000fe200078e3cffULL, 0x00005e0009087625ULL, 0x000fe200078e0004ULL,
0x0000000014137faeULL, 0x0005e2000d101c46ULL, 0x0000001c2100720cULL, 0x000fc40003f46070ULL,
0x0000000321217819ULL, 0x000fe200000006ffULL, 0x00000000161f7faeULL, 0x0007e2000d901c46ULL,
0x000000082d107210ULL, 0x000fe40007fde0ffULL, 0xfffffff81e087812ULL, 0x000fe400078ee211ULL,
0xfffffff821127812ULL, 0x000fe200078ee212ULL, 0x000000ffff117224ULL, 0x000fe200030e0609ULL,
0x000000282b217810ULL, 0x000fe20007ffe0ffULL, 0x0000001022137824ULL, 0x104fe200078e021dULL,
0x0000001c2300720cULL, 0x000fe20003f66070ULL, 0x0000001024097824ULL, 0x100fe200078e021dULL,
0x0000002c2b237810ULL, 0x000fe20007ffe0ffULL, 0x00000010081f7824ULL, 0x108fe200078e021dULL,
0x000000000c137faeULL, 0x0005e2000c101c46ULL, 0x0000000021087212ULL, 0x000fe200078e3cffULL,
0x0000001026157824ULL, 0x000fe200078e021dULL, 0x0000001d28177211ULL, 0x000fe200078e20ffULL,
0x000000000e097faeULL, 0x0007e2000c901c46ULL, 0x0000000823147824ULL, 0x000fe200078e00ffULL,
0x0000003c2b2b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000018157faeULL, 0x0009e2000e901c46ULL,
0x0000001c2100720cULL, 0x080fe40003fc6070ULL, 0x0000001c2300720cULL, 0x080fe20003fa6070ULL,
0x000000001a177faeULL, 0x000be2000e101c46ULL, 0x0000001c2500720cULL, 0x000fe20003f86070ULL,
0x0000000105137824ULL, 0x004fe200078e0225ULL, 0x00000000230d7212ULL, 0x080fe200078e3cffULL,
0x0000000821097824ULL, 0x008fe200078e00ffULL, 0x000000000a1f7faeULL, 0x0005e2000d901c46ULL,
0x00000010120f7824ULL, 0x000fe200078e021dULL, 0x00000000250e7212ULL, 0x040fe200078e3cffULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0xfffffff809127812ULL, 0x000fe200078ee208ULL,
0x0000000105097824ULL, 0x000fe200078e0221ULL, 0x00000000100f7faeULL, 0x0007e2000d101c46ULL,
0xfffffff814147812ULL, 0x000fe200078ee20dULL, 0x00000008291a7824ULL, 0x020fe200078e00ffULL,
0xfffffff825167812ULL, 0x000fe200078ee20eULL, 0x00005e0009087625ULL, 0x000fe200078e0004ULL,
0x0000001c2700720cULL, 0x000fc40003f66070ULL, 0x00000023050b7210ULL, 0x004fe20007ffe0ffULL,
0x0000001016177824ULL, 0x000fe200078e021dULL, 0x000000082d0c7210ULL, 0x000fe40007f5e0ffULL,
0x0000002b05157210ULL, 0x010fe20007ffe0ffULL, 0x00005e000b0a7625ULL, 0x000fe200078e0004ULL,
0x0000000327117819ULL, 0x008fe400000006ffULL, 0x0000001c2900720cULL, 0x000fe20003f26070ULL,
0x000000ffff0d7224ULL, 0x000fe200010e0609ULL, 0x0000000a2d0e7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0013087625ULL, 0x000fe200078e0004ULL, 0x00000000270a7212ULL, 0x000fc400078e3cffULL,
0x0000001c2b00720cULL, 0x000fe20003f06070ULL, 0x0000000105277824ULL, 0x000fe200078e0227ULL,
0xfffffff811187812ULL, 0x000fe200078ee20aULL, 0x000000ffff0f7224ULL, 0x000fe200010e060bULL,
0x000000082d107210ULL, 0x000fe20007f5e0ffULL, 0x00005e00270a7625ULL, 0x000fc800078e0004ULL,
0x0000000105137824ULL, 0x000fe200078e0229ULL, 0x0000000029057212ULL, 0x000fe200078e3cffULL,
0x000000ffff117224ULL, 0x000fe200010e0609ULL, 0x0000000a2d0a7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0013087625ULL, 0x000fe200078e0004ULL, 0x000000002b137212ULL, 0x000fe400078e3cffULL,
0xfffffff81a007812ULL, 0x000fe200078ee205ULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x000000082d087210ULL, 0x000fe20007f5e0ffULL, 0x000000082b1c7824ULL, 0x000fc400078e00ffULL,
0x00005e0015047625ULL, 0x000fc600078e0004ULL, 0xfffffff81c1a7812ULL, 0x000fe200078ee213ULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x0000001d12137211ULL, 0x080fe200078e20ffULL,
0x0000001014157824ULL, 0x100fe200078e021dULL, 0x000000042d047210ULL, 0x000fe20007f5e0ffULL,
0x0000001018197824ULL, 0x100fe400078e021dULL, 0x00000010001b7824ULL, 0x000fe200078e021dULL,
0x0000001d1a1d7211ULL, 0x000fe200078e20ffULL, 0x000000ffff057224ULL, 0x000fe200010e0605ULL,
0x000000000c137faeULL, 0x0005e8000f101c46ULL, 0x000000000e157faeULL, 0x0005e8000e901c46ULL,
0x0000000010177faeULL, 0x0005e8000e101c46ULL, 0x000000000a197faeULL, 0x0005e8000d901c46ULL,
0x00000000081b7faeULL, 0x0005e8000c901c46ULL, 0x00000000041d7faeULL, 0x0005e2000c101c46ULL,
0x00000a4000007947ULL, 0x000fea0003800000ULL, 0x00000003ff087819ULL, 0x000fe40000011600ULL,
0x000000700f297812ULL, 0x000fc400078ec0ffULL, 0x00000004080a7810ULL, 0x040fe40007ffe0ffULL,
0x0000001408127810ULL, 0x040fe40007ffe0ffULL, 0x00000008080c7810ULL, 0x000fe20007ffe0ffULL,
0x000000080a107824ULL, 0x040fe200078e00ffULL, 0x000000000a097212ULL, 0x080fe200078e3cffULL,
0x00000008121f7824ULL, 0x000fe200078e00ffULL, 0x0000000c080e7810ULL, 0x000fe20007ffe0ffULL,
0x000000080c167824ULL, 0x000fe200078e00ffULL, 0xfffffff810117812ULL, 0x000fe200078ee209ULL,
0x00000001050f7824ULL, 0x000fe200078e020cULL, 0x0000000012147212ULL, 0x080fe200078e3cffULL,
0x000000080e187824ULL, 0x000fe200078e00ffULL, 0x000000000c097212ULL, 0x000fc400078e3cffULL,
0x0000001008107810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81f1f7812ULL, 0x000fe400078ee214ULL,
0x000000000e0b7212ULL, 0x000fe200078e3cffULL, 0x0000000105197824ULL, 0x000fe200078e0210ULL,
0xfffffff816137812ULL, 0x000fe400078ee209ULL, 0x0000001808147810ULL, 0x040fe40007ffe0ffULL,
0x0000001c08167810ULL, 0x000fc40007ffe0ffULL, 0x00000000100d7212ULL, 0x080fe200078e3cffULL,
0x00000008141c7824ULL, 0x000fe200078e00ffULL, 0x00000003101a7819ULL, 0x000fe200000006ffULL,
0x00000008161e7824ULL, 0x000fe200078e00ffULL, 0xfffffff818177812ULL, 0x000fe200078ee20bULL,
0x0000000105217824ULL, 0x040fe200078e0214ULL, 0x0000002008187810ULL, 0x000fe20007ffe0ffULL,
0x0000000105257824ULL, 0x040fe200078e0216ULL, 0xfffffff81a1b7812ULL, 0x000fe400078ee20dULL,
0x0000000014097212ULL, 0x080fe200078e3cffULL, 0x0000000818207824ULL, 0x000fe200078e00ffULL,
0x00000024081a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001053b7824ULL, 0x000fe200078e0218ULL,
0x00000000160b7212ULL, 0x000fc400078e3cffULL, 0xfffffff81c237812ULL, 0x000fe200078ee209ULL,
0x00000001053f7824ULL, 0x000fe200078e021aULL, 0x00000000180d7212ULL, 0x080fe400078e3cffULL,
0x000000001a157212ULL, 0x040fe400078e3cffULL, 0x000000031a227819ULL, 0x000fe400000006ffULL,
0xfffffff81e277812ULL, 0x000fe400078ee20bULL, 0x00000028081c7810ULL, 0x000fc40007ffe0ffULL,
0x0000002c081e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8203d7812ULL, 0x000fe200078ee20dULL,
0x000000081c247824ULL, 0x000fe200078e00ffULL, 0xfffffff822417812ULL, 0x000fe200078ee215ULL,
0x000000081e267824ULL, 0x000fe200078e00ffULL, 0x0000003008207810ULL, 0x040fe20007ffe0ffULL,
0x0000000105477824ULL, 0x040fe200078e021eULL, 0x0000003408227810ULL, 0x000fe40007ffe0ffULL,
0x000000001c097212ULL, 0x080fe200078e3cffULL, 0x0000000820287824ULL, 0x000fe200078e00ffULL,
0x000000001e0b7212ULL, 0x080fe200078e3cffULL, 0x00000008222a7824ULL, 0x000fe200078e00ffULL,
0xfffffff824457812ULL, 0x000fe200078ee209ULL, 0x00000001054b7824ULL, 0x040fe200078e0220ULL,
0x00000000200d7212ULL, 0x080fe200078e3cffULL, 0x00000001054f7824ULL, 0x000fe200078e0222ULL,
0x0000000022157212ULL, 0x000fc400078e3cffULL, 0xfffffff826497812ULL, 0x000fe400078ee20bULL,
0x0000003808247810ULL, 0x040fe40007ffe0ffULL, 0x0000003c08267810ULL, 0x040fe40007ffe0ffULL,
0x00000007080b7812ULL, 0x000fe200078e4800ULL, 0x0000000105537824ULL, 0x040fe200078e0224ULL,
0x0000000805097210ULL, 0x040fe20007ffe0ffULL, 0x0000000826597824ULL, 0x000fe200078e00ffULL,
0xfffffff8284d7812ULL, 0x000fe200078ee20dULL, 0x00000001050d7824ULL, 0x040fe200078e020aULL,
0xfffffff82a517812ULL, 0x000fe200078ee215ULL, 0x0000000105157824ULL, 0x040fe200078e020eULL,
0x00000012051d7210ULL, 0x000fe20007ffe0ffULL, 0x00005e0009087625ULL, 0x000fe200078e0004ULL,
0x0000001c05437210ULL, 0x000fc40007ffe0ffULL, 0x0000002605577210ULL, 0x000fe40007ffe0ffULL,
0x0ffffff80b0b7812ULL, 0x000fe400078ef800ULL, 0x0000000024057212ULL, 0x0c0fe200078e3cffULL,
0x0000000824247824ULL, 0x000fe200078e00ffULL, 0x00000000260a7212ULL, 0x000fe400078e3cffULL,
0x0000100065007811ULL, 0x000fe400078e70ffULL, 0x0000000829087210ULL, 0x000fc40007f1e0ffULL,
0xfffffff859597812ULL, 0x000fe200078ee20aULL, 0x000000100b2b7824ULL, 0x000fe200078e0200ULL,
0x00000000112d7211ULL, 0x000fe200078e20ffULL, 0x00005e000d0a7625ULL, 0x000fe200078e0004ULL,
0x0000000023377211ULL, 0x000fe400078e20ffULL, 0xfffffff824057812ULL, 0x000fe200078ee205ULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x0000000a290a7210ULL, 0x000fe20007f1e0ffULL,
0x00005e000f0c7625ULL, 0x000fe200078e0004ULL, 0x0000000049497211ULL, 0x000fc400078e20ffULL,
0x0000000bff0b7210ULL, 0x000fe200007fe4ffULL, 0x00005e0019107625ULL, 0x000fe200078e0004ULL,
0x0000000c290c7210ULL, 0x000fe20007f3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000082b7faeULL, 0x0005e4000b901c46ULL, 0x00000010132f7824ULL, 0x000fe200078e0200ULL,
0x0000001029107210ULL, 0x000fe20007f1e0ffULL, 0x00005e00150e7625ULL, 0x080fe200078e0004ULL,
0x000000000a2d7faeULL, 0x0005e6000b901c46ULL, 0x00005e001d127625ULL, 0x000fe200078e0004ULL,
0x0000000e290e7210ULL, 0x000fc60007f5e0ffULL, 0x00005e0021147625ULL, 0x000fc800078e0004ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x0000001229127210ULL, 0x000fe20007f3e0ffULL,
0x0000001017317824ULL, 0x000fe400078e0200ULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000001429147210ULL, 0x000fe20007f1e0ffULL, 0x00005e0025167625ULL, 0x080fe200078e0004ULL,
0x000000000c2f7faeULL, 0x0005e4000b901c46ULL, 0x00000015ff157210ULL, 0x000fe200007fe4ffULL,
0x00005e003b187625ULL, 0x000fc800078e0004ULL, 0x000000ffff137224ULL, 0x000fe200008e0613ULL,
0x0000001629167210ULL, 0x000fe20007f3e0ffULL, 0x000000101b337824ULL, 0x100fe200078e0200ULL,
0x0000001829187210ULL, 0x000fe20007f1e0ffULL, 0x000000101f357824ULL, 0x000fe400078e0200ULL,
0x00005e003f1a7625ULL, 0x000fc800078e0004ULL, 0x00005e00471e7625ULL, 0x000fc800078e0004ULL,
0x00005e00431c7625ULL, 0x000fc800078e0004ULL, 0x000000ffff177224ULL, 0x000fe200008e0617ULL,
0x0000001a291a7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff197224ULL, 0x000fe200000e0619ULL,
0x0000001e291e7210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e060fULL,
0x0000001c291c7210ULL, 0x000fe20007f5e0ffULL, 0x00005e004b207625ULL, 0x080fe200078e0004ULL,
0x0000001fff1f7210ULL, 0x000fe400007fe4ffULL, 0x000000000e317faeULL, 0x0005e2000b901c46ULL,
0x00005e004f227625ULL, 0x000fc600078e0004ULL, 0x0000000010337faeULL, 0x0005e2000b901c46ULL,
0x0000001027397824ULL, 0x100fe400078e0200ULL, 0x00005e0053247625ULL, 0x080fe200078e0004ULL,
0x0000000012357faeULL, 0x0005e6000b901c46ULL, 0x00005e0057267625ULL, 0x000fe200078e0004ULL,
0x0000002029047210ULL, 0x040fe20007f1e0ffULL, 0x0000000014377faeULL, 0x0005e4000b901c46ULL,
0x000000ffff1b7224ULL, 0x000fe200008e061bULL, 0x0000002229207210ULL, 0x000fe20007f3e0ffULL,
0x000000103d3d7824ULL, 0x100fe200078e0200ULL, 0x0000000016397faeULL, 0x0005e2000b901c46ULL,
0x000000ffff1d7224ULL, 0x000fe200010e061dULL, 0x0000002429227210ULL, 0x000fe20007f5e0ffULL,
0x0000001041417824ULL, 0x100fe200078e0200ULL, 0x0000002629247210ULL, 0x000fe20007f7e0ffULL,
0x0000001045457824ULL, 0x100fe200078e0200ULL, 0x00000000183d7faeULL, 0x0005e2000b901c46ULL,
0x0000001005557824ULL, 0x000fc400078e0200ULL, 0x000000104d4d7824ULL, 0x100fe200078e0200ULL,
0x000000001a417faeULL, 0x0005e2000b901c46ULL, 0x000000ffff057224ULL, 0x000fe400000e0621ULL,
0x0000001051517824ULL, 0x100fe200078e0200ULL, 0x000000001c457faeULL, 0x0005e2000b901c46ULL,
0x000000ffff217224ULL, 0x000fe400008e0623ULL, 0x000000ffff237224ULL, 0x000fe200010e0625ULL,
0x000000001e497faeULL, 0x0005e2000b901c46ULL, 0x0000001059597824ULL, 0x000fc400078e0200ULL,
0x000000ffff257224ULL, 0x000fe200018e0627ULL, 0x00000000044d7faeULL, 0x0005e8000b901c46ULL,
0x0000000020517faeULL, 0x0005e8000b901c46ULL, 0x0000000022557faeULL, 0x0005e8000b901c46ULL,
0x0000000024597faeULL, 0x0005e4000b901c46ULL, 0x01b60400ff057984ULL, 0x004ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000005ff7812ULL, 0x006fc60007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e00000000007802ULL, 0x000fc80000000f00ULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x01b60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000636600720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000737919ULL, 0x000e620000000000ULL, 0x0001b688657a7811ULL, 0x040fe200078e18ffULL,
0x0000002065727824ULL, 0x000fe200078e00ffULL, 0xffffffff637d7810ULL, 0x000fe40007ffe0ffULL,
0x0000010066757824ULL, 0x000fe200078e0203ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000756400720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x0000000166007810ULL, 0x000fe20007ffe0ffULL, 0x0000620002157a24ULL, 0x000fc600078e0275ULL,
0x000000630000720cULL, 0x000fda0003f06070ULL, 0x00000a9000008947ULL, 0x000fea0003800000ULL,
0x00000003ff717819ULL, 0x002fe20000011673ULL, 0x0000000164197824ULL, 0x000fe200078e0a75ULL,
0x0000000773147812ULL, 0x000fe200078ec0ffULL, 0x00000100ff707424ULL, 0x000fe200078e00ffULL,
0x00000004716e7810ULL, 0x040fe40007ffe0ffULL, 0x00000008716c7810ULL, 0x040fe40007ffe0ffULL,
0x000000736e6d7212ULL, 0x0c0fe200078e3cffULL, 0x000000086e007824ULL, 0x000fe200078e00ffULL,
0x0000000c716a7810ULL, 0x040fe20007ffe0ffULL, 0x000000086c047824ULL, 0x000fe200078e00ffULL,
0x0000001071687810ULL, 0x040fe20007ffe0ffULL, 0x000000016e0d7824ULL, 0x000fe200078e0215ULL,
0xfffffff8006d7812ULL, 0x000fe200078ee26dULL, 0x000000016a117824ULL, 0x100fe200078e0215ULL,
0x0000001871007810ULL, 0x000fe20007ffe0ffULL, 0x0000000868087824ULL, 0x000fe200078e00ffULL,
0x000000736a697212ULL, 0x080fe200078e3cffULL, 0x0000000168137824ULL, 0x000fe200078e0215ULL,
0x000000036a067819ULL, 0x000fe200000006ffULL, 0x0000000800097824ULL, 0x000fe200078e00ffULL,
0x000000736c6b7212ULL, 0x080fe200078e3cffULL, 0x00005e0011107625ULL, 0x000fe200078e0070ULL,
0x0000007368677212ULL, 0x000fc400078e3cffULL, 0xfffffff806697812ULL, 0x000fe200078ee269ULL,
0x00005e0013127625ULL, 0x000fe200078e0070ULL, 0x0000002071057810ULL, 0x000fe40007ffe0ffULL,
0x0000007300067212ULL, 0x040fe200078e3cffULL, 0x0000000100237824ULL, 0x000fe200078e0215ULL,
0xfffffff8046b7812ULL, 0x000fe200078ee26bULL, 0x0000000105297824ULL, 0x000fe200078e0215ULL,
0x0000001471627810ULL, 0x000fe40007ffe0ffULL, 0xfffffff808677812ULL, 0x000fc400078ee267ULL,
0x0000001c71047810ULL, 0x000fe20007ffe0ffULL, 0x00000008620a7824ULL, 0x040fe200078e00ffULL,
0x0000007305087212ULL, 0x0c0fe200078e3cffULL, 0x0000000162217824ULL, 0x000fe200078e0215ULL,
0x00000003050b7819ULL, 0x000fe200000006ffULL, 0x00000008040c7824ULL, 0x000fe200078e00ffULL,
0xfffffff809067812ULL, 0x000fe400078ee206ULL, 0x0000007371097212ULL, 0x080fe400078e3cffULL,
0x0000007362617212ULL, 0x000fc400078e3cffULL, 0xfffffff80b087812ULL, 0x000fe200078ee208ULL,
0x00000001710b7824ULL, 0x000fe200078e0215ULL, 0x0000007304077212ULL, 0x000fe400078e3cffULL,
0x0000000709167812ULL, 0x000fe400078ec0ffULL, 0x000000156c0f7210ULL, 0x000fe40007ffe0ffULL,
0x000000197100720cULL, 0x080fe40003f06070ULL, 0xfffffff80a617812ULL, 0x000fe200078ee261ULL,
0x00005e000b0a7625ULL, 0x000fe200078e0070ULL, 0x000000196e00720cULL, 0x000fc40003f26070ULL,
0xfffffff80c077812ULL, 0x000fe200078ee207ULL, 0x00005e000d0c7625ULL, 0x080fe200078e0070ULL,
0x000000196c00720cULL, 0x080fe40003f46070ULL, 0x0000300065247811ULL, 0x000fe200078e70ffULL,
0x00005e000f0e7625ULL, 0x000fe200078e0070ULL, 0x0000000814257812ULL, 0x000fe400078efcffULL,
0x000000196a00720cULL, 0x080fe20003f66070ULL, 0x000000106d177824ULL, 0x000fe200078e0224ULL,
0x0ffffff8166f7812ULL, 0x000fe200078ef873ULL, 0x00000010250a7825ULL, 0x000fe200078e000aULL,
0x000000196800720cULL, 0x000fc40003f86070ULL, 0x000000246b1b7211ULL, 0x000fe200078e20ffULL,
0x000000106f097824ULL, 0x000fe200078e0224ULL, 0x0000001504277210ULL, 0x000fe20007ffe0ffULL,
0x00000010250c7825ULL, 0x000fc600078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a097faeULL, 0x0003e2000c101c46ULL, 0x00000010250e7825ULL, 0x040fe200078e000eULL,
0x000000196200720cULL, 0x080fe40003f06070ULL, 0x000000000c177faeULL, 0x0005e2000c901c46ULL,
0x0000001025107825ULL, 0x000fe200078e0010ULL, 0x000000190000720cULL, 0x080fe40003f26070ULL,
0x000000000e1b7faeULL, 0x0007e2000d101c46ULL, 0x00000010691d7824ULL, 0x000fe200078e0224ULL,
0x000000190400720cULL, 0x000fe20003f46070ULL, 0x0000001025127825ULL, 0x000fe200078e0012ULL,
0x0000002471097810ULL, 0x002fc40007ffe0ffULL, 0x00000000101d7faeULL, 0x0003e2000d901c46ULL,
0x00000010671f7824ULL, 0x000fe200078e0224ULL, 0x000000190500720cULL, 0x000fe20003f66070ULL,
0x00005e00210a7625ULL, 0x000fe200078e0070ULL, 0x0000002408217211ULL, 0x000fe400078e20ffULL,
0x00000000121f7faeULL, 0x0009e2000e101c46ULL, 0x00005e00230c7625ULL, 0x004fc800078e0070ULL,
0x00005e0027167625ULL, 0x000fc800078e0070ULL, 0x00000010250e7825ULL, 0x008fe200078e000aULL,
0x0000002c710b7810ULL, 0x040fe40007ffe0ffULL, 0x00000028710a7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0029127625ULL, 0x010fc800078e0070ULL, 0x00000010611b7824ULL, 0x000fe400078e0224ULL,
0x0000001025107825ULL, 0x002fe200078e000cULL, 0x00000030710c7810ULL, 0x040fe40007ffe0ffULL,
0x000000000e1b7faeULL, 0x0003e2000c101c46ULL, 0x00000010061d7824ULL, 0x000fe200078e0224ULL,
0x00000034710d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001025167825ULL, 0x000fe200078e0016ULL,
0x000000190900720cULL, 0x080fe40003f06070ULL, 0x00000000101d7faeULL, 0x0005e2000c901c46ULL,
0x00000010071f7824ULL, 0x000fe200078e0224ULL, 0x000000190a00720cULL, 0x080fe20003f26070ULL,
0x0000001025127825ULL, 0x000fe200078e0012ULL, 0x000000190d00720cULL, 0x000fc40003f86070ULL,
0x00000000161f7faeULL, 0x0007e2000d101c46ULL, 0x00000038710e7810ULL, 0x042fe40007ffe0ffULL,
0x0000003c710f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000012217faeULL, 0x0003e2000d901c46ULL,
0x000000190b00720cULL, 0x000fe20003f46070ULL, 0x000000080e187824ULL, 0x000fe200078e00ffULL,
0x000000730a117212ULL, 0x004fe200078e3cffULL, 0x000000010c1d7824ULL, 0x140fe200078e0215ULL,
0x000000190c00720cULL, 0x080fe20003f66070ULL, 0x000000010f237824ULL, 0x100fe200078e0215ULL,
0x000000190e00720cULL, 0x000fe20003fa6070ULL, 0x000000080b177824ULL, 0x008fe200078e00ffULL,
0x0000007309107212ULL, 0x000fe200078e3cffULL, 0x000000080a167824ULL, 0x000fe200078e00ffULL,
0x000000190f00720cULL, 0x000fe20003fc6070ULL, 0x0000000809137824ULL, 0x002fe200078e00ffULL,
0x000000730b127212ULL, 0x080fe200078e3cffULL, 0x000000080f197824ULL, 0x000fe200078e00ffULL,
0x000000730d5c7212ULL, 0x0c0fe200078e3cffULL, 0x000000010d1f7824ULL, 0x100fe200078e0215ULL,
0xfffffff817127812ULL, 0x000fe200078ee212ULL, 0x000000010e217824ULL, 0x000fe200078e0215ULL,
0x000000030d177819ULL, 0x000fe200000006ffULL, 0x00005e001d1c7625ULL, 0x000fe200078e0070ULL,
0x000000730f5e7212ULL, 0x000fc400078e3cffULL, 0xfffffff816117812ULL, 0x000fe200078ee211ULL,
0x000000080c167824ULL, 0x040fe200078e00ffULL, 0xfffffff813107812ULL, 0x000fe200078ee210ULL,
0x00005e001f1e7625ULL, 0x080fe200078e0070ULL, 0x000000730c137212ULL, 0x080fe400078e3cffULL,
0xfffffff8175c7812ULL, 0x000fe200078ee25cULL, 0x0000000109177824ULL, 0x000fe200078e0215ULL,
0x000000730e5d7212ULL, 0x000fe200078e3cffULL, 0x00005e0021207625ULL, 0x000fe200078e0070ULL,
0xfffffff8195e7812ULL, 0x000fc400078ee25eULL, 0x000000150b1b7210ULL, 0x000fe20007ffe0ffULL,
0x000000010a197824ULL, 0x000fe200078e0215ULL, 0xfffffff816137812ULL, 0x000fe200078ee213ULL,
0x00005e0017167625ULL, 0x000fe200078e0070ULL, 0xfffffff8185d7812ULL, 0x000fe400078ee25dULL,
0x0000002410157211ULL, 0x000fe200078e20ffULL, 0x00005e0019187625ULL, 0x000fe200078e0070ULL,
0x000000245d2d7211ULL, 0x000fc600078e20ffULL, 0x00005e001b1a7625ULL, 0x000fc800078e0070ULL,
0x00005e0023227625ULL, 0x000fc800078e0070ULL, 0x0000001025167825ULL, 0x000fc800078e0016ULL,
0x0000001025187825ULL, 0x040fe200078e0018ULL, 0x0000000016157faeULL, 0x0003e6000c101c46ULL,
0x00000010251a7825ULL, 0x000fc800078e001aULL, 0x00000010251c7825ULL, 0x000fc800078e001cULL,
0x0000001011277824ULL, 0x000fe400078e0224ULL, 0x00000010251e7825ULL, 0x000fc600078e001eULL,
0x0000000018277faeULL, 0x0003e2000c901c46ULL, 0x0000001025207825ULL, 0x000fc800078e0020ULL,
0x0000001025227825ULL, 0x000fc800078e0022ULL, 0x0000001012257824ULL, 0x100fe400078e0224ULL,
0x0000001013297824ULL, 0x100fe400078e0224ULL, 0x000000105c2b7824ULL, 0x100fe200078e0224ULL,
0x000000001a257faeULL, 0x0003e2000d101c46ULL, 0x000000105e2f7824ULL, 0x000fc600078e0224ULL,
0x000000001c297faeULL, 0x0003e8000d901c46ULL, 0x000000001e2b7faeULL, 0x0003e8000e101c46ULL,
0x00000000202d7faeULL, 0x0003e8000e901c46ULL, 0x00000000222f7faeULL, 0x0003e2000f101c46ULL,
0x0000097000007947ULL, 0x000fea0003800000ULL, 0x00000003ff717819ULL, 0x002fe20000011673ULL,
0x00000100ff707424ULL, 0x000fe200078e00ffULL, 0x00003000653a7811ULL, 0x000fc400078e70ffULL,
0x00000008716c7810ULL, 0x040fe40007ffe0ffULL, 0x00000004716e7810ULL, 0x040fe40007ffe0ffULL,
0x000000736c6b7212ULL, 0x0c0fe200078e3cffULL, 0x000000086c047824ULL, 0x000fe200078e00ffULL,
0x000000736e6d7212ULL, 0x040fe200078e3cffULL, 0x000000086e007824ULL, 0x000fe200078e00ffULL,
0x0000000c716a7810ULL, 0x040fe40007ffe0ffULL, 0x0000001071687810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8046b7812ULL, 0x000fe200078ee26bULL, 0x000000016a1d7824ULL, 0x000fe200078e0215ULL,
0xfffffff8006d7812ULL, 0x000fe200078ee26dULL, 0x000000086a007824ULL, 0x000fe200078e00ffULL,
0x0000007368677212ULL, 0x0c0fe200078e3cffULL, 0x0000000168237824ULL, 0x040fe200078e0215ULL,
0x0000000368047819ULL, 0x000fe200000006ffULL, 0x00005e001d1c7625ULL, 0x080fe200078e0070ULL,
0x0000001471627810ULL, 0x000fe40007ffe0ffULL, 0x000000736a697212ULL, 0x000fe200078e3cffULL,
0x00005e0023227625ULL, 0x000fe200078e0070ULL, 0xfffffff804677812ULL, 0x000fc400078ee267ULL,
0x0000001c71047810ULL, 0x040fe20007ffe0ffULL, 0x0000000862067824ULL, 0x000fe200078e00ffULL,
0xfffffff800697812ULL, 0x000fe200078ee269ULL, 0x0000000162257824ULL, 0x000fe200078e0215ULL,
0x0000002071057810ULL, 0x040fe20007ffe0ffULL, 0x00000008040a7824ULL, 0x000fe200078e00ffULL,
0x0000001871007810ULL, 0x000fe20007ffe0ffULL, 0x00005e0025247625ULL, 0x080fe200078e0070ULL,
0x0000007362617212ULL, 0x080fe400078e3cffULL, 0x0000007304077212ULL, 0x080fe200078e3cffULL,
0x00000008050b7824ULL, 0x040fe200078e00ffULL, 0xfffffff806617812ULL, 0x000fe200078ee261ULL,
0x0000000800097824ULL, 0x040fe200078e00ffULL, 0x0000007305087212ULL, 0x0c0fe200078e3cffULL,
0x0000000100277824ULL, 0x140fe200078e0215ULL, 0x0000007300067212ULL, 0x000fe200078e3cffULL,
0x00000001052b7824ULL, 0x000fe200078e0215ULL, 0xfffffff80a077812ULL, 0x000fe200078ee207ULL,
0x00005e0027267625ULL, 0x000fe200078e0070ULL, 0xfffffff80b087812ULL, 0x000fc400078ee208ULL,
0x00000028710a7810ULL, 0x000fe20007ffe0ffULL, 0x00005e002b2a7625ULL, 0x080fe200078e0070ULL,
0xfffffff809067812ULL, 0x000fe400078ee206ULL, 0x0000002c710b7810ULL, 0x040fe20007ffe0ffULL,
0x000000080a0c7824ULL, 0x040fe200078e00ffULL, 0x0000002471097810ULL, 0x000fe20007ffe0ffULL,
0x000000010a2f7824ULL, 0x140fe200078e0215ULL, 0x000000730a117212ULL, 0x080fe200078e3cffULL,
0x000000080b0f7824ULL, 0x000fe200078e00ffULL, 0x0000007309107212ULL, 0x080fe200078e3cffULL,
0x000000010b317824ULL, 0x100fe200078e0215ULL, 0x00000003090d7819ULL, 0x040fe200000006ffULL,
0x00000001092d7824ULL, 0x000fe200078e0215ULL, 0x000000730b127212ULL, 0x000fe200078e3cffULL,
0x00005e0031307625ULL, 0x000fe200078e0070ULL, 0x00000038710e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80d107812ULL, 0x000fe200078ee210ULL, 0x00005e002d2c7625ULL, 0x080fe200078e0070ULL,
0xfffffff80c117812ULL, 0x000fe400078ee211ULL, 0x00000030710c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010e377824ULL, 0x100fe200078e0215ULL, 0xfffffff80f127812ULL, 0x000fe200078ee212ULL,
0x00005e002f2e7625ULL, 0x080fe200078e0070ULL, 0x00000034710d7810ULL, 0x040fe40007ffe0ffULL,
0x0000003c710f7810ULL, 0x000fe20007ffe0ffULL, 0x000000080c147824ULL, 0x000fe200078e00ffULL,
0x000000730e5d7212ULL, 0x0c0fe200078e3cffULL, 0x000000080d177824ULL, 0x000fe200078e00ffULL,
0x000000030e167819ULL, 0x000fe200000006ffULL, 0x000000080f197824ULL, 0x000fe200078e00ffULL,
0x000000730c137212ULL, 0x080fe200078e3cffULL, 0x000000010d357824ULL, 0x140fe200078e0215ULL,
0x000000730d5c7212ULL, 0x080fe200078e3cffULL, 0x000000010f397824ULL, 0x000fe200078e0215ULL,
0xfffffff8165d7812ULL, 0x000fe200078ee25dULL, 0x00005e0035347625ULL, 0x000fe200078e0070ULL,
0x000000730f5e7212ULL, 0x000fc400078e3cffULL, 0x0000007371167212ULL, 0x000fe200078e3cffULL,
0x00005e0037367625ULL, 0x080fe200078e0070ULL, 0x000000156c1b7210ULL, 0x080fe40007ffe0ffULL,
0xfffffff814137812ULL, 0x000fe200078ee213ULL, 0x00005e0039387625ULL, 0x080fe200078e0070ULL,
0xfffffff8175c7812ULL, 0x000fe400078ee25cULL, 0x0000000773147812ULL, 0x000fe200078ec0ffULL,
0x0000000171177824ULL, 0x100fe200078e0215ULL, 0xfffffff8195e7812ULL, 0x000fe200078ee25eULL,
0x000000016e197824ULL, 0x000fe200078e0215ULL, 0x0000000716187812ULL, 0x000fe200078ec0ffULL,
0x00005e001b1a7625ULL, 0x000fe200078e0070ULL, 0x0000001504297210ULL, 0x000fc40007ffe0ffULL,
0x000000150c337210ULL, 0x000fe20007ffe0ffULL, 0x00005e0017167625ULL, 0x080fe200078e0070ULL,
0x00000008143b7812ULL, 0x000fe400078efcffULL, 0x0ffffff8186f7812ULL, 0x000fe200078ef873ULL,
0x00005e0019187625ULL, 0x000fc800078e0070ULL, 0x00005e0029287625ULL, 0x000fc800078e0070ULL,
0x00005e0033327625ULL, 0x000fc800078e0070ULL, 0x000000103b1e7825ULL, 0x000fc800078e001aULL,
0x000000103b167825ULL, 0x000fc800078e0016ULL, 0x000000103b207825ULL, 0x000fc800078e001cULL,
0x000000103b1a7825ULL, 0x000fe200078e0026ULL, 0x0000003a6d277211ULL, 0x000fc600078e20ffULL,
0x000000106f157824ULL, 0x000fe400078e023aULL, 0x000000103b187825ULL, 0x000fc600078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016157faeULL, 0x0003e2000b901c46ULL,
0x000000103b1c7825ULL, 0x000fc600078e0030ULL, 0x0000000018277faeULL, 0x0005e2000b901c46ULL,
0x000000103b227825ULL, 0x000fc800078e0022ULL, 0x000000103b247825ULL, 0x000fe200078e0024ULL,
0x0000003a06157211ULL, 0x002fc600078e20ffULL, 0x000000103b287825ULL, 0x000fe200078e0028ULL,
0x0000003a12197211ULL, 0x004fc600078e20ffULL, 0x000000103b2a7825ULL, 0x000fc800078e002aULL,
0x000000103b2c7825ULL, 0x000fc800078e002cULL, 0x000000103b2e7825ULL, 0x000fc800078e002eULL,
0x000000103b327825ULL, 0x000fc800078e0032ULL, 0x000000103b347825ULL, 0x000fc800078e0034ULL,
0x000000103b367825ULL, 0x000fc800078e0036ULL, 0x000000103b387825ULL, 0x000fc800078e0038ULL,
0x000000106b317824ULL, 0x100fe400078e023aULL, 0x00000010693b7824ULL, 0x100fe400078e023aULL,
0x00000010673d7824ULL, 0x100fe200078e023aULL, 0x000000001e317faeULL, 0x0003e2000b901c46ULL,
0x00000010613f7824ULL, 0x100fe400078e023aULL, 0x0000001007177824ULL, 0x100fe200078e023aULL,
0x00000000203b7faeULL, 0x0005e2000b901c46ULL, 0x0000001008417824ULL, 0x000fc400078e023aULL,
0x0000001010437824ULL, 0x100fe200078e023aULL, 0x00000000223d7faeULL, 0x0007e2000b901c46ULL,
0x0000001011457824ULL, 0x000fc600078e023aULL, 0x00000000243f7faeULL, 0x0009e2000b901c46ULL,
0x00000010131f7824ULL, 0x002fc600078e023aULL, 0x000000001a157faeULL, 0x0003e2000b901c46ULL,
0x000000105c217824ULL, 0x004fc600078e023aULL, 0x0000000028177faeULL, 0x0003e2000b901c46ULL,
0x000000105d237824ULL, 0x008fc600078e023aULL, 0x000000002a417faeULL, 0x0003e2000b901c46ULL,
0x000000105e257824ULL, 0x010fc600078e023aULL, 0x000000002c437faeULL, 0x0003e8000b901c46ULL,
0x000000002e457faeULL, 0x0003e8000b901c46ULL, 0x000000001c197faeULL, 0x0003e8000b901c46ULL,
0x00000000321f7faeULL, 0x0003e8000b901c46ULL, 0x0000000034217faeULL, 0x0003e8000b901c46ULL,
0x0000000036237faeULL, 0x0003e8000b901c46ULL, 0x0000000038257faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000004ff5f7819ULL, 0x000fc40000011673ULL,
0x0000000814607812ULL, 0x000fc800078ef873ULL, 0x000000075f157812ULL, 0x002fc800078e7860ULL,
0x0000001560157211ULL, 0x000fca00078e20ffULL, 0x0000001015157824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x000000085f177824ULL, 0x000fe200078e00ffULL, 0x000000001530783bULL, 0x000fe20000000200ULL,
0x0000400065797824ULL, 0x000fe200078e00ffULL, 0x00000001713d7812ULL, 0x000fe400078ec0ffULL,
0xfffffff817147812ULL, 0x000fe400078ee214ULL, 0x0000100079787810ULL, 0x000fe40007ffe0ffULL,
0x0000000714427812ULL, 0x040fe200078ec0ffULL, 0x0000000814877824ULL, 0x040fe200078e00ffULL,
0x0000001014957810ULL, 0x000fc40007ffe0ffULL, 0x0000000142167812ULL, 0x000fe400078e7871ULL,
0x000000025f177810ULL, 0x000fe40007ffe0ffULL, 0x00000087167b7212ULL, 0x000fe400078efcffULL,
0x0000000795407812ULL, 0x040fe200078ec0ffULL, 0x0000000895957824ULL, 0x000fe200078e00ffULL,
0x000000787b187211ULL, 0x000fe400078e20ffULL, 0x0000002014937810ULL, 0x000fc40007ffe0ffULL,
0x0000000242747812ULL, 0x000fe400078e1e3dULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0x0000000717177812ULL, 0x000fe400078e7860ULL, 0x0000000140167812ULL, 0x000fe400078e7871ULL,
0x0000003014147810ULL, 0x000fe20007ffe0ffULL, 0x0000001060177824ULL, 0x000fe200078e0217ULL,
0x00000007933e7812ULL, 0x000fe400078ec0ffULL, 0x0000008774747212ULL, 0x000fe200078efcffULL,
0x0000001017177824ULL, 0x000fe200078e00ffULL, 0x0000009516777212ULL, 0x000fe200078efcffULL,
0x0000000814917824ULL, 0x000fe200078e00ffULL, 0x0000000393937819ULL, 0x000fe200000006ffULL,
0x0000001074547824ULL, 0x100fe200078e0278ULL, 0x00000007143c7812ULL, 0x000fe200078ec0ffULL,
0x0000001077387824ULL, 0x000fe200078e0278ULL, 0x000000013e767812ULL, 0x100fe200078e7871ULL,
0x00000000172c783bULL, 0x000fe20000000200ULL, 0x000000013c147812ULL, 0x000fc400078e7871ULL,
0x0000009376767212ULL, 0x000fe200078efcffULL, 0x000000005454783bULL, 0x000ea20000000200ULL,
0x00000091147f7212ULL, 0x000fe400078efcffULL, 0x00000002401c7812ULL, 0x100fe200078e1e3dULL,
0x0000001076147824ULL, 0x100fe200078e0278ULL, 0x000000003838783bULL, 0x000ee20000000200ULL,
0x000000107f347824ULL, 0x000fe200078e0278ULL, 0x000000951c817212ULL, 0x000fe400078efcffULL,
0x000000023e207812ULL, 0x000fe200078e1e3dULL, 0x000000001414783bULL, 0x000f220000000200ULL,
0x00000078811c7211ULL, 0x000fc400078e20ffULL, 0x0000009320837212ULL, 0x000fe200078efcffULL,
0x000000003434783bULL, 0x000f620000000200ULL, 0x000000043c447812ULL, 0x000fe200078e1e3dULL,
0x000000183058723cULL, 0x002fe400000018ffULL, 0x0000001083247824ULL, 0x000fe200078e0278ULL,
0x000000001c1c783bULL, 0x000e620000000200ULL, 0x0000009144897212ULL, 0x000fc800078efcffULL,
0x000000002424783bULL, 0x000e620000000200ULL, 0x0000001a3018723cULL, 0x000fe200000018ffULL,
0x0000001089487824ULL, 0x000fcc00078e0278ULL, 0x000000004848783bULL, 0x000ff00000000200ULL,
0x000000542c58723cULL, 0x044ff20000001858ULL, 0x000000562c54723cULL, 0x000ff00000001818ULL,
0x000000383018723cULL, 0x048ff000000018ffULL, 0x0000003a3038723cULL, 0x040ff000000018ffULL,
0x000000143020723cULL, 0x050ff000000018ffULL, 0x000000343028723cULL, 0x060fee00000018ffULL,
0x000000023c347812ULL, 0x140fe200078e1e3dULL, 0x000000163014723cULL, 0x000fe200000018ffULL,
0x000000063c3c7812ULL, 0x000fc400078e1e3dULL, 0x0000009134857212ULL, 0x080fe400078efcffULL,
0x000000913c917212ULL, 0x000fc600078efcffULL, 0x0000001085347824ULL, 0x000fe200078e0278ULL,
0x0000001c2c18723cULL, 0x002ff00000001818ULL, 0x000000363030723cULL, 0x000fe200000018ffULL,
0x000000003434783bULL, 0x000e6e0000000200ULL, 0x0000001e2c1c723cULL, 0x040fee0000001838ULL,
0x000000045f397810ULL, 0x000fe20007ffe0ffULL, 0x000000242c20723cULL, 0x000fe20000001820ULL,
0x000000043e3a7812ULL, 0x000fc400078e1e3dULL, 0x000000063e3e7812ULL, 0x000fe400078e1e3dULL,
0x000000933a8b7212ULL, 0x080fe400078efcffULL, 0x0000000739257812ULL, 0x000fe400078e7860ULL,
0x000000065f397810ULL, 0x000fe20007ffe0ffULL, 0x000000108b4c7824ULL, 0x000fe200078e0278ULL,
0x000000933e937212ULL, 0x000fe200078efcffULL, 0x0000001060387824ULL, 0x000fe200078e0225ULL,
0x0000000739397812ULL, 0x000fe200078e7860ULL, 0x000000262c24723cULL, 0x000fe40000001814ULL,
0x0000001038387824ULL, 0x000fe200078e00ffULL, 0x000000004c4c783bULL, 0x000fe20000000200ULL,
0x0000001060397824ULL, 0x000fc600078e0239ULL, 0x000000003844783bULL, 0x0004e20000000200ULL,
0x0000000440167812ULL, 0x100fe400078e1e3dULL, 0x0000000442147812ULL, 0x100fe200078e1e3dULL,
0x000000342c28723cULL, 0x042fe20000001828ULL, 0x00000095168d7212ULL, 0x000fe400078efcffULL,
0x00000087148f7212ULL, 0x080fe200078efcffULL, 0x0000001093387824ULL, 0x104fe200078e0278ULL,
0x00000004397c7819ULL, 0x000fe200000006ffULL, 0x000000108d507824ULL, 0x100fe200078e0278ULL,
0x000000788f147211ULL, 0x000fe200078e20ffULL, 0x000000362c2c723cULL, 0x000fe20000001830ULL,
0x0000000642427812ULL, 0x100fe200078e1e3dULL, 0x000000007c30783bULL, 0x000fe20000000200ULL,
0x0000000640407812ULL, 0x000fe200078e1e3dULL, 0x0000001091347824ULL, 0x000fe200078e0278ULL,
0x0000008742877212ULL, 0x000fe200078efcffULL, 0x000000001414783bULL, 0x000e620000000200ULL,
0x0000009540957212ULL, 0x000fc600078efcffULL, 0x000000005050783bULL, 0x000ea20000000200ULL,
0x0000001087407824ULL, 0x100fe400078e0278ULL, 0x00000010953c7824ULL, 0x000fe200078e0278ULL,
0x000000003838783bULL, 0x000f280000000200ULL, 0x000000004040783bULL, 0x000f680000000200ULL,
0x000000003c3c783bULL, 0x000ea80000000200ULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x0000004c4420723cULL, 0x048ff00000001820ULL, 0x0000004e4424723cULL, 0x040ff00000001824ULL,
0x000000484428723cULL, 0x040ff00000001828ULL, 0x000000144458723cULL, 0x042ff00000001858ULL,
0x000000164454723cULL, 0x040ff00000001854ULL, 0x000000504418723cULL, 0x044ff00000001818ULL,
0x00000052441c723cULL, 0x040ff0000000181cULL, 0x0000004a442c723cULL, 0x000ff0000000182cULL,
0x000000383020723cULL, 0x050fee0000001820ULL, 0x0000030066387a10ULL, 0x000fe20007ffe0ffULL,
0x000000403058723cULL, 0x020fe60000001858ULL, 0x0000000138147810ULL, 0x000fc40007ffe0ffULL,
0x0000000338157211ULL, 0x000fe400078e40ffULL, 0x000000631400720cULL, 0x000fe20003f06070ULL,
0x000000423054723cULL, 0x000fe40000001854ULL, 0x0000620002397a24ULL, 0x000fcc00078e0215ULL,
0x0000003c3018723cULL, 0x040ff00000001818ULL, 0x0000003e301c723cULL, 0x040ff0000000181cULL,
0x0000003a3024723cULL, 0x040ff00000001824ULL, 0x000000343028723cULL, 0x040ff00000001828ULL,
0x00000036302c723cULL, 0x000fe2000000182cULL, 0x0000078000008947ULL, 0x000fee0003800000ULL,
0x00000010073d7824ULL, 0x100fe200078e0278ULL, 0x0000001564377217ULL, 0x000fe20007800000ULL,
0x0000000171077824ULL, 0x100fe200078e0239ULL, 0x00000078083c7211ULL, 0x080fe200078e20ffULL,
0x00000010733f7824ULL, 0x000fe200078e00ffULL, 0x0000007869697211ULL, 0x080fe200078e20ffULL,
0x00000010133b7824ULL, 0x100fe200078e0278ULL, 0x0000003904357210ULL, 0x080fe20007ffe0ffULL,
0x0000001006417824ULL, 0x100fe200078e0278ULL, 0x000000703f3f7812ULL, 0x000fe200078ec0ffULL,
0x000000016c137824ULL, 0x000fe200078e0239ULL, 0x000000785c5c7211ULL, 0x000fe200078e20ffULL,
0x0000001011087824ULL, 0x000fe200078e0278ULL, 0x000000396e117210ULL, 0x000fe20007ffe0ffULL,
0x00005e0007067625ULL, 0x000fc800078e0070ULL, 0x0000000137377824ULL, 0x000fe200078e0a15ULL,
0x000000063f067210ULL, 0x000fe20007f1e0ffULL, 0x00000010123a7824ULL, 0x100fe400078e0278ULL,
0x000000016a157824ULL, 0x100fe200078e0239ULL, 0x000000377100720cULL, 0x080fe20003f66070ULL,
0x00005e0013127625ULL, 0x000fe200078e0070ULL, 0x000000376e00720cULL, 0x080fe40003f46070ULL,
0x000000376c00720cULL, 0x080fe20003f86070ULL, 0x0000001010367824ULL, 0x000fe200078e0278ULL,
0x000000123f127210ULL, 0x000fe20007f3e0ffULL, 0x0000000168177824ULL, 0x000fe200078e0239ULL,
0x000000376a00720cULL, 0x000fe20003fa6070ULL, 0x00005e0011107625ULL, 0x000fc800078e0070ULL,
0x00005e0015147625ULL, 0x000fc800078e0070ULL, 0x00005e0017167625ULL, 0x000fe200078e0070ULL,
0x000000143f147210ULL, 0x000fc60007fde0ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x000000103f107210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0613ULL,
0x000000163f167210ULL, 0x000fe20007f3e0ffULL, 0x0000000100337824ULL, 0x100fe200078e0239ULL,
0x00000011ff117210ULL, 0x000fe200007fe4ffULL, 0x000000106f6f7824ULL, 0x100fe200078e0278ULL,
0x000000376800720cULL, 0x000fe20003f06070ULL, 0x0000000162317824ULL, 0x000fe400078e0239ULL,
0x000000106d6d7824ULL, 0x100fe200078e0278ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000066f7faeULL, 0x0003e2000d901c46ULL, 0x000000106b6b7824ULL, 0x000fc400078e0278ULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x00000000106d7faeULL, 0x0005e2000d101c46ULL,
0x00005e0033327625ULL, 0x080fe200078e0070ULL, 0x000000370000720cULL, 0x080fe40003f46070ULL,
0x00000000126b7faeULL, 0x0007e2000e101c46ULL, 0x00005e0031307625ULL, 0x000fe200078e0070ULL,
0x000000323f327210ULL, 0x000fe40007f7e0ffULL, 0x0000000014697faeULL, 0x0009e2000e901c46ULL,
0x000000ffff177224ULL, 0x000fe200008e0617ULL, 0x000000376200720cULL, 0x080fe20003f26070ULL,
0x0000001067677824ULL, 0x100fe200078e0278ULL, 0x000000303f307210ULL, 0x000fe20007fde0ffULL,
0x000000ffff337224ULL, 0x000fe200018e0633ULL, 0x000000370500720cULL, 0x000fe20003fa6070ULL,
0x0000001061617824ULL, 0x000fe200078e0278ULL, 0x0000003905057210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff317224ULL, 0x000fe200030e0631ULL, 0x000000370400720cULL, 0x080fe20003f66070ULL,
0x0000000016677faeULL, 0x000be2000c101c46ULL, 0x000000370900720cULL, 0x080fe20003f86070ULL,
0x00005e0005047625ULL, 0x000fe200078e0070ULL, 0x000000370a00720cULL, 0x040fe20003f06070ULL,
0x0000000030617faeULL, 0x0005e4000c901c46ULL, 0x0000000109077824ULL, 0x102fe200078e0239ULL,
0x000000043f047210ULL, 0x000fe20007f3e0ffULL, 0x000000010a097824ULL, 0x000fe200078e0239ULL,
0x0000000032417faeULL, 0x0003e2000d101c46ULL, 0x00005e0035347625ULL, 0x000fc800078e0070ULL,
0x000000ffff057224ULL, 0x000fe200008e0605ULL, 0x000000370b00720cULL, 0x040fe20003f26070ULL,
0x000000010b117824ULL, 0x004fe200078e0239ULL, 0x000000343f347210ULL, 0x000fe20007fde0ffULL,
0x00005e00090a7625ULL, 0x000fc800078e0070ULL, 0x00005e0007067625ULL, 0x000fe200078e0070ULL,
0x0000000a3f127210ULL, 0x008fc60007f5e0ffULL, 0x000000010c097824ULL, 0x000fe400078e0239ULL,
0x000000ffff357224ULL, 0x000fe200030e0635ULL, 0x000000063f067210ULL, 0x000fe20007fde0ffULL,
0x00005e0011107625ULL, 0x000fc600078e0070ULL, 0x00000007ff077210ULL, 0x000fe200037fe4ffULL,
0x000000ffff137224ULL, 0x000fe200010e060bULL, 0x000000103f147210ULL, 0x010fe20007fde0ffULL,
0x00005e00090a7625ULL, 0x000fe200078e0070ULL, 0x00000000343d7faeULL, 0x0003e2000d901c46ULL,
0x000000390e097210ULL, 0x000fe40007ffe0ffULL, 0x000000010d177824ULL, 0x020fe200078e0239ULL,
0x0000000a3f167210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff157224ULL, 0x000fe200030e0611ULL,
0x00000000043c7faeULL, 0x0003e2000e901c46ULL, 0x00005e0017107625ULL, 0x000fe200078e0070ULL,
0x000000370c00720cULL, 0x000fc40003f46070ULL, 0x0000000006367faeULL, 0x0003e2000e101c46ULL,
0x000000ffff177224ULL, 0x000fe200018e060bULL, 0x000000103f0c7210ULL, 0x000fe20007fde0ffULL,
0x00005e00090a7625ULL, 0x000fe200078e0070ULL, 0x000000370d00720cULL, 0x080fe20003f66070ULL,
0x0000000012087faeULL, 0x0003e2000c101c46ULL, 0x000000370e00720cULL, 0x000fe20003f86070ULL,
0x000000010f717824ULL, 0x000fe200078e0239ULL, 0x0000000a3f0a7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e0611ULL, 0x00000000143a7faeULL, 0x0003e2000c901c46ULL,
0x00005e0071707625ULL, 0x000fc600078e0070ULL, 0x00000000163b7faeULL, 0x0003e2000d101c46ULL,
0x000000ffff0b7224ULL, 0x000fe200028e060bULL, 0x000000370f00720cULL, 0x000fe20003fa6070ULL,
0x000000105d5d7824ULL, 0x100fe200078e0278ULL, 0x000000703f107210ULL, 0x000fe20007fde0ffULL,
0x000000105e5e7824ULL, 0x000fe200078e0278ULL, 0x000000000c5c7faeULL, 0x0003e4000d901c46ULL,
0x00000071ff117210ULL, 0x000fe400037fe4ffULL, 0x000000000a5d7faeULL, 0x0003ea000e101c46ULL,
0x00000000105e7faeULL, 0x0003e2000e901c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000001006357824ULL, 0x000fe200078e0278ULL, 0x0000003968337210ULL, 0x080fe20007ffe0ffULL,
0x0000000171717824ULL, 0x100fe200078e0239ULL, 0x0000003909517210ULL, 0x080fe20007ffe0ffULL,
0x0000001073067824ULL, 0x000fe200078e00ffULL, 0x000000390e3b7210ULL, 0x000fe20007ffe0ffULL,
0x00000001044d7824ULL, 0x100fe200078e0239ULL, 0x0000007869697211ULL, 0x000fe200078e20ffULL,
0x00000001054f7824ULL, 0x000fe200078e0239ULL, 0x0000007006497812ULL, 0x000fe200078ec0ffULL,
0x00005e0071047625ULL, 0x000fc800078e0070ULL, 0x000000016e157824ULL, 0x100fe200078e0239ULL,
0x0000000449047210ULL, 0x000fe20007f1e0ffULL, 0x0000001007377824ULL, 0x000fe400078e0278ULL,
0x000000016c177824ULL, 0x000fe400078e0239ULL, 0x00005e0015067625ULL, 0x000fc800078e0070ULL,
0x000000016a317824ULL, 0x100fe400078e0239ULL, 0x0000000162457824ULL, 0x100fe400078e0239ULL,
0x00000001004b7824ULL, 0x100fe200078e0239ULL, 0x0000007813007211ULL, 0x000fe200078e20ffULL,
0x000000010a537824ULL, 0x100fe400078e0239ULL, 0x000000010b977824ULL, 0x100fe400078e0239ULL,
0x000000010c997824ULL, 0x000fc400078e0239ULL, 0x000000010d417824ULL, 0x100fe400078e0239ULL,
0x000000010f3d7824ULL, 0x000fe200078e0239ULL, 0x0000007808397211ULL, 0x000fe200078e20ffULL,
0x00005e0017087625ULL, 0x000fc800078e0070ULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000000649067210ULL, 0x000fe20007f1e0ffULL, 0x00005e00330c7625ULL, 0x000fe200078e0070ULL,
0x0000000849087210ULL, 0x040fe40007f3e0ffULL, 0x00000007ff077210ULL, 0x000fe200007fe4ffULL,
0x00000010103f7824ULL, 0x100fe200078e0278ULL, 0x0000000c490c7210ULL, 0x000fe20007f1e0ffULL,
0x0000001011437824ULL, 0x000fe400078e0278ULL, 0x00005e00450e7625ULL, 0x000fc800078e0070ULL,
0x00005e004b107625ULL, 0x000fc800078e0070ULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x0000000e490e7210ULL, 0x040fe20007f3e0ffULL, 0x0000001012477824ULL, 0x000fe400078e0278ULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x0000001049107210ULL, 0x000fe20007f1e0ffULL,
0x00005e004d127625ULL, 0x000fc600078e0070ULL, 0x00000011ff117210ULL, 0x000fe200007fe4ffULL,
0x00005e004f147625ULL, 0x000fc800078e0070ULL, 0x00005e00310a7625ULL, 0x000fe200078e0070ULL,
0x0000001449147210ULL, 0x000fc60007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x0000001249127210ULL, 0x000fe20007f3e0ffULL, 0x00005e0051307625ULL, 0x000fe200078e0070ULL,
0x0000000a490a7210ULL, 0x000fc60007f5e0ffULL, 0x00005e0097167625ULL, 0x000fc800078e0070ULL,
0x00005e0053327625ULL, 0x000fc800078e0070ULL, 0x000000106f6f7824ULL, 0x100fe400078e0278ULL,
0x000000106d6d7824ULL, 0x100fe400078e0278ULL, 0x000000ffff137224ULL, 0x000fe200008e0613ULL,
0x0000003049307210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x0000001649167210ULL, 0x000fe20007f1e0ffULL, 0x000000106b6b7824ULL, 0x100fe200078e0278ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000046f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000003249327210ULL, 0x000fe20007f5e0ffULL,
0x00005e0099447625ULL, 0x080fe200078e0070ULL, 0x00000017ff177210ULL, 0x000fe200007fe4ffULL,
0x00000000066d7faeULL, 0x0003e4000b901c46ULL, 0x00005e0041407625ULL, 0x000fe200078e0070ULL,
0x00000044493c7210ULL, 0x000fe20007f1e0ffULL, 0x00000000086b7faeULL, 0x0003e4000b901c46ULL,
0x0000001067677824ULL, 0x000fc400078e0278ULL, 0x00005e003b3a7625ULL, 0x080fe200078e0070ULL,
0x000000000a697faeULL, 0x0003e6000b901c46ULL, 0x0000001061617824ULL, 0x000fe200078e0278ULL,
0x000000000c677faeULL, 0x0003e2000b901c46ULL, 0x00005e003d707625ULL, 0x000fc600078e0070ULL,
0x000000000e617faeULL, 0x0003e2000b901c46ULL, 0x000000ffff317224ULL, 0x000fe200008e0631ULL,
0x0000004049407210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff337224ULL, 0x000fe200010e0633ULL,
0x0000003a493a7210ULL, 0x040fe20007f5e0ffULL, 0x0000000010357faeULL, 0x0003e2000b901c46ULL,
0x0000007049447210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3d7224ULL, 0x000fe400000e0645ULL,
0x0000000012377faeULL, 0x0003e2000b901c46ULL, 0x000000105c9b7824ULL, 0x000fc400078e0278ULL,
0x000000ffff417224ULL, 0x000fe200008e0641ULL, 0x0000000014397faeULL, 0x0003e2000b901c46ULL,
0x000000105d5d7824ULL, 0x100fe400078e0278ULL, 0x000000ffff3b7224ULL, 0x000fe200010e063bULL,
0x00000000303f7faeULL, 0x0003e2000b901c46ULL, 0x000000105e9d7824ULL, 0x000fe400078e0278ULL,
0x000000ffff457224ULL, 0x000fe200018e0671ULL, 0x0000000032437faeULL, 0x0003e8000b901c46ULL,
0x0000000016477faeULL, 0x0003e8000b901c46ULL, 0x000000003c007faeULL, 0x0003e8000b901c46ULL,
0x00000000409b7faeULL, 0x0003e8000b901c46ULL, 0x000000003a5d7faeULL, 0x0003e8000b901c46ULL,
0x00000000449d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000085f057810ULL, 0x002fc40007ffe0ffULL, 0x0000300079007810ULL, 0x000fe40007ffe0ffULL,
0x0000000705057812ULL, 0x000fe400078e7860ULL, 0x0000000a5f117810ULL, 0x000fe20007ffe0ffULL,
0x000000107b087824ULL, 0x100fe200078e0200ULL, 0x0000000560057211ULL, 0x000fe200078e20ffULL,
0x00000010770c7824ULL, 0x000fe200078e0200ULL, 0x0000000711117812ULL, 0x000fe200078e7860ULL,
0x0000001076107824ULL, 0x100fe400078e0200ULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x0000001160117211ULL, 0x000fe200078e20ffULL, 0x000000107f347824ULL, 0x000fc400078e0200ULL,
0x0000001074307824ULL, 0x100fe400078e0200ULL, 0x0000001011147824ULL, 0x000fe400078e00ffULL,
0x0000001095447824ULL, 0x000fe200078e0200ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000808783bULL, 0x000fe20000000200ULL, 0x00000010933c7824ULL, 0x100fe400078e0200ULL,
0x0000001087407824ULL, 0x100fe200078e0200ULL, 0x000000000504783bULL, 0x000e680000000200ULL,
0x000000000c0c783bULL, 0x000ea80000000200ULL, 0x000000001010783bULL, 0x000ee80000000200ULL,
0x000000003434783bULL, 0x000f280000000200ULL, 0x000000001414783bULL, 0x000fe80000000200ULL,
0x000000003030783bULL, 0x000fe80000000200ULL, 0x000000004444783bULL, 0x000fe80000000200ULL,
0x000000003c3c783bULL, 0x000fe80000000200ULL, 0x000000004040783bULL, 0x000fe20000000200ULL,
0x000000080458723cULL, 0x042fee0000001858ULL, 0x0000001081087824ULL, 0x100fe200078e0200ULL,
0x0000000a0454723cULL, 0x040fea0000001854ULL, 0x000000000808783bULL, 0x000e660000000200ULL,
0x0000000c0418723cULL, 0x044fee0000001818ULL, 0x00000000830c7211ULL, 0x080fe200078e20ffULL,
0x0000000e041c723cULL, 0x040fea000000181cULL, 0x000000000c0c783bULL, 0x000ea60000000200ULL,
0x000000100420723cULL, 0x048ff00000001820ULL, 0x000000120424723cULL, 0x040ff00000001824ULL,
0x000000340428723cULL, 0x050fee0000001828ULL, 0x000000008d347211ULL, 0x000fe200078e20ffULL,
0x00000036042c723cULL, 0x000fea000000182cULL, 0x000000003434783bULL, 0x000fe40000000200ULL,
0x0000001085047824ULL, 0x100fe200078e0200ULL, 0x000000081418723cULL, 0x042fea0000001818ULL,
0x000000000404783bULL, 0x000e640000000200ULL, 0x0000000c5f097810ULL, 0x000fe20007ffe0ffULL,
0x000000301458723cULL, 0x000fe20000001858ULL, 0x000000108f087824ULL, 0x000fe200078e0200ULL,
0x0000000e5f5f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000709097812ULL, 0x100fe400078e7860ULL,
0x000000075f5f7812ULL, 0x000fe200078e7860ULL, 0x000000108b307824ULL, 0x100fe200078e0200ULL,
0x0000000c1420723cULL, 0x044fe20000001820ULL, 0x0000001060097824ULL, 0x040fe400078e0209ULL,
0x00000010605f7824ULL, 0x000fe400078e025fULL, 0x0000001009107824ULL, 0x000fe400078e00ffULL,
0x00000010890c7824ULL, 0x100fe200078e0200ULL, 0x000000321454723cULL, 0x040fe20000001854ULL,
0x000000003030783bULL, 0x000fe80000000200ULL, 0x000000001010783bULL, 0x000ea60000000200ULL,
0x0000000a141c723cULL, 0x040fe2000000181cULL, 0x000000000808783bULL, 0x000eee0000000200ULL,
0x0000000e1424723cULL, 0x040fe20000001824ULL, 0x000000000c0c783bULL, 0x000f2e0000000200ULL,
0x000000041428723cULL, 0x042fee0000001828ULL, 0x000000045f047819ULL, 0x000fe200000006ffULL,
0x00000006142c723cULL, 0x000fea000000182cULL, 0x000000000404783bULL, 0x000e640000000200ULL,
0x0000001091147824ULL, 0x000fcc00078e0200ULL, 0x000000001414783bULL, 0x000f620000000200ULL,
0x000000341018723cULL, 0x044ff00000001818ULL, 0x000000081058723cULL, 0x048ff00000001858ULL,
0x0000000a1054723cULL, 0x040ff00000001854ULL, 0x000000301020723cULL, 0x040ff00000001820ULL,
0x00000036101c723cULL, 0x040ff0000000181cULL, 0x000000321024723cULL, 0x040ff00000001824ULL,
0x0000000c1008723cULL, 0x050ff00000001828ULL, 0x0000000e102c723cULL, 0x000ff0000000182cULL,
0x000000440410723cULL, 0x042ff00000001818ULL, 0x0000003c040c723cULL, 0x040ff00000001820ULL,
0x000000400458723cULL, 0x040ff00000001858ULL, 0x000000420454723cULL, 0x040ff00000001854ULL,
0x000000460444723cULL, 0x040ff0000000181cULL, 0x0000003e043c723cULL, 0x040ff00000001824ULL,
0x000000140408723cULL, 0x060ff00000001808ULL, 0x000000160404723cULL, 0x000fe2000000182cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x000000007a147f8cULL, 0x000fe2000c80043fULL,
0x3db504f35b5b7820ULL, 0x000fc40000410000ULL, 0x3db504f35a5a7820ULL, 0x000fe20000410000ULL,
0x000004007a297984ULL, 0x000e620000000800ULL, 0x3db504f356567820ULL, 0x000fe40000410000ULL,
0x3db504f357577820ULL, 0x000fe40000410000ULL, 0x3db504f30a0a7820ULL, 0x000fe40000410000ULL,
0x3db504f310267820ULL, 0x000fe40000410000ULL, 0x3db504f312187820ULL, 0x000fc40000410000ULL,
0x3db504f313197820ULL, 0x000fe40000410000ULL, 0x3db504f311257820ULL, 0x000fe40000410000ULL,
0x3db504f30c227820ULL, 0x000fe40000410000ULL, 0x3db504f30d217820ULL, 0x000fe20000410000ULL,
0x0000005b000d7202ULL, 0x000fe20000000f00ULL, 0x3db504f30e127820ULL, 0x000fe40000410000ULL,
0x3db504f30f137820ULL, 0x000fc40000410000ULL, 0x3db504f3091d7820ULL, 0x000fe40000410000ULL,
0x3db504f30b107820ULL, 0x000fe40000410000ULL, 0x3db504f358587820ULL, 0x000fe40000410000ULL,
0x3db504f359597820ULL, 0x000fe40000410000ULL, 0x3db504f354287820ULL, 0x000fe40000410000ULL,
0x3db504f355277820ULL, 0x000fc40000410000ULL, 0x3db504f344247820ULL, 0x000fe40000410000ULL,
0x3db504f345237820ULL, 0x000fe40000410000ULL, 0x3db504f3461a7820ULL, 0x000fe20000410000ULL,
0x8000000029ff7812ULL, 0x002fe20007804815ULL, 0x3db504f347177820ULL, 0x000fe40000410000ULL,
0x3db504f33c207820ULL, 0x000fe40000410000ULL, 0x3db504f33d1f7820ULL, 0x000fc40000410000ULL,
0x3db504f33e167820ULL, 0x000fe40000410000ULL, 0x3db504f33f117820ULL, 0x000fe40000410000ULL,
0x3db504f3081e7820ULL, 0x000fe40000410000ULL, 0x3db504f3041c7820ULL, 0x000fe40000410000ULL,
0x3db504f3051b7820ULL, 0x000fe40000410000ULL, 0x3db504f306097820ULL, 0x000fc40000410000ULL,
0x3db504f307077820ULL, 0x000fe40000410000ULL, 0x000000ffff0c7224ULL, 0x000fe400078e005aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0056ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0057ULL,
0x000000ffff0b7224ULL, 0x000fe200078e000aULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0007ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e00000000007802ULL, 0x000fc80000000f00ULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x000004007a057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000473007824ULL, 0x000fe200078e00ffULL, 0x0000007d6600720cULL, 0x000fc80003f05270ULL,
0xfffffff000087812ULL, 0x000fca00078ec0ffULL, 0x0000008065087824ULL, 0x000fca00078e0208ULL,
0x01b4000008047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000273147824ULL, 0x000fe400078e00ffULL, 0x00000001642c7824ULL, 0x000fc600078e0a75ULL,
0x0000000614147812ULL, 0x000fc800078ec0ffULL, 0x0000000114157812ULL, 0x040fe400078efcffULL,
0x0000000814297812ULL, 0x040fe400078efcffULL, 0x0000002c1500720cULL, 0x080fe40003f26070ULL,
0x0000001014157812ULL, 0x000fe400078efcffULL, 0x0000002c2900720cULL, 0x080fe40003f06070ULL,
0x0000002c1500720cULL, 0x000fc40003fc6070ULL, 0x0000001114297812ULL, 0x040fe400078efcffULL,
0x0000001814157812ULL, 0x040fe400078efcffULL, 0x0000002c1400720cULL, 0x0c0fe40003f46070ULL,
0x0000002c2900720cULL, 0x080fe40003fa6070ULL, 0x0000002c1500720cULL, 0x000fe40003f66070ULL,
0x00000009142a7812ULL, 0x000fc400078efcffULL, 0x0000001914297812ULL, 0x040fe400078efcffULL,
0x0000002014157812ULL, 0x000fe400078efcffULL, 0xff7fffff0c0c7808ULL, 0x000fe40005000000ULL,
0xff7fffff58587808ULL, 0x000fe40005000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40004800000ULL,
0xff7fffff59597808ULL, 0x000fc40004800000ULL, 0x0000002c2a00720cULL, 0x080fe40003f86070ULL,
0x0000002c2900720cULL, 0x080fe40003f46070ULL, 0x0000002c1500720cULL, 0x000fe40003f26070ULL,
0x0000002114297812ULL, 0x040fe400078efcffULL, 0x0000002814157812ULL, 0x000fe400078efcffULL,
0xff7fffff0e0e7808ULL, 0x000fc40004000000ULL, 0xff7fffff28287808ULL, 0x000fe40004000000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40006000000ULL, 0xff7fffff27277808ULL, 0x000fe40006000000ULL,
0x0000002c2900720cULL, 0x080fe40003f06070ULL, 0x0000002c1500720cULL, 0x000fe40003f86070ULL,
0x0000002914297812ULL, 0x000fc400078efcffULL, 0x0000003014157812ULL, 0x000fe400078efcffULL,
0xff7fffff18187808ULL, 0x000fe40007000000ULL, 0xff7fffff26267808ULL, 0x000fe40007000000ULL,
0xff7fffff19197808ULL, 0x000fe40006800000ULL, 0xff7fffff25257808ULL, 0x000fe40006800000ULL,
0x0000002c2900720cULL, 0x000fc40003fc6070ULL, 0x0000002c1500720cULL, 0x000fe40003fa6070ULL,
0x0000003114297812ULL, 0x040fe400078efcffULL, 0x0000003814157812ULL, 0x040fe400078efcffULL,
0x0000003914147812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005800000ULL,
0xff7fffff24247808ULL, 0x000fc40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005000000ULL,
0xff7fffff23237808ULL, 0x000fe40005000000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0xff7fffff22227808ULL, 0x000fe40004800000ULL, 0x0000002c2900720cULL, 0x080fe40003f66070ULL,
0x0000002c1500720cULL, 0x000fc40003f46070ULL, 0x0000002c1400720cULL, 0x000fe40003f26070ULL,
0xff7fffff13137808ULL, 0x000fe40004000000ULL, 0xff7fffff21217808ULL, 0x000fe40004000000ULL,
0xff7fffff16167808ULL, 0x000fe40006000000ULL, 0xff7fffff20207808ULL, 0x000fe40006000000ULL,
0xff7fffff11117808ULL, 0x000fc40007000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40006800000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40006800000ULL,
0xff7fffff10107808ULL, 0x000fe40005800000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40005800000ULL,
0xff7fffff09097808ULL, 0x000fc40005000000ULL, 0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL,
0xff7fffff0a0a7808ULL, 0x000fe40004800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0x0000005804047209ULL, 0x004fe40007810000ULL, 0x0000000c05147209ULL, 0x000fe40007810000ULL,
0x0000005904057209ULL, 0x000fe40007810000ULL, 0x0000000d14157209ULL, 0x000fc40007810000ULL,
0x0000002805047209ULL, 0x000fe40007810000ULL, 0x0000000e15147209ULL, 0x000fe40007810000ULL,
0x0000002704057209ULL, 0x000fe40007810000ULL, 0x0000000f14157209ULL, 0x000fe40007810000ULL,
0x0000002605047209ULL, 0x000fe40007810000ULL, 0x0000001815147209ULL, 0x000fc40007810000ULL,
0x0000002504057209ULL, 0x000fe40007810000ULL, 0x0000001914157209ULL, 0x000fe40007810000ULL,
0x0000002405047209ULL, 0x000fe40007810000ULL, 0x0000001a15147209ULL, 0x000fe40007810000ULL,
0x0000002304057209ULL, 0x000fe40007810000ULL, 0x0000001714157209ULL, 0x000fc40007810000ULL,
0x0000002205047209ULL, 0x000fe40007810000ULL, 0x0000001215147209ULL, 0x000fe40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x0000001314157209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x0000001615147209ULL, 0x000fc40007810000ULL,
0x0000001f04057209ULL, 0x000fe40007810000ULL, 0x0000001114147209ULL, 0x000fe40007810000ULL,
0x0000001e05047209ULL, 0x000fe40007810000ULL, 0x0000000b14057209ULL, 0x000fe40007810000ULL,
0x0000001d04157209ULL, 0x000fe40007810000ULL, 0x0000001005047209ULL, 0x000fc40007810000ULL,
0x0000001c15147209ULL, 0x000fe40007810000ULL, 0x0000000904057209ULL, 0x000fe40007810000ULL,
0x0000001b14297209ULL, 0x000fe40007810000ULL, 0x0000000a052d7209ULL, 0x000fe20007810000ULL,
0x000018127f007947ULL, 0x000fea000b800000ULL, 0x0c401f0029047f89ULL, 0x0004e400000e0000ULL,
0x00000004292e7209ULL, 0x008fe20007810000ULL, 0x000018627f007947ULL, 0x000fea000b800000ULL,
0x0c401f002d047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000f2800000e0000ULL,
0x0c401f0007147f89ULL, 0x000f6200000e0000ULL, 0x000000042d157209ULL, 0x008fc60007810000ULL,
0x0c201f002e047f89ULL, 0x000ee200000e0000ULL, 0x0000000506297209ULL, 0x014fc60007810000ULL,
0x0c201f00152a7f89ULL, 0x000ea200000e0000ULL, 0x0000001407147209ULL, 0x020fc60007810000ULL,
0x0c201f00292c7f89ULL, 0x002e6800000e0000ULL, 0x0c201f00142b7f89ULL, 0x00092200000e0000ULL,
0x000000042e047209ULL, 0x008fe40007810000ULL, 0x0000002a15057209ULL, 0x004fe40007810000ULL,
0x0000002c29067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3c003c0000357802ULL, 0x000fe20000000f00ULL, 0x3fb8aa3b052d7820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010807ULL,
0x0000000000057886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b1d1d7823ULL, 0x000fc40000010807ULL,
0x0000001f00157308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b58587823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b59597823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010807ULL, 0x0000001d002a7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1c1c7823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b0e1f7823ULL, 0x104fe4000001082dULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe2000001082dULL,
0x0000001e00297308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b0f1d7823ULL, 0x008fe4000001082dULL, 0x3fb8aa3b26267823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL, 0x0000001c002c7308ULL, 0x002fe20000000800ULL,
0x3fb8aa3b24247823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b23237823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b22227823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL,
0x0000005800587308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b1b077823ULL, 0x000fe40000010807ULL, 0x3c003c00ff347424ULL, 0x000fc400078e00ffULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001082dULL, 0x0000005900597308ULL, 0x000e620000000800ULL,
0x3fb8aa3b18187823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b17177823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001082dULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b12127823ULL, 0x000fc4000001082dULL,
0x3fb8aa3b13137823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b09097823ULL, 0x100fe2000001082dULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b0a0a7823ULL, 0x000fce000001082dULL, 0x0000000c001b7308ULL, 0x0003f00000000800ULL,
0x0000000d001e7308ULL, 0x000ee20000000800ULL, 0x00000058590c723eULL, 0x002fe400000000ffULL,
0x00000028270e723eULL, 0x004fca00000000ffULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x0000001d001c7308ULL, 0x000e620000000800ULL, 0x0000001b1e0d723eULL, 0x008fce00000000ffULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x0000001f1c0f723eULL, 0x002fce00000000ffULL,
0x0000002500257308ULL, 0x000e620000000800ULL, 0x000000340c1c723cULL, 0x000fee00000018ffULL,
0x0000002400247308ULL, 0x000ff00000000800ULL, 0x0000002300237308ULL, 0x000eb00000000800ULL,
0x00000018002e7308ULL, 0x0003f00000000800ULL, 0x0000001900197308ULL, 0x000ee20000000800ULL,
0x000000262518723eULL, 0x002fce00000000ffULL, 0x0000001a001b7308ULL, 0x0005f00000000800ULL,
0x0000001700287308ULL, 0x0003620000000800ULL, 0x00000024231a723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b10237823ULL, 0x000fe2000001082dULL, 0x0000002e1919723eULL, 0x008fca00000000ffULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b11177823ULL, 0x002fe2000001082dULL,
0x0000001b281b723eULL, 0x020fcc00000000ffULL, 0x0000002100217308ULL, 0x000e620000000800ULL,
0x00000034181c723cULL, 0x000fee000000181cULL, 0x0000002000207308ULL, 0x000eb00000000800ULL,
0x0000001200277308ULL, 0x0005e20000000800ULL, 0x000000222110723eULL, 0x002fce00000000ffULL,
0x0000001300307308ULL, 0x000e620000000800ULL, 0x000000201512723eULL, 0x004fe400000000ffULL,
0xfffffffc73157812ULL, 0x000fca00078ec0ffULL, 0x0000001600167308ULL, 0x000ff00000000800ULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0x000000273011723eULL, 0x002fce00000000ffULL,
0x0000000700077308ULL, 0x000e620000000800ULL, 0x000000161713723eULL, 0x004fe200000000ffULL,
0x0000000fff167424ULL, 0x000fcc00078e00ffULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x0000001516167219ULL, 0x000fe200000006ffULL, 0x000000341030723cULL, 0x000fec000000181cULL,
0x0000002300247308ULL, 0x000ea20000000800ULL, 0x00000000161573a1ULL, 0x000ee200000e8000ULL,
0x00000000160473c4ULL, 0x000f620000004000ULL, 0x000000292a1c723eULL, 0x000fc400000000ffULL,
0x0000002c071e723eULL, 0x002fc600000000ffULL, 0x0000000900097308ULL, 0x000fe20000000800ULL,
0x000000142b077209ULL, 0x010fce0007810000ULL, 0x0000000a000a7308ULL, 0x000e620000000800ULL,
0x0000000b241d723eULL, 0x004fe400000000ffULL, 0x0000000516ff7c12ULL, 0x008fe4000f804015ULL,
0x000000090a1f723eULL, 0x002fce00000000ffULL, 0x000000341c30723cULL, 0x000fe80000001830ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0000148204008947ULL, 0x020fde000b800000ULL,
0x001c1fff30207589ULL, 0x0002a400000e0000ULL, 0x00000000160973a1ULL, 0x000ee200000e8000ULL,
0x00000000160473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x0000000516ff7c12ULL, 0x008fda000f804009ULL, 0x000014a204008947ULL, 0x010fea000b800000ULL,
0x001c1fff32217589ULL, 0x00072800000e0000ULL, 0x001c1fff01227589ULL, 0x00066800000e0000ULL,
0x001c1fff23237589ULL, 0x0006a400000e0000ULL, 0x00000002ff097819ULL, 0x000fe40000011673ULL,
0x0000000c00337812ULL, 0x000fc400078ec0ffULL, 0x00000007090a7812ULL, 0x040fe200078ec0ffULL,
0x0000000809177824ULL, 0x040fe200078e00ffULL, 0x00000003090b7819ULL, 0x040fe200000006ffULL,
0x00000008092e7824ULL, 0x040fe200078e00ffULL, 0x00000009ff157212ULL, 0x000fe400078e33ffULL,
0x0000000809097810ULL, 0x000fe40007ffe0ffULL, 0xfffffff817147812ULL, 0x100fe400078ee20aULL,
0x000000010b167812ULL, 0x10afe200078ef60aULL, 0x0000000809407824ULL, 0x000fe200078e00ffULL,
0x000000020b247812ULL, 0x100fe200078ef60aULL, 0x0000000809177824ULL, 0x000fe200078e00ffULL,
0x000000030b267812ULL, 0x000fc400078ef60aULL, 0x000000040b287812ULL, 0x140fe400078ef60aULL,
0x000000050b2a7812ULL, 0x140fe400078ef60aULL, 0x000000060b2c7812ULL, 0x000fe200078ef60aULL,
0x00000008090b7824ULL, 0x040fe200078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe400078ee215ULL,
0x00000009ff157212ULL, 0x000fe400078e33ffULL, 0x00000007090a7812ULL, 0x000fc400078ec0ffULL,
0x0001100065097811ULL, 0x000fe400078e58ffULL, 0xfffffff817307812ULL, 0x100fe400078ee20aULL,
0x0000000914007211ULL, 0x000fe200078e20ffULL, 0x0000001024147824ULL, 0x000fe200078e0209ULL,
0xfffffff840407812ULL, 0x000fe200078ee215ULL, 0x0000001028247824ULL, 0x100fe200078e0209ULL,
0x000000010b327812ULL, 0x140fe200078ef60aULL, 0x000000102c287824ULL, 0x100fe200078e0209ULL,
0x000000020b347812ULL, 0x000fe200078ef60aULL, 0x0000000133157824ULL, 0x000fe200078e0214ULL,
0x000000030b367812ULL, 0x000fe200078ef60aULL, 0x0000000133297824ULL, 0x000fe200078e0228ULL,
0x000000040b3a7812ULL, 0x140fe200078ef60aULL, 0x00000010342d7824ULL, 0x000fe200078e0209ULL,
0x000000050b3c7812ULL, 0x000fc400078ef60aULL, 0x000000060b3e7812ULL, 0x000fe200078ef60aULL,
0x00000010160a7824ULL, 0x100fe200078e0209ULL, 0x00000009322c7211ULL, 0x080fe200078e20ffULL,
0x0000001026167824ULL, 0x100fe200078e0209ULL, 0x000000092a267211ULL, 0x080fe200078e20ffULL,
0x00000001330b7824ULL, 0x040fe200078e0200ULL, 0x000000093e317211ULL, 0x000fe200078e20ffULL,
0x000000102e2a7824ULL, 0x100fe200078e0209ULL, 0x0000002433257210ULL, 0x000fe20007ffe0ffULL,
0x0000001030007824ULL, 0x100fe200078e0209ULL, 0x0000000c0b007388ULL, 0x0003e20000000800ULL,
0x00000010362e7824ULL, 0x100fe200078e0209ULL, 0x0000000373ff7812ULL, 0x000fe2000780c0ffULL,
0x000000103a2f7824ULL, 0x100fe200078e0209ULL, 0x0000002c332c7210ULL, 0x040fe20007ffe0ffULL,
0x000000103c307824ULL, 0x100fe200078e0209ULL, 0x0000003133147210ULL, 0x000fe20007ffe0ffULL,
0x0000001040327824ULL, 0x000fc400078e0209ULL, 0x0000000133097824ULL, 0x040fe400078e020aULL,
0x0000000133177824ULL, 0x040fe400078e0216ULL, 0x0000000133277824ULL, 0x040fe200078e0226ULL,
0x0000000e09007388ULL, 0x0007e20000000800ULL, 0x00000001332b7824ULL, 0x040fe400078e022aULL,
0x0000000133007824ULL, 0x040fe200078e0200ULL, 0x0000001815007388ULL, 0x0007e20000000800ULL,
0x00000001330a7824ULL, 0x000fc400078e022dULL, 0x00000001332e7824ULL, 0x040fe200078e022eULL,
0x0000001a17007388ULL, 0x0007e20000000800ULL, 0x00000001330c7824ULL, 0x042fe400078e022fULL,
0x0000000133307824ULL, 0x040fe200078e0230ULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x0000000133327824ULL, 0x000fc600078e0232ULL, 0x0000001227007388ULL, 0x0007e80000000800ULL,
0x0000001c29007388ULL, 0x0007e80000000800ULL, 0x0000001e2b007388ULL, 0x0007e80000000800ULL,
0x0000000d00007388ULL, 0x0007e80000000800ULL, 0x0000000f2c007388ULL, 0x0007e80000000800ULL,
0x000000190a007388ULL, 0x0007e80000000800ULL, 0x0000001b2e007388ULL, 0x0007e80000000800ULL,
0x000000110c007388ULL, 0x0007e80000000800ULL, 0x0000001330007388ULL, 0x0007e80000000800ULL,
0x0000001d14007388ULL, 0x0007e80000000800ULL, 0x0000001f32007388ULL, 0x0007e80000000800ULL,
0x01b0000408008388ULL, 0x0007e80000000c00ULL, 0x01b2002008008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6080072ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6100072ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6180072ff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000633800720cULL, 0x000fe20003f06070ULL,
0x01b6200072ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff667224ULL, 0x000fd600078e0038ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb6a000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff147807ULL, 0x004fe20004000000ULL,
0xffffffffff157424ULL, 0x000fe200078e00ffULL, 0x00010bd0001d7802ULL, 0x000fe40000000f00ULL,
0x0000107000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff027224ULL, 0x000fe200078e001cULL,
0xffff148000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20004800000ULL,
0xffffffffff157424ULL, 0x000fe200078e00ffULL, 0x00010c30001d7802ULL, 0x000fe40000000f00ULL,
0x0000101000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff027224ULL, 0x000fe200078e001cULL,
0xffff14b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff257224ULL, 0x000fe200078e0002ULL,
0x0000001f00267802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x00010ca000147802ULL, 0x000fe40000000f00ULL, 0x00000f6000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0023ULL, 0xffff150000007947ULL, 0x000fea000383ffffULL,
0x000000ffff257224ULL, 0x000fe200078e0002ULL, 0x00010d1000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff267424ULL, 0x000fc400078e00ffULL, 0xffffffffff277424ULL, 0x000fe400078e00ffULL,
0x00000ef000007944ULL, 0x00cfea0003c00000ULL, 0x0000002300027202ULL, 0x004fe20000000f00ULL,
0xffff14c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff257224ULL, 0x000fe200078e000bULL,
0x00010d8000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff267424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fe400078e00ffULL, 0x00000e8000007944ULL, 0x008fea0003c00000ULL,
0x000000080b0a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff6b7224ULL, 0x004fe200078e0023ULL,
0x0000001f00267802ULL, 0x002fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x00010df000147802ULL, 0x000fe20000000f00ULL, 0x000000ffff257224ULL, 0x000fc400078e000aULL,
0x00000e1000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff687224ULL, 0x004fe200078e0023ULL,
0xffff16e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x004fe20004000000ULL,
0xffffffffff157424ULL, 0x000fe200078e00ffULL, 0x00010e50001d7802ULL, 0x000fc40000000f00ULL,
0x00000df000007944ULL, 0x008fea0003c00000ULL, 0x0000001c00147202ULL, 0x000fe20000000f00ULL,
0xffff2a6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20004800000ULL,
0xffffffffff157424ULL, 0x000fe200078e00ffULL, 0x00010eb0001d7802ULL, 0x000fc40000000f00ULL,
0x00000d9000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e001cULL,
0xffff2a9000007947ULL, 0x000fea000383ffffULL, 0x0000001f00267802ULL, 0x002fe20000000f00ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x00010f1000147802ULL, 0x000fc40000000f00ULL,
0x00000cf000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0023ULL,
0xffff2b0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff257224ULL, 0x002fe200078e000aULL,
0x00010f8000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff267424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fe400078e00ffULL, 0x00000c8000007944ULL, 0x008fea0003c00000ULL,
0x0000002300147202ULL, 0x004fe20000000f00ULL, 0xffff2bb000007947ULL, 0x000fea000383ffffULL,
0x0000001fff267424ULL, 0x000fe200078e00ffULL, 0x00010fe000147802ULL, 0x000fe20000000f00ULL,
0xffffffffff277424ULL, 0x000fe400078e00ffULL, 0x00000c2000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff6b7224ULL, 0x004fe200078e0023ULL, 0xffffffff00277802ULL, 0x002fe20000000f00ULL,
0x000000ffff257224ULL, 0x000fe200078e000aULL, 0x0001104000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff267424ULL, 0x000fe400078e00ffULL, 0x00000bc000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff6c7224ULL, 0x004fe200078e0023ULL, 0xffff2cf000007947ULL, 0x000fea000383ffffULL,
0x00000001ff147807ULL, 0x004fe20004000000ULL, 0xffffffffff157424ULL, 0x000fe200078e00ffULL,
0x000110a0001d7802ULL, 0x000fc40000000f00ULL, 0x00000ba000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e001cULL, 0xffff3d8000007947ULL, 0x000fea000383ffffULL,
0x00000001ff147807ULL, 0x000fe40004800000ULL, 0xffffffff00157802ULL, 0x000fc40000000f00ULL,
0x00011100001d7802ULL, 0x000fe40000000f00ULL, 0x00000b4000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e001cULL, 0xffff3db000007947ULL, 0x000fea000383ffffULL,
0x0000001fff267424ULL, 0x002fe200078e00ffULL, 0xffffffff00277802ULL, 0x000fe40000000f00ULL,
0x0001116000147802ULL, 0x000fe40000000f00ULL, 0x00000aa000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0023ULL, 0xffff3e2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff257224ULL, 0x002fe200078e000aULL, 0x000111d000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff267424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fe400078e00ffULL,
0x00000a3000007944ULL, 0x008fea0003c00000ULL, 0x0000002300147202ULL, 0x004fe20000000f00ULL,
0xffff3ed000007947ULL, 0x000fea000383ffffULL, 0x0000001fff267424ULL, 0x000fe200078e00ffULL,
0x0001123000147802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x000009d000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff697224ULL, 0x004fe200078e0023ULL,
0x0000001f00267802ULL, 0x002fe20000000f00ULL, 0x000000ffff257224ULL, 0x000fe200078e000aULL,
0x0001129000147802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000097000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff6c7224ULL, 0x004fe200078e0023ULL,
0xffff401000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x004fe20004000000ULL,
0xffffffffff157424ULL, 0x000fe200078e00ffULL, 0x000112f0001d7802ULL, 0x000fc40000000f00ULL,
0x0000095000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff077224ULL, 0x000fe200078e001cULL,
0xffff50b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe40004800000ULL,
0xffffffff00157802ULL, 0x000fc40000000f00ULL, 0x00011350001d7802ULL, 0x000fe40000000f00ULL,
0x000008f000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff077224ULL, 0x000fe200078e001cULL,
0xffff50e000007947ULL, 0x000fea000383ffffULL, 0x0000001fff267424ULL, 0x002fe200078e00ffULL,
0xffffffff00277802ULL, 0x000fe40000000f00ULL, 0x000113b000147802ULL, 0x000fe40000000f00ULL,
0x0000085000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0023ULL,
0xffff515000007947ULL, 0x000fea000383ffffULL, 0x000000ffff257224ULL, 0x002fe200078e000aULL,
0x0001142000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff267424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fe400078e00ffULL, 0x000007e000007944ULL, 0x008fea0003c00000ULL,
0x0000002300067202ULL, 0x004fe20000000f00ULL, 0xffff520000007947ULL, 0x000fea000383ffffULL,
0x0000001fff267424ULL, 0x000fe200078e00ffULL, 0x0001148000147802ULL, 0x000fe20000000f00ULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000078000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0023ULL, 0x0000000a00257202ULL, 0x002fe20000000f00ULL,
0x0000001fff267424ULL, 0x000fe200078e00ffULL, 0x000114e000147802ULL, 0x000fe20000000f00ULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000072000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e0023ULL, 0xffff534000007947ULL, 0x000fea000383ffffULL,
0x0000002900157202ULL, 0x000fe20000000f00ULL, 0x00000002ff2c7424ULL, 0x000fe200078e00ffULL,
0x00011560002a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff2f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x0000066000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0015ULL, 0xffffe78000007947ULL, 0x000fea000383ffffULL,
0x0000002d00157202ULL, 0x000fe20000000f00ULL, 0x00000002ff2c7424ULL, 0x002fe200078e00ffULL,
0x000115e0002a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x000005e000007944ULL, 0x004fea0003c00000ULL,
0x000000152d307209ULL, 0x004fe20007810000ULL, 0x000000ffff157224ULL, 0x000fe200078e0006ULL,
0x00000002002c7802ULL, 0x002fe20000000f00ULL, 0x0000001fff2f7424ULL, 0x000fe200078e00ffULL,
0x00011650002a7802ULL, 0x000fe20000000f00ULL, 0xffffffffff327424ULL, 0x000fc400078e00ffULL,
0x0000057000007944ULL, 0x000fea0003c00000ULL, 0x0000001506067209ULL, 0x004fe20007810000ULL,
0x000000ffff157224ULL, 0x000fe200078e0007ULL, 0x0000001f002f7802ULL, 0x002fe20000000f00ULL,
0x00000002ff2c7424ULL, 0x000fe200078e00ffULL, 0x000116c0002a7802ULL, 0x000fe20000000f00ULL,
0xffffffffff327424ULL, 0x000fc400078e00ffULL, 0x0000050000007944ULL, 0x000fea0003c00000ULL,
0x0000001507147209ULL, 0x004fe20007810000ULL, 0x000000ffff157224ULL, 0x000fe200078e002eULL,
0xffffffff00327802ULL, 0x002fe20000000f00ULL, 0x00000001ff2c7424ULL, 0x000fe200078e00ffULL,
0x00011730002a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff2f7424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x000000152e047209ULL, 0x004fe20007810000ULL,
0x000000ffff157224ULL, 0x000fe200078e0030ULL, 0x000117a0002a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2c7424ULL, 0x002fc400078e00ffULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x0000042000007944ULL, 0x000fea0003c00000ULL,
0x0000001530057209ULL, 0x004fe20007810000ULL, 0x00000001ff2c7424ULL, 0x002fe200078e00ffULL,
0x0000000600157202ULL, 0x000fe20000000f00ULL, 0x0000001fff2f7424ULL, 0x000fe200078e00ffULL,
0x00011810002a7802ULL, 0x000fe20000000f00ULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x000003b000007944ULL, 0x000fea0003c00000ULL, 0x0000001506067209ULL, 0x004fe20007810000ULL,
0x000000ffff157224ULL, 0x000fe200078e0014ULL, 0x00000001002c7802ULL, 0x002fe20000000f00ULL,
0x0000001fff2f7424ULL, 0x000fe200078e00ffULL, 0x00011880002a7802ULL, 0x000fe20000000f00ULL,
0xffffffffff327424ULL, 0x000fc400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2b7224ULL, 0x004fe200078e0015ULL, 0xffffe55000007947ULL, 0x000fea000383ffffULL,
0x000000ffff247224ULL, 0x000fe200078e0030ULL, 0x0000001600277202ULL, 0x000fe20000000f00ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x0001190000147802ULL, 0x000fe20000000f00ULL,
0x00001c1fff267424ULL, 0x000fc400078e00ffULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff207224ULL, 0x004fe200078e0023ULL, 0xffffeb1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff247224ULL, 0x002fe200078e0032ULL, 0x0000001600277202ULL, 0x000fe20000000f00ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x0001198000147802ULL, 0x000fe20000000f00ULL,
0x00001c1fff267424ULL, 0x000fc400078e00ffULL, 0x0000028000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff257224ULL, 0x002fe200078e00ffULL, 0x000119e000147802ULL, 0x000fe20000000f00ULL,
0x00001c1fff267424ULL, 0x000fc400078e00ffULL, 0x000000ffff277224ULL, 0x000fe400078e0016ULL,
0x000000ffff217224ULL, 0x004fe400078e0023ULL, 0x0000022000007944ULL, 0x000fea0003c00000ULL,
0x0000001600277202ULL, 0x002fe20000000f00ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x00011a4000147802ULL, 0x000fe20000000f00ULL, 0x00001c1fff267424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x004fe400078e0023ULL, 0x000001c000007944ULL, 0x000fea0003c00000ULL,
0xffffea6000007947ULL, 0x000fea000383ffffULL, 0x0180000054037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000005400038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff067807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000306ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff54ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000054057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000306ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000005400037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffee44004007950ULL, 0x000fea0003c3ffffULL,
0x00000000002b7802ULL, 0x000fe20000000f00ULL, 0x0000003200007348ULL, 0x000fe80003800000ULL,
0x0c00002c15157389ULL, 0x0002a200000e002fULL, 0xfffee4002a007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff157424ULL, 0x000fe200078e00ffULL, 0x0000002700007348ULL, 0x000fe80003800000ULL,
0x0000002524237389ULL, 0x0002a200000e0026ULL, 0xfffee3c014007950ULL, 0x000fea0003c3ffffULL,
0x000000011400780cULL, 0x000fe20003f25070ULL, 0x0000001500007348ULL, 0x000fd80003800000ULL,
0x0000000000147806ULL, 0x000fc800048e0100ULL, 0x00000015141c7212ULL, 0x000fe200078ec0ffULL,
0x000000ffff147224ULL, 0x000fe400078e001dULL, 0x00000000ff157424ULL, 0x000fc800078e00ffULL,
0xfffee35014007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000358ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000938ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x00000000000005e4ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000facULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000fd0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000fe0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001000ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001090ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001098ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000010a8ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001280ULL, 0x0000000000011d80ULL, 0xa000001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000013010ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013010ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000013490ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001090ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000011f70ULL, 0x0000000000011f70ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000013490ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_8_m_8_sm_80_cubin_len = 79216;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
