/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_16_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000010ef0ULL, 0x0000000000010a70ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x000000000000fa70ULL, 0x0000000000000290ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x000000000000fd00ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000fa7000000000ULL, 0x0000480400000000ULL, 0x0400288080810c00ULL, 0x0000000000003e48ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000001cffffffffULL, 0x0000006800000000ULL, 0x0000fa7000000000ULL,
0x0000029000000000ULL, 0x0000000000000000ULL, 0x0000000e00082f04ULL, 0x000812040000007dULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL,
0x0000000e00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL, 0x0000007c00043704ULL,
0x00000000000c1704ULL, 0x0021f00000480007ULL, 0x00000000000c1704ULL, 0x0021f00000400006ULL,
0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL,
0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00801b0380005003ULL, 0x00007ac000183104ULL, 0x0000ef8000008100ULL, 0x0000efa00000ef90ULL,
0x00cc29040000efb0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001c05000003ULL, 0x050000030500001cULL,
0x0500000305000003ULL, 0x0500002b0500002bULL, 0x0500002b0500002bULL, 0x0500002b0500002bULL,
0x0500002b0500002bULL, 0x0500002b0500002bULL, 0x00cc28040500002bULL, 0x000000c0000000a0ULL,
0x0000362000001f40ULL, 0x00003740000036e0ULL, 0x00003ba000003780ULL, 0x000042c000003be0ULL,
0x0000510000005040ULL, 0x000051a000005170ULL, 0x000054e0000054b0ULL, 0x00005cb000005ca0ULL,
0x0000600000005ff0ULL, 0x0000810000007ac0ULL, 0x00008620000085f0ULL, 0x00008c3000008c10ULL,
0x0000e8c00000e8b0ULL, 0x0000e8e00000e8d0ULL, 0x0000e9300000e910ULL, 0x0000e9600000e950ULL,
0x0000ef900000ef70ULL, 0x0000efe00000efa0ULL, 0x0000f0000000eff0ULL, 0x0000f6100000f570ULL,
0x0000f6c00000f660ULL, 0x0000f7900000f730ULL, 0x0000f8500000f7f0ULL, 0x0000f9900000f8f0ULL,
0x010039040000fa30ULL, 0x000000ff00000170ULL, 0x0004010000023600ULL, 0x0000000200000260ULL,
0x003f010000023608ULL, 0x00000002000002d0ULL, 0x003f010000023610ULL, 0x000000ff000006a0ULL,
0x0004010700023600ULL, 0x000000ff000007d0ULL, 0x0004010100023610ULL, 0x000000ff00003540ULL,
0x0007010a00023608ULL, 0x000000ff00004200ULL, 0x0007010100023610ULL, 0x000000ff00004f90ULL,
0x0007010a00023628ULL, 0x000000ff000058f0ULL, 0x0007010100023630ULL, 0x000000ff0000ae20ULL,
0x000b010a00023600ULL, 0x000000ff0000df90ULL, 0x0013010a00023610ULL, 0x000000ff0000f320ULL,
0x0013010100023608ULL, 0x000000ff0000f360ULL, 0x0007010a00023608ULL, 0x000000ff0000f3d0ULL,
0x0007010a00023628ULL, 0x000000ff0000f430ULL, 0x000b010a00023600ULL, 0x000000ff0000f4b0ULL,
0x0013010a00023610ULL, 0x00141c0400033803ULL, 0x000096a000009250ULL, 0x0000aed00000ae50ULL,
0x000c05040000f340ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0050190300000000ULL,
0x0000000f00080a04ULL, 0x0004360400500210ULL, 0x0000000000000008ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x0000000000000000ULL, 0x00000000000000c4ULL, 0x0000000e00000002ULL, 0x000000000000fa70ULL,
0x0000000000000044ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL, 0x00000000000000a0ULL,
0x0000000e00000002ULL, 0x0000000000000000ULL, 0x0000004043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000057919ULL, 0x000eae0000002100ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x0000000000087919ULL, 0x000f220000002300ULL, 0x0000000000037919ULL, 0x000f2a0000002200ULL,
0x00000000000679c3ULL, 0x000f700000002700ULL, 0x00000000000979c3ULL, 0x000f620000002600ULL,
0x00000004ff647e24ULL, 0x008fe2000f8e00ffULL, 0x00000005ff027819ULL, 0x004fcc0000011605ULL,
0x00001fff02027589ULL, 0x000ea200000e0000ULL, 0x0000000108007824ULL, 0x010fc600078e0203ULL,
0x00001fff08087589ULL, 0x000ee200000e0000ULL, 0x0000008000007824ULL, 0x000fca00078e0205ULL,
0x000000ff0000720cULL, 0x040fe40003f05270ULL, 0x000000030000780cULL, 0x000fe40003f24070ULL,
0x00000000021472caULL, 0x004fd200000e0000ULL, 0x0000000000240947ULL, 0x022fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff00000a7882ULL, 0x000fe20000000000ULL, 0x7ffc0000000b7882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x0236000a043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000030000157ab9ULL, 0x000fe20000000800ULL, 0x000001a000007945ULL, 0x000fe80003800000ULL,
0x0000000000601947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7fff000000057882ULL, 0x000fc60000000000ULL,
0x0000000400027c11ULL, 0x000fe2000f8e20ffULL, 0x001fffc000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020712caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000f240000000000ULL, 0x02360804073f75b2ULL, 0x0043300008000100ULL,
0xfffffffd00e81947ULL, 0x010fea000393ffffULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x001fff8000047882ULL, 0x002fe20000000000ULL,
0x7ffe000000057882ULL, 0x000fd60000000000ULL, 0x00000000020712caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000f240000000000ULL, 0x02361004073f75b2ULL, 0x0043300008000100ULL,
0xfffffffd00e81947ULL, 0x010fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000007f0000780cULL, 0x000fe20003f04070ULL, 0x00008c0000047ab9ULL, 0x002fe20000000a00ULL,
0x000000ff0800720cULL, 0x008fe20003f25270ULL, 0x00000004060478a5ULL, 0x000fe2000f8e0004ULL,
0x0000820000107ab9ULL, 0x000fe20000000a00ULL, 0x00008400000a7ab9ULL, 0x000fc80000000800ULL,
0x00000004ff067e24ULL, 0x000fe4000f8e00ffULL, 0x00000005ff077e24ULL, 0x000fe4000f8e00ffULL,
0x0000000000038919ULL, 0x000e620000008800ULL, 0x0000040000028802ULL, 0x000fc80000000f00ULL,
0x0000065403058816ULL, 0x002fe20000000002ULL, 0xff317217ff038424ULL, 0x000fc800078e00ffULL,
0x0000000400008824ULL, 0x000fca00078e0205ULL, 0x0234000300008388ULL, 0x0003e20000000800ULL,
0x0000000000007b1dULL, 0x004fec0000010000ULL, 0x0000000000981947ULL, 0x002fea0003800000ULL,
0x00000000000d7919ULL, 0x000e620000000000ULL, 0x00008800ff047b82ULL, 0x000ea20000000a00ULL,
0x0000000214087899ULL, 0x000fe4000800063fULL, 0x000000040a047899ULL, 0x000fe4000800063fULL,
0x0000000409057899ULL, 0x000fc6000800063fULL, 0x00000000000779c3ULL, 0x000ee20000008800ULL,
0x00000006040472a4ULL, 0x000fe2000f8e0205ULL, 0x000000080d007c11ULL, 0x002fc8000f8fe0ffULL,
0x00000007000a7812ULL, 0x040fe200078ec0ffULL, 0x00000002000b7836ULL, 0x040fe40000000000ULL,
0x0000000400037c36ULL, 0x000fe40008000000ULL, 0x000000040b097c36ULL, 0x040fe20008000000ULL,
0x000000070b0c7812ULL, 0x000fe200078ec0ffULL, 0x0000010003027825ULL, 0x104fe200078e0004ULL,
0x0000040000047882ULL, 0x000fe40000000000ULL, 0x0000000f0c0c7812ULL, 0x000fe200078e780dULL,
0x0000010009047825ULL, 0x000fe200078e0004ULL, 0x000000040d097819ULL, 0x000fe200000006ffULL,
0x0000065407047896ULL, 0x008fc40008000004ULL, 0x000000100b0c7824ULL, 0x000fe200078e020cULL,
0x000000f0090f7812ULL, 0x000fe400078ec0ffULL, 0x0000000f0a097812ULL, 0x000fe400078e780dULL,
0x0000000f02027210ULL, 0x000fe40007f1e0ffULL, 0x0000000f04047210ULL, 0x000fe20007f3e0ffULL,
0x0000001000097824ULL, 0x000fe200078e0209ULL, 0x000000040c0b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff037224ULL, 0x000fc400000e0603ULL, 0x000000ffff057224ULL, 0x000fe200008e0605ULL,
0x0000000409097c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e8000b901c50ULL, 0x00000000040b7faeULL, 0x0003e2000b901c50ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0002360004047890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x002fe40000000000ULL,
0x0000001006067981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0800720cULL, 0x000fe40003f05270ULL,
0x00000000060f72caULL, 0x004fda00000e0000ULL, 0x000000ff0f057890ULL, 0x000fc8000fffe03fULL,
0x000000083f057899ULL, 0x000fe20008011605ULL, 0x0000008c00dc8947ULL, 0x000ff60003800000ULL,
0x00000000000479c3ULL, 0x000e620000008800ULL, 0x0000040000087882ULL, 0x000fe20000000000ULL,
0x00000002ff007424ULL, 0x000fe200078e00ffULL, 0x00000000640b72caULL, 0x000fe200000e0000ULL,
0x000000013f077899ULL, 0x000fe40008011614ULL, 0x0000000106067899ULL, 0x000fe4000800063fULL,
0x0000000607167899ULL, 0x000fe4000800063fULL, 0x0000065404087896ULL, 0x002fc80008000008ULL,
0x0000000814047291ULL, 0x000fd2000f8e203fULL, 0x02361000ffff79a7ULL, 0x0003e20008500004ULL,
0x0000000a09047290ULL, 0x000fc6000fffe03fULL, 0x00008e0000097ab9ULL, 0x000fe20000000800ULL,
0x0000000a060672a4ULL, 0x000fe4000f8e0204ULL, 0x000000160b0a7291ULL, 0x000fe2000f8e403fULL,
0x0000000164007836ULL, 0x002fe20000000000ULL, 0x0000000114047892ULL, 0x000fe4000f8ec03fULL,
0x00000009060b72a4ULL, 0x000fe4000f8e020aULL, 0x0000000500007c0cULL, 0x000fda000bf06070ULL,
0x0000000800c48947ULL, 0x000fea0003800000ULL, 0x0000000000777919ULL, 0x000e620000000000ULL,
0x0000000a0f00728cULL, 0x000fe4000bf01070ULL, 0x8000000aff127e24ULL, 0x000fe4000f8e02ffULL,
0x0000000a0f097287ULL, 0x000fcc000c000000ULL, 0x00000009ff057e24ULL, 0x000fe2000f8e00ffULL,
0x0000000807097291ULL, 0x000fc8000f8e783fULL, 0x0000004005127446ULL, 0x000fe20003800012ULL,
0x0000000904097291ULL, 0x000fc8000f8e703fULL, 0x0001300009097890ULL, 0x000fe2000fffe03fULL,
0x00000003ff137819ULL, 0x002fe40000011677ULL, 0x0ffffff877037812ULL, 0x000fe400078ec0ffULL,
0x0000007713007212ULL, 0x0c0fe200078e3cffULL, 0x0000000413087836ULL, 0x040fe20000000000ULL,
0x0000003013287810ULL, 0x000fe20007ffe0ffULL, 0x0000000c130e7836ULL, 0x040fe20000000000ULL,
0x00000007030a7812ULL, 0x000fe200078ef800ULL, 0x0000001013167836ULL, 0x040fe20000000000ULL,
0x0000007708027212ULL, 0x080fe200078e3cffULL, 0x000000080e057824ULL, 0x000fe200078e00ffULL,
0x0000000308077819ULL, 0x000fe200000006ffULL, 0x0000000816187824ULL, 0x040fe200078e00ffULL,
0x0000007716037212ULL, 0x080fe200078e3cffULL, 0x00000018131e7836ULL, 0x040fe20000000000ULL,
0xfffffff807107812ULL, 0x000fe200078ee202ULL, 0x0000001c13217836ULL, 0x000fe20000000000ULL,
0x000000770e027212ULL, 0x080fe200078e3cffULL, 0x000000081e077824ULL, 0x040fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee203ULL, 0x0000000821227824ULL, 0x000fe200078e00ffULL,
0xfffffff805147812ULL, 0x000fe200078ee202ULL, 0x00000008130c7836ULL, 0x040fe20000000000ULL,
0x000000771e027212ULL, 0x080fe200078e3cffULL, 0x00000014131a7836ULL, 0x000fe20000000000ULL,
0x0000007721037212ULL, 0x080fe200078e3cffULL, 0x000000080c117824ULL, 0x040fe200078e00ffULL,
0xfffffff807207812ULL, 0x000fe200078ee202ULL, 0x0000002413257836ULL, 0x040fe20000000000ULL,
0xfffffff822227812ULL, 0x000fe200078ee203ULL, 0x0000002813267836ULL, 0x040fe20000000000ULL,
0x000000770c007212ULL, 0x080fe200078e3cffULL, 0x00008a00ff027b82ULL, 0x000e620000000a00ULL,
0x000000031a057819ULL, 0x040fe200000006ffULL, 0x0000002013237836ULL, 0x000fe20000000000ULL,
0xfffffff811117812ULL, 0x000fe200078ee200ULL, 0x0000000825097824ULL, 0x040fe200078e00ffULL,
0x000000771a007212ULL, 0x080fe200078e3cffULL, 0x0000000826047824ULL, 0x040fe200078e00ffULL,
0x0000007725067212ULL, 0x080fe200078e3cffULL, 0x0000002c13277836ULL, 0x000fe20000000000ULL,
0xfffffff8051c7812ULL, 0x000fe200078ee200ULL, 0x0000000823057824ULL, 0x040fe200078e00ffULL,
0x0000007726077212ULL, 0x080fe200078e3cffULL, 0x00000008280b7824ULL, 0x000fe200078e00ffULL,
0x0000007723007212ULL, 0x080fe200078e3cffULL, 0x0000000b0c0d7c36ULL, 0x000fe20008000000ULL,
0xfffffff809067812ULL, 0x000fe200078ee206ULL, 0x0000000827097824ULL, 0x000fe200078e00ffULL,
0xfffffff804077812ULL, 0x000fe200078ee207ULL, 0x0000003413297836ULL, 0x000fe20000000000ULL,
0xfffffff805247812ULL, 0x000fe200078ee200ULL, 0x00000004ff057e24ULL, 0x000fe2000f8e00ffULL,
0x0000007727047212ULL, 0x080fe200078e3cffULL, 0x0000000b0e0f7c36ULL, 0x000fe20008000000ULL,
0x0000007728007212ULL, 0x000fe200078e3cffULL, 0x00000008052a7824ULL, 0x000fe200078e00ffULL,
0xfffffff809047812ULL, 0x000fe200078ee204ULL, 0x0000000b13097c36ULL, 0x040fe20008000000ULL,
0xfffffff80b007812ULL, 0x000fe200078ee200ULL, 0x0000000b080b7c36ULL, 0x000fe20008000000ULL,
0x000000121300720cULL, 0x080fe20003f06070ULL, 0x0000000b1e1f7c36ULL, 0x000fe20008000000ULL,
0x000000120800720cULL, 0x000fe20003f26070ULL, 0x0000010009087825ULL, 0x002fe200078e0002ULL,
0xfffffff82a057812ULL, 0x000fc400078ee277ULL, 0x000000090a157c11ULL, 0x000fe2000f8e20ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0002ULL, 0x000000120c00720cULL, 0x080fe40003f46070ULL,
0x000000120e00720cULL, 0x080fe20003f66070ULL, 0x0000001005087825ULL, 0x000fe200078e0008ULL,
0x0000000911197c11ULL, 0x000fe4000f8e20ffULL, 0x00000077291d7212ULL, 0x000fe200078e3cffULL,
0x000001000d0c7825ULL, 0x100fe200078e0002ULL, 0x00000003292a7819ULL, 0x000fe200000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008157faeULL, 0x0003e2000c101c50ULL,
0x0000000910177c11ULL, 0x000fe2000f8e20ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0002ULL,
0x000000121600720cULL, 0x000fc40003f06070ULL, 0x00000009141b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000b16117c36ULL, 0x000fe20008000000ULL, 0xfffffff82a147812ULL, 0x000fe200078ee21dULL,
0x00000010050a7825ULL, 0x000fe200078e000aULL, 0x000000122300720cULL, 0x080fe40003f86070ULL,
0x0000000907077c11ULL, 0x000fe2000f8e20ffULL, 0x00000010050c7825ULL, 0x000fe200078e000cULL,
0x000000000a177faeULL, 0x0005e2000c901c50ULL, 0x000000121a00720cULL, 0x000fe40003f26070ULL,
0x0000010011107825ULL, 0x000fe200078e0002ULL, 0x000000000c197faeULL, 0x0007e2000d101c50ULL,
0x0000000918157c11ULL, 0x002fc4000f8e20ffULL, 0x00000010050e7825ULL, 0x000fe200078e000eULL,
0x000000121e00720cULL, 0x000fc60003f46070ULL, 0x0000000b1a1d7c36ULL, 0x000fe20008000000ULL,
0x000000000e1b7faeULL, 0x0003e2000d901c50ULL, 0x0000001005107825ULL, 0x000fe200078e0010ULL,
0x000000122100720cULL, 0x000fe40003f66070ULL, 0x000000091c177c11ULL, 0x004fe2000f8e20ffULL,
0x000001001d087825ULL, 0x100fe200078e0002ULL, 0x0000000010157faeULL, 0x0005e2000c101c50ULL,
0x0000000920197c11ULL, 0x008fe4000f8e20ffULL, 0x0000000b210d7c36ULL, 0x000fe20008000000ULL,
0x00000009241d7c11ULL, 0x000fe2000f8e20ffULL, 0x000001001f0a7825ULL, 0x000fe200078e0002ULL,
0x00000009221b7c11ULL, 0x002fc4000f8e20ffULL, 0x000000122500720cULL, 0x000fe20003f06070ULL,
0x0000000b230f7c36ULL, 0x000fe40008000000ULL, 0x000001000d0c7825ULL, 0x000fc800078e0002ULL,
0x0000001005087825ULL, 0x000fc800078e0008ULL, 0x000001000f0e7825ULL, 0x000fe200078e0002ULL,
0x0000000008177faeULL, 0x0003e2000c901c50ULL, 0x000000122600720cULL, 0x080fe40003f26070ULL,
0x0000003c13157836ULL, 0x044fe40000000000ULL, 0x0000003813107836ULL, 0x000fe40000000000ULL,
0x00000010050a7825ULL, 0x000fe200078e000aULL, 0x000000121500720cULL, 0x080fe40003fc6070ULL,
0x000000121000720cULL, 0x0c0fe20003fa6070ULL, 0x00000010050c7825ULL, 0x000fe200078e000cULL,
0x0000007715097212ULL, 0x0c2fe200078e3cffULL, 0x000000000a197faeULL, 0x0003e2000d101c50ULL,
0x0000007710087212ULL, 0x000fe200078e3cffULL, 0x0000000815187824ULL, 0x000fe200078e00ffULL,
0x000000122700720cULL, 0x080fe20003f46070ULL, 0x00000010050e7825ULL, 0x000fe200078e000eULL,
0x000000000c1b7faeULL, 0x0005e2000d901c50ULL, 0x000000122800720cULL, 0x000fc40003f66070ULL,
0x0000000810117824ULL, 0x000fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ee209ULL,
0x000000000e1d7faeULL, 0x0007e2000e101c50ULL, 0x0000000b25097c10ULL, 0x000fe2000fffe0ffULL,
0x0000000b260b7c36ULL, 0x002fe20008000000ULL, 0xfffffff811167812ULL, 0x000fe200078ee208ULL,
0x0000000b29117c36ULL, 0x040fe20008000000ULL, 0x000000122900720cULL, 0x000fe20003f86070ULL,
0x0000000b10137c36ULL, 0x000fe20008000000ULL, 0x0000000900177c11ULL, 0x000fe2000f8e20ffULL,
0x0000000b270d7c36ULL, 0x004fe20008000000ULL, 0x0000000914197c11ULL, 0x000fe2000f8e20ffULL,
0x0000000b15157c36ULL, 0x000fe20008000000ULL, 0x00000009161b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000b280f7c36ULL, 0x008fe20008000000ULL, 0x00000009181d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000010009087825ULL, 0x000fc800078e0002ULL, 0x000001000b0a7825ULL, 0x000fc800078e0002ULL,
0x000001000d0c7825ULL, 0x000fc800078e0002ULL, 0x000001000f0e7825ULL, 0x000fc800078e0002ULL,
0x0000010011107825ULL, 0x000fc800078e0002ULL, 0x0000010013127825ULL, 0x000fc800078e0002ULL,
0x0000010015027825ULL, 0x000fe200078e0002ULL, 0x0000000906157c11ULL, 0x000fc6000f8e20ffULL,
0x0000001005087825ULL, 0x000fc800078e0008ULL, 0x00000010050a7825ULL, 0x040fe200078e000aULL,
0x0000000008157faeULL, 0x0003e6000c101c50ULL, 0x00000010050c7825ULL, 0x040fe200078e000cULL,
0x000000000a077faeULL, 0x0003e6000c901c50ULL, 0x00000010050e7825ULL, 0x000fc800078e000eULL,
0x0000001005107825ULL, 0x000fc800078e0010ULL, 0x0000001005127825ULL, 0x000fc800078e0012ULL,
0x0000001005027825ULL, 0x000fe200078e0002ULL, 0x0000000904057c11ULL, 0x000fca000f8e20ffULL,
0x000000000c057faeULL, 0x0003e8000d101c50ULL, 0x000000000e177faeULL, 0x0003e8000d901c50ULL,
0x0000000010197faeULL, 0x0003e8000e101c50ULL, 0x00000000121b7faeULL, 0x0003e8000e901c50ULL,
0x00000000021d7faeULL, 0x0003e2000f101c50ULL, 0x00000008006c7947ULL, 0x000fea0003800000ULL,
0x0000000000777919ULL, 0x000e620000000000ULL, 0x0000000807097291ULL, 0x000fe2000f8e783fULL,
0x00000004ff137e24ULL, 0x000fc6000f8e00ffULL, 0x0000000904097291ULL, 0x000fe2000f8e703fULL,
0x0000000813347824ULL, 0x000fc600078e00ffULL, 0x0001300009097890ULL, 0x000fe2000fffe03fULL,
0x00000003ff127819ULL, 0x002fe40000011677ULL, 0x0ffffff877037812ULL, 0x000fe400078ec0ffULL,
0x0000007712007212ULL, 0x0c0fe200078e3cffULL, 0x0000000412167836ULL, 0x040fe20000000000ULL,
0x0000000c121a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000812187836ULL, 0x040fe20000000000ULL,
0x0000000703147812ULL, 0x000fe200078ef800ULL, 0x00000014121e7836ULL, 0x000fe20000000000ULL,
0x0000007716077212ULL, 0x0c0fe200078e3cffULL, 0x0000000816027824ULL, 0x000fe200078e00ffULL,
0x0000007718067212ULL, 0x0c0fe200078e3cffULL, 0x0000000818037824ULL, 0x000fe200078e00ffULL,
0x000000771e0c7212ULL, 0x0c0fe200078e3cffULL, 0x000000081e097824ULL, 0x000fe200078e00ffULL,
0xfffffff802077812ULL, 0x000fe200078ee207ULL, 0x0000001c12227836ULL, 0x040fe20000000000ULL,
0xfffffff803067812ULL, 0x000fe200078ee206ULL, 0x0000002012247836ULL, 0x000fe20000000000ULL,
0xfffffff8090c7812ULL, 0x000fe200078ee20cULL, 0x0000000822037824ULL, 0x040fe200078e00ffULL,
0x00000077220a7212ULL, 0x080fe200078e3cffULL, 0x0000000824027824ULL, 0x040fe200078e00ffULL,
0x0000007724097212ULL, 0x080fe200078e3cffULL, 0x0000002c122a7836ULL, 0x040fe20000000000ULL,
0xfffffff8030a7812ULL, 0x000fe200078ee20aULL, 0x00000030122c7836ULL, 0x040fe20000000000ULL,
0xfffffff802097812ULL, 0x000fe200078ee209ULL, 0x00000010121c7836ULL, 0x000fe20000000000ULL,
0x000000032a037819ULL, 0x000fe200000006ffULL, 0x000000082c027824ULL, 0x000fe200078e00ffULL,
0x000000772a107212ULL, 0x080fe200078e3cffULL, 0x000000081a057824ULL, 0x000fe200078e00ffULL,
0x000000772c117212ULL, 0x080fe200078e3cffULL, 0x000000081c007824ULL, 0x000fe200078e00ffULL,
0xfffffff803107812ULL, 0x000fe200078ee210ULL, 0x0000001812207836ULL, 0x040fe20000000000ULL,
0xfffffff802117812ULL, 0x000fe200078ee211ULL, 0x00000034122e7836ULL, 0x000fe20000000000ULL,
0x00008a00ff027b82ULL, 0x000e620000000a00ULL, 0x000000771a0e7212ULL, 0x080fe200078e3cffULL,
0x0000002812287836ULL, 0x000fe20000000000ULL, 0x000000771c0d7212ULL, 0x080fe200078e3cffULL,
0x000000082e047824ULL, 0x000fe200078e00ffULL, 0x0000002412267810ULL, 0x000fe20007ffe0ffULL,
0x0000003812307836ULL, 0x040fe20000000000ULL, 0xfffffff8050e7812ULL, 0x000fe200078ee20eULL,
0x0000003c12327836ULL, 0x000fe20000000000ULL, 0xfffffff8000d7812ULL, 0x000fe200078ee20dULL,
0x0000000820007824ULL, 0x040fe200078e00ffULL, 0x00000077200b7212ULL, 0x080fe200078e3cffULL,
0x0000000826057824ULL, 0x040fe200078e00ffULL, 0x0000007726087212ULL, 0x080fe200078e3cffULL,
0x0000000830157824ULL, 0x000fe200078e00ffULL, 0xfffffff8000b7812ULL, 0x000fe200078ee20bULL,
0x0000000828007824ULL, 0x000fe200078e00ffULL, 0xfffffff805087812ULL, 0x000fe200078ee208ULL,
0x0000000832177824ULL, 0x000fe200078e00ffULL, 0x000000772e057212ULL, 0x080fe200078e3cffULL,
0x0000000b12137c36ULL, 0x000fe20008000000ULL, 0x00000077280f7212ULL, 0x000fe200078e3cffULL,
0x0000000b1a197c36ULL, 0x000fe20008000000ULL, 0xfffffff804057812ULL, 0x000fe200078ee205ULL,
0x0000010013127825ULL, 0x002fe200078e0002ULL, 0xfffffff8000f7812ULL, 0x000fc400078ee20fULL,
0x0000007730047212ULL, 0x080fe200078e3cffULL, 0x0000000b1c1b7c36ULL, 0x000fe20008000000ULL,
0x0000007732007212ULL, 0x000fe200078e3cffULL, 0x0000000b1e1d7c36ULL, 0x000fe20008000000ULL,
0xfffffff815047812ULL, 0x000fe200078ee204ULL, 0x0000000b201f7c36ULL, 0x000fe20008000000ULL,
0xfffffff817007812ULL, 0x000fe200078ee200ULL, 0x0000000b18177c36ULL, 0x000fe20008000000ULL,
0x0000000b16157c10ULL, 0x000fe2000fffe0ffULL, 0x0000000b22217c36ULL, 0x000fe20008000000ULL,
0x0000000b2a297c10ULL, 0x000fe2000fffe0ffULL, 0x0000000b24237c36ULL, 0x000fe20008000000ULL,
0xfffffff834317812ULL, 0x000fe200078ee277ULL, 0x0000000b26257c36ULL, 0x000fe20008000000ULL,
0x0000000914337c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b28277c36ULL, 0x000fe20008000000ULL,
0x0000000907077c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b2c2b7c36ULL, 0x000fe20008000000ULL,
0x000000090d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b2e2d7c36ULL, 0x000fe20008000000ULL,
0x000000090b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b302f7c36ULL, 0x000fe20008000000ULL,
0x0000000909097c11ULL, 0x000fe2000f8e20ffULL, 0x0000000b32357c36ULL, 0x000fe20008000000ULL,
0x0000000908377c11ULL, 0x000fe2000f8e20ffULL, 0x0000010015147825ULL, 0x000fe200078e0002ULL,
0x000000090f0f7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000911117c11ULL, 0x000fe2000f8e20ffULL,
0x0000010017167825ULL, 0x000fe200078e0002ULL, 0x0000000905057c11ULL, 0x000fc6000f8e20ffULL,
0x0000010019187825ULL, 0x000fc800078e0002ULL, 0x000001001b1a7825ULL, 0x000fc800078e0002ULL,
0x000001001d1c7825ULL, 0x000fc800078e0002ULL, 0x000001001f1e7825ULL, 0x000fc800078e0002ULL,
0x0000010021207825ULL, 0x000fc800078e0002ULL, 0x0000010023227825ULL, 0x000fc800078e0002ULL,
0x0000010025247825ULL, 0x000fc800078e0002ULL, 0x0000010027267825ULL, 0x000fc800078e0002ULL,
0x0000010029287825ULL, 0x000fc800078e0002ULL, 0x000001002b2a7825ULL, 0x000fc800078e0002ULL,
0x000001002d2c7825ULL, 0x000fc800078e0002ULL, 0x000001002f2e7825ULL, 0x000fc800078e0002ULL,
0x0000001031127825ULL, 0x000fc800078e0012ULL, 0x0000010035027825ULL, 0x000fe200078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012337faeULL, 0x0003e2000b901c50ULL,
0x000000090a357c11ULL, 0x000fe4000f8e20ffULL, 0x0000001031147825ULL, 0x000fc800078e0014ULL,
0x0000001031167825ULL, 0x040fe200078e0016ULL, 0x0000000014077faeULL, 0x0005e6000b901c50ULL,
0x0000001031187825ULL, 0x040fe200078e0018ULL, 0x0000000906137c11ULL, 0x002fe4000f8e20ffULL,
0x000000090c337c11ULL, 0x000fe2000f8e20ffULL, 0x00000010311a7825ULL, 0x040fe400078e001aULL,
0x0000000016137faeULL, 0x0003e4000b901c50ULL, 0x00000010311c7825ULL, 0x000fe200078e001cULL,
0x0000000910077c11ULL, 0x004fc6000f8e20ffULL, 0x00000010311e7825ULL, 0x000fc800078e001eULL,
0x0000001031207825ULL, 0x000fe200078e0020ULL, 0x0000000900137c11ULL, 0x002fc6000f8e20ffULL,
0x0000001031227825ULL, 0x000fc800078e0022ULL, 0x0000001031247825ULL, 0x000fc800078e0024ULL,
0x0000001031267825ULL, 0x000fc800078e0026ULL, 0x0000001031287825ULL, 0x000fc800078e0028ULL,
0x00000010312a7825ULL, 0x000fc800078e002aULL, 0x00000010312c7825ULL, 0x000fc800078e002cULL,
0x00000010312e7825ULL, 0x000fc800078e002eULL, 0x0000001031027825ULL, 0x000fe200078e0002ULL,
0x000000090e317c11ULL, 0x000fca000f8e20ffULL, 0x0000000018317faeULL, 0x000fe8000b901c50ULL,
0x000000001a0d7faeULL, 0x0005e8000b901c50ULL, 0x000000001c337faeULL, 0x0003e8000b901c50ULL,
0x000000001e0b7faeULL, 0x0003e8000b901c50ULL, 0x0000000020357faeULL, 0x0003e2000b901c50ULL,
0x00000009040d7c11ULL, 0x004fc6000f8e20ffULL, 0x0000000022097faeULL, 0x0003e8000b901c50ULL,
0x0000000024377faeULL, 0x0003e8000b901c50ULL, 0x00000000260f7faeULL, 0x0003e8000b901c50ULL,
0x0000000028077faeULL, 0x0003e8000b901c50ULL, 0x000000002a117faeULL, 0x0003e8000b901c50ULL,
0x000000002c057faeULL, 0x0003e8000b901c50ULL, 0x000000002e0d7faeULL, 0x0003e8000b901c50ULL,
0x0000000002137faeULL, 0x0003e4000b901c50ULL, 0x0000000564007c0cULL, 0x000fe2000bf06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff497424ULL, 0x000fe200078e00ffULL,
0x0000000000327805ULL, 0x002fe2000001ff00ULL, 0x000000ffff4d7224ULL, 0x000fe200078e00ffULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000003a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000003800f00947ULL, 0x000fec0003800000ULL,
0xff317217ff497424ULL, 0x000fe200078e00ffULL, 0x00007610ff767816ULL, 0x000fe20000000076ULL,
0x000000ffff337224ULL, 0x000fe200078e00ffULL, 0x0000000807077291ULL, 0x000fe2000f8e203fULL,
0x0000003f00047c82ULL, 0x000fd60008000000ULL, 0x00000000640a72caULL, 0x000fda00000e0000ULL,
0x000000160a0a7291ULL, 0x000fc8000f8e403fULL, 0x0000000f0a00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000003800b40947ULL, 0x000fea0003800000ULL,
0x0000000164007836ULL, 0x000fe20000000000ULL, 0x000000800a0d7890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000500007c0cULL, 0x000fe2000bf06070ULL,
0x00008e00000e7ab9ULL, 0x000fe20000000800ULL, 0x0000000400097c82ULL, 0x000fe20008000000ULL,
0x00000001140b7892ULL, 0x000fe4000f8ec03fULL, 0x000000013f137899ULL, 0x000fe40008011614ULL,
0x0000000104047892ULL, 0x000fe4000f8e0c3fULL, 0x0000000e060c72a4ULL, 0x000fc8000f8e020dULL,
0x0000000800cc8947ULL, 0x000ff00003800000ULL, 0x00000003ff007819ULL, 0x000fe20000011677ULL,
0x0000000d0f00728cULL, 0x000fe4000bf01070ULL, 0x8000000dff3d7e24ULL, 0x000fe2000f8e02ffULL,
0x00008a0000187ab9ULL, 0x000fe20000000a00ULL, 0x0000000400027810ULL, 0x000fe20007ffe0ffULL,
0x0000000800037836ULL, 0x040fe20000000000ULL, 0x0000000d0f0a7287ULL, 0x000fe2000c000000ULL,
0x0000001800077836ULL, 0x000fe20000000000ULL, 0x00000077025c7212ULL, 0x0c0fe200078e3cffULL,
0x0000000803067824ULL, 0x040fe200078e00ffULL, 0x00000077035b7212ULL, 0x080fe200078e3cffULL,
0x0000000802057824ULL, 0x000fe200078e00ffULL, 0x0000007707577212ULL, 0x040fe200078e3cffULL,
0x0000000aff047e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff8065b7812ULL, 0x000fe200078ee25bULL,
0x0000001400067836ULL, 0x040fe20000000000ULL, 0xfffffff8055c7812ULL, 0x000fe200078ee25cULL,
0x0000001000057836ULL, 0x000fe20000000000ULL, 0x00000040043d7446ULL, 0x000fe2000380003dULL,
0x00000008060b7824ULL, 0x040fe200078e00ffULL, 0x0000007706587212ULL, 0x080fe200078e3cffULL,
0x00000008070a7824ULL, 0x000fe200078e00ffULL, 0x0000007705597212ULL, 0x0c0fe200078e3cffULL,
0x0000000805087824ULL, 0x000fe200078e00ffULL, 0xfffffff80b587812ULL, 0x000fe200078ee258ULL,
0x0000000c00047836ULL, 0x040fe20000000000ULL, 0xfffffff80a577812ULL, 0x000fe200078ee257ULL,
0x00000024000a7836ULL, 0x040fe20000000000ULL, 0xfffffff808597812ULL, 0x000fe200078ee259ULL,
0x00000028000b7836ULL, 0x000fe20000000000ULL, 0x00000077045a7212ULL, 0x080fe200078e3cffULL,
0x0000001c00087836ULL, 0x000fe20000000000ULL, 0x0000000304097819ULL, 0x000fe200000006ffULL,
0x000000080b0e7824ULL, 0x040fe200078e00ffULL, 0x000000770a547212ULL, 0x080fe200078e3cffULL,
0x00000008080d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8095a7812ULL, 0x000fe200078ee25aULL,
0x0000002000097836ULL, 0x000fe20000000000ULL, 0x000000030a0f7819ULL, 0x000fe200000006ffULL,
0x0000003400457836ULL, 0x040fe20000000000ULL, 0x000000770b537212ULL, 0x080fe200078e3cffULL,
0x0000003800447836ULL, 0x000fe20000000000ULL, 0x0000007708567212ULL, 0x080fe200078e3cffULL,
0x0000002c00477836ULL, 0x000fe20000000000ULL, 0x00000008130a7291ULL, 0x000fe2000f8e783fULL,
0xfffffff80f547812ULL, 0x000fe200078ee254ULL, 0x00000008090c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e537812ULL, 0x000fe200078ee253ULL, 0x00000008450f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d567812ULL, 0x000fe200078ee256ULL, 0x00000008440e7824ULL, 0x000fe200078e00ffULL,
0x0000007709557212ULL, 0x080fe200078e3cffULL, 0x00000008470d7824ULL, 0x000fe200078e00ffULL,
0x0000007745507212ULL, 0x080fe200078e3cffULL, 0x0000003000467836ULL, 0x000fe20000000000ULL,
0x00000077444f7212ULL, 0x080fe200078e3cffULL, 0x0000000a0b127291ULL, 0x000fe2000f8e703fULL,
0x0000007747527212ULL, 0x080fe200078e3cffULL, 0x0000000c002f7c36ULL, 0x040fe20008000000ULL,
0x0000007700187212ULL, 0x080fe200078e3cffULL, 0x00000012040a7291ULL, 0x000fe2000f8e683fULL,
0xfffffff80c557812ULL, 0x000fe200078ee255ULL, 0x00000008460c7824ULL, 0x040fe200078e00ffULL,
0xfffffff80f507812ULL, 0x000fe200078ee250ULL, 0x00000019ff0f7e24ULL, 0x000fe2000f8e00ffULL,
0xfffffff80e4f7812ULL, 0x000fe200078ee24fULL, 0x00000018ff0e7e24ULL, 0x000fe2000f8e00ffULL,
0xfffffff80d527812ULL, 0x000fe200078ee252ULL, 0x000130000a0a7890ULL, 0x000fe2000fffe03fULL,
0x0000007746517212ULL, 0x000fe200078e3cffULL, 0x000001002f2e7825ULL, 0x000fe200078e000eULL,
0x00000007773c7812ULL, 0x000fc400078ec0ffULL, 0x0000000b000d7c02ULL, 0x000fe20008000f00ULL,
0x0000000c031b7c36ULL, 0x000fe20008000000ULL, 0x0000000718187812ULL, 0x000fe200078ec0ffULL,
0x0000000c022d7c36ULL, 0x000fe20008000000ULL, 0x0000003d0000720cULL, 0x080fe20003f06070ULL,
0x000001001b1a7825ULL, 0x000fe200078e000eULL, 0xfffffff80c517812ULL, 0x000fe400078ee251ULL,
0x0ffffff8185d7812ULL, 0x000fe200078ef877ULL, 0x000000080d0c7824ULL, 0x000fe200078e023cULL,
0x0000003d0200720cULL, 0x000fe20003f26070ULL, 0x0000003c000d7836ULL, 0x000fe20000000000ULL,
0x0000000a5d377c11ULL, 0x000fe2000f8e20ffULL, 0x000000100c2e7825ULL, 0x000fe200078e002eULL,
0x0000000c05437c10ULL, 0x000fc4000fffe0ffULL, 0x000000770d4e7212ULL, 0x040fe200078e3cffULL,
0x000000080d357824ULL, 0x000fe200078e00ffULL, 0x0000003d0300720cULL, 0x080fe20003f46070ULL,
0x0000000c04197c36ULL, 0x040fe20008000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e377faeULL, 0x0003e2000c101c50ULL, 0x000001002d2c7825ULL, 0x100fe200078e000eULL,
0x0000003d0400720cULL, 0x080fe40003f06070ULL, 0xfffffff8354e7812ULL, 0x000fe200078ee24eULL,
0x0000010019187825ULL, 0x000fe200078e000eULL, 0x0000003d0500720cULL, 0x000fc40003f66070ULL,
0x0000000a5c3f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100c347825ULL, 0x000fe200078e001aULL,
0x0000000a5b417c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a594b7c11ULL, 0x000fe2000f8e20ffULL,
0x00000100431a7825ULL, 0x000fe200078e000eULL, 0x0000000a5a437c11ULL, 0x000fe4000f8e20ffULL,
0x0000003d0900720cULL, 0x080fe20003f86070ULL, 0x000000100c2c7825ULL, 0x000fe200078e002cULL,
0x0000003d4400720cULL, 0x000fc40003fa6070ULL, 0x0000003d0d00720cULL, 0x080fe20003fc6070ULL,
0x0000000c065f7c36ULL, 0x000fe20008000000ULL, 0x000000002c3f7faeULL, 0x0005e2000c901c50ULL,
0x000000100c2e7825ULL, 0x002fe200078e0018ULL, 0x0000003d0600720cULL, 0x080fe40003f26070ULL,
0x0000000034417faeULL, 0x0003e2000d101c50ULL, 0x000000100c367825ULL, 0x000fe200078e001aULL,
0x0000003d0700720cULL, 0x080fe40003f46070ULL, 0x000000002e437faeULL, 0x0007e2000c101c50ULL,
0x000001005f187825ULL, 0x000fe200078e000eULL, 0x0000003d0a00720cULL, 0x000fc40003f06070ULL,
0x00000000364b7faeULL, 0x0009e2000d901c50ULL, 0x0000000c07617c36ULL, 0x000fe20008000000ULL,
0x0000003d0800720cULL, 0x040fe20003f66070ULL, 0x0000000c081b7c36ULL, 0x000fe20008000000ULL,
0x0000000a583f7c11ULL, 0x004fe2000f8e20ffULL, 0x0000000c09417c36ULL, 0x002fe20008000000ULL,
0x0000000a4e5f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000100612c7825ULL, 0x000fe200078e000eULL,
0x0000000a55437c11ULL, 0x008fc6000f8e20ffULL, 0x000001001b1a7825ULL, 0x000fe200078e000eULL,
0x0000000a57377c11ULL, 0x010fe4000f8e20ffULL, 0x0000000a544b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100c347825ULL, 0x000fc800078e0018ULL, 0x0000010041187825ULL, 0x000fe200078e000eULL,
0x0000000a56417c11ULL, 0x000fe2000f8e20ffULL, 0x00000000343f7faeULL, 0x0003e2000c901c50ULL,
0x0000003d0b00720cULL, 0x000fe20003f26070ULL, 0x0000000c0a2f7c36ULL, 0x000fe40008000000ULL,
0x000000100c2c7825ULL, 0x000fc800078e002cULL, 0x000000100c1a7825ULL, 0x040fe200078e001aULL,
0x000000002c377faeULL, 0x0005e2000d101c50ULL, 0x0000003d4700720cULL, 0x080fe40003f46070ULL,
0x000000100c187825ULL, 0x000fe200078e0018ULL, 0x000000001a417faeULL, 0x0007e2000d901c50ULL,
0x0000003d4600720cULL, 0x080fe40003f66070ULL, 0x000001002f2e7825ULL, 0x000fe200078e000eULL,
0x0000000018437faeULL, 0x0009e2000e101c50ULL, 0x0000003d4500720cULL, 0x000fc40003f86070ULL,
0x0000000c0b357c36ULL, 0x002fe20008000000ULL, 0x0000000c442d7c10ULL, 0x004fe2000fffe0ffULL,
0x000000100c3e7825ULL, 0x000fe200078e002eULL, 0x0000000a533d7c11ULL, 0x000fc6000f8e20ffULL,
0x0000000c462f7c36ULL, 0x000fe20008000000ULL, 0x000000003e4b7faeULL, 0x0003e2000c101c50ULL,
0x0000000c451b7c36ULL, 0x008fe20008000000ULL, 0x0000000a50437c11ULL, 0x010fe2000f8e20ffULL,
0x0000000c47197c36ULL, 0x000fe40008000000ULL, 0x0000010035367825ULL, 0x000fc800078e000eULL,
0x0000000c0d417c36ULL, 0x000fe40008000000ULL, 0x0000010019347825ULL, 0x100fe200078e000eULL,
0x0000000a523f7c11ULL, 0x002fe4000f8e20ffULL, 0x0000000a4f4b7c11ULL, 0x000fe2000f8e20ffULL,
0x000001002f2e7825ULL, 0x000fc800078e000eULL, 0x000001001b187825ULL, 0x000fc800078e000eULL,
0x000001002d1a7825ULL, 0x000fc800078e000eULL, 0x00000100412c7825ULL, 0x000fe200078e000eULL,
0x0000000a51417c11ULL, 0x000fc6000f8e20ffULL, 0x000000100c367825ULL, 0x000fc800078e0036ULL,
0x000000100c347825ULL, 0x040fe200078e0034ULL, 0x00000000363d7faeULL, 0x0003e6000c901c50ULL,
0x000000100c2e7825ULL, 0x040fe200078e002eULL, 0x00000000343f7faeULL, 0x0003e6000d101c50ULL,
0x000000100c187825ULL, 0x040fe200078e0018ULL, 0x000000002e417faeULL, 0x0003e6000d901c50ULL,
0x000000100c1a7825ULL, 0x040fe200078e001aULL, 0x0000000018437faeULL, 0x0003e6000e101c50ULL,
0x000000100c2c7825ULL, 0x000fe200078e002cULL, 0x000000001a4b7faeULL, 0x0003e8000e901c50ULL,
0x000000002c5f7faeULL, 0x0003e2000f101c50ULL, 0x00000008006c7947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe20000011677ULL, 0x0000000813127291ULL, 0x000fe2000f8e783fULL,
0x00000007773c7812ULL, 0x000fe400078ec0ffULL, 0x0000007700187212ULL, 0x0c0fe200078e3cffULL,
0x0000001400067836ULL, 0x040fe20000000000ULL, 0x000000120b127291ULL, 0x000fe2000f8e703fULL,
0x0000000400027836ULL, 0x000fe20000000000ULL, 0x0000000718187812ULL, 0x000fe200078ec0ffULL,
0x0000000800037836ULL, 0x000fe20000000000ULL, 0x0000007706587212ULL, 0x0c0fe200078e3cffULL,
0x0000000806097824ULL, 0x000fe200078e00ffULL, 0x00000077025c7212ULL, 0x0c0fe200078e3cffULL,
0x0000000802057824ULL, 0x000fe200078e00ffULL, 0x00000077035b7212ULL, 0x0c0fe200078e3cffULL,
0x0000000803087824ULL, 0x000fe200078e00ffULL, 0xfffffff809587812ULL, 0x000fe200078ee258ULL,
0x0000000c00047836ULL, 0x040fe20000000000ULL, 0xfffffff8055c7812ULL, 0x000fe200078ee25cULL,
0x0000002000097836ULL, 0x040fe20000000000ULL, 0xfffffff8085b7812ULL, 0x000fe200078ee25bULL,
0x0000001000057836ULL, 0x000fe20000000000ULL, 0x00000077045a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000804077824ULL, 0x000fe200078e00ffULL, 0x0000007709557212ULL, 0x080fe200078e3cffULL,
0x0000001c00087836ULL, 0x000fe20000000000ULL, 0x0000007705597212ULL, 0x080fe200078e3cffULL,
0x00000008090e7824ULL, 0x000fe200078e00ffULL, 0x00000003050a7819ULL, 0x000fe200000006ffULL,
0x00000008080b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8075a7812ULL, 0x000fe200078ee25aULL,
0x0000001800077836ULL, 0x000fe20000000000ULL, 0x0000007708567212ULL, 0x080fe200078e3cffULL,
0x0000002c00477836ULL, 0x040fe20000000000ULL, 0xfffffff80e557812ULL, 0x000fe200078ee255ULL,
0x00000008070c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a597812ULL, 0x000fe200078ee259ULL,
0x00008a00ff0e7b82ULL, 0x000e620000000a00ULL, 0x00000024000a7836ULL, 0x000fe20000000000ULL,
0xfffffff80b567812ULL, 0x000fe200078ee256ULL, 0x0000000847197824ULL, 0x000fe200078e00ffULL,
0x0000007707577212ULL, 0x080fe200078e3cffULL, 0x000000080a0d7824ULL, 0x000fe200078e00ffULL,
0x00000028000b7810ULL, 0x000fe20007ffe0ffULL, 0x0000003400457836ULL, 0x000fe20000000000ULL,
0x000000770a547212ULL, 0x080fe200078e3cffULL, 0x0000000c00377c36ULL, 0x040fe20008000000ULL,
0xfffffff80c577812ULL, 0x000fe200078ee257ULL, 0x000000080b0c7824ULL, 0x040fe200078e00ffULL,
0xfffffff80d547812ULL, 0x000fe200078ee254ULL, 0x0000000bff0d7e24ULL, 0x000fe2000f8e00ffULL,
0x000000770b537212ULL, 0x080fe200078e3cffULL, 0x00000012040a7291ULL, 0x000fe2000f8e683fULL,
0x0000007747527212ULL, 0x080fe200078e3cffULL, 0x0000003000467836ULL, 0x040fe20000000000ULL,
0xfffffff80c537812ULL, 0x000fe200078ee253ULL, 0x000000080d0c7824ULL, 0x000fe200078e023cULL,
0x0000003c000d7810ULL, 0x000fe20007ffe0ffULL, 0x0000003800447836ULL, 0x000fe20000000000ULL,
0xfffffff819527812ULL, 0x000fe200078ee252ULL, 0x0000000845197824ULL, 0x040fe200078e00ffULL,
0x0000007745507212ULL, 0x080fe200078e3cffULL, 0x000000080d1b7824ULL, 0x040fe200078e00ffULL,
0x000000770d4e7212ULL, 0x000fe200078e3cffULL, 0x0000010037367825ULL, 0x002fe200078e000eULL,
0x000130000a0a7890ULL, 0x000fe2000fffe03fULL, 0xfffffff819507812ULL, 0x000fc400078ee250ULL,
0x00000008461a7824ULL, 0x040fe200078e00ffULL, 0x0000007746517212ULL, 0x080fe200078e3cffULL,
0x0000000c02197c36ULL, 0x000fe20008000000ULL, 0x0ffffff8185d7812ULL, 0x000fe200078ef877ULL,
0x00000008442c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b4e7812ULL, 0x000fe200078ee24eULL,
0x0000000c061b7c36ULL, 0x000fe20008000000ULL, 0x00000077444f7212ULL, 0x000fe200078e3cffULL,
0x0000000c052f7c36ULL, 0x000fe20008000000ULL, 0x0000000a5d3d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100c367825ULL, 0x000fe200078e0036ULL, 0xfffffff81a517812ULL, 0x000fc400078ee251ULL,
0xfffffff82c4f7812ULL, 0x000fe200078ee24fULL, 0x0000000c032d7c36ULL, 0x000fe20008000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000363d7faeULL, 0x0003e2000b901c50ULL,
0x0000010019187825ULL, 0x100fe200078e000eULL, 0x0000000c074b7c10ULL, 0x000fe4000fffe0ffULL,
0x0000000a5a5f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c04357c36ULL, 0x000fe20008000000ULL,
0x0000000a59617c11ULL, 0x000fe2000f8e20ffULL, 0x000001001b1a7825ULL, 0x000fe200078e000eULL,
0x0000000a58637c11ULL, 0x000fc6000f8e20ffULL, 0x000001002f2e7825ULL, 0x100fe200078e000eULL,
0x0000000a5c377c11ULL, 0x002fe4000f8e20ffULL, 0x0000000a5b3d7c11ULL, 0x000fe2000f8e20ffULL,
0x000001002d2c7825ULL, 0x000fc800078e000eULL, 0x0000010035347825ULL, 0x000fc800078e000eULL,
0x000000100c187825ULL, 0x000fc800078e0018ULL, 0x000000100c427825ULL, 0x000fe200078e001aULL,
0x0000000018377faeULL, 0x000fe6000b901c50ULL, 0x0000000c08417c36ULL, 0x000fe40008000000ULL,
0x0000000c091b7c36ULL, 0x000fe40008000000ULL, 0x000000100c3e7825ULL, 0x000fc800078e002eULL,
0x0000000c0b657c36ULL, 0x000fe40008000000ULL, 0x000000100c2c7825ULL, 0x000fc800078e002cULL,
0x0000000c0a2f7c36ULL, 0x000fe20008000000ULL, 0x000000002c3d7faeULL, 0x0003e2000b901c50ULL,
0x000000100c347825ULL, 0x000fc800078e0034ULL, 0x000001004b4a7825ULL, 0x100fe200078e000eULL,
0x00000000345f7faeULL, 0x0005e6000b901c50ULL, 0x0000010041407825ULL, 0x100fe200078e000eULL,
0x000000003e617faeULL, 0x0007e2000b901c50ULL, 0x0000000a563d7c11ULL, 0x002fe4000f8e20ffULL,
0x000001001b367825ULL, 0x100fe200078e000eULL, 0x0000000042637faeULL, 0x0003e6000b901c50ULL,
0x00000100651a7825ULL, 0x000fe200078e000eULL, 0x0000000a57357c11ULL, 0x004fc4000f8e20ffULL,
0x0000000a555f7c11ULL, 0x000fe2000f8e20ffULL, 0x000001002f2e7825ULL, 0x000fe200078e000eULL,
0x0000000a54617c11ULL, 0x008fc6000f8e20ffULL, 0x000000100c187825ULL, 0x000fe200078e004aULL,
0x0000000a53637c11ULL, 0x002fc6000f8e20ffULL, 0x000000100c2c7825ULL, 0x040fe200078e0040ULL,
0x0000000018357faeULL, 0x000fe6000b901c50ULL, 0x0000000c474b7c36ULL, 0x000fe20008000000ULL,
0x000000002c3d7faeULL, 0x0003e2000b901c50ULL, 0x000000100c427825ULL, 0x000fc800078e001aULL,
0x0000000c46417c36ULL, 0x000fe40008000000ULL, 0x000000100c3e7825ULL, 0x000fc800078e002eULL,
0x0000000c451b7c36ULL, 0x000fe20008000000ULL, 0x0000000a513d7c11ULL, 0x002fe2000f8e20ffULL,
0x0000000c442f7c36ULL, 0x000fe40008000000ULL, 0x000000100c367825ULL, 0x000fc800078e0036ULL,
0x0000000c0d657c36ULL, 0x000fe20008000000ULL, 0x00000000365f7faeULL, 0x0003e2000b901c50ULL,
0x000001004b4a7825ULL, 0x000fc600078e000eULL, 0x000000003e617faeULL, 0x0005e2000b901c50ULL,
0x0000010041407825ULL, 0x000fc600078e000eULL, 0x0000000042637faeULL, 0x0007e2000b901c50ULL,
0x000001001b347825ULL, 0x000fe200078e000eULL, 0x0000000a52377c11ULL, 0x002fc6000f8e20ffULL,
0x000001002f2e7825ULL, 0x100fe200078e000eULL, 0x0000000a4e5f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a503f7c11ULL, 0x004fe2000f8e20ffULL, 0x00000100651a7825ULL, 0x000fe200078e000eULL,
0x0000000a4f437c11ULL, 0x008fc6000f8e20ffULL, 0x000000100c187825ULL, 0x000fc800078e004aULL,
0x000000100c2c7825ULL, 0x040fe200078e0040ULL, 0x0000000018377faeULL, 0x0003e6000b901c50ULL,
0x000000100c347825ULL, 0x040fe200078e0034ULL, 0x000000002c3d7faeULL, 0x0003e6000b901c50ULL,
0x000000100c2e7825ULL, 0x040fe200078e002eULL, 0x00000000343f7faeULL, 0x0003e6000b901c50ULL,
0x000000100c1a7825ULL, 0x000fe200078e001aULL, 0x000000002e437faeULL, 0x0003e8000b901c50ULL,
0x000000001a5f7faeULL, 0x0003e4000b901c50ULL, 0x0000ffff76187812ULL, 0x002fe200078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001077797824ULL, 0x000fe200078e00ffULL,
0x00000001ff787819ULL, 0x000fe20000011677ULL, 0x00000008130b7291ULL, 0x000fe2000f8e383fULL,
0x00008880186d7816ULL, 0x000fe400000000ffULL, 0x0000007079797812ULL, 0x000fe400078ec0ffULL,
0x0000001f6d187819ULL, 0x000fe400000006ffULL, 0x0000000c78787812ULL, 0x000fc400078ec0ffULL,
0x02360818ff0075a7ULL, 0x000e640008000147ULL, 0x0000000b78657c10ULL, 0x000fe2000fffe079ULL,
0x000000bc00788947ULL, 0x002fec0003800000ULL, 0x0230000065187984ULL, 0x000e620000000800ULL,
0x00000008771b7812ULL, 0x000fe200078ec0ffULL, 0x00000012090c7291ULL, 0x000fe2000f8e683fULL,
0x000000083c487812ULL, 0x000fe200078ef877ULL, 0x0232000065657984ULL, 0x000ea20000000800ULL,
0x00000004ff3d7819ULL, 0x000fe20000011677ULL, 0x00000001ff3e7424ULL, 0x000fe200078e00ffULL,
0x0000003c1b4a7212ULL, 0x000fe400078efcffULL, 0x000000071b3c7812ULL, 0x000fe400078ec83cULL,
0x000000073d737812ULL, 0x000fc400078e7848ULL, 0x000000491800720bULL, 0x002fda0003f1d000ULL,
0x0000000000197806ULL, 0x000fc800000e0100ULL, 0x0000ffff192d7812ULL, 0x000fda000780c0ffULL,
0x0000000000e08947ULL, 0x004fea0003800000ULL, 0x000000491800720bULL, 0x000fe20003f14000ULL,
0x000000141300728cULL, 0x000fe2000bf05270ULL, 0x00000018492f7209ULL, 0x000fe40007810000ULL,
0x00000002ff1b7819ULL, 0x000fc60000011677ULL, 0x8000002f49197221ULL, 0x100fe20000010000ULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x000000081b2c7836ULL, 0x000fe40000000000ULL,
0x3fb8aa3b191a7820ULL, 0x000fe20000410000ULL, 0x00000008140b8291ULL, 0x000fe2000f8e383fULL,
0x0000000000197806ULL, 0x000fe200000e0100ULL, 0x000000ffff497224ULL, 0x000fc600078e002fULL,
0x0000ffff192e7812ULL, 0x000fe200078e3cffULL, 0x0000001a001a7308ULL, 0x000e660000000800ULL,
0x0000002e2dff7212ULL, 0x000fc8000780c0ffULL, 0x00000001ff3e7807ULL, 0x000fe20000000000ULL,
0x00001f2c1a2c7589ULL, 0x002e7000000e0000ULL, 0x8000002f18190221ULL, 0x000fe20000010000ULL,
0x0000000b78189c10ULL, 0x000fe2000fffe079ULL, 0x0000001a4d4d7220ULL, 0x000fe20000410000ULL,
0x00001f1b1a1b7589ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b19190820ULL, 0x000fc60000410000ULL,
0x0234002f18009388ULL, 0x0007e20000000800ULL, 0x00000019005e0308ULL, 0x000f220000000800ULL,
0x0000002c33337220ULL, 0x082fe20000410000ULL, 0x0000002c32327220ULL, 0x080fe20000410000ULL,
0x0000002c13137220ULL, 0x080fe20000410000ULL, 0x0000002c12127220ULL, 0x080fe20000410000ULL,
0x0000002c27277220ULL, 0x080fe20000410000ULL, 0x0000002c26267220ULL, 0x080fe20000410000ULL,
0x0000002c23237220ULL, 0x080fe20000410000ULL, 0x0000002c22227220ULL, 0x080fe20000410000ULL,
0x0000002c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000002c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000002c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000002c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000002c17177220ULL, 0x080fe20000410000ULL, 0x0000002c16167220ULL, 0x080fe20000410000ULL,
0x0000002c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000002c3a3a7220ULL, 0x000fe20000410000ULL,
0x0000001b31317220ULL, 0x084fe20000410000ULL, 0x0000001b30307220ULL, 0x080fe20000410000ULL,
0x0000001b11117220ULL, 0x080fe20000410000ULL, 0x0000001b10107220ULL, 0x080fe20000410000ULL,
0x0000001b25257220ULL, 0x080fe20000410000ULL, 0x0000001b24247220ULL, 0x080fe20000410000ULL,
0x0000001b21217220ULL, 0x080fe20000410000ULL, 0x0000001b20207220ULL, 0x080fe20000410000ULL,
0x0000001b1d1d7220ULL, 0x080fe20000410000ULL, 0x0000001b1c1c7220ULL, 0x080fe20000410000ULL,
0x0000001b29297220ULL, 0x080fe20000410000ULL, 0x0000001b28287220ULL, 0x080fe20000410000ULL,
0x0000001b15157220ULL, 0x080fe20000410000ULL, 0x0000001b14147220ULL, 0x080fe20000410000ULL,
0x0000001b39397220ULL, 0x080fe20000410000ULL, 0x0000001b38387220ULL, 0x000fe20000410000ULL,
0x0000005e65650220ULL, 0x018fce0000410000ULL, 0x000000023d617836ULL, 0x000fe20000000000ULL,
0x00000008130b7291ULL, 0x000fe2000f8e583fULL, 0x0000000848737824ULL, 0x000fe200078e0273ULL,
0x000130000c0c7890ULL, 0x000fe2000fffe03fULL, 0x0000003d3c607212ULL, 0x000fe200078e3cffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000613c5f7212ULL, 0x000fe200078e3cffULL,
0x000000084a727824ULL, 0x040fe200078e0260ULL, 0x0000000b73347c11ULL, 0x000fe2000f8e20ffULL,
0x000000063d677836ULL, 0x000fe20000000000ULL, 0x000000043d197810ULL, 0x000fe20007ffe0ffULL,
0x000000084a717824ULL, 0x000fe200078e025fULL, 0x00000002ff7a7819ULL, 0x000fe20000011677ULL,
0x0000000f0d00728cULL, 0x000fe2000bf06070ULL, 0x011000003434783bULL, 0x000fe20000000200ULL,
0x000000193c667212ULL, 0x000fe200078e3cffULL, 0x0000004d654d7221ULL, 0x000fe20000010000ULL,
0x0000000c71187c11ULL, 0x000fe2000f8e20ffULL, 0x000000087a627836ULL, 0x000fe20000000000ULL,
0x0000000c722c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000084a707824ULL, 0x000fe200078e0266ULL,
0x0000005eff3f723eULL, 0x000fc400000000ffULL, 0x000000001818783bULL, 0x000fe20000004200ULL,
0x000099103e3e7816ULL, 0x000fe400000000ffULL, 0x000054103f637816ULL, 0x000fe2000000003fULL,
0x000000002c2c783bULL, 0x000fe20000004200ULL, 0x000000673c677212ULL, 0x000fe200078e3cffULL,
0x000000ffff3c7224ULL, 0x000fe200078e003eULL, 0x0000000c70407c11ULL, 0x000fe2000f8e20ffULL,
0x00001f7a634c7589ULL, 0x000e6200000e0000ULL, 0x0000000761617812ULL, 0x000fe200078e7848ULL,
0x000000084a6f7824ULL, 0x000fe200078e0267ULL, 0x000000ff3c00720cULL, 0x000fe20003f05270ULL,
0x00001f62634b7589ULL, 0x0004e400000e0000ULL, 0x00000008486e7824ULL, 0x000fe200078e0261ULL,
0x0000000c6f3c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000004040783bULL, 0x000f220000004200ULL,
0x000000804a617811ULL, 0x000fc800078e18ffULL, 0x000000003c3c783bULL, 0x000f620000004200ULL,
0x000000015f6b7824ULL, 0x100fe200078e0261ULL, 0x0000006167757210ULL, 0x000fe20007ffe0ffULL,
0x00000001606c7824ULL, 0x100fe200078e0261ULL, 0x000001004a627811ULL, 0x004fe200078e18ffULL,
0x0000000166747824ULL, 0x000fc800078e0261ULL, 0x0000000160697824ULL, 0x100fe400078e0262ULL,
0x0000004c34348232ULL, 0x082fe40000000000ULL, 0x000000015f687824ULL, 0x100fe400078e0262ULL,
0x0000004c36368232ULL, 0x000fe40000000000ULL, 0x0000000166637824ULL, 0x000fe400078e0262ULL,
0x0000004b35358232ULL, 0x008fc40000000000ULL, 0x0000000167627824ULL, 0x000fe400078e0262ULL,
0x0000004b37378232ULL, 0x000fce0000000000ULL, 0x000000183428723cULL, 0x000fec0000001828ULL,
0x0000002c3438723cULL, 0x000fe20000001838ULL, 0x0000000b6e187c11ULL, 0x000fca000f8e20ffULL,
0x0000001a341c723cULL, 0x000fe2000000181cULL, 0x011000001818783bULL, 0x000e6a0000000200ULL,
0x0000002e342c723cULL, 0x000fec0000001814ULL, 0x000000403420723cULL, 0x010fe20000001820ULL,
0x0000000c6b147c11ULL, 0x000fca000f8e20ffULL, 0x000000423424723cULL, 0x000fe20000001824ULL,
0x000000001414783bULL, 0x000ea20000004200ULL, 0x0000000c6c407c11ULL, 0x000fc8000f8e20ffULL,
0x0000003c3410723cULL, 0x020fe40000001810ULL, 0x000000004040783bULL, 0x000ee80000004200ULL,
0x0000003e3430723cULL, 0x000fe20000001830ULL, 0x0000000c743c7c11ULL, 0x000fcc000f8e20ffULL,
0x0000000c75347c11ULL, 0x000fe2000f8e20ffULL, 0x000000003c3c783bULL, 0x000fe20000004200ULL,
0x0000004c18188232ULL, 0x002fc80000000000ULL, 0x000000003434783bULL, 0x000e620000004200ULL,
0x0000004c1a1a8232ULL, 0x000fe40000000000ULL, 0x0000004b19198232ULL, 0x080fe40000000000ULL,
0x0000004b1b1b8232ULL, 0x000fce0000000000ULL, 0x000000141828723cULL, 0x004fec0000001828ULL,
0x00000016181c723cULL, 0x000fe2000000181cULL, 0x0000000477157811ULL, 0x000fc800078fe0ffULL,
0x0000000715157812ULL, 0x000fe200078e7848ULL, 0x000000401838723cULL, 0x008fe80000001838ULL,
0x00000008486a7824ULL, 0x000fe400078e0215ULL, 0x00000042182c723cULL, 0x000fe2000000182cULL,
0x0000000c68407c11ULL, 0x000fe4000f8e20ffULL, 0x0000000b6a147c11ULL, 0x000fc6000f8e20ffULL,
0x000000341810723cULL, 0x002fe20000001810ULL, 0x000000004040783bULL, 0x000fe80000004200ULL,
0x011000001414783bULL, 0x000e620000000200ULL, 0x000000361830723cULL, 0x000fe20000001830ULL,
0x0000000c69347c11ULL, 0x000fca000f8e20ffULL, 0x0000003c1820723cULL, 0x000fe20000001820ULL,
0x000000003434783bULL, 0x000eaa0000004200ULL, 0x0000003e1824723cULL, 0x000fe20000001824ULL,
0x0000000c633c7c11ULL, 0x000fcc000f8e20ffULL, 0x0000000c62187c11ULL, 0x000fe2000f8e20ffULL,
0x000000003c3c783bULL, 0x000eea0000004200ULL, 0x000000001818783bULL, 0x000f220000004200ULL,
0x0000004c14148232ULL, 0x082fe40000000000ULL, 0x0000004c16168232ULL, 0x000fe40000000000ULL,
0x0000004b15158232ULL, 0x000fc40000000000ULL, 0x0000004b17178232ULL, 0x000fce0000000000ULL,
0x000000341438723cULL, 0x004fec0000001838ULL, 0x000000361434723cULL, 0x000fec000000182cULL,
0x000000401428723cULL, 0x000fe20000001828ULL, 0x00000006772d7811ULL, 0x000fc800078fe0ffULL,
0x000000072d2d7812ULL, 0x000fe200078e7848ULL, 0x0000003c1420723cULL, 0x008fe80000001820ULL,
0x0000000848617824ULL, 0x000fe200078e022dULL, 0x000001804a487811ULL, 0x000fe200078e18ffULL,
0x000000181410723cULL, 0x010fe60000001810ULL, 0x0000000b612c7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000160607824ULL, 0x000fc400078e0248ULL, 0x000000015f5f7824ULL, 0x100fe200078e0248ULL,
0x00000042141c723cULL, 0x000fe2000000181cULL, 0x00000001664a7824ULL, 0x000fe200078e0248ULL,
0x011000002c2c783bULL, 0x000e620000000200ULL, 0x0000004867487210ULL, 0x000fe40007ffe0ffULL,
0x0000000c60667c11ULL, 0x000fe2000f8e20ffULL, 0x0000003e1424723cULL, 0x000fe20000001824ULL,
0x0000000c5f407c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c4a3c7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000c48187c11ULL, 0x000fe2000f8e20ffULL, 0x0000001a1430723cULL, 0x000fe20000001830ULL,
0x000000006614783bULL, 0x000ea80000004200ULL, 0x000000004040783bULL, 0x000ee80000004200ULL,
0x000000003c3c783bULL, 0x000f280000004200ULL, 0x000000001818783bULL, 0x000f620000004200ULL,
0x0000004c2c2c8232ULL, 0x002fc40000000000ULL, 0x0000004c2e2e8232ULL, 0x000fe40000000000ULL,
0x0000004b2d2d8232ULL, 0x080fe40000000000ULL, 0x0000004b2f2f8232ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x00000001ff4b7424ULL, 0x000fc800078e00ffULL,
0x0236104bffff79a7ULL, 0x0003e20008500007ULL, 0x000000142c38723cULL, 0x004fec0000001838ULL,
0x000000162c14723cULL, 0x000fec0000001834ULL, 0x000000402c28723cULL, 0x008fec0000001828ULL,
0x000000422c1c723cULL, 0x000fec000000181cULL, 0x0000003c2c20723cULL, 0x010fec0000001820ULL,
0x0000003e2c24723cULL, 0x000fec0000001824ULL, 0x000000182c10723cULL, 0x020fec0000001810ULL,
0x0000001a2c30723cULL, 0x000fe20000001830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000001400d00947ULL, 0x002fde0003800000ULL, 0x00000000640472caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000000415047290ULL, 0x000fc8000fffe03fULL,
0x00000001040c7890ULL, 0x000fe4000fffe03fULL, 0x0000001604047291ULL, 0x000fe4000f8e403fULL,
0x000000050c00728cULL, 0x000fe4000bf06070ULL, 0x0000000e060c72a4ULL, 0x000fc8000f8e0204ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000400b08947ULL, 0x000fea0003800000ULL,
0x000000040f00728cULL, 0x000fe4000bf01070ULL, 0x80000004ff427e24ULL, 0x000fe4000f8e02ffULL,
0x0000000c00197c36ULL, 0x000fe20008000000ULL, 0x000000040f0d7287ULL, 0x000fe2000c000000ULL,
0x0000000c04377c36ULL, 0x000fe20008000000ULL, 0x0000000109047892ULL, 0x000fe2000f8ec03fULL,
0x0000010019187825ULL, 0x000fc600078e000eULL, 0x0000001204097291ULL, 0x000fe2000f8e683fULL,
0x0000000dff1b7e24ULL, 0x000fe4000f8e00ffULL, 0x000000100c187825ULL, 0x000fe200078e0018ULL,
0x0001300009097890ULL, 0x000fe4000fffe03fULL, 0x0000004042427446ULL, 0x000fe2000380001bULL,
0x0000000c021b7c36ULL, 0x000fe40008000000ULL, 0x0000000c05357c36ULL, 0x000fe20008000000ULL,
0x000000420000720cULL, 0x080fe20003f06070ULL, 0x000001001b1a7825ULL, 0x000fe200078e000eULL,
0x000000420200720cULL, 0x000fc40003f26070ULL, 0x000000095d5d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000c062f7c36ULL, 0x000fe20008000000ULL, 0x000000095c2d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100c1a7825ULL, 0x000fe200078e001aULL, 0x000000420300720cULL, 0x0c0fe40003f86070ULL,
0x000000420400720cULL, 0x080fe20003fa6070ULL, 0x0000000c03037c36ULL, 0x000fe20008000000ULL,
0x000000420500720cULL, 0x080fe20003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000185d7faeULL, 0x0003e2000c101c50ULL, 0x000000420900720cULL, 0x0c0fe20003f66070ULL,
0x0000000c09097c36ULL, 0x000fe20008000000ULL, 0x000000420600720cULL, 0x080fe20003f06070ULL,
0x000000001a2d7faeULL, 0x0005e2000c901c50ULL, 0x000000420700720cULL, 0x000fe20003f26070ULL,
0x0000010003047825ULL, 0x000fe200078e000eULL, 0x0000000c07077c10ULL, 0x000fc4000fffe0ffULL,
0x000000420800720cULL, 0x000fe20003f46070ULL, 0x0000000c0a3d7c36ULL, 0x000fe20008000000ULL,
0x000000095b5b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c08197c36ULL, 0x002fe20008000000ULL,
0x0000000959597c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c0b5d7c36ULL, 0x000fe20008000000ULL,
0x0000000957577c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c47657c36ULL, 0x000fe20008000000ULL,
0x0000000955557c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c46677c36ULL, 0x000fe20008000000ULL,
0x0000000953537c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c45417c36ULL, 0x000fe20008000000ULL,
0x0000000951517c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c443f7c36ULL, 0x000fe20008000000ULL,
0x000000094f4f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000010037367825ULL, 0x000fc800078e000eULL,
0x0000000c0d437c36ULL, 0x000fe40008000000ULL, 0x0000010035347825ULL, 0x000fc800078e000eULL,
0x00000100191a7825ULL, 0x004fc800078e000eULL, 0x000001002f2e7825ULL, 0x000fc800078e000eULL,
0x0000010009187825ULL, 0x000fc800078e000eULL, 0x00000100072c7825ULL, 0x000fc800078e000eULL,
0x000001003d087825ULL, 0x000fc800078e000eULL, 0x000001005d027825ULL, 0x000fe200078e000eULL,
0x00000009585d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000010065067825ULL, 0x000fc800078e000eULL,
0x000000100c047825ULL, 0x000fc800078e0004ULL, 0x00000100673c7825ULL, 0x100fe200078e000eULL,
0x00000000045b7faeULL, 0x0003e2000e101c50ULL, 0x000000420a00720cULL, 0x000fe40003f86070ULL,
0x0000010041407825ULL, 0x000fc800078e000eULL, 0x000001003f3e7825ULL, 0x000fc800078e000eULL,
0x00000100430e7825ULL, 0x000fe200078e000eULL, 0x000000095a437c11ULL, 0x000fe4000f8e20ffULL,
0x0000000956057c11ULL, 0x002fe2000f8e20ffULL, 0x000000100c367825ULL, 0x000fc800078e0036ULL,
0x000000100c347825ULL, 0x040fe200078e0034ULL, 0x0000000036437faeULL, 0x000fe2000e901c50ULL,
0x000000420b00720cULL, 0x080fe40003fa6070ULL, 0x000000100c2e7825ULL, 0x040fe200078e002eULL,
0x0000000034597faeULL, 0x000fe2000f101c50ULL, 0x000000424700720cULL, 0x080fe40003fc6070ULL,
0x000000100c2c7825ULL, 0x000fe200078e002cULL, 0x000000002e5d7faeULL, 0x000fe2000c101c50ULL,
0x000000424600720cULL, 0x000fc40003f06070ULL, 0x000000100c1a7825ULL, 0x040fe200078e001aULL,
0x000000002c577faeULL, 0x000fe2000c901c50ULL, 0x000000424500720cULL, 0x080fe40003f26070ULL,
0x000000100c187825ULL, 0x000fe200078e0018ULL, 0x000000001a057faeULL, 0x0005e2000d101c50ULL,
0x000000424400720cULL, 0x080fe40003f46070ULL, 0x000000100c087825ULL, 0x000fe200078e0008ULL,
0x0000000018557faeULL, 0x0007e2000d901c50ULL, 0x000000420d00720cULL, 0x000fc40003f66070ULL,
0x00000009540b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100c027825ULL, 0x000fe200078e0002ULL,
0x00000009500d7c11ULL, 0x000fc6000f8e20ffULL, 0x000000100c067825ULL, 0x000fe200078e0006ULL,
0x0000000952057c11ULL, 0x004fe2000f8e20ffULL, 0x00000000080b7faeULL, 0x0003e4000e101c50ULL,
0x000000100c3c7825ULL, 0x000fe200078e003cULL, 0x000000094e197c11ULL, 0x008fe2000f8e20ffULL,
0x0000000002537faeULL, 0x0003e4000e901c50ULL, 0x000000100c407825ULL, 0x040fe400078e0040ULL,
0x0000000006057faeULL, 0x0003e4000f101c50ULL, 0x000000100c3e7825ULL, 0x000fc400078e003eULL,
0x000000003c517faeULL, 0x0003e4000c101c50ULL, 0x000000100c0e7825ULL, 0x000fe400078e000eULL,
0x00000000400d7faeULL, 0x0003e8000c901c50ULL, 0x000000003e4f7faeULL, 0x0003e8000d101c50ULL,
0x000000000e197faeULL, 0x0003e2000d901c50ULL, 0x0000000400587947ULL, 0x000fea0003800000ULL,
0x0000000109047892ULL, 0x000fe2000f8ec03fULL, 0x0000000c00437c10ULL, 0x000fe2000fffe0ffULL,
0x0000000c02197c36ULL, 0x000fe20008000000ULL, 0x0000000c0b0b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001204127291ULL, 0x000fe2000f8e683fULL, 0x0000000c032f7c36ULL, 0x000fe40008000000ULL,
0x0000000c043f7c36ULL, 0x000fe20008000000ULL, 0x0001300012127890ULL, 0x000fe2000fffe03fULL,
0x0000000c081b7c36ULL, 0x000fe40008000000ULL, 0x0000000c053d7c36ULL, 0x000fc40008000000ULL,
0x0000000c07357c36ULL, 0x000fe20008000000ULL, 0x000000125d5d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000c0a417c36ULL, 0x000fe20008000000ULL, 0x000000125b5b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000010043427825ULL, 0x000fe200078e000eULL, 0x0000001259597c11ULL, 0x000fe4000f8e20ffULL,
0x0000001257577c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c06377c36ULL, 0x000fe20008000000ULL,
0x0000001255557c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c092d7c36ULL, 0x000fe20008000000ULL,
0x0000001253537c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c47477c36ULL, 0x000fe20008000000ULL,
0x0000001251517c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c46657c36ULL, 0x000fe20008000000ULL,
0x000000124f4f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c45077c36ULL, 0x000fe20008000000ULL,
0x000000125a457c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c44057c36ULL, 0x000fc40008000000ULL,
0x0000010019027825ULL, 0x000fc800078e000eULL, 0x0000000c0d0d7c36ULL, 0x000fe40008000000ULL,
0x000001002f2e7825ULL, 0x000fc800078e000eULL, 0x000001003f3e7825ULL, 0x000fc800078e000eULL,
0x000001001b087825ULL, 0x000fc800078e000eULL, 0x000001003d3c7825ULL, 0x000fc800078e000eULL,
0x00000100411a7825ULL, 0x000fc800078e000eULL, 0x000001000b187825ULL, 0x000fc800078e000eULL,
0x0000010037367825ULL, 0x000fc800078e000eULL, 0x0000010035347825ULL, 0x000fc800078e000eULL,
0x000001002d2c7825ULL, 0x000fc800078e000eULL, 0x00000100470a7825ULL, 0x000fe200078e000eULL,
0x0000001258477c11ULL, 0x000fc6000f8e20ffULL, 0x0000010065407825ULL, 0x000fc800078e000eULL,
0x0000010007067825ULL, 0x000fc800078e000eULL, 0x0000010005047825ULL, 0x000fc800078e000eULL,
0x000001000d0e7825ULL, 0x000fe200078e000eULL, 0x000000125c0d7c11ULL, 0x000fc6000f8e20ffULL,
0x000000100c427825ULL, 0x000fc800078e0042ULL, 0x000000100c027825ULL, 0x040fe200078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000425d7faeULL, 0x0003e6000b901c50ULL,
0x000000100c2e7825ULL, 0x040fe200078e002eULL, 0x00000000020d7faeULL, 0x0005e6000b901c50ULL,
0x000000100c3e7825ULL, 0x040fe200078e003eULL, 0x000000002e5b7faeULL, 0x0007e6000b901c50ULL,
0x000000100c3c7825ULL, 0x000fe200078e003cULL, 0x0000001256437c11ULL, 0x002fe2000f8e20ffULL,
0x000000003e457faeULL, 0x0003e2000b901c50ULL, 0x00000012545d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100c367825ULL, 0x000fe200078e0036ULL, 0x0000001252037c11ULL, 0x004fe2000f8e20ffULL,
0x000000003c597faeULL, 0x0003e2000b901c50ULL, 0x00000012500d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100c347825ULL, 0x000fe200078e0034ULL, 0x000000124e2f7c11ULL, 0x008fe2000f8e20ffULL,
0x0000000036477faeULL, 0x0003e4000b901c50ULL, 0x000000100c087825ULL, 0x000fc400078e0008ULL,
0x0000000034577faeULL, 0x0003e4000b901c50ULL, 0x000000100c2c7825ULL, 0x040fe400078e002cULL,
0x0000000008437faeULL, 0x0003e4000b901c50ULL, 0x000000100c1a7825ULL, 0x040fe400078e001aULL,
0x000000002c557faeULL, 0x0003e4000b901c50ULL, 0x000000100c187825ULL, 0x000fc400078e0018ULL,
0x000000001a5d7faeULL, 0x0003e4000b901c50ULL, 0x000000100c0a7825ULL, 0x040fe400078e000aULL,
0x0000000018537faeULL, 0x0003e4000b901c50ULL, 0x000000100c407825ULL, 0x040fe400078e0040ULL,
0x000000000a037faeULL, 0x0003e4000b901c50ULL, 0x000000100c067825ULL, 0x000fc400078e0006ULL,
0x0000000040517faeULL, 0x0003e4000b901c50ULL, 0x000000100c047825ULL, 0x040fe400078e0004ULL,
0x00000000060d7faeULL, 0x0003e4000b901c50ULL, 0x000000100c0e7825ULL, 0x000fe400078e000eULL,
0x00000000044f7faeULL, 0x0003e8000b901c50ULL, 0x000000000e2f7faeULL, 0x0003e4000b901c50ULL,
0x800000006d027824ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000013f097899ULL, 0x000fe40008011614ULL, 0x02362802ff0075a7ULL, 0x000e640008000147ULL,
0x0000000209097890ULL, 0x000fc8000fffe03fULL, 0x00000008090c7291ULL, 0x000fcc000f8e383fULL,
0x0000000c78047c10ULL, 0x000fe2000fffe079ULL, 0x000000a000f88947ULL, 0x002fec0003800000ULL,
0x0230000004027984ULL, 0x000e620000000800ULL, 0x000010000b0b7890ULL, 0x000fe2000fffe03fULL,
0x00000001ff0c7424ULL, 0x000fe400078e00ffULL, 0x000000087a3c7836ULL, 0x000fc60000000000ULL,
0x0000000b73077c11ULL, 0x000fe4000f8e20ffULL, 0x000000490200720bULL, 0x002fda0003f1d000ULL,
0x0000000000007806ULL, 0x000fc800000e0100ULL, 0x0000ffff00067812ULL, 0x000fe4000780c0ffULL,
0x0232000004007984ULL, 0x0002b60000000800ULL, 0x0000000000d88947ULL, 0x002fea0003800000ULL,
0x000000490200720bULL, 0x000fe20003f14000ULL, 0x000000140900728cULL, 0x000fe2000bf05270ULL,
0x0000000249047209ULL, 0x000fca0007810000ULL, 0x8000000449037221ULL, 0x000fe20000010000ULL,
0x000000000000781cULL, 0x000fe40003f2f008ULL, 0x0000000400497202ULL, 0x000fe20000000f00ULL,
0x3fb8aa3b03057820ULL, 0x000fe20000410000ULL, 0x0000000814098291ULL, 0x000fe2000f8e383fULL,
0x0000000000037806ULL, 0x000fc800000e0100ULL, 0x0000ffff03097812ULL, 0x000fe200078e3cffULL,
0x0000000500057308ULL, 0x000e660000000800ULL, 0x0000000906ff7212ULL, 0x000fe4000780c0ffULL,
0x0000000978799c10ULL, 0x000fe4000fffe079ULL, 0x00000001ff0c7807ULL, 0x000fc60000000000ULL,
0x0234000479009388ULL, 0x000fe80000000800ULL, 0x00001f7a05037589ULL, 0x002e6400000e0000ULL,
0x8000000402060221ULL, 0x000fe20000010000ULL, 0x000000054d4d7220ULL, 0x000fe20000410000ULL,
0x00001f3c05027589ULL, 0x000ee400000e0000ULL, 0x3fb8aa3b06060820ULL, 0x000fc80000410000ULL,
0x00000006005e0308ULL, 0x000f220000000800ULL, 0x0000000338387220ULL, 0x082fe20000410000ULL,
0x0000000339397220ULL, 0x080fe20000410000ULL, 0x0000000314147220ULL, 0x080fe20000410000ULL,
0x0000000315157220ULL, 0x080fe20000410000ULL, 0x0000000328287220ULL, 0x080fe20000410000ULL,
0x0000000329297220ULL, 0x080fe20000410000ULL, 0x000000031c1c7220ULL, 0x080fe20000410000ULL,
0x000000031d1d7220ULL, 0x080fe20000410000ULL, 0x0000000320207220ULL, 0x080fe20000410000ULL,
0x0000000321217220ULL, 0x080fe20000410000ULL, 0x0000000324247220ULL, 0x080fe20000410000ULL,
0x0000000325257220ULL, 0x080fe20000410000ULL, 0x0000000310107220ULL, 0x080fe20000410000ULL,
0x0000000311117220ULL, 0x080fe20000410000ULL, 0x0000000330307220ULL, 0x080fe20000410000ULL,
0x0000000331317220ULL, 0x000fe20000410000ULL, 0x000000023a3a7220ULL, 0x088fe20000410000ULL,
0x000000023b3b7220ULL, 0x080fe20000410000ULL, 0x0000000216167220ULL, 0x080fe20000410000ULL,
0x0000000217177220ULL, 0x080fe20000410000ULL, 0x000000022a2a7220ULL, 0x080fe20000410000ULL,
0x000000022b2b7220ULL, 0x080fe20000410000ULL, 0x000000021e1e7220ULL, 0x080fe20000410000ULL,
0x000000021f1f7220ULL, 0x080fe20000410000ULL, 0x0000000222227220ULL, 0x080fe20000410000ULL,
0x0000000223237220ULL, 0x080fe20000410000ULL, 0x0000000226267220ULL, 0x080fe20000410000ULL,
0x0000000227277220ULL, 0x080fe20000410000ULL, 0x0000000212127220ULL, 0x080fe20000410000ULL,
0x0000000213137220ULL, 0x080fe20000410000ULL, 0x0000000232327220ULL, 0x080fe20000410000ULL,
0x0000000233337220ULL, 0x000fe20000410000ULL, 0x000000005e000220ULL, 0x014fce0000410000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x011000000704783bULL, 0x000fe20000000200ULL,
0x0000000a72087c11ULL, 0x000fe2000f8e20ffULL, 0x0000004d004d7221ULL, 0x004fe20000010000ULL,
0x0000000a710d7c11ULL, 0x000fe4000f8e20ffULL, 0x000099100c197816ULL, 0x000fe400000000ffULL,
0x0000005eff02723eULL, 0x000fe200000000ffULL, 0x000000000808783bULL, 0x000fe20000004200ULL,
0x0000000a70187c11ULL, 0x000fe4000f8e20ffULL, 0x00005410023d7816ULL, 0x000fe20000000002ULL,
0x000000000d0c783bULL, 0x000fe20000004200ULL, 0x0000000b6e2c7c11ULL, 0x000fc4000f8e20ffULL,
0x000000ff1900720cULL, 0x000fe20003f05270ULL, 0x00001f7a3d037589ULL, 0x000e6200000e0000ULL,
0x0000000a6f347c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a6b407c11ULL, 0x000fe2000f8e20ffULL,
0x00001f3c3d027589ULL, 0x0004e200000e0000ULL, 0x0000000a62447c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a5f507c11ULL, 0x000fe2000f8e20ffULL, 0x000000001818783bULL, 0x000fe80000004200ULL,
0x011000002c2c783bULL, 0x000f220000000200ULL, 0x0000000a6c3c7c11ULL, 0x004fc6000f8e20ffULL,
0x000000003434783bULL, 0x000ea80000004200ULL, 0x000000003c3c783bULL, 0x000f680000004200ULL,
0x000000004040783bULL, 0x000ea20000004200ULL, 0x0000000304048232ULL, 0x082fe40000000000ULL,
0x0000000306068232ULL, 0x000fe20000000000ULL, 0x000000004444783bULL, 0x000fe20000004200ULL,
0x0000000205058232ULL, 0x008fc40000000000ULL, 0x0000000207078232ULL, 0x000fe20000000000ULL,
0x000000005050783bULL, 0x000fec0000004200ULL, 0x000000080438723cULL, 0x000fec0000001838ULL,
0x0000000c0428723cULL, 0x000fec0000001828ULL, 0x0000000a0408723cULL, 0x000fe20000001814ULL,
0x000000032c2c8232ULL, 0x010fc40000000000ULL, 0x000000032e2e8232ULL, 0x000fc60000000000ULL,
0x0000000e040c723cULL, 0x000fe2000000181cULL, 0x0000000a74147c11ULL, 0x000fe2000f8e20ffULL,
0x000000022d2d8232ULL, 0x080fe40000000000ULL, 0x000000022f2f8232ULL, 0x000fe40000000000ULL,
0x000000180420723cULL, 0x000fe20000001820ULL, 0x0000000a751c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000001414783bULL, 0x000e680000004200ULL, 0x0000001a0418723cULL, 0x000fe20000001824ULL,
0x000000001c1c783bULL, 0x000fea0000004200ULL, 0x000000340410723cULL, 0x004fe20000001810ULL,
0x0000000b6a247c11ULL, 0x000fca000f8e20ffULL, 0x000000360404723cULL, 0x000fe20000001830ULL,
0x011000002424783bULL, 0x000ea20000000200ULL, 0x0000000a69347c11ULL, 0x000fc8000f8e20ffULL,
0x0000003c2c38723cULL, 0x020fe20000001838ULL, 0x0000000b61307c11ULL, 0x000fe2000f8e20ffULL,
0x000000003434783bULL, 0x000fe80000004200ULL, 0x000000402c28723cULL, 0x000fe20000001828ULL,
0x0000000a683c7c11ULL, 0x000fe2000f8e20ffULL, 0x011000003030783bULL, 0x000ee80000000200ULL,
0x0000003e2c08723cULL, 0x000fe20000001808ULL, 0x0000000a63407c11ULL, 0x000fe2000f8e20ffULL,
0x000000003c3c783bULL, 0x000f280000004200ULL, 0x000000422c0c723cULL, 0x000fe2000000180cULL,
0x000000004040783bULL, 0x000f6a0000004200ULL, 0x000000142c20723cULL, 0x002fec0000001820ULL,
0x000000162c18723cULL, 0x000fe20000001818ULL, 0x0000000a60147c11ULL, 0x000fe2000f8e20ffULL,
0x0000000324248232ULL, 0x004fc80000000000ULL, 0x0000001c2c10723cULL, 0x000fe20000001810ULL,
0x000000001414783bULL, 0x000e620000004200ULL, 0x0000000326268232ULL, 0x080fe40000000000ULL,
0x0000000225258232ULL, 0x080fe40000000000ULL, 0x0000001e2c1c723cULL, 0x000fe20000001804ULL,
0x0000000227278232ULL, 0x000fe40000000000ULL, 0x0000000330308232ULL, 0x008fc80000000000ULL,
0x0000000a4a2c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000342438723cULL, 0x000fe20000001838ULL,
0x0000000a48047c11ULL, 0x000fe2000f8e20ffULL, 0x0000000332328232ULL, 0x000fe40000000000ULL,
0x0000000231318232ULL, 0x080fe20000000000ULL, 0x000000002c2c783bULL, 0x000ea20000004200ULL,
0x000000362408723cULL, 0x000fe20000001808ULL, 0x0000000233338232ULL, 0x000fe40000000000ULL,
0x000000000404783bULL, 0x000ee20000004200ULL, 0x0236304bffff79a7ULL, 0x0003e40008500007ULL,
0x0000003c2428723cULL, 0x010fec0000001828ULL, 0x0000003e240c723cULL, 0x000fec000000180cULL,
0x000000402420723cULL, 0x020fec0000001820ULL, 0x000000422418723cULL, 0x000fec0000001818ULL,
0x000000442410723cULL, 0x000fec0000001810ULL, 0x000000462444723cULL, 0x000fec000000181cULL,
0x000000143038723cULL, 0x002fec0000001838ULL, 0x000000163014723cULL, 0x000fec0000001808ULL,
0x000000503028723cULL, 0x000fec0000001828ULL, 0x00000052301c723cULL, 0x000fec000000180cULL,
0x0000002c3020723cULL, 0x004fec0000001820ULL, 0x0000002e3024723cULL, 0x000fec0000001818ULL,
0x000000043010723cULL, 0x008fec0000001810ULL, 0x000000063030723cULL, 0x000fde0000001844ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000001564647c36ULL, 0x000fe20008000000ULL,
0x000000ff76ff7812ULL, 0x000fc8000780c0ffULL, 0x0000000564007c0cULL, 0x000fe4000bf26070ULL,
0x00000001ff767807ULL, 0x000fd60000000000ULL, 0xffffffc400249947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x0002300008047890ULL, 0x000fe2000fffe03fULL,
0x00000000001679c3ULL, 0x000ea20000002500ULL, 0x000000013f067899ULL, 0x000fce0008011614ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000414097291ULL, 0x000fe4000f8e383fULL,
0x0000000106077899ULL, 0x000fc8000800063fULL, 0x0000000207077892ULL, 0x000fc8000f8e0c3fULL,
0x0000000107077892ULL, 0x000fc8000f8ef814ULL, 0x0000000407077291ULL, 0x000fcc000f8e383fULL,
0x00000007ff0c7e24ULL, 0x000fe2000f8e00ffULL, 0x000000051600728cULL, 0x004fe2000bf06070ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x100fe40000011600ULL,
0x00000002ff077819ULL, 0x000fe40000011600ULL, 0x0000007002097812ULL, 0x000fe200078ec0ffULL,
0x00000009ff027e24ULL, 0x000fe2000f8e00ffULL, 0x0000000c030a7812ULL, 0x000fe400078ec0ffULL,
0x000000000000781cULL, 0x000fc40003f0f008ULL, 0x0000020009027810ULL, 0x040fe40007ffe002ULL,
0x000000090a047c10ULL, 0x140fe4000fffe009ULL, 0x000000070a037c10ULL, 0x040fe2000fffe009ULL,
0x000000010a067824ULL, 0x000fe400078e0202ULL, 0x0000004904007388ULL, 0x0003e80000000800ULL,
0x0000004d06007388ULL, 0x000fe20000000800ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000020009047810ULL, 0x002fc40007ffe00cULL, 0x0000000800097811ULL, 0x000fc600078ff0ffULL,
0x000000010a047824ULL, 0x000fe200078e0204ULL, 0x0000000003037984ULL, 0x000e6a0000000800ULL,
0x0000000004047984ULL, 0x000ea20000000800ULL, 0x0000004903027209ULL, 0x002fca0007810000ULL,
0x0000004902057221ULL, 0x000fe20000010100ULL, 0x8000000203037221ULL, 0x000fc60000010000ULL,
0x3fb8aa3b05057820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b03037820ULL, 0x000fc60000410000ULL,
0x0000000500087308ULL, 0x000e700000000800ULL, 0x0000000300037308ULL, 0x000ea20000000800ULL,
0x00001f0708077589ULL, 0x002e6800000e0000ULL, 0x00001f0908097589ULL, 0x000ee200000e0000ULL,
0x0000000304037220ULL, 0x004fc80000410000ULL, 0x0000004d084d7223ULL, 0x000fe20000010003ULL,
0x00000010070a7220ULL, 0x042fe20000410000ULL, 0x0000003807387220ULL, 0x040fe20000410000ULL,
0x0000003907397220ULL, 0x040fe20000410000ULL, 0x0000001407147220ULL, 0x040fe20000410000ULL,
0x0000001507157220ULL, 0x040fe20000410000ULL, 0x0000002807067220ULL, 0x040fe20000410000ULL,
0x0000002907297220ULL, 0x040fe20000410000ULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x0000001d071d7220ULL, 0x040fe20000410000ULL, 0x0000002007207220ULL, 0x040fe20000410000ULL,
0x0000002107217220ULL, 0x040fe20000410000ULL, 0x0000002407247220ULL, 0x040fe20000410000ULL,
0x0000002507257220ULL, 0x040fe20000410000ULL, 0x0000001107117220ULL, 0x040fe20000410000ULL,
0x00000030070b7220ULL, 0x040fe20000410000ULL, 0x00000031070c7220ULL, 0x000fe20000410000ULL,
0x0000003a09107220ULL, 0x048fe20000410000ULL, 0x0000003b093b7220ULL, 0x040fe20000410000ULL,
0x0000001609167220ULL, 0x040fe20000410000ULL, 0x0000001709177220ULL, 0x040fe20000410000ULL,
0x0000002a092a7220ULL, 0x040fe20000410000ULL, 0x0000002b092b7220ULL, 0x040fe20000410000ULL,
0x0000001e091e7220ULL, 0x040fe20000410000ULL, 0x0000001f091f7220ULL, 0x040fe20000410000ULL,
0x0000002209227220ULL, 0x040fe20000410000ULL, 0x0000002309237220ULL, 0x040fe20000410000ULL,
0x0000002609267220ULL, 0x040fe20000410000ULL, 0x0000002709277220ULL, 0x040fe20000410000ULL,
0x00000012090e7220ULL, 0x040fe20000410000ULL, 0x00000013090f7220ULL, 0x040fe20000410000ULL,
0x0000003209327220ULL, 0x040fe20000410000ULL, 0x0000003309337220ULL, 0x000fe20000410000ULL,
0x0000000000c80947ULL, 0x000fec0003800000ULL, 0x018000004d007836ULL, 0x000fca0000000000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00005f5000047802ULL, 0x000fce0000000f00ULL,
0x0000009800c87944ULL, 0x000fea0003c00000ULL, 0x000000ffff037224ULL, 0x00cfe200078e0000ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000004d00007308ULL, 0x000e640000001000ULL,
0xbf8000004d037423ULL, 0x002fc80000000000ULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000300037223ULL, 0x000fce0000000000ULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x00000002ff047819ULL, 0x004fe40000011600ULL, 0x0000000800087811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0403047589ULL, 0x000ea800000e0000ULL,
0x00001f0803057589ULL, 0x000ee200000e0000ULL, 0x0000000438387220ULL, 0x084fe20000410000ULL,
0x0000000439397220ULL, 0x080fe20000410000ULL, 0x0000000414147220ULL, 0x080fe20000410000ULL,
0x0000000415157220ULL, 0x080fe20000410000ULL, 0x0000000406067220ULL, 0x080fe20000410000ULL,
0x0000000429297220ULL, 0x080fe20000410000ULL, 0x000000041c1c7220ULL, 0x080fe20000410000ULL,
0x000000041d1d7220ULL, 0x080fe20000410000ULL, 0x0000000420207220ULL, 0x080fe20000410000ULL,
0x0000000421217220ULL, 0x080fe20000410000ULL, 0x0000000424247220ULL, 0x080fe20000410000ULL,
0x0000000425257220ULL, 0x080fe20000410000ULL, 0x000000040a0a7220ULL, 0x080fe20000410000ULL,
0x0000000411117220ULL, 0x080fe20000410000ULL, 0x000000040b0b7220ULL, 0x080fe20000410000ULL,
0x000000040c0c7220ULL, 0x000fe20000410000ULL, 0x0000000510107220ULL, 0x088fe20000410000ULL,
0x000000053b3b7220ULL, 0x080fe20000410000ULL, 0x0000000516167220ULL, 0x080fe20000410000ULL,
0x0000000517177220ULL, 0x080fe20000410000ULL, 0x000000052a2a7220ULL, 0x080fe20000410000ULL,
0x000000052b2b7220ULL, 0x080fe20000410000ULL, 0x000000051e1e7220ULL, 0x080fe20000410000ULL,
0x000000051f1f7220ULL, 0x080fe20000410000ULL, 0x0000000522227220ULL, 0x080fe20000410000ULL,
0x0000000523237220ULL, 0x080fe20000410000ULL, 0x0000000526267220ULL, 0x080fe20000410000ULL,
0x0000000527277220ULL, 0x080fe20000410000ULL, 0x000000050e0e7220ULL, 0x080fe20000410000ULL,
0x000000050f0f7220ULL, 0x080fe20000410000ULL, 0x0000000532327220ULL, 0x080fe20000410000ULL,
0x0000000533337220ULL, 0x000fce0000410000ULL, 0x00000003ff0d7819ULL, 0x000fe20000011600ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0xfffffff8ff047812ULL, 0x000fe200078ee200ULL,
0x0000000114177892ULL, 0x000fe2000f8ec03fULL, 0x000000030d037812ULL, 0x000fe200078ec0ffULL,
0x000000011500788cULL, 0x000fe2000bf05270ULL, 0x0000000304057819ULL, 0x040fe200000006ffULL,
0x0000000804127836ULL, 0x000fe20000000000ULL, 0x0000000403077812ULL, 0x000fe200078efcffULL,
0x0000000817087291ULL, 0x000fe2000f8e603fULL, 0x0000000703087812ULL, 0x000fc400078e7804ULL,
0x00000007031a7812ULL, 0x000fe200078e7812ULL, 0x0000000812037824ULL, 0x000fe200078e00ffULL,
0x0000000707047812ULL, 0x000fe200078e7804ULL, 0x0000000806197291ULL, 0x000fe2000f8e583fULL,
0x0000000707127812ULL, 0x000fe400078e7812ULL, 0x0000000508187212ULL, 0x080fe400078efcffULL,
0x0000000504197212ULL, 0x000fe400078efcffULL, 0x000000031a1a7212ULL, 0x000fc400078efcffULL,
0x00000003121b7212ULL, 0x000fe200078efcffULL, 0x00000006ff037e24ULL, 0x000fe2000f8e00ffULL,
0x000000383904723eULL, 0x000fe400000000ffULL, 0x000000141505723eULL, 0x000fe400000000ffULL,
0x000000062906723eULL, 0x000fe400000000ffULL, 0x0000001c1d07723eULL, 0x000fe400000000ffULL,
0x0000001918187c11ULL, 0x000fc4000f8e20ffULL, 0x000000202108723eULL, 0x000fe400000000ffULL,
0x000000242509723eULL, 0x000fe200000000ffULL, 0x0000000418007844ULL, 0x000fe20000000200ULL,
0x0000000a110a723eULL, 0x000fe400000000ffULL, 0x0000000b0c0b723eULL, 0x000fe400000000ffULL,
0x0000001919197c11ULL, 0x000fe4000f8e20ffULL, 0x000000103b10723eULL, 0x000fc400000000ffULL,
0x000000161711723eULL, 0x000fe200000000ffULL, 0x0000000819007844ULL, 0x000fe20000000200ULL,
0x0000002a2b12723eULL, 0x000fe400000000ffULL, 0x0000001e1f13723eULL, 0x000fe400000000ffULL,
0x000000191a1a7c11ULL, 0x000fe4000f8e20ffULL, 0x000000222314723eULL, 0x000fe400000000ffULL,
0x000000262715723eULL, 0x000fe200000000ffULL, 0x000000101a007844ULL, 0x000fe20000000200ULL,
0x0000000e0f16723eULL, 0x000fe200000000ffULL, 0x00000020030f7824ULL, 0x000fe200078e0200ULL,
0x000000323317723eULL, 0x000fc400000000ffULL, 0x000000191b1b7c11ULL, 0x000fe4000f8e20ffULL,
0x000000080f0c7c11ULL, 0x000fe4000f8e20ffULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000000141b007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000000c1c7984ULL, 0x000ea80000000c00ULL, 0x000400000c247984ULL, 0x000ee80000000c00ULL,
0x000800000c207984ULL, 0x000f280000000c00ULL, 0x000c00000c287984ULL, 0x000f620000000c00ULL,
0x200000ff1f1f7230ULL, 0x004fc40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fe40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x008fe40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fc40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x010fe40000000000ULL, 0x000000221e1e7230ULL, 0x000fe40000000000ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x020fc40000000000ULL, 0x0000002a26267230ULL, 0x000fe20000000000ULL,
0x0000001c0c007388ULL, 0x0005e20000000c00ULL, 0x0000002925257230ULL, 0x000fe40000000000ULL,
0x0000002824247230ULL, 0x000fca0000000000ULL, 0x000400240c007388ULL, 0x0005e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000002800e88947ULL, 0x000fea0003800000ULL,
0x000000000c087984ULL, 0x0006e20000000c00ULL, 0x00000000000a79c3ULL, 0x000fe20000002700ULL,
0x00000001063f7892ULL, 0x000fe4000f80f814ULL, 0x000400000c147984ULL, 0x0006620000000c00ULL,
0x0000840000077ab9ULL, 0x000fe20000000800ULL, 0x0000900000097ab9ULL, 0x000fe20000000800ULL,
0x00000007150472a4ULL, 0x000fe2000f8e023fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x00000000000579c3ULL, 0x000f240000002600ULL, 0x00000009040972a4ULL, 0x000fc8000f8e023fULL,
0x01ffffff09187892ULL, 0x000fe4000f8ec03fULL, 0x000000070a0a72a4ULL, 0x010fc8000f8e0205ULL,
0x000000150a0772a4ULL, 0x000fc8000f8e023fULL, 0x00000016070b7290ULL, 0x000fe2000fffe03fULL,
0x0000000000380947ULL, 0x008ff60003800000ULL, 0x000000180b0c7290ULL, 0x000fe2000fffe03fULL,
0x0000001000047824ULL, 0x000fe200078e00ffULL, 0x0000960000047ab9ULL, 0x000fe20000000a00ULL,
0x00000001ff057819ULL, 0x000fe20000011600ULL, 0x000000800b0e78a5ULL, 0x000fe4000f8e0004ULL,
0x000000800c0478a5ULL, 0x000fe2000f8e0004ULL, 0x0000007004067812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000e05047c10ULL, 0x140fe4000fa3e006ULL,
0x0000000405067c10ULL, 0x000fe4000fc7e006ULL, 0x0000000fff057c10ULL, 0x000fe40008fe44ffULL,
0x00000005ff077c10ULL, 0x000fc60009fe84ffULL, 0x0000000204007986ULL, 0x0007e8000c101910ULL,
0x0000004d06007986ULL, 0x0007e4000c101910ULL, 0x00000fff09097891ULL, 0x000fe2000f8e403fULL,
0x000000ff0000720cULL, 0x000fe20000705670ULL, 0x0000960000127ab9ULL, 0x000fe20000000a00ULL,
0x0000000b171a7899ULL, 0x000fe2000800063fULL, 0x000000400f117836ULL, 0x000fe20000000000ULL,
0x0000000b09047291ULL, 0x000fe2000f8fa03fULL, 0x0000022000007945ULL, 0x000fe60003800000ULL,
0x00001000040478a5ULL, 0x000fc8000f8e0012ULL, 0x0000001a040b7290ULL, 0x000fc8000ff1e03fULL,
0x000000053f047290ULL, 0x000fe400087fe43fULL, 0x0000000bff047e24ULL, 0x008fc8000f8e00ffULL,
0x00000004ff057e24ULL, 0x000fe4000f8e00ffULL, 0x000000100f067825ULL, 0x000fc800078e0004ULL,
0x0000001011047825ULL, 0x000fe200078e0004ULL, 0x0000000806007986ULL, 0x0007e8000c101d10ULL,
0x0000001404007986ULL, 0x0027e2000c101d10ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000580947ULL, 0x000fea0003800000ULL, 0x0000940000047ab9ULL, 0x000fe20000000a00ULL,
0xffffffff150b7890ULL, 0x000fe4000fffe03fULL, 0x000000040a0478a5ULL, 0x000fc8000f8e0004ULL,
0x0000000bff077e24ULL, 0x008fe4000f8e00ffULL, 0x00000004ff047e24ULL, 0x000fe2000f8e00ffULL,
0x0000000500057c02ULL, 0x000fe20008000f00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0003ec0000008000ULL,
0x0000000000007992ULL, 0x002fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000007040479a8ULL, 0x000ee800099ee1d0ULL,
0x00000000ff00798fULL, 0x008fe20002000000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fc40000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000b04007c0cULL, 0x000fc8000bf05270ULL, 0x00000001ff027807ULL, 0x000fca0000000000ULL,
0x00000002ff007988ULL, 0x0003e80008000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000f300000008800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000400000a7882ULL, 0x000fc40000000000ULL, 0x00000654040a7896ULL, 0x010fd2000800000aULL,
0x0000000aff027984ULL, 0x002e640008000000ULL, 0x000000ff0200720cULL, 0x002fda0003f05270ULL,
0x0000002400b48947ULL, 0x000fea0003800000ULL, 0x00000014ff007c0cULL, 0x000fda000bf05270ULL,
0x0000000c008c0947ULL, 0x000fea0003800000ULL, 0x00000015ff007c0cULL, 0x000fda000bf05270ULL,
0x0000000000f08947ULL, 0x000fea0003800000ULL, 0x0000000107047890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001ff047819ULL, 0x008fe20000011600ULL,
0x00000080070c78a5ULL, 0x000fe4000f8e0012ULL, 0x00000080040478a5ULL, 0x000fe2000f8e0012ULL,
0x0000007002087812ULL, 0x000fe400078ec0ffULL, 0x0000000c04137812ULL, 0x000fc800078ec0ffULL,
0x0000000c13047c10ULL, 0x140fe4000f91e008ULL, 0x0000000413067c10ULL, 0x000fe4000fb5e008ULL,
0x0000000dff057c10ULL, 0x000fe400087e24ffULL, 0x00000005ff077c10ULL, 0x000fc600097e64ffULL,
0x0000001004027981ULL, 0x000368000c1e1900ULL, 0x0000001006097981ULL, 0x000362000c1e1900ULL,
0x000000021500788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x0000000207047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e0012ULL, 0x0000000413047c10ULL, 0x000fc8000f91e008ULL,
0x00000005ff057c10ULL, 0x000fca00087e24ffULL, 0x00000010040b7981ULL, 0x000362000c1e1900ULL,
0x000000041500788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000908947ULL, 0x002fea0003800000ULL, 0x0000000307047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e0012ULL, 0x0000000413047c10ULL, 0x000fc8000f91e008ULL,
0x00000005ff057c10ULL, 0x000fca00087e24ffULL, 0x00000010040d7981ULL, 0x000362000c1e1900ULL,
0x000000041500788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000708947ULL, 0x002fea0003800000ULL, 0x0000000407047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e0012ULL, 0x0000000413047c10ULL, 0x000fc8000f91e008ULL,
0x00000005ff057c10ULL, 0x000fca00087e24ffULL, 0x00000010040f7981ULL, 0x000362000c1e1900ULL,
0x000000061500788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000508947ULL, 0x002fea0003800000ULL, 0x0000000507047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e0012ULL, 0x0000000413047c10ULL, 0x000fc8000f91e008ULL,
0x00000005ff057c10ULL, 0x000fca00087e24ffULL, 0x0000001004117981ULL, 0x000362000c1e1900ULL,
0x000000061500788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000308947ULL, 0x002fea0003800000ULL, 0x000000081500788cULL, 0x000fe4000bf06070ULL,
0x0000000607047890ULL, 0x000fc8000fffe03fULL, 0x000000000000781cULL, 0x000fe20003f8f008ULL,
0x00000080040478a5ULL, 0x000fc8000f8e0012ULL, 0x00000007070c0890ULL, 0x000fe4000fffe03fULL,
0x0000000413047c10ULL, 0x000fe4000f91e008ULL, 0x000000800c0c08a5ULL, 0x000fe4000f8e0012ULL,
0x00000005ff057c10ULL, 0x000fc800087e24ffULL, 0x0000000c13064c10ULL, 0x000fe4000fb5e008ULL,
0x0000001004137981ULL, 0x000364000c1e1900ULL, 0x0000000dff074c10ULL, 0x000fca00097e64ffULL,
0x0000001006154981ULL, 0x000368000c1e1900ULL, 0x00000007150b7890ULL, 0x000fc8000fffe03fULL,
0x000000033f0b7899ULL, 0x000fcc000801160bULL, 0x0000000bff007c0cULL, 0x000fda000bf05270ULL,
0x0000000800688947ULL, 0x000fea0003800000ULL, 0x000000ffff077224ULL, 0x02afe200078e0002ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x00000007000c7c82ULL, 0x000fe20008000000ULL,
0x0000003f00057c82ULL, 0x000fe20008000000ULL, 0x00009600001c7ab9ULL, 0x000fca0000000a00ULL,
0x000000150400728cULL, 0x000fe4000bf06070ULL, 0x0000000105057890ULL, 0x000fc8000fffe03fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000b0500728cULL, 0x000fd8000bf06070ULL,
0x0000000800300947ULL, 0x022fea0003800000ULL, 0x00000008040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000702027209ULL, 0x000fe20007810000ULL, 0x00000001040e7890ULL, 0x000fe4000fffe03fULL,
0x000000150d00728cULL, 0x000fe4000bf26070ULL, 0x000000150e00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x000000080c0e7890ULL, 0x000fe2000fffe03fULL,
0x0000001000047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011600ULL,
0x000000800e0e78a5ULL, 0x000fe4000f8e001cULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000e05047c10ULL, 0x000fc8000f91e004ULL,
0x0000000fff057c10ULL, 0x000fca00087e24ffULL, 0x0000001004077981ULL, 0x000368000c1e1900ULL,
0x0000000400e82947ULL, 0x000fea0003800000ULL, 0x00000009040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000902027209ULL, 0x000fe20007810000ULL, 0x00000002040e7890ULL, 0x000fe4000fffe03fULL,
0x000000150d00728cULL, 0x000fe4000bf26070ULL, 0x000000150e00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x000000090c0e7890ULL, 0x000fe2000fffe03fULL,
0x0000001000047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011600ULL,
0x000000800e0e78a5ULL, 0x000fe4000f8e001cULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000e05047c10ULL, 0x000fc8000f91e004ULL,
0x0000000fff057c10ULL, 0x000fca00087e24ffULL, 0x0000001004097981ULL, 0x000368000c1e1900ULL,
0x0000000400a02947ULL, 0x000fea0003800000ULL, 0x0000000a040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000b02027209ULL, 0x000fe20007810000ULL, 0x00000003040e7890ULL, 0x000fe4000fffe03fULL,
0x000000150d00728cULL, 0x000fe4000bf26070ULL, 0x000000150e00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000a0c0e7890ULL, 0x000fe2000fffe03fULL,
0x0000001000047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011600ULL,
0x000000800e0e78a5ULL, 0x000fe4000f8e001cULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000e05047c10ULL, 0x000fc8000f91e004ULL,
0x0000000fff057c10ULL, 0x000fca00087e24ffULL, 0x00000010040b7981ULL, 0x000368000c1e1900ULL,
0x0000000400582947ULL, 0x000fea0003800000ULL, 0x0000000b040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000d02027209ULL, 0x000fe20007810000ULL, 0x00000004040e7890ULL, 0x000fe4000fffe03fULL,
0x000000150d00728cULL, 0x000fe4000bf26070ULL, 0x000000150e00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000b0c0e7890ULL, 0x000fe2000fffe03fULL,
0x0000001000047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011600ULL,
0x000000800e0e78a5ULL, 0x000fe4000f8e001cULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000e05047c10ULL, 0x000fc8000f91e004ULL,
0x0000000fff057c10ULL, 0x000fca00087e24ffULL, 0x00000010040d7981ULL, 0x000368000c1e1900ULL,
0x0000000400102947ULL, 0x000fea0003800000ULL, 0x0000000c040d7890ULL, 0x000fe2000fffe03fULL,
0x0000000f02027209ULL, 0x000fe20007810000ULL, 0x00000005040e7890ULL, 0x000fe4000fffe03fULL,
0x000000150d00728cULL, 0x000fe4000bf26070ULL, 0x000000150e00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000c0c0e7890ULL, 0x000fe2000fffe03fULL,
0x0000001000047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011600ULL,
0x000000800e0e78a5ULL, 0x000fe4000f8e001cULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000e05047c10ULL, 0x000fc8000f91e004ULL,
0x0000000fff057c10ULL, 0x000fca00087e24ffULL, 0x00000010040f7981ULL, 0x000368000c1e1900ULL,
0x0000000000c82947ULL, 0x000fea0003800000ULL, 0x0000000d040d7890ULL, 0x000fe2000fffe03fULL,
0x0000001102027209ULL, 0x000fe20007810000ULL, 0x00000006040e7890ULL, 0x000fe4000fffe03fULL,
0x000000150d00728cULL, 0x000fe4000bf26070ULL, 0x000000150e00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000d0c0e7890ULL, 0x000fe2000fffe03fULL,
0x0000001000047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011600ULL,
0x000000800e0e78a5ULL, 0x000fe4000f8e001cULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000e05047c10ULL, 0x000fc8000f91e004ULL,
0x0000000fff057c10ULL, 0x000fca00087e24ffULL, 0x0000001004117981ULL, 0x000368000c1e1900ULL,
0x0000000000802947ULL, 0x000fea0003800000ULL, 0x0000000e040d7890ULL, 0x000fe2000fffe03fULL,
0x0000001302027209ULL, 0x000fe20007810000ULL, 0x00000007040e7890ULL, 0x000fe4000fffe03fULL,
0x000000150d00728cULL, 0x000fe4000bf26070ULL, 0x000000150e00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000e0c0e7890ULL, 0x000fe2000fffe03fULL,
0x0000001000047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011600ULL,
0x000000800e0e78a5ULL, 0x000fe4000f8e001cULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000e05047c10ULL, 0x000fc8000f91e004ULL,
0x0000000fff057c10ULL, 0x000fca00087e24ffULL, 0x0000001004137981ULL, 0x000368000c1e1900ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x0000000f040d7890ULL, 0x000fe2000fffe03fULL,
0x0000001502027209ULL, 0x000fc60007810000ULL, 0x000000150d00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000f0c0e7890ULL, 0x000fe2000fffe03fULL, 0x0000000400047819ULL, 0x002fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe20000011600ULL, 0x000000800e0e78a5ULL, 0x000fe2000f8e001cULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000000e05047c10ULL, 0x000fc8000f91e004ULL, 0x0000000fff057c10ULL, 0x000fca00087e24ffULL,
0x0000001004157981ULL, 0x000368000c1e1900ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000804047890ULL, 0x000fe4000fffe03fULL, 0x000000080c0c7890ULL, 0x000fd4000fffe03fULL,
0xfffffff400ac8947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000f240000000000ULL,
0x0000001000047824ULL, 0x01afe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011600ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000000a05057c10ULL, 0x000fca000fffe004ULL, 0x0000000205007388ULL, 0x0203e40000000800ULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x00000007060b7290ULL, 0x000fe2000fffe03fULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000023f047899ULL, 0x000fe20008011614ULL,
0x0000001000027824ULL, 0x042fe200078e00ffULL, 0x0000000a060f7291ULL, 0x000fe2000f8e683fULL,
0x00000001ff157819ULL, 0x008fe20000011600ULL, 0x0000000b090e7291ULL, 0x000fe2000f8fa03fULL,
0x0000002000077836ULL, 0x000fe20000000000ULL, 0x00009600000c7ab9ULL, 0x000fe20000000a00ULL,
0x0000000104057892ULL, 0x000fe2000f8ec03fULL, 0x0000007002027812ULL, 0x000fe200078ec0ffULL,
0x0000000f17047291ULL, 0x000fe2000f8e603fULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x000010000e0e78a5ULL, 0x000fe2000f8e000cULL, 0x0000004000097836ULL, 0x040fe20000000000ULL,
0x00000000003f7886ULL, 0x000fe20000020000ULL, 0x00000060000b7836ULL, 0x040fe20000000000ULL,
0x0000001a0e1f7290ULL, 0x000fe2000ff1e03fULL, 0x0000000a15147c10ULL, 0x000fe2000fffe002ULL,
0x00000009141b7899ULL, 0x000fe2000800063fULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000f3f1e7290ULL, 0x000fe200087fe43fULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000008001b1b7892ULL, 0x000fe2000f8ec03fULL, 0x0000001fff047e24ULL, 0x000fe2000f8e00ffULL,
0x0000000b181c9290ULL, 0x000fe2000fffe03fULL, 0x0000000014147984ULL, 0x000e620000000800ULL,
0x0000000a061d9291ULL, 0x000fe2000f8e483fULL, 0x0000001eff057e24ULL, 0x000fe2000f8e00ffULL,
0x000000800b0e98a5ULL, 0x000fe2000f8e000cULL, 0x00000000001c7805ULL, 0x004fe2000001ff00ULL,
0x0000000a060b9291ULL, 0x000fe2000f8e483fULL, 0x0000001007067825ULL, 0x100fe200078e0004ULL,
0x0000001b041b7290ULL, 0x000fe2000fffe03fULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000801c0c98a5ULL, 0x000fe2000f8e000cULL, 0x0000001009087825ULL, 0x100fe200078e0004ULL,
0x0000001d171d9291ULL, 0x000fe2000f8e403fULL, 0x0000000e000e7c02ULL, 0x000fe20008000f00ULL,
0x0000000b170b9291ULL, 0x000fe2000f8e403fULL, 0x000000100b0a7825ULL, 0x100fe200078e0004ULL,
0x0000001d051d9291ULL, 0x000fe2000f8e383fULL, 0x0000001b00117c11ULL, 0x040fe2000f8e20ffULL,
0x0000000b050b9291ULL, 0x000fe2000f8e383fULL, 0x0000001000047825ULL, 0x000fe200078e0004ULL,
0x000000150600728cULL, 0x000fe2000bf06070ULL, 0x0000000000207805ULL, 0x000fc4000001ff00ULL,
0x0000001d00138c11ULL, 0x040fe2000f8e20ffULL, 0x0000000cff0c7e24ULL, 0x000fe2000f8e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000004117faeULL, 0x000fe2000b901c50ULL,
0x0000000dff0d7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000b00178c11ULL, 0x040fe2000f8e20ffULL,
0x0000000fff0f7e24ULL, 0x000fe2000f8e00ffULL, 0x0038000006117faeULL, 0x000fe2000b901c50ULL,
0x00000010000c8825ULL, 0x040fe200078e000cULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0058000008117faeULL, 0x000fe2000b901c50ULL,
0x00000010000e8825ULL, 0x000fe200078e000eULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x007800000a117faeULL, 0x000fe2000b901c50ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x045800000c138faeULL, 0x000fe2000b901c50ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x041800000e178faeULL, 0x0005e2000b901c50ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000000ffff3d7224ULL, 0x000fe400078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000167805ULL, 0x004fd2000001ff00ULL,
0x0000000800b40947ULL, 0x002fea0003800000ULL, 0x00000003ff047819ULL, 0x100fe20000011600ULL,
0x0000000a06057291ULL, 0x000fe2000f8e483fULL, 0xfffffff8ff057812ULL, 0x000fe200078ee200ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x0000000304047812ULL, 0x000fe200078ec0ffULL,
0x0000000517057291ULL, 0x000fe2000f8e403fULL, 0x00000002ff397819ULL, 0x000fe20000011600ULL,
0x0000000805097836ULL, 0x040fe20000000000ULL, 0x0000000404067812ULL, 0x000fe200078efcffULL,
0x0000000805387824ULL, 0x000fe200078e00ffULL, 0x0000000704077812ULL, 0x000fe200078e7805ULL,
0x00000008393c7836ULL, 0x000fe20000000000ULL, 0x0000000706057812ULL, 0x000fe200078e7805ULL,
0x00000005ff377e24ULL, 0x000fe2000f8e00ffULL, 0x00000007043a7812ULL, 0x000fe200078e7809ULL,
0x0000000600057c82ULL, 0x000fe20008000000ULL, 0x0000000706067812ULL, 0x000fe200078e7809ULL,
0x0000000809097824ULL, 0x000fe200078e00ffULL, 0x0000003807367212ULL, 0x080fe200078efcffULL,
0x00009600001e7ab9ULL, 0x000fe20000000a00ULL, 0x0000003805387212ULL, 0x000fc400078efcffULL,
0x000000093a3a7212ULL, 0x080fe400078efcffULL, 0x00000009063b7212ULL, 0x000fce00078efcffULL,
0x00000002050b7890ULL, 0x000fc8000fffe03fULL, 0x000000150b00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000cc0947ULL, 0x000fea0003800000ULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x0000000b071d7290ULL, 0x000fe2000fffe03fULL,
0x00000040000b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000a0b0d7899ULL, 0x000fe2000800063fULL,
0x0000002000097836ULL, 0x040fe20000000000ULL, 0x0000001d090e7291ULL, 0x000fe2000f8fa03fULL,
0x00000060003f7836ULL, 0x000fe20000000000ULL, 0x000000013f0c7899ULL, 0x000fe4000801160bULL,
0x000010000e0e78a5ULL, 0x000fe4000f8e001eULL, 0x000008000d0d7892ULL, 0x000fc4000f8ec03fULL,
0x00000000003f7886ULL, 0x000fe20000020000ULL, 0x000000010c207892ULL, 0x000fe4000f8ec03fULL,
0x0000001a0e237290ULL, 0x000fe4000ff1e03fULL, 0x0000000a06219291ULL, 0x000fe4000f8e483fULL,
0x0000000d041b7290ULL, 0x000fe2000fffe03fULL, 0x00000020ff107e24ULL, 0x000fe2000f8e00ffULL,
0x0000002117219291ULL, 0x000fe2000f8e403fULL, 0x00000023ff047e24ULL, 0x000fe2000f8e00ffULL,
0x0000000a06229291ULL, 0x000fc4000f8e483fULL, 0x0000001d181c9290ULL, 0x000fe2000fffe03fULL,
0x0000001b00117c11ULL, 0x000fe2000f8e20ffULL, 0x000000801d0c98a5ULL, 0x000fe2000f8e001eULL,
0x00000021ff378e24ULL, 0x000fe2000f8e00ffULL, 0x0000000f3f1d7290ULL, 0x000fe400087fe43fULL,
0x0000002217229291ULL, 0x000fe4000f8e403fULL, 0x000000801c0e98a5ULL, 0x000fe2000f8e001eULL,
0x0000003710138211ULL, 0x000fe200078e38ffULL, 0x0000001dff057e24ULL, 0x000fc4000f8e00ffULL,
0x00000022ff378e24ULL, 0x000fe4000f8e00ffULL, 0x0000001000067825ULL, 0x000fc800078e0004ULL,
0x0000001009087825ULL, 0x100fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000006117faeULL, 0x0003e6000b901c50ULL, 0x000000100b0a7825ULL, 0x000fe200078e0004ULL,
0x0038000008117faeULL, 0x0003e6000b901c50ULL, 0x0000000eff0c7e24ULL, 0x000fe2000f8e00ffULL,
0x005800000a117faeULL, 0x0003e2000b901c50ULL, 0x0000000fff0d7e24ULL, 0x000fc4000f8e00ffULL,
0x000000103f047825ULL, 0x000fc800078e0004ULL, 0x0000000cff0e7e24ULL, 0x000fe2000f8e00ffULL,
0x0078000004117faeULL, 0x0003e2000b901c50ULL, 0x0000000dff0f7e24ULL, 0x000fe4000f8e00ffULL,
0x00000080103f8824ULL, 0x000fe400078e0237ULL, 0x00000010000c8825ULL, 0x000fc800078e000cULL,
0x0000001000138824ULL, 0x040fe400078e0213ULL, 0x00000010000e8825ULL, 0x000fc600078e000eULL,
0x045800000c138faeULL, 0x0003e2000b901c50ULL, 0x00000010003f8824ULL, 0x000fca00078e023fULL,
0x041800000e3f8faeULL, 0x0003e4000b901c50ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000005000c7c82ULL, 0x000fe40008000000ULL, 0x000000060c057899ULL, 0x000fc8000800063fULL,
0x0000008005057892ULL, 0x000fcc000f8ec03fULL, 0x0000000502047c10ULL, 0x002fe2000fffe037ULL,
0x0000000a0c057899ULL, 0x000fc8000800063fULL, 0x00000001153e7824ULL, 0x000fe200078e0204ULL,
0x0000080005057892ULL, 0x000fc8000f8ec03fULL, 0x0000018004057890ULL, 0x000fe2000fffe005ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180003e0d7984ULL, 0x000e620000000800ULL,
0x0000000536047c11ULL, 0x000fe4000f8e20ffULL, 0x0000000538087c11ULL, 0x000fe2000f8e20ffULL,
0x004580003e3f7984ULL, 0x000fe20000000800ULL, 0x000000053a0c7c11ULL, 0x000fe4000f8e20ffULL,
0x000000053b107c11ULL, 0x000fe2000f8e20ffULL, 0x000000000404783bULL, 0x000ea20000000200ULL,
0x0000000b00057c82ULL, 0x000fe40008000000ULL, 0x000000150500728cULL, 0x000fe2000bf06070ULL,
0x000000000808783bULL, 0x000eea0000000200ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000d14117221ULL, 0x002fc40000010100ULL, 0x000000000c0c783bULL, 0x000e640000000200ULL,
0x3fb8aa3b11427820ULL, 0x000fe40000410000ULL, 0x000000001010783bULL, 0x000f220000000200ULL,
0x20000004ff3e7230ULL, 0x004fc60000004100ULL, 0x0000004200427308ULL, 0x000ea20000000800ULL,
0x20000006ff407230ULL, 0x000fe40000004100ULL, 0x30000006ff417230ULL, 0x000fe40000004100ULL,
0x30000008ff437230ULL, 0x008fe40000004100ULL, 0x2000000aff447230ULL, 0x000fe40000004100ULL,
0x3000000aff457230ULL, 0x000fe40000004100ULL, 0x20000007ff067230ULL, 0x000fc40000004100ULL,
0x2000000bff0a7230ULL, 0x000fe40000004100ULL, 0x0000003f424e7220ULL, 0x004fe20000410000ULL,
0x30000004ff3f7230ULL, 0x000fe40000004100ULL, 0x20000008ff427230ULL, 0x000fe40000004100ULL,
0x0000003d4e3d7221ULL, 0x000fe20000010000ULL, 0x00001f394e4f7589ULL, 0x000ea200000e0000ULL,
0x20000005ff047230ULL, 0x000fe40000004100ULL, 0x20000009ff087230ULL, 0x000fe20000004100ULL,
0x00001f3c4e507589ULL, 0x000ee200000e0000ULL, 0x30000005ff057230ULL, 0x000fc40000004100ULL,
0x30000007ff077230ULL, 0x000fe40000004100ULL, 0x30000009ff097230ULL, 0x000fe40000004100ULL,
0x3000000bff0b7230ULL, 0x000fe40000004100ULL, 0x2000000cff467230ULL, 0x002fe40000004100ULL,
0x3000000cff477230ULL, 0x000fe40000004100ULL, 0x2000000eff487230ULL, 0x000fc40000004100ULL,
0x3000000eff497230ULL, 0x000fe40000004100ULL, 0x20000010ff4a7230ULL, 0x010fe40000004100ULL,
0x30000010ff4b7230ULL, 0x000fe40000004100ULL, 0x0000004f3e357223ULL, 0x084fe20000010035ULL,
0x20000012ff4c7230ULL, 0x000fe40000004100ULL, 0x0000004f3f347223ULL, 0x000fe20000010034ULL,
0x30000012ff4d7230ULL, 0x000fc40000004100ULL, 0x0000004f04337223ULL, 0x080fe20000010033ULL,
0x2000000dff0c7230ULL, 0x000fe40000004100ULL, 0x0000004f05307223ULL, 0x080fe20000010030ULL,
0x2000000fff0e7230ULL, 0x000fe40000004100ULL, 0x0000004f402f7223ULL, 0x080fe2000001002fULL,
0x20000011ff107230ULL, 0x000fe40000004100ULL, 0x0000004f412c7223ULL, 0x000fe2000001002cULL,
0x20000013ff127230ULL, 0x000fc40000004100ULL, 0x0000004f062b7223ULL, 0x080fe2000001002bULL,
0x3000000dff0d7230ULL, 0x000fe40000004100ULL, 0x0000004f07287223ULL, 0x080fe20000010028ULL,
0x3000000fff0f7230ULL, 0x000fe40000004100ULL, 0x0000004f42277223ULL, 0x080fe20000010027ULL,
0x30000011ff117230ULL, 0x000fe40000004100ULL, 0x0000004f43247223ULL, 0x000fe20000010024ULL,
0x30000013ff137230ULL, 0x000fc40000004100ULL, 0x0000004f08237223ULL, 0x080fe20000010023ULL,
0x0000004f09207223ULL, 0x080fe20000010020ULL, 0x0000004f441f7223ULL, 0x080fe2000001001fULL,
0x0000004f451c7223ULL, 0x080fe2000001001cULL, 0x0000004f0a1b7223ULL, 0x080fe2000001001bULL,
0x0000004f0b187223ULL, 0x000fe20000010018ULL, 0x0000005046177223ULL, 0x088fe20000010017ULL,
0x0000005047327223ULL, 0x080fe20000010032ULL, 0x000000500c317223ULL, 0x080fe20000010031ULL,
0x000000500d2e7223ULL, 0x080fe2000001002eULL, 0x00000050482d7223ULL, 0x080fe2000001002dULL,
0x00000050492a7223ULL, 0x080fe2000001002aULL, 0x000000500e297223ULL, 0x080fe20000010029ULL,
0x000000500f267223ULL, 0x080fe20000010026ULL, 0x000000504a257223ULL, 0x080fe20000010025ULL,
0x000000504b227223ULL, 0x080fe20000010022ULL, 0x0000005010217223ULL, 0x080fe20000010021ULL,
0x00000050111e7223ULL, 0x080fe2000001001eULL, 0x000000504c1d7223ULL, 0x080fe2000001001dULL,
0x000000504d1a7223ULL, 0x080fe2000001001aULL, 0x0000005012197223ULL, 0x080fe20000010019ULL,
0x0000005013167223ULL, 0x000fe20000010016ULL, 0xfffffff400a88947ULL, 0x000fec000383ffffULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x00000017ff007c0cULL, 0x000fe2000bf05270ULL,
0x000049800a047890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff047819ULL, 0x000fc80000011600ULL, 0x0000007002007812ULL, 0x000fe400078ec0ffULL,
0x0000000c04057812ULL, 0x000fc800078ec0ffULL, 0x0000000405007c10ULL, 0x000fe2000fffe000ULL,
0x0000000000200947ULL, 0x000fec0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0000000a060a7291ULL, 0x000fe2000f8e383fULL, 0x0000001002047824ULL, 0x002fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011602ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c02057812ULL, 0x000fc800078ec0ffULL, 0x0000000a05047c10ULL, 0x000fca000fffe004ULL,
0x0049803d04007388ULL, 0x0003e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000027984ULL, 0x000ea80000000800ULL, 0x0000800000057984ULL, 0x000ee20000000800ULL,
0x00000002ff027221ULL, 0x004fc80000010000ULL, 0x0000000502027221ULL, 0x008fc80000010000ULL,
0x0180000002047836ULL, 0x002fca0000000000ULL, 0x7f80000004047812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0400780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff4d7224ULL, 0x000fe200078e0002ULL,
0x00008b6000047802ULL, 0x000fce0000000f00ULL, 0x0000006c00c47944ULL, 0x000fea0003c00000ULL,
0x0000000000047202ULL, 0x00cfe20000000f00ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000200057308ULL, 0x000e640000001000ULL, 0xbf80000002007423ULL, 0x002fc80000000005ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000005047223ULL, 0x000fce0000000005ULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x00000002ff097819ULL, 0x104fe40000011600ULL,
0x00000008000b7811ULL, 0x000fe400078ff0ffULL, 0x00000003ff0d7819ULL, 0x000fe20000011600ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0904027589ULL, 0x000ea200000e0000ULL,
0xfffffff8ff157812ULL, 0x000fc600078ee200ULL, 0x00001f0b040c7589ULL, 0x00072400000e0000ULL,
0x00000008150e7824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000030d047812ULL, 0x008fc800078ec0ffULL, 0x0000000404147812ULL, 0x000fe200078efcffULL,
0x0000001f020a7220ULL, 0x044fe20000410000ULL, 0x00000008151f7836ULL, 0x000fe40000000000ULL,
0x0000002702087220ULL, 0x040fe20000410000ULL, 0x0000003502357220ULL, 0x000fe20000410000ULL,
0x000000170c107220ULL, 0x010fe20000410000ULL, 0x0000000704177812ULL, 0x000fe200078e7815ULL,
0x0000003402347220ULL, 0x040fe20000410000ULL, 0x0000000704277812ULL, 0x000fe200078e781fULL,
0x0000003302057220ULL, 0x040fe20000410000ULL, 0x0000003002307220ULL, 0x040fe20000410000ULL,
0x0000002f02067220ULL, 0x040fe20000410000ULL, 0x0000002c02077220ULL, 0x040fe20000410000ULL,
0x0000002b022b7220ULL, 0x040fe20000410000ULL, 0x0000002802287220ULL, 0x040fe20000410000ULL,
0x0000002402097220ULL, 0x040fe20000410000ULL, 0x0000002302237220ULL, 0x040fe20000410000ULL,
0x0000002002207220ULL, 0x040fe20000410000ULL, 0x0000001c020b7220ULL, 0x040fe20000410000ULL,
0x0000001b021b7220ULL, 0x000fe20000410000ULL, 0x0000000714157812ULL, 0x000fe200078e7815ULL,
0x000000081f047824ULL, 0x000fc400078e00ffULL, 0x0000001802027220ULL, 0x000fe20000410000ULL,
0x000000320c0f7220ULL, 0x040fe20000410000ULL, 0x000000310c117220ULL, 0x040fe20000410000ULL,
0x0000002e0c2e7220ULL, 0x040fe20000410000ULL, 0x0000002d0c127220ULL, 0x040fe20000410000ULL,
0x0000002a0c137220ULL, 0x040fe20000410000ULL, 0x000000290c297220ULL, 0x040fe20000410000ULL,
0x000000260c267220ULL, 0x040fe20000410000ULL, 0x000000250c257220ULL, 0x040fe20000410000ULL,
0x000000220c227220ULL, 0x040fe20000410000ULL, 0x000000210c217220ULL, 0x040fe20000410000ULL,
0x0000001e0c1e7220ULL, 0x040fe20000410000ULL, 0x0000001d0c1d7220ULL, 0x040fe20000410000ULL,
0x0000001a0c1a7220ULL, 0x040fe20000410000ULL, 0x000000190c197220ULL, 0x040fe20000410000ULL,
0x00000007141f7812ULL, 0x000fe200078e781fULL, 0x000000160c0c7220ULL, 0x000fe20000410000ULL,
0x0000000e17177212ULL, 0x000fc400078efcffULL, 0x0000000e15157212ULL, 0x000fe400078efcffULL,
0x0000000427277212ULL, 0x000fe400078efcffULL, 0x0000000a0b0a723eULL, 0x000fe400000000ffULL,
0x000000041f1f7212ULL, 0x000fe400078efcffULL, 0x000000060706723eULL, 0x000fe400000000ffULL,
0x000000080908723eULL, 0x000fc400000000ffULL, 0x0000001b020b723eULL, 0x000fe400000000ffULL,
0x000000100f10723eULL, 0x000fe200000000ffULL, 0x00000020030f7824ULL, 0x000fe200078e0200ULL,
0x000000353404723eULL, 0x000fe400000000ffULL, 0x000000053005723eULL, 0x000fe400000000ffULL,
0x0000002b2807723eULL, 0x000fe400000000ffULL, 0x000000232009723eULL, 0x000fc400000000ffULL,
0x0000001917027c11ULL, 0x000fe4000f8e20ffULL, 0x000000121312723eULL, 0x000fe400000000ffULL,
0x000000190c23723eULL, 0x000fe200000000ffULL, 0x0000000402007844ULL, 0x000fe20000000200ULL,
0x0000001915037c11ULL, 0x000fe4000f8e20ffULL, 0x000000112e11723eULL, 0x000fe400000000ffULL,
0x000000292613723eULL, 0x000fe200000000ffULL, 0x0000000803007844ULL, 0x000fe20000000200ULL,
0x000000252220723eULL, 0x000fc400000000ffULL, 0x00000019270c7c11ULL, 0x000fe4000f8e20ffULL,
0x000000211e21723eULL, 0x000fe400000000ffULL, 0x0000001d1a22723eULL, 0x000fe200000000ffULL,
0x000000100c007844ULL, 0x000fe20000000200ULL, 0x000000191f0e7c11ULL, 0x000fe4000f8e20ffULL,
0x000000080f0f7c11ULL, 0x000fc6000f8e20ffULL, 0x000000200e007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000000f147984ULL, 0x000ea80000000c00ULL,
0x000400000f1c7984ULL, 0x000ee80000000c00ULL, 0x000800000f187984ULL, 0x000f280000000c00ULL,
0x000c00000f247984ULL, 0x000f620000000c00ULL, 0x200000ff17177230ULL, 0x004fc40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fe40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x008fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fc40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x010fe40000000000ULL,
0x0000001a16167230ULL, 0x000fe40000000000ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fe40000000000ULL, 0x000000271f1f7230ULL, 0x020fc40000000000ULL,
0x000000261e1e7230ULL, 0x000fe20000000000ULL, 0x000000140f007388ULL, 0x0005e20000000c00ULL,
0x000000251d1d7230ULL, 0x000fe40000000000ULL, 0x000000241c1c7230ULL, 0x000fca0000000000ULL,
0x0004001c0f007388ULL, 0x0005e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000006ff007c0cULL, 0x000fda000bf05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x00ce620000002600ULL, 0x00000017ff187e24ULL, 0x000fe2000f8e00ffULL,
0x00000000000479c3ULL, 0x000ea20000002700ULL, 0x00000020001b7836ULL, 0x000fe20000000000ULL,
0x00000060001f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000818217824ULL, 0x000fe200078e00ffULL,
0x0000840000057ab9ULL, 0x000fe20000000800ULL, 0x00000040001d7836ULL, 0x000fe20000000000ULL,
0x00000003ff157819ULL, 0x000fe2000001161fULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0xfffffff821217812ULL, 0x000fe200078ee200ULL, 0x0000000818167824ULL, 0x040fe200078e00ffULL,
0x00000003ff147819ULL, 0x000fe2000001161dULL, 0x0000860000067ab9ULL, 0x000fe20000000a00ULL,
0x0000000715067812ULL, 0x000fe200078e481fULL, 0x00000008181a7824ULL, 0x040fe200078e00ffULL,
0x0000000714047812ULL, 0x000fe200078e481dULL, 0x00000008181e7824ULL, 0x000fe200078e00ffULL,
0x0ffffff806067812ULL, 0x000fc400078ef81fULL, 0x0ffffff804057812ULL, 0x000fe400078ef81dULL,
0x0000000806107c11ULL, 0x000fe4000f8e20ffULL, 0x00000008050c7c11ULL, 0x000fe2000f8e20ffULL,
0x00000004050472a4ULL, 0x004fe2000f8e023fULL, 0xfffffff81a1d7812ULL, 0x000fe400078ee21dULL,
0x0000000010107984ULL, 0x000fe20000000c00ULL, 0xfffffff81e1f7812ULL, 0x000fe200078ee21fULL,
0x0000001017027824ULL, 0x002fc400078e00ffULL, 0x0000001017197824ULL, 0x040fe400078e00ffULL,
0x00000010171c7824ULL, 0x000fe200078e00ffULL, 0xfffffff002027812ULL, 0x000fe400078ee20dULL,
0x000000070d0d7812ULL, 0x000fe400078e4800ULL, 0xfffffff019147812ULL, 0x000fe400078ee214ULL,
0x0ffffff80d0d7812ULL, 0x000fe400078ef800ULL, 0x00000003ff007819ULL, 0x000fc4000001161bULL,
0x000000080d047c11ULL, 0x000fe4000f8e20ffULL, 0x0000000700037812ULL, 0x000fe200078e481bULL,
0x000000000c0c7984ULL, 0x000fe20000000c00ULL, 0xfffffff019007812ULL, 0x000fe400078ee200ULL,
0x0ffffff803037812ULL, 0x000fe200078ef81bULL, 0x0000000004047984ULL, 0x000e620000000c00ULL,
0xfffffff8161b7812ULL, 0x000fe400078ee21bULL, 0x0000000803037c11ULL, 0x000fc4000f8e20ffULL,
0x0000000402167c10ULL, 0x000fe4000ff1e0ffULL, 0xfffffff01c157812ULL, 0x000fe200078ee215ULL,
0x0000000003087984ULL, 0x0004e40000000c00ULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0x0000000616027c11ULL, 0x000fc8000f8040ffULL, 0x0000000716037c11ULL, 0x004fe400080f4417ULL,
0x00000004001c7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000414177c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001021027825ULL, 0x000fe200078e0002ULL, 0x0000000415007c10ULL, 0x000fc6000ff5e0ffULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x000000061c147c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x0000000617167c11ULL, 0x040fe2000f8240ffULL,
0x000000ffff197224ULL, 0x000fe200010e06ffULL, 0x0000000600187c11ULL, 0x000fe4000f8440ffULL,
0x000000071c157c11ULL, 0x000fe400080f4415ULL, 0x0000000717177c11ULL, 0x000fe400088f441aULL,
0x0000000700197c11ULL, 0x000fe200090f4419ULL, 0x000000101b147825ULL, 0x000fe200078e0014ULL,
0x0000000402007986ULL, 0x002fe6000c101d10ULL, 0x000000101d167825ULL, 0x000fc800078e0016ULL,
0x000000101f187825ULL, 0x000fe200078e0018ULL, 0x0000000814007986ULL, 0x008fe8000c101d10ULL,
0x0000000c16007986ULL, 0x000fe8000c101d10ULL, 0x0000001018007986ULL, 0x000fe2000c101d10ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000000640772caULL, 0x000fe200000e0000ULL,
0x0000000106047899ULL, 0x000fe2000800063fULL, 0x0000000164007810ULL, 0x000fe20007ffe0ffULL,
0x00000006140d7899ULL, 0x000fe4000800063fULL, 0x0000000a040472a4ULL, 0x000fe2000f8e0209ULL,
0x0000000500007c0cULL, 0x000fe2000bf06070ULL, 0x00008e0000087ab9ULL, 0x000fcc0000000800ULL,
0x0000000d07077291ULL, 0x000fc8000f8e403fULL, 0x00000008040872a4ULL, 0x000fe4000f8e0207ULL,
0x0000000c00008947ULL, 0x000ff40003800000ULL, 0x0000000000777919ULL, 0x000e620000000000ULL,
0x00008a00ff027b82ULL, 0x000ea20000000a00ULL, 0x000000070f00728cULL, 0x000fc8000bf01070ULL,
0x000000070f067287ULL, 0x000fc6000c000000ULL, 0x00000000000979c3ULL, 0x000ee20000008800ULL,
0x0000000607067290ULL, 0x000fc6000fffe13fULL, 0x0000040000077882ULL, 0x000fe20000000000ULL,
0x00000003ff107819ULL, 0x002fe20000011677ULL, 0x00000654090b7896ULL, 0x008fe20008000007ULL,
0x0ffffff877057812ULL, 0x040fe400078ec0ffULL, 0x0000007710007212ULL, 0x0c0fe200078e3cffULL,
0x0000000410067836ULL, 0x040fe20000000000ULL, 0x0000000b14077291ULL, 0x000fe2000f8e703fULL,
0x0000000810087836ULL, 0x000fe20000000000ULL, 0x0000000705117812ULL, 0x000fe200078ef800ULL,
0x0000001077007824ULL, 0x000fe200078e00ffULL, 0x0000007706077212ULL, 0x080fe200078e3cffULL,
0x0000000810057c36ULL, 0x000fe20008000000ULL, 0x0000007708097212ULL, 0x000fe200078e3cffULL,
0x00000008060c7824ULL, 0x000fe200078e00ffULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x0000010005047825ULL, 0x004fe200078e0002ULL, 0x0000000606007c0cULL, 0x000fe2000bf46070ULL,
0x0000100007077890ULL, 0x000fe2000fffe03fULL, 0xfffffff80c1b7812ULL, 0x000fe200078ee207ULL,
0x00000008081a7824ULL, 0x000fe200078e00ffULL, 0x0000000400127210ULL, 0x000fe20007f1e0ffULL,
0x0000000c100a7836ULL, 0x000fc40000000000ULL, 0x0000000806077c36ULL, 0x000fe20008000000ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee209ULL, 0x000000080a1c7824ULL, 0x040fe200078e00ffULL,
0x000000770a0b7212ULL, 0x000fe200078e3cffULL, 0x0000000808097c36ULL, 0x040fe20008000000ULL,
0x00000005ff137210ULL, 0x000fe200007fe4ffULL, 0x0000010007047825ULL, 0x100fe200078e0002ULL,
0xfffffff81c1c7812ULL, 0x000fe400078ee20bULL, 0x0000000608007c0cULL, 0x000fe2000bf06070ULL,
0x0000010009067825ULL, 0x000fe200078e0002ULL, 0x0000000400147210ULL, 0x000fc40007f7e0ffULL,
0x0000000711117c11ULL, 0x000fe2000f8e20ffULL, 0x000000080a0b7c36ULL, 0x000fe20008000000ULL,
0x0000000600167210ULL, 0x000fe20007f9e0ffULL, 0x00000010101e7836ULL, 0x000fe20000000000ULL,
0x000000060a007c0cULL, 0x000fe2000bf26070ULL, 0x0000001410207836ULL, 0x000fe20000000000ULL,
0x000000071b1b7c11ULL, 0x000fe2000f8e20ffULL, 0x000001000b087825ULL, 0x000fe200078e0002ULL,
0x000000771e1d7212ULL, 0x000fc600078e3cffULL, 0x000000081e0d7c36ULL, 0x000fe40008000000ULL,
0x00000008200b7c36ULL, 0x000fe40008000000ULL, 0x000000ffff157224ULL, 0x000fe200018e0605ULL,
0x0000000800187210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe400020e0607ULL,
0x000001000d047825ULL, 0x000fc800078e0002ULL, 0x000001000b067825ULL, 0x000fe200078e0002ULL,
0x00000004000c7210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff197224ULL, 0x000fe200018e0609ULL,
0x00000006000e7210ULL, 0x000fe20007f7e0ffULL, 0x0000001810227836ULL, 0x040fe20000000000ULL,
0x00000005ff0d7210ULL, 0x000fe200027fe4ffULL, 0x0000001c10247836ULL, 0x000fe20000000000ULL,
0x000000061e007c0cULL, 0x000fe2000bf86070ULL, 0x0000000822057c36ULL, 0x040fe20008000000ULL,
0x00000077221f7212ULL, 0x000fe200078e3cffULL, 0x000000ffff0f7224ULL, 0x000fe200018e0607ULL,
0x0000000610007c0cULL, 0x040fe2000bf66070ULL, 0x0000002010267836ULL, 0x000fc40000000000ULL,
0x0000010005047825ULL, 0x000fc800078e0002ULL, 0x0000000824097c36ULL, 0x000fe20008000000ULL,
0x0000000400067210ULL, 0x000fe20007fbe0ffULL, 0x00000008260b7c36ULL, 0x000fe40008000000ULL,
0x0000010009087825ULL, 0x100fe400078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012117faeULL, 0x0003e2000d901c50ULL, 0x0000000622007c0cULL, 0x000fe2000bf66070ULL,
0x000001000b0a7825ULL, 0x000fe400078e0002ULL, 0x00000000141b7faeULL, 0x0005e2000d101c50ULL,
0x0000000624007c0cULL, 0x000fe2000bf46070ULL, 0x000000081e1e7824ULL, 0x000fe200078e00ffULL,
0x0000000a00047210ULL, 0x000fe20007fde0ffULL, 0x000000ffff077224ULL, 0x000fe200028e0605ULL,
0x0000000800087210ULL, 0x000fe20007fbe0ffULL, 0x0000000822227824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1d7812ULL, 0x000fe200078ee21dULL, 0x0000002410287836ULL, 0x000fe20000000000ULL,
0x00000009ff097210ULL, 0x000fe20002ffe4ffULL, 0x0000000820217824ULL, 0x040fe200078e00ffULL,
0x0000000620007c0cULL, 0x040fe2000bfa6070ULL, 0x000000ffff057224ULL, 0x000fe200030e060bULL,
0x00000077201e7212ULL, 0x080fe200078e3cffULL, 0x0000000824207824ULL, 0x000fe200078e00ffULL,
0xfffffff8221f7812ULL, 0x000fe200078ee21fULL, 0x00000008280b7c36ULL, 0x000fe20008000000ULL,
0x0000007724117212ULL, 0x002fe200078e3cffULL, 0x0000002810227836ULL, 0x000fe20000000000ULL,
0x000000071c1b7c11ULL, 0x004fe2000f8e20ffULL, 0x000001000b0a7825ULL, 0x000fe200078e0002ULL,
0xfffffff820207812ULL, 0x000fc400078ee211ULL, 0x000000071a117c11ULL, 0x000fe2000f8e20ffULL,
0x0000002c10247836ULL, 0x000fe20000000000ULL, 0x0000000822137c10ULL, 0x000fe4000fffe0ffULL,
0x0000000a000a7210ULL, 0x000fe20007fde0ffULL, 0x0000000016117faeULL, 0x0003e2000c101c50ULL,
0xfffffff8211e7812ULL, 0x000fe200078ee21eULL, 0x0000010013127825ULL, 0x000fe200078e0002ULL,
0x00000077281c7212ULL, 0x080fe200078e3cffULL, 0x00000000181b7faeULL, 0x0005e2000c901c50ULL,
0x0000000626007c0cULL, 0x000fe2000bf06070ULL, 0x0000000824157c36ULL, 0x000fe20008000000ULL,
0x00000077261a7212ULL, 0x040fe200078e3cffULL, 0x0000000826217824ULL, 0x000fe200078e00ffULL,
0x0000000628007c0cULL, 0x040fe2000bf26070ULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x0000001200127210ULL, 0x000fe20007fde0ffULL, 0x0000000828117824ULL, 0x002fe200078e00ffULL,
0xfffffff8211a7812ULL, 0x000fe200078ee21aULL, 0x0000003010267836ULL, 0x000fc40000000000ULL,
0x0000010015147825ULL, 0x000fe200078e0002ULL, 0xfffffff8111c7812ULL, 0x000fe400078ee21cULL,
0x000000071d117c11ULL, 0x000fe2000f8e20ffULL, 0x0000000826177c36ULL, 0x000fe20008000000ULL,
0x000000071e197c11ULL, 0x004fe2000f8e20ffULL, 0x00000034101e7836ULL, 0x000fe20000000000ULL,
0x0000007722187212ULL, 0x040fe200078e3cffULL, 0x000000ffff137224ULL, 0x000fe200030e0613ULL,
0x0000001400147210ULL, 0x000fe20007fde0ffULL, 0x000000000c117faeULL, 0x0003e2000e101c50ULL,
0x0000010017167825ULL, 0x000fe200078e0002ULL, 0x0000000622007c0cULL, 0x000fc4000bf86070ULL,
0x000000000e197faeULL, 0x0005e2000e901c50ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x0000001600167210ULL, 0x000fe20007fde0ffULL, 0x00000008221d7824ULL, 0x000fe200078e00ffULL,
0x0000000624007c0cULL, 0x000fe2000bfa6070ULL, 0x0000003c10227836ULL, 0x000fe20000000000ULL,
0x00000017ff177210ULL, 0x000fe200037fe4ffULL, 0x000000081e0d7c36ULL, 0x002fe20008000000ULL,
0x000000071f117c11ULL, 0x000fe4000f8e20ffULL, 0x00000077241b7212ULL, 0x080fe200078e3cffULL,
0x000001000d0c7825ULL, 0x100fe200078e0002ULL, 0x00000007200f7c11ULL, 0x004fe2000f8e20ffULL,
0x0000000006117faeULL, 0x0003e2000d901c50ULL, 0xfffffff81d187812ULL, 0x000fe200078ee218ULL,
0x0000003810207836ULL, 0x000fe20000000000ULL, 0x000000771e107212ULL, 0x080fe200078e3cffULL,
0x00000000080f7faeULL, 0x0005e2000d101c50ULL, 0x0000000824247824ULL, 0x000fe200078e00ffULL,
0x0000000626007c0cULL, 0x000fe2000bf66070ULL, 0x0000000820197c36ULL, 0x000fe20008000000ULL,
0x00000077260e7212ULL, 0x0c0fe200078e3cffULL, 0x00000008261d7824ULL, 0x000fe200078e00ffULL,
0x000000061e007c0cULL, 0x000fe2000bf46070ULL, 0x0000010019067825ULL, 0x002fe200078e0002ULL,
0x0000007722197212ULL, 0x000fc400078e3cffULL, 0xfffffff8241b7812ULL, 0x000fe200078ee21bULL,
0x000000081e097824ULL, 0x004fe200078e00ffULL, 0x0000000c00087210ULL, 0x000fe20007fde0ffULL,
0x00000008220f7c36ULL, 0x000fe20008000000ULL, 0x00000077200c7212ULL, 0x040fe200078e3cffULL,
0x0000000820117824ULL, 0x000fe200078e00ffULL, 0xfffffff809107812ULL, 0x000fe200078ee210ULL,
0x000000ffff097224ULL, 0x000fe200030e060dULL, 0x000000071a0d7c11ULL, 0x000fe2000f8e20ffULL,
0x000001000f027825ULL, 0x000fe200078e0002ULL, 0x000000071c0f7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000600067210ULL, 0x000fe20007fde0ffULL, 0x00000000040d7faeULL, 0x0003e2000c101c50ULL,
0x0000000620007c0cULL, 0x000fe4000bf06070ULL, 0xfffffff81d0e7812ULL, 0x000fe200078ee20eULL,
0x000000000a0f7faeULL, 0x0005e2000c901c50ULL, 0x0000000622007c0cULL, 0x040fe2000bf26070ULL,
0x0000000822227824ULL, 0x000fe200078e00ffULL, 0x00000007ff077210ULL, 0x000fe400037fe4ffULL,
0xfffffff8110c7812ULL, 0x000fc400078ee20cULL, 0x0000000200027210ULL, 0x000fe40007fde0ffULL,
0x0000000718117c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff822197812ULL, 0x000fe200078ee219ULL,
0x000000ffff037224ULL, 0x000fe200030e0603ULL, 0x000000071b057c11ULL, 0x002fe2000f8e20ffULL,
0x0000000012117faeULL, 0x0003e2000e101c50ULL, 0x000000070e0b7c11ULL, 0x004fe4000f8e20ffULL,
0x00000007100d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000014057faeULL, 0x0003e2000e901c50ULL,
0x000000070c0f7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000719197c11ULL, 0x000fe2000f8e20ffULL,
0x00000000160b7faeULL, 0x0003e8000d901c50ULL, 0x00000000080d7faeULL, 0x0003e8000d101c50ULL,
0x00000000060f7faeULL, 0x0003e8000c101c50ULL, 0x0000000002197faeULL, 0x0003e2000c901c50ULL,
0x0000000800b07947ULL, 0x000fea0003800000ULL, 0x0000000000777919ULL, 0x000e620000000000ULL,
0x00000000000679c3ULL, 0x000ea20000008800ULL, 0x00000400000b7882ULL, 0x000fe40000000000ULL,
0x00000654060b7896ULL, 0x004fc8000800000bULL, 0x0000000b14067291ULL, 0x000fe2000f8e703fULL,
0x00000003ff027819ULL, 0x002fc60000011677ULL, 0x0000100006067890ULL, 0x000fe2000fffe03fULL,
0x0ffffff877037812ULL, 0x040fe400078ec0ffULL, 0x0000007702147212ULL, 0x0c0fe200078e3cffULL,
0x0000000c021a7836ULL, 0x040fe20000000000ULL, 0x0000002402267810ULL, 0x000fe20007ffe0ffULL,
0x00000010021c7836ULL, 0x040fe20000000000ULL, 0x0000000703147812ULL, 0x000fe200078ef814ULL,
0x0000001c02227836ULL, 0x000fe20000000000ULL, 0x000000771a117212ULL, 0x080fe200078e3cffULL,
0x000000081c057824ULL, 0x000fe200078e00ffULL, 0x000000031a047819ULL, 0x000fe200000006ffULL,
0x0000002002247836ULL, 0x000fe20000000000ULL, 0x000000771c107212ULL, 0x080fe200078e3cffULL,
0x0000000802187836ULL, 0x040fe20000000000ULL, 0xfffffff804117812ULL, 0x000fe200078ee211ULL,
0x0000000402167836ULL, 0x000fe20000000000ULL, 0xfffffff805107812ULL, 0x000fe200078ee210ULL,
0x0000000822047824ULL, 0x040fe200078e00ffULL, 0x00000077220d7212ULL, 0x080fe200078e3cffULL,
0x0000000824057824ULL, 0x040fe200078e00ffULL, 0x00000077240c7212ULL, 0x080fe200078e3cffULL,
0x0000000818037824ULL, 0x040fe200078e00ffULL, 0x0000007718127212ULL, 0x080fe200078e3cffULL,
0x0000002c022a7836ULL, 0x000fe20000000000ULL, 0x0000007716137212ULL, 0x080fe200078e3cffULL,
0x00000030022c7836ULL, 0x000fe20000000000ULL, 0xfffffff8040d7812ULL, 0x000fe200078ee20dULL,
0x0000000816007824ULL, 0x000fe200078e00ffULL, 0xfffffff8050c7812ULL, 0x000fe200078ee20cULL,
0x0000001802207836ULL, 0x040fe20000000000ULL, 0xfffffff803127812ULL, 0x000fe200078ee212ULL,
0x00000014021e7836ULL, 0x000fe20000000000ULL, 0x000000772a097212ULL, 0x0c0fe200078e3cffULL,
0x000000082a047824ULL, 0x000fe200078e00ffULL, 0x000000772c087212ULL, 0x0c0fe200078e3cffULL,
0x000000082c057824ULL, 0x000fe200078e00ffULL, 0xfffffff800137812ULL, 0x000fe200078ee213ULL,
0x0000000820037824ULL, 0x040fe200078e00ffULL, 0x00000077200e7212ULL, 0x080fe200078e3cffULL,
0x000000081e007824ULL, 0x040fe200078e00ffULL, 0x000000771e0f7212ULL, 0x080fe200078e3cffULL,
0x0000002802287836ULL, 0x040fe20000000000ULL, 0xfffffff804097812ULL, 0x000fe200078ee209ULL,
0x00000034022e7836ULL, 0x040fe20000000000ULL, 0xfffffff805087812ULL, 0x000fe200078ee208ULL,
0x0000003802307836ULL, 0x000fe20000000000ULL, 0x00008a00ff047b82ULL, 0x000e620000000a00ULL,
0xfffffff8030e7812ULL, 0x000fe200078ee20eULL, 0x0000000828037824ULL, 0x000fe200078e00ffULL,
0xfffffff8000f7812ULL, 0x000fe200078ee20fULL, 0x0000000826007824ULL, 0x000fe200078e00ffULL,
0x00000077280a7212ULL, 0x080fe200078e3cffULL, 0x0000000830157824ULL, 0x000fe200078e00ffULL,
0x00000077260b7212ULL, 0x080fe200078e3cffULL, 0x0000000816177c36ULL, 0x000fe20008000000ULL,
0xfffffff8030a7812ULL, 0x000fe200078ee20aULL, 0x000000082e037824ULL, 0x000fe200078e00ffULL,
0xfffffff8000b7812ULL, 0x000fe200078ee20bULL, 0x0000000818197c36ULL, 0x000fe20008000000ULL,
0x000000772e007212ULL, 0x080fe200078e3cffULL, 0x000000081a1b7c36ULL, 0x000fe20008000000ULL,
0x0000007730067212ULL, 0x080fe200078e3cffULL, 0x000000081c1d7c36ULL, 0x000fe20008000000ULL,
0xfffffff803007812ULL, 0x000fe200078ee200ULL, 0x0000001077037824ULL, 0x000fe200078e00ffULL,
0xfffffff815067812ULL, 0x000fe200078ee206ULL, 0x0000000820217c36ULL, 0x000fe20008000000ULL,
0x0000003c02327810ULL, 0x000fe20007ffe0ffULL, 0x0000000822237c36ULL, 0x000fe20008000000ULL,
0x0000007003157812ULL, 0x000fe200078ec0ffULL, 0x0000000802037c36ULL, 0x000fe20008000000ULL,
0x000000081e1f7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000824257c36ULL, 0x000fe20008000000ULL,
0x0000000832337c10ULL, 0x000fe2000fffe0ffULL, 0x0000010003027825ULL, 0x002fe200078e0004ULL,
0x0000007732077212ULL, 0x000fc400078e3cffULL, 0x0000000613137c11ULL, 0x000fe2000f8e20ffULL,
0x0000000826277c36ULL, 0x000fe20008000000ULL, 0x0000000215027210ULL, 0x000fe20007f1e0ffULL,
0x0000000828297c36ULL, 0x000fe20008000000ULL, 0x0000000611117c11ULL, 0x000fe2000f8e20ffULL,
0x000000082a2b7c36ULL, 0x000fe20008000000ULL, 0x0000000610357c11ULL, 0x000fe2000f8e20ffULL,
0x000000082c2d7c36ULL, 0x000fe20008000000ULL, 0x000000060f0f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000082e2f7c36ULL, 0x000fe20008000000ULL, 0x000000060e377c11ULL, 0x000fe2000f8e20ffULL,
0x0000000830317c36ULL, 0x000fe20008000000ULL, 0x000000060d0d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000010017167825ULL, 0x000fe200078e0004ULL, 0x000000060b0b7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000609097c11ULL, 0x000fe2000f8e20ffULL, 0x0000010019187825ULL, 0x000fc800078e0004ULL,
0x000001001b1a7825ULL, 0x000fc800078e0004ULL, 0x0000000832347824ULL, 0x000fe400078e00ffULL,
0x000001001d1c7825ULL, 0x000fc600078e0004ULL, 0xfffffff834077812ULL, 0x000fe200078ee207ULL,
0x000001001f1e7825ULL, 0x000fc600078e0004ULL, 0x0000000607077c11ULL, 0x000fe2000f8e20ffULL,
0x0000010021207825ULL, 0x000fc800078e0004ULL, 0x0000010023227825ULL, 0x000fc800078e0004ULL,
0x0000010025247825ULL, 0x000fc800078e0004ULL, 0x0000010027267825ULL, 0x000fc800078e0004ULL,
0x0000010029287825ULL, 0x000fc800078e0004ULL, 0x000001002b2a7825ULL, 0x000fc800078e0004ULL,
0x000001002d2c7825ULL, 0x000fc800078e0004ULL, 0x000001002f2e7825ULL, 0x000fc800078e0004ULL,
0x0000010031307825ULL, 0x000fc800078e0004ULL, 0x0000010033327825ULL, 0x000fe200078e0004ULL,
0x0000001615047210ULL, 0x000fe40007f3e0ffULL, 0x0000001815167210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000001a15187210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e0617ULL, 0x0000001c151a7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff177224ULL, 0x000fe400010e0619ULL, 0x000000ffff197224ULL, 0x000fe200000e061bULL,
0x0000001e151c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200008e061dULL,
0x00000020151e7210ULL, 0x000fc40007f5e0ffULL, 0x0000002215207210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200000e061fULL, 0x0000002415227210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1f7224ULL, 0x000fe400010e0621ULL, 0x000000ffff217224ULL, 0x000fe200008e0623ULL,
0x0000002615247210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff237224ULL, 0x000fe200000e0625ULL,
0x0000002815267210ULL, 0x000fe40007f1e0ffULL, 0x00000027ff257210ULL, 0x000fc40000ffe4ffULL,
0x0000002a15287210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0629ULL,
0x0000002c152a7210ULL, 0x000fc60007f1e0ffULL, 0x000000ffff297224ULL, 0x000fe200008e062bULL,
0x0000002e152c7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200000e062dULL,
0x00000030152e7210ULL, 0x000fe40007f1e0ffULL, 0x0000003215307210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200008e062fULL, 0x0000000614157c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2f7224ULL, 0x000fe400000e0631ULL, 0x000000ffff317224ULL, 0x000fe200010e0633ULL,
0x0000000612337c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002157faeULL, 0x0003e8000b901c50ULL, 0x0000000004137faeULL, 0x0005e8000b901c50ULL,
0x0000000016337faeULL, 0x000fe8000b901c50ULL, 0x0000000018117faeULL, 0x0009e2000b901c50ULL,
0x000000060c037c11ULL, 0x002fc6000f8e20ffULL, 0x000000001a357faeULL, 0x000fe2000b901c50ULL,
0x000000060a057c11ULL, 0x004fc6000f8e20ffULL, 0x000000001c0f7faeULL, 0x0003e8000b901c50ULL,
0x000000001e377faeULL, 0x000fe2000b901c50ULL, 0x0000000600117c11ULL, 0x010fc6000f8e20ffULL,
0x00000000200d7faeULL, 0x0005e2000b901c50ULL, 0x00000006080f7c11ULL, 0x002fc6000f8e20ffULL,
0x0000000022037faeULL, 0x0007e8000b901c50ULL, 0x00000000240b7faeULL, 0x0007e2000b901c50ULL,
0x00000006060d7c11ULL, 0x004fc6000f8e20ffULL, 0x0000000026057faeULL, 0x0007e8000b901c50ULL,
0x0000000028097faeULL, 0x0007e8000b901c50ULL, 0x000000002a0f7faeULL, 0x0007e8000b901c50ULL,
0x000000002c117faeULL, 0x0007e8000b901c50ULL, 0x000000002e0d7faeULL, 0x0007e8000b901c50ULL,
0x0000000030077faeULL, 0x0007e4000b901c50ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x023600ffff0075a7ULL, 0x000ea2000800014bULL, 0x0000000564007c0cULL, 0x000fe2000bf26070ULL,
0x0000004400788947ULL, 0x004fd80003800000ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x00007610ff707816ULL, 0x000fe20000000070ULL, 0x0000000b14137291ULL, 0x000fe4000f8e203fULL,
0xffffffff050e7890ULL, 0x000fd8000fffe03fULL, 0x00000000640772caULL, 0x000fda00000e0000ULL,
0x0000000d07077291ULL, 0x000fc8000f8e403fULL, 0x000000070f00728cULL, 0x000fcc000bf04070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000164007836ULL, 0x000fe20000000000ULL, 0x00008e00000a7ab9ULL, 0x000fe40000000800ULL,
0x0000000a040972a4ULL, 0x000fe4000f8e0207ULL, 0x0000000500007c0cULL, 0x000fda000bf06070ULL,
0x0000000800b08947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe20000011677ULL,
0x800000070f087290ULL, 0x000fe2000fffe03fULL, 0x0000000777547812ULL, 0x000fe200078ec0ffULL,
0x00008a0000167ab9ULL, 0x000fe20000000a00ULL, 0x0000007700107212ULL, 0x0c0fe200078e3cffULL,
0x0000000800037836ULL, 0x04afe20000000000ULL, 0x0000000b14067291ULL, 0x000fe2000f8e703fULL,
0x0000001000057836ULL, 0x040fe20000000000ULL, 0x0000000800007c0cULL, 0x040fe2000bf06070ULL,
0x0000000803077824ULL, 0x040fe200078e00ffULL, 0x0000007703627212ULL, 0x080fe200078e3cffULL,
0x0000000805097824ULL, 0x040fe200078e00ffULL, 0x0000007705607212ULL, 0x080fe200078e3cffULL,
0x0000002800527836ULL, 0x040fe20000000000ULL, 0xfffffff807627812ULL, 0x000fe200078ee262ULL,
0x0000001800077836ULL, 0x040fe20000000000ULL, 0xfffffff809607812ULL, 0x000fe200078ee260ULL,
0x0000002000097836ULL, 0x000fe20000000000ULL, 0x00000077525a7212ULL, 0x080fe200078e3cffULL,
0x00000008070b7824ULL, 0x040fe200078e00ffULL, 0x00000077075e7212ULL, 0x080fe200078e3cffULL,
0x0000000400027836ULL, 0x000fe20000000000ULL, 0x00000077095c7212ULL, 0x0c0fe200078e3cffULL,
0x00000008520d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b5e7812ULL, 0x000fe200078ee25eULL,
0x00000008090b7824ULL, 0x000fe200078e00ffULL, 0x0000007702637212ULL, 0x080fe200078e3cffULL,
0x0000000c00047836ULL, 0x000fe20000000000ULL, 0x0000000302067819ULL, 0x000fe200000006ffULL,
0x0000000900117c36ULL, 0x040fe20008000000ULL, 0xfffffff80b5c7812ULL, 0x000fe200078ee25cULL,
0x00000030000b7836ULL, 0x000fe20000000000ULL, 0xfffffff80d5a7812ULL, 0x000fe200078ee25aULL,
0x0000000804087824ULL, 0x000fe200078e00ffULL, 0xfffffff806637812ULL, 0x000fe200078ee263ULL,
0x000000080b0f7824ULL, 0x040fe200078e00ffULL, 0x000000770b587212ULL, 0x080fe200078e3cffULL,
0x00000038000d7836ULL, 0x000fe20000000000ULL, 0x0000007704617212ULL, 0x080fe200078e3cffULL,
0x0000001400067836ULL, 0x000fe20000000000ULL, 0xfffffff80f587812ULL, 0x000fe200078ee258ULL,
0x000000080d0f7824ULL, 0x040fe200078e00ffULL, 0xfffffff808617812ULL, 0x000fe200078ee261ULL,
0x00000008060a7824ULL, 0x040fe200078e00ffULL, 0x000000770d567212ULL, 0x080fe200078e3cffULL,
0x00000016ff507e24ULL, 0x000fe2000f8e00ffULL, 0x0000000902137c10ULL, 0x000fe2000fffe0ffULL,
0x00000017ff517e24ULL, 0x000fe2000f8e00ffULL, 0x00000077065f7212ULL, 0x000fe200078e3cffULL,
0x0000000903157c36ULL, 0x000fe20008000000ULL, 0x0000001c00087810ULL, 0x000fe20007ffe0ffULL,
0x0000000904177c36ULL, 0x000fe20008000000ULL, 0x0000000710187812ULL, 0x000fe200078ec0ffULL,
0x0000300006127890ULL, 0x000fe2000fffe03fULL, 0x0000000802007c0cULL, 0x000fe2000bf26070ULL,
0x0000010011107825ULL, 0x000fe200078e0050ULL, 0xfffffff80f567812ULL, 0x000fc400078ee256ULL,
0x0000000803007c0cULL, 0x000fe2000bf46070ULL, 0x0000010013127825ULL, 0x100fe200078e0050ULL,
0xfffffff80a5f7812ULL, 0x000fe400078ee25fULL, 0x00000008540f7812ULL, 0x000fe200078efcffULL,
0x00000008080a7824ULL, 0x000fe200078e00ffULL, 0x0000000804007c0cULL, 0x000fe2000bf66070ULL,
0x0000010015147825ULL, 0x100fe200078e0050ULL, 0x0ffffff818657812ULL, 0x000fe400078ef877ULL,
0x00000077085d7212ULL, 0x000fe200078e3cffULL, 0x0000010017167825ULL, 0x000fe200078e0050ULL,
0x0000001265197c11ULL, 0x000fc4000f8e20ffULL, 0xfffffff80a5d7812ULL, 0x000fe200078ee25dULL,
0x0000002400537836ULL, 0x000fe20000000000ULL, 0x00000012631b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100f107825ULL, 0x000fe200078e0010ULL, 0x00000012621d7c11ULL, 0x000fe4000f8e20ffULL,
0x00000077535b7212ULL, 0x000fe200078e3cffULL, 0x000000100f127825ULL, 0x000fe200078e0012ULL,
0x00000012611f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010197faeULL, 0x0003e2000c101c50ULL, 0x0000000805007c0cULL, 0x000fe2000bf06070ULL,
0x00000008530c7824ULL, 0x000fe200078e00ffULL, 0x0000000809007c0cULL, 0x000fe2000bf86070ULL,
0x0000002c000a7836ULL, 0x000fe20000000000ULL, 0x00000000121b7faeULL, 0x0005e2000c901c50ULL,
0x000000100f147825ULL, 0x000fe200078e0014ULL, 0xfffffff80c5b7812ULL, 0x000fc400078ee25bULL,
0x000000770a597212ULL, 0x0c0fe200078e3cffULL, 0x000000100f167825ULL, 0x000fe200078e0016ULL,
0x000000030a0e7819ULL, 0x000fe200000006ffULL, 0x00000000141d7faeULL, 0x0007e2000d101c50ULL,
0x0000000806007c0cULL, 0x040fe2000bf26070ULL, 0x0000000905217c36ULL, 0x000fe20008000000ULL,
0x0000000807007c0cULL, 0x040fe2000bf46070ULL, 0x0000000906237c36ULL, 0x000fe20008000000ULL,
0x00000000161f7faeULL, 0x0009e2000d901c50ULL, 0x0000000907257c36ULL, 0x000fe20008000000ULL,
0x0000000808007c0cULL, 0x040fe2000bf66070ULL, 0x0000000908197c36ULL, 0x002fe20008000000ULL,
0xfffffff80e597812ULL, 0x000fe200078ee259ULL, 0x00000034000c7836ULL, 0x000fe20000000000ULL,
0x000000080d007c0cULL, 0x000fe2000bfa6070ULL, 0x00000009091b7c36ULL, 0x004fe20008000000ULL,
0x000000125f1d7c11ULL, 0x008fe2000f8e20ffULL, 0x0000010021107825ULL, 0x000fe200078e0050ULL,
0x000000770c577212ULL, 0x000fc400078e3cffULL, 0x000000125e1f7c11ULL, 0x010fe2000f8e20ffULL,
0x0000010023127825ULL, 0x100fe200078e0050ULL, 0x000000125d217c11ULL, 0x000fe4000f8e20ffULL,
0x000000125c237c11ULL, 0x000fe2000f8e20ffULL, 0x0000010025147825ULL, 0x000fe200078e0050ULL,
0x0000001256277c11ULL, 0x000fc6000f8e20ffULL, 0x0000010019167825ULL, 0x000fc800078e0050ULL,
0x000000080c0e7824ULL, 0x000fe400078e00ffULL, 0x000001001b187825ULL, 0x000fe200078e0050ULL,
0x00000012601b7c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff80e577812ULL, 0x000fe200078ee257ULL,
0x000000100f107825ULL, 0x000fc600078e0010ULL, 0x0000001257257c11ULL, 0x000fe2000f8e20ffULL,
0x000000100f127825ULL, 0x000fe200078e0012ULL, 0x00000000101b7faeULL, 0x0003e2000c101c50ULL,
0x0000000853007c0cULL, 0x000fe4000bf06070ULL, 0x000000100f147825ULL, 0x040fe200078e0014ULL,
0x00000000121d7faeULL, 0x0005e2000c901c50ULL, 0x0000000852007c0cULL, 0x000fe4000bf26070ULL,
0x000000100f167825ULL, 0x000fe200078e0016ULL, 0x00000000141f7faeULL, 0x0007e2000d101c50ULL,
0x000000080a007c0cULL, 0x000fc4000bf46070ULL, 0x0000003c000e7836ULL, 0x000fe20000000000ULL,
0x0000000016217faeULL, 0x0009e2000d901c50ULL, 0x000000100f187825ULL, 0x000fe200078e0018ULL,
0x000000080b007c0cULL, 0x000fe4000bf66070ULL, 0x000000770e557212ULL, 0x040fe200078e3cffULL,
0x000000080e1a7824ULL, 0x000fe200078e00ffULL, 0x0000000018237faeULL, 0x000be2000e101c50ULL,
0x0000000953117c36ULL, 0x002fe20008000000ULL, 0x0000000952137c10ULL, 0x004fe2000fffe0ffULL,
0x000000090a157c36ULL, 0x008fe20008000000ULL, 0xfffffff81a557812ULL, 0x000fe200078ee255ULL,
0x000000090d1b7c36ULL, 0x000fe20008000000ULL, 0x000000080c007c0cULL, 0x000fe2000bf86070ULL,
0x000000090b177c36ULL, 0x010fe20008000000ULL, 0x000000080e007c0cULL, 0x040fe2000bfc6070ULL,
0x000000090e1d7c36ULL, 0x000fe20008000000ULL, 0x000000125b1f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000010011107825ULL, 0x000fe200078e0050ULL, 0x000000125a217c11ULL, 0x000fc4000f8e20ffULL,
0x0000001258237c11ULL, 0x020fe2000f8e20ffULL, 0x000000090c197c36ULL, 0x000fe20008000000ULL,
0x0000001255297c11ULL, 0x000fe2000f8e20ffULL, 0x0000010013127825ULL, 0x000fc800078e0050ULL,
0x0000010015147825ULL, 0x000fc800078e0050ULL, 0x0000010017167825ULL, 0x000fc800078e0050ULL,
0x0000010019187825ULL, 0x000fc800078e0050ULL, 0x000001001b1a7825ULL, 0x000fc800078e0050ULL,
0x000001001d1c7825ULL, 0x000fc800078e0050ULL, 0x000000100f107825ULL, 0x000fc800078e0010ULL,
0x000000100f127825ULL, 0x040fe200078e0012ULL, 0x00000000101f7faeULL, 0x0003e6000c101c50ULL,
0x000000100f147825ULL, 0x040fe200078e0014ULL, 0x0000000012217faeULL, 0x0003e6000c901c50ULL,
0x000000100f167825ULL, 0x000fc800078e0016ULL, 0x000000100f187825ULL, 0x000fc800078e0018ULL,
0x000000100f1a7825ULL, 0x000fc800078e001aULL, 0x000000100f1c7825ULL, 0x000fe200078e001cULL,
0x00000012590f7c11ULL, 0x000fca000f8e20ffULL, 0x00000000140f7faeULL, 0x0003e8000d101c50ULL,
0x0000000016237faeULL, 0x0003e8000d901c50ULL, 0x0000000018257faeULL, 0x0003e8000e101c50ULL,
0x000000001a277faeULL, 0x0003e8000e901c50ULL, 0x000000001c297faeULL, 0x0003e2000f101c50ULL,
0x0000000800607947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe20000011677ULL,
0x00008a00ff507b82ULL, 0x000ea20000000a00ULL, 0x0000000b14067291ULL, 0x000fe2000f8e703fULL,
0x0000000777547812ULL, 0x000fe400078ec0ffULL, 0x0000000400027836ULL, 0x042fe20000000000ULL,
0x0000002400537810ULL, 0x000fe20007ffe0ffULL, 0x0000000c00047836ULL, 0x000fe20000000000ULL,
0x0000300006127890ULL, 0x000fe2000fffe03fULL, 0x0000000802067824ULL, 0x040fe200078e00ffULL,
0x0000007702637212ULL, 0x080fe200078e3cffULL, 0x0000000804087824ULL, 0x040fe200078e00ffULL,
0x0000007704617212ULL, 0x080fe200078e3cffULL, 0x0000000800037836ULL, 0x048fe20000000000ULL,
0xfffffff806637812ULL, 0x000fe200078ee263ULL, 0x0000001400067836ULL, 0x000fe20000000000ULL,
0xfffffff808617812ULL, 0x000fe200078ee261ULL, 0x00000008530c7824ULL, 0x000fe200078e00ffULL,
0x0000007703627212ULL, 0x0c0fe200078e3cffULL, 0x0000000806087824ULL, 0x040fe200078e00ffULL,
0x00000077065f7212ULL, 0x080fe200078e3cffULL, 0x0000001800077836ULL, 0x040fe20000000000ULL,
0x0000000303057819ULL, 0x000fe200000006ffULL, 0x0000002800527836ULL, 0x040fe20000000000ULL,
0xfffffff8085f7812ULL, 0x000fe200078ee25fULL, 0x0000001c00087836ULL, 0x000fe20000000000ULL,
0x00000077535b7212ULL, 0x080fe200078e3cffULL, 0x00000008070b7824ULL, 0x000fe200078e00ffULL,
0xfffffff805627812ULL, 0x000fe200078ee262ULL, 0x00000008080a7824ULL, 0x040fe200078e00ffULL,
0x00000077085d7212ULL, 0x080fe200078e3cffULL, 0x0000001000057836ULL, 0x040fe20000000000ULL,
0xfffffff80c5b7812ULL, 0x000fe200078ee25bULL, 0x0000003c000e7836ULL, 0x040fe20000000000ULL,
0xfffffff80a5d7812ULL, 0x000fe200078ee25dULL, 0x0000002c000a7836ULL, 0x000fe20000000000ULL,
0x0000007705607212ULL, 0x0c0fe200078e3cffULL, 0x0000000805097824ULL, 0x000fe200078e00ffULL,
0x00000077075e7212ULL, 0x080fe200078e3cffULL, 0x000000080a0c7824ULL, 0x040fe200078e00ffULL,
0x000000770a597212ULL, 0x080fe200078e3cffULL, 0x00000008520d7824ULL, 0x000fe200078e00ffULL,
0xfffffff809607812ULL, 0x000fe200078ee260ULL, 0x0000002000097836ULL, 0x040fe20000000000ULL,
0xfffffff80c597812ULL, 0x000fe200078ee259ULL, 0x0000000900117c36ULL, 0x000fe20008000000ULL,
0x00000034000c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000902177c36ULL, 0x000fe20008000000ULL,
0xfffffff80b5e7812ULL, 0x000fe200078ee25eULL, 0x00000008090b7824ULL, 0x040fe200078e00ffULL,
0x00000077095c7212ULL, 0x080fe200078e3cffULL, 0x000000080c107824ULL, 0x040fe200078e00ffULL,
0x000000770c577212ULL, 0x080fe200078e3cffULL, 0x00000009031b7c36ULL, 0x000fe20008000000ULL,
0xfffffff80b5c7812ULL, 0x000fe200078ee25cULL, 0x00000030000b7836ULL, 0x000fe20000000000ULL,
0xfffffff810577812ULL, 0x000fe200078ee257ULL, 0x000000080e107824ULL, 0x000fe200078e00ffULL,
0x00000077525a7212ULL, 0x080fe200078e3cffULL, 0x000000080b0f7824ULL, 0x040fe200078e00ffULL,
0x000000770e557212ULL, 0x080fe200078e3cffULL, 0x00000009041f7c36ULL, 0x000fe20008000000ULL,
0xfffffff80d5a7812ULL, 0x000fe200078ee25aULL, 0x00000038000d7836ULL, 0x000fe20000000000ULL,
0x000000770b587212ULL, 0x080fe200078e3cffULL, 0x0000000906257c36ULL, 0x000fe20008000000ULL,
0xfffffff810557812ULL, 0x000fe200078ee255ULL, 0x0000000907297c36ULL, 0x000fe20008000000ULL,
0x0000007700107212ULL, 0x080fe200078e3cffULL, 0x00000009082d7c36ULL, 0x000fe20008000000ULL,
0xfffffff80f587812ULL, 0x000fe200078ee258ULL, 0x000000080d0f7824ULL, 0x000fe200078e00ffULL,
0x0000000710127812ULL, 0x000fe200078ec0ffULL, 0x00000009092f7c36ULL, 0x000fe20008000000ULL,
0x0000000905237c10ULL, 0x000fe2000fffe0ffULL, 0x00000009532b7c36ULL, 0x000fe20008000000ULL,
0x000000090d157c10ULL, 0x000fe2000fffe0ffULL, 0x0000000952277c36ULL, 0x000fe20008000000ULL,
0x000000770d567212ULL, 0x000fe200078e3cffULL, 0x000000090a217c36ULL, 0x000fe20008000000ULL,
0x0ffffff812657812ULL, 0x000fe200078ef877ULL, 0x000000090b1d7c36ULL, 0x000fe20008000000ULL,
0xfffffff80f567812ULL, 0x000fe200078ee256ULL, 0x000000090c197c36ULL, 0x000fe20008000000ULL,
0x00000008540f7812ULL, 0x000fe200078efcffULL, 0x000000090e137c36ULL, 0x000fe20008000000ULL,
0x0000001265317c11ULL, 0x000fe2000f8e20ffULL, 0x0000010011107825ULL, 0x004fe200078e0050ULL,
0x0000001262337c11ULL, 0x000fc4000f8e20ffULL, 0x0000001261357c11ULL, 0x000fe2000f8e20ffULL,
0x0000010017167825ULL, 0x100fe200078e0050ULL, 0x0000001260377c11ULL, 0x000fe4000f8e20ffULL,
0x000000125f397c11ULL, 0x000fe2000f8e20ffULL, 0x000001001b1a7825ULL, 0x100fe200078e0050ULL,
0x000000125c3b7c11ULL, 0x000fe4000f8e20ffULL, 0x000000125b3d7c11ULL, 0x000fe2000f8e20ffULL,
0x000001001f1e7825ULL, 0x000fe200078e0050ULL, 0x000000125a3f7c11ULL, 0x000fc6000f8e20ffULL,
0x0000010023227825ULL, 0x000fc800078e0050ULL, 0x0000010025247825ULL, 0x000fc800078e0050ULL,
0x0000010029287825ULL, 0x000fc800078e0050ULL, 0x000001002d2c7825ULL, 0x000fc800078e0050ULL,
0x000001002f2e7825ULL, 0x000fc800078e0050ULL, 0x000001002b2a7825ULL, 0x000fc800078e0050ULL,
0x0000010027267825ULL, 0x000fc800078e0050ULL, 0x0000010021207825ULL, 0x000fc800078e0050ULL,
0x000001001d1c7825ULL, 0x000fc800078e0050ULL, 0x0000010019187825ULL, 0x000fc800078e0050ULL,
0x0000010015147825ULL, 0x000fc800078e0050ULL, 0x0000010013127825ULL, 0x000fc800078e0050ULL,
0x000000100f107825ULL, 0x000fc800078e0010ULL, 0x000000100f167825ULL, 0x040fe200078e0016ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010317faeULL, 0x0003e6000b901c50ULL,
0x000000100f1a7825ULL, 0x000fc800078e001aULL, 0x000000100f1e7825ULL, 0x000fc800078e001eULL,
0x000000100f227825ULL, 0x000fe200078e0022ULL, 0x000000125e117c11ULL, 0x002fe4000f8e20ffULL,
0x000000125d317c11ULL, 0x000fe2000f8e20ffULL, 0x000000100f247825ULL, 0x000fc800078e0024ULL,
0x000000100f287825ULL, 0x000fc800078e0028ULL, 0x000000100f2c7825ULL, 0x000fc800078e002cULL,
0x000000100f2e7825ULL, 0x000fc800078e002eULL, 0x000000100f2a7825ULL, 0x000fc800078e002aULL,
0x000000100f267825ULL, 0x000fc800078e0026ULL, 0x000000100f207825ULL, 0x000fc800078e0020ULL,
0x000000100f1c7825ULL, 0x000fc800078e001cULL, 0x000000100f187825ULL, 0x000fc800078e0018ULL,
0x000000100f147825ULL, 0x000fc800078e0014ULL, 0x000000100f127825ULL, 0x000fe200078e0012ULL,
0x00000012630f7c11ULL, 0x000fca000f8e20ffULL, 0x00000000160f7faeULL, 0x0003e8000b901c50ULL,
0x000000001a337faeULL, 0x0005e8000b901c50ULL, 0x000000001e357faeULL, 0x0007e8000b901c50ULL,
0x0000000022377faeULL, 0x0009e2000b901c50ULL, 0x00000012590f7c11ULL, 0x002fc4000f8e20ffULL,
0x0000001258177c11ULL, 0x000fe2000f8e20ffULL, 0x0000000024397faeULL, 0x0003e2000b901c50ULL,
0x00000012571b7c11ULL, 0x004fc6000f8e20ffULL, 0x0000000028117faeULL, 0x0003e2000b901c50ULL,
0x00000012561f7c11ULL, 0x008fc6000f8e20ffULL, 0x000000002c317faeULL, 0x0003e2000b901c50ULL,
0x0000001255237c11ULL, 0x010fc6000f8e20ffULL, 0x000000002e3b7faeULL, 0x0003e8000b901c50ULL,
0x000000002a3d7faeULL, 0x0003e8000b901c50ULL, 0x00000000263f7faeULL, 0x0003e8000b901c50ULL,
0x00000000200f7faeULL, 0x0003e8000b901c50ULL, 0x000000001c177faeULL, 0x0003e8000b901c50ULL,
0x00000000181b7faeULL, 0x0003e8000b901c50ULL, 0x00000000141f7faeULL, 0x0003e8000b901c50ULL,
0x0000000012237faeULL, 0x0003e4000b901c50ULL, 0x00000004ff787819ULL, 0x000fe20000011677ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000008540f7812ULL, 0x002fe200078ef877ULL,
0x00001000060c7890ULL, 0x000fe2000fffe03fULL, 0x0000000100667812ULL, 0x000fe200078ec0ffULL,
0x0000000878117824ULL, 0x040fe200078e00ffULL, 0x0000000778107812ULL, 0x000fe200078e780fULL,
0x00000004781c7836ULL, 0x000fe20000000000ULL, 0x00000000640872caULL, 0x000fe400000e0000ULL,
0xfffffff811117812ULL, 0x000fe200078ee254ULL, 0x000000100f107824ULL, 0x000fe200078e0210ULL,
0x000000071c1c7812ULL, 0x000fc400078e780fULL, 0x00000007114e7812ULL, 0x040fe200078ec0ffULL,
0x00000008114f7824ULL, 0x040fe200078e00ffULL, 0x0000000b10107c11ULL, 0x000fe2000f8e20ffULL,
0x00000010114d7836ULL, 0x040fe20000000000ULL, 0x000000014e127812ULL, 0x000fe200078e7800ULL,
0x00000020114c7836ULL, 0x040fe20000000000ULL, 0x000000024e727812ULL, 0x000fe200078e1e66ULL,
0x0000003011117836ULL, 0x000fe20000000000ULL, 0x0000004f12757212ULL, 0x000fe200078efcffULL,
0x0000000278127836ULL, 0x000fe20000000000ULL, 0x000000074d4a7812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000c75147c11ULL, 0x000fe2000f8e20ffULL,
0x000000001040783bULL, 0x0003e20000000200ULL, 0x0000000712127812ULL, 0x000fe200078e780fULL,
0x000000084d4d7824ULL, 0x000fe200078e00ffULL, 0x0000000711487812ULL, 0x040fe200078ec0ffULL,
0x00000008114b7824ULL, 0x000fe200078e00ffULL, 0x000000001414783bULL, 0x000ea20000000200ULL,
0x000000014a747812ULL, 0x000fe200078e7800ULL, 0x000000100f127824ULL, 0x040fe200078e0212ULL,
0x0000004f72727212ULL, 0x000fe200078efcffULL, 0x000000100f3c7824ULL, 0x000fe200078e021cULL,
0x0000000148107812ULL, 0x002fe200078e7800ULL, 0x0000000815087290ULL, 0x000fe2000fffe03fULL,
0x000000074c497812ULL, 0x000fc400078ec0ffULL, 0x0000004d74747212ULL, 0x000fe200078efcffULL,
0x0000000108067890ULL, 0x000fe2000fffe03fULL, 0x0000000c722c7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000d08097291ULL, 0x000fe2000f8e403fULL, 0x0000004b10717212ULL, 0x000fe200078efcffULL,
0x000000050600728cULL, 0x000fe2000bf06070ULL, 0x0000000b12127c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a040a72a4ULL, 0x000fe2000f8e0209ULL, 0x000000034c4c7819ULL, 0x000fe200000006ffULL,
0x000000002c2c783bULL, 0x000fe20000000200ULL, 0x0000000149737812ULL, 0x000fc400078e7800ULL,
0x0000000c74387c11ULL, 0x000fe2000f8e20ffULL, 0x000000001220783bULL, 0x000e620000000200ULL,
0x0000000c71107c11ULL, 0x000fe4000f8e20ffULL, 0x0000004c73737212ULL, 0x000fe400078efcffULL,
0x000000003838783bULL, 0x000ee20000000200ULL, 0x000000024a767812ULL, 0x000fe400078e1e66ULL,
0x0000000c73187c11ULL, 0x000fe2000f8e20ffULL, 0x000000001010783bULL, 0x000f220000000200ULL,
0x0000004d76767212ULL, 0x000fc400078efcffULL, 0x00000002486e7812ULL, 0x000fe400078e1e66ULL,
0x000000001818783bULL, 0x000f620000000200ULL, 0x0000000c76347c11ULL, 0x000fe4000f8e20ffULL,
0x00000002496f7812ULL, 0x000fe200078e1e66ULL, 0x000000144024723cULL, 0x004fe200000018ffULL,
0x0000004b6e6e7212ULL, 0x000fe400078efcffULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x0000004c6f6f7212ULL, 0x000fc400078efcffULL, 0x000000164014723cULL, 0x000fe200000018ffULL,
0x0000000c6e287c11ULL, 0x000fe4000f8e20ffULL, 0x000000044e1e7812ULL, 0x000fe400078e1e66ULL,
0x000000044a6c7812ULL, 0x000fe400078e1e66ULL, 0x0000004f1e6d7212ULL, 0x000fe200078efcffULL,
0x000000002828783bULL, 0x000ea20000000200ULL, 0x0000004d6c6c7212ULL, 0x000fe400078efcffULL,
0x00000004486a7812ULL, 0x000fc400078e1e66ULL, 0x0000000c6c677c11ULL, 0x000fe4000f8e20ffULL,
0x00000004496b7812ULL, 0x000fe400078e1e66ULL, 0x0000004b6a6a7212ULL, 0x000fe200078efcffULL,
0x0000002c2024723cULL, 0x002fe20000001824ULL, 0x0000004c6b6b7212ULL, 0x000fe400078efcffULL,
0x000000064e4e7812ULL, 0x000fe400078e1e66ULL, 0x0000000c6b687c11ULL, 0x000fe2000f8e20ffULL,
0x0000002e202c723cULL, 0x000fe20000001814ULL, 0x0000004f4e697212ULL, 0x000fc400078efcffULL,
0x000000000000781cULL, 0x000fc60003f0f008ULL, 0x000000384030723cULL, 0x008fe200000018ffULL,
0x0000000c6f147c11ULL, 0x000fca000f8e20ffULL, 0x0000003a4038723cULL, 0x000fe200000018ffULL,
0x000000001414783bULL, 0x000e6a0000000200ULL, 0x00000010401c723cULL, 0x010fec00000018ffULL,
0x000000184044723cULL, 0x020fe200000018ffULL, 0x0000000b3c107c11ULL, 0x000fc4000f8e20ffULL,
0x0000000c6d3c7c11ULL, 0x000fc6000f8e20ffULL, 0x0000001a4018723cULL, 0x000fe600000018ffULL,
0x000000003c3c783bULL, 0x000fe60000000200ULL, 0x000000124040723cULL, 0x000fe200000018ffULL,
0x000000001010783bULL, 0x000eea0000000200ULL, 0x000000342030723cULL, 0x004fec0000001830ULL,
0x000000362034723cULL, 0x000fe20000001838ULL, 0x000000006738783bULL, 0x00052a0000000200ULL,
0x00000028201c723cULL, 0x000fe2000000181cULL, 0x0000000649677812ULL, 0x004fca00078e1e66ULL,
0x000000142044723cULL, 0x002fe20000001844ULL, 0x0000000c6a287c11ULL, 0x000fe4000f8e20ffULL,
0x0000004c67677212ULL, 0x000fc600078efcffULL, 0x000000162014723cULL, 0x000fe20000001818ULL,
0x000000006818783bULL, 0x0002aa0000000200ULL, 0x0000002a2020723cULL, 0x000fe20000001840ULL,
0x000000002828783bULL, 0x000f620000000200ULL, 0x000000064a687812ULL, 0x002fe400078e1e66ULL,
0x0000000648667812ULL, 0x000fc400078e1e66ULL, 0x0000003c1024723cULL, 0x008fe20000001824ULL,
0x0000004d68687212ULL, 0x000fe400078efcffULL, 0x0000004b66667212ULL, 0x000fe400078efcffULL,
0x0000000c68407c11ULL, 0x000fe2000f8e20ffULL, 0x0000003e102c723cULL, 0x000fe2000000182cULL,
0x00000006783c7836ULL, 0x000fe20000000000ULL, 0x0000000c67487c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c664c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000004040783bULL, 0x000fe20000000200ULL,
0x000000073c3c7812ULL, 0x000fe200078e780fULL, 0x000000381030723cULL, 0x010fe40000001830ULL,
0x000000004848783bULL, 0x000fe40000000200ULL, 0x000000100f3c7824ULL, 0x000fc400078e023cULL,
0x0000003a1034723cULL, 0x000fe20000001834ULL, 0x000000004c4c783bULL, 0x000fe40000000200ULL,
0x0000000b3c387c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c693c7c11ULL, 0x000fc8000f8e20ffULL,
0x000000003838783bULL, 0x000e620000000200ULL, 0x000000181044723cULL, 0x004fe60000001844ULL,
0x000000003c3c783bULL, 0x000ea60000000200ULL, 0x0000001a1014723cULL, 0x000fec0000001814ULL,
0x00000028101c723cULL, 0x020fec000000181cULL, 0x0000002a1020723cULL, 0x000fec0000001820ULL,
0x000000403830723cULL, 0x002fec0000001830ULL, 0x0000003c3824723cULL, 0x004fec0000001824ULL,
0x0000003e382c723cULL, 0x000fec000000182cULL, 0x000000423834723cULL, 0x000fec0000001834ULL,
0x000000483844723cULL, 0x000fec0000001844ULL, 0x0000004a3814723cULL, 0x000fec0000001814ULL,
0x0000004c381c723cULL, 0x000fec000000181cULL, 0x0000004e3820723cULL, 0x000fe20000001820ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000400e48947ULL, 0x000fde0003800000ULL,
0x0000000a00137c36ULL, 0x000fe20008000000ULL, 0x000000090f00728cULL, 0x000fe2000bf01070ULL,
0x00000010774a7824ULL, 0x000fe200078e00ffULL, 0x0000000a03197c10ULL, 0x000fe2000fffe0ffULL,
0x0000000a02117c36ULL, 0x000fe20008000000ULL, 0x000000090f067287ULL, 0x000fe2000c000000ULL,
0x0000010013127825ULL, 0x100fe200078e0050ULL, 0x000000704a4a7812ULL, 0x000fe400078ec0ffULL,
0x0000000609067290ULL, 0x000fe2000fffe13fULL, 0x0000010011107825ULL, 0x000fe200078e0050ULL,
0x000000124a127210ULL, 0x000fc40007f1e0ffULL, 0x0000000c65657c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a041b7c36ULL, 0x000fe20008000000ULL, 0x000000104a107210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x0000000602007c0cULL, 0x000fe2000bf06070ULL,
0x000001001b1a7825ULL, 0x000fe200078e0050ULL, 0x0000000603007c0cULL, 0x000fe4000bf66070ULL,
0x0000000c63637c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000001a4a027210ULL, 0x000fe20007f3e0ffULL, 0x0000010019187825ULL, 0x000fe200078e0050ULL,
0x0000000606007c0cULL, 0x000fc4000bfa6070ULL, 0x0000000a09297c10ULL, 0x000fe2000fffe0ffULL,
0x000000ffff037224ULL, 0x000fe200008e061bULL, 0x0000000600007c0cULL, 0x000fe2000bf26070ULL,
0x0000000a072b7c36ULL, 0x000fe20008000000ULL, 0x000000184a187210ULL, 0x000fe20007f5e0ffULL,
0x0000000a05497c36ULL, 0x040fe20008000000ULL, 0x0000000605007c0cULL, 0x000fe2000bf86070ULL,
0x000001002b2a7825ULL, 0x100fe200078e0050ULL, 0x0000000c61617c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c5f5f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000010049487825ULL, 0x000fe200078e0050ULL,
0x0000000c5d5d7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000c5b5b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a06437c36ULL, 0x000fe20008000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012657faeULL, 0x000fe2000c901c50ULL, 0x000000ffff197224ULL, 0x000fe200010e0619ULL,
0x0000002a4a067210ULL, 0x000fe20007f3e0ffULL, 0x0000010043427825ULL, 0x100fe200078e0050ULL,
0x0000000604007c0cULL, 0x000fe2000bf46070ULL, 0x0000000010637faeULL, 0x0003e2000c101c50ULL,
0x000000484a487210ULL, 0x000fe20007fde0ffULL, 0x0000000a08417c36ULL, 0x000fe20008000000ULL,
0x0000000607007c0cULL, 0x000fe2000bf06070ULL, 0x0000010029287825ULL, 0x000fe200078e0050ULL,
0x0000002bff077210ULL, 0x000fc40000ffe4ffULL, 0x0000000c622b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff497224ULL, 0x000fe200030e0649ULL, 0x000000424a427210ULL, 0x000fe20007fde0ffULL,
0x0000010041407825ULL, 0x000fe200078e0050ULL, 0x0000000608007c0cULL, 0x000fe2000bf26070ULL,
0x00000000182b7faeULL, 0x0005e2000d901c50ULL, 0x000000284a087210ULL, 0x000fe20007f7e0ffULL,
0x0000000a533f7c36ULL, 0x000fe20008000000ULL, 0x0000000c59597c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff437224ULL, 0x000fe200030e0643ULL, 0x000000404a107210ULL, 0x002fe20007fde0ffULL,
0x0000000002617faeULL, 0x0003e2000d101c50ULL, 0x000001003f3e7825ULL, 0x000fe200078e0050ULL,
0x0000000609007c0cULL, 0x000fc4000bf46070ULL, 0x0000000c57577c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a52397c36ULL, 0x000fe20008000000ULL, 0x0000000c5e2b7c11ULL, 0x004fe2000f8e20ffULL,
0x000000ffff097224ULL, 0x000fe200018e0629ULL, 0x0000000c60297c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a0a3d7c36ULL, 0x000fe20008000000ULL, 0x0000000653007c0cULL, 0x000fe2000bf66070ULL,
0x0000000a0b057c36ULL, 0x000fe20008000000ULL, 0x0000000c55557c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff117224ULL, 0x000fe200030e0641ULL, 0x0000003e4a027210ULL, 0x002fe20007fde0ffULL,
0x0000000a0d1b7c36ULL, 0x000fe20008000000ULL, 0x0000000048297faeULL, 0x0003e2000e101c50ULL,
0x0000010039387825ULL, 0x000fc600078e0050ULL, 0x00000000425f7faeULL, 0x000fe2000e901c50ULL,
0x000001003d3c7825ULL, 0x100fe200078e0050ULL, 0x000000384a127210ULL, 0x000fe40007f9e0ffULL,
0x00000000062b7faeULL, 0x0005e2000c101c50ULL, 0x0000010005047825ULL, 0x100fe200078e0050ULL,
0x0000000652007c0cULL, 0x000fe4000bfa6070ULL, 0x0000000c5c297c11ULL, 0x002fe2000f8e20ffULL,
0x0000000a0c3b7c36ULL, 0x000fe20008000000ULL, 0x000000044a047210ULL, 0x000fe20007f1e0ffULL,
0x000001001b1a7825ULL, 0x000fe200078e0050ULL, 0x00000000105d7faeULL, 0x000fe2000c901c50ULL,
0x000000060b007c0cULL, 0x000fc4000bf26070ULL, 0x000000ffff037224ULL, 0x000fe200030e063fULL,
0x0000003c4a187210ULL, 0x000fe20007fde0ffULL, 0x000001003b3a7825ULL, 0x000fe200078e0050ULL,
0x0000000008297faeULL, 0x0003e2000d101c50ULL, 0x0000001a4a067210ULL, 0x004fe40007f5e0ffULL,
0x0000000a0e4b7c36ULL, 0x000fe20008000000ULL, 0x00000000025b7faeULL, 0x0005e2000d901c50ULL,
0x000000ffff137224ULL, 0x000fe200020e0639ULL, 0x000000060a007c0cULL, 0x000fe2000bf86070ULL,
0x000000ffff197224ULL, 0x000fe200030e063dULL, 0x0000003a4a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x000000060c007c0cULL, 0x000fe2000bf06070ULL,
0x000001004b507825ULL, 0x000fe200078e0050ULL, 0x000000060d007c0cULL, 0x000fc4000bf66070ULL,
0x0000000c5a0d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff077224ULL, 0x000fe200010e061bULL,
0x000000060e007c0cULL, 0x000fe2000bf46070ULL, 0x000000ffff0b7224ULL, 0x000fe200030e063bULL,
0x000000504a4a7210ULL, 0x000fe20007fde0ffULL, 0x00000000120d7faeULL, 0x0007e2000e901c50ULL,
0x0000000c58097c11ULL, 0x002fe4000f8e20ffULL, 0x0000000c56037c11ULL, 0x004fe2000f8e20ffULL,
0x000000ffff4b7224ULL, 0x000fe200030e0651ULL, 0x0000000018597faeULL, 0x0007e8000e101c50ULL,
0x0000000004097faeULL, 0x0007e8000c901c50ULL, 0x000000000a577faeULL, 0x0007e8000c101c50ULL,
0x0000000006037faeULL, 0x0007e8000d901c50ULL, 0x000000004a557faeULL, 0x0007e2000d101c50ULL,
0x0000000400947947ULL, 0x000fea0003800000ULL, 0x0000000a022b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001077027824ULL, 0x000fe200078e00ffULL, 0x0000000c65657c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a003d7c36ULL, 0x000fe20008000000ULL, 0x0000000c63637c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a0e417c36ULL, 0x000fe20008000000ULL, 0x00000070020e7812ULL, 0x000fe200078ec0ffULL,
0x000001003d3c7825ULL, 0x100fe200078e0050ULL, 0x0000000c61617c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c60437c11ULL, 0x000fe2000f8e20ffULL, 0x000001002b2a7825ULL, 0x000fe200078e0050ULL,
0x0000003c0e3c7210ULL, 0x000fc40007f1e0ffULL, 0x0000000c5f5f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a03297c36ULL, 0x000fe20008000000ULL, 0x0000002a0e2a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000a051b7c36ULL, 0x000fe20008000000ULL, 0x0000000a0a037c10ULL, 0x000fe2000fffe0ffULL,
0x0000010029287825ULL, 0x100fe200078e0050ULL, 0x0000000c5e497c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c5d5d7c11ULL, 0x000fe2000f8e20ffULL, 0x000001001b1a7825ULL, 0x000fe200078e0050ULL,
0x0000000c5b5b7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000c59597c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a06137c36ULL, 0x000fe20008000000ULL, 0x0000000c57577c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a07117c36ULL, 0x000fe20008000000ULL, 0x0000000c55557c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a04397c36ULL, 0x000fe40008000000ULL, 0x000000ffff3d7224ULL, 0x000fe200000e063dULL,
0x000000280e287210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200008e062bULL,
0x0000001a0e1a7210ULL, 0x000fe20007f3e0ffULL, 0x0000010013127825ULL, 0x100fe200078e0050ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c657faeULL, 0x000fe6000b901c50ULL,
0x0000010011107825ULL, 0x000fe200078e0050ULL, 0x000000002a637faeULL, 0x0005e6000b901c50ULL,
0x0000000a09097c36ULL, 0x000fc40008000000ULL, 0x0000000a53537c36ULL, 0x000fe40008000000ULL,
0x0000010039387825ULL, 0x000fc800078e0050ULL, 0x0000000a08197c36ULL, 0x000fe20008000000ULL,
0x000000380e387210ULL, 0x000fe20007f5e0ffULL, 0x0000000a0c3b7c36ULL, 0x000fe20008000000ULL,
0x0000000c5c2b7c11ULL, 0x004fe2000f8e20ffULL, 0x0000000a0d3f7c36ULL, 0x000fe20008000000ULL,
0x00000039ff397210ULL, 0x000fe200017fe4ffULL, 0x000000ffff297224ULL, 0x000fe200000e0629ULL,
0x000000120e127210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200008e061bULL,
0x000000100e107210ULL, 0x000fe20007f3e0ffULL, 0x00000100090c7825ULL, 0x000fc800078e0050ULL,
0x0000010053087825ULL, 0x000fc800078e0050ULL, 0x0000010019187825ULL, 0x000fc800078e0050ULL,
0x0000000a52077c36ULL, 0x000fe20008000000ULL, 0x000000180e187210ULL, 0x000fe20007f5e0ffULL,
0x0000000a0b057c36ULL, 0x000fe40008000000ULL, 0x000000ffff137224ULL, 0x000fe200000e0613ULL,
0x0000000c0e0c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x000000080e087210ULL, 0x000fe20007f3e0ffULL, 0x00000100030a7825ULL, 0x000fc800078e0050ULL,
0x0000010007067825ULL, 0x000fc800078e0050ULL, 0x0000010005027825ULL, 0x000fc800078e0050ULL,
0x000001003b047825ULL, 0x000fc800078e0050ULL, 0x000001003f3a7825ULL, 0x000fc800078e0050ULL,
0x0000010041507825ULL, 0x000fe200078e0050ULL, 0x0000000c62417c11ULL, 0x000fc6000f8e20ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x000000060e067210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000000020e027210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e0619ULL, 0x0000000a0e0a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000028417faeULL, 0x0005e2000b901c50ULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x000000040e047210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff037224ULL, 0x000fe200008e0603ULL,
0x0000000038617faeULL, 0x000fe2000b901c50ULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x0000003a0e3a7210ULL, 0x000fc40007f3e0ffULL, 0x000000001a437faeULL, 0x000fe2000b901c50ULL,
0x000000500e3e7210ULL, 0x000fe40007f5e0ffULL, 0x00000005ff057210ULL, 0x000fe200007fe4ffULL,
0x00000000125f7faeULL, 0x0007e2000b901c50ULL, 0x0000000c5a297c11ULL, 0x004fe2000f8e20ffULL,
0x000000ffff3b7224ULL, 0x000fe400008e063bULL, 0x0000000010497faeULL, 0x0005e2000b901c50ULL,
0x000000ffff3f7224ULL, 0x000fc600010e0651ULL, 0x00000000185d7faeULL, 0x0003e2000b901c50ULL,
0x0000000c58137c11ULL, 0x008fc6000f8e20ffULL, 0x000000000c2b7faeULL, 0x0003e2000b901c50ULL,
0x0000000c56117c11ULL, 0x004fc6000f8e20ffULL, 0x00000000085b7faeULL, 0x0003e8000b901c50ULL,
0x0000000006297faeULL, 0x0003e8000b901c50ULL, 0x000000000a597faeULL, 0x0003e8000b901c50ULL,
0x0000000002137faeULL, 0x0003e8000b901c50ULL, 0x0000000004577faeULL, 0x0003e8000b901c50ULL,
0x000000003a117faeULL, 0x0003e8000b901c50ULL, 0x000000003e557faeULL, 0x0003e4000b901c50ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000878027836ULL, 0x042fe20000000000ULL,
0x0000001275087c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a780c7836ULL, 0x000fe20000000000ULL,
0x0000001274107c11ULL, 0x008fe2000f8e20ffULL, 0x0000000b14097291ULL, 0x000fe2000f8e383fULL,
0x0000000702027812ULL, 0x000fe400078e780fULL, 0x0000001273187c11ULL, 0x000fe4000f8e20ffULL,
0x000000070c0c7812ULL, 0x000fe200078e780fULL, 0x000000100f027824ULL, 0x000fe200078e0202ULL,
0x0000001271287c11ULL, 0x000fc4000f8e20ffULL, 0x0000001272387c11ULL, 0x000fe2000f8e20ffULL,
0x000000100f0c7824ULL, 0x000fe200078e020cULL, 0x0000000b02027c11ULL, 0x000fe4000f8e20ffULL,
0x000000126c6c7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000b0c0c7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001268687c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000808783bULL, 0x000fe20000000200ULL, 0x0000001269407c11ULL, 0x000fc6000f8e20ffULL,
0x000000000204783bULL, 0x0002a80000000200ULL, 0x000000001010783bULL, 0x000ee80000000200ULL,
0x000000001818783bULL, 0x000f220000000200ULL, 0x0000000c78027836ULL, 0x042fe40000000000ULL,
0x0000000e78787836ULL, 0x000fe20000000000ULL, 0x000000002828783bULL, 0x000e640000000200ULL,
0x0000000702027812ULL, 0x000fc400078e780fULL, 0x000000003838783bULL, 0x000fe20000000200ULL,
0x0000000778787812ULL, 0x000fe400078e780fULL, 0x000000100f027824ULL, 0x040fe200078e0202ULL,
0x000000000c3c783bULL, 0x000a620000000200ULL, 0x000000780f787211ULL, 0x000fc600078e20ffULL,
0x0000000b02027c11ULL, 0x000fe2000f8e20ffULL, 0x000000004040783bULL, 0x000fe20000000200ULL,
0x0000000b780c7c11ULL, 0x020fcc000f8e20ffULL, 0x000000000c0c783bULL, 0x000fe20000000200ULL,
0x000000080424723cULL, 0x004fec0000001824ULL, 0x0000000a042c723cULL, 0x000fe2000000182cULL,
0x0000001276087c11ULL, 0x000fca000f8e20ffULL, 0x000000100430723cULL, 0x008fe20000001830ULL,
0x000000000808783bULL, 0x000eaa0000000200ULL, 0x000000180444723cULL, 0x010fe20000001844ULL,
0x000000126f107c11ULL, 0x000fca000f8e20ffULL, 0x000000120434723cULL, 0x000fe20000001834ULL,
0x000000126e187c11ULL, 0x000fe2000f8e20ffULL, 0x000000001010783bULL, 0x000ee80000000200ULL,
0x0000001a0414723cULL, 0x000fe20000001814ULL, 0x000000001818783bULL, 0x000f2a0000000200ULL,
0x00000028041c723cULL, 0x002fec000000181cULL, 0x0000002a0420723cULL, 0x000fe20000001820ULL,
0x000000000228783bULL, 0x0003ea0000000200ULL, 0x000000383c24723cULL, 0x000fe20000001824ULL,
0x000000126d047c11ULL, 0x000fc4000f8e20ffULL, 0x0000ffff70027812ULL, 0x002fc600078ec0ffULL,
0x0000003a3c2c723cULL, 0x000fe2000000182cULL, 0x000000000404783bULL, 0x000e6a0000000200ULL,
0x000000083c38723cULL, 0x004fe20000001830ULL, 0x000000006c30783bULL, 0x000eaa0000000200ULL,
0x0000000a3c34723cULL, 0x000fe20000001834ULL, 0x000000126b087c11ULL, 0x000fca000f8e20ffULL,
0x000000103c44723cULL, 0x008fe20000001844ULL, 0x000000000808783bULL, 0x000eea0000000200ULL,
0x000000123c14723cULL, 0x000fe20000001814ULL, 0x000000126a107c11ULL, 0x000fca000f8e20ffULL,
0x000000183c1c723cULL, 0x010fe2000000181cULL, 0x000000001010783bULL, 0x000fea0000000200ULL,
0x0000001a3c3c723cULL, 0x000fe20000001820ULL, 0x000000006820783bULL, 0x000f220000000200ULL,
0x0000001267187c11ULL, 0x000fc8000f8e20ffULL, 0x000000042848723cULL, 0x002fe40000001824ULL,
0x000000001818783bULL, 0x000e680000000200ULL, 0x000000322834723cULL, 0x004fe20000001834ULL,
0x0000001266247c11ULL, 0x000fca000f8e20ffULL, 0x00000006282c723cULL, 0x000fe2000000182cULL,
0x000000002424783bULL, 0x000eaa0000000200ULL, 0x000000082844723cULL, 0x008fec0000001844ULL,
0x0000000a2808723cULL, 0x000fec0000001814ULL, 0x000000302838723cULL, 0x000fec0000001838ULL,
0x000000220c14723cULL, 0x010fec0000001834ULL, 0x000000102804723cULL, 0x000fe2000000181cULL,
0x0000888002237816ULL, 0x000fe200000000ffULL, 0x0000000477027824ULL, 0x000fc800078e00ffULL,
0x00000012283c723cULL, 0x000fe2000000183cULL, 0x8000000023237824ULL, 0x000fe200078e00ffULL,
0xfffffff002027812ULL, 0x000fc600078ec0ffULL, 0x02361023ff0075a7ULL, 0x000ee20008000153ULL,
0x000000400c48723cULL, 0x000fec0000001848ULL, 0x000000420c2c723cULL, 0x000fe2000000182cULL,
0x3db504f314147820ULL, 0x000fe20000410000ULL, 0x3db504f315157820ULL, 0x000fe20000410000ULL,
0x3db504f316167820ULL, 0x000fe20000410000ULL, 0x3db504f317177820ULL, 0x000fc40000410000ULL,
0x000000200c1c723cULL, 0x000fec0000001838ULL, 0x000000180c10723cULL, 0x002fec0000001844ULL,
0x0000001a0c08723cULL, 0x000fe20000001808ULL, 0x3db504f348037820ULL, 0x000fe20000410000ULL,
0x3db504f349187820ULL, 0x000fe20000410000ULL, 0x3db504f34b197820ULL, 0x000fc60000410000ULL,
0x000000240c04723cULL, 0x004fe20000001804ULL, 0x3db504f34a1a7820ULL, 0x000fe20000410000ULL,
0x3db504f32c2c7820ULL, 0x000fe20000410000ULL, 0x3db504f32d2d7820ULL, 0x000fe20000410000ULL,
0x3db504f32e2e7820ULL, 0x000fe20000410000ULL, 0x3db504f32f2f7820ULL, 0x000fe20000410000ULL,
0x000000260c0c723cULL, 0x000fe2000000183cULL, 0x3db504f31c1c7820ULL, 0x000fe20000410000ULL,
0x3db504f31d1d7820ULL, 0x000fe20000410000ULL, 0x3db504f31e1e7820ULL, 0x000fe20000410000ULL,
0x3db504f31f1f7820ULL, 0x000fc40000410000ULL, 0x3db504f310107820ULL, 0x000fe20000410000ULL,
0x3db504f311117820ULL, 0x000fe20000410000ULL, 0x3db504f312127820ULL, 0x000fe20000410000ULL,
0x3db504f313137820ULL, 0x000fc60000410000ULL, 0x3db504f3081b7820ULL, 0x000fe20000410000ULL,
0x3db504f309207820ULL, 0x000fe20000410000ULL, 0x3db504f30a0a7820ULL, 0x000fe20000410000ULL,
0x3db504f30b0b7820ULL, 0x000fc60000410000ULL, 0x3db504f304217820ULL, 0x000fe20000410000ULL,
0x3db504f305227820ULL, 0x000fe20000410000ULL, 0x3db504f306087820ULL, 0x000fe20000410000ULL,
0x3db504f307097820ULL, 0x000fc60000410000ULL, 0x3db504f30c0c7820ULL, 0x000fe20000410000ULL,
0x3db504f30d0d7820ULL, 0x000fe20000410000ULL, 0x3db504f30e0e7820ULL, 0x000fe20000410000ULL,
0x3db504f30f0f7820ULL, 0x000fe20000410000ULL, 0x00000010009c8947ULL, 0x008fec0003800000ULL,
0x0234000902047984ULL, 0x0002a20008000c00ULL, 0x0000000e64007c0cULL, 0x000fda000bf05270ULL,
0x0000000400080947ULL, 0x002fea0003800000ULL, 0x0000000277237824ULL, 0x000fe200078e00ffULL,
0x800000070f077290ULL, 0x000fc8000fffe03fULL, 0x0000000623237812ULL, 0x000fc800078ec0ffULL,
0x0000000123247812ULL, 0x040fe400078efcffULL, 0x0000000823257812ULL, 0x040fe400078efcffULL,
0x0000000724007c0cULL, 0x000fe4000bf26070ULL, 0x0000001023247812ULL, 0x000fe400078efcffULL,
0x0000000725007c0cULL, 0x000fe4000bf06070ULL, 0x0000000724007c0cULL, 0x000fc4000bfc6070ULL,
0x0000001123257812ULL, 0x040fe400078efcffULL, 0x0000001823247812ULL, 0x040fe400078efcffULL,
0x0000000723007c0cULL, 0x000fe4000bf46070ULL, 0x0000000725007c0cULL, 0x000fe4000bfa6070ULL,
0x0000000724007c0cULL, 0x000fe4000bf66070ULL, 0x0000000923267812ULL, 0x000fc400078efcffULL,
0x0000001923257812ULL, 0x040fe400078efcffULL, 0x0000002023247812ULL, 0x000fe400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff03037808ULL, 0x000fe40005000000ULL,
0xff7fffff19197808ULL, 0x000fe40004800000ULL, 0xff7fffff18187808ULL, 0x000fc40004800000ULL,
0x0000000726007c0cULL, 0x000fe4000bf86070ULL, 0x0000000725007c0cULL, 0x000fe4000bf46070ULL,
0x0000000724007c0cULL, 0x000fe4000bf26070ULL, 0x0000002123257812ULL, 0x040fe400078efcffULL,
0x0000002823247812ULL, 0x000fe400078efcffULL, 0xff7fffff2e2e7808ULL, 0x000fc40004000000ULL,
0xff7fffff2c2c7808ULL, 0x000fe40004000000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40006000000ULL,
0xff7fffff2d2d7808ULL, 0x000fe40006000000ULL, 0x0000000725007c0cULL, 0x000fe4000bf06070ULL,
0x0000000724007c0cULL, 0x000fe4000bf86070ULL, 0x0000002923257812ULL, 0x000fc400078efcffULL,
0x0000003023247812ULL, 0x000fe400078efcffULL, 0xff7fffff1e1e7808ULL, 0x000fe40007000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40007000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40006800000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40006800000ULL, 0x0000000725007c0cULL, 0x000fc4000bfc6070ULL,
0x0000000724007c0cULL, 0x000fe4000bfa6070ULL, 0x0000003123257812ULL, 0x040fe400078efcffULL,
0x0000003823247812ULL, 0x040fe400078efcffULL, 0x0000003923237812ULL, 0x000fe400078efcffULL,
0xff7fffff16167808ULL, 0x000fe40005800000ULL, 0xff7fffff14147808ULL, 0x000fc40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0xff7fffff10107808ULL, 0x000fe40004800000ULL,
0x0000000725007c0cULL, 0x000fe4000bf66070ULL, 0x0000000724007c0cULL, 0x000fc4000bf46070ULL,
0x0000000723007c0cULL, 0x000fe4000bf26070ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff11117808ULL, 0x000fe40004000000ULL, 0xff7fffff0a0a7808ULL, 0x000fe40006000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40006000000ULL, 0xff7fffff0b0b7808ULL, 0x000fc40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40007000000ULL, 0xff7fffff08087808ULL, 0x000fe40006800000ULL,
0xff7fffff21217808ULL, 0x000fe40006800000ULL, 0xff7fffff09097808ULL, 0x000fe40005800000ULL,
0xff7fffff22227808ULL, 0x000fe40005800000ULL, 0xff7fffff0e0e7808ULL, 0x000fc40005000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40005000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40004800000ULL,
0xff7fffff0d0d7808ULL, 0x000fce0004800000ULL, 0x0000000304237209ULL, 0x004fe20007810000ULL,
0xffffffff00067882ULL, 0x000fe20000000000ULL, 0x0000001a05047209ULL, 0x000fe40007810000ULL,
0x0000001823237209ULL, 0x000fe40007810000ULL, 0x0000001904057209ULL, 0x000fe40007810000ULL,
0x0000002c23047209ULL, 0x000fe40007810000ULL, 0x0000002e05247209ULL, 0x000fc40007810000ULL,
0x0000002d04057209ULL, 0x000fe40007810000ULL, 0x0000002f24237209ULL, 0x000fe40007810000ULL,
0x0000001c05047209ULL, 0x000fe40007810000ULL, 0x0000001e23247209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x0000001f24237209ULL, 0x000fc40007810000ULL,
0x0000001405047209ULL, 0x000fe40007810000ULL, 0x0000001623247209ULL, 0x000fe40007810000ULL,
0x0000001504057209ULL, 0x000fe40007810000ULL, 0x0000001724237209ULL, 0x000fe40007810000ULL,
0x0000001005047209ULL, 0x000fe40007810000ULL, 0x0000001223247209ULL, 0x000fc40007810000ULL,
0x0000001104047209ULL, 0x000fe40007810000ULL, 0x0000001324057209ULL, 0x000fe40007810000ULL,
0x0000001b04237209ULL, 0x000fe40007810000ULL, 0x0000000a05047209ULL, 0x000fe40007810000ULL,
0x0000002023247209ULL, 0x000fe40007810000ULL, 0x0000000b04057209ULL, 0x000fc40007810000ULL,
0x0000002124237209ULL, 0x000fe40007810000ULL, 0x0000000805047209ULL, 0x000fe40007810000ULL,
0x0000002223237209ULL, 0x000fe40007810000ULL, 0x0000000904057209ULL, 0x000fe40007810000ULL,
0x000000ff70ff7812ULL, 0x000fe4000780c0ffULL, 0x0000000c23047209ULL, 0x000fc40007810000ULL,
0x0000000e05247209ULL, 0x000fe40007810000ULL, 0x00000001ff707807ULL, 0x000fe40000000000ULL,
0x0000000d04047209ULL, 0x000fe40007810000ULL, 0x0000000f24057209ULL, 0x000fe20007810000ULL,
0x0000000e06187947ULL, 0x000fec000b800000ULL, 0x0c401f0004237f89ULL, 0x000e6800000e0000ULL,
0x0c401f0005247f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006277f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007287f89ULL, 0x000f2200000e0000ULL, 0x0000002304257209ULL, 0x002fc40007810000ULL,
0x0000002405267209ULL, 0x004fc60007810000ULL, 0x0c201f00252a7f89ULL, 0x000e6200000e0000ULL,
0x0000002706277209ULL, 0x008fc60007810000ULL, 0x0c201f0026297f89ULL, 0x000ea200000e0000ULL,
0x0000002807237209ULL, 0x010fc60007810000ULL, 0x0c201f0027307f89ULL, 0x000ee800000e0000ULL,
0x0c201f0023247f89ULL, 0x00092200000e0000ULL, 0x0000002a25047209ULL, 0x002fe40007810000ULL,
0x0000002926057209ULL, 0x004fe40007810000ULL, 0x0000003027067209ULL, 0x008fce0007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b052b7820ULL, 0x000fc60000410000ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b03037823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2d2d7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b2f2f7823ULL, 0x000fe2000001082bULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010807ULL, 0x0000001000277308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0d077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b0f0f7823ULL, 0x000fc4000001082bULL,
0x0000001b00297308ULL, 0x000ff00000000800ULL, 0x0000000c002a7308ULL, 0x000ff00000000800ULL,
0x0000001a000d7308ULL, 0x000ff00000000800ULL, 0x0000001900107308ULL, 0x000e700000000800ULL,
0x0000002e001b7308ULL, 0x000fe20000000800ULL, 0x0000000d1019723eULL, 0x002fce00000000ffULL,
0x0000002f000c7308ULL, 0x000e620000000800ULL, 0x3c003c00000d7802ULL, 0x000fce0000000f00ULL,
0x0000000300037308ULL, 0x000fe20000000800ULL, 0x0000001b0c1b723eULL, 0x002fce00000000ffULL,
0x0000001800187308ULL, 0x000e620000000800ULL, 0x3c003c00ff0c7424ULL, 0x000fce00078e00ffULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x000000031818723eULL, 0x002fce00000000ffULL,
0x0000002d002d7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b16037823ULL, 0x000fce000001082bULL,
0x0000001100287308ULL, 0x000fe20000000800ULL, 0x0000002c2d1a723eULL, 0x002fce00000000ffULL,
0x0000001e00117308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b132c7823ULL, 0x000fce000001082bULL,
0x0000001400257308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b171e7823ULL, 0x002fce000001082bULL,
0x0000001500267308ULL, 0x0003f00000000800ULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000c1814723cULL, 0x002fe400000018ffULL,
0x0000001d001d7308ULL, 0x000e700000000800ULL, 0x0000001f00307308ULL, 0x0004e20000000800ULL,
0x0000001c1d10723eULL, 0x002fce00000000ffULL, 0x0000000300037308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b121f7823ULL, 0x104fe2000001082bULL, 0x000000252612723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b081d7823ULL, 0x100fe2000001082bULL, 0x000000272808723eULL, 0x000fe400000000ffULL,
0x000000113011723eULL, 0x008fe400000000ffULL, 0x0000001e001e7308ULL, 0x000e700000000800ULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x000000031e13723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b0b037823ULL, 0x000fcc000001082bULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b091e7823ULL, 0x000fe2000001082bULL, 0x0000000c1014723cULL, 0x000fec0000001814ULL,
0x0000002c002c7308ULL, 0x000e700000000800ULL, 0x0000000a001c7308ULL, 0x0005e20000000800ULL,
0x0000001f2c09723eULL, 0x002fce00000000ffULL, 0x0000000300037308ULL, 0x000e620000000800ULL,
0x00000029200a723eULL, 0x004fce00000000ffULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x0000001c030b723eULL, 0x002fce00000000ffULL, 0x0000002200227308ULL, 0x000e620000000800ULL,
0xfffffffc77037812ULL, 0x000fe200078ec0ffULL, 0x0000000c082c723cULL, 0x000fec0000001814ULL,
0x0000000700077308ULL, 0x000ea20000000800ULL, 0x000000212214723eULL, 0x002fce00000000ffULL,
0x0000001d001d7308ULL, 0x000fe20000000800ULL, 0x0000002a0716723eULL, 0x004fce00000000ffULL,
0x0000001e001e7308ULL, 0x000e620000000800ULL, 0x0000002423077209ULL, 0x010fce0007810000ULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000001d1e15723eULL, 0x002fce00000000ffULL,
0x0000000f000f7308ULL, 0x000e640000000800ULL, 0x0000000e0f17723eULL, 0x002fce00000000ffULL,
0x0000000c142c723cULL, 0x000fee000000182cULL, 0x0000000fff0c7424ULL, 0x000fca00078e00ffULL,
0x000000030c037219ULL, 0x000fd600000006ffULL, 0x001c1fff2c0c7589ULL, 0x00026200000e0000ULL,
0x00000000001c7806ULL, 0x000fe200038e0100ULL, 0x00000000030e73a1ULL, 0x000eb000000e8000ULL,
0x00000000030673c4ULL, 0x000ee20000004000ULL, 0x0000000000077886ULL, 0x000fc400038e0100ULL,
0x0000000703ff7c12ULL, 0x004fda000f80400eULL, 0x0000000a06308947ULL, 0x00afea000b800000ULL,
0x001c1fff2e0d7589ULL, 0x0002a800000e0000ULL, 0x001c1fff0e0e7589ULL, 0x000ee800000e0000ULL,
0x001c1fff000f7589ULL, 0x00032400000e0000ULL, 0xfffffff8ff547812ULL, 0x000fe200078ee254ULL,
0x0000000b14067291ULL, 0x000fe2000f8e583fULL, 0x00000003001f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff247224ULL, 0x000fe200078e0018ULL, 0x0000000377ff7812ULL, 0x000fe2000780c0ffULL,
0x00000008541c7836ULL, 0x040fe20000000000ULL, 0x000000041f217812ULL, 0x000fe200078efcffULL,
0x0000000854007824ULL, 0x002fe200078e00ffULL, 0x000000071f037812ULL, 0x000fe200078e7854ULL,
0x00000006ff207e24ULL, 0x000fe2000f8e00ffULL, 0x00000007211d7812ULL, 0x000fe200078e7854ULL,
0x000000081c1e7824ULL, 0x000fe200078e00ffULL, 0x000000071f1f7812ULL, 0x000fe200078e781cULL,
0x000000ffff257224ULL, 0x000fe200078e001aULL, 0x0000000721217812ULL, 0x000fe200078e781cULL,
0x00011000201c7836ULL, 0x000fe20000000000ULL, 0x0000000003037212ULL, 0x080fe200078efcffULL,
0x000000ffff267224ULL, 0x000fe200078e0010ULL, 0x000000001d1d7212ULL, 0x000fe200078efcffULL,
0x000000ffff277224ULL, 0x000fe200078e0012ULL, 0x0000001e1f1f7212ULL, 0x080fe200078efcffULL,
0x000000ffff287224ULL, 0x000fe200078e0008ULL, 0x0000001e21217212ULL, 0x000fe200078efcffULL,
0x000000ffff187224ULL, 0x000fe200078e0019ULL, 0x0000001c03037211ULL, 0x000fe200078e20ffULL,
0x000000101d1d7824ULL, 0x000fe200078e021cULL, 0x00000014002a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e000aULL, 0x000000ffff2b7224ULL, 0x000fe200078e0016ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000002403007844ULL, 0x0003e20000000200ULL,
0x000000ffff197224ULL, 0x000fe400078e001bULL, 0x000000ffff087224ULL, 0x000fe200078e0009ULL,
0x000000281d007844ULL, 0x0003e20000000200ULL, 0x000000101f1f7824ULL, 0x000fc400078e021cULL,
0x000000ffff1a7224ULL, 0x000fe400078e0011ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0013ULL,
0x000000ffff097224ULL, 0x000fe200078e000bULL, 0x00000017000b7202ULL, 0x000fe20000000f00ULL,
0x0000001021217824ULL, 0x000fe200078e021cULL, 0x000000181f007844ULL, 0x0003e20000000200ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0015ULL, 0x00000001ff007424ULL, 0x000fc400078e00ffULL,
0x00000008ff647e24ULL, 0x000fe2000f8e00ffULL, 0x0000000821007844ULL, 0x0003e20000000200ULL,
0x000000050800728cULL, 0x000fc6000bf06070ULL, 0x0230000402008988ULL, 0x0003e80008000c09ULL,
0x0232000c02008988ULL, 0x01c3e20008000c09ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x02360800ffff79a7ULL, 0x0003d80008500013ULL, 0xffffffb800d48947ULL, 0x002fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff197224ULL, 0x000fce00078e0018ULL,
0x02360819ff0075a7ULL, 0x0002620008000147ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x02360819ff0085a7ULL, 0x000e640008000047ULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff40006c7947ULL, 0x000fea000383ffffULL,
0x000000ffff037224ULL, 0x000fce00078e0002ULL, 0x02362803ff0075a7ULL, 0x0002620008000147ULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x02362803ff0085a7ULL, 0x000e640008000047ULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffff5800ec7947ULL, 0x000fea000383ffffULL, 0x023600ffff0075a7ULL, 0x000ea2000800014bULL,
0x0000a0000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x023600ffff0085a7ULL, 0x000e64000800004bULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffb800707947ULL, 0x00afea000383ffffULL, 0x000000ffff047224ULL, 0x100fe400078e0023ULL,
0x000000ffff057224ULL, 0x000fce00078e0023ULL, 0x02361005ff0075a7ULL, 0x0002620008000153ULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x02361005ff0085a7ULL, 0x000e640008000053ULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffec00447947ULL, 0x000fea000383ffffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x000fe400078e0004ULL, 0x00000002ff337424ULL, 0x000fe400078e00ffULL,
0x0000001fff347424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fce00078e00ffULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00003332317389ULL, 0x0006e40000000034ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff327224ULL, 0x002fe200078e0005ULL, 0x0000003100237202ULL, 0x004fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fe400078e00ffULL, 0x0000001fff347424ULL, 0x000fe200078e00ffULL,
0x0000002304257209ULL, 0x000fe20007810000ULL, 0xffffffffff2b7424ULL, 0x000fce00078e00ffULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00003332317389ULL, 0x0002640000000034ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000ffff327224ULL, 0x000fe400078e0006ULL,
0x000000ffff247224ULL, 0x000fce00078e0031ULL, 0x000000002b087348ULL, 0x000fea0003c00000ULL,
0x0c00003332317389ULL, 0x0002640000000034ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002405267209ULL, 0x000fe20007810000ULL, 0x000000ffff327224ULL, 0x000fe400078e0007ULL,
0x000000ffff277224ULL, 0x000fce00078e0031ULL, 0x000000002b087348ULL, 0x000fea0003c00000ULL,
0x0c00003332317389ULL, 0x0002640000000034ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002706277209ULL, 0x000fe40007810000ULL, 0x0000002500327202ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe400078e00ffULL, 0x000000ffff287224ULL, 0x000fce00078e0031ULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00003332317389ULL, 0x0002640000000034ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002807237209ULL, 0x000fe20007810000ULL,
0x000000ffff327224ULL, 0x000fe400078e0026ULL, 0x000000ffff2a7224ULL, 0x000fce00078e0031ULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00003332317389ULL, 0x0002640000000034ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002a25047209ULL, 0x000fe20007810000ULL,
0x000000ffff327224ULL, 0x000fe400078e0027ULL, 0x000000ffff297224ULL, 0x000fce00078e0031ULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00003332317389ULL, 0x0002640000000034ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002926057209ULL, 0x000fe20007810000ULL,
0x000000ffff327224ULL, 0x000fe400078e0023ULL, 0x000000ffff307224ULL, 0x000fce00078e0031ULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0c00003332317389ULL, 0x0002640000000034ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000003027067209ULL, 0x000fe20007810000ULL,
0x000000ffff247224ULL, 0x000fe200078e0031ULL, 0xfffffff000407947ULL, 0x000fec000383ffffULL,
0x0000007000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff1c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fce00078e0003ULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0000000f2e0f7389ULL, 0x0006e4000000001cULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0d7224ULL, 0x004fe400078e000fULL,
0x000000ffff2e7224ULL, 0x002fe400078e000eULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff1c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fce00078e0003ULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0000000f2e0f7389ULL, 0x0006e4000000001cULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x0000000f000e7202ULL, 0x004fe20000000f00ULL,
0x000000ffff2e7224ULL, 0x002fe400078e0000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff1c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fce00078e0003ULL,
0x000000002b087348ULL, 0x000fea0003c00000ULL, 0x0000000f2e0f7389ULL, 0x0006e4000000001cULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff400687947ULL, 0x006fea000383ffffULL, 0x018000004d007836ULL, 0x000fe20000000000ULL,
0x0000016000007945ULL, 0x000fe80003800000ULL, 0x7f80000000057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000004d00008308ULL, 0x0002a20000001000ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x008000000500780cULL, 0x040fe40003f22070ULL,
0x000000ff0500720cULL, 0x000fe40003f05070ULL, 0xffffffffff007807ULL, 0x004fe40004800000ULL,
0x00000001ff057807ULL, 0x000fc60000000000ULL, 0x000000ffff007224ULL, 0x000fca00078e0a00ULL,
0x0000000005ff7212ULL, 0x000fda000780fcffULL, 0x0000000000248947ULL, 0x000fea0003800000ULL,
0x007fffff4d007812ULL, 0x000fc800078ec0ffULL, 0x000000ff0000720cULL, 0x000fc80003f02070ULL,
0xffffffffff007807ULL, 0x000fca0004000000ULL, 0x000000ffff007224ULL, 0x000fca00078e0a00ULL,
0x0000000005ff7212ULL, 0x000fe4000780c0ffULL, 0x800000004d057812ULL, 0x000fd600078ec0ffULL,
0x0080000005000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0005ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000004d00007308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xffffff0004fc7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000023680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL, 0x0000000e00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000610ULL, 0x0000000000000048ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000658ULL, 0x000000000000039cULL, 0x0000000d00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f4ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000a18ULL, 0x0000000000000000ULL, 0x0000000d00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000a18ULL, 0x0000000000000030ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000a48ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000a90ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000a98ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000b00ULL, 0x000000000000fd00ULL, 0x0000000e00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000010800ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000010810ULL, 0x0000000000000400ULL, 0x0000000d00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000010810ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000010810ULL, 0x0000000000000260ULL, 0x0000000d00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000010ef0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000010ef0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000000a90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000000b00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000fd00ULL,
0x000000000000fd00ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000010800ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL, 0x0000000000000414ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000010810ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000260ULL, 0x0000000000000260ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_16_m_16_sm_90_cubin_len = 69696;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
