/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_16_m_16_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000011b90ULL, 0x0000000000011710ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x00000000000104e0ULL, 0x0000000000000190ULL, 0x000e002200000106ULL, 0x0000000000010670ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x00000000000106b0ULL, 0x00000000000000d0ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000010780ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000104e000000000ULL, 0x0000040400000000ULL, 0x810c000000780400ULL, 0x0040b00400288080ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x85082880809b0828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808085920000ULL, 0x0000000000000022ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x000104e000000000ULL, 0x0000019000000000ULL,
0x0000580400000000ULL, 0x8088288080860900ULL, 0x0900000004042880ULL, 0x2880808628808085ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8a08288080860828ULL, 0x2880809308288080ULL,
0x80aa082880809b08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080aa9200ULL,
0x0000001cffffffffULL, 0x0000010800000000ULL, 0x0001067000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x93082880808a0828ULL,
0x2880809b08288080ULL, 0x808208288080aa08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080829200ULL, 0x0000001cffffffffULL, 0x0000019000000000ULL, 0x000106b000000000ULL,
0x000000d000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x0008120400000071ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005001600000000dULL,
0x000c170400501903ULL, 0x0048000700000000ULL, 0x000c17040021f000ULL, 0x0040000600000000ULL,
0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0000f32000183104ULL, 0x0000f8700000f860ULL, 0x0000f9400000f930ULL,
0x00f829040000f950ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500002905000029ULL,
0x0500002905000029ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000b000f82804ULL, 0x00001330000000e0ULL, 0x0000221000002170ULL, 0x000022c000002290ULL,
0x000027d000002790ULL, 0x0000371000002aa0ULL, 0x00003830000037c0ULL, 0x00003c1000003870ULL,
0x00003ef000003c20ULL, 0x00004bd000004b20ULL, 0x00004c8000004c40ULL, 0x0000503000005020ULL,
0x00005f0000005300ULL, 0x0000601000005fa0ULL, 0x000063e000006040ULL, 0x00006830000063f0ULL,
0x0000948000006840ULL, 0x00009980000094a0ULL, 0x0000f1f0000099b0ULL, 0x0000f2300000f220ULL,
0x0000f2700000f240ULL, 0x0000f2a00000f290ULL, 0x0000f9200000f2b0ULL, 0x0000f9900000f980ULL,
0x0000ffe00000f9a0ULL, 0x000100b000010060ULL, 0x0001016000010110ULL, 0x00010200000101b0ULL,
0x000102a000010250ULL, 0x00010370000102f0ULL, 0x00010450000103f0ULL, 0x01703904000104b0ULL,
0x000000ff00000160ULL, 0x003f010000013600ULL, 0x0000000b000001a0ULL, 0x003f013000013608ULL,
0x0000000b000001c0ULL, 0x003f013000013610ULL, 0x000000ff000003f0ULL, 0x003f010700013600ULL,
0x0000000500000540ULL, 0x003f010200013614ULL, 0x00000005000005d0ULL, 0x003f010100013610ULL,
0x0000000800001ee0ULL, 0x003f01060001360cULL, 0x0000000800001f80ULL, 0x003f01060001360cULL,
0x0000000c00002a30ULL, 0x003f010100000000ULL, 0x00000008000035b0ULL, 0x003f01060001361cULL,
0x0000000800003660ULL, 0x003f01060001361cULL, 0x0000000c00003e80ULL, 0x003f010100000000ULL,
0x00000008000049a0ULL, 0x003f01060001362cULL, 0x0000000800004a70ULL, 0x003f01060001362cULL,
0x0000000c00005290ULL, 0x003f010100000000ULL, 0x0000000800005dc0ULL, 0x003f01060001363cULL,
0x0000000800005e70ULL, 0x003f01060001363cULL, 0x0000000800006620ULL, 0x003f010100013640ULL,
0x000000ff0000b330ULL, 0x003f010600013604ULL, 0x000000ff0000b3c0ULL, 0x003f010600013604ULL,
0x000000060000e700ULL, 0x003f010600013614ULL, 0x000000060000ead0ULL, 0x003f010600013614ULL,
0x000000060000ff20ULL, 0x003f010100013608ULL, 0x00141c0400033803ULL, 0x0000a7e00000a390ULL,
0x0000b4900000b410ULL, 0x000004010000ff80ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL,
0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000204ULL,
0x0000001100000002ULL, 0x000000000000017cULL, 0x0000001100000002ULL, 0x00000000000000dcULL,
0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001e1ULL,
0x0000001100000002ULL, 0x0000000000000159ULL, 0x0000001100000002ULL, 0x00000000000000b2ULL,
0x0000001100000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002300ULL,
0x00000004ff077424ULL, 0x000fe200078e00ffULL, 0x0000460000067ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x0000000000577919ULL, 0x000ea80000002100ULL,
0x00000000000c7919ULL, 0x000ee80000002700ULL, 0x0000000000647919ULL, 0x000f220000002600ULL,
0x0000000106007824ULL, 0x002fc800078e0203ULL, 0x00000080000b7824ULL, 0x104fe200078e0257ULL,
0x00000005ff577819ULL, 0x000fe20000011657ULL, 0x00001fff06007589ULL, 0x00066600000e0000ULL,
0x000000ff0b00720cULL, 0x040fe40003f05270ULL, 0x000000030b00780cULL, 0x040fe20003f24070ULL,
0x00001fff57577589ULL, 0x000ea200000e0000ULL, 0x0000007f0b00780cULL, 0x000fe20003f44070ULL,
0x000060000c067625ULL, 0x008fd000078e0007ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe200078e00ffULL, 0x3fffffe000049802ULL, 0x000fe20000000f00ULL,
0x7fffffe0ff059424ULL, 0x000fe400078e00ffULL, 0xff317217ff0aa424ULL, 0x000fe200078e00ffULL,
0x01360002ff008388ULL, 0x0007e20000000a00ULL, 0x000000ff0000720cULL, 0x002fe20003f05270ULL,
0x3fffff80ff089424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff099424ULL, 0x000fe200078e00ffULL,
0x013608040b009388ULL, 0x0007e8000000ca00ULL, 0x0134000a0b00a388ULL, 0x0007e80000004800ULL,
0x013610080b009388ULL, 0x0007e8000000ca00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000027000000947ULL, 0x000fea0003800000ULL, 0x00000000000d7919ULL, 0x014e620000000000ULL,
0x0000580000027a02ULL, 0x008fe20000000f00ULL, 0x0000000457047824ULL, 0x000fc400078e00ffULL,
0x0000001064037824ULL, 0x000fe400078e00ffULL, 0x0000001002027824ULL, 0x000fe400078e00ffULL,
0x00000100ff0e7424ULL, 0x000fe400078e00ffULL, 0x0000000c02027224ULL, 0x000fe200078e0203ULL,
0x000000040d097211ULL, 0x042fe200078fe0ffULL, 0x000000100d047824ULL, 0x000fc600078e00ffULL,
0x00000002090b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000902037210ULL, 0x040fe40007ffe0ffULL,
0x0000000709087812ULL, 0x000fe200078ec0ffULL, 0x0000000102057824ULL, 0x000fe200078e020bULL,
0x000000070b0a7812ULL, 0x000fe200078ec0ffULL, 0x00005c0003027625ULL, 0x080fe200078e000eULL,
0x000000f0040f7812ULL, 0x000fe400078ec0ffULL, 0x0000000f08087812ULL, 0x100fe200078e780dULL,
0x00005c0005047625ULL, 0x000fe200078e000eULL, 0x0000000f0a0a7812ULL, 0x000fc400078e780dULL,
0x0000000f02027210ULL, 0x080fe20007f1e0ffULL, 0x0000001009087824ULL, 0x000fe200078e0208ULL,
0x0000000f04047210ULL, 0x000fe20007f3e0ffULL, 0x000000100b0a7824ULL, 0x000fe400078e020aULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000000408097819ULL, 0x000fe200000006ffULL,
0x000000ffff057224ULL, 0x000fe400008e0605ULL, 0x000000100a0b7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000b901c46ULL,
0x00000000040b7faeULL, 0x0003e8000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01360000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000606567981ULL, 0x014ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000f220000002500ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x00000004ff597e24ULL, 0x010fe2000f8e00ffULL,
0x000000ff56547810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff547819ULL, 0x000fce0000011654ULL,
0x0000a32000008947ULL, 0x000fea0003800000ULL, 0x0000001057057824ULL, 0x00afe400078e00ffULL,
0x00000003ff007424ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136140005ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000159037810ULL, 0x000fe20007ffe0ffULL, 0x000000020c0b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011657ULL, 0x0136100005ff7f8cULL, 0x0005e2000c80043fULL,
0x000000540300720cULL, 0x000fe40003f06070ULL, 0x0000580064027a10ULL, 0x000fc40007ffe0ffULL,
0x000000050a007819ULL, 0x002fe400000006ffULL, 0x0000000157557812ULL, 0x000fe200078ec0ffULL,
0x000058000b0b7a24ULL, 0x000fe400078e0202ULL, 0x0000010059067824ULL, 0x000fc800078e0200ULL,
0x000062000b157a24ULL, 0x000fe200078e0206ULL, 0x000005d000008947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x004e620000000000ULL, 0x0000000656037217ULL, 0x000fe20007800000ULL,
0x000000020a197824ULL, 0x000fe200078e0255ULL, 0x0000000355177819ULL, 0x000fe200000006ffULL,
0x00000100ff227424ULL, 0x000fe400078e00ffULL, 0x0000000103037824ULL, 0x000fe200078e0a06ULL,
0x0000b00019197811ULL, 0x000fc800078e68ffULL, 0x0000002003037817ULL, 0x000fe40003800000ULL,
0x00000003ff047819ULL, 0x002fe40000011602ULL, 0x0ffffff802087812ULL, 0x000fe400078ec0ffULL,
0x0000000204077212ULL, 0x040fe200078e3cffULL, 0x0000000115067824ULL, 0x000fe200078e0204ULL,
0x000000030400720cULL, 0x000fe40003f06070ULL, 0x0000000708087812ULL, 0x000fe200078ef807ULL,
0x00005e0006067625ULL, 0x000fe200078e0022ULL, 0xfffffff817177812ULL, 0x000fc400078ee202ULL,
0x00000008040c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001008097824ULL, 0x000fe200078e0219ULL,
0x0000000404087810ULL, 0x040fe20007ffe0ffULL, 0x0000001017067825ULL, 0x000fe200078e0006ULL,
0x0000000c040d7810ULL, 0x040fe40007ffe0ffULL, 0x00000010040e7810ULL, 0x000fe20007ffe0ffULL,
0x000000080c0f7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c46ULL, 0x0000001404107810ULL, 0x040fe20007ffe0ffULL,
0x000000080d187824ULL, 0x000fe200078e00ffULL, 0x0000001804127810ULL, 0x000fe20007ffe0ffULL,
0x000000080e1a7824ULL, 0x000fe200078e00ffULL, 0x0000001c04147810ULL, 0x000fe20007ffe0ffULL,
0x00000008101c7824ULL, 0x000fe200078e00ffULL, 0x0000000208047212ULL, 0x080fe200078e3cffULL,
0x00000008121e7824ULL, 0x000fe200078e00ffULL, 0x000000030800720cULL, 0x080fe20003f06070ULL,
0x00000008141b7824ULL, 0x000fe200078e00ffULL, 0x000000030c00720cULL, 0x000fe20003f26070ULL,
0x0000000808097824ULL, 0x002fe200078e00ffULL, 0x000000020c067212ULL, 0x080fe200078e3cffULL,
0x0000000115117824ULL, 0x000fe200078e0210ULL, 0x000000020d077212ULL, 0x000fc400078e3cffULL,
0xfffffff80f167812ULL, 0x000fe200078ee206ULL, 0x0000000115067824ULL, 0x000fe200078e0208ULL,
0x000000030d00720cULL, 0x000fe20003f46070ULL, 0x00000001150d7824ULL, 0x000fe200078e020dULL,
0xfffffff809047812ULL, 0x000fe200078ee204ULL, 0x00000001150f7824ULL, 0x040fe200078e020eULL,
0xfffffff818187812ULL, 0x000fe400078ee207ULL, 0x0000000c15087210ULL, 0x000fe40007ffe0ffULL,
0x0000000210077212ULL, 0x000fc400078e3cffULL, 0x0000001215137210ULL, 0x040fe20007ffe0ffULL,
0x0000000115157824ULL, 0x000fe200078e0214ULL, 0x0000000212097212ULL, 0x080fe400078e3cffULL,
0x00000002140c7212ULL, 0x000fe400078e3cffULL, 0x000000030e00720cULL, 0x080fe40003f66070ULL,
0x000000031000720cULL, 0x080fe20003f86070ULL, 0x00005e0011107625ULL, 0x000fe200078e0022ULL,
0x000000031200720cULL, 0x000fc40003fa6070ULL, 0x000000031400720cULL, 0x000fe20003fc6070ULL,
0x00005e0013127625ULL, 0x000fe200078e0022ULL, 0x000000020e037212ULL, 0x000fe400078e3cffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee207ULL, 0x00005e0006067625ULL, 0x080fe200078e0022ULL,
0xfffffff81e1e7812ULL, 0x000fe400078ee209ULL, 0xfffffff81b207812ULL, 0x000fe200078ee20cULL,
0x00005e0008087625ULL, 0x000fe200078e0022ULL, 0xfffffff81a1a7812ULL, 0x000fc400078ee203ULL,
0x00000019181b7211ULL, 0x000fe200078e20ffULL, 0x00005e000d0c7625ULL, 0x000fc800078e0022ULL,
0x00005e000f0e7625ULL, 0x000fc800078e0022ULL, 0x00005e0015147625ULL, 0x000fc800078e0022ULL,
0x0000001017067825ULL, 0x000fc800078e0006ULL, 0x0000001017087825ULL, 0x000fc800078e0008ULL,
0x00000010170c7825ULL, 0x000fc800078e000cULL, 0x00000010170e7825ULL, 0x000fc800078e000eULL,
0x0000001017107825ULL, 0x000fc800078e0010ULL, 0x0000001017127825ULL, 0x000fc800078e0012ULL,
0x0000001017147825ULL, 0x000fc800078e0014ULL, 0x0000001004037824ULL, 0x100fe400078e0219ULL,
0x0000001016177824ULL, 0x100fe400078e0219ULL, 0x000000101a1d7824ULL, 0x100fe200078e0219ULL,
0x0000000006037faeULL, 0x0003e2000c101c46ULL, 0x000000101c1f7824ULL, 0x100fe400078e0219ULL,
0x000000101e217824ULL, 0x100fe200078e0219ULL, 0x0000000008177faeULL, 0x0003e2000c901c46ULL,
0x0000001020197824ULL, 0x000fc600078e0219ULL, 0x000000000c1b7faeULL, 0x0003e8000d101c46ULL,
0x000000000e1d7faeULL, 0x0003e8000d901c46ULL, 0x00000000101f7faeULL, 0x0003e8000e101c46ULL,
0x0000000012217faeULL, 0x0003e8000e901c46ULL, 0x0000000014197faeULL, 0x0003e2000f101c46ULL,
0x0000051000007947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x004e620000000000ULL,
0x0000000855197824ULL, 0x000fc400078e00ffULL, 0x00000100ff177424ULL, 0x000fe200078e00ffULL,
0x00000003ff037819ULL, 0x002fe40000011602ULL, 0x0ffffff802077812ULL, 0x000fe400078ec0ffULL,
0x0000000403087810ULL, 0x040fe40007ffe0ffULL, 0x0000000203047212ULL, 0x0c0fe400078e3cffULL,
0x0000000208067212ULL, 0x040fe200078e3cffULL, 0x00000008080f7824ULL, 0x000fe200078e00ffULL,
0x0000000c030d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000803097810ULL, 0x000fe40007ffe0ffULL,
0x0000000707047812ULL, 0x000fe200078ef804ULL, 0x00000001150e7824ULL, 0x000fe200078e020dULL,
0xfffffff80f187812ULL, 0x000fe200078ee206ULL, 0x000000080d0f7824ULL, 0x000fe200078e00ffULL,
0x0000000209077212ULL, 0x0c0fe200078e3cffULL, 0x000000020a067824ULL, 0x000fe200078e0255ULL,
0x00000003091a7819ULL, 0x000fe400000006ffULL, 0x000000020d0c7212ULL, 0x000fc400078e3cffULL,
0xfffffff81a1a7812ULL, 0x000fe400078ee207ULL, 0xfffffff80f1c7812ULL, 0x000fe200078ee20cULL,
0x00000001150c7824ULL, 0x000fe200078e0209ULL, 0x0000001003077810ULL, 0x000fe40007ffe0ffULL,
0x0000b000061b7811ULL, 0x000fe200078e68ffULL, 0x0000000115067824ULL, 0x000fe200078e0203ULL,
0x00000014030f7810ULL, 0x000fe20007ffe0ffULL, 0x00000008071e7824ULL, 0x000fe200078e00ffULL,
0x0000001803117810ULL, 0x000fe20007ffe0ffULL, 0x0000000115107824ULL, 0x000fe200078e0207ULL,
0x0000001c03037810ULL, 0x000fe20007ffe0ffULL, 0x0000000115127824ULL, 0x000fe200078e020fULL,
0x0000000207097212ULL, 0x080fe200078e3cffULL, 0x0000000115147824ULL, 0x000fe200078e0211ULL,
0x000000020f0d7212ULL, 0x080fe200078e3cffULL, 0x0000000811227824ULL, 0x000fe200078e00ffULL,
0x000000030f207819ULL, 0x000fe200000006ffULL, 0x0000000115167824ULL, 0x000fe200078e0203ULL,
0x00000002110f7212ULL, 0x080fe200078e3cffULL, 0x00005e0006067625ULL, 0x000fe200078e0017ULL,
0x0000000203117212ULL, 0x000fc400078e3cffULL, 0xfffffff819197812ULL, 0x000fe200078ee202ULL,
0x0000000803247824ULL, 0x000fe200078e00ffULL, 0x0000000815087210ULL, 0x000fe20007ffe0ffULL,
0x0000001004037824ULL, 0x000fe200078e021bULL, 0xfffffff81e047812ULL, 0x000fe200078ee209ULL,
0x0000001019067825ULL, 0x000fe200078e0006ULL, 0xfffffff8201e7812ULL, 0x000fe400078ee20dULL,
0xfffffff822207812ULL, 0x000fe200078ee20fULL, 0x00005e0008087625ULL, 0x080fe200078e0017ULL,
0xfffffff824227812ULL, 0x000fe200078ee211ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006037faeULL, 0x0003e4000b901c46ULL, 0x00005e000c0c7625ULL, 0x000fc800078e0017ULL,
0x00005e000e0e7625ULL, 0x000fc800078e0017ULL, 0x00005e0010107625ULL, 0x000fe200078e0017ULL,
0x0000001b18037211ULL, 0x002fc600078e20ffULL, 0x00005e0012127625ULL, 0x000fc800078e0017ULL,
0x00005e0014147625ULL, 0x000fc800078e0017ULL, 0x00005e0016167625ULL, 0x000fc800078e0017ULL,
0x0000001019087825ULL, 0x000fc800078e0008ULL, 0x00000010190c7825ULL, 0x040fe200078e000cULL,
0x0000000008037faeULL, 0x0003e6000b901c46ULL, 0x00000010190e7825ULL, 0x000fc800078e000eULL,
0x0000001019107825ULL, 0x000fc800078e0010ULL, 0x0000001019127825ULL, 0x000fc800078e0012ULL,
0x0000001019147825ULL, 0x000fc800078e0014ULL, 0x0000001019167825ULL, 0x000fc800078e0016ULL,
0x000000101a077824ULL, 0x100fe400078e021bULL, 0x000000101c197824ULL, 0x100fe400078e021bULL,
0x00000010041d7824ULL, 0x100fe200078e021bULL, 0x000000000c077faeULL, 0x0003e2000b901c46ULL,
0x000000101e1f7824ULL, 0x100fe400078e021bULL, 0x0000001020217824ULL, 0x000fe200078e021bULL,
0x0000001b221b7211ULL, 0x000fe200078e20ffULL, 0x000000000e197faeULL, 0x0003e8000b901c46ULL,
0x00000000101d7faeULL, 0x0003e8000b901c46ULL, 0x00000000121f7faeULL, 0x0003e8000b901c46ULL,
0x0000000014217faeULL, 0x0003e8000b901c46ULL, 0x00000000161b7faeULL, 0x0003e4000b901c46ULL,
0x000000545900720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff037424ULL, 0x002fe200078e00ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000542000000947ULL, 0x000fea0003800000ULL, 0xffffffc005057812ULL, 0x000fe200078ec0ffULL,
0xff317217ff037424ULL, 0x000fe200078e00ffULL, 0x00007610ff067816ULL, 0x000fe20000000006ULL,
0x000000ffff6d7224ULL, 0x000fc400078e00ffULL, 0x000000ffff137224ULL, 0x000fe400078e00ffULL,
0x0000000559077211ULL, 0x000fc800078e40ffULL, 0x000000560700720cULL, 0x000fda0003f06070ULL,
0x0000534000000947ULL, 0x000fea0003800000ULL, 0x0000000159077810ULL, 0x040fe20007ffe0ffULL,
0x00000100596b7824ULL, 0x000fe200078e0200ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000540700720cULL, 0x000fe20003f06070ULL, 0x000000ffff077224ULL, 0x000fe200078e006dULL,
0x000000406b0f7810ULL, 0x000fca0007ffe0ffULL, 0x000062000b0c7a24ULL, 0x000fcc00078e020fULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x000010006d0d7824ULL, 0x000fe200078e00ffULL,
0x0000000f56087217ULL, 0x000fe20007800000ULL, 0x000000020a0e7824ULL, 0x000fe200078e0255ULL,
0x00000003ff177819ULL, 0x100fe20000011602ULL, 0x00000100ff1f7424ULL, 0x000fe200078e00ffULL,
0x000010000d0d7812ULL, 0x000fe200078e0cffULL, 0x0000000108087824ULL, 0x000fe200078e0a0fULL,
0x00000003550f7819ULL, 0x000fe400000006ffULL, 0x00000008171d7810ULL, 0x000fe20007ffe0ffULL,
0x000020000e157824ULL, 0x000fe200078e000dULL, 0xfffffff80f0d7812ULL, 0x000fe200078ee202ULL,
0x00000001170e7824ULL, 0x000fe200078e020cULL, 0x0000002008147817ULL, 0x000fe20003800000ULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0x00000007170f7812ULL, 0x000fc400078e4802ULL,
0x000000141700720cULL, 0x000fe40003f06070ULL, 0x0ffffff80f197812ULL, 0x000fe200078ef802ULL,
0x00005e000e0e7625ULL, 0x000fe200078e001fULL, 0x0000b00015087810ULL, 0x000fe40007ffe0ffULL,
0x00000004171b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c17257810ULL, 0x000fe20007ffe0ffULL,
0x000000100d0e7825ULL, 0x000fe200078e000eULL, 0x000000021d187212ULL, 0x000fc400078e3cffULL,
0x0000001417297810ULL, 0x000fe20007ffe0ffULL, 0x0000001019157824ULL, 0x000fe200078e0208ULL,
0x0000001017197810ULL, 0x000fe20007ffe0ffULL, 0x000000081b217824ULL, 0x000fe200078e00ffULL,
0x00000018172b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000829227824ULL, 0x000fe200078e00ffULL,
0x000000021b167212ULL, 0x080fe200078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e157faeULL, 0x0003e2000c101c46ULL, 0x00000002251a7212ULL, 0x000fe200078e3cffULL,
0x000000012b1c7824ULL, 0x000fe200078e020cULL, 0x0000000325277819ULL, 0x000fc400000006ffULL,
0x0000001c17177810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823237812ULL, 0x000fe200078ee218ULL,
0x0000000119187824ULL, 0x140fe200078e020cULL, 0x000000141900720cULL, 0x000fe20003f66070ULL,
0x00000001171e7824ULL, 0x100fe200078e020cULL, 0x0000000319207819ULL, 0x000fe200000006ffULL,
0x000000011b0e7824ULL, 0x002fe200078e020cULL, 0x00000002190f7212ULL, 0x000fe400078e3cffULL,
0xfffffff821217812ULL, 0x000fe200078ee216ULL, 0x0000000125167824ULL, 0x000fe200078e020cULL,
0xfffffff827277812ULL, 0x000fe200078ee21aULL, 0x00000001291a7824ULL, 0x000fe200078e020cULL,
0x000000141b00720cULL, 0x000fc40003f06070ULL, 0x000000141d00720cULL, 0x080fe20003f26070ULL,
0x00005e001a1a7625ULL, 0x080fe200078e001fULL, 0x000000142500720cULL, 0x080fe40003f46070ULL,
0x000000142900720cULL, 0x080fe40003f86070ULL, 0x000000142b00720cULL, 0x080fe20003fa6070ULL,
0x000000100d1a7825ULL, 0x000fe200078e001aULL, 0x000000141700720cULL, 0x000fe40003fc6070ULL,
0x0000000229157212ULL, 0x080fe200078e3cffULL, 0x000000011d147824ULL, 0x000fe200078e020cULL,
0x0000000217197212ULL, 0x040fe200078e3cffULL, 0x00005e001c1c7625ULL, 0x000fe200078e001fULL,
0x0000000317247819ULL, 0x000fc400000006ffULL, 0xfffffff820257812ULL, 0x000fe200078ee20fULL,
0x00005e000e0e7625ULL, 0x080fe200078e001fULL, 0xfffffff822297812ULL, 0x000fe400078ee215ULL,
0xfffffff824497812ULL, 0x000fe200078ee219ULL, 0x00005e0014147625ULL, 0x000fe200078e001fULL,
0x000000022b0c7212ULL, 0x000fc600078e3cffULL, 0x00005e0016167625ULL, 0x000fc800078e001fULL,
0x00005e0018187625ULL, 0x000fc800078e001fULL, 0x00005e001e1e7625ULL, 0x000fc800078e001fULL,
0x000000082b2b7824ULL, 0x000fe400078e00ffULL, 0x000000100d0e7825ULL, 0x000fc600078e000eULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee20cULL, 0x000000100d147825ULL, 0x000fc800078e0014ULL,
0x000000100d167825ULL, 0x000fc800078e0016ULL, 0x000000100d187825ULL, 0x000fc800078e0018ULL,
0x000000100d1c7825ULL, 0x000fc800078e001cULL, 0x000000100d1e7825ULL, 0x000fc800078e001eULL,
0x00000010210d7824ULL, 0x100fe400078e0208ULL, 0x0000001023217824ULL, 0x100fe400078e0208ULL,
0x0000001027237824ULL, 0x100fe200078e0208ULL, 0x000000000e0d7faeULL, 0x0003e2000c101c46ULL,
0x0000001025257824ULL, 0x100fe400078e0208ULL, 0x0000001029277824ULL, 0x100fe200078e0208ULL,
0x000000082b297211ULL, 0x000fe200078e20ffULL, 0x00000010492b7824ULL, 0x000fe200078e0208ULL,
0x0000000014217faeULL, 0x0003e8000c901c46ULL, 0x0000000016237faeULL, 0x0003e8000d101c46ULL,
0x0000000018257faeULL, 0x0003e8000d901c46ULL, 0x000000001a277faeULL, 0x0003e8000e101c46ULL,
0x000000001c297faeULL, 0x0003e8000e901c46ULL, 0x000000001e2b7faeULL, 0x0003e2000f101c46ULL,
0x0000052000007947ULL, 0x000fea0003800000ULL, 0x00000003ff0d7819ULL, 0x000fe20000011602ULL,
0x000010006d0e7824ULL, 0x000fc400078e00ffULL, 0x000000020a087824ULL, 0x000fe200078e0255ULL,
0x000000040d157810ULL, 0x000fe40007ffe0ffULL, 0x000010000e0f7812ULL, 0x000fe400078e0cffULL,
0x0000000215147212ULL, 0x040fe200078e3cffULL, 0x0000000815197824ULL, 0x000fe200078e00ffULL,
0x000000100d1b7810ULL, 0x040fe20007ffe0ffULL, 0x00002000080e7824ULL, 0x000fe200078e000fULL,
0x000000080d177810ULL, 0x000fe40007ffe0ffULL, 0xfffffff819207812ULL, 0x000fe200078ee214ULL,
0x000000081b217824ULL, 0x000fe200078e00ffULL, 0x0000000c0d197810ULL, 0x000fe20007ffe0ffULL,
0x000000011b1a7824ULL, 0x000fe200078e020cULL, 0x000000140d1d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000217087212ULL, 0x080fe200078e3cffULL, 0x0000000819247824ULL, 0x000fe200078e00ffULL,
0x00000003171f7819ULL, 0x000fe200000006ffULL, 0x000000081d237824ULL, 0x000fe200078e00ffULL,
0x00000002190f7212ULL, 0x0c0fe200078e3cffULL, 0x0000000119187824ULL, 0x100fe200078e020cULL,
0x000000021b147212ULL, 0x080fe200078e3cffULL, 0x000000011d1c7824ULL, 0x040fe200078e020cULL,
0x000000021d167212ULL, 0x000fe400078e3cffULL, 0xfffffff81f227812ULL, 0x000fe200078ee208ULL,
0x00000100ff1f7424ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fc400078ee20fULL,
0xfffffff821267812ULL, 0x000fe200078ee214ULL, 0x0000000115147824ULL, 0x000fe200078e020cULL,
0x000000070d0f7812ULL, 0x040fe400078e4802ULL, 0x0000000c0d087210ULL, 0x040fe40007ffe0ffULL,
0x000000180d217810ULL, 0x040fe40007ffe0ffULL, 0x0000001c0d0d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823287812ULL, 0x000fe200078ee216ULL, 0x0000000855237824ULL, 0x000fe200078e00ffULL,
0x0000000221157212ULL, 0x040fe200078e3cffULL, 0x00000008212a7824ULL, 0x040fe200078e00ffULL,
0x0000000c211e7210ULL, 0x000fe20007ffe0ffULL, 0x0000000117167824ULL, 0x000fe200078e020cULL,
0x000000020d177212ULL, 0x040fe200078e3cffULL, 0x000000080d4a7824ULL, 0x000fe200078e00ffULL,
0xfffffff823217812ULL, 0x000fe200078ee202ULL, 0x000000010d487824ULL, 0x000fe200078e020cULL,
0x0000b0000e237810ULL, 0x000fe20007ffe0ffULL, 0x00005e00080c7625ULL, 0x000fe200078e001fULL,
0x0ffffff80f087812ULL, 0x000fc400078ef802ULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee215ULL,
0x00005e00140e7625ULL, 0x000fe200078e001fULL, 0xfffffff84a4a7812ULL, 0x000fe400078ee217ULL,
0x0000002320257211ULL, 0x000fe200078e20ffULL, 0x00005e0016147625ULL, 0x000fe200078e001fULL,
0x000000232a4b7211ULL, 0x000fc600078e20ffULL, 0x00005e0018167625ULL, 0x000fc800078e001fULL,
0x00005e001a187625ULL, 0x000fc800078e001fULL, 0x00005e001c1a7625ULL, 0x000fc800078e001fULL,
0x00005e001e1c7625ULL, 0x000fc800078e001fULL, 0x00005e00481e7625ULL, 0x000fc800078e001fULL,
0x00000010210c7825ULL, 0x000fc800078e000cULL, 0x00000010210e7825ULL, 0x000fc800078e000eULL,
0x0000001021147825ULL, 0x000fc800078e0014ULL, 0x0000001021167825ULL, 0x000fc800078e0016ULL,
0x0000001021187825ULL, 0x000fc800078e0018ULL, 0x00000010211a7825ULL, 0x000fc800078e001aULL,
0x00000010211c7825ULL, 0x000fc800078e001cULL, 0x00000010211e7825ULL, 0x000fc800078e001eULL,
0x0000001008217824ULL, 0x100fe400078e0223ULL, 0x0000001022277824ULL, 0x100fe400078e0223ULL,
0x0000001024297824ULL, 0x100fe200078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c217faeULL, 0x0003e2000b901c46ULL, 0x00000010262b7824ULL, 0x100fe400078e0223ULL,
0x0000001028497824ULL, 0x100fe200078e0223ULL, 0x000000000e257faeULL, 0x0003e2000b901c46ULL,
0x000000104a237824ULL, 0x000fc600078e0223ULL, 0x0000000014277faeULL, 0x0003e8000b901c46ULL,
0x0000000016297faeULL, 0x0003e8000b901c46ULL, 0x00000000182b7faeULL, 0x0003e8000b901c46ULL,
0x000000001a497faeULL, 0x0003e8000b901c46ULL, 0x000000001c4b7faeULL, 0x0003e8000b901c46ULL,
0x000000001e237faeULL, 0x0003e4000b901c46ULL, 0x0000000457087824ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000ffff060c7812ULL, 0x002fc600078ec0ffULL,
0xfffffff008087812ULL, 0x000fe400078ec0ffULL, 0x000088800c637816ULL, 0x000fc600000000ffULL,
0x01360c00080d7984ULL, 0x000e640000000800ULL, 0x80000000630c7824ULL, 0x000fca00078e00ffULL,
0x800000000dff7812ULL, 0x002fe2000780480cULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000001f630e7819ULL, 0x000fc600000006ffULL, 0x0000000c000d7305ULL, 0x0002a4000021f000ULL,
0x3fa000000c0c7823ULL, 0x002fe200000100ffULL, 0x0000000d0000735dULL, 0x004fe40003800000ULL,
0x01360c00080d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000780480eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000001002687824ULL, 0x040fe200078e00ffULL, 0x00000001ff667819ULL, 0x000fe20000011602ULL,
0x0000002057677824ULL, 0x000fe200078e00ffULL, 0x0000000802167812ULL, 0x000fe200078ec0ffULL,
0x000000040a0d7824ULL, 0x000fe200078e00ffULL, 0x0000007068687812ULL, 0x000fe200078ec0ffULL,
0x00000001ff0e7424ULL, 0x000fe200078e00ffULL, 0xffffff8067677812ULL, 0x000fc400078ec0ffULL,
0x0000000c66667812ULL, 0x000fe400078ec0ffULL, 0x000000040d0f7812ULL, 0x000fe400078ec0ffULL,
0x00000067666e7210ULL, 0x000fe40007ffe068ULL, 0x0000000702657812ULL, 0x000fe400078ec0ffULL,
0x00000004ff147819ULL, 0x000fe20000011602ULL, 0x013000006e0c7984ULL, 0x000e620000000800ULL,
0x0000000716177812ULL, 0x000fc400078ec865ULL, 0x0000000214187810ULL, 0x040fe20007ffe0ffULL,
0x013200006e6e7984ULL, 0x000ea20000000800ULL, 0x00000004145a7810ULL, 0x040fe40007ffe0ffULL,
0x0000000614587810ULL, 0x000fe40007ffe0ffULL, 0x00000018175b7212ULL, 0x000fe400078e3cffULL,
0x0000000865157812ULL, 0x000fe400078ef802ULL, 0x0000005a175a7212ULL, 0x000fc400078e3cffULL,
0x0000005817587212ULL, 0x040fe400078e3cffULL, 0x00000014175c7212ULL, 0x000fe400078e3cffULL,
0x000000020f1a7810ULL, 0x000fe40007ffe014ULL, 0x0000000f02187211ULL, 0x000fe400078fe0ffULL,
0x000000030c00720bULL, 0x002fda0003f1d000ULL, 0x00000000000d7806ULL, 0x000fc800000e0100ULL,
0x0000ffff0d197812ULL, 0x000fda000780c0ffULL, 0x0000038000008947ULL, 0x000fea0003800000ULL,
0x000000030c00720bULL, 0x004fe40003f14000ULL, 0x0000000c031e7209ULL, 0x040fe40007810000ULL,
0x00000002ff0f7819ULL, 0x000fe40000011602ULL, 0x00000002ff0e7819ULL, 0x000fe20000011657ULL,
0x8000001e030d7221ULL, 0x000fe20000010000ULL, 0x000000080f147810ULL, 0x000fc60007ffe0ffULL,
0x3fb8aa3b0d0d7820ULL, 0x000fe40000410000ULL, 0x0000000000037806ULL, 0x000fe400000e0100ULL,
0x000000570e00720cULL, 0x000fe40003f05270ULL, 0x0000ffff031c7812ULL, 0x000fe200078e3cffULL,
0x0000000d000d7308ULL, 0x000e660000000800ULL, 0x0000001c19ff7212ULL, 0x000fc8000782c0ffULL,
0x00000001ff0e7807ULL, 0x000fc60000800000ULL, 0x0000006857038211ULL, 0x000fca00078e38ffULL,
0x0000000166038824ULL, 0x000fe200078e0203ULL, 0x00001f140d147589ULL, 0x002e6200000e0000ULL,
0x8000001e0c0c1221ULL, 0x000fe20000010000ULL, 0x0000000d04047220ULL, 0x000fe40000410000ULL,
0x00001f0f0d0f7589ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b0c0c1820ULL, 0x000fc60000410000ULL,
0x0134001e03008388ULL, 0x0007e20000000800ULL, 0x0000000c00091308ULL, 0x000f220000000800ULL,
0x000000ffff037224ULL, 0x008fe200078e001eULL, 0x0000001413137220ULL, 0x082fe20000410000ULL,
0x0000001412127220ULL, 0x080fe20000410000ULL, 0x000000142f2f7220ULL, 0x080fe20000410000ULL,
0x000000142e2e7220ULL, 0x080fe20000410000ULL, 0x0000001433337220ULL, 0x080fe20000410000ULL,
0x0000001432327220ULL, 0x080fe20000410000ULL, 0x0000001437377220ULL, 0x080fe20000410000ULL,
0x0000001436367220ULL, 0x080fe20000410000ULL, 0x000000143b3b7220ULL, 0x080fe20000410000ULL,
0x000000143a3a7220ULL, 0x080fe20000410000ULL, 0x000000143f3f7220ULL, 0x080fe20000410000ULL,
0x000000143e3e7220ULL, 0x080fe20000410000ULL, 0x0000001443437220ULL, 0x080fe20000410000ULL,
0x0000001442427220ULL, 0x080fe20000410000ULL, 0x0000001447477220ULL, 0x080fe20000410000ULL,
0x0000001446467220ULL, 0x000fe20000410000ULL, 0x0000000f11117220ULL, 0x084fe20000410000ULL,
0x0000000f10107220ULL, 0x080fe20000410000ULL, 0x0000000f2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000f2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000f31317220ULL, 0x080fe20000410000ULL,
0x0000000f30307220ULL, 0x080fe20000410000ULL, 0x0000000f35357220ULL, 0x080fe20000410000ULL,
0x0000000f34347220ULL, 0x080fe20000410000ULL, 0x0000000f39397220ULL, 0x080fe20000410000ULL,
0x0000000f38387220ULL, 0x080fe20000410000ULL, 0x0000000f3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000f3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000f41417220ULL, 0x080fe20000410000ULL,
0x0000000f40407220ULL, 0x080fe20000410000ULL, 0x0000000f45457220ULL, 0x080fe20000410000ULL,
0x0000000f44447220ULL, 0x000fe20000410000ULL, 0x000000096e6e1220ULL, 0x010fe20000410000ULL,
0x000000020a6a7824ULL, 0x004fe200078e0255ULL, 0x0000000718187812ULL, 0x000fe200078e7815ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000009570d7819ULL, 0x000fe200000006ffULL,
0x000020006a6a7824ULL, 0x000fe200078e00ffULL, 0x00000065160f7212ULL, 0x000fe200078efcffULL,
0x0000000815187824ULL, 0x000fe200078e0218ULL, 0xfffff8000d0d7812ULL, 0x000fe200078ec0ffULL,
0x000010006d147824ULL, 0x000fe200078e026aULL, 0x0000005c0f627211ULL, 0x040fe200078e18ffULL,
0x000000080f5f7824ULL, 0x040fe200078e0258ULL, 0x00000009ff0c723eULL, 0x000fe200000000ffULL,
0x0000001018647824ULL, 0x000fe200078e020dULL, 0x0000b00014177810ULL, 0x000fe20007ffe0ffULL,
0x000000080f617824ULL, 0x040fe200078e025bULL, 0x00000002ff697819ULL, 0x000fe20000011602ULL,
0x000000080f607824ULL, 0x000fe200078e025aULL, 0x009000006424783bULL, 0x000fe20000000200ULL,
0x000000105f287824ULL, 0x100fe200078e0217ULL, 0x00000017614c7211ULL, 0x000fe200078e20ffULL,
0x0000001062507824ULL, 0x000fe200078e0217ULL, 0x000000071a1a7812ULL, 0x000fe200078e7815ULL,
0x0000001060487824ULL, 0x000fe200078e0217ULL, 0x000054100c1e7816ULL, 0x000fe2000000000cULL,
0x000000002828783bULL, 0x000fe20000004200ULL, 0x00000008695d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008151a7824ULL, 0x000fe200078e021aULL, 0x000000800f157811ULL, 0x000fe200078e18ffULL,
0x000000005050783bULL, 0x000fe20000004200ULL, 0x000099100e0c7816ULL, 0x000fe200000000ffULL,
0x000000101a5e7824ULL, 0x000fe200078e020dULL, 0x000000155b5b7210ULL, 0x000fe20007ffe0ffULL,
0x000000004c4c783bULL, 0x000fe20000004200ULL, 0x0000000158587824ULL, 0x100fe200078e0215ULL,
0x000000ff0c00720cULL, 0x000fe20003f05270ULL, 0x000000015a5a7824ULL, 0x100fe200078e0215ULL,
0x000000004848783bULL, 0x000fe20000004200ULL, 0x000000015c5c7824ULL, 0x000fc400078e0215ULL,
0x0000001058147824ULL, 0x100fe200078e0217ULL, 0x00001f691e697589ULL, 0x000e6200000e0000ULL,
0x000000105c207824ULL, 0x100fe200078e0217ULL, 0x000000175a187211ULL, 0x000fe200078e20ffULL,
0x000000105b1c7824ULL, 0x000fe200078e0217ULL, 0x00001f5d1e6c7589ULL, 0x000ea800000e0000ULL,
0x009000005e0c783bULL, 0x000ee80000000200ULL, 0x000000001414783bULL, 0x000f280000004200ULL,
0x000000002020783bULL, 0x000f680000004200ULL, 0x000000001c1c783bULL, 0x000f280000004200ULL,
0x000000001818783bULL, 0x000f220000004200ULL, 0x0000006924248232ULL, 0x002fc40000000000ULL,
0x0000006926268232ULL, 0x000fe40000000000ULL, 0x0000006c25258232ULL, 0x084fe40000000000ULL,
0x0000006c27278232ULL, 0x000fce0000000000ULL, 0x00000028242c723cULL, 0x040ff0000000182cULL,
0x000000502444723cULL, 0x000fe20000001844ULL, 0x000000690c0c8232ULL, 0x088fe40000000000ULL,
0x000000690e0e8232ULL, 0x000fc40000000000ULL, 0x0000006c0d0d8232ULL, 0x000fc60000000000ULL,
0x000000522440723cULL, 0x000fe20000001840ULL, 0x0000006c0f0f8232ULL, 0x000fce0000000000ULL,
0x0000004c243c723cULL, 0x040ff0000000183cULL, 0x0000004e2438723cULL, 0x040ff00000001838ULL,
0x000000482434723cULL, 0x040ff00000001834ULL, 0x0000004a2430723cULL, 0x040ff00000001830ULL,
0x0000002a2410723cULL, 0x000ff00000001810ULL, 0x000000140c2c723cULL, 0x050fee000000182cULL,
0x00000002ff147819ULL, 0x000fe20000011657ULL, 0x000000200c44723cULL, 0x060ff00000001844ULL,
0x000000220c40723cULL, 0x040ff00000001840ULL, 0x0000001c0c3c723cULL, 0x040ff0000000183cULL,
0x0000001e0c38723cULL, 0x040ff00000001838ULL, 0x000000180c34723cULL, 0x040ff00000001834ULL,
0x0000001a0c30723cULL, 0x040ff00000001830ULL, 0x000000160c10723cULL, 0x000fee0000001810ULL,
0x00013610140c7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000004590d7824ULL, 0x000fe200078e0214ULL, 0x000000000cff7f8cULL, 0x0003e2000c80043fULL,
0x000000046e047221ULL, 0x000fe20000010000ULL, 0x000000016d6d7812ULL, 0x000fc400078e0cffULL,
0x000000400d0d7811ULL, 0x000fc800078e30ffULL, 0x000000560d00720cULL, 0x000fda0003f06070ULL,
0x00003bc000000947ULL, 0x000fea0003800000ULL, 0x00000001590d7810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000540d00720cULL, 0x000fe40003f06070ULL,
0x000000806b147810ULL, 0x000fca0007ffe0ffULL, 0x000062000b0e7a24ULL, 0x000fcc00078e0214ULL,
0x000005c000008947ULL, 0x000fea0003800000ULL, 0x00000014560d7217ULL, 0x000fe20007800000ULL,
0x00001000070c7824ULL, 0x000fe200078e00ffULL, 0x00000003ff197819ULL, 0x000fe20000011602ULL,
0x0000000855167824ULL, 0x000fe200078e00ffULL, 0x0000000d140d7210ULL, 0x000fe20007ffe1ffULL,
0x00000100ff207424ULL, 0x000fe200078e00ffULL, 0x000010000c177812ULL, 0x000fe200078ec0ffULL,
0x0000000119157824ULL, 0x000fe200078e020eULL, 0x000000200d0f7817ULL, 0x000fe40003800000ULL,
0x00000007191b7812ULL, 0x000fe200078e4802ULL, 0x00005e00150c7625ULL, 0x000fe200078e0020ULL,
0x0000000f1900720cULL, 0x000fc40003f06070ULL, 0xfffffff8161f7812ULL, 0x000fe400078ee265ULL,
0x0000b0006a1e7810ULL, 0x000fe40007ffe017ULL, 0x0ffffff81b1b7812ULL, 0x000fe200078ef802ULL,
0x000000101f0c7825ULL, 0x000fe200078e000cULL, 0x00000004191d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000819277810ULL, 0x000fe20007ffe0ffULL, 0x000000101b157824ULL, 0x000fe200078e021eULL,
0x0000000c19297810ULL, 0x000fe20007ffe0ffULL, 0x000000081d147824ULL, 0x000fe200078e00ffULL,
0x00000010192b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000827167824ULL, 0x000fe200078e00ffULL,
0x0000001419497810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c157faeULL, 0x0003e2000c101c46ULL, 0x00000018194b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000127177824ULL, 0x100fe200078e020eULL, 0x0000001c194d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001291b7824ULL, 0x100fe200078e020eULL, 0x000000021d217212ULL, 0x080fe200078e3cffULL,
0x0000000149197824ULL, 0x000fe200078e020eULL, 0x0000000227257212ULL, 0x000fe200078e3cffULL,
0x00005e001b1a7625ULL, 0x000fe200078e0020ULL, 0x0000000f1d00720cULL, 0x000fc40003f06070ULL,
0x0000000f2700720cULL, 0x080fe20003f26070ULL, 0x000000082b277824ULL, 0x000fe200078e00ffULL,
0x0000000f2900720cULL, 0x080fe20003f46070ULL, 0x000000014b157824ULL, 0x002fe200078e020eULL,
0x0000000f2b00720cULL, 0x080fe20003f66070ULL, 0x000000101f1a7825ULL, 0x000fe200078e001aULL,
0x0000000f4900720cULL, 0x080fe40003f86070ULL, 0x0000000f4b00720cULL, 0x080fe40003fa6070ULL,
0x0000000f4d00720cULL, 0x000fe20003fc6070ULL, 0x000000011d0f7824ULL, 0x000fe200078e020eULL,
0x0000000229237212ULL, 0x000fc400078e3cffULL, 0x0000000329187819ULL, 0x000fe200000006ffULL,
0x0000000849297824ULL, 0x000fe200078e00ffULL, 0xfffffff814217812ULL, 0x000fe400078ee221ULL,
0x0000000e2b1d7210ULL, 0x040fe40007ffe0ffULL, 0x000000022b0c7212ULL, 0x080fe200078e3cffULL,
0x000000084b2b7824ULL, 0x000fe200078e00ffULL, 0x0000000249147212ULL, 0x000fe200078e3cffULL,
0x000000084d497824ULL, 0x040fe200078e00ffULL, 0x0000000e4d0d7210ULL, 0x000fe20007ffe0ffULL,
0x00005e001d1c7625ULL, 0x000fe200078e0020ULL, 0xfffffff816257812ULL, 0x000fc400078ee225ULL,
0x000000024b0e7212ULL, 0x080fe200078e3cffULL, 0x0000001021217824ULL, 0x100fe200078e021eULL,
0x000000024d167212ULL, 0x000fe200078e3cffULL, 0x0000001025257824ULL, 0x000fe200078e021eULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee20eULL, 0x00005e000f0e7625ULL, 0x080fe200078e0020ULL,
0xfffffff849497812ULL, 0x000fe400078ee216ULL, 0xfffffff818237812ULL, 0x000fe200078ee223ULL,
0x00005e0017167625ULL, 0x000fe200078e0020ULL, 0xfffffff827277812ULL, 0x000fc400078ee20cULL,
0xfffffff829297812ULL, 0x000fe200078ee214ULL, 0x00005e0019187625ULL, 0x000fe200078e0020ULL,
0x0000001e23237211ULL, 0x000fc600078e20ffULL, 0x00005e0015147625ULL, 0x000fc800078e0020ULL,
0x00005e000d0c7625ULL, 0x000fc800078e0020ULL, 0x000000101f0e7825ULL, 0x000fc800078e000eULL,
0x000000101f167825ULL, 0x040fe200078e0016ULL, 0x000000000e217faeULL, 0x0003e6000c101c46ULL,
0x000000101f1c7825ULL, 0x040fe200078e001cULL, 0x0000000016257faeULL, 0x0003e6000c901c46ULL,
0x000000101f187825ULL, 0x040fe200078e0018ULL, 0x000000001a237faeULL, 0x0003e6000d101c46ULL,
0x000000101f147825ULL, 0x000fc800078e0014ULL, 0x000000101f0c7825ULL, 0x000fc800078e000cULL,
0x00000010271f7824ULL, 0x100fe400078e021eULL, 0x0000001029277824ULL, 0x100fe400078e021eULL,
0x000000102b297824ULL, 0x100fe200078e021eULL, 0x000000001c1f7faeULL, 0x0003e2000d901c46ULL,
0x00000010492b7824ULL, 0x000fc600078e021eULL, 0x0000000018277faeULL, 0x0003e8000e101c46ULL,
0x0000000014297faeULL, 0x0003e8000e901c46ULL, 0x000000000c2b7faeULL, 0x0003e2000f101c46ULL,
0x0000050000007947ULL, 0x000fea0003800000ULL, 0x00000003ff0d7819ULL, 0x000fe20000011602ULL,
0x00001000070c7824ULL, 0x000fe200078e00ffULL, 0x0000010000277802ULL, 0x000fe20000000f00ULL,
0x0000000855147824ULL, 0x000fe200078e00ffULL, 0x000000080d177810ULL, 0x000fc40007ffe0ffULL,
0x000000040d157810ULL, 0x040fe40007ffe0ffULL, 0x0000000c0d197810ULL, 0x000fe20007ffe0ffULL,
0x00000008171b7824ULL, 0x040fe200078e00ffULL, 0x0000000217227212ULL, 0x0c0fe200078e3cffULL,
0x0000000117187824ULL, 0x100fe200078e020eULL, 0x0000000215207212ULL, 0x000fe200078e3cffULL,
0x0000000819167824ULL, 0x000fe200078e00ffULL, 0x00000003150f7819ULL, 0x000fe200000006ffULL,
0x00000001191a7824ULL, 0x000fe200078e020eULL, 0xfffffff81b227812ULL, 0x000fc400078ee222ULL,
0xfffffff80f207812ULL, 0x000fe400078ee220ULL, 0x0000000219217212ULL, 0x000fe400078e3cffULL,
0x000000100d1b7810ULL, 0x040fe40007ffe0ffULL, 0x000000140d1d7810ULL, 0x040fe40007ffe0ffULL,
0x000000180d1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000081b247824ULL, 0x000fe200078e00ffULL,
0x000010000c237812ULL, 0x000fe200078ec0ffULL, 0x000000010d0c7824ULL, 0x040fe200078e020eULL,
0x000000070d0f7812ULL, 0x000fe200078e4802ULL, 0x000000011d267824ULL, 0x100fe200078e020eULL,
0x0000001c0d297810ULL, 0x000fe20007ffe0ffULL, 0x000000011f2a7824ULL, 0x100fe200078e020eULL,
0xfffffff816217812ULL, 0x000fe200078ee221ULL, 0x0000000115167824ULL, 0x000fe200078e020eULL,
0xfffffff814257812ULL, 0x000fe200078ee265ULL, 0x000000081f197824ULL, 0x000fe200078e00ffULL,
0x0ffffff80f147812ULL, 0x000fe200078ef802ULL, 0x00005e000c0c7625ULL, 0x000fe200078e0027ULL,
0x0000000e1b1c7210ULL, 0x000fc40007ffe0ffULL, 0x0000000e294a7210ULL, 0x040fe20007ffe0ffULL,
0x00000008294c7824ULL, 0x000fe200078e00ffULL, 0x000000021b0f7212ULL, 0x080fe200078e3cffULL,
0x000000081d287824ULL, 0x000fe200078e00ffULL, 0x000000021f0e7212ULL, 0x080fe200078e3cffULL,
0x00000010251e7825ULL, 0x000fe200078e000cULL, 0x0000b0006a237810ULL, 0x000fe40007ffe023ULL,
0x0000000229177212ULL, 0x080fe200078e3cffULL, 0x00005e001a1a7625ULL, 0x000fe200078e0027ULL,
0x000000021d157212ULL, 0x000fc400078e3cffULL, 0xfffffff824247812ULL, 0x000fe200078ee20fULL,
0x0000001014297824ULL, 0x000fe200078e0223ULL, 0xfffffff819487812ULL, 0x000fe200078ee20eULL,
0x00005e00160e7625ULL, 0x080fe200078e0027ULL, 0xfffffff84c4c7812ULL, 0x000fe400078ee217ULL,
0xfffffff828287812ULL, 0x000fe200078ee215ULL, 0x00005e0018167625ULL, 0x080fe200078e0027ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e297faeULL, 0x0003e6000b901c46ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0027ULL, 0x00005e0026187625ULL, 0x000fc800078e0027ULL,
0x00005e002a147625ULL, 0x000fc800078e0027ULL, 0x00005e004a0c7625ULL, 0x000fc800078e0027ULL,
0x00000010250e7825ULL, 0x000fc800078e000eULL, 0x0000001025167825ULL, 0x000fc800078e0016ULL,
0x00000010251a7825ULL, 0x000fc800078e001aULL, 0x00000010251c7825ULL, 0x000fc800078e001cULL,
0x0000001025187825ULL, 0x000fc800078e0018ULL, 0x0000001025147825ULL, 0x000fc800078e0014ULL,
0x00000010250c7825ULL, 0x000fe200078e000cULL, 0x0000002322257211ULL, 0x000fc600078e20ffULL,
0x00000010201f7824ULL, 0x102fe400078e0223ULL, 0x0000001021217824ULL, 0x100fe400078e0223ULL,
0x0000001024277824ULL, 0x100fe200078e0223ULL, 0x000000000e1f7faeULL, 0x0003e2000b901c46ULL,
0x0000001028297824ULL, 0x100fe400078e0223ULL, 0x00000010482b7824ULL, 0x000fe200078e0223ULL,
0x000000234c237211ULL, 0x000fe200078e20ffULL, 0x0000000016257faeULL, 0x0003e8000b901c46ULL,
0x000000001a217faeULL, 0x0003e8000b901c46ULL, 0x000000001c277faeULL, 0x0003e8000b901c46ULL,
0x0000000018297faeULL, 0x0003e8000b901c46ULL, 0x00000000142b7faeULL, 0x0003e8000b901c46ULL,
0x000000000c237faeULL, 0x0003e4000b901c46ULL, 0x01361c00080c7984ULL, 0x002e620000000800ULL,
0x80000000630d7824ULL, 0x000fc600078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x800000000cff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff0c7424ULL, 0x000fe400078e00ffULL,
0x80000000630e7824ULL, 0x000fe400078e00ffULL, 0x0000000c000d7305ULL, 0x0002a4000021f000ULL,
0x3fa000000c0c7823ULL, 0x002fe200000100ffULL, 0x0000000d0000735dULL, 0x004fe40003800000ULL,
0x01361c00080d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fc4000780480eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000080680d7810ULL, 0x000fe20007ffe067ULL, 0x0000100007697824ULL, 0x000fc800078e00ffULL,
0x00000001660d7824ULL, 0x000fe200078e020dULL, 0x0000100069697812ULL, 0x000fc800078e0cffULL,
0x013000000d0c7984ULL, 0x000e680000000800ULL, 0x013200000d6e7984ULL, 0x0004e20000000800ULL,
0x000000030c00720bULL, 0x002fda0003f1d000ULL, 0x00000000000e7806ULL, 0x000fc800000e0100ULL,
0x0000ffff0e157812ULL, 0x000fe4000780c0ffULL, 0x00000001000e7802ULL, 0x000fd60000000f00ULL,
0x0000038000008947ULL, 0x000fea0003800000ULL, 0x000000030c00720bULL, 0x00cfe40003f14000ULL,
0x0000000c030f7209ULL, 0x080fe40007810000ULL, 0x00000001570e7811ULL, 0x000fe400078ff0ffULL,
0x00000002ff197819ULL, 0x000fe20000011602ULL, 0x8000000f030d7221ULL, 0x040fe20000010000ULL,
0x0000000c03037209ULL, 0x000fc60007810000ULL, 0x3fb8aa3b0d147820ULL, 0x000fe40000410000ULL,
0x00000000000d7806ULL, 0x000fe400000e0100ULL, 0x000000570e00720cULL, 0x000fe40003f05270ULL,
0x0000001400147308ULL, 0x000e620000000800ULL, 0x0000ffff0d167812ULL, 0x000fc800078e3cffULL,
0x0000001615ff7212ULL, 0x000fcc000782c0ffULL, 0x0000008057178824ULL, 0x000fc800078e0268ULL,
0x0000000166168824ULL, 0x000fe200078e0217ULL, 0x00001f5d140e7589ULL, 0x002e6200000e0000ULL,
0x0000001404047220ULL, 0x000fe20000410000ULL, 0x8000000f0c151221ULL, 0x000fe20000010000ULL,
0x00000001ff0c7807ULL, 0x000fe20000800000ULL, 0x00001f19140d7589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b15151820ULL, 0x000fe40000410000ULL, 0x0134000f16008388ULL, 0x0007e40000000800ULL,
0x0000001500091308ULL, 0x000f220000000800ULL, 0x0000000e46467220ULL, 0x082fe20000410000ULL,
0x0000000e47477220ULL, 0x080fe20000410000ULL, 0x0000000e42427220ULL, 0x080fe20000410000ULL,
0x0000000e43437220ULL, 0x080fe20000410000ULL, 0x0000000e3e3e7220ULL, 0x080fe20000410000ULL,
0x0000000e3f3f7220ULL, 0x080fe20000410000ULL, 0x0000000e3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000e3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000e36367220ULL, 0x080fe20000410000ULL,
0x0000000e37377220ULL, 0x080fe20000410000ULL, 0x0000000e32327220ULL, 0x080fe20000410000ULL,
0x0000000e33337220ULL, 0x080fe20000410000ULL, 0x0000000e2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000e2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000e12127220ULL, 0x080fe20000410000ULL,
0x0000000e13137220ULL, 0x000fe20000410000ULL, 0x0000000d44447220ULL, 0x084fe20000410000ULL,
0x0000000d45457220ULL, 0x080fe20000410000ULL, 0x0000000d40407220ULL, 0x080fe20000410000ULL,
0x0000000d41417220ULL, 0x080fe20000410000ULL, 0x0000000d3c3c7220ULL, 0x080fe20000410000ULL,
0x0000000d3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000d38387220ULL, 0x080fe20000410000ULL,
0x0000000d39397220ULL, 0x080fe20000410000ULL, 0x0000000d34347220ULL, 0x080fe20000410000ULL,
0x0000000d35357220ULL, 0x080fe20000410000ULL, 0x0000000d30307220ULL, 0x080fe20000410000ULL,
0x0000000d31317220ULL, 0x080fe20000410000ULL, 0x0000000d2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000d2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000d10107220ULL, 0x080fe20000410000ULL,
0x0000000d11117220ULL, 0x000fe20000410000ULL, 0x000076100c0e7816ULL, 0x000fe2000000000eULL,
0x0000006e096e1220ULL, 0x010fe20000410000ULL, 0x0000b0006a697810ULL, 0x00cfe20007ffe069ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x009800006424783bULL, 0x000fe20000000200ULL,
0x000000105f287824ULL, 0x100fe200078e0269ULL, 0x00000069614c7211ULL, 0x000fe200078e20ffULL,
0x0000001062507824ULL, 0x100fe200078e0269ULL, 0x00000009ff0c723eULL, 0x000fe200000000ffULL,
0x0000001060487824ULL, 0x100fe200078e0269ULL, 0x00000002ff6d7819ULL, 0x000fe20000011602ULL,
0x000000002828783bULL, 0x000fe20000004200ULL, 0x000054100c167816ULL, 0x000fe2000000000cULL,
0x000000105c207824ULL, 0x100fe200078e0269ULL, 0x000099100e147816ULL, 0x000fe200000000ffULL,
0x000000005050783bULL, 0x000fe20000004200ULL, 0x000000105b1c7824ULL, 0x000fe200078e0269ULL,
0x000000695a187211ULL, 0x000fc400078e20ffULL, 0x000000004c4c783bULL, 0x000fe20000004200ULL,
0x000000ff1400720cULL, 0x000fe20003f05270ULL, 0x0000001058147824ULL, 0x000fe400078e0269ULL,
0x000000004848783bULL, 0x000fe80000004200ULL, 0x00001f6d166d7589ULL, 0x000e6800000e0000ULL,
0x00001f5d166c7589ULL, 0x000ea800000e0000ULL, 0x009800005e0c783bULL, 0x000ee80000000200ULL,
0x000000001414783bULL, 0x000f280000004200ULL, 0x000000002020783bULL, 0x000f680000004200ULL,
0x000000001c1c783bULL, 0x000f280000004200ULL, 0x000000001818783bULL, 0x000f220000004200ULL,
0x0000006d24248232ULL, 0x002fc40000000000ULL, 0x0000006d26268232ULL, 0x000fe40000000000ULL,
0x0000006c25258232ULL, 0x084fe40000000000ULL, 0x0000006c27278232ULL, 0x000fce0000000000ULL,
0x00000028242c723cULL, 0x040ff0000000182cULL, 0x000000502444723cULL, 0x000fe20000001844ULL,
0x0000006d0c0c8232ULL, 0x088fe40000000000ULL, 0x0000006d0e0e8232ULL, 0x000fc40000000000ULL,
0x0000006c0d0d8232ULL, 0x000fc60000000000ULL, 0x000000522440723cULL, 0x000fe20000001840ULL,
0x0000006c0f0f8232ULL, 0x000fce0000000000ULL, 0x0000004c243c723cULL, 0x040ff0000000183cULL,
0x0000004e2438723cULL, 0x040ff00000001838ULL, 0x000000482434723cULL, 0x040ff00000001834ULL,
0x0000004a2430723cULL, 0x040ff00000001830ULL, 0x0000002a2410723cULL, 0x000ff00000001810ULL,
0x000000140c2c723cULL, 0x050fee000000182cULL, 0x00000002ff147819ULL, 0x000fe20000011657ULL,
0x000000200c44723cULL, 0x060ff00000001844ULL, 0x000000220c40723cULL, 0x040ff00000001840ULL,
0x0000001c0c3c723cULL, 0x040ff0000000183cULL, 0x0000001e0c38723cULL, 0x040ff00000001838ULL,
0x000000180c34723cULL, 0x040ff00000001834ULL, 0x0000001a0c30723cULL, 0x040ff00000001830ULL,
0x000000160c10723cULL, 0x000fee0000001810ULL, 0x00013620140c7811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000004590d7824ULL, 0x000fe200078e0214ULL,
0x000000000cff7f8cULL, 0x0003e2000c80043fULL, 0x000000046e047221ULL, 0x000fe20000010000ULL,
0x00000001076d7812ULL, 0x000fc400078ec0ffULL, 0x000000800d0d7811ULL, 0x000fc800078e30ffULL,
0x000000560d00720cULL, 0x000fda0003f06070ULL, 0x0000277000000947ULL, 0x000fea0003800000ULL,
0x00000001590d7810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000540d00720cULL, 0x000fe40003f06070ULL, 0x000000c06b6b7810ULL, 0x000fca0007ffe0ffULL,
0x000062000b0e7a24ULL, 0x000fcc00078e026bULL, 0x0000059000008947ULL, 0x000fea0003800000ULL,
0x0000006b560c7217ULL, 0x000fe20007800000ULL, 0x0000000855147824ULL, 0x000fe200078e00ffULL,
0x00000003ff177819ULL, 0x000fe40000011602ULL, 0x0000010000207802ULL, 0x000fe20000000f00ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a6bULL, 0x0000000417197810ULL, 0x040fe20007ffe0ffULL,
0x00000001170d7824ULL, 0x040fe200078e020eULL, 0x00000008171b7810ULL, 0x000fe40007ffe0ffULL,
0x000000200c0f7817ULL, 0x000fe20003800000ULL, 0x00005e000d0c7625ULL, 0x000fe200078e0020ULL,
0x0000000c171d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000717157812ULL, 0x100fe200078e4802ULL,
0x0000000819217824ULL, 0x000fe200078e00ffULL, 0x0000000f1700720cULL, 0x000fe20003f06070ULL,
0x000000081b237824ULL, 0x000fe200078e00ffULL, 0xfffffff8141f7812ULL, 0x000fe200078ee265ULL,
0x000000081d257824ULL, 0x000fe200078e00ffULL, 0x0ffffff815147812ULL, 0x000fe400078ef802ULL,
0x0000000219167212ULL, 0x080fe200078e3cffULL, 0x000000101f0c7825ULL, 0x000fe200078e000cULL,
0x000000021b187212ULL, 0x000fc400078e3cffULL, 0x000000021d1e7212ULL, 0x000fe400078e3cffULL,
0x0000006914157211ULL, 0x000fe400078e20ffULL, 0xfffffff821227812ULL, 0x000fe400078ee216ULL,
0xfffffff823247812ULL, 0x000fe200078ee218ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c157faeULL, 0x0003e2000c101c46ULL, 0xfffffff8251e7812ULL, 0x000fe400078ee21eULL,
0x0000001017217810ULL, 0x000fc40007ffe0ffULL, 0x0000001417237810ULL, 0x040fe40007ffe0ffULL,
0x0000001817257810ULL, 0x040fe40007ffe0ffULL, 0x0000001c17277810ULL, 0x000fe20007ffe0ffULL,
0x000000011b177824ULL, 0x100fe200078e020eULL, 0x0000000f1900720cULL, 0x080fe20003f06070ULL,
0x0000000125157824ULL, 0x102fe200078e020eULL, 0x0000000f1b00720cULL, 0x080fe20003f26070ULL,
0x000000011d1b7824ULL, 0x140fe200078e020eULL, 0x0000000f1d00720cULL, 0x080fe20003f46070ULL,
0x00000001211d7824ULL, 0x140fe200078e020eULL, 0x0000000f2100720cULL, 0x080fe20003f66070ULL,
0x00000001270d7824ULL, 0x000fe200078e020eULL, 0x0000000f2300720cULL, 0x080fe20003f86070ULL,
0x00005e001b1a7625ULL, 0x000fe200078e0020ULL, 0x0000000f2500720cULL, 0x000fc40003fa6070ULL,
0x0000000f2700720cULL, 0x000fe20003fc6070ULL, 0x00000001190f7824ULL, 0x100fe200078e020eULL,
0x0000000223147212ULL, 0x0c0fe200078e3cffULL, 0x0000000123197824ULL, 0x000fe200078e020eULL,
0x00000002250e7212ULL, 0x080fe200078e3cffULL, 0x0000000823237824ULL, 0x000fe200078e00ffULL,
0x0000000227167212ULL, 0x0c0fe200078e3cffULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x00000002210c7212ULL, 0x000fe200078e3cffULL, 0x00005e001d1c7625ULL, 0x000fe200078e0020ULL,
0x0000000325257819ULL, 0x000fc400000006ffULL, 0x0000000321217819ULL, 0x000fe200000006ffULL,
0x00005e0019187625ULL, 0x080fe200078e0020ULL, 0xfffffff8252a7812ULL, 0x000fe400078ee20eULL,
0xfffffff821267812ULL, 0x000fe200078ee20cULL, 0x00005e000f0e7625ULL, 0x080fe200078e0020ULL,
0xfffffff823287812ULL, 0x000fe400078ee214ULL, 0xfffffff827487812ULL, 0x000fe200078ee216ULL,
0x00005e0017167625ULL, 0x000fe200078e0020ULL, 0x0000006926257211ULL, 0x000fc600078e20ffULL,
0x00005e0015147625ULL, 0x000fc800078e0020ULL, 0x00005e000d0c7625ULL, 0x000fc800078e0020ULL,
0x0000001022217824ULL, 0x000fe400078e0269ULL, 0x000000101f0e7825ULL, 0x000fc800078e000eULL,
0x0000001024237824ULL, 0x000fe200078e0269ULL, 0x000000000e217faeULL, 0x0003e2000c101c46ULL,
0x000000101f167825ULL, 0x000fc800078e0016ULL, 0x000000101f1a7825ULL, 0x040fe200078e001aULL,
0x0000000016237faeULL, 0x0003e6000c901c46ULL, 0x000000101f1c7825ULL, 0x000fc800078e001cULL,
0x000000101f187825ULL, 0x000fc800078e0018ULL, 0x000000101f147825ULL, 0x000fc800078e0014ULL,
0x000000101f0c7825ULL, 0x000fc800078e000cULL, 0x000000101e1f7824ULL, 0x100fe400078e0269ULL,
0x0000001028277824ULL, 0x100fe400078e0269ULL, 0x000000102a297824ULL, 0x100fe200078e0269ULL,
0x000000001a1f7faeULL, 0x0003e2000d101c46ULL, 0x00000010482b7824ULL, 0x000fc600078e0269ULL,
0x000000001c257faeULL, 0x0003e8000d901c46ULL, 0x0000000018277faeULL, 0x0003e8000e101c46ULL,
0x0000000014297faeULL, 0x0003e8000e901c46ULL, 0x000000000c2b7faeULL, 0x0003e2000f101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x00000003ff0d7819ULL, 0x000fe20000011602ULL,
0x00000008550c7824ULL, 0x000fc400078e00ffULL, 0x00000100ff237424ULL, 0x000fe200078e00ffULL,
0x000000040d157810ULL, 0x040fe40007ffe0ffULL, 0x0000000c0d197810ULL, 0x040fe40007ffe0ffULL,
0x000000080d177810ULL, 0x000fe20007ffe0ffULL, 0x00000008150f7824ULL, 0x040fe200078e00ffULL,
0x0000000215247212ULL, 0x080fe200078e3cffULL, 0x00000008191d7824ULL, 0x000fe200078e00ffULL,
0x0000000217227212ULL, 0x080fe200078e3cffULL, 0x00000001191a7824ULL, 0x100fe200078e020eULL,
0x00000003171b7819ULL, 0x040fe200000006ffULL, 0x0000000117187824ULL, 0x000fe200078e020eULL,
0x0000000219207212ULL, 0x000fc400078e3cffULL, 0xfffffff81b227812ULL, 0x000fe400078ee222ULL,
0xfffffff80f247812ULL, 0x000fe400078ee224ULL, 0xfffffff81d207812ULL, 0x000fe200078ee220ULL,
0x0000001022277824ULL, 0x000fe200078e0269ULL, 0x000000100d1b7810ULL, 0x040fe40007ffe0ffULL,
0x000000180d1f7810ULL, 0x040fe40007ffe0ffULL, 0x0000001c0d257810ULL, 0x000fe20007ffe0ffULL,
0x000000011b1c7824ULL, 0x100fe200078e020eULL, 0xfffffff80c217812ULL, 0x000fe200078ee265ULL,
0x000000010d0c7824ULL, 0x040fe200078e020eULL, 0x000000070d0f7812ULL, 0x000fe200078e4802ULL,
0x000000081b267824ULL, 0x000fe200078e00ffULL, 0x000000140d1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000011f487824ULL, 0x000fe200078e020eULL, 0x0ffffff80f147812ULL, 0x000fe200078ef802ULL,
0x00000001254c7824ULL, 0x000fe200078e020eULL, 0x0000000e15167210ULL, 0x080fe20007ffe0ffULL,
0x000000081f197824ULL, 0x000fe200078e00ffULL, 0x0000000e1d287210ULL, 0x000fe20007ffe0ffULL,
0x00005e000c0c7625ULL, 0x000fe200078e0023ULL, 0x000000021b0f7212ULL, 0x000fc400078e3cffULL,
0x000000021f0e7212ULL, 0x080fe200078e3cffULL, 0x000000081d2a7824ULL, 0x000fe200078e00ffULL,
0x0000000225177212ULL, 0x080fe200078e3cffULL, 0x00000010211e7825ULL, 0x000fe200078e000cULL,
0x00000003254e7819ULL, 0x000fe400000006ffULL, 0x000000021d157212ULL, 0x000fe200078e3cffULL,
0x0000001014257824ULL, 0x000fe200078e0269ULL, 0xfffffff826267812ULL, 0x000fe200078ee20fULL,
0x00005e001a1a7625ULL, 0x000fe200078e0023ULL, 0xfffffff8194a7812ULL, 0x000fc400078ee20eULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee217ULL, 0x00005e00160e7625ULL, 0x080fe200078e0023ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e257faeULL, 0x0003e4000b901c46ULL, 0x00005e0018167625ULL, 0x000fc800078e0023ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0023ULL, 0x00005e0028187625ULL, 0x000fc800078e0023ULL,
0x00005e0048147625ULL, 0x000fc800078e0023ULL, 0x00005e004c0c7625ULL, 0x000fc800078e0023ULL,
0x0000001024237824ULL, 0x000fe400078e0269ULL, 0x00000010210e7825ULL, 0x000fc800078e000eULL,
0x0000001021167825ULL, 0x040fe200078e0016ULL, 0x000000000e237faeULL, 0x0005e6000b901c46ULL,
0x00000010211a7825ULL, 0x040fe200078e001aULL, 0x0000000016277faeULL, 0x0005e6000b901c46ULL,
0x00000010211c7825ULL, 0x000fc800078e001cULL, 0x0000001021187825ULL, 0x000fc800078e0018ULL,
0x0000001021147825ULL, 0x000fc800078e0014ULL, 0x00000010210c7825ULL, 0x000fe200078e000cULL,
0x0000006926217211ULL, 0x000fc600078e20ffULL, 0x00000010201f7824ULL, 0x102fe400078e0269ULL,
0x000000102a257824ULL, 0x100fe400078e0269ULL, 0x000000104a297824ULL, 0x100fe200078e0269ULL,
0x000000001a1f7faeULL, 0x0005e2000b901c46ULL, 0x000000104e2b7824ULL, 0x000fc600078e0269ULL,
0x000000001c217faeULL, 0x0005e8000b901c46ULL, 0x0000000018257faeULL, 0x0005e8000b901c46ULL,
0x0000000014297faeULL, 0x0005e8000b901c46ULL, 0x000000000c2b7faeULL, 0x0005e4000b901c46ULL,
0x01362c00080c7984ULL, 0x006e620000000800ULL, 0x80000000630d7824ULL, 0x000fc600078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x800000000cff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000b000000947ULL, 0x000fea0003800000ULL,
0x0000000257087819ULL, 0x000fe200000006ffULL, 0x3e000000ff0c7424ULL, 0x000fe400078e00ffULL,
0x80000000630e7824ULL, 0x000fe200078e00ffULL, 0xfffffff008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c000d7305ULL, 0x0002a4000021f000ULL, 0x3fa000000c0c7823ULL, 0x002fe200000100ffULL,
0x0000000d0000735dULL, 0x004fe40003800000ULL, 0x01362c00080d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fc4000780480eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000100680d7810ULL, 0x000fe40007ffe067ULL,
0x0000000c070f7819ULL, 0x000fc600000006ffULL, 0x00000001660d7824ULL, 0x000fe200078e020dULL,
0x000010000f6b7812ULL, 0x000fc800078ec0ffULL, 0x013000000d0c7984ULL, 0x000e680000000800ULL,
0x013200000d6c7984ULL, 0x0004e20000000800ULL, 0x000000030c00720bULL, 0x002fda0003f1d000ULL,
0x00000000000e7806ULL, 0x000fc800000e0100ULL, 0x0000ffff0e157812ULL, 0x000fe2000780c0ffULL,
0x00000001ff0e7424ULL, 0x000fd800078e00ffULL, 0x0000038000008947ULL, 0x000fea0003800000ULL,
0x000000030c00720bULL, 0x00cfe40003f14000ULL, 0x0000000c030f7209ULL, 0x080fe40007810000ULL,
0x00000002570e7811ULL, 0x000fe400078ff0ffULL, 0x00000002ff197819ULL, 0x000fe20000011602ULL,
0x8000000f030d7221ULL, 0x040fe20000010000ULL, 0x0000000c03037209ULL, 0x000fc60007810000ULL,
0x3fb8aa3b0d147820ULL, 0x000fe40000410000ULL, 0x00000000000d7806ULL, 0x000fe400000e0100ULL,
0x000000570e00720cULL, 0x000fe40003f05270ULL, 0x0000001400147308ULL, 0x000e620000000800ULL,
0x0000ffff0d167812ULL, 0x000fc800078e3cffULL, 0x0000001615ff7212ULL, 0x000fcc000782c0ffULL,
0x0000008057178824ULL, 0x000fc800078e0268ULL, 0x0000000166168824ULL, 0x000fe200078e0217ULL,
0x00001f5d140e7589ULL, 0x002e6200000e0000ULL, 0x0000001404047220ULL, 0x000fe20000410000ULL,
0x8000000f0c151221ULL, 0x000fe20000010000ULL, 0x00000001ff0c7807ULL, 0x000fe20000800000ULL,
0x00001f19140d7589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b15151820ULL, 0x000fe40000410000ULL,
0x0134000f16008388ULL, 0x0007e40000000800ULL, 0x0000001500091308ULL, 0x000f220000000800ULL,
0x0000000e46467220ULL, 0x082fe20000410000ULL, 0x0000000e47477220ULL, 0x080fe20000410000ULL,
0x0000000e42427220ULL, 0x080fe20000410000ULL, 0x0000000e43437220ULL, 0x080fe20000410000ULL,
0x0000000e3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000e3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000e3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000e3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000e36367220ULL, 0x080fe20000410000ULL, 0x0000000e37377220ULL, 0x080fe20000410000ULL,
0x0000000e32327220ULL, 0x080fe20000410000ULL, 0x0000000e33337220ULL, 0x080fe20000410000ULL,
0x0000000e2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000e2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000e12127220ULL, 0x080fe20000410000ULL, 0x0000000e13137220ULL, 0x000fe20000410000ULL,
0x0000000d44447220ULL, 0x084fe20000410000ULL, 0x0000000d45457220ULL, 0x080fe20000410000ULL,
0x0000000d40407220ULL, 0x080fe20000410000ULL, 0x0000000d41417220ULL, 0x080fe20000410000ULL,
0x0000000d3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000d3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000d38387220ULL, 0x080fe20000410000ULL, 0x0000000d39397220ULL, 0x080fe20000410000ULL,
0x0000000d34347220ULL, 0x080fe20000410000ULL, 0x0000000d35357220ULL, 0x080fe20000410000ULL,
0x0000000d30307220ULL, 0x080fe20000410000ULL, 0x0000000d31317220ULL, 0x080fe20000410000ULL,
0x0000000d2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000d10107220ULL, 0x080fe20000410000ULL, 0x0000000d11117220ULL, 0x000fe20000410000ULL,
0x000076100c0e7816ULL, 0x000fe2000000000eULL, 0x0000006c096c1220ULL, 0x010fe20000410000ULL,
0x0000b0006a6b7810ULL, 0x00cfe20007ffe06bULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00a000006424783bULL, 0x000fe20000000200ULL, 0x000000105f287824ULL, 0x100fe200078e026bULL,
0x0000006b60487211ULL, 0x000fe200078e20ffULL, 0x0000001062507824ULL, 0x100fe200078e026bULL,
0x00000009ff0c723eULL, 0x000fe200000000ffULL, 0x00000010614c7824ULL, 0x100fe200078e026bULL,
0x00000002ff6d7819ULL, 0x000fe20000011602ULL, 0x000000002828783bULL, 0x000fe20000004200ULL,
0x000054100c167816ULL, 0x000fe2000000000cULL, 0x000000105c207824ULL, 0x100fe200078e026bULL,
0x000099100e147816ULL, 0x000fe200000000ffULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x000000105b1c7824ULL, 0x000fc400078e026bULL, 0x000000ff1400720cULL, 0x000fe20003f05270ULL,
0x000000004c4c783bULL, 0x000fe20000004200ULL, 0x0000006b58147211ULL, 0x000fe200078e20ffULL,
0x000000105a187824ULL, 0x000fe400078e026bULL, 0x000000004848783bULL, 0x000fe80000004200ULL,
0x00001f6d166d7589ULL, 0x000e6800000e0000ULL, 0x00001f5d166a7589ULL, 0x000ea800000e0000ULL,
0x00a000005e0c783bULL, 0x000ee80000000200ULL, 0x000000001414783bULL, 0x000f280000004200ULL,
0x000000002020783bULL, 0x000f680000004200ULL, 0x000000001c1c783bULL, 0x000f280000004200ULL,
0x000000001818783bULL, 0x000f220000004200ULL, 0x0000006d24248232ULL, 0x002fc40000000000ULL,
0x0000006d26268232ULL, 0x000fe40000000000ULL, 0x0000006a25258232ULL, 0x084fe40000000000ULL,
0x0000006a27278232ULL, 0x000fce0000000000ULL, 0x00000028242c723cULL, 0x040ff0000000182cULL,
0x000000502444723cULL, 0x000fe20000001844ULL, 0x0000006d0c0c8232ULL, 0x088fe40000000000ULL,
0x0000006d0e0e8232ULL, 0x000fc40000000000ULL, 0x0000006a0d0d8232ULL, 0x000fc60000000000ULL,
0x000000522440723cULL, 0x000fe20000001840ULL, 0x0000006a0f0f8232ULL, 0x000fce0000000000ULL,
0x0000004c243c723cULL, 0x040ff0000000183cULL, 0x0000004e2438723cULL, 0x040ff00000001838ULL,
0x000000482434723cULL, 0x040ff00000001834ULL, 0x0000004a2430723cULL, 0x040ff00000001830ULL,
0x0000002a2410723cULL, 0x000ff00000001810ULL, 0x000000140c2c723cULL, 0x050fee000000182cULL,
0x00000002ff147819ULL, 0x000fe20000011657ULL, 0x000000200c44723cULL, 0x060ff00000001844ULL,
0x000000220c40723cULL, 0x040ff00000001840ULL, 0x0000001c0c3c723cULL, 0x040ff0000000183cULL,
0x0000001e0c38723cULL, 0x040ff00000001838ULL, 0x000000180c34723cULL, 0x040ff00000001834ULL,
0x0000001a0c30723cULL, 0x040ff00000001830ULL, 0x000000160c10723cULL, 0x000fee0000001810ULL,
0x00013630140c7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000004590d7824ULL, 0x000fe200078e0214ULL, 0x000000000cff7f8cULL, 0x0003e2000c80043fULL,
0x000000046c047221ULL, 0x000fe20000010000ULL, 0x00000001076d7812ULL, 0x000fc400078e0cffULL,
0x000000c00d0d7811ULL, 0x000fc800078e30ffULL, 0x000000560d00720cULL, 0x000fda0003f06070ULL,
0x0000136000000947ULL, 0x000fea0003800000ULL, 0x00000300590f7a10ULL, 0x002fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000010f0d7810ULL, 0x040fe20007ffe0ffULL,
0x000001000f0f7824ULL, 0x000fc600078e0200ULL, 0x000000540d00720cULL, 0x000fe20003f06070ULL,
0x000062000b0e7a24ULL, 0x000fd800078e020fULL, 0x0000059000008947ULL, 0x000fea0003800000ULL,
0x0000000f560c7217ULL, 0x000fe20007800000ULL, 0x0000000855147824ULL, 0x000fe200078e00ffULL,
0x00000003ff177819ULL, 0x000fe40000011602ULL, 0x00000100001f7802ULL, 0x000fe20000000f00ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a0fULL, 0xfffffff814657812ULL, 0x000fe200078ee265ULL,
0x0000000117147824ULL, 0x040fe200078e020eULL, 0x00000007170d7812ULL, 0x000fe400078e4802ULL,
0x000000200c0f7817ULL, 0x000fc40003800000ULL, 0x0000000417197810ULL, 0x040fe40007ffe0ffULL,
0x00000008171b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c171d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000819217824ULL, 0x000fe200078e00ffULL, 0x0000000f1700720cULL, 0x000fe20003f06070ULL,
0x000000081b237824ULL, 0x000fe200078e00ffULL, 0x0ffffff80d167812ULL, 0x000fe200078ef802ULL,
0x00005e00140c7625ULL, 0x000fe200078e001fULL, 0x00000002191e7212ULL, 0x000fc400078e3cffULL,
0x000000021b227212ULL, 0x080fe200078e3cffULL, 0x000000081d257824ULL, 0x040fe200078e00ffULL,
0x000000021d207212ULL, 0x000fe200078e3cffULL, 0x00000010650c7825ULL, 0x000fe200078e000cULL,
0xfffffff8211e7812ULL, 0x000fe400078ee21eULL, 0xfffffff823227812ULL, 0x000fe200078ee222ULL,
0x000000011d1a7824ULL, 0x000fe200078e020eULL, 0xfffffff825207812ULL, 0x000fe400078ee220ULL,
0x0000006b16157211ULL, 0x000fe200078e20ffULL, 0x000000011b167824ULL, 0x000fe200078e020eULL,
0x0000001017217810ULL, 0x000fc40007ffe0ffULL, 0x0000001417237810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c157faeULL, 0x0003e2000c101c46ULL,
0x0000001817257810ULL, 0x000fe20007ffe0ffULL, 0x00000001211c7824ULL, 0x100fe200078e020eULL,
0x0000001c17177810ULL, 0x000fe20007ffe0ffULL, 0x0000000123187824ULL, 0x100fe200078e020eULL,
0x0000000f1900720cULL, 0x080fe20003f06070ULL, 0x0000000125147824ULL, 0x100fe200078e020eULL,
0x0000000f1b00720cULL, 0x080fe20003f26070ULL, 0x0000000117247824ULL, 0x100fe200078e020eULL,
0x0000000f1d00720cULL, 0x080fe20003f46070ULL, 0x0000000823287824ULL, 0x000fe200078e00ffULL,
0x0000000f2100720cULL, 0x080fe20003f66070ULL, 0x00000001190c7824ULL, 0x002fe200078e020eULL,
0x0000000f2300720cULL, 0x080fe20003f86070ULL, 0x0000000817487824ULL, 0x000fe200078e00ffULL,
0x0000000f2500720cULL, 0x000fe20003fa6070ULL, 0x00005e001a1a7625ULL, 0x000fe200078e001fULL,
0x0000000f1700720cULL, 0x000fc40003fc6070ULL, 0x00000002250e7212ULL, 0x080fe200078e3cffULL,
0x00005e001c1c7625ULL, 0x080fe200078e001fULL, 0x00000002230f7212ULL, 0x080fe400078e3cffULL,
0x0000000325257819ULL, 0x000fe200000006ffULL, 0x00005e0018187625ULL, 0x080fe200078e001fULL,
0xfffffff828287812ULL, 0x000fe400078ee20fULL, 0xfffffff8252a7812ULL, 0x000fe200078ee20eULL,
0x00005e000c0e7625ULL, 0x000fe200078e001fULL, 0x00000002210d7212ULL, 0x000fc400078e3cffULL,
0x0000000321267819ULL, 0x000fe200000006ffULL, 0x0000001022217824ULL, 0x000fe200078e026bULL,
0x0000000217157212ULL, 0x000fe200078e3cffULL, 0x00005e0016167625ULL, 0x080fe200078e001fULL,
0xfffffff826267812ULL, 0x000fe400078ee20dULL, 0xfffffff848487812ULL, 0x000fe200078ee215ULL,
0x00005e0014147625ULL, 0x000fe200078e001fULL, 0x0000006b26257211ULL, 0x000fc600078e20ffULL,
0x00005e00240c7625ULL, 0x000fc800078e001fULL, 0x00000010650e7825ULL, 0x000fc800078e000eULL,
0x000000101e1f7824ULL, 0x000fe400078e026bULL, 0x0000001065167825ULL, 0x000fc600078e0016ULL,
0x000000000e1f7faeULL, 0x0003e2000c101c46ULL, 0x00000010651a7825ULL, 0x000fc600078e001aULL,
0x0000000016217faeULL, 0x0003e2000c901c46ULL, 0x0000001020237824ULL, 0x000fe400078e026bULL,
0x00000010651c7825ULL, 0x000fc600078e001cULL, 0x000000001a237faeULL, 0x0003e2000d101c46ULL,
0x0000001065187825ULL, 0x000fc600078e0018ULL, 0x000000001c257faeULL, 0x0003e2000d901c46ULL,
0x0000001028277824ULL, 0x000fe400078e026bULL, 0x0000001065147825ULL, 0x000fc600078e0014ULL,
0x0000000018277faeULL, 0x0003e2000e101c46ULL, 0x000000102a297824ULL, 0x000fe400078e026bULL,
0x00000010650c7825ULL, 0x000fc600078e000cULL, 0x0000000014297faeULL, 0x0003e2000e901c46ULL,
0x00000010486b7824ULL, 0x000fca00078e026bULL, 0x000000000c6b7faeULL, 0x0003e2000f101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x00000003ff0d7819ULL, 0x000fe20000011602ULL,
0x00000008550c7824ULL, 0x000fe400078e00ffULL, 0x00000100ff217424ULL, 0x000fe200078e00ffULL,
0x000000080d177810ULL, 0x040fe40007ffe0ffULL, 0x0000000c0d197810ULL, 0x040fe40007ffe0ffULL,
0x000000040d157810ULL, 0x000fe20007ffe0ffULL, 0x00000008171b7824ULL, 0x040fe200078e00ffULL,
0x0000000217247212ULL, 0x080fe200078e3cffULL, 0x00000008191d7824ULL, 0x000fe200078e00ffULL,
0x0000000215207212ULL, 0x080fe200078e3cffULL, 0x00000001191a7824ULL, 0x100fe200078e020eULL,
0x00000003150f7819ULL, 0x000fe200000006ffULL, 0x0000000117187824ULL, 0x000fe200078e020eULL,
0x0000000219227212ULL, 0x000fc400078e3cffULL, 0xfffffff81b247812ULL, 0x000fe400078ee224ULL,
0xfffffff80c657812ULL, 0x000fe200078ee265ULL, 0x000000010d0c7824ULL, 0x000fe200078e020eULL,
0xfffffff80f207812ULL, 0x000fe400078ee220ULL, 0xfffffff81d227812ULL, 0x000fe400078ee222ULL,
0x000000100d1b7810ULL, 0x040fe40007ffe0ffULL, 0x000000180d1f7810ULL, 0x000fc40007ffe0ffULL,
0x0000001c0d237810ULL, 0x000fe20007ffe0ffULL, 0x000000011b1c7824ULL, 0x000fe200078e020eULL,
0x000000070d0f7812ULL, 0x000fe200078e4802ULL, 0x000000081b267824ULL, 0x000fe200078e00ffULL,
0x000000140d1d7810ULL, 0x000fe20007ffe0ffULL, 0x000000011f487824ULL, 0x000fe200078e020eULL,
0x0ffffff80f147812ULL, 0x000fe200078ef802ULL, 0x00000001234c7824ULL, 0x000fe200078e020eULL,
0x0000000e15167210ULL, 0x080fe20007ffe0ffULL, 0x00005e000c0c7625ULL, 0x000fe200078e0021ULL,
0x0000000e1d287210ULL, 0x000fc40007ffe0ffULL, 0x000000021b0f7212ULL, 0x080fe200078e3cffULL,
0x000000081f197824ULL, 0x040fe200078e00ffULL, 0x000000021f0e7212ULL, 0x080fe200078e3cffULL,
0x000000081d2a7824ULL, 0x000fe200078e00ffULL, 0x0000000223177212ULL, 0x080fe200078e3cffULL,
0x00000010651e7825ULL, 0x000fe200078e000cULL, 0x00000003234e7819ULL, 0x000fe400000006ffULL,
0xfffffff826267812ULL, 0x000fe200078ee20fULL, 0x0000001014237824ULL, 0x000fe200078e026bULL,
0xfffffff8194a7812ULL, 0x000fe200078ee20eULL, 0x00005e00160e7625ULL, 0x000fe200078e0021ULL,
0x000000021d157212ULL, 0x000fc400078e3cffULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee217ULL,
0x00005e0018167625ULL, 0x000fe200078e0021ULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee215ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e237faeULL, 0x0003e2000b901c46ULL,
0x0000006b26257211ULL, 0x000fe200078e20ffULL, 0x00005e001a1a7625ULL, 0x000fc800078e0021ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0021ULL, 0x00005e0028187625ULL, 0x000fc800078e0021ULL,
0x00005e0048147625ULL, 0x000fc800078e0021ULL, 0x00005e004c0c7625ULL, 0x000fc800078e0021ULL,
0x00000010650e7825ULL, 0x000fc800078e000eULL, 0x00000010201f7824ULL, 0x002fe400078e026bULL,
0x0000001065167825ULL, 0x000fc600078e0016ULL, 0x000000000e1f7faeULL, 0x0003e2000b901c46ULL,
0x0000001024217824ULL, 0x000fe400078e026bULL, 0x00000010651a7825ULL, 0x000fc600078e001aULL,
0x0000000016217faeULL, 0x0003e2000b901c46ULL, 0x0000001022237824ULL, 0x000fe400078e026bULL,
0x00000010651c7825ULL, 0x000fc600078e001cULL, 0x000000001a237faeULL, 0x0003e2000b901c46ULL,
0x0000001065187825ULL, 0x000fc600078e0018ULL, 0x000000001c257faeULL, 0x0003e2000b901c46ULL,
0x000000102a277824ULL, 0x000fe400078e026bULL, 0x0000001065147825ULL, 0x000fc600078e0014ULL,
0x0000000018277faeULL, 0x0003e2000b901c46ULL, 0x000000104a297824ULL, 0x000fe400078e026bULL,
0x00000010650c7825ULL, 0x000fc600078e000cULL, 0x0000000014297faeULL, 0x0003e2000b901c46ULL,
0x000000104e6b7824ULL, 0x000fca00078e026bULL, 0x000000000c6b7faeULL, 0x0003e4000b901c46ULL,
0x01363c00080c7984ULL, 0x002e620000000800ULL, 0x80000000630d7824ULL, 0x000fc600078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x800000000cff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x0000001f630e7819ULL, 0x000fe200000006ffULL, 0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL,
0x0000000c000d7305ULL, 0x0002a4000021f000ULL, 0x3fa000000c0c7823ULL, 0x002fe200000100ffULL,
0x0000000d0000735dULL, 0x004fe40003800000ULL, 0x01363c00080d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fc4000780480eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000018068677810ULL, 0x000fca0007ffe067ULL,
0x0000000166677824ULL, 0x000fca00078e0267ULL, 0x01300000670c7984ULL, 0x000e680000000800ULL,
0x0132000067637984ULL, 0x0004e20000000800ULL, 0x000000030c00720bULL, 0x002fda0003f1d000ULL,
0x00000000000d7806ULL, 0x000fc800000e0100ULL, 0x0000ffff0d0f7812ULL, 0x000fe2000780c0ffULL,
0x00000001ff0d7424ULL, 0x000fd800078e00ffULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x000000030c00720bULL, 0x00cfe40003f14000ULL, 0x0000000c03157209ULL, 0x000fe40007810000ULL,
0x00000003570e7811ULL, 0x000fe400078ff0ffULL, 0x00000002ff167819ULL, 0x000fe20000011602ULL,
0x80000015030d7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fe40000410000ULL,
0x0000000000037806ULL, 0x000fe400000e0100ULL, 0x000000570e00720cULL, 0x000fe40003f05270ULL,
0x0000ffff03147812ULL, 0x000fe200078e3cffULL, 0x0000000d000d7308ULL, 0x000e660000000800ULL,
0x000000140fff7212ULL, 0x000fce000782c0ffULL, 0x00000080570f8824ULL, 0x000fca00078e0268ULL,
0x0000000f66668210ULL, 0x000fe20007ffe0ffULL, 0x00001f160d037589ULL, 0x002e6200000e0000ULL,
0x800000150c0e1221ULL, 0x000fe20000010000ULL, 0x0000000d04047220ULL, 0x000fe40000410000ULL,
0x00001f5d0d0c7589ULL, 0x0004e200000e0000ULL, 0x3fb8aa3b0e0e1820ULL, 0x000fc60000410000ULL,
0x0134001566008388ULL, 0x0009e20000000800ULL, 0x0000000e00091308ULL, 0x000f620000000800ULL,
0x00000001ff0d7807ULL, 0x004fe20000800000ULL, 0x0000000344447220ULL, 0x082fe20000410000ULL,
0x0000000345457220ULL, 0x080fe20000410000ULL, 0x0000000340407220ULL, 0x080fe20000410000ULL,
0x0000000341417220ULL, 0x080fe20000410000ULL, 0x000000033c3c7220ULL, 0x080fe20000410000ULL,
0x000000033d3d7220ULL, 0x080fe20000410000ULL, 0x0000000338387220ULL, 0x080fe20000410000ULL,
0x0000000339397220ULL, 0x080fe20000410000ULL, 0x0000000334347220ULL, 0x080fe20000410000ULL,
0x0000000335357220ULL, 0x080fe20000410000ULL, 0x0000000330307220ULL, 0x080fe20000410000ULL,
0x0000000331317220ULL, 0x080fe20000410000ULL, 0x000000032c2c7220ULL, 0x080fe20000410000ULL,
0x000000032d2d7220ULL, 0x080fe20000410000ULL, 0x0000000310107220ULL, 0x080fe20000410000ULL,
0x0000000311117220ULL, 0x000fe20000410000ULL, 0x0000000c46467220ULL, 0x088fe20000410000ULL,
0x0000000c47477220ULL, 0x080fe20000410000ULL, 0x0000000c42427220ULL, 0x080fe20000410000ULL,
0x0000000c43437220ULL, 0x080fe20000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000000c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000000c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000c36367220ULL, 0x080fe20000410000ULL,
0x0000000c37377220ULL, 0x080fe20000410000ULL, 0x0000000c32327220ULL, 0x080fe20000410000ULL,
0x0000000c33337220ULL, 0x080fe20000410000ULL, 0x0000000c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c12127220ULL, 0x080fe20000410000ULL,
0x0000000c13137220ULL, 0x000fe20000410000ULL, 0x000000ffff037224ULL, 0x000fe200078e0015ULL,
0x0000006309631220ULL, 0x020fe20000410000ULL, 0x000080400000791aULL, 0x01cfc80000000000ULL,
0x00a800006424783bULL, 0x000fe20000000200ULL, 0x0000001062507824ULL, 0x100fe200078e0269ULL,
0x0000006960487211ULL, 0x000fe200078e20ffULL, 0x00000010614c7824ULL, 0x100fe200078e0269ULL,
0x00000009ff0c723eULL, 0x000fe200000000ffULL, 0x000000105f287824ULL, 0x100fe200078e0269ULL,
0x00000002ff5f7819ULL, 0x000fe20000011602ULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x000054100c167816ULL, 0x000fe2000000000cULL, 0x000000105c207824ULL, 0x100fe200078e0269ULL,
0x000099100d147816ULL, 0x000fe200000000ffULL, 0x000000004c4c783bULL, 0x000fe20000004200ULL,
0x000000105b1c7824ULL, 0x000fc400078e0269ULL, 0x000000ff1400720cULL, 0x000fe20003f05270ULL,
0x000000004848783bULL, 0x000fe20000004200ULL, 0x0000001058147824ULL, 0x100fe400078e0269ULL,
0x000000105a187824ULL, 0x000fe200078e0269ULL, 0x000000002828783bULL, 0x000fe80000004200ULL,
0x00001f5f165f7589ULL, 0x000e6800000e0000ULL, 0x00001f5d16607589ULL, 0x000ea800000e0000ULL,
0x00a800005e0c783bULL, 0x000ee80000000200ULL, 0x000000002020783bULL, 0x000f280000004200ULL,
0x000000001c1c783bULL, 0x000f680000004200ULL, 0x000000001818783bULL, 0x000f280000004200ULL,
0x000000001414783bULL, 0x000f220000004200ULL, 0x0000005f24248232ULL, 0x002fc40000000000ULL,
0x0000005f26268232ULL, 0x000fe40000000000ULL, 0x0000006025258232ULL, 0x084fe40000000000ULL,
0x0000006027278232ULL, 0x000fce0000000000ULL, 0x000000502444723cULL, 0x040ff00000001844ULL,
0x000000522440723cULL, 0x000fe20000001840ULL, 0x0000005f0c0c8232ULL, 0x088fe40000000000ULL,
0x0000005f0e0e8232ULL, 0x000fc40000000000ULL, 0x000000600d0d8232ULL, 0x000fc60000000000ULL,
0x0000004c243c723cULL, 0x000fe2000000183cULL, 0x000000600f0f8232ULL, 0x000fce0000000000ULL,
0x0000004e2438723cULL, 0x040ff00000001838ULL, 0x000000482434723cULL, 0x040ff00000001834ULL,
0x0000004a2430723cULL, 0x040ff00000001830ULL, 0x00000028242c723cULL, 0x040ff0000000182cULL,
0x0000002a2410723cULL, 0x000ff00000001810ULL, 0x000000200c44723cULL, 0x050ff00000001844ULL,
0x000000220c40723cULL, 0x040ff00000001840ULL, 0x0000001c0c3c723cULL, 0x060ff0000000183cULL,
0x0000001e0c38723cULL, 0x040ff00000001838ULL, 0x000000180c34723cULL, 0x040ff00000001834ULL,
0x0000001a0c30723cULL, 0x040ff00000001830ULL, 0x000000140c2c723cULL, 0x040ff0000000182cULL,
0x000000160c10723cULL, 0x000fe20000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fdc0000008000ULL,
0x0136400008ff7f8cULL, 0x0003e2000c80043fULL, 0x00000001076d7812ULL, 0x000fe200078ec0ffULL,
0x0000000463047221ULL, 0x000fce0000010000ULL, 0x0000030059597a10ULL, 0x002fe40007ffe0ffULL,
0x000000ff06ff7812ULL, 0x000fc4000780c0ffULL, 0x000000545900720cULL, 0x000fe40003f26070ULL,
0x00000001ff067807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffffac3000007947ULL, 0x000fea000383ffffULL, 0x00000000000579c3ULL, 0x000e620000002500ULL,
0x0000001300177202ULL, 0x000fe20000000f00ULL, 0x000000ffff187224ULL, 0x000fe200078e0012ULL,
0x0000000554007c0cULL, 0x002fda000bf03070ULL, 0x0000035000000947ULL, 0x000fea0003800000ULL,
0x0180000004027810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe200078e0004ULL,
0x0000678000057802ULL, 0x000fe40000000f00ULL, 0x00009d6000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x002fe200078e0008ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000400057308ULL, 0x000e640000001000ULL, 0xbf80000005027423ULL, 0x002fc80000000004ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000205027223ULL, 0x000fe40000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e680000000000ULL,
0x0000000000077919ULL, 0x000ea20000000000ULL, 0x00000002ff057819ULL, 0x002fe40000011605ULL,
0x0000000807077811ULL, 0x004fc800078ff0ffULL, 0x00001f0502057589ULL, 0x000e6800000e0000ULL,
0x00001f0702077589ULL, 0x000ea200000e0000ULL, 0x0000004405447220ULL, 0x042fe20000410000ULL,
0x0000004505457220ULL, 0x040fe20000410000ULL, 0x0000004005407220ULL, 0x040fe20000410000ULL,
0x0000004105417220ULL, 0x040fe20000410000ULL, 0x0000003c053c7220ULL, 0x040fe20000410000ULL,
0x0000003d053d7220ULL, 0x040fe20000410000ULL, 0x0000003805387220ULL, 0x040fe20000410000ULL,
0x0000003905397220ULL, 0x040fe20000410000ULL, 0x0000003405347220ULL, 0x040fe20000410000ULL,
0x0000003505357220ULL, 0x040fe20000410000ULL, 0x0000003005307220ULL, 0x040fe20000410000ULL,
0x0000003105317220ULL, 0x040fe20000410000ULL, 0x0000002c052c7220ULL, 0x040fe20000410000ULL,
0x0000002d052d7220ULL, 0x040fe20000410000ULL, 0x0000001005107220ULL, 0x040fe20000410000ULL,
0x0000001105117220ULL, 0x000fe20000410000ULL, 0x0000004607467220ULL, 0x044fe20000410000ULL,
0x0000004707477220ULL, 0x040fe20000410000ULL, 0x0000004207427220ULL, 0x040fe20000410000ULL,
0x0000004307437220ULL, 0x040fe20000410000ULL, 0x0000003e073e7220ULL, 0x040fe20000410000ULL,
0x0000003f073f7220ULL, 0x040fe20000410000ULL, 0x0000003a073a7220ULL, 0x040fe20000410000ULL,
0x0000003b073b7220ULL, 0x040fe20000410000ULL, 0x0000003607367220ULL, 0x040fe20000410000ULL,
0x0000003707377220ULL, 0x040fe20000410000ULL, 0x0000003207327220ULL, 0x040fe20000410000ULL,
0x0000003307337220ULL, 0x040fe20000410000ULL, 0x0000002e072e7220ULL, 0x040fe20000410000ULL,
0x0000002f072f7220ULL, 0x040fe20000410000ULL, 0x0000001807187220ULL, 0x040fe20000410000ULL,
0x0000001707177220ULL, 0x000fe20000410000ULL, 0x00000000000b7919ULL, 0x000e620000000000ULL,
0x000000343508723eULL, 0x000fc400000000ffULL, 0x00000010110d723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000181717723eULL, 0x000fe400000000ffULL,
0x000000363714723eULL, 0x000fe400000000ffULL, 0x000000444502723eULL, 0x000fe400000000ffULL,
0x000000303109723eULL, 0x000fe400000000ffULL, 0x0000002c2d0c723eULL, 0x000fc400000000ffULL,
0x000000323315723eULL, 0x000fe400000000ffULL, 0x0000002e2f16723eULL, 0x000fe400000000ffULL,
0x000000404105723eULL, 0x000fe400000000ffULL, 0x0000003c3d06723eULL, 0x000fe400000000ffULL,
0x000000383907723eULL, 0x000fe400000000ffULL, 0x00000002ff257819ULL, 0x002fc4000001160bULL,
0x000000080b357811ULL, 0x000fe400078ff0ffULL, 0x0000000725107812ULL, 0x040fe200078ec0ffULL,
0x0000000825187824ULL, 0x040fe200078e00ffULL, 0x00000025ff277212ULL, 0x000fe200078e33ffULL,
0x00000008251a7824ULL, 0x000fe200078e00ffULL, 0x00000035ff377212ULL, 0x000fe400078e33ffULL,
0x00000003351c7819ULL, 0x000fe400000006ffULL, 0x0000000110117812ULL, 0x000fc400078e3cffULL,
0xfffffff818197812ULL, 0x000fe400078ee225ULL, 0xfffffff81a277812ULL, 0x000fe200078ee227ULL,
0x00000008251b7824ULL, 0x000fe200078e0211ULL, 0xfffffff81c377812ULL, 0x000fe200078ee237ULL,
0x0000100055117824ULL, 0x000fe200078e00ffULL, 0x0000000210187812ULL, 0x040fe400078e3cffULL,
0x00000003101a7812ULL, 0x040fe400078e3cffULL, 0x00000004101c7812ULL, 0x040fe200078e3cffULL,
0x00000008251d7824ULL, 0x040fe200078e0218ULL, 0x00000005101e7812ULL, 0x040fe200078e3cffULL,
0x00000008251f7824ULL, 0x000fe200078e021aULL, 0x0000000610107812ULL, 0x000fe200078e3cffULL,
0x000000040b187824ULL, 0x000fe200078e00ffULL, 0x0000001c25217211ULL, 0x040fe200078e18ffULL,
0x0000000825237824ULL, 0x000fe200078e021eULL, 0x00000003351c7819ULL, 0x000fe200000006ffULL,
0x0000000825257824ULL, 0x000fe200078e0210ULL, 0x0000000c18187812ULL, 0x000fe200078ec0ffULL,
0x000008000a107824ULL, 0x000fe200078e0211ULL, 0x00000007351a7812ULL, 0x000fc400078ec0ffULL,
0xfffffff81c297812ULL, 0x000fe200078ee235ULL, 0x0000001019197824ULL, 0x100fe200078e0210ULL,
0x000000011a1c7812ULL, 0x040fe200078e3cffULL, 0x000000101b1b7824ULL, 0x000fe200078e0210ULL,
0x000000021a1e7812ULL, 0x040fe200078e3cffULL, 0x0000000119197824ULL, 0x000fe200078e0218ULL,
0x000000031a207812ULL, 0x040fe200078e3cffULL, 0x000000101d1d7824ULL, 0x100fe200078e0210ULL,
0x000000041a227812ULL, 0x040fe200078e3cffULL, 0x0000001021217824ULL, 0x000fe200078e0210ULL,
0x000000051a247812ULL, 0x040fe200078e3cffULL, 0x0000000219007388ULL, 0x0003e20000000800ULL,
0x000000061a1a7812ULL, 0x000fe200078e3cffULL, 0x00000008352b7824ULL, 0x000fe200078e021cULL,
0x000000101f1f7211ULL, 0x000fe200078e20ffULL, 0x00000008352d7824ULL, 0x040fe200078e021eULL,
0x00000020352f7211ULL, 0x040fe200078e18ffULL, 0x0000000835317824ULL, 0x000fe200078e0222ULL,
0x0000001027277211ULL, 0x000fe200078e20ffULL, 0x0000000835337824ULL, 0x000fe200078e0224ULL,
0x00000046470e723eULL, 0x000fe200000000ffULL, 0x0000001023237824ULL, 0x000fe200078e0210ULL,
0x00000042430f723eULL, 0x000fe200000000ffULL, 0x0000000118027824ULL, 0x042fe200078e021bULL,
0x0000001033337211ULL, 0x000fe200078e20ffULL, 0x0000000835357824ULL, 0x000fe200078e021aULL,
0x0000001f181a7210ULL, 0x040fe20007ffe0ffULL, 0x0000001025257824ULL, 0x100fe200078e0210ULL,
0x0000000502007388ULL, 0x0003e20000000800ULL, 0x00000001181d7824ULL, 0x040fe200078e021dULL,
0x0000003e3f12723eULL, 0x000fe200000000ffULL, 0x0000001029297824ULL, 0x100fe200078e0210ULL,
0x0000003a3b13723eULL, 0x000fe200000000ffULL, 0x0000000118217824ULL, 0x040fe200078e0221ULL,
0x000000061d007388ULL, 0x000fe20000000800ULL, 0x000000102b2b7824ULL, 0x100fe200078e0210ULL,
0x0000002918297210ULL, 0x040fe20007ffe0ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0210ULL,
0x000000071a007388ULL, 0x000fe20000000800ULL, 0x00000001181c7824ULL, 0x000fe200078e0223ULL,
0x0000000b001f7210ULL, 0x000fe20007ffe0ffULL, 0x0000000118257824ULL, 0x040fe200078e0225ULL,
0x0000000821007388ULL, 0x000fe20000000800ULL, 0x00000001181e7824ULL, 0x040fe200078e0227ULL,
0x0000002d182d7210ULL, 0x000fe20007ffe0ffULL, 0x000000102f2f7824ULL, 0x100fe200078e0210ULL,
0x000000091c007388ULL, 0x000fe20000000800ULL, 0x0000001031317824ULL, 0x000fc400078e0210ULL,
0x0000000118207824ULL, 0x040fe200078e022bULL, 0x0000000c25007388ULL, 0x000fe20000000800ULL,
0x0000001035357824ULL, 0x100fe400078e0210ULL, 0x0000001037377824ULL, 0x000fe200078e0210ULL,
0x0000000d1e007388ULL, 0x000fe20000000800ULL, 0x0000000118227824ULL, 0x040fe400078e022fULL,
0x0000000118317824ULL, 0x040fe200078e0231ULL, 0x0000000e29007388ULL, 0x000fe20000000800ULL,
0x0000000118247824ULL, 0x000fc400078e0233ULL, 0x0000000118357824ULL, 0x040fe200078e0235ULL,
0x0000000f20007388ULL, 0x000fe20000000800ULL, 0x0000000118267824ULL, 0x000fe400078e0237ULL,
0x000000101f027824ULL, 0x002fe200078e0211ULL, 0x000000122d007388ULL, 0x000fe20000000800ULL,
0x00000001ff057424ULL, 0x000fc600078e00ffULL, 0x0000001322007388ULL, 0x000fe40000000800ULL,
0x0000030005007a0cULL, 0x000fe40003f05270ULL, 0x0000001431007388ULL, 0x000fe80000000800ULL,
0x0000001524007388ULL, 0x000fe80000000800ULL, 0x0000001635007388ULL, 0x000fe80000000800ULL,
0x0000001726007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000002187984ULL, 0x000e680000000c00ULL, 0x0004000002287984ULL, 0x000ea80000000c00ULL,
0x00080000020c7984ULL, 0x000ee80000000c00ULL, 0x000c0000022c7984ULL, 0x000f220000000c00ULL,
0x200000ff1b1b7230ULL, 0x002fc40000000000ULL, 0x200000ff1a1a7230ULL, 0x000fe40000000000ULL,
0x200000ff19197230ULL, 0x000fe40000000000ULL, 0x200000ff18187230ULL, 0x000fe40000000000ULL,
0x200000ff2b2b7230ULL, 0x004fe40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fe40000000000ULL,
0x200000ff29297230ULL, 0x000fc40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x0000000f1b1b7230ULL, 0x008fe40000000000ULL, 0x0000000e1a1a7230ULL, 0x000fe40000000000ULL,
0x0000000d19197230ULL, 0x000fe40000000000ULL, 0x0000000c18187230ULL, 0x000fe40000000000ULL,
0x0000002f2b2b7230ULL, 0x010fc40000000000ULL, 0x0000002e2a2a7230ULL, 0x000fe20000000000ULL,
0x0000001802007388ULL, 0x0003e20000000c00ULL, 0x0000002d29297230ULL, 0x000fe40000000000ULL,
0x0000002c28287230ULL, 0x000fca0000000000ULL, 0x0004002802007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000030a000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7919ULL, 0x000ea20000002700ULL, 0x00005800ff067624ULL, 0x000fe200078e00ffULL,
0x000000010aff7812ULL, 0x000fe2000780f857ULL, 0x00001000ff077424ULL, 0x000fe200078e00ffULL,
0x0000000000057919ULL, 0x000ea20000002600ULL, 0x0000000b55147819ULL, 0x000fc400000006ffULL,
0x000000401f1d7810ULL, 0x000fe20007ffe0ffULL, 0x00000000020c7984ULL, 0x0007280000000c00ULL,
0x0004000002187984ULL, 0x0026620000000c00ULL, 0x000058001e1e7a24ULL, 0x004fe400078e0205ULL,
0x0000030006057a24ULL, 0x000fe400078e02ffULL, 0x000003001e137a24ULL, 0x000fc400078e02ffULL,
0x0000640005057a24ULL, 0x000fc600078e02ffULL, 0x0000000513087c10ULL, 0x000fe4000fffe0ffULL,
0x00000fff05127811ULL, 0x040fe400078e40ffULL, 0x01ffffff05157812ULL, 0x000fe400078ec0ffULL,
0x0000000812067211ULL, 0x000fca00078fa0ffULL, 0x00006a0006067625ULL, 0x000fca00078e0007ULL,
0x0000001406067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x000000ff0b00720cULL, 0x000fc60000725670ULL, 0x000000101f167825ULL, 0x000fc800078e0006ULL,
0x000000101d1c7825ULL, 0x000fe200078e0006ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000001ff067819ULL, 0x01afe2000001160bULL, 0x000000100b057824ULL, 0x000fe400078e00ffULL,
0x00000080ff027424ULL, 0x000fe200078e00ffULL, 0x0000000c061f7812ULL, 0x000fe200078ec0ffULL,
0x0000000108097824ULL, 0x040fe200078e0215ULL, 0x0000007005057812ULL, 0x000fe200078ec0ffULL,
0x00006a0008067625ULL, 0x000fc800078e0002ULL, 0x00006a0009087625ULL, 0x000fe200078e0002ULL,
0x000000061f067210ULL, 0x000fc80007a1e005ULL, 0x000000081f087210ULL, 0x000fe40007c7e005ULL,
0x00000007ff077210ULL, 0x000fe400007e44ffULL, 0x00000009ff097210ULL, 0x000fc60001fe84ffULL,
0x0000000306007986ULL, 0x0003e8000c101906ULL, 0x0000000408007986ULL, 0x0003e4000c101906ULL,
0x0000000c16007986ULL, 0x01a3e2000c101d06ULL, 0x0000013000007945ULL, 0x000fe60003800000ULL,
0x000000181c007986ULL, 0x0003e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x0000000100057802ULL, 0x000fe20000000f00ULL,
0x00000004ff037424ULL, 0x000fc600078e00ffULL, 0x0000030005057a10ULL, 0x000fe20007ffe1ffULL,
0x000068001e027625ULL, 0x000fe200078e0003ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000005020279a8ULL, 0x000ea400099ee1c6ULL,
0x000000050200720cULL, 0x004fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff047807ULL, 0x000fca0000000000ULL, 0x00000004ff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff027984ULL, 0x000ee40000000000ULL, 0x000000ff0200720cULL, 0x008fda0003f05270ULL,
0x00002cb000008947ULL, 0x000fea0003800000ULL, 0x000000ff5700720cULL, 0x000fda0003f05270ULL,
0x00000d6000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000038000008947ULL, 0x000fea0003800000ULL, 0x000000100b027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe2000001160bULL, 0x00000080ff177424ULL, 0x002fe200078e00ffULL,
0x0000000113047810ULL, 0x004fe40007ffe0ffULL, 0x0000007002197812ULL, 0x000fe400078ec0ffULL,
0x0000000c030c7812ULL, 0x000fe200078ec0ffULL, 0x00006a0013027625ULL, 0x000fc800078e0017ULL,
0x00006a0004047625ULL, 0x000fe200078e0017ULL, 0x000000020c067210ULL, 0x000fc8000791e019ULL,
0x000000040c047210ULL, 0x000fe40007b5e019ULL, 0x00000003ff077210ULL, 0x000fe400007e24ffULL,
0x00000005ff057210ULL, 0x000fc600017e64ffULL, 0x0000000606027981ULL, 0x000368000c1e1900ULL,
0x0000000604037981ULL, 0x000362000c1e1900ULL, 0x00000300ff087624ULL, 0x000fca00078e00ffULL,
0x000000020800780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x0000000213047810ULL, 0x002fca0007ffe0ffULL, 0x00006a0004047625ULL, 0x000fca00078e0017ULL,
0x000000040c047210ULL, 0x000fc8000791e019ULL, 0x00000005ff057210ULL, 0x000fcc00007e24ffULL,
0x0000000604057981ULL, 0x000362000c1e1900ULL, 0x000000040800780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x0000000313067810ULL, 0x002fca0007ffe0ffULL,
0x00006a0006067625ULL, 0x000fca00078e0017ULL, 0x000000060c067210ULL, 0x000fc8000791e019ULL,
0x00000007ff077210ULL, 0x000fca00007e24ffULL, 0x0000000606097981ULL, 0x000362000c1e1900ULL,
0x000000040800780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x0000000413067810ULL, 0x002fca0007ffe0ffULL, 0x00006a0006067625ULL, 0x000fca00078e0017ULL,
0x000000060c067210ULL, 0x000fc8000791e019ULL, 0x00000007ff077210ULL, 0x000fca00007e24ffULL,
0x00000006060d7981ULL, 0x000362000c1e1900ULL, 0x000000060800780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000000513067810ULL, 0x002fca0007ffe0ffULL,
0x00006a0006067625ULL, 0x000fca00078e0017ULL, 0x000000060c067210ULL, 0x000fc8000791e019ULL,
0x00000007ff077210ULL, 0x000fca00007e24ffULL, 0x00000006060f7981ULL, 0x000362000c1e1900ULL,
0x000000060800780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000080800780cULL, 0x002fe40003f06070ULL, 0x0000000613067810ULL, 0x000fca0007ffe0ffULL,
0x00006a0006067625ULL, 0x000fca00078e0017ULL, 0x000000060c067210ULL, 0x000fe40007a3e019ULL,
0x0000000713160810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff077210ULL, 0x000fc60000fe44ffULL,
0x00006a0016160625ULL, 0x000fca00078e0017ULL, 0x000000160c160210ULL, 0x000fe40007c7e019ULL,
0x0000000606197981ULL, 0x000364000c1e1900ULL, 0x00000017ff170210ULL, 0x000fcc0001fe84ffULL,
0x0000000616170981ULL, 0x000366000c1e1900ULL, 0x0000030000047ab9ULL, 0x002fe40000000800ULL,
0x0000000704047890ULL, 0x000fc8000fffe03fULL, 0x000000033f047899ULL, 0x000fcc0008011604ULL,
0x00000004ff007c0cULL, 0x000fda000bf05270ULL, 0x0000090000008947ULL, 0x000fea0003800000ULL,
0x000000ff000e7202ULL, 0x000fe20000000f00ULL, 0x000000ffff087224ULL, 0x000fe400078e0013ULL,
0x000000ffff1b7224ULL, 0x020fe400078e0002ULL, 0x000000ffff167224ULL, 0x000fc600078e00ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x0000000116167810ULL, 0x000fc80007ffe0ffULL,
0x0000000416007c0cULL, 0x000fce000bf06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080e047810ULL, 0x044fe40007ffe0ffULL, 0x000000010e067810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030006007a0cULL, 0x000fe40003f46070ULL,
0x0000001b02027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000808067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x000000040b047819ULL, 0x000fe400000006ffULL, 0x00000001ff0c7819ULL, 0x000fe2000001160bULL,
0x00006a0006067625ULL, 0x000fe200078e0007ULL, 0x00000070041b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL, 0x000000060c067210ULL, 0x000fc80007b3e01bULL,
0x00000007ff077210ULL, 0x000fca0000fe64ffULL, 0x00000006061b7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090e047810ULL, 0x040fe40007ffe0ffULL,
0x000000020e067810ULL, 0x002fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030006007a0cULL, 0x000fe40003f46070ULL, 0x0000000302027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000908067810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x00000001ff047819ULL, 0x000fe2000001160bULL,
0x000000100b037824ULL, 0x000fe400078e00ffULL, 0x00006a0006067625ULL, 0x000fe200078e0007ULL,
0x0000000c04047812ULL, 0x000fe400078ec0ffULL, 0x0000007003037812ULL, 0x000fc800078ec0ffULL,
0x0000000604067210ULL, 0x000fc80007b3e003ULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x0000000606037981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0e047810ULL, 0x040fe40007ffe0ffULL, 0x000000030e067810ULL, 0x002fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030006007a0cULL, 0x000fe40003f46070ULL,
0x0000000502027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000a08047810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff057424ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe2000001160bULL, 0x000000100b067824ULL, 0x000fe400078e00ffULL,
0x00006a0004047625ULL, 0x000fe200078e0005ULL, 0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL,
0x0000007006077812ULL, 0x000fc800078ec0ffULL, 0x000000040c047210ULL, 0x000fc80007b3e007ULL,
0x00000005ff057210ULL, 0x000fcc0000fe64ffULL, 0x0000000604057981ULL, 0x000366000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0e047810ULL, 0x042fe40007ffe0ffULL,
0x000000040e067810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030006007a0cULL, 0x000fe40003f46070ULL, 0x0000000902027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000b08067810ULL, 0x000fe20007ffe0ffULL,
0x000000100b047824ULL, 0x000fe200078e00ffULL, 0x0000008000077802ULL, 0x000fe40000000f00ULL,
0x00000001ff0c7819ULL, 0x000fe4000001160bULL, 0x0000007004097812ULL, 0x000fe200078ec0ffULL,
0x00006a0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000060c067210ULL, 0x000fc80007b3e009ULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x0000000606097981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0e047810ULL, 0x040fe40007ffe0ffULL, 0x000000050e067810ULL, 0x002fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030006007a0cULL, 0x000fe40003f46070ULL,
0x0000000d02027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000c08067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe2000001160bULL, 0x000000100b047824ULL, 0x000fe400078e00ffULL,
0x00006a0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL,
0x00000070040d7812ULL, 0x000fc800078ec0ffULL, 0x000000060c067210ULL, 0x000fc80007b3e00dULL,
0x00000007ff077210ULL, 0x000fca0000fe64ffULL, 0x00000006060d7981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0e047810ULL, 0x040fe40007ffe0ffULL,
0x000000060e067810ULL, 0x002fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030006007a0cULL, 0x000fe40003f46070ULL, 0x0000000f02027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000d08067810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x000000040b047819ULL, 0x000fe400000006ffULL,
0x00000001ff0c7819ULL, 0x000fe2000001160bULL, 0x00006a0006067625ULL, 0x000fe200078e0007ULL,
0x00000070040f7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000060c067210ULL, 0x000fc80007b3e00fULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x00000006060f7981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0e047810ULL, 0x040fe40007ffe0ffULL, 0x000000070e067810ULL, 0x002fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030006007a0cULL, 0x000fe40003f46070ULL,
0x0000001902027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000e08067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe2000001160bULL, 0x000000100b047824ULL, 0x000fe400078e00ffULL,
0x00006a0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL,
0x0000007004197812ULL, 0x000fc800078ec0ffULL, 0x000000060c067210ULL, 0x000fc80007b3e019ULL,
0x00000007ff077210ULL, 0x000fca0000fe64ffULL, 0x0000000606197981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0e047810ULL, 0x000fe40007ffe0ffULL,
0x0000001702027209ULL, 0x000fe40007810000ULL, 0x0000030004007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000f08067810ULL, 0x002fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe2000001160bULL,
0x000000100b047824ULL, 0x000fe400078e00ffULL, 0x00006a0006067625ULL, 0x000fe200078e0007ULL,
0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000007004177812ULL, 0x000fc800078ec0ffULL,
0x000000060c067210ULL, 0x000fc80007a3e017ULL, 0x00000007ff077210ULL, 0x000fca0000fe44ffULL,
0x0000000606177981ULL, 0x000368000c1e1900ULL, 0x000000080e0e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000808087810ULL, 0x000fe20007ffe0ffULL, 0xfffff74000008947ULL, 0x000fea000383ffffULL,
0x00000000000b7919ULL, 0x000ee40000000000ULL, 0x000000040b037819ULL, 0x028fe400000006ffULL,
0x00000001ff047819ULL, 0x006fe4000001160bULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c04047812ULL, 0x000fca00078ec0ffULL, 0x0000000103037824ULL, 0x000fca00078e0204ULL,
0x0000000203007388ULL, 0x0003e40000000800ULL, 0x000000100b037824ULL, 0x042fe200078e00ffULL,
0x00000001ff047819ULL, 0x004fe2000001160bULL, 0x000000010a0e7824ULL, 0x000fe200078e0213ULL,
0x000000070b00780cULL, 0x000fe20003f04070ULL, 0x00001000ff097424ULL, 0x000fe200078e00ffULL,
0x0000007003057812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000c04067812ULL, 0x000fe200078ec0ffULL, 0x000020000a167824ULL, 0x000fe200078e0211ULL,
0x0000000e12027211ULL, 0x000fe200078fa0ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000002ff077819ULL, 0x000fe20000011657ULL, 0x0000000105177824ULL, 0x000fe200078e0206ULL,
0x000000600b0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000020057057824ULL, 0x000fe200078e00ffULL,
0x0000000107047812ULL, 0x000fe200078ec0ffULL, 0x00006a0002027625ULL, 0x000fe200078e0009ULL,
0x000000550a078211ULL, 0x040fe200078e08ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000080005057812ULL, 0x000fe200078ec0ffULL, 0x000000020a098824ULL, 0x000fe200078e0255ULL,
0x0000001402027210ULL, 0x000fe20007f3e0ffULL, 0x0000000207188824ULL, 0x000fe200078e0204ULL,
0x000000200b077810ULL, 0x000fe20007ffe0ffULL, 0x00000001150c8824ULL, 0x000fe200078e020eULL,
0x00000004091a8211ULL, 0x000fe200078e08ffULL, 0x0000000116047824ULL, 0x000fe200078e0205ULL,
0x000000400b097810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff037224ULL, 0x000fe200008e0603ULL,
0x00000080000f8802ULL, 0x000fe20000000f00ULL, 0x000000100b1f7824ULL, 0x000fe200078e0204ULL,
0x000003000a007a0cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x100fe200078e0002ULL,
0x0000000017177984ULL, 0x000e620000000800ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000080ff198424ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000001009067825ULL, 0x100fe200078e0002ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x000000100d087825ULL, 0x000fe200078e0002ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x00006a000c0c8625ULL, 0x000fe200078e000fULL,
0x000000ff00387202ULL, 0x000fc60000000f00ULL, 0x00006a000e0e8625ULL, 0x000fc800078e0019ULL,
0x0000000818188824ULL, 0x000fe400078e020bULL, 0x000000100b027825ULL, 0x000fc600078e0002ULL,
0x0000458018218811ULL, 0x000fe200078e20ffULL, 0x000000081a1a8824ULL, 0x000fe200078e020bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000021f7faeULL, 0x0005e2000b901c46ULL,
0x000000100b0c8825ULL, 0x040fe200078e000cULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x000041801a238811ULL, 0x000fe200078e20ffULL, 0x000000100b0e8825ULL, 0x000fe200078e000eULL,
0x00380000041f7faeULL, 0x0005e2000b901c46ULL, 0x00000000001a7805ULL, 0x000fc6000001ff00ULL,
0x00580000061f7faeULL, 0x0005e8000b901c46ULL, 0x00780000081f7faeULL, 0x0005e8000b901c46ULL,
0x000000000c218faeULL, 0x0007e8000b901c46ULL, 0x000000000e238faeULL, 0x0009e8000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000001e7805ULL, 0x004fe2000001ff00ULL,
0x0000000000207805ULL, 0x008fe2000001ff00ULL, 0x0000000000227805ULL, 0x010fe2000001ff00ULL,
0x00000e0000001947ULL, 0x000fea0003800000ULL, 0x00000df000007945ULL, 0x002fe20003800000ULL,
0x000000ffff187224ULL, 0x000fc400078e00ffULL, 0x000000ffff047224ULL, 0x000fca00078e000aULL,
0x00000002043c7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff487224ULL, 0x000fe200078e0004ULL,
0x00000002ff3a7819ULL, 0x000fe2000001160bULL, 0x000000020a057824ULL, 0x000fe200078e0255ULL,
0x000003003c007a0cULL, 0x000fe20003f06070ULL, 0x0000040000017945ULL, 0x000fe20003800000ULL,
0x0000000648027819ULL, 0x000fe200000006ffULL, 0x000000083a3e7824ULL, 0x040fe200078e00ffULL,
0x000000073a037812ULL, 0x040fe200078ec0ffULL, 0x000000083a047824ULL, 0x000fe200078e00ffULL,
0x0000008002027812ULL, 0x000fe200078ec0ffULL, 0x000000083a067824ULL, 0x000fe200078e00ffULL,
0x0000003aff3b7212ULL, 0x000fc400078e33ffULL, 0x000000013e427812ULL, 0x140fe200078ef603ULL,
0x0000010005447824ULL, 0x000fe200078e0002ULL, 0x000000023e417812ULL, 0x140fe400078ef603ULL,
0x000000033e407812ULL, 0x140fe400078ef603ULL, 0x000000043e3f7812ULL, 0x140fe400078ef603ULL,
0x000000053e3d7812ULL, 0x100fe400078ef603ULL, 0xfffffff804437812ULL, 0x000fc400078ee203ULL,
0x000000063e3e7812ULL, 0x000fe400078ef603ULL, 0xfffffff8063b7812ULL, 0x000fe400078ee23bULL,
0x000000040b4b7819ULL, 0x000fe400000006ffULL, 0x000000083a397810ULL, 0x008fe20007ffe0ffULL,
0x000002c000000947ULL, 0x000fea0003800000ULL, 0x0000000113067824ULL, 0x100fe200078e023cULL,
0x000000070b00780cULL, 0x000fe20003f24070ULL, 0x00001000ff037424ULL, 0x000fe200078e00ffULL,
0x00000001ff047819ULL, 0x000fc4000001163cULL, 0x0000000612027211ULL, 0x000fe400078fa0ffULL,
0x0000000104047812ULL, 0x000fe400078ec0ffULL, 0x000000400b477810ULL, 0x040fe20007ffe0ffULL,
0x00006a0002027625ULL, 0x000fe200078e0003ULL, 0x000000600b497810ULL, 0x000fc60007ffe0ffULL,
0x000000020a059824ULL, 0x100fe200078e0255ULL, 0x0000001402087210ULL, 0x000fe20007f1e0ffULL,
0x000000020a079824ULL, 0x000fe200078e0255ULL, 0x0000000a3c027819ULL, 0x000fe200000006ffULL,
0x0000000205469824ULL, 0x100fe200078e0204ULL, 0x000000200b057810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0603ULL, 0x0000080002037812ULL, 0x000fe200078ec0ffULL,
0x00000002074a9824ULL, 0x000fe200078e0204ULL, 0x00000080000d9802ULL, 0x000fe20000000f00ULL,
0x00000001150c9824ULL, 0x000fc400078e0206ULL, 0x0000000116027824ULL, 0x000fe400078e0203ULL,
0x00000080ff079424ULL, 0x000fe400078e00ffULL, 0x000000100b457824ULL, 0x000fe400078e0202ULL,
0x00006a000c0c9625ULL, 0x000fc800078e000dULL, 0x0000001005027825ULL, 0x000fc800078e0008ULL,
0x000000100b0e7825ULL, 0x000fc800078e0008ULL, 0x00006a0006069625ULL, 0x000fe200078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000e457faeULL, 0x0003e6000b901c46ULL,
0x0000001047047825ULL, 0x000fe200078e0008ULL, 0x0038000002457faeULL, 0x0003e6000b901c46ULL,
0x0000000846469824ULL, 0x000fe200078e020bULL, 0x0058000004457faeULL, 0x0003e2000b901c46ULL,
0x0000001049087825ULL, 0x000fe200078e0008ULL, 0x0000000b4a499211ULL, 0x000fc400078e18ffULL,
0x0000458046479811ULL, 0x000fe200078e20ffULL, 0x000000100b0c9825ULL, 0x000fe200078e000cULL,
0x0000418049499811ULL, 0x000fe200078e20ffULL, 0x0078000008457faeULL, 0x0003e4000b901c46ULL,
0x000000100b069825ULL, 0x000fe400078e0006ULL, 0x000000000c479faeULL, 0x0003e8000b901c46ULL,
0x0000000006499faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000001ff057819ULL, 0x002fe2000001160bULL,
0x0000000839047824ULL, 0x000fe200078e00ffULL, 0x000000704b4b7812ULL, 0x000fe200078ec0ffULL,
0x0000000839087824ULL, 0x000fe200078e00ffULL, 0x0000000c05067812ULL, 0x000fe200078ec0ffULL,
0x0000040048027824ULL, 0x000fe200078e00ffULL, 0x0000000739037812ULL, 0x000fc400078ec0ffULL,
0x0000004406447210ULL, 0x000fe40007ffe04bULL, 0x0000000104077812ULL, 0x140fe400078ef603ULL,
0x0000000204097812ULL, 0x140fe400078ef603ULL, 0x00000003040d7812ULL, 0x140fe400078ef603ULL,
0x00000004040f7812ULL, 0x140fe400078ef603ULL, 0x0000000504457812ULL, 0x000fc400078ef603ULL,
0x0000000604477812ULL, 0x100fe400078ef603ULL, 0xfffffff808057812ULL, 0x000fe200078ee203ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800044047984ULL, 0x000e620000000800ULL,
0x0000080002037812ULL, 0x000fe200078ec0ffULL, 0x000000040b087824ULL, 0x000fe200078e00ffULL,
0x00000039ff067212ULL, 0x000fe400078e33ffULL, 0x0000000339497819ULL, 0x000fe400000006ffULL,
0x0000018016027810ULL, 0x000fe40007ffe003ULL, 0xfffffff849037812ULL, 0x000fe400078ee206ULL,
0x0000000c08087812ULL, 0x000fe200078ec0ffULL, 0x0000001042427824ULL, 0x100fe200078e0202ULL,
0x000000023f3f7211ULL, 0x080fe200078e20ffULL, 0x0000001040407824ULL, 0x100fe200078e0202ULL,
0x0000000209097211ULL, 0x080fe200078e20ffULL, 0x0000001045457824ULL, 0x100fe200078e0202ULL,
0x000000023b3b7211ULL, 0x000fe200078e20ffULL, 0x0000001043437824ULL, 0x100fe200078e0202ULL,
0x0000004008407210ULL, 0x040fe20007ffe0ffULL, 0x0000001041417824ULL, 0x100fe200078e0202ULL,
0x0000004508457210ULL, 0x000fe20007ffe0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0202ULL,
0x0045800044497984ULL, 0x000fe20000000800ULL, 0x000000103e3e7824ULL, 0x000fc400078e0202ULL,
0x0000001005057824ULL, 0x100fe200078e0202ULL, 0x0000000040407984ULL, 0x000ea20000000800ULL,
0x000000100d0d7824ULL, 0x100fe400078e0202ULL, 0x000000100f0f7824ULL, 0x100fe200078e0202ULL,
0x0000000508057210ULL, 0x040fe20007ffe0ffULL, 0x0000001047477824ULL, 0x100fe200078e0202ULL,
0x0000000045457984ULL, 0x000ee20000000800ULL, 0x0000001007077824ULL, 0x100fe400078e0202ULL,
0x0000001003037824ULL, 0x000fe200078e0202ULL, 0x0000000005057984ULL, 0x000f220000000800ULL,
0x0000000108427824ULL, 0x000fc400078e0242ULL, 0x0000000108437824ULL, 0x040fe200078e0243ULL,
0x0000000417047221ULL, 0x002fe20000010100ULL, 0x0000000108417824ULL, 0x040fe400078e0241ULL,
0x00000001083f7824ULL, 0x040fe200078e023fULL, 0x0000000042427984ULL, 0x000e620000000800ULL,
0x00000001083d7824ULL, 0x000fe200078e023dULL, 0x3fb8aa3b04027820ULL, 0x000fe20000410000ULL,
0x00000001083e7824ULL, 0x040fe200078e023eULL, 0x0000000043437984ULL, 0x000f620000000800ULL,
0x0000000108097824ULL, 0x000fc400078e0209ULL, 0x00000001080d7824ULL, 0x040fe200078e020dULL,
0x0000000041417984ULL, 0x000f620000000800ULL, 0x00000001080f7824ULL, 0x040fe200078e020fULL,
0x0000000200027308ULL, 0x000ee20000000800ULL, 0x0000000108477824ULL, 0x040fe200078e0247ULL,
0x000000003f3f7984ULL, 0x000f620000000800ULL, 0x00000001083b7824ULL, 0x040fe400078e023bULL,
0x0000000108077824ULL, 0x040fe200078e0207ULL, 0x000000003d3d7984ULL, 0x000f620000000800ULL,
0x0000000108037824ULL, 0x000fc400078e0203ULL, 0x000000ffff047224ULL, 0x000fe200078e003cULL,
0x000000003e3e7984ULL, 0x000f620000000800ULL, 0x30000040ff4b7230ULL, 0x004fc60000004100ULL,
0x0000000009097984ULL, 0x000ea20000000800ULL, 0x0000030004007a0cULL, 0x000fe20003f06070ULL,
0x0000004902597220ULL, 0x008fe40000410000ULL, 0x000000000d0d7984ULL, 0x000ee20000000800ULL,
0x20000045ff527230ULL, 0x100fe20000004100ULL, 0x0000003859387221ULL, 0x000fe20000010000ULL,
0x30000045ff457230ULL, 0x000fe20000004100ULL, 0x000000000f0f7984ULL, 0x000ee20000000800ULL,
0x20000005ff487230ULL, 0x110fe40000004100ULL, 0x30000005ff517230ULL, 0x000fe20000004100ULL,
0x0000000047477984ULL, 0x000f280000000800ULL, 0x000000003b3b7984ULL, 0x000f220000000800ULL,
0x20000042ff0c7230ULL, 0x002fc40000004100ULL, 0x30000042ff497230ULL, 0x000fe20000004100ULL,
0x0000000007077984ULL, 0x000e620000000800ULL, 0x20000040ff427230ULL, 0x000fe40000004100ULL,
0x20000043ff067230ULL, 0x020fe20000004100ULL, 0x0000000003037984ULL, 0x000f620000000800ULL,
0x20000041ff0e7230ULL, 0x000fe40000004100ULL, 0x30000043ff437230ULL, 0x000fe40000004100ULL,
0x2000003fff407230ULL, 0x000fc40000004100ULL, 0x30000041ff417230ULL, 0x000fe40000004100ULL,
0x2000003dff447230ULL, 0x000fe40000004100ULL, 0x3000003fff3f7230ULL, 0x000fe40000004100ULL,
0x2000003eff467230ULL, 0x100fe40000004100ULL, 0x3000003eff4d7230ULL, 0x000fe40000004100ULL,
0x20000009ff4c7230ULL, 0x004fc40000004100ULL, 0x3000003dff3d7230ULL, 0x000fe40000004100ULL,
0x2000000dff4e7230ULL, 0x008fe40000004100ULL, 0x30000009ff097230ULL, 0x000fe40000004100ULL,
0x2000000fff507230ULL, 0x000fe40000004100ULL, 0x3000000dff0d7230ULL, 0x000fe40000004100ULL,
0x20000047ff547230ULL, 0x010fc40000004100ULL, 0x3000000fff0f7230ULL, 0x000fe40000004100ULL,
0x2000003bff3e7230ULL, 0x100fe40000004100ULL, 0x3000003bff4f7230ULL, 0x000fe40000004100ULL,
0x20000007ff4a7230ULL, 0x102fe40000004100ULL, 0x30000007ff537230ULL, 0x000fe40000004100ULL,
0x30000047ff477230ULL, 0x000fc40000004100ULL, 0x20000003ff567230ULL, 0x120fe40000004100ULL,
0x30000003ff577230ULL, 0x000fe20000004100ULL, 0x00006b127f007947ULL, 0x000fea000b800000ULL,
0x00001f3a593a7589ULL, 0x0002a400000e0000ULL, 0x00006b727f007947ULL, 0x000fea000b800000ULL,
0x00001f3959057589ULL, 0x00072400000e0000ULL, 0x0000003a06377223ULL, 0x084fe20000010037ULL,
0x0000003a43367223ULL, 0x080fe20000010036ULL, 0x0000003a0c337223ULL, 0x080fe20000010033ULL,
0x0000003a49327223ULL, 0x080fe20000010032ULL, 0x0000003a0e2f7223ULL, 0x080fe2000001002fULL,
0x0000003a412e7223ULL, 0x080fe2000001002eULL, 0x0000003a422b7223ULL, 0x080fe2000001002bULL,
0x0000003a4b2a7223ULL, 0x080fe2000001002aULL, 0x0000003a40277223ULL, 0x080fe20000010027ULL,
0x0000003a3f267223ULL, 0x080fe20000010026ULL, 0x0000003a44237223ULL, 0x080fe20000010023ULL,
0x0000003a3d227223ULL, 0x080fe20000010022ULL, 0x0000003a461f7223ULL, 0x080fe2000001001fULL,
0x0000003a4d1e7223ULL, 0x080fe2000001001eULL, 0x0000003a3e1b7223ULL, 0x080fe2000001001bULL,
0x0000003a4f1a7223ULL, 0x000fe2000001001aULL, 0x0000000548357223ULL, 0x090fe20000010035ULL,
0x0000000551347223ULL, 0x080fe20000010034ULL, 0x000000054a317223ULL, 0x080fe20000010031ULL,
0x0000000553307223ULL, 0x080fe20000010030ULL, 0x000000054c2d7223ULL, 0x080fe2000001002dULL,
0x00000005092c7223ULL, 0x080fe2000001002cULL, 0x000000054e297223ULL, 0x080fe20000010029ULL,
0x000000050d287223ULL, 0x080fe20000010028ULL, 0x0000000550257223ULL, 0x080fe20000010025ULL,
0x000000050f247223ULL, 0x080fe20000010024ULL, 0x0000000552217223ULL, 0x080fe20000010021ULL,
0x0000000545207223ULL, 0x080fe20000010020ULL, 0x00000005541d7223ULL, 0x080fe2000001001dULL,
0x00000005471c7223ULL, 0x080fe2000001001cULL, 0x0000000556197223ULL, 0x080fe20000010019ULL,
0x0000000557187223ULL, 0x000fe20000010018ULL, 0xfffff24000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x002e620000000000ULL,
0x000000ff5500720cULL, 0x000fe20003f05270ULL, 0x0000001002037824ULL, 0x002fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011602ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c02027812ULL, 0x000fca00078ec0ffULL, 0x0000000103047824ULL, 0x000fe200078e0202ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x0000000402037819ULL, 0x002fe400000006ffULL, 0x00000001ff027819ULL, 0x000fe40000011602ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c02057812ULL, 0x000fc600078ec0ffULL,
0x000000800a027824ULL, 0x000fc800078e0203ULL, 0x0000000105037824ULL, 0x000fca00078e0202ULL,
0x0049803803007388ULL, 0x0003e40000000800ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0049800004027984ULL, 0x000ea80000000800ULL, 0x004a000004037984ULL, 0x002e620000000800ULL,
0x00000002ff027221ULL, 0x004fc80000010000ULL, 0x0000000302027221ULL, 0x002fca0000010000ULL,
0x0180000002037810ULL, 0x000fc80007ffe0ffULL, 0x7f80000003037812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000098b000057802ULL, 0x000fe40000000f00ULL,
0x00006c3000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e0008ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000200037308ULL, 0x000e640000001000ULL,
0xbf80000002047423ULL, 0x002fc80000000003ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000403037223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000b7919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000080b027811ULL, 0x006fe200078ff0ffULL, 0x0000000100007824ULL, 0x100fe200078e020bULL,
0x00000002ff067819ULL, 0x000fe4000001160bULL, 0x00000002ff077212ULL, 0x000fe200078e33ffULL,
0x00001f0203057589ULL, 0x000e6200000e0000ULL, 0x00000003020c7819ULL, 0x000fe200000006ffULL,
0x0000000806087824ULL, 0x000fc400078e00ffULL, 0x00001f0603047589ULL, 0x00052200000e0000ULL,
0xfffffff80c397812ULL, 0x008fe200078ee207ULL, 0x0000001000007824ULL, 0x000fc800078e0211ULL,
0x0000001039397824ULL, 0x000fe200078e0210ULL, 0x00000006ff037212ULL, 0x004fc800078e33ffULL,
0xfffffff808177812ULL, 0x000fe200078ee203ULL, 0x0000000806037824ULL, 0x000fe200078e00ffULL,
0x0000000702087812ULL, 0x000fc600078ec0ffULL, 0x0000001017177824ULL, 0x000fe200078e0210ULL,
0x0000003505357220ULL, 0x042fe20000410000ULL, 0x0000003405347220ULL, 0x040fe20000410000ULL,
0x0000003105317220ULL, 0x040fe20000410000ULL, 0x0000003005307220ULL, 0x040fe20000410000ULL,
0x0000002d052d7220ULL, 0x040fe20000410000ULL, 0x0000002c052c7220ULL, 0x040fe20000410000ULL,
0x0000002905297220ULL, 0x040fe20000410000ULL, 0x0000002805287220ULL, 0x040fe20000410000ULL,
0x0000002505257220ULL, 0x040fe20000410000ULL, 0x0000002405247220ULL, 0x040fe20000410000ULL,
0x0000002105217220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000001d051d7220ULL, 0x040fe20000410000ULL, 0x0000001c051c7220ULL, 0x040fe20000410000ULL,
0x0000001905197220ULL, 0x040fe20000410000ULL, 0x0000001805187220ULL, 0x000fe20000410000ULL,
0x0000000706057812ULL, 0x000fe200078ec0ffULL, 0x0000003704377220ULL, 0x050fe20000410000ULL,
0x0000003604367220ULL, 0x040fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000003204327220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000000105077812ULL, 0x040fe200078e3cffULL, 0x0000001a04047220ULL, 0x000fe20000410000ULL,
0x0000000205097812ULL, 0x000fc400078e3cffULL, 0x00000003050d7812ULL, 0x040fe200078e3cffULL,
0x0000000806077824ULL, 0x040fe200078e0207ULL, 0x00000004050f7812ULL, 0x040fe200078e3cffULL,
0x0000000806097824ULL, 0x040fe200078e0209ULL, 0x0000000505137812ULL, 0x000fe200078e3cffULL,
0x0000001007077824ULL, 0x100fe200078e0210ULL, 0x0000000605057812ULL, 0x000fe200078e3cffULL,
0x00000008060f7824ULL, 0x000fe200078e020fULL, 0x000000232222723eULL, 0x000fe200000000ffULL,
0x0000000806137824ULL, 0x000fe200078e0213ULL, 0x0000001f1e1e723eULL, 0x000fe200000000ffULL,
0x0000000806157824ULL, 0x000fe200078e0205ULL, 0x000000212020723eULL, 0x000fe200000000ffULL,
0x000000040b057824ULL, 0x000fe200078e00ffULL, 0x0000001d1c1c723eULL, 0x000fe200000000ffULL,
0x0000001009097824ULL, 0x100fe200078e0210ULL, 0x000000191818723eULL, 0x000fe200000000ffULL,
0x0000000802197824ULL, 0x000fe200078e00ffULL, 0x0000001b0404723eULL, 0x000fe200000000ffULL,
0x000000100f0f7824ULL, 0x100fe200078e0210ULL, 0x000000252424723eULL, 0x000fe200000000ffULL,
0x0000001015157824ULL, 0x000fe200078e0210ULL, 0xfffffff803037812ULL, 0x000fc400078ee206ULL,
0x00000002081d7812ULL, 0x040fe400078e3cffULL, 0x00000003081f7812ULL, 0x040fe200078e3cffULL,
0x0000001003037824ULL, 0x100fe200078e0210ULL, 0x0000000408217812ULL, 0x000fe200078e3cffULL,
0x00000008021d7824ULL, 0x000fe200078e021dULL, 0x0000000508237812ULL, 0x000fe200078e3cffULL,
0x00000008021f7824ULL, 0x000fe200078e021fULL, 0x00000001081b7812ULL, 0x000fe200078e3cffULL,
0x0000000802217824ULL, 0x000fe200078e0221ULL, 0x0000000608257812ULL, 0x000fe200078e3cffULL,
0x0000000802237824ULL, 0x000fe200078e0223ULL, 0x0000000d060d7211ULL, 0x000fe200078e18ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0210ULL, 0xfffffff819197812ULL, 0x000fe200078ee202ULL,
0x000000101f1f7824ULL, 0x100fe200078e0210ULL, 0x0000001b021b7211ULL, 0x040fe200078e18ffULL,
0x000000100d0d7824ULL, 0x100fe200078e0210ULL, 0x0000002502257211ULL, 0x000fe200078e18ffULL,
0x0000001019197824ULL, 0x100fe200078e0210ULL, 0x0000000c05027812ULL, 0x000fe200078ec0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0210ULL, 0x000000373636723eULL, 0x000fe200000000ffULL,
0x0000001023237824ULL, 0x100fe200078e0210ULL, 0x0000000203037210ULL, 0x000fe20007ffe0ffULL,
0x0000000102077824ULL, 0x000fe200078e0207ULL, 0x000000333232723eULL, 0x000fe200000000ffULL,
0x0000000102097824ULL, 0x040fe200078e0209ULL, 0x0000001013137211ULL, 0x080fe200078e20ffULL,
0x00000001020d7824ULL, 0x000fe200078e020dULL, 0x0000002f2e2e723eULL, 0x000fe200000000ffULL,
0x00000001020f7824ULL, 0x000fe200078e020fULL, 0x0000002b2a2a723eULL, 0x000fe200000000ffULL,
0x0000003603007388ULL, 0x000fe20000000800ULL, 0x000000272626723eULL, 0x000fe200000000ffULL,
0x0000000102157824ULL, 0x040fe200078e0215ULL, 0x0000001302137210ULL, 0x040fe20007ffe0ffULL,
0x0000003207007388ULL, 0x000fe20000000800ULL, 0x0000000102177824ULL, 0x000fe200078e0217ULL,
0x000000353434723eULL, 0x000fe200000000ffULL, 0x0000000102197824ULL, 0x040fe200078e0219ULL,
0x0000002e09007388ULL, 0x000fe20000000800ULL, 0x0000001021217211ULL, 0x000fe200078e20ffULL,
0x00000001021b7824ULL, 0x000fe200078e021bULL, 0x000000313030723eULL, 0x000fe200000000ffULL,
0x0000002a0d007388ULL, 0x000fe20000000800ULL, 0x0000002d2c2c723eULL, 0x000fe200000000ffULL,
0x0000001025257824ULL, 0x000fe200078e0210ULL, 0x000000292828723eULL, 0x000fe200000000ffULL,
0x000000260f007388ULL, 0x000fe20000000800ULL, 0x00000001021d7824ULL, 0x040fe200078e021dULL,
0x0000002102217210ULL, 0x040fe20007ffe0ffULL, 0x00000001021f7824ULL, 0x040fe200078e021fULL,
0x0000002213007388ULL, 0x000fe20000000800ULL, 0x0000000102237824ULL, 0x040fe200078e0223ULL,
0x0000003902397210ULL, 0x040fe20007ffe0ffULL, 0x0000000102257824ULL, 0x000fe200078e0225ULL,
0x0000001e15007388ULL, 0x000fe80000000800ULL, 0x0000000417007388ULL, 0x000fe80000000800ULL,
0x0000003419007388ULL, 0x000fe80000000800ULL, 0x000000301b007388ULL, 0x000fe80000000800ULL,
0x0000002c1d007388ULL, 0x000fe80000000800ULL, 0x000000281f007388ULL, 0x000fe80000000800ULL,
0x0000002421007388ULL, 0x000fe80000000800ULL, 0x0000002023007388ULL, 0x000fe80000000800ULL,
0x0000001c25007388ULL, 0x000fe80000000800ULL, 0x0000001839007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000000047984ULL, 0x000e680000000c00ULL,
0x0004000000147984ULL, 0x000ea80000000c00ULL, 0x00080000000c7984ULL, 0x000ee80000000c00ULL,
0x000c0000002c7984ULL, 0x000f220000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x004fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x0000000f07077230ULL, 0x008fe40000000000ULL,
0x0000000e06067230ULL, 0x000fe40000000000ULL, 0x0000000d05057230ULL, 0x000fe40000000000ULL,
0x0000000c04047230ULL, 0x000fe40000000000ULL, 0x0000002f17177230ULL, 0x010fc40000000000ULL,
0x0000002e16167230ULL, 0x000fe20000000000ULL, 0x0000000400007388ULL, 0x0003e20000000c00ULL,
0x0000002d15157230ULL, 0x000fe40000000000ULL, 0x0000002c14147230ULL, 0x000fca0000000000ULL,
0x0004001400007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000187919ULL, 0x002e620000002600ULL, 0x000000200b1b7810ULL, 0x040fe20007ffe0ffULL,
0x00000000000479c3ULL, 0x000ee20000002700ULL, 0x000000400b1d7810ULL, 0x040fe20007ffe0ffULL,
0x0000580000057ab9ULL, 0x000fe20000000800ULL, 0x00000003ff027819ULL, 0x000fe2000001160bULL,
0x0000000405057899ULL, 0x000fe2000800063fULL, 0x000000600b1e7810ULL, 0x000fe20007ffe0ffULL,
0x00000008551c7824ULL, 0x040fe200078e00ffULL, 0x00000003ff037819ULL, 0x000fe2000001161bULL,
0x0000000855207824ULL, 0x040fe200078e00ffULL, 0x00000003ff087819ULL, 0x000fe2000001161dULL,
0x00000008551f7824ULL, 0x000fe200078e00ffULL, 0x00000003ff097819ULL, 0x000fc4000001161eULL,
0x0000000702067812ULL, 0x000fe400078e480bULL, 0x0000000708047812ULL, 0x004fe400078e481dULL,
0x0ffffff8060c7812ULL, 0x000fe400078ef80bULL, 0x0ffffff804067812ULL, 0x000fe400078ef81dULL,
0x00000003551a7819ULL, 0x000fe200000006ffULL, 0x000000100c047824ULL, 0x100fe200078e0211ULL,
0x0000000418057819ULL, 0x002fe200000006ffULL, 0x0000001006107824ULL, 0x000fe200078e0211ULL,
0x00000004050472a4ULL, 0x008fe2000f8e023fULL, 0xfffffff81a217812ULL, 0x000fe200078ee20bULL,
0x0000001018197824ULL, 0x000fe200078e00ffULL, 0xfffffff005007812ULL, 0x000fc400078ee202ULL,
0x0000000703027812ULL, 0x100fe400078e481bULL, 0x0000000709057812ULL, 0x100fe400078e481eULL,
0x0ffffff802027812ULL, 0x000fe400078ef81bULL, 0x0ffffff8050a7812ULL, 0x000fe400078ef81eULL,
0x0000000004047984ULL, 0x000e620000000c00ULL, 0x0000001002027824ULL, 0x100fe200078e0211ULL,
0x00000004000b7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0211ULL,
0x00000004181a7819ULL, 0x040fe200000006ffULL, 0x0000000010107984ULL, 0x000fe20000000c00ULL,
0x0000001018007824ULL, 0x000fe200078e00ffULL, 0xfffffff019087812ULL, 0x000fe200078ee208ULL,
0x000000ffff187224ULL, 0x000fe200000e06ffULL, 0x00000000020c7984ULL, 0x0004e20000000c00ULL,
0xfffffff81c1b7812ULL, 0x000fc400078ee21bULL, 0xfffffff000007812ULL, 0x000fe200078ee203ULL,
0x000000000a147984ULL, 0x0009620000000c00ULL, 0xfffffff01a097812ULL, 0x000fe400078ee209ULL,
0xfffffff8201d7812ULL, 0x000fe400078ee21dULL, 0x00005a000b027a11ULL, 0x004fe400078040ffULL,
0xfffffff81f1f7812ULL, 0x000fe400078ee21eULL, 0x00005b000b037a11ULL, 0x000fc400000f4418ULL,
0x00000004001c7c10ULL, 0x000fe4000ff1e0ffULL, 0x00000004080b7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001021027825ULL, 0x000fe200078e0002ULL, 0x0000000409007c10ULL, 0x000fc6000ff5e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005a001c087a11ULL, 0x000fe200078040ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x00005a000b0a7a11ULL, 0x050fe400078240ffULL,
0x000000ffff197210ULL, 0x000fe400017fe4ffULL, 0x00005a0000187a11ULL, 0x000fe400078440ffULL,
0x00005b001c097a11ULL, 0x000fe200000f4409ULL, 0x0000000402007986ULL, 0x002fe2000c101d06ULL,
0x00005b000b0b7a11ULL, 0x000fc400008f441aULL, 0x00005b0000197a11ULL, 0x000fe200010f4419ULL,
0x000000101b087825ULL, 0x000fc800078e0008ULL, 0x000000101d0a7825ULL, 0x000fe200078e000aULL,
0x0000000c08007986ULL, 0x008fe6000c101d06ULL, 0x000000101f187825ULL, 0x000fe200078e0018ULL,
0x000000100a007986ULL, 0x000fe8000c101d06ULL, 0x0000001418007986ULL, 0x020fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000159057810ULL, 0x00afe20007ffe0ffULL,
0x000000020c037824ULL, 0x000fc400078e00ffULL, 0x0000004057627824ULL, 0x000fe200078e00ffULL,
0x000000540500720cULL, 0x000fe20003f06070ULL, 0x0000580003647a24ULL, 0x000fe400078e0264ULL,
0x0000010059077824ULL, 0x000fc800078e0262ULL, 0x0000620064167a24ULL, 0x000fcc00078e0207ULL,
0x000005c000008947ULL, 0x000fea0003800000ULL, 0x00000000000d7919ULL, 0x000e620000000000ULL,
0x00000100ff1f7424ULL, 0x000fe200078e00ffULL, 0x0000000756007217ULL, 0x000fe40007800000ULL,
0x0000100057127811ULL, 0x000fe400078e68ffULL, 0x0000000007007210ULL, 0x000fe40007ffe1ffULL,
0x00000002ff1b7819ULL, 0x002fe4000001160dULL, 0x000000040d1d7819ULL, 0x000fc400000006ffULL,
0x000000081b0f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000116027824ULL, 0x040fe200078e021bULL,
0x000000181b237810ULL, 0x040fe40007ffe0ffULL, 0x000000101b217810ULL, 0x000fe20007ffe0ffULL,
0x0000000116047824ULL, 0x000fe200078e020fULL, 0x000000301d1d7812ULL, 0x000fe200078ec0ffULL,
0x00005e0002027625ULL, 0x080fe200078e001fULL, 0x000000201b157810ULL, 0x000fe40007ffe0ffULL,
0x00000003ff107819ULL, 0x000fe2000001160dULL, 0x00005e0004047625ULL, 0x000fe200078e001fULL,
0x0000001d020a7210ULL, 0x000fc40007f1e0ffULL, 0x0000000310107812ULL, 0x000fe200078e480dULL,
0x0000000116087824ULL, 0x000fe200078e0223ULL, 0x0000001d04047210ULL, 0x000fe20007f3e0ffULL,
0x0000000116067824ULL, 0x000fe200078e0221ULL, 0x000000281b177810ULL, 0x040fe20007ffe0ffULL,
0x00005e0008087625ULL, 0x080fe200078e001fULL, 0x0ffffffc100d7812ULL, 0x000fe400078ef80dULL,
0x000000301b197810ULL, 0x000fe20007ffe0ffULL, 0x0000000116027824ULL, 0x000fe200078e0215ULL,
0x000000002100720cULL, 0x080fe20003fa6070ULL, 0x00005e0006067625ULL, 0x000fe200078e001fULL,
0x000000001500720cULL, 0x000fc40003f66070ULL, 0x000000002300720cULL, 0x000fe20003f86070ULL,
0x000000ffff0b7224ULL, 0x000fe200000e0603ULL, 0x0000001d06067210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e0605ULL, 0x0000001d08087210ULL, 0x000fe20007f3e0ffULL,
0x00005e0002027625ULL, 0x000fc600078e001fULL, 0x00000009ff097210ULL, 0x000fe20000ffe4ffULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x0000001d020c7210ULL, 0x000fe20007f5e0ffULL,
0x000000100d117824ULL, 0x000fe200078e0212ULL, 0x000000000f00720cULL, 0x0c0fe20003f26070ULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0x0000001716027210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e0603ULL, 0x000000001b00720cULL, 0x000fe40003f06070ULL,
0xfffffffc0f0f7812ULL, 0x000fe200078ee210ULL, 0x00005e0002027625ULL, 0x000fe200078e001fULL,
0x000000381b1b7810ULL, 0x000fc40007ffe0ffULL, 0x000000001700720cULL, 0x000fe20003f46070ULL,
0x000000100f137824ULL, 0x000fe200078e0212ULL, 0x0000001d020e7210ULL, 0x000fe40007fde0ffULL,
0x0000001916027210ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a117faeULL, 0x0003e2000c101c46ULL, 0x000000ffff0f7224ULL, 0x000fe200030e0603ULL,
0x000000001b00720cULL, 0x080fe20003f06070ULL, 0x00005e0002027625ULL, 0x000fe200078e001fULL,
0x0000000004137faeULL, 0x0005e2000c901c46ULL, 0x000000001900720cULL, 0x000fc60003f26070ULL,
0x0000001d02027210ULL, 0x000fe20007fde0ffULL, 0x00000004210b7824ULL, 0x002fc600078e00ffULL,
0x00000003ff037210ULL, 0x000fe200037fe4ffULL, 0x0000000423117824ULL, 0x000fe400078e00ffULL,
0x0000000116047824ULL, 0x004fe200078e021bULL, 0xfffffffc0b0b7812ULL, 0x100fe200078ee210ULL,
0x0000000415137824ULL, 0x000fe200078e00ffULL, 0xfffffffc11117812ULL, 0x100fe200078ee210ULL,
0x0000000417157824ULL, 0x000fe400078e00ffULL, 0x0000000419177824ULL, 0x000fe200078e00ffULL,
0xfffffffc13137812ULL, 0x100fe200078ee210ULL, 0x000000041b197824ULL, 0x000fe200078e00ffULL,
0xfffffffc15157812ULL, 0x100fe200078ee210ULL, 0x00005e0004047625ULL, 0x000fe200078e001fULL,
0xfffffffc17177812ULL, 0x000fc400078ee210ULL, 0xfffffffc19197812ULL, 0x000fe200078ee210ULL,
0x000000100b0b7824ULL, 0x100fe200078e0212ULL, 0x0000001d04047210ULL, 0x000fe20007fde0ffULL,
0x0000001011117824ULL, 0x100fe200078e0212ULL, 0x0000001217177211ULL, 0x000fe200078e20ffULL,
0x0000001013137824ULL, 0x100fe200078e0212ULL, 0x00000000060b7faeULL, 0x0003e2000e901c46ULL,
0x0000001015157824ULL, 0x100fe400078e0212ULL, 0x0000001019197824ULL, 0x000fe200078e0212ULL,
0x0000000008117faeULL, 0x0003e2000e101c46ULL, 0x000000ffff057224ULL, 0x000fc600030e0605ULL,
0x000000000c137faeULL, 0x0003e8000d901c46ULL, 0x000000000e157faeULL, 0x0003e8000d101c46ULL,
0x0000000002177faeULL, 0x0003e8000c901c46ULL, 0x0000000004197faeULL, 0x0003e2000c101c46ULL,
0x0000050000007947ULL, 0x000fea0003800000ULL, 0x00000000000d7919ULL, 0x000e620000000000ULL,
0x00000100ff217424ULL, 0x000fe200078e00ffULL, 0x00001000571f7811ULL, 0x000fe200078e68ffULL,
0x000000100d047824ULL, 0x042fe200078e00ffULL, 0x000000100d037811ULL, 0x000fc400078ff0ffULL,
0x000000160d027211ULL, 0x000fe400078ff0ffULL, 0x00000003ff007819ULL, 0x000fe2000001160dULL,
0x0000000403117824ULL, 0x000fe200078e00ffULL, 0x000000080d0b7811ULL, 0x040fe400078ff0ffULL,
0x0000003004237812ULL, 0x000fe200078ec0ffULL, 0x0000000116047824ULL, 0x000fe200078e0203ULL,
0x000000200d077811ULL, 0x040fe200078ff0ffULL, 0x00005e0002027625ULL, 0x000fe200078e0021ULL,
0x000000180d057811ULL, 0x000fc400078ff0ffULL, 0x0000000300187812ULL, 0x000fe200078e480dULL,
0x000000040b0f7824ULL, 0x000fe200078e00ffULL, 0x0000000b16007210ULL, 0x040fe20007ffe0ffULL,
0x00000001160b7824ULL, 0x040fe200078e0207ULL, 0x000000280d087811ULL, 0x000fe200078ff0ffULL,
0x0000000407077824ULL, 0x000fe200078e00ffULL, 0x000000300d097811ULL, 0x040fe200078ff0ffULL,
0x0000000116067824ULL, 0x040fe200078e0205ULL, 0x000000380d0a7811ULL, 0x000fe200078ff0ffULL,
0x0000000116127824ULL, 0x000fe200078e0208ULL, 0x00000023020c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000408137824ULL, 0x000fe200078e00ffULL, 0x0000000205057819ULL, 0x000fe200000006ffULL,
0x000000040a177824ULL, 0x000fe200078e00ffULL, 0x0000000916147210ULL, 0x040fe20007ffe0ffULL,
0x0000000116167824ULL, 0x000fe200078e020aULL, 0x0ffffffc18107812ULL, 0x000fe200078ef80dULL,
0x000000ffff0d7224ULL, 0x000fe200000e0603ULL, 0xfffffffc070e7812ULL, 0x100fe200078ee218ULL,
0x0000000409157824ULL, 0x000fe200078e00ffULL, 0xfffffffc050a7812ULL, 0x100fe200078ee218ULL,
0x00005e0000027625ULL, 0x000fe200078e0021ULL, 0xfffffffc0f087812ULL, 0x000fc400078ee218ULL,
0xfffffffc11097812ULL, 0x100fe200078ee218ULL, 0x00005e0004047625ULL, 0x000fe200078e0021ULL,
0xfffffffc130f7812ULL, 0x100fe400078ee218ULL, 0xfffffffc15117812ULL, 0x100fe200078ee218ULL,
0x000000100e197824ULL, 0x100fe200078e021fULL, 0x0000001f10257211ULL, 0x000fe200078e20ffULL,
0x00005e0006067625ULL, 0x000fe200078e0021ULL, 0x00000023020e7210ULL, 0x080fe40007f1e0ffULL,
0x0000002304107210ULL, 0x000fe20007f3e0ffULL, 0x00000010111d7824ULL, 0x000fe200078e021fULL,
0x0000001f0f1b7211ULL, 0x000fe200078e20ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e0603ULL,
0x0000002306067210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0605ULL,
0xfffffffc17187812ULL, 0x000fe200078ee218ULL, 0x00005e000b027625ULL, 0x000fe200078e0021ULL,
0x00000007ff077210ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c257faeULL, 0x0003e4000b901c46ULL, 0x0000001008137824ULL, 0x100fe200078e021fULL,
0x0000002302027210ULL, 0x000fe20007f1e0ffULL, 0x0000001009157824ULL, 0x000fc400078e021fULL,
0x00005e0012047625ULL, 0x000fe200078e0021ULL, 0x000000000e137faeULL, 0x0003e6000b901c46ULL,
0x000000100a177824ULL, 0x000fe200078e021fULL, 0x0000002304047210ULL, 0x000fe20007f3e0ffULL,
0x00005e0014087625ULL, 0x080fe200078e0021ULL, 0x0000000010157faeULL, 0x0003e6000b901c46ULL,
0x00005e00160a7625ULL, 0x000fe200078e0021ULL, 0x0000002308087210ULL, 0x080fe20007f5e0ffULL,
0x0000000006177faeULL, 0x0003e4000b901c46ULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x000000230a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff057224ULL, 0x000fc400008e0605ULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x0000000002197faeULL, 0x0003e2000b901c46ULL,
0x00000010181f7824ULL, 0x000fe400078e021fULL, 0x000000ffff0b7224ULL, 0x000fe200018e060bULL,
0x00000000041b7faeULL, 0x0003e8000b901c46ULL, 0x00000000081d7faeULL, 0x0003e8000b901c46ULL,
0x000000000a1f7faeULL, 0x0003e4000b901c46ULL, 0x01360400ff007984ULL, 0x000ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000000ff7812ULL, 0x004fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e00000000007802ULL, 0x000fc80000000f00ULL, 0x0000000000027305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x01360400ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000545900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000097919ULL, 0x002e620000000000ULL, 0x0000001057067824ULL, 0x000fe200078e00ffULL,
0xffffffff54607810ULL, 0x000fe40007ffe0ffULL, 0x00007610ff5e7816ULL, 0x000fe4000000005eULL,
0x0000010059077824ULL, 0x002fe200078e0262ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000075600720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000159037810ULL, 0x000fe20007ffe0ffULL, 0x000009e000007945ULL, 0x000fe20003800000ULL,
0x00006200646c7a24ULL, 0x000fe400078e0207ULL, 0x000000540300720cULL, 0x000fe20003f06070ULL,
0x00000100ff057424ULL, 0x000fd800078e00ffULL, 0x0000052000008947ULL, 0x000fea0003800000ULL,
0x00000002ff117819ULL, 0x002fe20000011609ULL, 0x0000000156087824ULL, 0x000fe200078e0a07ULL,
0x00000003ff007819ULL, 0x000fe40000011609ULL, 0x00000008110b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000900047212ULL, 0x000fe400078e3cffULL, 0x0000006c11027210ULL, 0x000fe20007ffe0ffULL,
0x000000010b0a7824ULL, 0x000fe200078e026cULL, 0x00000003096b7812ULL, 0x000fe200078ec0ffULL,
0x000000040b0d7824ULL, 0x000fe200078e00ffULL, 0x0000000304047812ULL, 0x000fe200078ec0ffULL,
0x00005e0002027625ULL, 0x000fe200078e0005ULL, 0x000000081100720cULL, 0x000fc40003f26070ULL,
0x000000080b00720cULL, 0x080fe20003f46070ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0005ULL,
0x000000046b157812ULL, 0x000fe400078efcffULL, 0x0000200057177811ULL, 0x000fe400078e68ffULL,
0x0ffffffc046a7812ULL, 0x000fe200078ef809ULL, 0x0000001015027825ULL, 0x000fe200078e0002ULL,
0xfffffffc0d0c7812ULL, 0x000fe400078ee204ULL, 0x0000001011197810ULL, 0x040fe20007ffe0ffULL,
0x000000106a0d7824ULL, 0x100fe200078e0217ULL, 0x00000018111b7810ULL, 0x040fe20007ffe0ffULL,
0x000000100c0f7824ULL, 0x000fe200078e0217ULL, 0x00000020111d7810ULL, 0x000fe20007ffe0ffULL,
0x00000010150a7825ULL, 0x000fe200078e000aULL, 0x00000028111f7810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020d7faeULL, 0x0003e2000c901c46ULL,
0x0000003011217810ULL, 0x000fe20007ffe0ffULL, 0x000000011d0c7824ULL, 0x100fe200078e026cULL,
0x0000003811237810ULL, 0x000fe20007ffe0ffULL, 0x000000000a0f7faeULL, 0x0005e2000d101c46ULL,
0x000000081900720cULL, 0x000fe20003f26070ULL, 0x000000011f0e7824ULL, 0x100fe200078e026cULL,
0x0000006c23127210ULL, 0x000fe20007ffe0ffULL, 0x0000000121107824ULL, 0x000fe200078e026cULL,
0x000000081b00720cULL, 0x000fc40003f46070ULL, 0x000000081d00720cULL, 0x040fe20003f66070ULL,
0x000000041d1d7824ULL, 0x000fe200078e00ffULL, 0x0000006c19027210ULL, 0x042fe20007ffe0ffULL,
0x0000000419197824ULL, 0x000fe200078e00ffULL, 0x000000081f00720cULL, 0x080fe20003f86070ULL,
0x000000011b0a7824ULL, 0x004fe200078e026cULL, 0x000000082100720cULL, 0x080fe20003fa6070ULL,
0x000000041b1b7824ULL, 0x000fe200078e00ffULL, 0x000000082300720cULL, 0x000fe20003fc6070ULL,
0x00005e0002027625ULL, 0x000fe200078e0005ULL, 0x0000000221217819ULL, 0x000fc400000006ffULL,
0xfffffffc19087812ULL, 0x100fe200078ee204ULL, 0x00005e000a0a7625ULL, 0x080fe200078e0005ULL,
0xfffffffc1b147812ULL, 0x100fe400078ee204ULL, 0xfffffffc1d167812ULL, 0x100fe200078ee204ULL,
0x00005e000c0c7625ULL, 0x000fe200078e0005ULL, 0xfffffffc211a7812ULL, 0x000fc600078ee204ULL,
0x00005e000e0e7625ULL, 0x000fc800078e0005ULL, 0x00005e0010107625ULL, 0x000fc800078e0005ULL,
0x00005e0012127625ULL, 0x000fc800078e0005ULL, 0x000000041f1f7824ULL, 0x000fe400078e00ffULL,
0x0000000423237824ULL, 0x000fe400078e00ffULL, 0x0000001015027825ULL, 0x000fe200078e0002ULL,
0xfffffffc1f187812ULL, 0x100fe400078ee204ULL, 0xfffffffc231c7812ULL, 0x000fe200078ee204ULL,
0x00000010150a7825ULL, 0x000fe200078e000aULL, 0x00000017181d7211ULL, 0x000fc600078e20ffULL,
0x00000010150c7825ULL, 0x000fc800078e000cULL, 0x00000010150e7825ULL, 0x000fc800078e000eULL,
0x0000001015107825ULL, 0x000fc800078e0010ULL, 0x0000001015127825ULL, 0x000fc800078e0012ULL,
0x0000001008157824ULL, 0x100fe400078e0217ULL, 0x0000001014197824ULL, 0x100fe400078e0217ULL,
0x00000010161b7824ULL, 0x100fe200078e0217ULL, 0x0000000002157faeULL, 0x0003e2000c901c46ULL,
0x000000101a1f7824ULL, 0x100fe400078e0217ULL, 0x000000101c177824ULL, 0x000fe200078e0217ULL,
0x000000000a197faeULL, 0x0003e8000d101c46ULL, 0x000000000c1b7faeULL, 0x0003e8000d901c46ULL,
0x000000000e1d7faeULL, 0x0003e8000e101c46ULL, 0x00000000101f7faeULL, 0x0003e8000e901c46ULL,
0x0000000012177faeULL, 0x0003e2000f101c46ULL, 0x0000047000007947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x002fe40000011609ULL, 0x00000008091b7811ULL, 0x000fc400078ff0ffULL,
0x00000010091d7811ULL, 0x040fe400078ff0ffULL, 0x00000018091f7811ULL, 0x000fe200078ff0ffULL,
0x000000011b0a7824ULL, 0x100fe200078e026cULL, 0x0000002009217811ULL, 0x000fe200078ff0ffULL,
0x000000011d0c7824ULL, 0x100fe200078e026cULL, 0x0000002809237811ULL, 0x000fe200078ff0ffULL,
0x000000041d1d7824ULL, 0x000fe200078e00ffULL, 0x0000003009277811ULL, 0x000fe200078ff0ffULL,
0x0000000121107824ULL, 0x100fe200078e026cULL, 0x0000003809297811ULL, 0x000fe200078ff0ffULL,
0x0000000123127824ULL, 0x100fe200078e026cULL, 0x0000000900047212ULL, 0x000fe200078e3cffULL,
0x0000000127147824ULL, 0x100fe200078e026cULL, 0x0000006c09027211ULL, 0x080fe200078ff0ffULL,
0x0000000129167824ULL, 0x000fe200078e026cULL, 0x0000006c1f0e7210ULL, 0x040fe20007ffe0ffULL,
0x000000041f1f7824ULL, 0x000fe200078e00ffULL, 0x00000003096b7812ULL, 0x000fe200078ec0ffULL,
0x00005e0002027625ULL, 0x000fe200078e0005ULL, 0x000000021b1b7819ULL, 0x000fc400000006ffULL,
0x0000000304047812ULL, 0x000fe200078ec0ffULL, 0x00005e000a0a7625ULL, 0x080fe200078e0005ULL,
0x000000046b197812ULL, 0x000fe400078efcffULL, 0x0000000227277819ULL, 0x000fe200000006ffULL,
0x00005e000c0c7625ULL, 0x080fe200078e0005ULL, 0x0000200057257811ULL, 0x000fe400078e68ffULL,
0xfffffffc1b087812ULL, 0x000fe200078ee204ULL, 0x00005e000e0e7625ULL, 0x000fe200078e0005ULL,
0x0ffffffc046a7812ULL, 0x000fc400078ef809ULL, 0xfffffffc1d187812ULL, 0x100fe200078ee204ULL,
0x00005e0010107625ULL, 0x080fe200078e0005ULL, 0xfffffffc1f1a7812ULL, 0x100fe400078ee204ULL,
0xfffffffc27207812ULL, 0x000fe200078ee204ULL, 0x00005e0012127625ULL, 0x000fe200078e0005ULL,
0x000000256a277211ULL, 0x000fc600078e20ffULL, 0x00005e0014147625ULL, 0x000fc800078e0005ULL,
0x00005e0016167625ULL, 0x000fc800078e0005ULL, 0x0000000421217824ULL, 0x000fe400078e00ffULL,
0x0000000423237824ULL, 0x000fe400078e00ffULL, 0x0000000429297824ULL, 0x000fe200078e00ffULL,
0xfffffffc211c7812ULL, 0x000fe200078ee204ULL, 0x0000001019027825ULL, 0x000fe200078e0002ULL,
0xfffffffc231e7812ULL, 0x100fe400078ee204ULL, 0xfffffffc29227812ULL, 0x000fe200078ee204ULL,
0x00000010190a7825ULL, 0x040fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002277faeULL, 0x0003e6000b901c46ULL, 0x00000010190c7825ULL, 0x000fc800078e000cULL,
0x00000010190e7825ULL, 0x000fc800078e000eULL, 0x0000001019107825ULL, 0x000fc800078e0010ULL,
0x0000001019127825ULL, 0x000fc800078e0012ULL, 0x0000001019147825ULL, 0x000fc800078e0014ULL,
0x0000001019167825ULL, 0x000fc800078e0016ULL, 0x0000001008197824ULL, 0x100fe400078e0225ULL,
0x00000010181b7824ULL, 0x100fe400078e0225ULL, 0x000000101a1d7824ULL, 0x100fe200078e0225ULL,
0x000000000a197faeULL, 0x0003e2000b901c46ULL, 0x000000101c1f7824ULL, 0x100fe400078e0225ULL,
0x000000101e217824ULL, 0x100fe200078e0225ULL, 0x000000000c1b7faeULL, 0x0003e2000b901c46ULL,
0x0000001020237824ULL, 0x000fc400078e0225ULL, 0x0000001022257824ULL, 0x000fe200078e0225ULL,
0x000000000e1d7faeULL, 0x0003e8000b901c46ULL, 0x00000000101f7faeULL, 0x0003e8000b901c46ULL,
0x0000000012217faeULL, 0x0003e8000b901c46ULL, 0x0000000014237faeULL, 0x0003e8000b901c46ULL,
0x0000000016257faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000709087812ULL, 0x000fc400078ec0ffULL,
0x00000004ff037819ULL, 0x102fe40000011609ULL, 0x0000000808027812ULL, 0x000fc800078ef809ULL,
0x00000007030b7812ULL, 0x000fc800078e7802ULL, 0x0000000b020b7211ULL, 0x000fca00078e20ffULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x00000008030d7824ULL, 0x000fe200078e00ffULL,
0x000000000b28783bULL, 0x000fe20000000200ULL, 0x00002000576d7824ULL, 0x000fe200078e00ffULL,
0x00000002031d7810ULL, 0x000fe20007ffe0ffULL, 0x00000d5000007945ULL, 0x000fe20003800000ULL,
0xfffffff80d087812ULL, 0x000fe400078ee208ULL, 0x000010006d5d7810ULL, 0x000fe40007ffe0ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011608ULL, 0x00000004080f7824ULL, 0x040fe200078e00ffULL,
0x00000010080c7810ULL, 0x000fc40007ffe0ffULL, 0x00000020080e7810ULL, 0x040fe40007ffe0ffULL,
0x0000003008107810ULL, 0x000fe40007ffe0ffULL, 0x000000030a0d7812ULL, 0x000fe200078ec0ffULL,
0x000000040e177824ULL, 0x000fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fe2000001160cULL,
0x00000004101b7824ULL, 0x000fe200078e00ffULL, 0x000000020c137819ULL, 0x000fe400000006ffULL,
0x00000001ff0a7819ULL, 0x000fc4000001160eULL, 0x00000001ff0c7819ULL, 0x000fe40000011610ULL,
0x0000000308117812ULL, 0x000fe400078ec0ffULL, 0x000000030a157812ULL, 0x000fe400078ec0ffULL,
0x000000030c197812ULL, 0x000fe400078ec0ffULL, 0x000000010d3e7812ULL, 0x100fe400078e7800ULL,
0x00000001115a7812ULL, 0x000fc400078e7800ULL, 0x0000000115587812ULL, 0x100fe400078e7800ULL,
0x00000001193c7812ULL, 0x000fe400078e7800ULL, 0x0000000f3e3e7212ULL, 0x000fe400078efcffULL,
0x000000135a5a7212ULL, 0x000fe400078efcffULL, 0x0000001758587212ULL, 0x000fe200078efcffULL,
0x000000103e697824ULL, 0x100fe200078e025dULL, 0x0000001b3c3c7212ULL, 0x000fe200078efcffULL,
0x000000105a687824ULL, 0x000fe200078e025dULL, 0x0000005d58677211ULL, 0x000fc400078e20ffULL,
0x000000006934783bULL, 0x000e620000000200ULL, 0x000000103c667824ULL, 0x000fe200078e025dULL,
0x0000000100007812ULL, 0x000fe400078ec0ffULL, 0x000000006830783bULL, 0x000ea40000000200ULL,
0x000000020d6e7812ULL, 0x000fe400078e1e00ULL, 0x00000000672c783bULL, 0x000ee20000000200ULL,
0x000000071d0d7812ULL, 0x000fe400078e7802ULL, 0x00000002110a7812ULL, 0x100fe200078e1e00ULL,
0x000000006638783bULL, 0x000f220000000200ULL, 0x0000000215087812ULL, 0x100fe200078e1e00ULL,
0x00000010020d7824ULL, 0x000fe200078e020dULL, 0x0000000219007812ULL, 0x000fc400078e1e00ULL,
0x0000000f6e6e7212ULL, 0x000fe200078efcffULL, 0x000000100d1c7824ULL, 0x000fe200078e00ffULL,
0x0000001708087212ULL, 0x000fe400078efcffULL, 0x000000130a0a7212ULL, 0x000fe200078efcffULL,
0x000000106e657824ULL, 0x100fe200078e025dULL, 0x0000001b00007212ULL, 0x000fe200078efcffULL,
0x0000001008617824ULL, 0x100fe200078e025dULL, 0x0000005d0a637211ULL, 0x000fe200078e20ffULL,
0x000000001c1c783bULL, 0x000fe40000000200ULL, 0x00000010005f7824ULL, 0x000fc400078e025dULL,
0x00000000654c783bULL, 0x000f680000000200ULL, 0x00000000630c783bULL, 0x000f280000000200ULL,
0x000000006114783bULL, 0x000f220000000200ULL, 0x000000342820723cULL, 0x042fe600000018ffULL,
0x000000005f24783bULL, 0x000e6a0000000200ULL, 0x000000302848723cULL, 0x044ff000000018ffULL,
0x0000002c2810723cULL, 0x048ff000000018ffULL, 0x000000362834723cULL, 0x040ff000000018ffULL,
0x000000322830723cULL, 0x040ff000000018ffULL, 0x0000002e282c723cULL, 0x040ff000000018ffULL,
0x000000382818723cULL, 0x050ff000000018ffULL, 0x0000003a2828723cULL, 0x000ff000000018ffULL,
0x0000004c1c20723cULL, 0x060ff00000001820ULL, 0x0000000c1c48723cULL, 0x040ff00000001848ULL,
0x000000141c10723cULL, 0x040ff00000001810ULL, 0x0000004e1c4c723cULL, 0x040ff00000001834ULL,
0x0000000e1c0c723cULL, 0x040ff00000001830ULL, 0x000000161c14723cULL, 0x040ff0000000182cULL,
0x000000241c18723cULL, 0x042ff00000001818ULL, 0x000000261c1c723cULL, 0x000fe20000001828ULL,
0x000004c000008947ULL, 0x000fee0003800000ULL, 0x00000002ff2b7819ULL, 0x000fe20000011609ULL,
0x0000000156287824ULL, 0x000fc400078e0a07ULL, 0x000000106a5c7824ULL, 0x000fe200078e025dULL,
0x000000082b0b7810ULL, 0x040fe20007ffe0ffULL, 0x000000012b247824ULL, 0x040fe200078e026cULL,
0x000000282b00720cULL, 0x000fe40003f26070ULL, 0x0000006c0b267210ULL, 0x040fe20007ffe0ffULL,
0x000000040b297824ULL, 0x040fe200078e00ffULL, 0x000000280b00720cULL, 0x000fe20003f46070ULL,
0x00005e0024247625ULL, 0x080fe200078e0005ULL, 0x000000086b0b7812ULL, 0x000fe400078efcffULL,
0xfffffffc292a7812ULL, 0x000fe200078ee204ULL, 0x00005e0026267625ULL, 0x000fe200078e0005ULL,
0x000000102b2d7810ULL, 0x000fc40007ffe0ffULL, 0x000000182b337810ULL, 0x000fe20007ffe0ffULL,
0x000000100b247825ULL, 0x000fe200078e0024ULL, 0x000000202b357810ULL, 0x040fe40007ffe0ffULL,
0x000000282b377810ULL, 0x000fe20007ffe0ffULL, 0x000000102a297824ULL, 0x000fe200078e025dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000245c7faeULL, 0x0003e2000c901c46ULL,
0x000000100b267825ULL, 0x000fe200078e0026ULL, 0x000000302b397810ULL, 0x040fe40007ffe0ffULL,
0x000000382b3b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001352e7824ULL, 0x100fe200078e026cULL,
0x0000000026297faeULL, 0x0005e2000d101c46ULL, 0x000000282d00720cULL, 0x080fe20003f26070ULL,
0x00000001372c7824ULL, 0x100fe200078e026cULL, 0x000000283300720cULL, 0x080fe20003f46070ULL,
0x00000001392a7824ULL, 0x100fe200078e026cULL, 0x000000283500720cULL, 0x080fe20003f66070ULL,
0x0000000133247824ULL, 0x102fe200078e026cULL, 0x000000283700720cULL, 0x080fe20003f86070ULL,
0x0000000433337824ULL, 0x000fe200078e00ffULL, 0x000000283900720cULL, 0x080fe20003fa6070ULL,
0x0000000435357824ULL, 0x000fe200078e00ffULL, 0x000000283b00720cULL, 0x000fe20003fc6070ULL,
0x000000012d267824ULL, 0x044fe200078e026cULL, 0x000000022d2d7819ULL, 0x000fe200000006ffULL,
0x0000000437377824ULL, 0x000fe200078e00ffULL, 0x0000006c3b287210ULL, 0x000fe20007ffe0ffULL,
0x00005e0026267625ULL, 0x000fe200078e0005ULL, 0xfffffffc2d307812ULL, 0x000fc400078ee204ULL,
0x0000000239397819ULL, 0x000fe200000006ffULL, 0x00005e0024247625ULL, 0x080fe200078e0005ULL,
0xfffffffc35327812ULL, 0x100fe400078ee204ULL, 0xfffffffc37347812ULL, 0x100fe200078ee204ULL,
0x00005e002e2e7625ULL, 0x000fe200078e0005ULL, 0xfffffffc39367812ULL, 0x000fc600078ee204ULL,
0x00005e002c2c7625ULL, 0x000fc800078e0005ULL, 0x00005e002a2a7625ULL, 0x000fc800078e0005ULL,
0x00005e0028287625ULL, 0x000fc800078e0005ULL, 0x0000001030317824ULL, 0x000fe200078e025dULL,
0xfffffffc33307812ULL, 0x000fe200078ee204ULL, 0x000000043b3b7824ULL, 0x000fe200078e00ffULL,
0x0000005d36337211ULL, 0x000fe200078e20ffULL, 0x000000100b267825ULL, 0x000fc600078e0026ULL,
0xfffffffc3b387812ULL, 0x000fe200078ee204ULL, 0x000000100b247825ULL, 0x040fe200078e0024ULL,
0x0000000026317faeULL, 0x0003e6000c901c46ULL, 0x000000100b2e7825ULL, 0x000fc800078e002eULL,
0x000000100b2c7825ULL, 0x000fc800078e002cULL, 0x000000100b2a7825ULL, 0x000fc800078e002aULL,
0x000000100b287825ULL, 0x000fc800078e0028ULL, 0x00000010300b7824ULL, 0x100fe400078e025dULL,
0x0000001032277824ULL, 0x102fe400078e025dULL, 0x0000001034317824ULL, 0x100fe200078e025dULL,
0x00000000240b7faeULL, 0x0003e2000d101c46ULL, 0x0000001038357824ULL, 0x000fc600078e025dULL,
0x000000002e277faeULL, 0x0003e8000d901c46ULL, 0x000000002c317faeULL, 0x0003e8000e101c46ULL,
0x000000002a337faeULL, 0x0003e8000e901c46ULL, 0x0000000028357faeULL, 0x0003e2000f101c46ULL,
0x0000041000007947ULL, 0x000fea0003800000ULL, 0x0000006c09247211ULL, 0x000fe200078ff0ffULL,
0x000000106a5c7824ULL, 0x000fe200078e025dULL, 0x000000086b357812ULL, 0x000fc400078efcffULL,
0x00000008090b7811ULL, 0x040fe200078ff0ffULL, 0x00005e0024247625ULL, 0x080fe200078e0005ULL,
0x0000001009277811ULL, 0x040fe400078ff0ffULL, 0x0000001809377811ULL, 0x000fe200078ff0ffULL,
0x000000010b267824ULL, 0x000fe200078e026cULL, 0x0000006c27287210ULL, 0x000fe20007ffe0ffULL,
0x0000001035247825ULL, 0x000fe200078e0024ULL, 0x0000002009397811ULL, 0x040fe400078ff0ffULL,
0x00000028093b7811ULL, 0x000fe200078ff0ffULL, 0x000000040b0b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000245c7faeULL, 0x0003e2000b901c46ULL,
0x0000000427277824ULL, 0x000fe200078e00ffULL, 0x00000038093f7811ULL, 0x000fe200078ff0ffULL,
0x00000001372e7824ULL, 0x000fe200078e026cULL, 0x00000030093d7811ULL, 0x000fe200078ff0ffULL,
0x00005e0028287625ULL, 0x000fe200078e0005ULL, 0xfffffffc0b327812ULL, 0x000fc400078ee204ULL,
0xfffffffc27347812ULL, 0x000fe200078ee204ULL, 0x0000000437377824ULL, 0x000fe200078e00ffULL,
0x0000006c3d2a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000139307824ULL, 0x040fe200078e026cULL,
0x0000000239397819ULL, 0x000fe200000006ffULL, 0x00005e0026247625ULL, 0x002fc800078e0005ULL,
0x000000013b2c7824ULL, 0x100fe400078e026cULL, 0x000000013f367824ULL, 0x000fe400078e026cULL,
0x000000043b3b7824ULL, 0x000fe400078e00ffULL, 0x00000010320b7824ULL, 0x000fe200078e025dULL,
0xfffffffc37327812ULL, 0x000fe200078ee204ULL, 0x0000001035247825ULL, 0x000fc800078e0024ULL,
0x000000043d3d7824ULL, 0x000fe200078e00ffULL, 0x00000000240b7faeULL, 0x0003e2000b901c46ULL,
0x00005e002e2e7625ULL, 0x000fc600078e0005ULL, 0xfffffffc3d387812ULL, 0x000fe200078ee204ULL,
0x000000043f3f7824ULL, 0x000fe400078e00ffULL, 0x00005e0030307625ULL, 0x000fc800078e0005ULL,
0x00005e002c2c7625ULL, 0x000fe200078e0005ULL, 0xfffffffc3f247812ULL, 0x002fc600078ee204ULL,
0x00005e0036267625ULL, 0x000fe200078e0005ULL, 0xfffffffc3b367812ULL, 0x000fc600078ee204ULL,
0x0000001034337824ULL, 0x000fe200078e025dULL, 0xfffffffc39347812ULL, 0x000fe200078ee204ULL,
0x0000001035287825ULL, 0x000fc600078e0028ULL, 0x0000005d34257211ULL, 0x000fe200078e20ffULL,
0x00005e002a2a7625ULL, 0x000fe200078e0005ULL, 0x0000000028337faeULL, 0x0003e6000b901c46ULL,
0x00000010352e7825ULL, 0x000fc800078e002eULL, 0x00000010320b7824ULL, 0x000fe400078e025dULL,
0x0000001035307825ULL, 0x000fc600078e0030ULL, 0x000000002e0b7faeULL, 0x0005e2000b901c46ULL,
0x00000010352c7825ULL, 0x000fc600078e002cULL, 0x0000000030257faeULL, 0x0005e2000b901c46ULL,
0x0000001036297824ULL, 0x002fe400078e025dULL, 0x00000010352a7825ULL, 0x000fc600078e002aULL,
0x000000002c297faeULL, 0x0005e2000b901c46ULL, 0x0000001035267825ULL, 0x000fc800078e0026ULL,
0x0000001038337824ULL, 0x100fe400078e025dULL, 0x0000001024357824ULL, 0x000fc600078e025dULL,
0x000000002a337faeULL, 0x0005e8000b901c46ULL, 0x0000000026357faeULL, 0x0005e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000004030b7810ULL, 0x006fe20007ffe0ffULL, 0x00000ba000007945ULL, 0x000fe20003800000ULL,
0x000020006d6d7810ULL, 0x000fe40007ffe0ffULL, 0x000000070b0b7812ULL, 0x000fe400078e7802ULL,
0x0000006d3e5b7211ULL, 0x080fe200078e20ffULL, 0x000000105a5a7824ULL, 0x000fe200078e026dULL,
0x0000006d00007211ULL, 0x000fe200078e20ffULL, 0x00000010020b7824ULL, 0x000fc400078e020bULL,
0x0000001058587824ULL, 0x100fe400078e026dULL, 0x000000100b387824ULL, 0x000fe200078e00ffULL,
0x00000006030b7810ULL, 0x000fe20007ffe0ffULL, 0x000000103c557824ULL, 0x100fe400078e026dULL,
0x000000100a0a7824ULL, 0x100fe200078e026dULL, 0x000000070b0b7812ULL, 0x000fe200078e7802ULL,
0x0000001008087824ULL, 0x000fc600078e026dULL, 0x0000000b02247211ULL, 0x000fe200078e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000005b50783bULL, 0x000fe20000000200ULL,
0x0000001024247824ULL, 0x000fe400078e00ffULL, 0x000000106e0b7824ULL, 0x000fe200078e026dULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000005a44783bULL, 0x000ea80000000200ULL,
0x000000005840783bULL, 0x000ee80000000200ULL, 0x00000000553c783bULL, 0x000f280000000200ULL,
0x000000000b34783bULL, 0x000fe80000000200ULL, 0x000000002424783bULL, 0x000f680000000200ULL,
0x000000000a30783bULL, 0x000ee80000000200ULL, 0x00000000082c783bULL, 0x000ee80000000200ULL,
0x000000000028783bULL, 0x000ee20000000200ULL, 0x000000503820723cULL, 0x042ff00000001820ULL,
0x00000052384c723cULL, 0x040ff0000000184cULL, 0x000000443848723cULL, 0x044ff00000001848ULL,
0x00000046380c723cULL, 0x040ff0000000180cULL, 0x000000403810723cULL, 0x048ff00000001810ULL,
0x000000423814723cULL, 0x040ff00000001814ULL, 0x0000003c3818723cULL, 0x050ff00000001818ULL,
0x0000003e381c723cULL, 0x000ff0000000181cULL, 0x000000342420723cULL, 0x060ff00000001820ULL,
0x00000036244c723cULL, 0x040ff0000000184cULL, 0x000000302448723cULL, 0x040ff00000001848ULL,
0x00000032240c723cULL, 0x040ff0000000180cULL, 0x0000002c2410723cULL, 0x040ff00000001810ULL,
0x0000002e2414723cULL, 0x040ff00000001814ULL, 0x000000282418723cULL, 0x040ff00000001818ULL,
0x0000002a2424723cULL, 0x000fe2000000181cULL, 0x000004c000008947ULL, 0x000fee0003800000ULL,
0x00000002ff297819ULL, 0x000fe20000011609ULL, 0x00000001561e7824ULL, 0x000fe200078e0a07ULL,
0x0000000c6b6b7812ULL, 0x000fe200078efcffULL, 0x000000106a1f7824ULL, 0x000fe200078e026dULL,
0x00000010292d7810ULL, 0x040fe20007ffe0ffULL, 0x00000001291c7824ULL, 0x040fe200078e026cULL,
0x0000001e2900720cULL, 0x000fc40003f06070ULL, 0x00000018292f7810ULL, 0x040fe20007ffe0ffULL,
0x00005e001c1c7625ULL, 0x000fe200078e0005ULL, 0x00000008292b7810ULL, 0x040fe40007ffe0ffULL,
0x0000002029317810ULL, 0x000fe20007ffe0ffULL, 0x000000012d2a7824ULL, 0x000fe200078e026cULL,
0x0000002829337810ULL, 0x000fe20007ffe0ffULL, 0x000000106b1c7825ULL, 0x000fe200078e001cULL,
0x0000003029357810ULL, 0x040fe40007ffe0ffULL, 0x0000003829297810ULL, 0x000fe20007ffe0ffULL,
0x000000012f2e7824ULL, 0x100fe200078e026cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c1f7faeULL, 0x0003e2000c101c46ULL, 0x0000001e2d00720cULL, 0x0c0fe20003f26070ULL,
0x000000042d2d7824ULL, 0x000fe200078e00ffULL, 0x0000001e2f00720cULL, 0x0c0fe20003f46070ULL,
0x000000042f2f7824ULL, 0x000fe200078e00ffULL, 0x0000001e2b00720cULL, 0x080fe20003f06070ULL,
0x0000000133347824ULL, 0x100fe200078e026cULL, 0x0000001e3100720cULL, 0x080fe20003f66070ULL,
0x0000000135387824ULL, 0x000fe200078e026cULL, 0x0000001e3300720cULL, 0x0c0fe20003f86070ULL,
0x0000000433337824ULL, 0x000fe200078e00ffULL, 0x0000001e3500720cULL, 0x000fc40003fa6070ULL,
0x0000001e2900720cULL, 0x000fe20003fc6070ULL, 0x000000012b1e7824ULL, 0x140fe200078e026cULL,
0x000000022b2b7819ULL, 0x000fe400000006ffULL, 0x0000006c31307210ULL, 0x040fe20007ffe0ffULL,
0x0000000431317824ULL, 0x000fe200078e00ffULL, 0x0000000235357819ULL, 0x000fe200000006ffULL,
0x00000001296c7824ULL, 0x000fe200078e026cULL, 0xfffffffc2d287812ULL, 0x100fe200078ee204ULL,
0x0000000429297824ULL, 0x000fe200078e00ffULL, 0xfffffffc2f2c7812ULL, 0x100fe200078ee204ULL,
0x00005e001e1e7625ULL, 0x002fe200078e0005ULL, 0xfffffffc2b1c7812ULL, 0x000fc400078ee204ULL,
0xfffffffc31327812ULL, 0x100fe200078ee204ULL, 0x00005e002a2a7625ULL, 0x000fe200078e0005ULL,
0xfffffffc353a7812ULL, 0x100fe400078ee204ULL, 0x0000006d2c377211ULL, 0x000fe200078e20ffULL,
0x00005e002e2e7625ULL, 0x080fe200078e0005ULL, 0xfffffffc33367812ULL, 0x100fe400078ee204ULL,
0xfffffffc293c7812ULL, 0x000fe200078ee204ULL, 0x00005e0030307625ULL, 0x000fc800078e0005ULL,
0x0000001028357824ULL, 0x000fe400078e026dULL, 0x00005e00342c7625ULL, 0x000fc800078e0005ULL,
0x000000101c337824ULL, 0x000fe400078e026dULL, 0x00005e0038287625ULL, 0x000fc800078e0005ULL,
0x00005e006c1c7625ULL, 0x000fc800078e0005ULL, 0x000000106b1e7825ULL, 0x000fc800078e001eULL,
0x000000106b2a7825ULL, 0x040fe200078e002aULL, 0x000000001e337faeULL, 0x0003e6000c101c46ULL,
0x000000106b2e7825ULL, 0x040fe200078e002eULL, 0x000000002a357faeULL, 0x0003e6000c901c46ULL,
0x0000001032397824ULL, 0x000fe200078e026dULL, 0x000000002e377faeULL, 0x0003e2000d101c46ULL,
0x000000106b307825ULL, 0x000fc800078e0030ULL, 0x00000010363b7824ULL, 0x000fe200078e026dULL,
0x0000000030397faeULL, 0x0003e2000d901c46ULL, 0x000000106b2c7825ULL, 0x000fc800078e002cULL,
0x000000103a3d7824ULL, 0x000fe200078e026dULL, 0x000000002c3b7faeULL, 0x0003e2000e101c46ULL,
0x000000106b287825ULL, 0x000fc800078e0028ULL, 0x000000103c6d7824ULL, 0x000fe200078e026dULL,
0x00000000283d7faeULL, 0x0003e2000e901c46ULL, 0x000000106b1c7825ULL, 0x000fca00078e001cULL,
0x000000001c6d7faeULL, 0x0003e2000f101c46ULL, 0x0000041000007947ULL, 0x000fea0003800000ULL,
0x0000006c091c7211ULL, 0x040fe400078ff0ffULL, 0x00000010092b7811ULL, 0x040fe400078ff0ffULL,
0x00000018092d7811ULL, 0x000fe200078ff0ffULL, 0x00005e001c1c7625ULL, 0x000fe200078e0005ULL,
0x0000000c6b6b7812ULL, 0x000fe400078efcffULL, 0x0000000809297811ULL, 0x000fe200078ff0ffULL,
0x000000012b2a7824ULL, 0x000fe200078e026cULL, 0x00000020092f7811ULL, 0x000fe200078ff0ffULL,
0x000000106b1c7825ULL, 0x000fe200078e001cULL, 0x0000002809317811ULL, 0x000fc400078ff0ffULL,
0x0000003009337811ULL, 0x000fe200078ff0ffULL, 0x000000042b2b7824ULL, 0x000fe200078e00ffULL,
0x0000003809357811ULL, 0x000fe200078ff0ffULL, 0x00000001291e7824ULL, 0x100fe200078e026cULL,
0x0000006c2d2e7210ULL, 0x040fe20007ffe0ffULL, 0x000000042d2d7824ULL, 0x000fe200078e00ffULL,
0x0000006d6a1f7211ULL, 0x000fe200078e20ffULL, 0x000000012f307824ULL, 0x000fe200078e026cULL,
0xfffffffc2b287812ULL, 0x100fe200078ee204ULL, 0x0000000429297824ULL, 0x000fe200078e00ffULL,
0xfffffffc2d2c7812ULL, 0x000fe200078ee204ULL, 0x000000042f2f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c1f7faeULL, 0x0003e2000b901c46ULL,
0x0000000131347824ULL, 0x140fe200078e026cULL, 0x0000000231317819ULL, 0x000fe200000006ffULL,
0x0000000133387824ULL, 0x000fe200078e026cULL, 0xfffffffc2f327812ULL, 0x000fe200078ee204ULL,
0x00000001356c7824ULL, 0x000fe200078e026cULL, 0xfffffffc31367812ULL, 0x000fe200078ee204ULL,
0x0000000435357824ULL, 0x000fc400078e00ffULL, 0x0000000433337824ULL, 0x000fe400078e00ffULL,
0x00005e002a2a7625ULL, 0x080fe200078e0005ULL, 0xfffffffc291c7812ULL, 0x102fe400078ee204ULL,
0xfffffffc353c7812ULL, 0x100fe200078ee204ULL, 0x00005e001e1e7625ULL, 0x000fe200078e0005ULL,
0xfffffffc333a7812ULL, 0x000fe400078ee204ULL, 0x0000006d1c337211ULL, 0x000fe200078e20ffULL,
0x00005e002e2e7625ULL, 0x000fe200078e0005ULL, 0x0000006d3a3d7211ULL, 0x000fc600078e20ffULL,
0x000000102c377824ULL, 0x000fe400078e026dULL, 0x00005e0030307625ULL, 0x000fc800078e0005ULL,
0x0000001028357824ULL, 0x000fe400078e026dULL, 0x00005e00342c7625ULL, 0x000fc800078e0005ULL,
0x00005e0038287625ULL, 0x000fc800078e0005ULL, 0x00005e006c1c7625ULL, 0x000fc800078e0005ULL,
0x000000106b1e7825ULL, 0x000fc800078e001eULL, 0x000000106b2a7825ULL, 0x040fe200078e002aULL,
0x000000001e337faeULL, 0x0003e6000b901c46ULL, 0x000000106b2e7825ULL, 0x040fe200078e002eULL,
0x000000002a357faeULL, 0x0003e6000b901c46ULL, 0x0000001032397824ULL, 0x000fe200078e026dULL,
0x000000002e377faeULL, 0x0003e2000b901c46ULL, 0x000000106b307825ULL, 0x000fc800078e0030ULL,
0x00000010363b7824ULL, 0x000fe200078e026dULL, 0x0000000030397faeULL, 0x0003e2000b901c46ULL,
0x000000106b2c7825ULL, 0x000fc800078e002cULL, 0x000000106b287825ULL, 0x040fe200078e0028ULL,
0x000000002c3b7faeULL, 0x0003e6000b901c46ULL, 0x000000103c6d7824ULL, 0x000fe200078e026dULL,
0x00000000283d7faeULL, 0x0003e2000b901c46ULL, 0x000000106b1c7825ULL, 0x000fca00078e001cULL,
0x000000001c6d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000008031d7810ULL, 0x042fe20007ffe0ffULL,
0x00000c7000007945ULL, 0x000fe20003800000ULL, 0x0000000a03297810ULL, 0x000fe40007ffe0ffULL,
0x000000071d1d7812ULL, 0x100fe400078e7802ULL, 0x0000000729297812ULL, 0x000fc600078e7802ULL,
0x00000010021d7824ULL, 0x040fe400078e021dULL, 0x0000001002297824ULL, 0x000fe400078e0229ULL,
0x000000101d3c7824ULL, 0x000fc600078e00ffULL, 0x0000000429297819ULL, 0x000fe200000006ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000000691c783bULL, 0x000fe80000000200ULL,
0x000000003c3c783bULL, 0x000e680000000200ULL, 0x000000006850783bULL, 0x000ea80000000200ULL,
0x000000006744783bULL, 0x000ee80000000200ULL, 0x000000006640783bULL, 0x000f280000000200ULL,
0x000000006538783bULL, 0x000fe80000000200ULL, 0x000000002928783bULL, 0x000f680000000200ULL,
0x000000006334783bULL, 0x000ee80000000200ULL, 0x000000006130783bULL, 0x000ee80000000200ULL,
0x000000005f2c783bULL, 0x000ee20000000200ULL, 0x0000001c3c20723cULL, 0x042ff00000001820ULL,
0x0000001e3c4c723cULL, 0x040ff0000000184cULL, 0x000000503c48723cULL, 0x044fee0000001848ULL,
0x0000030059517a10ULL, 0x000fe20007ffe0ffULL, 0x000000523c0c723cULL, 0x000fe6000000180cULL,
0x00000001511d7810ULL, 0x040fe20007ffe0ffULL, 0x00000100511f7824ULL, 0x000fc600078e0262ULL,
0x000000541d00720cULL, 0x000fe20003f06070ULL, 0x000000443c10723cULL, 0x048ff00000001810ULL,
0x000000463c14723cULL, 0x040ff00000001814ULL, 0x000000403c18723cULL, 0x050ff00000001818ULL,
0x000000423c24723cULL, 0x000ff00000001824ULL, 0x000000382820723cULL, 0x060ff00000001820ULL,
0x0000003a284c723cULL, 0x040ff0000000184cULL, 0x000000342848723cULL, 0x040ff00000001848ULL,
0x00000036280c723cULL, 0x040ff0000000180cULL, 0x000000302810723cULL, 0x040fee0000001810ULL,
0x0000620064307a24ULL, 0x000fe200078e021fULL, 0x000000322814723cULL, 0x040ff00000001814ULL,
0x0000002c2818723cULL, 0x040ff00000001818ULL, 0x0000002e2824723cULL, 0x000fe20000001824ULL,
0x0000055000008947ULL, 0x000fee0003800000ULL, 0x00000002ff337819ULL, 0x000fe20000011609ULL,
0x0000001009317824ULL, 0x000fe200078e00ffULL, 0x0000001f561e7217ULL, 0x000fc40007800000ULL,
0x00000008332f7810ULL, 0x040fe20007ffe0ffULL, 0x00000001331c7824ULL, 0x100fe200078e0230ULL,
0x0000003031317812ULL, 0x000fe400078ec0ffULL, 0x0000001e1f327210ULL, 0x000fe20007ffe1ffULL,
0x00005e001c1c7625ULL, 0x000fe200078e0005ULL, 0x0000001033377810ULL, 0x040fe40007ffe0ffULL,
0x0000001833397810ULL, 0x000fe20007ffe0ffULL, 0x000000012f287824ULL, 0x100fe200078e0230ULL,
0x000000311c1e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001371c7824ULL, 0x000fe200078e0230ULL,
0x000000322f00720cULL, 0x000fe20003f26070ULL, 0x00005e0028287625ULL, 0x000fe200078e0005ULL,
0x00000020333b7810ULL, 0x000fc40007ffe0ffULL, 0x00000028333d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1f7224ULL, 0x000fe200000e061dULL, 0x00000031282c7210ULL, 0x000fe20007f1e0ffULL,
0x000000042f2f7824ULL, 0x000fe200078e00ffULL, 0x00000030333f7810ULL, 0x040fe20007ffe0ffULL,
0x00005e001c1c7625ULL, 0x000fe200078e0005ULL, 0x00000029ff2d7210ULL, 0x000fe400007fe4ffULL,
0x000000323300720cULL, 0x000fe20003f06070ULL, 0x0000000139287824ULL, 0x000fe200078e0230ULL,
0xfffffffc2f2e7812ULL, 0x000fe200078ee204ULL, 0x000000013b2a7824ULL, 0x000fe200078e0230ULL,
0x000000311c1c7210ULL, 0x000fe20007f5e0ffULL, 0x00005e0028287625ULL, 0x000fe200078e0005ULL,
0x0000005d2e357211ULL, 0x000fc400078e20ffULL, 0x0000003833337810ULL, 0x000fe20007ffe0ffULL,
0x00005e002a2a7625ULL, 0x000fe200078e0005ULL, 0x000000323700720cULL, 0x080fe40003fa6070ULL,
0x000000323900720cULL, 0x080fe20003f86070ULL, 0x000000013d2e7824ULL, 0x000fe200078e0230ULL,
0x000000312a2a7210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200010e061dULL,
0x0000003128287210ULL, 0x000fe20007f5e0ffULL, 0x00005e002e2e7625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e5c7faeULL, 0x0003e2000c101c46ULL,
0x000000323300720cULL, 0x000fc40003f06070ULL, 0x000000ffff297224ULL, 0x000fe200010e0629ULL,
0x000000002c357faeULL, 0x0005e2000c901c46ULL, 0x000000ffff2b7224ULL, 0x000fe200018e062bULL,
0x000000312e2e7210ULL, 0x000fe20007fde0ffULL, 0x0000000437377824ULL, 0x000fe200078e00ffULL,
0x000000323d00720cULL, 0x080fe20003f46070ULL, 0x0000000439397824ULL, 0x000fe200078e00ffULL,
0x000000323f00720cULL, 0x080fe20003f26070ULL, 0x000000043d3d7824ULL, 0x000fe200078e00ffULL,
0x000000323b00720cULL, 0x000fe20003f66070ULL, 0x000000013f1e7824ULL, 0x002fe200078e0230ULL,
0x000000023b3b7819ULL, 0x000fe200000006ffULL, 0x000000043f3f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc372c7812ULL, 0x004fe200078ee204ULL, 0x0000000133307824ULL, 0x040fe200078e0230ULL,
0x0000000233337819ULL, 0x000fe200000006ffULL, 0x00005e001e1e7625ULL, 0x000fe200078e0005ULL,
0xfffffffc39327812ULL, 0x000fc400078ee204ULL, 0xfffffffc3b347812ULL, 0x100fe200078ee204ULL,
0x000000ffff2f7224ULL, 0x000fe200030e062fULL, 0xfffffffc3d367812ULL, 0x100fe200078ee204ULL,
0x000000102c2d7824ULL, 0x100fe200078e025dULL, 0x000000311e1e7210ULL, 0x000fe20007fde0ffULL,
0x0000001034357824ULL, 0x000fe200078e025dULL, 0xfffffffc3f387812ULL, 0x100fe400078ee204ULL,
0xfffffffc333a7812ULL, 0x000fe200078ee204ULL, 0x00005e0030047625ULL, 0x000fe200078e0005ULL,
0x000000001c2d7faeULL, 0x0003e6000e901c46ULL, 0x000000ffff1f7224ULL, 0x000fe200030e061fULL,
0x0000003104047210ULL, 0x000fe20007fde0ffULL, 0x0000001032337824ULL, 0x100fe200078e025dULL,
0x0000005d36317211ULL, 0x000fe200078e20ffULL, 0x0000001038377824ULL, 0x000fc400078e025dULL,
0x000000103a5d7824ULL, 0x000fe200078e025dULL, 0x0000000028337faeULL, 0x0003e2000e101c46ULL,
0x000000ffff057224ULL, 0x000fc600030e0605ULL, 0x000000002a357faeULL, 0x0003e8000d901c46ULL,
0x000000002e317faeULL, 0x0003e8000d101c46ULL, 0x000000001e377faeULL, 0x0003e8000c901c46ULL,
0x00000000045d7faeULL, 0x0003e2000c101c46ULL, 0x0000049000007947ULL, 0x000fea0003800000ULL,
0x00000008091d7811ULL, 0x040fe200078ff0ffULL, 0x00000010092d7824ULL, 0x040fe200078e00ffULL,
0x00000010091f7811ULL, 0x000fc400078ff0ffULL, 0x00000030091c7211ULL, 0x080fe200078ff0ffULL,
0x000000041d357824ULL, 0x000fe200078e00ffULL, 0x00000020092b7811ULL, 0x000fe200078ff0ffULL,
0x000000011f2a7824ULL, 0x100fe200078e0230ULL, 0x00000028092f7811ULL, 0x000fe200078ff0ffULL,
0x000000041f1f7824ULL, 0x000fe200078e00ffULL, 0x000000301d1e7210ULL, 0x080fe20007ffe0ffULL,
0x00005e001c1c7625ULL, 0x000fe200078e0005ULL, 0x0000001809297811ULL, 0x040fe400078ff0ffULL,
0x0000003009317811ULL, 0x000fe200078ff0ffULL, 0x000000012b2e7824ULL, 0x100fe200078e0230ULL,
0x0000003809337811ULL, 0x000fe200078ff0ffULL, 0x000000012f2c7824ULL, 0x100fe200078e0230ULL,
0x000000302d2d7812ULL, 0x000fe200078ec0ffULL, 0x0000000129287824ULL, 0x000fe200078e0230ULL,
0x0000003031327210ULL, 0x000fe20007ffe0ffULL, 0x000000042b2b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1f367812ULL, 0x000fe200078ee204ULL, 0x000000042f2f7824ULL, 0x000fe200078e00ffULL,
0x0000002d1c1c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000431317824ULL, 0x000fe200078e00ffULL,
0x0000000229297819ULL, 0x000fe200000006ffULL, 0x0000000133347824ULL, 0x000fe200078e0230ULL,
0xfffffffc35307812ULL, 0x100fe200078ee204ULL, 0x0000000433337824ULL, 0x000fe200078e00ffULL,
0xfffffffc29387812ULL, 0x100fe200078ee204ULL, 0x00005e001e1e7625ULL, 0x000fe200078e0005ULL,
0xfffffffc2b3a7812ULL, 0x000fc400078ee204ULL, 0xfffffffc2f3c7812ULL, 0x100fe200078ee204ULL,
0x000000ffff1d7224ULL, 0x000fe200000e061dULL, 0xfffffffc313e7812ULL, 0x100fe200078ee204ULL,
0x00005e002a2a7625ULL, 0x000fe200078e0005ULL, 0xfffffffc33047812ULL, 0x000fe400078ee204ULL,
0x0000002d1e1e7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0028287625ULL, 0x000fe200078e0005ULL,
0x0000005d30377211ULL, 0x080fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c5c7faeULL, 0x0003e2000b901c46ULL, 0x0000005d3e417211ULL, 0x000fe200078e20ffULL,
0x0000001036397824ULL, 0x100fe200078e025dULL, 0x0000002d2a2a7210ULL, 0x000fe20007f3e0ffULL,
0x00000010383b7824ULL, 0x000fc400078e025dULL, 0x000000103a3d7824ULL, 0x100fe400078e025dULL,
0x000000103c3f7824ULL, 0x100fe400078e025dULL, 0x00000010045d7824ULL, 0x000fe400078e025dULL,
0x000000ffff1f7224ULL, 0x000fe200000e061fULL, 0x0000002d28047210ULL, 0x000fe20007f1e0ffULL,
0x00005e002e2e7625ULL, 0x000fc600078e0005ULL, 0x000000001e377faeULL, 0x0003e2000b901c46ULL,
0x00005e002c307625ULL, 0x000fc800078e0005ULL, 0x00005e0032327625ULL, 0x000fc800078e0005ULL,
0x00005e0034347625ULL, 0x000fc800078e0005ULL, 0x000000ffff2b7224ULL, 0x000fe200008e062bULL,
0x0000002d302c7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e0629ULL,
0x0000002d2e287210ULL, 0x080fe40007f1e0ffULL, 0x0000002d322e7210ULL, 0x080fe20007f5e0ffULL,
0x000000002a397faeULL, 0x0003e2000b901c46ULL, 0x0000002d34307210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200008e0631ULL, 0x0000002fff297210ULL, 0x000fe200007fe4ffULL,
0x000000ffff2f7224ULL, 0x000fe200010e0633ULL, 0x00000000043b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff317224ULL, 0x000fc600018e0635ULL, 0x00000000283d7faeULL, 0x0003e8000b901c46ULL,
0x000000002c3f7faeULL, 0x0003e8000b901c46ULL, 0x000000002e417faeULL, 0x0003e8000b901c46ULL,
0x00000000305d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000c03057810ULL, 0x002fc40007ffe0ffULL,
0x0000000e03037810ULL, 0x000fe40007ffe0ffULL, 0x0000000705057812ULL, 0x100fe400078e7802ULL,
0x0000000703037812ULL, 0x000fc600078e7802ULL, 0x0000001002057824ULL, 0x040fe400078e0205ULL,
0x0000001002037824ULL, 0x000fc600078e0203ULL, 0x0000000405057819ULL, 0x000fe200000006ffULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000005b1c783bULL, 0x000fe80000000200ULL, 0x000000000528783bULL, 0x000e680000000200ULL,
0x000000005a2c783bULL, 0x000ea80000000200ULL, 0x000000005830783bULL, 0x000ee80000000200ULL,
0x000000005534783bULL, 0x000f280000000200ULL, 0x000000000338783bULL, 0x000fe80000000200ULL,
0x000000000a40783bULL, 0x000f680000000200ULL, 0x000000000b3c783bULL, 0x000ee80000000200ULL,
0x000000000044783bULL, 0x000fe20000000200ULL, 0x0000001c2820723cULL, 0x042ff00000001820ULL,
0x0000001e284c723cULL, 0x040fe2000000184cULL, 0x00000000081c783bULL, 0x000e6e0000000200ULL,
0x0000002e280c723cULL, 0x044ff0000000180cULL, 0x000000322814723cULL, 0x048ff00000001814ULL,
0x000000342818723cULL, 0x050ff00000001818ULL, 0x0000002c2848723cULL, 0x040ff00000001848ULL,
0x000000302810723cULL, 0x040ff00000001810ULL, 0x000000362824723cULL, 0x000fe20000001824ULL,
0x01361400062b7984ULL, 0x000eae0000000800ULL, 0x00000042380c723cULL, 0x060ff0000000180cULL,
0x0000003c3820723cULL, 0x040ff00000001820ULL, 0x0000001e3814723cULL, 0x042ff00000001814ULL,
0x000000443818723cULL, 0x000fe20000001818ULL, 0x3db504f30e297820ULL, 0x000fe20000410000ULL,
0x0000ffff5e0e7812ULL, 0x000fe200078ec0ffULL, 0x3db504f30c0c7820ULL, 0x000fe20000410000ULL,
0x3db504f30d0d7820ULL, 0x000fe20000410000ULL, 0x3db504f30f0f7820ULL, 0x000fe20000410000ULL,
0x000088800e2a7816ULL, 0x000fc400000000ffULL, 0x0000003e384c723cULL, 0x000fe2000000184cULL,
0x3db504f321027820ULL, 0x000fe20000410000ULL, 0x3db504f320037820ULL, 0x000fe20000410000ULL,
0x800000002a0e7824ULL, 0x000fe200078e00ffULL, 0x3db504f322227820ULL, 0x000fe20000410000ULL,
0x3db504f323237820ULL, 0x000fc60000410000ULL, 0x000000403848723cULL, 0x000fe20000001848ULL,
0x3db504f316217820ULL, 0x000fe20000410000ULL, 0x3db504f314147820ULL, 0x000fe20000410000ULL,
0x3db504f315157820ULL, 0x000fe20000410000ULL, 0x800000002bff7812ULL, 0x004fc8000780480eULL,
0x0000001c3810723cULL, 0x000fe20000001810ULL, 0x3db504f318167820ULL, 0x000fe20000410000ULL,
0x3db504f31a1a7820ULL, 0x000fe20000410000ULL, 0x3db504f31b1b7820ULL, 0x000fc80000410000ULL,
0x3db504f3171c7820ULL, 0x000fe20000410000ULL, 0x000000463824723cULL, 0x000fe20000001824ULL,
0x3db504f319177820ULL, 0x000fe20000410000ULL, 0x3db504f34c057820ULL, 0x000fe20000410000ULL,
0x3db504f34d087820ULL, 0x000fe20000410000ULL, 0x3db504f34e4e7820ULL, 0x000fe20000410000ULL,
0x3db504f34f4f7820ULL, 0x000fc60000410000ULL, 0x3db504f3480a7820ULL, 0x000fe20000410000ULL,
0x3db504f3490b7820ULL, 0x000fe20000410000ULL, 0x3db504f34a4a7820ULL, 0x000fe20000410000ULL,
0x3db504f34b287820ULL, 0x000fca0000410000ULL, 0x3db504f310007820ULL, 0x000fe20000410000ULL,
0x3db504f311047820ULL, 0x000fe20000410000ULL, 0x3db504f3121e7820ULL, 0x000fe20000410000ULL,
0x3db504f313207820ULL, 0x000fca0000410000ULL, 0x3db504f3241d7820ULL, 0x000fe20000410000ULL,
0x3db504f3251f7820ULL, 0x000fe20000410000ULL, 0x3db504f326187820ULL, 0x000fe20000410000ULL,
0x3db504f327197820ULL, 0x000fe20000410000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e000cULL,
0x0000000d00117202ULL, 0x000fe20000000f00ULL, 0x000000ffff127224ULL, 0x000fe200078e0000ULL,
0x0000004a00277202ULL, 0x000fe20000000f00ULL, 0x000000ffff137224ULL, 0x000fe400078e0004ULL,
0x000000ffff257224ULL, 0x000fc400078e004eULL, 0x000000ffff267224ULL, 0x000fe400078e004fULL,
0x000000ffff247224ULL, 0x000fe200078e000fULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000002a0d7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x0136140006047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fc4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000409007824ULL, 0x000fe200078e00ffULL, 0x000000605900720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff000047812ULL, 0x000fc800078ec0ffULL,
0x0000000457047211ULL, 0x000fca00078e38ffULL, 0x01340000040c7984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002092a7824ULL, 0x000fe400078e00ffULL,
0x00000001562e7824ULL, 0x000fc600078e0a07ULL, 0x000000062a2a7812ULL, 0x000fc800078ec0ffULL,
0x000000012a077812ULL, 0x040fe400078efcffULL, 0x000000082a2b7812ULL, 0x040fe400078efcffULL,
0x0000002e0700720cULL, 0x080fe40003f26070ULL, 0x000000102a077812ULL, 0x000fe400078efcffULL,
0x0000002e2b00720cULL, 0x080fe40003f06070ULL, 0x0000002e0700720cULL, 0x000fc40003fc6070ULL,
0x000000112a2b7812ULL, 0x040fe400078efcffULL, 0x000000182a077812ULL, 0x040fe400078efcffULL,
0x0000002e2a00720cULL, 0x0c0fe40003f46070ULL, 0x0000002e2b00720cULL, 0x080fe40003fa6070ULL,
0x0000002e0700720cULL, 0x000fe40003f66070ULL, 0x000000092a2c7812ULL, 0x000fc400078efcffULL,
0x000000192a2b7812ULL, 0x040fe400078efcffULL, 0x000000202a077812ULL, 0x000fe400078efcffULL,
0xff7fffff22227808ULL, 0x000fe40005000000ULL, 0xff7fffff03037808ULL, 0x000fe40005000000ULL,
0xff7fffff23237808ULL, 0x000fe40004800000ULL, 0xff7fffff02027808ULL, 0x000fc40004800000ULL,
0x0000002e2c00720cULL, 0x080fe40003f86070ULL, 0x0000002e2b00720cULL, 0x080fe40003f46070ULL,
0x0000002e0700720cULL, 0x000fe40003f26070ULL, 0x000000212a2b7812ULL, 0x040fe400078efcffULL,
0x000000282a077812ULL, 0x000fe400078efcffULL, 0xff7fffff25257808ULL, 0x000fc40004000000ULL,
0xff7fffff05057808ULL, 0x000fe40004000000ULL, 0xff7fffff26267808ULL, 0x000fe40006000000ULL,
0xff7fffff08087808ULL, 0x000fe40006000000ULL, 0x0000002e2b00720cULL, 0x080fe40003f06070ULL,
0x0000002e0700720cULL, 0x000fe40003f86070ULL, 0x000000292a2b7812ULL, 0x000fc400078efcffULL,
0x000000302a077812ULL, 0x000fe400078efcffULL, 0xff7fffff27277808ULL, 0x000fe40007000000ULL,
0xff7fffff0a0a7808ULL, 0x000fe40007000000ULL, 0xff7fffff28287808ULL, 0x000fe40006800000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40006800000ULL, 0x0000002e2b00720cULL, 0x000fc40003fc6070ULL,
0x0000002e0700720cULL, 0x000fe40003fa6070ULL, 0x000000312a2b7812ULL, 0x040fe400078efcffULL,
0x000000382a077812ULL, 0x040fe400078efcffULL, 0x000000392a2a7812ULL, 0x000fe400078efcffULL,
0xff7fffff29297808ULL, 0x000fe40005800000ULL, 0xff7fffff10107808ULL, 0x000fc40005800000ULL,
0xff7fffff24247808ULL, 0x000fe40005000000ULL, 0xff7fffff11117808ULL, 0x000fe40005000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40004800000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0x0000002e2b00720cULL, 0x080fe40003f66070ULL, 0x0000002e0700720cULL, 0x000fc40003f46070ULL,
0x0000002e2a00720cULL, 0x000fe40003f26070ULL, 0xff7fffff20207808ULL, 0x000fe40004000000ULL,
0xff7fffff13137808ULL, 0x000fe40004000000ULL, 0xff7fffff21217808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff1c1c7808ULL, 0x000fc40007000000ULL,
0xff7fffff15157808ULL, 0x000fe40007000000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff18187808ULL, 0x000fc40005000000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40005000000ULL, 0xff7fffff19197808ULL, 0x000fe40004800000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000030c077209ULL, 0x004fe20007810000ULL, 0x0000001fff2e7424ULL, 0x000fe200078e00ffULL,
0x000000220d2a7209ULL, 0x000fe20007810000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x00000002070c7209ULL, 0x000fe40007810000ULL, 0x000000232a2a7209ULL, 0x000fc40007810000ULL,
0x000000050c077209ULL, 0x000fe40007810000ULL, 0x000000252a0d7209ULL, 0x000fe40007810000ULL,
0x0000000807077209ULL, 0x000fe40007810000ULL, 0x000000260d0c7209ULL, 0x000fe40007810000ULL,
0x0000000a072a7209ULL, 0x000fe40007810000ULL, 0x000000270c077209ULL, 0x000fc40007810000ULL,
0x0000000b2a0d7209ULL, 0x000fe40007810000ULL, 0x00000028070c7209ULL, 0x000fe40007810000ULL,
0x000000100d2a7209ULL, 0x000fe40007810000ULL, 0x000000290c077209ULL, 0x000fe40007810000ULL,
0x000000112a0d7209ULL, 0x000fe40007810000ULL, 0x0000002407077209ULL, 0x000fc40007810000ULL,
0x000000120d0c7209ULL, 0x000fe40007810000ULL, 0x0000001e07077209ULL, 0x000fe40007810000ULL,
0x000000130c0d7209ULL, 0x000fe40007810000ULL, 0x00000020070c7209ULL, 0x000fe40007810000ULL,
0x000000140d2a7209ULL, 0x000fe40007810000ULL, 0x000000210c077209ULL, 0x000fc40007810000ULL,
0x000000152a0d7209ULL, 0x000fe40007810000ULL, 0x0000001c07077209ULL, 0x000fe40007810000ULL,
0x000000160d0c7209ULL, 0x000fe40007810000ULL, 0x0000001a072a7209ULL, 0x000fe40007810000ULL,
0x000000170c0c7209ULL, 0x000fe40007810000ULL, 0x0000001b2a077209ULL, 0x000fc40007810000ULL,
0x0000001d0c0c7209ULL, 0x000fe40007810000ULL, 0x00000018072a7209ULL, 0x000fe40007810000ULL,
0x0000001f0c0c7209ULL, 0x000fe40007810000ULL, 0x000000192a2f7209ULL, 0x000fe20007810000ULL,
0x00000e927f007947ULL, 0x000fea000b800000ULL, 0x0c401f000c077f89ULL, 0x0004e400000e0000ULL,
0x000000070c307209ULL, 0x008fe20007810000ULL, 0x00000ec27f007947ULL, 0x000fea000b800000ULL,
0x0c401f002f077f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e0d7f89ULL, 0x000f2800000e0000ULL,
0x0c401f000f0c7f89ULL, 0x004ea200000e0000ULL, 0x000000072f2b7209ULL, 0x008fc40007810000ULL,
0x0000000d0e2c7209ULL, 0x010fc60007810000ULL, 0x0c201f002b2e7f89ULL, 0x002fe200000e0000ULL,
0x0000000c0f077209ULL, 0x004fc60007810000ULL, 0x0c201f00300d7f89ULL, 0x000e6800000e0000ULL,
0x0c201f002c2d7f89ULL, 0x000ea800000e0000ULL, 0x0c201f00072a7f89ULL, 0x00072200000e0000ULL,
0x0000000d300c7209ULL, 0x002fe40007810000ULL, 0x0000002e2b0d7209ULL, 0x000fc40007810000ULL,
0x0000002d2c0e7209ULL, 0x004fe40007810000ULL, 0x3fb8aa3b0c2c7820ULL, 0x008fe20000410000ULL,
0x3fb8aa3b0d337820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000057886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b03037823ULL, 0x100fe2000001082cULL,
0x3fb8aa3b02027823ULL, 0x100fe2000001082cULL, 0x3fb8aa3b05057823ULL, 0x100fe2000001082cULL,
0x3fb8aa3b08087823ULL, 0x100fe2000001082cULL, 0x3fb8aa3b11117823ULL, 0x100fe2000001082cULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001082cULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001082cULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010833ULL,
0x0000000300037308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b10107823ULL, 0x100fe2000001082cULL,
0x3fb8aa3b12127823ULL, 0x100fe2000001082cULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001082cULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe2000001082cULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe2000001082cULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001082cULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010833ULL,
0x0000000200027308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001082cULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082cULL, 0x3fb8aa3b1f1f7823ULL, 0x000fe2000001082cULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010833ULL,
0x00000011002e7308ULL, 0x002fe20000000800ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b1a1a7823ULL, 0x000fca0000010833ULL,
0x0000001300307308ULL, 0x000ff00000000800ULL, 0x00000014002d7308ULL, 0x000ff00000000800ULL,
0x0000000500057308ULL, 0x000ff00000000800ULL, 0x0000000800087308ULL, 0x000ff00000000800ULL,
0x0000002200117308ULL, 0x000ff00000000800ULL, 0x0000002300147308ULL, 0x000e700000000800ULL,
0x0000002500137308ULL, 0x000ff00000000800ULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x000000111411723eULL, 0x002fce00000000ffULL, 0x00000010000f7308ULL, 0x0003f00000000800ULL,
0x00000012002b7308ULL, 0x0007e20000000800ULL, 0x000000030210723eULL, 0x002fe200000000ffULL,
0x3c003c00ff027424ULL, 0x000fe200078e00ffULL, 0x000000132613723eULL, 0x004fe200000000ffULL,
0x3c003c00ff037424ULL, 0x000fc800078e00ffULL, 0x0000001500327308ULL, 0x000fe20000000800ULL,
0x000000050812723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b24057823ULL, 0x000fcc0000010833ULL,
0x0000002700157308ULL, 0x0003f00000000800ULL, 0x0000001700347308ULL, 0x000fe20000000800ULL,
0x000000021024723cULL, 0x002fee00000018ffULL, 0x0000000a000a7308ULL, 0x000ff00000000800ULL,
0x0000000b000b7308ULL, 0x000e700000000800ULL, 0x0000002800287308ULL, 0x000eb00000000800ULL,
0x0000002900177308ULL, 0x000fe20000000800ULL, 0x0000000a0b14723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b180b7823ULL, 0x000fe20000010833ULL, 0x0000000f00187802ULL, 0x000fca0000000f00ULL,
0x0000000500087308ULL, 0x0002e20000000800ULL, 0x000000152815723eULL, 0x004fce00000000ffULL,
0x00000016002f7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b1c057823ULL, 0x102fe20000010833ULL,
0x0000002b301c723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b19337823ULL, 0x000fe20000010833ULL,
0x000000170817723eULL, 0x008fc800000000ffULL, 0x0000001d00317308ULL, 0x000fe20000000800ULL,
0x0000000f2e16723eULL, 0x004fe400000000ffULL, 0x000000072a0f7209ULL, 0x010fca0007810000ULL,
0x0000001f002c7308ULL, 0x000fe20000000800ULL, 0x000000021424723cULL, 0x000fee0000001824ULL,
0x0000001e001d7308ULL, 0x0003f00000000800ULL, 0x0000002000207308ULL, 0x000ea20000000800ULL,
0x0000002d321e723eULL, 0x002fce00000000ffULL, 0x00000021001f7308ULL, 0x000ff00000000800ULL,
0x0000000500087308ULL, 0x0002e20000000800ULL, 0x0000001d201d723eULL, 0x004fce00000000ffULL,
0x0000001a000a7308ULL, 0x0005e20000000800ULL, 0xfffffffc09057812ULL, 0x002fc800078ec0ffULL,
0x0000000518297219ULL, 0x000fe400000006ffULL, 0x0000002f3418723eULL, 0x000fe200000000ffULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x0000001f081f723eULL, 0x008fe200000000ffULL,
0x00000000292073a1ULL, 0x000ee200000e8000ULL, 0x00000000290473c4ULL, 0x000f220000004000ULL,
0x000000312c1a723eULL, 0x004fc800000000ffULL, 0x000000021c24723cULL, 0x000fe20000001824ULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x0000000a1b19723eULL, 0x002fce00000000ffULL,
0x0000003300087308ULL, 0x000e620000000800ULL, 0x0000000529ff7c12ULL, 0x008fe4000f804020ULL,
0x0000000b081b723eULL, 0x002fd800000000ffULL, 0x000000021824723cULL, 0x000fe20000001824ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000a0204008947ULL, 0x010fde000b800000ULL,
0x001c1fff24207589ULL, 0x0002a400000e0000ULL, 0x00000000290273a1ULL, 0x000ee200000e8000ULL,
0x00000000290473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x0000000529ff7c12ULL, 0x008fda000f804002ULL, 0x00000a2204008947ULL, 0x010fea000b800000ULL,
0x001c1fff26217589ULL, 0x00072800000e0000ULL, 0x001c1fff22227589ULL, 0x00066800000e0000ULL,
0x001c1fff00237589ULL, 0x0006a400000e0000ULL, 0x00000002ff027819ULL, 0x000fe40000011609ULL,
0x0000000c00337812ULL, 0x000fc400078ec0ffULL, 0x0000000702037812ULL, 0x040fe200078ec0ffULL,
0x0000000802247824ULL, 0x042fe200078e00ffULL, 0x0000000302087819ULL, 0x040fe200000006ffULL,
0x00000008022b7824ULL, 0x040fe200078e00ffULL, 0x00000002ff0a7212ULL, 0x000fe400078e33ffULL,
0x0000000802027810ULL, 0x000fe40007ffe0ffULL, 0xfffffff824057812ULL, 0x100fe400078ee203ULL,
0x0000000108077812ULL, 0x100fe200078ef603ULL, 0x00000008023f7824ULL, 0x000fe200078e00ffULL,
0x00000002080b7812ULL, 0x100fe200078ef603ULL, 0x00000008022d7824ULL, 0x000fe200078e00ffULL,
0x0000000308257812ULL, 0x100fe200078ef603ULL, 0x00000008022f7824ULL, 0x000fe200078e00ffULL,
0x0000000408277812ULL, 0x000fc400078ef603ULL, 0x0000000508297812ULL, 0x148fe400078ef603ULL,
0x0000000608037812ULL, 0x000fe400078ef603ULL, 0xfffffff82b2b7812ULL, 0x000fe400078ee20aULL,
0x00000002ff0a7212ULL, 0x000fe400078e33ffULL, 0x0000000702087812ULL, 0x000fe400078ec0ffULL,
0x0000900057027811ULL, 0x000fc400078e58ffULL, 0xfffffff83f3f7812ULL, 0x000fe400078ee20aULL,
0x0000000205007211ULL, 0x080fe200078e20ffULL, 0x0000001007057824ULL, 0x000fe200078e0202ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee208ULL, 0x000000100b077824ULL, 0x000fe200078e0202ULL,
0x000000012f317812ULL, 0x000fe200078ef608ULL, 0x00000010270a7824ULL, 0x000fe200078e0202ULL,
0x000000022f357812ULL, 0x000fe200078ef608ULL, 0x0000001003267824ULL, 0x000fe200078e0202ULL,
0x000000032f377812ULL, 0x000fe200078ef608ULL, 0x0000000133037824ULL, 0x000fe200078e0200ULL,
0x000000042f397812ULL, 0x100fe200078ef608ULL, 0x0000000133057824ULL, 0x000fe200078e0205ULL,
0x000000052f3b7812ULL, 0x100fe200078ef608ULL, 0x0000000133077824ULL, 0x000fe200078e0207ULL,
0x000000062f3d7812ULL, 0x000fe200078ef608ULL, 0x0000001025087824ULL, 0x100fe200078e0202ULL,
0x0000000229247211ULL, 0x000fe200078e20ffULL, 0x000000102b287824ULL, 0x000fe200078e0202ULL,
0x0000000a33257210ULL, 0x040fe20007ffe0ffULL, 0x00000001330b7824ULL, 0x000fe200078e0208ULL,
0x00000002312a7211ULL, 0x000fe200078e20ffULL, 0x000000102d007824ULL, 0x000fe200078e0202ULL,
0x0000001003007388ULL, 0x0003e20000000800ULL, 0x0000000133277824ULL, 0x000fe200078e0224ULL,
0x0000000309ff7812ULL, 0x000fe2000780c0ffULL, 0x00000010352c7824ULL, 0x000fe200078e0202ULL,
0x0000001205007388ULL, 0x0003e20000000800ULL, 0x0000000133297824ULL, 0x040fe200078e0226ULL,
0x0000002a332a7210ULL, 0x000fe20007ffe0ffULL, 0x00000010372d7824ULL, 0x000fe200078e0202ULL,
0x0000001407007388ULL, 0x0003e20000000800ULL, 0x00000001332b7824ULL, 0x000fe200078e0228ULL,
0x000000023d307211ULL, 0x000fe200078e20ffULL, 0x00000010392e7824ULL, 0x000fe200078e0202ULL,
0x000000160b007388ULL, 0x0003e20000000800ULL, 0x0000000133007824ULL, 0x040fe200078e0200ULL,
0x0000003033307210ULL, 0x000fe20007ffe0ffULL, 0x000000103b2f7824ULL, 0x100fe200078e0202ULL,
0x0000001c25007388ULL, 0x0003e20000000800ULL, 0x000000103f317824ULL, 0x000fc400078e0202ULL,
0x00000001332c7824ULL, 0x040fe200078e022cULL, 0x0000001e27007388ULL, 0x0003e20000000800ULL,
0x0000000133027824ULL, 0x040fe400078e022dULL, 0x00000001332e7824ULL, 0x040fe200078e022eULL,
0x0000001829007388ULL, 0x0003e20000000800ULL, 0x0000000133087824ULL, 0x040fe400078e022fULL,
0x00000001330a7824ULL, 0x000fe200078e0231ULL, 0x0000001a2b007388ULL, 0x0003e80000000800ULL,
0x0000001100007388ULL, 0x0003e80000000800ULL, 0x000000132a007388ULL, 0x0003e80000000800ULL,
0x000000152c007388ULL, 0x0003e80000000800ULL, 0x0000001702007388ULL, 0x0003e80000000800ULL,
0x0000001d2e007388ULL, 0x0003e80000000800ULL, 0x0000001f08007388ULL, 0x0003e80000000800ULL,
0x0000001930007388ULL, 0x0003e80000000800ULL, 0x0000001b0a007388ULL, 0x0003e80000000800ULL,
0x0130000c04008388ULL, 0x0003e80000000c00ULL, 0x0132002004008388ULL, 0x0143e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000545100720cULL, 0x000fe20003f26070ULL,
0x0136080006ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff5eff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff597224ULL, 0x000fc600078e0051ULL, 0x00000001ff5e7807ULL, 0x000fce0000000000ULL,
0x0000001000001944ULL, 0x004fe20003c00000ULL, 0xffffb4e000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e003aULL,
0x0000005900077202ULL, 0x000fe20000000f00ULL, 0x0000001fff3b7424ULL, 0x000fe200078e00ffULL,
0x0000fff000027802ULL, 0x000fe20000000f00ULL, 0xffffffffff3c7424ULL, 0x000fe400078e00ffULL,
0x000006c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0005ULL,
0xffff948000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x002fe200078e0059ULL,
0x0000003900087202ULL, 0x000fe20000000f00ULL, 0x0000001fff3b7424ULL, 0x000fe200078e00ffULL,
0x0001007000027802ULL, 0x000fe20000000f00ULL, 0xffffffffff3c7424ULL, 0x000fe400078e00ffULL,
0x0000064000007944ULL, 0x004fea0003c00000ULL, 0xffff943000007947ULL, 0x000fea000383ffffULL,
0x0000000c002c7202ULL, 0x000fe20000000f00ULL, 0x00000002ff2d7424ULL, 0x000fe200078e00ffULL,
0x000100c0002a7802ULL, 0x000fc40000000f00ULL, 0x000005b000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e002cULL, 0xfffff12000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2c7224ULL, 0x000fe200078e002fULL, 0x00010120002a7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2d7424ULL, 0x002fc400078e00ffULL, 0x0000055000007944ULL, 0x004fea0003c00000ULL,
0x0000002c2f0d7209ULL, 0x004fe20007810000ULL, 0x00000002ff2d7424ULL, 0x002fe200078e00ffULL,
0x0000000e002c7202ULL, 0x000fc40000000f00ULL, 0x00010170002a7802ULL, 0x000fe40000000f00ULL,
0x0000050000007944ULL, 0x000fea0003c00000ULL, 0x0000002c0e2f7209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e000fULL, 0x000101c0002a7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2d7424ULL, 0x002fe400078e00ffULL, 0x000004b000007944ULL, 0x000fea0003c00000ULL,
0x0000002c0f077209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e0030ULL,
0x00000001002d7802ULL, 0x002fe40000000f00ULL, 0x00010210002a7802ULL, 0x000fe40000000f00ULL,
0x0000046000007944ULL, 0x000fea0003c00000ULL, 0x0000002c300c7209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e000dULL, 0x00010260002a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2d7424ULL, 0x002fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x0000002c0d0d7209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e002fULL,
0x000102b0002a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2d7424ULL, 0x002fc400078e00ffULL,
0x000003c000007944ULL, 0x000fea0003c00000ULL, 0x0000002c2f0e7209ULL, 0x004fe20007810000ULL,
0x00000001ff2d7424ULL, 0x002fe200078e00ffULL, 0x00000007002c7202ULL, 0x000fc40000000f00ULL,
0x00010300002a7802ULL, 0x000fe40000000f00ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2a7224ULL, 0x004fe200078e002cULL, 0xffffefd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x000fe200078e0024ULL, 0x0001038000027802ULL, 0x000fe20000000f00ULL,
0x000000ffff087224ULL, 0x000fe400078e00ffULL, 0x00001c1fff3b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fe400078e0029ULL, 0x0000033000007944ULL, 0x000fea0003c00000ULL,
0x0000000500207202ULL, 0x004fe20000000f00ULL, 0xfffff59000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x002fe200078e0026ULL, 0x0001040000027802ULL, 0x000fe20000000f00ULL,
0x000000ffff087224ULL, 0x000fc400078e00ffULL, 0x00001c1fff3b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fe400078e0029ULL, 0x000002b000007944ULL, 0x004fea0003c00000ULL,
0x000000ff00087202ULL, 0x002fe20000000f00ULL, 0x00001c1fff3b7424ULL, 0x000fe200078e00ffULL,
0x0001046000027802ULL, 0x000fe20000000f00ULL, 0x000000ffff3c7224ULL, 0x000fe400078e0029ULL,
0x000000ffff217224ULL, 0x004fe400078e0005ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff3c7224ULL, 0x002fe200078e0029ULL, 0x000000ff00087202ULL, 0x000fe20000000f00ULL,
0x00001c1fff3b7424ULL, 0x000fe200078e00ffULL, 0x000104c000027802ULL, 0x000fe20000000f00ULL,
0x000000ffff227224ULL, 0x004fc400078e0005ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff237224ULL, 0x004fe200078e0005ULL, 0xfffff4d000007947ULL, 0x000fea000383ffffULL,
0x0180000002067810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000006077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000000200068308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff077807ULL, 0x000fe40000800000ULL, 0x00000001ff067807ULL, 0x004fc80004000000ULL,
0x0000000607ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff02ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff067807ULL, 0x000fc80000000000ULL,
0x0000000607ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000002077812ULL, 0x000fd600078ec0ffULL,
0x0080000007060812ULL, 0x000fe200078efcffULL, 0x000000ffff068224ULL, 0x000fe200078e0007ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000200067308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff087224ULL, 0x00cfe200078e0006ULL,
0x0000000500067202ULL, 0x000fe20000000f00ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffef99006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff2b7424ULL, 0x000fe200078e00ffULL,
0x0000003100007348ULL, 0x000fe80003800000ULL, 0x0c00002d2c2c7389ULL, 0x0002a200000e002eULL,
0xfffef9502a007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff037424ULL, 0x000fe200078e00ffULL,
0x0000003c00007348ULL, 0x000fe80003800000ULL, 0x0000000807057389ULL, 0x0002a200000e003bULL,
0xfffef91002007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000013680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x0000000000000218ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000007b0ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000828ULL, 0x0000000000000460ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000c88ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ca8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000cb8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000cd8ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000d48ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000d50ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000d60ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000f80ULL, 0x0000000000010780ULL, 0x7100001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000011700ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000011710ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000011710ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000011b90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000d48ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000109b8ULL, 0x00000000000109b8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000011700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000011b90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_16_m_16_sm_86_cubin_len = 72816;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
