/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001a230ULL, 0x0000000000019eb0ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x346a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4532336a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45346a4c4545326aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x000000676e696469ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x6e695f5f24000000ULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x722e006874617077ULL, 0x2e747865742e6c65ULL,
0x6d5f6c656e72656bULL, 0x616c65722e006168ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL,
0x0000000000000061ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL,
0x0000000000000028ULL, 0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000017cULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000b0001000001beULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b000100000204ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000b00010000024bULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b000100000291ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000002dfULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b00010000032dULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a002200000388ULL, 0x0000000000018b10ULL, 0x0000000000000270ULL, 0x00040003000003feULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL,
0x0000000000018d80ULL, 0x000d00030000042eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00018b1000000000ULL, 0x0001400400000000ULL, 0x0000288080810c00ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080860828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808692ULL, 0x0000001cffffffffULL, 0x0000006000000000ULL, 0x00018b1000000000ULL,
0x0000027000000000ULL, 0x0000000000000000ULL, 0x0000001300082f04ULL, 0x00082304000000ddULL,
0x0000000000000011ULL, 0x0000001100081204ULL, 0x0008110400000000ULL, 0x0000000000000011ULL,
0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0058000a00000000ULL, 0x000c17040021f000ULL,
0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040061f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0xffffffff010c2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000001a0010c2804ULL, 0x0000083000000300ULL,
0x0000317000002250ULL, 0x000032e0000031f0ULL, 0x0000354000003410ULL, 0x00003a5000003680ULL,
0x00003a7000003a60ULL, 0x0000413000003a80ULL, 0x0000500000004f60ULL, 0x00005210000050e0ULL,
0x0000548000005340ULL, 0x00005700000056f0ULL, 0x0000572000005710ULL, 0x00006b3000005d20ULL,
0x00006cb000006bd0ULL, 0x00006f1000006de0ULL, 0x0000733000007050ULL, 0x0000735000007340ULL,
0x000078b000007360ULL, 0x000087a000008720ULL, 0x000089c000008890ULL, 0x00008c3000008af0ULL,
0x00008f2000008f10ULL, 0x00008f4000008f30ULL, 0x0000983000009820ULL, 0x0000985000009840ULL,
0x0000c4600000c400ULL, 0x0000c5800000c540ULL, 0x0000ce300000ce10ULL, 0x0000ce500000ce40ULL,
0x0001741000017360ULL, 0x00017810000176f0ULL, 0x00017db000017c20ULL, 0x000180e000018030ULL,
0x0000055001f03904ULL, 0x0001e600000000ffULL, 0x0000063000040100ULL, 0x0001e60800000000ULL,
0x00000740003f0100ULL, 0x0001e68800000003ULL, 0x000011e0003f0100ULL, 0x0001e60000000095ULL,
0x00001310003f0107ULL, 0x0001e68800000004ULL, 0x00002ee0003f0101ULL, 0x0001e60800000034ULL,
0x00002f20003f0101ULL, 0x0001e60800000037ULL, 0x00003090003f0109ULL, 0x0001e60800000037ULL,
0x000040d0003f0109ULL, 0x0001e68800000039ULL, 0x00004d30003f0101ULL, 0x0001e62800000039ULL,
0x00004d60003f0101ULL, 0x0001e6280000004dULL, 0x00004ed0003f0109ULL, 0x0001e6280000004dULL,
0x00005cb0003f0109ULL, 0x0001e69000000039ULL, 0x00006910003f0101ULL, 0x0001e6480000003bULL,
0x00006930003f0101ULL, 0x0001e6480000003bULL, 0x00006aa0003f0109ULL, 0x0001e6480000003bULL,
0x00007840003f0109ULL, 0x0001e6980000003aULL, 0x00008500003f0101ULL, 0x0001e6680000003bULL,
0x00008520003f0101ULL, 0x0001e6680000003bULL, 0x00008690003f0109ULL, 0x0001e6680000003bULL,
0x00009350003f0109ULL, 0x0001e6a000000038ULL, 0x0000eb30003f0101ULL, 0x0001e60000000095ULL,
0x00010370003f0101ULL, 0x0001e60000000095ULL, 0x00010530003f0109ULL, 0x0001e60000000095ULL,
0x00014870003f0109ULL, 0x0001e6880000001fULL, 0x00014d90003f0101ULL, 0x0001e6880000001fULL,
0x00014f00003f0109ULL, 0x0001e6880000001fULL, 0x00018ab0003f0109ULL, 0x0001e6080000001cULL,
0x00018ac0003f0101ULL, 0x0001e6100000001cULL, 0x00018ad0003f0101ULL, 0x0001e6180000001cULL,
0x00018ae0003f0101ULL, 0x0001e6200000001cULL, 0x00033803003f0101ULL, 0x0000da3000301c04ULL,
0x0000dd200000da60ULL, 0x0000e1000000df10ULL, 0x0000e4e00000e2f0ULL, 0x0000e8d00000e6d0ULL,
0x000105600000ea80ULL, 0x000c050400018b00ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0060190300000000ULL, 0x0000001400080a04ULL, 0x0000000000600210ULL, 0x00000000000000bcULL,
0x0000001300000002ULL, 0x0000000000018b10ULL, 0x0000000000000044ULL, 0x0000001300000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001300000002ULL, 0x0000000000000000ULL,
0x000000000001e700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000117919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fcc0000000a00ULL,
0x00008500ff157b82ULL, 0x000f220000000800ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff022b82ULL, 0x000ea20000000a00ULL,
0x0000000111072836ULL, 0x008fe40000000000ULL, 0x0000000411042825ULL, 0x004fc800078e0002ULL,
0x0000000407022825ULL, 0x000fe400078e0002ULL, 0x0000000604042981ULL, 0x0004e8000c1e1900ULL,
0x00000006029b2981ULL, 0x000ae2000c1e1900ULL, 0x0000001500007306ULL, 0x010f220000209000ULL,
0x00000300ff997b82ULL, 0x000ee20000000800ULL, 0x0000040000047ab9ULL, 0x000fe20000000800ULL,
0x000000ff1500720cULL, 0x000fe20003f65070ULL, 0x00000000000b7919ULL, 0x000f620000002300ULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x0000000000057919ULL, 0x004ea60000002100ULL,
0x00000000000579c3ULL, 0x000ea20000002600ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00067836ULL, 0x010fcc0000000000ULL, 0x0000000600077305ULL, 0x000962000021f000ULL,
0x00000005ff987819ULL, 0x004fe20000011605ULL, 0x000000ffff067224ULL, 0x010fca00078e00ffULL,
0x00001fff98987589ULL, 0x000ea200000e0000ULL, 0x000000ffff087224ULL, 0x022fc800078e0a07ULL,
0x0000001508097224ULL, 0x000fc800078e02ffULL, 0x0000000907077227ULL, 0x000fe400078e0006ULL,
0x0000000000067919ULL, 0x000e680000002200ULL, 0x0000000407077c27ULL, 0x000fca000f8e00ffULL,
0x000000ff07007210ULL, 0x000fca0007ffe1ffULL, 0x0000000415007e24ULL, 0x000fe2000f8e0200ULL,
0x0000010000047ab9ULL, 0x000fc80000000800ULL, 0x000000150000720cULL, 0x000fda0003f06070ULL,
0x0000000100000824ULL, 0x000fe400078e0a15ULL, 0x0000000107070836ULL, 0x000fc60000000000ULL,
0x000000150000720cULL, 0x000fda0003f26070ULL, 0x0000000107071836ULL, 0x000fe20000000000ULL,
0x00000015ff07b212ULL, 0x000fc800078e33ffULL, 0x0000000700007306ULL, 0x000f220000209000ULL,
0x000000ff0700720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00037836ULL, 0x010fe40000000000ULL, 0x000000040b007c24ULL, 0x002fe2000f8e0206ULL,
0x0000000000047ab9ULL, 0x000fe20000000800ULL, 0x00008400ff06ab82ULL, 0x000ea20000000800ULL,
0x00001fff0b0b7589ULL, 0x000ea200000e0000ULL, 0x0000000300037305ULL, 0x000e64000021f000ULL,
0x0000000307027224ULL, 0x002fca00078e02ffULL, 0x000000ff02097210ULL, 0x000fe20007ffe1ffULL,
0x000000ffff027224ULL, 0x000fc800078e00ffULL, 0x0000000903027227ULL, 0x000fc800078e0002ULL,
0x0000000400037c24ULL, 0x000fe2000f8e0205ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x0000000502027c27ULL, 0x000fc6000f8e00ffULL, 0x0000007f0300780cULL, 0x000fe20003f64070ULL,
0x000000ffff007224ULL, 0x000fc800078e0a02ULL, 0x0000000507007e24ULL, 0x000fca000f8e0200ULL,
0x000000070000720cULL, 0x000fc60003f06070ULL, 0x000000000009b919ULL, 0x000f220000008800ULL,
0x000004000008b802ULL, 0x000fe20000000f00ULL, 0x00000004ff9a7e24ULL, 0x002fd0000f8e00ffULL,
0x0000000100000824ULL, 0x000fe400078e0a07ULL, 0x0000000102020836ULL, 0x000fe20000000000ULL,
0x000000ff0300720cULL, 0x000fe40003f05270ULL, 0x000000070000720cULL, 0x000fda0003f26070ULL,
0x0000000102021836ULL, 0x000fe20000000000ULL, 0x00000007ff02c212ULL, 0x000fe400078e33ffULL,
0x0000000f0300780cULL, 0x000fe40003f24070ULL, 0x00000654090ab816ULL, 0x010fe20000000008ULL,
0x000000ffff007224ULL, 0x000fe200078e0a02ULL, 0x000000030300780cULL, 0x040fe20003f84070ULL,
0xff317217ff08b424ULL, 0x000fe200078e00ffULL, 0x0000000a0305b211ULL, 0x000fe200078e10ffULL,
0x0000000507977e24ULL, 0x000fe2000f8e0200ULL, 0x0000009b049b2210ULL, 0x008fcc0007ffe1ffULL,
0x00008400ff9bab82ULL, 0x000e640000000800ULL, 0x0000000000240947ULL, 0x006fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x004fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000eb40000000000ULL, 0x01e60008043f75b2ULL, 0x0004a40008000100ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000403007c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000000812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x01e60804083f75b2ULL, 0x0004b00008000100ULL, 0xfffffffd00e81947ULL, 0x004fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000403037c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000030812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x01e68804083f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x004fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002097977824ULL, 0x000fe200078e00ffULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x000000061104a224ULL, 0x000fe200078e02ffULL, 0x01e400080500b388ULL, 0x0005e20000000800ULL,
0x000000049b007c24ULL, 0x002fe4000f8e02ffULL, 0x000000ffff037224ULL, 0x000fe400078e0a97ULL,
0x0000000415137c24ULL, 0x000fe2000f8e02ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000970000720cULL, 0x000fc40003f06070ULL, 0x00000020005c7446ULL, 0x000fe20003800003ULL,
0x000000040b007824ULL, 0x000fe400078e0298ULL, 0x0000001304037224ULL, 0x000fe200078e02ffULL,
0x000000ff5c5c7207ULL, 0x000fe20000000000ULL, 0x0000000400057824ULL, 0x004fe400078e00ffULL,
0x0000000402127c24ULL, 0x000fe2000f8e0203ULL, 0x000000205c00780cULL, 0x000fda0003f05270ULL,
0x00000004002c8947ULL, 0x000fea0003800000ULL, 0x0000000400097d06ULL, 0x000e620008209000ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x000000ff00067202ULL, 0x000fe40000000f00ULL,
0x0000040000957802ULL, 0x000fe20000000f00ULL, 0x0000000000147919ULL, 0x000ee60000008800ULL,
0x0000000900097308ULL, 0x002e640000001000ULL, 0x0ffffffe09077810ULL, 0x002fc40007ffe0ffULL,
0x00000004ff087819ULL, 0x004fc80000011600ULL, 0x0000000700077305ULL, 0x000e62000021f000ULL,
0x0000065414957816ULL, 0x008fe20000000095ULL, 0x00000002080d7836ULL, 0x000fe40000000000ULL,
0x00000001050a7824ULL, 0x040fe400078e0208ULL, 0x00000001050e7824ULL, 0x000fc800078e020dULL,
0x0000000197107824ULL, 0x000fe400078e020eULL, 0x000000ffff0f7224ULL, 0x002fc800078e0a07ULL,
0x000000040f0f7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000f07097227ULL, 0x000fc800078e0006ULL,
0x0000000197067824ULL, 0x000fe400078e020aULL, 0x00000010090f7227ULL, 0x000fc800078e00ffULL,
0x0000000609077227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fe400078e0a07ULL,
0x000000ffff177224ULL, 0x000fe400078e0a0fULL, 0x0000000409097c24ULL, 0x000fe4000f8e0206ULL,
0x00000004170c7c24ULL, 0x000fc6000f8e0210ULL, 0x0000000409007c0cULL, 0x000fe4000bf06070ULL,
0x000000040c007c0cULL, 0x000fd6000bf46070ULL, 0x8000000409090c10ULL, 0x000fe2000fffe0ffULL,
0x0000000107070836ULL, 0x000fe20000000000ULL, 0x00000004ff007c0cULL, 0x000fe2000bf05070ULL,
0x800000040c0c2c36ULL, 0x000fe20008000000ULL, 0x0000000409007c0cULL, 0x000fe2000bf26070ULL,
0x000000010f0f2836ULL, 0x000fc60000000000ULL, 0x000000040c007c0cULL, 0x000fe4000bf66070ULL,
0x00000004ff0c7c12ULL, 0x000fce000f8e33ffULL, 0x0000000107071836ULL, 0x000fc80000000000ULL,
0x000000010f0f3810ULL, 0x000fe40007ffe0ffULL, 0x000000070c077207ULL, 0x040fe40004000000ULL,
0x0000000f0c0f7207ULL, 0x000fc60004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a07ULL,
0x000000ffff177224ULL, 0x000fe400078e0a0fULL, 0x0000000409097c24ULL, 0x000fe2000f8e0206ULL,
0x000000055c067248ULL, 0x000fe20007fe0000ULL, 0x0000000417107c24ULL, 0x000fe2000f8e0210ULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000001120c7824ULL, 0x000fe400078e0209ULL,
0x0000000106067824ULL, 0x000fe200078e0a05ULL, 0x0000001012107210ULL, 0x000fe20007ffe0ffULL,
0x0000001307077224ULL, 0x000fc400078e020cULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x000000060800720cULL, 0x080fe20003f06070ULL, 0x000000130f087224ULL, 0x000fe200078e0210ULL,
0x000000060d00720cULL, 0x000fe20003f26070ULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x000000f0050d7812ULL, 0x000fc600078ec0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000d06067212ULL, 0x000fc600078efcffULL, 0x000000010a0c7824ULL, 0x100fe200078e0200ULL,
0x0000000d08087212ULL, 0x000fe200078efcffULL, 0x000000100a0f7824ULL, 0x000fe200078e00ffULL,
0x000000040e0d7819ULL, 0x040fe200000006ffULL, 0x000000010e0a7824ULL, 0x000fe200078e0200ULL,
0x0000000406067c10ULL, 0x000fe4000ff5e0ffULL, 0xfffffff00f0c7812ULL, 0x000fe400078ee20cULL,
0xfffffff00d0a7812ULL, 0x000fe400078ee20aULL, 0x0000000408087c10ULL, 0x000fe2000ff7e0ffULL,
0x000000100c0d7824ULL, 0x100fe200078e0295ULL, 0x0000000507077c10ULL, 0x000fe200097fe4ffULL,
0x000000100a0f7824ULL, 0x000fe200078e0295ULL, 0x0000000509097c10ULL, 0x000fc60009ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e8000c101c46ULL,
0x00000000080f7faeULL, 0x0003e2000c901c46ULL, 0x0000000400107947ULL, 0x000fea0003800000ULL,
0x0000000400087d06ULL, 0x000e620008209000ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000040000957802ULL, 0x000fe20000000f00ULL, 0x00000000000e7919ULL, 0x000eea0000008800ULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe08077836ULL, 0x002fe20000000000ULL,
0x00000005000a7211ULL, 0x004fca00078fe0ffULL, 0x0000000700077305ULL, 0x000e62000021f000ULL,
0x000000020a0d7810ULL, 0x000fe40007ffe0ffULL, 0x000006540e957816ULL, 0x008fc60000000095ULL,
0x0000000197087824ULL, 0x000fe400078e020dULL, 0x000000ffff067224ULL, 0x002fc800078e0a07ULL,
0x0000000406057c24ULL, 0x000fe4000f8e02ffULL, 0x000000ffff067224ULL, 0x000fc800078e00ffULL,
0x0000000507097227ULL, 0x000fc800078e0006ULL, 0x0000000197057824ULL, 0x000fc800078e020aULL,
0x0000000509067227ULL, 0x000fc800078e00ffULL, 0x0000000809097227ULL, 0x000fc800078e00ffULL,
0x000000ffff0c7224ULL, 0x000fe200078e0a06ULL, 0x000000ff090f7210ULL, 0x000fc60007ffe1ffULL,
0x000000040c077c24ULL, 0x000fe4000f8e0205ULL, 0x000000040f0c7c24ULL, 0x000fc6000f8e0208ULL,
0x0000000407007c0cULL, 0x000fe4000bf06070ULL, 0x000000040c007c0cULL, 0x000fd6000bf46070ULL,
0x8000000407070c36ULL, 0x000fe40008000000ULL, 0x800000040c0c2c36ULL, 0x000fe40008000000ULL,
0x0000000109092836ULL, 0x000fe20000000000ULL, 0x0000000407007c0cULL, 0x000fe2000bf26070ULL,
0x0000000106060836ULL, 0x000fe20000000000ULL, 0x000000040c007c0cULL, 0x000fe4000bf66070ULL,
0x00000004ff007c0cULL, 0x000fe4000bf05070ULL, 0x00000004ff077c12ULL, 0x000fce000f8e33ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x0000000109093836ULL, 0x000fe40000000000ULL,
0x0000000607067207ULL, 0x000fc60004000000ULL, 0x0000000907097207ULL, 0x000fe40004000000ULL,
0x000000ffff0c7224ULL, 0x000fc600078e0a06ULL, 0x000000ffff077224ULL, 0x000fe400078e0a09ULL,
0x000000040c057c24ULL, 0x000fe4000f8e0205ULL, 0x0000000407087c24ULL, 0x000fe2000f8e0208ULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000112077824ULL, 0x000fe400078e0205ULL,
0x0000001000057824ULL, 0x000fe200078e00ffULL, 0x0000000812087210ULL, 0x000fe20007ffe0ffULL,
0x0000001306077224ULL, 0x000fc400078e0207ULL, 0x000000010a0c7824ULL, 0x000fe200078e0200ULL,
0x000000f0050f7812ULL, 0x000fe200078ec0ffULL, 0x0000001309087224ULL, 0x000fe400078e0208ULL,
0x0000010007067825ULL, 0x000fc800078e00ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000f06067212ULL, 0x000fc600078efcffULL, 0x000000100a137824ULL, 0x000fe200078e00ffULL,
0x0000000f08087212ULL, 0x000fe200078efcffULL, 0x000000010d0a7824ULL, 0x040fe200078e0200ULL,
0x000000040d0d7819ULL, 0x000fe400000006ffULL, 0xfffffff0130c7812ULL, 0x000fe400078ee20cULL,
0x0000000406067c10ULL, 0x000fe4000ff1e0ffULL, 0xfffffff00d0a7812ULL, 0x000fe200078ee20aULL,
0x000000100c0d7824ULL, 0x000fe200078e0295ULL, 0x0000000408087c10ULL, 0x000fc4000ff3e0ffULL,
0x0000000507077c10ULL, 0x000fe200087fe4ffULL, 0x000000100a0f7824ULL, 0x000fe200078e0295ULL,
0x0000000509097c10ULL, 0x000fc60008ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e8000b901c46ULL, 0x00000000080f7faeULL, 0x0003e4000b901c46ULL,
0x00000000950472caULL, 0x000fe200000e0000ULL, 0x00009200ff067b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x0001e60004047890ULL, 0x000fd2000fffe03fULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000411067825ULL, 0x002fe200078e0006ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000606967981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0b00720cULL, 0x000fe20003f05270ULL,
0x000000ff96947836ULL, 0x004fca0000000000ULL, 0x00000008ff947819ULL, 0x000fce0000011694ULL,
0x000000d800008947ULL, 0x000fea0003800000ULL, 0x0000000898747824ULL, 0x000fe200078e00ffULL,
0x0000000400077802ULL, 0x000fe20000000f00ULL, 0x000000019a097836ULL, 0x000fe20000000000ULL,
0x00000001ff727819ULL, 0x000fe20000011698ULL, 0x0000000195047824ULL, 0x000fe200078e0274ULL,
0x0000940000047ab9ULL, 0x000fe20000000800ULL, 0x0000000211067824ULL, 0x000fe200078e00ffULL,
0x000000940900720cULL, 0x000fe20003f06070ULL, 0x01e6880704ff79a7ULL, 0x0003e2000850003fULL,
0x0000002072717824ULL, 0x000fe200078e00ffULL, 0x00000001986e7812ULL, 0x000fc600078ec0ffULL,
0x000001009a0b7824ULL, 0x000fe400078e0271ULL, 0x0000001506077224ULL, 0x002fca00078e0215ULL,
0x0000000702707210ULL, 0x000fca0007ffe0ffULL, 0x0000000470147c24ULL, 0x000fe2000f8e020bULL,
0x0000000400988947ULL, 0x000fec0003800000ULL, 0x0000007005057812ULL, 0x000fe200078ec0ffULL,
0x0000900000047ab9ULL, 0x000fe20000000a00ULL, 0x00000003ff0f7819ULL, 0x000fe40000011600ULL,
0x0000000b96087248ULL, 0x000fe20007fe0000ULL, 0x000000806e047824ULL, 0x000fe200078e0205ULL,
0x000000ff00057202ULL, 0x000fe20000000f00ULL, 0x0000000114077824ULL, 0x000fe200078e020fULL,
0x000000080f157810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a0bULL,
0x0000010007067825ULL, 0x000fc600078e0004ULL, 0x00000020080e7446ULL, 0x000fe2000380000bULL,
0x000000040f097836ULL, 0x000fe20000000000ULL, 0x00000004060c7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000010f087824ULL, 0x100fe200078e0200ULL, 0x00000015140b7210ULL, 0x000fe20007ffe0ffULL,
0x00000001090a7824ULL, 0x040fe200078e0200ULL, 0x00000005070d7c10ULL, 0x000fe200087fe4ffULL,
0x0000000809137824ULL, 0x040fe200078e00ffULL, 0x0000000e0900720cULL, 0x080fe20003f26070ULL,
0x0000400072077824ULL, 0x000fe200078e0295ULL, 0x0000000708117812ULL, 0x000fe200078ec0ffULL,
0x0000000114097824ULL, 0x000fe200078e0209ULL, 0x0000000e0f00720cULL, 0x080fe20003f06070ULL,
0x0000000c0f177836ULL, 0x000fe20000000000ULL, 0x0ffffff811117812ULL, 0x000fe200078ef800ULL,
0x000020006e107824ULL, 0x000fe200078e0207ULL, 0xfffffff813137812ULL, 0x000fe200078ee20aULL,
0x0000010009067825ULL, 0x000fe200078e0004ULL, 0x0000000e1500720cULL, 0x000fc40003fa6070ULL,
0x0000000e1700720cULL, 0x000fe20003f86070ULL, 0x0000000114197824ULL, 0x000fe200078e0217ULL,
0x0000000406067c10ULL, 0x000fe2000ff5e0ffULL, 0x000001000b087825ULL, 0x000fc600078e0004ULL,
0x0000000507077c10ULL, 0x000fe200097fe4ffULL, 0x0001600010107836ULL, 0x000fe20000000000ULL,
0x0000000408087c10ULL, 0x000fe2000ff7e0ffULL, 0x00000100190a7825ULL, 0x000fe200078e0004ULL,
0x000000100f197810ULL, 0x000fe40007ffe0ffULL, 0x0000000509097c10ULL, 0x000fe20009ffe4ffULL,
0x0000001011117824ULL, 0x100fe200078e0210ULL, 0x00000019141b7210ULL, 0x000fe20007ffe0ffULL,
0x0000001013137824ULL, 0x000fe200078e0210ULL, 0x000000040a0a7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000140f1d7836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c117faeULL, 0x0003e2000c101c46ULL, 0x0000000817167824ULL, 0x000fe200078e00ffULL,
0x000000050b0b7c10ULL, 0x000fe200097fe4ffULL, 0x000000180f1f7836ULL, 0x000fe20000000000ULL,
0x0000000006137faeULL, 0x0005e2000c901c46ULL, 0x0000001c0f217836ULL, 0x000fe20000000000ULL,
0x0000000e1900720cULL, 0x080fe20003f66070ULL, 0x00000001150f7824ULL, 0x100fe200078e0200ULL,
0x0000000e1d00720cULL, 0x080fe20003f46070ULL, 0x0000000815127824ULL, 0x000fe200078e00ffULL,
0x0000000e1f00720cULL, 0x080fe20003f26070ULL, 0x0000000114157824ULL, 0x000fe200078e021dULL,
0x0000000e2100720cULL, 0x000fe20003f06070ULL, 0x00000001170d7824ULL, 0x102fe200078e0200ULL,
0xfffffff812117812ULL, 0x000fe200078ee20fULL, 0x000000011d127824ULL, 0x000fe200078e0200ULL,
0x00000000190f7210ULL, 0x000fe20007ffe0ffULL, 0x000001001b067825ULL, 0x004fe200078e0004ULL,
0xfffffff816137812ULL, 0x000fc400078ee20dULL, 0x00000021141b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000819167824ULL, 0x000fe200078e00ffULL, 0x00000004060c7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000114197824ULL, 0x000fe200078e021fULL, 0x0000001011117211ULL, 0x000fe200078e20ffULL,
0x000000081d177824ULL, 0x000fe200078e00ffULL, 0x00000005070d7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000010015067825ULL, 0x000fe200078e0004ULL, 0xfffffff816157812ULL, 0x000fe200078ee20fULL,
0x0000000008117faeULL, 0x0003e2000e901c46ULL, 0xfffffff817177812ULL, 0x000fe200078ee212ULL,
0x000000011f127824ULL, 0x100fe200078e0200ULL, 0x00000004060e7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000121147824ULL, 0x000fc400078e0200ULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0x00000005070f7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000010019067825ULL, 0x000fc800078e0004ULL,
0x000000081f197824ULL, 0x000fe200078e00ffULL, 0x0000000406067c10ULL, 0x000fe2000ffde0ffULL,
0x000001001b047825ULL, 0x000fe200078e0004ULL, 0xfffffff8211b7812ULL, 0x000fe400078ee214ULL,
0xfffffff819197812ULL, 0x000fe200078ee212ULL, 0x0000001013137824ULL, 0x100fe200078e0210ULL,
0x0000000507077c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001015157824ULL, 0x100fe200078e0210ULL,
0x0000000404047c10ULL, 0x000fe2000ffde0ffULL, 0x0000001017177824ULL, 0x100fe200078e0210ULL,
0x000000101b1b7211ULL, 0x000fe200078e20ffULL, 0x0000001019197824ULL, 0x000fe200078e0210ULL,
0x0000000505057c10ULL, 0x000fe2000b7fe4ffULL, 0x000000000a137faeULL, 0x0003e8000e101c46ULL,
0x000000000c157faeULL, 0x0003e8000d901c46ULL, 0x000000000e177faeULL, 0x0003e8000d101c46ULL,
0x0000000006197faeULL, 0x0003e8000c901c46ULL, 0x00000000041b7faeULL, 0x0003e2000c101c46ULL,
0x0000000400647947ULL, 0x000fea0003800000ULL, 0x0000000400097811ULL, 0x040fe200078fe8ffULL,
0x0000900000047ab9ULL, 0x000fe20000000a00ULL, 0x00000008000b7811ULL, 0x040fe400078fe8ffULL,
0x0000001400117811ULL, 0x040fe200078fe8ffULL, 0x0000000109047824ULL, 0x140fe200078e0200ULL,
0x0000000c000d7811ULL, 0x040fe200078fe8ffULL, 0x0000000809077824ULL, 0x000fe200078e00ffULL,
0x00000003111e7819ULL, 0x000fe200000006ffULL, 0x000000010b067824ULL, 0x140fe200078e0200ULL,
0x0000001800137811ULL, 0x040fe200078fe8ffULL, 0x000000080b0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff807167812ULL, 0x000fe200078ee204ULL, 0x0000000111077824ULL, 0x100fe200078e0200ULL,
0x000000000d047210ULL, 0x000fe20007ffe0ffULL, 0x000000080d157824ULL, 0x000fe200078e00ffULL,
0xfffffff80f187812ULL, 0x000fe200078ee206ULL, 0x0000000113087824ULL, 0x140fe200078e0200ULL,
0x00000010000f7811ULL, 0x000fe200078fe8ffULL, 0x0000000813197824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee207ULL, 0x0000000114097824ULL, 0x000fe200078e0209ULL,
0x0000007005077812ULL, 0x000fe200078ec0ffULL, 0x000000010f067824ULL, 0x140fe200078e0200ULL,
0xfffffff8151a7812ULL, 0x000fe200078ee204ULL, 0x000000080f177824ULL, 0x000fe200078e00ffULL,
0x0000000000047211ULL, 0x000fe200078fe8ffULL, 0x0000400072157824ULL, 0x000fe200078e0295ULL,
0x0000001c00057811ULL, 0x000fe200078fe8ffULL, 0x000000806e127824ULL, 0x000fe200078e0207ULL,
0xfffffff8171c7812ULL, 0x000fe200078ee206ULL, 0x00000001140b7824ULL, 0x000fe200078e020bULL,
0xfffffff819207812ULL, 0x000fe200078ee208ULL, 0x0000000805197824ULL, 0x040fe200078e00ffULL,
0x0000000704077812ULL, 0x000fe200078ec0ffULL, 0x0000000105047824ULL, 0x000fe200078e0200ULL,
0x000000156e067211ULL, 0x000fe200078e68ffULL, 0x0000000114177824ULL, 0x000fe200078e0205ULL,
0x0000001400057211ULL, 0x000fe200078fe8ffULL, 0x0000000114157824ULL, 0x040fe200078e0213ULL,
0x0000001114117210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200078e00ffULL,
0xfffffff819227812ULL, 0x000fe200078ee204ULL, 0x00000001140d7824ULL, 0x040fe200078e020dULL,
0x0001600006237810ULL, 0x000fe20007ffe0ffULL, 0x00000001140f7824ULL, 0x000fe200078e020fULL,
0x0ffffff807147812ULL, 0x000fe200078ef800ULL, 0x0000010005047825ULL, 0x000fe200078e0012ULL,
0x000000231a1b7211ULL, 0x000fc600078e20ffULL, 0x0000010009067825ULL, 0x000fe200078e0012ULL,
0x0000000404047c10ULL, 0x000fc6000ff1e0ffULL, 0x000001000b087825ULL, 0x100fe200078e0012ULL,
0x0000000406067c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000505057c10ULL, 0x000fe200087fe4ffULL,
0x000001000d0a7825ULL, 0x100fe200078e0012ULL, 0x0000000408087c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000507077c10ULL, 0x000fe20008ffe4ffULL, 0x000001000f0c7825ULL, 0x100fe200078e0012ULL,
0x000000040a0a7c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000509097c10ULL, 0x000fe200097fe4ffULL,
0x00000100110e7825ULL, 0x000fe200078e0012ULL, 0x000000040c0c7c10ULL, 0x000fc4000ff1e0ffULL,
0x000000050b0b7c10ULL, 0x000fe20009ffe4ffULL, 0x0000010015107825ULL, 0x100fe200078e0012ULL,
0x000000040e0e7c10ULL, 0x000fe4000ff3e0ffULL, 0x000000050d0d7c10ULL, 0x000fe200087fe4ffULL,
0x0000010017127825ULL, 0x000fe200078e0012ULL, 0x0000000410107c10ULL, 0x000fe4000ff5e0ffULL,
0x000000050f0f7c10ULL, 0x000fe20008ffe4ffULL, 0x0000001014157824ULL, 0x100fe200078e0223ULL,
0x0000000412127c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001016177824ULL, 0x100fe200078e0223ULL,
0x0000000511117c10ULL, 0x000fe200097fe4ffULL, 0x0000001018197824ULL, 0x100fe200078e0223ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004157faeULL, 0x0003e2000b901c46ULL,
0x000000101c1d7824ULL, 0x100fe200078e0223ULL, 0x0000000513137c10ULL, 0x000fe20009ffe4ffULL,
0x000000101e1f7824ULL, 0x100fe200078e0223ULL, 0x0000000006177faeULL, 0x0003e2000b901c46ULL,
0x0000001020217824ULL, 0x000fc400078e0223ULL, 0x0000001022237824ULL, 0x000fe200078e0223ULL,
0x0000000008197faeULL, 0x0003e8000b901c46ULL, 0x000000000a1b7faeULL, 0x0003e8000b901c46ULL,
0x000000000c1d7faeULL, 0x0003e8000b901c46ULL, 0x000000000e1f7faeULL, 0x0003e8000b901c46ULL,
0x0000000010217faeULL, 0x0003e8000b901c46ULL, 0x0000000012237faeULL, 0x0003e4000b901c46ULL,
0x000000949a00720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217005d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff7c7224ULL, 0x000fe200078e00ffULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fc4000001ff00ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fc4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x0000000000227805ULL, 0x002fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fc4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000c7805ULL, 0x000fc4000001ff00ULL,
0x0000000000827805ULL, 0x000fe4000001ff00ULL, 0x0000000000807805ULL, 0x000fe4000001ff00ULL,
0x00000000000a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000007000980947ULL, 0x000fec0003800000ULL, 0xff317217ff5d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff337224ULL, 0x000fce00078e00ffULL, 0x000000019a057810ULL, 0x000fe20007ffe0ffULL,
0x000001009a7b7824ULL, 0x000fe200078e0271ULL, 0x0000940000047ab9ULL, 0x000fe40000000800ULL,
0x000000940500720cULL, 0x000fe20003f06070ULL, 0x000000407b077836ULL, 0x000fc80000000000ULL,
0x00000004704f7c24ULL, 0x000fe2000f8e0207ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x00000004009c8947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000003ff397819ULL, 0x100fe20000011600ULL, 0x0000400072377824ULL, 0x000fe200078e0295ULL,
0x0000900000047ab9ULL, 0x000fe40000000a00ULL, 0x00000070044d7812ULL, 0x000fe200078ec0ffULL,
0x00000004393b7836ULL, 0x000fe20000000000ULL, 0x0000000796047248ULL, 0x000fe20007fe0000ULL,
0x000000ffff077224ULL, 0x000fe200078e0a07ULL, 0x0000004f39057210ULL, 0x000fe20007ffe0ffULL,
0x000000806e4c7824ULL, 0x000fe200078e024dULL, 0x0000004f3b357210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4d7224ULL, 0x000fe200078e00ffULL, 0x0000002004367446ULL, 0x000fe20003800007ULL,
0x0000000139077824ULL, 0x000fe200078e0200ULL, 0x0000001839597810ULL, 0x000fe20007ffe0ffULL,
0x0000010005047825ULL, 0x000fe200078e004cULL, 0x000000363900720cULL, 0x000fc60003f26070ULL,
0x000020006e4e7824ULL, 0x000fe200078e0237ULL, 0x0000000404067c10ULL, 0x000fe2000ff1e0ffULL,
0x000000083b387824ULL, 0x000fe200078e00ffULL, 0x0000000707377812ULL, 0x000fe200078ec0ffULL,
0x000170004e4e7836ULL, 0x000fe20000000000ULL, 0x0000000505077c10ULL, 0x000fe200087fe4ffULL,
0x0000010035047825ULL, 0x000fe200078e004cULL, 0x000000363b00720cULL, 0x040fe40003f06070ULL,
0x0ffffff837377812ULL, 0x000fe200078ef800ULL, 0x000000013b357824ULL, 0x100fe200078e0200ULL,
0x0000000404347c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000c39537836ULL, 0x000fe20000000000ULL,
0x0000004e37377211ULL, 0x000fe200078e20ffULL, 0x0000001039557836ULL, 0x000fe20000000000ULL,
0xfffffff8383b7812ULL, 0x000fe200078ee235ULL, 0x0000001439577836ULL, 0x000fe20000000000ULL,
0x0000000505357c10ULL, 0x000fe200097fe4ffULL, 0x0000000839057836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006377faeULL, 0x0003e2000c901c46ULL,
0x0000001c395b7836ULL, 0x000fe20000000000ULL, 0x000000365300720cULL, 0x080fe20003fa6070ULL,
0x0000000105047824ULL, 0x040fe200078e0200ULL, 0x000000360500720cULL, 0x0c0fe20003fc6070ULL,
0x0000000805517824ULL, 0x000fe200078e00ffULL, 0x0000004f05057210ULL, 0x000fe20007ffe0ffULL,
0x000000103b397824ULL, 0x000fe200078e024eULL, 0x000000365500720cULL, 0x080fe20003f86070ULL,
0x00000008533a7824ULL, 0x000fe200078e00ffULL, 0xfffffff851517812ULL, 0x000fe200078ee204ULL,
0x0000010005047825ULL, 0x000fe200078e004cULL, 0x000000365700720cULL, 0x080fe20003f66070ULL,
0x0000000034397faeULL, 0x0005e2000c101c46ULL, 0x000000365900720cULL, 0x080fe20003f46070ULL,
0x0000000153077824ULL, 0x002fe200078e024fULL, 0x000000365b00720cULL, 0x000fe20003f26070ULL,
0x0000000153377824ULL, 0x000fe200078e0200ULL, 0x0000000404367c10ULL, 0x000fe2000ff1e0ffULL,
0x0000010007067825ULL, 0x000fe200078e004cULL, 0x0000000055387210ULL, 0x000fc40007ffe0ffULL,
0xfffffff83a537812ULL, 0x000fe200078ee237ULL, 0x00000001553b7824ULL, 0x040fe200078e024fULL,
0x0000000505377c10ULL, 0x000fe200087fe4ffULL, 0x0000000855557824ULL, 0x000fe200078e00ffULL,
0x0000000406347c10ULL, 0x004fe2000ff1e0ffULL, 0x000001003b047825ULL, 0x000fc600078e004cULL,
0xfffffff855557812ULL, 0x000fe200078ee238ULL, 0x0000000157067824ULL, 0x140fe200078e0200ULL,
0x0000000507357c10ULL, 0x000fe200087fe4ffULL, 0x00000008573b7824ULL, 0x040fe200078e00ffULL,
0x0000000404387c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000157397824ULL, 0x000fe400078e024fULL,
0x0000000159507824ULL, 0x000fe200078e0200ULL, 0xfffffff83b577812ULL, 0x000fe200078ee206ULL,
0x0000010039067825ULL, 0x000fe200078e004cULL, 0x0000004f593b7210ULL, 0x000fc40007ffe0ffULL,
0x0000000505397c10ULL, 0x000fe200087fe4ffULL, 0x000000015b4f7824ULL, 0x040fe200078e024fULL,
0x00000004063a7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000015b067824ULL, 0x040fe200078e0200ULL,
0x000000035b5b7819ULL, 0x000fe200000006ffULL, 0x000001003b047825ULL, 0x100fe200078e004cULL,
0x00000005073b7c10ULL, 0x000fe400087fe4ffULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee206ULL,
0x0000000859597824ULL, 0x000fe200078e00ffULL, 0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL,
0x000001004f067825ULL, 0x000fc600078e004cULL, 0xfffffff859597812ULL, 0x000fe200078ee250ULL,
0x00000010514d7824ULL, 0x100fe200078e024eULL, 0x0000000505057c10ULL, 0x000fe200087fe4ffULL,
0x00000010534f7824ULL, 0x100fe200078e024eULL, 0x0000000406067c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001055517824ULL, 0x100fe200078e024eULL, 0x0000004e59557211ULL, 0x000fe200078e20ffULL,
0x0000001057537824ULL, 0x100fe200078e024eULL, 0x0000000507077c10ULL, 0x000fe200087fe4ffULL,
0x000000105b577824ULL, 0x000fe200078e024eULL, 0x00000000364d7faeULL, 0x0003e8000f101c46ULL,
0x00000000344f7faeULL, 0x0003e8000e901c46ULL, 0x0000000038517faeULL, 0x0003e8000e101c46ULL,
0x000000003a537faeULL, 0x0003e8000d901c46ULL, 0x0000000004557faeULL, 0x0003e8000d101c46ULL,
0x0000000006577faeULL, 0x0003e2000c901c46ULL, 0x0000000400687947ULL, 0x000fea0003800000ULL,
0x0000000c00377811ULL, 0x040fe200078fe8ffULL, 0x0000900000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000400347811ULL, 0x040fe400078fe8ffULL, 0x0000000800357811ULL, 0x040fe200078fe8ffULL,
0x0000000137067824ULL, 0x140fe200078e0200ULL, 0x00000018004d7811ULL, 0x040fe200078fe8ffULL,
0x00000008373b7824ULL, 0x000fe200078e00ffULL, 0x0000001000397811ULL, 0x000fe200078fe8ffULL,
0x0000000134047824ULL, 0x140fe200078e0200ULL, 0x0000000335387819ULL, 0x040fe200000006ffULL,
0x0000000834077824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3a7812ULL, 0x000fe200078ee206ULL,
0x0000000135057824ULL, 0x100fe200078e0200ULL, 0x00000014003b7811ULL, 0x040fe200078fe8ffULL,
0x000000014d067824ULL, 0x140fe200078e0200ULL, 0xfffffff807367812ULL, 0x000fe200078ee204ULL,
0x000000084d517824ULL, 0x000fe200078e00ffULL, 0x0000001c00657811ULL, 0x000fe200078fe8ffULL,
0x0000000139047824ULL, 0x140fe200078e0200ULL, 0xfffffff838387812ULL, 0x000fe200078ee205ULL,
0x0000000839077824ULL, 0x000fe200078e00ffULL, 0x000000003b057210ULL, 0x000fe20007ffe0ffULL,
0x000000083b507824ULL, 0x000fe200078e00ffULL, 0xfffffff851527812ULL, 0x000fe200078ee206ULL,
0x0000000165067824ULL, 0x040fe200078e0200ULL, 0xfffffff8074c7812ULL, 0x000fe200078ee204ULL,
0x0000400072077824ULL, 0x000fe200078e0295ULL, 0x0000000365517819ULL, 0x000fe200000006ffULL,
0x0000001000047824ULL, 0x040fe200078e00ffULL, 0xfffffff850507812ULL, 0x000fe200078ee205ULL,
0x0000000137377824ULL, 0x100fe200078e024fULL, 0x0000000000057211ULL, 0x000fe200078fe8ffULL,
0x0000000139397824ULL, 0x000fe200078e024fULL, 0xfffffff851547812ULL, 0x000fe200078ee206ULL,
0x000020006e067824ULL, 0x000fe200078e0207ULL, 0x0000000705057812ULL, 0x000fe200078ec0ffULL,
0x0000000134077824ULL, 0x100fe200078e024fULL, 0x0000007004517812ULL, 0x000fe200078ec0ffULL,
0x000000013b3b7824ULL, 0x100fe200078e024fULL, 0x0ffffff805047812ULL, 0x000fe200078ef800ULL,
0x000000014d4d7824ULL, 0x100fe200078e024fULL, 0x0001700006677810ULL, 0x000fe20007ffe0ffULL,
0x0000000165657824ULL, 0x000fe200078e024fULL, 0x0000004f35357210ULL, 0x000fe20007ffe0ffULL,
0x000000806e4e7824ULL, 0x000fe200078e0251ULL, 0x0000004f00057211ULL, 0x000fe200078fe8ffULL,
0x000000ffff4f7224ULL, 0x000fe200078e00ffULL, 0x0000006738557211ULL, 0x000fe200078e20ffULL,
0x0000001004517824ULL, 0x000fc400078e0267ULL, 0x0000010005047825ULL, 0x000fc800078e004eULL,
0x0000010007067825ULL, 0x000fe200078e004eULL, 0x0000000404047c10ULL, 0x000fc6000ff1e0ffULL,
0x0000001036537824ULL, 0x000fe200078e0267ULL, 0x0000000406067c10ULL, 0x000fe2000ff3e0ffULL,
0x0000010035347825ULL, 0x100fe200078e004eULL, 0x0000000505057c10ULL, 0x000fe400087fe4ffULL,
0x0000000507077c10ULL, 0x000fe20008ffe4ffULL, 0x0000010037367825ULL, 0x000fe200078e004eULL,
0x0000000434347c10ULL, 0x000fe2000ff5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004517faeULL, 0x0003e4000b901c46ULL, 0x000000103a577824ULL, 0x000fe200078e0267ULL,
0x0000000436367c10ULL, 0x000fe2000ff7e0ffULL, 0x0000010039387825ULL, 0x000fe200078e004eULL,
0x0000000535357c10ULL, 0x000fe200097fe4ffULL, 0x0000000006537faeULL, 0x0003e2000b901c46ULL,
0x0000000537377c10ULL, 0x000fe20009ffe4ffULL, 0x000000104c597824ULL, 0x000fe200078e0267ULL,
0x0000000438387c10ULL, 0x000fe2000ff1e0ffULL, 0x000001003b3a7825ULL, 0x100fe200078e004eULL,
0x0000000034557faeULL, 0x0003e4000b901c46ULL, 0x0000000539397c10ULL, 0x000fe200087fe4ffULL,
0x000001004d4c7825ULL, 0x100fe200078e004eULL, 0x000000043a3a7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000036577faeULL, 0x0003e4000b901c46ULL, 0x00000100654e7825ULL, 0x000fe200078e004eULL,
0x000000044c4c7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000038597faeULL, 0x0003e2000b901c46ULL,
0x000000053b3b7c10ULL, 0x000fe20008ffe4ffULL, 0x00000010505b7824ULL, 0x100fe200078e0267ULL,
0x000000044e4e7c10ULL, 0x000fe2000ff7e0ffULL, 0x00000010525f7824ULL, 0x000fe200078e0267ULL,
0x000000054d4d7c10ULL, 0x000fc400097fe4ffULL, 0x0000006754677211ULL, 0x000fe200078e20ffULL,
0x000000003a5b7faeULL, 0x0003e2000b901c46ULL, 0x000000054f4f7c10ULL, 0x000fc60009ffe4ffULL,
0x000000004c5f7faeULL, 0x0003e8000b901c46ULL, 0x000000004e677faeULL, 0x0003e4000b901c46ULL,
0xffffffe074047812ULL, 0x042fe200078ec0ffULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x0000001074057812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x0000009505077210ULL, 0x000fca0007ffe004ULL, 0x000000086e347824ULL, 0x000fcc00078e0207ULL,
0x01e60835343479a7ULL, 0x000e64000850003fULL, 0x0000000000047805ULL, 0x000fe40000015200ULL,
0x0000000874067812ULL, 0x000fca00078ec0ffULL, 0x0000000107377824ULL, 0x000fc800078e0206ULL,
0x01e60835370075a7ULL, 0x002ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ff00367202ULL, 0x000fce0000000f00ULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604397210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000003906067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01e60835370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000010006f7824ULL, 0x000fe200078e00ffULL,
0x0000000598047819ULL, 0x000fe200000006ffULL, 0x000000ffff7e7224ULL, 0x000fe200078e005dULL,
0x00000001ff6c7819ULL, 0x000fe40000011600ULL, 0x000000706f6f7812ULL, 0x000fe400078ec0ffULL,
0xffffff8004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c6c6c7812ULL, 0x000fe400078ec0ffULL,
0x000000956f057210ULL, 0x000fca0007ffe004ULL, 0x0000000105057824ULL, 0x000fca00078e026cULL,
0x01e0000005047984ULL, 0x000e680000000800ULL, 0x01e2000005777984ULL, 0x0004a20000000800ULL,
0x0000005d0400720bULL, 0x002fda0003f1d000ULL, 0x0000000000067806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x000000ff0600720cULL, 0x000fda0003f25270ULL,
0x0000000400909947ULL, 0x004fea0003800000ULL, 0x00000002ff057819ULL, 0x000fe40000011698ULL,
0x0000005d0400720bULL, 0x0c0fe40003f34000ULL, 0x000000980500720cULL, 0x000fe40003f45270ULL,
0x0000005d047e7209ULL, 0x000fd20007810000ULL, 0x0000000000077806ULL, 0x000fe400008e0100ULL,
0x000000809805a824ULL, 0x000fe400078e0295ULL, 0x000000ff0700720cULL, 0x000fc60003f25270ULL,
0x000000056c05a210ULL, 0x000fca0007ffe06fULL, 0x01e4007e0500a388ULL, 0x0003ea0000000800ULL,
0x0000000400509947ULL, 0x000fea0003800000ULL, 0x0000005d7e057221ULL, 0x002fe20000010100ULL,
0x000000ff07ff7812ULL, 0x040fe4000782c0ffULL, 0x0000ff0007ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b05057820ULL, 0x000fe20000410000ULL, 0x00ff000007ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000007ff7812ULL, 0x000fe2000788c0ffULL, 0x0000000500347308ULL, 0x0002ac0000000800ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x00000002ff057819ULL, 0x002fcc0000011600ULL,
0x00001f0534057589ULL, 0x004e6400000e0000ULL, 0x0000000508087220ULL, 0x082fe20000410000ULL,
0x0000000509097220ULL, 0x080fe20000410000ULL, 0x0000000580807220ULL, 0x080fe20000410000ULL,
0x0000000581817220ULL, 0x080fe20000410000ULL, 0x000000050c0c7220ULL, 0x080fe20000410000ULL,
0x000000050d0d7220ULL, 0x080fe20000410000ULL, 0x0000000510107220ULL, 0x080fe20000410000ULL,
0x0000000511117220ULL, 0x080fe20000410000ULL, 0x0000000514147220ULL, 0x080fe20000410000ULL,
0x0000000515157220ULL, 0x080fe20000410000ULL, 0x0000000518187220ULL, 0x080fe20000410000ULL,
0x0000000519197220ULL, 0x080fe20000410000ULL, 0x000000051c1c7220ULL, 0x080fe20000410000ULL,
0x000000051d1d7220ULL, 0x080fe20000410000ULL, 0x0000000520207220ULL, 0x080fe20000410000ULL,
0x0000000521217220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000000800057811ULL, 0x002fcc00078ff0ffULL, 0x00001f0534057589ULL, 0x004e6400000e0000ULL,
0x000000050a0a7220ULL, 0x082fe20000410000ULL, 0x000000050b0b7220ULL, 0x080fe20000410000ULL,
0x0000000582827220ULL, 0x080fe20000410000ULL, 0x0000000583837220ULL, 0x080fe20000410000ULL,
0x000000050e0e7220ULL, 0x080fe20000410000ULL, 0x000000050f0f7220ULL, 0x080fe20000410000ULL,
0x0000000512127220ULL, 0x080fe20000410000ULL, 0x0000000513137220ULL, 0x080fe20000410000ULL,
0x0000000516167220ULL, 0x080fe20000410000ULL, 0x0000000517177220ULL, 0x080fe20000410000ULL,
0x000000051a1a7220ULL, 0x080fe20000410000ULL, 0x000000051b1b7220ULL, 0x080fe20000410000ULL,
0x000000051e1e7220ULL, 0x080fe20000410000ULL, 0x000000051f1f7220ULL, 0x080fe20000410000ULL,
0x0000000522227220ULL, 0x080fe20000410000ULL, 0x0000000523237220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x0000001000057811ULL, 0x002fcc00078ff0ffULL,
0x00001f0534057589ULL, 0x004e6400000e0000ULL, 0x0000000524247220ULL, 0x082fe20000410000ULL,
0x0000000525257220ULL, 0x080fe20000410000ULL, 0x0000000528287220ULL, 0x080fe20000410000ULL,
0x0000000529297220ULL, 0x080fe20000410000ULL, 0x000000052c2c7220ULL, 0x080fe20000410000ULL,
0x000000052d2d7220ULL, 0x080fe20000410000ULL, 0x0000000540407220ULL, 0x080fe20000410000ULL,
0x0000000541417220ULL, 0x080fe20000410000ULL, 0x0000000548487220ULL, 0x080fe20000410000ULL,
0x0000000549497220ULL, 0x080fe20000410000ULL, 0x0000000544447220ULL, 0x080fe20000410000ULL,
0x0000000545457220ULL, 0x080fe20000410000ULL, 0x000000053c3c7220ULL, 0x080fe20000410000ULL,
0x000000053d3d7220ULL, 0x080fe20000410000ULL, 0x0000000530307220ULL, 0x080fe20000410000ULL,
0x0000000531317220ULL, 0x000fce0000410000ULL, 0x000000347c7c7220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x0000001800057811ULL, 0x002fcc00078ff0ffULL,
0x00001f0534057589ULL, 0x000e6400000e0000ULL, 0x0000000526267220ULL, 0x082fe20000410000ULL,
0x0000000527277220ULL, 0x080fe20000410000ULL, 0x000000052a2a7220ULL, 0x080fe20000410000ULL,
0x000000052b2b7220ULL, 0x080fe20000410000ULL, 0x000000052e2e7220ULL, 0x080fe20000410000ULL,
0x000000052f2f7220ULL, 0x080fe20000410000ULL, 0x0000000542427220ULL, 0x080fe20000410000ULL,
0x0000000543437220ULL, 0x080fe20000410000ULL, 0x000000054a4a7220ULL, 0x080fe20000410000ULL,
0x000000054b4b7220ULL, 0x080fe20000410000ULL, 0x0000000546467220ULL, 0x080fe20000410000ULL,
0x0000000547477220ULL, 0x080fe20000410000ULL, 0x000000053e3e7220ULL, 0x080fe20000410000ULL,
0x000000053f3f7220ULL, 0x080fe20000410000ULL, 0x0000000532327220ULL, 0x080fe20000410000ULL,
0x0000000533337220ULL, 0x000fce0000410000ULL, 0x0000000706ff7212ULL, 0x000fda00078230ffULL,
0x8000007e04041221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b04041820ULL, 0x000fc80000410000ULL, 0x00000004006a1308ULL, 0x000ea40000000800ULL,
0x0000006a77771220ULL, 0x004fce0000410000ULL, 0x0000000472047824ULL, 0x000fe200078e00ffULL,
0x00000008006d7812ULL, 0x000fe200078ec0ffULL, 0x0000400072077824ULL, 0x000fe200078e0295ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000004045d7812ULL, 0x000fe200078ec0ffULL,
0x000020006e077824ULL, 0x000fe200078e0207ULL, 0x000000076d6d7812ULL, 0x000fe400078ef800ULL,
0x0000005d00047211ULL, 0x040fe200078fe0ffULL, 0x0001600007767836ULL, 0x000fe20000000000ULL,
0x000000106d6b7812ULL, 0x040fe200078efcffULL, 0x000000086d347824ULL, 0x040fe200078e00ffULL,
0x0000006d00057211ULL, 0x002fe200078fe0ffULL, 0x000000016d757824ULL, 0x040fe200078e0204ULL,
0x000000036d067819ULL, 0x000fe200000006ffULL, 0x0000000104737824ULL, 0x000fe200078e026bULL,
0x0000000205697810ULL, 0x000fe20007ffe0ffULL, 0x000000086b047824ULL, 0x000fe200078e00ffULL,
0x0000000405667810ULL, 0x000fe20007ffe0ffULL, 0x000000086d687824ULL, 0x040fe200078e00ffULL,
0xfffffff806757812ULL, 0x000fe200078ee275ULL, 0x000000086d357824ULL, 0x000fe200078e00ffULL,
0xfffffff804737812ULL, 0x000fe200078ee273ULL, 0x0000040098047824ULL, 0x000fe200078e00ffULL,
0xfffffff834697812ULL, 0x000fe200078ee269ULL, 0x0000000605657836ULL, 0x000fe20000000000ULL,
0xfffffff868687812ULL, 0x000fc400078ee205ULL, 0xfffff00004047812ULL, 0x000fe400078ec0ffULL,
0xfffffff835667812ULL, 0x000fe400078ee266ULL, 0xfffffff806657812ULL, 0x000fe200078ee265ULL,
0x0000000195677824ULL, 0x000fca00078e0204ULL, 0x0001200067787810ULL, 0x000fe20007ffe0ffULL,
0x0000000000288947ULL, 0x000fec0003800000ULL, 0x00000002ff617819ULL, 0x000fe40000011600ULL,
0x0000006aff04723eULL, 0x000fc600000000ffULL, 0x0000001061637836ULL, 0x000fe20000000000ULL,
0x0000541004047816ULL, 0x000fe20000000004ULL, 0x0000000861057836ULL, 0x000fe40000000000ULL,
0x0000001861077836ULL, 0x000fe40000000000ULL, 0x00001f6304637589ULL, 0x0002a800000e0000ULL,
0x00001f0504647589ULL, 0x0002e800000e0000ULL, 0x00001f6104617589ULL, 0x00026800000e0000ULL,
0x00001f0704627589ULL, 0x00026400000e0000ULL, 0x0000001075587824ULL, 0x000fe200078e0278ULL,
0x0000007873347211ULL, 0x000fe200078e20ffULL, 0x0000001068547824ULL, 0x100fe400078e0276ULL,
0x0000001069507824ULL, 0x100fe400078e0276ULL, 0x000000005858783bULL, 0x000ee20000000200ULL,
0x00000010664c7824ULL, 0x000fc600078e0276ULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x0000000000208947ULL, 0x000fea0003800000ULL, 0x0000006158587232ULL, 0x08afe40000000000ULL,
0x000000615a5a7232ULL, 0x000fe40000000000ULL, 0x0000006459597232ULL, 0x080fe40000000000ULL,
0x000000645b5b7232ULL, 0x000fe40000000000ULL, 0x0000006334347232ULL, 0x084fe40000000000ULL,
0x0000006336367232ULL, 0x000fc40000000000ULL, 0x0000006235357232ULL, 0x080fe40000000000ULL,
0x0000006237377232ULL, 0x000fce0000000000ULL, 0x000000005050783bULL, 0x000f220000004200ULL,
0x0000001065387824ULL, 0x000fe200078e0276ULL, 0x000000025d5d7812ULL, 0x000fe400078efcffULL,
0x000000004c4c783bULL, 0x000f680000004200ULL, 0x000000005454783bULL, 0x000f680000004200ULL,
0x000000003838783bULL, 0x000f620000004200ULL, 0x00000050580c723cULL, 0x018fec000000180cULL,
0x00000050342c723cULL, 0x004fec000000182cULL, 0x0000004c5814723cULL, 0x020fe20000001814ULL,
0x0000005d00507211ULL, 0x000fe200078fe0ffULL, 0x000000086b517824ULL, 0x000fc800078e00ffULL,
0x0000004c3448723cULL, 0x000fec0000001848ULL, 0x0000004e5818723cULL, 0x000fe20000001818ULL,
0x000000016d4c7824ULL, 0x140fe200078e0250ULL, 0x000000036d4d7819ULL, 0x000fe200000006ffULL,
0x000000016b507824ULL, 0x000fc600078e0250ULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee24cULL,
0x0000004e3444723cULL, 0x000fe20000001844ULL, 0x0000006b004c7211ULL, 0x000fe400078fe0ffULL,
0xfffffff851517812ULL, 0x000fe200078ee250ULL, 0x000000104d4d7824ULL, 0x000fe200078e0278ULL,
0x000000064c5d7810ULL, 0x000fe20007ffe0ffULL, 0x000000525810723cULL, 0x000fe20000001810ULL,
0x000000086b4f7824ULL, 0x040fe200078e00ffULL, 0x000000036b4e7819ULL, 0x000fe200000006ffULL,
0x000000024c5f7836ULL, 0x000fc40000000000ULL, 0x000000044c5e7836ULL, 0x000fe20000000000ULL,
0x000000523440723cULL, 0x000fe20000001840ULL, 0x0000001051517824ULL, 0x000fe200078e0278ULL,
0xfffffff84f607812ULL, 0x000fe200078ee24cULL, 0x000000086b507824ULL, 0x040fe200078e00ffULL,
0xfffffff84e5f7812ULL, 0x000fe400078ee25fULL, 0x000000545804723cULL, 0x002fe20000001808ULL,
0x000000086b537824ULL, 0x000fe200078e00ffULL, 0xfffffff8505d7812ULL, 0x000fe200078ee25dULL,
0x000000105f507824ULL, 0x000fc600078e0276ULL, 0x000000565808723cULL, 0x000fe20000001880ULL,
0xfffffff8535e7812ULL, 0x000fc800078ee25eULL, 0x000000765e4c7211ULL, 0x000fe200078e20ffULL,
0x00000038581c723cULL, 0x000fec000000181cULL, 0x0000003a5820723cULL, 0x000fe20000001820ULL,
0x000000004d58783bULL, 0x0002aa0000000200ULL, 0x000000543424723cULL, 0x000fec0000001824ULL,
0x000000563428723cULL, 0x000fe20000001828ULL, 0x0000001060547824ULL, 0x000fca00078e0276ULL,
0x00000038343c723cULL, 0x000fec000000183cULL, 0x0000003a3430723cULL, 0x000fe20000001830ULL,
0x000000005134783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000208947ULL, 0x000fde0003800000ULL, 0x0000006158587232ULL, 0x084fe40000000000ULL,
0x000000615a5a7232ULL, 0x000fe40000000000ULL, 0x0000006459597232ULL, 0x080fe40000000000ULL,
0x000000645b5b7232ULL, 0x000fe40000000000ULL, 0x0000006334347232ULL, 0x088fe40000000000ULL,
0x0000006336367232ULL, 0x000fc40000000000ULL, 0x0000006235357232ULL, 0x080fe40000000000ULL,
0x0000006237377232ULL, 0x000fce0000000000ULL, 0x000000105d387824ULL, 0x000fe200078e0276ULL,
0x000000005454783bULL, 0x000f220000004200ULL, 0x0000940000047ab9ULL, 0x000fe20000000800ULL,
0x0000007c777c7221ULL, 0x000fe40000010000ULL, 0x000000005050783bULL, 0x002e680000004200ULL,
0x000000004c4c783bULL, 0x000f680000004200ULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x000000543424723cULL, 0x018fec0000001824ULL, 0x000000563428723cULL, 0x000fec0000001828ULL,
0x00000050342c723cULL, 0x002fec000000182cULL, 0x000000523440723cULL, 0x000fec0000001840ULL,
0x0000004c3448723cULL, 0x020fec0000001848ULL, 0x0000004e3444723cULL, 0x000fec0000001844ULL,
0x00000038343c723cULL, 0x004fec000000183cULL, 0x0000003a3430723cULL, 0x000fec0000001830ULL,
0x0000004c5814723cULL, 0x000fe20000001814ULL, 0x000000019a357810ULL, 0x000fe20007ffe0ffULL,
0x000000807b377836ULL, 0x000fc60000000000ULL, 0x000000943500720cULL, 0x000fe20003f06070ULL,
0x00000038581c723cULL, 0x000fe2000000181cULL, 0x00000002984c7824ULL, 0x000fca00078e00ffULL,
0xfffffff84c4c7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x000000545804723cULL, 0x000fe60000001804ULL, 0x0000000195397824ULL, 0x000fc600078e024cULL,
0x000000565808723cULL, 0x000fe20000001808ULL, 0x01e6883839ff79a7ULL, 0x0003e2000850003fULL,
0x0000000470557c24ULL, 0x000fc8000f8e0237ULL, 0x00000050580c723cULL, 0x000fec000000180cULL,
0x000000525810723cULL, 0x000fec0000001810ULL, 0x0000004e5818723cULL, 0x000fec0000001818ULL,
0x0000003a5820723cULL, 0x000fe20000001820ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000400888947ULL, 0x002fde0003800000ULL,
0x00000003ff547819ULL, 0x100fe20000011600ULL, 0x000000ffff367224ULL, 0x000fe200078e0a37ULL,
0x0000003796357248ULL, 0x000fe20007fe0000ULL, 0x000000806e347824ULL, 0x000fe200078e026fULL,
0x0000000854567810ULL, 0x000fe20007ffe0ffULL, 0x00000004543a7836ULL, 0x000fe20000000000ULL,
0x0000002035397446ULL, 0x000fe20003800036ULL, 0x0000000154367824ULL, 0x100fe200078e0200ULL,
0x0000900000047ab9ULL, 0x000fe20000000a00ULL, 0x000000013a377824ULL, 0x040fe200078e0200ULL,
0x000000033a4c7819ULL, 0x000fe200000006ffULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x0000000736537812ULL, 0x000fe200078ec0ffULL, 0x00000001564d7824ULL, 0x100fe200078e0255ULL,
0xfffffff84c597812ULL, 0x000fe200078ee237ULL, 0x0000000154377824ULL, 0x100fe200078e0255ULL,
0x000000393a00720cULL, 0x0c0fe20003f26070ULL, 0x000000013a3b7824ULL, 0x000fe200078e0255ULL,
0x000000395400720cULL, 0x080fe20003f06070ULL, 0x0000010037367825ULL, 0x000fe200078e0034ULL,
0x000000395600720cULL, 0x000fc60003fa6070ULL, 0x0000000c54587836ULL, 0x000fe20000000000ULL,
0x0000000436507c10ULL, 0x000fe2000ff5e0ffULL, 0x000001004d4c7825ULL, 0x000fc600078e0034ULL,
0x0000000537517c10ULL, 0x000fe200097fe4ffULL, 0x000001003b3a7825ULL, 0x000fe200078e0034ULL,
0x0ffffff853377812ULL, 0x000fe400078ef800ULL, 0x000000044c367c10ULL, 0x000fe2000ff5e0ffULL,
0x00000001584f7824ULL, 0x000fe200078e0255ULL, 0x000000043a527c10ULL, 0x000fe2000ff7e0ffULL,
0x00000010545a7836ULL, 0x000fe20000000000ULL, 0x0000007637577211ULL, 0x000fe200078e20ffULL,
0x000001004f4e7825ULL, 0x000fe200078e0034ULL, 0x000000054d377c10ULL, 0x000fc400097fe4ffULL,
0x000000053b537c10ULL, 0x000fe20009ffe4ffULL, 0x000000015a4d7824ULL, 0x040fe200078e0255ULL,
0x000000044e3a7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001454787836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000050577faeULL, 0x0003e2000c101c46ULL,
0x000001004d4c7825ULL, 0x000fe200078e0034ULL, 0x000000054f3b7c10ULL, 0x000fe40009ffe4ffULL,
0x000000395a00720cULL, 0x080fe20003f66070ULL, 0x00000001564f7824ULL, 0x040fe200078e0200ULL,
0x000000044c4e7c10ULL, 0x000fe2000ffde0ffULL, 0x0000000856567824ULL, 0x000fe200078e00ffULL,
0x000000395800720cULL, 0x080fe20003f86070ULL, 0x0000001059597824ULL, 0x000fe200078e0276ULL,
0x000000397800720cULL, 0x040fe20003f46070ULL, 0x00000018547a7836ULL, 0x000fe20000000000ULL,
0xfffffff856577812ULL, 0x002fe200078ee24fULL, 0x0000000178517824ULL, 0x000fe200078e0255ULL,
0x0000000052597faeULL, 0x0003e2000c901c46ULL, 0x0000000158507824ULL, 0x000fe200078e0200ULL,
0x000000054d4f7c10ULL, 0x000fe2000b7fe4ffULL, 0x00000100514c7825ULL, 0x000fe200078e0034ULL,
0x0000001c54547810ULL, 0x000fc40007ffe0ffULL, 0x000000397a00720cULL, 0x080fe20003f26070ULL,
0x000000015a517824ULL, 0x100fe200078e0200ULL, 0x000000395400720cULL, 0x000fe20003f06070ULL,
0x000000085a5a7824ULL, 0x000fe200078e00ffULL, 0x0000000378777819ULL, 0x000fe200000006ffULL,
0x000000017a397824ULL, 0x100fe200078e0255ULL, 0x0000000358597819ULL, 0x002fe200000006ffULL,
0x0000000178527824ULL, 0x000fe200078e0200ULL, 0xfffffff85a5b7812ULL, 0x000fe200078ee251ULL,
0x0000000154537824ULL, 0x040fe200078e0255ULL, 0xfffffff859597812ULL, 0x000fe200078ee250ULL,
0x0000000854557824ULL, 0x000fe200078e00ffULL, 0x000000044c507c10ULL, 0x000fe2000ffde0ffULL,
0x0000001057577824ULL, 0x100fe200078e0276ULL, 0xfffffff877777812ULL, 0x000fe200078ee252ULL,
0x0000001059597824ULL, 0x000fe200078e0276ULL, 0x000000054d517c10ULL, 0x000fe2000b7fe4ffULL,
0x00000100394c7825ULL, 0x000fe200078e0034ULL, 0x0000000054527210ULL, 0x000fe20007ffe0ffULL,
0x0000000036577faeULL, 0x0003e2000e901c46ULL, 0x0000007677777211ULL, 0x000fe200078e20ffULL,
0x000000017a397824ULL, 0x040fe200078e0200ULL, 0x000000044c4c7c10ULL, 0x000fe2000ffde0ffULL,
0x000000087a7a7824ULL, 0x000fe200078e00ffULL, 0x000000003a597faeULL, 0x0003e2000e101c46ULL,
0x0000010053347825ULL, 0x000fe200078e0034ULL, 0xfffffff855537812ULL, 0x000fc400078ee252ULL,
0xfffffff87a397812ULL, 0x000fe200078ee239ULL, 0x000000105b5b7824ULL, 0x100fe200078e0276ULL,
0x000000054d4d7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001053537824ULL, 0x100fe200078e0276ULL,
0x0000000434347c10ULL, 0x000fe2000ffde0ffULL, 0x0000001039397824ULL, 0x000fe200078e0276ULL,
0x000000004e5b7faeULL, 0x0003e4000d901c46ULL, 0x0000000535357c10ULL, 0x000fe4000b7fe4ffULL,
0x0000000050777faeULL, 0x0003e8000d101c46ULL, 0x000000004c397faeULL, 0x0003e8000c901c46ULL,
0x0000000034537faeULL, 0x0003e2000c101c46ULL, 0x0000000400547947ULL, 0x000fea0003800000ULL,
0x00000008003b7811ULL, 0x040fe200078fe8ffULL, 0x0000900000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000400377811ULL, 0x040fe400078fe8ffULL, 0x000000003b357210ULL, 0x000fe20007ffe0ffULL,
0x000000083b367824ULL, 0x000fe200078e00ffULL, 0x0000001400517811ULL, 0x040fe200078fe8ffULL,
0x0000000137347824ULL, 0x140fe200078e0200ULL, 0x00000010004f7811ULL, 0x040fe200078fe8ffULL,
0x0000000837597824ULL, 0x000fe200078e00ffULL, 0xfffffff8365b7812ULL, 0x000fe200078ee235ULL,
0x0000000151367824ULL, 0x140fe200078e0200ULL, 0x0000001800537811ULL, 0x040fe200078fe8ffULL,
0x00000008517d7824ULL, 0x000fe200078e00ffULL, 0x0000000c004d7811ULL, 0x040fe200078fe8ffULL,
0x000000014f357824ULL, 0x100fe200078e0200ULL, 0xfffffff859597812ULL, 0x000fe200078ee234ULL,
0x0000000153397824ULL, 0x140fe200078e0200ULL, 0xfffffff87d7d7812ULL, 0x000fe200078ee236ULL,
0x00000008534c7824ULL, 0x000fe200078e00ffULL, 0x000000034f3a7819ULL, 0x000fe200000006ffULL,
0x000000014d347824ULL, 0x140fe200078e0200ULL, 0x0000001c00367811ULL, 0x040fe200078fe8ffULL,
0x000000084d777824ULL, 0x000fe200078e00ffULL, 0xfffffff83a797812ULL, 0x000fe200078ee235ULL,
0x0000000137377824ULL, 0x100fe200078e0255ULL, 0xfffffff84c7f7812ULL, 0x000fe200078ee239ULL,
0x000000013b3b7824ULL, 0x100fe200078e0255ULL, 0xfffffff877777812ULL, 0x000fe200078ee234ULL,
0x000000014d4d7824ULL, 0x100fe200078e0255ULL, 0x0000005500357211ULL, 0x040fe200078fe8ffULL,
0x000000014f4f7824ULL, 0x100fe200078e0255ULL, 0x0000005551517210ULL, 0x000fe20007ffe0ffULL,
0x0000000153537824ULL, 0x100fe200078e0255ULL, 0x0000000000347211ULL, 0x000fe200078fe8ffULL,
0x0000000136397824ULL, 0x000fe200078e0255ULL, 0x0000006f6e547211ULL, 0x000fe200078e38ffULL,
0x0000000136567824ULL, 0x040fe200078e0200ULL, 0x000000ff00557202ULL, 0x000fe20000000f00ULL,
0x0000000836817824ULL, 0x000fe200078e00ffULL, 0x0000000734577812ULL, 0x000fe200078ec0ffULL,
0x0000001059597824ULL, 0x000fe200078e0276ULL, 0x0000007679797211ULL, 0x000fe200078e20ffULL,
0x0000010035347825ULL, 0x000fe200078e0054ULL, 0x0ffffff857577812ULL, 0x000fc600078ef800ULL,
0x0000010037367825ULL, 0x000fe200078e0054ULL, 0x0000000434347c10ULL, 0x000fc6000ff1e0ffULL,
0x000001003b3a7825ULL, 0x100fe200078e0054ULL, 0x0000000436367c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000535357c10ULL, 0x000fe200087fe4ffULL, 0x000001004d4c7825ULL, 0x100fe200078e0054ULL,
0x000000043a3a7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000537377c10ULL, 0x000fe20008ffe4ffULL,
0x000001004f4e7825ULL, 0x100fe200078e0054ULL, 0x000000044c4c7c10ULL, 0x000fe4000ff7e0ffULL,
0x000000053b3b7c10ULL, 0x000fe200097fe4ffULL, 0x0000010051507825ULL, 0x000fe200078e0054ULL,
0x000000044e4e7c10ULL, 0x000fc4000ff1e0ffULL, 0x000000054d4d7c10ULL, 0x000fe20009ffe4ffULL,
0x0000010053527825ULL, 0x100fe200078e0054ULL, 0x0000000450507c10ULL, 0x000fe4000ff3e0ffULL,
0x000000054f4f7c10ULL, 0x000fe200087fe4ffULL, 0x0000010039547825ULL, 0x000fe200078e0054ULL,
0xfffffff881397812ULL, 0x000fe400078ee256ULL, 0x0000000452527c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001057577824ULL, 0x100fe200078e0276ULL, 0x0000000454547c10ULL, 0x000fe2000ff7e0ffULL,
0x000000105b5b7824ULL, 0x100fe200078e0276ULL, 0x0000000551517c10ULL, 0x000fe20008ffe4ffULL,
0x0000001077777824ULL, 0x100fe200078e0276ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034577faeULL, 0x0003e2000b901c46ULL, 0x000000107d7d7824ULL, 0x100fe200078e0276ULL,
0x0000000553537c10ULL, 0x000fe200097fe4ffULL, 0x000000107f7f7824ULL, 0x100fe200078e0276ULL,
0x0000000036597faeULL, 0x0003e2000b901c46ULL, 0x0000001039397824ULL, 0x000fe200078e0276ULL,
0x0000000555557c10ULL, 0x000fc40009ffe4ffULL, 0x000000003a5b7faeULL, 0x0003e8000b901c46ULL,
0x000000004c777faeULL, 0x0003e8000b901c46ULL, 0x000000004e797faeULL, 0x0003e8000b901c46ULL,
0x00000000507d7faeULL, 0x0003e8000b901c46ULL, 0x00000000527f7faeULL, 0x0003e8000b901c46ULL,
0x0000000054397faeULL, 0x0003e4000b901c46ULL, 0xffffffe074347812ULL, 0x042fe200078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001074357812ULL, 0x040fe400078ec0ffULL,
0x0000000874367812ULL, 0x000fe400078ec0ffULL, 0x0000009535377210ULL, 0x000fca0007ffe034ULL,
0x0000000137397824ULL, 0x000fcc00078e0236ULL, 0x01e62838393879a7ULL, 0x000e64000850003fULL,
0x0000000000347805ULL, 0x000fe40000015200ULL, 0x000000376e4d7211ULL, 0x000fc800078e18ffULL,
0x01e628394d0075a7ULL, 0x002ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x00000036343b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003b36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x01e628394d0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000598347819ULL, 0x000fc800000006ffULL,
0xffffff8034347812ULL, 0x000fc800078ec0ffULL, 0x0000008095347810ULL, 0x000fc80007ffe034ULL,
0x000000346c347210ULL, 0x000fca0007ffe06fULL, 0x01e0000034357984ULL, 0x000e680000000800ULL,
0x01e20000347d7984ULL, 0x0004a20000000800ULL, 0x0000007e3500720bULL, 0x002fda0003f1d000ULL,
0x0000000000367806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x000000ff3600720cULL, 0x000fda0003f25270ULL, 0x0000000400949947ULL, 0x004fea0003800000ULL,
0x0000000198377811ULL, 0x000fe400078ff0ffULL, 0x0000007e3500720bULL, 0x000fe40003f14000ULL,
0x000000983700720cULL, 0x000fda0003f25270ULL, 0x0000008098379824ULL, 0x000fe200078e0295ULL,
0x0000007e35349209ULL, 0x000fc80007810000ULL, 0x000000376c399210ULL, 0x000fe40007ffe06fULL,
0x0000000000377806ULL, 0x000fc600000e0100ULL, 0x01e4003439009388ULL, 0x0003e20000000800ULL,
0x000000ff3700720cULL, 0x000fda0003f05270ULL, 0x0000000400548947ULL, 0x002fea0003800000ULL,
0x0000007e35397209ULL, 0x000fe40007810000ULL, 0x000000ff37ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0037ff7812ULL, 0x000fe2000782c0ffULL, 0x0000007e39347221ULL, 0x000fe20000010100ULL,
0x00ff000037ff7812ULL, 0x040fe4000784c0ffULL, 0xff00000037ff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL, 0x0000003400397308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff347819ULL, 0x002fcc0000011600ULL,
0x00001f3439347589ULL, 0x004e6400000e0000ULL, 0x0000000434047220ULL, 0x042fe20000410000ULL,
0x0000000534057220ULL, 0x040fe20000410000ULL, 0x0000000834087220ULL, 0x040fe20000410000ULL,
0x0000000934097220ULL, 0x040fe20000410000ULL, 0x0000000c340c7220ULL, 0x040fe20000410000ULL,
0x0000000d340d7220ULL, 0x040fe20000410000ULL, 0x0000001034107220ULL, 0x040fe20000410000ULL,
0x0000001134117220ULL, 0x040fe20000410000ULL, 0x0000001434147220ULL, 0x040fe20000410000ULL,
0x0000001534157220ULL, 0x040fe20000410000ULL, 0x0000001834187220ULL, 0x040fe20000410000ULL,
0x0000001934197220ULL, 0x040fe20000410000ULL, 0x0000001c341c7220ULL, 0x040fe20000410000ULL,
0x0000001d341d7220ULL, 0x040fe20000410000ULL, 0x0000002034207220ULL, 0x040fe20000410000ULL,
0x0000002134217220ULL, 0x000fce0000410000ULL, 0x0000000000489947ULL, 0x000fea0003800000ULL,
0x0000000800347811ULL, 0x002fcc00078ff0ffULL, 0x00001f3439347589ULL, 0x004e6400000e0000ULL,
0x0000000634067220ULL, 0x042fe20000410000ULL, 0x0000000734077220ULL, 0x040fe20000410000ULL,
0x0000000a340a7220ULL, 0x040fe20000410000ULL, 0x0000000b340b7220ULL, 0x040fe20000410000ULL,
0x0000000e340e7220ULL, 0x040fe20000410000ULL, 0x0000000f340f7220ULL, 0x040fe20000410000ULL,
0x0000001234127220ULL, 0x040fe20000410000ULL, 0x0000001334137220ULL, 0x040fe20000410000ULL,
0x0000001634167220ULL, 0x040fe20000410000ULL, 0x0000001734177220ULL, 0x040fe20000410000ULL,
0x0000001a341a7220ULL, 0x040fe20000410000ULL, 0x0000001b341b7220ULL, 0x040fe20000410000ULL,
0x0000001e341e7220ULL, 0x040fe20000410000ULL, 0x0000001f341f7220ULL, 0x040fe20000410000ULL,
0x0000002234227220ULL, 0x040fe20000410000ULL, 0x0000002334237220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x0000001000347811ULL, 0x002fcc00078ff0ffULL,
0x00001f3439347589ULL, 0x004e6400000e0000ULL, 0x0000002434247220ULL, 0x042fe20000410000ULL,
0x0000002534257220ULL, 0x040fe20000410000ULL, 0x0000002834287220ULL, 0x040fe20000410000ULL,
0x0000002934297220ULL, 0x040fe20000410000ULL, 0x0000002c342c7220ULL, 0x040fe20000410000ULL,
0x0000002d342d7220ULL, 0x040fe20000410000ULL, 0x0000004034407220ULL, 0x040fe20000410000ULL,
0x0000004134417220ULL, 0x040fe20000410000ULL, 0x0000004834487220ULL, 0x040fe20000410000ULL,
0x0000004934497220ULL, 0x040fe20000410000ULL, 0x0000004434447220ULL, 0x040fe20000410000ULL,
0x0000004534457220ULL, 0x040fe20000410000ULL, 0x0000003c343c7220ULL, 0x040fe20000410000ULL,
0x0000003d343d7220ULL, 0x040fe20000410000ULL, 0x0000003034307220ULL, 0x040fe20000410000ULL,
0x0000003134317220ULL, 0x000fce0000410000ULL, 0x000000397c7c7220ULL, 0x004fe20000410000ULL,
0x000000000048b947ULL, 0x000fec0003800000ULL, 0x0000001800347811ULL, 0x002fcc00078ff0ffULL,
0x00001f3439347589ULL, 0x000e6400000e0000ULL, 0x0000002634267220ULL, 0x042fe20000410000ULL,
0x0000002734277220ULL, 0x040fe20000410000ULL, 0x0000002a342a7220ULL, 0x040fe20000410000ULL,
0x0000002b342b7220ULL, 0x040fe20000410000ULL, 0x0000002e342e7220ULL, 0x040fe20000410000ULL,
0x0000002f342f7220ULL, 0x040fe20000410000ULL, 0x0000004234427220ULL, 0x040fe20000410000ULL,
0x0000004334437220ULL, 0x040fe20000410000ULL, 0x0000004a344a7220ULL, 0x040fe20000410000ULL,
0x0000004b344b7220ULL, 0x040fe20000410000ULL, 0x0000004634467220ULL, 0x040fe20000410000ULL,
0x0000004734477220ULL, 0x040fe20000410000ULL, 0x0000003e343e7220ULL, 0x040fe20000410000ULL,
0x0000003f343f7220ULL, 0x040fe20000410000ULL, 0x0000003234327220ULL, 0x040fe20000410000ULL,
0x0000003334337220ULL, 0x000fce0000410000ULL, 0x0000003736ff7212ULL, 0x000fe400078030ffULL,
0x0000007e357e7209ULL, 0x000fd60007810000ULL, 0x8000007e35350221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b35350820ULL, 0x000fc80000410000ULL, 0x00000035006a0308ULL, 0x000ea40000000800ULL,
0x0000006a7d7d0220ULL, 0x004fce0000410000ULL, 0x0000200098347824ULL, 0x002fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xffffc00034347812ULL, 0x000fe200078ec0ffULL,
0x0001300067787836ULL, 0x000fc80000000000ULL, 0x0000000195357824ULL, 0x000fe400078e0234ULL,
0x0000001075587824ULL, 0x100fe400078e0278ULL, 0x0000001073347824ULL, 0x000fe200078e0278ULL,
0x000000356e357211ULL, 0x000fca00078e68ffULL, 0x0001700035387836ULL, 0x000fe20000000000ULL,
0x0000000000288947ULL, 0x000fec0003800000ULL, 0x00000002ff367819ULL, 0x000fe40000011600ULL,
0x0000006aff35723eULL, 0x000fe400000000ffULL, 0x00000010363a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000836647836ULL, 0x000fe20000000000ULL, 0x0000541035357816ULL, 0x000fe20000000035ULL,
0x0000001836627836ULL, 0x000fc80000000000ULL, 0x00001f6435647589ULL, 0x0002a800000e0000ULL,
0x00001f3a35637589ULL, 0x0002e800000e0000ULL, 0x00001f3635617589ULL, 0x00026800000e0000ULL,
0x00001f6235627589ULL, 0x00026400000e0000ULL, 0x000000005858783bULL, 0x000ee20000000200ULL,
0x0000001068547824ULL, 0x100fe400078e0238ULL, 0x0000001069507824ULL, 0x100fe200078e0238ULL,
0x000000003434783bULL, 0x002e620000000200ULL, 0x00000010664c7824ULL, 0x000fe200078e0238ULL,
0x0000000000208947ULL, 0x000fec0003800000ULL, 0x0000006158587232ULL, 0x088fe40000000000ULL,
0x000000615a5a7232ULL, 0x000fe40000000000ULL, 0x0000006459597232ULL, 0x084fe40000000000ULL,
0x000000645b5b7232ULL, 0x000fe40000000000ULL, 0x0000006334347232ULL, 0x082fe40000000000ULL,
0x0000006336367232ULL, 0x000fc40000000000ULL, 0x0000006235357232ULL, 0x080fe40000000000ULL,
0x0000006237377232ULL, 0x000fce0000000000ULL, 0x000000005050783bULL, 0x000f220000004200ULL,
0x0000003865387211ULL, 0x000fc600078e20ffULL, 0x000000004c4c783bULL, 0x000f680000004200ULL,
0x000000003838783bULL, 0x000f680000004200ULL, 0x000000005454783bULL, 0x000f620000004200ULL,
0x00000050580c723cULL, 0x018fec000000180cULL, 0x00000050342c723cULL, 0x002fec000000182cULL,
0x0000004c5814723cULL, 0x020fe20000001814ULL, 0x0000000298507824ULL, 0x000fca00078e00ffULL,
0x0000004c3448723cULL, 0x000fec0000001848ULL, 0x00000038581c723cULL, 0x004fe2000000181cULL,
0x00000004504c7812ULL, 0x000fc800078ec0ffULL, 0x000000024c4d7812ULL, 0x000fe200078efcffULL,
0x00000038343c723cULL, 0x000fe2000000183cULL, 0x000000086d4c7824ULL, 0x000fca00078e00ffULL,
0x0000004e5818723cULL, 0x000fe20000001818ULL, 0x0000004d00387211ULL, 0x000fe200078fe0ffULL,
0x0000400072397824ULL, 0x000fc600078e0295ULL, 0x000000386d737210ULL, 0x000fe20007ffe0ffULL,
0x0000004e3444723cULL, 0x000fe20000001844ULL, 0x000000016b757824ULL, 0x040fe400078e0238ULL,
0xfffffff84c737812ULL, 0x000fe200078ee273ULL, 0x000020006e397824ULL, 0x000fe400078e0239ULL,
0x000000545804723cULL, 0x000fe20000001804ULL, 0x000000086b4e7824ULL, 0x000fe400078e00ffULL,
0x0001700039767836ULL, 0x000fc60000000000ULL, 0xfffffff84e757812ULL, 0x000fe200078ee275ULL,
0x000000565808723cULL, 0x000fe20000001808ULL, 0x00000010607a7824ULL, 0x100fe400078e0276ULL,
0x000000105f797824ULL, 0x000fc600078e0276ULL, 0x000000525810723cULL, 0x000fec0000001810ULL,
0x0000003a5820723cULL, 0x000fec0000001820ULL, 0x000000543424723cULL, 0x000fe20000001824ULL,
0x0000001073587824ULL, 0x000fca00078e0278ULL, 0x000000563428723cULL, 0x000fe20000001828ULL,
0x000000005858783bULL, 0x000e6a0000000200ULL, 0x000000523440723cULL, 0x000fec0000001840ULL,
0x0000003a3430723cULL, 0x000fee0000001830ULL, 0x0000007875347211ULL, 0x000fe200078e20ffULL,
0x000000105e787824ULL, 0x000fca00078e0276ULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x0000000000208947ULL, 0x000ff40003800000ULL, 0x0000006158587232ULL, 0x082fe40000000000ULL,
0x000000615a5a7232ULL, 0x000fe40000000000ULL, 0x0000006459597232ULL, 0x080fe40000000000ULL,
0x000000645b5b7232ULL, 0x000fe40000000000ULL, 0x0000006334347232ULL, 0x084fe40000000000ULL,
0x0000006336367232ULL, 0x000fc40000000000ULL, 0x0000006235357232ULL, 0x080fe40000000000ULL,
0x0000006237377232ULL, 0x000fce0000000000ULL, 0x000000105d777824ULL, 0x000fe200078e0276ULL,
0x000000007a54783bULL, 0x000ee20000004200ULL, 0x000000c07b7b7836ULL, 0x000fe20000000000ULL,
0x0000940000047ab9ULL, 0x000fe20000000800ULL, 0x0000007c7d7c7221ULL, 0x000fe20000010000ULL,
0x000000007950783bULL, 0x000f280000004200ULL, 0x00000000784c783bULL, 0x000f680000004200ULL,
0x000000007738783bULL, 0x000f220000004200ULL, 0x000000543424723cULL, 0x00cfec0000001824ULL,
0x000000563428723cULL, 0x000fec0000001828ULL, 0x00000050342c723cULL, 0x010fec000000182cULL,
0x000000523440723cULL, 0x000fec0000001840ULL, 0x0000004c3448723cULL, 0x020fec0000001848ULL,
0x0000004e3444723cULL, 0x000fec0000001844ULL, 0x00000038343c723cULL, 0x002fec000000183cULL,
0x0000003a3430723cULL, 0x000fec0000001830ULL, 0x0000004c5814723cULL, 0x000fe20000001814ULL,
0x000000019a357836ULL, 0x000fca0000000000ULL, 0x000000943500720cULL, 0x000fe20003f06070ULL,
0x00000038581c723cULL, 0x000fe2000000181cULL, 0x00000002ff4c7819ULL, 0x000fca0000011698ULL,
0x000000565808723cULL, 0x000fe20000001808ULL, 0x0000000100387802ULL, 0x000fe20000000f00ULL,
0x000000084c397824ULL, 0x000fc800078e0295ULL, 0x01e6903839ff79a7ULL, 0x0003e2000850003fULL,
0x000000545804723cULL, 0x000fe20000001804ULL, 0x0000000470577c24ULL, 0x000fca000f8e027bULL,
0x00000050580c723cULL, 0x000fec000000180cULL, 0x000000525810723cULL, 0x000fec0000001810ULL,
0x0000004e5818723cULL, 0x000fec0000001818ULL, 0x0000003a5820723cULL, 0x000fe20000001820ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000400888947ULL, 0x002fde0003800000ULL, 0x00000003ff4e7819ULL, 0x100fe20000011600ULL,
0x000000ffff367224ULL, 0x000fe200078e0a7bULL, 0x0000007b96357248ULL, 0x000fe20007fe0000ULL,
0x0000900000047ab9ULL, 0x000fe20000000a00ULL, 0x0000006f6e347211ULL, 0x000fe200078e38ffULL,
0x000000044e507836ULL, 0x000fe20000000000ULL, 0x0000002035397446ULL, 0x000fe20003800036ULL,
0x000000014e367824ULL, 0x140fe200078e0200ULL, 0x0000001c4e807810ULL, 0x000fe20007ffe0ffULL,
0x000000014e377824ULL, 0x000fe200078e0257ULL, 0x00000057503b7210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x00000007364d7812ULL, 0x000fe200078ec0ffULL,
0x00000001504f7824ULL, 0x000fe200078e0200ULL, 0x000000394e00720cULL, 0x080fe20003f06070ULL,
0x0000010037367825ULL, 0x000fe200078e0034ULL, 0x000000395000720cULL, 0x000fc40003f26070ULL,
0x0ffffff84d4d7812ULL, 0x000fe200078ef800ULL, 0x0000000850527824ULL, 0x000fe200078e00ffULL,
0x0000000436367c10ULL, 0x000fe2000ff5e0ffULL, 0x000001003b3a7825ULL, 0x000fe200078e0034ULL,
0x000000084e507810ULL, 0x000fe40007ffe0ffULL, 0xfffffff852517812ULL, 0x000fe200078ee24fULL,
0x000000104d4f7824ULL, 0x100fe200078e0276ULL, 0x000000043a3a7c10ULL, 0x000fe2000ff7e0ffULL,
0x00000001504d7824ULL, 0x040fe200078e0257ULL, 0x0000000537377c10ULL, 0x000fe200097fe4ffULL,
0x0000001051517824ULL, 0x000fe200078e0276ULL, 0x000000053b3b7c10ULL, 0x000fe20009ffe4ffULL,
0x0000000c4e547836ULL, 0x000fe20000000000ULL, 0x000000395000720cULL, 0x080fe20003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000364f7faeULL, 0x0003e2000c101c46ULL,
0x000000104e567836ULL, 0x000fe20000000000ULL, 0x000000398000720cULL, 0x080fe20003f06070ULL,
0x000000144e587836ULL, 0x000fe20000000000ULL, 0x000000003a517faeULL, 0x0005e2000c901c46ULL,
0x000000184e5a7836ULL, 0x000fe20000000000ULL, 0x000000395400720cULL, 0x080fe20003f86070ULL,
0x0000000150527824ULL, 0x000fe200078e0200ULL, 0x000000395600720cULL, 0x080fe20003f66070ULL,
0x0000000850557824ULL, 0x000fe200078e00ffULL, 0x000000395800720cULL, 0x080fe20003f46070ULL,
0x0000000854597824ULL, 0x000fe200078e00ffULL, 0x000000395a00720cULL, 0x000fe20003f26070ULL,
0x000001004d367825ULL, 0x002fe200078e0034ULL, 0x00000057564d7210ULL, 0x000fc40007ffe0ffULL,
0xfffffff855557812ULL, 0x000fe200078ee252ULL, 0x00000001543b7824ULL, 0x104fe200078e0257ULL,
0x00000004364e7c10ULL, 0x000fe2000ffde0ffULL, 0x0000000158397824ULL, 0x000fe400078e0257ULL,
0x000001003b3a7825ULL, 0x000fe200078e0034ULL, 0x00000005374f7c10ULL, 0x000fc6000b7fe4ffULL,
0x000001004d367825ULL, 0x000fe200078e0034ULL, 0x000000043a507c10ULL, 0x000fc6000ffde0ffULL,
0x00000001543a7824ULL, 0x000fe200078e0200ULL, 0x000000053b517c10ULL, 0x000fe2000b7fe4ffULL,
0x000000015a4d7824ULL, 0x000fe200078e0257ULL, 0x0000000436527c10ULL, 0x000fe2000ffde0ffULL,
0x00000008565b7824ULL, 0x000fe200078e00ffULL, 0xfffffff859597812ULL, 0x000fe200078ee23aULL,
0x00000100393a7825ULL, 0x000fe200078e0034ULL, 0x0000000537537c10ULL, 0x000fe4000b7fe4ffULL,
0x0000000056547210ULL, 0x000fe20007ffe0ffULL, 0x0000000180397824ULL, 0x000fe200078e0257ULL,
0x000000043a3a7c10ULL, 0x000fe2000ffde0ffULL, 0x000001004d367825ULL, 0x000fe200078e0034ULL,
0xfffffff85b4d7812ULL, 0x000fc400078ee254ULL, 0x000000053b3b7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000010039347825ULL, 0x000fe200078e0034ULL, 0x000000005a397210ULL, 0x000fe40007ffe0ffULL,
0x0000000436367c10ULL, 0x000fe2000ffde0ffULL, 0x0000000158567824ULL, 0x140fe200078e0200ULL,
0x0000007659597211ULL, 0x000fe200078e20ffULL, 0x00000008587b7824ULL, 0x000fe200078e00ffULL,
0x0000000537377c10ULL, 0x000fe2000b7fe4ffULL, 0x000000085a5a7824ULL, 0x000fe200078e00ffULL,
0x0000000434347c10ULL, 0x000fe2000ffde0ffULL, 0x0000000180547824ULL, 0x040fe200078e0200ULL,
0xfffffff87b577812ULL, 0x000fe200078ee256ULL, 0x00000008805b7824ULL, 0x000fe200078e00ffULL,
0xfffffff85a397812ULL, 0x000fe200078ee239ULL, 0x0000001055557824ULL, 0x100fe200078e0276ULL,
0x0000000535357c10ULL, 0x000fe2000b7fe4ffULL, 0x000000104d4d7824ULL, 0x100fe200078e0276ULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee254ULL, 0x0000001057577824ULL, 0x100fe200078e0276ULL,
0x000000004e557faeULL, 0x0003e2000e901c46ULL, 0x0000001039397824ULL, 0x000fc400078e0276ULL,
0x000000105b5b7824ULL, 0x000fe200078e0276ULL, 0x0000000050597faeULL, 0x0003e8000e101c46ULL,
0x00000000524d7faeULL, 0x0003e8000d901c46ULL, 0x000000003a577faeULL, 0x0003e8000d101c46ULL,
0x0000000036397faeULL, 0x0003e8000c901c46ULL, 0x00000000345b7faeULL, 0x0003e2000c101c46ULL,
0x0000000400547947ULL, 0x000fea0003800000ULL, 0x0000000400377811ULL, 0x000fe200078fe8ffULL,
0x000000806e567824ULL, 0x000fe200078e026fULL, 0x00000008003b7811ULL, 0x040fe200078fe8ffULL,
0x0000900000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000037347210ULL, 0x000fe20007ffe0ffULL,
0x00000008374d7824ULL, 0x000fe200078e00ffULL, 0x0000000c004f7811ULL, 0x040fe200078fe8ffULL,
0x000000013b357824ULL, 0x140fe200078e0200ULL, 0x0000001000517811ULL, 0x040fe200078fe8ffULL,
0x000000083b367824ULL, 0x000fe200078e00ffULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee234ULL,
0x000000014f347824ULL, 0x100fe200078e0200ULL, 0x0000001800557811ULL, 0x040fe200078fe8ffULL,
0x00000008513a7824ULL, 0x000fe200078e00ffULL, 0x000000034f5b7819ULL, 0x000fe200000006ffULL,
0x0000000137377824ULL, 0x100fe200078e0257ULL, 0xfffffff836597812ULL, 0x000fe200078ee235ULL,
0x0000000151357824ULL, 0x100fe200078e0200ULL, 0x0000001400537811ULL, 0x040fe200078fe8ffULL,
0x00000008554e7824ULL, 0x000fe200078e00ffULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee234ULL,
0x000000013b3b7824ULL, 0x100fe200078e0257ULL, 0x0000000055397210ULL, 0x000fe20007ffe0ffULL,
0x0000000153367824ULL, 0x040fe200078e0200ULL, 0x0000001c00347811ULL, 0x040fe200078fe8ffULL,
0x00000008537d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83a7b7812ULL, 0x000fe200078ee235ULL,
0x0000000151517824ULL, 0x100fe200078e0257ULL, 0xfffffff84e7f7812ULL, 0x000fe200078ee239ULL,
0x0000000153537824ULL, 0x100fe200078e0257ULL, 0x0000005700357211ULL, 0x000fe200078fe8ffULL,
0x0000000155557824ULL, 0x100fe200078e0257ULL, 0x000000574f4f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000134397824ULL, 0x040fe200078e0257ULL, 0xfffffff87d7d7812ULL, 0x000fe200078ee236ULL,
0x000000ffff577224ULL, 0x000fe200078e00ffULL, 0x0000000034587210ULL, 0x000fe20007ffe0ffULL,
0x0000000834817824ULL, 0x000fe200078e00ffULL, 0x0000007659597211ULL, 0x000fe200078e20ffULL,
0x0000010035347825ULL, 0x000fc600078e0056ULL, 0xfffffff881817812ULL, 0x000fe200078ee258ULL,
0x0000010037367825ULL, 0x100fe200078e0056ULL, 0x0000000434347c10ULL, 0x000fe4000ff1e0ffULL,
0x0000007681817211ULL, 0x000fe200078e20ffULL, 0x000001003b3a7825ULL, 0x100fe200078e0056ULL,
0x0000000436367c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000535357c10ULL, 0x000fe200087fe4ffULL,
0x000001004f4e7825ULL, 0x000fe200078e0056ULL, 0x0000000537377c10ULL, 0x000fc40008ffe4ffULL,
0x000000043a3a7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000010051507825ULL, 0x100fe200078e0056ULL,
0x000000044e4e7c10ULL, 0x000fe4000ff3e0ffULL, 0x000000053b3b7c10ULL, 0x000fe200087fe4ffULL,
0x0000010053527825ULL, 0x100fe200078e0056ULL, 0x0000000450507c10ULL, 0x000fe4000ff5e0ffULL,
0x000000054f4f7c10ULL, 0x000fe20008ffe4ffULL, 0x0000010055547825ULL, 0x000fe200078e0056ULL,
0x0000000452527c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000551517c10ULL, 0x000fe200097fe4ffULL,
0x0000010039567825ULL, 0x000fe200078e0056ULL, 0x0000000000397211ULL, 0x000fe400078fe8ffULL,
0x0000000454547c10ULL, 0x000fe2000ff3e0ffULL, 0x000000104d4d7824ULL, 0x100fe200078e0276ULL,
0x0000000739397812ULL, 0x000fe200078ec0ffULL, 0x000000105b5b7824ULL, 0x100fe200078e0276ULL,
0x0000000456567c10ULL, 0x000fe2000ff5e0ffULL, 0x000000107b7b7824ULL, 0x100fe200078e0276ULL,
0x0ffffff839397812ULL, 0x000fe200078ef800ULL, 0x000000107d7d7824ULL, 0x100fe200078e0276ULL,
0x0000000553537c10ULL, 0x000fe200087fe4ffULL, 0x000000107f7f7824ULL, 0x100fe200078e0276ULL,
0x0000000555557c10ULL, 0x000fe20008ffe4ffULL, 0x0000001039397824ULL, 0x000fe200078e0276ULL,
0x0000000557577c10ULL, 0x000fc800097fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034397faeULL, 0x0003e8000b901c46ULL, 0x00000000364d7faeULL, 0x0003e8000b901c46ULL,
0x000000003a597faeULL, 0x0003e8000b901c46ULL, 0x000000004e5b7faeULL, 0x0003e8000b901c46ULL,
0x00000000507b7faeULL, 0x0003e8000b901c46ULL, 0x00000000527d7faeULL, 0x0003e8000b901c46ULL,
0x00000000547f7faeULL, 0x0003e8000b901c46ULL, 0x0000000056817faeULL, 0x0003e4000b901c46ULL,
0x0000001074357812ULL, 0x002fe200078ec0ffULL, 0x000000204c4c7824ULL, 0x000fe200078e0295ULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x0000000135357824ULL, 0x000fc800078e024cULL,
0x000000086e3b7824ULL, 0x000fc800078e0235ULL, 0x01e648383b3879a7ULL, 0x0002a6000850003fULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x01e648393b0075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036344d7210ULL, 0x000fc80007f1e1ffULL,
0x0000003735377210ULL, 0x000fe400007fe5ffULL, 0x003d09004d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000004d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x01e648393b0075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000002098347824ULL, 0x000fca00078e00ffULL, 0xffffff8034347812ULL, 0x000fc800078ec0ffULL,
0x0000010095347810ULL, 0x000fc80007ffe034ULL, 0x000000346c347210ULL, 0x000fca0007ffe06fULL,
0x01e0000034357984ULL, 0x000ea80000000800ULL, 0x01e20000347b7984ULL, 0x0006e20000000800ULL,
0x0000007e3500720bULL, 0x004fda0003f1d000ULL, 0x0000000000367806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x000000ff3600720cULL, 0x000fda0003f25270ULL,
0x0000000400949947ULL, 0x00afea0003800000ULL, 0x0000000298377811ULL, 0x000fe400078ff0ffULL,
0x0000007e3500720bULL, 0x000fe40003f14000ULL, 0x000000983700720cULL, 0x000fda0003f25270ULL,
0x0000008098379824ULL, 0x000fe200078e0295ULL, 0x0000007e35349209ULL, 0x000fc80007810000ULL,
0x000000376c399210ULL, 0x000fe40007ffe06fULL, 0x0000000000377806ULL, 0x000fc600000e0100ULL,
0x01e4003439009388ULL, 0x0003e20000000800ULL, 0x000000ff3700720cULL, 0x000fda0003f05270ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x0000007e35397209ULL, 0x000fe40007810000ULL,
0x000000ff37ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0037ff7812ULL, 0x000fe2000782c0ffULL,
0x0000007e39347221ULL, 0x000fe20000010100ULL, 0x00ff000037ff7812ULL, 0x040fe4000784c0ffULL,
0xff00000037ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL,
0x0000003400397308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff347819ULL, 0x002fcc0000011600ULL, 0x00001f3439347589ULL, 0x004e6400000e0000ULL,
0x0000000434047220ULL, 0x042fe20000410000ULL, 0x0000000534057220ULL, 0x040fe20000410000ULL,
0x0000000834087220ULL, 0x040fe20000410000ULL, 0x0000000934097220ULL, 0x040fe20000410000ULL,
0x0000000c340c7220ULL, 0x040fe20000410000ULL, 0x0000000d340d7220ULL, 0x040fe20000410000ULL,
0x0000001034107220ULL, 0x040fe20000410000ULL, 0x0000001134117220ULL, 0x040fe20000410000ULL,
0x0000001434147220ULL, 0x040fe20000410000ULL, 0x0000001534157220ULL, 0x040fe20000410000ULL,
0x0000001834187220ULL, 0x040fe20000410000ULL, 0x0000001934197220ULL, 0x040fe20000410000ULL,
0x0000001c341c7220ULL, 0x040fe20000410000ULL, 0x0000001d341d7220ULL, 0x040fe20000410000ULL,
0x0000002034207220ULL, 0x040fe20000410000ULL, 0x0000002134217220ULL, 0x000fce0000410000ULL,
0x0000000000489947ULL, 0x000fea0003800000ULL, 0x0000000800347811ULL, 0x002fcc00078ff0ffULL,
0x00001f3439347589ULL, 0x004e6400000e0000ULL, 0x0000000634067220ULL, 0x042fe20000410000ULL,
0x0000000734077220ULL, 0x040fe20000410000ULL, 0x0000000a340a7220ULL, 0x040fe20000410000ULL,
0x0000000b340b7220ULL, 0x040fe20000410000ULL, 0x0000000e340e7220ULL, 0x040fe20000410000ULL,
0x0000000f340f7220ULL, 0x040fe20000410000ULL, 0x0000001234127220ULL, 0x040fe20000410000ULL,
0x0000001334137220ULL, 0x040fe20000410000ULL, 0x0000001634167220ULL, 0x040fe20000410000ULL,
0x0000001734177220ULL, 0x040fe20000410000ULL, 0x0000001a341a7220ULL, 0x040fe20000410000ULL,
0x0000001b341b7220ULL, 0x040fe20000410000ULL, 0x0000001e341e7220ULL, 0x040fe20000410000ULL,
0x0000001f341f7220ULL, 0x040fe20000410000ULL, 0x0000002234227220ULL, 0x040fe20000410000ULL,
0x0000002334237220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000001000347811ULL, 0x002fcc00078ff0ffULL, 0x00001f3439347589ULL, 0x004e6400000e0000ULL,
0x0000002434247220ULL, 0x042fe20000410000ULL, 0x0000002534257220ULL, 0x040fe20000410000ULL,
0x0000002834287220ULL, 0x040fe20000410000ULL, 0x0000002934297220ULL, 0x040fe20000410000ULL,
0x0000002c342c7220ULL, 0x040fe20000410000ULL, 0x0000002d342d7220ULL, 0x040fe20000410000ULL,
0x0000004034407220ULL, 0x040fe20000410000ULL, 0x0000004134417220ULL, 0x040fe20000410000ULL,
0x0000004834487220ULL, 0x040fe20000410000ULL, 0x0000004934497220ULL, 0x040fe20000410000ULL,
0x0000004434447220ULL, 0x040fe20000410000ULL, 0x0000004534457220ULL, 0x040fe20000410000ULL,
0x0000003c343c7220ULL, 0x040fe20000410000ULL, 0x0000003d343d7220ULL, 0x040fe20000410000ULL,
0x0000003034307220ULL, 0x040fe20000410000ULL, 0x0000003134317220ULL, 0x000fce0000410000ULL,
0x000000397c7c7220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x0000001800347811ULL, 0x002fcc00078ff0ffULL, 0x00001f3439347589ULL, 0x000e6400000e0000ULL,
0x0000002634267220ULL, 0x042fe20000410000ULL, 0x0000002734277220ULL, 0x040fe20000410000ULL,
0x0000002a342a7220ULL, 0x040fe20000410000ULL, 0x0000002b342b7220ULL, 0x040fe20000410000ULL,
0x0000002e342e7220ULL, 0x040fe20000410000ULL, 0x0000002f342f7220ULL, 0x040fe20000410000ULL,
0x0000004234427220ULL, 0x040fe20000410000ULL, 0x0000004334437220ULL, 0x040fe20000410000ULL,
0x0000004a344a7220ULL, 0x040fe20000410000ULL, 0x0000004b344b7220ULL, 0x040fe20000410000ULL,
0x0000004634467220ULL, 0x040fe20000410000ULL, 0x0000004734477220ULL, 0x040fe20000410000ULL,
0x0000003e343e7220ULL, 0x040fe20000410000ULL, 0x0000003f343f7220ULL, 0x040fe20000410000ULL,
0x0000003234327220ULL, 0x040fe20000410000ULL, 0x0000003334337220ULL, 0x000fce0000410000ULL,
0x0000003736ff7212ULL, 0x000fe400078030ffULL, 0x0000007e357e7209ULL, 0x000fd60007810000ULL,
0x8000007e35350221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b35350820ULL, 0x000fc80000410000ULL,
0x00000035006a0308ULL, 0x000ea40000000800ULL, 0x0000006a7b7b0220ULL, 0x004fce0000410000ULL,
0x0000000198347819ULL, 0x042fe200000006ffULL, 0x0000200098367824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000434357812ULL, 0x000fe200078ec0ffULL,
0x000000086d387824ULL, 0x000fe200078e00ffULL, 0xffffc00036367812ULL, 0x000fe200078ec0ffULL,
0x000000086b397824ULL, 0x000fe200078e00ffULL, 0x0000003500347211ULL, 0x000fe200078fe0ffULL,
0x0001400067807836ULL, 0x000fe40000000000ULL, 0x0000000195377824ULL, 0x000fe200078e0236ULL,
0x000000346d357210ULL, 0x000fe20007ffe0ffULL, 0x000000016b347824ULL, 0x000fe400078e0234ULL,
0x000020006e507824ULL, 0x000fe200078e0237ULL, 0xfffffff838357812ULL, 0x000fc400078ee235ULL,
0xfffffff839377812ULL, 0x000fe200078ee234ULL, 0x0001600050507836ULL, 0x000fe20000000000ULL,
0x0000000000288947ULL, 0x000fec0003800000ULL, 0x00000002ff617819ULL, 0x000fe40000011600ULL,
0x0000006aff34723eULL, 0x000fe400000000ffULL, 0x0000000861397810ULL, 0x000fe20007ffe0ffULL,
0x0000001061637836ULL, 0x000fe20000000000ULL, 0x0000541034347816ULL, 0x000fe20000000034ULL,
0x00000018613b7836ULL, 0x000fc80000000000ULL, 0x00001f3934647589ULL, 0x0002a800000e0000ULL,
0x00001f6334637589ULL, 0x0002e800000e0000ULL, 0x00001f6134617589ULL, 0x00026800000e0000ULL,
0x00001f3b34627589ULL, 0x00026400000e0000ULL, 0x0000001035357824ULL, 0x100fe200078e0280ULL,
0x00000050684c7211ULL, 0x000fe200078e20ffULL, 0x0000001037387824ULL, 0x000fe400078e0280ULL,
0x0000001069517824ULL, 0x100fe400078e0250ULL, 0x000000003534783bULL, 0x002e620000000200ULL,
0x0000001066547824ULL, 0x000fc600078e0250ULL, 0x000000003838783bULL, 0x000ee20000000200ULL,
0x0000000000208947ULL, 0x000fea0003800000ULL, 0x0000006134347232ULL, 0x082fe40000000000ULL,
0x0000006136367232ULL, 0x000fe40000000000ULL, 0x0000006435357232ULL, 0x084fe40000000000ULL,
0x0000006437377232ULL, 0x000fe40000000000ULL, 0x0000006338387232ULL, 0x088fe40000000000ULL,
0x000000633a3a7232ULL, 0x000fc40000000000ULL, 0x0000006239397232ULL, 0x080fe40000000000ULL,
0x000000623b3b7232ULL, 0x000fce0000000000ULL, 0x0000001065587824ULL, 0x000fe200078e0250ULL,
0x000000004c4c783bULL, 0x000f280000004200ULL, 0x000000005150783bULL, 0x000f680000004200ULL,
0x000000005454783bULL, 0x000f680000004200ULL, 0x000000005858783bULL, 0x000f620000004200ULL,
0x0000004c3404723cULL, 0x012fec0000001804ULL, 0x0000004e3408723cULL, 0x000fec0000001808ULL,
0x00000050340c723cULL, 0x028fec000000180cULL, 0x000000523410723cULL, 0x000fec0000001810ULL,
0x000000543414723cULL, 0x004fec0000001814ULL, 0x000000563418723cULL, 0x000fec0000001818ULL,
0x00000058341c723cULL, 0x000fec000000181cULL, 0x0000005a3420723cULL, 0x000fec0000001820ULL,
0x0000004c3824723cULL, 0x000fe20000001824ULL, 0x0000400072357824ULL, 0x000fc400078e0295ULL,
0x0000001075347824ULL, 0x000fc600078e0280ULL, 0x0000004e3828723cULL, 0x000fe20000001828ULL,
0x000000356e357211ULL, 0x000fca00078e68ffULL, 0x00000050382c723cULL, 0x000fe2000000182cULL,
0x0001600035727836ULL, 0x000fe40000000000ULL, 0x000000003434783bULL, 0x000e640000000200ULL,
0x00000010604c7824ULL, 0x000fe200078e0272ULL, 0x000000523840723cULL, 0x000fe20000001840ULL,
0x000000725f507211ULL, 0x000fca00078e20ffULL, 0x000000543848723cULL, 0x000fec0000001848ULL,
0x000000563844723cULL, 0x000fe20000001844ULL, 0x000000105e547824ULL, 0x000fca00078e0272ULL,
0x00000058383c723cULL, 0x000fec000000183cULL, 0x0000005a3830723cULL, 0x000fee0000001830ULL,
0x0000001073387824ULL, 0x000fcc00078e0280ULL, 0x000000003838783bULL, 0x000ea20000000200ULL,
0x0000000000208947ULL, 0x002ff40003800000ULL, 0x0000006138387232ULL, 0x084fe40000000000ULL,
0x000000613a3a7232ULL, 0x000fe40000000000ULL, 0x0000006439397232ULL, 0x080fe40000000000ULL,
0x000000643b3b7232ULL, 0x000fe40000000000ULL, 0x0000006334347232ULL, 0x080fe40000000000ULL,
0x0000006336367232ULL, 0x000fc40000000000ULL, 0x0000006235357232ULL, 0x080fe40000000000ULL,
0x0000006237377232ULL, 0x000fce0000000000ULL, 0x000000105d587824ULL, 0x000fe200078e0272ULL,
0x000000004c4c783bULL, 0x000e620000004200ULL, 0x0000009a999a7210ULL, 0x000fe20007ffe0ffULL,
0x0000007c7b7b7221ULL, 0x000fe40000010000ULL, 0x000000005050783bULL, 0x000ee20000004200ULL,
0x000000949a00720cULL, 0x000fc60003f06070ULL, 0x000000005454783bULL, 0x000f280000004200ULL,
0x000000005858783bULL, 0x000f620000004200ULL, 0x0000004c3804723cULL, 0x006fec0000001804ULL,
0x0000004e3808723cULL, 0x000fec0000001808ULL, 0x00000050380c723cULL, 0x008fec000000180cULL,
0x000000523810723cULL, 0x000fec0000001810ULL, 0x000000543814723cULL, 0x010fec0000001814ULL,
0x000000563818723cULL, 0x000fec0000001818ULL, 0x00000058381c723cULL, 0x020fec000000181cULL,
0x0000005a3820723cULL, 0x000fec0000001820ULL, 0x0000004c3424723cULL, 0x000fe20000001824ULL,
0x00000002ff387819ULL, 0x000fe20000011698ULL, 0x00000001ff397424ULL, 0x000fc800078e00ffULL,
0x00000008383a7824ULL, 0x000fe200078e0295ULL, 0x0000004e3428723cULL, 0x000fe60000001828ULL,
0x01e698393aff79a7ULL, 0x0003e6000850003fULL, 0x00000050342c723cULL, 0x000fec000000182cULL,
0x000000523440723cULL, 0x000fec0000001840ULL, 0x000000543448723cULL, 0x000fec0000001848ULL,
0x000000563444723cULL, 0x000fec0000001844ULL, 0x00000058343c723cULL, 0x000fec000000183cULL,
0x0000005a3430723cULL, 0x000fe20000001830ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000800f40947ULL, 0x002fde0003800000ULL,
0x000000019a357836ULL, 0x000fe20000000000ULL, 0x0000940000047ab9ULL, 0x000fe20000000800ULL,
0x000001009a377824ULL, 0x000fc600078e0271ULL, 0x000000943500720cULL, 0x000fe20003f06070ULL,
0x0000000470557c24ULL, 0x000fd8000f8e0237ULL, 0x0000000400888947ULL, 0x000fea0003800000ULL,
0x00000003ff577819ULL, 0x000fe20000011600ULL, 0x000000ffff547224ULL, 0x000fe200078e0a37ULL,
0x0000003796357248ULL, 0x000fe20007fe0000ULL, 0x000000806e347824ULL, 0x000fe200078e026fULL,
0x0000900000047ab9ULL, 0x000fe20000000a00ULL, 0x00000004573b7836ULL, 0x000fe20000000000ULL,
0x0000002035547446ULL, 0x000fe20003800054ULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x0000001857817810ULL, 0x000fe20007ffe0ffULL, 0x000000083b5b7824ULL, 0x000fe200078e00ffULL,
0x000000003b367210ULL, 0x000fe20007ffe0ffULL, 0x0000000157377824ULL, 0x100fe200078e0255ULL,
0x000000543b00720cULL, 0x080fe20003f26070ULL, 0x00000008575d7836ULL, 0x000fe20000000000ULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee236ULL, 0x0000000c575f7836ULL, 0x000fe20000000000ULL,
0x0000000057367210ULL, 0x000fe20007ffe0ffULL, 0x000000015d4d7824ULL, 0x100fe200078e0255ULL,
0x000000545700720cULL, 0x000fe20003f06070ULL, 0x000000013b3b7824ULL, 0x000fe200078e0255ULL,
0x0000000736537812ULL, 0x000fe200078ec0ffULL, 0x0000010037367825ULL, 0x000fe200078e0034ULL,
0x000000555f4f7210ULL, 0x000fc40007ffe0ffULL, 0x000000545d00720cULL, 0x080fe20003fa6070ULL,
0x000001004d4c7825ULL, 0x100fe200078e0034ULL, 0x0000000436507c10ULL, 0x000fe4000ff5e0ffULL,
0x000000545f00720cULL, 0x000fe20003f86070ULL, 0x000001003b3a7825ULL, 0x100fe200078e0034ULL,
0x0000000537517c10ULL, 0x000fe400097fe4ffULL, 0x0ffffff853377812ULL, 0x000fe200078ef800ULL,
0x00000010577d7836ULL, 0x000fe20000000000ULL, 0x000000044c367c10ULL, 0x000fe2000ff5e0ffULL,
0x000001004f4e7825ULL, 0x000fe200078e0034ULL, 0x000000043a527c10ULL, 0x000fc6000ff7e0ffULL,
0x0000001037597824ULL, 0x000fe200078e0272ULL, 0x000000054d377c10ULL, 0x000fe200097fe4ffULL,
0x000000017d4d7824ULL, 0x000fe200078e0255ULL, 0x000000053b537c10ULL, 0x000fe20009ffe4ffULL,
0x00000014577f7836ULL, 0x000fe20000000000ULL, 0x000000044e3a7c10ULL, 0x000fe2000ff7e0ffULL,
0x000001004d4c7825ULL, 0x000fe200078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000050597faeULL, 0x0003e4000c101c46ULL, 0x000000054f3b7c10ULL, 0x000fe20009ffe4ffULL,
0x000000015d4f7824ULL, 0x040fe200078e0200ULL, 0x000000044c4e7c10ULL, 0x000fe2000ffde0ffULL,
0x000000085d567824ULL, 0x000fe200078e00ffULL, 0x000000547d00720cULL, 0x080fe20003f66070ULL,
0x000000105b5b7824ULL, 0x000fe200078e0272ULL, 0x000000547f00720cULL, 0x0c0fe20003f46070ULL,
0x0000001c57837836ULL, 0x000fe20000000000ULL, 0xfffffff856577812ULL, 0x000fe200078ee24fULL,
0x000000087f5d7824ULL, 0x040fe200078e00ffULL, 0x000000054d4f7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000017f517824ULL, 0x002fe200078e0255ULL, 0x000000005f507210ULL, 0x000fe20007ffe0ffULL,
0x000000085f597824ULL, 0x000fe200078e00ffULL, 0x00000000525b7faeULL, 0x0003e2000c901c46ULL,
0x00000100514c7825ULL, 0x000fe200078e0034ULL, 0x000000548100720cULL, 0x000fc40003f26070ULL,
0x000000548300720cULL, 0x000fe20003f06070ULL, 0x000000017d517824ULL, 0x040fe200078e0200ULL,
0xfffffff859597812ULL, 0x000fe200078ee250ULL, 0x000000087d547824ULL, 0x000fe200078e00ffULL,
0x000000044c507c10ULL, 0x000fe2000ffde0ffULL, 0x0000001057577824ULL, 0x100fe400078e0272ULL,
0x0000001059597824ULL, 0x000fe200078e0272ULL, 0x000000007f527210ULL, 0x002fe20007ffe0ffULL,
0x0000000181537824ULL, 0x100fe200078e0255ULL, 0xfffffff8545b7812ULL, 0x000fe200078ee251ULL,
0x0000000183557824ULL, 0x000fe200078e0255ULL, 0x000000054d517c10ULL, 0x000fe2000b7fe4ffULL,
0x00000100534c7825ULL, 0x000fe200078e0034ULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee252ULL,
0x0000000036577faeULL, 0x0003e2000e901c46ULL, 0x0000000381537819ULL, 0x040fe200000006ffULL,
0x0000000181527824ULL, 0x100fe200078e0200ULL, 0x000000044c4c7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000183547824ULL, 0x000fe200078e0200ULL, 0x000000725b5b7211ULL, 0x000fe200078e20ffULL,
0x0000000883837824ULL, 0x000fe200078e00ffULL, 0xfffffff853537812ULL, 0x000fe200078ee252ULL,
0x0000010055347825ULL, 0x000fe200078e0034ULL, 0x000000054d4d7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000003a597faeULL, 0x0003e2000e101c46ULL, 0xfffffff883557812ULL, 0x000fe200078ee254ULL,
0x000000105d5d7824ULL, 0x100fe200078e0272ULL, 0x0000000434347c10ULL, 0x000fe2000ffde0ffULL,
0x0000001053537824ULL, 0x100fe200078e0272ULL, 0x000000004e5b7faeULL, 0x0003e2000d901c46ULL,
0x0000001055557824ULL, 0x000fe200078e0272ULL, 0x0000000535357c10ULL, 0x000fc4000b7fe4ffULL,
0x00000000505d7faeULL, 0x0003e8000d101c46ULL, 0x000000004c537faeULL, 0x0003e8000c901c46ULL,
0x0000000034557faeULL, 0x0003e2000c101c46ULL, 0x0000000400547947ULL, 0x000fea0003800000ULL,
0x00000008003b7811ULL, 0x000fe200078fe8ffULL, 0x000000806e547824ULL, 0x000fe200078e026fULL,
0x0000000400377811ULL, 0x040fe200078fe8ffULL, 0x0000900000047ab9ULL, 0x000fe20000000a00ULL,
0x0000001400517811ULL, 0x040fe200078fe8ffULL, 0x000000013b357824ULL, 0x100fe200078e0200ULL,
0x00000003375b7819ULL, 0x000fe200000006ffULL, 0x000000083b367824ULL, 0x000fe200078e00ffULL,
0x0000000c004d7811ULL, 0x040fe200078fe8ffULL, 0x0000000137347824ULL, 0x100fe200078e0200ULL,
0x00000010004f7811ULL, 0x040fe200078fe8ffULL, 0x00000008517f7824ULL, 0x040fe200078e00ffULL,
0xfffffff8365d7812ULL, 0x000fe200078ee235ULL, 0x0000000151367824ULL, 0x100fe200078e0200ULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee234ULL, 0x000000014d347824ULL, 0x140fe200078e0200ULL,
0x0000001800537811ULL, 0x040fe200078fe8ffULL, 0x000000084d5f7824ULL, 0x000fe200078e00ffULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee236ULL, 0x000000084f4c7824ULL, 0x000fe200078e00ffULL,
0x000000004f357210ULL, 0x000fe20007ffe0ffULL, 0x00000001533a7824ULL, 0x100fe200078e0200ULL,
0x0000001c00367811ULL, 0x040fe200078fe8ffULL, 0x0000000137377824ULL, 0x100fe200078e0255ULL,
0x0000000353817819ULL, 0x000fe200000006ffULL, 0x000000013b3b7824ULL, 0x100fe200078e0255ULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee234ULL, 0x000000014d4d7824ULL, 0x100fe200078e0255ULL,
0xfffffff84c7d7812ULL, 0x000fe200078ee235ULL, 0x0000000151517824ULL, 0x100fe200078e0255ULL,
0x0000000000347211ULL, 0x040fe200078fe8ffULL, 0x0000000153537824ULL, 0x100fe200078e0255ULL,
0x0000005500357211ULL, 0x000fe200078fe8ffULL, 0x0000000136577824ULL, 0x000fe200078e0255ULL,
0x000000554f4f7210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff557224ULL, 0x000fe200078e00ffULL,
0x0000000734597812ULL, 0x000fe200078ec0ffULL, 0x0000000136567824ULL, 0x040fe200078e0200ULL,
0x0000000336837819ULL, 0x000fe200000006ffULL, 0x0000010035347825ULL, 0x000fe200078e0054ULL,
0xfffffff881817812ULL, 0x000fc400078ee23aULL, 0x0ffffff859597812ULL, 0x000fe200078ef800ULL,
0x0000010037367825ULL, 0x100fe200078e0054ULL, 0x0000000434347c10ULL, 0x000fe4000ff1e0ffULL,
0x000000725f5f7211ULL, 0x000fe200078e20ffULL, 0x000001003b3a7825ULL, 0x100fe200078e0054ULL,
0x0000000436367c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000535357c10ULL, 0x000fe200087fe4ffULL,
0x000001004d4c7825ULL, 0x000fe200078e0054ULL, 0x000000043a3a7c10ULL, 0x000fc4000ff5e0ffULL,
0x0000000537377c10ULL, 0x000fe20008ffe4ffULL, 0x000001004f4e7825ULL, 0x100fe200078e0054ULL,
0x000000044c4c7c10ULL, 0x000fe4000ff7e0ffULL, 0x000000053b3b7c10ULL, 0x000fe200097fe4ffULL,
0x0000010051507825ULL, 0x100fe200078e0054ULL, 0x000000044e4e7c10ULL, 0x000fe4000ff1e0ffULL,
0x000000054d4d7c10ULL, 0x000fe20009ffe4ffULL, 0x0000010053527825ULL, 0x000fe200078e0054ULL,
0x0000000450507c10ULL, 0x000fc4000ff3e0ffULL, 0x000000054f4f7c10ULL, 0x000fe200087fe4ffULL,
0x0000010057547825ULL, 0x000fe200078e0054ULL, 0xfffffff883577812ULL, 0x000fe400078ee256ULL,
0x0000000452527c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001059597824ULL, 0x100fe200078e0272ULL,
0x0000000454547c10ULL, 0x000fe2000ff7e0ffULL, 0x000000105b5b7824ULL, 0x100fe200078e0272ULL,
0x0000000551517c10ULL, 0x000fe20008ffe4ffULL, 0x000000105d5d7824ULL, 0x100fe200078e0272ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034597faeULL, 0x0003e2000b901c46ULL,
0x000000107d7d7824ULL, 0x100fe200078e0272ULL, 0x0000000553537c10ULL, 0x000fe200097fe4ffULL,
0x000000107f7f7824ULL, 0x100fe200078e0272ULL, 0x00000000365b7faeULL, 0x0003e2000b901c46ULL,
0x0000001081817824ULL, 0x100fe200078e0272ULL, 0x0000000555557c10ULL, 0x000fe20009ffe4ffULL,
0x0000001057577824ULL, 0x000fe200078e0272ULL, 0x000000003a5d7faeULL, 0x0003e8000b901c46ULL,
0x000000004c5f7faeULL, 0x0003e8000b901c46ULL, 0x000000004e7d7faeULL, 0x0003e8000b901c46ULL,
0x00000000507f7faeULL, 0x0003e8000b901c46ULL, 0x0000000052817faeULL, 0x0003e8000b901c46ULL,
0x0000000054577faeULL, 0x0003e4000b901c46ULL, 0x0000009538387211ULL, 0x000fe200078e28ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000010743b7812ULL, 0x042fe400078ec0ffULL,
0x0000000874347812ULL, 0x000fc800078ec0ffULL, 0x00000038343b7210ULL, 0x000fc80007ffe03bULL,
0x01e668393b3879a7ULL, 0x0002a6000850003fULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x01e668393b0075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x00000036344d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09004d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000004d36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x01e668393b0075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000000398347811ULL, 0x000fe200078ff0ffULL,
0x000000ffff5d7224ULL, 0x000fc600078e007eULL, 0x0000009534357211ULL, 0x000fc800078e38ffULL,
0x000000356c357210ULL, 0x000fca0007ffe06fULL, 0x01e0000035377984ULL, 0x000ea80000000800ULL,
0x01e20000355e7984ULL, 0x0006e20000000800ULL, 0x0000007e3700720bULL, 0x004fda0003f1d000ULL,
0x0000000000367806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x000000ff3600720cULL, 0x000fda0003f25270ULL, 0x0000000400909947ULL, 0x00afea0003800000ULL,
0x000000983400720cULL, 0x000fe40003f25270ULL, 0x0000007e3700720bULL, 0x000fd60003f14000ULL,
0x0000008098389824ULL, 0x000fe200078e0295ULL, 0x0000007e37359209ULL, 0x000fe40007810000ULL,
0x0000000000397806ULL, 0x000fe400000e0100ULL, 0x000000386c389210ULL, 0x000fe40007ffe06fULL,
0x000000ff3900720cULL, 0x000fc60003f05270ULL, 0x01e4003538009388ULL, 0x0003f40000000800ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x0000007e37357209ULL, 0x000fe40007810000ULL,
0x000000ff39ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0039ff7812ULL, 0x000fe2000782c0ffULL,
0x0000007e35357221ULL, 0x000fe20000010100ULL, 0x00ff000039ff7812ULL, 0x040fe4000784c0ffULL,
0xff00000039ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b35357820ULL, 0x000fc80000410000ULL,
0x0000003500387308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff357819ULL, 0x002fcc0000011600ULL, 0x00001f3538357589ULL, 0x004e6400000e0000ULL,
0x0000000435047220ULL, 0x042fe20000410000ULL, 0x0000000535057220ULL, 0x040fe20000410000ULL,
0x0000000835087220ULL, 0x040fe20000410000ULL, 0x0000000935097220ULL, 0x040fe20000410000ULL,
0x0000000c350c7220ULL, 0x040fe20000410000ULL, 0x0000000d350d7220ULL, 0x040fe20000410000ULL,
0x0000001035107220ULL, 0x040fe20000410000ULL, 0x0000001135117220ULL, 0x040fe20000410000ULL,
0x0000001435147220ULL, 0x040fe20000410000ULL, 0x0000001535157220ULL, 0x040fe20000410000ULL,
0x0000001835187220ULL, 0x040fe20000410000ULL, 0x0000001935197220ULL, 0x040fe20000410000ULL,
0x0000001c351c7220ULL, 0x040fe20000410000ULL, 0x0000001d351d7220ULL, 0x040fe20000410000ULL,
0x0000002035207220ULL, 0x040fe20000410000ULL, 0x0000002135217220ULL, 0x000fce0000410000ULL,
0x0000000000489947ULL, 0x000fea0003800000ULL, 0x0000000800357811ULL, 0x002fcc00078ff0ffULL,
0x00001f3538357589ULL, 0x004e6400000e0000ULL, 0x0000000635067220ULL, 0x042fe20000410000ULL,
0x0000000735077220ULL, 0x040fe20000410000ULL, 0x0000000a350a7220ULL, 0x040fe20000410000ULL,
0x0000000b350b7220ULL, 0x040fe20000410000ULL, 0x0000000e350e7220ULL, 0x040fe20000410000ULL,
0x0000000f350f7220ULL, 0x040fe20000410000ULL, 0x0000001235127220ULL, 0x040fe20000410000ULL,
0x0000001335137220ULL, 0x040fe20000410000ULL, 0x0000001635167220ULL, 0x040fe20000410000ULL,
0x0000001735177220ULL, 0x040fe20000410000ULL, 0x0000001a351a7220ULL, 0x040fe20000410000ULL,
0x0000001b351b7220ULL, 0x040fe20000410000ULL, 0x0000001e351e7220ULL, 0x040fe20000410000ULL,
0x0000001f351f7220ULL, 0x040fe20000410000ULL, 0x0000002235227220ULL, 0x040fe20000410000ULL,
0x0000002335237220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000001000357811ULL, 0x002fcc00078ff0ffULL, 0x00001f3538357589ULL, 0x004e6400000e0000ULL,
0x0000002435247220ULL, 0x042fe20000410000ULL, 0x0000002535257220ULL, 0x040fe20000410000ULL,
0x0000002835287220ULL, 0x040fe20000410000ULL, 0x0000002935297220ULL, 0x040fe20000410000ULL,
0x0000002c352c7220ULL, 0x040fe20000410000ULL, 0x0000002d352d7220ULL, 0x040fe20000410000ULL,
0x0000004035407220ULL, 0x040fe20000410000ULL, 0x0000004135417220ULL, 0x040fe20000410000ULL,
0x0000004835487220ULL, 0x040fe20000410000ULL, 0x0000004935497220ULL, 0x040fe20000410000ULL,
0x0000004435447220ULL, 0x040fe20000410000ULL, 0x0000004535457220ULL, 0x040fe20000410000ULL,
0x0000003c353c7220ULL, 0x040fe20000410000ULL, 0x0000003d353d7220ULL, 0x040fe20000410000ULL,
0x0000003035307220ULL, 0x040fe20000410000ULL, 0x0000003135317220ULL, 0x000fce0000410000ULL,
0x000000387b7b7220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x0000001800357811ULL, 0x002fcc00078ff0ffULL, 0x00001f3538357589ULL, 0x000e6400000e0000ULL,
0x0000002635267220ULL, 0x042fe20000410000ULL, 0x0000002735277220ULL, 0x040fe20000410000ULL,
0x0000002a352a7220ULL, 0x040fe20000410000ULL, 0x0000002b352b7220ULL, 0x040fe20000410000ULL,
0x0000002e352e7220ULL, 0x040fe20000410000ULL, 0x0000002f352f7220ULL, 0x040fe20000410000ULL,
0x0000004235427220ULL, 0x040fe20000410000ULL, 0x0000004335437220ULL, 0x040fe20000410000ULL,
0x0000004a354a7220ULL, 0x040fe20000410000ULL, 0x0000004b354b7220ULL, 0x040fe20000410000ULL,
0x0000004635467220ULL, 0x040fe20000410000ULL, 0x0000004735477220ULL, 0x040fe20000410000ULL,
0x0000003e353e7220ULL, 0x040fe20000410000ULL, 0x0000003f353f7220ULL, 0x040fe20000410000ULL,
0x0000003235327220ULL, 0x040fe20000410000ULL, 0x0000003335337220ULL, 0x000fce0000410000ULL,
0x0000003936ff7212ULL, 0x000fe400078030ffULL, 0x0000007e375d7209ULL, 0x000fd60007810000ULL,
0x8000005d37370221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b37370820ULL, 0x000fc80000410000ULL,
0x00000037006a0308ULL, 0x000ea40000000800ULL, 0x0000006a5e5e0220ULL, 0x004fce0000410000ULL,
0x00000001ff727819ULL, 0x000fe20000011698ULL, 0x0000100034347824ULL, 0x000fe200078e0295ULL,
0x00000004ff367819ULL, 0x000fe20000011600ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000172357812ULL, 0x002fe200078ec0ffULL, 0x0001200034347836ULL, 0x000fe20000000000ULL,
0x000000036d387819ULL, 0x000fe400000006ffULL, 0x00000076684c7211ULL, 0x000fe200078e20ffULL,
0x0000000435367824ULL, 0x000fe400078e0236ULL, 0x000000086b357824ULL, 0x000fe400078e00ffULL,
0x000000016d6d7824ULL, 0x100fe400078e0236ULL, 0x000000016b367824ULL, 0x000fc600078e0236ULL,
0xfffffff8386d7812ULL, 0x000fe400078ee26dULL, 0xfffffff835357812ULL, 0x000fc600078ee236ULL,
0x000000106d6d7824ULL, 0x100fe400078e0234ULL, 0x0000001035357824ULL, 0x000fe200078e0234ULL,
0x0000000000288947ULL, 0x000fec0003800000ULL, 0x00000002ff617819ULL, 0x000fe40000011600ULL,
0x0000006aff34723eULL, 0x000fe400000000ffULL, 0x0000001861397810ULL, 0x000fe20007ffe0ffULL,
0x0000001061637836ULL, 0x000fe20000000000ULL, 0x0000541034347816ULL, 0x000fe20000000034ULL,
0x0000000861377836ULL, 0x000fc80000000000ULL, 0x00001f6334637589ULL, 0x0002a800000e0000ULL,
0x00001f3734647589ULL, 0x0002e800000e0000ULL, 0x00001f6134617589ULL, 0x00026800000e0000ULL,
0x00001f3934627589ULL, 0x00026400000e0000ULL, 0x000000006d38783bULL, 0x0022e80000000200ULL,
0x000000003534783bULL, 0x000ea20000000200ULL, 0x0000000000208947ULL, 0x000fea0003800000ULL,
0x0000006138387232ULL, 0x088fe40000000000ULL, 0x000000613a3a7232ULL, 0x000fe40000000000ULL,
0x0000006439397232ULL, 0x080fe40000000000ULL, 0x000000643b3b7232ULL, 0x000fe40000000000ULL,
0x0000006334347232ULL, 0x084fe40000000000ULL, 0x0000006336367232ULL, 0x000fc40000000000ULL,
0x0000006235357232ULL, 0x080fe40000000000ULL, 0x0000006237377232ULL, 0x000fce0000000000ULL,
0x000000004c4c783bULL, 0x000f220000004200ULL, 0x0000001069507824ULL, 0x100fe400078e0276ULL,
0x00000010667c7824ULL, 0x100fe400078e0276ULL, 0x0000001065847824ULL, 0x000fe400078e0276ULL,
0x000000005050783bULL, 0x000f680000004200ULL, 0x000000007c7c783bULL, 0x000f680000004200ULL,
0x000000008484783bULL, 0x000f620000004200ULL, 0x0000004c3858723cULL, 0x018fec0000001804ULL,
0x0000004e3880723cULL, 0x000fe20000001808ULL, 0x0001500067047836ULL, 0x000fca0000000000ULL,
0x0000000473547211ULL, 0x000fe200078e20ffULL, 0x0000001075047824ULL, 0x000fe200078e0204ULL,
0x00000050380c723cULL, 0x022fe8000000180cULL, 0x000000005454783bULL, 0x000e640000000200ULL,
0x000000523810723cULL, 0x000fe40000001810ULL, 0x000000000404783bULL, 0x000e680000000200ULL,
0x0000007c3814723cULL, 0x000fec0000001814ULL, 0x0000007e3818723cULL, 0x000fec0000001818ULL,
0x00000084381c723cULL, 0x004fec000000181cULL, 0x000000863820723cULL, 0x000fec0000001820ULL,
0x0000004c3424723cULL, 0x000fec0000001824ULL, 0x0000004e3428723cULL, 0x000fec0000001828ULL,
0x00000050342c723cULL, 0x000fec000000182cULL, 0x000000523440723cULL, 0x000fec0000001840ULL,
0x0000007c3448723cULL, 0x000fec0000001848ULL, 0x0000007e3444723cULL, 0x000fe20000001844ULL,
0x0000007b5e7c7221ULL, 0x000fca0000010000ULL, 0x00000084343c723cULL, 0x000fec000000183cULL,
0x000000863430723cULL, 0x000fe20000001830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000208947ULL, 0x002fde0003800000ULL, 0x0000006154547232ULL, 0x080fe40000000000ULL,
0x0000006156567232ULL, 0x000fe40000000000ULL, 0x0000006455557232ULL, 0x080fe40000000000ULL,
0x0000006457577232ULL, 0x000fe40000000000ULL, 0x0000006304047232ULL, 0x080fe40000000000ULL,
0x0000006306067232ULL, 0x000fc40000000000ULL, 0x0000006205057232ULL, 0x080fe40000000000ULL,
0x0000006207077232ULL, 0x000fce0000000000ULL, 0x000000007a38783bULL, 0x000e620000004200ULL,
0x000000949a00720cULL, 0x000fc60003f06070ULL, 0x000000007734783bULL, 0x000ea80000004200ULL,
0x00000000794c783bULL, 0x000ee80000004200ULL, 0x000000007850783bULL, 0x000f220000004200ULL,
0x000000385408723cULL, 0x002fec0000001858ULL, 0x000000380424723cULL, 0x000fec0000001824ULL,
0x00000034541c723cULL, 0x004fe2000000181cULL, 0x0000000298387824ULL, 0x000fca00078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ec0ffULL, 0x00000034043c723cULL, 0x000fe8000000183cULL,
0x0000000195387824ULL, 0x000fe400078e0238ULL, 0x0000003a5480723cULL, 0x000fe20000001880ULL,
0x00000001ff357424ULL, 0x000fc800078e00ffULL, 0x01e6a03538ff79a7ULL, 0x0003e2000850003fULL,
0x0000004c540c723cULL, 0x008fec000000180cULL, 0x0000004e5410723cULL, 0x000fec0000001810ULL,
0x000000505414723cULL, 0x010fec0000001814ULL, 0x000000525418723cULL, 0x000fec0000001818ULL,
0x000000365420723cULL, 0x000fec0000001820ULL, 0x0000003a0428723cULL, 0x000fec0000001828ULL,
0x0000004c042c723cULL, 0x000fec000000182cULL, 0x0000004e0440723cULL, 0x000fec0000001840ULL,
0x000000500448723cULL, 0x000fec0000001848ULL, 0x000000520444723cULL, 0x000fec0000001844ULL,
0x000000360430723cULL, 0x000fe20000001830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffff8c00708947ULL, 0x002fde000383ffffULL, 0x0000000000047919ULL, 0x000e620000002500ULL,
0x000000ffff387224ULL, 0x000fe200078e002cULL, 0x0000002e00397202ULL, 0x000fe20000000f00ULL,
0x000000ffff367224ULL, 0x000fe200078e002bULL, 0x00000033004e7202ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fe200078e0030ULL, 0x0000002400307202ULL, 0x000fe20000000f00ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0021ULL, 0x0000002900337202ULL, 0x000fe20000000f00ULL,
0x000000ffff2b7224ULL, 0x000fe400078e001eULL, 0x000000ffff2e7224ULL, 0x000fe200078e0023ULL,
0x0000001a00237202ULL, 0x000fe20000000f00ULL, 0x000000ffff1e7224ULL, 0x000fe200078e0018ULL,
0x00000015001a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff217224ULL, 0x000fc400078e0016ULL,
0x000000ffff247224ULL, 0x000fe400078e001cULL, 0x000000ffff187224ULL, 0x000fe200078e0014ULL,
0x0000001000147202ULL, 0x000fe20000000f00ULL, 0x000000ffff167224ULL, 0x000fe400078e0013ULL,
0x000000ffff3b7224ULL, 0x000fe400078e0031ULL, 0x000000ffff377224ULL, 0x000fe400078e002dULL,
0x000000ffff357224ULL, 0x000fc400078e002aULL, 0x000000ffff1c7224ULL, 0x000fe400078e0017ULL,
0x000000ffff137224ULL, 0x000fe200078e000eULL, 0x000000940400720cULL, 0x002fe20003f06070ULL,
0x000000ffff4d7224ULL, 0x000fe400078e0032ULL, 0x000000ffff3a7224ULL, 0x000fe400078e002fULL,
0x000000ffff347224ULL, 0x000fe200078e0028ULL, 0x0000001f00287202ULL, 0x000fe20000000f00ULL,
0x000000ffff317224ULL, 0x000fc400078e0026ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0022ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0020ULL, 0x000000ffff177224ULL, 0x000fe400078e0012ULL,
0x000000ffff157224ULL, 0x000fe200078e0011ULL, 0x0000000a00117202ULL, 0x000fe20000000f00ULL,
0x000000ffff0e7224ULL, 0x000fe400078e000cULL, 0x000000ffff107224ULL, 0x000fc400078e000bULL,
0x000000ffff327224ULL, 0x000fe400078e0027ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0025ULL,
0x000000ffff267224ULL, 0x000fe400078e001dULL, 0x000000ffff227224ULL, 0x000fe400078e001bULL,
0x000000ffff207224ULL, 0x000fe400078e0019ULL, 0x000000ffff127224ULL, 0x000fc400078e000fULL,
0x000000ffff0b7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0008ULL,
0x0000000400540947ULL, 0x000fec0003800000ULL, 0x018000007c007836ULL, 0x000fca0000000000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000977000067802ULL, 0x000fce0000000f00ULL,
0x000000f000e87944ULL, 0x000fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000007c00057308ULL, 0x000e640000001000ULL, 0xbf80000005007423ULL, 0x002fc8000000007cULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000005007223ULL, 0x000fce0000000005ULL,
0x0000000000077919ULL, 0x000f240000000000ULL, 0x00000002ff057819ULL, 0x010fe40000011607ULL,
0x0000000807097811ULL, 0x040fe400078ff0ffULL, 0x00000010070f7811ULL, 0x040fe400078ff0ffULL,
0x0000001807197811ULL, 0x000fe200078ff0ffULL, 0x0000000000007948ULL, 0x00cfea0003800000ULL,
0x00001f0500057589ULL, 0x000ea800000e0000ULL, 0x00001f0900067589ULL, 0x000ee800000e0000ULL,
0x00001f0f00077589ULL, 0x000f2800000e0000ULL, 0x00001f1900087589ULL, 0x000f6200000e0000ULL,
0x0000000c050c7220ULL, 0x044fe20000410000ULL, 0x0000000b050b7220ULL, 0x040fe20000410000ULL,
0x0000008005807220ULL, 0x040fe20000410000ULL, 0x0000008105817220ULL, 0x040fe20000410000ULL,
0x0000000e050e7220ULL, 0x040fe20000410000ULL, 0x0000000d050d7220ULL, 0x040fe20000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x0000001505157220ULL, 0x040fe20000410000ULL,
0x0000001805187220ULL, 0x040fe20000410000ULL, 0x0000001a051a7220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000002405247220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002c052c7220ULL, 0x000fe20000410000ULL,
0x0000001106117220ULL, 0x048fe20000410000ULL, 0x0000001006107220ULL, 0x040fe20000410000ULL,
0x0000008206827220ULL, 0x040fe20000410000ULL, 0x0000008306837220ULL, 0x040fe20000410000ULL,
0x0000001306137220ULL, 0x040fe20000410000ULL, 0x0000001206127220ULL, 0x040fe20000410000ULL,
0x0000001706177220ULL, 0x040fe20000410000ULL, 0x0000001606167220ULL, 0x040fe20000410000ULL,
0x0000002106217220ULL, 0x040fe20000410000ULL, 0x0000001c061c7220ULL, 0x040fe20000410000ULL,
0x0000002306237220ULL, 0x040fe20000410000ULL, 0x0000002206227220ULL, 0x040fe20000410000ULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x0000002806287220ULL, 0x040fe20000410000ULL,
0x0000002d062d7220ULL, 0x040fe20000410000ULL, 0x0000002e062e7220ULL, 0x000fe20000410000ULL,
0x0000003007307220ULL, 0x050fe20000410000ULL, 0x0000002f072f7220ULL, 0x040fe20000410000ULL,
0x0000003407347220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x040fe20000410000ULL,
0x0000003807387220ULL, 0x040fe20000410000ULL, 0x0000003707377220ULL, 0x040fe20000410000ULL,
0x0000004007407220ULL, 0x040fe20000410000ULL, 0x0000004107417220ULL, 0x040fe20000410000ULL,
0x0000004807487220ULL, 0x040fe20000410000ULL, 0x0000004907497220ULL, 0x040fe20000410000ULL,
0x0000004407447220ULL, 0x040fe20000410000ULL, 0x0000004507457220ULL, 0x040fe20000410000ULL,
0x0000003c073c7220ULL, 0x040fe20000410000ULL, 0x0000003d073d7220ULL, 0x040fe20000410000ULL,
0x0000004c074c7220ULL, 0x040fe20000410000ULL, 0x0000003b073b7220ULL, 0x000fe20000410000ULL,
0x0000003108317220ULL, 0x062fe20000410000ULL, 0x0000003208327220ULL, 0x040fe20000410000ULL,
0x0000003508357220ULL, 0x040fe20000410000ULL, 0x0000003608367220ULL, 0x040fe20000410000ULL,
0x0000003908397220ULL, 0x040fe20000410000ULL, 0x0000003a083a7220ULL, 0x040fe20000410000ULL,
0x0000004208427220ULL, 0x040fe20000410000ULL, 0x0000004308437220ULL, 0x040fe20000410000ULL,
0x0000004a084a7220ULL, 0x040fe20000410000ULL, 0x0000004b084b7220ULL, 0x040fe20000410000ULL,
0x0000004608467220ULL, 0x040fe20000410000ULL, 0x0000004708477220ULL, 0x040fe20000410000ULL,
0x0000003e083e7220ULL, 0x040fe20000410000ULL, 0x0000003f083f7220ULL, 0x040fe20000410000ULL,
0x0000004d084d7220ULL, 0x040fe20000410000ULL, 0x0000004e084e7220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x000020006e957824ULL, 0x000fe200078e0295ULL,
0x0000002a2c0f723eULL, 0x000fe400000000ffULL, 0x000000111010723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000131212723eULL, 0x000fc400000000ffULL,
0x000000828311723eULL, 0x000fe400000000ffULL, 0x000000171613723eULL, 0x000fe400000000ffULL,
0x0000002b2816723eULL, 0x000fe400000000ffULL, 0x0000002d2e17723eULL, 0x000fe400000000ffULL,
0x000000019900780cULL, 0x000fe40003f05270ULL, 0x0000ffff00057812ULL, 0x002fc400078ec0ffULL,
0xfffffff8ff077812ULL, 0x000fe400078ee200ULL, 0x00000003ff057819ULL, 0x000fe40000011605ULL,
0x0000000807087810ULL, 0x000fe20007ffe0ffULL, 0x0000001007097836ULL, 0x000fe20000000000ULL,
0x0000000305057812ULL, 0x000fe200078ec0ffULL, 0x00000018070a7836ULL, 0x000fe40000000000ULL,
0x0000000807197824ULL, 0x000fe200078e00ffULL, 0x00000003091f7819ULL, 0x000fe200000006ffULL,
0x0000000105057824ULL, 0x000fc400078e0200ULL, 0x00000008081b7824ULL, 0x000fe400078e00ffULL,
0x000000080a277824ULL, 0x000fe200078e00ffULL, 0x0000000705067812ULL, 0x040fe200078ec0ffULL,
0x0000000808087824ULL, 0x000fe200078e00ffULL, 0x0000000405057812ULL, 0x000fe200078e3cffULL,
0x0000000809507824ULL, 0x000fe200078e00ffULL, 0x000000030a0a7819ULL, 0x000fe400000006ffULL,
0x0000000705057812ULL, 0x000fe400078ec0ffULL, 0xfffffff819197812ULL, 0x000fc400078ee206ULL,
0xfffffff81b1b7812ULL, 0x000fe400078ee206ULL, 0xfffffff81f1f7812ULL, 0x000fe400078ee206ULL,
0xfffffff827277812ULL, 0x000fe200078ee206ULL, 0x0000000807067824ULL, 0x000fe200078e00ffULL,
0xfffffff80a297812ULL, 0x000fe400078ee205ULL, 0x0000000e0d0a723eULL, 0x000fe400000000ffULL,
0x0000001e200d723eULL, 0x000fe200000000ffULL, 0x00001000721e7824ULL, 0x000fe200078e0295ULL,
0xfffffff806077812ULL, 0x000fc400078ee205ULL, 0xfffffff8081d7812ULL, 0x000fe200078ee205ULL,
0x000000101b067824ULL, 0x100fe200078e021eULL, 0xfffffff850257812ULL, 0x000fe200078ee205ULL,
0x0000001019057824ULL, 0x100fe200078e021eULL, 0x0000000c0b08723eULL, 0x000fe200000000ffULL,
0x000000101d1d7824ULL, 0x100fe200078e021eULL, 0x000000808109723eULL, 0x000fe200000000ffULL,
0x000000101f1f7824ULL, 0x100fe200078e021eULL, 0x00000014150b723eULL, 0x000fe200000000ffULL,
0x0000001025257824ULL, 0x100fe200078e021eULL, 0x000000181a0c723eULL, 0x000fe200000000ffULL,
0x0000001027277824ULL, 0x100fe200078e021eULL, 0x00000024260e723eULL, 0x000fe200000000ffULL,
0x0000000805007844ULL, 0x0003e20000000200ULL, 0x0000001e07077211ULL, 0x000fe200078e20ffULL,
0x0000001029297824ULL, 0x000fe200078e021eULL, 0x000000211c14723eULL, 0x000fc400000000ffULL,
0x000000232215723eULL, 0x000fe200000000ffULL, 0x0000000c07007844ULL, 0x000fe20000000200ULL,
0x000000302f18723eULL, 0x000fe400000000ffULL, 0x000000343319723eULL, 0x000fe200000000ffULL,
0x0000001006007844ULL, 0x0005e20000000200ULL, 0x00000038371a723eULL, 0x000fe400000000ffULL,
0x00000040411b723eULL, 0x000fe200000000ffULL, 0x000000141d007844ULL, 0x000fe20000000200ULL,
0x000000484920723eULL, 0x000fc400000000ffULL, 0x000000444521723eULL, 0x000fe200000000ffULL,
0x000000181f007844ULL, 0x000fe20000000200ULL, 0x0000003c3d22723eULL, 0x000fe400000000ffULL,
0x0000004c3b23723eULL, 0x000fe400000000ffULL, 0x000000313208723eULL, 0x002fe400000000ffULL,
0x000000353609723eULL, 0x000fe200000000ffULL, 0x0000002025007844ULL, 0x000fe20000000200ULL,
0x0000000071067210ULL, 0x004fc40007ffe0ffULL, 0x000000393a0a723eULL, 0x000fe400000000ffULL,
0x00000042430b723eULL, 0x000fe200000000ffULL, 0x0000001006077824ULL, 0x000fe200078e0295ULL,
0x0000004a4b0c723eULL, 0x000fe400000000ffULL, 0x00000046470d723eULL, 0x000fe200000000ffULL,
0x0000000827007844ULL, 0x000fe20000000200ULL, 0x0000003e3f0e723eULL, 0x000fe400000000ffULL,
0x0000004d4e0f723eULL, 0x000fca00000000ffULL, 0x0000000c29007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000007107984ULL, 0x000e680000000c00ULL,
0x00040000072c7984ULL, 0x000ea80000000c00ULL, 0x0008000007347984ULL, 0x000ee80000000c00ULL,
0x000c000007207984ULL, 0x000f280000000c00ULL, 0x0010000007147984ULL, 0x000f680000000c00ULL,
0x0014000007307984ULL, 0x000f280000000c00ULL, 0x0018000007187984ULL, 0x000f280000000c00ULL,
0x001c000007087984ULL, 0x000f620000000c00ULL, 0x200000ff13137230ULL, 0x002fc40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fe40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x200000ff2f2f7230ULL, 0x004fe40000000000ULL,
0x200000ff2e2e7230ULL, 0x000fe40000000000ULL, 0x200000ff2d2d7230ULL, 0x000fc40000000000ULL,
0x200000ff2c2c7230ULL, 0x000fe40000000000ULL, 0x200000ff37377230ULL, 0x008fe40000000000ULL,
0x200000ff36367230ULL, 0x000fe40000000000ULL, 0x200000ff35357230ULL, 0x000fe40000000000ULL,
0x200000ff34347230ULL, 0x000fe40000000000ULL, 0x200000ff23237230ULL, 0x010fc40000000000ULL,
0x200000ff22227230ULL, 0x000fe40000000000ULL, 0x200000ff21217230ULL, 0x000fe40000000000ULL,
0x200000ff20207230ULL, 0x000fe40000000000ULL, 0x0000001713137230ULL, 0x020fe40000000000ULL,
0x0000001612127230ULL, 0x000fe40000000000ULL, 0x0000001511117230ULL, 0x000fc40000000000ULL,
0x0000001410107230ULL, 0x000fe40000000000ULL, 0x000000332f2f7230ULL, 0x000fe40000000000ULL,
0x000000322e2e7230ULL, 0x000fe20000000000ULL, 0x0000001007007388ULL, 0x0003e20000000c00ULL,
0x000000312d2d7230ULL, 0x000fe40000000000ULL, 0x000000302c2c7230ULL, 0x000fe40000000000ULL,
0x0000001b37377230ULL, 0x000fc40000000000ULL, 0x0000001a36367230ULL, 0x000fe20000000000ULL,
0x0004002c07007388ULL, 0x0003e20000000c00ULL, 0x0000001935357230ULL, 0x000fe40000000000ULL,
0x0000001834347230ULL, 0x000fe40000000000ULL, 0x0000000b23237230ULL, 0x000fe40000000000ULL,
0x0000000a22227230ULL, 0x000fe20000000000ULL, 0x0008003407007388ULL, 0x0003e20000000c00ULL,
0x0000000921217230ULL, 0x000fc40000000000ULL, 0x0000000820207230ULL, 0x000fca0000000000ULL,
0x000c002007007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000034006c8947ULL, 0x000fea0003800000ULL, 0x00000400ff107b82ULL, 0x002e620000000800ULL,
0x0000000000097919ULL, 0x000ea20000002600ULL, 0x00000080060b7836ULL, 0x000fe20000000000ULL,
0x000000c0060d7810ULL, 0x000fe20007ffe0ffULL, 0x00000000000a7919ULL, 0x000ea80000002700ULL,
0x00009600ff057b82ULL, 0x000e620000000800ULL, 0x0000000007147984ULL, 0x000ee80000000c00ULL,
0x0004000007187984ULL, 0x000ee60000000c00ULL, 0x00009a00ff2c7b82ULL, 0x000f220000000a00ULL,
0x0008000007247984ULL, 0x000ee80000000c00ULL, 0x000c000007287984ULL, 0x000ae20000000c00ULL,
0x0000000510087224ULL, 0x002fca00078e02ffULL, 0x0000000f08057811ULL, 0x040fe200078e10ffULL,
0x0000009908087224ULL, 0x080fe400078e02ffULL, 0x000000100a107224ULL, 0x004fe200078e0209ULL,
0xfffffff005237812ULL, 0x000fe200078ec0ffULL, 0x0000004006097836ULL, 0x000fe40000000000ULL,
0x00000099101f7224ULL, 0x000fe400078e02ffULL, 0x0000008008117824ULL, 0x000fe400078e0223ULL,
0x000000011f0c7824ULL, 0x000fc400078e0204ULL, 0x0000008008087824ULL, 0x000fca00078e0211ULL,
0x0000007f08087810ULL, 0x000fc80007ffe0ffULL, 0xffffff80081d7812ULL, 0x000fc800078ec0ffULL,
0x0000002c1d057210ULL, 0x010fc80007f1e0ffULL, 0x000000050c047211ULL, 0x000fe200078268ffULL,
0x000000ffff057224ULL, 0x000fe200000e062dULL, 0x0000000172ff7812ULL, 0x000fc8000780f898ULL,
0x000000050c057211ULL, 0x000fe400008f6cffULL, 0x0000002c231c7210ULL, 0x000fe20007f3e0ffULL,
0x000010006e047825ULL, 0x000fc800078e0004ULL, 0x000000ffff137224ULL, 0x000fe400008e062dULL,
0x0000001006067825ULL, 0x020fc800078e0004ULL, 0x0000001009087825ULL, 0x000fc800078e0004ULL,
0x000000100b0a7825ULL, 0x000fc800078e0004ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x0000000000400947ULL, 0x008fec0003800000ULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x000000800c0d7824ULL, 0x000fc600078e00ffULL,
0x000000700e0f7812ULL, 0x000fe400078ec0ffULL, 0x0000000c12207812ULL, 0x000fe400078ec0ffULL,
0x0000002c0d0e7210ULL, 0x000fe40007ebe011ULL, 0x00000019ff127819ULL, 0x000fe4000001160cULL,
0x0000001c0f0d7210ULL, 0x000fe40007a3e00dULL, 0x0000000e200e7210ULL, 0x000fc40007c7e00fULL,
0x0000002d120f7210ULL, 0x000fe40002fec4ffULL, 0x0000000d200c7210ULL, 0x000fe40007fbe0ffULL,
0x00000013ff127210ULL, 0x000fe40000fe4412ULL, 0x0000000fff0f7210ULL, 0x000fc60001fe84ffULL,
0x000000ffff0d7224ULL, 0x000fca00028e0612ULL, 0x0000005d0c007986ULL, 0x0003e8000c101906ULL,
0x0000007c0e007986ULL, 0x0003e4000c101906ULL, 0x000000ff0000720cULL, 0x000fe20000705670ULL,
0x0000001406007986ULL, 0x0005e8000c101d06ULL, 0x0000001808007986ULL, 0x0005e8000c101d06ULL,
0x000000240a007986ULL, 0x0005e8000c101d06ULL, 0x0000002804007986ULL, 0x0005e2000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000000700947ULL, 0x000fea0003800000ULL,
0x00009a00ff047b82ULL, 0x004ea20000000a00ULL, 0xffffffff99077810ULL, 0x000fe20007ffe0ffULL,
0x0000000410047825ULL, 0x004fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000000ff00798fULL, 0x000fe20002000000ULL,
0x00000007040479a8ULL, 0x00052200099ee1c6ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000000ff00798fULL, 0x000fe20002000000ULL,
0x00000000000579c3ULL, 0x000ee20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000070400720cULL, 0x010fc80003f05270ULL, 0x00000001ff047807ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x008fd20008000004ULL, 0x00000004ff007988ULL, 0x0007e60008000004ULL,
0x0000000000047919ULL, 0x00cea20000008800ULL, 0x0000040000217802ULL, 0x000fe20000000f00ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000065404217816ULL, 0x004fca0000000021ULL, 0x0000000021047984ULL, 0x000ea40000000000ULL,
0x000000ff0400720cULL, 0x004fda0003f05270ULL, 0x0000002c00f08947ULL, 0x000fea0003800000ULL,
0x000000ff9800720cULL, 0x000fda0003f05270ULL, 0x0000000800940947ULL, 0x000fea0003800000ULL,
0x000000ff9900720cULL, 0x000fda0003f05270ULL, 0x00000000006c8947ULL, 0x000fea0003800000ULL,
0x0000001000057824ULL, 0x000fe200078e00ffULL, 0x00000001ff067819ULL, 0x000fe40000011600ULL,
0x0000001c1f047211ULL, 0x000fe400078038ffULL, 0x0000007005077812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fe400078ec0ffULL, 0x000000131f057211ULL, 0x000fe400000f3cffULL,
0x0000000406047210ULL, 0x000fc8000791e007ULL, 0x00000005ff057210ULL, 0x000fca00007e24ffULL,
0x0000000604087981ULL, 0x000528000c1e1900ULL, 0x0000800604097981ULL, 0x000522000c1e1900ULL,
0x000000029900780cULL, 0x000fda0003f05270ULL, 0x00000000003c8947ULL, 0x004fea0003800000ULL,
0x00010006040b7981ULL, 0x000522000c1e1900ULL, 0x000000049900780cULL, 0x000fda0003f06070ULL,
0x0000000000308947ULL, 0x004fea0003800000ULL, 0x00018006040d7981ULL, 0x002322000c1e1900ULL,
0x000000049900780cULL, 0x000fda0003f05270ULL, 0x0000000000248947ULL, 0x002fea0003800000ULL,
0x00020006040f7981ULL, 0x000322000c1e1900ULL, 0x000000069900780cULL, 0x000fda0003f06070ULL,
0x0000000000188947ULL, 0x002fea0003800000ULL, 0x0002800604137981ULL, 0x000322000c1e1900ULL,
0x000000069900780cULL, 0x000fda0003f05270ULL, 0x00000000000c8947ULL, 0x002fea0003800000ULL,
0x000000089900780cULL, 0x000fe20003f06070ULL, 0x0003000604157981ULL, 0x000318000c1e1900ULL,
0x0003800604170981ULL, 0x000324000c1e1900ULL, 0x0000000799047836ULL, 0x002fca0000000000ULL,
0x00000003ff067819ULL, 0x000fc80000011604ULL, 0x000000ff0600720cULL, 0x000fda0003f05270ULL,
0x0000000400f48947ULL, 0x000fea0003800000ULL, 0x000000231f197211ULL, 0x040fe200078038ffULL,
0x000000ffff077224ULL, 0x010fe200078e0008ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x0000003f00057c82ULL, 0x000fe20008000000ULL, 0x0000002c19197210ULL, 0x000fe40007f3e0ffULL,
0x000000ff1f0a7211ULL, 0x000fe400000f3cffULL, 0x0000078019197810ULL, 0x000fc80007f5e0ffULL,
0x0000000aff0a7210ULL, 0x000fd200017e242dULL, 0x0000000499007c0cULL, 0x000fe2000bf23070ULL,
0x0000000105057890ULL, 0x000fcc000fffe03fULL, 0x0000000506007c0cULL, 0x000fcc000bf03070ULL,
0x0000000400b41947ULL, 0x012fee0003800000ULL, 0x0000000804087890ULL, 0x000fe2000fffe03fULL,
0x0000000708087209ULL, 0x000fca0007810000ULL, 0x0000000899007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000419047210ULL, 0x000fc80007f3e0ffULL,
0x0000000aff057210ULL, 0x000fca0000ffe4ffULL, 0xfffc800604077981ULL, 0x000328000c1e1900ULL,
0x0000000104087890ULL, 0x000fcc000fffe03fULL, 0x0000000899007c0cULL, 0x000fda000bf23070ULL,
0x00000004007c1947ULL, 0x000fea0003800000ULL, 0x0000000904087890ULL, 0x000fe2000fffe03fULL,
0x0000000908087209ULL, 0x000fca0007810000ULL, 0x0000000899007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000419047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffd000604097981ULL, 0x000326000c1e1900ULL,
0x0000000204087890ULL, 0x000fcc000fffe03fULL, 0x0000000899007c0cULL, 0x000fda000bf23070ULL,
0x0000000400441947ULL, 0x000fea0003800000ULL, 0x0000000a04087890ULL, 0x000fe2000fffe03fULL,
0x0000000b08087209ULL, 0x000fca0007810000ULL, 0x0000000899007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000419047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffd8006040b7981ULL, 0x000326000c1e1900ULL,
0x0000000304087890ULL, 0x000fcc000fffe03fULL, 0x0000000899007c0cULL, 0x000fda000bf23070ULL,
0x00000004000c1947ULL, 0x000fea0003800000ULL, 0x0000000b04087890ULL, 0x000fe2000fffe03fULL,
0x0000000d08087209ULL, 0x000fca0007810000ULL, 0x0000000899007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000000400047819ULL, 0x002fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe40000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000419047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffe0006040d7981ULL, 0x000326000c1e1900ULL,
0x0000000404087890ULL, 0x000fcc000fffe03fULL, 0x0000000899007c0cULL, 0x000fda000bf23070ULL,
0x0000000000d41947ULL, 0x000fea0003800000ULL, 0x0000000c04087890ULL, 0x000fe2000fffe03fULL,
0x0000000f08087209ULL, 0x000fca0007810000ULL, 0x0000000899007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000419047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffe8006040f7981ULL, 0x000326000c1e1900ULL,
0x0000000504087890ULL, 0x000fcc000fffe03fULL, 0x0000000899007c0cULL, 0x000fda000bf23070ULL,
0x00000000009c1947ULL, 0x000fea0003800000ULL, 0x0000000d04087890ULL, 0x000fe2000fffe03fULL,
0x0000001308087209ULL, 0x000fca0007810000ULL, 0x0000000899007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000419047210ULL, 0x000fc80007f3e0ffULL,
0x0000000aff057210ULL, 0x000fca0000ffe4ffULL, 0xffff000604137981ULL, 0x000328000c1e1900ULL,
0x0000000604087890ULL, 0x000fcc000fffe03fULL, 0x0000000899007c0cULL, 0x000fda000bf23070ULL,
0x0000000000641947ULL, 0x000fea0003800000ULL, 0x0000000e04087890ULL, 0x000fe2000fffe03fULL,
0x0000001508087209ULL, 0x000fca0007810000ULL, 0x0000000899007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000419047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xffff800604157981ULL, 0x000326000c1e1900ULL,
0x0000000704087890ULL, 0x000fcc000fffe03fULL, 0x0000000899007c0cULL, 0x000fda000bf23070ULL,
0x00000000002c1947ULL, 0x000fea0003800000ULL, 0x0000000f04087890ULL, 0x000fe2000fffe03fULL,
0x0000001708087209ULL, 0x000fca0007810000ULL, 0x0000000899007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000419047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0x0000000604177981ULL, 0x000326000c1e1900ULL,
0x0000040019197810ULL, 0x000fe20007f3e0ffULL, 0x0000000804047890ULL, 0x000fc6000fffe03fULL,
0x0000000aff0a7210ULL, 0x000fe20000ffe4ffULL, 0xfffffff8002c8947ULL, 0x000ff0000383ffffULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x0000001000047824ULL, 0x006fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000002105057210ULL, 0x000fca0007ffe004ULL,
0x0000000805007388ULL, 0x0103e40000000800ULL, 0x00009a00ff287b82ULL, 0x000ea20000000a00ULL,
0x000000070000780cULL, 0x000fe20003f04070ULL, 0x0000100098207824ULL, 0x000fe200078e00ffULL,
0x00000002ff067819ULL, 0x000fe20000011698ULL, 0x0000001000267824ULL, 0x000fe200078e00ffULL,
0x0000001f72177210ULL, 0x000fe20007ffe0ffULL, 0x00000040000b7836ULL, 0x000fe20000000000ULL,
0x0000000106067812ULL, 0x000fe200078ec0ffULL, 0x00000060000d7836ULL, 0x002fe20000000000ULL,
0x0000100020207812ULL, 0x000fe200078ee2ffULL, 0x00000080000f7836ULL, 0x000fe20000000000ULL,
0x00000001ff257819ULL, 0x000fe20000011600ULL, 0x000000c000137836ULL, 0x000fe20000000000ULL,
0x0000007026267812ULL, 0x000fe200078ec0ffULL, 0x0000020072058824ULL, 0x140fe200078e0221ULL,
0x0000000c25257812ULL, 0x000fe200078ec0ffULL, 0x0000020072098824ULL, 0x000fe200078e0221ULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x000001006e078824ULL, 0x040fe200078e0205ULL,
0x0000002125277210ULL, 0x000fe20007ffe026ULL, 0x000001006e098824ULL, 0x000fe200078e0209ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000281d1c7210ULL, 0x004fe20007f3e0ffULL,
0x00000080061b8824ULL, 0x040fe200078e0207ULL, 0x00000009062b8211ULL, 0x000fe200078e38ffULL,
0x0000040098077824ULL, 0x000fe200078e00ffULL, 0x0000002000097810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e0629ULL, 0x0000002811227210ULL, 0x000fe20007f3e0ffULL,
0x0000400072117824ULL, 0x000fe200078e0221ULL, 0x0000100007077812ULL, 0x000fe200078ec0ffULL,
0x0000200017047825ULL, 0x040fe200078e001cULL, 0x0000002823237210ULL, 0x000fe20007f7e0ffULL,
0x0000000027277984ULL, 0x000e620000000800ULL, 0x00000029ff287210ULL, 0x000fe20000ffe4ffULL,
0x000020006e247824ULL, 0x000fe200078e0211ULL, 0x0000002004047210ULL, 0x000fe20007f5e0ffULL,
0x000000e000157836ULL, 0x000fe20000000000ULL, 0x000000a000117810ULL, 0x000fe20007ffe0ffULL,
0x0000000124077824ULL, 0x000fe200078e0207ULL, 0x0000002217148211ULL, 0x040fe200078238ffULL,
0x000000ffff057224ULL, 0x000fe200010e0605ULL, 0x0000002317168211ULL, 0x000fe200078438ffULL,
0x0000001000197824ULL, 0x000fe200078e0207ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000001009067825ULL, 0x000fe200078e0004ULL, 0x00000000003a7805ULL, 0x000fc4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x000000100b087825ULL, 0x100fe200078e0004ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x000000100d0a7825ULL, 0x000fe200078e0004ULL, 0x0000000000407805ULL, 0x000fc4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x000000100f0c7825ULL, 0x100fe200078e0004ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x00000010110e7825ULL, 0x000fe200078e0004ULL, 0x0000000000467805ULL, 0x000fc4000001ff00ULL,
0x0000000000487805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000001013107825ULL, 0x100fe200078e0004ULL, 0x0000000000587805ULL, 0x000fe4000001ff00ULL,
0x00000000005a7805ULL, 0x000fe4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000001015127825ULL, 0x000fe200078e0004ULL, 0x0000002817158211ULL, 0x000fc400008f3cffULL,
0x00000000004e7805ULL, 0x000fe4000001ff00ULL, 0x000000997200720cULL, 0x000fe20003f26070ULL,
0x000000ffff297224ULL, 0x000fe200018e0629ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x0000001000047825ULL, 0x040fe200078e0004ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x0000000000607805ULL, 0x000fe4000001ff00ULL, 0x0000002917178211ULL, 0x000fe200010f3cffULL,
0x00000010001b8824ULL, 0x000fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000004197faeULL, 0x0005e2000b901c46ULL, 0x000000ffff5d7224ULL, 0x000fe200078e00ffULL,
0x0000000000527805ULL, 0x000fc4000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0038000006197faeULL, 0x0007e2000b901c46ULL, 0x0000000000547805ULL, 0x000fe4000001ff00ULL,
0x0000000000647805ULL, 0x000fe4000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0058000008197faeULL, 0x0009e2000b901c46ULL, 0x0000000000667805ULL, 0x000fe4000001ff00ULL,
0x0000000000687805ULL, 0x000fe2000001ff00ULL, 0x007800000a197faeULL, 0x0003e2000b901c46ULL,
0x0000001000048825ULL, 0x004fc600078e0014ULL, 0x009800000c197faeULL, 0x0005e2000b901c46ULL,
0x0000001000068825ULL, 0x008fc600078e0016ULL, 0x00b800000e197faeULL, 0x0005e2000b901c46ULL,
0x0000001000098824ULL, 0x010fe200078e022bULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x00d8000010197faeULL, 0x0005e8000b901c46ULL, 0x00f8000012197faeULL, 0x0005e8000b901c46ULL,
0x08580000041b8faeULL, 0x0005e8000b901c46ULL, 0x0818000006098faeULL, 0x0005e8000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001000001947ULL, 0x002fea0003800000ULL,
0x00000003ff077819ULL, 0x004fe20000011600ULL, 0x00000200727b7824ULL, 0x000fe200078e0221ULL,
0xfffffff8ff067812ULL, 0x000fe200078ee200ULL, 0x000000ffff6b7224ULL, 0x000fe200078e00ffULL,
0x0000000307057812ULL, 0x000fe200078ec0ffULL, 0x000000ffff187224ULL, 0x000fe200078e0072ULL,
0x0000000400047810ULL, 0x000fe20007ffe007ULL, 0x0000001006087836ULL, 0x000fe20000000000ULL,
0x0000000806077810ULL, 0x000fe20007ffe0ffULL, 0x0000001806097836ULL, 0x000fe20000000000ULL,
0x0000000704047812ULL, 0x000fe200078ec0ffULL, 0x00000008066d7824ULL, 0x000fe200078e00ffULL,
0x0000000005057210ULL, 0x000fe20007ffe0ffULL, 0x00000008070b7824ULL, 0x000fe200078e00ffULL,
0x00000002ff797819ULL, 0x000fe20000011600ULL, 0x00000008086f7824ULL, 0x000fe200078e00ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee204ULL, 0x00000008090d7824ULL, 0x040fe200078e00ffULL,
0xfffffff80b6c7812ULL, 0x000fe200078ee204ULL, 0x0000000806747824ULL, 0x000fe200078e00ffULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee204ULL, 0x0000000809067824ULL, 0x000fe200078e00ffULL,
0xfffffff80d707812ULL, 0x000fe200078ee204ULL, 0x0000000807047824ULL, 0x000fe200078e00ffULL,
0x0000000705057812ULL, 0x000fe200078ec0ffULL, 0x00000008797a7836ULL, 0x000fe20000000000ULL,
0x0000000308087819ULL, 0x000fe200000006ffULL, 0x00000010797c7836ULL, 0x000fe20000000000ULL,
0xfffffff804737812ULL, 0x000fe200078ee205ULL, 0x0000001879767836ULL, 0x000fe20000000000ULL,
0xfffffff874747812ULL, 0x000fc400078ee205ULL, 0xfffffff808757812ULL, 0x000fe400078ee205ULL,
0xfffffff806777812ULL, 0x000fe400078ee205ULL, 0x0000007b6e7b7211ULL, 0x000fce00078e40ffULL,
0x0000000218787836ULL, 0x000fca0000000000ULL, 0x000000997800720cULL, 0x000fda0003f06070ULL,
0x0000000000cc0947ULL, 0x000fea0003800000ULL, 0x000000070000780cULL, 0x000fe20003f44070ULL,
0x0000002000097836ULL, 0x000fe20000000000ULL, 0x00000001ff067819ULL, 0x000fe20000011678ULL,
0x00000040000b7836ULL, 0x000fe20000000000ULL, 0x000000781f177210ULL, 0x000fe20007ffe0ffULL,
0x00000060000d7836ULL, 0x000fe20000000000ULL, 0x00000001061a7812ULL, 0x000fe200078ec0ffULL,
0x0000080078067824ULL, 0x000fe400078e00ffULL, 0x0000200017047825ULL, 0x000fc800078e001cULL,
0x000002007207a824ULL, 0x000fe200078e0221ULL, 0x0000002004047210ULL, 0x000fe20007f1e0ffULL,
0x00000080000f7836ULL, 0x000fe20000000000ULL, 0x000000231716a211ULL, 0x040fe200078238ffULL,
0x000001006e7ba824ULL, 0x000fe200078e0207ULL, 0x0000100006077812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x000000221714a211ULL, 0x000fe200078038ffULL,
0x000000a000117836ULL, 0x000fe20000000000ULL, 0x0000000724077210ULL, 0x000fe20007ffe0ffULL,
0x000000c000137836ULL, 0x000fe20000000000ULL, 0x0000007b1a1ba211ULL, 0x0c0fe200078e38ffULL,
0x000000e000157836ULL, 0x000fe20000000000ULL, 0x0000007b1a7da211ULL, 0x000fe200078e38ffULL,
0x0000001000197824ULL, 0x000fc400078e0207ULL, 0x0000001000067825ULL, 0x000fc800078e0004ULL,
0x0000001009087825ULL, 0x100fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000006197faeULL, 0x0003e6000b901c46ULL, 0x000000100b0a7825ULL, 0x100fe200078e0004ULL,
0x0038000008197faeULL, 0x0003e6000b901c46ULL, 0x000000100d0c7825ULL, 0x100fe200078e0004ULL,
0x005800000a197faeULL, 0x0003e6000b901c46ULL, 0x000000100f0e7825ULL, 0x100fe200078e0004ULL,
0x007800000c197faeULL, 0x0003e6000b901c46ULL, 0x0000001011107825ULL, 0x100fe200078e0004ULL,
0x009800000e197faeULL, 0x0003e6000b901c46ULL, 0x0000001013127825ULL, 0x100fe200078e0004ULL,
0x00b8000010197faeULL, 0x0003e6000b901c46ULL, 0x0000001015047825ULL, 0x000fe200078e0004ULL,
0x000000281715a211ULL, 0x040fe200000f3cffULL, 0x00d8000012197faeULL, 0x0003e2000b901c46ULL,
0x000000291717a211ULL, 0x000fe200008f3cffULL, 0x00000010001ba824ULL, 0x000fc400078e021bULL,
0x000000100014a825ULL, 0x040fe200078e0014ULL, 0x00f8000004197faeULL, 0x0003e6000b901c46ULL,
0x000000100016a825ULL, 0x040fe200078e0016ULL, 0x08580000141bafaeULL, 0x0003e6000b901c46ULL,
0x00000010007da824ULL, 0x000fca00078e027dULL, 0x08180000167dafaeULL, 0x0003e4000b901c46ULL,
0x000000ffff067224ULL, 0x002fe200078e0018ULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x0000080006047824ULL, 0x000fca00078e00ffULL, 0x0000100004057812ULL, 0x000fe400078ec0ffULL,
0x0000000606047819ULL, 0x000fe400000006ffULL, 0x0000018024187810ULL, 0x000fe40007ffe005ULL,
0x0000008004047812ULL, 0x000fe400078ec0ffULL, 0x000000186c087211ULL, 0x000fe200078e20ffULL,
0x000000106d107824ULL, 0x000fe200078e0218ULL, 0x0000007b26047210ULL, 0x000fe20007ffe004ULL,
0x0000001074147824ULL, 0x000fc400078e0218ULL, 0x00000010707e7824ULL, 0x000fe400078e0218ULL,
0x00000001251a7824ULL, 0x000fe200078e0204ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x000000106f7d7824ULL, 0x100fe400078e0218ULL,
0x0000001077197824ULL, 0x100fe200078e0218ULL, 0x008180001a8e7984ULL, 0x000ea20000000800ULL,
0x0000001073047824ULL, 0x100fe400078e0218ULL, 0x00000010750c7824ULL, 0x000fe200078e0218ULL,
0x000000001414783bULL, 0x000ee80000000200ULL, 0x008580001a9b7984ULL, 0x000f280000000800ULL,
0x000000001918783bULL, 0x000fe80000000200ULL, 0x000000000404783bULL, 0x000f680000000200ULL,
0x000000000808783bULL, 0x000f280000000200ULL, 0x000000000c0c783bULL, 0x000f220000000200ULL,
0x20000010ff887230ULL, 0x002fc40000004100ULL, 0x30000010ff877230ULL, 0x000fe40000004100ULL,
0x0000008e27107221ULL, 0x004fe20000010100ULL, 0x20000011ff8a7230ULL, 0x000fe40000004100ULL,
0x30000011ff897230ULL, 0x000fe40000004100ULL, 0x3fb8aa3b10937820ULL, 0x000fe20000410000ULL,
0x20000012ff8c7230ULL, 0x000fe40000004100ULL, 0x30000012ff8e7230ULL, 0x000fe20000004100ULL,
0x0000009300987308ULL, 0x000f220000000800ULL, 0x20000013ff8b7230ULL, 0x000fc40000004100ULL,
0x30000013ff907230ULL, 0x000fe40000004100ULL, 0x000000007e10783bULL, 0x0003e20000000200ULL,
0x20000014ff807230ULL, 0x008fe40000004100ULL, 0x30000014ff7f7230ULL, 0x000fe40000004100ULL,
0x20000015ff827230ULL, 0x000fe40000004100ULL, 0x30000015ff817230ULL, 0x000fe40000004100ULL,
0x20000016ff847230ULL, 0x000fc40000004100ULL, 0x0000009b98ab7220ULL, 0x010fe20000410000ULL,
0x30000016ff837230ULL, 0x000fe40000004100ULL, 0x20000017ff867230ULL, 0x000fe40000004100ULL,
0x0000006aab6a7221ULL, 0x000fe20000010000ULL, 0x30000017ff857230ULL, 0x000fe20000004100ULL,
0x00001f79aba87589ULL, 0x000ea200000e0000ULL, 0x20000005ff8d7230ULL, 0x020fe40000004100ULL,
0x30000005ff927230ULL, 0x000fe20000004100ULL, 0x000000007d14783bULL, 0x0007220000000200ULL,
0x20000007ff8f7230ULL, 0x000fc40000004100ULL, 0x30000007ff947230ULL, 0x000fe20000004100ULL,
0x00001f7aabaa7589ULL, 0x000fe200000e0000ULL, 0x20000009ff917230ULL, 0x000fe40000004100ULL,
0x30000009ff7e7230ULL, 0x002fe40000004100ULL, 0x2000000bff937230ULL, 0x000fe40000004100ULL,
0x3000000bff967230ULL, 0x000fe40000004100ULL, 0x2000000dff9b7230ULL, 0x000fc40000004100ULL,
0x3000000dff987230ULL, 0x000fe40000004100ULL, 0x2000000fff9d7230ULL, 0x000fe40000004100ULL,
0x3000000fff9a7230ULL, 0x000fe40000004100ULL, 0x000000a880697223ULL, 0x084fe20000010069ULL,
0x20000013ffa97230ULL, 0x000fe40000004100ULL, 0x000000a87f687223ULL, 0x000fe20000010068ULL,
0x30000013ffa67230ULL, 0x000fc40000004100ULL, 0x000000a882677223ULL, 0x080fe20000010067ULL,
0x00001f7cab137589ULL, 0x000fe200000e0000ULL, 0x20000019ffa37230ULL, 0x000fe40000004100ULL,
0x000000a881667223ULL, 0x080fe20000010066ULL, 0x30000019ffa07230ULL, 0x000fe20000004100ULL,
0x00001f76abab7589ULL, 0x000e6200000e0000ULL, 0x2000001bffa57230ULL, 0x000fe40000004100ULL,
0x000000a884657223ULL, 0x000fe20000010065ULL, 0x3000001bffa27230ULL, 0x000fc40000004100ULL,
0x000000a883647223ULL, 0x080fe20000010064ULL, 0x20000011ffa77230ULL, 0x000fe40000004100ULL,
0x000000a886637223ULL, 0x080fe20000010063ULL, 0x30000011ffa47230ULL, 0x000fe40000004100ULL,
0x000000a885627223ULL, 0x080fe20000010062ULL, 0x20000004ff7d7230ULL, 0x008fe40000004100ULL,
0x000000a888617223ULL, 0x000fe20000010061ULL, 0x20000017ffa17230ULL, 0x010fc40000004100ULL,
0x000000a887607223ULL, 0x080fe20000010060ULL, 0x30000017ff9e7230ULL, 0x000fe40000004100ULL,
0x000000a88a5f7223ULL, 0x080fe2000001005fULL, 0x20000018ff177230ULL, 0x000fe40000004100ULL,
0x000000a8895e7223ULL, 0x080fe2000001005eULL, 0x30000018ff187230ULL, 0x000fe40000004100ULL,
0x000000a88c5d7223ULL, 0x000fe2000001005dULL, 0x20000015ff9f7230ULL, 0x000fc40000004100ULL,
0x000000a88e5b7223ULL, 0x080fe2000001005bULL, 0x30000015ff9c7230ULL, 0x000fe40000004100ULL,
0x000000a88b5a7223ULL, 0x080fe2000001005aULL, 0x20000006ff057230ULL, 0x000fe40000004100ULL,
0x000000ab18377223ULL, 0x002fe20000010037ULL, 0x0000007800187202ULL, 0x000fe20000000f00ULL,
0x20000008ff077230ULL, 0x000fe40000004100ULL, 0x000000a890597223ULL, 0x000fe20000010059ULL,
0x2000000aff097230ULL, 0x000fe20000004100ULL, 0x000000991800720cULL, 0x000fe20003f06070ULL,
0x2000000cff0b7230ULL, 0x000fc40000004100ULL, 0x000000aa7d587223ULL, 0x080fe20000010058ULL,
0x2000000eff0d7230ULL, 0x000fe40000004100ULL, 0x000000aa8d567223ULL, 0x080fe20000010056ULL,
0x20000014ff0f7230ULL, 0x000fe40000004100ULL, 0x000000aa92557223ULL, 0x080fe20000010055ULL,
0x20000016ff157230ULL, 0x000fe40000004100ULL, 0x000000aa05547223ULL, 0x000fe20000010054ULL,
0x2000001aff197230ULL, 0x000fc40000004100ULL, 0x000000aa8f527223ULL, 0x080fe20000010052ULL,
0x20000010ff1b7230ULL, 0x000fe40000004100ULL, 0x000000aa94517223ULL, 0x080fe20000010051ULL,
0x20000012ff117230ULL, 0x000fe40000004100ULL, 0x000000aa07507223ULL, 0x080fe20000010050ULL,
0x30000004ff047230ULL, 0x000fe40000004100ULL, 0x000000aa914e7223ULL, 0x000fe2000001004eULL,
0x30000006ff067230ULL, 0x000fc40000004100ULL, 0x000000aa7e4d7223ULL, 0x080fe2000001004dULL,
0x30000008ff087230ULL, 0x000fe40000004100ULL, 0x000000aa04577223ULL, 0x080fe20000010057ULL,
0x3000000aff0a7230ULL, 0x000fe40000004100ULL, 0x000000aa06537223ULL, 0x080fe20000010053ULL,
0x3000000cff0c7230ULL, 0x000fe40000004100ULL, 0x000000aa084f7223ULL, 0x000fe2000001004fULL,
0x3000000eff0e7230ULL, 0x000fc40000004100ULL, 0x000000aa094c7223ULL, 0x080fe2000001004cULL,
0x30000014ff147230ULL, 0x000fe40000004100ULL, 0x000000aa0a4b7223ULL, 0x080fe2000001004bULL,
0x30000016ff167230ULL, 0x000fe40000004100ULL, 0x000000aa934a7223ULL, 0x080fe2000001004aULL,
0x3000001aff1a7230ULL, 0x000fe40000004100ULL, 0x000000aa96497223ULL, 0x000fe20000010049ULL,
0x30000010ff107230ULL, 0x000fc40000004100ULL, 0x000000130b487223ULL, 0x080fe20000010048ULL,
0x30000012ff127230ULL, 0x000fe40000004100ULL, 0x000000130c477223ULL, 0x080fe20000010047ULL,
0x000000139b467223ULL, 0x080fe20000010046ULL, 0x0000001398457223ULL, 0x080fe20000010045ULL,
0x000000130d447223ULL, 0x080fe20000010044ULL, 0x000000130e437223ULL, 0x080fe20000010043ULL,
0x000000139d427223ULL, 0x080fe20000010042ULL, 0x000000139a417223ULL, 0x080fe20000010041ULL,
0x000000130f407223ULL, 0x080fe20000010040ULL, 0x00000013143f7223ULL, 0x080fe2000001003fULL,
0x000000139f3e7223ULL, 0x080fe2000001003eULL, 0x000000139c3d7223ULL, 0x080fe2000001003dULL,
0x00000013153c7223ULL, 0x080fe2000001003cULL, 0x00000013163b7223ULL, 0x080fe2000001003bULL,
0x00000013a13a7223ULL, 0x080fe2000001003aULL, 0x000000139e397223ULL, 0x000fe20000010039ULL,
0x000000ab17387223ULL, 0x080fe20000010038ULL, 0x000000aba3367223ULL, 0x080fe20000010036ULL,
0x000000aba0357223ULL, 0x080fe20000010035ULL, 0x000000ab19347223ULL, 0x080fe20000010034ULL,
0x000000ab1a337223ULL, 0x080fe20000010033ULL, 0x000000aba5327223ULL, 0x080fe20000010032ULL,
0x000000aba2317223ULL, 0x080fe20000010031ULL, 0x000000ab1b307223ULL, 0x080fe20000010030ULL,
0x000000ab102f7223ULL, 0x080fe2000001002fULL, 0x000000aba72e7223ULL, 0x080fe2000001002eULL,
0x000000aba42d7223ULL, 0x080fe2000001002dULL, 0x000000ab112c7223ULL, 0x080fe2000001002cULL,
0x000000ab122b7223ULL, 0x080fe2000001002bULL, 0x000000aba92a7223ULL, 0x080fe2000001002aULL,
0x000000aba66b7223ULL, 0x000fe2000001006bULL, 0xfffffff000888947ULL, 0x000fec000383ffffULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x000000ff6e00720cULL, 0x000fe20003f05270ULL,
0x0000001000047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe20000011600ULL,
0x0000898021007836ULL, 0x000fc60000000000ULL, 0x0000007004077812ULL, 0x000fe400078ec0ffULL,
0x0000000c05087812ULL, 0x000fca00078ec0ffULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x0000008072217824ULL, 0x000fe400078e0221ULL,
0x0000001004057824ULL, 0x002fe200078e00ffULL, 0x00000001ff067819ULL, 0x000fc80000011604ULL,
0x0000007005047812ULL, 0x000fe400078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ec0ffULL,
0x0000002106217210ULL, 0x000fca0007ffe004ULL, 0x0089806a21007388ULL, 0x0003e40000000800ULL,
0x0000000008007210ULL, 0x000fe20007ffe007ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000000047984ULL, 0x000ea80000000800ULL, 0x0000800000057984ULL, 0x000ee20000000800ULL,
0x00000004ff047221ULL, 0x004fc80000010000ULL, 0x0000000504047221ULL, 0x008fca0000010000ULL,
0x0180000004057810ULL, 0x000fc80007ffe0ffULL, 0x7f80000005057812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0500780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff7c7224ULL, 0x000fe200078e0004ULL,
0x0000cd6000067802ULL, 0x000fce0000000f00ULL, 0x000000bc006c7944ULL, 0x002fea0003c00000ULL,
0x000000ffff057224ULL, 0x00cfe200078e0000ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000400057308ULL, 0x000ea40000001000ULL, 0xbf80000004007423ULL, 0x004fc80000000005ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000005057223ULL, 0x000fce0000000005ULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x00000002ff047819ULL, 0x004fe40000011600ULL,
0x0000000800087811ULL, 0x040fe400078ff0ffULL, 0x00000010000a7811ULL, 0x040fe200078ff0ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0405047589ULL, 0x000ea200000e0000ULL,
0x0000001800167811ULL, 0x000fc600078ff0ffULL, 0x00001f08050d7589ULL, 0x00072800000e0000ULL,
0x00001f0a05157589ULL, 0x000be800000e0000ULL, 0x00001f1605167589ULL, 0x000f2200000e0000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000006904697220ULL, 0x044fe20000410000ULL,
0x0000006804687220ULL, 0x040fe20000410000ULL, 0x0000006704677220ULL, 0x040fe20000410000ULL,
0x0000006604667220ULL, 0x040fe20000410000ULL, 0x0000006504067220ULL, 0x040fe20000410000ULL,
0x0000006404077220ULL, 0x040fe20000410000ULL, 0x0000006304637220ULL, 0x040fe20000410000ULL,
0x0000006204627220ULL, 0x040fe20000410000ULL, 0x0000006104087220ULL, 0x048fe20000410000ULL,
0x0000006004097220ULL, 0x040fe20000410000ULL, 0x0000005f045f7220ULL, 0x040fe20000410000ULL,
0x0000005e045e7220ULL, 0x040fe20000410000ULL, 0x0000005d040a7220ULL, 0x062fe20000410000ULL,
0x0000005b045b7220ULL, 0x040fe20000410000ULL, 0x0000005a040b7220ULL, 0x040fe20000410000ULL,
0x00000059040c7220ULL, 0x000fe20000410000ULL, 0x0000ffff00047812ULL, 0x000fe200078ec0ffULL,
0x000000580d587220ULL, 0x050fe20000410000ULL, 0x000000570d577220ULL, 0x040fe20000410000ULL,
0x000000560d567220ULL, 0x040fe20000410000ULL, 0x00000003ff047819ULL, 0x000fe20000011604ULL,
0x000000550d557220ULL, 0x040fe20000410000ULL, 0x000000540d0e7220ULL, 0x040fe20000410000ULL,
0x000000530d537220ULL, 0x040fe20000410000ULL, 0x000000520d0f7220ULL, 0x040fe20000410000ULL,
0x000000510d107220ULL, 0x040fe20000410000ULL, 0x000000500d507220ULL, 0x040fe20000410000ULL,
0x0000004f0d4f7220ULL, 0x040fe20000410000ULL, 0x0000004e0d117220ULL, 0x040fe20000410000ULL,
0x0000004d0d127220ULL, 0x040fe20000410000ULL, 0x0000004c0d4c7220ULL, 0x040fe20000410000ULL,
0x0000004b0d4b7220ULL, 0x040fe20000410000ULL, 0x0000004a0d137220ULL, 0x040fe20000410000ULL,
0x000000490d147220ULL, 0x000fe20000410000ULL, 0xfffffff8ff0d7812ULL, 0x000fe200078ee200ULL,
0x0000003816387220ULL, 0x000fe20000410000ULL, 0x0000000304057812ULL, 0x000fe200078ec0ffULL,
0x0000003716377220ULL, 0x040fe20000410000ULL, 0x0000003616367220ULL, 0x040fe20000410000ULL,
0x0000003516357220ULL, 0x040fe20000410000ULL, 0x0000003416347220ULL, 0x040fe20000410000ULL,
0x0000003316337220ULL, 0x040fe20000410000ULL, 0x0000003216327220ULL, 0x040fe20000410000ULL,
0x0000003116317220ULL, 0x040fe20000410000ULL, 0x0000003016307220ULL, 0x040fe20000410000ULL,
0x0000002f162f7220ULL, 0x040fe20000410000ULL, 0x0000002e162e7220ULL, 0x040fe20000410000ULL,
0x0000002d162d7220ULL, 0x040fe20000410000ULL, 0x0000002c162c7220ULL, 0x040fe20000410000ULL,
0x0000002b162b7220ULL, 0x040fe20000410000ULL, 0x0000002a162a7220ULL, 0x040fe20000410000ULL,
0x0000006b166b7220ULL, 0x000fe20000410000ULL, 0x000000080d167836ULL, 0x000fe20000000000ULL,
0x0000000005057210ULL, 0x000fe20007ffe0ffULL, 0x000000100d187836ULL, 0x000fe20000000000ULL,
0x000000060706723eULL, 0x000fe200000000ffULL, 0x000000180d197836ULL, 0x000fe20000000000ULL,
0x0000000705047812ULL, 0x000fe200078ec0ffULL, 0x000000080d177824ULL, 0x000fe200078e00ffULL,
0x0000000405057812ULL, 0x000fe200078e3cffULL, 0x00000008161b7824ULL, 0x000fe200078e00ffULL,
0x0000000319237819ULL, 0x040fe200000006ffULL, 0x00000008181f7824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee204ULL, 0x0000000816167824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee204ULL, 0x0000000818187824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee204ULL, 0x00000008191a7824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee204ULL, 0x000000080d047824ULL, 0x000fe200078e00ffULL,
0x0000000705057812ULL, 0x000fe200078ec0ffULL, 0x0000004815487220ULL, 0x040fe20000410000ULL,
0x0000004715477220ULL, 0x040fe20000410000ULL, 0x0000004615467220ULL, 0x040fe20000410000ULL,
0xfffffff804197812ULL, 0x000fe200078ee205ULL, 0x0000004515457220ULL, 0x040fe20000410000ULL,
0xfffffff8161d7812ULL, 0x000fe200078ee205ULL, 0x0000004415447220ULL, 0x040fe20000410000ULL,
0xfffffff818217812ULL, 0x000fe200078ee205ULL, 0x0000004315437220ULL, 0x040fe20000410000ULL,
0xfffffff81a257812ULL, 0x000fe200078ee205ULL, 0x0000004215427220ULL, 0x040fe20000410000ULL,
0x0000004115417220ULL, 0x040fe20000410000ULL, 0x0000004015407220ULL, 0x040fe20000410000ULL,
0x0000003f153f7220ULL, 0x040fe20000410000ULL, 0x0000003e153e7220ULL, 0x040fe20000410000ULL,
0x0000003d153d7220ULL, 0x040fe20000410000ULL, 0x0000003c153c7220ULL, 0x040fe20000410000ULL,
0x0000003b153b7220ULL, 0x040fe20000410000ULL, 0x0000003a153a7220ULL, 0x040fe20000410000ULL,
0x000000696804723eULL, 0x000fe200000000ffULL, 0x0000003915157220ULL, 0x000fe20000410000ULL,
0x000000676605723eULL, 0x000fe200000000ffULL, 0x0000001019197824ULL, 0x100fe200078e021eULL,
0x000000636207723eULL, 0x000fe200000000ffULL, 0x000000101b1b7824ULL, 0x100fe200078e021eULL,
0x0000001e17177211ULL, 0x000fe200078e20ffULL, 0x000000101f1f7824ULL, 0x100fe200078e021eULL,
0x000000080908723eULL, 0x000fe200000000ffULL, 0x0000001021217824ULL, 0x100fe200078e021eULL,
0x0000005f5e09723eULL, 0x000fe200000000ffULL, 0x0000000417007844ULL, 0x0003e20000000200ULL,
0x0000000a5b0a723eULL, 0x000fe200000000ffULL, 0x0000001023237824ULL, 0x100fe200078e021eULL,
0x0000000b0c0b723eULL, 0x000fe200000000ffULL, 0x0000001025257824ULL, 0x000fe200078e021eULL,
0x00000058570c723eULL, 0x000fc400000000ffULL, 0x00000056550d723eULL, 0x000fe200000000ffULL,
0x0000000819007844ULL, 0x000fe20000000200ULL, 0x0000000e530e723eULL, 0x000fe400000000ffULL,
0x0000000f100f723eULL, 0x000fe400000000ffULL, 0x000000111211723eULL, 0x000fe400000000ffULL,
0x000000504f10723eULL, 0x000fe200000000ffULL, 0x0000000171047824ULL, 0x002fe200078e0200ULL,
0x0000004c4b12723eULL, 0x000fe200000000ffULL, 0x0000000c1b007844ULL, 0x000fe20000000200ULL,
0x000000131413723eULL, 0x000fe200000000ffULL, 0x0000001004247824ULL, 0x000fe200078e0295ULL,
0x0000001e1d1d7211ULL, 0x000fc400078e20ffULL, 0x000000484748723eULL, 0x000fe400000000ffULL,
0x000000464549723eULL, 0x000fe200000000ffULL, 0x000000101d007844ULL, 0x000fe20000000200ULL,
0x00000044434a723eULL, 0x000fe400000000ffULL, 0x00000042414b723eULL, 0x000fe400000000ffULL,
0x000000403f40723eULL, 0x000fe400000000ffULL, 0x0000003e3d41723eULL, 0x000fe200000000ffULL,
0x000000481f007844ULL, 0x000fe20000000200ULL, 0x0000003c3b42723eULL, 0x000fc400000000ffULL,
0x0000003a1543723eULL, 0x000fe400000000ffULL, 0x000000383738723eULL, 0x000fe400000000ffULL,
0x000000363539723eULL, 0x000fe200000000ffULL, 0x0000004021007844ULL, 0x000fe20000000200ULL,
0x00000034333a723eULL, 0x000fe400000000ffULL, 0x00000032313b723eULL, 0x000fe400000000ffULL,
0x000000302f30723eULL, 0x000fc400000000ffULL, 0x0000002e2d31723eULL, 0x000fe200000000ffULL,
0x0000003823007844ULL, 0x000fe20000000200ULL, 0x0000002c2b32723eULL, 0x000fe400000000ffULL,
0x0000002a6b33723eULL, 0x000fca00000000ffULL, 0x0000003025007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000024047984ULL, 0x000e680000000c00ULL,
0x00040000240c7984ULL, 0x000ea80000000c00ULL, 0x0008000024147984ULL, 0x000ee80000000c00ULL,
0x000c0000241c7984ULL, 0x000f280000000c00ULL, 0x0010000024087984ULL, 0x000f680000000c00ULL,
0x0014000024107984ULL, 0x000f280000000c00ULL, 0x0018000024187984ULL, 0x000f280000000c00ULL,
0x001c000024207984ULL, 0x000f620000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff0f0f7230ULL, 0x004fe40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fc40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x008fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fe40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x010fc40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fe40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x0000000b07077230ULL, 0x020fe40000000000ULL,
0x0000000a06067230ULL, 0x000fe40000000000ULL, 0x0000000905057230ULL, 0x000fc40000000000ULL,
0x0000000804047230ULL, 0x000fe40000000000ULL, 0x000000130f0f7230ULL, 0x000fe40000000000ULL,
0x000000120e0e7230ULL, 0x000fe20000000000ULL, 0x0000000424007388ULL, 0x0003e20000000c00ULL,
0x000000110d0d7230ULL, 0x000fe40000000000ULL, 0x000000100c0c7230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x000fc40000000000ULL, 0x0000001a16167230ULL, 0x000fe20000000000ULL,
0x0004000c24007388ULL, 0x0003e20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fe40000000000ULL, 0x000000231f1f7230ULL, 0x000fe40000000000ULL,
0x000000221e1e7230ULL, 0x000fe20000000000ULL, 0x0008001424007388ULL, 0x0003e20000000c00ULL,
0x000000211d1d7230ULL, 0x000fc40000000000ULL, 0x000000201c1c7230ULL, 0x000fca0000000000ULL,
0x000c001c24007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff7200720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fc80000011600ULL, 0x0000005c0900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x000000ffff047224ULL, 0x002fe200078e00ffULL, 0x0000000800067d06ULL, 0x000e620008209000ULL,
0x00000008ff0e7c12ULL, 0x000fe2000f8e33ffULL, 0x0000850000097ab9ULL, 0x000fe20000000800ULL,
0x00000020000f7836ULL, 0x000fe20000000000ULL, 0x00008a0000047ab9ULL, 0x000fc80000000a00ULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe06087810ULL, 0x002fcc0007ffe0ffULL,
0x0000000800057305ULL, 0x000e64000021f000ULL, 0x000000ffff077224ULL, 0x002fc800078e0a05ULL,
0x0000000807077c24ULL, 0x000fc8000f8e02ffULL, 0x00000007050d7227ULL, 0x000fc800078e0004ULL,
0x0000000197047824ULL, 0x000fe400078e0209ULL, 0x0000000109097824ULL, 0x000fe400078e0200ULL,
0x000000040d057227ULL, 0x000fc600078e00ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a05ULL, 0x0000000807067c24ULL, 0x000fca000f8e0204ULL,
0x0000000806007c0cULL, 0x000fda000bf06070ULL, 0x8000000806060c10ULL, 0x000fe2000fffe0ffULL,
0x0000000105050836ULL, 0x000fe20000000000ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x0000000806007c0cULL, 0x000fe4000bf26070ULL, 0x0ffffff809067812ULL, 0x000fca00078ef800ULL,
0x0000001006067824ULL, 0x000fca00078e0295ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000105051836ULL, 0x000fca0000000000ULL, 0x000000050e057207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fe4000001160fULL, 0x000000ff05077210ULL, 0x000fe20007ffe1ffULL,
0x0000000905057c24ULL, 0x000fc8000f8e0202ULL, 0x0000000807047c24ULL, 0x000fe2000f8e0204ULL,
0x0000000700077812ULL, 0x000fc600078ec0ffULL, 0x0000000805047c24ULL, 0x000fe4000f8e0204ULL,
0x000000086e077824ULL, 0x000fc600078e0207ULL, 0x0000000403057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f440cULL, 0x0000005c0600720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000197047824ULL, 0x102fe400078e0206ULL,
0x000000010f067824ULL, 0x000fe400078e0206ULL, 0x000000040d057227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe400078ec0ffULL, 0x000000ff05077210ULL, 0x000fe40007ffe1ffULL,
0x0ffffff806067812ULL, 0x000fc600078ef80fULL, 0x0000000807077c24ULL, 0x000fe4000f8e0204ULL,
0x0000001006067824ULL, 0x000fc600078e0295ULL, 0x0000000807007c0cULL, 0x000fe4000bf26070ULL,
0x0000000006087984ULL, 0x0002b60000000c00ULL, 0x8000000807071c36ULL, 0x000fc40008000000ULL,
0x0000000105051836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fda000bf46070ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x000000050e057207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a05ULL, 0x0000000905057c24ULL, 0x000fe4000f8e0202ULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x000000070f077812ULL, 0x000fe200078ec0ffULL,
0x00000040000f7836ULL, 0x000fe40000000000ULL, 0x0000000805047c24ULL, 0x000fe4000f8e0204ULL,
0x000000086e077824ULL, 0x000fe200078e0207ULL, 0x00000003ff067819ULL, 0x002fc4000001160fULL,
0x0000000403057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f440cULL,
0x0000005c0600720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000697047210ULL, 0x002fe20007ffe0ffULL, 0x000000010f067824ULL, 0x000fc800078e0206ULL,
0x000000040d057227ULL, 0x000fe200078e00ffULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x000000ffff077224ULL, 0x000fe200078e0a05ULL, 0x0ffffff806067812ULL, 0x000fc600078ef80fULL,
0x0000000807077c24ULL, 0x000fe2000f8e0204ULL, 0x0000009506067211ULL, 0x000fc800078e20ffULL,
0x0000000807007c0cULL, 0x000fe2000bf26070ULL, 0x0000000006087984ULL, 0x0002980000000c00ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf46070ULL, 0x0000000105052836ULL, 0x000fca0000000000ULL,
0x000000050e057207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a05ULL,
0x0000000905057c24ULL, 0x000fe4000f8e0202ULL, 0x0000000807047c24ULL, 0x000fe2000f8e0204ULL,
0x000000070f077812ULL, 0x000fe200078ec0ffULL, 0x00000060000f7836ULL, 0x000fe40000000000ULL,
0x0000000805047c24ULL, 0x000fe2000f8e0204ULL, 0x000000076e077211ULL, 0x000fe400078e18ffULL,
0x00000003ff067819ULL, 0x002fc4000001160fULL, 0x0000000403057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f440cULL, 0x0000005c0600720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000197047824ULL, 0x102fe400078e0206ULL,
0x000000010f067824ULL, 0x000fe400078e0206ULL, 0x000000040d057227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc600078e0a05ULL,
0x0ffffff806067812ULL, 0x000fe200078ef80fULL, 0x0000000807077c24ULL, 0x000fc8000f8e0204ULL,
0x0000001006067824ULL, 0x000fe200078e0295ULL, 0x0000000807007c0cULL, 0x000fc8000bf26070ULL,
0x0000000006087984ULL, 0x0002b20000000c00ULL, 0x8000000807071c36ULL, 0x000fe20008000000ULL,
0x0000000105051810ULL, 0x000fc80007ffe0ffULL, 0x0000000807007c0cULL, 0x000fda000bf46070ULL,
0x0000000105052836ULL, 0x000fca0000000000ULL, 0x000000050e057207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a05ULL, 0x0000000905057c24ULL, 0x000fe4000f8e0202ULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x000000070f077812ULL, 0x000fe400078ec0ffULL,
0x00000080000f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000805047c24ULL, 0x000fe4000f8e0204ULL,
0x000000086e077824ULL, 0x000fe200078e0207ULL, 0x00000003ff067819ULL, 0x002fc4000001160fULL,
0x0000000403057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f440cULL,
0x0000005c0600720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000197047824ULL, 0x002fe200078e0206ULL, 0x000000060f067210ULL, 0x000fc60007ffe0ffULL,
0x000000040d057227ULL, 0x000fe200078e00ffULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x000000ffff077224ULL, 0x000fe200078e0a05ULL, 0x0ffffff806067812ULL, 0x000fc600078ef80fULL,
0x0000000807077c24ULL, 0x000fe4000f8e0204ULL, 0x0000001006067824ULL, 0x000fc600078e0295ULL,
0x0000000807007c0cULL, 0x000fe4000bf26070ULL, 0x0000000006087984ULL, 0x0002b60000000c00ULL,
0x8000000807071c36ULL, 0x000fc40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf46070ULL, 0x0000000105052836ULL, 0x000fca0000000000ULL,
0x000000050e057207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a05ULL,
0x0000000905057c24ULL, 0x000fe4000f8e0202ULL, 0x0000000807047c24ULL, 0x000fe2000f8e0204ULL,
0x000000070f077812ULL, 0x000fe200078ec0ffULL, 0x000000a0000f7836ULL, 0x000fe40000000000ULL,
0x0000000805047c24ULL, 0x000fe4000f8e0204ULL, 0x000000086e077824ULL, 0x000fe200078e0207ULL,
0x00000003ff067819ULL, 0x002fc4000001160fULL, 0x0000000403057210ULL, 0x000fc80007f3e0ffULL,
0x000000ffff0c7210ULL, 0x000fe40000ffe4ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f440cULL, 0x0000005c0600720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000197047824ULL, 0x102fe400078e0206ULL,
0x000000010f067824ULL, 0x000fe400078e0206ULL, 0x000000040d057227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc600078e0a05ULL,
0x0ffffff806067812ULL, 0x000fe200078ef80fULL, 0x0000000807077c24ULL, 0x000fc8000f8e0204ULL,
0x0000001006067824ULL, 0x000fe200078e0295ULL, 0x0000000807007c0cULL, 0x000fc8000bf26070ULL,
0x0000000006087984ULL, 0x0002b20000000c00ULL, 0x8000000807071c10ULL, 0x000fe2000fffe0ffULL,
0x0000000105051836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fda000bf46070ULL,
0x0000000105052836ULL, 0x000fca0000000000ULL, 0x000000050e057207ULL, 0x000fc80004000000ULL,
0x000000ff05077210ULL, 0x000fe20007ffe1ffULL, 0x0000000905057c24ULL, 0x000fc8000f8e0202ULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x000000070f077812ULL, 0x000fe200078ec0ffULL,
0x000000c0000f7836ULL, 0x000fe40000000000ULL, 0x0000000805047c24ULL, 0x000fe4000f8e0204ULL,
0x000000086e077824ULL, 0x000fe200078e0207ULL, 0x00000003ff067819ULL, 0x002fe4000001160fULL,
0x0000000403057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f440cULL,
0x0000005c0600720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000197047824ULL, 0x102fe400078e0206ULL, 0x000000010f067824ULL, 0x000fe400078e0206ULL,
0x000000040d057227ULL, 0x000fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe400078ec0ffULL,
0x000000ff05077210ULL, 0x000fe40007ffe1ffULL, 0x0ffffff806067812ULL, 0x000fc600078ef80fULL,
0x0000000807077c24ULL, 0x000fe4000f8e0204ULL, 0x0000001006067824ULL, 0x000fc600078e0295ULL,
0x0000000807007c0cULL, 0x000fe4000bf26070ULL, 0x0000000006087984ULL, 0x000e760000000c00ULL,
0x8000000807071c36ULL, 0x000fc40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf46070ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x000000050e057207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a05ULL,
0x0000000905057c24ULL, 0x000fe4000f8e0202ULL, 0x0000000807047c24ULL, 0x000fe2000f8e0204ULL,
0x000000070f077812ULL, 0x000fe200078ec0ffULL, 0x000000e0000f7836ULL, 0x000fe40000000000ULL,
0x0000000805047c24ULL, 0x000fe4000f8e0204ULL, 0x000000086e077824ULL, 0x000fe200078e0207ULL,
0x00000003ff007819ULL, 0x000fc4000001160fULL, 0x0000000403057210ULL, 0x000fe40007f3e0ffULL,
0x0000000097977210ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f440cULL,
0x0000005c0000720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000970d047227ULL, 0x002fc800078e00ffULL, 0x000000ffff067224ULL, 0x000fe400078e0a04ULL,
0x000000010f007824ULL, 0x000fe400078e0200ULL, 0x0000000806057c24ULL, 0x000fc6000f8e0297ULL,
0x0000000700007812ULL, 0x000fe400078ec0ffULL, 0x0000000805007c0cULL, 0x000fe4000bf26070ULL,
0xfffffff800007812ULL, 0x000fc800078ef80fULL, 0x0000009500007211ULL, 0x000fca00078e20ffULL,
0x0000000000087984ULL, 0x000e640000000c00ULL, 0x8000000805051c36ULL, 0x000fe40008000000ULL,
0x0000000104041836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fda000bf46070ULL,
0x0000000104042836ULL, 0x000fca0000000000ULL, 0x000000040e057207ULL, 0x000fca0004000000ULL,
0x000000ffff047224ULL, 0x000fe400078e0a05ULL, 0x0000000905027c24ULL, 0x000fe2000f8e0202ULL,
0x000000070f057812ULL, 0x000fe200078ec0ffULL, 0x0000000804977c24ULL, 0x000fc8000f8e0297ULL,
0x0000000802027c24ULL, 0x000fe4000f8e0297ULL, 0x000000086e057824ULL, 0x000fc600078e0205ULL,
0x0000000203037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x0000000403027c11ULL, 0x000fc8000f8040ffULL, 0x0000000503037c11ULL, 0x000fc600080f4404ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000019a037836ULL, 0x000fe20000000000ULL,
0x0000000100067802ULL, 0x000fe20000000f00ULL, 0x0000000211227824ULL, 0x000fe200078e00ffULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x0000004098237824ULL, 0x000fe200078e00ffULL,
0x000000940300720cULL, 0x000fe20003f06070ULL, 0x0000001f04047890ULL, 0x000fe2000fffe03fULL,
0x0000001522227224ULL, 0x000fe200078e0202ULL, 0x0000940000057ab9ULL, 0x000fe20000000800ULL,
0x000001009a037824ULL, 0x000fe200078e0223ULL, 0x01e60006950679a7ULL, 0x0002a2000850003fULL,
0x000000053f047899ULL, 0x000fc40008011604ULL, 0x00000005222e7c24ULL, 0x000fca000f8e0203ULL,
0x0000000c00248947ULL, 0x000fea0003800000ULL, 0x00000003ff2f7819ULL, 0x100fe20000011600ULL,
0x0000900000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000396027248ULL, 0x000fe40007fe0000ULL,
0x000000042f097810ULL, 0x000fe20007ffe0ffULL, 0x000000082f0b7836ULL, 0x000fe20000000000ULL,
0x000000102f0f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001021c7824ULL, 0x000fe200078e0a03ULL,
0x000000142f197810ULL, 0x000fe20007ffe0ffULL, 0x000000080b207824ULL, 0x000fe200078e00ffULL,
0x000000000b037210ULL, 0x000fe20007ffe0ffULL, 0x0000000109087824ULL, 0x040fe200078e0200ULL,
0x0000001c0900720cULL, 0x040fe20003fa6070ULL, 0x00000008090d7824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee203ULL, 0x000000012e027824ULL, 0x000fe200078e022fULL,
0x000000192e0c7210ULL, 0x000fe20007ffe0ffULL, 0x000000080f137824ULL, 0x000fe200078e00ffULL,
0xfffffff80d1e7812ULL, 0x000fe200078ee208ULL, 0x0000010002027825ULL, 0x000fc800078e00ffULL,
0x000000012e087824ULL, 0x000fe200078e0209ULL, 0x0000007002107812ULL, 0x000fe200078ef805ULL,
0x0000000c2f0d7836ULL, 0x000fe40000000000ULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000810107c10ULL, 0x000fe4000ff1e0ffULL, 0x0000001c0d00720cULL, 0x000fe20003f46070ULL,
0x000000010f027824ULL, 0x100fe200078e0200ULL, 0x0000007008127812ULL, 0x000fe200078ef805ULL,
0x000000010d0a7824ULL, 0x000fc400078e0200ULL, 0x000000080d117824ULL, 0x000fe200078e00ffULL,
0xfffffff813267812ULL, 0x000fe200078ee202ULL, 0x000000012e027824ULL, 0x040fe200078e020bULL,
0x0000000812127c10ULL, 0x000fe2000ff3e0ffULL, 0x000000012e087824ULL, 0x040fe200078e020dULL,
0xfffffff811247812ULL, 0x000fe200078ee20aULL, 0x000000012e0a7824ULL, 0x000fe200078e020fULL,
0x0000000903117c10ULL, 0x000fe200087fe4ffULL, 0x0000010002027825ULL, 0x000fe200078e00ffULL,
0x0000000909137c10ULL, 0x000fe40008ffe4ffULL, 0x0000001c0b00720cULL, 0x000fe20003f26070ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000007002147812ULL, 0x000fc400078ef805ULL,
0x0000001c0f00720cULL, 0x000fe20003f06070ULL, 0x000000182f1b7836ULL, 0x000fe20000000000ULL,
0x0000000814147c10ULL, 0x000fe2000ff7e0ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x000000700a0a7812ULL, 0x000fe400078ef805ULL, 0x0000000903157c10ULL, 0x000fe20009ffe4ffULL,
0x0000001c2f2b7836ULL, 0x000fe20000000000ULL, 0x000000080a0a7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x000fc400078ef805ULL,
0x000000090b0b7c10ULL, 0x000fe20009ffe4ffULL, 0x000000012e0e7824ULL, 0x000fe200078e021bULL,
0x0000007008167812ULL, 0x000fe200078ef805ULL, 0x0000400098027824ULL, 0x000fe200078e0295ULL,
0x000000080c0c7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000012e037824ULL, 0x000fe200078e022bULL,
0x0000000816167c10ULL, 0x000fe2000ff9e0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000000090d0d7c10ULL, 0x000fe40009ffe4ffULL, 0x000000002f087210ULL, 0x000fe20007ffe0ffULL,
0x00002000021d7836ULL, 0x000fe20000000000ULL, 0x000000700e0e7812ULL, 0x000fe200078ef805ULL,
0x0000010003027825ULL, 0x000fe200078e00ffULL, 0x0000000909177c10ULL, 0x000fc4000a7fe4ffULL,
0x0000001c1900720cULL, 0x0c0fe20003f66070ULL, 0x000000202f257836ULL, 0x000fe20000000000ULL,
0x0000007002187812ULL, 0x000fe200078ef805ULL, 0x00000001191a7824ULL, 0x040fe200078e0200ULL,
0x000000080e0e7c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000819197824ULL, 0x000fe200078e00ffULL,
0x0000000708097812ULL, 0x000fe200078ec0ffULL, 0x000000242f277836ULL, 0x000fe20000000000ULL,
0x0000000818187c10ULL, 0x000fe2000ffde0ffULL, 0x000000282f297836ULL, 0x000fe20000000000ULL,
0x000000252e027210ULL, 0x000fe20007ffe0ffULL, 0x000000081b2a7824ULL, 0x000fe200078e00ffULL,
0x000000090f0f7c10ULL, 0x000fe2000a7fe4ffULL, 0x000000382f2d7836ULL, 0x000fe20000000000ULL,
0x0000001c2f00720cULL, 0x000fc40003f86070ULL, 0xfffffff819287812ULL, 0x000fe400078ee21aULL,
0x0ffffff809087812ULL, 0x000fe400078ef800ULL, 0x0000000903197c10ULL, 0x000fe2000b7fe4ffULL,
0x0000010002027825ULL, 0x000fe200078e00ffULL, 0x000000001b217210ULL, 0x000fe40007ffe0ffULL,
0x000000032b2c7819ULL, 0x000fe200000006ffULL, 0x00000010081f7824ULL, 0x000fe200078e021dULL,
0x00000070021a7812ULL, 0x000fe200078ef805ULL, 0x000000012e087824ULL, 0x040fe200078e0227ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee221ULL, 0x000000012e027824ULL, 0x000fe200078e0229ULL,
0x000000081a1a7c10ULL, 0x000fe2000ffde0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101f7faeULL, 0x0007e2000e101c46ULL,
0x0000001c1b00720cULL, 0x000fc40003f86070ULL, 0x00000009031b7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000010002027825ULL, 0x000fe200078e00ffULL, 0x0000007008087812ULL, 0x000fc600078ef805ULL,
0x0000001020217824ULL, 0x100fe200078e021dULL, 0x0000000808087c10ULL, 0x000fe2000ffde0ffULL,
0x0000000825207824ULL, 0x000fe400078e00ffULL, 0x000000101e1f7824ULL, 0x008fe200078e021dULL,
0x0000007002107812ULL, 0x000fe200078ef805ULL, 0x000000012b117824ULL, 0x100fe200078e0200ULL,
0x0000000909097c10ULL, 0x000fe2000b7fe4ffULL, 0x00000001271e7824ULL, 0x000fe200078e0200ULL,
0x00000000121f7faeULL, 0x0007e2000e901c46ULL, 0x0000001c2b00720cULL, 0x000fe20003fa6070ULL,
0x0000002c2f2b7836ULL, 0x000fe20000000000ULL, 0x0000000810107c10ULL, 0x000fe2000ffde0ffULL,
0x0000000014217faeULL, 0x0009e2000c901c46ULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee211ULL,
0x000000012e027824ULL, 0x000fe200078e022bULL, 0x0000000903117c10ULL, 0x000fc4000b7fe4ffULL,
0x0000001c2500720cULL, 0x000fe20003f26070ULL, 0x0000010002027825ULL, 0x000fe200078e00ffULL,
0x0000000025137210ULL, 0x008fc60007ffe0ffULL, 0x00000010241f7824ULL, 0x100fe200078e021dULL,
0x0000007002127812ULL, 0x000fe200078ef805ULL, 0x0000001026157824ULL, 0x110fe200078e021dULL,
0xfffffff820027812ULL, 0x000fe400078ee213ULL, 0x00000000161f7faeULL, 0x0007e2000d101c46ULL,
0x0000001c2700720cULL, 0x040fe20003f46070ULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x0000000812127c10ULL, 0x000fe2000ffde0ffULL, 0x0000001002217824ULL, 0x000fe200078e021dULL,
0x000000000a157faeULL, 0x0009e4000c101c46ULL, 0xfffffff8271e7812ULL, 0x000fc400078ee21eULL,
0x000000302f277810ULL, 0x000fe40007ffe0ffULL, 0x0000000903137c10ULL, 0x000fe2000b7fe4ffULL,
0x000000102a177824ULL, 0x008fe200078e021dULL, 0x0000001d28037211ULL, 0x000fe200078e20ffULL,
0x000000012e027824ULL, 0x000fe400078e0227ULL, 0x000000102c1f7824ULL, 0x100fe200078e021dULL,
0x00000000290b7210ULL, 0x010fe20007ffe0ffULL, 0x000000000c037faeULL, 0x0007e2000d901c46ULL,
0x000000342f157836ULL, 0x000fe20000000000ULL, 0x0000001c2700720cULL, 0x080fe20003f66070ULL,
0x000000101e257824ULL, 0x000fe200078e021dULL, 0x000000000e177faeULL, 0x0009e2000e101c46ULL,
0x0000001c2b00720cULL, 0x000fe20003f86070ULL, 0x0000000827167824ULL, 0x000fc400078e00ffULL,
0x00000000181f7faeULL, 0x000be2000e901c46ULL, 0x0000003c2f2f7836ULL, 0x000fe20000000000ULL,
0x0000001c2900720cULL, 0x080fe20003fa6070ULL, 0x0000010002027825ULL, 0x008fe200078e00ffULL,
0x000000001a217faeULL, 0x0007e2000c901c46ULL, 0x0000001c2d00720cULL, 0x080fe40003f26070ULL,
0x000000012e0c7824ULL, 0x000fe200078e0215ULL, 0x00000070020a7812ULL, 0x000fe200078ef805ULL,
0x00000008290e7824ULL, 0x010fe200078e00ffULL, 0x0000000008257faeULL, 0x0009e2000d101c46ULL,
0x000000012b027824ULL, 0x140fe200078e0200ULL, 0x000000080a0a7c10ULL, 0x000fe2000ffde0ffULL,
0x000000082b2b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee20bULL,
0x00000001150f7824ULL, 0x140fe200078e0200ULL, 0x00000009030b7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000815187824ULL, 0x022fe200078e00ffULL, 0x0000000027037210ULL, 0x000fe20007ffe0ffULL,
0x000000082d1a7824ULL, 0x008fe200078e00ffULL, 0xfffffff82b147812ULL, 0x000fe200078ee202ULL,
0x000000012f177824ULL, 0x000fe200078e0200ULL, 0xfffffff816167812ULL, 0x000fe200078ee203ULL,
0x000001000c087825ULL, 0x010fe200078e00ffULL, 0x0000001c1500720cULL, 0x000fc40003f46070ULL,
0x0000001c2f00720cULL, 0x000fe20003f06070ULL, 0x000000012d157824ULL, 0x000fe200078e0200ULL,
0x00000070080c7812ULL, 0x000fe200078ef805ULL, 0x000000012e087824ULL, 0x000fe200078e022dULL,
0xfffffff818007812ULL, 0x000fe200078ee20fULL, 0x000000082f1c7824ULL, 0x000fe200078e00ffULL,
0x000000080c0c7c10ULL, 0x000fe2000ffde0ffULL, 0x0000010008027825ULL, 0x000fe200078e00ffULL,
0x0000002f2e087210ULL, 0x000fe40007ffe0ffULL, 0x00000009090d7c10ULL, 0x000fe2000b7fe4ffULL,
0x00000010140f7824ULL, 0x000fe200078e021dULL, 0x0000007002027812ULL, 0x000fe200078ef805ULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0xfffffff81a187812ULL, 0x000fc400078ee215ULL,
0x0000000802027c10ULL, 0x000fe2000ffde0ffULL, 0x0000001016157824ULL, 0x100fe200078e021dULL,
0x0000007008087812ULL, 0x000fe200078ef805ULL, 0x0000001018197824ULL, 0x100fe200078e021dULL,
0x0000000903037c10ULL, 0x000fe4000b7fe4ffULL, 0x0000001d0e057211ULL, 0x080fe400078e20ffULL,
0xfffffff81c1a7812ULL, 0x000fe200078ee217ULL, 0x0000001000177824ULL, 0x000fe200078e021dULL,
0x0000000808087c10ULL, 0x000fe2000ffde0ffULL, 0x0000000010057faeULL, 0x0003e2000e901c46ULL,
0x0000001d1a1d7211ULL, 0x000fc400078e20ffULL, 0x0000000909097c10ULL, 0x000fe2000b7fe4ffULL,
0x00000000120f7faeULL, 0x0003e8000e101c46ULL, 0x000000000a157faeULL, 0x0003e8000d901c46ULL,
0x000000000c177faeULL, 0x0003e8000d101c46ULL, 0x0000000002197faeULL, 0x0003e8000c901c46ULL,
0x00000000081d7faeULL, 0x0003e2000c101c46ULL, 0x0000000800d47947ULL, 0x000fea0003800000ULL,
0x0000001400217811ULL, 0x040fe200078fe8ffULL, 0x0000900000087ab9ULL, 0x000fe20000000a00ULL,
0x00000010001f7811ULL, 0x040fe400078fe8ffULL, 0x0000000321307819ULL, 0x040fe200000006ffULL,
0x0000000121097824ULL, 0x100fe200078e0200ULL, 0x00000004000d7811ULL, 0x040fe200078fe8ffULL,
0x000000011f087824ULL, 0x140fe200078e0200ULL, 0x00000008000f7811ULL, 0x040fe200078fe8ffULL,
0x000000081f117824ULL, 0x000fe200078e00ffULL, 0xfffffff830307812ULL, 0x000fe200078ee209ULL,
0x000000010d027824ULL, 0x140fe200078e0200ULL, 0x0000002400097811ULL, 0x040fe200078fe8ffULL,
0x000000080d037824ULL, 0x000fe200078e00ffULL, 0x0000000c001b7811ULL, 0x040fe200078fe8ffULL,
0x000000080f0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff811267812ULL, 0x000fe200078ee208ULL,
0x0000000109087824ULL, 0x140fe200078e0200ULL, 0xfffffff8031a7812ULL, 0x000fe200078ee202ULL,
0x0000000809157824ULL, 0x000fe200078e00ffULL, 0x000000001b037210ULL, 0x000fe20007ffe0ffULL,
0x000000010f027824ULL, 0x000fe200078e0200ULL, 0x0000001c002b7811ULL, 0x040fe200078fe8ffULL,
0x000000081b247824ULL, 0x000fe200078e00ffULL, 0xfffffff815127812ULL, 0x000fe200078ee208ULL,
0x00000001210e7824ULL, 0x000fe200078e022eULL, 0x0000002c00157811ULL, 0x040fe200078fe8ffULL,
0x000000082b347824ULL, 0x000fe200078e00ffULL, 0x0000001800297811ULL, 0x000fc400078fe8ffULL,
0xfffffff80b1c7812ULL, 0x000fe200078ee202ULL, 0x000000012b0b7824ULL, 0x100fe200078e0200ULL,
0xfffffff824247812ULL, 0x000fe200078ee203ULL, 0x0000000115087824ULL, 0x140fe200078e0200ULL,
0x0000002000037811ULL, 0x040fe200078fe8ffULL, 0x00000008151d7824ULL, 0x000fe200078e00ffULL,
0x0000003400197811ULL, 0x040fe200078fe8ffULL, 0x00000001290a7824ULL, 0x140fe200078e0200ULL,
0x0000003000177811ULL, 0x040fe200078fe8ffULL, 0x0000000829117824ULL, 0x000fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe200078ee20bULL, 0x0000000803137824ULL, 0x000fe200078e00ffULL,
0x0000000003027210ULL, 0x000fe20007ffe0ffULL, 0x0000000819277824ULL, 0x000fe200078e00ffULL,
0x00000028000b7811ULL, 0x000fe200078fe8ffULL, 0x0000000817257824ULL, 0x040fe200078e00ffULL,
0x00000000190c7210ULL, 0x000fe20007ffe0ffULL, 0x000000012e1e7824ULL, 0x040fe200078e0203ULL,
0xfffffff81d147812ULL, 0x000fe200078ee208ULL, 0x000000012e207824ULL, 0x000fe200078e020bULL,
0xfffffff811327812ULL, 0x000fe200078ee20aULL, 0x00000001170a7824ULL, 0x100fe200078e0200ULL,
0x0000000000087211ULL, 0x000fe200078fe8ffULL, 0x000000012e217824ULL, 0x000fe200078e0215ULL,
0xfffffff813117812ULL, 0x000fe200078ee202ULL, 0x000000010b027824ULL, 0x000fe200078e0200ULL,
0xfffffff827187812ULL, 0x000fe200078ee20cULL, 0x000000011b0c7824ULL, 0x100fe200078e022eULL,
0x00000038001d7811ULL, 0x000fe200078fe8ffULL, 0x000000012b1b7824ULL, 0x100fe200078e022eULL,
0x0000000708277812ULL, 0x000fe200078ec0ffULL, 0x000000010d087824ULL, 0x100fe200078e022eULL,
0x000000030b137819ULL, 0x000fe200000006ffULL, 0x000000081d107824ULL, 0x000fe200078e00ffULL,
0xfffffff825167812ULL, 0x000fe200078ee20aULL, 0x000000010f0a7824ULL, 0x100fe200078e022eULL,
0x0000002e1f0d7210ULL, 0x000fe20007ffe0ffULL, 0x00000001290f7824ULL, 0x000fe200078e022eULL,
0x0000003c00257811ULL, 0x000fe200078fe8ffULL, 0x000000012e287824ULL, 0x000fe200078e0217ULL,
0x000000092e1f7210ULL, 0x000fe20007ffe0ffULL, 0x000000011d097824ULL, 0x100fe200078e0200ULL,
0xfffffff813137812ULL, 0x000fe200078ee202ULL, 0x00000001250b7824ULL, 0x000fe200078e0200ULL,
0x0000002e00027211ULL, 0x000fe200078fe8ffULL, 0x000000012e2a7824ULL, 0x000fe200078e0219ULL,
0x0ffffff827277812ULL, 0x000fc400078ef800ULL, 0xfffffff810007812ULL, 0x000fe200078ee209ULL,
0x0000400098097824ULL, 0x000fe200078e0295ULL, 0x0000000325367819ULL, 0x000fe200000006ffULL,
0x0000010002027825ULL, 0x000fe200078e00ffULL, 0x0000001d2e2c7210ULL, 0x000fe40007ffe0ffULL,
0xfffffff836157812ULL, 0x000fe200078ee20bULL, 0x0000200009477836ULL, 0x000fe20000000000ULL,
0x0000007002107812ULL, 0x000fe200078ef805ULL, 0x0000010008087825ULL, 0x000fc600078e00ffULL,
0x0000000810107c10ULL, 0x000fe2000ff1e0ffULL, 0x00000010123b7824ULL, 0x100fe200078e0247ULL,
0x0000007008127812ULL, 0x000fe200078ef805ULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000004716417211ULL, 0x080fe400078e20ffULL, 0x0000000812127c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001011397824ULL, 0x100fe200078e0247ULL, 0x0000000903117c10ULL, 0x000fe200087fe4ffULL,
0x00000010143f7824ULL, 0x000fe200078e0247ULL, 0x000000700a147812ULL, 0x000fe200078ef805ULL,
0x000001000c027825ULL, 0x000fe200078e00ffULL, 0x000000471c2d7211ULL, 0x000fc400078e20ffULL,
0x0000000814147c10ULL, 0x000fe2000ff1e0ffULL, 0x00000010133d7824ULL, 0x100fe200078e0247ULL,
0x0000000909137c10ULL, 0x000fe20008ffe4ffULL, 0x000001000d087825ULL, 0x000fe200078e00ffULL,
0x0000007002167812ULL, 0x000fe400078ef805ULL, 0x0000004734377211ULL, 0x000fe200078e20ffULL,
0x0000001027297824ULL, 0x100fe400078e0247ULL, 0x000000101a2b7824ULL, 0x100fe400078e0247ULL,
0x00000010242f7824ULL, 0x100fe200078e0247ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010297faeULL, 0x0007e2000b901c46ULL, 0x0000001026317824ULL, 0x000fc400078e0247ULL,
0x0000001030337824ULL, 0x100fe200078e0247ULL, 0x00000000122b7faeULL, 0x0007e2000b901c46ULL,
0x0000001032357824ULL, 0x100fe400078e0247ULL, 0x0000001018437824ULL, 0x100fe200078e0247ULL,
0x0000007008187812ULL, 0x000fe200078ef805ULL, 0x0000001000457824ULL, 0x000fe400078e0247ULL,
0x000001000e0c7825ULL, 0x000fe200078e00ffULL, 0x0000000818187c10ULL, 0x000fc6000ff3e0ffULL,
0x0000001015477824ULL, 0x000fe200078e0247ULL, 0x000000090b157c10ULL, 0x000fe200087fe4ffULL,
0x000001000f0e7825ULL, 0x000fe200078e00ffULL, 0x0000000816167c10ULL, 0x000fe4000ff1e0ffULL,
0x000000700c1a7812ULL, 0x000fe200078ef805ULL, 0x000001001f0a7825ULL, 0x000fe200078e00ffULL,
0x0000000903177c10ULL, 0x000fe200087fe4ffULL, 0x00000000142d7faeULL, 0x0007e2000b901c46ULL,
0x000000081a1a7c10ULL, 0x000fe2000ff1e0ffULL, 0x000001001b027825ULL, 0x000fe200078e00ffULL,
0x000000700e1c7812ULL, 0x000fe200078ef805ULL, 0x00000000162f7faeULL, 0x0007e2000b901c46ULL,
0x0000000909197c10ULL, 0x000fe20008ffe4ffULL, 0x000001001e087825ULL, 0x000fe200078e00ffULL,
0x000000090d1b7c10ULL, 0x000fc400087fe4ffULL, 0x00000070021e7812ULL, 0x000fe200078ef805ULL,
0x00000100200c7825ULL, 0x000fe200078e00ffULL, 0x000000081c1c7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000018317faeULL, 0x0007e2000b901c46ULL, 0x0000007008207812ULL, 0x000fe200078ef805ULL,
0x000000012e2e7824ULL, 0x000fe200078e0225ULL, 0x000000081e1e7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000001a337faeULL, 0x0007e2000b901c46ULL, 0x000000700a247812ULL, 0x000fe400078ef805ULL,
0x000000090f1d7c10ULL, 0x000fe200097fe4ffULL, 0x00000100210e7825ULL, 0x000fe200078e00ffULL,
0x000000700c267812ULL, 0x000fc400078ef805ULL, 0x0000000820207c10ULL, 0x000fe2000ff3e0ffULL,
0x000000001c357faeULL, 0x0007e2000b901c46ULL, 0x00000009031f7c10ULL, 0x000fe200087fe4ffULL,
0x0000010028027825ULL, 0x000fe200078e00ffULL, 0x0000000824247c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000826267c10ULL, 0x000fe2000ff5e0ffULL, 0x000000001e377faeULL, 0x0007e2000b901c46ULL,
0x0000000909217c10ULL, 0x000fe20008ffe4ffULL, 0x000001002a087825ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fc400078ef805ULL, 0x000000090b257c10ULL, 0x000fe200087fe4ffULL,
0x000001002c0a7825ULL, 0x000fe200078e00ffULL, 0x000000090d277c10ULL, 0x000fe200097fe4ffULL,
0x0000000020397faeULL, 0x0007e2000b901c46ULL, 0x000000080e0e7c10ULL, 0x000fe2000ff1e0ffULL,
0x000001002e0c7825ULL, 0x000fe200078e00ffULL, 0x0000007002027812ULL, 0x000fe200078ef805ULL,
0x00000000243b7faeULL, 0x0007e2000b901c46ULL, 0x0000007008087812ULL, 0x000fe400078ef805ULL,
0x000000700a0a7812ULL, 0x000fe200078ef805ULL, 0x00000000263d7faeULL, 0x0007e2000b901c46ULL,
0x000000090f0f7c10ULL, 0x000fc400087fe4ffULL, 0x000000700c057812ULL, 0x000fe400078ef805ULL,
0x0000000802027c10ULL, 0x000fe2000ff1e0ffULL, 0x000000000e3f7faeULL, 0x0007e2000b901c46ULL,
0x0000000808087c10ULL, 0x000fe4000ff3e0ffULL, 0x000000080a0a7c10ULL, 0x000fe4000ff5e0ffULL,
0x00000008050c7c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000903037c10ULL, 0x000fc400087fe4ffULL,
0x0000000909097c10ULL, 0x000fe40008ffe4ffULL, 0x000000090b0b7c10ULL, 0x000fe200097fe4ffULL,
0x0000000002417faeULL, 0x0007e2000b901c46ULL, 0x000000090d0d7c10ULL, 0x000fc60009ffe4ffULL,
0x0000000008437faeULL, 0x0007e8000b901c46ULL, 0x000000000a457faeULL, 0x0007e8000b901c46ULL,
0x000000000c477faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000027805ULL, 0x00afe20000015200ULL, 0x01e60007950075a7ULL, 0x004e62000800017fULL,
0x0000000196217824ULL, 0x000fe400078e0a9bULL, 0x0000000404057c24ULL, 0x000fc6000f8e02ffULL,
0x00000008ff217819ULL, 0x000fe20000011621ULL, 0x00008e00ff9c7b82ULL, 0x000ee40000000a00ULL,
0x00000004059c7825ULL, 0x008fe200078e009cULL, 0x00000000005c0947ULL, 0x006fec0003800000ULL,
0x000000ff00087202ULL, 0x000fce0000000f00ULL, 0x000000100800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402097210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000900007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000108087836ULL, 0x000fce0000000000ULL, 0x01e60007950075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000949a00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000207919ULL, 0x000e620000000000ULL,
0x00000008981f7824ULL, 0x140fe200078e0295ULL, 0xffffffff9b1e7810ULL, 0x000fe20007ffe0ffULL,
0x000000099b1d7836ULL, 0x000fe20000000000ULL, 0x0000000104057899ULL, 0x000fe2000800063fULL,
0x00000020981c7824ULL, 0x000fd600078e0295ULL, 0x000000019a037836ULL, 0x008fe20000000000ULL,
0x0000940000047ab9ULL, 0x000fe20000000800ULL, 0x000001009a1b7824ULL, 0x000fc600078e0223ULL,
0x000000940300720cULL, 0x000fe20003f06070ULL, 0x00000004222b7c24ULL, 0x000fd8000f8e021bULL,
0x0000000800f48947ULL, 0x000fea0003800000ULL, 0x00000003ff297819ULL, 0x102fe20000011620ULL,
0x00000010201a7824ULL, 0x040fe200078e00ffULL, 0x0000900000087ab9ULL, 0x000fe20000000a00ULL,
0x0ffffff820187812ULL, 0x000fe200078ec0ffULL, 0x00004000982e7824ULL, 0x000fe200078e0295ULL,
0x0000000429077810ULL, 0x000fe20007ffe0ffULL, 0x0000000829097836ULL, 0x000fe20000000000ULL,
0x000000701a1a7812ULL, 0x000fe200078ec0ffULL, 0x0000000c290b7836ULL, 0x000fe20000000000ULL,
0x0000002029157210ULL, 0x000fe20007ffe0ffULL, 0x0000000107007824ULL, 0x040fe200078e0220ULL,
0x0000002009027210ULL, 0x000fe20007ffe0ffULL, 0x0000000807037824ULL, 0x000fe200078e00ffULL,
0x0000003029317810ULL, 0x000fe20007ffe0ffULL, 0x0000000809057824ULL, 0x000fc400078e00ffULL,
0x000000010b067824ULL, 0x140fe200078e0220ULL, 0xfffffff803167812ULL, 0x000fe200078ee200ULL,
0x000000080b0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff805247812ULL, 0x000fe200078ee202ULL,
0x0000000129057824ULL, 0x000fe200078e022bULL, 0x000000801a027812ULL, 0x000fe200078efcffULL,
0x00000010290f7836ULL, 0x000fe20000000000ULL, 0x000000ff00037202ULL, 0x000fe20000000f00ULL,
0x0000001429177836ULL, 0x000fe20000000000ULL, 0x0000001b96007248ULL, 0x000fe20007fe0000ULL,
0x000000010f087824ULL, 0x000fe200078e0220ULL, 0xfffffff80d267812ULL, 0x000fe200078ee206ULL,
0x0000010005047825ULL, 0x000fe200078e0002ULL, 0x000000001b007210ULL, 0x000fc60007ffe1ffULL,
0x000000080f117824ULL, 0x000fe200078e00ffULL, 0x00000008040c7c10ULL, 0x000fe2000ff1e0ffULL,
0x00000018292d7836ULL, 0x000fe20000000000ULL, 0x000000000700720cULL, 0x0c0fe20003f86070ULL,
0x000040002e197836ULL, 0x000fe20000000000ULL, 0x00000009050d7c10ULL, 0x000fe200087fe4ffULL,
0x0000000107057824ULL, 0x100fe200078e022bULL, 0x000000000900720cULL, 0x0c0fe20003f26070ULL,
0x0000000109077824ULL, 0x000fe200078e022bULL, 0xfffffff811287812ULL, 0x000fe200078ee208ULL,
0x0000010005047825ULL, 0x000fe200078e0002ULL, 0x000000000b00720cULL, 0x000fc40003f46070ULL,
0x000000000f00720cULL, 0x000fe20003f06070ULL, 0x000000010b097824ULL, 0x000fe200078e022bULL,
0x00000008040e7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000010007067825ULL, 0x000fe200078e0002ULL,
0x0000002b0f0b7210ULL, 0x000fe40007ffe0ffULL, 0x00000009050f7c10ULL, 0x000fe20009ffe4ffULL,
0x0000000117117824ULL, 0x000fe200078e022bULL, 0x0000000806107c10ULL, 0x000fe2000ffbe0ffULL,
0x0000010009087825ULL, 0x000fe200078e0002ULL, 0x000000202d2c7210ULL, 0x000fc60007ffe0ffULL,
0x0000010011047825ULL, 0x100fe200078e0002ULL, 0x0000000808087c10ULL, 0x000fe4000ff7e0ffULL,
0x0000000907117c10ULL, 0x000fe2000affe4ffULL, 0x000001000b0a7825ULL, 0x000fe200078e0002ULL,
0x0000000804127c10ULL, 0x000fe4000ffde0ffULL, 0x0000000909097c10ULL, 0x000fe20009ffe4ffULL,
0x000000012d077824ULL, 0x000fe200078e022bULL, 0x0000000905137c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000117067824ULL, 0x040fe200078e0220ULL, 0x000000001700720cULL, 0x000fe20003f66070ULL,
0x0000010007047825ULL, 0x000fe200078e0002ULL, 0x000000080a0a7c10ULL, 0x000fc6000ffbe0ffULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0x000000090b0b7c10ULL, 0x000fe2000affe4ffULL,
0x0000001016277824ULL, 0x000fe200078e0219ULL, 0x0000000804147c10ULL, 0x000fe2000ffde0ffULL,
0x00000020292f7836ULL, 0x000fe20000000000ULL, 0xfffffff8172a7812ULL, 0x000fe200078ee206ULL,
0x0000001c29177836ULL, 0x000fe20000000000ULL, 0x000000002900720cULL, 0x000fe20003fa6070ULL,
0x000000012f077824ULL, 0x100fe200078e022bULL, 0x0000000718047812ULL, 0x000fe200078ef815ULL,
0x0000003829337836ULL, 0x000fe20000000000ULL, 0x0000000905157c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000117057824ULL, 0x000fe200078e022bULL, 0x0000001904257211ULL, 0x000fe200078e20ffULL,
0x0000010007067825ULL, 0x000fc800078e0002ULL, 0x0000010005047825ULL, 0x000fe400078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c257faeULL, 0x0003e2000e901c46ULL,
0x000000002d00720cULL, 0x0c0fe20003fa6070ULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0x0000000804167c10ULL, 0x000fe2000ffde0ffULL, 0x0000000117047824ULL, 0x040fe200078e0220ULL,
0x000000000e277faeULL, 0x0005e2000e101c46ULL, 0x000000001700720cULL, 0x000fe40003f86070ULL,
0xfffffff82d2c7812ULL, 0x000fe200078ee22cULL, 0x00000028292d7836ULL, 0x000fc40000000000ULL,
0x00000008170d7824ULL, 0x002fe200078e00ffULL, 0x0000002429257810ULL, 0x000fe40007ffe0ffULL,
0x0000000905177c10ULL, 0x000fe4000b7fe4ffULL, 0xfffffff80d0c7812ULL, 0x000fe200078ee204ULL,
0x00000010240d7824ULL, 0x100fe200078e0219ULL, 0x0000002025247210ULL, 0x000fe20007ffe0ffULL,
0x00000010260f7824ULL, 0x004fe200078e0219ULL, 0x0000000806067c10ULL, 0x000fe2000ffde0ffULL,
0x0000000125057824ULL, 0x000fe200078e022bULL, 0x00000000100d7faeULL, 0x0003e2000c901c46ULL,
0x000000002f00720cULL, 0x0c0fe20003f26070ULL, 0x000000012f0e7824ULL, 0x040fe200078e0220ULL,
0x0000000907077c10ULL, 0x000fe2000b7fe4ffULL, 0x00000000080f7faeULL, 0x0005e2000d101c46ULL,
0x000000082f2f7824ULL, 0x000fe200078e00ffULL, 0x000000002500720cULL, 0x040fe20003f46070ULL,
0x0000000825257824ULL, 0x000fc400078e00ffULL, 0x0000010005047825ULL, 0x000fe200078e0002ULL,
0xfffffff82f0e7812ULL, 0x000fe400078ee20eULL, 0xfffffff825247812ULL, 0x000fe200078ee224ULL,
0x00000010280d7824ULL, 0x102fe200078e0219ULL, 0x0000000804047c10ULL, 0x000fe2000ffde0ffULL,
0x000000100e257824ULL, 0x100fe200078e0219ULL, 0x000000190c117211ULL, 0x000fe200078e20ffULL,
0x000000102a097824ULL, 0x104fe200078e0219ULL, 0x0000000905057c10ULL, 0x000fe2000b7fe4ffULL,
0x000000102c0f7824ULL, 0x100fe200078e0219ULL, 0x000000000a0d7faeULL, 0x0003e2000c101c46ULL,
0x0000001024277824ULL, 0x000fc400078e0219ULL, 0x0000002c292f7836ULL, 0x000fe20000000000ULL,
0x0000000012097faeULL, 0x0005e2000d901c46ULL, 0x000000003100720cULL, 0x0c0fe20003f66070ULL,
0x0000000131107824ULL, 0x000fe400078e0220ULL, 0x00000000140f7faeULL, 0x0007e2000e901c46ULL,
0x000000002d00720cULL, 0x000fc60003fa6070ULL, 0x0000000016117faeULL, 0x0009e2000e101c46ULL,
0x000000202d0a7210ULL, 0x002fe20007ffe0ffULL, 0x00000001310b7824ULL, 0x100fe200078e022bULL,
0x000000002f00720cULL, 0x080fe20003f86070ULL, 0x000000012d097824ULL, 0x104fe200078e022bULL,
0x0000000006257faeULL, 0x0003e2000c901c46ULL, 0x0000003429137836ULL, 0x000fe20000000000ULL,
0x000000003300720cULL, 0x080fe20003f26070ULL, 0x0000003c29297836ULL, 0x000fe20000000000ULL,
0x0000000004277faeULL, 0x0005e2000d101c46ULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0x000000001300720cULL, 0x0c0fe20003f46070ULL, 0x00000001130d7824ULL, 0x100fe200078e022bULL,
0x000000002900720cULL, 0x000fe20003f06070ULL, 0x00000001330f7824ULL, 0x108fe200078e022bULL,
0xfffffff82d007812ULL, 0x000fe200078ee20aULL, 0x0000000813127824ULL, 0x000fe200078e00ffULL,
0x0000002013117210ULL, 0x010fe20007ffe0ffULL, 0x000000012f077824ULL, 0x002fc400078e022bULL,
0x0000000831317824ULL, 0x000fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee211ULL,
0x0000010009047825ULL, 0x104fe200078e0002ULL, 0x0000002029117210ULL, 0x000fe40007ffe0ffULL,
0xfffffff831107812ULL, 0x000fe200078ee210ULL, 0x0000010007067825ULL, 0x100fe200078e0002ULL,
0x0000000804087c10ULL, 0x000fe4000ffde0ffULL, 0x0000001912157211ULL, 0x000fe200078e20ffULL,
0x0000000833147824ULL, 0x000fe200078e00ffULL, 0x0000000905097c10ULL, 0x000fe2000b7fe4ffULL,
0x000001000b047825ULL, 0x000fe200078e0002ULL, 0x00000008060a7c10ULL, 0x000fc6000ffde0ffULL,
0x000000012f067824ULL, 0x040fe200078e0220ULL, 0x000000032f2f7819ULL, 0x000fe200000006ffULL,
0x0000000829167824ULL, 0x000fe200078e00ffULL, 0x00000009070b7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001010137824ULL, 0x000fe200078e0219ULL, 0x00000008040c7c10ULL, 0x000fe4000ffde0ffULL,
0xfffffff82f0e7812ULL, 0x000fe200078ee206ULL, 0x000001000d067825ULL, 0x000fe200078e0002ULL,
0x00000009050d7c10ULL, 0x000fc6000b7fe4ffULL, 0x000001000f047825ULL, 0x000fe200078e0002ULL,
0x0000000806067c10ULL, 0x000fc6000ffde0ffULL, 0x00000001290f7824ULL, 0x000fe200078e022bULL,
0x0000000907077c10ULL, 0x000fe4000b7fe4ffULL, 0x0000000804047c10ULL, 0x000fe2000ffde0ffULL,
0x000001000f027825ULL, 0x000fc600078e0002ULL, 0x0000000905057c10ULL, 0x000fe2000b7fe4ffULL,
0x00000001330f7824ULL, 0x000fe200078e0220ULL, 0x0000000802027c10ULL, 0x000fc8000ffde0ffULL,
0xfffffff814147812ULL, 0x000fe200078ee20fULL, 0x00000010000f7824ULL, 0x100fe200078e0219ULL,
0xfffffff816007812ULL, 0x000fe200078ee211ULL, 0x000000100e117824ULL, 0x100fe200078e0219ULL,
0x0000000903037c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001014177824ULL, 0x100fe200078e0219ULL,
0x00000000080f7faeULL, 0x0003e2000e901c46ULL, 0x0000001000257824ULL, 0x000fc600078e0219ULL,
0x000000000a117faeULL, 0x0003e8000e101c46ULL, 0x000000000c137faeULL, 0x0003e8000d901c46ULL,
0x0000000006157faeULL, 0x0003e8000d101c46ULL, 0x0000000004177faeULL, 0x0003e8000c901c46ULL,
0x0000000002257faeULL, 0x0003e2000c101c46ULL, 0x0000000800a47947ULL, 0x000fea0003800000ULL,
0x0000000420057811ULL, 0x042fe200078fe8ffULL, 0x00000010201a7824ULL, 0x040fe200078e00ffULL,
0x0000000820077811ULL, 0x040fe200078fe8ffULL, 0x0000900000087ab9ULL, 0x000fe20000000a00ULL,
0x0000000c20097811ULL, 0x040fe200078fe8ffULL, 0x0000000105007824ULL, 0x140fe200078e0220ULL,
0x00000010200b7811ULL, 0x040fe200078fe8ffULL, 0x0000000805037824ULL, 0x000fe200078e00ffULL,
0x0000001c20117811ULL, 0x040fe200078fe8ffULL, 0x00000008070d7824ULL, 0x000fe200078e00ffULL,
0x000000030b367819ULL, 0x000fe200000006ffULL, 0x0000000109027824ULL, 0x140fe200078e0220ULL,
0xfffffff803307812ULL, 0x000fe200078ee200ULL, 0x00000008090f7824ULL, 0x000fe200078e00ffULL,
0x0000002007007210ULL, 0x000fe20007ffe0ffULL, 0x000000010b037824ULL, 0x100fe200078e0220ULL,
0x0000002820177811ULL, 0x040fe200078fe8ffULL, 0x00000008113c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d327812ULL, 0x000fe200078ee200ULL, 0x0000000107077824ULL, 0x100fe200078e022bULL,
0x00000014200d7811ULL, 0x040fe200078fe8ffULL, 0x0000000817427824ULL, 0x000fe200078e00ffULL,
0xfffffff80f347812ULL, 0x000fe200078ee202ULL, 0x0000000109097824ULL, 0x100fe200078e022bULL,
0x00000018200f7811ULL, 0x040fe200078fe8ffULL, 0x000000010d007824ULL, 0x140fe200078e0220ULL,
0xfffffff836367812ULL, 0x000fe200078ee203ULL, 0x000000080d137824ULL, 0x000fe200078e00ffULL,
0x0000002011037210ULL, 0x000fe20007ffe0ffULL, 0x000000010f027824ULL, 0x140fe200078e0220ULL,
0x0000003420277811ULL, 0x040fe200078fe8ffULL, 0x000000080f157824ULL, 0x000fe200078e00ffULL,
0xfffffff813387812ULL, 0x000fe200078ee200ULL, 0x000000010b0b7824ULL, 0x100fe200078e022bULL,
0x0000002020137811ULL, 0x040fe200078fe8ffULL, 0x0000000827487824ULL, 0x000fe200078e00ffULL,
0xfffffff8153a7812ULL, 0x000fe200078ee202ULL, 0x000000010d0d7824ULL, 0x100fe200078e022bULL,
0x0000002420157811ULL, 0x000fe200078fe8ffULL, 0x0000000113007824ULL, 0x140fe200078e0220ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee203ULL, 0x0000000813197824ULL, 0x000fe200078e00ffULL,
0x0000000315257819ULL, 0x040fe200000006ffULL, 0x0000000115027824ULL, 0x100fe200078e0220ULL,
0x000000701a1a7812ULL, 0x000fe200078ec0ffULL, 0x0000000117037824ULL, 0x100fe200078e0220ULL,
0xfffffff8193e7812ULL, 0x000fe200078ee200ULL, 0x0000000111117824ULL, 0x100fe200078e022bULL,
0x0000002c20197811ULL, 0x040fe200078fe8ffULL, 0x0000000113137824ULL, 0x100fe200078e022bULL,
0xfffffff825407812ULL, 0x000fe200078ee202ULL, 0x0000000115157824ULL, 0x100fe200078e022bULL,
0xfffffff842427812ULL, 0x000fe200078ee203ULL, 0x0000000119007824ULL, 0x140fe200078e0220ULL,
0x0000003020257811ULL, 0x040fe200078fe8ffULL, 0x0000000819297824ULL, 0x000fe200078e00ffULL,
0x0000002b05057210ULL, 0x000fe20007ffe0ffULL, 0x0000000127037824ULL, 0x000fe200078e0220ULL,
0x0000002025027210ULL, 0x000fe20007ffe0ffULL, 0x00000008252d7824ULL, 0x000fe200078e00ffULL,
0xfffffff829447812ULL, 0x000fe200078ee200ULL, 0x0000000117177824ULL, 0x100fe200078e022bULL,
0xfffffff848487812ULL, 0x000fe200078ee203ULL, 0x0000000125257824ULL, 0x100fe200078e022bULL,
0x0000003820007811ULL, 0x040fe200078fe8ffULL, 0x0000000127277824ULL, 0x000fe200078e022bULL,
0x0000003c20037811ULL, 0x000fc400078fe8ffULL, 0xfffffff82d467812ULL, 0x000fe200078ee202ULL,
0x0000000100297824ULL, 0x140fe200078e022bULL, 0x00000003002f7819ULL, 0x040fe200000006ffULL,
0x0000000100027824ULL, 0x100fe200078e0220ULL, 0x0000002b0f0f7210ULL, 0x000fe20007ffe0ffULL,
0x00000001032d7824ULL, 0x040fe200078e022bULL, 0x0000002b19197210ULL, 0x000fe20007ffe0ffULL,
0x0000000103007824ULL, 0x040fe200078e0220ULL, 0x000000801a2a7812ULL, 0x000fe200078efcffULL,
0x0000000803317824ULL, 0x000fe200078e00ffULL, 0x0000002b20037211ULL, 0x000fe200078fe8ffULL,
0x000000ffff2b7224ULL, 0x000fe200078e00ffULL, 0xfffffff82f4a7812ULL, 0x000fc400078ee202ULL,
0x00000020202f7211ULL, 0x000fe200078fe8ffULL, 0x0000010003027825ULL, 0x100fe200078e002aULL,
0x00000095982e7211ULL, 0x000fe400078e70ffULL, 0xfffffff8314c7812ULL, 0x000fe200078ee200ULL,
0x0000010009087825ULL, 0x000fe200078e002aULL, 0x0000000802027c10ULL, 0x000fc6000ff1e0ffULL,
0x0000010011107825ULL, 0x100fe200078e002aULL, 0x0000000903037c10ULL, 0x000fe400087fe4ffULL,
0x0000000808087c10ULL, 0x000fe2000ff1e0ffULL, 0x0000010005047825ULL, 0x000fc600078e002aULL,
0x0000000909097c10ULL, 0x000fe200087fe4ffULL, 0x0000010019187825ULL, 0x100fe200078e002aULL,
0x0000000810107c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000804047c10ULL, 0x000fe2000ff3e0ffULL,
0x0000010007067825ULL, 0x100fe200078e002aULL, 0x0000000911117c10ULL, 0x000fe400087fe4ffULL,
0x00000008182c7c10ULL, 0x000fe2000ff1e0ffULL, 0x000001000b0a7825ULL, 0x000fe200078e002aULL,
0x0ffffff820187812ULL, 0x000fc400078ec0ffULL, 0x0000000905057c10ULL, 0x000fe20008ffe4ffULL,
0x000001000d0c7825ULL, 0x100fe200078e002aULL, 0x0000000806067c10ULL, 0x000fe4000ff5e0ffULL,
0x000000080a0a7c10ULL, 0x000fe2000ff3e0ffULL, 0x000001000f0e7825ULL, 0x100fe200078e002aULL,
0x0000000718007812ULL, 0x000fe400078ef82fULL, 0x0000000907077c10ULL, 0x000fe200097fe4ffULL,
0x0000010013127825ULL, 0x000fe200078e002aULL, 0x000000090b0b7c10ULL, 0x000fc40008ffe4ffULL,
0x000000080c0c7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000010015147825ULL, 0x100fe200078e002aULL,
0x0000000812127c10ULL, 0x000fe4000ff3e0ffULL, 0x000000080e0e7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000010017167825ULL, 0x100fe200078e002aULL, 0x000000090d0d7c10ULL, 0x000fe400097fe4ffULL,
0x0000000913137c10ULL, 0x000fe20008ffe4ffULL, 0x0000010025247825ULL, 0x000fe200078e002aULL,
0x000000090f0f7c10ULL, 0x000fc40009ffe4ffULL, 0x0000000814147c10ULL, 0x000fe2000ff5e0ffULL,
0x0000010027267825ULL, 0x100fe200078e002aULL, 0x0000000824247c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000816167c10ULL, 0x000fe2000ff7e0ffULL, 0x0000010029287825ULL, 0x100fe200078e002aULL,
0x0000000915157c10ULL, 0x000fe400097fe4ffULL, 0x0000000925257c10ULL, 0x000fe20008ffe4ffULL,
0x000001002d2a7825ULL, 0x000fe200078e002aULL, 0x00000009192d7c10ULL, 0x000fc400087fe4ffULL,
0x0000000826267c10ULL, 0x000fe2000ff1e0ffULL, 0x000040002e197836ULL, 0x000fe20000000000ULL,
0x0000000917177c10ULL, 0x000fe40009ffe4ffULL, 0x0000000828287c10ULL, 0x000fe2000ff3e0ffULL,
0x00000010002f7824ULL, 0x100fe200078e0219ULL, 0x0000001934357211ULL, 0x000fe200078e20ffULL,
0x0000001030317824ULL, 0x100fe200078e0219ULL, 0x000000082a2a7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001032337824ULL, 0x100fe200078e0219ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000022f7faeULL, 0x0003e2000b901c46ULL, 0x0000001036377824ULL, 0x100fe200078e0219ULL,
0x0000000927277c10ULL, 0x000fe200087fe4ffULL, 0x0000001038397824ULL, 0x100fe200078e0219ULL,
0x0000000004317faeULL, 0x0005e2000b901c46ULL, 0x000000103a3b7824ULL, 0x000fe200078e0219ULL,
0x0000000929297c10ULL, 0x000fc40008ffe4ffULL, 0x0000000006337faeULL, 0x0007e2000b901c46ULL,
0x000000092b2b7c10ULL, 0x000fe200097fe4ffULL, 0x000000103c037824ULL, 0x002fe400078e0219ULL,
0x0000000008357faeULL, 0x0003e2000b901c46ULL, 0x000000193e057211ULL, 0x004fc600078e20ffULL,
0x000000000a377faeULL, 0x0005e2000b901c46ULL, 0x0000001040077824ULL, 0x008fc600078e0219ULL,
0x000000000c397faeULL, 0x0007e2000b901c46ULL, 0x0000001042097824ULL, 0x002fc600078e0219ULL,
0x000000000e3b7faeULL, 0x0003e2000b901c46ULL, 0x00000010440b7824ULL, 0x004fc600078e0219ULL,
0x0000000010037faeULL, 0x0005e2000b901c46ULL, 0x00000010460d7824ULL, 0x008fc600078e0219ULL,
0x0000000012057faeULL, 0x0007e2000b901c46ULL, 0x00000019480f7211ULL, 0x002fc600078e20ffULL,
0x0000000014077faeULL, 0x0007e2000b901c46ULL, 0x000000104a037824ULL, 0x004fc600078e0219ULL,
0x0000000016097faeULL, 0x0007e2000b901c46ULL, 0x000000104c117824ULL, 0x000fc600078e0219ULL,
0x000000002c0b7faeULL, 0x0007e8000b901c46ULL, 0x00000000240d7faeULL, 0x0007e8000b901c46ULL,
0x00000000260f7faeULL, 0x0007e8000b901c46ULL, 0x0000000028037faeULL, 0x0007e8000b901c46ULL,
0x000000002a117faeULL, 0x0007e4000b901c46ULL, 0x0000000820037812ULL, 0x04afe200078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000004ff117819ULL, 0x100fe20000011620ULL,
0x000020002e177836ULL, 0x000fe20000000000ULL, 0x0000000703147812ULL, 0x000fe400078ef820ULL,
0x0000000720167812ULL, 0x000fe200078ec0ffULL, 0x0000000811037824ULL, 0x000fe200078e00ffULL,
0x00000003ff157819ULL, 0x000fe20000011620ULL, 0x0000001014047824ULL, 0x040fe200078e00ffULL,
0x0000001411137210ULL, 0x000fe20007ffe0ffULL, 0x0000001014087824ULL, 0x000fe200078e00ffULL,
0xfffffff8035c7812ULL, 0x000fc400078ee216ULL, 0x0000000115057812ULL, 0x000fe200078ec0ffULL,
0x0000000213077836ULL, 0x000fe20000000000ULL, 0x000000305c007810ULL, 0x000fe20007ffe0ffULL,
0x000000105c6c7836ULL, 0x000fe20000000000ULL, 0x0000001014127812ULL, 0x000fe200078efcffULL,
0x000000205c037836ULL, 0x000fe20000000000ULL, 0xfffffff004047812ULL, 0x000fe200078ee213ULL,
0x000000085c097824ULL, 0x000fe200078e00ffULL, 0x0000005c05027210ULL, 0x000fe20007ffe0ffULL,
0x00000001050f7824ULL, 0x040fe200078e026cULL, 0xfffffff008087812ULL, 0x000fe200078ee207ULL,
0x00000001050e7824ULL, 0x040fe200078e0203ULL, 0xfffffff809107812ULL, 0x000fe200078ee202ULL,
0x00000001050d7824ULL, 0x000fe200078e0200ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000086c0a7824ULL, 0x000fe200078e00ffULL, 0x0000000303267819ULL, 0x000fe200000006ffULL,
0x00000008000c7824ULL, 0x000fe200078e00ffULL, 0x0000000414767819ULL, 0x000fe200000006ffULL,
0x0000000111117824ULL, 0x000fe200078e0212ULL, 0xfffffff80a0f7812ULL, 0x000fe200078ee20fULL,
0x0000001012067824ULL, 0x040fe200078e00ffULL, 0xfffffff80c0d7812ULL, 0x000fe200078ee20dULL,
0x0000000803057824ULL, 0x000fe200078e00ffULL, 0x00000004120a7819ULL, 0x000fe200000006ffULL,
0x0000001004047824ULL, 0x000fe200078e0295ULL, 0xfffffff006067812ULL, 0x000fe200078ee211ULL,
0x0000001010507824ULL, 0x100fe200078e0217ULL, 0xfffffff8050e7812ULL, 0x000fe200078ee20eULL,
0x000000100d8c7824ULL, 0x000fe200078e0217ULL, 0x000000000454783bULL, 0x0003e20000000200ULL,
0x0000009506067211ULL, 0x000fe200078e20ffULL, 0x0000000211097836ULL, 0x000fe20000000000ULL,
0x000000170e647211ULL, 0x000fe200078e20ffULL, 0x000000005050783bULL, 0x000ea20000000200ULL,
0x00000012020b7836ULL, 0x000fc40000000000ULL, 0x000000086c247824ULL, 0x000fe200078e00ffULL,
0x000000000658783bULL, 0x000ee20000000200ULL, 0x000000100f047824ULL, 0x002fe200078e0217ULL,
0xfffffff00a0a7812ULL, 0x000fe200078ee209ULL, 0x000000085c257824ULL, 0x000fe200078e00ffULL,
0x000000006464783bULL, 0x000fe20000000200ULL, 0x00000002020c7836ULL, 0x000fe20000000000ULL,
0xfffffff8240b7812ULL, 0x000fe200078ee20bULL, 0x0000002202097836ULL, 0x000fe20000000000ULL,
0x000000000404783bULL, 0x000e620000000200ULL, 0x0000003202247836ULL, 0x000fe20000000000ULL,
0xfffffff8250c7812ULL, 0x000fe200078ee20cULL, 0x000000100a847824ULL, 0x100fe200078e0295ULL,
0x000000008c8c783bULL, 0x000f220000000200ULL, 0x0000000300257819ULL, 0x000fe200000006ffULL,
0x0000001008087824ULL, 0x000fe200078e0295ULL, 0xfffffff8260a7812ULL, 0x000fe200078ee209ULL,
0x000000100c2c7824ULL, 0x100fe200078e0217ULL, 0xfffffff825097812ULL, 0x000fe200078ee224ULL,
0x000000100b4c7824ULL, 0x100fe200078e0217ULL, 0x000000000844783bULL, 0x000be20000000200ULL,
0x000000100a607824ULL, 0x000fc400078e0217ULL, 0x0000001009887824ULL, 0x000fe200078e0217ULL,
0x000000002c2c783bULL, 0x000f220000000200ULL, 0x0000001012787824ULL, 0x000fe400078e00ffULL,
0x00000008007c7824ULL, 0x000fe200078e00ffULL, 0x000000008484783bULL, 0x000f220000000200ULL,
0x0000000413087836ULL, 0x020fe40000000000ULL, 0x0000000611757836ULL, 0x000fe20000000000ULL,
0x000000004c4c783bULL, 0x000f620000000200ULL, 0x0000000803797824ULL, 0x000fc400078e00ffULL,
0x0000003602777836ULL, 0x000fe20000000000ULL, 0x000000006060783bULL, 0x000f220000000200ULL,
0x000000505490723cULL, 0x004fe200000018ffULL, 0x000000086c7a7824ULL, 0x000fe400078e00ffULL,
0x000000008888783bULL, 0x000ea60000000200ULL, 0x000000505824723cULL, 0x008fec00000018ffULL,
0x000000525428723cULL, 0x000fec00000018ffULL, 0x000000525850723cULL, 0x000fec00000018ffULL,
0x000000045430723cULL, 0x002fec00000018ffULL, 0x000000065434723cULL, 0x000fec00000018ffULL,
0x000000645438723cULL, 0x000fec00000018ffULL, 0x00000066543c723cULL, 0x000fec00000018ffULL,
0x0000008c5440723cULL, 0x010fec00000018ffULL, 0x0000008e5454723cULL, 0x000fec00000018ffULL,
0x000000045848723cULL, 0x000fec00000018ffULL, 0x000000065804723cULL, 0x000fec00000018ffULL,
0x0000002c4490723cULL, 0x000fec0000001890ULL, 0x0000002c8424723cULL, 0x000fec0000001824ULL,
0x0000002e4428723cULL, 0x000fec0000001828ULL, 0x0000002e842c723cULL, 0x000fec0000001850ULL,
0x0000004c4430723cULL, 0x020fec0000001830ULL, 0x0000004e4434723cULL, 0x000fec0000001834ULL,
0x000000604438723cULL, 0x000fec0000001838ULL, 0x00000062443c723cULL, 0x000fec000000183cULL,
0x000000884440723cULL, 0x004fec0000001840ULL, 0x000000645850723cULL, 0x000fec00000018ffULL,
0x0000008c5870723cULL, 0x000fec00000018ffULL, 0x0000008a4444723cULL, 0x000fec0000001854ULL,
0x000000665864723cULL, 0x000fe200000018ffULL, 0x0000001014577824ULL, 0x000fc400078e00ffULL,
0x0000000613557836ULL, 0x000fc60000000000ULL, 0x0000008e588c723cULL, 0x000fe200000018ffULL,
0xfffffff057547812ULL, 0x000fe200078ee208ULL, 0x000000085c577824ULL, 0x000fe200078e00ffULL,
0xfffffff076767812ULL, 0x000fe200078ee255ULL, 0x0000000800557824ULL, 0x000fe200078e00ffULL,
0x0000009554547211ULL, 0x000fe200078e20ffULL, 0x0000004c8448723cULL, 0x000fe20000001848ULL,
0x0000001012597824ULL, 0x000fe400078e00ffULL, 0x000000085c587824ULL, 0x000fe400078e00ffULL,
0x00000008035a7824ULL, 0x000fe200078e00ffULL, 0x000000608450723cULL, 0x000fe20000001850ULL,
0x00000004024d7836ULL, 0x000fe20000000000ULL, 0x00000004114c7810ULL, 0x000fe20007ffe0ffULL,
0x0000002602007836ULL, 0x000fe20000000000ULL, 0x0000001602037810ULL, 0x000fe20007ffe0ffULL,
0x0000001076767824ULL, 0x100fe200078e0295ULL, 0xfffffff059567812ULL, 0x000fe200078ee24cULL,
0x000000628460723cULL, 0x000fe20000001864ULL, 0xfffffff858087812ULL, 0x000fe200078ee24dULL,
0x000000086c587824ULL, 0x000fe200078e00ffULL, 0xfffffff87a037812ULL, 0x000fe200078ee203ULL,
0x00000010565c7824ULL, 0x000fc400078e0295ULL, 0x0000004e844c723cULL, 0x000fe40000001804ULL,
0x0000001003807824ULL, 0x000fe400078e0217ULL, 0x000000005c5c783bULL, 0x000fe40000000200ULL,
0x000000888470723cULL, 0x000fe20000001870ULL, 0x0000002402057836ULL, 0x000fe20000000000ULL,
0x0000003402067810ULL, 0x000fe20007ffe0ffULL, 0x0000000602047836ULL, 0x000fe20000000000ULL,
0x000000008080783bULL, 0x000fe20000000200ULL, 0x0000001402077836ULL, 0x000fe20000000000ULL,
0xfffffff85a057812ULL, 0x000fe200078ee205ULL, 0x0000008a8484723cULL, 0x000fe2000000188cULL,
0xfffffff855067812ULL, 0x000fc400078ee206ULL, 0xfffffff857047812ULL, 0x000fe200078ee204ULL,
0x0000001005687824ULL, 0x100fe200078e0217ULL, 0x000000005454783bULL, 0x000fe20000000200ULL,
0xfffffff858077812ULL, 0x000fe200078ee207ULL, 0x0000001008587824ULL, 0x100fe200078e0217ULL,
0xfffffff879027812ULL, 0x000fe400078ee200ULL, 0x000000006868783bULL, 0x000e620000000200ULL,
0x0000001007747824ULL, 0x100fe200078e0217ULL, 0x00000017066d7211ULL, 0x000fe200078e20ffULL,
0x00000010029e7824ULL, 0x100fe200078e0217ULL, 0xfffffff87c007812ULL, 0x000fe200078ee277ULL,
0x000000005858783bULL, 0x000ea80000000200ULL, 0x000000007464783bULL, 0x0007220000000200ULL,
0x0000001000887824ULL, 0x000fc600078e0217ULL, 0x000000006d6c783bULL, 0x000f620000000200ULL,
0xfffffff078747812ULL, 0x008fc600078ee275ULL, 0x000000009e8c783bULL, 0x000fe20000000200ULL,
0x0000001704787211ULL, 0x000fe200078e20ffULL, 0x00000010747c7824ULL, 0x000fe400078e0295ULL,
0x000000008888783bULL, 0x000fe80000000200ULL, 0x000000007674783bULL, 0x000ee80000000200ULL,
0x000000007c7c783bULL, 0x000ee80000000200ULL, 0x000000007878783bULL, 0x000ee20000000200ULL,
0x000000685438723cULL, 0x002fec0000001838ULL, 0x000000685c50723cULL, 0x000fec0000001850ULL,
0x000000585490723cULL, 0x004fec0000001890ULL, 0x000000585c24723cULL, 0x000fec0000001824ULL,
0x0000005a5428723cULL, 0x000fec0000001828ULL, 0x0000005a5c2c723cULL, 0x000fec000000182cULL,
0x000000645430723cULL, 0x010fec0000001830ULL, 0x000000665434723cULL, 0x000fec0000001834ULL,
0x0000006a543c723cULL, 0x000fec000000183cULL, 0x0000006c5440723cULL, 0x020fec0000001840ULL,
0x0000006e5444723cULL, 0x000fec0000001844ULL, 0x000000645c48723cULL, 0x000fec0000001848ULL,
0x000000665c4c723cULL, 0x000fec000000184cULL, 0x0000006c5c70723cULL, 0x000fec0000001870ULL,
0x0000006a5c60723cULL, 0x000fec0000001860ULL, 0x0000006e5c84723cULL, 0x000fec0000001884ULL,
0x0000008c7438723cULL, 0x008fec0000001838ULL, 0x0000008c7c50723cULL, 0x000fec0000001850ULL,
0x000000787490723cULL, 0x000fe20000001890ULL, 0x0000009a998c7210ULL, 0x000fca0007ffe0ffULL,
0x000000018c557836ULL, 0x000fe20000000000ULL, 0x000000787c24723cULL, 0x000fe80000001824ULL,
0x000000945500720cULL, 0x000fe20003f06070ULL, 0x000001008c557824ULL, 0x000fe200078e0223ULL,
0x0000007a7428723cULL, 0x000fe60000001828ULL, 0x0000000422567c24ULL, 0x000fc6000f8e0255ULL,
0x0000007a7c2c723cULL, 0x000fec000000182cULL, 0x000000807430723cULL, 0x000fec0000001830ULL,
0x000000827434723cULL, 0x000fec0000001834ULL, 0x000000887440723cULL, 0x000fec0000001840ULL,
0x0000008e743c723cULL, 0x000fec000000183cULL, 0x0000008a7444723cULL, 0x000fec0000001844ULL,
0x000000807c48723cULL, 0x000fec0000001848ULL, 0x000000827c4c723cULL, 0x000fec000000184cULL,
0x0000008e7c60723cULL, 0x000fec0000001860ULL, 0x000000887c70723cULL, 0x000fec0000001870ULL,
0x0000008a7c84723cULL, 0x000fe20000001884ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000c00108947ULL, 0x000fde0003800000ULL, 0x0000000415597836ULL, 0x000fe20000000000ULL,
0x0000005596587248ULL, 0x000fe20007fe0000ULL, 0x00000008155d7836ULL, 0x000fe20000000000ULL,
0x0000002015577210ULL, 0x000fe20007ffe0ffULL, 0x0000000159547824ULL, 0x140fe200078e0220ULL,
0x0000005855587210ULL, 0x000fe20007ffe1ffULL, 0x00000008595b7824ULL, 0x000fe200078e00ffULL,
0x0000000718187812ULL, 0x000fe200078ef857ULL, 0x000000015d5a7824ULL, 0x040fe200078e0220ULL,
0x000000585d00720cULL, 0x0c0fe20003f66070ULL, 0x000000085d5f7824ULL, 0x000fe200078e00ffULL,
0xfffffff85b647812ULL, 0x000fe200078ee254ULL, 0x0000001015657836ULL, 0x000fe20000000000ULL,
0x000000585900720cULL, 0x080fe20003f46070ULL, 0x0000000115547824ULL, 0x000fe200078e0256ULL,
0xfffffff85f6c7812ULL, 0x000fe200078ee25aULL, 0x00000001655b7824ULL, 0x040fe200078e0220ULL,
0x00000056595a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000865747824ULL, 0x040fe200078e00ffULL,
0x000000586500720cULL, 0x080fe20003f86070ULL, 0x0000010054547825ULL, 0x000fe200078e00ffULL,
0x000000581500720cULL, 0x000fc40003f26070ULL, 0xfffffff874747812ULL, 0x000fe200078ee25bULL,
0x00000014156d7836ULL, 0x000fe20000000000ULL, 0x0000001a545e7212ULL, 0x000fe200078efcffULL,
0x000001005a5a7825ULL, 0x000fc600078e00ffULL, 0x000000206d547210ULL, 0x000fe20007ffe0ffULL,
0x0000000c15577836ULL, 0x000fe20000000000ULL, 0x000000085e5e7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000086d5f7824ULL, 0x000fe200078e00ffULL, 0x0000001a5a667212ULL, 0x000fe200078efcffULL,
0x00000001575c7824ULL, 0x040fe200078e0256ULL, 0x00000056655a7210ULL, 0x000fe20007ffe0ffULL,
0x0000000157597824ULL, 0x000fe200078e0220ULL, 0xfffffff85f767812ULL, 0x000fe200078ee254ULL,
0x000000015d547824ULL, 0x000fe200078e0256ULL, 0x00000009555f7c10ULL, 0x000fe200087fe4ffULL,
0x000001005c5c7825ULL, 0x000fe200078e00ffULL, 0x0000000866667c10ULL, 0x000fc4000ff1e0ffULL,
0x000000585700720cULL, 0x040fe20003fa6070ULL, 0x00000008576e7824ULL, 0x000fe200078e00ffULL,
0x000000095b677c10ULL, 0x000fe200087fe4ffULL, 0x0000010054547825ULL, 0x000fe200078e00ffULL,
0x0000001a5c6a7212ULL, 0x080fe400078efcffULL, 0xfffffff86e6e7812ULL, 0x000fe200078ee259ULL,
0x000001005a5a7825ULL, 0x000fe200078e00ffULL, 0x0000001a54687212ULL, 0x080fe400078efcffULL,
0x000000086a6a7c10ULL, 0x000fe2000ffde0ffULL, 0x0000001815597836ULL, 0x000fe20000000000ULL,
0x0000001a5a547212ULL, 0x000fe200078efcffULL, 0x000000016d5a7824ULL, 0x000fe200078e0256ULL,
0x0000000868687c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000159577824ULL, 0x040fe200078e0220ULL,
0x000000095d6b7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000859787824ULL, 0x040fe200078e00ffULL,
0x0000001c15657810ULL, 0x000fe20007ffe0ffULL, 0x00000001595c7824ULL, 0x000fe200078e0256ULL,
0x0000000854547c10ULL, 0x000fe2000ffde0ffULL, 0x00000034156f7836ULL, 0x000fe20000000000ULL,
0xfffffff878787812ULL, 0x000fe200078ee257ULL, 0x0000001018577824ULL, 0x000fe200078e0217ULL,
0x0000000955697c10ULL, 0x000fe200087fe4ffULL, 0x0000000165187824ULL, 0x040fe200078e0220ULL,
0x000000095b557c10ULL, 0x000fe2000b7fe4ffULL, 0x00000008655d7824ULL, 0x000fe200078e00ffULL,
0x000000586d00720cULL, 0x080fe20003f06070ULL, 0x000001005a5a7825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000005e577faeULL, 0x0003e2000c901c46ULL,
0x000000585900720cULL, 0x000fc40003f26070ULL, 0xfffffff85d7a7812ULL, 0x000fe200078ee218ULL,
0x000001005c5c7825ULL, 0x000fe200078e00ffULL, 0x0000001a5a5a7212ULL, 0x000fc600078efcffULL,
0x00000020156d7836ULL, 0x000fe20000000000ULL, 0x000000085a5a7c10ULL, 0x000fe2000ffde0ffULL,
0x0000003815757836ULL, 0x000fe40000000000ULL, 0x00000001655e7824ULL, 0x002fe200078e0256ULL,
0x000000206d597210ULL, 0x000fe20007ffe0ffULL, 0x0000001064577824ULL, 0x100fe200078e0217ULL,
0x0000001a5c647212ULL, 0x000fe200078efcffULL, 0x000000086d7c7824ULL, 0x000fe200078e00ffULL,
0x000000566d187210ULL, 0x000fe20007ffe0ffULL, 0x000001005e5e7825ULL, 0x000fe200078e00ffULL,
0x000000095b5b7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000066577faeULL, 0x0003e2000d101c46ULL,
0x0000000864647c10ULL, 0x000fe2000ffde0ffULL, 0x0000003c15777836ULL, 0x000fe20000000000ULL,
0xfffffff87c7c7812ULL, 0x000fe200078ee259ULL, 0x000000106c597824ULL, 0x000fe200078e0217ULL,
0x000000586500720cULL, 0x000fc40003f46070ULL, 0x0000001a5e5c7212ULL, 0x000fe400078efcffULL,
0x000000095d657c10ULL, 0x000fe2000b7fe4ffULL, 0x00000024155d7836ULL, 0x000fe20000000000ULL,
0x000000085c5c7c10ULL, 0x000fe2000ffde0ffULL, 0x0000010018667825ULL, 0x002fe200078e00ffULL,
0x0000000068597faeULL, 0x0003e2000d901c46ULL, 0x000000586d00720cULL, 0x000fe40003f66070ULL,
0x000000106e577824ULL, 0x000fe200078e0217ULL, 0x0000001a665e7212ULL, 0x000fe200078efcffULL,
0x000000015d187824ULL, 0x000fc600078e0220ULL, 0x000000006a577faeULL, 0x0005e2000e901c46ULL,
0x000000585d00720cULL, 0x040fe20003fa6070ULL, 0x000000085d597824ULL, 0x002fe200078e00ffULL,
0x000000565d687210ULL, 0x000fe40007ffe0ffULL, 0x000000095f5d7c10ULL, 0x000fe4000b7fe4ffULL,
0x000000085e5e7c10ULL, 0x000fe2000ffde0ffULL, 0x0000010068687825ULL, 0x000fe200078e00ffULL,
0xfffffff8596c7812ULL, 0x000fe400078ee218ULL, 0x00000009675f7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000002815577836ULL, 0x004fe20000000000ULL, 0x0000001a686a7212ULL, 0x000fe200078efcffULL,
0x0000001074597824ULL, 0x000fc400078e0217ULL, 0x0000000157667824ULL, 0x040fe200078e0220ULL,
0x0000005657187210ULL, 0x000fe20007ffe0ffULL, 0x0000000857677824ULL, 0x040fe200078e00ffULL,
0x0000000054597faeULL, 0x0003e2000e101c46ULL, 0x000000585700720cULL, 0x080fe20003f86070ULL,
0x0000001076577824ULL, 0x000fe200078e0217ULL, 0x000000086a6a7c10ULL, 0x000fe4000ffde0ffULL,
0xfffffff8676e7812ULL, 0x000fe200078ee266ULL, 0x0000002c15677836ULL, 0x000fe20000000000ULL,
0x00000009696b7c10ULL, 0x000fe2000b7fe4ffULL, 0x000000005a577faeULL, 0x0005e4000c101c46ULL,
0x0000000167667824ULL, 0x040fe200078e0256ULL, 0x000000586700720cULL, 0x000fe20003f06070ULL,
0x0000010018547825ULL, 0x002fe200078e00ffULL, 0x0000002067187210ULL, 0x000fc60007ffe0ffULL,
0x0000003015597836ULL, 0x000fe20000000000ULL, 0x0000001a54547212ULL, 0x080fe200078efcffULL,
0x0000000867697824ULL, 0x000fe400078e00ffULL, 0x0000010066667825ULL, 0x000fe200078e00ffULL,
0x0000000854547c10ULL, 0x000fe4000ffde0ffULL, 0xfffffff869187812ULL, 0x000fe200078ee218ULL,
0x0000000159687824ULL, 0x000fe200078e0256ULL, 0x0000001a665a7212ULL, 0x004fe200078efcffULL,
0x0000001078577824ULL, 0x000fe200078e0217ULL, 0x0000000955557c10ULL, 0x000fe2000b7fe4ffULL,
0x0000010068687825ULL, 0x000fe200078e00ffULL, 0x000000085a5a7c10ULL, 0x000fc4000ffde0ffULL,
0x0000000064577faeULL, 0x0003e2000c901c46ULL, 0x00000001596d7824ULL, 0x040fe200078e0220ULL,
0x0000001a68667212ULL, 0x000fe400078efcffULL, 0x0000000359687819ULL, 0x000fe400000006ffULL,
0x00000009675b7c10ULL, 0x000fe4000b7fe4ffULL, 0x0000000866667c10ULL, 0x000fe4000ffde0ffULL,
0xfffffff868687812ULL, 0x000fe200078ee26dULL, 0x000000107a6d7824ULL, 0x100fe200078e0217ULL,
0x0000000969677c10ULL, 0x000fe2000b7fe4ffULL, 0x000000016f647824ULL, 0x002fe200078e0256ULL,
0x000000176c697211ULL, 0x000fe200078e20ffULL, 0x000000107c577824ULL, 0x000fe200078e0217ULL,
0x000000585900720cULL, 0x080fe20003f26070ULL, 0x0000010064647825ULL, 0x000fe200078e00ffULL,
0x000000005c6d7faeULL, 0x0003e2000d101c46ULL, 0x000000587700720cULL, 0x000fc40003f46070ULL,
0x0000000175597824ULL, 0x140fe200078e0256ULL, 0x000000005e577faeULL, 0x0005e2000d901c46ULL,
0x000000587500720cULL, 0x000fe20003f66070ULL, 0x0000000177567824ULL, 0x000fe200078e0256ULL,
0x0000001a64647212ULL, 0x000fe200078efcffULL, 0x000000006a697faeULL, 0x0007e2000e901c46ULL,
0x000000586f00720cULL, 0x000fe20003fa6070ULL, 0x0000010059587825ULL, 0x000fe200078e00ffULL,
0x0000000864647c10ULL, 0x000fc6000ffde0ffULL, 0x000000016f5c7824ULL, 0x142fe200078e0220ULL,
0x0000001a58587212ULL, 0x080fe200078efcffULL, 0x0000010056567825ULL, 0x004fe200078e00ffULL,
0x000000036f6f7819ULL, 0x000fe400000006ffULL, 0x0000000965657c10ULL, 0x000fe2000b7fe4ffULL,
0x00000001755d7824ULL, 0x100fe200078e0220ULL, 0x00000003776a7819ULL, 0x008fe200000006ffULL,
0x00000008755e7824ULL, 0x000fe200078e00ffULL, 0x0000000858587c10ULL, 0x000fe2000ffde0ffULL,
0x00000001775f7824ULL, 0x000fe200078e0220ULL, 0x0000001a561a7212ULL, 0x000fe200078efcffULL,
0x0000001068697824ULL, 0x000fe200078e0217ULL, 0xfffffff86f5c7812ULL, 0x000fc400078ee25cULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee25dULL, 0x000000106e5d7824ULL, 0x100fe200078e0217ULL,
0xfffffff86a6a7812ULL, 0x000fe200078ee25fULL, 0x00000010185f7824ULL, 0x100fe200078e0217ULL,
0x0000000959597c10ULL, 0x000fe2000b7fe4ffULL, 0x000000105c6b7824ULL, 0x100fe200078e0217ULL,
0x000000081a567c10ULL, 0x000fe2000ffde0ffULL, 0x00000000545d7faeULL, 0x0003e2000e101c46ULL,
0x000000175e6d7211ULL, 0x000fe200078e20ffULL, 0x000000106a177824ULL, 0x000fe200078e0217ULL,
0x0000000957577c10ULL, 0x000fe2000b7fe4ffULL, 0x000000005a5f7faeULL, 0x0003e8000c101c46ULL,
0x0000000066697faeULL, 0x0003e8000c901c46ULL, 0x00000000646b7faeULL, 0x0003e8000e901c46ULL,
0x00000000586d7faeULL, 0x0003e8000d901c46ULL, 0x0000000056177faeULL, 0x0003e2000d101c46ULL,
0x0000000800c47947ULL, 0x000fea0003800000ULL, 0x0000000415577836ULL, 0x000fe20000000000ULL,
0x0000001c15677810ULL, 0x000fe20007ffe0ffULL, 0x0000000115557824ULL, 0x100fe200078e0220ULL,
0x0000000c155b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000157547824ULL, 0x140fe200078e0220ULL,
0x0000003c157f7810ULL, 0x000fe20007ffe0ffULL, 0x00000008575f7824ULL, 0x000fe200078e00ffULL,
0x0000000718187812ULL, 0x000fe200078ef855ULL, 0x0000000815597836ULL, 0x000fe20000000000ULL,
0x000000205b5d7210ULL, 0x000fe20007ffe0ffULL, 0x0000001015557836ULL, 0x000fe20000000000ULL,
0xfffffff85f5a7812ULL, 0x000fe200078ee254ULL, 0x0000000159587824ULL, 0x000fc400078e0220ULL,
0x0000000859657824ULL, 0x000fe400078e00ffULL, 0x0000000155547824ULL, 0x140fe400078e0220ULL,
0x00000008556b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8655c7812ULL, 0x000fe200078ee258ULL,
0x00000014155f7836ULL, 0x000fe40000000000ULL, 0x0000000167697824ULL, 0x040fe200078e0220ULL,
0xfffffff86b647812ULL, 0x000fe200078ee254ULL, 0x00000008676a7824ULL, 0x000fe200078e00ffULL,
0x00000024156b7810ULL, 0x000fe20007ffe0ffULL, 0x000000085b5e7824ULL, 0x000fc400078e00ffULL,
0x0000001815657836ULL, 0x000fe20000000000ULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee269ULL,
0x000000015f587824ULL, 0x140fe200078e0220ULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee25dULL,
0x000000085f6d7824ULL, 0x000fe200078e00ffULL, 0x00000020655d7210ULL, 0x000fe20007ffe0ffULL,
0x0000002c156f7836ULL, 0x000fe20000000000ULL, 0x000000565f5f7210ULL, 0x000fe20007ffe0ffULL,
0x0000002015697836ULL, 0x000fe20000000000ULL, 0xfffffff86d667812ULL, 0x000fe200078ee258ULL,
0x0000000865687824ULL, 0x000fe200078e00ffULL, 0x000000206b587210ULL, 0x000fe20007ffe0ffULL,
0x000000086b797824ULL, 0x000fe200078e00ffULL, 0x000000036f767819ULL, 0x040fe200000006ffULL,
0x000000016f757824ULL, 0x100fe200078e0220ULL, 0xfffffff868687812ULL, 0x000fe200078ee25dULL,
0x00000028156d7836ULL, 0x000fe20000000000ULL, 0xfffffff8796e7812ULL, 0x000fe200078ee258ULL,
0x0000000169547824ULL, 0x140fe200078e0220ULL, 0xfffffff876767812ULL, 0x000fe200078ee275ULL,
0x0000000869777824ULL, 0x000fe200078e00ffULL, 0x00000017688d7211ULL, 0x080fe200078e20ffULL,
0x000000016d5d7824ULL, 0x040fe200078e0220ULL, 0x0000001776a57211ULL, 0x000fe200078e20ffULL,
0x000000086d747824ULL, 0x000fe200078e00ffULL, 0xfffffff8776c7812ULL, 0x000fe200078ee254ULL,
0x0000003015757836ULL, 0x000fe20000000000ULL, 0x000000566d6d7210ULL, 0x000fe20007ffe0ffULL,
0x0000003415797836ULL, 0x000fe20000000000ULL, 0xfffffff874747812ULL, 0x000fe200078ee25dULL,
0x00000038157b7836ULL, 0x000fc40000000000ULL, 0x0000000115547824ULL, 0x100fe200078e0256ULL,
0x00000056797a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000175777824ULL, 0x000fe200078e0256ULL,
0x000000037b7e7819ULL, 0x000fe200000006ffULL, 0x0000000175587824ULL, 0x040fe400078e0220ULL,
0x0000000875817824ULL, 0x000fe400078e00ffULL, 0x00000001555d7824ULL, 0x000fe400078e0256ULL,
0x0000000179757824ULL, 0x040fe200078e0220ULL, 0xfffffff881787812ULL, 0x000fe200078ee258ULL,
0x00000008797c7824ULL, 0x000fc400078e00ffULL, 0x000000017b797824ULL, 0x040fe400078e0256ULL,
0x000000017b7d7824ULL, 0x000fe200078e0220ULL, 0xfffffff87c7c7812ULL, 0x000fe200078ee275ULL,
0x0000010054547825ULL, 0x000fc600078e00ffULL, 0xfffffff87e7e7812ULL, 0x000fe200078ee27dULL,
0x0000000157577824ULL, 0x100fe200078e0256ULL, 0x0000001a54547212ULL, 0x000fe200078efcffULL,
0x0000000159597824ULL, 0x100fe400078e0256ULL, 0x000000015b5b7824ULL, 0x100fe200078e0256ULL,
0x0000000854547c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000165657824ULL, 0x100fe400078e0256ULL,
0x0000000167677824ULL, 0x100fe200078e0256ULL, 0x0000000955557c10ULL, 0x000fe200087fe4ffULL,
0x0000000169697824ULL, 0x000fc400078e0256ULL, 0x000000016b6b7824ULL, 0x100fe400078e0256ULL,
0x000000016f6f7824ULL, 0x100fe400078e0256ULL, 0x000000017f7b7824ULL, 0x040fe400078e0256ULL,
0x000000017f567824ULL, 0x040fe400078e0220ULL, 0x000000087f7f7824ULL, 0x000fe400078e00ffULL,
0x0000010059587825ULL, 0x000fc600078e00ffULL, 0xfffffff87f807812ULL, 0x000fe200078ee256ULL,
0x000000105e837824ULL, 0x000fe200078e0217ULL, 0x000000175a7f7211ULL, 0x000fe200078e20ffULL,
0x000001005b5a7825ULL, 0x000fe200078e00ffULL, 0x0000001a58587212ULL, 0x000fc600078efcffULL,
0x000001005f5e7825ULL, 0x000fe200078e00ffULL, 0x0000000858587c10ULL, 0x000fe4000ff1e0ffULL,
0x0000001a5a5a7212ULL, 0x080fe200078efcffULL, 0x00000010668b7824ULL, 0x000fe200078e0217ULL,
0x0000000959597c10ULL, 0x000fe200087fe4ffULL, 0x0000010067667825ULL, 0x000fe200078e00ffULL,
0x000000085a5a7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000001a5e5e7212ULL, 0x000fe200078efcffULL,
0x0000010057567825ULL, 0x000fe200078e00ffULL, 0x000000095b5b7c10ULL, 0x000fc400087fe4ffULL,
0x000000085e5e7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000106a8f7824ULL, 0x100fe200078e0217ULL,
0x0000001a66667212ULL, 0x080fe200078efcffULL, 0x000000105c817824ULL, 0x100fe200078e0217ULL,
0x0000001a56567212ULL, 0x080fe200078efcffULL, 0x000001006b6a7825ULL, 0x000fe200078e00ffULL,
0x000000095f5f7c10ULL, 0x000fe400087fe4ffULL, 0x0000000866667c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001064897824ULL, 0x000fe200078e0217ULL, 0x0000000856567c10ULL, 0x000fe2000ff3e0ffULL,
0x000001005d5c7825ULL, 0x000fe200078e00ffULL, 0x0000001a6a6a7212ULL, 0x000fc400078efcffULL,
0x0000000967677c10ULL, 0x000fe200087fe4ffULL, 0x0000010065647825ULL, 0x000fe200078e00ffULL,
0x0000001a5c5c7212ULL, 0x080fe400078efcffULL, 0x0000000957577c10ULL, 0x000fe20008ffe4ffULL,
0x000000106ea17824ULL, 0x100fe200078e0217ULL, 0x0000001a64647212ULL, 0x080fe200078efcffULL,
0x000001006f6e7825ULL, 0x000fe200078e00ffULL, 0x000000086a6a7c10ULL, 0x000fe4000ff1e0ffULL,
0x000000085c5c7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000106c9f7824ULL, 0x000fe200078e0217ULL,
0x0000001a6e6e7212ULL, 0x000fe200078efcffULL, 0x0000010069687825ULL, 0x000fe200078e00ffULL,
0x0000000864647c10ULL, 0x000fc4000ff5e0ffULL, 0x000000096b6b7c10ULL, 0x000fe200087fe4ffULL,
0x000001006d6c7825ULL, 0x000fe200078e00ffULL, 0x0000001a68687212ULL, 0x080fe400078efcffULL,
0x000000095d5d7c10ULL, 0x000fe20008ffe4ffULL, 0x0000001074a37824ULL, 0x100fe200078e0217ULL,
0x0000001a6c6c7212ULL, 0x080fe200078efcffULL, 0x0000010077747825ULL, 0x000fe200078e00ffULL,
0x000000086e6e7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000965657c10ULL, 0x000fe200097fe4ffULL,
0x00000010187d7824ULL, 0x100fe200078e0217ULL, 0x0000000868687c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001078a77824ULL, 0x100fe200078e0217ULL, 0x0000001a74747212ULL, 0x080fe200078efcffULL,
0x000001007a767825ULL, 0x000fe200078e00ffULL, 0x000000086c6c7c10ULL, 0x000fe2000ff5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000547d7faeULL, 0x0003e2000b901c46ULL,
0x000000096f6f7c10ULL, 0x000fe200087fe4ffULL, 0x0000010079787825ULL, 0x000fe200078e00ffULL,
0x0000001a76767212ULL, 0x080fe200078efcffULL, 0x00000000567f7faeULL, 0x0003e2000b901c46ULL,
0x0000000969697c10ULL, 0x000fe20008ffe4ffULL, 0x000001007b7a7825ULL, 0x000fe200078e00ffULL,
0x0000001a78787212ULL, 0x080fe200078efcffULL, 0x0000000058817faeULL, 0x0003e2000b901c46ULL,
0x0000000874747c10ULL, 0x000fe2000ff1e0ffULL, 0x000000107ca97824ULL, 0x100fe200078e0217ULL,
0x0000001a7a1a7212ULL, 0x000fe200078efcffULL, 0x000000005a837faeULL, 0x0003e2000b901c46ULL,
0x000000096d6d7c10ULL, 0x000fe200097fe4ffULL, 0x000000107eab7824ULL, 0x100fe200078e0217ULL,
0x0000000876767c10ULL, 0x000fe2000ff3e0ffULL, 0x000000005c897faeULL, 0x0003e2000b901c46ULL,
0x0000000878787c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001080177824ULL, 0x000fe200078e0217ULL,
0x000000081a7a7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000005e8b7faeULL, 0x0003e2000b901c46ULL,
0x0000000975757c10ULL, 0x000fc400087fe4ffULL, 0x0000000977777c10ULL, 0x000fe20008ffe4ffULL,
0x00000000648d7faeULL, 0x0003e2000b901c46ULL, 0x0000000979797c10ULL, 0x000fe400097fe4ffULL,
0x000000097b7b7c10ULL, 0x000fe20009ffe4ffULL, 0x00000000668f7faeULL, 0x0003e8000b901c46ULL,
0x00000000689f7faeULL, 0x0003e8000b901c46ULL, 0x000000006aa17faeULL, 0x0003e8000b901c46ULL,
0x000000006ca37faeULL, 0x0003e8000b901c46ULL, 0x000000006ea57faeULL, 0x0003e8000b901c46ULL,
0x0000000074a77faeULL, 0x0003e8000b901c46ULL, 0x0000000076a97faeULL, 0x0003e8000b901c46ULL,
0x0000000078ab7faeULL, 0x0003e8000b901c46ULL, 0x000000007a177faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001014187824ULL, 0x000fe200078e00ffULL,
0x0000000813177810ULL, 0x002fe20007ffe0ffULL, 0x00000008111a7836ULL, 0x000fe20000000000ULL,
0x000000190f6c7211ULL, 0x000fe200078e20ffULL, 0x0000001012557824ULL, 0x000fe200078e00ffULL,
0xfffffff018187812ULL, 0x000fe200078ee217ULL, 0x0000001010547824ULL, 0x100fe200078e0219ULL,
0x0000000412177819ULL, 0x000fe200000006ffULL, 0x000000100e687824ULL, 0x000fe200078e0219ULL,
0xfffffff0551a7812ULL, 0x000fe200078ee21aULL, 0x0000001018187824ULL, 0x000fc400078e0295ULL,
0x000000100d647824ULL, 0x000fe200078e0219ULL, 0x0000000a130d7810ULL, 0x000fe20007ffe0ffULL,
0x000000101a1a7824ULL, 0x000fe400078e0295ULL, 0x00000010140e7824ULL, 0x000fe400078e00ffULL,
0x0000001012107824ULL, 0x000fe400078e00ffULL, 0x000000100c0c7824ULL, 0x000fe200078e0219ULL,
0xfffffff00e0e7812ULL, 0x000fe200078ee20dULL, 0x0000000a110d7836ULL, 0x000fe20000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000005454783bULL, 0x000fe20000000200ULL,
0xfffffff010107812ULL, 0x000fe200078ee20dULL, 0x000000100a787824ULL, 0x100fe200078e0219ULL,
0x000000950e747211ULL, 0x000fe200078e20ffULL, 0x000000001858783bULL, 0x000e620000000200ULL,
0x0000001009807824ULL, 0x000fe200078e0219ULL, 0x0000000c13097810ULL, 0x000fe20007ffe0ffULL,
0x0000001010107824ULL, 0x000fe200078e0295ULL, 0x000000001a5c783bULL, 0x000ea20000000200ULL,
0x00000010140a7824ULL, 0x000fe400078e00ffULL, 0x000000100b887824ULL, 0x100fe200078e0219ULL,
0x000000006868783bULL, 0x000ee20000000200ULL, 0x0000001008087824ULL, 0x100fe200078e0219ULL,
0xfffffff00a0a7812ULL, 0x000fe200078ee209ULL, 0x0000000e13137836ULL, 0x000fe20000000000ULL,
0x000000000c0c783bULL, 0x000fe20000000200ULL, 0x0000001004047824ULL, 0x000fc600078e0219ULL,
0x000000007474783bULL, 0x000f280000000200ULL, 0x00000000107c783bULL, 0x000ae80000000200ULL,
0x000000006c6c783bULL, 0x000ee80000000200ULL, 0x000000006464783bULL, 0x000f220000000200ULL,
0x0000000c11107836ULL, 0x020fc40000000000ULL, 0x0000000e11117836ULL, 0x000fe20000000000ULL,
0x000000007878783bULL, 0x000f640000000200ULL, 0xfffffff017107812ULL, 0x000fe400078ee210ULL,
0x000000008080783bULL, 0x000f660000000200ULL, 0x0000001010107824ULL, 0x000fe200078e0295ULL,
0x000000545890723cULL, 0x002fe20000001890ULL, 0x000000008888783bULL, 0x000e6a0000000200ULL,
0x000000545c24723cULL, 0x004fec0000001824ULL, 0x000000565828723cULL, 0x000fe20000001828ULL,
0x0000001007547824ULL, 0x000fca00078e0219ULL, 0x000000565c2c723cULL, 0x000fe2000000182cULL,
0x000000005454783bULL, 0x000fea0000000200ULL, 0x000000685c50723cULL, 0x008fec0000001850ULL,
0x0000000c7490723cULL, 0x010fec0000001890ULL, 0x0000000c7c24723cULL, 0x000fec0000001824ULL,
0x0000000e7428723cULL, 0x000fe20000001828ULL, 0x000000100a0c7824ULL, 0x000fc400078e0295ULL,
0x000000000808783bULL, 0x000fe60000000200ULL, 0x0000000e7c2c723cULL, 0x000fe2000000182cULL,
0x000000000c0c783bULL, 0x000eaa0000000200ULL, 0x0000006c5830723cULL, 0x000fec0000001830ULL,
0x0000006e5834723cULL, 0x000fec0000001834ULL, 0x000000685838723cULL, 0x000fec0000001838ULL,
0x0000006a583c723cULL, 0x000fec000000183cULL, 0x000000645840723cULL, 0x000fec0000001840ULL,
0x000000665844723cULL, 0x000fec0000001844ULL, 0x000000645c70723cULL, 0x000fe20000001870ULL,
0x0000001006587824ULL, 0x000fe200078e0219ULL, 0x0000000414067819ULL, 0x000fc400000006ffULL,
0x0000000412147819ULL, 0x000fe200000006ffULL, 0x0000001003127824ULL, 0x000fe200078e0219ULL,
0xfffffff006067812ULL, 0x000fe200078ee213ULL, 0x000000665c84723cULL, 0x000fe20000001884ULL,
0x000000005858783bULL, 0x000ee20000000200ULL, 0xfffffff014147812ULL, 0x000fc800078ee211ULL,
0x0000006c5c48723cULL, 0x000fe20000001848ULL, 0x0000001014147824ULL, 0x000fca00078e0295ULL,
0x000000787c64723cULL, 0x020fec0000001850ULL, 0x0000006e5c4c723cULL, 0x000fe2000000184cULL,
0x0000001006507824ULL, 0x000fe200078e0295ULL, 0x00000000146c783bULL, 0x000fe80000000200ULL,
0x0000006a5c60723cULL, 0x000fe20000001860ULL, 0x000000005050783bULL, 0x000fe80000000200ULL,
0x000000001068783bULL, 0x000f220000000200ULL, 0x000000827444723cULL, 0x000fe20000001844ULL,
0x00000010055c7824ULL, 0x000fc400078e0219ULL, 0x000000000404783bULL, 0x000f660000000200ULL,
0x000000887430723cULL, 0x002fe20000001830ULL, 0x000000005c5c783bULL, 0x000e680000000200ULL,
0x000000001210783bULL, 0x000e620000000200ULL, 0x0000000a0c28723cULL, 0x004fec0000001828ULL,
0x0000008a7434723cULL, 0x000fec0000001834ULL, 0x000000787438723cULL, 0x000fec0000001838ULL,
0x0000007a743c723cULL, 0x000fec000000183cULL, 0x000000807440723cULL, 0x000fec0000001840ULL,
0x000000887c48723cULL, 0x000fec0000001848ULL, 0x0000008a7c4c723cULL, 0x000fec000000184cULL,
0x0000007a7c78723cULL, 0x000fec0000001860ULL, 0x000000807c74723cULL, 0x000fe20000001870ULL,
0x0000001000607824ULL, 0x000fca00078e0219ULL, 0x000000827c84723cULL, 0x000fe20000001884ULL,
0x0000001002707824ULL, 0x000fe200078e0219ULL, 0x000000006060783bULL, 0x000fe80000000200ULL,
0x000000080c90723cULL, 0x000fe20000001890ULL, 0x000000007070783bULL, 0x000eaa0000000200ULL,
0x0000005a0c88723cULL, 0x008fec0000001844ULL, 0x0000000868a0723cULL, 0x010fec0000001824ULL,
0x000000540c30723cULL, 0x000fec0000001830ULL, 0x0000000a682c723cULL, 0x000fec000000182cULL,
0x000000065044723cULL, 0x020fec0000001828ULL, 0x000000560c34723cULL, 0x000fec0000001834ULL,
0x0000005c0c7c723cULL, 0x002fec0000001838ULL, 0x0000005e0c80723cULL, 0x000fec000000183cULL,
0x000000546848723cULL, 0x000fe20000001848ULL, 0x3db504f346037820ULL, 0x000fe20000410000ULL,
0x0000000100467802ULL, 0x000fe20000000f00ULL, 0x3db504f347147820ULL, 0x000fe20000410000ULL,
0x3db504f344447820ULL, 0x000fe20000410000ULL, 0x3db504f345457820ULL, 0x000fe20000410000ULL,
0x0000005c6864723cULL, 0x000fe40000001864ULL, 0x01e688461f4679a7ULL, 0x000e68000850003fULL,
0x000000580c40723cULL, 0x000fec0000001840ULL, 0x00000056684c723cULL, 0x000fec000000184cULL,
0x0000005e6878723cULL, 0x000fec0000001878ULL, 0x000000586874723cULL, 0x000fec0000001874ULL,
0x0000005a6884723cULL, 0x000fec0000001884ULL, 0x000000045090723cULL, 0x000fec0000001890ULL,
0x000000046c28723cULL, 0x000fec00000018a0ULL, 0x00000010503c723cULL, 0x000fec0000001830ULL,
0x000000066c04723cULL, 0x000fec000000182cULL, 0x000000125038723cULL, 0x000fe20000001834ULL,
0x3db504f390197820ULL, 0x000fe20000410000ULL, 0x3db504f391187820ULL, 0x000fe20000410000ULL,
0x3db504f392027820ULL, 0x000fe20000410000ULL, 0x3db504f393007820ULL, 0x000fc40000410000ULL,
0x00000070500c723cULL, 0x004fe2000000187cULL, 0x3db504f329297820ULL, 0x000fe20000410000ULL,
0x3db504f32a2a7820ULL, 0x000fe20000410000ULL, 0x3db504f32b2b7820ULL, 0x000fc60000410000ULL,
0x000000725008723cULL, 0x000fe20000001880ULL, 0x3db504f33e177820ULL, 0x000fe20000410000ULL,
0x3db504f33c3c7820ULL, 0x000fe20000410000ULL, 0x3db504f33d3d7820ULL, 0x000fe20000410000ULL,
0x3db504f33f3f7820ULL, 0x000fe40000410000ULL, 0x000000106c2c723cULL, 0x000fe20000001848ULL,
0x3db504f3053e7820ULL, 0x000fca0000410000ULL, 0x000000706c30723cULL, 0x000fe20000001864ULL,
0x3db504f338387820ULL, 0x000fe20000410000ULL, 0x3db504f339397820ULL, 0x000fe20000410000ULL,
0x3db504f33a3a7820ULL, 0x000fe20000410000ULL, 0x3db504f33b3b7820ULL, 0x000fe40000410000ULL,
0x000000605024723cULL, 0x000fe20000001840ULL, 0x3db504f30c0c7820ULL, 0x000fe20000410000ULL,
0x3db504f30d0d7820ULL, 0x000fe20000410000ULL, 0x3db504f30e0e7820ULL, 0x000fe20000410000ULL,
0x3db504f30f0f7820ULL, 0x000fc40000410000ULL, 0x000000126c10723cULL, 0x000fe2000000184cULL,
0x3db504f328417820ULL, 0x000fe20000410000ULL, 0x3db504f3081a7820ULL, 0x000fe20000410000ULL,
0x3db504f309097820ULL, 0x000fe20000410000ULL, 0x3db504f30a0a7820ULL, 0x000fe20000410000ULL,
0x3db504f30b0b7820ULL, 0x000fe20000410000ULL, 0x000000726c70723cULL, 0x000fe20000001878ULL,
0x3db504f304287820ULL, 0x000fe20000410000ULL, 0x3db504f306407820ULL, 0x000fe20000410000ULL,
0x3db504f307427820ULL, 0x000fe20000410000ULL, 0x3db504f32c2c7820ULL, 0x000fe20000410000ULL,
0x3db504f32d2d7820ULL, 0x000fe20000410000ULL, 0x000000606c34723cULL, 0x000fe20000001874ULL,
0x3db504f32e2e7820ULL, 0x000fe20000410000ULL, 0x3db504f32f2f7820ULL, 0x000fe20000410000ULL,
0x3db504f330307820ULL, 0x000fe20000410000ULL, 0x3db504f331317820ULL, 0x000fe20000410000ULL,
0x3db504f332327820ULL, 0x000fe20000410000ULL, 0x000000625050723cULL, 0x000fe20000001888ULL,
0x3db504f324247820ULL, 0x000fe20000410000ULL, 0x3db504f325257820ULL, 0x000fe20000410000ULL,
0x3db504f326267820ULL, 0x000fe20000410000ULL, 0x3db504f327277820ULL, 0x000fe20000410000ULL,
0x3db504f333337820ULL, 0x000fe20000410000ULL, 0x000000626c6c723cULL, 0x000fe20000001884ULL,
0x3db504f310107820ULL, 0x000fe20000410000ULL, 0x3db504f311117820ULL, 0x000fe20000410000ULL,
0x3db504f312127820ULL, 0x000fe20000410000ULL, 0x3db504f313137820ULL, 0x000fc40000410000ULL,
0x3db504f370707820ULL, 0x000fe20000410000ULL, 0x3db504f371717820ULL, 0x000fe20000410000ULL,
0x3db504f372727820ULL, 0x000fe20000410000ULL, 0x3db504f373737820ULL, 0x000fc60000410000ULL,
0x3db504f334347820ULL, 0x000fe20000410000ULL, 0x3db504f335357820ULL, 0x000fe20000410000ULL,
0x3db504f336367820ULL, 0x000fe20000410000ULL, 0x3db504f337377820ULL, 0x000fc60000410000ULL,
0x3db504f350507820ULL, 0x000fe20000410000ULL, 0x3db504f351517820ULL, 0x000fe20000410000ULL,
0x3db504f352527820ULL, 0x000fe20000410000ULL, 0x3db504f353537820ULL, 0x000fc60000410000ULL,
0x3db504f36c6c7820ULL, 0x000fe20000410000ULL, 0x3db504f36d6d7820ULL, 0x000fe20000410000ULL,
0x3db504f36e6e7820ULL, 0x000fe20000410000ULL, 0x3db504f36f6f7820ULL, 0x000fe20000410000ULL,
0x0000000000047805ULL, 0x000fe20000015200ULL, 0x01e688471f0075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff087224ULL, 0x000fce00078e00ffULL,
0x000000100800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604437210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000004306067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000108087836ULL, 0x000fce0000000000ULL,
0x01e688471f0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000220047819ULL, 0x000fe200000006ffULL, 0x0000008098057824ULL, 0x000fe200078e0295ULL,
0x000000219a00720cULL, 0x000fe40003f06070ULL, 0xfffffff004047812ULL, 0x000fca00078ec0ffULL,
0x0000000105087824ULL, 0x000fca00078e0204ULL, 0x01e4000008047984ULL, 0x0002a20000000c00ULL,
0x0000002000608947ULL, 0x000fea0003800000ULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x000000ff00467202ULL, 0x000fe20000000f00ULL, 0x0000000400487d06ULL, 0x000ee20008209000ULL,
0x0000009720437211ULL, 0x000fca00078ff0ffULL, 0x00000018434a7836ULL, 0x000fe40000000000ULL,
0x0000004800487308ULL, 0x008ee40000001000ULL, 0x0ffffffe48477836ULL, 0x008fe40000000000ULL,
0x0000001043487836ULL, 0x000fc80000000000ULL, 0x0000004700477305ULL, 0x000ee4000021f000ULL,
0x000000ffff497224ULL, 0x008fc800078e0a47ULL, 0x0000000449497c24ULL, 0x000fc8000f8e02ffULL,
0x00000049474f7227ULL, 0x000fc800078e0046ULL, 0x0000000843467836ULL, 0x000fe40000000000ULL,
0x000000434f477227ULL, 0x000fc800078e00ffULL, 0x000000464f497227ULL, 0x000fe200078e00ffULL,
0x000000ff474e7210ULL, 0x000fc60007ffe1ffULL, 0x000000ffff4d7224ULL, 0x000fe400078e0a49ULL,
0x000000044e437c24ULL, 0x000fe2000f8e0243ULL, 0x00000004ff4e7c12ULL, 0x000fe2000f8e33ffULL,
0x000000044d467c24ULL, 0x000fe4000f8e0246ULL, 0x000000484f4b7227ULL, 0x000fe200078e00ffULL,
0x0000000443007c0cULL, 0x000fe4000bfa6070ULL, 0x0000000446007c0cULL, 0x000fe2000bf06070ULL,
0x000000ffff4d7224ULL, 0x000fc400078e0a4bULL, 0x0000004a4f4c7227ULL, 0x000fc800078e00ffULL,
0x000000044d487c24ULL, 0x000fe4000f8e0248ULL, 0x000000ffff4f7224ULL, 0x000fe400078e0a4cULL,
0x8000000443435c36ULL, 0x000fe20008000000ULL, 0x0000000448007c0cULL, 0x000fe2000bf46070ULL,
0x8000000446460c36ULL, 0x000fe40008000000ULL, 0x000000044f4a7c24ULL, 0x000fe2000f8e024aULL,
0x0000000443007c0cULL, 0x000fe2000bf86070ULL, 0x0000000149490836ULL, 0x000fe20000000000ULL,
0x0000000446007c0cULL, 0x000fe2000bfc6070ULL, 0x0000000147475836ULL, 0x000fe20000000000ULL,
0x0000001b96467248ULL, 0x000fc40007fe0000ULL, 0x000000044a007c0cULL, 0x000fe4000bf66070ULL,
0x000000461b1b7210ULL, 0x000fe20007ffe1ffULL, 0x0000000220467824ULL, 0x000fe400078e00ffULL,
0x8000000448482c36ULL, 0x000fe40008000000ULL, 0x0000000147474810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff7d7224ULL, 0x000fe200078e0a1bULL, 0x0000000646467812ULL, 0x000fe200078ec0ffULL,
0x000000014b4b2836ULL, 0x000fe20000000000ULL, 0x0000000448007c0cULL, 0x000fc4000bf26070ULL,
0x0000000149496810ULL, 0x000fe20007ffe0ffULL, 0x800000044a4a3c36ULL, 0x000fe20008000000ULL,
0x00000004ff007c0cULL, 0x000fe2000bfc5070ULL, 0x000000011d437824ULL, 0x000fe400078e0246ULL,
0x0000000146487824ULL, 0x000fe200078e029bULL, 0x000000474e477207ULL, 0x000fe20007000000ULL,
0x000000014c4c3836ULL, 0x000fe20000000000ULL, 0x000000044a007c0cULL, 0x000fe4000bf06070ULL,
0x0000001b4300720cULL, 0x000fe20003fa6070ULL, 0x000000014b4b1836ULL, 0x000fe20000000000ULL,
0x0000007d43437246ULL, 0x000fc4000380001eULL, 0x000000471e477248ULL, 0x000fe40003fe0000ULL,
0x0000001b4800720cULL, 0x000fe40003f86070ULL, 0x0000007d48557246ULL, 0x000fe2000380001eULL,
0x00000005477c7c24ULL, 0x000fe2000f8e02ffULL, 0x000000494e497207ULL, 0x000fe20007000000ULL,
0x000000014c4c0836ULL, 0x000fe20000000000ULL, 0x00000004ff437819ULL, 0x000fe40000011643ULL,
0x000000ff55557207ULL, 0x000fc40002000000ULL, 0x000000491e4a7248ULL, 0x000fe40003fe0000ULL,
0x000000ff43497207ULL, 0x000fe40002800000ULL, 0x0000004b4e437207ULL, 0x000fe20007000000ULL,
0x000000054a7e7c24ULL, 0x000fe2000f8e02ffULL, 0x0000007c554b7211ULL, 0x000fe400078fe0ffULL,
0x000000497c4d7210ULL, 0x000fe20007ffe0ffULL, 0x00000001494f7824ULL, 0x000fe200078e027eULL,
0x000000431e477248ULL, 0x000fe20003fe0000ULL, 0x000000024b4a7825ULL, 0x000fe200078e009cULL,
0x0000004c4e577207ULL, 0x000fc60007000000ULL, 0x000000024d4c7825ULL, 0x000fe200078e009cULL,
0x000000571e577248ULL, 0x000fe20003fe0000ULL, 0x000000064a4a7981ULL, 0x000ee4000c1e9500ULL,
0x0000000547807c24ULL, 0x000fe4000f8e02ffULL, 0x000000064c437981ULL, 0x0008e2000c1e9500ULL,
0x0000007e555b7211ULL, 0x000fe200078fe0ffULL, 0x00000001495f7824ULL, 0x000fe200078e0280ULL,
0x00000080555d7211ULL, 0x000fe200078fe0ffULL, 0x000000024f4e7825ULL, 0x000fe200078e009cULL,
0x0000001046547812ULL, 0x000fc600078efcffULL, 0x0000000557827c24ULL, 0x000fe2000f8e02ffULL,
0x000000064e477981ULL, 0x000ae2000c1e9500ULL, 0x000000025b5a7825ULL, 0x000fc800078e009cULL,
0x000000025f5e7825ULL, 0x100fe200078e009cULL, 0x000000065a4c7981ULL, 0x012326000c1e9500ULL,
0x000000025d5c7825ULL, 0x000fe200078e009cULL, 0x0000008255597211ULL, 0x000fc600078fe0ffULL,
0x0000000149617824ULL, 0x000fe200078e0282ULL, 0x000000065c4e7981ULL, 0x024562000c1e9500ULL,
0x000000011d4d7824ULL, 0x000fe200078e0254ULL, 0x0000009b54567210ULL, 0x000fe40007ffe0ffULL,
0x000000065e497981ULL, 0x000364000c1e9500ULL, 0x0000007d4d4f7246ULL, 0x000fe4000380001eULL,
0x0000001b4d00720cULL, 0x080fe20003f26070ULL, 0x0000000259587825ULL, 0x000fe200078e009cULL,
0x0000001b5600720cULL, 0x000fc40003f06070ULL, 0x0000007d564d7246ULL, 0x000fe2000380001eULL,
0x0000000261607825ULL, 0x000fe200078e009cULL, 0x00000004ff4f7819ULL, 0x000fe2000001164fULL,
0x0000000658587981ULL, 0x000f62000c1e9500ULL, 0x000000ff4d697207ULL, 0x000fe40000000000ULL,
0x000000ff4f577207ULL, 0x000fe20000800000ULL, 0x00000006604b7981ULL, 0x000f62000c1e9500ULL,
0x0000007c695b7211ULL, 0x042fe400078fe0ffULL, 0x0000007e69657211ULL, 0x000fe200078fe0ffULL,
0x000000017c5d7824ULL, 0x004fc400078e0257ULL, 0x00000001575f7824ULL, 0x000fe400078e027eULL,
0x000000025b5a7825ULL, 0x000fe200078e009cULL, 0x0000002046687812ULL, 0x000fc600078efcffULL,
0x0000000265647825ULL, 0x100fe200078e009cULL, 0x0000008069677211ULL, 0x000fe200078fe0ffULL,
0x000000065a5a7981ULL, 0x0002a4000c1e9500ULL, 0x000000025d5c7825ULL, 0x100fe400078e009cULL,
0x0000000664647981ULL, 0x000ea4000c1e9500ULL, 0x000000025f5e7825ULL, 0x000fe400078e009cULL,
0x000000065c4d7981ULL, 0x000ea2000c1e9500ULL, 0x000000681d5b7210ULL, 0x002fc60007ffe0ffULL,
0x000000065e4f7981ULL, 0x0002a2000c1e9500ULL, 0x0000008269797211ULL, 0x000fe200078fe0ffULL,
0x0000000157617824ULL, 0x040fe400078e0280ULL, 0x00000001686a7824ULL, 0x000fe400078e029bULL,
0x0000000157577824ULL, 0x000fe400078e0282ULL, 0x0000000267667825ULL, 0x000fe200078e009cULL,
0x0000007d5b5e7246ULL, 0x002fc6000380001eULL, 0x0000000279787825ULL, 0x100fe200078e009cULL,
0x0000001b5b00720cULL, 0x080fe20003f26070ULL, 0x0000000666667981ULL, 0x0002a2000c1e9500ULL,
0x0000001b6a00720cULL, 0x000fe20003f06070ULL, 0x0000000261607825ULL, 0x000fe200078e009cULL,
0x00000004ff5e7819ULL, 0x000fe2000001165eULL, 0x0000000678787981ULL, 0x000ea2000c1e9500ULL,
0x0000007d6a5b7246ULL, 0x000fe2000380001eULL, 0x00000002575c7825ULL, 0x000fe200078e009cULL,
0x000000ff5e5f7207ULL, 0x000fe20000800000ULL, 0x0000000660577981ULL, 0x0002a4000c1e9500ULL,
0x000000ff5b677207ULL, 0x002fc40000000000ULL, 0x000000065c597981ULL, 0x0002a2000c1e9500ULL,
0x000000015f777824ULL, 0x000fe200078e027eULL, 0x0000007e67617211ULL, 0x000fc600078fe0ffULL,
0x0000000277767825ULL, 0x000fc800078e009cULL, 0x0000000261607825ULL, 0x000fe200078e009cULL,
0x0000000676657981ULL, 0x000ea6000c1e9500ULL, 0x000000017c5d7824ULL, 0x002fe200078e025fULL,
0x0000000660d07981ULL, 0x000ea2000c1e9500ULL, 0x0000007c677b7211ULL, 0x000fe200078fe0ffULL,
0x000000015f637824ULL, 0x000fe200078e0280ULL, 0x0000008067757211ULL, 0x000fe200078fe0ffULL,
0x000000025d5c7825ULL, 0x000fe200078e009cULL, 0x000000825f5f7210ULL, 0x000fc40007ffe0ffULL,
0x00000082676b7211ULL, 0x000fe200078fe0ffULL, 0x000000027b7a7825ULL, 0x100fe200078e009cULL,
0x000000065c5b7981ULL, 0x0002a2000c1e9500ULL, 0x0000003046b67812ULL, 0x000fe400078efcffULL,
0x0000000263627825ULL, 0x100fe400078e009cULL, 0x000000067a7a7981ULL, 0x000ea4000c1e9500ULL,
0x0000000275747825ULL, 0x100fe400078e009cULL, 0x0000000662817981ULL, 0x000ea4000c1e9500ULL,
0x000000025f5e7825ULL, 0x000fc400078e009cULL, 0x0000000674d47981ULL, 0x0002a4000c1e9500ULL,
0x000000026b5c7825ULL, 0x002fe400078e009cULL, 0x000000065e857981ULL, 0x0002a4000c1e9500ULL,
0x000000011d6b7824ULL, 0x000fe400078e02b6ULL, 0x000000065cd87981ULL, 0x0002a2000c1e9500ULL,
0x00000001b6b87824ULL, 0x000fe400078e029bULL, 0x0000007d6b767246ULL, 0x000fc4000380001eULL,
0x0000001b6b00720cULL, 0x080fe40003f26070ULL, 0x0000001bb800720cULL, 0x000fe40003f06070ULL,
0x00000004ff767819ULL, 0x000fe40000011676ULL, 0x0000007db8607246ULL, 0x000fe4000380001eULL,
0x000000ff76797207ULL, 0x000fe40000800000ULL, 0x000000ff606b7207ULL, 0x000fc40000000000ULL,
0x0000008079617210ULL, 0x000fe20007ffe0ffULL, 0x000000017c757824ULL, 0x000fe200078e0279ULL,
0x0000007c6b777211ULL, 0x040fe400078fe0ffULL, 0x000000806b637211ULL, 0x000fe200078fe0ffULL,
0x0000000275747825ULL, 0x000fc800078e009cULL, 0x0000000277767825ULL, 0x100fe200078e009cULL,
0x00000006747b7981ULL, 0x0002a6000c1e9500ULL, 0x0000000261607825ULL, 0x100fe200078e009cULL,
0x0000000676ba7981ULL, 0x0002a6000c1e9500ULL, 0x0000000263627825ULL, 0x000fe200078e009cULL,
0x0000000660837981ULL, 0x000ea2000c1e9500ULL, 0x0000007e6b5f7211ULL, 0x002fc600078fe0ffULL,
0x0000000662d67981ULL, 0x000ea2000c1e9500ULL, 0x00000001795d7824ULL, 0x000fe400078e027eULL,
0x000000025f5e7825ULL, 0x000fc800078e009cULL, 0x000000025d5c7825ULL, 0x000fe200078e009cULL,
0x000000065ed27981ULL, 0x000ea2000c1e9500ULL, 0x000000826b757211ULL, 0x000fc600078fe0ffULL,
0x000000065c7f7981ULL, 0x0002a2000c1e9500ULL, 0x0000000179777824ULL, 0x000fe400078e0282ULL,
0x0000000275747825ULL, 0x000fc800078e009cULL, 0x0000000277767825ULL, 0x000fe200078e009cULL,
0x0000000674da7981ULL, 0x000ea8000c1e9500ULL, 0x0000000676877981ULL, 0x0002a4000c1e9500ULL,
0xfffffff0555c7812ULL, 0x002fe200078ec0ffULL, 0x00000001ffce7424ULL, 0x000fc800078e00ffULL,
0x000000011b557824ULL, 0x000fe200078e025cULL, 0x00000001467c7812ULL, 0x000fc800078efcffULL,
0x80000055485c7210ULL, 0x000fc80007ffe0ffULL, 0x0000005cce5c7219ULL, 0x000fe200000006ffULL,
0x000000017c5e7824ULL, 0x000fe200078e029bULL, 0xfffffff069607812ULL, 0x000fc600078ec0ffULL,
0x000000015e5d7824ULL, 0x000fe200078e0a55ULL, 0x00000008467e7812ULL, 0x040fe400078efcffULL,
0x0000000946807812ULL, 0x000fe400078efcffULL, 0x000000601b617210ULL, 0x000fe40007ffe0ffULL,
0x0000005dce607219ULL, 0x000fe400000006ffULL, 0x0000009b7e627210ULL, 0x000fe20007ffe0ffULL,
0x0000000180767824ULL, 0x000fe200078e029bULL, 0xfffffff067747812ULL, 0x000fc400078ec0ffULL,
0xfffffff06b827812ULL, 0x000fe200078ec0ffULL, 0x00000001625f7824ULL, 0x100fe400078e0a55ULL,
0x0000000176557824ULL, 0x000fe200078e0a55ULL, 0x0000001146867812ULL, 0x000fe200078efcffULL,
0x000000011b637824ULL, 0x040fe200078e0274ULL, 0x0000005fce747219ULL, 0x040fe200000006ffULL,
0x000000011b757824ULL, 0x000fe200078e0282ULL, 0x00000055ce827219ULL, 0x000fe200000006ffULL,
0x0000000186887824ULL, 0x000fe400078e029bULL, 0x0000000156557824ULL, 0x000fe200078e0a61ULL,
0x00000018468e7812ULL, 0x000fc400078efcffULL, 0x00000088615d7210ULL, 0x000fe40007ffe1ffULL,
0x00000019469a7812ULL, 0x000fe400078efcffULL, 0x00000055ce847219ULL, 0x040fe400000006ffULL,
0x0000005dce8a7219ULL, 0x000fe200000006ffULL, 0x000000018e907824ULL, 0x000fe200078e029bULL,
0x0000009b9a9e7210ULL, 0x000fe40007ffe0ffULL, 0x000054104a437816ULL, 0x008fc80000000043ULL,
0x000000435cff7212ULL, 0x000fc800078ac0ffULL, 0x0000001b4800720cULL, 0x000fc80002fa1470ULL,
0x0000001b4600720cULL, 0x000fe40002fa1070ULL, 0x000054104c477816ULL, 0x010fe40000000047ULL,
0xff80000019197808ULL, 0x000fe40002800000ULL, 0x0000004360ff7212ULL, 0x000fe4000782c0ffULL,
0x000000475cff7212ULL, 0x080fe4000784c0ffULL, 0x0000004760ff7212ULL, 0x000fc400078ac0ffULL,
0x000054104e497816ULL, 0x020fc80000000049ULL, 0x000000495cff7212ULL, 0x000fe4000788c0ffULL,
0x0000001b4800720cULL, 0x0c0fe40001741470ULL, 0x0000001b4800720cULL, 0x080fe40002781470ULL,
0x0000001b5e00720cULL, 0x0c0fe40000f21470ULL, 0x0000001b5e00720cULL, 0x080fe40002fa1470ULL,
0x0000001b4600720cULL, 0x000fc40001741070ULL, 0x0000001b4600720cULL, 0x080fe40002781070ULL,
0x0000001b7c00720cULL, 0x0c0fe40000f21070ULL, 0x0000001b7c00720cULL, 0x000fe40002fa1070ULL,
0x00005410584b7816ULL, 0x000fe4000000004bULL, 0xff80000002027808ULL, 0x000fe40001000000ULL,
0xff80000041417808ULL, 0x000fc40002000000ULL, 0xff80000018187808ULL, 0x000fe40000800000ULL,
0xff80000000007808ULL, 0x000fe40002800000ULL, 0x0000004374ff7212ULL, 0x000fe4000786c0ffULL,
0x0000004b5cff7212ULL, 0x000fe4000780c0ffULL, 0x0000004960ff7212ULL, 0x040fe4000784c0ffULL,
0x0000004b60ff7212ULL, 0x000fc4000788c0ffULL, 0x0000004782ff7212ULL, 0x000fe4000782c0ffULL,
0x0000004974ff7212ULL, 0x000fe400078ac0ffULL, 0x0000001b4800720cULL, 0x080fe40000701470ULL,
0x0000001b5e00720cULL, 0x0c0fe40001741470ULL, 0x0000001b5e00720cULL, 0x080fe40002781470ULL,
0x0000001b6200720cULL, 0x000fc40001f61470ULL, 0x0000001b6200720cULL, 0x080fe40002fa1470ULL,
0x0000001b7600720cULL, 0x080fe40000f21470ULL, 0x0000001b4600720cULL, 0x080fe40000701070ULL,
0x0000001b7c00720cULL, 0x0c0fe40001741070ULL, 0x0000001b7c00720cULL, 0x080fe40002781070ULL,
0x0000001b7e00720cULL, 0x000fc40001f61070ULL, 0x0000001b7e00720cULL, 0x080fe40002fa1070ULL,
0x0000001b8000720cULL, 0x000fe40000f21070ULL, 0x000054105a4d7816ULL, 0x004fe4000000004dULL,
0x00005410644f7816ULL, 0x000fe4000000004fULL, 0xff8000002a2a7808ULL, 0x000fe40000000000ULL,
0xff80000029297808ULL, 0x000fc40001000000ULL, 0xff8000002b2b7808ULL, 0x000fe40002000000ULL,
0xff80000044447808ULL, 0x000fe40001800000ULL, 0xff80000028287808ULL, 0x000fe40002800000ULL,
0xff80000014147808ULL, 0x000fe40000800000ULL, 0x0000004774ff7212ULL, 0x000fe4000780c0ffULL,
0x0000004982ff7212ULL, 0x000fc4000784c0ffULL, 0x0000004b74ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004b82ff7212ULL, 0x000fe4000786c0ffULL, 0x0000004d8aff7212ULL, 0x000fe400078ac0ffULL,
0x0000004f84ff7212ULL, 0x000fe2000782c0ffULL, 0x00000001905f7824ULL, 0x100fe200078e0a61ULL,
0x0000001b6200720cULL, 0x080fe20000701470ULL, 0x000000019e617824ULL, 0x000fe200078e0a61ULL,
0x0000001b6200720cULL, 0x000fc40002781470ULL, 0x0000001b7600720cULL, 0x0c0fe40001741470ULL,
0x0000001b7600720cULL, 0x080fe40001f61470ULL, 0x0000001b5600720cULL, 0x080fe40000f21470ULL,
0x0000001b8800720cULL, 0x080fe40002fa1470ULL, 0x0000001b7e00720cULL, 0x0c0fe40000701070ULL,
0x0000001b7e00720cULL, 0x000fc40002781070ULL, 0x0000001b8000720cULL, 0x0c0fe40001741070ULL,
0x0000001b8000720cULL, 0x080fe40001f61070ULL, 0x0000001b5400720cULL, 0x080fe40000f21070ULL,
0x0000001b8600720cULL, 0x000fe40002fa1070ULL, 0x0000005fce927219ULL, 0x040fe400000006ffULL,
0x00000061cea07219ULL, 0x000fc400000006ffULL, 0x0000541066577816ULL, 0x000fe40000000057ULL,
0x0000541078597816ULL, 0x000fe40000000059ULL, 0xff80000003037808ULL, 0x000fe40000000000ULL,
0xff80000040407808ULL, 0x000fe40002000000ULL, 0xff8000003e3e7808ULL, 0x000fe40001000000ULL,
0xff80000042427808ULL, 0x000fc40001800000ULL, 0xff80000017177808ULL, 0x000fe40000800000ULL,
0xff8000003d3d7808ULL, 0x000fe40002800000ULL, 0x0000004d84ff7212ULL, 0x080fe4000780c0ffULL,
0x0000004d92ff7212ULL, 0x000fe4000788c0ffULL, 0x0000005784ff7212ULL, 0x040fe4000784c0ffULL,
0x0000005984ff7212ULL, 0x000fc4000786c0ffULL, 0x000000578aff7212ULL, 0x000fe4000782c0ffULL,
0x0000004fa0ff7212ULL, 0x000fe200078ac0ffULL, 0x000000016a677824ULL, 0x000fe200078e0a63ULL,
0x0000001b5600720cULL, 0x0c0fe40000701470ULL, 0x0000001b5600720cULL, 0x0c0fe40001741470ULL,
0x0000001b5600720cULL, 0x080fe40001f61470ULL, 0x0000001b8800720cULL, 0x000fc40000f21470ULL,
0x0000001b9000720cULL, 0x080fe40002781470ULL, 0x0000001b9e00720cULL, 0x080fe40002fa1470ULL,
0x0000002146a47812ULL, 0x000fe400078efcffULL, 0x0000001b5400720cULL, 0x0c0fe40000701070ULL,
0x0000001b5400720cULL, 0x0c0fe40001741070ULL, 0x0000001b5400720cULL, 0x000fc40001f61070ULL,
0x0000001b8600720cULL, 0x080fe40000f21070ULL, 0x0000001b8e00720cULL, 0x080fe40002781070ULL,
0x0000001b9a00720cULL, 0x000fe40002fa1070ULL, 0x00000067cea27219ULL, 0x000fe400000006ffULL,
0x00005410d0657816ULL, 0x000fe20000000065ULL, 0x00000001a4a67824ULL, 0x000fe200078e029bULL,
0xff8000003c3c7808ULL, 0x000fc40000000000ULL, 0xff8000002c2c7808ULL, 0x000fe40001000000ULL,
0xff8000002e2e7808ULL, 0x000fe40001800000ULL, 0xff8000002d2d7808ULL, 0x000fe40000800000ULL,
0xff80000038387808ULL, 0x000fe40002000000ULL, 0xff8000003b3b7808ULL, 0x000fe40002800000ULL,
0x0000004f8aff7212ULL, 0x000fc4000780c0ffULL, 0x000000598aff7212ULL, 0x000fe4000784c0ffULL,
0x0000004f92ff7212ULL, 0x000fe4000786c0ffULL, 0x00000057a0ff7212ULL, 0x040fe4000782c0ffULL,
0x00000059a0ff7212ULL, 0x000fe4000788c0ffULL, 0x00000065a2ff7212ULL, 0x000fe400078ac0ffULL,
0x0000001b8800720cULL, 0x000fc40000701470ULL, 0x0000001b8800720cULL, 0x080fe40001741470ULL,
0x0000001b9000720cULL, 0x080fe40001f61470ULL, 0x0000001b9e00720cULL, 0x0c0fe40000f21470ULL,
0x0000001b9e00720cULL, 0x080fe40002781470ULL, 0x0000001b6a00720cULL, 0x000fe40002fa1470ULL,
0x000000a663697210ULL, 0x000fc40007ffe1ffULL, 0x0000002846aa7812ULL, 0x040fe400078efcffULL,
0x0000002946b07812ULL, 0x000fe400078efcffULL, 0x0000001b8600720cULL, 0x0c0fe40000701070ULL,
0x0000001b8600720cULL, 0x080fe40001741070ULL, 0x0000001b8e00720cULL, 0x080fe40001f61070ULL,
0x0000001b9a00720cULL, 0x000fc40000f21070ULL, 0x0000001b9a00720cULL, 0x080fe40002781070ULL,
0x0000001b6800720cULL, 0x000fe40002fa1070ULL, 0x00000069cea87219ULL, 0x000fe400000006ffULL,
0x000054107a5b7816ULL, 0x000fe4000000005bULL, 0x00005410d4817816ULL, 0x000fe40000000081ULL,
0x00005410d8857816ULL, 0x000fe20000000085ULL, 0x00000001aaac7824ULL, 0x100fe200078e029bULL,
0xff8000003f3f7808ULL, 0x000fe20000000000ULL, 0x00000001b0b27824ULL, 0x000fe200078e029bULL,
0xff8000002f2f7808ULL, 0x000fc40001000000ULL, 0xff8000003a3a7808ULL, 0x000fe40001800000ULL,
0xff80000011117808ULL, 0x000fe40000800000ULL, 0xff80000013137808ULL, 0x000fe40002000000ULL,
0xff8000000e0e7808ULL, 0x000fe40002800000ULL, 0x0000004382ff7212ULL, 0x000fe400078cc0ffULL,
0x0000005792ff7212ULL, 0x000fc4000780c0ffULL, 0x0000005992ff7212ULL, 0x000fe4000784c0ffULL,
0x0000005ba2ff7212ULL, 0x040fe4000786c0ffULL, 0x00000081a2ff7212ULL, 0x040fe4000782c0ffULL,
0x00000085a2ff7212ULL, 0x000fe4000788c0ffULL, 0x00000081a8ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001ac6b7824ULL, 0x100fe200078e0a63ULL, 0x0000001b7600720cULL, 0x080fe200037c1470ULL,
0x00000001b2637824ULL, 0x000fe200078e0a63ULL, 0x0000001b9000720cULL, 0x000fc40000701470ULL,
0x0000001b9000720cULL, 0x080fe40001741470ULL, 0x0000001b6a00720cULL, 0x0c0fe40001f61470ULL,
0x0000001b6a00720cULL, 0x0c0fe40000f21470ULL, 0x0000001b6a00720cULL, 0x080fe40002781470ULL,
0x0000001ba600720cULL, 0x080fe40002fa1470ULL, 0x0000001b8000720cULL, 0x000fc400037c1070ULL,
0x0000001b8e00720cULL, 0x0c0fe40000701070ULL, 0x0000001b8e00720cULL, 0x080fe40001741070ULL,
0x0000001b6800720cULL, 0x0c0fe40001f61070ULL, 0x0000001b6800720cULL, 0x0c0fe40000f21070ULL,
0x0000001b6800720cULL, 0x080fe40002781070ULL, 0x0000001ba400720cULL, 0x000fc40002fa1070ULL,
0x0000006bceae7219ULL, 0x040fe400000006ffULL, 0x00000063ceb47219ULL, 0x000fe400000006ffULL,
0xff80000045457808ULL, 0x000fe40003000000ULL, 0xff80000010107808ULL, 0x000fe40000000000ULL,
0xff80000012127808ULL, 0x000fe40001000000ULL, 0xff8000000c0c7808ULL, 0x000fc40001800000ULL,
0xff80000030307808ULL, 0x000fe40000800000ULL, 0xff80000032327808ULL, 0x000fe40002000000ULL,
0xff80000031317808ULL, 0x000fe40002800000ULL, 0x0000004da0ff7212ULL, 0x000fe400078cc0ffULL,
0x0000005ba8ff7212ULL, 0x080fe4000780c0ffULL, 0x0000005baeff7212ULL, 0x000fc4000784c0ffULL,
0x00000065a8ff7212ULL, 0x040fe4000786c0ffULL, 0x00000085a8ff7212ULL, 0x000fe4000782c0ffULL,
0x00000065aeff7212ULL, 0x000fe4000788c0ffULL, 0x00000081b4ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b8777824ULL, 0x000fe200078e0a75ULL, 0x0000001b9e00720cULL, 0x080fe400037c1470ULL,
0x0000001ba600720cULL, 0x000fc40000701470ULL, 0x0000001ba600720cULL, 0x0c0fe40001f61470ULL,
0x0000001ba600720cULL, 0x080fe40000f21470ULL, 0x0000001bac00720cULL, 0x0c0fe40001741470ULL,
0x0000001bac00720cULL, 0x080fe40002781470ULL, 0x0000001bb200720cULL, 0x000fe40002fa1470ULL,
0x0000003846c47812ULL, 0x000fc400078efcffULL, 0x0000003146be7812ULL, 0x040fe400078efcffULL,
0x0000003946ca7812ULL, 0x000fe400078efcffULL, 0x0000001b9a00720cULL, 0x080fe400037c1070ULL,
0x0000001ba400720cULL, 0x0c0fe40000701070ULL, 0x0000001ba400720cULL, 0x0c0fe40001f61070ULL,
0x0000001ba400720cULL, 0x000fc40000f21070ULL, 0x0000001baa00720cULL, 0x0c0fe40001741070ULL,
0x0000001baa00720cULL, 0x080fe40002781070ULL, 0x0000001bb000720cULL, 0x000fe40002fa1070ULL,
0x00000077cebc7219ULL, 0x000fe400000006ffULL, 0x00005410ba7b7816ULL, 0x000fe4000000007bULL,
0x00005410d6837816ULL, 0x000fe20000000083ULL, 0x00000001c4c67824ULL, 0x100fe200078e029bULL,
0x0000009bbec07210ULL, 0x000fe20007ffe0ffULL, 0x00000001cacc7824ULL, 0x000fe200078e029bULL,
0xff80000039397808ULL, 0x000fc40003000000ULL, 0xff8000000d0d7808ULL, 0x000fe40000000000ULL,
0xff8000000f0f7808ULL, 0x000fe40001800000ULL, 0xff80000033337808ULL, 0x000fe40000800000ULL,
0xff8000001a1a7808ULL, 0x000fe40001000000ULL, 0xff8000000a0a7808ULL, 0x000fe40002000000ULL,
0xff80000071717808ULL, 0x000fc40002800000ULL, 0x0000005bb4ff7212ULL, 0x040fe400078cc0ffULL,
0x00000065b4ff7212ULL, 0x000fe4000780c0ffULL, 0x00000081aeff7212ULL, 0x040fe4000786c0ffULL,
0x00000085aeff7212ULL, 0x080fe4000782c0ffULL, 0x00000085b4ff7212ULL, 0x000fe4000784c0ffULL,
0x0000007bbcff7212ULL, 0x000fc4000788c0ffULL, 0x00000083bcff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c67d7824ULL, 0x100fe200078e0a75ULL, 0x000000c075797210ULL, 0x000fe20007ffe1ffULL,
0x00000001cc757824ULL, 0x000fe200078e0a75ULL, 0x0000001bac00720cULL, 0x0c0fe40001f61470ULL,
0x0000001bac00720cULL, 0x080fe40000f21470ULL, 0x0000001bb200720cULL, 0x0c0fe400037c1470ULL,
0x0000001bb200720cULL, 0x000fc40000701470ULL, 0x0000001bb200720cULL, 0x080fe40001741470ULL,
0x0000001bb800720cULL, 0x0c0fe40002781470ULL, 0x0000001bb800720cULL, 0x000fe40002fa1470ULL,
0x00000079cec27219ULL, 0x040fe400000006ffULL, 0x0000007dcec87219ULL, 0x000fe400000006ffULL,
0x0000001baa00720cULL, 0x000fc40001f61070ULL, 0x0000001baa00720cULL, 0x080fe40000f21070ULL,
0x0000001bb000720cULL, 0x0c0fe400037c1070ULL, 0x0000001bb000720cULL, 0x0c0fe40000701070ULL,
0x0000001bb000720cULL, 0x080fe40001741070ULL, 0x0000001bb600720cULL, 0x0c0fe40002781070ULL,
0x0000001bb600720cULL, 0x000fc40002fa1070ULL, 0x00000075cece7219ULL, 0x000fe400000006ffULL,
0x00005410d27f7816ULL, 0x000fe4000000007fULL, 0xff80000070707808ULL, 0x000fe40001800000ULL,
0xff80000072727808ULL, 0x000fe40000800000ULL, 0xff80000009097808ULL, 0x000fe40003000000ULL,
0xff8000000b0b7808ULL, 0x000fc40000000000ULL, 0xff80000073737808ULL, 0x000fe40001000000ULL,
0xff80000024247808ULL, 0x000fe40002000000ULL, 0xff80000034347808ULL, 0x000fe40002800000ULL,
0x0000007bc2ff7212ULL, 0x080fe4000786c0ffULL, 0x0000007bc8ff7212ULL, 0x080fe4000782c0ffULL,
0x0000007bceff7212ULL, 0x000fc400078cc0ffULL, 0x0000007fbcff7212ULL, 0x080fe4000780c0ffULL,
0x0000007fc2ff7212ULL, 0x080fe4000784c0ffULL, 0x0000007fc8ff7212ULL, 0x000fe4000788c0ffULL,
0x00000083c2ff7212ULL, 0x000fe400078ac0ffULL, 0x0000001bb800720cULL, 0x080fe40000701470ULL,
0x0000001bc000720cULL, 0x000fc40001f61470ULL, 0x0000001bc000720cULL, 0x0c0fe40001741470ULL,
0x0000001bc000720cULL, 0x080fe40002fa1470ULL, 0x0000001bc600720cULL, 0x080fe40000f21470ULL,
0x0000001bcc00720cULL, 0x080fe400037c1470ULL, 0x0000001bc600720cULL, 0x080fe40002781470ULL,
0x0000001bb600720cULL, 0x000fc40000701070ULL, 0x0000001bbe00720cULL, 0x0c0fe40001f61070ULL,
0x0000001bbe00720cULL, 0x0c0fe40001741070ULL, 0x0000001bbe00720cULL, 0x080fe40002fa1070ULL,
0x0000001bc400720cULL, 0x080fe40000f21070ULL, 0x0000001bca00720cULL, 0x080fe400037c1070ULL,
0x0000001bc400720cULL, 0x000fc40002781070ULL, 0x00005410da877816ULL, 0x000fe40000000087ULL,
0xff80000026267808ULL, 0x000fe40000000000ULL, 0xff80000025257808ULL, 0x000fe40001800000ULL,
0xff80000027277808ULL, 0x000fe40001000000ULL, 0xff80000035357808ULL, 0x000fe40002800000ULL,
0xff80000050507808ULL, 0x000fc40000800000ULL, 0xff80000051517808ULL, 0x000fe40003000000ULL,
0xff80000052527808ULL, 0x000fe40002000000ULL, 0x0000007fceff7212ULL, 0x000fe4000780c0ffULL,
0x00000083c8ff7212ULL, 0x080fe4000786c0ffULL, 0x00000083ceff7212ULL, 0x000fe4000784c0ffULL,
0x00000087bcff7212ULL, 0x000fc400078ac0ffULL, 0x00000087c2ff7212ULL, 0x080fe4000782c0ffULL,
0x00000087c8ff7212ULL, 0x080fe400078cc0ffULL, 0x00000087ceff7212ULL, 0x000fe4000788c0ffULL,
0x0000001bb800720cULL, 0x080fe40002fa1470ULL, 0x0000001bc000720cULL, 0x080fe40000f21470ULL,
0x0000001bc600720cULL, 0x000fc40001f61470ULL, 0x0000001bc600720cULL, 0x080fe400037c1470ULL,
0x0000001bcc00720cULL, 0x0c0fe40000701470ULL, 0x0000001bcc00720cULL, 0x0c0fe40001741470ULL,
0x0000001bcc00720cULL, 0x080fe40002781470ULL, 0x0000001bb600720cULL, 0x080fe40002fa1070ULL,
0x0000001bbe00720cULL, 0x000fc40000f21070ULL, 0x0000001bca00720cULL, 0x080fe40000701070ULL,
0x0000001bc400720cULL, 0x0c0fe40001f61070ULL, 0x0000001bc400720cULL, 0x080fe400037c1070ULL,
0x0000001bca00720cULL, 0x0c0fe40001741070ULL, 0x0000001bca00720cULL, 0x000fe40002781070ULL,
0xff80000053537808ULL, 0x000fc40000000000ULL, 0xff8000006c6c7808ULL, 0x000fe40001800000ULL,
0xff8000006d6d7808ULL, 0x000fe40001000000ULL, 0xff80000036367808ULL, 0x000fe40002800000ULL,
0xff80000037377808ULL, 0x000fe40000800000ULL, 0xff8000006e6e7808ULL, 0x000fe40003000000ULL,
0xff8000006f6f7808ULL, 0x000fce0002000000ULL, 0x000000190400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff9a7224ULL, 0x000fe200078e008cULL, 0xfffffff8ff167812ULL, 0x000fe400078ee216ULL,
0x00000004191b7208ULL, 0x000fc80004000000ULL, 0x000000181b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b181b7208ULL, 0x000fc80004000000ULL, 0x000000441b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b44047208ULL, 0x000fc80004000000ULL, 0x000000450400720bULL, 0x000fc80003f1e000ULL,
0x00000004451b7208ULL, 0x000fc80004000000ULL, 0x0000003c1b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b3c047208ULL, 0x000fc80004000000ULL, 0x0000003d0400720bULL, 0x000fc80003f1e000ULL,
0x000000043d1b7208ULL, 0x000fc80004000000ULL, 0x000000381b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b38047208ULL, 0x000fc80004000000ULL, 0x000000390400720bULL, 0x000fc80003f1e000ULL,
0x00000004391b7208ULL, 0x000fc80004000000ULL, 0x0000000c1b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b0c047208ULL, 0x000fc80004000000ULL, 0x0000000d0400720bULL, 0x000fc80003f1e000ULL,
0x000000040d1b7208ULL, 0x000fc80004000000ULL, 0x0000001a1b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b1a047208ULL, 0x000fc80004000000ULL, 0x000000090400720bULL, 0x000fc80003f1e000ULL,
0x00000004091b7208ULL, 0x000fc80004000000ULL, 0x000000241b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b24047208ULL, 0x000fc80004000000ULL, 0x000000250400720bULL, 0x000fc80003f1e000ULL,
0x00000004251b7208ULL, 0x000fc80004000000ULL, 0x000000501b00720bULL, 0x000fc80003f1e000ULL,
0x0000001b50047208ULL, 0x000fe40004000000ULL, 0x000000020500720bULL, 0x000fe40003f1e000ULL,
0x000000510400720bULL, 0x000fe40003f3e000ULL, 0x0000000502057208ULL, 0x000fe40004000000ULL,
0x00000004511b7208ULL, 0x000fe40004800000ULL, 0x000000000500720bULL, 0x000fc60003f1e000ULL,
0x0c401f001b467f89ULL, 0x000ea200000e0000ULL, 0x0000000500047208ULL, 0x000fc80004000000ULL,
0x000000030400720bULL, 0x000fc80003f1e000ULL, 0x0000000403057208ULL, 0x000fc80004000000ULL,
0x000000140500720bULL, 0x000fc80003f1e000ULL, 0x0000000514047208ULL, 0x000fc80004000000ULL,
0x000000170400720bULL, 0x000fe40003f1e000ULL, 0x000000461b00720bULL, 0x004fe40003f3e000ULL,
0x0000000417047208ULL, 0x000fe40004000000ULL, 0x0000001b46437208ULL, 0x000fe40004800000ULL,
0x0000003f0400720bULL, 0x000fc60003f1e000ULL, 0x0c201f0043467f89ULL, 0x000ea200000e0000ULL,
0x000000043f057208ULL, 0x000fc80004000000ULL, 0x0000003a0500720bULL, 0x000fc80003f1e000ULL,
0x000000053a047208ULL, 0x000fc80004000000ULL, 0x0000003b0400720bULL, 0x000fc80003f1e000ULL,
0x000000043b057208ULL, 0x000fc80004000000ULL, 0x0000000e0500720bULL, 0x000fe40003f1e000ULL,
0x000000464300720bULL, 0x004fc80003f3e000ULL, 0x0000004346047208ULL, 0x000fe40004800000ULL,
0x000000050e467208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b041b7820ULL, 0x000fe20000410000ULL,
0x0000000f4600720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b18437823ULL, 0x100fe2000001081bULL,
0x000000460f057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001081bULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe2000001081bULL, 0x0000004300487308ULL, 0x0005e20000000800ULL,
0x0000000a0500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b44447823ULL, 0x100fe2000001081bULL,
0x3fb8aa3b45457823ULL, 0x100fe2000001081bULL, 0x3fb8aa3b51467823ULL, 0x100fe2000001081bULL,
0x000000050a187208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3d3d7823ULL, 0x000fc4000001081bULL,
0x0000001900477308ULL, 0x000fe20000000800ULL, 0x0000000b1800720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b38437823ULL, 0x104fe2000001081bULL, 0x3fb8aa3b0c387823ULL, 0x000fe4000001081bULL,
0x000000180b057208ULL, 0x000fc60004000000ULL, 0x0000003c004b7308ULL, 0x0005e20000000800ULL,
0x000000260500720bULL, 0x000fc80003f1e000ULL, 0x0000000526187208ULL, 0x000fc60004000000ULL,
0x0000004400497308ULL, 0x0007e20000000800ULL, 0x000000271800720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b393c7823ULL, 0x104fe2000001081bULL, 0x3fb8aa3b0d397823ULL, 0x000fe4000001081bULL,
0x0000001827057208ULL, 0x000fc60004000000ULL, 0x00000045004a7308ULL, 0x000fe20000000800ULL,
0x000000520500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b25447823ULL, 0x008fc6000001081bULL,
0x0000000552187208ULL, 0x000fc60004000000ULL, 0x0000003d004c7308ULL, 0x0005e20000000800ULL,
0x000000531800720bULL, 0x000fc80003f1e000ULL, 0x0000001853187208ULL, 0x000fe40004000000ULL,
0x000000410600720bULL, 0x000fe20003f1e000ULL, 0x0000003c004e7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b093d7823ULL, 0x104fe2000001081bULL, 0x0c401f0018197f89ULL, 0x000ea200000e0000ULL,
0x0000000641067208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b24097823ULL, 0x000fc6000001081bULL,
0x000000290600720bULL, 0x000fe20003f1e000ULL, 0x0000004300457308ULL, 0x0009e20000000800ULL,
0x3fb8aa3b1a3c7823ULL, 0x008fe4000001081bULL, 0x0000000629057208ULL, 0x000fc80004000000ULL,
0x000000280500720bULL, 0x000fe20003f1e000ULL, 0x0000003800387308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b50437823ULL, 0x010fe4000001081bULL, 0x0000000528057208ULL, 0x000fc80004000000ULL,
0x0000003e0500720bULL, 0x000fe20003f1e000ULL, 0x0000003900397308ULL, 0x000ee20000000800ULL,
0x000000191800720bULL, 0x004fe40003f3e000ULL, 0x000000053e057208ULL, 0x000fe40004000000ULL,
0x0000001819187208ULL, 0x000fe40004800000ULL, 0x0000002c0500720bULL, 0x000fe20003f1e000ULL,
0x0000003c003c7308ULL, 0x000fe40000000800ULL, 0x0c201f0018197f89ULL, 0x000ea200000e0000ULL,
0x000000052c067208ULL, 0x000fc40004000000ULL, 0x000000383938723eULL, 0x008fe400000000ffULL,
0x0000002d0600720bULL, 0x000fe20003f1e000ULL, 0x0000003d003d7308ULL, 0x000fe60000000800ULL,
0x000000062d057208ULL, 0x000fc80004000000ULL, 0x000000100500720bULL, 0x000fe20003f1e000ULL,
0x0000000900097308ULL, 0x000fe60000000800ULL, 0x0000000510067208ULL, 0x000fc80004000000ULL,
0x000000110600720bULL, 0x000fe20003f1e000ULL, 0x0000004400447308ULL, 0x000fe20000000800ULL,
0x000000191800720bULL, 0x004fe40003f3e000ULL, 0x00000006110d7208ULL, 0x000fe40004000000ULL,
0x0000001819057208ULL, 0x000fe40004800000ULL, 0x000000300d00720bULL, 0x000fe20003f1e000ULL,
0x0000004300437308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b050c7820ULL, 0x000fe20000410000ULL,
0x0000000d30067208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b03197823ULL, 0x100fe2000001080cULL,
0x000000310600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b02027823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001080cULL,
0x00000006310d7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b00067823ULL, 0x100fe2000001080cULL,
0x0000000200187308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe2000001080cULL,
0x000000700d00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe2000001080cULL,
0x0000000d70007208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe2000001080cULL,
0x00000006000d7308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe2000001080cULL,
0x000000710000720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001080cULL,
0x0000000071037208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b52527823ULL, 0x100fe2000001080cULL,
0x0000002a0700720bULL, 0x000fe20003f1e000ULL, 0x0000001900197308ULL, 0x000fe20000000800ULL,
0x000000340300720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b530c7823ULL, 0x000fe2000001080cULL,
0x000000072a007208ULL, 0x000fc40004000000ULL, 0x0000000334027208ULL, 0x004fe40004800000ULL,
0x0000002b0000720bULL, 0x000fe20003f1e000ULL, 0x0000001400147308ULL, 0x000ea20000000800ULL,
0x000000350200720bULL, 0x000fe40003f3e000ULL, 0x000000002b037208ULL, 0x000fe40004000000ULL,
0x0000000235077208ULL, 0x000fe40004800000ULL, 0x000000400300720bULL, 0x000fe20003f1e000ULL,
0x0000001700177308ULL, 0x000fe20000000800ULL, 0x0000006c0700720bULL, 0x000fc40003f3e000ULL,
0x0000000340037208ULL, 0x000fe40004000000ULL, 0x000000076c007208ULL, 0x000fe40004800000ULL,
0x000000420300720bULL, 0x000fe20003f1e000ULL, 0x0000003f001a7308ULL, 0x000fe20000000800ULL,
0x0000006d0000720bULL, 0x000fe40003f3e000ULL, 0x0000000342037208ULL, 0x000fe40004000000ULL,
0x000000006d027208ULL, 0x000fc40004800000ULL, 0x0000002e0300720bULL, 0x000fe20003f1e000ULL,
0x0000000e003f7308ULL, 0x0009e20000000800ULL, 0x000000180d0d723eULL, 0x008fe200000000ffULL,
0x0c401f0002077f89ULL, 0x000ee200000e0000ULL, 0x000000032e007208ULL, 0x000fe40004000000ULL,
0x000000094444723eULL, 0x000fe200000000ffULL, 0x0000100098097824ULL, 0x000fe200078e0295ULL,
0x0000002f0000720bULL, 0x000fe20003f1e000ULL, 0x0000000f00507308ULL, 0x0005620000000800ULL,
0x000000494a0e723eULL, 0x010fe200000000ffULL, 0x0000001816497836ULL, 0x000fe20000000000ULL,
0x000000002f037208ULL, 0x000fe20004000000ULL, 0x0001200009097836ULL, 0x000fc60000000000ULL,
0x000000120300720bULL, 0x000fe20003f1e000ULL, 0x0000000c004f7308ULL, 0x0009e20000000800ULL,
0x00000019140f723eULL, 0x004fe400000000ffULL, 0x0000000312007208ULL, 0x000fe40004000000ULL,
0x00000003494a7819ULL, 0x000fe400000006ffULL, 0x000000130000720bULL, 0x000fe20003f1e000ULL,
0x00000026004d7308ULL, 0x000fe20000000800ULL, 0x00000047480c723eULL, 0x010fc400000000ffULL,
0x0000000013037208ULL, 0x000fe40004000000ULL, 0x000000070200720bULL, 0x008fe40003f3e000ULL,
0x000000320300720bULL, 0x000fe20003f1e000ULL, 0x0000002700547308ULL, 0x000fe20000000800ULL,
0x0000000207027208ULL, 0x000fe40004800000ULL, 0x0000000332007208ULL, 0x000fe40004000000ULL,
0x0000003f5039723eULL, 0x022fe200000000ffULL, 0x0c201f0002077f89ULL, 0x000e6200000e0000ULL,
0x000000330000720bULL, 0x000fe20003f1e000ULL, 0x0000003a003a7308ULL, 0x000fe60000000800ULL,
0x0000000033037208ULL, 0x000fc80004000000ULL, 0x000000720300720bULL, 0x000fe20003f1e000ULL,
0x0000003b003b7308ULL, 0x000fe60000000800ULL, 0x0000000372007208ULL, 0x000fc80004000000ULL,
0x000000730000720bULL, 0x000fe20003f1e000ULL, 0x0000000a000a7308ULL, 0x000fe60000000800ULL,
0x0000000073037208ULL, 0x000fe40004000000ULL, 0x000000070200720bULL, 0x002fe40003f3e000ULL,
0x000000360300720bULL, 0x000fe20003f1e000ULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x0000000207067208ULL, 0x000fc40004800000ULL, 0x0000000336007208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b06027820ULL, 0x000fe20000410000ULL, 0x000000370000720bULL, 0x000fe20003f1e000ULL,
0x0000004600467308ULL, 0x000e640000000800ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010802ULL,
0x0000000037037208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010802ULL,
0x0000006e0300720bULL, 0x000fe20003f1e000ULL, 0x0000003100517308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010802ULL,
0x000000036e007208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010802ULL,
0x0000006f0000720bULL, 0x000fe20003f1e000ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b70707823ULL, 0x100fe20000010802ULL,
0x000000006f007208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b71717823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010802ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010802ULL,
0x3fb8aa3b6c6c7823ULL, 0x100fe20000010802ULL, 0x0c401f0000037f89ULL, 0x000ea200000e0000ULL,
0x0000003e001b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b6d027823ULL, 0x000fe20000010802ULL,
0x000000434646723eULL, 0x002fcc00000000ffULL, 0x0000004100417308ULL, 0x000ff00000000800ULL,
0x0000002900567308ULL, 0x000e620000000800ULL, 0x000000030000720bULL, 0x004fce0003f1e000ULL,
0x0000001000297308ULL, 0x0005e20000000800ULL, 0x0000000003007208ULL, 0x000fe40004000000ULL,
0x3c003c0000037802ULL, 0x000fe40000000f00ULL, 0x000000415618723eULL, 0x002fe200000000ffULL,
0x0c201f0000077f89ULL, 0x000e6400000e0000ULL, 0x0000001100587308ULL, 0x0007e20000000800ULL,
0x0000004b4c10723eULL, 0x004fe200000000ffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0038ULL,
0x0000001016417810ULL, 0x000fca0007ffe0ffULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0x000000171a11723eULL, 0x008fe200000000ffULL, 0x0000000841487824ULL, 0x000fe200078e00ffULL,
0x000000281b1a723eULL, 0x000fca00000000ffULL, 0x0000002d002d7308ULL, 0x000ea20000000800ULL,
0x000000070000720bULL, 0x002fce0003f1e000ULL, 0x0000000200537308ULL, 0x0003e20000000800ULL,
0x0000000007077208ULL, 0x000fe40004000000ULL, 0x0000000320ff7812ULL, 0x000fe4000780c0ffULL,
0x0000002c2d28723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b07317820ULL, 0x000fe20000410000ULL,
0x3c003c00ff027424ULL, 0x002fe200078e00ffULL, 0x00000030003e7308ULL, 0x0003e40000000800ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010831ULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x000000020c24723cULL, 0x000fe200000018ffULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b13307823ULL, 0x102fe20000010831ULL,
0x0000003a3b13723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b72727823ULL, 0x100fe20000010831ULL,
0x00000003153b7812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b73737823ULL, 0x100fe20000010831ULL,
0x0000002b002b7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010831ULL, 0x000000013b3b7824ULL, 0x000fe200078e0220ULL,
0x0000003c3d3a723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b6e6e7823ULL, 0x100fe20000010831ULL,
0x0000004000407308ULL, 0x000fe20000000800ULL, 0x000000073b3b7812ULL, 0x000fe200078ec0ffULL,
0x3fb8aa3b6f6f7823ULL, 0x000fe20000010831ULL, 0x0000000420157810ULL, 0x000fc40007ffe015ULL,
0xfffffff848487812ULL, 0x000fe400078ee23bULL, 0x0000002a2b19723eULL, 0x002fe200000000ffULL,
0x0000004200557308ULL, 0x000e620000000800ULL, 0x00000029582a723eULL, 0x000fe200000000ffULL,
0x0000001048487824ULL, 0x000fe200078e0209ULL, 0xfffffff84a4a7812ULL, 0x000fe400078ee23bULL,
0x0000000715157812ULL, 0x000fc600078ec0ffULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x000000104a4a7824ULL, 0x000fe200078e0209ULL, 0x00000040551b723eULL, 0x002fcc00000000ffULL,
0x0000002f002f7308ULL, 0x000e620000000800ULL, 0x0000000816407836ULL, 0x000fc80000000000ULL,
0x0000000840427824ULL, 0x040fe400078e00ffULL, 0x00000008403c7824ULL, 0x000fe200078e00ffULL,
0x0000001200007308ULL, 0x0005e20000000800ULL, 0x0000000849407824ULL, 0x000fe200078e00ffULL,
0xfffffff842427812ULL, 0x000fe400078ee23bULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee215ULL,
0xfffffff840407812ULL, 0x000fe200078ee215ULL, 0x0000001042427824ULL, 0x100fe200078e0209ULL,
0x0000002e2f29723eULL, 0x002fe200000000ffULL, 0x0000003000477308ULL, 0x000e620000000800ULL,
0x00000002182c723cULL, 0x000fe200000018ffULL, 0x000000454e12723eULL, 0x004fe200000000ffULL,
0x000000ffff4e7224ULL, 0x000fe200078e0044ULL, 0x0000004d5445723eULL, 0x000fe200000000ffULL,
0x000000103c3c7824ULL, 0x100fe200078e0209ULL, 0x0000003a004d7202ULL, 0x000fe20000000f00ULL,
0x0000001040407824ULL, 0x000fe200078e0209ULL, 0x0000007000707308ULL, 0x000fe20000000800ULL,
0x000000021024723cULL, 0x000fe20000001824ULL, 0x00000000472b723eULL, 0x002fcc00000000ffULL,
0x0000007100717308ULL, 0x000e620000000800ULL, 0x0000000816007824ULL, 0x000fca00078e00ffULL,
0xfffffff800007812ULL, 0x000fe400078ee23bULL, 0x0000003200147308ULL, 0x000fe20000000800ULL,
0x00000002282c723cULL, 0x000fe2000000182cULL, 0x0000000a0b3b723eULL, 0x000fe200000000ffULL,
0x00000008160a7824ULL, 0x000fe200078e00ffULL, 0x0000000900007211ULL, 0x000fc800078e20ffULL,
0x0000003300177308ULL, 0x0004e20000000800ULL, 0xfffffff80a0a7812ULL, 0x000fca00078ee215ULL,
0x000000100a0a7824ULL, 0x000fe400078e0209ULL, 0x0000007200727308ULL, 0x000fe20000000800ULL,
0x000000023830723cULL, 0x004fee0000001824ULL, 0x0000007300737308ULL, 0x000ea20000000800ULL,
0x0000003e5124723eULL, 0x000fc400000000ffULL, 0x000000707126723eULL, 0x002fe400000000ffULL,
0x000000141725723eULL, 0x008fe200000000ffULL, 0x000000ffff387224ULL, 0x000fe200078e0024ULL,
0x00000003413e7819ULL, 0x000fe200000006ffULL, 0x0000005200527308ULL, 0x000e660000000800ULL,
0xfffffff83e3e7812ULL, 0x000fe400078ee215ULL, 0x000000727327723eULL, 0x004fc600000000ffULL,
0x0000003400347308ULL, 0x000fe20000000800ULL, 0x000000093e3e7211ULL, 0x000fc600078e20ffULL,
0x00000002242c723cULL, 0x000fe2000000182cULL, 0x000000524f47723eULL, 0x002fc600000000ffULL,
0x0000003500357308ULL, 0x000e620000000800ULL, 0x000000ffff4f7224ULL, 0x000fe400078e0046ULL,
0x000000ffff247224ULL, 0x000fe200078e0025ULL, 0x000000024430723cULL, 0x000fe20000001830ULL,
0x0000002700257202ULL, 0x000fc60000000f00ULL, 0x0000006c006c7308ULL, 0x000ea20000000800ULL,
0x000000343514723eULL, 0x002fce00000000ffULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x000000ffff347224ULL, 0x000fe200078e000cULL, 0x0000000e00357202ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fe200078e000dULL, 0x0000000f000d7202ULL, 0x000fe20000000f00ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0011ULL, 0x0000003b00117202ULL, 0x000fe20000000f00ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0013ULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x0000006c5316723eULL, 0x004fe200000000ffULL, 0x000000ffff137224ULL, 0x000fc400078e0047ULL,
0x000000ffff3a7224ULL, 0x000fe400078e0014ULL, 0x000000ffff3b7224ULL, 0x000fe400078e0016ULL,
0x0000006e006e7308ULL, 0x000fe20000000800ULL, 0x000000ffff317224ULL, 0x000fe200078e0032ULL,
0x000000363715723eULL, 0x002fcc00000000ffULL, 0x0000006f00177308ULL, 0x000e620000000800ULL,
0x000000ffff367224ULL, 0x000fe400078e0010ULL, 0x000000ffff377224ULL, 0x000fe400078e0012ULL,
0x000000ffff107224ULL, 0x000fe200078e0039ULL, 0x0000002600397202ULL, 0x000fe20000000f00ULL,
0x000000ffff127224ULL, 0x000fe200078e0045ULL, 0x0000003400007844ULL, 0x0005e20000000200ULL,
0x000000ffff267224ULL, 0x000fc600078e0015ULL, 0x0000004c0a007844ULL, 0x0007e20000000200ULL,
0x0000006e1717723eULL, 0x002fc600000000ffULL, 0x0000000c42007844ULL, 0x0007e40000000200ULL,
0x000000ffff277224ULL, 0x000fe400078e0017ULL, 0x000000103c007844ULL, 0x0007e20000000200ULL,
0x00000002142c723cULL, 0x000fe2000000182cULL, 0x000000ffff347224ULL, 0x004fe200078e0018ULL,
0x0000001a00357202ULL, 0x000fe20000000f00ULL, 0x000000ffff367224ULL, 0x000fe400078e0028ULL,
0x000000ffff377224ULL, 0x000fc400078e002aULL, 0x000000ffff187224ULL, 0x000fe200078e0019ULL,
0x0000001b00197202ULL, 0x000fe20000000f00ULL, 0x000000ffff1a7224ULL, 0x000fe200078e0029ULL,
0x0000003448007844ULL, 0x0007e20000000200ULL, 0x000000ffff1b7224ULL, 0x000fe400078e002bULL,
0x00000001ff037424ULL, 0x000fe200078e00ffULL, 0x000000383e007844ULL, 0x0007e80000000200ULL,
0x000000184a007844ULL, 0x0007e80000000200ULL, 0x0000002440007844ULL, 0x0007e40000000200ULL,
0x0000002c00327202ULL, 0x000fe20000000f00ULL, 0x000000ffff337224ULL, 0x000fe200078e002eULL,
0x01e0000408008388ULL, 0x0007e80000000c00ULL, 0x01e2003008008388ULL, 0x0007e20000000c00ULL,
0x000000948c00720cULL, 0x000fe20003f06070ULL, 0x01e608031cff79a7ULL, 0x0007e2000850003fULL,
0x01e610031cff79a7ULL, 0x0007e2000850003fULL, 0x01e618031cff79a7ULL, 0x0007e2000850003fULL,
0x01e620031cff79a7ULL, 0x0007f2000850003fULL, 0xffffff7800b48947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x018000007c007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000007945ULL, 0x000fe60003800000ULL, 0x7f80000000057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000007c00008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000005ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff7cff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000005ff7212ULL, 0x000fe4000780c0ffULL,
0x800000007c057812ULL, 0x000fd600078ec0ffULL, 0x0080000005000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0005ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000007c00007308ULL, 0x0004e40000001000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffffe7006e07950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000100000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x0000000000000447ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005c8ULL, 0x00000000000001f8ULL, 0x0000001300000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000007c0ULL, 0x00000000000000d0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000890ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000008e4ULL, 0x0000000000000530ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e18ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e18ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000e60ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000e80ULL, 0x0000000000018d80ULL, 0x0000001300000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019c00ULL, 0x0000000000000038ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019c40ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000019c40ULL, 0x0000000000000270ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x000000000001a230ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x000000000001a230ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000000e60ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000000e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000018d80ULL,
0x0000000000018d80ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000019c00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000019c40ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000270ULL, 0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_0_m_32_sm_90_cubin_len = 107392;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
