/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_0_m_32_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b640ULL, 0x000000000001b2c0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL,
0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL,
0x616e7265746e695fULL, 0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL,
0x705f796c66625f63ULL, 0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL,
0x6c6668735f30376dULL, 0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL,
0x616475635f5f245fULL, 0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL,
0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL,
0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL,
0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000028ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b00220000036fULL, 0x00000000000199c0ULL, 0x0000000000000170ULL, 0x000b0022000003a2ULL,
0x0000000000019b30ULL, 0x0000000000000040ULL, 0x000b0022000003cdULL, 0x0000000000019b70ULL,
0x0000000000000050ULL, 0x000b0022000003f7ULL, 0x0000000000019bc0ULL, 0x0000000000000140ULL,
0x000a000300000465ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000485ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004b5ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000019d00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000199c000000000ULL, 0x0000040400000000ULL, 0x810c000001740400ULL,
0x0064f00400288080ULL, 0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808892ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x000199c000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8a08288080890828ULL, 0x2880808b08288080ULL,
0x808e082880808d08ULL, 0x0828808097082880ULL, 0x80809c082880809bULL, 0xa408288080a00828ULL,
0x288080a608288080ULL, 0x80e908288080e808ULL, 0x16288080d0082880ULL, 0x0000031028808280ULL,
0xd092000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL,
0x00019b3000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000084ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0x8a08288080890828ULL, 0x2880808b08288080ULL, 0x808e082880808d08ULL,
0x0828808097082880ULL, 0x80809c082880809bULL, 0xa508288080a00828ULL, 0x288080a608288080ULL,
0x80e908288080e808ULL, 0x16288080a4082880ULL, 0x0000031028808280ULL, 0xa492000000000000ULL,
0x0000002200288080ULL, 0x0000002cffffffffULL, 0x0000019800000000ULL, 0x00019b7000000000ULL,
0x0000005000000000ULL, 0x0000100400000000ULL, 0x80a6288080a40900ULL, 0x0000000000002880ULL,
0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8a08288080890828ULL, 0x2880808b08288080ULL,
0x808e082880808d08ULL, 0x0828808097082880ULL, 0x80809c082880809bULL, 0xa408288080a00828ULL,
0x288080a608288080ULL, 0x80e908288080e808ULL, 0x16288080a5082880ULL, 0x0000031028808280ULL,
0xa592000000000000ULL, 0x0000002200288080ULL, 0x0000002cffffffffULL, 0x0000026000000000ULL,
0x00019bc000000000ULL, 0x0000014000000000ULL, 0x0000080400000000ULL, 0x80a6288080a50900ULL,
0x0000000000002880ULL, 0x0000001700082f04ULL, 0x00082304000000daULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL,
0x0000000000000011ULL, 0x0000001100081204ULL, 0x0008110400000000ULL, 0x0000000000000011ULL,
0x0000001000082304ULL, 0x0008120400000000ULL, 0x0000000000000010ULL, 0x0000001000081104ULL,
0x0008230400000000ULL, 0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL,
0x0000000000000017ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0060016000000014ULL,
0x000c170400601903ULL, 0x0058000a00000000ULL, 0x000c17040021f000ULL, 0x0050000900000000ULL,
0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL,
0x000c17040061f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000e6000043104ULL,
0xffffffff01cc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000019001cc2804ULL, 0x000005a000000360ULL,
0x00002f1000001f30ULL, 0x000030e000002fd0ULL, 0x000033c000003250ULL, 0x0000373000003520ULL,
0x0000378000003770ULL, 0x00004080000037b0ULL, 0x0000501000004f70ULL, 0x000052a000005130ULL,
0x0000557000005410ULL, 0x000057b000005770ULL, 0x000057f0000057c0ULL, 0x00006d7000005eb0ULL,
0x00006f3000006e10ULL, 0x00007210000070a0ULL, 0x0000758000007370ULL, 0x000075d0000075c0ULL,
0x00007ca000007600ULL, 0x00008c5000008bb0ULL, 0x00008ee000008d70ULL, 0x000091b000009050ULL,
0x00009400000093c0ULL, 0x0000944000009410ULL, 0x00009c1000009c00ULL, 0x00009c3000009c20ULL,
0x0000ca500000c950ULL, 0x0000cab00000ca80ULL, 0x0000d6700000d630ULL, 0x0000d6900000d680ULL,
0x0001774000017700ULL, 0x0001776000017750ULL, 0x000177d0000177b0ULL, 0x00017800000177f0ULL,
0x00018b9000018b40ULL, 0x00018c2000018be0ULL, 0x00018ca000018c60ULL, 0x00018d4000018cf0ULL,
0x00018de000018d90ULL, 0x00018e8000018e30ULL, 0x00018f1000018ed0ULL, 0x00018f9000018f50ULL,
0x0001903000018fe0ULL, 0x000190d000019080ULL, 0x0001917000019120ULL, 0x00019200000191c0ULL,
0x0001928000019240ULL, 0x00019320000192d0ULL, 0x000193c000019370ULL, 0x0001946000019410ULL,
0x000194f0000194b0ULL, 0x0001957000019530ULL, 0x00019610000195c0ULL, 0x000196b000019660ULL,
0x0001976000019700ULL, 0x00019820000197c0ULL, 0x000198e000019880ULL, 0x000199a000019940ULL,
0x0000045002003904ULL, 0x00016600000000ffULL, 0x00000480003f0100ULL, 0x000166080000000dULL,
0x00000550003f0120ULL, 0x000166880000000dULL, 0x00000e80003f0120ULL, 0x00016600000000ffULL,
0x00000fe0003f0107ULL, 0x0001668c00000002ULL, 0x00001070003f0102ULL, 0x0001668800000002ULL,
0x00002bf0003f0101ULL, 0x0001660800000010ULL, 0x00002c30003f0101ULL, 0x0001660c00000006ULL,
0x00002e00003f0105ULL, 0x0001660c00000006ULL, 0x00004040003f0105ULL, 0x0001668800000017ULL,
0x00004c90003f0101ULL, 0x0001662800000024ULL, 0x00004cd0003f0101ULL, 0x0001662c00000026ULL,
0x00004ea0003f0105ULL, 0x0001662c00000026ULL, 0x00005e70003f0105ULL, 0x0000000000000024ULL,
0x00006ab0003f0101ULL, 0x0001664800000020ULL, 0x00006ad0003f0101ULL, 0x0001664c00000020ULL,
0x00006ca0003f0105ULL, 0x0001664c00000020ULL, 0x00007c80003f0105ULL, 0x000000000000001bULL,
0x00008900003f0101ULL, 0x000166680000001eULL, 0x00008920003f0101ULL, 0x0001666c0000001eULL,
0x00008af0003f0105ULL, 0x0001666c0000001eULL, 0x00009a70003f0105ULL, 0x000166a000000006ULL,
0x0000f580003f0101ULL, 0x00016600000000ffULL, 0x00010180003f0101ULL, 0x00016604000000ffULL,
0x00010390003f0105ULL, 0x00016604000000ffULL, 0x00014760003f0105ULL, 0x000000000000009bULL,
0x00014a70003f0101ULL, 0x000000040000009bULL, 0x00014c40003f0105ULL, 0x000000040000009bULL,
0x000189a0003f0105ULL, 0x000166080000009cULL, 0x00018a00003f0101ULL, 0x000166100000009cULL,
0x00018a60003f0101ULL, 0x000166180000009cULL, 0x00018ad0003f0101ULL, 0x000166200000009cULL,
0x00033803003f0101ULL, 0x0000e4e000301c04ULL, 0x0000e7a00000e510ULL, 0x0000eb800000e990ULL,
0x0000ef600000ed70ULL, 0x0000f3500000f150ULL, 0x000103f00000f500ULL, 0x0000040100018b10ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000304ULL, 0x0000001700000002ULL, 0x000000000000023cULL,
0x0000001700000002ULL, 0x0000000000000184ULL, 0x0000001700000002ULL, 0x00000000000000ccULL,
0x0000001700000002ULL, 0x0000000000000044ULL, 0x0000001700000002ULL, 0x00000000000002deULL,
0x0000001700000002ULL, 0x0000000000000216ULL, 0x0000001700000002ULL, 0x000000000000015eULL,
0x0000001700000002ULL, 0x00000000000000a8ULL, 0x0000001700000002ULL, 0x0000000000016700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000e7919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff030424ULL, 0x000fe200078e00ffULL,
0x000000010e040810ULL, 0x002fca0007ffe0ffULL, 0x00005c0004040625ULL, 0x000fc800078e0003ULL,
0x00005c000e020625ULL, 0x000fe200078e0003ULL, 0x0000000604090981ULL, 0x0002aa000c1e1900ULL,
0x0000000602020981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff107624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000967919ULL, 0x000e620000002600ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x00005a00ff117624ULL, 0x000fc400078e00ffULL, 0x00000000000a7919ULL, 0x000ee40000002300ULL,
0x0000590011117a24ULL, 0x000fe400078e02ffULL, 0x0000000000087919ULL, 0x000ee20000002100ULL,
0x0000000000007308ULL, 0x010f220000001000ULL, 0x00000004ff957e24ULL, 0x002fe2000f8e00ffULL,
0x0ffffffe00067810ULL, 0x010fe40007ffe0ffULL, 0x00000005ff977819ULL, 0x008fc80000011608ULL,
0x0000000600077305ULL, 0x0002e4000021f000ULL, 0x00001fff97977589ULL, 0x000fe200000e0000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x008fc800078e0a07ULL,
0x000059000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b07077227ULL, 0x000fcc00078e0006ULL,
0x00000400070b7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a0bULL,
0x0000040003007624ULL, 0x000fca00078e0210ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x000000010b0b2810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff0bba12ULL, 0x000fc800078e33ffULL, 0x0000000b00007306ULL, 0x000e620000209000ULL,
0x000000ff0b00720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00047810ULL, 0x002fcc0007ffe0ffULL, 0x0000000400057305ULL, 0x0002e4000021f000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000050b037224ULL, 0x008fc800078e02ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a03ULL, 0x0000000305057227ULL, 0x000fe400078e0004ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x0000009605227227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a22ULL, 0x000000000b007224ULL, 0x000fca00078e0296ULL,
0x0000000b0000720cULL, 0x000fe20003f66070ULL, 0x000001000a037a24ULL, 0x002fe400078e0203ULL,
0x00001fff0a0a7589ULL, 0x000e6400000e0000ULL, 0x00000000030d7a24ULL, 0x000fd000078e0208ULL,
0x0000000100003824ULL, 0x000fe200078e0a0bULL, 0x0000000122223810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0d00720cULL, 0x040fe40003f25270ULL, 0x0000000b0000720cULL, 0x000fe40003f86070ULL,
0x0000000f0d00780cULL, 0x040fe40003f44070ULL, 0x000000030d00780cULL, 0x000fce0003f64070ULL,
0x3fffff80ff049424ULL, 0x000fe400078e00ffULL, 0x0000000122224810ULL, 0x000fe20007ffe0ffULL,
0x7fffff80ff059424ULL, 0x000fe200078e00ffULL, 0x0000000bff22d212ULL, 0x000fe200078e33ffULL,
0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL, 0x0000007f0d00780cULL, 0x000fe20003f84070ULL,
0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL, 0x01660004ff009388ULL, 0x000fe20000000a00ULL,
0x000000ffff007224ULL, 0x000fe400078e0a22ULL, 0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL,
0x016608060d00a388ULL, 0x000fe20000008a00ULL, 0x000000000b967224ULL, 0x000fc800078e0296ULL,
0x0000002096967824ULL, 0x000fe400078e00ffULL, 0xff317217ff0cc424ULL, 0x000fca00078e00ffULL,
0x0164000c0d00c388ULL, 0x000fe20000004800ULL, 0x00000001099a0824ULL, 0x004fe400078e0a02ULL,
0x00005800ff9a8624ULL, 0x000fe400078e00ffULL, 0x000058000e028a24ULL, 0x000fe400078e02ffULL,
0x00005a009a037a24ULL, 0x000fe400078e02ffULL, 0x7fffff60ff09b424ULL, 0x000fe400078e00ffULL,
0x0000000103007824ULL, 0x040fe200078e0a96ULL, 0x000000960300720cULL, 0x000fe20003f26070ULL,
0x00000011027e7224ULL, 0x000fe200078e02ffULL, 0x016688080d00b388ULL, 0x000fe40000008a00ULL,
0x0000002000007817ULL, 0x000fe20003800000ULL, 0x00005a0022147a24ULL, 0x000fc600078e027eULL,
0x000000ff007d7207ULL, 0x000fe20000800000ULL, 0x000000040a007824ULL, 0x002fe200078e0297ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000207d00780cULL, 0x000fe20003f05270ULL,
0x0000000400037824ULL, 0x000fd800078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00005a0000087b06ULL, 0x000e620000209000ULL, 0x0000000000007919ULL, 0x000eae0000000000ULL,
0x0000000800087308ULL, 0x002e620000001000ULL, 0x00000004ff067819ULL, 0x004fc80000011600ULL,
0x00000002060b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000103077824ULL, 0x000fe200078e0206ULL,
0x0ffffffe08047810ULL, 0x002fc60007ffe0ffULL, 0x00000001030d7824ULL, 0x000fe200078e020bULL,
0x0000000400057305ULL, 0x0002a6000021f000ULL, 0x00000001960f7824ULL, 0x000fe400078e020dULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000ffff097224ULL, 0x004fc800078e0a05ULL,
0x00005a0009097a24ULL, 0x000fc800078e02ffULL, 0x0000000905087227ULL, 0x000fc800078e0004ULL,
0x0000000196057824ULL, 0x000fe400078e0207ULL, 0x0000000f080c7227ULL, 0x000fc800078e00ffULL,
0x0000000508047227ULL, 0x000fc800078e00ffULL, 0x000000ffff087224ULL, 0x000fe400078e0a04ULL,
0x000000ffff127224ULL, 0x000fe400078e0a0cULL, 0x00005a0008087a24ULL, 0x000fe400078e0205ULL,
0x00005a0012097a24ULL, 0x000fc600078e020fULL, 0x00005a0008007a0cULL, 0x000fe40003f06070ULL,
0x00005a0009007a0cULL, 0x000fd60003f46070ULL, 0x80005a0008080a10ULL, 0x000fe40007ffe0ffULL,
0x80005a0009092a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0008007a0cULL, 0x000fe40003f26070ULL,
0x00005a0009007a0cULL, 0x000fe40003f66070ULL, 0x0000000104040810ULL, 0x000fe40007ffe0ffULL,
0x000000010c0c2810ULL, 0x000fc40007ffe0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x00005a00ff097a12ULL, 0x000fc600078e33ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x000000010c0c3810ULL, 0x000fe40007ffe0ffULL, 0x0000000409087207ULL, 0x040fe40004000000ULL,
0x0000000c09097207ULL, 0x000fe40004000000ULL, 0x000000037d047217ULL, 0x000fe20007800000ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x000000ffff127224ULL, 0x000fc400078e0a09ULL,
0x00005a000c057a24ULL, 0x000fe400078e0205ULL, 0x00005a00120f7a24ULL, 0x000fe400078e020fULL,
0x0000000104047824ULL, 0x000fe400078e0a03ULL, 0x0000000114057824ULL, 0x040fe400078e0205ULL,
0x00000001140c7824ULL, 0x000fe200078e020fULL, 0x000000040600720cULL, 0x080fe20003f06070ULL,
0x0000001108057224ULL, 0x000fe200078e0205ULL, 0x000000040b00720cULL, 0x000fe20003f26070ULL,
0x0000001000067824ULL, 0x000fc400078e00ffULL, 0x0000001109097224ULL, 0x000fe400078e020cULL,
0x0000010005047825ULL, 0x000fe200078e00ffULL, 0x000000f006037812ULL, 0x000fc600078ec0ffULL,
0x0000010009087825ULL, 0x000fe200078e00ffULL, 0x0000000304047212ULL, 0x000fc600078efcffULL,
0x00000001070b7824ULL, 0x140fe200078e0200ULL, 0x0000000308037212ULL, 0x000fe200078efcffULL,
0x00000010070c7824ULL, 0x000fe200078e00ffULL, 0x0000600004047a10ULL, 0x000fe20007f5e0ffULL,
0x000000010d077824ULL, 0x000fe200078e0200ULL, 0x0000600003087a10ULL, 0x000fe20007f7e0ffULL,
0x000000100d127824ULL, 0x000fe200078e00ffULL, 0xfffffff00c0b7812ULL, 0x000fe400078ee20bULL,
0x0000610005057a10ULL, 0x000fe400017fe4ffULL, 0xfffffff012077812ULL, 0x000fe200078ee207ULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x0000610009097a10ULL, 0x000fc60001ffe4ffULL,
0x0000001007077824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e8000c101c46ULL, 0x0000000008077faeULL, 0x0003e2000c901c46ULL,
0x0000040000007947ULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fcc00078e00ffULL,
0x0000000600067308ULL, 0x002e620000001000ULL, 0x0000000300037211ULL, 0x004fc800078fe0ffULL,
0x00000002030b7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffe06087810ULL, 0x002fc60007ffe0ffULL,
0x000000100b127824ULL, 0x000fe200078e00ffULL, 0x0000000800057305ULL, 0x000e64000021f000ULL,
0x000000ffff077224ULL, 0x002fc800078e0a05ULL, 0x00005a0007077a24ULL, 0x000fc800078e02ffULL,
0x0000000705097227ULL, 0x000fc800078e0004ULL, 0x0000000196047824ULL, 0x040fe400078e0203ULL,
0x0000000196077824ULL, 0x000fe400078e020bULL, 0x0000000409057227ULL, 0x000fc800078e00ffULL,
0x0000000709087227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fe400078e0a05ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x00005a0009067a24ULL, 0x000fe400078e0204ULL,
0x00005a000c097a24ULL, 0x000fe400078e0207ULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x00005a0006007a0cULL, 0x000fe40003f06070ULL, 0x00005a0009007a0cULL, 0x000fd60003f46070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0009092a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f26070ULL, 0x00005a0009007a0cULL, 0x000fe40003f66070ULL,
0x0000000105050810ULL, 0x000fe40007ffe0ffULL, 0x0000000108082810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff067a12ULL, 0x000fc600078e33ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x0000000108083810ULL, 0x000fe40007ffe0ffULL,
0x0000000506057207ULL, 0x040fe40004000000ULL, 0x0000000806087207ULL, 0x000fc60004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a05ULL, 0x000000ffff067224ULL, 0x000fe400078e0a08ULL,
0x00005a0009047a24ULL, 0x000fe400078e0204ULL, 0x00005a0006077a24ULL, 0x000fe400078e0207ULL,
0x0000000114047824ULL, 0x040fe400078e0204ULL, 0x0000000114077824ULL, 0x000fc400078e0207ULL,
0x0000001000067824ULL, 0x000fe400078e00ffULL, 0x0000001105047224ULL, 0x080fe400078e0204ULL,
0x0000001108087224ULL, 0x000fe200078e0207ULL, 0x000000f0060d7812ULL, 0x000fe200078ec0ffULL,
0x0000010004047825ULL, 0x000fc800078e00ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000d04047212ULL, 0x000fc600078efcffULL, 0x0000000103077824ULL, 0x100fe200078e0200ULL,
0x0000000d08087212ULL, 0x000fe200078efcffULL, 0x000000010b037824ULL, 0x000fe200078e0200ULL,
0x0000600004047a10ULL, 0x000fe40007f1e0ffULL, 0xfffffff00c077812ULL, 0x000fe400078ee207ULL,
0xfffffff012037812ULL, 0x000fe400078ee203ULL, 0x0000600008087a10ULL, 0x000fe20007f3e0ffULL,
0x0000001007077824ULL, 0x000fe200078e00ffULL, 0x0000610005057a10ULL, 0x000fe200007fe4ffULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0x0000610009097a10ULL, 0x000fc60000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000b901c46ULL,
0x0000000008037faeULL, 0x0003e4000b901c46ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000037806ULL, 0x000fe200038e0000ULL, 0x00000004ff997424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000300047300ULL, 0x000e7000000e0000ULL,
0x0000000300077309ULL, 0x000ea20000000000ULL, 0x000000050400720cULL, 0x002fe20003f02070ULL,
0x000066000e047625ULL, 0x000fc800078e0099ULL, 0x000000ffff077224ULL, 0x004fd000078e0a07ULL,
0x01660407ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01660000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000604947981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0a00720cULL, 0x000fe40003f05270ULL, 0x000000ff94237810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff237819ULL, 0x000fce0000011623ULL, 0x0000e57000008947ULL, 0x000fea0003800000ULL,
0x000000020e037824ULL, 0x000fe400078e00ffULL, 0x0000000897027824ULL, 0x000fe400078e00ffULL,
0x00000003ff057424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01668c0502ff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000195047810ULL, 0x000fe20007ffe0ffULL, 0x0000590003057624ULL, 0x004fe200078e0210ULL,
0x00000001ff1a7819ULL, 0x000fe20000011697ULL, 0x0166880002ff7f8cULL, 0x0005e2000c80043fULL,
0x000000230400720cULL, 0x000fe20003f06070ULL, 0x0000000122047824ULL, 0x000fe200078e0205ULL,
0x0000000197057812ULL, 0x000fe200078ec0ffULL, 0x000000201a037824ULL, 0x000fc800078e00ffULL,
0x0000010095097824ULL, 0x000fc800078e0203ULL, 0x0000680004277a24ULL, 0x000fe400078e0209ULL,
0x0000064000008947ULL, 0x000fea0003800000ULL, 0x00000003ff147819ULL, 0x104fe40000011600ULL,
0x0000000994077217ULL, 0x002fe40007800000ULL, 0x0000000414087810ULL, 0x040fe40007ffe0ffULL,
0x0000000c140d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107077824ULL, 0x000fe200078e0a09ULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x0000000108097824ULL, 0x100fe200078e0200ULL,
0x00000008140c7810ULL, 0x000fe20007ffe0ffULL, 0x00000008080e7824ULL, 0x000fe200078e00ffULL,
0x0000002007157817ULL, 0x000fe20003800000ULL, 0x000000010d0b7824ULL, 0x040fe200078e0200ULL,
0x0000001014127810ULL, 0x000fe20007ffe0ffULL, 0x000000080d107824ULL, 0x000fe200078e00ffULL,
0xfffffff80e197812ULL, 0x000fe200078ee209ULL, 0x0000008005067824ULL, 0x000fe200078e0206ULL,
0x000000150800720cULL, 0x080fe20003f86070ULL, 0x0000000127097824ULL, 0x000fe200078e0214ULL,
0xfffffff8101d7812ULL, 0x000fe200078ee20bULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x0000001414187810ULL, 0x000fe20007ffe0ffULL, 0x000000010c0a7824ULL, 0x040fe200078e0200ULL,
0x000000150c00720cULL, 0x0c0fe20003f66070ULL, 0x000000080c1b7824ULL, 0x000fe200078e00ffULL,
0x000000150d00720cULL, 0x080fe20003f46070ULL, 0x00000001270b7824ULL, 0x000fe200078e0208ULL,
0x000000151400720cULL, 0x000fe20003fa6070ULL, 0x0000010009087825ULL, 0x000fe200078e0006ULL,
0xfffffff81b1b7812ULL, 0x000fc600078ee20aULL, 0x00000001120f7824ULL, 0x000fe200078e0200ULL,
0x00006400080e7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000812167824ULL, 0x000fe400078e00ffULL,
0x000001000b0a7825ULL, 0x000fc600078e0006ULL, 0xfffffff8161f7812ULL, 0x000fe200078ee20fULL,
0x0000000118117824ULL, 0x000fe200078e0200ULL, 0x000064000a107a10ULL, 0x000fe20007f3e0ffULL,
0x00000008181c7824ULL, 0x000fe200078e00ffULL, 0x00006500090f7a10ULL, 0x000fe200007fe4ffULL,
0x0000000127097824ULL, 0x000fe400078e020cULL, 0x00000001140c7824ULL, 0x000fe200078e0200ULL,
0xfffffff81c217812ULL, 0x000fe200078ee211ULL, 0x0000010009087825ULL, 0x000fe200078e0006ULL,
0x000065000b117a10ULL, 0x000fc40000ffe4ffULL, 0x000000151200720cULL, 0x080fe20003f26070ULL,
0x00000001270b7824ULL, 0x040fe200078e020dULL, 0x000000070c177812ULL, 0x000fe200078ec0ffULL,
0x00000001270d7824ULL, 0x000fe200078e0212ULL, 0x0000640008127a10ULL, 0x000fe20007f1e0ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0006ULL, 0x0ffffff817177812ULL, 0x000fe400078ef800ULL,
0x0000650009137a10ULL, 0x000fe200007fe4ffULL, 0x000000021a167824ULL, 0x000fe200078e0205ULL,
0x000064000a0a7a10ULL, 0x000fe20007fde0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e0006ULL,
0x000000151800720cULL, 0x000fc40003f06070ULL, 0x0000e00016167811ULL, 0x000fe200078e68ffULL,
0x0000000127097824ULL, 0x000fe200078e0218ULL, 0x000065000b0b7a10ULL, 0x000fe400037fe4ffULL,
0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x0000010009087825ULL, 0x000fe200078e0006ULL,
0x0000001814187810ULL, 0x040fe40007ffe0ffULL, 0x000065000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x0000001017177824ULL, 0x100fe200078e0216ULL, 0x0000001c141c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001019197824ULL, 0x000fe200078e0216ULL, 0x0000640008147a10ULL, 0x000fe20007fde0ffULL,
0x0000000127257824ULL, 0x040fe200078e0218ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e177faeULL, 0x0003e2000e901c46ULL, 0x000000151800720cULL, 0x000fe20003fa6070ULL,
0x0000000127277824ULL, 0x000fc400078e021cULL, 0x0000000010197faeULL, 0x0005e2000e101c46ULL,
0x000000151c00720cULL, 0x000fe20003f86070ULL, 0x000000101b1b7824ULL, 0x000fe200078e0216ULL,
0x0000650009157a10ULL, 0x000fe200037fe4ffULL, 0x0000010025087825ULL, 0x000fc600078e0006ULL,
0x00000000121b7faeULL, 0x0007e2000d901c46ULL, 0x00000001180e7824ULL, 0x102fe200078e0200ULL,
0x0000640008087a10ULL, 0x000fe20007fde0ffULL, 0x00000008180f7824ULL, 0x000fe400078e00ffULL,
0x000000011c107824ULL, 0x044fe200078e0200ULL, 0x0000650009097a10ULL, 0x000fe200037fe4ffULL,
0x000000081c117824ULL, 0x000fe200078e00ffULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee20eULL,
0x0000010027067825ULL, 0x000fc600078e0006ULL, 0xfffffff811117812ULL, 0x000fe200078ee210ULL,
0x000000101d1d7824ULL, 0x100fe200078e0216ULL, 0x0000640006067a10ULL, 0x000fe20007fde0ffULL,
0x000000101f1f7824ULL, 0x100fe400078e0216ULL, 0x0000001021217824ULL, 0x100fe200078e0216ULL,
0x0000650007077a10ULL, 0x000fe200037fe4ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0216ULL,
0x000000000a1d7faeULL, 0x0007e2000d101c46ULL, 0x0000001011117824ULL, 0x000fc600078e0216ULL,
0x000000000c1f7faeULL, 0x0007e8000c901c46ULL, 0x0000000014217faeULL, 0x0007e8000c101c46ULL,
0x00000000080f7faeULL, 0x0007e8000e901c46ULL, 0x0000000006117faeULL, 0x0007e2000e101c46ULL,
0x0000057000007947ULL, 0x000fea0003800000ULL, 0x00000008000d7811ULL, 0x044fe400078fe8ffULL,
0x0000000400077811ULL, 0x002fc400078fe8ffULL, 0x0000001400137811ULL, 0x040fe200078fe8ffULL,
0x000000010d097824ULL, 0x140fe200078e0200ULL, 0x0000001000117811ULL, 0x040fe200078fe8ffULL,
0x000000080d0a7824ULL, 0x000fe200078e00ffULL, 0x0000001800157811ULL, 0x040fe200078fe8ffULL,
0x0000000107087824ULL, 0x140fe200078e0200ULL, 0x0000000c000f7811ULL, 0x000fe200078fe8ffULL,
0x00000008070b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a1b7812ULL, 0x000fe200078ee209ULL,
0x00000001130a7824ULL, 0x040fe200078e0200ULL, 0x0000007006147812ULL, 0x000fe200078ec0ffULL,
0x0000000813197824ULL, 0x000fe200078e00ffULL, 0xfffffff80b187812ULL, 0x000fe200078ee208ULL,
0x0000000111097824ULL, 0x040fe200078e0200ULL, 0x0000000000067211ULL, 0x040fe200078fe8ffULL,
0x00000008111e7824ULL, 0x000fe200078e00ffULL, 0xfffffff819207812ULL, 0x000fe200078ee20aULL,
0x00000001150b7824ULL, 0x140fe200078e0200ULL, 0x0000001c00197811ULL, 0x000fe200078fe8ffULL,
0x0000000815247824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee209ULL,
0x000000010f087824ULL, 0x140fe200078e0200ULL, 0x0000000706097812ULL, 0x000fe200078ec0ffULL,
0x000000080f177824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee20bULL,
0x00000001270b7824ULL, 0x000fe200078e0207ULL, 0x0000002700077211ULL, 0x000fe200078fe8ffULL,
0x0000000119067824ULL, 0x000fe200078e0200ULL, 0xfffffff8171c7812ULL, 0x000fe200078ee208ULL,
0x00000008191d7824ULL, 0x000fe200078e00ffULL, 0x0ffffff809167812ULL, 0x000fe200078ef800ULL,
0x000000021a087824ULL, 0x000fc400078e0205ULL, 0x0000000127177824ULL, 0x000fe200078e0215ULL,
0xfffffff81d267812ULL, 0x000fe200078ee206ULL, 0x0000008005147824ULL, 0x000fe400078e0214ULL,
0x000000ffff157224ULL, 0x000fe400078e00ffULL, 0x00000001270d7824ULL, 0x040fe400078e020dULL,
0x00000001270f7824ULL, 0x040fe400078e020fULL, 0x0000000127117824ULL, 0x000fc400078e0211ULL,
0x0000000127137824ULL, 0x040fe400078e0213ULL, 0x0000000127197824ULL, 0x000fe200078e0219ULL,
0x0000e00008277811ULL, 0x000fe200078e68ffULL, 0x0000010007067825ULL, 0x000fc800078e0014ULL,
0x000001000b087825ULL, 0x000fe200078e0014ULL, 0x0000640006067a10ULL, 0x000fc60007f1e0ffULL,
0x000001000d0a7825ULL, 0x100fe200078e0014ULL, 0x0000640008087a10ULL, 0x000fe40007f3e0ffULL,
0x0000650007077a10ULL, 0x000fe200007fe4ffULL, 0x000001000f0c7825ULL, 0x100fe200078e0014ULL,
0x000064000a0a7a10ULL, 0x000fe40007f5e0ffULL, 0x0000650009097a10ULL, 0x000fe20000ffe4ffULL,
0x00000100110e7825ULL, 0x100fe200078e0014ULL, 0x000064000c0c7a10ULL, 0x000fe40007f7e0ffULL,
0x000065000b0b7a10ULL, 0x000fe200017fe4ffULL, 0x0000010013107825ULL, 0x000fe200078e0014ULL,
0x000064000e0e7a10ULL, 0x000fc40007f1e0ffULL, 0x000065000d0d7a10ULL, 0x000fe20001ffe4ffULL,
0x0000010017127825ULL, 0x100fe200078e0014ULL, 0x0000640010107a10ULL, 0x000fe40007f3e0ffULL,
0x000065000f0f7a10ULL, 0x000fe200007fe4ffULL, 0x0000010019147825ULL, 0x000fe200078e0014ULL,
0x0000640012127a10ULL, 0x000fe40007f5e0ffULL, 0x0000650011117a10ULL, 0x000fe20000ffe4ffULL,
0x0000001016177824ULL, 0x100fe200078e0227ULL, 0x0000640014147a10ULL, 0x000fe20007f7e0ffULL,
0x0000001018197824ULL, 0x100fe200078e0227ULL, 0x0000650013137a10ULL, 0x000fe200017fe4ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0227ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006177faeULL, 0x0003e2000b901c46ULL, 0x000000101c1d7824ULL, 0x100fe200078e0227ULL,
0x0000650015157a10ULL, 0x000fe20001ffe4ffULL, 0x000000101e1f7824ULL, 0x100fe200078e0227ULL,
0x0000000008197faeULL, 0x0003e2000b901c46ULL, 0x0000001020217824ULL, 0x000fc400078e0227ULL,
0x0000001024257824ULL, 0x100fe200078e0227ULL, 0x000000000a1b7faeULL, 0x0003e2000b901c46ULL,
0x0000001026277824ULL, 0x000fc600078e0227ULL, 0x000000000c1d7faeULL, 0x0003e8000b901c46ULL,
0x000000000e1f7faeULL, 0x0003e8000b901c46ULL, 0x0000000010217faeULL, 0x0003e8000b901c46ULL,
0x0000000012257faeULL, 0x0003e8000b901c46ULL, 0x0000000014277faeULL, 0x0003e4000b901c46ULL,
0x000000239500720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff1c7424ULL, 0x000fe200078e00ffULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x000000ffff1f7224ULL, 0x00afe200078e00ffULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00007bb000000947ULL, 0x000fea0003800000ULL, 0xff317217ff1c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff677224ULL, 0x000fc400078e00ffULL, 0x0000000195067810ULL, 0x040fe20007ffe0ffULL,
0x0000010095207824ULL, 0x000fe200078e0203ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000230600720cULL, 0x000fe40003f06070ULL, 0x00000040200d7810ULL, 0x020fca0007ffe0ffULL,
0x0000680004277a24ULL, 0x000fcc00078e020dULL, 0x0000065000008947ULL, 0x000fea0003800000ULL,
0x00000003ff197819ULL, 0x100fe20000011600ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x0000000d94067217ULL, 0x000fe20007800000ULL, 0x000000021a1b7824ULL, 0x000fe200078e0205ULL,
0x00000004190f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000119147824ULL, 0x140fe200078e0200ULL,
0x0000000819117810ULL, 0x040fe20007ffe0ffULL, 0x0000000106067824ULL, 0x000fe200078e0a0dULL,
0x0000000c19157810ULL, 0x000fe20007ffe0ffULL, 0x000000010f0c7824ULL, 0x100fe200078e0200ULL,
0x0000001019217810ULL, 0x000fe20007ffe0ffULL, 0x000000080f137824ULL, 0x000fe200078e00ffULL,
0x0000002006067817ULL, 0x000fe20003800000ULL, 0x00000001110d7824ULL, 0x000fe200078e0200ULL,
0x0000001419697810ULL, 0x000fe20007ffe0ffULL, 0x00000008111e7824ULL, 0x000fe200078e00ffULL,
0xfffffff813187812ULL, 0x000fe200078ee20cULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x000000060f00720cULL, 0x080fe20003f86070ULL, 0x00000001150e7824ULL, 0x100fe200078e0200ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20dULL, 0x00000001190d7824ULL, 0x000fe200078e0227ULL,
0x000000700c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000815137824ULL, 0x040fe200078e00ffULL,
0x000000061500720cULL, 0x080fe20003f26070ULL, 0x0000000169107824ULL, 0x000fe200078e0200ULL,
0x000000061900720cULL, 0x000fe20003f66070ULL, 0x0000008005247824ULL, 0x000fe200078e020cULL,
0xfffffff813267812ULL, 0x000fe200078ee20eULL, 0x00000001210e7824ULL, 0x000fe200078e0200ULL,
0x0000f0001b1b7811ULL, 0x000fe200078e68ffULL, 0x000001000d0c7825ULL, 0x000fe200078e0024ULL,
0x00000018196b7810ULL, 0x000fc40007ffe0ffULL, 0x0000001c196d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000821137824ULL, 0x000fe200078e00ffULL, 0x000064000c127a10ULL, 0x000fe20007f1e0ffULL,
0x0000000869177824ULL, 0x040fe400078e00ffULL, 0x0000000169197824ULL, 0x000fe200078e0227ULL,
0xfffffff813687812ULL, 0x000fe200078ee20eULL, 0x00000010181d7824ULL, 0x000fe200078e021bULL,
0x000065000d137a10ULL, 0x000fe200007fe4ffULL, 0x000000010f0d7824ULL, 0x100fe200078e0227ULL,
0x000000061100720cULL, 0x040fe20003f06070ULL, 0x00000001110f7824ULL, 0x000fe200078e0227ULL,
0xfffffff8176a7812ULL, 0x000fe200078ee210ULL, 0x000001000d0c7825ULL, 0x000fc800078e0024ULL,
0x0000000115117824ULL, 0x000fe200078e0227ULL, 0x0000000714157812ULL, 0x000fe200078ec0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0024ULL, 0x000064000c147a10ULL, 0x000fe40007f5e0ffULL,
0x0ffffff8150c7812ULL, 0x000fe200078ef800ULL, 0x0000010011107825ULL, 0x000fe200078e0024ULL,
0x000064000e167a10ULL, 0x000fe40007fbe0ffULL, 0x000065000d157a10ULL, 0x000fe200017fe4ffULL,
0x00000001210d7824ULL, 0x000fe200078e0227ULL, 0x000065000f177a10ULL, 0x000fe20002ffe4ffULL,
0x000000100c0f7824ULL, 0x000fe200078e021bULL, 0x0000640010107a10ULL, 0x000fe20007fde0ffULL,
0x000001000d0c7825ULL, 0x000fe200078e0024ULL, 0x000000062100720cULL, 0x000fc40003f46070ULL,
0x0000650011117a10ULL, 0x000fe200037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120f7faeULL, 0x0003e2000d901c46ULL, 0x000064000c187a10ULL, 0x000fe20007fde0ffULL,
0x000000016b217824ULL, 0x000fe200078e0227ULL, 0x000000066d00720cULL, 0x080fe20003f66070ULL,
0x00000000141d7faeULL, 0x0005e2000e101c46ULL, 0x000000066900720cULL, 0x080fe40003fa6070ULL,
0x000000066b00720cULL, 0x040fe20003f86070ULL, 0x000000016b067824ULL, 0x040fe400078e0200ULL,
0x000000086b6b7824ULL, 0x000fc400078e00ffULL, 0x00000100190e7825ULL, 0x002fe200078e0024ULL,
0x000065000d197a10ULL, 0x000fe400037fe4ffULL, 0xfffffff86b067812ULL, 0x000fe200078ee206ULL,
0x000000016d157824ULL, 0x044fe200078e0227ULL, 0x000064000e127a10ULL, 0x000fe20007fde0ffULL,
0x000000016d0e7824ULL, 0x040fe400078e0200ULL, 0x000000086d6d7824ULL, 0x000fe200078e00ffULL,
0x000065000f137a10ULL, 0x000fe200037fe4ffULL, 0x00000100210c7825ULL, 0x000fc600078e0024ULL,
0xfffffff86d147812ULL, 0x000fe200078ee20eULL, 0x00000100150e7825ULL, 0x000fe200078e0024ULL,
0x000064000c0c7a10ULL, 0x000fc60007fde0ffULL, 0x000000101e157824ULL, 0x100fe200078e021bULL,
0x000065000d0d7a10ULL, 0x000fe200037fe4ffULL, 0x00000010261d7824ULL, 0x100fe200078e021bULL,
0x000064000e0e7a10ULL, 0x000fe20007fde0ffULL, 0x0000001068217824ULL, 0x100fe200078e021bULL,
0x0000000016157faeULL, 0x0003e2000c101c46ULL, 0x000000106a257824ULL, 0x100fe200078e021bULL,
0x000065000f0f7a10ULL, 0x000fe200037fe4ffULL, 0x0000001006277824ULL, 0x100fe200078e021bULL,
0x00000000101d7faeULL, 0x0003e2000c901c46ULL, 0x00000010141b7824ULL, 0x000fc600078e021bULL,
0x0000000018217faeULL, 0x0003e8000d101c46ULL, 0x0000000012257faeULL, 0x0003e8000e901c46ULL,
0x000000000c277faeULL, 0x0003e8000e101c46ULL, 0x000000000e1b7faeULL, 0x0003e2000d901c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000c00137811ULL, 0x040fe400078fe8ffULL,
0x0000000800117811ULL, 0x000fc400078fe8ffULL, 0x00000004000f7811ULL, 0x040fe200078fe8ffULL,
0x00000001130d7824ULL, 0x140fe200078e0200ULL, 0x0000001800197811ULL, 0x040fe200078fe8ffULL,
0x00000008130e7824ULL, 0x000fe200078e00ffULL, 0x0000001400177811ULL, 0x040fe200078fe8ffULL,
0x00000001110c7824ULL, 0x140fe200078e0200ULL, 0x0000001000157811ULL, 0x000fe200078fe8ffULL,
0x0000000811217824ULL, 0x000fe200078e00ffULL, 0xfffffff80e257812ULL, 0x000fe200078ee20dULL,
0x000000010f067824ULL, 0x040fe200078e0200ULL, 0x0000001c006f7811ULL, 0x000fe200078fe8ffULL,
0x000000080f1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee20cULL,
0x00000001190d7824ULL, 0x000fc400078e0200ULL, 0x00000008190e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL, 0x00000001170c7824ULL, 0x140fe400078e0200ULL,
0x00000008176b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e6d7812ULL, 0x000fe200078ee20dULL,
0x0000000115067824ULL, 0x040fe400078e0200ULL, 0x0000000815697824ULL, 0x000fe200078e00ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee20cULL, 0x000000016f0d7824ULL, 0x040fe200078e0200ULL,
0x00000000000c7211ULL, 0x000fe200078fe8ffULL, 0x000000086f107824ULL, 0x000fe200078e00ffULL,
0xfffffff869697812ULL, 0x000fe200078ee206ULL, 0x000000021a0e7824ULL, 0x000fc400078e0205ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0xfffffff810717812ULL, 0x000fe200078ee20dULL,
0x000000010f0f7824ULL, 0x100fe200078e0227ULL, 0x000000070c0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000111117824ULL, 0x100fe200078e0227ULL, 0x0000f0000e0e7811ULL, 0x000fe200078e68ffULL,
0x0000000113137824ULL, 0x100fe200078e0227ULL, 0x0000007006067812ULL, 0x000fe200078ec0ffULL,
0x0000000115157824ULL, 0x100fe200078e0227ULL, 0x0ffffff80d1b7812ULL, 0x000fe200078ef800ULL,
0x0000000117177824ULL, 0x100fe200078e0227ULL, 0x00000027000d7211ULL, 0x000fe200078fe8ffULL,
0x0000000119197824ULL, 0x000fc400078e0227ULL, 0x000000016f6f7824ULL, 0x000fe400078e0227ULL,
0x0000001025277824ULL, 0x000fe400078e020eULL, 0x0000008005247824ULL, 0x000fe400078e0206ULL,
0x000000ffff257224ULL, 0x000fe400078e00ffULL, 0x000000101b1b7824ULL, 0x100fe400078e020eULL,
0x000000101d1d7824ULL, 0x000fc400078e020eULL, 0x0000001021217824ULL, 0x100fe400078e020eULL,
0x0000001069697824ULL, 0x100fe400078e020eULL, 0x000000106b6b7824ULL, 0x100fe400078e020eULL,
0x000000106d6d7824ULL, 0x100fe400078e020eULL, 0x0000001071717824ULL, 0x000fe400078e020eULL,
0x000001000d0c7825ULL, 0x000fc800078e0024ULL, 0x000001000f0e7825ULL, 0x000fe200078e0024ULL,
0x000064000c0c7a10ULL, 0x000fc60007f1e0ffULL, 0x0000010011107825ULL, 0x100fe200078e0024ULL,
0x000064000e0e7a10ULL, 0x000fe40007f3e0ffULL, 0x000065000d0d7a10ULL, 0x000fe200007fe4ffULL,
0x0000010013127825ULL, 0x100fe200078e0024ULL, 0x0000640010107a10ULL, 0x000fe40007f5e0ffULL,
0x000065000f0f7a10ULL, 0x000fe20000ffe4ffULL, 0x0000010015147825ULL, 0x100fe200078e0024ULL,
0x0000640012127a10ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c1b7faeULL, 0x0003e2000b901c46ULL, 0x0000650011117a10ULL, 0x000fe200017fe4ffULL,
0x0000010017167825ULL, 0x100fe200078e0024ULL, 0x0000640014147a10ULL, 0x000fe20007f1e0ffULL,
0x000000000e1d7faeULL, 0x0003e2000b901c46ULL, 0x0000650013137a10ULL, 0x000fe20001ffe4ffULL,
0x0000010019187825ULL, 0x100fe200078e0024ULL, 0x0000640016167a10ULL, 0x000fe20007f3e0ffULL,
0x0000000010217faeULL, 0x0003e2000b901c46ULL, 0x0000650015157a10ULL, 0x000fe200007fe4ffULL,
0x000001006f247825ULL, 0x000fe200078e0024ULL, 0x0000640018187a10ULL, 0x000fe20007f5e0ffULL,
0x0000000012277faeULL, 0x0003e2000b901c46ULL, 0x0000650017177a10ULL, 0x000fc40000ffe4ffULL,
0x0000640024247a10ULL, 0x000fe20007f7e0ffULL, 0x0000000014697faeULL, 0x0003e2000b901c46ULL,
0x0000650019197a10ULL, 0x000fe400017fe4ffULL, 0x0000650025257a10ULL, 0x000fe20001ffe4ffULL,
0x00000000166b7faeULL, 0x0003e8000b901c46ULL, 0x00000000186d7faeULL, 0x0003e8000b901c46ULL,
0x0000000024717faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffe002067812ULL, 0x000fc400078ec0ffULL, 0x00000010020d7812ULL, 0x002fca00078ec0ffULL,
0x0000000106067824ULL, 0x000fc800078e020dULL, 0x0000000805107824ULL, 0x000fe200078e0206ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0166080010107f8cULL, 0x000e64000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x00000008020f7812ULL, 0x000fca00078ec0ffULL,
0x0000000106067824ULL, 0x000fca00078e020fULL, 0x01660c00060f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x006fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c137210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000130e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000112127810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01660c00060f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000001ff7c7819ULL, 0x000fe20000011600ULL, 0x00000020970c7824ULL, 0x000fe400078e00ffULL,
0xffffffffff7f7424ULL, 0x000fe200078e00ffULL, 0x0000007006067812ULL, 0x000fc400078ec0ffULL,
0xffffff800c0d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c7c7c7812ULL, 0x000fc800078ec0ffULL,
0x0000000d7c0d7210ULL, 0x000fca0007ffe006ULL, 0x016000000d0f7984ULL, 0x000e680000000800ULL,
0x016200000d0c7984ULL, 0x0004e20000000800ULL, 0x0000001c0f00720bULL, 0x002fe20003f1d000ULL,
0x00015c127f007947ULL, 0x000fd8000b800000ULL, 0x00000000000d7806ULL, 0x004fc800000e0100ULL,
0x000000ff0d00720cULL, 0x000fe20003f25270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff157224ULL, 0x000fe400078e001cULL,
0x0000001fff817424ULL, 0x000fc400078e00ffULL, 0xffffffffff807424ULL, 0x000fcc00078e00ffULL,
0x0000071000009947ULL, 0x000fea0003800000ULL, 0x00000002ff0e7819ULL, 0x000fe40000011697ULL,
0x0000001c0f00720bULL, 0x000fe40003f54000ULL, 0x000000970e00720cULL, 0x000fe20003f25270ULL,
0x00015ba27f007947ULL, 0x000fd4000b800000ULL, 0x00000000000e7806ULL, 0x000fc400010e0100ULL,
0x0000008097119824ULL, 0x000fe200078e0206ULL, 0x0000001c0f157209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000017c109824ULL, 0x000fca00078e0211ULL,
0x0164001510009388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f25270ULL,
0x000005e000009947ULL, 0x000fea0003800000ULL, 0x0000001c15107221ULL, 0x002fe20000010100ULL,
0x000000ff0eff7812ULL, 0x000fe2000782c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b10107820ULL, 0x000fcc0000410000ULL, 0x0000001000107308ULL, 0x000e640000000800ULL,
0x000000101f1f7220ULL, 0x002fe40000410000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000002ff257819ULL, 0x000fe20000011600ULL, 0x00015ae27f007947ULL, 0x000fea000b800000ULL,
0x00001f2510257589ULL, 0x0002a400000e0000ULL, 0x0000002528287220ULL, 0x084fe20000410000ULL,
0x0000002529297220ULL, 0x080fe20000410000ULL, 0x000000252c2c7220ULL, 0x080fe20000410000ULL,
0x000000252d2d7220ULL, 0x080fe20000410000ULL, 0x0000002530307220ULL, 0x080fe20000410000ULL,
0x0000002531317220ULL, 0x080fe20000410000ULL, 0x0000002534347220ULL, 0x080fe20000410000ULL,
0x0000002535357220ULL, 0x080fe20000410000ULL, 0x0000002538387220ULL, 0x080fe20000410000ULL,
0x0000002539397220ULL, 0x080fe20000410000ULL, 0x000000253c3c7220ULL, 0x080fe20000410000ULL,
0x000000253d3d7220ULL, 0x080fe20000410000ULL, 0x0000002540407220ULL, 0x080fe20000410000ULL,
0x0000002541417220ULL, 0x080fe20000410000ULL, 0x0000002544447220ULL, 0x080fe20000410000ULL,
0x0000002545457220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000eff7812ULL, 0x000fe2000782c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x0000000800257811ULL, 0x000fe200078ff0ffULL,
0x000159b27f007947ULL, 0x000fea000b800000ULL, 0x00001f2510257589ULL, 0x00046400000e0000ULL,
0x000000252a2a7220ULL, 0x086fe20000410000ULL, 0x000000252b2b7220ULL, 0x080fe20000410000ULL,
0x000000252e2e7220ULL, 0x080fe20000410000ULL, 0x000000252f2f7220ULL, 0x080fe20000410000ULL,
0x0000002532327220ULL, 0x080fe20000410000ULL, 0x0000002533337220ULL, 0x080fe20000410000ULL,
0x0000002536367220ULL, 0x080fe20000410000ULL, 0x0000002537377220ULL, 0x080fe20000410000ULL,
0x000000253a3a7220ULL, 0x080fe20000410000ULL, 0x000000253b3b7220ULL, 0x080fe20000410000ULL,
0x000000253e3e7220ULL, 0x080fe20000410000ULL, 0x000000253f3f7220ULL, 0x080fe20000410000ULL,
0x0000002542427220ULL, 0x080fe20000410000ULL, 0x0000002543437220ULL, 0x080fe20000410000ULL,
0x0000002546467220ULL, 0x080fe20000410000ULL, 0x0000002547477220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00000eff7812ULL, 0x000fe2000782c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x0000001000257811ULL, 0x000fe200078ff0ffULL, 0x000158827f007947ULL, 0x000fea000b800000ULL,
0x00001f2510257589ULL, 0x00046400000e0000ULL, 0x0000002548487220ULL, 0x086fe20000410000ULL,
0x0000002549497220ULL, 0x080fe20000410000ULL, 0x000000254c4c7220ULL, 0x080fe20000410000ULL,
0x000000254d4d7220ULL, 0x080fe20000410000ULL, 0x0000002550507220ULL, 0x080fe20000410000ULL,
0x0000002551517220ULL, 0x080fe20000410000ULL, 0x0000002554547220ULL, 0x080fe20000410000ULL,
0x0000002555557220ULL, 0x080fe20000410000ULL, 0x0000002558587220ULL, 0x080fe20000410000ULL,
0x0000002559597220ULL, 0x080fe20000410000ULL, 0x000000255c5c7220ULL, 0x080fe20000410000ULL,
0x000000255d5d7220ULL, 0x080fe20000410000ULL, 0x0000002560607220ULL, 0x080fe20000410000ULL,
0x0000002561617220ULL, 0x080fe20000410000ULL, 0x0000002564647220ULL, 0x080fe20000410000ULL,
0x0000002565657220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000000eff7812ULL, 0x000fda000782c0ffULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x0000001800257811ULL, 0x000fe200078ff0ffULL, 0x000157627f007947ULL, 0x000fea000b800000ULL,
0x00001f2510257589ULL, 0x00046400000e0000ULL, 0x000000254a4a7220ULL, 0x086fe20000410000ULL,
0x000000254b4b7220ULL, 0x080fe20000410000ULL, 0x000000254e4e7220ULL, 0x080fe20000410000ULL,
0x000000254f4f7220ULL, 0x080fe20000410000ULL, 0x0000002552527220ULL, 0x080fe20000410000ULL,
0x0000002553537220ULL, 0x080fe20000410000ULL, 0x0000002556567220ULL, 0x080fe20000410000ULL,
0x0000002557577220ULL, 0x080fe20000410000ULL, 0x000000255a5a7220ULL, 0x080fe20000410000ULL,
0x000000255b5b7220ULL, 0x080fe20000410000ULL, 0x000000255e5e7220ULL, 0x080fe20000410000ULL,
0x000000255f5f7220ULL, 0x080fe20000410000ULL, 0x0000002562627220ULL, 0x080fe20000410000ULL,
0x0000002563637220ULL, 0x080fe20000410000ULL, 0x0000002566667220ULL, 0x080fe20000410000ULL,
0x0000002567677220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000000e0dff7212ULL, 0x000fda00078230ffULL, 0x800000150f0f1221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b0f0f1820ULL, 0x000fc80000410000ULL,
0x0000000f00071308ULL, 0x000e640000000800ULL, 0x000000070c0c1220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000001f0c1f7221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000007ff08723eULL, 0x000fe400000000ffULL,
0x00000002ff0b7819ULL, 0x000fe40000011600ULL, 0x00005410080c7816ULL, 0x000fe20000000008ULL,
0x000155927f007947ULL, 0x000fea000b800000ULL, 0x00001f0b0c087589ULL, 0x0002a400000e0000ULL,
0x000000080b257810ULL, 0x000fe20007ffe0ffULL, 0x000155c27f007947ULL, 0x000fea000b800000ULL,
0x000000100b0d7810ULL, 0x000fe20007ffe0ffULL, 0x00001f250c097589ULL, 0x00066800000e0000ULL,
0x00001f0d0c0a7589ULL, 0x0006a400000e0000ULL, 0x000000180b257810ULL, 0x008fe20007ffe0ffULL,
0x000156127f007947ULL, 0x000fea000b800000ULL, 0x00001f250c0b7589ULL, 0x0022e400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000041a0c7824ULL, 0x002fe200078e00ffULL,
0x00000008000d7812ULL, 0x000fe200078ec0ffULL, 0x00000400970f7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000021a1e7824ULL, 0x000fe200078e0205ULL,
0x000000040c177812ULL, 0x000fe200078ec0ffULL, 0x0000028000007945ULL, 0x000fe20003800000ULL,
0x000000070d0c7812ULL, 0x000fe200078ef800ULL, 0x000020001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000017000e7211ULL, 0x000fc400078fe0ffULL, 0x000000100c0d7812ULL, 0x040fe200078efcffULL,
0x000000080c107824ULL, 0x040fe200078e00ffULL, 0xfffff0000f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000010c137824ULL, 0x000fe200078e020eULL, 0x0000000c00117211ULL, 0x000fe200078fe0ffULL,
0x000000010e147824ULL, 0x000fe200078e020dULL, 0x0000a0000f217810ULL, 0x000fe20007ffe0ffULL,
0x000000080d197824ULL, 0x000fe200078e00ffULL, 0xfffffff810137812ULL, 0x000fe200078ee213ULL,
0x000000080c1b7824ULL, 0x000fe200078e00ffULL, 0x0000000411127810ULL, 0x000fc40007ffe0ffULL,
0xfffffff819147812ULL, 0x000fe200078ee214ULL, 0x000000080c197824ULL, 0x000fe200078e00ffULL,
0x0000000611167810ULL, 0x000fe20007ffe0ffULL, 0x0000001013747824ULL, 0x100fe200078e0221ULL,
0x00000002110e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001014247824ULL, 0x000fe200078e0221ULL,
0xfffffff810107812ULL, 0x000fe400078ee211ULL, 0xfffffff819117812ULL, 0x000fe200078ee212ULL,
0x000000007474783bULL, 0x000e620000000200ULL, 0xfffffff81b127812ULL, 0x000fc400078ee216ULL,
0xfffffff81b0e7812ULL, 0x000fe200078ee20eULL, 0x000000002424783bULL, 0x000ee20000000200ULL,
0x0000e0001e167810ULL, 0x000fca0007ffe0ffULL, 0x0000001010707824ULL, 0x100fe400078e0216ULL,
0x000000100e6c7824ULL, 0x100fe400078e0216ULL, 0x0000001011187824ULL, 0x000fe200078e0216ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000000874747232ULL, 0x086fe40000000000ULL,
0x0000000876767232ULL, 0x000fe40000000000ULL, 0x0000000975757232ULL, 0x080fe40000000000ULL,
0x0000000977777232ULL, 0x000fc40000000000ULL, 0x0000000a24247232ULL, 0x088fe40000000000ULL,
0x0000000a26267232ULL, 0x000fe40000000000ULL, 0x0000000b25257232ULL, 0x080fe40000000000ULL,
0x0000000b27277232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001012687824ULL, 0x000fe200078e0216ULL, 0x000000001818783bULL, 0x000f220000004200ULL,
0x0000000217177812ULL, 0x000fe200078efcffULL, 0x0000037000007945ULL, 0x000fe40003800000ULL,
0x000000006c6c783bULL, 0x000fe20000004200ULL, 0x0000001700177211ULL, 0x000fc600078fe0ffULL,
0x000000006868783bULL, 0x000ee80000004200ULL, 0x000000007070783bULL, 0x000ea20000004200ULL,
0x000000187438723cULL, 0x092f700000001838ULL, 0x000000182458723cULL, 0x008b6e0000001858ULL,
0x000000080c197824ULL, 0x060fe200078e00ffULL, 0x000000687440723cULL, 0x000f620000001840ULL,
0x000000010c187824ULL, 0x000fc400078e0217ULL, 0x000000010d177824ULL, 0x000fc600078e0217ULL,
0xfffffff819187812ULL, 0x000fe400078ee218ULL, 0x000000682460723cULL, 0x000b620000001860ULL,
0x0000000d00197211ULL, 0x000fe400078fe0ffULL, 0x0000001018187824ULL, 0x000fe400078e0221ULL,
0x00000002191c7810ULL, 0x000fe40007ffe0ffULL, 0x000000080d687824ULL, 0x060fe200078e00ffULL,
0x0000006c7430723cULL, 0x000f620000001830ULL, 0x000000080d697824ULL, 0x000fe200078e00ffULL,
0x00000004191d7810ULL, 0x000fe20007ffe0ffULL, 0x000000001878783bULL, 0x0002e20000000200ULL,
0xfffffff868687812ULL, 0x000fc400078ee217ULL, 0xfffffff8691c7812ULL, 0x000fe400078ee21cULL,
0x0000001a743c723cULL, 0x000f62000000183cULL, 0x0000001068687824ULL, 0x000fce00078e0221ULL,
0x0000006c2450723cULL, 0x040b6e0000001850ULL, 0x000000080d6c7824ULL, 0x060fe200078e00ffULL,
0x0000001a245c723cULL, 0x000b62000000185cULL, 0x000000080d6d7824ULL, 0x000fc600078e00ffULL,
0xfffffff86c1d7812ULL, 0x000fc600078ee21dULL, 0x000000080d1a7824ULL, 0x020fe200078e00ffULL,
0x000000702448723cULL, 0x004f620000001848ULL, 0x000000101d6c7824ULL, 0x000fc600078e0216ULL,
0xfffffff81a1b7812ULL, 0x000fe400078ee219ULL, 0x00000006191a7810ULL, 0x000fe40007ffe0ffULL,
0x00000072244c723cULL, 0x000f64000000184cULL, 0xfffffff86d1a7812ULL, 0x000fcc00078ee21aULL,
0x0000006e2454723cULL, 0x040f700000001854ULL, 0x0000006a2464723cULL, 0x000b640000001864ULL,
0x000000006824783bULL, 0x0202ac0000000200ULL, 0x000000707428723cULL, 0x040b6e0000001828ULL,
0x000000101c707824ULL, 0x120fe200078e0216ULL, 0x00000072742c723cULL, 0x040f70000000182cULL,
0x0000006e7434723cULL, 0x040f700000001834ULL, 0x0000006a7444723cULL, 0x000b6e0000001844ULL,
0x000000101b747824ULL, 0x020fe200078e0216ULL, 0x0000008000008947ULL, 0x000fd60003800000ULL,
0x0000000878787232ULL, 0x08afe40000000000ULL, 0x000000087a7a7232ULL, 0x000fc40000000000ULL,
0x0000000979797232ULL, 0x080fe40000000000ULL, 0x000000097b7b7232ULL, 0x000fe40000000000ULL,
0x0000000a24247232ULL, 0x084fe40000000000ULL, 0x0000000a26267232ULL, 0x000fe40000000000ULL,
0x0000000b25257232ULL, 0x080fe40000000000ULL, 0x0000000b27277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x00afea0003800000ULL, 0x000000101a687824ULL, 0x000fe200078e0216ULL,
0x000000007474783bULL, 0x000e620000004200ULL, 0x0000000297177824ULL, 0x000fc600078e00ffULL,
0x000000007070783bULL, 0x000ee40000004200ULL, 0xfffffff817177812ULL, 0x000fe400078ec0ffULL,
0x000000006c6c783bULL, 0x000f280000004200ULL, 0x000000006868783bULL, 0x000ea20000004200ULL,
0x000000747828723cULL, 0x042b700000001828ULL, 0x00000076782c723cULL, 0x040b70000000182cULL,
0x000000707830723cULL, 0x048b700000001830ULL, 0x000000727834723cULL, 0x040b700000001834ULL,
0x0000006c7838723cULL, 0x050b700000001838ULL, 0x0000006e783c723cULL, 0x040b70000000183cULL,
0x000000687840723cULL, 0x044b700000001840ULL, 0x0000006a7844723cULL, 0x000b700000001844ULL,
0x000000742448723cULL, 0x040b700000001848ULL, 0x00000076244c723cULL, 0x040b70000000184cULL,
0x000000702450723cULL, 0x040b700000001850ULL, 0x000000722454723cULL, 0x040b700000001854ULL,
0x0000006c2458723cULL, 0x040b700000001858ULL, 0x0000006e245c723cULL, 0x040b70000000185cULL,
0x000000682460723cULL, 0x040b700000001860ULL, 0x0000006a2464723cULL, 0x000b620000001864ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000000195187810ULL, 0x000fe20007ffe0ffULL,
0x0166880017ff7f8cULL, 0x0003e2000c80043fULL, 0x0000008020197810ULL, 0x000fc40007ffe0ffULL,
0x000000231800720cULL, 0x000fc60003f06070ULL, 0x0000680004777a24ULL, 0x020fe200078e0219ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000061000008947ULL, 0x000fea0003800000ULL,
0x00000003ff707819ULL, 0x002fe20000011600ULL, 0x0000008005187824ULL, 0x000fe200078e0206ULL,
0x0000001994177217ULL, 0x000fe40007800000ULL, 0x0000000470247810ULL, 0x040fe20007ffe0ffULL,
0x0000000170257824ULL, 0x040fe200078e0277ULL, 0x0000000870687810ULL, 0x040fe20007ffe0ffULL,
0x0000000117177824ULL, 0x000fe200078e0a19ULL, 0x0000000c706e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000124197824ULL, 0x100fe200078e0200ULL, 0x0000001070727810ULL, 0x000fe20007ffe0ffULL,
0x0000000824267824ULL, 0x000fe200078e00ffULL, 0x0000002017177817ULL, 0x000fe20003800000ULL,
0x0000000168217824ULL, 0x000fc400078e0200ULL, 0x00000008686a7824ULL, 0x000fe200078e00ffULL,
0xfffffff826737812ULL, 0x000fe200078ee219ULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x000000172400720cULL, 0x0c0fe20003f86070ULL, 0x0000000124277824ULL, 0x000fe200078e0277ULL,
0xfffffff86a797812ULL, 0x000fe200078ee221ULL, 0x000000016e217824ULL, 0x040fe200078e0200ULL,
0x000000176e00720cULL, 0x0c0fe20003f46070ULL, 0x000000086e6a7824ULL, 0x000fe200078e00ffULL,
0x000000176800720cULL, 0x080fe20003f66070ULL, 0x0000010025247825ULL, 0x000fe200078e0018ULL,
0x000000177000720cULL, 0x000fc40003fa6070ULL, 0xfffffff86a7b7812ULL, 0x000fe200078ee221ULL,
0x0000010027267825ULL, 0x000fe200078e0018ULL, 0x00006400246a7a10ULL, 0x000fc60007f1e0ffULL,
0x0000000172697824ULL, 0x000fe200078e0200ULL, 0x00006400266c7a10ULL, 0x000fe20007f3e0ffULL,
0x0000000872747824ULL, 0x000fe200078e00ffULL, 0x00006500256b7a10ULL, 0x000fe200007fe4ffULL,
0x0000000168257824ULL, 0x100fe200078e0277ULL, 0x00006500276d7a10ULL, 0x000fe20000ffe4ffULL,
0x000000016e277824ULL, 0x000fe200078e0277ULL, 0xfffffff874837812ULL, 0x000fe200078ee269ULL,
0x0000010025247825ULL, 0x000fe200078e0018ULL, 0x0000001470747810ULL, 0x000fe40007ffe0ffULL,
0x000000177200720cULL, 0x040fe20003f26070ULL, 0x0000000172697824ULL, 0x000fe200078e0277ULL,
0x00006400246e7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000170217824ULL, 0x000fc400078e0200ULL,
0x00000001746f7824ULL, 0x040fe400078e0200ULL, 0x0000000874727824ULL, 0x000fe200078e00ffULL,
0x0000000721217812ULL, 0x000fe200078ec0ffULL, 0x0000010027267825ULL, 0x000fc600078e0018ULL,
0xfffffff872857812ULL, 0x000fe200078ee26fULL, 0x0000010069687825ULL, 0x000fe200078e0018ULL,
0x0000640026267a10ULL, 0x000fe40007fde0ffULL, 0x00006500256f7a10ULL, 0x000fe200007fe4ffULL,
0x0000000174257824ULL, 0x000fe200078e0277ULL, 0x0ffffff821217812ULL, 0x000fe200078ef800ULL,
0x0000001073737824ULL, 0x000fe200078e0216ULL, 0x0000650027277a10ULL, 0x000fe200037fe4ffULL,
0x0000010025247825ULL, 0x000fe200078e0018ULL, 0x0000640068687a10ULL, 0x000fc40007fde0ffULL,
0x0000001870727810ULL, 0x000fe20007ffe0ffULL, 0x0000001021217824ULL, 0x000fe200078e0216ULL,
0x000000177400720cULL, 0x080fe40003f06070ULL, 0x0000650069697a10ULL, 0x000fe200037fe4ffULL,
0x0000000172757824ULL, 0x000fe200078e0277ULL, 0x0000001c70747810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a217faeULL, 0x0003e2000e901c46ULL,
0x0000640024707a10ULL, 0x000fe40007fde0ffULL, 0x000000177200720cULL, 0x080fe20003fa6070ULL,
0x000000006c737faeULL, 0x0005e2000e101c46ULL, 0x0000650025717a10ULL, 0x000fe200037fe4ffULL,
0x0000010075247825ULL, 0x000fe200078e0018ULL, 0x000000177400720cULL, 0x000fc60003f86070ULL,
0x0000000174177824ULL, 0x000fe200078e0277ULL, 0x0000640024247a10ULL, 0x000fe20007fde0ffULL,
0x0000000172217824ULL, 0x142fe400078e0200ULL, 0x0000000872727824ULL, 0x000fe200078e00ffULL,
0x0000650025257a10ULL, 0x000fe200037fe4ffULL, 0x00000001746a7824ULL, 0x040fe400078e0200ULL,
0x0000000874757824ULL, 0x000fe200078e00ffULL, 0xfffffff872737812ULL, 0x004fe200078ee221ULL,
0x0000010017187825ULL, 0x000fc600078e0018ULL, 0xfffffff875757812ULL, 0x000fe200078ee26aULL,
0x0000001079177824ULL, 0x100fe200078e0216ULL, 0x0000640018187a10ULL, 0x000fe20007fde0ffULL,
0x000000107b217824ULL, 0x100fe400078e0216ULL, 0x00000010836b7824ULL, 0x100fe200078e0216ULL,
0x0000650019197a10ULL, 0x000fe200037fe4ffULL, 0x00000010856d7824ULL, 0x100fe200078e0216ULL,
0x000000006e177faeULL, 0x0003e2000d901c46ULL, 0x0000001073737824ULL, 0x100fe400078e0216ULL,
0x0000001075757824ULL, 0x000fe200078e0216ULL, 0x0000000026217faeULL, 0x0003e8000d101c46ULL,
0x00000000686b7faeULL, 0x0003e8000c901c46ULL, 0x00000000706d7faeULL, 0x0003e8000c101c46ULL,
0x0000000024737faeULL, 0x0003e8000e901c46ULL, 0x0000000018757faeULL, 0x0003e2000e101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000000400257811ULL, 0x042fe200078fe8ffULL,
0x0000008005707824ULL, 0x000fe200078e0206ULL, 0x0000000800277811ULL, 0x040fe200078fe8ffULL,
0x000000ffff717224ULL, 0x000fe200078e00ffULL, 0x0000000c00697811ULL, 0x040fe200078fe8ffULL,
0x0000000125177824ULL, 0x140fe200078e0200ULL, 0x00000010006b7811ULL, 0x040fe200078fe8ffULL,
0x0000000825247824ULL, 0x000fe200078e00ffULL, 0x00000014006d7811ULL, 0x040fe200078fe8ffULL,
0x0000000127187824ULL, 0x140fe200078e0200ULL, 0x00000018006f7811ULL, 0x000fe200078fe8ffULL,
0x0000000827757824ULL, 0x000fe200078e00ffULL, 0xfffffff824737812ULL, 0x000fe200078ee217ULL,
0x0000000169177824ULL, 0x000fc400078e0200ULL, 0x0000000869247824ULL, 0x000fe200078e00ffULL,
0xfffffff875757812ULL, 0x000fe200078ee218ULL, 0x000000016b187824ULL, 0x140fe400078e0200ULL,
0x000000086b7b7824ULL, 0x000fe200078e00ffULL, 0xfffffff824797812ULL, 0x000fe200078ee217ULL,
0x000000016d197824ULL, 0x040fe200078e0200ULL, 0x0000000000177211ULL, 0x040fe200078fe8ffULL,
0x000000086d267824ULL, 0x000fe200078e00ffULL, 0xfffffff87b7b7812ULL, 0x000fe200078ee218ULL,
0x000000016f217824ULL, 0x040fe200078e0200ULL, 0x0000001c00187811ULL, 0x000fe200078fe8ffULL,
0x000000086f687824ULL, 0x000fe200078e00ffULL, 0xfffffff826837812ULL, 0x000fe200078ee219ULL,
0x0000000125257824ULL, 0x100fe200078e0277ULL, 0x0000007700197211ULL, 0x000fe200078fe8ffULL,
0x0000000127277824ULL, 0x000fe200078e0277ULL, 0xfffffff868857812ULL, 0x000fe200078ee221ULL,
0x0000000169697824ULL, 0x100fe200078e0277ULL, 0x0000000717217812ULL, 0x000fe200078ec0ffULL,
0x000000016b6b7824ULL, 0x000fc400078e0277ULL, 0x000000016d6d7824ULL, 0x100fe200078e0277ULL,
0x0ffffff821217812ULL, 0x100fe200078ef800ULL, 0x000000016f6f7824ULL, 0x100fe400078e0277ULL,
0x0000000118177824ULL, 0x040fe400078e0277ULL, 0x0000000118727824ULL, 0x040fe400078e0200ULL,
0x0000000818777824ULL, 0x000fe400078e00ffULL, 0x0000010019187825ULL, 0x000fc800078e0070ULL,
0x0000010025247825ULL, 0x000fc800078e0070ULL, 0x0000010027267825ULL, 0x000fc800078e0070ULL,
0x0000010069687825ULL, 0x000fc800078e0070ULL, 0x000001006b6a7825ULL, 0x000fc800078e0070ULL,
0x000001006d6c7825ULL, 0x000fc800078e0070ULL, 0x000001006f6e7825ULL, 0x000fc800078e0070ULL,
0x0000010017707825ULL, 0x000fe200078e0070ULL, 0xfffffff877177812ULL, 0x000fc600078ee272ULL,
0x0000001079777824ULL, 0x100fe400078e0216ULL, 0x000000107b797824ULL, 0x100fe400078e0216ULL,
0x00000010837b7824ULL, 0x100fe400078e0216ULL, 0x0000001085837824ULL, 0x100fe400078e0216ULL,
0x0000001021217824ULL, 0x100fe400078e0216ULL, 0x0000001073737824ULL, 0x000fc400078e0216ULL,
0x0000001075757824ULL, 0x100fe400078e0216ULL, 0x0000001017857824ULL, 0x000fe200078e0216ULL,
0x0000640018167a10ULL, 0x000fe40007f1e0ffULL, 0x0000640024187a10ULL, 0x000fe40007f3e0ffULL,
0x0000640026247a10ULL, 0x000fe40007f5e0ffULL, 0x0000640068267a10ULL, 0x000fe40007f7e0ffULL,
0x0000650019177a10ULL, 0x000fc400007fe4ffULL, 0x0000650025197a10ULL, 0x000fe40000ffe4ffULL,
0x000064006a687a10ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016217faeULL, 0x0003e2000b901c46ULL, 0x0000650027257a10ULL, 0x000fe400017fe4ffULL,
0x000064006c6a7a10ULL, 0x000fe20007f3e0ffULL, 0x0000000018737faeULL, 0x0003e2000b901c46ULL,
0x0000650069277a10ULL, 0x000fe40001ffe4ffULL, 0x000064006e6c7a10ULL, 0x000fe20007f5e0ffULL,
0x0000000024757faeULL, 0x0003e2000b901c46ULL, 0x00006400706e7a10ULL, 0x000fc40007f7e0ffULL,
0x000065006b697a10ULL, 0x000fe200007fe4ffULL, 0x0000000026777faeULL, 0x0003e2000b901c46ULL,
0x000065006d6b7a10ULL, 0x000fe40000ffe4ffULL, 0x000065006f6d7a10ULL, 0x000fe200017fe4ffULL,
0x0000000068797faeULL, 0x0003e2000b901c46ULL, 0x00006500716f7a10ULL, 0x000fc60001ffe4ffULL,
0x000000006a7b7faeULL, 0x0003e8000b901c46ULL, 0x000000006c837faeULL, 0x0003e8000b901c46ULL,
0x000000006e857faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffe002187812ULL, 0x042fe400078ec0ffULL, 0x0000001002197812ULL, 0x000fc400078ec0ffULL,
0x0000000802247812ULL, 0x000fc800078ec0ffULL, 0x0000001824247210ULL, 0x000fe20007ffe019ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0166280024247f8cULL, 0x000e64000c80043fULL,
0x0000000000167805ULL, 0x000fc40000015200ULL, 0x0000000118187824ULL, 0x000fc800078e0219ULL,
0x0000000805267824ULL, 0x000fca00078e0218ULL, 0x01662c0026197984ULL, 0x000ea40000000800ULL,
0x8000000019ff7812ULL, 0x006fe40007804825ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff277224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x0000001816217210ULL, 0x000fca0007f1e1ffULL, 0x0000000119197824ULL, 0x000fe200000e0e17ULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc80000011419ULL, 0x0000002118187211ULL, 0x000fca00078110ffULL,
0x000000ffff197224ULL, 0x000fca00000e0619ULL, 0x0000000218187819ULL, 0x000fc80000001219ULL,
0x000000180000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000127277810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01662c0026197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002097167824ULL, 0x000fca00078e00ffULL,
0xffffff8016177812ULL, 0x000fc800078ec0ffULL, 0x0000008006177810ULL, 0x000fca0007ffe017ULL,
0x000000017c177824ULL, 0x000fca00078e0217ULL, 0x0160000017167984ULL, 0x000e680000000800ULL,
0x0162000017187984ULL, 0x0004e20000000800ULL, 0x000000151600720bULL, 0x002fe20003f1d000ULL,
0x00013ea27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000177806ULL, 0x004fc800000e0100ULL,
0x000000ff1700720cULL, 0x000fe20003f25270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff217224ULL, 0x000fd400078e0015ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x0000000197247811ULL, 0x000fe400078ff0ffULL,
0x000000151600720bULL, 0x000fe40003f34000ULL, 0x000000972400720cULL, 0x000fe20003f05270ULL,
0x00013e527f007947ULL, 0x000fd4000b800000ULL, 0x0000000000687806ULL, 0x000fc400008e0100ULL,
0x0000008097218824ULL, 0x000fe200078e0206ULL, 0x0000001516198209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x000000017c248824ULL, 0x000fca00078e0221ULL,
0x0164001924008388ULL, 0x0003e20000000800ULL, 0x000000ff6800720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000001516247209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff68ff7812ULL, 0x000fc6000780c0ffULL,
0x0000001524197221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b19197820ULL, 0x000fc80000410000ULL,
0x00000019006a7308ULL, 0x000e640000000800ULL, 0x0000006a1f1f7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff257819ULL, 0x000fe20000011600ULL,
0x00013d827f007947ULL, 0x000fea000b800000ULL, 0x00001f256a257589ULL, 0x0002a400000e0000ULL,
0x0000002528287220ULL, 0x084fe20000410000ULL, 0x0000002529297220ULL, 0x080fe20000410000ULL,
0x000000252c2c7220ULL, 0x080fe20000410000ULL, 0x000000252d2d7220ULL, 0x080fe20000410000ULL,
0x0000002530307220ULL, 0x080fe20000410000ULL, 0x0000002531317220ULL, 0x080fe20000410000ULL,
0x0000002534347220ULL, 0x080fe20000410000ULL, 0x0000002535357220ULL, 0x080fe20000410000ULL,
0x0000002538387220ULL, 0x080fe20000410000ULL, 0x0000002539397220ULL, 0x080fe20000410000ULL,
0x000000253c3c7220ULL, 0x080fe20000410000ULL, 0x000000253d3d7220ULL, 0x080fe20000410000ULL,
0x0000002540407220ULL, 0x080fe20000410000ULL, 0x0000002541417220ULL, 0x080fe20000410000ULL,
0x0000002544447220ULL, 0x080fe20000410000ULL, 0x0000002545457220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0068ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000800257811ULL, 0x000fe200078ff0ffULL, 0x00013c527f007947ULL, 0x000fea000b800000ULL,
0x00001f256a257589ULL, 0x00046400000e0000ULL, 0x000000252a2a7220ULL, 0x086fe20000410000ULL,
0x000000252b2b7220ULL, 0x080fe20000410000ULL, 0x000000252e2e7220ULL, 0x080fe20000410000ULL,
0x000000252f2f7220ULL, 0x080fe20000410000ULL, 0x0000002532327220ULL, 0x080fe20000410000ULL,
0x0000002533337220ULL, 0x080fe20000410000ULL, 0x0000002536367220ULL, 0x080fe20000410000ULL,
0x0000002537377220ULL, 0x080fe20000410000ULL, 0x000000253a3a7220ULL, 0x080fe20000410000ULL,
0x000000253b3b7220ULL, 0x080fe20000410000ULL, 0x000000253e3e7220ULL, 0x080fe20000410000ULL,
0x000000253f3f7220ULL, 0x080fe20000410000ULL, 0x0000002542427220ULL, 0x080fe20000410000ULL,
0x0000002543437220ULL, 0x080fe20000410000ULL, 0x0000002546467220ULL, 0x080fe20000410000ULL,
0x0000002547477220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000068ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001000257811ULL, 0x000fe200078ff0ffULL,
0x00013b227f007947ULL, 0x000fea000b800000ULL, 0x00001f256a257589ULL, 0x00046400000e0000ULL,
0x0000002548487220ULL, 0x086fe20000410000ULL, 0x0000002549497220ULL, 0x080fe20000410000ULL,
0x000000254c4c7220ULL, 0x080fe20000410000ULL, 0x000000254d4d7220ULL, 0x080fe20000410000ULL,
0x0000002550507220ULL, 0x080fe20000410000ULL, 0x0000002551517220ULL, 0x080fe20000410000ULL,
0x0000002554547220ULL, 0x080fe20000410000ULL, 0x0000002555557220ULL, 0x080fe20000410000ULL,
0x0000002558587220ULL, 0x080fe20000410000ULL, 0x0000002559597220ULL, 0x080fe20000410000ULL,
0x000000255c5c7220ULL, 0x080fe20000410000ULL, 0x000000255d5d7220ULL, 0x080fe20000410000ULL,
0x0000002560607220ULL, 0x080fe20000410000ULL, 0x0000002561617220ULL, 0x080fe20000410000ULL,
0x0000002564647220ULL, 0x080fe20000410000ULL, 0x0000002565657220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000068ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001800257811ULL, 0x000fe200078ff0ffULL,
0x00013a027f007947ULL, 0x000fea000b800000ULL, 0x00001f256a257589ULL, 0x00046400000e0000ULL,
0x000000254a4a7220ULL, 0x086fe20000410000ULL, 0x000000254b4b7220ULL, 0x080fe20000410000ULL,
0x000000254e4e7220ULL, 0x080fe20000410000ULL, 0x000000254f4f7220ULL, 0x080fe20000410000ULL,
0x0000002552527220ULL, 0x080fe20000410000ULL, 0x0000002553537220ULL, 0x080fe20000410000ULL,
0x0000002556567220ULL, 0x080fe20000410000ULL, 0x0000002557577220ULL, 0x080fe20000410000ULL,
0x000000255a5a7220ULL, 0x080fe20000410000ULL, 0x000000255b5b7220ULL, 0x080fe20000410000ULL,
0x000000255e5e7220ULL, 0x080fe20000410000ULL, 0x000000255f5f7220ULL, 0x080fe20000410000ULL,
0x0000002562627220ULL, 0x080fe20000410000ULL, 0x0000002563637220ULL, 0x080fe20000410000ULL,
0x0000002566667220ULL, 0x080fe20000410000ULL, 0x0000002567677220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000006817ff7212ULL, 0x000fe400078030ffULL,
0x0000001516217209ULL, 0x000fd60007810000ULL, 0x8000002116160221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600070308ULL, 0x000e640000000800ULL,
0x0000000718180220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000001f181f7221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000007ff08723eULL, 0x000fe400000000ffULL,
0x00000002ff167819ULL, 0x000fe40000011600ULL, 0x00005410080b7816ULL, 0x000fe20000000008ULL,
0x000138427f007947ULL, 0x000fea000b800000ULL, 0x00001f160b087589ULL, 0x0002a400000e0000ULL,
0x0000000816257810ULL, 0x000fe20007ffe0ffULL, 0x000138727f007947ULL, 0x000fea000b800000ULL,
0x00000010160a7810ULL, 0x000fe20007ffe0ffULL, 0x00001f250b097589ULL, 0x00066a00000e0000ULL,
0x00001f0a0b0a7589ULL, 0x0006a400000e0000ULL, 0x0000001816257810ULL, 0x008fe20007ffe0ffULL,
0x000138c27f007947ULL, 0x000fea000b800000ULL, 0x00001f250b0b7589ULL, 0x0022e400000e0000ULL,
0x0000200097157824ULL, 0x000fe200078e00ffULL, 0x0000b0000f187810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000014000007945ULL, 0x000fe40003800000ULL,
0xffffc00015167812ULL, 0x000fe200078ec0ffULL, 0x0000001013137824ULL, 0x000fc400078e0218ULL,
0x0000001014147824ULL, 0x000fe400078e0218ULL, 0x0000200005167824ULL, 0x000fe200078e0216ULL,
0x000000001374783bULL, 0x0002e80000000200ULL, 0x0000f00016157810ULL, 0x000fe20007ffe0ffULL,
0x000000001424783bULL, 0x0022a80000000200ULL, 0x0000001010707824ULL, 0x000fc400078e0215ULL,
0x000000100e6c7824ULL, 0x100fe400078e0215ULL, 0x0000001011687824ULL, 0x000fe200078e0215ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000000874747232ULL, 0x08efe40000000000ULL,
0x0000000876767232ULL, 0x000fe40000000000ULL, 0x0000000975757232ULL, 0x080fe40000000000ULL,
0x0000000977777232ULL, 0x000fe40000000000ULL, 0x0000000a24247232ULL, 0x000fc40000000000ULL,
0x0000000a26267232ULL, 0x000fe40000000000ULL, 0x0000000b25257232ULL, 0x080fe40000000000ULL,
0x0000000b27277232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x002fea0003800000ULL,
0x0000001012157824ULL, 0x000fe200078e0215ULL, 0x000000006868783bULL, 0x000e620000004200ULL,
0x0000000297137824ULL, 0x000fe200078e00ffULL, 0x000002e000007945ULL, 0x000fe20003800000ULL,
0x000000080c197824ULL, 0x000fe200078e00ffULL, 0x000000007070783bULL, 0x000fe40000004200ULL,
0x0000000413137812ULL, 0x000fc400078ec0ffULL, 0x000000001514783bULL, 0x000f240000004200ULL,
0x0000000213137812ULL, 0x000fe400078efcffULL, 0x000000006c6c783bULL, 0x000ee40000004200ULL,
0x0000001300137211ULL, 0x000fe200078fe0ffULL, 0x000000687438723cULL, 0x04af700000001838ULL,
0x000000147440723cULL, 0x090f700000001840ULL, 0x000000142460723cULL, 0x044b6e0000001860ULL,
0x000000010c147824ULL, 0x120fe200078e0213ULL, 0x000000682458723cULL, 0x000b620000001858ULL,
0x000000010d157824ULL, 0x000fc600078e0213ULL, 0xfffffff819137812ULL, 0x000fc600078ee214ULL,
0x000000080d687824ULL, 0x020fe200078e00ffULL, 0x000000702448723cULL, 0x000f620000001848ULL,
0x0000001013787824ULL, 0x000fc600078e0218ULL, 0xfffffff868147812ULL, 0x000fe400078ee215ULL,
0x0000f0001e157810ULL, 0x000fe20007ffe0ffULL, 0x000000007878783bULL, 0x000e620000000200ULL,
0x00000072244c723cULL, 0x040f70000000184cULL, 0x0000006c2450723cULL, 0x040f700000001850ULL,
0x0000006e2454723cULL, 0x040f700000001854ULL, 0x0000006a245c723cULL, 0x040f70000000185cULL,
0x000000162464723cULL, 0x000b6e0000001864ULL, 0x0000001014247824ULL, 0x020fe200078e0218ULL,
0x000000707428723cULL, 0x000f620000001828ULL, 0x000000101d187824ULL, 0x000fc800078e0215ULL,
0x000000002424783bULL, 0x000ea60000000200ULL, 0x00000072742c723cULL, 0x040f70000000182cULL,
0x0000006c7430723cULL, 0x040f700000001830ULL, 0x0000006e7434723cULL, 0x040f700000001834ULL,
0x0000006a743c723cULL, 0x040f70000000183cULL, 0x000000167444723cULL, 0x000b6e0000001844ULL,
0x000000101b167824ULL, 0x020fc400078e0215ULL, 0x000000101c177824ULL, 0x000fe200078e0215ULL,
0x0000008000008947ULL, 0x000fd20003800000ULL, 0x0000000878787232ULL, 0x086fe40000000000ULL,
0x000000087a7a7232ULL, 0x000fe40000000000ULL, 0x0000000979797232ULL, 0x080fe40000000000ULL,
0x000000097b7b7232ULL, 0x000fe40000000000ULL, 0x0000000a24247232ULL, 0x080fe40000000000ULL,
0x0000000a26267232ULL, 0x000fc40000000000ULL, 0x0000000b25257232ULL, 0x080fe40000000000ULL,
0x0000000b27277232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x006fea0003800000ULL,
0x000000101a197824ULL, 0x000fe200078e0215ULL, 0x000000001674783bULL, 0x000e680000004200ULL,
0x000000001770783bULL, 0x000ea80000004200ULL, 0x00000000186c783bULL, 0x000ee80000004200ULL,
0x000000001968783bULL, 0x000f220000004200ULL, 0x000000747828723cULL, 0x042f700000001828ULL,
0x00000076782c723cULL, 0x040f70000000182cULL, 0x000000707830723cULL, 0x044f700000001830ULL,
0x000000727834723cULL, 0x040f700000001834ULL, 0x0000006c7838723cULL, 0x048f700000001838ULL,
0x0000006e783c723cULL, 0x040f70000000183cULL, 0x0000006a7844723cULL, 0x050f700000001844ULL,
0x000000687840723cULL, 0x080f700000001840ULL, 0x000000682460723cULL, 0x040b6e0000001860ULL,
0x00000002ff687819ULL, 0x020fe20000011697ULL, 0x000000742448723cULL, 0x040f700000001848ULL,
0x00000076244c723cULL, 0x040f70000000184cULL, 0x000000702450723cULL, 0x040f700000001850ULL,
0x000000722454723cULL, 0x040f700000001854ULL, 0x0000006c2458723cULL, 0x040f700000001858ULL,
0x0000006e245c723cULL, 0x040f70000000185cULL, 0x0000006a2464723cULL, 0x000b6e0000001864ULL,
0x0001669068247811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fcc0000008000ULL,
0x000000c020257810ULL, 0x000fe20007ffe0ffULL, 0x0000000024ff7f8cULL, 0x0003e2000c80043fULL,
0x0000000195207810ULL, 0x000fc60007ffe0ffULL, 0x0000680004777a24ULL, 0x000fe200078e0225ULL,
0x000000232000720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000061000008947ULL, 0x000fea0003800000ULL, 0x00000003ff697819ULL, 0x102fe40000011600ULL,
0x0000002594207217ULL, 0x000fe40007800000ULL, 0x00000004696b7810ULL, 0x040fe40007ffe0ffULL,
0x00000008696d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000120207824ULL, 0x000fe200078e0a25ULL,
0x0000001069757810ULL, 0x000fe20007ffe0ffULL, 0x000000016b247824ULL, 0x100fe200078e0200ULL,
0x0000000c696f7810ULL, 0x000fe20007ffe0ffULL, 0x000000086b277824ULL, 0x000fe200078e00ffULL,
0x0000001469797810ULL, 0x000fe20007ffe0ffULL, 0x000000016d257824ULL, 0x040fe200078e0200ULL,
0x0000002020207817ULL, 0x000fe20003800000ULL, 0x000000086d7a7824ULL, 0x000fe200078e00ffULL,
0xfffffff827787812ULL, 0x000fe200078ee224ULL, 0x0000000175277824ULL, 0x100fe200078e0200ULL,
0x000000206b00720cULL, 0x080fe20003fa6070ULL, 0x0000000875847824ULL, 0x000fe200078e00ffULL,
0xfffffff87a7a7812ULL, 0x000fe200078ee225ULL, 0x000000016f267824ULL, 0x000fe200078e0200ULL,
0x000000206d00720cULL, 0x080fe20003f66070ULL, 0x000000086f717824ULL, 0x000fe200078e00ffULL,
0xfffffff884847812ULL, 0x000fe200078ee227ULL, 0x0000008005247824ULL, 0x000fe200078e0206ULL,
0x000000206f00720cULL, 0x000fe20003f46070ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0xfffffff871827812ULL, 0x000fe200078ee226ULL, 0x0000000169277824ULL, 0x040fe200078e0277ULL,
0x00000018697b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000179707824ULL, 0x000fc400078e0200ULL,
0x0000000879717824ULL, 0x000fe400078e00ffULL, 0x0000010027267825ULL, 0x000fc600078e0024ULL,
0xfffffff871867812ULL, 0x000fe200078ee270ULL, 0x000000016b6b7824ULL, 0x100fe200078e0277ULL,
0x0000640026707a10ULL, 0x000fe20007f1e0ffULL, 0x000000016d6d7824ULL, 0x100fe400078e0277ULL,
0x000000016f6f7824ULL, 0x000fe200078e0277ULL, 0x0000650027717a10ULL, 0x000fe200007fe4ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0024ULL, 0x000000207900720cULL, 0x000fc60003f06070ULL,
0x000001006d6c7825ULL, 0x000fe200078e0024ULL, 0x000064006a727a10ULL, 0x000fc60007f3e0ffULL,
0x000001006f6e7825ULL, 0x000fe200078e0024ULL, 0x000064006c6c7a10ULL, 0x000fe40007f9e0ffULL,
0x000065006b737a10ULL, 0x000fe20000ffe4ffULL, 0x0000000175277824ULL, 0x000fe200078e0277ULL,
0x000064006e6e7a10ULL, 0x000fe20007fde0ffULL, 0x00000001696a7824ULL, 0x000fe200078e0200ULL,
0x000000207500720cULL, 0x000fe20003f26070ULL, 0x0000010027267825ULL, 0x000fe200078e0024ULL,
0x000065006d6d7a10ULL, 0x000fe400027fe4ffULL, 0x000000076a757812ULL, 0x000fe200078ec0ffULL,
0x00000001796b7824ULL, 0x000fe200078e0277ULL, 0x0000001c69797810ULL, 0x000fc40007ffe0ffULL,
0x000000206900720cULL, 0x000fe20003f86070ULL, 0x000000017b697824ULL, 0x100fe200078e0277ULL,
0x000065006f6f7a10ULL, 0x000fe200037fe4ffULL, 0x0000000179777824ULL, 0x000fe200078e0277ULL,
0x0000640026747a10ULL, 0x000fe20007fde0ffULL, 0x000001006b6a7825ULL, 0x000fe200078e0024ULL,
0x0ffffff875767812ULL, 0x000fe400078ef800ULL, 0x0000650027757a10ULL, 0x000fe200037fe4ffULL,
0x0000010069267825ULL, 0x000fe200078e0024ULL, 0x000064006a6a7a10ULL, 0x000fc60007fde0ffULL,
0x0000001076697824ULL, 0x000fe200078e0215ULL, 0x000065006b6b7a10ULL, 0x000fe200037fe4ffULL,
0x0000010077247825ULL, 0x000fe200078e0024ULL, 0x000000207b00720cULL, 0x000fe40003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000070697faeULL, 0x0003e2000e101c46ULL,
0x0000001078777824ULL, 0x000fe200078e0215ULL, 0x0000640026267a10ULL, 0x000fe20007f9e0ffULL,
0x0000000179767824ULL, 0x000fc600078e0200ULL, 0x0000000072777faeULL, 0x0005e2000e901c46ULL,
0x000000207900720cULL, 0x000fe20003fa6070ULL, 0x000000017b207824ULL, 0x000fe200078e0200ULL,
0x0000650027277a10ULL, 0x000fe200027fe4ffULL, 0x000000087b7b7824ULL, 0x000fe200078e00ffULL,
0x0000640024247a10ULL, 0x000fe20007f9e0ffULL, 0x0000000879797824ULL, 0x000fe400078e00ffULL,
0x000000107a697824ULL, 0x102fe200078e0215ULL, 0xfffffff87b207812ULL, 0x000fe200078ee220ULL,
0x0000001082717824ULL, 0x100fe200078e0215ULL, 0xfffffff879767812ULL, 0x000fe200078ee276ULL,
0x0000001084737824ULL, 0x104fe200078e0215ULL, 0x0000650025257a10ULL, 0x000fe200027fe4ffULL,
0x0000001086777824ULL, 0x100fe200078e0215ULL, 0x000000006c697faeULL, 0x0003e2000d901c46ULL,
0x0000001020797824ULL, 0x000fc400078e0215ULL, 0x00000010767b7824ULL, 0x000fe200078e0215ULL,
0x000000006e717faeULL, 0x0003e8000d101c46ULL, 0x0000000074737faeULL, 0x0003e8000c901c46ULL,
0x000000006a777faeULL, 0x0003e8000c101c46ULL, 0x0000000026797faeULL, 0x0003e8000f101c46ULL,
0x00000000247b7faeULL, 0x0003e2000e901c46ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000000400277811ULL, 0x042fe200078fe8ffULL, 0x0000008005747824ULL, 0x000fe200078e0206ULL,
0x00000008006b7811ULL, 0x000fc400078fe8ffULL, 0x0000000c006d7811ULL, 0x040fe200078fe8ffULL,
0x0000000127207824ULL, 0x140fe200078e0200ULL, 0x0000001400717811ULL, 0x040fe200078fe8ffULL,
0x0000000827257824ULL, 0x000fe200078e00ffULL, 0x00000010006f7811ULL, 0x040fe200078fe8ffULL,
0x000000016b247824ULL, 0x040fe200078e0200ULL, 0x0000001800737811ULL, 0x000fe200078fe8ffULL,
0x000000086b697824ULL, 0x000fe200078e00ffULL, 0xfffffff825767812ULL, 0x000fe200078ee220ULL,
0x000000016d207824ULL, 0x100fe400078e0200ULL, 0x0000000171257824ULL, 0x000fe200078e0200ULL,
0xfffffff869787812ULL, 0x000fe200078ee224ULL, 0x000000086d697824ULL, 0x000fc400078e00ffULL,
0x0000000871847824ULL, 0x000fe400078e00ffULL, 0x000000016f247824ULL, 0x000fe200078e0200ULL,
0xfffffff8697a7812ULL, 0x000fe200078ee220ULL, 0x000000086f757824ULL, 0x000fe200078e00ffULL,
0xfffffff884847812ULL, 0x000fe200078ee225ULL, 0x0000000173267824ULL, 0x040fe200078e0200ULL,
0x0000001c00207811ULL, 0x040fe200078fe8ffULL, 0x0000000873797824ULL, 0x000fe200078e00ffULL,
0xfffffff875827812ULL, 0x000fe200078ee224ULL, 0x000000ffff757224ULL, 0x000fe200078e00ffULL,
0x0000007700257211ULL, 0x000fe200078fe8ffULL, 0x0000000127277824ULL, 0x100fe200078e0277ULL,
0xfffffff879867812ULL, 0x000fe200078ee226ULL, 0x000000016b6b7824ULL, 0x000fc400078e0277ULL,
0x000000016d6d7824ULL, 0x100fe400078e0277ULL, 0x000000016f6f7824ULL, 0x100fe400078e0277ULL,
0x0000000171717824ULL, 0x100fe400078e0277ULL, 0x0000000173737824ULL, 0x100fe400078e0277ULL,
0x0000000120697824ULL, 0x040fe400078e0277ULL, 0x0000000120777824ULL, 0x000fc400078e0200ULL,
0x0000000820887824ULL, 0x000fe200078e00ffULL, 0x0000000000207211ULL, 0x000fe200078fe8ffULL,
0x0000010025247825ULL, 0x000fc600078e0074ULL, 0xfffffff888887812ULL, 0x000fe200078ee277ULL,
0x0000010027267825ULL, 0x000fe200078e0074ULL, 0x0000640024247a10ULL, 0x000fc60007f1e0ffULL,
0x000001006b6a7825ULL, 0x100fe200078e0074ULL, 0x0000640026267a10ULL, 0x000fe40007f3e0ffULL,
0x0000650025257a10ULL, 0x000fe200007fe4ffULL, 0x000001006d6c7825ULL, 0x100fe200078e0074ULL,
0x0000650027277a10ULL, 0x000fe40000ffe4ffULL, 0x000064006a6a7a10ULL, 0x000fe20007f1e0ffULL,
0x000001006f6e7825ULL, 0x100fe200078e0074ULL, 0x000064006c6c7a10ULL, 0x000fe40007f3e0ffULL,
0x000065006b6b7a10ULL, 0x000fe200007fe4ffULL, 0x0000010071707825ULL, 0x000fe200078e0074ULL,
0x000064006e6e7a10ULL, 0x000fc40007f5e0ffULL, 0x000065006d6d7a10ULL, 0x000fe20000ffe4ffULL,
0x0000010073727825ULL, 0x100fe200078e0074ULL, 0x0000640070707a10ULL, 0x000fe40007f1e0ffULL,
0x000065006f6f7a10ULL, 0x000fe200017fe4ffULL, 0x0000010069747825ULL, 0x000fe200078e0074ULL,
0x0000000720697812ULL, 0x000fe400078ec0ffULL, 0x0000640072727a10ULL, 0x000fe20007f3e0ffULL,
0x0000001076777824ULL, 0x100fe200078e0215ULL, 0x0ffffff869207812ULL, 0x000fe200078ef800ULL,
0x0000001078797824ULL, 0x100fe200078e0215ULL, 0x0000640074747a10ULL, 0x000fe20007f5e0ffULL,
0x000000107a7b7824ULL, 0x100fe200078e0215ULL, 0x0000650071717a10ULL, 0x000fe200007fe4ffULL,
0x0000001020697824ULL, 0x100fe200078e0215ULL, 0x0000650073737a10ULL, 0x000fe20000ffe4ffULL,
0x0000001082837824ULL, 0x100fe200078e0215ULL, 0x0000650075757a10ULL, 0x000fe200017fe4ffULL,
0x0000001084857824ULL, 0x100fe200078e0215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024697faeULL, 0x0003e2000b901c46ULL, 0x0000001086877824ULL, 0x000fc400078e0215ULL,
0x0000001088897824ULL, 0x000fe200078e0215ULL, 0x0000000026777faeULL, 0x0003e8000b901c46ULL,
0x000000006a797faeULL, 0x0003e8000b901c46ULL, 0x000000006c7b7faeULL, 0x0003e8000b901c46ULL,
0x000000006e837faeULL, 0x0003e8000b901c46ULL, 0x0000000070857faeULL, 0x0003e8000b901c46ULL,
0x0000000072877faeULL, 0x0003e8000b901c46ULL, 0x0000000074897faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001002257812ULL, 0x002fca00078ec0ffULL,
0x0000002068687824ULL, 0x000fc800078e0225ULL, 0x0000000805207824ULL, 0x000fe200078e0268ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0166480020687f8cULL, 0x0002a4000c80043fULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x01664c0020277984ULL, 0x000ee40000000800ULL,
0x8000000027ff7812ULL, 0x00cfe40007804869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026246b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09006b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000006b26267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01664c0020277984ULL, 0x000ea40000000800ULL, 0x8000000027ff7812ULL, 0x004fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002097207824ULL, 0x002fca00078e00ffULL,
0xffffff8020257812ULL, 0x000fc800078ec0ffULL, 0x0000010006257810ULL, 0x000fca0007ffe025ULL,
0x000000017c257824ULL, 0x000fca00078e0225ULL, 0x0160000025687984ULL, 0x000e680000000800ULL,
0x01620000256a7984ULL, 0x0004e20000000800ULL, 0x000000216800720bULL, 0x002fe20003f1d000ULL,
0x000123927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000697806ULL, 0x004fc800000e0100ULL,
0x000000ff6900720cULL, 0x000fe20003f25270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff207224ULL, 0x000fd400078e0021ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x0000000297207811ULL, 0x000fe400078ff0ffULL,
0x000000216800720bULL, 0x000fe40003f34000ULL, 0x000000972000720cULL, 0x000fe20003f05270ULL,
0x000123427f007947ULL, 0x000fd4000b800000ULL, 0x0000000000207806ULL, 0x000fc400008e0100ULL,
0x0000008097258824ULL, 0x000fe200078e0206ULL, 0x0000002168248209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x000000017c258824ULL, 0x000fca00078e0225ULL,
0x0164002425008388ULL, 0x0003e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000002168247209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff20ff7812ULL, 0x000fc6000780c0ffULL,
0x0000002124247221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b24247820ULL, 0x000fc80000410000ULL,
0x00000024006c7308ULL, 0x000e640000000800ULL, 0x0000006c1f1f7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff257819ULL, 0x000fe20000011600ULL,
0x000122727f007947ULL, 0x000fea000b800000ULL, 0x00001f256c257589ULL, 0x0002a400000e0000ULL,
0x0000002528287220ULL, 0x084fe20000410000ULL, 0x0000002529297220ULL, 0x080fe20000410000ULL,
0x000000252c2c7220ULL, 0x080fe20000410000ULL, 0x000000252d2d7220ULL, 0x080fe20000410000ULL,
0x0000002530307220ULL, 0x080fe20000410000ULL, 0x0000002531317220ULL, 0x080fe20000410000ULL,
0x0000002534347220ULL, 0x080fe20000410000ULL, 0x0000002535357220ULL, 0x080fe20000410000ULL,
0x0000002538387220ULL, 0x080fe20000410000ULL, 0x0000002539397220ULL, 0x080fe20000410000ULL,
0x000000253c3c7220ULL, 0x080fe20000410000ULL, 0x000000253d3d7220ULL, 0x080fe20000410000ULL,
0x0000002540407220ULL, 0x080fe20000410000ULL, 0x0000002541417220ULL, 0x080fe20000410000ULL,
0x0000002544447220ULL, 0x080fe20000410000ULL, 0x0000002545457220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0020ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000800257811ULL, 0x000fe200078ff0ffULL, 0x000121427f007947ULL, 0x000fea000b800000ULL,
0x00001f256c257589ULL, 0x00046400000e0000ULL, 0x000000252a2a7220ULL, 0x086fe20000410000ULL,
0x000000252b2b7220ULL, 0x080fe20000410000ULL, 0x000000252e2e7220ULL, 0x080fe20000410000ULL,
0x000000252f2f7220ULL, 0x080fe20000410000ULL, 0x0000002532327220ULL, 0x080fe20000410000ULL,
0x0000002533337220ULL, 0x080fe20000410000ULL, 0x0000002536367220ULL, 0x080fe20000410000ULL,
0x0000002537377220ULL, 0x080fe20000410000ULL, 0x000000253a3a7220ULL, 0x080fe20000410000ULL,
0x000000253b3b7220ULL, 0x080fe20000410000ULL, 0x000000253e3e7220ULL, 0x080fe20000410000ULL,
0x000000253f3f7220ULL, 0x080fe20000410000ULL, 0x0000002542427220ULL, 0x080fe20000410000ULL,
0x0000002543437220ULL, 0x080fe20000410000ULL, 0x0000002546467220ULL, 0x080fe20000410000ULL,
0x0000002547477220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000020ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001000257811ULL, 0x000fe200078ff0ffULL,
0x000120127f007947ULL, 0x000fea000b800000ULL, 0x00001f256c257589ULL, 0x00046400000e0000ULL,
0x0000002548487220ULL, 0x086fe20000410000ULL, 0x0000002549497220ULL, 0x080fe20000410000ULL,
0x000000254c4c7220ULL, 0x080fe20000410000ULL, 0x000000254d4d7220ULL, 0x080fe20000410000ULL,
0x0000002550507220ULL, 0x080fe20000410000ULL, 0x0000002551517220ULL, 0x080fe20000410000ULL,
0x0000002554547220ULL, 0x080fe20000410000ULL, 0x0000002555557220ULL, 0x080fe20000410000ULL,
0x0000002558587220ULL, 0x080fe20000410000ULL, 0x0000002559597220ULL, 0x080fe20000410000ULL,
0x000000255c5c7220ULL, 0x080fe20000410000ULL, 0x000000255d5d7220ULL, 0x080fe20000410000ULL,
0x0000002560607220ULL, 0x080fe20000410000ULL, 0x0000002561617220ULL, 0x080fe20000410000ULL,
0x0000002564647220ULL, 0x080fe20000410000ULL, 0x0000002565657220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000020ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001800257811ULL, 0x000fe200078ff0ffULL,
0x00011ef27f007947ULL, 0x000fea000b800000ULL, 0x00001f256c257589ULL, 0x00046400000e0000ULL,
0x000000254a4a7220ULL, 0x086fe20000410000ULL, 0x000000254b4b7220ULL, 0x080fe20000410000ULL,
0x000000254e4e7220ULL, 0x080fe20000410000ULL, 0x000000254f4f7220ULL, 0x080fe20000410000ULL,
0x0000002552527220ULL, 0x080fe20000410000ULL, 0x0000002553537220ULL, 0x080fe20000410000ULL,
0x0000002556567220ULL, 0x080fe20000410000ULL, 0x0000002557577220ULL, 0x080fe20000410000ULL,
0x000000255a5a7220ULL, 0x080fe20000410000ULL, 0x000000255b5b7220ULL, 0x080fe20000410000ULL,
0x000000255e5e7220ULL, 0x080fe20000410000ULL, 0x000000255f5f7220ULL, 0x080fe20000410000ULL,
0x0000002562627220ULL, 0x080fe20000410000ULL, 0x0000002563637220ULL, 0x080fe20000410000ULL,
0x0000002566667220ULL, 0x080fe20000410000ULL, 0x0000002567677220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000002069ff7212ULL, 0x000fe400078030ffULL,
0x0000002168207209ULL, 0x000fd60007810000ULL, 0x8000002068680221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b68680820ULL, 0x000fc80000410000ULL, 0x0000006800070308ULL, 0x000e640000000800ULL,
0x000000076a6a0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000001f6a1f7221ULL, 0x008fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000000ffULL, 0x00000002ff687819ULL, 0x000fe40000011600ULL,
0x00005410080b7816ULL, 0x000fe20000000008ULL, 0x00011d227f007947ULL, 0x000fea000b800000ULL,
0x00001f680b087589ULL, 0x0002a400000e0000ULL, 0x0000000868257810ULL, 0x000fe20007ffe0ffULL,
0x00011d527f007947ULL, 0x000fea000b800000ULL, 0x00000010680a7810ULL, 0x000fe20007ffe0ffULL,
0x00001f250b097589ULL, 0x00066a00000e0000ULL, 0x00001f0a0b0a7589ULL, 0x0006a400000e0000ULL,
0x0000001868257810ULL, 0x008fe20007ffe0ffULL, 0x00011da27f007947ULL, 0x000fea000b800000ULL,
0x00001f250b0b7589ULL, 0x0022e400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000297217824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000200097247824ULL, 0x000fe200078e00ffULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000000080c277824ULL, 0x000fe200078e00ffULL, 0x0000000421217812ULL, 0x000fe200078ec0ffULL,
0x000000080d687824ULL, 0x000fe200078e00ffULL, 0xffffc00024267812ULL, 0x000fc400078ec0ffULL,
0x0000002100217211ULL, 0x000fc600078fe0ffULL, 0x0000200005717824ULL, 0x000fe400078e0226ULL,
0x000000010c247824ULL, 0x100fe400078e0221ULL, 0x000000010d257824ULL, 0x002fe200078e0221ULL,
0x0000c0000f217810ULL, 0x000fe40007ffe0ffULL, 0xfffffff827247812ULL, 0x000fe400078ee224ULL,
0xfffffff868267812ULL, 0x000fe400078ee225ULL, 0x0000e00071717810ULL, 0x000fe20007ffe0ffULL,
0x0000001024687824ULL, 0x000fc400078e0221ULL, 0x0000001026267824ULL, 0x000fe400078e0221ULL,
0x00000010106c7824ULL, 0x100fe400078e0271ULL, 0x000000006868783bULL, 0x000e620000000200ULL,
0x000000100e707824ULL, 0x100fe400078e0271ULL, 0x0000001011747824ULL, 0x000fe200078e0271ULL,
0x000000002624783bULL, 0x000ee20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000868687232ULL, 0x086fe40000000000ULL, 0x000000086a6a7232ULL, 0x000fc40000000000ULL,
0x0000000969697232ULL, 0x080fe40000000000ULL, 0x000000096b6b7232ULL, 0x000fe40000000000ULL,
0x0000000a24247232ULL, 0x088fe40000000000ULL, 0x0000000a26267232ULL, 0x000fe40000000000ULL,
0x0000000b25257232ULL, 0x080fe40000000000ULL, 0x0000000b27277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001012787824ULL, 0x000fe200078e0271ULL,
0x000000006c6c783bULL, 0x000f220000004200ULL, 0x0000e0001e1e7810ULL, 0x000fe20007ffe0ffULL,
0x0000024000007945ULL, 0x000fe40003800000ULL, 0x000000007070783bULL, 0x000ee80000004200ULL,
0x000000007474783bULL, 0x000ea80000004200ULL, 0x000000007878783bULL, 0x000e640000004200ULL,
0x0000006c6828723cULL, 0x092f700000001828ULL, 0x0000006c2448723cULL, 0x048b6e0000001848ULL,
0x00000010136c7824ULL, 0x120fe200078e0221ULL, 0x0000006e244c723cULL, 0x000f62000000184cULL,
0x0000001014217824ULL, 0x000fce00078e0221ULL, 0x000000702450723cULL, 0x040f700000001850ULL,
0x000000722454723cULL, 0x040f700000001854ULL, 0x000000742458723cULL, 0x044f700000001858ULL,
0x00000076245c723cULL, 0x040f70000000185cULL, 0x000000782460723cULL, 0x000f700000001860ULL,
0x0000006e682c723cULL, 0x000b64000000182cULL, 0x000000006c6c783bULL, 0x020e6c0000000200ULL,
0x0000007a2424723cULL, 0x000b640000001864ULL, 0x000000002164783bULL, 0x0204ec0000000200ULL,
0x000000706830723cULL, 0x040b6e0000001830ULL, 0x000000101c707824ULL, 0x120fe200078e021eULL,
0x000000726834723cULL, 0x040f700000001834ULL, 0x000000746838723cULL, 0x040b6e0000001838ULL,
0x000000101d747824ULL, 0x120fe200078e021eULL, 0x00000076683c723cULL, 0x040f70000000183cULL,
0x000000786840723cULL, 0x040f700000001840ULL, 0x0000007a6844723cULL, 0x000b6e0000001844ULL,
0x000000101b687824ULL, 0x020fe200078e021eULL, 0x0000008000008947ULL, 0x000fd60003800000ULL,
0x000000086c6c7232ULL, 0x08efe40000000000ULL, 0x000000086e6e7232ULL, 0x000fc40000000000ULL,
0x000000096d6d7232ULL, 0x080fe40000000000ULL, 0x000000096f6f7232ULL, 0x000fe40000000000ULL,
0x0000000a64647232ULL, 0x080fe40000000000ULL, 0x0000000a66667232ULL, 0x000fe40000000000ULL,
0x0000000b65657232ULL, 0x080fe40000000000ULL, 0x0000000b67677232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x00efea0003800000ULL, 0x000000101a787824ULL, 0x000fe200078e021eULL,
0x000000006868783bULL, 0x000e620000004200ULL, 0x00000002ff1a7819ULL, 0x000fc60000011697ULL,
0x000000007070783bULL, 0x000ea20000004200ULL, 0x000166981a1b7811ULL, 0x000fc600078e18ffULL,
0x000000007474783bULL, 0x000ee80000004200ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x000000686448723cULL, 0x042b700000001848ULL, 0x0000006a644c723cULL, 0x040b70000000184cULL,
0x000000706450723cULL, 0x044b700000001850ULL, 0x000000726454723cULL, 0x040b700000001854ULL,
0x000000746458723cULL, 0x048b700000001858ULL, 0x00000076645c723cULL, 0x040b70000000185cULL,
0x000000786460723cULL, 0x010b700000001860ULL, 0x000000686c28723cULL, 0x040b700000001828ULL,
0x0000006a6c2c723cULL, 0x040b70000000182cULL, 0x000000706c30723cULL, 0x040b700000001830ULL,
0x000000726c34723cULL, 0x040b700000001834ULL, 0x000000746c38723cULL, 0x040b700000001838ULL,
0x000000766c3c723cULL, 0x040b70000000183cULL, 0x000000786c40723cULL, 0x040b700000001840ULL,
0x0000007a6c44723cULL, 0x080b700000001844ULL, 0x0000007a6464723cULL, 0x000b620000001824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000030095957a10ULL, 0x000fe20007ffe0ffULL,
0x000000001bff7f8cULL, 0x0003e6000c80043fULL, 0x000000239500720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x00000ba000000947ULL, 0x000fea0003800000ULL,
0x00000001951c7810ULL, 0x042fe20007ffe0ffULL, 0x00000100951d7824ULL, 0x000fc600078e0203ULL,
0x000000231c00720cULL, 0x000fe20003f06070ULL, 0x0000680004737a24ULL, 0x020fd800078e021dULL,
0x0000061000008947ULL, 0x000fea0003800000ULL, 0x00000003ff707819ULL, 0x000fe20000011600ULL,
0x00000080051c7824ULL, 0x000fe200078e0206ULL, 0x0000001d941b7217ULL, 0x000fe40007800000ULL,
0x0000000470247810ULL, 0x040fe20007ffe0ffULL, 0x0000000170257824ULL, 0x040fe200078e0273ULL,
0x0000000870687810ULL, 0x040fe20007ffe0ffULL, 0x000000011b1b7824ULL, 0x000fe200078e0a1dULL,
0x0000000c706e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001241d7824ULL, 0x100fe200078e0200ULL,
0x0000001070727810ULL, 0x000fe20007ffe0ffULL, 0x0000000824267824ULL, 0x000fe200078e00ffULL,
0x000000201b1b7817ULL, 0x000fe20003800000ULL, 0x0000000168217824ULL, 0x000fc400078e0200ULL,
0x00000008686a7824ULL, 0x000fe200078e00ffULL, 0xfffffff826717812ULL, 0x000fe200078ee21dULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x0000001b2400720cULL, 0x0c0fe20003f86070ULL,
0x0000000124277824ULL, 0x000fe200078e0273ULL, 0xfffffff86a797812ULL, 0x000fe200078ee221ULL,
0x000000016e217824ULL, 0x040fe200078e0200ULL, 0x0000001b6e00720cULL, 0x0c0fe20003f46070ULL,
0x000000086e6a7824ULL, 0x000fe200078e00ffULL, 0x0000001b6800720cULL, 0x080fe20003f66070ULL,
0x0000010025247825ULL, 0x000fe200078e001cULL, 0x0000001b7000720cULL, 0x000fc40003fa6070ULL,
0xfffffff86a7b7812ULL, 0x000fe200078ee221ULL, 0x0000010027267825ULL, 0x000fe200078e001cULL,
0x00006400246a7a10ULL, 0x000fc60007f1e0ffULL, 0x0000000172697824ULL, 0x000fe200078e0200ULL,
0x00006400266c7a10ULL, 0x000fe20007f3e0ffULL, 0x0000000872747824ULL, 0x000fe200078e00ffULL,
0x00006500256b7a10ULL, 0x000fe200007fe4ffULL, 0x0000000168257824ULL, 0x100fe200078e0273ULL,
0x00006500276d7a10ULL, 0x000fe20000ffe4ffULL, 0x000000016e277824ULL, 0x000fe200078e0273ULL,
0xfffffff874837812ULL, 0x000fe200078ee269ULL, 0x0000010025247825ULL, 0x000fe200078e001cULL,
0x0000001470747810ULL, 0x000fe40007ffe0ffULL, 0x0000001b7200720cULL, 0x040fe20003f26070ULL,
0x0000000172697824ULL, 0x000fe200078e0273ULL, 0x00006400246e7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000170217824ULL, 0x000fc400078e0200ULL, 0x00000001746f7824ULL, 0x040fe400078e0200ULL,
0x0000000874727824ULL, 0x000fe200078e00ffULL, 0x0000000721217812ULL, 0x000fe200078ec0ffULL,
0x0000010027267825ULL, 0x000fc600078e001cULL, 0xfffffff872857812ULL, 0x000fe200078ee26fULL,
0x0000010069687825ULL, 0x000fe200078e001cULL, 0x0000640026267a10ULL, 0x000fe40007fde0ffULL,
0x00006500256f7a10ULL, 0x000fe200007fe4ffULL, 0x0000000174257824ULL, 0x000fe200078e0273ULL,
0x0ffffff821217812ULL, 0x000fe200078ef800ULL, 0x0000001071777824ULL, 0x000fe200078e021eULL,
0x0000650027277a10ULL, 0x000fe200037fe4ffULL, 0x0000010025247825ULL, 0x000fe200078e001cULL,
0x0000640068687a10ULL, 0x000fc40007fde0ffULL, 0x0000001870727810ULL, 0x000fe20007ffe0ffULL,
0x0000001021757824ULL, 0x100fe200078e021eULL, 0x0000001b7400720cULL, 0x080fe20003f06070ULL,
0x0000001079797824ULL, 0x100fe200078e021eULL, 0x0000650069697a10ULL, 0x000fe200037fe4ffULL,
0x0000000172217824ULL, 0x000fe200078e0273ULL, 0x0000001c70747810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a757faeULL, 0x0003e2000e901c46ULL,
0x0000640024707a10ULL, 0x000fe20007fde0ffULL, 0x000000107b7b7824ULL, 0x000fe200078e021eULL,
0x0000001b7200720cULL, 0x080fe20003fa6070ULL, 0x000000006c777faeULL, 0x0005e2000e101c46ULL,
0x0000650025717a10ULL, 0x000fe200037fe4ffULL, 0x0000010021247825ULL, 0x000fe200078e001cULL,
0x0000001b7400720cULL, 0x040fe20003f86070ULL, 0x000000006e797faeULL, 0x0005e4000d901c46ULL,
0x00000001741b7824ULL, 0x000fe200078e0273ULL, 0x0000640024247a10ULL, 0x000fe20007fde0ffULL,
0x0000000172217824ULL, 0x140fe200078e0200ULL, 0x00000000267b7faeULL, 0x0005e2000d101c46ULL,
0x0000000872727824ULL, 0x000fe200078e00ffULL, 0x0000650025257a10ULL, 0x000fe200037fe4ffULL,
0x00000001746a7824ULL, 0x002fc400078e0200ULL, 0x00000008746b7824ULL, 0x000fe200078e00ffULL,
0xfffffff872217812ULL, 0x000fe200078ee221ULL, 0x000001001b1c7825ULL, 0x000fc600078e001cULL,
0xfffffff86b1b7812ULL, 0x000fe200078ee26aULL, 0x0000001083837824ULL, 0x100fe200078e021eULL,
0x000064001c1c7a10ULL, 0x000fe20007fde0ffULL, 0x0000001085857824ULL, 0x100fe400078e021eULL,
0x0000001021217824ULL, 0x100fe200078e021eULL, 0x000065001d1d7a10ULL, 0x000fe200037fe4ffULL,
0x000000101b1b7824ULL, 0x000fe200078e021eULL, 0x0000000068837faeULL, 0x0005e8000c901c46ULL,
0x0000000070857faeULL, 0x0005e8000c101c46ULL, 0x0000000024217faeULL, 0x0005e8000e901c46ULL,
0x000000001c1b7faeULL, 0x0005e2000e101c46ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000000400257811ULL, 0x040fe200078fe8ffULL, 0x0000008005707824ULL, 0x000fe200078e0206ULL,
0x0000000800277811ULL, 0x040fe200078fe8ffULL, 0x000000ffff717224ULL, 0x000fe200078e00ffULL,
0x0000000c00697811ULL, 0x040fe200078fe8ffULL, 0x00000001251b7824ULL, 0x140fe200078e0200ULL,
0x00000010006b7811ULL, 0x040fe200078fe8ffULL, 0x0000000825247824ULL, 0x000fe200078e00ffULL,
0x00000014006d7811ULL, 0x040fe200078fe8ffULL, 0x00000001271c7824ULL, 0x140fe200078e0200ULL,
0x00000018006f7811ULL, 0x000fe200078fe8ffULL, 0x0000000827777824ULL, 0x000fe200078e00ffULL,
0xfffffff824757812ULL, 0x000fe200078ee21bULL, 0x00000001691b7824ULL, 0x000fc400078e0200ULL,
0x0000000869247824ULL, 0x000fe200078e00ffULL, 0xfffffff877777812ULL, 0x000fe200078ee21cULL,
0x000000016b1c7824ULL, 0x140fe400078e0200ULL, 0x000000086b7b7824ULL, 0x000fe200078e00ffULL,
0xfffffff824797812ULL, 0x000fe200078ee21bULL, 0x000000016d1d7824ULL, 0x040fe200078e0200ULL,
0x00000000001b7211ULL, 0x040fe200078fe8ffULL, 0x000000086d267824ULL, 0x000fe200078e00ffULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee21cULL, 0x000000016f217824ULL, 0x040fe200078e0200ULL,
0x0000001c001c7811ULL, 0x000fe200078fe8ffULL, 0x000000086f687824ULL, 0x000fe200078e00ffULL,
0xfffffff826837812ULL, 0x000fe200078ee21dULL, 0x0000000125257824ULL, 0x100fe200078e0273ULL,
0x00000073001d7211ULL, 0x000fe200078fe8ffULL, 0x0000000127277824ULL, 0x000fe200078e0273ULL,
0xfffffff868857812ULL, 0x000fe200078ee221ULL, 0x0000000169697824ULL, 0x100fe200078e0273ULL,
0x000000071b217812ULL, 0x000fe200078ec0ffULL, 0x000000016b6b7824ULL, 0x000fc400078e0273ULL,
0x000000016d6d7824ULL, 0x100fe200078e0273ULL, 0x0ffffff821217812ULL, 0x100fe200078ef800ULL,
0x000000016f6f7824ULL, 0x100fe400078e0273ULL, 0x000000011c1b7824ULL, 0x040fe400078e0273ULL,
0x000000011c727824ULL, 0x040fe400078e0200ULL, 0x000000081c737824ULL, 0x000fe400078e00ffULL,
0x000001001d1c7825ULL, 0x000fc800078e0070ULL, 0x0000010025247825ULL, 0x000fe200078e0070ULL,
0x000064001c1c7a10ULL, 0x000fc60007f1e0ffULL, 0x0000010027267825ULL, 0x100fe200078e0070ULL,
0x0000640024247a10ULL, 0x000fe40007f3e0ffULL, 0x000065001d1d7a10ULL, 0x000fe200007fe4ffULL,
0x0000010069687825ULL, 0x100fe200078e0070ULL, 0x0000640026267a10ULL, 0x000fe40007f5e0ffULL,
0x0000650025257a10ULL, 0x000fe20000ffe4ffULL, 0x000001006b6a7825ULL, 0x100fe200078e0070ULL,
0x0000640068687a10ULL, 0x000fe40007f7e0ffULL, 0x0000650027277a10ULL, 0x000fe200017fe4ffULL,
0x000001006d6c7825ULL, 0x000fe200078e0070ULL, 0x000064006a6a7a10ULL, 0x000fc40007f1e0ffULL,
0x0000650069697a10ULL, 0x000fe20001ffe4ffULL, 0x000001006f6e7825ULL, 0x100fe200078e0070ULL,
0x000064006c6c7a10ULL, 0x000fe40007f3e0ffULL, 0x000065006b6b7a10ULL, 0x000fe200007fe4ffULL,
0x000001001b707825ULL, 0x000fe200078e0070ULL, 0xfffffff8731b7812ULL, 0x000fe400078ee272ULL,
0x000064006e6e7a10ULL, 0x000fe20007f5e0ffULL, 0x0000001021217824ULL, 0x100fe200078e021eULL,
0x0000640070707a10ULL, 0x000fe20007f7e0ffULL, 0x0000001075757824ULL, 0x100fe200078e021eULL,
0x000065006d6d7a10ULL, 0x000fe20000ffe4ffULL, 0x0000001077777824ULL, 0x100fe200078e021eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c217faeULL, 0x0003e2000b901c46ULL,
0x0000001079797824ULL, 0x100fe200078e021eULL, 0x000065006f6f7a10ULL, 0x000fe200017fe4ffULL,
0x000000107b7b7824ULL, 0x100fe200078e021eULL, 0x0000000024757faeULL, 0x0003e2000b901c46ULL,
0x0000001083837824ULL, 0x100fe200078e021eULL, 0x0000650071717a10ULL, 0x000fe20001ffe4ffULL,
0x0000001085857824ULL, 0x100fe200078e021eULL, 0x0000000026777faeULL, 0x0003e2000b901c46ULL,
0x000000101b1b7824ULL, 0x000fc600078e021eULL, 0x0000000068797faeULL, 0x0003e8000b901c46ULL,
0x000000006a7b7faeULL, 0x0003e8000b901c46ULL, 0x000000006c837faeULL, 0x0003e8000b901c46ULL,
0x000000006e857faeULL, 0x0003e8000b901c46ULL, 0x00000000701b7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x002e220000000000ULL, 0x00000010021b7812ULL, 0x004fc400078ec0ffULL,
0x00000008021e7812ULL, 0x000fc600078ec0ffULL, 0x000000201a1b7824ULL, 0x000fc800078e021bULL,
0x000000011e1e7824ULL, 0x000fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x016668001e247f8cULL, 0x0202a4000c80043fULL, 0x00000000001a7805ULL, 0x000fc40000015200ULL,
0x01666c001e1d7984ULL, 0x000ee40000000800ULL, 0x800000001dff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff267224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c1a217210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e1bULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1c7819ULL, 0x000fc8000001141dULL,
0x000000211c1c7211ULL, 0x000fca00078110ffULL, 0x000000ffff1d7224ULL, 0x000fca00000e061dULL,
0x000000021c1c7819ULL, 0x000fc8000000121dULL, 0x0000001c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000126267810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01666c001e1d7984ULL, 0x000ea40000000800ULL,
0x800000001dff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000003971b7811ULL, 0x000fca00078ff0ffULL, 0x000000801b1b7824ULL, 0x000fc800078e0206ULL,
0x000000017c1b7824ULL, 0x000fca00078e021bULL, 0x016000001b1d7984ULL, 0x000ea80000000800ULL,
0x016200001b1a7984ULL, 0x0006620000000800ULL, 0x000000201d00720bULL, 0x004fe20003f1d000ULL,
0x000108427f007947ULL, 0x000fd8000b800000ULL, 0x00000000001b7806ULL, 0x008fc800000e0100ULL,
0x000000ff1b00720cULL, 0x000fe20003f25270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff1c7224ULL, 0x000fd400078e0020ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x00000003971c7811ULL, 0x000fe400078ff0ffULL,
0x000000201d00720bULL, 0x000fe40003f34000ULL, 0x000000971c00720cULL, 0x000fe20003f05270ULL,
0x000107f27f007947ULL, 0x000fd4000b800000ULL, 0x00000000001c7806ULL, 0x000fc400008e0100ULL,
0x0000008097218824ULL, 0x000fe200078e0206ULL, 0x000000201d068209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x000000017c218824ULL, 0x000fca00078e0221ULL,
0x0164000621008388ULL, 0x0005e20000000800ULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x000000201d217209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff1cff7812ULL, 0x000fc6000780c0ffULL,
0x0000002021067221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b06067820ULL, 0x000fcc0000410000ULL,
0x0000000600067308ULL, 0x000ea40000000800ULL, 0x000000061f1f7220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff257819ULL, 0x000fe20000011600ULL,
0x000107227f007947ULL, 0x000fea000b800000ULL, 0x00001f2506257589ULL, 0x0004e400000e0000ULL,
0x0000002528287220ULL, 0x08cfe20000410000ULL, 0x0000002529297220ULL, 0x080fe20000410000ULL,
0x000000252c2c7220ULL, 0x080fe20000410000ULL, 0x000000252d2d7220ULL, 0x080fe20000410000ULL,
0x0000002530307220ULL, 0x080fe20000410000ULL, 0x0000002531317220ULL, 0x080fe20000410000ULL,
0x0000002534347220ULL, 0x080fe20000410000ULL, 0x0000002535357220ULL, 0x080fe20000410000ULL,
0x0000002538387220ULL, 0x080fe20000410000ULL, 0x0000002539397220ULL, 0x080fe20000410000ULL,
0x000000253c3c7220ULL, 0x080fe20000410000ULL, 0x000000253d3d7220ULL, 0x080fe20000410000ULL,
0x0000002540407220ULL, 0x080fe20000410000ULL, 0x0000002541417220ULL, 0x080fe20000410000ULL,
0x0000002544447220ULL, 0x080fe20000410000ULL, 0x0000002545457220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000800257811ULL, 0x000fe200078ff0ffULL, 0x000105f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2506257589ULL, 0x0004e400000e0000ULL, 0x000000252a2a7220ULL, 0x08cfe20000410000ULL,
0x000000252b2b7220ULL, 0x080fe20000410000ULL, 0x000000252e2e7220ULL, 0x080fe20000410000ULL,
0x000000252f2f7220ULL, 0x080fe20000410000ULL, 0x0000002532327220ULL, 0x080fe20000410000ULL,
0x0000002533337220ULL, 0x080fe20000410000ULL, 0x0000002536367220ULL, 0x080fe20000410000ULL,
0x0000002537377220ULL, 0x080fe20000410000ULL, 0x000000253a3a7220ULL, 0x080fe20000410000ULL,
0x000000253b3b7220ULL, 0x080fe20000410000ULL, 0x000000253e3e7220ULL, 0x080fe20000410000ULL,
0x000000253f3f7220ULL, 0x080fe20000410000ULL, 0x0000002542427220ULL, 0x080fe20000410000ULL,
0x0000002543437220ULL, 0x080fe20000410000ULL, 0x0000002546467220ULL, 0x080fe20000410000ULL,
0x0000002547477220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00001cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001000257811ULL, 0x000fe200078ff0ffULL,
0x000104c27f007947ULL, 0x000fea000b800000ULL, 0x00001f2506257589ULL, 0x0004e400000e0000ULL,
0x0000002548487220ULL, 0x08cfe20000410000ULL, 0x0000002549497220ULL, 0x080fe20000410000ULL,
0x000000254c4c7220ULL, 0x080fe20000410000ULL, 0x000000254d4d7220ULL, 0x080fe20000410000ULL,
0x0000002550507220ULL, 0x080fe20000410000ULL, 0x0000002551517220ULL, 0x080fe20000410000ULL,
0x0000002554547220ULL, 0x080fe20000410000ULL, 0x0000002555557220ULL, 0x080fe20000410000ULL,
0x0000002558587220ULL, 0x080fe20000410000ULL, 0x0000002559597220ULL, 0x080fe20000410000ULL,
0x000000255c5c7220ULL, 0x080fe20000410000ULL, 0x000000255d5d7220ULL, 0x080fe20000410000ULL,
0x0000002560607220ULL, 0x080fe20000410000ULL, 0x0000002561617220ULL, 0x080fe20000410000ULL,
0x0000002564647220ULL, 0x080fe20000410000ULL, 0x0000002565657220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000001cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001800257811ULL, 0x000fe200078ff0ffULL,
0x000103a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2506257589ULL, 0x0004e400000e0000ULL,
0x000000254a4a7220ULL, 0x08cfe20000410000ULL, 0x000000254b4b7220ULL, 0x080fe20000410000ULL,
0x000000254e4e7220ULL, 0x080fe20000410000ULL, 0x000000254f4f7220ULL, 0x080fe20000410000ULL,
0x0000002552527220ULL, 0x080fe20000410000ULL, 0x0000002553537220ULL, 0x080fe20000410000ULL,
0x0000002556567220ULL, 0x080fe20000410000ULL, 0x0000002557577220ULL, 0x080fe20000410000ULL,
0x000000255a5a7220ULL, 0x080fe20000410000ULL, 0x000000255b5b7220ULL, 0x080fe20000410000ULL,
0x000000255e5e7220ULL, 0x080fe20000410000ULL, 0x000000255f5f7220ULL, 0x080fe20000410000ULL,
0x0000002562627220ULL, 0x080fe20000410000ULL, 0x0000002563637220ULL, 0x080fe20000410000ULL,
0x0000002566667220ULL, 0x080fe20000410000ULL, 0x0000002567677220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000001c1bff7212ULL, 0x000fe400078030ffULL,
0x000000201d1c7209ULL, 0x000fd60007810000ULL, 0x8000001c1d1d0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b1d1d0820ULL, 0x000fc80000410000ULL, 0x0000001d00070308ULL, 0x000ea40000000800ULL,
0x000000071a1a0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000001f1a1f7221ULL, 0x002fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000007ff06723eULL, 0x000fe400000000ffULL, 0x00000002ff0b7819ULL, 0x000fe40000011600ULL,
0x0000541006067816ULL, 0x000fe20000000006ULL, 0x000101d27f007947ULL, 0x000fea000b800000ULL,
0x00001f0b06087589ULL, 0x0002a400000e0000ULL, 0x000000080b257810ULL, 0x000fe20007ffe0ffULL,
0x000102027f007947ULL, 0x000fea000b800000ULL, 0x000000100b1b7810ULL, 0x000fe20007ffe0ffULL,
0x00001f2506097589ULL, 0x00066800000e0000ULL, 0x00001f1b060a7589ULL, 0x0006a400000e0000ULL,
0x000000180b257810ULL, 0x008fe20007ffe0ffULL, 0x000102527f007947ULL, 0x000fea000b800000ULL,
0x00001f25060b7589ULL, 0x0022e400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff1a7819ULL, 0x000fe20000011697ULL, 0x000000080c1d7824ULL, 0x000fe200078e00ffULL,
0x00000004ff1b7819ULL, 0x000fe20000011600ULL, 0x000000080d217824ULL, 0x000fe200078e00ffULL,
0x000000011a067812ULL, 0x002fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000001010747824ULL, 0x000fc400078e0215ULL,
0x0000000406067824ULL, 0x000fe200078e021bULL, 0x00000003971b7811ULL, 0x000fe200078ff0ffULL,
0x000000100e787824ULL, 0x100fe400078e0215ULL, 0x000000010c0c7824ULL, 0x100fe400078e0206ULL,
0x000000010d067824ULL, 0x000fe200078e0206ULL, 0x0000a0001b0d7811ULL, 0x000fe200078e60ffULL,
0x0000001011687824ULL, 0x000fe200078e0215ULL, 0xfffffff81d0c7812ULL, 0x000fe400078ee20cULL,
0xfffffff821067812ULL, 0x000fc600078ee206ULL, 0x000000100c0c7824ULL, 0x100fe400078e020dULL,
0x0000001006067824ULL, 0x000fc600078e020dULL, 0x000000000c70783bULL, 0x0002e80000000200ULL,
0x000000000624783bULL, 0x0002a20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000870707232ULL, 0x08cfe40000000000ULL, 0x0000000872727232ULL, 0x000fe40000000000ULL,
0x0000000971717232ULL, 0x080fe40000000000ULL, 0x0000000973737232ULL, 0x000fc40000000000ULL,
0x0000000a24247232ULL, 0x080fe40000000000ULL, 0x0000000a26267232ULL, 0x000fe40000000000ULL,
0x0000000b25257232ULL, 0x080fe40000000000ULL, 0x0000000b27277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010126c7824ULL, 0x000fe200078e0215ULL,
0x000000007474783bULL, 0x000f220000004200ULL, 0x0000d0000f0f7810ULL, 0x000fe20007ffe0ffULL,
0x0000022000007945ULL, 0x000fe40003800000ULL, 0x000000007878783bULL, 0x000e640000004200ULL,
0x0000001013137824ULL, 0x000fc400078e020fULL, 0x000000006868783bULL, 0x000ee20000004200ULL,
0x00000010140f7824ULL, 0x000fc600078e020fULL, 0x000000006c6c783bULL, 0x000ea80000004200ULL,
0x000000001310783bULL, 0x000e680000000200ULL, 0x000000000f0c783bULL, 0x002e620000000200ULL,
0x000000747028723cULL, 0x058b700000001828ULL, 0x00000076702c723cULL, 0x040b70000000182cULL,
0x000000787030723cULL, 0x040b700000001830ULL, 0x0000007a7034723cULL, 0x040b700000001834ULL,
0x000000687038723cULL, 0x040b700000001838ULL, 0x0000006a703c723cULL, 0x040b70000000183cULL,
0x0000006c7040723cULL, 0x044b700000001840ULL, 0x0000006e7044723cULL, 0x000b700000001844ULL,
0x000000742448723cULL, 0x040b700000001848ULL, 0x00000076244c723cULL, 0x040b70000000184cULL,
0x000000782450723cULL, 0x040b700000001850ULL, 0x0000007a2454723cULL, 0x040b700000001854ULL,
0x000000682458723cULL, 0x040b700000001858ULL, 0x0000006a245c723cULL, 0x040b70000000185cULL,
0x0000006c2460723cULL, 0x040b700000001860ULL, 0x0000006e2464723cULL, 0x000b620000001864ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000008000008947ULL, 0x000fde0003800000ULL,
0x0000000810107232ULL, 0x082fe40000000000ULL, 0x0000000812127232ULL, 0x000fc40000000000ULL,
0x0000000911117232ULL, 0x080fe40000000000ULL, 0x0000000913137232ULL, 0x000fe40000000000ULL,
0x0000000a0c0c7232ULL, 0x080fe40000000000ULL, 0x0000000a0e0e7232ULL, 0x000fe40000000000ULL,
0x0000000b0d0d7232ULL, 0x080fe40000000000ULL, 0x0000000b0f0f7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x002fea0003800000ULL, 0x000000001624783bULL, 0x020e620000004200ULL,
0x0000000297067824ULL, 0x000fc600078e00ffULL, 0x000000001768783bULL, 0x000ea40000004200ULL,
0xfffffff806067812ULL, 0x000fe400078ec0ffULL, 0x00000000186c783bULL, 0x000ee80000004200ULL,
0x000000001970783bULL, 0x000f220000004200ULL, 0x000000241028723cULL, 0x042b700000001828ULL,
0x00000026102c723cULL, 0x040b70000000182cULL, 0x000000681030723cULL, 0x044b700000001830ULL,
0x0000006a1034723cULL, 0x040b700000001834ULL, 0x0000006c1038723cULL, 0x048b700000001838ULL,
0x0000006e103c723cULL, 0x040b70000000183cULL, 0x000000701040723cULL, 0x050b700000001840ULL,
0x000000721044723cULL, 0x000b700000001844ULL, 0x000000240c48723cULL, 0x040b700000001848ULL,
0x000000260c4c723cULL, 0x040b70000000184cULL, 0x000000680c50723cULL, 0x040b700000001850ULL,
0x0000006a0c54723cULL, 0x040b700000001854ULL, 0x0000006c0c58723cULL, 0x040b700000001858ULL,
0x0000006e0c5c723cULL, 0x040b70000000185cULL, 0x000000700c60723cULL, 0x040b700000001860ULL,
0x000000720c64723cULL, 0x000b620000001864ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000239500720cULL, 0x000fe20003f06070ULL, 0x0166a00006ff7f8cULL, 0x0003d8000c80043fULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff847000007947ULL, 0x000fea000383ffffULL,
0x0000000000047919ULL, 0x000e640000002500ULL, 0x000000230400720cULL, 0x002fda0003f06070ULL,
0x0000057000000947ULL, 0x000fea0003800000ULL, 0x018000001f007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e001fULL, 0x00009b5000087802ULL, 0x000fc40000000f00ULL,
0x0000fe7000007944ULL, 0x020fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001f00007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc8000000001fULL,
0x800000ff02077221ULL, 0x000fc80000010100ULL, 0x0000000700007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x006e640000000000ULL,
0x0000001006077811ULL, 0x042fe400078ff0ffULL, 0x00000002ff097819ULL, 0x000fe40000011606ULL,
0x00000018060d7811ULL, 0x060fe400078ff0ffULL, 0x00000008060b7811ULL, 0x000fe200078ff0ffULL,
0x00001f0900027589ULL, 0x008e6800000e0000ULL, 0x00001f0d00087589ULL, 0x000ea800000e0000ULL,
0x00001f0b00067589ULL, 0x000ee800000e0000ULL, 0x00001f0700077589ULL, 0x000f2200000e0000ULL,
0x0000002802287220ULL, 0x042fe20000410000ULL, 0x0000002902297220ULL, 0x040fe20000410000ULL,
0x0000002c022c7220ULL, 0x040fe20000410000ULL, 0x0000002d022d7220ULL, 0x040fe20000410000ULL,
0x0000003002307220ULL, 0x040fe20000410000ULL, 0x0000003102317220ULL, 0x040fe20000410000ULL,
0x0000003402347220ULL, 0x040fe20000410000ULL, 0x0000003502357220ULL, 0x040fe20000410000ULL,
0x0000003802387220ULL, 0x040fe20000410000ULL, 0x0000003902397220ULL, 0x040fe20000410000ULL,
0x0000003c023c7220ULL, 0x040fe20000410000ULL, 0x0000003d023d7220ULL, 0x040fe20000410000ULL,
0x0000004002407220ULL, 0x040fe20000410000ULL, 0x0000004102417220ULL, 0x040fe20000410000ULL,
0x0000004402447220ULL, 0x040fe20000410000ULL, 0x0000004502457220ULL, 0x000fe20000410000ULL,
0x0000004a084a7220ULL, 0x044fe20000410000ULL, 0x0000004b084b7220ULL, 0x040fe20000410000ULL,
0x0000004e084e7220ULL, 0x040fe20000410000ULL, 0x0000004f084f7220ULL, 0x040fe20000410000ULL,
0x0000005208527220ULL, 0x040fe20000410000ULL, 0x0000005308537220ULL, 0x040fe20000410000ULL,
0x0000005608567220ULL, 0x040fe20000410000ULL, 0x0000005708577220ULL, 0x040fe20000410000ULL,
0x0000005a085a7220ULL, 0x040fe20000410000ULL, 0x0000005b085b7220ULL, 0x040fe20000410000ULL,
0x0000005e085e7220ULL, 0x040fe20000410000ULL, 0x0000005f085f7220ULL, 0x040fe20000410000ULL,
0x0000006208627220ULL, 0x040fe20000410000ULL, 0x0000006308637220ULL, 0x040fe20000410000ULL,
0x0000006608667220ULL, 0x040fe20000410000ULL, 0x0000006708677220ULL, 0x000fe20000410000ULL,
0x000000062a2a7220ULL, 0x088fe20000410000ULL, 0x000000062b2b7220ULL, 0x080fe20000410000ULL,
0x000000062e2e7220ULL, 0x080fe20000410000ULL, 0x000000062f2f7220ULL, 0x080fe20000410000ULL,
0x0000000632327220ULL, 0x080fe20000410000ULL, 0x0000000633337220ULL, 0x080fe20000410000ULL,
0x0000000636367220ULL, 0x080fe20000410000ULL, 0x0000000637377220ULL, 0x080fe20000410000ULL,
0x000000063a3a7220ULL, 0x080fe20000410000ULL, 0x000000063b3b7220ULL, 0x080fe20000410000ULL,
0x000000063e3e7220ULL, 0x080fe20000410000ULL, 0x000000063f3f7220ULL, 0x080fe20000410000ULL,
0x0000000642427220ULL, 0x080fe20000410000ULL, 0x0000000643437220ULL, 0x080fe20000410000ULL,
0x0000000646467220ULL, 0x080fe20000410000ULL, 0x0000000647477220ULL, 0x000fe20000410000ULL,
0x0000000748487220ULL, 0x090fe20000410000ULL, 0x0000000749497220ULL, 0x080fe20000410000ULL,
0x000000074c4c7220ULL, 0x080fe20000410000ULL, 0x000000074d4d7220ULL, 0x080fe20000410000ULL,
0x0000000750507220ULL, 0x080fe20000410000ULL, 0x0000000751517220ULL, 0x080fe20000410000ULL,
0x0000000754547220ULL, 0x080fe20000410000ULL, 0x0000000755557220ULL, 0x080fe20000410000ULL,
0x0000000758587220ULL, 0x080fe20000410000ULL, 0x0000000759597220ULL, 0x080fe20000410000ULL,
0x000000075c5c7220ULL, 0x080fe20000410000ULL, 0x000000075d5d7220ULL, 0x080fe20000410000ULL,
0x0000000760607220ULL, 0x080fe20000410000ULL, 0x0000000761617220ULL, 0x080fe20000410000ULL,
0x0000000764647220ULL, 0x080fe20000410000ULL, 0x0000000765657220ULL, 0x000fc20000410000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x000000282906723eULL, 0x020fc400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000002c2d08723eULL, 0x000fe400000000ffULL, 0x000000303109723eULL, 0x000fe400000000ffULL,
0x00000034350a723eULL, 0x000fc400000000ffULL, 0x00000038390b723eULL, 0x000fe400000000ffULL,
0x0000003c3d0c723eULL, 0x000fe400000000ffULL, 0x00000040410d723eULL, 0x000fe400000000ffULL,
0x00000044450e723eULL, 0x000fe400000000ffULL, 0x00000002ff1e7819ULL, 0x002fe40000011600ULL,
0x0000000800297811ULL, 0x000fc400078ff0ffULL, 0x000000011e027810ULL, 0x040fe20007ffe0ffULL,
0x000000081e197824ULL, 0x040fe200078e00ffULL, 0x000000021e077810ULL, 0x040fe20007ffe0ffULL,
0x000000081e207824ULL, 0x040fe200078e00ffULL, 0x000000041e187810ULL, 0x040fe20007ffe0ffULL,
0x000000081e217824ULL, 0x040fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee202ULL,
0x000000081e247824ULL, 0x040fe200078e00ffULL, 0x000000031e177810ULL, 0x040fe20007ffe0ffULL,
0x000000081e237824ULL, 0x040fe200078e00ffULL, 0x000000051e027810ULL, 0x040fe20007ffe0ffULL,
0x000000081e277824ULL, 0x000fe200078e00ffULL, 0xfffffff8201b7812ULL, 0x000fc400078ee207ULL,
0x000000061e077810ULL, 0x000fe40007ffe0ffULL, 0xfffffff821217812ULL, 0x000fe400078ee218ULL,
0xfffffff8241d7812ULL, 0x000fe200078ee217ULL, 0x000000081e177824ULL, 0x040fe200078e00ffULL,
0xffffffff1e187810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823237812ULL, 0x000fe200078ee202ULL,
0x0000000829027824ULL, 0x000fe200078e00ffULL, 0xfffffff820257812ULL, 0x000fe200078ee207ULL,
0x0000200005077824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee218ULL,
0x0000000400187824ULL, 0x000fe200078e00ffULL, 0xfffffff817177812ULL, 0x000fc400078ee21eULL,
0xfffffff802297812ULL, 0x000fe200078ee229ULL, 0x000010001a027824ULL, 0x000fe200078e0207ULL,
0x0000000c18187812ULL, 0x000fe400078ec0ffULL, 0x00000010002b7811ULL, 0x040fe200078ff0ffULL,
0x0000001017177824ULL, 0x100fe200078e0202ULL, 0x00000018002d7811ULL, 0x000fe200078ff0ffULL,
0x0000001019197824ULL, 0x100fe200078e0202ULL, 0x0000002e2f2e723eULL, 0x000fe200000000ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0202ULL, 0x000000323332723eULL, 0x000fe200000000ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0202ULL, 0x000000363736723eULL, 0x000fe200000000ffULL,
0x0000001021217824ULL, 0x000fe200078e0202ULL, 0x0000003a3b3a723eULL, 0x000fe200000000ffULL,
0x0000000117177824ULL, 0x000fe200078e0218ULL, 0x0000003e3f3e723eULL, 0x000fe200000000ffULL,
0x0000001023237824ULL, 0x100fe200078e0202ULL, 0x000000424342723eULL, 0x000fe200000000ffULL,
0x0000000118197824ULL, 0x040fe200078e0219ULL, 0x0000000617007388ULL, 0x000fe20000000800ULL,
0x000000082b1e7824ULL, 0x000fe200078e00ffULL, 0x000000464746723eULL, 0x000fe200000000ffULL,
0x0000001025257824ULL, 0x100fe200078e0202ULL, 0x0000000819007388ULL, 0x000fe20000000800ULL,
0x00000001181b7824ULL, 0x000fe200078e021bULL, 0xfffffff81e2b7812ULL, 0x000fe200078ee22bULL,
0x0000001027277824ULL, 0x100fe200078e0202ULL, 0x000000484948723eULL, 0x000fe200000000ffULL,
0x00000001181d7824ULL, 0x040fe200078e021dULL, 0x000000091b007388ULL, 0x000fe20000000800ULL,
0x0000001029297824ULL, 0x100fe200078e0202ULL, 0x0000004c4d4c723eULL, 0x000fe200000000ffULL,
0x0000000118217824ULL, 0x040fe200078e0221ULL, 0x0000000a1d007388ULL, 0x000fe20000000800ULL,
0x0000000118237824ULL, 0x040fe200078e0223ULL, 0x000000505150723eULL, 0x000fe200000000ffULL,
0x0000000118257824ULL, 0x040fe200078e0225ULL, 0x0000000b21007388ULL, 0x000fe20000000800ULL,
0x0000000118277824ULL, 0x040fe200078e0227ULL, 0x000000545554723eULL, 0x000fe200000000ffULL,
0x0000000118297824ULL, 0x000fe200078e0229ULL, 0x0000000c23007388ULL, 0x0003e20000000800ULL,
0x000000082d207824ULL, 0x000fe200078e00ffULL, 0x000000585958723eULL, 0x000fe200000000ffULL,
0x000000102b2b7824ULL, 0x000fe200078e0202ULL, 0x0000000d25007388ULL, 0x000fe20000000800ULL,
0x0000005c5d5c723eULL, 0x000fc400000000ffULL, 0xfffffff8202d7812ULL, 0x000fe200078ee22dULL,
0x0000000e27007388ULL, 0x000fe20000000800ULL, 0x00000001182b7824ULL, 0x000fe200078e022bULL,
0x000000606160723eULL, 0x000fe200000000ffULL, 0x00000001030c7824ULL, 0x002fe200078e0200ULL,
0x0000002a29007388ULL, 0x000fe20000000800ULL, 0x000000102d2d7824ULL, 0x000fe200078e0202ULL,
0x000000646564723eULL, 0x000fe200000000ffULL, 0x000000100c067824ULL, 0x000fe200078e0207ULL,
0x0004002e19007388ULL, 0x000fe20000000800ULL, 0x0000004a4b0f723eULL, 0x000fe200000000ffULL,
0x0000000118187824ULL, 0x000fe200078e022dULL, 0x0000004e4f10723eULL, 0x000fe200000000ffULL,
0x000400321b007388ULL, 0x000fe20000000800ULL, 0x000000525311723eULL, 0x000fc400000000ffULL,
0x000000565712723eULL, 0x000fe200000000ffULL, 0x000400361d007388ULL, 0x000fe20000000800ULL,
0x0000005a5b13723eULL, 0x000fe400000000ffULL, 0x0000005e5f14723eULL, 0x000fe200000000ffULL,
0x0004003a21007388ULL, 0x000fe20000000800ULL, 0x000000626315723eULL, 0x000fe400000000ffULL,
0x000000666716723eULL, 0x000fe200000000ffULL, 0x0004003e23007388ULL, 0x000fe80000000800ULL,
0x0004004225007388ULL, 0x000fe80000000800ULL, 0x0004004627007388ULL, 0x000fe80000000800ULL,
0x000000482b007388ULL, 0x000fe80000000800ULL, 0x0008004c19007388ULL, 0x000fe80000000800ULL,
0x000800501b007388ULL, 0x000fe80000000800ULL, 0x000800541d007388ULL, 0x000fe80000000800ULL,
0x0008005821007388ULL, 0x000fe80000000800ULL, 0x0008005c23007388ULL, 0x000fe80000000800ULL,
0x0008006025007388ULL, 0x000fe80000000800ULL, 0x0008006427007388ULL, 0x000fe80000000800ULL,
0x0000000f18007388ULL, 0x0003e80000000800ULL, 0x000c001019007388ULL, 0x000fe80000000800ULL,
0x000c00111b007388ULL, 0x000fe20000000800ULL, 0x00000300ff187624ULL, 0x002fc600078e00ffULL,
0x000c00121d007388ULL, 0x000fe40000000800ULL, 0x000000011800780cULL, 0x000fe40003f05270ULL,
0x000c001321007388ULL, 0x000fe80000000800ULL, 0x000c001423007388ULL, 0x000fe80000000800ULL,
0x000c001525007388ULL, 0x000fe80000000800ULL, 0x000c001627007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000006087984ULL, 0x000e680000000c00ULL,
0x00040000062c7984ULL, 0x000ea80000000c00ULL, 0x0008000006347984ULL, 0x000ee80000000c00ULL,
0x000c000006387984ULL, 0x000f280000000c00ULL, 0x0010000006287984ULL, 0x000ee80000000c00ULL,
0x0014000006307984ULL, 0x000f280000000c00ULL, 0x0018000006107984ULL, 0x000f280000000c00ULL,
0x001c0000063c7984ULL, 0x000f220000000c00ULL, 0x200000ff0b0b7230ULL, 0x002fc40000000000ULL,
0x200000ff0a0a7230ULL, 0x000fe40000000000ULL, 0x200000ff09097230ULL, 0x000fe40000000000ULL,
0x200000ff08087230ULL, 0x000fe40000000000ULL, 0x200000ff2f2f7230ULL, 0x004fe40000000000ULL,
0x200000ff2e2e7230ULL, 0x000fe40000000000ULL, 0x200000ff2d2d7230ULL, 0x000fc40000000000ULL,
0x200000ff2c2c7230ULL, 0x000fe40000000000ULL, 0x200000ff37377230ULL, 0x008fe40000000000ULL,
0x200000ff36367230ULL, 0x000fe40000000000ULL, 0x200000ff35357230ULL, 0x000fe40000000000ULL,
0x200000ff34347230ULL, 0x000fe40000000000ULL, 0x200000ff3b3b7230ULL, 0x010fc40000000000ULL,
0x200000ff3a3a7230ULL, 0x000fe40000000000ULL, 0x200000ff39397230ULL, 0x000fe40000000000ULL,
0x200000ff38387230ULL, 0x000fe40000000000ULL, 0x0000002b0b0b7230ULL, 0x000fe40000000000ULL,
0x0000002a0a0a7230ULL, 0x000fe40000000000ULL, 0x0000002909097230ULL, 0x000fc40000000000ULL,
0x0000002808087230ULL, 0x000fe40000000000ULL, 0x000000332f2f7230ULL, 0x000fe40000000000ULL,
0x000000322e2e7230ULL, 0x000fe20000000000ULL, 0x0000000806007388ULL, 0x000fe20000000c00ULL,
0x000000312d2d7230ULL, 0x000fe40000000000ULL, 0x000000302c2c7230ULL, 0x000fe40000000000ULL,
0x0000001337377230ULL, 0x000fc40000000000ULL, 0x0000001236367230ULL, 0x000fe20000000000ULL,
0x0004002c06007388ULL, 0x000fe20000000c00ULL, 0x0000001135357230ULL, 0x000fe40000000000ULL,
0x0000001034347230ULL, 0x000fe40000000000ULL, 0x0000003f3b3b7230ULL, 0x000fe40000000000ULL,
0x0000003e3a3a7230ULL, 0x000fe20000000000ULL, 0x0008003406007388ULL, 0x000fe20000000c00ULL,
0x0000003d39397230ULL, 0x000fc40000000000ULL, 0x0000003c38387230ULL, 0x000fca0000000000ULL,
0x000c003806007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000039a000008947ULL, 0x000fea0003800000ULL, 0x00000400ff087624ULL, 0x000fe200078e00ffULL,
0x00000000000a7919ULL, 0x000e620000002600ULL, 0x000000400c0f7810ULL, 0x000fc40007ffe0ffULL,
0x00006a0008087a24ULL, 0x000fe200078e02ffULL, 0x00000000000d7919ULL, 0x000e620000002700ULL,
0x000000800c117810ULL, 0x000fe40007ffe0ffULL, 0x00000300080b7a24ULL, 0x040fe200078e02ffULL,
0x0000000f08097811ULL, 0x000fe200078e10ffULL, 0x00000000062c7984ULL, 0x000ea20000000c00ULL,
0x000000c00c137810ULL, 0x000fe40007ffe0ffULL, 0xfffffff009267812ULL, 0x000fe200078ec0ffULL,
0x0004000006307984ULL, 0x000ee80000000c00ULL, 0x000000800b287824ULL, 0x040fe200078e0226ULL,
0x0008000006347984ULL, 0x000ea60000000c00ULL, 0x000000800b0b7824ULL, 0x000fe200078e0228ULL,
0x000c000006387984ULL, 0x0008a80000000c00ULL, 0x0000007f0b087810ULL, 0x000fe20007ffe0ffULL,
0x000004000d0a7a24ULL, 0x002fc600078e020aULL, 0xffffff8008167812ULL, 0x000fe200078ec0ffULL,
0x000003000a0b7a24ULL, 0x000fc600078e02ffULL, 0x00006e0016097a10ULL, 0x000fe20007f1e0ffULL,
0x000000010b047824ULL, 0x000fca00078e0204ULL, 0x0000000904087211ULL, 0x000fe200078268ffULL,
0x00006f00ff097624ULL, 0x000fe200000e06ffULL, 0x000000011aff7812ULL, 0x000fc8000780f897ULL,
0x0000000904097211ULL, 0x000fe400008f6cffULL, 0x00006e0026067a10ULL, 0x010fc60007f3e0ffULL,
0x0000100005087825ULL, 0x000fc800078e0008ULL, 0x00006f00ff177624ULL, 0x000fe400008e06ffULL,
0x000000100c0c7825ULL, 0x000fc800078e0008ULL, 0x000000100f0e7825ULL, 0x000fc800078e0008ULL,
0x0000001011107825ULL, 0x000fc800078e0008ULL, 0x0000001013087825ULL, 0x000fe200078e0008ULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x0000001000127824ULL, 0x00cfe200078e00ffULL,
0x00000001ff147819ULL, 0x000fe20000011600ULL, 0x0000008004137824ULL, 0x000fe200078e00ffULL,
0x00000019ff047819ULL, 0x000fe40000011604ULL, 0x0000007012157812ULL, 0x000fe400078ec0ffULL,
0x0000000c14127812ULL, 0x000fe400078ec0ffULL, 0x00006e0013147a10ULL, 0x000fc40007ebe028ULL,
0x0000000615137210ULL, 0x000fe40007a3e013ULL, 0x0000001412147210ULL, 0x000fe40007c7e015ULL,
0x00006f0004157a10ULL, 0x000fe40002fec4ffULL, 0x0000001312127210ULL, 0x000fe40007fbe0ffULL,
0x00000017ff047210ULL, 0x000fe40000fe4404ULL, 0x00000015ff157210ULL, 0x000fc60001fe84ffULL,
0x000000ffff137224ULL, 0x000fca00028e0604ULL, 0x0000001c12007986ULL, 0x0003e8000c101906ULL,
0x0000001f14007986ULL, 0x0003e4000c101906ULL, 0x000000ff0000720cULL, 0x00cfe20000705670ULL,
0x0000002c0c007986ULL, 0x000fe2000c101d06ULL, 0x0000017000007945ULL, 0x000fe60003800000ULL,
0x000000300e007986ULL, 0x000fe8000c101d06ULL, 0x0000003410007986ULL, 0x000fe8000c101d06ULL,
0x0000003808007986ULL, 0x000fe8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000004ff097424ULL, 0x000fe200078e00ffULL,
0xffffffff180d7810ULL, 0x000fc60007ffe0ffULL, 0x00006e000a087625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x0000000d080879a8ULL, 0x000ea400099ee1c6ULL,
0x0000000d0800720cULL, 0x004fc80003f05270ULL, 0x00000001ff047807ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000004ff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000ff047984ULL, 0x004ea40000000000ULL, 0x000000ff0400720cULL, 0x004fda0003f05270ULL,
0x000034a000008947ULL, 0x000fea0003800000ULL, 0x000000ff9700720cULL, 0x000fda0003f05270ULL,
0x00000a5000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x000001b000008947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe40000011600ULL, 0x000000060b087211ULL, 0x040fe400078038ffULL,
0x0000007004097812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fe400078ec0ffULL,
0x000000170b047211ULL, 0x000fe400000f3cffULL, 0x000000080a087210ULL, 0x000fc8000791e009ULL,
0x00000004ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608047981ULL, 0x000528000c1e1900ULL,
0x00008006080d7981ULL, 0x000522000c1e1900ULL, 0x000000021800780cULL, 0x000fda0003f05270ULL,
0x000000f000008947ULL, 0x000fea0003800000ULL, 0x00010006080f7981ULL, 0x004522000c1e1900ULL,
0x000000041800780cULL, 0x000fda0003f06070ULL, 0x000000c000008947ULL, 0x000fea0003800000ULL,
0x0001800608117981ULL, 0x004522000c1e1900ULL, 0x000000041800780cULL, 0x000fda0003f05270ULL,
0x0000009000008947ULL, 0x000fea0003800000ULL, 0x0002000608137981ULL, 0x006322000c1e1900ULL,
0x000000061800780cULL, 0x000fda0003f06070ULL, 0x0000006000008947ULL, 0x000fea0003800000ULL,
0x0002800608157981ULL, 0x002322000c1e1900ULL, 0x000000061800780cULL, 0x000fda0003f05270ULL,
0x0000003000008947ULL, 0x000fea0003800000ULL, 0x000000081800780cULL, 0x002fe20003f06070ULL,
0x0003000608177981ULL, 0x000318000c1e1900ULL, 0x0003800608190981ULL, 0x000324000c1e1900ULL,
0x0000000718067810ULL, 0x006fc80007ffe0ffULL, 0x00000003ff067819ULL, 0x000fc80000011606ULL,
0x000000ff0600720cULL, 0x000fda0003f05270ULL, 0x000007d000008947ULL, 0x000fea0003800000ULL,
0x000000260b1d7211ULL, 0x000fe200078038ffULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1b7224ULL, 0x010fe200078e0004ULL,
0x00006e001d1d7a10ULL, 0x000fe40007f3e0ffULL, 0x000000ff0b0a7211ULL, 0x000fe400000f3cffULL,
0x000007801d1d7810ULL, 0x000fc80007f5e0ffULL, 0x00006f00ff0a7a10ULL, 0x000fc400017e240aULL,
0x000003000c007a0cULL, 0x000fe20003f26070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x0000000406007c0cULL, 0x000fcc000bf03070ULL, 0x000006d000001947ULL, 0x012fea0003800000ULL,
0x000000080c087810ULL, 0x040fe40007ffe0ffULL, 0x000000010c097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001b04047209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011600ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x000000081d087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e060aULL,
0xfffc8006081b7981ULL, 0x000326000c1e1900ULL, 0x000005f000002947ULL, 0x000fea0003800000ULL,
0x000000090c087810ULL, 0x042fe40007ffe0ffULL, 0x000000020c097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000d04047209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011600ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x000000081d087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e060aULL,
0xfffd0006080d7981ULL, 0x000326000c1e1900ULL, 0x0000051000002947ULL, 0x000fea0003800000ULL,
0x0000000a0c087810ULL, 0x042fe40007ffe0ffULL, 0x000000030c097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000f04047209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011600ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x000000081d087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e060aULL,
0xfffd8006080f7981ULL, 0x000326000c1e1900ULL, 0x0000043000002947ULL, 0x000fea0003800000ULL,
0x0000000b0c087810ULL, 0x042fe40007ffe0ffULL, 0x000000040c097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001104047209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011600ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x000000081d087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e060aULL,
0xfffe000608117981ULL, 0x000326000c1e1900ULL, 0x0000035000002947ULL, 0x000fea0003800000ULL,
0x0000000c0c087810ULL, 0x042fe40007ffe0ffULL, 0x000000050c097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001304047209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011600ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x000000081d087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e060aULL,
0xfffe800608137981ULL, 0x000326000c1e1900ULL, 0x0000027000002947ULL, 0x000fea0003800000ULL,
0x0000000d0c087810ULL, 0x042fe40007ffe0ffULL, 0x000000060c097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001504047209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011600ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x000000081d087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e060aULL,
0xffff000608157981ULL, 0x000326000c1e1900ULL, 0x0000019000002947ULL, 0x000fea0003800000ULL,
0x0000000e0c087810ULL, 0x042fe40007ffe0ffULL, 0x000000070c097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001704047209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011600ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x000000081d087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e060aULL,
0xffff800608177981ULL, 0x000326000c1e1900ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000000f0c087810ULL, 0x002fe40007ffe0ffULL, 0x0000001904047209ULL, 0x000fe40007810000ULL,
0x0000030008007a0cULL, 0x000fda0003f26070ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011600ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x000000081d087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e060aULL,
0x0000000608197981ULL, 0x000326000c1e1900ULL, 0x000004001d1d7810ULL, 0x000fe40007f3e0ffULL,
0x000000080c0c7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e060aULL,
0xfffff8b000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x0000001000067824ULL, 0x004fe200078e00ffULL, 0x00000001ff087819ULL, 0x002fc80000011600ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c08097812ULL, 0x000fca00078ec0ffULL,
0x0000000106097824ULL, 0x000fca00078e0209ULL, 0x0000000409007388ULL, 0x0103e40000000800ULL,
0x000000070000780cULL, 0x000fe20003f04070ULL, 0x000000011a1b7824ULL, 0x000fe200078e020bULL,
0x00006e0016087a10ULL, 0x000fe20007f3e0ffULL, 0x0000100005047824ULL, 0x002fe200078e00ffULL,
0x00000002ff067819ULL, 0x000fe20000011697ULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011600ULL, 0x00006f00ff097624ULL, 0x000fe200008e06ffULL,
0x0000000106067812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000021a0f8824ULL, 0x000fe200078e0205ULL, 0x0000002000157810ULL, 0x040fe20007ffe0ffULL,
0x000020001b0c7825ULL, 0x000fe200078e0008ULL, 0x0000004000177810ULL, 0x040fe20007ffe0ffULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000006000197810ULL, 0x000fe20007ffe0ffULL,
0x000000020f2b8824ULL, 0x100fe200078e0206ULL, 0x000000040c0c7210ULL, 0x000fe20007f3e0ffULL,
0x00000400970f7824ULL, 0x000fe200078e00ffULL, 0x00000080001d7810ULL, 0x000fe20007ffe0ffULL,
0x000000021a298824ULL, 0x000fe200078e0205ULL, 0x000000a0001f7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x000010000f0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000229298824ULL, 0x000fe200078e0206ULL, 0x000000c000217810ULL, 0x000fe20007ffe0ffULL,
0x000040001a067824ULL, 0x000fe200078e0207ULL, 0x000000e000257810ULL, 0x000fe20007ffe0ffULL,
0x0000001015147825ULL, 0x000fe200078e000cULL, 0x0000007011117812ULL, 0x000fe200078ec0ffULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00000001060f7824ULL, 0x000fe200078e020fULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x0000001017167825ULL, 0x100fe200078e000cULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x0000001019187825ULL, 0x100fe200078e000cULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x000000101d1c7825ULL, 0x100fe200078e000cULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000101f1e7825ULL, 0x100fe200078e000cULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000001021207825ULL, 0x100fe200078e000cULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000001025247825ULL, 0x000fe200078e000cULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fc4000001ff00ULL, 0x0000001000127825ULL, 0x000fe200078e000cULL,
0x00006e00280c7a10ULL, 0x000fe40007f3e0ffULL, 0x00006e00260d7a10ULL, 0x000fe20007f5e0ffULL,
0x00000001110a7824ULL, 0x000fe400078e0210ULL, 0x0000001000237824ULL, 0x000fe400078e020fULL,
0x00006f00ff0e7624ULL, 0x000fe200008e06ffULL, 0x0000000c1b268211ULL, 0x040fe200078238ffULL,
0x000000000a0a7984ULL, 0x000e620000000800ULL, 0x00006f00ff0f7624ULL, 0x000fe200010e06ffULL,
0x0000000d1b288211ULL, 0x040fe200078438ffULL, 0x000000ffff547224ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000012237faeULL, 0x0005e2000b901c46ULL,
0x0000000e1b278211ULL, 0x000fc400008f3cffULL, 0x000003001a007a0cULL, 0x000fe20003f26070ULL,
0x0038000014237faeULL, 0x0007e4000b901c46ULL, 0x0000001000268825ULL, 0x000fe400078e0026ULL,
0x0058000016237faeULL, 0x0009e8000b901c46ULL, 0x0078000018237faeULL, 0x0009e2000b901c46ULL,
0x0000000000127805ULL, 0x004fc6000001ff00ULL, 0x009800001c237faeULL, 0x0005e2000b901c46ULL,
0x0000000000147805ULL, 0x008fe2000001ff00ULL, 0x0000000829178824ULL, 0x110fe200078e0200ULL,
0x0000000f1b298211ULL, 0x000fe200010f3cffULL, 0x000000082b1b8824ULL, 0x000fe200078e0200ULL,
0x00b800001e237faeULL, 0x0007e2000b901c46ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000858017178811ULL, 0x000fe200078e20ffULL, 0x0000001000288825ULL, 0x000fe200078e0028ULL,
0x000081801b1b8811ULL, 0x000fe200078e20ffULL, 0x00d8000020237faeULL, 0x0009e2000b901c46ULL,
0x00000000001c7805ULL, 0x004fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fc4000001ff00ULL,
0x00f8000024237faeULL, 0x0005e2000b901c46ULL, 0x00000000001e7805ULL, 0x008fc6000001ff00ULL,
0x0000000026178faeULL, 0x0007e8000b901c46ULL, 0x00000000281b8faeULL, 0x0003e2000b901c46ULL,
0x0000000000207805ULL, 0x010fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff237224ULL, 0x004fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x008fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x002fe2000001ff00ULL, 0x000000ffff1b7224ULL, 0x000fe200078e00ffULL,
0x0000131000001947ULL, 0x000fea0003800000ULL, 0x000000ffff127224ULL, 0x000fe400078e00ffULL,
0x000000ffff557224ULL, 0x000fca00078e001aULL, 0x0000000255567810ULL, 0x000fc80007ffe0ffULL,
0x0000030056007a0cULL, 0x000fda0003f06070ULL, 0x0000035000000947ULL, 0x000fea0003800000ULL,
0x00000001ff577819ULL, 0x100fe20000011656ULL, 0x000000010b697824ULL, 0x000fe200078e0256ULL,
0x000000070000780cULL, 0x040fe40003f44070ULL, 0x0000000157587812ULL, 0x000fe200078ec0ffULL,
0x0000200069107825ULL, 0x000fe200078e0008ULL, 0x00000020005b7810ULL, 0x040fe40007ffe0ffULL,
0x00000040005d7810ULL, 0x000fe20007ffe0ffULL, 0x0000080056577824ULL, 0x000fe200078e00ffULL,
0x0000000410107210ULL, 0x000fc40007f1e0ffULL, 0x00000060005f7810ULL, 0x000fe40007ffe0ffULL,
0x0000100057577812ULL, 0x000fe200078ec0ffULL, 0x000000021a6ba824ULL, 0x100fe200078e0205ULL,
0x0000008000617810ULL, 0x000fe20007ffe0ffULL, 0x000000021a59a824ULL, 0x000fe200078e0205ULL,
0x000000a000637810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x000000c000657810ULL, 0x000fe20007ffe0ffULL, 0x0000000106577824ULL, 0x000fe200078e0257ULL,
0x000000e000677810ULL, 0x040fe20007ffe0ffULL, 0x000000026b6ba824ULL, 0x100fe200078e0258ULL,
0x0000000c6966a211ULL, 0x000fe200078038ffULL, 0x00000002596da824ULL, 0x000fe200078e0258ULL,
0x0000000d6968a211ULL, 0x000fe200078238ffULL, 0x0000001000577824ULL, 0x000fc400078e0257ULL,
0x0000001000587825ULL, 0x000fc800078e0010ULL, 0x000000105b5a7825ULL, 0x100fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000058577faeULL, 0x0003e6000b901c46ULL,
0x000000105d5c7825ULL, 0x100fe200078e0010ULL, 0x003800005a577faeULL, 0x0005e6000b901c46ULL,
0x000000105f5e7825ULL, 0x100fe200078e0010ULL, 0x005800005c577faeULL, 0x0007e6000b901c46ULL,
0x0000001061607825ULL, 0x100fe200078e0010ULL, 0x007800005e577faeULL, 0x0007e6000b901c46ULL,
0x0000001063627825ULL, 0x100fe200078e0010ULL, 0x0098000060577faeULL, 0x0007e6000b901c46ULL,
0x0000001065647825ULL, 0x100fe200078e0010ULL, 0x00b8000062577faeULL, 0x0007e6000b901c46ULL,
0x0000001067107825ULL, 0x000fe200078e0010ULL, 0x0000000e6967a211ULL, 0x040fe200000f3cffULL,
0x00d8000064577faeULL, 0x0007e2000b901c46ULL, 0x0000000f6969a211ULL, 0x000fe200008f3cffULL,
0x000000086b6ba824ULL, 0x000fc400078e0200ULL, 0x000000086d6da824ULL, 0x000fe200078e0200ULL,
0x00f8000010577faeULL, 0x0007e2000b901c46ULL, 0x000000100066a825ULL, 0x040fe200078e0066ULL,
0x000085806b6ba811ULL, 0x000fe400078e20ffULL, 0x000081806d5ba811ULL, 0x004fe200078e20ffULL,
0x000000100058a825ULL, 0x002fe400078e0068ULL, 0x00000000666bafaeULL, 0x0007e8000b901c46ULL,
0x00000000585bafaeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff587224ULL, 0x008fe200078e0055ULL, 0x00000001ff577819ULL, 0x100fe20000011600ULL,
0x000000021a557824ULL, 0x000fe200078e0205ULL, 0x00000002ff687819ULL, 0x000fe20000011600ULL,
0x0000004058107824ULL, 0x000fc400078e00ffULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x00000002685a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000868607824ULL, 0x000fe200078e00ffULL,
0x0000008010107812ULL, 0x000fe200078ec0ffULL, 0x00000008686a7824ULL, 0x040fe200078e00ffULL,
0x0000007011117812ULL, 0x000fe200078ec0ffULL, 0x00000008685f7824ULL, 0x040fe200078e00ffULL,
0x00000004685b7810ULL, 0x040fe20007ffe0ffULL, 0x0000010055557824ULL, 0x000fe200078e0010ULL,
0x0000000c57107812ULL, 0x000fe200078ec0ffULL, 0x00000008686c7824ULL, 0x040fe200078e00ffULL,
0x0000000868727810ULL, 0x040fe20007ffe0ffULL, 0x0000000868617824ULL, 0x000fe200078e00ffULL,
0x0000005510577210ULL, 0x000fe20007ffe011ULL, 0x0000000868707824ULL, 0x040fe200078e00ffULL,
0x0000000168557810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0081800057597984ULL, 0x000e620000000800ULL, 0xfffffff860607812ULL, 0x000fe400078ee255ULL,
0x0000000368557810ULL, 0x000fe20007ffe0ffULL, 0x00858000575d7984ULL, 0x0004e20000000800ULL,
0xfffffff85f627812ULL, 0x000fe200078ee25aULL, 0x00000004005a7824ULL, 0x000fe200078e00ffULL,
0xfffffff86a6a7812ULL, 0x000fe200078ee255ULL, 0x0000080058557824ULL, 0x000fe200078e00ffULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee25bULL, 0x00000008685b7824ULL, 0x000fe200078e00ffULL,
0x0000000c5a637812ULL, 0x000fe200078ec0ffULL, 0x0000000872577824ULL, 0x004fe200078e00ffULL,
0x0000100055557812ULL, 0x000fc400078ec0ffULL, 0x0000001068747810ULL, 0x000fe40007ffe0ffULL,
0xfffffff85b5a7812ULL, 0x000fe400078ee268ULL, 0x0000018006557810ULL, 0x000fe40007ffe055ULL,
0x0000001868767810ULL, 0x000fe40007ffe0ffULL, 0xfffffff857587812ULL, 0x000fe200078ee272ULL,
0x000000105a577824ULL, 0x100fe200078e0255ULL, 0x00000005685e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000876657824ULL, 0x000fe200078e00ffULL, 0x00000006685f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001058587824ULL, 0x000fe200078e0255ULL, 0xfffffff8616e7812ULL, 0x000fe200078ee25eULL,
0x0000000163577824ULL, 0x000fe200078e0257ULL, 0xfffffff870707812ULL, 0x000fc400078ee25fULL,
0xffffffff685f7810ULL, 0x000fc60007ffe0ffULL, 0x0000000057577984ULL, 0x000ea20000000800ULL,
0x000000590a597221ULL, 0x002fc80000010100ULL, 0x3fb8aa3b595b7820ULL, 0x000fe20000410000ULL,
0x0000000874597824ULL, 0x000fc600078e00ffULL, 0x0000005b005c7308ULL, 0x0002e40000000800ULL,
0xfffffff8595a7812ULL, 0x000fe200078ee274ULL, 0x0000000163597824ULL, 0x000fe200078e0258ULL,
0xfffffff865587812ULL, 0x000fc600078ee276ULL, 0x000000105a5a7824ULL, 0x100fe200078e0255ULL,
0x0000000059647984ULL, 0x0008a20000000800ULL, 0x0000001058587824ULL, 0x100fe400078e0255ULL,
0x00000001635b7824ULL, 0x042fe400078e025aULL, 0x00000001635e7824ULL, 0x040fe400078e0258ULL,
0x0000001060587824ULL, 0x100fe200078e0255ULL, 0x000000005b657984ULL, 0x000fe20000000800ULL,
0x0000001062597824ULL, 0x010fe200078e0255ULL, 0x0000005d5c697220ULL, 0x008fe20000410000ULL,
0x0000000163587824ULL, 0x000fe200078e0258ULL, 0x000000005e667984ULL, 0x000fe20000000800ULL,
0x0000000868627824ULL, 0x000fe200078e00ffULL, 0x0000005469547221ULL, 0x000fe20000010000ULL,
0x00000001635a7824ULL, 0x040fe200078e0259ULL, 0x00001f68696b7589ULL, 0x0002e200000e0000ULL,
0x000000106a5c7824ULL, 0x000fe200078e0255ULL, 0xfffffff862627812ULL, 0x000fe200078ee25fULL,
0x000000106c5d7824ULL, 0x000fe200078e0255ULL, 0x0000000058597984ULL, 0x000fe20000000800ULL,
0x00000001635c7824ULL, 0x000fc400078e025cULL, 0x00000001635d7824ULL, 0x040fe200078e025dULL,
0x000000005a5b7984ULL, 0x000fe20000000800ULL, 0x000000106e5f7824ULL, 0x100fe400078e0255ULL,
0x0000001070607824ULL, 0x100fe200078e0255ULL, 0x000000005d5e7984ULL, 0x000fe20000000800ULL,
0x0000001062627824ULL, 0x000fe400078e0255ULL, 0x00000001635f7824ULL, 0x040fe200078e025fULL,
0x000000005c557984ULL, 0x000fe20000000800ULL, 0x0000000163617824ULL, 0x000fc400078e0260ULL,
0x0000000163627824ULL, 0x000fe200078e0262ULL, 0x00001f72696c7589ULL, 0x000f2200000e0000ULL,
0x20000057ff637230ULL, 0x104fe40000004100ULL, 0x30000057ff687230ULL, 0x002fe20000004100ULL,
0x00001f76696e7589ULL, 0x000e6200000e0000ULL, 0x20000064ff677230ULL, 0x000fe20000004100ULL,
0x0000006b63527223ULL, 0x088fe40000010052ULL, 0x00001f74696d7589ULL, 0x0004e200000e0000ULL,
0x0000006b68517223ULL, 0x000fc60000010051ULL, 0x000000005f607984ULL, 0x000ee20000000800ULL,
0x30000065ff687230ULL, 0x000fc60000004100ULL, 0x0000000061577984ULL, 0x000ee20000000800ULL,
0x30000066ff6a7230ULL, 0x100fe40000004100ULL, 0x20000065ff697230ULL, 0x004fe20000004100ULL,
0x0000000062637984ULL, 0x000ea20000000800ULL, 0x20000066ff657230ULL, 0x000fe20000004100ULL,
0x0000006c67507223ULL, 0x010fe20000010050ULL, 0x30000064ff677230ULL, 0x000fe40000004100ULL,
0x0004000058647984ULL, 0x000f220000000800ULL, 0x0000006e65307223ULL, 0x002fe20000010030ULL,
0x20000059ff667230ULL, 0x100fe20000004100ULL, 0x0000006c67327223ULL, 0x000fe20000010032ULL,
0x000400005a657984ULL, 0x000e620000000800ULL, 0x0000006d68317223ULL, 0x008fe20000010031ULL,
0x30000059ff687230ULL, 0x000fe20000004100ULL, 0x0000006b662f7223ULL, 0x000fe2000001002fULL,
0x000400005c597984ULL, 0x000ee20000000800ULL, 0x2000005bff677230ULL, 0x000fe20000004100ULL,
0x0000006d694e7223ULL, 0x000fe2000001004eULL, 0x0000006b684d7223ULL, 0x080fe2000001004dULL,
0x000400005d667984ULL, 0x000ee20000000800ULL, 0x20000055ff697230ULL, 0x100fe20000004100ULL,
0x0000006b674c7223ULL, 0x080fe2000001004cULL, 0x30000055ff687230ULL, 0x000fe20000004100ULL,
0x000400005f677984ULL, 0x000ee20000000800ULL, 0x2000005eff557230ULL, 0x100fe20000004100ULL,
0x0000006b69487223ULL, 0x080fe20000010048ULL, 0x3000005bff5b7230ULL, 0x000fe20000004100ULL,
0x0000006b68457223ULL, 0x080fe20000010045ULL, 0x3000005eff5e7230ULL, 0x000fe20000004100ULL,
0x0000006b55447223ULL, 0x080fe20000010044ULL, 0x0000006e6a477223ULL, 0x000fe20000010047ULL,
0x0004000061557984ULL, 0x000ee20000000800ULL, 0x0000006b5b427223ULL, 0x080fe20000010042ULL,
0x20000060ff5b7230ULL, 0x100fe20000004100ULL, 0x0000006b5e417223ULL, 0x000fe20000010041ULL,
0x30000060ff607230ULL, 0x000fc40000004100ULL, 0x20000057ff697230ULL, 0x100fe20000004100ULL,
0x0000006b5b207223ULL, 0x080fe20000010020ULL, 0x30000057ff5e7230ULL, 0x000fe20000004100ULL,
0x00080000585b7984ULL, 0x000fe20000000800ULL, 0x30000063ff687230ULL, 0x104fe20000004100ULL,
0x0000006b693c7223ULL, 0x080fe2000001003cULL, 0x0000006b603d7223ULL, 0x080fe2000001003dULL,
0x0004000062577984ULL, 0x000ea20000000800ULL, 0x0000006b5e397223ULL, 0x080fe20000010039ULL,
0x20000063ff5e7230ULL, 0x000fe20000004100ULL, 0x0000006b68357223ULL, 0x080fe20000010035ULL,
0x20000064ff637230ULL, 0x110fe20000004100ULL, 0x000c000058607984ULL, 0x000fe20000000800ULL,
0x30000064ff697230ULL, 0x000fe20000004100ULL, 0x0000006b5e4b7223ULL, 0x000fe2000001004bULL,
0x20000065ff647230ULL, 0x102fe20000004100ULL, 0x000800005a5e7984ULL, 0x000e620000000800ULL,
0x30000065ff657230ULL, 0x000fe20000004100ULL, 0x0000006c694a7223ULL, 0x080fe2000001004aULL,
0x20000059ff697230ULL, 0x108fe20000004100ULL, 0x0000006c641b7223ULL, 0x080fe2000001001bULL,
0x30000059ff647230ULL, 0x000fe20000004100ULL, 0x000800005c587984ULL, 0x000ee20000000800ULL,
0x20000066ff597230ULL, 0x100fe20000004100ULL, 0x0000006c65367223ULL, 0x080fe20000010036ULL,
0x0000006c63347223ULL, 0x080fe20000010034ULL, 0x0000006c64277223ULL, 0x080fe20000010027ULL,
0x20000067ff657230ULL, 0x100fe20000004100ULL, 0x0000006c59407223ULL, 0x080fe20000010040ULL,
0x000c00005c647984ULL, 0x000f220000000800ULL, 0x30000067ff687230ULL, 0x000fe20000004100ULL,
0x0000006c69467223ULL, 0x080fe20000010046ULL, 0x0000006c653e7223ULL, 0x080fe2000001003eULL,
0x000800005d597984ULL, 0x000f220000000800ULL, 0x20000055ff677230ULL, 0x000fe20000004100ULL,
0x0000006c683b7223ULL, 0x080fe2000001003bULL, 0x30000066ff667230ULL, 0x000fe20000004100ULL,
0x000c00005a637984ULL, 0x0005240000000800ULL, 0x0000006c67267223ULL, 0x000fc40000010026ULL,
0x000c00005d657984ULL, 0x0003220000000800ULL, 0x0000006c66257223ULL, 0x080fe20000010025ULL,
0x30000055ff5a7230ULL, 0x004fe40000004100ULL, 0x000c00005f5c7984ULL, 0x000ea20000000800ULL,
0x20000057ff697230ULL, 0x100fe40000004100ULL, 0x30000057ff667230ULL, 0x000fe20000004100ULL,
0x000800005f557984ULL, 0x0002a20000000800ULL, 0x0000006c5a377223ULL, 0x080fe20000010037ULL,
0x2000005bff5a7230ULL, 0x100fe20000004100ULL, 0x0000006c691c7223ULL, 0x080fe2000001001cULL,
0x0008000061577984ULL, 0x000ea20000000800ULL, 0x3000005bff5d7230ULL, 0x002fe20000004100ULL,
0x0000006c66337223ULL, 0x000fe20000010033ULL, 0x0000006d5a177223ULL, 0x080fe20000010017ULL,
0x000c0000615b7984ULL, 0x0002a20000000800ULL, 0x3000005eff5f7230ULL, 0x000fe20000004100ULL,
0x0000006d5d2e7223ULL, 0x080fe2000001002eULL, 0x20000060ff667230ULL, 0x100fe20000004100ULL,
0x00080000625a7984ULL, 0x000ea20000000800ULL, 0x30000060ff677230ULL, 0x000fe20000004100ULL,
0x0000006d5f387223ULL, 0x080fe20000010038ULL, 0x2000005eff607230ULL, 0x000fe20000004100ULL,
0x000c0000625d7984ULL, 0x000ea20000000800ULL, 0x20000058ff5e7230ULL, 0x108fe20000004100ULL,
0x0000006e662d7223ULL, 0x080fe2000001002dULL, 0x30000058ff5f7230ULL, 0x000fe20000004100ULL,
0x0000006d602b7223ULL, 0x080fe2000001002bULL, 0x20000064ff607230ULL, 0x110fe20000004100ULL,
0x0000006d5e3f7223ULL, 0x080fe2000001003fULL, 0x20000059ff587230ULL, 0x100fe20000004100ULL,
0x0000006e672c7223ULL, 0x080fe2000001002cULL, 0x30000059ff5e7230ULL, 0x000fe20000004100ULL,
0x0000006e60217223ULL, 0x080fe20000010021ULL, 0x20000063ff667230ULL, 0x100fe20000004100ULL,
0x0000006d58237223ULL, 0x080fe20000010023ULL, 0x30000063ff637230ULL, 0x000fe20000004100ULL,
0x0000006d5e1f7223ULL, 0x080fe2000001001fULL, 0x20000065ff607230ULL, 0x100fe20000004100ULL,
0x0000006e66297223ULL, 0x080fe20000010029ULL, 0x30000064ff617230ULL, 0x002fe20000004100ULL,
0x0000006e63287223ULL, 0x080fe20000010028ULL, 0x30000065ff657230ULL, 0x000fe20000004100ULL,
0x0000006e60497223ULL, 0x080fe20000010049ULL, 0x2000005cff5e7230ULL, 0x104fe20000004100ULL,
0x0000006d5f2a7223ULL, 0x080fe2000001002aULL, 0x3000005cff607230ULL, 0x000fe20000004100ULL,
0x0000006e61247223ULL, 0x080fe20000010024ULL, 0x20000055ff597230ULL, 0x100fe20000004100ULL,
0x0000006e653a7223ULL, 0x080fe2000001003aULL, 0x30000055ff587230ULL, 0x000fe20000004100ULL,
0x0000006e5e4f7223ULL, 0x080fe2000001004fULL, 0x000000ffff557224ULL, 0x000fe200078e0056ULL,
0x0000006d591e7223ULL, 0x080fe2000001001eULL, 0x30000057ff5c7230ULL, 0x100fe20000004100ULL,
0x0000006d581d7223ULL, 0x080fe2000001001dULL, 0x20000057ff587230ULL, 0x000fe20000004100ULL,
0x0000030055007a0cULL, 0x000fe20003f06070ULL, 0x2000005bff577230ULL, 0x100fe20000004100ULL,
0x0000006e60437223ULL, 0x080fe20000010043ULL, 0x3000005bff567230ULL, 0x000fe20000004100ULL,
0x0000006d58137223ULL, 0x080fe20000010013ULL, 0x0000006d5c197223ULL, 0x000fe20000010019ULL,
0x0000006e57187223ULL, 0x080fe20000010018ULL, 0x2000005aff577230ULL, 0x000fe20000004100ULL,
0x0000006e56537223ULL, 0x000fe20000010053ULL, 0x2000005dff597230ULL, 0x000fc40000004100ULL,
0x3000005aff5a7230ULL, 0x000fe20000004100ULL, 0x0000006d57167223ULL, 0x080fe20000010016ULL,
0x3000005dff5d7230ULL, 0x000fe20000004100ULL, 0x0000006e59147223ULL, 0x080fe40000010014ULL,
0x0000006d5a157223ULL, 0x000fe40000010015ULL, 0x0000006e5d127223ULL, 0x000fe20000010012ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffed1000007947ULL, 0x000fea000383ffffULL,
0x000000ff0500720cULL, 0x000fe20003f05270ULL, 0x0000018000007945ULL, 0x000fd80003800000ULL,
0x000000801a098824ULL, 0x000fc800078e0211ULL, 0x0000000110098824ULL, 0x000fe400078e0209ULL,
0x0000000111107824ULL, 0x000fc600078e0210ULL, 0x0089805409008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0089800010007984ULL, 0x000e680000000800ULL,
0x008a0000100b7984ULL, 0x000ea20000000800ULL, 0x00000000ff007221ULL, 0x002fc80000010000ULL,
0x0000000b00007221ULL, 0x004fca0000010000ULL, 0x0180000000047810ULL, 0x000fc80007ffe0ffULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e0000ULL, 0x0000d57000087802ULL, 0x000fc40000000f00ULL,
0x0000c45000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff047224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000097308ULL, 0x000e640000001000ULL,
0xbf80000000047423ULL, 0x002fc80000000009ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000409047223ULL, 0x000fc40000000009ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff557819ULL, 0x004fc40000011600ULL, 0x0000000800577811ULL, 0x040fe400078ff0ffULL,
0x0000001000597811ULL, 0x040fe200078ff0ffULL, 0x00001f5504067589ULL, 0x002e6200000e0000ULL,
0x00000018005b7811ULL, 0x000fe200078ff0ffULL, 0x00000008555d7824ULL, 0x040fe200078e00ffULL,
0x0000000155107810ULL, 0x000fe20007ffe0ffULL, 0x00001f57040b7589ULL, 0x000ea800000e0000ULL,
0x00001f59040a7589ULL, 0x000ee800000e0000ULL, 0x00001f5b040e7589ULL, 0x0008a200000e0000ULL,
0x0000005206527220ULL, 0x042fe20000410000ULL, 0x0000005106517220ULL, 0x040fe20000410000ULL,
0x0000002f062f7220ULL, 0x040fe20000410000ULL, 0x0000004d06087220ULL, 0x040fe20000410000ULL,
0x0000004c064c7220ULL, 0x040fe20000410000ULL, 0x0000004206097220ULL, 0x040fe20000410000ULL,
0x0000004806487220ULL, 0x040fe20000410000ULL, 0x0000004506457220ULL, 0x040fe20000410000ULL,
0x0000004406447220ULL, 0x040fe20000410000ULL, 0x0000004106417220ULL, 0x040fe20000410000ULL,
0x0000002006207220ULL, 0x040fe20000410000ULL, 0x0000003d063d7220ULL, 0x040fe20000410000ULL,
0x0000003c063c7220ULL, 0x040fe20000410000ULL, 0x0000003906397220ULL, 0x040fe20000410000ULL,
0x0000004b064b7220ULL, 0x040fe20000410000ULL, 0x0000003506067220ULL, 0x000fe20000410000ULL,
0x000000320b0d7220ULL, 0x004fe20000410000ULL, 0x0000000855357824ULL, 0x040fe200078e00ffULL,
0x0000000355327810ULL, 0x040fe20007ffe0ffULL, 0x0000004e0a4e7220ULL, 0x048fe20000410000ULL,
0x000000310a317220ULL, 0x040fe20000410000ULL, 0x000000170a177220ULL, 0x040fe20000410000ULL,
0x0000002e0a2e7220ULL, 0x040fe20000410000ULL, 0x0000002b0a2b7220ULL, 0x040fe20000410000ULL,
0x000000380a387220ULL, 0x040fe20000410000ULL, 0x0000003f0a3f7220ULL, 0x040fe20000410000ULL,
0x0000002a0a2a7220ULL, 0x040fe20000410000ULL, 0x000000230a237220ULL, 0x040fe20000410000ULL,
0x0000001f0a047220ULL, 0x050fe20000410000ULL, 0x0000001e0a1e7220ULL, 0x040fe20000410000ULL,
0x0000001d0a1d7220ULL, 0x040fe20000410000ULL, 0x000000130a137220ULL, 0x040fe20000410000ULL,
0x000000190a0c7220ULL, 0x040fe20000410000ULL, 0x000000160a167220ULL, 0x040fe20000410000ULL,
0x000000150a157220ULL, 0x000fe20000410000ULL, 0x000000430e0a7220ULL, 0x040fe20000410000ULL,
0x00000008551f7824ULL, 0x040fe200078e00ffULL, 0x000000300e307220ULL, 0x040fe20000410000ULL,
0x0000000855427824ULL, 0x000fe200078e00ffULL, 0x000000470e477220ULL, 0x040fe20000410000ULL,
0x0000002d0e2d7220ULL, 0x040fe20000410000ULL, 0x0000002c0e2c7220ULL, 0x040fe20000410000ULL,
0x000000290e297220ULL, 0x040fe20000410000ULL, 0x000000280e287220ULL, 0x040fe20000410000ULL,
0x000000210e217220ULL, 0x040fe20000410000ULL, 0x000000240e247220ULL, 0x040fe20000410000ULL,
0x000000490e497220ULL, 0x040fe20000410000ULL, 0x0000003a0e3a7220ULL, 0x040fe20000410000ULL,
0x0000004f0e4f7220ULL, 0x040fe20000410000ULL, 0x000000180e187220ULL, 0x040fe20000410000ULL,
0x000000530e537220ULL, 0x040fe20000410000ULL, 0x000000140e147220ULL, 0x040fe20000410000ULL,
0x000000120e117220ULL, 0x000fe20000410000ULL, 0xfffffff835357812ULL, 0x000fe200078ee232ULL,
0x0000000855437824ULL, 0x040fe200078e00ffULL, 0x0000000255197810ULL, 0x040fe20007ffe0ffULL,
0x0000000855327824ULL, 0x040fe200078e00ffULL, 0x00000004550e7810ULL, 0x000fe20007ffe0ffULL,
0x000000500b507220ULL, 0x040fe20000410000ULL, 0x000000340b347220ULL, 0x040fe20000410000ULL,
0x0000004a0b0f7220ULL, 0x040fe20000410000ULL, 0x0000001b0b1b7220ULL, 0x040fe20000410000ULL,
0x000000360b367220ULL, 0x040fe20000410000ULL, 0x000000460b467220ULL, 0x040fe20000410000ULL,
0x000000270b277220ULL, 0x040fe20000410000ULL, 0x000000400b407220ULL, 0x040fe20000410000ULL,
0x000000250b257220ULL, 0x040fe20000410000ULL, 0x0000003e0b3e7220ULL, 0x040fe20000410000ULL,
0x0000003b0b3b7220ULL, 0x040fe20000410000ULL, 0x000000260b267220ULL, 0x040fe20000410000ULL,
0x000000370b377220ULL, 0x040fe20000410000ULL, 0x0000001c0b1c7220ULL, 0x040fe20000410000ULL,
0x000000330b0b7220ULL, 0x000fe20000410000ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee210ULL,
0x00000008554d7824ULL, 0x000fe200078e00ffULL, 0xfffffff842337812ULL, 0x000fe200078ee219ULL,
0x0000001035357824ULL, 0x000fe200078e0202ULL, 0xfffffff843437812ULL, 0x000fe200078ee20eULL,
0x000000101f1f7824ULL, 0x100fe200078e0202ULL, 0x0000000555107810ULL, 0x000fe20007ffe0ffULL,
0x0000001033337824ULL, 0x100fe200078e0202ULL, 0x0000000655127810ULL, 0x000fe20007ffe0ffULL,
0x0000001043437824ULL, 0x000fe200078e0202ULL, 0xffffffff550e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff832197812ULL, 0x000fe200078ee255ULL, 0x0000000855557824ULL, 0x000fe200078e00ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee210ULL, 0x0000000857107824ULL, 0x000fe200078e00ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee212ULL, 0x0000000859127824ULL, 0x000fe200078e00ffULL,
0xfffffff855557812ULL, 0x000fe200078ee20eULL, 0x000000085b327824ULL, 0x000fe200078e00ffULL,
0xfffffff810577812ULL, 0x000fe200078ee257ULL, 0x00000004000e7824ULL, 0x000fe200078e00ffULL,
0xfffffff812597812ULL, 0x000fe200078ee259ULL, 0x0000001019197824ULL, 0x100fe200078e0202ULL,
0xfffffff8325b7812ULL, 0x000fe200078ee25bULL, 0x000000104d4d7824ULL, 0x100fe200078e0202ULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x000000105d5d7824ULL, 0x100fe200078e0202ULL,
0x000000525151723eULL, 0x000fe200000000ffULL, 0x0000001055557824ULL, 0x100fe200078e0202ULL,
0x0000002f0808723eULL, 0x000fe200000000ffULL, 0x0000001057577824ULL, 0x100fe200078e0202ULL,
0x0000004c0909723eULL, 0x000fe200000000ffULL, 0x0000001059597824ULL, 0x100fe200078e0202ULL,
0x000000484545723eULL, 0x000fe200000000ffULL, 0x000000105b5b7824ULL, 0x000fe200078e0202ULL,
0x000000444141723eULL, 0x000fe200000000ffULL, 0x0000000119027824ULL, 0x000fe200078e020eULL,
0x000000203d20723eULL, 0x000fe200000000ffULL, 0x000000010e1f7824ULL, 0x040fe200078e021fULL,
0x0000003c3939723eULL, 0x000fe200000000ffULL, 0x000000010e107824ULL, 0x040fe200078e0233ULL,
0x0000005102007388ULL, 0x0003e20000000800ULL, 0x000000010e127824ULL, 0x040fe200078e0235ULL,
0x000000340f0f723eULL, 0x000fe200000000ffULL, 0x000000010e437824ULL, 0x040fe200078e0243ULL,
0x000000081f007388ULL, 0x000fe20000000800ULL, 0x000000010e4d7824ULL, 0x000fe200078e024dULL,
0x0000004b0606723eULL, 0x000fe200000000ffULL, 0x000000010e5d7824ULL, 0x040fe200078e025dULL,
0x000000141111723eULL, 0x000fe200000000ffULL, 0x000000010e347824ULL, 0x040fe200078e0255ULL,
0x0000000910007388ULL, 0x000fe20000000800ULL, 0x000000500d0d723eULL, 0x000fe200000000ffULL,
0x000000010e147824ULL, 0x000fe200078e0257ULL, 0x0000001b361b723eULL, 0x000fe200000000ffULL,
0x0000004512007388ULL, 0x000fe20000000800ULL, 0x000000462727723eULL, 0x000fe200000000ffULL,
0x000000010e5b7824ULL, 0x000fe200078e025bULL, 0x000000402525723eULL, 0x000fe200000000ffULL,
0x0000004143007388ULL, 0x000fe20000000800ULL, 0x0000003e3b3b723eULL, 0x000fe200000000ffULL,
0x0000000103027824ULL, 0x002fe200078e0200ULL, 0x000000263726723eULL, 0x000fe200000000ffULL,
0x000000204d007388ULL, 0x000fe20000000800ULL, 0x0000001c0b0b723eULL, 0x000fe200000000ffULL,
0x0000001002027824ULL, 0x000fe200078e0207ULL, 0x000000161515723eULL, 0x000fe200000000ffULL,
0x000000395d007388ULL, 0x000fe20000000800ULL, 0x0000004e3131723eULL, 0x000fe200000000ffULL,
0x000000010e167824ULL, 0x000fe200078e0259ULL, 0x000000172e17723eULL, 0x000fe200000000ffULL,
0x0000000634007388ULL, 0x000fe20000000800ULL, 0x0000002b382b723eULL, 0x000fc400000000ffULL,
0x0000003f2a2a723eULL, 0x000fe200000000ffULL, 0x0000000d14007388ULL, 0x000fe20000000800ULL,
0x000000230404723eULL, 0x000fe400000000ffULL, 0x0000001e1d1d723eULL, 0x000fe200000000ffULL,
0x0004000f1f007388ULL, 0x000fe20000000800ULL, 0x000000130c0c723eULL, 0x000fe400000000ffULL,
0x000000304730723eULL, 0x000fe200000000ffULL, 0x0004001b10007388ULL, 0x000fe20000000800ULL,
0x0000002d2c2c723eULL, 0x000fc400000000ffULL, 0x000000292828723eULL, 0x000fe200000000ffULL,
0x0004002712007388ULL, 0x000fe20000000800ULL, 0x000000212421723eULL, 0x000fe400000000ffULL,
0x000000493a3a723eULL, 0x000fe200000000ffULL, 0x0004002543007388ULL, 0x000fe20000000800ULL,
0x0000004f0a0a723eULL, 0x000fe400000000ffULL, 0x000000185318723eULL, 0x000fe200000000ffULL,
0x0004003b4d007388ULL, 0x000fe80000000800ULL, 0x000400265d007388ULL, 0x000fe80000000800ULL,
0x0004000b34007388ULL, 0x000fe80000000800ULL, 0x0000003116007388ULL, 0x000fe80000000800ULL,
0x000800171f007388ULL, 0x000fe80000000800ULL, 0x0008002b10007388ULL, 0x000fe80000000800ULL,
0x0008002a12007388ULL, 0x000fe80000000800ULL, 0x0008000443007388ULL, 0x000fe80000000800ULL,
0x0008001d4d007388ULL, 0x000fe80000000800ULL, 0x0008000c5d007388ULL, 0x000fe80000000800ULL,
0x0008001534007388ULL, 0x000fe80000000800ULL, 0x000000305b007388ULL, 0x000fe80000000800ULL,
0x000c002c1f007388ULL, 0x000fe80000000800ULL, 0x000c002810007388ULL, 0x000fe80000000800ULL,
0x000c002112007388ULL, 0x000fe80000000800ULL, 0x000c003a43007388ULL, 0x000fe80000000800ULL,
0x000c000a4d007388ULL, 0x000fe80000000800ULL, 0x000c00185d007388ULL, 0x000fe80000000800ULL,
0x000c001134007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000020c7984ULL, 0x000e680000000c00ULL, 0x00040000021c7984ULL, 0x000ea80000000c00ULL,
0x0008000002287984ULL, 0x000ee80000000c00ULL, 0x000c000002087984ULL, 0x000f280000000c00ULL,
0x0010000002147984ULL, 0x000ee80000000c00ULL, 0x0014000002247984ULL, 0x000f280000000c00ULL,
0x00180000022c7984ULL, 0x000f280000000c00ULL, 0x001c000002307984ULL, 0x000f220000000c00ULL,
0x200000ff0f0f7230ULL, 0x002fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x004fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fc40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff2b2b7230ULL, 0x008fe40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fe40000000000ULL,
0x200000ff29297230ULL, 0x000fe40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x200000ff0b0b7230ULL, 0x010fc40000000000ULL, 0x200000ff0a0a7230ULL, 0x000fe40000000000ULL,
0x200000ff09097230ULL, 0x000fe40000000000ULL, 0x200000ff08087230ULL, 0x000fe40000000000ULL,
0x000000170f0f7230ULL, 0x000fe40000000000ULL, 0x000000160e0e7230ULL, 0x000fe40000000000ULL,
0x000000150d0d7230ULL, 0x000fc40000000000ULL, 0x000000140c0c7230ULL, 0x000fe40000000000ULL,
0x000000271f1f7230ULL, 0x000fe40000000000ULL, 0x000000261e1e7230ULL, 0x000fe20000000000ULL,
0x0000000c02007388ULL, 0x000fe20000000c00ULL, 0x000000251d1d7230ULL, 0x000fe40000000000ULL,
0x000000241c1c7230ULL, 0x000fe40000000000ULL, 0x0000002f2b2b7230ULL, 0x000fc40000000000ULL,
0x0000002e2a2a7230ULL, 0x000fe20000000000ULL, 0x0004001c02007388ULL, 0x000fe20000000c00ULL,
0x0000002d29297230ULL, 0x000fe40000000000ULL, 0x0000002c28287230ULL, 0x000fe40000000000ULL,
0x000000330b0b7230ULL, 0x000fe40000000000ULL, 0x000000320a0a7230ULL, 0x000fe20000000000ULL,
0x0008002802007388ULL, 0x000fe20000000c00ULL, 0x0000003109097230ULL, 0x000fc40000000000ULL,
0x0000003008087230ULL, 0x000fca0000000000ULL, 0x000c000802007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff1a00720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff0b7819ULL, 0x000fc80000011600ULL,
0x0000007d0b00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000047b06ULL, 0x000ea20000209000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00005a00ff0e7a12ULL, 0x000fe400078e33ffULL, 0x0000002000117810ULL, 0x040fe40007ffe0ffULL,
0x00000007000c7812ULL, 0x000fe400078ec0ffULL, 0x0000000400047308ULL, 0x004ea40000001000ULL,
0x0ffffffe04067810ULL, 0x004fcc0007ffe0ffULL, 0x0000000600037305ULL, 0x000ea4000021f000ULL,
0x000000ffff097224ULL, 0x004fc800078e0a03ULL, 0x00005a0009097a24ULL, 0x000fc800078e02ffULL,
0x00000009030f7227ULL, 0x000fc800078e0002ULL, 0x0000000196027824ULL, 0x000fe400078e020bULL,
0x000000010b0b7824ULL, 0x000fe400078e0200ULL, 0x000000020f037227ULL, 0x000fc600078e00ffULL,
0x000000070b0b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a03ULL,
0x00005a0009047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f06070ULL,
0x80005a0004040a10ULL, 0x000fe40007ffe0ffULL, 0x0000000103030810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f26070ULL, 0x0ffffff80b047812ULL, 0x000fe400078ef800ULL,
0x00005a00ff007a0cULL, 0x000fc60003f05070ULL, 0x0000001004047824ULL, 0x000fca00078e0207ULL,
0x0000000004087984ULL, 0x0004e20000000c00ULL, 0x0000000103031810ULL, 0x000fc80007ffe0ffULL,
0x000000030e037207ULL, 0x000fe40004000000ULL, 0x00000003ff047819ULL, 0x004fc60000011611ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a03ULL, 0x0000590003037a24ULL, 0x000fe400078e0222ULL,
0x00005a000d027a24ULL, 0x000fe400078e0202ULL, 0x00000008050d7824ULL, 0x000fe400078e020cULL,
0x00005a0003037a24ULL, 0x000fca00078e0202ULL, 0x000000037e037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00005e0003027a11ULL, 0x000fc800078240ffULL,
0x00005f0003037a11ULL, 0x000fe400008f4406ULL, 0x0000007d0400720cULL, 0x000fc60003f26070ULL,
0x000000100d027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0085ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000196027824ULL, 0x104fe200078e0204ULL,
0x0000004000137810ULL, 0x002fe20007ffe0ffULL, 0x0000000111047824ULL, 0x000fe400078e0204ULL,
0x000000020f037227ULL, 0x000fc600078e00ffULL, 0x0000000704047812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fc600078e0a03ULL, 0x0ffffff804047812ULL, 0x000fe200078ef811ULL,
0x00005a0009067a24ULL, 0x000fc800078e0202ULL, 0x0000001004047824ULL, 0x000fe200078e0207ULL,
0x00005a0006007a0cULL, 0x000fc80003f26070ULL, 0x0000000004087984ULL, 0x0002a40000000c00ULL,
0x00000003ff047819ULL, 0x002fce0000011613ULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f46070ULL,
0x0000000711067812ULL, 0x000fd600078ec0ffULL, 0x0000000103032810ULL, 0x000fc80007ffe0ffULL,
0x000000030e037207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e0222ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x00000008050d7824ULL, 0x000fe400078e0206ULL, 0x00005a0003037a24ULL, 0x000fca00078e0202ULL,
0x000000037e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078240ffULL, 0x00005f0003037a11ULL, 0x000fe400008f440cULL,
0x0000007d0400720cULL, 0x000fc60003f26070ULL, 0x000000100d027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000196027824ULL, 0x102fe200078e0204ULL, 0x0000006000117810ULL, 0x000fe20007ffe0ffULL,
0x0000000113047824ULL, 0x000fe400078e0204ULL, 0x000000020f037227ULL, 0x000fc600078e00ffULL,
0x0000000704047812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fc600078e0a03ULL,
0x0ffffff804047812ULL, 0x000fe200078ef813ULL, 0x00005a0009067a24ULL, 0x000fc800078e0202ULL,
0x0000001004047824ULL, 0x000fe200078e0207ULL, 0x00005a0006007a0cULL, 0x000fc80003f26070ULL,
0x0000000004087984ULL, 0x0002a40000000c00ULL, 0x00000003ff047819ULL, 0x002fce0000011611ULL,
0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL, 0x0000000103031810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f46070ULL, 0x0000000713067812ULL, 0x000fd600078ec0ffULL,
0x0000000103032810ULL, 0x000fc80007ffe0ffULL, 0x000000030e037207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a03ULL, 0x0000590003037a24ULL, 0x000fe400078e0222ULL,
0x00005a000d027a24ULL, 0x000fe400078e0202ULL, 0x00000008050d7824ULL, 0x000fe400078e0206ULL,
0x00005a0003037a24ULL, 0x000fca00078e0202ULL, 0x000000037e037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0003027a11ULL, 0x000fc800078240ffULL,
0x00005f0003037a11ULL, 0x000fe400008f440cULL, 0x0000007d0400720cULL, 0x000fc60003f26070ULL,
0x000000100d027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000196027824ULL, 0x102fe200078e0204ULL,
0x0000008000137810ULL, 0x000fe20007ffe0ffULL, 0x0000000111047824ULL, 0x000fe400078e0204ULL,
0x000000020f037227ULL, 0x000fc600078e00ffULL, 0x0000000704047812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fc600078e0a03ULL, 0x0ffffff804047812ULL, 0x000fe200078ef811ULL,
0x00005a0009067a24ULL, 0x000fc800078e0202ULL, 0x0000001004047824ULL, 0x000fe200078e0207ULL,
0x00005a0006007a0cULL, 0x000fc80003f26070ULL, 0x0000000004087984ULL, 0x0002a40000000c00ULL,
0x00000003ff047819ULL, 0x002fce0000011613ULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f46070ULL,
0x0000000711067812ULL, 0x000fd600078ec0ffULL, 0x0000000103032810ULL, 0x000fc80007ffe0ffULL,
0x000000030e037207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e0222ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x00000008050d7824ULL, 0x000fe400078e0206ULL, 0x00005a0003037a24ULL, 0x000fca00078e0202ULL,
0x000000037e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078240ffULL, 0x00005f0003037a11ULL, 0x000fe400008f440cULL,
0x0000007d0400720cULL, 0x000fc60003f26070ULL, 0x000000100d027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000196027824ULL, 0x102fe200078e0204ULL, 0x000000a000117810ULL, 0x000fe20007ffe0ffULL,
0x0000000113047824ULL, 0x000fe400078e0204ULL, 0x000000020f037227ULL, 0x000fc600078e00ffULL,
0x0000000704047812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fc600078e0a03ULL,
0x0ffffff804047812ULL, 0x000fe200078ef813ULL, 0x00005a0009067a24ULL, 0x000fc800078e0202ULL,
0x0000001004047824ULL, 0x000fe200078e0207ULL, 0x00005a0006007a0cULL, 0x000fc80003f26070ULL,
0x0000000004087984ULL, 0x0002a40000000c00ULL, 0x00000003ff047819ULL, 0x002fce0000011611ULL,
0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL, 0x0000000103031810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f46070ULL, 0x0000000713067812ULL, 0x000fd600078ec0ffULL,
0x0000000103032810ULL, 0x000fc80007ffe0ffULL, 0x000000030e037207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a03ULL, 0x0000590003037a24ULL, 0x000fe400078e0222ULL,
0x00005a000d027a24ULL, 0x000fe400078e0202ULL, 0x00000008050d7824ULL, 0x000fe400078e0206ULL,
0x00005a0003037a24ULL, 0x000fca00078e0202ULL, 0x000000037e037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0003027a11ULL, 0x000fc800078240ffULL,
0x00005f0003037a11ULL, 0x000fe400008f440cULL, 0x0000007d0400720cULL, 0x000fc60003f26070ULL,
0x000000100d027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000196027824ULL, 0x102fe200078e0204ULL,
0x000000c000137810ULL, 0x000fe20007ffe0ffULL, 0x0000000111047824ULL, 0x000fe400078e0204ULL,
0x000000020f037227ULL, 0x000fc600078e00ffULL, 0x0000000704047812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fc600078e0a03ULL, 0x0ffffff804047812ULL, 0x000fe200078ef811ULL,
0x00005a0009067a24ULL, 0x000fc800078e0202ULL, 0x0000001004047824ULL, 0x000fe200078e0207ULL,
0x00005a0006007a0cULL, 0x000fc80003f26070ULL, 0x0000000004087984ULL, 0x0002a40000000c00ULL,
0x00000003ff047819ULL, 0x002fce0000011613ULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f46070ULL,
0x0000000711067812ULL, 0x000fd600078ec0ffULL, 0x0000000103032810ULL, 0x000fc80007ffe0ffULL,
0x000000030e037207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e0222ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x00000008050d7824ULL, 0x000fe400078e0206ULL, 0x00005a0003037a24ULL, 0x000fca00078e0202ULL,
0x000000037e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078240ffULL, 0x00005f0003037a11ULL, 0x000fe400008f440cULL,
0x0000007d0400720cULL, 0x000fc60003f26070ULL, 0x000000100d027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000196027824ULL, 0x102fe200078e0204ULL, 0x000000e000117810ULL, 0x000fe20007ffe0ffULL,
0x0000000113047824ULL, 0x040fe200078e0204ULL, 0x0000000713007812ULL, 0x000fe200078ec0ffULL,
0x000000020f037227ULL, 0x000fc600078e00ffULL, 0x0000000704047812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fc600078e0a03ULL, 0x0ffffff804047812ULL, 0x000fe200078ef813ULL,
0x00005a0009067a24ULL, 0x000fc800078e0202ULL, 0x0000001004047824ULL, 0x000fe200078e0207ULL,
0x00005a0006007a0cULL, 0x000fc80003f26070ULL, 0x0000000004087984ULL, 0x0002a40000000c00ULL,
0x00000003ff047819ULL, 0x002fce0000011611ULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103031810ULL, 0x000fe20007ffe0ffULL, 0x0000000196967824ULL, 0x000fe200078e0204ULL,
0x00005a0006007a0cULL, 0x000fda0003f46070ULL, 0x0000000103032810ULL, 0x000fc80007ffe0ffULL,
0x000000030e037207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e0222ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x00000008050d7824ULL, 0x000fe400078e0200ULL, 0x00005a0003037a24ULL, 0x000fca00078e0202ULL,
0x000000037e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078240ffULL, 0x00005f0003037a11ULL, 0x000fe400008f4406ULL,
0x0000007d0400720cULL, 0x000fc60003f26070ULL, 0x000000100d027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000960f007227ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x002fe400078e0a00ULL,
0x0000000111047824ULL, 0x000fe400078e0204ULL, 0x00005a0003027a24ULL, 0x000fc600078e0296ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x00005a0002007a0cULL, 0x000fe40003f26070ULL,
0xfffffff804047812ULL, 0x000fca00078ef811ULL, 0x0000001004047824ULL, 0x000fca00078e0207ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000100001810ULL, 0x000fe40007ffe0ffULL, 0x00005a0002007a0cULL, 0x000fda0003f46070ULL,
0x0000000100002810ULL, 0x000fc80007ffe0ffULL, 0x000000000e037207ULL, 0x000fe40004000000ULL,
0x0000000711007812ULL, 0x000fc600078ec0ffULL, 0x000000ffff077224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e0222ULL, 0x00005a0007967a24ULL, 0x000fe400078e0296ULL,
0x0000000805057824ULL, 0x000fe400078e0200ULL, 0x00005a0003037a24ULL, 0x000fca00078e0296ULL,
0x000000037e037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078040ffULL, 0x00005f0003037a11ULL, 0x000fca00000f4406ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000195087810ULL, 0x000fe20007ffe0ffULL, 0x00005800ff037624ULL, 0x000fe200078e00ffULL,
0x01660000ff047f8cULL, 0x000ea2000c80043fULL, 0x000000020e097824ULL, 0x000fe200078e00ffULL,
0x000000230800720cULL, 0x000fe20003f06070ULL, 0x00000040979d7824ULL, 0x000fe200078e00ffULL,
0x0000001f03037810ULL, 0x000fe20007ffe0ffULL, 0x0000590009227a24ULL, 0x000fe400078e0222ULL,
0x0000010095077824ULL, 0x002fe200078e029dULL, 0x00000005ff277819ULL, 0x000fc60000011603ULL,
0x00006800221d7a24ULL, 0x000fc800078e0207ULL, 0x0000060000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1a7819ULL, 0x000fe40000011600ULL, 0x0000000794037217ULL, 0x000fe40007800000ULL,
0x000000181a1e7810ULL, 0x040fe20007ffe0ffULL, 0x000000011d087824ULL, 0x000fe200078e021aULL,
0x000000201a167810ULL, 0x040fe20007ffe0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a07ULL,
0x000000081a147810ULL, 0x000fe20007ffe0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x000000101a1c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000077211ULL, 0x000fe200078fe8ffULL,
0x000000011d0e7824ULL, 0x040fe200078e021eULL, 0x0000003008107812ULL, 0x000fe200078ef806ULL,
0x000000011d087824ULL, 0x000fe200078e0216ULL, 0x0000000307077812ULL, 0x000fe200078ec0ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000640010107a10ULL, 0x000fe40007f1e0ffULL,
0x0000200097177811ULL, 0x000fe200078e68ffULL, 0x000000011d0a7824ULL, 0x000fe200078e0214ULL,
0x0000650009117a10ULL, 0x000fe200007fe4ffULL, 0x000000011d0c7824ULL, 0x000fe200078e021cULL,
0x000000300e0e7812ULL, 0x000fe200078ef806ULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0ffffffc07007812ULL, 0x000fc400078ef800ULL, 0x000064000e0e7a10ULL, 0x000fe20007f5e0ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000003008127812ULL, 0x100fe400078ef806ULL,
0x000000281a187810ULL, 0x000fe20007ffe0ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x000000300a0a7812ULL, 0x100fe400078ef806ULL, 0x000065000f0f7a10ULL, 0x000fe200017fe4ffULL,
0x0000000414087824ULL, 0x000fe200078e00ffULL, 0x000000300c0c7812ULL, 0x000fe200078ef806ULL,
0x0000001000197824ULL, 0x000fe200078e0217ULL, 0x000064000a0a7a10ULL, 0x000fe20007f1e0ffULL,
0x000000011d007824ULL, 0x000fe200078e0218ULL, 0xfffffffc08087812ULL, 0x000fc400078ee207ULL,
0x0000640012127a10ULL, 0x000fe40007f5e0ffULL, 0x000064000c0c7a10ULL, 0x000fe20007f3e0ffULL,
0x00000010081b7824ULL, 0x000fe200078e0217ULL, 0x000065000b0b7a10ULL, 0x000fe400007fe4ffULL,
0x0000650009137a10ULL, 0x000fe200017fe4ffULL, 0x0000010000087825ULL, 0x000fe200078e00ffULL,
0x000065000d0d7a10ULL, 0x000fe40000ffe4ffULL, 0x000000031a00720cULL, 0x000fc40003f06070ULL,
0x000000031400720cULL, 0x080fe40003f26070ULL, 0x000000301a007810ULL, 0x000fe40007ffe0ffULL,
0x0000003008147812ULL, 0x000fe400078ef806ULL, 0x000000381a1a7810ULL, 0x000fe20007ffe0ffULL,
0x000000011d087824ULL, 0x000fe200078e0200ULL, 0x0000640014147a10ULL, 0x000fe40007fde0ffULL,
0x000000031c00720cULL, 0x080fe20003fa6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010197faeULL, 0x0003e2000c101c46ULL, 0x0000650009157a10ULL, 0x000fe200037fe4ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x000000031600720cULL, 0x080fe20003f66070ULL,
0x000000000a1b7faeULL, 0x0007e2000c901c46ULL, 0x000000031800720cULL, 0x080fe20003f46070ULL,
0x000000041c1c7824ULL, 0x000fe200078e00ffULL, 0x0000003008087812ULL, 0x000fe200078ef806ULL,
0x0000000416167824ULL, 0x000fe200078e00ffULL, 0x000000031e00720cULL, 0x080fe20003f86070ULL,
0x0000000418187824ULL, 0x000fe200078e00ffULL, 0x000000030000720cULL, 0x080fe20003f26070ULL,
0x000000041e107824ULL, 0x002fe200078e00ffULL, 0x0000640008087a10ULL, 0x000fe20007fde0ffULL,
0x00000004001e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1c007812ULL, 0x100fe200078ee207ULL,
0x000000011d0a7824ULL, 0x008fe200078e021aULL, 0xfffffffc10107812ULL, 0x100fe200078ee207ULL,
0x000000041a207824ULL, 0x040fe200078e00ffULL, 0x000000031a00720cULL, 0x000fe20003f06070ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc16167812ULL, 0x000fc400078ee207ULL,
0xfffffffc18187812ULL, 0x000fe200078ee207ULL, 0x0000001000037824ULL, 0x100fe200078e0217ULL,
0x000000300a067812ULL, 0x000fe200078ef806ULL, 0x0000001010117824ULL, 0x000fe200078e0217ULL,
0xfffffffc1e1a7812ULL, 0x000fe200078ee207ULL, 0x0000001016197824ULL, 0x000fe200078e0217ULL,
0xfffffffc201c7812ULL, 0x000fe200078ee207ULL, 0x00000010181b7824ULL, 0x100fe200078e0217ULL,
0x0000650009097a10ULL, 0x000fe200037fe4ffULL, 0x000000101a1d7824ULL, 0x100fe200078e0217ULL,
0x0000640006067a10ULL, 0x000fe20007fde0ffULL, 0x000000101c177824ULL, 0x000fe200078e0217ULL,
0x000000000c037faeULL, 0x0003e4000e901c46ULL, 0x000065000b077a10ULL, 0x000fc400037fe4ffULL,
0x000000000e117faeULL, 0x0003e8000e101c46ULL, 0x0000000012197faeULL, 0x0003e8000d901c46ULL,
0x00000000141b7faeULL, 0x0003e8000d101c46ULL, 0x00000000081d7faeULL, 0x0003e8000c901c46ULL,
0x0000000006177faeULL, 0x0003e2000c101c46ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x00000000000a7211ULL, 0x040fe400078fe8ffULL, 0x00000008000c7811ULL, 0x000fc400078ff0ffULL,
0x00000010000e7811ULL, 0x040fe400078ff0ffULL, 0x0000001800107811ULL, 0x000fe200078ff0ffULL,
0x000000040c127824ULL, 0x000fe200078e00ffULL, 0x0000002000037811ULL, 0x000fe200078ff0ffULL,
0x000000040e147824ULL, 0x000fe200078e00ffULL, 0x0000002800077811ULL, 0x040fe400078ff0ffULL,
0x0000003000097811ULL, 0x040fe200078ff0ffULL, 0x0000000403167824ULL, 0x000fe200078e00ffULL,
0x00000038000b7811ULL, 0x000fe200078ff0ffULL, 0x00000004071e7824ULL, 0x000fe200078e00ffULL,
0x000000030a0d7812ULL, 0x000fe200078ec0ffULL, 0x000000011d0a7824ULL, 0x040fe200078e020cULL,
0x0000001d00087211ULL, 0x000fe200078ff0ffULL, 0x000000011d0c7824ULL, 0x040fe200078e020eULL,
0xfffffffc16137812ULL, 0x000fe200078ee20dULL, 0x000000011d0e7824ULL, 0x000fe200078e0210ULL,
0x0000200097257811ULL, 0x000fe200078e68ffULL, 0x0000000410107824ULL, 0x000fc400078e00ffULL,
0x0000000409207824ULL, 0x000fe400078e00ffULL, 0x000000040b247824ULL, 0x000fe200078e00ffULL,
0xfffffffc10107812ULL, 0x000fe200078ee20dULL, 0x000000011d187824ULL, 0x040fe200078e0207ULL,
0xfffffffc14077812ULL, 0x000fe200078ee20dULL, 0x000000011d117824ULL, 0x000fe200078e0203ULL,
0x0ffffffc0d037812ULL, 0x000fe200078ef800ULL, 0x000000011d1a7824ULL, 0x040fe200078e0209ULL,
0xfffffffc1e147812ULL, 0x000fe200078ee20dULL, 0x000000011d1c7824ULL, 0x000fe200078e020bULL,
0xfffffffc12007812ULL, 0x100fe200078ee20dULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0xfffffffc20157812ULL, 0x000fc400078ee20dULL, 0xfffffffc24167812ULL, 0x000fe200078ee20dULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000003008127812ULL, 0x000fc600078ef806ULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000640012127a10ULL, 0x000fc60007f1e0ffULL,
0x00000010141f7824ULL, 0x100fe200078e0225ULL, 0x000000300a147812ULL, 0x100fe200078ef806ULL,
0x0000001003297824ULL, 0x000fe200078e0225ULL, 0x000000300c177812ULL, 0x000fe200078ef806ULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000640014147a10ULL, 0x000fc60007f3e0ffULL,
0x0000001000037824ULL, 0x100fe200078e0225ULL, 0x000000300e0e7812ULL, 0x100fe200078ef806ULL,
0x0000001007197824ULL, 0x100fe400078e0225ULL, 0x00000010101b7824ULL, 0x100fe400078e0225ULL,
0x00000010131d7824ULL, 0x100fe200078e0225ULL, 0x0000650009137a10ULL, 0x000fe200007fe4ffULL,
0x0000001015217824ULL, 0x100fe200078e0225ULL, 0x000065000b157a10ULL, 0x000fe20000ffe4ffULL,
0x0000001016257824ULL, 0x000fe200078e0225ULL, 0x0000640017167a10ULL, 0x000fe20007f5e0ffULL,
0x0000010011087825ULL, 0x000fe200078e00ffULL, 0x000064000e0e7a10ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012297faeULL, 0x0003e2000b901c46ULL,
0x000065000d177a10ULL, 0x000fe200017fe4ffULL, 0x00000100180a7825ULL, 0x000fe200078e00ffULL,
0x0000003008077812ULL, 0x100fe200078ef806ULL, 0x0000000014037faeULL, 0x0003e2000b901c46ULL,
0x000065000f0f7a10ULL, 0x000fe200007fe4ffULL, 0x000001001a0c7825ULL, 0x000fe200078e00ffULL,
0x000000300a087812ULL, 0x100fe200078ef806ULL, 0x0000000016197faeULL, 0x0003e4000b901c46ULL,
0x000001001c107825ULL, 0x000fe200078e00ffULL, 0x000000300c0a7812ULL, 0x000fe200078ef806ULL,
0x000000000e1b7faeULL, 0x0003e2000b901c46ULL, 0x0000640008087a10ULL, 0x000fc40007f3e0ffULL,
0x00000030100c7812ULL, 0x000fe400078ef806ULL, 0x0000640007067a10ULL, 0x000fe40007f1e0ffULL,
0x000064000a0a7a10ULL, 0x000fe40007f5e0ffULL, 0x000064000c0c7a10ULL, 0x000fe40007f7e0ffULL,
0x0000650009077a10ULL, 0x000fe400007fe4ffULL, 0x000065000b097a10ULL, 0x000fc40000ffe4ffULL,
0x000065000d0b7a10ULL, 0x000fe200017fe4ffULL, 0x00000000061d7faeULL, 0x0003e2000b901c46ULL,
0x00006500110d7a10ULL, 0x000fc60001ffe4ffULL, 0x00000000081f7faeULL, 0x0003e8000b901c46ULL,
0x000000000a217faeULL, 0x0003e8000b901c46ULL, 0x000000000c257faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x002fc40000015200ULL,
0x01660400ff037984ULL, 0x000e620000000800ULL, 0x0000002702987224ULL, 0x000fe400078e02ffULL,
0x0000000194217824ULL, 0x000fc400078e0a9aULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x8000000003ff7812ULL, 0x006fe20007804805ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000620098987625ULL, 0x000fe200078e0099ULL,
0x00000008ff217819ULL, 0x000fe20000011621ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000027805ULL, 0x000fcc0000015200ULL, 0x0000000206097210ULL, 0x000fca0007f1e1ffULL,
0x0000000103037824ULL, 0x000fe200000e0e07ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011403ULL,
0x0000000900007211ULL, 0x000fca00078110ffULL, 0x000000ffff037224ULL, 0x000fca00000e0603ULL,
0x0000000200007819ULL, 0x000fc80000001203ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01660400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000239500720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000207919ULL, 0x000e620000000000ULL, 0x00000002271f7824ULL, 0x000fe200078e00ffULL,
0x00016688979b7811ULL, 0x040fe200078e18ffULL, 0x00000020979c7824ULL, 0x000fe200078e00ffULL,
0xffffffff9a1e7810ULL, 0x040fe40007ffe0ffULL, 0x000000099a1d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000195007810ULL, 0x040fe20007ffe0ffULL, 0x00000100951c7824ULL, 0x008fe200078e029dULL,
0x0000000000007946ULL, 0x000fe40003800000ULL, 0x000000230000720cULL, 0x000fe20003f06070ULL,
0x00006800221b7a24ULL, 0x000fd800078e021cULL, 0x0000064000008947ULL, 0x004fea0003800000ULL,
0x00000002ff107819ULL, 0x002fe20000011620ULL, 0x00000010201a7824ULL, 0x000fc600078e00ffULL,
0x0000000810137810ULL, 0x040fe20007ffe0ffULL, 0x0000000110027824ULL, 0x100fe200078e021bULL,
0x000000301a1a7812ULL, 0x000fe400078ec0ffULL, 0x0000001810167810ULL, 0x000fe20007ffe0ffULL,
0x0000010002027825ULL, 0x000fe200078e00ffULL, 0x000000401a117812ULL, 0x000fe400078efcffULL,
0x0000001010147810ULL, 0x000fe20007ffe0ffULL, 0x0000000113047824ULL, 0x100fe200078e021bULL,
0x00000011020c7212ULL, 0x000fe200078efcffULL, 0x0000000116087824ULL, 0x000fe200078e021bULL,
0x0000002010187810ULL, 0x000fe20007ffe0ffULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x000064000c0c7a10ULL, 0x000fc40007f3e0ffULL, 0x0000002810197810ULL, 0x000fe20007ffe0ffULL,
0x000000011b067824ULL, 0x000fe200078e0214ULL, 0x00000011040e7212ULL, 0x080fe200078efcffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x00006500030d7a10ULL, 0x000fe40000ffe4ffULL,
0x000064000e0e7a10ULL, 0x000fe20007f3e0ffULL, 0x00000001180a7824ULL, 0x000fe200078e021bULL,
0x0000001c94037217ULL, 0x000fe20007800000ULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000001108087212ULL, 0x000fc400078efcffULL, 0x00006500050f7a10ULL, 0x000fe20000ffe4ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000001106067212ULL, 0x080fe400078efcffULL,
0x0000640008087a10ULL, 0x000fe20007f3e0ffULL, 0x0000000103007824ULL, 0x000fe200078e0a1cULL,
0x0000002020047211ULL, 0x000fe200078fe8ffULL, 0x0000000413157824ULL, 0x000fe200078e00ffULL,
0x000000110a0a7212ULL, 0x000fe200078efcffULL, 0x0000000414177824ULL, 0x000fe200078e00ffULL,
0x0000640006067a10ULL, 0x000fc40007f5e0ffULL, 0x0000650009097a10ULL, 0x000fe40000ffe4ffULL,
0x0ffffffc20037812ULL, 0x000fe400078ec0ffULL, 0x0000000304127812ULL, 0x000fe200078ec0ffULL,
0x0000000119047824ULL, 0x000fe200078e021bULL, 0x000000001000720cULL, 0x000fe40003f26070ULL,
0x000064000a0a7a10ULL, 0x000fe20007f7e0ffULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x0000650007077a10ULL, 0x000fc400017fe4ffULL, 0x000000001300720cULL, 0x080fe40003f46070ULL,
0x0000300097027811ULL, 0x000fe400078e68ffULL, 0x0000000312137212ULL, 0x000fe400078efcffULL,
0x000065000b0b7a10ULL, 0x000fe40001ffe4ffULL, 0x000000001400720cULL, 0x000fe20003f66070ULL,
0x0000001013137824ULL, 0x000fe200078e0202ULL, 0xfffffffc15157812ULL, 0x000fc400078ee212ULL,
0xfffffffc17177812ULL, 0x000fe400078ee212ULL, 0x0000003010147810ULL, 0x000fe20007ffe0ffULL,
0x0000001015157824ULL, 0x100fe200078e0202ULL, 0x0000001104047212ULL, 0x000fe200078efcffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c137faeULL, 0x0003e2000c901c46ULL,
0x0000001017177824ULL, 0x000fe200078e0202ULL, 0x0000003810107810ULL, 0x000fe40007ffe0ffULL,
0x000000000e157faeULL, 0x0005e2000d101c46ULL, 0x000000001600720cULL, 0x000fc40003fa6070ULL,
0x000000001800720cULL, 0x080fe20003f86070ULL, 0x0000000006177faeULL, 0x0007e2000d901c46ULL,
0x000000001900720cULL, 0x080fe40003f66070ULL, 0x000000001400720cULL, 0x080fe20003f46070ULL,
0x0000000418137824ULL, 0x002fe200078e00ffULL, 0x00006400040c7a10ULL, 0x000fe20007fde0ffULL,
0x0000000114047824ULL, 0x000fe200078e021bULL, 0x000000001000720cULL, 0x000fe20003f26070ULL,
0x00000004160f7824ULL, 0x004fe200078e00ffULL, 0x00006500050d7a10ULL, 0x000fe200037fe4ffULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0xfffffffc13137812ULL, 0x000fc400078ee212ULL,
0xfffffffc0f0f7812ULL, 0x100fe200078ee212ULL, 0x0000000110067824ULL, 0x008fe200078e021bULL,
0x0000001104047212ULL, 0x080fe200078efcffULL, 0x0000000419157824ULL, 0x000fe400078e00ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000640004047a10ULL, 0x000fe40007fde0ffULL,
0xfffffffc15157812ULL, 0x000fe200078ee212ULL, 0x0000000414177824ULL, 0x000fe200078e00ffULL,
0x0000001106067212ULL, 0x000fe200078efcffULL, 0x0000000410197824ULL, 0x000fe200078e00ffULL,
0x0000650005057a10ULL, 0x000fe200037fe4ffULL, 0x000000100f0f7824ULL, 0x000fe200078e0202ULL,
0xfffffffc17177812ULL, 0x000fe200078ee212ULL, 0x0000001013117824ULL, 0x000fe200078e0202ULL,
0xfffffffc19197812ULL, 0x000fe200078ee212ULL, 0x0000001015137824ULL, 0x100fe200078e0202ULL,
0x0000640006067a10ULL, 0x000fe20007fde0ffULL, 0x0000001017157824ULL, 0x100fe200078e0202ULL,
0x00000000080f7faeULL, 0x0003e2000e901c46ULL, 0x0000001019177824ULL, 0x000fe200078e0202ULL,
0x0000650007077a10ULL, 0x000fc400037fe4ffULL, 0x000000000a117faeULL, 0x0003e8000e101c46ULL,
0x000000000c137faeULL, 0x0003e8000d901c46ULL, 0x0000000004157faeULL, 0x0003e8000d101c46ULL,
0x0000000006177faeULL, 0x0003e2000c901c46ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x00000018200c7811ULL, 0x042fe200078ff0ffULL, 0x00000010201a7824ULL, 0x040fe200078e00ffULL,
0x0000002020007211ULL, 0x000fc400078fe8ffULL, 0x0000000820087811ULL, 0x000fe200078ff0ffULL,
0x000000040c0b7824ULL, 0x000fe200078e00ffULL, 0x0000002020147811ULL, 0x040fe400078ff0ffULL,
0x0000001b20047211ULL, 0x000fe200078ff0ffULL, 0x0000000408077824ULL, 0x000fe200078e00ffULL,
0x00000010200a7811ULL, 0x000fe200078ff0ffULL, 0x00000004140d7824ULL, 0x000fe200078e00ffULL,
0x0000002820167811ULL, 0x000fe200078ff0ffULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x0000000300027812ULL, 0x000fc400078ec0ffULL, 0x000000301a1a7812ULL, 0x000fe200078ec0ffULL,
0x000000040a097824ULL, 0x000fe200078e00ffULL, 0x00003000972b7811ULL, 0x000fe200078e68ffULL,
0x00000004160f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b0e7812ULL, 0x100fe200078ee202ULL,
0x0000000108067824ULL, 0x100fe200078e021bULL, 0x000000401a2d7812ULL, 0x000fe200078efcffULL,
0x000000010a087824ULL, 0x100fe200078e021bULL, 0xfffffffc070a7812ULL, 0x100fe200078ee202ULL,
0x000000010c007824ULL, 0x000fe200078e021bULL, 0xfffffffc0d107812ULL, 0x100fe200078ee202ULL,
0x000000100e197824ULL, 0x000fe200078e022bULL, 0xfffffffc090c7812ULL, 0x100fe200078ee202ULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0xfffffffc0f127812ULL, 0x000fc400078ee202ULL,
0x0000002d040e7212ULL, 0x080fe200078efcffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000003020187811ULL, 0x040fe400078ff0ffULL, 0x0000003820267811ULL, 0x000fe200078ff0ffULL,
0x0000001010257824ULL, 0x100fe200078e022bULL, 0x000064000e0e7a10ULL, 0x000fe20007f3e0ffULL,
0x0000001012277824ULL, 0x000fe200078e022bULL, 0x0000002d06107212ULL, 0x080fe200078efcffULL,
0x0000000418117824ULL, 0x000fe200078e00ffULL, 0x0000002d08127212ULL, 0x000fe200078efcffULL,
0x0000000426137824ULL, 0x000fe200078e00ffULL, 0x00006500050f7a10ULL, 0x000fe20000ffe4ffULL,
0x0000010000047825ULL, 0x000fe200078e00ffULL, 0x0000640010107a10ULL, 0x000fc40007f5e0ffULL,
0x0000640012127a10ULL, 0x000fe20007f7e0ffULL, 0x0000000114067824ULL, 0x000fe200078e021bULL,
0xfffffffc11247812ULL, 0x100fe200078ee202ULL, 0x000000100a157824ULL, 0x000fe200078e022bULL,
0xfffffffc13287812ULL, 0x000fe200078ee202ULL, 0x0000000116087824ULL, 0x000fe200078e021bULL,
0x0000650007117a10ULL, 0x000fe200017fe4ffULL, 0x000000100c177824ULL, 0x000fe200078e022bULL,
0x0ffffffc20037812ULL, 0x000fe200078ec0ffULL, 0x00000001180a7824ULL, 0x100fe200078e021bULL,
0x0000650009137a10ULL, 0x000fe20001ffe4ffULL, 0x00000001260c7824ULL, 0x000fe200078e021bULL,
0x0000002d04047212ULL, 0x000fe200078efcffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000302027212ULL, 0x000fc400078efcffULL, 0x0000640004047a10ULL, 0x000fe20007f3e0ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x0000002d06067212ULL, 0x080fe400078efcffULL,
0x0000650005057a10ULL, 0x000fe20000ffe4ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002d08087212ULL, 0x080fe400078efcffULL, 0x0000640006067a10ULL, 0x000fe20007f3e0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000002d0a0a7212ULL, 0x000fc400078efcffULL,
0x0000640008087a10ULL, 0x000fe20007f5e0ffULL, 0x00000010022f7824ULL, 0x100fe200078e022bULL,
0x0000002d0c0c7212ULL, 0x000fe200078efcffULL, 0x0000001024297824ULL, 0x100fe200078e022bULL,
0x000064000a0a7a10ULL, 0x000fe20007f7e0ffULL, 0x00000010282b7824ULL, 0x000fe200078e022bULL,
0x000064000c0c7a10ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e2f7faeULL, 0x0003e2000b901c46ULL, 0x0000650007077a10ULL, 0x000fe40000ffe4ffULL,
0x0000650009097a10ULL, 0x000fe200017fe4ffULL, 0x0000000010157faeULL, 0x0003e2000b901c46ULL,
0x000065000b0b7a10ULL, 0x000fc40001ffe4ffULL, 0x000065000d0d7a10ULL, 0x000fe200027fe4ffULL,
0x0000000012177faeULL, 0x0003e8000b901c46ULL, 0x0000000004197faeULL, 0x0003e8000b901c46ULL,
0x0000000006257faeULL, 0x0003e8000b901c46ULL, 0x0000000008277faeULL, 0x0003e8000b901c46ULL,
0x000000000a297faeULL, 0x0003e8000b901c46ULL, 0x000000000c2b7faeULL, 0x0003e4000b901c46ULL,
0x0000000820197812ULL, 0x002fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000004ff157819ULL, 0x100fe20000011620ULL, 0x0000200097717824ULL, 0x000fe200078e00ffULL,
0x0000000719197812ULL, 0x000fc400078ef820ULL, 0x0000000720057812ULL, 0x000fe200078ec0ffULL,
0x0000000815027824ULL, 0x040fe200078e00ffULL, 0x00000003ff737819ULL, 0x000fe20000011620ULL,
0x0000000115187824ULL, 0x000fe200078e0219ULL, 0x0000001019167812ULL, 0x040fe200078efcffULL,
0x0000001019077824ULL, 0x040fe200078e00ffULL, 0xfffffff802057812ULL, 0x000fe200078ee205ULL,
0x0000001019097824ULL, 0x000fe200078e00ffULL, 0x0000000218007810ULL, 0x000fe20007ffe0ffULL,
0x0000000115157824ULL, 0x000fe200078e0216ULL, 0x0000000173047812ULL, 0x000fe200078ec0ffULL,
0x00000004050b7824ULL, 0x000fe200078e00ffULL, 0xfffffff0070c7812ULL, 0x000fe200078ee200ULL,
0x0000001016067824ULL, 0x040fe200078e00ffULL, 0x0000000405027211ULL, 0x040fe200078ff8ffULL,
0x0000000405277824ULL, 0x040fe200078e00ffULL, 0x0000001005077810ULL, 0x040fe20007ffe0ffULL,
0x0000001016257824ULL, 0x000fe200078e00ffULL, 0x00000020050d7810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000030050f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000407767824ULL, 0x000fe200078e00ffULL, 0xfffffff009007812ULL, 0x000fe200078ee218ULL,
0x000000040d097824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b7a7812ULL, 0x000fe200078ee202ULL,
0x000000040f0b7824ULL, 0x000fe200078e00ffULL, 0x0000000202727810ULL, 0x000fe20007ffe0ffULL,
0x0000001000007824ULL, 0x000fe200078e00ffULL, 0xfffffff006027812ULL, 0x000fe200078ee215ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000407057211ULL, 0x0c0fe200078ff8ffULL,
0x0000000407077824ULL, 0x000fe200078e00ffULL, 0x000000040d067211ULL, 0x080fe200078ff8ffULL,
0x0000001002027824ULL, 0x000fe200078e00ffULL, 0x000000040f047211ULL, 0x000fe200078ff8ffULL,
0x000000000064783bULL, 0x0003e20000000200ULL, 0x0000200071177810ULL, 0x000fe20007ffe0ffULL,
0x000000040d0d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc76767812ULL, 0x000fe200078ee205ULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc09787812ULL, 0x000fe200078ee206ULL,
0x000000107a147824ULL, 0x100fe200078e0217ULL, 0xfffffffc0b747812ULL, 0x000fe200078ee204ULL,
0x0000001076137824ULL, 0x100fe200078e0217ULL, 0x000000000208783bULL, 0x0005e20000000200ULL,
0x0000001078127824ULL, 0x100fe200078e0217ULL, 0x00000002150e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001074117824ULL, 0x000fe200078e0217ULL, 0x000000001468783bULL, 0x000ee20000000200ULL,
0x0000000205707810ULL, 0x000fe20007ffe0ffULL, 0x000000100c0c7824ULL, 0x000fe200078e00ffULL,
0x0000000204007810ULL, 0x002fe20007ffe0ffULL, 0x000000001360783bULL, 0x000e620000000200ULL,
0x0000000206027810ULL, 0x004fc40007ffe0ffULL, 0xfffffff0250e7812ULL, 0x000fe200078ee20eULL,
0x00000000125c783bULL, 0x000ea20000000200ULL, 0xfffffffc27727812ULL, 0x000fe400078ee272ULL,
0xfffffffc07707812ULL, 0x000fe200078ee270ULL, 0x00000000116c783bULL, 0x000f220000000200ULL,
0xfffffffc0d027812ULL, 0x000fe200078ee202ULL, 0x000000100e547824ULL, 0x000fe200078e00ffULL,
0xfffffffc0f007812ULL, 0x000fe200078ee200ULL, 0x0000001072107824ULL, 0x100fe200078e0217ULL,
0x000000000c34783bULL, 0x000fe20000000200ULL, 0x00000010700f7824ULL, 0x000fc400078e0217ULL,
0x00000010020e7824ULL, 0x100fe200078e0217ULL, 0x00000000103c783bULL, 0x000e620000000200ULL,
0x00000010000d7824ULL, 0x000fc600078e0217ULL, 0x000000005454783bULL, 0x000ea80000000200ULL,
0x000000000f44783bULL, 0x000ea80000000200ULL, 0x000000000e4c783bULL, 0x000ea80000000200ULL,
0x000000000d04783bULL, 0x000ea20000000200ULL, 0x000000686458723cULL, 0x088f7000000018ffULL,
0x000000680838723cULL, 0x000f7000000018ffULL, 0x0000006a6424723cULL, 0x040f7000000018ffULL,
0x000000606428723cULL, 0x042f7000000018ffULL, 0x000000626490723cULL, 0x040f7000000018ffULL,
0x0000005c648c723cULL, 0x044f7000000018ffULL, 0x0000005e642c723cULL, 0x000f7000000018ffULL,
0x000000600840723cULL, 0x040f7000000018ffULL, 0x0000005c0848723cULL, 0x040f7000000018ffULL,
0x0000006a0868723cULL, 0x000f7000000018ffULL, 0x0000006c6430723cULL, 0x010f7000000018ffULL,
0x000000620860723cULL, 0x040f7000000018ffULL, 0x0000005e085c723cULL, 0x040f7000000018ffULL,
0x0000006c0850723cULL, 0x000f7000000018ffULL, 0x0000006e6464723cULL, 0x080f7000000018ffULL,
0x0000006e0808723cULL, 0x000f7000000018ffULL, 0x0000003c3458723cULL, 0x0a0b700000001858ULL,
0x0000003c5438723cULL, 0x000b700000001838ULL, 0x0000003e3424723cULL, 0x040b700000001824ULL,
0x000000443428723cULL, 0x040b700000001828ULL, 0x000000463490723cULL, 0x040b700000001890ULL,
0x0000004c348c723cULL, 0x040b70000000188cULL, 0x0000004e342c723cULL, 0x000b70000000182cULL,
0x000000445440723cULL, 0x040b700000001840ULL, 0x0000004c5448723cULL, 0x040b700000001848ULL,
0x0000003e543c723cULL, 0x000b700000001868ULL, 0x000000043430723cULL, 0x000b700000001830ULL,
0x000000465444723cULL, 0x040b700000001860ULL, 0x0000004e544c723cULL, 0x040b70000000185cULL,
0x000000045450723cULL, 0x000b700000001850ULL, 0x000000063434723cULL, 0x080b700000001864ULL,
0x000000065454723cULL, 0x000b620000001808ULL, 0x0000059000008947ULL, 0x000fce0003800000ULL,
0x00000002ff067819ULL, 0x120fe20000011620ULL, 0x00000001730c7824ULL, 0x000fe200078e0220ULL,
0x0000001c94057217ULL, 0x000fc40007800000ULL, 0x0000000806667810ULL, 0x040fe20007ffe0ffULL,
0x0000000106077824ULL, 0x140fe200078e021bULL, 0x0000001006687810ULL, 0x000fe20007ffe0ffULL,
0x0000000105697824ULL, 0x000fe200078e0a1cULL, 0x000000801a047812ULL, 0x000fe200078efcffULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x00000020066c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000166097824ULL, 0x000fe200078e021bULL, 0x00000018066a7810ULL, 0x040fe20007ffe0ffULL,
0x000000011b0b7824ULL, 0x000fe200078e0268ULL, 0x00000028066e7810ULL, 0x040fe20007ffe0ffULL,
0x0000010009087825ULL, 0x000fe200078e0004ULL, 0x00000030067c7810ULL, 0x000fc40007ffe0ffULL,
0x00000038067e7810ULL, 0x000fe20007ffe0ffULL, 0x000000016c5f7824ULL, 0x000fe200078e021bULL,
0x0000640008087a10ULL, 0x000fe20007f7e0ffULL, 0x000001000b0a7825ULL, 0x000fe200078e0004ULL,
0x000000690600720cULL, 0x080fe40003f26070ULL, 0x000000030c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000016a5d7824ULL, 0x100fe200078e021bULL, 0x000064000a647a10ULL, 0x000fe20007f9e0ffULL,
0x000000016e617824ULL, 0x100fe200078e021bULL, 0x0000650009097a10ULL, 0x000fe20001ffe4ffULL,
0x000000017c637824ULL, 0x040fe200078e021bULL, 0x000000697c00720cULL, 0x080fe20003fa6070ULL,
0x000001005f5e7825ULL, 0x000fe200078e0004ULL, 0x000000697e00720cULL, 0x000fc60003fc6070ULL,
0x000000017e657824ULL, 0x000fe200078e021bULL, 0x000064005e5e7a10ULL, 0x000fe20007f7e0ffULL,
0x0000010007067825ULL, 0x000fc600078e0004ULL, 0x000065005f5f7a10ULL, 0x000fe20001ffe4ffULL,
0x000001005d5c7825ULL, 0x100fe200078e0004ULL, 0x000000696600720cULL, 0x000fe40003f66070ULL,
0x0000640006067a10ULL, 0x000fe20007f5e0ffULL, 0x0000010061607825ULL, 0x000fc600078e0004ULL,
0x0000650007077a10ULL, 0x000fe200017fe4ffULL, 0x0000010063627825ULL, 0x000fe200078e0004ULL,
0x000064005c5c7a10ULL, 0x000fc60007f5e0ffULL, 0x0000010065047825ULL, 0x000fe200078e0004ULL,
0x000065000b657a10ULL, 0x000fe400027fe4ffULL, 0x000000030c0b7212ULL, 0x000fe200078efcffULL,
0x0000000466037824ULL, 0x000fe200078e00ffULL, 0x0000640060607a10ULL, 0x000fe20007f9e0ffULL,
0x0000000468677824ULL, 0x000fe200078e00ffULL, 0x000065005d5d7a10ULL, 0x000fe200017fe4ffULL,
0x000000100b0a7824ULL, 0x000fe200078e0217ULL, 0xfffffffc03667812ULL, 0x000fe200078ee20cULL,
0x000000046a6b7824ULL, 0x000fe200078e00ffULL, 0x0000650061617a10ULL, 0x000fc400027fe4ffULL,
0x000000696800720cULL, 0x080fe20003f86070ULL, 0x0000001066037824ULL, 0x100fe200078e0217ULL,
0xfffffffc67687812ULL, 0x100fe200078ee20cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060a7faeULL, 0x0003e2000c901c46ULL, 0x000000696a00720cULL, 0x080fe40003f26070ULL,
0xfffffffc6b667812ULL, 0x000fe200078ee20cULL, 0x0000000008037faeULL, 0x0005e2000d901c46ULL,
0x0000001068677824ULL, 0x000fe200078e0217ULL, 0x000000696c00720cULL, 0x000fe40003f66070ULL,
0x0000640062627a10ULL, 0x000fc40007f5e0ffULL, 0x0000000064677faeULL, 0x0007e2000e101c46ULL,
0x000000696e00720cULL, 0x000fe20003f86070ULL, 0x0000001066077824ULL, 0x002fe200078e0217ULL,
0x0000650063637a10ULL, 0x000fe400017fe4ffULL, 0x0000640004047a10ULL, 0x000fe20007f5e0ffULL,
0x000000046c037824ULL, 0x004fe200078e00ffULL, 0x000000005c077faeULL, 0x0003e2000c901c46ULL,
0x000000046e097824ULL, 0x000fe200078e00ffULL, 0x0000650005057a10ULL, 0x000fe400017fe4ffULL,
0xfffffffc03067812ULL, 0x100fe200078ee20cULL, 0x000000047c657824ULL, 0x008fe200078e00ffULL,
0xfffffffc09087812ULL, 0x000fe200078ee20cULL, 0x000000047e677824ULL, 0x000fc400078e00ffULL,
0x0000001006037824ULL, 0x100fe200078e0217ULL, 0xfffffffc65067812ULL, 0x100fe200078ee20cULL,
0x0000001008097824ULL, 0x100fe200078e0217ULL, 0xfffffffc67647812ULL, 0x000fe400078ee20cULL,
0x000000005e037faeULL, 0x0005e2000d901c46ULL, 0x0000001006077824ULL, 0x102fe400078e0217ULL,
0x00000010645d7824ULL, 0x000fe200078e0217ULL, 0x0000000060097faeULL, 0x0005e8000e101c46ULL,
0x0000000062077faeULL, 0x0005e8000e901c46ULL, 0x00000000045d7faeULL, 0x0005e2000f101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x000000801a627812ULL, 0x020fe200078efcffULL,
0x000000ffff637224ULL, 0x000fe200078e00ffULL, 0x0000001b20057211ULL, 0x040fe200078ff0ffULL,
0x00000001730c7824ULL, 0x000fe200078e0220ULL, 0x00000018206a7811ULL, 0x000fc400078ff0ffULL,
0x0000000820667811ULL, 0x040fe200078ff0ffULL, 0x0000010005047825ULL, 0x000fe200078e0062ULL,
0x0000001020687811ULL, 0x040fe400078ff0ffULL, 0x00000020206c7811ULL, 0x000fe200078ff0ffULL,
0x000000016a0b7824ULL, 0x100fe200078e021bULL, 0x00000028206e7811ULL, 0x000fe200078ff0ffULL,
0x0000000166077824ULL, 0x000fe200078e021bULL, 0x00000030207c7811ULL, 0x040fe200078ff0ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0062ULL, 0x00000038207e7811ULL, 0x000fc400078ff0ffULL,
0x0000640004047a10ULL, 0x000fe20007f3e0ffULL, 0x0000000168097824ULL, 0x100fe200078e021bULL,
0x000000030c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000016c5d7824ULL, 0x100fe200078e021bULL,
0x0000650005057a10ULL, 0x000fe20000ffe4ffULL, 0x000000016e5f7824ULL, 0x100fe200078e021bULL,
0x000064000a647a10ULL, 0x000fe20007f3e0ffULL, 0x000000017c617824ULL, 0x100fe400078e021bULL,
0x000000017e657824ULL, 0x000fe400078e021bULL, 0x0000010007067825ULL, 0x000fc800078e0062ULL,
0x0000010009087825ULL, 0x000fe200078e0062ULL, 0x0000640006067a10ULL, 0x000fc60007f5e0ffULL,
0x000001005d5c7825ULL, 0x100fe200078e0062ULL, 0x0000650007077a10ULL, 0x000fe400017fe4ffULL,
0x0000640008087a10ULL, 0x000fe20007f7e0ffULL, 0x000001005f5e7825ULL, 0x100fe200078e0062ULL,
0x000064005c5c7a10ULL, 0x000fe40007f5e0ffULL, 0x0000650009097a10ULL, 0x000fe20001ffe4ffULL,
0x0000010061607825ULL, 0x000fe200078e0062ULL, 0x000065005d5d7a10ULL, 0x000fc600017fe4ffULL,
0x0000000466677824ULL, 0x000fe200078e00ffULL, 0x0000640060607a10ULL, 0x000fe20007f5e0ffULL,
0x0000010065627825ULL, 0x000fe200078e0062ULL, 0x000065000b657a10ULL, 0x000fe40000ffe4ffULL,
0x000000030c0b7212ULL, 0x000fe200078efcffULL, 0x0000000468037824ULL, 0x000fe200078e00ffULL,
0xfffffffc67667812ULL, 0x100fe200078ee20cULL, 0x000000046a677824ULL, 0x000fe200078e00ffULL,
0x000064005e5e7a10ULL, 0x000fe20007f3e0ffULL, 0x000000046c6b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc03687812ULL, 0x100fe200078ee20cULL, 0x0000001066037824ULL, 0x100fe200078e0217ULL,
0xfffffffc67667812ULL, 0x100fe200078ee20cULL, 0x000000100b0a7824ULL, 0x100fe200078e0217ULL,
0x000065005f5f7a10ULL, 0x000fe20000ffe4ffULL, 0x000000046e6d7824ULL, 0x000fe200078e00ffULL,
0x0000640062627a10ULL, 0x000fe20007f3e0ffULL, 0x0000001066697824ULL, 0x100fe200078e0217ULL,
0xfffffffc6b667812ULL, 0x000fe200078ee20cULL, 0x000000047c6b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040a7faeULL, 0x0003e2000b901c46ULL,
0x000000047e6f7824ULL, 0x000fe200078e00ffULL, 0x0000650061617a10ULL, 0x000fe200017fe4ffULL,
0x0000001068677824ULL, 0x000fe200078e0217ULL, 0x0000000006037faeULL, 0x0005e2000b901c46ULL,
0x0000650063637a10ULL, 0x000fc60000ffe4ffULL, 0x0000000008677faeULL, 0x0007e2000b901c46ULL,
0xfffffffc6d047812ULL, 0x102fe200078ee20cULL, 0x0000001066057824ULL, 0x100fe200078e0217ULL,
0xfffffffc6f667812ULL, 0x100fe200078ee20cULL, 0x0000000064697faeULL, 0x0003e2000b901c46ULL,
0xfffffffc6b067812ULL, 0x004fe200078ee20cULL, 0x0000001004037824ULL, 0x100fe400078e0217ULL,
0x000000005c057faeULL, 0x0003e2000b901c46ULL, 0x0000001066097824ULL, 0x108fe400078e0217ULL,
0x0000001006077824ULL, 0x000fe200078e0217ULL, 0x000000005e037faeULL, 0x0003e8000b901c46ULL,
0x0000000060077faeULL, 0x0003e8000b901c46ULL, 0x0000000062097faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001016057824ULL, 0x006fe200078e00ffULL,
0x0000000415047810ULL, 0x000fe20007ffe0ffULL, 0x0000001019067824ULL, 0x040fe200078e00ffULL,
0x0000000418037810ULL, 0x000fe20007ffe0ffULL, 0x00000010195d7824ULL, 0x000fe200078e00ffULL,
0x0000300071097810ULL, 0x000fe20007ffe0ffULL, 0x00000010165e7824ULL, 0x000fe200078e00ffULL,
0xfffffff005047812ULL, 0x000fc400078ee204ULL, 0xfffffff006037812ULL, 0x000fe200078ee203ULL,
0x0000001074057824ULL, 0x100fe400078e0209ULL, 0x0000001004747824ULL, 0x000fe200078e00ffULL,
0x0000000618047810ULL, 0x000fe20007ffe0ffULL, 0x000000107a087824ULL, 0x100fe400078e0209ULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0xfffffff05d5c7812ULL, 0x000fe200078ee204ULL,
0x0000001076077824ULL, 0x100fe200078e0209ULL, 0x00000006155d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001078067824ULL, 0x000fc400078e0209ULL, 0x000000105c717824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000884783bULL, 0x000fe20000000200ULL,
0xfffffff05e5d7812ULL, 0x000fe200078ee25dULL, 0x0000001072047824ULL, 0x100fe400078e0209ULL,
0x000000000388783bULL, 0x0002a20000000200ULL, 0x0000001002027824ULL, 0x100fe400078e0209ULL,
0x000000105d5d7824ULL, 0x000fe200078e00ffULL, 0x000000000780783bULL, 0x000ee20000000200ULL,
0x0000001000007824ULL, 0x000fc600078e0209ULL, 0x00000000067c783bULL, 0x000f220000000200ULL,
0x0000001070037824ULL, 0x002fc600078e0209ULL, 0x000000000578783bULL, 0x000e680000000200ULL,
0x000000007474783bULL, 0x000e680000000200ULL, 0x00000000046c783bULL, 0x000fe80000000200ULL,
0x000000007170783bULL, 0x000e680000000200ULL, 0x000000000368783bULL, 0x000e680000000200ULL,
0x000000000264783bULL, 0x000e680000000200ULL, 0x000000000060783bULL, 0x000e680000000200ULL,
0x000000005d5c783bULL, 0x000e620000000200ULL, 0x000000848858723cULL, 0x044f700000001858ULL,
0x000000868824723cULL, 0x040f700000001824ULL, 0x000000808828723cULL, 0x048f700000001828ULL,
0x000000828890723cULL, 0x040f700000001890ULL, 0x0000007c888c723cULL, 0x050f70000000188cULL,
0x0000007e882c723cULL, 0x040f70000000182cULL, 0x000000788830723cULL, 0x042f700000001830ULL,
0x0000007a8834723cULL, 0x000f700000001834ULL, 0x000000847438723cULL, 0x040f700000001838ULL,
0x00000086743c723cULL, 0x040f70000000183cULL, 0x000000807440723cULL, 0x040f700000001840ULL,
0x000000827444723cULL, 0x040f700000001844ULL, 0x0000007c7448723cULL, 0x040f700000001848ULL,
0x0000007e744c723cULL, 0x040f70000000184cULL, 0x000000787450723cULL, 0x040f700000001850ULL,
0x0000007a7454723cULL, 0x000f700000001854ULL, 0x0000006c7058723cULL, 0x060b700000001858ULL,
0x0000006e7024723cULL, 0x040b700000001824ULL, 0x000000687028723cULL, 0x040b700000001828ULL,
0x0000006a7090723cULL, 0x040b700000001890ULL, 0x00000064708c723cULL, 0x040b70000000188cULL,
0x00000066702c723cULL, 0x040b70000000182cULL, 0x000000607030723cULL, 0x040b700000001830ULL,
0x000000627034723cULL, 0x000b700000001834ULL, 0x0000006c5c38723cULL, 0x040b700000001838ULL,
0x0000006e5c3c723cULL, 0x040b70000000183cULL, 0x000000685c40723cULL, 0x040b700000001840ULL,
0x0000006a5c44723cULL, 0x040b700000001844ULL, 0x000000645c48723cULL, 0x040b700000001848ULL,
0x000000665c4c723cULL, 0x040b70000000184cULL, 0x000000605c50723cULL, 0x040b700000001850ULL,
0x000000625c54723cULL, 0x000b620000001854ULL, 0x0000056000008947ULL, 0x000fce0003800000ULL,
0x00000002ff6e7819ULL, 0x020fe20000011620ULL, 0x000000ffff5f7224ULL, 0x000fe200078e00ffULL,
0x000000c01a5e7812ULL, 0x000fe200078efcffULL, 0x000000100b0b7824ULL, 0x000fe200078e0209ULL,
0x000000086e6b7810ULL, 0x040fe20007ffe0ffULL, 0x000000016e5d7824ULL, 0x040fe200078e021bULL,
0x000000106e6f7810ULL, 0x000fc40007ffe0ffULL, 0x000000186e707810ULL, 0x040fe20007ffe0ffULL,
0x000000016b617824ULL, 0x000fe200078e021bULL, 0x000000206e717810ULL, 0x040fe20007ffe0ffULL,
0x000001005d5c7825ULL, 0x100fe200078e005eULL, 0x000000286e727810ULL, 0x040fe40007ffe0ffULL,
0x000000306e737810ULL, 0x000fe20007ffe0ffULL, 0x0000010061607825ULL, 0x000fe200078e005eULL,
0x000064005c667a10ULL, 0x000fc60007f1e0ffULL, 0x000000011b637824ULL, 0x000fe200078e026fULL,
0x0000640060687a10ULL, 0x000fe20007f3e0ffULL, 0x0000000171657824ULL, 0x000fe200078e021bULL,
0x000065005d677a10ULL, 0x000fe200007fe4ffULL, 0x00000100635c7825ULL, 0x000fe200078e005eULL,
0x0000650061697a10ULL, 0x000fe40000ffe4ffULL, 0x0000001c94617217ULL, 0x000fe20007800000ULL,
0x0000000170637824ULL, 0x100fe200078e021bULL, 0x000064005c5c7a10ULL, 0x000fe20007f1e0ffULL,
0x00000001726d7824ULL, 0x000fc400078e021bULL, 0x00000001616c7824ULL, 0x000fe200078e0a1cULL,
0x000065005d5d7a10ULL, 0x000fe200007fe4ffULL, 0x0000010063607825ULL, 0x000fc600078e005eULL,
0x0000006c6e00720cULL, 0x080fe20003f46070ULL, 0x0000010065627825ULL, 0x100fe200078e005eULL,
0x0000006c6b00720cULL, 0x080fe40003f66070ULL, 0x00006400606a7a10ULL, 0x000fe20007f1e0ffULL,
0x000001006d647825ULL, 0x000fe200078e005eULL, 0x000000386e6e7810ULL, 0x000fe40007ffe0ffULL,
0x0000640062627a10ULL, 0x000fe20007f3e0ffULL, 0x000000046b6d7824ULL, 0x000fe200078e00ffULL,
0x00006500616b7a10ULL, 0x000fe200007fe4ffULL, 0x0000000173617824ULL, 0x100fe200078e021bULL,
0x0000006c6f00720cULL, 0x000fe20003fa6070ULL, 0x000000016e1b7824ULL, 0x000fe200078e021bULL,
0xfffffffc6d607812ULL, 0x000fe200078ee20cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000660b7faeULL, 0x0003e2000d101c46ULL, 0x000000046f6f7824ULL, 0x000fe200078e00ffULL,
0x0000640064647a10ULL, 0x000fc40007f1e0ffULL, 0x00000010606d7824ULL, 0x000fe200078e0209ULL,
0x0000650063637a10ULL, 0x000fe20000ffe4ffULL, 0x0000010061607825ULL, 0x100fe200078e005eULL,
0x0000006c7000720cULL, 0x0c0fe40003f86070ULL, 0x00000000686d7faeULL, 0x0005e2000d901c46ULL,
0x0000006c7100720cULL, 0x080fe20003f66070ULL, 0x000001001b5e7825ULL, 0x000fe200078e005eULL,
0x0000006c7300720cULL, 0x080fe40003f26070ULL, 0x0000650065657a10ULL, 0x000fe200007fe4ffULL,
0x00000004700b7824ULL, 0x002fe200078e00ffULL, 0x0000006c7200720cULL, 0x0c0fe20003f46070ULL,
0x0000000471717824ULL, 0x000fe200078e00ffULL, 0xfffffffc6f667812ULL, 0x100fe200078ee20cULL,
0x00000004721b7824ULL, 0x000fe200078e00ffULL, 0x0000640060607a10ULL, 0x000fe20007fde0ffULL,
0x0000000473737824ULL, 0x000fe200078e00ffULL, 0x0000006c6e00720cULL, 0x040fe20003f06070ULL,
0x000000046e677824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b687812ULL, 0x104fe200078ee20cULL,
0x00000010660b7824ULL, 0x000fe200078e0209ULL, 0xfffffffc716c7812ULL, 0x000fc400078ee20cULL,
0xfffffffc1b6e7812ULL, 0x100fe200078ee20cULL, 0x00000010681b7824ULL, 0x100fe200078e0209ULL,
0xfffffffc73707812ULL, 0x100fe200078ee20cULL, 0x000000005c0b7faeULL, 0x0003e2000e901c46ULL,
0x0000650061617a10ULL, 0x000fe200037fe4ffULL, 0x000000106e697824ULL, 0x100fe200078e0209ULL,
0xfffffffc67727812ULL, 0x000fe200078ee20cULL, 0x000000106c677824ULL, 0x100fe200078e0209ULL,
0x000064005e5e7a10ULL, 0x000fe20007fde0ffULL, 0x00000010706d7824ULL, 0x100fe200078e0209ULL,
0x000000006a1b7faeULL, 0x0003e2000e101c46ULL, 0x0000001072097824ULL, 0x000fe200078e0209ULL,
0x000065005f5f7a10ULL, 0x000fc400037fe4ffULL, 0x0000000062677faeULL, 0x0003e8000d901c46ULL,
0x0000000064697faeULL, 0x0003e8000d101c46ULL, 0x00000000606d7faeULL, 0x0003e8000c901c46ULL,
0x000000005e097faeULL, 0x0003e2000c101c46ULL, 0x000004a000007947ULL, 0x000fea0003800000ULL,
0x00000008206c7811ULL, 0x060fe200078ff0ffULL, 0x000000ffff6b7224ULL, 0x000fe200078e00ffULL,
0x00000010206e7811ULL, 0x040fe200078ff0ffULL, 0x000000100b757824ULL, 0x000fe200078e0209ULL,
0x0000001820707811ULL, 0x000fe200078ff0ffULL, 0x000000016c5f7824ULL, 0x100fe200078e021bULL,
0x0000002020727811ULL, 0x000fe200078ff0ffULL, 0x000000016e617824ULL, 0x100fe200078e021bULL,
0x0000002820747811ULL, 0x000fe200078ff0ffULL, 0x0000000170637824ULL, 0x100fe200078e021bULL,
0x0000003020767811ULL, 0x000fe200078ff0ffULL, 0x0000000172657824ULL, 0x100fe200078e021bULL,
0x0000003820787811ULL, 0x000fe200078ff0ffULL, 0x0000000174677824ULL, 0x100fe200078e021bULL,
0x000000c01a6a7812ULL, 0x000fe200078efcffULL, 0x0000000176697824ULL, 0x100fe200078e021bULL,
0x0000001b205d7211ULL, 0x000fe200078ff0ffULL, 0x00000001781b7824ULL, 0x000fc400078e021bULL,
0x000001005f5e7825ULL, 0x000fc800078e006aULL, 0x000001005d5c7825ULL, 0x000fe200078e006aULL,
0x000064005e5e7a10ULL, 0x000fc60007f3e0ffULL, 0x0000010061607825ULL, 0x100fe200078e006aULL,
0x000064005c5c7a10ULL, 0x000fe40007f1e0ffULL, 0x000065005f5f7a10ULL, 0x000fe20000ffe4ffULL,
0x0000010063627825ULL, 0x100fe200078e006aULL, 0x0000640060607a10ULL, 0x000fe40007f5e0ffULL,
0x000065005d5d7a10ULL, 0x000fe200007fe4ffULL, 0x0000010065647825ULL, 0x100fe200078e006aULL,
0x0000640062627a10ULL, 0x000fe40007f7e0ffULL, 0x0000650061617a10ULL, 0x000fe200017fe4ffULL,
0x0000010067667825ULL, 0x100fe200078e006aULL, 0x0000640064647a10ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000005c757faeULL, 0x0003e2000b901c46ULL,
0x0000650063637a10ULL, 0x000fe20001ffe4ffULL, 0x0000010069687825ULL, 0x000fe200078e006aULL,
0x0000640066667a10ULL, 0x000fc40007f3e0ffULL, 0x0000650065657a10ULL, 0x000fe200007fe4ffULL,
0x000001001b6a7825ULL, 0x000fe200078e006aULL, 0x0000640068687a10ULL, 0x000fe40007f5e0ffULL,
0x0000650067677a10ULL, 0x000fe20000ffe4ffULL, 0x000000046c0b7824ULL, 0x000fe200078e00ffULL,
0x000064006a6a7a10ULL, 0x000fe20007f7e0ffULL, 0x000000046e1b7824ULL, 0x000fe200078e00ffULL,
0x0000650069697a10ULL, 0x000fe200017fe4ffULL, 0x00000004706d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b6c7812ULL, 0x100fe200078ee20cULL, 0x00000004726f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1b6e7812ULL, 0x100fe200078ee20cULL, 0x0000000474717824ULL, 0x000fe200078e00ffULL,
0xfffffffc6d707812ULL, 0x100fe200078ee20cULL, 0x0000000476737824ULL, 0x000fe200078e00ffULL,
0xfffffffc6f727812ULL, 0x100fe200078ee20cULL, 0x0000000478777824ULL, 0x000fe200078e00ffULL,
0xfffffffc71747812ULL, 0x100fe200078ee20cULL, 0x000000106c0b7824ULL, 0x100fe200078e0209ULL,
0xfffffffc73767812ULL, 0x100fe200078ee20cULL, 0x000000106e1b7824ULL, 0x100fe200078e0209ULL,
0xfffffffc77787812ULL, 0x000fe200078ee20cULL, 0x00000010706d7824ULL, 0x100fe200078e0209ULL,
0x000000005e0b7faeULL, 0x0003e2000b901c46ULL, 0x00000010726f7824ULL, 0x100fe200078e0209ULL,
0x000065006b6b7a10ULL, 0x000fe20001ffe4ffULL, 0x0000001074717824ULL, 0x100fe200078e0209ULL,
0x00000000601b7faeULL, 0x0003e2000b901c46ULL, 0x0000001076737824ULL, 0x000fc400078e0209ULL,
0x0000001078097824ULL, 0x000fe200078e0209ULL, 0x00000000626d7faeULL, 0x0003e8000b901c46ULL,
0x00000000646f7faeULL, 0x0003e8000b901c46ULL, 0x0000000066717faeULL, 0x0003e8000b901c46ULL,
0x0000000068737faeULL, 0x0003e8000b901c46ULL, 0x000000006a097faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000010195c7824ULL, 0x002fe200078e00ffULL,
0x0000000818097810ULL, 0x000fe20007ffe0ffULL, 0x00000010165e7824ULL, 0x000fe200078e00ffULL,
0x00000008150b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001019747824ULL, 0x000fe200078e00ffULL,
0xfffffff05c097812ULL, 0x000fe200078ee209ULL, 0x0000001016757824ULL, 0x000fe200078e00ffULL,
0xfffffff05e0b7812ULL, 0x000fc400078ee20bULL, 0x0000000a181b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001009097824ULL, 0x000fe400078e00ffULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff0741b7812ULL, 0x000fe400078ee21bULL, 0x0000000a15747810ULL, 0x000fc60007ffe0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000000145c783bULL, 0x000fe80000000200ULL, 0x000000000960783bULL, 0x0002a80000000200ULL,
0x000000001364783bULL, 0x000ee80000000200ULL, 0x000000001268783bULL, 0x000f220000000200ULL,
0xfffffff075097812ULL, 0x002fc600078ee274ULL, 0x000000001170783bULL, 0x000e640000000200ULL,
0x0000001009097824ULL, 0x000fe400078e00ffULL, 0x000000000b6c783bULL, 0x000e680000000200ULL,
0x000000001074783bULL, 0x000fe80000000200ULL, 0x000000001b78783bULL, 0x000e680000000200ULL,
0x000000000f7c783bULL, 0x000e680000000200ULL, 0x000000000e80783bULL, 0x0004680000000200ULL,
0x000000000d88783bULL, 0x000e680000000200ULL, 0x000000000984783bULL, 0x000e620000000200ULL,
0x0000005c6058723cULL, 0x004f620000001858ULL, 0x00000300950e7a10ULL, 0x000fc80007ffe0ffULL,
0x000000010e107810ULL, 0x040fe20007ffe0ffULL, 0x000001000e0b7824ULL, 0x000fe400078e029dULL,
0x0000005e6024723cULL, 0x000f620000001824ULL, 0x000000231000720cULL, 0x000fe20003f06070ULL,
0x00006800221b7a24ULL, 0x000fcc00078e020bULL, 0x000000646028723cULL, 0x048f700000001828ULL,
0x000000666090723cULL, 0x040f700000001890ULL, 0x00000068608c723cULL, 0x050f70000000188cULL,
0x0000006a602c723cULL, 0x040f70000000182cULL, 0x000000706030723cULL, 0x042f700000001830ULL,
0x000000726034723cULL, 0x000f700000001834ULL, 0x0000005c6c38723cULL, 0x040f700000001838ULL,
0x0000005e6c3c723cULL, 0x040f70000000183cULL, 0x000000646c40723cULL, 0x040f700000001840ULL,
0x000000666c44723cULL, 0x040f700000001844ULL, 0x000000686c48723cULL, 0x040f700000001848ULL,
0x0000006a6c4c723cULL, 0x040f70000000184cULL, 0x000000706c50723cULL, 0x040f700000001850ULL,
0x000000726c54723cULL, 0x000f700000001854ULL, 0x000000747858723cULL, 0x060b700000001858ULL,
0x000000767824723cULL, 0x040b700000001824ULL, 0x0000007c7828723cULL, 0x040b700000001828ULL,
0x0000007e7890723cULL, 0x040b700000001890ULL, 0x00000080788c723cULL, 0x040b70000000188cULL,
0x00000082782c723cULL, 0x040b70000000182cULL, 0x000000887830723cULL, 0x040b700000001830ULL,
0x0000008a7834723cULL, 0x000b700000001834ULL, 0x000000748438723cULL, 0x040b700000001838ULL,
0x00000076843c723cULL, 0x040b70000000183cULL, 0x0000007c8440723cULL, 0x040b700000001840ULL,
0x0000007e8444723cULL, 0x040b700000001844ULL, 0x000000808448723cULL, 0x040b700000001848ULL,
0x00000082844c723cULL, 0x040b70000000184cULL, 0x000000888450723cULL, 0x040b700000001850ULL,
0x0000008a8454723cULL, 0x000b620000001854ULL, 0x000005b000008947ULL, 0x000fce0003800000ULL,
0x00000002ff147819ULL, 0x000fe40000011620ULL, 0x0000000b94097217ULL, 0x000fc40007800000ULL,
0x0000001014667810ULL, 0x040fe20007ffe0ffULL, 0x0000000114107824ULL, 0x040fe200078e021bULL,
0x0000000814647810ULL, 0x040fe20007ffe0ffULL, 0x0000000109097824ULL, 0x000fe200078e0a0bULL,
0x0000001814687810ULL, 0x000fe20007ffe0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x00000020146a7810ULL, 0x040fe40007ffe0ffULL, 0x00000028146c7810ULL, 0x000fe20007ffe0ffULL,
0x000000011b5c7824ULL, 0x000fe200078e0266ULL, 0x0000001a105e7212ULL, 0x000fe200078efcffULL,
0x0000000164127824ULL, 0x000fe200078e021bULL, 0x00000030146e7810ULL, 0x000fe20007ffe0ffULL,
0x000001005c5c7825ULL, 0x000fe200078e00ffULL, 0x000064005e5e7a10ULL, 0x000fc40007f1e0ffULL,
0x000000096600720cULL, 0x000fe20003fa6070ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000001a5c5c7212ULL, 0x080fe400078efcffULL, 0x00006500115f7a10ULL, 0x000fe200007fe4ffULL,
0x0000000168107824ULL, 0x100fe200078e021bULL, 0x0000001a12607212ULL, 0x000fe200078efcffULL,
0x000000016a127824ULL, 0x000fe200078e021bULL, 0x000064005c5c7a10ULL, 0x000fe20007f1e0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x0000640060607a10ULL, 0x000fc40007f3e0ffULL,
0x000065005d5d7a10ULL, 0x000fe200007fe4ffULL, 0x00000004640b7824ULL, 0x000fe200078e00ffULL,
0x000000091400720cULL, 0x080fe20003f06070ULL, 0x00000004680d7824ULL, 0x000fe200078e00ffULL,
0x0000001a10627212ULL, 0x000fe200078efcffULL, 0x000000016c107824ULL, 0x000fe200078e021bULL,
0x0000650013617a10ULL, 0x000fe20000ffe4ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000096400720cULL, 0x000fe40003f26070ULL, 0x0000640062627a10ULL, 0x000fe20007f5e0ffULL,
0x000000046a0f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b647812ULL, 0x000fc400078ee20cULL,
0x0000650011637a10ULL, 0x000fe200017fe4ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x0000001a12127212ULL, 0x080fe200078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000005e0a7faeULL, 0x0003e2000c101c46ULL, 0x0000003814147810ULL, 0x000fe20007ffe0ffULL,
0x00000010640b7824ULL, 0x000fe200078e0217ULL, 0x0000001a10647212ULL, 0x000fe400078efcffULL,
0x0000640012127a10ULL, 0x000fe20007f7e0ffULL, 0x0000000114107824ULL, 0x000fe200078e021bULL,
0x00000000600b7faeULL, 0x0005e2000c901c46ULL, 0x0000640064647a10ULL, 0x000fc40007fde0ffULL,
0x0000650013137a10ULL, 0x000fe20001ffe4ffULL, 0x000000016e0a7824ULL, 0x002fe200078e021bULL,
0x000000096800720cULL, 0x080fe20003f86070ULL, 0x000000046c5f7824ULL, 0x000fe200078e00ffULL,
0x000000096a00720cULL, 0x080fe20003f66070ULL, 0x00000004141b7824ULL, 0x000fe200078e00ffULL,
0x000000096c00720cULL, 0x080fe20003f46070ULL, 0x000001000a0a7825ULL, 0x004fe200078e00ffULL,
0x000000096e00720cULL, 0x080fe40003f26070ULL, 0x000000091400720cULL, 0x000fe20003f06070ULL,
0x0000000466097824ULL, 0x000fe200078e00ffULL, 0x0000650011657a10ULL, 0x000fe200037fe4ffULL,
0x000000046e617824ULL, 0x000fe200078e00ffULL, 0x0000001a0a0a7212ULL, 0x000fe200078efcffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0xfffffffc09147812ULL, 0x000fc400078ee20cULL,
0xfffffffc0d5e7812ULL, 0x100fe400078ee20cULL, 0xfffffffc0f607812ULL, 0x100fe200078ee20cULL,
0x0000001014097824ULL, 0x100fe200078e0217ULL, 0x000064000a0a7a10ULL, 0x000fe20007fde0ffULL,
0x000000105e0f7824ULL, 0x100fe200078e0217ULL, 0xfffffffc5f667812ULL, 0x100fe400078ee20cULL,
0xfffffffc61687812ULL, 0x100fe200078ee20cULL, 0x000000005c097faeULL, 0x0003e2000e901c46ULL,
0xfffffffc1b6a7812ULL, 0x000fe200078ee20cULL, 0x00000010601b7824ULL, 0x100fe200078e0217ULL,
0x0000001a100c7212ULL, 0x000fe200078efcffULL, 0x00000010665f7824ULL, 0x100fe200078e0217ULL,
0x000065000b0b7a10ULL, 0x000fe200037fe4ffULL, 0x0000001068617824ULL, 0x100fe200078e0217ULL,
0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x000000106a177824ULL, 0x000fe200078e0217ULL,
0x00000000620f7faeULL, 0x0003e4000e101c46ULL, 0x00006500110d7a10ULL, 0x000fc400037fe4ffULL,
0x00000000121b7faeULL, 0x0003e8000d901c46ULL, 0x00000000645f7faeULL, 0x0003e8000d101c46ULL,
0x000000000a617faeULL, 0x0003e8000c901c46ULL, 0x000000000c177faeULL, 0x0003e2000c101c46ULL,
0x000004f000007947ULL, 0x000fea0003800000ULL, 0x0000000820127811ULL, 0x040fe400078ff0ffULL,
0x00000018205e7811ULL, 0x000fc400078ff0ffULL, 0x0000001020147811ULL, 0x000fe200078ff0ffULL,
0x00000001120d7824ULL, 0x100fe200078e021bULL, 0x0000002020607811ULL, 0x000fe200078ff0ffULL,
0x0000000412137824ULL, 0x000fe200078e00ffULL, 0x0000002820627811ULL, 0x000fe200078ff0ffULL,
0x000000015e5c7824ULL, 0x100fe200078e021bULL, 0x0000003020647811ULL, 0x000fe200078ff0ffULL,
0x000000045e5f7824ULL, 0x000fe200078e00ffULL, 0x0000003820667811ULL, 0x000fe200078ff0ffULL,
0x0000000114127824ULL, 0x100fe200078e021bULL, 0x0000001b20107211ULL, 0x000fe200078ff0ffULL,
0x0000000160097824ULL, 0x000fc400078e021bULL, 0x00000001620b7824ULL, 0x100fe400078e021bULL,
0x00000001640f7824ULL, 0x100fe400078e021bULL, 0x00000001665e7824ULL, 0x000fe400078e021bULL,
0x00000004145d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc13147812ULL, 0x100fe200078ee20cULL,
0x0000000460617824ULL, 0x000fe400078e00ffULL, 0x0000000462637824ULL, 0x000fe200078e00ffULL,
0xfffffffc5d627812ULL, 0x100fe200078ee20cULL, 0x0000000464657824ULL, 0x000fe200078e00ffULL,
0xfffffffc5f647812ULL, 0x100fe200078ee20cULL, 0x00000004661b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc61667812ULL, 0x100fe200078ee20cULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0xfffffffc63687812ULL, 0x000fc400078ee20cULL, 0xfffffffc656a7812ULL, 0x100fe200078ee20cULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0xfffffffc1b6c7812ULL, 0x000fe400078ee20cULL,
0x0000001a10607212ULL, 0x000fe200078efcffULL, 0x000001000d0c7825ULL, 0x000fc600078e00ffULL,
0x0000640060607a10ULL, 0x000fe20007f1e0ffULL, 0x0000001062697824ULL, 0x100fe200078e0217ULL,
0x0000001a0c627212ULL, 0x080fe200078efcffULL, 0x00000010646b7824ULL, 0x000fe200078e0217ULL,
0x0000001a12647212ULL, 0x000fe200078efcffULL, 0x000001005c5c7825ULL, 0x000fe200078e00ffULL,
0x0000640062627a10ULL, 0x000fe40007f3e0ffULL, 0x0000640064647a10ULL, 0x000fe20007f5e0ffULL,
0x000001005e5e7825ULL, 0x000fe200078e00ffULL, 0x000065000d637a10ULL, 0x000fc40000ffe4ffULL,
0x0000650011617a10ULL, 0x000fe200007fe4ffULL, 0x00000100090c7825ULL, 0x000fe200078e00ffULL,
0x0000001a5c5c7212ULL, 0x080fe400078efcffULL, 0x0000650013657a10ULL, 0x000fe200017fe4ffULL,
0x000001000b107825ULL, 0x000fe200078e00ffULL, 0x000064005c5c7a10ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000600a7faeULL, 0x0003e2000b901c46ULL,
0x0000001a0c0c7212ULL, 0x080fe200078efcffULL, 0x000001000f127825ULL, 0x000fe200078e00ffULL,
0x0000001a10107212ULL, 0x000fc400078efcffULL, 0x000065005d5d7a10ULL, 0x000fe200007fe4ffULL,
0x0000001014677824ULL, 0x100fe200078e0217ULL, 0x0000001a12127212ULL, 0x080fe200078efcffULL,
0x00000010666d7824ULL, 0x100fe200078e0217ULL, 0x0000001a5e1a7212ULL, 0x000fe200078efcffULL,
0x00000010686f7824ULL, 0x100fe200078e0217ULL, 0x000064000c0c7a10ULL, 0x000fe20007f1e0ffULL,
0x000000106a717824ULL, 0x100fe200078e0217ULL, 0x0000640010107a10ULL, 0x000fe20007f3e0ffULL,
0x0000000062677faeULL, 0x0003e2000b901c46ULL, 0x0000640012127a10ULL, 0x000fe20007f5e0ffULL,
0x000000106c177824ULL, 0x000fe200078e0217ULL, 0x000064001a1a7a10ULL, 0x000fe20007f7e0ffULL,
0x0000000064697faeULL, 0x0003e2000b901c46ULL, 0x000065000d0d7a10ULL, 0x000fc400007fe4ffULL,
0x0000650011117a10ULL, 0x000fe20000ffe4ffULL, 0x000000005c6b7faeULL, 0x0003e2000b901c46ULL,
0x0000650013137a10ULL, 0x000fe400017fe4ffULL, 0x000065005f1b7a10ULL, 0x000fe20001ffe4ffULL,
0x000000000c6d7faeULL, 0x0003e8000b901c46ULL, 0x00000000106f7faeULL, 0x0003e8000b901c46ULL,
0x0000000012717faeULL, 0x0003e8000b901c46ULL, 0x000000001a177faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000010190a7824ULL, 0x002fe200078e00ffULL,
0x0000000c18097810ULL, 0x000fe20007ffe0ffULL, 0x00000010160d7824ULL, 0x000fe200078e00ffULL,
0x0000000c150c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001019197824ULL, 0x000fe200078e00ffULL,
0xfffffff00a097812ULL, 0x000fe200078ee209ULL, 0x0000001016167824ULL, 0x000fe200078e00ffULL,
0xfffffff00d0c7812ULL, 0x000fc400078ee20cULL, 0x0000000e18187810ULL, 0x000fe20007ffe0ffULL,
0x0000001009107824ULL, 0x000fe200078e00ffULL, 0x0000000e15157810ULL, 0x000fe20007ffe0ffULL,
0x000000100c0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff019187812ULL, 0x000fe400078ee218ULL,
0xfffffff016157812ULL, 0x000fc600078ee215ULL, 0x00000010186c7824ULL, 0x000fe400078e00ffULL,
0x0000001015157824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000808783bULL, 0x000fe80000000200ULL, 0x000000001010783bULL, 0x000e680000000200ULL,
0x000000000764783bULL, 0x000ea80000000200ULL, 0x000000000670783bULL, 0x000ee80000000200ULL,
0x000000000574783bULL, 0x020f280000000200ULL, 0x000000000c78783bULL, 0x000ee80000000200ULL,
0x000000000460783bULL, 0x0007e80000000200ULL, 0x000000006c6c783bULL, 0x000f280000000200ULL,
0x000000000368783bULL, 0x000f280000000200ULL, 0x00000000025c783bULL, 0x000f280000000200ULL,
0x000000000018783bULL, 0x000f280000000200ULL, 0x000000001514783bULL, 0x000f220000000200ULL,
0x0000000a1024723cULL, 0x042f700000001824ULL, 0x000000641028723cULL, 0x044f700000001828ULL,
0x000000721004723cULL, 0x048f70000000182cULL, 0x000000081058723cULL, 0x040f700000001858ULL,
0x000000661090723cULL, 0x040ff00000001890ULL, 0x00000070108c723cULL, 0x040ff0000000188cULL,
0x000000741030723cULL, 0x050ff00000001830ULL, 0x000000761034723cULL, 0x000ff00000001834ULL,
0x000000087810723cULL, 0x040ff00000001838ULL, 0x000000647840723cULL, 0x040ff00000001840ULL,
0x000000707848723cULL, 0x040ff00000001848ULL, 0x0000000a783c723cULL, 0x040ff0000000183cULL,
0x000000667844723cULL, 0x040ff00000001844ULL, 0x00000072784c723cULL, 0x040ff0000000184cULL,
0x000000747838723cULL, 0x040ff00000001850ULL, 0x000000767854723cULL, 0x000ff00000001854ULL,
0x000000626c50723cULL, 0x060f700000001824ULL, 0x000000686c2c723cULL, 0x040f700000001828ULL,
0x0000005e6c08723cULL, 0x040f700000001804ULL, 0x000000606c58723cULL, 0x000f640000001858ULL,
0x3db504f350027820ULL, 0x020fe20000410000ULL, 0x3db504f351517820ULL, 0x000fca0000410000ULL,
0x0000006a6c28723cULL, 0x000f620000001890ULL, 0x3db504f32c2c7820ULL, 0x000fe20000410000ULL,
0x3db504f32d2d7820ULL, 0x000fe20000410000ULL, 0x3db504f32e2e7820ULL, 0x000fe20000410000ULL,
0x3db504f32f2f7820ULL, 0x000fc80000410000ULL, 0x0000005c6c24723cULL, 0x000f62000000188cULL,
0x3db504f3080c7820ULL, 0x000fce0000410000ULL, 0x000000186c04723cULL, 0x000f620000001830ULL,
0x3db504f358037820ULL, 0x000fe20000410000ULL, 0x3db504f359007820ULL, 0x000fe20000410000ULL,
0x3db504f35a5a7820ULL, 0x000fe20000410000ULL, 0x3db504f35b5b7820ULL, 0x000fc80000410000ULL,
0x0000001a6c6c723cULL, 0x000f640000001834ULL, 0x3db504f3290d7820ULL, 0x020fe20000410000ULL,
0x3db504f328287820ULL, 0x000fe20000410000ULL, 0x3db504f32a2a7820ULL, 0x000fe20000410000ULL,
0x3db504f32b2b7820ULL, 0x000fc60000410000ULL, 0x000000601410723cULL, 0x000f620000001810ULL,
0x3db504f3240f7820ULL, 0x000fe20000410000ULL, 0x3db504f325257820ULL, 0x000fe20000410000ULL,
0x3db504f327297820ULL, 0x000fca0000410000ULL, 0x000000681430723cULL, 0x000f620000001840ULL,
0x3db504f304047820ULL, 0x000fe20000410000ULL, 0x3db504f305057820ULL, 0x000fe20000410000ULL,
0x3db504f306067820ULL, 0x000fe20000410000ULL, 0x3db504f307077820ULL, 0x000fc80000410000ULL,
0x0000005c1434723cULL, 0x000b620000001848ULL, 0x3db504f36c6c7820ULL, 0x000fe20000410000ULL,
0x3db504f36d6d7820ULL, 0x000fe20000410000ULL, 0x3db504f36e6e7820ULL, 0x000fe20000410000ULL,
0x3db504f36f6f7820ULL, 0x000fc80000410000ULL, 0x000000621460723cULL, 0x000b64000000183cULL,
0x3db504f313487820ULL, 0x020fca0000410000ULL, 0x3db504f30a3c7820ULL, 0x000fe20000410000ULL,
0x0000006a1468723cULL, 0x040b620000001844ULL, 0x3db504f30b3d7820ULL, 0x000fe20000410000ULL,
0x3db504f3103e7820ULL, 0x000fe20000410000ULL, 0x3db504f3113f7820ULL, 0x000fe20000410000ULL,
0x3db504f330407820ULL, 0x000fe20000410000ULL, 0x3db504f331417820ULL, 0x000fe40000410000ULL,
0x3db504f312477820ULL, 0x020fe20000410000ULL, 0x0000005e145c723cULL, 0x000b62000000184cULL,
0x3db504f334427820ULL, 0x000fe20000410000ULL, 0x3db504f335437820ULL, 0x000fe20000410000ULL,
0x3db504f3364a7820ULL, 0x000fc80000410000ULL, 0x3db504f3324c7820ULL, 0x020fe20000410000ULL,
0x000000181438723cULL, 0x040b620000001838ULL, 0x3db504f360607820ULL, 0x000fe20000410000ULL,
0x3db504f361617820ULL, 0x000fe20000410000ULL, 0x3db504f362497820ULL, 0x000fe20000410000ULL,
0x3db504f3634b7820ULL, 0x000fe20000410000ULL, 0x3db504f3334e7820ULL, 0x000fe40000410000ULL,
0x3db504f352197820ULL, 0x020fe20000410000ULL, 0x0000001a1414723cULL, 0x000b620000001854ULL,
0x3db504f309187820ULL, 0x000fe20000410000ULL, 0x3db504f368687820ULL, 0x000fe20000410000ULL,
0x3db504f369697820ULL, 0x000fe20000410000ULL, 0x3db504f36a4f7820ULL, 0x000fe20000410000ULL,
0x3db504f36b4d7820ULL, 0x000fe20000410000ULL, 0x3db504f337527820ULL, 0x000fe20000410000ULL,
0x3db504f3531b7820ULL, 0x020fe20000410000ULL, 0x3db504f3261a7820ULL, 0x000fe20000410000ULL,
0x3db504f35c5c7820ULL, 0x000fe20000410000ULL, 0x3db504f35d5d7820ULL, 0x000fe20000410000ULL,
0x3db504f35e5e7820ULL, 0x000fe20000410000ULL, 0x3db504f35f5f7820ULL, 0x000fc80000410000ULL,
0x3db504f33b547820ULL, 0x000fe20000410000ULL, 0x3db504f338447820ULL, 0x000fe20000410000ULL,
0x3db504f339457820ULL, 0x000fe20000410000ULL, 0x3db504f33a537820ULL, 0x000fca0000410000ULL,
0x3db504f3143b7820ULL, 0x000fe20000410000ULL, 0x3db504f315467820ULL, 0x000fe20000410000ULL,
0x3db504f316557820ULL, 0x000fe20000410000ULL, 0x3db504f317567820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ffff087224ULL, 0x000fe400078e0051ULL,
0x000000009b507f8cULL, 0x0002a2000c80043fULL, 0x000000ffff307224ULL, 0x000fe400078e003fULL,
0x000000ffff347224ULL, 0x000fe400078e0040ULL, 0x000000ffff137224ULL, 0x000fc400078e0025ULL,
0x000000ffff267224ULL, 0x000fe400078e002aULL, 0x000000ffff277224ULL, 0x000fe400078e002bULL,
0x000000ffff387224ULL, 0x000fe400078e0042ULL, 0x000000ffff3f7224ULL, 0x000fe400078e0044ULL,
0x000000ffff407224ULL, 0x000fe400078e0045ULL, 0x000000ffff097224ULL, 0x000fc400078e002cULL,
0x000000ffff0a7224ULL, 0x000fe400078e002dULL, 0x000000ffff0b7224ULL, 0x000fe400078e0028ULL,
0x000000ffff157224ULL, 0x000fe400078e0018ULL, 0x000000ffff247224ULL, 0x000fe400078e002eULL,
0x000000ffff257224ULL, 0x000fe400078e002fULL, 0x000000ffff2a7224ULL, 0x000fc400078e003cULL,
0x000000ffff2b7224ULL, 0x000fe400078e003dULL, 0x000000ffff317224ULL, 0x000fe400078e003eULL,
0x000000ffff357224ULL, 0x000fe400078e0041ULL, 0x000000ffff397224ULL, 0x000fe400078e0043ULL,
0x000000ffff427224ULL, 0x000fe400078e003bULL, 0x000000ffff457224ULL, 0x000fc400078e0046ULL,
0x000000ffff447224ULL, 0x000fe400078e0047ULL, 0x000000ffff177224ULL, 0x000fe400078e000cULL,
0x000000ffff167224ULL, 0x000fe400078e0004ULL, 0x000000ffff117224ULL, 0x000fe400078e0005ULL,
0x000000ffff127224ULL, 0x000fe400078e006cULL, 0x000000ffff147224ULL, 0x000fc400078e006dULL,
0x000000ffff107224ULL, 0x000fe400078e005aULL, 0x000000ffff187224ULL, 0x000fe400078e005bULL,
0x000000ffff287224ULL, 0x000fe400078e001aULL, 0x000000ffff2c7224ULL, 0x000fe400078e0006ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0007ULL, 0x000000ffff2e7224ULL, 0x000fc400078e006eULL,
0x000000ffff2f7224ULL, 0x000fe400078e006fULL, 0x000000ffff327224ULL, 0x000fe400078e0060ULL,
0x000000ffff337224ULL, 0x000fe400078e0061ULL, 0x000000ffff367224ULL, 0x000fe400078e0068ULL,
0x000000ffff377224ULL, 0x000fe400078e0069ULL, 0x000000ffff3a7224ULL, 0x000fc400078e005cULL,
0x000000ffff3c7224ULL, 0x000fe400078e005dULL, 0x000000ffff3b7224ULL, 0x000fe400078e0052ULL,
0x000000ffff3d7224ULL, 0x000fe400078e005eULL, 0x000000ffff3e7224ULL, 0x000fe400078e005fULL,
0x000000ffff417224ULL, 0x000fe400078e0053ULL, 0x000000ffff437224ULL, 0x000fc400078e0054ULL,
0x000000ffff467224ULL, 0x000fe400078e0055ULL, 0x000000ffff477224ULL, 0x000fc400078e0056ULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x000004009b077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804851ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604537210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09005300780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c405300780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000005306067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004009b077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804851ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004201a7824ULL, 0x000fe200078e00ffULL,
0x000000219500720cULL, 0x000fc80003f06070ULL, 0xfffffff01a0c7812ULL, 0x000fca00078ec0ffULL,
0x00000080970c7824ULL, 0x000fca00078e020cULL, 0x016400000c047984ULL, 0x0002a20000000c00ULL,
0x000021e000008947ULL, 0x000fea0003800000ULL, 0x00005a0000537b06ULL, 0x000ee20000209000ULL,
0x000000ffff507224ULL, 0x000fe200078e00ffULL, 0x0000009620527211ULL, 0x000fe400078ff0ffULL,
0x0000001c94597217ULL, 0x000fe40007800000ULL, 0x00005a00ff5d7a12ULL, 0x000fc600078e33ffULL,
0x00000001591c7824ULL, 0x000fe200078e0a1cULL, 0x0000005300537308ULL, 0x008ee40000001000ULL,
0x0ffffffe53567810ULL, 0x008fcc0007ffe0ffULL, 0x0000005600517305ULL, 0x000ee4000021f000ULL,
0x000000ffff557224ULL, 0x008fc800078e0a51ULL, 0x00005a0055557a24ULL, 0x000fc800078e02ffULL,
0x0000005551577227ULL, 0x000fe200078e0050ULL, 0x0000000852517810ULL, 0x040fe40007ffe0ffULL,
0x0000001052557810ULL, 0x000fc60007ffe0ffULL, 0x0000005157547227ULL, 0x000fc800078e00ffULL,
0x0000005257507227ULL, 0x000fc800078e00ffULL, 0x000000ffff587224ULL, 0x000fe400078e0a54ULL,
0x000000ffff537224ULL, 0x000fe400078e0a50ULL, 0x00005a0058517a24ULL, 0x000fe400078e0251ULL,
0x00005a0053537a24ULL, 0x000fe200078e0252ULL, 0x0000001852527810ULL, 0x000fe20007ffe0ffULL,
0x0000005557567227ULL, 0x000fe200078e00ffULL, 0x00005a0051007a0cULL, 0x000fe40003fa6070ULL,
0x00005a0053007a0cULL, 0x000fe20003f06070ULL, 0x000000ffff587224ULL, 0x000fc800078e0a56ULL,
0x00005a0058557a24ULL, 0x000fe400078e0255ULL, 0x0000005257587227ULL, 0x000fc600078e00ffULL,
0x00005a0055007a0cULL, 0x000fe20003f26070ULL, 0x000000ffff577224ULL, 0x000fe200078e0a58ULL,
0x80005a0051515a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0053530a10ULL, 0x000fe20007ffe0ffULL,
0x00005a0057527a24ULL, 0x000fe200078e0252ULL, 0x00005a0051007a0cULL, 0x000fe20003fc6070ULL,
0x0000000220517824ULL, 0x000fe200078e00ffULL, 0x00005a0053007a0cULL, 0x000fe40003f46070ULL,
0x00005a0052007a0cULL, 0x000fc40003f66070ULL, 0x0000000651517812ULL, 0x000fe400078ec0ffULL,
0x80005a0055551a10ULL, 0x000fe40007ffe0ffULL, 0x0000000150500810ULL, 0x000fe20007ffe0ffULL,
0x0000000151537824ULL, 0x000fe200078e029aULL, 0x00005a0055007a0cULL, 0x000fe20003f86070ULL,
0x000000011d577824ULL, 0x000fe200078e0251ULL, 0x0000000154545810ULL, 0x000fe20007ffe0ffULL,
0x0000000153557824ULL, 0x000fe200078e0a1cULL, 0x00005a00ff007a0cULL, 0x000fc40003fa5070ULL,
0x0000000150502810ULL, 0x000fe40007ffe0ffULL, 0x0000001c5700720cULL, 0x040fe20003f06070ULL,
0x0000000157577824ULL, 0x000fe200078e0a1cULL, 0x80005a0052523a10ULL, 0x000fe40007ffe0ffULL,
0x000000551e5c7217ULL, 0x000fe40003800000ULL, 0x000000505d557207ULL, 0x000fe40006800000ULL,
0x00005a0052007a0cULL, 0x000fc40003f46070ULL, 0x000000571e577217ULL, 0x000fe40003800000ULL,
0x0000000154546810ULL, 0x000fe40007ffe0ffULL, 0x000000551e507217ULL, 0x000fe40003800000ULL,
0x0000001c5300720cULL, 0x000fe40003fc6070ULL, 0x0000000156561810ULL, 0x000fe20007ffe0ffULL,
0x000000501f7b7224ULL, 0x000fe200078e02ffULL, 0x00000004ff577819ULL, 0x000fc40000011657ULL,
0x000000545d597207ULL, 0x000fe40006800000ULL, 0x000000ff5c5c7207ULL, 0x000fe40003000000ULL,
0x0000000156564810ULL, 0x000fe40007ffe0ffULL, 0x000000ff575a7207ULL, 0x000fe40000000000ULL,
0x0000000158583810ULL, 0x000fe40007ffe0ffULL, 0x000000591e527217ULL, 0x000fe20003800000ULL,
0x000000017b577824ULL, 0x000fe200078e025aULL, 0x000000565d5b7207ULL, 0x000fc40006800000ULL,
0x0000007b5c557211ULL, 0x000fe200078fe0ffULL, 0x000000521f7f7224ULL, 0x000fe200078e02ffULL,
0x0000000158582810ULL, 0x000fe20007ffe0ffULL, 0x0000000257567825ULL, 0x100fe200078e0098ULL,
0x0000005b1e527217ULL, 0x040fe40003800000ULL, 0x000000585d5d7207ULL, 0x000fe20006800000ULL,
0x0000000255547825ULL, 0x000fe200078e0098ULL, 0x00000010515b7812ULL, 0x000fe200078efcffULL,
0x0000000656507981ULL, 0x000722000c1e9500ULL, 0x0000005d1e5e7217ULL, 0x000fe20003800000ULL,
0x000000521f817224ULL, 0x000fc400078e02ffULL, 0x0000000654557981ULL, 0x000322000c1e9500ULL,
0x000000015a597824ULL, 0x000fe200078e027fULL, 0x0000007f5c617211ULL, 0x040fe200078fe0ffULL,
0x0000005e1f837224ULL, 0x000fe200078e02ffULL, 0x000000815c637211ULL, 0x000fe200078fe0ffULL,
0x000000015a657824ULL, 0x000fe400078e0281ULL, 0x000000011d6b7824ULL, 0x000fe400078e025bULL,
0x0000000259587825ULL, 0x000fe200078e0098ULL, 0x000000835c5f7211ULL, 0x000fc600078fe0ffULL,
0x0000000261607825ULL, 0x100fe200078e0098ULL, 0x0000000658527981ULL, 0x000526000c1e9500ULL,
0x0000000265647825ULL, 0x100fe200078e0098ULL, 0x0000000660577981ULL, 0x008726000c1e9500ULL,
0x0000000263627825ULL, 0x000fe200078e0098ULL, 0x0000000664547981ULL, 0x002326000c1e9500ULL,
0x000000016b697824ULL, 0x000fe200078e0a1cULL, 0x0000000662597981ULL, 0x004522000c1e9500ULL,
0x000000015b5d7824ULL, 0x000fc400078e029aULL, 0x000000025f5e7825ULL, 0x000fe200078e0098ULL,
0x000000691e587217ULL, 0x000fc60003800000ULL, 0x000000015d697824ULL, 0x000fe200078e0a1cULL,
0x0000001c6b00720cULL, 0x080fe20003f26070ULL, 0x000000015a677824ULL, 0x000fe200078e0283ULL,
0x00000004ff587819ULL, 0x000fe20000011658ULL, 0x000000065e5f7981ULL, 0x000322000c1e9500ULL,
0x0000001c5d00720cULL, 0x000fe20003f06070ULL, 0x0000000267667825ULL, 0x000fe200078e0098ULL,
0x000000691e697217ULL, 0x000fc80003800000ULL, 0x000000ff696a7207ULL, 0x000fe20000000000ULL,
0x0000000666567981ULL, 0x000522000c1e9500ULL, 0x000000ff585e7207ULL, 0x002fe40000800000ULL,
0x00000020516b7812ULL, 0x000fe400078efcffULL, 0x0000007b6a617211ULL, 0x008fe200078fe0ffULL,
0x000000017b637824ULL, 0x004fe400078e025eULL, 0x000000015e677824ULL, 0x000fe200078e027fULL,
0x0000007f6a657211ULL, 0x000fe200078fe0ffULL, 0x000000011d757824ULL, 0x000fc400078e026bULL,
0x0000000267667825ULL, 0x000fc800078e0098ULL, 0x0000000263627825ULL, 0x100fe200078e0098ULL,
0x00000006665a7981ULL, 0x0002a6000c1e9500ULL, 0x0000000261607825ULL, 0x100fe200078e0098ULL,
0x0000000662587981ULL, 0x0006a6000c1e9500ULL, 0x0000000265647825ULL, 0x000fe400078e0098ULL,
0x0000000660617981ULL, 0x0006a4000c1e9500ULL, 0x0000000175677824ULL, 0x002fc400078e0a1cULL,
0x000000016b6d7824ULL, 0x000fe200078e029aULL, 0x0000000664637981ULL, 0x0082e2000c1e9500ULL,
0x000000816a697211ULL, 0x040fe400078fe0ffULL, 0x000000836a6f7211ULL, 0x000fe400078fe0ffULL,
0x000000671e627217ULL, 0x000fe20003800000ULL, 0x000000016d677824ULL, 0x000fe400078e0a1cULL,
0x000000015e717824ULL, 0x040fe400078e0281ULL, 0x000000015e737824ULL, 0x000fe200078e0283ULL,
0x0000001c7500720cULL, 0x080fe20003f26070ULL, 0x0000000269687825ULL, 0x000fe200078e0098ULL,
0x0000001c6d00720cULL, 0x000fc40003f06070ULL, 0x00000004ff627819ULL, 0x000fe20000011662ULL,
0x000000026f6e7825ULL, 0x100fe200078e0098ULL, 0x000000671e677217ULL, 0x000fe20003800000ULL,
0x0000000668697981ULL, 0x0002a4000c1e9500ULL, 0x0000000271707825ULL, 0x000fc800078e0098ULL,
0x0000000273727825ULL, 0x000fe200078e0098ULL, 0x000000ff62667207ULL, 0x000fe20000800000ULL,
0x00000006705e7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff676c7207ULL, 0x000fc60000000000ULL,
0x0000000672607981ULL, 0x0002e2000c1e9500ULL, 0x0000007f6c677211ULL, 0x000fc600078fe0ffULL,
0x000000066e6f7981ULL, 0x0002e2000c1e9500ULL, 0x0000000166777824ULL, 0x000fe200078e027fULL,
0x0000007b6c757211ULL, 0x000fe200078fe0ffULL, 0x000000017b657824ULL, 0x002fe400078e0266ULL,
0x0000000166717824ULL, 0x040fe400078e0281ULL, 0x0000000166857824ULL, 0x000fe400078e0283ULL,
0x0000000277767825ULL, 0x000fc800078e0098ULL, 0x0000000267667825ULL, 0x100fe200078e0098ULL,
0x0000000676687981ULL, 0x0002e2000c1e9500ULL, 0x000000836c7d7211ULL, 0x040fe400078fe0ffULL,
0x0000000275747825ULL, 0x100fe200078e0098ULL, 0x0000000666cd7981ULL, 0x0002e2000c1e9500ULL,
0x0000003051b37812ULL, 0x000fe400078efcffULL, 0x0000000265647825ULL, 0x100fe200078e0098ULL,
0x000000816c737211ULL, 0x000fe200078fe0ffULL, 0x0000000674797981ULL, 0x0002e4000c1e9500ULL,
0x0000000271707825ULL, 0x000fc400078e0098ULL, 0x0000000664627981ULL, 0x0002e4000c1e9500ULL,
0x0000000273727825ULL, 0x100fe400078e0098ULL, 0x0000000670807981ULL, 0x0002e4000c1e9500ULL,
0x000000027d747825ULL, 0x002fe400078e0098ULL, 0x0000000672d17981ULL, 0x0002e4000c1e9500ULL,
0x000000011d7d7824ULL, 0x000fc400078e02b3ULL, 0x0000000285647825ULL, 0x000fe200078e0098ULL,
0x0000000674d57981ULL, 0x0002e6000c1e9500ULL, 0x000000017d777824ULL, 0x000fe200078e0a1cULL,
0x0000000664847981ULL, 0x0002e2000c1e9500ULL, 0x00000001b3b57824ULL, 0x000fc600078e029aULL,
0x000000771e6e7217ULL, 0x040fe20003800000ULL, 0x00000001b5777824ULL, 0x000fe200078e0a1cULL,
0x0000001c7d00720cULL, 0x080fe40003f26070ULL, 0x00000004ff6e7819ULL, 0x000fe4000001166eULL,
0x0000001cb500720cULL, 0x000fe40003f06070ULL, 0x000000771e777217ULL, 0x000fe40003800000ULL,
0x000000ff6e787207ULL, 0x000fc40000800000ULL, 0x000000ff776e7207ULL, 0x000fc60000000000ULL,
0x000000017b757824ULL, 0x002fe200078e0278ULL, 0x0000007b6e777211ULL, 0x000fe200078fe0ffULL,
0x0000000178677824ULL, 0x000fe200078e0281ULL, 0x000000816e657211ULL, 0x000fe200078fe0ffULL,
0x0000000275747825ULL, 0x000fc800078e0098ULL, 0x0000000277767825ULL, 0x100fe200078e0098ULL,
0x00000006747a7981ULL, 0x0002e6000c1e9500ULL, 0x0000000267667825ULL, 0x100fe200078e0098ULL,
0x0000000676b77981ULL, 0x0002e6000c1e9500ULL, 0x0000000265647825ULL, 0x000fe200078e0098ULL,
0x0000000666827981ULL, 0x0002e2000c1e9500ULL, 0x0000007f6e737211ULL, 0x000fc600078fe0ffULL,
0x0000000664d37981ULL, 0x0002e2000c1e9500ULL, 0x0000000178717824ULL, 0x000fe400078e027fULL,
0x0000000273727825ULL, 0x000fc800078e0098ULL, 0x0000000271707825ULL, 0x000fe200078e0098ULL,
0x0000000672cf7981ULL, 0x0002e4000c1e9500ULL, 0x000000836e757211ULL, 0x002fe400078fe0ffULL,
0x00000006707e7981ULL, 0x0002e2000c1e9500ULL, 0x0000000178777824ULL, 0x000fe400078e0283ULL,
0x0000000275747825ULL, 0x000fc800078e0098ULL, 0x0000000277767825ULL, 0x000fe200078e0098ULL,
0x0000000674d77981ULL, 0x0002e8000c1e9500ULL, 0x0000000676867981ULL, 0x0002e2000c1e9500ULL,
0xfffffff05c657812ULL, 0x000fe200078ec0ffULL, 0x00000001ffcb7424ULL, 0x000fc800078e00ffULL,
0x000000011c5c7824ULL, 0x000fe200078e0265ULL, 0xfffffff06a657812ULL, 0x000fc600078ec0ffULL,
0x0000000153647824ULL, 0x000fe200078e0a5cULL, 0xfffffff06c737812ULL, 0x000fe200078ec0ffULL,
0x000000011c6c7824ULL, 0x000fe200078e0265ULL, 0x0000000151717812ULL, 0x002fe400078efcffULL,
0x00000064cb657219ULL, 0x000fc600000006ffULL, 0x0000000171677824ULL, 0x000fe200078e029aULL,
0x00000008517b7812ULL, 0x000fc600078efcffULL, 0x0000000167667824ULL, 0x000fe200078e0a5cULL,
0xfffffff06e777812ULL, 0x000fe200078ec0ffULL, 0x000000011c6e7824ULL, 0x000fe200078e0273ULL,
0x00000009517d7812ULL, 0x000fe400078efcffULL, 0x00000066cb737219ULL, 0x000fe200000006ffULL,
0x000000017b757824ULL, 0x100fe400078e029aULL, 0x000000017d7f7824ULL, 0x000fe400078e029aULL,
0x00000001756a7824ULL, 0x000fc400078e0a5cULL, 0x000000017f5c7824ULL, 0x000fe200078e0a5cULL,
0x0000001151857812ULL, 0x000fe200078efcffULL, 0x000000011c747824ULL, 0x000fe200078e0277ULL,
0x0000006acb777219ULL, 0x040fe400000006ffULL, 0x0000005ccb817219ULL, 0x000fe200000006ffULL,
0x0000000185877824ULL, 0x000fe400078e029aULL, 0x000000015d5c7824ULL, 0x100fe400078e0a6cULL,
0x0000000187647824ULL, 0x000fe200078e0a6cULL, 0x0000541055507816ULL, 0x010fc80000000050ULL,
0x0000005065ff7212ULL, 0x000fc800078ac0ffULL, 0x0000001c5300720cULL, 0x000fc80002fa1470ULL,
0x0000001c5100720cULL, 0x000fe40002fa1070ULL, 0x0000005073ff7212ULL, 0x000fe4000782c0ffULL,
0x0000541057527816ULL, 0x000fe40000000052ULL, 0xff80000003037808ULL, 0x000fe40002800000ULL,
0x0000005265ff7212ULL, 0x000fe4000784c0ffULL, 0x0000541059547816ULL, 0x000fc40000000054ULL,
0x0000005273ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005465ff7212ULL, 0x000fe4000788c0ffULL,
0x0000001c5300720cULL, 0x0c0fe40001741470ULL, 0x0000001c5300720cULL, 0x080fe40002781470ULL,
0x0000001c6700720cULL, 0x0c0fe40000f21470ULL, 0x0000001c6700720cULL, 0x000fc40002fa1470ULL,
0x0000001c5100720cULL, 0x0c0fe40001741070ULL, 0x0000001c5100720cULL, 0x080fe40002781070ULL,
0x0000001c7100720cULL, 0x0c0fe40000f21070ULL, 0x0000001c7100720cULL, 0x000fe40002fa1070ULL,
0x000054105f567816ULL, 0x000fe40000000056ULL, 0xff80000010107808ULL, 0x000fc40001000000ULL,
0xff80000031317808ULL, 0x000fe40002000000ULL, 0xff80000000007808ULL, 0x000fe40000800000ULL,
0xff80000018187808ULL, 0x000fe40002800000ULL, 0x0000005077ff7212ULL, 0x000fe4000786c0ffULL,
0x0000005665ff7212ULL, 0x000fe4000780c0ffULL, 0x0000005473ff7212ULL, 0x000fc4000784c0ffULL,
0x0000005673ff7212ULL, 0x000fe4000788c0ffULL, 0x0000005281ff7212ULL, 0x000fe4000782c0ffULL,
0x0000005477ff7212ULL, 0x000fe400078ac0ffULL, 0x0000001c5300720cULL, 0x080fe40000701470ULL,
0x0000001c6700720cULL, 0x0c0fe40001741470ULL, 0x0000001c6700720cULL, 0x000fc40002781470ULL,
0x0000001c7500720cULL, 0x0c0fe40001f61470ULL, 0x0000001c7500720cULL, 0x080fe40002fa1470ULL,
0x0000001c7f00720cULL, 0x080fe40000f21470ULL, 0x00000018518b7812ULL, 0x040fe400078efcffULL,
0x0000001951917812ULL, 0x040fe400078efcffULL, 0x0000001c5100720cULL, 0x000fc40000701070ULL,
0x0000001c7100720cULL, 0x0c0fe40001741070ULL, 0x0000001c7100720cULL, 0x080fe40002781070ULL,
0x0000001c7b00720cULL, 0x0c0fe40001f61070ULL, 0x0000001c7b00720cULL, 0x080fe40002fa1070ULL,
0x0000001c7d00720cULL, 0x000fe40000f21070ULL, 0x0000005ccb837219ULL, 0x000fc400000006ffULL,
0x00000064cb897219ULL, 0x000fe400000006ffULL, 0x0000541061587816ULL, 0x004fe40000000058ULL,
0x00005410635a7816ULL, 0x008fe2000000005aULL, 0x000000018b8d7824ULL, 0x100fe200078e029aULL,
0xff80000044447808ULL, 0x000fe20000000000ULL, 0x0000000191937824ULL, 0x000fe200078e029aULL,
0xff80000030307808ULL, 0x000fe40001000000ULL, 0xff80000048487808ULL, 0x000fc40002000000ULL,
0xff80000002027808ULL, 0x000fe40001800000ULL, 0xff80000032327808ULL, 0x000fe40002800000ULL,
0xff8000001b1b7808ULL, 0x000fe40000800000ULL, 0x0000005277ff7212ULL, 0x000fe4000780c0ffULL,
0x0000005481ff7212ULL, 0x000fe4000784c0ffULL, 0x0000005677ff7212ULL, 0x000fc4000788c0ffULL,
0x0000005681ff7212ULL, 0x000fe4000786c0ffULL, 0x0000005889ff7212ULL, 0x000fe400078ac0ffULL,
0x0000005a83ff7212ULL, 0x000fe2000782c0ffULL, 0x000000018d667824ULL, 0x100fe200078e0a6cULL,
0x0000001c7500720cULL, 0x080fe20000701470ULL, 0x00000001936c7824ULL, 0x000fe200078e0a6cULL,
0x0000001c7500720cULL, 0x080fe40002781470ULL, 0x0000001c7f00720cULL, 0x000fc40001741470ULL,
0x0000001c7f00720cULL, 0x080fe40001f61470ULL, 0x0000001c5d00720cULL, 0x080fe40000f21470ULL,
0x0000001c8700720cULL, 0x080fe40002fa1470ULL, 0x0000001c7b00720cULL, 0x0c0fe40000701070ULL,
0x0000001c7b00720cULL, 0x080fe40002781070ULL, 0x0000001c7d00720cULL, 0x000fc40001741070ULL,
0x0000001c7d00720cULL, 0x080fe40001f61070ULL, 0x0000001c5b00720cULL, 0x080fe40000f21070ULL,
0x0000001c8500720cULL, 0x000fe40002fa1070ULL, 0x00000066cb8f7219ULL, 0x040fe400000006ffULL,
0x0000006ccb957219ULL, 0x000fe400000006ffULL, 0x00005410695e7816ULL, 0x000fc4000000005eULL,
0x000054106f607816ULL, 0x000fe40000000060ULL, 0xff80000019197808ULL, 0x000fe40000000000ULL,
0xff80000049497808ULL, 0x000fe40002000000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff8000004b4b7808ULL, 0x000fe40001800000ULL, 0xff80000024247808ULL, 0x000fc40000800000ULL,
0xff8000000a0a7808ULL, 0x000fe40002800000ULL, 0x0000005883ff7212ULL, 0x080fe4000780c0ffULL,
0x000000588fff7212ULL, 0x000fe4000788c0ffULL, 0x0000005e83ff7212ULL, 0x040fe4000784c0ffULL,
0x0000006083ff7212ULL, 0x000fe4000786c0ffULL, 0x0000005e89ff7212ULL, 0x000fc4000782c0ffULL,
0x0000005a95ff7212ULL, 0x000fe200078ac0ffULL, 0x000000016d6a7824ULL, 0x000fe200078e0a6eULL,
0x0000001c5d00720cULL, 0x0c0fe40000701470ULL, 0x0000001c5d00720cULL, 0x0c0fe40001741470ULL,
0x0000001c5d00720cULL, 0x080fe40001f61470ULL, 0x0000001c8700720cULL, 0x080fe40000f21470ULL,
0x0000001c8d00720cULL, 0x000fc40002781470ULL, 0x0000001c9300720cULL, 0x080fe40002fa1470ULL,
0x0000002151a17812ULL, 0x000fe400078efcffULL, 0x0000001c5b00720cULL, 0x0c0fe40000701070ULL,
0x0000001c5b00720cULL, 0x0c0fe40001741070ULL, 0x0000001c5b00720cULL, 0x080fe40001f61070ULL,
0x0000001c8500720cULL, 0x000fc40000f21070ULL, 0x0000001c8b00720cULL, 0x080fe40002781070ULL,
0x0000001c9100720cULL, 0x000fe40002fa1070ULL, 0x0000006acb9f7219ULL, 0x000fe400000006ffULL,
0x00005410cd687816ULL, 0x000fe20000000068ULL, 0x00000001a1a37824ULL, 0x000fe200078e029aULL,
0xff80000009097808ULL, 0x000fe40000000000ULL, 0xff80000034347808ULL, 0x000fc40001000000ULL,
0xff8000004c4c7808ULL, 0x000fe40001800000ULL, 0xff80000035357808ULL, 0x000fe40000800000ULL,
0xff8000000b0b7808ULL, 0x000fe40002000000ULL, 0xff80000027277808ULL, 0x000fe40002800000ULL,
0x0000005a89ff7212ULL, 0x040fe4000780c0ffULL, 0x0000006089ff7212ULL, 0x000fc4000784c0ffULL,
0x0000005a8fff7212ULL, 0x000fe4000786c0ffULL, 0x0000005e95ff7212ULL, 0x040fe4000782c0ffULL,
0x0000006095ff7212ULL, 0x000fe4000788c0ffULL, 0x000000689fff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a3707824ULL, 0x000fe200078e0a6eULL, 0x0000001c8700720cULL, 0x0c0fe40000701470ULL,
0x0000001c8700720cULL, 0x000fc40001741470ULL, 0x0000001c8d00720cULL, 0x080fe40001f61470ULL,
0x0000001c9300720cULL, 0x0c0fe40000f21470ULL, 0x0000001c9300720cULL, 0x080fe40002781470ULL,
0x0000001c6d00720cULL, 0x000fe40002fa1470ULL, 0x0000002851a77812ULL, 0x040fe400078efcffULL,
0x0000002951ad7812ULL, 0x000fc400078efcffULL, 0x0000001c8500720cULL, 0x0c0fe40000701070ULL,
0x0000001c8500720cULL, 0x080fe40001741070ULL, 0x0000001c8b00720cULL, 0x080fe40001f61070ULL,
0x0000001c9100720cULL, 0x0c0fe40000f21070ULL, 0x0000001c9100720cULL, 0x080fe40002781070ULL,
0x0000001c6b00720cULL, 0x000fc40002fa1070ULL, 0x00000070cba57219ULL, 0x000fe400000006ffULL,
0x0000541079627816ULL, 0x000fe40000000062ULL, 0x00005410d1807816ULL, 0x000fe40000000080ULL,
0x00005410d5847816ULL, 0x000fe20000000084ULL, 0x00000001a7a97824ULL, 0x100fe200078e029aULL,
0xff80000025257808ULL, 0x000fe20000000000ULL, 0x00000001adaf7824ULL, 0x000fe200078e029aULL,
0xff8000004e4e7808ULL, 0x000fc40001000000ULL, 0xff80000026267808ULL, 0x000fe40001800000ULL,
0xff80000037377808ULL, 0x000fe40000800000ULL, 0xff8000004d4d7808ULL, 0x000fe40002000000ULL,
0xff80000028287808ULL, 0x000fe40002800000ULL, 0x0000005081ff7212ULL, 0x000fe400078cc0ffULL,
0x0000005e8fff7212ULL, 0x000fc4000780c0ffULL, 0x000000608fff7212ULL, 0x000fe4000784c0ffULL,
0x000000629fff7212ULL, 0x040fe4000786c0ffULL, 0x000000809fff7212ULL, 0x040fe4000782c0ffULL,
0x000000849fff7212ULL, 0x000fe4000788c0ffULL, 0x00000080a5ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a9727824ULL, 0x100fe200078e0a6eULL, 0x0000001c7f00720cULL, 0x080fe200037c1470ULL,
0x00000001af6e7824ULL, 0x000fe200078e0a6eULL, 0x0000001c8d00720cULL, 0x000fc40000701470ULL,
0x0000001c8d00720cULL, 0x080fe40001741470ULL, 0x0000001c6d00720cULL, 0x0c0fe40001f61470ULL,
0x0000001c6d00720cULL, 0x0c0fe40000f21470ULL, 0x0000001c6d00720cULL, 0x080fe40002781470ULL,
0x0000001ca300720cULL, 0x080fe40002fa1470ULL, 0x0000001c7d00720cULL, 0x000fc400037c1070ULL,
0x0000001c8b00720cULL, 0x0c0fe40000701070ULL, 0x0000001c8b00720cULL, 0x080fe40001741070ULL,
0x0000001c6b00720cULL, 0x0c0fe40001f61070ULL, 0x0000001c6b00720cULL, 0x0c0fe40000f21070ULL,
0x0000001c6b00720cULL, 0x080fe40002781070ULL, 0x0000001ca100720cULL, 0x000fc40002fa1070ULL,
0x00000072cbab7219ULL, 0x040fe400000006ffULL, 0x0000006ecbb17219ULL, 0x000fe400000006ffULL,
0xff80000008087808ULL, 0x000fe40003000000ULL, 0xff80000036367808ULL, 0x000fe40000000000ULL,
0xff8000004f4f7808ULL, 0x000fe40001000000ULL, 0xff8000000f0f7808ULL, 0x000fc40001800000ULL,
0xff80000038387808ULL, 0x000fe40000800000ULL, 0xff8000004a4a7808ULL, 0x000fe40002000000ULL,
0xff80000039397808ULL, 0x000fe40002800000ULL, 0x0000005895ff7212ULL, 0x000fe400078cc0ffULL,
0x00000062a5ff7212ULL, 0x080fe4000780c0ffULL, 0x00000062abff7212ULL, 0x000fc4000784c0ffULL,
0x00000068a5ff7212ULL, 0x040fe4000786c0ffULL, 0x00000084a5ff7212ULL, 0x000fe4000782c0ffULL,
0x00000068abff7212ULL, 0x000fe4000788c0ffULL, 0x00000080b1ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b5767824ULL, 0x000fe200078e0a74ULL, 0x0000001c9300720cULL, 0x080fe400037c1470ULL,
0x0000001ca300720cULL, 0x000fc40000701470ULL, 0x0000001ca300720cULL, 0x0c0fe40001f61470ULL,
0x0000001ca300720cULL, 0x080fe40000f21470ULL, 0x0000001ca900720cULL, 0x0c0fe40001741470ULL,
0x0000001ca900720cULL, 0x080fe40002781470ULL, 0x0000001caf00720cULL, 0x000fe40002fa1470ULL,
0x0000003151bb7812ULL, 0x000fc400078efcffULL, 0x0000003851c17812ULL, 0x040fe400078efcffULL,
0x0000003951c77812ULL, 0x000fe400078efcffULL, 0x0000001c9100720cULL, 0x080fe400037c1070ULL,
0x0000001ca100720cULL, 0x0c0fe40000701070ULL, 0x0000001ca100720cULL, 0x0c0fe40001f61070ULL,
0x0000001ca100720cULL, 0x000fc40000f21070ULL, 0x0000001ca700720cULL, 0x0c0fe40001741070ULL,
0x0000001ca700720cULL, 0x080fe40002781070ULL, 0x0000001cad00720cULL, 0x000fe40002fa1070ULL,
0x00000076cbb97219ULL, 0x000fe400000006ffULL, 0x00005410b77a7816ULL, 0x000fe4000000007aULL,
0x00005410d3827816ULL, 0x000fe20000000082ULL, 0x00000001bbbd7824ULL, 0x100fe200078e029aULL,
0xff8000000d0d7808ULL, 0x000fe20003000000ULL, 0x00000001c1c37824ULL, 0x100fe200078e029aULL,
0xff80000013137808ULL, 0x000fe20000000000ULL, 0x00000001c7c97824ULL, 0x000fe200078e029aULL,
0xff80000029297808ULL, 0x000fc40001800000ULL, 0xff8000003b3b7808ULL, 0x000fe40000800000ULL,
0xff80000017177808ULL, 0x000fe40001000000ULL, 0xff8000002a2a7808ULL, 0x000fe40002000000ULL,
0xff8000003c3c7808ULL, 0x000fe40002800000ULL, 0x00000062b1ff7212ULL, 0x040fe400078cc0ffULL,
0x00000068b1ff7212ULL, 0x000fc4000780c0ffULL, 0x00000080abff7212ULL, 0x040fe4000786c0ffULL,
0x00000084abff7212ULL, 0x080fe4000782c0ffULL, 0x00000084b1ff7212ULL, 0x000fe4000784c0ffULL,
0x0000007ab9ff7212ULL, 0x040fe4000788c0ffULL, 0x00000082b9ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001bd787824ULL, 0x100fe200078e0a74ULL, 0x0000001ca900720cULL, 0x080fe20001f61470ULL,
0x00000001c37c7824ULL, 0x100fe200078e0a74ULL, 0x0000001ca900720cULL, 0x080fe20000f21470ULL,
0x00000001c9747824ULL, 0x000fe200078e0a74ULL, 0x0000001caf00720cULL, 0x000fc400037c1470ULL,
0x0000001caf00720cULL, 0x0c0fe40000701470ULL, 0x0000001caf00720cULL, 0x080fe40001741470ULL,
0x0000001cb500720cULL, 0x0c0fe40002781470ULL, 0x0000001cb500720cULL, 0x000fe40002fa1470ULL,
0x00000078cbbf7219ULL, 0x040fe400000006ffULL, 0x0000007ccbc57219ULL, 0x000fc400000006ffULL,
0x0000001ca700720cULL, 0x0c0fe40001f61070ULL, 0x0000001ca700720cULL, 0x080fe40000f21070ULL,
0x0000001cad00720cULL, 0x0c0fe400037c1070ULL, 0x0000001cad00720cULL, 0x0c0fe40000701070ULL,
0x0000001cad00720cULL, 0x080fe40001741070ULL, 0x0000001cb300720cULL, 0x000fc40002781070ULL,
0x0000001cb300720cULL, 0x000fe40002fa1070ULL, 0x00000074cbcb7219ULL, 0x000fe400000006ffULL,
0x00005410cf7e7816ULL, 0x000fe4000000007eULL, 0xff8000003a3a7808ULL, 0x000fe40001800000ULL,
0xff8000003d3d7808ULL, 0x000fe40000800000ULL, 0xff80000015157808ULL, 0x000fc40003000000ULL,
0xff8000002b2b7808ULL, 0x000fe40000000000ULL, 0xff8000003e3e7808ULL, 0x000fe40001000000ULL,
0xff80000016167808ULL, 0x000fe40002000000ULL, 0xff8000003f3f7808ULL, 0x000fe40002800000ULL,
0x0000007abfff7212ULL, 0x080fe4000786c0ffULL, 0x0000007ac5ff7212ULL, 0x000fc4000782c0ffULL,
0x0000007acbff7212ULL, 0x000fe400078cc0ffULL, 0x0000007eb9ff7212ULL, 0x080fe4000780c0ffULL,
0x0000007ebfff7212ULL, 0x080fe4000784c0ffULL, 0x0000007ec5ff7212ULL, 0x000fe4000788c0ffULL,
0x00000082bfff7212ULL, 0x000fe400078ac0ffULL, 0x0000001cb500720cULL, 0x000fc40000701470ULL,
0x0000001cbd00720cULL, 0x0c0fe40001f61470ULL, 0x0000001cbd00720cULL, 0x0c0fe40001741470ULL,
0x0000001cbd00720cULL, 0x080fe40002fa1470ULL, 0x0000001cc300720cULL, 0x080fe40000f21470ULL,
0x0000001cc900720cULL, 0x080fe400037c1470ULL, 0x0000001cc300720cULL, 0x000fc40002781470ULL,
0x0000001cb300720cULL, 0x080fe40000701070ULL, 0x0000001cbb00720cULL, 0x0c0fe40001f61070ULL,
0x0000001cbb00720cULL, 0x0c0fe40001741070ULL, 0x0000001cbb00720cULL, 0x080fe40002fa1070ULL,
0x0000001cc100720cULL, 0x080fe40000f21070ULL, 0x0000001cc700720cULL, 0x000fc400037c1070ULL,
0x0000001cc100720cULL, 0x000fe40002781070ULL, 0x00005410d7867816ULL, 0x000fe40000000086ULL,
0xff8000002c2c7808ULL, 0x000fe40000000000ULL, 0xff80000011117808ULL, 0x000fe40001800000ULL,
0xff8000002d2d7808ULL, 0x000fe40001000000ULL, 0xff80000040407808ULL, 0x000fc40002800000ULL,
0xff80000012127808ULL, 0x000fe40000800000ULL, 0xff80000014147808ULL, 0x000fe40003000000ULL,
0xff8000002e2e7808ULL, 0x000fe40002000000ULL, 0x0000007ecbff7212ULL, 0x000fe4000780c0ffULL,
0x00000082c5ff7212ULL, 0x080fe4000786c0ffULL, 0x00000082cbff7212ULL, 0x000fc4000784c0ffULL,
0x00000086b9ff7212ULL, 0x080fe400078ac0ffULL, 0x00000086bfff7212ULL, 0x080fe4000782c0ffULL,
0x00000086c5ff7212ULL, 0x080fe400078cc0ffULL, 0x00000086cbff7212ULL, 0x000fe4000788c0ffULL,
0x0000001cb500720cULL, 0x080fe40002fa1470ULL, 0x0000001cbd00720cULL, 0x000fc40000f21470ULL,
0x0000001cc300720cULL, 0x0c0fe40001f61470ULL, 0x0000001cc300720cULL, 0x080fe400037c1470ULL,
0x0000001cc900720cULL, 0x0c0fe40000701470ULL, 0x0000001cc900720cULL, 0x0c0fe40001741470ULL,
0x0000001cc900720cULL, 0x080fe40002781470ULL, 0x0000001cb300720cULL, 0x000fc40002fa1070ULL,
0x0000001cbb00720cULL, 0x080fe40000f21070ULL, 0x0000001cc700720cULL, 0x080fe40000701070ULL,
0x0000001cc100720cULL, 0x0c0fe40001f61070ULL, 0x0000001cc100720cULL, 0x080fe400037c1070ULL,
0x0000001cc700720cULL, 0x0c0fe40001741070ULL, 0x0000001cc700720cULL, 0x000fc40002781070ULL,
0xff8000002f2f7808ULL, 0x000fe40000000000ULL, 0xff80000042427808ULL, 0x000fe40001800000ULL,
0xff80000045457808ULL, 0x000fe40001000000ULL, 0xff80000041417808ULL, 0x000fe40002800000ULL,
0xff80000043437808ULL, 0x000fe40000800000ULL, 0xff80000046467808ULL, 0x000fc40003000000ULL,
0xff80000047477808ULL, 0x000fc40002000000ULL, 0x000000030400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff587424ULL, 0x000fe200078e00ffULL, 0x000000100500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff597424ULL, 0x000fe200078e00ffULL, 0x000000310600720bULL, 0x000fe40003f5e000ULL,
0x000000440700720bULL, 0x000fe40003f7e000ULL, 0x0000000403517208ULL, 0x000fe40004000000ULL,
0x0000000510057208ULL, 0x000fc40004800000ULL, 0x0000000631537208ULL, 0x000fe40005000000ULL,
0x0000000744077208ULL, 0x000fe40005800000ULL, 0x000000005100720bULL, 0x000fe40003f1e000ULL,
0x000000180500720bULL, 0x000fe40003f3e000ULL, 0x000000305300720bULL, 0x000fe40003f5e000ULL,
0x000000480700720bULL, 0x000fc40003f7e000ULL, 0x0000005100517208ULL, 0x000fe40004000000ULL,
0x0000000518047208ULL, 0x000fe40004800000ULL, 0x0000005330537208ULL, 0x000fe40005000000ULL,
0x0000000748067208ULL, 0x000fe40005800000ULL, 0x000000025100720bULL, 0x000fe40003f1e000ULL,
0x000000190400720bULL, 0x000fc40003f3e000ULL, 0x000000325300720bULL, 0x000fe40003f5e000ULL,
0x000000490600720bULL, 0x000fe40003f7e000ULL, 0x0000005102517208ULL, 0x000fe40004000000ULL,
0x0000000419047208ULL, 0x000fe40004800000ULL, 0x00000053321c7208ULL, 0x000fe40005000000ULL,
0x0000000649067208ULL, 0x000fc40005800000ULL, 0x000000085100720bULL, 0x000fe40003f1e000ULL,
0x0000001b0400720bULL, 0x000fe40003f3e000ULL, 0x000000331c00720bULL, 0x000fe40003f5e000ULL,
0x0000004b0600720bULL, 0x000fe40003f7e000ULL, 0x0000005108507208ULL, 0x000fe40004000000ULL,
0x000000041b057208ULL, 0x000fc40004800000ULL, 0x0000001c33077208ULL, 0x000fe40005000000ULL,
0x000000064b517208ULL, 0x000fe40005800000ULL, 0x000000240500720bULL, 0x000fe40003f3e000ULL,
0x000000095000720bULL, 0x000fe40003f1e000ULL, 0x000000340700720bULL, 0x000fe40003f5e000ULL,
0x0000004c5100720bULL, 0x000fc40003f7e000ULL, 0x0000000524047208ULL, 0x000fe40004800000ULL,
0x0000005009537208ULL, 0x000fe40004000000ULL, 0x0000000734067208ULL, 0x000fe40005000000ULL,
0x000000514c517208ULL, 0x000fe40005800000ULL, 0x000000250400720bULL, 0x000fe40003f3e000ULL,
0x0000000a5300720bULL, 0x000fc40003f1e000ULL, 0x000000350600720bULL, 0x000fe40003f5e000ULL,
0x0000004e5100720bULL, 0x000fe40003f7e000ULL, 0x0000000425057208ULL, 0x000fe40004800000ULL,
0x000000530a1c7208ULL, 0x000fe40004000000ULL, 0x0000000635077208ULL, 0x000fe40005000000ULL,
0x000000514e047208ULL, 0x000fc40005800000ULL, 0x000000260500720bULL, 0x000fe40003f3e000ULL,
0x0000000b1c00720bULL, 0x000fe40003f1e000ULL, 0x000000360700720bULL, 0x000fe40003f5e000ULL,
0x0000004f0400720bULL, 0x000fe40003f7e000ULL, 0x0000000526067208ULL, 0x000fe40004800000ULL,
0x0000001c0b1c7208ULL, 0x000fc40004000000ULL, 0x0000000736507208ULL, 0x000fe40005000000ULL,
0x000000044f047208ULL, 0x000fe40005800000ULL, 0x000000270600720bULL, 0x000fe40003f3e000ULL,
0x0000000d1c00720bULL, 0x000fe40003f1e000ULL, 0x000000375000720bULL, 0x000fe40003f5e000ULL,
0x0000004d0400720bULL, 0x000fc40003f7e000ULL, 0x0000000627057208ULL, 0x000fe40004800000ULL,
0x0000001c0d1c7208ULL, 0x000fe40004000000ULL, 0x0000005037077208ULL, 0x000fe40005000000ULL,
0x000000044d517208ULL, 0x000fe40005800000ULL, 0x000000280500720bULL, 0x000fe40003f3e000ULL,
0x0000000f1c00720bULL, 0x000fc40003f1e000ULL, 0x000000380700720bULL, 0x000fe40003f5e000ULL,
0x0000004a5100720bULL, 0x000fe40003f7e000ULL, 0x0000000528047208ULL, 0x000fe40004800000ULL,
0x0000001c0f1c7208ULL, 0x000fe40004000000ULL, 0x0000000738067208ULL, 0x000fe40005000000ULL,
0x000000514a507208ULL, 0x000fc40005800000ULL, 0x000000290400720bULL, 0x000fe40003f3e000ULL,
0x000000131c00720bULL, 0x000fe40003f1e000ULL, 0x000000390600720bULL, 0x000fe40003f5e000ULL,
0x0000003b5000720bULL, 0x000fe40003f7e000ULL, 0x0000000429057208ULL, 0x000fe40004800000ULL,
0x0000001c131c7208ULL, 0x000fc40004000000ULL, 0x0000000639077208ULL, 0x000fe40005000000ULL,
0x000000503b507208ULL, 0x000fe40005800000ULL, 0x0000002a0500720bULL, 0x000fe40003f3e000ULL,
0x000000171c00720bULL, 0x000fe40003f1e000ULL, 0x0000003a0700720bULL, 0x000fe40003f5e000ULL,
0x0000003d5000720bULL, 0x000fc40003f7e000ULL, 0x000000052a047208ULL, 0x000fe40004800000ULL,
0x0000001c171c7208ULL, 0x000fe40004000000ULL, 0x000000073a077208ULL, 0x000fe40005000000ULL,
0x000000503d057208ULL, 0x000fe40005800000ULL, 0x0000002b0400720bULL, 0x000fe40003f3e000ULL,
0x000000151c00720bULL, 0x000fc40003f1e000ULL, 0x0000003c0700720bULL, 0x000fe40003f5e000ULL,
0x0000003e0500720bULL, 0x000fe40003f7e000ULL, 0x000000042b537208ULL, 0x000fe40004800000ULL,
0x0000001c15517208ULL, 0x000fe40004000000ULL, 0x000000073c047208ULL, 0x000fe40005000000ULL,
0x000000053e067208ULL, 0x000fc40005800000ULL, 0x000000165100720bULL, 0x000fe40003f1e000ULL,
0x0000002c5300720bULL, 0x000fe40003f3e000ULL, 0x0000003f0400720bULL, 0x000fe40003f5e000ULL,
0x000000410600720bULL, 0x000fe40003f7e000ULL, 0x00000051161c7208ULL, 0x000fe40004000000ULL,
0x000000532c507208ULL, 0x000fc40004800000ULL, 0x000000043f057208ULL, 0x000fe40005000000ULL,
0x0000000641067208ULL, 0x000fe40005800000ULL, 0x000000111c00720bULL, 0x000fe40003f1e000ULL,
0x0000002d5000720bULL, 0x000fe40003f3e000ULL, 0x000000400500720bULL, 0x000fe40003f5e000ULL,
0x000000430600720bULL, 0x000fc40003f7e000ULL, 0x0000001c11077208ULL, 0x000fe40004000000ULL,
0x000000502d517208ULL, 0x000fe40004800000ULL, 0x0000000540057208ULL, 0x000fe40005000000ULL,
0x0000000643537208ULL, 0x000fe40005800000ULL, 0x000000120700720bULL, 0x000fe40003f1e000ULL,
0x0000002e5100720bULL, 0x000fc40003f3e000ULL, 0x000000420500720bULL, 0x000fe40003f5e000ULL,
0x000000465300720bULL, 0x000fe40003f7e000ULL, 0x0000000712077208ULL, 0x000fe40004000000ULL,
0x000000512e047208ULL, 0x000fe40004800000ULL, 0x0000000542067208ULL, 0x000fe40005000000ULL,
0x00000053461c7208ULL, 0x000fc40005800000ULL, 0x000000140700720bULL, 0x000fe40003f1e000ULL,
0x0000002f0400720bULL, 0x000fe40003f3e000ULL, 0x000000450600720bULL, 0x000fe40003f5e000ULL,
0x000000471c00720bULL, 0x000fe40003f7e000ULL, 0x0000000714077208ULL, 0x000fe40004000000ULL,
0x000000042f527208ULL, 0x000fc40004800000ULL, 0x0000000645567208ULL, 0x000fe40005000000ULL,
0x0000001c47537208ULL, 0x000fe20005800000ULL, 0x00001fe27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0007047f89ULL, 0x0004e400000e0000ULL, 0x000000040700720bULL, 0x008fc80003f1e000ULL,
0x0000000704577208ULL, 0x000fe20004000000ULL, 0x00001ff27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0052047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0056057f89ULL, 0x000f2800000e0000ULL,
0x0c401f0053067f89ULL, 0x000e6200000e0000ULL, 0x000000045200720bULL, 0x008fc40003f1e000ULL,
0x000000055600720bULL, 0x010fe40003f3e000ULL, 0x0000005204077208ULL, 0x006fe40004000000ULL,
0x00000056051c7208ULL, 0x000fe20004800000ULL, 0x0c201f0057047f89ULL, 0x000e6200000e0000ULL,
0x000000065300720bULL, 0x000fc60003f1e000ULL, 0x0c201f0007507f89ULL, 0x000ea200000e0000ULL,
0x0000005306547208ULL, 0x000fc60004000000ULL, 0x0c201f001c517f89ULL, 0x000ee800000e0000ULL,
0x0c201f0054557f89ULL, 0x0002e400000e0000ULL, 0x000000045700720bULL, 0x002fe40003f1e000ULL,
0x000000500700720bULL, 0x004fe40003f3e000ULL, 0x0000005704047208ULL, 0x000fc40004000000ULL,
0x000000511c00720bULL, 0x008fe40003f5e000ULL, 0x0000000750057208ULL, 0x000fe40004800000ULL,
0x0000001c51067208ULL, 0x000fc60005000000ULL, 0x3fb8aa3b05077820ULL, 0x002fe20000410000ULL,
0x3fb8aa3b04507820ULL, 0x000fe20000410000ULL, 0x000000555400720bULL, 0x004fe20003f1e000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2f077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b11537823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b06117820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b00007823ULL, 0x100fe20000010850ULL,
0x0000000700667308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b03037823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b02027823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b09097823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b08087823ULL, 0x100fe20000010850ULL,
0x0000000000567308ULL, 0x0005e20000000800ULL, 0x0000005455077208ULL, 0x002fe20004000000ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010811ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010811ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010811ULL,
0x00000024005c7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b0f007823ULL, 0x104fe20000010850ULL,
0x3fb8aa3b130f7823ULL, 0x000fe20000010850ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010811ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010811ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe20000010811ULL,
0x0000003000137308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b07247820ULL, 0x002fe20000410000ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010811ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b49497823ULL, 0x000fe20000010824ULL, 0x3fb8aa3b45117823ULL, 0x000fe20000010811ULL,
0x0000000300037308ULL, 0x000fe20000000800ULL, 0x00000002ff307819ULL, 0x004fe20000011620ULL,
0x3fb8aa3b48487823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b4b4b7823ULL, 0x000fe20000010824ULL,
0x3fb8aa3b15517823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010850ULL,
0x0000000830157824ULL, 0x040fe200078e00ffULL, 0x3fb8aa3b171c7823ULL, 0x000fe20000010850ULL,
0x0000000900587308ULL, 0x000fe20000000800ULL, 0x0000000830687824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010824ULL, 0x0000000830177824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b4e4e7823ULL, 0x000fe20000010824ULL, 0x00000008306c7824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b16527823ULL, 0x000fe20000010850ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010824ULL,
0x0000000d005b7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b43437823ULL, 0x000fe20000010824ULL,
0x0000000200027308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b120d7823ULL, 0x102fe20000010850ULL,
0x3fb8aa3b14507823ULL, 0x000fe20000010850ULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b47477823ULL, 0x000fe20000010824ULL, 0x0000000320ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000800577308ULL, 0x0003f00000000800ULL, 0x0000000b005a7308ULL, 0x000fe20000000800ULL,
0x0000000130087810ULL, 0x002fce0007ffe0ffULL, 0x0000001000097308ULL, 0x000ff00000000800ULL,
0x0000001800187308ULL, 0x000e700000000800ULL, 0x00000019000b7308ULL, 0x000ff00000000800ULL,
0x0000001b00127308ULL, 0x000ea20000000800ULL, 0x000000091809723eULL, 0x002fce00000000ffULL,
0x00000026005d7308ULL, 0x000ff00000000800ULL, 0x00000027005e7308ULL, 0x000fe20000000800ULL,
0x0000000b120b723eULL, 0x004fce00000000ffULL, 0x0000003100107308ULL, 0x0002b00000000800ULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x0000000830317810ULL, 0x002fce0007ffe0ffULL,
0x0000003300337308ULL, 0x000e620000000800ULL, 0x000000101310723eULL, 0x004fce00000000ffULL,
0x0000001100457308ULL, 0x0005f00000000800ULL, 0x0000004400447308ULL, 0x000fe20000000800ULL,
0x0000000330117810ULL, 0x044fe40007ffe0ffULL, 0x000000323312723eULL, 0x002fe200000000ffULL,
0x0000000830337824ULL, 0x000fe200078e00ffULL, 0xfffffff868687812ULL, 0x000fc400078ee211ULL,
0x0000000630117810ULL, 0x040fe20007ffe0ffULL, 0x0000004800277308ULL, 0x0003e20000000800ULL,
0x0000001030327810ULL, 0x000fe40007ffe0ffULL, 0xfffffff86c6c7812ULL, 0x000fe400078ee211ULL,
0xffffffff30117810ULL, 0x000fc60007ffe0ffULL, 0x0000004900497308ULL, 0x000fe20000000800ULL,
0xfffffff815487812ULL, 0x002fe400078ee208ULL, 0x0000000430087810ULL, 0x000fca0007ffe0ffULL,
0x0000004b00267308ULL, 0x000e700000000800ULL, 0x0000000a00597308ULL, 0x0004f00000000800ULL,
0x0000002d00647308ULL, 0x000fe20000000800ULL, 0x00000002300a7810ULL, 0x004fc40007ffe0ffULL,
0x000000492613723eULL, 0x002fe400000000ffULL, 0xfffffff817547812ULL, 0x000fe400078ee20aULL,
0x00000005300a7810ULL, 0x000fe20007ffe0ffULL, 0x0000004c002d7308ULL, 0x0003e20000000800ULL,
0x000000585924723eULL, 0x008fe400000000ffULL, 0xfffffff8176a7812ULL, 0x000fe400078ee20aULL,
0x00000002570a723eULL, 0x000fe200000000ffULL, 0x3c003c00ff027424ULL, 0x000fe200078e00ffULL,
0x0000005a5b26723eULL, 0x000fe200000000ffULL, 0x0000002800197308ULL, 0x000fe20000000800ULL,
0xfffffff8154c7812ULL, 0x002fc400078ee208ULL, 0x000000035608723eULL, 0x000fe200000000ffULL,
0x0000000830567824ULL, 0x000fe200078e00ffULL, 0x0000000c1a497812ULL, 0x000fe200078ec0ffULL,
0x3c003c00ff037424ULL, 0x000fe400078e00ffULL, 0x0000002900607308ULL, 0x000e620000000800ULL,
0xfffffff856567812ULL, 0x000fe400078ee211ULL, 0x000000442711723eULL, 0x000fe200000000ffULL,
0x0000000831447824ULL, 0x000fe200078e00ffULL, 0x000000020814723cULL, 0x000f6200000018ffULL,
0x0000005d5e27723eULL, 0x000fc400000000ffULL, 0x0000002a001b7308ULL, 0x000fe20000000800ULL,
0xfffffff844447812ULL, 0x000fce00078ee231ULL, 0x0000002b00627308ULL, 0x0005e20000000800ULL,
0x000000196031723eULL, 0x002fce00000000ffULL, 0x0000002500257308ULL, 0x000e620000000800ULL,
0x000000021028723cULL, 0x004f6e00000018ffULL, 0x0000002c005f7308ULL, 0x000ff00000000800ULL,
0x0000002e00617308ULL, 0x000fe20000000800ULL, 0x0000005c2525723eULL, 0x002fce00000000ffULL,
0x00000034002c7308ULL, 0x000fe20000000800ULL, 0x000000022414723cULL, 0x020f6e0000001814ULL,
0x0000003500357308ULL, 0x000e700000000800ULL, 0x00000036002e7308ULL, 0x000ff00000000800ULL,
0x0000003700377308ULL, 0x000ea20000000800ULL, 0x0000002c352c723eULL, 0x002fce00000000ffULL,
0x0000004e004e7308ULL, 0x000e700000000800ULL, 0x0000004f002f7308ULL, 0x000fe20000000800ULL,
0x0000002e372e723eULL, 0x004fe400000000ffULL, 0x000000616637723eULL, 0x000fca00000000ffULL,
0x0000004d00187308ULL, 0x000ea20000000800ULL, 0x0000002d4e2d723eULL, 0x002fce00000000ffULL,
0x0000003800387308ULL, 0x000fe20000000800ULL, 0x0000002f182f723eULL, 0x004fce00000000ffULL,
0x0000003900397308ULL, 0x000e620000000800ULL, 0x000000022c28723cULL, 0x000f6e0000001828ULL,
0x0000000000007308ULL, 0x000ff00000000800ULL, 0x0000000f000f7308ULL, 0x000fe20000000800ULL,
0x000000383938723eULL, 0x002fce00000000ffULL, 0x0000001c001c7308ULL, 0x000ff00000000800ULL,
0x0000005100517308ULL, 0x000ff00000000800ULL, 0x0000004a004a7308ULL, 0x000ff00000000800ULL,
0x0000003b003b7308ULL, 0x000e700000000800ULL, 0x0000003a003a7308ULL, 0x000ff00000000800ULL,
0x0000003c00637308ULL, 0x0004e20000000800ULL, 0x0000004a3b39723eULL, 0x002fce00000000ffULL,
0x0000003d003d7308ULL, 0x000fe20000000800ULL, 0xfffffff8333c7812ULL, 0x004fe200078ee230ULL,
0x0000000832337824ULL, 0x000fe200078e00ffULL, 0x0000001830307810ULL, 0x000fc80007ffe0ffULL,
0xfffffff8334e7812ULL, 0x000fe200078ee232ULL, 0x0000003e003e7308ULL, 0x000e620000000800ULL,
0x0000000830357824ULL, 0x000fe200078e00ffULL, 0x0000001c5132723eULL, 0x000fe400000000ffULL,
0x0000001b6233723eULL, 0x000fe400000000ffULL, 0xfffffff835587812ULL, 0x000fe400078ee230ULL,
0x0000000d000d7308ULL, 0x000fe20000000800ULL, 0x000000000f30723eULL, 0x000fc400000000ffULL,
0x0000003a633a723eULL, 0x008fe400000000ffULL, 0x0000005f6435723eULL, 0x000fc600000000ffULL,
0x0000005000507308ULL, 0x000ea20000000800ULL, 0x0000003d3e3b723eULL, 0x002fe200000000ffULL,
0x000000023014723cULL, 0x0a0f6c0000001814ULL, 0x0000005200527308ULL, 0x000fe40000000800ULL,
0x000000023828723cULL, 0x000fec0000001828ULL, 0x0000005300537308ULL, 0x000e620000000800ULL,
0x0000000d5036723eULL, 0x004fc400000000ffULL, 0x0000a000970d7811ULL, 0x000fca00078e60ffULL,
0x0000003f003f7308ULL, 0x000fe20000000800ULL, 0x000000103c0f7824ULL, 0x100fe400078e020dULL,
0x0000001048187824ULL, 0x100fe400078e020dULL, 0x0000001054197824ULL, 0x100fe400078e020dULL,
0x00000010681a7824ULL, 0x100fe200078e020dULL, 0x0000004000407308ULL, 0x000ea20000000800ULL,
0x000000525334723eULL, 0x002fe200000000ffULL, 0x000000104c1b7824ULL, 0x000fc400078e020dULL,
0x00000001490f7824ULL, 0x040fe400078e020fULL, 0x000000106a1c7824ULL, 0x100fe400078e020dULL,
0x0000004200427308ULL, 0x000e620000000800ULL, 0x0000000149187824ULL, 0x040fe200078e0218ULL,
0x000000080f007388ULL, 0x0007e20000000800ULL, 0x000000106c3c7824ULL, 0x000fe200078e020dULL,
0x000000023414723cULL, 0x020f620000001814ULL, 0x0000000149197824ULL, 0x040fe200078e0219ULL,
0x0000000a18007388ULL, 0x0007e20000000800ULL, 0x00000010563d7824ULL, 0x100fe200078e020dULL,
0x0000004100417308ULL, 0x000fe20000000800ULL, 0x0000003f4040723eULL, 0x004fe200000000ffULL,
0x00000001491a7824ULL, 0x000fe200078e021aULL, 0x0000002419007388ULL, 0x0007e20000000800ULL,
0x00000010443e7824ULL, 0x000fc400078e020dULL, 0x00000001491b7824ULL, 0x000fe200078e021bULL,
0x000000261a007388ULL, 0x0007e20000000800ULL, 0x0000004300007308ULL, 0x000ea20000000800ULL,
0x000000424542723eULL, 0x002fe200000000ffULL, 0x00000001491c7824ULL, 0x040fe200078e021cULL,
0x000000301b007388ULL, 0x0007e20000000800ULL, 0x00000001493c7824ULL, 0x040fe400078e023cULL,
0x00000001493d7824ULL, 0x040fe200078e023dULL, 0x000000321c007388ULL, 0x0007e20000000800ULL,
0x0000004600467308ULL, 0x000fe20000000800ULL, 0x00000001493e7824ULL, 0x000fc400078e023eULL,
0x000000343c007388ULL, 0x0007e20000000800ULL, 0x000000104e447824ULL, 0x100fe400078e020dULL,
0x0000001058487824ULL, 0x000fe200078e020dULL, 0x000000363d007388ULL, 0x0007e20000000800ULL,
0x0000004700477308ULL, 0x000e620000000800ULL, 0x000000410041723eULL, 0x004fe200000000ffULL,
0x00000001490d7824ULL, 0x040fe200078e0244ULL, 0x000000093e007388ULL, 0x0007e20000000800ULL,
0x0000000149487824ULL, 0x000fe400078e0248ULL, 0x000000ffff157224ULL, 0x020fe200078e0016ULL,
0x0004000b18007388ULL, 0x0007e80000000800ULL, 0x0004002519007388ULL, 0x0007e80000000800ULL,
0x000400271a007388ULL, 0x0007e20000000800ULL, 0x000000464743723eULL, 0x002fc600000000ffULL,
0x000400311b007388ULL, 0x0007e80000000800ULL, 0x000000024028723cULL, 0x000f620000001828ULL,
0x000400331c007388ULL, 0x0007e80000000800ULL, 0x000400353c007388ULL, 0x0007e80000000800ULL,
0x000400373d007388ULL, 0x0007e80000000800ULL, 0x000000100d007388ULL, 0x0007e80000000800ULL,
0x0008001218007388ULL, 0x0007e80000000800ULL, 0x0008002c19007388ULL, 0x0007e60000000800ULL,
0x000000ffff167224ULL, 0x020fe200078e0028ULL, 0x0008002e1a007388ULL, 0x0007e20000000800ULL,
0x000000ffff177224ULL, 0x000fc600078e002aULL, 0x000800381b007388ULL, 0x0007e80000000800ULL,
0x0008003a1c007388ULL, 0x0007e80000000800ULL, 0x000800403c007388ULL, 0x0007e80000000800ULL,
0x000800423d007388ULL, 0x0007e80000000800ULL, 0x0000001148007388ULL, 0x0007e80000000800ULL,
0x000c001318007388ULL, 0x0007e80000000800ULL, 0x000c002d19007388ULL, 0x0007e80000000800ULL,
0x000c002f1a007388ULL, 0x0007e80000000800ULL, 0x000c00391b007388ULL, 0x0007e80000000800ULL,
0x000c003b1c007388ULL, 0x0007e80000000800ULL, 0x000c00413c007388ULL, 0x0007e80000000800ULL,
0x000c00433d007388ULL, 0x0007e80000000800ULL, 0x016000040c008388ULL, 0x0007e80000000c00ULL,
0x016200140c008388ULL, 0x0007e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x016608009cff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x016610009cff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x016618009cff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000230e00720cULL, 0x000fe20003f06070ULL, 0x016620009cff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff957224ULL, 0x000fd600078e000eULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff795000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff247807ULL, 0x004fe40004000000ULL, 0x00018b5000257802ULL, 0x000fc40000000f00ULL,
0x0000107000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0024ULL,
0xfffea3b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe40005000000ULL,
0x00018ba000257802ULL, 0x000fc40000000f00ULL, 0x0000102000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0024ULL, 0xfffea42000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0010ULL, 0x00018bf000247802ULL, 0x000fc40000000f00ULL,
0x00000f8000007944ULL, 0x008fea0003c00000ULL, 0xfffea4f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0010ULL, 0x00018c3000247802ULL, 0x000fc40000000f00ULL,
0x00000f4000007944ULL, 0x00afea0003c00000ULL, 0xfffea62000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0010ULL, 0x00018c7000247802ULL, 0x000fc40000000f00ULL,
0x00000f0000007944ULL, 0x00afea0003c00000ULL, 0xfffea75000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0010ULL, 0x00018cb000247802ULL, 0x000fc40000000f00ULL,
0x00000ec000007944ULL, 0x00afea0003c00000ULL, 0xfffea87000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000cULL, 0x00018d0000247802ULL, 0x000fe20000000f00ULL,
0x000000ffff257224ULL, 0x000fc400078e000bULL, 0x00000e7000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0025ULL, 0xfffeaa2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000cULL, 0x00018d5000247802ULL, 0x000fc40000000f00ULL,
0x00000e2000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0025ULL,
0x000000100b257810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e000cULL,
0x00018da000247802ULL, 0x000fc40000000f00ULL, 0x00000dd000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e0025ULL, 0xfffea9d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000cULL, 0x00018df000247802ULL, 0x000fc40000000f00ULL,
0x00000d8000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e0025ULL,
0xfffea9b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x004fe40004000000ULL,
0x00018e4000257802ULL, 0x000fc40000000f00ULL, 0x00000d8000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff177224ULL, 0x000fe200078e0024ULL, 0xfffec12000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe40004800000ULL, 0x00018e9000257802ULL, 0x000fc40000000f00ULL,
0x00000d3000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff687224ULL, 0x000fe200078e0024ULL,
0xfffec17000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e006aULL,
0x00018ee000247802ULL, 0x000fc40000000f00ULL, 0x00000c9000007944ULL, 0x008fea0003c00000ULL,
0xfffec25000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e006aULL,
0x00018f2000247802ULL, 0x000fc40000000f00ULL, 0x00000c5000007944ULL, 0x00afea0003c00000ULL,
0xfffec38000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e006aULL,
0x00018f6000247802ULL, 0x000fc40000000f00ULL, 0x00000c1000007944ULL, 0x00afea0003c00000ULL,
0xfffec4b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e006aULL,
0x00018fa000247802ULL, 0x000fc40000000f00ULL, 0x00000bd000007944ULL, 0x00afea0003c00000ULL,
0xfffec5d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000bULL,
0x00018ff000247802ULL, 0x000fe20000000f00ULL, 0x000000ffff257224ULL, 0x000fc400078e0016ULL,
0x00000b8000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0025ULL,
0xfffec77000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000bULL,
0x0001904000247802ULL, 0x000fc40000000f00ULL, 0x00000b3000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0025ULL, 0x0000001016257810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e000bULL, 0x0001909000247802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e0025ULL,
0xfffec72000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000bULL,
0x000190e000247802ULL, 0x000fc40000000f00ULL, 0x00000a9000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0025ULL, 0xfffec70000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x004fe40004000000ULL, 0x0001913000257802ULL, 0x000fc40000000f00ULL,
0x00000a9000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff697224ULL, 0x000fe200078e0024ULL,
0xfffedc3000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe40004800000ULL,
0x0001918000257802ULL, 0x000fc40000000f00ULL, 0x00000a4000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff207224ULL, 0x000fe200078e0024ULL, 0xfffedc8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006cULL, 0x000191d000247802ULL, 0x000fc40000000f00ULL,
0x000009a000007944ULL, 0x008fea0003c00000ULL, 0xfffedd6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006cULL, 0x0001921000247802ULL, 0x000fc40000000f00ULL,
0x0000096000007944ULL, 0x00afea0003c00000ULL, 0xfffede9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006cULL, 0x0001925000247802ULL, 0x000fc40000000f00ULL,
0x0000092000007944ULL, 0x00afea0003c00000ULL, 0xfffedfc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006cULL, 0x0001929000247802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x00afea0003c00000ULL, 0xfffee0e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000bULL, 0x000192e000247802ULL, 0x000fe20000000f00ULL,
0x000000ffff257224ULL, 0x000fc400078e0068ULL, 0x0000089000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0025ULL, 0xfffee29000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000bULL, 0x0001933000247802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0025ULL,
0x0000001068257810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e000bULL,
0x0001938000247802ULL, 0x000fc40000000f00ULL, 0x000007f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e0025ULL, 0xfffee24000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000bULL, 0x000193d000247802ULL, 0x000fc40000000f00ULL,
0x000007a000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e0025ULL,
0xfffee22000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x008fe40004000000ULL,
0x0001942000257802ULL, 0x000fc40000000f00ULL, 0x000007a000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0024ULL, 0xfffef78000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe40004800000ULL, 0x0001947000257802ULL, 0x000fc40000000f00ULL,
0x0000075000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0024ULL,
0xfffef7d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0006ULL,
0x000194c000247802ULL, 0x000fc40000000f00ULL, 0x000006b000007944ULL, 0x002fea0003c00000ULL,
0xfffef8b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0006ULL,
0x0001950000247802ULL, 0x000fc40000000f00ULL, 0x0000067000007944ULL, 0x002fea0003c00000ULL,
0xfffef9e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0006ULL,
0x0001954000247802ULL, 0x000fc40000000f00ULL, 0x0000063000007944ULL, 0x002fea0003c00000ULL,
0xfffefb1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0006ULL,
0x0001958000247802ULL, 0x000fc40000000f00ULL, 0x000005f000007944ULL, 0x002fea0003c00000ULL,
0xfffefc3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0006ULL,
0x000195d000247802ULL, 0x000fe20000000f00ULL, 0x000000ffff257224ULL, 0x000fc400078e000bULL,
0x000005a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0025ULL,
0xfffefde000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0006ULL,
0x0001962000247802ULL, 0x000fc40000000f00ULL, 0x0000055000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0025ULL, 0x000000100b257810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0006ULL, 0x0001967000247802ULL, 0x000fc40000000f00ULL,
0x0000050000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e0025ULL,
0xfffefd9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0006ULL,
0x000196c000247802ULL, 0x000fc40000000f00ULL, 0x000004b000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0025ULL, 0xfffefd7000007947ULL, 0x000fea000383ffffULL,
0x00000002ff1c7424ULL, 0x000fe200078e00ffULL, 0x0001971000507802ULL, 0x000fc40000000f00ULL,
0x0000042000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0055ULL,
0xffffdfe000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x006fe200078e0052ULL,
0x0001977000507802ULL, 0x000fe20000000f00ULL, 0x00000002ff1c7424ULL, 0x000fc400078e00ffULL,
0x000003c000007944ULL, 0x000fea0003c00000ULL, 0x000000555200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0056ULL, 0x000197d000507802ULL, 0x000fe20000000f00ULL,
0x00000002ff1c7424ULL, 0x000fe200078e00ffULL, 0x0000005255067208ULL, 0x000fc80004000000ULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0x000000555600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0053ULL, 0x0001983000507802ULL, 0x000fe20000000f00ULL,
0x00000002ff1c7424ULL, 0x000fe200078e00ffULL, 0x0000005655527208ULL, 0x000fc80004000000ULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0x000000555300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0057ULL, 0x0001989000507802ULL, 0x000fe20000000f00ULL,
0x00000001ff1c7424ULL, 0x000fe200078e00ffULL, 0x0000005355547208ULL, 0x000fc80004000000ULL,
0x000002a000007944ULL, 0x000fea0003c00000ULL, 0x000000555700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0006ULL, 0x000198f000507802ULL, 0x000fe20000000f00ULL,
0x00000001ff1c7424ULL, 0x000fe200078e00ffULL, 0x0000005755047208ULL, 0x000fc80004000000ULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x000000550600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0052ULL, 0x0001995000507802ULL, 0x000fe20000000f00ULL,
0x00000001ff1c7424ULL, 0x000fe200078e00ffULL, 0x0000000655057208ULL, 0x000fc80004000000ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0x000000555200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0054ULL, 0x000199b000507802ULL, 0x000fe20000000f00ULL,
0x00000001ff1c7424ULL, 0x000fe200078e00ffULL, 0x0000005255067208ULL, 0x000fc80004000000ULL,
0x0000018000007944ULL, 0x000fea0003c00000ULL, 0xffffdeb000007947ULL, 0x000fea000383ffffULL,
0x0180000006007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000097812ULL, 0x000fc800078ec0ffULL, 0x018000000900780cULL, 0x000fda0003f05070ULL,
0x0000000600008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0900720cULL, 0x040fe40003f25070ULL, 0x008000000900780cULL, 0x000fe40003f02070ULL,
0x00000001ff097807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000009ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000006067812ULL, 0x002fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000009ff7212ULL, 0x000fda000780c0ffULL,
0x0080000006000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0006ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000600007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xfffe64d008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff517424ULL, 0x000fe200078e00ffULL,
0x0000005900007348ULL, 0x000fe80003800000ULL, 0x0c00001c07557389ULL, 0x0002a200000e0058ULL,
0xfffe649050007950ULL, 0x000fea0003c3ffffULL, 0x0000008000007348ULL, 0x000fe80003800000ULL,
0x0000002526257389ULL, 0x0002a200000e0081ULL, 0x00000000ff277424ULL, 0x000fc400078e00ffULL,
0x000000ffff267224ULL, 0x002fc800078e0024ULL, 0xfffe644026007950ULL, 0x000fea0003c3ffffULL,
0x000000012400780cULL, 0x000fe20003f45070ULL, 0x000000ffff267224ULL, 0x000fe200078e0025ULL,
0x0000007f00007348ULL, 0x000fe80003800000ULL, 0x00000000ff277424ULL, 0x000fce00078e00ffULL,
0x0000000000247806ULL, 0x000fc800050e0100ULL, 0x0000007f24247212ULL, 0x000fe200078ec0ffULL,
0xfffe63d026007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000200000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x00000000000004c4ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000620ULL,
0x0000000000000240ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000860ULL,
0x0000000000000328ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b88ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c48ULL,
0x00000000000006d0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001318ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001328ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000013b8ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000013bcULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001580ULL,
0x0000000000019d00ULL, 0xda00001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001b280ULL,
0x0000000000000038ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001b2c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001b640ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000013b8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000019ec8ULL,
0x0000000000019ec8ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001b280ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001b640ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_0_m_32_sm_86_cubin_len = 112416;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
