/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_0_m_16_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000015840ULL, 0x00000000000154c0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL,
0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL,
0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL,
0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL,
0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c00010000028dULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00010000036fULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b0022000003b5ULL, 0x0000000000013d00ULL, 0x0000000000000170ULL, 0x000b0022000003e8ULL,
0x0000000000013e70ULL, 0x0000000000000040ULL, 0x000b002200000413ULL, 0x0000000000013eb0ULL,
0x0000000000000050ULL, 0x000b00220000043dULL, 0x0000000000013f00ULL, 0x0000000000000100ULL,
0x000a0003000004abULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000004cbULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004fbULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000014000ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00013d0000000000ULL, 0x0000040400000000ULL, 0x810c000001740400ULL,
0x004dc00400288080ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080b00828808081ULL,
0x8608288080b10828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808086920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x00013d0000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL,
0xb0082880808a0828ULL, 0x288080b108288080ULL, 0x8280162880808808ULL, 0x0000000003102880ULL,
0x8080889200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL, 0x000000f000000000ULL,
0x00013e7000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080860828808081ULL, 0xb108288080b00828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080b1920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL, 0x0000017800000000ULL,
0x00013eb000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL, 0x80b0288080b10900ULL,
0x0000000000002880ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0xb008288080b10828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080b0920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x0000020800000000ULL, 0x00013f0000000000ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000001800082f04ULL, 0x000823040000007fULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL,
0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL,
0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL,
0x0000001100082304ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008230400000000ULL, 0x0000000000000018ULL, 0x0000001800081204ULL, 0x0008110400000000ULL,
0x0000000000000018ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0060016000000015ULL,
0x000c170400601903ULL, 0x0058000a00000000ULL, 0x000c17040021f000ULL, 0x0050000900000000ULL,
0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL,
0x000c17040061f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0x00000b2000043104ULL,
0xffffffff01542904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000019001542804ULL,
0x0000055000000390ULL, 0x00002ad000001af0ULL, 0x00002cb000002b90ULL, 0x0000302000002e10ULL,
0x000030a000003050ULL, 0x00003730000030f0ULL, 0x0000469000004600ULL, 0x00004920000047c0ULL,
0x00004b6000004b30ULL, 0x00004c0000004bb0ULL, 0x00005f2000005060ULL, 0x000060e000005fb0ULL,
0x0000645000006240ULL, 0x000064d000006480ULL, 0x000069d000006520ULL, 0x00007980000078e0ULL,
0x00007c1000007ab0ULL, 0x00007e5000007e20ULL, 0x00007ef000007ea0ULL, 0x0000846000008450ULL,
0x0000a8400000a800ULL, 0x0000afc00000af80ULL, 0x0001264000012600ULL, 0x0001266000012650ULL,
0x000126d000012670ULL, 0x00012710000126f0ULL, 0x0001338000013340ULL, 0x00013410000133d0ULL,
0x000134b000013460ULL, 0x0001354000013500ULL, 0x000135d000013590ULL, 0x0001367000013620ULL,
0x00013700000136c0ULL, 0x0001379000013750ULL, 0x00013830000137e0ULL, 0x000138c000013880ULL,
0x0001395000013910ULL, 0x000139f0000139a0ULL, 0x00013aa000013a40ULL, 0x00013b6000013b00ULL,
0x00013c2000013bc0ULL, 0x00013ce000013c80ULL, 0x0000045002003904ULL, 0x00013600000000ffULL,
0x00000480003f0100ULL, 0x000136080000000fULL, 0x000004d0003f0120ULL, 0x000136880000000fULL,
0x00000b80003f0120ULL, 0x00013600000000ffULL, 0x00000ca0003f0107ULL, 0x0001368c0000006bULL,
0x00000d30003f0102ULL, 0x000136880000006bULL, 0x000027b0003f0101ULL, 0x0001360800000030ULL,
0x000027f0003f0101ULL, 0x0001360c00000006ULL, 0x000029c0003f0105ULL, 0x0001360c00000006ULL,
0x000036f0003f0105ULL, 0x0001368800000010ULL, 0x00004340003f0101ULL, 0x0001362800000010ULL,
0x00004360003f0101ULL, 0x0001362c00000010ULL, 0x00004530003f0105ULL, 0x0001362c00000010ULL,
0x00005020003f0105ULL, 0x0000000000000030ULL, 0x00005c60003f0101ULL, 0x0001364800000010ULL,
0x00005c80003f0101ULL, 0x0001364c00000010ULL, 0x00005e50003f0105ULL, 0x0001364c00000010ULL,
0x000069b0003f0105ULL, 0x0000000000000030ULL, 0x00007630003f0101ULL, 0x0001366800000009ULL,
0x00007650003f0101ULL, 0x0001366c00000009ULL, 0x00007820003f0105ULL, 0x0001366c00000009ULL,
0x000082c0003f0105ULL, 0x0000000000000002ULL, 0x0000c0f0003f0101ULL, 0x00013600000000ffULL,
0x0000cce0003f0101ULL, 0x00013604000000ffULL, 0x0000cef0003f0105ULL, 0x00013604000000ffULL,
0x00010a10003f0105ULL, 0x0000000000000071ULL, 0x00010a70003f0101ULL, 0x0000000400000071ULL,
0x00010c40003f0105ULL, 0x0000000400000071ULL, 0x000131a0003f0105ULL, 0x0001360800000072ULL,
0x00013200003f0101ULL, 0x0001361000000072ULL, 0x00013260003f0101ULL, 0x0001361800000072ULL,
0x000132d0003f0101ULL, 0x0001362000000072ULL, 0x00033803003f0101ULL, 0x0000b80000201c04ULL,
0x0000bac00000b830ULL, 0x0000beb00000bcb0ULL, 0x0000cf500000c060ULL, 0x0000040100013310ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000274ULL, 0x0000001800000002ULL, 0x00000000000001e4ULL,
0x0000001800000002ULL, 0x0000000000000164ULL, 0x0000001800000002ULL, 0x00000000000000dcULL,
0x0000001800000002ULL, 0x0000000000000044ULL, 0x0000001800000002ULL, 0x000000000000024aULL,
0x0000001800000002ULL, 0x00000000000001baULL, 0x0000001800000002ULL, 0x000000000000013cULL,
0x0000001800000002ULL, 0x00000000000000b2ULL, 0x0000001800000002ULL, 0x0000000000013700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000077919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff020424ULL, 0x000fe200078e00ffULL,
0x0000000107040810ULL, 0x002fca0007ffe0ffULL, 0x00005c0004040625ULL, 0x000fc800078e0002ULL,
0x00005c0007020625ULL, 0x000fe400078e0002ULL, 0x0000000604050981ULL, 0x0002a8000c1e1900ULL,
0x0000000602020981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff007a0cULL, 0x000fe20003f65070ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x0000000000707919ULL, 0x000ee20000002600ULL, 0x00005a00ff117624ULL, 0x000fc400078e00ffULL,
0x00005900ff047624ULL, 0x002fe200078e00ffULL, 0x00000000000e7919ULL, 0x000e620000002300ULL,
0x0000590011117a24ULL, 0x000fc600078e02ffULL, 0x0000000000067919ULL, 0x000e620000002100ULL,
0x0000000000007308ULL, 0x010f220000001000ULL, 0x00000004ff127e24ULL, 0x008fe2000f8e00ffULL,
0x0ffffffe00087810ULL, 0x010fe40007ffe0ffULL, 0x00000005ff137819ULL, 0x002fc80000011606ULL,
0x0000000800097305ULL, 0x0002e4000021f000ULL, 0x00001fff13137589ULL, 0x000fe200000e0000ULL,
0x000000ffff087224ULL, 0x002fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x008fc800078e0a09ULL,
0x000059000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b09097227ULL, 0x000fcc00078e0008ULL,
0x00000400090d7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a0dULL,
0x0000040003007624ULL, 0x000fca00078e0204ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d1810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x000000010d0d2810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff0dba12ULL, 0x000fc800078e33ffULL, 0x0000000d00007306ULL, 0x000e620000209000ULL,
0x000000ff0d00720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00087810ULL, 0x002fcc0007ffe0ffULL, 0x0000000800097305ULL, 0x0002e4000021f000ULL,
0x000000ffff087224ULL, 0x002fe400078e00ffULL, 0x000000090d037224ULL, 0x008fc800078e02ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a03ULL, 0x0000000309097227ULL, 0x000fe400078e0008ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x00000070096d7227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a6dULL, 0x000000000d007224ULL, 0x000fca00078e0270ULL,
0x0000000d0000720cULL, 0x000fe20003f66070ULL, 0x000001000e037a24ULL, 0x002fc800078e0203ULL,
0x00000000030f7a24ULL, 0x000fd000078e0206ULL, 0x0000000100003824ULL, 0x000fe200078e0a0dULL,
0x000000016d6d3810ULL, 0x000fe20007ffe0ffULL, 0x00001fff0e067589ULL, 0x000e6200000e0000ULL,
0x000000ff0f00720cULL, 0x040fe40003f25270ULL, 0x0000000d0000720cULL, 0x000fe40003f86070ULL,
0x0000000f0f00780cULL, 0x040fe40003f44070ULL, 0x000000030f00780cULL, 0x000fce0003f64070ULL,
0x3fffff80ff089424ULL, 0x000fe400078e00ffULL, 0x000000016d6d4810ULL, 0x000fe20007ffe0ffULL,
0x7fffff80ff099424ULL, 0x000fe200078e00ffULL, 0x0000000dff6dd212ULL, 0x000fe200078e33ffULL,
0x3fffffc0ff0aa424ULL, 0x000fe200078e00ffULL, 0x0000007f0f00780cULL, 0x000fe20003f84070ULL,
0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL, 0x01360008ff009388ULL, 0x000fe20000000a00ULL,
0x000000ffff007224ULL, 0x000fe400078e0a6dULL, 0x3fffff60ff0cb424ULL, 0x000fe200078e00ffULL,
0x0136080a0f00a388ULL, 0x000fe20000008a00ULL, 0x000000000d707224ULL, 0x000fc400078e0270ULL,
0x7fffff60ff0db424ULL, 0x000fe400078e00ffULL, 0x0000001070707824ULL, 0x000fe400078e00ffULL,
0xff317217ff10c424ULL, 0x000fe200078e00ffULL, 0x0136880c0f00b388ULL, 0x000fe80000008a00ULL,
0x013400100f00c388ULL, 0x000fe20000004800ULL, 0x00000001054e0824ULL, 0x004fc400078e0a02ULL,
0x00005800ff4e8624ULL, 0x000fe400078e00ffULL, 0x0000580007028a24ULL, 0x000fe400078e02ffULL,
0x00005a004e037a24ULL, 0x000fe400078e02ffULL, 0x00000011026f7224ULL, 0x000fe400078e02ffULL,
0x0000000103007824ULL, 0x040fe200078e0a70ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000700300720cULL, 0x000fe20003f26070ULL, 0x00005a006d107a24ULL, 0x000fe200078e026fULL,
0x0000001000007817ULL, 0x000fc80003800000ULL, 0x000000ff006e7207ULL, 0x000fe20000800000ULL,
0x0000000406007824ULL, 0x002fc600078e0213ULL, 0x000000106e00780cULL, 0x000fe20003f05270ULL,
0x0000000200057824ULL, 0x000fd800078e00ffULL, 0x000002c000008947ULL, 0x000fea0003800000ULL,
0x00005a0000037b06ULL, 0x000e620000209000ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x00005a00ff007a0cULL, 0x000fcc0003f45070ULL, 0x0000000300037308ULL, 0x002e620000001000ULL,
0x00000004ff0a7819ULL, 0x004fca0000011600ULL, 0x00000001050b7824ULL, 0x000fe200078e020aULL,
0x0ffffffe03087810ULL, 0x002fc60007ffe0ffULL, 0x0000000170037824ULL, 0x000fe200078e020bULL,
0x0000000800097305ULL, 0x0002a4000021f000ULL, 0x000000ffff087224ULL, 0x002fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x004fc800078e0a09ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d090c7227ULL, 0x000fcc00078e0008ULL, 0x000000030c0c7227ULL, 0x000fc800078e00ffULL,
0x000000ffff0e7224ULL, 0x000fc800078e0a0cULL, 0x00005a000e087a24ULL, 0x000fca00078e0203ULL,
0x00005a0008007a0cULL, 0x000fda0003f06070ULL, 0x80005a0008080a10ULL, 0x000fe40007ffe0ffULL,
0x000000010c0c0810ULL, 0x000fe40007ffe0ffULL, 0x00005a0008007a0cULL, 0x000fda0003f26070ULL,
0x000000010c0c1810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff0caa12ULL, 0x000fca00078e33ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a0cULL, 0x00005a0008037a24ULL, 0x000fe200078e0203ULL,
0x000000056e087217ULL, 0x000fc60007800000ULL, 0x0000000110037824ULL, 0x000fe400078e0203ULL,
0x0000000108057824ULL, 0x000fe400078e0a05ULL, 0x000000110c097224ULL, 0x000fe400078e0203ULL,
0x0000001000037824ULL, 0x000fe200078e00ffULL, 0x000000050a00720cULL, 0x000fe20003f06070ULL,
0x0000010009087825ULL, 0x000fc600078e00ffULL, 0x000000f0030d7812ULL, 0x000fe200078ec0ffULL,
0x000000010b057824ULL, 0x040fe400078e0200ULL, 0x000000100b0a7824ULL, 0x000fe200078e00ffULL,
0x0000000d080d7212ULL, 0x000fc800078efcffULL, 0xfffffff00a057812ULL, 0x000fe400078ee205ULL,
0x000060000d087a10ULL, 0x000fc60007f3e0ffULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x0000610009097a10ULL, 0x000fca0000ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008057faeULL, 0x0003e2000c101c46ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x00005a00000a7b06ULL, 0x000e620000209000ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fca0003f45070ULL,
0x0000000a000a7308ULL, 0x002e620000001000ULL, 0x0000000500057211ULL, 0x004fe400078fe0ffULL,
0x0ffffffe0a097810ULL, 0x002fcc0007ffe0ffULL, 0x0000000900097305ULL, 0x000e64000021f000ULL,
0x000000ffff037224ULL, 0x002fc800078e0a09ULL, 0x00005a0003037a24ULL, 0x000fc800078e02ffULL,
0x0000000309087227ULL, 0x000fc800078e0008ULL, 0x0000000170037824ULL, 0x000fc800078e0205ULL,
0x0000000308087227ULL, 0x000fc800078e00ffULL, 0x000000ffff0a7224ULL, 0x000fc800078e0a08ULL,
0x00005a000a097a24ULL, 0x000fca00078e0203ULL, 0x00005a0009007a0cULL, 0x000fda0003f06070ULL,
0x80005a0009090a10ULL, 0x000fe40007ffe0ffULL, 0x0000000108080810ULL, 0x000fe40007ffe0ffULL,
0x00005a0009007a0cULL, 0x000fda0003f26070ULL, 0x0000000108081810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff08aa12ULL, 0x000fca00078e33ffULL, 0x000000ffff0a7224ULL, 0x000fc800078e0a08ULL,
0x00005a000a037a24ULL, 0x000fe400078e0203ULL, 0x00000001050a7824ULL, 0x040fe400078e0200ULL,
0x0000000110037824ULL, 0x000fe400078e0203ULL, 0x0000001005057824ULL, 0x000fe400078e00ffULL,
0x0000001108087224ULL, 0x000fe400078e0203ULL, 0x0000001000037824ULL, 0x000fe200078e00ffULL,
0xfffffff0050a7812ULL, 0x000fe200078ee20aULL, 0x0000010008087825ULL, 0x000fc600078e00ffULL,
0x000000f0030b7812ULL, 0x000fe200078ec0ffULL, 0x000000100a057824ULL, 0x000fc600078e00ffULL,
0x0000000b08087212ULL, 0x000fc800078efcffULL, 0x0000600008087a10ULL, 0x000fc80007f1e0ffULL,
0x0000610009097a10ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008057faeULL, 0x0003e8000b901c46ULL, 0x0000000000097919ULL, 0x002e620000000000ULL,
0x0000000000057806ULL, 0x000fe200038e0000ULL, 0x00000004ff4c7424ULL, 0x000fc600078e00ffULL,
0x0000000500087300ULL, 0x000e6200000e0000ULL, 0x0000660007607625ULL, 0x000fce00078e004cULL,
0x00000005000a7309ULL, 0x000ea20000000000ULL, 0x000000090800720cULL, 0x002fe40003f02070ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffff087224ULL, 0x004fd400078e0a0aULL,
0x01360408ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01360000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000660607981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0600720cULL, 0x000fe40003f05270ULL, 0x000000ff60627810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff627819ULL, 0x000fce0000011662ULL, 0x0000b41000008947ULL, 0x000fea0003800000ULL,
0x0000000207077824ULL, 0x000fe400078e00ffULL, 0x00000008136b7824ULL, 0x000fe400078e00ffULL,
0x00000003ff027424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01368c026bff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000112057810ULL, 0x000fe20007ffe0ffULL, 0x0000590007667624ULL, 0x000fe200078e0204ULL,
0x00000001ff0a7819ULL, 0x000fe20000011613ULL, 0x013688006bff7f8cULL, 0x0007e2000c80043fULL,
0x000000620500720cULL, 0x000fe20003f06070ULL, 0x000000016d667824ULL, 0x000fe200078e0266ULL,
0x0000000113637812ULL, 0x000fe200078ec0ffULL, 0x000000200a6a7824ULL, 0x000fc800078e00ffULL,
0x0000010012057824ULL, 0x000fc800078e026aULL, 0x0000680066257a24ULL, 0x000fe400078e0205ULL,
0x0000064000008947ULL, 0x000fea0003800000ULL, 0x00000003ff147819ULL, 0x108fe40000011600ULL,
0x0000000560027217ULL, 0x004fe40007800000ULL, 0x0000000414067810ULL, 0x040fe40007ffe0ffULL,
0x0000000814087810ULL, 0x002fe20007ffe0ffULL, 0x0000000102027824ULL, 0x000fe200078e0a05ULL,
0x0000000c14097810ULL, 0x000fe20007ffe0ffULL, 0x0000000106047824ULL, 0x100fe200078e0200ULL,
0x0000001014107810ULL, 0x000fe20007ffe0ffULL, 0x0000000806197824ULL, 0x000fe200078e00ffULL,
0x00000020020b7817ULL, 0x000fe20003800000ULL, 0x0000000108057824ULL, 0x000fe200078e0200ULL,
0x0000001414187810ULL, 0x000fe20007ffe0ffULL, 0x00000008080c7824ULL, 0x000fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fe200078ee204ULL, 0x0000000109077824ULL, 0x000fe200078e0200ULL,
0x0000007003047812ULL, 0x000fe200078ec0ffULL, 0x00000008090e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c1b7812ULL, 0x000fe200078ee205ULL, 0x0000000125057824ULL, 0x000fe200078e0214ULL,
0x0000000b0600720cULL, 0x080fe20003f86070ULL, 0x0000008063027824ULL, 0x000fe200078e0204ULL,
0xfffffff80e1d7812ULL, 0x000fe200078ee207ULL, 0x000000ffff037224ULL, 0x000fe200078e00ffULL,
0x0000000b0800720cULL, 0x080fe20003f66070ULL, 0x0000000125077824ULL, 0x000fe200078e0206ULL,
0x0000000b0900720cULL, 0x080fe20003f46070ULL, 0x0000010005047825ULL, 0x000fe200078e0002ULL,
0x0000000b1400720cULL, 0x000fc60003fa6070ULL, 0x00000001100d7824ULL, 0x000fe200078e0200ULL,
0x00006400040c7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000810167824ULL, 0x000fe400078e00ffULL,
0x0000010007067825ULL, 0x000fc600078e0002ULL, 0xfffffff8161f7812ULL, 0x000fe200078ee20dULL,
0x00000001180f7824ULL, 0x000fe200078e0200ULL, 0x00006400060e7a10ULL, 0x000fe20007f3e0ffULL,
0x00000008181a7824ULL, 0x000fe200078e00ffULL, 0x00006500050d7a10ULL, 0x000fe200007fe4ffULL,
0x0000000125057824ULL, 0x000fe400078e0208ULL, 0x0000000114087824ULL, 0x000fe200078e0200ULL,
0xfffffff81a217812ULL, 0x000fe200078ee20fULL, 0x0000010005047825ULL, 0x000fe200078e0002ULL,
0x00006500070f7a10ULL, 0x000fc40000ffe4ffULL, 0x0000000b1000720cULL, 0x080fe20003f26070ULL,
0x0000000125077824ULL, 0x040fe200078e0209ULL, 0x0000000708157812ULL, 0x000fe200078ec0ffULL,
0x0000000125097824ULL, 0x000fe200078e0210ULL, 0x0000640004107a10ULL, 0x000fe20007f1e0ffULL,
0x0000010007067825ULL, 0x000fe200078e0002ULL, 0x0ffffff815157812ULL, 0x000fe400078ef800ULL,
0x0000650005117a10ULL, 0x000fe200007fe4ffULL, 0x000000020a167824ULL, 0x000fe200078e0263ULL,
0x0000640006067a10ULL, 0x000fe20007fde0ffULL, 0x0000010009087825ULL, 0x000fe200078e0002ULL,
0x0000000b1800720cULL, 0x000fc40003f06070ULL, 0x0000b00016167811ULL, 0x000fe200078e68ffULL,
0x0000000125057824ULL, 0x000fe200078e0218ULL, 0x0000650007077a10ULL, 0x000fe400037fe4ffULL,
0x0000640008087a10ULL, 0x000fe20007fde0ffULL, 0x0000010005047825ULL, 0x000fe200078e0002ULL,
0x0000001814187810ULL, 0x040fe40007ffe0ffULL, 0x0000650009097a10ULL, 0x000fe200037fe4ffULL,
0x0000001015177824ULL, 0x100fe200078e0216ULL, 0x0000001c141a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001019197824ULL, 0x000fe200078e0216ULL, 0x0000640004147a10ULL, 0x000fe20007fde0ffULL,
0x0000000125237824ULL, 0x040fe200078e0218ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c177faeULL, 0x0003e2000e901c46ULL, 0x0000000b1800720cULL, 0x080fe20003fa6070ULL,
0x0000000125257824ULL, 0x000fe200078e021aULL, 0x0000650005157a10ULL, 0x000fe200037fe4ffULL,
0x000000000e197faeULL, 0x0005e2000e101c46ULL, 0x0000010023047825ULL, 0x000fe200078e0002ULL,
0x0000000b1a00720cULL, 0x000fc60003f86070ULL, 0x00000001180b7824ULL, 0x100fe200078e0200ULL,
0x0000640004047a10ULL, 0x000fe20007fde0ffULL, 0x0000000818187824ULL, 0x000fe400078e00ffULL,
0x000000011a0c7824ULL, 0x042fe200078e0200ULL, 0x0000650005057a10ULL, 0x000fe200037fe4ffULL,
0x000000081a0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8180b7812ULL, 0x000fe200078ee20bULL,
0x0000010025027825ULL, 0x000fc600078e0002ULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL,
0x000000101b1b7824ULL, 0x100fe200078e0216ULL, 0x0000640002027a10ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x100fe400078e0216ULL, 0x000000101f1f7824ULL, 0x100fe200078e0216ULL,
0x0000650003037a10ULL, 0x000fe200037fe4ffULL, 0x0000001021217824ULL, 0x100fe200078e0216ULL,
0x00000000101b7faeULL, 0x0005e2000d901c46ULL, 0x000000100b0b7824ULL, 0x100fe400078e0216ULL,
0x000000100d0d7824ULL, 0x000fe200078e0216ULL, 0x00000000061d7faeULL, 0x0005e8000d101c46ULL,
0x00000000081f7faeULL, 0x0005e8000c901c46ULL, 0x0000000014217faeULL, 0x0005e8000c101c46ULL,
0x00000000040b7faeULL, 0x0005e8000e901c46ULL, 0x00000000020d7faeULL, 0x0005e2000e101c46ULL,
0x0000057000007947ULL, 0x000fea0003800000ULL, 0x0000000400077811ULL, 0x048fe400078fe8ffULL,
0x0000000800097811ULL, 0x000fc400078fe8ffULL, 0x0000000c000b7811ULL, 0x040fe200078fe8ffULL,
0x0000000107027824ULL, 0x144fe200078e0200ULL, 0x0000001400117811ULL, 0x040fe200078fe8ffULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0x0000001800157811ULL, 0x040fe200078fe8ffULL,
0x0000000109047824ULL, 0x040fe200078e0200ULL, 0x00000010000f7811ULL, 0x040fe200078fe8ffULL,
0x00000008090d7824ULL, 0x000fe200078e00ffULL, 0xfffffff805167812ULL, 0x000fe200078ee202ULL,
0x000000010b027824ULL, 0x100fe200078e0200ULL, 0x0000007003147812ULL, 0x000fe200078ec0ffULL,
0x0000000111057824ULL, 0x000fe200078e0200ULL, 0xfffffff80d187812ULL, 0x000fe200078ee204ULL,
0x000000080b0d7824ULL, 0x000fe200078e00ffULL, 0x0000001c00037811ULL, 0x000fe200078fe8ffULL,
0x00000008111e7824ULL, 0x000fc400078e00ffULL, 0x0000000115067824ULL, 0x000fe200078e0200ULL,
0xfffffff80d1a7812ULL, 0x000fe200078ee202ULL, 0x0000000815197824ULL, 0x000fe200078e00ffULL,
0x0000000000027211ULL, 0x000fe200078fe8ffULL, 0x000000010f047824ULL, 0x040fe200078e0200ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee205ULL, 0x000000080f177824ULL, 0x000fe200078e00ffULL,
0xfffffff819207812ULL, 0x000fe200078ee206ULL, 0x00000001250d7824ULL, 0x000fe200078e020bULL,
0x0000000702057812ULL, 0x000fe200078ec0ffULL, 0x0000000103027824ULL, 0x000fe200078e0200ULL,
0xfffffff8171c7812ULL, 0x000fe200078ee204ULL, 0x00000008030b7824ULL, 0x000fc400078e00ffULL,
0x0000000125197824ULL, 0x000fe200078e0203ULL, 0x0000002500037211ULL, 0x000fe200078fe8ffULL,
0x000000020a047824ULL, 0x000fe200078e0263ULL, 0xfffffff80b227812ULL, 0x000fe200078ee202ULL,
0x0000000125177824ULL, 0x000fe200078e0215ULL, 0x0ffffff8050b7812ULL, 0x000fe200078ef800ULL,
0x0000008063147824ULL, 0x000fe200078e0214ULL, 0x0000b00004237811ULL, 0x000fe200078e68ffULL,
0x000000ffff157224ULL, 0x000fe400078e00ffULL, 0x0000000125077824ULL, 0x000fc400078e0207ULL,
0x0000000125097824ULL, 0x000fe400078e0209ULL, 0x0000010003027825ULL, 0x000fc800078e0014ULL,
0x00000001250f7824ULL, 0x000fe200078e020fULL, 0x0000640002027a10ULL, 0x000fe20007f1e0ffULL,
0x0000010007047825ULL, 0x000fc600078e0014ULL, 0x0000650003037a10ULL, 0x000fe200007fe4ffULL,
0x0000000125117824ULL, 0x000fe200078e0211ULL, 0x0000640004047a10ULL, 0x000fe20007f3e0ffULL,
0x0000010009067825ULL, 0x000fc600078e0014ULL, 0x0000650005057a10ULL, 0x000fe20000ffe4ffULL,
0x000001000d087825ULL, 0x002fe200078e0014ULL, 0x0000640006067a10ULL, 0x000fc60007f5e0ffULL,
0x000001000f0c7825ULL, 0x100fe200078e0014ULL, 0x0000640008087a10ULL, 0x000fe40007f7e0ffULL,
0x0000650007077a10ULL, 0x000fe200017fe4ffULL, 0x00000100110e7825ULL, 0x100fe200078e0014ULL,
0x000064000c0c7a10ULL, 0x000fe40007f1e0ffULL, 0x0000650009097a10ULL, 0x000fe20001ffe4ffULL,
0x0000010017107825ULL, 0x100fe200078e0014ULL, 0x000064000e0e7a10ULL, 0x000fe40007f3e0ffULL,
0x000065000d0d7a10ULL, 0x000fe200007fe4ffULL, 0x0000010019147825ULL, 0x000fe200078e0014ULL,
0x0000640010107a10ULL, 0x000fc40007f5e0ffULL, 0x000065000f0f7a10ULL, 0x000fe20000ffe4ffULL,
0x000000100b0b7824ULL, 0x100fe200078e0223ULL, 0x0000640014147a10ULL, 0x000fe20007f7e0ffULL,
0x0000001016177824ULL, 0x100fe200078e0223ULL, 0x0000650011117a10ULL, 0x000fe200017fe4ffULL,
0x0000001018197824ULL, 0x100fe200078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e2000b901c46ULL, 0x000000101a1b7824ULL, 0x100fe200078e0223ULL,
0x0000650015157a10ULL, 0x000fe20001ffe4ffULL, 0x000000101c1d7824ULL, 0x100fe200078e0223ULL,
0x0000000004177faeULL, 0x0003e2000b901c46ULL, 0x000000101e1f7824ULL, 0x000fc400078e0223ULL,
0x0000001020217824ULL, 0x100fe200078e0223ULL, 0x0000000006197faeULL, 0x0003e2000b901c46ULL,
0x0000001022237824ULL, 0x000fc600078e0223ULL, 0x00000000081b7faeULL, 0x0003e8000b901c46ULL,
0x000000000c1d7faeULL, 0x0003e8000b901c46ULL, 0x000000000e1f7faeULL, 0x0003e8000b901c46ULL,
0x0000000010217faeULL, 0x0003e8000b901c46ULL, 0x0000000014237faeULL, 0x0003e4000b901c46ULL,
0x000000621200720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff327424ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0b7224ULL, 0x006fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000684000000947ULL, 0x000fea0003800000ULL, 0xff317217ff327424ULL, 0x000fe400078e00ffULL,
0x000000ffff277224ULL, 0x000fc400078e00ffULL, 0x0000000112037810ULL, 0x040fe20007ffe0ffULL,
0x0000010012097824ULL, 0x000fe200078e026aULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000620300720cULL, 0x000fe40003f06070ULL, 0x0000004009037810ULL, 0x000fca0007ffe0ffULL,
0x0000680066337a24ULL, 0x000fcc00078e0203ULL, 0x0000065000008947ULL, 0x020fea0003800000ULL,
0x00000003ff417819ULL, 0x100fe40000011600ULL, 0x0000000360027217ULL, 0x000fe40007800000ULL,
0x0000000441317810ULL, 0x040fe20007ffe0ffULL, 0x0000000141387824ULL, 0x140fe200078e0200ULL,
0x0000000841377810ULL, 0x040fe20007ffe0ffULL, 0x0000000102307824ULL, 0x000fe200078e0a03ULL,
0x0000000c41397810ULL, 0x000fe20007ffe0ffULL, 0x0000000131067824ULL, 0x000fe200078e0200ULL,
0x0000001041437810ULL, 0x000fe20007ffe0ffULL, 0x0000000831117824ULL, 0x000fe200078e00ffULL,
0x0000001441457810ULL, 0x000fe20007ffe0ffULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x00000020303a7817ULL, 0x000fe20003800000ULL, 0x0000000837037824ULL, 0x000fe200078e00ffULL,
0xfffffff8113c7812ULL, 0x000fe200078ee206ULL, 0x0000000137067824ULL, 0x100fe200078e0200ULL,
0x0000007002027812ULL, 0x000fe200078ec0ffULL, 0x0000000141117824ULL, 0x000fe200078e0233ULL,
0x0000003a3100720cULL, 0x080fe20003f86070ULL, 0x0000000139087824ULL, 0x000fe200078e0200ULL,
0xfffffff803067812ULL, 0x000fe200078ee206ULL, 0x0000008063027824ULL, 0x000fe200078e0202ULL,
0x0000003a3900720cULL, 0x080fe20003f26070ULL, 0x000000ffff037224ULL, 0x000fe200078e00ffULL,
0x0000003a4100720cULL, 0x000fe20003f66070ULL, 0x0000000839357824ULL, 0x000fe200078e00ffULL,
0x0000001841477810ULL, 0x000fe20007ffe0ffULL, 0x0000010011107825ULL, 0x000fe200078e0002ULL,
0x0000001c41497810ULL, 0x000fc40007ffe0ffULL, 0xfffffff835087812ULL, 0x000fe200078ee208ULL,
0x0000000143357824ULL, 0x140fe200078e0200ULL, 0x0000640010347a10ULL, 0x000fe20007f1e0ffULL,
0x00000008433e7824ULL, 0x000fe400078e00ffULL, 0x0000000145367824ULL, 0x040fe400078e0200ULL,
0x00000008453b7824ULL, 0x040fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee235ULL,
0x0000000145417824ULL, 0x100fe200078e0233ULL, 0x0000650011357a10ULL, 0x000fe200007fe4ffULL,
0x0000000131117824ULL, 0x100fe200078e0233ULL, 0x0000003a3700720cULL, 0x040fe20003f06070ULL,
0x0000000137317824ULL, 0x100fe200078e0233ULL, 0xfffffff83b407812ULL, 0x000fe200078ee236ULL,
0x0000000139377824ULL, 0x000fe200078e0233ULL, 0x0000000738397812ULL, 0x000fe200078ec0ffULL,
0x0000010011107825ULL, 0x000fc800078e0002ULL, 0x0000010031307825ULL, 0x000fe200078e0002ULL,
0x0000640010387a10ULL, 0x000fc60007f5e0ffULL, 0x0000010037367825ULL, 0x000fe200078e0002ULL,
0x0000640030107a10ULL, 0x000fc60007fbe0ffULL, 0x000000020a3b7824ULL, 0x000fe200078e0263ULL,
0x0000640036307a10ULL, 0x000fe40007fde0ffULL, 0x0ffffff839367812ULL, 0x000fe400078ef800ULL,
0x0000650011397a10ULL, 0x000fe400017fe4ffULL, 0x0000c0003b3b7811ULL, 0x000fe400078e68ffULL,
0x0000650031117a10ULL, 0x000fe40002ffe4ffULL, 0x0000650037317a10ULL, 0x000fe200037fe4ffULL,
0x0000000143377824ULL, 0x040fe200078e0233ULL, 0x0000003a4300720cULL, 0x080fe20003f46070ULL,
0x00000010363d7824ULL, 0x000fe200078e023bULL, 0x0000003a4500720cULL, 0x000fe20003fa6070ULL,
0x0000010037367825ULL, 0x000fc600078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000343d7faeULL, 0x0003e2000d901c46ULL, 0x000000103c3f7824ULL, 0x000fe200078e023bULL,
0x0000640036367a10ULL, 0x000fe20007fde0ffULL, 0x0000000147437824ULL, 0x100fe200078e0233ULL,
0x0000003a4900720cULL, 0x0c0fe20003f66070ULL, 0x0000000149337824ULL, 0x000fe200078e0233ULL,
0x00000000383f7faeULL, 0x0005e2000e101c46ULL, 0x0000650037377a10ULL, 0x000fe200037fe4ffULL,
0x00000001493c7824ULL, 0x100fe200078e0200ULL, 0x0000003a4700720cULL, 0x040fe20003f86070ULL,
0x00000001473a7824ULL, 0x000fc400078e0200ULL, 0x0000010041347825ULL, 0x002fc800078e0002ULL,
0x0000000847477824ULL, 0x000fe200078e00ffULL, 0x0000640034347a10ULL, 0x000fe20007fde0ffULL,
0x0000010043387825ULL, 0x004fc600078e0002ULL, 0x0000650035357a10ULL, 0x000fe200037fe4ffULL,
0x0000000849497824ULL, 0x000fe200078e00ffULL, 0x0000640038387a10ULL, 0x000fe20007fde0ffULL,
0x0000010033027825ULL, 0x000fe200078e0002ULL, 0xfffffff8473a7812ULL, 0x000fe400078ee23aULL,
0xfffffff8493c7812ULL, 0x000fe200078ee23cULL, 0x0000001006337824ULL, 0x100fe200078e023bULL,
0x0000650039397a10ULL, 0x000fe200037fe4ffULL, 0x00000010083d7824ULL, 0x100fe200078e023bULL,
0x0000640002027a10ULL, 0x000fe20007fde0ffULL, 0x000000103e3f7824ULL, 0x100fe200078e023bULL,
0x0000000010337faeULL, 0x0003e2000c101c46ULL, 0x0000001040417824ULL, 0x100fe200078e023bULL,
0x0000650003037a10ULL, 0x000fe200037fe4ffULL, 0x000000103a437824ULL, 0x100fe200078e023bULL,
0x00000000303d7faeULL, 0x0003e2000c901c46ULL, 0x000000103c3b7824ULL, 0x000fc600078e023bULL,
0x00000000363f7faeULL, 0x0003e8000d101c46ULL, 0x0000000034417faeULL, 0x0003e8000e901c46ULL,
0x0000000038437faeULL, 0x0003e8000e101c46ULL, 0x00000000023b7faeULL, 0x0003e2000d901c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000800357811ULL, 0x040fe400078fe8ffULL,
0x0000000c00377811ULL, 0x000fc400078fe8ffULL, 0x0000000400317811ULL, 0x040fe200078fe8ffULL,
0x0000000135037824ULL, 0x140fe200078e0200ULL, 0x00000014003b7811ULL, 0x040fe200078fe8ffULL,
0x0000000835087824ULL, 0x000fe200078e00ffULL, 0x00000018003d7811ULL, 0x040fe200078fe8ffULL,
0x0000000137067824ULL, 0x140fe200078e0200ULL, 0x0000001000397811ULL, 0x000fe200078fe8ffULL,
0x0000000837437824ULL, 0x000fe200078e00ffULL, 0xfffffff808417812ULL, 0x000fe200078ee203ULL,
0x0000000131027824ULL, 0x040fe200078e0200ULL, 0x0000001c004b7811ULL, 0x040fe200078fe8ffULL,
0x00000008313f7824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee206ULL,
0x000000013b037824ULL, 0x040fe200078e0200ULL, 0x0000003300117211ULL, 0x000fe200078fe8ffULL,
0x000000083b087824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee202ULL,
0x000000013d067824ULL, 0x000fc400078e0200ULL, 0x000000083d497824ULL, 0x000fe200078e00ffULL,
0xfffffff808477812ULL, 0x000fe200078ee203ULL, 0x0000000139027824ULL, 0x040fe200078e0200ULL,
0x0000000000037211ULL, 0x000fe200078fe8ffULL, 0x0000000839457824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee206ULL, 0x000000020a067824ULL, 0x000fe200078e0263ULL,
0x0000000703037812ULL, 0x000fe200078ec0ffULL, 0x000000014b087824ULL, 0x000fe200078e0200ULL,
0xfffffff845457812ULL, 0x000fe200078ee202ULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x0000c00006067811ULL, 0x000fe200078e68ffULL, 0x000000084b4d7824ULL, 0x000fe200078e00ffULL,
0x0ffffff803037812ULL, 0x000fe200078ef800ULL, 0x0000000131317824ULL, 0x100fe200078e0233ULL,
0x0000007002027812ULL, 0x000fe200078ec0ffULL, 0x0000000135357824ULL, 0x100fe200078e0233ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee208ULL, 0x0000000137377824ULL, 0x000fc400078e0233ULL,
0x0000000139397824ULL, 0x100fe400078e0233ULL, 0x000000013b3b7824ULL, 0x100fe400078e0233ULL,
0x000000013d3d7824ULL, 0x100fe400078e0233ULL, 0x000000014b4b7824ULL, 0x000fe400078e0233ULL,
0x0000001003337824ULL, 0x000fe400078e0206ULL, 0x0000008063027824ULL, 0x000fc400078e0202ULL,
0x000000ffff037224ULL, 0x000fe400078e00ffULL, 0x000000103f3f7824ULL, 0x000fe400078e0206ULL,
0x0000010011107825ULL, 0x000fc800078e0002ULL, 0x0000010031307825ULL, 0x000fe200078e0002ULL,
0x0000640010107a10ULL, 0x000fc60007f1e0ffULL, 0x0000010035347825ULL, 0x100fe200078e0002ULL,
0x0000640030307a10ULL, 0x000fe40007f3e0ffULL, 0x0000650011117a10ULL, 0x000fe200007fe4ffULL,
0x0000010037367825ULL, 0x100fe200078e0002ULL, 0x0000640034347a10ULL, 0x000fe40007f5e0ffULL,
0x0000650031317a10ULL, 0x000fe20000ffe4ffULL, 0x0000010039387825ULL, 0x100fe200078e0002ULL,
0x0000640036367a10ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010337faeULL, 0x0003e2000b901c46ULL, 0x0000650035357a10ULL, 0x000fe200017fe4ffULL,
0x000001003b3a7825ULL, 0x100fe200078e0002ULL, 0x0000640038387a10ULL, 0x000fe20007f1e0ffULL,
0x00000000303f7faeULL, 0x0003e2000b901c46ULL, 0x0000650037377a10ULL, 0x000fe20001ffe4ffULL,
0x000001003d3c7825ULL, 0x000fe200078e0002ULL, 0x000064003a3a7a10ULL, 0x000fc40007f3e0ffULL,
0x0000650039397a10ULL, 0x000fe200007fe4ffULL, 0x000001004b027825ULL, 0x000fe200078e0002ULL,
0x000064003c3c7a10ULL, 0x000fe40007f5e0ffULL, 0x000065003b3b7a10ULL, 0x000fe20000ffe4ffULL,
0x0000001041417824ULL, 0x100fe200078e0206ULL, 0x0000640002027a10ULL, 0x000fe20007f7e0ffULL,
0x0000001043437824ULL, 0x100fe200078e0206ULL, 0x000065003d3d7a10ULL, 0x000fe200017fe4ffULL,
0x0000001045457824ULL, 0x100fe200078e0206ULL, 0x0000650003037a10ULL, 0x000fe20001ffe4ffULL,
0x0000001047477824ULL, 0x100fe200078e0206ULL, 0x0000000034417faeULL, 0x0003e2000b901c46ULL,
0x0000001049497824ULL, 0x000fc400078e0206ULL, 0x000000104d4d7824ULL, 0x000fe200078e0206ULL,
0x0000000036437faeULL, 0x0003e8000b901c46ULL, 0x0000000038457faeULL, 0x0003e8000b901c46ULL,
0x000000003a477faeULL, 0x0003e8000b901c46ULL, 0x000000003c497faeULL, 0x0003e8000b901c46ULL,
0x00000000024d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffe06b027812ULL, 0x002fc400078ec0ffULL, 0x000000106b037812ULL, 0x000fca00078ec0ffULL,
0x0000000102067824ULL, 0x000fc800078e0203ULL, 0x0000000863307824ULL, 0x000fe200078e0206ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136080030307f8cULL, 0x000e64000c80043fULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x000000086b117812ULL, 0x000fca00078ec0ffULL,
0x0000000106067824ULL, 0x000fca00078e0211ULL, 0x01360c0006117984ULL, 0x000ea40000000800ULL,
0x8000000011ff7812ULL, 0x006fe40007804831ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x0000001002337210ULL, 0x000fca0007f1e1ffULL, 0x0000000111117824ULL, 0x000fe200000e0e03ULL,
0x003d09003300780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403300780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011411ULL, 0x0000003308087211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0611ULL, 0x0000000208087819ULL, 0x000fc80000001211ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01360c0006117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000697824ULL, 0x000fe200078e00ffULL,
0x00000001ff6c7819ULL, 0x000fe20000011600ULL, 0x0000002013027824ULL, 0x000fe400078e00ffULL,
0xffffffffff717424ULL, 0x000fe200078e00ffULL, 0x0000007069697812ULL, 0x000fc400078ec0ffULL,
0xffffff8002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c6c6c7812ULL, 0x000fc800078ec0ffULL,
0x000000026c027210ULL, 0x000fca0007ffe069ULL, 0x0130000002037984ULL, 0x000e680000000800ULL,
0x0132000002067984ULL, 0x0004e20000000800ULL, 0x000000320300720bULL, 0x002fe20003f1d000ULL,
0x000108527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x004fc800000e0100ULL,
0x0000ffff10337812ULL, 0x000fe2000782c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff087224ULL, 0x000fe400078e0032ULL,
0x0000001fff737424ULL, 0x000fc400078e00ffULL, 0xffffffffff727424ULL, 0x000fcc00078e00ffULL,
0x0000044000009947ULL, 0x000fea0003800000ULL, 0x00000002ff027819ULL, 0x000fe40000011613ULL,
0x000000320300720bULL, 0x000fe40003f54000ULL, 0x000000130200720cULL, 0x000fe20003f25270ULL,
0x000107d27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000027806ULL, 0x000fc400010e0100ULL,
0x0000008013119824ULL, 0x000fe200078e0269ULL, 0x0000003203087209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991002107816ULL, 0x000fe200000000ffULL,
0x000000016c119824ULL, 0x000fca00078e0211ULL, 0x0134000811009388ULL, 0x0003e20000000800ULL,
0x000000ff1000720cULL, 0x000fda0003f25270ULL, 0x0000030000009947ULL, 0x000fea0003800000ULL,
0x0000003208107221ULL, 0x002fe20000010100ULL, 0x000000ff02ff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000117308ULL, 0x000e640000000800ULL, 0x000000110b0b7220ULL, 0x002fc80000410000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe20000011600ULL,
0x000107027f007947ULL, 0x000fea000b800000ULL, 0x00001f1011107589ULL, 0x0002a400000e0000ULL,
0x000000102c2c7220ULL, 0x084fe20000410000ULL, 0x000000102d2d7220ULL, 0x080fe20000410000ULL,
0x0000001028287220ULL, 0x080fe20000410000ULL, 0x0000001029297220ULL, 0x080fe20000410000ULL,
0x000000100c0c7220ULL, 0x080fe20000410000ULL, 0x000000100d0d7220ULL, 0x080fe20000410000ULL,
0x0000001014147220ULL, 0x080fe20000410000ULL, 0x0000001015157220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x080fe20000410000ULL,
0x000000101c1c7220ULL, 0x080fe20000410000ULL, 0x000000101d1d7220ULL, 0x080fe20000410000ULL,
0x0000001020207220ULL, 0x080fe20000410000ULL, 0x0000001021217220ULL, 0x080fe20000410000ULL,
0x0000001024247220ULL, 0x080fe20000410000ULL, 0x0000001025257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0002ff7812ULL, 0x000fda000782c0ffULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x0000000800107811ULL, 0x000fe200078ff0ffULL,
0x000105e27f007947ULL, 0x000fea000b800000ULL, 0x00001f1011107589ULL, 0x00046400000e0000ULL,
0x000000102e2e7220ULL, 0x086fe20000410000ULL, 0x000000102f2f7220ULL, 0x080fe20000410000ULL,
0x000000102a2a7220ULL, 0x080fe20000410000ULL, 0x000000102b2b7220ULL, 0x080fe20000410000ULL,
0x000000100e0e7220ULL, 0x080fe20000410000ULL, 0x000000100f0f7220ULL, 0x080fe20000410000ULL,
0x0000001016167220ULL, 0x080fe20000410000ULL, 0x0000001017177220ULL, 0x080fe20000410000ULL,
0x000000101a1a7220ULL, 0x080fe20000410000ULL, 0x000000101b1b7220ULL, 0x080fe20000410000ULL,
0x000000101e1e7220ULL, 0x080fe20000410000ULL, 0x000000101f1f7220ULL, 0x080fe20000410000ULL,
0x0000001022227220ULL, 0x080fe20000410000ULL, 0x0000001023237220ULL, 0x080fe20000410000ULL,
0x0000001026267220ULL, 0x080fe20000410000ULL, 0x0000001027277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff33ff7812ULL, 0x000fda0007826002ULL,
0x8000000803031221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b03031820ULL, 0x000fc80000410000ULL, 0x0000000300071308ULL, 0x000e640000000800ULL,
0x0000000706061220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x0000000b06067221ULL, 0x008fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000007ff02723eULL, 0x000fe400000000ffULL, 0x00000002ff037819ULL, 0x000fe40000011600ULL,
0x0000541002027816ULL, 0x000fe20000000002ULL, 0x000104127f007947ULL, 0x000fea000b800000ULL,
0x00001f0302057589ULL, 0x0002a400000e0000ULL, 0x0000000803107810ULL, 0x000fe20007ffe0ffULL,
0x000104427f007947ULL, 0x000fea000b800000ULL, 0x00001f1002047589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001003107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x000fe200078e0002ULL, 0x000030b000317802ULL, 0x000fc40000000f00ULL,
0x00010e0000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001803107810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff307224ULL, 0x000fe200078e0002ULL,
0x0000310000317802ULL, 0x000fc40000000f00ULL, 0x00010db000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff037819ULL, 0x102fe20000011600ULL,
0x0000020013107824ULL, 0x00cfe200078e00ffULL, 0x0000000700677812ULL, 0x040fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000800687812ULL, 0x000fe200078ec0ffULL,
0x000000040a037824ULL, 0x000fe200078e0203ULL, 0x0000000867027812ULL, 0x000fc400078ef800ULL,
0xfffff80010107812ULL, 0x000fc600078ec0ffULL, 0x00000001020b7824ULL, 0x040fe400078e0203ULL,
0x0000000802307824ULL, 0x000fca00078e00ffULL, 0xfffffff830037812ULL, 0x000fca00078ee20bULL,
0x0000001003037824ULL, 0x000fc600078e0210ULL, 0x0000006768317212ULL, 0x000fe200078efcffULL,
0x000000020a587824ULL, 0x000fe200078e0263ULL, 0x009000000348783bULL, 0x000e620000000200ULL,
0x000000020b0b7810ULL, 0x000fe40007ffe0ffULL, 0x0000003100307211ULL, 0x000fe200078fe0ffULL,
0x0000000831347824ULL, 0x040fe200078e00ffULL, 0x0000001068357812ULL, 0x000fe200078efe67ULL,
0x0000000831327824ULL, 0x040fe200078e00ffULL, 0x0000000430117810ULL, 0x040fe20007ffe0ffULL,
0x0000000831337824ULL, 0x000fe200078e00ffULL, 0x00000002305d7810ULL, 0x000fe20007ffe0ffULL,
0x0000200058587824ULL, 0x000fe200078e00ffULL, 0x0000000630317810ULL, 0x000fe20007ffe0ffULL,
0x0000000835387824ULL, 0x040fe200078e00ffULL, 0xfffffff834117812ULL, 0x000fe200078ee211ULL,
0x0000000802347824ULL, 0x000fe200078e00ffULL, 0xfffffff8325d7812ULL, 0x000fe200078ee25dULL,
0x00000008353b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8335e7812ULL, 0x000fe200078ee230ULL,
0x0000000835397824ULL, 0x040fe200078e00ffULL, 0x0000b000580a7810ULL, 0x000fe20007ffe0ffULL,
0x00000008353a7824ULL, 0x000fe200078e00ffULL, 0xfffffff832027812ULL, 0x000fc400078ee231ULL,
0xfffffff8340b7812ULL, 0x000fe200078ee20bULL, 0x000000105e307824ULL, 0x100fe400078e020aULL,
0x000000105d547824ULL, 0x100fe400078e020aULL, 0x0000001011507824ULL, 0x100fe400078e020aULL,
0x00000010024c7824ULL, 0x000fe200078e020aULL, 0x000000003030783bULL, 0x000ea20000004200ULL,
0x000000100b0b7824ULL, 0x000fe200078e0210ULL, 0x0000003500107211ULL, 0x000fc400078fe0ffULL,
0x000000005454783bULL, 0x000ee40000004200ULL, 0x00000002105b7810ULL, 0x040fe40007ffe0ffULL,
0x000000005050783bULL, 0x000fe20000004200ULL, 0x00000004105a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000548480232ULL, 0x082fe20000000000ULL, 0x0000000610597810ULL, 0x000fe20007ffe0ffULL,
0x000000004c4c783bULL, 0x000fe20000004200ULL, 0xfffffff8395c7812ULL, 0x000fe200078ee210ULL,
0x000000054a4a0232ULL, 0x000fe20000000000ULL, 0xfffffff8385b7812ULL, 0x000fe200078ee25bULL,
0x009000000b34783bULL, 0x0003220000000200ULL, 0xfffffff83b5a7812ULL, 0x000fe200078ee25aULL,
0x000000105c447824ULL, 0x100fe200078e020aULL, 0xfffffff83a597812ULL, 0x000fe200078ee259ULL,
0x000000105b407824ULL, 0x100fe200078e020aULL, 0x0000000449490232ULL, 0x080fe20000000000ULL,
0x000000105a3c7824ULL, 0x100fe200078e020aULL, 0x000000044b4b0232ULL, 0x000fe20000000000ULL,
0x0000001059387824ULL, 0x000fe200078e020aULL, 0x000000004444783bULL, 0x000f220000004200ULL,
0x00000002130b7824ULL, 0x002fc600078e00ffULL, 0x000000004040783bULL, 0x000e640000004200ULL,
0xfffffff80b107812ULL, 0x000fe400078ec0ffULL, 0x000000003c3c783bULL, 0x000e680000004200ULL,
0x000000003838783bULL, 0x000e620000004200ULL, 0x00000030482c723cULL, 0x044f70000000182cULL,
0x000000324828723cULL, 0x040f700000001828ULL, 0x00000054480c723cULL, 0x008f62000000180cULL,
0x0000000534340232ULL, 0x010fc40000000000ULL, 0x0000000536360232ULL, 0x000fe40000000000ULL,
0x0000000435350232ULL, 0x080fe40000000000ULL, 0x0000000437370232ULL, 0x000fe20000000000ULL,
0x000000564814723cULL, 0x040f700000001814ULL, 0x000000504818723cULL, 0x040f700000001818ULL,
0x00000052481c723cULL, 0x040f70000000181cULL, 0x0000004c4820723cULL, 0x040f700000001820ULL,
0x0000004e4824723cULL, 0x000f700000001824ULL, 0x00000044342c723cULL, 0x060b70000000182cULL,
0x000000463428723cULL, 0x040b700000001828ULL, 0x00000040340c723cULL, 0x042b70000000180cULL,
0x000000423414723cULL, 0x040b700000001814ULL, 0x0000003c3418723cULL, 0x040b700000001818ULL,
0x0000003e341c723cULL, 0x040b70000000181cULL, 0x000000383420723cULL, 0x040b700000001820ULL,
0x0000003a3424723cULL, 0x000b620000001824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000001120b7810ULL, 0x000fe20007ffe0ffULL, 0x0136880010ff7f8cULL, 0x0003e2000c80043fULL,
0x0000008009317810ULL, 0x000fc40007ffe0ffULL, 0x000000620b00720cULL, 0x000fc60003f06070ULL,
0x00006800660b7a24ULL, 0x000fe200078e0231ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000061000008947ULL, 0x000fea0003800000ULL, 0x00000003ff107819ULL, 0x102fe20000011600ULL,
0x0000008063327824ULL, 0x000fe200078e0269ULL, 0x0000003160307217ULL, 0x000fe20007800000ULL,
0x000000ffff337224ULL, 0x000fe200078e00ffULL, 0x0000000410347810ULL, 0x060fe20007ffe0ffULL,
0x0000000110357824ULL, 0x040fe200078e020bULL, 0x0000000810367810ULL, 0x000fe20007ffe0ffULL,
0x0000000130307824ULL, 0x000fe200078e0a31ULL, 0x00000010103c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000134317824ULL, 0x100fe200078e0200ULL, 0x0000001c10407810ULL, 0x000fe20007ffe0ffULL,
0x0000000834387824ULL, 0x000fe200078e00ffULL, 0x0000002030457817ULL, 0x000fe20003800000ULL,
0x00000001363f7824ULL, 0x000fc400078e0200ULL, 0x00000008363a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8384b7812ULL, 0x000fe200078ee231ULL, 0x0000000134317824ULL, 0x000fe200078e020bULL,
0x0000000c10387810ULL, 0x000fe20007ffe0ffULL, 0x000000013c417824ULL, 0x000fe200078e0200ULL,
0xfffffff83a3f7812ULL, 0x000fe200078ee23fULL, 0x0000010031307825ULL, 0x000fe200078e0032ULL,
0x000000453400720cULL, 0x080fe40003f86070ULL, 0x000000453600720cULL, 0x080fe20003f66070ULL,
0x0000000138437824ULL, 0x000fe200078e0200ULL, 0x000000451000720cULL, 0x080fe20003fa6070ULL,
0x00000008383a7824ULL, 0x040fe200078e00ffULL, 0x000000453800720cULL, 0x000fe20003f46070ULL,
0x0000010035347825ULL, 0x000fc600078e0032ULL, 0xfffffff83a437812ULL, 0x000fe200078ee243ULL,
0x000000083c3e7824ULL, 0x000fe200078e00ffULL, 0x00006400343a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000138377824ULL, 0x100fe200078e020bULL, 0x0000640030347a10ULL, 0x000fe20007f3e0ffULL,
0x0000000110307824ULL, 0x000fe200078e0200ULL, 0x00006500353b7a10ULL, 0x000fe200007fe4ffULL,
0x000000013c397824ULL, 0x100fe200078e020bULL, 0x0000650031357a10ULL, 0x000fe20000ffe4ffULL,
0x0000000136317824ULL, 0x000fe200078e020bULL, 0x00000007303d7812ULL, 0x000fe200078ec0ffULL,
0x0000010037367825ULL, 0x000fe200078e0032ULL, 0xfffffff83e417812ULL, 0x000fc400078ee241ULL,
0x00000014103e7810ULL, 0x000fe20007ffe0ffULL, 0x0000010031307825ULL, 0x000fe200078e0032ULL,
0x0ffffff83d3d7812ULL, 0x100fe400078ef800ULL, 0x000000453c00720cULL, 0x080fe20003f26070ULL,
0x000000013e477824ULL, 0x000fe200078e0200ULL, 0x0000640030307a10ULL, 0x000fe20007f1e0ffULL,
0x000000083e3c7824ULL, 0x000fe200078e00ffULL, 0x0000640036367a10ULL, 0x000fe20007fde0ffULL,
0x000000103d497824ULL, 0x000fe200078e020aULL, 0x0000650031317a10ULL, 0x000fe200007fe4ffULL,
0x0000010039387825ULL, 0x000fe200078e0032ULL, 0x000000453e00720cULL, 0x000fc40003f06070ULL,
0xfffffff83c477812ULL, 0x000fe200078ee247ULL, 0x000000013e3d7824ULL, 0x000fe200078e020bULL,
0x00000018103e7810ULL, 0x000fe20007ffe0ffULL, 0x000000104b4b7824ULL, 0x000fe200078e020aULL,
0x0000650037377a10ULL, 0x000fe200037fe4ffULL, 0x000001003d3c7825ULL, 0x000fe200078e0032ULL,
0x0000640038387a10ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a497faeULL, 0x0003e2000e901c46ULL, 0x000000453e00720cULL, 0x0c0fe20003fa6070ULL,
0x000000013e4d7824ULL, 0x100fe200078e020bULL, 0x0000650039397a10ULL, 0x000fe200037fe4ffULL,
0x00000000344b7faeULL, 0x0005e2000e101c46ULL, 0x000064003c3c7a10ULL, 0x000fe20007fde0ffULL,
0x00000001400b7824ULL, 0x040fe200078e020bULL, 0x000000454000720cULL, 0x000fe20003f86070ULL,
0x000000013e107824ULL, 0x040fe200078e0200ULL, 0x000065003d3d7a10ULL, 0x000fe200037fe4ffULL,
0x000000083e457824ULL, 0x000fc400078e00ffULL, 0x000001004d3a7825ULL, 0x002fc800078e0032ULL,
0x0000000140357824ULL, 0x004fe200078e0200ULL, 0x000064003a347a10ULL, 0x000fe20007fde0ffULL,
0x0000000840407824ULL, 0x000fe400078e00ffULL, 0x000001000b327825ULL, 0x000fe200078e0032ULL,
0xfffffff8450b7812ULL, 0x000fe400078ee210ULL, 0xfffffff840457812ULL, 0x000fe200078ee235ULL,
0x000000103f3f7824ULL, 0x100fe200078e020aULL, 0x000065003b357a10ULL, 0x000fe200037fe4ffULL,
0x0000001043437824ULL, 0x100fe200078e020aULL, 0x0000640032327a10ULL, 0x000fe20007fde0ffULL,
0x0000001041417824ULL, 0x100fe200078e020aULL, 0x00000000303f7faeULL, 0x0003e2000d901c46ULL,
0x0000001047477824ULL, 0x100fe200078e020aULL, 0x0000650033337a10ULL, 0x000fe200037fe4ffULL,
0x000000100b0b7824ULL, 0x100fe200078e020aULL, 0x0000000036437faeULL, 0x0003e2000d101c46ULL,
0x00000010453b7824ULL, 0x000fc600078e020aULL, 0x0000000038417faeULL, 0x0003e8000c901c46ULL,
0x000000003c477faeULL, 0x0003e8000c101c46ULL, 0x00000000340b7faeULL, 0x0003e8000e901c46ULL,
0x00000000323b7faeULL, 0x0003e2000e101c46ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x00000004003b7811ULL, 0x062fe200078fe8ffULL, 0x0000008063367824ULL, 0x000fe200078e0269ULL,
0x00000008003d7811ULL, 0x040fe200078fe8ffULL, 0x000000ffff377224ULL, 0x000fe200078e00ffULL,
0x0000000c00397811ULL, 0x040fe200078fe8ffULL, 0x000000013b417824ULL, 0x140fe200078e0200ULL,
0x0000001000317811ULL, 0x040fe200078fe8ffULL, 0x000000083b307824ULL, 0x000fe200078e00ffULL,
0x0000001400337811ULL, 0x040fe200078fe8ffULL, 0x000000013d107824ULL, 0x140fe200078e0200ULL,
0x0000001800357811ULL, 0x000fe200078fe8ffULL, 0x000000083d457824ULL, 0x000fe200078e00ffULL,
0xfffffff830417812ULL, 0x000fe200078ee241ULL, 0x0000000839477824ULL, 0x000fe200078e00ffULL,
0x0000000b003f7211ULL, 0x000fe200078fe8ffULL, 0x0000000131307824ULL, 0x000fe200078e0200ULL,
0xfffffff845457812ULL, 0x000fe200078ee210ULL, 0x0000000139107824ULL, 0x000fc400078e0200ULL,
0x0000000831497824ULL, 0x000fe400078e00ffULL, 0x0000000133327824ULL, 0x000fe200078e0200ULL,
0xfffffff847477812ULL, 0x000fe200078ee210ULL, 0x00000008334b7824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee230ULL, 0x0000000135347824ULL, 0x040fe200078e0200ULL,
0x0000000000107211ULL, 0x040fe200078fe8ffULL, 0x00000008354d7824ULL, 0x000fe200078e00ffULL,
0x0000001c00307811ULL, 0x000fe200078fe8ffULL, 0x000000013b3b7824ULL, 0x100fe200078e020bULL,
0x0000000710437812ULL, 0x000fe200078ec0ffULL, 0x000000013d3d7824ULL, 0x100fe200078e020bULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee232ULL, 0x0000000130107824ULL, 0x040fe200078e0200ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee234ULL, 0x00000008304f7824ULL, 0x000fe200078e00ffULL,
0x0ffffff843437812ULL, 0x000fe200078ef800ULL, 0x0000000139397824ULL, 0x000fc400078e020bULL,
0x000001003f3e7825ULL, 0x000fe200078e0036ULL, 0xfffffff84f4f7812ULL, 0x000fc600078ee210ULL,
0x0000000131317824ULL, 0x000fe400078e020bULL, 0x000001003b3a7825ULL, 0x000fc800078e0036ULL,
0x0000000133337824ULL, 0x000fe200078e020bULL, 0x000064003a3a7a10ULL, 0x000fe20007f3e0ffULL,
0x000001003d3c7825ULL, 0x000fc600078e0036ULL, 0x000065003b3b7a10ULL, 0x000fe20000ffe4ffULL,
0x0000000135357824ULL, 0x000fe200078e020bULL, 0x000064003c3c7a10ULL, 0x000fe20007f5e0ffULL,
0x0000010039387825ULL, 0x000fc600078e0036ULL, 0x000065003d3d7a10ULL, 0x000fe200017fe4ffULL,
0x00000001300b7824ULL, 0x000fe200078e020bULL, 0x0000640038387a10ULL, 0x000fe20007f7e0ffULL,
0x0000001043437824ULL, 0x100fe400078e020aULL, 0x0000001041417824ULL, 0x100fe200078e020aULL,
0x0000650039397a10ULL, 0x000fe20001ffe4ffULL, 0x0000001045457824ULL, 0x100fe400078e020aULL,
0x0000001047477824ULL, 0x100fe400078e020aULL, 0x0000001049497824ULL, 0x000fc400078e020aULL,
0x000000104b4b7824ULL, 0x100fe400078e020aULL, 0x000000104d4d7824ULL, 0x100fe400078e020aULL,
0x000000104f4f7824ULL, 0x000fe200078e020aULL, 0x000064003e0a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000010031307825ULL, 0x000fc800078e0036ULL, 0x0000010033327825ULL, 0x000fc800078e0036ULL,
0x0000010035347825ULL, 0x000fe200078e0036ULL, 0x0000640032327a10ULL, 0x000fc60007f3e0ffULL,
0x000001000b367825ULL, 0x000fe200078e0036ULL, 0x000065003f0b7a10ULL, 0x000fe400007fe4ffULL,
0x0000640030307a10ULL, 0x000fe40007f1e0ffULL, 0x0000640034347a10ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a437faeULL, 0x0003e2000b901c46ULL,
0x0000640036367a10ULL, 0x000fe40007f7e0ffULL, 0x0000650031317a10ULL, 0x000fe200007fe4ffULL,
0x000000003a417faeULL, 0x0003e2000b901c46ULL, 0x0000650033337a10ULL, 0x000fc40000ffe4ffULL,
0x0000650035357a10ULL, 0x000fe200017fe4ffULL, 0x000000003c457faeULL, 0x0003e2000b901c46ULL,
0x0000650037377a10ULL, 0x000fc60001ffe4ffULL, 0x0000000038477faeULL, 0x0003e8000b901c46ULL,
0x0000000030497faeULL, 0x0003e8000b901c46ULL, 0x00000000324b7faeULL, 0x0003e8000b901c46ULL,
0x00000000344d7faeULL, 0x0003e8000b901c46ULL, 0x00000000364f7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe06b107812ULL, 0x000fc400078ec0ffULL,
0x000000106b0b7812ULL, 0x042fe400078ec0ffULL, 0x000000086b0a7812ULL, 0x000fc800078ec0ffULL,
0x000000100a107210ULL, 0x000fe20007ffe00bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136280010307f8cULL, 0x0002a4000c80043fULL, 0x00000000000a7805ULL, 0x000fc40000015200ULL,
0x01362c0010337984ULL, 0x000ee40000000800ULL, 0x8000000033ff7812ULL, 0x00cfe40007804831ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x000000320a357210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e0bULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003532327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01362c0010337984ULL, 0x000ea40000000800ULL,
0x8000000033ff7812ULL, 0x004fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020130a7824ULL, 0x000fca00078e00ffULL, 0xffffff800a0a7812ULL, 0x000fc800078ec0ffULL,
0x00000080690b7810ULL, 0x000fca0007ffe00aULL, 0x000000016c0b7824ULL, 0x000fca00078e020bULL,
0x013000000b337984ULL, 0x000ea80000000800ULL, 0x013200000b0a7984ULL, 0x0006620000000800ULL,
0x000000083300720bULL, 0x004fe20003f1d000ULL, 0x0000eee27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x00afc800000e0100ULL, 0x0000ffff10327812ULL, 0x000fe2000782c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x0000000113107811ULL, 0x000fe400078ff0ffULL,
0x000000083300720bULL, 0x000fe40003f34000ULL, 0x000000131000720cULL, 0x000fe20003f05270ULL,
0x0000ee927f007947ULL, 0x000fd4000b800000ULL, 0x00000000000b7806ULL, 0x000fc400008e0100ULL,
0x0000008013318824ULL, 0x000fe200078e0269ULL, 0x0000000833108209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x000099100b307816ULL, 0x000fe200000000ffULL,
0x000000016c318824ULL, 0x000fca00078e0231ULL, 0x0134001031008388ULL, 0x0003e20000000800ULL,
0x000000ff3000720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000833317209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0bff7812ULL, 0x000fc6000780c0ffULL, 0x0000000831107221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000357308ULL, 0x000e640000000800ULL,
0x0000003506067220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe20000011600ULL, 0x0000edb27f007947ULL, 0x000fea000b800000ULL,
0x00001f1035107589ULL, 0x0002a400000e0000ULL, 0x000000102c2c7220ULL, 0x084fe20000410000ULL,
0x000000102d2d7220ULL, 0x080fe20000410000ULL, 0x0000001028287220ULL, 0x080fe20000410000ULL,
0x0000001029297220ULL, 0x080fe20000410000ULL, 0x000000100c0c7220ULL, 0x080fe20000410000ULL,
0x000000100d0d7220ULL, 0x080fe20000410000ULL, 0x0000001014147220ULL, 0x080fe20000410000ULL,
0x0000001015157220ULL, 0x080fe20000410000ULL, 0x0000001018187220ULL, 0x080fe20000410000ULL,
0x0000001019197220ULL, 0x080fe20000410000ULL, 0x000000101c1c7220ULL, 0x080fe20000410000ULL,
0x000000101d1d7220ULL, 0x080fe20000410000ULL, 0x0000001020207220ULL, 0x080fe20000410000ULL,
0x0000001021217220ULL, 0x080fe20000410000ULL, 0x0000001024247220ULL, 0x080fe20000410000ULL,
0x0000001025257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000bff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000800107811ULL, 0x000fe200078ff0ffULL, 0x0000ec927f007947ULL, 0x000fea000b800000ULL,
0x00001f1035107589ULL, 0x0004e400000e0000ULL, 0x000000102e2e7220ULL, 0x08cfe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000100e0e7220ULL, 0x080fe20000410000ULL,
0x000000100f0f7220ULL, 0x080fe20000410000ULL, 0x0000001016167220ULL, 0x080fe20000410000ULL,
0x0000001017177220ULL, 0x080fe20000410000ULL, 0x000000101a1a7220ULL, 0x080fe20000410000ULL,
0x000000101b1b7220ULL, 0x080fe20000410000ULL, 0x000000101e1e7220ULL, 0x080fe20000410000ULL,
0x000000101f1f7220ULL, 0x080fe20000410000ULL, 0x0000001022227220ULL, 0x080fe20000410000ULL,
0x0000001023237220ULL, 0x080fe20000410000ULL, 0x0000001026267220ULL, 0x080fe20000410000ULL,
0x0000001027277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff32ff7812ULL, 0x000fe4000780600bULL, 0x0000000833087209ULL, 0x000fd60007810000ULL,
0x8000000833330221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b33330820ULL, 0x000fc80000410000ULL,
0x0000003300070308ULL, 0x000e640000000800ULL, 0x000000070a0a0220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x000000060a0b7221ULL, 0x000fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000007ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff337819ULL, 0x000fe40000011600ULL, 0x0000541004067816ULL, 0x000fe20000000004ULL,
0x0000eac27f007947ULL, 0x000fea000b800000ULL, 0x00001f3306057589ULL, 0x0002a400000e0000ULL,
0x0000000833107810ULL, 0x000fe20007ffe0ffULL, 0x0000eaf27f007947ULL, 0x000fea000b800000ULL,
0x00001f1006047589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001033107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff307224ULL, 0x000fe200078e0006ULL,
0x00004bc000317802ULL, 0x000fc40000000f00ULL, 0x0000f2f000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001833107810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff307224ULL, 0x000fe200078e0006ULL, 0x00004c1000317802ULL, 0x000fc40000000f00ULL,
0x0000f2a000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x00000001ff0a7819ULL, 0x000fe20000011613ULL,
0x009800000348783bULL, 0x0008e20000000200ULL, 0x00000004ff317819ULL, 0x000fc40000011600ULL,
0x0000006867107212ULL, 0x00cfe200078efcffULL, 0x000000020a307824ULL, 0x040fe400078e0263ULL,
0x000000040a317824ULL, 0x000fe400078e0231ULL, 0x0000000810357824ULL, 0x000fe200078e00ffULL,
0x0000c000304c7811ULL, 0x000fe200078e68ffULL, 0x0000000110067824ULL, 0x002fe200078e0231ULL,
0x0000c00058037810ULL, 0x010fc60007ffe0ffULL, 0x000000105e307824ULL, 0x100fe200078e024cULL,
0x0000000206107810ULL, 0x000fe20007ffe0ffULL, 0x000000105d547824ULL, 0x100fe400078e024cULL,
0x0000001011507824ULL, 0x000fe200078e024cULL, 0xfffffff835357812ULL, 0x000fe200078ee210ULL,
0x00000010024c7824ULL, 0x000fe200078e024cULL, 0x000000003030783bULL, 0x000e620000004200ULL,
0x00000002ff107819ULL, 0x000fe20000011613ULL, 0x000000105c5f7824ULL, 0x100fe400078e0203ULL,
0x000000005454783bULL, 0x000ea20000004200ULL, 0x000000105b617824ULL, 0x000fc400078e0203ULL,
0x0000008010347824ULL, 0x000fe200078e0235ULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x000000105a647824ULL, 0x100fe400078e0203ULL, 0x0000001059657824ULL, 0x000fe200078e0203ULL,
0x000000004c4c783bULL, 0x000fe20000004200ULL, 0x0000980034347811ULL, 0x000fc600078e20ffULL,
0x000000005f44783bULL, 0x000fe20000004200ULL, 0x0000000548480232ULL, 0x000fc60000000000ULL,
0x000000003434783bULL, 0x000ee20000000200ULL, 0x000000054a4a0232ULL, 0x000fe40000000000ULL,
0x0000000449490232ULL, 0x080fe20000000000ULL, 0x000000006140783bULL, 0x000f220000004200ULL,
0x000000044b4b0232ULL, 0x000fc60000000000ULL, 0x00000000643c783bULL, 0x000f280000004200ULL,
0x000000006538783bULL, 0x000f220000004200ULL, 0x00000030482c723cULL, 0x042b6e000000182cULL,
0x0001369010307811ULL, 0x020fe200078e18ffULL, 0x000000324828723cULL, 0x040f700000001828ULL,
0x00000054480c723cULL, 0x004f62000000180cULL, 0x0000000534340232ULL, 0x008fc40000000000ULL,
0x0000000536360232ULL, 0x000fca0000000000ULL, 0x000000564814723cULL, 0x000f620000001814ULL,
0x0000000435350232ULL, 0x080fe40000000000ULL, 0x0000000437370232ULL, 0x000fca0000000000ULL,
0x000000504818723cULL, 0x040f700000001818ULL, 0x00000052481c723cULL, 0x040f70000000181cULL,
0x0000004c4820723cULL, 0x040f700000001820ULL, 0x0000004e4824723cULL, 0x000f700000001824ULL,
0x00000044342c723cULL, 0x040b70000000182cULL, 0x000000463428723cULL, 0x060b700000001828ULL,
0x00000040340c723cULL, 0x050b70000000180cULL, 0x000000423414723cULL, 0x040b700000001814ULL,
0x0000003c3418723cULL, 0x040b700000001818ULL, 0x0000003e341c723cULL, 0x040b70000000181cULL,
0x000000383420723cULL, 0x040b700000001820ULL, 0x0000003a3424723cULL, 0x000b620000001824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000c009317810ULL, 0x000fe20007ffe0ffULL,
0x0000000030ff7f8cULL, 0x0003e2000c80043fULL, 0x0000000112097810ULL, 0x000fc80007ffe0ffULL,
0x000000620900720cULL, 0x000fe20003f06070ULL, 0x0000680066097a24ULL, 0x000fe200078e0231ULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x0000061000008947ULL, 0x000fea0003800000ULL,
0x00000003ff387819ULL, 0x122fe20000011600ULL, 0x00000080633c7824ULL, 0x000fe200078e0269ULL,
0x0000003160307217ULL, 0x000fe20007800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000438327810ULL, 0x040fe20007ffe0ffULL, 0x0000000138377824ULL, 0x040fe200078e0209ULL,
0x00000010383e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000130307824ULL, 0x000fe200078e0a31ULL,
0x0000000c38367810ULL, 0x000fe20007ffe0ffULL, 0x0000000132487824ULL, 0x100fe200078e0200ULL,
0x0000000838347810ULL, 0x000fe20007ffe0ffULL, 0x0000000832337824ULL, 0x000fe200078e00ffULL,
0x0000002030417817ULL, 0x000fe20003800000ULL, 0x000000013e407824ULL, 0x000fe200078e0200ULL,
0x00000014384a7810ULL, 0x000fe20007ffe0ffULL, 0x000000083e357824ULL, 0x000fe200078e00ffULL,
0xfffffff833487812ULL, 0x000fe200078ee248ULL, 0x0000000136427824ULL, 0x040fe200078e0200ULL,
0x000000413600720cULL, 0x0c0fe20003f46070ULL, 0x0000000836337824ULL, 0x000fe200078e00ffULL,
0xfffffff835407812ULL, 0x000fe200078ee240ULL, 0x0000000134447824ULL, 0x040fe200078e0200ULL,
0x000000413400720cULL, 0x0c0fe20003f66070ULL, 0x0000000834317824ULL, 0x040fe200078e00ffULL,
0xfffffff833427812ULL, 0x000fe200078ee242ULL, 0x0000000134357824ULL, 0x100fe200078e0209ULL,
0x000000413200720cULL, 0x000fe20003fa6070ULL, 0x0000000136337824ULL, 0x000fe200078e0209ULL,
0xfffffff831447812ULL, 0x000fe200078ee244ULL, 0x0000010037367825ULL, 0x000fe200078e003cULL,
0x00000018384c7810ULL, 0x000fc40007ffe0ffULL, 0x0000001c384e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000132317824ULL, 0x000fe200078e0209ULL, 0x00006400363a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000010035347825ULL, 0x000fc600078e003cULL, 0x00006500373b7a10ULL, 0x000fe200007fe4ffULL,
0x0000010033327825ULL, 0x000fe200078e003cULL, 0x0000640034367a10ULL, 0x000fe40007f9e0ffULL,
0x000000414a00720cULL, 0x040fe20003f06070ULL, 0x000000014a467824ULL, 0x000fe200078e0200ULL,
0x0000640032347a10ULL, 0x000fe20007fde0ffULL, 0x000000084a397824ULL, 0x000fe200078e00ffULL,
0x0000650035377a10ULL, 0x000fe200027fe4ffULL, 0x0000010031307825ULL, 0x000fe200078e003cULL,
0x0000650033357a10ULL, 0x000fc400037fe4ffULL, 0xfffffff839467812ULL, 0x000fe200078ee246ULL,
0x0000000138397824ULL, 0x000fe200078e0200ULL, 0x0000640030307a10ULL, 0x000fe20007f3e0ffULL,
0x000000013e337824ULL, 0x100fe200078e0209ULL, 0x000000413800720cULL, 0x080fe20003f86070ULL,
0x000000014a3f7824ULL, 0x000fe200078e0209ULL, 0x0000000739457812ULL, 0x000fe200078ec0ffULL,
0x0000010033327825ULL, 0x000fe200078e003cULL, 0x0000650031317a10ULL, 0x000fe40000ffe4ffULL,
0x0ffffff8454a7812ULL, 0x000fe200078ef800ULL, 0x000000014c397824ULL, 0x100fe200078e0209ULL,
0x000000413e00720cULL, 0x000fe20003f26070ULL, 0x000000014e437824ULL, 0x000fe200078e0209ULL,
0x0000640032327a10ULL, 0x000fe20007fde0ffULL, 0x000001003f3e7825ULL, 0x000fc600078e003cULL,
0x0000650033337a10ULL, 0x000fe200037fe4ffULL, 0x0000010039387825ULL, 0x000fe200078e003cULL,
0x000064003e3e7a10ULL, 0x000fc60007fde0ffULL, 0x000000104a097824ULL, 0x000fe200078e0203ULL,
0x000065003f3f7a10ULL, 0x000fe200037fe4ffULL, 0x00000100433c7825ULL, 0x000fe200078e003cULL,
0x000000414c00720cULL, 0x000fe40003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a097faeULL, 0x0003e2000e101c46ULL, 0x0000001048437824ULL, 0x000fe200078e0203ULL,
0x0000640038387a10ULL, 0x000fe20007f9e0ffULL, 0x000000014e457824ULL, 0x000fc600078e0200ULL,
0x0000000030437faeULL, 0x0005e2000e901c46ULL, 0x000000414e00720cULL, 0x000fe20003fa6070ULL,
0x000000014c417824ULL, 0x040fe200078e0200ULL, 0x0000650039397a10ULL, 0x000fe200027fe4ffULL,
0x000000084c4c7824ULL, 0x000fe400078e00ffULL, 0x000000084e4e7824ULL, 0x000fe400078e00ffULL,
0x0000001044097824ULL, 0x002fe200078e0203ULL, 0xfffffff84c3a7812ULL, 0x000fe200078ee241ULL,
0x00000010423b7824ULL, 0x100fe200078e0203ULL, 0x000064003c307a10ULL, 0x004fe20007f9e0ffULL,
0x0000001046417824ULL, 0x000fe200078e0203ULL, 0xfffffff84e3c7812ULL, 0x000fe200078ee245ULL,
0x000000103a437824ULL, 0x100fe200078e0203ULL, 0x000065003d317a10ULL, 0x000fe200027fe4ffULL,
0x00000010403d7824ULL, 0x100fe200078e0203ULL, 0x0000000036097faeULL, 0x0003e2000d901c46ULL,
0x000000103c457824ULL, 0x000fc600078e0203ULL, 0x00000000343b7faeULL, 0x0003e8000d101c46ULL,
0x00000000323d7faeULL, 0x0003e8000c901c46ULL, 0x000000003e417faeULL, 0x0003e8000c101c46ULL,
0x0000000038437faeULL, 0x0003e8000f101c46ULL, 0x0000000030457faeULL, 0x0003e2000e901c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000000400317811ULL, 0x042fe200078fe8ffULL,
0x00000080633e7824ULL, 0x020fe200078e0269ULL, 0x0000000800337811ULL, 0x000fc400078fe8ffULL,
0x0000001400397811ULL, 0x040fe200078fe8ffULL, 0x00000001314a7824ULL, 0x140fe200078e0200ULL,
0x00000018003b7811ULL, 0x040fe200078fe8ffULL, 0x0000000831357824ULL, 0x000fe200078e00ffULL,
0x0000001c00307811ULL, 0x040fe200078fe8ffULL, 0x0000000133487824ULL, 0x040fe400078e0200ULL,
0x0000000833377824ULL, 0x000fe200078e00ffULL, 0xfffffff8354a7812ULL, 0x000fe200078ee24aULL,
0x0000000139427824ULL, 0x040fe200078e0200ULL, 0x0000000c00357811ULL, 0x040fe200078fe8ffULL,
0x0000000839417824ULL, 0x000fe200078e00ffULL, 0xfffffff837487812ULL, 0x000fe200078ee248ULL,
0x000000013b407824ULL, 0x100fe200078e0200ULL, 0x0000001000377811ULL, 0x000fe200078fe8ffULL,
0x0000000135467824ULL, 0x000fe200078e0200ULL, 0xfffffff841427812ULL, 0x000fe200078ee242ULL,
0x00000008353d7824ULL, 0x000fc400078e00ffULL, 0x0000000137447824ULL, 0x040fe400078e0200ULL,
0x00000008373f7824ULL, 0x000fe200078e00ffULL, 0xfffffff83d467812ULL, 0x000fe200078ee246ULL,
0x000000083b437824ULL, 0x000fe200078e00ffULL, 0x00000009003d7211ULL, 0x000fe200078fe8ffULL,
0x0000000131317824ULL, 0x100fe200078e0209ULL, 0xfffffff83f447812ULL, 0x000fe200078ee244ULL,
0x0000000133337824ULL, 0x100fe200078e0209ULL, 0xfffffff843407812ULL, 0x000fe200078ee240ULL,
0x0000000135357824ULL, 0x000fc400078e0209ULL, 0x0000000137377824ULL, 0x100fe400078e0209ULL,
0x0000000139397824ULL, 0x100fe400078e0209ULL, 0x000000013b3b7824ULL, 0x100fe400078e0209ULL,
0x000000ffff3f7224ULL, 0x000fe400078e00ffULL, 0x0000000130097824ULL, 0x040fe400078e0209ULL,
0x0000000130417824ULL, 0x000fc400078e0200ULL, 0x00000008304e7824ULL, 0x000fe400078e00ffULL,
0x000001003d3c7825ULL, 0x000fc600078e003eULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee241ULL,
0x0000010031307825ULL, 0x000fe200078e003eULL, 0x000064003c3c7a10ULL, 0x000fc60007f1e0ffULL,
0x0000010033327825ULL, 0x100fe200078e003eULL, 0x0000640030307a10ULL, 0x000fe40007f3e0ffULL,
0x000065003d3d7a10ULL, 0x000fe200007fe4ffULL, 0x0000010035347825ULL, 0x100fe200078e003eULL,
0x0000650031317a10ULL, 0x000fe40000ffe4ffULL, 0x0000640032327a10ULL, 0x000fe20007f1e0ffULL,
0x0000010037367825ULL, 0x100fe200078e003eULL, 0x0000640034347a10ULL, 0x000fe40007f3e0ffULL,
0x0000650033337a10ULL, 0x000fe200007fe4ffULL, 0x0000010039387825ULL, 0x000fe200078e003eULL,
0x0000640036367a10ULL, 0x000fc40007f5e0ffULL, 0x0000650035357a10ULL, 0x000fe20000ffe4ffULL,
0x000001003b3a7825ULL, 0x100fe200078e003eULL, 0x0000640038387a10ULL, 0x000fe40007f1e0ffULL,
0x0000650037377a10ULL, 0x000fe200017fe4ffULL, 0x00000100093e7825ULL, 0x000fe200078e003eULL,
0x0000000000097211ULL, 0x000fe400078fe8ffULL, 0x000064003a3a7a10ULL, 0x000fe20007f3e0ffULL,
0x000000104a417824ULL, 0x100fe200078e0203ULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x0000001048437824ULL, 0x100fe200078e0203ULL, 0x000064003e3e7a10ULL, 0x000fe20007f5e0ffULL,
0x0000001046457824ULL, 0x100fe200078e0203ULL, 0x0ffffff8094c7812ULL, 0x000fe200078ef800ULL,
0x0000001044477824ULL, 0x100fe200078e0203ULL, 0x0000650039397a10ULL, 0x000fe200007fe4ffULL,
0x0000001042497824ULL, 0x100fe200078e0203ULL, 0x000065003b3b7a10ULL, 0x000fe20000ffe4ffULL,
0x000000104c097824ULL, 0x100fe200078e0203ULL, 0x000065003f3f7a10ULL, 0x000fe200017fe4ffULL,
0x00000010404b7824ULL, 0x000fc400078e0203ULL, 0x000000104e4d7824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c097faeULL, 0x0003e8000b901c46ULL,
0x0000000030417faeULL, 0x0003e8000b901c46ULL, 0x0000000032437faeULL, 0x0003e8000b901c46ULL,
0x0000000034457faeULL, 0x0003e8000b901c46ULL, 0x0000000036477faeULL, 0x0003e8000b901c46ULL,
0x0000000038497faeULL, 0x0003e8000b901c46ULL, 0x000000003a4b7faeULL, 0x0003e8000b901c46ULL,
0x000000003e4d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000106b097812ULL, 0x002fca00078ec0ffULL, 0x0000002010107824ULL, 0x000fc800078e0209ULL,
0x0000000863107824ULL, 0x000fe200078e0210ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136480010307f8cULL, 0x0002a4000c80043fULL, 0x0000000000327805ULL, 0x000fc40000015200ULL,
0x01364c0010097984ULL, 0x000ee40000000800ULL, 0x8000000009ff7812ULL, 0x00cfe40007804831ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003432347210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e33ULL, 0x003d09003400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc80000011435ULL,
0x0000003409097211ULL, 0x000fca00078110ffULL, 0x000000ffff347224ULL, 0x000fca00000e0635ULL,
0x0000000209097819ULL, 0x000fc80000001234ULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01364c0010097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002013097824ULL, 0x000fca00078e00ffULL, 0xffffff8009107812ULL, 0x002fc800078ec0ffULL,
0x0000010069097810ULL, 0x000fca0007ffe010ULL, 0x000000016c097824ULL, 0x000fca00078e0209ULL,
0x0130000009337984ULL, 0x000e680000000800ULL, 0x0132000009327984ULL, 0x0004e20000000800ULL,
0x000000083300720bULL, 0x002fe20003f1d000ULL, 0x0000d7827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x004fc800000e0100ULL, 0x0000ffff10347812ULL, 0x000fe2000782c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x0000000213107811ULL, 0x000fe400078ff0ffULL,
0x000000083300720bULL, 0x000fe40003f34000ULL, 0x000000131000720cULL, 0x000fe20003f05270ULL,
0x0000d7327f007947ULL, 0x000fd4000b800000ULL, 0x0000000000097806ULL, 0x000fc400008e0100ULL,
0x0000008013318824ULL, 0x000fe200078e0269ULL, 0x0000000833108209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991009307816ULL, 0x000fe200000000ffULL,
0x000000016c318824ULL, 0x000fca00078e0231ULL, 0x0134001031008388ULL, 0x0003e20000000800ULL,
0x000000ff3000720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000833317209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff09ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000831107221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000367308ULL, 0x000e640000000800ULL,
0x000000360b0b7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe20000011600ULL, 0x0000d6527f007947ULL, 0x000fea000b800000ULL,
0x00001f1036107589ULL, 0x0002a400000e0000ULL, 0x000000102c2c7220ULL, 0x084fe20000410000ULL,
0x000000102d2d7220ULL, 0x080fe20000410000ULL, 0x0000001028287220ULL, 0x080fe20000410000ULL,
0x0000001029297220ULL, 0x080fe20000410000ULL, 0x000000100c0c7220ULL, 0x080fe20000410000ULL,
0x000000100d0d7220ULL, 0x080fe20000410000ULL, 0x0000001014147220ULL, 0x080fe20000410000ULL,
0x0000001015157220ULL, 0x080fe20000410000ULL, 0x0000001018187220ULL, 0x080fe20000410000ULL,
0x0000001019197220ULL, 0x080fe20000410000ULL, 0x000000101c1c7220ULL, 0x080fe20000410000ULL,
0x000000101d1d7220ULL, 0x080fe20000410000ULL, 0x0000001020207220ULL, 0x080fe20000410000ULL,
0x0000001021217220ULL, 0x080fe20000410000ULL, 0x0000001024247220ULL, 0x080fe20000410000ULL,
0x0000001025257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0009ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000800107811ULL, 0x000fe200078ff0ffULL, 0x0000d5327f007947ULL, 0x000fea000b800000ULL,
0x00001f1036107589ULL, 0x00046400000e0000ULL, 0x000000102e2e7220ULL, 0x086fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000100e0e7220ULL, 0x080fe20000410000ULL,
0x000000100f0f7220ULL, 0x080fe20000410000ULL, 0x0000001016167220ULL, 0x080fe20000410000ULL,
0x0000001017177220ULL, 0x080fe20000410000ULL, 0x000000101a1a7220ULL, 0x080fe20000410000ULL,
0x000000101b1b7220ULL, 0x080fe20000410000ULL, 0x000000101e1e7220ULL, 0x080fe20000410000ULL,
0x000000101f1f7220ULL, 0x080fe20000410000ULL, 0x0000001022227220ULL, 0x080fe20000410000ULL,
0x0000001023237220ULL, 0x080fe20000410000ULL, 0x0000001026267220ULL, 0x080fe20000410000ULL,
0x0000001027277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff34ff7812ULL, 0x000fe40007806009ULL, 0x0000000833087209ULL, 0x000fd60007810000ULL,
0x8000000833330221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b33330820ULL, 0x000fc80000410000ULL,
0x0000003300070308ULL, 0x000e640000000800ULL, 0x0000000732320220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x0000000b320b7221ULL, 0x008fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000007ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff327819ULL, 0x000fe40000011600ULL, 0x0000541004097816ULL, 0x000fe20000000004ULL,
0x0000d3627f007947ULL, 0x000fea000b800000ULL, 0x00001f3209057589ULL, 0x0002a400000e0000ULL,
0x0000000832107810ULL, 0x000fe20007ffe0ffULL, 0x0000d3927f007947ULL, 0x000fea000b800000ULL,
0x00001f1009047589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001032107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff307224ULL, 0x000fe200078e0009ULL,
0x000064e000317802ULL, 0x000fc40000000f00ULL, 0x0000d9d000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001832107810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff307224ULL, 0x000fe200078e0009ULL, 0x0000653000317802ULL, 0x000fc40000000f00ULL,
0x0000d98000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000006867107212ULL, 0x00cfe200078efcffULL, 0x0000020013307824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000213097824ULL, 0x002fc400078e00ffULL,
0x0000000810317824ULL, 0x000fe200078e00ffULL, 0xfffff80030307812ULL, 0x000fe400078ec0ffULL,
0x0000000409097812ULL, 0x000fe400078ec0ffULL, 0xfffffff831317812ULL, 0x000fe200078ee206ULL,
0x0000200013067824ULL, 0x000fe200078e00ffULL, 0x0000000209097812ULL, 0x000fc600078efcffULL,
0x0000001031487824ULL, 0x000fe200078e0230ULL, 0xffffc00006067812ULL, 0x000fe400078ec0ffULL,
0x0000000900097211ULL, 0x000fc600078fe0ffULL, 0x0000200063067824ULL, 0x000fe200078e0206ULL,
0x00a000004848783bULL, 0x000e620000000200ULL, 0x0000000110097824ULL, 0x040fe400078e0209ULL,
0x0000000810107824ULL, 0x000fe200078e00ffULL, 0x0000b00006067810ULL, 0x000fc80007ffe0ffULL,
0xfffffff810097812ULL, 0x000fe200078ee209ULL, 0x000000105e307824ULL, 0x100fe200078e0206ULL,
0x00000002ff107819ULL, 0x000fe20000011613ULL, 0x000000105d547824ULL, 0x100fe400078e0206ULL,
0x0000001011507824ULL, 0x100fe400078e0206ULL, 0x00000010024c7824ULL, 0x000fe200078e0206ULL,
0x000000003030783bULL, 0x000ea20000004200ULL, 0x0000001009067824ULL, 0x000fe200078e00ffULL,
0x0000b00058097810ULL, 0x000fc40007ffe0ffULL, 0x000000005454783bULL, 0x000ee20000004200ULL,
0x0000080010347824ULL, 0x000fe400078e0206ULL, 0x000000105c447824ULL, 0x100fe200078e0209ULL,
0x000000005050783bULL, 0x000fe20000004200ULL, 0x000000105b407824ULL, 0x100fe400078e0209ULL,
0x0000001059387824ULL, 0x100fe200078e0209ULL, 0x000000004c4c783bULL, 0x000fe20000004200ULL,
0x000000105a3c7824ULL, 0x000fc600078e0209ULL, 0x00a000003434783bULL, 0x000f280000000200ULL,
0x000000004444783bULL, 0x000f280000004200ULL, 0x000000004040783bULL, 0x000f220000004200ULL,
0x0000000548480232ULL, 0x082fe40000000000ULL, 0x000000054a4a0232ULL, 0x000fe20000000000ULL,
0x000000003c3c783bULL, 0x000e620000004200ULL, 0x0000000449490232ULL, 0x000fc40000000000ULL,
0x000000044b4b0232ULL, 0x000fe20000000000ULL, 0x000000003838783bULL, 0x000e6c0000004200ULL,
0x00000030482c723cULL, 0x044b6e000000182cULL, 0x0001369810307811ULL, 0x020fe200078e18ffULL,
0x000000324828723cULL, 0x040f700000001828ULL, 0x00000054480c723cULL, 0x008f62000000180cULL,
0x0000000534340232ULL, 0x010fc40000000000ULL, 0x0000000536360232ULL, 0x000fe40000000000ULL,
0x0000000435350232ULL, 0x080fe40000000000ULL, 0x0000000437370232ULL, 0x000fe20000000000ULL,
0x000000564814723cULL, 0x040f700000001814ULL, 0x000000504818723cULL, 0x040f700000001818ULL,
0x00000052481c723cULL, 0x040f70000000181cULL, 0x0000004c4820723cULL, 0x040f700000001820ULL,
0x0000004e4824723cULL, 0x000f700000001824ULL, 0x00000044342c723cULL, 0x040b70000000182cULL,
0x000000463428723cULL, 0x060b700000001828ULL, 0x00000040340c723cULL, 0x040b70000000180cULL,
0x000000423414723cULL, 0x040b700000001814ULL, 0x0000003c3418723cULL, 0x042b700000001818ULL,
0x0000003e341c723cULL, 0x040b70000000181cULL, 0x000000383420723cULL, 0x040b700000001820ULL,
0x0000003a3424723cULL, 0x000b620000001824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000030012337a10ULL, 0x000fe20007ffe0ffULL, 0x0000000030ff7f8cULL, 0x0003e6000c80043fULL,
0x000000623300720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00000ba000000947ULL, 0x000fea0003800000ULL, 0x0000000133317810ULL, 0x042fe20007ffe0ffULL,
0x0000010033337824ULL, 0x000fc600078e026aULL, 0x000000623100720cULL, 0x000fe20003f06070ULL,
0x00006800663f7a24ULL, 0x020fd800078e0233ULL, 0x0000061000008947ULL, 0x000fea0003800000ULL,
0x00000003ff417819ULL, 0x100fe40000011600ULL, 0x0000003360307217ULL, 0x000fe40007800000ULL,
0x0000000441377810ULL, 0x040fe20007ffe0ffULL, 0x0000000141357824ULL, 0x040fe200078e023fULL,
0x00000008413b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000130447824ULL, 0x000fe200078e0a33ULL,
0x0000000c41437810ULL, 0x000fe20007ffe0ffULL, 0x0000000137317824ULL, 0x100fe200078e0200ULL,
0x0000001041457810ULL, 0x000fe20007ffe0ffULL, 0x0000000837487824ULL, 0x000fe200078e00ffULL,
0x0000002044447817ULL, 0x000fe20003800000ULL, 0x000000013b3e7824ULL, 0x000fe200078e0200ULL,
0x0000001441477810ULL, 0x000fe20007ffe0ffULL, 0x000000083b337824ULL, 0x000fe200078e00ffULL,
0xfffffff848487812ULL, 0x000fe200078ee231ULL, 0x0000008063307824ULL, 0x000fe200078e0269ULL,
0x000000443700720cULL, 0x080fe20003f86070ULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0xfffffff8333e7812ULL, 0x000fe200078ee23eULL, 0x0000000137337824ULL, 0x000fe200078e023fULL,
0x000000443b00720cULL, 0x080fe20003f66070ULL, 0x0000000143427824ULL, 0x000fe200078e0200ULL,
0x000000444100720cULL, 0x080fe20003fa6070ULL, 0x0000010033327825ULL, 0x000fe200078e0030ULL,
0x000000444300720cULL, 0x000fc40003f46070ULL, 0x0000001c41497810ULL, 0x000fe20007ffe0ffULL,
0x0000000843377824ULL, 0x000fe200078e00ffULL, 0x0000640032367a10ULL, 0x000fe20007f3e0ffULL,
0x0000010035347825ULL, 0x000fc600078e0030ULL, 0xfffffff837427812ULL, 0x000fe200078ee242ULL,
0x0000000145407824ULL, 0x100fe200078e0200ULL, 0x0000650033377a10ULL, 0x000fe20000ffe4ffULL,
0x0000000845397824ULL, 0x000fe200078e00ffULL, 0x0000640034387a10ULL, 0x000fe20007f1e0ffULL,
0x0000000141327824ULL, 0x000fe200078e0200ULL, 0x000000444500720cULL, 0x000fe20003f26070ULL,
0x000000013b337824ULL, 0x100fe200078e023fULL, 0xfffffff839407812ULL, 0x000fe200078ee240ULL,
0x00000001453b7824ULL, 0x000fe200078e023fULL, 0x00000007323d7812ULL, 0x000fe200078ec0ffULL,
0x0000010033327825ULL, 0x000fe200078e0030ULL, 0x0000650035397a10ULL, 0x000fc400007fe4ffULL,
0x0ffffff83d3c7812ULL, 0x100fe200078ef800ULL, 0x0000000143357824ULL, 0x000fe200078e023fULL,
0x0000640032327a10ULL, 0x000fe20007f1e0ffULL, 0x0000000147467824ULL, 0x000fe400078e0200ULL,
0x0000010035347825ULL, 0x100fe200078e0030ULL, 0x0000650033337a10ULL, 0x000fe400007fe4ffULL,
0x000000444700720cULL, 0x040fe20003f06070ULL, 0x0000000847437824ULL, 0x000fe200078e00ffULL,
0x0000640034347a10ULL, 0x000fe20007fde0ffULL, 0x000001003b3a7825ULL, 0x000fc600078e0030ULL,
0xfffffff843467812ULL, 0x000fe200078ee246ULL, 0x00000001473d7824ULL, 0x000fe200078e023fULL,
0x0000001841477810ULL, 0x000fe20007ffe0ffULL, 0x000000103c437824ULL, 0x100fe200078e0209ULL,
0x0000650035357a10ULL, 0x000fe200037fe4ffULL, 0x0000001048457824ULL, 0x000fe200078e0209ULL,
0x000064003a3a7a10ULL, 0x000fe20007fde0ffULL, 0x000001003d3c7825ULL, 0x000fe200078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038437faeULL, 0x0003e2000e901c46ULL,
0x000000444700720cULL, 0x0c0fe40003fa6070ULL, 0x0000000147417824ULL, 0x100fe200078e023fULL,
0x000065003b3b7a10ULL, 0x000fe200037fe4ffULL, 0x0000000036457faeULL, 0x0005e2000e101c46ULL,
0x000064003c3c7a10ULL, 0x000fe20007fde0ffULL, 0x00000001493f7824ULL, 0x040fe200078e023fULL,
0x000000444900720cULL, 0x000fe20003f86070ULL, 0x0000000847447824ULL, 0x000fe200078e00ffULL,
0x000065003d3d7a10ULL, 0x000fe200037fe4ffULL, 0x0000000849487824ULL, 0x000fc400078e00ffULL,
0x0000010041387825ULL, 0x002fc800078e0030ULL, 0x0000000147417824ULL, 0x100fe200078e0200ULL,
0x0000640038367a10ULL, 0x004fe20007fde0ffULL, 0x0000000149377824ULL, 0x000fe400078e0200ULL,
0x000001003f307825ULL, 0x000fe200078e0030ULL, 0xfffffff844387812ULL, 0x000fe400078ee241ULL,
0xfffffff848447812ULL, 0x000fe200078ee237ULL, 0x00000010423f7824ULL, 0x100fe200078e0209ULL,
0x0000650039377a10ULL, 0x000fe200037fe4ffULL, 0x000000103e397824ULL, 0x100fe200078e0209ULL,
0x0000640030307a10ULL, 0x000fe20007fde0ffULL, 0x0000001040417824ULL, 0x000fc400078e0209ULL,
0x0000001046437824ULL, 0x100fe200078e0209ULL, 0x0000650031317a10ULL, 0x000fe200037fe4ffULL,
0x0000001038457824ULL, 0x100fe200078e0209ULL, 0x0000000032397faeULL, 0x0003e2000d901c46ULL,
0x0000001044097824ULL, 0x000fc600078e0209ULL, 0x00000000343f7faeULL, 0x0003e8000d101c46ULL,
0x000000003a417faeULL, 0x0003e8000c901c46ULL, 0x000000003c437faeULL, 0x0003e8000c101c46ULL,
0x0000000036457faeULL, 0x0003e8000e901c46ULL, 0x0000000030097faeULL, 0x0003e2000e101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x00000008003b7811ULL, 0x040fe200078fe8ffULL,
0x0000008063367824ULL, 0x000fe200078e0269ULL, 0x00000004003d7811ULL, 0x000fc400078fe8ffULL,
0x0000001400357811ULL, 0x040fe200078fe8ffULL, 0x000000013b427824ULL, 0x140fe200078e0200ULL,
0x0000000c00397811ULL, 0x040fe200078fe8ffULL, 0x000000083b337824ULL, 0x000fe200078e00ffULL,
0x0000001800417811ULL, 0x040fe200078fe8ffULL, 0x000000013d407824ULL, 0x040fe400078e0200ULL,
0x000000083d317824ULL, 0x000fe200078e00ffULL, 0xfffffff833427812ULL, 0x000fe200078ee242ULL,
0x0000000135327824ULL, 0x040fe200078e0200ULL, 0x0000001000337811ULL, 0x000fe200078fe8ffULL,
0x0000000835437824ULL, 0x000fe200078e00ffULL, 0xfffffff831407812ULL, 0x000fe200078ee240ULL,
0x0000000139307824ULL, 0x000fc400078e0200ULL, 0x0000000133317824ULL, 0x000fe200078e0200ULL,
0xfffffff8434a7812ULL, 0x000fe200078ee232ULL, 0x0000000833487824ULL, 0x000fe200078e00ffULL,
0x0000001c00327811ULL, 0x000fe200078fe8ffULL, 0x0000000839377824ULL, 0x000fe400078e00ffULL,
0x0000000141347824ULL, 0x040fe200078e0200ULL, 0xfffffff848487812ULL, 0x000fe200078ee231ULL,
0x0000000841457824ULL, 0x000fe200078e00ffULL, 0xfffffff837467812ULL, 0x000fe200078ee230ULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x0000003f00317211ULL, 0x040fe200078fe8ffULL,
0x000000013d3d7824ULL, 0x100fe200078e023fULL, 0x0000000000307211ULL, 0x000fe200078fe8ffULL,
0x000000013b3b7824ULL, 0x100fe200078e023fULL, 0xfffffff8454c7812ULL, 0x000fe200078ee234ULL,
0x0000000139397824ULL, 0x100fe200078e023fULL, 0x0000000730457812ULL, 0x000fe200078ec0ffULL,
0x0000000133337824ULL, 0x000fc400078e023fULL, 0x0000000135357824ULL, 0x100fe200078e023fULL,
0x0ffffff845447812ULL, 0x000fe200078ef800ULL, 0x0000000141417824ULL, 0x100fe400078e023fULL,
0x0000000132437824ULL, 0x000fe400078e023fULL, 0x00000100313e7825ULL, 0x000fc800078e0036ULL,
0x000001003d3c7825ULL, 0x000fe200078e0036ULL, 0x000064003e3e7a10ULL, 0x000fc60007f1e0ffULL,
0x000001003b3a7825ULL, 0x100fe200078e0036ULL, 0x000064003c3c7a10ULL, 0x000fe40007f3e0ffULL,
0x000065003f3f7a10ULL, 0x000fe200007fe4ffULL, 0x0000010039387825ULL, 0x000fe200078e0036ULL,
0x000064003a3a7a10ULL, 0x000fe40007f5e0ffULL, 0x000065003d3d7a10ULL, 0x000fe20000ffe4ffULL,
0x0000000132477824ULL, 0x000fe200078e0200ULL, 0x0000640038387a10ULL, 0x000fe20007f7e0ffULL,
0x00000008324e7824ULL, 0x000fe200078e00ffULL, 0x000065003b3b7a10ULL, 0x000fe200017fe4ffULL,
0x0000010033307825ULL, 0x000fe200078e0036ULL, 0x0000650039397a10ULL, 0x000fc40001ffe4ffULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee247ULL, 0x0000010035327825ULL, 0x000fe200078e0036ULL,
0x0000640030307a10ULL, 0x000fc60007f1e0ffULL, 0x0000010041347825ULL, 0x100fe200078e0036ULL,
0x0000640032327a10ULL, 0x000fe40007f3e0ffULL, 0x0000650031317a10ULL, 0x000fe200007fe4ffULL,
0x0000010043367825ULL, 0x000fe200078e0036ULL, 0x0000640034347a10ULL, 0x000fe40007f5e0ffULL,
0x0000650033337a10ULL, 0x000fe20000ffe4ffULL, 0x0000001044417824ULL, 0x100fe200078e0209ULL,
0x0000640036367a10ULL, 0x000fe20007f7e0ffULL, 0x0000001040437824ULL, 0x100fe200078e0209ULL,
0x0000650035357a10ULL, 0x000fe200017fe4ffULL, 0x0000001042457824ULL, 0x100fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e417faeULL, 0x0003e2000b901c46ULL,
0x0000001046477824ULL, 0x100fe200078e0209ULL, 0x0000650037377a10ULL, 0x000fe20001ffe4ffULL,
0x0000001048497824ULL, 0x100fe200078e0209ULL, 0x000000003c437faeULL, 0x0003e2000b901c46ULL,
0x000000104a4b7824ULL, 0x000fc400078e0209ULL, 0x000000104c4d7824ULL, 0x100fe200078e0209ULL,
0x000000003a457faeULL, 0x0003e2000b901c46ULL, 0x000000104e097824ULL, 0x000fc600078e0209ULL,
0x0000000038477faeULL, 0x0003e8000b901c46ULL, 0x0000000030497faeULL, 0x0003e8000b901c46ULL,
0x00000000324b7faeULL, 0x0003e8000b901c46ULL, 0x00000000344d7faeULL, 0x0003e8000b901c46ULL,
0x0000000036097faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x000000106b097812ULL, 0x000fc400078ec0ffULL, 0x000000086b307812ULL, 0x000fc600078ec0ffULL,
0x0000002010097824ULL, 0x000fc800078e0209ULL, 0x0000000130097824ULL, 0x000fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136680009327f8cULL, 0x0002a4000c80043fULL,
0x0000000000307805ULL, 0x000fc40000015200ULL, 0x01366c0009357984ULL, 0x020ee40000000800ULL,
0x8000000035ff7812ULL, 0x00cfe40007804833ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003430377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e31ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x000fc80000011435ULL, 0x0000003710107211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000210107819ULL, 0x000fc80000001235ULL,
0x000000100000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01366c0009357984ULL, 0x000ea40000000800ULL, 0x8000000035ff7812ULL, 0x004fe40007804833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000313107811ULL, 0x000fca00078ff0ffULL,
0x0000008010097824ULL, 0x002fc800078e0269ULL, 0x000000016c097824ULL, 0x000fca00078e0209ULL,
0x0130000009337984ULL, 0x000e680000000800ULL, 0x0132000009347984ULL, 0x0004e20000000800ULL,
0x000000083300720bULL, 0x002fe20003f1d000ULL, 0x0000bf827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x004fc800000e0100ULL, 0x0000ffff10367812ULL, 0x000fe2000782c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff327224ULL, 0x000fd400078e0008ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x0000000313107811ULL, 0x000fe400078ff0ffULL, 0x000000083300720bULL, 0x000fe40003f34000ULL,
0x000000131000720cULL, 0x000fe20003f05270ULL, 0x0000bf227f007947ULL, 0x000fd4000b800000ULL,
0x0000000000097806ULL, 0x000fc400008e0100ULL, 0x0000008013698824ULL, 0x000fe200078e0269ULL,
0x0000000833108209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991009307816ULL, 0x000fe200000000ffULL, 0x000000016c698824ULL, 0x000fca00078e0269ULL,
0x0134001069008388ULL, 0x0003e20000000800ULL, 0x000000ff3000720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000833317209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff09ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000831107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000327308ULL, 0x000e640000000800ULL, 0x000000320b0b7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe20000011600ULL,
0x0000be427f007947ULL, 0x000fea000b800000ULL, 0x00001f1032107589ULL, 0x0002a400000e0000ULL,
0x000000102c2c7220ULL, 0x084fe20000410000ULL, 0x000000102d2d7220ULL, 0x080fe20000410000ULL,
0x0000001028287220ULL, 0x080fe20000410000ULL, 0x0000001029297220ULL, 0x080fe20000410000ULL,
0x000000100c0c7220ULL, 0x080fe20000410000ULL, 0x000000100d0d7220ULL, 0x080fe20000410000ULL,
0x0000001014147220ULL, 0x080fe20000410000ULL, 0x0000001015157220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x080fe20000410000ULL,
0x000000101c1c7220ULL, 0x080fe20000410000ULL, 0x000000101d1d7220ULL, 0x080fe20000410000ULL,
0x0000001020207220ULL, 0x080fe20000410000ULL, 0x0000001021217220ULL, 0x080fe20000410000ULL,
0x0000001024247220ULL, 0x080fe20000410000ULL, 0x0000001025257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0009ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000800107811ULL, 0x000fe200078ff0ffULL,
0x0000bd227f007947ULL, 0x000fea000b800000ULL, 0x00001f1032107589ULL, 0x00046400000e0000ULL,
0x000000102e2e7220ULL, 0x086fe20000410000ULL, 0x000000102f2f7220ULL, 0x080fe20000410000ULL,
0x000000102a2a7220ULL, 0x080fe20000410000ULL, 0x000000102b2b7220ULL, 0x080fe20000410000ULL,
0x000000100e0e7220ULL, 0x080fe20000410000ULL, 0x000000100f0f7220ULL, 0x080fe20000410000ULL,
0x0000001016167220ULL, 0x080fe20000410000ULL, 0x0000001017177220ULL, 0x080fe20000410000ULL,
0x000000101a1a7220ULL, 0x080fe20000410000ULL, 0x000000101b1b7220ULL, 0x080fe20000410000ULL,
0x000000101e1e7220ULL, 0x080fe20000410000ULL, 0x000000101f1f7220ULL, 0x080fe20000410000ULL,
0x0000001022227220ULL, 0x080fe20000410000ULL, 0x0000001023237220ULL, 0x080fe20000410000ULL,
0x0000001026267220ULL, 0x080fe20000410000ULL, 0x0000001027277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff36ff7812ULL, 0x000fe40007806009ULL,
0x0000000833327209ULL, 0x000fd60007810000ULL, 0x8000003233330221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b33330820ULL, 0x000fc80000410000ULL, 0x0000003300070308ULL, 0x000e640000000800ULL,
0x0000000734340220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x0000000b340b7221ULL, 0x008fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000007ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff097819ULL, 0x000fe40000011600ULL,
0x0000541004087816ULL, 0x000fe20000000004ULL, 0x0000bb527f007947ULL, 0x000fea000b800000ULL,
0x00001f0908057589ULL, 0x0002a400000e0000ULL, 0x0000000809107810ULL, 0x000fe20007ffe0ffULL,
0x0000bb827f007947ULL, 0x000fea000b800000ULL, 0x00001f1008047589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001009107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x000fe200078e0008ULL, 0x00007eb000317802ULL, 0x000fc40000000f00ULL,
0x0000c00000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001809107810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff307224ULL, 0x000fe200078e0008ULL,
0x00007f0000317802ULL, 0x000fc40000000f00ULL, 0x0000bfb000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000213087824ULL, 0x00afe200078e00ffULL,
0x0000006867677212ULL, 0x000fe200078efcffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x0000000408097812ULL, 0x000fe200078ec0ffULL, 0x0000000867317824ULL, 0x000fc600078e00ffULL,
0x0000000900087211ULL, 0x000fe400078fe0ffULL, 0x0000000313097811ULL, 0x000fc600078ff0ffULL,
0x0000000167087824ULL, 0x000fe400078e0208ULL, 0x0000080009097824ULL, 0x000fc600078e00ffULL,
0xfffffff831087812ULL, 0x000fca00078ee208ULL, 0x0000001008087824ULL, 0x000fca00078e0209ULL,
0x00900000083c783bULL, 0x000e620000000200ULL, 0x000000105e447824ULL, 0x100fe200078e0203ULL,
0x0000900009067810ULL, 0x000fe20007ffe006ULL, 0x000000105d587824ULL, 0x100fe200078e0203ULL,
0x000000005f4c783bULL, 0x000fe20000004200ULL, 0x0000001011547824ULL, 0x100fe200078e0203ULL,
0x0000030012127a10ULL, 0x000fe20007ffe0ffULL, 0x0000001002507824ULL, 0x000fe200078e0203ULL,
0x000000004444783bULL, 0x000ee20000004200ULL, 0x00000002ff027819ULL, 0x000fc60000011613ULL,
0x000000005858783bULL, 0x000fe20000004200ULL, 0x000136a002027811ULL, 0x000fc600078e18ffULL,
0x000000005454783bULL, 0x000fe80000004200ULL, 0x000000005050783bULL, 0x000fe80000004200ULL,
0x000000000634783bULL, 0x000f280000000200ULL, 0x000000006148783bULL, 0x000ea80000004200ULL,
0x000000006440783bULL, 0x000ea80000004200ULL, 0x000000006538783bULL, 0x000ea40000004200ULL,
0x000000053c3c0232ULL, 0x006fc40000000000ULL, 0x000000053e3e0232ULL, 0x000fe40000000000ULL,
0x000000043d3d0232ULL, 0x080fe40000000000ULL, 0x000000043f3f0232ULL, 0x000fce0000000000ULL,
0x000000443c2c723cULL, 0x048f70000000182cULL, 0x000000463c28723cULL, 0x000f620000001828ULL,
0x0000000534340232ULL, 0x090fe40000000000ULL, 0x0000000536360232ULL, 0x000fc40000000000ULL,
0x0000000435350232ULL, 0x000fc60000000000ULL, 0x000000583c0c723cULL, 0x000f62000000180cULL,
0x0000000437370232ULL, 0x000fce0000000000ULL, 0x0000005a3c14723cULL, 0x040f700000001814ULL,
0x000000543c18723cULL, 0x040f700000001818ULL, 0x000000563c1c723cULL, 0x040f70000000181cULL,
0x000000503c20723cULL, 0x040f700000001820ULL, 0x000000523c24723cULL, 0x000f700000001824ULL,
0x0000004c342c723cULL, 0x060b70000000182cULL, 0x0000004e3428723cULL, 0x040b700000001828ULL,
0x00000048340c723cULL, 0x040b70000000180cULL, 0x0000004a3414723cULL, 0x040b700000001814ULL,
0x000000403418723cULL, 0x040b700000001818ULL, 0x00000042341c723cULL, 0x040b70000000181cULL,
0x000000383420723cULL, 0x040b700000001820ULL, 0x0000003a3424723cULL, 0x000b620000001824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000621200720cULL, 0x000fe20003f06070ULL,
0x0000000002ff7f8cULL, 0x0003d8000c80043fULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff97e000007947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x000e620000002500ULL,
0x000000ffff057224ULL, 0x020fe400078e000fULL, 0x000000ffff117224ULL, 0x000fe200078e000eULL,
0x000000620200720cULL, 0x002fda0003f06070ULL, 0x0000033000000947ULL, 0x000fea0003800000ULL,
0x018000000b007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000083b000067802ULL, 0x000fc40000000f00ULL,
0x0000b95000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000b00007308ULL, 0x000e640000001000ULL,
0xbf80000000037423ULL, 0x002fc8000000000bULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000ea40000000000ULL, 0x00000002ff037819ULL, 0x004fe40000011604ULL,
0x0000000804077811ULL, 0x000fc800078ff0ffULL, 0x00001f0300037589ULL, 0x000ea800000e0000ULL,
0x00001f0700047589ULL, 0x000ee200000e0000ULL, 0x0000002c032c7220ULL, 0x044fe20000410000ULL,
0x0000002d032d7220ULL, 0x040fe20000410000ULL, 0x0000002803287220ULL, 0x040fe20000410000ULL,
0x0000002903297220ULL, 0x040fe20000410000ULL, 0x0000000c030c7220ULL, 0x040fe20000410000ULL,
0x0000000d030d7220ULL, 0x040fe20000410000ULL, 0x0000001403147220ULL, 0x040fe20000410000ULL,
0x0000001503157220ULL, 0x040fe20000410000ULL, 0x0000001803187220ULL, 0x040fe20000410000ULL,
0x0000001903197220ULL, 0x040fe20000410000ULL, 0x0000001c031c7220ULL, 0x040fe20000410000ULL,
0x0000001d031d7220ULL, 0x040fe20000410000ULL, 0x0000002003207220ULL, 0x040fe20000410000ULL,
0x0000002103217220ULL, 0x040fe20000410000ULL, 0x0000002403247220ULL, 0x040fe20000410000ULL,
0x0000002503257220ULL, 0x000fe20000410000ULL, 0x0000002e042e7220ULL, 0x048fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x040fe20000410000ULL,
0x0000000504057220ULL, 0x040fe20000410000ULL, 0x0000001604167220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x000fc20000410000ULL, 0x0000000000077919ULL, 0x000ea20000000000ULL,
0x0000000c0d06723eULL, 0x000fc400000000ffULL, 0x0000001c1d0c723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000181909723eULL, 0x000fe400000000ffULL,
0x000000110511723eULL, 0x000fe400000000ffULL, 0x000000141508723eULL, 0x000fc400000000ffULL,
0x0000001e1f15723eULL, 0x000fe400000000ffULL, 0x0000001a1b14723eULL, 0x000fe400000000ffULL,
0x000000161712723eULL, 0x000fe400000000ffULL, 0x000000222316723eULL, 0x000fe400000000ffULL,
0x00000002ff1c7819ULL, 0x004fe40000011607ULL, 0x00000024250e723eULL, 0x000fc400000000ffULL,
0x000000021c057810ULL, 0x040fe20007ffe0ffULL, 0x000000081c187824ULL, 0x040fe200078e00ffULL,
0x000000061c197810ULL, 0x040fe20007ffe0ffULL, 0x000000081c1e7824ULL, 0x040fe200078e00ffULL,
0x000000011c007810ULL, 0x040fe20007ffe0ffULL, 0x000000081c1b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8181d7812ULL, 0x000fe200078ee205ULL, 0x000000081c1a7824ULL, 0x040fe200078e00ffULL,
0x000000041c057810ULL, 0x040fe20007ffe0ffULL, 0x000000081c237824ULL, 0x040fe200078e00ffULL,
0x000000051c187810ULL, 0x040fe20007ffe0ffULL, 0x000000081c1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e257812ULL, 0x000fe200078ee219ULL, 0x000000081c197824ULL, 0x000fe200078e00ffULL,
0x00000020210d723eULL, 0x000fe200000000ffULL, 0x00000300ff207624ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fc400078ee200ULL, 0x000000031c007810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81a217812ULL, 0x000fe200078ee205ULL, 0x0000100063057824ULL, 0x000fe200078e00ffULL,
0x000000282904723eULL, 0x000fe400000000ffULL, 0xfffffff823237812ULL, 0x000fe200078ee218ULL,
0x0000000407187824ULL, 0x040fe200078e00ffULL, 0x0000000807297811ULL, 0x000fe400078ff0ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee200ULL, 0x000008000a007824ULL, 0x000fe200078e0205ULL,
0xfffffff819197812ULL, 0x000fc400078ee21cULL, 0x000000262717723eULL, 0x000fe200000000ffULL,
0x000000081c277824ULL, 0x040fe200078e00ffULL, 0xffffffff1c1a7810ULL, 0x000fe20007ffe0ffULL,
0x00000008291c7824ULL, 0x000fe200078e00ffULL, 0x0000000c18187812ULL, 0x000fe200078ec0ffULL,
0x0000001019197824ULL, 0x000fe200078e0200ULL, 0xfffffff827277812ULL, 0x000fe200078ee21aULL,
0x000000101b1b7824ULL, 0x100fe200078e0200ULL, 0xfffffff81c297812ULL, 0x000fe200078ee229ULL,
0x000000101d1d7824ULL, 0x100fe200078e0200ULL, 0x0000002c2d03723eULL, 0x000fe200000000ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0200ULL, 0x0000002e2f0f723eULL, 0x000fe200000000ffULL,
0x0000001021217824ULL, 0x000fe200078e0200ULL, 0x0000002a2b10723eULL, 0x000fe200000000ffULL,
0x00000001191a7824ULL, 0x000fe200078e0218ULL, 0x000000012000780cULL, 0x000fe20003f05270ULL,
0x0000001023237824ULL, 0x000fc400078e0200ULL, 0x00000001181b7824ULL, 0x040fe200078e021bULL,
0x000000031a007388ULL, 0x0005e20000000800ULL, 0x0000001025257824ULL, 0x100fe400078e0200ULL,
0x00000001181d7824ULL, 0x040fe200078e021dULL, 0x000000041b007388ULL, 0x0007e20000000800ULL,
0x0000001027277824ULL, 0x100fe400078e0200ULL, 0x00000001181f7824ULL, 0x000fe200078e021fULL,
0x000000061d007388ULL, 0x000fe20000000800ULL, 0x0000001029297824ULL, 0x000fc400078e0200ULL,
0x0000000118217824ULL, 0x040fe200078e0221ULL, 0x000000081f007388ULL, 0x000fe20000000800ULL,
0x0000000118237824ULL, 0x040fe400078e0223ULL, 0x0000000118257824ULL, 0x040fe200078e0225ULL,
0x0000000921007388ULL, 0x000fe20000000800ULL, 0x0000000118277824ULL, 0x040fe400078e0227ULL,
0x0000000118187824ULL, 0x000fe200078e0229ULL, 0x0000000c23007388ULL, 0x000fe20000000800ULL,
0x000000016a1a7824ULL, 0x004fc600078e0207ULL, 0x0000000d25007388ULL, 0x000fe20000000800ULL,
0x000000101a047824ULL, 0x008fc600078e0205ULL, 0x0000000e27007388ULL, 0x000fe80000000800ULL,
0x0000000f18007388ULL, 0x000fe80000000800ULL, 0x000400101b007388ULL, 0x000fe80000000800ULL,
0x000400111d007388ULL, 0x000fe80000000800ULL, 0x000400121f007388ULL, 0x000fe80000000800ULL,
0x0004001421007388ULL, 0x000fe80000000800ULL, 0x0004001523007388ULL, 0x000fe80000000800ULL,
0x0004001625007388ULL, 0x000fe80000000800ULL, 0x0004001727007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000040c7984ULL, 0x000ea80000000c00ULL,
0x00040000042c7984ULL, 0x000ee80000000c00ULL, 0x0008000004287984ULL, 0x000f280000000c00ULL,
0x000c000004347984ULL, 0x000e620000000c00ULL, 0x200000ff0f0f7230ULL, 0x004fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff2f2f7230ULL, 0x008fe40000000000ULL,
0x200000ff2e2e7230ULL, 0x000fe40000000000ULL, 0x200000ff2d2d7230ULL, 0x000fc40000000000ULL,
0x200000ff2c2c7230ULL, 0x000fe40000000000ULL, 0x0000002b0f0f7230ULL, 0x010fe40000000000ULL,
0x0000002a0e0e7230ULL, 0x000fe40000000000ULL, 0x000000290d0d7230ULL, 0x000fe40000000000ULL,
0x000000280c0c7230ULL, 0x000fe40000000000ULL, 0x000000372f2f7230ULL, 0x002fc40000000000ULL,
0x000000362e2e7230ULL, 0x000fe20000000000ULL, 0x0000000c04007388ULL, 0x000fe20000000c00ULL,
0x000000352d2d7230ULL, 0x000fe40000000000ULL, 0x000000342c2c7230ULL, 0x000fca0000000000ULL,
0x0004002c04007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00002a8000008947ULL, 0x000fea0003800000ULL, 0x00000400ff037624ULL, 0x000fe200078e00ffULL,
0x0000000000087919ULL, 0x000e660000002600ULL, 0x00006a0003037a24ULL, 0x000fe200078e02ffULL,
0x0000000000097919ULL, 0x000e680000002700ULL, 0x0000000f03107811ULL, 0x040fe200078e10ffULL,
0x0000030003037a24ULL, 0x000fe200078e02ffULL, 0x00000000040c7984ULL, 0x000ea40000000c00ULL,
0xfffffff010107812ULL, 0x000fc400078ec0ffULL, 0x0004000004147984ULL, 0x0006a60000000c00ULL,
0x0000008003067824ULL, 0x000fc800078e0210ULL, 0x0000008003037824ULL, 0x000fca00078e0206ULL,
0x0000007f03037810ULL, 0x000fe20007ffe0ffULL, 0x0000040009087a24ULL, 0x002fc600078e0208ULL,
0xffffff8003037812ULL, 0x000fe200078ec0ffULL, 0x0000030008097a24ULL, 0x000fc600078e02ffULL,
0x00006e0003197a10ULL, 0x000fe20007f1e0ffULL, 0x0000000109027824ULL, 0x000fc800078e0202ULL,
0x00006f00ff117624ULL, 0x000fe200000e06ffULL, 0x000000010aff7812ULL, 0x000fe4000780f813ULL,
0x0000001902187211ULL, 0x000fc800078260ffULL, 0x0000001102197211ULL, 0x000fe400008f64ffULL,
0x000000401a117810ULL, 0x000fe40007ffe0ffULL, 0x00006e0010047a10ULL, 0x008fe20007f3e0ffULL,
0x0000080063187825ULL, 0x000fc800078e0018ULL, 0x00006f00ff127624ULL, 0x000fe400008e06ffULL,
0x000000101a1a7825ULL, 0x000fc800078e0018ULL, 0x0000001011187825ULL, 0x000fe200078e0018ULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x00000010071c7824ULL, 0x004fe200078e00ffULL,
0x00000001ff1d7819ULL, 0x000fe20000011607ULL, 0x0000008002117824ULL, 0x000fe200078e00ffULL,
0x00000019ff027819ULL, 0x000fe40000011602ULL, 0x000000701c1f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c1d1c7812ULL, 0x000fe400078ec0ffULL, 0x00006e00111e7a10ULL, 0x000fc40007ebe006ULL,
0x000000041f117210ULL, 0x000fe40007a3e011ULL, 0x0000001e1c1e7210ULL, 0x000fe40007c7e01fULL,
0x00006f00021d7a10ULL, 0x000fe40002fec4ffULL, 0x000000111c1c7210ULL, 0x000fe40007fbe0ffULL,
0x00000012ff027210ULL, 0x000fe40000fe4402ULL, 0x0000001dff1f7210ULL, 0x000fc60001fe84ffULL,
0x000000ffff1d7224ULL, 0x000fca00028e0602ULL, 0x000000321c007986ULL, 0x0003e8000c101906ULL,
0x0000000b1e007986ULL, 0x0003e4000c101906ULL, 0x000000ff0700720cULL, 0x004fe20000705670ULL,
0x0000000c1a007986ULL, 0x000fe2000c101d06ULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x0000001418007986ULL, 0x000fe8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000004ff0d7424ULL, 0x000fe200078e00ffULL,
0xffffffff200b7810ULL, 0x002fc60007ffe0ffULL, 0x00006e00080c7625ULL, 0x000fe200078e000dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x0000000b0c0c79a8ULL, 0x000ea400099ee1c6ULL,
0x0000000b0c00720cULL, 0x004fc80003f05270ULL, 0x00000001ff027807ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000002ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000ff027984ULL, 0x002e640000000000ULL, 0x000000ff0200720cULL, 0x002fda0003f05270ULL,
0x0000260000008947ULL, 0x000fea0003800000ULL, 0x000000ff1300720cULL, 0x000fda0003f05270ULL,
0x00000a5000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x000001b000008947ULL, 0x000fea0003800000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00000001ff087819ULL, 0x000fe40000011607ULL, 0x00000004090c7211ULL, 0x040fe400078038ffULL,
0x00000070020d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c08087812ULL, 0x000fe400078ec0ffULL,
0x0000001209027211ULL, 0x000fe400000f3cffULL, 0x0000000c080c7210ULL, 0x000fc8000791e00dULL,
0x00000002ff0d7210ULL, 0x000fca00007e24ffULL, 0x000000060c027981ULL, 0x000328000c1e1900ULL,
0x000080060c0b7981ULL, 0x000322000c1e1900ULL, 0x000000022000780cULL, 0x000fda0003f05270ULL,
0x000000f000008947ULL, 0x000fea0003800000ULL, 0x000100060c0f7981ULL, 0x002322000c1e1900ULL,
0x000000042000780cULL, 0x000fda0003f06070ULL, 0x000000c000008947ULL, 0x000fea0003800000ULL,
0x000180060c117981ULL, 0x002322000c1e1900ULL, 0x000000042000780cULL, 0x000fda0003f05270ULL,
0x0000009000008947ULL, 0x000fea0003800000ULL, 0x000200060c157981ULL, 0x002322000c1e1900ULL,
0x000000062000780cULL, 0x000fda0003f06070ULL, 0x0000006000008947ULL, 0x000fea0003800000ULL,
0x000280060c177981ULL, 0x002322000c1e1900ULL, 0x000000062000780cULL, 0x000fda0003f05270ULL,
0x0000003000008947ULL, 0x000fea0003800000ULL, 0x000000082000780cULL, 0x002fe20003f06070ULL,
0x000300060c197981ULL, 0x000318000c1e1900ULL, 0x000380060c1b0981ULL, 0x000324000c1e1900ULL,
0x0000000720047810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff047819ULL, 0x000fc80000011604ULL,
0x000000ff0400720cULL, 0x000fda0003f05270ULL, 0x000007d000008947ULL, 0x000fea0003800000ULL,
0x00000010091f7211ULL, 0x000fe200078038ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1d7224ULL, 0x010fe200078e0002ULL,
0x00006e001f1f7a10ULL, 0x000fe40007f3e0ffULL, 0x000000ff09087211ULL, 0x000fe400000f3cffULL,
0x000007801f1f7810ULL, 0x000fc80007f5e0ffULL, 0x00006f00ff087a10ULL, 0x000fc400017e2408ULL,
0x000003000e007a0cULL, 0x000fe20003f26070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x0000000404007c0cULL, 0x000fcc000bf03070ULL, 0x000006d000001947ULL, 0x012fea0003800000ULL,
0x000000080e0c7810ULL, 0x040fe40007ffe0ffULL, 0x000000010e0d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001d02027209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010070c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011607ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0608ULL,
0xfffc80060c1d7981ULL, 0x000326000c1e1900ULL, 0x000005f000002947ULL, 0x000fea0003800000ULL,
0x000000090e0c7810ULL, 0x042fe40007ffe0ffULL, 0x000000020e0d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000000b02027209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010070b7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fc80000011607ULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0b0c7812ULL, 0x000fc800078ef80cULL,
0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0608ULL,
0xfffd00060c0b7981ULL, 0x000326000c1e1900ULL, 0x0000051000002947ULL, 0x000fea0003800000ULL,
0x0000000a0e0c7810ULL, 0x042fe40007ffe0ffULL, 0x000000030e0d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000000f02027209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010070c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011607ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0608ULL,
0xfffd80060c0f7981ULL, 0x000326000c1e1900ULL, 0x0000043000002947ULL, 0x000fea0003800000ULL,
0x0000000b0e0c7810ULL, 0x042fe40007ffe0ffULL, 0x000000040e0d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001102027209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010070c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011607ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0608ULL,
0xfffe00060c117981ULL, 0x000326000c1e1900ULL, 0x0000035000002947ULL, 0x000fea0003800000ULL,
0x0000000c0e0c7810ULL, 0x042fe40007ffe0ffULL, 0x000000050e0d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001502027209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010070c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011607ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0608ULL,
0xfffe80060c157981ULL, 0x000326000c1e1900ULL, 0x0000027000002947ULL, 0x000fea0003800000ULL,
0x0000000d0e0c7810ULL, 0x042fe40007ffe0ffULL, 0x000000060e0d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001702027209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010070c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011607ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0608ULL,
0xffff00060c177981ULL, 0x000326000c1e1900ULL, 0x0000019000002947ULL, 0x000fea0003800000ULL,
0x0000000e0e0c7810ULL, 0x042fe40007ffe0ffULL, 0x000000070e0d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001902027209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010070c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011607ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0608ULL,
0xffff80060c197981ULL, 0x000326000c1e1900ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000000f0e0c7810ULL, 0x002fe40007ffe0ffULL, 0x0000001b02027209ULL, 0x000fe40007810000ULL,
0x000003000c007a0cULL, 0x000fda0003f26070ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010070c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011607ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0608ULL,
0x000000060c1b7981ULL, 0x000326000c1e1900ULL, 0x000004001f1f7810ULL, 0x000fe40007f3e0ffULL,
0x000000080e0e7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff087224ULL, 0x000fe200008e0608ULL,
0xfffff8b000008947ULL, 0x000fea000383ffffULL, 0x0000000000077919ULL, 0x000ea40000000000ULL,
0x0000001007047824ULL, 0x004fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fc80000011607ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c080b7812ULL, 0x010fca00078ec0ffULL,
0x00000001040b7824ULL, 0x000fca00078e020bULL, 0x000000020b007388ULL, 0x0005e40000000800ULL,
0x000000070700780cULL, 0x000fe20003f04070ULL, 0x000000010a197824ULL, 0x000fe200078e0209ULL,
0x00006e0003027a10ULL, 0x004fe20007f3e0ffULL, 0x0000080063047824ULL, 0x000fe200078e00ffULL,
0x00000002ff087819ULL, 0x000fe20000011613ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00006f00ff037624ULL, 0x000fe200008e06ffULL, 0x0000000108087812ULL, 0x000fe200078ec0ffULL,
0x000000020a0b8824ULL, 0x000fe200078e0263ULL, 0x0000004007157810ULL, 0x000fe20007ffe0ffULL,
0x00001000190c7825ULL, 0x002fe200078e0002ULL, 0x00000060071d7810ULL, 0x000fe20007ffe0ffULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x000000020b1e8824ULL, 0x100fe200078e0208ULL, 0x000000040c0e7210ULL, 0x000fe20007f3e0ffULL,
0x00000200130b7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011607ULL,
0x000000020a0f8824ULL, 0x000fe200078e0263ULL, 0x0000002007137810ULL, 0x000fe20007ffe0ffULL,
0x000000081e1e8824ULL, 0x000fe200078e0207ULL, 0x000008000b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000020f208824ULL, 0x000fe200078e0208ULL, 0x0000000c0c0c7812ULL, 0x000fe200078ec0ffULL,
0x000020000a087824ULL, 0x000fe200078e0205ULL, 0x000045801e218811ULL, 0x000fe200078e20ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060dULL, 0x00006e0006067a10ULL, 0x000fe20007f3e0ffULL,
0x00000010070d7824ULL, 0x000fe200078e00ffULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000108127824ULL, 0x000fe200078e020bULL, 0x00006e00100b7a10ULL, 0x000fe20007f5e0ffULL,
0x00006f00ff167624ULL, 0x000fe200008e06ffULL, 0x000000700d0d7812ULL, 0x000fe200078ec0ffULL,
0x00000010071f7824ULL, 0x000fe200078e0212ULL, 0x0000000619108211ULL, 0x040fe200078238ffULL,
0x00006f00ff187624ULL, 0x000fe200010e06ffULL, 0x0000000b191a8211ULL, 0x000fe200078438ffULL,
0x000000010d177824ULL, 0x000fe200078e020cULL, 0x0000001619118211ULL, 0x000fe200008f3cffULL,
0x0000001013127825ULL, 0x100fe200078e000eULL, 0x000003000a007a0cULL, 0x000fe20003f26070ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000018191b8211ULL, 0x000fe200010f3cffULL,
0x0000001015147825ULL, 0x100fe200078e000eULL, 0x0000000017177984ULL, 0x000e620000000800ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000000101d1c7825ULL, 0x100fe200078e000eULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x00000010070e7825ULL, 0x000fe200078e000eULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fc4000001ff00ULL, 0x0000000820208824ULL, 0x000fe200078e0207ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000e1f7faeULL, 0x0005e2000b901c46ULL,
0x0000001007108825ULL, 0x000fc600078e0010ULL, 0x0000418020238811ULL, 0x000fe200078e20ffULL,
0x00380000121f7faeULL, 0x0007e2000b901c46ULL, 0x000000ffff197224ULL, 0x000fc600078e00ffULL,
0x00580000141f7faeULL, 0x0007e2000b901c46ULL, 0x00000010070e8825ULL, 0x004fc600078e001aULL,
0x007800001c1f7faeULL, 0x0005e2000b901c46ULL, 0x00000000001a7805ULL, 0x000fc6000001ff00ULL,
0x0000000010218faeULL, 0x0009e8000b901c46ULL, 0x000000000e238faeULL, 0x0003e8000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000001c7805ULL, 0x004fe2000001ff00ULL,
0x00000000001e7805ULL, 0x008fe2000001ff00ULL, 0x0000000000207805ULL, 0x010fe2000001ff00ULL,
0x0000000000227805ULL, 0x002fe2000001ff00ULL, 0x00000c6000001947ULL, 0x000fea0003800000ULL,
0x000000ffff197224ULL, 0x000fe400078e00ffULL, 0x000000ffff3b7224ULL, 0x000fca00078e000aULL,
0x000000023b3a7810ULL, 0x000fc80007ffe0ffULL, 0x000003003a007a0cULL, 0x000fda0003f06070ULL,
0x0000029000000947ULL, 0x000fea0003800000ULL, 0x0000000109157824ULL, 0x100fe200078e023aULL,
0x000000070700780cULL, 0x000fe40003f44070ULL, 0x00000001ff0e7819ULL, 0x000fe2000001163aULL,
0x00001000150c7825ULL, 0x000fe200078e0002ULL, 0x0000004007417810ULL, 0x040fe40007ffe0ffULL,
0x000000010e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000040c127210ULL, 0x000fe20007f1e0ffULL,
0x000004003a0c7824ULL, 0x000fe200078e00ffULL, 0x0000006007437810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200000e060dULL, 0x000008000c0d7812ULL, 0x000fe200078ec0ffULL,
0x000000020a0fa824ULL, 0x140fe200078e0263ULL, 0x000000061510a211ULL, 0x040fe200078038ffULL,
0x000000020a11a824ULL, 0x000fe200078e0263ULL, 0x0000000b1514a211ULL, 0x000fe200078238ffULL,
0x000000020f3ea824ULL, 0x100fe200078e020eULL, 0x00000020070f7810ULL, 0x000fe20007ffe0ffULL,
0x000000021140a824ULL, 0x000fe200078e020eULL, 0x000000161511a211ULL, 0x040fe200000f3cffULL,
0x00000001080c7824ULL, 0x000fe200078e020dULL, 0x000000181515a211ULL, 0x000fe200008f3cffULL,
0x000000083e3ea824ULL, 0x000fc400078e0207ULL, 0x00000010073f7824ULL, 0x040fe400078e020cULL,
0x00000010073c7825ULL, 0x000fc800078e0012ULL, 0x000000084040a824ULL, 0x000fe200078e0207ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800003c3f7faeULL, 0x0003e2000b901c46ULL,
0x000000100f0c7825ULL, 0x000fc800078e0012ULL, 0x00000010410e7825ULL, 0x100fe200078e0012ULL,
0x000045803e41a811ULL, 0x000fe200078e20ffULL, 0x003800000c3f7faeULL, 0x0003e4000b901c46ULL,
0x0000001043127825ULL, 0x000fe200078e0012ULL, 0x000041804043a811ULL, 0x000fe200078e20ffULL,
0x005800000e3f7faeULL, 0x0003e4000b901c46ULL, 0x000000100710a825ULL, 0x040fe400078e0010ULL,
0x00780000123f7faeULL, 0x0003e4000b901c46ULL, 0x000000100714a825ULL, 0x000fc400078e0014ULL,
0x000000001041afaeULL, 0x0003e8000b901c46ULL, 0x000000001443afaeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000403b0c7824ULL, 0x002fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011607ULL, 0x000000020a0f7824ULL, 0x000fe200078e0263ULL,
0x00000002ff3f7819ULL, 0x000fe20000011607ULL, 0x00000010070d7824ULL, 0x000fe200078e00ffULL,
0x000000800c0c7812ULL, 0x000fc400078ec0ffULL, 0x000000083f497810ULL, 0x040fe20007ffe0ffULL,
0x000000083f137824ULL, 0x000fe200078e00ffULL, 0x000000700d0d7812ULL, 0x000fe200078ec0ffULL,
0x000001000f0e7824ULL, 0x000fe200078e000cULL, 0x0000000c100c7812ULL, 0x000fe200078ec0ffULL,
0x000000083f147824ULL, 0x040fe200078e00ffULL, 0x000000023f0f7810ULL, 0x040fe20007ffe0ffULL,
0x000000083f447824ULL, 0x040fe200078e00ffULL, 0x0000000e0c107210ULL, 0x000fe20007ffe00dULL,
0x000000083f427824ULL, 0x040fe200078e00ffULL, 0x000000013f0e7810ULL, 0x040fe20007ffe0ffULL,
0x000000083f437824ULL, 0x000fe200078e00ffULL, 0xfffffff814117812ULL, 0x000fc400078ee23fULL,
0xfffffff813137812ULL, 0x000fe200078ee20eULL, 0x000004003b0e7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800010127984ULL, 0x000e620000000800ULL,
0xfffffff8143b7812ULL, 0x000fe200078ee20fULL, 0x0000000849147824ULL, 0x000fe200078e00ffULL,
0x000008000e0f7812ULL, 0x000fe200078ec0ffULL, 0x00458000103c7984ULL, 0x0004e20000000800ULL,
0x00000004070e7824ULL, 0x000fe200078e00ffULL, 0x000000033f3d7810ULL, 0x040fe40007ffe0ffULL,
0x000000043f3e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c0e467812ULL, 0x000fc400078ec0ffULL,
0x0000018008107810ULL, 0x004fe40007ffe00fULL, 0xfffffff8140f7812ULL, 0x000fe400078ee249ULL,
0xfffffff8423d7812ULL, 0x000fe200078ee23dULL, 0x00000010110e7824ULL, 0x000fe200078e0210ULL,
0xfffffff843437812ULL, 0x000fe200078ee23eULL, 0x000000100f0f7824ULL, 0x000fe200078e0210ULL,
0xffffffff3f3e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001460e7824ULL, 0x040fe400078e020eULL,
0x0000000146147824ULL, 0x000fc400078e020fULL, 0x00000010130f7824ULL, 0x100fe200078e0210ULL,
0x000000000e117984ULL, 0x000ea20000000800ULL, 0x000000053f137810ULL, 0x000fe40007ffe0ffULL,
0x00000001460f7824ULL, 0x000fe200078e020fULL, 0x0000000014407984ULL, 0x000f220000000800ULL,
0xfffffff844457812ULL, 0x000fe200078ee213ULL, 0x000000103b137824ULL, 0x000fe200078e0210ULL,
0x000000063f3b7810ULL, 0x000fe20007ffe0ffULL, 0x000400000f417984ULL, 0x000fe40000000800ULL,
0x0000000146137824ULL, 0x000fe200078e0213ULL, 0x0000001217127221ULL, 0x002fc80000010100ULL,
0x0000000013147984ULL, 0x000fe20000000800ULL, 0x3fb8aa3b12127820ULL, 0x000fc60000410000ULL,
0x0004000013427984ULL, 0x0005e20000000800ULL, 0x0000001200157308ULL, 0x0002e60000000800ULL,
0x000000000f127984ULL, 0x002fe20000000800ULL, 0x0000003c15447220ULL, 0x008fe20000410000ULL,
0x000000083f3c7824ULL, 0x000fe400078e00ffULL, 0x000000103d157824ULL, 0x100fe200078e0210ULL,
0x0000003944397221ULL, 0x000fe20000010000ULL, 0x000000083f3d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c477812ULL, 0x000fe200078ee23bULL, 0x00000010433c7824ULL, 0x000fe200078e0210ULL,
0x00001f49440f7589ULL, 0x000e6200000e0000ULL, 0x0000000146157824ULL, 0x040fe200078e0215ULL,
0xfffffff83d437812ULL, 0x000fe200078ee23eULL, 0x00000001463c7824ULL, 0x000fe200078e023cULL,
0x00001f3f440e7589ULL, 0x00066200000e0000ULL, 0x00000010453d7824ULL, 0x000fc400078e0210ULL,
0x00000010473e7824ULL, 0x000fe200078e0210ULL, 0x00000000153b7984ULL, 0x000e620000000800ULL,
0x00000001463d7824ULL, 0x040fe400078e023dULL, 0x00000001463e7824ULL, 0x000fe200078e023eULL,
0x000400003c447984ULL, 0x000fe20000000800ULL, 0x30000011ff137230ULL, 0x004fe40000004100ULL,
0x00000010433f7824ULL, 0x008fe400078e0210ULL, 0x000000003c107984ULL, 0x000ea20000000800ULL,
0x30000040ff457230ULL, 0x010fc40000004100ULL, 0x00000001463f7824ULL, 0x000fe200078e023fULL,
0x0004000015437984ULL, 0x000ee20000000800ULL, 0x20000011ff467230ULL, 0x000fe40000004100ULL,
0x20000040ff487230ULL, 0x000fe20000004100ULL, 0x000000003d117984ULL, 0x000f220000000800ULL,
0x0000000f45347223ULL, 0x082fe20000010034ULL, 0x20000012ff407230ULL, 0x100fe20000004100ULL,
0x0000000e13367223ULL, 0x080fe20000010036ULL, 0x000400003d157984ULL, 0x000e620000000800ULL,
0x30000012ff457230ULL, 0x000fe20000004100ULL, 0x0000000e46377223ULL, 0x080fe20000010037ULL,
0x20000041ff127230ULL, 0x100fe20000004100ULL, 0x000000003e137984ULL, 0x000e620000000800ULL,
0x30000041ff417230ULL, 0x000fe20000004100ULL, 0x0000000e45327223ULL, 0x080fe20000010032ULL,
0x20000042ff457230ULL, 0x000fe20000004100ULL, 0x000400003e3c7984ULL, 0x000e620000000800ULL,
0x0000000f12317223ULL, 0x080fe20000010031ULL, 0x0000000f41307223ULL, 0x080fe20000010030ULL,
0x20000014ff417230ULL, 0x100fe20000004100ULL, 0x000000003f127984ULL, 0x000e620000000800ULL,
0x30000014ff147230ULL, 0x000fe20000004100ULL, 0x0000000f48357223ULL, 0x080fe20000010035ULL,
0x30000042ff427230ULL, 0x000fe20000004100ULL, 0x000400003f3d7984ULL, 0x0006620000000800ULL,
0x0000000e412c7223ULL, 0x080fe2000001002cULL, 0x0000000e142b7223ULL, 0x080fe2000001002bULL,
0x2000003bff417230ULL, 0x100fe20000004100ULL, 0x0000000e40337223ULL, 0x080fe20000010033ULL,
0x3000003bff147230ULL, 0x000fe20000004100ULL, 0x0000000f452a7223ULL, 0x080fe2000001002aULL,
0x0000000f42297223ULL, 0x000fe20000010029ULL, 0x0000000e41287223ULL, 0x000fc40000010028ULL,
0x0000000e14277223ULL, 0x080fe20000010027ULL, 0x20000010ff3b7230ULL, 0x104fe40000004100ULL,
0x30000010ff107230ULL, 0x000fe40000004100ULL, 0x20000043ff3f7230ULL, 0x108fe20000004100ULL,
0x0000000e3b247223ULL, 0x080fe20000010024ULL, 0x30000043ff3e7230ULL, 0x000fe20000004100ULL,
0x0000000e10237223ULL, 0x080fe20000010023ULL, 0x20000011ff3b7230ULL, 0x110fe20000004100ULL,
0x0000000f3f267223ULL, 0x080fe20000010026ULL, 0x30000011ff107230ULL, 0x000fe20000004100ULL,
0x0000000f3e257223ULL, 0x080fe20000010025ULL, 0x20000015ff117230ULL, 0x002fe20000004100ULL,
0x0000000e3b207223ULL, 0x080fe20000010020ULL, 0x000000ffff3b7224ULL, 0x000fe200078e003aULL,
0x0000000e101f7223ULL, 0x080fe2000001001fULL, 0x30000013ff107230ULL, 0x100fe20000004100ULL,
0x0000000f111e7223ULL, 0x080fe2000001001eULL, 0x20000013ff117230ULL, 0x000fe20000004100ULL,
0x000003003b007a0cULL, 0x000fe20003f06070ULL, 0x30000015ff147230ULL, 0x000fe20000004100ULL,
0x0000000e101b7223ULL, 0x080fe2000001001bULL, 0x2000003cff137230ULL, 0x000fe20000004100ULL,
0x0000000e111c7223ULL, 0x080fe2000001001cULL, 0x20000044ff3f7230ULL, 0x000fe20000004100ULL,
0x0000000f141d7223ULL, 0x080fe2000001001dULL, 0x20000012ff107230ULL, 0x100fe20000004100ULL,
0x0000000f131a7223ULL, 0x080fe2000001001aULL, 0x30000012ff117230ULL, 0x000fe20000004100ULL,
0x0000000f3f227223ULL, 0x080fe20000010022ULL, 0x30000044ff447230ULL, 0x000fe20000004100ULL,
0x0000000e102f7223ULL, 0x080fe2000001002fULL, 0x3000003cff137230ULL, 0x000fe20000004100ULL,
0x0000000e112e7223ULL, 0x000fe2000001002eULL, 0x2000003dff127230ULL, 0x100fe20000004100ULL,
0x0000000f44217223ULL, 0x080fe20000010021ULL, 0x3000003dff147230ULL, 0x000fe20000004100ULL,
0x0000000f13387223ULL, 0x000fc40000010038ULL, 0x0000000f122d7223ULL, 0x080fe4000001002dULL,
0x0000000f14197223ULL, 0x000fe20000010019ULL, 0xfffff3c000008947ULL, 0x000fea000383ffffULL,
0x000000ff6300720cULL, 0x000fe20003f05270ULL, 0x0000018000007945ULL, 0x000fd80003800000ULL,
0x000000800a038824ULL, 0x000fc800078e020dULL, 0x000000010c028824ULL, 0x000fe400078e0203ULL,
0x000000010d0c7824ULL, 0x000fc600078e020cULL, 0x0049803902008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x004980000c037984ULL, 0x000e680000000800ULL,
0x004a00000c047984ULL, 0x000ea20000000800ULL, 0x00000003ff037221ULL, 0x002fc80000010000ULL,
0x0000000403037221ULL, 0x004fca0000010000ULL, 0x0180000003047810ULL, 0x000fc80007ffe0ffULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0003ULL, 0x0000aeb000067802ULL, 0x000fc40000000f00ULL,
0x00008e5000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff027224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000300027308ULL, 0x000e640000001000ULL,
0xbf80000003047423ULL, 0x002fc80000000002ULL, 0x800000ff04077221ULL, 0x000fc80000010100ULL,
0x0000000702027223ULL, 0x000fc40000000002ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff097819ULL, 0x104fe20000011607ULL, 0x000000016a6a7824ULL, 0x000fe200078e0207ULL,
0x00000008070b7811ULL, 0x002fc400078ff0ffULL, 0x00000004090c7810ULL, 0x040fe20007ffe0ffULL,
0x00001f0902037589ULL, 0x000e6200000e0000ULL, 0x0000000809157824ULL, 0x040fe200078e00ffULL,
0x0000000209067810ULL, 0x040fe20007ffe0ffULL, 0x00000008090f7824ULL, 0x040fe200078e00ffULL,
0x00001f0b02047589ULL, 0x0004e200000e0000ULL, 0x0000000809117824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee20cULL, 0x0000000809137824ULL, 0x040fe200078e00ffULL,
0x0000000309087810ULL, 0x040fe20007ffe0ffULL, 0x00000008090c7824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee206ULL, 0x0000000809177824ULL, 0x000fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee208ULL, 0x0000000809397824ULL, 0x040fe200078e00ffULL,
0x0000000109027810ULL, 0x004fe20007ffe0ffULL, 0x0000001011117824ULL, 0x100fe200078e0200ULL,
0x0000000609067810ULL, 0x000fe20007ffe0ffULL, 0x0000001013137824ULL, 0x000fe200078e0200ULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee202ULL, 0x0000001015157824ULL, 0x100fe200078e0200ULL,
0x0000000509027810ULL, 0x040fe20007ffe0ffULL, 0x000000106a6a7824ULL, 0x000fe200078e0205ULL,
0xffffffff09087810ULL, 0x000fe20007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe200078e0200ULL,
0x0000003703377220ULL, 0x042fe20000410000ULL, 0x0000003603367220ULL, 0x040fe20000410000ULL,
0x0000003303337220ULL, 0x040fe20000410000ULL, 0x0000003203327220ULL, 0x040fe20000410000ULL,
0x0000002c032c7220ULL, 0x040fe20000410000ULL, 0x0000002b032b7220ULL, 0x040fe20000410000ULL,
0x0000002803287220ULL, 0x040fe20000410000ULL, 0x0000002703277220ULL, 0x040fe20000410000ULL,
0x0000002403247220ULL, 0x040fe20000410000ULL, 0x0000002303237220ULL, 0x040fe20000410000ULL,
0x0000002003207220ULL, 0x040fe20000410000ULL, 0x0000001f031f7220ULL, 0x040fe20000410000ULL,
0x0000001c031c7220ULL, 0x040fe20000410000ULL, 0x0000001b031b7220ULL, 0x040fe20000410000ULL,
0x0000002f032f7220ULL, 0x040fe20000410000ULL, 0x0000002e032e7220ULL, 0x000fe20000410000ULL,
0x0000003504357220ULL, 0x048fe20000410000ULL, 0x0000003404347220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x040fe20000410000ULL, 0x0000003804037220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000001904047220ULL, 0x000fe20000410000ULL,
0x0000000809197824ULL, 0x000fe200078e00ffULL, 0xfffffff80c0d7812ULL, 0x000fe200078ee209ULL,
0x000000080b0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff817097812ULL, 0x000fe200078ee202ULL,
0x0000000407027824ULL, 0x000fe200078e00ffULL, 0xfffffff819177812ULL, 0x000fe200078ee206ULL,
0x000000100d0d7824ULL, 0x000fe200078e0200ULL, 0xfffffff839197812ULL, 0x000fc400078ee208ULL,
0x0000000c02027812ULL, 0x000fe200078ec0ffULL, 0x0000001017177824ULL, 0x100fe200078e0200ULL,
0xfffffff80c397812ULL, 0x000fe200078ee20bULL, 0x00000010090b7824ULL, 0x000fe200078e0200ULL,
0x000000373636723eULL, 0x000fe200000000ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0202ULL,
0x000000333232723eULL, 0x000fe200000000ffULL, 0x0000001019197824ULL, 0x100fe200078e0200ULL,
0x0000002c2b2b723eULL, 0x000fe200000000ffULL, 0x0000001039397824ULL, 0x000fe200078e0200ULL,
0x000000282727723eULL, 0x000fe200000000ffULL, 0x0000000102097824ULL, 0x040fe200078e020fULL,
0x000000242323723eULL, 0x000fe200000000ffULL, 0x0000000102007824ULL, 0x040fe200078e0211ULL,
0x0000001c1b1b723eULL, 0x000fe200000000ffULL, 0x0000000102067824ULL, 0x040fe200078e0213ULL,
0x000000201f1f723eULL, 0x000fe200000000ffULL, 0x0000000102087824ULL, 0x040fe200078e0215ULL,
0x0000001e1d1d723eULL, 0x000fe200000000ffULL, 0x00000001021c7824ULL, 0x040fe200078e020bULL,
0x000000360d007388ULL, 0x000fe20000000800ULL, 0x00000001021e7824ULL, 0x000fe200078e0217ULL,
0x0000002f2e2e723eULL, 0x000fe200000000ffULL, 0x00000001020b7824ULL, 0x000fe200078e0219ULL,
0x0000003209007388ULL, 0x000fe20000000800ULL, 0x000000353434723eULL, 0x000fe200000000ffULL,
0x0000000102397824ULL, 0x000fe200078e0239ULL, 0x000000313030723eULL, 0x000fe200000000ffULL,
0x0000002b00007388ULL, 0x000fe20000000800ULL, 0x0000002a2929723eULL, 0x000fc400000000ffULL,
0x000000262525723eULL, 0x000fe200000000ffULL, 0x0000002706007388ULL, 0x000fe20000000800ULL,
0x000000222121723eULL, 0x000fe400000000ffULL, 0x0000001a0303723eULL, 0x000fe200000000ffULL,
0x0000002308007388ULL, 0x000fe20000000800ULL, 0x0000002d0404723eULL, 0x000fc600000000ffULL,
0x0000001f1c007388ULL, 0x000fe80000000800ULL, 0x0000001b1e007388ULL, 0x000fe80000000800ULL,
0x0000002e0b007388ULL, 0x000fe80000000800ULL, 0x0000003439007388ULL, 0x000fe80000000800ULL,
0x0004003009007388ULL, 0x000fe80000000800ULL, 0x0004002900007388ULL, 0x000fe80000000800ULL,
0x0004002506007388ULL, 0x000fe80000000800ULL, 0x0004002108007388ULL, 0x000fe80000000800ULL,
0x0004001d1c007388ULL, 0x000fe80000000800ULL, 0x000400031e007388ULL, 0x000fe80000000800ULL,
0x000400040b007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000006a0c7984ULL, 0x000e680000000c00ULL, 0x000400006a147984ULL, 0x000ea80000000c00ULL,
0x000800006a107984ULL, 0x000ee80000000c00ULL, 0x000c00006a187984ULL, 0x000f220000000c00ULL,
0x200000ff0f0f7230ULL, 0x002fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff17177230ULL, 0x004fe40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fc40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x000000130f0f7230ULL, 0x008fe40000000000ULL, 0x000000120e0e7230ULL, 0x000fe40000000000ULL,
0x000000110d0d7230ULL, 0x000fe40000000000ULL, 0x000000100c0c7230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x010fc40000000000ULL, 0x0000001a16167230ULL, 0x000fe20000000000ULL,
0x0000000c6a007388ULL, 0x000fe20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fca0000000000ULL, 0x000400146a007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fc80000011607ULL,
0x0000006e0900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000047b06ULL, 0x000e620000209000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00005a00ff0c7a12ULL, 0x000fe200078e33ffULL, 0x0000000170007824ULL, 0x000fe200078e0209ULL,
0x00000020070e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109097824ULL, 0x000fc600078e0207ULL,
0x00000003ff0f7819ULL, 0x000fe2000001160eULL, 0x0000000400047308ULL, 0x002e640000001000ULL,
0x0ffffffe04067810ULL, 0x002fe40007ffe0ffULL, 0x0000000709047812ULL, 0x000fc800078ec0ffULL,
0x0000000600037305ULL, 0x0002a2000021f000ULL, 0x0ffffff804047812ULL, 0x000fca00078ef807ULL,
0x0000001004047824ULL, 0x000fe200078e0205ULL, 0x0000000707067812ULL, 0x002fe200078ec0ffULL,
0x000000ffff0b7224ULL, 0x004fc800078e0a03ULL, 0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL,
0x0000000b03117227ULL, 0x000fe400078e0002ULL, 0x0000000004087984ULL, 0x000e680000000c00ULL,
0x0000000011027227ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a02ULL,
0x00005a0003037a24ULL, 0x000fca00078e0200ULL, 0x00005a0003007a0cULL, 0x000fda0003f06070ULL,
0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL, 0x0000000102020810ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f26070ULL, 0x00005a00ff007a0cULL, 0x000fd60003f05070ULL,
0x0000000102021810ULL, 0x000fc80007ffe0ffULL, 0x000000020c027207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a02ULL, 0x0000590002037a24ULL, 0x000fe400078e026dULL,
0x00005a000d007a24ULL, 0x000fe400078e0200ULL, 0x00000008630d7824ULL, 0x000fe400078e0206ULL,
0x00005a0003007a24ULL, 0x000fca00078e0200ULL, 0x000000006f007210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fe200008e06ffULL, 0x00005e0000027a11ULL, 0x000fc800078240ffULL,
0x00005f0000037a11ULL, 0x000fe400008f4403ULL, 0x0000006e0f00720cULL, 0x000fc60003f26070ULL,
0x000000100d027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000170007824ULL, 0x100fe200078e020fULL,
0x0000004007107810ULL, 0x000fe20007ffe0ffULL, 0x000000010e0f7824ULL, 0x000fe400078e020fULL,
0x0000000011037227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a03ULL, 0x00005a0009027a24ULL, 0x000fca00078e0200ULL,
0x00005a0002007a0cULL, 0x000fda0003f26070ULL, 0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a0002007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f027812ULL, 0x000fe400078ef80eULL, 0x00000003ff0f7819ULL, 0x000fc60000011610ULL,
0x0000001002047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000103032810ULL, 0x000fc80007ffe0ffULL, 0x000000030c027207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a02ULL, 0x0000590002037a24ULL, 0x000fe400078e026dULL,
0x00005a000d007a24ULL, 0x000fc800078e0200ULL, 0x00005a0003007a24ULL, 0x000fca00078e0200ULL,
0x000000006f037210ULL, 0x000fe40007f3e0ffULL, 0x000000070e007812ULL, 0x000fc600078ec0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00005e0003027a11ULL, 0x000fe200078240ffULL,
0x00000008630d7824ULL, 0x000fc600078e0200ULL, 0x00005f0003037a11ULL, 0x000fe400008f4406ULL,
0x0000006e0f00720cULL, 0x000fc60003f26070ULL, 0x000000100d027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000170007824ULL, 0x100fe200078e020fULL, 0x00000060070e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001100f7824ULL, 0x000fe400078e020fULL, 0x0000000011037227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a03ULL,
0x00005a0009027a24ULL, 0x000fca00078e0200ULL, 0x00005a0002007a0cULL, 0x000fda0003f26070ULL,
0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL, 0x0000000103031810ULL, 0x000fe40007ffe0ffULL,
0x00005a0002007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f027812ULL, 0x000fca00078ef810ULL,
0x0000001002047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000103032810ULL, 0x000fc80007ffe0ffULL, 0x000000030c027207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a02ULL, 0x0000590002037a24ULL, 0x000fe400078e026dULL,
0x00005a000d007a24ULL, 0x000fe200078e0200ULL, 0x00000003ff0d7819ULL, 0x000fc6000001160eULL,
0x00005a0003007a24ULL, 0x000fe400078e0200ULL, 0x0000000170707824ULL, 0x000fc600078e020dULL,
0x000000006f037210ULL, 0x000fe40007f3e0ffULL, 0x0000000710007812ULL, 0x000fc600078ec0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00005e0003027a11ULL, 0x000fe200078240ffULL,
0x0000000863077824ULL, 0x000fc600078e0200ULL, 0x00005f0003037a11ULL, 0x000fe400008f4406ULL,
0x0000006e0d00720cULL, 0x000fc60003f26070ULL, 0x0000001007027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000007011027227ULL, 0x002fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fe400078e0a02ULL,
0x000000010e0d7824ULL, 0x000fe400078e020dULL, 0x00005a0003007a24ULL, 0x000fc600078e0270ULL,
0x000000070d0d7812ULL, 0x000fe400078ec0ffULL, 0x00005a0000007a0cULL, 0x000fda0003f26070ULL,
0x80005a0000001a10ULL, 0x000fe40007ffe0ffULL, 0x0000000102021810ULL, 0x000fe40007ffe0ffULL,
0x00005a0000007a0cULL, 0x000fe40003f46070ULL, 0xfffffff80d007812ULL, 0x000fca00078ef80eULL,
0x0000001000057824ULL, 0x000fe200078e0205ULL, 0x000000070e007812ULL, 0x000fca00078ec0ffULL,
0x0000000102022810ULL, 0x000fe20007ffe0ffULL, 0x0000000005047984ULL, 0x000e620000000c00ULL,
0x0000000863637824ULL, 0x000fe400078e0200ULL, 0x000000020c027207ULL, 0x000fca0004000000ULL,
0x000000ffff037224ULL, 0x000fe400078e0a02ULL, 0x00005900026d7a24ULL, 0x000fe400078e026dULL,
0x00005a0003707a24ULL, 0x000fc800078e0270ULL, 0x00005a006d707a24ULL, 0x000fca00078e0270ULL,
0x000000706f707210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005e0070027a11ULL, 0x000fc800078040ffULL, 0x00005f0070037a11ULL, 0x000fca00000f4403ULL,
0x0000001063027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000207067824ULL, 0x000fe200078e00ffULL, 0x0000000112077810ULL, 0x000fe20007ffe0ffULL,
0x00005800ff087624ULL, 0x002fe200078e00ffULL, 0x01360000ff047f8cULL, 0x000e62000c80043fULL,
0x0000004013737824ULL, 0x000fe200078e00ffULL, 0x000000620700720cULL, 0x000fe20003f06070ULL,
0x00005900066d7a24ULL, 0x000fe200078e026dULL, 0x0000001f08077810ULL, 0x000fe20007ffe0ffULL,
0x00000100120f7824ULL, 0x000fc600078e0273ULL, 0x00000005ff077819ULL, 0x000fe20000011607ULL,
0x000068006d1e7a24ULL, 0x000fcc00078e020fULL, 0x0000060000008947ULL, 0x000fea0003800000ULL,
0x00000002ff277819ULL, 0x000fe40000011600ULL, 0x0000000f60067217ULL, 0x000fe40007800000ULL,
0x0000000827177810ULL, 0x040fe20007ffe0ffULL, 0x000000011e087824ULL, 0x000fe200078e0227ULL,
0x00000018272b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000106067824ULL, 0x000fe200078e0a0fULL,
0x0000001027297810ULL, 0x000fe20007ffe0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000000197211ULL, 0x000fc400078fe8ffULL, 0x0000002827237810ULL, 0x000fe20007ffe0ffULL,
0x000000011e0a7824ULL, 0x000fe200078e0217ULL, 0x0000003008107812ULL, 0x000fe200078ef803ULL,
0x000000011e0e7824ULL, 0x000fe200078e022bULL, 0x0000000319197812ULL, 0x000fe200078ec0ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000640010107a10ULL, 0x000fe40007f1e0ffULL,
0x0000002027217810ULL, 0x000fe20007ffe0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000000300a147812ULL, 0x000fc400078ef803ULL, 0x0000650009117a10ULL, 0x000fe200007fe4ffULL,
0x000000011e0c7824ULL, 0x000fe200078e0229ULL, 0x000000300e0a7812ULL, 0x100fe200078ef803ULL,
0x00000004170e7824ULL, 0x000fe200078e00ffULL, 0x0000640014147a10ULL, 0x000fe20007f1e0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x000064000a0a7a10ULL, 0x000fe40007f5e0ffULL,
0x000065000b157a10ULL, 0x000fe200007fe4ffULL, 0x0000000423187824ULL, 0x000fe200078e00ffULL,
0x000000300c087812ULL, 0x000fe200078ef803ULL, 0x000000011e0c7824ULL, 0x000fe200078e0221ULL,
0x00001000131b7811ULL, 0x000fc400078e68ffULL, 0xfffffffc0e0e7812ULL, 0x000fe400078ee219ULL,
0x000065000f0b7a10ULL, 0x000fe200017fe4ffULL, 0x000000011e0f7824ULL, 0x000fe200078e0223ULL,
0x0000640008087a10ULL, 0x000fe20007f3e0ffULL, 0x000000100e1f7824ULL, 0x000fe200078e021bULL,
0x000000062700720cULL, 0x080fe20003f06070ULL, 0x000001000f0e7825ULL, 0x000fe200078e00ffULL,
0x000065000d097a10ULL, 0x000fe40000ffe4ffULL, 0x000000061700720cULL, 0x000fe20003f26070ULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0ffffffc19007812ULL, 0x000fc400078ef800ULL,
0x0000003027257810ULL, 0x000fe40007ffe0ffULL, 0x000000300e167812ULL, 0x000fe200078ef803ULL,
0x00000010001d7824ULL, 0x000fe200078e021bULL, 0x000000300c0c7812ULL, 0x000fe200078ef803ULL,
0x000000011e0e7824ULL, 0x000fe200078e0225ULL, 0x0000640016167a10ULL, 0x000fe20007fde0ffULL,
0x0000000429007824ULL, 0x000fe200078e00ffULL, 0x0000003827277810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101d7faeULL, 0x0005e2000c101c46ULL,
0x000064000c0c7a10ULL, 0x000fe20007f5e0ffULL, 0x00000004251a7824ULL, 0x000fe200078e00ffULL,
0x000065000f177a10ULL, 0x000fe200037fe4ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000065000d0d7a10ULL, 0x000fe200017fe4ffULL, 0x00000000141f7faeULL, 0x0007e2000c901c46ULL,
0x000000062900720cULL, 0x080fe20003fa6070ULL, 0x00000004271c7824ULL, 0x000fe200078e00ffULL,
0x000000062b00720cULL, 0x000fc40003f86070ULL, 0x000000062100720cULL, 0x080fe20003f66070ULL,
0x000000011e107824ULL, 0x004fe200078e0227ULL, 0x000000062300720cULL, 0x080fe40003f46070ULL,
0x000000062500720cULL, 0x080fe20003f26070ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000062700720cULL, 0x000fe40003f06070ULL, 0x000000300e0e7812ULL, 0x000fe200078ef803ULL,
0x000000042b067824ULL, 0x000fe200078e00ffULL, 0xfffffffc00007812ULL, 0x000fe200078ee219ULL,
0x0000000421147824ULL, 0x008fe200078e00ffULL, 0x000064000e0e7a10ULL, 0x000fc40007fde0ffULL,
0xfffffffc06067812ULL, 0x100fe400078ee219ULL, 0xfffffffc14147812ULL, 0x000fe400078ee219ULL,
0x0000003010107812ULL, 0x000fe200078ef803ULL, 0x0000001000037824ULL, 0x000fe200078e021bULL,
0xfffffffc18187812ULL, 0x000fe200078ee219ULL, 0x0000001006157824ULL, 0x000fe200078e021bULL,
0xfffffffc1a1a7812ULL, 0x100fe400078ee219ULL, 0xfffffffc1c1c7812ULL, 0x000fe200078ee219ULL,
0x0000001014197824ULL, 0x100fe200078e021bULL, 0x000065000f0f7a10ULL, 0x000fe200037fe4ffULL,
0x00000010181d7824ULL, 0x100fe200078e021bULL, 0x0000640010107a10ULL, 0x000fe20007fde0ffULL,
0x000000101a1f7824ULL, 0x100fe200078e021bULL, 0x0000000008037faeULL, 0x0005e2000e901c46ULL,
0x000000101c1b7824ULL, 0x000fe200078e021bULL, 0x0000650011117a10ULL, 0x000fc400037fe4ffULL,
0x000000000a157faeULL, 0x0005e8000e101c46ULL, 0x000000000c197faeULL, 0x0005e8000d901c46ULL,
0x00000000161d7faeULL, 0x0005e8000d101c46ULL, 0x000000000e1f7faeULL, 0x0005e8000c901c46ULL,
0x00000000101b7faeULL, 0x0005e2000c101c46ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000001800097811ULL, 0x040fe400078ff0ffULL, 0x00000028000d7811ULL, 0x000fc400078ff0ffULL,
0x00000000000a7211ULL, 0x040fe200078fe8ffULL, 0x0000000409167824ULL, 0x000fe200078e00ffULL,
0x0000000800117811ULL, 0x040fe200078ff0ffULL, 0x000000040d207824ULL, 0x000fe200078e00ffULL,
0x0000001000067811ULL, 0x000fe200078ff0ffULL, 0x000000011e0e7824ULL, 0x000fe200078e0209ULL,
0x00000020000b7811ULL, 0x040fe200078ff0ffULL, 0x0000000411147824ULL, 0x000fe200078e00ffULL,
0x00000030000f7811ULL, 0x000fe200078ff0ffULL, 0x000000011e0c7824ULL, 0x000fe200078e0206ULL,
0x0000003800107811ULL, 0x000fe200078ff0ffULL, 0x000000011e1a7824ULL, 0x000fe200078e020dULL,
0x0000001e00087211ULL, 0x000fe200078ff0ffULL, 0x000000011e1c7824ULL, 0x000fe200078e020fULL,
0x000000030a197812ULL, 0x000fe200078ec0ffULL, 0x000000011e0a7824ULL, 0x040fe200078e0211ULL,
0x0000100013277811ULL, 0x000fe200078e68ffULL, 0x000000011e117824ULL, 0x040fe200078e020bULL,
0x0ffffffc191b7812ULL, 0x000fe200078ef800ULL, 0x000000011e1e7824ULL, 0x000fe200078e0210ULL,
0xfffffffc14007812ULL, 0x100fe200078ee219ULL, 0x0000000410247824ULL, 0x000fe200078e00ffULL,
0xfffffffc16107812ULL, 0x100fe200078ee219ULL, 0x0000000406067824ULL, 0x000fe200078e00ffULL,
0xfffffffc20167812ULL, 0x000fe200078ee219ULL, 0x000000040b187824ULL, 0x000fc400078e00ffULL,
0x000000040f227824ULL, 0x000fe200078e00ffULL, 0xfffffffc06067812ULL, 0x100fe200078ee219ULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0xfffffffc18157812ULL, 0x100fe400078ee219ULL,
0xfffffffc22177812ULL, 0x100fe200078ee219ULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffffc24187812ULL, 0x000fe400078ee219ULL, 0x0000003008147812ULL, 0x000fe200078ef803ULL,
0x000001000c0c7825ULL, 0x000fc600078e00ffULL, 0x0000640014147a10ULL, 0x000fe20007f1e0ffULL,
0x0000001016237824ULL, 0x000fe200078e0227ULL, 0x000000300a167812ULL, 0x000fe200078ef803ULL,
0x000000101b297824ULL, 0x000fe200078e0227ULL, 0x000000300c197812ULL, 0x000fe200078ef803ULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000640016167a10ULL, 0x000fc60007f3e0ffULL,
0x00000010001b7824ULL, 0x000fe200078e0227ULL, 0x000000300e0e7812ULL, 0x000fe200078ef803ULL,
0x00000010061d7824ULL, 0x100fe400078e0227ULL, 0x00000010101f7824ULL, 0x100fe400078e0227ULL,
0x0000001015217824ULL, 0x100fe200078e0227ULL, 0x0000650009157a10ULL, 0x000fe200007fe4ffULL,
0x0000001017257824ULL, 0x100fe200078e0227ULL, 0x000065000b177a10ULL, 0x000fe20000ffe4ffULL,
0x0000001018277824ULL, 0x000fe200078e0227ULL, 0x0000640019187a10ULL, 0x000fe20007f5e0ffULL,
0x0000010011087825ULL, 0x000fe200078e00ffULL, 0x000064000e0e7a10ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014297faeULL, 0x0005e2000b901c46ULL,
0x000065000d197a10ULL, 0x000fe200017fe4ffULL, 0x000001001a0a7825ULL, 0x000fe200078e00ffULL,
0x0000003008087812ULL, 0x100fe200078ef803ULL, 0x00000000161b7faeULL, 0x0005e2000b901c46ULL,
0x000065000f0f7a10ULL, 0x000fe200007fe4ffULL, 0x000001001c0c7825ULL, 0x000fe200078e00ffULL,
0x000000300a0a7812ULL, 0x100fe200078ef803ULL, 0x00000000181d7faeULL, 0x0005e2000b901c46ULL,
0x0000640008087a10ULL, 0x000fe20007f1e0ffULL, 0x000001001e107825ULL, 0x000fe200078e00ffULL,
0x000000300c0c7812ULL, 0x000fe200078ef803ULL, 0x000000000e1f7faeULL, 0x0005e2000b901c46ULL,
0x000064000a0a7a10ULL, 0x000fc40007f3e0ffULL, 0x0000003010037812ULL, 0x000fe400078ef803ULL,
0x000064000c0c7a10ULL, 0x000fe40007f5e0ffULL, 0x0000640003107a10ULL, 0x000fe40007f7e0ffULL,
0x0000650009097a10ULL, 0x000fe400007fe4ffULL, 0x000065000b0b7a10ULL, 0x000fe40000ffe4ffULL,
0x000065000d0d7a10ULL, 0x000fe200017fe4ffULL, 0x0000000008217faeULL, 0x0005e2000b901c46ULL,
0x0000650011117a10ULL, 0x000fc60001ffe4ffULL, 0x000000000a237faeULL, 0x0005e8000b901c46ULL,
0x000000000c257faeULL, 0x0005e8000b901c46ULL, 0x0000000010277faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000087805ULL, 0x004fc40000015200ULL,
0x01360400ff037984ULL, 0x000ea20000000800ULL, 0x00000007024d7224ULL, 0x000fe400078e02ffULL,
0x00000001606f7824ULL, 0x000fc400078e0a4eULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x8000000003ff7812ULL, 0x006fe20007804805ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000062004d4c7625ULL, 0x000fe200078e004cULL,
0x00000008ff6f7819ULL, 0x000fe2000001166fULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000027805ULL, 0x000fcc0000015200ULL, 0x00000002080b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000103037824ULL, 0x000fe200000e0e09ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011403ULL,
0x0000000b00007211ULL, 0x000fca00078110ffULL, 0x000000ffff037224ULL, 0x000fca00000e0603ULL,
0x0000000200007819ULL, 0x000fc80000001203ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01360400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000621200720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000006c7919ULL, 0x000e620000000000ULL, 0x00000002076e7824ULL, 0x000fe200078e00ffULL,
0x0001368813717811ULL, 0x040fe200078e18ffULL, 0x0000002013727824ULL, 0x000fe200078e00ffULL,
0xffffffff4e117810ULL, 0x040fe40007ffe0ffULL, 0x000000094e107810ULL, 0x000fc40007ffe0ffULL,
0x0000000112037810ULL, 0x040fe20007ffe0ffULL, 0x00000100120f7824ULL, 0x000fe200078e0273ULL,
0x0000000000007946ULL, 0x000fe40003800000ULL, 0x000000620300720cULL, 0x000fe20003f06070ULL,
0x000068006d0e7a24ULL, 0x000fd800078e020fULL, 0x0000064000008947ULL, 0x00cfea0003800000ULL,
0x00000002ff217819ULL, 0x002fe2000001166cULL, 0x000000106c0d7824ULL, 0x000fe200078e00ffULL,
0x0000000f60007217ULL, 0x000fe40007800000ULL, 0x00000010211f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000121027824ULL, 0x140fe200078e020eULL, 0x00000008211d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a0fULL, 0x000000300d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000011f067824ULL, 0x000fe200078e020eULL, 0x0000001821257810ULL, 0x000fe20007ffe0ffULL,
0x0000010002027825ULL, 0x000fe200078e00ffULL, 0x000000400d1b7812ULL, 0x000fc400078efcffULL,
0x0000002021277810ULL, 0x000fe20007ffe0ffULL, 0x000000011d047824ULL, 0x100fe200078e020eULL,
0x0000001b02147212ULL, 0x080fe200078efcffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000002821297810ULL, 0x000fe40007ffe0ffULL, 0x0000640014147a10ULL, 0x000fe20007f3e0ffULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x0000001b06187212ULL, 0x080fe400078efcffULL,
0x0000006c6c067211ULL, 0x000fe200078fe8ffULL, 0x0000000125087824ULL, 0x100fe200078e020eULL,
0x0000001b04167212ULL, 0x000fe200078efcffULL, 0x00000001270a7824ULL, 0x000fe200078e020eULL,
0x0000640018187a10ULL, 0x000fe20007f5e0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000306237812ULL, 0x000fc400078ec0ffULL, 0x0000650003157a10ULL, 0x000fe20000ffe4ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000640016167a10ULL, 0x000fe40007f3e0ffULL,
0x0000001b08027212ULL, 0x080fe200078efcffULL, 0x000000041d067824ULL, 0x000fe200078e00ffULL,
0x0000650007197a10ULL, 0x000fe200017fe4ffULL, 0x000000041f087824ULL, 0x000fe200078e00ffULL,
0x0000001b0a047212ULL, 0x000fe400078efcffULL, 0x000000001d00720cULL, 0x000fc40003f46070ULL,
0x0000650005177a10ULL, 0x000fe40000ffe4ffULL, 0xfffffffc061d7812ULL, 0x000fe200078ee223ULL,
0x0000000129067824ULL, 0x000fe200078e020eULL, 0x0000640002027a10ULL, 0x000fe40007f3e0ffULL,
0x0000640004047a10ULL, 0x000fe20007f7e0ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000650009037a10ULL, 0x000fe40000ffe4ffULL, 0x0ffffffc6c0c7812ULL, 0x000fc400078ec0ffULL,
0x000000002100720cULL, 0x080fe40003f26070ULL, 0x000065000b057a10ULL, 0x000fe40001ffe4ffULL,
0x000000001f00720cULL, 0x000fe40003f66070ULL, 0x00002000131a7811ULL, 0x000fe400078e68ffULL,
0x0000000c23097212ULL, 0x000fe400078efcffULL, 0x00000030212b7810ULL, 0x000fe20007ffe0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e021aULL, 0x0000001b060a7212ULL, 0x000fe200078efcffULL,
0x0000001009097824ULL, 0x000fe200078e021aULL, 0xfffffffc081f7812ULL, 0x000fe200078ee223ULL,
0x000000012b067824ULL, 0x000fe200078e020eULL, 0x000064000a0a7a10ULL, 0x000fc40007fde0ffULL,
0x0000003821217810ULL, 0x000fe20007ffe0ffULL, 0x000000101f1f7824ULL, 0x000fe200078e021aULL,
0x00006500070b7a10ULL, 0x000fe200037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014097faeULL, 0x0003e2000c901c46ULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x000000002500720cULL, 0x080fe40003fa6070ULL, 0x00000000161d7faeULL, 0x0005e2000d101c46ULL,
0x0000000121087824ULL, 0x000fe200078e020eULL, 0x000000002700720cULL, 0x080fe20003f86070ULL,
0x00000004211c7824ULL, 0x000fe200078e00ffULL, 0x00000000181f7faeULL, 0x0007e2000d901c46ULL,
0x000000002900720cULL, 0x000fc40003f66070ULL, 0x000000002b00720cULL, 0x080fe20003f46070ULL,
0x0000000427147824ULL, 0x002fe200078e00ffULL, 0x000000002100720cULL, 0x000fe20003f26070ULL,
0x0000000425007824ULL, 0x000fe200078e00ffULL, 0x0000001b06067212ULL, 0x080fe200078efcffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0xfffffffc14177812ULL, 0x104fe400078ee223ULL,
0xfffffffc00157812ULL, 0x100fe200078ee223ULL, 0x0000000429167824ULL, 0x000fe200078e00ffULL,
0x0000640006067a10ULL, 0x000fe20007fde0ffULL, 0x000000042b187824ULL, 0x008fe200078e00ffULL,
0x0000001b08087212ULL, 0x000fe200078efcffULL, 0x0000001015157824ULL, 0x100fe200078e021aULL,
0xfffffffc16197812ULL, 0x100fe200078ee223ULL, 0x0000001017177824ULL, 0x000fe200078e021aULL,
0xfffffffc181d7812ULL, 0x000fc400078ee223ULL, 0xfffffffc1c237812ULL, 0x000fe200078ee223ULL,
0x0000001019197824ULL, 0x100fe200078e021aULL, 0x0000650007077a10ULL, 0x000fe200037fe4ffULL,
0x000000101d1b7824ULL, 0x100fe200078e021aULL, 0x0000640008087a10ULL, 0x000fe20007fde0ffULL,
0x00000010231d7824ULL, 0x000fe200078e021aULL, 0x0000000002157faeULL, 0x0003e4000e901c46ULL,
0x0000650009097a10ULL, 0x000fe400037fe4ffULL, 0x0000000004177faeULL, 0x0003e8000e101c46ULL,
0x000000000a197faeULL, 0x0003e8000d901c46ULL, 0x00000000061b7faeULL, 0x0003e8000d101c46ULL,
0x00000000081d7faeULL, 0x0003e2000c901c46ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x000000106c077811ULL, 0x042fe200078ff0ffULL, 0x000000106c0d7824ULL, 0x040fe200078e00ffULL,
0x0000006c6c007211ULL, 0x000fc400078fe8ffULL, 0x000000086c037811ULL, 0x040fe200078ff0ffULL,
0x0000000407147824ULL, 0x040fe200078e00ffULL, 0x000000186c097811ULL, 0x040fe200078ff0ffULL,
0x0000000107067824ULL, 0x100fe200078e020eULL, 0x000000206c0b7811ULL, 0x040fe200078ff0ffULL,
0x0000000103047824ULL, 0x040fe200078e020eULL, 0x000000286c2d7811ULL, 0x040fe200078ff0ffULL,
0x00000004030a7824ULL, 0x000fe200078e00ffULL, 0x000000306c2f7811ULL, 0x040fe200078ff0ffULL,
0x0000000409167824ULL, 0x000fe200078e00ffULL, 0x000000386c317811ULL, 0x040fe200078ff0ffULL,
0x000000040b187824ULL, 0x000fe200078e00ffULL, 0x0000000e6c027211ULL, 0x000fe200078ff0ffULL,
0x000000042d1a7824ULL, 0x000fe200078e00ffULL, 0x0000000300057812ULL, 0x000fe200078ec0ffULL,
0x000000042f1c7824ULL, 0x000fe200078e00ffULL, 0x000000300d0d7812ULL, 0x000fe200078ec0ffULL,
0x00000004311e7824ULL, 0x000fe200078e00ffULL, 0x0000200013277811ULL, 0x000fe200078e68ffULL,
0x0000010002027825ULL, 0x000fe200078e00ffULL, 0xfffffffc14147812ULL, 0x000fc400078ee205ULL,
0x0ffffffc6c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x000000400d297812ULL, 0x000fe400078efcffULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee205ULL,
0x00000010141d7824ULL, 0x000fe200078e0227ULL, 0xfffffffc16167812ULL, 0x100fe200078ee205ULL,
0x0000000109007824ULL, 0x100fe200078e020eULL, 0xfffffffc18187812ULL, 0x000fe200078ee205ULL,
0x000000100a1b7824ULL, 0x000fe200078e0227ULL, 0xfffffffc1a1a7812ULL, 0x000fe200078ee205ULL,
0x00000010161f7824ULL, 0x000fe200078e0227ULL, 0xfffffffc1c1c7812ULL, 0x000fe200078ee205ULL,
0x0000001018217824ULL, 0x000fe200078e0227ULL, 0xfffffffc1e1e7812ULL, 0x000fe200078ee205ULL,
0x00000001310a7824ULL, 0x000fe200078e020eULL, 0x0000000c05087212ULL, 0x000fe200078efcffULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x0000002902147212ULL, 0x000fc400078efcffULL,
0x0000002906187212ULL, 0x080fe200078efcffULL, 0x00000010082b7824ULL, 0x000fe200078e0227ULL,
0x0000640014147a10ULL, 0x000fe20007f3e0ffULL, 0x000000012d067824ULL, 0x100fe200078e020eULL,
0x0000002904167212ULL, 0x080fe200078efcffULL, 0x000000010b047824ULL, 0x100fe200078e020eULL,
0x0000650003157a10ULL, 0x000fe20000ffe4ffULL, 0x0000010000027825ULL, 0x000fe200078e00ffULL,
0x0000640016167a10ULL, 0x000fe40007f5e0ffULL, 0x0000640018187a10ULL, 0x000fe20007f7e0ffULL,
0x000000012f087824ULL, 0x000fe200078e020eULL, 0x0000650005177a10ULL, 0x000fe200017fe4ffULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x0000650007197a10ULL, 0x000fe20001ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000142b7faeULL, 0x0003e2000b901c46ULL,
0x0000002902027212ULL, 0x080fe200078efcffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000002904047212ULL, 0x080fe200078efcffULL, 0x00000000161b7faeULL, 0x0003e2000b901c46ULL,
0x0000640002027a10ULL, 0x000fe20007f3e0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000002906067212ULL, 0x080fe200078efcffULL, 0x00000000181d7faeULL, 0x0003e2000b901c46ULL,
0x0000650003037a10ULL, 0x000fe20000ffe4ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002908087212ULL, 0x000fc400078efcffULL, 0x0000640004047a10ULL, 0x000fe20007f3e0ffULL,
0x000000101a237824ULL, 0x100fe200078e0227ULL, 0x000000290a0a7212ULL, 0x000fe200078efcffULL,
0x000000101c257824ULL, 0x100fe200078e0227ULL, 0x0000640006067a10ULL, 0x000fe20007f5e0ffULL,
0x000000101e277824ULL, 0x000fe200078e0227ULL, 0x0000640008087a10ULL, 0x000fe20007f7e0ffULL,
0x00000000021f7faeULL, 0x0003e2000b901c46ULL, 0x000064000a0a7a10ULL, 0x000fe40007f9e0ffULL,
0x0000650005057a10ULL, 0x000fc40000ffe4ffULL, 0x0000650007077a10ULL, 0x000fe400017fe4ffULL,
0x0000650009097a10ULL, 0x000fe20001ffe4ffULL, 0x0000000004217faeULL, 0x0003e2000b901c46ULL,
0x000065000b0b7a10ULL, 0x000fc600027fe4ffULL, 0x0000000006237faeULL, 0x0003e8000b901c46ULL,
0x0000000008257faeULL, 0x0003e8000b901c46ULL, 0x000000000a277faeULL, 0x0003e4000b901c46ULL,
0x00000004ff0a7819ULL, 0x102fe2000001166cULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000076c4f7812ULL, 0x000fe200078ec0ffULL, 0x00002000130b7824ULL, 0x000fe200078e00ffULL,
0x00000003ff507819ULL, 0x000fe2000001166cULL, 0x000000080a007824ULL, 0x000fc600078e00ffULL,
0x0000000150027812ULL, 0x000fe400078ec0ffULL, 0xfffffff800037812ULL, 0x000fe400078ee24fULL,
0x000000084f4f7812ULL, 0x000fe400078ef86cULL, 0x00000010031d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000403257824ULL, 0x040fe200078e00ffULL, 0x0000000203047211ULL, 0x0c0fe200078ff8ffULL,
0x000000010a0a7824ULL, 0x000fe200078e024fULL, 0x00000020031f7810ULL, 0x000fe20007ffe0ffULL,
0x000000104f057824ULL, 0x000fe200078e00ffULL, 0x0000003003217810ULL, 0x000fe20007ffe0ffULL,
0x000000041d067824ULL, 0x000fe200078e00ffULL, 0x000000021f1c7211ULL, 0x080fe200078ff8ffULL,
0x000000104f237824ULL, 0x000fe200078e00ffULL, 0xfffffff005007812ULL, 0x000fe200078ee20aULL,
0x0000000403057824ULL, 0x000fe200078e00ffULL, 0x000000021d037211ULL, 0x080fe200078ff8ffULL,
0x0000000421157824ULL, 0x040fe200078e00ffULL, 0x0000000221027211ULL, 0x000fe200078ff8ffULL,
0x0000001000007824ULL, 0x000fe200078e00ffULL, 0xfffffffc05087812ULL, 0x000fe200078ee204ULL,
0x000000041f057824ULL, 0x000fe200078e00ffULL, 0xfffffffc06077812ULL, 0x000fe200078ee203ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000010000b097810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0xfffffffc05067812ULL, 0x000fe200078ee21cULL,
0x000000041d207824ULL, 0x000fe200078e00ffULL, 0xfffffffc15057812ULL, 0x000fe200078ee202ULL,
0x0000001008617824ULL, 0x100fe200078e0209ULL, 0x000000000014783bULL, 0x0003e20000000200ULL,
0x0000001007637824ULL, 0x100fe200078e0209ULL, 0x000000020a1e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001006647824ULL, 0x100fe200078e0209ULL, 0x000000006134783bULL, 0x000ea20000000200ULL,
0x0000001005657824ULL, 0x000fe200078e0209ULL, 0x0000000204047810ULL, 0x000fe20007ffe0ffULL,
0x000000041f1f7824ULL, 0x000fe200078e00ffULL, 0x00000000633c783bULL, 0x000ee20000000200ULL,
0x0000000421217824ULL, 0x000fe200078e00ffULL, 0x0000000203037810ULL, 0x000fc40007ffe0ffULL,
0x000000006444783bULL, 0x000f220000000200ULL, 0x000000021c1c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000202007810ULL, 0x002fe20007ffe0ffULL, 0x000000006518783bULL, 0x000e620000000200ULL,
0xfffffff0231e7812ULL, 0x000fe400078ee21eULL, 0xfffffffc25047812ULL, 0x000fe400078ee204ULL,
0xfffffffc20037812ULL, 0x000fe200078ee203ULL, 0x000000101e1e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1f027812ULL, 0x000fe200078ee21cULL, 0x0000001004667824ULL, 0x100fe200078e0209ULL,
0xfffffffc21007812ULL, 0x000fe200078ee200ULL, 0x0000001003687824ULL, 0x000fc400078e0209ULL,
0x00000010026a7824ULL, 0x100fe200078e0209ULL, 0x000000001e1c783bULL, 0x000fe20000000200ULL,
0x00000010006b7824ULL, 0x000fc600078e0209ULL, 0x000000006620783bULL, 0x000e680000000200ULL,
0x000000006824783bULL, 0x000e680000000200ULL, 0x000000006a28783bULL, 0x000e620000000200ULL,
0x000000341430723cULL, 0x044f6600000018ffULL, 0x000000006b2c783bULL, 0x000eaa0000000200ULL,
0x0000003c1438723cULL, 0x048ff000000018ffULL, 0x000000441440723cULL, 0x050ff000000018ffULL,
0x000000361434723cULL, 0x040f7000000018ffULL, 0x0000003e143c723cULL, 0x040f7000000018ffULL,
0x000000461444723cULL, 0x040f7000000018ffULL, 0x000000181448723cULL, 0x042f7000000018ffULL,
0x0000001a1414723cULL, 0x000f7000000018ffULL, 0x000000201c30723cULL, 0x060b700000001830ULL,
0x000000221c34723cULL, 0x040b700000001834ULL, 0x000000241c38723cULL, 0x040b700000001838ULL,
0x000000261c3c723cULL, 0x040b70000000183cULL, 0x000000281c40723cULL, 0x040b700000001840ULL,
0x0000002a1c44723cULL, 0x040b700000001844ULL, 0x0000002c1c48723cULL, 0x044b700000001848ULL,
0x0000002e1c1c723cULL, 0x000b620000001814ULL, 0x0000059000008947ULL, 0x000fce0003800000ULL,
0x00000002ff2d7819ULL, 0x120fe2000001166cULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x000000800d187812ULL, 0x000fe200078efcffULL, 0x0000000150507824ULL, 0x000fe200078e026cULL,
0x000000082d577810ULL, 0x040fe20007ffe0ffULL, 0x000000012d237824ULL, 0x040fe200078e020eULL,
0x000000102d557810ULL, 0x000fc40007ffe0ffULL, 0x000000202d517810ULL, 0x000fe20007ffe0ffULL,
0x0000000157217824ULL, 0x100fe200078e020eULL, 0x0000000f602a7217ULL, 0x000fe20007800000ULL,
0x00000001551b7824ULL, 0x000fe200078e020eULL, 0x000000282d2f7810ULL, 0x000fe20007ffe0ffULL,
0x0000010021207825ULL, 0x000fe200078e0018ULL, 0x000000182d537810ULL, 0x040fe40007ffe0ffULL,
0x000000302d2b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000151277824ULL, 0x000fe200078e020eULL,
0x0000640020207a10ULL, 0x000fe20007f7e0ffULL, 0x000000012a2a7824ULL, 0x000fc400078e0a0fULL,
0x000001001b1a7825ULL, 0x000fe200078e0018ULL, 0x0000650021217a10ULL, 0x000fe40001ffe4ffULL,
0x0000002a2d00720cULL, 0x080fe20003f26070ULL, 0x000000012f157824ULL, 0x000fe200078e020eULL,
0x000000382d2d7810ULL, 0x000fe20007ffe0ffULL, 0x0000010027267825ULL, 0x100fe200078e0018ULL,
0x000064001a1a7a10ULL, 0x000fe40007f9e0ffULL, 0x0000002a2b00720cULL, 0x000fe20003fa6070ULL,
0x0000010015147825ULL, 0x000fe200078e0018ULL, 0x0000640026267a10ULL, 0x000fc40007f7e0ffULL,
0x000065001b1b7a10ULL, 0x000fe200027fe4ffULL, 0x0000000153257824ULL, 0x100fe200078e020eULL,
0x0000640014287a10ULL, 0x000fe20007f9e0ffULL, 0x000000012b177824ULL, 0x100fe200078e020eULL,
0x0000650027277a10ULL, 0x000fe20001ffe4ffULL, 0x000000012d297824ULL, 0x000fe200078e020eULL,
0x0000002a5700720cULL, 0x080fe20003f66070ULL, 0x0000010023227825ULL, 0x100fe200078e0018ULL,
0x0000000350147812ULL, 0x000fe400078ec0ffULL, 0x0000002a2d00720cULL, 0x000fe20003fc6070ULL,
0x0000010025247825ULL, 0x000fe200078e0018ULL, 0x0000000c140c7212ULL, 0x000fc400078efcffULL,
0x0000640022227a10ULL, 0x000fe20007f5e0ffULL, 0x0000010017167825ULL, 0x000fc600078e0018ULL,
0x0000650023237a10ULL, 0x000fe200017fe4ffULL, 0x0000000457577824ULL, 0x000fe200078e00ffULL,
0x0000640024247a10ULL, 0x000fe20007f5e0ffULL, 0x0000010029187825ULL, 0x000fe200078e0018ULL,
0x0000650015297a10ULL, 0x000fe400027fe4ffULL, 0x0000002a5500720cULL, 0x0c0fe20003f86070ULL,
0x0000000455557824ULL, 0x000fe200078e00ffULL, 0xfffffffc572c7812ULL, 0x100fe200078ee214ULL,
0x000000100c157824ULL, 0x100fe200078e0209ULL, 0x0000650025257a10ULL, 0x000fe200017fe4ffULL,
0x000000042b2b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc552e7812ULL, 0x100fe200078ee214ULL,
0x000000102c557824ULL, 0x100fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022157faeULL, 0x0003e2000c901c46ULL, 0x0000002a5300720cULL, 0x0c0fe20003f26070ULL,
0x0000000453537824ULL, 0x000fe200078e00ffULL, 0x0000640016167a10ULL, 0x000fe20007f5e0ffULL,
0x000000102e577824ULL, 0x100fe200078e0209ULL, 0x0000000020557faeULL, 0x0005e2000d901c46ULL,
0x0000002a5100720cULL, 0x0c0fe20003f66070ULL, 0x0000000451517824ULL, 0x000fe200078e00ffULL,
0xfffffffc532c7812ULL, 0x100fe200078ee214ULL, 0x000000001a577faeULL, 0x0007e2000e101c46ULL,
0x0000002a2f00720cULL, 0x040fe20003f86070ULL, 0x000000042f2f7824ULL, 0x000fe200078e00ffULL,
0x0000650017177a10ULL, 0x000fe200017fe4ffULL, 0x000000042d2d7824ULL, 0x000fe200078e00ffULL,
0x0000640018187a10ULL, 0x000fe20007f5e0ffULL, 0x000000102c237824ULL, 0x002fe200078e0209ULL,
0xfffffffc2f207812ULL, 0x004fc400078ee214ULL, 0xfffffffc2d227812ULL, 0x100fe400078ee214ULL,
0x0000000024237faeULL, 0x0003e2000c901c46ULL, 0xfffffffc511a7812ULL, 0x008fe200078ee214ULL,
0x0000001020217824ULL, 0x000fe200078e0209ULL, 0x0000650019197a10ULL, 0x000fc600017fe4ffULL,
0x000000101a1b7824ULL, 0x000fe200078e0209ULL, 0xfffffffc2b1a7812ULL, 0x000fc800078ee214ULL,
0x00000000261b7faeULL, 0x0005e2000d901c46ULL, 0x000000101a237824ULL, 0x102fe400078e0209ULL,
0x0000001022257824ULL, 0x000fe200078e0209ULL, 0x0000000028217faeULL, 0x0005e8000e101c46ULL,
0x0000000016237faeULL, 0x0005e8000e901c46ULL, 0x0000000018257faeULL, 0x0005e2000f101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x000000086c577811ULL, 0x000fe200078ff0ffULL,
0x000000ffff297224ULL, 0x020fe200078e00ffULL, 0x000000800d287812ULL, 0x000fe200078efcffULL,
0x0000000150507824ULL, 0x000fe200078e026cULL, 0x000000206c2f7811ULL, 0x040fe200078ff0ffULL,
0x0000000157197824ULL, 0x040fe200078e020eULL, 0x000000306c2b7811ULL, 0x040fe200078ff0ffULL,
0x0000000457577824ULL, 0x000fe200078e00ffULL, 0x0000000e6c177211ULL, 0x040fe200078ff0ffULL,
0x0000010019187825ULL, 0x000fe200078e0028ULL, 0x000000186c537811ULL, 0x000fc400078ff0ffULL,
0x000000106c557811ULL, 0x000fe200078ff0ffULL, 0x000000012f237824ULL, 0x100fe200078e020eULL,
0x0000640018187a10ULL, 0x000fe20007f5e0ffULL, 0x000000012b157824ULL, 0x000fe200078e020eULL,
0x000000286c517811ULL, 0x040fe200078ff0ffULL, 0x0000010023227825ULL, 0x100fe200078e0028ULL,
0x0000650019197a10ULL, 0x000fe400017fe4ffULL, 0x000000386c2d7811ULL, 0x000fe200078ff0ffULL,
0x0000010015147825ULL, 0x000fe200078e0028ULL, 0x0000640022227a10ULL, 0x000fc60007f5e0ffULL,
0x0000010017167825ULL, 0x000fe200078e0028ULL, 0x0000650023237a10ULL, 0x000fe400017fe4ffULL,
0x0000640014267a10ULL, 0x000fe20007f5e0ffULL, 0x0000000153217824ULL, 0x100fe200078e020eULL,
0x0000000350147812ULL, 0x000fe200078ec0ffULL, 0x00000001551b7824ULL, 0x100fe200078e020eULL,
0x0000640016167a10ULL, 0x000fe20007f3e0ffULL, 0x0000000151257824ULL, 0x000fe200078e020eULL,
0xfffffffc572a7812ULL, 0x000fe200078ee214ULL, 0x0000000453577824ULL, 0x000fe200078e00ffULL,
0x0000000c140c7212ULL, 0x000fe200078efcffULL, 0x000000012d277824ULL, 0x000fe200078e020eULL,
0x0000650017177a10ULL, 0x000fe20000ffe4ffULL, 0x0000010021207825ULL, 0x000fc800078e0028ULL,
0x000000102a537824ULL, 0x000fe200078e0209ULL, 0xfffffffc572a7812ULL, 0x000fe200078ee214ULL,
0x0000000455557824ULL, 0x000fe200078e00ffULL, 0x0000640020207a10ULL, 0x000fe20007f3e0ffULL,
0x000001001b1a7825ULL, 0x000fc600078e0028ULL, 0xfffffffc552c7812ULL, 0x000fe200078ee214ULL,
0x0000010025247825ULL, 0x100fe200078e0028ULL, 0x000064001a1a7a10ULL, 0x000fe40007f7e0ffULL,
0x0000650021217a10ULL, 0x000fe20000ffe4ffULL, 0x000000042f2f7824ULL, 0x000fe200078e00ffULL,
0x0000640024247a10ULL, 0x000fe20007f3e0ffULL, 0x0000010027287825ULL, 0x000fe200078e0028ULL,
0x0000650015277a10ULL, 0x000fe400017fe4ffULL, 0x000065001b1b7a10ULL, 0x000fe20001ffe4ffULL,
0x000000100c157824ULL, 0x100fe200078e0209ULL, 0x0000650025257a10ULL, 0x000fe20000ffe4ffULL,
0x000000102a577824ULL, 0x100fe200078e0209ULL, 0xfffffffc2f2a7812ULL, 0x000fe200078ee214ULL,
0x0000000451517824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016157faeULL, 0x0003e2000b901c46ULL, 0x000000042b2b7824ULL, 0x000fe200078e00ffULL,
0x0000640028287a10ULL, 0x000fe20007f3e0ffULL, 0x000000042d2d7824ULL, 0x000fe200078e00ffULL,
0x0000000018537faeULL, 0x0005e2000b901c46ULL, 0x000000102c557824ULL, 0x000fe200078e0209ULL,
0x0000650029297a10ULL, 0x000fc80000ffe4ffULL, 0x000000001a557faeULL, 0x0007e2000b901c46ULL,
0xfffffffc51167812ULL, 0x102fe200078ee214ULL, 0x000000102a177824ULL, 0x100fe200078e0209ULL,
0xfffffffc2d2a7812ULL, 0x100fe200078ee214ULL, 0x0000000020577faeULL, 0x0003e2000b901c46ULL,
0xfffffffc2b187812ULL, 0x004fe200078ee214ULL, 0x0000001016197824ULL, 0x100fe400078e0209ULL,
0x0000000022177faeULL, 0x0005e4000b901c46ULL, 0x00000010181b7824ULL, 0x008fc400078e0209ULL,
0x0000000024197faeULL, 0x0005e2000b901c46ULL, 0x000000102a217824ULL, 0x002fc600078e0209ULL,
0x00000000261b7faeULL, 0x0005e8000b901c46ULL, 0x0000000028217faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000104f177824ULL, 0x004fe200078e00ffULL,
0x000000040a167810ULL, 0x000fe40007ffe0ffULL, 0x000020000b0b7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff017167812ULL, 0x000fc600078ee216ULL, 0x0000001008697824ULL, 0x100fe400078e020bULL,
0x0000001016207824ULL, 0x000fe400078e00ffULL, 0x0000001007677824ULL, 0x100fe400078e020bULL,
0x0000001006177824ULL, 0x100fe400078e020bULL, 0x0000001005167824ULL, 0x000fe200078e020bULL,
0x000000060a057810ULL, 0x000fe20007ffe0ffULL, 0x000000104f067824ULL, 0x000fc400078e00ffULL,
0x0000001004087824ULL, 0x100fe400078e020bULL, 0x0000001003037824ULL, 0x000fe200078e020bULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006918783bULL, 0x000fe20000000200ULL,
0xfffffff006057812ULL, 0x000fe200078ee205ULL, 0x0000001002027824ULL, 0x100fe400078e020bULL,
0x000000002020783bULL, 0x000e620000000200ULL, 0x0000001000007824ULL, 0x000fe400078e020bULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x000000006728783bULL, 0x000ea80000000200ULL,
0x000000001724783bULL, 0x000ee80000000200ULL, 0x00000000162c783bULL, 0x000f280000000200ULL,
0x000000000850783bULL, 0x000fe80000000200ULL, 0x000000000504783bULL, 0x000ee80000000200ULL,
0x00000000035c783bULL, 0x000ee80000000200ULL, 0x000000000258783bULL, 0x000ee80000000200ULL,
0x000000000054783bULL, 0x000ee20000000200ULL, 0x000000182030723cULL, 0x042f700000001830ULL,
0x0000001a2034723cULL, 0x040f700000001834ULL, 0x000000282038723cULL, 0x044f700000001838ULL,
0x0000002a203c723cULL, 0x040f70000000183cULL, 0x000000242040723cULL, 0x048f700000001840ULL,
0x000000262044723cULL, 0x040f700000001844ULL, 0x0000002c2048723cULL, 0x050f700000001848ULL,
0x0000002e201c723cULL, 0x000f70000000181cULL, 0x000000500430723cULL, 0x060b700000001830ULL,
0x000000520434723cULL, 0x040b700000001834ULL, 0x0000005c0438723cULL, 0x040b700000001838ULL,
0x0000005e043c723cULL, 0x040b70000000183cULL, 0x000000580440723cULL, 0x040b700000001840ULL,
0x0000005a0444723cULL, 0x040b700000001844ULL, 0x000000540448723cULL, 0x040b700000001848ULL,
0x00000056041c723cULL, 0x000b62000000181cULL, 0x0000056000008947ULL, 0x000fce0003800000ULL,
0x00000002ff2d7819ULL, 0x000fe2000001166cULL, 0x000000ffff1b7224ULL, 0x000fe200078e00ffULL,
0x000000c00d1a7812ULL, 0x000fc400078efcffULL, 0x000000102d277810ULL, 0x040fe20007ffe0ffULL,
0x000000012d077824ULL, 0x060fe200078e020eULL, 0x000000082d297810ULL, 0x040fe40007ffe0ffULL,
0x000000182d2f7810ULL, 0x000fe20007ffe0ffULL, 0x0000010007067825ULL, 0x000fe200078e001aULL,
0x000000202d517810ULL, 0x040fe40007ffe0ffULL, 0x000000282d537810ULL, 0x000fe20007ffe0ffULL,
0x0000000127197824ULL, 0x100fe200078e020eULL, 0x0000640006207a10ULL, 0x000fe20007f1e0ffULL,
0x0000000129057824ULL, 0x000fe200078e020eULL, 0x0000000f60067217ULL, 0x000fe20007800000ULL,
0x0000010019187825ULL, 0x000fe200078e001aULL, 0x0000650007217a10ULL, 0x000fc400007fe4ffULL,
0x000000302d557810ULL, 0x000fe20007ffe0ffULL, 0x0000000106267824ULL, 0x000fe200078e0a0fULL,
0x0000640018187a10ULL, 0x000fe20007f1e0ffULL, 0x000000012f077824ULL, 0x000fe400078e020eULL,
0x0000010005047825ULL, 0x000fe200078e001aULL, 0x000000262900720cULL, 0x080fe40003f66070ULL,
0x000000262d00720cULL, 0x000fe20003f46070ULL, 0x0000000429297824ULL, 0x000fe200078e00ffULL,
0x0000640004047a10ULL, 0x000fe20007f3e0ffULL, 0x0000000151257824ULL, 0x000fe200078e020eULL,
0x0000650019197a10ULL, 0x000fe200007fe4ffULL, 0x0000010007067825ULL, 0x000fe200078e001aULL,
0xfffffffc29287812ULL, 0x000fc400078ee214ULL, 0x0000650005057a10ULL, 0x000fe20000ffe4ffULL,
0x0000000153237824ULL, 0x000fe200078e020eULL, 0x0000640006067a10ULL, 0x000fe20007f1e0ffULL,
0x0000010025247825ULL, 0x100fe200078e001aULL, 0x000000382d2d7810ULL, 0x000fe40007ffe0ffULL,
0x0000650007077a10ULL, 0x000fe200007fe4ffULL, 0x0000010023227825ULL, 0x000fe200078e001aULL,
0x0000640024247a10ULL, 0x000fe40007f3e0ffULL, 0x000000262700720cULL, 0x080fe20003fa6070ULL,
0x000000100c297824ULL, 0x100fe200078e020bULL, 0x0000640022227a10ULL, 0x000fe20007f1e0ffULL,
0x00000010282b7824ULL, 0x000fe200078e020bULL, 0x000000262f00720cULL, 0x080fe20003f86070ULL,
0x0000000155577824ULL, 0x000fe200078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020297faeULL, 0x0003e2000d101c46ULL, 0x0000000427277824ULL, 0x000fe200078e00ffULL,
0x0000650025257a10ULL, 0x000fe20000ffe4ffULL, 0x000000042f2f7824ULL, 0x000fe200078e00ffULL,
0x00000000042b7faeULL, 0x0005e2000d901c46ULL, 0x000000265100720cULL, 0x0c0fe20003f66070ULL,
0x0000000451517824ULL, 0x000fe200078e00ffULL, 0x000000265300720cULL, 0x040fe20003f46070ULL,
0x0000000453537824ULL, 0x000fe200078e00ffULL, 0x0000650023237a10ULL, 0x000fc400007fe4ffULL,
0x000000265500720cULL, 0x0c0fe20003f26070ULL, 0x0000000455557824ULL, 0x000fe200078e00ffULL,
0x000000262d00720cULL, 0x000fe40003f06070ULL, 0xfffffffc270c7812ULL, 0x000fe200078ee214ULL,
0x0000010057047825ULL, 0x004fe200078e001aULL, 0xfffffffc51207812ULL, 0x102fe400078ee214ULL,
0xfffffffc53267812ULL, 0x000fe200078ee214ULL, 0x000000012d577824ULL, 0x040fe200078e020eULL,
0x0000640004047a10ULL, 0x000fe20007fde0ffULL, 0x000000042d2d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc2f0e7812ULL, 0x000fe200078ee214ULL, 0x00000100571a7825ULL, 0x000fe200078e001aULL,
0xfffffffc55287812ULL, 0x000fc400078ee214ULL, 0x0000650005057a10ULL, 0x000fe200037fe4ffULL,
0x000000100c217824ULL, 0x100fe200078e020bULL, 0xfffffffc2d2a7812ULL, 0x000fe200078ee214ULL,
0x000000100e277824ULL, 0x100fe200078e020bULL, 0x000064001a1a7a10ULL, 0x000fe20007fde0ffULL,
0x0000001020297824ULL, 0x100fe200078e020bULL, 0x0000000018217faeULL, 0x0003e2000e901c46ULL,
0x00000010262b7824ULL, 0x100fe200078e020bULL, 0x000065001b1b7a10ULL, 0x000fe200037fe4ffULL,
0x00000010282d7824ULL, 0x100fe200078e020bULL, 0x0000000006277faeULL, 0x0003e2000e101c46ULL,
0x000000102a0b7824ULL, 0x000fc600078e020bULL, 0x0000000024297faeULL, 0x0003e8000d901c46ULL,
0x00000000222b7faeULL, 0x0003e8000d101c46ULL, 0x00000000042d7faeULL, 0x0003e8000c901c46ULL,
0x000000001a0b7faeULL, 0x0003e2000c101c46ULL, 0x000004a000007947ULL, 0x000fea0003800000ULL,
0x000000086c2b7811ULL, 0x040fe200078ff0ffULL, 0x000000ffff057224ULL, 0x020fe200078e00ffULL,
0x000000106c2d7811ULL, 0x000fc400078ff0ffULL, 0x000000186c2f7811ULL, 0x040fe200078ff0ffULL,
0x000000012b257824ULL, 0x100fe200078e020eULL, 0x000000206c517811ULL, 0x040fe200078ff0ffULL,
0x000000012d277824ULL, 0x100fe200078e020eULL, 0x000000286c537811ULL, 0x040fe200078ff0ffULL,
0x000000012f077824ULL, 0x100fe200078e020eULL, 0x000000306c557811ULL, 0x040fe200078ff0ffULL,
0x0000000151197824ULL, 0x100fe200078e020eULL, 0x000000c00d047812ULL, 0x000fe200078efcffULL,
0x00000001531b7824ULL, 0x100fe200078e020eULL, 0x0000000e6c237211ULL, 0x040fe200078ff0ffULL,
0x0000000155217824ULL, 0x000fe200078e020eULL, 0x000000386c577811ULL, 0x000fe200078ff0ffULL,
0x0000010025247825ULL, 0x000fc800078e0004ULL, 0x0000000157297824ULL, 0x000fe200078e020eULL,
0x0000640024247a10ULL, 0x000fe20007f3e0ffULL, 0x0000010023227825ULL, 0x000fc600078e0004ULL,
0x0000650025257a10ULL, 0x000fe20000ffe4ffULL, 0x000000042b2b7824ULL, 0x000fe200078e00ffULL,
0x0000640022227a10ULL, 0x000fe20007f1e0ffULL, 0x0000010027267825ULL, 0x000fc600078e0004ULL,
0x0000650023237a10ULL, 0x000fe200007fe4ffULL, 0x000000042d2d7824ULL, 0x000fe200078e00ffULL,
0x0000640026267a10ULL, 0x000fe20007f5e0ffULL, 0x0000010007067825ULL, 0x000fc600078e0004ULL,
0xfffffffc2d0e7812ULL, 0x000fe200078ee214ULL, 0x0000010019187825ULL, 0x100fe200078e0004ULL,
0x0000640006067a10ULL, 0x000fe40007f7e0ffULL, 0x0000650027277a10ULL, 0x000fe200017fe4ffULL,
0x000001001b1a7825ULL, 0x100fe200078e0004ULL, 0x0000640018187a10ULL, 0x000fe40007f1e0ffULL,
0x0000650007077a10ULL, 0x000fe20001ffe4ffULL, 0x0000010021207825ULL, 0x000fe200078e0004ULL,
0x000064001a1a7a10ULL, 0x000fc40007f3e0ffULL, 0x0000650019197a10ULL, 0x000fe200007fe4ffULL,
0x000000042f2f7824ULL, 0x000fe200078e00ffULL, 0x0000640020207a10ULL, 0x000fe20007f5e0ffULL,
0x0000010029047825ULL, 0x000fe200078e0004ULL, 0x000065001b1b7a10ULL, 0x000fe40000ffe4ffULL,
0xfffffffc2f287812ULL, 0x100fe200078ee214ULL, 0x0000000451517824ULL, 0x000fe200078e00ffULL,
0x0000640004047a10ULL, 0x000fe20007f7e0ffULL, 0x000000100c297824ULL, 0x100fe200078e020bULL,
0xfffffffc2b0c7812ULL, 0x100fe200078ee214ULL, 0x0000000453537824ULL, 0x000fe200078e00ffULL,
0xfffffffc512a7812ULL, 0x100fe200078ee214ULL, 0x0000000455557824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022297faeULL, 0x0003e2000b901c46ULL,
0x0000000457577824ULL, 0x000fe200078e00ffULL, 0xfffffffc532c7812ULL, 0x100fe200078ee214ULL,
0x000000100c2b7824ULL, 0x100fe200078e020bULL, 0xfffffffc552e7812ULL, 0x100fe200078ee214ULL,
0x000000100e2d7824ULL, 0x100fe200078e020bULL, 0xfffffffc57507812ULL, 0x000fe200078ee214ULL,
0x00000010282f7824ULL, 0x100fe200078e020bULL, 0x0000650021217a10ULL, 0x000fe200017fe4ffULL,
0x000000102a517824ULL, 0x100fe200078e020bULL, 0x00000000242b7faeULL, 0x0003e2000b901c46ULL,
0x000000102c537824ULL, 0x100fe200078e020bULL, 0x0000650005057a10ULL, 0x000fe20001ffe4ffULL,
0x000000102e557824ULL, 0x100fe200078e020bULL, 0x00000000262d7faeULL, 0x0003e2000b901c46ULL,
0x00000010500b7824ULL, 0x000fc600078e020bULL, 0x00000000062f7faeULL, 0x0003e8000b901c46ULL,
0x0000000018517faeULL, 0x0003e8000b901c46ULL, 0x000000001a537faeULL, 0x0003e8000b901c46ULL,
0x0000000020557faeULL, 0x0003e8000b901c46ULL, 0x00000000040b7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000104f057824ULL, 0x042fe200078e00ffULL,
0x000000080a047810ULL, 0x040fe20007ffe0ffULL, 0x000000104f0c7824ULL, 0x000fe200078e00ffULL,
0x0000000a0a0b7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff005047812ULL, 0x000fe400078ee204ULL,
0xfffffff00c0b7812ULL, 0x000fe400078ee20bULL, 0x00000300120c7a10ULL, 0x000fe20007ffe0ffULL,
0x0000001004507824ULL, 0x000fe400078e00ffULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006104783bULL, 0x000fe80000000200ULL,
0x000000005050783bULL, 0x000e680000000200ULL, 0x00000000635c783bULL, 0x000ea80000000200ULL,
0x000000006458783bULL, 0x000ee80000000200ULL, 0x000000006554783bULL, 0x000f280000000200ULL,
0x00000000662c783bULL, 0x000fe80000000200ULL, 0x000000000b18783bULL, 0x000ee80000000200ULL,
0x000000006828783bULL, 0x000ee80000000200ULL, 0x000000006a24783bULL, 0x000ee80000000200ULL,
0x000000006b20783bULL, 0x000ee20000000200ULL, 0x000000045030723cULL, 0x042b6e0000001830ULL,
0x000000010c057810ULL, 0x020fe20007ffe0ffULL, 0x000000065034723cULL, 0x000f660000001834ULL,
0x000000620500720cULL, 0x000fca0003f06070ULL, 0x0000005c5038723cULL, 0x044f700000001838ULL,
0x0000005e503c723cULL, 0x040f70000000183cULL, 0x000000585040723cULL, 0x048f700000001840ULL,
0x0000005a5044723cULL, 0x040f700000001844ULL, 0x000000545048723cULL, 0x050f700000001848ULL,
0x00000056501c723cULL, 0x000f70000000181cULL, 0x0000002c1830723cULL, 0x040f700000001830ULL,
0x0000002e1834723cULL, 0x060f700000001834ULL, 0x000000281838723cULL, 0x040f700000001838ULL,
0x0000002a183c723cULL, 0x040f70000000183cULL, 0x000000241840723cULL, 0x040f700000001840ULL,
0x000000261844723cULL, 0x040f700000001844ULL, 0x000000201848723cULL, 0x040f700000001848ULL,
0x00000022181c723cULL, 0x000b6e000000181cULL, 0x000001000c197824ULL, 0x020fc800078e0273ULL,
0x000068006d0b7a24ULL, 0x000fe200078e0219ULL, 0x000005b000008947ULL, 0x000fca0003800000ULL,
0x00000002ff247819ULL, 0x000fe4000001166cULL, 0x0000001960067217ULL, 0x000fe40007800000ULL,
0x0000000824257810ULL, 0x040fe20007ffe0ffULL, 0x0000000124047824ULL, 0x040fe200078e020bULL,
0x0000001024277810ULL, 0x000fe20007ffe0ffULL, 0x00000001060e7824ULL, 0x000fe200078e0a19ULL,
0x0000001824287810ULL, 0x040fe20007ffe0ffULL, 0x0000000125187824ULL, 0x000fe200078e020bULL,
0x0000002024297810ULL, 0x000fe20007ffe0ffULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x00000028242a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000e2700720cULL, 0x0c0fe20003fa6070ULL,
0x0000000127077824ULL, 0x100fe200078e020bULL, 0x0000000d04207212ULL, 0x080fe200078efcffULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x0000000e2800720cULL, 0x000fe40003f86070ULL,
0x0000640020207a10ULL, 0x000fe20007f1e0ffULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x0000000d181a7212ULL, 0x080fe400078efcffULL, 0x0000650005217a10ULL, 0x000fe200007fe4ffULL,
0x0000000128227824ULL, 0x100fe200078e020bULL, 0x0000000d06047212ULL, 0x000fe200078efcffULL,
0x0000000129187824ULL, 0x000fe200078e020bULL, 0x000064001a1a7a10ULL, 0x000fe20007f3e0ffULL,
0x0000010022227825ULL, 0x000fe200078e00ffULL, 0x0000640004047a10ULL, 0x000fc40007f1e0ffULL,
0x00006500191b7a10ULL, 0x000fe20000ffe4ffULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x0000000e2500720cULL, 0x080fe40003f26070ULL, 0x0000650007057a10ULL, 0x000fe200007fe4ffULL,
0x0000000425257824ULL, 0x000fe200078e00ffULL, 0x0000000e2400720cULL, 0x000fe20003f06070ULL,
0x0000000427277824ULL, 0x000fe200078e00ffULL, 0x0000000d22067212ULL, 0x000fe200078efcffULL,
0x000000012a227824ULL, 0x000fe200078e020bULL, 0xfffffffc25267812ULL, 0x000fc400078ee214ULL,
0x0000640006067a10ULL, 0x000fe40007f5e0ffULL, 0x0000000d18187212ULL, 0x080fe200078efcffULL,
0x0000001026257824ULL, 0x000fe200078e0209ULL, 0x0000003024267810ULL, 0x000fe40007ffe0ffULL,
0x0000650023077a10ULL, 0x000fe200017fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020157faeULL, 0x0003e2000c101c46ULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x0000003824247810ULL, 0x000fe40007ffe0ffULL, 0x0000640018187a10ULL, 0x000fe20007f7e0ffULL,
0x000000001a257faeULL, 0x0005e2000c901c46ULL, 0x0000000d22227212ULL, 0x000fe200078efcffULL,
0x00000004262b7824ULL, 0x000fe200078e00ffULL, 0x0000650019197a10ULL, 0x000fc40001ffe4ffULL,
0x0000000e2900720cULL, 0x0c0fe20003f66070ULL, 0x0000000429297824ULL, 0x000fe200078e00ffULL,
0x0000640022227a10ULL, 0x000fe20007fde0ffULL, 0x0000000126207824ULL, 0x102fe200078e020bULL,
0x0000000e2a00720cULL, 0x080fe20003f46070ULL, 0x0000000428157824ULL, 0x000fe200078e00ffULL,
0x0000000e2600720cULL, 0x080fe20003f26070ULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x0000000e2400720cULL, 0x040fe40003f06070ULL, 0x0000650023237a10ULL, 0x000fe200037fe4ffULL,
0x00000001241a7824ULL, 0x004fe200078e020bULL, 0x0000000d20207212ULL, 0x000fe200078efcffULL,
0x000000042a257824ULL, 0x000fe200078e00ffULL, 0xfffffffc270e7812ULL, 0x000fe200078ee214ULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x0000640020207a10ULL, 0x000fc40007fde0ffULL,
0xfffffffc29267812ULL, 0x100fe200078ee214ULL, 0x00000004240b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc15247812ULL, 0x100fe400078ee214ULL, 0x0000000d1a0d7212ULL, 0x000fe200078efcffULL,
0x0000001026277824ULL, 0x100fe200078e0209ULL, 0xfffffffc25287812ULL, 0x100fe200078ee214ULL,
0x0000001024257824ULL, 0x100fe200078e0209ULL, 0xfffffffc2b2a7812ULL, 0x100fe400078ee214ULL,
0xfffffffc0b2c7812ULL, 0x000fe200078ee214ULL, 0x000000100e0b7824ULL, 0x100fe200078e0209ULL,
0x0000650021217a10ULL, 0x000fe200037fe4ffULL, 0x000000102a297824ULL, 0x100fe200078e0209ULL,
0x000064000d147a10ULL, 0x000fe20007fde0ffULL, 0x00000010280d7824ULL, 0x100fe200078e0209ULL,
0x00000000040b7faeULL, 0x0003e2000e901c46ULL, 0x000000102c097824ULL, 0x000fe200078e0209ULL,
0x000065001b157a10ULL, 0x000fc400037fe4ffULL, 0x0000000006257faeULL, 0x0003e8000e101c46ULL,
0x0000000018277faeULL, 0x0003e8000d901c46ULL, 0x00000000220d7faeULL, 0x0003e8000d101c46ULL,
0x0000000020297faeULL, 0x0003e8000c901c46ULL, 0x0000000014097faeULL, 0x0003e2000c101c46ULL,
0x000004f000007947ULL, 0x000fea0003800000ULL, 0x000000106c1a7811ULL, 0x040fe400078ff0ffULL,
0x000000186c207811ULL, 0x000fc400078ff0ffULL, 0x0000000b6c047211ULL, 0x000fe200078ff0ffULL,
0x000000011a187824ULL, 0x100fe200078e020bULL, 0x000000086c0e7811ULL, 0x000fe200078ff0ffULL,
0x000000041a197824ULL, 0x000fe200078e00ffULL, 0x000000206c227811ULL, 0x000fe200078ff0ffULL,
0x00000004201b7824ULL, 0x000fe200078e00ffULL, 0x000000286c247811ULL, 0x000fe200078ff0ffULL,
0x000000040e077824ULL, 0x000fe200078e00ffULL, 0x000000306c267811ULL, 0x000fe200078ff0ffULL,
0x00000001201a7824ULL, 0x000fe200078e020bULL, 0x000000386c287811ULL, 0x000fe200078ff0ffULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0xfffffffc1b2a7812ULL, 0x000fc600078ee214ULL,
0x0000000122207824ULL, 0x100fe200078e020bULL, 0x0000000d04047212ULL, 0x000fe200078efcffULL,
0x0000000422217824ULL, 0x000fe400078e00ffULL, 0x000000010e067824ULL, 0x100fe200078e020bULL,
0xfffffffc070e7812ULL, 0x100fe200078ee214ULL, 0x0000000124227824ULL, 0x140fe200078e020bULL,
0xfffffffc212c7812ULL, 0x000fe200078ee214ULL, 0x0000000424237824ULL, 0x000fe200078e00ffULL,
0x0000640004047a10ULL, 0x000fe20007f1e0ffULL, 0x0000000126247824ULL, 0x000fc400078e020bULL,
0x0000000426257824ULL, 0x000fe200078e00ffULL, 0xfffffffc232e7812ULL, 0x100fe200078ee214ULL,
0x0000000128267824ULL, 0x040fe200078e020bULL, 0x0000650005057a10ULL, 0x000fe200007fe4ffULL,
0x00000004280b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc19287812ULL, 0x100fe200078ee214ULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc25507812ULL, 0x100fe200078ee214ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004157faeULL, 0x0003e2000b901c46ULL,
0xfffffffc0b147812ULL, 0x000fe200078ee214ULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000d1a1a7212ULL, 0x000fc600078efcffULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x0000000d06067212ULL, 0x080fe400078efcffULL, 0x000064001a1a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x0000000d18187212ULL, 0x080fe400078efcffULL,
0x0000640006067a10ULL, 0x000fe20007f3e0ffULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x0000000d20207212ULL, 0x080fe400078efcffULL, 0x0000640018187a10ULL, 0x000fe20007f5e0ffULL,
0x0000010024247825ULL, 0x000fe200078e00ffULL, 0x0000000d22227212ULL, 0x000fc400078efcffULL,
0x000065001b1b7a10ULL, 0x000fe200007fe4ffULL, 0x0000010026267825ULL, 0x000fe200078e00ffULL,
0x0000000d24247212ULL, 0x080fe400078efcffULL, 0x0000650007077a10ULL, 0x000fe20000ffe4ffULL,
0x000000100e0b7824ULL, 0x100fe200078e0209ULL, 0x0000000d260d7212ULL, 0x000fe200078efcffULL,
0x0000001028297824ULL, 0x100fe200078e0209ULL, 0x0000640020207a10ULL, 0x000fe20007f1e0ffULL,
0x000000102a2b7824ULL, 0x100fe200078e0209ULL, 0x0000650019197a10ULL, 0x000fe200017fe4ffULL,
0x000000102c2d7824ULL, 0x100fe200078e0209ULL, 0x0000640022227a10ULL, 0x000fe20007f3e0ffULL,
0x000000102e2f7824ULL, 0x100fe200078e0209ULL, 0x0000640024247a10ULL, 0x000fe20007f5e0ffULL,
0x0000001050517824ULL, 0x100fe200078e0209ULL, 0x000064000d267a10ULL, 0x000fe20007f7e0ffULL,
0x00000000060b7faeULL, 0x0003e2000b901c46ULL, 0x0000650021217a10ULL, 0x000fe200007fe4ffULL,
0x0000001014097824ULL, 0x000fe200078e0209ULL, 0x0000650023237a10ULL, 0x000fe20000ffe4ffULL,
0x0000000018297faeULL, 0x0003e2000b901c46ULL, 0x0000650025257a10ULL, 0x000fc400017fe4ffULL,
0x0000650027277a10ULL, 0x000fe20001ffe4ffULL, 0x000000001a2b7faeULL, 0x0003e8000b901c46ULL,
0x00000000202d7faeULL, 0x0003e8000b901c46ULL, 0x00000000222f7faeULL, 0x0003e8000b901c46ULL,
0x0000000024517faeULL, 0x0003e8000b901c46ULL, 0x0000000026097faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000104f057824ULL, 0x042fe200078e00ffULL,
0x0000000c0a047810ULL, 0x040fe20007ffe0ffULL, 0x000000104f4f7824ULL, 0x000fe200078e00ffULL,
0x0000000e0a0a7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff005047812ULL, 0x000fe400078ee204ULL,
0xfffffff04f0a7812ULL, 0x000fc600078ee20aULL, 0x0000001004047824ULL, 0x000fe400078e00ffULL,
0x000000100a0a7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000006968783bULL, 0x000fe80000000200ULL, 0x000000000404783bULL, 0x000e680000000200ULL,
0x000000001718783bULL, 0x000fe80000000200ULL, 0x000000006764783bULL, 0x000ea80000000200ULL,
0x000000001614783bULL, 0x000ee80000000200ULL, 0x000000000820783bULL, 0x000fe80000000200ULL,
0x000000000a08783bULL, 0x000f280000000200ULL, 0x000000000324783bULL, 0x000ee80000000200ULL,
0x000000000228783bULL, 0x000ee80000000200ULL, 0x00000000002c783bULL, 0x000ee20000000200ULL,
0x000000680430723cULL, 0x042f700000001830ULL, 0x0000006a0434723cULL, 0x040f700000001834ULL,
0x000000640438723cULL, 0x044f700000001838ULL, 0x00000066043c723cULL, 0x040f70000000183cULL,
0x000000180440723cULL, 0x040f700000001840ULL, 0x0000001a0444723cULL, 0x040ff00000001844ULL,
0x000000140448723cULL, 0x048ff00000001848ULL, 0x00000016041c723cULL, 0x000ff0000000181cULL,
0x000000200830723cULL, 0x070ff00000001830ULL, 0x000000220834723cULL, 0x040f700000001834ULL,
0x000000240838723cULL, 0x040f700000001838ULL, 0x00000026083c723cULL, 0x040f70000000183cULL,
0x000000280840723cULL, 0x040b6e0000001840ULL, 0x3db504f337297820ULL, 0x020fe20000410000ULL,
0x0000002a0844723cULL, 0x000b620000001844ULL, 0x3db504f338287820ULL, 0x000fe20000410000ULL,
0x3db504f339267820ULL, 0x000fe20000410000ULL, 0x3db504f33a277820ULL, 0x000fe20000410000ULL,
0x3db504f33b257820ULL, 0x000fc60000410000ULL, 0x3db504f3352a7820ULL, 0x020fe20000410000ULL,
0x0000002c0848723cULL, 0x040b620000001848ULL, 0x3db504f3362b7820ULL, 0x000fe20000410000ULL,
0x3db504f33c247820ULL, 0x000fe20000410000ULL, 0x3db504f33d227820ULL, 0x000fe20000410000ULL,
0x3db504f33e237820ULL, 0x000fe20000410000ULL, 0x3db504f33f217820ULL, 0x000fe40000410000ULL,
0x3db504f3332d7820ULL, 0x020fe20000410000ULL, 0x0000002e081c723cULL, 0x000b62000000181cULL,
0x3db504f3342c7820ULL, 0x000fe20000410000ULL, 0x3db504f340207820ULL, 0x000fe20000410000ULL,
0x3db504f341417820ULL, 0x000fe20000410000ULL, 0x3db504f342427820ULL, 0x000fe20000410000ULL,
0x3db504f3430d7820ULL, 0x000fc40000410000ULL, 0x3db504f3302f7820ULL, 0x020fe20000410000ULL,
0x3db504f3312e7820ULL, 0x000fe20000410000ULL, 0x3db504f332307820ULL, 0x000fe20000410000ULL,
0x3db504f344447820ULL, 0x000fe20000410000ULL, 0x3db504f345457820ULL, 0x000fe20000410000ULL,
0x3db504f346147820ULL, 0x000fe20000410000ULL, 0x3db504f3471a7820ULL, 0x000fc60000410000ULL,
0x3db504f3481b7820ULL, 0x000fe20000410000ULL, 0x3db504f349337820ULL, 0x000fe20000410000ULL,
0x3db504f34a157820ULL, 0x000fe20000410000ULL, 0x3db504f34b167820ULL, 0x000fca0000410000ULL,
0x3db504f31c317820ULL, 0x000fe20000410000ULL, 0x3db504f31d327820ULL, 0x000fe20000410000ULL,
0x3db504f31e177820ULL, 0x000fe20000410000ULL, 0x3db504f31f187820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000071027f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1e7224ULL, 0x000fe400078e0041ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0044ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0045ULL, 0x000000ffff1f7224ULL, 0x000fc400078e0042ULL,
0x0000000000047805ULL, 0x000fca0000015200ULL, 0x0000040071077984ULL, 0x000ee40000000800ULL,
0x8000000007ff7812ULL, 0x00cfc40007804803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011407ULL, 0x0000000900007211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000200007819ULL, 0x000fc80000001207ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040071077984ULL, 0x000ea40000000800ULL, 0x8000000007ff7812ULL, 0x004fe40007804803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000046c197824ULL, 0x000fe200078e00ffULL,
0x0000006f1200720cULL, 0x000fc80003f06070ULL, 0xfffffff019007812ULL, 0x000fca00078ec0ffULL,
0x0000008013007824ULL, 0x000fca00078e0200ULL, 0x0134000000047984ULL, 0x0004e20000000c00ULL,
0x000014e000008947ULL, 0x000fea0003800000ULL, 0x00005a0000097b06ULL, 0x000f220000209000ULL,
0x000000ffff027224ULL, 0x000fe200078e00ffULL, 0x000000706c087211ULL, 0x040fe200078ff0ffULL,
0x000000026c357824ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f85070ULL,
0x00005a00ff0e7a12ULL, 0x000fe400078e33ffULL, 0x0000000635357812ULL, 0x000fc800078ec0ffULL,
0x0000001035367812ULL, 0x040fe200078efcffULL, 0x0000000135127824ULL, 0x000fe200078e024eULL,
0x0000000900097308ULL, 0x010f260000001000ULL, 0x00000001103c7824ULL, 0x000fe200078e0236ULL,
0x0ffffffe090a7810ULL, 0x010fc80007ffe0ffULL, 0x0000000a00037305ULL, 0x000f24000021f000ULL,
0x000000ffff0b7224ULL, 0x010fc800078e0a03ULL, 0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL,
0x0000000b030b7227ULL, 0x000fe200078e0002ULL, 0x0000000808037810ULL, 0x000fca0007ffe0ffULL,
0x000000080b027227ULL, 0x000fc800078e00ffULL, 0x000000030b097227ULL, 0x000fc800078e00ffULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a02ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0a09ULL,
0x00005a000b087a24ULL, 0x000fe400078e0208ULL, 0x00005a000a037a24ULL, 0x000fe200078e0203ULL,
0x0000000f600a7217ULL, 0x000fe40007800000ULL, 0x00005a0008007a0cULL, 0x000fe40003f06070ULL,
0x00005a0003007a0cULL, 0x000fe20003f46070ULL, 0x000000010a377824ULL, 0x000fd400078e0a0fULL,
0x80005a0008080a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0003032a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0008007a0cULL, 0x000fe20003f26070ULL, 0x0000000110087824ULL, 0x000fe200078e0235ULL,
0x00005a0003007a0cULL, 0x000fe40003f66070ULL, 0x0000000102020810ULL, 0x000fe20007ffe0ffULL,
0x00000001080a7824ULL, 0x000fe200078e0a37ULL, 0x0000000109092810ULL, 0x000fc40007ffe0ffULL,
0x000000371200720cULL, 0x000fe40003f06070ULL, 0x0000000a110a7217ULL, 0x000fc60003800000ULL,
0x0000000102021810ULL, 0x000fe40007ffe0ffULL, 0x000000370800720cULL, 0x000fe20003f26070ULL,
0x0000000112087824ULL, 0x000fe200078e0a37ULL, 0x000000020e027207ULL, 0x040fe40006000000ULL,
0x0000000109093810ULL, 0x000fe40007ffe0ffULL, 0x00000002114f7217ULL, 0x000fe40003800000ULL,
0x000000090e0e7207ULL, 0x000fc40006000000ULL, 0x0000000811087217ULL, 0x040fe20003800000ULL,
0x000000013c407824ULL, 0x000fe200078e0a37ULL, 0x00000004ff0a7819ULL, 0x000fe2000001160aULL,
0x0000004f6e4f7224ULL, 0x000fe200078e02ffULL, 0x0000000e11497217ULL, 0x040fe40003800000ULL,
0x000000ff0a0a7207ULL, 0x000fe40000800000ULL, 0x000000ff08387207ULL, 0x000fe20000000000ULL,
0x000000496e497224ULL, 0x000fe200078e02ffULL, 0x0000004011407217ULL, 0x000fe20003800000ULL,
0x000000014f0f7824ULL, 0x000fe200078e020aULL, 0x0000004f380b7211ULL, 0x000fe200078fe0ffULL,
0x000000010a097824ULL, 0x000fe200078e0249ULL, 0x00000020353d7812ULL, 0x000fe200078efcffULL,
0x000000020f0e7825ULL, 0x000fe200078e004cULL, 0x000000373c00720cULL, 0x000fc40003f26070ULL,
0x00000004ff407819ULL, 0x000fe20000011640ULL, 0x000000020b0a7825ULL, 0x000fe200078e004cULL,
0x0000004938037211ULL, 0x000fe200078fe0ffULL, 0x000000060e347981ULL, 0x0048a2000c1e9500ULL,
0x000000ff40407207ULL, 0x000fe20000800000ULL, 0x0000000110467824ULL, 0x000fe400078e023dULL,
0x00000001363e7824ULL, 0x000fe200078e024eULL, 0x000000060a397981ULL, 0x0002a2000c1e9500ULL,
0x0000000203027825ULL, 0x000fc800078e004cULL, 0x0000000146447824ULL, 0x100fe200078e0a37ULL,
0x00000006023b7981ULL, 0x0006a2000c1e9500ULL, 0x000000013e3c7824ULL, 0x000fe400078e0a37ULL,
0x0000000209087825ULL, 0x000fe200078e004cULL, 0x0000004411437217ULL, 0x000fc60003800000ULL,
0x000000014f0b7824ULL, 0x002fe200078e0240ULL, 0x000000373e00720cULL, 0x000fe20003f06070ULL,
0x00000006083a7981ULL, 0x0002a4000c1e9500ULL, 0x000000020b027825ULL, 0x008fe200078e004cULL,
0x0000003c113c7217ULL, 0x000fc60003800000ULL, 0x00000001400b7824ULL, 0x000fe200078e0249ULL,
0x000000374600720cULL, 0x000fe20003f26070ULL, 0x000000013d407824ULL, 0x000fe200078e024eULL,
0x00000004ff437819ULL, 0x000fe20000011643ULL, 0x00000006023f7981ULL, 0x0006a2000c1e9500ULL,
0x000000ff3c3c7207ULL, 0x000fe40000000000ULL, 0x000000ff43467207ULL, 0x000fe40000800000ULL,
0x0000003035437812ULL, 0x000fe200078efcffULL, 0x0000000140027824ULL, 0x008fe200078e0a37ULL,
0x0000004f3c097211ULL, 0x002fc400078fe0ffULL, 0x000000493c0f7211ULL, 0x010fe200078fe0ffULL,
0x000000014f037824ULL, 0x000fe200078e0246ULL, 0x000000374000720cULL, 0x000fe40003f06070ULL,
0x0000000211027217ULL, 0x000fe20003800000ULL, 0x0000000110507824ULL, 0x000fe400078e0243ULL,
0x0000000209087825ULL, 0x000fe200078e004cULL, 0x000000ff024b7207ULL, 0x000fc60000000000ULL,
0x000000020b0a7825ULL, 0x100fe200078e004cULL, 0x0000000608427981ULL, 0x0002e6000c1e9500ULL,
0x000000020f0e7825ULL, 0x100fe200078e004cULL, 0x000000060a417981ULL, 0x0008e6000c1e9500ULL,
0x0000000203027825ULL, 0x000fe200078e004cULL, 0x000000060e447981ULL, 0x0008e6000c1e9500ULL,
0x00000001504a7824ULL, 0x000fe200078e0a37ULL, 0x0000000602457981ULL, 0x0008e2000c1e9500ULL,
0x0000000143487824ULL, 0x000fe200078e024eULL, 0x0000004f4b097211ULL, 0x002fc400078fe0ffULL,
0x0000004a11517217ULL, 0x000fe20003800000ULL, 0x00000001460b7824ULL, 0x010fe200078e0249ULL,
0x000000494b0f7211ULL, 0x000fe200078fe0ffULL, 0x0000000148027824ULL, 0x000fe200078e0a37ULL,
0x000000375000720cULL, 0x080fe40003f26070ULL, 0x00000004ff517819ULL, 0x000fe20000011651ULL,
0x0000000209087825ULL, 0x100fe200078e004cULL, 0x000000374800720cULL, 0x000fe40003f06070ULL,
0x0000000211027217ULL, 0x000fe20003800000ULL, 0x000000020b0a7825ULL, 0x100fe200078e004cULL,
0x000000ff51507207ULL, 0x000fe20000800000ULL, 0x0000000608467981ULL, 0x000324000c1e9500ULL,
0x000000020f0e7825ULL, 0x000fe200078e004cULL, 0x000000ff02517207ULL, 0x000fe20000000000ULL,
0x000000060a477981ULL, 0x000328000c1e9500ULL, 0x000000060e4a7981ULL, 0x000322000c1e9500ULL,
0x000000014f037824ULL, 0x000fe200078e0250ULL, 0x0000004f51097211ULL, 0x002fc600078fe0ffULL,
0x0000000203027825ULL, 0x000fc800078e004cULL, 0x0000000209087825ULL, 0x000fe400078e004cULL,
0x0000000602027981ULL, 0x000322000c1e9500ULL, 0x00000049510b7211ULL, 0x000fc600078fe0ffULL,
0x0000000608097981ULL, 0x000322000c1e9500ULL, 0x00000001500f7824ULL, 0x000fe400078e0249ULL,
0x000000020b0a7825ULL, 0x000fc800078e004cULL, 0x000000020f0e7825ULL, 0x000fe400078e004cULL,
0x000000060a0a7981ULL, 0x000328000c1e9500ULL, 0x000000060e0f7981ULL, 0x000322000c1e9500ULL,
0x0000000135507812ULL, 0x040fe400078efcffULL, 0xfffffff0380b7812ULL, 0x002fe400078ec0ffULL,
0x0000000835527812ULL, 0x000fc400078efcffULL, 0x0000000935547812ULL, 0x000fe200078efcffULL,
0x00000001370b7824ULL, 0x000fe200078e020bULL, 0xfffffff03c537812ULL, 0x000fe200078ec0ffULL,
0x00000001ff497424ULL, 0x000fe400078e00ffULL, 0x0000000150687824ULL, 0x100fe400078e024eULL,
0x00000001526a7824ULL, 0x100fe400078e024eULL, 0x0000000154747824ULL, 0x000fe400078e024eULL,
0x00000001123c7824ULL, 0x100fe200078e0a0bULL, 0xfffffff04b557812ULL, 0x000fe200078ec0ffULL,
0x00000001684b7824ULL, 0x100fe200078e0a0bULL, 0xfffffff0515d7812ULL, 0x000fe200078ec0ffULL,
0x000000016a4f7824ULL, 0x000fc400078e0a0bULL, 0x0000000174517824ULL, 0x000fe200078e0a0bULL,
0x0000003c490b7219ULL, 0x040fe400000006ffULL, 0x0000004b493c7219ULL, 0x000fe400000006ffULL,
0x0000001835587812ULL, 0x000fe400078efcffULL, 0x0000004f494b7219ULL, 0x040fe400000006ffULL,
0x00000051494f7219ULL, 0x000fe200000006ffULL, 0x0000000158787824ULL, 0x000fc400078e024eULL,
0x0000000137537824ULL, 0x000fc800078e0253ULL, 0x000000013e5f7824ULL, 0x100fe400078e0a53ULL,
0x0000000178637824ULL, 0x000fe200078e0a53ULL, 0x0000001135567812ULL, 0x040fe400078efcffULL,
0x0000001935087812ULL, 0x000fe400078efcffULL, 0x0000005f495f7219ULL, 0x040fe400000006ffULL,
0x0000006349637219ULL, 0x000fe200000006ffULL, 0x0000000156767824ULL, 0x000fc400078e024eULL,
0x00000001087a7824ULL, 0x000fe400078e024eULL, 0x0000000137557824ULL, 0x000fe400078e0255ULL,
0x0000000176617824ULL, 0x100fe400078e0a53ULL, 0x000000017a657824ULL, 0x000fe400078e0a53ULL,
0x0000000140677824ULL, 0x000fe200078e0a55ULL, 0x00000021355a7812ULL, 0x040fe400078efcffULL,
0x00000028355c7812ULL, 0x000fc400078efcffULL, 0x00000029355e7812ULL, 0x000fe400078efcffULL,
0x0000006149617219ULL, 0x040fe400000006ffULL, 0x0000006549657219ULL, 0x040fe400000006ffULL,
0x0000006749677219ULL, 0x000fe200000006ffULL, 0x000000015a037824ULL, 0x100fe400078e024eULL,
0x000000015c7c7824ULL, 0x100fe400078e024eULL, 0x000000015e387824ULL, 0x000fc400078e024eULL,
0x00000001375d7824ULL, 0x000fe400078e025dULL, 0x0000000103757824ULL, 0x100fe400078e0a55ULL,
0x000000017c6b7824ULL, 0x100fe400078e0a55ULL, 0x0000000138697824ULL, 0x000fe400078e0a55ULL,
0x00000001485b7824ULL, 0x000fe200078e0a5dULL, 0x00000031350e7812ULL, 0x040fe400078efcffULL,
0x0000003835647812ULL, 0x000fc400078efcffULL, 0x0000003935667812ULL, 0x000fe400078efcffULL,
0x0000007549757219ULL, 0x040fe400000006ffULL, 0x0000006b496b7219ULL, 0x040fe400000006ffULL,
0x0000006949697219ULL, 0x040fe400000006ffULL, 0x0000005b495b7219ULL, 0x000fe200000006ffULL,
0x000000010e517824ULL, 0x100fe400078e024eULL, 0x0000000164537824ULL, 0x000fc400078e024eULL,
0x0000000166557824ULL, 0x000fe400078e024eULL, 0x0000000151577824ULL, 0x100fe400078e0a5dULL,
0x0000000153597824ULL, 0x100fe400078e0a5dULL, 0x00000001555d7824ULL, 0x000fe200078e0a5dULL,
0x0000005749577219ULL, 0x040fe400000006ffULL, 0x0000005949597219ULL, 0x000fe400000006ffULL,
0x0000541039347816ULL, 0x004fc80000000034ULL, 0x000000340bff7212ULL, 0x000fc8000780c0ffULL,
0x000000371200720cULL, 0x000fc800007a1470ULL, 0x000000373500720cULL, 0x000fe40002fa1070ULL,
0x000054103b3a7816ULL, 0x000fe4000000003aULL, 0xff8000002f2f7808ULL, 0x000fe40002800000ULL,
0x0000003a0bff7212ULL, 0x080fe4000784c0ffULL, 0x0000003a4bff7212ULL, 0x080fe400078cc0ffULL,
0x0000003a4fff7212ULL, 0x000fc400078ac0ffULL, 0x000000371200720cULL, 0x080fe40001741470ULL,
0x000000376a00720cULL, 0x080fe400037c1470ULL, 0x000000377400720cULL, 0x080fe40002fa1470ULL,
0x000000373500720cULL, 0x080fe40001741070ULL, 0x000000375200720cULL, 0x080fe400037c1070ULL,
0x000000375400720cULL, 0x000fc40002fa1070ULL, 0xff80000030307808ULL, 0x000fe40001000000ULL,
0xff8000002b2b7808ULL, 0x000fe40003000000ULL, 0xff80000029297808ULL, 0x000fe40002800000ULL,
0x000000343cff7212ULL, 0x080fe4000782c0ffULL, 0x000000344bff7212ULL, 0x000fe4000786c0ffULL,
0x0000541042427816ULL, 0x008fc4000000003fULL, 0x000000344fff7212ULL, 0x000fe4000788c0ffULL,
0x0000003a3cff7212ULL, 0x000fe4000780c0ffULL, 0x0000541044447816ULL, 0x000fe40000000041ULL,
0x000000425fff7212ULL, 0x040fe4000784c0ffULL, 0x000000445fff7212ULL, 0x080fe400078cc0ffULL,
0x0000004463ff7212ULL, 0x000fc400078ac0ffULL, 0x000000376800720cULL, 0x0c0fe40000f21470ULL,
0x000000376800720cULL, 0x080fe40000701470ULL, 0x000000376a00720cULL, 0x080fe40001f61470ULL,
0x000000377400720cULL, 0x080fe40002781470ULL, 0x000000373e00720cULL, 0x0c0fe40001741470ULL,
0x000000373e00720cULL, 0x000fc400037c1470ULL, 0x000000377800720cULL, 0x080fe40002fa1470ULL,
0x000000375000720cULL, 0x0c0fe40000f21070ULL, 0x000000375000720cULL, 0x080fe40000701070ULL,
0x000000375200720cULL, 0x080fe40001f61070ULL, 0x000000375400720cULL, 0x080fe40002781070ULL,
0x000000373600720cULL, 0x000fc40001741070ULL, 0x000000373600720cULL, 0x080fe400037c1070ULL,
0x000000375800720cULL, 0x000fe40002fa1070ULL, 0x0000541046467816ULL, 0x010fe40000000045ULL,
0x000054104a4a7816ULL, 0x000fe40000000047ULL, 0xff8000002e2e7808ULL, 0x000fe40000800000ULL,
0xff8000002d2d7808ULL, 0x000fc40000000000ULL, 0xff8000002c2c7808ULL, 0x000fe40001800000ULL,
0xff8000002a2a7808ULL, 0x000fe40002000000ULL, 0xff80000028287808ULL, 0x000fe40001000000ULL,
0xff80000027277808ULL, 0x000fe40003000000ULL, 0xff80000023237808ULL, 0x000fe40002800000ULL,
0x0000004261ff7212ULL, 0x000fc4000782c0ffULL, 0x0000004263ff7212ULL, 0x080fe4000780c0ffULL,
0x0000004265ff7212ULL, 0x000fe4000786c0ffULL, 0x0000004461ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004465ff7212ULL, 0x000fe4000784c0ffULL, 0x0000004667ff7212ULL, 0x040fe400078cc0ffULL,
0x0000004a67ff7212ULL, 0x000fc400078ac0ffULL, 0x000000377600720cULL, 0x0c0fe40000f21470ULL,
0x000000377600720cULL, 0x080fe40002781470ULL, 0x000000377800720cULL, 0x080fe40000701470ULL,
0x000000377a00720cULL, 0x0c0fe40001f61470ULL, 0x000000377a00720cULL, 0x080fe40001741470ULL,
0x000000374000720cULL, 0x000fc400037c1470ULL, 0x000000374000720cULL, 0x080fe40002fa1470ULL,
0x000000375600720cULL, 0x0c0fe40000f21070ULL, 0x000000375600720cULL, 0x080fe40002781070ULL,
0x000000375800720cULL, 0x080fe40000701070ULL, 0x000000370800720cULL, 0x0c0fe40001f61070ULL,
0x000000370800720cULL, 0x000fc40001741070ULL, 0x000000373d00720cULL, 0x0c0fe400037c1070ULL,
0x000000373d00720cULL, 0x000fe40002fa1070ULL, 0x0000541009027816ULL, 0x000fe40000000002ULL,
0xff80000026267808ULL, 0x000fe40000800000ULL, 0xff80000025257808ULL, 0x000fe40002000000ULL,
0xff80000024247808ULL, 0x000fc40000000000ULL, 0xff80000022227808ULL, 0x000fe40001800000ULL,
0xff80000021217808ULL, 0x000fe40001000000ULL, 0xff80000020207808ULL, 0x000fe40003000000ULL,
0xff8000001f1f7808ULL, 0x000fe40002800000ULL, 0x0000004675ff7212ULL, 0x080fe4000782c0ffULL,
0x000000466bff7212ULL, 0x000fc4000788c0ffULL, 0x0000004669ff7212ULL, 0x000fe4000780c0ffULL,
0x0000004a75ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004a6bff7212ULL, 0x080fe4000784c0ffULL,
0x0000004a69ff7212ULL, 0x000fe400078cc0ffULL, 0x000000025bff7212ULL, 0x000fe400078ac0ffULL,
0x000000370300720cULL, 0x000fc40000f21470ULL, 0x000000370300720cULL, 0x080fe40001f61470ULL,
0x000000377c00720cULL, 0x0c0fe40002781470ULL, 0x000000377c00720cULL, 0x080fe40001741470ULL,
0x000000373800720cULL, 0x0c0fe40000701470ULL, 0x000000373800720cULL, 0x080fe400037c1470ULL,
0x000000374800720cULL, 0x000fc40002fa1470ULL, 0x000000375a00720cULL, 0x0c0fe40000f21070ULL,
0x000000375a00720cULL, 0x080fe40001f61070ULL, 0x000000375c00720cULL, 0x0c0fe40002781070ULL,
0x000000375c00720cULL, 0x080fe40001741070ULL, 0x000000375e00720cULL, 0x0c0fe40000701070ULL,
0x000000375e00720cULL, 0x000fc400037c1070ULL, 0x000000374300720cULL, 0x000fe40002fa1070ULL,
0x0000005d495d7219ULL, 0x000fe400000006ffULL, 0x000054100a0a7816ULL, 0x000fe4000000000fULL,
0xff8000001e1e7808ULL, 0x000fe40000800000ULL, 0xff8000000d0d7808ULL, 0x000fe40001800000ULL,
0xff8000001d1d7808ULL, 0x000fc40002000000ULL, 0xff80000014147808ULL, 0x000fe40001000000ULL,
0xff8000001c1c7808ULL, 0x000fe40000000000ULL, 0xff8000001a1a7808ULL, 0x000fe40003000000ULL,
0xff8000001b1b7808ULL, 0x000fe40002800000ULL, 0x0000000257ff7212ULL, 0x080fe4000782c0ffULL,
0x0000000259ff7212ULL, 0x000fc4000786c0ffULL, 0x000000025dff7212ULL, 0x000fe4000788c0ffULL,
0x0000000a5bff7212ULL, 0x080fe4000784c0ffULL, 0x0000000a57ff7212ULL, 0x080fe4000780c0ffULL,
0x0000000a59ff7212ULL, 0x080fe400078cc0ffULL, 0x0000000a5dff7212ULL, 0x000fe400078ac0ffULL,
0x000000374800720cULL, 0x000fc40001741470ULL, 0x000000375100720cULL, 0x0c0fe40000f21470ULL,
0x000000375100720cULL, 0x080fe40000701470ULL, 0x000000375300720cULL, 0x0c0fe40001f61470ULL,
0x000000375300720cULL, 0x080fe400037c1470ULL, 0x000000375500720cULL, 0x0c0fe40002781470ULL,
0x000000375500720cULL, 0x000fc40002fa1470ULL, 0x000000374300720cULL, 0x080fe40001741070ULL,
0x000000370e00720cULL, 0x0c0fe40000f21070ULL, 0x000000370e00720cULL, 0x080fe40000701070ULL,
0x000000376400720cULL, 0x0c0fe40001f61070ULL, 0x000000376400720cULL, 0x080fe400037c1070ULL,
0x000000376600720cULL, 0x000fc40002781070ULL, 0x000000376600720cULL, 0x000fe40002fa1070ULL,
0xff80000033337808ULL, 0x000fe40000800000ULL, 0xff80000031317808ULL, 0x000fe40001800000ULL,
0xff80000032327808ULL, 0x000fe40002000000ULL, 0xff80000015157808ULL, 0x000fe40001000000ULL,
0xff80000016167808ULL, 0x000fc40000000000ULL, 0xff80000017177808ULL, 0x000fe40003000000ULL,
0xff80000018187808ULL, 0x000fc40002800000ULL, 0x0000002f0400720bULL, 0x008fe20003f1e000ULL,
0x0000001fff0f7424ULL, 0x000fe200078e00ffULL, 0x000000300500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff347424ULL, 0x000fe200078e00ffULL, 0x000000042f037208ULL, 0x000fe40004000000ULL,
0x0000000530027208ULL, 0x000fe40004800000ULL, 0x0000002e0300720bULL, 0x000fc40003f1e000ULL,
0x0000002d0200720bULL, 0x000fe40003f3e000ULL, 0x000000032e037208ULL, 0x000fe40004000000ULL,
0x000000022d027208ULL, 0x000fe40004800000ULL, 0x0000002c0300720bULL, 0x000fe40003f1e000ULL,
0x0000002b0200720bULL, 0x000fe40003f3e000ULL, 0x000000032c037208ULL, 0x000fc40004000000ULL,
0x000000022b027208ULL, 0x000fe40004800000ULL, 0x0000002a0300720bULL, 0x000fe40003f1e000ULL,
0x000000290200720bULL, 0x000fe40003f3e000ULL, 0x000000032a037208ULL, 0x000fe40004000000ULL,
0x0000000229027208ULL, 0x000fe40004800000ULL, 0x000000280300720bULL, 0x000fc40003f1e000ULL,
0x000000270200720bULL, 0x000fe40003f3e000ULL, 0x0000000328037208ULL, 0x000fe40004000000ULL,
0x0000000227027208ULL, 0x000fe40004800000ULL, 0x000000260300720bULL, 0x000fe40003f1e000ULL,
0x000000250200720bULL, 0x000fe40003f3e000ULL, 0x0000000326037208ULL, 0x000fc40004000000ULL,
0x0000000225027208ULL, 0x000fe40004800000ULL, 0x000000240300720bULL, 0x000fe40003f1e000ULL,
0x000000230200720bULL, 0x000fe40003f3e000ULL, 0x0000000324037208ULL, 0x000fe40004000000ULL,
0x0000000223027208ULL, 0x000fe40004800000ULL, 0x000000220300720bULL, 0x000fc40003f1e000ULL,
0x000000210200720bULL, 0x000fe40003f3e000ULL, 0x0000000322037208ULL, 0x000fe40004000000ULL,
0x0000000221027208ULL, 0x000fe40004800000ULL, 0x000000200300720bULL, 0x000fe40003f1e000ULL,
0x0000001f0200720bULL, 0x000fe40003f3e000ULL, 0x0000000320037208ULL, 0x000fc40004000000ULL,
0x000000021f027208ULL, 0x000fe40004800000ULL, 0x0000001e0300720bULL, 0x000fe40003f1e000ULL,
0x0000000d0200720bULL, 0x000fe40003f3e000ULL, 0x000000031e047208ULL, 0x000fe40004000000ULL,
0x000000020d037208ULL, 0x000fe40004800000ULL, 0x0000001d0400720bULL, 0x000fc40003f1e000ULL,
0x000000140300720bULL, 0x000fe40003f3e000ULL, 0x000000041d057208ULL, 0x000fe40004000000ULL,
0x0000000314037208ULL, 0x000fe40004800000ULL, 0x0000001c0500720bULL, 0x000fe40003f1e000ULL,
0x0000001a0300720bULL, 0x000fe40003f3e000ULL, 0x000000051c027208ULL, 0x000fc40004000000ULL,
0x000000031a047208ULL, 0x000fe40004800000ULL, 0x0000001b0200720bULL, 0x000fe40003f1e000ULL,
0x000000150400720bULL, 0x000fe40003f3e000ULL, 0x000000021b027208ULL, 0x000fe40004000000ULL,
0x0000000415037208ULL, 0x000fe40004800000ULL, 0x000000330200720bULL, 0x000fc40003f1e000ULL,
0x000000160300720bULL, 0x000fe40003f3e000ULL, 0x0000000233027208ULL, 0x000fe40004000000ULL,
0x0000000316047208ULL, 0x000fe40004800000ULL, 0x000000310200720bULL, 0x000fe40003f1e000ULL,
0x000000170400720bULL, 0x000fe40003f3e000ULL, 0x0000000231037208ULL, 0x000fc40004000000ULL,
0x0000000417057208ULL, 0x000fe40004800000ULL, 0x000000320300720bULL, 0x000fe40003f1e000ULL,
0x000000180500720bULL, 0x000fe40003f3e000ULL, 0x00000003320a7208ULL, 0x000fe40004000000ULL,
0x00000005180e7208ULL, 0x000fe20004800000ULL, 0x000014227f007947ULL, 0x000fec000b800000ULL,
0x0c401f000a027f89ULL, 0x00066400000e0000ULL, 0x000000020a00720bULL, 0x002fc80003f1e000ULL,
0x0000000a02127208ULL, 0x000fe20004000000ULL, 0x000014327f007947ULL, 0x000fea000b800000ULL,
0x0c401f000e027f89ULL, 0x000e6800000e0000ULL, 0x0c401f0006037f89ULL, 0x000f2800000e0000ULL,
0x0c401f0007047f89ULL, 0x000ea800000e0000ULL, 0x0c201f0012057f89ULL, 0x000ee200000e0000ULL,
0x000000020e00720bULL, 0x002fc40003f1e000ULL, 0x000000030600720bULL, 0x010fe40003f3e000ULL,
0x0000000e02087208ULL, 0x000fe40004000000ULL, 0x0000000603097208ULL, 0x000fe40004800000ULL,
0x000000040700720bULL, 0x004fe20003f1e000ULL, 0x0c201f00080b7f89ULL, 0x000e6600000e0000ULL,
0x0000000704027208ULL, 0x000fe20004000000ULL, 0x0c201f00090a7f89ULL, 0x008ea200000e0000ULL,
0x000000051200720bULL, 0x000fc60003f1e000ULL, 0x0c201f0002037f89ULL, 0x0006e200000e0000ULL,
0x0000001205047208ULL, 0x000fe40004000000ULL, 0x0000000b0800720bULL, 0x002fe40003f3e000ULL,
0x0000000a0900720bULL, 0x004fe40003f5e000ULL, 0x000000080b057208ULL, 0x000fe40004800000ULL,
0x000000090a067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04097820ULL, 0x008fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000036cff7812ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010809ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010809ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010809ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010809ULL,
0x0000002a000f7308ULL, 0x0023e20000000800ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010809ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010809ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010809ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010809ULL, 0x3fb8aa3b20127823ULL, 0x100fe20000010809ULL,
0x3fb8aa3b1c357823ULL, 0x100fe20000010809ULL, 0x3fb8aa3b33077823ULL, 0x000fe20000010809ULL,
0x0000002400367308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b052a7820ULL, 0x002fe20000410000ULL,
0x000000030200720bULL, 0x004fc60003f3e000ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001082aULL, 0x0000002f00087308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b1b247823ULL, 0x108fe20000010809ULL, 0x3fb8aa3b321b7823ULL, 0x100fe20000010809ULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082aULL, 0x0000002800347308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b1e2f7823ULL, 0x002fe20000010809ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b15157823ULL, 0x000fc6000001082aULL, 0x0000002600377308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b1d287823ULL, 0x004fce0000010809ULL, 0x0000002e000b7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b31267823ULL, 0x002fce0000010809ULL, 0x0000002c000a7308ULL, 0x000e700000000800ULL,
0x0000003000097308ULL, 0x000fe20000000800ULL, 0x000000080b08723eULL, 0x004fce00000000ffULL,
0x0000002d000e7308ULL, 0x000ea20000000800ULL, 0x0000000a0f0a723eULL, 0x002fe200000000ffULL,
0x3c003c00ff0f7424ULL, 0x000fcc00078e00ffULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x00000029001c7308ULL, 0x0002e20000000800ULL, 0x000000090e09723eULL, 0x004fe200000000ffULL,
0x3c003c00ff0e7424ULL, 0x000fcc00078e00ffULL, 0x0000002200397308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b16297823ULL, 0x002fe2000001082aULL, 0x0000002b1c0b723eULL, 0x008fcc00000000ffULL,
0x00000023002e7308ULL, 0x000fe20000000800ULL, 0x00000034371c723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b172b7823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b182a7823ULL, 0x000fe2000001082aULL,
0x00000036391e723eULL, 0x004fc800000000ffULL, 0x00000021002d7308ULL, 0x0003f00000000800ULL,
0x00000027001d7308ULL, 0x000fe20000000800ULL, 0x0000000e0820723cULL, 0x002f6e00000018ffULL,
0x00000025002c7308ULL, 0x000e700000000800ULL, 0x0000001f00277308ULL, 0x0005e20000000800ULL,
0x0000001d2c1d723eULL, 0x002fce00000000ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x0000002e2d1f723eULL, 0x004fe400000000ffULL, 0x00000002ff2c7819ULL, 0x000fc8000001166cULL,
0x000000022c167810ULL, 0x040fe20007ffe0ffULL, 0x0000000e1c20723cULL, 0x020f620000001820ULL,
0x0000002f002f7308ULL, 0x000fe20000000800ULL, 0x000000082c317824ULL, 0x040fe200078e00ffULL,
0x000000032c177810ULL, 0x040fe20007ffe0ffULL, 0x000000082c337824ULL, 0x040fe200078e00ffULL,
0x000000042c2d7810ULL, 0x040fe20007ffe0ffULL, 0x000000082c347824ULL, 0x040fe400078e00ffULL,
0x000000082c367824ULL, 0x040fe200078e00ffULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0xfffffff833327812ULL, 0x000fe200078ee216ULL, 0x000000082c387824ULL, 0x000fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fc400078ee217ULL, 0xfffffff836367812ULL, 0x000fe200078ee22dULL,
0x000000082c2d7824ULL, 0x000fe400078e00ffULL, 0x0000003500357308ULL, 0x000e700000000800ULL,
0x0000000d00307308ULL, 0x000ff00000000800ULL, 0x0000001400257308ULL, 0x0005e20000000800ULL,
0x000000283516723eULL, 0x002fce00000000ffULL, 0x0000001a001a7308ULL, 0x000e620000000800ULL,
0x000000012c147810ULL, 0x004fc80007ffe0ffULL, 0xfffffff8312e7812ULL, 0x000fe400078ee214ULL,
0x000000122f14723eULL, 0x000fe200000000ffULL, 0x00000015000d7308ULL, 0x0005e20000000800ULL,
0x000000082c2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d127812ULL, 0x000fe400078ee22cULL,
0x000000251a17723eULL, 0x002fc800000000ffULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x000000273015723eULL, 0x004fe200000000ffULL, 0x000000082c307824ULL, 0x040fe200078e00ffULL,
0x000000062c257810ULL, 0x040fe40007ffe0ffULL, 0xffffffff2c277810ULL, 0x040fe40007ffe0ffULL,
0x000000052c1a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000e1420723cULL, 0x020f620000001820ULL,
0x0000000700077308ULL, 0x000e640000000800ULL, 0xfffffff82f287812ULL, 0x000fcc00078ee21aULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000001b001b7308ULL, 0x000ea20000000800ULL,
0x000000240724723eULL, 0x002fe400000000ffULL, 0x0000900013077811ULL, 0x000fca00078e58ffULL,
0x0000002900187308ULL, 0x0002e20000000800ULL, 0x00000010361a7824ULL, 0x000fce00078e0207ULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x000000082c297810ULL, 0x002fe40007ffe0ffULL,
0xfffffff8302c7812ULL, 0x000fe400078ee225ULL, 0xfffffff838307812ULL, 0x000fe200078ee227ULL,
0x00000008293a7824ULL, 0x000fe200078e00ffULL, 0x000000261b26723eULL, 0x004fe200000000ffULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0x0000000d1825723eULL, 0x008fe200000000ffULL,
0x00000010120d7824ULL, 0x000fe200078e0207ULL, 0xfffffff83a387812ULL, 0x000fe200078ee229ULL,
0x000000102e127824ULL, 0x000fc400078e0207ULL, 0x0000001032187824ULL, 0x100fe400078e0207ULL,
0x00000010281b7824ULL, 0x100fe400078e0207ULL, 0x000000102c287824ULL, 0x100fe400078e0207ULL,
0x0000001030297824ULL, 0x100fe200078e0207ULL, 0x0000002b2a27723eULL, 0x002fe400000000ffULL,
0x0000000c192a7812ULL, 0x000fe200078ec0ffULL, 0x0000001034197824ULL, 0x000fc400078e0207ULL,
0x0000001038077824ULL, 0x000fe400078e0207ULL, 0x0000000e2420723cULL, 0x020b620000001820ULL,
0x000000012a0d7824ULL, 0x040fe400078e020dULL, 0x000000012a127824ULL, 0x040fe400078e0212ULL,
0x000000012a187824ULL, 0x040fe200078e0218ULL, 0x000000080d007388ULL, 0x0003e20000000800ULL,
0x000000012a197824ULL, 0x040fe400078e0219ULL, 0x000000012a1a7824ULL, 0x040fe200078e021aULL,
0x0000000a12007388ULL, 0x0003e20000000800ULL, 0x000000012a1b7824ULL, 0x000fc400078e021bULL,
0x000000012a287824ULL, 0x040fe200078e0228ULL, 0x0000001c18007388ULL, 0x0003e20000000800ULL,
0x000000012a297824ULL, 0x040fe400078e0229ULL, 0x000000012a0e7824ULL, 0x020fe200078e0207ULL,
0x0000001e19007388ULL, 0x0003e20000000800ULL, 0x0000000203077208ULL, 0x000fc60004800000ULL,
0x000000141a007388ULL, 0x0003e40000000800ULL, 0x000000ffff217224ULL, 0x000fe400078e0022ULL,
0x000000161b007388ULL, 0x0003e80000000800ULL, 0x0000002428007388ULL, 0x0003e80000000800ULL,
0x0000002629007388ULL, 0x0003e80000000800ULL, 0x000000090e007388ULL, 0x0003e80000000800ULL,
0x0004000b12007388ULL, 0x0003e80000000800ULL, 0x0004001d18007388ULL, 0x0003e80000000800ULL,
0x0004001f19007388ULL, 0x0003e80000000800ULL, 0x000400151a007388ULL, 0x0003e80000000800ULL,
0x000400171b007388ULL, 0x0003e80000000800ULL, 0x0004002528007388ULL, 0x0003e80000000800ULL,
0x0004002729007388ULL, 0x0003e80000000800ULL, 0x0130000400008388ULL, 0x0003e80000000c00ULL,
0x0132002000008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136080072ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136100072ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136180072ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000620c00720cULL, 0x000fe20003f06070ULL, 0x0136200072ff7f8cULL, 0x0003e4000c80043fULL,
0x000000ffff127224ULL, 0x002fd400078e000cULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff9cb000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff107807ULL, 0x004fe40004000000ULL, 0x0001335000307802ULL, 0x000fc40000000f00ULL,
0x00000bb000007944ULL, 0x008fea0003c00000ULL, 0xfffef78000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe40005000000ULL, 0x0001339000307802ULL, 0x000fc40000000f00ULL,
0x00000b7000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff027224ULL, 0x000fe200078e0010ULL,
0xfffef7f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0011ULL,
0x000133e000317802ULL, 0x000fc40000000f00ULL, 0x00000ad000007944ULL, 0x008fea0003c00000ULL,
0xfffef8d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0011ULL,
0x0001342000317802ULL, 0x000fc40000000f00ULL, 0x00000a9000007944ULL, 0x00afea0003c00000ULL,
0xfffef9f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0002ULL,
0x0001347000317802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fc400078e0003ULL,
0x00000a4000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0010ULL,
0xfffefba000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0002ULL,
0x000134c000317802ULL, 0x000fc40000000f00ULL, 0x000009f000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0010ULL, 0xfffefb8000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x00afe40004000000ULL, 0x0001351000307802ULL, 0x000fc40000000f00ULL,
0x000009f000007944ULL, 0x000fea0003c00000ULL, 0xffff10f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe40004800000ULL, 0x0001355000307802ULL, 0x000fc40000000f00ULL,
0x000009b000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0010ULL,
0xffff113000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0035ULL,
0x000135a000317802ULL, 0x000fc40000000f00ULL, 0x0000091000007944ULL, 0x000fea0003c00000ULL,
0xffff122000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0035ULL,
0x000135e000317802ULL, 0x000fc40000000f00ULL, 0x000008d000007944ULL, 0x002fea0003c00000ULL,
0xffff134000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0006ULL,
0x0001363000317802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fc400078e0033ULL,
0x0000088000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0010ULL,
0xffff14f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0006ULL,
0x0001368000317802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0010ULL, 0xffff14d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x004fe40004000000ULL, 0x000136d000307802ULL, 0x000fc40000000f00ULL,
0x0000083000007944ULL, 0x008fea0003c00000ULL, 0xffff285000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe40004800000ULL, 0x0001371000307802ULL, 0x000fc40000000f00ULL,
0x000007f000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff097224ULL, 0x000fe200078e0010ULL,
0xffff289000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0036ULL,
0x0001376000317802ULL, 0x000fc40000000f00ULL, 0x0000075000007944ULL, 0x008fea0003c00000ULL,
0xffff298000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0036ULL,
0x000137a000317802ULL, 0x000fc40000000f00ULL, 0x0000071000007944ULL, 0x00afea0003c00000ULL,
0xffff2aa000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0009ULL,
0x000137f000317802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fc400078e0032ULL,
0x000006c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0010ULL,
0xffff2c5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0009ULL,
0x0001384000317802ULL, 0x000fc40000000f00ULL, 0x0000067000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0010ULL, 0xffff2c3000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x004fe40004000000ULL, 0x0001389000307802ULL, 0x000fc40000000f00ULL,
0x0000067000007944ULL, 0x008fea0003c00000ULL, 0xffff405000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe40004800000ULL, 0x000138d000307802ULL, 0x000fc40000000f00ULL,
0x0000063000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff097224ULL, 0x000fe200078e0010ULL,
0xffff40a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0032ULL,
0x0001392000317802ULL, 0x000fc40000000f00ULL, 0x0000059000007944ULL, 0x008fea0003c00000ULL,
0xffff419000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0032ULL,
0x0001396000317802ULL, 0x000fc40000000f00ULL, 0x0000055000007944ULL, 0x00afea0003c00000ULL,
0xffff42b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0008ULL,
0x000139b000317802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fc400078e0009ULL,
0x0000050000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0010ULL,
0xffff446000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x000fe200078e0008ULL,
0x00013a0000317802ULL, 0x000fc40000000f00ULL, 0x000004b000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0010ULL, 0xffff444000007947ULL, 0x000fea000383ffffULL,
0x00000002ff0b7424ULL, 0x000fe200078e00ffULL, 0x00013a5000087802ULL, 0x000fc40000000f00ULL,
0x0000042000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e0003ULL,
0xffffeba000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0a7224ULL, 0x008fe200078e000eULL,
0x00013ab000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0b7424ULL, 0x000fc400078e00ffULL,
0x000003c000007944ULL, 0x004fea0003c00000ULL, 0x000000030e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0006ULL, 0x00013b1000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000e030e7208ULL, 0x000fc80004000000ULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0x000000030600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0007ULL, 0x00013b7000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000603067208ULL, 0x000fc80004000000ULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0x000000030700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0012ULL, 0x00013bd000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000703027208ULL, 0x000fc80004000000ULL,
0x000002a000007944ULL, 0x000fea0003c00000ULL, 0x000000031200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e000eULL, 0x00013c3000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000001203047208ULL, 0x000fc80004000000ULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x000000030e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0006ULL, 0x00013c9000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000e03057208ULL, 0x000fc80004000000ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0x000000030600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0002ULL, 0x00013cf000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000603067208ULL, 0x000fc80004000000ULL,
0x0000018000007944ULL, 0x000fea0003c00000ULL, 0xffffea7000007947ULL, 0x000fea000383ffffULL,
0x018000000b037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000000b00038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff047807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000304ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0bff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000304ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000b047812ULL, 0x000fd600078ec0ffULL,
0x0080000004030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0004ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000b00037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffec19006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003400007348ULL, 0x000fe80003800000ULL, 0x0c00000b0a037389ULL, 0x0002a200000e000fULL,
0xfffec15008007950ULL, 0x000fea0003c3ffffULL, 0x0000007200007348ULL, 0x000fe80003800000ULL,
0x0000001030107389ULL, 0x0002a400000e0073ULL, 0x000000ffff307224ULL, 0x002fc400078e0031ULL,
0x00000000ff317424ULL, 0x000fc800078e00ffULL, 0xfffec10030007950ULL, 0x000fea0003c3ffffULL,
0x000000011000780cULL, 0x000fe20003f45070ULL, 0x00000000ff317424ULL, 0x000fe200078e00ffULL,
0x0000007100007348ULL, 0x000ff60003800000ULL, 0x0000000000107806ULL, 0x000fc800050e0100ULL,
0x0000007110107212ULL, 0x000fe200078ec0ffULL, 0xfffec0a030007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000002ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000050aULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000668ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008c0ULL,
0x0000000000000288ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b48ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c08ULL,
0x00000000000005d0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000011d8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000011e8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001278ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000127cULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001480ULL,
0x0000000000014000ULL, 0x7f00001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015480ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x00000000000154c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000015840ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001278ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000014208ULL,
0x0000000000014208ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000015480ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000015840ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_0_m_16_sm_86_cubin_len = 88352;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
