/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000011690ULL, 0x0000000000011210ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x000000000000f9e0ULL, 0x0000000000000190ULL,
0x000e002200000106ULL, 0x000000000000fb70ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x000000000000fbb0ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x000000000000fbf0ULL,
0x0000000000000110ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x000000000000fd00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000f9e000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x003d340400288080ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x9008288080820828ULL, 0x2880809208288080ULL, 0x8097082880809408ULL, 0x082880809a082880ULL,
0x8080a508288080a1ULL, 0xae08288080a80828ULL, 0x288080af08288080ULL, 0x808608288080ba08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080869200ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x0000f9e000000000ULL, 0x0000019000000000ULL, 0x0000580400000000ULL,
0x8084288080820900ULL, 0x0900000004042880ULL, 0x2880808228808086ULL, 0x0000007cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x90082880808f0828ULL, 0x2880809208288080ULL, 0x8094082880809308ULL,
0x0828808095082880ULL, 0x8080a508288080a1ULL, 0xae08288080a80828ULL, 0x288080af08288080ULL,
0x8280162880808808ULL, 0x0000000003102880ULL, 0x8080889200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x0000013800000000ULL, 0x0000fb7000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8f08288080880828ULL,
0x2880809008288080ULL, 0x8093082880809208ULL, 0x0828808094082880ULL, 0x8080a10828808095ULL,
0xae08288080a50828ULL, 0x288080af08288080ULL, 0x828016288080a808ULL, 0x0000000003102880ULL,
0x8080a89200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL, 0x000001e800000000ULL,
0x0000fbb000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8f08288080880828ULL, 0x2880809008288080ULL, 0x8093082880809208ULL,
0x0828808094082880ULL, 0x8080a10828808095ULL, 0xae08288080a50828ULL, 0x288080af08288080ULL,
0x828016288080a808ULL, 0x0000000003102880ULL, 0x8080a89200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x0000029800000000ULL, 0x0000fbf000000000ULL, 0x0000011000000000ULL,
0x0000000000000000ULL, 0x0000001200082f04ULL, 0x0008120400000072ULL, 0x000000000000000dULL,
0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL,
0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL,
0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL,
0x0000000e00080a04ULL, 0x0058190300580160ULL, 0x00000000000c1704ULL, 0x0021f00000500007ULL,
0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL,
0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL,
0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x001c310400ff1b03ULL, 0x0000e03000000020ULL,
0x0000e3a00000e390ULL, 0x0000e5200000e510ULL, 0x016029040000e530ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001d0500001dULL,
0x0500001d0500001dULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000f001602804ULL,
0x00001ac000000110ULL, 0x00001c0000001b40ULL, 0x0000200000001c30ULL, 0x0000209000002030ULL,
0x00003300000020f0ULL, 0x0000346000003390ULL, 0x000038a000003580ULL, 0x00003920000038c0ULL,
0x000048d000003980ULL, 0x00004a3000004960ULL, 0x00004e6000004b50ULL, 0x00004ee000004e80ULL,
0x00005e6000004f40ULL, 0x00005fc000005ef0ULL, 0x00006400000060e0ULL, 0x0000648000006420ULL,
0x00006e00000064e0ULL, 0x0000944000006e10ULL, 0x00009c5000009680ULL, 0x0000ddd000009c80ULL,
0x0000de100000de00ULL, 0x0000de400000de20ULL, 0x0000de800000de60ULL, 0x0000e5000000de90ULL,
0x0000e5700000e560ULL, 0x0000ec900000e580ULL, 0x0000ed500000ece0ULL, 0x0000ee300000edc0ULL,
0x0000eef00000eea0ULL, 0x0000efa00000ef40ULL, 0x0000f0700000f010ULL, 0x0000f1300000f0e0ULL,
0x0000f1e00000f180ULL, 0x0000f2b00000f250ULL, 0x0000f3700000f320ULL, 0x0000f4200000f3c0ULL,
0x0000f4f00000f490ULL, 0x0000f5c00000f560ULL, 0x0000f6700000f620ULL, 0x0000f7100000f6c0ULL,
0x0000f7b00000f760ULL, 0x0000f8700000f800ULL, 0x0000f9500000f8f0ULL, 0x04c039040000f9b0ULL,
0x000000ff00000220ULL, 0x003f01000000f600ULL, 0x0000000b00000290ULL, 0x003f01200000f608ULL,
0x0000000b000002e0ULL, 0x003f01200000f688ULL, 0x0000000b00000370ULL, 0x003f01200000f6a8ULL,
0x0000000b000003b0ULL, 0x003f01200000f6c8ULL, 0x000000ff00000460ULL, 0x003f01070000f600ULL,
0x0000004200000630ULL, 0x003f01020000f68cULL, 0x0000004200000740ULL, 0x003f01010000f688ULL,
0x000000ff00000d60ULL, 0x0004010700000000ULL, 0x000000ff00000e20ULL, 0x0004010100000000ULL,
0x0000003900000e80ULL, 0x003f010100000020ULL, 0x0000006100000fd0ULL, 0x003f010500000004ULL,
0x0000003900001040ULL, 0x003f010500000024ULL, 0x00000039000010c0ULL, 0x003f010500000024ULL,
0x00000031000017b0ULL, 0x003f010700000000ULL, 0x0000003100001880ULL, 0x003f010100000000ULL,
0x0000003300001890ULL, 0x003f010500000004ULL, 0x0000004700001900ULL, 0x003f01010000f608ULL,
0x0000004700001920ULL, 0x003f01050000f60cULL, 0x0000002a000019d0ULL, 0x003f01050000f60cULL,
0x0000003300001ef0ULL, 0x003f010500000004ULL, 0x0000003300001f70ULL, 0x003f010500000004ULL,
0x00000039000028c0ULL, 0x003f010100000020ULL, 0x0000005700002940ULL, 0x003f01010000f688ULL,
0x0000006100002990ULL, 0x003f010500000004ULL, 0x00000039000029e0ULL, 0x003f010500000024ULL,
0x0000003900002a60ULL, 0x003f010500000024ULL, 0x0000005f00003030ULL, 0x003f010700000000ULL,
0x0000005f000030b0ULL, 0x003f010100000000ULL, 0x0000005c000030c0ULL, 0x003f010500000004ULL,
0x0000004700003130ULL, 0x003f01010000f628ULL, 0x0000004700003150ULL, 0x003f01050000f62cULL,
0x0000004700003230ULL, 0x003f01050000f62cULL, 0x0000002800003770ULL, 0x003f01050000f6acULL,
0x00000028000037f0ULL, 0x003f01050000f6acULL, 0x0000003900003fe0ULL, 0x003f010100000020ULL,
0x0000005700004050ULL, 0x003f01010000f690ULL, 0x0000006100004090ULL, 0x003f010500000004ULL,
0x00000039000040e0ULL, 0x003f010500000024ULL, 0x0000003900004160ULL, 0x003f010500000024ULL,
0x0000005c00004610ULL, 0x003f010700000000ULL, 0x0000005c00004690ULL, 0x003f010100000000ULL,
0x0000005f000046a0ULL, 0x003f010500000004ULL, 0x0000004700004710ULL, 0x003f01010000f648ULL,
0x0000004700004730ULL, 0x003f01050000f64cULL, 0x0000004700004800ULL, 0x003f01050000f64cULL,
0x0000000000004d30ULL, 0x003f01050000f6acULL, 0x0000005f00004db0ULL, 0x003f010500000004ULL,
0x0000003900005550ULL, 0x003f010100000020ULL, 0x00000057000055c0ULL, 0x003f01010000f698ULL,
0x0000006100005610ULL, 0x003f010500000004ULL, 0x0000003900005660ULL, 0x003f010500000024ULL,
0x00000039000056e0ULL, 0x003f010500000024ULL, 0x0000005f00005be0ULL, 0x003f010700000000ULL,
0x0000005f00005c60ULL, 0x003f010100000000ULL, 0x0000005c00005c70ULL, 0x003f010500000004ULL,
0x0000004700005ce0ULL, 0x003f01010000f668ULL, 0x0000004700005d00ULL, 0x003f01050000f66cULL,
0x0000004700005d90ULL, 0x003f01050000f66cULL, 0x00000029000062d0ULL, 0x003f01050000f6acULL,
0x0000005c00006350ULL, 0x003f010500000004ULL, 0x0000003900006a60ULL, 0x003f010100000020ULL,
0x0000005700006ac0ULL, 0x003f01010000f6a0ULL, 0x000000ff0000a9a0ULL, 0x003f01010000f600ULL,
0x000000ff0000b7a0ULL, 0x003f01050000f604ULL, 0x000000ff0000b840ULL, 0x003f01050000f604ULL,
0x000000ff0000ba50ULL, 0x003f01010000f600ULL, 0x000000ff0000ba60ULL, 0x003f01050000f604ULL,
0x000000ff0000baf0ULL, 0x003f01050000f604ULL, 0x000000310000d230ULL, 0x003f010100000000ULL,
0x000000310000d270ULL, 0x003f010500000004ULL, 0x000000310000d6d0ULL, 0x003f010500000004ULL,
0x000000330000eaf0ULL, 0x003f010100000000ULL, 0x000000330000eb50ULL, 0x003f010100000008ULL,
0x000000330000ebb0ULL, 0x003f010100000010ULL, 0x000000330000ec20ULL, 0x003f010100000018ULL,
0x00141c0400053803ULL, 0x0000a8b00000a660ULL, 0x0000bc000000bb50ULL, 0x000004010000ec60ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL,
0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x0000000000000334ULL, 0x0000001200000002ULL, 0x0000000000000284ULL,
0x0000001200000002ULL, 0x00000000000001d4ULL, 0x0000001200000002ULL, 0x000000000000010cULL,
0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL, 0x000000000000030cULL,
0x0000001200000002ULL, 0x000000000000025cULL, 0x0000001200000002ULL, 0x00000000000001acULL,
0x0000001200000002ULL, 0x00000000000000e9ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x00000000000e7806ULL, 0x000fe200038e0000ULL, 0x00005800ff2c7624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea20000002300ULL,
0x0000000e00047300ULL, 0x000ee200000e0000ULL, 0x00000100ff177424ULL, 0x000fe400078e00ffULL,
0x0000000000007919ULL, 0x000ea80000002200ULL, 0x0000000000447919ULL, 0x000f220000000000ULL,
0x0000000e000e7309ULL, 0x000f660000000000ULL, 0x00000000003d7919ULL, 0x000ee80000002600ULL,
0x0000000000057919ULL, 0x000f620000000000ULL, 0x00000005ff267819ULL, 0x002fc6000001160bULL,
0x0000000000287919ULL, 0x000e680000002700ULL, 0x00001fff26267589ULL, 0x000fe200000e0000ULL,
0x000000010d007824ULL, 0x004fc600078e0200ULL, 0x00001fff0d0d7589ULL, 0x000ea200000e0000ULL,
0x00000080000b7824ULL, 0x000fe200078e020bULL, 0x00000004ff0f7819ULL, 0x010fe20000011644ULL,
0x000000082c007824ULL, 0x000fe400078e00ffULL, 0x000000083d077824ULL, 0x008fe200078e00ffULL,
0x000000ff0b00720cULL, 0x040fe20003f45270ULL, 0x00000010440a7824ULL, 0x000fe200078e00ffULL,
0x0000000f0b00780cULL, 0x040fe40003f64070ULL, 0x000000030b00780cULL, 0x000fc40003f24070ULL,
0x0000007f0b00780cULL, 0x000fe40003f84070ULL, 0x000000050400720cULL, 0x020fe20003f02070ULL,
0x0000002800007224ULL, 0x002fe200078e0207ULL, 0x000000f00a157812ULL, 0x000fc600078ec0ffULL,
0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL,
0x000000040d067824ULL, 0x004fe400078e0226ULL, 0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL,
0x00f60002ff00a388ULL, 0x0003e20000000a00ULL, 0x000000010b00780cULL, 0x000fe20003f44070ULL,
0x0000000206087824ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff05b424ULL, 0x000fc400078e00ffULL,
0x0000000108117824ULL, 0x040fe200078e020fULL, 0x0000000808097817ULL, 0x000fe20007800000ULL,
0x3fffff60ff069424ULL, 0x000fe200078e00ffULL, 0x00f608040b00b388ULL, 0x0005e20000008a00ULL,
0x7fffff60ff079424ULL, 0x000fe200078e00ffULL, 0x0000000711137812ULL, 0x000fe200078ec0ffULL,
0x0000000100027824ULL, 0x002fe400078e0211ULL, 0x0000000109007824ULL, 0x000fe200078e0a08ULL,
0x00f688060b009388ULL, 0x000fe20000008a00ULL, 0xff317217ff0cc424ULL, 0x000fc400078e00ffULL,
0x3fffffc0ff08a424ULL, 0x000fe200078e00ffULL, 0x000000000f00720cULL, 0x000fe20003f66070ULL,
0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL, 0x00f4000c0b00c388ULL, 0x0003e20000004800ULL,
0x3fffff80ff049424ULL, 0x004fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x00005c0002027625ULL, 0x000fc600078e0017ULL, 0x00f6a8040b009388ULL, 0x0005e20000008a00ULL,
0x000000ffff007224ULL, 0x000fe200078e0a0eULL, 0x0000000f130c7812ULL, 0x002fe200078e7844ULL,
0x00000004ff0f7424ULL, 0x000fe200078e00ffULL, 0x00f6c8080b00a388ULL, 0x0003e80000008a00ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000001502027210ULL, 0x000fe20007f9e0ffULL,
0x00000010110c7824ULL, 0x000fc400078e020cULL, 0x0000620028047625ULL, 0x004fc800078e000fULL,
0x000000ffff037224ULL, 0x000fe400020e0603ULL, 0x000000100c077824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604247981ULL, 0x000ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x00000004ff257e24ULL, 0x008fe2000f8e00ffULL,
0x0000003f24037810ULL, 0x006fc40007ffe0ffULL, 0x000000ff24027810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff037819ULL, 0x000fe40000011603ULL, 0x00000008ff027819ULL, 0x000fca0000011602ULL,
0x0000a35000008947ULL, 0x000fea0003800000ULL, 0x00000002ff437819ULL, 0x000fe20000011626ULL,
0x0000000826427824ULL, 0x000fe400078e00ffULL, 0x00000003ff077424ULL, 0x000fe200078e00ffULL,
0x03ffffff43007812ULL, 0x000fca00078ec0ffULL, 0x0000000425097824ULL, 0x000fca00078e0200ULL,
0x000000030900720cULL, 0x000fda0003f06070ULL, 0x0000000228008824ULL, 0x000fe400078e00ffULL,
0x00006400ff058624ULL, 0x000fc800078e00ffULL, 0x0000640000048624ULL, 0x000fe400078e0205ULL,
0xffffffffff007424ULL, 0x000fe400078e00ffULL, 0x0000000109048824ULL, 0x000fe200078e0204ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f68c0742ff738cULL, 0x0003e20000000000ULL,
0x0000600004048625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000604008981ULL, 0x0004e2000c1e1900ULL, 0x00000003ff087424ULL, 0x000fe200078e00ffULL,
0x0000000309067812ULL, 0x000fe200078ec0ffULL, 0xffffffffff407424ULL, 0x000fe200078e00ffULL,
0x00000001263f7812ULL, 0x000fe200078ec0ffULL, 0x000003000f417a24ULL, 0x000fe200078e0a08ULL,
0x000000030600780cULL, 0x000fc40003f05270ULL, 0x00000001ff507819ULL, 0x000fe20000011626ULL,
0x000000403d3d7824ULL, 0x000fe200078e00ffULL, 0x0000000141467807ULL, 0x000fe20004000000ULL,
0x00f6880042ff7f8cULL, 0x0009e8000c80043fULL, 0x0000000109467824ULL, 0x000fca00078e0246ULL,
0x000000034600720cULL, 0x000fe40003f06070ULL, 0x00000003ff087819ULL, 0x000fd60000011644ULL,
0x0000000228068824ULL, 0x000fe400078e00ffULL, 0x00006400ff078624ULL, 0x002fc800078e00ffULL,
0x0000640006078624ULL, 0x000fe200078e0207ULL, 0x00000004080d7810ULL, 0x000fe20007ffe0ffULL,
0x000000103f067824ULL, 0x000fe400078e00ffULL, 0x0000000107048824ULL, 0x004fc800078e0246ULL,
0x0000600004048625ULL, 0x000fc800078e000fULL, 0x00000001060f7824ULL, 0x000fe200078e020dULL,
0x0000000604408981ULL, 0x000362000c1e1900ULL, 0x0000000125077810ULL, 0x000fe20007ffe0ffULL,
0x00000020503e7824ULL, 0x000fe200078e00ffULL, 0x00000008080e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000106097824ULL, 0x000fe200078e0208ULL, 0x000000020700720cULL, 0x000fe20003f06070ULL,
0x00002000503c7824ULL, 0x000fe200078e00ffULL, 0x0000000c08127810ULL, 0x000fe20007ffe0ffULL,
0x00000008090c7824ULL, 0x040fe200078e00ffULL, 0x00000044090b7212ULL, 0x080fe200078e3cffULL,
0x000000080f057824ULL, 0x042fe200078e00ffULL, 0x000000440f047212ULL, 0x080fe200078e3cffULL,
0x0000000106117824ULL, 0x040fe200078e020eULL, 0x00000000500473c2ULL, 0x000e6200000e0000ULL,
0x0000000106157824ULL, 0x000fe200078e0212ULL, 0xfffffff805077812ULL, 0x000fe200078ee204ULL,
0x0000010025047824ULL, 0x000fe200078e023eULL, 0x0000004411107212ULL, 0x0c0fe200078e3cffULL,
0x0000000811197824ULL, 0x000fe200078e00ffULL, 0x0000004415147212ULL, 0x000fe200078e3cffULL,
0xff317217ff3b7424ULL, 0x000fe200078e00ffULL, 0x0000000424057217ULL, 0x000fe20007800000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0xfffffff80c0b7812ULL, 0x000fe200078ee20bULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000b0003c0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105057824ULL, 0x100fe200078e0a04ULL, 0x000000203d047812ULL, 0x000fc400078ef804ULL,
0x0000f6a850397811ULL, 0x000fe200078e18ffULL, 0x000000100b0b7824ULL, 0x000fe200078e020cULL,
0x0000002005057807ULL, 0x000fe20000000000ULL, 0x0000000104097824ULL, 0x040fe400078e0209ULL,
0x00000001040f7824ULL, 0x040fe200078e020fULL, 0x0000000605057217ULL, 0x000fe20007800000ULL,
0x0000000104137824ULL, 0x040fe200078e0211ULL, 0x0000f6a804047891ULL, 0x002fe2000f8e203fULL,
0x0000000104177824ULL, 0x000fe400078e0215ULL, 0x0000000815117824ULL, 0x000fe200078e00ffULL,
0xfffffff819157812ULL, 0x000fe200078ee210ULL, 0x0000000105057824ULL, 0x000fc600078e0a06ULL,
0xfffffff811197812ULL, 0x000fe200078ee214ULL, 0x0000001007117824ULL, 0x100fe200078e020cULL,
0x000000050d00720cULL, 0x080fe20003f26070ULL, 0x0000001015157824ULL, 0x100fe200078e020cULL,
0x000000050800720cULL, 0x080fe20003f46070ULL, 0x0000001019197824ULL, 0x000fe200078e020cULL,
0x000000050e00720cULL, 0x000fe20003f06070ULL, 0x0000580000007a24ULL, 0x008fc800078e02ffULL,
0x0000004000007824ULL, 0x000fca00078e00ffULL, 0x0000000900097210ULL, 0x040fe40007f7e0ffULL,
0x0000000f000f7210ULL, 0x040fe40007f9e0ffULL, 0x0000001300137210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff047224ULL, 0x000fe200018e06ffULL, 0x00005e0009107a11ULL, 0x000fc600078638ffULL,
0x000000ffff067224ULL, 0x000fe200028e06ffULL, 0x00005f00090d7a11ULL, 0x000fe200018f3c04ULL,
0x000000ffff047224ULL, 0x000fe200020e06ffULL, 0x00005e000f087a11ULL, 0x040fe400078638ffULL,
0x0000001700007210ULL, 0x000fe40007fbe0ffULL, 0x00005f000f097a11ULL, 0x000fe400018f3c04ULL,
0x00005e00130c7a11ULL, 0x000fe200078838ffULL, 0x000000ffff077224ULL, 0x000fe200028e06ffULL,
0x000000700a0f7812ULL, 0x000fc400078ec0ffULL, 0x00005f0013067a11ULL, 0x000fe400020f3c06ULL,
0x000000100f047210ULL, 0x000fe40007fbe0ffULL, 0x0000000f08087210ULL, 0x000fe40007f9e0ffULL,
0x00005e00000e7a11ULL, 0x000fe400078c38ffULL, 0x000000051200720cULL, 0x000fe20003f66070ULL,
0x000000ffff057224ULL, 0x000fe200028e060dULL, 0x0000000f0c0c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200020e0609ULL, 0x00005f0000007a11ULL, 0x000fc400030f3c07ULL,
0x0000000f0e0e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200028e0606ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e2000d101c46ULL,
0x0000000000067805ULL, 0x000fe4000001ff00ULL, 0x000000ffff0f7224ULL, 0x000fe200020e0600ULL,
0x0000000008117faeULL, 0x0005e8000c901c46ULL, 0x000000000c157faeULL, 0x0007e2000c101c46ULL,
0x000000022500720cULL, 0x000fc60003f06070ULL, 0x000000000e197faeULL, 0x0009e2000d901c46ULL,
0x0000000000047805ULL, 0x002fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000087805ULL, 0x004fc6000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x00000000000c7805ULL, 0x008fe2000001ff00ULL,
0x0000000000187805ULL, 0x010fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff647f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00002000392a7f8cULL, 0x0004e2000c80043fULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000002039617810ULL, 0x000fe20007ffe0ffULL,
0x00005bf000000947ULL, 0x000fea0003800000ULL, 0x0000000228387824ULL, 0x004fe400078e00ffULL,
0x00006400ff077624ULL, 0x000fc400078e00ffULL, 0x000000ffff297224ULL, 0x008fe400078e002bULL,
0x0000640038387624ULL, 0x000fe400078e0207ULL, 0xff317217ff3b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff697224ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e00ffULL,
0x0000010025277824ULL, 0x000fca00078e00ffULL, 0x000000242700720cULL, 0x000fda0003f06070ULL,
0x00005b1000000947ULL, 0x006fea0003800000ULL, 0x0000040061007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804829ULL, 0x0000000000007918ULL, 0x000fee0000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x000000ffff597224ULL, 0x000fe400078e0046ULL,
0x000000ffff277224ULL, 0x000fe200078e0069ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240039007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000287305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000280000735dULL, 0x008fe40003800000ULL,
0x0000240039287984ULL, 0x000ea40000000800ULL, 0x8000000028ff7812ULL, 0x004fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000346007812ULL, 0x000fe200078ec0ffULL,
0x00005800402a7a24ULL, 0x020fe200078e02ffULL, 0x00000003ff357819ULL, 0x000fe20000011644ULL,
0xffffffffff407424ULL, 0x000fe200078e00ffULL, 0x000000030000780cULL, 0x000fc80003f05270ULL,
0x0000000141297807ULL, 0x000fca0004000000ULL, 0x0000000146467824ULL, 0x000fca00078e0229ULL,
0x000000034600720cULL, 0x000fe20003f06070ULL, 0x0000001026007824ULL, 0x000fe200078e00ffULL,
0x0000000435377810ULL, 0x000fe20007ffe0ffULL, 0x00000100254e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff507819ULL, 0x000fe40000011626ULL, 0x00000010002c7812ULL, 0x000fce00078ec0ffULL,
0x0000000138288824ULL, 0x000fe400078e0246ULL, 0x00000004ff298424ULL, 0x000fe400078e00ffULL,
0x00000001374f7824ULL, 0x000fe400078e022cULL, 0x0000600028288625ULL, 0x000fc800078e0029ULL,
0x0000002050007824ULL, 0x000fe200078e024eULL, 0x0000000628408981ULL, 0x000562000c1e1900ULL,
0x000000444f4a7212ULL, 0x080fe200078e3cffULL, 0x0000000135517824ULL, 0x140fe200078e022cULL,
0x0000000c35557810ULL, 0x000fe20007ffe0ffULL, 0x000000402a2a7824ULL, 0x000fe200078e00ffULL,
0x0000004000007810ULL, 0x000fe20007ffe0ffULL, 0x00000008512d7824ULL, 0x000fe200078e00ffULL,
0x00000001252b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001554b7824ULL, 0x000fe200078e022cULL,
0x00000044514c7212ULL, 0x000fe200078e3cffULL, 0x000000084f297824ULL, 0x004fe200078e00ffULL,
0x0000000835477810ULL, 0x000fe20007ffe0ffULL, 0x0000001044537824ULL, 0x000fe200078e00ffULL,
0x000000022b00720cULL, 0x000fe20003f06070ULL, 0x0000053000007945ULL, 0x000fe20003800000ULL,
0xfffffff8294a7812ULL, 0x000fe200078ee24aULL, 0x00000001474d7824ULL, 0x000fe200078e022cULL,
0x0000000024297217ULL, 0x000fc40007800000ULL, 0xfffffff82d4c7812ULL, 0x000fe200078ee24cULL,
0x000000084b2d7824ULL, 0x040fe200078e00ffULL, 0x000000444b487212ULL, 0x080fe200078e3cffULL,
0x0000000129297824ULL, 0x100fe200078e0a00ULL, 0x000000203d007812ULL, 0x000fe200078ef800ULL,
0x000000084d287824ULL, 0x000fe200078e00ffULL, 0xfffffff82d487812ULL, 0x000fe400078ee248ULL,
0x000000444d497212ULL, 0x000fe200078e3cffULL, 0x00000001002b7824ULL, 0x040fe200078e0251ULL,
0x0000002029297807ULL, 0x000fe20000000000ULL, 0x00000001002d7824ULL, 0x000fe200078e024fULL,
0xfffffff828497812ULL, 0x000fe200078ee249ULL, 0x00000001002f7824ULL, 0x000fe200078e024dULL,
0x0000002b2a337210ULL, 0x000fe20007f5e0ffULL, 0x00000001002b7824ULL, 0x000fe200078e024bULL,
0x0000002d2a2d7210ULL, 0x000fe20007f7e0ffULL, 0x0000100069287824ULL, 0x000fe200078e00ffULL,
0x0000002c29297217ULL, 0x000fe20007800000ULL, 0x000000ffff007224ULL, 0x000fe200010e06ffULL,
0x00005e0033327a11ULL, 0x000fc400078438ffULL, 0x0000002f2a2f7210ULL, 0x040fe40007f9e0ffULL,
0x0000002b2a2b7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x00005f0033337a11ULL, 0x000fe200010f3c00ULL, 0x0000000129007824ULL, 0x000fe200078e0a2cULL,
0x00005e002d307a11ULL, 0x040fe400078438ffULL, 0x0000100028297812ULL, 0x000fe200078e0cffULL,
0x000000ffff287224ULL, 0x000fe200020e06ffULL, 0x00005f002d317a11ULL, 0x000fe200010f3c2aULL,
0x000000ffff2a7224ULL, 0x000fe200000e06ffULL, 0x000000003500720cULL, 0x000fe20003f46070ULL,
0x0000200050297824ULL, 0x000fe200078e0229ULL, 0x00005e002f2c7a11ULL, 0x000fc400078638ffULL,
0x0000007053357812ULL, 0x000fe400078ec0ffULL, 0x00005f002f2d7a11ULL, 0x000fe400018f3c28ULL,
0x00005e002b2e7a11ULL, 0x000fe400078038ffULL, 0x0000003532287210ULL, 0x080fe40007f7e0ffULL,
0x0000b00029637810ULL, 0x000fe40007ffe0ffULL, 0x00005f002b2f7a11ULL, 0x000fe200000f3c2aULL,
0x000000ffff297224ULL, 0x000fe200018e0633ULL, 0x00000035302a7210ULL, 0x080fe20007fbe0ffULL,
0x000000104c5b7824ULL, 0x000fe200078e0263ULL, 0x000000003700720cULL, 0x080fe20003f06070ULL,
0x0000000869337824ULL, 0x000fe200078e00ffULL, 0x000000352c2c7210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200028e0631ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000285b7faeULL, 0x0005e2000d101c46ULL, 0x000000004700720cULL, 0x080fe20003f46070ULL,
0x000000104a5d7824ULL, 0x000fe200078e0263ULL, 0x000000005500720cULL, 0x000fe20003fa6070ULL,
0x000000ffff2d7224ULL, 0x000fe200018e062dULL, 0xfffffff042007812ULL, 0x000fe200078ec0ffULL,
0x0000001049627824ULL, 0x100fe200078e0263ULL, 0x000000352e2e7210ULL, 0x000fe20007f9e0ffULL,
0x0000001048637824ULL, 0x000fe200078e0263ULL, 0x0000f6a800307810ULL, 0x000fe20007ffe0ffULL,
0x000000002a5d7faeULL, 0x0007e2000c101c46ULL, 0x0000000833317812ULL, 0x000fe200078e0cffULL,
0x000000ffff2f7224ULL, 0x000fe200020e062fULL, 0xffffffe042477812ULL, 0x040fe200078ec0ffULL,
0x000000002c627faeULL, 0x0007e2000d101c46ULL, 0x0000001042007812ULL, 0x000fe200078ec0ffULL,
0x0000000130317824ULL, 0x000fe200078e0231ULL, 0x0000000842287812ULL, 0x004fe200078ec0ffULL,
0x000000002e637faeULL, 0x0007e2000e901c46ULL, 0x000000000000781cULL, 0x000fc40003f0f070ULL,
0x0000004728477210ULL, 0x000fe20007ffe000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x00000000310403c2ULL, 0x000ea40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000130337824ULL, 0x000fe200078e0233ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000031667f8cULL, 0x000528000c80043fULL, 0x00000400332a7984ULL, 0x0084e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6080047287f8cULL, 0x000fe2000c80043fULL, 0x800000002aff7812ULL, 0x00afc60007844865ULL,
0x00f60c00472b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe40007804829ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000a000000947ULL, 0x000fea0003800000ULL, 0x00000020432a7824ULL, 0x000fe400078e0200ULL,
0x3e000000ff007424ULL, 0x000fe400078e00ffULL, 0x000000083f2a7824ULL, 0x000fe400078e022aULL,
0x00000000002b7305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x0000002b0000735dULL, 0x008fe40003800000ULL, 0x00f60c002a2b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fc40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff527819ULL, 0x000fe20000011644ULL, 0xffffffffff547424ULL, 0x000fe200078e00ffULL,
0x0000007053537812ULL, 0x000fe400078ec0ffULL, 0x0000000c52527812ULL, 0x000fc600078ec0ffULL,
0x0000008043297824ULL, 0x000fc800078e0253ULL, 0x0000000129297824ULL, 0x000fca00078e0252ULL,
0x00f0000029007984ULL, 0x000e680000000800ULL, 0x00f20000292a7984ULL, 0x0006a20000000800ULL,
0x0000003b0000720bULL, 0x002fe20003f1d000ULL, 0x0000d1b27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000287806ULL, 0x008fc800000e0100ULL, 0x0000ffff282c7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff307424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x000000264300720cULL, 0x000fe40003f65270ULL,
0x0000003b0000720bULL, 0x000fe20003f14000ULL, 0x0000d1827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000287806ULL, 0x000fe400000e0100ULL, 0x000000802629b824ULL, 0x000fe200078e0253ULL,
0x000000003b2e7209ULL, 0x040fe40007810000ULL, 0x0000ffff282d7812ULL, 0x000fe200078e3cffULL,
0x000000015229b824ULL, 0x000fe400078e0229ULL, 0x8000002e3b2b7221ULL, 0x000fe20000010000ULL,
0x0000002d2cff7212ULL, 0x000fc4000780c0ffULL, 0x00f4002e2900b388ULL, 0x0003e20000000800ULL,
0x3fb8aa3b2b2b7820ULL, 0x000fe20000410000ULL, 0x00000002ff2c7819ULL, 0x000fc60000011644ULL,
0x0000002b00367308ULL, 0x0002e20000000800ULL, 0x0000d1127f007947ULL, 0x000fea000b800000ULL,
0x00001f2c362b7589ULL, 0x00a2e400000e0000ULL, 0x000000082c2c7810ULL, 0x002fe20007ffe0ffULL,
0x0000d1527f007947ULL, 0x000fea000b800000ULL, 0x00001f2c362c7589ULL, 0x00032400000e0000ULL,
0x8000002e00000221ULL, 0x100fe20000010000ULL, 0x000000363a3a7220ULL, 0x000fe20000410000ULL,
0x0000002c07077220ULL, 0x090fe20000410000ULL, 0x0000002c06067220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b00000820ULL, 0x000fe20000410000ULL, 0x0000002c0b0b7220ULL, 0x080fe20000410000ULL,
0x0000002c0a0a7220ULL, 0x080fe20000410000ULL, 0x0000002c1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000000450308ULL, 0x000f220000000800ULL, 0x0000002c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000002c0f0f7220ULL, 0x080fe20000410000ULL, 0x0000002c0e0e7220ULL, 0x080fe20000410000ULL,
0x0000002c13137220ULL, 0x080fe20000410000ULL, 0x0000002c12127220ULL, 0x080fe20000410000ULL,
0x0000002c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000002c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000002c23237220ULL, 0x080fe20000410000ULL, 0x0000002c22227220ULL, 0x080fe20000410000ULL,
0x0000002c17177220ULL, 0x080fe20000410000ULL, 0x0000002c16167220ULL, 0x000fe20000410000ULL,
0x00000001ff307807ULL, 0x000fe20000000000ULL, 0x0000002b05057220ULL, 0x088fe20000410000ULL,
0x0000002b04047220ULL, 0x080fe20000410000ULL, 0x0000002b09097220ULL, 0x080fe20000410000ULL,
0x0000002b08087220ULL, 0x080fe20000410000ULL, 0x0000002b19197220ULL, 0x080fe20000410000ULL,
0x0000002b18187220ULL, 0x080fe20000410000ULL, 0x0000002b0d0d7220ULL, 0x080fe20000410000ULL,
0x0000002b0c0c7220ULL, 0x080fe20000410000ULL, 0x0000002b11117220ULL, 0x080fe20000410000ULL,
0x0000002b10107220ULL, 0x080fe20000410000ULL, 0x0000002b1d1d7220ULL, 0x080fe20000410000ULL,
0x0000002b1c1c7220ULL, 0x080fe20000410000ULL, 0x0000002b21217220ULL, 0x080fe20000410000ULL,
0x0000002b20207220ULL, 0x080fe20000410000ULL, 0x0000002b15157220ULL, 0x080fe20000410000ULL,
0x0000002b14147220ULL, 0x000fe20000410000ULL, 0x000000ffff3b7224ULL, 0x000fe200078e002eULL,
0x000000452a2a0220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000003a2a3a7221ULL, 0x004fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0000040033007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007804865ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000287305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000280000735dULL, 0x008fe40003800000ULL, 0x0000040033287984ULL, 0x000ea40000000800ULL,
0x8000000028ff7812ULL, 0x004fe40007804865ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000045ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff2b7819ULL, 0x000fc40000011644ULL,
0x0000541000367816ULL, 0x002fe20000000000ULL, 0x0000cdf27f007947ULL, 0x000fea000b800000ULL,
0x00001f2b36577589ULL, 0x0002a400000e0000ULL, 0x000000082b557810ULL, 0x000fe20007ffe0ffULL,
0x0000ce327f007947ULL, 0x000fea000b800000ULL, 0x00001f5536007589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000102b377810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff6e7424ULL, 0x000fe200078e00ffULL, 0x000020a000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff6f7424ULL, 0x000fe400078e00ffULL, 0x0000db1000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000182b377810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff6e7424ULL, 0x000fe200078e00ffULL, 0x0000210000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff6f7424ULL, 0x000fe400078e00ffULL, 0x0000dab000007944ULL, 0x03cfea0003c00000ULL,
0x00000002265c7824ULL, 0x000fe200078e00ffULL, 0x0000000744297812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x000000045c2b7812ULL, 0x002fc400078ec0ffULL,
0x0000000829317812ULL, 0x000fe400078ef844ULL, 0x0000002b44327211ULL, 0x040fe400078fe0ffULL,
0x0000000844297812ULL, 0x000fe400078ec0ffULL, 0x0000000732287812ULL, 0x000fca00078e7831ULL,
0x0000000831287824ULL, 0x000fc800078e0228ULL, 0x00000010285e7824ULL, 0x000fc800078e00ffULL,
0x00000800432d7824ULL, 0x000fe400078e025eULL, 0x0000000426287824ULL, 0x040fe200078e00ffULL,
0x0000000729357812ULL, 0x140fe200078ec844ULL, 0x00001000262a7824ULL, 0x000fe200078e00ffULL,
0x0000000729337812ULL, 0x000fe200078ef844ULL, 0x009000002d2c783bULL, 0x000e620000000200ULL,
0x00000004282b7812ULL, 0x000fe400078ec0ffULL, 0xffffe0002a2a7812ULL, 0x000fe400078ec0ffULL,
0x0000002b44347211ULL, 0x004fe400078fe0ffULL, 0x0000991030307816ULL, 0x000fe200000000ffULL,
0x00001000692a7824ULL, 0x000fe200078e022aULL, 0x0000003435587212ULL, 0x000fc400078e3cffULL,
0x0000000234347810ULL, 0x000fe40007ffe0ffULL, 0x0000b0002a377810ULL, 0x000fe20007ffe0ffULL,
0x0000000833647824ULL, 0x000fe200078e0258ULL, 0x0000003435567212ULL, 0x000fe400078e3cffULL,
0x000000ff3000720cULL, 0x000fe20003f05270ULL, 0x0000001064287824ULL, 0x000fe200078e0237ULL,
0x0000000232327810ULL, 0x000fe20007ffe0ffULL, 0x00000008335a7824ULL, 0x040fe200078e0256ULL,
0x0000008033657811ULL, 0x000fc400078e18ffULL, 0x0000000732327812ULL, 0x000fe200078e7831ULL,
0x000000002828783bULL, 0x000ea20000004200ULL, 0x000000105a377824ULL, 0x000fe400078e0237ULL,
0x0000000158587824ULL, 0x100fe400078e0265ULL, 0x0000000831327824ULL, 0x000fe400078e0232ULL,
0x000000003734783bULL, 0x008ee20000004200ULL, 0x0000000156567824ULL, 0x000fe400078e0265ULL,
0x0000001032607824ULL, 0x000fe200078e00ffULL, 0x000000572c2c8232ULL, 0x002fc40000000000ULL,
0x000000572e2e8232ULL, 0x000fe40000000000ULL, 0x000000002d2d8232ULL, 0x080fe40000000000ULL,
0x000000002f2f8232ULL, 0x000fe20000000000ULL, 0x0000312028287816ULL, 0x004fe400000000ffULL,
0x0000312029297816ULL, 0x000fe400000000ffULL, 0x00000028ff6a723eULL, 0x000fe400020006ffULL,
0x00000029ff6b723eULL, 0x000fc400020006ffULL, 0x00000028ff28723eULL, 0x000fe400030006ffULL,
0x00000029ff29723eULL, 0x000fe400030006ffULL, 0x000031202a307816ULL, 0x000fe200000000ffULL,
0x0000006a2c14723cULL, 0x040fe20000001814ULL, 0x00001000692a7824ULL, 0x000fe200078e023cULL,
0x0000312034347816ULL, 0x008fe400000000ffULL, 0x0000312035357816ULL, 0x000fe400000000ffULL,
0x0000b0002a6d7810ULL, 0x000fe20007ffe0ffULL, 0x00000800432a7824ULL, 0x000fe200078e0260ULL,
0x000031202b6b7816ULL, 0x000fe200000000ffULL, 0x000000282c20723cULL, 0x000fe20000001820ULL,
0x00000030ff6a723eULL, 0x000fe200030006ffULL, 0x0000001058317824ULL, 0x100fe200078e026dULL,
0x00003120365f7816ULL, 0x000fe200000000ffULL, 0x0000001056367824ULL, 0x000fc600078e026dULL,
0x0000006bff29723eULL, 0x080fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400030006ffULL,
0x00000030ff28723eULL, 0x000fe400020006ffULL, 0x000000003130783bULL, 0x000e660000004200ULL,
0x0000006a2c10723cULL, 0x040fee0000001810ULL, 0x00000034ff6a723eULL, 0x080fe200020006ffULL,
0x000000282c1c723cULL, 0x000fe2000000181cULL, 0x00000035ff6b723eULL, 0x000fe200020006ffULL,
0x009000002a28783bULL, 0x000ea20000000200ULL, 0x00000034ff34723eULL, 0x000fc400030006ffULL,
0x00000035ff35723eULL, 0x000fc600030006ffULL, 0x0000006a2c0c723cULL, 0x040fee000000180cULL,
0x00003120376b7816ULL, 0x000fe200000000ffULL, 0x000000342c18723cULL, 0x000fe20000001818ULL,
0x0000005fff6a723eULL, 0x000fcc00030006ffULL, 0x0000005fff34723eULL, 0x000fe400020006ffULL,
0x0000006bff35723eULL, 0x080fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400030006ffULL,
0x0000312030307816ULL, 0x002fe400000000ffULL, 0x0000312031317816ULL, 0x000fe200000000ffULL,
0x000000342c08723cULL, 0x000fe20000001808ULL, 0x000000003634783bULL, 0x000e620000004200ULL,
0x0000312032327816ULL, 0x000fc400000000ffULL, 0x0000312033337816ULL, 0x000fc800000000ffULL,
0x0000006a2c04723cULL, 0x000fe20000001804ULL, 0x0000005728288232ULL, 0x084fe40000000000ULL,
0x000000572a2a8232ULL, 0x000fe40000000000ULL, 0x0000000029298232ULL, 0x080fe40000000000ULL,
0x00000030ff2c723eULL, 0x080fe200020006ffULL, 0x000000002b2b8232ULL, 0x000fe20000000000ULL,
0x00000031ff2d723eULL, 0x000fe400020006ffULL, 0x00000030ff30723eULL, 0x000fc400030006ffULL,
0x00000031ff31723eULL, 0x000fc600030006ffULL, 0x0000002c2814723cULL, 0x040fee0000001814ULL,
0x00000032ff2c723eULL, 0x080fe200020006ffULL, 0x000000302820723cULL, 0x000fe20000001820ULL,
0x00000033ff2d723eULL, 0x000fe400020006ffULL, 0x00000032ff32723eULL, 0x000fc400030006ffULL,
0x00000033ff33723eULL, 0x000fc600030006ffULL, 0x0000002c281c723cULL, 0x040fe2000000181cULL,
0x0000312034347816ULL, 0x002fe400000000ffULL, 0x0000312035357816ULL, 0x000fe400000000ffULL,
0x0000312036367816ULL, 0x000fe400000000ffULL, 0x00000034ff2c723eULL, 0x000fe200020006ffULL,
0x000000322810723cULL, 0x000fe20000001810ULL, 0x00000035ff2d723eULL, 0x000fe400020006ffULL,
0x0000312037377816ULL, 0x000fc400000000ffULL, 0x00000034ff34723eULL, 0x000fe400030006ffULL,
0x00000035ff35723eULL, 0x000fe200030006ffULL, 0x0000002c280c723cULL, 0x040fee000000180cULL,
0x00000036ff2c723eULL, 0x000fe200020006ffULL, 0x000000342818723cULL, 0x000fe20000001818ULL,
0x00000037ff2d723eULL, 0x000fc400020006ffULL, 0x00000036ff36723eULL, 0x000fe400030006ffULL,
0x00000037ff37723eULL, 0x000fc600030006ffULL, 0x0000002c2808723cULL, 0x040ff00000001808ULL,
0x000000362804723cULL, 0x000fe20000001804ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200039287f8cULL, 0x0002a2000c80043fULL, 0xfffffff85c577812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000404e2b7810ULL, 0x000fe20007ffe0ffULL,
0x00f6880057ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff657224ULL, 0x010fe200078e0067ULL,
0x0000000169697812ULL, 0x000fc400078e0cffULL, 0x000000242b00720cULL, 0x000fda0003f06070ULL,
0x0000415000000947ULL, 0x000fea0003800000ULL, 0x0000040061007984ULL, 0x008ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804829ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240039007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000287305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000280000735dULL, 0x008fe40003800000ULL,
0x0000240039287984ULL, 0x000ea40000000800ULL, 0x8000000028ff7812ULL, 0x004fc40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000359007812ULL, 0x000fe200078ec0ffULL,
0x00005800402c7a24ULL, 0x020fe200078e02ffULL, 0x00000001ff507819ULL, 0x000fe20000011626ULL,
0x00000008276a7824ULL, 0x000fe200078e00ffULL, 0x000000030000780cULL, 0x000fe20003f05270ULL,
0xffffffffff407424ULL, 0x000fc600078e00ffULL, 0x0000000141007807ULL, 0x000fca0004000000ULL,
0x00000001596d7824ULL, 0x000fca00078e0200ULL, 0x000000036d007812ULL, 0x000fc800078ec0ffULL,
0x000000030000780cULL, 0x000fc80003f05270ULL, 0x00000001416c7807ULL, 0x000fca0004000000ULL,
0x000000016d467824ULL, 0x000fca00078e026cULL, 0x000000034600720cULL, 0x000fe20003f06070ULL,
0x0000002050007824ULL, 0x000fe200078e024eULL, 0xfffffff0422a7812ULL, 0x000fe400078ec0ffULL,
0x000000086a5f7812ULL, 0x000fe400078ec0ffULL, 0x0000008000007810ULL, 0x000fce0007ffe0ffULL,
0x0000006c38288210ULL, 0x000fe20007ffe06dULL, 0x00000004ff298424ULL, 0x000fc800078e00ffULL,
0x0000600028288625ULL, 0x000fe200078e0029ULL, 0x0000f6a82a2a7810ULL, 0x000fe40007ffe0ffULL,
0x000000085f5c7812ULL, 0x000fe400078e3cffULL, 0x0000000628408981ULL, 0x000562000c1e1900ULL,
0x00000001252b7810ULL, 0x000fe20007ffe0ffULL, 0x000000012a5f7824ULL, 0x040fe200078e025fULL,
0x00000003ff337819ULL, 0x000fe20000011644ULL, 0x000000012a5c7824ULL, 0x000fe200078e025cULL,
0x000000022b00720cULL, 0x000fe20003f06070ULL, 0x00000010262a7824ULL, 0x000fe200078e00ffULL,
0x000000005f0473c2ULL, 0x000ee200000e0000ULL, 0x000000402c2f7824ULL, 0x000fe200078e00ffULL,
0x0000000024297217ULL, 0x004fe20007800000ULL, 0x00001000276b7824ULL, 0x000fe200078e00ffULL,
0x000000203d287812ULL, 0x000fc400078ef800ULL, 0x000000102a2c7812ULL, 0x000fe200078ec0ffULL,
0x0000000129297824ULL, 0x000fe400078e0a00ULL, 0x0000000151007824ULL, 0x100fe400078e0228ULL,
0x000000014f2a7824ULL, 0x100fe200078e0228ULL, 0x0000002029297807ULL, 0x000fe20000000000ULL,
0x000000014d2b7824ULL, 0x100fe200078e0228ULL, 0x000000002f007210ULL, 0x000fe20007f1e0ffULL,
0x000000014b287824ULL, 0x000fe200078e0228ULL, 0x0000002a2f2a7210ULL, 0x000fc40007f5e0ffULL,
0x000000292c297217ULL, 0x000fe20007800000ULL, 0x000000ffff317224ULL, 0x000fe200000e06ffULL,
0x00005e0000367a11ULL, 0x000fe400078038ffULL, 0x0000002b2f2d7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200010e06ffULL, 0x00005e002a327a11ULL, 0x000fe400078438ffULL,
0x000000282f287210ULL, 0x000fe40007f9e0ffULL, 0x00005f0000317a11ULL, 0x000fe200000f3c31ULL,
0x0000000129007824ULL, 0x000fe200078e0a2cULL, 0x000010006b297812ULL, 0x000fc400078ec0ffULL,
0x00005f002a347a11ULL, 0x000fe200010f3c2bULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x00005e002d2c7a11ULL, 0x000fe200078038ffULL, 0x000000ffff2b7224ULL, 0x000fe200020e06ffULL,
0x00005e00282e7a11ULL, 0x000fe200078438ffULL, 0x0000200050297824ULL, 0x000fe200078e0229ULL,
0x00000004332f7810ULL, 0x040fe40007ffe0ffULL, 0x000000003300720cULL, 0x000fe40003f86070ULL,
0x00005f002d2d7a11ULL, 0x000fc400000f3c2aULL, 0x00005f0028307a11ULL, 0x000fe400010f3c2bULL,
0x000000002f00720cULL, 0x080fe40003f06070ULL, 0x0000005336287210ULL, 0x080fe40007f5e0ffULL,
0x0000b000292f7810ULL, 0x000fe40007ffe0ffULL, 0x00000008332b7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff297224ULL, 0x000fe200010e0631ULL, 0x0000000c33337810ULL, 0x000fe20007ffe0ffULL,
0x000000104c317824ULL, 0x100fe200078e022fULL, 0x00000053322a7210ULL, 0x080fe20007fbe0ffULL,
0x0000001049357824ULL, 0x100fe200078e022fULL, 0x000000002b00720cULL, 0x080fe20003f66070ULL,
0x0000001048377824ULL, 0x100fe200078e022fULL, 0x000000003300720cULL, 0x000fe20003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028317faeULL, 0x0005e2000e101c46ULL,
0x000000532c2c7210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200028e0634ULL,
0x000000532e2e7210ULL, 0x000fe20007fbe0ffULL, 0x000000104a337824ULL, 0x000fc400078e022fULL,
0x000000ffff2d7224ULL, 0x000fe400020e062dULL, 0x000000ffff2f7224ULL, 0x000fe200028e0630ULL,
0x000000002a337faeULL, 0x0005e8000c101c46ULL, 0x000000002c357faeULL, 0x0005e8000d901c46ULL,
0x000000002e377faeULL, 0x0005e8000d101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x008fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000005f287f8cULL, 0x0044e8000c80043fULL,
0x000004005c2d7984ULL, 0x0005220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f62800472a7f8cULL, 0x000fe2000c80043fULL,
0x800000002dff7812ULL, 0x010fc60007844867ULL, 0x00f62c00472f7984ULL, 0x000f240000000800ULL,
0x800000002fff7812ULL, 0x010fe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff657224ULL, 0x008fe200078e0029ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0xffffffe042477812ULL, 0x040fe200078ec0ffULL,
0x3e000000ff007424ULL, 0x000fe200078e00ffULL, 0x0000001042287812ULL, 0x040fe400078ec0ffULL,
0x0000000842297812ULL, 0x000fc800078ec0ffULL, 0x0000004729477210ULL, 0x000fe40007ffe028ULL,
0x0000000000287305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000280000735dULL, 0x010fe20003800000ULL, 0x00f62c0047297984ULL, 0x000ee40000000800ULL,
0x8000000029ff7812ULL, 0x008fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002026007824ULL, 0x000fca00078e00ffULL, 0xffffff8000007812ULL, 0x000fc800078ec0ffULL,
0x0000008053297810ULL, 0x000fca0007ffe000ULL, 0x0000000152297824ULL, 0x000fca00078e0229ULL,
0x00f0000029007984ULL, 0x000ee80000000800ULL, 0x00f20000292a7984ULL, 0x0008620000000800ULL,
0x0000003b0000720bULL, 0x008fe20003f1d000ULL, 0x0000bbd27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000287806ULL, 0x010fc800000e0100ULL, 0x0000ffff282d7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff307424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000143297810ULL, 0x000fe40007ffe0ffULL,
0x0000003b0000720bULL, 0x000fe40003f14000ULL, 0x000000262900720cULL, 0x000fe20003f65270ULL,
0x0000bb927f007947ULL, 0x000ff4000b800000ULL, 0x0000000000287806ULL, 0x000fe400000e0100ULL,
0x000000003b2c7209ULL, 0x040fe20007810000ULL, 0x00000080262bb824ULL, 0x000fe200078e0253ULL,
0x0000ffff28287812ULL, 0x000fe400078e3cffULL, 0x00000002ff377819ULL, 0x000fe20000011644ULL,
0x00000001522bb824ULL, 0x000fe200078e022bULL, 0x8000002c3b297221ULL, 0x000fe20000010000ULL,
0x000000282dff7212ULL, 0x000fc6000780c0ffULL, 0x3fb8aa3b29297820ULL, 0x000fe20000410000ULL,
0x00f4002c2b00b388ULL, 0x0007e60000000800ULL, 0x0000002900367308ULL, 0x000f240000000800ULL,
0x000000363a3a7220ULL, 0x010fe20000410000ULL, 0x0000bb127f007947ULL, 0x000fea000b800000ULL,
0x00001f3736287589ULL, 0x00872400000e0000ULL, 0x0000002814147220ULL, 0x090fe20000410000ULL,
0x0000002815157220ULL, 0x080fe20000410000ULL, 0x0000002820207220ULL, 0x080fe20000410000ULL,
0x0000002821217220ULL, 0x080fe20000410000ULL, 0x000000281c1c7220ULL, 0x080fe20000410000ULL,
0x000000281d1d7220ULL, 0x080fe20000410000ULL, 0x0000002810107220ULL, 0x080fe20000410000ULL,
0x0000002811117220ULL, 0x080fe20000410000ULL, 0x000000280c0c7220ULL, 0x080fe20000410000ULL,
0x000000280d0d7220ULL, 0x080fe20000410000ULL, 0x0000002818187220ULL, 0x080fe20000410000ULL,
0x0000002819197220ULL, 0x080fe20000410000ULL, 0x0000002808087220ULL, 0x080fe20000410000ULL,
0x0000002809097220ULL, 0x080fe20000410000ULL, 0x0000002804047220ULL, 0x080fe20000410000ULL,
0x0000002805057220ULL, 0x000fe20000410000ULL, 0x0000ba527f007947ULL, 0x000fea000b800000ULL,
0x00001f5536287589ULL, 0x0008a400000e0000ULL, 0x000000003b3b7209ULL, 0x000fe20007810000ULL,
0x0000002816167220ULL, 0x084fe20000410000ULL, 0x00000001ff307807ULL, 0x000fe20000000000ULL,
0x0000002817177220ULL, 0x080fe20000410000ULL, 0x0000002822227220ULL, 0x080fe20000410000ULL,
0x8000003b00000221ULL, 0x000fe20000010000ULL, 0x0000002823237220ULL, 0x080fe20000410000ULL,
0x000000281e1e7220ULL, 0x080fe20000410000ULL, 0x000000281f1f7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b00000820ULL, 0x000fe20000410000ULL, 0x0000002812127220ULL, 0x080fe20000410000ULL,
0x0000002813137220ULL, 0x080fe20000410000ULL, 0x000000280e0e7220ULL, 0x080fe20000410000ULL,
0x0000000000450308ULL, 0x000ea20000000800ULL, 0x000000280f0f7220ULL, 0x080fe20000410000ULL,
0x000000281a1a7220ULL, 0x080fe20000410000ULL, 0x000000281b1b7220ULL, 0x080fe20000410000ULL,
0x000000280a0a7220ULL, 0x080fe20000410000ULL, 0x000000280b0b7220ULL, 0x080fe20000410000ULL,
0x0000002806067220ULL, 0x080fe20000410000ULL, 0x0000002807077220ULL, 0x000fe20000410000ULL,
0x0000002a452a0220ULL, 0x006fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000003a2a3a7221ULL, 0x002fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x0000000827007824ULL, 0x000fe200078e00ffULL,
0xfffffff042297812ULL, 0x000fc800078ec0ffULL, 0x0000000800007812ULL, 0x000fca00078e0cffULL,
0x0000000129287824ULL, 0x000fca00078e0200ULL, 0x00f6ac0028297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000297305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000290000735dULL, 0x004fe40003800000ULL, 0x00f6ac0028297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fc40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff377819ULL, 0x008fe40000011644ULL, 0x00000045ff00723eULL, 0x000fe400000000ffULL,
0x00000018372a7810ULL, 0x040fe40007ffe0ffULL, 0x00000010372b7810ULL, 0x000fe40007ffe0ffULL,
0x0000541000367816ULL, 0x010fe20000000000ULL, 0x0000b7a27f007947ULL, 0x000fea000b800000ULL,
0x00001f3736697589ULL, 0x0002e400000e0000ULL, 0x0000b7e27f007947ULL, 0x000fea000b800000ULL,
0x00001f5536007589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff377224ULL, 0x002fe200078e002bULL, 0x0000393000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6f7424ULL, 0x000fe400078e00ffULL,
0x0000c28000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff377224ULL, 0x002fe200078e002aULL, 0x0000399000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6f7424ULL, 0x000fe400078e00ffULL,
0x0000c22000007944ULL, 0x03cfea0003c00000ULL, 0x0000100027337824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100026297824ULL, 0x000fe200078e00ffULL,
0x0000991030307816ULL, 0x000fe200000000ffULL, 0x0000020026287824ULL, 0x000fe200078e00ffULL,
0x0000100033337812ULL, 0x000fe400078e0cffULL, 0xffffe000292a7812ULL, 0x000fc400078ec0ffULL,
0xfffff80028317812ULL, 0x000fe400078ec0ffULL, 0x0000b0002a357810ULL, 0x000fe40007ffe033ULL,
0x000000ff3000720cULL, 0x000fe20003f05270ULL, 0x000000015e687824ULL, 0x000fe200078e0231ULL,
0x0000b0003c597810ULL, 0x000fe20007ffe033ULL, 0x0000001064677824ULL, 0x100fe400078e0235ULL,
0x000000105a667824ULL, 0x000fe200078e0235ULL, 0x009800006828783bULL, 0x000f220000000200ULL,
0x00000010585e7824ULL, 0x000fc400078e0259ULL, 0x0000000160607824ULL, 0x000fe200078e0231ULL,
0x00000000672c783bULL, 0x000ee20000004200ULL, 0x0000001056597824ULL, 0x000fc600078e0259ULL,
0x000000006634783bULL, 0x016e620000004200ULL, 0x0000006928288232ULL, 0x088fe40000000000ULL,
0x000000692a2a8232ULL, 0x000fe20000000000ULL, 0x000031202c2c7816ULL, 0x000fe200000000ffULL,
0x0000000029298232ULL, 0x080fe20000000000ULL, 0x000031202d2d7816ULL, 0x000fe200000000ffULL,
0x000000002b2b8232ULL, 0x000fe20000000000ULL, 0x0000002cff6e723eULL, 0x000fe400020006ffULL,
0x0000002dff6f723eULL, 0x000fc400020006ffULL, 0x0000002cff2c723eULL, 0x000fe400030006ffULL,
0x0000002dff2d723eULL, 0x000fe400030006ffULL, 0x000031202e307816ULL, 0x000fe200000000ffULL,
0x0000006e2814723cULL, 0x000fe20000001814ULL, 0x0000312034347816ULL, 0x002fe400000000ffULL,
0x0000312035357816ULL, 0x000fc800000000ffULL, 0x000031202f6f7816ULL, 0x000fe200000000ffULL,
0x0000002c2820723cULL, 0x000fe20000001820ULL, 0x00000030ff6e723eULL, 0x000fcc00030006ffULL,
0x0000006fff2d723eULL, 0x080fe400020006ffULL, 0x0000006fff6f723eULL, 0x000fe400030006ffULL,
0x00000030ff2c723eULL, 0x000fe400020006ffULL, 0x000000005e30783bULL, 0x000e660000004200ULL,
0x0000006e2810723cULL, 0x040fee0000001810ULL, 0x00000034ff6e723eULL, 0x080fe200020006ffULL,
0x0000002c281c723cULL, 0x000fe2000000181cULL, 0x00000035ff6f723eULL, 0x000fe200020006ffULL,
0x00980000602c783bULL, 0x000ea20000000200ULL, 0x00000034ff34723eULL, 0x000fc400030006ffULL,
0x00000035ff35723eULL, 0x000fc600030006ffULL, 0x0000006e280c723cULL, 0x040fee000000180cULL,
0x00003120366e7816ULL, 0x000fe200000000ffULL, 0x000000342818723cULL, 0x000fe20000001818ULL,
0x00003120376f7816ULL, 0x000fcc00000000ffULL, 0x0000006eff34723eULL, 0x080fe400020006ffULL,
0x0000006fff35723eULL, 0x080fe400020006ffULL, 0x0000006eff6e723eULL, 0x000fe400030006ffULL,
0x0000006fff6f723eULL, 0x000fe400030006ffULL, 0x0000312030307816ULL, 0x002fe200000000ffULL,
0x000000342808723cULL, 0x000fe20000001808ULL, 0x000000005934783bULL, 0x000e620000004200ULL,
0x0000312031317816ULL, 0x000fc400000000ffULL, 0x0000312032327816ULL, 0x000fe400000000ffULL,
0x0000312033337816ULL, 0x000fe400000000ffULL, 0x0000006e2804723cULL, 0x000fe20000001804ULL,
0x000000692c2c8232ULL, 0x084fe40000000000ULL, 0x000000692e2e8232ULL, 0x000fe40000000000ULL,
0x000000002d2d8232ULL, 0x080fe40000000000ULL, 0x00000030ff28723eULL, 0x000fe200020006ffULL,
0x000000002f2f8232ULL, 0x000fe20000000000ULL, 0x00000031ff29723eULL, 0x000fc400020006ffULL,
0x00000030ff30723eULL, 0x000fe400030006ffULL, 0x00000031ff31723eULL, 0x000fc600030006ffULL,
0x000000282c14723cULL, 0x040fee0000001814ULL, 0x00000032ff28723eULL, 0x080fe200020006ffULL,
0x000000302c20723cULL, 0x000fe20000001820ULL, 0x00000033ff29723eULL, 0x000fe400020006ffULL,
0x00000032ff32723eULL, 0x000fc400030006ffULL, 0x00000033ff33723eULL, 0x000fc600030006ffULL,
0x000000282c1c723cULL, 0x040fe2000000181cULL, 0x0000312034347816ULL, 0x002fe400000000ffULL,
0x0000312035357816ULL, 0x000fe400000000ffULL, 0x0000312036367816ULL, 0x000fe400000000ffULL,
0x00000034ff28723eULL, 0x000fe200020006ffULL, 0x000000322c10723cULL, 0x000fe20000001810ULL,
0x00000035ff29723eULL, 0x000fe400020006ffULL, 0x0000312037377816ULL, 0x000fc400000000ffULL,
0x00000034ff34723eULL, 0x000fe400030006ffULL, 0x00000035ff35723eULL, 0x000fe200030006ffULL,
0x000000282c0c723cULL, 0x040fee000000180cULL, 0x00000036ff28723eULL, 0x000fe200020006ffULL,
0x000000342c18723cULL, 0x000fe20000001818ULL, 0x00000037ff29723eULL, 0x000fc400020006ffULL,
0x00000036ff36723eULL, 0x000fe400030006ffULL, 0x00000037ff37723eULL, 0x000fc600030006ffULL,
0x000000282c08723cULL, 0x040ff00000001808ULL, 0x000000362c04723cULL, 0x000fe20000001804ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200039287f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000804e2b7810ULL, 0x000fe20007ffe0ffULL, 0x00f6900057ff7f8cULL, 0x0007e2000c80043fULL,
0x0000000127697812ULL, 0x000fc400078ec0ffULL, 0x000000242b00720cULL, 0x000fda0003f06070ULL,
0x00002a5000000947ULL, 0x000fea0003800000ULL, 0x0000040061007984ULL, 0x008ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804829ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240039007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000287305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000280000735dULL, 0x008fe40003800000ULL,
0x0000240039287984ULL, 0x000ea40000000800ULL, 0x8000000028ff7812ULL, 0x004fc40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000016d6d7824ULL, 0x000fe400078e026cULL,
0x00005800402e7a24ULL, 0x020fe200078e02ffULL, 0x00000001ff507819ULL, 0x000fe20000011626ULL,
0xffffffffff407424ULL, 0x000fe200078e00ffULL, 0x000000036d007812ULL, 0x000fc800078ec0ffULL,
0x000000030000780cULL, 0x000fc80003f05270ULL, 0x0000000141467807ULL, 0x000fca0004000000ULL,
0x000000016d467824ULL, 0x000fe400078e0246ULL, 0x0000002050007824ULL, 0x000fc600078e024eULL,
0x000000034600720cULL, 0x000fe40003f06070ULL, 0x000000c000007810ULL, 0x000fc80007ffe0ffULL,
0x00000000242b7217ULL, 0x000fe40007800000ULL, 0x000000203d2a7812ULL, 0x000fca00078ef800ULL,
0x0000000138288824ULL, 0x000fe400078e0246ULL, 0x00000004ff298424ULL, 0x000fe200078e00ffULL,
0x00000001252d7810ULL, 0x000fe20007ffe0ffULL, 0x000000012b2b7824ULL, 0x000fe400078e0a00ULL,
0x0000600028288625ULL, 0x000fe200078e0029ULL, 0x000000022d00720cULL, 0x000fc60003f46070ULL,
0x000000402e2f7824ULL, 0x000fe200078e00ffULL, 0x0000000628408981ULL, 0x000562000c1e1900ULL,
0x0000000151007824ULL, 0x000fe200078e022aULL, 0x000000202b2b7807ULL, 0x000fe20001000000ULL,
0x00000010262c7824ULL, 0x000fe200078e00ffULL, 0x00000003ff337819ULL, 0x000fe20000011644ULL,
0x000000005c0473c2ULL, 0x000ee200000e0000ULL, 0x000000002f007210ULL, 0x000fe40007f1e0ffULL,
0x000000102c2c7812ULL, 0x000fe200078ec0ffULL, 0x000000014f287824ULL, 0x104fe200078e022aULL,
0x0000000433357810ULL, 0x000fe20007ffe0ffULL, 0x000000014d297824ULL, 0x100fe200078e022aULL,
0x0000002b2c2b7217ULL, 0x000fe20007800000ULL, 0x000000014b2a7824ULL, 0x000fe200078e022aULL,
0x000000282f2d7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff317224ULL, 0x000fe200000e06ffULL,
0x00005e0000347a11ULL, 0x000fc400078038ffULL, 0x000000292f297210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff327224ULL, 0x000fe200010e06ffULL, 0x0000002a2f2a7210ULL, 0x000fe40007f9e0ffULL,
0x00005f0000317a11ULL, 0x000fe200000f3c31ULL, 0x000000012b007824ULL, 0x000fe200078e0a2cULL,
0x00005e002d307a11ULL, 0x000fe200078038ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x00005e00292c7a11ULL, 0x000fe200078438ffULL, 0x000000ffff2f7224ULL, 0x000fe200020e06ffULL,
0x00005e002a2e7a11ULL, 0x000fc400078638ffULL, 0x00005f002d2b7a11ULL, 0x000fe400000f3c32ULL,
0x00005f00292d7a11ULL, 0x000fe400010f3c28ULL, 0x00005f002a2f7a11ULL, 0x000fe400018f3c2fULL,
0x0000000833297810ULL, 0x040fe40007ffe0ffULL, 0x0000005334287210ULL, 0x000fe40007f9e0ffULL,
0x000000003300720cULL, 0x000fc40003f66070ULL, 0x0000000c33337810ULL, 0x000fe40007ffe0ffULL,
0x00000053302a7210ULL, 0x080fe40007fbe0ffULL, 0x000000003500720cULL, 0x080fe40003f46070ULL,
0x000000002900720cULL, 0x080fe20003f06070ULL, 0x000000ffff297224ULL, 0x000fe200020e0631ULL,
0x000000003300720cULL, 0x000fe20003f86070ULL, 0x000000ffff2b7224ULL, 0x000fe200028e062bULL,
0x000000532c2c7210ULL, 0x000fc40007fde0ffULL, 0x000000532e2e7210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000285b7faeULL, 0x0005e4000d901c46ULL,
0x000000ffff2d7224ULL, 0x000fe400030e062dULL, 0x000000ffff2f7224ULL, 0x000fe200028e062fULL,
0x000000002a5d7faeULL, 0x0005e8000d101c46ULL, 0x000000002c627faeULL, 0x0005e8000c101c46ULL,
0x000000002e637faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x008fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000005c627f8cULL, 0x0044e8000c80043fULL,
0x000004005f007984ULL, 0x0005220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480047287f8cULL, 0x000fe2000c80043fULL,
0x8000000000ff7812ULL, 0x010fc60007844865ULL, 0x00f64c00472b7984ULL, 0x000f240000000800ULL,
0x800000002bff7812ULL, 0x010fe40007804829ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0xffffffe042477812ULL, 0x040fe200078ec0ffULL, 0x3e000000ff007424ULL, 0x000fe200078e00ffULL,
0x00000010422a7812ULL, 0x040fe400078ec0ffULL, 0x00000008422b7812ULL, 0x000fc800078ec0ffULL,
0x000000472b477210ULL, 0x000fe40007ffe02aULL, 0x00000000002a7305ULL, 0x000864000021f000ULL,
0x3fa0000000007823ULL, 0x010fe200000100ffULL, 0x0000002a0000735dULL, 0x002fe20003800000ULL,
0x00f64c00472b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002026007824ULL, 0x000fca00078e00ffULL,
0xffffff8000007812ULL, 0x000fc800078ec0ffULL, 0x0000010053297810ULL, 0x000fca0007ffe000ULL,
0x0000000152297824ULL, 0x000fca00078e0229ULL, 0x00f0000029007984ULL, 0x000f280000000800ULL,
0x00f20000292a7984ULL, 0x0002a20000000800ULL, 0x0000003b0000720bULL, 0x010fe20003f1d000ULL,
0x0000a8427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000287806ULL, 0x002fc800000e0100ULL,
0x0000ffff282d7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff307424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000243297810ULL, 0x000fe40007ffe0ffULL, 0x0000003b0000720bULL, 0x000fe40003f14000ULL,
0x000000262900720cULL, 0x000fe20003f65270ULL, 0x0000a8027f007947ULL, 0x000ff4000b800000ULL,
0x0000000000287806ULL, 0x000fe400000e0100ULL, 0x000000003b2c7209ULL, 0x040fe20007810000ULL,
0x00000080262bb824ULL, 0x000fe200078e0253ULL, 0x0000ffff28287812ULL, 0x000fe400078e3cffULL,
0x00000002ff377819ULL, 0x000fe20000011644ULL, 0x00000001522bb824ULL, 0x000fe200078e022bULL,
0x8000002c3b297221ULL, 0x000fe20000010000ULL, 0x000000282dff7212ULL, 0x000fc6000780c0ffULL,
0x3fb8aa3b29297820ULL, 0x000fe20000410000ULL, 0x00f4002c2b00b388ULL, 0x0003e60000000800ULL,
0x0000002900367308ULL, 0x000f240000000800ULL, 0x000000363a3a7220ULL, 0x010fe20000410000ULL,
0x0000a7827f007947ULL, 0x000fea000b800000ULL, 0x00001f3736287589ULL, 0x00232400000e0000ULL,
0x0000002814147220ULL, 0x090fe20000410000ULL, 0x0000002815157220ULL, 0x080fe20000410000ULL,
0x0000002820207220ULL, 0x080fe20000410000ULL, 0x0000002821217220ULL, 0x080fe20000410000ULL,
0x000000281c1c7220ULL, 0x080fe20000410000ULL, 0x000000281d1d7220ULL, 0x080fe20000410000ULL,
0x0000002810107220ULL, 0x080fe20000410000ULL, 0x0000002811117220ULL, 0x080fe20000410000ULL,
0x000000280c0c7220ULL, 0x080fe20000410000ULL, 0x000000280d0d7220ULL, 0x080fe20000410000ULL,
0x0000002818187220ULL, 0x080fe20000410000ULL, 0x0000002819197220ULL, 0x080fe20000410000ULL,
0x0000002808087220ULL, 0x080fe20000410000ULL, 0x0000002809097220ULL, 0x080fe20000410000ULL,
0x0000002804047220ULL, 0x080fe20000410000ULL, 0x0000002805057220ULL, 0x000fe20000410000ULL,
0x0000a6c27f007947ULL, 0x000fea000b800000ULL, 0x00001f5536287589ULL, 0x00086400000e0000ULL,
0x000000003b3b7209ULL, 0x000fe20007810000ULL, 0x0000002816167220ULL, 0x082fe20000410000ULL,
0x00000001ff307807ULL, 0x000fe20000000000ULL, 0x0000002817177220ULL, 0x080fe20000410000ULL,
0x0000002822227220ULL, 0x080fe20000410000ULL, 0x8000003b00000221ULL, 0x000fe20000010000ULL,
0x0000002823237220ULL, 0x080fe20000410000ULL, 0x000000281e1e7220ULL, 0x080fe20000410000ULL,
0x000000281f1f7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b00000820ULL, 0x000fe20000410000ULL,
0x0000002812127220ULL, 0x080fe20000410000ULL, 0x0000002813137220ULL, 0x080fe20000410000ULL,
0x000000280e0e7220ULL, 0x080fe20000410000ULL, 0x0000000000450308ULL, 0x000e620000000800ULL,
0x000000280f0f7220ULL, 0x080fe20000410000ULL, 0x000000281a1a7220ULL, 0x080fe20000410000ULL,
0x000000281b1b7220ULL, 0x080fe20000410000ULL, 0x000000280a0a7220ULL, 0x080fe20000410000ULL,
0x000000280b0b7220ULL, 0x080fe20000410000ULL, 0x0000002806067220ULL, 0x080fe20000410000ULL,
0x0000002807077220ULL, 0x000fe20000410000ULL, 0x0000002a452a0220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0000003a2a3a7221ULL, 0x004fe20000010000ULL, 0x000000f000002947ULL, 0x000fea0003800000ULL,
0x000000086a007812ULL, 0x000fe400078ec0ffULL, 0xfffffff042297812ULL, 0x000fca00078ec0ffULL,
0x0000000129007824ULL, 0x000fcc00078e0200ULL, 0x00f6ac0000007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804865ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000287305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000280000735dULL, 0x004fe40003800000ULL, 0x000004005f287984ULL, 0x000e640000000800ULL,
0x8000000028ff7812ULL, 0x002fc40007804865ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff377819ULL, 0x000fe40000011644ULL, 0x00000045ff00723eULL, 0x000fe400000000ffULL,
0x00000018372a7810ULL, 0x040fe40007ffe0ffULL, 0x00000010372b7810ULL, 0x000fe40007ffe0ffULL,
0x0000541000367816ULL, 0x010fe20000000000ULL, 0x0000a4227f007947ULL, 0x000fea000b800000ULL,
0x00001f37365b7589ULL, 0x0002a400000e0000ULL, 0x0000a4627f007947ULL, 0x000fea000b800000ULL,
0x00001f5536007589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff377224ULL, 0x002fe200078e002bULL, 0x00004ef000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6f7424ULL, 0x000fe400078e00ffULL,
0x0000acc000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff377224ULL, 0x002fe200078e002aULL, 0x00004f5000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6f7424ULL, 0x000fe400078e00ffULL,
0x0000ac6000007944ULL, 0x03cfea0003c00000ULL, 0x0000100026287824ULL, 0x000fe200078e00ffULL,
0x000010006b5d7812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000991030307816ULL, 0x000fe400000000ffULL, 0xffffe00028287812ULL, 0x000fe400078ec0ffULL,
0x000000ff3000720cULL, 0x000fc40003f05270ULL, 0x0000b00028317810ULL, 0x100fe40007ffe05dULL,
0x00a000006828783bULL, 0x000f220000000200ULL, 0x0000b0003c5d7810ULL, 0x000fe40007ffe05dULL,
0x00000010642c7824ULL, 0x100fe400078e0231ULL, 0x000000105a347824ULL, 0x004fc800078e0231ULL,
0x000000002c2c783bULL, 0x000ea80000004200ULL, 0x000000003434783bULL, 0x012e620000004200ULL,
0x0000005b28288232ULL, 0x080fe40000000000ULL, 0x0000005b2a2a8232ULL, 0x000fe40000000000ULL,
0x0000000029298232ULL, 0x080fe40000000000ULL, 0x000000002b2b8232ULL, 0x000fe20000000000ULL,
0x000031202c307816ULL, 0x004fc400000000ffULL, 0x000031202d317816ULL, 0x000fe400000000ffULL,
0x00000030ff2c723eULL, 0x080fe400020006ffULL, 0x00000031ff2d723eULL, 0x080fe400020006ffULL,
0x000031202f657816ULL, 0x000fe400000000ffULL, 0x000031202e327816ULL, 0x000fe400000000ffULL,
0x00000030ff30723eULL, 0x000fe200030006ffULL, 0x0000002c2814723cULL, 0x000fe20000001814ULL,
0x00000031ff31723eULL, 0x000fc400030006ffULL, 0x00000032ff64723eULL, 0x080fe400030006ffULL,
0x0000312034347816ULL, 0x002fe400000000ffULL, 0x00000065ff2d723eULL, 0x080fe200020006ffULL,
0x000000302820723cULL, 0x000fe20000001820ULL, 0x00000065ff65723eULL, 0x000fe400030006ffULL,
0x0000312035357816ULL, 0x000fe400000000ffULL, 0x00000032ff2c723eULL, 0x000fc400020006ffULL,
0x0000001058307824ULL, 0x100fe200078e025dULL, 0x000000642810723cULL, 0x000fe20000001810ULL,
0x0000312036587816ULL, 0x000fe200000000ffULL, 0x0000001056367824ULL, 0x000fc600078e025dULL,
0x000000003030783bULL, 0x000e640000004200ULL, 0x00000034ff64723eULL, 0x080fe200020006ffULL,
0x0000002c281c723cULL, 0x000fe2000000181cULL, 0x00000035ff65723eULL, 0x080fe200020006ffULL,
0x00a00000602c783bULL, 0x000ea20000000200ULL, 0x00000034ff34723eULL, 0x000fe400030006ffULL,
0x00000035ff35723eULL, 0x000fc600030006ffULL, 0x00000064280c723cULL, 0x040fee000000180cULL,
0x0000312037657816ULL, 0x000fe200000000ffULL, 0x000000342818723cULL, 0x000fe20000001818ULL,
0x00000058ff64723eULL, 0x000fcc00030006ffULL, 0x00000058ff34723eULL, 0x000fe400020006ffULL,
0x00000065ff35723eULL, 0x080fe400020006ffULL, 0x00000065ff65723eULL, 0x000fca00030006ffULL,
0x000000342808723cULL, 0x000fe20000001808ULL, 0x000000003634783bULL, 0x000f220000004200ULL,
0x0000312030307816ULL, 0x002fe400000000ffULL, 0x0000312031317816ULL, 0x000fc800000000ffULL,
0x000000642804723cULL, 0x000fe20000001804ULL, 0x0000312032327816ULL, 0x000fe200000000ffULL,
0x0000005b2c2c8232ULL, 0x084fe20000000000ULL, 0x0000312033337816ULL, 0x000fe200000000ffULL,
0x0000005b2e2e8232ULL, 0x000fe40000000000ULL, 0x000000002d2d8232ULL, 0x080fe20000000000ULL,
0x00000030ff28723eULL, 0x080fe200020006ffULL, 0x000000002f2f8232ULL, 0x000fe20000000000ULL,
0x00000031ff29723eULL, 0x000fe400020006ffULL, 0x00000030ff30723eULL, 0x000fc400030006ffULL,
0x00000031ff31723eULL, 0x000fc600030006ffULL, 0x000000282c14723cULL, 0x040fee0000001814ULL,
0x00000032ff28723eULL, 0x080fe200020006ffULL, 0x000000302c20723cULL, 0x000fe20000001820ULL,
0x00000033ff29723eULL, 0x000fe400020006ffULL, 0x00000032ff32723eULL, 0x000fc400030006ffULL,
0x00000033ff33723eULL, 0x000fc600030006ffULL, 0x000000282c1c723cULL, 0x040fe2000000181cULL,
0x0000312034347816ULL, 0x010fe400000000ffULL, 0x0000312035357816ULL, 0x000fe400000000ffULL,
0x0000312036367816ULL, 0x000fe400000000ffULL, 0x00000034ff28723eULL, 0x000fe200020006ffULL,
0x000000322c10723cULL, 0x000fe20000001810ULL, 0x00000035ff29723eULL, 0x000fe400020006ffULL,
0x0000312037377816ULL, 0x000fc400000000ffULL, 0x00000034ff34723eULL, 0x000fe400030006ffULL,
0x00000035ff35723eULL, 0x000fe200030006ffULL, 0x000000282c0c723cULL, 0x040fee000000180cULL,
0x00000036ff28723eULL, 0x000fe200020006ffULL, 0x000000342c18723cULL, 0x000fe20000001818ULL,
0x00000037ff29723eULL, 0x000fc400020006ffULL, 0x00000036ff36723eULL, 0x000fe400030006ffULL,
0x00000037ff37723eULL, 0x000fc600030006ffULL, 0x000000282c08723cULL, 0x040ff00000001808ULL,
0x000000362c04723cULL, 0x000fe20000001804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200039287f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c04e2b7810ULL, 0x000fe20007ffe0ffULL,
0x00f6980057ff7f8cULL, 0x0009e2000c80043fULL, 0x0000000127697812ULL, 0x000fe200078e0cffULL,
0x000000ffff657224ULL, 0x008fe200078e0063ULL, 0x000000242b00720cULL, 0x000fda0003f06070ULL,
0x000014d000000947ULL, 0x000fea0003800000ULL, 0x0000040061007984ULL, 0x010ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804829ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240039007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000287305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000280000735dULL, 0x008fe40003800000ULL,
0x0000240039287984ULL, 0x000ea40000000800ULL, 0x8000000028ff7812ULL, 0x004fc40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000346007812ULL, 0x000fe200078ec0ffULL,
0x00005800402c7a24ULL, 0x020fe200078e02ffULL, 0x00000300252b7a10ULL, 0x000fe20007ffe0ffULL,
0xffffffffff407424ULL, 0x000fe200078e00ffULL, 0x000000030000780cULL, 0x000fc80003f05270ULL,
0x0000000141297807ULL, 0x000fca0004000000ULL, 0x0000000146467824ULL, 0x000fca00078e0229ULL,
0x000000034600720cULL, 0x000fe20003f06070ULL, 0x000001002b007824ULL, 0x040fe200078e023eULL,
0x000000012b2b7810ULL, 0x000fc80007ffe0ffULL, 0x00000000242d7217ULL, 0x000fe40007800000ULL,
0x000000203d2a7812ULL, 0x000fca00078ef800ULL, 0x0000000138288824ULL, 0x000fe400078e0246ULL,
0x00000004ff298424ULL, 0x000fc800078e00ffULL, 0x0000600028288625ULL, 0x000fc800078e0029ULL,
0x000000012d2d7824ULL, 0x000fe200078e0a00ULL, 0x0000000628408981ULL, 0x000562000c1e1900ULL,
0x000000402c307824ULL, 0x000fe200078e00ffULL, 0x000000022b00720cULL, 0x000fe20003f06070ULL,
0x000000014f4f7824ULL, 0x000fe200078e022aULL, 0x00000003ff347819ULL, 0x000fe20000011644ULL,
0x0000001026007824ULL, 0x000fe200078e00ffULL, 0x000000202d2d7807ULL, 0x000fe20000000000ULL,
0x0000000151517824ULL, 0x100fe200078e022aULL, 0x0000004f304f7210ULL, 0x000fe20007f5e0ffULL,
0x000000014d4d7824ULL, 0x100fe200078e022aULL, 0x00000010002e7812ULL, 0x000fe200078ec0ffULL,
0x000000014b2a7824ULL, 0x000fe200078e022aULL, 0x0000005130517210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200010e06ffULL, 0x0000002d2e2d7217ULL, 0x000fe20007800000ULL,
0x000000005f0473c2ULL, 0x000ee200000e0000ULL, 0x0000002a302a7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200000e06ffULL, 0x00005e004f327a11ULL, 0x000fe200078438ffULL,
0x000000012d2d7824ULL, 0x000fe200078e0a2eULL, 0x0000004d304d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff297224ULL, 0x004fe200020e06ffULL, 0x00005f004f2b7a11ULL, 0x000fc400010f3c00ULL,
0x00005e002a2e7a11ULL, 0x040fe200078438ffULL, 0x000000ffff307224ULL, 0x000fe200018e06ffULL,
0x00005e0051287a11ULL, 0x000fe400078038ffULL, 0x00005f002a007a11ULL, 0x000fe200010f3c29ULL,
0x0000100027297824ULL, 0x000fe200078e00ffULL, 0x00000053322a7210ULL, 0x000fe40007fbe0ffULL,
0x00005f0051317a11ULL, 0x000fe400000f3c2cULL, 0x00005e004d2c7a11ULL, 0x000fe200078038ffULL,
0x000000ffff2b7224ULL, 0x000fe200028e062bULL, 0x00000004344e7810ULL, 0x000fc40007ffe0ffULL,
0x0000100029297812ULL, 0x000fe400078ec0ffULL, 0x0000005328287210ULL, 0x000fe40007f9e0ffULL,
0x0000000834367810ULL, 0x040fe40007ffe0ffULL, 0x0000002d3400720cULL, 0x040fe40003f66070ULL,
0x0000000c34347810ULL, 0x000fe40007ffe0ffULL, 0x00005f004d307a11ULL, 0x000fc400000f3c30ULL,
0x000000532c2c7210ULL, 0x000fe40007fbe0ffULL, 0x0000002d4e00720cULL, 0x080fe40003f46070ULL,
0x0000b0003c2f7810ULL, 0x000fe20007ffe029ULL, 0x000000ffff297224ULL, 0x000fe200020e0631ULL,
0x0000002d3600720cULL, 0x080fe40003f06070ULL, 0x0000002d3400720cULL, 0x000fe20003f86070ULL,
0x000000ffff2d7224ULL, 0x000fe200028e0630ULL, 0x000000532e2e7210ULL, 0x000fe20007fbe0ffULL,
0x000000104c317824ULL, 0x000fc400078e022fULL, 0x000000104a337824ULL, 0x100fe400078e022fULL,
0x0000001049497824ULL, 0x100fe200078e022fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028317faeULL, 0x0005e2000d901c46ULL, 0x0000001048357824ULL, 0x000fe400078e022fULL,
0x000000ffff2f7224ULL, 0x000fe200028e0600ULL, 0x000000002a337faeULL, 0x0005e8000d101c46ULL,
0x000000002c497faeULL, 0x0005e8000c101c46ULL, 0x000000002e357faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x008fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000005f647f8cULL, 0x000728000c80043fULL, 0x000004005c2b7984ULL, 0x0046a20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6680047287f8cULL, 0x000fe2000c80043fULL, 0x800000002bff7812ULL, 0x004fc60007844863ULL,
0x00f66c00472d7984ULL, 0x000ea40000000800ULL, 0x800000002dff7812ULL, 0x004fe40007804829ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x00000000002a7305ULL, 0x000464000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x0000002a0000735dULL, 0x002fe20003800000ULL, 0x00f66c00472b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fc40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002026007824ULL, 0x000fca00078e00ffULL, 0xffffff8000007812ULL, 0x000fc800078ec0ffULL,
0x0000018053297810ULL, 0x000fca0007ffe000ULL, 0x0000000152297824ULL, 0x000fca00078e0229ULL,
0x00f0000029007984ULL, 0x000ea80000000800ULL, 0x00f20000292a7984ULL, 0x0002e20000000800ULL,
0x0000003b0000720bULL, 0x004fe20003f1d000ULL, 0x000094f27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000287806ULL, 0x002fc800000e0100ULL, 0x0000ffff282d7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2c7424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000343297810ULL, 0x000fe40007ffe0ffULL,
0x0000003b0000720bULL, 0x000fe40003f14000ULL, 0x000000262900720cULL, 0x000fe20003f65270ULL,
0x000094b27f007947ULL, 0x000ff4000b800000ULL, 0x0000000000287806ULL, 0x000fe400000e0100ULL,
0x000000003b2b7209ULL, 0x040fe20007810000ULL, 0x000000802653b824ULL, 0x000fe200078e0253ULL,
0x0000ffff28287812ULL, 0x000fe400078e3cffULL, 0x00000002ff377819ULL, 0x000fe20000011644ULL,
0x000000015252b824ULL, 0x000fe200078e0253ULL, 0x8000002b3b297221ULL, 0x000fe20000010000ULL,
0x000000282dff7212ULL, 0x000fc6000780c0ffULL, 0x3fb8aa3b29297820ULL, 0x000fe20000410000ULL,
0x00f4002b5200b388ULL, 0x0003e60000000800ULL, 0x0000002900367308ULL, 0x000ea40000000800ULL,
0x000000363a3a7220ULL, 0x004fe20000410000ULL, 0x000094327f007947ULL, 0x000fea000b800000ULL,
0x00001f3736287589ULL, 0x0022a400000e0000ULL, 0x0000002814147220ULL, 0x084fe20000410000ULL,
0x0000002815157220ULL, 0x080fe20000410000ULL, 0x0000002820207220ULL, 0x080fe20000410000ULL,
0x0000002821217220ULL, 0x080fe20000410000ULL, 0x000000281c1c7220ULL, 0x080fe20000410000ULL,
0x000000281d1d7220ULL, 0x080fe20000410000ULL, 0x0000002810107220ULL, 0x080fe20000410000ULL,
0x0000002811117220ULL, 0x080fe20000410000ULL, 0x000000280c0c7220ULL, 0x080fe20000410000ULL,
0x000000280d0d7220ULL, 0x080fe20000410000ULL, 0x0000002818187220ULL, 0x080fe20000410000ULL,
0x0000002819197220ULL, 0x080fe20000410000ULL, 0x0000002808087220ULL, 0x080fe20000410000ULL,
0x0000002809097220ULL, 0x080fe20000410000ULL, 0x0000002804047220ULL, 0x080fe20000410000ULL,
0x0000002805057220ULL, 0x000fe20000410000ULL, 0x000093727f007947ULL, 0x000fea000b800000ULL,
0x00001f5536287589ULL, 0x00046400000e0000ULL, 0x8000002b00000221ULL, 0x100fe20000010000ULL,
0x00000001ff2c7807ULL, 0x000fe20000000000ULL, 0x0000002816167220ULL, 0x082fe20000410000ULL,
0x0000002817177220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b00000820ULL, 0x000fe20000410000ULL,
0x0000002822227220ULL, 0x080fe20000410000ULL, 0x0000002823237220ULL, 0x080fe20000410000ULL,
0x000000281e1e7220ULL, 0x080fe20000410000ULL, 0x0000000000450308ULL, 0x000e620000000800ULL,
0x000000281f1f7220ULL, 0x080fe20000410000ULL, 0x0000002812127220ULL, 0x080fe20000410000ULL,
0x0000002813137220ULL, 0x080fe20000410000ULL, 0x000000280e0e7220ULL, 0x080fe20000410000ULL,
0x000000280f0f7220ULL, 0x080fe20000410000ULL, 0x000000281a1a7220ULL, 0x080fe20000410000ULL,
0x000000281b1b7220ULL, 0x080fe20000410000ULL, 0x000000280a0a7220ULL, 0x080fe20000410000ULL,
0x000000280b0b7220ULL, 0x080fe20000410000ULL, 0x0000002806067220ULL, 0x080fe20000410000ULL,
0x0000002807077220ULL, 0x000fe20000410000ULL, 0x000000ffff3b7224ULL, 0x000fe200078e002bULL,
0x0000002a452a0220ULL, 0x00afc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000003a2a3a7221ULL, 0x008fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x0000000827007824ULL, 0x000fe200078e00ffULL,
0xfffffff042297812ULL, 0x000fc800078ec0ffULL, 0x0000000800007812ULL, 0x000fca00078e0cffULL,
0x0000000129297824ULL, 0x000fcc00078e0200ULL, 0x00f6ac0029297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe40007804863ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000287305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000280000735dULL, 0x008fe20003800000ULL, 0x000004005c297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fc40007804863ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff377819ULL, 0x000fe40000011644ULL, 0x00000045ff00723eULL, 0x000fe400000000ffULL,
0x00000018372a7810ULL, 0x040fe40007ffe0ffULL, 0x00000010372b7810ULL, 0x000fe40007ffe0ffULL,
0x0000541000367816ULL, 0x004fe20000000000ULL, 0x000090c27f007947ULL, 0x000fea000b800000ULL,
0x00001f3736317589ULL, 0x0002a400000e0000ULL, 0x000091027f007947ULL, 0x000fea000b800000ULL,
0x00001f5536007589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff377224ULL, 0x002fe200078e002bULL, 0x0000649000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6f7424ULL, 0x000fe400078e00ffULL,
0x0000972000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff377224ULL, 0x002fe200078e002aULL, 0x000064f000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6f7424ULL, 0x000fe400078e00ffULL,
0x000096c000007944ULL, 0x03cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006734783bULL, 0x00ee620000004200ULL, 0x000099102c2c7816ULL, 0x000fc600000000ffULL,
0x00a800006828783bULL, 0x000ea20000000200ULL, 0x000000ff2c00720cULL, 0x000fc60003f05270ULL,
0x000000006648783bULL, 0x000ee80000004200ULL, 0x000000005e5c783bULL, 0x000f280000004200ULL,
0x000000005958783bULL, 0x000f220000004200ULL, 0x0000312034347816ULL, 0x002fe400000000ffULL,
0x0000312035357816ULL, 0x000fc400000000ffULL, 0x00000034ff2c723eULL, 0x000fe200020006ffULL,
0x0000003128288232ULL, 0x084fe20000000000ULL, 0x00000035ff2d723eULL, 0x000fe200020006ffULL,
0x000000312a2a8232ULL, 0x000fe20000000000ULL, 0x0000312036367816ULL, 0x000fe200000000ffULL,
0x0000000029298232ULL, 0x080fe20000000000ULL, 0x0000312037377816ULL, 0x000fe200000000ffULL,
0x000000002b2b8232ULL, 0x000fe20000000000ULL, 0x0000312048487816ULL, 0x008fe400000000ffULL,
0x0000312049497816ULL, 0x000fc400000000ffULL, 0x00000048ff32723eULL, 0x000fe400020006ffULL,
0x0000002c2814723cULL, 0x040fe20000001814ULL, 0x00000049ff33723eULL, 0x000fe400020006ffULL,
0x000031204a4a7816ULL, 0x000fe400000000ffULL, 0x000031204b4b7816ULL, 0x000fe400000000ffULL,
0x00000036ff2c723eULL, 0x000fe200020006ffULL, 0x00000032280c723cULL, 0x000fe2000000180cULL,
0x00000037ff2d723eULL, 0x000fc400020006ffULL, 0x00000034ff34723eULL, 0x000fe400030006ffULL,
0x00000035ff35723eULL, 0x000fe400030006ffULL, 0x00000036ff36723eULL, 0x000fe200030006ffULL,
0x0000002c281c723cULL, 0x000fe2000000181cULL, 0x00a80000602c783bULL, 0x000e620000000200ULL,
0x00000037ff37723eULL, 0x000fe400030006ffULL, 0x00000048ff48723eULL, 0x000fe400030006ffULL,
0x00000049ff49723eULL, 0x000fc400030006ffULL, 0x0000004aff32723eULL, 0x080fe200020006ffULL,
0x000000342820723cULL, 0x040fe20000001820ULL, 0x0000004bff33723eULL, 0x080fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400030006ffULL, 0x0000004bff4b723eULL, 0x000fe400030006ffULL,
0x000031205c5c7816ULL, 0x010fe200000000ffULL, 0x000000362810723cULL, 0x000fe20000001810ULL,
0x000031205d5d7816ULL, 0x000fc400000000ffULL, 0x000031205e5e7816ULL, 0x000fe400000000ffULL,
0x000031205f5f7816ULL, 0x000fe400000000ffULL, 0x0000312058587816ULL, 0x000fe200000000ffULL,
0x000000482818723cULL, 0x000fe20000001818ULL, 0x0000312059597816ULL, 0x000fe400000000ffULL,
0x000031205a5a7816ULL, 0x000fe400000000ffULL, 0x000031205b5b7816ULL, 0x000fc600000000ffULL,
0x000000322808723cULL, 0x040ff00000001808ULL, 0x0000004a2828723cULL, 0x000fe20000001804ULL,
0x000000312c2c8232ULL, 0x082fe40000000000ULL, 0x000000312e2e8232ULL, 0x000fc40000000000ULL,
0x000000002d2d8232ULL, 0x080fe40000000000ULL, 0x000000002f2f8232ULL, 0x000fe20000000000ULL,
0x0000005cff04723eULL, 0x080fe400020006ffULL, 0x0000005dff05723eULL, 0x080fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400030006ffULL, 0x0000005dff5d723eULL, 0x000fc600030006ffULL,
0x000000042c14723cULL, 0x040fee0000001814ULL, 0x0000005eff04723eULL, 0x080fe200020006ffULL,
0x0000005c2c20723cULL, 0x000fe20000001820ULL, 0x0000005fff05723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fc400030006ffULL, 0x0000005fff5f723eULL, 0x000fc600030006ffULL,
0x000000042c1c723cULL, 0x040fee000000181cULL, 0x00000058ff04723eULL, 0x080fe200020006ffULL,
0x0000005e2c10723cULL, 0x000fe20000001810ULL, 0x00000059ff05723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fc400030006ffULL, 0x00000059ff59723eULL, 0x000fc600030006ffULL,
0x000000042c0c723cULL, 0x040fee000000180cULL, 0x0000005aff04723eULL, 0x000fe200020006ffULL,
0x000000582c18723cULL, 0x000fe20000001818ULL, 0x0000005bff05723eULL, 0x000fce00020006ffULL,
0x000000042c08723cULL, 0x000fee0000001808ULL, 0x0000005aff04723eULL, 0x000fe400030006ffULL,
0x0000005bff05723eULL, 0x000fce00030006ffULL, 0x000000042c04723cULL, 0x000fe20000001828ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200039287f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a00057ff7f8cULL, 0x0007e2000c80043fULL, 0x0000000127697812ULL, 0x000fc600078ec0ffULL,
0x0000030025257a10ULL, 0x018fc80007ffe0ffULL, 0x000000022500720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffa48000007947ULL, 0x000fea000383ffffULL,
0x00000000000479c3ULL, 0x004ea20000002500ULL, 0x000000ffff297224ULL, 0x000fe400078e000eULL,
0x000000ffff287224ULL, 0x000fe400078e001bULL, 0x000000ffff2d7224ULL, 0x000fe400078e001aULL,
0x000000ffff247224ULL, 0x000fe400078e0019ULL, 0x000000ffff2b7224ULL, 0x008fe400078e0018ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0017ULL, 0x000000ffff307224ULL, 0x000fe400078e0007ULL,
0x000000ffff357224ULL, 0x000fe400078e0006ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0005ULL,
0x000000ffff337224ULL, 0x000fe400078e0004ULL, 0x000000ffff2c7224ULL, 0x000fe400078e000bULL,
0x000000ffff317224ULL, 0x000fe200078e000aULL, 0x0000000402007c0cULL, 0x004fe2000bf03070ULL,
0x000000ffff2a7224ULL, 0x000fc400078e0009ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0008ULL,
0x000000ffff1a7224ULL, 0x000fe400078e000fULL, 0x000000ffff187224ULL, 0x000fe400078e000dULL,
0x000000ffff277224ULL, 0x000fe400078e000cULL, 0x000000ffff257224ULL, 0x000fe400078e0013ULL,
0x000000ffff1b7224ULL, 0x000fc400078e0011ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff177224ULL, 0x000fe200078e0015ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x018000003a007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x00006d1000067802ULL, 0x000fe40000000f00ULL,
0x00008cd000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0004ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003a00037308ULL, 0x000ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc8000000003aULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff037624ULL, 0x000fe400078e00ffULL, 0x00006800ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000ea8000c1e9900ULL, 0x0000000000047919ULL, 0x000ee80000000000ULL,
0x0000000000077919ULL, 0x000f220000000000ULL, 0x00000002ff067819ULL, 0x008fe40000011604ULL,
0x0000000807047811ULL, 0x010fe200078ff0ffULL, 0x0000000003057220ULL, 0x004fca0000410000ULL,
0x00001f0605007589ULL, 0x000ea800000e0000ULL, 0x00001f0405047589ULL, 0x000ee200000e0000ULL,
0x0000001400147220ULL, 0x044fe20000410000ULL, 0x0000001700177220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002100217220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000001000107220ULL, 0x040fe20000410000ULL, 0x0000001b001b7220ULL, 0x040fe20000410000ULL,
0x0000002700277220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000002b002b7220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002f002f7220ULL, 0x040fe20000410000ULL, 0x0000002a002a7220ULL, 0x040fe20000410000ULL,
0x0000003300337220ULL, 0x040fe20000410000ULL, 0x0000002e002e7220ULL, 0x000fe20000410000ULL,
0x0000001904197220ULL, 0x048fe20000410000ULL, 0x0000000e040e7220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000001204127220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x000fe20000410000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000203007812ULL, 0x004fc400078ec0ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011603ULL,
0x0000000200047811ULL, 0x040fe400078ff8ffULL, 0x0000000400067811ULL, 0x000fe400078ff8ffULL,
0x0000000803157811ULL, 0x000fe400078ff0ffULL, 0x00000001ff027819ULL, 0x000fe40000011600ULL,
0x0000000704057812ULL, 0x000fc400078e780dULL, 0x00000006000a7811ULL, 0x000fe400078ff8ffULL,
0x0000000706087812ULL, 0x040fe200078e780dULL, 0x000000080d097824ULL, 0x000fe200078e0205ULL,
0x0000000706067812ULL, 0x000fe200078e7815ULL, 0x000010003f057824ULL, 0x000fe200078e00ffULL,
0x0000000702007812ULL, 0x100fe200078e780dULL, 0x000000080d0b7824ULL, 0x000fe200078e0208ULL,
0x000000070a0c7812ULL, 0x000fe200078e780dULL, 0x0000000815137824ULL, 0x000fe200078e0206ULL,
0x0000000702027812ULL, 0x100fe200078e7815ULL, 0x0000000803067824ULL, 0x000fe200078e00ffULL,
0x0000000704047812ULL, 0x100fe200078e7815ULL, 0x000000080d077824ULL, 0x000fe200078e0200ULL,
0x000000070a0a7812ULL, 0x000fe200078e7815ULL, 0x00000008150f7824ULL, 0x040fe200078e0202ULL,
0x0000000806067812ULL, 0x000fe200078ec0ffULL, 0x0000000815117824ULL, 0x000fe200078e0204ULL,
0x000000141702723eULL, 0x000fe200000000ffULL, 0x0000080050007824ULL, 0x000fe200078e0205ULL,
0x000000202104723eULL, 0x000fe200000000ffULL, 0x000000080d0d7824ULL, 0x000fc400078e020cULL,
0x0000000815157824ULL, 0x000fe200078e020aULL, 0x0000541002167816ULL, 0x040fe20000000004ULL,
0x0000001007077824ULL, 0x000fe200078e0200ULL, 0x0000763202177816ULL, 0x000fe20000000004ULL,
0x0000001009097824ULL, 0x100fe200078e0200ULL, 0x000000271802723eULL, 0x000fe200000000ffULL,
0x000000100b0b7824ULL, 0x100fe200078e0200ULL, 0x0000002b2404723eULL, 0x000fe200000000ffULL,
0x000000100f0f7824ULL, 0x100fe400078e0200ULL, 0x0000001011117824ULL, 0x000fc400078e0200ULL,
0x000000100d0d7824ULL, 0x100fe400078e0200ULL, 0x0000001013137824ULL, 0x100fe400078e0200ULL,
0x0000001015157824ULL, 0x000fe400078e0200ULL, 0x0000000107087824ULL, 0x000fe200078e0206ULL,
0x000000101b07723eULL, 0x000fe200000000ffULL, 0x0000000106097824ULL, 0x040fe400078e0209ULL,
0x00000001060b7824ULL, 0x040fe200078e020bULL, 0x0000001608007388ULL, 0x0005e20000000a00ULL,
0x00000001060f7824ULL, 0x000fc400078e020fULL, 0x0000000106117824ULL, 0x040fe400078e0211ULL,
0x00000001060d7824ULL, 0x040fe400078e020dULL, 0x0000000106137824ULL, 0x040fe400078e0213ULL,
0x0000000106157824ULL, 0x000fe200078e0215ULL, 0x0000001c1d06723eULL, 0x000fe200000000ffULL,
0x000000013e0a7824ULL, 0x000fe200078e0203ULL, 0x0000541002087816ULL, 0x004fe20000000004ULL,
0x00000300ff147624ULL, 0x000fe200078e00ffULL, 0x0000541006167816ULL, 0x000fc40000000007ULL,
0x0000763206177816ULL, 0x000fe40000000007ULL, 0x0000002f2a06723eULL, 0x000fe400000000ffULL,
0x000000332e07723eULL, 0x000fe200000000ffULL, 0x0000001609007388ULL, 0x0005e20000000a00ULL,
0x000000011400780cULL, 0x000fe40003f05270ULL, 0x0000763202097816ULL, 0x004fe40000000004ULL,
0x000000190e02723eULL, 0x000fc400000000ffULL, 0x000000222304723eULL, 0x000fe200000000ffULL,
0x000000080b007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x004fe20000000007ULL,
0x000000100a0b7824ULL, 0x000fe200078e0205ULL, 0x0000763206097816ULL, 0x000fe40000000007ULL,
0x0000001e1f06723eULL, 0x000fe400000000ffULL, 0x000000122507723eULL, 0x000fe200000000ffULL,
0x000000080d007388ULL, 0x0005e40000000a00ULL, 0x0000541002087816ULL, 0x004fc40000000004ULL,
0x0000763202097816ULL, 0x000fe40000000004ULL, 0x000000291a02723eULL, 0x000fe400000000ffULL,
0x0000002d2804723eULL, 0x000fe200000000ffULL, 0x000000080f007388ULL, 0x0005e40000000a00ULL,
0x0000541006087816ULL, 0x144fe40000000007ULL, 0x0000763206097816ULL, 0x000fe40000000007ULL,
0x000000312c06723eULL, 0x000fc400000000ffULL, 0x000000353007723eULL, 0x000fe200000000ffULL,
0x0000000811007388ULL, 0x0005e40000000a00ULL, 0x0000541002087816ULL, 0x144fe40000000004ULL,
0x0000763202097816ULL, 0x000fca0000000004ULL, 0x0000000813007388ULL, 0x0005e40000000a00ULL,
0x0000541006087816ULL, 0x144fe40000000007ULL, 0x0000763206097816ULL, 0x000fca0000000007ULL,
0x0000000815007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000000b0c7984ULL, 0x000ea80000000c00ULL, 0x000400000b1c7984ULL, 0x000ee80000000c00ULL,
0x000800000b187984ULL, 0x000f280000000c00ULL, 0x000c00000b207984ULL, 0x000e620000000c00ULL,
0x200000ff0f0f7230ULL, 0x004fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x008fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fc40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x0000001b0f0f7230ULL, 0x010fe40000000000ULL, 0x0000001a0e0e7230ULL, 0x000fe40000000000ULL,
0x000000190d0d7230ULL, 0x000fe40000000000ULL, 0x000000180c0c7230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x002fc40000000000ULL, 0x000000221e1e7230ULL, 0x000fe20000000000ULL,
0x0000000c0b007388ULL, 0x0003e20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fca0000000000ULL, 0x0004001c0b007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00002f1000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x002e620000002700ULL, 0x0000580014027a24ULL, 0x000fe200078e02ffULL,
0x0000000150ff7812ULL, 0x000fe2000780f826ULL, 0x00000800ff097424ULL, 0x000fe200078e00ffULL,
0x0000000000077919ULL, 0x000e620000002600ULL, 0x0000660002067a24ULL, 0x000fe200078e02ffULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000004003f047824ULL, 0x000fe200078e00ffULL,
0x000000000b107984ULL, 0x0004e20000000c00ULL, 0x000000ff0300720cULL, 0x000fc40000725670ULL,
0x000007ff06027811ULL, 0x040fe400078e40ffULL, 0x01ffffff06067812ULL, 0x000fe200078ec0ffULL,
0x000058000e0e7a24ULL, 0x002fc800078e0207ULL, 0x000003000e077a24ULL, 0x000fca00078e02ffULL,
0x00000004070f7c10ULL, 0x000fc8000fffe0ffULL, 0x0000000f02087211ULL, 0x000fca00078fa8ffULL,
0x00006c0008087625ULL, 0x000fca00078e0009ULL, 0x00000004080c7210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fc800010e0609ULL, 0x000000100a0c7825ULL, 0x000fe200078e000cULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x0000001003087824ULL, 0x00cfe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000010f0a7824ULL, 0x000fe200078e0206ULL, 0x0000007008157812ULL, 0x000fe400078ec0ffULL,
0x0000000c09167812ULL, 0x000fe200078ec0ffULL, 0x00006c000f087625ULL, 0x000fc800078e000bULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000816087210ULL, 0x000fc80007a1e015ULL,
0x0000000a160a7210ULL, 0x000fe40007c7e015ULL, 0x00000009ff097210ULL, 0x000fe400007e44ffULL,
0x0000000bff0b7210ULL, 0x000fc60001fe84ffULL, 0x0000003b08007986ULL, 0x0003e8000c101906ULL,
0x0000003a0a007986ULL, 0x0003e4000c101906ULL, 0x0000000000007941ULL, 0x00cfea0003800000ULL,
0x000000100c007986ULL, 0x0005e2000c101d06ULL, 0x0000011000007945ULL, 0x000fe60003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff097424ULL, 0x002fe200078e00ffULL, 0xffffffff140b7810ULL, 0x000fc60007ffe0ffULL,
0x00006a000e087625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000b080879a8ULL, 0x000ee400099ee1c6ULL,
0x0000000b0800720cULL, 0x008fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff0a7807ULL, 0x000fca0000000000ULL, 0x0000000aff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff087984ULL, 0x002e640000000000ULL, 0x000000ff0800720cULL, 0x002fda0003f05270ULL,
0x00002b6000008947ULL, 0x000fea0003800000ULL, 0x000000ff2600720cULL, 0x000fda0003f05270ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0000001003087824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011603ULL, 0x00000080ff177424ULL, 0x000fe200078e00ffULL,
0x00000001070a7810ULL, 0x000fe40007ffe0ffULL, 0x0000007008197812ULL, 0x000fe400078ec0ffULL,
0x0000000c090e7812ULL, 0x000fe200078ec0ffULL, 0x00006c0007087625ULL, 0x000fc800078e0017ULL,
0x00006c000a0a7625ULL, 0x000fe200078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x0000000a0e0a7210ULL, 0x000fe40007b5e019ULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x00000006080c7981ULL, 0x004368000c1e1900ULL,
0x000000060a0d7981ULL, 0x000362000c1e1900ULL, 0x000000021400780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000207087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080f7981ULL, 0x000362000c1e1900ULL,
0x000000041400780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000307087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608117981ULL, 0x000362000c1e1900ULL, 0x000000041400780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000407087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608137981ULL, 0x000362000c1e1900ULL,
0x000000061400780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000507087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608157981ULL, 0x000362000c1e1900ULL, 0x000000061400780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081400780cULL, 0x002fe40003f06070ULL,
0x0000000607087810ULL, 0x000fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fe40007a3e019ULL, 0x00000007070a0810ULL, 0x000fe40007ffe0ffULL,
0x00000009ff097210ULL, 0x000fc60000fe44ffULL, 0x00006c000a0a0625ULL, 0x000fe400078e0017ULL,
0x0000000608177981ULL, 0x000366000c1e1900ULL, 0x0000000a0e0a0210ULL, 0x000fc80007c7e019ULL,
0x0000000bff0b0210ULL, 0x000fcc0001fe84ffULL, 0x000000060a0b0981ULL, 0x000366000c1e1900ULL,
0x0000000714087810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0a7819ULL, 0x000fc80000011608ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff197224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x020fe400078e000cULL,
0x00000008190e7824ULL, 0x040fe200078e00ffULL, 0x0000000119197810ULL, 0x000fc80007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x0000000a1900720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080e087810ULL, 0x040fe40007ffe0ffULL,
0x000000010e097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001b0c0c7209ULL, 0x004fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x00000070101b7812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x000fc80007b3e01bULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006081b7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090e087810ULL, 0x042fe40007ffe0ffULL, 0x000000020e097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000d0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030d7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e00dULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080d7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0e087810ULL, 0x042fe40007ffe0ffULL,
0x000000030e097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000f0c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e00fULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080f7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0e087810ULL, 0x042fe40007ffe0ffULL, 0x000000040e097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000110c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010117812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e011ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608117981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0e087810ULL, 0x042fe40007ffe0ffULL,
0x000000050e097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000130c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010137812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x000fc80007b3e013ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608137981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0e087810ULL, 0x042fe40007ffe0ffULL, 0x000000060e097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000150c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010157812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e015ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608157981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0e087810ULL, 0x042fe40007ffe0ffULL,
0x000000070e097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000170c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010177812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x000fc80007b3e017ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608177981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0e087810ULL, 0x002fe40007ffe0ffULL, 0x0000000b0c0c7209ULL, 0x000fe40007810000ULL,
0x0000030008007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030b7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000080e087210ULL, 0x000fc80007a3e00bULL,
0x00000009ff097210ULL, 0x000fca0000fe44ffULL, 0x00000006080b7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ee40000000000ULL,
0x0000001003087824ULL, 0x00afe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011603ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fca00078ec0ffULL,
0x0000000109097824ULL, 0x000fca00078e0208ULL, 0x0000000c09007388ULL, 0x0203e40000000800ULL,
0x0000001003097824ULL, 0x042fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011603ULL,
0x0000000150117824ULL, 0x004fe200078e0207ULL, 0x000000070300780cULL, 0x000fe20003f04070ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000070090a7812ULL, 0x000fe200078ec0ffULL,
0x00000800ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000013c3c7824ULL, 0x000fe200078e0205ULL, 0x0000001102087211ULL, 0x000fe200078fa8ffULL,
0x000010e000007945ULL, 0x000fe20003800000ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000010b307824ULL, 0x000fe200078e020aULL, 0x00000001430a7812ULL, 0x040fe200078ec0ffULL,
0x0000080043437824ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00006c0008087625ULL, 0x000fe200078e000dULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000080043437812ULL, 0x000fe200078ec0ffULL,
0x00000002500b8824ULL, 0x100fe200078e023fULL, 0x0000000408087210ULL, 0x000fe20007f3e0ffULL,
0x00000002500d8824ULL, 0x000fe200078e023fULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000001060e8824ULL, 0x000fe200078e0211ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000080ff0f8424ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000020b0c8824ULL, 0x100fe200078e020aULL, 0x0000000030307984ULL, 0x000e620000000800ULL,
0x00000080ff108424ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000020d128824ULL, 0x000fe200078e020aULL, 0x00000020030d7810ULL, 0x000fe20007ffe0ffULL,
0x000000013c0a7824ULL, 0x000fc400078e0243ULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x0000030050007a0cULL, 0x000fe20003f26070ULL, 0x00006c000e0e8625ULL, 0x000fc800078e000fULL,
0x00006c0011108625ULL, 0x000fc800078e0010ULL, 0x000000080c158824ULL, 0x100fe400078e0203ULL,
0x0000000812128824ULL, 0x000fe400078e0203ULL, 0x0000001003137824ULL, 0x000fe200078e020aULL,
0x0000458015158811ULL, 0x000fe200078e20ffULL, 0x00000010030a7825ULL, 0x000fe200078e0008ULL,
0x0000418012178811ULL, 0x000fc600078e20ffULL, 0x000000100d0c7825ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000a137faeULL, 0x0005e2000b901c46ULL,
0x0000000000087805ULL, 0x000fe4000001ff00ULL, 0x00000010030e8825ULL, 0x040fe200078e000eULL,
0x003800000c137faeULL, 0x0007e6000b901c46ULL, 0x0000001003108825ULL, 0x000fe200078e0010ULL,
0x000000000e158faeULL, 0x0009e6000b901c46ULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0x0000000010178faeULL, 0x0003e2000b901c46ULL, 0x00000000000a7805ULL, 0x004fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000c7805ULL, 0x008fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x010fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x002fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000d6000001947ULL, 0x000fea0003800000ULL,
0x000000ffff087224ULL, 0x000fe400078e00ffULL, 0x000000ffff327224ULL, 0x000fca00078e0050ULL,
0x0000000232347810ULL, 0x000fe20007ffe0ffULL, 0x0000029000017945ULL, 0x000fe60003800000ULL,
0x0000030034007a0cULL, 0x000fda0003f06070ULL, 0x0000026000000947ULL, 0x000fea0003800000ULL,
0x000000070300780cULL, 0x000fe20003f24070ULL, 0x00000001072f7824ULL, 0x100fe200078e0234ULL,
0x00000001ff287819ULL, 0x000fe20000011634ULL, 0x00000800ff2e7424ULL, 0x000fe200078e00ffULL,
0x0000002003377810ULL, 0x000fe20007ffe0ffULL, 0x00000400342a7824ULL, 0x000fe200078e00ffULL,
0x0000002f02297211ULL, 0x000fe400078fa8ffULL, 0x00000001282c7812ULL, 0x000fc600078ec0ffULL,
0x00006c0029287625ULL, 0x000fc800078e002eULL, 0x00000002502d9824ULL, 0x000fe200078e023fULL,
0x0000000428287210ULL, 0x000fe20007f1e0ffULL, 0x00000001062b9824ULL, 0x000fe400078e022fULL,
0x000000022d369824ULL, 0x100fe200078e022cULL, 0x000008002a2d7812ULL, 0x000fe200078ec0ffULL,
0x0000000250339824ULL, 0x000fe400078e023fULL, 0x00000080ff2e9424ULL, 0x000fe400078e00ffULL,
0x00000002333a9824ULL, 0x000fc400078e022cULL, 0x00006c002b2a9625ULL, 0x000fc800078e002eULL,
0x00000080ff389424ULL, 0x000fe400078e00ffULL, 0x000000013c2c7824ULL, 0x000fe400078e022dULL,
0x000000ffff297224ULL, 0x000fe400000e0629ULL, 0x00006c002f2e9625ULL, 0x000fc800078e0038ULL,
0x0000001003337824ULL, 0x040fe400078e022cULL, 0x0000000836359824ULL, 0x000fe400078e0203ULL,
0x00000010032c9825ULL, 0x000fc600078e002aULL, 0x0000458035359811ULL, 0x000fe200078e20ffULL,
0x000000083a3a9824ULL, 0x000fe400078e0203ULL, 0x00000010372a7825ULL, 0x000fc600078e0028ULL,
0x000041803a379811ULL, 0x000fe200078e20ffULL, 0x0000001003287825ULL, 0x000fc800078e0028ULL,
0x00000010032e9825ULL, 0x000fe200078e002eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000028337faeULL, 0x0003e8000b901c46ULL, 0x003800002a337faeULL, 0x0003e8000b901c46ULL,
0x000000002c359faeULL, 0x0003e8000b901c46ULL, 0x000000002e379faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff2d7224ULL, 0x002fe200078e0032ULL, 0x00000001ff2a7819ULL, 0x000fe20000011603ULL,
0x00000002502b7824ULL, 0x000fe200078e023fULL, 0x00000002ff337819ULL, 0x000fe20000011603ULL,
0x000000402d287824ULL, 0x000fe200078e00ffULL, 0x0000000c2a2a7812ULL, 0x000fe200078ec0ffULL,
0x0000001003297824ULL, 0x000fe200078e00ffULL, 0x00000007333a7812ULL, 0x040fe200078ec0ffULL,
0x00000008332f7824ULL, 0x040fe200078e00ffULL, 0x0000008028287812ULL, 0x000fe200078ec0ffULL,
0x0000000833357824ULL, 0x000fe200078e00ffULL, 0x0000007029297812ULL, 0x000fc400078ec0ffULL,
0x00000033ff407212ULL, 0x020fe200078e33ffULL, 0x000001002b287824ULL, 0x000fc600078e0028ULL,
0xfffffff835407812ULL, 0x000fe400078ee240ULL, 0x000000282a2a7210ULL, 0x000fe20007ffe029ULL,
0x0000000833297824ULL, 0x000fe200078e00ffULL, 0xfffffff82f287812ULL, 0x000fe200078ee23aULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180002a2b7984ULL, 0x000e620000000800ULL,
0x00000001292c7812ULL, 0x140fe400078ef63aULL, 0x00000002292e7812ULL, 0x140fe200078ef63aULL,
0x004580002a527984ULL, 0x0004e20000000800ULL, 0x0000000329327812ULL, 0x140fe400078ef63aULL,
0x0000000429367812ULL, 0x140fe400078ef63aULL, 0x0000000529387812ULL, 0x140fe400078ef63aULL,
0x00000006293a7812ULL, 0x000fe200078ef63aULL, 0x000004002d297824ULL, 0x000fe200078e00ffULL,
0x0000000833357810ULL, 0x000fe20007ffe0ffULL, 0x00000004032a7824ULL, 0x004fc600078e00ffULL,
0x0000080029297812ULL, 0x000fe200078ec0ffULL, 0x0000000835447824ULL, 0x040fe200078e00ffULL,
0x00000007352d7812ULL, 0x040fe200078ec0ffULL, 0x0000000835427824ULL, 0x040fe200078e00ffULL,
0x000001803c297810ULL, 0x000fe20007ffe029ULL, 0x0000000835377824ULL, 0x000fe200078e00ffULL,
0x00000035ff4e7212ULL, 0x000fe400078e33ffULL, 0x0000000242467812ULL, 0x000fe200078ef62dULL,
0x0000001028287824ULL, 0x000fe200078e0229ULL, 0x0000000342487812ULL, 0x000fe200078ef62dULL,
0x0000001040407824ULL, 0x000fe200078e0229ULL, 0x00000004424a7812ULL, 0x000fe200078ef62dULL,
0x000000102c2c7824ULL, 0x000fe200078e0229ULL, 0x00000005424c7812ULL, 0x000fe200078ef62dULL,
0x0000001032327824ULL, 0x100fe200078e0229ULL, 0xfffffff8374e7812ULL, 0x000fe200078ee24eULL,
0x000000102e2e7824ULL, 0x000fc400078e0229ULL, 0x0000001038387824ULL, 0x100fe400078e0229ULL,
0x0000001036367824ULL, 0x000fe200078e0229ULL, 0x0000002b302b7221ULL, 0x002fe20000010100ULL,
0x000000103a3a7824ULL, 0x100fe400078e0229ULL, 0x0000001046467824ULL, 0x100fe200078e0229ULL,
0x3fb8aa3b2b2f7820ULL, 0x000fe20000410000ULL, 0x0000000c2a2b7812ULL, 0x000fe200078ec0ffULL,
0x0000001048487824ULL, 0x000fe200078e0229ULL, 0xfffffff8442a7812ULL, 0x000fe200078ee22dULL,
0x000000104a4a7824ULL, 0x000fe200078e0229ULL, 0x0000000142447812ULL, 0x000fe200078ef62dULL,
0x0000000128287824ULL, 0x000fe200078e022bULL, 0x0000002f002f7308ULL, 0x000ee20000000800ULL,
0x000000012b407824ULL, 0x040fe200078e0240ULL, 0x0000000642427812ULL, 0x000fe200078ef62dULL,
0x000000012b2c7824ULL, 0x000fc400078e022cULL, 0x0000000028287984ULL, 0x000e620000000800ULL,
0x000000012b327824ULL, 0x040fe400078e0232ULL, 0x000000012b2e7824ULL, 0x040fe200078e022eULL,
0x0000000040407984ULL, 0x000ea20000000800ULL, 0x000000012b387824ULL, 0x040fe400078e0238ULL,
0x000000012b367824ULL, 0x040fe200078e0236ULL, 0x000000002c2c7984ULL, 0x000fe20000000800ULL,
0x000000012b3a7824ULL, 0x000fe200078e023aULL, 0x000000522f547220ULL, 0x008fc40000410000ULL,
0x0000000032327984ULL, 0x000fe20000000800ULL, 0x000000102a2a7824ULL, 0x100fe400078e0229ULL,
0x0000001044447824ULL, 0x000fe200078e0229ULL, 0x000000002e2e7984ULL, 0x000fe20000000800ULL,
0x000000012b2a7824ULL, 0x040fe200078e022aULL, 0x0000003154317221ULL, 0x000fe20000010000ULL,
0x000000012b447824ULL, 0x040fe200078e0244ULL, 0x0000000038387984ULL, 0x000fe20000000800ULL,
0x000000012b467824ULL, 0x040fe400078e0246ULL, 0x000000012b487824ULL, 0x000fe200078e0248ULL,
0x00001f33542d7589ULL, 0x000ee200000e0000ULL, 0x000000104c4c7824ULL, 0x000fc400078e0229ULL,
0x0000001042427824ULL, 0x100fe200078e0229ULL, 0x0000000036367984ULL, 0x000f220000000800ULL,
0x000000104e4e7824ULL, 0x000fe400078e0229ULL, 0x000000012b4a7824ULL, 0x040fe200078e024aULL,
0x000000003a3a7984ULL, 0x000f220000000800ULL, 0x000000012b4c7824ULL, 0x040fe400078e024cULL,
0x000000012b427824ULL, 0x040fe200078e0242ULL, 0x000000002a2a7984ULL, 0x000f220000000800ULL,
0x000000012b4e7824ULL, 0x000fc600078e024eULL, 0x0000000044447984ULL, 0x000f220000000800ULL,
0x20000028ff527230ULL, 0x102fe40000004100ULL, 0x30000028ff2b7230ULL, 0x000fe20000004100ULL,
0x0000000046467984ULL, 0x000e620000000800ULL, 0x20000040ff287230ULL, 0x104fe40000004100ULL,
0x30000040ff2f7230ULL, 0x000fe20000004100ULL, 0x0000000048487984ULL, 0x000fe20000000800ULL,
0x0000002d2b267223ULL, 0x088fe20000010026ULL, 0x0000002d28197223ULL, 0x080fe20000010019ULL,
0x2000002cff287230ULL, 0x100fe20000004100ULL, 0x000000004a4a7984ULL, 0x000fe20000000800ULL,
0x3000002cff2b7230ULL, 0x000fe20000004100ULL, 0x0000002d2f187223ULL, 0x080fe20000010018ULL,
0x0000002d52277223ULL, 0x080fe20000010027ULL, 0x000000004c4c7984ULL, 0x000fe20000000800ULL,
0x0000002d28257223ULL, 0x080fe20000010025ULL, 0x20000032ff287230ULL, 0x000fe20000004100ULL,
0x0000002d2b247223ULL, 0x000fe20000010024ULL, 0x0000000042427984ULL, 0x000fe20000000800ULL,
0x3000002eff2f7230ULL, 0x000fc40000004100ULL, 0x0000002d28217223ULL, 0x080fe20000010021ULL,
0x000000004e4e7984ULL, 0x000fe20000000800ULL, 0x30000032ff2b7230ULL, 0x000fe20000004100ULL,
0x0000002d2f227223ULL, 0x080fe20000010022ULL, 0x20000038ff287230ULL, 0x000fe20000004100ULL,
0x00001f3554297589ULL, 0x000ea200000e0000ULL, 0x2000002eff2c7230ULL, 0x000fe20000004100ULL,
0x0000002d2b207223ULL, 0x080fe20000010020ULL, 0x30000036ff2f7230ULL, 0x010fe20000004100ULL,
0x0000002d281d7223ULL, 0x080fe2000001001dULL, 0x30000038ff2b7230ULL, 0x000fe20000004100ULL,
0x0000002d2c237223ULL, 0x080fe20000010023ULL, 0x2000003aff287230ULL, 0x000fe20000004100ULL,
0x0000002d2f1e7223ULL, 0x080fe2000001001eULL, 0x20000036ff2c7230ULL, 0x000fe20000004100ULL,
0x0000002d2b1c7223ULL, 0x080fe2000001001cULL, 0x3000003aff2f7230ULL, 0x000fe20000004100ULL,
0x0000002d281b7223ULL, 0x080fe2000001001bULL, 0x3000002aff2b7230ULL, 0x000fe20000004100ULL,
0x0000002d2c1f7223ULL, 0x080fe2000001001fULL, 0x20000044ff287230ULL, 0x000fe20000004100ULL,
0x0000002d2f1a7223ULL, 0x000fe2000001001aULL, 0x000000ffff327224ULL, 0x000fc400078e0034ULL,
0x2000002aff2c7230ULL, 0x000fe40000004100ULL, 0x20000046ff2a7230ULL, 0x102fe20000004100ULL,
0x0000030032007a0cULL, 0x000fe20003f06070ULL, 0x30000046ff2d7230ULL, 0x000fe20000004100ULL,
0x000000292b167223ULL, 0x084fe20000010016ULL, 0x0000002928157223ULL, 0x080fe20000010015ULL,
0x30000044ff2b7230ULL, 0x000fe20000004100ULL, 0x000000292a137223ULL, 0x080fe20000010013ULL,
0x20000048ff287230ULL, 0x000fe20000004100ULL, 0x000000292d127223ULL, 0x080fe20000010012ULL,
0x3000004aff2d7230ULL, 0x000fe20000004100ULL, 0x000000292b147223ULL, 0x080fe20000010014ULL,
0x30000048ff2b7230ULL, 0x000fe20000004100ULL, 0x0000002928117223ULL, 0x080fe20000010011ULL,
0x2000004aff287230ULL, 0x000fe20000004100ULL, 0x000000292d0e7223ULL, 0x080fe2000001000eULL,
0x2000004cff2a7230ULL, 0x100fe20000004100ULL, 0x000000292b107223ULL, 0x080fe20000010010ULL,
0x3000004cff2b7230ULL, 0x000fe20000004100ULL, 0x00000029280f7223ULL, 0x080fe2000001000fULL,
0x20000042ff287230ULL, 0x100fe20000004100ULL, 0x000000292a0d7223ULL, 0x080fe2000001000dULL,
0x30000042ff2d7230ULL, 0x000fe20000004100ULL, 0x000000292c177223ULL, 0x080fe20000010017ULL,
0x2000004eff2a7230ULL, 0x100fe20000004100ULL, 0x000000292b0c7223ULL, 0x080fe2000001000cULL,
0x3000004eff2f7230ULL, 0x000fe20000004100ULL, 0x00000029280b7223ULL, 0x080fe2000001000bULL,
0x000000292d0a7223ULL, 0x080fe2000001000aULL, 0x000000292a097223ULL, 0x000fc40000010009ULL,
0x000000292f087223ULL, 0x000fe20000010008ULL, 0xfffff2c000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x000000ff3f00720cULL, 0x000fe20003f05270ULL, 0x0000001002037824ULL, 0x002fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011602ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c02027812ULL, 0x000fca00078ec0ffULL, 0x0000000102047824ULL, 0x000fe200078e0203ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x0000001002037824ULL, 0x002fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fc80000011602ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c02077812ULL, 0x000fc600078ec0ffULL,
0x0000008050027824ULL, 0x000fc800078e0203ULL, 0x0000000107027824ULL, 0x000fca00078e0202ULL,
0x0049803102007388ULL, 0x0003e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0x0049800004027984ULL, 0x002e680000000800ULL,
0x004a000004037984ULL, 0x000ea20000000800ULL, 0x00000002ff027221ULL, 0x002fc80000010000ULL,
0x0000000302027221ULL, 0x004fca0000010000ULL, 0x0180000002037810ULL, 0x000fc80007ffe0ffULL,
0x7f80000003037812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0002ULL, 0x00009b9000067802ULL, 0x000fe40000000f00ULL,
0x00005e5000007944ULL, 0x020fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000200037308ULL, 0x000e640000001000ULL, 0xbf80000002047423ULL, 0x002fc80000000003ULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x0000000403047223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000008032d7811ULL, 0x004fe200078ff0ffULL,
0x000000013e3e7824ULL, 0x100fe200078e0203ULL, 0x00000002ff2b7819ULL, 0x000fe40000011603ULL,
0x0000002dff297212ULL, 0x000fe200078e33ffULL, 0x00001f2d04067589ULL, 0x000ea200000e0000ULL,
0x000000082d2e7824ULL, 0x000fc400078e00ffULL, 0x000000082b2f7824ULL, 0x000fe200078e00ffULL,
0x00001f2b04027589ULL, 0x00072200000e0000ULL, 0x000000103e3e7824ULL, 0x000fe200078e0205ULL,
0x0000002bff047212ULL, 0x008fc800078e33ffULL, 0xfffffff82f2f7812ULL, 0x000fe400078ee204ULL,
0x000000072b047812ULL, 0x040fe200078ec0ffULL, 0x0000001706177220ULL, 0x044fe20000410000ULL,
0x0000001606167220ULL, 0x040fe20000410000ULL, 0x0000001506157220ULL, 0x040fe20000410000ULL,
0x0000001406147220ULL, 0x040fe20000410000ULL, 0x0000001306137220ULL, 0x040fe20000410000ULL,
0x0000001206127220ULL, 0x040fe20000410000ULL, 0x0000001106117220ULL, 0x040fe20000410000ULL,
0x0000001006107220ULL, 0x040fe20000410000ULL, 0x0000000f060f7220ULL, 0x040fe20000410000ULL,
0x0000000e060e7220ULL, 0x040fe20000410000ULL, 0x0000000d060d7220ULL, 0x040fe20000410000ULL,
0x0000000c060c7220ULL, 0x040fe20000410000ULL, 0x0000000b060b7220ULL, 0x040fe20000410000ULL,
0x0000000a060a7220ULL, 0x040fe20000410000ULL, 0x0000000906097220ULL, 0x000fe20000410000ULL,
0x0000002702277220ULL, 0x050fe20000410000ULL, 0x0000002602267220ULL, 0x040fe20000410000ULL,
0x0000002502257220ULL, 0x040fe20000410000ULL, 0x0000002402247220ULL, 0x040fe20000410000ULL,
0x0000002302237220ULL, 0x040fe20000410000ULL, 0x0000002202227220ULL, 0x040fe20000410000ULL,
0x0000002102217220ULL, 0x040fe20000410000ULL, 0x0000002002207220ULL, 0x040fe20000410000ULL,
0x0000001f021f7220ULL, 0x040fe20000410000ULL, 0x0000001e021e7220ULL, 0x040fe20000410000ULL,
0x0000001d021d7220ULL, 0x040fe20000410000ULL, 0x0000001c021c7220ULL, 0x040fe20000410000ULL,
0x0000001b021b7220ULL, 0x040fe20000410000ULL, 0x0000001a021a7220ULL, 0x040fe20000410000ULL,
0x0000001902197220ULL, 0x000fe20000410000ULL, 0x0000000806067220ULL, 0x000fe20000410000ULL,
0x0000001802027220ULL, 0x000fe20000410000ULL, 0x000000082b087824ULL, 0x000fe200078e00ffULL,
0x000000252424723eULL, 0x000fe200000000ffULL, 0x000000082d187824ULL, 0x000fe200078e00ffULL,
0x0000000304287812ULL, 0x000fe200078e3cffULL, 0x0000000403257824ULL, 0x000fe200078e00ffULL,
0xfffffff808077812ULL, 0x000fc400078ee22bULL, 0xfffffff818297812ULL, 0x000fe400078ee229ULL,
0x0000000104087812ULL, 0x040fe200078e3cffULL, 0x0000001007077824ULL, 0x100fe200078e0200ULL,
0x0000000204187812ULL, 0x040fe200078e3cffULL, 0x0000001029297824ULL, 0x000fe200078e0200ULL,
0x00000004042a7812ULL, 0x040fe400078e3cffULL, 0x00000005042c7812ULL, 0x040fe400078e3cffULL,
0x0000000604047812ULL, 0x000fc400078e3cffULL, 0x000000232222723eULL, 0x000fe400000000ffULL,
0x000000090606723eULL, 0x000fe200000000ffULL, 0x000000082b097824ULL, 0x000fe200078e0208ULL,
0x000000072d237812ULL, 0x000fe400078ec0ffULL, 0x0000000d0c0c723eULL, 0x000fe200000000ffULL,
0x000000082b0d7824ULL, 0x040fe200078e0228ULL, 0x0000000b0a0a723eULL, 0x000fe200000000ffULL,
0x000000082b0b7824ULL, 0x040fe200078e0218ULL, 0x000000131212723eULL, 0x000fe200000000ffULL,
0x000000082b137824ULL, 0x040fe200078e0204ULL, 0x0000000f0e0e723eULL, 0x000fe200000000ffULL,
0x000000082b0f7824ULL, 0x000fe200078e022aULL, 0x0000000c25287812ULL, 0x000fe200078ec0ffULL,
0x0000001009097824ULL, 0x000fe200078e0200ULL, 0x000000111010723eULL, 0x000fe200000000ffULL,
0x000000082b117824ULL, 0x000fe200078e022cULL, 0x0000000123047812ULL, 0x000fe200078e3cffULL,
0x000000100b0b7824ULL, 0x100fe200078e0200ULL, 0x0000000223087812ULL, 0x000fe200078e3cffULL,
0x000000100d0d7824ULL, 0x100fe200078e0200ULL, 0x0000001b1a1a723eULL, 0x000fe200000000ffULL,
0x0000000128077824ULL, 0x000fe200078e0207ULL, 0x000000151414723eULL, 0x000fe200000000ffULL,
0x000000100f0f7824ULL, 0x100fe200078e0200ULL, 0x0000000323187812ULL, 0x000fe200078e3cffULL,
0x0000001011117824ULL, 0x100fe200078e0200ULL, 0x000000212020723eULL, 0x000fe200000000ffULL,
0x0000000128097824ULL, 0x000fe200078e0209ULL, 0xfffffff82e157812ULL, 0x000fe200078ee22dULL,
0x0000001013137824ULL, 0x000fe200078e0200ULL, 0x00000004231b7812ULL, 0x000fe200078e3cffULL,
0x00000001280b7824ULL, 0x000fe200078e020bULL, 0x000000272626723eULL, 0x000fe200000000ffULL,
0x00000001280d7824ULL, 0x000fe200078e020dULL, 0x000000171616723eULL, 0x000fe200000000ffULL,
0x000000082d177824ULL, 0x000fe200078e0204ULL, 0x0000000523217812ULL, 0x000fe200078e3cffULL,
0x000000102f047824ULL, 0x000fe200078e0200ULL, 0x000000190202723eULL, 0x000fe200000000ffULL,
0x000000082d197824ULL, 0x000fe200078e0208ULL, 0x0000000623237812ULL, 0x000fe200078e3cffULL,
0x0000001015087824ULL, 0x000fe200078e0200ULL, 0x0000001d1c1c723eULL, 0x000fe200000000ffULL,
0x000000082d1d7824ULL, 0x040fe200078e0218ULL, 0x0000001f1e1e723eULL, 0x000fe200000000ffULL,
0x000000082d1f7824ULL, 0x000fe200078e021bULL, 0x0000002607007388ULL, 0x000fe20000000800ULL,
0x00000001280f7824ULL, 0x000fc400078e020fULL, 0x000000082d217824ULL, 0x000fe200078e0221ULL,
0x0000002409007388ULL, 0x000fe20000000800ULL, 0x0000001017187824ULL, 0x100fe400078e0200ULL,
0x0000000128117824ULL, 0x040fe200078e0211ULL, 0x000000220b007388ULL, 0x000fe20000000800ULL,
0x000000082d237824ULL, 0x000fe400078e0223ULL, 0x00000010191b7824ULL, 0x000fe200078e0200ULL,
0x000000200d007388ULL, 0x000fe20000000800ULL, 0x0000000128137824ULL, 0x000fc400078e0213ULL,
0x000000101d1d7824ULL, 0x000fe200078e0200ULL, 0x0000001e0f007388ULL, 0x000fe20000000800ULL,
0x0000000128157824ULL, 0x040fe400078e0204ULL, 0x000000101f1f7824ULL, 0x000fe200078e0200ULL,
0x0000001c11007388ULL, 0x000fe20000000800ULL, 0x0000000128177824ULL, 0x040fe400078e0208ULL,
0x0000001021217824ULL, 0x000fe200078e0200ULL, 0x0000001a13007388ULL, 0x000fe20000000800ULL,
0x0000000128197824ULL, 0x000fc400078e0218ULL, 0x0000001023237824ULL, 0x000fe200078e0200ULL,
0x0000000215007388ULL, 0x000fe20000000800ULL, 0x00000001281b7824ULL, 0x040fe400078e021bULL,
0x00000001281d7824ULL, 0x040fe200078e021dULL, 0x0000001617007388ULL, 0x000fe20000000800ULL,
0x00000001281f7824ULL, 0x040fe400078e021fULL, 0x0000000128217824ULL, 0x040fe200078e0221ULL,
0x0000001419007388ULL, 0x000fe20000000800ULL, 0x0000000128237824ULL, 0x000fc400078e0223ULL,
0x0000000128297824ULL, 0x000fe200078e0229ULL, 0x000000121b007388ULL, 0x000fe80000000800ULL,
0x000000101d007388ULL, 0x000fe80000000800ULL, 0x0000000e1f007388ULL, 0x000fe80000000800ULL,
0x0000000c21007388ULL, 0x000fe80000000800ULL, 0x0000000a23007388ULL, 0x000fe80000000800ULL,
0x0000000629007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000003e247984ULL, 0x000ea80000000c00ULL, 0x000400003e2c7984ULL, 0x000ee80000000c00ULL,
0x000800003e147984ULL, 0x000f280000000c00ULL, 0x000c00003e187984ULL, 0x000e620000000c00ULL,
0x200000ff27277230ULL, 0x004fc40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fe40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x200000ff2f2f7230ULL, 0x008fe40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fc40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x0000001727277230ULL, 0x010fe40000000000ULL, 0x0000001626267230ULL, 0x000fe40000000000ULL,
0x0000001525257230ULL, 0x000fe40000000000ULL, 0x0000001424247230ULL, 0x000fe40000000000ULL,
0x0000001b2f2f7230ULL, 0x002fc40000000000ULL, 0x0000001a2e2e7230ULL, 0x000fe20000000000ULL,
0x000000243e007388ULL, 0x0003e20000000c00ULL, 0x000000192d2d7230ULL, 0x000fe40000000000ULL,
0x000000182c2c7230ULL, 0x000fca0000000000ULL, 0x0004002c3e007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff5000720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002003117810ULL, 0x004fe20007ffe0ffULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x00000003ff107819ULL, 0x000fe20000011603ULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x00000003ff047819ULL, 0x000fe20000011611ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000710007812ULL, 0x000fe200078e4803ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000704027812ULL, 0x000fe200078e4811ULL,
0x000000083f127824ULL, 0x000fe200078e00ffULL, 0x0ffffff800007812ULL, 0x000fc400078ef803ULL,
0x0ffffff802027812ULL, 0x100fe400078ef811ULL, 0xfffffff812117812ULL, 0x000fe200078ee211ULL,
0x0000001000007824ULL, 0x100fe400078e0205ULL, 0x0000001002057824ULL, 0x000fc600078e0205ULL,
0x0000000000087984ULL, 0x0023280000000c00ULL, 0x00000000050c7984ULL, 0x0003220000000c00ULL,
0x0000000806077824ULL, 0x044fe400078e00ffULL, 0x0000000806137824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x008fe2000f8e023fULL, 0x000000083f007824ULL, 0x002fe200078e00ffULL,
0xfffffff807027812ULL, 0x000fc400078ee210ULL, 0xfffffff813047812ULL, 0x000fe400078ee204ULL,
0x0000000402107c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000404027c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff800037812ULL, 0x000fe200078ee203ULL, 0x000000ffff057224ULL, 0x000fe200000e06ffULL,
0x00005a0010047a11ULL, 0x000fe200078040ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005a0002067a11ULL, 0x000fc400078240ffULL, 0x00005b0010057a11ULL, 0x000fe400000f4405ULL,
0x00005b0002077a11ULL, 0x000fc600008f4407ULL, 0x0000001003027825ULL, 0x000fc800078e0004ULL,
0x0000001011047825ULL, 0x000fe200078e0006ULL, 0x0000000802007986ULL, 0x010fe8000c101d06ULL,
0x0000000c04007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000004252a7824ULL, 0x000fe400078e0226ULL, 0xffffffffff277424ULL, 0x000fc600078e00ffULL,
0x000000032a00720cULL, 0x000fda0003f06070ULL, 0x0000000228058824ULL, 0x000fc800078e00ffULL,
0x0000640005068a24ULL, 0x000fc800078e022aULL, 0x0000600006068625ULL, 0x000fe200078e000fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff087624ULL, 0x000fe200078e00ffULL,
0x0000000606278981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff097624ULL, 0x000fc600078e00ffULL,
0x00f60000ff047f8cULL, 0x000e68000c80043fULL, 0x00000006082d7981ULL, 0x000762000c1e9900ULL,
0x00000001250b7810ULL, 0x000fe20007ffe0ffULL, 0x000000402c2c7824ULL, 0x000fe400078e00ffULL,
0x00000040262e7824ULL, 0x000fe200078e00ffULL, 0x000000020b00720cULL, 0x000fe20003f06070ULL,
0x000000403d2b7824ULL, 0x000fc400078e00ffULL, 0x0000002c271e7224ULL, 0x004fd400078e02ffULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1d7819ULL, 0x00afe20000011644ULL,
0x0000010025077824ULL, 0x000fe200078e022eULL, 0x00000003ff0f7819ULL, 0x100fe40000011644ULL,
0x000000300a1f7812ULL, 0x000fe200078ec0ffULL, 0x000000403d067824ULL, 0x000fe200078e021dULL,
0x0000000724007217ULL, 0x000fe40007800000ULL, 0x000000030f0f7812ULL, 0x000fe400078e4844ULL,
0x0000001006087810ULL, 0x000fe20007ffe0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a07ULL,
0x0000000806077810ULL, 0x000fc40007ffe0ffULL, 0x000000081e087210ULL, 0x040fe40007f5e0ffULL,
0x000000061e147210ULL, 0x040fe40007f1e0ffULL, 0x000000071e177210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200010e06ffULL, 0x00005e00080e7a11ULL, 0x000fe200078438ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e0014127a11ULL, 0x000fe200078038ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0017157a11ULL, 0x000fc400078238ffULL,
0x00005f0008107a11ULL, 0x000fe400010f3c07ULL, 0x0000001806077810ULL, 0x000fe40007ffe0ffULL,
0x000000001d00720cULL, 0x000fe40003f66070ULL, 0x00005f0014147a11ULL, 0x000fe400000f3c09ULL,
0x00005f0017177a11ULL, 0x000fe400008f3c0cULL, 0x0000002006087810ULL, 0x000fc40007ffe0ffULL,
0x0000002806097810ULL, 0x040fe40007ffe0ffULL, 0x00000030060a7810ULL, 0x040fe40007ffe0ffULL,
0x00000038060b7810ULL, 0x000fe40007ffe0ffULL, 0x0000100026117811ULL, 0x000fe400078e68ffULL,
0x0ffffffc0f447812ULL, 0x000fe400078ef844ULL, 0x000000071e0d7210ULL, 0x000fc40007f3e0ffULL,
0x000000121f067210ULL, 0x000fe20007f1e0ffULL, 0x0000001044137824ULL, 0x000fe200078e0211ULL,
0x000000081e1a7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00005e000d0c7a11ULL, 0x040fe200078838ffULL, 0x000000ffff077224ULL, 0x000fe200000e0614ULL,
0x0000000a1e147210ULL, 0x000fe40007f1e0ffULL, 0x00005f000d0d7a11ULL, 0x000fe400020f3c08ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006137faeULL, 0x0003e2000d901c46ULL,
0x000000081d197810ULL, 0x000fc40007ffe0ffULL, 0x0000001f15087210ULL, 0x080fe40007f7e0ffULL,
0x0000001f0e0a7210ULL, 0x080fe20007f9e0ffULL, 0x00000004190e7824ULL, 0x000fe200078e00ffULL,
0x000000101d157810ULL, 0x040fe40007ffe0ffULL, 0x000000181d1b7810ULL, 0x000fe40007ffe0ffULL,
0x0000001f0c0c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff137224ULL, 0x002fe200010e06ffULL,
0x0000000b1e127210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e0610ULL,
0x000000091e167210ULL, 0x000fe20007fde0ffULL, 0x000000ffff097224ULL, 0x000fe200018e0617ULL,
0x000000001900720cULL, 0x080fe20003f66070ULL, 0x0000000415107824ULL, 0x040fe200078e00ffULL,
0x000000001500720cULL, 0x080fe20003f86070ULL, 0x000000041b1c7824ULL, 0x040fe200078e00ffULL,
0xfffffffc0e067812ULL, 0x000fe200078ee20fULL, 0x000000ffff0d7224ULL, 0x000fe200028e060dULL,
0x000000001b00720cULL, 0x000fc40003fa6070ULL, 0x00005e001a187a11ULL, 0x000fe200078438ffULL,
0x0000001006077824ULL, 0x000fe200078e0211ULL, 0xfffffffc100e7812ULL, 0x100fe400078ee20fULL,
0xfffffffc1c107812ULL, 0x000fe400078ee20fULL, 0x00005f001a1a7a11ULL, 0x000fe200010f3c13ULL,
0x000000100e137824ULL, 0x100fe200078e0211ULL, 0x000000201d177810ULL, 0x040fe20007ffe0ffULL,
0x0000001010157824ULL, 0x000fe200078e0211ULL, 0x000000281d197810ULL, 0x040fe20007ffe0ffULL,
0x0000000008077faeULL, 0x0003e2000d901c46ULL, 0x000000301d1b7810ULL, 0x000fc40007ffe0ffULL,
0x000000381d1d7810ULL, 0x000fe20007ffe0ffULL, 0x000000000a137faeULL, 0x0005e2000e101c46ULL,
0x000000001700720cULL, 0x080fe20003f46070ULL, 0x0000000419067824ULL, 0x040fe200078e00ffULL,
0x000000001900720cULL, 0x080fe20003f66070ULL, 0x000000000c157faeULL, 0x0007e2000e901c46ULL,
0x000000001b00720cULL, 0x080fe40003f86070ULL, 0x000000001d00720cULL, 0x000fe20003fa6070ULL,
0x0000000417007824ULL, 0x000fe200078e00ffULL, 0xfffffffc06067812ULL, 0x000fe200078ee20fULL,
0x000000041b087824ULL, 0x002fc400078e00ffULL, 0x000000041d0a7824ULL, 0x004fe200078e00ffULL,
0xfffffffc00007812ULL, 0x000fe200078ee20fULL, 0x0000001006137824ULL, 0x000fe200078e0211ULL,
0xfffffffc08087812ULL, 0x100fe200078ee20fULL, 0x000000ffff0d7224ULL, 0x008fe200030e06ffULL,
0xfffffffc0a0a7812ULL, 0x000fe200078ee20fULL, 0x00000010000f7824ULL, 0x100fe200078e0211ULL,
0x00005e0016007a11ULL, 0x000fe200078c38ffULL, 0x0000001008157824ULL, 0x100fe400078e0211ULL,
0x000000100a117824ULL, 0x000fe200078e0211ULL, 0x00005f00160d7a11ULL, 0x000fe200030f3c0dULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x0000001f18067210ULL, 0x000fe20007fde0ffULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x00005e00140a7a11ULL, 0x000fc400078038ffULL,
0x0000001f00087210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff077224ULL, 0x000fe200030e061aULL,
0x00005e00120c7a11ULL, 0x000fe400078c38ffULL, 0x00005f00140b7a11ULL, 0x000fe400000f3c0bULL,
0x00005f0012007a11ULL, 0x000fe200030f3c09ULL, 0x000000ffff097224ULL, 0x000fe200008e060dULL,
0x0000001f0a0a7210ULL, 0x080fe20007f1e0ffULL, 0x00000000060f7faeULL, 0x0003e2000d101c46ULL,
0x0000001f0c0c7210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000000008137faeULL, 0x0003e2000d901c46ULL, 0x000000ffff0d7224ULL, 0x000fc600008e0600ULL,
0x000000000a157faeULL, 0x0003e8000e101c46ULL, 0x000000000c117faeULL, 0x0003e2000e901c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000002b44007211ULL, 0x04afe400078ff0ffULL,
0x00000020440c7811ULL, 0x000fe400078ff0ffULL, 0x000000001e007210ULL, 0x000fe40007f1e0ffULL,
0x0000003044107811ULL, 0x040fe200078ff0ffULL, 0x000000012b0b7824ULL, 0x040fe200078e020cULL,
0x0000001844087811ULL, 0x040fe200078ff0ffULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0x00000028440e7811ULL, 0x000fe200078ff0ffULL, 0x000000012b0f7824ULL, 0x040fe200078e0210ULL,
0x00000003ff137819ULL, 0x000fe20000011644ULL, 0x000000012b097824ULL, 0x040fe200078e0208ULL,
0x00005e0000157a11ULL, 0x000fe200078038ffULL, 0x000000012b0d7824ULL, 0x000fe200078e020eULL,
0x0000000844147811ULL, 0x000fe200078ff0ffULL, 0x0000000410107824ULL, 0x000fe200078e00ffULL,
0x0000001044067811ULL, 0x000fe200078ff0ffULL, 0x000000040e0e7824ULL, 0x000fe200078e00ffULL,
0x0000000313177812ULL, 0x000fe200078e4844ULL, 0x0000000408087824ULL, 0x000fe200078e00ffULL,
0x00005f0000227a11ULL, 0x000fe200000f3c07ULL, 0x000000012b007824ULL, 0x040fe200078e0214ULL,
0x0000003844127811ULL, 0x000fe200078ff0ffULL, 0x000000012b077824ULL, 0x040fe200078e0206ULL,
0x0000000b1e167210ULL, 0x000fe20007f3e0ffULL, 0x0000000406067824ULL, 0x000fe200078e00ffULL,
0x000000091e187210ULL, 0x000fe20007f1e0ffULL, 0x000000012b117824ULL, 0x000fe200078e0212ULL,
0x0000100026237811ULL, 0x000fe200078e68ffULL, 0x000000040c0c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc100b7812ULL, 0x100fe200078ee217ULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0xfffffffc0e097812ULL, 0x000fc400078ee217ULL, 0x000000001e207210ULL, 0x040fe20007fde0ffULL,
0x000000100b217824ULL, 0x100fe200078e0223ULL, 0x000000071e1c7210ULL, 0x000fe20007fbe0ffULL,
0x00000010091f7824ULL, 0x000fe200078e0223ULL, 0xfffffffc08077812ULL, 0x000fe200078ee217ULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x00005e0018097a11ULL, 0x000fe200078038ffULL,
0x0000000414007824ULL, 0x000fe200078e00ffULL, 0x0000000d1e0d7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff137224ULL, 0x000fe200030e06ffULL, 0x0000000f1e0f7210ULL, 0x040fe20007f7e0ffULL,
0x00000010071b7824ULL, 0x000fe200078e0223ULL, 0x000000111e117210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0xfffffffc06067812ULL, 0x000fc400078ee217ULL,
0xfffffffc0c087812ULL, 0x000fe400078ee217ULL, 0x00005e00201e7a11ULL, 0x000fe200078c38ffULL,
0x0000001006197824ULL, 0x000fe200078e0223ULL, 0x00005f0018187a11ULL, 0x000fe200000f3c0bULL,
0x00000010081d7824ULL, 0x000fe200078e0223ULL, 0x000000300a0b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0a7224ULL, 0x000fe200010e06ffULL, 0xfffffffc00007812ULL, 0x000fe200078ee217ULL,
0x000000ffff087224ULL, 0x000fe200018e06ffULL, 0x00005f0020207a11ULL, 0x000fe200030f3c13ULL,
0x000000ffff137224ULL, 0x000fe200028e06ffULL, 0x00005e00160e7a11ULL, 0x000fc400078238ffULL,
0xfffffffc120c7812ULL, 0x000fe400078ee217ULL, 0x00005e001c1a7a11ULL, 0x000fe400078a38ffULL,
0x000000150b067210ULL, 0x000fe40007f1e0ffULL, 0x00005e000f127a11ULL, 0x000fe400078438ffULL,
0x0ffffffc17447812ULL, 0x000fe200078ef844ULL, 0x0000001000177824ULL, 0x000fe200078e0223ULL,
0x00005f0016167a11ULL, 0x000fe200008f3c07ULL, 0x000000ffff007224ULL, 0x000fe200020e06ffULL,
0x00005e000d107a11ULL, 0x000fe200078238ffULL, 0x000000ffff077224ULL, 0x000fe200000e0622ULL,
0x00005f001c1c7a11ULL, 0x000fe200028f3c13ULL, 0x0000001044297824ULL, 0x100fe200078e0223ULL,
0x00005e0011147a11ULL, 0x000fe200078638ffULL, 0x000000100c237824ULL, 0x000fe200078e0223ULL,
0x00005f000f137a11ULL, 0x000fc400010f3c08ULL, 0x0000001e0b087210ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006297faeULL, 0x0003e2000b901c46ULL,
0x00005f000d157a11ULL, 0x000fe400008f3c0aULL, 0x0000001a0b0a7210ULL, 0x000fe40007f3e0ffULL,
0x00005f0011007a11ULL, 0x000fe400018f3c00ULL, 0x000000090b0c7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0620ULL, 0x0000000e0b0e7210ULL, 0x000fc40007f7e0ffULL,
0x000000100b107210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e0618ULL,
0x000000120b127210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e0616ULL,
0x000000140b147210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e061cULL,
0x0000000008177faeULL, 0x0003e2000b901c46ULL, 0x000000ffff117224ULL, 0x000fe400020e0615ULL,
0x000000ffff137224ULL, 0x000fe200028e0613ULL, 0x000000000a197faeULL, 0x0003e2000b901c46ULL,
0x000000ffff157224ULL, 0x000fc600000e0600ULL, 0x000000000c1b7faeULL, 0x0003e8000b901c46ULL,
0x000000000e1d7faeULL, 0x0003e8000b901c46ULL, 0x00000000101f7faeULL, 0x0003e8000b901c46ULL,
0x0000000012217faeULL, 0x0003e8000b901c46ULL, 0x0000000014237faeULL, 0x0003e4000b901c46ULL,
0x00f60400ff077984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000007ff7812ULL, 0x002fc60007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000002026007824ULL, 0x002fc800078e0205ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x000000f006067812ULL, 0x000fe400078ec0ffULL, 0x0000000105077812ULL, 0x040fe400078efcffULL,
0x0000000705057812ULL, 0x100fe400078e7800ULL, 0x0000000707077812ULL, 0x000fc600078e7800ULL,
0x0000000105057824ULL, 0x000fe400078e0206ULL, 0x0000000106077824ULL, 0x000fc600078e0207ULL,
0x00000000050c7984ULL, 0x000e68000000cc00ULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fc400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fe400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001005007388ULL, 0x0003e8000000cc00ULL, 0x0000000c07007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff047f8cULL, 0x002fe8000c80043fULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe20003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000022500720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000307919ULL, 0x000e620000000000ULL, 0x3db504f32d2d7820ULL, 0x020fe20000410000ULL,
0x00006400282f7a24ULL, 0x000fe200078e02ffULL, 0x0000f68826317811ULL, 0x000fe200078e18ffULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0xffffffff02327810ULL, 0x000fe40007ffe0ffULL,
0x0000f60826337811ULL, 0x000fe400078e28ffULL, 0x0000010025297824ULL, 0x008fe200078e022eULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000292400720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x034fea0003800000ULL, 0x000000ffff377224ULL, 0x000fe200078e0035ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fc4000001ff00ULL, 0x0000000100287810ULL, 0x000fe20007ffe0ffULL,
0x00000d7000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4c7224ULL, 0x000fc400078e0000ULL,
0x00000001ff347819ULL, 0x100fe20000011628ULL, 0x0000002c27497224ULL, 0x020fe200078e02ffULL,
0x000000022800780cULL, 0x040fe20003f06070ULL, 0x000000ffff007224ULL, 0x000fe200078e0028ULL,
0x0000000128567812ULL, 0x000fe200078ec0ffULL, 0x0000030034397a24ULL, 0x000fca00078e0225ULL,
0x0000000139357810ULL, 0x000fc80007ffe0ffULL, 0x000000023500720cULL, 0x000fe40003f26070ULL,
0x0000000137357812ULL, 0x000fd600078e0cffULL, 0x000006c000009947ULL, 0x000fea0003800000ULL,
0x00000002ff407819ULL, 0x002fe20000011630ULL, 0x0000010039397824ULL, 0x000fc600078e022eULL,
0x0000000840427810ULL, 0x040fe20007ffe0ffULL, 0x000000012b287824ULL, 0x040fe200078e0240ULL,
0x00000010404e7810ULL, 0x040fe40007ffe0ffULL, 0x0000001840507810ULL, 0x000fe20007ffe0ffULL,
0x000000012b347824ULL, 0x000fe200078e0242ULL, 0x00000028493e7210ULL, 0x000fe20007f3e0ffULL,
0x000000012b367824ULL, 0x000fe200078e024eULL, 0x0000003924287217ULL, 0x000fe20007800000ULL,
0x0000000442447824ULL, 0x000fe200078e00ffULL, 0x0000003449347210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200008e06ffULL, 0x0000003649367210ULL, 0x000fe20007f7e0ffULL,
0x0000000128287824ULL, 0x000fe200078e0a39ULL, 0x00005e003e387a11ULL, 0x000fe200078238ffULL,
0x000000ffff3b7224ULL, 0x000fe200010e06ffULL, 0x00005e00343a7a11ULL, 0x000fe200078438ffULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0x0000002840527810ULL, 0x000fc40007ffe0ffULL,
0x00005f00343b7a11ULL, 0x000fe200010f3c3bULL, 0x000000012b347824ULL, 0x040fe200078e0250ULL,
0x00005e00363c7a11ULL, 0x000fe400078638ffULL, 0x0000002040517810ULL, 0x040fe40007ffe0ffULL,
0x0000003040537810ULL, 0x040fe40007ffe0ffULL, 0x0000003840547810ULL, 0x000fe40007ffe0ffULL,
0x00005f003e397a11ULL, 0x000fe200008f3c3fULL, 0x000000012b3e7824ULL, 0x040fe200078e0252ULL,
0x000000284000720cULL, 0x000fe20003f46070ULL, 0x000000012b3f7824ULL, 0x040fe200078e0253ULL,
0x00005f00363d7a11ULL, 0x000fe200018f3c3dULL, 0x000000012b367824ULL, 0x000fe200078e0251ULL,
0x0000003449407210ULL, 0x000fe20007f3e0ffULL, 0x000000012b347824ULL, 0x000fe200078e0254ULL,
0x0000003e49437210ULL, 0x000fc40007fde0ffULL, 0x0000003649417210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff477224ULL, 0x000fe200008e06ffULL, 0x00005e00403e7a11ULL, 0x000fe200078238ffULL,
0x000000ffff4a7224ULL, 0x000fe200030e06ffULL, 0x0000003f49457210ULL, 0x040fe40007f9e0ffULL,
0x0000003449367210ULL, 0x000fe20007f7e0ffULL, 0x0000000226347824ULL, 0x000fe200078e0235ULL,
0x00000003ff497819ULL, 0x100fe20000011630ULL, 0x000000ffff487224ULL, 0x000fe200020e06ffULL,
0x00005f00403f7a11ULL, 0x000fe200008f3c47ULL, 0x0000000456477824ULL, 0x000fe200078e00ffULL,
0x00000003494f7812ULL, 0x000fc400078e4830ULL, 0x000000284200720cULL, 0x000fe20003f26070ULL,
0x000000ffff427224ULL, 0x000fe200028e06ffULL, 0x0000100034347811ULL, 0x000fe400078e60ffULL,
0x0ffffffc4f4b7812ULL, 0x100fe400078ef830ULL, 0xfffffffc47497812ULL, 0x000fe200078ee230ULL,
0x000000ffff477224ULL, 0x000fe200018e06ffULL, 0xfffffffc444d7812ULL, 0x000fe200078ee24fULL,
0x000000104b4b7824ULL, 0x000fe200078e0234ULL, 0x00005e0041407a11ULL, 0x000fe200078a38ffULL,
0x0000001049387825ULL, 0x000fe200078e0038ULL, 0x00005e0045447a11ULL, 0x000fc400078838ffULL,
0x00005f0041417a11ULL, 0x000fe200028f3c42ULL, 0x000000104d4d7824ULL, 0x000fe200078e0234ULL,
0x00005e0043427a11ULL, 0x000fe200078a38ffULL, 0x00000010493a7825ULL, 0x000fe200078e003aULL,
0x00005e0036467a11ULL, 0x040fe200078638ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000384b7faeULL, 0x0003e2000d101c46ULL, 0x00005f0043437a11ULL, 0x000fe400028f3c4aULL,
0x00005f0045457a11ULL, 0x000fe200020f3c48ULL, 0x000000003a4d7faeULL, 0x0005e2000c901c46ULL,
0x00005f0036477a11ULL, 0x000fe200018f3c47ULL, 0x0000000453367824ULL, 0x000fe200078e00ffULL,
0x000000284e00720cULL, 0x0c0fe20003f26070ULL, 0x000000044e4e7824ULL, 0x000fe200078e00ffULL,
0x000000285000720cULL, 0x0c0fe20003f46070ULL, 0x0000000450507824ULL, 0x000fe200078e00ffULL,
0x000000285100720cULL, 0x000fc40003f66070ULL, 0x000000285200720cULL, 0x0c0fe20003f86070ULL,
0x0000000452527824ULL, 0x000fe200078e00ffULL, 0x000000285300720cULL, 0x080fe20003fa6070ULL,
0x00000010493a7825ULL, 0x004fe200078e003eULL, 0x000000285400720cULL, 0x000fe40003fc6070ULL,
0xfffffffc4e4b7812ULL, 0x102fe200078ee24fULL, 0x0000000451287824ULL, 0x000fe200078e00ffULL,
0xfffffffc504d7812ULL, 0x100fe200078ee24fULL, 0x0000000454547824ULL, 0x000fe200078e00ffULL,
0xfffffffc52517812ULL, 0x100fe200078ee24fULL, 0x000000104b4b7824ULL, 0x100fe200078e0234ULL,
0xfffffffc28397812ULL, 0x100fe200078ee24fULL, 0x000000104d4d7824ULL, 0x100fe200078e0234ULL,
0xfffffffc36537812ULL, 0x100fe200078ee24fULL, 0x0000001051517824ULL, 0x100fe200078e0234ULL,
0xfffffffc54557812ULL, 0x000fe200078ee24fULL, 0x00000010394f7824ULL, 0x000fc400078e0234ULL,
0x0000001049387825ULL, 0x000fc800078e003cULL, 0x00000010493c7825ULL, 0x040fe200078e0040ULL,
0x00000000384b7faeULL, 0x0003e6000c901c46ULL, 0x00000010493e7825ULL, 0x000fe200078e0042ULL,
0x000000003a4d7faeULL, 0x0003e6000d101c46ULL, 0x0000001053537824ULL, 0x000fe200078e0234ULL,
0x000000003c4f7faeULL, 0x0003e2000d901c46ULL, 0x0000001049407825ULL, 0x000fc600078e0044ULL,
0x000000003e517faeULL, 0x0003e2000e101c46ULL, 0x0000001055557824ULL, 0x000fe400078e0234ULL,
0x0000001049427825ULL, 0x000fe200078e0046ULL, 0x0000000040537faeULL, 0x0003e8000e901c46ULL,
0x0000000042557faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x00000008303e7811ULL, 0x002fe200078ff0ffULL, 0x00000002263c7824ULL, 0x000fe200078e0235ULL,
0x0000002b30347211ULL, 0x000fe200078ff0ffULL, 0x0000000456577824ULL, 0x000fe200078e00ffULL,
0x0000001030407811ULL, 0x000fe200078ff0ffULL, 0x000000012b287824ULL, 0x000fe200078e023eULL,
0x0000004934347210ULL, 0x000fe20007f3e0ffULL, 0x000000043e3e7824ULL, 0x000fe200078e00ffULL,
0x0000002030447811ULL, 0x000fc400078ff0ffULL, 0x0000004928287210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x0000002830467811ULL, 0x000fe200078ff0ffULL,
0x000000012b367824ULL, 0x040fe200078e0244ULL, 0x00005e0034387a11ULL, 0x000fe200078238ffULL,
0x000000ffff3b7224ULL, 0x000fe200010e06ffULL, 0x00005e00283a7a11ULL, 0x000fe200078438ffULL,
0x000000012b487824ULL, 0x000fe200078e0246ULL, 0x0000001830427811ULL, 0x040fe400078ff0ffULL,
0x00000030304a7811ULL, 0x000fc400078ff0ffULL, 0x00005f00283b7a11ULL, 0x000fe200010f3c3bULL,
0x000000012b287824ULL, 0x040fe200078e0240ULL, 0x00000003ff437819ULL, 0x000fe20000011630ULL,
0x000000012b4e7824ULL, 0x040fe200078e024aULL, 0x00005f0034397a11ULL, 0x000fe200008f3c39ULL,
0x000000012b347824ULL, 0x000fe200078e0242ULL, 0x0000003830507811ULL, 0x000fe200078ff0ffULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0x0000000343437812ULL, 0x000fe400078e4830ULL,
0x000010003c557811ULL, 0x000fe200078e60ffULL, 0x00000004423c7824ULL, 0x000fe200078e00ffULL,
0x00000049283d7210ULL, 0x080fe20007fde0ffULL, 0x000000012b527824ULL, 0x000fe200078e0250ULL,
0x0000004936417210ULL, 0x080fe20007f9e0ffULL, 0x0000000450507824ULL, 0x000fe200078e00ffULL,
0x0000004948367210ULL, 0x080fe20007f3e0ffULL, 0x0000000444487824ULL, 0x000fe200078e00ffULL,
0x00000049343f7210ULL, 0x000fc40007fbe0ffULL, 0x000000494e347210ULL, 0x080fe20007f5e0ffULL,
0x00000004464e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc40447812ULL, 0x100fe400078ee243ULL,
0xfffffffc3e427812ULL, 0x000fe200078ee243ULL, 0x000000ffff3e7224ULL, 0x000fe200030e06ffULL,
0x0ffffffc43407812ULL, 0x000fe200078ef830ULL, 0x00000010444b7824ULL, 0x000fe200078e0255ULL,
0xfffffffc3c467812ULL, 0x000fe200078ee243ULL, 0x000000ffff457224ULL, 0x000fe200010e06ffULL,
0x00005e003d3c7a11ULL, 0x040fe200078c38ffULL, 0x0000001040597824ULL, 0x000fe200078e0255ULL,
0x0000004952287210ULL, 0x000fe20007f7e0ffULL, 0x000000044a527824ULL, 0x000fe200078e00ffULL,
0xfffffffc48487812ULL, 0x000fe200078ee243ULL, 0x000000ffff407224ULL, 0x000fe200028e06ffULL,
0x00005f003d3d7a11ULL, 0x000fe200030f3c3eULL, 0x0000001042497824ULL, 0x100fe200078e0255ULL,
0x00005e003f3e7a11ULL, 0x040fe200078a38ffULL, 0x00000010484f7824ULL, 0x000fe200078e0255ULL,
0xfffffffc4e4a7812ULL, 0x100fe200078ee243ULL, 0x000000ffff487224ULL, 0x000fe200020e06ffULL,
0xfffffffc524e7812ULL, 0x000fe200078ee243ULL, 0x00000010464d7824ULL, 0x000fe200078e0255ULL,
0xfffffffc50507812ULL, 0x000fe200078ee243ULL, 0x000000ffff437224ULL, 0x000fe200008e06ffULL,
0x00005f003f3f7a11ULL, 0x000fe200028f3c40ULL, 0x000000ffff477224ULL, 0x000fe200018e06ffULL,
0xfffffffc57577812ULL, 0x000fe200078ee230ULL, 0x000000104a517824ULL, 0x100fe200078e0255ULL,
0x00005e0041407a11ULL, 0x000fe200078838ffULL, 0x000000104e537824ULL, 0x000fe200078e0255ULL,
0x00005e0036427a11ULL, 0x000fe200078238ffULL, 0x0000001057387825ULL, 0x000fe200078e0038ULL,
0x00005e0034447a11ULL, 0x000fc400078438ffULL, 0x00005e0028467a11ULL, 0x000fe200078638ffULL,
0x00000010573a7825ULL, 0x000fe200078e003aULL, 0x00005f0041417a11ULL, 0x000fe200020f3c48ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038597faeULL, 0x0003e2000b901c46ULL,
0x00005f0036437a11ULL, 0x000fe200008f3c43ULL, 0x00000010573c7825ULL, 0x040fe200078e003cULL,
0x00005f0034457a11ULL, 0x000fe200010f3c45ULL, 0x000000003a497faeULL, 0x0003e2000b901c46ULL,
0x00005f0028477a11ULL, 0x000fe200018f3c47ULL, 0x00000010573e7825ULL, 0x040fe400078e003eULL,
0x000000003c4b7faeULL, 0x0003e4000b901c46ULL, 0x0000001057407825ULL, 0x000fc400078e0040ULL,
0x000000003e4d7faeULL, 0x0003e4000b901c46ULL, 0x0000001057427825ULL, 0x040fe400078e0042ULL,
0x00000000404f7faeULL, 0x0003e4000b901c46ULL, 0x0000001057447825ULL, 0x000fe400078e0044ULL,
0x0000000042517faeULL, 0x0003e4000b901c46ULL, 0x0000001050557824ULL, 0x000fc400078e0255ULL,
0x0000001057467825ULL, 0x000fe200078e0046ULL, 0x0000000044537faeULL, 0x0003e8000b901c46ULL,
0x0000000046557faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff5600720cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000009947ULL, 0x000fea0003800000ULL, 0x00000004ff397424ULL, 0x002fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fe400078e00ffULL, 0x00000300392a7a24ULL, 0x000fca00078e022aULL,
0x000000032a00720cULL, 0x000fda0003f26070ULL, 0x0000003000001947ULL, 0x000fea0003800000ULL,
0x000000022f387824ULL, 0x000fc800078e022aULL, 0x0000600038387625ULL, 0x000fca00078e0039ULL,
0x0000000638277981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000020303b7810ULL, 0x002fe20007ffe0ffULL,
0x0000000226387824ULL, 0x000fe200078e0237ULL, 0xfffffff830397812ULL, 0x000fe200078ec0ffULL,
0x000000084c457824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000000739377812ULL, 0x100fe400078ef830ULL,
0x000000073b447812ULL, 0x000fe400078ef830ULL, 0x0000000730397812ULL, 0x000fc400078ec0ffULL,
0x00000001ff347819ULL, 0x000fe40000011637ULL, 0x00000001ff367819ULL, 0x000fe40000011644ULL,
0x0000100038487811ULL, 0x000fe400078e60ffULL, 0x0000000839597812ULL, 0x000fe400078ef830ULL,
0x0000000334477812ULL, 0x000fe400078ec0ffULL, 0x0000000336497812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000002847367212ULL, 0x000fe200078e3cffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000004530347211ULL, 0x000fc400078fe0ffULL,
0x00000028493d7212ULL, 0x000fe200078e3cffULL, 0x0000000437387824ULL, 0x000fe200078e0236ULL,
0x0000000734367812ULL, 0x140fe400078e7859ULL, 0x0000000234347810ULL, 0x000fe20007ffe0ffULL,
0x0000001038407824ULL, 0x000fe200078e0248ULL, 0x0000000445457810ULL, 0x000fe20007ffe0ffULL,
0x0000001059367824ULL, 0x000fe200078e0236ULL, 0x0000000734347812ULL, 0x000fe200078e7859ULL,
0x00000004443d7824ULL, 0x000fe400078e023dULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x0000001036367824ULL, 0x000fc400078e00ffULL, 0x000000103d3d7824ULL, 0x000fe400078e0248ULL,
0x0000001059347824ULL, 0x000fe200078e0234ULL, 0x000000003638783bULL, 0x0004e60000000200ULL,
0x0000001034347824ULL, 0x000fe200078e00ffULL, 0x000000003d3c783bULL, 0x000f220000000200ULL,
0x0000000128367810ULL, 0x044fe40007ffe0ffULL, 0x0000000228287810ULL, 0x000fc80007ffe0ffULL,
0x000000042800780cULL, 0x000fe40003f25270ULL, 0x00000040ff4a723eULL, 0x082fe400020006ffULL,
0x00000040ff4b723eULL, 0x000fe400030006ffULL, 0x00000041ff4c723eULL, 0x080fe400020006ffULL,
0x00000041ff4d723eULL, 0x000fe400030006ffULL, 0x00000042ff40723eULL, 0x080fe200020006ffULL,
0x0000004a3818723cULL, 0x008fe20000001818ULL, 0x00000042ff41723eULL, 0x000fc400030006ffULL,
0x0000003647427212ULL, 0x000fca00078e3cffULL, 0x000000403820723cULL, 0x040fee0000001820ULL,
0x0000000437407824ULL, 0x000fe200078e0242ULL, 0x00000043ff42723eULL, 0x080fe200020006ffULL,
0x0000004c381c723cULL, 0x000fe2000000181cULL, 0x00000043ff43723eULL, 0x000fe200030006ffULL,
0x0000001040467824ULL, 0x000fca00078e0248ULL, 0x000000004650783bULL, 0x000e620000000200ULL,
0x00000042384c723cULL, 0x000fe60000001804ULL, 0x000000003440783bULL, 0x000ea80000000200ULL,
0x0000003649077212ULL, 0x000fe400078e3cffULL, 0x0000003cff04723eULL, 0x010fc400020006ffULL,
0x0000003cff05723eULL, 0x000fe200030006ffULL, 0x0000000444077824ULL, 0x000fe200078e0207ULL,
0x0000003dff3c723eULL, 0x080fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fe200030006ffULL,
0x0000001007077824ULL, 0x000fe400078e0248ULL, 0x000000043808723cULL, 0x040fe60000001808ULL,
0x000000000754783bULL, 0x000ee80000000200ULL, 0x0000003eff04723eULL, 0x080fe200020006ffULL,
0x0000003c380c723cULL, 0x000fe2000000180cULL, 0x0000003eff05723eULL, 0x000fc400030006ffULL,
0x0000003fff3e723eULL, 0x080fe400020006ffULL, 0x0000003fff3f723eULL, 0x000fc600030006ffULL,
0x000000043810723cULL, 0x040fee0000001810ULL, 0x00000050ff04723eULL, 0x082fe200020006ffULL,
0x0000003e3814723cULL, 0x000fe20000001814ULL, 0x00000050ff05723eULL, 0x000fe400030006ffULL,
0x00000051ff50723eULL, 0x000fc400020006ffULL, 0x00000051ff51723eULL, 0x000fc600030006ffULL,
0x000000044018723cULL, 0x044fee0000001818ULL, 0x00000052ff04723eULL, 0x080fe200020006ffULL,
0x00000050401c723cULL, 0x000fe2000000181cULL, 0x00000052ff05723eULL, 0x000fe400030006ffULL,
0x00000054ff38723eULL, 0x008fc400020006ffULL, 0x00000054ff39723eULL, 0x000fe400030006ffULL,
0x00000055ff54723eULL, 0x080fe200020006ffULL, 0x000000044020723cULL, 0x000fe20000001820ULL,
0x00000055ff55723eULL, 0x000fcc00030006ffULL, 0x00000053ff04723eULL, 0x080fe200020006ffULL,
0x000000384008723cULL, 0x000fe20000001808ULL, 0x00000053ff05723eULL, 0x000fcc00030006ffULL,
0x00000056ff38723eULL, 0x080fe200020006ffULL, 0x000000044004723cULL, 0x000fe2000000184cULL,
0x00000056ff39723eULL, 0x000fe400030006ffULL, 0x00000057ff56723eULL, 0x080fe400020006ffULL,
0x00000057ff57723eULL, 0x000fc600030006ffULL, 0x00000054400c723cULL, 0x040ff0000000180cULL,
0x000000384010723cULL, 0x040ff00000001810ULL, 0x000000564014723cULL, 0x000fe20000001814ULL,
0xfffffb0000001947ULL, 0x000fee000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff377224ULL, 0x000fe200078e0035ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffeb6000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000031367f8cULL, 0x000fe2000c80043fULL,
0x000000192d197220ULL, 0x040fe20000410000ULL, 0x0000001e2d387220ULL, 0x040fe20000410000ULL,
0x000000182d187220ULL, 0x040fe20000410000ULL, 0x0000040031397984ULL, 0x000e620000000800ULL,
0x0000001a2d287220ULL, 0x040fe20000410000ULL, 0x0000001b2d347220ULL, 0x040fe20000410000ULL,
0x000000152d1e7220ULL, 0x040fe20000410000ULL, 0x0000001d2d1d7220ULL, 0x040fe20000410000ULL,
0x0000001f2d1f7220ULL, 0x040fe20000410000ULL, 0x000000202d207220ULL, 0x040fe20000410000ULL,
0x000000212d217220ULL, 0x040fe20000410000ULL, 0x000000112d1a7220ULL, 0x040fe20000410000ULL,
0x000000142d1b7220ULL, 0x040fe20000410000ULL, 0x000000222d227220ULL, 0x040fe20000410000ULL,
0x000000232d237220ULL, 0x040fe20000410000ULL, 0x000000062d3a7220ULL, 0x040fe20000410000ULL,
0x000000072d3b7220ULL, 0x040fe20000410000ULL, 0x0000000a2d3c7220ULL, 0x040fe20000410000ULL,
0x0000001c2d1c7220ULL, 0x040fe20000410000ULL, 0x000000042d047220ULL, 0x040fe20000410000ULL,
0x000000052d057220ULL, 0x040fe20000410000ULL, 0x000000082d087220ULL, 0x040fe20000410000ULL,
0x000000092d097220ULL, 0x040fe20000410000ULL, 0x0000000b2d3d7220ULL, 0x040fe20000410000ULL,
0x0000000c2d007220ULL, 0x040fe20000410000ULL, 0x0000000d2d067220ULL, 0x040fe20000410000ULL,
0x0000000e2d3e7220ULL, 0x040fe20000410000ULL, 0x0000000f2d3f7220ULL, 0x040fe20000410000ULL,
0x000000102d077220ULL, 0x040fe20000410000ULL, 0x000000122d407220ULL, 0x040fe20000410000ULL,
0x000000132d417220ULL, 0x040fe20000410000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0019ULL,
0x000000172d437220ULL, 0x040fe20000410000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0018ULL,
0x000000162d427220ULL, 0x000fe20000410000ULL, 0x000000ffff197224ULL, 0x000fc400078e001eULL,
0x000000ffff0d7224ULL, 0x000fe400078e001dULL, 0x000000ffff0e7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0021ULL, 0x000000ffff177224ULL, 0x000fe200078e001aULL,
0x8000000039ff7812ULL, 0x002fe20007804837ULL, 0x000000ffff187224ULL, 0x000fe400078e001bULL,
0x000000ffff1e7224ULL, 0x000fc400078e001fULL, 0x000000ffff1a7224ULL, 0x000fe400078e0028ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0034ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0038ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0022ULL, 0x000000ffff207224ULL, 0x000fe400078e0023ULL,
0x000000ffff217224ULL, 0x000fc400078e003aULL, 0x000000ffff0c7224ULL, 0x000fe400078e001cULL,
0x000000ffff107224ULL, 0x000fe400078e0004ULL, 0x000000ffff117224ULL, 0x000fe400078e0005ULL,
0x000000ffff127224ULL, 0x000fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fe400078e0009ULL,
0x000000ffff147224ULL, 0x000fc400078e0000ULL, 0x000000ffff157224ULL, 0x000fe400078e0006ULL,
0x000000ffff167224ULL, 0x000fe400078e0007ULL, 0x000000ffff227224ULL, 0x000fe400078e003bULL,
0x000000ffff237224ULL, 0x000fe400078e003cULL, 0x000000ffff287224ULL, 0x000fe400078e003dULL,
0x000000ffff347224ULL, 0x000fc400078e003eULL, 0x000000ffff387224ULL, 0x000fe400078e003fULL,
0x000000ffff397224ULL, 0x000fe400078e0040ULL, 0x000000ffff3a7224ULL, 0x000fe200078e0041ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3b7224ULL, 0x000fe400078e0042ULL, 0x000000ffff3c7224ULL, 0x000fe200078e0043ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x0000040031057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004301c7824ULL, 0x000fe200078e00ffULL, 0x000000322500720cULL, 0x000fc80003f05270ULL,
0xfffffff01c057812ULL, 0x000fca00078ec0ffULL, 0x0000008026007824ULL, 0x000fca00078e0205ULL,
0x00f4000000047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000230087824ULL, 0x000fe400078e00ffULL, 0x0000000124297824ULL, 0x000fc600078e0a29ULL,
0x0000000608087812ULL, 0x000fc800078ec0ffULL, 0x0000000108367812ULL, 0x040fe400078efcffULL,
0x00000008083e7812ULL, 0x000fe400078efcffULL, 0x000000293600720cULL, 0x080fe40003f26070ULL,
0x0000001008367812ULL, 0x000fe400078efcffULL, 0x000000293e00720cULL, 0x080fe40003f06070ULL,
0x000000293600720cULL, 0x000fc40003fc6070ULL, 0x00000011083e7812ULL, 0x040fe400078efcffULL,
0x0000001808367812ULL, 0x040fe400078efcffULL, 0x000000290800720cULL, 0x080fe40003f46070ULL,
0x000000293e00720cULL, 0x080fe40003fa6070ULL, 0x000000293600720cULL, 0x000fe40003f66070ULL,
0x0000000908407812ULL, 0x000fc400078efcffULL, 0x00000019083e7812ULL, 0x040fe400078efcffULL,
0x0000002008367812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x000000294000720cULL, 0x080fe40003f86070ULL,
0x000000293e00720cULL, 0x080fe40003f46070ULL, 0x000000293600720cULL, 0x000fe40003f26070ULL,
0x00000021083e7812ULL, 0x040fe400078efcffULL, 0x0000002808367812ULL, 0x000fe400078efcffULL,
0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x000000293e00720cULL, 0x080fe40003f06070ULL, 0x000000293600720cULL, 0x000fe40003f86070ULL,
0x00000029083e7812ULL, 0x000fc400078efcffULL, 0x0000003008367812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x000000293e00720cULL, 0x000fc40003fc6070ULL, 0x000000293600720cULL, 0x000fe40003fa6070ULL,
0x00000031083e7812ULL, 0x040fe400078efcffULL, 0x0000003808367812ULL, 0x040fe400078efcffULL,
0x0000003908087812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x000000293e00720cULL, 0x080fe40003f66070ULL,
0x000000293600720cULL, 0x000fc40003f46070ULL, 0x000000290800720cULL, 0x000fe40003f26070ULL,
0xff7fffff28287808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff34347808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff38387808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff39397808ULL, 0x000fe40006800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff3a3a7808ULL, 0x000fe40005800000ULL,
0xff7fffff18187808ULL, 0x000fc40005000000ULL, 0xff7fffff3b3b7808ULL, 0x000fe40005000000ULL,
0xff7fffff19197808ULL, 0x000fe40004800000ULL, 0xff7fffff3c3c7808ULL, 0x000fe40004800000ULL,
0x0000000b04097209ULL, 0x004fe20007810000ULL, 0x0000001fff3f7424ULL, 0x000fe200078e00ffULL,
0x0000001a05047209ULL, 0x000fe20007810000ULL, 0xffffffffff427424ULL, 0x000fe200078e00ffULL,
0x0000000a09097209ULL, 0x000fe40007810000ULL, 0x0000001b04047209ULL, 0x000fc40007810000ULL,
0x0000000c09087209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000000d08097209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000000e09087209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fc40007810000ULL,
0x0000000f08097209ULL, 0x000fe40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x0000001009087209ULL, 0x000fe40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fc40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x0000002304057209ULL, 0x000fe40007810000ULL,
0x0000001308097209ULL, 0x000fe40007810000ULL, 0x0000002805057209ULL, 0x000fe40007810000ULL,
0x0000001409047209ULL, 0x000fe40007810000ULL, 0x0000003405057209ULL, 0x000fc40007810000ULL,
0x0000001504097209ULL, 0x000fe40007810000ULL, 0x0000003805047209ULL, 0x000fe40007810000ULL,
0x0000001609087209ULL, 0x000fe40007810000ULL, 0x0000003904057209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x0000003a05047209ULL, 0x000fc40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x0000003b04057209ULL, 0x000fe40007810000ULL,
0x0000001908377209ULL, 0x000fe40007810000ULL, 0x0000003c053d7209ULL, 0x000fe20007810000ULL,
0x000017c27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0037047f89ULL, 0x0004e400000e0000ULL,
0x0000000437377209ULL, 0x00cfe20007810000ULL, 0x000017f27f007947ULL, 0x000fea000b800000ULL,
0x0c401f003d047f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006057f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007367f89ULL, 0x000f2200000e0000ULL, 0x000000043d087209ULL, 0x004fc60007810000ULL,
0x0c201f0037047f89ULL, 0x000ea200000e0000ULL, 0x0000000506097209ULL, 0x008fc60007810000ULL,
0x0c201f0008057f89ULL, 0x000ee200000e0000ULL, 0x0000003607367209ULL, 0x010fc60007810000ULL,
0x0c201f00093e7f89ULL, 0x002e6800000e0000ULL, 0x0c201f0036297f89ULL, 0x00092200000e0000ULL,
0x0000000437047209ULL, 0x004fe40007810000ULL, 0x0000000508057209ULL, 0x008fe40007810000ULL,
0x0000003e09067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3c003c00ff3e7424ULL, 0x002fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3c003c00ff3f7424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x0000000000057886ULL, 0x000fc400038e0100ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010819ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b3c197823ULL, 0x000fc80000010819ULL,
0x0000000d000d7308ULL, 0x000ee20000000800ULL, 0x000000080908723eULL, 0x002fce00000000ffULL,
0x0000001a001a7308ULL, 0x000ff00000000800ULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x008fce00000000ffULL, 0x0000001d000b7308ULL, 0x0007f00000000800ULL,
0x0000001e001e7308ULL, 0x000f220000000800ULL, 0x0000001a1b09723eULL, 0x002fe200000000ffULL,
0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000b1e0b723eULL, 0x010fce00000000ffULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x0000003e0840723cULL, 0x000fee00000018ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000001100117308ULL, 0x000ee20000000800ULL, 0x0000000e0f0c723eULL, 0x002fce00000000ffULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x00000010110e723eULL, 0x008fce00000000ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002200227308ULL, 0x000ee20000000800ULL, 0x0000001f200d723eULL, 0x002fce00000000ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x00000021220f723eULL, 0x008fce00000000ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x0000003e0c40723cULL, 0x000fee0000001840ULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ee20000000800ULL,
0x000000121310723eULL, 0x002fce00000000ffULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000002800287308ULL, 0x000e620000000800ULL, 0x000000141512723eULL, 0x008fe400000000ffULL,
0xfffffffc30147812ULL, 0x000fc800078ec0ffULL, 0x000000141d1d7219ULL, 0x000fe200000006ffULL,
0x0000003400347308ULL, 0x000fe60000000800ULL, 0x000000001d1e73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0473c4ULL, 0x000f280000004000ULL, 0x00000038001b7308ULL, 0x000ea20000000800ULL,
0x000000232811723eULL, 0x002fce00000000ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000341b13723eULL, 0x004fce00000000ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000051dff7c12ULL, 0x008fe2000f80401eULL, 0x0000003e1040723cULL, 0x000fec0000001840ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000000700077308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000000ffULL, 0x0000003900397308ULL, 0x000ff00000000800ULL,
0x0000003a003a7308ULL, 0x000e620000000800ULL, 0x000000180716723eULL, 0x004fe400000000ffULL,
0x0000003629077209ULL, 0x000fca0007810000ULL, 0x0000003b003b7308ULL, 0x000ff00000000800ULL,
0x00000019001a7308ULL, 0x000ea20000000800ULL, 0x000000393a15723eULL, 0x002fe400000000ffULL,
0x0000003b1a17723eULL, 0x004fce00000000ffULL, 0x0000003e1440723cULL, 0x000fe20000001840ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000132204008947ULL, 0x010fde000b800000ULL,
0x001c1fff40187589ULL, 0x0002a400000e0000ULL, 0x000000001d1a73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x000000051dff7c12ULL, 0x008fda000f80401aULL, 0x0000134204008947ULL, 0x010fea000b800000ULL,
0x001c1fff42197589ULL, 0x00072800000e0000ULL, 0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL,
0x001c1fff001b7589ULL, 0x0006a400000e0000ULL, 0x00000002ff1d7819ULL, 0x00afe40000011630ULL,
0x0000000c1c437812ULL, 0x000fc400078ec0ffULL, 0x000000071d1e7812ULL, 0x040fe200078ec0ffULL,
0x000000081d237824ULL, 0x040fe200078e00ffULL, 0x0000001dff217212ULL, 0x000fe200078e33ffULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0x0000000330ff7812ULL, 0x000fe2000780c0ffULL,
0x000000081d3c7824ULL, 0x040fe200078e00ffULL, 0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823207812ULL, 0x100fe400078ee21eULL, 0x000000011f227812ULL, 0x100fe200078ef61eULL,
0x000000081d4c7824ULL, 0x000fe200078e00ffULL, 0x000000021f287812ULL, 0x100fe200078ef61eULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0x000000031f347812ULL, 0x000fc400078ef61eULL,
0x000000041f367812ULL, 0x140fe400078ef61eULL, 0x000000051f387812ULL, 0x140fe400078ef61eULL,
0x000000061f3a7812ULL, 0x000fe200078ef61eULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee221ULL, 0x0000001dff217212ULL, 0x000fe400078e33ffULL,
0x000000071d1e7812ULL, 0x000fc400078ec0ffULL, 0x00009000261d7811ULL, 0x000fe400078e58ffULL,
0xfffffff8233e7812ULL, 0x100fe400078ee21eULL, 0x000000011f407812ULL, 0x140fe200078ef61eULL,
0x00000010201c7824ULL, 0x000fe200078e021dULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee221ULL,
0x0000001028207824ULL, 0x100fe200078e021dULL, 0x000000021f427812ULL, 0x140fe200078ef61eULL,
0x0000001036287824ULL, 0x100fe200078e021dULL, 0x000000031f447812ULL, 0x140fe200078ef61eULL,
0x000000103a367824ULL, 0x100fe200078e021dULL, 0x000000041f467812ULL, 0x140fe200078ef61eULL,
0x00000010403a7824ULL, 0x100fe200078e021dULL, 0x000000051f487812ULL, 0x140fe200078ef61eULL,
0x00000010443d7824ULL, 0x100fe200078e021dULL, 0x000000061f4a7812ULL, 0x000fe200078ef61eULL,
0x00000010221e7824ULL, 0x000fc400078e021dULL, 0x0000001034227824ULL, 0x100fe400078e021dULL,
0x0000001038347824ULL, 0x100fe400078e021dULL, 0x00000001431f7824ULL, 0x000fe400078e021cULL,
0x000000103c387824ULL, 0x100fe400078e021dULL, 0x000000103e1c7824ULL, 0x100fe200078e021dULL,
0x000000081f007388ULL, 0x0003e20000000800ULL, 0x00000010423c7824ULL, 0x000fc400078e021dULL,
0x00000010463e7824ULL, 0x100fe400078e021dULL, 0x00000010483f7824ULL, 0x100fe400078e021dULL,
0x000000104a407824ULL, 0x100fe400078e021dULL, 0x000000104c417824ULL, 0x000fe400078e021dULL,
0x00000001431d7824ULL, 0x040fe400078e021eULL, 0x0000000143217824ULL, 0x000fc400078e0220ULL,
0x0000000143237824ULL, 0x040fe200078e0222ULL, 0x0000000a1d007388ULL, 0x0007e20000000800ULL,
0x0000000143297824ULL, 0x040fe400078e0228ULL, 0x0000000143377824ULL, 0x040fe200078e0234ULL,
0x0000000c21007388ULL, 0x0007e20000000800ULL, 0x0000000143397824ULL, 0x040fe400078e0236ULL,
0x00000001433b7824ULL, 0x040fe200078e0238ULL, 0x0000000e23007388ULL, 0x0007e20000000800ULL,
0x00000001431c7824ULL, 0x000fc400078e021cULL, 0x00000001433a7824ULL, 0x040fe200078e023aULL,
0x0000001029007388ULL, 0x0007e20000000800ULL, 0x00000001433c7824ULL, 0x040fe400078e023cULL,
0x0000000143087824ULL, 0x042fe200078e023dULL, 0x0000001237007388ULL, 0x0007e20000000800ULL,
0x00000001433e7824ULL, 0x040fe400078e023eULL, 0x00000001431e7824ULL, 0x040fe200078e023fULL,
0x0000001439007388ULL, 0x0007e20000000800ULL, 0x0000000143407824ULL, 0x000fc400078e0240ULL,
0x0000000143207824ULL, 0x000fe200078e0241ULL, 0x000000163b007388ULL, 0x0007e80000000800ULL,
0x000000091c007388ULL, 0x0007e80000000800ULL, 0x0000000b3a007388ULL, 0x0007e80000000800ULL,
0x0000000d3c007388ULL, 0x0007e80000000800ULL, 0x0000000f08007388ULL, 0x0007e80000000800ULL,
0x000000113e007388ULL, 0x0007e80000000800ULL, 0x000000131e007388ULL, 0x0007e80000000800ULL,
0x0000001540007388ULL, 0x0007e80000000800ULL, 0x0000001720007388ULL, 0x0007e80000000800ULL,
0x00f0000400008388ULL, 0x0007e80000000c00ULL, 0x00f2001800008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000033ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080033ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100033ff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030025257a10ULL, 0x000fe20007ffe0ffULL,
0x0000180033ff7f8cULL, 0x0003e6000c80043fULL, 0x000000022500720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffcf7000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff297807ULL, 0x008fe40004000000ULL,
0x0000eca000287802ULL, 0x000fe40000000f00ULL, 0x00000f5000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff287224ULL, 0x000fe200078e002bULL, 0xffff2e1000007947ULL, 0x000fea000383ffffULL,
0x00000001ff297807ULL, 0x000fe40004000000ULL, 0x0000ecf000287802ULL, 0x000fe40000000f00ULL,
0x00000f0000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff287224ULL, 0x000fe200078e002bULL,
0xffff2e4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff377224ULL, 0x000fe200078e002cULL,
0x0000ed6000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6f7424ULL, 0x000fc400078e00ffULL, 0x00000e5000007944ULL, 0x03efea0003c00000ULL,
0x000000ffff2b7224ULL, 0x004fe200078e0034ULL, 0xffff2e9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff377224ULL, 0x000fe200078e002cULL, 0x0000edd000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6f7424ULL, 0x000fe400078e00ffULL,
0x00000de000007944ULL, 0x03cfea0003c00000ULL, 0x000000ffff2c7224ULL, 0x004fe200078e0034ULL,
0xffff2e5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff377224ULL, 0x000fe200078e002bULL,
0x0000ee4000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6f7424ULL, 0x000fe400078e00ffULL, 0x00000d7000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff577224ULL, 0x004fe200078e0034ULL, 0xffff31b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff377224ULL, 0x002fe200078e0055ULL, 0x0000eeb000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6f7424ULL, 0x000fc400078e00ffULL,
0x00000d0000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0034ULL,
0xffff317000007947ULL, 0x000fea000383ffffULL, 0x00000001ff297807ULL, 0x010fe40004000000ULL,
0x0000ef0000287802ULL, 0x000fc40000000f00ULL, 0x00000cf000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff287224ULL, 0x000fe200078e002bULL, 0xffff43f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff297807ULL, 0x000fe40004000000ULL, 0x0000ef5000287802ULL, 0x000fc40000000f00ULL,
0x00000ca000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff287224ULL, 0x000fe200078e002bULL,
0xffff443000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6e7424ULL, 0x008fe200078e00ffULL,
0x0000efb000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff6f7424ULL, 0x000fc400078e00ffULL,
0x00000c0000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff287224ULL, 0x004fe200078e0034ULL,
0xffff44a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff377224ULL, 0x00afe200078e0055ULL,
0x0000f02000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6f7424ULL, 0x000fe400078e00ffULL, 0x00000b9000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff287224ULL, 0x004fe200078e0034ULL, 0xffff455000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6e7424ULL, 0x000fe200078e00ffULL, 0x0000f08000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff6f7424ULL, 0x000fe400078e00ffULL, 0x00000b3000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff697224ULL, 0x004fe200078e0034ULL, 0xffff481000007947ULL, 0x000fea000383ffffULL,
0x000000ffff377224ULL, 0x002fe200078e0055ULL, 0x0000f0f000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6f7424ULL, 0x000fe400078e00ffULL,
0x00000ac000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0034ULL,
0xffff47c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff297807ULL, 0x002fe40004000000ULL,
0x0000f14000287802ULL, 0x000fc40000000f00ULL, 0x00000ab000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff287224ULL, 0x000fe200078e002bULL, 0xffff578000007947ULL, 0x000fea000383ffffULL,
0x00000001ff297807ULL, 0x000fe40004000000ULL, 0x0000f19000287802ULL, 0x000fc40000000f00ULL,
0x00000a6000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff287224ULL, 0x000fe200078e002bULL,
0xffff57c000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6e7424ULL, 0x002fe200078e00ffULL,
0x0000f1f000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff6f7424ULL, 0x000fc400078e00ffULL,
0x000009c000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff287224ULL, 0x004fe200078e0034ULL,
0xffff583000007947ULL, 0x000fea000383ffffULL, 0x000000ffff377224ULL, 0x002fe200078e0055ULL,
0x0000f26000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6f7424ULL, 0x000fe400078e00ffULL, 0x0000095000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff287224ULL, 0x004fe200078e0034ULL, 0xffff58e000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6e7424ULL, 0x000fe200078e00ffULL, 0x0000f2c000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff6f7424ULL, 0x000fe400078e00ffULL, 0x000008f000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff5b7224ULL, 0x004fe200078e0034ULL, 0xffff5b9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff377224ULL, 0x002fe200078e0055ULL, 0x0000f33000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6f7424ULL, 0x000fe400078e00ffULL,
0x0000088000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0034ULL,
0xffff5b4000007947ULL, 0x000fea000383ffffULL, 0x00000001ff297807ULL, 0x002fe40004000000ULL,
0x0000f38000287802ULL, 0x000fc40000000f00ULL, 0x0000087000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff287224ULL, 0x000fe200078e002bULL, 0xffff6ad000007947ULL, 0x000fea000383ffffULL,
0x00000001ff297807ULL, 0x000fe40004000000ULL, 0x0000f3d000287802ULL, 0x000fc40000000f00ULL,
0x0000082000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff287224ULL, 0x000fe200078e002bULL,
0xffff6b1000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6e7424ULL, 0x002fe200078e00ffULL,
0x0000f43000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff6f7424ULL, 0x000fc400078e00ffULL,
0x0000078000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff287224ULL, 0x004fe200078e0034ULL,
0xffff6b8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff377224ULL, 0x002fe200078e0055ULL,
0x0000f4a000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6f7424ULL, 0x000fe400078e00ffULL, 0x0000071000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff287224ULL, 0x004fe200078e0034ULL, 0xffff6c3000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6e7424ULL, 0x000fe200078e00ffULL, 0x0000f50000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff6f7424ULL, 0x000fe400078e00ffULL, 0x000006b000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff317224ULL, 0x004fe200078e0034ULL, 0xffff6ef000007947ULL, 0x000fea000383ffffULL,
0x000000ffff377224ULL, 0x002fe200078e0055ULL, 0x0000f57000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6f7424ULL, 0x000fe400078e00ffULL,
0x0000064000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0034ULL,
0xffff6ea000007947ULL, 0x000fea000383ffffULL, 0x000000ffff297224ULL, 0x000fe200078e0037ULL,
0x0000f5d000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3e7424ULL, 0x000fc400078e00ffULL,
0x000005a000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0029ULL,
0xffffe7f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff297224ULL, 0x000fe200078e003dULL,
0x0000f63000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3e7424ULL, 0x002fc400078e00ffULL,
0x0000054000007944ULL, 0x020fea0003c00000ULL, 0x000000293d407209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e0006ULL, 0x0000f68000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff3e7424ULL, 0x002fc400078e00ffULL, 0x000004f000007944ULL, 0x000fea0003c00000ULL,
0x0000002906067209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e0007ULL,
0x0000f6d000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3e7424ULL, 0x002fc400078e00ffULL,
0x000004a000007944ULL, 0x000fea0003c00000ULL, 0x0000002907367209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e0037ULL, 0x0000f72000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff3e7424ULL, 0x002fc400078e00ffULL, 0x0000045000007944ULL, 0x000fea0003c00000ULL,
0x0000002937047209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e0040ULL,
0x0000f77000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff3e7424ULL, 0x002fc400078e00ffULL,
0x0000040000007944ULL, 0x000fea0003c00000ULL, 0x0000002940057209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e0006ULL, 0x0000f7c000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff3e7424ULL, 0x002fc400078e00ffULL, 0x000003b000007944ULL, 0x000fea0003c00000ULL,
0x0000002906067209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e0036ULL,
0x0000f81000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff3e7424ULL, 0x002fc400078e00ffULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0xffffe6b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e0040ULL, 0x0000f88000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fc400078e00ffULL, 0x00001c1fff6e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff6f7224ULL, 0x000fe400078e001dULL, 0x0000033000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e0034ULL, 0xffffec7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x002fe200078e0042ULL, 0x0000f90000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fe400078e00ffULL, 0x00001c1fff6e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff6f7224ULL, 0x000fe400078e001dULL, 0x000002b000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff377224ULL, 0x002fe200078e00ffULL, 0x0000f96000287802ULL, 0x000fe20000000f00ULL,
0x00001c1fff6e7424ULL, 0x000fc400078e00ffULL, 0x000000ffff6f7224ULL, 0x000fe400078e001dULL,
0x000000ffff197224ULL, 0x004fe400078e0034ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff6f7224ULL, 0x002fe200078e001dULL, 0x0000f9c000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fe400078e00ffULL, 0x00001c1fff6e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1a7224ULL, 0x004fe400078e0034ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0034ULL, 0xffffebb000007947ULL, 0x000fea000383ffffULL,
0x018000003a027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000003a00028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff3aff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x800000003a037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003a00027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0006ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xffff049002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000004200007348ULL, 0x000fe80003800000ULL, 0x0c00003e29297389ULL, 0x0002a200000e003fULL,
0xffff045008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff297424ULL, 0x000fe200078e00ffULL,
0x0000006f00007348ULL, 0x000fe80003800000ULL, 0x0000003736347389ULL, 0x0002a200000e006eULL,
0xffff041028007950ULL, 0x000fea0003c3ffffULL, 0x000000012900780cULL, 0x000fe20003f05070ULL,
0x0000005400007348ULL, 0x000fd80003800000ULL, 0x0000000000297806ULL, 0x000fc800040e0100ULL,
0x00000054292b7212ULL, 0x000fe200078ec0ffULL, 0x00000000ff297424ULL, 0x000fc800078e00ffULL,
0xffff03b028007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000348ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000928ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000009b8ULL, 0x0000000000000880ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001238ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001258ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001268ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001288ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001318ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001320ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001330ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001500ULL, 0x000000000000fd00ULL, 0x7200001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000011200ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000011210ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000011210ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000011690ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001318ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000fee8ULL, 0x000000000000fee8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000011200ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000011690ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_89_cubin_len = 71536;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
