/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_16_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x000000000000fd90ULL, 0x000000000000f910ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x000000000000e500ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x000000000000e670ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x000000000000e6b0ULL, 0x00000000000000d0ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x000000000000e780ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000e50000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x0038980400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808692ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0000e50000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808e0828808081ULL, 0xb508288080b00828ULL, 0x288080ae08288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080aeULL, 0x0000001cffffffffULL, 0x000000e000000000ULL,
0x0000e67000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808e0828808081ULL, 0xb508288080ae0828ULL, 0x288080b008288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080b0ULL, 0x0000001cffffffffULL, 0x0000016000000000ULL,
0x0000e6b000000000ULL, 0x000000d000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL,
0x0008120400000077ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000007c00043704ULL, 0x0000000d00080a04ULL,
0x0058190300580160ULL, 0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL,
0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL,
0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x0018310400ff1b03ULL, 0x0000d8e00000d360ULL, 0x0000d9600000d8f0ULL,
0x0000d9800000d970ULL, 0xffffffff00e82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500000fffffffffULL, 0x0500000f0500000fULL, 0xffffffff0500000fULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00e82804ffffffffULL, 0x000000f0000000c0ULL,
0x00001a0000001970ULL, 0x00001ab000001a70ULL, 0x0000206000002030ULL, 0x0000304000002fa0ULL,
0x000030f0000030b0ULL, 0x000035c0000035b0ULL, 0x000043c000004320ULL, 0x0000447000004430ULL,
0x0000488000004850ULL, 0x000056f000005660ULL, 0x0000579000005750ULL, 0x00005bc000005bb0ULL,
0x000063b0000063a0ULL, 0x00008e2000008e00ULL, 0x00009320000092f0ULL, 0x0000d2600000d230ULL,
0x0000d2800000d270ULL, 0x0000d2c00000d2a0ULL, 0x0000d2f00000d2e0ULL, 0x0000d9b00000d950ULL,
0x0000d9d00000d9c0ULL, 0x0000e0900000e010ULL, 0x0000e1400000e0e0ULL, 0x0000e1e00000e190ULL,
0x0000e2800000e230ULL, 0x0000e3200000e2d0ULL, 0x0000e4100000e390ULL, 0x0000e4d00000e470ULL,
0x0000017003e03904ULL, 0x0000f600000000ffULL, 0x000001b0003f0100ULL, 0x0000f6080000000fULL,
0x000001e0003f0130ULL, 0x0000f6100000000fULL, 0x00000210003f0130ULL, 0x0000f6480000000fULL,
0x00000240003f0120ULL, 0x0000f6680000000fULL, 0x00000460003f0120ULL, 0x0000f600000000ffULL,
0x00000660003f0107ULL, 0x0000f61400000004ULL, 0x00000740003f0102ULL, 0x0000f61000000004ULL,
0x00000d70003f0101ULL, 0x00000000000000ffULL, 0x00000e0000040107ULL, 0x0000002000000011ULL,
0x00000f80003f0101ULL, 0x0000002400000011ULL, 0x00001030003f0106ULL, 0x0000002400000011ULL,
0x000010c0003f0106ULL, 0x0000002400000011ULL, 0x00001700003f0106ULL, 0x000000000000006dULL,
0x0000177000040107ULL, 0x0000000400000042ULL, 0x0000179000040106ULL, 0x0000f60c00000015ULL,
0x000018a0003f0106ULL, 0x0000000400000019ULL, 0x00001d30003f0106ULL, 0x0000000400000042ULL,
0x00001dd000040106ULL, 0x0000000400000042ULL, 0x0000264000040106ULL, 0x0000002000000011ULL,
0x000026c0003f0101ULL, 0x0000000000000018ULL, 0x00002770003f0101ULL, 0x0000002400000011ULL,
0x000027c0003f0106ULL, 0x0000002400000011ULL, 0x00002850003f0106ULL, 0x0000002400000011ULL,
0x00002d40003f0106ULL, 0x00000000000000ffULL, 0x00002db000060107ULL, 0x0000000400000062ULL,
0x00002dd0003f0106ULL, 0x0000f61c00000015ULL, 0x00002ee0003f0106ULL, 0x0000f61c00000015ULL,
0x000033a0003f0106ULL, 0x0000f64c0000001aULL, 0x00003430003f0106ULL, 0x0000f64c0000001aULL,
0x00003b00003f0106ULL, 0x0000002000000011ULL, 0x00003b80003f0101ULL, 0x0000000000000018ULL,
0x00003c10003f0101ULL, 0x0000002400000011ULL, 0x00003c70003f0106ULL, 0x0000002400000011ULL,
0x00003d00003f0106ULL, 0x0000002400000011ULL, 0x000040c0003f0106ULL, 0x000000000000006dULL,
0x0000413000040107ULL, 0x00000004000000ffULL, 0x0000415000060106ULL, 0x0000f62c00000015ULL,
0x00004260003f0106ULL, 0x0000f62c00000015ULL, 0x00004700003f0106ULL, 0x0000f64c00000018ULL,
0x00004790003f0106ULL, 0x00000004000000ffULL, 0x00004e3000060106ULL, 0x0000002000000011ULL,
0x00004eb0003f0101ULL, 0x0000000000000018ULL, 0x00004f40003f0101ULL, 0x0000002400000011ULL,
0x00004f90003f0106ULL, 0x0000002400000011ULL, 0x00005020003f0106ULL, 0x0000002400000011ULL,
0x00005430003f0106ULL, 0x00000000000000ffULL, 0x000054a000060107ULL, 0x0000000400000062ULL,
0x000054c0003f0106ULL, 0x0000f63c00000015ULL, 0x000055a0003f0106ULL, 0x0000f63c00000015ULL,
0x00005a60003f0106ULL, 0x0000f64c0000005fULL, 0x00005af0003f0106ULL, 0x0000f64c0000005fULL,
0x000060e0003f0106ULL, 0x0000002000000011ULL, 0x00006140003f0101ULL, 0x0000f64000000015ULL,
0x0000ae90003f0101ULL, 0x0000f604000000ffULL, 0x0000af20003f0106ULL, 0x0000f604000000ffULL,
0x0000b140003f0106ULL, 0x0000f600000000ffULL, 0x0000b150003f0101ULL, 0x0000f604000000ffULL,
0x0000b1d0003f0106ULL, 0x0000f604000000ffULL, 0x0000c710003f0106ULL, 0x0000f6140000003eULL,
0x0000cb10003f0106ULL, 0x0000f6140000003eULL, 0x0000df50003f0106ULL, 0x0000f6080000003eULL,
0x00053803003f0101ULL, 0x00009d2000141c04ULL, 0x0000b2200000a170ULL, 0x0000dfb00000b2f0ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001ccULL, 0x0000001100000002ULL,
0x000000000000014cULL, 0x0000001100000002ULL, 0x00000000000000ccULL, 0x0000001100000002ULL,
0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001a7ULL, 0x0000001100000002ULL,
0x0000000000000127ULL, 0x0000001100000002ULL, 0x00000000000000a8ULL, 0x0000001100000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002300ULL,
0x00000004ff117424ULL, 0x000fe200078e00ffULL, 0x0000460000087ab9ULL, 0x000fe20000000a00ULL,
0x00005800ff1e7624ULL, 0x000fe200078e00ffULL, 0x0000000000037919ULL, 0x000e680000002200ULL,
0x0000000000077919ULL, 0x000ea80000002100ULL, 0x0000000000407919ULL, 0x000ee80000002700ULL,
0x00000000001d7919ULL, 0x000f220000002600ULL, 0x0000000106007824ULL, 0x002fc800078e0203ULL,
0x00000080000f7824ULL, 0x104fe200078e0207ULL, 0x00000005ff487819ULL, 0x000fe20000011607ULL,
0x00001fff06007589ULL, 0x00066600000e0000ULL, 0x000000ff0f00720cULL, 0x040fe40003f05270ULL,
0x000000030f00780cULL, 0x040fe20003f44070ULL, 0x00001fff48487589ULL, 0x000ea200000e0000ULL,
0x0000007f0f00780cULL, 0x040fe20003f24070ULL, 0x0000620040067625ULL, 0x008fe200078e0011ULL,
0x000000010f00780cULL, 0x000fce0003f64070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff04a424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff05a424ULL, 0x000fe200078e00ffULL, 0x00f60002ff008388ULL, 0x0007e20000000a00ULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0x3fffff80ff0aa424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0ba424ULL, 0x000fe200078e00ffULL, 0x00f608040f00a388ULL, 0x0007e2000000ca00ULL,
0x3fffffc0ff08a424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL,
0x00f6100a0f00a388ULL, 0x0007e2000000ca00ULL, 0xff317217ff0e9424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL, 0x00f648080f00a388ULL, 0x0007e20000008a00ULL,
0x7fffffc0ff0db424ULL, 0x000fc600078e00ffULL, 0x00f4000e0f009388ULL, 0x0007e80000004800ULL,
0x00f6680c0f00b388ULL, 0x0007e80000008a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x00000000000d7919ULL, 0x01ce620000000000ULL,
0x0000000448047824ULL, 0x000fc400078e00ffULL, 0x000000101e037824ULL, 0x000fe400078e00ffULL,
0x000000101d027824ULL, 0x000fe400078e00ffULL, 0x00000100ff0e7424ULL, 0x000fe400078e00ffULL,
0x0000004003027224ULL, 0x000fe200078e0202ULL, 0x000000040d097211ULL, 0x042fe200078fe0ffULL,
0x000000100d047824ULL, 0x000fc600078e00ffULL, 0x00000002090b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000102037824ULL, 0x040fe200078e0209ULL, 0x0000000709057812ULL, 0x000fe400078ec0ffULL,
0x000000070b0c7812ULL, 0x000fe200078ec0ffULL, 0x00000001020a7824ULL, 0x000fe200078e020bULL,
0x000000f0040f7812ULL, 0x000fe200078ec0ffULL, 0x00005c0003027625ULL, 0x080fe200078e000eULL,
0x0000000f05087812ULL, 0x100fe400078e780dULL, 0x0000000f0c0c7812ULL, 0x000fe200078e780dULL,
0x00005c000a047625ULL, 0x000fe200078e000eULL, 0x0000000f02027210ULL, 0x000fc60007f1e0ffULL,
0x0000001009087824ULL, 0x000fe200078e0208ULL, 0x0000000f04047210ULL, 0x000fe20007f3e0ffULL,
0x000000100b0c7824ULL, 0x000fe400078e020cULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x0000001008097824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x000000100c0b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e8000b901c48ULL, 0x00000000040b7faeULL, 0x0003e8000b901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000806177981ULL, 0x014ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000f220000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000004ff497e24ULL, 0x010fe2000f8e00ffULL, 0x0000003f17007810ULL, 0x004fc40007ffe0ffULL,
0x000000ff17027810ULL, 0x00afe40007ffe0ffULL, 0x00000006ff007819ULL, 0x000fe40000011600ULL,
0x00000008ff027819ULL, 0x000fca0000011602ULL, 0x00009c2000008947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe20000011648ULL, 0x00000003ff077424ULL, 0x000fe400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fe200078e00ffULL, 0x03ffffff03047812ULL, 0x000fca00078ec0ffULL,
0x00000004490c7824ULL, 0x000fca00078e0204ULL, 0x000000000c00720cULL, 0x000fda0003f06070ULL,
0x0000000240048824ULL, 0x000fe400078e00ffULL, 0x00006400ff058624ULL, 0x000fc800078e00ffULL,
0x0000640004058624ULL, 0x000fe400078e0205ULL, 0x0000001048047824ULL, 0x000fe400078e00ffULL,
0x000000010c058824ULL, 0x000fe200078e0205ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6140704ff738cULL, 0x0003e20000000000ULL, 0x0000600005088625ULL, 0x000fe200078e0011ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000008080e8981ULL, 0x0004e2000c1e1900ULL,
0x00000300ff0a7624ULL, 0x000fe200078e00ffULL, 0x000000030c067812ULL, 0x000fe400078ec0ffULL,
0x00000001490f7810ULL, 0x000fe20007ffe0ffULL, 0xfffffffd11057424ULL, 0x000fe200078e020aULL,
0x000000030600780cULL, 0x000fe20003f05270ULL, 0x00000080ff2f7424ULL, 0x000fe200078e00ffULL,
0x00f6100004ff7f8cULL, 0x0009e4000c80043fULL, 0x0000000105077807ULL, 0x002fca0004000000ULL,
0x000000010c077824ULL, 0x000fe200078e0207ULL, 0x0000000000087919ULL, 0x004e680000000000ULL,
0x000000000700720cULL, 0x000fe40003f06070ULL, 0x0000000148097812ULL, 0x000fd600078ec0ffULL,
0x0000000240068824ULL, 0x000fe400078e00ffULL, 0x00006400ff0b8624ULL, 0x000fc800078e00ffULL,
0x0000640006068624ULL, 0x000fc800078e020bULL, 0x00000001060c8824ULL, 0x000fe400078e0207ULL,
0x0000001009127824ULL, 0x000fe400078e00ffULL, 0x000060000c0c8625ULL, 0x000fe200078e0011ULL,
0x00000003ff117819ULL, 0x002fe40000011608ULL, 0x00000001ff0a7819ULL, 0x000fe20000011648ULL,
0xffffffffff067424ULL, 0x000fe400078e00ffULL, 0x0000000112137824ULL, 0x000fc400078e0211ULL,
0x000000200a0b7824ULL, 0x000fe400078e00ffULL, 0x0000000813157824ULL, 0x040fe200078e00ffULL,
0x0000000813107212ULL, 0x000fe200078e3cffULL, 0x000000080c068981ULL, 0x000362000c1e1900ULL,
0x0000000411197810ULL, 0x000fe20007ffe0ffULL, 0x000000000a0473c2ULL, 0x000ea200000e0000ULL,
0xfffffff815147812ULL, 0x000fe200078ee210ULL, 0x0000010049107824ULL, 0x000fe200078e020bULL,
0x0000000811217810ULL, 0x000fe20007ffe0ffULL, 0x00000001121b7824ULL, 0x000fe200078e0219ULL,
0x000000020f00720cULL, 0x000fe20003f06070ULL, 0x00000010082d7824ULL, 0x000fe200078e00ffULL,
0x0000000c11277810ULL, 0x000fe20007ffe0ffULL, 0x000000081b0f7824ULL, 0x000fe200078e00ffULL,
0x00000010170d7217ULL, 0x002fe20007800000ULL, 0x0000000112237824ULL, 0x040fe200078e0221ULL,
0x000000081b0c7212ULL, 0x080fe200078e3cffULL, 0x0000000112297824ULL, 0x000fe200078e0227ULL,
0x0000003f13137812ULL, 0x000fe200078ec0ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0a10ULL,
0xfffffff80f187812ULL, 0x000fe200078ee20cULL, 0x00000008230f7824ULL, 0x040fe200078e00ffULL,
0x00000008230c7212ULL, 0x000fe200078e3cffULL, 0x00000008291c7824ULL, 0x000fe200078e00ffULL,
0x000000200d0d7807ULL, 0x000fe20000000000ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0xfffffff80f1a7812ULL, 0x000fe200078ee20cULL, 0x000020000a0c7824ULL, 0x000fe200078e00ffULL,
0x000000120d0f7217ULL, 0x000fe20007800000ULL, 0x000000401d0d7824ULL, 0x000fe200078e00ffULL,
0x0000000829157212ULL, 0x000fe200078e3cffULL, 0x0000f64804047891ULL, 0x004fe2000f8e203fULL,
0x0000003f1b1b7812ULL, 0x000fe200078ec0ffULL, 0x000000010f167824ULL, 0x000fe200078e0a12ULL,
0x000000200d107812ULL, 0x000fe200078ef810ULL, 0x000000401e0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee215ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000b0000c157810ULL, 0x000fe20007ffe0ffULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x000000161100720cULL, 0x080fe20003f46070ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000003f23237812ULL, 0x000fe200078ec0ffULL, 0x00000010141d7824ULL, 0x100fe200078e0215ULL,
0x0000003f29297812ULL, 0x000fe200078ec0ffULL, 0x00000010181f7824ULL, 0x100fe200078e0215ULL,
0x000000702d2d7812ULL, 0x000fe200078ec0ffULL, 0x000000101a257824ULL, 0x100fe200078e0215ULL,
0x000000161900720cULL, 0x080fe20003f26070ULL, 0x000000101c2b7824ULL, 0x000fe200078e0215ULL,
0x000000162100720cULL, 0x000fc40003f06070ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000e0f0e7224ULL, 0x008fc800078e0210ULL, 0x000000010e107824ULL, 0x040fe400078e0213ULL,
0x000000010e127824ULL, 0x000fe400078e021bULL, 0x00005e0010107625ULL, 0x000fc800078e002fULL,
0x000000010e147824ULL, 0x000fe200078e0223ULL, 0x0000002d101a7210ULL, 0x000fe20007f7e0ffULL,
0x000000010e187824ULL, 0x000fe200078e0229ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00005e0012127625ULL, 0x000fc800078e002fULL, 0x00005e0014147625ULL, 0x000fe200078e002fULL,
0x0000002d12127210ULL, 0x000fc60007f9e0ffULL, 0x00005e0018187625ULL, 0x000fe200078e002fULL,
0x0000002d14147210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e0611ULL,
0x000000162700720cULL, 0x000fe20003f66070ULL, 0x000000ffff137224ULL, 0x000fe200020e0613ULL,
0x0000002d18187210ULL, 0x000fe20007fde0ffULL, 0x000000ffff157224ULL, 0x000fe200028e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a1d7faeULL, 0x0009e2000d101c48ULL,
0xff317217ff0e7424ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x00000000121f7faeULL, 0x0009e2000c901c48ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x0000f6480a117811ULL, 0x000fc400078e18ffULL,
0x0000000014257faeULL, 0x0003e2000c101c48ULL, 0x000000024900720cULL, 0x000fc60003f06070ULL,
0x00000000182b7faeULL, 0x0009e8000d901c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x000000ffff257224ULL, 0x002fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200011ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x010fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000536000000947ULL, 0x000fea0003800000ULL, 0x0000000240127824ULL, 0x002fe200078e00ffULL,
0x00007610ff727816ULL, 0x000fe20000000072ULL, 0x00006400ff137624ULL, 0x000fe200078e00ffULL,
0x00007610ff737816ULL, 0x000fe20000000073ULL, 0xff317217ff0e7424ULL, 0x000fc400078e00ffULL,
0x0000640012127624ULL, 0x000fe200078e0213ULL, 0x00007610ff137816ULL, 0x000fe20000000013ULL,
0x000000ffff717224ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fe400078e00ffULL,
0xffffffc004147812ULL, 0x000fca00078ec0ffULL, 0x0000010049147824ULL, 0x000fca00078e0214ULL,
0x000000171400720cULL, 0x000fda0003f06070ULL, 0x0000523000000947ULL, 0x002fea0003800000ULL,
0x0000240011157984ULL, 0x000e620000000800ULL, 0x0000ffff720a7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff707224ULL, 0x000fe400078e0007ULL, 0x000000ffff147224ULL, 0x000fe200078e0071ULL,
0x000088800a187816ULL, 0x000fca00000000ffULL, 0x80000000180a7824ULL, 0x000fca00078e00ffULL,
0x8000000015ff7812ULL, 0x002fe2000780480aULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x00007610736e7816ULL, 0x000fe4000000006eULL, 0x0000761072567816ULL, 0x000fe20000000056ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000240011157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe4000780480aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000018187824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL, 0x0000000a00157305ULL, 0x0002a4000021f000ULL,
0x3fa000000a0a7823ULL, 0x002fe200000100ffULL, 0x000000150000735dULL, 0x004fe40003800000ULL,
0x0000240011157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fc40007804818ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000003070a7812ULL, 0x000fe200078ec0ffULL, 0x0000010049697824ULL, 0x000fc600078e00ffULL,
0x000000030a00780cULL, 0x000fc80003f05270ULL, 0x00000001050a7807ULL, 0x000fca0004000000ULL,
0x0000000107077824ULL, 0x000fe200078e020aULL, 0x00000001ff0a7819ULL, 0x000fc80000011648ULL,
0x000000000700720cULL, 0x000fe20003f06070ULL, 0x000000200a157824ULL, 0x000fca00078e0269ULL,
0x00000040151a7810ULL, 0x000fc80007ffe0ffULL, 0x000000200d157812ULL, 0x000fe400078ef81aULL,
0x00000003ff1d7819ULL, 0x000fe20000011608ULL, 0x0000000112188824ULL, 0x000fe400078e0207ULL,
0x00000004ff198424ULL, 0x000fe400078e00ffULL, 0x0000000f061e7224ULL, 0x020fe200078e0215ULL,
0x00000010041c7812ULL, 0x000fe200078ec0ffULL, 0xffffffffff067424ULL, 0x000fe200078e00ffULL,
0x000000041d407810ULL, 0x000fe20007ffe0ffULL, 0x0000600018188625ULL, 0x000fe200078e0019ULL,
0x0000000149157810ULL, 0x000fc60007ffe0ffULL, 0x000000011d557824ULL, 0x100fe200078e021cULL,
0x0000000818068981ULL, 0x000362000c1e1900ULL, 0x000000021500720cULL, 0x000fe20003f06070ULL,
0x0000000140537824ULL, 0x000fe200078e021cULL, 0x0000001a17157217ULL, 0x000fe20007800000ULL,
0x00000008481b7824ULL, 0x000fe200078e00ffULL, 0x0000000855547212ULL, 0x080fe200078e3cffULL,
0x00000008531f7824ULL, 0x040fe200078e00ffULL, 0x0000000853527212ULL, 0x000fe200078e3cffULL,
0x0000000115157824ULL, 0x000fe200078e0a1aULL, 0x000000081d417810ULL, 0x000fe20007ffe0ffULL,
0x0000000855197824ULL, 0x042fe200078e00ffULL, 0x0000003f55557812ULL, 0x000fe200078ec0ffULL,
0x00000010084b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f527812ULL, 0x000fe200078ee252ULL,
0x00000080ff1f7424ULL, 0x000fe200078e00ffULL, 0x0000002015157807ULL, 0x000fe20000000000ULL,
0x000000011e187824ULL, 0x000fe200078e0255ULL, 0xfffffff01b1b7812ULL, 0x000fe200078ec0ffULL,
0x0000000871427824ULL, 0x000fe200078e00ffULL, 0xfffffff819547812ULL, 0x000fe200078ee254ULL,
0x0000000141517824ULL, 0x100fe200078e021cULL, 0x000000704b437812ULL, 0x000fe200078ec0ffULL,
0x00005e0018187625ULL, 0x000fe200078e001fULL, 0x0000001c15157217ULL, 0x000fe20007800000ULL,
0x000000001b0473c2ULL, 0x0002a200000e0000ULL, 0x0000000c1d447810ULL, 0x000fe20007ffe0ffULL,
0x00001000711a7824ULL, 0x000fe200078e00ffULL, 0x00000008426d7812ULL, 0x000fe200078e0cffULL,
0x0000000115157824ULL, 0x100fe200078e0a1cULL, 0x0000000851507212ULL, 0x080fe200078e3cffULL,
0x00000001444f7824ULL, 0x000fe200078e021cULL, 0x0000003f53537812ULL, 0x000fe200078ec0ffULL,
0x00000008511b7824ULL, 0x002fe200078e00ffULL, 0x0000004318187210ULL, 0x000fe20007f1e0ffULL,
0x000000006d0573c2ULL, 0x000e6200000e0000ULL, 0x000000084f4e7212ULL, 0x040fe200078e3cffULL,
0x000000084f457824ULL, 0x000fe200078e00ffULL, 0xfffffff81b507812ULL, 0x000fe200078ee250ULL,
0x000000011e1b7824ULL, 0x000fe200078e0253ULL, 0x0000003f51517812ULL, 0x000fe200078ec0ffULL,
0x000000ffff197224ULL, 0x000fe200000e0619ULL, 0x000000151d00720cULL, 0x000fc40003f06070ULL,
0x000010001a1d7812ULL, 0x000fe200078e0cffULL, 0x00005e001b1a7625ULL, 0x000fe200078e001fULL,
0x0000003f4f4f7812ULL, 0x000fe400078ec0ffULL, 0x000000154000720cULL, 0x000fe20003f26070ULL,
0x000000011e1c7824ULL, 0x000fe200078e0251ULL, 0x000000431a1a7210ULL, 0x000fe20007f5e0ffULL,
0x000000011e1e7824ULL, 0x000fe200078e024fULL, 0x000000154400720cULL, 0x000fe20003f66070ULL,
0x000020000a407824ULL, 0x000fe200078e021dULL, 0x0000f64804047890ULL, 0x004fe2000fffe03fULL,
0x00005e001c1c7625ULL, 0x000fe200078e001fULL, 0xfffffff8454e7812ULL, 0x000fc600078ee24eULL,
0x00005e001e1e7625ULL, 0x000fe200078e001fULL, 0x000000431c1c7210ULL, 0x000fe20007f9e0ffULL,
0x0000000504057290ULL, 0x002fe4000fffe03fULL, 0x000000ffff1b7224ULL, 0x000fe200010e061bULL,
0x000000154100720cULL, 0x000fe20003f46070ULL, 0x000000ffff1d7224ULL, 0x000fe200020e061dULL,
0x0000b00040417810ULL, 0x000fe20007ffe0ffULL, 0x0000000448157824ULL, 0x000fe200078e00ffULL,
0x000000431e1e7210ULL, 0x000fc60007fbe0ffULL, 0x0000001054677824ULL, 0x100fe200078e0241ULL,
0xfffffff015157812ULL, 0x000fe200078ec0ffULL, 0x0000001052667824ULL, 0x100fe400078e0241ULL,
0x0000001050657824ULL, 0x000fe200078e0241ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018677faeULL, 0x0003e2000c101c48ULL, 0x000000ffff1f7224ULL, 0x000fe400028e061fULL,
0x000000104e647824ULL, 0x000fe200078e0241ULL, 0x000000001a667faeULL, 0x0003e8000c901c48ULL,
0x000000001c657faeULL, 0x0003e8000d101c48ULL, 0x000000001e647faeULL, 0x0003e8000d901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000404421b7984ULL, 0x0022a20008000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f60c00151a7984ULL, 0x000ee20000000800ULL,
0x0000ffff73187812ULL, 0x000fc400078ec0ffULL, 0x0000ffff13197812ULL, 0x000fe400078ec0ffULL,
0x00008880181d7816ULL, 0x000fe400000000ffULL, 0x00008880194c7816ULL, 0x000fc600000000ffULL,
0x800000001d187824ULL, 0x000fe400078e00ffULL, 0x800000004c197824ULL, 0x000fc600078e00ffULL,
0x800000001bff7812ULL, 0x004fe40007804818ULL, 0x800000001aff7812ULL, 0x008fe20007824819ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000f60803197811ULL, 0x000fe200078e20ffULL, 0x3e000000ff187424ULL, 0x000fe400078e00ffULL,
0x800000004c1b7824ULL, 0x000fe400078e00ffULL, 0x00000018001a7305ULL, 0x0004e4000021f000ULL,
0x3fa0000018187823ULL, 0x004fe200000100ffULL, 0x0000001a0000735dULL, 0x008fe40003800000ULL,
0x00000400191a7984ULL, 0x000ea40000000800ULL, 0x800000001aff7812ULL, 0x004fc4000782481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000001ff4d7819ULL, 0x000fe20000011608ULL, 0x00000001ff407424ULL, 0x000fe200078e00ffULL,
0x000000704b4b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c4d4d7812ULL, 0x000fc600078ec0ffULL,
0x0000008003187824ULL, 0x000fc800078e024bULL, 0x0000000118187824ULL, 0x000fca00078e024dULL,
0x00f0000018197984ULL, 0x000ea80000000800ULL, 0x00f20000181b7984ULL, 0x0007220000000800ULL,
0x0000000e1900720bULL, 0x004fda0003f3d000ULL, 0x00000000001a7806ULL, 0x000fc800008e0100ULL,
0x0000ffff1a1e7812ULL, 0x000fda000782c0ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x0000000e1900720bULL, 0x018fe40003f34000ULL, 0x000000190e417209ULL, 0x000fe40007810000ULL,
0x00000002ff1a7819ULL, 0x000fc60000011608ULL, 0x800000410e187221ULL, 0x000fe20000010000ULL,
0x000000081a1c7810ULL, 0x000fc60007ffe0ffULL, 0x3fb8aa3b18187820ULL, 0x000fe40000410000ULL,
0x00000000000e7806ULL, 0x000fe400008e0100ULL, 0x0000001800437308ULL, 0x000ea20000000800ULL,
0x000000480300720cULL, 0x000fe40003f25270ULL, 0x0000ffff0e1f7812ULL, 0x000fc800078e3cffULL,
0x0000001f1eff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff407807ULL, 0x000fc60001000000ULL,
0x00000080480e9824ULL, 0x000fe200078e024bULL, 0x00001f1c431c7589ULL, 0x004ea200000e0000ULL,
0x0000004310107220ULL, 0x000fe40000410000ULL, 0x000000014d0e9824ULL, 0x000fe400078e020eULL,
0x8000004119192221ULL, 0x100fe20000010000ULL, 0x00001f1a431a7589ULL, 0x000ee600000e0000ULL,
0x3fb8aa3b19192820ULL, 0x000fe20000410000ULL, 0x00f400410e009388ULL, 0x0009e60000000800ULL,
0x0000001900162308ULL, 0x000e620000000800ULL, 0x000000ffff0e7224ULL, 0x010fe200078e0041ULL,
0x0000001c23237220ULL, 0x084fe20000410000ULL, 0x0000001c22227220ULL, 0x080fe20000410000ULL,
0x0000001c33337220ULL, 0x080fe20000410000ULL, 0x0000001c32327220ULL, 0x080fe20000410000ULL,
0x0000001c37377220ULL, 0x080fe20000410000ULL, 0x0000001c36367220ULL, 0x080fe20000410000ULL,
0x0000001c27277220ULL, 0x080fe20000410000ULL, 0x0000001c26267220ULL, 0x080fe20000410000ULL,
0x0000001c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000001c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001c2e2e7220ULL, 0x000fe20000410000ULL,
0x0000001a21217220ULL, 0x088fe20000410000ULL, 0x0000001a20207220ULL, 0x080fe20000410000ULL,
0x0000001a31317220ULL, 0x080fe20000410000ULL, 0x0000001a30307220ULL, 0x080fe20000410000ULL,
0x0000001a35357220ULL, 0x080fe20000410000ULL, 0x0000001a34347220ULL, 0x080fe20000410000ULL,
0x0000001a25257220ULL, 0x080fe20000410000ULL, 0x0000001a24247220ULL, 0x080fe20000410000ULL,
0x0000001a29297220ULL, 0x080fe20000410000ULL, 0x0000001a28287220ULL, 0x080fe20000410000ULL,
0x0000001a39397220ULL, 0x080fe20000410000ULL, 0x0000001a38387220ULL, 0x080fe20000410000ULL,
0x0000001a3d3d7220ULL, 0x080fe20000410000ULL, 0x0000001a3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001a2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001a2c2c7220ULL, 0x000fe20000410000ULL,
0x000000161b1b2220ULL, 0x002fc80000410000ULL, 0x000000101b107221ULL, 0x018fe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x0000040442187984ULL, 0x000ea20008000800ULL,
0x800000001d197824ULL, 0x000fca00078e00ffULL, 0x8000000018ff7812ULL, 0x004fe20007804819ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000001d1a7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x0000001800197305ULL, 0x0004e4000021f000ULL, 0x3fa0000018187823ULL, 0x004fe200000100ffULL,
0x000000190000735dULL, 0x008fe40003800000ULL, 0x0000040442197984ULL, 0x000ea40008000800ULL,
0x8000000019ff7812ULL, 0x004fc4000780481aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000808197812ULL, 0x000fe200078ec0ffULL,
0x00000004481d7824ULL, 0x000fe200078e00ffULL, 0x00000007081b7812ULL, 0x000fe200078ec0ffULL,
0x0000000248187824ULL, 0x040fe200078e00ffULL, 0x0000000719587812ULL, 0x140fe200078ef808ULL,
0x00001000481a7824ULL, 0x000fe200078e00ffULL, 0x0000000719457812ULL, 0x000fe400078ec808ULL,
0x000000041d1d7812ULL, 0x000fe400078ec0ffULL, 0x0000000418197812ULL, 0x000fc400078ec0ffULL,
0xffffe0001a1a7812ULL, 0x000fe400078ec0ffULL, 0x0000001d08447211ULL, 0x040fe400078fe0ffULL,
0x000000081b427812ULL, 0x002fe200078ef808ULL, 0x00001000711a7824ULL, 0x000fe200078e021aULL,
0x0000001908437211ULL, 0x000fe400078fe0ffULL, 0x00000044455b7212ULL, 0x000fe400078e3cffULL,
0x0000000743197812ULL, 0x000fc400078e7842ULL, 0x0000b0001a467810ULL, 0x000fe20007ffe0ffULL,
0x00000008586c7824ULL, 0x000fe200078e025bULL, 0x0000000244447810ULL, 0x000fe20007ffe0ffULL,
0x0000000842197824ULL, 0x000fe200078e0219ULL, 0x00000002ff5a7819ULL, 0x000fe20000011608ULL,
0x000000106c187824ULL, 0x000fe200078e0246ULL, 0x00000044455f7212ULL, 0x000fe200078e3cffULL,
0x00000010195e7824ULL, 0x000fe200078e00ffULL, 0x00000016ff41723eULL, 0x000fe400000000ffULL,
0x000000085a4a7810ULL, 0x000fe20007ffe0ffULL, 0x00000800031c7824ULL, 0x000fe200078e025eULL,
0x000000001818783bULL, 0x000e620000004200ULL, 0x00000008585d7824ULL, 0x000fe200078e025fULL,
0x0000541041597816ULL, 0x000fc40000000041ULL, 0x0000991040407816ULL, 0x000fe200000000ffULL,
0x009000001c1c783bULL, 0x000fe20000000200ULL, 0x000000105d467824ULL, 0x000fe200078e0246ULL,
0x0000000243437810ULL, 0x000fe40007ffe0ffULL, 0x00001f5a59577589ULL, 0x0004e200000e0000ULL,
0x000000ff4000720cULL, 0x000fe40003f05270ULL, 0x0000000743437812ULL, 0x000fe200078e7842ULL,
0x00001f4a595c7589ULL, 0x000f2200000e0000ULL, 0x0000008058627811ULL, 0x000fc600078e18ffULL,
0x000000004644783bULL, 0x000f220000004200ULL, 0x0000000842437824ULL, 0x000fe400078e0243ULL,
0x000000015b5b7824ULL, 0x000fe400078e0262ULL, 0x00000010435a7824ULL, 0x004fe200078e00ffULL,
0x0000312018407816ULL, 0x002fe400000000ffULL, 0x0000312019417816ULL, 0x000fe400000000ffULL,
0x00000040ff18723eULL, 0x000fe200020006ffULL, 0x000000571c1c8232ULL, 0x088fe20000000000ULL,
0x00000041ff19723eULL, 0x000fe200020006ffULL, 0x000000571e1e8232ULL, 0x000fe20000000000ULL,
0x000031201a587816ULL, 0x000fe200000000ffULL, 0x0000005c1d1d8232ULL, 0x090fe20000000000ULL,
0x000031201b597816ULL, 0x000fe200000000ffULL, 0x0000005c1f1f8232ULL, 0x000fe20000000000ULL,
0x00000800031a7824ULL, 0x000fe200078e025aULL, 0x0000312044607816ULL, 0x000fca00000000ffULL,
0x000000181c2c723cULL, 0x000fe2000000182cULL, 0x0000312045617816ULL, 0x000fe400000000ffULL,
0x00000060ff44723eULL, 0x000fe400020006ffULL, 0x00000061ff45723eULL, 0x000fe400020006ffULL,
0x00000040ff18723eULL, 0x000fe400030006ffULL, 0x00000041ff19723eULL, 0x000fc600030006ffULL,
0x000000441c24723cULL, 0x040fee0000001824ULL, 0x00000060ff44723eULL, 0x000fe200030006ffULL,
0x000000181c3c723cULL, 0x000fe2000000183cULL, 0x00000061ff45723eULL, 0x000fe400030006ffULL,
0x0000312046607816ULL, 0x000fc400000000ffULL, 0x0000312047617816ULL, 0x000fe400000000ffULL,
0x0000100071187824ULL, 0x000fe200078e020cULL, 0x00000059ff19723eULL, 0x080fe200020006ffULL,
0x000000441c34723cULL, 0x000fe20000001834ULL, 0x00000059ff59723eULL, 0x000fe400030006ffULL,
0x0000b00018637810ULL, 0x000fe40007ffe0ffULL, 0x00000058ff18723eULL, 0x080fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe200030006ffULL, 0x000000105b407824ULL, 0x000fe200078e0263ULL,
0x00000060ff44723eULL, 0x000fc400020006ffULL, 0x00000061ff45723eULL, 0x080fe200020006ffULL,
0x000000181c38723cULL, 0x040fe20000001838ULL, 0x009000001a18783bULL, 0x000e620000000200ULL,
0x00000060ff60723eULL, 0x000fe400030006ffULL, 0x00000061ff61723eULL, 0x000fe200030006ffULL,
0x000000004040783bULL, 0x000ea60000004200ULL, 0x000000581c28723cULL, 0x040fee0000001828ULL,
0x000000015f587824ULL, 0x000fe200078e0262ULL, 0x000000441c30723cULL, 0x000fe60000001830ULL,
0x0000001058467824ULL, 0x000fca00078e0263ULL, 0x000000601c20723cULL, 0x000fe20000001820ULL,
0x000000004644783bULL, 0x000eec0000004200ULL, 0x0000010049607824ULL, 0x000fe200078e00ffULL,
0x0000005718188232ULL, 0x082fe40000000000ULL, 0x000000571a1a8232ULL, 0x000fe20000000000ULL,
0x0000312040407816ULL, 0x004fe200000000ffULL, 0x0000005c19198232ULL, 0x080fe20000000000ULL,
0x0000312041417816ULL, 0x000fe200000000ffULL, 0x0000005c1b1b8232ULL, 0x000fe20000000000ULL,
0x00000040ff1c723eULL, 0x000fc400020006ffULL, 0x00000041ff1d723eULL, 0x080fe400020006ffULL,
0x0000312042427816ULL, 0x000fe400000000ffULL, 0x0000312043437816ULL, 0x000fe400000000ffULL,
0x00000040ff40723eULL, 0x000fe200030006ffULL, 0x0000001c182c723cULL, 0x000fe2000000182cULL,
0x00000041ff41723eULL, 0x000fcc00030006ffULL, 0x00000042ff1c723eULL, 0x000fe200020006ffULL,
0x00000040183c723cULL, 0x040fe2000000183cULL, 0x00000043ff1d723eULL, 0x000fe400020006ffULL,
0x0000312044447816ULL, 0x008fe400000000ffULL, 0x0000312045457816ULL, 0x000fe400000000ffULL,
0x0000312046467816ULL, 0x000fe200000000ffULL, 0x0000001c1838723cULL, 0x000fe20000001838ULL,
0x0000312047477816ULL, 0x000fc400000000ffULL, 0x00000042ff42723eULL, 0x000fe400030006ffULL,
0x00000043ff43723eULL, 0x000fe400030006ffULL, 0x00000044ff1c723eULL, 0x080fe400020006ffULL,
0x00000045ff1d723eULL, 0x080fe400020006ffULL, 0x00000044ff44723eULL, 0x000fe200030006ffULL,
0x000000421828723cULL, 0x000fe20000001828ULL, 0x00000045ff45723eULL, 0x000fce00030006ffULL,
0x0000001c1824723cULL, 0x040fee0000001824ULL, 0x00000046ff1c723eULL, 0x080fe200020006ffULL,
0x000000441834723cULL, 0x000fe20000001834ULL, 0x00000047ff1d723eULL, 0x000fe400020006ffULL,
0x00000046ff46723eULL, 0x000fc400030006ffULL, 0x00000047ff47723eULL, 0x000fc600030006ffULL,
0x0000001c1830723cULL, 0x040ff00000001830ULL, 0x000000461820723cULL, 0x000fee0000001820ULL,
0x0000f61003187811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x0000200011ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004003197824ULL, 0x000fe200078e0260ULL, 0x000000ff73ff7812ULL, 0x000fe2000782c0ffULL,
0x0000000018ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff72ff7812ULL, 0x000fc4000784c0ffULL,
0x00000040191a7810ULL, 0x000fe40007ffe0ffULL, 0x00000001ff427807ULL, 0x000fe40000800000ULL,
0x000000171a00720cULL, 0x000fe40003f26070ULL, 0x000000017100780cULL, 0x040fe40003f05270ULL,
0x00000001ff687807ULL, 0x000fe40001000000ULL, 0x0000000171717812ULL, 0x000fc400078e0cffULL,
0x0000007342737207ULL, 0x000fe40004000000ULL, 0x0000761068727816ULL, 0x000fc60000000072ULL,
0x00003a4000001947ULL, 0x000fea0003800000ULL, 0x00002400110a7984ULL, 0x004ea20000000800ULL,
0x8000000068077824ULL, 0x000fca00078e00ffULL, 0x800000000aff7812ULL, 0x004fe20007824807ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x00002400110a7984ULL, 0x000ea40000000800ULL, 0x800000000aff7812ULL, 0x004fe40007824807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff077424ULL, 0x000fe400078e00ffULL, 0x8000000068197824ULL, 0x000fe400078e00ffULL,
0x00000007000a7305ULL, 0x0004e4000021f000ULL, 0x3fa0000007077823ULL, 0x004fe200000100ffULL,
0x0000000a0000735dULL, 0x008fe40003800000ULL, 0x00002400110a7984ULL, 0x000ea40000000800ULL,
0x800000000aff7812ULL, 0x004fc40007824819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000370077812ULL, 0x000fe400078ec0ffULL,
0x00000001ff0a7819ULL, 0x000fe40000011648ULL, 0x000000030700780cULL, 0x000fc60003f25270ULL,
0x000000200a1a7824ULL, 0x000fe200078e0269ULL, 0x0000000105077807ULL, 0x000fc80004800000ULL,
0x000000801a1a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000170707824ULL, 0x000fc600078e0207ULL,
0x000000200d187812ULL, 0x000fe400078ef81aULL, 0x0000000370077812ULL, 0x000fc600078ec0ffULL,
0x0000000f061c7224ULL, 0x020fe200078e0218ULL, 0x000000030700780cULL, 0x000fe20003f25270ULL,
0xffffffffff067424ULL, 0x000fc600078e00ffULL, 0x00000001056f7807ULL, 0x000fca0004800000ULL,
0x0000000170077824ULL, 0x000fca00078e026fULL, 0x000000000700720cULL, 0x000fe40003f26070ULL,
0x0000001a171b7217ULL, 0x000fe40007800000ULL, 0x00000001491d7810ULL, 0x000fd20007ffe0ffULL,
0x0000006f12199210ULL, 0x000fe20007ffe070ULL, 0x00000004ff1e9424ULL, 0x000fc800078e00ffULL,
0x0000600019189625ULL, 0x000fc800078e001eULL, 0x00000008485f7824ULL, 0x000fe200078e00ffULL,
0x0000000818069981ULL, 0x000562000c1e1900ULL, 0x000000011b1b7824ULL, 0x000fe200078e0a1aULL,
0x000000021d00720cULL, 0x000fe20003f26070ULL, 0x00000080ff477424ULL, 0x000fe200078e00ffULL,
0x0000000114637812ULL, 0x000fe200078ec0ffULL, 0x00000001531a7824ULL, 0x100fe200078e021cULL,
0xfffffff05f5f7812ULL, 0x000fe200078ec0ffULL, 0x000000014f1e7824ULL, 0x100fe200078e021cULL,
0x0000001004407812ULL, 0x000fe200078ec0ffULL, 0x00000008631d7824ULL, 0x000fe200078e00ffULL,
0x000000201b1b7807ULL, 0x000fe20000800000ULL, 0x0000000155187824ULL, 0x004fe200078e021cULL,
0x0000f6485f577810ULL, 0x000fe20007ffe0ffULL, 0x000000001d0773c2ULL, 0x0004e200000e0000ULL,
0x0000001b401b7217ULL, 0x000fe20007800000ULL, 0x00005e0018187625ULL, 0x000fe200078e0047ULL,
0x000000081d627812ULL, 0x000fc400078e3cffULL, 0x00000003ff437819ULL, 0x000fe20000011608ULL,
0x000000011b407824ULL, 0x000fe200078e0a40ULL, 0x0000004b18187210ULL, 0x000fe20007f3e0ffULL,
0x00000000570673c2ULL, 0x000ee200000e0000ULL, 0x00005e001a1a7625ULL, 0x000fe200078e0047ULL,
0x0000000843457810ULL, 0x040fe40007ffe0ffULL, 0x00000004431f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001511d7824ULL, 0x004fe200078e021cULL, 0x0000004b1a1a7210ULL, 0x000fe20007f7e0ffULL,
0x000000020a417824ULL, 0x000fe200078e0263ULL, 0x000000404300720cULL, 0x000fe20003f46070ULL,
0x00005e001d1c7625ULL, 0x000fc600078e0047ULL, 0x0000b00041417811ULL, 0x000fe200078e60ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e061bULL, 0x0000004b1c1c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff197224ULL, 0x000fe200008e0619ULL, 0x000000404500720cULL, 0x080fe20003f66070ULL,
0x0000000157627824ULL, 0x000fe200078e0262ULL, 0x0000000c43457810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1d7224ULL, 0x000fe200020e061dULL, 0x000000401f00720cULL, 0x080fe20003f26070ULL,
0x00005e001e1e7625ULL, 0x000fe200078e0047ULL, 0x000000404500720cULL, 0x000fe20003f86070ULL,
0x0000000706067290ULL, 0x008fc4000fffe03fULL, 0x0000001054437824ULL, 0x100fe200078e0241ULL,
0x0000004b1e1e7210ULL, 0x000fe20007fbe0ffULL, 0x0000001052457824ULL, 0x100fe400078e0241ULL,
0x0000001050477824ULL, 0x000fe200078e0241ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018437faeULL, 0x0005e2000d101c48ULL, 0x000000ffff1f7224ULL, 0x000fe400028e061fULL,
0x000000104e417824ULL, 0x000fe200078e0241ULL, 0x000000001a457faeULL, 0x0005e8000c901c48ULL,
0x000000001c477faeULL, 0x0005e8000d901c48ULL, 0x000000001e417faeULL, 0x0005e8000e101c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a06ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000040062197984ULL, 0x0044e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f61c00151a7984ULL, 0x000f220000000800ULL,
0x0000006e426e7207ULL, 0x000fe20004000000ULL, 0x800000004c1b7824ULL, 0x000fc600078e00ffULL,
0x0000ffff6e187812ULL, 0x000fc800078ec0ffULL, 0x00008880181e7816ULL, 0x000fca00000000ffULL,
0x800000001e187824ULL, 0x000fca00078e00ffULL, 0x8000000019ff7812ULL, 0x008fe40007804818ULL,
0x800000001aff7812ULL, 0x010fe2000782481bULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000448157824ULL, 0x000fe400078e00ffULL,
0x3e000000ff187424ULL, 0x000fe400078e00ffULL, 0x800000004c1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff015157812ULL, 0x000fe400078ec0ffULL, 0x0000001800197305ULL, 0x000724000021f000ULL,
0x3fa0000018187823ULL, 0x008fe200000100ffULL, 0x000000190000735dULL, 0x010fe40003800000ULL,
0x00f61c0015197984ULL, 0x000ee40000000800ULL, 0x8000000019ff7812ULL, 0x008fc4000782481aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000002048187824ULL, 0x000fe400078e00ffULL, 0x00000001ff407424ULL, 0x000fc600078e00ffULL,
0xffffff8018187812ULL, 0x000fc800078ec0ffULL, 0x000000804b187810ULL, 0x000fca0007ffe018ULL,
0x000000014d187824ULL, 0x000fca00078e0218ULL, 0x00f0000018197984ULL, 0x000ee80000000800ULL,
0x00f20000181b7984ULL, 0x0008620000000800ULL, 0x0000000e1900720bULL, 0x008fda0003f3d000ULL,
0x00000000001a7806ULL, 0x000fc800008e0100ULL, 0x0000ffff1a1f7812ULL, 0x000fda000782c0ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x0000000e1900720bULL, 0x012fe40003f34000ULL,
0x000000190e1a7209ULL, 0x0c0fe40007810000ULL, 0x00000001031d7810ULL, 0x000fe40007ffe0ffULL,
0x00000002ff427819ULL, 0x000fe20000011608ULL, 0x8000001a0e187221ULL, 0x040fe20000010000ULL,
0x000000190e0e7209ULL, 0x000fc60007810000ULL, 0x3fb8aa3b181c7820ULL, 0x000fe40000410000ULL,
0x0000000000187806ULL, 0x000fe400008e0100ULL, 0x000000481d00720cULL, 0x000fe20003f25270ULL,
0x0000001c00417308ULL, 0x000e620000000800ULL, 0x0000ffff18407812ULL, 0x000fc800078e3cffULL,
0x000000401fff7212ULL, 0x000fce000784c0ffULL, 0x0000008048409824ULL, 0x000fc800078e024bULL,
0x000000014d1f9824ULL, 0x000fe200078e0240ULL, 0x00001f4241187589ULL, 0x002e6200000e0000ULL,
0x8000001a191d2221ULL, 0x000fe20000010000ULL, 0x0000004110107220ULL, 0x000fe20000410000ULL,
0x00000001ff407807ULL, 0x000fe20001000000ULL, 0x00001f4a411c7589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b1d1d2820ULL, 0x000fc60000410000ULL, 0x00f4001a1f009388ULL, 0x0009e20000000800ULL,
0x0000001d00162308ULL, 0x000ea20000000800ULL, 0x000000182c2c7220ULL, 0x082fe20000410000ULL,
0x000000182d2d7220ULL, 0x080fe20000410000ULL, 0x000000183c3c7220ULL, 0x080fe20000410000ULL,
0x000000183d3d7220ULL, 0x080fe20000410000ULL, 0x0000001838387220ULL, 0x080fe20000410000ULL,
0x0000001839397220ULL, 0x080fe20000410000ULL, 0x0000001828287220ULL, 0x080fe20000410000ULL,
0x0000001829297220ULL, 0x080fe20000410000ULL, 0x0000001824247220ULL, 0x080fe20000410000ULL,
0x0000001825257220ULL, 0x080fe20000410000ULL, 0x0000001834347220ULL, 0x080fe20000410000ULL,
0x0000001835357220ULL, 0x080fe20000410000ULL, 0x0000001830307220ULL, 0x080fe20000410000ULL,
0x0000001831317220ULL, 0x080fe20000410000ULL, 0x0000001820207220ULL, 0x080fe20000410000ULL,
0x0000001821217220ULL, 0x000fe20000410000ULL, 0x0000001c2e2e7220ULL, 0x088fe20000410000ULL,
0x0000001c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000001c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001c26267220ULL, 0x080fe20000410000ULL,
0x0000001c27277220ULL, 0x080fe20000410000ULL, 0x0000001c36367220ULL, 0x080fe20000410000ULL,
0x0000001c37377220ULL, 0x080fe20000410000ULL, 0x0000001c32327220ULL, 0x080fe20000410000ULL,
0x0000001c33337220ULL, 0x080fe20000410000ULL, 0x0000001c22227220ULL, 0x080fe20000410000ULL,
0x0000001c23237220ULL, 0x000fe20000410000ULL, 0x0000001b161b2220ULL, 0x004fc80000410000ULL,
0x000000101b107221ULL, 0x012fe20000010000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x0000000863187824ULL, 0x000fe400078e00ffULL, 0x800000001e197824ULL, 0x000fc600078e00ffULL,
0x0000000818187812ULL, 0x000fca00078e3cffULL, 0x000000015f1a7824ULL, 0x000fca00078e0218ULL,
0x00f64c001a187984ULL, 0x000e640000000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000001e1e7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x0000001800197305ULL, 0x0002e4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x000000190000735dULL, 0x008fe40003800000ULL, 0x00f64c001a197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fc4000780481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000100014197824ULL, 0x000fe200078e00ffULL,
0x00000016ff41723eULL, 0x000fe200000000ffULL, 0x00001000481a7824ULL, 0x040fe200078e00ffULL,
0x00000002ff717819ULL, 0x000fe20000011608ULL, 0x0000020048187824ULL, 0x000fe200078e00ffULL,
0x0000100019577812ULL, 0x000fe400078e0cffULL, 0xffffe0001a1a7812ULL, 0x000fe400078ec0ffULL,
0xfffff80018437812ULL, 0x000fe400078ec0ffULL, 0x0000b0001a5c7810ULL, 0x000fc40007ffe057ULL,
0x0000541041417816ULL, 0x000fe20000000041ULL, 0x000000015e5e7824ULL, 0x000fe200078e0243ULL,
0x0000991040407816ULL, 0x000fe200000000ffULL, 0x000000106c617824ULL, 0x100fe200078e025cULL,
0x0000b0000c747810ULL, 0x000fe20007ffe057ULL, 0x000000105d5c7824ULL, 0x000fe200078e025cULL,
0x009800005e1c783bULL, 0x000fe20000000200ULL, 0x000000ff4000720cULL, 0x000fe20003f05270ULL,
0x000000015a5a7824ULL, 0x000fe400078e0243ULL, 0x000000006118783bULL, 0x000fe20000004200ULL,
0x000000105b597824ULL, 0x000fc600078e0274ULL, 0x00001f7141717589ULL, 0x000e6800000e0000ULL,
0x00001f4a41727589ULL, 0x000ee800000e0000ULL, 0x000000005c44783bULL, 0x000f220000004200ULL,
0x000000711c1c8232ULL, 0x082fe40000000000ULL, 0x000000711e1e8232ULL, 0x000fe20000000000ULL,
0x0000312018187816ULL, 0x000fe200000000ffULL, 0x000000721d1d8232ULL, 0x088fe20000000000ULL,
0x0000312019197816ULL, 0x000fe200000000ffULL, 0x000000721f1f8232ULL, 0x000fe20000000000ULL,
0x00000018ff40723eULL, 0x000fc400020006ffULL, 0x00000019ff41723eULL, 0x080fe400020006ffULL,
0x00000018ff18723eULL, 0x000fe400030006ffULL, 0x00000019ff19723eULL, 0x000fe400030006ffULL,
0x000031201a6a7816ULL, 0x000fe200000000ffULL, 0x000000401c2c723cULL, 0x000fe2000000182cULL,
0x000031201b6b7816ULL, 0x000fe200000000ffULL, 0x000000005940783bULL, 0x000e620000004200ULL,
0x0000312044577816ULL, 0x010fc400000000ffULL, 0x0000312045737816ULL, 0x000fe400000000ffULL,
0x00000057ff44723eULL, 0x000fe200020006ffULL, 0x000000181c3c723cULL, 0x000fe2000000183cULL,
0x00000073ff45723eULL, 0x000fcc00020006ffULL, 0x0000006aff18723eULL, 0x080fe200020006ffULL,
0x000000441c24723cULL, 0x040fe20000001824ULL, 0x0000006bff19723eULL, 0x080fe400020006ffULL,
0x0000006aff6a723eULL, 0x000fe400030006ffULL, 0x0000006bff6b723eULL, 0x000fe400030006ffULL,
0x00000057ff44723eULL, 0x000fe200030006ffULL, 0x000000181c38723cULL, 0x000fe20000001838ULL,
0x009800005a18783bULL, 0x000ee20000000200ULL, 0x00000073ff45723eULL, 0x000fe200030006ffULL,
0x0000001058577824ULL, 0x000fca00078e0274ULL, 0x0000006a1c28723cULL, 0x040fee0000001828ULL,
0x00003120466a7816ULL, 0x000fe200000000ffULL, 0x000000441c34723cULL, 0x000fe20000001834ULL,
0x00003120476b7816ULL, 0x000fe400000000ffULL, 0x0000312040407816ULL, 0x002fc400000000ffULL,
0x0000312041417816ULL, 0x000fe400000000ffULL, 0x0000006aff44723eULL, 0x080fe400020006ffULL,
0x0000006bff45723eULL, 0x080fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400030006ffULL,
0x0000006bff6b723eULL, 0x000fe400030006ffULL, 0x0000312042427816ULL, 0x000fe200000000ffULL,
0x000000441c30723cULL, 0x000fe20000001830ULL, 0x000000005744783bULL, 0x000e620000004200ULL,
0x0000312043437816ULL, 0x000fcc00000000ffULL, 0x0000006a1c20723cULL, 0x000fe20000001820ULL,
0x0000007118188232ULL, 0x088fe40000000000ULL, 0x000000711a1a8232ULL, 0x000fe40000000000ULL,
0x0000007219198232ULL, 0x080fe40000000000ULL, 0x000000721b1b8232ULL, 0x000fe20000000000ULL,
0x00000040ff1c723eULL, 0x000fe400020006ffULL, 0x00000041ff1d723eULL, 0x000fce00020006ffULL,
0x0000001c182c723cULL, 0x000fee000000182cULL, 0x00000040ff1c723eULL, 0x000fe400030006ffULL,
0x00000041ff1d723eULL, 0x000fce00030006ffULL, 0x0000001c183c723cULL, 0x000fe2000000183cULL,
0x0000312044447816ULL, 0x002fe400000000ffULL, 0x0000312045457816ULL, 0x000fe400000000ffULL,
0x0000312046467816ULL, 0x000fe400000000ffULL, 0x00000042ff1c723eULL, 0x000fe400020006ffULL,
0x00000043ff1d723eULL, 0x000fe400020006ffULL, 0x0000312047477816ULL, 0x000fca00000000ffULL,
0x0000001c1838723cULL, 0x000fee0000001838ULL, 0x00000042ff1c723eULL, 0x000fe400030006ffULL,
0x00000043ff1d723eULL, 0x000fce00030006ffULL, 0x0000001c1828723cULL, 0x000fee0000001828ULL,
0x00000044ff1c723eULL, 0x000fe400020006ffULL, 0x00000045ff1d723eULL, 0x000fce00020006ffULL,
0x0000001c1824723cULL, 0x000fee0000001824ULL, 0x00000044ff1c723eULL, 0x000fe400030006ffULL,
0x00000045ff1d723eULL, 0x000fce00030006ffULL, 0x0000001c1834723cULL, 0x000fee0000001834ULL,
0x00000046ff1c723eULL, 0x080fe400020006ffULL, 0x00000047ff1d723eULL, 0x000fe400020006ffULL,
0x00000046ff46723eULL, 0x000fc400030006ffULL, 0x00000047ff47723eULL, 0x000fc600030006ffULL,
0x0000001c1830723cULL, 0x040ff00000001830ULL, 0x000000461820723cULL, 0x000fee0000001820ULL,
0x0000f62003187811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x0000200011ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000004491a7824ULL, 0x000fe200078e0203ULL, 0x000000ff6eff7812ULL, 0x000fe2000784c0ffULL,
0x0000000018ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ff56ff7812ULL, 0x000fc4000782c0ffULL,
0x000000801a1a7811ULL, 0x000fe400078e30ffULL, 0x00000001ff6b7807ULL, 0x000fe40001000000ULL,
0x000000171a00720cULL, 0x000fe40003f46070ULL, 0x0000000114717812ULL, 0x000fe4000780c0ffULL,
0x00000001ff727807ULL, 0x000fe40004800000ULL, 0x0000006e6b737207ULL, 0x000fce0004000000ULL,
0x000025a000002947ULL, 0x000fea0003800000ULL, 0x00002400110a7984ULL, 0x008ee20000000800ULL,
0x00000001ff187807ULL, 0x000fca0004800000ULL, 0x8000000018077824ULL, 0x000fca00078e00ffULL,
0x800000000aff7812ULL, 0x008fe20007844807ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000002947ULL, 0x000fea0003800000ULL, 0x00002400110a7984ULL, 0x000ee40000000800ULL,
0x800000000aff7812ULL, 0x008fe40007844807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x8000000018197824ULL, 0x000fe400078e00ffULL,
0x3e000000ff077424ULL, 0x000fc800078e00ffULL, 0x00000007000a7305ULL, 0x000724000021f000ULL,
0x3fa0000007077823ULL, 0x008fe200000100ffULL, 0x0000000a0000735dULL, 0x010fe40003800000ULL,
0x00002400110a7984ULL, 0x000ee40000000800ULL, 0x800000000aff7812ULL, 0x008fc40007844819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00000001706f7824ULL, 0x000fe200078e026fULL, 0x00000001ff0a7819ULL, 0x000fc80000011648ULL,
0x000000036f077812ULL, 0x000fe200078ec0ffULL, 0x000000200a1a7824ULL, 0x000fc600078e0269ULL,
0x000000030700780cULL, 0x000fe40003f45270ULL, 0x000000c01a1a7810ULL, 0x000fe40007ffe0ffULL,
0x00000001056a7807ULL, 0x000fe40005000000ULL, 0x000000200d187812ULL, 0x000fc600078ef81aULL,
0x000000016f077824ULL, 0x000fe400078e026aULL, 0x0000000f061e7224ULL, 0x020fe200078e0218ULL,
0x0000001a171b7217ULL, 0x000fe20007800000ULL, 0xffffffffff067424ULL, 0x000fe200078e00ffULL,
0x000000000700720cULL, 0x000fe40003f46070ULL, 0x00000001491d7810ULL, 0x000fe20007ffe0ffULL,
0x000000011b1b7824ULL, 0x000fd400078e0a1aULL, 0x000000011219a824ULL, 0x000fe400078e0207ULL,
0x00000004ff1ca424ULL, 0x000fc800078e00ffULL, 0x000060001918a625ULL, 0x000fca00078e001cULL,
0x000000081806a981ULL, 0x000762000c1e1900ULL, 0x000000021d00720cULL, 0x000fe20003f46070ULL,
0x00000080ff427424ULL, 0x000fe200078e00ffULL, 0x0000001004407812ULL, 0x000fe200078ec0ffULL,
0x00000001551a7824ULL, 0x100fe200078e021eULL, 0x000000201b1b7807ULL, 0x000fe20001000000ULL,
0x00000001531d7824ULL, 0x000fe200078e021eULL, 0x00000003ff417819ULL, 0x000fe20000011608ULL,
0x00000001511f7824ULL, 0x000fe200078e021eULL, 0x0000001b401c7217ULL, 0x000fe20007800000ULL,
0x00005e001a1a7625ULL, 0x000fe200078e0042ULL, 0x0000000841437810ULL, 0x000fc60007ffe0ffULL,
0x000000011c407824ULL, 0x000fe200078e0a40ULL, 0x0000004b1a1a7210ULL, 0x000fe20007f5e0ffULL,
0x00005e001d187625ULL, 0x008fe200078e0042ULL, 0x00000004411d7810ULL, 0x000fc60007ffe0ffULL,
0x000000014f1c7824ULL, 0x000fe200078e021eULL, 0x0000004b18187210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e061bULL, 0x000000401d00720cULL, 0x000fe20003f46070ULL,
0x00005e001f1e7625ULL, 0x000fc800078e0042ULL, 0x00005e001c1c7625ULL, 0x000fe200078e0042ULL,
0x0000004b1e1e7210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff197224ULL, 0x000fe200018e0619ULL,
0x0000004b1c1c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1f7224ULL, 0x000fe200020e061fULL,
0x000000404100720cULL, 0x0c0fe40003f66070ULL, 0x0000000c41417810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1d7224ULL, 0x000fe200028e061dULL, 0x000000404300720cULL, 0x080fe40003f86070ULL,
0x000000404100720cULL, 0x000fce0003fa6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a677faeULL, 0x0007e8000d901c48ULL, 0x0000000018667faeULL, 0x0007e8000d101c48ULL,
0x000000001e657faeULL, 0x0007e8000e101c48ULL, 0x000000001c647faeULL, 0x0007e8000e901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000406ff197984ULL, 0x008ee20008000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f62c00151a7984ULL, 0x000f220000000800ULL,
0x0000006e6b6e7207ULL, 0x000fe20004000000ULL, 0x800000004c1b7824ULL, 0x000fc600078e00ffULL,
0x0000ffff6e187812ULL, 0x000fc800078ec0ffULL, 0x00008880181e7816ULL, 0x000fca00000000ffULL,
0x800000001e187824ULL, 0x000fca00078e00ffULL, 0x8000000019ff7812ULL, 0x008fe40007844818ULL,
0x800000001aff7812ULL, 0x010fe2000786481bULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000003947ULL, 0x000fea0003800000ULL, 0x0000000448157824ULL, 0x000fe400078e00ffULL,
0x3e000000ff187424ULL, 0x000fe400078e00ffULL, 0x800000004c1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff015157812ULL, 0x000fe400078ec0ffULL, 0x0000001800197305ULL, 0x000724000021f000ULL,
0x3fa0000018187823ULL, 0x008fe200000100ffULL, 0x000000190000735dULL, 0x010fe40003800000ULL,
0x00f62c0015197984ULL, 0x000ee40000000800ULL, 0x8000000019ff7812ULL, 0x008fc4000786481aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000b947ULL, 0x000fea000383ffffULL,
0x0000002048187824ULL, 0x000fe400078e00ffULL, 0x00000001ff407424ULL, 0x000fc600078e00ffULL,
0xffffff8018187812ULL, 0x000fc800078ec0ffULL, 0x000001004b187810ULL, 0x000fca0007ffe018ULL,
0x000000014d187824ULL, 0x000fca00078e0218ULL, 0x00f0000018197984ULL, 0x000ee80000000800ULL,
0x00f20000181b7984ULL, 0x0008620000000800ULL, 0x0000000e1900720bULL, 0x008fda0003f7d000ULL,
0x00000000001a7806ULL, 0x000fc800018e0100ULL, 0x0000ffff1a1f7812ULL, 0x000fda000786c0ffULL,
0x000003700000b947ULL, 0x000fea0003800000ULL, 0x0000000e1900720bULL, 0x012fe40003f74000ULL,
0x000000190e1a7209ULL, 0x0c0fe40007810000ULL, 0x00000002031d7810ULL, 0x000fe40007ffe0ffULL,
0x00000002ff427819ULL, 0x000fe20000011608ULL, 0x8000001a0e187221ULL, 0x040fe20000010000ULL,
0x000000190e0e7209ULL, 0x000fc60007810000ULL, 0x3fb8aa3b181c7820ULL, 0x000fe40000410000ULL,
0x0000000000187806ULL, 0x000fe400018e0100ULL, 0x000000481d00720cULL, 0x000fe20003f65270ULL,
0x0000001c00417308ULL, 0x000e620000000800ULL, 0x0000ffff18407812ULL, 0x000fc800078e3cffULL,
0x000000401fff7212ULL, 0x000fce000788c0ffULL, 0x000000804840b824ULL, 0x000fc800078e024bULL,
0x000000014d1fb824ULL, 0x000fe200078e0240ULL, 0x00001f4241187589ULL, 0x002e6200000e0000ULL,
0x8000001a191d4221ULL, 0x000fe20000010000ULL, 0x0000004110107220ULL, 0x000fe20000410000ULL,
0x00000001ff407807ULL, 0x000fe20002000000ULL, 0x00001f4a411c7589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b1d1d4820ULL, 0x000fc60000410000ULL, 0x00f4001a1f00b388ULL, 0x0009e20000000800ULL,
0x0000001d00164308ULL, 0x000ea20000000800ULL, 0x000000182c2c7220ULL, 0x082fe20000410000ULL,
0x000000182d2d7220ULL, 0x080fe20000410000ULL, 0x000000183c3c7220ULL, 0x080fe20000410000ULL,
0x000000183d3d7220ULL, 0x080fe20000410000ULL, 0x0000001838387220ULL, 0x080fe20000410000ULL,
0x0000001839397220ULL, 0x080fe20000410000ULL, 0x0000001828287220ULL, 0x080fe20000410000ULL,
0x0000001829297220ULL, 0x080fe20000410000ULL, 0x0000001824247220ULL, 0x080fe20000410000ULL,
0x0000001825257220ULL, 0x080fe20000410000ULL, 0x0000001834347220ULL, 0x080fe20000410000ULL,
0x0000001835357220ULL, 0x080fe20000410000ULL, 0x0000001830307220ULL, 0x080fe20000410000ULL,
0x0000001831317220ULL, 0x080fe20000410000ULL, 0x0000001820207220ULL, 0x080fe20000410000ULL,
0x0000001821217220ULL, 0x000fe20000410000ULL, 0x0000001c2e2e7220ULL, 0x088fe20000410000ULL,
0x0000001c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000001c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001c26267220ULL, 0x080fe20000410000ULL,
0x0000001c27277220ULL, 0x080fe20000410000ULL, 0x0000001c36367220ULL, 0x080fe20000410000ULL,
0x0000001c37377220ULL, 0x080fe20000410000ULL, 0x0000001c32327220ULL, 0x080fe20000410000ULL,
0x0000001c33337220ULL, 0x080fe20000410000ULL, 0x0000001c22227220ULL, 0x080fe20000410000ULL,
0x0000001c23237220ULL, 0x000fe20000410000ULL, 0x0000001b161b4220ULL, 0x004fc80000410000ULL,
0x000000101b107221ULL, 0x012fe20000010000ULL, 0x000000f000002947ULL, 0x000fea0003800000ULL,
0x0000000863187824ULL, 0x000fe400078e025fULL, 0x800000001e197824ULL, 0x000fc800078e00ffULL,
0x00f64c0018187984ULL, 0x000e640000000800ULL, 0x8000000018ff7812ULL, 0x002fe40007844819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x800000001e1e7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x0000001800197305ULL, 0x0002e4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x000000190000735dULL, 0x008fe40003800000ULL, 0x00000406ff197984ULL, 0x000e640008000800ULL,
0x8000000019ff7812ULL, 0x002fc4000784481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000100048187824ULL, 0x000fe200078e00ffULL,
0x00a000005e1c783bULL, 0x000fe20000000200ULL, 0x00000016ff42723eULL, 0x000fe400000000ffULL,
0x00000002ff657819ULL, 0x000fe40000011608ULL, 0xffffe00018187812ULL, 0x000fe400078ec0ffULL,
0x0000541042427816ULL, 0x000fe40000000042ULL, 0x0000991040407816ULL, 0x000fe200000000ffULL,
0x0000100063187824ULL, 0x000fc400078e0218ULL, 0x00001f6542657589ULL, 0x000e6200000e0000ULL,
0x000000ff4000720cULL, 0x000fe40003f45270ULL, 0x0000b00018417810ULL, 0x000fe20007ffe0ffULL,
0x00001f4a42647589ULL, 0x000ee800000e0000ULL, 0x000000106c187824ULL, 0x100fe400078e0241ULL,
0x000000105d447824ULL, 0x000fc800078e0241ULL, 0x000000001818783bULL, 0x000f280000004200ULL,
0x000000004444783bULL, 0x000ea20000004200ULL, 0x000000651c1ca232ULL, 0x082fe40000000000ULL,
0x000000651e1ea232ULL, 0x000fe40000000000ULL, 0x000000641d1da232ULL, 0x088fe40000000000ULL,
0x000000641f1fa232ULL, 0x000fe20000000000ULL, 0x0000312018187816ULL, 0x010fc400000000ffULL,
0x0000312019197816ULL, 0x000fe400000000ffULL, 0x00000018ff40723eULL, 0x080fe400020006ffULL,
0x00000019ff41723eULL, 0x080fe400020006ffULL, 0x000031201b677816ULL, 0x000fe400000000ffULL,
0x00000018ff18723eULL, 0x000fe400030006ffULL, 0x00000019ff19723eULL, 0x000fe200030006ffULL,
0x000000401c2c723cULL, 0x000fe2000000182cULL, 0x00003120455d7816ULL, 0x004fc400000000ffULL,
0x000031201a667816ULL, 0x000fe400000000ffULL, 0x0000005dff45723eULL, 0x000fe400020006ffULL,
0x0000100014407824ULL, 0x000fe200078e00ffULL, 0x000000181c3c723cULL, 0x000fe8000000183cULL,
0x00001000401b7812ULL, 0x000fc600078ec0ffULL, 0x00000066ff18723eULL, 0x080fe400020006ffULL,
0x0000b0000c697810ULL, 0x000fe40007ffe01bULL, 0x00000067ff19723eULL, 0x080fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe200030006ffULL, 0x000000105b407824ULL, 0x000fe200078e0269ULL,
0x00003120445b7816ULL, 0x000fe400000000ffULL, 0x00000067ff67723eULL, 0x000fe200030006ffULL,
0x000000181c38723cULL, 0x040fe20000001838ULL, 0x0000005bff44723eULL, 0x080fe200020006ffULL,
0x000000004040783bULL, 0x000e680000004200ULL, 0x00a000005a18783bULL, 0x000ea40000000200ULL,
0x000000441c24723cULL, 0x040fee0000001824ULL, 0x0000005bff44723eULL, 0x000fe200030006ffULL,
0x000000661c28723cULL, 0x000fe20000001828ULL, 0x0000005dff45723eULL, 0x000fcc00030006ffULL,
0x0000312046667816ULL, 0x000fe200000000ffULL, 0x000000441c34723cULL, 0x000fe20000001834ULL,
0x0000312047677816ULL, 0x000fe200000000ffULL, 0x0000001058467824ULL, 0x000fca00078e0269ULL,
0x00000066ff44723eULL, 0x080fe400020006ffULL, 0x00000067ff45723eULL, 0x080fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe400030006ffULL, 0x00000067ff67723eULL, 0x000fc600030006ffULL,
0x000000441c30723cULL, 0x040fe20000001830ULL, 0x000000004644783bULL, 0x000ee20000004200ULL,
0x0000312040407816ULL, 0x002fe400000000ffULL, 0x0000312041417816ULL, 0x000fe200000000ffULL,
0x000000651818a232ULL, 0x084fe20000000000ULL, 0x0000312042427816ULL, 0x000fe400000000ffULL,
0x000000661c20723cULL, 0x000fe20000001820ULL, 0x000000651a1aa232ULL, 0x000fe20000000000ULL,
0x0000312043437816ULL, 0x000fe200000000ffULL, 0x000000641919a232ULL, 0x000fc40000000000ULL,
0x000000641b1ba232ULL, 0x000fe40000000000ULL, 0x00000040ff1c723eULL, 0x080fe400020006ffULL,
0x00000041ff1d723eULL, 0x080fe400020006ffULL, 0x00000040ff40723eULL, 0x000fe400030006ffULL,
0x00000041ff41723eULL, 0x000fc600030006ffULL, 0x0000001c182c723cULL, 0x040fee000000182cULL,
0x00000042ff1c723eULL, 0x080fe200020006ffULL, 0x00000040183c723cULL, 0x000fe2000000183cULL,
0x00000043ff1d723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fc400030006ffULL,
0x00000043ff43723eULL, 0x000fc600030006ffULL, 0x0000001c1838723cULL, 0x040fe20000001838ULL,
0x0000312044447816ULL, 0x008fe400000000ffULL, 0x0000312045457816ULL, 0x000fe400000000ffULL,
0x0000312046467816ULL, 0x000fe400000000ffULL, 0x00000044ff1c723eULL, 0x000fe200020006ffULL,
0x000000421828723cULL, 0x000fe20000001828ULL, 0x00000045ff1d723eULL, 0x000fe400020006ffULL,
0x0000312047477816ULL, 0x000fc400000000ffULL, 0x00000044ff44723eULL, 0x000fe400030006ffULL,
0x00000045ff45723eULL, 0x000fe200030006ffULL, 0x0000001c1824723cULL, 0x040fee0000001824ULL,
0x00000046ff1c723eULL, 0x000fe200020006ffULL, 0x000000441834723cULL, 0x000fe20000001834ULL,
0x00000047ff1d723eULL, 0x000fc400020006ffULL, 0x00000046ff46723eULL, 0x000fe400030006ffULL,
0x00000047ff47723eULL, 0x000fc600030006ffULL, 0x0000001c1830723cULL, 0x040ff00000001830ULL,
0x000000461820723cULL, 0x000fee0000001820ULL, 0x0000f63003187811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000ff20000008000ULL, 0x0000200011ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000040031a7824ULL, 0x000fe200078e0260ULL,
0x000000ff6eff7812ULL, 0x000fe2000784c0ffULL, 0x0000000018ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ff56ff7812ULL, 0x000fc4000786c0ffULL, 0x000000c01a1a7810ULL, 0x000fe40007ffe0ffULL,
0x00000001ff567807ULL, 0x000fe40001000000ULL, 0x000000171a00720cULL, 0x000fe40003f46070ULL,
0x00000001ff727807ULL, 0x000fe40001800000ULL, 0x000000566b737207ULL, 0x000fe40004000000ULL,
0x0000000114717812ULL, 0x000fce00078e0cffULL, 0x0000127000002947ULL, 0x000fea0003800000ULL,
0x0000240011077984ULL, 0x004ea20000000800ULL, 0x8000000068187824ULL, 0x000fca00078e00ffULL,
0x8000000007ff7812ULL, 0x004fe20007844818ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000002947ULL, 0x000fea0003800000ULL, 0x0000240011077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x004fe40007844818ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x8000000068197824ULL, 0x000fe400078e00ffULL,
0x3e000000ff077424ULL, 0x000fc800078e00ffULL, 0x0000000700187305ULL, 0x0004e4000021f000ULL,
0x3fa0000007077823ULL, 0x004fe200000100ffULL, 0x000000180000735dULL, 0x008fe40003800000ULL,
0x0000240011187984ULL, 0x000ea40000000800ULL, 0x8000000018ff7812ULL, 0x004fc40007844819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000000016f6a7824ULL, 0x000fe200078e026aULL, 0x00000300491a7a10ULL, 0x000fc80007ffe0ffULL,
0x000000036a077812ULL, 0x000fe200078ec0ffULL, 0x000001001a1c7824ULL, 0x000fc600078e020bULL,
0x000000030700780cULL, 0x000fe40003f45270ULL, 0x000000200d187812ULL, 0x000fe400078ef81cULL,
0x0000000105077807ULL, 0x000fc60005000000ULL, 0x0000000f061e7224ULL, 0x020fe400078e0218ULL,
0x000000016a077824ULL, 0x000fe200078e0207ULL, 0x0000001c171d7217ULL, 0x000fe20007800000ULL,
0xffffffffff067424ULL, 0x000fc600078e00ffULL, 0x000000000700720cULL, 0x000fe40003f46070ULL,
0x000000011a1b7810ULL, 0x000fe20007ffe0ffULL, 0x000000011d1d7824ULL, 0x000fd400078e0a1cULL,
0x000000011219a824ULL, 0x000fe400078e0207ULL, 0x00000004ff40a424ULL, 0x000fc800078e00ffULL,
0x000060001918a625ULL, 0x000fc800078e0040ULL, 0x00000080ff427424ULL, 0x000fe200078e00ffULL,
0x000000081806a981ULL, 0x000562000c1e1900ULL, 0x000000021b00720cULL, 0x000fe20003f46070ULL,
0x0000000155557824ULL, 0x100fe200078e021eULL, 0x0000001004407812ULL, 0x000fe200078ec0ffULL,
0x00000001531a7824ULL, 0x100fe200078e021eULL, 0x000000201d1d7807ULL, 0x000fe20001000000ULL,
0x00000001511c7824ULL, 0x000fe200078e021eULL, 0x00000003ff437819ULL, 0x000fe20000011608ULL,
0x000000014f4f7824ULL, 0x000fe200078e021eULL, 0x0000001d401f7217ULL, 0x000fe20007800000ULL,
0x00005e0055187625ULL, 0x004fe200078e0042ULL, 0x0000000443417810ULL, 0x000fc40007ffe0ffULL,
0x0000000843457810ULL, 0x000fe20007ffe0ffULL, 0x00005e001a1a7625ULL, 0x000fe200078e0042ULL,
0x0000004b181e7210ULL, 0x000fc60007f5e0ffULL, 0x000000011f407824ULL, 0x000fe200078e0a40ULL,
0x0000004b1a1a7210ULL, 0x000fe20007f7e0ffULL, 0x00005e001c1c7625ULL, 0x000fc800078e0042ULL,
0x000000ffff1f7224ULL, 0x000fe200010e0619ULL, 0x0000004b1c1c7210ULL, 0x000fe20007f9e0ffULL,
0x00005e004f187625ULL, 0x000fe200078e0042ULL, 0x000000404100720cULL, 0x000fc60003f46070ULL,
0x000000ffff1b7224ULL, 0x000fe200018e061bULL, 0x0000004b18187210ULL, 0x000fe20007fbe0ffULL,
0x0000100063417824ULL, 0x000fe200078e020cULL, 0x000000404300720cULL, 0x0c0fe20003f66070ULL,
0x000000ffff1d7224ULL, 0x000fe200020e061dULL, 0x0000000c43437810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff197224ULL, 0x000fe200028e0619ULL, 0x000000404500720cULL, 0x080fe40003f86070ULL,
0x0000b00041417810ULL, 0x000fe40007ffe0ffULL, 0x000000404300720cULL, 0x000fc60003fa6070ULL,
0x0000001054437824ULL, 0x100fe400078e0241ULL, 0x0000001052457824ULL, 0x100fe400078e0241ULL,
0x0000001050477824ULL, 0x100fe200078e0241ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e437faeULL, 0x0005e2000d901c48ULL, 0x000000104e417824ULL, 0x000fc600078e0241ULL,
0x000000001a457faeULL, 0x0005e8000d101c48ULL, 0x000000001c477faeULL, 0x0005e8000e101c48ULL,
0x0000000018417faeULL, 0x0005e8000e901c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000040062197984ULL, 0x0044e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f63c00151a7984ULL, 0x000f220000000800ULL, 0x000000566b6b7207ULL, 0x000fe20004000000ULL,
0x800000004c1b7824ULL, 0x000fc600078e00ffULL, 0x0000ffff6b1c7812ULL, 0x000fca00078ec0ffULL,
0x800000001c187824ULL, 0x000fca00078e00ffULL, 0x8000000019ff7812ULL, 0x008fe40007844818ULL,
0x800000001aff7812ULL, 0x010fe2000786481bULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000003947ULL, 0x000fea0003800000ULL, 0x800000004c4c7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff187424ULL, 0x000fc800078e00ffULL, 0x0000001800197305ULL, 0x000724000021f000ULL,
0x3fa0000018187823ULL, 0x008fe200000100ffULL, 0x000000190000735dULL, 0x010fe40003800000ULL,
0x00f63c0015197984ULL, 0x000ee40000000800ULL, 0x8000000019ff7812ULL, 0x008fc4000786484cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000b947ULL, 0x000fea000383ffffULL,
0x0000002048187824ULL, 0x000fe400078e00ffULL, 0x00000001ff407424ULL, 0x000fc600078e00ffULL,
0xffffff8018187812ULL, 0x000fc800078ec0ffULL, 0x000001804b187810ULL, 0x000fca0007ffe018ULL,
0x000000014d187824ULL, 0x000fca00078e0218ULL, 0x00f0000018197984ULL, 0x000ee80000000800ULL,
0x00f20000181b7984ULL, 0x0008620000000800ULL, 0x0000000e1900720bULL, 0x008fda0003f7d000ULL,
0x00000000001a7806ULL, 0x000fc800018e0100ULL, 0x0000ffff1a1a7812ULL, 0x000fda000786c0ffULL,
0x000003700000b947ULL, 0x000fea0003800000ULL, 0x0000000e1900720bULL, 0x012fe40003f74000ULL,
0x000000190e1e7209ULL, 0x040fe40007810000ULL, 0x00000003031d7810ULL, 0x000fe40007ffe0ffULL,
0x00000002ff407819ULL, 0x000fe20000011608ULL, 0x8000001e0e187221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b18187820ULL, 0x000fe40000410000ULL, 0x00000000000e7806ULL, 0x000fe400018e0100ULL,
0x000000481d00720cULL, 0x000fe20003f65270ULL, 0x0000001800417308ULL, 0x000e620000000800ULL,
0x0000ffff0e1f7812ULL, 0x000fc800078e3cffULL, 0x0000001f1aff7212ULL, 0x000fce000788c0ffULL,
0x00000080481ab824ULL, 0x000fe200078e024bULL, 0x00001f40410e7589ULL, 0x0022e600000e0000ULL,
0x000000014d4db824ULL, 0x000fe400078e021aULL, 0x8000001e19194221ULL, 0x000fe20000010000ULL,
0x0000004110107220ULL, 0x000fe20000410000ULL, 0x00001f4a41187589ULL, 0x000f2400000e0000ULL,
0x3fb8aa3b19194820ULL, 0x000fc40000410000ULL, 0x00f4001e4d00b388ULL, 0x0005e40000000800ULL,
0x0000001900164308ULL, 0x000ea20000000800ULL, 0x00000001ff407807ULL, 0x002fe20002000000ULL,
0x0000000e2c2c7220ULL, 0x088fe20000410000ULL, 0x0000000e2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000e3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000e3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000e38387220ULL, 0x080fe20000410000ULL, 0x0000000e39397220ULL, 0x080fe20000410000ULL,
0x0000000e28287220ULL, 0x080fe20000410000ULL, 0x0000000e29297220ULL, 0x080fe20000410000ULL,
0x0000000e24247220ULL, 0x080fe20000410000ULL, 0x0000000e25257220ULL, 0x080fe20000410000ULL,
0x0000000e34347220ULL, 0x080fe20000410000ULL, 0x0000000e35357220ULL, 0x080fe20000410000ULL,
0x0000000e30307220ULL, 0x080fe20000410000ULL, 0x0000000e31317220ULL, 0x080fe20000410000ULL,
0x0000000e20207220ULL, 0x080fe20000410000ULL, 0x0000000e21217220ULL, 0x000fe20000410000ULL,
0x000000182e2e7220ULL, 0x090fe20000410000ULL, 0x000000182f2f7220ULL, 0x080fe20000410000ULL,
0x000000183e3e7220ULL, 0x080fe20000410000ULL, 0x000000183f3f7220ULL, 0x080fe20000410000ULL,
0x000000183a3a7220ULL, 0x080fe20000410000ULL, 0x000000183b3b7220ULL, 0x080fe20000410000ULL,
0x000000182a2a7220ULL, 0x080fe20000410000ULL, 0x000000182b2b7220ULL, 0x080fe20000410000ULL,
0x0000001826267220ULL, 0x080fe20000410000ULL, 0x0000001827277220ULL, 0x080fe20000410000ULL,
0x0000001836367220ULL, 0x080fe20000410000ULL, 0x0000001837377220ULL, 0x080fe20000410000ULL,
0x0000001832327220ULL, 0x080fe20000410000ULL, 0x0000001833337220ULL, 0x080fe20000410000ULL,
0x0000001822227220ULL, 0x080fe20000410000ULL, 0x0000001823237220ULL, 0x000fe20000410000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e001eULL, 0x0000001b161b4220ULL, 0x004fc80000410000ULL,
0x000000101b107221ULL, 0x012fe20000010000ULL, 0x0000011000002947ULL, 0x000fea0003800000ULL,
0x0000000863637824ULL, 0x000fe400078e00ffULL, 0x800000001c197824ULL, 0x000fc600078e00ffULL,
0x0000000863187812ULL, 0x000fca00078e3cffULL, 0x000000015f5f7824ULL, 0x000fca00078e0218ULL,
0x00f64c005f187984ULL, 0x000e640000000800ULL, 0x8000000018ff7812ULL, 0x002fe40007844819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x800000001c1c7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x0000001800197305ULL, 0x0002e4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x000000190000735dULL, 0x008fe40003800000ULL, 0x00f64c005f197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fc4000784481cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000006118783bULL, 0x000e620000004200ULL,
0x00000016ff41723eULL, 0x000fe400000000ffULL, 0x00000002ff4b7819ULL, 0x000fe20000011608ULL,
0x00a800005e1c783bULL, 0x000fe20000000200ULL, 0x0000541041427816ULL, 0x000fe40000000041ULL,
0x0000991040407816ULL, 0x000fe200000000ffULL, 0x000000005c44783bULL, 0x000fe60000004200ULL,
0x000000ff4000720cULL, 0x000fe20003f45270ULL, 0x00001f4b424b7589ULL, 0x000ee800000e0000ULL,
0x00001f4a424a7589ULL, 0x000f2200000e0000ULL, 0x0000312018187816ULL, 0x002fc400000000ffULL,
0x0000312019197816ULL, 0x000fe400000000ffULL, 0x00000018ff40723eULL, 0x000fc600020006ffULL,
0x0000004b1c1ca232ULL, 0x088fe20000000000ULL, 0x00000019ff41723eULL, 0x080fe200020006ffULL,
0x0000004b1e1ea232ULL, 0x000fe20000000000ULL, 0x00000018ff18723eULL, 0x000fe200030006ffULL,
0x0000004a1d1da232ULL, 0x090fe20000000000ULL, 0x00000019ff19723eULL, 0x000fe200030006ffULL,
0x0000004a1f1fa232ULL, 0x000fe20000000000ULL, 0x000031201a4c7816ULL, 0x000fe400000000ffULL,
0x000031201b4d7816ULL, 0x000fe400000000ffULL, 0x0000312044447816ULL, 0x000fc400000000ffULL,
0x000000181c3c723cULL, 0x000fe2000000183cULL, 0x0000312045457816ULL, 0x000fcc00000000ffULL,
0x0000004cff18723eULL, 0x080fe200020006ffULL, 0x000000401c2c723cULL, 0x000fe2000000182cULL,
0x0000004dff19723eULL, 0x080fe200020006ffULL, 0x000000005940783bULL, 0x000e620000004200ULL,
0x0000004cff4c723eULL, 0x000fe400030006ffULL, 0x0000004dff4d723eULL, 0x000fc600030006ffULL,
0x000000181c38723cULL, 0x040fe20000001838ULL, 0x00a800005a18783bULL, 0x000eee0000000200ULL,
0x0000004c1c28723cULL, 0x000fee0000001828ULL, 0x00000044ff4c723eULL, 0x000fc400020006ffULL,
0x00000045ff4d723eULL, 0x080fe400020006ffULL, 0x00000044ff44723eULL, 0x000fe400030006ffULL,
0x00000045ff45723eULL, 0x000fc600030006ffULL, 0x0000004c1c24723cULL, 0x040fee0000001824ULL,
0x00003120464c7816ULL, 0x000fe200000000ffULL, 0x000000441c34723cULL, 0x000fe20000001834ULL,
0x00003120474d7816ULL, 0x000fe400000000ffULL, 0x0000312040407816ULL, 0x002fc400000000ffULL,
0x0000312041417816ULL, 0x000fe400000000ffULL, 0x0000004cff44723eULL, 0x080fe400020006ffULL,
0x0000004dff45723eULL, 0x080fe200020006ffULL, 0x0000004b1818a232ULL, 0x088fe20000000000ULL,
0x0000004cff4c723eULL, 0x000fe200030006ffULL, 0x0000004b1a1aa232ULL, 0x000fe20000000000ULL,
0x0000004dff4d723eULL, 0x000fe200030006ffULL, 0x0000004a1919a232ULL, 0x080fe20000000000ULL,
0x0000312042427816ULL, 0x000fe200000000ffULL, 0x000000441c30723cULL, 0x000fe20000001830ULL,
0x000000005744783bULL, 0x000e620000004200ULL, 0x0000004a1b1ba232ULL, 0x000fe20000000000ULL,
0x0000312043437816ULL, 0x000fca00000000ffULL, 0x0000004c1c20723cULL, 0x000fee0000001820ULL,
0x00000040ff1c723eULL, 0x080fe400020006ffULL, 0x00000041ff1d723eULL, 0x000fe400020006ffULL,
0x00000040ff40723eULL, 0x000fc400030006ffULL, 0x00000041ff41723eULL, 0x000fc600030006ffULL,
0x0000001c182c723cULL, 0x040fee000000182cULL, 0x00000042ff1c723eULL, 0x080fe200020006ffULL,
0x00000040183c723cULL, 0x000fe2000000183cULL, 0x00000043ff1d723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fc400030006ffULL, 0x00000043ff43723eULL, 0x000fc600030006ffULL,
0x0000001c1838723cULL, 0x040fe20000001838ULL, 0x0000312044447816ULL, 0x002fe400000000ffULL,
0x0000312045457816ULL, 0x000fe400000000ffULL, 0x0000312046467816ULL, 0x000fe400000000ffULL,
0x00000044ff1c723eULL, 0x000fe200020006ffULL, 0x000000421828723cULL, 0x000fe20000001828ULL,
0x00000045ff1d723eULL, 0x000fe400020006ffULL, 0x0000312047477816ULL, 0x000fc400000000ffULL,
0x00000044ff44723eULL, 0x000fe400030006ffULL, 0x00000045ff45723eULL, 0x000fe200030006ffULL,
0x0000001c1824723cULL, 0x040fee0000001824ULL, 0x00000046ff1c723eULL, 0x000fe200020006ffULL,
0x000000441834723cULL, 0x000fe20000001834ULL, 0x00000047ff1d723eULL, 0x000fc400020006ffULL,
0x00000046ff46723eULL, 0x000fe400030006ffULL, 0x00000047ff47723eULL, 0x000fc600030006ffULL,
0x0000001c1830723cULL, 0x040ff00000001830ULL, 0x000000461820723cULL, 0x000fe20000001820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200011ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6400015ff7f8cULL, 0x0007e2000c80043fULL, 0x000099106b187816ULL, 0x000fc400000000ffULL,
0x00000001ff727807ULL, 0x000fe40004800000ULL, 0x000000ff1800720cULL, 0x000fe40003f45270ULL,
0x0000000114717812ULL, 0x000fe400078ec0ffULL, 0x00000001ff568807ULL, 0x000fc80001000000ULL,
0x0000761056737816ULL, 0x000fe40000000073ULL, 0x0000030049497a10ULL, 0x00cfe40007ffe0ffULL,
0x000000ff13ff7812ULL, 0x000fe4000780c0ffULL, 0x000000024900720cULL, 0x000fe40003f26070ULL,
0x00000001ff137807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffffad3000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x002e640000002500ULL,
0x0000000402007c0cULL, 0x002fda000bf03070ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x0180000010007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x000fe200078e0010ULL,
0x000062c000067802ULL, 0x020fe40000000f00ULL, 0x0000824000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001000057308ULL, 0x000e640000001000ULL,
0xbf80000005007423ULL, 0x002fc80000000010ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000005007223ULL, 0x000fe40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff057624ULL, 0x000fe400078e00ffULL, 0x00006800ff047624ULL, 0x006fca00078e00ffULL,
0x0000000804057981ULL, 0x000ea8000c1e9900ULL, 0x0000000000027919ULL, 0x000e680000000000ULL,
0x0000000000087919ULL, 0x000f220000000000ULL, 0x00000002ff067819ULL, 0x022fe40000011602ULL,
0x0000000808027811ULL, 0x010fe200078ff0ffULL, 0x0000000005077220ULL, 0x00cfca0000410000ULL,
0x00001f0607007589ULL, 0x000e6800000e0000ULL, 0x00001f0207027589ULL, 0x000ea200000e0000ULL,
0x0000002c002c7220ULL, 0x042fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000003c003c7220ULL, 0x040fe20000410000ULL, 0x0000003d003d7220ULL, 0x040fe20000410000ULL,
0x0000003800387220ULL, 0x040fe20000410000ULL, 0x0000003900397220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002900297220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000003400347220ULL, 0x040fe20000410000ULL, 0x0000003500357220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x040fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002100217220ULL, 0x000fe20000410000ULL,
0x0000002e022e7220ULL, 0x044fe20000410000ULL, 0x0000002f022f7220ULL, 0x040fe20000410000ULL,
0x0000003e023e7220ULL, 0x040fe20000410000ULL, 0x0000003f023f7220ULL, 0x040fe20000410000ULL,
0x0000003a023a7220ULL, 0x040fe20000410000ULL, 0x0000003b023b7220ULL, 0x040fe20000410000ULL,
0x0000002a022a7220ULL, 0x040fe20000410000ULL, 0x0000002b022b7220ULL, 0x040fe20000410000ULL,
0x0000002602267220ULL, 0x040fe20000410000ULL, 0x0000002702277220ULL, 0x040fe20000410000ULL,
0x0000003602367220ULL, 0x040fe20000410000ULL, 0x0000003702377220ULL, 0x040fe20000410000ULL,
0x0000003202327220ULL, 0x040fe20000410000ULL, 0x0000003302337220ULL, 0x040fe20000410000ULL,
0x0000002202227220ULL, 0x040fe20000410000ULL, 0x0000002302237220ULL, 0x000fc40000410000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x000000323333723eULL, 0x000fc400000000ffULL,
0x000000222322723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x0000541033327816ULL, 0x140fe40000000022ULL, 0x0000763233337816ULL, 0x000fe40000000022ULL,
0x0000000200027812ULL, 0x002fe200078ec0ffULL, 0x000000010b1a7824ULL, 0x100fe200078e0200ULL,
0x00000002ff157819ULL, 0x000fc40000011600ULL, 0x0000000202067811ULL, 0x060fe400078ff8ffULL,
0x0000000402087811ULL, 0x000fe400078ff8ffULL, 0x00000008001b7811ULL, 0x000fe400078ff0ffULL,
0x00000001ff047819ULL, 0x000fe40000011602ULL, 0x0000000602127811ULL, 0x000fe400078ff8ffULL,
0x0000000706057812ULL, 0x000fc400078e7815ULL, 0x00000007080f7812ULL, 0x040fe400078e7815ULL,
0x0000000708087812ULL, 0x000fe200078e781bULL, 0x00000008150d7824ULL, 0x000fe200078e0205ULL,
0x0000000704027812ULL, 0x100fe200078e7815ULL, 0x0000100009057824ULL, 0x000fe200078e00ffULL,
0x0000000712137812ULL, 0x000fe200078e7815ULL, 0x000000081b197824ULL, 0x000fe200078e0208ULL,
0x0000000704047812ULL, 0x100fe200078e781bULL, 0x0000000800087824ULL, 0x000fe200078e00ffULL,
0x0000000706067812ULL, 0x100fe200078e781bULL, 0x0000000815077824ULL, 0x040fe200078e0202ULL,
0x0000000712127812ULL, 0x000fe200078e781bULL, 0x0000000815117824ULL, 0x040fe200078e020fULL,
0x0000000808087812ULL, 0x000fe200078ec0ffULL, 0x0000000815137824ULL, 0x000fc400078e0213ULL,
0x000000081b157824ULL, 0x000fe200078e0204ULL, 0x0000002c2d04723eULL, 0x000fe200000000ffULL,
0x000000081b177824ULL, 0x000fe200078e0206ULL, 0x0000003c3d06723eULL, 0x000fe200000000ffULL,
0x000008000a027824ULL, 0x000fe400078e0205ULL, 0x000000081b1b7824ULL, 0x000fe200078e0212ULL,
0x00005410041c7816ULL, 0x040fe20000000006ULL, 0x0000001007077824ULL, 0x000fe200078e0202ULL,
0x00007632041d7816ULL, 0x000fe20000000006ULL, 0x000000100d0f7824ULL, 0x100fe200078e0202ULL,
0x000000242504723eULL, 0x000fe200000000ffULL, 0x0000001011117824ULL, 0x100fe200078e0202ULL,
0x000000343506723eULL, 0x000fe200000000ffULL, 0x0000001015157824ULL, 0x000fc400078e0202ULL,
0x0000001017177824ULL, 0x100fe400078e0202ULL, 0x0000001013137824ULL, 0x100fe400078e0202ULL,
0x0000001019197824ULL, 0x100fe400078e0202ULL, 0x000000101b1b7824ULL, 0x000fe400078e0202ULL,
0x00000001070d7824ULL, 0x000fe200078e0208ULL, 0x000000383907723eULL, 0x000fe200000000ffULL,
0x00000001080f7824ULL, 0x000fc400078e020fULL, 0x0000000108117824ULL, 0x040fe200078e0211ULL,
0x0000001c0d007388ULL, 0x0003e20000000a00ULL, 0x0000000108157824ULL, 0x040fe400078e0215ULL,
0x0000000108177824ULL, 0x040fe400078e0217ULL, 0x0000000108137824ULL, 0x040fe400078e0213ULL,
0x0000000108197824ULL, 0x040fe400078e0219ULL, 0x00000001081b7824ULL, 0x000fe200078e021bULL,
0x000000282908723eULL, 0x000fc800000000ffULL, 0x00005410071c7816ULL, 0x142fe40000000008ULL,
0x00007632071d7816ULL, 0x000fe40000000008ULL, 0x000000303107723eULL, 0x000fe400000000ffULL,
0x000000202108723eULL, 0x000fe200000000ffULL, 0x0000001c0f007388ULL, 0x0003e40000000a00ULL,
0x00005410041c7816ULL, 0x142fe40000000006ULL, 0x00007632041d7816ULL, 0x000fc40000000006ULL,
0x0000002e2f04723eULL, 0x000fe400000000ffULL, 0x0000003e3f06723eULL, 0x000fe200000000ffULL,
0x0000001c11007388ULL, 0x0003e60000000a00ULL, 0x0000541004127816ULL, 0x000fe40000000006ULL,
0x00005410071c7816ULL, 0x142fe40000000008ULL, 0x00007632071d7816ULL, 0x000fc40000000008ULL,
0x0000003a3b07723eULL, 0x000fe400000000ffULL, 0x0000002a2b08723eULL, 0x000fe200000000ffULL,
0x0000001c13007388ULL, 0x0003e40000000a00ULL, 0x0000763204137816ULL, 0x002fe40000000006ULL,
0x000000262704723eULL, 0x000fe400000000ffULL, 0x000000363706723eULL, 0x000fe200000000ffULL,
0x0000001215007388ULL, 0x0003e40000000a00ULL, 0x0000541007127816ULL, 0x002fc40000000008ULL,
0x0000763207137816ULL, 0x000fe20000000008ULL, 0x000000101a087824ULL, 0x000fc800078e0205ULL,
0x0000001217007388ULL, 0x0003e40000000a00ULL, 0x0000541004127816ULL, 0x142fe40000000006ULL,
0x0000763204137816ULL, 0x000fca0000000006ULL, 0x0000001219007388ULL, 0x000fe80000000a00ULL,
0x000000321b007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000008147984ULL, 0x000e680000000c00ULL, 0x00080000081c7984ULL, 0x000ea80000000c00ULL,
0x0004000008207984ULL, 0x000ee80000000c00ULL, 0x000c000008247984ULL, 0x000f220000000c00ULL,
0x200000ff16167230ULL, 0x002fc40000000000ULL, 0x200000ff17177230ULL, 0x000fe40000000000ULL,
0x0000001e16167230ULL, 0x004fe20000000000ULL, 0x00000300ff1e7624ULL, 0x000fe200078e00ffULL,
0x200000ff15157230ULL, 0x000fe40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x000000011e00780cULL, 0x000fe20003f05270ULL, 0x200000ff23237230ULL, 0x008fe40000000000ULL,
0x200000ff22227230ULL, 0x000fc40000000000ULL, 0x200000ff21217230ULL, 0x000fe40000000000ULL,
0x200000ff20207230ULL, 0x000fe40000000000ULL, 0x0000001f17177230ULL, 0x000fe40000000000ULL,
0x0000001d15157230ULL, 0x000fe40000000000ULL, 0x0000001c14147230ULL, 0x000fe40000000000ULL,
0x0000002723237230ULL, 0x010fc40000000000ULL, 0x0000002622227230ULL, 0x000fe20000000000ULL,
0x0000001408007388ULL, 0x0003e20000000c00ULL, 0x0000002521217230ULL, 0x000fe40000000000ULL,
0x0000002420207230ULL, 0x000fca0000000000ULL, 0x0004002008007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000303000008947ULL, 0x000fea0003800000ULL,
0x00000000000f7919ULL, 0x000ea20000002700ULL, 0x000058001e047a24ULL, 0x000fe200078e02ffULL,
0x000000010aff7812ULL, 0x000fe2000780f848ULL, 0x00001000ff137424ULL, 0x000fe200078e00ffULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x00006600040d7a24ULL, 0x000fe200078e02ffULL,
0x000000401a1d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000008147984ULL, 0x002e640000000c00ULL,
0x00000fff0d047811ULL, 0x040fe400078e40ffULL, 0x0004000008207984ULL, 0x0007240000000c00ULL,
0x01ffffff0d087812ULL, 0x008fe200078ec0ffULL, 0x000058000f0f7a24ULL, 0x004fe400078e0206ULL,
0x0000080009067824ULL, 0x000fe400078e00ffULL, 0x000003000f077a24ULL, 0x000fca00078e02ffULL,
0x0000000407117c10ULL, 0x000fc8000fffe0ffULL, 0x0000001104127211ULL, 0x000fca00078fa0ffULL,
0x00006c0012127625ULL, 0x000fca00078e0013ULL, 0x0000000612127210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e0613ULL, 0x000000ff0000720cULL, 0x000fc60000725670ULL,
0x000000101a1a7825ULL, 0x000fc800078e0012ULL, 0x000000101d1c7825ULL, 0x000fe200078e0012ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000001ff127819ULL, 0x012fe20000011600ULL,
0x00000010000d7824ULL, 0x000fe400078e00ffULL, 0x00000080ff197424ULL, 0x000fe200078e00ffULL,
0x0000000c121f7812ULL, 0x000fe200078ec0ffULL, 0x0000000111187824ULL, 0x000fe200078e0208ULL,
0x000000700d0d7812ULL, 0x000fe200078ec0ffULL, 0x00006c0011127625ULL, 0x000fc800078e0019ULL,
0x00006c0018187625ULL, 0x000fe200078e0019ULL, 0x000000121f127210ULL, 0x000fc80007a1e00dULL,
0x000000181f187210ULL, 0x000fe40007c7e00dULL, 0x00000013ff137210ULL, 0x000fe400007e44ffULL,
0x00000019ff197210ULL, 0x000fc60001fe84ffULL, 0x0000000e12007986ULL, 0x0003e8000c101908ULL,
0x0000001018007986ULL, 0x0003e4000c101908ULL, 0x000000141a007986ULL, 0x0123e2000c101d08ULL,
0x0000012000007945ULL, 0x000fe60003800000ULL, 0x000000201c007986ULL, 0x0003e8000c101d08ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff0e7424ULL, 0x000fe200078e00ffULL, 0xffffffff1e0d7810ULL, 0x000fc60007ffe0ffULL,
0x00006a000f0e7625ULL, 0x000fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000d0e0e79a8ULL, 0x000ea400099ee1c8ULL,
0x0000000d0e00720cULL, 0x004fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff107807ULL, 0x000fca0000000000ULL, 0x00000010ff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff0d7984ULL, 0x000ee40000000000ULL, 0x000000ff0d00720cULL, 0x008fda0003f05270ULL,
0x00002c6000008947ULL, 0x000fea0003800000ULL, 0x000000ff4800720cULL, 0x000fda0003f05270ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff0e7819ULL, 0x000fe20000011600ULL,
0x00000010000d7824ULL, 0x000fe200078e00ffULL, 0x0000000107107810ULL, 0x004fe20007ffe0ffULL,
0x00000080ff137424ULL, 0x000fe200078e00ffULL, 0x0000000c0e177812ULL, 0x002fe400078ec0ffULL,
0x000000700d157812ULL, 0x000fe200078ec0ffULL, 0x00006c00070e7625ULL, 0x000fc800078e0013ULL,
0x00006c0010107625ULL, 0x000fe200078e0013ULL, 0x0000000e170e7210ULL, 0x000fc8000791e015ULL,
0x0000001017107210ULL, 0x000fe40007b5e015ULL, 0x0000000fff0f7210ULL, 0x000fe400007e24ffULL,
0x00000011ff117210ULL, 0x000fc600017e64ffULL, 0x000000080e0d7981ULL, 0x000368000c1e1900ULL,
0x0000000810127981ULL, 0x000362000c1e1900ULL, 0x000000021e00780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002070e7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000e0e7625ULL, 0x000fca00078e0013ULL, 0x0000000e170e7210ULL, 0x000fc8000791e015ULL,
0x0000000fff0f7210ULL, 0x000fca00007e24ffULL, 0x000000080e147981ULL, 0x000362000c1e1900ULL,
0x000000041e00780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003070e7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000e0e7625ULL, 0x000fca00078e0013ULL,
0x0000000e170e7210ULL, 0x000fc8000791e015ULL, 0x0000000fff0f7210ULL, 0x000fca00007e24ffULL,
0x000000080e167981ULL, 0x000362000c1e1900ULL, 0x000000041e00780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004070e7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000e0e7625ULL, 0x000fca00078e0013ULL, 0x0000000e170e7210ULL, 0x000fc8000791e015ULL,
0x0000000fff0f7210ULL, 0x000fca00007e24ffULL, 0x000000080e187981ULL, 0x000362000c1e1900ULL,
0x000000061e00780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005070e7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000e0e7625ULL, 0x000fca00078e0013ULL,
0x0000000e170e7210ULL, 0x000fc8000791e015ULL, 0x0000000fff0f7210ULL, 0x000fca00007e24ffULL,
0x000000080e1a7981ULL, 0x000362000c1e1900ULL, 0x000000061e00780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081e00780cULL, 0x002fe40003f06070ULL,
0x00000006070e7810ULL, 0x000fca0007ffe0ffULL, 0x00006c000e0e7625ULL, 0x000fca00078e0013ULL,
0x0000000e170e7210ULL, 0x000fe40007a3e015ULL, 0x0000000707100810ULL, 0x000fe40007ffe0ffULL,
0x0000000fff0f7210ULL, 0x000fc60000fe44ffULL, 0x00006c0010100625ULL, 0x000fe400078e0013ULL,
0x000000080e1c7981ULL, 0x000366000c1e1900ULL, 0x0000001017100210ULL, 0x000fc80007c7e015ULL,
0x00000011ff110210ULL, 0x000fca0001fe84ffULL, 0x0000000810100981ULL, 0x000368000c1e1900ULL,
0x000000071e0e7810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff117819ULL, 0x000fc8000001160eULL,
0x000000ff1100720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff1e7224ULL, 0x000fe400078e00ffULL, 0x000000ffff207224ULL, 0x020fe400078e000dULL,
0x000000081e137824ULL, 0x040fe200078e00ffULL, 0x000000011e1e7810ULL, 0x000fc80007ffe0ffULL,
0x0000030013007a0cULL, 0x000fe40003f26070ULL, 0x000000111e00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x00000008130e7810ULL, 0x040fe40007ffe0ffULL,
0x00000001130f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x000000200d0d7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x00000001ff177819ULL, 0x000fe20000011600ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001000157824ULL, 0x000fe200078e00ffULL, 0x0000000c17177812ULL, 0x000fe200078ec0ffULL,
0x00006c000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007015157812ULL, 0x000fc800078ec0ffULL,
0x0000000e170e7210ULL, 0x000fc80007b3e015ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000080e207981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x00000009130e7810ULL, 0x042fe40007ffe0ffULL, 0x00000002130f7810ULL, 0x000fe40007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x000003000f007a0cULL, 0x000fe40003f46070ULL,
0x000000120d0d7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x00000001ff177819ULL, 0x000fe20000011600ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x0000000c17177812ULL, 0x000fe200078ec0ffULL, 0x00006c000e0e7625ULL, 0x000fc600078e000fULL,
0x0000007012157812ULL, 0x000fc800078ec0ffULL, 0x0000000e170e7210ULL, 0x000fc80007b3e015ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000080e127981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a130e7810ULL, 0x042fe40007ffe0ffULL,
0x00000003130f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x000000140d0d7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x00000001ff177819ULL, 0x000fe20000011600ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001000147824ULL, 0x000fe200078e00ffULL, 0x0000000c17177812ULL, 0x000fe200078ec0ffULL,
0x00006c000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007014157812ULL, 0x000fc800078ec0ffULL,
0x0000000e170e7210ULL, 0x000fc80007b3e015ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000080e147981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b130e7810ULL, 0x042fe40007ffe0ffULL, 0x00000004130f7810ULL, 0x000fe40007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x000003000f007a0cULL, 0x000fe40003f46070ULL,
0x000000160d0d7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x00000001ff167819ULL, 0x000fe20000011600ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001000157824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006c000e0e7625ULL, 0x000fc600078e000fULL,
0x0000007015157812ULL, 0x000fc800078ec0ffULL, 0x0000000e160e7210ULL, 0x000fc80007b3e015ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000080e167981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c130e7810ULL, 0x042fe40007ffe0ffULL,
0x00000005130f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x000000180d0d7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x00000001ff177819ULL, 0x000fe20000011600ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001000157824ULL, 0x000fe200078e00ffULL, 0x0000000c17177812ULL, 0x000fe200078ec0ffULL,
0x00006c000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007015157812ULL, 0x000fc800078ec0ffULL,
0x0000000e170e7210ULL, 0x000fc80007b3e015ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000080e187981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d130e7810ULL, 0x042fe40007ffe0ffULL, 0x00000006130f7810ULL, 0x000fe40007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x000003000f007a0cULL, 0x000fe40003f46070ULL,
0x0000001a0d0d7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x00000001ff177819ULL, 0x000fe20000011600ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001000157824ULL, 0x000fe200078e00ffULL,
0x0000000c17177812ULL, 0x000fe200078ec0ffULL, 0x00006c000e0e7625ULL, 0x000fc600078e000fULL,
0x0000007015157812ULL, 0x000fc800078ec0ffULL, 0x0000000e170e7210ULL, 0x000fc80007b3e015ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000080e1a7981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e130e7810ULL, 0x042fe40007ffe0ffULL,
0x00000007130f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001c0d0d7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x00000001ff177819ULL, 0x000fe20000011600ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001000157824ULL, 0x000fe200078e00ffULL, 0x0000000c17177812ULL, 0x000fe200078ec0ffULL,
0x00006c000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007015157812ULL, 0x000fc800078ec0ffULL,
0x0000000e170e7210ULL, 0x000fc80007b3e015ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000080e1c7981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f130e7810ULL, 0x002fe40007ffe0ffULL, 0x000000100d0d7209ULL, 0x000fe40007810000ULL,
0x000003000e007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x00000001ff157819ULL, 0x000fe20000011600ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x004fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006c000e0e7625ULL, 0x000fc600078e000fULL,
0x0000007010137812ULL, 0x000fc800078ec0ffULL, 0x0000000e150e7210ULL, 0x000fc80007a3e013ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe44ffULL, 0x000000080e107981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ee40000000000ULL,
0x00000010000e7824ULL, 0x00afe200078e00ffULL, 0x00000001ff0f7819ULL, 0x000fc80000011600ULL,
0x000000700e0e7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0f0f7812ULL, 0x000fca00078ec0ffULL,
0x000000010f0e7824ULL, 0x000fca00078e020eULL, 0x0000000d0e007388ULL, 0x0203e40000000800ULL,
0x000000010a197824ULL, 0x000fe200078e0207ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x00000010000d7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0f7819ULL, 0x000fe20000011600ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000019040e7211ULL, 0x000fe200078fa0ffULL,
0x00001000ff137424ULL, 0x000fe200078e00ffULL, 0x000000700d117812ULL, 0x000fe200078ec0ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0205ULL, 0x0000000c0f127812ULL, 0x000fe200078ec0ffULL,
0x00006c000e0e7625ULL, 0x000fe200078e0013ULL, 0x00000001030d7812ULL, 0x040fe200078ec0ffULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000004000137810ULL, 0x000fe20007ffe0ffULL,
0x0000080003037824ULL, 0x000fe200078e00ffULL, 0x000000060e0e7210ULL, 0x000fe20007f3e0ffULL,
0x000000020a108824ULL, 0x004fe200078e0209ULL, 0x0000006000157810ULL, 0x000fe20007ffe0ffULL,
0x00000001121a7824ULL, 0x000fe200078e0211ULL, 0x0000080003037812ULL, 0x000fe200078ec0ffULL,
0x000000020a128824ULL, 0x000fe200078e0209ULL, 0x0000002000117810ULL, 0x000fe20007ffe0ffULL,
0x0000000108168824ULL, 0x000fe200078e0219ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000080ff178424ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000002101d8824ULL, 0x000fe200078e020dULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x000003000a007a0cULL, 0x000fe20003f26070ULL,
0x00000080ff188424ULL, 0x000fe200078e00ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000002120d8824ULL, 0x000fe200078e020dULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000010c037824ULL, 0x000fe200078e0203ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00006c0016168625ULL, 0x000fc800078e0017ULL, 0x0000001011107825ULL, 0x000fc800078e000eULL,
0x0000001013127825ULL, 0x000fc800078e000eULL, 0x0000001015147825ULL, 0x000fc800078e000eULL,
0x00006c0019188625ULL, 0x000fc800078e0018ULL, 0x000000081d1d8824ULL, 0x000fe400078e0200ULL,
0x00000010001b7824ULL, 0x040fe400078e0203ULL, 0x00000010000e7825ULL, 0x040fe200078e000eULL,
0x000000001a037984ULL, 0x0002a20000000800ULL, 0x000045801d1d8811ULL, 0x000fe400078e20ffULL,
0x000000080d0d8824ULL, 0x000fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000e1b7faeULL, 0x0007e2000b901c48ULL, 0x0000001000168825ULL, 0x000fc600078e0016ULL,
0x000041800d1f8811ULL, 0x000fe200078e20ffULL, 0x0000001000188825ULL, 0x000fe200078e0018ULL,
0x00380000101b7faeULL, 0x0009e6000b901c48ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x00580000121b7faeULL, 0x000be2000b901c48ULL, 0x00000000000e7805ULL, 0x008fc6000001ff00ULL,
0x00780000141b7faeULL, 0x0007e8000b901c48ULL, 0x00000000161d8faeULL, 0x0003e2000b901c48ULL,
0x0000000000107805ULL, 0x010fc6000001ff00ULL, 0x00000000181f8faeULL, 0x0009e2000b901c48ULL,
0x0000000000127805ULL, 0x020fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000147805ULL, 0x008fe2000001ff00ULL, 0x00000000001a7805ULL, 0x002fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x010fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000e0000001947ULL, 0x000fea0003800000ULL, 0x00000df000007945ULL, 0x004fe20003800000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e00ffULL, 0x000000ffff327224ULL, 0x000fca00078e000aULL,
0x0000000232307810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff457224ULL, 0x000fe200078e0032ULL,
0x00000002ff2f7819ULL, 0x000fe20000011600ULL, 0x000000020a327824ULL, 0x000fe200078e0209ULL,
0x0000030030007a0cULL, 0x000fe20003f06070ULL, 0x0000004045317824ULL, 0x000fe200078e00ffULL,
0x000000072f337812ULL, 0x040fe200078ec0ffULL, 0x000000082f2e7824ULL, 0x040fe200078e00ffULL,
0x0000002fff4c7212ULL, 0x000fe200078e33ffULL, 0x000000082f3e7824ULL, 0x000fe200078e00ffULL,
0x0000008031317812ULL, 0x000fe200078ec0ffULL, 0x000000082f357824ULL, 0x002fe200078e00ffULL,
0x0000039000017945ULL, 0x000fe20003800000ULL, 0x000000012e407812ULL, 0x100fe200078ef633ULL,
0x0000001000497824ULL, 0x000fe200078e00ffULL, 0x000000022e427812ULL, 0x000fe200078ef633ULL,
0x0000010032437824ULL, 0x000fe200078e0031ULL, 0x000000032e447812ULL, 0x000fc400078ef633ULL,
0x000000042e467812ULL, 0x140fe400078ef633ULL, 0x000000052e487812ULL, 0x140fe400078ef633ULL,
0x000000062e4a7812ULL, 0x100fe400078ef633ULL, 0xfffffff83e3e7812ULL, 0x000fe400078ee233ULL,
0xfffffff8354c7812ULL, 0x000fe400078ee24cULL, 0x000000082f2e7810ULL, 0x000fe20007ffe0ffULL,
0x000002c000000947ULL, 0x008fea0003800000ULL, 0x00000001073d7824ULL, 0x100fe200078e0230ULL,
0x000000070000780cULL, 0x000fe20003f24070ULL, 0x00001000ff337424ULL, 0x000fe200078e00ffULL,
0x00000001ff317819ULL, 0x000fc40000011630ULL, 0x0000003d04327211ULL, 0x000fe400078fa0ffULL,
0x0000000131347812ULL, 0x000fe200078ec0ffULL, 0x0000040030317824ULL, 0x000fe200078e00ffULL,
0x0000002000377810ULL, 0x000fe20007ffe0ffULL, 0x00006c0032327625ULL, 0x000fe200078e0033ULL,
0x0000004000397810ULL, 0x000fe40007ffe0ffULL, 0x0000080031317812ULL, 0x000fe200078ec0ffULL,
0x000000020a3f9824ULL, 0x100fe200078e0209ULL, 0x0000000632327210ULL, 0x000fe20007f1e0ffULL,
0x000000020a359824ULL, 0x000fe200078e0209ULL, 0x0000006000417810ULL, 0x000fe20007ffe0ffULL,
0x00000001083a9824ULL, 0x000fc400078e023dULL, 0x000000ffff337224ULL, 0x000fe400000e0633ULL,
0x00000080ff3b9424ULL, 0x000fe400078e00ffULL, 0x000000023f3f9824ULL, 0x100fe400078e0234ULL,
0x00000080ff3c9424ULL, 0x000fe400078e00ffULL, 0x0000000235479824ULL, 0x000fe400078e0234ULL,
0x000000010c317824ULL, 0x000fc400078e0231ULL, 0x00006c003a3a9625ULL, 0x000fc800078e003bULL,
0x0000001000347825ULL, 0x000fc800078e0032ULL, 0x0000001037367825ULL, 0x000fc800078e0032ULL,
0x0000001039387825ULL, 0x000fc800078e0032ULL, 0x00006c003d3c9625ULL, 0x000fc800078e003cULL,
0x0000001041327825ULL, 0x000fc800078e0032ULL, 0x000000083f3f9824ULL, 0x100fe400078e0200ULL,
0x0000001000317824ULL, 0x040fe400078e0231ULL, 0x0000000847419824ULL, 0x000fe200078e0200ULL,
0x000045803f3f9811ULL, 0x000fe200078e20ffULL, 0x00000010003a9825ULL, 0x040fe200078e003aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000034317faeULL, 0x0003e4000b901c48ULL,
0x0000418041419811ULL, 0x000fe200078e20ffULL, 0x00000010003c9825ULL, 0x000fe200078e003cULL,
0x0038000036317faeULL, 0x0003e8000b901c48ULL, 0x0058000038317faeULL, 0x0003e8000b901c48ULL,
0x0078000032317faeULL, 0x0003e8000b901c48ULL, 0x000000003a3f9faeULL, 0x0003e8000b901c48ULL,
0x000000003c419faeULL, 0x0003e4000b901c48ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000001ff347819ULL, 0x002fe20000011600ULL,
0x000000082e337824ULL, 0x000fe200078e00ffULL, 0x0000007049527812ULL, 0x000fe200078ec0ffULL,
0x0000040045317824ULL, 0x000fe200078e00ffULL, 0x0000000c34357812ULL, 0x000fe200078ec0ffULL,
0x000000082e377824ULL, 0x040fe200078e00ffULL, 0x000000072e327812ULL, 0x000fc400078ec0ffULL,
0x0000004335437210ULL, 0x000fe40007ffe052ULL, 0x0000000133367812ULL, 0x140fe400078ef632ULL,
0x0000000233387812ULL, 0x140fe400078ef632ULL, 0x00000003333a7812ULL, 0x140fe400078ef632ULL,
0x00000004333c7812ULL, 0x140fe400078ef632ULL, 0x00000005334e7812ULL, 0x000fc400078ef632ULL,
0x0000000633507812ULL, 0x000fe200078ef632ULL, 0x000000082e337824ULL, 0x000fe200078e00ffULL,
0x0000080031317812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800043547984ULL, 0x000e620000000800ULL, 0x0000002eff527212ULL, 0x000fe400078e33ffULL,
0xfffffff837347812ULL, 0x000fe200078ee232ULL, 0x0000000400327824ULL, 0x000fe200078e00ffULL,
0x000001800c317810ULL, 0x000fe20007ffe031ULL, 0x0045800043437984ULL, 0x000ea20000000800ULL,
0xfffffff833527812ULL, 0x000fe400078ee252ULL, 0x0000000c32337812ULL, 0x000fe200078ec0ffULL,
0x000000103e3e7824ULL, 0x000fc400078e0231ULL, 0x0000001040407824ULL, 0x100fe400078e0231ULL,
0x0000001042427824ULL, 0x100fe400078e0231ULL, 0x0000001044447824ULL, 0x100fe400078e0231ULL,
0x0000001046467824ULL, 0x100fe400078e0231ULL, 0x0000001048487824ULL, 0x100fe400078e0231ULL,
0x000000104a4a7824ULL, 0x000fc400078e0231ULL, 0x0000001038387824ULL, 0x100fe400078e0231ULL,
0x000000103a3a7824ULL, 0x100fe400078e0231ULL, 0x000000103c3c7824ULL, 0x100fe400078e0231ULL,
0x000000104e4e7824ULL, 0x100fe400078e0231ULL, 0x0000001050507824ULL, 0x100fe400078e0231ULL,
0x000000104c4c7824ULL, 0x000fc400078e0231ULL, 0x0000001052527824ULL, 0x100fe400078e0231ULL,
0x0000001034347824ULL, 0x100fe400078e0231ULL, 0x0000001036367824ULL, 0x000fe200078e0231ULL,
0x0000005403547221ULL, 0x002fe20000010100ULL, 0x000000013e3e7824ULL, 0x000fe400078e0233ULL,
0x0000000133407824ULL, 0x040fe200078e0240ULL, 0x3fb8aa3b54547820ULL, 0x000fe20000410000ULL,
0x0000000133427824ULL, 0x000fc400078e0242ULL, 0x0000000133447824ULL, 0x040fe200078e0244ULL,
0x000000003e3e7984ULL, 0x000e620000000800ULL, 0x0000000133467824ULL, 0x040fe200078e0246ULL,
0x0000005400547308ULL, 0x000ea20000000800ULL, 0x0000000133487824ULL, 0x040fe200078e0248ULL,
0x0000000040407984ULL, 0x000ee20000000800ULL, 0x00000001334a7824ULL, 0x040fe400078e024aULL,
0x00000001334c7824ULL, 0x040fe200078e024cULL, 0x0000000042427984ULL, 0x000f220000000800ULL,
0x0000000133387824ULL, 0x000fc400078e0238ULL, 0x00000001333a7824ULL, 0x040fe200078e023aULL,
0x0000000044447984ULL, 0x000f620000000800ULL, 0x00000001333c7824ULL, 0x040fe400078e023cULL,
0x00000001334e7824ULL, 0x040fe200078e024eULL, 0x0000000046467984ULL, 0x000f620000000800ULL,
0x0000000133507824ULL, 0x040fe200078e0250ULL, 0x0000004354587220ULL, 0x004fe20000410000ULL,
0x0000000133527824ULL, 0x040fe200078e0252ULL, 0x0000000048487984ULL, 0x000ea20000000800ULL,
0x0000000133347824ULL, 0x040fe200078e0234ULL, 0x0000002d582d7221ULL, 0x000fe20000010000ULL,
0x0000000133367824ULL, 0x000fe200078e0236ULL, 0x000000004a4a7984ULL, 0x000ea20000000800ULL,
0x000000ffff327224ULL, 0x000fc600078e0030ULL, 0x000000004c4c7984ULL, 0x000ea40000000800ULL,
0x0000030032007a0cULL, 0x000fe40003f06070ULL, 0x0000000038387984ULL, 0x000ea80000000800ULL,
0x000000003a3a7984ULL, 0x000ea80000000800ULL, 0x000000003c3c7984ULL, 0x000ea20000000800ULL,
0x2000003eff397230ULL, 0x002fc40000004100ULL, 0x3000003eff3e7230ULL, 0x000fe20000004100ULL,
0x000000004e4e7984ULL, 0x000e620000000800ULL, 0x20000040ff3b7230ULL, 0x108fe40000004100ULL,
0x30000040ff407230ULL, 0x000fe20000004100ULL, 0x0000000050507984ULL, 0x000ee20000000800ULL,
0x20000042ff3d7230ULL, 0x110fe40000004100ULL, 0x30000042ff427230ULL, 0x000fe20000004100ULL,
0x0000000052527984ULL, 0x000f220000000800ULL, 0x20000044ff3f7230ULL, 0x020fc40000004100ULL,
0x30000044ff447230ULL, 0x000fe20000004100ULL, 0x0000000034347984ULL, 0x000f620000000800ULL,
0x20000046ff417230ULL, 0x100fe40000004100ULL, 0x30000046ff467230ULL, 0x000fe20000004100ULL,
0x0000000036367984ULL, 0x000f620000000800ULL, 0x20000048ff437230ULL, 0x104fe40000004100ULL,
0x30000048ff487230ULL, 0x000fe40000004100ULL, 0x2000004aff457230ULL, 0x000fc40000004100ULL,
0x3000004aff4a7230ULL, 0x000fe40000004100ULL, 0x2000004cff477230ULL, 0x100fe40000004100ULL,
0x3000004cff4c7230ULL, 0x000fe40000004100ULL, 0x20000038ff4d7230ULL, 0x100fe40000004100ULL,
0x30000038ff387230ULL, 0x000fe40000004100ULL, 0x2000003aff4f7230ULL, 0x000fc40000004100ULL,
0x3000003aff3a7230ULL, 0x000fe40000004100ULL, 0x2000003cff517230ULL, 0x100fe40000004100ULL,
0x3000003cff3c7230ULL, 0x000fe40000004100ULL, 0x2000004eff537230ULL, 0x102fe40000004100ULL,
0x3000004eff4e7230ULL, 0x000fe40000004100ULL, 0x20000050ff557230ULL, 0x008fc40000004100ULL,
0x30000050ff507230ULL, 0x000fe40000004100ULL, 0x20000052ff577230ULL, 0x110fe40000004100ULL,
0x30000052ff527230ULL, 0x000fe40000004100ULL, 0x20000034ff497230ULL, 0x120fe40000004100ULL,
0x30000034ff547230ULL, 0x000fe40000004100ULL, 0x20000036ff4b7230ULL, 0x000fc40000004100ULL,
0x30000036ff567230ULL, 0x000fe20000004100ULL, 0x000051c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2f582f7589ULL, 0x0002a400000e0000ULL, 0x000052227f007947ULL, 0x000fea000b800000ULL,
0x00001f2e582e7589ULL, 0x00072400000e0000ULL, 0x0000002f392c7223ULL, 0x084fe2000001002cULL,
0x0000002f3e2b7223ULL, 0x080fe2000001002bULL, 0x0000002f3b287223ULL, 0x080fe20000010028ULL,
0x0000002f40277223ULL, 0x080fe20000010027ULL, 0x0000002f3d247223ULL, 0x080fe20000010024ULL,
0x0000002f42237223ULL, 0x080fe20000010023ULL, 0x0000002f3f207223ULL, 0x080fe20000010020ULL,
0x0000002f441f7223ULL, 0x080fe2000001001fULL, 0x0000002f411c7223ULL, 0x080fe2000001001cULL,
0x0000002f461b7223ULL, 0x080fe2000001001bULL, 0x0000002f43187223ULL, 0x080fe20000010018ULL,
0x0000002f48177223ULL, 0x080fe20000010017ULL, 0x0000002f45147223ULL, 0x080fe20000010014ULL,
0x0000002f4a137223ULL, 0x080fe20000010013ULL, 0x0000002f47107223ULL, 0x080fe20000010010ULL,
0x0000002f4c0f7223ULL, 0x000fe2000001000fULL, 0x0000002e492a7223ULL, 0x090fe2000001002aULL,
0x0000002e54297223ULL, 0x080fe20000010029ULL, 0x0000002e4b267223ULL, 0x080fe20000010026ULL,
0x0000002e56257223ULL, 0x080fe20000010025ULL, 0x0000002e4d227223ULL, 0x080fe20000010022ULL,
0x0000002e38217223ULL, 0x080fe20000010021ULL, 0x0000002e4f1e7223ULL, 0x080fe2000001001eULL,
0x0000002e3a1d7223ULL, 0x080fe2000001001dULL, 0x0000002e511a7223ULL, 0x080fe2000001001aULL,
0x0000002e3c197223ULL, 0x080fe20000010019ULL, 0x0000002e53167223ULL, 0x080fe20000010016ULL,
0x0000002e4e157223ULL, 0x080fe20000010015ULL, 0x0000002e55127223ULL, 0x080fe20000010012ULL,
0x0000002e50117223ULL, 0x080fe20000010011ULL, 0x0000002e570e7223ULL, 0x080fe2000001000eULL,
0x0000002e520d7223ULL, 0x000fe2000001000dULL, 0xfffff24000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x004ea20000000000ULL,
0x000000ff0900720cULL, 0x000fe20003f05270ULL, 0x0000001000037824ULL, 0x004fe200078e00ffULL,
0x00000001ff007819ULL, 0x000fc80000011600ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c00007812ULL, 0x000fca00078ec0ffULL, 0x0000000100047824ULL, 0x000fe200078e0203ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x0000001000037824ULL, 0x004fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fc80000011600ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c00077812ULL, 0x000fc600078ec0ffULL,
0x000000800a007824ULL, 0x000fc800078e0203ULL, 0x0000000107007824ULL, 0x000fca00078e0200ULL,
0x0049802d00007388ULL, 0x0005e40000000800ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0049800004007984ULL, 0x004ea80000000800ULL, 0x004a000004037984ULL, 0x000f220000000800ULL,
0x00000000ff007221ULL, 0x004fc80000010000ULL, 0x0000000300007221ULL, 0x010fca0000010000ULL,
0x0180000000037810ULL, 0x000fc80007ffe0ffULL, 0x7f80000003037812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x000fe200078e0000ULL,
0x0000924000067802ULL, 0x000fe40000000f00ULL, 0x000052c000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff037224ULL, 0x00cfe200078e0000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000000037308ULL, 0x000ea40000001000ULL, 0xbf80000000047423ULL, 0x004fc80000000003ULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x0000000403037223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff087819ULL, 0x004fe40000011600ULL,
0x0000000800437811ULL, 0x000fc600078ff0ffULL, 0x00001f0803047589ULL, 0x002e6200000e0000ULL,
0x00000043ff457212ULL, 0x000fe200078e33ffULL, 0x00000008430c7824ULL, 0x000fe400078e00ffULL,
0x00001f4303067589ULL, 0x00052600000e0000ULL, 0xfffffff80c457812ULL, 0x000fca00078ee245ULL,
0x0000001045457824ULL, 0x000fe200078e0202ULL, 0x00000008ff037212ULL, 0x004fe200078e33ffULL,
0x0000002c042c7220ULL, 0x042fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000001804187220ULL, 0x040fe20000410000ULL, 0x0000001704177220ULL, 0x040fe20000410000ULL,
0x0000001404147220ULL, 0x040fe20000410000ULL, 0x0000001304137220ULL, 0x040fe20000410000ULL,
0x0000001004107220ULL, 0x040fe20000410000ULL, 0x0000000f040f7220ULL, 0x000fe20000410000ULL,
0x0000000808047824ULL, 0x000fe200078e00ffULL, 0x0000002a062a7220ULL, 0x050fe20000410000ULL,
0x0000002906297220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0x0000002506257220ULL, 0x000fe20000410000ULL, 0xfffffff804477812ULL, 0x000fe200078ee203ULL,
0x0000002206227220ULL, 0x000fe20000410000ULL, 0x0000000708047812ULL, 0x000fe200078ec0ffULL,
0x0000002106217220ULL, 0x040fe20000410000ULL, 0x0000001e061e7220ULL, 0x040fe20000410000ULL,
0x0000001d061d7220ULL, 0x040fe20000410000ULL, 0x0000001a061a7220ULL, 0x040fe20000410000ULL,
0x0000001906197220ULL, 0x040fe20000410000ULL, 0x0000001606167220ULL, 0x040fe20000410000ULL,
0x0000001506157220ULL, 0x040fe20000410000ULL, 0x0000001206127220ULL, 0x040fe20000410000ULL,
0x0000001106117220ULL, 0x040fe20000410000ULL, 0x0000000e060e7220ULL, 0x040fe20000410000ULL,
0x0000000d060d7220ULL, 0x000fe20000410000ULL, 0x0000000808037824ULL, 0x000fe200078e00ffULL,
0x0000000104077812ULL, 0x040fe200078e3cffULL, 0x0000000843067824ULL, 0x000fe200078e00ffULL,
0x00000002042d7812ULL, 0x000fc400078e3cffULL, 0x00000003042f7812ULL, 0x000fe200078e3cffULL,
0x0000000808077824ULL, 0x000fe200078e0207ULL, 0x0000000404317812ULL, 0x000fe200078e3cffULL,
0x00000008082d7824ULL, 0x000fe200078e022dULL, 0x0000000504337812ULL, 0x000fe200078e3cffULL,
0x00000008082f7824ULL, 0x000fe200078e022fULL, 0x0000000604357812ULL, 0x000fe200078e3cffULL,
0x0000000808317824ULL, 0x040fe200078e0231ULL, 0x000000100f0f723eULL, 0x000fe200000000ffULL,
0x0000000808337824ULL, 0x040fe200078e0233ULL, 0x0000000743107812ULL, 0x000fe200078ec0ffULL,
0x0000000808357824ULL, 0x000fe200078e0235ULL, 0x000000121111723eULL, 0x000fe200000000ffULL,
0x0000000400127824ULL, 0x000fe200078e00ffULL, 0x0000000e0d0d723eULL, 0x000fe200000000ffULL,
0x0000001007077824ULL, 0x000fe200078e0202ULL, 0xfffffff803037812ULL, 0x000fe200078ee208ULL,
0x000000102d2d7824ULL, 0x100fe200078e0202ULL, 0xfffffff806377812ULL, 0x000fe200078ee243ULL,
0x000000102f2f7824ULL, 0x100fe200078e0202ULL, 0x0000000110047812ULL, 0x040fe200078e3cffULL,
0x0000001003037824ULL, 0x100fe200078e0202ULL, 0x0000000210067812ULL, 0x040fe200078e3cffULL,
0x0000001037377824ULL, 0x000fe200078e0202ULL, 0x0000000310087812ULL, 0x040fe200078e3cffULL,
0x0000000843397824ULL, 0x040fe200078e0204ULL, 0x00000004100c7812ULL, 0x040fe200078e3cffULL,
0x00000008433b7824ULL, 0x040fe200078e0206ULL, 0x00000005100e7812ULL, 0x040fe200078e3cffULL,
0x00000008433d7824ULL, 0x040fe200078e0208ULL, 0x0000000610107812ULL, 0x000fe200078e3cffULL,
0x00000008433f7824ULL, 0x000fe200078e020cULL, 0x0000001e1d1d723eULL, 0x000fe200000000ffULL,
0x0000000843417824ULL, 0x040fe200078e020eULL, 0x0000000c121e7812ULL, 0x000fe200078ec0ffULL,
0x0000000843437824ULL, 0x000fe200078e0210ULL, 0x0000002c2b2b723eULL, 0x000fe200000000ffULL,
0x0000001047067824ULL, 0x100fe200078e0202ULL, 0x000000282727723eULL, 0x000fe200000000ffULL,
0x000000011e047824ULL, 0x040fe200078e0203ULL, 0x000000242323723eULL, 0x000fe200000000ffULL,
0x0000001031317824ULL, 0x100fe200078e0202ULL, 0x000000201f1f723eULL, 0x000fe200000000ffULL,
0x0000001033337824ULL, 0x100fe200078e0202ULL, 0x0000001c1b1b723eULL, 0x000fe200000000ffULL,
0x0000001035357824ULL, 0x100fe200078e0202ULL, 0x000000181717723eULL, 0x000fe200000000ffULL,
0x0000001039397824ULL, 0x100fe200078e0202ULL, 0x0000002b04007388ULL, 0x0003e20000000800ULL,
0x000000103b3b7824ULL, 0x100fe200078e0202ULL, 0x000000141313723eULL, 0x000fe200000000ffULL,
0x000000103d3d7824ULL, 0x100fe200078e0202ULL, 0x0000002a2929723eULL, 0x000fe200000000ffULL,
0x000000103f3f7824ULL, 0x100fe200078e0202ULL, 0x000000161515723eULL, 0x000fe200000000ffULL,
0x0000001041417824ULL, 0x100fe200078e0202ULL, 0x000000262525723eULL, 0x000fe200000000ffULL,
0x0000001043437824ULL, 0x000fe200078e0202ULL, 0x000000222121723eULL, 0x000fe200000000ffULL,
0x000000011e127824ULL, 0x040fe200078e0206ULL, 0x0000001a1919723eULL, 0x000fe200000000ffULL,
0x000000011e027824ULL, 0x000fc400078e0207ULL, 0x000000011e067824ULL, 0x040fe400078e022dULL,
0x000000011e087824ULL, 0x040fe200078e022fULL, 0x0000002702007388ULL, 0x000fe20000000800ULL,
0x000000011e0c7824ULL, 0x040fe400078e0231ULL, 0x000000011e0e7824ULL, 0x040fe200078e0233ULL,
0x0000002306007388ULL, 0x000fe20000000800ULL, 0x000000011e107824ULL, 0x040fe400078e0235ULL,
0x000000011e147824ULL, 0x040fe200078e0237ULL, 0x0000001f08007388ULL, 0x000fe20000000800ULL,
0x000000011e167824ULL, 0x000fc400078e0239ULL, 0x000000011e047824ULL, 0x042fe200078e023bULL,
0x0000001b0c007388ULL, 0x000fe20000000800ULL, 0x000000011e187824ULL, 0x040fe400078e023dULL,
0x000000011e1a7824ULL, 0x040fe200078e023fULL, 0x000000170e007388ULL, 0x000fe20000000800ULL,
0x000000011e207824ULL, 0x040fe400078e0245ULL, 0x000000011e1c7824ULL, 0x040fe200078e0241ULL,
0x0000001310007388ULL, 0x000fe20000000800ULL, 0x000000011e1e7824ULL, 0x000fc400078e0243ULL,
0x000000010b227824ULL, 0x000fe200078e0200ULL, 0x0000000f12007388ULL, 0x000fe60000000800ULL,
0x0000001022227824ULL, 0x000fe200078e0205ULL, 0x0000002914007388ULL, 0x000fe80000000800ULL,
0x0000002516007388ULL, 0x000fe80000000800ULL, 0x0000002104007388ULL, 0x000fe80000000800ULL,
0x0000001d18007388ULL, 0x000fe80000000800ULL, 0x000000191a007388ULL, 0x000fe80000000800ULL,
0x000000151c007388ULL, 0x000fe80000000800ULL, 0x000000111e007388ULL, 0x000fe80000000800ULL,
0x0000000d20007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000022287984ULL, 0x000e680000000c00ULL, 0x00040000222c7984ULL, 0x000ea80000000c00ULL,
0x0008000022247984ULL, 0x000f280000000c00ULL, 0x000c000022307984ULL, 0x000f620000000c00ULL,
0x200000ff2b2b7230ULL, 0x002fc40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fe40000000000ULL,
0x200000ff29297230ULL, 0x000fe40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x200000ff2f2f7230ULL, 0x004fe40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fc40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x000000272b2b7230ULL, 0x010fe40000000000ULL, 0x000000262a2a7230ULL, 0x000fe40000000000ULL,
0x0000002529297230ULL, 0x000fe40000000000ULL, 0x0000002428287230ULL, 0x000fe40000000000ULL,
0x000000332f2f7230ULL, 0x020fc40000000000ULL, 0x000000322e2e7230ULL, 0x000fe20000000000ULL,
0x0000002822007388ULL, 0x0003e20000000c00ULL, 0x000000312d2d7230ULL, 0x000fe40000000000ULL,
0x000000302c2c7230ULL, 0x000fca0000000000ULL, 0x0004002c22007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000197919ULL, 0x000f220000002600ULL,
0x00000020001d7810ULL, 0x042fe20007ffe0ffULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0x00000040001f7810ULL, 0x040fe20007ffe0ffULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x0000006000217810ULL, 0x000fe20007ffe0ffULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x00000003ff037819ULL, 0x000fe20000011600ULL, 0x00000008091b7824ULL, 0x040fe200078e00ffULL,
0x00000003ff0a7819ULL, 0x000fe2000001161dULL, 0x00000008091c7824ULL, 0x040fe200078e00ffULL,
0x00000003ff0b7819ULL, 0x000fe2000001161fULL, 0x00000008091a7824ULL, 0x040fe200078e00ffULL,
0x00000003ff187819ULL, 0x000fe20000011621ULL, 0x00000008091e7824ULL, 0x000fe200078e00ffULL,
0x000000070a047812ULL, 0x000fc400078e481dULL, 0x000000070b067812ULL, 0x000fe400078e481fULL,
0x0000000718077812ULL, 0x000fe400078e4821ULL, 0x0ffffff804047812ULL, 0x000fe400078ef81dULL,
0x0ffffff806067812ULL, 0x000fe200078ef81fULL, 0x0000001019087824ULL, 0x010fe200078e00ffULL,
0x0ffffff8070e7812ULL, 0x000fe200078ef821ULL, 0x00000010040c7824ULL, 0x100fe200078e0205ULL,
0x00000004050472a4ULL, 0x002fe2000f8e023fULL, 0x0000001006107824ULL, 0x004fe200078e0205ULL,
0xfffffff008087812ULL, 0x000fe200078ee203ULL, 0x000000100e147824ULL, 0x100fe200078e0205ULL,
0x0000000703037812ULL, 0x100fe200078e4800ULL, 0x000000000c0c7984ULL, 0x000fe20000000c00ULL,
0x0000000408087c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001019237824ULL, 0x000fe200078e00ffULL,
0x0ffffff803027812ULL, 0x100fe200078ef800ULL, 0x0000000010107984ULL, 0x000fe20000000c00ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL, 0x0000001019007824ULL, 0x000fe200078e00ffULL,
0xfffffff0230a7812ULL, 0x000fe200078ee20aULL, 0x0000001002027824ULL, 0x000fe200078e0205ULL,
0x0000000014147984ULL, 0x000fe20000000c00ULL, 0x0000001019197824ULL, 0x000fe200078e00ffULL,
0xfffffff0000b7812ULL, 0x000fe200078ee20bULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x0000000002047984ULL, 0x0002a20000000c00ULL, 0xfffffff81c1f7812ULL, 0x000fc400078ee21fULL,
0xfffffff019187812ULL, 0x000fe400078ee218ULL, 0x000000040b0b7c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000418007c10ULL, 0x000fe4000ff5e0ffULL, 0x00005a0008027a11ULL, 0x002fe400078040ffULL,
0xfffffff81a1d7812ULL, 0x000fe200078ee21dULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x00005b0008037a11ULL, 0x000fe200000f4403ULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x000000040a1c7c10ULL, 0x000fc4000ff1e0ffULL, 0x00005a000b0a7a11ULL, 0x000fe200078240ffULL,
0x000000101b027825ULL, 0x000fe200078e0002ULL, 0x00005a0000187a11ULL, 0x000fe400078440ffULL,
0x00005b000b0b7a11ULL, 0x000fe200008f441aULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005a001c087a11ULL, 0x000fe400078040ffULL, 0xfffffff81e217812ULL, 0x000fe200078ee221ULL,
0x000000101f0a7825ULL, 0x000fe200078e000aULL, 0x00005b001c097a11ULL, 0x000fc400000f4409ULL,
0x00005b0000197a11ULL, 0x000fc600010f4419ULL, 0x000000101d087825ULL, 0x000fc800078e0008ULL,
0x0000001021187825ULL, 0x000fe200078e0018ULL, 0x0000000402007986ULL, 0x004fe8000c101d08ULL,
0x0000000c08007986ULL, 0x000fe8000c101d08ULL, 0x000000100a007986ULL, 0x000fe8000c101d08ULL,
0x0000001418007986ULL, 0x000fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006800ff067624ULL, 0x000fe200078e00ffULL, 0x03ffffff48047812ULL, 0x000fe200078ec0ffULL,
0x00006900ff077624ULL, 0x000fc400078e00ffULL, 0xffffffffff167424ULL, 0x000fe400078e00ffULL,
0x0000000449397824ULL, 0x000fe200078e0204ULL, 0x0000000806387981ULL, 0x000368000c1e9900ULL,
0x000000003900720cULL, 0x000fe40003f06070ULL, 0x0000000149037810ULL, 0x000fd60007ffe0ffULL,
0x0000000240048824ULL, 0x000fc800078e00ffULL, 0x0000640004048a24ULL, 0x000fc800078e0239ULL,
0x0000600004048625ULL, 0x000fca00078e0011ULL, 0x0000000804168981ULL, 0x000362000c1e1900ULL,
0x000000020300720cULL, 0x000fe20003f06070ULL, 0x000000401d157824ULL, 0x000fe400078e00ffULL,
0x000000401e127824ULL, 0x000fe400078e00ffULL, 0x0000004048147824ULL, 0x000fd000078e00ffULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x002e620000000000ULL,
0x0000001612127224ULL, 0x020fe200078e0215ULL, 0x0000100048197811ULL, 0x000fe200078e68ffULL,
0x00000080ff207424ULL, 0x000fe400078e00ffULL, 0x0000010049087824ULL, 0x000fe200078e0214ULL,
0x00000002ff1c7819ULL, 0x102fe20000011610ULL, 0x00000010101d7824ULL, 0x000fe200078e00ffULL,
0x00000003ff137819ULL, 0x000fe40000011610ULL, 0x0000003f1c037812ULL, 0x000fc400078ec0ffULL,
0x000000081c1a7810ULL, 0x000fe40007ffe0ffULL, 0x000000301d1d7812ULL, 0x000fe200078ec0ffULL,
0x0000000112037824ULL, 0x000fe200078e0203ULL, 0x0000003f1a077812ULL, 0x000fe400078ec0ffULL,
0x000000101c1e7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0003047625ULL, 0x000fe200078e0020ULL,
0x0000000817037217ULL, 0x000fe40007800000ULL, 0x0000003f1e097812ULL, 0x000fe200078ec0ffULL,
0x0000000112077824ULL, 0x000fe200078e0207ULL, 0x0000001d040a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000103037824ULL, 0x000fe200078e0a08ULL, 0x000000181c227810ULL, 0x040fe20007ffe0ffULL,
0x00005e0007067625ULL, 0x000fe200078e0020ULL, 0x000000201c187810ULL, 0x000fc40007ffe0ffULL,
0x0000000313137812ULL, 0x000fe200078e4810ULL, 0x000000ffff0b7224ULL, 0x000fe200000e0605ULL,
0x0000001d060c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000112097824ULL, 0x000fe200078e0209ULL,
0x0000003f22057812ULL, 0x000fe400078ec0ffULL, 0x000000031e00720cULL, 0x080fe20003fa6070ULL,
0x00005e0009087625ULL, 0x000fe200078e0020ULL, 0x000000032200720cULL, 0x000fc60003f86070ULL,
0x000000ffff0d7224ULL, 0x000fe200000e0607ULL, 0x0000003f18077812ULL, 0x000fe200078ec0ffULL,
0x0000000112057824ULL, 0x000fe200078e0205ULL, 0x0000001d08087210ULL, 0x000fe40007f3e0ffULL,
0x000000031c00720cULL, 0x000fe20003f06070ULL, 0x0000000112077824ULL, 0x000fe400078e0207ULL,
0x00005e0005047625ULL, 0x000fc800078e0020ULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x000000031a00720cULL, 0x000fe20003f26070ULL, 0x00005e0007067625ULL, 0x000fe200078e0020ULL,
0x0000001d040e7210ULL, 0x080fe40007f5e0ffULL, 0x0ffffffc13047812ULL, 0x000fe200078ef810ULL,
0x000000041a1a7824ULL, 0x000fe200078e00ffULL, 0x0000001d06107210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0f7224ULL, 0x000fe400010e0605ULL, 0x00000010041b7824ULL, 0x000fe200078e0219ULL,
0xfffffffc1a067812ULL, 0x000fe200078ee213ULL, 0x000000ffff117224ULL, 0x000fe200018e0607ULL,
0x000000281c1a7810ULL, 0x000fc40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a1b7faeULL, 0x0003e2000c101c48ULL, 0x0000001006077824ULL, 0x000fe200078e0219ULL,
0x0000003f1a057812ULL, 0x000fe400078ec0ffULL, 0x000000301c067810ULL, 0x040fe40007ffe0ffULL,
0x000000381c1c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000112057824ULL, 0x000fe200078e0205ULL,
0x000000000c077faeULL, 0x0005e2000c901c48ULL, 0x000000030600720cULL, 0x040fe40003f26070ULL,
0x00005e0005047625ULL, 0x000fe200078e0020ULL, 0x0000003f060b7812ULL, 0x002fc400078ec0ffULL,
0x000000031800720cULL, 0x000fe20003f66070ULL, 0x0000000406067824ULL, 0x000fe200078e00ffULL,
0x0000001d040a7210ULL, 0x000fe20007fde0ffULL, 0x0000000112047824ULL, 0x000fe200078e020bULL,
0x000000031a00720cULL, 0x080fe20003f46070ULL, 0x0000000418187824ULL, 0x000fe200078e00ffULL,
0x0000003f1c077812ULL, 0x044fe200078ec0ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e0605ULL,
0x000000031c00720cULL, 0x000fe20003f06070ULL, 0x00005e0004047625ULL, 0x000fe200078e0020ULL,
0xfffffffc18187812ULL, 0x000fc600078ee213ULL, 0x0000000112077824ULL, 0x000fe200078e0207ULL,
0x0000001d04047210ULL, 0x000fe20007fde0ffULL, 0x000000041e0c7824ULL, 0x000fe400078e00ffULL,
0x0000000422127824ULL, 0x000fe400078e00ffULL, 0x000000041a1a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0c0c7812ULL, 0x100fe200078ee213ULL, 0x000000041c1e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc061c7812ULL, 0x100fe200078ee213ULL, 0x00005e0007067625ULL, 0x000fe200078e0020ULL,
0xfffffffc12127812ULL, 0x000fc400078ee213ULL, 0xfffffffc1a1a7812ULL, 0x000fe200078ee213ULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0xfffffffc1e1e7812ULL, 0x000fe200078ee213ULL,
0x000000100c037824ULL, 0x100fe200078e0219ULL, 0x0000001d06067210ULL, 0x000fe20007fde0ffULL,
0x00000010120d7824ULL, 0x100fe400078e0219ULL, 0x0000001018137824ULL, 0x100fe200078e0219ULL,
0x0000000008037faeULL, 0x0003e2000e901c48ULL, 0x000000101a1b7824ULL, 0x100fe400078e0219ULL,
0x000000101c1d7824ULL, 0x100fe200078e0219ULL, 0x000000000e0d7faeULL, 0x0003e2000e101c48ULL,
0x000000101e197824ULL, 0x000fc400078e0219ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000000010137faeULL, 0x0003e8000d901c48ULL, 0x000000000a1b7faeULL, 0x0003e8000d101c48ULL,
0x00000000041d7faeULL, 0x0003e8000c901c48ULL, 0x0000000006197faeULL, 0x0003e2000c101c48ULL,
0x000005a000007947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x0000001612127224ULL, 0x020fe200078e0215ULL, 0x00001000480a7811ULL, 0x000fc400078e68ffULL,
0x00000002ff047819ULL, 0x102fe40000011603ULL, 0x00000003ff067819ULL, 0x000fe40000011603ULL,
0x0000000804087810ULL, 0x040fe40007ffe0ffULL, 0x00000018040c7810ULL, 0x040fe40007ffe0ffULL,
0x00000020040e7810ULL, 0x040fe40007ffe0ffULL, 0x00000010040b7810ULL, 0x000fc40007ffe0ffULL,
0x0000002804107810ULL, 0x000fe20007ffe0ffULL, 0x000000040e237824ULL, 0x000fe200078e00ffULL,
0x0000003004187810ULL, 0x040fe40007ffe0ffULL, 0x00000038041a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000410277824ULL, 0x000fe200078e00ffULL, 0x0000003f08077812ULL, 0x000fe200078ec0ffULL,
0x00000004182b7824ULL, 0x000fe200078e00ffULL, 0x0000000306067812ULL, 0x000fe200078e4803ULL,
0x000000041a2f7824ULL, 0x000fe200078e00ffULL, 0x0000003f0c0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000112097824ULL, 0x000fe200078e0207ULL, 0x0000003f0e137812ULL, 0x000fc400078ec0ffULL,
0x0000003f04057812ULL, 0x000fe200078ec0ffULL, 0x0000001003047824ULL, 0x000fe200078e00ffULL,
0x0000003f0b0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000112117824ULL, 0x000fe200078e020fULL,
0x0000003f10197812ULL, 0x000fe200078ec0ffULL, 0x0000000112217824ULL, 0x000fe200078e0213ULL,
0x0000003f181b7812ULL, 0x000fe200078ec0ffULL, 0x0000000112057824ULL, 0x000fe200078e0205ULL,
0x0000003f1a1d7812ULL, 0x000fe200078ec0ffULL, 0x00000001120d7824ULL, 0x000fe200078e020dULL,
0x0ffffffc06077812ULL, 0x000fe200078ef803ULL, 0x0000000408037824ULL, 0x000fe200078e00ffULL,
0xfffffffc23237812ULL, 0x100fe200078ee206ULL, 0x0000000112257824ULL, 0x040fe200078e0219ULL,
0xfffffffc27277812ULL, 0x100fe200078ee206ULL, 0x0000000112297824ULL, 0x040fe200078e021bULL,
0xfffffffc2b2b7812ULL, 0x100fe200078ee206ULL, 0x00000001122d7824ULL, 0x000fe200078e021dULL,
0xfffffffc2f2f7812ULL, 0x100fe200078ee206ULL, 0x000000040b0f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc030b7812ULL, 0x100fe200078ee206ULL, 0x000000040c137824ULL, 0x000fe200078e00ffULL,
0x0000003004037812ULL, 0x000fe200078ec0ffULL, 0x00000080ff127424ULL, 0x000fe200078e00ffULL,
0xfffffffc0f0f7812ULL, 0x000fe200078ee206ULL, 0x0000001007197824ULL, 0x000fe200078e020aULL,
0xfffffffc13137812ULL, 0x000fe200078ee206ULL, 0x00005e0005047625ULL, 0x000fc800078e0012ULL,
0x000000100b1b7824ULL, 0x100fe200078e020aULL, 0x0000000304047210ULL, 0x000fe20007f1e0ffULL,
0x000000100f1d7824ULL, 0x100fe400078e020aULL, 0x00000010131f7824ULL, 0x100fe400078e020aULL,
0x0000001023237824ULL, 0x100fe400078e020aULL, 0x0000001027277824ULL, 0x100fe400078e020aULL,
0x000000102b2b7824ULL, 0x000fc400078e020aULL, 0x000000102f2f7824ULL, 0x000fe400078e020aULL,
0x00005e00110a7625ULL, 0x000fc800078e0012ULL, 0x00005e0009067625ULL, 0x000fc800078e0012ULL,
0x00005e000d087625ULL, 0x000fe200078e0012ULL, 0x0000000306067210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x000000030a0a7210ULL, 0x080fe20007f1e0ffULL,
0x00005e00210c7625ULL, 0x080fe200078e0012ULL, 0x0000000308087210ULL, 0x000fe40007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004197faeULL, 0x0003e2000b901c48ULL,
0x00005e00250e7625ULL, 0x000fc800078e0012ULL, 0x00005e0029107625ULL, 0x000fc800078e0012ULL,
0x00005e002d127625ULL, 0x000fc800078e0012ULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x000000030c0c7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x000000030e0e7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000000310107210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000000312127210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x00000000061b7faeULL, 0x0003e2000b901c48ULL, 0x000000ffff117224ULL, 0x000fc400010e0611ULL,
0x000000ffff137224ULL, 0x000fe200018e0613ULL, 0x00000000081d7faeULL, 0x0003e8000b901c48ULL,
0x000000000a1f7faeULL, 0x0003e8000b901c48ULL, 0x000000000c237faeULL, 0x0003e8000b901c48ULL,
0x000000000e277faeULL, 0x0003e8000b901c48ULL, 0x00000000102b7faeULL, 0x0003e8000b901c48ULL,
0x00000000122f7faeULL, 0x0003e4000b901c48ULL, 0x00f60400ff037984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000003ff7812ULL, 0x002fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff037424ULL, 0x000fc800078e00ffULL, 0x0000000300047305ULL, 0x0002a4000021f000ULL,
0x3fa0000003037823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x00f60400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000034800780cULL, 0x000fda0003f04070ULL, 0x0000017000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000002048037824ULL, 0x002fc800078e0203ULL,
0x0000001003057824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011603ULL,
0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL, 0x000000f005057812ULL, 0x000fe400078ec0ffULL,
0x0000000104067812ULL, 0x040fe400078efcffULL, 0x0000000704047812ULL, 0x100fe400078e7803ULL,
0x0000000706067812ULL, 0x000fc600078e7803ULL, 0x0000000104047824ULL, 0x000fe400078e0205ULL,
0x0000000105067824ULL, 0x000fc600078e0206ULL, 0x00000000040c7984ULL, 0x000e68000000cc00ULL,
0x0000000006087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001004007388ULL, 0x0003e8000000cc00ULL,
0x0000000c06007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ffff7f8cULL, 0x000fe8000c80043fULL, 0x00f60400ff037984ULL, 0x000ea40000000800ULL,
0x8000000003ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff037424ULL, 0x000fc800078e00ffULL,
0x0000000300047305ULL, 0x0022a4000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x00f60400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000024900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000003a7919ULL, 0x000ea20000000000ULL,
0x3db504f338387820ULL, 0x000fe20000410000ULL, 0x0000640040407a24ULL, 0x000fe200078e02ffULL,
0xffffffff023c7810ULL, 0x000fe20007ffe0ffULL, 0x00000010483e7824ULL, 0x000fe200078e00ffULL,
0x00007610ff3b7816ULL, 0x000fe2000000003bULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x0000000604047899ULL, 0x000fe4000800063fULL,
0x0000010049427824ULL, 0x000fe200078e0214ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000421700720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x028fea0003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e003dULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000000ffff037224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x002fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fc4000001ff00ULL,
0x0000000103267810ULL, 0x000fe20007ffe0ffULL, 0x00000bb000007945ULL, 0x000fe20003800000ULL,
0x00000001253d7812ULL, 0x000fc400078e0cffULL, 0x00000001ff247819ULL, 0x100fe40000011626ULL,
0x000000022600780cULL, 0x040fe40003f06070ULL, 0x00000001264c7812ULL, 0x000fe200078ec0ffULL,
0x0000030024297a24ULL, 0x000fe400078e0249ULL, 0x000000ffff247224ULL, 0x000fe400078e0003ULL,
0x000000ffff037224ULL, 0x000fe200078e0026ULL, 0x0000000129277810ULL, 0x000fc80007ffe0ffULL,
0x000000022700720cULL, 0x000fda0003f26070ULL, 0x000005e000009947ULL, 0x020fea0003800000ULL,
0x0000010029267824ULL, 0x000fe200078e0214ULL, 0x00000002ff357819ULL, 0x004fe2000001163aULL,
0x0000000416307c24ULL, 0x000fe4000f8e0215ULL, 0x000000044c377824ULL, 0x000fe200078e00ffULL,
0x0000002617277217ULL, 0x000fe20007800000ULL, 0x00000002482b7824ULL, 0x000fe200078e023dULL,
0x0000000835317810ULL, 0x040fe20007ffe0ffULL, 0x00000080ff4d7424ULL, 0x000fe200078e00ffULL,
0x0000003f35297812ULL, 0x000fe200078ec0ffULL, 0x00000001272a7824ULL, 0x000fe200078e0a26ULL,
0x00000003ff277819ULL, 0x100fe2000001163aULL, 0x0000000431347824ULL, 0x000fe200078e00ffULL,
0xfffffffc37377812ULL, 0x100fe200078ee23aULL, 0x0000000130267824ULL, 0x000fe200078e0229ULL,
0x00000003273f7812ULL, 0x000fc400078e483aULL, 0x0000003f31277812ULL, 0x000fe400078ec0ffULL,
0x0000002a3500720cULL, 0x080fe40003f26070ULL, 0x0000002a3100720cULL, 0x000fe20003f46070ULL,
0x0000000130287824ULL, 0x000fe200078e0227ULL, 0x000010002b2b7811ULL, 0x000fe200078e60ffULL,
0x00005e0026267625ULL, 0x080fe200078e004dULL, 0x0ffffffc3f327812ULL, 0x000fe400078ef83aULL,
0xfffffffc34347812ULL, 0x000fe200078ee23fULL, 0x00005e0028287625ULL, 0x000fe200078e004dULL,
0x0000001035417810ULL, 0x000fc40007ffe0ffULL, 0x0000001835437810ULL, 0x040fe20007ffe0ffULL,
0x0000001032317824ULL, 0x000fe200078e022bULL, 0x0000002035457810ULL, 0x000fe20007ffe0ffULL,
0x0000001037267825ULL, 0x000fe200078e0026ULL, 0x0000002835477810ULL, 0x040fe40007ffe0ffULL,
0x00000030354b7810ULL, 0x040fe20007ffe0ffULL, 0x0000001034337824ULL, 0x000fe200078e022bULL,
0x00000038354f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001037287825ULL, 0x000fe200078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026317faeULL, 0x0003e2000c901c48ULL,
0x0000003f4b357812ULL, 0x000fc400078ec0ffULL, 0x0000003f4f517812ULL, 0x000fe200078ec0ffULL,
0x0000000028337faeULL, 0x0005e2000d101c48ULL, 0x0000002a4100720cULL, 0x080fe20003f26070ULL,
0x0000000130467824ULL, 0x040fe200078e0235ULL, 0x0000002a4300720cULL, 0x080fe20003f46070ULL,
0x00000001304e7824ULL, 0x040fe200078e0251ULL, 0x0000002a4500720cULL, 0x0c0fe20003f66070ULL,
0x0000000445347824ULL, 0x000fe200078e00ffULL, 0x0000002a4700720cULL, 0x0c0fe20003f86070ULL,
0x0000000447447824ULL, 0x000fe200078e00ffULL, 0x0000003f41277812ULL, 0x002fe200078ec0ffULL,
0x000000044b4a7824ULL, 0x000fe200078e00ffULL, 0x0000003f45317812ULL, 0x000fe200078ec0ffULL,
0x0000000441287824ULL, 0x004fe200078e00ffULL, 0x0000003f43297812ULL, 0x000fe200078ec0ffULL,
0x0000000130267824ULL, 0x040fe200078e0227ULL, 0x0000003f47337812ULL, 0x000fe200078ec0ffULL,
0x0000000130327824ULL, 0x040fe200078e0231ULL, 0x0000002a4b00720cULL, 0x080fe20003fa6070ULL,
0x000000044f507824ULL, 0x040fe200078e00ffULL, 0x0000002a4f00720cULL, 0x000fe20003fc6070ULL,
0x00000001302a7824ULL, 0x000fe200078e0229ULL, 0xfffffffc28287812ULL, 0x000fe200078ee23fULL,
0x0000000130367824ULL, 0x000fe200078e0233ULL, 0xfffffffc34347812ULL, 0x100fe200078ee23fULL,
0x0000000443307824ULL, 0x000fe200078e00ffULL, 0xfffffffc44447812ULL, 0x100fe200078ee23fULL,
0x00005e0026267625ULL, 0x000fe200078e004dULL, 0xfffffffc4a4a7812ULL, 0x000fc400078ee23fULL,
0xfffffffc30307812ULL, 0x000fe200078ee23fULL, 0x0000001034437824ULL, 0x000fe200078e022bULL,
0xfffffffc50507812ULL, 0x000fe200078ee23fULL, 0x00000010283f7824ULL, 0x100fe400078e022bULL,
0x0000001030417824ULL, 0x100fe400078e022bULL, 0x0000001044457824ULL, 0x100fe400078e022bULL,
0x000000104a477824ULL, 0x100fe400078e022bULL, 0x00000010504b7824ULL, 0x000fc400078e022bULL,
0x00005e002a287625ULL, 0x000fc800078e004dULL, 0x00005e00322a7625ULL, 0x000fc800078e004dULL,
0x00005e0036307625ULL, 0x000fc800078e004dULL, 0x00005e0046327625ULL, 0x000fc800078e004dULL,
0x00005e004e347625ULL, 0x000fc800078e004dULL, 0x0000001037267825ULL, 0x000fc800078e0026ULL,
0x0000001037287825ULL, 0x040fe200078e0028ULL, 0x00000000263f7faeULL, 0x0003e6000c901c48ULL,
0x00000010372a7825ULL, 0x040fe200078e002aULL, 0x0000000028417faeULL, 0x0003e6000d101c48ULL,
0x0000001037307825ULL, 0x040fe200078e0030ULL, 0x000000002a437faeULL, 0x0003e6000d901c48ULL,
0x0000001037327825ULL, 0x040fe200078e0032ULL, 0x0000000030457faeULL, 0x0003e6000e101c48ULL,
0x0000001037347825ULL, 0x000fe200078e0034ULL, 0x0000000032477faeULL, 0x0003e8000e901c48ULL,
0x00000000344b7faeULL, 0x0003e2000f101c48ULL, 0x0000052000007947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x004fe2000001163aULL, 0x0000000416277c24ULL, 0x000fc4000f8e0215ULL,
0x000000044c3f7824ULL, 0x000fe200078e00ffULL, 0x0000003f26287812ULL, 0x040fe200078ec0ffULL,
0x00000080ff457424ULL, 0x000fe200078e00ffULL, 0x00000008262a7810ULL, 0x040fe40007ffe0ffULL,
0x0000001026317810ULL, 0x040fe40007ffe0ffULL, 0x0000001826337810ULL, 0x040fe40007ffe0ffULL,
0x0000002026357810ULL, 0x040fe40007ffe0ffULL, 0x0000002826377810ULL, 0x000fc40007ffe0ffULL,
0x0000003026417810ULL, 0x040fe40007ffe0ffULL, 0x0000003826437810ULL, 0x000fe20007ffe0ffULL,
0x0000000127267824ULL, 0x000fe200078e0228ULL, 0x0000003f2a287812ULL, 0x040fe200078ec0ffULL,
0x000000042a2a7824ULL, 0x000fe200078e00ffULL, 0x0000003f31327812ULL, 0x000fe200078ec0ffULL,
0x0000000443587824ULL, 0x000fe200078e00ffULL, 0x0000003f33347812ULL, 0x000fe200078ec0ffULL,
0x0000000127307824ULL, 0x000fe200078e0228ULL, 0x0000003f35447812ULL, 0x000fe200078ec0ffULL,
0x0000000127327824ULL, 0x000fe200078e0232ULL, 0x0000003f374a7812ULL, 0x000fe200078ec0ffULL,
0x0000000127367824ULL, 0x000fe200078e0234ULL, 0x0000003f41507812ULL, 0x000fe200078ec0ffULL,
0x0000000127467824ULL, 0x000fe200078e0244ULL, 0x0000003f43547812ULL, 0x000fe200078ec0ffULL,
0x00000001274e7824ULL, 0x000fe200078e024aULL, 0xfffffffc3f3f7812ULL, 0x000fe200078ee23aULL,
0x0000000127527824ULL, 0x000fc400078e0250ULL, 0x0000000127567824ULL, 0x000fe200078e0254ULL,
0x00000003ff277819ULL, 0x100fe2000001163aULL, 0x0000000248287824ULL, 0x000fe400078e023dULL,
0x0000000431347824ULL, 0x000fe200078e00ffULL, 0x0000000327297812ULL, 0x100fe200078e483aULL,
0x0000000433447824ULL, 0x000fe200078e00ffULL, 0x00001000282b7811ULL, 0x000fe200078e60ffULL,
0x00000004354a7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc29287812ULL, 0x000fe200078ef83aULL,
0x0000000437507824ULL, 0x000fe200078e00ffULL, 0xfffffffc2a2a7812ULL, 0x100fe200078ee229ULL,
0x0000000441547824ULL, 0x000fe200078e00ffULL, 0xfffffffc34347812ULL, 0x100fe200078ee229ULL,
0x00005e0026267625ULL, 0x000fe200078e0045ULL, 0xfffffffc44447812ULL, 0x000fc400078ee229ULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee229ULL, 0x0000001028417824ULL, 0x000fe200078e022bULL,
0xfffffffc50507812ULL, 0x000fe200078ee229ULL, 0x000000102a437824ULL, 0x000fe200078e022bULL,
0xfffffffc54547812ULL, 0x000fe200078ee229ULL, 0x0000001034477824ULL, 0x000fe200078e022bULL,
0xfffffffc58587812ULL, 0x000fe200078ee229ULL, 0x00000010444b7824ULL, 0x100fe400078e022bULL,
0x000000104a4d7824ULL, 0x100fe400078e022bULL, 0x00000010504f7824ULL, 0x000fc400078e022bULL,
0x0000001054517824ULL, 0x100fe400078e022bULL, 0x0000001058537824ULL, 0x000fe400078e022bULL,
0x00005e0030287625ULL, 0x000fc800078e0045ULL, 0x00005e00322a7625ULL, 0x000fc800078e0045ULL,
0x00005e0036307625ULL, 0x000fc800078e0045ULL, 0x00005e0046327625ULL, 0x000fc800078e0045ULL,
0x00005e004e347625ULL, 0x000fc800078e0045ULL, 0x000000103f267825ULL, 0x000fc800078e0026ULL,
0x00005e0052367625ULL, 0x080fe200078e0045ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026417faeULL, 0x0003e6000b901c48ULL, 0x00005e0056447625ULL, 0x000fc800078e0045ULL,
0x000000103f287825ULL, 0x000fc800078e0028ULL, 0x000000103f2a7825ULL, 0x040fe200078e002aULL,
0x0000000028437faeULL, 0x0003e6000b901c48ULL, 0x000000103f307825ULL, 0x040fe200078e0030ULL,
0x000000002a477faeULL, 0x0003e6000b901c48ULL, 0x000000103f327825ULL, 0x040fe200078e0032ULL,
0x00000000304b7faeULL, 0x0003e6000b901c48ULL, 0x000000103f347825ULL, 0x040fe200078e0034ULL,
0x00000000324d7faeULL, 0x0003e6000b901c48ULL, 0x000000103f367825ULL, 0x040fe200078e0036ULL,
0x00000000344f7faeULL, 0x0003e6000b901c48ULL, 0x000000103f447825ULL, 0x000fe200078e0044ULL,
0x0000000036517faeULL, 0x0003e8000b901c48ULL, 0x0000000044537faeULL, 0x0003e4000b901c48ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff4c00720cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000009947ULL, 0x000fea0003800000ULL,
0x00000004ff277424ULL, 0x002fe400078e00ffULL, 0xffffffffff167424ULL, 0x000fe400078e00ffULL,
0x0000030027397a24ULL, 0x000fca00078e0239ULL, 0x000000003900720cULL, 0x000fda0003f26070ULL,
0x0000003000001947ULL, 0x000fea0003800000ULL, 0x0000000240267824ULL, 0x000fc800078e0239ULL,
0x0000600026267625ULL, 0x000fca00078e0027ULL, 0x0000000826167981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000203a277810ULL, 0x002fe20007ffe0ffULL, 0x0000000248457824ULL, 0x000fe200078e0225ULL,
0xfffffff83a417812ULL, 0x000fe200078ec0ffULL, 0x00000008243f7824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ec0ffULL, 0x000000ffff437224ULL, 0x000fe200078e00ffULL,
0x0000000741417812ULL, 0x100fe400078ef83aULL, 0x0000000727467812ULL, 0x000fe400078ef83aULL,
0x000000073a257812ULL, 0x000fc400078ec0ffULL, 0x00000001ff4a7819ULL, 0x000fe40000011641ULL,
0x00000001ff4c7819ULL, 0x000fe40000011646ULL, 0x0000100045457811ULL, 0x000fe400078e60ffULL,
0x0000000825447812ULL, 0x000fe400078ef83aULL, 0x000000034a4a7812ULL, 0x000fe400078ec0ffULL,
0x000000034c4c7812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000434a247212ULL, 0x000fe200078e3cffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000003f3a357211ULL, 0x000fc400078fe0ffULL, 0x000000434c317212ULL, 0x000fe200078e3cffULL,
0x0000000441247824ULL, 0x000fe200078e0224ULL, 0x0000000735257812ULL, 0x100fe400078e7844ULL,
0x0000000143477810ULL, 0x000fe20007ffe0ffULL, 0x0000001024287824ULL, 0x000fe200078e0245ULL,
0x0000000235357810ULL, 0x000fe20007ffe0ffULL, 0x0000001044257824ULL, 0x000fe200078e0225ULL,
0x0000000243437810ULL, 0x000fe20007ffe0ffULL, 0x0000000446307824ULL, 0x000fe200078e0231ULL,
0x0000000735357812ULL, 0x000fe200078e7844ULL, 0x000000002828783bULL, 0x000e620000000200ULL,
0x0000001025257824ULL, 0x000fe200078e00ffULL, 0x000000044300780cULL, 0x000fe20003f25270ULL,
0x0000001030307824ULL, 0x000fe200078e0245ULL, 0x000000043f3f7810ULL, 0x000fc60007ffe0ffULL,
0x000000002524783bULL, 0x000ea80000000200ULL, 0x000000003030783bULL, 0x000ee20000000200ULL,
0x00000028ff36723eULL, 0x082fe400020006ffULL, 0x00000028ff37723eULL, 0x000fe400030006ffULL,
0x00000029ff4e723eULL, 0x080fe400020006ffULL, 0x00000029ff4f723eULL, 0x000fc400030006ffULL,
0x0000002aff28723eULL, 0x080fe200020006ffULL, 0x000000362420723cULL, 0x004fe20000001820ULL,
0x0000002aff29723eULL, 0x000fe400030006ffULL, 0x000000474a2a7212ULL, 0x080fe400078e3cffULL,
0x000000474c477212ULL, 0x000fc600078e3cffULL, 0x000000282418723cULL, 0x040fee0000001818ULL,
0x0000000441287824ULL, 0x000fe200078e022aULL, 0x0000004e241c723cULL, 0x000fe2000000181cULL,
0x0000002bff2a723eULL, 0x080fe400020006ffULL, 0x0000001028347824ULL, 0x000fe200078e0245ULL,
0x0000002bff2b723eULL, 0x000fe200030006ffULL, 0x0000001044287824ULL, 0x000fc400078e0235ULL,
0x00000030ff4e723eULL, 0x088fe400020006ffULL, 0x00000030ff4f723eULL, 0x000fe200030006ffULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0x00000031ff30723eULL, 0x080fe200020006ffULL,
0x0000001028287824ULL, 0x000fe200078e00ffULL, 0x00000031ff31723eULL, 0x000fe200030006ffULL,
0x0000002a242c723cULL, 0x040fe8000000182cULL, 0x000000002828783bULL, 0x000ea80000000200ULL,
0x00000030240c723cULL, 0x040fee000000180cULL, 0x00000032ff30723eULL, 0x080fe200020006ffULL,
0x0000004e2410723cULL, 0x000fe20000001810ULL, 0x00000032ff31723eULL, 0x000fe200030006ffULL,
0x0000000446327824ULL, 0x000fc800078e0247ULL, 0x0000001032327824ULL, 0x000fe200078e0245ULL,
0x00000033ff4e723eULL, 0x080fe200020006ffULL, 0x000000302408723cULL, 0x000fe20000001808ULL,
0x00000033ff4f723eULL, 0x000fc600030006ffULL, 0x000000003230783bULL, 0x000ee80000000200ULL,
0x0000004e2404723cULL, 0x000fee0000001804ULL, 0x00000034ff24723eULL, 0x002fc400020006ffULL,
0x00000034ff25723eULL, 0x000fe400030006ffULL, 0x00000035ff34723eULL, 0x080fe400020006ffULL,
0x00000035ff35723eULL, 0x000fc600030006ffULL, 0x000000242820723cULL, 0x044fee0000001820ULL,
0x00000036ff24723eULL, 0x080fe200020006ffULL, 0x00000034281c723cULL, 0x000fe2000000181cULL,
0x00000036ff25723eULL, 0x000fe400030006ffULL, 0x00000037ff36723eULL, 0x000fc400020006ffULL,
0x00000037ff37723eULL, 0x000fc600030006ffULL, 0x000000242818723cULL, 0x040fee0000001818ULL,
0x00000030ff24723eULL, 0x088fe200020006ffULL, 0x00000036282c723cULL, 0x000fe2000000182cULL,
0x00000030ff25723eULL, 0x000fe400030006ffULL, 0x00000031ff30723eULL, 0x000fc400020006ffULL,
0x00000031ff31723eULL, 0x000fc600030006ffULL, 0x000000242810723cULL, 0x040fee0000001810ULL,
0x00000032ff24723eULL, 0x080fe200020006ffULL, 0x00000030280c723cULL, 0x000fe2000000180cULL,
0x00000032ff25723eULL, 0x000fe400030006ffULL, 0x00000033ff32723eULL, 0x000fc400020006ffULL,
0x00000033ff33723eULL, 0x000fc600030006ffULL, 0x000000242808723cULL, 0x040ff00000001808ULL,
0x000000322804723cULL, 0x000fe20000001804ULL, 0xfffffb0000001947ULL, 0x000fee000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff257224ULL, 0x000fe200078e003dULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffed2000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00f614003e247984ULL, 0x000e620000000800ULL,
0x0000ffff3b037812ULL, 0x000fe200078ec0ffULL, 0x0000001d38297220ULL, 0x040fe20000410000ULL,
0x0000002038207220ULL, 0x040fe20000410000ULL, 0x00000022382a7220ULL, 0x040fe20000410000ULL,
0x0000888003347816ULL, 0x000fe200000000ffULL, 0x0000001c382b7220ULL, 0x040fe20000410000ULL,
0x0000001f381d7220ULL, 0x040fe20000410000ULL, 0x0000002138217220ULL, 0x040fe20000410000ULL,
0x0000001e381c7220ULL, 0x000fe20000410000ULL, 0x8000000034037824ULL, 0x000fe200078e00ffULL,
0x0000001038107220ULL, 0x040fe20000410000ULL, 0x0000000c38227220ULL, 0x040fe20000410000ULL,
0x0000000f380f7220ULL, 0x040fe20000410000ULL, 0x0000000838087220ULL, 0x040fe20000410000ULL,
0x0000002338307220ULL, 0x040fe20000410000ULL, 0x0000001a38317220ULL, 0x040fe20000410000ULL,
0x0000001b38327220ULL, 0x040fe20000410000ULL, 0x0000002e382e7220ULL, 0x040fe20000410000ULL,
0x0000002f382f7220ULL, 0x040fe20000410000ULL, 0x0000000d380d7220ULL, 0x040fe20000410000ULL,
0x0000000e380e7220ULL, 0x040fe20000410000ULL, 0x0000000a380c7220ULL, 0x040fe20000410000ULL,
0x0000000b38337220ULL, 0x040fe20000410000ULL, 0x0000002d38257220ULL, 0x040fe20000410000ULL,
0x0000001838287220ULL, 0x040fe20000410000ULL, 0x0000002c38267220ULL, 0x040fe20000410000ULL,
0x0000001138237220ULL, 0x040fe20000410000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0020ULL,
0x0000001938277220ULL, 0x040fe20000410000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e001dULL,
0x0000001338117220ULL, 0x040fe20000410000ULL, 0x00000009381f7220ULL, 0x040fe20000410000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0021ULL, 0x0000001238127220ULL, 0x040fe20000410000ULL,
0x000000ffff207224ULL, 0x000fe200078e0008ULL, 0x00000004381e7220ULL, 0x040fe20000410000ULL,
0x000000ffff187224ULL, 0x000fe200078e001cULL, 0x00000005381b7220ULL, 0x000fe20000410000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e000fULL, 0x8000000024ff7812ULL, 0x002fe20007804803ULL,
0x000000ffff247224ULL, 0x000fe200078e0010ULL, 0x0000000638067220ULL, 0x040fe20000410000ULL,
0x0000000738077220ULL, 0x000fe20000410000ULL, 0x000000ffff217224ULL, 0x000fc400078e000dULL,
0x000000ffff1a7224ULL, 0x000fe400078e002aULL, 0x000000ffff197224ULL, 0x000fe400078e0030ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0031ULL, 0x000000ffff097224ULL, 0x000fe400078e0032ULL,
0x000000ffff087224ULL, 0x000fe400078e002eULL, 0x000000ffff137224ULL, 0x000fc400078e002fULL,
0x000000ffff107224ULL, 0x000fe400078e000eULL, 0x000000ffff1c7224ULL, 0x000fe400078e000cULL,
0x000000ffff0f7224ULL, 0x000fe200078e0033ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0006ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0007ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000034057824ULL, 0x000fe400078e00ffULL, 0x3e000000ff037424ULL, 0x000fc800078e00ffULL,
0x0000000300047305ULL, 0x0002a4000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x00f614003e047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000043a037824ULL, 0x000fe200078e00ffULL, 0x0000003c4900720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff003057812ULL, 0x000fca00078ec0ffULL,
0x00000080480c7824ULL, 0x000fca00078e0205ULL, 0x00f400000c047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x000000023a2a7824ULL, 0x000fe400078e00ffULL,
0x0000000117427824ULL, 0x000fc600078e0a42ULL, 0x000000062a2f7812ULL, 0x000fc800078ec0ffULL,
0x000000012f317812ULL, 0x040fe400078efcffULL, 0x000000082f337812ULL, 0x000fe400078efcffULL,
0x000000423100720cULL, 0x080fe40003f26070ULL, 0x000000102f317812ULL, 0x000fe400078efcffULL,
0x000000423300720cULL, 0x080fe40003f06070ULL, 0x000000423100720cULL, 0x000fc40003fc6070ULL,
0x000000112f337812ULL, 0x040fe400078efcffULL, 0x000000182f317812ULL, 0x040fe400078efcffULL,
0x000000422f00720cULL, 0x080fe40003f46070ULL, 0x000000423300720cULL, 0x080fe40003fa6070ULL,
0x000000423100720cULL, 0x000fe40003f66070ULL, 0x000000092f357812ULL, 0x000fc400078efcffULL,
0x000000192f337812ULL, 0x040fe400078efcffULL, 0x000000202f317812ULL, 0x000fe400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40005000000ULL,
0xff7fffff19197808ULL, 0x000fe40004800000ULL, 0xff7fffff2c2c7808ULL, 0x000fc40004800000ULL,
0x000000423500720cULL, 0x080fe40003f86070ULL, 0x000000423300720cULL, 0x080fe40003f46070ULL,
0x000000423100720cULL, 0x000fe40003f26070ULL, 0x000000212f337812ULL, 0x040fe400078efcffULL,
0x000000282f317812ULL, 0x000fe400078efcffULL, 0xff7fffff18187808ULL, 0x000fc40004000000ULL,
0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL, 0xff7fffff0b0b7808ULL, 0x000fe40006000000ULL,
0xff7fffff29297808ULL, 0x000fe40006000000ULL, 0x000000423300720cULL, 0x080fe40003f06070ULL,
0x000000423100720cULL, 0x000fe40003f86070ULL, 0x000000292f337812ULL, 0x000fc400078efcffULL,
0x000000302f317812ULL, 0x000fe400078efcffULL, 0xff7fffff0a0a7808ULL, 0x000fe40007000000ULL,
0xff7fffff28287808ULL, 0x000fe40007000000ULL, 0xff7fffff09097808ULL, 0x000fe40006800000ULL,
0xff7fffff27277808ULL, 0x000fe40006800000ULL, 0x000000423300720cULL, 0x000fc40003fc6070ULL,
0x000000423100720cULL, 0x000fe40003fa6070ULL, 0x000000312f337812ULL, 0x040fe400078efcffULL,
0x000000382f317812ULL, 0x040fe400078efcffULL, 0x000000392f2f7812ULL, 0x000fe400078efcffULL,
0xff7fffff08087808ULL, 0x000fe40005800000ULL, 0xff7fffff26267808ULL, 0x000fc40005800000ULL,
0xff7fffff13137808ULL, 0x000fe40005000000ULL, 0xff7fffff25257808ULL, 0x000fe40005000000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0xff7fffff24247808ULL, 0x000fe40004800000ULL,
0x000000423300720cULL, 0x080fe40003f66070ULL, 0x000000423100720cULL, 0x000fc40003f46070ULL,
0x000000422f00720cULL, 0x000fe40003f26070ULL, 0xff7fffff11117808ULL, 0x000fe40004000000ULL,
0xff7fffff23237808ULL, 0x000fe40004000000ULL, 0xff7fffff10107808ULL, 0x000fe40006000000ULL,
0xff7fffff22227808ULL, 0x000fe40006000000ULL, 0xff7fffff1d1d7808ULL, 0x000fc40007000000ULL,
0xff7fffff21217808ULL, 0x000fe40007000000ULL, 0xff7fffff20207808ULL, 0x000fe40006800000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40006800000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40005800000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40005800000ULL, 0xff7fffff1e1e7808ULL, 0x000fc40005000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002d042f7209ULL, 0x004fe20007810000ULL, 0x0000001fff347424ULL, 0x000fe200078e00ffULL,
0x0000001a052a7209ULL, 0x000fe20007810000ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x0000002c2f047209ULL, 0x000fe40007810000ULL, 0x000000192a057209ULL, 0x000fc40007810000ULL,
0x0000002b04047209ULL, 0x000fe40007810000ULL, 0x00000018052a7209ULL, 0x000fe40007810000ULL,
0x0000002904057209ULL, 0x000fe40007810000ULL, 0x0000000b2a2f7209ULL, 0x000fe40007810000ULL,
0x0000002805047209ULL, 0x000fe40007810000ULL, 0x0000000a2f2a7209ULL, 0x000fc40007810000ULL,
0x0000002704057209ULL, 0x000fe40007810000ULL, 0x000000092a2f7209ULL, 0x000fe40007810000ULL,
0x0000002605047209ULL, 0x000fe40007810000ULL, 0x000000082f2a7209ULL, 0x000fe40007810000ULL,
0x0000002504057209ULL, 0x000fe40007810000ULL, 0x000000132a2f7209ULL, 0x000fc40007810000ULL,
0x0000002405047209ULL, 0x000fe40007810000ULL, 0x000000122f2a7209ULL, 0x000fe40007810000ULL,
0x0000002304057209ULL, 0x000fe40007810000ULL, 0x000000112a2f7209ULL, 0x000fe40007810000ULL,
0x0000002205047209ULL, 0x000fe40007810000ULL, 0x000000102f2a7209ULL, 0x000fc40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x0000001d2a2f7209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x0000001c2f2a7209ULL, 0x000fe40007810000ULL,
0x0000001f04057209ULL, 0x000fe40007810000ULL, 0x0000000f2a2f7209ULL, 0x000fc40007810000ULL,
0x0000001e05047209ULL, 0x000fe40007810000ULL, 0x0000000e2f2a7209ULL, 0x000fe40007810000ULL,
0x0000001b04307209ULL, 0x000fe40007810000ULL, 0x0000000d2a327209ULL, 0x000fe20007810000ULL,
0x00000e927f007947ULL, 0x000fea000b800000ULL, 0x0c401f0030047f89ULL, 0x0004e400000e0000ULL,
0x0000000430337209ULL, 0x008fe20007810000ULL, 0x00000eb27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0032047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000f2800000e0000ULL,
0x0c401f00072a7f89ULL, 0x000e6200000e0000ULL, 0x00000004322e7209ULL, 0x008fc60007810000ULL,
0x0c201f0033047f89ULL, 0x000ee200000e0000ULL, 0x00000005062f7209ULL, 0x010fc60007810000ULL,
0x0c201f002e057f89ULL, 0x000f2200000e0000ULL, 0x0000002a072a7209ULL, 0x002fc60007810000ULL,
0x0c201f002f307f89ULL, 0x004e6800000e0000ULL, 0x0c201f002a317f89ULL, 0x0004a200000e0000ULL,
0x0000000433047209ULL, 0x008fe40007810000ULL, 0x000000052e057209ULL, 0x010fe40007810000ULL,
0x000000302f067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b042e7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b05337820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000067886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010833ULL,
0x0000001f00327308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001082eULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0b1f7823ULL, 0x108fe20000010833ULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b22227823ULL, 0x000fe2000001082eULL, 0x3fb8aa3b08347823ULL, 0x102fe20000010833ULL,
0x0000002c002c7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b0d0d7823ULL, 0x000fc80000010833ULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x0000002900307308ULL, 0x000ee20000000800ULL, 0x0000002d2c08723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b102d7823ULL, 0x000fcc0000010833ULL, 0x0000001a001a7308ULL, 0x000ff00000000800ULL,
0x0000001900197308ULL, 0x000ff00000000800ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000001f000b7308ULL, 0x0003300000000800ULL, 0x0000001e002f7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b121f7823ULL, 0x002fce0000010833ULL, 0x0000001b002e7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b0a1e7823ULL, 0x104fe20000010833ULL, 0x0000002b300a723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b112b7823ULL, 0x000fe20000010833ULL, 0x000000180b0b723eULL, 0x010fc800000000ffULL,
0x0000002100077308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b091b7823ULL, 0x002fe20000010833ULL,
0x0000001a1909723eULL, 0x000fcc00000000ffULL, 0x0000002000297308ULL, 0x0003e20000000800ULL,
0x3c003c00ff217424ULL, 0x004fce00078e00ffULL, 0x0000001b00357308ULL, 0x0005e20000000800ULL,
0x3c003c00ff207424ULL, 0x002fce00078e00ffULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x000000200818723cULL, 0x004fee00000018ffULL, 0x0000002700277308ULL, 0x000e700000000800ULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x000000282710723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b1c277823ULL, 0x000fcc0000010833ULL,
0x0000001e001e7308ULL, 0x000e700000000800ULL, 0x0000003400347308ULL, 0x000fe20000000800ULL,
0x000000262512723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b1d257823ULL, 0x000fcc0000010833ULL,
0x0000001300137308ULL, 0x000ea20000000800ULL, 0x0000001e3511723eULL, 0x002fce00000000ffULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x000000341313723eULL, 0x004fce00000000ffULL,
0x0000002b002c7308ULL, 0x000e620000000800ULL, 0x000000201018723cULL, 0x000fee0000001818ULL,
0x0000002400247308ULL, 0x000ff00000000800ULL, 0x0000002300237308ULL, 0x000ea20000000800ULL,
0x0000001f2c1d723eULL, 0x002fce00000000ffULL, 0x0000002200227308ULL, 0x000e700000000800ULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x00000024231c723eULL, 0x004fce00000000ffULL,
0x0000002500267308ULL, 0x000ea20000000800ULL, 0x00000022071e723eULL, 0x002fe400000000ffULL,
0xfffffffc3a077812ULL, 0x000fca00078ec0ffULL, 0x0000000f00287308ULL, 0x000fe20000000800ULL,
0x0000002d261f723eULL, 0x004fce00000000ffULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x000000201c34723cULL, 0x000fee0000001818ULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000fff187424ULL, 0x000fe200078e00ffULL, 0x0000002f2e1a723eULL, 0x000fcc00000000ffULL,
0x0000000d000d7308ULL, 0x000ea20000000800ULL, 0x000000272819723eULL, 0x002fe400000000ffULL,
0x00000007180f7219ULL, 0x000fe400000006ffULL, 0x000000293218723eULL, 0x000fe400000000ffULL,
0x000000000f2273a1ULL, 0x000e6200000e8000ULL, 0x000000000f0573c4ULL, 0x000ee20000004000ULL,
0x0000002a31077209ULL, 0x000fe40007810000ULL, 0x0000000e0d1b723eULL, 0x004fce00000000ffULL,
0x000000201824723cULL, 0x000fe20000001834ULL, 0x000000060fff7c12ULL, 0x002fda000f804022ULL,
0x000009f205008947ULL, 0x008ff4000b800000ULL, 0x001c1fff24207589ULL, 0x0002a400000e0000ULL,
0x000000000f0e73a1ULL, 0x000ee200000e8000ULL, 0x000000000f0573c4ULL, 0x000f220000004000ULL,
0x0000000000067886ULL, 0x000fe400038e0100ULL, 0x000000060fff7c12ULL, 0x008fda000f80400eULL,
0x00000a1205008947ULL, 0x010fea000b800000ULL, 0x001c1fff26217589ULL, 0x00072800000e0000ULL,
0x001c1fff22227589ULL, 0x00066800000e0000ULL, 0x001c1fff00237589ULL, 0x0006a400000e0000ULL,
0x00000002ff0d7819ULL, 0x000fe4000001163aULL, 0x0000000c03377812ULL, 0x002fc400078ec0ffULL,
0x000000070d0e7812ULL, 0x040fe200078ec0ffULL, 0x000000080d277824ULL, 0x040fe200078e00ffULL,
0x0000000dff257212ULL, 0x000fe200078e33ffULL, 0x000000080d0f7824ULL, 0x048fe200078e00ffULL,
0x000000033aff7812ULL, 0x000fe2000780c0ffULL, 0x000000080d327824ULL, 0x040fe200078e00ffULL,
0x000000080d0d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff827247812ULL, 0x100fe400078ee20eULL,
0x000000010f267812ULL, 0x100fe200078ef60eULL, 0x000000080d277824ULL, 0x000fe200078e00ffULL,
0x000000020f287812ULL, 0x100fe200078ef60eULL, 0x000000080d4e7824ULL, 0x000fe200078e00ffULL,
0x000000030f2a7812ULL, 0x000fc400078ef60eULL, 0x000000040f2c7812ULL, 0x140fe400078ef60eULL,
0x000000050f2e7812ULL, 0x140fe400078ef60eULL, 0x000000060f307812ULL, 0x000fe200078ef60eULL,
0x000000080d0f7824ULL, 0x040fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe400078ee225ULL,
0x0000000dff257212ULL, 0x000fe400078e33ffULL, 0x000000070d0e7812ULL, 0x000fc400078ec0ffULL,
0x00009000480d7811ULL, 0x000fe400078e58ffULL, 0xfffffff827347812ULL, 0x100fe400078ee20eULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee225ULL, 0x0000001024037824ULL, 0x100fe200078e020dULL,
0x000000010f367812ULL, 0x140fe200078ef60eULL, 0x000000102a247824ULL, 0x100fe200078e020dULL,
0x000000020f427812ULL, 0x140fe200078ef60eULL, 0x00000010302a7824ULL, 0x000fe200078e020dULL,
0x000000030f447812ULL, 0x100fe200078ef60eULL, 0x0000000137037824ULL, 0x000fe200078e0203ULL,
0x000000040f467812ULL, 0x140fe200078ef60eULL, 0x00000010362f7824ULL, 0x100fe200078e020dULL,
0x000000050f4a7812ULL, 0x140fe200078ef60eULL, 0x0000001042307824ULL, 0x100fe200078e020dULL,
0x000000060f4c7812ULL, 0x000fe200078ef60eULL, 0x00000010260e7824ULL, 0x100fe200078e020dULL,
0x0000000803007388ULL, 0x0003e20000000800ULL, 0x00000010280f7824ULL, 0x000fc400078e020dULL,
0x000000102c267824ULL, 0x100fe400078e020dULL, 0x000000102e287824ULL, 0x100fe400078e020dULL,
0x00000010322c7824ULL, 0x100fe400078e020dULL, 0x00000010342e7824ULL, 0x100fe400078e020dULL,
0x0000001044317824ULL, 0x100fe400078e020dULL, 0x0000001046327824ULL, 0x000fc400078e020dULL,
0x000000104a337824ULL, 0x100fe400078e020dULL, 0x000000104c347824ULL, 0x100fe400078e020dULL,
0x000000104e357824ULL, 0x000fe400078e020dULL, 0x00000001370d7824ULL, 0x040fe400078e020eULL,
0x00000001370f7824ULL, 0x040fe400078e020fULL, 0x0000000137257824ULL, 0x040fe200078e0224ULL,
0x0000000a0d007388ULL, 0x0007e20000000800ULL, 0x0000000137277824ULL, 0x000fc400078e0226ULL,
0x0000000137297824ULL, 0x040fe200078e0228ULL, 0x000000100f007388ULL, 0x0007e20000000800ULL,
0x00000001372b7824ULL, 0x040fe400078e022aULL, 0x00000001372d7824ULL, 0x040fe200078e022cULL,
0x0000001225007388ULL, 0x0007e20000000800ULL, 0x00000001372e7824ULL, 0x040fe400078e022eULL,
0x00000001370e7824ULL, 0x040fe200078e022fULL, 0x0000001c27007388ULL, 0x0007e20000000800ULL,
0x0000000137307824ULL, 0x000fc400078e0230ULL, 0x0000000137087824ULL, 0x042fe200078e0231ULL,
0x0000001e29007388ULL, 0x0007e20000000800ULL, 0x0000000137327824ULL, 0x040fe400078e0232ULL,
0x0000000137247824ULL, 0x040fe200078e0233ULL, 0x000000182b007388ULL, 0x0007e20000000800ULL,
0x0000000137347824ULL, 0x040fe400078e0234ULL, 0x0000000137267824ULL, 0x000fe200078e0235ULL,
0x0000001a2d007388ULL, 0x0007e80000000800ULL, 0x000000092e007388ULL, 0x0007e80000000800ULL,
0x0000000b0e007388ULL, 0x0007e80000000800ULL, 0x0000001130007388ULL, 0x0007e80000000800ULL,
0x0000001308007388ULL, 0x0007e80000000800ULL, 0x0000001d32007388ULL, 0x0007e80000000800ULL,
0x0000001f24007388ULL, 0x0007e80000000800ULL, 0x0000001934007388ULL, 0x0007e80000000800ULL,
0x0000001b26007388ULL, 0x0007e80000000800ULL, 0x00f000040c008388ULL, 0x0007e80000000c00ULL,
0x00f200200c008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030049497a10ULL, 0x000fe20007ffe0ffULL, 0x00f608003eff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff3bff7812ULL, 0x000fc4000780c0ffULL, 0x000000024900720cULL, 0x000fe40003f26070ULL,
0x00000001ff3b7807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffd31000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff357224ULL, 0x000fe200078e002fULL, 0x0000e02000307802ULL, 0x000fe20000000f00ULL,
0x000000ffff347224ULL, 0x000fe400078e0058ULL, 0x0000001fff367424ULL, 0x000fe400078e00ffULL,
0xffffffffff377424ULL, 0x000fe400078e00ffULL, 0x0000069000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2f7224ULL, 0x004fe200078e0033ULL, 0xffffadd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x002fe200078e0058ULL, 0x0000e0a000307802ULL, 0x000fe20000000f00ULL,
0x000000ffff357224ULL, 0x000fe400078e002eULL, 0x0000001fff367424ULL, 0x000fc400078e00ffULL,
0xffffffffff377424ULL, 0x000fe400078e00ffULL, 0x0000061000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff2e7224ULL, 0x004fe200078e0033ULL, 0xffffad7000007947ULL, 0x000fea000383ffffULL,
0x00000002ff317424ULL, 0x000fe200078e00ffULL, 0x0000e0f0002e7802ULL, 0x000fe40000000f00ULL,
0x0000058000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0031ULL,
0xfffff13000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x006fe200078e0032ULL,
0x0000e150002e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff317424ULL, 0x000fe400078e00ffULL,
0x0000052000007944ULL, 0x020fea0003c00000ULL, 0x0000003132327209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x002fe200078e0006ULL, 0x0000e1a0002e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff317424ULL, 0x000fe400078e00ffULL, 0x000004d000007944ULL, 0x000fea0003c00000ULL,
0x0000003106067209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x002fe200078e0007ULL,
0x0000e1f0002e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff317424ULL, 0x000fc400078e00ffULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x00000031072a7209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x002fe200078e0033ULL, 0x0000e240002e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fc400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x0000003133047209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x002fe200078e0032ULL,
0x0000e290002e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff317424ULL, 0x000fc400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x0000003132057209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x002fe200078e0006ULL, 0x0000e2e0002e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000003106067209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x002fe200078e002aULL,
0x0000e330002e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff317424ULL, 0x000fc400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0xffffeff000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0024ULL, 0x0000e3a000307802ULL, 0x000fe20000000f00ULL,
0x000000ffff357224ULL, 0x000fc400078e00ffULL, 0x00001c1fff367424ULL, 0x000fe400078e00ffULL,
0x000000ffff377224ULL, 0x000fe400078e000fULL, 0x0000031000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff207224ULL, 0x004fe200078e0033ULL, 0xfffff5a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x002fe200078e0026ULL, 0x0000e42000307802ULL, 0x000fe20000000f00ULL,
0x000000ffff357224ULL, 0x000fe400078e00ffULL, 0x00001c1fff367424ULL, 0x000fe400078e00ffULL,
0x000000ffff377224ULL, 0x000fe400078e000fULL, 0x0000029000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff357224ULL, 0x002fe200078e00ffULL, 0x0000e48000307802ULL, 0x000fe20000000f00ULL,
0x00001c1fff367424ULL, 0x000fc400078e00ffULL, 0x000000ffff377224ULL, 0x000fe400078e000fULL,
0x000000ffff217224ULL, 0x004fe400078e0033ULL, 0x0000023000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff377224ULL, 0x002fe200078e000fULL, 0x0000e4e000307802ULL, 0x000fe20000000f00ULL,
0x000000ffff357224ULL, 0x000fe400078e00ffULL, 0x00001c1fff367424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x004fe400078e0033ULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff237224ULL, 0x004fe200078e0033ULL, 0xfffff4e000007947ULL, 0x000fea000383ffffULL,
0x0180000004007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000000400008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff077807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000007ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff04ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000004047812ULL, 0x002fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000007ff7212ULL, 0x000fda000780c0ffULL,
0x0080000004000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0004ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000400007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xffff199006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000003500007348ULL, 0x000fe80003800000ULL, 0x0c00003130317389ULL, 0x0002a200000e0034ULL,
0xffff19502e007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff317424ULL, 0x000fe200078e00ffULL,
0x0000003700007348ULL, 0x000fe80003800000ULL, 0x0000003534337389ULL, 0x0002a200000e0036ULL,
0xffff191030007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000778ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007f0ULL, 0x00000000000006acULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e9cULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ec0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ed0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ef0ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f60ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f68ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000f78ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x000000000000e780ULL, 0x7700001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000000f900ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x000000000000f910ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000000f910ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000000fd90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f60ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000e9a0ULL, 0x000000000000e9a0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000000f900ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000000fd90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_16_m_16_sm_89_cubin_len = 65136;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
