/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000018db8ULL, 0x0000000000018a38ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x346a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4532336a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL,
0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL, 0x45316a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x324545386a4c4532ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x0000000000000067ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x656b240061686d5fULL,
0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x65642e0066754265ULL, 0x6d6172665f677562ULL,
0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL, 0x665f67756265642eULL,
0x766e2e00656d6172ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x00000061686d5f6cULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000001beULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000b000100000204ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b00010000024bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000291ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000002dfULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000032dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000b00010000037bULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000003c9ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a002200000424ULL, 0x0000000000017390ULL, 0x0000000000000270ULL,
0x000400030000049aULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL,
0x0000000000000000ULL, 0x0000000000017600ULL, 0x000d0003000004caULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001739000000000ULL, 0x0001380400000000ULL,
0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL,
0x0001739000000000ULL, 0x0000027000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000001500082f04ULL, 0x00082304000000c3ULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001500082304ULL,
0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL, 0x0004370400000000ULL,
0x000c17040000007bULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL, 0x0058000900000000ULL,
0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL,
0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0xffffffff00dc2904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000001b000dc2804ULL,
0x000009f000000360ULL, 0x00002fe000002f70ULL, 0x000031f0000030c0ULL, 0x0000346000003320ULL,
0x000039e0000039d0ULL, 0x00003a00000039f0ULL, 0x000058b000005820ULL, 0x00005ac000005990ULL,
0x00005d3000005bf0ULL, 0x000061f0000061e0ULL, 0x0000621000006200ULL, 0x00007fb000007f20ULL,
0x000081c000008090ULL, 0x00008430000082f0ULL, 0x000088f0000088e0ULL, 0x0000891000008900ULL,
0x0000a7500000a6e0ULL, 0x0000a9700000a840ULL, 0x0000abe00000aaa0ULL, 0x0000b1000000b0f0ULL,
0x0000b1200000b110ULL, 0x0000c3d00000c3c0ULL, 0x0000c3f00000c3e0ULL, 0x00015c6000015bb0ULL,
0x0001603000015f40ULL, 0x0001652000016430ULL, 0x000168a0000167f0ULL, 0x0000053004303904ULL,
0x0001a600000000ffULL, 0x0000061000040100ULL, 0x0001a60800000007ULL, 0x00000720003f0100ULL,
0x0001a68800000007ULL, 0x00000860003f0100ULL, 0x0001a6a800000002ULL, 0x00000960003f0100ULL,
0x0001a6c800000004ULL, 0x000013f0003f0100ULL, 0x0001a600000000ffULL, 0x0000157000080107ULL,
0x0001a68800000002ULL, 0x00001fb0003f0101ULL, 0x00000000000000ffULL, 0x0000203000040107ULL,
0x00000000000000ffULL, 0x000020b000040101ULL, 0x0000002000000002ULL, 0x000021b0003f0101ULL,
0x0001a6c800000036ULL, 0x0000234000080109ULL, 0x0001a6c800000038ULL, 0x00002c10003f0109ULL,
0x0001a6b000000038ULL, 0x00002ce000080107ULL, 0x0001a6b00000003aULL, 0x00002cf0003f0101ULL,
0x0001a60800000080ULL, 0x00002d10003f0101ULL, 0x0001a60800000080ULL, 0x00002e80003f0109ULL,
0x0001a60800000080ULL, 0x000035f0003f0109ULL, 0x0001a6a80000003aULL, 0x00003760003f0109ULL,
0x0001a6a80000003aULL, 0x00004b40003f0109ULL, 0x0001a6c800000034ULL, 0x00004b60003f0101ULL,
0x0001a68800000081ULL, 0x00004bc000080101ULL, 0x0000000000000006ULL, 0x00004d30003f0109ULL,
0x0000000000000006ULL, 0x00005530003f0109ULL, 0x0001a6a80000007aULL, 0x000055d000080107ULL,
0x0001a6a800000088ULL, 0x000055e0003f0101ULL, 0x0001a62800000080ULL, 0x00005600003f0101ULL,
0x0001a62800000080ULL, 0x00005770003f0109ULL, 0x0001a62800000080ULL, 0x00005f00003f0109ULL,
0x0001a6b00000002fULL, 0x0000608000080109ULL, 0x0001a6b000000037ULL, 0x00007220003f0109ULL,
0x0001a6c800000034ULL, 0x00007240003f0101ULL, 0x0001a69000000036ULL, 0x000072b000080101ULL,
0x0000000000000006ULL, 0x00007420003f0109ULL, 0x0000000000000006ULL, 0x00007c50003f0109ULL,
0x0001a6b00000002eULL, 0x00007cd000080107ULL, 0x0001a6b000000084ULL, 0x00007ce0003f0101ULL,
0x0001a64800000080ULL, 0x00007d00003f0101ULL, 0x0001a64800000080ULL, 0x00007e70003f0109ULL,
0x0001a64800000080ULL, 0x00008600003f0109ULL, 0x0001a6a80000002fULL, 0x0000878000080109ULL,
0x0001a6a800000037ULL, 0x00009920003f0109ULL, 0x0001a6c80000004dULL, 0x00009940003f0101ULL,
0x0001a69800000036ULL, 0x000099b000080101ULL, 0x0001a6c80000004dULL, 0x00009b40003f0109ULL,
0x0001a6c80000004dULL, 0x0000a440003f0109ULL, 0x0001a6a800000034ULL, 0x0000a49000080107ULL,
0x0001a6a800000035ULL, 0x0000a4b0003f0101ULL, 0x0001a6680000002fULL, 0x0000a4e0003f0101ULL,
0x0001a6680000002fULL, 0x0000a650003f0109ULL, 0x0001a6680000002fULL, 0x0000ada0003f0109ULL,
0x0001a6b00000002fULL, 0x0000af2000080109ULL, 0x0001a6b000000037ULL, 0x0000c130003f0109ULL,
0x0000000000000006ULL, 0x0000c1a0003f0101ULL, 0x0001a6a000000006ULL, 0x0000e400003f0101ULL,
0x0001a600000000ffULL, 0x0000fd3000080101ULL, 0x0001a600000000ffULL, 0x0000fef000080109ULL,
0x0001a600000000ffULL, 0x0001023000080109ULL, 0x0001a600000000ffULL, 0x0001025000080101ULL,
0x0001a600000000ffULL, 0x000103c000080109ULL, 0x0001a600000000ffULL, 0x0001321000080109ULL,
0x0001a68800000052ULL, 0x000135e0003f0101ULL, 0x0001a68800000052ULL, 0x00013750003f0109ULL,
0x0001a68800000052ULL, 0x00017330003f0109ULL, 0x0001a60800000079ULL, 0x00017340003f0101ULL,
0x0001a61000000079ULL, 0x00017350003f0101ULL, 0x0001a61800000079ULL, 0x00017360003f0101ULL,
0x0001a62000000079ULL, 0x00053803003f0101ULL, 0x0000d2f000301c04ULL, 0x0000d5e00000d320ULL,
0x0000d9c00000d7d0ULL, 0x0000dda00000dbb0ULL, 0x0000e1900000df90ULL, 0x000103f00000e340ULL,
0x000c050400017380ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0068190300000000ULL,
0x0000001600080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL, 0x0000001500000002ULL,
0x0000000000017390ULL, 0x0000000000000044ULL, 0x0000001500000002ULL, 0x0000000000000000ULL,
0x0000000000000098ULL, 0x0000001500000002ULL, 0x0000000000000000ULL, 0x000000000001a700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x00000000007b7919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fcc0000000a00ULL,
0x00008500ff007b82ULL, 0x000f220000000800ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff022b82ULL, 0x000ea20000000a00ULL,
0x000000017b052836ULL, 0x008fe40000000000ULL, 0x000000047b082825ULL, 0x004fc800078e0002ULL,
0x0000000405022825ULL, 0x000fe400078e0002ULL, 0x0000000608082981ULL, 0x0004e8000c1e1900ULL,
0x0000000602072981ULL, 0x000ae2000c1e1900ULL, 0x0000000000067306ULL, 0x010f220000209000ULL,
0x00000400ff0a7b82ULL, 0x000f620000000800ULL, 0x000000ff0000720cULL, 0x000fe20003f65070ULL,
0x00000000000e7919ULL, 0x000f620000002300ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x0000000000097919ULL, 0x004ea20000002200ULL,
0x00000000000c7919ULL, 0x000ea20000002100ULL, 0x0000000600067308ULL, 0x010f240000001000ULL,
0x0ffffffe06047836ULL, 0x010fcc0000000000ULL, 0x0000000400057305ULL, 0x000964000021f000ULL,
0x000000ffff047224ULL, 0x010fe200078e00ffULL, 0x00000005ff637819ULL, 0x006fe2000001160cULL,
0x000000ffff0b7224ULL, 0x020fca00078e0a05ULL, 0x00001fff63637589ULL, 0x000e6200000e0000ULL,
0x000000000b0b7224ULL, 0x000fc800078e02ffULL, 0x0000000b05057227ULL, 0x000fcc00078e0004ULL,
0x0000000a05057227ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a05ULL,
0x0000000300037224ULL, 0x000fe400078e020aULL, 0x00000000000a7919ULL, 0x000ea60000002600ULL,
0x000000000300720cULL, 0x000fda0003f06070ULL, 0x0000000103030824ULL, 0x000fe400078e0a00ULL,
0x0000000105050836ULL, 0x000fc60000000000ULL, 0x000000000300720cULL, 0x000fda0003f26070ULL,
0x0000000105051836ULL, 0x000fe20000000000ULL, 0x00000000ff05b212ULL, 0x000fc800078e33ffULL,
0x0000000500047306ULL, 0x000f220000209000ULL, 0x000000ff0500720cULL, 0x000fce0003f65070ULL,
0x0000000400047308ULL, 0x010f240000001000ULL, 0x0ffffffe04027836ULL, 0x010fcc0000000000ULL,
0x0000000200037305ULL, 0x000964000021f000ULL, 0x000000ffff027224ULL, 0x010fe400078e00ffULL,
0x0000000305067224ULL, 0x020fc800078e02ffULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a06ULL,
0x00008400ff06ab82ULL, 0x000e640000000800ULL, 0x0000000b03037227ULL, 0x000fcc00078e0002ULL,
0x0000000a03777227ULL, 0x004fc800078e00ffULL, 0x000000040e037c24ULL, 0x000fe2000f8e0209ULL,
0x0000000000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff027224ULL, 0x000fe200078e0a77ULL,
0x00001fff0e0e7589ULL, 0x000e6200000e0000ULL, 0x0000000403047c24ULL, 0x000fe4000f8e020cULL,
0x0000000205027224ULL, 0x000fc600078e020aULL, 0x0000007f0400780cULL, 0x000fe40003fa4070ULL,
0x000000050200720cULL, 0x000fe40003f06070ULL, 0x000000030400780cULL, 0x000fd20003f84070ULL,
0x000000000009d919ULL, 0x000ea40000008800ULL, 0x0000000102020824ULL, 0x000fe400078e0a05ULL,
0x0000000177770836ULL, 0x000fe20000000000ULL, 0x000000ff0400720cULL, 0x000fe40003f05270ULL,
0x000000050200720cULL, 0x000fe40003f26070ULL, 0x000004000002d802ULL, 0x000fd60000000f00ULL,
0x0000000177771836ULL, 0x000fe20000000000ULL, 0x00000005ff77b212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x040fe40003f24070ULL, 0x000000010400780cULL, 0x000fe20003f64070ULL,
0x000000ffff757224ULL, 0x000fc800078e0a77ULL, 0x0000007505757224ULL, 0x000fe200078e020aULL,
0x000006540909d816ULL, 0x004fe20000000002ULL, 0xff317217ff05d424ULL, 0x000fc800078e00ffULL,
0x000000040402d824ULL, 0x000fe400078e0209ULL, 0x0000000107032824ULL, 0x008fcc00078e0a08ULL,
0x00008400ff03ab82ULL, 0x000ee20000000800ULL, 0x0000000000240947ULL, 0x002fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01a60008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404077c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000070812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a60804083f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404077c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000070812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a68804083f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01a400050200d388ULL, 0x0003e20000000800ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000002075757824ULL, 0x000fc600078e00ffULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000404027c11ULL, 0x002fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6a804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000040912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6c804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000803027c24ULL, 0x00afe2000f8e02ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0a75ULL, 0x000000750200720cULL, 0x000fe20003f06070ULL,
0x000000067b08a224ULL, 0x000fc400078e02ffULL, 0x0000000800117c24ULL, 0x000fe2000f8e02ffULL,
0x00000020020b7446ULL, 0x000fe2000380000bULL, 0x000000040e027824ULL, 0x000fe400078e0263ULL,
0x00000011080a7224ULL, 0x000fe200078e02ffULL, 0x000000ff0b0b7207ULL, 0x000fe20000000000ULL,
0x0000000402027824ULL, 0x000fe400078e00ffULL, 0x0000000877157c24ULL, 0x000fe2000f8e020aULL,
0x000000200b00780cULL, 0x000fda0003f05270ULL, 0x0000000400308947ULL, 0x000fea0003800000ULL,
0x0000000800077d06ULL, 0x000e620008209000ULL, 0x0000000000097919ULL, 0x000ea20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00008c0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000167919ULL, 0x000ee80000008800ULL, 0x0000000700077308ULL, 0x002e640000001000ULL,
0x0ffffffe07057836ULL, 0x002fe20000000000ULL, 0x00000004ff067819ULL, 0x004fca0000011609ULL,
0x0000000500057305ULL, 0x000e62000021f000ULL, 0x00000002060d7836ULL, 0x000fe40000000000ULL,
0x0000000102107824ULL, 0x040fe400078e0206ULL, 0x0000000102127824ULL, 0x000fc800078e020dULL,
0x0000000175147824ULL, 0x000fe400078e0212ULL, 0x000000ffff0f7224ULL, 0x002fc800078e0a05ULL,
0x000000080f0f7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000f05077227ULL, 0x000fc800078e0004ULL,
0x0000000175047824ULL, 0x000fe400078e0210ULL, 0x00000014070f7227ULL, 0x000fc800078e00ffULL,
0x0000000407057227ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e0a05ULL,
0x000000ffff137224ULL, 0x000fe400078e0a0fULL, 0x0000000807077c24ULL, 0x000fe4000f8e0204ULL,
0x00000008130c7c24ULL, 0x000fc6000f8e0214ULL, 0x0000000807007c0cULL, 0x000fe4000bf06070ULL,
0x000000080c007c0cULL, 0x000fd6000bf46070ULL, 0x8000000807070c36ULL, 0x000fe40008000000ULL,
0x800000080c0c2c36ULL, 0x000fe40008000000ULL, 0x0000000105050836ULL, 0x000fe20000000000ULL,
0x0000000807007c0cULL, 0x000fe2000bf26070ULL, 0x000000010f0f2836ULL, 0x000fe20000000000ULL,
0x000000080c007c0cULL, 0x000fe4000bf66070ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x00000008ff0c7c12ULL, 0x000fce000f8e33ffULL, 0x0000000105051836ULL, 0x000fe40000000000ULL,
0x000000010f0f3836ULL, 0x000fc60000000000ULL, 0x000000050c077207ULL, 0x040fe40004000000ULL,
0x0000000f0c0c7207ULL, 0x000fe40004000000ULL, 0x000000020b057248ULL, 0x000fe20007fe0000ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0a07ULL, 0x000000ffff137224ULL, 0x000fe400078e0a0cULL,
0x000000080f047c24ULL, 0x000fe2000f8e0204ULL, 0x00000400000f7802ULL, 0x000fe20000000f00ULL,
0x0000000813147c24ULL, 0x000fc4000f8e0214ULL, 0x0000000115047824ULL, 0x040fe200078e0204ULL,
0x0000065416167816ULL, 0x008fe2000000000fULL, 0x00000001150f7824ULL, 0x000fe400078e0214ULL,
0x0000000105057824ULL, 0x000fe200078e0a02ULL, 0x00000000160872caULL, 0x000fe200000e0000ULL,
0x0000001107077224ULL, 0x000fe400078e0204ULL, 0x0000001009047824ULL, 0x000fe200078e00ffULL,
0x000000050600720cULL, 0x000fe20003f06070ULL, 0x000000110c0c7224ULL, 0x000fe200078e020fULL,
0x000000050d00720cULL, 0x000fe20003f26070ULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x000000f004057812ULL, 0x000fc600078ec0ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000506067212ULL, 0x000fc600078efcffULL, 0x0000000110027824ULL, 0x100fe200078e0209ULL,
0x000000050c057212ULL, 0x000fe200078efcffULL, 0x0000001010117824ULL, 0x000fe200078e00ffULL,
0x0000000406067c10ULL, 0x000fe2000ff5e0ffULL, 0x00000001120f7824ULL, 0x040fe200078e0209ULL,
0x00000004050c7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001012127824ULL, 0x000fe200078e00ffULL,
0xfffffff011027812ULL, 0x000fe400078ee202ULL, 0x0000000507077c10ULL, 0x000fe400097fe4ffULL,
0xfffffff0120f7812ULL, 0x000fc400078ee20fULL, 0x0000000802057c11ULL, 0x000fe4000f8e20ffULL,
0x000000050d0d7c10ULL, 0x000fe40009ffe4ffULL, 0x000000080f0f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e8000c101c46ULL,
0x000000000c0f7faeULL, 0x0003e2000c901c46ULL, 0x0000000400147947ULL, 0x000fea0003800000ULL,
0x0000000800067d06ULL, 0x000e620008209000ULL, 0x0000000000097919ULL, 0x000ea20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00008c0000047ab9ULL, 0x000fca0000000a00ULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe060c7836ULL, 0x002fe20000000000ULL,
0x0000000209027211ULL, 0x004fca00078fe0ffULL, 0x0000000c00057305ULL, 0x000e62000021f000ULL,
0x0000000202107836ULL, 0x000fe40000000000ULL, 0x000000ffff077224ULL, 0x002fc800078e0a05ULL,
0x0000000807077c24ULL, 0x000fc8000f8e02ffULL, 0x00000007050d7227ULL, 0x000fc800078e0004ULL,
0x0000000175047824ULL, 0x040fe400078e0202ULL, 0x0000000175077824ULL, 0x000fe400078e0210ULL,
0x000000040d057227ULL, 0x000fc800078e00ffULL, 0x000000070d0c7227ULL, 0x000fc800078e00ffULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a05ULL, 0x000000ffff127224ULL, 0x000fe400078e0a0cULL,
0x000000080d067c24ULL, 0x000fe4000f8e0204ULL, 0x00000008120d7c24ULL, 0x000fe4000f8e0207ULL,
0x0000000000127919ULL, 0x000e620000008800ULL, 0x0000000806007c0cULL, 0x000fe4000bf06070ULL,
0x000000080d007c0cULL, 0x000fd6000bf46070ULL, 0x8000000806060c36ULL, 0x000fe40008000000ULL,
0x800000080d0d2c36ULL, 0x000fe40008000000ULL, 0x0000000105050836ULL, 0x000fe20000000000ULL,
0x0000000806007c0cULL, 0x000fe2000bf26070ULL, 0x000000010c0c2836ULL, 0x000fe20000000000ULL,
0x000000080d007c0cULL, 0x000fe4000bf66070ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x00000008ff067c12ULL, 0x000fce000f8e33ffULL, 0x0000000105051836ULL, 0x000fe40000000000ULL,
0x000000010c0c3836ULL, 0x000fc60000000000ULL, 0x0000000506057207ULL, 0x040fe40004000000ULL,
0x0000000c060c7207ULL, 0x000fc60004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a05ULL,
0x000000ffff067224ULL, 0x000fe400078e0a0cULL, 0x000000080d047c24ULL, 0x000fe2000f8e0204ULL,
0x00000400000d7802ULL, 0x000fe20000000f00ULL, 0x0000000806077c24ULL, 0x000fe4000f8e0207ULL,
0x0000000115067824ULL, 0x040fe200078e0204ULL, 0x00000654120d7816ULL, 0x002fe2000000000dULL,
0x0000000115077824ULL, 0x000fc400078e0207ULL, 0x0000001009047824ULL, 0x000fe200078e00ffULL,
0x000000000d0872caULL, 0x000fe200000e0000ULL, 0x0000001105067224ULL, 0x080fe400078e0206ULL,
0x000000110c0c7224ULL, 0x000fe200078e0207ULL, 0x000000f0040f7812ULL, 0x000fe200078ec0ffULL,
0x0000010006067825ULL, 0x000fc800078e00ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000f06067212ULL, 0x000fc600078efcffULL, 0x0000000102057824ULL, 0x100fe200078e0209ULL,
0x0000000f0c0c7212ULL, 0x000fe200078efcffULL, 0x0000001002127824ULL, 0x000fe200078e00ffULL,
0x0000000406067c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000110027824ULL, 0x040fe200078e0209ULL,
0x000000040c0c7c10ULL, 0x000fe2000ff3e0ffULL, 0x00000010100f7824ULL, 0x000fe200078e00ffULL,
0xfffffff012057812ULL, 0x000fe400078ee205ULL, 0x0000000507077c10ULL, 0x000fe400087fe4ffULL,
0xfffffff00f027812ULL, 0x000fc400078ee202ULL, 0x0000000805057c11ULL, 0x000fe4000f8e20ffULL,
0x000000050d0d7c10ULL, 0x000fe40008ffe4ffULL, 0x00000008020f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e8000b901c46ULL,
0x000000000c0f7faeULL, 0x0003e4000b901c46ULL, 0x0001a60008047890ULL, 0x000fe2000fffe03fULL,
0x00009400ff067b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x000000047b067825ULL, 0x002fe200078e0006ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000606767981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0e00720cULL, 0x000fe20003f05270ULL,
0x0000003f76747836ULL, 0x004fe40000000000ULL, 0x000000ff76057836ULL, 0x000fc60000000000ULL,
0x00000006ff747819ULL, 0x000fe40000011674ULL, 0x00000008ff627819ULL, 0x000fca0000011605ULL,
0x000000cc00a88947ULL, 0x000fea0003800000ULL, 0x00000002ff607819ULL, 0x000fe20000011663ULL,
0xffffffffff0d7424ULL, 0x000fe400078e00ffULL, 0x00000004ff0f7424ULL, 0x000fe200078e00ffULL,
0x03ffffff60597812ULL, 0x000fc800078ec0ffULL, 0x000000745900720cULL, 0x000fda0003f06070ULL,
0x00009600ff038b82ULL, 0x000e620000000800ULL, 0x000000027b028824ULL, 0x000fce00078e00ffULL,
0x00009200ff068b82ULL, 0x000ea20000000a00ULL, 0x0000000302028224ULL, 0x002fc800078e0203ULL,
0x0000000159038824ULL, 0x000fe200078e0202ULL, 0x0000000863027c11ULL, 0x000fc6000f8e18ffULL,
0x0000000403068825ULL, 0x004fe200078e0006ULL, 0x01a6880f02ff79a7ULL, 0x0003e8000850003fULL,
0x00000006060d8981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x00000040775a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff617819ULL, 0x000fe40000011663ULL,
0x0000000163057812ULL, 0x000fc600078ec0ffULL, 0x00000020615b7824ULL, 0x000fe200078e00ffULL,
0x00009000ff027b82ULL, 0x002e620000000a00ULL, 0x000000000d0d7224ULL, 0x004fc600078e02ffULL,
0x000000205a007812ULL, 0x000fe200078ef85bULL, 0x000000400d0d7824ULL, 0x000fc800078e00ffULL,
0x000000800d027825ULL, 0x002fe200078e0002ULL, 0x0000000000fc0947ULL, 0x000fec0003800000ULL,
0x0000005b76067248ULL, 0x000fe20007fe0000ULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fc60000011609ULL, 0x0000000106067824ULL, 0x000fe400078e0a5bULL,
0x0000000105087824ULL, 0x000fe400078e0207ULL, 0x00000004070d7836ULL, 0x000fe20000000000ULL,
0x0000000506067248ULL, 0x000fe20007fe0000ULL, 0x00000001080c7824ULL, 0x040fe400078e0209ULL,
0x00000008080f7824ULL, 0x000fe400078e00ffULL, 0x0000000106067824ULL, 0x000fc400078e0a05ULL,
0x0000000c070e7836ULL, 0x000fe20000000000ULL, 0xfffffff80f127812ULL, 0x000fe200078ee20cULL,
0x00000008070c7836ULL, 0x000fe20000000000ULL, 0x000000060d00720cULL, 0x080fe20003f46070ULL,
0x00000001050d7824ULL, 0x000fe200078e020dULL, 0x000000060700720cULL, 0x080fe20003f66070ULL,
0x0000000100077824ULL, 0x000fe200078e0208ULL, 0x000000060c00720cULL, 0x080fe20003f26070ULL,
0x000000010d087824ULL, 0x040fe200078e0209ULL, 0x000000060e00720cULL, 0x000fe20003f06070ULL,
0x000000080d117824ULL, 0x000fc400078e00ffULL, 0x0000008007067825ULL, 0x000fc600078e00ffULL,
0xfffffff811087812ULL, 0x000fe200078ee208ULL, 0x00000001050f7824ULL, 0x040fe200078e020eULL,
0x0000007006117812ULL, 0x000fe200078ef804ULL, 0x00000001050c7824ULL, 0x000fe400078e020cULL,
0x0000000100137824ULL, 0x040fe200078e020fULL, 0x0000001102107210ULL, 0x000fe20007f9e0ffULL,
0x000000010f067824ULL, 0x040fe400078e0209ULL, 0x000000080f0f7824ULL, 0x000fe400078e00ffULL,
0x00000001000d7824ULL, 0x000fc400078e020dULL, 0x00000001000e7824ULL, 0x000fe200078e020cULL,
0xfffffff80f167812ULL, 0x000fe200078ee206ULL, 0x0000000103117824ULL, 0x000fe200020e0607ULL,
0x0000000861007c11ULL, 0x000fe2000f8e68ffULL, 0x000000010c057824ULL, 0x040fe400078e0209ULL,
0x000000080c147824ULL, 0x000fe400078e00ffULL, 0x000000800d067825ULL, 0x000fc600078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x000000800e0c7825ULL, 0x000fe200078e00ffULL,
0x00000070061d7812ULL, 0x000fc600078ef804ULL, 0x00000080130e7825ULL, 0x000fe200078e00ffULL,
0x000000700c1b7812ULL, 0x000fc600078ef804ULL, 0x0001600000057836ULL, 0x000fe20000000000ULL,
0x000000700e197812ULL, 0x000fe400078ef804ULL, 0x0000001d02047210ULL, 0x000fe20007f9e0ffULL,
0x0000001012137824ULL, 0x100fe200078e0205ULL, 0x0000001b02067210ULL, 0x000fe20007fbe0ffULL,
0x0000001008157824ULL, 0x100fe200078e0205ULL, 0x0000001902027210ULL, 0x000fe20007fde0ffULL,
0x0000001014177824ULL, 0x100fe200078e0205ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0003e2000d901c46ULL, 0x0000001016197824ULL, 0x000fc400078e0205ULL,
0x0000000103057824ULL, 0x040fe400020e0607ULL, 0x0000000103077824ULL, 0x040fe400028e060dULL,
0x0000000103037824ULL, 0x000fe200030e060fULL, 0x0000000004157faeULL, 0x0003e8000d101c46ULL,
0x0000000006177faeULL, 0x0003e8000c901c46ULL, 0x0000000002197faeULL, 0x0003e2000c101c46ULL,
0x0000000000c87947ULL, 0x000fea0003800000ULL, 0x0000001005067824ULL, 0x000fca00078e00ffULL,
0x0000000609057211ULL, 0x000fca00078fe8ffULL, 0x00000004050c7836ULL, 0x000fe40000000000ULL,
0x0000000105077824ULL, 0x040fe400078e0209ULL, 0x0000000805087824ULL, 0x000fe400078e00ffULL,
0x0000000100067824ULL, 0x000fe400078e0205ULL, 0x000000010c0d7824ULL, 0x040fe200078e0209ULL,
0xfffffff808087812ULL, 0x000fe200078ee207ULL, 0x000000080c127824ULL, 0x000fc400078e00ffULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee20dULL,
0x00000008050d7836ULL, 0x000fe20000000000ULL, 0x0000007006117812ULL, 0x000fe200078ef804ULL,
0x0000000c050e7836ULL, 0x000fe40000000000ULL, 0x00000001000c7824ULL, 0x040fe200078e020cULL,
0x0000001102107210ULL, 0x000fe20007f1e0ffULL, 0x0000000100057824ULL, 0x040fe400078e020dULL,
0x00000001000f7824ULL, 0x000fe400078e020eULL, 0x000000010d007824ULL, 0x000fc400078e0209ULL,
0x000000080d137824ULL, 0x000fe200078e00ffULL, 0x00000008610d7c11ULL, 0x000fe2000f8e68ffULL,
0x000000010e067824ULL, 0x040fe400078e0209ULL, 0x000000080e157824ULL, 0x000fe200078e00ffULL,
0xfffffff813007812ULL, 0x000fe200078ee200ULL, 0x0000000103117824ULL, 0x000fe400000e0607ULL,
0x000160000d1d7836ULL, 0x000fe20000000000ULL, 0xfffffff815147812ULL, 0x000fe200078ee206ULL,
0x000000800c067825ULL, 0x000fc800078e00ffULL, 0x00000080050c7825ULL, 0x000fe200078e00ffULL,
0x00000070061b7812ULL, 0x000fc600078ef804ULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c197812ULL, 0x000fc600078ef804ULL, 0x0000001008137824ULL, 0x100fe200078e021dULL,
0x000000700e057812ULL, 0x000fe200078ef804ULL, 0x0000001012157824ULL, 0x100fe200078e021dULL,
0x0000001b02047210ULL, 0x000fe20007f1e0ffULL, 0x0000001000177824ULL, 0x100fe200078e021dULL,
0x0000001902067210ULL, 0x000fe20007f3e0ffULL, 0x0000001014197824ULL, 0x000fe200078e021dULL,
0x0000000502027210ULL, 0x000fe20007f5e0ffULL, 0x0000000103057824ULL, 0x040fe200000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000b901c46ULL,
0x0000000103077824ULL, 0x000fc400008e060dULL, 0x0000000103037824ULL, 0x000fe200010e060fULL,
0x0000000004157faeULL, 0x0003e8000b901c46ULL, 0x0000000006177faeULL, 0x0003e8000b901c46ULL,
0x0000000002197faeULL, 0x0003e4000b901c46ULL, 0x0000000159597836ULL, 0x000fe40000000000ULL,
0xffffffffff817424ULL, 0x000fc600078e00ffULL, 0x000000745900720cULL, 0x000fda0003f06070ULL,
0x00009600ff058b82ULL, 0x002e620000000800ULL, 0x000000027b008824ULL, 0x000fe200078e00ffULL,
0x00000000610472caULL, 0x000fcc00000e0000ULL, 0x00009200ff028b82ULL, 0x000ea20000000a00ULL,
0x0000000500008224ULL, 0x002fc800078e0205ULL, 0x0000000100058824ULL, 0x000fe400078e0259ULL,
0x00000008ff007e24ULL, 0x000fe4000f8e00ffULL, 0x0000000405028825ULL, 0x004fc800078e0002ULL,
0x0001a6a800007836ULL, 0x000fe20000000000ULL, 0x0000000602818981ULL, 0x000322000c1e1900ULL,
0x000000ff6200720cULL, 0x000fe20003f05270ULL, 0x00000001ff057424ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000572caULL, 0x000fe200000e0000ULL,
0x000000ffff827224ULL, 0x000fe200078e00ffULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000504047291ULL, 0x000fe2000f8e203fULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000000e7805ULL, 0x000fc4000001ff00ULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000527805ULL, 0x000fc4000001ff00ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x000000ffff497224ULL, 0x000fe400078e00ffULL, 0x0000000861027824ULL, 0x002fe200078e0200ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000005ff7879a7ULL, 0x0002a20008500004ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x0000000000467805ULL, 0x000fe4000001ff00ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fc4000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00002005020279a7ULL, 0x0002e2000850003fULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x000000a000408947ULL, 0x000fec0003800000ULL, 0x00009600ff057b82ULL, 0x002e620000000800ULL,
0x000000027b087824ULL, 0x000fe200078e00ffULL, 0x0000000161587812ULL, 0x000fe200078ec0ffULL,
0x000000ffff397224ULL, 0x008fe400078e0003ULL, 0xff317217ff7e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fe400078e00ffULL,
0x0000000508087224ULL, 0x002fce00078e0205ULL, 0x000000ffff6e7224ULL, 0x000fce00078e0059ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x0000000463067824ULL, 0x000fca00078e00ffULL,
0xfffffff806367812ULL, 0x000fc800078ec0ffULL, 0x01a6c839360075a7ULL, 0x000e620008000148ULL,
0x0000000836387c36ULL, 0x000fc80008000000ULL, 0x0001a6c838067836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x01a6c839380075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009000ff347b82ULL, 0x000e620000000a00ULL, 0x0000001063367824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x0000000107377836ULL, 0x000fe40000000000ULL,
0x0000000481817c24ULL, 0x010fe2000f8e02ffULL, 0xffffffe036387812ULL, 0x000fe400078ec0ffULL,
0x000000623700720cULL, 0x000fe20003f26070ULL, 0x0000004081817824ULL, 0x000fe400078e00ffULL,
0x0000010007387824ULL, 0x000fc800078e0238ULL, 0x0000004038397836ULL, 0x000fca0000000000ULL,
0x0000002039377812ULL, 0x000fe200078ec0ffULL, 0x0000008081347825ULL, 0x002fc800078e0034ULL,
0x000000015a4d7824ULL, 0x000fe200078e0237ULL, 0x0000000400049947ULL, 0x000fec0003800000ULL,
0x0000001036377812ULL, 0x000fe200078ec0ffULL, 0x00000010093b7824ULL, 0x000fe200078e00ffULL,
0x0000003976367248ULL, 0x000fe40007fe0000ULL, 0x00000003ff3a7819ULL, 0x000fe40000011609ULL,
0x000000703b657812ULL, 0x000fe200078ec0ffULL, 0x0000000136367824ULL, 0x000fe400078e0a39ULL,
0x000000013a387824ULL, 0x000fe400078e0237ULL, 0x000000083a4c7836ULL, 0x000fe20000000000ULL,
0x0000003736367248ULL, 0x000fe20007fe0000ULL, 0x0000000138397824ULL, 0x000fc400078e0209ULL,
0x00000008384e7824ULL, 0x000fe400078e00ffULL, 0x0000000136367824ULL, 0x100fe400078e0a37ULL,
0x0000000c3a4f7836ULL, 0x000fe20000000000ULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee239ULL,
0x000000043a397836ULL, 0x000fe20000000000ULL, 0x000000363a00720cULL, 0x080fe20003f86070ULL,
0x000000014f5c7824ULL, 0x100fe200078e0237ULL, 0x000000364c00720cULL, 0x0c0fe20003f46070ULL,
0x00000001393a7824ULL, 0x140fe200078e0237ULL, 0x000000363900720cULL, 0x080fe20003f66070ULL,
0x000000014c4c7824ULL, 0x000fe200078e0237ULL, 0x000000364f00720cULL, 0x000fe20003f06070ULL,
0x000000014d367824ULL, 0x000fc400078e0238ULL, 0x000000014d387824ULL, 0x040fe400078e023aULL,
0x000000013a3b7824ULL, 0x140fe400078e0209ULL, 0x000000083a5e7824ULL, 0x000fe400078e00ffULL,
0x000000014d3a7824ULL, 0x040fe400078e024cULL, 0x000000014d4f7824ULL, 0x000fe400078e025cULL,
0x000000014c4d7824ULL, 0x000fc400078e0209ULL, 0x000000084c647824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x0000008038387825ULL, 0x000fc800078e00ffULL,
0x000000015c4c7824ULL, 0x040fe400078e0209ULL, 0x000000085c5d7824ULL, 0x000fe200078e00ffULL,
0xfffffff85e5c7812ULL, 0x000fe400078ee23bULL, 0xfffffff8645e7812ULL, 0x000fe400078ee24dULL,
0x00000065363b7212ULL, 0x080fe400078efcffULL, 0x00000065384d7212ULL, 0x000fe400078efcffULL,
0x0000003b34367210ULL, 0x000fe20007fbe0ffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0xfffffff85d647812ULL, 0x000fc400078ee24cULL, 0x0000004d34387210ULL, 0x000fe20007fde0ffULL,
0x000000804f4c7825ULL, 0x000fe200078e00ffULL, 0x00000008615d7c11ULL, 0x000fe4000f8e68ffULL,
0x000000653a677212ULL, 0x080fe200078efcffULL, 0x0000000135377824ULL, 0x040fe200028e0637ULL,
0x000000654c657212ULL, 0x000fe200078efcffULL, 0x000170005d4f7836ULL, 0x000fe20000000000ULL,
0x00000067343a7210ULL, 0x000fe20007fbe0ffULL, 0x0000000135397824ULL, 0x000fe200030e0639ULL,
0x0000006534347210ULL, 0x000fe20007fde0ffULL, 0x000000104e5d7824ULL, 0x000fc400078e024fULL,
0x000000105c5f7824ULL, 0x100fe400078e024fULL, 0x000000105e657824ULL, 0x000fe200078e024fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000365d7faeULL, 0x0003e2000e101c46ULL,
0x00000001353b7824ULL, 0x040fe400028e063bULL, 0x00000010644f7824ULL, 0x000fe200078e024fULL,
0x00000000385f7faeULL, 0x0003e2000d901c46ULL, 0x0000000135357824ULL, 0x000fc600030e064dULL,
0x000000003a657faeULL, 0x0003e8000d101c46ULL, 0x00000000344f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x0000001036367812ULL, 0x000fe200078ec0ffULL,
0x00000010093a7824ULL, 0x000fc600078e00ffULL, 0x0000003609367211ULL, 0x000fe400078fe8ffULL,
0x000000703a657812ULL, 0x000fc600078ec0ffULL, 0x0000000436387836ULL, 0x000fe40000000000ULL,
0x0000000136377824ULL, 0x140fe400078e0209ULL, 0x00000008364e7824ULL, 0x000fe400078e00ffULL,
0x0000000138397824ULL, 0x040fe400078e0209ULL, 0x00000008385c7824ULL, 0x000fe200078e00ffULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee237ULL, 0x000000014d377824ULL, 0x000fc400078e0236ULL,
0x00000008363a7836ULL, 0x000fe20000000000ULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee239ULL,
0x0000000c364c7836ULL, 0x000fe40000000000ULL, 0x0000008037367825ULL, 0x000fc800078e00ffULL,
0x000000014d387824ULL, 0x040fe200078e0238ULL, 0x00000065364f7212ULL, 0x000fe200078efcffULL,
0x000000014d3b7824ULL, 0x040fe400078e023aULL, 0x000000013a397824ULL, 0x140fe200078e0209ULL,
0x0000004f34367210ULL, 0x000fe20007f1e0ffULL, 0x000000083a5e7824ULL, 0x000fe400078e00ffULL,
0x000000014d4d7824ULL, 0x000fe400078e024cULL, 0x000000014c3a7824ULL, 0x040fe200078e0209ULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee239ULL, 0x000000084c5d7824ULL, 0x000fe200078e00ffULL,
0x00000008614c7c11ULL, 0x000fe2000f8e68ffULL, 0x0000008038387825ULL, 0x000fc600078e00ffULL,
0xfffffff85d647812ULL, 0x000fe200078ee23aULL, 0x000170004c6b7836ULL, 0x000fe20000000000ULL,
0x0000006538697212ULL, 0x000fe200078efcffULL, 0x000000803b3a7825ULL, 0x000fc800078e00ffULL,
0x000000804d4c7825ULL, 0x000fe200078e00ffULL, 0x000000653a677212ULL, 0x000fc600078efcffULL,
0x0000000135377824ULL, 0x040fe200000e0637ULL, 0x000000654c657212ULL, 0x000fe200078efcffULL,
0x000000104e4f7824ULL, 0x100fe200078e026bULL, 0x0000006934387210ULL, 0x000fe20007f1e0ffULL,
0x000000105c5d7824ULL, 0x100fe200078e026bULL, 0x00000067343a7210ULL, 0x000fe20007f5e0ffULL,
0x000000105e5f7824ULL, 0x000fe200078e026bULL, 0x0000006534347210ULL, 0x000fe20007f7e0ffULL,
0x0000000135397824ULL, 0x040fe200000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000364f7faeULL, 0x0003e2000b901c46ULL, 0x00000001353b7824ULL, 0x000fc400010e063bULL,
0x0000001064657824ULL, 0x000fe200078e026bULL, 0x00000000385d7faeULL, 0x0003e2000b901c46ULL,
0x0000000135357824ULL, 0x000fc600018e064dULL, 0x000000003a5f7faeULL, 0x0003e8000b901c46ULL,
0x0000000034657faeULL, 0x0003e4000b901c46ULL, 0x0000000159377836ULL, 0x002fe40000000000ULL,
0xffffffffff7c7424ULL, 0x000fc600078e00ffULL, 0x000000743700720cULL, 0x000fe20003f06070ULL,
0x00000008637a7824ULL, 0x000fca00078e00ffULL, 0xfffffff07a387812ULL, 0x000fca00078ec0ffULL,
0x00000008383a7c36ULL, 0x000fe40008000000ULL, 0x00009200ff348b82ULL, 0x000e620000000a00ULL,
0x0000000108378824ULL, 0x000fe200078e0237ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000003a0472caULL, 0x000fda00000e0000ULL, 0x0001a6b004047890ULL, 0x000fe2000fffe03fULL,
0x0000000437348825ULL, 0x002fd000078e0034ULL, 0x00000000ff0079b0ULL, 0x000fe80008000a44ULL,
0x00000006347c8981ULL, 0x000322000c1e1900ULL, 0xffffffe07a367812ULL, 0x040fe200078ec0ffULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x000000107a377812ULL, 0x000fc800078ec0ffULL,
0x0000000837367c10ULL, 0x000fe4000fffe036ULL, 0x000000087a377812ULL, 0x000fca00078ec0ffULL,
0x0000000136807824ULL, 0x000fe200078e0237ULL, 0x0000000000007918ULL, 0x002fcc0000000000ULL,
0x01a6b0393a8679a7ULL, 0x0002e4000850003fULL, 0x01a60839803879a7ULL, 0x0022a4000850003fULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x01a60839800075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a60839800075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x00000010096d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff707819ULL, 0x000fe20000011609ULL,
0x0000002063347824ULL, 0x000fe400078e00ffULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x000000706d6d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff837224ULL, 0x000fe200078e007eULL,
0xffffff8034347812ULL, 0x000fe400078ec0ffULL, 0x0000000c70707812ULL, 0x000fe400078ec0ffULL,
0x000000086d357c10ULL, 0x000fca000fffe034ULL, 0x0000000135357824ULL, 0x000fca00078e0270ULL,
0x01a0000035377984ULL, 0x000ea80000000800ULL, 0x01a2000035397984ULL, 0x000b620000000800ULL,
0x0000007e3700720bULL, 0x004fda0003f1d000ULL, 0x0000000000367806ULL, 0x000fc800000e0100ULL,
0x000000ff3600720cULL, 0x000fda0003f05270ULL, 0x00000004008c8947ULL, 0x02afea0003800000ULL,
0x000000636000720cULL, 0x000fe40003f45270ULL, 0x0000007e3700720bULL, 0x0c0fe40003f14000ULL,
0x0000007e37837209ULL, 0x000fd20007810000ULL, 0x000000086334ac11ULL, 0x000fe4000f8e38ffULL,
0x0000000000357806ULL, 0x000fe400000e0100ULL, 0x000000347034a210ULL, 0x000fe40007ffe06dULL,
0x000000ff3500720cULL, 0x000fc60003f05270ULL, 0x01a400833400a388ULL, 0x0003f40000000800ULL,
0x0000000400508947ULL, 0x002fea0003800000ULL, 0x0000007e83347221ULL, 0x000fe20000010100ULL,
0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0035ff7812ULL, 0x040fe2000784c0ffULL,
0x3fb8aa3b34347820ULL, 0x000fe20000410000ULL, 0x00ff000035ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000035ff7812ULL, 0x000fe2000788c0ffULL, 0x00000034003b7308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff347819ULL, 0x002fcc0000011609ULL,
0x00001f343b347589ULL, 0x004e6400000e0000ULL, 0x0000003454547220ULL, 0x082fe20000410000ULL,
0x0000003455557220ULL, 0x080fe20000410000ULL, 0x000000343c3c7220ULL, 0x080fe20000410000ULL,
0x000000343d3d7220ULL, 0x080fe20000410000ULL, 0x0000003440407220ULL, 0x080fe20000410000ULL,
0x0000003441417220ULL, 0x080fe20000410000ULL, 0x0000003444447220ULL, 0x080fe20000410000ULL,
0x0000003445457220ULL, 0x080fe20000410000ULL, 0x0000003448487220ULL, 0x080fe20000410000ULL,
0x0000003449497220ULL, 0x080fe20000410000ULL, 0x0000003450507220ULL, 0x080fe20000410000ULL,
0x0000003451517220ULL, 0x080fe20000410000ULL, 0x0000003428287220ULL, 0x080fe20000410000ULL,
0x0000003429297220ULL, 0x080fe20000410000ULL, 0x0000003424247220ULL, 0x080fe20000410000ULL,
0x0000003425257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000000809347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343b347589ULL, 0x004e6400000e0000ULL,
0x0000003456567220ULL, 0x082fe20000410000ULL, 0x0000003457577220ULL, 0x080fe20000410000ULL,
0x000000343e3e7220ULL, 0x080fe20000410000ULL, 0x000000343f3f7220ULL, 0x080fe20000410000ULL,
0x0000003442427220ULL, 0x080fe20000410000ULL, 0x0000003443437220ULL, 0x080fe20000410000ULL,
0x0000003446467220ULL, 0x080fe20000410000ULL, 0x0000003447477220ULL, 0x080fe20000410000ULL,
0x000000344a4a7220ULL, 0x080fe20000410000ULL, 0x000000344b4b7220ULL, 0x080fe20000410000ULL,
0x0000003452527220ULL, 0x080fe20000410000ULL, 0x0000003453537220ULL, 0x080fe20000410000ULL,
0x000000342a2a7220ULL, 0x080fe20000410000ULL, 0x000000342b2b7220ULL, 0x080fe20000410000ULL,
0x0000003426267220ULL, 0x080fe20000410000ULL, 0x0000003427277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x0000001009347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343b347589ULL, 0x004e6400000e0000ULL, 0x000000340c0c7220ULL, 0x082fe20000410000ULL,
0x000000340d0d7220ULL, 0x080fe20000410000ULL, 0x0000003410107220ULL, 0x080fe20000410000ULL,
0x0000003411117220ULL, 0x080fe20000410000ULL, 0x0000003414147220ULL, 0x080fe20000410000ULL,
0x0000003415157220ULL, 0x080fe20000410000ULL, 0x0000003418187220ULL, 0x080fe20000410000ULL,
0x0000003419197220ULL, 0x080fe20000410000ULL, 0x000000341c1c7220ULL, 0x080fe20000410000ULL,
0x000000341d1d7220ULL, 0x080fe20000410000ULL, 0x0000003420207220ULL, 0x080fe20000410000ULL,
0x0000003421217220ULL, 0x080fe20000410000ULL, 0x0000003430307220ULL, 0x080fe20000410000ULL,
0x0000003431317220ULL, 0x080fe20000410000ULL, 0x000000342c2c7220ULL, 0x080fe20000410000ULL,
0x000000342d2d7220ULL, 0x000fce0000410000ULL, 0x0000003b82827220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x0000001809347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343b347589ULL, 0x000e6400000e0000ULL, 0x000000340e0e7220ULL, 0x082fe20000410000ULL,
0x000000340f0f7220ULL, 0x080fe20000410000ULL, 0x0000003412127220ULL, 0x080fe20000410000ULL,
0x0000003413137220ULL, 0x080fe20000410000ULL, 0x0000003416167220ULL, 0x080fe20000410000ULL,
0x0000003417177220ULL, 0x080fe20000410000ULL, 0x000000341a1a7220ULL, 0x080fe20000410000ULL,
0x000000341b1b7220ULL, 0x080fe20000410000ULL, 0x000000341e1e7220ULL, 0x080fe20000410000ULL,
0x000000341f1f7220ULL, 0x080fe20000410000ULL, 0x0000003422227220ULL, 0x080fe20000410000ULL,
0x0000003423237220ULL, 0x080fe20000410000ULL, 0x0000003432327220ULL, 0x080fe20000410000ULL,
0x0000003433337220ULL, 0x080fe20000410000ULL, 0x000000342e2e7220ULL, 0x080fe20000410000ULL,
0x000000342f2f7220ULL, 0x000fce0000410000ULL, 0x0000003536ff7212ULL, 0x000fda00078030ffULL,
0x8000008337370221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b37370820ULL, 0x000fc80000410000ULL, 0x0000003700040308ULL, 0x000ea40000000800ULL,
0x0000000439390220ULL, 0x004fce0000410000ULL, 0x0000008239827221ULL, 0x000fce0000010000ULL,
0x0000000000347805ULL, 0x002fce0000015200ULL, 0x01a6a8793a0075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3b7224ULL, 0x000fce00078e00ffULL,
0x000000103b00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x0000003634397210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003936367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013b3b7836ULL, 0x000fce0000000000ULL,
0x01a6a8793a0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000040063347824ULL, 0x000fe200078e00ffULL, 0x0000991038357816ULL, 0x000fe200000000ffULL,
0x00000008ff797e24ULL, 0x000fe2000f8e00ffULL, 0x00000008096c7812ULL, 0x000fe200078ec0ffULL,
0x0000000263817824ULL, 0x000fe200078e00ffULL, 0xfffff00034347812ULL, 0x000fe200078ec0ffULL,
0x00000008ff377e24ULL, 0x000fe2000f8e00ffULL, 0x000000ff3500720cULL, 0x000fe20003f05270ULL,
0x0000100063357824ULL, 0x000fe200078e00ffULL, 0x0001200079797810ULL, 0x000fe20007ffe034ULL,
0x0000000463347824ULL, 0x000fe200078e00ffULL, 0x0000000481727812ULL, 0x000fc400078ec0ffULL,
0x000000076c6c7812ULL, 0x000fe400078ef809ULL, 0xffffe00035367812ULL, 0x000fe400078ec0ffULL,
0x0000007209357211ULL, 0x000fe200078fe0ffULL, 0x000000086c6f7824ULL, 0x040fe200078e00ffULL,
0x000000106c787812ULL, 0x000fe400078efcffULL, 0x0000000434347812ULL, 0x000fe200078ec0ffULL,
0x000000016c7f7824ULL, 0x040fe200078e0235ULL, 0x00016000375e7810ULL, 0x000fe20007ffe036ULL,
0x00000001357e7824ULL, 0x000fe200078e0278ULL, 0x00000034097d7211ULL, 0x000fe200078fe0ffULL,
0x000000086c347824ULL, 0x000fc400078e00ffULL, 0x0000000878357824ULL, 0x000fe400078e00ffULL,
0x000000016c5c7824ULL, 0x000fe200078e027dULL, 0xfffffff8347f7812ULL, 0x000fe400078ee27fULL,
0xfffffff8357e7812ULL, 0x000fe400078ee27eULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee25cULL,
0x000000107f367824ULL, 0x100fe400078e0279ULL, 0x000000107e387824ULL, 0x000fe200078e0279ULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe40000011609ULL,
0x00000004ff00723eULL, 0x000fc600000000ffULL, 0x0000001003057836ULL, 0x000fe20000000000ULL,
0x0000541000347816ULL, 0x000fe20000000000ULL, 0x0000000803357836ULL, 0x000fe40000000000ULL,
0x0000001803377836ULL, 0x000fe40000000000ULL, 0x00001f0534057589ULL, 0x0002a800000e0000ULL,
0x00001f3534027589ULL, 0x0002e800000e0000ULL, 0x00001f0334037589ULL, 0x00026800000e0000ULL,
0x00001f3734007589ULL, 0x00026400000e0000ULL, 0x000000003634783bULL, 0x002e620000000200ULL,
0x000000106f4c7824ULL, 0x000fc600078e025eULL, 0x000000003838783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x088fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x0000000538387232ULL, 0x084fe40000000000ULL,
0x000000053a3a7232ULL, 0x000fc40000000000ULL, 0x0000000039397232ULL, 0x080fe40000000000ULL,
0x000000003b3b7232ULL, 0x000fce0000000000ULL, 0x000000086c647824ULL, 0x000fe200078e00ffULL,
0x000000004c4c783bULL, 0x000f620000004200ULL, 0x000000025c7b7836ULL, 0x000fe20000000000ULL,
0x0000000272727812ULL, 0x000fc800078efcffULL, 0xfffffff8647b7812ULL, 0x000fca00078ee27bULL,
0x000000107b5e7824ULL, 0x000fcc00078e025eULL, 0x000000005e5c783bULL, 0x000f640000004200ULL,
0x00000018ff677819ULL, 0x028fe4000001164fULL, 0x00000010ff917819ULL, 0x000fe4000001164cULL,
0x00000018ff657819ULL, 0x000fe4000001164eULL, 0x0000ffff4d8c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff927819ULL, 0x000fc4000001164dULL, 0x0000ffff4e8d7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff4c6a7812ULL, 0x040fe400078ec0ffULL, 0x000000ff4c907812ULL, 0x000fe400078ec0ffULL,
0x000000ff91917812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6b7819ULL, 0x004fe4000001165dULL,
0x000000ff5d947812ULL, 0x000fc400078ec0ffULL, 0x000000ff5e957812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe4000001165fULL, 0x000000ff5f967812ULL, 0x040fe400078ec0ffULL,
0x00000018ff687819ULL, 0x000fe4000001165fULL, 0x0000ffff5f717812ULL, 0x000fe400078ec0ffULL,
0x00000010ff887819ULL, 0x000fc4000001165eULL, 0x00000018ff937819ULL, 0x000fe4000001165eULL,
0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL, 0x00000067ff5f723eULL, 0x000fe400020006ffULL,
0x00000065ff5e723eULL, 0x000fe400020006ffULL, 0x0000006bff67723eULL, 0x000fe400020006ffULL,
0x00000094ff65723eULL, 0x000fc400020006ffULL, 0x00000095ff6b723eULL, 0x000fe400020006ffULL,
0x00000008ff8c7819ULL, 0x000fe4000001168cULL, 0x00000018ff8a7819ULL, 0x000fe4000001164cULL,
0x000000ff4d8f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fe4000001164dULL,
0x000000ff92947812ULL, 0x000fc400078ec0ffULL, 0x00000008ff957819ULL, 0x000fe4000001168dULL,
0x00000010ff4d7819ULL, 0x000fe4000001164eULL, 0x0000ffff4f4c7812ULL, 0x040fe400078ec0ffULL,
0x00000008ff927819ULL, 0x000fe4000001166aULL, 0x000000ff4e897812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f697812ULL, 0x000fc400078ec0ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000093ff6a723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001165cULL, 0x0000008cff93723eULL, 0x000fe400020006ffULL,
0x00000010ff8e7819ULL, 0x000fc4000001164fULL, 0x00000095ff8c723eULL, 0x000fe400020006ffULL,
0x00000010ff4f7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d857812ULL, 0x000fe400078ec0ffULL,
0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff957819ULL, 0x000fe4000001164cULL,
0x000000ff5c847812ULL, 0x000fc400078ec0ffULL, 0x00000018ff737819ULL, 0x000fe4000001165cULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000069ff5d723eULL, 0x000fe400020006ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00005410904c7816ULL, 0x000fe40000000091ULL,
0x0000ffff5c5c7812ULL, 0x000fc400078ec0ffULL, 0x00000096ff69723eULL, 0x000fe400020006ffULL,
0x000000ff4e907812ULL, 0x000fe400078ec0ffULL, 0x000000ff8e967812ULL, 0x000fe400078ec0ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x0000004dff8e723eULL, 0x000fe400020006ffULL,
0x00005410924e7816ULL, 0x000fc4000000008aULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000008ff8a7819ULL, 0x000fe4000001165cULL,
0x00005410895c7816ULL, 0x000fe4000000008eULL, 0x000000ff64897812ULL, 0x000fe400078ec0ffULL,
0x0000008fff8f723eULL, 0x000fc400020006ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x000000ff88887812ULL, 0x000fe400078ec0ffULL, 0x0000541084647816ULL, 0x000fe40000000090ULL,
0x000000ff4f917812ULL, 0x000fc400078ec0ffULL, 0x00000008ff857819ULL, 0x000fe40000011685ULL,
0x00000008ff847819ULL, 0x000fe40000011666ULL, 0x00000008ff717819ULL, 0x000fe40000011671ULL,
0x000054108f4d7816ULL, 0x000fe40000000094ULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x000054108a667816ULL, 0x000fc40000000073ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x0000004c3454723cULL, 0x002fe20000001854ULL, 0x00000096ff8d723eULL, 0x000fe400020006ffULL,
0x00000095ff8f723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x0000004c380c723cULL, 0x000fe2000000180cULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fc400020006ffULL, 0x00000068ff73723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x000054106b687816ULL, 0x000fe40000000088ULL, 0x00005410934f7816ULL, 0x000fe4000000008bULL,
0x000054105d5d7816ULL, 0x000fc4000000008dULL, 0x000054108c5e7816ULL, 0x000fe4000000005eULL,
0x000054108f5f7816ULL, 0x000fe2000000005fULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x0000541065657816ULL, 0x000fe40000000091ULL, 0x0000541085677816ULL, 0x000fe40000000067ULL,
0x0000541069697816ULL, 0x000fe20000000089ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x00005410846a7816ULL, 0x000fc4000000006aULL, 0x00005410716b7816ULL, 0x000fe40000000073ULL,
0x0000000861737c11ULL, 0x000fe2000f8e68ffULL, 0x0000005e3444723cULL, 0x000fe80000001844ULL,
0x0001600073847836ULL, 0x000fe40000000000ULL, 0x000000643448723cULL, 0x000fec0000001848ULL,
0x000000663450723cULL, 0x000fec0000001850ULL, 0x000000683428723cULL, 0x000fec0000001828ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x0000005c3814723cULL, 0x000fe20000001814ULL,
0x0000007209357211ULL, 0x000fe200078fe0ffULL, 0x000000086c347824ULL, 0x000fc400078e00ffULL,
0x0000000878377824ULL, 0x000fe400078e00ffULL, 0x000000016c717824ULL, 0x100fe200078e0235ULL,
0x0000004e3810723cULL, 0x000fe20000001810ULL, 0x0000000178727824ULL, 0x040fe400078e0235ULL,
0x00000001785c7824ULL, 0x040fe200078e027dULL, 0xfffffff834717812ULL, 0x000fe200078ee271ULL,
0x00000008787d7824ULL, 0x000fe200078e00ffULL, 0xfffffff837727812ULL, 0x000fe200078ee272ULL,
0x0000005e3818723cULL, 0x000fe40000001818ULL, 0x0000001071347824ULL, 0x100fe200078e0279ULL,
0xfffffff87d7d7812ULL, 0x000fe200078ee25cULL, 0x0000001072797824ULL, 0x000fc400078e0279ULL,
0x00000064381c723cULL, 0x000fe4000000181cULL, 0x000000003434783bULL, 0x000e620000000200ULL,
0x000000107d4c7824ULL, 0x000fc600078e0284ULL, 0x000000663820723cULL, 0x000fec0000001820ULL,
0x000000683830723cULL, 0x000fec0000001830ULL, 0x0000006a3838723cULL, 0x000fe2000000182cULL,
0x00000000792c783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x080fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x088fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x00000008785e7824ULL, 0x000fe200078e00ffULL,
0x000000004c4c783bULL, 0x000f620000004200ULL, 0x000000025c797836ULL, 0x004fe20000000000ULL,
0xfffffff881817812ULL, 0x000fc800078ec0ffULL, 0xfffffff85e797812ULL, 0x000fca00078ee279ULL,
0x00000010795c7824ULL, 0x000fcc00078e0284ULL, 0x000000005c5c783bULL, 0x000ea20000004200ULL,
0x00000018ff677819ULL, 0x020fe4000001164fULL, 0x00000010ff957819ULL, 0x100fe4000001164dULL,
0x000000ff4d937812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001164dULL,
0x00000018ff657819ULL, 0x000fe4000001164eULL, 0x00000010ff947819ULL, 0x000fc4000001164cULL,
0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4c6a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff94947812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6b7819ULL, 0x004fe4000001165dULL,
0x000000ff5e987812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x000fc4000001165fULL,
0x000000ff5f997812ULL, 0x040fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe4000001165fULL,
0x0000ffff5f857812ULL, 0x000fe400078ec0ffULL, 0x00000067ff5f723eULL, 0x000fe400020006ffULL,
0x0000006bff67723eULL, 0x000fe400020006ffULL, 0x000000ff5d977812ULL, 0x000fc400078ec0ffULL,
0x00000098ff6b723eULL, 0x000fe400020006ffULL, 0x000000ff95987812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8b7819ULL, 0x100fe4000001165eULL, 0x00000018ff967819ULL, 0x000fe4000001165eULL,
0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL, 0x00000065ff5e723eULL, 0x000fc400020006ffULL,
0x00000097ff65723eULL, 0x000fe400020006ffULL, 0x00000008ff4d7819ULL, 0x000fe4000001164dULL,
0x00000018ff8f7819ULL, 0x000fe4000001164cULL, 0x00000010ff8d7819ULL, 0x000fe4000001164eULL,
0x000000ff4e8c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4e917812ULL, 0x000fc400078ec0ffULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x00000008ff977819ULL, 0x000fe4000001166aULL,
0x00000098ff98723eULL, 0x000fe400020006ffULL, 0x00000010ff4e7819ULL, 0x000fe4000001165cULL,
0x00000096ff6a723eULL, 0x000fe400020006ffULL, 0x00000094ff95723eULL, 0x000fc400020006ffULL,
0x0000004dff96723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000097ff94723eULL, 0x000fe400020006ffULL, 0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL,
0x00005410934d7816ULL, 0x000fe40000000098ULL, 0x000000ff5c897812ULL, 0x000fc400078ec0ffULL,
0x00000018ff887819ULL, 0x000fe4000001165cULL, 0x000000ff4e937812ULL, 0x000fe400078ec0ffULL,
0x000000ff4c927812ULL, 0x000fe400078ec0ffULL, 0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff977819ULL, 0x000fe40000011691ULL, 0x0000008cff8c723eULL, 0x000fc400020006ffULL,
0x0000008dff91723eULL, 0x000fe400020006ffULL, 0x00005410944e7816ULL, 0x000fe4000000008fULL,
0x0000ffff4f4c7812ULL, 0x040fe400078ec0ffULL, 0x00000093ff8f723eULL, 0x000fe400020006ffULL,
0x00000010ff907819ULL, 0x000fe4000001164fULL, 0x000000ff4f697812ULL, 0x000fc400078ec0ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000008ff937819ULL, 0x000fe4000001165cULL, 0x00000010ff4f7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d8a7812ULL, 0x000fe400078ec0ffULL, 0x00000097ff8d723eULL, 0x000fc400020006ffULL,
0x000054108c5c7816ULL, 0x000fe40000000091ULL, 0x00000008ff977819ULL, 0x000fe4000001164cULL,
0x000000ff648c7812ULL, 0x000fe400078ec0ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00005410924c7816ULL, 0x000fc40000000095ULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x0000541089647816ULL, 0x000fe2000000008fULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x000000ff90907812ULL, 0x000fe400078ec0ffULL, 0x000000ff4f957812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8a7819ULL, 0x000fe2000001168aULL, 0x0000004c2c0c723cULL, 0x008fe2000000180cULL,
0x00000008ff897819ULL, 0x000fc40000011666ULL, 0x00000008ff857819ULL, 0x000fe40000011685ULL,
0x00000069ff5d723eULL, 0x000fe400020006ffULL, 0x00005410964f7816ULL, 0x000fe4000000008eULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x0000541093667816ULL, 0x000fe40000000088ULL,
0x00000099ff69723eULL, 0x000fe200020006ffULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x00000090ff90723eULL, 0x000fc400020006ffULL, 0x00000097ff92723eULL, 0x000fe400020006ffULL,
0x00000095ff8e723eULL, 0x000fe200020006ffULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000068ff88723eULL, 0x000fe400020006ffULL, 0x00000089ff89723eULL, 0x000fc400020006ffULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x000054106b687816ULL, 0x000fe4000000008bULL,
0x000054105d5d7816ULL, 0x000fe40000000090ULL, 0x000054108d5e7816ULL, 0x000fe4000000005eULL,
0x00005410925f7816ULL, 0x000fe4000000005fULL, 0x0000541065657816ULL, 0x000fe2000000008eULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x000054108a677816ULL, 0x000fc40000000067ULL,
0x0000541069697816ULL, 0x000fe4000000008cULL, 0x00005410896a7816ULL, 0x000fe2000000006aULL,
0x0000005e3444723cULL, 0x000fe20000001844ULL, 0x00005410856b7816ULL, 0x000fca0000000088ULL,
0x000000643448723cULL, 0x000fec0000001848ULL, 0x000000663450723cULL, 0x000fec0000001850ULL,
0x000000683428723cULL, 0x000fec0000001828ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x0000000861347c11ULL, 0x000fe2000f8e18ffULL,
0x00000001ff367424ULL, 0x000fc800078e00ffULL, 0x0000005e2c18723cULL, 0x000fe20000001818ULL,
0x01a6c836343479a7ULL, 0x0002aa000850003fULL, 0x000000642c1c723cULL, 0x000fe2000000181cULL,
0x01a6883681ff79a7ULL, 0x0003ea0008500008ULL, 0x000000662c20723cULL, 0x000fec0000001820ULL,
0x000000682c30723cULL, 0x000fec0000001830ULL, 0x0000006a2c38723cULL, 0x002fde0000001838ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x00000035060075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000372e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00009000ff2c7b82ULL, 0x000e620000000a00ULL,
0x00000010632e7824ULL, 0x000fe200078e00ffULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x000000047c7c7c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe02e347812ULL, 0x000fe400078ec0ffULL,
0x000000407c357824ULL, 0x000fc600078e00ffULL, 0x0000010007347824ULL, 0x000fc800078e0234ULL,
0x0000008034377836ULL, 0x000fca0000000000ULL, 0x00000020372f7812ULL, 0x000fe200078ec0ffULL,
0x00000080352c7825ULL, 0x002fc800078e002cULL, 0x000000015a4e7824ULL, 0x000fe200078e022fULL,
0x0000000000f49947ULL, 0x000fec0003800000ULL, 0x000000102e2f7812ULL, 0x000fe400078ec0ffULL,
0x00000037762e7248ULL, 0x000fe40007fe0000ULL, 0x00000003ff347819ULL, 0x000fc60000011609ULL,
0x000000012e2e7824ULL, 0x000fe400078e0a37ULL, 0x0000000134357824ULL, 0x000fe400078e022fULL,
0x0000000434377836ULL, 0x000fe20000000000ULL, 0x0000002e2f2e7248ULL, 0x000fe20007fe0000ULL,
0x0000000135367824ULL, 0x040fe400078e0209ULL, 0x00000008355d7824ULL, 0x000fe400078e00ffULL,
0x000000012e2e7824ULL, 0x000fc400078e0a2fULL, 0x0000000c344d7836ULL, 0x000fe20000000000ULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee236ULL, 0x0000000834367836ULL, 0x000fe20000000000ULL,
0x0000002e3700720cULL, 0x0c0fe20003f66070ULL, 0x0000000137377824ULL, 0x100fe200078e022fULL,
0x0000002e3400720cULL, 0x080fe20003f86070ULL, 0x0000000135347824ULL, 0x100fe200078e024eULL,
0x0000002e3600720cULL, 0x0c0fe20003f46070ULL, 0x0000000136367824ULL, 0x000fe200078e022fULL,
0x0000002e4d00720cULL, 0x000fe20003f06070ULL, 0x00000001374c7824ULL, 0x000fc400078e024eULL,
0x0000000136357824ULL, 0x040fe400078e0209ULL, 0x0000000836647824ULL, 0x000fe400078e00ffULL,
0x000000014d5c7824ULL, 0x000fe400078e022fULL, 0x00000001372f7824ULL, 0x040fe200078e0209ULL,
0xfffffff864697812ULL, 0x000fe200078ee235ULL, 0x00000008375e7824ULL, 0x000fe400078e00ffULL,
0x000000804c4c7825ULL, 0x000fc600078e00ffULL, 0xfffffff85e677812ULL, 0x000fe200078ee22fULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000006d4c2f7212ULL, 0x000fc600078efcffULL,
0x0000000136367824ULL, 0x100fe200078e024eULL, 0x0000006d344f7212ULL, 0x000fe200078efcffULL,
0x000000015c2e7824ULL, 0x000fe200078e024eULL, 0x0000002f2c4c7210ULL, 0x000fe20007fde0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004f2c347210ULL, 0x000fc60007fbe0ffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000006d36657212ULL, 0x000fc600078efcffULL,
0x000000015c4e7824ULL, 0x000fe200078e0209ULL, 0x0000006d2e5f7212ULL, 0x000fe200078efcffULL,
0x000000085c6b7824ULL, 0x000fe400078e00ffULL, 0x000000012d357824ULL, 0x040fe200028e0635ULL,
0x000000652c367210ULL, 0x000fe20007fbe0ffULL, 0x000000012d4d7824ULL, 0x000fe200030e064dULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee24eULL, 0x000000105d4f7824ULL, 0x100fe200078e0284ULL,
0x0000005f2c2c7210ULL, 0x000fe20007fde0ffULL, 0x00000010675d7824ULL, 0x000fc400078e0284ULL,
0x00000010695f7824ULL, 0x100fe200078e0284ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000344f7faeULL, 0x0003e2000e101c46ULL, 0x000000012d377824ULL, 0x000fe400028e0637ULL,
0x000000106b657824ULL, 0x000fe200078e0284ULL, 0x000000004c5d7faeULL, 0x0003e2000d901c46ULL,
0x000000012d2d7824ULL, 0x000fc600030e062fULL, 0x00000000365f7faeULL, 0x0003e8000d101c46ULL,
0x000000002c657faeULL, 0x0003e2000c101c46ULL, 0x0000000000c07947ULL, 0x000fea0003800000ULL,
0x000000102e2e7812ULL, 0x000fc800078ec0ffULL, 0x0000002e092f7211ULL, 0x000fca00078fe8ffULL,
0x000000012f347824ULL, 0x040fe400078e0209ULL, 0x000000082f4f7824ULL, 0x040fe400078e00ffULL,
0x000000012f2e7824ULL, 0x000fe400078e024eULL, 0x000000042f357836ULL, 0x000fe20000000000ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee234ULL, 0x000000082f4d7836ULL, 0x000fe40000000000ULL,
0x0000000c2f5c7836ULL, 0x000fc40000000000ULL, 0x000000802e2e7825ULL, 0x000fc800078e00ffULL,
0x0000000135367824ULL, 0x100fe400078e024eULL, 0x000000014d4c7824ULL, 0x140fe400078e024eULL,
0x000000015c347824ULL, 0x000fe400078e024eULL, 0x000000014d4e7824ULL, 0x140fe400078e0209ULL,
0x000000084d5f7824ULL, 0x000fe400078e00ffULL, 0x0000000135377824ULL, 0x000fc400078e0209ULL,
0x00000008355e7824ULL, 0x000fe200078e00ffULL, 0x0000006d2e357212ULL, 0x080fe200078efcffULL,
0x000000015c4d7824ULL, 0x040fe200078e0209ULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee24eULL,
0x000000085c5c7824ULL, 0x000fe200078e00ffULL, 0xfffffff85e5d7812ULL, 0x000fe200078ee237ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000000352c2e7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff85c6b7812ULL, 0x000fe200078ee24dULL, 0x000000804c4c7825ULL, 0x000fe200078e00ffULL,
0x0000006d36697212ULL, 0x000fc600078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000006d4c677212ULL, 0x000fc600078efcffULL, 0x000000012d2f7824ULL, 0x000fe200000e062fULL,
0x0000006d34657212ULL, 0x000fe200078efcffULL, 0x000000104f4f7824ULL, 0x100fe200078e0284ULL,
0x000000692c367210ULL, 0x000fe20007f1e0ffULL, 0x000000105d5d7824ULL, 0x100fe200078e0284ULL,
0x000000672c4c7210ULL, 0x000fe20007f5e0ffULL, 0x000000105f5f7824ULL, 0x000fe200078e0284ULL,
0x000000652c2c7210ULL, 0x000fe20007f7e0ffULL, 0x000000012d377824ULL, 0x040fe200000e0637ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e4f7faeULL, 0x0003e2000b901c46ULL,
0x000000012d4d7824ULL, 0x000fc400010e064dULL, 0x000000106b657824ULL, 0x000fe200078e0284ULL,
0x00000000365d7faeULL, 0x0003e2000b901c46ULL, 0x000000012d2d7824ULL, 0x000fc600018e0635ULL,
0x000000004c5f7faeULL, 0x0003e8000b901c46ULL, 0x000000002c657faeULL, 0x0003e4000b901c46ULL,
0x00000002592f7836ULL, 0x002fe40000000000ULL, 0xffffffffff817424ULL, 0x000fc600078e00ffULL,
0x000000742f00720cULL, 0x000fe40003f06070ULL, 0xfffffff07a7a7812ULL, 0x000fca00078ec0ffULL,
0x000000087a887c36ULL, 0x000fe20008000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00009200ff2c8b82ULL, 0x000e620000000a00ULL, 0x00000000880472caULL, 0x000fe200000e0000ULL,
0x00000001082f8824ULL, 0x000fd800078e022fULL, 0x0001a6a804047890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x000000042f2c8825ULL, 0x002fca00078e002cULL,
0x000000062c818981ULL, 0x000322000c1e1900ULL, 0x00000001ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x01a6a82f888879a7ULL, 0x0004e4000850003fULL,
0x01a6282f802e79a7ULL, 0x004464000850003fULL, 0x00000000002c7805ULL, 0x002fce0000015200ULL,
0x01a6282f800075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x000000342c377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6282f800075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000020632c7824ULL, 0x000fe400078e00ffULL,
0x00000008ff2d7e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0xffffff802c2c7812ULL, 0x000fc800078ec0ffULL, 0x000000802d2c7810ULL, 0x000fc80007ffe02cULL,
0x0000002c702c7210ULL, 0x000fca0007ffe06dULL, 0x01a000002c2e7984ULL, 0x000e680000000800ULL,
0x01a200002c2d7984ULL, 0x000b620000000800ULL, 0x000000832e00720bULL, 0x002fda0003f1d000ULL,
0x00000000002f7806ULL, 0x000fc800000e0100ULL, 0x000000ff2f00720cULL, 0x000fda0003f05270ULL,
0x00000004009c8947ULL, 0x02cfea0003800000ULL, 0x00000001602c7836ULL, 0x000fe20000000000ULL,
0x000000832e00720bULL, 0x000fc80003f14000ULL, 0x000000632c00720cULL, 0x000fda0003f45270ULL,
0x000000086334ac11ULL, 0x000fe4000f8e38ffULL, 0x000000832e2ca209ULL, 0x000fe40007810000ULL,
0x000000347035a210ULL, 0x000fe40007ffe06dULL, 0x0000000000347806ULL, 0x000fc600000e0100ULL,
0x01a4002c3500a388ULL, 0x0003e20000000800ULL, 0x000000ff3400720cULL, 0x000fda0003f05270ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x000000832e2c7209ULL, 0x000fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x000000832c2c7221ULL, 0x000fe20000010100ULL, 0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000034ff7812ULL, 0x000fe2000788c0ffULL, 0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL,
0x0000002c00357308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff2c7819ULL, 0x002fcc0000011609ULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x000000542c547220ULL, 0x042fe20000410000ULL, 0x000000552c557220ULL, 0x040fe20000410000ULL,
0x0000003c2c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d2c3d7220ULL, 0x040fe20000410000ULL,
0x000000402c407220ULL, 0x040fe20000410000ULL, 0x000000412c417220ULL, 0x040fe20000410000ULL,
0x000000442c447220ULL, 0x040fe20000410000ULL, 0x000000452c457220ULL, 0x040fe20000410000ULL,
0x000000482c487220ULL, 0x040fe20000410000ULL, 0x000000492c497220ULL, 0x040fe20000410000ULL,
0x000000502c507220ULL, 0x040fe20000410000ULL, 0x000000512c517220ULL, 0x040fe20000410000ULL,
0x000000282c287220ULL, 0x040fe20000410000ULL, 0x000000292c297220ULL, 0x040fe20000410000ULL,
0x000000242c247220ULL, 0x040fe20000410000ULL, 0x000000252c257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x00000008092c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x000000562c567220ULL, 0x042fe20000410000ULL,
0x000000572c577220ULL, 0x040fe20000410000ULL, 0x0000003e2c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f2c3f7220ULL, 0x040fe20000410000ULL, 0x000000422c427220ULL, 0x040fe20000410000ULL,
0x000000432c437220ULL, 0x040fe20000410000ULL, 0x000000462c467220ULL, 0x040fe20000410000ULL,
0x000000472c477220ULL, 0x040fe20000410000ULL, 0x0000004a2c4a7220ULL, 0x040fe20000410000ULL,
0x0000004b2c4b7220ULL, 0x040fe20000410000ULL, 0x000000522c527220ULL, 0x040fe20000410000ULL,
0x000000532c537220ULL, 0x040fe20000410000ULL, 0x0000002a2c2a7220ULL, 0x040fe20000410000ULL,
0x0000002b2c2b7220ULL, 0x040fe20000410000ULL, 0x000000262c267220ULL, 0x040fe20000410000ULL,
0x000000272c277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x00000010092c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x0000000c2c0c7220ULL, 0x042fe20000410000ULL, 0x0000000d2c0d7220ULL, 0x040fe20000410000ULL,
0x000000102c107220ULL, 0x040fe20000410000ULL, 0x000000112c117220ULL, 0x040fe20000410000ULL,
0x000000142c147220ULL, 0x040fe20000410000ULL, 0x000000152c157220ULL, 0x040fe20000410000ULL,
0x000000182c187220ULL, 0x040fe20000410000ULL, 0x000000192c197220ULL, 0x040fe20000410000ULL,
0x0000001c2c1c7220ULL, 0x040fe20000410000ULL, 0x0000001d2c1d7220ULL, 0x040fe20000410000ULL,
0x000000202c207220ULL, 0x040fe20000410000ULL, 0x000000212c217220ULL, 0x040fe20000410000ULL,
0x000000302c307220ULL, 0x040fe20000410000ULL, 0x000000312c317220ULL, 0x040fe20000410000ULL,
0x000000382c387220ULL, 0x040fe20000410000ULL, 0x000000392c397220ULL, 0x000fce0000410000ULL,
0x0000003582827220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x00000018092c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x000e6400000e0000ULL,
0x0000000e2c0e7220ULL, 0x042fe20000410000ULL, 0x0000000f2c0f7220ULL, 0x040fe20000410000ULL,
0x000000122c127220ULL, 0x040fe20000410000ULL, 0x000000132c137220ULL, 0x040fe20000410000ULL,
0x000000162c167220ULL, 0x040fe20000410000ULL, 0x000000172c177220ULL, 0x040fe20000410000ULL,
0x0000001a2c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b2c1b7220ULL, 0x040fe20000410000ULL,
0x0000001e2c1e7220ULL, 0x040fe20000410000ULL, 0x0000001f2c1f7220ULL, 0x040fe20000410000ULL,
0x000000222c227220ULL, 0x040fe20000410000ULL, 0x000000232c237220ULL, 0x040fe20000410000ULL,
0x000000322c327220ULL, 0x040fe20000410000ULL, 0x000000332c337220ULL, 0x040fe20000410000ULL,
0x0000003a2c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b2c3b7220ULL, 0x000fce0000410000ULL,
0x000000342fff7212ULL, 0x000fe200078030ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x000000832e837209ULL, 0x000fd60007810000ULL, 0x800000832e2e0221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL,
0x0000002e00040308ULL, 0x000ea40000000800ULL, 0x000000042d2d0220ULL, 0x004fce0000410000ULL,
0x000000822d827221ULL, 0x000fce0000010000ULL, 0x00000000002c7805ULL, 0x002fce0000015200ULL,
0x00000008632e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2f7812ULL, 0x000fc800078ec0ffULL,
0x01a6b0872f0075a7ULL, 0x000e620008000148ULL, 0x000000082f377c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6b087370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009910342c7816ULL, 0x000fe200000000ffULL, 0x00000400632d7824ULL, 0x040fe400078e00ffULL,
0x00001000632e7824ULL, 0x000fe200078e00ffULL, 0x000000ff2c00720cULL, 0x000fe20003f05270ULL,
0x00000008ff7c7e24ULL, 0x000fe2000f8e00ffULL, 0xfffff0002d2d7812ULL, 0x000fe200078ec0ffULL,
0x00000008ff2f7e24ULL, 0x000fe2000f8e00ffULL, 0xffffe0002e2e7812ULL, 0x000fe400078ec0ffULL,
0x000130007c7c7810ULL, 0x000fc40007ffe02dULL, 0x000170002f5c7810ULL, 0x000fc60007ffe02eULL,
0x000000107f347824ULL, 0x100fe400078e027cULL, 0x000000107e2c7824ULL, 0x000fe400078e027cULL,
0x000000106f4c7824ULL, 0x000fe200078e025cULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff2e7819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000000ffULL,
0x000000082e027836ULL, 0x000fe20000000000ULL, 0x00005410002d7816ULL, 0x000fe20000000000ULL,
0x000000102e367836ULL, 0x000fe40000000000ULL, 0x000000182e4e7836ULL, 0x000fe40000000000ULL,
0x00001f022d027589ULL, 0x0002a800000e0000ULL, 0x00001f362d057589ULL, 0x0002e800000e0000ULL,
0x00001f2e2d037589ULL, 0x00026800000e0000ULL, 0x00001f4e2d007589ULL, 0x00026400000e0000ULL,
0x000000003434783bULL, 0x002e680000000200ULL, 0x000000002c2c783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x084fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x088fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000107b5c7824ULL, 0x000fe200078e025cULL,
0x000000004c4c783bULL, 0x000f6a0000004200ULL, 0x000000005c5c783bULL, 0x000f640000004200ULL,
0x00000018ff657819ULL, 0x028fe4000001164eULL, 0x00000010ff927819ULL, 0x000fc4000001164cULL,
0x00000018ff677819ULL, 0x000fe4000001164fULL, 0x000000ff5d957812ULL, 0x004fe400078ec0ffULL,
0x0000ffff4c6a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001165dULL,
0x00000010ff867819ULL, 0x000fe4000001165eULL, 0x000000ff5e967812ULL, 0x000fc400078ec0ffULL,
0x00000018ff947819ULL, 0x000fe4000001165eULL, 0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL,
0x00000010ff937819ULL, 0x000fe4000001164dULL, 0x00000010ff647819ULL, 0x100fe4000001165fULL,
0x000000ff5f977812ULL, 0x000fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fc4000001165fULL,
0x0000ffff5f7a7812ULL, 0x000fe400078ec0ffULL, 0x00000065ff5e723eULL, 0x000fe400020006ffULL,
0x00000067ff5f723eULL, 0x000fe400020006ffULL, 0x00000095ff65723eULL, 0x000fe400020006ffULL,
0x000000ff92927812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4d8d7812ULL, 0x000fc400078ec0ffULL,
0x0000006bff67723eULL, 0x000fe400020006ffULL, 0x00000008ff957819ULL, 0x000fe4000001166aULL,
0x0000ffff4e8e7812ULL, 0x000fe400078ec0ffULL, 0x00000096ff6b723eULL, 0x000fe400020006ffULL,
0x000000ff93967812ULL, 0x000fe400078ec0ffULL, 0x000000ff4c917812ULL, 0x000fc400078ec0ffULL,
0x00000092ff93723eULL, 0x000fe400020006ffULL, 0x00000095ff92723eULL, 0x000fe400020006ffULL,
0x00000008ff8d7819ULL, 0x000fe4000001168dULL, 0x00000018ff8b7819ULL, 0x000fe4000001164cULL,
0x000000ff4d907812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8c7819ULL, 0x000fc4000001164dULL,
0x00000008ff957819ULL, 0x000fe4000001168eULL, 0x00000010ff4d7819ULL, 0x000fe4000001164eULL,
0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e8a7812ULL, 0x000fe400078ec0ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000094ff6a723eULL, 0x000fc400020006ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001165cULL, 0x0000008dff94723eULL, 0x000fe400020006ffULL,
0x00000095ff8d723eULL, 0x000fe400020006ffULL, 0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff957819ULL, 0x000fe4000001164cULL, 0x000000ff5c857812ULL, 0x000fc400078ec0ffULL,
0x00000018ff847819ULL, 0x000fe4000001165cULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00005410914c7816ULL, 0x000fe40000000093ULL, 0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4e917812ULL, 0x000fe400078ec0ffULL, 0x0000008aff8a723eULL, 0x000fc400020006ffULL,
0x0000004dff8e723eULL, 0x000fe400020006ffULL, 0x00005410924e7816ULL, 0x000fe4000000008bULL,
0x00000010ff8f7819ULL, 0x000fe4000001164fULL, 0x000000ff4f697812ULL, 0x000fe400078ec0ffULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fc400020006ffULL,
0x00000008ff8b7819ULL, 0x000fe4000001165cULL, 0x00000010ff4f7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d877812ULL, 0x000fe400078ec0ffULL, 0x000054108a5c7816ULL, 0x000fe4000000008eULL,
0x000000ff648a7812ULL, 0x000fe400078ec0ffULL, 0x00000090ff90723eULL, 0x000fc400020006ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000096ff96723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x0000541085647816ULL, 0x000fe40000000091ULL, 0x000000ff8f8f7812ULL, 0x000fc400078ec0ffULL,
0x000000ff4f937812ULL, 0x000fe400078ec0ffULL, 0x00000008ff877819ULL, 0x000fe40000011687ULL,
0x00000008ff857819ULL, 0x000fe40000011666ULL, 0x00000008ff7a7819ULL, 0x000fe4000001167aULL,
0x00000069ff5d723eULL, 0x000fe400020006ffULL, 0x00005410904d7816ULL, 0x000fc40000000096ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x000054108b667816ULL, 0x000fe40000000084ULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x00000097ff69723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000095ff90723eULL, 0x000fe200020006ffULL, 0x0000004c2c0c723cULL, 0x000fe2000000180cULL,
0x00000093ff93723eULL, 0x000fc400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000068ff84723eULL, 0x000fe200020006ffULL,
0x00000010724c7824ULL, 0x000fe200078e027cULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x000054106b687816ULL, 0x000fc40000000086ULL,
0x00005410944f7816ULL, 0x000fe4000000008cULL, 0x000054105d5d7816ULL, 0x000fe4000000008fULL,
0x000054108d5e7816ULL, 0x000fe4000000005eULL, 0x00005410905f7816ULL, 0x000fe2000000005fULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x0000541065657816ULL, 0x000fe40000000093ULL,
0x0000541087677816ULL, 0x000fc40000000067ULL, 0x0000541069697816ULL, 0x000fe2000000008aULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x00005410856a7816ULL, 0x000fe4000000006aULL,
0x000054107a6b7816ULL, 0x000fe20000000084ULL, 0x00017000737a7836ULL, 0x000fe40000000000ULL,
0x0000005e3444723cULL, 0x000fec0000001844ULL, 0x000000643448723cULL, 0x000fec0000001848ULL,
0x000000663450723cULL, 0x000fec0000001850ULL, 0x000000683428723cULL, 0x000fec0000001828ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x0000001071347824ULL, 0x000fc400078e027cULL, 0x000000107d7c7824ULL, 0x000fc600078e027aULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x000000003434783bULL, 0x000e6a0000000200ULL,
0x0000005e2c18723cULL, 0x000fec0000001818ULL, 0x000000642c1c723cULL, 0x000fec000000181cULL,
0x000000662c20723cULL, 0x000fec0000001820ULL, 0x000000682c30723cULL, 0x000fec0000001830ULL,
0x0000006a2c38723cULL, 0x000fe20000001838ULL, 0x000000004c2c783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x080fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x00000010795c7824ULL, 0x000fe200078e027aULL, 0x000000007c4c783bULL, 0x004eaa0000004200ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x00000018ff677819ULL, 0x004fe4000001164fULL,
0x00000010ff947819ULL, 0x000fe4000001164dULL, 0x000000ff4d927812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6b7819ULL, 0x028fe4000001165dULL, 0x000000ff5e977812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe4000001165fULL, 0x000000ff5f987812ULL, 0x040fe400078ec0ffULL,
0x00000018ff687819ULL, 0x000fe4000001165fULL, 0x0000ffff5f847812ULL, 0x000fc400078ec0ffULL,
0x00000067ff5f723eULL, 0x000fe400020006ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001164dULL,
0x00000018ff657819ULL, 0x000fe4000001164eULL, 0x0000006bff67723eULL, 0x000fe400020006ffULL,
0x00000010ff937819ULL, 0x000fe4000001164cULL, 0x0000ffff4d4d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff5d967812ULL, 0x000fe400078ec0ffULL, 0x00000097ff6b723eULL, 0x000fe400020006ffULL,
0x0000ffff4c6a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff94977812ULL, 0x000fe400078ec0ffULL,
0x00000010ff877819ULL, 0x100fe4000001165eULL, 0x00000018ff957819ULL, 0x000fc4000001165eULL,
0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL, 0x00000065ff5e723eULL, 0x000fe400020006ffULL,
0x00000010ff8c7819ULL, 0x000fe4000001164eULL, 0x00000096ff65723eULL, 0x000fe400020006ffULL,
0x000000ff93937812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4d7819ULL, 0x000fc4000001164dULL,
0x00000018ff8d7819ULL, 0x000fe4000001164cULL, 0x000000ff4e8b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e907812ULL, 0x000fe400078ec0ffULL, 0x000000ff4f697812ULL, 0x000fe400078ec0ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000008ff967819ULL, 0x000fc4000001166aULL,
0x00000097ff97723eULL, 0x000fe400020006ffULL, 0x000000ff4c917812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001165cULL, 0x00000010ff8f7819ULL, 0x000fe4000001164fULL,
0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL, 0x00000095ff6a723eULL, 0x000fc400020006ffULL,
0x00000010ff4f7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d8a7812ULL, 0x000fe400078ec0ffULL,
0x00000093ff94723eULL, 0x000fe400020006ffULL, 0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL,
0x0000004dff95723eULL, 0x000fe400020006ffULL, 0x000000ff5c867812ULL, 0x000fc400078ec0ffULL,
0x00000018ff857819ULL, 0x000fe4000001165cULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000069ff5d723eULL, 0x000fe400020006ffULL, 0x00000096ff93723eULL, 0x000fe400020006ffULL,
0x00005410924d7816ULL, 0x000fe40000000097ULL, 0x0000ffff5c5c7812ULL, 0x000fc400078ec0ffULL,
0x00000098ff69723eULL, 0x000fe400020006ffULL, 0x000000ff4e927812ULL, 0x000fe400078ec0ffULL,
0x000000ff8f987812ULL, 0x000fe400078ec0ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000008ff967819ULL, 0x000fe40000011690ULL, 0x0000008cff8f723eULL, 0x000fc400020006ffULL,
0x00005410934e7816ULL, 0x000fe4000000008dULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000008ff8d7819ULL, 0x000fe4000001165cULL, 0x00000096ff8c723eULL, 0x000fc400020006ffULL,
0x000054108b5c7816ULL, 0x000fe4000000008fULL, 0x00000008ff967819ULL, 0x000fe4000001164cULL,
0x000000ff648b7812ULL, 0x000fe400078ec0ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00005410914c7816ULL, 0x000fe40000000094ULL, 0x0000008dff8d723eULL, 0x000fc400020006ffULL,
0x000000ff87877812ULL, 0x000fe400078ec0ffULL, 0x0000541086647816ULL, 0x000fe20000000092ULL,
0x0000004c3454723cULL, 0x002fe20000001854ULL, 0x000000ff4f947812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8a7819ULL, 0x000fe4000001168aULL, 0x00000008ff867819ULL, 0x000fe20000011666ULL,
0x0000004c2c0c723cULL, 0x000fe2000000180cULL, 0x00000008ff847819ULL, 0x000fc40000011684ULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x000054108d667816ULL, 0x000fe40000000085ULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x00000098ff90723eULL, 0x000fe400020006ffULL,
0x00000096ff91723eULL, 0x000fe400020006ffULL, 0x00000094ff94723eULL, 0x000fc400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000068ff85723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x000054106b687816ULL, 0x000fc40000000087ULL,
0x00005410954f7816ULL, 0x000fe4000000008eULL, 0x000054105d5d7816ULL, 0x000fe40000000090ULL,
0x000054108c5e7816ULL, 0x000fe4000000005eULL, 0x00005410915f7816ULL, 0x000fe2000000005fULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x0000541065657816ULL, 0x000fe40000000094ULL,
0x000054108a677816ULL, 0x000fc40000000067ULL, 0x0000541069697816ULL, 0x000fe2000000008bULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x00005410866a7816ULL, 0x000fe4000000006aULL,
0x00005410846b7816ULL, 0x000fc60000000085ULL, 0x0000005e3444723cULL, 0x000fec0000001844ULL,
0x000000643448723cULL, 0x000fec0000001848ULL, 0x000000663450723cULL, 0x000fec0000001850ULL,
0x000000683428723cULL, 0x000fec0000001828ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x0000004e2c10723cULL, 0x000fe20000001810ULL, 0x0000000263357824ULL, 0x000fe200078e00ffULL,
0x0000000861347c11ULL, 0x000fe2000f8e18ffULL, 0x00000001ff377424ULL, 0x000fc600078e00ffULL,
0xfffffff835367812ULL, 0x000fe200078ec0ffULL, 0x0000005c2c14723cULL, 0x000fe20000001814ULL,
0x01a6c837343479a7ULL, 0x00026a000850003fULL, 0x0000005e2c18723cULL, 0x000fe20000001818ULL,
0x01a6903736ff79a7ULL, 0x0003ea0008500008ULL, 0x000000642c1c723cULL, 0x000fec000000181cULL,
0x000000662c20723cULL, 0x000fec0000001820ULL, 0x000000682c30723cULL, 0x000fec0000001830ULL,
0x0000006a2c38723cULL, 0x002fde0000001838ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x00000035060075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009000ff2c7b82ULL, 0x000e620000000a00ULL, 0x00000010632e7824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe40000000800ULL, 0x0000000481817c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe02e347812ULL, 0x000fe400078ec0ffULL, 0x0000004081817824ULL, 0x000fc600078e00ffULL,
0x0000010007347824ULL, 0x000fc800078e0234ULL, 0x000000c034357836ULL, 0x000fca0000000000ULL,
0x00000020352f7812ULL, 0x000fe200078ec0ffULL, 0x00000080812c7825ULL, 0x002fc800078e002cULL,
0x000000015a4d7824ULL, 0x000fe200078e022fULL, 0x0000000000f49947ULL, 0x000fec0003800000ULL,
0x000000102e2f7812ULL, 0x000fe400078ec0ffULL, 0x00000035762e7248ULL, 0x000fe40007fe0000ULL,
0x00000003ff347819ULL, 0x000fc60000011609ULL, 0x000000012e2e7824ULL, 0x000fe400078e0a35ULL,
0x0000000134367824ULL, 0x000fe400078e022fULL, 0x0000000434377836ULL, 0x000fe20000000000ULL,
0x0000002e2f2e7248ULL, 0x000fe20007fe0000ULL, 0x0000000136357824ULL, 0x040fe400078e0209ULL,
0x00000008364c7824ULL, 0x000fe400078e00ffULL, 0x000000012e2e7824ULL, 0x000fc400078e0a2fULL,
0x00000008344e7836ULL, 0x000fe20000000000ULL, 0xfffffff84c5f7812ULL, 0x000fe200078ee235ULL,
0x00000001374c7824ULL, 0x040fe200078e022fULL, 0x0000002e3700720cULL, 0x080fe20003f66070ULL,
0x0000000c34377836ULL, 0x000fe20000000000ULL, 0x0000002e3400720cULL, 0x080fe20003f86070ULL,
0x0000000136347824ULL, 0x000fe200078e024dULL, 0x0000002e4e00720cULL, 0x080fe20003f46070ULL,
0x000000014c357824ULL, 0x040fe200078e0209ULL, 0x0000002e3700720cULL, 0x000fe20003f06070ULL,
0x000000084c367824ULL, 0x000fc400078e00ffULL, 0x000000014e4e7824ULL, 0x100fe400078e022fULL,
0x00000001375c7824ULL, 0x000fe200078e022fULL, 0xfffffff836657812ULL, 0x000fe200078ee235ULL,
0x0000008034347825ULL, 0x000fc800078e00ffULL, 0x000000014c367824ULL, 0x100fe200078e024dULL,
0x0000006d342f7212ULL, 0x000fe200078efcffULL, 0x000000014e4c7824ULL, 0x040fe400078e024dULL,
0x000000014e4f7824ULL, 0x040fe200078e0209ULL, 0x0000002f2c347210ULL, 0x000fe20007fbe0ffULL,
0x000000084e4e7824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff84e677812ULL, 0x000fe200078ee24fULL, 0x000000015c2e7824ULL, 0x000fe200078e024dULL,
0x0000006d364f7212ULL, 0x000fe200078efcffULL, 0x000000804c4c7825ULL, 0x000fc800078e00ffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000006d4c5d7212ULL, 0x000fc600078efcffULL,
0x000000012d357824ULL, 0x040fe200028e0635ULL, 0x0000004f2c367210ULL, 0x000fe20007fbe0ffULL,
0x000000015c4e7824ULL, 0x000fe200078e0209ULL, 0x0000006d2e4f7212ULL, 0x000fe200078efcffULL,
0x000000085c697824ULL, 0x000fe400078e00ffULL, 0x000000012d377824ULL, 0x000fe200028e0637ULL,
0x0000005d2c4c7210ULL, 0x000fe20007fbe0ffULL, 0x000000105f5f7824ULL, 0x100fe200078e027aULL,
0x0000004f2c2c7210ULL, 0x000fe20007fde0ffULL, 0x0000001065657824ULL, 0x100fe200078e027aULL,
0xfffffff8694f7812ULL, 0x000fe200078ee24eULL, 0x000000012d4d7824ULL, 0x000fe200028e064dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000345f7faeULL, 0x0003e2000e101c46ULL,
0x0000001067677824ULL, 0x000fc400078e027aULL, 0x000000012d2d7824ULL, 0x000fe200030e062fULL,
0x0000000036657faeULL, 0x0003e2000d901c46ULL, 0x000000104f4f7824ULL, 0x000fc600078e027aULL,
0x000000004c677faeULL, 0x0003e8000d101c46ULL, 0x000000002c4f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c07947ULL, 0x000fea0003800000ULL, 0x000000102e2e7812ULL, 0x000fc800078ec0ffULL,
0x0000002e092e7211ULL, 0x000fca00078fe8ffULL, 0x000000042e367836ULL, 0x000fe40000000000ULL,
0x000000082e4c7836ULL, 0x000fe40000000000ULL, 0x0000000136347824ULL, 0x140fe400078e0209ULL,
0x0000000836677824ULL, 0x000fe400078e00ffULL, 0x000000012e2f7824ULL, 0x140fe400078e0209ULL,
0x000000082e4e7824ULL, 0x000fe200078e00ffULL, 0xfffffff867677812ULL, 0x000fe200078ee234ULL,
0x000000014c357824ULL, 0x000fc400078e0209ULL, 0x000000084c5c7824ULL, 0x000fe200078e00ffULL,
0xfffffff84e657812ULL, 0x000fe200078ee22fULL, 0x000000012e347824ULL, 0x000fe400078e024dULL,
0x0000000c2e4e7836ULL, 0x000fe20000000000ULL, 0xfffffff85c697812ULL, 0x000fe200078ee235ULL,
0x0000008034347825ULL, 0x000fc800078e00ffULL, 0x0000000136367824ULL, 0x100fe200078e024dULL,
0x0000006d344f7212ULL, 0x000fe200078efcffULL, 0x000000014c4c7824ULL, 0x100fe400078e024dULL,
0x000000014e2e7824ULL, 0x000fe200078e024dULL, 0x0000004f2c347210ULL, 0x000fe20007f1e0ffULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x000000804c4c7825ULL, 0x000fe200078e00ffULL,
0x0000006d365f7212ULL, 0x000fc600078efcffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000006d4c5d7212ULL, 0x080fe400078efcffULL, 0x0000005f2c367210ULL, 0x000fe20007f5e0ffULL,
0x000000014e5c7824ULL, 0x000fe200078e0209ULL, 0x0000006d2e4f7212ULL, 0x000fe200078efcffULL,
0x000000084e6b7824ULL, 0x000fe400078e00ffULL, 0x000000012d357824ULL, 0x000fe200000e0635ULL,
0x0000005d2c4c7210ULL, 0x000fe20007f1e0ffULL, 0x0000001065657824ULL, 0x100fe200078e027aULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee25cULL, 0x000000012d377824ULL, 0x000fe200010e0637ULL,
0x0000004f2c2c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001067677824ULL, 0x000fe200078e027aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034657faeULL, 0x0003e2000b901c46ULL,
0x000000012d4d7824ULL, 0x000fc400000e064dULL, 0x0000001069697824ULL, 0x100fe200078e027aULL,
0x0000000036677faeULL, 0x0003e2000b901c46ULL, 0x000000012d2d7824ULL, 0x000fe400018e062fULL,
0x000000106b6b7824ULL, 0x000fe200078e027aULL, 0x000000004c697faeULL, 0x0003e8000b901c46ULL,
0x000000002c6b7faeULL, 0x0003e4000b901c46ULL, 0x00000003592f7836ULL, 0x000fe40000000000ULL,
0xffffffffff817424ULL, 0x000fc600078e00ffULL, 0x000000742f00720cULL, 0x000fe20003f06070ULL,
0x00000008632e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2e7812ULL, 0x000fca00078ec0ffULL,
0x000000082e847c36ULL, 0x000fe40008000000ULL, 0x00009200ff2c8b82ULL, 0x002e620000000a00ULL,
0x00000001082f8824ULL, 0x000fe200078e022fULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000840472caULL, 0x000fda00000e0000ULL, 0x0001a6b004047890ULL, 0x000fe2000fffe03fULL,
0x000000042f2c8825ULL, 0x002fd000078e002cULL, 0x00000000ff0079b0ULL, 0x000fe80008000a44ULL,
0x000000062c818981ULL, 0x000322000c1e1900ULL, 0x00000001ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x01a6b02f848479a7ULL, 0x0004e2000850003fULL,
0x01a6482f802c79a7ULL, 0x002464000850003fULL, 0x00000000002e7805ULL, 0x004fce0000015200ULL,
0x01a6482d800075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x000000342e377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e2fULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6482d800075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000020632c7824ULL, 0x000fe400078e00ffULL,
0x00000008ff2d7e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0xffffff802c2c7812ULL, 0x000fc800078ec0ffULL, 0x000001002d2c7810ULL, 0x000fc80007ffe02cULL,
0x0000002c702c7210ULL, 0x000fca0007ffe06dULL, 0x01a000002c2e7984ULL, 0x000e680000000800ULL,
0x01a200002c2d7984ULL, 0x0004a20000000800ULL, 0x000000832e00720bULL, 0x002fda0003f1d000ULL,
0x00000000002f7806ULL, 0x000fc800000e0100ULL, 0x000000ff2f00720cULL, 0x000fda0003f05270ULL,
0x00000004009c8947ULL, 0x00cfea0003800000ULL, 0x00000002602c7836ULL, 0x000fe20000000000ULL,
0x000000832e00720bULL, 0x000fc80003f14000ULL, 0x000000632c00720cULL, 0x000fda0003f45270ULL,
0x000000086334ac11ULL, 0x000fe4000f8e38ffULL, 0x000000832e2ca209ULL, 0x000fe40007810000ULL,
0x000000347035a210ULL, 0x000fe40007ffe06dULL, 0x0000000000347806ULL, 0x000fc600000e0100ULL,
0x01a4002c3500a388ULL, 0x0003e20000000800ULL, 0x000000ff3400720cULL, 0x000fda0003f05270ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x000000832e2c7209ULL, 0x000fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x000000832c2c7221ULL, 0x000fe20000010100ULL, 0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000034ff7812ULL, 0x000fe2000788c0ffULL, 0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL,
0x0000002c00357308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff2c7819ULL, 0x002fcc0000011609ULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x000000542c547220ULL, 0x042fe20000410000ULL, 0x000000552c557220ULL, 0x040fe20000410000ULL,
0x0000003c2c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d2c3d7220ULL, 0x040fe20000410000ULL,
0x000000402c407220ULL, 0x040fe20000410000ULL, 0x000000412c417220ULL, 0x040fe20000410000ULL,
0x000000442c447220ULL, 0x040fe20000410000ULL, 0x000000452c457220ULL, 0x040fe20000410000ULL,
0x000000482c487220ULL, 0x040fe20000410000ULL, 0x000000492c497220ULL, 0x040fe20000410000ULL,
0x000000502c507220ULL, 0x040fe20000410000ULL, 0x000000512c517220ULL, 0x040fe20000410000ULL,
0x000000282c287220ULL, 0x040fe20000410000ULL, 0x000000292c297220ULL, 0x040fe20000410000ULL,
0x000000242c247220ULL, 0x040fe20000410000ULL, 0x000000252c257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x00000008092c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x000000562c567220ULL, 0x042fe20000410000ULL,
0x000000572c577220ULL, 0x040fe20000410000ULL, 0x0000003e2c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f2c3f7220ULL, 0x040fe20000410000ULL, 0x000000422c427220ULL, 0x040fe20000410000ULL,
0x000000432c437220ULL, 0x040fe20000410000ULL, 0x000000462c467220ULL, 0x040fe20000410000ULL,
0x000000472c477220ULL, 0x040fe20000410000ULL, 0x0000004a2c4a7220ULL, 0x040fe20000410000ULL,
0x0000004b2c4b7220ULL, 0x040fe20000410000ULL, 0x000000522c527220ULL, 0x040fe20000410000ULL,
0x000000532c537220ULL, 0x040fe20000410000ULL, 0x0000002a2c2a7220ULL, 0x040fe20000410000ULL,
0x0000002b2c2b7220ULL, 0x040fe20000410000ULL, 0x000000262c267220ULL, 0x040fe20000410000ULL,
0x000000272c277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x00000010092c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x0000000c2c0c7220ULL, 0x042fe20000410000ULL, 0x0000000d2c0d7220ULL, 0x040fe20000410000ULL,
0x000000102c107220ULL, 0x040fe20000410000ULL, 0x000000112c117220ULL, 0x040fe20000410000ULL,
0x000000142c147220ULL, 0x040fe20000410000ULL, 0x000000152c157220ULL, 0x040fe20000410000ULL,
0x000000182c187220ULL, 0x040fe20000410000ULL, 0x000000192c197220ULL, 0x040fe20000410000ULL,
0x0000001c2c1c7220ULL, 0x040fe20000410000ULL, 0x0000001d2c1d7220ULL, 0x040fe20000410000ULL,
0x000000202c207220ULL, 0x040fe20000410000ULL, 0x000000212c217220ULL, 0x040fe20000410000ULL,
0x000000302c307220ULL, 0x040fe20000410000ULL, 0x000000312c317220ULL, 0x040fe20000410000ULL,
0x000000382c387220ULL, 0x040fe20000410000ULL, 0x000000392c397220ULL, 0x000fce0000410000ULL,
0x0000003582827220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x00000018092c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x000e6400000e0000ULL,
0x0000000e2c0e7220ULL, 0x042fe20000410000ULL, 0x0000000f2c0f7220ULL, 0x040fe20000410000ULL,
0x000000122c127220ULL, 0x040fe20000410000ULL, 0x000000132c137220ULL, 0x040fe20000410000ULL,
0x000000162c167220ULL, 0x040fe20000410000ULL, 0x000000172c177220ULL, 0x040fe20000410000ULL,
0x0000001a2c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b2c1b7220ULL, 0x040fe20000410000ULL,
0x0000001e2c1e7220ULL, 0x040fe20000410000ULL, 0x0000001f2c1f7220ULL, 0x040fe20000410000ULL,
0x000000222c227220ULL, 0x040fe20000410000ULL, 0x000000232c237220ULL, 0x040fe20000410000ULL,
0x000000322c327220ULL, 0x040fe20000410000ULL, 0x000000332c337220ULL, 0x040fe20000410000ULL,
0x0000003a2c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b2c3b7220ULL, 0x000fce0000410000ULL,
0x000000342fff7212ULL, 0x000fe200078030ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x000000832e837209ULL, 0x000fd60007810000ULL, 0x800000832e2e0221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL,
0x0000002e00040308ULL, 0x000ea40000000800ULL, 0x000000042d2d0220ULL, 0x004fce0000410000ULL,
0x000000822d827221ULL, 0x000fce0000010000ULL, 0x00000000002c7805ULL, 0x002fce0000015200ULL,
0x00000008632e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2f7812ULL, 0x000fc800078ec0ffULL,
0x01a6a8892f0075a7ULL, 0x000e620008000148ULL, 0x000000082f377c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6a889370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009910342c7816ULL, 0x000fe200000000ffULL, 0x00000400632d7824ULL, 0x040fe400078e00ffULL,
0x00001000632e7824ULL, 0x000fe200078e00ffULL, 0x000000ff2c00720cULL, 0x000fe20003f05270ULL,
0x00000008ff807e24ULL, 0x000fe2000f8e00ffULL, 0xfffff0002d2d7812ULL, 0x000fe200078ec0ffULL,
0x00000008ff2f7e24ULL, 0x000fe2000f8e00ffULL, 0xffffe0002e2e7812ULL, 0x000fe400078ec0ffULL,
0x0001400080807810ULL, 0x000fc40007ffe02dULL, 0x000160002f5c7810ULL, 0x000fc60007ffe02eULL,
0x000000107f347824ULL, 0x100fe400078e0280ULL, 0x000000107e2c7824ULL, 0x000fe400078e0280ULL,
0x000000106f4d7824ULL, 0x000fe200078e025cULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff2e7819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000000ffULL,
0x000000082e027836ULL, 0x000fe20000000000ULL, 0x00005410002d7816ULL, 0x000fe20000000000ULL,
0x000000102e367836ULL, 0x000fe40000000000ULL, 0x000000182e4c7836ULL, 0x000fe40000000000ULL,
0x00001f022d027589ULL, 0x0002a800000e0000ULL, 0x00001f362d057589ULL, 0x0002e800000e0000ULL,
0x00001f2e2d037589ULL, 0x00026800000e0000ULL, 0x00001f4c2d007589ULL, 0x00026400000e0000ULL,
0x000000003434783bULL, 0x002e680000000200ULL, 0x000000002c2c783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x084fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x088fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000107b5c7824ULL, 0x000fe200078e025cULL,
0x000000004d4c783bULL, 0x000f6a0000004200ULL, 0x000000005c5c783bULL, 0x000f640000004200ULL,
0x00000010ff907819ULL, 0x028fe4000001164cULL, 0x00000018ff657819ULL, 0x000fc4000001164eULL,
0x00000010ff917819ULL, 0x000fe4000001164dULL, 0x000000ff5d927812ULL, 0x004fe400078ec0ffULL,
0x000000ff4c8e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4c697812ULL, 0x000fe400078ec0ffULL,
0x00000018ff677819ULL, 0x000fe4000001164fULL, 0x00000010ff867819ULL, 0x000fc4000001165eULL,
0x00000018ff937819ULL, 0x000fe4000001165eULL, 0x000000ff5e947812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL, 0x000000ff90907812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001165dULL, 0x00000065ff5e723eULL, 0x000fc400020006ffULL,
0x00000018ff897819ULL, 0x000fe4000001164cULL, 0x00000092ff65723eULL, 0x000fe400020006ffULL,
0x00000010ff8c7819ULL, 0x000fe4000001164eULL, 0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe4000001165fULL, 0x00000018ff687819ULL, 0x000fc4000001165fULL,
0x000000ff5f957812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5f7b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff91927812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e887812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e8b7812ULL, 0x000fe400078ec0ffULL, 0x0000008eff8e723eULL, 0x000fc400020006ffULL,
0x00000067ff5f723eULL, 0x000fe400020006ffULL, 0x00000008ff917819ULL, 0x000fe40000011669ULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000010ff4e7819ULL, 0x000fe4000001165cULL,
0x0000006bff67723eULL, 0x000fe400020006ffULL, 0x00000094ff6b723eULL, 0x000fc400020006ffULL,
0x000000ff4d8f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff8a7819ULL, 0x000fe4000001164dULL,
0x0000ffff4d8d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff947819ULL, 0x000fe4000001164cULL, 0x00000010ff4d7819ULL, 0x000fc4000001164fULL,
0x000000ff5c7f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001165cULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x000054108e4c7816ULL, 0x000fe40000000090ULL, 0x000000ff4f6a7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e8e7812ULL, 0x000fe400078ec0ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000008ff8d7819ULL, 0x000fe4000001168dULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x00000010ff4f7819ULL, 0x000fc4000001165dULL,
0x0000ffff5d877812ULL, 0x000fe400078ec0ffULL, 0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x00005410914e7816ULL, 0x000fe40000000089ULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x0000006aff5d723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fc400020006ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000008ff897819ULL, 0x000fe4000001165cULL, 0x00000093ff6a723eULL, 0x000fe400020006ffULL,
0x0000008dff93723eULL, 0x000fe400020006ffULL, 0x00005410885c7816ULL, 0x000fc4000000008cULL,
0x0000004dff8d723eULL, 0x000fe400020006ffULL, 0x000000ff64887812ULL, 0x000fe400078ec0ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x000054108f4d7816ULL, 0x000fe40000000092ULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x000000ff86867812ULL, 0x000fc400078ec0ffULL,
0x000054107f647816ULL, 0x000fe2000000008eULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x00000008ff8b7819ULL, 0x000fe4000001168bULL, 0x000000ff4f8f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff877819ULL, 0x000fe20000011687ULL, 0x0000004c2c0c723cULL, 0x000fe2000000180cULL,
0x00000008ff7f7819ULL, 0x000fe40000011666ULL, 0x00000008ff7b7819ULL, 0x000fc4000001167bULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x0000541089667816ULL, 0x000fe4000000007eULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000095ff69723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000094ff94723eULL, 0x000fc400020006ffULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000068ff7e723eULL, 0x000fe400020006ffULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x0000007bff7b723eULL, 0x000fc400020006ffULL,
0x000054106b687816ULL, 0x000fe40000000086ULL, 0x00005410934f7816ULL, 0x000fe4000000008aULL,
0x000054105d5d7816ULL, 0x000fe4000000008dULL, 0x000054108b5e7816ULL, 0x000fe4000000005eULL,
0x00005410945f7816ULL, 0x000fe2000000005fULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x0000541065657816ULL, 0x000fc4000000008fULL, 0x0000541087677816ULL, 0x000fe40000000067ULL,
0x0000541069697816ULL, 0x000fe20000000088ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x000054107f6a7816ULL, 0x000fe4000000006aULL, 0x000054107b6b7816ULL, 0x000fe2000000007eULL,
0x00016000737e7836ULL, 0x000fe40000000000ULL, 0x0000005e3444723cULL, 0x000fe40000001844ULL,
0x000000107d4c7824ULL, 0x000fc800078e027eULL, 0x000000643448723cULL, 0x000fec0000001848ULL,
0x000000663450723cULL, 0x000fec0000001850ULL, 0x000000683428723cULL, 0x000fec0000001828ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x0000001071347824ULL, 0x000fc400078e0280ULL, 0x0000001072807824ULL, 0x000fc600078e0280ULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x000000003434783bULL, 0x000e6a0000000200ULL,
0x0000005e2c18723cULL, 0x000fec0000001818ULL, 0x000000642c1c723cULL, 0x000fec000000181cULL,
0x000000662c20723cULL, 0x000fec0000001820ULL, 0x000000682c30723cULL, 0x000fec0000001830ULL,
0x0000006a2c38723cULL, 0x000fe20000001838ULL, 0x00000000802c783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x080fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x00000010795c7824ULL, 0x000fe200078e027eULL, 0x000000004c4c783bULL, 0x000f6a0000004200ULL,
0x000000005c5c783bULL, 0x000f640000004200ULL, 0x00000010ff8d7819ULL, 0x024fe4000001164cULL,
0x00000018ff657819ULL, 0x000fc4000001164eULL, 0x00000010ff8e7819ULL, 0x000fe4000001164dULL,
0x000000ff5d8f7812ULL, 0x008fe400078ec0ffULL, 0x000000ff4c887812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4c697812ULL, 0x000fe400078ec0ffULL, 0x00000018ff677819ULL, 0x000fe4000001164fULL,
0x00000010ff7d7819ULL, 0x000fc4000001165eULL, 0x00000018ff907819ULL, 0x000fe4000001165eULL,
0x000000ff5e917812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL,
0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001165dULL,
0x00000065ff5e723eULL, 0x000fc400020006ffULL, 0x00000018ff867819ULL, 0x000fe4000001164cULL,
0x0000008fff65723eULL, 0x000fe400020006ffULL, 0x000000ff4d897812ULL, 0x040fe400078ec0ffULL,
0x00000018ff877819ULL, 0x000fe4000001164dULL, 0x0000ffff4d8c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8b7819ULL, 0x000fc4000001164eULL, 0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe4000001165fULL, 0x00000018ff687819ULL, 0x000fe4000001165fULL,
0x000000ff5f927812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5f737812ULL, 0x000fe400078ec0ffULL,
0x000000ff8e8f7812ULL, 0x000fc400078ec0ffULL, 0x000000ff4e807812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e4d7812ULL, 0x000fe400078ec0ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000067ff5f723eULL, 0x000fe400020006ffULL, 0x00000008ff8e7819ULL, 0x000fe40000011669ULL,
0x0000008dff8d723eULL, 0x000fc400020006ffULL, 0x00000010ff4e7819ULL, 0x000fe4000001165cULL,
0x0000006bff67723eULL, 0x000fe400020006ffULL, 0x00000091ff6b723eULL, 0x000fe400020006ffULL,
0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff917819ULL, 0x000fe4000001164cULL,
0x000000ff5c7b7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff797819ULL, 0x000fe4000001165cULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00005410884c7816ULL, 0x000fe4000000008dULL, 0x000000ff4f6a7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff5c5c7812ULL, 0x000fc400078ec0ffULL, 0x000000ff4e887812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8a7819ULL, 0x000fe4000001164fULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000010ff4f7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d7f7812ULL, 0x000fc400078ec0ffULL, 0x000054108e4e7816ULL, 0x000fe40000000086ULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x0000006aff5d723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fc400020006ffULL, 0x00000008ff867819ULL, 0x000fe4000001165cULL,
0x00000090ff6a723eULL, 0x000fe400020006ffULL, 0x000000ff8a907812ULL, 0x000fe400078ec0ffULL,
0x00005410805c7816ULL, 0x000fe4000000008bULL, 0x00000008ff8a7819ULL, 0x000fe4000001164dULL,
0x000000ff64807812ULL, 0x000fc400078ec0ffULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x00005410894d7816ULL, 0x000fe4000000008fULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x000000ff7d7d7812ULL, 0x000fe400078ec0ffULL, 0x000054107b647816ULL, 0x000fe20000000088ULL,
0x0000004c3454723cULL, 0x002fe20000001854ULL, 0x00000008ff8c7819ULL, 0x000fc4000001168cULL,
0x000000ff4f897812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7f7819ULL, 0x000fe2000001167fULL,
0x0000004c2c0c723cULL, 0x000fe2000000180cULL, 0x00000008ff7b7819ULL, 0x000fe40000011666ULL,
0x00000008ff737819ULL, 0x000fe40000011673ULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x0000541086667816ULL, 0x000fc40000000079ULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00000092ff69723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x00000091ff91723eULL, 0x000fc400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000068ff79723eULL, 0x000fe400020006ffULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x00000073ff73723eULL, 0x000fc400020006ffULL, 0x000054106b687816ULL, 0x000fe4000000007dULL,
0x000054108c4f7816ULL, 0x000fe40000000087ULL, 0x000054105d5d7816ULL, 0x000fe40000000090ULL,
0x000054108a5e7816ULL, 0x000fe4000000005eULL, 0x00005410915f7816ULL, 0x000fe2000000005fULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x0000541065657816ULL, 0x000fc40000000089ULL,
0x000054107f677816ULL, 0x000fe40000000067ULL, 0x0000541069697816ULL, 0x000fe20000000080ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x000054107b6a7816ULL, 0x000fe4000000006aULL,
0x00005410736b7816ULL, 0x000fe40000000079ULL, 0x00000008614d7c11ULL, 0x000fe2000f8e18ffULL,
0x0000005e3444723cULL, 0x000fec0000001844ULL, 0x000000643448723cULL, 0x000fec0000001848ULL,
0x000000663450723cULL, 0x000fec0000001850ULL, 0x000000683428723cULL, 0x000fec0000001828ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x0000000263347824ULL, 0x000fc400078e00ffULL, 0x00000001ff377424ULL, 0x000fc600078e00ffULL,
0xfffffff834367812ULL, 0x000fe200078ec0ffULL, 0x0000005c2c14723cULL, 0x000fe20000001814ULL,
0x01a6c8374d3479a7ULL, 0x00026a000850003fULL, 0x0000005e2c18723cULL, 0x000fe20000001818ULL,
0x01a6983736ff79a7ULL, 0x0003ea0008500008ULL, 0x000000642c1c723cULL, 0x000fec000000181cULL,
0x000000662c20723cULL, 0x000fec0000001820ULL, 0x000000682c30723cULL, 0x000fec0000001830ULL,
0x0000006a2c38723cULL, 0x002fde0000001838ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x01a6c8354d0075a7ULL, 0x000e62000800017fULL,
0x0000000360367836ULL, 0x000fc80000000000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e0036ULL,
0x0000000000600947ULL, 0x002fec0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a6c8354d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ffff2e7224ULL, 0x000fce00078e0036ULL, 0x0000000107347836ULL, 0x000fe40000000000ULL,
0x0000000359597836ULL, 0x000fc60000000000ULL, 0x000000623400720cULL, 0x000fda0003f06070ULL,
0x0000000800080947ULL, 0x000fea0003800000ULL, 0x00009000ff2c7b82ULL, 0x000e620000000a00ULL,
0x00000002072f7836ULL, 0x000fe20000000000ULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x0000010034347824ULL, 0x000fe400078e025bULL, 0x0000000481817c24ULL, 0x010fe2000f8e02ffULL,
0x000000622f00720cULL, 0x000fe40003f06070ULL, 0x00000020342f7812ULL, 0x000fe200078ec0ffULL,
0x0000004081817824ULL, 0x000fc800078e00ffULL, 0x000000015a4e7824ULL, 0x000fe400078e022fULL,
0x00000080812c7825ULL, 0x002fc800078e002cULL, 0x0000000000f88947ULL, 0x000fea0003800000ULL,
0x00000034762f7248ULL, 0x000fe20007fe0000ULL, 0x0000001063357824ULL, 0x000fc800078e00ffULL,
0x000000012f2f7824ULL, 0x000fe200078e0a34ULL, 0x0000001035347812ULL, 0x000fe400078ec0ffULL,
0x00000003ff357819ULL, 0x000fe40000011609ULL, 0x0000002f342f7248ULL, 0x000fc60007fe0000ULL,
0x0000000435367836ULL, 0x000fe40000000000ULL, 0x000000012f2f7824ULL, 0x100fe400078e0a34ULL,
0x0000000835377836ULL, 0x000fe40000000000ULL, 0x0000000c354d7836ULL, 0x000fe20000000000ULL,
0x0000002f3500720cULL, 0x0c0fe20003f86070ULL, 0x0000000135357824ULL, 0x100fe200078e0234ULL,
0x0000002f3600720cULL, 0x0c0fe20003f66070ULL, 0x00000001364c7824ULL, 0x000fe200078e0234ULL,
0x0000002f3700720cULL, 0x080fe20003f46070ULL, 0x0000000135367824ULL, 0x000fe200078e024eULL,
0x0000002f4d00720cULL, 0x000fe20003f06070ULL, 0x00000001374f7824ULL, 0x000fc400078e0234ULL,
0x000000014d597824ULL, 0x000fe400078e0234ULL, 0x000000014c347824ULL, 0x040fe400078e0209ULL,
0x000000084c5f7824ULL, 0x040fe400078e00ffULL, 0x000000014c4c7824ULL, 0x000fe400078e024eULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0xfffffff85f5f7812ULL, 0x000fc600078ee234ULL,
0x00000001352f7824ULL, 0x140fe400078e0209ULL, 0x00000008355c7824ULL, 0x000fe400078e00ffULL,
0x000000014f357824ULL, 0x040fe400078e0209ULL, 0x000000084f5e7824ULL, 0x000fe200078e00ffULL,
0xfffffff85c5d7812ULL, 0x000fe200078ee22fULL, 0x000000804c4c7825ULL, 0x000fc600078e00ffULL,
0xfffffff85e657812ULL, 0x000fe200078ee235ULL, 0x000000014f347824ULL, 0x100fe200078e024eULL,
0x0000006d364f7212ULL, 0x080fe200078efcffULL, 0x00000001594e7824ULL, 0x000fe200078e024eULL,
0x0000006d4c2f7212ULL, 0x000fe200078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000004f2c367210ULL, 0x000fe40007fbe0ffULL, 0x0000002f2c4c7210ULL, 0x000fe20007fde0ffULL,
0x000000804e4e7825ULL, 0x000fc800078e00ffULL, 0x00000001595c7824ULL, 0x040fe200078e0209ULL,
0x0000006d4e2f7212ULL, 0x080fe200078efcffULL, 0x0000000859677824ULL, 0x000fe200078e00ffULL,
0x0000006d34597212ULL, 0x000fe200078efcffULL, 0x000000012d377824ULL, 0x040fe400028e0637ULL,
0x000000012d4d7824ULL, 0x000fe200030e064dULL, 0x000000592c347210ULL, 0x000fe20007fbe0ffULL,
0x000000105d5d7824ULL, 0x100fe200078e027eULL, 0xfffffff867677812ULL, 0x000fe200078ee25cULL,
0x000000105f5f7824ULL, 0x100fe200078e027eULL, 0x0000002f2c2c7210ULL, 0x000fe20007fde0ffULL,
0x0000001065657824ULL, 0x000fe200078e027eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000365d7faeULL, 0x0003e2000e101c46ULL, 0x000000012d357824ULL, 0x000fc400028e0635ULL,
0x0000001067677824ULL, 0x000fe200078e027eULL, 0x000000004c5f7faeULL, 0x0003e2000d901c46ULL,
0x000000012d2d7824ULL, 0x000fc600030e064fULL, 0x0000000034657faeULL, 0x0003e8000d101c46ULL,
0x000000002c677faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x00000010632f7824ULL, 0x000fca00078e00ffULL, 0x000000102f347812ULL, 0x000fc800078ec0ffULL,
0x00000034092f7211ULL, 0x000fca00078fe8ffULL, 0x000000012f357824ULL, 0x040fe400078e0209ULL,
0x000000082f367824ULL, 0x040fe400078e00ffULL, 0x000000012f347824ULL, 0x000fe400078e024eULL,
0x000000042f377836ULL, 0x000fe20000000000ULL, 0xfffffff836597812ULL, 0x000fe200078ee235ULL,
0x000000082f4f7836ULL, 0x000fe40000000000ULL, 0x0000008034347825ULL, 0x000fc800078e00ffULL,
0x0000000c2f5c7836ULL, 0x000fe20000000000ULL, 0x0000006d342f7212ULL, 0x000fe200078efcffULL,
0x0000000137367824ULL, 0x140fe400078e024eULL, 0x00000001374d7824ULL, 0x140fe200078e0209ULL,
0x0000002f2c347210ULL, 0x000fe20007f1e0ffULL, 0x00000008375e7824ULL, 0x000fe400078e00ffULL,
0x000000014f4c7824ULL, 0x040fe400078e024eULL, 0x000000014f377824ULL, 0x040fe200078e0209ULL,
0xfffffff85e2f7812ULL, 0x000fe200078ee24dULL, 0x000000084f647824ULL, 0x000fc400078e00ffULL,
0x000000015c4e7824ULL, 0x040fe400078e024eULL, 0x000000015c4f7824ULL, 0x040fe200078e0209ULL,
0xfffffff864677812ULL, 0x000fe200078ee237ULL, 0x000000085c5c7824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff85c697812ULL, 0x000fe200078ee24fULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x0000006d365d7212ULL, 0x000fc600078efcffULL,
0x000000804e4e7825ULL, 0x000fc800078e00ffULL, 0x00000010595f7824ULL, 0x100fe200078e027eULL,
0x0000006d4c597212ULL, 0x080fe200078efcffULL, 0x000000102f657824ULL, 0x100fe200078e027eULL,
0x0000006d4e2f7212ULL, 0x000fe200078efcffULL, 0x000000012d357824ULL, 0x000fe200000e0635ULL,
0x0000005d2c367210ULL, 0x000fe20007f1e0ffULL, 0x0000001067677824ULL, 0x100fe200078e027eULL,
0x000000592c4c7210ULL, 0x000fe20007f5e0ffULL, 0x0000001069697824ULL, 0x000fe200078e027eULL,
0x0000002f2c2c7210ULL, 0x000fe20007f7e0ffULL, 0x000000012d377824ULL, 0x040fe200000e0637ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000345f7faeULL, 0x0003e2000b901c46ULL,
0x000000012d4d7824ULL, 0x000fc400010e064dULL, 0x000000012d2d7824ULL, 0x000fe200018e064fULL,
0x0000000036657faeULL, 0x0003e8000b901c46ULL, 0x000000004c677faeULL, 0x0003e8000b901c46ULL,
0x000000002c697faeULL, 0x0003e4000b901c46ULL, 0x000000046e597836ULL, 0x000fe40000000000ULL,
0xffffffffff817424ULL, 0x000fc600078e00ffULL, 0x000000745900720cULL, 0x000fda0003f06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00009200ff2c7b82ULL, 0x002e620000000a00ULL,
0x00000001082f7824ULL, 0x000fc800078e0259ULL, 0x000000042f2c7825ULL, 0x002fca00078e002cULL,
0x000000062c817981ULL, 0x000324000c1e1900ULL, 0x00000008632c7824ULL, 0x002fe200078e00ffULL,
0x00000008602d7c11ULL, 0x000fe2000f8e28ffULL, 0x00000001ff4c7424ULL, 0x000fc600078e00ffULL,
0xfffffff02c347812ULL, 0x000fe200078ec0ffULL, 0x00000010582f7824ULL, 0x000fe200078e022dULL,
0x000000082c367812ULL, 0x000fc600078ec0ffULL, 0x0000000834357c36ULL, 0x000fe20008000000ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x00000000350472caULL, 0x000fda00000e0000ULL,
0x0001a6a804047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01a6a84c352c79a7ULL, 0x000e62000850003fULL,
0x00000001362f7824ULL, 0x000fc800078e022fULL, 0x01a6684c2f3679a7ULL, 0x0004e4000850003fULL,
0x000000ffff797224ULL, 0x006fce00078e002dULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x01a668372f0075a7ULL, 0x008e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff4c7224ULL, 0x000fce00078e00ffULL, 0x000000104c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x000000342c4d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e2dULL,
0x003d09004d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000004d34347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000014c4c7836ULL, 0x000fce0000000000ULL, 0x01a668372f0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000082e2e7c11ULL, 0x000fe2000f8e38ffULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff7e7224ULL, 0x000fe200078e0083ULL,
0x0000002e702e7210ULL, 0x000fca0007ffe06dULL, 0x01a000002e367984ULL, 0x000e680000000800ULL,
0x01a200002e2d7984ULL, 0x0004a20000000800ULL, 0x000000833600720bULL, 0x002fda0003f1d000ULL,
0x00000000002f7806ULL, 0x000fc800000e0100ULL, 0x000000ff2f00720cULL, 0x000fda0003f05270ULL,
0x0000000400948947ULL, 0x004fea0003800000ULL, 0x00000003602c7836ULL, 0x000fe20000000000ULL,
0x000000833600720bULL, 0x0c0fe40003f14000ULL, 0x00000083367e7209ULL, 0x000fe40007810000ULL,
0x000000632c00720cULL, 0x000fd20003f45270ULL, 0x00000000002e7806ULL, 0x000fc800000e0100ULL,
0x00000008632cac11ULL, 0x000fe4000f8e38ffULL, 0x000000ff2e00720cULL, 0x000fe40003f05270ULL,
0x0000002c706da210ULL, 0x000fca0007ffe06dULL, 0x01a4007e6d00a388ULL, 0x0003ec0000000800ULL,
0x0000000400508947ULL, 0x000fea0003800000ULL, 0x000000837e2c7221ULL, 0x000fe20000010100ULL,
0x000000ff2eff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff002eff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b2c2c7820ULL, 0x000fe20000410000ULL, 0x00ff00002eff7812ULL, 0x040fe4000786c0ffULL,
0xff0000002eff7812ULL, 0x000fe2000788c0ffULL, 0x0000002c00357308ULL, 0x0004ec0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff2c7819ULL, 0x004fcc0000011609ULL,
0x00001f2c352c7589ULL, 0x008ea400000e0000ULL, 0x000000542c547220ULL, 0x044fe20000410000ULL,
0x000000552c557220ULL, 0x040fe20000410000ULL, 0x0000003c2c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d2c3d7220ULL, 0x040fe20000410000ULL, 0x000000402c407220ULL, 0x040fe20000410000ULL,
0x000000412c417220ULL, 0x040fe20000410000ULL, 0x000000442c447220ULL, 0x040fe20000410000ULL,
0x000000452c457220ULL, 0x040fe20000410000ULL, 0x000000482c487220ULL, 0x040fe20000410000ULL,
0x000000492c497220ULL, 0x040fe20000410000ULL, 0x000000502c507220ULL, 0x040fe20000410000ULL,
0x000000512c517220ULL, 0x040fe20000410000ULL, 0x000000282c287220ULL, 0x040fe20000410000ULL,
0x000000292c297220ULL, 0x040fe20000410000ULL, 0x000000242c247220ULL, 0x040fe20000410000ULL,
0x000000252c257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000008092c7811ULL, 0x004fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x008ea400000e0000ULL,
0x000000562c567220ULL, 0x044fe20000410000ULL, 0x000000572c577220ULL, 0x040fe20000410000ULL,
0x0000003e2c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f2c3f7220ULL, 0x040fe20000410000ULL,
0x000000422c427220ULL, 0x040fe20000410000ULL, 0x000000432c437220ULL, 0x040fe20000410000ULL,
0x000000462c467220ULL, 0x040fe20000410000ULL, 0x000000472c477220ULL, 0x040fe20000410000ULL,
0x0000004a2c4a7220ULL, 0x040fe20000410000ULL, 0x0000004b2c4b7220ULL, 0x040fe20000410000ULL,
0x000000522c527220ULL, 0x040fe20000410000ULL, 0x000000532c537220ULL, 0x040fe20000410000ULL,
0x0000002a2c2a7220ULL, 0x040fe20000410000ULL, 0x0000002b2c2b7220ULL, 0x040fe20000410000ULL,
0x000000262c267220ULL, 0x040fe20000410000ULL, 0x000000272c277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x00000010092c7811ULL, 0x004fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x008ea400000e0000ULL, 0x0000000c2c0c7220ULL, 0x044fe20000410000ULL,
0x0000000d2c0d7220ULL, 0x040fe20000410000ULL, 0x000000102c107220ULL, 0x040fe20000410000ULL,
0x000000112c117220ULL, 0x040fe20000410000ULL, 0x000000142c147220ULL, 0x040fe20000410000ULL,
0x000000152c157220ULL, 0x040fe20000410000ULL, 0x000000182c187220ULL, 0x040fe20000410000ULL,
0x000000192c197220ULL, 0x040fe20000410000ULL, 0x0000001c2c1c7220ULL, 0x040fe20000410000ULL,
0x0000001d2c1d7220ULL, 0x040fe20000410000ULL, 0x000000202c207220ULL, 0x040fe20000410000ULL,
0x000000212c217220ULL, 0x040fe20000410000ULL, 0x000000302c307220ULL, 0x040fe20000410000ULL,
0x000000312c317220ULL, 0x040fe20000410000ULL, 0x000000382c387220ULL, 0x040fe20000410000ULL,
0x000000392c397220ULL, 0x000fce0000410000ULL, 0x0000003582827220ULL, 0x008fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x00000018092c7811ULL, 0x004fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x000ea400000e0000ULL, 0x0000000e2c0e7220ULL, 0x044fe20000410000ULL,
0x0000000f2c0f7220ULL, 0x040fe20000410000ULL, 0x000000122c127220ULL, 0x040fe20000410000ULL,
0x000000132c137220ULL, 0x040fe20000410000ULL, 0x000000162c167220ULL, 0x040fe20000410000ULL,
0x000000172c177220ULL, 0x040fe20000410000ULL, 0x0000001a2c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b2c1b7220ULL, 0x040fe20000410000ULL, 0x0000001e2c1e7220ULL, 0x040fe20000410000ULL,
0x0000001f2c1f7220ULL, 0x040fe20000410000ULL, 0x000000222c227220ULL, 0x040fe20000410000ULL,
0x000000232c237220ULL, 0x040fe20000410000ULL, 0x000000322c327220ULL, 0x040fe20000410000ULL,
0x000000332c337220ULL, 0x040fe20000410000ULL, 0x0000003a2c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b2c3b7220ULL, 0x000fce0000410000ULL, 0x0000002e2fff7212ULL, 0x000fe200078030ffULL,
0x00000001ff347424ULL, 0x000fd800078e00ffULL, 0x000000367e2c0221ULL, 0x004fe20000010100ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b2c2c0820ULL, 0x000fc80000410000ULL,
0x0000002c00040308ULL, 0x000ea40000000800ULL, 0x000000042d2d0220ULL, 0x004fce0000410000ULL,
0x000000822d827221ULL, 0x000fce0000010000ULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x00000008632e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2f7812ULL, 0x000fc800078ec0ffULL,
0x01a6b0852f0075a7ULL, 0x000ea20008000148ULL, 0x000000082f377c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x004fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6b085370075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x00000004ff2d7819ULL, 0x000fe20000011609ULL, 0x00000003602e7836ULL, 0x000fe20000000000ULL,
0x00009910342c7816ULL, 0x000fe200000000ffULL, 0x00000004632f7824ULL, 0x000fe400078e00ffULL,
0x00000004582d7824ULL, 0x000fe200078e022dULL, 0x000000ff2c00720cULL, 0x000fe20003f05270ULL,
0x000000086c357824ULL, 0x000fe200078e00ffULL, 0x000000082e2e7c11ULL, 0x000fe2000f8e60ffULL,
0x000000016c2c7824ULL, 0x000fe200078e022dULL, 0x000000042f2f7812ULL, 0x000fe200078ec0ffULL,
0x0000000878367824ULL, 0x000fc400078e00ffULL, 0x00000001782d7824ULL, 0x000fe200078e022dULL,
0xfffffff8352c7812ULL, 0x000fe200078ee22cULL, 0x000120002e657836ULL, 0x000fe20000000000ULL,
0x000000022f347812ULL, 0x000fe400078efcffULL, 0xfffffff8362e7812ULL, 0x000fe200078ee22dULL,
0x000000106f2d7824ULL, 0x000fe200078e027aULL, 0x00000034097b7211ULL, 0x000fe200078fe0ffULL,
0x000000102c2c7824ULL, 0x100fe400078e0265ULL, 0x000000102e2e7824ULL, 0x000fe200078e0265ULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff347819ULL, 0x000fe40000011609ULL,
0x00000004ff00723eULL, 0x000fc600000000ffULL, 0x0000000834027836ULL, 0x000fe20000000000ULL,
0x00005410002f7816ULL, 0x000fe20000000000ULL, 0x0000001034367836ULL, 0x000fe40000000000ULL,
0x00000018344c7836ULL, 0x000fe40000000000ULL, 0x00001f022f027589ULL, 0x0004e800000e0000ULL,
0x00001f362f057589ULL, 0x00046800000e0000ULL, 0x00001f342f037589ULL, 0x00046800000e0000ULL,
0x00001f4c2f007589ULL, 0x00046400000e0000ULL, 0x000000002c5c783bULL, 0x000ae80000000200ULL,
0x000000002e34783bULL, 0x0044620000000200ULL, 0x0000000000200947ULL, 0x020fea0003800000ULL,
0x000000035c5c7232ULL, 0x08afe40000000000ULL, 0x000000035e5e7232ULL, 0x000fe40000000000ULL,
0x000000025d5d7232ULL, 0x080fe40000000000ULL, 0x000000025f5f7232ULL, 0x000fe40000000000ULL,
0x0000000534347232ULL, 0x080fe40000000000ULL, 0x0000000536367232ULL, 0x000fc40000000000ULL,
0x0000000035357232ULL, 0x080fe40000000000ULL, 0x0000000037377232ULL, 0x000fce0000000000ULL,
0x000000086c4d7824ULL, 0x040fe200078e00ffULL, 0x000000002d2c783bULL, 0x004ea20000004200ULL,
0x000000016c6c7824ULL, 0x000fe400078e027bULL, 0x0000001072707824ULL, 0x100fe400078e0265ULL,
0x00000010716e7824ULL, 0x000fe200078e0265ULL, 0xfffffff84d4d7812ULL, 0x000fca00078ee26cULL,
0x000000104d4d7824ULL, 0x000fcc00078e027aULL, 0x000000004d4c783bULL, 0x000f620000004200ULL,
0x00000018ff697819ULL, 0x104fe4000001162dULL, 0x000000ff2f6c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff877819ULL, 0x000fe4000001162dULL, 0x000000ff2d837812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2d8b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff867819ULL, 0x000fc4000001162cULL,
0x00000010ff847819ULL, 0x100fe4000001162eULL, 0x000000ff2e6b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe4000001162eULL, 0x00000010ff667819ULL, 0x128fe4000001164cULL,
0x000000ff4c6d7812ULL, 0x002fe400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fc4000001164cULL,
0x0000ffff4c687812ULL, 0x000fe400078ec0ffULL, 0x000000ff4d727812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4c7819ULL, 0x100fe4000001164fULL, 0x000000ff4f897812ULL, 0x040fe400078ec0ffULL,
0x00000018ff887819ULL, 0x000fe4000001164fULL, 0x0000ffff4f2d7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff737819ULL, 0x000fe4000001164eULL, 0x00000069ff4f723eULL, 0x000fe400020006ffULL,
0x0000006cff69723eULL, 0x000fe400020006ffULL, 0x0000006dff6c723eULL, 0x000fe400020006ffULL,
0x0000ffff2e647812ULL, 0x000fe400078ec0ffULL, 0x00000072ff6d723eULL, 0x000fc400020006ffULL,
0x00000010ff857819ULL, 0x100fe4000001162fULL, 0x00000018ff2e7819ULL, 0x000fe4000001162fULL,
0x00000073ff72723eULL, 0x000fe400020006ffULL, 0x000000ff2c807812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7f7819ULL, 0x000fe4000001162cULL, 0x0000ffff2c8a7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff2f657812ULL, 0x000fe400078ec0ffULL, 0x00000088ff73723eULL, 0x000fe400020006ffULL,
0x00000018ff717819ULL, 0x000fe4000001164dULL, 0x00000010ff2f7819ULL, 0x000fe4000001164eULL,
0x000000ff4e7d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4e2c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff86867812ULL, 0x000fe400078ec0ffULL, 0x000000ff87887812ULL, 0x000fe400078ec0ffULL,
0x0000006bff4e723eULL, 0x000fe400020006ffULL, 0x0000002eff6b723eULL, 0x000fe400020006ffULL,
0x000000ff85857812ULL, 0x000fe400078ec0ffULL, 0x0000006fff2e723eULL, 0x000fc400020006ffULL,
0x00000008ff647819ULL, 0x000fe40000011664ULL, 0x00000008ff657819ULL, 0x000fe40000011665ULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000071ff6f723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fc400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000010ff677819ULL, 0x000fe4000001164dULL,
0x00000089ff71723eULL, 0x000fe400020006ffULL, 0x00000008ff877819ULL, 0x000fe4000001168aULL,
0x00000008ff897819ULL, 0x000fe4000001168bULL, 0x00000085ff8a723eULL, 0x000fc400020006ffULL,
0x000000ff84847812ULL, 0x000fe400078ec0ffULL, 0x00000064ff85723eULL, 0x000fe400020006ffULL,
0x00000065ff8b723eULL, 0x000fe400020006ffULL, 0x0000541080647816ULL, 0x000fe40000000086ULL,
0x0000541083657816ULL, 0x000fe40000000088ULL, 0x0000007fff7f723eULL, 0x000fc400020006ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x000000ff66807812ULL, 0x000fe200078ec0ffULL,
0x00000064340c723cULL, 0x000fe2000000180cULL, 0x000000ff67837812ULL, 0x000fe400078ec0ffULL,
0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff687819ULL, 0x000fe20000011668ULL,
0x000000645c54723cULL, 0x000fe20000001854ULL, 0x00000084ff84723eULL, 0x000fc400020006ffULL,
0x0000541087667816ULL, 0x000fe4000000007fULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000068ff7f723eULL, 0x000fe400020006ffULL,
0x00000008ff4d7819ULL, 0x000fe4000001164dULL, 0x000054104e687816ULL, 0x000fc40000000084ULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x000000ff2f4e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x000054106c6c7816ULL, 0x000fe40000000080ULL, 0x000054106d6d7816ULL, 0x000fc40000000083ULL,
0x0000004dff2f723eULL, 0x000fe400020006ffULL, 0x00000008ff807819ULL, 0x000fe4000001162cULL,
0x00000008ff837819ULL, 0x000fe2000001162dULL, 0x0000006c341c723cULL, 0x000fe2000000181cULL,
0x00005410856a7816ULL, 0x000fe4000000006aULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x0000541089677816ULL, 0x000fe2000000004fULL, 0x0000006c5c48723cULL, 0x000fe20000001848ULL,
0x0000004eff84723eULL, 0x000fc400020006ffULL, 0x0000004cff85723eULL, 0x000fe400020006ffULL,
0x000000006e4c783bULL, 0x0002a20000000200ULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x000000663410723cULL, 0x000fe20000001810ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x000054102f6f7816ULL, 0x000fe4000000006fULL, 0x0000541069697816ULL, 0x000fe2000000008aULL,
0x000000665c3c723cULL, 0x000fe2000000183cULL, 0x000054107f6e7816ULL, 0x002fc4000000002eULL,
0x00000000702c783bULL, 0x0002a20000000200ULL, 0x000054108b6b7816ULL, 0x000fe4000000006bULL,
0x0000541071717816ULL, 0x000fe20000000085ULL, 0x000000683414723cULL, 0x000fe20000001814ULL,
0x0000541080727816ULL, 0x000fe40000000072ULL, 0x0000541083737816ULL, 0x000fe40000000073ULL,
0x000054107d707816ULL, 0x002fe20000000084ULL, 0x0000006a3418723cULL, 0x000fec0000001818ULL,
0x0000006e3420723cULL, 0x000fec0000001820ULL, 0x000000703430723cULL, 0x000fec0000001830ULL,
0x000000685c40723cULL, 0x000fec0000001840ULL, 0x0000006a5c44723cULL, 0x000fec0000001844ULL,
0x0000006e5c50723cULL, 0x000fec0000001850ULL, 0x000000705c28723cULL, 0x000fec0000001828ULL,
0x000000725c24723cULL, 0x000fec0000001824ULL, 0x000000723434723cULL, 0x000fe20000001838ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000200947ULL, 0x004fde0003800000ULL,
0x000000034c4c7232ULL, 0x080fe40000000000ULL, 0x000000034e4e7232ULL, 0x000fe40000000000ULL,
0x000000024d4d7232ULL, 0x080fe40000000000ULL, 0x000000024f4f7232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x080fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x000000007c5c783bULL, 0x000e620000004200ULL, 0x00000001787b7824ULL, 0x040fe400078e027bULL,
0x0000000878787824ULL, 0x000fe400078e00ffULL, 0x0000000107077836ULL, 0x000fc60000000000ULL,
0xfffffff8787b7812ULL, 0x000fca00078ee27bULL, 0x000000107b387824ULL, 0x000fe200078e027aULL,
0x00000010ff397819ULL, 0x002fe4000001165cULL, 0x00000010ff3b7819ULL, 0x000fe4000001165dULL,
0x000000ff5d647812ULL, 0x000fe400078ec0ffULL, 0x000000ff5c3a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff39397812ULL, 0x000fe400078ec0ffULL, 0x000000ff3b3b7812ULL, 0x000fc400078ec0ffULL,
0x00000064ff65723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x0000003bff3b723eULL, 0x000fe400020006ffULL,
0x0000ffff5c647812ULL, 0x000fe400078ec0ffULL, 0x0000ffff5d687812ULL, 0x000fc400078ec0ffULL,
0x00000018ff677819ULL, 0x000fe4000001165dULL, 0x00000008ff5d7819ULL, 0x000fe40000011664ULL,
0x000054103a647816ULL, 0x000fe40000000039ULL, 0x0000541065657816ULL, 0x000fe4000000003bULL,
0x000000003838783bULL, 0x000e620000004200ULL, 0x00000018ff5c7819ULL, 0x000fe4000001165cULL,
0x00000008ff687819ULL, 0x000fc40000011668ULL, 0x0000005cff66723eULL, 0x000fe200020006ffULL,
0x000000644c54723cULL, 0x000fe20000001854ULL, 0x0000005dff5c723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000068ff5d723eULL, 0x000fe200020006ffULL,
0x000000642c0c723cULL, 0x000fe2000000180cULL, 0x000054105c5c7816ULL, 0x000fe40000000066ULL,
0x000054105d5d7816ULL, 0x000fc40000000067ULL, 0x000000ff5e687812ULL, 0x040fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe4000001165eULL, 0x00000018ff657819ULL, 0x000fe2000001165eULL,
0x0000005c4c3c723cULL, 0x000fe2000000183cULL, 0x0000ffff5e6b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x100fe4000001165fULL, 0x000000ff5f697812ULL, 0x000fe200078ec0ffULL,
0x0000005c2c10723cULL, 0x000fe20000001810ULL, 0x00000018ff6a7819ULL, 0x000fc4000001165fULL,
0x0000ffff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5c7819ULL, 0x000fe4000001166bULL, 0x00000008ff5d7819ULL, 0x000fe4000001165fULL,
0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL, 0x00000065ff65723eULL, 0x000fc400020006ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fc400020006ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x000054105c5c7816ULL, 0x000fe40000000065ULL,
0x000054105d5d7816ULL, 0x000fe4000000006aULL, 0x0000541068687816ULL, 0x000fe40000000064ULL,
0x0000541069697816ULL, 0x000fe4000000005eULL, 0x00000010ff5f7819ULL, 0x002fe20000011639ULL,
0x0000005c4c44723cULL, 0x000fe20000001844ULL, 0x000000ff39657812ULL, 0x000fc400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe40000011639ULL, 0x0000ffff396d7812ULL, 0x000fe200078ec0ffULL,
0x0000005c2c18723cULL, 0x000fe20000001818ULL, 0x00000018ff397819ULL, 0x100fe4000001163aULL,
0x0000ffff386c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff667819ULL, 0x000fe2000001163aULL,
0x000000684c40723cULL, 0x000fe20000001840ULL, 0x00000010ff5c7819ULL, 0x000fc40000011638ULL,
0x000000ff3a677812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3a6e7812ULL, 0x000fe200078ec0ffULL,
0x000000682c14723cULL, 0x000fe20000001814ULL, 0x00000018ff6a7819ULL, 0x100fe4000001163bULL,
0x000000ff3b3a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3b6f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff697819ULL, 0x000fc4000001163bULL, 0x00000039ff68723eULL, 0x000fe400020006ffULL,
0x00000018ff5d7819ULL, 0x000fe40000011638ULL, 0x00000008ff397819ULL, 0x000fe4000001166cULL,
0x00000008ff3b7819ULL, 0x000fe4000001166dULL, 0x000000ff385e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL, 0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL,
0x0000003aff6b723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000039ff3a723eULL, 0x000fe400020006ffULL,
0x0000003bff3b723eULL, 0x000fc400020006ffULL, 0x0000005eff38723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x000054103a3a7816ULL, 0x000fe4000000005dULL,
0x000054103b3b7816ULL, 0x000fc40000000064ULL, 0x000000ff66667812ULL, 0x000fe400078ec0ffULL,
0x000000ff69697812ULL, 0x000fe400078ec0ffULL, 0x0000541038387816ULL, 0x000fe2000000005cULL,
0x0000003a4c50723cULL, 0x000fe20000001850ULL, 0x0000541065397816ULL, 0x000fe4000000005fULL,
0x00000008ff5c7819ULL, 0x000fe4000001166eULL, 0x00000008ff5f7819ULL, 0x000fe2000001166fULL,
0x0000003a2c20723cULL, 0x000fe20000001820ULL, 0x00000067ff67723eULL, 0x000fc400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x000000384c48723cULL, 0x000fe20000001848ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x00000001ff3b7424ULL, 0x000fe200078e00ffULL, 0x0000005cff5e723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x000000382c1c723cULL, 0x000fe2000000181cULL,
0x00005410675c7816ULL, 0x000fe20000000066ULL, 0x0000003b063879a7ULL, 0x0002e2000850003fULL,
0x000054106b5d7816ULL, 0x000fc40000000069ULL, 0x000054105e5e7816ULL, 0x000fe40000000068ULL,
0x000054105f5f7816ULL, 0x000fc6000000006aULL, 0x0000005c2c30723cULL, 0x000fe20000001830ULL,
0x0000000860067c11ULL, 0x002fca000f8e18ffULL, 0x0000005c4c28723cULL, 0x000fe20000001828ULL,
0x01a6a03b06ff79a7ULL, 0x0007ea000850003fULL, 0x0000005e4c24723cULL, 0x000fec0000001824ULL,
0x0000005e2c2c723cULL, 0x000fe20000001834ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffff5c00e09947ULL, 0x00cfde000383ffffULL, 0x000000ff6200720cULL, 0x000fe20003f05270ULL,
0x000000ffff4c7224ULL, 0x000fe400078e0045ULL, 0x000000ffff457224ULL, 0x000fe400078e0044ULL,
0x000000ffff447224ULL, 0x000fe400078e0041ULL, 0x000000ffff417224ULL, 0x000fe400078e0040ULL,
0x000000ffff407224ULL, 0x000fe400078e003dULL, 0x000000ffff3d7224ULL, 0x000fc400078e003cULL,
0x0000000400648947ULL, 0x000fea0003800000ULL, 0x0180000082007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000c2e000047802ULL, 0x000fce0000000f00ULL, 0x000000b0002c7944ULL, 0x01efea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000008200037308ULL, 0x008ee40000001000ULL,
0xbf80000003007423ULL, 0x008fc80000000082ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009a00ff027b82ULL, 0x000f640000000a00ULL, 0x0000000602037981ULL, 0x02aee2000c1e9900ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000001805077811ULL, 0x042fe400078ff0ffULL,
0x00000002ff097819ULL, 0x000fe40000011605ULL, 0x0000000805357811ULL, 0x040fe400078ff0ffULL,
0x0000001005377811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x00cfca0000410000ULL,
0x00001f0900047589ULL, 0x000e6800000e0000ULL, 0x00001f3500067589ULL, 0x000ea800000e0000ULL,
0x00001f3700057589ULL, 0x000ee800000e0000ULL, 0x00001f0700077589ULL, 0x000f6200000e0000ULL,
0x0000005404547220ULL, 0x042fe20000410000ULL, 0x0000005504557220ULL, 0x040fe20000410000ULL,
0x0000003d043d7220ULL, 0x040fe20000410000ULL, 0x0000004004407220ULL, 0x040fe20000410000ULL,
0x0000004104417220ULL, 0x040fe20000410000ULL, 0x0000004404447220ULL, 0x040fe20000410000ULL,
0x0000004504457220ULL, 0x040fe20000410000ULL, 0x0000004c044c7220ULL, 0x040fe20000410000ULL,
0x0000004804487220ULL, 0x040fe20000410000ULL, 0x0000004904497220ULL, 0x040fe20000410000ULL,
0x0000005004507220ULL, 0x040fe20000410000ULL, 0x0000005104517220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x000fe20000410000ULL,
0x0000005606567220ULL, 0x044fe20000410000ULL, 0x0000005706577220ULL, 0x040fe20000410000ULL,
0x0000003e063e7220ULL, 0x040fe20000410000ULL, 0x0000003f063f7220ULL, 0x040fe20000410000ULL,
0x0000004206427220ULL, 0x040fe20000410000ULL, 0x0000004306437220ULL, 0x040fe20000410000ULL,
0x0000004606467220ULL, 0x040fe20000410000ULL, 0x0000004706477220ULL, 0x040fe20000410000ULL,
0x0000004a064a7220ULL, 0x040fe20000410000ULL, 0x0000004b064b7220ULL, 0x040fe20000410000ULL,
0x0000005206527220ULL, 0x040fe20000410000ULL, 0x0000005306537220ULL, 0x040fe20000410000ULL,
0x0000002a062a7220ULL, 0x040fe20000410000ULL, 0x0000002b062b7220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000002706277220ULL, 0x000fe20000410000ULL,
0x0000000c050c7220ULL, 0x048fe20000410000ULL, 0x0000000d050d7220ULL, 0x040fe20000410000ULL,
0x0000001005107220ULL, 0x040fe20000410000ULL, 0x0000001105117220ULL, 0x040fe20000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x0000001505157220ULL, 0x040fe20000410000ULL,
0x0000001805187220ULL, 0x040fe20000410000ULL, 0x0000001905197220ULL, 0x040fe20000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x0000001d051d7220ULL, 0x040fe20000410000ULL,
0x0000002005207220ULL, 0x040fe20000410000ULL, 0x0000002105217220ULL, 0x040fe20000410000ULL,
0x0000003005307220ULL, 0x040fe20000410000ULL, 0x0000003105317220ULL, 0x040fe20000410000ULL,
0x0000002c052c7220ULL, 0x040fe20000410000ULL, 0x0000002d052d7220ULL, 0x000fe20000410000ULL,
0x0000000e070e7220ULL, 0x060fe20000410000ULL, 0x0000000f070f7220ULL, 0x040fe20000410000ULL,
0x0000001207127220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000001607167220ULL, 0x040fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001b071b7220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000003207327220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x040fe20000410000ULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0x0000002f072f7220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000f620000000000ULL, 0x0000000163637812ULL, 0x000fe400078ec0ffULL,
0x000000484948723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000505150723eULL, 0x000fc400000000ffULL, 0x000000282928723eULL, 0x000fe400000000ffULL,
0x000000242524723eULL, 0x000fe400000000ffULL, 0x000000565757723eULL, 0x000fe400000000ffULL,
0x0000003e3f3e723eULL, 0x000fe400000000ffULL, 0x000000424342723eULL, 0x000fe400000000ffULL,
0x000000464746723eULL, 0x000fc400000000ffULL, 0x0000541057567816ULL, 0x140fe4000000003eULL,
0x0000763257577816ULL, 0x000fe4000000003eULL, 0x0000004a4b4a723eULL, 0x000fe400000000ffULL,
0x000000525325723eULL, 0x000fe400000000ffULL, 0x0000000800057811ULL, 0x062fe200078ff0ffULL,
0x000000015b5b7824ULL, 0x000fe200078e0200ULL, 0x0000000200027812ULL, 0x008fc400078ec0ffULL,
0x00000002ff077819ULL, 0x000fe20000011600ULL, 0x0000000805387824ULL, 0x000fe200078e00ffULL,
0x0000000502037211ULL, 0x000fe400078ff8ffULL, 0x0000001000057811ULL, 0x040fe200078ff0ffULL,
0x0000000807367824ULL, 0x000fe200078e00ffULL, 0xfffffff838387812ULL, 0x000fe400078ee203ULL,
0x0000001800097811ULL, 0x000fe200078ff0ffULL, 0x0000000805357824ULL, 0x000fe200078e00ffULL,
0x0000000702037211ULL, 0x000fc400078ff8ffULL, 0x0000000502047211ULL, 0x040fe200078ff8ffULL,
0x00000008093c7824ULL, 0x000fe200078e00ffULL, 0x0000000902057211ULL, 0x000fe200078ff8ffULL,
0x0000000807097824ULL, 0x040fe200078e00ffULL, 0xfffffff8353a7812ULL, 0x000fe200078ee204ULL,
0x0000000203027836ULL, 0x000fe20000000000ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee205ULL,
0x0000000807047824ULL, 0x000fe200078e00ffULL, 0x0000002a2b2a723eULL, 0x000fe200000000ffULL,
0x0000000403067836ULL, 0x000fe20000000000ULL, 0xfffffff809087812ULL, 0x000fe200078ee202ULL,
0x0000000603077836ULL, 0x000fe20000000000ULL, 0x0000000863027c11ULL, 0x000fe2000f8e68ffULL,
0x0000000800057824ULL, 0x000fe200078e00ffULL, 0xfffffff804047812ULL, 0x000fc400078ee203ULL,
0xfffffff809347812ULL, 0x000fe200078ee206ULL, 0x0000100061037824ULL, 0x100fe200078e0202ULL,
0xfffffff836367812ULL, 0x000fe200078ee207ULL, 0x000000105b5b7824ULL, 0x000fe200078e0202ULL,
0x0000000805067812ULL, 0x000fe200078ec0ffULL, 0x0000001004057824ULL, 0x100fe200078e0203ULL,
0x0000003d4004723eULL, 0x000fe200000000ffULL, 0x0000001038377824ULL, 0x100fe200078e0203ULL,
0x000000262726723eULL, 0x000fe200000000ffULL, 0x000000103a397824ULL, 0x100fe200078e0203ULL,
0x0000000c0d0c723eULL, 0x000fe200000000ffULL, 0x000000103c3b7824ULL, 0x100fe200078e0203ULL,
0x000000141514723eULL, 0x000fe200000000ffULL, 0x0000001008077824ULL, 0x100fe200078e0203ULL,
0x000000181918723eULL, 0x000fe200000000ffULL, 0x0000001034097824ULL, 0x100fe200078e0203ULL,
0x0000001c1d1c723eULL, 0x000fe200000000ffULL, 0x0000001036357824ULL, 0x000fe200078e0203ULL,
0x000000545503723eULL, 0x000fe200000000ffULL, 0x0000000105057824ULL, 0x000fe200078e0206ULL,
0x000000202120723eULL, 0x000fe200000000ffULL, 0x0000000106377824ULL, 0x040fe200078e0237ULL,
0x00005410033c7816ULL, 0x140fe20000000004ULL, 0x0000000106397824ULL, 0x040fe200078e0239ULL,
0x00007632033d7816ULL, 0x000fe20000000004ULL, 0x00000001063b7824ULL, 0x000fe200078e023bULL,
0x000000414403723eULL, 0x000fe200000000ffULL, 0x0000000106087824ULL, 0x000fe200078e0207ULL,
0x000000454c04723eULL, 0x000fe200000000ffULL, 0x0000000106097824ULL, 0x040fe200078e0209ULL,
0x0000003c05007388ULL, 0x0003e20000000a00ULL, 0x0000000106357824ULL, 0x000fe200078e0235ULL,
0x0000541003067816ULL, 0x000fc40000000004ULL, 0x0000763203077816ULL, 0x000fe40000000004ULL,
0x0000541048047816ULL, 0x140fe40000000050ULL, 0x000000303130723eULL, 0x000fe200000000ffULL,
0x0000000608007388ULL, 0x0007e20000000a00ULL, 0x0000000e0f0e723eULL, 0x000fe400000000ffULL,
0x0000763248057816ULL, 0x002fe40000000050ULL, 0x000000161716723eULL, 0x000fc400000000ffULL,
0x0000001a1b1a723eULL, 0x000fe200000000ffULL, 0x0000000409007388ULL, 0x0003e20000000a00ULL,
0x0000001e1f1e723eULL, 0x000fe400000000ffULL, 0x00000022230f723eULL, 0x000fe400000000ffULL,
0x000000101106723eULL, 0x008fe400000000ffULL, 0x000000121307723eULL, 0x000fe400000000ffULL,
0x00007632160d7816ULL, 0x000fc4000000001aULL, 0x000076321e217816ULL, 0x000fe4000000000fULL,
0x0000541028047816ULL, 0x142fe40000000024ULL, 0x0000763228057816ULL, 0x000fe40000000024ULL,
0x000054104a247816ULL, 0x140fe40000000025ULL, 0x000076324a257816ULL, 0x000fe20000000025ULL,
0x0000000435007388ULL, 0x0003e20000000a00ULL, 0x000000323332723eULL, 0x000fc400000000ffULL,
0x0000002e2f19723eULL, 0x000fe200000000ffULL, 0x0000005637007388ULL, 0x000fe20000000a00ULL,
0x000000ff6100720cULL, 0x000fe40003f05270ULL, 0x0000541042047816ULL, 0x142fe40000000046ULL,
0x0000763242057816ULL, 0x000fca0000000046ULL, 0x0004000408007388ULL, 0x0003e80000000a00ULL,
0x0004002409007388ULL, 0x000fe20000000a00ULL, 0x000054102a047816ULL, 0x142fe40000000026ULL,
0x000076322a057816ULL, 0x000fca0000000026ULL, 0x0004000435007388ULL, 0x0003e40000000a00ULL,
0x000054100c047816ULL, 0x142fe40000000006ULL, 0x000076320c057816ULL, 0x000fe40000000006ULL,
0x000054100e067816ULL, 0x140fe40000000007ULL, 0x000076320e077816ULL, 0x000fe20000000007ULL,
0x0000000439007388ULL, 0x0003e20000000a00ULL, 0x00005410160c7816ULL, 0x000fc4000000001aULL,
0x0000541014047816ULL, 0x142fe40000000018ULL, 0x0000763214057816ULL, 0x000fe40000000018ULL,
0x0000002c2d18723eULL, 0x000fc600000000ffULL, 0x0008000408007388ULL, 0x0003e40000000a00ULL,
0x000054101c047816ULL, 0x142fe40000000020ULL, 0x000076321c057816ULL, 0x000fe40000000020ULL,
0x000054101e207816ULL, 0x000fc6000000000fULL, 0x0008000409007388ULL, 0x0003e40000000a00ULL,
0x0000541030047816ULL, 0x142fe40000000018ULL, 0x0000763230057816ULL, 0x000fca0000000018ULL,
0x0008000435007388ULL, 0x000fe80000000a00ULL, 0x000000063b007388ULL, 0x000fe80000000a00ULL,
0x000c000c08007388ULL, 0x0003e80000000a00ULL, 0x000c002009007388ULL, 0x0007e20000000a00ULL,
0x0000541032087816ULL, 0x002fc40000000019ULL, 0x0000763232097816ULL, 0x008fca0000000019ULL,
0x000c000835007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000005b047984ULL, 0x000e680000000c00ULL, 0x000400005b107984ULL, 0x000ee80000000c00ULL,
0x000800005b187984ULL, 0x000f680000000c00ULL, 0x000c00005b207984ULL, 0x000f680000000c00ULL,
0x001000005b0c7984ULL, 0x000f680000000c00ULL, 0x001400005b147984ULL, 0x000f680000000c00ULL,
0x001800005b1c7984ULL, 0x000f680000000c00ULL, 0x001c00005b247984ULL, 0x000f620000000c00ULL,
0x200000ff07077230ULL, 0x002fc40000000000ULL, 0x200000ff06067230ULL, 0x000fe40000000000ULL,
0x200000ff05057230ULL, 0x000fe40000000000ULL, 0x200000ff04047230ULL, 0x000fe40000000000ULL,
0x200000ff13137230ULL, 0x008fe40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fc40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x200000ff1b1b7230ULL, 0x024fe40000000000ULL, 0x200000ff1a1a7230ULL, 0x000fe40000000000ULL,
0x200000ff19197230ULL, 0x000fe40000000000ULL, 0x200000ff18187230ULL, 0x000fe40000000000ULL,
0x200000ff23237230ULL, 0x000fc40000000000ULL, 0x200000ff22227230ULL, 0x000fe40000000000ULL,
0x200000ff21217230ULL, 0x000fe40000000000ULL, 0x200000ff20207230ULL, 0x000fe40000000000ULL,
0x0000000f07077230ULL, 0x000fe40000000000ULL, 0x0000000e06067230ULL, 0x000fe40000000000ULL,
0x0000000d05057230ULL, 0x000fc40000000000ULL, 0x0000000c04047230ULL, 0x000fe40000000000ULL,
0x0000001713137230ULL, 0x000fe40000000000ULL, 0x0000001612127230ULL, 0x000fe20000000000ULL,
0x000000045b007388ULL, 0x0003e20000000c00ULL, 0x0000001511117230ULL, 0x000fe40000000000ULL,
0x0000001410107230ULL, 0x000fe40000000000ULL, 0x0000001f1b1b7230ULL, 0x000fc40000000000ULL,
0x0000001e1a1a7230ULL, 0x000fe20000000000ULL, 0x000400105b007388ULL, 0x0003e20000000c00ULL,
0x0000001d19197230ULL, 0x000fe40000000000ULL, 0x0000001c18187230ULL, 0x000fe40000000000ULL,
0x0000002723237230ULL, 0x000fe40000000000ULL, 0x0000002622227230ULL, 0x000fe20000000000ULL,
0x000800185b007388ULL, 0x0003e20000000c00ULL, 0x0000002521217230ULL, 0x000fc40000000000ULL,
0x0000002420207230ULL, 0x000fca0000000000ULL, 0x000c00205b007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff0c7819ULL, 0x000fc80000011600ULL, 0x0000000b0c00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x000000ffff047224ULL, 0x002fe200078e00ffULL, 0x0000000800037d06ULL, 0x000e620008209000ULL,
0x0000850000097ab9ULL, 0x000fe20000000800ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000700127812ULL, 0x000fca00078ec0ffULL, 0x0000000300037308ULL, 0x002e640000001000ULL,
0x0ffffffe03097836ULL, 0x002fe40000000000ULL, 0x000000010c037824ULL, 0x000fc800078e0200ULL,
0x0000000900057305ULL, 0x000e62000021f000ULL, 0x0000000703037812ULL, 0x000fc800078ec0ffULL,
0x0ffffff803037812ULL, 0x000fe200078ef800ULL, 0x000000ffff077224ULL, 0x002fc800078e0a05ULL,
0x0000000807077c24ULL, 0x000fc8000f8e02ffULL, 0x0000000705047227ULL, 0x000fc800078e0004ULL,
0x0000000175057824ULL, 0x000fc800078e020cULL, 0x0000000504067227ULL, 0x000fc800078e00ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a06ULL, 0x0000000808077c24ULL, 0x000fe4000f8e0205ULL,
0x0000001003087824ULL, 0x000fe200078e0202ULL, 0x00000008ff037c12ULL, 0x000fe4000f8e33ffULL,
0x0000000807007c0cULL, 0x000fe4000bf06070ULL, 0x00000000080c7984ULL, 0x0002a40000000c00ULL,
0x0000002000087836ULL, 0x002fd20000000000ULL, 0x8000000807070c36ULL, 0x000fe40008000000ULL,
0x0000000106060836ULL, 0x000fe20000000000ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x0000000106061836ULL, 0x000fca0000000000ULL,
0x0000000603067207ULL, 0x000fca0004000000ULL, 0x000000ffff107224ULL, 0x000fe400078e0a06ULL,
0x0000000906067c24ULL, 0x000fe4000f8e0277ULL, 0x0000000810057c24ULL, 0x000fc8000f8e0205ULL,
0x0000000806057c24ULL, 0x000fca000f8e0205ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000405067c11ULL, 0x000fc8000f8240ffULL,
0x0000000505077c11ULL, 0x000fe200088f4410ULL, 0x0000000863057824ULL, 0x000fe200078e0212ULL,
0x00000003ff107819ULL, 0x000fc60000011608ULL, 0x0000001005067825ULL, 0x000fe200078e0006ULL,
0x0000000b1000720cULL, 0x000fc80003f26070ULL, 0x0000000c06007986ULL, 0x0043f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000175057824ULL, 0x100fe400078e0210ULL,
0x0000000108107824ULL, 0x000fe400078e0210ULL, 0x0000000504067227ULL, 0x002fc800078e00ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL, 0x000000080c077c24ULL, 0x000fca000f8e0205ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fe4000bf46070ULL,
0x0000000710077812ULL, 0x000fc800078ec0ffULL, 0x0ffffff807077812ULL, 0x000fe400078ef808ULL,
0x0000000708087812ULL, 0x000fc600078ec0ffULL, 0x0000001007097824ULL, 0x000fe400078e0202ULL,
0x0000000106062836ULL, 0x000fc60000000000ULL, 0x00000000090c7984ULL, 0x0002a40000000c00ULL,
0x0000000603067207ULL, 0x000fca0004000000ULL, 0x000000ffff107224ULL, 0x000fe400078e0a06ULL,
0x0000000906067c24ULL, 0x000fe4000f8e0277ULL, 0x0000000810057c24ULL, 0x000fe4000f8e0205ULL,
0x0000004000097836ULL, 0x002fe40000000000ULL, 0x0000000806057c24ULL, 0x000fca000f8e0205ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405067c11ULL, 0x000fc8000f8240ffULL, 0x0000000505077c11ULL, 0x000fe200088f4410ULL,
0x0000000863057824ULL, 0x000fe200078e0208ULL, 0x00000003ff087819ULL, 0x000fc60000011609ULL,
0x0000001005067825ULL, 0x000fe200078e0006ULL, 0x0000000b0800720cULL, 0x000fc80003f26070ULL,
0x0000000c06007986ULL, 0x0043f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000175057824ULL, 0x100fe400078e0208ULL, 0x0000000109087824ULL, 0x000fe400078e0208ULL,
0x0000000504067227ULL, 0x002fc600078e00ffULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL, 0x000000080c077c24ULL, 0x000fca000f8e0205ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff808077812ULL, 0x000fca00078ef809ULL, 0x0000001007087824ULL, 0x000fca00078e0202ULL,
0x00000000080c7984ULL, 0x0002a20000000c00ULL, 0x0000000106062836ULL, 0x000fca0000000000ULL,
0x0000000603067207ULL, 0x000fe20004000000ULL, 0x0000006000087836ULL, 0x002fc80000000000ULL,
0x000000ffff107224ULL, 0x000fe400078e0a06ULL, 0x0000000906067c24ULL, 0x000fe4000f8e0277ULL,
0x0000000810057c24ULL, 0x000fe2000f8e0205ULL, 0x0000000709107812ULL, 0x000fc600078ec0ffULL,
0x0000000806057c24ULL, 0x000fca000f8e0205ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000000405067c11ULL, 0x000fc8000f8240ffULL,
0x0000000505077c11ULL, 0x000fe200088f4412ULL, 0x0000000863057824ULL, 0x000fe200078e0210ULL,
0x00000003ff107819ULL, 0x000fc60000011608ULL, 0x0000001005067825ULL, 0x000fe200078e0006ULL,
0x0000000b1000720cULL, 0x000fc80003f26070ULL, 0x0000000c06007986ULL, 0x0043f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000175057824ULL, 0x100fe400078e0210ULL,
0x0000000108107824ULL, 0x000fe400078e0210ULL, 0x0000000504067227ULL, 0x002fc800078e00ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL, 0x000000080c077c24ULL, 0x000fca000f8e0205ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fe4000bf46070ULL,
0x0000000710077812ULL, 0x000fc800078ec0ffULL, 0x0ffffff807077812ULL, 0x000fe400078ef808ULL,
0x0000000708087812ULL, 0x000fc600078ec0ffULL, 0x0000001007097824ULL, 0x000fe400078e0202ULL,
0x0000000106062836ULL, 0x000fc60000000000ULL, 0x00000000090c7984ULL, 0x0002a40000000c00ULL,
0x0000000603067207ULL, 0x000fca0004000000ULL, 0x000000ffff107224ULL, 0x000fe400078e0a06ULL,
0x0000000906067c24ULL, 0x000fe4000f8e0277ULL, 0x0000000810057c24ULL, 0x000fe4000f8e0205ULL,
0x0000008000097836ULL, 0x002fe40000000000ULL, 0x0000000806057c24ULL, 0x000fca000f8e0205ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405067c11ULL, 0x000fc8000f8240ffULL, 0x0000000505077c11ULL, 0x000fe200088f4410ULL,
0x0000000863057824ULL, 0x000fe200078e0208ULL, 0x00000003ff087819ULL, 0x000fc60000011609ULL,
0x0000001005067825ULL, 0x000fe200078e0006ULL, 0x0000000b0800720cULL, 0x000fc80003f26070ULL,
0x0000000c06007986ULL, 0x0043f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000175057824ULL, 0x100fe400078e0208ULL, 0x0000000109087824ULL, 0x000fe400078e0208ULL,
0x0000000504067227ULL, 0x002fc600078e00ffULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL, 0x000000080c077c24ULL, 0x000fca000f8e0205ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff808077812ULL, 0x000fca00078ef809ULL, 0x0000001007087824ULL, 0x000fca00078e0202ULL,
0x00000000080c7984ULL, 0x0002a20000000c00ULL, 0x0000000106062836ULL, 0x000fca0000000000ULL,
0x0000000603067207ULL, 0x000fe20004000000ULL, 0x000000a000087836ULL, 0x002fc80000000000ULL,
0x000000ffff107224ULL, 0x000fe400078e0a06ULL, 0x0000000906067c24ULL, 0x000fe4000f8e0277ULL,
0x0000000810057c24ULL, 0x000fe2000f8e0205ULL, 0x0000000709107812ULL, 0x000fc600078ec0ffULL,
0x0000000806057c24ULL, 0x000fca000f8e0205ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000000405067c11ULL, 0x000fc8000f8240ffULL,
0x0000000505077c11ULL, 0x000fe200088f4412ULL, 0x0000000863057824ULL, 0x000fe200078e0210ULL,
0x00000003ff107819ULL, 0x000fc60000011608ULL, 0x0000001005067825ULL, 0x000fe200078e0006ULL,
0x0000000b1000720cULL, 0x000fc80003f26070ULL, 0x0000000c06007986ULL, 0x0043f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000175057824ULL, 0x100fe400078e0210ULL,
0x0000000108107824ULL, 0x000fe400078e0210ULL, 0x0000000504067227ULL, 0x002fc800078e00ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL, 0x000000080c077c24ULL, 0x000fca000f8e0205ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fe4000bf46070ULL,
0x0000000710077812ULL, 0x000fc800078ec0ffULL, 0x0ffffff807077812ULL, 0x000fe400078ef808ULL,
0x0000000708087812ULL, 0x000fc600078ec0ffULL, 0x0000001007097824ULL, 0x000fe400078e0202ULL,
0x0000000106062836ULL, 0x000fc60000000000ULL, 0x00000000090c7984ULL, 0x0002a40000000c00ULL,
0x0000000603067207ULL, 0x000fca0004000000ULL, 0x000000ffff107224ULL, 0x000fe400078e0a06ULL,
0x0000000906067c24ULL, 0x000fe4000f8e0277ULL, 0x0000000810057c24ULL, 0x000fe4000f8e0205ULL,
0x000000c000097836ULL, 0x002fe40000000000ULL, 0x0000000806057c24ULL, 0x000fca000f8e0205ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405067c11ULL, 0x000fc8000f8240ffULL, 0x0000000505077c11ULL, 0x000fe200088f4410ULL,
0x0000000863057824ULL, 0x000fe200078e0208ULL, 0x00000003ff087819ULL, 0x000fc60000011609ULL,
0x0000001005067825ULL, 0x000fe200078e0006ULL, 0x0000000b0800720cULL, 0x000fc80003f26070ULL,
0x0000000c06007986ULL, 0x0043f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000175057824ULL, 0x100fe400078e0208ULL, 0x0000000109087824ULL, 0x000fe400078e0208ULL,
0x0000000504067227ULL, 0x002fc600078e00ffULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a06ULL, 0x000000e000007836ULL, 0x000fe40000000000ULL,
0x000000080c077c24ULL, 0x000fca000f8e0205ULL, 0x0000000807007c0cULL, 0x000fda000bf26070ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000106061836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff808077812ULL, 0x000fca00078ef809ULL,
0x0000001007087824ULL, 0x000fca00078e0202ULL, 0x00000000080c7984ULL, 0x0002a20000000c00ULL,
0x0000000106062836ULL, 0x000fca0000000000ULL, 0x0000000603067207ULL, 0x000fe40004000000ULL,
0x00000003ff087819ULL, 0x002fc60000011600ULL, 0x000000ffff107224ULL, 0x000fe400078e0a06ULL,
0x0000000906067c24ULL, 0x000fe4000f8e0277ULL, 0x0000000810057c24ULL, 0x000fe2000f8e0205ULL,
0x0000000709107812ULL, 0x000fe200078ec0ffULL, 0x0000000175757824ULL, 0x000fe400078e0208ULL,
0x0000000806057c24ULL, 0x000fca000f8e0205ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000000405067c11ULL, 0x000fc8000f8240ffULL,
0x0000000505077c11ULL, 0x000fe200088f4412ULL, 0x0000000863057824ULL, 0x000fe200078e0210ULL,
0x0000000b0800720cULL, 0x000fc60003f26070ULL, 0x0000001005067825ULL, 0x000fca00078e0006ULL,
0x0000000c06007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x00000075040c7227ULL, 0x002fc800078e00ffULL, 0x000000ffff047224ULL, 0x000fe400078e0a0cULL,
0x0000000100087824ULL, 0x000fe400078e0208ULL, 0x0000000804047c24ULL, 0x000fc6000f8e0275ULL,
0x0000000708057812ULL, 0x000fe400078ec0ffULL, 0x0000000804007c0cULL, 0x000fe4000bf26070ULL,
0xfffffff805057812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001005057824ULL, 0x000fe400078e0202ULL, 0x0000000863637824ULL, 0x000fc800078e0200ULL,
0x8000000804041c36ULL, 0x000fe40008000000ULL, 0x000000010c0c1836ULL, 0x000fc60000000000ULL,
0x0000000804007c0cULL, 0x000fe4000bf46070ULL, 0x0000000005047984ULL, 0x000e760000000c00ULL,
0x000000010c0c2836ULL, 0x000fca0000000000ULL, 0x0000000c030c7207ULL, 0x000fca0004000000ULL,
0x000000ffff027224ULL, 0x000fe400078e0a0cULL, 0x000000090c0c7c24ULL, 0x000fe4000f8e0277ULL,
0x0000000802757c24ULL, 0x000fc8000f8e0275ULL, 0x000000080c757c24ULL, 0x000fca000f8e0275ULL,
0x000000750a757210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000475027c11ULL, 0x000fc8000f8040ffULL, 0x0000000575037c11ULL, 0x000fc600080f4408ULL,
0x0000001063027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000746300720cULL, 0x000fe20003f06070ULL,
0x00009a00ff727b82ULL, 0x000e620000000a00ULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0xffffffffff0f7424ULL, 0x000fca00078e00ffULL, 0x00009000ff0a7b82ULL, 0x000ea80000000a00ULL,
0x000000027b028824ULL, 0x000fc800078e00ffULL, 0x00009600ff078b82ULL, 0x000ef00000000800ULL,
0x00009200ff0c8b82ULL, 0x000f620000000a00ULL, 0x0000000672727981ULL, 0x002322000c1e9900ULL,
0x0000000702078224ULL, 0x008fc800078e0263ULL, 0x00000004070c8825ULL, 0x020fe400078e000cULL,
0x01a60006ff0679a7ULL, 0x000e660008500008ULL, 0x000000060c0f8981ULL, 0x000ee2000c1e1900ULL,
0x000001ff0500780cULL, 0x000fe20003f04070ULL, 0x0000004000007824ULL, 0x000fe400078e00ffULL,
0x0000004063057824ULL, 0x000fe400078e00ffULL, 0x0000004077027824ULL, 0x000fc400078e00ffULL,
0x0000000f000f7224ULL, 0x008fc800078e02ffULL, 0x000000800f0a7825ULL, 0x004fe400078e000aULL,
0x0000000c00200947ULL, 0x002fea0003800000ULL, 0x00000003ff2e7819ULL, 0x000fe40000011609ULL,
0x00000005760c7248ULL, 0x000fc60007fe0000ULL, 0x000000042e0d7836ULL, 0x000fe40000000000ULL,
0x000000010c227824ULL, 0x000fe400078e0a05ULL, 0x000000010d0c7824ULL, 0x140fe400078e0209ULL,
0x000000080d0f7824ULL, 0x040fe200078e00ffULL, 0x000000220d00720cULL, 0x080fe20003f86070ULL,
0x000000082e0d7836ULL, 0x000fe40000000000ULL, 0x0000004077777824ULL, 0x000fe200078e022eULL,
0xfffffff80f247812ULL, 0x000fe200078ee20cULL, 0x000000010d127824ULL, 0x040fe200078e0209ULL,
0x000000220d00720cULL, 0x040fe20003f06070ULL, 0x000000080d157824ULL, 0x000fc400078e00ffULL,
0x00000080770c7825ULL, 0x000fc600078e00ffULL, 0xfffffff815267812ULL, 0x000fe200078ee212ULL,
0x0000000c2e0f7836ULL, 0x000fe20000000000ULL, 0x000000700c1b7812ULL, 0x000fe200078ef804ULL,
0x00000004770e7836ULL, 0x000fe40000000000ULL, 0x000000010f137824ULL, 0x040fe200078e0209ULL,
0x000000220f00720cULL, 0x040fe20003f26070ULL, 0x000000080f287824ULL, 0x000fe200078e00ffULL,
0x0000001b0a1a7210ULL, 0x000fe20007f5e0ffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee213ULL, 0x0000000c770c7836ULL, 0x000fe20000000000ULL,
0x000000700e1d7812ULL, 0x000fe200078ef804ULL, 0x000000010b1b7824ULL, 0x000fe400010e060dULL,
0x0000000877107836ULL, 0x000fe20000000000ULL, 0x0000001d0a1c7210ULL, 0x000fe20007f5e0ffULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000700c1f7812ULL, 0x000fe400078ef804ULL, 0x00000008630c7c11ULL, 0x000fe2000f8e70ffULL,
0x00000010770e7836ULL, 0x000fe20000000000ULL, 0x0000007010177812ULL, 0x000fe200078ef804ULL,
0x0000001c77187836ULL, 0x000fe40000000000ULL, 0x000000010b1d7824ULL, 0x000fe200010e060fULL,
0x0000001f0a1e7210ULL, 0x000fe20007f5e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000170a167210ULL, 0x000fc60007f7e0ffULL, 0x0000001877127836ULL, 0x000fe20000000000ULL,
0x000000700e157812ULL, 0x000fe200078ef804ULL, 0x0000008018187825ULL, 0x000fc800078e00ffULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x000000010b1f7824ULL, 0x040fe200010e060dULL,
0x00000070180d7812ULL, 0x000fe200078ef804ULL, 0x0000001477107836ULL, 0x000fe20000000000ULL,
0x000000150a0e7210ULL, 0x000fe20007f5e0ffULL, 0x000000010b177824ULL, 0x000fe200018e0611ULL,
0x0000007012157812ULL, 0x000fe200078ef804ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000d0a127210ULL, 0x000fe40007fbe0ffULL, 0x000000150a147210ULL, 0x000fe20007f7e0ffULL,
0x000000012e0d7824ULL, 0x000fe200078e0209ULL, 0x0000007010217812ULL, 0x000fe200078ef804ULL,
0x000020000c237836ULL, 0x000fc40000000000ULL, 0x00000020770c7836ULL, 0x000fe20000000000ULL,
0x000000070d2a7812ULL, 0x000fe200078ec0ffULL, 0x000000010b0f7824ULL, 0x000fe200010e060fULL,
0x000000210a107210ULL, 0x000fe20007f5e0ffULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x000000102e187836ULL, 0x000fe20000000000ULL, 0x000000700c217812ULL, 0x000fe200078ef804ULL,
0x000000142e207836ULL, 0x000fe40000000000ULL, 0x000000010b157824ULL, 0x040fe400018e0613ULL,
0x000000010b137824ULL, 0x000fe200028e0619ULL, 0x000000222000720cULL, 0x080fe20003f66070ULL,
0x0000000118197824ULL, 0x000fe200078e0209ULL, 0x000000222e00720cULL, 0x000fe20003fa6070ULL,
0x00000008182c7824ULL, 0x000fc400078e00ffULL, 0x00000001200c7824ULL, 0x040fe400078e0209ULL,
0x0000000820277824ULL, 0x000fe200078e00ffULL, 0x000000210a207210ULL, 0x000fe20007fde0ffULL,
0x000000010b117824ULL, 0x040fe200010e0611ULL, 0x000000221800720cULL, 0x000fe20003f46070ULL,
0x0000001c2e2b7836ULL, 0x000fe20000000000ULL, 0x0ffffff82a187812ULL, 0x000fe200078ef809ULL,
0x000000010b217824ULL, 0x000fe200030e060dULL, 0xfffffff82c2a7812ULL, 0x000fe400078ee219ULL,
0xfffffff8272c7812ULL, 0x000fe200078ee20cULL, 0x00000024770c7836ULL, 0x000fc40000000000ULL,
0x0000001018257824ULL, 0x100fe400078e0223ULL, 0x0000002877187836ULL, 0x000fe40000000000ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a257faeULL, 0x0003e6000e901c46ULL, 0x0000001024277824ULL, 0x000fe200078e0223ULL,
0x000000700c2d7812ULL, 0x000fe200078ef804ULL, 0x000000182e247836ULL, 0x000fc40000000000ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x000000001c277faeULL, 0x0005e2000e101c46ULL,
0x000000222b00720cULL, 0x0c0fe40003f86070ULL, 0x000000222400720cULL, 0x040fe20003fa6070ULL,
0x0000000124297824ULL, 0x140fe200078e0209ULL, 0x0000002d0a1a7210ULL, 0x002fe20007fde0ffULL,
0x0000000824247824ULL, 0x000fe200078e00ffULL, 0x0000007018257812ULL, 0x000fe200078ef804ULL,
0x000000012b187824ULL, 0x040fe400078e0209ULL, 0x000000082b2b7824ULL, 0x000fc400078e00ffULL,
0x000000010b1b7824ULL, 0x040fe200030e060dULL, 0x000000250a0c7210ULL, 0x000fe20007fde0ffULL,
0x00000010261d7824ULL, 0x004fe200078e0223ULL, 0xfffffff8241c7812ULL, 0x000fe200078ee229ULL,
0x000000202e267836ULL, 0x000fe20000000000ULL, 0xfffffff82b247812ULL, 0x000fe200078ee218ULL,
0x0000002c77187836ULL, 0x000fe20000000000ULL, 0x00000000161d7faeULL, 0x0003e2000c101c46ULL,
0x000000010b0d7824ULL, 0x000fe200030e0619ULL, 0x000000222600720cULL, 0x000fe20003f06070ULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x0000001028257824ULL, 0x000fe200078e0223ULL,
0x0000007018297812ULL, 0x000fe200078ef804ULL, 0x000000242e287836ULL, 0x000fe40000000000ULL,
0x0000000126277824ULL, 0x000fe200078e0209ULL, 0x000000290a167210ULL, 0x002fe20007fde0ffULL,
0x000000102a1d7824ULL, 0x000fe200078e0223ULL, 0x000000001e257faeULL, 0x0003e2000c901c46ULL,
0x0000000826307824ULL, 0x000fe200078e00ffULL, 0x000000222800720cULL, 0x040fe20003f26070ULL,
0x0000000128267824ULL, 0x040fe200078e0209ULL, 0x000000000e1d7faeULL, 0x0005e2000d101c46ULL,
0x0000000828177824ULL, 0x000fe200078e00ffULL, 0xfffffff830187812ULL, 0x000fc800078ee227ULL,
0xfffffff817267812ULL, 0x000fe200078ee226ULL, 0x000000010b177824ULL, 0x000fe400030e0619ULL,
0x000000102c197824ULL, 0x100fe400078e0223ULL, 0x000000101c1f7824ULL, 0x102fe400078e0223ULL,
0x00000030770e7836ULL, 0x004fe20000000000ULL, 0x0000000010197faeULL, 0x0003e2000d901c46ULL,
0x0000001024257824ULL, 0x100fe400078e0223ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x00000000141f7faeULL, 0x000fe6000e901c46ULL, 0x0000001018277824ULL, 0x000fe200078e0223ULL,
0x0000000012257faeULL, 0x0005e2000e101c46ULL, 0x000000282e187836ULL, 0x000fc40000000000ULL,
0x0000001026297824ULL, 0x000fe200078e0223ULL, 0x000000700e117812ULL, 0x002fe200078ef804ULL,
0x0000003477107836ULL, 0x000fe20000000000ULL, 0x000000221800720cULL, 0x080fe20003fa6070ULL,
0x0000002c2e1c7836ULL, 0x000fe20000000000ULL, 0x0000000020277faeULL, 0x000fe2000c101c46ULL,
0x000000302e1d7836ULL, 0x000fe40000000000ULL, 0x000000011c0e7824ULL, 0x100fe200078e0209ULL,
0x000000110a127210ULL, 0x004fe20007fde0ffULL, 0x0000000118137824ULL, 0x040fe200078e0209ULL,
0x000000001a297faeULL, 0x0003e2000c901c46ULL, 0x0000000818187824ULL, 0x000fe200078e00ffULL,
0x000000221c00720cULL, 0x080fe20003f86070ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000221d00720cULL, 0x000fc40003f66070ULL, 0xfffffff818187812ULL, 0x000fe200078ee213ULL,
0x000000010b137824ULL, 0x000fe200030e060fULL, 0x0000007010157812ULL, 0x000fe200078ef804ULL,
0x000000011d0f7824ULL, 0x040fe400078e0209ULL, 0x0000003877107836ULL, 0x000fe20000000000ULL,
0x000000150a147210ULL, 0x000fe20007fde0ffULL, 0x000000081c1b7824ULL, 0x002fe400078e00ffULL,
0x000000081d1c7824ULL, 0x000fe400078e00ffULL, 0x000000342e197836ULL, 0x000fe20000000000ULL,
0xfffffff81b1a7812ULL, 0x000fe200078ee20eULL, 0x000000382e1e7836ULL, 0x000fe20000000000ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20fULL, 0x00000080100e7825ULL, 0x000fe200078e00ffULL,
0x000000221900720cULL, 0x000fc40003f46070ULL, 0x000000221e00720cULL, 0x080fe20003f26070ULL,
0x0000003c2e1f7836ULL, 0x000fe20000000000ULL, 0x000000700e1d7812ULL, 0x000fe200078ef804ULL,
0x0000003c77107836ULL, 0x000fe40000000000ULL, 0x000000010b157824ULL, 0x000fe200030e0611ULL,
0x000000221f00720cULL, 0x000fe20003f06070ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001d0a0e7210ULL, 0x000fc60007fde0ffULL, 0x00000001191b7824ULL, 0x140fe200078e0209ULL,
0x00000070101d7812ULL, 0x000fe200078ef804ULL, 0x0000000819207824ULL, 0x000fe400078e00ffULL,
0x000000011e197824ULL, 0x140fe400078e0209ULL, 0x000000081e227824ULL, 0x000fe200078e00ffULL,
0xfffffff8201e7812ULL, 0x000fe200078ee21bULL, 0x000000011f097824ULL, 0x040fe400078e0209ULL,
0x000000081f247824ULL, 0x000fe200078e00ffULL, 0xfffffff822207812ULL, 0x000fe200078ee219ULL,
0x000000010b0f7824ULL, 0x000fe200030e060fULL, 0x0000001d0a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000101a197824ULL, 0x100fe200078e0223ULL, 0xfffffff824227812ULL, 0x000fe200078ee209ULL,
0x0000001018097824ULL, 0x000fc400078e0223ULL, 0x000000101c1b7824ULL, 0x100fe400078e0223ULL,
0x000000101e1d7824ULL, 0x100fe200078e0223ULL, 0x000000000c097faeULL, 0x0003e2000e901c46ULL,
0x00000010201f7824ULL, 0x100fe400078e0223ULL, 0x0000001022237824ULL, 0x000fe200078e0223ULL,
0x0000000016197faeULL, 0x0003e2000e101c46ULL, 0x000000010b0b7824ULL, 0x000fc600030e0611ULL,
0x00000000121b7faeULL, 0x0003e8000d901c46ULL, 0x00000000141d7faeULL, 0x0003e8000d101c46ULL,
0x000000000e1f7faeULL, 0x0003e8000c901c46ULL, 0x000000000a237faeULL, 0x0003e2000c101c46ULL,
0x0000000800d07947ULL, 0x000fea0003800000ULL, 0x00000004090f7811ULL, 0x040fe400078fe8ffULL,
0x0000000c09147811ULL, 0x040fe400078fe8ffULL, 0x0000000809127811ULL, 0x000fe200078fe8ffULL,
0x000000010f0c7824ULL, 0x100fe200078e0209ULL, 0x0000001009167811ULL, 0x000fe200078fe8ffULL,
0x000000080f117824ULL, 0x000fe200078e00ffULL, 0x0000001c091c7811ULL, 0x040fe200078fe8ffULL,
0x00000001140d7824ULL, 0x140fe200078e0209ULL, 0x0000001409187811ULL, 0x040fe200078fe8ffULL,
0x00000008141a7824ULL, 0x000fe200078e00ffULL, 0xfffffff811117812ULL, 0x000fe200078ee20cULL,
0x00000001120c7824ULL, 0x140fe200078e0209ULL, 0x00000020091e7811ULL, 0x040fe200078fe8ffULL,
0x0000000812137824ULL, 0x000fe200078e00ffULL, 0xfffffff81a157812ULL, 0x000fe200078ee20dULL,
0x00000001160e7824ULL, 0x140fe200078e0209ULL, 0x00000018091a7811ULL, 0x040fe200078fe8ffULL,
0x0000000816177824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee20cULL,
0x000000011c0d7824ULL, 0x100fe200078e0209ULL, 0x0000002809237811ULL, 0x040fe200078fe8ffULL,
0x000000011a0c7824ULL, 0x140fe200078e0209ULL, 0x0000002c09247811ULL, 0x040fe200078fe8ffULL,
0x000000081a1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff817177812ULL, 0x000fe200078ee20eULL,
0x000000081c227824ULL, 0x000fe200078e00ffULL, 0x0000002409207811ULL, 0x040fe200078fe8ffULL,
0x0000000118107824ULL, 0x140fe200078e0209ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee20cULL,
0x0000000818197824ULL, 0x000fe200078e00ffULL, 0xfffffff8221d7812ULL, 0x000fe200078ee20dULL,
0x000000011e0e7824ULL, 0x140fe200078e0209ULL, 0x00000030092c7811ULL, 0x000fe200078fe8ffULL,
0x000000081e1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee210ULL,
0x00000001230c7824ULL, 0x100fe200078e0209ULL, 0x00000034092e7811ULL, 0x000fe200078fe8ffULL,
0x0000000823257824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20eULL,
0x00000001240d7824ULL, 0x140fe200078e0209ULL, 0x0000003809307811ULL, 0x040fe200078fe8ffULL,
0x0000000824267824ULL, 0x000fe200078e00ffULL, 0xfffffff825227812ULL, 0x000fe200078ee20cULL,
0x0000000120107824ULL, 0x140fe200078e0209ULL, 0x0000003c09327811ULL, 0x040fe200078fe8ffULL,
0x0000000820217824ULL, 0x000fe200078e00ffULL, 0xfffffff826257812ULL, 0x000fe200078ee20dULL,
0x000000012c0e7824ULL, 0x140fe200078e0209ULL, 0x00000009090d7211ULL, 0x040fe200078fe8ffULL,
0x000000082c277824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee210ULL,
0x000000012e107824ULL, 0x140fe200078e0209ULL, 0x00000002090c7211ULL, 0x000fe200078fe8ffULL,
0x000000082e297824ULL, 0x000fe200078e00ffULL, 0xfffffff827267812ULL, 0x000fe200078ee20eULL,
0x0000000130287824ULL, 0x000fe200078e0209ULL, 0x000000070d0e7812ULL, 0x000fe200078ec0ffULL,
0x00000001020f7824ULL, 0x000fe200078e020fULL, 0xfffffff829277812ULL, 0x000fe200078ee210ULL,
0x00000008302b7824ULL, 0x000fe200078e00ffULL, 0x0000000863297c11ULL, 0x000fe2000f8e70ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0ffffff80e107812ULL, 0x000fc400078ef809ULL,
0xfffffff82b287812ULL, 0x000fe200078ee228ULL, 0x0000000132097824ULL, 0x040fe200078e0209ULL,
0x000000700c2b7812ULL, 0x000fe200078ef804ULL, 0x00000008320e7824ULL, 0x000fe400078e00ffULL,
0x00002000292a7836ULL, 0x000fe20000000000ULL, 0x0000002b0a0c7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff80e297812ULL, 0x000fe200078ee209ULL, 0x000000800f0e7825ULL, 0x000fc800078e00ffULL,
0x00000010112d7824ULL, 0x100fe200078e022aULL, 0x000000700e117812ULL, 0x000fe200078ef804ULL,
0x0000001010097824ULL, 0x000fe400078e022aULL, 0x0000000102107824ULL, 0x040fe200078e0212ULL,
0x000000110a0e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000102127824ULL, 0x000fe400078e0214ULL,
0x00000010132f7824ULL, 0x000fe400078e022aULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000102147824ULL, 0x000fe400078e0216ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000000102167824ULL, 0x000fe400078e0218ULL, 0x000000101f3b7824ULL, 0x100fe200078e022aULL,
0x00000070101f7812ULL, 0x000fe200078ef804ULL, 0x0000001017337824ULL, 0x100fe400078e022aULL,
0x000000101b377824ULL, 0x000fe200078e022aULL, 0x00000070121b7812ULL, 0x000fe200078ef804ULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x000000010b0d7824ULL, 0x040fe200000e060dULL,
0x0000001f0a107210ULL, 0x000fe20007f1e0ffULL, 0x0000000102187824ULL, 0x000fe400078e021aULL,
0x000000010b0f7824ULL, 0x000fe200008e060fULL, 0x0000001b0a127210ULL, 0x000fe20007f3e0ffULL,
0x0000001019357824ULL, 0x100fe200078e022aULL, 0x00000070161b7812ULL, 0x000fe200078ef804ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c097faeULL, 0x0003e6000b901c46ULL, 0x000000010b117824ULL, 0x000fe200000e0611ULL,
0x0000001b0a167210ULL, 0x000fe20007f1e0ffULL, 0x00000010223f7824ULL, 0x100fe200078e022aULL,
0x00000070181b7812ULL, 0x000fe200078ef804ULL, 0x0000001015317824ULL, 0x000fe200078e022aULL,
0x000000000e2d7faeULL, 0x0003e2000b901c46ULL, 0x000000010b177824ULL, 0x000fe200000e0617ULL,
0x0000001b0a227210ULL, 0x000fe20007f1e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x00000000102f7faeULL, 0x0003e6000b901c46ULL, 0x00000001021a7824ULL, 0x000fc400078e021cULL,
0x0000000102187824ULL, 0x040fe400078e021eULL, 0x00000001021e7824ULL, 0x000fe400078e0223ULL,
0x000000101d397824ULL, 0x000fe200078e022aULL, 0x00000070141d7812ULL, 0x000fe200078ef804ULL,
0x000000801a1a7825ULL, 0x000fc600078e00ffULL, 0x0000001d0a147210ULL, 0x000fe20007f5e0ffULL,
0x000000010b237824ULL, 0x000fe400000e0619ULL, 0x0000008018187825ULL, 0x000fc800078e00ffULL,
0x00000001021c7824ULL, 0x000fe400078e0220ULL, 0x0000001025417824ULL, 0x100fe200078e022aULL,
0x000000701a257812ULL, 0x000fe200078ef804ULL, 0x0000001027457824ULL, 0x000fe200078e022aULL,
0x0000007018277812ULL, 0x000fe200078ef804ULL, 0x000000801c1c7825ULL, 0x000fc800078e00ffULL,
0x00000001021a7824ULL, 0x000fe200078e0224ULL, 0x000000250a247210ULL, 0x000fe20007f1e0ffULL,
0x0000001026437824ULL, 0x100fe400078e022aULL, 0x000000010b137824ULL, 0x000fe200008e0613ULL,
0x000000270a267210ULL, 0x000fe20007f3e0ffULL, 0x0000001029497824ULL, 0x100fe200078e022aULL,
0x000000701c297812ULL, 0x000fe200078ef804ULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000000012317faeULL, 0x0003e6000b901c46ULL, 0x0000001028477824ULL, 0x000fe200078e022aULL,
0x000000701e2b7812ULL, 0x000fe200078ef804ULL, 0x000000010b257824ULL, 0x040fe200000e061bULL,
0x000000290a287210ULL, 0x000fe20007f1e0ffULL, 0x000000010b277824ULL, 0x000fc400008e0619ULL,
0x000000801a187825ULL, 0x000fc800078e00ffULL, 0x00000010213d7824ULL, 0x000fe400078e022aULL,
0x000000010b157824ULL, 0x040fe200010e0615ULL, 0x0000002b0a2a7210ULL, 0x000fe20007f5e0ffULL,
0x000000010b297824ULL, 0x000fe200000e061dULL, 0x00000070181d7812ULL, 0x000fe200078ef804ULL,
0x00000001021a7824ULL, 0x040fe200078e022cULL, 0x0000000014337faeULL, 0x0003e2000b901c46ULL,
0x00000001021c7824ULL, 0x040fe200078e022eULL, 0x0000001d0a187210ULL, 0x000fe20007f1e0ffULL,
0x00000001021e7824ULL, 0x040fe200078e0230ULL, 0x0000000016357faeULL, 0x0003e2000b901c46ULL,
0x0000000102207824ULL, 0x000fc400078e0232ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000022377faeULL, 0x0003e6000b901c46ULL, 0x000000010b2b7824ULL, 0x040fe200010e061fULL,
0x000000701a517812ULL, 0x000fe200078ef804ULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000000024397faeULL, 0x0003e6000b901c46ULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x000000701c4f7812ULL, 0x000fe200078ef804ULL, 0x00000000263b7faeULL, 0x0003e4000b901c46ULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x000000701e4d7812ULL, 0x000fe200078ef804ULL,
0x00000000283d7faeULL, 0x0003e2000b901c46ULL, 0x0000004f0a1c7210ULL, 0x000fe20007f3e0ffULL,
0x000000010b197824ULL, 0x040fe200000e0619ULL, 0x00000070204b7812ULL, 0x000fe200078ef804ULL,
0x000000002a3f7faeULL, 0x0003e2000b901c46ULL, 0x000000510a1a7210ULL, 0x000fe20007f1e0ffULL,
0x000000010b1d7824ULL, 0x040fe200008e061dULL, 0x0000004d0a1e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000018417faeULL, 0x0003e2000b901c46ULL, 0x0000004b0a0a7210ULL, 0x000fe20007f7e0ffULL,
0x000000010b1b7824ULL, 0x000fc400000e061bULL, 0x000000010b1f7824ULL, 0x040fe400010e061fULL,
0x000000010b0b7824ULL, 0x000fe200018e0621ULL, 0x000000001a437faeULL, 0x0003e8000b901c46ULL,
0x000000001c457faeULL, 0x0003e8000b901c46ULL, 0x000000001e477faeULL, 0x0003e8000b901c46ULL,
0x000000000a497faeULL, 0x0003e4000b901c46ULL, 0x0000000463817836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff7f7424ULL, 0x000fe200078e00ffULL,
0x0000840000047ab9ULL, 0x000fe40000000800ULL, 0x000000748100720cULL, 0x000fda0003f06070ULL,
0x00009600ff098b82ULL, 0x002e620000000800ULL, 0x000000027b048824ULL, 0x000fce00078e00ffULL,
0x00009200ff0a8b82ULL, 0x000ea20000000a00ULL, 0x0000000904098224ULL, 0x002fc800078e0281ULL,
0x00000004090a8825ULL, 0x004fca00078e000aULL, 0x000000060a7f8981ULL, 0x000322000c1e1900ULL,
0x0000001f04047890ULL, 0x000fc8000fffe03fULL, 0x000000053f047899ULL, 0x000fd80008011604ULL,
0x00000000000a7805ULL, 0x002fce0000015200ULL, 0x01a60007ff0075a7ULL, 0x000e620008000148ULL,
0x0000000176717824ULL, 0x000fe400078e0a03ULL, 0x0000000408097c24ULL, 0x000fc6000f8e02ffULL,
0x00000008ff717819ULL, 0x000fe20000011671ULL, 0x00008e00ff827b82ULL, 0x000ea40000000a00ULL,
0x0000000409827825ULL, 0x004fe200078e0082ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff0c7224ULL, 0x000fce00078e00ffULL, 0x000000100c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fce0000015200ULL,
0x000000080a0d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e0bULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011409ULL, 0x0000000d04047211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000204047819ULL, 0x000fc80000001209ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010c0c7836ULL, 0x000fce0000000000ULL, 0x01a60007ff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000047919ULL, 0x000e640000000000ULL,
0x0000002063047824ULL, 0x002fc800078e0204ULL, 0x0000000104087836ULL, 0x000fe20000000000ULL,
0x00000004ff067819ULL, 0x000fc80000011604ULL, 0x0ffffffe06077812ULL, 0x000fe400078ec0ffULL,
0x0000001f04067812ULL, 0x000fc600078ec0ffULL, 0x00000001070a7824ULL, 0x000fe400078e0208ULL,
0x0000000104097824ULL, 0x000fe400078e0207ULL, 0x00000010060b7824ULL, 0x000fe200078e00ffULL,
0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x00000010060c7824ULL, 0x040fe200078e00ffULL,
0x0000000f09097812ULL, 0x000fe200078ec0ffULL, 0x0000000807077836ULL, 0x000fe20000000000ULL,
0x000001f00b0a7812ULL, 0x000fe200078ee20aULL, 0x0000001006067824ULL, 0x000fe200078e00ffULL,
0x000001f00c097812ULL, 0x000fe200078ee209ULL, 0x0000000104047824ULL, 0x100fe200078e0207ULL,
0x000000080a0a7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000108077824ULL, 0x000fe200078e0207ULL,
0x0000000809097c11ULL, 0x000fc4000f8e20ffULL, 0x0000000f04047812ULL, 0x000fe200078ec0ffULL,
0x000000000a0c7984ULL, 0x000e620000000c00ULL, 0x0000000f07077812ULL, 0x000fe400078ec0ffULL,
0x000001f00b047812ULL, 0x000fe200078ee204ULL, 0x0000000009107984ULL, 0x000ea20000000c00ULL,
0x000001f006077812ULL, 0x000fe400078ee207ULL, 0x0000000804047c11ULL, 0x000fe4000f8e20ffULL,
0x0000000807077c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff167224ULL, 0x002fc400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff147224ULL, 0x004fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fe200078e000fULL, 0x0000001409007388ULL, 0x000fe20000000c00ULL,
0x000000ffff187224ULL, 0x000fc400078e0011ULL, 0x000000ffff197224ULL, 0x000fca00078e0013ULL,
0x000000180a007388ULL, 0x0003e80000000c00ULL, 0x00000000070c7984ULL, 0x000ea80000000c00ULL,
0x0000000004107984ULL, 0x000ee20000000c00ULL, 0x00000001ff0a7424ULL, 0x002fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x004fc400078e000eULL, 0x000000ffff1e7224ULL, 0x000fe400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1c7224ULL, 0x008fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000001c04007388ULL, 0x0003e80000000c00ULL,
0x0000000c07007388ULL, 0x0003e20000000c00ULL, 0x01a6000aff0a79a7ULL, 0x000ea40008500008ULL,
0x0000000000067805ULL, 0x002fce0000015200ULL, 0x01a6000bff0075a7ULL, 0x004e640008000148ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fce00078e00ffULL,
0x000000100c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fce0000015200ULL, 0x00000008060d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011409ULL,
0x0000000d04047211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000204047819ULL, 0x000fc80000001209ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010c0c7836ULL, 0x000fce0000000000ULL,
0x01a6000bff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ff6200720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00009600ff067b82ULL, 0x000e620000000800ULL, 0x0000000000047919ULL, 0x000ea20000000000ULL,
0x3db504f372727820ULL, 0x010fe20000410000ULL, 0x00000100057d7836ULL, 0x000fe20000000000ULL,
0x0000000863527c11ULL, 0x040fe2000f8e18ffULL, 0xffffffff03707836ULL, 0x000fe20000000000ULL,
0x0000000863797c11ULL, 0x000fe2000f8e28ffULL, 0x00000009035d7836ULL, 0x000fe20000000000ULL,
0x0000000104057899ULL, 0x000fe2000800063fULL, 0x000000ffff7a7224ULL, 0x000fe400078e00ffULL,
0x000000ffff0c7224ULL, 0x000fc400078e00ffULL, 0x000000067b7b7224ULL, 0x002fce00078e02ffULL,
0x00009000ff067b82ULL, 0x004e620000000a00ULL, 0x000000027a097836ULL, 0x000fe20000000000ULL,
0x000000010c5c7812ULL, 0x000fe200078e0cffULL, 0x0000007f007f7224ULL, 0x010fc600078e02ffULL,
0x000000620900720cULL, 0x000fe20003f06070ULL, 0x000000807f067825ULL, 0x002fd800078e0006ULL,
0x0000000c00308947ULL, 0x000fea0003800000ULL, 0x00000003ff0b7819ULL, 0x004fe20000011604ULL,
0x000001007a097824ULL, 0x000fc800078e027dULL, 0x000000040b0d7836ULL, 0x000fe20000000000ULL,
0x00000009760a7248ULL, 0x000fe20007fe0000ULL, 0x0000000c0b197836ULL, 0x000fe40000000000ULL,
0x000000010d087824ULL, 0x140fe400078e0204ULL, 0x000000080d0f7824ULL, 0x000fe400078e00ffULL,
0x00000001190e7824ULL, 0x040fe400078e0204ULL, 0x0000000819117824ULL, 0x000fe200078e00ffULL,
0xfffffff80f1c7812ULL, 0x000fe200078ee208ULL, 0x000000080b137836ULL, 0x000fc40000000000ULL,
0x0000001004087824ULL, 0x000fe200078e00ffULL, 0xfffffff811207812ULL, 0x000fe200078ee20eULL,
0x0000000102107824ULL, 0x000fe400078e020dULL, 0x000000010a0a7824ULL, 0x000fe200078e0a09ULL,
0x0000007008087812ULL, 0x000fe200078ec0ffULL, 0x0000000113097824ULL, 0x040fe400078e0204ULL,
0x00000008131e7824ULL, 0x000fe200078e00ffULL, 0x0000000a0d00720cULL, 0x080fe20003f46070ULL,
0x00000001020e7824ULL, 0x000fe200078e020bULL, 0x0000000a1300720cULL, 0x000fe20003f66070ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fc400078ee209ULL,
0x0000000a1900720cULL, 0x000fe20003fa6070ULL, 0x000000100b1b7836ULL, 0x000fe20000000000ULL,
0x0000000810177212ULL, 0x000fe200078efcffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x0000001706167210ULL, 0x000fe20007f3e0ffULL, 0x000000011b097824ULL, 0x140fe200078e0204ULL,
0x000000080e157212ULL, 0x000fe200078efcffULL, 0x000000081b227824ULL, 0x040fe200078e00ffULL,
0x0000000a1b00720cULL, 0x000fe20003f86070ULL, 0x000000140b217836ULL, 0x000fe20000000000ULL,
0x0000001506147210ULL, 0x000fe20007f1e0ffULL, 0x0000000102107824ULL, 0x000fe200078e0219ULL,
0xfffffff822227812ULL, 0x000fe200078ee209ULL, 0x0000000121097824ULL, 0x040fe400078e0204ULL,
0x0000000821247824ULL, 0x000fc400078e00ffULL, 0x000000180b237836ULL, 0x000fe40000000000ULL,
0x0000000107177824ULL, 0x000fe200008e0611ULL, 0xfffffff824247812ULL, 0x000fe200078ee209ULL,
0x00000001020e7824ULL, 0x000fe200078e0213ULL, 0x0000000863097c11ULL, 0x000fe2000f8e70ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000a0b00720cULL, 0x000fc60003f26070ULL,
0x00000001230d7824ULL, 0x140fe400078e0204ULL, 0x0000000823267824ULL, 0x000fe400078e00ffULL,
0x000000010b137824ULL, 0x000fe400078e0204ULL, 0x0000000107157824ULL, 0x000fe200000e060fULL,
0xfffffff826267812ULL, 0x000fe200078ee20dULL, 0x0000000102127824ULL, 0x000fe200078e021bULL,
0x00000008101b7212ULL, 0x000fe200078efcffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x00000007131f7812ULL, 0x000fc400078ec0ffULL, 0x0000001b061a7210ULL, 0x000fe20007fde0ffULL,
0x000020005c0d7824ULL, 0x000fe200078e0209ULL, 0x000000080e197212ULL, 0x080fe200078efcffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0ffffff81f0e7812ULL, 0x000fe400078ef804ULL,
0x0000001906187210ULL, 0x000fe20007f1e0ffULL, 0x000020000d0d7836ULL, 0x000fe20000000000ULL,
0x00000008121d7212ULL, 0x000fe200078efcffULL, 0x00000001071b7824ULL, 0x000fe400030e0611ULL,
0x000000100e117824ULL, 0x000fe200078e020dULL, 0x0000001d06127210ULL, 0x000fe20007fde0ffULL,
0x00000001020e7824ULL, 0x000fc400078e0221ULL, 0x0000000107197824ULL, 0x000fe200000e060fULL,
0x0000000a2100720cULL, 0x080fe20003f06070ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014117faeULL, 0x0003e2000c901c46ULL,
0x0000000a2300720cULL, 0x000fe40003f26070ULL, 0x000000200b277836ULL, 0x000fe20000000000ULL,
0x000000080e1d7212ULL, 0x000fe200078efcffULL, 0x0000000107137824ULL, 0x000fe400030e0613ULL,
0x00000001270e7824ULL, 0x000fc400078e0204ULL, 0x0000000827217824ULL, 0x000fe400078e00ffULL,
0x0000000102107824ULL, 0x000fe200078e0223ULL, 0x0000001d06147210ULL, 0x002fe20007fde0ffULL,
0x0000001c0b257836ULL, 0x000fe20000000000ULL, 0xfffffff8212a7812ULL, 0x000fe200078ee20eULL,
0x000000101e217824ULL, 0x000fe400078e020dULL, 0x0000000107157824ULL, 0x000fe400030e060fULL,
0x00000080100e7825ULL, 0x000fc800078e00ffULL, 0x00000001251f7824ULL, 0x040fe200078e0204ULL,
0x000000080e1d7212ULL, 0x000fe200078efcffULL, 0x0000000825287824ULL, 0x000fe400078e00ffULL,
0x0000000102107824ULL, 0x040fe400078e0225ULL, 0x00000001020e7824ULL, 0x000fe200078e0227ULL,
0xfffffff828287812ULL, 0x000fe200078ee21fULL, 0x000000101c1f7824ULL, 0x000fe200078e020dULL,
0x0000001d061c7210ULL, 0x000fe20007fde0ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x00000000161f7faeULL, 0x0003e2000d101c46ULL, 0x00000001071d7824ULL, 0x000fe200030e060fULL,
0x0000000a2500720cULL, 0x080fe20003f46070ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000018217faeULL, 0x0005e2000d901c46ULL, 0x0000000a2700720cULL, 0x000fe40003f66070ULL,
0x000000240b237836ULL, 0x000fe40000000000ULL, 0x000000300b257836ULL, 0x000fe40000000000ULL,
0x00000001231e7824ULL, 0x000fe200078e0204ULL, 0x0000000810177212ULL, 0x002fe200078efcffULL,
0x0000000102107824ULL, 0x000fc400078e0223ULL, 0x00000010201f7824ULL, 0x000fe200078e020dULL,
0x0000001706167210ULL, 0x000fe20007fde0ffULL, 0x0000000823217824ULL, 0x004fe200078e00ffULL,
0x000000080e197212ULL, 0x000fe200078efcffULL, 0x000000380b277836ULL, 0x000fe20000000000ULL,
0x000000001a1f7faeULL, 0x0003e2000e901c46ULL, 0x0000000107177824ULL, 0x000fe200030e0611ULL,
0x0000001906187210ULL, 0x000fe20007fde0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff8211e7812ULL, 0x000fe400078ee21eULL, 0x0000000a2300720cULL, 0x000fe20003fa6070ULL,
0x0000000107197824ULL, 0x000fc400030e060fULL, 0x000000280b0f7836ULL, 0x000fe40000000000ULL,
0x0000001022217824ULL, 0x000fe200078e020dULL, 0x00000008101b7212ULL, 0x002fe200078efcffULL,
0x00000001020e7824ULL, 0x000fe400078e020fULL, 0x000000010f107824ULL, 0x040fe200078e0204ULL,
0x0000000012217faeULL, 0x0003e2000e101c46ULL, 0x000000080f1f7824ULL, 0x040fe200078e00ffULL,
0x0000000a0f00720cULL, 0x000fe20003f86070ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001b061a7210ULL, 0x000fc40007fde0ffULL, 0xfffffff81f207812ULL, 0x000fe200078ee210ULL,
0x0000002c0b237836ULL, 0x000fe40000000000ULL, 0x00000001071b7824ULL, 0x000fe200030e0611ULL,
0x000000080e117212ULL, 0x000fe200078efcffULL, 0x00000010241f7824ULL, 0x000fe400078e020dULL,
0x0000000102107824ULL, 0x000fe200078e0223ULL, 0x00000011060e7210ULL, 0x000fe20007fde0ffULL,
0x0000000123137824ULL, 0x042fe200078e0204ULL, 0x00000000141f7faeULL, 0x0003e2000c101c46ULL,
0x0000000823227824ULL, 0x040fe200078e00ffULL, 0x0000000a2300720cULL, 0x000fe20003f06070ULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee213ULL,
0x0000000102127824ULL, 0x000fe400078e0225ULL, 0x0000000825237824ULL, 0x000fe400078e00ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000810157212ULL, 0x002fc600078efcffULL,
0x00000010261f7824ULL, 0x000fe200078e020dULL, 0x0000000812217212ULL, 0x000fe200078efcffULL,
0x0000000125107824ULL, 0x000fe400078e0204ULL, 0x00000001070f7824ULL, 0x000fe200030e060fULL,
0x000000001c1f7faeULL, 0x0003e2000c901c46ULL, 0x0000000a2500720cULL, 0x000fe20003f26070ULL,
0x000000340b257836ULL, 0x000fe20000000000ULL, 0x0000001506147210ULL, 0x000fe20007fde0ffULL,
0x0000003c0b297836ULL, 0x000fe20000000000ULL, 0xfffffff823247812ULL, 0x000fe200078ee210ULL,
0x0000000102107824ULL, 0x000fc400078e0225ULL, 0x0000000107157824ULL, 0x000fe200030e0611ULL,
0x0000002106127210ULL, 0x000fe20007fde0ffULL, 0x0000001028217824ULL, 0x000fe400078e020dULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x0000000016217faeULL, 0x0005e2000d101c46ULL,
0x000000102a1f7824ULL, 0x102fe200078e020dULL, 0x00000008101d7212ULL, 0x000fe200078efcffULL,
0x000000101e237824ULL, 0x000fe200078e020dULL, 0x0000000a2900720cULL, 0x080fe20003f46070ULL,
0x00000001020b7824ULL, 0x040fe200078e0227ULL, 0x00000000181f7faeULL, 0x0003e2000d901c46ULL,
0x0000000107137824ULL, 0x000fe200030e0613ULL, 0x0000000a2700720cULL, 0x080fe20003f66070ULL,
0x0000000102107824ULL, 0x000fe200078e0229ULL, 0x000000001a237faeULL, 0x0007e2000e901c46ULL,
0x0000000a2500720cULL, 0x000fe20003fa6070ULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x0000001d061c7210ULL, 0x000fc60007fde0ffULL, 0x0000000125167824ULL, 0x004fe200078e0204ULL,
0x000000080a177212ULL, 0x000fe200078efcffULL, 0x00000001071d7824ULL, 0x000fe400030e0611ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x00000017060a7210ULL, 0x000fc60007fde0ffULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0x00000008101f7212ULL, 0x002fe200078efcffULL,
0x0000000127187824ULL, 0x140fe400078e0204ULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0xfffffff825167812ULL, 0x000fe200078ee216ULL, 0x0000000129197824ULL, 0x040fe400078e0204ULL,
0x00000008291a7824ULL, 0x008fe200078e00ffULL, 0xfffffff827187812ULL, 0x000fe200078ee218ULL,
0x00000001070b7824ULL, 0x000fe200030e060bULL, 0x0000001f06067210ULL, 0x000fe20007fde0ffULL,
0x0000001020177824ULL, 0x100fe200078e020dULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee219ULL,
0x0000001022197824ULL, 0x000fc400078e020dULL, 0x00000010241b7824ULL, 0x100fe200078e020dULL,
0x000000000e177faeULL, 0x0003e2000e101c46ULL, 0x00000010161f7824ULL, 0x100fe400078e020dULL,
0x0000001018217824ULL, 0x100fe200078e020dULL, 0x0000000014197faeULL, 0x0003e2000c101c46ULL,
0x000000101a0d7824ULL, 0x000fe400078e020dULL, 0x0000000107077824ULL, 0x000fe200030e0611ULL,
0x00000000121b7faeULL, 0x0003e8000c901c46ULL, 0x000000001c1f7faeULL, 0x0003e8000e901c46ULL,
0x000000000a217faeULL, 0x0003e8000d901c46ULL, 0x00000000060d7faeULL, 0x0003e2000d101c46ULL,
0x0000000800dc7947ULL, 0x000fea0003800000ULL, 0x00000004040f7811ULL, 0x044fe400078fe8ffULL,
0x0000000804137811ULL, 0x040fe400078fe8ffULL, 0x0000001004177811ULL, 0x040fe200078fe8ffULL,
0x000000010f087824ULL, 0x140fe200078e0204ULL, 0x0000001404197811ULL, 0x040fe200078fe8ffULL,
0x000000080f0b7824ULL, 0x000fe200078e00ffULL, 0x00000018041b7811ULL, 0x040fe200078fe8ffULL,
0x0000000113097824ULL, 0x140fe200078e0204ULL, 0x0000000c04157811ULL, 0x040fe200078fe8ffULL,
0x0000000813147824ULL, 0x000fe200078e00ffULL, 0xfffffff80b127812ULL, 0x000fe200078ee208ULL,
0x0000000817187824ULL, 0x000fe200078e00ffULL, 0x0000002004257811ULL, 0x040fe200078fe8ffULL,
0x00000001190a7824ULL, 0x100fe200078e0204ULL, 0xfffffff814147812ULL, 0x000fe200078ee209ULL,
0x0000000117097824ULL, 0x100fe200078e0204ULL, 0x0000002404277811ULL, 0x040fe200078fe8ffULL,
0x0000000819117824ULL, 0x000fe200078e00ffULL, 0x0000002804297811ULL, 0x040fe200078fe8ffULL,
0x000000011b0b7824ULL, 0x140fe200078e0204ULL, 0x0000001c04237811ULL, 0x040fe200078fe8ffULL,
0x000000081b1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ee209ULL,
0x0000000115087824ULL, 0x140fe200078e0204ULL, 0xfffffff8111a7812ULL, 0x000fe200078ee20aULL,
0x00000008150d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL,
0x0000000125097824ULL, 0x140fe200078e0204ULL, 0x00000030042d7811ULL, 0x040fe200078fe8ffULL,
0x0000000825207824ULL, 0x000fe200078e00ffULL, 0xfffffff80d167812ULL, 0x000fe200078ee208ULL,
0x00000001270a7824ULL, 0x140fe200078e0204ULL, 0x00000034044b7811ULL, 0x040fe200078fe8ffULL,
0x0000000827117824ULL, 0x000fe200078e00ffULL, 0x00000038044d7811ULL, 0x040fe200078fe8ffULL,
0x00000001290b7824ULL, 0x140fe200078e0204ULL, 0x0000002c042b7811ULL, 0x040fe200078fe8ffULL,
0x0000000829247824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee209ULL,
0x0000000123087824ULL, 0x140fe200078e0204ULL, 0xfffffff811227812ULL, 0x000fe200078ee20aULL,
0x00000008230d7824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee20bULL,
0x000000012d097824ULL, 0x140fe200078e0204ULL, 0x0000003c044f7811ULL, 0x000fe200078fe8ffULL,
0x000000082d287824ULL, 0x000fe200078e00ffULL, 0xfffffff80d1e7812ULL, 0x000fe200078ee208ULL,
0x000000014b0a7824ULL, 0x000fc400078e0204ULL, 0x000000084b117824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee209ULL, 0x000000014d0b7824ULL, 0x100fe200078e0204ULL,
0x0000000863097c11ULL, 0x000fe2000f8e70ffULL, 0x000000084d2c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8112a7812ULL, 0x000fe200078ee20aULL, 0x000000012b087824ULL, 0x040fe200078e0204ULL,
0x00000002040a7211ULL, 0x000fe200078fe8ffULL, 0x000000082b0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee20bULL, 0x000020005c0e7824ULL, 0x000fe200078e0209ULL,
0x00000004040b7211ULL, 0x000fe200078fe8ffULL, 0x00000001020f7824ULL, 0x000fe200078e020fULL,
0xfffffff80d267812ULL, 0x000fe200078ee208ULL, 0x0000001004087824ULL, 0x000fe200078e00ffULL,
0x000000070b0d7812ULL, 0x000fe200078ec0ffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0x0000007008087812ULL, 0x000fe200078ec0ffULL, 0x000000014f117824ULL, 0x040fe200078e0204ULL,
0x0ffffff80d107812ULL, 0x000fe200078ef804ULL, 0x000000084f2e7824ULL, 0x000fe200078e00ffULL,
0x000000080a0d7212ULL, 0x080fe200078efcffULL, 0x000020000e497836ULL, 0x000fe40000000000ULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe400078ee211ULL,
0x0000000d060a7210ULL, 0x000fe20007f1e0ffULL, 0x00000010100d7824ULL, 0x000fe200078e0249ULL,
0x000000080e117212ULL, 0x000fe200078efcffULL, 0x0000000102107824ULL, 0x000fc400078e0213ULL,
0x0000001016317824ULL, 0x000fe200078e0249ULL, 0x00000011060e7210ULL, 0x000fe20007f3e0ffULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x0000000102167824ULL, 0x000fe400078e0219ULL,
0x0000001018337824ULL, 0x100fe400078e0249ULL, 0x00000010142f7824ULL, 0x000fe400078e0249ULL,
0x0000000102187824ULL, 0x000fe200078e021bULL, 0x00000008101b7212ULL, 0x000fe200078efcffULL,
0x0000000102147824ULL, 0x000fe400078e0217ULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x000000010b0b7824ULL, 0x100fe200000e0607ULL, 0x0000001b06107210ULL, 0x000fe20007f1e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000008161b7212ULL, 0x080fe400078efcffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000b901c46ULL,
0x0000000111117824ULL, 0x000fe200000e0607ULL, 0x0000001b06167210ULL, 0x000fe20007f1e0ffULL,
0x00000010121d7824ULL, 0x100fe200078e0249ULL, 0x00000008181b7212ULL, 0x000fe200078efcffULL,
0x000000101a357824ULL, 0x000fc400078e0249ULL, 0x0000000102127824ULL, 0x000fe400078e0215ULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x00000001021a7824ULL, 0x000fe200078e0223ULL,
0x0000000814217212ULL, 0x000fe200078efcffULL, 0x0000000117177824ULL, 0x000fe200000e0607ULL,
0x0000001b06187210ULL, 0x000fe20007f1e0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000002106147210ULL, 0x000fc60007f5e0ffULL, 0x00000010203b7824ULL, 0x000fe400078e0249ULL,
0x0000000102207824ULL, 0x000fe400078e0227ULL, 0x000000101e397824ULL, 0x000fe400078e0249ULL,
0x00000001021e7824ULL, 0x000fe200078e0225ULL, 0x000000081a257212ULL, 0x000fe200078efcffULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x00000010223d7824ULL, 0x000fe200078e0249ULL,
0x00000008121f7212ULL, 0x000fe200078efcffULL, 0x0000008020207825ULL, 0x000fc800078e00ffULL,
0x0000000102227824ULL, 0x000fe400078e0229ULL, 0x0000000119197824ULL, 0x000fe200000e0607ULL,
0x00000025061a7210ULL, 0x000fe20007f1e0ffULL, 0x00000010243f7824ULL, 0x000fe200078e0249ULL,
0x0000000820257212ULL, 0x000fe200078efcffULL, 0x0000008022227825ULL, 0x000fc800078e00ffULL,
0x0000000102247824ULL, 0x000fe200078e022bULL, 0x0000000822297212ULL, 0x080fe200078efcffULL,
0x000000010f0f7824ULL, 0x100fe200008e0607ULL, 0x0000001f06127210ULL, 0x000fe20007f3e0ffULL,
0x000000011b1b7824ULL, 0x100fe200000e0607ULL, 0x0000002506207210ULL, 0x000fe20007f1e0ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000000000e1d7faeULL, 0x0003e6000b901c46ULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x000000081e277212ULL, 0x080fe200078efcffULL,
0x00000000102f7faeULL, 0x0003e4000b901c46ULL, 0x0000000115157824ULL, 0x000fe200010e0607ULL,
0x0000002906227210ULL, 0x000fe20007f5e0ffULL, 0x0000001026417824ULL, 0x100fe200078e0249ULL,
0x0000000824297212ULL, 0x000fe200078efcffULL, 0x0000001028437824ULL, 0x000fc400078e0249ULL,
0x0000000102267824ULL, 0x000fe400078e022dULL, 0x000000102a457824ULL, 0x000fe400078e0249ULL,
0x0000000102287824ULL, 0x000fe400078e024bULL, 0x000000102c477824ULL, 0x000fe400078e0249ULL,
0x0000000113137824ULL, 0x000fe200008e0607ULL, 0x00000027061e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001022a7824ULL, 0x000fc400078e024dULL, 0x0000000121217824ULL, 0x000fe200000e0607ULL,
0x0000002906247210ULL, 0x000fe20007f1e0ffULL, 0x00000001022c7824ULL, 0x000fe200078e024fULL,
0x0000000012317faeULL, 0x0003e2000b901c46ULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0x0000000014337faeULL, 0x0003e2000b901c46ULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x00000008264b7212ULL, 0x080fe400078efcffULL, 0x0000000016357faeULL, 0x0003e2000b901c46ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x00000008284d7212ULL, 0x000fc600078efcffULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x000000082a4f7212ULL, 0x000fc600078efcffULL,
0x000000101c377824ULL, 0x000fe200078e0249ULL, 0x000000082c517212ULL, 0x000fe200078efcffULL,
0x0000000125257824ULL, 0x100fe200000e0607ULL, 0x0000004b06267210ULL, 0x000fe20007f1e0ffULL,
0x000000011f1f7824ULL, 0x100fe200008e0607ULL, 0x0000004d06287210ULL, 0x000fe20007f3e0ffULL,
0x0000000123237824ULL, 0x100fe200010e0607ULL, 0x0000004f062a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000018377faeULL, 0x0003e2000b901c46ULL, 0x0000005106067210ULL, 0x000fe20007f7e0ffULL,
0x0000000127277824ULL, 0x000fc400000e0607ULL, 0x000000001a397faeULL, 0x0003e2000b901c46ULL,
0x0000000129297824ULL, 0x100fe400008e0607ULL, 0x000000012b2b7824ULL, 0x000fe200010e0607ULL,
0x000000001e3b7faeULL, 0x0003e2000b901c46ULL, 0x000000102e497824ULL, 0x000fe400078e0249ULL,
0x000000012d077824ULL, 0x000fe200018e0607ULL, 0x00000000203d7faeULL, 0x0003e8000b901c46ULL,
0x00000000223f7faeULL, 0x0003e8000b901c46ULL, 0x0000000024417faeULL, 0x0003e8000b901c46ULL,
0x0000000026437faeULL, 0x0003e8000b901c46ULL, 0x0000000028457faeULL, 0x0003e8000b901c46ULL,
0x000000002a477faeULL, 0x0003e8000b901c46ULL, 0x0000000006497faeULL, 0x0003e4000b901c46ULL,
0x0000000481817836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff7f7424ULL, 0x000fc600078e00ffULL, 0x000000748100720cULL, 0x000fda0003f06070ULL,
0x00009200ff0a8b82ULL, 0x002e620000000a00ULL, 0x000000027b078824ULL, 0x000fe200078e0281ULL,
0x0000000804517812ULL, 0x040fe200078ec0ffULL, 0x0000002004737836ULL, 0x000fe20000000000ULL,
0xfffffff804777812ULL, 0x000fe200078ec0ffULL, 0x000020000c537824ULL, 0x000fe200078e0209ULL,
0x0000000751517812ULL, 0x000fe200078ef804ULL, 0x000000ffff787224ULL, 0x000fe200078e00ffULL,
0xfffffff873737812ULL, 0x000fe400078ec0ffULL, 0x0000000000467805ULL, 0x000fc4000001ff00ULL,
0x0000000704507812ULL, 0x000fe400078ec0ffULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x0000000000087805ULL, 0x000fe4000001ff00ULL, 0x00000000000e7805ULL, 0x000fe4000001ff00ULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fc4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fc4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000004070a8825ULL, 0x002fe200078e000aULL, 0x00000004ff077819ULL, 0x000fe40000011604ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000060a7f8981ULL, 0x000322000c1e1900ULL,
0x00000000002a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fc4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x00000000000a7805ULL, 0x002fe4000001ff00ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x00000000003c7805ULL, 0x000fc4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000200053537836ULL, 0x000fe20000000000ULL,
0x0000000777777812ULL, 0x000fe200078ef804ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000773737812ULL, 0x000fe400078ef804ULL, 0x0000001051067812ULL, 0x000fce00078efcffULL,
0x0000000177487824ULL, 0x040fe400078e0278ULL, 0x0000000877497824ULL, 0x000fe400078e00ffULL,
0x00000002787c7824ULL, 0x000fe400078e0207ULL, 0x0000001051557824ULL, 0x000fe200078e00ffULL,
0xfffffff849487812ULL, 0x000fe200078ee248ULL, 0x0000000873497824ULL, 0x000fe400078e00ffULL,
0x0000000151547824ULL, 0x000fc400078e027cULL, 0x00000010484c7824ULL, 0x000fe400078e0253ULL,
0x0000000173487824ULL, 0x040fe200078e0278ULL, 0xfffffff055547812ULL, 0x000fe200078ee254ULL,
0x0000000178567836ULL, 0x000fe40000000000ULL, 0x000000004c4c783bULL, 0x000e620000000200ULL,
0xfffffff849487812ULL, 0x000fe200078ee248ULL, 0x00000010065a7824ULL, 0x000fe200078e00ffULL,
0x0000000854547c11ULL, 0x000fe2000f8e20ffULL, 0x0000000873597824ULL, 0x000fc400078e00ffULL,
0x0000001048487824ULL, 0x000fe400078e0253ULL, 0x00000001065b7824ULL, 0x000fe400078e027cULL,
0x0000000173587824ULL, 0x100fe400078e0256ULL, 0x000000004848783bULL, 0x000ea20000000200ULL,
0x0000000877577824ULL, 0x040fe200078e00ffULL, 0xfffffff05a5b7812ULL, 0x000fe200078ee25bULL,
0x00000001776c7824ULL, 0x000fe200078e0256ULL, 0xfffffff859587812ULL, 0x000fe200078ee258ULL,
0x000000027c7c7836ULL, 0x000fc40000000000ULL, 0x0000000278787836ULL, 0x000fe20000000000ULL,
0xfffffff8576c7812ULL, 0x000fe200078ee26cULL, 0x0000001058587824ULL, 0x000fe200078e0253ULL,
0x000000005454783bULL, 0x000ee40000000200ULL, 0x000000087800780cULL, 0x000fe40003f05270ULL,
0x00000010ff677819ULL, 0x002fe4000001164cULL, 0x00000010ff857819ULL, 0x100fe4000001164dULL,
0x00000018ff6d7819ULL, 0x000fc4000001164dULL, 0x000000ff4d5e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4d8c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001164cULL,
0x000000ff4c6a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4c8a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff877819ULL, 0x004fc40000011648ULL, 0x00000018ff617819ULL, 0x000fe40000011648ULL,
0x000000ff48687812ULL, 0x040fe400078ec0ffULL, 0x0000ffff484d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f607812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4c7819ULL, 0x100fe40000011649ULL,
0x00000018ff807819ULL, 0x000fc40000011649ULL, 0x000000ff497e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff496e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff67487812ULL, 0x000fe400078ec0ffULL,
0x00000018ff497819ULL, 0x000fe4000001164aULL, 0x00000010ff897819ULL, 0x100fe4000001164eULL,
0x00000018ff6f7819ULL, 0x000fc4000001164eULL, 0x000000ff4e847812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e887812ULL, 0x000fe400078ec0ffULL, 0x00000010ff597819ULL, 0x000fe4000001164aULL,
0x000000ff4a697812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4a5a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fc4000001164bULL, 0x0000005eff4e723eULL, 0x000fe400020006ffULL,
0x00000060ff5e723eULL, 0x000fe400020006ffULL, 0x00000048ff8b723eULL, 0x000fe400020006ffULL,
0x00000068ff60723eULL, 0x000fe400020006ffULL, 0x00000049ff67723eULL, 0x000fe400020006ffULL,
0x00000008ff487819ULL, 0x000fc4000001168aULL, 0x00000069ff68723eULL, 0x000fe400020006ffULL,
0x00000008ff497819ULL, 0x000fe4000001168cULL, 0x0000004aff69723eULL, 0x000fe400020006ffULL,
0x00000008ff8a7819ULL, 0x000fe40000011688ULL, 0x00000010ff867819ULL, 0x100fe4000001164fULL,
0x00000018ff5f7819ULL, 0x000fc4000001164fULL, 0x000000ff894a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff887819ULL, 0x000fe2000001164dULL, 0x000000106c4d7824ULL, 0x000fe200078e0253ULL,
0x0000ffff4f4f7812ULL, 0x000fe400078ec0ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x00000048ff89723eULL, 0x000fe400020006ffULL, 0x00000049ff8c723eULL, 0x000fc400020006ffULL,
0x000000ff86497812ULL, 0x000fe400078ec0ffULL, 0x000054106a6a7816ULL, 0x000fe40000000089ULL,
0x00000008ff867819ULL, 0x000fe4000001164fULL, 0x000000ff4c897812ULL, 0x000fe400078ec0ffULL,
0x000054104e6c7816ULL, 0x000fe4000000008cULL, 0x000000ff85857812ULL, 0x000fe200078ec0ffULL,
0x000000004d4c783bULL, 0x000fe20000000200ULL, 0x000000085b487c11ULL, 0x000fc4000f8e20ffULL,
0x00000085ff8d723eULL, 0x000fe400020006ffULL, 0x000000ff875b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x000fe4000001164bULL, 0x000000ff4b667812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4b657812ULL, 0x000fe400078ec0ffULL, 0x0000004aff85723eULL, 0x000fc400020006ffULL,
0x00000049ff87723eULL, 0x000fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x000000004848783bULL, 0x000e620000000200ULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x000054108b6b7816ULL, 0x000fe4000000006bULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000008ff8b7819ULL, 0x000fc4000001166eULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x0000006a5440723cULL, 0x008fe20000001840ULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000008ff5a7819ULL, 0x000fc4000001165aULL,
0x00005410875f7816ULL, 0x000fe4000000005fULL, 0x000054105e5e7816ULL, 0x000fe40000000086ULL,
0x000000ff59597812ULL, 0x000fe400078ec0ffULL, 0x000000ff64877812ULL, 0x000fe400078ec0ffULL,
0x00000008ff867819ULL, 0x000fe20000011665ULL, 0x0000005e5434723cULL, 0x000fe20000001834ULL,
0x00005410846e7816ULL, 0x000fc4000000008aULL, 0x00005410856f7816ULL, 0x000fe4000000006fULL,
0x0000005aff84723eULL, 0x000fe400020006ffULL, 0x000054107e647816ULL, 0x000fe4000000008bULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x0000006e5438723cULL, 0x000fe20000001838ULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000080ff80723eULL, 0x000fc400020006ffULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x0000006a4820723cULL, 0x002fe20000001820ULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000059ff85723eULL, 0x000fe200020006ffULL, 0x0000006e4818723cULL, 0x000fe20000001818ULL,
0x00000066ff7e723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fc400020006ffULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x0000005e4814723cULL, 0x000fe20000001814ULL,
0x0000541068667816ULL, 0x000fe40000000084ULL, 0x000054108d6d7816ULL, 0x000fe4000000006dULL,
0x000054105b617816ULL, 0x000fe40000000061ULL, 0x0000541060607816ULL, 0x000fe20000000088ULL,
0x000000005858783bULL, 0x000e620000000200ULL, 0x0000541089657816ULL, 0x000fe20000000080ULL,
0x0000006c543c723cULL, 0x000fe2000000183cULL, 0x0000541085677816ULL, 0x000fc40000000067ULL,
0x0000541087697816ULL, 0x000fe40000000069ULL, 0x000054107e687816ULL, 0x000fe20000000086ULL,
0x000000605430723cULL, 0x000fe20000001830ULL, 0x00000010ff8c7819ULL, 0x100fe4000001164cULL,
0x00000018ff887819ULL, 0x000fe4000001164cULL, 0x000000ff4c877812ULL, 0x040fe200078ec0ffULL,
0x00000064542c723cULL, 0x000fe2000000182cULL, 0x0000ffff4c8d7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff8e7819ULL, 0x000fe4000001164dULL, 0x000000ff4d847812ULL, 0x040fe200078ec0ffULL,
0x000000665428723cULL, 0x000fe20000001828ULL, 0x0000ffff4d8f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff897819ULL, 0x100fe4000001164eULL, 0x00000018ff857819ULL, 0x000fe2000001164eULL,
0x000000685424723cULL, 0x000fe20000001824ULL, 0x000000ff4e927812ULL, 0x000fc400078ec0ffULL,
0x0000ffff4e8a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8b7819ULL, 0x100fe2000001164fULL,
0x0000006c481c723cULL, 0x000fe2000000181cULL, 0x0000001051557824ULL, 0x040fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe2000001164fULL, 0x0000000151547824ULL, 0x100fe200078e027cULL,
0x000000ff4f947812ULL, 0x000fe200078ec0ffULL, 0x0000001006577824ULL, 0x040fe200078e00ffULL,
0x000000604810723cULL, 0x000fe20000001810ULL, 0x00000001067c7824ULL, 0x000fe200078e027cULL,
0xfffffff055567812ULL, 0x000fc400078ee254ULL, 0x0000ffff4f557812ULL, 0x000fe400078ec0ffULL,
0xfffffff057547812ULL, 0x000fe200078ee27cULL, 0x00000064480c723cULL, 0x000fe2000000180cULL,
0x00000008564c7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000854547c11ULL, 0x000fe4000f8e20ffULL,
0x00000018ff577819ULL, 0x000fe2000001164dULL, 0x000000664808723cULL, 0x000fe20000001808ULL,
0x000000004c4c783bULL, 0x000ea20000000200ULL, 0x000000ff8e647812ULL, 0x000fc400078ec0ffULL,
0x00000010ff567819ULL, 0x102fe40000011658ULL, 0x000000684844723cULL, 0x000fe20000001844ULL,
0x00000018ff957819ULL, 0x000fe20000011658ULL, 0x000000005448783bULL, 0x000e620000000200ULL,
0x000000ff58967812ULL, 0x040fe400078ec0ffULL, 0x0000ffff58867812ULL, 0x000fe400078ec0ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fc400020006ffULL,
0x00000010ff587819ULL, 0x000fe40000011659ULL, 0x00000008ff657819ULL, 0x000fe4000001168fULL,
0x000000ff89667812ULL, 0x000fe400078ec0ffULL, 0x00000008ff677819ULL, 0x000fe4000001168aULL,
0x0000ffff597e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff807819ULL, 0x000fc4000001165aULL,
0x0000ffff5a7c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6c7819ULL, 0x000fe4000001165bULL,
0x0000ffff5b6f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff917819ULL, 0x000fe40000011659ULL,
0x000000ff596e7812ULL, 0x000fe400078ec0ffULL, 0x00000085ff59723eULL, 0x000fc400020006ffULL,
0x0000541064577816ULL, 0x000fe40000000057ULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x00000092ff85723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fc400020006ffULL,
0x000000ff58647812ULL, 0x000fe400078ec0ffULL, 0x00000018ff907819ULL, 0x000fe4000001165aULL,
0x000000ff5a6d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001165bULL,
0x000000ff5b6b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8c8c7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff8d7819ULL, 0x000fe4000001168dULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff687819ULL, 0x000fe40000011655ULL, 0x000000ff56697812ULL, 0x000fe400078ec0ffULL,
0x00000008ff867819ULL, 0x000fe40000011686ULL, 0x00000008ff7e7819ULL, 0x000fc4000001167eULL,
0x000000ff80807812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7c7819ULL, 0x000fe4000001167cULL,
0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6f7819ULL, 0x000fe4000001166fULL,
0x00000091ff61723eULL, 0x000fe400020006ffULL, 0x0000006eff60723eULL, 0x000fc400020006ffULL,
0x0000541084567816ULL, 0x000fe40000000065ULL, 0x0000541066597816ULL, 0x000fe40000000059ULL,
0x0000541085587816ULL, 0x000fe40000000067ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x000000564c3c723cULL, 0x004fe2000000183cULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000087ff87723eULL, 0x000fc400020006ffULL, 0x00000093ff5b723eULL, 0x000fe200020006ffULL,
0x000000584c38723cULL, 0x000fe20000001838ULL, 0x00000094ff5a723eULL, 0x000fe400020006ffULL,
0x00000095ff5f723eULL, 0x000fe400020006ffULL, 0x00000096ff5e723eULL, 0x000fe200020006ffULL,
0x00000056481c723cULL, 0x002fe2000000181cULL, 0x00000090ff6e723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fc400020006ffULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x000000584818723cULL, 0x000fe20000001818ULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fc400020006ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000080ff65723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000006bff66723eULL, 0x000fe400020006ffULL, 0x0000006cff67723eULL, 0x000fc400020006ffULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x0000541064617816ULL, 0x000fe40000000061ULL,
0x000054108c557816ULL, 0x000fe40000000088ULL, 0x0000541087547816ULL, 0x000fe4000000008dULL,
0x000054108b5b7816ULL, 0x000fe4000000005bULL, 0x000054105a5a7816ULL, 0x000fc40000000068ULL,
0x00005410695f7816ULL, 0x000fe2000000005fULL, 0x000000544c40723cULL, 0x000fe20000001840ULL,
0x000054105e5e7816ULL, 0x000fe40000000086ULL, 0x0000541060607816ULL, 0x000fe4000000007eULL,
0x0000541065657816ULL, 0x000fe2000000006eULL, 0x0000005a4c34723cULL, 0x000fe20000001834ULL,
0x000054106d647816ULL, 0x000fe4000000007cULL, 0x0000541067677816ULL, 0x000fc4000000006aULL,
0x0000541066667816ULL, 0x000fe2000000006fULL, 0x0000005e4c30723cULL, 0x000fec0000001830ULL,
0x000000604c2c723cULL, 0x000fec000000182cULL, 0x000000644c28723cULL, 0x000fec0000001828ULL,
0x000000664c24723cULL, 0x000fec0000001824ULL, 0x000000544820723cULL, 0x000fec0000001820ULL,
0x0000005a4814723cULL, 0x000fec0000001814ULL, 0x0000005e4810723cULL, 0x000fec0000001810ULL,
0x00000060480c723cULL, 0x000fec000000180cULL, 0x000000644808723cULL, 0x000fec0000001808ULL,
0x000000664844723cULL, 0x000fe20000001844ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffec00c40947ULL, 0x000fde000383ffffULL, 0x00000001ff4b7424ULL, 0x000fe400078e00ffULL,
0x0000007240077220ULL, 0x080fe20000410000ULL, 0x0000007220497220ULL, 0x080fe20000410000ULL,
0x0000007241417220ULL, 0x080fe20000410000ULL, 0x0000007242427220ULL, 0x080fe20000410000ULL,
0x0000007243437220ULL, 0x080fe20000410000ULL, 0x01a6884b524a79a7ULL, 0x000262000850003fULL,
0x000000723c3c7220ULL, 0x080fe20000410000ULL, 0x000000723d3d7220ULL, 0x080fe20000410000ULL,
0x000000723e3e7220ULL, 0x080fe20000410000ULL, 0x000000723f3f7220ULL, 0x080fe20000410000ULL,
0x0000007238387220ULL, 0x080fe20000410000ULL, 0x0000007239397220ULL, 0x080fe20000410000ULL,
0x000000723a3a7220ULL, 0x080fe20000410000ULL, 0x000000723b3b7220ULL, 0x080fe20000410000ULL,
0x0000007234347220ULL, 0x080fe20000410000ULL, 0x0000007235357220ULL, 0x080fe20000410000ULL,
0x0000007236367220ULL, 0x080fe20000410000ULL, 0x0000007237377220ULL, 0x080fe20000410000ULL,
0x0000007230307220ULL, 0x080fe20000410000ULL, 0x0000007231317220ULL, 0x080fe20000410000ULL,
0x0000007232327220ULL, 0x080fe20000410000ULL, 0x0000007233337220ULL, 0x080fe20000410000ULL,
0x000000722c2c7220ULL, 0x080fe20000410000ULL, 0x000000722d2d7220ULL, 0x080fe20000410000ULL,
0x000000722e2e7220ULL, 0x080fe20000410000ULL, 0x000000722f2f7220ULL, 0x080fe20000410000ULL,
0x0000007228287220ULL, 0x080fe20000410000ULL, 0x0000007229297220ULL, 0x080fe20000410000ULL,
0x000000722a2a7220ULL, 0x080fe20000410000ULL, 0x000000722b2b7220ULL, 0x080fe20000410000ULL,
0x0000007224247220ULL, 0x080fe20000410000ULL, 0x0000007225257220ULL, 0x080fe20000410000ULL,
0x0000007226267220ULL, 0x080fe20000410000ULL, 0x0000007227277220ULL, 0x080fe20000410000ULL,
0x0000007221217220ULL, 0x080fe20000410000ULL, 0x0000007222227220ULL, 0x080fe20000410000ULL,
0x0000007223237220ULL, 0x080fe20000410000ULL, 0x000000721c1c7220ULL, 0x080fe20000410000ULL,
0x000000721d1d7220ULL, 0x080fe20000410000ULL, 0x000000721e1e7220ULL, 0x080fe20000410000ULL,
0x000000721f1f7220ULL, 0x080fe20000410000ULL, 0x0000007218187220ULL, 0x080fe20000410000ULL,
0x0000007219197220ULL, 0x080fe20000410000ULL, 0x000000721a1a7220ULL, 0x080fe20000410000ULL,
0x000000721b1b7220ULL, 0x080fe20000410000ULL, 0x0000007214147220ULL, 0x080fe20000410000ULL,
0x0000007215157220ULL, 0x080fe20000410000ULL, 0x0000007216167220ULL, 0x080fe20000410000ULL,
0x0000007217177220ULL, 0x080fe20000410000ULL, 0x0000007210107220ULL, 0x080fe20000410000ULL,
0x0000007211117220ULL, 0x080fe20000410000ULL, 0x0000007212127220ULL, 0x080fe20000410000ULL,
0x0000007213137220ULL, 0x080fe20000410000ULL, 0x000000720c0c7220ULL, 0x080fe20000410000ULL,
0x000000720d0d7220ULL, 0x080fe20000410000ULL, 0x000000720e0e7220ULL, 0x080fe20000410000ULL,
0x000000720f0f7220ULL, 0x080fe20000410000ULL, 0x0000007208067220ULL, 0x080fe20000410000ULL,
0x0000007209207220ULL, 0x080fe20000410000ULL, 0x000000720a407220ULL, 0x080fe20000410000ULL,
0x000000720b487220ULL, 0x080fe20000410000ULL, 0x0000007244447220ULL, 0x080fe20000410000ULL,
0x0000007245457220ULL, 0x080fe20000410000ULL, 0x0000007246467220ULL, 0x080fe20000410000ULL,
0x0000007247477220ULL, 0x002fce0000410000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x01a6884b520075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff4c7224ULL, 0x000fce00078e00ffULL, 0x000000104c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fce0000015200ULL,
0x000000080a4d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e0bULL,
0x003d09004d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000004d08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000014c4c7836ULL, 0x000fce0000000000ULL, 0x01a6884b520075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000404087824ULL, 0x000fe200078e00ffULL,
0x0000000863097c11ULL, 0x000fe4000f8e38ffULL, 0x000000717a00720cULL, 0x000fe40003f06070ULL,
0xfffffff008087812ULL, 0x000fca00078ec0ffULL, 0x00000001094a7824ULL, 0x000fca00078e0208ULL,
0x01a400004a087984ULL, 0x0002a20000000c00ULL, 0x0000002000648947ULL, 0x000fea0003800000ULL,
0x0000860000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x00000004004f7d06ULL, 0x000ee20008209000ULL, 0x00000075044b7211ULL, 0x000fe200078ff0ffULL,
0x000001007ab17824ULL, 0x000fe400078e0205ULL, 0x0000000204ae7824ULL, 0x000fe400078e00ffULL,
0x000000184b537836ULL, 0x000fc60000000000ULL, 0x00000006aeae7812ULL, 0x000fca00078ec0ffULL,
0x00000001aeaf7824ULL, 0x000fe200078e0203ULL, 0x0000004f004f7308ULL, 0x008ee40000001000ULL,
0x0ffffffe4f4d7836ULL, 0x008fe40000000000ULL, 0x000000104b4f7836ULL, 0x000fc80000000000ULL,
0x0000004d004d7305ULL, 0x000ee4000021f000ULL, 0x000000ffff517224ULL, 0x008fc800078e0a4dULL,
0x0000000451517c24ULL, 0x000fc8000f8e02ffULL, 0x000000514d547227ULL, 0x000fc800078e004cULL,
0x000000084b4c7836ULL, 0x000fe40000000000ULL, 0x0000004b544d7227ULL, 0x000fc800078e00ffULL,
0x0000004c544e7227ULL, 0x000fc800078e00ffULL, 0x000000ffff557224ULL, 0x000fe400078e0a4eULL,
0x000000ffff567224ULL, 0x000fe400078e0a4dULL, 0x00000004554c7c24ULL, 0x000fe4000f8e024cULL,
0x00000004564b7c24ULL, 0x000fe4000f8e024bULL, 0x0000004f54517227ULL, 0x000fe200078e00ffULL,
0x000000044c007c0cULL, 0x000fe4000bf06070ULL, 0x000000044b007c0cULL, 0x000fe2000bfa6070ULL,
0x0000005354547227ULL, 0x000fc800078e00ffULL, 0x000000ffff587224ULL, 0x000fe400078e0a51ULL,
0x000000ffff567224ULL, 0x000fe400078e0a54ULL, 0x00000004584f7c24ULL, 0x000fe4000f8e024fULL,
0x0000000456537c24ULL, 0x000fe4000f8e0253ULL, 0x800000044c4c0c36ULL, 0x000fe20008000000ULL,
0x000000044f007c0cULL, 0x000fe2000bf46070ULL, 0x800000044b4b5c36ULL, 0x000fe20008000000ULL,
0x0000000453007c0cULL, 0x000fe2000bf66070ULL, 0x000000014e4e0836ULL, 0x000fe20000000000ULL,
0x000000044c007c0cULL, 0x000fe2000bfc6070ULL, 0x000000014d4d5836ULL, 0x000fe20000000000ULL,
0x000000044b007c0cULL, 0x000fc4000bf86070ULL, 0x000000b1764c7248ULL, 0x000fca0007fe0000ULL,
0x800000044f4f2c36ULL, 0x000fe40008000000ULL, 0x000000014cb17824ULL, 0x000fe400078e0ab1ULL,
0x8000000453533c36ULL, 0x000fe20008000000ULL, 0x000000044f007c0cULL, 0x000fe2000bf26070ULL,
0x000000014e4e6836ULL, 0x000fe20000000000ULL, 0x00000004ff007c0cULL, 0x000fe2000bfc5070ULL,
0x000000014d4d4836ULL, 0x000fe20000000000ULL, 0x00000004ff4f7c12ULL, 0x000fe2000f8e33ffULL,
0x000000015d4c7824ULL, 0x000fe200078e02aeULL, 0x0000000453007c0cULL, 0x000fe2000bf06070ULL,
0x000000ffff8d7224ULL, 0x000fe200078e0ab1ULL, 0x0000004d4f4d7207ULL, 0x000fe20007000000ULL,
0x0000000151512836ULL, 0x000fe20000000000ULL, 0x000000b14c00720cULL, 0x000fe20003fa6070ULL,
0x0000000154543836ULL, 0x000fe20000000000ULL, 0x0000008d4c4c7246ULL, 0x000fe20003800070ULL,
0x0000000151511836ULL, 0x000fe20000000000ULL, 0x0000004d704d7248ULL, 0x000fc40003fe0000ULL,
0x000000b1af00720cULL, 0x000fe40003f86070ULL, 0x0000008daf9a7246ULL, 0x000fe20003800070ULL,
0x000000054d8b7c24ULL, 0x000fe2000f8e02ffULL, 0x00000004ff4c7819ULL, 0x000fe2000001164cULL,
0x0000000154540836ULL, 0x000fe20000000000ULL, 0x0000004e4f4b7207ULL, 0x000fe40007000000ULL,
0x000000ff9a9a7207ULL, 0x000fe40002000000ULL, 0x000000ff4c587207ULL, 0x000fc40002800000ULL,
0x0000004b704b7248ULL, 0x000fe40003fe0000ULL, 0x000000514f517207ULL, 0x000fe20007000000ULL,
0x000000018b557824ULL, 0x000fe200078e0258ULL, 0x0000008b9a4d7211ULL, 0x000fe200078fe0ffULL,
0x000000054b617c24ULL, 0x000fe2000f8e02ffULL, 0x000000544f4b7207ULL, 0x000fe20007000000ULL,
0x0000000255547825ULL, 0x100fe200078e0082ULL, 0x0000005170517248ULL, 0x000fe40003fe0000ULL,
0x0000004b704b7248ULL, 0x000fe20003fe0000ULL, 0x000000024d4c7825ULL, 0x000fe200078e0082ULL,
0x0000000654ad7981ULL, 0x004ea6000c1e9500ULL, 0x0000000551897c24ULL, 0x000fe2000f8e02ffULL,
0x000000064cac7981ULL, 0x000ea2000c1e9500ULL, 0x00000001584f7824ULL, 0x000fe200078e0261ULL,
0x000000619a5f7211ULL, 0x040fe200078fe0ffULL, 0x000000054b577c24ULL, 0x000fe2000f8e02ffULL,
0x000000899a597211ULL, 0x000fe200078fe0ffULL, 0x00000001585b7824ULL, 0x000fe200078e0289ULL,
0x00000010ae907812ULL, 0x000fe200078efcffULL, 0x000000024f4e7825ULL, 0x000fe200078e0082ULL,
0x000000579a4b7211ULL, 0x000fc600078fe0ffULL, 0x0000000158517824ULL, 0x000fe200078e0257ULL,
0x000000064e567981ULL, 0x000762000c1e9500ULL, 0x000000025f5e7825ULL, 0x000fc800078e0082ULL,
0x000000025b5a7825ULL, 0x100fe200078e0082ULL, 0x000000065e537981ULL, 0x000f66000c1e9500ULL,
0x0000000259587825ULL, 0x000fc800078e0082ULL, 0x000000015d4e7824ULL, 0x00afe200078e0290ULL,
0x00000006588a7981ULL, 0x0002e2000c1e9500ULL, 0x000000024b547825ULL, 0x000fc600078e0082ULL,
0x000000065a4b7981ULL, 0x000ee2000c1e9500ULL, 0x00000002514c7825ULL, 0x000fe200078e0082ULL,
0x0000008d4e517246ULL, 0x000fc60003800070ULL, 0x00000001906f7824ULL, 0x000fe200078e0203ULL,
0x000000b14e00720cULL, 0x080fe20003f26070ULL, 0x000000064c4f7981ULL, 0x0002e2000c1e9500ULL,
0x00000004ff517819ULL, 0x000fe40000011651ULL, 0x000000b16f00720cULL, 0x000fe20003f06070ULL,
0x0000000654547981ULL, 0x0002e2000c1e9500ULL, 0x0000008d6f9e7246ULL, 0x000fe40003800070ULL,
0x000000ff514e7207ULL, 0x000fe40000800000ULL, 0x000000ff9e9e7207ULL, 0x000fc60000000000ULL,
0x000000014e957824ULL, 0x000fe200078e0261ULL, 0x0000008b9e977211ULL, 0x040fe200078fe0ffULL,
0x000000018b597824ULL, 0x002fe200078e024eULL, 0x000000619e5f7211ULL, 0x000fe200078fe0ffULL,
0x0000000295947825ULL, 0x000fe200078e0082ULL, 0x00000020ae787812ULL, 0x000fc600078efcffULL,
0x0000000297967825ULL, 0x100fe400078e0082ULL, 0x0000000694947981ULL, 0x000ee4000c1e9500ULL,
0x0000000259587825ULL, 0x100fe400078e0082ULL, 0x0000000696967981ULL, 0x000ee4000c1e9500ULL,
0x000000025f5e7825ULL, 0x000fe400078e0082ULL, 0x00000006586d7981ULL, 0x0002e4000c1e9500ULL,
0x000000014e4d7824ULL, 0x000fc400078e0289ULL, 0x000000014e517824ULL, 0x000fe200078e0257ULL,
0x000000065e777981ULL, 0x000ee2000c1e9500ULL, 0x000000015d4e7824ULL, 0x000fe200078e0278ULL,
0x000000579e937211ULL, 0x000fe200078fe0ffULL, 0x0000000178677824ULL, 0x000fe200078e0203ULL,
0x000000899e5b7211ULL, 0x000fe400078fe0ffULL, 0x0000008d4e557246ULL, 0x000fe20003800070ULL,
0x000000024d4c7825ULL, 0x100fe200078e0082ULL, 0x000000b16700720cULL, 0x080fe40003f06070ULL,
0x0000008d67a27246ULL, 0x000fe20003800070ULL, 0x0000000293927825ULL, 0x000fe200078e0082ULL,
0x000000b14e00720cULL, 0x000fe20003f26070ULL, 0x000000064c4c7981ULL, 0x000ee2000c1e9500ULL,
0x00000004ff557819ULL, 0x000fe20000011655ULL, 0x000000025b5a7825ULL, 0x100fe200078e0082ULL,
0x000000ffa2a27207ULL, 0x000fe20000000000ULL, 0x0000000692927981ULL, 0x000ee4000c1e9500ULL,
0x0000000251587825ULL, 0x002fe200078e0082ULL, 0x000000ff554e7207ULL, 0x000fe20000800000ULL,
0x000000065a737981ULL, 0x0002e2000c1e9500ULL, 0x00000061a2697211ULL, 0x000fc600078fe0ffULL,
0x0000000658517981ULL, 0x0002e4000c1e9500ULL, 0x0000000269687825ULL, 0x000fe200078e0082ULL,
0x0000008ba25b7211ULL, 0x002fca00078fe0ffULL, 0x0000000668697981ULL, 0x000ee2000c1e9500ULL,
0x000000014e597824ULL, 0x000fc800078e0261ULL, 0x0000000259587825ULL, 0x000fe200078e0082ULL,
0x00000089a2657211ULL, 0x000fc800078fe0ffULL, 0x0000000658807981ULL, 0x000ee2000c1e9500ULL,
0x000000025b5a7825ULL, 0x000fe200078e0082ULL, 0x00000057a24d7211ULL, 0x000fc600078fe0ffULL,
0x000000018b857824ULL, 0x000fe200078e024eULL, 0x000000065a6b7981ULL, 0x0002e2000c1e9500ULL,
0x000000014e877824ULL, 0x040fe400078e0289ULL, 0x000000014e5f7824ULL, 0x000fe200078e0257ULL,
0x00000030ae607812ULL, 0x000fe200078efcffULL, 0x0000000285847825ULL, 0x000fc800078e0082ULL,
0x0000000287867825ULL, 0x100fe400078e0082ULL, 0x0000000684847981ULL, 0x000ee4000c1e9500ULL,
0x0000000265647825ULL, 0x000fc800078e0082ULL, 0x000000025f5e7825ULL, 0x100fe200078e0082ULL,
0x00000006647e7981ULL, 0x000ee6000c1e9500ULL, 0x000000024d5a7825ULL, 0x002fe200078e0082ULL,
0x000000065e557981ULL, 0x0002e6000c1e9500ULL, 0x000000015d4e7824ULL, 0x000fe200078e0260ULL,
0x00000006864d7981ULL, 0x000ee2000c1e9500ULL, 0x0000000160597824ULL, 0x000fc600078e0203ULL,
0x000000065a7c7981ULL, 0x0002e2000c1e9500ULL, 0x0000008d4e587246ULL, 0x000fe40003800070ULL,
0x000000b15900720cULL, 0x080fe40003f06070ULL, 0x0000008d59987246ULL, 0x000fe40003800070ULL,
0x000000b14e00720cULL, 0x000fe40003f26070ULL, 0x00000004ff587819ULL, 0x000fe40000011658ULL,
0x000000ff98987207ULL, 0x000fc40000000000ULL, 0x000000ff58587207ULL, 0x000fe40000800000ULL,
0x00000089985f7211ULL, 0x042fe400078fe0ffULL, 0x0000008b985b7211ULL, 0x000fe200078fe0ffULL,
0x000000018b8f7824ULL, 0x000fe400078e0258ULL, 0x0000000158877824ULL, 0x000fe400078e0289ULL,
0x000000025f5e7825ULL, 0x000fc800078e0082ULL, 0x000000028f8e7825ULL, 0x100fe400078e0082ULL,
0x000000065e5f7981ULL, 0x000ee4000c1e9500ULL, 0x000000025b5a7825ULL, 0x100fe400078e0082ULL,
0x000000068e687981ULL, 0x000ee4000c1e9500ULL, 0x0000000287867825ULL, 0x000fe400078e0082ULL,
0x000000065a657981ULL, 0x0002e4000c1e9500ULL, 0x00000001588d7824ULL, 0x000fc400078e0261ULL,
0x00000006864e7981ULL, 0x000ee2000c1e9500ULL, 0x0000006198617211ULL, 0x000fe200078fe0ffULL,
0x000000028d8c7825ULL, 0x000fc800078e0082ULL, 0x0000000261887825ULL, 0x000fe200078e0082ULL,
0x000000068c667981ULL, 0x0002e4000c1e9500ULL, 0x00000057985b7211ULL, 0x002fe400078fe0ffULL,
0x0000000688617981ULL, 0x0002e2000c1e9500ULL, 0x00000001589d7824ULL, 0x000fe400078e0257ULL,
0x000000025b5a7825ULL, 0x000fc800078e0082ULL, 0x000000029d9c7825ULL, 0x000fe400078e0082ULL,
0x000000065a5b7981ULL, 0x000ee8000c1e9500ULL, 0x000000069c647981ULL, 0x0002e2000c1e9500ULL,
0xfffffff09a9a7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff577424ULL, 0x000fc800078e00ffULL,
0x00000001b19a7824ULL, 0x000fc800078e029aULL, 0x00000001afc07824ULL, 0x000fe200078e0a9aULL,
0x00000001aeaa7812ULL, 0x000fc800078efcffULL, 0x000000c057ab7219ULL, 0x000fe200000006ffULL,
0x00000001aaa97824ULL, 0x000fe200078e0203ULL, 0x00000008aea87812ULL, 0x000fc600078efcffULL,
0x00000001a9be7824ULL, 0x000fe200078e0a9aULL, 0x00000009ae8e7812ULL, 0x000fe200078efcffULL,
0x00000001a8a67824ULL, 0x000fc600078e0203ULL, 0x000000be57a77219ULL, 0x000fe200000006ffULL,
0x000000018e857824ULL, 0x000fe400078e0203ULL, 0x00000001a6bc7824ULL, 0x100fe400078e0a9aULL,
0x00000001859a7824ULL, 0x000fe200078e0a9aULL, 0x00000011ae8c7812ULL, 0x000fe400078efcffULL,
0xfffffff09e9e7812ULL, 0x000fe400078ec0ffULL, 0x000000bc57997219ULL, 0x000fc400000006ffULL,
0x0000009a579a7219ULL, 0x000fe200000006ffULL, 0x000000018c877824ULL, 0x000fe400078e0203ULL,
0x00000001b19e7824ULL, 0x000fe200078e029eULL, 0x00000018ae887812ULL, 0x002fc600078efcffULL,
0x000000016fba7824ULL, 0x100fe400078e0a9eULL, 0x00000001879c7824ULL, 0x000fe200078e0a9eULL,
0x00005410acac7816ULL, 0x004fc800000000adULL, 0x000000acabff7212ULL, 0x000fc800078ac0ffULL,
0x000000b1af00720cULL, 0x000fc80002fa1470ULL, 0x000000b1ae00720cULL, 0x000fe40002fa1070ULL,
0x000000aca7ff7212ULL, 0x000fe4000782c0ffULL, 0x0000541053567816ULL, 0x020fe40000000056ULL,
0xff80000007077808ULL, 0x000fe40002800000ULL, 0x00000056abff7212ULL, 0x080fe4000784c0ffULL,
0x00000056a7ff7212ULL, 0x000fc400078ac0ffULL, 0x000054108a8a7816ULL, 0x008fc8000000004bULL,
0x0000008aabff7212ULL, 0x000fe4000788c0ffULL, 0x000000b1af00720cULL, 0x0c0fe40001741470ULL,
0x000000b1af00720cULL, 0x080fe40002781470ULL, 0x000000b1a900720cULL, 0x0c0fe40000f21470ULL,
0x000000b1a900720cULL, 0x080fe40002fa1470ULL, 0x000000b1ae00720cULL, 0x000fc40001741070ULL,
0x000000b1ae00720cULL, 0x080fe40002781070ULL, 0x000000b1aa00720cULL, 0x0c0fe40000f21070ULL,
0x000000b1aa00720cULL, 0x000fe40002fa1070ULL, 0x0000541054547816ULL, 0x000fe4000000004fULL,
0xff80000042427808ULL, 0x000fe40001000000ULL, 0xff80000049497808ULL, 0x000fc40002000000ULL,
0xff80000041417808ULL, 0x000fe40000800000ULL, 0xff80000043437808ULL, 0x000fe40002800000ULL,
0x000000ac99ff7212ULL, 0x000fe4000786c0ffULL, 0x00000054abff7212ULL, 0x000fe4000780c0ffULL,
0x0000008aa7ff7212ULL, 0x040fe4000784c0ffULL, 0x00000054a7ff7212ULL, 0x000fc4000788c0ffULL,
0x000000569aff7212ULL, 0x000fe4000782c0ffULL, 0x0000008a99ff7212ULL, 0x000fe400078ac0ffULL,
0x000000b1af00720cULL, 0x080fe40000701470ULL, 0x000000b1a900720cULL, 0x0c0fe40001741470ULL,
0x000000b1a900720cULL, 0x080fe40002781470ULL, 0x000000b1a600720cULL, 0x000fc40001f61470ULL,
0x000000b1a600720cULL, 0x080fe40002fa1470ULL, 0x000000b18500720cULL, 0x080fe40000f21470ULL,
0x00000019ae867812ULL, 0x040fe400078efcffULL, 0x000000b1ae00720cULL, 0x080fe40000701070ULL,
0x000000b1aa00720cULL, 0x0c0fe40001741070ULL, 0x000000b1aa00720cULL, 0x000fc40002781070ULL,
0x000000b1a800720cULL, 0x0c0fe40001f61070ULL, 0x000000b1a800720cULL, 0x080fe40002fa1070ULL,
0x000000b18e00720cULL, 0x000fe40000f21070ULL, 0x000000ba579b7219ULL, 0x040fe400000006ffULL,
0x0000009c579c7219ULL, 0x000fe400000006ffULL, 0x00005410966d7816ULL, 0x000fc4000000006dULL,
0x0000541077777816ULL, 0x000fe20000000094ULL, 0x0000000188897824ULL, 0x100fe200078e0203ULL,
0xff80000022227808ULL, 0x000fe20000000000ULL, 0x00000001868b7824ULL, 0x000fe200078e0203ULL,
0xff80000021217808ULL, 0x000fe40001000000ULL, 0xff80000023237808ULL, 0x000fe40002000000ULL,
0xff8000003c3c7808ULL, 0x000fe40001800000ULL, 0xff8000001c1c7808ULL, 0x000fc40002800000ULL,
0xff8000003f3f7808ULL, 0x000fe40000800000ULL, 0x0000005699ff7212ULL, 0x040fe4000780c0ffULL,
0x0000008a9aff7212ULL, 0x040fe4000784c0ffULL, 0x0000005499ff7212ULL, 0x080fe4000788c0ffULL,
0x000000549aff7212ULL, 0x000fe4000786c0ffULL, 0x0000006d9cff7212ULL, 0x000fc400078ac0ffULL,
0x000000779bff7212ULL, 0x000fe2000782c0ffULL, 0x0000000189b87824ULL, 0x100fe200078e0a9eULL,
0x000000b1a600720cULL, 0x0c0fe20000701470ULL, 0x000000018b9e7824ULL, 0x000fe200078e0a9eULL,
0x000000b1a600720cULL, 0x080fe40002781470ULL, 0x000000b18500720cULL, 0x0c0fe40001741470ULL,
0x000000b18500720cULL, 0x080fe40001f61470ULL, 0x000000b16f00720cULL, 0x000fc40000f21470ULL,
0x000000b18700720cULL, 0x080fe40002fa1470ULL, 0xfffffff0a2a27812ULL, 0x000fe400078ec0ffULL,
0x000000b1a800720cULL, 0x0c0fe40000701070ULL, 0x000000b1a800720cULL, 0x080fe40002781070ULL,
0x000000b18e00720cULL, 0x0c0fe40001741070ULL, 0x000000b18e00720cULL, 0x000fc40001f61070ULL,
0x000000b19000720cULL, 0x080fe40000f21070ULL, 0x000000b18c00720cULL, 0x000fe40002fa1070ULL,
0x000000b8579d7219ULL, 0x040fe400000006ffULL, 0x0000009e579e7219ULL, 0x000fe400000006ffULL,
0x00005410734c7816ULL, 0x000fe4000000004cULL, 0x0000541092517816ULL, 0x000fe20000000051ULL,
0x00000001b1a27824ULL, 0x000fe200078e02a2ULL, 0xff8000003e3e7808ULL, 0x000fc40000000000ULL,
0xff8000001e1e7808ULL, 0x000fe40002000000ULL, 0xff8000001d1d7808ULL, 0x000fe40001000000ULL,
0xff8000001f1f7808ULL, 0x000fe40001800000ULL, 0xff8000003a3a7808ULL, 0x000fe40000800000ULL,
0xff80000039397808ULL, 0x000fe40002800000ULL, 0x0000006d9bff7212ULL, 0x000fc4000780c0ffULL,
0x0000006d9dff7212ULL, 0x000fe4000788c0ffULL, 0x0000004c9bff7212ULL, 0x0c0fe4000784c0ffULL,
0x000000519bff7212ULL, 0x000fe4000786c0ffULL, 0x0000004c9cff7212ULL, 0x000fe4000782c0ffULL,
0x000000779eff7212ULL, 0x000fe200078ac0ffULL, 0x0000000167b67824ULL, 0x000fe200078e0aa2ULL,
0x000000b16f00720cULL, 0x000fc40000701470ULL, 0x000000b16f00720cULL, 0x0c0fe40001741470ULL,
0x000000b16f00720cULL, 0x080fe40001f61470ULL, 0x000000b18700720cULL, 0x080fe40000f21470ULL,
0x000000b18900720cULL, 0x080fe40002781470ULL, 0x000000b18b00720cULL, 0x000fe40002fa1470ULL,
0x00000021ae6e7812ULL, 0x000fc400078efcffULL, 0x000000b19000720cULL, 0x0c0fe40000701070ULL,
0x000000b19000720cULL, 0x0c0fe40001741070ULL, 0x000000b19000720cULL, 0x080fe40001f61070ULL,
0x000000b18c00720cULL, 0x080fe40000f21070ULL, 0x000000b18800720cULL, 0x080fe40002781070ULL,
0x000000b18600720cULL, 0x000fc40002fa1070ULL, 0x000000b6579f7219ULL, 0x000fe400000006ffULL,
0x0000541069697816ULL, 0x000fe20000000080ULL, 0x000000016e8d7824ULL, 0x000fe200078e0203ULL,
0xff80000038387808ULL, 0x000fe40000000000ULL, 0xff80000018187808ULL, 0x000fe40001000000ULL,
0xff8000001a1a7808ULL, 0x000fe40001800000ULL, 0xff80000019197808ULL, 0x000fc40000800000ULL,
0xff80000034347808ULL, 0x000fe40002000000ULL, 0xff80000037377808ULL, 0x000fe40002800000ULL,
0x000000779cff7212ULL, 0x040fe4000780c0ffULL, 0x000000519cff7212ULL, 0x000fe4000784c0ffULL,
0x000000779dff7212ULL, 0x000fe4000786c0ffULL, 0x0000004c9eff7212ULL, 0x000fc4000782c0ffULL,
0x000000519eff7212ULL, 0x000fe4000788c0ffULL, 0x000000699fff7212ULL, 0x000fe200078ac0ffULL,
0x000000018da07824ULL, 0x000fe200078e0aa2ULL, 0x000000b18700720cULL, 0x0c0fe40000701470ULL,
0x000000b18700720cULL, 0x080fe40001741470ULL, 0x000000b18900720cULL, 0x080fe40001f61470ULL,
0x000000b18b00720cULL, 0x000fc40000f21470ULL, 0x000000b18b00720cULL, 0x080fe40002781470ULL,
0x000000b16700720cULL, 0x080fe40002fa1470ULL, 0x00000028ae6c7812ULL, 0x040fe400078efcffULL,
0x00000029ae6a7812ULL, 0x000fe400078efcffULL, 0x000000b18c00720cULL, 0x0c0fe40000701070ULL,
0x000000b18c00720cULL, 0x000fc40001741070ULL, 0x000000b18800720cULL, 0x080fe40001f61070ULL,
0x000000b18600720cULL, 0x0c0fe40000f21070ULL, 0x000000b18600720cULL, 0x080fe40002781070ULL,
0x000000b17800720cULL, 0x000fe40002fa1070ULL, 0x000000a057a07219ULL, 0x000fe400000006ffULL,
0x000054106b6b7816ULL, 0x000fc40000000084ULL, 0x000054107e4d7816ULL, 0x000fe4000000004dULL,
0x000054107c557816ULL, 0x000fe20000000055ULL, 0x000000016c8f7824ULL, 0x100fe200078e0203ULL,
0xff8000003b3b7808ULL, 0x000fe20000000000ULL, 0x000000016a917824ULL, 0x000fe200078e0203ULL,
0xff8000001b1b7808ULL, 0x000fe40001000000ULL, 0xff80000036367808ULL, 0x000fe40001800000ULL,
0xff80000015157808ULL, 0x000fc40000800000ULL, 0xff80000017177808ULL, 0x000fe40002000000ULL,
0xff80000032327808ULL, 0x000fe40002800000ULL, 0x000000ac9aff7212ULL, 0x000fe400078cc0ffULL,
0x0000004c9dff7212ULL, 0x040fe4000780c0ffULL, 0x000000519dff7212ULL, 0x000fe4000784c0ffULL,
0x0000006b9fff7212ULL, 0x000fc4000786c0ffULL, 0x0000004d9fff7212ULL, 0x040fe4000782c0ffULL,
0x000000559fff7212ULL, 0x000fe4000788c0ffULL, 0x0000004da0ff7212ULL, 0x000fe200078ac0ffULL,
0x000000018fb47824ULL, 0x100fe200078e0aa2ULL, 0x000000b18500720cULL, 0x080fe200037c1470ULL,
0x0000000191a27824ULL, 0x000fe200078e0aa2ULL, 0x000000b18900720cULL, 0x0c0fe40000701470ULL,
0x000000b18900720cULL, 0x000fc40001741470ULL, 0x000000b16700720cULL, 0x0c0fe40001f61470ULL,
0x000000b16700720cULL, 0x0c0fe40000f21470ULL, 0x000000b16700720cULL, 0x080fe40002781470ULL,
0x000000b18d00720cULL, 0x080fe40002fa1470ULL, 0xfffffff098987812ULL, 0x000fe400078ec0ffULL,
0x000000b18e00720cULL, 0x000fc400037c1070ULL, 0x000000b18800720cULL, 0x0c0fe40000701070ULL,
0x000000b18800720cULL, 0x080fe40001741070ULL, 0x000000b17800720cULL, 0x0c0fe40001f61070ULL,
0x000000b17800720cULL, 0x0c0fe40000f21070ULL, 0x000000b17800720cULL, 0x080fe40002781070ULL,
0x000000b16e00720cULL, 0x000fc40002fa1070ULL, 0x000000b457a17219ULL, 0x040fe400000006ffULL,
0x000000a257a27219ULL, 0x000fe200000006ffULL, 0x00000001b1987824ULL, 0x000fe200078e0298ULL,
0xff8000003d3d7808ULL, 0x000fe40003000000ULL, 0xff80000014147808ULL, 0x000fe40000000000ULL,
0xff80000016167808ULL, 0x000fe40001000000ULL, 0xff80000030307808ULL, 0x000fc40001800000ULL,
0xff80000010107808ULL, 0x000fe40000800000ULL, 0xff80000012127808ULL, 0x000fe40002000000ULL,
0xff80000011117808ULL, 0x000fe40002800000ULL, 0x0000006d9eff7212ULL, 0x000fe400078cc0ffULL,
0x0000006ba0ff7212ULL, 0x080fe4000780c0ffULL, 0x0000006ba1ff7212ULL, 0x000fc4000784c0ffULL,
0x00000069a0ff7212ULL, 0x040fe4000786c0ffULL, 0x00000055a0ff7212ULL, 0x000fe4000782c0ffULL,
0x00000069a1ff7212ULL, 0x000fe4000788c0ffULL, 0x0000004da2ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000159b27824ULL, 0x000fe200078e0a98ULL, 0x000000b18b00720cULL, 0x080fe400037c1470ULL,
0x000000b18d00720cULL, 0x000fc40000701470ULL, 0x000000b18d00720cULL, 0x0c0fe40001f61470ULL,
0x000000b18d00720cULL, 0x080fe40000f21470ULL, 0x000000b18f00720cULL, 0x0c0fe40001741470ULL,
0x000000b18f00720cULL, 0x080fe40002781470ULL, 0x000000b19100720cULL, 0x000fe40002fa1470ULL,
0x00000031ae5e7812ULL, 0x000fc400078efcffULL, 0x00000038ae5a7812ULL, 0x040fe400078efcffULL,
0x00000039ae587812ULL, 0x000fe400078efcffULL, 0x000000b18600720cULL, 0x080fe400037c1070ULL,
0x000000b16e00720cULL, 0x0c0fe40000701070ULL, 0x000000b16e00720cULL, 0x0c0fe40001f61070ULL,
0x000000b16e00720cULL, 0x000fc40000f21070ULL, 0x000000b16c00720cULL, 0x0c0fe40001741070ULL,
0x000000b16c00720cULL, 0x080fe40002781070ULL, 0x000000b16a00720cULL, 0x000fe40002fa1070ULL,
0x000000b257a37219ULL, 0x000fe400000006ffULL, 0x0000541065657816ULL, 0x000fe40000000068ULL,
0x000054105f4e7816ULL, 0x000fe2000000004eULL, 0x000000015e937824ULL, 0x100fe200078e0203ULL,
0xff80000035357808ULL, 0x000fe20003000000ULL, 0x000000015a957824ULL, 0x100fe200078e0203ULL,
0xff80000031317808ULL, 0x000fe20000000000ULL, 0x0000000158977824ULL, 0x000fe200078e0203ULL,
0xff80000033337808ULL, 0x000fc40001800000ULL, 0xff80000013137808ULL, 0x000fe40000800000ULL,
0xff8000002c2c7808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40002000000ULL,
0xff8000000d0d7808ULL, 0x000fe40002800000ULL, 0x0000006ba2ff7212ULL, 0x040fe400078cc0ffULL,
0x00000069a2ff7212ULL, 0x000fc4000780c0ffULL, 0x0000004da1ff7212ULL, 0x040fe4000786c0ffULL,
0x00000055a1ff7212ULL, 0x080fe4000782c0ffULL, 0x00000055a2ff7212ULL, 0x000fe4000784c0ffULL,
0x00000065a3ff7212ULL, 0x040fe4000788c0ffULL, 0x0000004ea3ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000193a47824ULL, 0x100fe200078e0a98ULL, 0x000000b18f00720cULL, 0x080fe20001f61470ULL,
0x0000000195b07824ULL, 0x100fe200078e0a98ULL, 0x000000b18f00720cULL, 0x080fe20000f21470ULL,
0x0000000197987824ULL, 0x000fe200078e0a98ULL, 0x000000b19100720cULL, 0x000fc400037c1470ULL,
0x000000b19100720cULL, 0x0c0fe40000701470ULL, 0x000000b19100720cULL, 0x080fe40001741470ULL,
0x000000b15900720cULL, 0x0c0fe40002781470ULL, 0x000000b15900720cULL, 0x080fe40002fa1470ULL,
0x000000b16c00720cULL, 0x0c0fe40001f61070ULL, 0x000000b16c00720cULL, 0x000fc40000f21070ULL,
0x000000b16a00720cULL, 0x0c0fe400037c1070ULL, 0x000000b16a00720cULL, 0x0c0fe40000701070ULL,
0x000000b16a00720cULL, 0x080fe40001741070ULL, 0x000000b16000720cULL, 0x0c0fe40002781070ULL,
0x000000b16000720cULL, 0x000fe40002fa1070ULL, 0x000000a457a47219ULL, 0x000fc400000006ffULL,
0x000000b057a57219ULL, 0x040fe400000006ffULL, 0x0000009857987219ULL, 0x000fe400000006ffULL,
0x0000541061617816ULL, 0x000fe40000000066ULL, 0xff8000000c0c7808ULL, 0x000fe40001800000ULL,
0xff8000000e0e7808ULL, 0x000fe40000800000ULL, 0xff8000002d2d7808ULL, 0x000fc40003000000ULL,
0xff8000002f2f7808ULL, 0x000fe40000000000ULL, 0xff8000000f0f7808ULL, 0x000fe40001000000ULL,
0xff80000028287808ULL, 0x000fe40002000000ULL, 0xff80000006067808ULL, 0x000fe40002800000ULL,
0x00000065a4ff7212ULL, 0x080fe4000786c0ffULL, 0x00000065a5ff7212ULL, 0x000fc4000782c0ffULL,
0x0000006598ff7212ULL, 0x000fe400078cc0ffULL, 0x00000061a3ff7212ULL, 0x080fe4000780c0ffULL,
0x00000061a4ff7212ULL, 0x0c0fe4000784c0ffULL, 0x00000061a5ff7212ULL, 0x000fe4000788c0ffULL,
0x0000004ea4ff7212ULL, 0x000fe400078ac0ffULL, 0x000000b15900720cULL, 0x000fc40000701470ULL,
0x000000b19300720cULL, 0x0c0fe40001f61470ULL, 0x000000b19300720cULL, 0x0c0fe40001741470ULL,
0x000000b19300720cULL, 0x080fe40002fa1470ULL, 0x000000b19500720cULL, 0x080fe40000f21470ULL,
0x000000b19700720cULL, 0x080fe400037c1470ULL, 0x000000b19500720cULL, 0x000fc40002781470ULL,
0x000000b16000720cULL, 0x080fe40000701070ULL, 0x000000b15e00720cULL, 0x0c0fe40001f61070ULL,
0x000000b15e00720cULL, 0x0c0fe40001741070ULL, 0x000000b15e00720cULL, 0x080fe40002fa1070ULL,
0x000000b15a00720cULL, 0x080fe40000f21070ULL, 0x000000b15800720cULL, 0x000fc400037c1070ULL,
0x000000b15a00720cULL, 0x000fe40002781070ULL, 0x000054105b5b7816ULL, 0x000fe40000000064ULL,
0xff8000002a2a7808ULL, 0x000fe40000000000ULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff80000020207808ULL, 0x000fc40002800000ULL,
0xff80000024247808ULL, 0x000fe40000800000ULL, 0xff80000025257808ULL, 0x000fe40003000000ULL,
0xff80000026267808ULL, 0x000fe40002000000ULL, 0x0000006198ff7212ULL, 0x040fe4000780c0ffULL,
0x0000004ea5ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004e98ff7212ULL, 0x000fc4000784c0ffULL,
0x0000005ba3ff7212ULL, 0x080fe400078ac0ffULL, 0x0000005ba4ff7212ULL, 0x080fe4000782c0ffULL,
0x0000005ba5ff7212ULL, 0x080fe400078cc0ffULL, 0x0000005b98ff7212ULL, 0x000fe4000788c0ffULL,
0x000000b15900720cULL, 0x080fe40002fa1470ULL, 0x000000b19300720cULL, 0x000fc40000f21470ULL,
0x000000b19500720cULL, 0x0c0fe40001f61470ULL, 0x000000b19500720cULL, 0x080fe400037c1470ULL,
0x000000b19700720cULL, 0x0c0fe40000701470ULL, 0x000000b19700720cULL, 0x0c0fe40001741470ULL,
0x000000b19700720cULL, 0x080fe40002781470ULL, 0x000000b16000720cULL, 0x000fc40002fa1070ULL,
0x000000b15e00720cULL, 0x080fe40000f21070ULL, 0x000000b15800720cULL, 0x080fe40000701070ULL,
0x000000b15a00720cULL, 0x0c0fe40001f61070ULL, 0x000000b15a00720cULL, 0x080fe400037c1070ULL,
0x000000b15800720cULL, 0x0c0fe40001741070ULL, 0x000000b15800720cULL, 0x000fc40002781070ULL,
0xff80000027277808ULL, 0x000fe40000000000ULL, 0xff80000044447808ULL, 0x000fe40001800000ULL,
0xff80000045457808ULL, 0x000fe40001000000ULL, 0xff80000040407808ULL, 0x000fe40002800000ULL,
0xff80000048487808ULL, 0x000fe40000800000ULL, 0xff80000046467808ULL, 0x000fc40003000000ULL,
0xff80000047477808ULL, 0x000fce0002000000ULL, 0x000000070800720bULL, 0x004fe20003f1e000ULL,
0x000000017a7a7836ULL, 0x000fe20000000000ULL, 0xfffffff8ff507812ULL, 0x000fe400078ee250ULL,
0x0000000807087208ULL, 0x000fc80004000000ULL, 0x000000410800720bULL, 0x000fc80003f1e000ULL,
0x00000008414b7208ULL, 0x000fc80004000000ULL, 0x0000003c4b00720bULL, 0x000fc80003f1e000ULL,
0x0000004b3c087208ULL, 0x000fc80004000000ULL, 0x0000003d0800720bULL, 0x000fc80003f1e000ULL,
0x000000083d4b7208ULL, 0x000fc80004000000ULL, 0x000000384b00720bULL, 0x000fc80003f1e000ULL,
0x0000004b38087208ULL, 0x000fc80004000000ULL, 0x000000390800720bULL, 0x000fc80003f1e000ULL,
0x00000008394b7208ULL, 0x000fc80004000000ULL, 0x000000344b00720bULL, 0x000fc80003f1e000ULL,
0x0000004b34087208ULL, 0x000fc80004000000ULL, 0x000000350800720bULL, 0x000fc80003f1e000ULL,
0x00000008354b7208ULL, 0x000fc80004000000ULL, 0x000000304b00720bULL, 0x000fc80003f1e000ULL,
0x0000004b30087208ULL, 0x000fc80004000000ULL, 0x000000310800720bULL, 0x000fc80003f1e000ULL,
0x00000008314b7208ULL, 0x000fc80004000000ULL, 0x0000002c4b00720bULL, 0x000fc80003f1e000ULL,
0x0000004b2c087208ULL, 0x000fc80004000000ULL, 0x0000002d0800720bULL, 0x000fc80003f1e000ULL,
0x000000082d4b7208ULL, 0x000fc80004000000ULL, 0x000000284b00720bULL, 0x000fc80003f1e000ULL,
0x0000004b28087208ULL, 0x000fc80004000000ULL, 0x000000290800720bULL, 0x000fc80003f1e000ULL,
0x00000008294b7208ULL, 0x000fc80004000000ULL, 0x000000244b00720bULL, 0x000fc80003f1e000ULL,
0x0000004b24087208ULL, 0x000fe40004000000ULL, 0x000000420900720bULL, 0x000fe40003f1e000ULL,
0x000000250800720bULL, 0x000fc80003f3e000ULL, 0x00000008254b7208ULL, 0x000fe40004800000ULL,
0x0000000942087208ULL, 0x000fc60004000000ULL, 0x0c401f004b4c7f89ULL, 0x000ea200000e0000ULL,
0x000000430800720bULL, 0x000fc80003f1e000ULL, 0x0000000843097208ULL, 0x000fc80004000000ULL,
0x0000003e0900720bULL, 0x000fc80003f1e000ULL, 0x000000093e087208ULL, 0x000fc80004000000ULL,
0x0000003f0800720bULL, 0x000fc80003f1e000ULL, 0x000000083f097208ULL, 0x000fe40004000000ULL,
0x0000004c4b00720bULL, 0x004fe40003f3e000ULL, 0x0000003a0900720bULL, 0x000fe40003f1e000ULL,
0x0000004b4c4d7208ULL, 0x000fe40004800000ULL, 0x000000093a087208ULL, 0x000fc60004000000ULL,
0x0c201f004d4c7f89ULL, 0x000ea200000e0000ULL, 0x0000003b0800720bULL, 0x000fc80003f1e000ULL,
0x000000083b097208ULL, 0x000fc80004000000ULL, 0x000000360900720bULL, 0x000fc80003f1e000ULL,
0x0000000936087208ULL, 0x000fc80004000000ULL, 0x000000370800720bULL, 0x000fc80003f1e000ULL,
0x0000000837097208ULL, 0x000fe40004000000ULL, 0x0000004c4d00720bULL, 0x004fe40003f3e000ULL,
0x000000320900720bULL, 0x000fe40003f1e000ULL, 0x0000004d4c087208ULL, 0x000fe40004800000ULL,
0x00000009324c7208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b08567820ULL, 0x000fe20000410000ULL,
0x000000334c00720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010856ULL,
0x0000004c33097208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b414c7823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b3d417823ULL, 0x100fe20000010856ULL, 0x3fb8aa3b343d7823ULL, 0x100fe20000010856ULL,
0x0000002e0900720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b07077823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe20000010856ULL, 0x3fb8aa3b38387823ULL, 0x100fe20000010856ULL,
0x000000092e4e7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010856ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010856ULL,
0x0000002f4e00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b29297823ULL, 0x000fe20000010856ULL, 0x0000000700077308ULL, 0x000fe20000000800ULL,
0x0000004e2f097208ULL, 0x000fc80004000000ULL, 0x0000002a0900720bULL, 0x000fc60003f1e000ULL,
0x0000004c004c7308ULL, 0x000fe20000000800ULL, 0x000000092a4e7208ULL, 0x000fc80004000000ULL,
0x0000002b4e00720bULL, 0x000fc60003f1e000ULL, 0x0000003c003c7308ULL, 0x000fe20000000800ULL,
0x0000004e2b097208ULL, 0x000fc80004000000ULL, 0x000000260900720bULL, 0x000fc60003f1e000ULL,
0x0000004100417308ULL, 0x000fe20000000800ULL, 0x00000009264e7208ULL, 0x000fc80004000000ULL,
0x000000274e00720bULL, 0x000fc60003f1e000ULL, 0x0000003800387308ULL, 0x000fe20000000800ULL,
0x0000004e27347208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b354e7823ULL, 0x100fe20000010856ULL,
0x000000490a00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2d357823ULL, 0x000fe40000010856ULL,
0x0c401f00344b7f89ULL, 0x000ea200000e0000ULL, 0x0000000a490a7208ULL, 0x000fe20004000000ULL,
0x0000003900397308ULL, 0x000fe60000000800ULL, 0x000000210a00720bULL, 0x000fc80003f1e000ULL,
0x0000000a21097208ULL, 0x000fe20004000000ULL, 0x0000003d003d7308ULL, 0x000fe60000000800ULL,
0x0000001c0900720bULL, 0x000fc80003f1e000ULL, 0x000000091c0a7208ULL, 0x000fe20004000000ULL,
0x0000004e004e7308ULL, 0x000fe60000000800ULL, 0x0000001d0a00720bULL, 0x000fe40003f1e000ULL,
0x0000004b3400720bULL, 0x004fe40003f3e000ULL, 0x0000000a1d097208ULL, 0x000fe20004000000ULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x000000344b4b7208ULL, 0x000fc40004800000ULL,
0x000000180900720bULL, 0x000fc60003f1e000ULL, 0x0c201f004b547f89ULL, 0x000ea200000e0000ULL,
0x00000009180a7208ULL, 0x000fe20004000000ULL, 0x0000002c00347308ULL, 0x0007e60000000800ULL,
0x000000190a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a19097208ULL, 0x000fe20004000000ULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b242c7823ULL, 0x108fe20000010856ULL,
0x3fb8aa3b25567823ULL, 0x000fe20000010856ULL, 0x000000140900720bULL, 0x000fc80003f1e000ULL,
0x00000009140a7208ULL, 0x000fe20004000000ULL, 0x0000003500357308ULL, 0x000fe60000000800ULL,
0x000000150a00720bULL, 0x000fe40003f1e000ULL, 0x000000544b00720bULL, 0x004fe40003f3e000ULL,
0x0000000a152d7208ULL, 0x000fe20004000000ULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0x0000004b54097208ULL, 0x000fc40004800000ULL, 0x000000102d00720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b094d7820ULL, 0x000fe20000410000ULL, 0x0000002d100a7208ULL, 0x000fe20004000000ULL,
0x0000002800287308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b42247823ULL, 0x100fe2000001084dULL,
0x000000110a00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b43427823ULL, 0x100fe2000001084dULL,
0x3fb8aa3b37547823ULL, 0x100fe2000001084dULL, 0x3fb8aa3b26377823ULL, 0x100fe2000001084dULL,
0x0000000a11257208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe2000001084dULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe2000001084dULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x0000000c2500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe2000001084dULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe2000001084dULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001084dULL,
0x000000250c0a7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001084dULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001084dULL, 0x0000004200257308ULL, 0x0005e20000000800ULL,
0x0000000d0a00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001084dULL,
0x3fb8aa3b2b2b7823ULL, 0x000fc4000001084dULL, 0x0000000a0d437208ULL, 0x000fe40004000000ULL,
0x000000220b00720bULL, 0x000fe20003f1e000ULL, 0x0000003e003e7308ULL, 0x000fe20000000800ULL,
0x000000064300720bULL, 0x000fe40003f3e000ULL, 0x0000000b220a7208ULL, 0x000fe40004000000ULL,
0x0000004306437208ULL, 0x000fe40004800000ULL, 0x000000230a00720bULL, 0x000fe20003f1e000ULL,
0x0000003f003f7308ULL, 0x000fe20000000800ULL, 0x000000204300720bULL, 0x000fc40003f3e000ULL,
0x0000000a230b7208ULL, 0x000fe40004000000ULL, 0x0000004320437208ULL, 0x000fe40004800000ULL,
0x0000001e0b00720bULL, 0x000fe20003f1e000ULL, 0x00000056002d7308ULL, 0x000fe20000000800ULL,
0x000000444300720bULL, 0x000fe40003f3e000ULL, 0x0000000b1e0a7208ULL, 0x000fe40004000000ULL,
0x0000004344427208ULL, 0x004fe20004800000ULL, 0x3fb8aa3b36437823ULL, 0x100fe2000001084dULL,
0x0000001f0a00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2a367823ULL, 0x000fe2000001084dULL,
0x000000454200720bULL, 0x000fe20003f3e000ULL, 0x0000003a003a7308ULL, 0x000fe20000000800ULL,
0x0000000a1f0b7208ULL, 0x000fc40004000000ULL, 0x0000004245427208ULL, 0x000fe40004800000ULL,
0x0000001a0b00720bULL, 0x000fc60003f1e000ULL, 0x0c401f00424b7f89ULL, 0x000ea200000e0000ULL,
0x0000000b1a0a7208ULL, 0x000fe20004000000ULL, 0x0000003b003b7308ULL, 0x000fe60000000800ULL,
0x0000001b0a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a1b0b7208ULL, 0x000fe20004000000ULL,
0x0000004300437308ULL, 0x000fe60000000800ULL, 0x000000160b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b160a7208ULL, 0x000fe20004000000ULL, 0x0000005400547308ULL, 0x000fe60000000800ULL,
0x000000170a00720bULL, 0x000fe40003f1e000ULL, 0x0000004b4200720bULL, 0x004fe40003f3e000ULL,
0x0000000a170b7208ULL, 0x000fe20004000000ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x000000424b427208ULL, 0x000fc40004800000ULL, 0x000000120b00720bULL, 0x000fc60003f1e000ULL,
0x0c201f00424b7f89ULL, 0x000ea200000e0000ULL, 0x0000000b120a7208ULL, 0x000fe20004000000ULL,
0x0000003300337308ULL, 0x000fe60000000800ULL, 0x000000130a00720bULL, 0x000fc80003f1e000ULL,
0x0000000a130b7208ULL, 0x000fe20004000000ULL, 0x0000002e002e7308ULL, 0x000fe60000000800ULL,
0x0000000e0b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b0e0a7208ULL, 0x000fe20004000000ULL,
0x0000002f002f7308ULL, 0x000fe60000000800ULL, 0x0000000f0a00720bULL, 0x000fe40003f1e000ULL,
0x0000004b4200720bULL, 0x004fe40003f3e000ULL, 0x0000000a0f0b7208ULL, 0x000fe20004000000ULL,
0x0000002900297308ULL, 0x000ea20000000800ULL, 0x000000424b0a7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b27427823ULL, 0x000fe2000001084dULL, 0x000000400b00720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b0a277820ULL, 0x000fe20000410000ULL, 0x0000000b400b7208ULL, 0x000fe20004000000ULL,
0x0000003600367308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b104b7823ULL, 0x100fe20000010827ULL,
0x000000480b00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b49497823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010827ULL,
0x0000000b480b7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010827ULL, 0x00000049002a7308ULL, 0x0007e20000000800ULL,
0x000000460b00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b11587823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b0c4d7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010827ULL,
0x0000000b46267208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010827ULL, 0x0000002100517308ULL, 0x000fe20000000800ULL,
0x000000472600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b0d5a7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b06497823ULL, 0x108fe20000010827ULL, 0x3fb8aa3b20567823ULL, 0x100fe20000010827ULL,
0x0000002647267208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b45457823ULL, 0x000fe20000010827ULL, 0x0000001400557308ULL, 0x0007e20000000800ULL,
0x3c003c00ff067424ULL, 0x000fe200078e00ffULL, 0x0c401f00260b7f89ULL, 0x000f6200000e0000ULL,
0x000000282928723eULL, 0x004fca00000000ffULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x000000074c14723eULL, 0x008fe200000000ffULL, 0x3c003c00ff077424ULL, 0x000fcc00078e00ffULL,
0x0000001d001d7308ULL, 0x000eb00000000800ULL, 0x0000001500607308ULL, 0x0007e20000000800ULL,
0x0000000b2600720bULL, 0x022fc80003f1e000ULL, 0x000000260b0b7208ULL, 0x000fc60004000000ULL,
0x0000001800537308ULL, 0x0003e20000000800ULL, 0x000000242515723eULL, 0x008fe200000000ffULL,
0x0c201f000b107f89ULL, 0x000eec00000e0000ULL, 0x00000019005e7308ULL, 0x000aa20000000800ULL,
0x000000383918723eULL, 0x002fce00000000ffULL, 0x0000004b004b7308ULL, 0x000fe20000000800ULL,
0x0000003a3b19723eULL, 0x020fce00000000ffULL, 0x0000005800587308ULL, 0x000fe20000000800ULL,
0x000000100b00720bULL, 0x008fc80003f1e000ULL, 0x0000000b100b7208ULL, 0x000fc60004000000ULL,
0x0000004d004d7308ULL, 0x000fe20000000800ULL, 0x0000000304ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b0b4f7820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001084fULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001084fULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001084fULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001084fULL, 0x3fb8aa3b174c7823ULL, 0x100fe2000001084fULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe2000001084fULL, 0x0000002200117308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe2000001084fULL, 0x3fb8aa3b16107823ULL, 0x100fe2000001084fULL,
0x0000003c4116723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b12247823ULL, 0x100fe2000001084fULL,
0x0000003e3f17723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe2000001084fULL,
0x0000001c1d12723eULL, 0x004fe200000000ffULL, 0x00000023000c7308ULL, 0x0002a20000000800ULL,
0x000000535e1c723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b0f0f7823ULL, 0x000fe2000001084fULL,
0x00000003ff417819ULL, 0x000fe20000011604ULL, 0x00000010503e7836ULL, 0x000fc40000000000ULL,
0x3fb8aa3b40407823ULL, 0x100fe2000001084fULL, 0x00000018503f7836ULL, 0x000fe40000000000ULL,
0x3fb8aa3b48487823ULL, 0x100fe2000001084fULL, 0x0000001e001e7308ULL, 0x000fe20000000800ULL,
0x000000061420723cULL, 0x002fe200000018ffULL, 0x000000083f537824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b46467823ULL, 0x100fe2000001084fULL, 0x3fb8aa3b47477823ULL, 0x000fe2000001084fULL,
0x000000110c11723eULL, 0x004fc400000000ffULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x00000004040c7810ULL, 0x000fc80007ffe041ULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001a000d7308ULL, 0x0003f00000000800ULL, 0x0000001b00267308ULL, 0x0004e20000000800ULL,
0x0000003d4e1a723eULL, 0x002fe200000000ffULL, 0x00000008503d7836ULL, 0x000fcc0000000000ULL,
0x0000001000277308ULL, 0x0003e20000000800ULL, 0x00000043541b723eULL, 0x004fe200000000ffULL,
0x000000083d437824ULL, 0x000fe200078e00ffULL, 0xfffffff853547812ULL, 0x000fe400078ee20cULL,
0x0000000d261d723eULL, 0x008fc600000000ffULL, 0x0000004c004c7308ULL, 0x000ea20000000800ULL,
0x0000002a5110723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b132a7823ULL, 0x000fe2000001084fULL,
0x0000001e1f13723eULL, 0x000fe200000000ffULL, 0x000000061820723cULL, 0x000fe20000001820ULL,
0x00000055601e723eULL, 0x000fe200000000ffULL, 0x00000008500d7824ULL, 0x000fe400078e00ffULL,
0x0000002400387308ULL, 0x0003e20000000800ULL, 0x000000083e517824ULL, 0x000fe400078e00ffULL,
0xfffffff80d3c7812ULL, 0x000fc400078ee20cULL, 0x00000032330d723eULL, 0x000fe400000000ffULL,
0x000000274c1f723eULL, 0x004fe200000000ffULL, 0x0000005a005a7308ULL, 0x000fe20000000800ULL,
0x000000061024723cULL, 0x002fe200000018ffULL, 0xfffffff8434c7812ULL, 0x000fe400078ee20cULL,
0xfffffff8514e7812ULL, 0x000fe400078ee20cULL, 0x00000030310c723eULL, 0x000fe200000000ffULL,
0x000000083d307824ULL, 0x000fe200078e00ffULL, 0x0000002a00397308ULL, 0x0002b00000000800ULL,
0x0000000e003a7308ULL, 0x0007e20000000800ULL, 0x0000002c2d2a723eULL, 0x002fc400000000ffULL,
0x0000004b582c723eULL, 0x000fe400000000ffULL, 0x00000038392d723eULL, 0x004fc600000000ffULL,
0x0000000f003b7308ULL, 0x0002a20000000800ULL, 0x000000061c24723cULL, 0x000fe20000001824ULL,
0x00000034350e723eULL, 0x008fe200000000ffULL, 0x000000ffff387224ULL, 0x000fe200078e0014ULL,
0x0000000341357812ULL, 0x000fe200078ec0ffULL, 0x000000ffff397224ULL, 0x000fe400078e0016ULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0x0000002b002b7308ULL, 0x000ee20000000800ULL,
0x0000002e2f0f723eULL, 0x002fe200000000ffULL, 0x0000000135357824ULL, 0x000fe200078e0204ULL,
0x0000004d5a2e723eULL, 0x000fe200000000ffULL, 0x000000ffff157224ULL, 0x000fc400078e0017ULL,
0x000000ffff167224ULL, 0x000fe200078e0019ULL, 0x0000003a3b2f723eULL, 0x004fe200000000ffULL,
0x000000060c20723cULL, 0x000fe20000001820ULL, 0x0000003700377308ULL, 0x000fe20000000800ULL,
0x0000000735357812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3a7224ULL, 0x000fe400078e0018ULL,
0x000000ffff3b7224ULL, 0x000fe200078e001aULL, 0x000000362b29723eULL, 0x008fe200000000ffULL,
0x0000000850367824ULL, 0x000fe400078e00ffULL, 0x0000004200427308ULL, 0x000e620000000800ULL,
0x000000062c24723cULL, 0x000fe20000001824ULL, 0x000000ffff177224ULL, 0x000fe200078e001bULL,
0xfffffff836367812ULL, 0x000fe200078ee235ULL, 0x000000ffff187224ULL, 0x000fc400078e0010ULL,
0x000000ffff197224ULL, 0x000fe400078e0012ULL, 0x0000004900497308ULL, 0x000fe20000000800ULL,
0x000000ffff1a7224ULL, 0x000fe400078e001cULL, 0x000000ffff1b7224ULL, 0x000fe400078e001eULL,
0x000000ffff107224ULL, 0x000fe200078e0011ULL, 0x00000037422b723eULL, 0x002fe400000000ffULL,
0x0000005600567308ULL, 0x000e620000000800ULL, 0x000000083e427824ULL, 0x000fe200078e00ffULL,
0xfffffff8303e7812ULL, 0x000fe200078ee235ULL, 0x000000ffff117224ULL, 0x000fe200078e0013ULL,
0x0000000863377c11ULL, 0x000fe2000f8e60ffULL, 0x000000ffff127224ULL, 0x000fe200078e001dULL,
0x000000062820723cULL, 0x000fe20000001820ULL, 0xfffffff842427812ULL, 0x000fe200078ee235ULL,
0x0000004400447308ULL, 0x000fe20000000800ULL, 0x0001200037377836ULL, 0x000fc40000000000ULL,
0x000000ffff137224ULL, 0x000fe400078e001fULL, 0x000000103c3c7824ULL, 0x100fe200078e0237ULL,
0x000000495630723eULL, 0x002fe400000000ffULL, 0x0000004500457308ULL, 0x000e620000000800ULL,
0x000000104c4c7824ULL, 0x100fe400078e0237ULL, 0x000000104e4e7824ULL, 0x100fe400078e0237ULL,
0x0000001054547824ULL, 0x000fc400078e0237ULL, 0x000000103e3e7824ULL, 0x100fe200078e0237ULL,
0x0000004000407308ULL, 0x000fe20000000800ULL, 0x0000001042427824ULL, 0x100fe400078e0237ULL,
0x0000001036217824ULL, 0x000fe400078e0237ULL, 0x000000ffff367224ULL, 0x000fe200078e0028ULL,
0x000000444532723eULL, 0x002fe400000000ffULL, 0x0000004800317308ULL, 0x000e620000000800ULL,
0x0000003821007844ULL, 0x0005e20000000200ULL, 0x000000ffff287224ULL, 0x000fc400078e002cULL,
0x000000ffff1c7224ULL, 0x000fe400078e002dULL, 0x000000ffff1d7224ULL, 0x000fe400078e002fULL,
0x0000004600337308ULL, 0x0007e20000000800ULL, 0x000000403131723eULL, 0x002fce00000000ffULL,
0x0000004700347308ULL, 0x000e620000000800ULL, 0x000000083f467824ULL, 0x008fe400078e00ffULL,
0x000000ffff217224ULL, 0x004fe400078e0022ULL, 0x000000ffff1e7224ULL, 0x000fe200078e0031ULL,
0xfffffff846467812ULL, 0x000fe200078ee235ULL, 0x000000ffff357224ULL, 0x000fe400078e000eULL,
0x000000ffff0e7224ULL, 0x000fe400078e0029ULL, 0x0000001046467824ULL, 0x000fc400078e0237ULL,
0x000000ffff377224ULL, 0x000fe200078e002aULL, 0x000000333433723eULL, 0x002fe200000000ffULL,
0x000000ffff347224ULL, 0x000fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff0d7224ULL, 0x000fe200078e000fULL, 0x000000343c007844ULL, 0x000fe20000000200ULL,
0x000000063024723cULL, 0x000fe20000001824ULL, 0x000000ffff0f7224ULL, 0x000fe400078e002bULL,
0x000000ffff297224ULL, 0x000fe200078e002eULL, 0x000000143e007844ULL, 0x000fe40000000200ULL,
0x000000ffff2a7224ULL, 0x000fc400078e0030ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0032ULL,
0x0000000c4c007844ULL, 0x0003e20000000200ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0033ULL,
0x00000001ff067424ULL, 0x000fe200078e00ffULL, 0x0000001842007844ULL, 0x0005e80000000200ULL,
0x000000284e007844ULL, 0x0005e80000000200ULL, 0x0000001046007844ULL, 0x0005e60000000200ULL,
0x000000ffff227224ULL, 0x000fe200078e0024ULL, 0x0000001c54007844ULL, 0x0005e20000000200ULL,
0x000000ffff237224ULL, 0x000fc400078e0026ULL, 0x000000ffff0c7224ULL, 0x002fe200078e005cULL,
0x01a000084a008388ULL, 0x0005e80000000c00ULL, 0x01a200204a008388ULL, 0x0005e20000000c00ULL,
0x000000627a00720cULL, 0x000fe20003f06070ULL, 0x01a6080679ff79a7ULL, 0x0005e2000850003fULL,
0x01a6100679ff79a7ULL, 0x0005e2000850003fULL, 0x01a6180679ff79a7ULL, 0x0005e2000850003fULL,
0x01a6200679ff79a7ULL, 0x0005f2000850003fULL, 0xffffff9000508947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000082007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000008200008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff82ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000082027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000008200007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffe8802bc7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004e3ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000660ULL, 0x0000000000000228ULL,
0x0000001500000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000888ULL, 0x00000000000000e0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000968ULL, 0x0000000000000054ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000009bcULL, 0x0000000000000710ULL,
0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010d0ULL, 0x0000000000000000ULL,
0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010d0ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001118ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000017600ULL,
0x0000001500000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000018780ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x00000000000187c0ULL, 0x0000000000000400ULL,
0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000187c0ULL, 0x0000000000000278ULL,
0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000018db8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000018db8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001118ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000017600ULL, 0x0000000000017600ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000018780ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000187c0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000278ULL, 0x0000000000000278ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_32_sm_90_cubin_len = 102152;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
