/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_32_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000019c40ULL, 0x00000000000198c0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x746e695f5f240068ULL,
0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL, 0x66625f636e79736cULL,
0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL, 0x5f30376d735f6164ULL,
0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL, 0x5f5f245f335f6c61ULL,
0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL, 0x2e616c65722e0074ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x766e2e0066754265ULL,
0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL, 0x65642e006d617261ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x00000000006e6f69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c000100000377ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000003c5ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000040bULL, 0x0000000000017ce0ULL,
0x0000000000000180ULL, 0x000b00220000043eULL, 0x0000000000017e60ULL, 0x0000000000000040ULL,
0x000b002200000469ULL, 0x0000000000017ea0ULL, 0x0000000000000050ULL, 0x000b002200000493ULL,
0x0000000000017ef0ULL, 0x0000000000000110ULL, 0x000a000300000501ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0007000300000551ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000018000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00017ce000000000ULL,
0x0000040400000000ULL, 0x810c000001880400ULL, 0x005da40400288080ULL, 0x0000000000000000ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x00017ce000000000ULL,
0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080830828ULL, 0x2880808d08288080ULL,
0x8094082880809308ULL, 0x0828808095082880ULL, 0x8080970828808096ULL, 0x9f082880809c0828ULL,
0x288080a508288080ULL, 0x80ec08288080a708ULL, 0x08288080f0082880ULL, 0x8080f208288080f1ULL,
0x8016288080880828ULL, 0x0000000310288082ULL, 0x8088920000000000ULL, 0x0000000022002880ULL,
0x0000001cffffffffULL, 0x000000f000000000ULL, 0x00017e6000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8d08288080830828ULL,
0x2880809308288080ULL, 0x8095082880809408ULL, 0x0828808096082880ULL, 0x80809c0828808097ULL,
0xa6082880809f0828ULL, 0x288080a708288080ULL, 0x80f008288080ec08ULL, 0x08288080f1082880ULL,
0x8080a508288080f2ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080a592ULL,
0x0000002cffffffffULL, 0x000001b800000000ULL, 0x00017ea000000000ULL, 0x0000005000000000ULL,
0x0000040400000000ULL, 0x80ec288080a50900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8d08288080830828ULL, 0x2880809308288080ULL, 0x8095082880809408ULL,
0x0828808096082880ULL, 0x80809c0828808097ULL, 0xa5082880809f0828ULL, 0x288080a708288080ULL,
0x80f008288080ec08ULL, 0x08288080f1082880ULL, 0x8080a608288080f2ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080a692ULL, 0x0000001cffffffffULL, 0x0000028800000000ULL,
0x00017ef000000000ULL, 0x0000011000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL,
0x00082304000000e2ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL,
0x0000001900081204ULL, 0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL,
0x0000001600080a04ULL, 0x0068190300680160ULL, 0x00000000000c1704ULL, 0x0021f0000060000aULL,
0x00000000000c1704ULL, 0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0011f00000500008ULL,
0x00000000000c1704ULL, 0x0081f00000300007ULL, 0x00000000000c1704ULL, 0x0021f00000280006ULL,
0x00000000000c1704ULL, 0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL,
0x00000000000c1704ULL, 0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL,
0x00000000000c1704ULL, 0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400ff1b03ULL, 0x019c290400000eb0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x019c2804ffffffffULL, 0x0000032000000150ULL, 0x00002ce0000005a0ULL,
0x00002ea000002d90ULL, 0x0000318000003010ULL, 0x00003730000032e0ULL, 0x0000378000003770ULL,
0x000059c0000037b0ULL, 0x00005b7000005a50ULL, 0x00005e5000005ce0ULL, 0x0000643000005fb0ULL,
0x0000648000006470ULL, 0x000084a0000064b0ULL, 0x0000866000008540ULL, 0x00008940000087d0ULL,
0x00008f2000008aa0ULL, 0x00008f7000008f60ULL, 0x0000b08000008fa0ULL, 0x0000b2300000b120ULL,
0x0000b5100000b3a0ULL, 0x0000baf00000b670ULL, 0x0000bb400000bb30ULL, 0x0000cfe00000bb70ULL,
0x0000d0000000cff0ULL, 0x00015a200000d010ULL, 0x00015a7000015a60ULL, 0x00015ad000015a80ULL,
0x00015b1000015af0ULL, 0x00016e6000015b20ULL, 0x00016f0000016eb0ULL, 0x00016f8000016f40ULL,
0x0001701000016fc0ULL, 0x000170b000017060ULL, 0x0001715000017100ULL, 0x000171f0000171a0ULL,
0x0001727000017230ULL, 0x00017300000172b0ULL, 0x000173a000017350ULL, 0x00017440000173f0ULL,
0x000174e000017490ULL, 0x0001756000017520ULL, 0x000175f0000175a0ULL, 0x0001769000017640ULL,
0x00017730000176e0ULL, 0x000177d000017780ULL, 0x0001785000017810ULL, 0x000178e000017890ULL,
0x0001798000017930ULL, 0x00017a20000179d0ULL, 0x00017ae000017a80ULL, 0x00017ba000017b40ULL,
0x00017c6000017c00ULL, 0x0440390400017cc0ULL, 0x000000ff00000410ULL, 0x003f010000012600ULL,
0x0000000f00000450ULL, 0x003f012000012608ULL, 0x0000000f000004e0ULL, 0x003f012000012688ULL,
0x0000000f00000510ULL, 0x003f0120000126a8ULL, 0x0000000f00000530ULL, 0x003f0120000126c8ULL,
0x000000ff00000ec0ULL, 0x003f010700012600ULL, 0x00000003000010c0ULL, 0x003f010200000004ULL,
0x0000000300001170ULL, 0x003f010100000000ULL, 0x000000ff00001b60ULL, 0x0004010700000000ULL,
0x000000ff00001be0ULL, 0x0004010100000000ULL, 0x0000000200001c40ULL, 0x003f0101000126c8ULL,
0x0000001900001dc0ULL, 0x003f0105000126ccULL, 0x0000001900001fb0ULL, 0x003f0105000126ccULL,
0x00000019000028d0ULL, 0x003f0107000126b0ULL, 0x0000001900002980ULL, 0x003f0101000126b0ULL,
0x00000003000029e0ULL, 0x003f010100012608ULL, 0x0000000300002a00ULL, 0x003f01050001260cULL,
0x0000000300002bd0ULL, 0x003f01050001260cULL, 0x0000001900003490ULL, 0x003f0105000126acULL,
0x0000001900003660ULL, 0x003f0105000126acULL, 0x0000006c00004b60ULL, 0x003f010100000000ULL,
0x0000002500004bc0ULL, 0x003f010100012688ULL, 0x0000000400004be0ULL, 0x003f010500000004ULL,
0x0000000400004db0ULL, 0x003f010500000004ULL, 0x000000ff00005620ULL, 0x00040107000126a8ULL,
0x000000ff000056a0ULL, 0x00040101000126a8ULL, 0x0000000300005700ULL, 0x003f010100012628ULL,
0x0000000300005720ULL, 0x003f01050001262cULL, 0x00000003000058f0ULL, 0x003f01050001262cULL,
0x0000006c000061a0ULL, 0x003f0105000126b4ULL, 0x0000006c00006370ULL, 0x003f0105000126b4ULL,
0x0000006e00007630ULL, 0x003f010100000000ULL, 0x0000002500007690ULL, 0x003f010100012690ULL,
0x00000004000076b0ULL, 0x003f010500000004ULL, 0x0000000400007880ULL, 0x003f010500000004ULL,
0x00000025000080b0ULL, 0x003f0107000126b0ULL, 0x0000002500008180ULL, 0x003f0101000126b0ULL,
0x00000003000081e0ULL, 0x003f010100012648ULL, 0x0000000300008200ULL, 0x003f01050001264cULL,
0x00000003000083d0ULL, 0x003f01050001264cULL, 0x0000007000008c90ULL, 0x003f0105000126acULL,
0x0000007000008e60ULL, 0x003f0105000126acULL, 0x0000001c0000a120ULL, 0x003f010100000000ULL,
0x000000180000a180ULL, 0x003f010100012698ULL, 0x0000001c0000a1a0ULL, 0x003f010500000004ULL,
0x0000001c0000a3a0ULL, 0x003f010500000004ULL, 0x000000200000ace0ULL, 0x003f0107000126a8ULL,
0x000000200000ad70ULL, 0x003f0101000126a8ULL, 0x000000050000add0ULL, 0x003f010100012668ULL,
0x000000050000ae00ULL, 0x003f01050001266cULL, 0x000000050000afd0ULL, 0x003f01050001266cULL,
0x000000230000b850ULL, 0x003f0105000126b4ULL, 0x000000230000ba20ULL, 0x003f0105000126b4ULL,
0x000000040000cd90ULL, 0x003f010100000000ULL, 0x000000020000ce10ULL, 0x003f010100000000ULL,
0x000000ff0000f020ULL, 0x003f010100012600ULL, 0x000000ff0000fc50ULL, 0x003f010500012604ULL,
0x000000ff0000fe60ULL, 0x003f010500012604ULL, 0x000000ff000101e0ULL, 0x003f010100012600ULL,
0x000000ff00010210ULL, 0x003f010500012604ULL, 0x000000ff000103d0ULL, 0x003f010500012604ULL,
0x0000006500012c60ULL, 0x003f010100000000ULL, 0x0000006500012d80ULL, 0x003f010500000004ULL,
0x0000006500012f50ULL, 0x003f010500000004ULL, 0x0000006200016cc0ULL, 0x003f010100000000ULL,
0x0000006200016d20ULL, 0x003f010100000008ULL, 0x0000006200016d80ULL, 0x003f010100000010ULL,
0x0000006200016df0ULL, 0x003f010100000018ULL, 0x00301c0400053803ULL, 0x0000df400000df10ULL,
0x0000e3d00000e1e0ULL, 0x0000e7b00000e5c0ULL, 0x0000eb900000e9a0ULL, 0x0000ef400000ed90ULL,
0x00016e3000010430ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000334ULL,
0x0000001900000002ULL, 0x0000000000000264ULL, 0x0000001900000002ULL, 0x00000000000001a4ULL,
0x0000001900000002ULL, 0x00000000000000ccULL, 0x0000001900000002ULL, 0x0000000000000044ULL,
0x0000001900000002ULL, 0x0000000000000310ULL, 0x0000001900000002ULL, 0x0000000000000240ULL,
0x0000001900000002ULL, 0x000000000000017dULL, 0x0000001900000002ULL, 0x00000000000000a8ULL,
0x0000001900000002ULL, 0x0000000000012700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000047919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff030424ULL, 0x000fe200078e00ffULL,
0x0000000104060810ULL, 0x002fca0007ffe0ffULL, 0x00005c0006060625ULL, 0x000fc800078e0003ULL,
0x00005c0004020625ULL, 0x000fe200078e0003ULL, 0x0000000606000981ULL, 0x0002aa000c1e1900ULL,
0x0000000602030981ULL, 0x0006a2000c1e1900ULL, 0x0000590000057b06ULL, 0x000f220000209000ULL,
0x00005900ff157624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000107919ULL, 0x000e680000002600ULL, 0x0000000000147919ULL, 0x000e680000002300ULL,
0x00000000000a7919ULL, 0x000e620000002100ULL, 0x0000000500057308ULL, 0x010f240000001000ULL,
0x0ffffffe05087810ULL, 0x010fc40007ffe0ffULL, 0x00000005ff117819ULL, 0x002fc8000001160aULL,
0x0000000800097305ULL, 0x000324000021f000ULL, 0x00001fff11117589ULL, 0x000fe200000e0000ULL,
0x000000ffff087224ULL, 0x002fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x010fc800078e0a09ULL,
0x000059000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b09097227ULL, 0x000fcc00078e0008ULL,
0x00000400090b7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff027224ULL, 0x008fc800078e0a0bULL,
0x0000040002027624ULL, 0x000fca00078e0215ULL, 0x0000590002007a0cULL, 0x000fda0003f26070ULL,
0x8000590002021a10ULL, 0x000fe40007ffe0ffULL, 0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL,
0x0000590002007a0cULL, 0x000fda0003f46070ULL, 0x000000010b0b2810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff0bba12ULL, 0x000fc800078e33ffULL, 0x0000000b00027306ULL, 0x000e620000209000ULL,
0x000000ff0b00720cULL, 0x000fce0003f85070ULL, 0x0000000200027308ULL, 0x002e640000001000ULL,
0x0ffffffe02067810ULL, 0x002fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x0002e4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000070b057224ULL, 0x008fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a05ULL, 0x0000000507077227ULL, 0x000fe400078e0006ULL,
0x0000000000057919ULL, 0x000e680000002200ULL, 0x0000001007127227ULL, 0x000fc800078e00ffULL,
0x000000ffff027224ULL, 0x000fc800078e0a12ULL, 0x000000020b027224ULL, 0x000fca00078e0210ULL,
0x0000000b0200720cULL, 0x000fe20003fa6070ULL, 0x0000010014057a24ULL, 0x002fe400078e0205ULL,
0x00001fff14147589ULL, 0x000e6400000e0000ULL, 0x00000000050f7a24ULL, 0x000fd000078e020aULL,
0x0000000102025824ULL, 0x000fe200078e0a0bULL, 0x0000000112125810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0f00720cULL, 0x040fe40003f65270ULL, 0x0000000b0200720cULL, 0x000fe40003fc6070ULL,
0x0000000f0f00780cULL, 0x040fe40003f24070ULL, 0x0000007f0f00780cULL, 0x040fe40003f44070ULL,
0x000000030f00780cULL, 0x000fca0003fa4070ULL, 0x3fffff80ff06b424ULL, 0x000fe400078e00ffULL,
0x0000000112126810ULL, 0x000fe20007ffe0ffULL, 0x7fffff80ff07b424ULL, 0x000fe200078e00ffULL,
0x0000000bff12c212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff089424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff099424ULL, 0x000fe200078e00ffULL, 0x01260006ff00b388ULL, 0x0007e20000000a00ULL,
0x000000ffff027224ULL, 0x000fe200078e0a12ULL, 0x000000010f00780cULL, 0x000fe20003f64070ULL,
0xff317217ff0ea424ULL, 0x000fe200078e00ffULL, 0x012608080f009388ULL, 0x000fe20000008a00ULL,
0x000000020b107224ULL, 0x000fc400078e0210ULL, 0x3fffff80ff0ad424ULL, 0x000fe200078e00ffULL,
0x0124000e0f00a388ULL, 0x0009e20000004800ULL, 0x0000002010107824ULL, 0x000fe400078e00ffULL,
0x3fffff60ff06d424ULL, 0x008fe400078e00ffULL, 0x7fffff60ff07d424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0bd424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL,
0x012688060f00d388ULL, 0x000fe20000008a00ULL, 0x00005a00ff0e7624ULL, 0x010fc400078e00ffULL,
0x7fffffc0ff0db424ULL, 0x000fe200078e00ffULL, 0x0126a80a0f00d388ULL, 0x000fe20000008a00ULL,
0x000059000e0e7a24ULL, 0x000fc600078e02ffULL, 0x0126c80c0f00b388ULL, 0x000fe20000008a00ULL,
0x0000000100130824ULL, 0x004fe400078e0a03ULL, 0x00005800ff138624ULL, 0x000fe400078e00ffULL,
0x0000580004038a24ULL, 0x000fe400078e02ffULL, 0x00005a0013057a24ULL, 0x000fe400078e02ffULL,
0x0000000e037b7224ULL, 0x000fe400078e02ffULL, 0x0000000105007824ULL, 0x040fe200078e0a10ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000100500720cULL, 0x000fe20003f26070ULL,
0x00005a0012197a24ULL, 0x000fe200078e027bULL, 0x0000002000007817ULL, 0x000fc80003800000ULL,
0x000000ff007a7207ULL, 0x000fe20000800000ULL, 0x0000000414007824ULL, 0x002fc600078e0211ULL,
0x000000207a00780cULL, 0x000fe20003f05270ULL, 0x0000000400007824ULL, 0x000fd800078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00005a0000057b06ULL, 0x000e620000209000ULL,
0x00000000000f7919ULL, 0x000ea20000000000ULL, 0x000000ffff067224ULL, 0x000fcc00078e00ffULL,
0x0000000500057308ULL, 0x002e620000001000ULL, 0x00000004ff027819ULL, 0x004fc8000001160fULL,
0x0000000202097810ULL, 0x000fe20007ffe0ffULL, 0x00000001000a7824ULL, 0x000fe200078e0202ULL,
0x0ffffffe05077810ULL, 0x002fc60007ffe0ffULL, 0x00000001000b7824ULL, 0x000fc600078e0209ULL,
0x0000000700077305ULL, 0x000e62000021f000ULL, 0x00000001100c7824ULL, 0x000fe400078e020bULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a07ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d07057227ULL, 0x000fc800078e0006ULL, 0x0000000110067824ULL, 0x000fe400078e020aULL,
0x0000000c050d7227ULL, 0x000fc800078e00ffULL, 0x0000000605077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a07ULL, 0x000000ffff177224ULL, 0x000fe400078e0a0dULL,
0x00005a0005057a24ULL, 0x000fe400078e0206ULL, 0x00005a0017087a24ULL, 0x000fc600078e020cULL,
0x00005a0005007a0cULL, 0x000fe40003f06070ULL, 0x00005a0008007a0cULL, 0x000fd60003f46070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0008082a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x00005a0008007a0cULL, 0x000fe40003f66070ULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d2810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff087a12ULL, 0x000fe400078e33ffULL,
0x000000007a057217ULL, 0x000fe40007800000ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x000000010d0d3810ULL, 0x000fe20007ffe0ffULL, 0x0000000105057824ULL, 0x000fe200078e0a00ULL,
0x0000000708077207ULL, 0x000fe20004000000ULL, 0x000000010a007824ULL, 0x000fe200078e020fULL,
0x0000000d08087207ULL, 0x000fc40004000000ULL, 0x000000050200720cULL, 0x080fe20003f06070ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0a07ULL, 0x000000050900720cULL, 0x000fe20003f26070ULL,
0x000000ffff177224ULL, 0x000fe400078e0a08ULL, 0x00005a000d067a24ULL, 0x000fe400078e0206ULL,
0x00005a00170c7a24ULL, 0x000fe400078e020cULL, 0x0000000119067824ULL, 0x040fe400078e0206ULL,
0x00000001190d7824ULL, 0x000fc400078e020cULL, 0x0000000e07067224ULL, 0x080fe400078e0206ULL,
0x000000100f027824ULL, 0x000fe400078e00ffULL, 0x0000000e08087224ULL, 0x000fe400078e020dULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x000000f002057812ULL, 0x000fc600078ec0ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x0000000506067212ULL, 0x000fc600078efcffULL,
0x000000100a0d7824ULL, 0x000fe200078e00ffULL, 0x0000000508057212ULL, 0x000fe200078efcffULL,
0x000000010b0a7824ULL, 0x040fe200078e020fULL, 0x0000600006067a10ULL, 0x000fe20007f5e0ffULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff00d007812ULL, 0x000fe400078ee200ULL,
0x0000600005087a10ULL, 0x000fe40007f7e0ffULL, 0xfffffff00b0a7812ULL, 0x000fe200078ee20aULL,
0x0000001000057824ULL, 0x000fe200078e00ffULL, 0x0000610007077a10ULL, 0x000fc400017fe4ffULL,
0x0000610009097a10ULL, 0x000fe20001ffe4ffULL, 0x000000100a0b7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e8000c101c46ULL,
0x00000000080b7faeULL, 0x0003e2000c901c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x00005a0000027b06ULL, 0x000e620000209000ULL, 0x00000000000f7919ULL, 0x000eae0000000000ULL,
0x0000000200027308ULL, 0x002e620000001000ULL, 0x000000000f007211ULL, 0x004fc800078fe0ffULL,
0x00000002000a7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffe02067810ULL, 0x002fe20007ffe0ffULL,
0x0000000110027824ULL, 0x000fc600078e0200ULL, 0x0000000600077305ULL, 0x0002a4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fc800078e02ffULL, 0x0000000507087227ULL, 0x000fc800078e0006ULL,
0x0000000110077824ULL, 0x000fe400078e020aULL, 0x0000000208057227ULL, 0x000fc800078e00ffULL,
0x0000000708087227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fe400078e0a05ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x00005a0009067a24ULL, 0x000fe400078e0202ULL,
0x00005a000c097a24ULL, 0x000fe400078e0207ULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x00005a0006007a0cULL, 0x000fe40003f06070ULL, 0x00005a0009007a0cULL, 0x000fd60003f46070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0009092a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f26070ULL, 0x00005a0009007a0cULL, 0x000fe40003f66070ULL,
0x0000000105050810ULL, 0x000fe40007ffe0ffULL, 0x0000000108082810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff067a12ULL, 0x000fc600078e33ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x0000000108083810ULL, 0x000fe40007ffe0ffULL,
0x0000000506057207ULL, 0x040fe40004000000ULL, 0x0000000806087207ULL, 0x000fc60004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a05ULL, 0x000000ffff067224ULL, 0x000fe400078e0a08ULL,
0x00005a0009027a24ULL, 0x000fe400078e0202ULL, 0x00005a0006077a24ULL, 0x000fe400078e0207ULL,
0x0000000119067824ULL, 0x040fe400078e0202ULL, 0x0000000119077824ULL, 0x000fc400078e0207ULL,
0x000000100f027824ULL, 0x000fe400078e00ffULL, 0x0000000e05067224ULL, 0x080fe400078e0206ULL,
0x0000000e08087224ULL, 0x000fe200078e0207ULL, 0x000000f0020b7812ULL, 0x000fe200078ec0ffULL,
0x0000010006067825ULL, 0x000fc800078e00ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000b06067212ULL, 0x000fc600078efcffULL, 0x0000000100057824ULL, 0x100fe200078e020fULL,
0x0000000b08087212ULL, 0x000fe200078efcffULL, 0x000000010a007824ULL, 0x000fe200078e020fULL,
0x0000600006067a10ULL, 0x000fe20007f1e0ffULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff00c057812ULL, 0x000fe400078ee205ULL, 0x0000600008087a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00b007812ULL, 0x000fe200078ee200ULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x0000610007077a10ULL, 0x000fc400007fe4ffULL, 0x0000610009097a10ULL, 0x000fe20000ffe4ffULL,
0x00000010000b7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e8000b901c46ULL, 0x00000000080b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000067919ULL, 0x002e620000000000ULL, 0x0000000000007806ULL, 0x000fc600038e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000057300ULL, 0x000e7000000e0000ULL,
0x0000000000077309ULL, 0x000ea20000000000ULL, 0x000000060500720cULL, 0x002fe20003f02070ULL,
0x00000004ff057424ULL, 0x000fc400078e00ffULL, 0x000000ffff087224ULL, 0x004fe400078e0a07ULL,
0x0000680004067625ULL, 0x000fd000078e0005ULL, 0x01260408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01260000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006060e7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff1400720cULL, 0x000fe40003f05270ULL,
0x0000003f0e0d7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff0e007810ULL, 0x000fc40007ffe0ffULL,
0x00000006ff0d7819ULL, 0x000fe4000001160dULL, 0x00000008ff0c7819ULL, 0x000fca0000011600ULL,
0x0000df4000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0b7819ULL, 0x000fe20000011611ULL,
0x00000003ff0a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff097424ULL, 0x000fe200078e00ffULL,
0x03ffffff0b087812ULL, 0x002fc800078ec0ffULL, 0x0000000d0800720cULL, 0x000fda0003f06070ULL,
0x0000000204038824ULL, 0x000fe400078e00ffULL, 0x00006a00ff068624ULL, 0x000fc800078e00ffULL,
0x00006a0003078624ULL, 0x000fe200078e0206ULL, 0x0001268811037811ULL, 0x000fc600078e18ffULL,
0x0000000108068824ULL, 0x000fe200078e0207ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040a03ff738cULL, 0x0003e20000000000ULL, 0x0000660006068625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000606098981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x00000080ff1b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x002fe20000011611ULL, 0x0000000003ff7f8cULL, 0x0003e2000c80043fULL,
0x0000000111007812ULL, 0x000fc600078ec0ffULL, 0x000000200a847824ULL, 0x000fe400078e00ffULL,
0x0000590009137a24ULL, 0x004fe400078e02ffULL, 0x0000004012097824ULL, 0x000fe400078e00ffULL,
0x00000040131a7824ULL, 0x000fc600078e00ffULL, 0x0000002009137812ULL, 0x000fe200078ef884ULL,
0x000064001a1a7625ULL, 0x000fe200078e001bULL, 0x000003e000000947ULL, 0x000fea0003800000ULL,
0x000000840e037217ULL, 0x002fe20007800000ULL, 0x0000001000007824ULL, 0x000fe200078e00ffULL,
0x00000003ff067819ULL, 0x000fc6000001160fULL, 0x0000000103037824ULL, 0x000fe200078e0a84ULL,
0x0000000406157810ULL, 0x000fe20007ffe0ffULL, 0x0000000100147824ULL, 0x000fe200078e0206ULL,
0x0000000c06177810ULL, 0x000fe40007ffe0ffULL, 0x0000000003037217ULL, 0x000fe20007800000ULL,
0x0000000114077824ULL, 0x040fe400078e020fULL, 0x00000008141c7824ULL, 0x000fe400078e00ffULL,
0x0000000103037824ULL, 0x000fc400078e0a00ULL, 0x0000000100187824ULL, 0x000fe200078e0217ULL,
0xfffffff81c1c7812ULL, 0x000fe400078ee207ULL, 0x0000000806077810ULL, 0x040fe40007ffe0ffULL,
0x000000030600720cULL, 0x080fe20003f66070ULL, 0x0000000113067824ULL, 0x000fe200078e0214ULL,
0x000000030700720cULL, 0x080fe20003f26070ULL, 0x0000000100167824ULL, 0x000fe200078e0207ULL,
0x000000031500720cULL, 0x080fe20003f46070ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x000000031700720cULL, 0x000fc60003f06070ULL, 0x0000000100147824ULL, 0x000fe200078e0215ULL,
0x0000007006197812ULL, 0x000fe200078ef802ULL, 0x0000000113177824ULL, 0x040fe400078e0218ULL,
0x0000000118067824ULL, 0x140fe400078e020fULL, 0x0000000818157824ULL, 0x000fe200078e00ffULL,
0x000000191a187210ULL, 0x000fe20007f9e0ffULL, 0x0000000113007824ULL, 0x000fe400078e0214ULL,
0x0000000114037824ULL, 0x040fe200078e020fULL, 0xfffffff815227812ULL, 0x000fe200078ee206ULL,
0x00000008141e7824ULL, 0x000fc400078e00ffULL, 0x0000000113147824ULL, 0x000fe400078e0216ULL,
0x000000011b197824ULL, 0x000fe200020e0607ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee203ULL,
0x0000008000067825ULL, 0x000fe200078e00ffULL, 0x0000e0000a037811ULL, 0x000fc600078e68ffULL,
0x0000000116137824ULL, 0x000fe200078e020fULL, 0x0000007006257812ULL, 0x000fe200078ef802ULL,
0x0000000816207824ULL, 0x000fe400078e00ffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee213ULL, 0x0000008017167825ULL, 0x000fe200078e00ffULL,
0x0000007014237812ULL, 0x000fc600078ef802ULL, 0x000000101c137824ULL, 0x100fe200078e0203ULL,
0x0000007016217812ULL, 0x000fe200078ef802ULL, 0x000000101e1d7824ULL, 0x100fe200078e0203ULL,
0x000000251a027210ULL, 0x000fe20007f9e0ffULL, 0x00000010201f7824ULL, 0x100fe200078e0203ULL,
0x000000231a067210ULL, 0x040fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018137faeULL, 0x0003e2000d901c46ULL, 0x000000211a147210ULL, 0x000fe20007fde0ffULL,
0x0000001022217824ULL, 0x000fe400078e0203ULL, 0x000000011b037824ULL, 0x000fc400020e0607ULL,
0x000000011b077824ULL, 0x040fe400028e0615ULL, 0x000000011b157824ULL, 0x000fe200030e0617ULL,
0x00000000021d7faeULL, 0x0003e8000d101c46ULL, 0x00000000061f7faeULL, 0x0003e8000c901c46ULL,
0x0000000014217faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001000007824ULL, 0x002fe200078e00ffULL, 0x0000e0000a257811ULL, 0x000fc800078e68ffULL,
0x000000000f007211ULL, 0x000fc800078fe8ffULL, 0x0000000c00187810ULL, 0x040fe20007ffe0ffULL,
0x0000000113067824ULL, 0x000fe200078e0200ULL, 0x0000000400147810ULL, 0x040fe20007ffe0ffULL,
0x0000000100037824ULL, 0x000fe400078e020fULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x0000000800167824ULL, 0x000fe200078e00ffULL, 0x0000007006197812ULL, 0x000fe200078ef802ULL,
0x0000000113177824ULL, 0x000fe400078e0218ULL, 0x0000000118067824ULL, 0x000fe200078e020fULL,
0xfffffff816037812ULL, 0x000fe200078ee203ULL, 0x00000008181d7824ULL, 0x000fe200078e00ffULL,
0x0000000800167810ULL, 0x000fe20007ffe0ffULL, 0x0000000114157824ULL, 0x000fe200078e020fULL,
0x000000191a187210ULL, 0x000fe20007f1e0ffULL, 0x00000008141c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d207812ULL, 0x000fe200078ee206ULL, 0x0000000113007824ULL, 0x000fc400078e0214ULL,
0x0000000113147824ULL, 0x000fe200078e0216ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee215ULL,
0x000000011b197824ULL, 0x000fe400000e0607ULL, 0x0000000116137824ULL, 0x040fe400078e020fULL,
0x00000008161e7824ULL, 0x000fe400078e00ffULL, 0x0000008000067825ULL, 0x000fc600078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee213ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000007006237812ULL, 0x000fc600078ef802ULL, 0x0000008017167825ULL, 0x000fe200078e00ffULL,
0x0000007014217812ULL, 0x000fc600078ef802ULL, 0x0000001003137824ULL, 0x100fe200078e0225ULL,
0x0000007016037812ULL, 0x000fe200078ef802ULL, 0x000000101c1d7824ULL, 0x100fe200078e0225ULL,
0x000000231a027210ULL, 0x000fe20007f1e0ffULL, 0x000000101e1f7824ULL, 0x100fe200078e0225ULL,
0x000000211a067210ULL, 0x000fe20007f3e0ffULL, 0x0000001020217824ULL, 0x000fe200078e0225ULL,
0x000000031a147210ULL, 0x000fe20007f5e0ffULL, 0x000000011b037824ULL, 0x040fe200000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018137faeULL, 0x0003e2000b901c46ULL,
0x000000011b077824ULL, 0x000fc400008e0615ULL, 0x000000011b157824ULL, 0x000fe200010e0617ULL,
0x00000000021d7faeULL, 0x0003e8000b901c46ULL, 0x00000000061f7faeULL, 0x0003e8000b901c46ULL,
0x0000000014217faeULL, 0x0003e4000b901c46ULL, 0x0000000108087810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff227424ULL, 0x000fc600078e00ffULL, 0x0000000d0800720cULL, 0x000fda0003f06070ULL,
0x0000006000000947ULL, 0x000fea0003800000ULL, 0x0000000204007824ULL, 0x000fe400078e00ffULL,
0x00006a00ff037624ULL, 0x002fc800078e00ffULL, 0x00006a0000037624ULL, 0x000fc800078e0203ULL,
0x0000000103227824ULL, 0x000fc800078e0208ULL, 0x0000660022227625ULL, 0x000fcc00078e0005ULL,
0x0000000622227981ULL, 0x000324000c1e1900ULL, 0x000000000a0473c2ULL, 0x000ea200000e0000ULL,
0x000000ff0c00720cULL, 0x000fe20003f05270ULL, 0x000000080a027824ULL, 0x002fe200078e00ffULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x0000000000687805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x000126a804047891ULL, 0x004fe2000f8e203fULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3d7224ULL, 0x000fca00078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff187f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126c80002027f8cULL, 0x000ea2000c80043fULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000b16000008947ULL, 0x000fea0003800000ULL, 0x0000000204077824ULL, 0x000fe200078e00ffULL,
0x000000010a797812ULL, 0x000fe200078ec0ffULL, 0x00006a00ff007624ULL, 0x000fc400078e00ffULL,
0x000000ffff187224ULL, 0x002fe400078e0019ULL, 0x000000ffff177224ULL, 0x004fe400078e0003ULL,
0x00006a0007077624ULL, 0x000fe400078e0200ULL, 0xff317217ff1a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff067224ULL, 0x000fe400078e00ffULL, 0x000000ffff6b7224ULL, 0x000fc400078e00ffULL,
0x000000ffff057224ULL, 0x004fca00078e0008ULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x0000000411047824ULL, 0x000fca00078e00ffULL, 0xfffffff804197812ULL, 0x000fca00078ec0ffULL,
0x0126cc0019047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804817ULL,
0x000126c819047810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000ff00000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c021c7210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e03ULL, 0x003d09001c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1b7819ULL, 0x000fc8000001141dULL,
0x0000001c1b1b7211ULL, 0x000fca00078110ffULL, 0x000000ffff1c7224ULL, 0x000fca00000e061dULL,
0x000000021b1b7819ULL, 0x000fc8000000121cULL, 0x0000001b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0126cc00191c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001011177824ULL, 0x000fe200078e00ffULL,
0x0000000106197810ULL, 0x000fe20007ffe0ffULL, 0x0000590022227a24ULL, 0x010fc600078e02ffULL,
0xffffffe017037812ULL, 0x000fe200078ec0ffULL, 0x0000004022027824ULL, 0x000fe200078e00ffULL,
0x0000000c1900720cULL, 0x000fc60003f26070ULL, 0x0000010006037824ULL, 0x000fca00078e0203ULL,
0x0000004003197810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff037424ULL, 0x000fc600078e00ffULL,
0x00000020191c7812ULL, 0x000fe200078ec0ffULL, 0x0000640002027625ULL, 0x000fc800078e0003ULL,
0x0000000109217824ULL, 0x000fe200078e021cULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x00000010171c7812ULL, 0x000fe200078ec0ffULL, 0x000000100f1d7824ULL, 0x000fe200078e00ffULL,
0x000000190e177217ULL, 0x000fe40007800000ULL, 0x00000003ff1b7819ULL, 0x000fe4000001160fULL,
0x000000701d2b7812ULL, 0x000fe200078ec0ffULL, 0x0000000117177824ULL, 0x000fe200078e0a19ULL,
0x000000041b207810ULL, 0x040fe20007ffe0ffULL, 0x000000011b1e7824ULL, 0x040fe200078e021cULL,
0x0000000c1b1f7810ULL, 0x000fc40007ffe0ffULL, 0x0000001c17177217ULL, 0x000fe20007800000ULL,
0x000000011e197824ULL, 0x040fe400078e020fULL, 0x000000081e227824ULL, 0x000fe400078e00ffULL,
0x0000000117177824ULL, 0x100fe400078e0a1cULL, 0x000000011f267824ULL, 0x000fe200078e021cULL,
0xfffffff822197812ULL, 0x000fe400078ee219ULL, 0x000000081b227810ULL, 0x000fe20007ffe0ffULL,
0x0000000121237824ULL, 0x000fe200078e0226ULL, 0x000000172000720cULL, 0x0c0fe20003f66070ULL,
0x0000000120207824ULL, 0x100fe200078e021cULL, 0x000000172200720cULL, 0x0c0fe20003f46070ULL,
0x0000000122227824ULL, 0x000fe200078e021cULL, 0x000000171b00720cULL, 0x080fe20003f86070ULL,
0x00000001211c7824ULL, 0x000fe200078e021eULL, 0x000000171f00720cULL, 0x000fe20003f06070ULL,
0x00000001201b7824ULL, 0x000fc400078e020fULL, 0x0000000820287824ULL, 0x000fe400078e00ffULL,
0x00000001211e7824ULL, 0x040fe400078e0220ULL, 0x0000000121207824ULL, 0x000fe200078e0222ULL,
0xfffffff8281b7812ULL, 0x000fe200078ee21bULL, 0x0000000126217824ULL, 0x000fe400078e020fULL,
0x000000801c1c7825ULL, 0x000fc800078e00ffULL, 0x0000000122177824ULL, 0x000fe200078e020fULL,
0x0000002b1c297212ULL, 0x000fe200078efcffULL, 0x0000000826267824ULL, 0x000fe400078e00ffULL,
0x0000000822227824ULL, 0x000fe200078e00ffULL, 0x00000029021c7210ULL, 0x000fe20007fbe0ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0xfffffff826257812ULL, 0x000fe400078ee221ULL,
0xfffffff822177812ULL, 0x000fe200078ee217ULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000002b1e277212ULL, 0x000fc400078efcffULL, 0x0000f0000a267811ULL, 0x000fe200078e68ffULL,
0x0000008023227825ULL, 0x000fe200078e00ffULL, 0x00000027021e7210ULL, 0x000fe40007fde0ffULL,
0x0000002b20297212ULL, 0x080fe200078efcffULL, 0x00000001031d7824ULL, 0x040fe200028e061dULL,
0x0000002b22277212ULL, 0x000fe200078efcffULL, 0x00000001031f7824ULL, 0x000fe200030e061fULL,
0x0000002902207210ULL, 0x040fe20007fbe0ffULL, 0x0000001019197824ULL, 0x100fe200078e0226ULL,
0x0000002702027210ULL, 0x000fe20007fde0ffULL, 0x000000101b1b7824ULL, 0x000fc400078e0226ULL,
0x0000001017177824ULL, 0x100fe200078e0226ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c197faeULL, 0x0003e2000e101c46ULL, 0x0000000103217824ULL, 0x000fe400028e0621ULL,
0x0000001025257824ULL, 0x000fe200078e0226ULL, 0x000000001e1b7faeULL, 0x0003e2000d901c46ULL,
0x0000000103037824ULL, 0x000fc600030e0623ULL, 0x0000000020177faeULL, 0x0003e8000d101c46ULL,
0x0000000002257faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x00000010171c7812ULL, 0x000fe200078ec0ffULL, 0x000000100f197824ULL, 0x040fe200078e00ffULL,
0x0000f0000a287811ULL, 0x000fe400078e68ffULL, 0x0000001c0f1c7211ULL, 0x000fe400078fe8ffULL,
0x00000070192b7812ULL, 0x000fc400078ec0ffULL, 0x000000081c207810ULL, 0x040fe20007ffe0ffULL,
0x000000011c177824ULL, 0x040fe200078e020fULL, 0x0000000c1c227810ULL, 0x040fe20007ffe0ffULL,
0x000000081c1e7824ULL, 0x000fe400078e00ffULL, 0x00000001211d7824ULL, 0x000fe400078e021cULL,
0x0000000822277824ULL, 0x000fe200078e00ffULL, 0xfffffff81e177812ULL, 0x000fe200078ee217ULL,
0x00000001201f7824ULL, 0x000fe200078e020fULL, 0x000000041c1e7810ULL, 0x000fe20007ffe0ffULL,
0x000000801d1c7825ULL, 0x000fc800078e00ffULL, 0x0000000121197824ULL, 0x040fe200078e021eULL,
0x0000002b1c237212ULL, 0x000fe200078efcffULL, 0x000000011e1b7824ULL, 0x040fe400078e020fULL,
0x000000081e267824ULL, 0x000fe400078e00ffULL, 0x00000001211e7824ULL, 0x040fe400078e0220ULL,
0x0000000121217824ULL, 0x000fe200078e0222ULL, 0xfffffff8261b7812ULL, 0x000fe200078ee21bULL,
0x00000001221c7824ULL, 0x000fe200078e020fULL, 0x0000002302227210ULL, 0x000fe20007f1e0ffULL,
0x0000000820207824ULL, 0x000fc400078e00ffULL, 0x0000001017177824ULL, 0x000fe200078e0228ULL,
0xfffffff827267812ULL, 0x000fe200078ee21cULL, 0x0000000103237824ULL, 0x000fe200000e061dULL,
0xfffffff820257812ULL, 0x000fe200078ee21fULL, 0x00000080191c7825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022177faeULL, 0x0003e2000b901c46ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000002b1c297212ULL, 0x000fc600078efcffULL,
0x0000008021207825ULL, 0x000fe200078e00ffULL, 0x0000002b1e277212ULL, 0x000fe400078efcffULL,
0x00000029021c7210ULL, 0x000fe20007f1e0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0228ULL,
0x0000002b20197212ULL, 0x000fe200078efcffULL, 0x0000001025257824ULL, 0x100fe200078e0228ULL,
0x00000027021e7210ULL, 0x040fe20007f5e0ffULL, 0x00000001031d7824ULL, 0x000fe200000e061dULL,
0x0000001902027210ULL, 0x000fe20007f7e0ffULL, 0x0000001026197824ULL, 0x000fc400078e0228ULL,
0x00000001031f7824ULL, 0x040fe200010e061fULL, 0x000000001c1b7faeULL, 0x0003e2000b901c46ULL,
0x0000000103037824ULL, 0x000fc600018e0621ULL, 0x000000001e257faeULL, 0x0003e8000b901c46ULL,
0x0000000002197faeULL, 0x0003e4000b901c46ULL, 0x0000000811287824ULL, 0x000fe200078e00ffULL,
0x00000001081c7810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff227424ULL, 0x000fc600078e00ffULL,
0xfffffff028197812ULL, 0x000fe400078ec0ffULL, 0x0000000d1c00720cULL, 0x000fe40003f06070ULL,
0x00000000190473c2ULL, 0x000e6200000e0000ULL, 0x0000001028027812ULL, 0x040fe400078ec0ffULL,
0xffffffe028037812ULL, 0x040fe400078ec0ffULL, 0x0000000828177812ULL, 0x000fcc00078ec0ffULL,
0x00000001071c8824ULL, 0x000fe400078e021cULL, 0x00000004ff1d8424ULL, 0x000fe200078e00ffULL,
0x0000000317037210ULL, 0x000fe40007ffe002ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000066001c1c8625ULL, 0x000fca00078e001dULL, 0x000000061c228981ULL, 0x000522000c1e1900ULL,
0x000126b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0126b000196e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126080003207f8cULL, 0x000664000c80043fULL, 0x00000000001c7805ULL, 0x000fc40000015200ULL,
0x01260c0003177984ULL, 0x000ee40000000800ULL, 0x8000000017ff7812ULL, 0x00afe40007804821ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c177210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1e7824ULL, 0x000fe200000e0e1dULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1e00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1e00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc8000001141eULL,
0x0000001702027211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e061eULL,
0x0000000202027819ULL, 0x000fc80000001217ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011b1b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260c0003177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100f027824ULL, 0x000fe200078e00ffULL, 0x00000001ff787819ULL, 0x000fe2000001160fULL,
0x0000002011177824ULL, 0x000fe400078e00ffULL, 0xffffffffff857424ULL, 0x000fe200078e00ffULL,
0x0000007002027812ULL, 0x000fc400078ec0ffULL, 0xffffff8017177812ULL, 0x000fe400078ec0ffULL,
0x0000000c78787812ULL, 0x000fc800078ec0ffULL, 0x0000001778177210ULL, 0x000fca0007ffe002ULL,
0x01200000171b7984ULL, 0x000e680000000800ULL, 0x01220000171d7984ULL, 0x0006a20000000800ULL,
0x0000001a1b00720bULL, 0x002fe20003f1d000ULL, 0x000141627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000177806ULL, 0x008fc800000e0100ULL, 0x000000ff1700720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fc400078e001aULL, 0x0000001fff877424ULL, 0x000fe400078e00ffULL,
0xffffffffff867424ULL, 0x000fca00078e00ffULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x000000110b00720cULL, 0x000fe40003f05270ULL, 0x0000001a1b00720bULL, 0x000fe20003f54000ULL,
0x000141027f007947ULL, 0x000fd8000b800000ULL, 0x00000000001c7806ULL, 0x000fc400010e0100ULL,
0x00000080111f8824ULL, 0x000fe200078e0202ULL, 0x0000001a1b237209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000178208824ULL, 0x000fca00078e021fULL,
0x0124002320008388ULL, 0x0003e20000000800ULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000001a231a7221ULL, 0x002fe20000010100ULL,
0x000000ff1cff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b1a1a7820ULL, 0x000fcc0000410000ULL, 0x0000001a001a7308ULL, 0x000e640000000800ULL,
0x0000001a24247220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff277819ULL, 0x000fe2000001160fULL, 0x000140427f007947ULL, 0x000fea000b800000ULL,
0x00001f271a267589ULL, 0x0002e400000e0000ULL, 0x000000262c2c7220ULL, 0x08cfe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x0000002644447220ULL, 0x080fe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080f277811ULL, 0x002fe200078ff0ffULL,
0x00013f127f007947ULL, 0x000fea000b800000ULL, 0x00001f271a267589ULL, 0x0002e400000e0000ULL,
0x000000262e2e7220ULL, 0x08cfe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x0000002646467220ULL, 0x080fe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00001cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000100f277811ULL, 0x002fe200078ff0ffULL, 0x00013de27f007947ULL, 0x000fea000b800000ULL,
0x00001f271a267589ULL, 0x0002e400000e0000ULL, 0x000000264c4c7220ULL, 0x08cfe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x0000002664647220ULL, 0x080fe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002668687220ULL, 0x080fe20000410000ULL,
0x0000002669697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000001cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000180f277811ULL, 0x002fe200078ff0ffULL, 0x00013cc27f007947ULL, 0x000fea000b800000ULL,
0x00001f271a267589ULL, 0x0002e400000e0000ULL, 0x000000264e4e7220ULL, 0x08cfe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x0000002666667220ULL, 0x080fe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x000000266a6a7220ULL, 0x080fe20000410000ULL,
0x000000266b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000001c17ff7212ULL, 0x000fda00078030ffULL, 0x800000231b1b0221ULL, 0x000fe20000010000ULL,
0x00007610ff1e0816ULL, 0x000fc6000000001eULL, 0x3fb8aa3b1b1b0820ULL, 0x000fc80000410000ULL,
0x0000001b00000308ULL, 0x000e640000000800ULL, 0x000000001d1d0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000241d247221ULL, 0x004fc20000010000ULL,
0x00000000001a7805ULL, 0x000fcc0000015200ULL, 0x0126ac0019177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804818ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c1a1c7210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1d7824ULL, 0x000fe200000e0e1bULL,
0x003d09001c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff177819ULL, 0x000fc8000001141dULL, 0x0000001c17177211ULL, 0x000fca00078110ffULL,
0x000000ffff1c7224ULL, 0x000fca00000e061dULL, 0x0000000217177819ULL, 0x000fc8000000121cULL,
0x000000170000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126ac0019177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007804818ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099101e177816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff1700720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000ff13723eULL, 0x000fe400000000ffULL,
0x00000002ff177819ULL, 0x000fe4000001160fULL, 0x0000541013167816ULL, 0x000fe20000000013ULL,
0x000138b27f007947ULL, 0x000fea000b800000ULL, 0x00001f1716137589ULL, 0x0002a400000e0000ULL,
0x0000000817277810ULL, 0x002fe20007ffe0ffULL, 0x000138e27f007947ULL, 0x000fea000b800000ULL,
0x0000001017157810ULL, 0x000fe20007ffe0ffULL, 0x00001f2716147589ULL, 0x0002ea00000e0000ULL,
0x00001f1516157589ULL, 0x0002a400000e0000ULL, 0x0000001817277810ULL, 0x002fe20007ffe0ffULL,
0x000139327f007947ULL, 0x000fea000b800000ULL, 0x00001f2716167589ULL, 0x0002e400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000211257824ULL, 0x000fe200078e00ffULL,
0x000000080f187812ULL, 0x000fe200078ec0ffULL, 0x0000000411267824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000400111b7824ULL, 0x000fe200078e00ffULL,
0x0000000425207812ULL, 0x000fe200078ec0ffULL, 0x00001000111c7824ULL, 0x000fe200078e00ffULL,
0x0000000718177812ULL, 0x000fe200078ef80fULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000200f1a7211ULL, 0x000fc400078fe0ffULL, 0x0000000426267812ULL, 0x000fe200078ec0ffULL,
0x0000000817197824ULL, 0x000fe200078e00ffULL, 0xfffff0001b1b7812ULL, 0x000fe200078ec0ffULL,
0x0000000117187824ULL, 0x000fe200078e021aULL, 0x000000260f267211ULL, 0x000fe200078fe0ffULL,
0x0000000817277824ULL, 0x002fe200078e00ffULL, 0x0000a0001b217810ULL, 0x000fe40007ffe0ffULL,
0xfffffff819187812ULL, 0x000fe400078ee218ULL, 0x0000001017197812ULL, 0x000fc400078efcffULL,
0xffffe0001c1d7812ULL, 0x000fe200078ec0ffULL, 0x00000001171c7824ULL, 0x000fe400078e0226ULL,
0x000000011a1a7824ULL, 0x000fe200078e0219ULL, 0x0000e0001d1d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008191f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8271b7812ULL, 0x000fe200078ee21cULL,
0x0000001018747824ULL, 0x000fc600078e0221ULL, 0xfffffff81f1a7812ULL, 0x000fe200078ee21aULL,
0x000000101b7c7824ULL, 0x000fe400078e021dULL, 0x000000007474783bULL, 0x000e640000000200ULL,
0x000000101a707824ULL, 0x000fcc00078e0221ULL, 0x000000007070783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001374747232ULL, 0x086fe40000000000ULL,
0x0000001376767232ULL, 0x000fe40000000000ULL, 0x0000001475757232ULL, 0x088fe40000000000ULL,
0x0000001477777232ULL, 0x000fe40000000000ULL, 0x0000001570707232ULL, 0x080fe40000000000ULL,
0x0000001572727232ULL, 0x000fc40000000000ULL, 0x0000001671717232ULL, 0x080fe40000000000ULL,
0x0000001673737232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000008171f7824ULL, 0x000fe200078e00ffULL, 0x000000021c1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x0000000220207812ULL, 0x000fe200078efcffULL,
0x0000000119267824ULL, 0x000fe200078e0226ULL, 0xfffffff81f1c7812ULL, 0x000fe200078ee21cULL,
0x000008c000007945ULL, 0x000fe20003800000ULL, 0x000000200f207211ULL, 0x000fc600078fe0ffULL,
0x000000101c807824ULL, 0x000fcc00078e021dULL, 0x000000008080783bULL, 0x000ea20000004200ULL,
0x00000010ff1d7819ULL, 0x108fe4000001167cULL, 0x00000010ff277819ULL, 0x000fe4000001167dULL,
0x000000ff7c1f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff1e7819ULL, 0x000fe4000001167cULL,
0x0000ffff7c937812ULL, 0x000fe400078ec0ffULL, 0x000000ff7d297812ULL, 0x000fc400078ec0ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001167dULL, 0x0000ffff7d947812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7c7819ULL, 0x100fe4000001167eULL, 0x000000ff7e7d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001167eULL, 0x0000ffff7e957812ULL, 0x000fc400078ec0ffULL,
0x000000ff1d1d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff7f7e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff27277812ULL, 0x000fe400078ec0ffULL, 0x00000010ff887819ULL, 0x100fe4000001167fULL,
0x00000018ff897819ULL, 0x000fe4000001167fULL, 0x0000ffff7f967812ULL, 0x000fc400078ec0ffULL,
0x0000001fff1f723eULL, 0x000fe400020006ffULL, 0x0000001dff1d723eULL, 0x000fe400020006ffULL,
0x0000002aff6d723eULL, 0x000fe400020006ffULL, 0x0000007eff7f723eULL, 0x000fe400020006ffULL,
0x00000029ff2b723eULL, 0x000fe400020006ffULL, 0x0000006cff7e723eULL, 0x000fc400020006ffULL,
0x00000027ff2a723eULL, 0x000fe400020006ffULL, 0x0000001eff29723eULL, 0x000fe400020006ffULL,
0x00000008ff6c7819ULL, 0x000fe40000011694ULL, 0x000054101f1e7816ULL, 0x000fe4000000001dULL,
0x000000ff7c7c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff1d7819ULL, 0x000fc40000011695ULL,
0x0000ffff80977812ULL, 0x044fe400078ec0ffULL, 0x000054102b1f7816ULL, 0x000fe4000000002aULL,
0x0000006cff2b723eULL, 0x000fe400020006ffULL, 0x00000010ff8a7819ULL, 0x100fe40000011680ULL,
0x000000ff808c7812ULL, 0x000fe200078ec0ffULL, 0x0000001e742c723cULL, 0x002f62000000182cULL,
0x00000018ff8b7819ULL, 0x000fc40000011680ULL, 0x000000ff88887812ULL, 0x000fe400078ec0ffULL,
0x0000007cff6c723eULL, 0x000fe400020006ffULL, 0x00000010ff807819ULL, 0x000fe20000011681ULL,
0x0000001e704c723cULL, 0x000b62000000184cULL, 0x0000001dff7c723eULL, 0x000fe400020006ffULL,
0x00000008ff1d7819ULL, 0x000fe40000011697ULL, 0x00000008ff277819ULL, 0x000fc40000011693ULL,
0x000054102b2b7816ULL, 0x000fe2000000006dULL, 0x00000008191f7824ULL, 0x060fe200078e00ffULL,
0x00000088ff6d723eULL, 0x000fe200020006ffULL, 0x00000001191e7824ULL, 0x000fe200078e0220ULL,
0x000000ff80807812ULL, 0x000fe400078ec0ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x0000001dff1d723eULL, 0x000fe400020006ffULL, 0x0000ffff82997812ULL, 0x000fc400078ec0ffULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x00000027ff2a723eULL, 0x000fe400020006ffULL,
0x000000ff818e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff8d7819ULL, 0x000fe40000011681ULL,
0x0000ffff81987812ULL, 0x000fe400078ec0ffULL, 0x00000008ff277819ULL, 0x000fc40000011696ULL,
0x000054107f6d7816ULL, 0x000fe4000000006dULL, 0x00000010ff8f7819ULL, 0x100fe40000011682ULL,
0x000000ff82817812ULL, 0x000fe400078ec0ffULL, 0x00000018ff907819ULL, 0x000fe40000011682ULL,
0x00000080ff7f723eULL, 0x000fe400020006ffULL, 0x00000010ff827819ULL, 0x000fc40000011683ULL,
0x0000ffff839a7812ULL, 0x000fe400078ec0ffULL, 0x000054101d807816ULL, 0x000fe4000000008bULL,
0x000054107d6c7816ULL, 0x000fe4000000006cULL, 0x00000008ff1d7819ULL, 0x000fe40000011699ULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x000054102a2a7816ULL, 0x000fe20000000029ULL,
0x0000006c7434723cULL, 0x000f620000001834ULL, 0x00000027ff7d723eULL, 0x000fc400020006ffULL,
0x00000018ff917819ULL, 0x000fe40000011683ULL, 0x00000008ff277819ULL, 0x000fe40000011698ULL,
0x000000ff83927812ULL, 0x000fe200078ec0ffULL, 0x0000002a7430723cULL, 0x000f620000001830ULL,
0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff82827812ULL, 0x000fc400078ec0ffULL, 0x00000008ff887819ULL, 0x000fe2000001169aULL,
0x0000002a7050723cULL, 0x040b620000001850ULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x0000001dff1d723eULL, 0x000fe400020006ffULL, 0x00000081ff29723eULL, 0x000fe400020006ffULL,
0x000054107d7d7816ULL, 0x000fe20000000089ULL, 0x00000008172a7824ULL, 0x020fe200078e00ffULL,
0x000054107c7c7816ULL, 0x000fe2000000007eULL, 0x0000006c7054723cULL, 0x000f620000001854ULL,
0x00000027ff81723eULL, 0x000fc400020006ffULL, 0x00000091ff89723eULL, 0x000fe400020006ffULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x0000007c7438723cULL, 0x000f620000001838ULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x0000008aff7e723eULL, 0x000fe400020006ffULL, 0x00000092ff83723eULL, 0x000fc400020006ffULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x0000007c7058723cULL, 0x000b620000001858ULL,
0x00000082ff27723eULL, 0x000fe400020006ffULL, 0x00000088ff91723eULL, 0x000fe400020006ffULL,
0x000054101d907816ULL, 0x000fe20000000090ULL, 0x00000001171d7824ULL, 0x000fe200078e0220ULL,
0x000054108c7e7816ULL, 0x000fe4000000007eULL, 0x000054108e7f7816ULL, 0x000fc4000000007fULL,
0x0000541081817816ULL, 0x000fe4000000008dULL, 0x0000541029827816ULL, 0x000fe4000000008fULL,
0x0000541083837816ULL, 0x000fe20000000027ULL, 0x0000007e743c723cULL, 0x000f62000000183cULL,
0x0000541091917816ULL, 0x000fe20000000089ULL, 0x0000000819277824ULL, 0x000fe200078e00ffULL,
0xfffffff82a1d7812ULL, 0x000fe400078ee21dULL, 0xfffffff81f1e7812ULL, 0x000fc400078ee21eULL,
0x0000e0000a1f7811ULL, 0x000fe200078e68ffULL, 0x000000807440723cULL, 0x000f620000001840ULL,
0xfffffff827207812ULL, 0x000fca00078ee226ULL, 0x00000010207c7824ULL, 0x020fe400078e021fULL,
0x000000827444723cULL, 0x040f700000001844ULL, 0x000000907448723cULL, 0x000b6e0000001848ULL,
0x000000101d747824ULL, 0x120fe200078e0221ULL, 0x0000007e705c723cULL, 0x000f62000000185cULL,
0x000000101e217824ULL, 0x000fc800078e0221ULL, 0x000000007474783bULL, 0x000e660000000200ULL,
0x000000807060723cULL, 0x040f700000001860ULL, 0x000000827064723cULL, 0x040f700000001864ULL,
0x000000907068723cULL, 0x000b640000001868ULL, 0x000000002170783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000001374747232ULL, 0x082fe40000000000ULL, 0x0000001376767232ULL, 0x000fc40000000000ULL,
0x0000001475757232ULL, 0x080fe40000000000ULL, 0x0000001477777232ULL, 0x000fe40000000000ULL,
0x0000001570707232ULL, 0x088fe40000000000ULL, 0x0000001572727232ULL, 0x000fe40000000000ULL,
0x0000001671717232ULL, 0x080fe40000000000ULL, 0x0000001673737232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007c7c783bULL, 0x000ea20000004200ULL,
0x00000008192a7824ULL, 0x000fe200078e00ffULL, 0x0000000226217810ULL, 0x004fc40007ffe0ffULL,
0xfffffff825257812ULL, 0x000fe400078ec0ffULL, 0xfffffff82a217812ULL, 0x000fca00078ee221ULL,
0x0000001021807824ULL, 0x000fcc00078e021fULL, 0x000000008080783bULL, 0x000ea20000004200ULL,
0x00000010ff2a7819ULL, 0x000fe4000001167dULL, 0x00000010ff267819ULL, 0x100fe4000001167cULL,
0x000000ff7d2b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff277819ULL, 0x000fe4000001167cULL,
0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff7c947812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001167dULL, 0x000000ff7c297812ULL, 0x000fe400078ec0ffULL,
0x0000ffff7d957812ULL, 0x000fe400078ec0ffULL, 0x0000002bff6d723eULL, 0x000fe400020006ffULL,
0x000000ff26267812ULL, 0x000fe400078ec0ffULL, 0x00000027ff2b723eULL, 0x000fc400020006ffULL,
0x0000002aff27723eULL, 0x000fe400020006ffULL, 0x0000006cff7c723eULL, 0x000fe400020006ffULL,
0x00000008ff2a7819ULL, 0x000fe40000011694ULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x00000008ff6c7819ULL, 0x000fc40000011695ULL,
0x0000ffff7e967812ULL, 0x040fe400078ec0ffULL, 0x0000002aff2a723eULL, 0x000fe400020006ffULL,
0x0000541029267816ULL, 0x000fe40000000026ULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000010ff7d7819ULL, 0x000fe4000001167eULL, 0x000000ff7e897812ULL, 0x000fc400078ec0ffULL,
0x00000018ff887819ULL, 0x000fe4000001167eULL, 0x00000008ff297819ULL, 0x000fe40000011696ULL,
0x00000010ff7e7819ULL, 0x100fe4000001167fULL, 0x000000ff7f8b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001167fULL, 0x0000ffff7f977812ULL, 0x000fc400078ec0ffULL,
0x0000ffff80987812ULL, 0x044fe400078ec0ffULL, 0x00000010ff7f7819ULL, 0x100fe40000011680ULL,
0x000000ff808d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8c7819ULL, 0x000fe40000011680ULL,
0x000054102a2a7816ULL, 0x000fe4000000002bULL, 0x00000010ff807819ULL, 0x000fc40000011681ULL,
0x000054106c2b7816ULL, 0x000fe4000000007cULL, 0x000000ff818f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8e7819ULL, 0x000fe40000011681ULL, 0x0000ffff81997812ULL, 0x000fe200078ec0ffULL,
0x0000002a7430723cULL, 0x002f620000001830ULL, 0x00000029ff7c723eULL, 0x000fe400020006ffULL,
0x00000010ff817819ULL, 0x000fc40000011682ULL, 0x000000ff7e7e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff297819ULL, 0x000fe20000011698ULL, 0x0000002a7050723cULL, 0x008f620000001850ULL,
0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff80807812ULL, 0x000fe400078ec0ffULL,
0x000000ff82917812ULL, 0x000fe400078ec0ffULL, 0x00000018ff907819ULL, 0x000fc40000011682ULL,
0x0000ffff829a7812ULL, 0x000fe400078ec0ffULL, 0x000054106d277816ULL, 0x000fe40000000027ULL,
0x00000010ff827819ULL, 0x100fe40000011683ULL, 0x000000ff83937812ULL, 0x000fe400078ec0ffULL,
0x00000018ff927819ULL, 0x000fe20000011683ULL, 0x00000026742c723cULL, 0x000f62000000182cULL,
0x0000008cff8c723eULL, 0x000fc400020006ffULL, 0x000000ff7d7d7812ULL, 0x000fe400078ec0ffULL,
0x0000007eff6d723eULL, 0x000fe400020006ffULL, 0x00000029ff29723eULL, 0x000fe200020006ffULL,
0x00000026704c723cULL, 0x000f62000000184cULL, 0x000000ff81817812ULL, 0x000fe400078ec0ffULL,
0x0000ffff83837812ULL, 0x000fe400078ec0ffULL, 0x0000007fff7e723eULL, 0x000fc400020006ffULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x00000080ff7f723eULL, 0x000fe400020006ffULL,
0x00000008ff807819ULL, 0x000fe40000011699ULL, 0x0000007dff6c723eULL, 0x000fe400020006ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00005410298c7816ULL, 0x000fc4000000008cULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000008ff7d7819ULL, 0x000fe40000011697ULL,
0x000000ff82827812ULL, 0x000fe400078ec0ffULL, 0x00000008ff297819ULL, 0x000fe4000001169aULL,
0x00000008ff837819ULL, 0x000fe40000011683ULL, 0x000054108d7e7816ULL, 0x000fc4000000007eULL,
0x00000080ff8d723eULL, 0x000fe400020006ffULL, 0x0000541091807816ULL, 0x000fe40000000081ULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x0000008eff8e723eULL, 0x000fc400020006ffULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000029ff29723eULL, 0x000fc400020006ffULL,
0x00000083ff91723eULL, 0x000fe400020006ffULL, 0x000054107c7c7816ULL, 0x000fe40000000088ULL,
0x000054107d7d7816ULL, 0x000fe4000000008aULL, 0x000054108f7f7816ULL, 0x000fe4000000007fULL,
0x000054108d8d7816ULL, 0x000fe4000000008eULL, 0x0000541093817816ULL, 0x000fe20000000082ULL,
0x0000007c7438723cULL, 0x000f620000001838ULL, 0x0000541029907816ULL, 0x000fc40000000090ULL,
0x0000541091917816ULL, 0x000fe40000000092ULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x0000007e743c723cULL, 0x000f62000000183cULL,
0x00005410896c7816ULL, 0x000fe4000000006cULL, 0x000054108b6d7816ULL, 0x000fca000000006dULL,
0x0000008c7440723cULL, 0x040f700000001840ULL, 0x000000807444723cULL, 0x040f700000001844ULL,
0x000000907448723cULL, 0x000f700000001848ULL, 0x0000007c7058723cULL, 0x040f700000001858ULL,
0x0000007e705c723cULL, 0x040f70000000185cULL, 0x0000008c7060723cULL, 0x040f700000001860ULL,
0x000000807064723cULL, 0x040f700000001864ULL, 0x000000907068723cULL, 0x000f700000001868ULL,
0x0000006c7434723cULL, 0x080f700000001834ULL, 0x0000006c7054723cULL, 0x000b6e0000001854ULL,
0x000126c80a6c7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006c6c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126880025ff7f8cULL, 0x0005e4000c80043fULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0x0000040004257984ULL, 0x004ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc4000780486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a262a7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e27ULL, 0x003d09002a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc8000001142bULL,
0x0000002a25257211ULL, 0x000fca00078110ffULL, 0x000000ffff2a7224ULL, 0x000fca00000e062bULL,
0x0000000225257819ULL, 0x000fc8000000122aULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040004257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001011297824ULL, 0x000fe400078e00ffULL, 0x0000590022227a24ULL, 0x010fe400078e02ffULL,
0x00000080ff277424ULL, 0x000fe200078e00ffULL, 0xffffffe029257812ULL, 0x000fe200078ec0ffULL,
0x0000004022267824ULL, 0x000fc800078e00ffULL, 0x0000010006257824ULL, 0x000fe400078e0225ULL,
0x0000640026267625ULL, 0x000fc600078e0027ULL, 0x0000008025257810ULL, 0x000fc80007ffe0ffULL,
0x0000002025227812ULL, 0x000fca00078ec0ffULL, 0x0000000109727824ULL, 0x000fe200078e0222ULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x000000250e227217ULL, 0x000fe40007800000ULL,
0x0000001029297812ULL, 0x000fe400078ec0ffULL, 0x00000003ff2a7819ULL, 0x000fe2000001160fULL,
0x0000000122227824ULL, 0x000fc600078e0a25ULL, 0x000000042a6c7810ULL, 0x040fe20007ffe0ffULL,
0x000000012a257824ULL, 0x040fe200078e0229ULL, 0x0000002229227217ULL, 0x000fe40007800000ULL,
0x0000000c2a707810ULL, 0x000fe20007ffe0ffULL, 0x00000001252b7824ULL, 0x040fe400078e020fULL,
0x0000000825747824ULL, 0x000fe400078e00ffULL, 0x0000000122227824ULL, 0x100fe400078e0a29ULL,
0x0000000170757824ULL, 0x000fe200078e0229ULL, 0xfffffff874747812ULL, 0x000fc400078ee22bULL,
0x000000082a2b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000175777824ULL, 0x000fe200078e020fULL,
0x000000226c00720cULL, 0x0c0fe20003f66070ULL, 0x000000016c6c7824ULL, 0x000fe200078e0229ULL,
0x000000222a00720cULL, 0x080fe20003f86070ULL, 0x00000001252a7824ULL, 0x000fe200078e0272ULL,
0x000000222b00720cULL, 0x0c0fe20003f46070ULL, 0x000000016c257824ULL, 0x000fe200078e020fULL,
0x000000227000720cULL, 0x000fe20003f06070ULL, 0x000000086c767824ULL, 0x000fe400078e00ffULL,
0x000000012b6d7824ULL, 0x000fc400078e0229ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0xfffffff876227812ULL, 0x000fc600078ee225ULL, 0x000000016c6c7824ULL, 0x100fe200078e0272ULL,
0x000000022a257212ULL, 0x000fe200078efcffULL, 0x000000016d707824ULL, 0x040fe400078e0272ULL,
0x000000016d297824ULL, 0x040fe200078e020fULL, 0x00000025262a7210ULL, 0x000fe20007fbe0ffULL,
0x000000086d767824ULL, 0x000fe400078e00ffULL, 0x000000806c6c7825ULL, 0x000fc600078e00ffULL,
0xfffffff876767812ULL, 0x000fe200078ee229ULL, 0x0000000175727824ULL, 0x000fe200078e0272ULL,
0x000000026c257212ULL, 0x000fe200078efcffULL, 0x0000008070707825ULL, 0x000fc800078e00ffULL,
0x0000008072727825ULL, 0x000fe200078e00ffULL, 0x0000000270297212ULL, 0x000fc600078efcffULL,
0x00000001272b7824ULL, 0x000fe200028e062bULL, 0x00000025266c7210ULL, 0x000fe40007fbe0ffULL,
0x0000000272257212ULL, 0x000fe200078efcffULL, 0x0000000875727824ULL, 0x000fe400078e00ffULL,
0x00000001276d7824ULL, 0x040fe200028e066dULL, 0x0000002926707210ULL, 0x000fe20007fbe0ffULL,
0x0000001022297824ULL, 0x100fe200078e021fULL, 0x0000002526267210ULL, 0x000fe20007fde0ffULL,
0x0000001074257824ULL, 0x000fe200078e021fULL, 0xfffffff872727812ULL, 0x000fe200078ee277ULL,
0x0000000127717824ULL, 0x000fc400028e0671ULL, 0x0000000127277824ULL, 0x000fe200030e0673ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a257faeULL, 0x0003e2000e101c46ULL,
0x0000001076737824ULL, 0x100fe400078e021fULL, 0x0000001072757824ULL, 0x000fe200078e021fULL,
0x000000006c297faeULL, 0x0003e8000d901c46ULL, 0x0000000070737faeULL, 0x0003e8000d101c46ULL,
0x0000000026757faeULL, 0x0003e2000c101c46ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001029227812ULL, 0x000fc800078ec0ffULL, 0x000000220f227211ULL, 0x000fc800078fe8ffULL,
0x0000000822707810ULL, 0x040fe20007ffe0ffULL, 0x00000001222a7824ULL, 0x040fe200078e0272ULL,
0x00000004226c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000122257824ULL, 0x100fe400078e020fULL,
0x00000001702b7824ULL, 0x140fe400078e020fULL, 0x00000008707c7824ULL, 0x000fe400078e00ffULL,
0x0000000822747824ULL, 0x040fe200078e00ffULL, 0x0000000c22227810ULL, 0x000fe20007ffe0ffULL,
0x000000016c297824ULL, 0x000fe200078e020fULL, 0xfffffff87c7c7812ULL, 0x000fe200078ee22bULL,
0x000000086c767824ULL, 0x000fe200078e00ffULL, 0xfffffff874747812ULL, 0x000fe200078ee225ULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0xfffffff876767812ULL, 0x000fe200078ee229ULL,
0x000000016c6c7824ULL, 0x100fe200078e0272ULL, 0x000000022a257212ULL, 0x000fe200078efcffULL,
0x0000000170707824ULL, 0x100fe400078e0272ULL, 0x0000000122727824ULL, 0x000fe200078e0272ULL,
0x00000025262a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000122297824ULL, 0x040fe400078e020fULL,
0x0000000822227824ULL, 0x000fe400078e00ffULL, 0x000000806c6c7825ULL, 0x000fc600078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee229ULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000026c757212ULL, 0x000fc600078efcffULL, 0x0000008072727825ULL, 0x000fe200078e00ffULL,
0x0000000270297212ULL, 0x080fe400078efcffULL, 0x00000075266c7210ULL, 0x000fe20007f5e0ffULL,
0x00000001272b7824ULL, 0x040fe200000e062bULL, 0x0000000272257212ULL, 0x000fe200078efcffULL,
0x0000001022757824ULL, 0x000fe200078e021fULL, 0x0000002926707210ULL, 0x040fe20007f1e0ffULL,
0x00000001276d7824ULL, 0x000fe200010e066dULL, 0x0000002526267210ULL, 0x000fe20007f7e0ffULL,
0x0000001074257824ULL, 0x000fc400078e021fULL, 0x0000000127717824ULL, 0x040fe400000e0671ULL,
0x0000000127277824ULL, 0x000fe200018e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a257faeULL, 0x0003e2000b901c46ULL, 0x0000001076297824ULL, 0x100fe400078e021fULL,
0x000000107c737824ULL, 0x000fc600078e021fULL, 0x000000006c297faeULL, 0x0003e8000b901c46ULL,
0x0000000070737faeULL, 0x0003e8000b901c46ULL, 0x0000000026757faeULL, 0x0003e4000b901c46ULL,
0x00000000280473c2ULL, 0x000ea200000e0000ULL, 0x0000000208267810ULL, 0x002fe20007ffe0ffULL,
0xffffffffff227424ULL, 0x000fc600078e00ffULL, 0x0000000d2600720cULL, 0x000fda0003f06070ULL,
0x0000000107268824ULL, 0x000fe400078e0226ULL, 0x00000004ff278424ULL, 0x000fe200078e00ffULL,
0xfffffff004047892ULL, 0x004fc6000f8ec03fULL, 0x0000660026268625ULL, 0x000fe200078e0027ULL,
0x000126a804057890ULL, 0x000fc8000fffe03fULL, 0x0000000626228981ULL, 0x000328000c1e1900ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126a800ff2a7f8cULL, 0x000ea2000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01262800036c7f8cULL, 0x000664000c80043fULL, 0x0000000000267805ULL, 0x002fc40000015200ULL,
0x01262c0003257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc4000780486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002826287210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011429ULL,
0x0000002825257211ULL, 0x000fca00078110ffULL, 0x000000ffff287224ULL, 0x000fca00000e0629ULL,
0x0000000225257819ULL, 0x000fc80000001228ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01262c0003257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002011257824ULL, 0x000fca00078e00ffULL, 0xffffff8025257812ULL, 0x000fc800078ec0ffULL,
0x0000008002257810ULL, 0x000fca0007ffe025ULL, 0x0000000178257824ULL, 0x000fca00078e0225ULL,
0x0120000025287984ULL, 0x000e680000000800ULL, 0x0122000025297984ULL, 0x0006a20000000800ULL,
0x000000232800720bULL, 0x002fe20003f1d000ULL, 0x000117727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000707806ULL, 0x008fc800000e0100ULL, 0x000000ff7000720cULL, 0x000fe20003f05270ULL,
0x0000077000007945ULL, 0x000fe20003800000ULL, 0x00000001ff257424ULL, 0x000fd600078e00ffULL,
0x0000074000008947ULL, 0x000fea0003800000ULL, 0x000000010b267810ULL, 0x000fe40007ffe0ffULL,
0x000000232800720bULL, 0x000fe40003f54000ULL, 0x000000112600720cULL, 0x000fe20003f05270ULL,
0x000117327f007947ULL, 0x000fd4000b800000ULL, 0x0000000000717806ULL, 0x000fc400010e0100ULL,
0x0000008011278824ULL, 0x000fe200078e0202ULL, 0x0000002328258209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x0000000178268824ULL, 0x000fca00078e0227ULL,
0x0124002526008388ULL, 0x0003e20000000800ULL, 0x000000ff7100720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000002328267209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff71ff7812ULL, 0x000fc6000780c0ffULL,
0x0000002326257221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL,
0x0000002500737308ULL, 0x000e640000000800ULL, 0x0000007324247220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x000fe2000001160fULL,
0x000116627f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000262c2c7220ULL, 0x08cfe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x0000002644447220ULL, 0x080fe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0071ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080f277811ULL, 0x002fe200078ff0ffULL, 0x000115327f007947ULL, 0x000fea000b800000ULL,
0x00001f2773267589ULL, 0x0002e400000e0000ULL, 0x000000262e2e7220ULL, 0x08cfe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x0000002646467220ULL, 0x080fe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000071ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000100f277811ULL, 0x002fe200078ff0ffULL,
0x000114027f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000264c4c7220ULL, 0x08cfe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x0000002664647220ULL, 0x080fe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002668687220ULL, 0x080fe20000410000ULL, 0x0000002669697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000071ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000180f277811ULL, 0x002fe200078ff0ffULL,
0x000112e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000264e4e7220ULL, 0x08cfe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x0000002666667220ULL, 0x080fe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x000000266a6a7220ULL, 0x080fe20000410000ULL, 0x000000266b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000007170ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff257424ULL, 0x000fe200078e00ffULL, 0x0000002328237209ULL, 0x000fd60007810000ULL,
0x8000002328280221ULL, 0x000fe20000010000ULL, 0x00007610ff250816ULL, 0x000fc60000000025ULL,
0x3fb8aa3b28280820ULL, 0x000fc80000410000ULL, 0x0000002800000308ULL, 0x000e640000000800ULL,
0x0000000029290220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002429247221ULL, 0x004fc20000010000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000000811287824ULL, 0x000fca00078e00ffULL, 0xfffffff0286c7812ULL, 0x000fca00078ec0ffULL,
0x0126b4006c297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x00000028266d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09006d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff287819ULL, 0x000fc80000011429ULL,
0x0000006d28287211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000228287819ULL, 0x000fc80000001229ULL, 0x000000280000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b4006c297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991025257816ULL, 0x000fc800000000ffULL, 0x000000ff2500720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000ff13723eULL, 0x000fe400000000ffULL,
0x00000002ff297819ULL, 0x000fe4000001160fULL, 0x0000541013167816ULL, 0x000fe20000000013ULL,
0x00010ea27f007947ULL, 0x000fea000b800000ULL, 0x00001f2916137589ULL, 0x0002a400000e0000ULL,
0x0000000829277810ULL, 0x002fe20007ffe0ffULL, 0x00010ed27f007947ULL, 0x000fea000b800000ULL,
0x0000001029157810ULL, 0x000fe20007ffe0ffULL, 0x00001f2716147589ULL, 0x0002ea00000e0000ULL,
0x00001f1516157589ULL, 0x0002a400000e0000ULL, 0x0000001829277810ULL, 0x002fe20007ffe0ffULL,
0x00010f227f007947ULL, 0x000fea000b800000ULL, 0x00001f2716167589ULL, 0x0002e400000e0000ULL,
0x0000040011257824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100011267824ULL, 0x000fe200078e00ffULL, 0x0000013000007945ULL, 0x000fe40003800000ULL,
0xfffff00025257812ULL, 0x000fc400078ec0ffULL, 0xffffe00026267812ULL, 0x000fe400078ec0ffULL,
0x0000b00025257810ULL, 0x000fe40007ffe0ffULL, 0x0000f00026267810ULL, 0x000fc60007ffe0ffULL,
0x0000001018707824ULL, 0x100fe400078e0225ULL, 0x000000101a6c7824ULL, 0x000fe400078e0225ULL,
0x000000101b747824ULL, 0x000fe400078e0226ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000006c6c783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000001370707232ULL, 0x086fe40000000000ULL, 0x0000001372727232ULL, 0x000fc40000000000ULL,
0x0000001471717232ULL, 0x088fe40000000000ULL, 0x0000001473737232ULL, 0x000fe40000000000ULL,
0x000000156c6c7232ULL, 0x080fe40000000000ULL, 0x000000156e6e7232ULL, 0x000fe40000000000ULL,
0x000000166d6d7232ULL, 0x080fe40000000000ULL, 0x000000166f6f7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007474783bULL, 0x000ee20000004200ULL,
0x000000101c7c7824ULL, 0x000fe200078e0226ULL, 0x0000082000007945ULL, 0x000fea0003800000ULL,
0x000000007c7c783bULL, 0x000ea20000004200ULL, 0x00000010ff267819ULL, 0x008fc40000011674ULL,
0x00000010ff297819ULL, 0x100fe40000011675ULL, 0x00000018ff277819ULL, 0x002fe40000011674ULL,
0x000000ff74287812ULL, 0x000fe400078ec0ffULL, 0x000000ff75817812ULL, 0x040fe400078ec0ffULL,
0x00000018ff807819ULL, 0x000fe40000011675ULL, 0x0000ffff75957812ULL, 0x000fc400078ec0ffULL,
0x000000ff26267812ULL, 0x000fe400078ec0ffULL, 0x000000ff29297812ULL, 0x000fe400078ec0ffULL,
0x0000ffff74947812ULL, 0x000fe400078ec0ffULL, 0x00000018ff757819ULL, 0x100fe40000011676ULL,
0x00000010ff827819ULL, 0x000fe40000011676ULL, 0x000000ff76837812ULL, 0x000fc400078ec0ffULL,
0x0000ffff76967812ULL, 0x000fe400078ec0ffULL, 0x00000027ff74723eULL, 0x000fe400020006ffULL,
0x00000010ff767819ULL, 0x100fe40000011677ULL, 0x000000ff77897812ULL, 0x040fe400078ec0ffULL,
0x00000018ff887819ULL, 0x000fe40000011677ULL, 0x0000ffff77977812ULL, 0x000fc400078ec0ffULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x00000026ff26723eULL, 0x000fe400020006ffULL,
0x00000029ff27723eULL, 0x000fe400020006ffULL, 0x00000075ff77723eULL, 0x000fe400020006ffULL,
0x00000008ff297819ULL, 0x000fe40000011694ULL, 0x00000008ff757819ULL, 0x000fc40000011695ULL,
0x0000541028267816ULL, 0x000fe40000000026ULL, 0x00000029ff28723eULL, 0x000fe400020006ffULL,
0x00000010ff8a7819ULL, 0x104fe4000001167cULL, 0x000000ff7c8c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8b7819ULL, 0x000fe4000001167cULL, 0x0000ffff7c987812ULL, 0x000fc400078ec0ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x00000075ff29723eULL, 0x000fe400020006ffULL,
0x000000ff76767812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001167dULL,
0x000000ff82827812ULL, 0x000fe400078ec0ffULL, 0x0000541029297816ULL, 0x000fc40000000080ULL,
0x00000076ff75723eULL, 0x000fe400020006ffULL, 0x00000010ff8f7819ULL, 0x100fe4000001167eULL,
0x000000ff7e917812ULL, 0x040fe400078ec0ffULL, 0x00000018ff907819ULL, 0x000fe4000001167eULL,
0x0000ffff7e9a7812ULL, 0x000fe400078ec0ffULL, 0x00000081ff81723eULL, 0x000fc400020006ffULL,
0x0000541028287816ULL, 0x000fe40000000074ULL, 0x0000007cff80723eULL, 0x000fe400020006ffULL,
0x00000008ff767819ULL, 0x000fe40000011696ULL, 0x0000ffff7d997812ULL, 0x000fe200078ec0ffULL,
0x000000287030723cULL, 0x000f620000001830ULL, 0x000000ff7f7e7812ULL, 0x000fe400078ec0ffULL,
0x00000083ff83723eULL, 0x000fc400020006ffULL, 0x00000082ff74723eULL, 0x000fe400020006ffULL,
0x00000008ff7c7819ULL, 0x000fe20000011697ULL, 0x000000286c50723cULL, 0x000b620000001850ULL,
0x00000010ff8d7819ULL, 0x000fe4000001167dULL, 0x00000010ff927819ULL, 0x100fe4000001167fULL,
0x0000ffff7f9b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff937819ULL, 0x000fc4000001167fULL,
0x0000541081277816ULL, 0x000fe40000000027ULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x0000541083747816ULL, 0x000fe20000000074ULL,
0x00000026702c723cULL, 0x000f62000000182cULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000007eff81723eULL, 0x000fc400020006ffULL, 0x00000008ff7f7819ULL, 0x000fe40000011699ULL,
0x000000ff7d8e7812ULL, 0x000fe200078ec0ffULL, 0x000000266c4c723cULL, 0x000f62000000184cULL,
0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff7e7819ULL, 0x000fe40000011698ULL, 0x000000ff8f8f7812ULL, 0x000fc400078ec0ffULL,
0x000000ff92927812ULL, 0x000fe400078ec0ffULL, 0x00000008ff827819ULL, 0x000fe4000001169aULL,
0x00000008ff837819ULL, 0x000fe4000001169bULL, 0x0000541076767816ULL, 0x000fe40000000077ULL,
0x000054107c777816ULL, 0x000fe40000000088ULL, 0x0000007fff7f723eULL, 0x000fc400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x000000767038723cULL, 0x080f620000001838ULL, 0x0000008eff7d723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x0000008aff7c723eULL, 0x000fe200020006ffULL, 0x000000766c58723cULL, 0x000f620000001858ULL,
0x0000008dff8d723eULL, 0x000fc400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fc400020006ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x000054107f7f7816ULL, 0x000fe40000000080ULL, 0x0000541089757816ULL, 0x000fe40000000075ULL,
0x000054108c7c7816ULL, 0x000fe4000000007cULL, 0x000054107d7d7816ULL, 0x000fe4000000008dULL,
0x000054107e7e7816ULL, 0x000fe2000000008bULL, 0x000000747034723cULL, 0x000f620000001834ULL,
0x0000541091807816ULL, 0x000fc4000000008fULL, 0x0000541081817816ULL, 0x000fe40000000092ULL,
0x0000541082827816ULL, 0x000fe40000000090ULL, 0x0000541083837816ULL, 0x000fe20000000093ULL,
0x0000007c703c723cULL, 0x000f64000000183cULL, 0x000010001f287810ULL, 0x020fca0007ffe0ffULL,
0x0000001020297824ULL, 0x000fe200078e0228ULL, 0x0000007e7040723cULL, 0x040f700000001840ULL,
0x000000807044723cULL, 0x040f700000001844ULL, 0x000000827048723cULL, 0x000b6e0000001848ULL,
0x000000101d707824ULL, 0x120fe200078e0225ULL, 0x000000746c54723cULL, 0x000f620000001854ULL,
0x000000101e257824ULL, 0x000fc800078e0225ULL, 0x000000007070783bULL, 0x000e660000000200ULL,
0x0000007c6c5c723cULL, 0x040f70000000185cULL, 0x0000007e6c60723cULL, 0x040f700000001860ULL,
0x000000806c64723cULL, 0x040f700000001864ULL, 0x000000826c68723cULL, 0x000b640000001868ULL,
0x00000000256c783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000001370707232ULL, 0x082fe40000000000ULL,
0x0000001372727232ULL, 0x000fc40000000000ULL, 0x0000001471717232ULL, 0x080fe40000000000ULL,
0x0000001473737232ULL, 0x000fe40000000000ULL, 0x000000156c6c7232ULL, 0x088fe40000000000ULL,
0x000000156e6e7232ULL, 0x000fe40000000000ULL, 0x000000166d6d7232ULL, 0x080fe40000000000ULL,
0x000000166f6f7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000002974783bULL, 0x000ea20000004200ULL, 0x00000010217c7824ULL, 0x000fcc00078e0228ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000010ff257819ULL, 0x104fe40000011674ULL,
0x000000ff74277812ULL, 0x040fe400078ec0ffULL, 0x00000018ff267819ULL, 0x000fe40000011674ULL,
0x0000ffff74957812ULL, 0x000fe400078ec0ffULL, 0x00000010ff747819ULL, 0x000fe40000011675ULL,
0x000000ff25257812ULL, 0x000fc400078ec0ffULL, 0x00000010ff827819ULL, 0x100fe40000011676ULL,
0x000000ff76887812ULL, 0x040fe400078ec0ffULL, 0x00000018ff837819ULL, 0x000fe40000011676ULL,
0x0000ffff76977812ULL, 0x000fe400078ec0ffULL, 0x00000018ff767819ULL, 0x000fe40000011677ULL,
0x000000ff75817812ULL, 0x000fc400078ec0ffULL, 0x00000010ff897819ULL, 0x000fe40000011677ULL,
0x000000ff778a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff77987812ULL, 0x000fe400078ec0ffULL,
0x000000ff74747812ULL, 0x000fe400078ec0ffULL, 0x000000ff7c777812ULL, 0x008fe400078ec0ffULL,
0x00000027ff27723eULL, 0x000fc400020006ffULL, 0x00000025ff25723eULL, 0x000fe400020006ffULL,
0x0000ffff75967812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8b7819ULL, 0x100fe4000001167cULL,
0x00000018ff8c7819ULL, 0x000fe4000001167cULL, 0x0000ffff7c997812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8f7819ULL, 0x000fc4000001167eULL, 0x000000ff7e917812ULL, 0x040fe400078ec0ffULL,
0x00000018ff907819ULL, 0x000fe4000001167eULL, 0x0000ffff7e9b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff807819ULL, 0x000fe40000011675ULL, 0x00000010ff8d7819ULL, 0x000fe4000001167dULL,
0x000000ff7d8e7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001167dULL,
0x0000ffff7d9a7812ULL, 0x000fe400078ec0ffULL, 0x00000076ff7e723eULL, 0x000fe400020006ffULL,
0x00000010ff927819ULL, 0x100fe4000001167fULL, 0x000000ff7f947812ULL, 0x000fe400078ec0ffULL,
0x00000018ff937819ULL, 0x000fc4000001167fULL, 0x0000ffff7f9c7812ULL, 0x000fe400078ec0ffULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000026ff75723eULL, 0x000fe400020006ffULL,
0x00000074ff76723eULL, 0x000fe400020006ffULL, 0x00000008ff7d7819ULL, 0x000fe40000011698ULL,
0x00000077ff7f723eULL, 0x000fc400020006ffULL, 0x00000008ff747819ULL, 0x000fe40000011695ULL,
0x0000541027267816ULL, 0x000fe40000000025ULL, 0x00000008ff777819ULL, 0x000fe40000011696ULL,
0x00000008ff257819ULL, 0x000fe40000011697ULL, 0x0000541081277816ULL, 0x000fe40000000076ULL,
0x0000007dff7d723eULL, 0x000fc400020006ffULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x0000007cff81723eULL, 0x000fe200020006ffULL, 0x00000026702c723cULL, 0x082f62000000182cULL,
0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000025ff7c723eULL, 0x000fe200020006ffULL,
0x000000266c4c723cULL, 0x000f62000000184cULL, 0x000000ff8d8d7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff257819ULL, 0x000fe40000011699ULL, 0x000054107d7d7816ULL, 0x000fe4000000007eULL,
0x0000541074747816ULL, 0x000fe40000000075ULL, 0x0000008bff7e723eULL, 0x000fe400020006ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x0000541077757816ULL, 0x000fc40000000080ULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x000000ff82827812ULL, 0x000fe200078ec0ffULL, 0x000000747030723cULL, 0x000f620000001830ULL,
0x00000008ff807819ULL, 0x000fe4000001169aULL, 0x00000025ff25723eULL, 0x000fe400020006ffULL,
0x000000ff8f8f7812ULL, 0x000fc400078ec0ffULL, 0x000054107f7e7816ULL, 0x000fe2000000007eULL,
0x000000746c50723cULL, 0x000f620000001850ULL, 0x000054108e7f7816ULL, 0x000fe4000000008dULL,
0x00000082ff76723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x00000080ff8d723eULL, 0x000fe200020006ffULL, 0x0000007e703c723cULL, 0x000f62000000183cULL,
0x00005410258c7816ULL, 0x000fc4000000008cULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x000000ff89897812ULL, 0x000fe400078ec0ffULL, 0x000000ff92927812ULL, 0x000fe200078ec0ffULL,
0x0000007e6c5c723cULL, 0x000f62000000185cULL, 0x00000008ff257819ULL, 0x000fe4000001169bULL,
0x00000008ff827819ULL, 0x000fe4000001169cULL, 0x000054108d8d7816ULL, 0x000fc40000000081ULL,
0x0000541091807816ULL, 0x000fe4000000008fULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x0000008c7040723cULL, 0x000f620000001840ULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000089ff77723eULL, 0x000fe400020006ffULL,
0x00000094ff94723eULL, 0x000fc400020006ffULL, 0x00000090ff90723eULL, 0x000fe200020006ffULL,
0x0000008c6c60723cULL, 0x000f620000001860ULL, 0x00000092ff81723eULL, 0x000fe400020006ffULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x00000025ff25723eULL, 0x000fe400020006ffULL,
0x00000082ff91723eULL, 0x000fe400020006ffULL, 0x0000541088767816ULL, 0x000fc40000000076ULL,
0x000054108a777816ULL, 0x000fe40000000077ULL, 0x000054107c7c7816ULL, 0x000fe40000000083ULL,
0x0000541094817816ULL, 0x000fe40000000081ULL, 0x0000541025907816ULL, 0x000fe20000000090ULL,
0x000000767034723cULL, 0x000f620000001834ULL, 0x0000541091917816ULL, 0x000fe20000000093ULL,
0x0000000211257824ULL, 0x000fca00078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ec0ffULL,
0x0000007c7038723cULL, 0x040f700000001838ULL, 0x000000807044723cULL, 0x040f700000001844ULL,
0x000000907048723cULL, 0x000f700000001848ULL, 0x000000766c54723cULL, 0x040f700000001854ULL,
0x0000007c6c58723cULL, 0x040f700000001858ULL, 0x000000806c64723cULL, 0x040f700000001864ULL,
0x000000906c68723cULL, 0x000b6e0000001868ULL, 0x000126c80a6e7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006e6e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126900025ff7f8cULL, 0x0005e4000c80043fULL,
0x0000000000267805ULL, 0x000fc40000015200ULL, 0x0000040004257984ULL, 0x004ea40000000800ULL,
0x8000000025ff7812ULL, 0x006fc4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006c7805ULL, 0x000fcc0000015200ULL,
0x0000006c266c7210ULL, 0x000fca0007f1e1ffULL, 0x000000016d6d7824ULL, 0x000fe200000e0e27ULL,
0x003d09006c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001146dULL, 0x0000006c25257211ULL, 0x000fca00078110ffULL,
0x000000ffff6c7224ULL, 0x000fca00000e066dULL, 0x0000000225257819ULL, 0x000fc8000000126cULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040004257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010116c7824ULL, 0x000fe400078e00ffULL,
0x0000590022227a24ULL, 0x010fe400078e02ffULL, 0x00000080ff277424ULL, 0x000fe200078e00ffULL,
0xffffffe06c257812ULL, 0x000fe200078ec0ffULL, 0x0000004022267824ULL, 0x000fc800078e00ffULL,
0x0000010006257824ULL, 0x000fe400078e0225ULL, 0x0000640026267625ULL, 0x000fc600078e0027ULL,
0x000000c025257810ULL, 0x000fc80007ffe0ffULL, 0x0000002025227812ULL, 0x000fca00078ec0ffULL,
0x0000000109727824ULL, 0x000fe200078e0222ULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x000000250e227217ULL, 0x000fe40007800000ULL, 0x000000106c6d7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff6c7819ULL, 0x000fe2000001160fULL, 0x0000000122227824ULL, 0x000fc600078e0a25ULL,
0x000000046c6f7810ULL, 0x040fe20007ffe0ffULL, 0x000000016c257824ULL, 0x040fe200078e026dULL,
0x000000226d227217ULL, 0x000fe40007800000ULL, 0x000000086c707810ULL, 0x040fe20007ffe0ffULL,
0x00000001256e7824ULL, 0x040fe200078e020fULL, 0x0000000c6c717810ULL, 0x000fe20007ffe0ffULL,
0x0000000825777824ULL, 0x000fe400078e00ffULL, 0x0000000122227824ULL, 0x100fe400078e0a6dULL,
0x0000000171747824ULL, 0x100fe200078e026dULL, 0xfffffff877777812ULL, 0x000fe200078ee26eULL,
0x000000016f6e7824ULL, 0x000fe200078e026dULL, 0x000000226c00720cULL, 0x080fe20003f86070ULL,
0x00000001256c7824ULL, 0x000fe200078e0272ULL, 0x000000226f00720cULL, 0x080fe20003f66070ULL,
0x000000016e257824ULL, 0x000fe200078e020fULL, 0x000000227000720cULL, 0x080fe20003f46070ULL,
0x000000086e767824ULL, 0x000fe200078e00ffULL, 0x000000227100720cULL, 0x000fe20003f06070ULL,
0x00000001706f7824ULL, 0x000fc400078e026dULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0xfffffff8767d7812ULL, 0x000fc600078ee225ULL, 0x000000016e6e7824ULL, 0x100fe200078e0272ULL,
0x000000026c257212ULL, 0x000fe200078efcffULL, 0x000000016f707824ULL, 0x040fe400078e0272ULL,
0x000000016f227824ULL, 0x040fe200078e020fULL, 0x00000025266c7210ULL, 0x000fe20007fbe0ffULL,
0x000000086f7f7824ULL, 0x000fe400078e00ffULL, 0x000000806e6e7825ULL, 0x000fc600078e00ffULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee222ULL, 0x0000000174727824ULL, 0x000fe200078e0272ULL,
0x000000026e257212ULL, 0x000fe200078efcffULL, 0x0000008070707825ULL, 0x000fc800078e00ffULL,
0x0000008072727825ULL, 0x000fe200078e00ffULL, 0x0000000270757212ULL, 0x000fc600078efcffULL,
0x00000001276d7824ULL, 0x040fe200028e066dULL, 0x00000025266e7210ULL, 0x000fe20007fbe0ffULL,
0x0000000174227824ULL, 0x000fe200078e020fULL, 0x0000000272257212ULL, 0x000fe200078efcffULL,
0x0000000874817824ULL, 0x000fe400078e00ffULL, 0x00000001276f7824ULL, 0x000fe200028e066fULL,
0x0000007526707210ULL, 0x040fe20007fbe0ffULL, 0x000000107f757824ULL, 0x100fe200078e0228ULL,
0x0000002526267210ULL, 0x000fe20007fde0ffULL, 0x0000001077257824ULL, 0x000fe200078e0228ULL,
0xfffffff881817812ULL, 0x000fe200078ee222ULL, 0x0000000127717824ULL, 0x000fc400028e0671ULL,
0x0000000127277824ULL, 0x000fe200030e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c257faeULL, 0x0003e2000e101c46ULL, 0x000000107d737824ULL, 0x100fe400078e0228ULL,
0x0000001081777824ULL, 0x000fc600078e0228ULL, 0x000000006e737faeULL, 0x0003e8000d901c46ULL,
0x0000000070757faeULL, 0x0003e8000d101c46ULL, 0x0000000026777faeULL, 0x0003e2000c101c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x000000106c6c7812ULL, 0x000fc800078ec0ffULL,
0x0000006c0f227211ULL, 0x000fc800078fe8ffULL, 0x00000004226e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000122257824ULL, 0x140fe200078e020fULL, 0x0000000822707810ULL, 0x040fe20007ffe0ffULL,
0x0000000822747824ULL, 0x000fe400078e00ffULL, 0x000000016e6c7824ULL, 0x040fe400078e020fULL,
0x000000086e7f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8747d7812ULL, 0x000fe200078ee225ULL,
0x00000001706d7824ULL, 0x040fe400078e020fULL, 0x0000000870767824ULL, 0x000fe200078e00ffULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee26cULL, 0x00000001226c7824ULL, 0x140fe200078e0272ULL,
0x0000000c22227810ULL, 0x000fe20007ffe0ffULL, 0x000000016e6e7824ULL, 0x000fe200078e0272ULL,
0xfffffff876817812ULL, 0x000fe200078ee26dULL, 0x000000806c6c7825ULL, 0x000fc800078e00ffULL,
0x0000000170707824ULL, 0x100fe200078e0272ULL, 0x000000026c257212ULL, 0x000fe200078efcffULL,
0x0000000122727824ULL, 0x000fe400078e0272ULL, 0x000000806e6e7825ULL, 0x000fe200078e00ffULL,
0x00000025266c7210ULL, 0x000fc60007f1e0ffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000026e777212ULL, 0x000fc600078efcffULL, 0x0000008072727825ULL, 0x000fe200078e00ffULL,
0x0000000270757212ULL, 0x080fe400078efcffULL, 0x00000077266e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000122747824ULL, 0x000fe200078e020fULL, 0x0000000272257212ULL, 0x000fe200078efcffULL,
0x0000000822837824ULL, 0x000fe400078e00ffULL, 0x00000001276d7824ULL, 0x040fe200000e066dULL,
0x0000007526707210ULL, 0x040fe20007f1e0ffULL, 0x00000001276f7824ULL, 0x000fe200010e066fULL,
0x0000002526267210ULL, 0x000fe20007f7e0ffULL, 0x000000107d257824ULL, 0x000fe200078e0228ULL,
0xfffffff883837812ULL, 0x000fe200078ee274ULL, 0x0000000127717824ULL, 0x000fc400000e0671ULL,
0x0000000127277824ULL, 0x000fe200018e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c257faeULL, 0x0003e2000b901c46ULL, 0x000000107f737824ULL, 0x100fe400078e0228ULL,
0x0000001081757824ULL, 0x100fe400078e0228ULL, 0x0000001083777824ULL, 0x000fe200078e0228ULL,
0x000000006e737faeULL, 0x0003e8000b901c46ULL, 0x0000000070757faeULL, 0x0003e8000b901c46ULL,
0x0000000026777faeULL, 0x0003e4000b901c46ULL, 0x0000000811257824ULL, 0x002fe200078e00ffULL,
0x0000000308267810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff227424ULL, 0x000fc600078e00ffULL,
0xfffffff025257812ULL, 0x000fe400078ec0ffULL, 0x0000000d2600720cULL, 0x000fe40003f06070ULL,
0x00000000250473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000000107268824ULL, 0x000fc400078e0226ULL, 0x00000004ff278424ULL, 0x000fc800078e00ffULL,
0x0000660026268625ULL, 0x000fca00078e0027ULL, 0x0000000626228981ULL, 0x000522000c1e1900ULL,
0x000126b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0126b000256e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126480003707f8cULL, 0x000664000c80043fULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0x01264c0003257984ULL, 0x002e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804871ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006c7805ULL, 0x000fcc0000015200ULL, 0x0000006c266c7210ULL, 0x000fca0007f1e1ffULL,
0x000000016d6d7824ULL, 0x000fe200000e0e27ULL, 0x003d09006c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc8000001146dULL,
0x0000006c25257211ULL, 0x000fca00078110ffULL, 0x000000ffff6c7224ULL, 0x000fca00000e066dULL,
0x0000000225257819ULL, 0x000fc8000000126cULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01264c0003257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002011037824ULL, 0x008fca00078e00ffULL, 0xffffff8003037812ULL, 0x000fc800078ec0ffULL,
0x0000010002037810ULL, 0x000fca0007ffe003ULL, 0x0000000178037824ULL, 0x000fca00078e0203ULL,
0x0120000003707984ULL, 0x000e680000000800ULL, 0x0122000003717984ULL, 0x0006a20000000800ULL,
0x000000237000720bULL, 0x002fe20003f1d000ULL, 0x0000ef827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000727806ULL, 0x008fc800000e0100ULL, 0x000000ff7200720cULL, 0x000fe20003f05270ULL,
0x0000078000007945ULL, 0x000fe20003800000ULL, 0x00000001ff257424ULL, 0x000fe400078e00ffULL,
0x000000ffff037224ULL, 0x000fd200078e0023ULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x000000020b267810ULL, 0x000fe40007ffe0ffULL, 0x000000237000720bULL, 0x000fe40003f54000ULL,
0x000000112600720cULL, 0x000fe20003f05270ULL, 0x0000ef327f007947ULL, 0x000fd4000b800000ULL,
0x0000000000037806ULL, 0x000fc400010e0100ULL, 0x0000008011278824ULL, 0x000fe200078e0202ULL,
0x0000002370258209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000178268824ULL, 0x000fca00078e0227ULL, 0x0124002526008388ULL, 0x0003e20000000800ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000002370267209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff03ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002326257221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL, 0x0000002500737308ULL, 0x000e640000000800ULL,
0x0000007324247220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff277819ULL, 0x000fe2000001160fULL, 0x0000ee627f007947ULL, 0x000fea000b800000ULL,
0x00001f2773267589ULL, 0x0002e400000e0000ULL, 0x000000262c2c7220ULL, 0x08cfe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x0000002644447220ULL, 0x080fe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0003ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080f277811ULL, 0x002fe200078ff0ffULL,
0x0000ed327f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000262e2e7220ULL, 0x08cfe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x0000002646467220ULL, 0x080fe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000003ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000100f277811ULL, 0x002fe200078ff0ffULL, 0x0000ec027f007947ULL, 0x000fea000b800000ULL,
0x00001f2773267589ULL, 0x0002e400000e0000ULL, 0x000000264c4c7220ULL, 0x08cfe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x0000002664647220ULL, 0x080fe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002668687220ULL, 0x080fe20000410000ULL,
0x0000002669697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000003ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000180f277811ULL, 0x002fe200078ff0ffULL, 0x0000eae27f007947ULL, 0x000fea000b800000ULL,
0x00001f2773267589ULL, 0x0002e400000e0000ULL, 0x000000264e4e7220ULL, 0x08cfe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x0000002666667220ULL, 0x080fe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x000000266a6a7220ULL, 0x080fe20000410000ULL,
0x000000266b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000000372ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff257424ULL, 0x000fe200078e00ffULL,
0x0000002370037209ULL, 0x000fd60007810000ULL, 0x8000000370700221ULL, 0x000fe20000010000ULL,
0x00007610ff250816ULL, 0x000fc60000000025ULL, 0x3fb8aa3b70700820ULL, 0x000fc80000410000ULL,
0x0000007000000308ULL, 0x000e640000000800ULL, 0x0000000071710220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002471247221ULL, 0x004fc20000010000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000000811237824ULL, 0x000fca00078e00ffULL,
0xfffffff023707812ULL, 0x000fca00078ec0ffULL, 0x0126ac0070237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006c7805ULL, 0x000fcc0000015200ULL,
0x0000006c266c7210ULL, 0x000fca0007f1e1ffULL, 0x000000016d6d7824ULL, 0x000fe200000e0e27ULL,
0x003d09006c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc8000001146dULL, 0x0000006c23237211ULL, 0x000fca00078110ffULL,
0x000000ffff6c7224ULL, 0x000fca00000e066dULL, 0x0000000223237819ULL, 0x000fc8000000126cULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000171717810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126ac0070237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991025237816ULL, 0x000fc800000000ffULL,
0x000000ff2300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000000ff13723eULL, 0x000fe400000000ffULL, 0x00000002ff237819ULL, 0x000fe4000001160fULL,
0x0000541013167816ULL, 0x000fe20000000013ULL, 0x0000e6a27f007947ULL, 0x000fea000b800000ULL,
0x00001f2316137589ULL, 0x0002a400000e0000ULL, 0x0000000823277810ULL, 0x002fe20007ffe0ffULL,
0x0000e6d27f007947ULL, 0x000fea000b800000ULL, 0x0000001023157810ULL, 0x000fe20007ffe0ffULL,
0x00001f2716147589ULL, 0x0002ea00000e0000ULL, 0x00001f1516157589ULL, 0x0002a400000e0000ULL,
0x0000001823277810ULL, 0x002fe20007ffe0ffULL, 0x0000e7227f007947ULL, 0x000fea000b800000ULL,
0x00001f2716167589ULL, 0x0002e400000e0000ULL, 0x0000040011237824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100011257824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00023237812ULL, 0x000fc400078ec0ffULL,
0xffffe00025257812ULL, 0x000fe400078ec0ffULL, 0x0000c00023237810ULL, 0x000fe40007ffe0ffULL,
0x0000e00025257810ULL, 0x000fc60007ffe0ffULL, 0x0000001018187824ULL, 0x100fe400078e0223ULL,
0x000000101a1a7824ULL, 0x000fe400078e0223ULL, 0x000000101b7c7824ULL, 0x000fe200078e0225ULL,
0x000000001874783bULL, 0x0002e80000000200ULL, 0x000000001a70783bULL, 0x0002a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001374747232ULL, 0x08cfe40000000000ULL,
0x0000001376767232ULL, 0x000fc40000000000ULL, 0x0000001475757232ULL, 0x080fe40000000000ULL,
0x0000001477777232ULL, 0x000fe40000000000ULL, 0x0000001570707232ULL, 0x080fe40000000000ULL,
0x0000001572727232ULL, 0x000fe40000000000ULL, 0x0000001671717232ULL, 0x080fe40000000000ULL,
0x0000001673737232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007c7c783bULL, 0x000e620000004200ULL, 0x000000101c807824ULL, 0x000fe200078e0225ULL,
0x0000081000007945ULL, 0x000fea0003800000ULL, 0x000000008080783bULL, 0x000ee20000004200ULL,
0x00000010ff257819ULL, 0x002fc4000001167dULL, 0x000000ff7d2a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff277819ULL, 0x000fe4000001167dULL, 0x0000ffff7d937812ULL, 0x000fe400078ec0ffULL,
0x000000ff7f7d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff187819ULL, 0x000fe4000001167cULL,
0x000000ff7c1c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff1a7819ULL, 0x000fe4000001167cULL,
0x0000ffff7c927812ULL, 0x000fe400078ec0ffULL, 0x00000018ff2b7819ULL, 0x100fe4000001167eULL,
0x00000010ff6d7819ULL, 0x000fe4000001167eULL, 0x000000ff7e7c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff7e947812ULL, 0x000fc400078ec0ffULL, 0x00000010ff7e7819ULL, 0x100fe4000001167fULL,
0x00000018ff887819ULL, 0x000fe4000001167fULL, 0x0000ffff7f957812ULL, 0x000fe400078ec0ffULL,
0x0000007dff7f723eULL, 0x000fe400020006ffULL, 0x0000002bff7d723eULL, 0x000fe400020006ffULL,
0x00000008ff2b7819ULL, 0x000fc40000011693ULL, 0x000000ff18187812ULL, 0x000fe400078ec0ffULL,
0x000000ff25257812ULL, 0x000fe400078ec0ffULL, 0x0000001cff26723eULL, 0x000fe400020006ffULL,
0x00000027ff6c723eULL, 0x000fe400020006ffULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x0000002aff2a723eULL, 0x000fc400020006ffULL, 0x0000001aff1c723eULL, 0x000fe400020006ffULL,
0x00000018ff18723eULL, 0x000fe400020006ffULL, 0x00000025ff25723eULL, 0x000fe400020006ffULL,
0x000000ff6d6d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff1a7819ULL, 0x000fe40000011692ULL,
0x000054102b2b7816ULL, 0x000fc4000000006cULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000541026267816ULL, 0x000fe40000000018ULL, 0x000054102a277816ULL, 0x000fe40000000025ULL,
0x0000006dff6c723eULL, 0x000fe400020006ffULL, 0x0000001aff2a723eULL, 0x000fe400020006ffULL,
0x00000008ff187819ULL, 0x000fe20000011694ULL, 0x00000026742c723cULL, 0x008f62000000182cULL,
0x00000010ff897819ULL, 0x000fc40000011680ULL, 0x00000008ff1a7819ULL, 0x000fe40000011695ULL,
0x0000ffff80967812ULL, 0x000fe400078ec0ffULL, 0x000054107c6c7816ULL, 0x000fe2000000006cULL,
0x00000026704c723cULL, 0x004f62000000184cULL, 0x000000ff808b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8a7819ULL, 0x000fe40000011680ULL, 0x000000ff7e7e7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff7c723eULL, 0x000fe400020006ffULL, 0x00000010ff807819ULL, 0x100fe40000011681ULL,
0x000000ff818d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff8c7819ULL, 0x000fe40000011681ULL,
0x0000ffff81977812ULL, 0x000fe400078ec0ffULL, 0x00000088ff88723eULL, 0x000fc400020006ffULL,
0x0000001aff1a723eULL, 0x000fe400020006ffULL, 0x000000ff89897812ULL, 0x000fe400078ec0ffULL,
0x00000010ff817819ULL, 0x000fe40000011682ULL, 0x00000008ff187819ULL, 0x000fe40000011696ULL,
0x0000007eff6d723eULL, 0x000fe400020006ffULL, 0x000054107c7c7816ULL, 0x000fc4000000007dULL,
0x00000018ff8e7819ULL, 0x000fe40000011682ULL, 0x000000ff828f7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff82987812ULL, 0x000fe400078ec0ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x000054101a7d7816ULL, 0x000fe40000000088ULL, 0x00000089ff7e723eULL, 0x000fc400020006ffULL,
0x00000010ff827819ULL, 0x100fe40000011683ULL, 0x00000018ff907819ULL, 0x000fe20000011683ULL,
0x0000007c7438723cULL, 0x080f620000001838ULL, 0x000000ff83917812ULL, 0x000fe400078ec0ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000008ff1a7819ULL, 0x000fe40000011697ULL,
0x00000018ff18723eULL, 0x000fe200020006ffULL, 0x0000007c7058723cULL, 0x000b620000001858ULL,
0x000000ff81817812ULL, 0x000fc400078ec0ffULL, 0x0000ffff83837812ULL, 0x000fe400078ec0ffULL,
0x000000ff80807812ULL, 0x000fe400078ec0ffULL, 0x000054108b7e7816ULL, 0x000fe2000000007eULL,
0x00000010207c7824ULL, 0x020fe200078e021fULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x0000001aff8b723eULL, 0x000fe400020006ffULL, 0x00005410188a7816ULL, 0x000fc4000000008aULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x000000ff82827812ULL, 0x000fe400078ec0ffULL,
0x00000008ff187819ULL, 0x000fe40000011698ULL, 0x00000008ff1a7819ULL, 0x000fe40000011683ULL,
0x000054107f6d7816ULL, 0x000fe4000000006dULL, 0x00000080ff7f723eULL, 0x000fc400020006ffULL,
0x000054108f807816ULL, 0x000fe40000000081ULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x0000006c7434723cULL, 0x080f620000001834ULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x0000006c7054723cULL, 0x000f620000001854ULL,
0x00000090ff90723eULL, 0x000fc400020006ffULL, 0x00000018ff18723eULL, 0x000fe400020006ffULL,
0x0000001aff8f723eULL, 0x000fe400020006ffULL, 0x000054102a2a7816ULL, 0x000fe4000000001cULL,
0x000054108d7f7816ULL, 0x000fe4000000007fULL, 0x000054108b8b7816ULL, 0x000fe4000000008cULL,
0x0000541091817816ULL, 0x000fe20000000082ULL, 0x0000002a7430723cULL, 0x000f620000001830ULL,
0x00005410188e7816ULL, 0x000fc4000000008eULL, 0x000054108f8f7816ULL, 0x000fca0000000090ULL,
0x0000007e743c723cULL, 0x040f70000000183cULL, 0x0000008a7440723cULL, 0x040f700000001840ULL,
0x000000807444723cULL, 0x040f700000001844ULL, 0x0000008e7448723cULL, 0x000b6e0000001848ULL,
0x000000101d747824ULL, 0x120fe200078e0223ULL, 0x0000002a7050723cULL, 0x000f620000001850ULL,
0x000000101e237824ULL, 0x000fc800078e0223ULL, 0x000000007474783bULL, 0x000e660000000200ULL,
0x0000007e705c723cULL, 0x040f70000000185cULL, 0x0000008a7060723cULL, 0x040f700000001860ULL,
0x000000807064723cULL, 0x040f700000001864ULL, 0x0000008e7068723cULL, 0x000b640000001868ULL,
0x000000002370783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000001374747232ULL, 0x082fe40000000000ULL,
0x0000001376767232ULL, 0x000fc40000000000ULL, 0x0000001475757232ULL, 0x080fe40000000000ULL,
0x0000001477777232ULL, 0x000fe40000000000ULL, 0x0000001570707232ULL, 0x088fe40000000000ULL,
0x0000001572727232ULL, 0x000fe40000000000ULL, 0x0000001671717232ULL, 0x080fe40000000000ULL,
0x0000001673737232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007c7c783bULL, 0x000ea20000004200ULL, 0x0000001021807824ULL, 0x000fcc00078e021fULL,
0x000000008080783bULL, 0x000ee20000004200ULL, 0x00000018ff237819ULL, 0x004fe4000001167dULL,
0x0000ffff7d917812ULL, 0x000fe400078ec0ffULL, 0x00000010ff187819ULL, 0x000fe4000001167cULL,
0x000000ff7e277812ULL, 0x000fe400078ec0ffULL, 0x00000023ff2a723eULL, 0x000fe400020006ffULL,
0x000000ff7c1c7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff237819ULL, 0x000fe40000011691ULL,
0x00000018ff1a7819ULL, 0x000fe4000001167cULL, 0x00000010ff2b7819ULL, 0x000fe4000001167eULL,
0x000000ff18187812ULL, 0x000fe400078ec0ffULL, 0x0000ffff7c907812ULL, 0x000fe400078ec0ffULL,
0x00000027ff6c723eULL, 0x000fc400020006ffULL, 0x000000ff7f6d7812ULL, 0x000fe400078ec0ffULL,
0x0000001cff20723eULL, 0x000fe400020006ffULL, 0x00000023ff27723eULL, 0x000fe400020006ffULL,
0x00000018ff267819ULL, 0x000fe4000001167eULL, 0x0000001aff1c723eULL, 0x000fe400020006ffULL,
0x00000018ff18723eULL, 0x000fc400020006ffULL, 0x000000ff2b2b7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff7e927812ULL, 0x000fe400078ec0ffULL, 0x00000008ff1a7819ULL, 0x000fe40000011690ULL,
0x0000ffff7f937812ULL, 0x000fe400078ec0ffULL, 0x0000006dff7e723eULL, 0x000fe400020006ffULL,
0x0000541027277816ULL, 0x000fc4000000002aULL, 0x00000010ff217819ULL, 0x000fe4000001167dULL,
0x000000ff7d257812ULL, 0x000fe400078ec0ffULL, 0x00000026ff6d723eULL, 0x000fe400020006ffULL,
0x0000541020207816ULL, 0x000fe40000000018ULL, 0x0000002bff2a723eULL, 0x000fe400020006ffULL,
0x00000010ff7c7819ULL, 0x000fc4000001167fULL, 0x00000018ff7d7819ULL, 0x000fe4000001167fULL,
0x0000001aff26723eULL, 0x000fe400020006ffULL, 0x00000008ff187819ULL, 0x000fe40000011692ULL,
0x00000010ff7f7819ULL, 0x008fe40000011680ULL, 0x00000008ff1a7819ULL, 0x000fe40000011693ULL,
0x0000ffff80947812ULL, 0x000fc400078ec0ffULL, 0x000054106c2a7816ULL, 0x000fe4000000002aULL,
0x000000ff80897812ULL, 0x000fe400078ec0ffULL, 0x00000018ff887819ULL, 0x000fe40000011680ULL,
0x000000ff7c7c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6c723eULL, 0x000fe400020006ffULL,
0x00000010ff807819ULL, 0x000fc40000011681ULL, 0x000000ff818b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8a7819ULL, 0x000fe40000011681ULL, 0x0000ffff81957812ULL, 0x000fe400078ec0ffULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x0000001aff1a723eULL, 0x000fe400020006ffULL,
0x000000ff7f7f7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff817819ULL, 0x000fe40000011682ULL,
0x00000008ff187819ULL, 0x000fe40000011694ULL, 0x0000007cff2b723eULL, 0x000fe400020006ffULL,
0x000054106c6c7816ULL, 0x000fe4000000006dULL, 0x00000018ff8c7819ULL, 0x000fe40000011682ULL,
0x000000ff828d7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff82967812ULL, 0x000fe400078ec0ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x000054101a6d7816ULL, 0x000fe4000000007dULL,
0x0000007fff7c723eULL, 0x000fe400020006ffULL, 0x00000010ff827819ULL, 0x100fe40000011683ULL,
0x00000018ff8e7819ULL, 0x000fe20000011683ULL, 0x0000006c7438723cULL, 0x002b620000001838ULL,
0x000000ff838f7812ULL, 0x000fc400078ec0ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000008ff1a7819ULL, 0x000fe40000011695ULL, 0x00000018ff18723eULL, 0x000fe200020006ffULL,
0x0000006c7058723cULL, 0x000b620000001858ULL, 0x000000ff81817812ULL, 0x000fe400078ec0ffULL,
0x0000ffff83837812ULL, 0x000fe400078ec0ffULL, 0x00005410897c7816ULL, 0x000fc4000000007cULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x0000001aff89723eULL, 0x000fe400020006ffULL,
0x0000541018887816ULL, 0x000fe40000000088ULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x000000ff21217812ULL, 0x000fe400078ec0ffULL, 0x000000ff80807812ULL, 0x000fc400078ec0ffULL,
0x000000ff82827812ULL, 0x000fe400078ec0ffULL, 0x00000008ff187819ULL, 0x000fe40000011696ULL,
0x00000008ff1a7819ULL, 0x000fe40000011683ULL, 0x000054107e2b7816ULL, 0x000fe4000000002bULL,
0x000054108d7e7816ULL, 0x000fe40000000081ULL, 0x00000025ff25723eULL, 0x000fc400020006ffULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x0000002a7434723cULL, 0x080b620000001834ULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x00000080ff7d723eULL, 0x000fe200020006ffULL,
0x0000002a7054723cULL, 0x000b620000001854ULL, 0x0000008fff7f723eULL, 0x000fc400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000018ff18723eULL, 0x000fe400020006ffULL, 0x0000001aff8d723eULL, 0x000fe400020006ffULL,
0x0000541025217816ULL, 0x000fe40000000021ULL, 0x0000541026267816ULL, 0x000fc4000000001cULL,
0x000054108b7d7816ULL, 0x000fe4000000007dULL, 0x0000541089897816ULL, 0x000fe2000000008aULL,
0x00000020742c723cULL, 0x040b62000000182cULL, 0x000054107f7f7816ULL, 0x000fe40000000082ULL,
0x00005410188c7816ULL, 0x000fe2000000008cULL, 0x0000000211187824ULL, 0x000fe200078e00ffULL,
0x000054108d8d7816ULL, 0x000fe4000000008eULL, 0x000126c80a1c7811ULL, 0x000fe200078e18ffULL,
0x000000267430723cULL, 0x000b620000001830ULL, 0xfffffff818187812ULL, 0x000fce00078ec0ffULL,
0x0000007c743c723cULL, 0x040b70000000183cULL, 0x000000887440723cULL, 0x040b700000001840ULL,
0x0000007e7444723cULL, 0x040b700000001844ULL, 0x0000008c7448723cULL, 0x000b700000001848ULL,
0x00000020704c723cULL, 0x040b70000000184cULL, 0x000000267050723cULL, 0x040b700000001850ULL,
0x0000007c705c723cULL, 0x040b70000000185cULL, 0x000000887060723cULL, 0x040b700000001860ULL,
0x0000007e7064723cULL, 0x040b700000001864ULL, 0x0000008c7068723cULL, 0x000b620000001868ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000001c2a7f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126980018ff7f8cULL, 0x0007e4000c80043fULL, 0x0000000000207805ULL, 0x000fc40000015200ULL,
0x000004001c237984ULL, 0x000e620000000800ULL, 0x000000030b187810ULL, 0x008fc40007ffe0ffULL,
0x8000000023ff7812ULL, 0x006fe2000780482bULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000022000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6c7224ULL, 0x000fe400078e00ffULL,
0x000000ffff257224ULL, 0x000fe200078e0018ULL, 0x000001e000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000106c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002620237210ULL, 0x000fca0007f1e1ffULL, 0x0000000127267824ULL, 0x000fe200000e0e21ULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1a7819ULL, 0x000fc80000011426ULL, 0x000000231a1a7211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0626ULL, 0x000000021a1a7819ULL, 0x000fc80000001223ULL,
0x0000001a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016c6c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x000004001c237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff257224ULL, 0x000fc400078e0018ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000106237810ULL, 0x000fe40007ffe0ffULL,
0x0000000308087810ULL, 0x000fe40007ffe0ffULL, 0x0000000c2300720cULL, 0x000fda0003f06070ULL,
0x0000083000000947ULL, 0x000fea0003800000ULL, 0x0000000206217810ULL, 0x000fe20007ffe0ffULL,
0x0000010023237824ULL, 0x000fe400078e0284ULL, 0x0000590022227a24ULL, 0x010fe200078e02ffULL,
0x0000000c2100720cULL, 0x000fe20003f06070ULL, 0x00000080ff217424ULL, 0x000fe200078e00ffULL,
0x0000002023087812ULL, 0x000fe200078ec0ffULL, 0x0000004022207824ULL, 0x000fc800078e00ffULL,
0x00000001096c7824ULL, 0x000fe400078e0208ULL, 0x0000640020207625ULL, 0x000fc800078e0021ULL,
0x000003e000008947ULL, 0x000fea0003800000ULL, 0x000000230e087217ULL, 0x000fe20007800000ULL,
0x0000001011187824ULL, 0x000fc800078e00ffULL, 0x0000000108087824ULL, 0x000fe200078e0a23ULL,
0x0000001018237812ULL, 0x000fe400078ec0ffULL, 0x00000003ff187819ULL, 0x000fe4000001160fULL,
0x0000000823087217ULL, 0x000fe40007800000ULL, 0x00000004181a7810ULL, 0x040fe40007ffe0ffULL,
0x00000008181c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000108087824ULL, 0x000fe200078e0a23ULL,
0x0000000c18227810ULL, 0x000fc80007ffe0ffULL, 0x000000081800720cULL, 0x0c0fe20003f86070ULL,
0x0000000118187824ULL, 0x100fe200078e0223ULL, 0x000000081a00720cULL, 0x0c0fe20003f66070ULL,
0x000000011a1a7824ULL, 0x100fe200078e0223ULL, 0x000000081c00720cULL, 0x0c0fe20003f46070ULL,
0x000000011c1c7824ULL, 0x000fe200078e0223ULL, 0x000000082200720cULL, 0x000fe20003f06070ULL,
0x0000000118087824ULL, 0x040fe400078e020fULL, 0x0000000818277824ULL, 0x000fe400078e00ffULL,
0x00000001222b7824ULL, 0x000fc400078e0223ULL, 0x000000011a267824ULL, 0x000fe200078e026cULL,
0xfffffff827087812ULL, 0x000fe200078ee208ULL, 0x000000011c237824ULL, 0x140fe400078e020fULL,
0x000000081c2a7824ULL, 0x000fe400078e00ffULL, 0x0000000118227824ULL, 0x000fe400078e026cULL,
0x000000011a187824ULL, 0x040fe400078e020fULL, 0x000000081a6d7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a1a7812ULL, 0x000fe200078ee223ULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff86d187812ULL, 0x000fe200078ee218ULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x00000002266d7212ULL, 0x000fc600078efcffULL, 0x000000011c2a7824ULL, 0x100fe200078e026cULL,
0x0000000222717212ULL, 0x000fe200078efcffULL, 0x000000012b6c7824ULL, 0x040fe200078e026cULL,
0x0000006d20267210ULL, 0x040fe20007fde0ffULL, 0x000000012b1c7824ULL, 0x040fe200078e020fULL,
0x0000007120227210ULL, 0x000fe20007fbe0ffULL, 0x000000082b737824ULL, 0x000fe400078e00ffULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0xfffffff8731c7812ULL, 0x000fe200078ee21cULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x000000022a737212ULL, 0x000fc600078efcffULL,
0x0000000121237824ULL, 0x040fe200028e0623ULL, 0x000000026c717212ULL, 0x000fe200078efcffULL,
0x0000000121277824ULL, 0x040fe200030e0627ULL, 0x00000073202a7210ULL, 0x000fe20007fbe0ffULL,
0x0000001008757824ULL, 0x100fe200078e021fULL, 0x0000007120207210ULL, 0x000fe20007fde0ffULL,
0x0000001018777824ULL, 0x100fe400078e021fULL, 0x000000101a717824ULL, 0x000fe200078e021fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022757faeULL, 0x0003e2000e101c46ULL,
0x00000001212b7824ULL, 0x000fc400028e062bULL, 0x000000101c1f7824ULL, 0x000fe200078e021fULL,
0x0000000026777faeULL, 0x0003e2000d901c46ULL, 0x0000000121217824ULL, 0x000fc600030e066dULL,
0x000000002a717faeULL, 0x0003e8000d101c46ULL, 0x00000000201f7faeULL, 0x0003e2000c101c46ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001011087824ULL, 0x000fca00078e00ffULL,
0x0000001008087812ULL, 0x000fc800078ec0ffULL, 0x000000080f087211ULL, 0x000fc800078fe8ffULL,
0x00000004081a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000108187824ULL, 0x040fe200078e020fULL,
0x0000000808277810ULL, 0x040fe20007ffe0ffULL, 0x0000000808237824ULL, 0x040fe200078e00ffULL,
0x0000000c082b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000108227824ULL, 0x100fe400078e026cULL,
0x000000011a087824ULL, 0x000fe200078e026cULL, 0xfffffff823187812ULL, 0x000fe200078ee218ULL,
0x0000008022227825ULL, 0x000fc800078e00ffULL, 0x000000011a1c7824ULL, 0x100fe200078e020fULL,
0x00000002226d7212ULL, 0x000fe200078efcffULL, 0x000000081a717824ULL, 0x000fe400078e00ffULL,
0x0000000127267824ULL, 0x100fe400078e026cULL, 0x000000012b2a7824ULL, 0x040fe200078e026cULL,
0x0000006d206c7210ULL, 0x000fe20007f1e0ffULL, 0x000000012b227824ULL, 0x100fe200078e020fULL,
0xfffffff8711c7812ULL, 0x000fe200078ee21cULL, 0x00000001271a7824ULL, 0x000fc400078e020fULL,
0x000000082b2b7824ULL, 0x000fe400078e00ffULL, 0x0000000827277824ULL, 0x000fe400078e00ffULL,
0x00000001216d7824ULL, 0x000fe200000e0623ULL, 0xfffffff82b707812ULL, 0x000fe200078ee222ULL,
0x0000008008227825ULL, 0x000fe200078e00ffULL, 0xfffffff8271a7812ULL, 0x000fc600078ee21aULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000222757212ULL, 0x000fc600078efcffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000000226737212ULL, 0x080fe400078efcffULL,
0x0000007520227210ULL, 0x000fe20007f1e0ffULL, 0x0000001018777824ULL, 0x100fe200078e021fULL,
0x000000022a717212ULL, 0x000fe200078efcffULL, 0x000000101c7d7824ULL, 0x000fe200078e021fULL,
0x0000007320267210ULL, 0x040fe20007f5e0ffULL, 0x0000000121237824ULL, 0x040fe200000e0623ULL,
0x0000007120207210ULL, 0x000fe20007f7e0ffULL, 0x000000101a7f7824ULL, 0x000fe200078e021fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006c777faeULL, 0x0003e2000b901c46ULL,
0x0000000121277824ULL, 0x000fc400010e0627ULL, 0x00000010701f7824ULL, 0x000fe200078e021fULL,
0x00000000227d7faeULL, 0x0003e2000b901c46ULL, 0x0000000121217824ULL, 0x000fc600018e062bULL,
0x00000000267f7faeULL, 0x0003e8000b901c46ULL, 0x00000000201f7faeULL, 0x0003e4000b901c46ULL,
0x0000000405087810ULL, 0x000fe20007ffe0ffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0xffffffffff227424ULL, 0x002fe400078e00ffULL, 0x0000000d0800720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000107227824ULL, 0x000fe400078e0208ULL,
0x00000004ff237424ULL, 0x000fc800078e00ffULL, 0x0000660022227625ULL, 0x000fcc00078e0023ULL,
0x0000000622227981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000811187824ULL, 0x000fe400078e00ffULL, 0x000000020b057824ULL, 0x000fc600078e0279ULL,
0xfffffff018207812ULL, 0x040fe400078ec0ffULL, 0x0000000818187812ULL, 0x000fe400078ec0ffULL,
0x00000000200473c2ULL, 0x000ea600000e0000ULL, 0x0000001005057824ULL, 0x000fe400078e0018ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000126a804047890ULL, 0x004fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126a80020207f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01266800052a7f8cULL, 0x000662000c80043fULL,
0x000000ffff187224ULL, 0x004fc600078e0021ULL, 0x0000000000207805ULL, 0x000fc80000015200ULL,
0x01266c00051f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x006fe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026201f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127267824ULL, 0x000fe200000e0e21ULL, 0x003d09001f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1a7819ULL, 0x000fc80000011426ULL,
0x0000001f1a1a7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e0626ULL,
0x000000021a1a7819ULL, 0x000fc8000000121fULL, 0x0000001a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01266c00051f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008025257824ULL, 0x000fc800078e0202ULL, 0x0000000178257824ULL, 0x000fca00078e0225ULL,
0x0120000025207984ULL, 0x000e680000000800ULL, 0x0122000025057984ULL, 0x0084e20000000800ULL,
0x000000032000720bULL, 0x002fe20003f1d000ULL, 0x0000c6927f007947ULL, 0x000fd8000b800000ULL,
0x00000000001c7806ULL, 0x004fc800000e0100ULL, 0x000000ff1c00720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1a7224ULL, 0x000fd200078e0003ULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x000000030b1a7810ULL, 0x000fe40007ffe0ffULL, 0x000000032000720bULL, 0x000fe40003f54000ULL,
0x000000111a00720cULL, 0x000fe20003f05270ULL, 0x0000c6427f007947ULL, 0x000fd4000b800000ULL,
0x00000000001f7806ULL, 0x000fc400010e0100ULL, 0x0000008011218824ULL, 0x000fe200078e0202ULL,
0x00000003201a7209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000178218824ULL, 0x000fca00078e0221ULL, 0x0124001a21008388ULL, 0x0003e20000000800ULL,
0x000000ff1f00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x000000031a027221ULL, 0x002fe20000010100ULL, 0x000000ff1fff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b02027820ULL, 0x000fc80000410000ULL,
0x0000000200037308ULL, 0x000e640000000800ULL, 0x0000000324247220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x000fe2000001160fULL,
0x0000c5827f007947ULL, 0x000fea000b800000ULL, 0x00001f2703267589ULL, 0x0002a400000e0000ULL,
0x000000262c2c7220ULL, 0x084fe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x0000002644447220ULL, 0x080fe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001fff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080f277811ULL, 0x002fe200078ff0ffULL, 0x0000c4527f007947ULL, 0x000fea000b800000ULL,
0x00001f2703267589ULL, 0x0002a400000e0000ULL, 0x000000262e2e7220ULL, 0x084fe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x0000002646467220ULL, 0x080fe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00001fff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000100f277811ULL, 0x002fe200078ff0ffULL,
0x0000c3227f007947ULL, 0x000fea000b800000ULL, 0x00001f2703267589ULL, 0x0002a400000e0000ULL,
0x000000264c4c7220ULL, 0x084fe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x0000002664647220ULL, 0x080fe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002668687220ULL, 0x080fe20000410000ULL, 0x0000002669697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000001fff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000180f277811ULL, 0x002fe200078ff0ffULL,
0x0000c2027f007947ULL, 0x000fea000b800000ULL, 0x00001f2703267589ULL, 0x0002a400000e0000ULL,
0x000000264e4e7220ULL, 0x084fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x0000002666667220ULL, 0x080fe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x000000266a6a7220ULL, 0x080fe20000410000ULL, 0x000000266b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000001f1cff7212ULL, 0x000fe200078030ffULL,
0x00000001ff1f7424ULL, 0x000fd800078e00ffULL, 0x000000201a020221ULL, 0x000fe20000010100ULL,
0x00007610ff1f0816ULL, 0x000fc6000000001fULL, 0x3fb8aa3b02020820ULL, 0x000fc80000410000ULL,
0x0000000200000308ULL, 0x000e640000000800ULL, 0x0000000005050220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002405247221ULL, 0x008fc20000010000ULL,
0x0000000000027805ULL, 0x000fcc0000015200ULL, 0x0000000811057824ULL, 0x000fca00078e00ffULL,
0xfffffff005237812ULL, 0x000fca00078ec0ffULL, 0x0126b40023057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x00000020021c7210ULL, 0x000fca0007f1e1ffULL, 0x0000000121207824ULL, 0x000fe200000e0e03ULL,
0x003d09001c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2000720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2000720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc80000011420ULL, 0x0000001c05057211ULL, 0x000fca00078110ffULL,
0x000000ffff1c7224ULL, 0x000fca00000e0620ULL, 0x0000000205057819ULL, 0x000fc8000000121cULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126b40023057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099101f027816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0200720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000ff02723eULL, 0x000fe400000000ffULL,
0x00000002ff037819ULL, 0x000fe4000001160fULL, 0x0000541002027816ULL, 0x000fe20000000002ULL,
0x0000bdc27f007947ULL, 0x000fea000b800000ULL, 0x00001f0302137589ULL, 0x0002a400000e0000ULL,
0x0000000803277810ULL, 0x002fe20007ffe0ffULL, 0x0000bdf27f007947ULL, 0x000fea000b800000ULL,
0x0000001003157810ULL, 0x000fe20007ffe0ffULL, 0x00001f2702147589ULL, 0x0002ea00000e0000ULL,
0x00001f1502157589ULL, 0x0002a400000e0000ULL, 0x0000001803277810ULL, 0x002fe20007ffe0ffULL,
0x0000be427f007947ULL, 0x000fea000b800000ULL, 0x00001f2702167589ULL, 0x0002e400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff027819ULL, 0x002fe2000001160fULL,
0x0000000817207824ULL, 0x000fe200078e00ffULL, 0x000000030b1c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000819267824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000479027824ULL, 0x000fe200078e0202ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x00000004111f7824ULL, 0x000fc400078e00ffULL, 0x0000000117037824ULL, 0x100fe400078e0202ULL,
0x0000000119057824ULL, 0x000fe200078e0202ULL, 0x000000041f1f7812ULL, 0x000fe200078ec0ffULL,
0x000000101b747824ULL, 0x000fe200078e0228ULL, 0xfffffff820027812ULL, 0x000fe400078ee203ULL,
0x0000a0001c037811ULL, 0x000fe400078e60ffULL, 0xfffffff8261c7812ULL, 0x000fe400078ee205ULL,
0x000000021f207812ULL, 0x000fe200078efcffULL, 0x0000001002707824ULL, 0x000fc400078e0203ULL,
0x000000101c1c7824ULL, 0x000fe200078e0203ULL, 0x000000200f027211ULL, 0x000fc600078fe0ffULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000001c6c783bULL, 0x0006a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001370707232ULL, 0x086fe40000000000ULL,
0x0000001372727232ULL, 0x000fe40000000000ULL, 0x0000001471717232ULL, 0x088fe40000000000ULL,
0x0000001473737232ULL, 0x000fc40000000000ULL, 0x000000156c6c7232ULL, 0x080fe40000000000ULL,
0x000000156e6e7232ULL, 0x000fe40000000000ULL, 0x000000166d6d7232ULL, 0x080fe40000000000ULL,
0x000000166f6f7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000008171c7824ULL, 0x048fe200078e00ffULL, 0x000000007474783bULL, 0x000ee20000004200ULL,
0x0000000117177824ULL, 0x000fe200078e0202ULL, 0x0000082000007945ULL, 0x000fe20003800000ULL,
0x000000101e1e7824ULL, 0x000fc600078e0203ULL, 0xfffffff81c177812ULL, 0x000fca00078ee217ULL,
0x0000001017177824ULL, 0x000fca00078e0228ULL, 0x00000000177c783bULL, 0x0004620000004200ULL,
0x00000010ff057819ULL, 0x008fe40000011674ULL, 0x00000010ff1f7819ULL, 0x100fe40000011675ULL,
0x000000ff75237812ULL, 0x040fe400078ec0ffULL, 0x00000018ff217819ULL, 0x000fe40000011675ULL,
0x0000ffff758a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff741c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff1b7819ULL, 0x000fe40000011674ULL, 0x0000ffff74897812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2a7819ULL, 0x100fe40000011676ULL, 0x000000ff77757812ULL, 0x000fe400078ec0ffULL,
0x00000018ff177819ULL, 0x004fe40000011676ULL, 0x00000010ff747819ULL, 0x000fc40000011677ULL,
0x000000ff05057812ULL, 0x000fe400078ec0ffULL, 0x000000ff76267812ULL, 0x040fe400078ec0ffULL,
0x0000ffff768b7812ULL, 0x000fe400078ec0ffULL, 0x00000075ff76723eULL, 0x000fe400020006ffULL,
0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL, 0x0000001cff20723eULL, 0x000fc400020006ffULL,
0x00000017ff75723eULL, 0x000fe400020006ffULL, 0x00000005ff05723eULL, 0x000fe400020006ffULL,
0x000000ff74747812ULL, 0x000fe400078ec0ffULL, 0x00000008ff177819ULL, 0x000fe40000011689ULL,
0x0000ffff778c7812ULL, 0x000fe400078ec0ffULL, 0x00000026ff2b723eULL, 0x000fc400020006ffULL,
0x0000002aff2a723eULL, 0x000fe400020006ffULL, 0x0000541020207816ULL, 0x000fe40000000005ULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x00000017ff26723eULL, 0x000fe400020006ffULL,
0x00000008ff057819ULL, 0x000fe4000001168bULL, 0x00000018ff277819ULL, 0x000fc40000011677ULL,
0x00000010ff787819ULL, 0x002fe4000001167cULL, 0x00000008ff177819ULL, 0x000fe4000001168cULL,
0x0000ffff7c8d7812ULL, 0x000fe400078ec0ffULL, 0x000054102b2a7816ULL, 0x000fe4000000002aULL,
0x00005410762b7816ULL, 0x000fe40000000074ULL, 0x000000ff7c817812ULL, 0x000fc400078ec0ffULL,
0x00000018ff807819ULL, 0x000fe4000001167cULL, 0x00000005ff74723eULL, 0x000fe200020006ffULL,
0x0000002a6c54723cULL, 0x080f620000001854ULL, 0x00000010ff7c7819ULL, 0x100fe4000001167dULL,
0x000000ff7d837812ULL, 0x040fe400078ec0ffULL, 0x00000018ff827819ULL, 0x000fe4000001167dULL,
0x0000ffff7d8e7812ULL, 0x000fe200078ec0ffULL, 0x0000002a7034723cULL, 0x000f620000001834ULL,
0x00000027ff77723eULL, 0x000fc400020006ffULL, 0x00000017ff17723eULL, 0x000fe400020006ffULL,
0x000000ff78787812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7d7819ULL, 0x000fe4000001167eULL,
0x00000008ff057819ULL, 0x000fe4000001168dULL, 0x0000541074747816ULL, 0x000fe40000000075ULL,
0x000000ff7e867812ULL, 0x000fc400078ec0ffULL, 0x00000018ff857819ULL, 0x000fe4000001167eULL,
0x0000ffff7e8f7812ULL, 0x000fe400078ec0ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x0000541017757816ULL, 0x000fe40000000077ULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000010ff7e7819ULL, 0x000fc4000001167fULL, 0x000000ff7f887812ULL, 0x000fe200078ec0ffULL,
0x000000746c58723cULL, 0x080f620000001858ULL, 0x00000018ff877819ULL, 0x000fe4000001167fULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x00000008ff177819ULL, 0x000fe4000001168eULL,
0x00000005ff05723eULL, 0x000fe200020006ffULL, 0x000000747038723cULL, 0x000f620000001838ULL,
0x000000ff7d7d7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x0000541081767816ULL, 0x000fe40000000078ULL, 0x0000001bff1b723eULL, 0x000fe400020006ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000017ff81723eULL, 0x000fe400020006ffULL,
0x0000541005807816ULL, 0x000fc40000000080ULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x000000ff1f1f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff1c7819ULL, 0x000fe4000001168aULL,
0x000000ff7c7c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff7e7e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff057819ULL, 0x000fc4000001168fULL, 0x00000008ff177819ULL, 0x000fe4000001167fULL,
0x0000541026267816ULL, 0x000fe4000000001bULL, 0x0000541086867816ULL, 0x000fe4000000007dULL,
0x00000023ff23723eULL, 0x000fe400020006ffULL, 0x00000021ff25723eULL, 0x000fe400020006ffULL,
0x0000001fff1f723eULL, 0x000fc400020006ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x0000001cff27723eULL, 0x000fe400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x0000007cff77723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000085ff85723eULL, 0x000fc400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000087ff1b723eULL, 0x000fe400020006ffULL, 0x00000005ff05723eULL, 0x000fe400020006ffULL,
0x00000017ff7d723eULL, 0x000fe400020006ffULL, 0x0000541023217816ULL, 0x000fe4000000001fULL,
0x0000541027277816ULL, 0x000fc40000000025ULL, 0x0000541083777816ULL, 0x000fe40000000077ULL,
0x0000541081817816ULL, 0x000fe20000000082ULL, 0x000000206c4c723cULL, 0x040f62000000184cULL,
0x0000541088877816ULL, 0x000fe4000000007eULL, 0x00005410057c7816ULL, 0x000fe20000000085ULL,
0x000000101d057824ULL, 0x000fe200078e0203ULL, 0x000054107d7d7816ULL, 0x000fe2000000001bULL,
0x000000001e1c783bULL, 0x000e640000000200ULL, 0x000000266c50723cULL, 0x040f700000001850ULL,
0x000000766c5c723cULL, 0x040f70000000185cULL, 0x000000806c60723cULL, 0x040f700000001860ULL,
0x000000866c64723cULL, 0x040f700000001864ULL, 0x0000007c6c68723cULL, 0x000b640000001868ULL,
0x00000000056c783bULL, 0x0204ec0000000200ULL, 0x00000020702c723cULL, 0x040b70000000182cULL,
0x000000267030723cULL, 0x040b700000001830ULL, 0x00000076703c723cULL, 0x040b70000000183cULL,
0x000000807040723cULL, 0x040b700000001840ULL, 0x000000867044723cULL, 0x040b700000001844ULL,
0x0000007c7048723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x000000136c6c7232ULL, 0x08efe40000000000ULL,
0x000000136e6e7232ULL, 0x000fc40000000000ULL, 0x000000146d6d7232ULL, 0x080fe40000000000ULL,
0x000000146f6f7232ULL, 0x000fe40000000000ULL, 0x000000151c1c7232ULL, 0x080fe40000000000ULL,
0x000000151e1e7232ULL, 0x000fe40000000000ULL, 0x000000161d1d7232ULL, 0x080fe40000000000ULL,
0x000000161f1f7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x00efea0003800000ULL,
0x000000002970783bULL, 0x020e620000004200ULL, 0x0000000819037824ULL, 0x000fc400078e00ffULL,
0x0000000119027824ULL, 0x000fca00078e0202ULL, 0xfffffff803037812ULL, 0x000fca00078ee202ULL,
0x0000001003037824ULL, 0x000fca00078e0228ULL, 0x000000000374783bULL, 0x0004e20000004200ULL,
0x000000ff71197812ULL, 0x002fe400078ec0ffULL, 0x00000018ff057819ULL, 0x000fe40000011670ULL,
0x0000ffff70807812ULL, 0x000fe400078ec0ffULL, 0x00000019ff03723eULL, 0x004fe400020006ffULL,
0x00000018ff207819ULL, 0x000fe40000011671ULL, 0x00000005ff19723eULL, 0x000fc400020006ffULL,
0x00000010ff027819ULL, 0x000fe40000011670ULL, 0x00000008ff057819ULL, 0x000fe40000011680ULL,
0x0000ffff72827812ULL, 0x000fe400078ec0ffULL, 0x00000020ff23723eULL, 0x000fe400020006ffULL,
0x000000ff70177812ULL, 0x000fe400078ec0ffULL, 0x000000ff73287812ULL, 0x000fc400078ec0ffULL,
0x000000ff02027812ULL, 0x000fe400078ec0ffULL, 0x00000005ff20723eULL, 0x000fe400020006ffULL,
0x00000018ff217819ULL, 0x000fe40000011672ULL, 0x00000008ff057819ULL, 0x000fe40000011682ULL,
0x00000017ff17723eULL, 0x000fe400020006ffULL, 0x00000028ff2a723eULL, 0x000fc400020006ffULL,
0x00000002ff02723eULL, 0x000fe400020006ffULL, 0x00000010ff277819ULL, 0x000fe40000011673ULL,
0x0000ffff73837812ULL, 0x000fe400078ec0ffULL, 0x00000021ff28723eULL, 0x000fe400020006ffULL,
0x00000005ff05723eULL, 0x000fe400020006ffULL, 0x0000ffff74857812ULL, 0x008fc400078ec0ffULL,
0x00000010ff1b7819ULL, 0x000fe40000011671ULL, 0x0000ffff71817812ULL, 0x000fe400078ec0ffULL,
0x00000010ff257819ULL, 0x000fe40000011672ULL, 0x000000ff72267812ULL, 0x000fe400078ec0ffULL,
0x00000018ff297819ULL, 0x000fe40000011673ULL, 0x00000010ff707819ULL, 0x000fc40000011674ULL,
0x000000ff74727812ULL, 0x000fe400078ec0ffULL, 0x00000018ff717819ULL, 0x000fe40000011674ULL,
0x0000541017027816ULL, 0x000fe40000000002ULL, 0x00000010ff737819ULL, 0x100fe40000011675ULL,
0x000000ff75787812ULL, 0x000fe400078ec0ffULL, 0x00000018ff747819ULL, 0x000fc40000011675ULL,
0x0000ffff75867812ULL, 0x000fe400078ec0ffULL, 0x000000ff27277812ULL, 0x000fe400078ec0ffULL,
0x00000008ff177819ULL, 0x000fe40000011683ULL, 0x0000541005287816ULL, 0x000fe40000000028ULL,
0x00000010ff757819ULL, 0x000fe40000011676ULL, 0x00000008ff057819ULL, 0x000fc40000011685ULL,
0x00000029ff2b723eULL, 0x000fe400020006ffULL, 0x00000018ff7c7819ULL, 0x000fe40000011676ULL,
0x000000ff767d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff76877812ULL, 0x000fe400078ec0ffULL,
0x00000027ff27723eULL, 0x000fe400020006ffULL, 0x00000017ff29723eULL, 0x000fc400020006ffULL,
0x000000ff70707812ULL, 0x000fe400078ec0ffULL, 0x00000010ff767819ULL, 0x100fe40000011677ULL,
0x00000018ff7e7819ULL, 0x000fe40000011677ULL, 0x000000ff777f7812ULL, 0x000fe400078ec0ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000008ff177819ULL, 0x000fc40000011686ULL,
0x00000005ff05723eULL, 0x000fe400020006ffULL, 0x000000ff75757812ULL, 0x000fe400078ec0ffULL,
0x0000ffff77777812ULL, 0x000fe400078ec0ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x000054102a277816ULL, 0x000fe40000000027ULL, 0x0000541029297816ULL, 0x000fc4000000002bULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x00000017ff2b723eULL, 0x000fe200020006ffULL, 0x000000286c38723cULL, 0x000b620000001838ULL,
0x00005410052a7816ULL, 0x000fe40000000071ULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x000000ff1b1b7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff217819ULL, 0x000fe20000011681ULL,
0x000000281c58723cULL, 0x000b620000001858ULL, 0x000000ff25257812ULL, 0x000fe400078ec0ffULL,
0x000000ff73737812ULL, 0x000fe400078ec0ffULL, 0x000000ff76767812ULL, 0x000fe400078ec0ffULL,
0x00000008ff057819ULL, 0x000fe40000011687ULL, 0x00000008ff177819ULL, 0x000fc40000011677ULL,
0x0000541072727816ULL, 0x000fe40000000070ULL, 0x000054107d707816ULL, 0x000fe40000000075ULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x0000001bff1b723eULL, 0x000fe400020006ffULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000021ff21723eULL, 0x000fc400020006ffULL,
0x00000025ff25723eULL, 0x000fe400020006ffULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000076ff71723eULL, 0x000fc400020006ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00000005ff05723eULL, 0x000fe400020006ffULL,
0x00000017ff7d723eULL, 0x000fe400020006ffULL, 0x0000541003037816ULL, 0x000fe4000000001bULL,
0x0000541020207816ULL, 0x000fe40000000019ULL, 0x0000541021217816ULL, 0x000fc40000000023ULL,
0x0000541026267816ULL, 0x000fe20000000025ULL, 0x000000026c2c723cULL, 0x040b62000000182cULL,
0x0000541078737816ULL, 0x000fe40000000073ULL, 0x000054102b2b7816ULL, 0x000fe40000000074ULL,
0x000054107f717816ULL, 0x000fe40000000071ULL, 0x00005410057c7816ULL, 0x000fe2000000007cULL,
0x000000206c30723cULL, 0x000b620000001830ULL, 0x000054107d7d7816ULL, 0x000fce000000007eULL,
0x000000266c34723cULL, 0x040b700000001834ULL, 0x000000726c3c723cULL, 0x040b70000000183cULL,
0x0000002a6c40723cULL, 0x040b700000001840ULL, 0x000000706c44723cULL, 0x040b700000001844ULL,
0x0000007c6c48723cULL, 0x000b700000001848ULL, 0x000000021c4c723cULL, 0x040b70000000184cULL,
0x000000201c50723cULL, 0x040b700000001850ULL, 0x000000261c54723cULL, 0x040b700000001854ULL,
0x000000721c5c723cULL, 0x040b70000000185cULL, 0x0000002a1c60723cULL, 0x040b700000001860ULL,
0x000000701c64723cULL, 0x040b700000001864ULL, 0x0000007c1c68723cULL, 0x000b620000001868ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x0000000004047f8cULL, 0x000e62000c80043fULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x000126a00b027811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000002ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff177224ULL, 0x002fe200078e0005ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff4f3000007947ULL, 0x000fea000383ffffULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0180000024007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000cee000047802ULL, 0x000fc40000000f00ULL, 0x0000ae0000007944ULL, 0x016fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002400037308ULL, 0x004ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc80000000024ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006f00ff037624ULL, 0x000fe400078e00ffULL, 0x00006e00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000087919ULL, 0x000ea80000000000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x0000001808057811ULL, 0x044fe400078ff0ffULL,
0x0000000808097811ULL, 0x000fc400078ff0ffULL, 0x00000002ff077819ULL, 0x002fe40000011604ULL,
0x00000010080b7811ULL, 0x000fe200078ff0ffULL, 0x0000000003067220ULL, 0x008fca0000410000ULL,
0x00001f0706007589ULL, 0x000e6800000e0000ULL, 0x00001f0506057589ULL, 0x000ea800000e0000ULL,
0x00001f0906047589ULL, 0x000ee800000e0000ULL, 0x00001f0b06027589ULL, 0x000ea200000e0000ULL,
0x0000002c002c7220ULL, 0x042fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x040fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000003400347220ULL, 0x040fe20000410000ULL, 0x0000003500357220ULL, 0x040fe20000410000ULL,
0x0000003800387220ULL, 0x040fe20000410000ULL, 0x0000003900397220ULL, 0x040fe20000410000ULL,
0x0000003c003c7220ULL, 0x040fe20000410000ULL, 0x0000003d003d7220ULL, 0x040fe20000410000ULL,
0x0000004000407220ULL, 0x040fe20000410000ULL, 0x0000004100417220ULL, 0x040fe20000410000ULL,
0x0000004400447220ULL, 0x040fe20000410000ULL, 0x0000004500457220ULL, 0x040fe20000410000ULL,
0x0000004800487220ULL, 0x040fe20000410000ULL, 0x0000004900497220ULL, 0x000fe20000410000ULL,
0x0000004e054e7220ULL, 0x044fe20000410000ULL, 0x0000004f054f7220ULL, 0x040fe20000410000ULL,
0x0000005205527220ULL, 0x040fe20000410000ULL, 0x0000005305537220ULL, 0x040fe20000410000ULL,
0x0000005605567220ULL, 0x040fe20000410000ULL, 0x0000005705577220ULL, 0x040fe20000410000ULL,
0x0000005a055a7220ULL, 0x040fe20000410000ULL, 0x0000005b055b7220ULL, 0x040fe20000410000ULL,
0x0000005e055e7220ULL, 0x040fe20000410000ULL, 0x0000005f055f7220ULL, 0x040fe20000410000ULL,
0x0000006205627220ULL, 0x040fe20000410000ULL, 0x0000006305637220ULL, 0x040fe20000410000ULL,
0x0000006605667220ULL, 0x040fe20000410000ULL, 0x0000006705677220ULL, 0x040fe20000410000ULL,
0x0000006a056a7220ULL, 0x040fe20000410000ULL, 0x0000006b056b7220ULL, 0x000fe20000410000ULL,
0x000000042e2e7220ULL, 0x088fe20000410000ULL, 0x000000042f2f7220ULL, 0x080fe20000410000ULL,
0x0000000432327220ULL, 0x080fe20000410000ULL, 0x0000000433337220ULL, 0x080fe20000410000ULL,
0x0000000436367220ULL, 0x080fe20000410000ULL, 0x0000000437377220ULL, 0x080fe20000410000ULL,
0x000000043a3a7220ULL, 0x080fe20000410000ULL, 0x000000043b3b7220ULL, 0x080fe20000410000ULL,
0x000000043e3e7220ULL, 0x080fe20000410000ULL, 0x000000043f3f7220ULL, 0x080fe20000410000ULL,
0x0000000442427220ULL, 0x080fe20000410000ULL, 0x0000000443437220ULL, 0x080fe20000410000ULL,
0x0000000446467220ULL, 0x080fe20000410000ULL, 0x0000000447477220ULL, 0x080fe20000410000ULL,
0x000000044a4a7220ULL, 0x080fe20000410000ULL, 0x000000044b4b7220ULL, 0x000fe20000410000ULL,
0x000000024c4c7220ULL, 0x080fe20000410000ULL, 0x000000024d4d7220ULL, 0x080fe20000410000ULL,
0x0000000250507220ULL, 0x080fe20000410000ULL, 0x0000000251517220ULL, 0x080fe20000410000ULL,
0x0000000254547220ULL, 0x080fe20000410000ULL, 0x0000000255557220ULL, 0x080fe20000410000ULL,
0x0000000258587220ULL, 0x080fe20000410000ULL, 0x0000000259597220ULL, 0x080fe20000410000ULL,
0x000000025c5c7220ULL, 0x080fe20000410000ULL, 0x000000025d5d7220ULL, 0x080fe20000410000ULL,
0x0000000260607220ULL, 0x080fe20000410000ULL, 0x0000000261617220ULL, 0x080fe20000410000ULL,
0x0000000264647220ULL, 0x080fe20000410000ULL, 0x0000000265657220ULL, 0x080fe20000410000ULL,
0x0000000268687220ULL, 0x080fe20000410000ULL, 0x0000000269697220ULL, 0x000fc20000410000ULL,
0x0000000000037919ULL, 0x004ea20000000000ULL, 0x0000002e2f2e723eULL, 0x000fc400000000ffULL,
0x000000323317723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000363736723eULL, 0x000fe400000000ffULL, 0x0000003a3b1b723eULL, 0x000fe400000000ffULL,
0x0000003e3f3e723eULL, 0x000fc400000000ffULL, 0x00000042431f723eULL, 0x000fe400000000ffULL,
0x000000464746723eULL, 0x000fe400000000ffULL, 0x0000004a4b23723eULL, 0x000fe400000000ffULL,
0x0000004c4d4c723eULL, 0x000fe400000000ffULL, 0x0000000803057811ULL, 0x044fe200078ff0ffULL,
0x0000000184847824ULL, 0x000fe200078e0203ULL, 0x0000000203007812ULL, 0x000fc400078ec0ffULL,
0x0000001803097811ULL, 0x000fe200078ff0ffULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0x0000000500027211ULL, 0x040fe400078ff8ffULL, 0x0000001003057811ULL, 0x000fe200078ff0ffULL,
0x0000000809187824ULL, 0x002fe200078e00ffULL, 0xfffffff8070e7812ULL, 0x000fe400078ee202ULL,
0x00000002ff077819ULL, 0x000fe20000011603ULL, 0x00000008050b7824ULL, 0x000fe200078e00ffULL,
0x0000000500047211ULL, 0x000fc400078ff8ffULL, 0x0000000700027211ULL, 0x040fe200078ff8ffULL,
0x00000008070c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b167812ULL, 0x000fe200078ee204ULL,
0x0000200011047824ULL, 0x000fe200078e00ffULL, 0x0000000900057211ULL, 0x000fe200078ff8ffULL,
0x0000000807097824ULL, 0x040fe200078e00ffULL, 0x0000000202007810ULL, 0x000fe20007ffe0ffULL,
0x00000008070b7824ULL, 0x000fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe400078ee205ULL,
0x0000200004057812ULL, 0x000fc400078ee2ffULL, 0xfffffff809067812ULL, 0x040fe400078ee200ULL,
0xfffffff809007812ULL, 0x000fe200078ee202ULL, 0x000010000a077824ULL, 0x100fe200078e0205ULL,
0x0000000402047810ULL, 0x000fe20007ffe0ffULL, 0x0000001084847824ULL, 0x000fe200078e0205ULL,
0x0000000602097810ULL, 0x000fe20007ffe0ffULL, 0x0000000803027824ULL, 0x000fe200078e00ffULL,
0xfffffff80b087812ULL, 0x000fe200078ee204ULL, 0x0000001000047824ULL, 0x000fe200078e0207ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee209ULL, 0x000000100e147824ULL, 0x100fe200078e0207ULL,
0x0000000802097812ULL, 0x000fe200078ec0ffULL, 0x0000001016167824ULL, 0x100fe200078e0207ULL,
0x0000002c2d00723eULL, 0x000fe200000000ffULL, 0x0000001018187824ULL, 0x100fe200078e0207ULL,
0x000000303102723eULL, 0x000fe200000000ffULL, 0x0000001006067824ULL, 0x100fe200078e0207ULL,
0x000000505126723eULL, 0x000fe200000000ffULL, 0x0000001008087824ULL, 0x100fe200078e0207ULL,
0x00005410001c7816ULL, 0x100fe20000000002ULL, 0x000000100c0e7824ULL, 0x000fe200078e0207ULL,
0x00007632001d7816ULL, 0x000fe20000000002ULL, 0x0000000104077824ULL, 0x000fe200078e0209ULL,
0x000000343500723eULL, 0x000fe200000000ffULL, 0x00000001090b7824ULL, 0x000fe200078e0206ULL,
0x000000383902723eULL, 0x000fe200000000ffULL, 0x00000001090c7824ULL, 0x000fe200078e0208ULL,
0x0000001c07007388ULL, 0x0003e20000000a00ULL, 0x0000003c3d04723eULL, 0x000fe200000000ffULL,
0x00000001090e7824ULL, 0x000fe200078e020eULL, 0x000000404106723eULL, 0x000fe200000000ffULL,
0x0000000109147824ULL, 0x000fe200078e0214ULL, 0x000000484908723eULL, 0x000fe200000000ffULL,
0x0000000109167824ULL, 0x040fe200078e0216ULL, 0x00005410361a7816ULL, 0x000fe2000000001bULL,
0x0000000109187824ULL, 0x000fe200078e0218ULL, 0x000000545554723eULL, 0x000fc400000000ffULL,
0x00000058592a723eULL, 0x000fe400000000ffULL, 0x00005410001c7816ULL, 0x142fe40000000002ULL,
0x00007632001d7816ULL, 0x000fe40000000002ULL, 0x000000444507723eULL, 0x000fe400000000ffULL,
0x00007632361b7816ULL, 0x000fe2000000001bULL, 0x0000001c0b007388ULL, 0x0003e20000000a00ULL,
0x000054103e1e7816ULL, 0x000fc4000000001fULL, 0x000076323e1f7816ULL, 0x000fe4000000001fULL,
0x0000541046227816ULL, 0x150fe40000000023ULL, 0x0000763246237816ULL, 0x000fe40000000023ULL,
0x0000763254097816ULL, 0x000fe4000000002aULL, 0x0000005c5d5c723eULL, 0x000fe400000000ffULL,
0x00005410041c7816ULL, 0x002fc40000000006ULL, 0x00007632041d7816ULL, 0x000fe40000000006ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x0000001c0c007388ULL, 0x000fe20000000a00ULL, 0x0000541054087816ULL, 0x000fe4000000002aULL,
0x000000606160723eULL, 0x000fe200000000ffULL, 0x000000060e007388ULL, 0x0003e20000000a00ULL,
0x000000646564723eULL, 0x000fc400000000ffULL, 0x000000686932723eULL, 0x000fe400000000ffULL,
0x0000004e4f00723eULL, 0x000fe400000000ffULL, 0x0000763264157816ULL, 0x000fe40000000032ULL,
0x000000525302723eULL, 0x000fe400000000ffULL, 0x000000565704723eULL, 0x000fe400000000ffULL,
0x000054102e067816ULL, 0x002fc40000000017ULL, 0x000076322e077816ULL, 0x000fe40000000017ULL,
0x000000ff0a00720cULL, 0x000fc60003f05270ULL, 0x0000000614007388ULL, 0x0003e80000000a00ULL,
0x0004001a0b007388ULL, 0x000fe80000000a00ULL, 0x0004001e0c007388ULL, 0x000fe20000000a00ULL,
0x000054104c067816ULL, 0x002fc60000000026ULL, 0x000400220e007388ULL, 0x000fe20000000a00ULL,
0x000076324c077816ULL, 0x000fe40000000026ULL, 0x0000541064147816ULL, 0x000fc60000000032ULL,
0x0000000616007388ULL, 0x0003e80000000a00ULL, 0x000800080b007388ULL, 0x0005e20000000a00ULL,
0x0000005a5b06723eULL, 0x002fe400000000ffULL, 0x000000666707723eULL, 0x000fe400000000ffULL,
0x000054105c087816ULL, 0x144fe40000000060ULL, 0x000076325c097816ULL, 0x000fc40000000060ULL,
0x0000763204197816ULL, 0x000fc60000000006ULL, 0x000800080c007388ULL, 0x0003e80000000a00ULL,
0x000800140e007388ULL, 0x0005e20000000a00ULL, 0x0000006a6b08723eULL, 0x002fe400000000ffULL,
0x0000541000147816ULL, 0x144fe40000000002ULL, 0x0000763200157816ULL, 0x000fe40000000002ULL,
0x0000005e5f00723eULL, 0x000fc400000000ffULL, 0x000000626302723eULL, 0x000fe200000000ffULL,
0x0000001418007388ULL, 0x0003e60000000a00ULL, 0x00005410002c7816ULL, 0x140fe40000000002ULL,
0x00007632002d7816ULL, 0x000fe40000000002ULL, 0x0000541004187816ULL, 0x002fe40000000006ULL,
0x0000541007067816ULL, 0x000fc40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x000c00180b007388ULL, 0x000fe80000000a00ULL, 0x000c002c0c007388ULL, 0x000fe80000000a00ULL,
0x000c00060e007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000084147984ULL, 0x000e680000000c00ULL, 0x00040000841c7984ULL, 0x000ea80000000c00ULL,
0x0008000084247984ULL, 0x000ee80000000c00ULL, 0x000c0000842c7984ULL, 0x000ee80000000c00ULL,
0x0010000084187984ULL, 0x000ee80000000c00ULL, 0x0014000084207984ULL, 0x000ee80000000c00ULL,
0x0018000084287984ULL, 0x000ee80000000c00ULL, 0x001c000084307984ULL, 0x000ee20000000c00ULL,
0x200000ff17177230ULL, 0x002fc40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fe40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x004fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fc40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x008fe40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fe40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x200000ff2f2f7230ULL, 0x000fc40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fe40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x000fe40000000000ULL, 0x0000001a16167230ULL, 0x000fe40000000000ULL,
0x0000001915157230ULL, 0x000fc40000000000ULL, 0x0000001814147230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x000fe40000000000ULL, 0x000000221e1e7230ULL, 0x000fe20000000000ULL,
0x0000001484007388ULL, 0x000fe20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fe40000000000ULL, 0x0000002b27277230ULL, 0x000fc40000000000ULL,
0x0000002a26267230ULL, 0x000fe20000000000ULL, 0x0004001c84007388ULL, 0x000fe20000000c00ULL,
0x0000002925257230ULL, 0x000fe40000000000ULL, 0x0000002824247230ULL, 0x000fe40000000000ULL,
0x000000332f2f7230ULL, 0x000fe40000000000ULL, 0x000000322e2e7230ULL, 0x000fe20000000000ULL,
0x0008002484007388ULL, 0x000fe20000000c00ULL, 0x000000312d2d7230ULL, 0x000fc40000000000ULL,
0x000000302c2c7230ULL, 0x000fca0000000000ULL, 0x000c002c84007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fc80000011603ULL, 0x0000007a0900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a0000027b06ULL, 0x000e620000209000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00005a00ff157a12ULL, 0x000fe200078e33ffULL,
0x0000000110007824ULL, 0x000fe200078e0209ULL, 0x0000000111117812ULL, 0x000fc800078ec0ffULL,
0x0000000200027308ULL, 0x002e640000001000ULL, 0x0ffffffe02087810ULL, 0x002fe20007ffe0ffULL,
0x0000000109027824ULL, 0x000fca00078e0203ULL, 0x0000000800077305ULL, 0x000e62000021f000ULL,
0x0000000702027812ULL, 0x000fc800078ec0ffULL, 0x0ffffff802027812ULL, 0x000fca00078ef803ULL,
0x0000001002027824ULL, 0x000fe400078e0205ULL, 0x000000ffff0b7224ULL, 0x002fc800078e0a07ULL,
0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b07137227ULL, 0x000fe400078e0006ULL,
0x0000000002087984ULL, 0x0002a80000000c00ULL, 0x0000000013047227ULL, 0x000fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fe200078e0a04ULL, 0x0000000703027812ULL, 0x002fc600078ec0ffULL,
0x00005a0007067a24ULL, 0x000fca00078e0200ULL, 0x00005a0006007a0cULL, 0x000fda0003f06070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104040810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f26070ULL, 0x00005a00ff007a0cULL, 0x000fd60003f05070ULL,
0x0000000104041810ULL, 0x000fc80007ffe0ffULL, 0x0000000415077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0212ULL,
0x00005a000d007a24ULL, 0x000fe400078e0200ULL, 0x00000008110d7824ULL, 0x000fe400078e0202ULL,
0x00005a0007007a24ULL, 0x000fca00078e0200ULL, 0x000000007b047210ULL, 0x000fe40007f3e0ffULL,
0x0000002003007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0004067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011600ULL,
0x00005f0004077a11ULL, 0x000fe400008f4407ULL, 0x0000007a0f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000110027824ULL, 0x100fe400078e020fULL,
0x00000001000f7824ULL, 0x000fe400078e020fULL, 0x0000000213067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000615077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0212ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x00000008110d7824ULL, 0x000fe400078e0200ULL, 0x00005a0007027a24ULL, 0x000fca00078e0202ULL,
0x000000027b077210ULL, 0x000fe40007f3e0ffULL, 0x0000004003027810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011602ULL, 0x00005f0007077a11ULL, 0x000fe400008f440cULL,
0x0000007a0f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000110007824ULL, 0x100fe400078e020fULL, 0x00000001020f7824ULL, 0x000fe400078e020fULL,
0x0000000013067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0200ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef802ULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000615077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0212ULL,
0x00005a000d007a24ULL, 0x000fe400078e0200ULL, 0x00000008110d7824ULL, 0x000fe400078e0202ULL,
0x00005a0007007a24ULL, 0x000fca00078e0200ULL, 0x000000007b077210ULL, 0x000fe40007f3e0ffULL,
0x0000006003007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011600ULL,
0x00005f0007077a11ULL, 0x000fe400008f440cULL, 0x0000007a0f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000110027824ULL, 0x100fe400078e020fULL,
0x00000001000f7824ULL, 0x000fe400078e020fULL, 0x0000000213067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000615077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0212ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x00000008110d7824ULL, 0x000fe400078e0200ULL, 0x00005a0007027a24ULL, 0x000fca00078e0202ULL,
0x000000027b077210ULL, 0x000fe40007f3e0ffULL, 0x0000008003027810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011602ULL, 0x00005f0007077a11ULL, 0x000fe400008f440cULL,
0x0000007a0f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000110007824ULL, 0x100fe400078e020fULL, 0x00000001020f7824ULL, 0x000fe400078e020fULL,
0x0000000013067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0200ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef802ULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000615077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0212ULL,
0x00005a000d007a24ULL, 0x000fe400078e0200ULL, 0x00000008110d7824ULL, 0x000fe400078e0202ULL,
0x00005a0007007a24ULL, 0x000fca00078e0200ULL, 0x000000007b077210ULL, 0x000fe40007f3e0ffULL,
0x000000a003007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011600ULL,
0x00005f0007077a11ULL, 0x000fe400008f440cULL, 0x0000007a0f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000110027824ULL, 0x100fe200078e020fULL,
0x000000c0030c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001000f7824ULL, 0x000fe400078e020fULL,
0x0000000213067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef800ULL, 0x00000003ff0f7819ULL, 0x000fe4000001160cULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000615077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0212ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x00000008110d7824ULL, 0x000fe400078e0200ULL, 0x00005a0007027a24ULL, 0x000fca00078e0202ULL,
0x000000027b027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0002067a11ULL, 0x000fc800078240ffULL, 0x00005f0002077a11ULL, 0x000fe400008f4407ULL,
0x0000007a0f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000110007824ULL, 0x100fe400078e020fULL, 0x000000010c0f7824ULL, 0x000fe400078e020fULL,
0x0000000013067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007027a24ULL, 0x000fca00078e0200ULL,
0x00005a0002007a0cULL, 0x000fda0003f26070ULL, 0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0002007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f027812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001002047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000615077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0212ULL,
0x00005a000d007a24ULL, 0x000fc800078e0200ULL, 0x00005a0007007a24ULL, 0x000fca00078e0200ULL,
0x000000007b067210ULL, 0x000fe40007f3e0ffULL, 0x000000e003007810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0006027a11ULL, 0x040fe400078240ffULL,
0x00000003ff0d7819ULL, 0x000fe40000011600ULL, 0x00005f0006037a11ULL, 0x000fe200008f4407ULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x0000007a0d00720cULL, 0x000fe20003f26070ULL,
0x0000000110107824ULL, 0x000fe400078e020dULL, 0x0000001007027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000001013037227ULL, 0x002fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e0a03ULL,
0x00000001000d7824ULL, 0x000fe400078e020dULL, 0x00005a0007027a24ULL, 0x000fc600078e0210ULL,
0x000000070d0d7812ULL, 0x000fe400078ec0ffULL, 0x00005a0002007a0cULL, 0x000fda0003f26070ULL,
0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL, 0x0000000103031810ULL, 0x000fe40007ffe0ffULL,
0x00005a0002007a0cULL, 0x000fe40003f46070ULL, 0xfffffff80d027812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001002057824ULL, 0x000fca00078e0205ULL,
0x0000000005087984ULL, 0x0002a20000000c00ULL, 0x0000000103032810ULL, 0x000fc80007ffe0ffULL,
0x0000000315037207ULL, 0x000fe20004000000ULL, 0x0000000811057824ULL, 0x002fc800078e0200ULL,
0x000000ffff077224ULL, 0x000fe400078e0a03ULL, 0x0000590003037a24ULL, 0x000fe400078e0212ULL,
0x00005a0007107a24ULL, 0x000fc800078e0210ULL, 0x00005a0003107a24ULL, 0x000fca00078e0210ULL,
0x000000107b107210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005e0010027a11ULL, 0x000fc800078040ffULL, 0x00005f0010037a11ULL, 0x000fca00000f4403ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x004fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000d1100720cULL, 0x000fe20003f06070ULL,
0xffffffffff5f7424ULL, 0x000fd800078e00ffULL, 0x0000000204088824ULL, 0x002fc800078e00ffULL,
0x00006a0008088a24ULL, 0x000fc800078e0211ULL, 0x0000660008088625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000006085f8981ULL, 0x000ea2000c1e1900ULL,
0x00006e00ff667624ULL, 0x000fe400078e00ffULL, 0x00006f00ff677624ULL, 0x000fe200078e00ffULL,
0x01260000ff067f8cULL, 0x000e68000c80043fULL, 0x0000000666667981ULL, 0x000722000c1e9900ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x00005800ff0a7624ULL, 0x000fc400078e00ffULL,
0x00000040155c7824ULL, 0x000fe400078e00ffULL, 0x00000080ff147424ULL, 0x000fe200078e00ffULL,
0x0000001f0a0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000040115d7824ULL, 0x000fe400078e00ffULL,
0x0000004012007824ULL, 0x000fe200078e00ffULL, 0x00000005ff0a7819ULL, 0x000fe2000001160aULL,
0x0000005c5f0b7224ULL, 0x004fc800078e02ffULL, 0x000064000b087625ULL, 0x000fe200078e0014ULL,
0x0000060000000947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x00afe4000001160fULL,
0x0000200011247811ULL, 0x000fe400078e68ffULL, 0x0000000829257810ULL, 0x040fe20007ffe0ffULL,
0x0000004012237824ULL, 0x000fe200078e0229ULL, 0x0000005d0e127217ULL, 0x000fe40007800000ULL,
0x00000010292d7810ULL, 0x000fe20007ffe0ffULL, 0x0000008023147825ULL, 0x040fe200078e00ffULL,
0x0000001023187810ULL, 0x000fc40007ffe0ffULL, 0x0000000823167810ULL, 0x040fe20007ffe0ffULL,
0x0000000112127824ULL, 0x000fe200078e0a5dULL, 0x00000030141b7812ULL, 0x100fe200078ef802ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000001823147810ULL, 0x000fe40007ffe0ffULL,
0x0000001b081a7210ULL, 0x000fe20007f1e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000030180b7812ULL, 0x000fe400078ef802ULL, 0x00000018292f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001091b7824ULL, 0x000fe200000e0615ULL, 0x0000000b08187210ULL, 0x000fe20007f5e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000f0f0b7211ULL, 0x000fc400078fe8ffULL,
0x00000030161d7812ULL, 0x100fe200078ef802ULL, 0x0000000109197824ULL, 0x000fe200010e0619ULL,
0x00000030141f7812ULL, 0x000fe400078ef802ULL, 0x000000030b227812ULL, 0x000fe200078ec0ffULL,
0x00000004250b7824ULL, 0x000fe200078e00ffULL, 0x0000001f081e7210ULL, 0x040fe40007f5e0ffULL,
0x0000001d081c7210ULL, 0x000fe40007f3e0ffULL, 0x000000122900720cULL, 0x000fe20003f06070ULL,
0x00000001091f7824ULL, 0x000fe200010e0615ULL, 0x0000002823147810ULL, 0x000fe20007ffe0ffULL,
0x00000001091d7824ULL, 0x000fe200008e0617ULL, 0x0000002023167810ULL, 0x000fc40007ffe0ffULL,
0x0ffffffc220f7812ULL, 0x000fe200078ef80fULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000122500720cULL, 0x000fe40003f26070ULL, 0xfffffffc0b0b7812ULL, 0x000fe200078ee222ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x00000030142b7812ULL, 0x000fe400078ef802ULL,
0x0000003023147810ULL, 0x000fe20007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe200078e0224ULL,
0x0000003016217812ULL, 0x000fe200078ef802ULL, 0x000000100b0b7824ULL, 0x000fe200078e0224ULL,
0x0000002829257810ULL, 0x000fc40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a0f7faeULL, 0x0003e2000c101c46ULL, 0x0000002108207210ULL, 0x040fe40007f7e0ffULL,
0x0000003029277810ULL, 0x000fe20007ffe0ffULL, 0x000000001c0b7faeULL, 0x0005e2000c901c46ULL,
0x0000003823167810ULL, 0x000fe20007ffe0ffULL, 0x0000000109217824ULL, 0x000fe200018e0617ULL,
0x0000002029177810ULL, 0x040fe40007ffe0ffULL, 0x0000003829297810ULL, 0x000fe40007ffe0ffULL,
0x000000122500720cULL, 0x0c0fe20003f46070ULL, 0x0000000425257824ULL, 0x000fe200078e00ffULL,
0x0000002b081a7210ULL, 0x002fe20007fde0ffULL, 0x000000042f0f7824ULL, 0x000fe200078e00ffULL,
0x000000122700720cULL, 0x0c0fe20003f26070ULL, 0x0000000427277824ULL, 0x000fe200078e00ffULL,
0x000000122900720cULL, 0x080fe20003f06070ULL, 0x00000001091b7824ULL, 0x000fe200030e0615ULL,
0x000000121700720cULL, 0x080fe20003f66070ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000122d00720cULL, 0x000fc40003fa6070ULL, 0x000000122f00720cULL, 0x000fe20003f86070ULL,
0x000000042d0b7824ULL, 0x004fe200078e00ffULL, 0x0000003014237812ULL, 0x000fe200078ef802ULL,
0x00000004171d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc0f0f7812ULL, 0x100fe200078ee222ULL,
0x0000000429297824ULL, 0x000fe200078e00ffULL, 0x0000002308147210ULL, 0x000fe20007fde0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0xfffffffc25237812ULL, 0x100fe400078ee222ULL,
0xfffffffc27257812ULL, 0x100fe200078ee222ULL, 0x0000000109157824ULL, 0x000fe200030e0615ULL,
0xfffffffc0b0b7812ULL, 0x000fe200078ee222ULL, 0x000000100f0f7824ULL, 0x000fe200078e0224ULL,
0xfffffffc29277812ULL, 0x000fe200078ee222ULL, 0x0000001023237824ULL, 0x000fe200078e0224ULL,
0x0000003016297812ULL, 0x000fe200078ef802ULL, 0x000000100b0b7824ULL, 0x000fe200078e0224ULL,
0xfffffffc1d1d7812ULL, 0x000fe200078ee222ULL, 0x0000001025257824ULL, 0x100fe200078e0224ULL,
0x0000002908087210ULL, 0x000fe20007fde0ffULL, 0x0000001027277824ULL, 0x100fe200078e0224ULL,
0x00000000180b7faeULL, 0x0003e2000e901c46ULL, 0x000000101d1d7824ULL, 0x000fc400078e0224ULL,
0x0000000109097824ULL, 0x000fe200030e0617ULL, 0x000000001e0f7faeULL, 0x0003e8000e101c46ULL,
0x00000000201d7faeULL, 0x0003e8000d901c46ULL, 0x000000001a237faeULL, 0x0003e8000d101c46ULL,
0x0000000014257faeULL, 0x0003e8000c901c46ULL, 0x0000000008277faeULL, 0x0003e2000c101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x000000180f237811ULL, 0x04afe400078ff0ffULL,
0x000000000f147211ULL, 0x000fc400078ff0ffULL, 0x0000000f0f0b7211ULL, 0x000fe200078fe8ffULL,
0x0000000423217824ULL, 0x000fe200078e00ffULL, 0x000000100f197811ULL, 0x040fe200078ff0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000300f2b7811ULL, 0x040fe400078ff0ffULL,
0x000000080f177811ULL, 0x000fe200078ff0ffULL, 0x0000000100187824ULL, 0x040fe200078e0219ULL,
0x000000030b207812ULL, 0x000fe200078ec0ffULL, 0x00000004191f7824ULL, 0x000fe200078e00ffULL,
0x000000200f1b7811ULL, 0x000fe200078ff0ffULL, 0x000000042b297824ULL, 0x000fe200078e00ffULL,
0x000000280f1d7811ULL, 0x040fe200078ff0ffULL, 0x0000000100167824ULL, 0x000fe200078e0217ULL,
0x000000380f2f7811ULL, 0x000fe200078ff0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0xfffffffc21127812ULL, 0x000fc400078ee220ULL, 0x0000003014217812ULL, 0x000fe200078ef802ULL,
0x00000004170b7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc20227812ULL, 0x000fe200078ef80fULL,
0x000000041b257824ULL, 0x000fe200078e00ffULL, 0xfffffffc1f0f7812ULL, 0x100fe200078ee220ULL,
0x000000041d277824ULL, 0x000fe200078e00ffULL, 0xfffffffc291f7812ULL, 0x000fe200078ee220ULL,
0x000000042f2d7824ULL, 0x000fe200078e00ffULL, 0x0000200011317811ULL, 0x000fe200078e68ffULL,
0x0000000100147824ULL, 0x000fe200078e0223ULL, 0x00000021081e7210ULL, 0x000fe20007f1e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000003018237812ULL, 0x000fc400078ef802ULL,
0xfffffffc0b0b7812ULL, 0x100fe200078ee220ULL, 0x0000001022377824ULL, 0x100fe200078e0231ULL,
0xfffffffc251a7812ULL, 0x100fe200078ee220ULL, 0x000000100f0f7824ULL, 0x100fe200078e0231ULL,
0xfffffffc271c7812ULL, 0x100fe200078ee220ULL, 0x000000100b0b7824ULL, 0x100fe200078e0231ULL,
0xfffffffc2d207812ULL, 0x000fe200078ee220ULL, 0x000000101f2d7824ULL, 0x000fe200078e0231ULL,
0x0000003016217812ULL, 0x000fe200078ef802ULL, 0x00000001091f7824ULL, 0x000fe200000e0615ULL,
0x0000002308227210ULL, 0x000fe20007f5e0ffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e377faeULL, 0x0003e2000b901c46ULL,
0x0000001012257824ULL, 0x100fe400078e0231ULL, 0x000000101a277824ULL, 0x100fe400078e0231ULL,
0x000000101c297824ULL, 0x100fe400078e0231ULL, 0x0000001020317824ULL, 0x000fe200078e0231ULL,
0x0000002108207210ULL, 0x000fe20007f3e0ffULL, 0x0000000109237824ULL, 0x000fe200010e0619ULL,
0x0000003014197812ULL, 0x000fe200078ef802ULL, 0x0000000100167824ULL, 0x000fc400078e021bULL,
0x0000000100187824ULL, 0x000fe200078e021dULL, 0x0000001908147210ULL, 0x000fe20007f1e0ffULL,
0x00000001001a7824ULL, 0x040fe400078e022bULL, 0x0000000109217824ULL, 0x000fe400008e0617ULL,
0x00000001001c7824ULL, 0x000fe400078e022fULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000000200b7faeULL, 0x0003e6000b901c46ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000003016357812ULL, 0x100fe200078ef802ULL, 0x00000000220f7faeULL, 0x0003e4000b901c46ULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000003018337812ULL, 0x000fc600078ef802ULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000301a2f7812ULL, 0x100fe400078ef802ULL,
0x0000003308187210ULL, 0x000fe20007f3e0ffULL, 0x0000000109157824ULL, 0x040fe200000e0615ULL,
0x000000301c2b7812ULL, 0x000fe400078ef802ULL, 0x0000003508167210ULL, 0x040fe20007f1e0ffULL,
0x0000000109197824ULL, 0x040fe200008e0619ULL, 0x0000002f081a7210ULL, 0x040fe20007f5e0ffULL,
0x0000000014257faeULL, 0x0003e2000b901c46ULL, 0x0000002b08087210ULL, 0x000fe20007f7e0ffULL,
0x0000000109177824ULL, 0x000fc400000e0617ULL, 0x00000001091b7824ULL, 0x040fe400010e061bULL,
0x0000000109097824ULL, 0x000fe200018e061dULL, 0x0000000016277faeULL, 0x0003e8000b901c46ULL,
0x0000000018297faeULL, 0x0003e8000b901c46ULL, 0x000000001a2d7faeULL, 0x0003e8000b901c46ULL,
0x0000000008317faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fc40000015200ULL, 0x01260400ff0b7984ULL, 0x000e620000000800ULL,
0x0000000a03027224ULL, 0x000fc400078e02ffULL, 0x000000010e127824ULL, 0x000fe200078e0a13ULL,
0x800000000bff7812ULL, 0x002fe20007804807ULL, 0x000000ffff0b7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000ff00000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620002027625ULL, 0x000fe200078e0005ULL, 0x00000008ff127819ULL, 0x000fe20000011612ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001408147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e09ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc80000011415ULL, 0x0000001405057211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x0000000205057819ULL, 0x000fc80000001214ULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01260400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000e640000000000ULL,
0x0000002011057824ULL, 0x002fca00078e0206ULL, 0x00000004ff067819ULL, 0x000fe40000011605ULL,
0x0000000105077810ULL, 0x040fe40007ffe0ffULL, 0x0ffffffe06087812ULL, 0x000fe400078ec0ffULL,
0x0000001f05067812ULL, 0x000fc600078ec0ffULL, 0x00000001080b7824ULL, 0x040fe400078e0207ULL,
0x0000000105097824ULL, 0x000fe200078e0208ULL, 0x0000000808087810ULL, 0x000fe20007ffe0ffULL,
0x0000001006167824ULL, 0x040fe200078e00ffULL, 0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000001006147824ULL, 0x000fe200078e00ffULL, 0x0000000f09097812ULL, 0x000fe200078ec0ffULL,
0x0000000107077824ULL, 0x100fe200078e0208ULL, 0x000001f0160b7812ULL, 0x000fe200078ee20bULL,
0x0000000105057824ULL, 0x000fe200078e0208ULL, 0x000001f014097812ULL, 0x000fe200078ee209ULL,
0x0000001006087824ULL, 0x040fe200078e00ffULL, 0x0000000f07077812ULL, 0x000fe200078ec0ffULL,
0x000000000b147984ULL, 0x000e62000000cc00ULL, 0x0000001006067824ULL, 0x000fe200078e00ffULL,
0x0000000f05057812ULL, 0x000fc400078ec0ffULL, 0x0000000009187984ULL, 0x000ea4000000cc00ULL,
0x000001f006077812ULL, 0x000fe400078ee207ULL, 0x000001f008057812ULL, 0x000fe200078ee205ULL,
0x000000ffff1e7224ULL, 0x002fe400078e0014ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0016ULL,
0x000000ffff1c7224ULL, 0x004fe400078e0018ULL, 0x000000ffff1d7224ULL, 0x000fc400078e001aULL,
0x000000ffff227224ULL, 0x000fe400078e0015ULL, 0x000000ffff237224ULL, 0x000fe200078e0017ULL,
0x0000001c09007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff207224ULL, 0x000fe400078e0019ULL,
0x000000ffff217224ULL, 0x000fca00078e001bULL, 0x000000200b007388ULL, 0x000fe8000000cc00ULL,
0x0000000007147984ULL, 0x000e68000000cc00ULL, 0x0000000005187984ULL, 0x000ea2000000cc00ULL,
0x000000ffff277224ULL, 0x002fe400078e0016ULL, 0x000000ffff267224ULL, 0x000fc400078e0014ULL,
0x000000ffff167224ULL, 0x000fe400078e0015ULL, 0x000000ffff247224ULL, 0x004fe400078e0018ULL,
0x000000ffff257224ULL, 0x000fe400078e001aULL, 0x000000ffff147224ULL, 0x000fe400078e0019ULL,
0x000000ffff157224ULL, 0x000fe200078e001bULL, 0x0000002405007388ULL, 0x0003e8000000cc00ULL,
0x0000001407007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01260000ff147f8cULL, 0x002e62000c80043fULL, 0x000000ffff0b7224ULL, 0x000fc600078e00ffULL,
0x0000000000067805ULL, 0x000fc80000015200ULL, 0x01260400ff057984ULL, 0x000ea40000000800ULL,
0x8000000005ff7812ULL, 0x006fc40007804815ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc80000011409ULL,
0x0000000805057211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000205057819ULL, 0x000fc80000001208ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00000000000f7919ULL, 0x000e620000000000ULL, 0x00006a0004697a24ULL, 0x000fe200078e02ffULL,
0x3db504f366667820ULL, 0x010fe20000410000ULL, 0x000000020a677824ULL, 0x000fe200078e00ffULL,
0x0001268811657811ULL, 0x000fe200078e18ffULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0xffffffff13647810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff5e7224ULL, 0x000fe200078e0011ULL,
0x0000000913637810ULL, 0x000fe40007ffe0ffULL, 0x0001260811627811ULL, 0x000fc400078e28ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000ffff687224ULL, 0x004fe200078e0060ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff6a7224ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x018fc4000001ff00ULL, 0x000000016a00780cULL, 0x040fe20003f25270ULL,
0x00000080ff507424ULL, 0x020fe200078e00ffULL, 0x0000000161527810ULL, 0x000fe20007ffe0ffULL,
0x00000bc000007945ULL, 0x000fe20003800000ULL, 0x000000016a3c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff6b7224ULL, 0x000fe200078e006aULL, 0x0000000168607812ULL, 0x000fc400078e0cffULL,
0x000000023c00780cULL, 0x040fe20003f06070ULL, 0x000000ffff6a7224ULL, 0x000fe200078e003cULL,
0x000000ff3c3e7207ULL, 0x000fc60000800000ULL, 0x000000ffff521224ULL, 0x000fca00078e0261ULL,
0x00000001523d7810ULL, 0x000fc80007ffe0ffULL, 0x0000000c3d00720cULL, 0x000fe20003f46070ULL,
0x0000005c5f3d7224ULL, 0x010fc800078e02ffULL, 0x000064003d3c7625ULL, 0x000fd000078e0050ULL,
0x000005e00000a947ULL, 0x000fea0003800000ULL, 0x000000100f3f7824ULL, 0x002fe200078e00ffULL,
0x00000002ff727819ULL, 0x000fe2000001160fULL, 0x000000ffff517224ULL, 0x000fe400078e00ffULL,
0x0000000211707824ULL, 0x000fe200078e0260ULL, 0x000000303f3f7812ULL, 0x000fe200078ec0ffULL,
0x0000000100537824ULL, 0x000fe200078e0272ULL, 0x00000008726d7810ULL, 0x040fe40007ffe0ffULL,
0x0000001072737810ULL, 0x000fe20007ffe0ffULL, 0x000000403e507824ULL, 0x000fe200078e023fULL,
0x0000001872767810ULL, 0x000fe20007ffe0ffULL, 0x00000100523f7824ULL, 0x000fe200078e025dULL,
0x0000002072787810ULL, 0x000fe20007ffe0ffULL, 0x0000008053527825ULL, 0x000fe200078e0050ULL,
0x0000200070707811ULL, 0x000fc400078e60ffULL, 0x0000003f0e567217ULL, 0x000fe20007800000ULL,
0x0000000100557824ULL, 0x000fe200078e026dULL, 0x000000523c587210ULL, 0x000fe20007f3e0ffULL,
0x0000000100577824ULL, 0x000fe200078e0273ULL, 0x0000000f0f527211ULL, 0x000fe200078fe8ffULL,
0x0000008055547825ULL, 0x000fe200078e0050ULL, 0x0000002872797810ULL, 0x000fe40007ffe0ffULL,
0x0000000352747812ULL, 0x000fe200078ec0ffULL, 0x00000001563f7824ULL, 0x000fe200078e0a3fULL,
0x000000543c5a7210ULL, 0x000fe20007f5e0ffULL, 0x000000013d597824ULL, 0x000fe200008e0653ULL,
0x0ffffffc74717812ULL, 0x000fe200078ef80fULL, 0x0000008057567825ULL, 0x000fe200078e0050ULL,
0x00000030727a7810ULL, 0x000fc40007ffe0ffULL, 0x0000003f7600720cULL, 0x080fe20003fa6070ULL,
0x0000000100537824ULL, 0x000fe200078e0276ULL, 0x000000563c567210ULL, 0x000fe20007f3e0ffULL,
0x000000013d5b7824ULL, 0x000fe200010e0655ULL, 0x0000003f6d00720cULL, 0x000fe20003f46070ULL,
0x0000008053527825ULL, 0x000fc800078e0050ULL, 0x0000000100557824ULL, 0x000fe200078e0278ULL,
0x000000523c6c7210ULL, 0x000fe20007f7e0ffULL, 0x000000013d577824ULL, 0x000fe200008e0657ULL,
0x0000003f7200720cULL, 0x040fe20003f26070ULL, 0x0000008055547825ULL, 0x000fe200078e0050ULL,
0x0000003872727810ULL, 0x000fc60007ffe0ffULL, 0x000000046d757824ULL, 0x000fe200078e00ffULL,
0x000000543c6e7210ULL, 0x000fe20007f9e0ffULL, 0x000000013d6d7824ULL, 0x000fe200018e0653ULL,
0x0000003f7300720cULL, 0x080fe20003f66070ULL, 0x0000001071537824ULL, 0x000fe400078e0270ULL,
0x0000000473717824ULL, 0x000fe400078e00ffULL, 0x000000013d6f7824ULL, 0x000fe200020e0655ULL,
0xfffffffc75557812ULL, 0x100fe200078ee274ULL, 0x0000000100737824ULL, 0x040fe200078e0279ULL,
0xfffffffc71717812ULL, 0x000fe200078ee274ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000058537faeULL, 0x0003e2000c901c46ULL, 0x0000000100757824ULL, 0x000fe200078e027aULL,
0x0000003f7800720cULL, 0x080fe20003f86070ULL, 0x0000001055557824ULL, 0x100fe200078e0270ULL,
0x0000003f7200720cULL, 0x000fe20003f26070ULL, 0x0000001071717824ULL, 0x000fc400078e0270ULL,
0x0000000100777824ULL, 0x000fe200078e0272ULL, 0x000000005a557faeULL, 0x0005e2000d101c46ULL,
0x0000003f7a00720cULL, 0x080fe20003f46070ULL, 0x0000008073527825ULL, 0x102fe400078e0050ULL,
0x0000000056717faeULL, 0x0003e2000d901c46ULL, 0x0000003f7900720cULL, 0x040fe20003f66070ULL,
0x00000004763f7824ULL, 0x000fe200078e00ffULL, 0x000000523c527210ULL, 0x000fe20007fde0ffULL,
0x0000000479597824ULL, 0x000fe400078e00ffULL, 0x0000008075547825ULL, 0x004fe200078e0050ULL,
0xfffffffc3f3f7812ULL, 0x000fc400078ee274ULL, 0xfffffffc59597812ULL, 0x000fe200078ee274ULL,
0x000000013d537824ULL, 0x000fe200030e0653ULL, 0x000000543c547210ULL, 0x000fe20007fde0ffULL,
0x0000000478577824ULL, 0x002fe400078e00ffULL, 0x000000047a5b7824ULL, 0x000fe400078e00ffULL,
0x0000008077507825ULL, 0x000fe200078e0050ULL, 0xfffffffc57577812ULL, 0x100fe400078ee274ULL,
0xfffffffc5b5b7812ULL, 0x000fe200078ee274ULL, 0x0000000472717824ULL, 0x000fc400078e00ffULL,
0x000000013d557824ULL, 0x000fe200030e0655ULL, 0x000000503c3c7210ULL, 0x000fe20007fde0ffULL,
0x000000103f3f7824ULL, 0x000fe200078e0270ULL, 0xfffffffc71717812ULL, 0x000fe200078ee274ULL,
0x0000001057577824ULL, 0x100fe400078e0270ULL, 0x0000001059597824ULL, 0x100fe200078e0270ULL,
0x000000006c3f7faeULL, 0x0003e2000e901c46ULL, 0x000000105b5b7824ULL, 0x100fe400078e0270ULL,
0x0000001071717824ULL, 0x000fe200078e0270ULL, 0x000000006e577faeULL, 0x0003e2000e101c46ULL,
0x000000013d3d7824ULL, 0x000fc600030e0651ULL, 0x0000000052597faeULL, 0x0003e8000d901c46ULL,
0x00000000545b7faeULL, 0x0003e8000d101c46ULL, 0x000000003c717faeULL, 0x0003e2000c901c46ULL,
0x0000051000007947ULL, 0x000fea0003800000ULL, 0x0000000211517824ULL, 0x000fe200078e0260ULL,
0x000000080f537811ULL, 0x002fc400078ff0ffULL, 0x000000100f557811ULL, 0x040fe400078ff0ffULL,
0x000000180f577811ULL, 0x040fe400078ff0ffULL, 0x000000200f597811ULL, 0x000fe200078ff0ffULL,
0x0000000455717824ULL, 0x000fe200078e00ffULL, 0x000000280f5b7811ULL, 0x000fe200078ff0ffULL,
0x0000000457737824ULL, 0x000fe200078e00ffULL, 0x000000300f6d7811ULL, 0x000fe200078ff0ffULL,
0x0000000459757824ULL, 0x000fe200078e00ffULL, 0x000000380f7f7811ULL, 0x000fe200078ff0ffULL,
0x000000045b777824ULL, 0x000fe200078e00ffULL, 0x0000000f0f3f7211ULL, 0x000fe200078fe8ffULL,
0x000000046d797824ULL, 0x000fe200078e00ffULL, 0x0000200051527811ULL, 0x000fe200078e60ffULL,
0x0000000453517824ULL, 0x000fe200078e00ffULL, 0x000000033f507812ULL, 0x000fe200078ec0ffULL,
0x000000047f7b7824ULL, 0x000fc400078e00ffULL, 0x0000000100537824ULL, 0x040fe200078e0253ULL,
0xfffffffc51517812ULL, 0x100fe200078ee250ULL, 0x0000000100557824ULL, 0x040fe200078e0255ULL,
0xfffffffc71717812ULL, 0x100fe200078ee250ULL, 0x0000000100577824ULL, 0x040fe200078e0257ULL,
0xfffffffc73737812ULL, 0x100fe200078ee250ULL, 0x0000000100597824ULL, 0x000fe200078e0259ULL,
0xfffffffc75757812ULL, 0x000fe200078ee250ULL, 0x0000001071717824ULL, 0x000fe200078e0252ULL,
0xfffffffc77777812ULL, 0x000fe200078ee250ULL, 0x0000001073737824ULL, 0x100fe200078e0252ULL,
0x0ffffffc503f7812ULL, 0x000fe200078ef80fULL, 0x0000001075757824ULL, 0x000fe200078e0252ULL,
0xfffffffc79797812ULL, 0x000fe200078ee250ULL, 0x0000001077777824ULL, 0x000fe200078e0252ULL,
0xfffffffc7b7b7812ULL, 0x000fe200078ee250ULL, 0x000000100f507824ULL, 0x000fc400078e00ffULL,
0x000000103f7d7824ULL, 0x100fe400078e0252ULL, 0x00000010513f7824ULL, 0x100fe200078e0252ULL,
0x00000030506f7812ULL, 0x000fe200078ec0ffULL, 0x0000001079797824ULL, 0x100fe200078e0252ULL,
0x000000000f517211ULL, 0x000fe200078ff0ffULL, 0x000000107b7b7824ULL, 0x000fe400078e0252ULL,
0x000000403e6e7824ULL, 0x000fe400078e026fULL, 0x000000ffff6f7224ULL, 0x000fc400078e00ffULL,
0x00000001005b7824ULL, 0x000fe400078e025bULL, 0x0000008051507825ULL, 0x000fc800078e006eULL,
0x0000008053527825ULL, 0x000fe200078e006eULL, 0x000000503c507210ULL, 0x000fc60007f3e0ffULL,
0x0000008055547825ULL, 0x000fe200078e006eULL, 0x000000523c527210ULL, 0x000fc60007f5e0ffULL,
0x0000008057567825ULL, 0x000fe200078e006eULL, 0x000000543c547210ULL, 0x000fc60007f7e0ffULL,
0x00000001006d7824ULL, 0x000fe200078e026dULL, 0x000000563c567210ULL, 0x000fe20007f9e0ffULL,
0x00000001007f7824ULL, 0x000fe400078e027fULL, 0x0000008059587825ULL, 0x000fc800078e006eULL,
0x000000805b5a7825ULL, 0x000fc800078e006eULL, 0x000000806d6c7825ULL, 0x000fc800078e006eULL,
0x000000807f6e7825ULL, 0x000fc800078e006eULL, 0x000000013d517824ULL, 0x040fe200008e0651ULL,
0x000000583c587210ULL, 0x040fe20007f3e0ffULL, 0x000000013d537824ULL, 0x040fe200010e0653ULL,
0x0000005a3c5a7210ULL, 0x040fe20007f5e0ffULL, 0x000000013d557824ULL, 0x040fe200018e0655ULL,
0x0000006c3c6c7210ULL, 0x040fe20007f7e0ffULL, 0x000000013d577824ULL, 0x040fe200020e0657ULL,
0x0000006e3c3c7210ULL, 0x000fe20007f9e0ffULL, 0x000000013d597824ULL, 0x040fe200008e0659ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000507d7faeULL, 0x0003e2000b901c46ULL,
0x000000013d5b7824ULL, 0x000fc400010e065bULL, 0x000000013d6d7824ULL, 0x040fe200018e066dULL,
0x00000000523f7faeULL, 0x0003e2000b901c46ULL, 0x000000013d3d7824ULL, 0x000fc600020e066fULL,
0x0000000054717faeULL, 0x0003e8000b901c46ULL, 0x0000000056737faeULL, 0x0003e8000b901c46ULL,
0x0000000058757faeULL, 0x0003e8000b901c46ULL, 0x000000005a777faeULL, 0x0003e8000b901c46ULL,
0x000000006c797faeULL, 0x0003e8000b901c46ULL, 0x000000003c7b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000013e00780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x000000045e5e7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff5f7424ULL, 0x000fc600078e00ffULL,
0x0000000d5e00720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x00000002693c7824ULL, 0x002fe400078e025eULL, 0x00000004ff3d7424ULL, 0x000fc800078e00ffULL,
0x000066003c3c7625ULL, 0x000fca00078e003dULL, 0x000000063c5f7981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000086b6f7824ULL, 0x002fe400078e00ffULL, 0x000000ffff747224ULL, 0x000fe400078e00ffULL,
0x00000010ff6e7424ULL, 0x000fe200078e00ffULL, 0x000000126f6d7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff6c7224ULL, 0x000fe200078e00ffULL, 0x000000026f6f7810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff80f3c7812ULL, 0x000fe200078ec0ffULL,
0x0000000211707824ULL, 0x000fe200078e0268ULL, 0x000000080f3e7812ULL, 0x020fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000073c767812ULL, 0x000fc400078ef80fULL,
0x0000200070707811ULL, 0x000fe400078e60ffULL, 0x00000001ff777819ULL, 0x000fe20000011676ULL,
0x00000004763d7824ULL, 0x040fe200078e00ffULL, 0x000000070f757812ULL, 0x000fe200078ec0ffULL,
0x0000000476767824ULL, 0x000fe200078e00ffULL, 0x000000073e7d7812ULL, 0x100fe200078ef80fULL,
0x00000001773c7824ULL, 0x000fe200078e026cULL, 0x000000200f727810ULL, 0x000fe40007ffe0ffULL,
0x000000107d737812ULL, 0x040fe200078efcffULL, 0x000000107d3f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc3d3d7812ULL, 0x000fe200078ee23cULL, 0x000000107d7d7824ULL, 0x000fe200078e00ffULL,
0x0000003e0f3c7211ULL, 0x000fe200078fe0ffULL, 0x000000086b3e7824ULL, 0x000fe200078e026eULL,
0xfffffff872727812ULL, 0x000fe200078ec0ffULL, 0x000000103d3d7824ULL, 0x000fe200078e0270ULL,
0x000000016c827810ULL, 0x000fe20007ffe0ffULL, 0x0000000175757824ULL, 0x000fe200078e023cULL,
0x0000000772727812ULL, 0x000fe200078ef80fULL, 0x000000086b3c7824ULL, 0x000fe200078e0274ULL,
0x000000003d54783bULL, 0x000e620000000200ULL, 0x00000001753e7824ULL, 0x040fe200078e023eULL,
0x00000001ff717819ULL, 0x000fe20000011672ULL, 0x00000001753c7824ULL, 0x040fe200078e023cULL,
0x0000006d75817210ULL, 0x000fe20007ffe074ULL, 0x0000000472597824ULL, 0x000fc400078e00ffULL,
0x0000000171587824ULL, 0x000fe200078e026cULL, 0xfffffff03f3c7812ULL, 0x000fe200078ee23cULL,
0x00000010733f7824ULL, 0x000fe200078e00ffULL, 0x000000026c6c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000177777824ULL, 0x000fe200078e0282ULL, 0xfffffffc59597812ULL, 0x000fe200078ee258ULL,
0x000000103c507824ULL, 0x000fe200078e00ffULL, 0xfffffff03f3e7812ULL, 0x000fe200078ee23eULL,
0x0000000171717824ULL, 0x000fe200078e0282ULL, 0xfffffffc767f7812ULL, 0x000fe200078ee277ULL,
0x0000001059597824ULL, 0x000fc400078e0270ULL, 0x000000103e3e7824ULL, 0x000fe200078e00ffULL,
0x000000005050783bULL, 0x000ea20000000200ULL, 0x0000000472727824ULL, 0x000fc800078e00ffULL,
0x000000003e3c783bULL, 0x000ee20000000200ULL, 0xfffffffc72717812ULL, 0x000fe400078ee271ULL,
0x00000018ff5a7819ULL, 0x102fe40000011654ULL, 0x00000010ff587819ULL, 0x000fe40000011654ULL,
0x0000ffff54787812ULL, 0x000fe400078ec0ffULL, 0x0000005aff5b723eULL, 0x000fe400020006ffULL,
0x000000ff585a7812ULL, 0x000fc400078ec0ffULL, 0x000000ff54547812ULL, 0x000fe400078ec0ffULL,
0x00000008ff587819ULL, 0x000fe40000011678ULL, 0x00000018ff787819ULL, 0x000fe40000011655ULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000005aff79723eULL, 0x000fc400020006ffULL, 0x00000078ff7b723eULL, 0x000fe400020006ffULL,
0x0000541054787816ULL, 0x000fe40000000058ULL, 0x0000541079797816ULL, 0x000fe4000000005bULL,
0x00000010ff547819ULL, 0x000fe20000011655ULL, 0x000000005958783bULL, 0x000e620000000200ULL,
0x0000ffff557c7812ULL, 0x040fe400078ec0ffULL, 0x000000ff547a7812ULL, 0x000fe200078ec0ffULL,
0x000000785020723cULL, 0x004f620000001820ULL, 0x000000ff55557812ULL, 0x000fc400078ec0ffULL,
0x00000008ff547819ULL, 0x000fe4000001167cULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x000000783c18723cULL, 0x008b620000001818ULL,
0x0000ffff577c7812ULL, 0x000fcc00078ec0ffULL, 0x0000007aff79723eULL, 0x020fe400020006ffULL,
0x0000541055787816ULL, 0x000fe40000000054ULL, 0x0000541079797816ULL, 0x000fe4000000007bULL,
0x00000010ff547819ULL, 0x100fe40000011656ULL, 0x0000ffff567b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7a7819ULL, 0x000fe20000011656ULL, 0x00000078501c723cULL, 0x000f62000000181cULL,
0x000000ff54557812ULL, 0x000fc400078ec0ffULL, 0x000000ff56567812ULL, 0x000fe400078ec0ffULL,
0x00000008ff547819ULL, 0x000fe4000001167bULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x000000783c04723cULL, 0x000b620000001804ULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fc400020006ffULL,
0x0000541055557816ULL, 0x000fe4000000007aULL, 0x0000541056547816ULL, 0x000fe40000000054ULL,
0x0000006f75567210ULL, 0x000fe40007ffe074ULL, 0x00000010ff747819ULL, 0x002fe40000011658ULL,
0xfffffff07d807812ULL, 0x000fe200078ee256ULL, 0x000000545008723cULL, 0x000fe20000001808ULL,
0x000000ff57567812ULL, 0x000fc400078ec0ffULL, 0x00000018ff757819ULL, 0x000fe40000011658ULL,
0x000000ff58767812ULL, 0x040fe400078ec0ffULL, 0x0000ffff58837812ULL, 0x000fe200078ec0ffULL,
0x000000543c14723cULL, 0x000be20000001814ULL, 0x00000010ff587819ULL, 0x000fe40000011659ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000018ff797819ULL, 0x020fc4000001165aULL,
0x00000010ff547819ULL, 0x100fe40000011657ULL, 0x00000018ff557819ULL, 0x000fe40000011657ULL,
0x000000ff54577812ULL, 0x000fe400078ec0ffULL, 0x00000008ff547819ULL, 0x000fe4000001167cULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fc400020006ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x000000ff58587812ULL, 0x000fe400078ec0ffULL,
0x00000018ff777819ULL, 0x000fe40000011659ULL, 0x0000541057577816ULL, 0x000fe40000000055ULL,
0x0000541056567816ULL, 0x000fe40000000054ULL, 0x00000079ff7c723eULL, 0x000fc400020006ffULL,
0x000000ff59787812ULL, 0x040fe400078ec0ffULL, 0x0000ffff59847812ULL, 0x000fe200078ec0ffULL,
0x00000056502c723cULL, 0x080f62000000182cULL, 0x00000010ff7a7819ULL, 0x000fe4000001165aULL,
0x000000ff5a7b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5a857812ULL, 0x000fe400078ec0ffULL,
0x00000058ff79723eULL, 0x000fe200020006ffULL, 0x000000107f587824ULL, 0x000fe200078e0270ULL,
0x00000010ff5a7819ULL, 0x000fe2000001165bULL, 0x000000563c48723cULL, 0x000b620000001848ULL,
0x00000077ff59723eULL, 0x000fc400020006ffULL, 0x00000008ff547819ULL, 0x000fe40000011683ULL,
0x00000008ff557819ULL, 0x000fe40000011684ULL, 0x00000018ff7d7819ULL, 0x000fe4000001165bULL,
0x000000ff5b7e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5b867812ULL, 0x000fe400078ec0ffULL,
0x000000ff5a567812ULL, 0x020fc400078ec0ffULL, 0x0000541079797816ULL, 0x000fe40000000059ULL,
0x000000005858783bULL, 0x000e620000000200ULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x000000ff74747812ULL, 0x000fe400078ec0ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000055ff55723eULL, 0x000fc400020006ffULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x00000074ff77723eULL, 0x000fe400020006ffULL,
0x0000541076767816ULL, 0x000fe40000000054ULL, 0x0000541078787816ULL, 0x000fe40000000055ULL,
0x000000ff7a7a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff547819ULL, 0x000fc40000011685ULL,
0x00000008ff557819ULL, 0x000fe20000011686ULL, 0x00000078504c723cULL, 0x040fe2000000184cULL,
0x0000541077777816ULL, 0x000fe40000000075ULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x0000007aff75723eULL, 0x000fe200020006ffULL,
0x000000765040723cULL, 0x000fe20000001840ULL, 0x00000054ff54723eULL, 0x000fc400020006ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00000056ff7f723eULL, 0x000fe200020006ffULL,
0x0000001073567824ULL, 0x000fe200078e00ffULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x000000763c28723cULL, 0x000fe20000001828ULL, 0x0000541075757816ULL, 0x000fe4000000007cULL,
0x000054107b747816ULL, 0x000fe20000000054ULL, 0x0000001080547824ULL, 0x000fe200078e00ffULL,
0x000054107f7f7816ULL, 0x000fc4000000007dULL, 0x000054107e7e7816ULL, 0x000fe20000000055ULL,
0x000000783c34723cULL, 0x000fe20000001834ULL, 0xfffffff056817812ULL, 0x000fe400078ee281ULL,
0x000000005454783bULL, 0x000ea20000000200ULL, 0x00000018ff737819ULL, 0x102fe40000011658ULL,
0x00000010ff727819ULL, 0x000fe40000011658ULL, 0x000000745030723cULL, 0x040f700000001830ULL,
0x0000007e5044723cULL, 0x000bee0000001844ULL, 0x0000001081507824ULL, 0x020fe200078e00ffULL,
0x000000743c38723cULL, 0x040b6a0000001838ULL, 0x000000005050783bULL, 0x000e640000000200ULL,
0x0000ffff58757812ULL, 0x020fe200078ec0ffULL, 0x0000007e3c24723cULL, 0x000b620000001824ULL,
0x00000073ff74723eULL, 0x000fc400020006ffULL, 0x000000ff72737812ULL, 0x000fe400078ec0ffULL,
0x000000ff58587812ULL, 0x000fe400078ec0ffULL, 0x00000010713c7824ULL, 0x020fe200078e0270ULL,
0x00000008ff727819ULL, 0x000fe40000011675ULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x000000003c3c783bULL, 0x000ee20000000200ULL,
0x00000073ff73723eULL, 0x000fc400020006ffULL, 0x0000541058727816ULL, 0x000fe40000000072ULL,
0x0000ffff59587812ULL, 0x040fe400078ec0ffULL, 0x00000010ff707819ULL, 0x100fe40000011659ULL,
0x00000018ff717819ULL, 0x000fe40000011659ULL, 0x000000ff59597812ULL, 0x000fe400078ec0ffULL,
0x00000008ff587819ULL, 0x000fc40000011658ULL, 0x0000541073737816ULL, 0x000fe40000000074ULL,
0x000000ff70707812ULL, 0x000fe400078ec0ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x000000725420723cULL, 0x004f620000001820ULL,
0x00000071ff74723eULL, 0x000fe400020006ffULL, 0x00000070ff71723eULL, 0x000fc400020006ffULL,
0x0000541059707816ULL, 0x000fe40000000058ULL, 0x00000010ff587819ULL, 0x000fe2000001165bULL,
0x000000725018723cULL, 0x002b620000001818ULL, 0x0000541071717816ULL, 0x000fe40000000074ULL,
0x000000ff58597812ULL, 0x000fc800078ec0ffULL, 0x0000ffff5b737812ULL, 0x060fe200078ec0ffULL,
0x00000070541c723cULL, 0x080f62000000181cULL, 0x00000018ff727819ULL, 0x000fe4000001165bULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff587819ULL, 0x000fe40000011673ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x000000705004723cULL, 0x000b620000001804ULL,
0x0000005bff5b723eULL, 0x000fc400020006ffULL, 0x0000ffff5a737812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3c7b7812ULL, 0x008fe400078ec0ffULL, 0x00000059ff71723eULL, 0x020fe400020006ffULL,
0x00000058ff70723eULL, 0x000fe400020006ffULL, 0x00000010ff587819ULL, 0x000fe4000001165aULL,
0x0000541071717816ULL, 0x000fc40000000072ULL, 0x000054105b707816ULL, 0x000fe40000000070ULL,
0x00000018ff597819ULL, 0x000fe4000001165aULL, 0x000000ff585b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5a5a7812ULL, 0x000fe200078ec0ffULL, 0x00000070542c723cULL, 0x000f62000000182cULL,
0x00000008ff587819ULL, 0x000fe40000011673ULL, 0x0000005aff5a723eULL, 0x000fc400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x000000ff3c727812ULL, 0x000fe200078ec0ffULL,
0x000000705048723cULL, 0x000b620000001848ULL, 0x000054105a5a7816ULL, 0x000fe40000000058ULL,
0x0000ffff3d7c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff757819ULL, 0x000fe4000001163eULL,
0x00000010ff707819ULL, 0x020fc4000001163cULL, 0x00000018ff717819ULL, 0x000fe4000001163cULL,
0x00000018ff3c7819ULL, 0x000fe4000001163dULL, 0x00000018ff767819ULL, 0x000fe4000001163eULL,
0x0000003cff58723eULL, 0x000fe400020006ffULL, 0x00000008ff3c7819ULL, 0x000fe4000001167bULL,
0x000000ff3e777812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3e7d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3d737812ULL, 0x000fe400078ec0ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000008ff3e7819ULL, 0x000fe4000001167cULL,
0x00000010ff747819ULL, 0x000fc4000001163dULL, 0x00000073ff3d723eULL, 0x000fe400020006ffULL,
0x0000541072727816ULL, 0x000fe4000000003cULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x000000ff75757812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3c7819ULL, 0x000fe4000001167dULL,
0x000054103d3e7816ULL, 0x000fc4000000003eULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000075ff3d723eULL, 0x000fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x000000ff74747812ULL, 0x000fe400078ec0ffULL,
0x000054103d3d7816ULL, 0x000fc40000000076ULL, 0x00005410773c7816ULL, 0x000fe4000000003cULL,
0x00000010ff787819ULL, 0x100fe4000001163fULL, 0x00000018ff797819ULL, 0x000fe4000001163fULL,
0x000000ff3f7a7812ULL, 0x040fe200078ec0ffULL, 0x0000003c5430723cULL, 0x000f620000001830ULL,
0x0000ffff3f7e7812ULL, 0x000fe400078ec0ffULL, 0x00000074ff3f723eULL, 0x000fc400020006ffULL,
0x000000ff70707812ULL, 0x000fe400078ec0ffULL, 0x000054103f3f7816ULL, 0x000fe20000000058ULL,
0x0000003c5038723cULL, 0x000b620000001838ULL, 0x000000ff78787812ULL, 0x000fe400078ec0ffULL,
0x00000008ff587819ULL, 0x000fe4000001167eULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x000000046e3c7810ULL, 0x020fe20007ffe0ffULL, 0x0000003e544c723cULL, 0x000b62000000184cULL,
0x0000005bff5b723eULL, 0x000fc400020006ffULL, 0x000000183c00780cULL, 0x000fe40003f25270ULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000070ff73723eULL, 0x000fe200020006ffULL,
0x0000003e5034723cULL, 0x000b620000001834ULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00000078ff7b723eULL, 0x000fc400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x000054105b5b7816ULL, 0x000fe40000000059ULL,
0x0000541073737816ULL, 0x000fe40000000071ULL, 0x000054107b7b7816ULL, 0x000fe40000000079ULL,
0x000054107a7a7816ULL, 0x000fe20000000058ULL, 0x0000005a5408723cULL, 0x000b620000001808ULL,
0xfffffff46e747810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff6e7224ULL, 0x000fcc00078e003cULL,
0x0000005a5014723cULL, 0x000b700000001814ULL, 0x000000725440723cULL, 0x040b700000001840ULL,
0x0000007a5444723cULL, 0x000b700000001844ULL, 0x000000725028723cULL, 0x040b700000001828ULL,
0x0000007a5024723cULL, 0x000b620000001824ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffede000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff687224ULL, 0x000fe200078e0060ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe06000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x000000662d587220ULL, 0x080fe20000410000ULL, 0x00000066206b7220ULL, 0x080fe20000410000ULL,
0x0000006621557220ULL, 0x0a0fe20000410000ULL, 0x000000661c687220ULL, 0x080fe20000410000ULL,
0x000000661d567220ULL, 0x080fe20000410000ULL, 0x00000066085b7220ULL, 0x080fe20000410000ULL,
0x0000006609577220ULL, 0x080fe20000410000ULL, 0x000000662c5a7220ULL, 0x080fe20000410000ULL,
0x0000006642427220ULL, 0x080fe20000410000ULL, 0x0000006643437220ULL, 0x080fe20000410000ULL,
0x00000066062d7220ULL, 0x080fe20000410000ULL, 0x00000066076a7220ULL, 0x080fe20000410000ULL,
0x0000006622227220ULL, 0x080fe20000410000ULL, 0x0000006623237220ULL, 0x080fe20000410000ULL,
0x000000661e1e7220ULL, 0x080fe20000410000ULL, 0x000000661f1f7220ULL, 0x080fe20000410000ULL,
0x000000660a0a7220ULL, 0x080fe20000410000ULL, 0x000000660b0b7220ULL, 0x080fe20000410000ULL,
0x000000662e087220ULL, 0x080fe20000410000ULL, 0x000000662f097220ULL, 0x080fe20000410000ULL,
0x000000664e1c7220ULL, 0x080fe20000410000ULL, 0x000000664f1d7220ULL, 0x080fe20000410000ULL,
0x0000006632207220ULL, 0x080fe20000410000ULL, 0x0000006633217220ULL, 0x080fe20000410000ULL,
0x00000066472c7220ULL, 0x080fe20000410000ULL, 0x0000006618187220ULL, 0x080fe20000410000ULL,
0x0000006619197220ULL, 0x080fe20000410000ULL, 0x0000006604047220ULL, 0x080fe20000410000ULL,
0x0000006605057220ULL, 0x080fe20000410000ULL, 0x0000006634067220ULL, 0x080fe20000410000ULL,
0x0000006635077220ULL, 0x080fe20000410000ULL, 0x000000664c537220ULL, 0x080fe20000410000ULL,
0x000000664d527220ULL, 0x080fe20000410000ULL, 0x00000066454e7220ULL, 0x080fe20000410000ULL,
0x00000066143c7220ULL, 0x080fe20000410000ULL, 0x00000066153d7220ULL, 0x080fe20000410000ULL,
0x00000066483e7220ULL, 0x080fe20000410000ULL, 0x0000006640597220ULL, 0x080fe20000410000ULL,
0x0000006641547220ULL, 0x080fe20000410000ULL, 0x0000006630517220ULL, 0x080fe20000410000ULL,
0x0000006631507220ULL, 0x080fe20000410000ULL, 0x00000066444f7220ULL, 0x080fe20000410000ULL,
0x00000066464c7220ULL, 0x080fe20000410000ULL, 0x00000066493f7220ULL, 0x080fe20000410000ULL,
0x000000664a147220ULL, 0x080fe20000410000ULL, 0x000000664b157220ULL, 0x080fe20000410000ULL,
0x00000066366e7220ULL, 0x080fe20000410000ULL, 0x00000066376f7220ULL, 0x080fe20000410000ULL,
0x00000066384d7220ULL, 0x080fe20000410000ULL, 0x0000006639457220ULL, 0x080fe20000410000ULL,
0x000000663a707220ULL, 0x080fe20000410000ULL, 0x000000663b717220ULL, 0x080fe20000410000ULL,
0x000000ffff337224ULL, 0x000fe200078e0042ULL, 0x000000661a1a7220ULL, 0x080fe20000410000ULL,
0x000000ffff487224ULL, 0x000fe200078e0043ULL, 0x000000661b1b7220ULL, 0x080fe20000410000ULL,
0x0000006616167220ULL, 0x080fe20000410000ULL, 0x0000006617177220ULL, 0x080fe20000410000ULL,
0x0000006628407220ULL, 0x080fe20000410000ULL, 0x0000006629417220ULL, 0x080fe20000410000ULL,
0x000000662a6c7220ULL, 0x080fe20000410000ULL, 0x000000662b6d7220ULL, 0x080fe20000410000ULL,
0x0000006624467220ULL, 0x080fe20000410000ULL, 0x0000006625497220ULL, 0x080fe20000410000ULL,
0x0000006626727220ULL, 0x080fe20000410000ULL, 0x0000006627737220ULL, 0x000fe20000410000ULL,
0x000000ffff2e7224ULL, 0x000fc400078e0022ULL, 0x000000ffff4b7224ULL, 0x000fe400078e0023ULL,
0x000000ffff2f7224ULL, 0x000fe400078e001eULL, 0x000000ffff317224ULL, 0x000fe400078e001fULL,
0x000000ffff307224ULL, 0x000fe400078e000aULL, 0x000000ffff477224ULL, 0x000fe400078e000bULL,
0x000000ffff327224ULL, 0x000fc400078e0008ULL, 0x000000ffff347224ULL, 0x000fe400078e0009ULL,
0x000000ffff357224ULL, 0x000fe400078e001cULL, 0x000000ffff447224ULL, 0x000fe400078e001dULL,
0x000000ffff367224ULL, 0x000fe400078e0020ULL, 0x000000ffff377224ULL, 0x000fe400078e0021ULL,
0x000000ffff4a7224ULL, 0x000fc400078e002cULL, 0x000000ffff397224ULL, 0x000fe400078e0018ULL,
0x000000ffff387224ULL, 0x000fe400078e0019ULL, 0x000000ffff3a7224ULL, 0x000fe400078e0004ULL,
0x000000ffff3b7224ULL, 0x000fe400078e0005ULL, 0x000000ffff427224ULL, 0x000fe400078e0006ULL,
0x000000ffff437224ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000065087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff277224ULL, 0x000fc400078e002dULL,
0x000000ffff287224ULL, 0x000fe400078e001aULL, 0x000000ffff2c7224ULL, 0x000fe400078e001bULL,
0x000000ffff297224ULL, 0x000fe400078e006aULL, 0x000000ffff2a7224ULL, 0x000fe400078e0016ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0017ULL, 0x000000ffff2b7224ULL, 0x000fc400078e0014ULL,
0x000000ffff267224ULL, 0x000fe400078e0015ULL, 0x000000ffff257224ULL, 0x000fe400078e006cULL,
0x000000ffff247224ULL, 0x000fe400078e006dULL, 0x000000ffff1e7224ULL, 0x000fe400078e006eULL,
0x000000ffff1f7224ULL, 0x000fe400078e006fULL, 0x000000ffff207224ULL, 0x000fc400078e0070ULL,
0x000000ffff217224ULL, 0x000fe400078e0071ULL, 0x000000ffff227224ULL, 0x000fe400078e0072ULL,
0x000000ffff237224ULL, 0x000fc400078e0073ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x0000040065077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040065077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000040f1d7824ULL, 0x000fe200078e00ffULL, 0x000000126100720cULL, 0x000fc80003f06070ULL,
0xfffffff01d1c7812ULL, 0x000fca00078ec0ffULL, 0x00000080111c7824ULL, 0x000fca00078e021cULL,
0x012400001c047984ULL, 0x0002a20000000c00ULL, 0x000021f000008947ULL, 0x000fea0003800000ULL,
0x00005a00000b7b06ULL, 0x000ee20000209000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000000100f0a7211ULL, 0x040fe200078ff0ffULL, 0x000000020f6d7824ULL, 0x000fc600078e00ffULL,
0x000000100a167810ULL, 0x000fe40007ffe0ffULL, 0x000000066d6d7812ULL, 0x000fca00078ec0ffULL,
0x000000016d6f7824ULL, 0x000fe200078e0213ULL, 0x0000000b000b7308ULL, 0x008ee40000001000ULL,
0x0ffffffe0b157810ULL, 0x008fcc0007ffe0ffULL, 0x0000001500097305ULL, 0x000ee4000021f000ULL,
0x000000ffff177224ULL, 0x008fc800078e0a09ULL, 0x00005a0017177a24ULL, 0x000fc800078e02ffULL,
0x0000001709197227ULL, 0x000fe200078e0008ULL, 0x000000080a097810ULL, 0x000fca0007ffe0ffULL,
0x0000000a19087227ULL, 0x000fc800078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a08ULL,
0x0000000919147227ULL, 0x000fc800078e00ffULL, 0x00005a000b0b7a24ULL, 0x000fe200078e020aULL,
0x000000180a0a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe400078e0a14ULL,
0x0000001619177227ULL, 0x000fe200078e00ffULL, 0x00005a000b007a0cULL, 0x000fc60003f06070ULL,
0x00005a0018157a24ULL, 0x000fe400078e0209ULL, 0x0000000a19187227ULL, 0x000fc600078e00ffULL,
0x00005a0015007a0cULL, 0x000fe20003fa6070ULL, 0x000000ffff097224ULL, 0x000fe400078e0a17ULL,
0x000000ffff197224ULL, 0x000fe400078e0a18ULL, 0x00005a0009167a24ULL, 0x000fe200078e0216ULL,
0x80005a000b0b0a10ULL, 0x000fe20007ffe0ffULL, 0x00005a00190a7a24ULL, 0x000fe200078e020aULL,
0x0000000108080810ULL, 0x000fe20007ffe0ffULL, 0x0000010061097824ULL, 0x000fe200078e025dULL,
0x00005a0016007a0cULL, 0x000fc40003f26070ULL, 0x00005a000a007a0cULL, 0x000fe40003f66070ULL,
0x00005a000b007a0cULL, 0x000fe20003f46070ULL, 0x00000001630b7824ULL, 0x000fe200078e026dULL,
0x000000090e6a7217ULL, 0x000fe40007800000ULL, 0x80005a0015155a10ULL, 0x000fe40007ffe0ffULL,
0x0000000114145810ULL, 0x000fe20007ffe0ffULL, 0x000000016a6a7824ULL, 0x000fe200078e0a09ULL,
0x00005a0015007a0cULL, 0x000fc40003fc6070ULL, 0x80005a0016161a10ULL, 0x000fe20007ffe0ffULL,
0x000000016f097824ULL, 0x100fe200078e0a6aULL, 0x80005a000a0a3a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0016007a0cULL, 0x000fe40003f86070ULL, 0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL,
0x00005a00ff197a12ULL, 0x000fe400078e33ffULL, 0x0000006a0b00720cULL, 0x040fe20003f06070ULL,
0x000000010b0b7824ULL, 0x000fe200078e0a6aULL, 0x0000000108082810ULL, 0x000fc40007ffe0ffULL,
0x00000009647a7217ULL, 0x000fe40003800000ULL, 0x00005a000a007a0cULL, 0x000fe40003f46070ULL,
0x0000000819097207ULL, 0x000fe40006800000ULL, 0x0000000b640b7217ULL, 0x000fe40003800000ULL,
0x0000000114146810ULL, 0x000fe40007ffe0ffULL, 0x0000000964087217ULL, 0x000fc40003800000ULL,
0x0000000117171810ULL, 0x000fe40007ffe0ffULL, 0x0000006a6f00720cULL, 0x000fe20003fc6070ULL,
0x0000000867937224ULL, 0x000fe200078e02ffULL, 0x00000004ff0b7819ULL, 0x000fe4000001160bULL,
0x0000001419157207ULL, 0x000fe40006800000ULL, 0x0000000118183810ULL, 0x000fe40007ffe0ffULL,
0x0000000117174810ULL, 0x000fc40007ffe0ffULL, 0x000000ff7a7a7207ULL, 0x000fe40003000000ULL,
0x000000ff0b147207ULL, 0x000fe40000000000ULL, 0x00000015640a7217ULL, 0x000fe40003800000ULL,
0x0000000118182810ULL, 0x000fe20007ffe0ffULL, 0x00000001930b7824ULL, 0x000fe200078e0214ULL,
0x0000001719157207ULL, 0x000fe20006800000ULL, 0x0000000a67977224ULL, 0x000fe200078e02ffULL,
0x000000937a097211ULL, 0x000fe200078fe0ffULL, 0x000000020b0a7825ULL, 0x000fe200078e0002ULL,
0x0000001819197207ULL, 0x000fc40006800000ULL, 0x0000001564187217ULL, 0x040fe20003800000ULL,
0x0000000209087825ULL, 0x000fe200078e0002ULL, 0x00000019641a7217ULL, 0x000fe20003800000ULL,
0x000000060a6c7981ULL, 0x0046a2000c1e9500ULL, 0x000000106d797812ULL, 0x000fe200078efcffULL,
0x0000000114177824ULL, 0x000fe400078e0297ULL, 0x0000001867997224ULL, 0x000fe200078e02ffULL,
0x0000000608717981ULL, 0x0002a2000c1e9500ULL, 0x0000000217167825ULL, 0x000fe200078e0002ULL,
0x000000977a157211ULL, 0x000fc400078fe0ffULL, 0x000000997a1b7211ULL, 0x000fe200078fe0ffULL,
0x0000001a679b7224ULL, 0x000fe200078e02ffULL, 0x00000006166e7981ULL, 0x0002a2000c1e9500ULL,
0x0000000114197824ULL, 0x000fe400078e0299ULL, 0x00000001637d7824ULL, 0x000fe200078e0279ULL,
0x0000009b7a737211ULL, 0x000fe200078fe0ffULL, 0x0000000114757824ULL, 0x000fe400078e029bULL,
0x0000000215147825ULL, 0x000fc800078e0002ULL, 0x0000000219187825ULL, 0x000fc800078e0002ULL,
0x000000021b0a7825ULL, 0x008fe200078e0002ULL, 0x0000000618707981ULL, 0x0006a6000c1e9500ULL,
0x000000017d177824ULL, 0x002fe400078e0a6aULL, 0x0000000179777824ULL, 0x000fe400078e0213ULL,
0x00000002751a7825ULL, 0x100fe200078e0002ULL, 0x0000001764167217ULL, 0x000fe20003800000ULL,
0x000000060a757981ULL, 0x0002a4000c1e9500ULL, 0x0000000273087825ULL, 0x000fc400078e0002ULL,
0x0000000614737981ULL, 0x0002a4000c1e9500ULL, 0x0000000177177824ULL, 0x000fe200078e0a6aULL,
0x0000006a7d00720cULL, 0x080fe20003f26070ULL, 0x000000061a727981ULL, 0x0006a2000c1e9500ULL,
0x00000004ff167819ULL, 0x000fe40000011616ULL, 0x0000006a7700720cULL, 0x000fe20003f06070ULL,
0x00000006087b7981ULL, 0x0006a2000c1e9500ULL, 0x0000001764177217ULL, 0x000fe40003800000ULL,
0x000000ff16147207ULL, 0x002fc40000800000ULL, 0x000000ff17807207ULL, 0x000fe40000000000ULL,
0x000000206d837812ULL, 0x000fe200078efcffULL, 0x0000000114177824ULL, 0x000fe200078e0297ULL,
0x0000009380097211ULL, 0x048fe200078fe0ffULL, 0x00000001930b7824ULL, 0x000fe200078e0214ULL,
0x0000009780157211ULL, 0x040fe200078fe0ffULL, 0x0000000217167825ULL, 0x000fe200078e0002ULL,
0x0000009b807f7211ULL, 0x000fc600078fe0ffULL, 0x0000000209087825ULL, 0x000fe200078e0002ULL,
0x0000000616767981ULL, 0x0002e6000c1e9500ULL, 0x0000000163897824ULL, 0x000fe200078e0283ULL,
0x00000006087d7981ULL, 0x0002e2000c1e9500ULL, 0x00000001141b7824ULL, 0x040fe400078e0299ULL,
0x0000000114817824ULL, 0x000fe400078e029bULL, 0x000000020b0a7825ULL, 0x000fc800078e0002ULL,
0x0000000215147825ULL, 0x000fe200078e0002ULL, 0x000000060a747981ULL, 0x0002e6000c1e9500ULL,
0x0000000189177824ULL, 0x002fe400078e0a6aULL, 0x000000027f087825ULL, 0x000fe400078e0002ULL,
0x00000006147f7981ULL, 0x0002e4000c1e9500ULL, 0x0000000183857824ULL, 0x000fe200078e0213ULL,
0x0000001764167217ULL, 0x000fc40003800000ULL, 0x0000009980197211ULL, 0x000fe200078fe0ffULL,
0x0000000185177824ULL, 0x000fe200078e0a6aULL, 0x0000006a8900720cULL, 0x080fe20003f26070ULL,
0x000000021b1a7825ULL, 0x000fe200078e0002ULL, 0x00000004ff167819ULL, 0x000fe20000011616ULL,
0x0000000608877981ULL, 0x0002e2000c1e9500ULL, 0x0000006a8500720cULL, 0x000fe20003f06070ULL,
0x0000000219187825ULL, 0x100fe200078e0002ULL, 0x0000001764177217ULL, 0x000fe20003800000ULL,
0x000000061a787981ULL, 0x0002e4000c1e9500ULL, 0x00000002810a7825ULL, 0x000fe200078e0002ULL,
0x000000ff16167207ULL, 0x000fe20000800000ULL, 0x0000000618817981ULL, 0x0002e2000c1e9500ULL,
0x000000ff17847207ULL, 0x000fc60000000000ULL, 0x000000060a7c7981ULL, 0x0002e2000c1e9500ULL,
0x0000000116897824ULL, 0x000fe400078e0297ULL, 0x0000000193097824ULL, 0x002fe200078e0216ULL,
0x0000009784197211ULL, 0x040fe200078fe0ffULL, 0x0000000289887825ULL, 0x000fe200078e0002ULL,
0x0000009b848d7211ULL, 0x000fc600078fe0ffULL, 0x0000000209087825ULL, 0x100fe200078e0002ULL,
0x00000093841b7211ULL, 0x040fe200078fe0ffULL, 0x0000000688887981ULL, 0x0002e4000c1e9500ULL,
0x0000000219187825ULL, 0x100fe400078e0002ULL, 0x00000006087e7981ULL, 0x0002e2000c1e9500ULL,
0x0000009984157211ULL, 0x000fe200078fe0ffULL, 0x000000021b1a7825ULL, 0x100fe400078e0002ULL,
0x0000000618897981ULL, 0x0022e4000c1e9500ULL, 0x000000028d087825ULL, 0x000fe200078e0002ULL,
0x000000306d8d7812ULL, 0x000fe200078efcffULL, 0x000000061a8b7981ULL, 0x0002e4000c1e9500ULL,
0x0000000116177824ULL, 0x000fc400078e0299ULL, 0x00000001160b7824ULL, 0x000fe200078e029bULL,
0x0000000608dd7981ULL, 0x0002e2000c1e9500ULL, 0x0000000163957824ULL, 0x000fe400078e028dULL,
0x0000000217167825ULL, 0x000fc800078e0002ULL, 0x0000000215147825ULL, 0x100fe200078e0002ULL,
0x0000000616827981ULL, 0x0002e6000c1e9500ULL, 0x000000020b0a7825ULL, 0x000fe200078e0002ULL,
0x0000000614917981ULL, 0x0002e6000c1e9500ULL, 0x00000001951b7824ULL, 0x002fe200078e0a6aULL,
0x000000060a947981ULL, 0x0002e2000c1e9500ULL, 0x000000018d8f7824ULL, 0x000fc600078e0213ULL,
0x0000001b641a7217ULL, 0x040fe20003800000ULL, 0x000000018f1b7824ULL, 0x000fe200078e0a6aULL,
0x0000006a9500720cULL, 0x080fe40003f26070ULL, 0x0000006a8f00720cULL, 0x000fe40003f06070ULL,
0x00000004ff1a7819ULL, 0x000fe4000001161aULL, 0x0000001b641b7217ULL, 0x000fe40003800000ULL,
0x000000ff1a8a7207ULL, 0x000fc40000800000ULL, 0x000000ff1b867207ULL, 0x000fc60000000000ULL,
0x0000000193197824ULL, 0x000fe200078e028aULL, 0x00000093861b7211ULL, 0x000fe200078fe0ffULL,
0x000000018a157824ULL, 0x000fe200078e0299ULL, 0x0000009986177211ULL, 0x000fe200078fe0ffULL,
0x0000000219187825ULL, 0x000fc800078e0002ULL, 0x000000021b1a7825ULL, 0x100fe200078e0002ULL,
0x00000006188c7981ULL, 0x0002e6000c1e9500ULL, 0x0000000215147825ULL, 0x100fe200078e0002ULL,
0x000000061ac37981ULL, 0x0002e6000c1e9500ULL, 0x0000000217167825ULL, 0x000fe200078e0002ULL,
0x0000000614927981ULL, 0x0002e4000c1e9500ULL, 0x00000097860b7211ULL, 0x002fc400078fe0ffULL,
0x0000000616db7981ULL, 0x0002e2000c1e9500ULL, 0x000000018a097824ULL, 0x000fe400078e0297ULL,
0x000000020b0a7825ULL, 0x000fc800078e0002ULL, 0x0000000209087825ULL, 0x000fe200078e0002ULL,
0x000000060ad97981ULL, 0x0002e2000c1e9500ULL, 0x0000009b86197211ULL, 0x000fc600078fe0ffULL,
0x0000000608907981ULL, 0x0002e2000c1e9500ULL, 0x000000018a1b7824ULL, 0x000fe400078e029bULL,
0x0000000219187825ULL, 0x000fc800078e0002ULL, 0x000000021b1a7825ULL, 0x000fe200078e0002ULL,
0x0000000618df7981ULL, 0x0002e8000c1e9500ULL, 0x000000061a967981ULL, 0x0002e4000c1e9500ULL,
0xfffffff07a097812ULL, 0x002fe200078ec0ffULL, 0x00000001ffd77424ULL, 0x000fc800078e00ffULL,
0x000000016a087824ULL, 0x000fc800078e0209ULL, 0x000000016f097824ULL, 0x000fe200078e0a08ULL,
0x000000016d937812ULL, 0x000fc800078efcffULL, 0x00000009d7097219ULL, 0x000fe200000006ffULL,
0x00000001930b7824ULL, 0x000fe200078e0213ULL, 0xfffffff080157812ULL, 0x000fc600078ec0ffULL,
0x000000010b0a7824ULL, 0x100fe200078e0a08ULL, 0x000000086d957812ULL, 0x040fe200078efcffULL,
0x000000016a167824ULL, 0x000fe200078e0215ULL, 0x000000096d977812ULL, 0x000fe400078efcffULL,
0x0000000ad7157219ULL, 0x000fe200000006ffULL, 0x0000000195177824ULL, 0x100fe400078e0213ULL,
0x00000001971b7824ULL, 0x000fe200078e0213ULL, 0xfffffff084197812ULL, 0x000fe200078ec0ffULL,
0x0000000117147824ULL, 0x100fe200078e0a08ULL, 0xfffffff086997812ULL, 0x000fe200078ec0ffULL,
0x000000011b087824ULL, 0x000fe200078e0a08ULL, 0x000000116d9d7812ULL, 0x000fe200078efcffULL,
0x000000016a187824ULL, 0x040fe200078e0219ULL, 0x00000014d7197219ULL, 0x040fe200000006ffULL,
0x000000016a847824ULL, 0x000fe200078e0299ULL, 0x00000008d7997219ULL, 0x000fe200000006ffULL,
0x000000019d9f7824ULL, 0x000fc400078e0213ULL, 0x0000000177087824ULL, 0x100fe400078e0a16ULL,
0x000000019f0a7824ULL, 0x000fe200078e0a16ULL, 0x000000186da37812ULL, 0x000fe400078efcffULL,
0x00005410716c7816ULL, 0x004fc8000000006cULL, 0x0000006c09ff7212ULL, 0x000fc800078ac0ffULL,
0x0000006a6f00720cULL, 0x000fc80002fa1470ULL, 0x0000006a6d00720cULL, 0x000fe40002fa1070ULL,
0x0000006c15ff7212ULL, 0x000fe4000782c0ffULL, 0xff8000006b6b7808ULL, 0x000fe40002800000ULL,
0x0000006a0b00720cULL, 0x000fe40000f21470ULL, 0x0000541075707816ULL, 0x000fe40000000070ULL,
0x00005410736e7816ULL, 0x000fc4000000006eULL, 0x0000007009ff7212ULL, 0x040fe4000788c0ffULL,
0x0000006e09ff7212ULL, 0x080fe4000784c0ffULL, 0x0000006e15ff7212ULL, 0x000fe400078ac0ffULL,
0x0000006a6f00720cULL, 0x0c0fe40001741470ULL, 0x0000006a6f00720cULL, 0x080fe40002781470ULL,
0x0000006a0b00720cULL, 0x000fc40002fa1470ULL, 0x0000006a6d00720cULL, 0x0c0fe40001741070ULL,
0x0000006a6d00720cULL, 0x080fe40002781070ULL, 0x0000006a9300720cULL, 0x0c0fe40000f21070ULL,
0x0000006a9300720cULL, 0x000fe40002fa1070ULL, 0x000054107b727816ULL, 0x000fe40000000072ULL,
0xff8000002e2e7808ULL, 0x000fc40001000000ULL, 0xff80000039397808ULL, 0x000fe40002000000ULL,
0xff80000055557808ULL, 0x000fe40000800000ULL, 0xff8000004b4b7808ULL, 0x000fe40002800000ULL,
0x0000006c19ff7212ULL, 0x000fe4000786c0ffULL, 0x0000007209ff7212ULL, 0x000fe4000780c0ffULL,
0x0000007015ff7212ULL, 0x000fc4000784c0ffULL, 0x0000007215ff7212ULL, 0x000fe4000788c0ffULL,
0x0000006e99ff7212ULL, 0x000fe4000782c0ffULL, 0x0000007019ff7212ULL, 0x000fe400078ac0ffULL,
0x0000006a6f00720cULL, 0x080fe40000701470ULL, 0x0000006a0b00720cULL, 0x0c0fe40001741470ULL,
0x0000006a0b00720cULL, 0x000fc40002781470ULL, 0x0000006a1700720cULL, 0x0c0fe40001f61470ULL,
0x0000006a1700720cULL, 0x080fe40002fa1470ULL, 0x0000006a1b00720cULL, 0x080fe40000f21470ULL,
0x000000196da97812ULL, 0x040fe400078efcffULL, 0x0000006a6d00720cULL, 0x080fe40000701070ULL,
0x0000006a9300720cULL, 0x000fc40001741070ULL, 0x0000006a9300720cULL, 0x080fe40002781070ULL,
0x0000006a9500720cULL, 0x0c0fe40001f61070ULL, 0x0000006a9500720cULL, 0x080fe40002fa1070ULL,
0x0000006a9700720cULL, 0x000fe40000f21070ULL, 0x00000008d79b7219ULL, 0x040fe400000006ffULL,
0x0000000ad7a17219ULL, 0x000fc400000006ffULL, 0x000054107d747816ULL, 0x008fe40000000074ULL,
0x000054107f767816ULL, 0x000fe20000000076ULL, 0x00000001a3a57824ULL, 0x100fe200078e0213ULL,
0xff80000028287808ULL, 0x000fe20000000000ULL, 0x00000001a9ab7824ULL, 0x000fe200078e0213ULL,
0xff80000038387808ULL, 0x000fe40001000000ULL, 0xff8000002c2c7808ULL, 0x000fe40002000000ULL,
0xff80000068687808ULL, 0x000fc40001800000ULL, 0xff8000003a3a7808ULL, 0x000fe40002800000ULL,
0xff80000031317808ULL, 0x000fe40000800000ULL, 0x0000006e19ff7212ULL, 0x000fe4000780c0ffULL,
0x0000007099ff7212ULL, 0x000fe4000784c0ffULL, 0x0000007219ff7212ULL, 0x080fe4000788c0ffULL,
0x0000007299ff7212ULL, 0x000fc4000786c0ffULL, 0x00000074a1ff7212ULL, 0x000fe400078ac0ffULL,
0x000000769bff7212ULL, 0x000fe2000782c0ffULL, 0x00000001a5147824ULL, 0x100fe200078e0a16ULL,
0x0000006a1700720cULL, 0x080fe20000701470ULL, 0x00000001ab167824ULL, 0x000fe200078e0a16ULL,
0x0000006a1700720cULL, 0x080fe40002781470ULL, 0x0000006a1b00720cULL, 0x0c0fe40001741470ULL,
0x0000006a1b00720cULL, 0x000fc40001f61470ULL, 0x0000006a7700720cULL, 0x080fe40000f21470ULL,
0x0000006a9f00720cULL, 0x080fe40002fa1470ULL, 0x0000006a9500720cULL, 0x0c0fe40000701070ULL,
0x0000006a9500720cULL, 0x080fe40002781070ULL, 0x0000006a9700720cULL, 0x0c0fe40001741070ULL,
0x0000006a9700720cULL, 0x000fc40001f61070ULL, 0x0000006a7900720cULL, 0x080fe40000f21070ULL,
0x0000006a9d00720cULL, 0x000fe40002fa1070ULL, 0x00000014d7a77219ULL, 0x040fe400000006ffULL,
0x00000016d7ad7219ULL, 0x000fe400000006ffULL, 0x0000541081787816ULL, 0x000fe40000000078ULL,
0x00005410877c7816ULL, 0x000fc4000000007cULL, 0xff8000002f2f7808ULL, 0x000fe40000000000ULL,
0xff80000027277808ULL, 0x000fe40002000000ULL, 0xff8000003b3b7808ULL, 0x000fe40001000000ULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff80000030307808ULL, 0x000fe40000800000ULL,
0xff80000057577808ULL, 0x000fc40002800000ULL, 0x000000749bff7212ULL, 0x080fe4000780c0ffULL,
0x00000074a7ff7212ULL, 0x000fe4000788c0ffULL, 0x000000789bff7212ULL, 0x040fe4000784c0ffULL,
0x0000007c9bff7212ULL, 0x000fe4000786c0ffULL, 0x00000078a1ff7212ULL, 0x000fe4000782c0ffULL,
0x00000076adff7212ULL, 0x000fe200078ac0ffULL, 0x00000001851a7824ULL, 0x000fe200078e0a18ULL,
0x0000006a7700720cULL, 0x000fc40000701470ULL, 0x0000006a7700720cULL, 0x0c0fe40001741470ULL,
0x0000006a7700720cULL, 0x080fe40001f61470ULL, 0x0000006a9f00720cULL, 0x080fe40000f21470ULL,
0x0000006aa500720cULL, 0x080fe40002781470ULL, 0x0000006aab00720cULL, 0x000fe40002fa1470ULL,
0x000000216db17812ULL, 0x000fc400078efcffULL, 0x0000006a7900720cULL, 0x0c0fe40000701070ULL,
0x0000006a7900720cULL, 0x0c0fe40001741070ULL, 0x0000006a7900720cULL, 0x080fe40001f61070ULL,
0x0000006a9d00720cULL, 0x080fe40000f21070ULL, 0x0000006aa300720cULL, 0x080fe40002781070ULL,
0x0000006aa900720cULL, 0x000fc40002fa1070ULL, 0x0000001ad7af7219ULL, 0x000fe400000006ffULL,
0x0000541089887816ULL, 0x000fe20000000088ULL, 0x00000001b1b37824ULL, 0x000fe200078e0213ULL,
0xff8000005b5b7808ULL, 0x000fe40000000000ULL, 0xff8000003c3c7808ULL, 0x000fe40001000000ULL,
0xff8000002a2a7808ULL, 0x000fe40001800000ULL, 0xff8000003d3d7808ULL, 0x000fc40000800000ULL,
0xff8000005a5a7808ULL, 0x000fe40002000000ULL, 0xff80000034347808ULL, 0x000fe40002800000ULL,
0x00000076a1ff7212ULL, 0x040fe4000780c0ffULL, 0x0000007ca1ff7212ULL, 0x000fe4000784c0ffULL,
0x00000076a7ff7212ULL, 0x000fe4000786c0ffULL, 0x00000078adff7212ULL, 0x000fc4000782c0ffULL,
0x0000007cadff7212ULL, 0x000fe4000788c0ffULL, 0x00000088afff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b37a7824ULL, 0x000fe200078e0a18ULL, 0x0000006a9f00720cULL, 0x0c0fe40000701470ULL,
0x0000006a9f00720cULL, 0x080fe40001741470ULL, 0x0000006aa500720cULL, 0x080fe40001f61470ULL,
0x0000006aab00720cULL, 0x000fc40000f21470ULL, 0x0000006aab00720cULL, 0x080fe40002781470ULL,
0x0000006a8500720cULL, 0x080fe40002fa1470ULL, 0x000000286db77812ULL, 0x040fe400078efcffULL,
0x000000296dbd7812ULL, 0x000fe400078efcffULL, 0x0000006a9d00720cULL, 0x0c0fe40000701070ULL,
0x0000006a9d00720cULL, 0x000fc40001741070ULL, 0x0000006aa300720cULL, 0x080fe40001f61070ULL,
0x0000006aa900720cULL, 0x0c0fe40000f21070ULL, 0x0000006aa900720cULL, 0x080fe40002781070ULL,
0x0000006a8300720cULL, 0x000fe40002fa1070ULL, 0x0000007ad7b57219ULL, 0x000fe400000006ffULL,
0x000054108b7e7816ULL, 0x000fc4000000007eULL, 0x0000541091827816ULL, 0x000fe40000000082ULL,
0x00005410dd947816ULL, 0x000fe20000000094ULL, 0x00000001b7b97824ULL, 0x100fe200078e0213ULL,
0xff80000047477808ULL, 0x000fe20000000000ULL, 0x00000001bdbf7824ULL, 0x000fe200078e0213ULL,
0xff8000002d2d7808ULL, 0x000fe40001000000ULL, 0xff80000032327808ULL, 0x000fe40001800000ULL,
0xff8000003f3f7808ULL, 0x000fc40000800000ULL, 0xff80000026267808ULL, 0x000fe40002000000ULL,
0xff80000033337808ULL, 0x000fe40002800000ULL, 0x0000006c99ff7212ULL, 0x000fe400078cc0ffULL,
0x00000078a7ff7212ULL, 0x040fe4000780c0ffULL, 0x0000007ca7ff7212ULL, 0x000fe4000784c0ffULL,
0x0000007eafff7212ULL, 0x000fc4000786c0ffULL, 0x00000082afff7212ULL, 0x040fe4000782c0ffULL,
0x00000094afff7212ULL, 0x000fe4000788c0ffULL, 0x00000082b5ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b9807824ULL, 0x100fe200078e0a18ULL, 0x0000006a1b00720cULL, 0x080fe200037c1470ULL,
0x00000001bf187824ULL, 0x000fe200078e0a18ULL, 0x0000006aa500720cULL, 0x0c0fe40000701470ULL,
0x0000006aa500720cULL, 0x000fc40001741470ULL, 0x0000006a8500720cULL, 0x0c0fe40001f61470ULL,
0x0000006a8500720cULL, 0x0c0fe40000f21470ULL, 0x0000006a8500720cULL, 0x080fe40002781470ULL,
0x0000006ab300720cULL, 0x080fe40002fa1470ULL, 0x0000006a9700720cULL, 0x080fe400037c1070ULL,
0x0000006aa300720cULL, 0x000fc40000701070ULL, 0x0000006aa300720cULL, 0x080fe40001741070ULL,
0x0000006a8300720cULL, 0x0c0fe40001f61070ULL, 0x0000006a8300720cULL, 0x0c0fe40000f21070ULL,
0x0000006a8300720cULL, 0x080fe40002781070ULL, 0x0000006ab100720cULL, 0x000fe40002fa1070ULL,
0x00000080d7bb7219ULL, 0x000fc400000006ffULL, 0x00000018d7c17219ULL, 0x000fe400000006ffULL,
0xff80000056567808ULL, 0x000fe40003000000ULL, 0xff8000003e3e7808ULL, 0x000fe40000000000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff80000059597808ULL, 0x000fe40001800000ULL,
0xff80000040407808ULL, 0x000fc40000800000ULL, 0xff80000025257808ULL, 0x000fe40002000000ULL,
0xff80000041417808ULL, 0x000fe40002800000ULL, 0x00000074adff7212ULL, 0x000fe400078cc0ffULL,
0x0000007eb5ff7212ULL, 0x080fe4000780c0ffULL, 0x0000007ebbff7212ULL, 0x000fe4000784c0ffULL,
0x00000088b5ff7212ULL, 0x000fc4000786c0ffULL, 0x00000094b5ff7212ULL, 0x000fe4000782c0ffULL,
0x00000088bbff7212ULL, 0x000fe4000788c0ffULL, 0x00000082c1ff7212ULL, 0x000fe200078ac0ffULL,
0x000000018f867824ULL, 0x000fe200078e0a84ULL, 0x0000006aab00720cULL, 0x080fe400037c1470ULL,
0x0000006ab300720cULL, 0x0c0fe40000701470ULL, 0x0000006ab300720cULL, 0x000fc40001f61470ULL,
0x0000006ab300720cULL, 0x080fe40000f21470ULL, 0x0000006ab900720cULL, 0x0c0fe40001741470ULL,
0x0000006ab900720cULL, 0x080fe40002781470ULL, 0x0000006abf00720cULL, 0x000fe40002fa1470ULL,
0x000000316dc77812ULL, 0x040fe400078efcffULL, 0x000000386dcd7812ULL, 0x000fc400078efcffULL,
0x000000396dd37812ULL, 0x000fe400078efcffULL, 0x0000006aa900720cULL, 0x080fe400037c1070ULL,
0x0000006ab100720cULL, 0x0c0fe40000701070ULL, 0x0000006ab100720cULL, 0x0c0fe40001f61070ULL,
0x0000006ab100720cULL, 0x080fe40000f21070ULL, 0x0000006ab700720cULL, 0x000fc40001741070ULL,
0x0000006ab700720cULL, 0x080fe40002781070ULL, 0x0000006abd00720cULL, 0x000fe40002fa1070ULL,
0x00000086d7c57219ULL, 0x000fe400000006ffULL, 0x00005410c38c7816ULL, 0x000fe4000000008cULL,
0x00005410db927816ULL, 0x000fe20000000092ULL, 0x00000001c7c97824ULL, 0x100fe200078e0213ULL,
0xff80000058587808ULL, 0x000fe20003000000ULL, 0x00000001cdcf7824ULL, 0x100fe200078e0213ULL,
0xff80000054547808ULL, 0x000fe20000000000ULL, 0x00000001d3d57824ULL, 0x000fe200078e0213ULL,
0xff80000048487808ULL, 0x000fc40001800000ULL, 0xff80000024247808ULL, 0x000fe40000800000ULL,
0xff80000053537808ULL, 0x000fe40001000000ULL, 0xff80000035357808ULL, 0x000fe40002000000ULL,
0xff80000043437808ULL, 0x000fe40002800000ULL, 0x0000007ec1ff7212ULL, 0x040fe400078cc0ffULL,
0x00000088c1ff7212ULL, 0x000fc4000780c0ffULL, 0x00000082bbff7212ULL, 0x040fe4000786c0ffULL,
0x00000094bbff7212ULL, 0x080fe4000782c0ffULL, 0x00000094c1ff7212ULL, 0x000fe4000784c0ffULL,
0x0000008cc5ff7212ULL, 0x040fe4000788c0ffULL, 0x00000092c5ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c98a7824ULL, 0x100fe200078e0a84ULL, 0x0000006ab900720cULL, 0x080fe20001f61470ULL,
0x00000001cf8e7824ULL, 0x100fe200078e0a84ULL, 0x0000006ab900720cULL, 0x080fe20000f21470ULL,
0x00000001d5847824ULL, 0x000fe200078e0a84ULL, 0x0000006abf00720cULL, 0x000fc400037c1470ULL,
0x0000006abf00720cULL, 0x0c0fe40000701470ULL, 0x0000006abf00720cULL, 0x080fe40001741470ULL,
0x0000006a8f00720cULL, 0x0c0fe40002781470ULL, 0x0000006a8f00720cULL, 0x000fe40002fa1470ULL,
0x0000008ad7cb7219ULL, 0x040fe400000006ffULL, 0x0000008ed7d17219ULL, 0x000fc400000006ffULL,
0x0000006ab700720cULL, 0x0c0fe40001f61070ULL, 0x0000006ab700720cULL, 0x080fe40000f21070ULL,
0x0000006abd00720cULL, 0x0c0fe400037c1070ULL, 0x0000006abd00720cULL, 0x0c0fe40000701070ULL,
0x0000006abd00720cULL, 0x080fe40001741070ULL, 0x0000006a8d00720cULL, 0x000fc40002781070ULL,
0x0000006a8d00720cULL, 0x000fe40002fa1070ULL, 0x00000084d7d77219ULL, 0x000fe400000006ffULL,
0x00005410d9907816ULL, 0x000fe40000000090ULL, 0xff80000042427808ULL, 0x000fe40001800000ULL,
0xff8000001e1e7808ULL, 0x000fe40000800000ULL, 0xff80000052527808ULL, 0x000fc40003000000ULL,
0xff80000044447808ULL, 0x000fe40000000000ULL, 0xff8000001f1f7808ULL, 0x000fe40001000000ULL,
0xff80000051517808ULL, 0x000fe40002000000ULL, 0xff8000004d4d7808ULL, 0x000fe40002800000ULL,
0x0000008ccbff7212ULL, 0x080fe4000786c0ffULL, 0x0000008cd1ff7212ULL, 0x000fc4000782c0ffULL,
0x0000008cd7ff7212ULL, 0x000fe400078cc0ffULL, 0x00000090c5ff7212ULL, 0x080fe4000780c0ffULL,
0x00000090cbff7212ULL, 0x080fe4000784c0ffULL, 0x00000090d1ff7212ULL, 0x000fe4000788c0ffULL,
0x00000092cbff7212ULL, 0x000fe400078ac0ffULL, 0x0000006a8f00720cULL, 0x000fc40000701470ULL,
0x0000006ac900720cULL, 0x0c0fe40001f61470ULL, 0x0000006ac900720cULL, 0x0c0fe40001741470ULL,
0x0000006ac900720cULL, 0x080fe40002fa1470ULL, 0x0000006acf00720cULL, 0x080fe40000f21470ULL,
0x0000006ad500720cULL, 0x080fe400037c1470ULL, 0x0000006acf00720cULL, 0x000fc40002781470ULL,
0x0000006a8d00720cULL, 0x080fe40000701070ULL, 0x0000006ac700720cULL, 0x0c0fe40001f61070ULL,
0x0000006ac700720cULL, 0x0c0fe40001741070ULL, 0x0000006ac700720cULL, 0x080fe40002fa1070ULL,
0x0000006acd00720cULL, 0x080fe40000f21070ULL, 0x0000006ad300720cULL, 0x000fc400037c1070ULL,
0x0000006acd00720cULL, 0x000fe40002781070ULL, 0x00005410df967816ULL, 0x000fe40000000096ULL,
0xff80000036367808ULL, 0x000fe40000000000ULL, 0xff80000050507808ULL, 0x000fe40001800000ULL,
0xff80000037377808ULL, 0x000fe40001000000ULL, 0xff80000045457808ULL, 0x000fc40002800000ULL,
0xff8000004f4f7808ULL, 0x000fe40000800000ULL, 0xff8000004e4e7808ULL, 0x000fe40003000000ULL,
0xff8000004c4c7808ULL, 0x000fe40002000000ULL, 0x00000090d7ff7212ULL, 0x000fe4000780c0ffULL,
0x00000092d1ff7212ULL, 0x080fe4000786c0ffULL, 0x00000092d7ff7212ULL, 0x000fc4000784c0ffULL,
0x00000096c5ff7212ULL, 0x080fe400078ac0ffULL, 0x00000096cbff7212ULL, 0x080fe4000782c0ffULL,
0x00000096d1ff7212ULL, 0x080fe400078cc0ffULL, 0x00000096d7ff7212ULL, 0x000fe4000788c0ffULL,
0x0000006a8f00720cULL, 0x080fe40002fa1470ULL, 0x0000006ac900720cULL, 0x000fc40000f21470ULL,
0x0000006acf00720cULL, 0x0c0fe40001f61470ULL, 0x0000006acf00720cULL, 0x080fe400037c1470ULL,
0x0000006ad500720cULL, 0x0c0fe40000701470ULL, 0x0000006ad500720cULL, 0x0c0fe40001741470ULL,
0x0000006ad500720cULL, 0x080fe40002781470ULL, 0x0000006a8d00720cULL, 0x000fc40002fa1070ULL,
0x0000006ac700720cULL, 0x080fe40000f21070ULL, 0x0000006ad300720cULL, 0x080fe40000701070ULL,
0x0000006acd00720cULL, 0x0c0fe40001f61070ULL, 0x0000006acd00720cULL, 0x080fe400037c1070ULL,
0x0000006ad300720cULL, 0x0c0fe40001741070ULL, 0x0000006ad300720cULL, 0x000fc40002781070ULL,
0xff8000004a4a7808ULL, 0x000fe40000000000ULL, 0xff80000046467808ULL, 0x000fe40001800000ULL,
0xff80000049497808ULL, 0x000fe40001000000ULL, 0xff80000020207808ULL, 0x000fe40002800000ULL,
0xff80000021217808ULL, 0x000fe40000800000ULL, 0xff80000022227808ULL, 0x000fc40003000000ULL,
0xff80000023237808ULL, 0x000fc40002000000ULL, 0x0000006b0400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff187424ULL, 0x000fe200078e00ffULL, 0x0000002e0500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x000000390600720bULL, 0x000fe40003f5e000ULL,
0x000000280700720bULL, 0x000fe40003f7e000ULL, 0x000000046b047208ULL, 0x000fe40004000000ULL,
0x000000052e087208ULL, 0x000fc40004800000ULL, 0x0000000639057208ULL, 0x000fe40005000000ULL,
0x0000000728077208ULL, 0x000fe40005800000ULL, 0x000000550400720bULL, 0x000fe40003f1e000ULL,
0x000000380500720bULL, 0x000fe40003f5e000ULL, 0x0000004b0800720bULL, 0x000fe40003f3e000ULL,
0x0000002c0700720bULL, 0x000fc40003f7e000ULL, 0x0000000455097208ULL, 0x000fe40004000000ULL,
0x0000000538057208ULL, 0x000fe40005000000ULL, 0x000000084b087208ULL, 0x000fe40004800000ULL,
0x000000072c047208ULL, 0x000fe40005800000ULL, 0x000000680900720bULL, 0x000fe40003f1e000ULL,
0x0000003a0500720bULL, 0x000fc40003f5e000ULL, 0x0000002f0800720bULL, 0x000fe40003f3e000ULL,
0x000000270400720bULL, 0x000fe40003f7e000ULL, 0x0000000968097208ULL, 0x000fe40004000000ULL,
0x000000053a067208ULL, 0x000fe40005000000ULL, 0x000000082f087208ULL, 0x000fe40004800000ULL,
0x0000000427047208ULL, 0x000fc40005800000ULL, 0x000000560900720bULL, 0x000fe40003f1e000ULL,
0x0000003b0600720bULL, 0x000fe40003f5e000ULL, 0x000000310800720bULL, 0x000fe40003f3e000ULL,
0x000000290400720bULL, 0x000fe40003f7e000ULL, 0x00000009560a7208ULL, 0x000fe40004000000ULL,
0x000000063b077208ULL, 0x000fc40005000000ULL, 0x0000000831057208ULL, 0x000fe40004800000ULL,
0x0000000429097208ULL, 0x000fe40005800000ULL, 0x0000005b0a00720bULL, 0x000fe40003f1e000ULL,
0x0000003c0700720bULL, 0x000fe40003f5e000ULL, 0x000000300500720bULL, 0x000fe40003f3e000ULL,
0x0000002a0900720bULL, 0x000fc40003f7e000ULL, 0x0000000a5b0a7208ULL, 0x000fe40004000000ULL,
0x000000073c067208ULL, 0x000fe40005000000ULL, 0x0000000530047208ULL, 0x000fe40004800000ULL,
0x000000092a087208ULL, 0x000fe40005800000ULL, 0x000000570a00720bULL, 0x000fe40003f1e000ULL,
0x0000003d0600720bULL, 0x000fc40003f5e000ULL, 0x000000470400720bULL, 0x000fe40003f3e000ULL,
0x0000002d0800720bULL, 0x000fe40003f7e000ULL, 0x0000000a57057208ULL, 0x000fe40004000000ULL,
0x000000063d097208ULL, 0x000fe40005000000ULL, 0x0000000447077208ULL, 0x000fe40004800000ULL,
0x000000082d087208ULL, 0x000fc40005800000ULL, 0x0000005a0500720bULL, 0x000fe40003f1e000ULL,
0x0000003e0900720bULL, 0x000fe40003f5e000ULL, 0x000000320700720bULL, 0x000fe40003f3e000ULL,
0x0000002b0800720bULL, 0x000fe40003f7e000ULL, 0x000000055a057208ULL, 0x000fe40004000000ULL,
0x000000093e047208ULL, 0x000fc40005000000ULL, 0x0000000732077208ULL, 0x000fe40004800000ULL,
0x000000082b097208ULL, 0x000fe40005800000ULL, 0x000000580500720bULL, 0x000fe40003f1e000ULL,
0x0000003f0400720bULL, 0x000fe40003f5e000ULL, 0x000000340700720bULL, 0x000fe40003f3e000ULL,
0x000000260900720bULL, 0x000fc40003f7e000ULL, 0x0000000558067208ULL, 0x000fe40004000000ULL,
0x000000043f057208ULL, 0x000fe40005000000ULL, 0x0000000734087208ULL, 0x000fe40004800000ULL,
0x0000000926047208ULL, 0x000fe40005800000ULL, 0x000000590600720bULL, 0x000fe40003f1e000ULL,
0x000000400500720bULL, 0x000fc40003f5e000ULL, 0x000000330800720bULL, 0x000fe40003f3e000ULL,
0x000000250400720bULL, 0x000fe40003f7e000ULL, 0x0000000659077208ULL, 0x000fe40004000000ULL,
0x0000000540067208ULL, 0x000fe40005000000ULL, 0x0000000833097208ULL, 0x000fe40004800000ULL,
0x0000000425057208ULL, 0x000fc40005800000ULL, 0x000000540700720bULL, 0x000fe40003f1e000ULL,
0x000000480900720bULL, 0x000fe40003f3e000ULL, 0x000000410600720bULL, 0x000fe40003f5e000ULL,
0x000000240500720bULL, 0x000fe40003f7e000ULL, 0x0000000754047208ULL, 0x000fe40004000000ULL,
0x0000000948087208ULL, 0x000fc40004800000ULL, 0x0000000641077208ULL, 0x000fe40005000000ULL,
0x0000000524057208ULL, 0x000fe40005800000ULL, 0x000000530400720bULL, 0x000fe40003f1e000ULL,
0x000000350800720bULL, 0x000fe40003f3e000ULL, 0x000000420700720bULL, 0x000fe40003f5e000ULL,
0x0000001e0500720bULL, 0x000fc40003f7e000ULL, 0x0000000453097208ULL, 0x000fe40004000000ULL,
0x00000008350b7208ULL, 0x000fe40004800000ULL, 0x0000000742047208ULL, 0x000fe40005000000ULL,
0x000000051e067208ULL, 0x000fe40005800000ULL, 0x000000520900720bULL, 0x000fe40003f1e000ULL,
0x000000440b00720bULL, 0x000fc40003f3e000ULL, 0x000000430400720bULL, 0x000fe40003f5e000ULL,
0x0000001f0600720bULL, 0x000fe40003f7e000ULL, 0x0000000952087208ULL, 0x000fe40004000000ULL,
0x0000000b440b7208ULL, 0x000fe40004800000ULL, 0x0000000443047208ULL, 0x000fe40005000000ULL,
0x000000061f057208ULL, 0x000fc40005800000ULL, 0x000000510800720bULL, 0x000fe40003f1e000ULL,
0x000000360b00720bULL, 0x000fe40003f3e000ULL, 0x0000004d0400720bULL, 0x000fe40003f5e000ULL,
0x000000200500720bULL, 0x000fe40003f7e000ULL, 0x0000000851077208ULL, 0x000fe40004000000ULL,
0x0000000b36067208ULL, 0x000fc40004800000ULL, 0x000000044d047208ULL, 0x000fe40005000000ULL,
0x0000000520087208ULL, 0x000fe40005800000ULL, 0x000000500700720bULL, 0x000fe40003f1e000ULL,
0x000000370600720bULL, 0x000fe40003f3e000ULL, 0x000000450400720bULL, 0x000fe40003f5e000ULL,
0x000000210800720bULL, 0x000fc40003f7e000ULL, 0x00000007500a7208ULL, 0x000fe40004000000ULL,
0x0000000637057208ULL, 0x000fe40004800000ULL, 0x0000000445077208ULL, 0x000fe40005000000ULL,
0x0000000821097208ULL, 0x000fe40005800000ULL, 0x0000004f0a00720bULL, 0x000fe40003f1e000ULL,
0x0000004c0500720bULL, 0x000fc40003f3e000ULL, 0x000000460700720bULL, 0x000fe40003f5e000ULL,
0x000000220900720bULL, 0x000fe40003f7e000ULL, 0x0000000a4f0b7208ULL, 0x000fe40004000000ULL,
0x000000054c057208ULL, 0x000fe40004800000ULL, 0x0000000746047208ULL, 0x000fe40005000000ULL,
0x0000000922067208ULL, 0x000fc40005800000ULL, 0x0000004e0b00720bULL, 0x000fe40003f1e000ULL,
0x0000004a0500720bULL, 0x000fe40003f3e000ULL, 0x000000490400720bULL, 0x000fe40003f5e000ULL,
0x000000230600720bULL, 0x000fe40003f7e000ULL, 0x0000000b4e077208ULL, 0x000fe40004000000ULL,
0x000000054a0a7208ULL, 0x000fc40004800000ULL, 0x0000000449167208ULL, 0x000fe40005000000ULL,
0x0000000623157208ULL, 0x000fe20005800000ULL, 0x00001fe27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0007047f89ULL, 0x0004e400000e0000ULL, 0x000000040700720bULL, 0x008fc80003f1e000ULL,
0x0000000704177208ULL, 0x000fe20004000000ULL, 0x00001ff27f007947ULL, 0x000fea000b800000ULL,
0x0c401f000a047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0016057f89ULL, 0x000e6800000e0000ULL,
0x0c401f0015067f89ULL, 0x000ea200000e0000ULL, 0x000000040a00720bULL, 0x008fc40003f1e000ULL,
0x000000051600720bULL, 0x002fe40003f3e000ULL, 0x0000000a04077208ULL, 0x004fe40004000000ULL,
0x0000001605087208ULL, 0x000fe20004800000ULL, 0x0c201f0017047f89ULL, 0x000e6200000e0000ULL,
0x000000061500720bULL, 0x000fc60003f1e000ULL, 0x0c201f0007147f89ULL, 0x000ea200000e0000ULL,
0x00000015060a7208ULL, 0x000fc60004000000ULL, 0x0c201f0008097f89ULL, 0x000ee800000e0000ULL,
0x0c201f000a0b7f89ULL, 0x0002e400000e0000ULL, 0x000000041700720bULL, 0x002fe40003f1e000ULL,
0x000000140700720bULL, 0x004fe40003f3e000ULL, 0x0000001704047208ULL, 0x000fc40004000000ULL,
0x000000090800720bULL, 0x008fe40003f5e000ULL, 0x0000000714057208ULL, 0x000fe40004800000ULL,
0x0000000809067208ULL, 0x000fc60005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x0000000b0a00720bULL, 0x004fe20003f1e000ULL, 0x3fb8aa3b06167820ULL, 0x000fe20000410000ULL,
0x00000002ff6d7819ULL, 0x000fe2000001160fULL, 0x3fb8aa3b55557823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b6b6b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b68687823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b56567823ULL, 0x100fe20000010807ULL, 0x0000005500097308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b5b5b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b57577823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b5a5a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b58587823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b54547823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b52527823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b51517823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b59557823ULL, 0x102fe20000010807ULL, 0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4e4e7823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b05077820ULL, 0x000fe20000410000ULL, 0x0000006b00087308ULL, 0x000e620000000800ULL,
0x000000086d197824ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b48487823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4a077823ULL, 0x000fe20000010807ULL,
0x0000006800687308ULL, 0x000fe20000000800ULL, 0x000000086d6e7824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010816ULL,
0x0000000700597308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b41417823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010816ULL,
0x0000005600157308ULL, 0x0006620000000800ULL, 0x0000000a0b077208ULL, 0x004fe20004000000ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010816ULL, 0x000000016d0a7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b49167823ULL, 0x000fe20000010816ULL, 0x000000026d0b7810ULL, 0x040fe20007ffe0ffULL,
0x000000086d747824ULL, 0x000fe200078e00ffULL, 0xfffffff8196c7812ULL, 0x000fe200078ee20aULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b07567820ULL, 0x008fe20000410000ULL,
0xfffffff86e6e7812ULL, 0x000fe200078ee20bULL, 0x000000086d1b7824ULL, 0x040fe200078e00ffULL,
0x000000046d0a7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010856ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010856ULL,
0x0000004b004b7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b29297823ULL, 0x000fe20000010856ULL,
0x000000056d0b7810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0xfffffff819727812ULL, 0x000fe200078ee20aULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010856ULL,
0xfffffff874747812ULL, 0x000fe200078ee20bULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010856ULL,
0x0000002f002f7308ULL, 0x000fe20000000800ULL, 0x000000080908723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010856ULL, 0x00000068150a723eULL, 0x000fe200000000ffULL,
0x000000086d157824ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010856ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010856ULL,
0x0000003100147308ULL, 0x000e620000000800ULL, 0x0000002e4b09723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b214b7823ULL, 0x000fe20000010856ULL, 0x0000000c1d1d7812ULL, 0x000fc400078ec0ffULL,
0x000000030fff7812ULL, 0x000fc6000780c0ffULL, 0x00000058006b7308ULL, 0x000ff00000000800ULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x0000002f140b723eULL, 0x002fe400000000ffULL,
0xffffffff6d147810ULL, 0x000fc80007ffe0ffULL, 0xfffffff815687812ULL, 0x000fe200078ee214ULL,
0x0000002c00177308ULL, 0x000e700000000800ULL, 0x0000003900397308ULL, 0x000ff00000000800ULL,
0x0000003800387308ULL, 0x000ea20000000800ULL, 0x000000281715723eULL, 0x002fce00000000ffULL,
0x0000003a003a7308ULL, 0x000ff00000000800ULL, 0x0000003b003b7308ULL, 0x000e620000000800ULL,
0x000000393814723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b20387823ULL, 0x000fcc0000010856ULL,
0x0000001600497308ULL, 0x0005f00000000800ULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x000000036d167810ULL, 0x004fc80007ffe0ffULL, 0xfffffff81b707812ULL, 0x000fe400078ee216ULL,
0x000000066d167810ULL, 0x000fe20007ffe0ffULL, 0x0000002900587308ULL, 0x000ea60000000800ULL,
0xfffffff81b767812ULL, 0x000fe400078ee216ULL, 0x0000003a3b16723eULL, 0x002fc600000000ffULL,
0x00000057006a7308ULL, 0x000ff00000000800ULL, 0x0000003400577308ULL, 0x0003e20000000800ULL,
0x000000275817723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b1e277823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b22587823ULL, 0x000fca0000010856ULL, 0x0000003500317308ULL, 0x0005e20000000800ULL,
0x3c003c00ff347424ULL, 0x002fce00078e00ffULL, 0x0000005b005b7308ULL, 0x000e620000000800ULL,
0x3c003c00ff357424ULL, 0x004fce00078e00ffULL, 0x000000340818723cULL, 0x000f6200000018ffULL,
0x0000005a005a7308ULL, 0x000ea20000000800ULL, 0x0000005b6a20723eULL, 0x002fce00000000ffULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x000000106d6a7810ULL, 0x000fca0007ffe0ffULL,
0x000000086a2f7824ULL, 0x000fe400078e00ffULL, 0x0000004700477308ULL, 0x000e620000000800ULL,
0x0000005a6b22723eULL, 0x004fe400000000ffULL, 0x000000086d5a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82f6a7812ULL, 0x000fc600078ee26aULL, 0x0000003200327308ULL, 0x000eb00000000800ULL,
0x00000045004a7308ULL, 0x000fe20000000800ULL, 0x000000304721723eULL, 0x002fce00000000ffULL,
0x0000002a002c7308ULL, 0x000ff00000000800ULL, 0x0000002b00457308ULL, 0x0003f00000000800ULL,
0x0000003c003c7308ULL, 0x000fe20000000800ULL, 0x000000341428723cULL, 0x002f6e00000018ffULL,
0x0000003d003d7308ULL, 0x000e700000000800ULL, 0x0000003e003e7308ULL, 0x000ff00000000800ULL,
0x0000003f003f7308ULL, 0x000ff00000000800ULL, 0x0000002d002d7308ULL, 0x000ef00000000800ULL,
0x00000026002e7308ULL, 0x0003f00000000800ULL, 0x0000005500557308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b24267823ULL, 0x102fe20000010856ULL, 0x3fb8aa3b23567823ULL, 0x000fe20000010856ULL,
0x000000325723723eULL, 0x004fc400000000ffULL, 0x0000003c3d24723eULL, 0x000fc600000000ffULL,
0x0000005400547308ULL, 0x000e640000000800ULL, 0x000000342018723cULL, 0x020f6c0000001818ULL,
0x0000005300537308ULL, 0x000ff00000000800ULL, 0x0000005200527308ULL, 0x000ff00000000800ULL,
0x0000003300337308ULL, 0x000ff00000000800ULL, 0x0000004800487308ULL, 0x000ff00000000800ULL,
0x0000004400447308ULL, 0x000eb00000000800ULL, 0x0000002500397308ULL, 0x0007f00000000800ULL,
0x00000026001e7308ULL, 0x0004a20000000800ULL, 0x0000002c2d25723eULL, 0x008fe200000000ffULL,
0x000000085a2d7824ULL, 0x000fe200078e00ffULL, 0x00000055542c723eULL, 0x002fc400000000ffULL,
0x00000031442f723eULL, 0x004fe400000000ffULL, 0xfffffff82d5a7812ULL, 0x000fe200078ee25aULL,
0x00000027003b7308ULL, 0x0003e20000000800ULL, 0x0000003e3f26723eULL, 0x000fe200000000ffULL,
0x000000086d3e7824ULL, 0x000fe200078e00ffULL, 0x00000033482d723eULL, 0x000fc800000000ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee26dULL, 0x0000004000407308ULL, 0x000fe20000000800ULL,
0x000000452e27723eULL, 0x002fe400000000ffULL, 0x00000053522e723eULL, 0x000fe400000000ffULL,
0x000000391e39723eULL, 0x000fe400000000ffULL, 0x000000186d6d7810ULL, 0x000fe20007ffe0ffULL,
0x000000342428723cULL, 0x000f620000001828ULL, 0x0000004100417308ULL, 0x000fe60000000800ULL,
0x000000086d787824ULL, 0x000fc800078e00ffULL, 0x000000342c18723cULL, 0x020f620000001818ULL,
0x0000004200427308ULL, 0x000fe20000000800ULL, 0xfffffff878787812ULL, 0x000fce00078ee26dULL,
0x0000004300437308ULL, 0x000e700000000800ULL, 0x0000001f003c7308ULL, 0x0004f00000000800ULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x00000042433a723eULL, 0x002fc400000000ffULL,
0x0000a000111f7811ULL, 0x004fca00078e60ffULL, 0x0000005000507308ULL, 0x000e620000000800ULL,
0x0000003b3c3b723eULL, 0x008fe200000000ffULL, 0x000000103e3e7824ULL, 0x100fe400078e021fULL,
0x000000106c6c7824ULL, 0x100fe400078e021fULL, 0x000000106e6e7824ULL, 0x100fe400078e021fULL,
0x0000004f004f7308ULL, 0x000fe20000000800ULL, 0x0000001070707824ULL, 0x100fe400078e021fULL,
0x0000001072727824ULL, 0x000fc400078e021fULL, 0x0000001074747824ULL, 0x100fe400078e021fULL,
0x000000011d6c7824ULL, 0x040fe200078e026cULL, 0x0000004e004e7308ULL, 0x000ea20000000800ULL,
0x000000515030723eULL, 0x002fe200000000ffULL, 0x0000001076767824ULL, 0x100fe400078e021fULL,
0x000000011d6e7824ULL, 0x040fe400078e026eULL, 0x0000001068687824ULL, 0x000fe400078e021fULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x000000011d707824ULL, 0x000fc400078e0270ULL,
0x000000105a5a7824ULL, 0x000fe400078e021fULL, 0x000000011d727824ULL, 0x040fe400078e0272ULL,
0x000000011d747824ULL, 0x040fe200078e0274ULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x0000004f4e32723eULL, 0x004fe200000000ffULL, 0x000000011d767824ULL, 0x040fe400078e0276ULL,
0x000000011d687824ULL, 0x040fe400078e0268ULL, 0x000000011d5a7824ULL, 0x000fc400078e025aULL,
0x0000004c004c7308ULL, 0x000ea20000000800ULL, 0x000000106a6a7824ULL, 0x100fe400078e021fULL,
0x0000001078787824ULL, 0x000fc800078e021fULL, 0x000000011d787824ULL, 0x000fe200078e0278ULL,
0x00000038003d7308ULL, 0x0007e20000000800ULL, 0x000000363731723eULL, 0x002fe200000000ffULL,
0x000000013e377824ULL, 0x000fca00078e021dULL, 0x0000000837007388ULL, 0x000fe20000000800ULL,
0x0000004d004d7308ULL, 0x000e620000000800ULL, 0x000000404138723eULL, 0x008fe400000000ffULL,
0x0000004c5933723eULL, 0x004fe200000000ffULL, 0x0000000a6c007388ULL, 0x000fe80000000800ULL,
0x000000343828723cULL, 0x080fe20000001828ULL, 0x0000004600467308ULL, 0x000ea20000000800ULL,
0x000000206e007388ULL, 0x000fe80000000800ULL, 0x0000002270007388ULL, 0x000fe40000000800ULL,
0x000000343018723cULL, 0x020f620000001818ULL, 0x0000004b00507308ULL, 0x000ee20000000800ULL,
0x0000004d4a3c723eULL, 0x002fe200000000ffULL, 0x0000002c72007388ULL, 0x000fe80000000800ULL,
0x0000002e74007388ULL, 0x000fe40000000800ULL, 0x00000058003f7308ULL, 0x000fe20000000800ULL,
0x00000046493e723eULL, 0x004fe200000000ffULL, 0x0000003076007388ULL, 0x000fe80000000800ULL,
0x0000003268007388ULL, 0x000fe40000000800ULL, 0x0000005600567308ULL, 0x000e620000000800ULL,
0x0000003d503d723eULL, 0x008fe200000000ffULL, 0x000000095a007388ULL, 0x000fe20000000800ULL,
0x000000011d197824ULL, 0x020fc600078e026aULL, 0x0004000b6c007388ULL, 0x000fe80000000800ULL,
0x000400216e007388ULL, 0x000fe80000000800ULL, 0x0004002370007388ULL, 0x000fe20000000800ULL,
0x0000003f563f723eULL, 0x002fc600000000ffULL, 0x0004002d72007388ULL, 0x000fe80000000800ULL,
0x0004002f74007388ULL, 0x000fe20000000800ULL, 0x000000343c28723cULL, 0x000f660000001828ULL,
0x0004003176007388ULL, 0x000fe80000000800ULL, 0x0004003368007388ULL, 0x000fe80000000800ULL,
0x0000001419007388ULL, 0x0003e80000000800ULL, 0x000800166c007388ULL, 0x0005e80000000800ULL,
0x000800246e007388ULL, 0x0005e20000000800ULL, 0x000000ffff197224ULL, 0x002fc600078e001aULL,
0x0008002670007388ULL, 0x0005e20000000800ULL, 0x000000ffff1a7224ULL, 0x020fe400078e0028ULL,
0x000000ffff1b7224ULL, 0x000fe200078e002aULL, 0x0008003872007388ULL, 0x0005e80000000800ULL,
0x0008003a74007388ULL, 0x0005e80000000800ULL, 0x0008003c76007388ULL, 0x0005e80000000800ULL,
0x0008003e68007388ULL, 0x0005e80000000800ULL, 0x0000001578007388ULL, 0x0005e80000000800ULL,
0x000c00176c007388ULL, 0x0005e80000000800ULL, 0x000c00256e007388ULL, 0x0005e80000000800ULL,
0x000c002770007388ULL, 0x0005e80000000800ULL, 0x000c003972007388ULL, 0x0005e80000000800ULL,
0x000c003b74007388ULL, 0x0005e80000000800ULL, 0x000c003d76007388ULL, 0x0005e80000000800ULL,
0x000c003f68007388ULL, 0x0005e80000000800ULL, 0x012000041c008388ULL, 0x0005e80000000c00ULL,
0x012200181c008388ULL, 0x0005e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000062ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080062ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100062ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000161617810ULL, 0x000fe20007ffe0ffULL, 0x0000180062ff7f8cULL, 0x0003e6000c80043fULL,
0x0000000c6100720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff96b000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x00016e7000267802ULL, 0x000fc40000000f00ULL,
0x0000108000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff177224ULL, 0x000fe200078e0025ULL,
0xfffebe6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005000000ULL,
0x00016ec000267802ULL, 0x000fc40000000f00ULL, 0x0000103000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0025ULL, 0xfffebec000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x00016f1000257802ULL, 0x000fc40000000f00ULL,
0x00000f9000007944ULL, 0x014fea0003c00000ULL, 0xfffebf9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x00016f5000257802ULL, 0x000fc40000000f00ULL,
0x00000f5000007944ULL, 0x014fea0003c00000ULL, 0xfffec0c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x00016f9000257802ULL, 0x000fc40000000f00ULL,
0x00000f1000007944ULL, 0x014fea0003c00000ULL, 0xfffec1f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x00016fd000257802ULL, 0x000fc40000000f00ULL,
0x00000ed000007944ULL, 0x014fea0003c00000ULL, 0xfffec31000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001702000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0017ULL, 0x00000e8000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xfffec70000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001707000257802ULL, 0x000fc40000000f00ULL,
0x00000e3000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0026ULL,
0x0000001017277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x000170c000257802ULL, 0x000fc40000000f00ULL, 0x00000de000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0026ULL, 0xfffec6b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001711000257802ULL, 0x000fc40000000f00ULL,
0x00000d9000007944ULL, 0x01cfea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0026ULL,
0xfffec69000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe40004000000ULL,
0x0001716000267802ULL, 0x000fc40000000f00ULL, 0x00000d9000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff707224ULL, 0x000fe200078e0025ULL, 0xfffee85000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005000000ULL, 0x000171b000267802ULL, 0x000fc40000000f00ULL,
0x00000d4000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff717224ULL, 0x000fe200078e0025ULL,
0xfffee89000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x0001720000257802ULL, 0x000fc40000000f00ULL, 0x00000ca000007944ULL, 0x014fea0003c00000ULL,
0xfffee97000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x0001724000257802ULL, 0x000fc40000000f00ULL, 0x00000c6000007944ULL, 0x014fea0003c00000ULL,
0xfffeeaa000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x0001728000257802ULL, 0x000fc40000000f00ULL, 0x00000c2000007944ULL, 0x014fea0003c00000ULL,
0xfffeebd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x000172c000257802ULL, 0x000fc40000000f00ULL, 0x00000be000007944ULL, 0x014fea0003c00000ULL,
0xfffeecf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x0001731000257802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0029ULL,
0x00000b9000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xfffef11000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x0001736000257802ULL, 0x000fc40000000f00ULL, 0x00000b4000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0026ULL, 0x0000001029277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x000173b000257802ULL, 0x000fc40000000f00ULL,
0x00000af000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0026ULL,
0xfffef0c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x0001740000257802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x01cfea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0026ULL, 0xfffef0a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x0001745000267802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff727224ULL, 0x000fe200078e0025ULL,
0xffff104000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005000000ULL,
0x000174a000267802ULL, 0x000fc40000000f00ULL, 0x00000a5000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff037224ULL, 0x000fe200078e0025ULL, 0xffff109000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0073ULL, 0x000174f000257802ULL, 0x000fc40000000f00ULL,
0x000009b000007944ULL, 0x014fea0003c00000ULL, 0xffff117000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0073ULL, 0x0001753000257802ULL, 0x000fc40000000f00ULL,
0x0000097000007944ULL, 0x014fea0003c00000ULL, 0xffff12a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0073ULL, 0x0001757000257802ULL, 0x000fc40000000f00ULL,
0x0000093000007944ULL, 0x014fea0003c00000ULL, 0xffff13d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0073ULL, 0x000175b000257802ULL, 0x000fc40000000f00ULL,
0x000008f000007944ULL, 0x014fea0003c00000ULL, 0xffff14f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001760000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0023ULL, 0x000008a000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xffff191000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001765000257802ULL, 0x000fc40000000f00ULL,
0x0000085000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0026ULL,
0x0000001023277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x000176a000257802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0026ULL, 0xffff18c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x000176f000257802ULL, 0x000fc40000000f00ULL,
0x000007b000007944ULL, 0x01cfea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0026ULL,
0xffff18a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x004fe40004000000ULL,
0x0001774000267802ULL, 0x000fc40000000f00ULL, 0x000007b000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0025ULL, 0xffff393000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005000000ULL, 0x0001779000267802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0025ULL,
0xffff398000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x000177e000257802ULL, 0x000fc40000000f00ULL, 0x000006c000007944ULL, 0x018fea0003c00000ULL,
0xffff3a5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x0001782000257802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x018fea0003c00000ULL,
0xffff3b8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x0001786000257802ULL, 0x000fc40000000f00ULL, 0x0000064000007944ULL, 0x018fea0003c00000ULL,
0xffff3cb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x000178a000257802ULL, 0x000fc40000000f00ULL, 0x0000060000007944ULL, 0x018fea0003c00000ULL,
0xffff3dd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x000178f000257802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0003ULL,
0x000005b000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xffff41f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x0001794000257802ULL, 0x000fc40000000f00ULL, 0x0000056000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0026ULL, 0x0000001003277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0002ULL, 0x0001799000257802ULL, 0x000fc40000000f00ULL,
0x0000051000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0026ULL,
0xffff41a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x000179e000257802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x01cfea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0026ULL, 0xffff418000007947ULL, 0x000fea000383ffffULL,
0x00000002ff147424ULL, 0x000fe200078e00ffULL, 0x00017a3000087802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e000bULL,
0xffffdfe000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x006fe200078e000aULL,
0x00017a9000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff147424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x010fea0003c00000ULL, 0x0000000b0a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0016ULL, 0x00017af000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff147424ULL, 0x000fe200078e00ffULL, 0x0000000a0b067208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0015ULL, 0x00017b5000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff147424ULL, 0x000fe200078e00ffULL, 0x000000160b167208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0017ULL, 0x00017bb000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000150b0a7208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0006ULL, 0x00017c1000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000170b047208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0016ULL, 0x00017c7000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000060b057208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000aULL, 0x00017cd000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000160b067208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffdeb000007947ULL, 0x000fea000383ffffULL,
0x0180000024007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000002400008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff24ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000024027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002400007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe81a002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000001900007348ULL, 0x000fe80003800000ULL,
0x0c000014070b7389ULL, 0x0002a200000e0018ULL, 0xfffe816008007950ULL, 0x000fea0003c3ffffULL,
0x000000ffff6c7224ULL, 0x000fe200078e0025ULL, 0x0000008600007348ULL, 0x000fe80003800000ULL,
0x00000000ff6d7424ULL, 0x000fe200078e00ffULL, 0x0000002726267389ULL, 0x0002a600000e0087ULL,
0xfffe81106c007950ULL, 0x000fea0003c3ffffULL, 0x000000012500780cULL, 0x000fe20003f45070ULL,
0x00000000ff277424ULL, 0x000fe200078e00ffULL, 0x0000008500007348ULL, 0x000ff60003800000ULL,
0x0000000000257806ULL, 0x000fc800050e0100ULL, 0x0000008525257212ULL, 0x000fe200078ec0ffULL,
0xfffe80b026007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000200000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000560ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c0ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000930ULL,
0x0000000000000348ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c78ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d38ULL,
0x00000000000008acULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001688ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000168cULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x0000000000018000ULL, 0xe200001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000019880ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x00000000000198c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000019c40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001688ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000181f8ULL,
0x00000000000181f8ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000019880ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000019c40ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_32_sm_89_cubin_len = 105760;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
