/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000014b48ULL, 0x00000000000147c8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x326a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL,
0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL, 0x45316a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x000000676e696469ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL, 0x305f6c616e726574ULL,
0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL,
0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL, 0x616c65722e006168ULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL,
0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL,
0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000135ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b0001000001beULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000b000100000204ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b00010000024bULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000291ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b0001000002dfULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000032dULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b00010000037bULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003c9ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b00010000040fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b00010000045dULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004b8ULL, 0x0000000000013150ULL,
0x0000000000000230ULL, 0x000400030000052eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000013380ULL, 0x000d00030000055eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001315000000000ULL,
0x0000140400000000ULL, 0x0020288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808692ULL, 0x0000002cffffffffULL,
0x0000006000000000ULL, 0x0001315000000000ULL, 0x0000023000000000ULL, 0x0000580400000000ULL,
0x8084288080860900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL, 0x0008230400000080ULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000020ULL, 0x0000002000000015ULL,
0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000002000000017ULL, 0x0000001700081104ULL,
0x0004370400000020ULL, 0x000c17040000007bULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0xffffffff00942904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000044000942804ULL,
0x00000a6000000470ULL, 0x00002c7000002bf0ULL, 0x00002e8000002d40ULL, 0x000033f0000033e0ULL,
0x000050a000005040ULL, 0x000052e0000051a0ULL, 0x000056f0000056e0ULL, 0x000072c000007250ULL,
0x00007500000073c0ULL, 0x0000791000007900ULL, 0x00009550000094e0ULL, 0x0000979000009650ULL,
0x00009c0000009bf0ULL, 0x0000ad200000ad10ULL, 0x000126d0000126c0ULL, 0x0001273000012720ULL,
0x00012bb000012b20ULL, 0x00012d6000012d00ULL, 0x0000054004303904ULL, 0x00017600000000ffULL,
0x0000062000040100ULL, 0x0001760800000008ULL, 0x00000730003f0100ULL, 0x0001768800000008ULL,
0x00000880003f0100ULL, 0x000176a800000004ULL, 0x00000980003f0100ULL, 0x000176c800000002ULL,
0x000010c0003f0100ULL, 0x0001760000000002ULL, 0x00001270003f0107ULL, 0x0001768800000006ULL,
0x00001b30003f0101ULL, 0x0000000000000008ULL, 0x00001c4000040107ULL, 0x0000000000000008ULL,
0x00001ce000040101ULL, 0x0000002000000009ULL, 0x00001e20003f0101ULL, 0x000176c80000000eULL,
0x00001fa0003f0109ULL, 0x000176c80000000eULL, 0x00002910003f0109ULL, 0x000176b000000014ULL,
0x00002970003f0107ULL, 0x000176b000000014ULL, 0x00002980003f0101ULL, 0x000176080000000dULL,
0x000029a0003f0101ULL, 0x000176080000000dULL, 0x00002b10003f0109ULL, 0x000176080000000dULL,
0x00003070003f0109ULL, 0x000176a800000039ULL, 0x000031e0003f0109ULL, 0x000176a800000039ULL,
0x00004380003f0109ULL, 0x000176c800000018ULL, 0x00004390003f0101ULL, 0x0001768800000045ULL,
0x000043c0003f0101ULL, 0x0000000000000009ULL, 0x00004530003f0109ULL, 0x0000000000000009ULL,
0x00004dc0003f0109ULL, 0x000176a800000017ULL, 0x00004e00003f0107ULL, 0x000176a800000017ULL,
0x00004e10003f0101ULL, 0x000176280000000dULL, 0x00004e30003f0101ULL, 0x000176280000000dULL,
0x00004fa0003f0109ULL, 0x000176280000000dULL, 0x000054c0003f0109ULL, 0x000176b000000041ULL,
0x00005630003f0109ULL, 0x000176b000000041ULL, 0x00006590003f0109ULL, 0x000176c800000042ULL,
0x000065a0003f0101ULL, 0x0001769000000059ULL, 0x000065d0003f0101ULL, 0x0000000000000009ULL,
0x00006740003f0109ULL, 0x0000000000000009ULL, 0x00006fd0003f0109ULL, 0x000176b00000001bULL,
0x00007010003f0107ULL, 0x000176b00000001bULL, 0x00007020003f0101ULL, 0x000176480000000dULL,
0x00007040003f0101ULL, 0x000176480000000dULL, 0x000071b0003f0109ULL, 0x000176480000000dULL,
0x000076e0003f0109ULL, 0x000176a800000041ULL, 0x00007850003f0109ULL, 0x000176a800000041ULL,
0x000087a0003f0109ULL, 0x000176c80000003cULL, 0x000087c0003f0101ULL, 0x000176980000003dULL,
0x000087f0003f0101ULL, 0x0000000000000009ULL, 0x00008960003f0109ULL, 0x0000000000000009ULL,
0x00009260003f0109ULL, 0x000176a800000007ULL, 0x000092a0003f0107ULL, 0x000176a800000007ULL,
0x000092b0003f0101ULL, 0x000176680000000bULL, 0x000092e0003f0101ULL, 0x000176680000000bULL,
0x00009450003f0109ULL, 0x000176680000000bULL, 0x00009970003f0109ULL, 0x000176b000000039ULL,
0x00009ae0003f0109ULL, 0x000176b000000039ULL, 0x0000aa30003f0109ULL, 0x0000000000000009ULL,
0x0000aac0003f0101ULL, 0x000176a000000009ULL, 0x0000bf00003f0101ULL, 0x0001760000000002ULL,
0x0000d850003f0101ULL, 0x0001760000000002ULL, 0x0000da20003f0109ULL, 0x0001760000000002ULL,
0x0000dc00003f0109ULL, 0x0001760000000002ULL, 0x0000dc20003f0101ULL, 0x0001760000000002ULL,
0x0000dd90003f0109ULL, 0x0001760000000002ULL, 0x00010a00003f0109ULL, 0x0001768800000068ULL,
0x00010bd0003f0101ULL, 0x0001768800000068ULL, 0x00010d40003f0109ULL, 0x0001768800000068ULL,
0x000130e0003f0109ULL, 0x0001760800000039ULL, 0x00013100003f0101ULL, 0x0001761000000039ULL,
0x00013110003f0101ULL, 0x0001761800000039ULL, 0x00013120003f0101ULL, 0x0001762000000039ULL,
0x00053803003f0101ULL, 0x0000b59000201c04ULL, 0x0000b8900000b5c0ULL, 0x0000bc800000ba80ULL,
0x0000ddd00000be30ULL, 0x000c050400013140ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0068190300000000ULL, 0x0000001800080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL,
0x0000001700000002ULL, 0x0000000000013150ULL, 0x0000000000000044ULL, 0x0000001700000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001700000002ULL, 0x0000000000000000ULL,
0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000057919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fe20000000a00ULL,
0xffffffe001017836ULL, 0x002fe20000000000ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff062b82ULL, 0x000e620000000a00ULL,
0x0000000105032836ULL, 0x008fe40000000000ULL, 0x0000000405082825ULL, 0x002fc800078e0006ULL,
0x0000000403062825ULL, 0x000fe200078e0006ULL, 0x00000006080b2981ULL, 0x0002a2000c1e1900ULL,
0x00008500ff037b82ULL, 0x000ee60000000800ULL, 0x0000000606642981ULL, 0x0008a2000c1e1900ULL,
0x000004a000007945ULL, 0x000fe80003800000ULL, 0x00000400ff027b82ULL, 0x000f620000000800ULL,
0x0000000000087919ULL, 0x002e620000002300ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x0000000000097919ULL, 0x000e620000002100ULL, 0x0000000300007306ULL, 0x008ee20000209000ULL,
0x000000ff0300720cULL, 0x000fce0003f65070ULL, 0x0000000000007308ULL, 0x008ee40000001000ULL,
0x0ffffffe000c7836ULL, 0x008fcc0000000000ULL, 0x0000000c000d7305ULL, 0x000664000021f000ULL,
0x000000ffff0c7224ULL, 0x008fe400078e00ffULL, 0x000000ffff047224ULL, 0x002fc800078e0a0dULL,
0x00000003040f7224ULL, 0x000fc800078e02ffULL, 0x0000000f0d0d7227ULL, 0x000fe400078e000cULL,
0x00000000000f7919ULL, 0x000e680000002200ULL, 0x000000020d0d7227ULL, 0x020fc800078e00ffULL,
0x000000ffff047224ULL, 0x000fc800078e0a0dULL, 0x0000000403007224ULL, 0x000fe400078e0202ULL,
0x0000000000047919ULL, 0x000ee60000002600ULL, 0x000000030000720cULL, 0x000fda0003f06070ULL,
0x0000000100000824ULL, 0x000fe400078e0a03ULL, 0x000000010d0d0836ULL, 0x000fc60000000000ULL,
0x000000030000720cULL, 0x000fda0003f26070ULL, 0x000000010d0d1836ULL, 0x000fe20000000000ULL,
0x00000003ff0db212ULL, 0x000fc800078e33ffULL, 0x0000000d00007306ULL, 0x000f620000209000ULL,
0x000000ff0d00720cULL, 0x000fce0003f65070ULL, 0x0000000000007308ULL, 0x020f240000001000ULL,
0x0ffffffe00067836ULL, 0x010fe40000000000ULL, 0x0000000408007c24ULL, 0x002fe2000f8e020fULL,
0x0000000000047ab9ULL, 0x000fc60000000800ULL, 0x0000000600077305ULL, 0x000324000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000070d027224ULL, 0x010fc800078e02ffULL,
0x000000ffff117224ULL, 0x000fe400078e0a02ULL, 0x0000000400027c24ULL, 0x000fe4000f8e0209ULL,
0x0000001107077227ULL, 0x000fc600078e0006ULL, 0x0000007f0200780cULL, 0x040fe40003fa4070ULL,
0x000000030200780cULL, 0x000fe20003f84070ULL, 0x0000000407517227ULL, 0x008fc800078e00ffULL,
0x000000ffff067224ULL, 0x000fc800078e0a51ULL, 0x000000060d007224ULL, 0x000fe400078e0204ULL,
0x00000000000fd919ULL, 0x000e620000008800ULL, 0x00008400ff06ab82ULL, 0x000ee40000000800ULL,
0x0000000d0000720cULL, 0x000fda0003f06070ULL, 0x0000000100000824ULL, 0x000fe400078e0a0dULL,
0x0000000151510836ULL, 0x000fe20000000000ULL, 0x000000ff0200720cULL, 0x000fe40003f05270ULL,
0x0000000d0000720cULL, 0x000fe40003f26070ULL, 0x000004000000d802ULL, 0x000fc80000000f00ULL,
0x000006540f0fd816ULL, 0x002fce0000000000ULL, 0x0000000151511836ULL, 0x000fe20000000000ULL,
0x0000000dff51b212ULL, 0x000fe400078e33ffULL, 0x00000005ff007819ULL, 0x000fe40000011609ULL,
0x00001fff08097589ULL, 0x0006e200000e0000ULL, 0x000000ffff077224ULL, 0x000fe200078e0a51ULL,
0x0000000f0200780cULL, 0x040fe40003f24070ULL, 0x00001fff00007589ULL, 0x000ee200000e0000ULL,
0x000000070d0d7224ULL, 0x000fe200078e0204ULL, 0x000000010200780cULL, 0x000fe20003f64070ULL,
0xff317217ff07d424ULL, 0x000fc400078e00ffULL, 0x000000040204d824ULL, 0x000fe400078e020fULL,
0x0000000164642824ULL, 0x004fcc00078e0a0bULL, 0x00008400ff64ab82ULL, 0x000ea20000000800ULL,
0x0000000000240947ULL, 0x008fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000087882ULL, 0x000fe20000000000ULL,
0x7ffc000000097882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01760008043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402087c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000080812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01760804083f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000402087c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000080812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01768804083f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x017400070400d388ULL, 0x0003e20000000800ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x000000100d047824ULL, 0x002fca00078e00ffULL, 0x0000180401007387ULL, 0x0003e20000100800ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x008fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000402047c11ULL, 0x002fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000040912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x0176a804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x008fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402027c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000020912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x0176c804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x00001800010e7983ULL, 0x000ee20000100800ULL,
0x0000000864027c24ULL, 0x004fe4000f8e02ffULL, 0x00000006050ba224ULL, 0x000fe400078e02ffULL,
0x00000008030a7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000a0b557224ULL, 0x000fc800078e02ffULL,
0x0000000851137c24ULL, 0x000fe2000f8e0255ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ffff077224ULL, 0x008fe200078e0a0eULL,
0x0000000e0200720cULL, 0x000fc80003f06070ULL, 0x0000001002547446ULL, 0x000fe20003800007ULL,
0x0000000409027824ULL, 0x000fc600078e0200ULL, 0x000000ff54547207ULL, 0x000fe20000000000ULL,
0x00000002020d7824ULL, 0x000fc600078e00ffULL, 0x000000105400780cULL, 0x000fda0003f05270ULL,
0x0000000000c08947ULL, 0x000fea0003800000ULL, 0x0000000800027d06ULL, 0x000ea20008209000ULL,
0x0000000000047919ULL, 0x002e620000000000ULL, 0x00000008ff007c0cULL, 0x000fe2000bf45070ULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000157919ULL, 0x000ee80000008800ULL,
0x0000000200027308ULL, 0x004ea40000001000ULL, 0x0ffffffe02067836ULL, 0x004fe20000000000ULL,
0x00000004ff087819ULL, 0x002fca0000011604ULL, 0x0000000600077305ULL, 0x0002a2000021f000ULL,
0x000000010d0f7824ULL, 0x000fc800078e0208ULL, 0x000000010e027824ULL, 0x000fe400078e020fULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff117224ULL, 0x004fc800078e0a07ULL,
0x0000000811117c24ULL, 0x000fc8000f8e02ffULL, 0x0000001107077227ULL, 0x000fcc00078e0006ULL,
0x0000000207077227ULL, 0x000fc800078e00ffULL, 0x000000ffff117224ULL, 0x000fc800078e0a07ULL,
0x0000000811067c24ULL, 0x000fca000f8e0202ULL, 0x0000000806007c0cULL, 0x000fda000bf06070ULL,
0x8000000806060c36ULL, 0x000fe40008000000ULL, 0x0000000107070836ULL, 0x000fc60000000000ULL,
0x0000000806007c0cULL, 0x000fda000bf26070ULL, 0x0000000107071836ULL, 0x000fe20000000000ULL,
0x00000008ff07ac12ULL, 0x000fca000f8e33ffULL, 0x000000ffff117224ULL, 0x000fc800078e0a07ULL,
0x0000000811027c24ULL, 0x000fc8000f8e0202ULL, 0x0000000113067824ULL, 0x000fe200078e0202ULL,
0x0000000d54027248ULL, 0x000fc60007fe0000ULL, 0x0000000a07067224ULL, 0x000fe400078e0206ULL,
0x00000010040a7824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fe400078e0a0dULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x000000f00a0d7812ULL, 0x000fe400078ec0ffULL,
0x000000020800720cULL, 0x000fe20003f06070ULL, 0x000000010f087824ULL, 0x040fe200078e0204ULL,
0x0000000d060d7212ULL, 0x000fe200078efcffULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0x0000040000027802ULL, 0x000fc40000000f00ULL, 0x000000040d067c10ULL, 0x000fe4000ff3e0ffULL,
0x0000065415027816ULL, 0x008fe40000000002ULL, 0xfffffff00f0d7812ULL, 0x000fe400078ee208ULL,
0x0000000507077c10ULL, 0x000fc60008ffe4ffULL, 0x000000100d0d7824ULL, 0x000fca00078e0202ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c46ULL,
0x0000000000ac7947ULL, 0x000fea0003800000ULL, 0x0000000800087d06ULL, 0x000ea20008209000ULL,
0x0000000000047919ULL, 0x002e620000000000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00000008ff007c0cULL, 0x000fe2000bf45070ULL, 0x00008c0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000117919ULL, 0x000ee60000008800ULL, 0x0000000800087308ULL, 0x004ea40000001000ULL,
0x0ffffffe080c7836ULL, 0x004fe20000000000ULL, 0x0000000d040d7211ULL, 0x002fca00078fe0ffULL,
0x0000000c00077305ULL, 0x000e62000021f000ULL, 0x000000010e027824ULL, 0x000fe400078e020dULL,
0x000000010d087824ULL, 0x040fe400078e0204ULL, 0x000000100d0d7824ULL, 0x000fca00078e00ffULL,
0xfffffff00d0d7812ULL, 0x000fe200078ee208ULL, 0x000000ffff0f7224ULL, 0x002fc800078e0a07ULL,
0x000000080f0f7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000f070f7227ULL, 0x000fcc00078e0006ULL,
0x000000020f067227ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x0000000807077c24ULL, 0x000fca000f8e0202ULL, 0x0000000807007c0cULL, 0x000fda000bf06070ULL,
0x8000000807070c36ULL, 0x000fe40008000000ULL, 0x0000000106060836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x0000000106061836ULL, 0x000fe20000000000ULL,
0x00000008ff06ac12ULL, 0x000fca000f8e33ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x0000000807027c24ULL, 0x000fc8000f8e0202ULL, 0x0000000113077824ULL, 0x000fe200078e0202ULL,
0x0000040000027802ULL, 0x000fc60000000f00ULL, 0x0000000a06077224ULL, 0x000fe200078e0207ULL,
0x0000065411027816ULL, 0x008fe20000000002ULL, 0x00000010040a7824ULL, 0x000fe400078e00ffULL,
0x0000010007067825ULL, 0x000fc600078e00ffULL, 0x000000f00a0f7812ULL, 0x000fe200078ec0ffULL,
0x000000100d0d7824ULL, 0x000fc600078e0202ULL, 0x0000000f06067212ULL, 0x000fc800078efcffULL,
0x0000000406067c10ULL, 0x000fc8000ff1e0ffULL, 0x0000000507077c10ULL, 0x000fca00087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e8000b901c46ULL,
0x00000000020472caULL, 0x000fe200000e0000ULL, 0x00009400ff067b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x0001760004047890ULL, 0x000fd2000fffe03fULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000405067825ULL, 0x002fe200078e0006ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x00000006060d7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0900720cULL, 0x000fe20003f05270ULL,
0x000000ff0d107836ULL, 0x004fe40000000000ULL, 0x0000080d01007387ULL, 0x0003e20000100800ULL,
0x0000003f0d087836ULL, 0x000fe40000000000ULL, 0x00000008ff1c7819ULL, 0x000fc60000011610ULL,
0x00000006ff1e7819ULL, 0x000fe40000011608ULL, 0x0000101c01007387ULL, 0x0003e80000100800ULL,
0x00000c1e01007387ULL, 0x0003e20000100800ULL, 0x000000ac00208947ULL, 0x000fea0003800000ULL,
0x00000002ff507819ULL, 0x000fe20000011600ULL, 0xffffffffff0e7424ULL, 0x000fe400078e00ffULL,
0x00000004ff0b7424ULL, 0x000fe200078e00ffULL, 0x03ffffff500c7812ULL, 0x000fc800078ec0ffULL,
0x0000001e0c00720cULL, 0x000fda0003f06070ULL, 0x00009600ff078b82ULL, 0x000ea20000000800ULL,
0x0000000205068824ULL, 0x000fce00078e00ffULL, 0x00009200ff088b82ULL, 0x000ee20000000a00ULL,
0x0000000706078224ULL, 0x004fe400078e0207ULL, 0x0000000800067824ULL, 0x000fe400078e0202ULL,
0x000000010c078824ULL, 0x000fe400078e0207ULL, 0x0176880b06ff79a7ULL, 0x0005e4000850003fULL,
0x0000000407088825ULL, 0x008fca00078e0008ULL, 0x00000006080e8981ULL, 0x000ee2000c1e1900ULL,
0x000001ff1000780cULL, 0x000fe20003f04070ULL, 0x00000040514a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff537819ULL, 0x000fe40000011600ULL, 0x00000001000b7812ULL, 0x004fc600078ec0ffULL,
0x0000002053567824ULL, 0x000fe200078e00ffULL, 0x00009000ff067b82ULL, 0x000ea20000000a00ULL,
0x000000030e0e7224ULL, 0x008fc800078e02ffULL, 0x000000400e037824ULL, 0x000fc800078e00ffULL,
0x0000008003067825ULL, 0x004fe200078e0006ULL, 0x000000204a037812ULL, 0x000fe200078ef856ULL,
0x0000000000fc0947ULL, 0x000fec0003800000ULL, 0x000000560d097248ULL, 0x000fe20007fe0000ULL,
0x000000100b087824ULL, 0x000fe200078e00ffULL, 0x00000003ff0d7819ULL, 0x002fc60000011604ULL,
0x0000000109097824ULL, 0x000fe400078e0a56ULL, 0x00000001080e7824ULL, 0x000fe400078e020dULL,
0x000000040d107836ULL, 0x000fe20000000000ULL, 0x0000000809097248ULL, 0x000fe20007fe0000ULL,
0x000000010e0f7824ULL, 0x040fe400078e0204ULL, 0x000000080e147824ULL, 0x000fe400078e00ffULL,
0x0000000109097824ULL, 0x000fc400078e0a08ULL, 0x0000000c0d117836ULL, 0x000fe20000000000ULL,
0xfffffff814147812ULL, 0x000fe200078ee20fULL, 0x000000080d0f7836ULL, 0x000fe20000000000ULL,
0x000000091000720cULL, 0x080fe20003f46070ULL, 0x00000001030e7824ULL, 0x000fe200078e020eULL,
0x000000090d00720cULL, 0x080fe20003f66070ULL, 0x0000000108107824ULL, 0x040fe200078e0210ULL,
0x000000090f00720cULL, 0x080fe20003f26070ULL, 0x00000001080f7824ULL, 0x040fe200078e020fULL,
0x000000091100720cULL, 0x000fe20003f06070ULL, 0x0000000108127824ULL, 0x000fc400078e0211ULL,
0x000000800e087825ULL, 0x000fc800078e00ffULL, 0x00000001100d7824ULL, 0x140fe200078e0204ULL,
0x0000007008137812ULL, 0x000fe200078ef80aULL, 0x0000000810167824ULL, 0x000fe400078e00ffULL,
0x00000001030e7824ULL, 0x000fe400078e020fULL, 0x000000080f187824ULL, 0x040fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee20dULL, 0x000000010f0d7824ULL, 0x000fe400078e0204ULL,
0x0000000103117824ULL, 0x000fc400078e0212ULL, 0x0000000112087824ULL, 0x040fe200078e0204ULL,
0xfffffff818187812ULL, 0x000fe200078ee20dULL, 0x00000008120f7824ULL, 0x000fe200078e00ffULL,
0x0000001306127210ULL, 0x000fe20007f9e0ffULL, 0x0000000103107824ULL, 0x000fe400078e0210ULL,
0x0000200053037824ULL, 0x000fe200078e0202ULL, 0xfffffff80f1a7812ULL, 0x000fe200078ee208ULL,
0x0000000107137824ULL, 0x000fe400020e0609ULL, 0x0000008010087825ULL, 0x000fc800078e00ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x00000070081d7812ULL, 0x000fc600078ef80aULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0x000000700e1b7812ULL, 0x000fe400078ef80aULL,
0x0000001d06087210ULL, 0x000fe20007f9e0ffULL, 0x0001300003037836ULL, 0x000fe20000000000ULL,
0x0000007010197812ULL, 0x000fe400078ef80aULL, 0x0000001b060e7210ULL, 0x000fe20007fbe0ffULL,
0x00000010140d7824ULL, 0x100fe200078e0203ULL, 0x0000001906067210ULL, 0x000fe20007fde0ffULL,
0x0000001016157824ULL, 0x000fc400078e0203ULL, 0x0000000107097824ULL, 0x040fe200020e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000120d7faeULL, 0x0003e2000d901c46ULL,
0x0000001018177824ULL, 0x000fe400078e0203ULL, 0x00000001070f7824ULL, 0x040fe200028e060fULL,
0x0000000008157faeULL, 0x0003e2000d101c46ULL, 0x000000101a037824ULL, 0x000fe400078e0203ULL,
0x0000000107077824ULL, 0x000fe200030e0611ULL, 0x000000000e177faeULL, 0x0003e8000c901c46ULL,
0x0000000006037faeULL, 0x0003e2000c101c46ULL, 0x0000000000c87947ULL, 0x000fea0003800000ULL,
0x000000100b097824ULL, 0x000fca00078e00ffULL, 0x0000000904087211ULL, 0x000fca00078fe8ffULL,
0x00000004080e7836ULL, 0x000fe40000000000ULL, 0x0000000103097824ULL, 0x000fe400078e0208ULL,
0x000000010e0f7824ULL, 0x140fe400078e0204ULL, 0x000000080e147824ULL, 0x000fe400078e00ffULL,
0x00000001080d7824ULL, 0x042fe400078e0204ULL, 0x0000000808107824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee20fULL, 0x00000008080f7836ULL, 0x000fc40000000000ULL,
0x0000000c08117836ULL, 0x000fe20000000000ULL, 0xfffffff8100d7812ULL, 0x000fe200078ee20dULL,
0x0000008009087825ULL, 0x000fc800078e00ffULL, 0x00000001030e7824ULL, 0x040fe200078e020eULL,
0x0000007008137812ULL, 0x000fe200078ef80aULL, 0x0000000103107824ULL, 0x040fe400078e020fULL,
0x0000000103167824ULL, 0x000fe200078e0211ULL, 0x0000001306127210ULL, 0x000fe20007f1e0ffULL,
0x000000010f037824ULL, 0x140fe400078e0204ULL, 0x000000080f187824ULL, 0x000fe400078e00ffULL,
0x0000000111087824ULL, 0x000fc400078e0204ULL, 0x0000000811177824ULL, 0x000fe200078e00ffULL,
0xfffffff818157812ULL, 0x000fe200078ee203ULL, 0x00002000530f7824ULL, 0x000fe400078e0202ULL,
0x0000000107137824ULL, 0x000fe200000e0609ULL, 0xfffffff817177812ULL, 0x000fe200078ee208ULL,
0x000130000f187836ULL, 0x000fe40000000000ULL, 0x000000800e087825ULL, 0x000fc800078e00ffULL,
0x00000080100e7825ULL, 0x000fe200078e00ffULL, 0x00000070081d7812ULL, 0x000fc600078ef80aULL,
0x0000008016107825ULL, 0x000fe200078e00ffULL, 0x000000700e1b7812ULL, 0x000fe400078ef80aULL,
0x0000001d06087210ULL, 0x000fe20007f1e0ffULL, 0x000000100d0d7824ULL, 0x100fe200078e0218ULL,
0x0000007010197812ULL, 0x000fe200078ef80aULL, 0x0000001014037824ULL, 0x100fe200078e0218ULL,
0x0000001b060e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000107097824ULL, 0x000fe200000e0609ULL,
0x0000001906067210ULL, 0x000fe20007f5e0ffULL, 0x0000001015157824ULL, 0x000fe200078e0218ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000120d7faeULL, 0x0003e2000b901c46ULL,
0x00000001070f7824ULL, 0x000fc400008e060fULL, 0x0000001017177824ULL, 0x000fe200078e0218ULL,
0x0000000008037faeULL, 0x0003e2000b901c46ULL, 0x0000000107077824ULL, 0x000fc600010e0611ULL,
0x000000000e157faeULL, 0x0003e8000b901c46ULL, 0x0000000006177faeULL, 0x0003e4000b901c46ULL,
0x000000010c0c7836ULL, 0x000fe40000000000ULL, 0xffffffffff117424ULL, 0x000fc600078e00ffULL,
0x0000001e0c00720cULL, 0x000fda0003f06070ULL, 0x00009600ff088b82ULL, 0x002e620000000800ULL,
0x0000000205038824ULL, 0x000fe200078e00ffULL, 0x00000000530472caULL, 0x000fcc00000e0000ULL,
0x00009200ff068b82ULL, 0x000ea20000000a00ULL, 0x0000000803038224ULL, 0x002fe400078e0208ULL,
0x000176a802087836ULL, 0x000fc80000000000ULL, 0x0000000404047899ULL, 0x000fe2000800063fULL,
0x0000000103038824ULL, 0x000fe200078e020cULL, 0x00000000080572caULL, 0x000fc600000e0000ULL,
0x0000000403068825ULL, 0x004fe200078e0006ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000606118981ULL, 0x000322000c1e1900ULL, 0x000000ff1c00720cULL, 0x000fe20003f05270ULL,
0x00000001ff037424ULL, 0x000fe200078e00ffULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000504057290ULL, 0x000fe2000fffe03fULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fc4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000853097824ULL, 0x000fe200078e0208ULL, 0x0000000000007918ULL, 0x002fcc0000000000ULL,
0x00000003080679a7ULL, 0x0002a20008500004ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fc4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00002003090879a7ULL, 0x0022e2000850003fULL, 0x0000008c00ac8947ULL, 0x000fea0003800000ULL,
0x00009600ff0a7b82ULL, 0x000f620000000800ULL, 0x00000004ff067e24ULL, 0x004fe4000f8e00ffULL,
0x0000002050037824ULL, 0x002fe400078e0202ULL, 0x00000002054b7824ULL, 0x000fe200078e00ffULL,
0x0000001006067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0d7224ULL, 0x008fe400078e0009ULL,
0x000000ffff377224ULL, 0x000fe400078e00ffULL, 0x0000000103087824ULL, 0x000fc400078e0206ULL,
0x000000ffff067224ULL, 0x000fe400078e0007ULL, 0x000000080b0b7824ULL, 0x000fe400078e0208ULL,
0xff317217ff077424ULL, 0x000fe400078e00ffULL, 0x0000000a4b4b7224ULL, 0x020fe400078e020aULL,
0x000000ffff0a7224ULL, 0x000fce00078e00ffULL, 0x000000ffff4f7224ULL, 0x000fce00078e000cULL,
0x0000000000127805ULL, 0x000fce0000015200ULL, 0x0000000400097824ULL, 0x000fca00078e00ffULL,
0xfffffff809097812ULL, 0x000fca00078ec0ffULL, 0x00000001020e7824ULL, 0x000fc800078e0209ULL,
0x0176c80d0e0075a7ULL, 0x000e62000800017fULL, 0x000176c80e097836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff167224ULL, 0x000fce00078e00ffULL,
0x000000101600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001412177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011415ULL,
0x0000001710107211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000210107819ULL, 0x000fc80000001215ULL, 0x000000100000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000116167836ULL, 0x000fce0000000000ULL,
0x0176c80d0e0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000100001107983ULL, 0x000ea20000100800ULL, 0x00009000ff127b82ULL, 0x000e620000000a00ULL,
0x00000010000d7824ULL, 0x000fe200078e00ffULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x000000010a0e7836ULL, 0x000fe40000000000ULL, 0x0000000411117c24ULL, 0x010fe2000f8e02ffULL,
0xffffffe00d157812ULL, 0x000fc600078ec0ffULL, 0x0000004011117824ULL, 0x000fe400078e00ffULL,
0x000001000a157824ULL, 0x000fc800078e0215ULL, 0x0000004015147836ULL, 0x000fca0000000000ULL,
0x0000002014157812ULL, 0x000fca00078ec0ffULL, 0x000000014a387824ULL, 0x000fe200078e0215ULL,
0x000000100e00720cULL, 0x004fe20003f26070ULL, 0x0000008011107825ULL, 0x002fd800078e0012ULL,
0x0000000400089947ULL, 0x000fea0003800000ULL, 0x0000080001167983ULL, 0x000ea20000100800ULL,
0x000000100d0e7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff157819ULL, 0x000fca0000011604ULL,
0x0000000115137824ULL, 0x000fc800078e020eULL, 0x0000000113127824ULL, 0x040fe400078e0204ULL,
0x0000000813177824ULL, 0x000fe400078e00ffULL, 0x0000000138137824ULL, 0x000fc600078e0213ULL,
0xfffffff8173a7812ULL, 0x000fe200078ee212ULL, 0x0000000815177836ULL, 0x000fe40000000000ULL,
0x0000000415127836ULL, 0x000fe20000000000ULL, 0x00000014160d7248ULL, 0x004fe20007fe0000ULL,
0x0000000c15167836ULL, 0x000fc80000000000ULL, 0x000000010d0d7824ULL, 0x000fe400078e0a14ULL,
0x0000001004147824ULL, 0x000fe400078e00ffULL, 0x0000000116397824ULL, 0x000fe200078e020eULL,
0x0000000e0d0d7248ULL, 0x000fe40007fe0000ULL, 0x00000070143f7812ULL, 0x000fe200078ec0ffULL,
0x00000001393b7824ULL, 0x000fe400078e0204ULL, 0x000000010d0d7824ULL, 0x000fc400078e0a0eULL,
0x00000008393e7824ULL, 0x000fc600078e00ffULL, 0x0000000d1500720cULL, 0x080fe20003f86070ULL,
0x0000000112157824ULL, 0x140fe200078e020eULL, 0x0000000d1700720cULL, 0x0c0fe20003f46070ULL,
0x0000000117177824ULL, 0x000fe200078e020eULL, 0x0000000d1200720cULL, 0x080fe20003f66070ULL,
0x00000008150e7824ULL, 0x040fe200078e00ffULL, 0x0000000d1600720cULL, 0x000fe20003f06070ULL,
0x0000000138167824ULL, 0x000fe200078e0215ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee23bULL,
0x00000001150d7824ULL, 0x100fe400078e0204ULL, 0x0000000117157824ULL, 0x000fc400078e0204ULL,
0x00000008173c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee20dULL,
0x0000008013127825ULL, 0x000fc600078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee215ULL,
0x0000000138147824ULL, 0x000fe200078e0217ULL, 0x0000003f12157212ULL, 0x000fe200078efcffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0x0000001510127210ULL, 0x000fe20007fbe0ffULL,
0x0000000138387824ULL, 0x000fe200078e0239ULL, 0x0000003f160d7212ULL, 0x000fe200078efcffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0x0000000d10167210ULL, 0x000fe20007fde0ffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000003f14417212ULL, 0x000fc600078efcffULL,
0x00002000533b7824ULL, 0x000fe200078e0202ULL, 0x0000003f383f7212ULL, 0x000fe200078efcffULL,
0x0000000111137824ULL, 0x040fe200028e0613ULL, 0x0000004110147210ULL, 0x000fe20007fbe0ffULL,
0x000140003b0d7836ULL, 0x000fe40000000000ULL, 0x0000000111177824ULL, 0x000fe200030e0617ULL,
0x0000003f10107210ULL, 0x000fe20007fde0ffULL, 0x000000103a3b7824ULL, 0x100fe400078e020dULL,
0x000000100e3d7824ULL, 0x000fc400078e020dULL, 0x000000103c3f7824ULL, 0x000fe200078e020dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000123b7faeULL, 0x0003e2000e101c46ULL,
0x0000000111157824ULL, 0x040fe400028e0615ULL, 0x000000103e0d7824ULL, 0x000fe200078e020dULL,
0x00000000163d7faeULL, 0x0003e2000d901c46ULL, 0x0000000111117824ULL, 0x000fc600030e0639ULL,
0x00000000143f7faeULL, 0x0003e8000d101c46ULL, 0x00000000100d7faeULL, 0x0003e2000c101c46ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x000000100d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000001004147824ULL, 0x000fc600078e00ffULL, 0x0000000d040d7211ULL, 0x000fe400078fe8ffULL,
0x00000070143f7812ULL, 0x000fc600078ec0ffULL, 0x000000010d0e7824ULL, 0x140fe400078e0204ULL,
0x000000080d177824ULL, 0x000fe400078e00ffULL, 0x000000040d157836ULL, 0x000fe40000000000ULL,
0x0000000c0d397836ULL, 0x000fe20000000000ULL, 0xfffffff8170e7812ULL, 0x000fe200078ee20eULL,
0x0000000115137824ULL, 0x040fe400078e0204ULL, 0x00000008153a7824ULL, 0x000fc400078e00ffULL,
0x000000080d177836ULL, 0x000fe40000000000ULL, 0x0000000138127824ULL, 0x040fe200078e020dULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee213ULL, 0x0000000138157824ULL, 0x040fe400078e0215ULL,
0x0000000138167824ULL, 0x040fe400078e0217ULL, 0x0000000138387824ULL, 0x000fe400078e0239ULL,
0x0000000139147824ULL, 0x000fc400078e0204ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000000839397824ULL, 0x000fe200078e00ffULL, 0x0000003f123b7212ULL, 0x000fe200078efcffULL,
0x00000001170d7824ULL, 0x040fe400078e0204ULL, 0x00000008173c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8393e7812ULL, 0x000fe200078ee214ULL, 0x0000200053177824ULL, 0x000fe200078e0202ULL,
0x0000003b10127210ULL, 0x000fe20007f1e0ffULL, 0x0000008015147825ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fc600078ee20dULL, 0x0001400017457836ULL, 0x000fe20000000000ULL,
0x0000003f14437212ULL, 0x000fe200078efcffULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000003f16417212ULL, 0x000fc600078efcffULL,
0x0000000111137824ULL, 0x040fe200000e0613ULL, 0x0000003f383f7212ULL, 0x000fe200078efcffULL,
0x000000100e0d7824ULL, 0x100fe200078e0245ULL, 0x0000004310147210ULL, 0x000fe20007f1e0ffULL,
0x000000103a3b7824ULL, 0x100fe200078e0245ULL, 0x0000004110167210ULL, 0x000fe20007f5e0ffULL,
0x000000103c3d7824ULL, 0x000fe200078e0245ULL, 0x0000003f10107210ULL, 0x000fe20007f7e0ffULL,
0x0000000111157824ULL, 0x040fe200000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120d7faeULL, 0x0003e2000b901c46ULL, 0x0000000111177824ULL, 0x000fc400010e0617ULL,
0x000000103e3f7824ULL, 0x000fe200078e0245ULL, 0x00000000143b7faeULL, 0x0003e2000b901c46ULL,
0x0000000111117824ULL, 0x000fc600018e0639ULL, 0x00000000163d7faeULL, 0x0003e8000b901c46ULL,
0x00000000103f7faeULL, 0x0003e4000b901c46ULL, 0x00000c00010d7983ULL, 0x002ea20000100800ULL,
0x000000010c0e7836ULL, 0x000fe40000000000ULL, 0xffffffffff167424ULL, 0x000fe400078e00ffULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x0000000d0e00720cULL, 0x004fda0003f06070ULL,
0x00009200ff108b82ULL, 0x000e620000000a00ULL, 0x000000014b0d8824ULL, 0x000fc800078e020eULL,
0x000000040d108825ULL, 0x002fc800078e0010ULL, 0x00000008000d7824ULL, 0x000fe200078e00ffULL,
0x0000000610168981ULL, 0x000328000c1e1900ULL, 0xfffffff00d137812ULL, 0x040fe400078ec0ffULL,
0x000000100d0e7812ULL, 0x000fc600078ec0ffULL, 0x0000000102147824ULL, 0x000fe200078e0213ULL,
0xffffffe00d137812ULL, 0x040fe400078ec0ffULL, 0x000000080d0d7812ULL, 0x000fe400078ec0ffULL,
0x00000000140472caULL, 0x000fe200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000020e0e7210ULL, 0x000fca0007ffe013ULL, 0x000000010e0d7824ULL, 0x000fcc00078e020dULL,
0x000176b004047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x0176b038141479a7ULL, 0x0002a4000850003fULL,
0x017608380d3879a7ULL, 0x0022e4000850003fULL, 0x0000000000107805ULL, 0x000fce0000015200ULL,
0x017608390d0075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fce0000015200ULL,
0x0000001210177210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc80000011413ULL, 0x000000170e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x000000020e0e7819ULL, 0x000fc80000001213ULL,
0x0000000e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x017608390d0075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x00000010044d7824ULL, 0x000fe200078e00ffULL,
0x00000001ff527819ULL, 0x000fe20000011604ULL, 0x00000020000e7824ULL, 0x000fe400078e00ffULL,
0x00000001ff177424ULL, 0x000fe200078e00ffULL, 0x000000704d4d7812ULL, 0x000fe400078ec0ffULL,
0xffffff800e0e7812ULL, 0x000fe400078ec0ffULL, 0x0000000c52527812ULL, 0x000fe400078ec0ffULL,
0x000000024d117210ULL, 0x000fca0007ffe00eULL, 0x0000000111117824ULL, 0x000fca00078e0252ULL,
0x0170000011107984ULL, 0x000ee80000000800ULL, 0x0172000011127984ULL, 0x000b620000000800ULL,
0x000000071000720bULL, 0x008fda0003f1d000ULL, 0x00000000000e7806ULL, 0x000fc800000e0100ULL,
0x0000ffff0e137812ULL, 0x000fe2000780c0ffULL, 0x000000ffff0e7224ULL, 0x000fd800078e0007ULL,
0x0000000000fc8947ULL, 0x026fea0003800000ULL, 0x000000005000720cULL, 0x000fe40003f45270ULL,
0x000000071000720bULL, 0x0c0fe40003f14000ULL, 0x0000000710397209ULL, 0x000fd20007810000ULL,
0x00000080000ea824ULL, 0x000fe400078e0202ULL, 0x0000000000387806ULL, 0x000fc600000e0100ULL,
0x0000000e520ea210ULL, 0x000fe40007ffe04dULL, 0x0000991038117816ULL, 0x000fc600000000ffULL,
0x017400390e00a388ULL, 0x0003e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x8000003907077221ULL, 0x000fe20000010000ULL,
0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0038ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b07077820ULL, 0x000fc80000410000ULL, 0x00000007000e7308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff077819ULL, 0x002fcc0000011604ULL,
0x00001f070e077589ULL, 0x004e6400000e0000ULL, 0x0000000718187220ULL, 0x082fe20000410000ULL,
0x0000000719197220ULL, 0x080fe20000410000ULL, 0x000000071c1c7220ULL, 0x080fe20000410000ULL,
0x000000071d1d7220ULL, 0x080fe20000410000ULL, 0x0000000720207220ULL, 0x080fe20000410000ULL,
0x0000000721217220ULL, 0x080fe20000410000ULL, 0x0000000724247220ULL, 0x080fe20000410000ULL,
0x0000000725257220ULL, 0x080fe20000410000ULL, 0x0000000728287220ULL, 0x080fe20000410000ULL,
0x0000000729297220ULL, 0x080fe20000410000ULL, 0x000000072c2c7220ULL, 0x080fe20000410000ULL,
0x000000072d2d7220ULL, 0x080fe20000410000ULL, 0x0000000730307220ULL, 0x080fe20000410000ULL,
0x0000000731317220ULL, 0x080fe20000410000ULL, 0x0000000734347220ULL, 0x080fe20000410000ULL,
0x0000000735357220ULL, 0x000fce0000410000ULL, 0x0000000e0f0f7220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x0000000804077811ULL, 0x002fcc00078ff0ffULL,
0x00001f070e077589ULL, 0x000e6400000e0000ULL, 0x000000071a1a7220ULL, 0x082fe20000410000ULL,
0x000000071b1b7220ULL, 0x080fe20000410000ULL, 0x000000071e1e7220ULL, 0x080fe20000410000ULL,
0x000000071f1f7220ULL, 0x080fe20000410000ULL, 0x0000000722227220ULL, 0x080fe20000410000ULL,
0x0000000723237220ULL, 0x080fe20000410000ULL, 0x0000000726267220ULL, 0x080fe20000410000ULL,
0x0000000727277220ULL, 0x080fe20000410000ULL, 0x000000072a2a7220ULL, 0x080fe20000410000ULL,
0x000000072b2b7220ULL, 0x080fe20000410000ULL, 0x000000072e2e7220ULL, 0x080fe20000410000ULL,
0x000000072f2f7220ULL, 0x080fe20000410000ULL, 0x0000000732327220ULL, 0x080fe20000410000ULL,
0x0000000733337220ULL, 0x080fe20000410000ULL, 0x0000000736367220ULL, 0x080fe20000410000ULL,
0x0000000737377220ULL, 0x000fce0000410000ULL, 0x0000ffff13ff7812ULL, 0x000fe20007806038ULL,
0x00000001ff177424ULL, 0x000fe400078e00ffULL, 0x000000ffff0e7224ULL, 0x000fd400078e0039ULL,
0x8000003910100221ULL, 0x100fe20000010000ULL, 0x000000ffff0e0224ULL, 0x000fe200078e0039ULL,
0x00007610ff170816ULL, 0x000fe40000000017ULL, 0x3fb8aa3b10100820ULL, 0x000fc80000410000ULL,
0x0000001000080308ULL, 0x000ea40000000800ULL, 0x0000000812120220ULL, 0x004fce0000410000ULL,
0x0000000f120f7221ULL, 0x000fce0000010000ULL, 0x0000000000107805ULL, 0x000fce0000015200ULL,
0x0000000800077824ULL, 0x002fca00078e00ffULL, 0xfffffff007077812ULL, 0x000fca00078ec0ffULL,
0x0000000102397824ULL, 0x000fc800078e0207ULL, 0x0176a806390075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fce0000015200ULL, 0x0000001210127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011413ULL,
0x0000001207077211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x0000000207077819ULL, 0x000fc80000001212ULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x0176a806390075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000200457824ULL, 0x040fe200078e00ffULL, 0x0000991017077816ULL, 0x000fe200000000ffULL,
0x0000000400467824ULL, 0x000fe200078e00ffULL, 0x00000007043e7812ULL, 0x000fe200078ec0ffULL,
0x0000020000067824ULL, 0x000fe200078e00ffULL, 0x0000000445117812ULL, 0x000fe400078ec0ffULL,
0x000000ff0700720cULL, 0x000fe20003f05270ULL, 0x0000200053077824ULL, 0x000fe200078e0202ULL,
0x000000083e477812ULL, 0x000fe400078ef804ULL, 0x00000011044c7211ULL, 0x040fe200078fe0ffULL,
0x0001300007177836ULL, 0x000fe20000000000ULL, 0x00000008043d7812ULL, 0x000fe200078ec0ffULL,
0x0000000847117824ULL, 0x040fe200078e00ffULL, 0x00000004ff487819ULL, 0x000fe20000011604ULL,
0x00000001474c7824ULL, 0x000fe200078e024cULL, 0x0000000446467812ULL, 0x000fc400078ec0ffULL,
0x0000003e3d417212ULL, 0x000fe400078efcffULL, 0xfffff800063f7812ULL, 0x000fe200078ec0ffULL,
0x0000000148467824ULL, 0x000fe200078e0246ULL, 0xfffffff8114e7812ULL, 0x000fe200078ee24cULL,
0x0000000841137824ULL, 0x040fe400078e00ffULL, 0x0000000141407824ULL, 0x000fe400078e0246ULL,
0x00000001023f7824ULL, 0x000fc600078e023fULL, 0xfffffff813067812ULL, 0x000fe200078ee240ULL,
0x000000104e3c7824ULL, 0x000fe200078e023fULL, 0x0000000000180947ULL, 0x000fec0003800000ULL,
0x00000002ff057819ULL, 0x000fe40000011604ULL, 0x00000008ff03723eULL, 0x000fc600000000ffULL,
0x0000000805117836ULL, 0x000fe20000000000ULL, 0x0000541003107816ULL, 0x000fca0000000003ULL,
0x00001f0510057589ULL, 0x0002a800000e0000ULL, 0x00001f1110037589ULL, 0x0002e400000e0000ULL,
0x011000003c10783bULL, 0x0022e20000000200ULL, 0x0000001006387824ULL, 0x000fe200078e0217ULL,
0x0000000000100947ULL, 0x000fec0003800000ULL, 0x0000000510107232ULL, 0x08cfe40000000000ULL,
0x0000000512127232ULL, 0x000fe40000000000ULL, 0x0000000311117232ULL, 0x080fe40000000000ULL,
0x0000000313137232ULL, 0x000fce0000000000ULL, 0x0000000841417824ULL, 0x000fe200078e00ffULL,
0x000000003838783bULL, 0x000f620000004200ULL, 0x0000000240447836ULL, 0x000fe20000000000ULL,
0x000000103d3d7812ULL, 0x000fe200078efe3eULL, 0x0000000453487824ULL, 0x000fc600078e0248ULL,
0xfffffff841447812ULL, 0x000fe200078ee244ULL, 0x0000000146467824ULL, 0x000fe200078e023dULL,
0x0000000248487810ULL, 0x000fe20007ffe047ULL, 0x0000000847477824ULL, 0x000fe400078e00ffULL,
0x0000001044407824ULL, 0x000fc600078e0217ULL, 0xfffffff8473e7812ULL, 0x000fc600078ee248ULL,
0x000000004040783bULL, 0x000f640000004200ULL, 0x000000103e3f7824ULL, 0x000fe200078e023fULL,
0x00000018ff6d7819ULL, 0x022fe4000001163aULL, 0x00000010ff687819ULL, 0x000fe40000011638ULL,
0x00000010ff697819ULL, 0x000fe40000011639ULL, 0x0000ffff386a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff39677812ULL, 0x000fc400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe40000011639ULL,
0x0000ffff39607812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x000fe4000001163aULL,
0x000000ff68687812ULL, 0x000fe400078ec0ffULL, 0x00000010ff397819ULL, 0x008fe40000011641ULL,
0x000000ff415a7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe40000011641ULL,
0x0000ffff41617812ULL, 0x000fe400078ec0ffULL, 0x0000006dff41723eULL, 0x000fe400020006ffULL,
0x000000ff696d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff657819ULL, 0x000fe4000001163bULL,
0x00000008ff697819ULL, 0x000fc4000001166aULL, 0x000000ff386b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff667819ULL, 0x000fe40000011640ULL, 0x00000068ff6a723eULL, 0x000fe400020006ffULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x00000018ff637819ULL, 0x000fe40000011638ULL,
0x00000018ff6c7819ULL, 0x000fc4000001163bULL, 0x00000069ff68723eULL, 0x000fe400020006ffULL,
0x000000ff65657812ULL, 0x000fe400078ec0ffULL, 0x0000ffff40387812ULL, 0x000fe400078ec0ffULL,
0x00000008ff697819ULL, 0x000fe40000011660ULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fc400020006ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x000000ff66607812ULL, 0x000fe400078ec0ffULL, 0x000000ff405b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff587819ULL, 0x000fe40000011640ULL, 0x00000064ff66723eULL, 0x000fe400020006ffULL,
0x0000006cff40723eULL, 0x000fc400020006ffULL, 0x00000065ff64723eULL, 0x000fe400020006ffULL,
0x000000ff396c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff657819ULL, 0x000fe40000011638ULL,
0x000054106b387816ULL, 0x000fe4000000006aULL, 0x0000541067397816ULL, 0x000fe4000000006dULL,
0x00000063ff63723eULL, 0x000fc400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x000000381018723cULL, 0x000fe20000001818ULL,
0x000000ff3a5f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3b5e7812ULL, 0x000fe400078ec0ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x0000541068387816ULL, 0x000fc40000000063ULL,
0x0000541069397816ULL, 0x000fe40000000062ULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x00000038101c723cULL, 0x000fe2000000181cULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000006cff67723eULL, 0x000fc400020006ffULL, 0x00000008ff617819ULL, 0x000fe40000011661ULL,
0x000054105f387816ULL, 0x000fe40000000066ULL, 0x000054105e397816ULL, 0x000fe40000000064ULL,
0x00000010ff5c7819ULL, 0x000fe40000011642ULL, 0x00000010ff5d7819ULL, 0x000fe40000011643ULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x000000381020723cULL, 0x000fe20000001820ULL,
0x00000057ff57723eULL, 0x000fc400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x000054105b387816ULL, 0x000fe40000000060ULL,
0x000054105a397816ULL, 0x000fe40000000067ULL, 0x0000ffff3a597812ULL, 0x000fe400078ec0ffULL,
0x000000ff42477812ULL, 0x000fc400078ec0ffULL, 0x00000018ff3a7819ULL, 0x000fe20000011642ULL,
0x000000381028723cULL, 0x000fe20000001828ULL, 0x0000ffff42497812ULL, 0x000fe400078ec0ffULL,
0x000000ff43427812ULL, 0x000fe400078ec0ffULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL, 0x0000541065387816ULL, 0x000fc40000000058ULL,
0x0000541061397816ULL, 0x000fe40000000057ULL, 0x0000ffff3b487812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3b7819ULL, 0x000fe40000011643ULL, 0x0000ffff43437812ULL, 0x000fe200078ec0ffULL,
0x00000038102c723cULL, 0x000fe2000000182cULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fc400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000008ff597819ULL, 0x000fe40000011659ULL,
0x00000008ff497819ULL, 0x000fe40000011649ULL, 0x00000008ff487819ULL, 0x000fe40000011648ULL,
0x00000008ff437819ULL, 0x000fc40000011643ULL, 0x0000541047387816ULL, 0x000fe2000000005cULL,
0x000000083d477824ULL, 0x000fe200078e00ffULL, 0x0000541042397816ULL, 0x000fe4000000005dULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x0000003bff3b723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x000000381030723cULL, 0x000fe20000001830ULL,
0x00000049ff49723eULL, 0x000fc400020006ffULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x0000541059387816ULL, 0x000fe40000000041ULL,
0x0000541048397816ULL, 0x000fe40000000040ULL, 0x00005410493a7816ULL, 0x000fe4000000003aULL,
0x00005410433b7816ULL, 0x000fc4000000003bULL, 0xfffffff8473e7812ULL, 0x000fe200078ee246ULL,
0x000000381024723cULL, 0x000fec0000001824ULL, 0x0000003a1034723cULL, 0x000fe20000001834ULL,
0x000000103e387824ULL, 0x000fe200078e0217ULL, 0x011000003f10783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000510107232ULL, 0x08cfe40000000000ULL, 0x0000000512127232ULL, 0x000fe40000000000ULL,
0x0000000311117232ULL, 0x080fe40000000000ULL, 0x0000000313137232ULL, 0x000fce0000000000ULL,
0x000000083d407824ULL, 0x000fe200078e00ffULL, 0x000000003838783bULL, 0x000f620000004200ULL,
0x00000002463d7836ULL, 0x000fe20000000000ULL, 0xfffffff845457812ULL, 0x000fc800078ec0ffULL,
0xfffffff8403d7812ULL, 0x000fe200078ee23dULL, 0x0000000102457824ULL, 0x000fc800078e0245ULL,
0x000000103d407824ULL, 0x000fcc00078e0217ULL, 0x000000004040783bULL, 0x000f640000004200ULL,
0x00000010ff6a7819ULL, 0x022fe40000011638ULL, 0x00000010ff697819ULL, 0x100fe40000011639ULL,
0x000000ff39657812ULL, 0x040fe400078ec0ffULL, 0x00000018ff637819ULL, 0x000fe40000011639ULL,
0x0000ffff39677812ULL, 0x000fc400078ec0ffULL, 0x000000ff38667812ULL, 0x040fe400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe40000011638ULL, 0x0000ffff38687812ULL, 0x000fe400078ec0ffULL,
0x000000ff6a6a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff436c7812ULL, 0x008fe400078ec0ffULL,
0x00000010ff397819ULL, 0x000fc40000011641ULL, 0x000000ff41497812ULL, 0x040fe400078ec0ffULL,
0x00000018ff467819ULL, 0x000fe40000011641ULL, 0x0000ffff415d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff597819ULL, 0x100fe40000011643ULL, 0x00000018ff417819ULL, 0x000fe40000011643ULL,
0x0000ffff43587812ULL, 0x000fc400078ec0ffULL, 0x000000ff426b7812ULL, 0x000fe400078ec0ffULL,
0x0000006cff43723eULL, 0x000fe400020006ffULL, 0x000000ff696c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff387819ULL, 0x100fe40000011640ULL, 0x000000ff40577812ULL, 0x000fe400078ec0ffULL,
0x00000018ff477819ULL, 0x000fc40000011640ULL, 0x0000ffff40627812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x100fe40000011642ULL, 0x00000018ff407819ULL, 0x000fe40000011642ULL,
0x0000ffff42487812ULL, 0x000fe400078ec0ffULL, 0x0000006bff42723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fc400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x0000006aff6b723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x000000ff386d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff396e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff697819ULL, 0x000fc40000011668ULL, 0x00000008ff677819ULL, 0x000fe40000011667ULL,
0x0000541066387816ULL, 0x000fe4000000006bULL, 0x0000541065397816ULL, 0x000fe4000000006cULL,
0x00000010ff5c7819ULL, 0x100fe4000001163aULL, 0x000000ff3a607812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fc4000001163aULL, 0x00000010ff617819ULL, 0x100fe4000001163bULL,
0x000000ff3b5f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001163bULL,
0x0000ffff3a3a7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3b3b7812ULL, 0x000fe400078ec0ffULL,
0x00000064ff64723eULL, 0x000fc400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000067ff6a723eULL, 0x000fe400020006ffULL,
0x000000ff5c687812ULL, 0x000fe400078ec0ffULL, 0x000000ff61677812ULL, 0x000fe400078ec0ffULL,
0x00000008ff617819ULL, 0x000fc4000001163aULL, 0x00000008ff5c7819ULL, 0x000fe4000001163bULL,
0x000000381038723cULL, 0x000fe20000001818ULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x0000541069187816ULL, 0x000fe40000000064ULL, 0x000054106a197816ULL, 0x000fc40000000063ULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x00000018101c723cULL, 0x000fe2000000181cULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fc400020006ffULL, 0x0000541060187816ULL, 0x000fe40000000068ULL,
0x000054105f197816ULL, 0x000fe40000000067ULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x0000006dff1b723eULL, 0x000fe400020006ffULL, 0x0000006eff1a723eULL, 0x000fe200020006ffULL,
0x000000181020723cULL, 0x000fe20000001820ULL, 0x00000008ff627819ULL, 0x000fc40000011662ULL,
0x00000008ff5d7819ULL, 0x000fe4000001165dULL, 0x000000ff5e637812ULL, 0x000fe400078ec0ffULL,
0x0000541061187816ULL, 0x000fe4000000005bULL, 0x000054105c197816ULL, 0x000fe4000000005aULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fc400020006ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x000000181024723cULL, 0x000fe20000001824ULL,
0x0000005dff5e723eULL, 0x000fe400020006ffULL, 0x000000ff59597812ULL, 0x000fe400078ec0ffULL,
0x00000008ff487819ULL, 0x000fe40000011648ULL, 0x0000541057187816ULL, 0x000fe4000000001bULL,
0x0000541049197816ULL, 0x000fe2000000001aULL, 0x00000001ff1a7424ULL, 0x000fe200078e00ffULL,
0x00000008ff587819ULL, 0x000fc40000011658ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x000000181028723cULL, 0x000fe20000001828ULL,
0x00000063ff5d723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x0000541062187816ULL, 0x000fc40000000047ULL,
0x000054105e197816ULL, 0x000fe40000000046ULL, 0x00000058ff49723eULL, 0x000fe400020006ffULL,
0x0000541042427816ULL, 0x000fe4000000005dULL, 0x0000541043437816ULL, 0x000fe20000000059ULL,
0x00000018102c723cULL, 0x000fe2000000182cULL, 0x0000541048487816ULL, 0x000fe40000000040ULL,
0x0000541049497816ULL, 0x000fc60000000041ULL, 0x000000421030723cULL, 0x000fe20000001830ULL,
0x0000000853187824ULL, 0x000fca00078e0202ULL, 0x000000481034723cULL, 0x000fe20000001834ULL,
0x0176c81a181879a7ULL, 0x0002e2000850003fULL, 0x0176881a45ff79a7ULL, 0x0003de000850003fULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000107805ULL, 0x000fce0000015200ULL,
0x00000019090075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff1a7224ULL, 0x002fce00078e00ffULL, 0x000000101a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fce0000015200ULL,
0x00000012101b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001b12127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011a1a7836ULL, 0x000fce0000000000ULL, 0x00000019090075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00009000ff107b82ULL, 0x000ee20000000a00ULL,
0x0000001000127824ULL, 0x000fe200078e00ffULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x0000000416167c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe012137812ULL, 0x000fe400078ec0ffULL,
0x0000004016197824ULL, 0x000fc600078e00ffULL, 0x000001000a137824ULL, 0x000fc800078e0213ULL,
0x00000080131b7836ULL, 0x000fca0000000000ULL, 0x000000201b137812ULL, 0x000fe200078ec0ffULL,
0x0000008019107825ULL, 0x008fc800078e0010ULL, 0x000000014a167824ULL, 0x000fe200078e0213ULL,
0x0000000000f89947ULL, 0x000fec0003800000ULL, 0x0000080001407983ULL, 0x000ee20000100800ULL,
0x0000001012137812ULL, 0x000fe400078ec0ffULL, 0x00000003ff187819ULL, 0x000fca0000011604ULL,
0x0000000118197824ULL, 0x000fc800078e0213ULL, 0x00000001191a7824ULL, 0x042fe400078e0204ULL,
0x0000000819417824ULL, 0x000fca00078e00ffULL, 0xfffffff841427812ULL, 0x000fe200078ee21aULL,
0x00000008181a7836ULL, 0x000fe40000000000ULL, 0x0000000c18417836ULL, 0x000fe40000000000ULL,
0x000000011a437824ULL, 0x100fe400078e0213ULL, 0x0000000141457824ULL, 0x000fe400078e0213ULL,
0x0000000843487824ULL, 0x000fe200078e00ffULL, 0x0000001b40127248ULL, 0x008fca0007fe0000ULL,
0x0000000112127824ULL, 0x000fe400078e0a1bULL, 0x00000004181b7836ULL, 0x000fc60000000000ULL,
0x0000001213127248ULL, 0x000fca0007fe0000ULL, 0x0000000112127824ULL, 0x000fca00078e0a13ULL,
0x000000121b00720cULL, 0x0c0fe20003f66070ULL, 0x000000011b1b7824ULL, 0x000fe200078e0213ULL,
0x000000121800720cULL, 0x080fe20003f86070ULL, 0x0000000119187824ULL, 0x100fe200078e0216ULL,
0x000000124100720cULL, 0x080fe20003f06070ULL, 0x000000011b407824ULL, 0x000fe200078e0216ULL,
0x000000121a00720cULL, 0x000fe20003f46070ULL, 0x0000000143197824ULL, 0x100fe400078e0204ULL,
0x000000011b137824ULL, 0x040fe400078e0204ULL, 0x000000081b467824ULL, 0x000fe200078e00ffULL,
0xfffffff848487812ULL, 0x000fe200078ee219ULL, 0x0000008040407825ULL, 0x000fc600078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee213ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000004d40137212ULL, 0x000fc600078efcffULL, 0x00000001431a7824ULL, 0x100fe200078e0216ULL,
0x0000004d18437212ULL, 0x000fe200078efcffULL, 0x0000000145127824ULL, 0x000fe200078e0216ULL,
0x0000001310407210ULL, 0x000fe20007fde0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000004310187210ULL, 0x000fc60007fbe0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000004d1a497212ULL, 0x000fc600078efcffULL, 0x0000000145167824ULL, 0x040fe200078e0204ULL,
0x0000004d12477212ULL, 0x000fe200078efcffULL, 0x0000000845457824ULL, 0x000fe400078e00ffULL,
0x0000000111197824ULL, 0x040fe400028e0619ULL, 0x0000000111417824ULL, 0x000fe200030e0641ULL,
0xfffffff845587812ULL, 0x000fe200078ee216ULL, 0x0000001042437824ULL, 0x100fe200078e0217ULL,
0x0000004910167210ULL, 0x000fe20007fbe0ffULL, 0x0000001046457824ULL, 0x100fe200078e0217ULL,
0x0000004710107210ULL, 0x000fe20007fde0ffULL, 0x0000001048477824ULL, 0x100fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018437faeULL, 0x0003e2000e101c46ULL,
0x0000001058497824ULL, 0x000fc400078e0217ULL, 0x0000000111177824ULL, 0x040fe200028e061bULL,
0x0000000040457faeULL, 0x0003e2000d901c46ULL, 0x0000000111117824ULL, 0x000fc600030e0613ULL,
0x0000000016477faeULL, 0x0003e8000d101c46ULL, 0x0000000010497faeULL, 0x0003e2000c101c46ULL,
0x0000000000c07947ULL, 0x000fea0003800000ULL, 0x0000001012137812ULL, 0x000fc800078ec0ffULL,
0x0000001304137211ULL, 0x000fca00078fe8ffULL, 0x0000000113187824ULL, 0x040fe400078e0204ULL,
0x00000008131b7824ULL, 0x040fe400078e00ffULL, 0x0000000113127824ULL, 0x000fe400078e0216ULL,
0x0000000413197836ULL, 0x000fe20000000000ULL, 0xfffffff81b427812ULL, 0x000fe200078ee218ULL,
0x0000000813417836ULL, 0x000fe40000000000ULL, 0x0000000c13457836ULL, 0x002fc40000000000ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x00000001191b7824ULL, 0x040fe400078e0204ULL,
0x0000000819467824ULL, 0x000fe400078e00ffULL, 0x00000001411a7824ULL, 0x040fe400078e0216ULL,
0x0000000141437824ULL, 0x140fe400078e0204ULL, 0x0000000841487824ULL, 0x000fe400078e00ffULL,
0x0000000145417824ULL, 0x000fc400078e0204ULL, 0x0000000845587824ULL, 0x000fe400078e00ffULL,
0x0000000119407824ULL, 0x100fe200078e0216ULL, 0x0000004d12197212ULL, 0x000fe200078efcffULL,
0x0000000145187824ULL, 0x000fe200078e0216ULL, 0xfffffff846167812ULL, 0x000fe200078ee21bULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0xfffffff848467812ULL, 0x000fe400078ee243ULL,
0xfffffff858487812ULL, 0x000fe200078ee241ULL, 0x0000008040407825ULL, 0x000fe200078e00ffULL,
0x0000001910127210ULL, 0x000fc40007f1e0ffULL, 0x0000004d1a577212ULL, 0x080fe200078efcffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000004d40597212ULL, 0x080fe400078efcffULL,
0x00000057101a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000111137824ULL, 0x000fe200000e0613ULL,
0x0000004d18497212ULL, 0x000fe200078efcffULL, 0x0000001016457824ULL, 0x100fe200078e0217ULL,
0x0000005910167210ULL, 0x000fe20007f1e0ffULL, 0x0000001042437824ULL, 0x100fe200078e0217ULL,
0x0000004910107210ULL, 0x000fe20007f7e0ffULL, 0x0000001046477824ULL, 0x000fc400078e0217ULL,
0x0000001048497824ULL, 0x000fe200078e0217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012437faeULL, 0x0003e2000b901c46ULL, 0x0000000111177824ULL, 0x040fe400000e0641ULL,
0x00000001111b7824ULL, 0x040fe400010e061bULL, 0x0000000111117824ULL, 0x000fe200018e0619ULL,
0x0000000016457faeULL, 0x0003e8000b901c46ULL, 0x000000001a477faeULL, 0x0003e8000b901c46ULL,
0x0000000010497faeULL, 0x0003e4000b901c46ULL, 0x00000c0001117983ULL, 0x002ee20000100800ULL,
0x000000020c107836ULL, 0x000fe40000000000ULL, 0x00000001ff167424ULL, 0x000fc600078e00ffULL,
0x000000111000720cULL, 0x008fe20003f06070ULL, 0xffffffffff117424ULL, 0x000fd800078e00ffULL,
0x00009200ff128b82ULL, 0x000e620000000a00ULL, 0x000000014b178824ULL, 0x000fe400078e0210ULL,
0x0000000800107824ULL, 0x000fe400078e00ffULL, 0x0000000417128825ULL, 0x002fc600078e0012ULL,
0xfffffff010177812ULL, 0x000fe400078ec0ffULL, 0x0000000612118981ULL, 0x000326000c1e1900ULL,
0x0000000102177824ULL, 0x000fca00078e0217ULL, 0x00000000170472caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000176a804047890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x002fe40000000000ULL,
0x0176a816171279a7ULL, 0x0002e4000850003fULL, 0x017628160d1679a7ULL, 0x0022a4000850003fULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x017628170d0075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff407224ULL, 0x000fce00078e00ffULL,
0x000000104000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x0000001a18417210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0e19ULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc8000001141bULL,
0x0000004110107211ULL, 0x000fca00078110ffULL, 0x000000ffff1b7224ULL, 0x000fca00000e061bULL,
0x0000000210107819ULL, 0x000fc8000000121bULL, 0x000000100000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000140407836ULL, 0x000fce0000000000ULL,
0x017628170d0075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000002000107824ULL, 0x000fe400078e00ffULL, 0x00000001ff1a7424ULL, 0x000fc600078e00ffULL,
0xffffff8010177812ULL, 0x000fc800078ec0ffULL, 0x0000008002107810ULL, 0x000fc80007ffe017ULL,
0x0000001052107210ULL, 0x000fca0007ffe04dULL, 0x0170000010177984ULL, 0x000ea80000000800ULL,
0x0172000010187984ULL, 0x000b620000000800ULL, 0x0000000e1700720bULL, 0x004fda0003f1d000ULL,
0x0000000000167806ULL, 0x000fc800000e0100ULL, 0x0000ffff161b7812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x02afea0003800000ULL, 0x0000000150197836ULL, 0x000fe20000000000ULL,
0x0000000e1700720bULL, 0x000fc80003f14000ULL, 0x000000001900720cULL, 0x000fd20003f45270ULL,
0x00000000001a7806ULL, 0x000fc800000e0100ULL, 0x000000800016a824ULL, 0x000fe200078e0202ULL,
0x0000000e1710a209ULL, 0x000fc80007810000ULL, 0x000000165219a210ULL, 0x000fe40007ffe04dULL,
0x000099101a167816ULL, 0x000fc600000000ffULL, 0x017400101900a388ULL, 0x0003e20000000800ULL,
0x000000ff1600720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000000e17197209ULL, 0x000fe40007810000ULL, 0x000000ff1aff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff001aff7812ULL, 0x000fe2000784c0ffULL, 0x0000000e19107221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000167308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff197819ULL, 0x000fca0000011604ULL,
0x00001f1916107589ULL, 0x006e6400000e0000ULL, 0x0000003810387220ULL, 0x042fe20000410000ULL,
0x0000003910397220ULL, 0x040fe20000410000ULL, 0x0000001c101c7220ULL, 0x040fe20000410000ULL,
0x0000001d101d7220ULL, 0x040fe20000410000ULL, 0x0000002010207220ULL, 0x040fe20000410000ULL,
0x0000002110217220ULL, 0x040fe20000410000ULL, 0x0000002410247220ULL, 0x040fe20000410000ULL,
0x0000002510257220ULL, 0x040fe20000410000ULL, 0x0000002810287220ULL, 0x040fe20000410000ULL,
0x0000002910297220ULL, 0x040fe20000410000ULL, 0x0000002c102c7220ULL, 0x040fe20000410000ULL,
0x0000002d102d7220ULL, 0x040fe20000410000ULL, 0x0000003010307220ULL, 0x040fe20000410000ULL,
0x0000003110317220ULL, 0x040fe20000410000ULL, 0x0000003410347220ULL, 0x040fe20000410000ULL,
0x0000003510357220ULL, 0x000fce0000410000ULL, 0x000000160f0f7220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x0000000804197811ULL, 0x000fca00078ff0ffULL,
0x00001f1916107589ULL, 0x002e6400000e0000ULL, 0x0000003a103a7220ULL, 0x042fe20000410000ULL,
0x0000003b103b7220ULL, 0x040fe20000410000ULL, 0x0000001e101e7220ULL, 0x040fe20000410000ULL,
0x0000001f101f7220ULL, 0x040fe20000410000ULL, 0x0000002210227220ULL, 0x040fe20000410000ULL,
0x0000002310237220ULL, 0x040fe20000410000ULL, 0x0000002610267220ULL, 0x040fe20000410000ULL,
0x0000002710277220ULL, 0x040fe20000410000ULL, 0x0000002a102a7220ULL, 0x040fe20000410000ULL,
0x0000002b102b7220ULL, 0x040fe20000410000ULL, 0x0000002e102e7220ULL, 0x040fe20000410000ULL,
0x0000002f102f7220ULL, 0x040fe20000410000ULL, 0x0000003210327220ULL, 0x040fe20000410000ULL,
0x0000003310337220ULL, 0x040fe20000410000ULL, 0x0000003610367220ULL, 0x040fe20000410000ULL,
0x0000003710377220ULL, 0x000fce0000410000ULL, 0x0000ffff1bff7812ULL, 0x000fe2000780601aULL,
0x00000001ff1a7424ULL, 0x000fe200078e00ffULL, 0x0000000e170e7209ULL, 0x000fd60007810000ULL,
0x8000000e17170221ULL, 0x000fe20000010000ULL, 0x00007610ff1a0816ULL, 0x000fc6000000001aULL,
0x3fb8aa3b17170820ULL, 0x000fc80000410000ULL, 0x0000001700080308ULL, 0x000ea40000000800ULL,
0x0000000818180220ULL, 0x004fce0000410000ULL, 0x0000000f180f7221ULL, 0x000fce0000010000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000000800107824ULL, 0x002fca00078e00ffULL,
0xfffffff010197812ULL, 0x000fca00078ec0ffULL, 0x0000000102417824ULL, 0x000fc800078e0219ULL,
0x0176b015410075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff407224ULL, 0x000fce00078e00ffULL, 0x000000104000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fce0000015200ULL,
0x00000018161b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000119197824ULL, 0x000fe200000e0e17ULL,
0x003d09001b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x000fc80000011419ULL, 0x0000001b10107211ULL, 0x000fca00078110ffULL,
0x000000ffff197224ULL, 0x000fca00000e0619ULL, 0x0000000210107819ULL, 0x000fc80000001219ULL,
0x000000100000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000140407836ULL, 0x000fce0000000000ULL, 0x0176b015410075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000099101a107816ULL, 0x000fc800000000ffULL,
0x000000ff1000720cULL, 0x000fe20003f05270ULL, 0x0001400007107836ULL, 0x000fc80000000000ULL,
0x0000001006497824ULL, 0x000fd000078e0210ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff057819ULL, 0x000fe40000011604ULL, 0x00000008ff03723eULL, 0x000fc600000000ffULL,
0x0000000805157836ULL, 0x000fe20000000000ULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f0514057589ULL, 0x0002a800000e0000ULL, 0x00001f1514037589ULL, 0x0002e400000e0000ULL,
0x011800003c18783bULL, 0x0002e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000518187232ULL, 0x08cfe40000000000ULL, 0x000000051a1a7232ULL, 0x000fe40000000000ULL,
0x0000000319197232ULL, 0x080fe40000000000ULL, 0x000000031b1b7232ULL, 0x000fce0000000000ULL,
0x0000001044407824ULL, 0x000fe200078e0210ULL, 0x000000004914783bULL, 0x002e6a0000004200ULL,
0x000000004040783bULL, 0x000f620000004200ULL, 0x00000010ff697819ULL, 0x002fe40000011614ULL,
0x00000010ff6a7819ULL, 0x000fe40000011615ULL, 0x000000ff15677812ULL, 0x000fc400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe40000011615ULL, 0x0000ffff15157812ULL, 0x000fe400078ec0ffULL,
0x000000ff426b7812ULL, 0x028fe400078ec0ffULL, 0x000000ff436c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff14667812ULL, 0x000fe400078ec0ffULL, 0x000000ff69697812ULL, 0x000fc400078ec0ffULL,
0x000000ff6a6a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff627819ULL, 0x100fe40000011640ULL,
0x000000ff40597812ULL, 0x040fe400078ec0ffULL, 0x00000018ff487819ULL, 0x000fe40000011640ULL,
0x0000ffff405e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff637819ULL, 0x000fc40000011641ULL,
0x000000ff41587812ULL, 0x040fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fe40000011641ULL,
0x0000ffff415a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff657819ULL, 0x000fe40000011614ULL,
0x0000ffff14687812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5b7819ULL, 0x000fc40000011642ULL,
0x00000018ff407819ULL, 0x000fe40000011642ULL, 0x0000ffff42457812ULL, 0x000fe400078ec0ffULL,
0x00000010ff577819ULL, 0x100fe40000011643ULL, 0x00000018ff417819ULL, 0x000fe40000011643ULL,
0x0000ffff43477812ULL, 0x000fe400078ec0ffULL, 0x00000010ff147819ULL, 0x000fc40000011616ULL,
0x0000006bff42723eULL, 0x000fe400020006ffULL, 0x0000006cff43723eULL, 0x000fe400020006ffULL,
0x00000008ff157819ULL, 0x000fe40000011615ULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000069ff6b723eULL, 0x000fc400020006ffULL,
0x0000006aff6c723eULL, 0x000fe400020006ffULL, 0x000000ff14697812ULL, 0x000fe400078ec0ffULL,
0x00000015ff6d723eULL, 0x000fe400020006ffULL, 0x000000ff16607812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe40000011616ULL, 0x0000ffff16617812ULL, 0x000fc400078ec0ffULL,
0x00000008ff687819ULL, 0x000fe40000011668ULL, 0x0000541066147816ULL, 0x000fe4000000006bULL,
0x0000541067157816ULL, 0x000fe4000000006cULL, 0x00000010ff167819ULL, 0x100fe40000011617ULL,
0x000000ff175f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fc40000011617ULL,
0x0000ffff17177812ULL, 0x000fe400078ec0ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x000000ff166a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6e7819ULL, 0x000fc40000011617ULL,
0x000000141814723cULL, 0x000fe20000001838ULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x0000541068387816ULL, 0x000fe40000000065ULL, 0x000054106d397816ULL, 0x000fe40000000064ULL,
0x0000006aff6a723eULL, 0x000fc400020006ffULL, 0x00000008ff617819ULL, 0x000fe40000011661ULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x00000038181c723cULL, 0x000fe2000000181cULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x0000006eff3a723eULL, 0x000fe400020006ffULL, 0x0000541060387816ULL, 0x000fc40000000069ULL,
0x000054105f397816ULL, 0x000fe4000000006aULL, 0x000000ff62627812ULL, 0x000fe400078ec0ffULL,
0x000000ff63637812ULL, 0x000fe400078ec0ffULL, 0x00000059ff59723eULL, 0x000fe200020006ffULL,
0x000000381820723cULL, 0x000fe20000001820ULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fc400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x0000541061387816ULL, 0x000fe4000000005dULL, 0x000054103a397816ULL, 0x000fe4000000005cULL,
0x00000008ff5e7819ULL, 0x000fe4000001165eULL, 0x00000008ff5a7819ULL, 0x000fe4000001165aULL,
0x00000048ff48723eULL, 0x000fe200020006ffULL, 0x000000381824723cULL, 0x000fe20000001824ULL,
0x00000046ff46723eULL, 0x000fc400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x0000541059387816ULL, 0x000fe40000000062ULL,
0x0000541058397816ULL, 0x000fe40000000063ULL, 0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff57577812ULL, 0x000fc400078ec0ffULL, 0x00000008ff457819ULL, 0x000fe20000011645ULL,
0x000000381828723cULL, 0x000fe20000001828ULL, 0x00000008ff477819ULL, 0x000fe40000011647ULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x000054105e387816ULL, 0x000fe20000000048ULL, 0x000000103e487824ULL, 0x000fe200078e0210ULL,
0x000054105a397816ULL, 0x000fc40000000046ULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x0000541042427816ULL, 0x000fe2000000005bULL,
0x00000038182c723cULL, 0x000fe2000000182cULL, 0x0000541043437816ULL, 0x000fe40000000057ULL,
0x0000541045407816ULL, 0x000fc80000000040ULL, 0x00000041ff38723eULL, 0x000fe200020006ffULL,
0x000000421830723cULL, 0x000fe20000001830ULL, 0x00000047ff41723eULL, 0x000fc800020006ffULL,
0x0000541041417816ULL, 0x000fce0000000038ULL, 0x000000401834723cULL, 0x000fe20000001834ULL,
0x011800003f18783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000518187232ULL, 0x08cfe40000000000ULL,
0x000000051a1a7232ULL, 0x000fe40000000000ULL, 0x0000000319197232ULL, 0x080fe40000000000ULL,
0x000000031b1b7232ULL, 0x000fce0000000000ULL, 0x000000103d407824ULL, 0x000fe200078e0210ULL,
0x000000004838783bULL, 0x000f6a0000004200ULL, 0x000000004040783bULL, 0x000f640000004200ULL,
0x00000010ff6b7819ULL, 0x022fe40000011638ULL, 0x000000ff38687812ULL, 0x000fc400078ec0ffULL,
0x00000018ff637819ULL, 0x000fe40000011638ULL, 0x0000ffff38697812ULL, 0x000fe400078ec0ffULL,
0x00000010ff387819ULL, 0x108fe40000011640ULL, 0x000000ff40477812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6c7819ULL, 0x000fe40000011640ULL, 0x0000ffff40587812ULL, 0x000fc400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011641ULL, 0x00000010ff6a7819ULL, 0x100fe40000011639ULL,
0x000000ff39677812ULL, 0x040fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe40000011639ULL,
0x0000ffff39667812ULL, 0x000fe400078ec0ffULL, 0x000000ff436d7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff5a7819ULL, 0x100fe4000001163aULL, 0x000000ff3a617812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fe4000001163aULL, 0x0000ffff3a607812ULL, 0x000fe400078ec0ffULL,
0x00000010ff397819ULL, 0x000fe40000011641ULL, 0x000000ff41467812ULL, 0x000fc400078ec0ffULL,
0x0000ffff415c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5d7819ULL, 0x100fe40000011642ULL,
0x000000ff42417812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3a7819ULL, 0x000fe40000011642ULL,
0x0000ffff42457812ULL, 0x000fe400078ec0ffULL, 0x00000040ff42723eULL, 0x000fc400020006ffULL,
0x0000006dff40723eULL, 0x000fe400020006ffULL, 0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff6a6d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x100fe4000001163bULL,
0x000000ff3b5f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff597819ULL, 0x000fc4000001163bULL,
0x0000ffff3b657812ULL, 0x000fe400078ec0ffULL, 0x00000008ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff5e7819ULL, 0x100fe40000011643ULL, 0x00000018ff3b7819ULL, 0x000fe40000011643ULL,
0x0000ffff43577812ULL, 0x000fe400078ec0ffULL, 0x0000006cff43723eULL, 0x000fc400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000008ff6a7819ULL, 0x000fe40000011669ULL, 0x0000006bff6c723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x00000066ff6b723eULL, 0x000fc400020006ffULL,
0x000000ff5a697812ULL, 0x000fe400078ec0ffULL, 0x000000ff64667812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5a7819ULL, 0x000fe40000011665ULL, 0x000000ff38657812ULL, 0x000fe400078ec0ffULL,
0x000000ff39647812ULL, 0x000fe400078ec0ffULL, 0x0000541068387816ULL, 0x000fc4000000006cULL,
0x0000541067397816ULL, 0x000fe4000000006dULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x000000381814723cULL, 0x000fe20000001814ULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fc400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x000054106a387816ULL, 0x000fe40000000063ULL, 0x000054106b397816ULL, 0x000fe40000000062ULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000008ff607819ULL, 0x000fe40000011660ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x00000038181c723cULL, 0x000fe2000000181cULL,
0x00000059ff59723eULL, 0x000fc400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x0000541061387816ULL, 0x000fe40000000069ULL,
0x000054105f397816ULL, 0x000fe40000000066ULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000046ff46723eULL, 0x000fc400020006ffULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x000000381820723cULL, 0x000fe20000001820ULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000008ff587819ULL, 0x000fe40000011658ULL, 0x00000008ff5c7819ULL, 0x000fe4000001165cULL,
0x0000541060387816ULL, 0x000fe4000000005bULL, 0x000054105a397816ULL, 0x000fe20000000059ULL,
0x0000000200597824ULL, 0x000fe200078e00ffULL, 0x000000ff5e627812ULL, 0x000fc400078ec0ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x0000005cff5e723eULL, 0x000fe200020006ffULL,
0x000000381824723cULL, 0x000fe20000001824ULL, 0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000541047387816ULL, 0x000fc40000000065ULL, 0x0000541046397816ULL, 0x000fe40000000064ULL,
0x00000062ff5c723eULL, 0x000fe400020006ffULL, 0x00000008ff457819ULL, 0x000fe40000011645ULL,
0x00000008ff577819ULL, 0x000fe20000011657ULL, 0x000000381828723cULL, 0x000fe20000001828ULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x0000003bff3b723eULL, 0x000fc400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x0000541058387816ULL, 0x000fe20000000043ULL,
0x00000001ff437424ULL, 0x000fe200078e00ffULL, 0x000054105e397816ULL, 0x000fe20000000042ULL,
0x0000000853427824ULL, 0x000fe200078e0202ULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0xfffffff859597812ULL, 0x000fe400078ec0ffULL, 0x00005410453a7816ULL, 0x000fe2000000003aULL,
0x00000038182c723cULL, 0x000fe2000000182cULL, 0x00005410573b7816ULL, 0x000fe2000000003bULL,
0x0000000102597824ULL, 0x000fca00078e0259ULL, 0x0000541041387816ULL, 0x000fe2000000005dULL,
0x0000003a1834723cULL, 0x000fe20000001834ULL, 0x0000541040397816ULL, 0x000fce000000005cULL,
0x000000381830723cULL, 0x000fe20000001830ULL, 0x0176c843423879a7ULL, 0x0002e2000850003fULL,
0x0176904359ff79a7ULL, 0x0003de000850003fULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x00000039090075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x0000001a183b7210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0e19ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1a7819ULL, 0x000fc8000001141bULL,
0x0000003b1a1a7211ULL, 0x000fca00078110ffULL, 0x000000ffff1b7224ULL, 0x000fca00000e061bULL,
0x000000021a1a7819ULL, 0x000fc8000000121bULL, 0x0000001a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x00000039090075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x00009000ff187b82ULL, 0x000ee20000000a00ULL, 0x00000010001a7824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe40000000800ULL, 0x0000000411117c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe01a1b7812ULL, 0x000fca00078ec0ffULL, 0x000001000a1b7824ULL, 0x000fc800078e021bULL,
0x000000c01b397836ULL, 0x000fe40000000000ULL, 0x00000040111b7824ULL, 0x000fc600078e00ffULL,
0x0000002039117812ULL, 0x000fe200078ec0ffULL, 0x000000801b187825ULL, 0x008fc800078e0018ULL,
0x000000014a117824ULL, 0x000fe200078e0211ULL, 0x0000000000f89947ULL, 0x000fec0003800000ULL,
0x0000080001407983ULL, 0x000ee20000100800ULL, 0x000000101a3b7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff1b7819ULL, 0x000fca0000011604ULL, 0x000000011b387824ULL, 0x000fe400078e023bULL,
0x000000041b3a7836ULL, 0x000fe20000000000ULL, 0x00000039401a7248ULL, 0x008fe20007fe0000ULL,
0x0000000838407824ULL, 0x000fc800078e00ffULL, 0x000000011a1a7824ULL, 0x000fe400078e0a39ULL,
0x0000000138397824ULL, 0x000fc600078e0204ULL, 0x0000001a3b1a7248ULL, 0x000fe40007fe0000ULL,
0xfffffff840457812ULL, 0x000fe200078ee239ULL, 0x000000081b397836ULL, 0x000fe40000000000ULL,
0x000000011a1a7824ULL, 0x100fe400078e0a3bULL, 0x0000000c1b407836ULL, 0x000fe40000000000ULL,
0x0000001045457824ULL, 0x000fe200078e0210ULL, 0x0000001a3a00720cULL, 0x0c0fe20003f66070ULL,
0x000000013a3a7824ULL, 0x000fe200078e023bULL, 0x0000001a1b00720cULL, 0x080fe20003f86070ULL,
0x00000001381b7824ULL, 0x000fe200078e0211ULL, 0x0000001a3900720cULL, 0x080fe20003f46070ULL,
0x000000013a387824ULL, 0x000fe200078e0204ULL, 0x0000001a4000720cULL, 0x000fe20003f06070ULL,
0x000000083a477824ULL, 0x000fc400078e00ffULL, 0x0000000139397824ULL, 0x000fe400078e023bULL,
0x000000801b1a7825ULL, 0x000fe200078e00ffULL, 0xfffffff847477812ULL, 0x000fc600078ee238ULL,
0x0000000140427824ULL, 0x002fe400078e023bULL, 0x000000013a407824ULL, 0x100fe400078e0211ULL,
0x0000000139387824ULL, 0x040fe400078e0211ULL, 0x00000001393b7824ULL, 0x040fe400078e0204ULL,
0x0000000839467824ULL, 0x000fe200078e00ffULL, 0x0000004d1a397212ULL, 0x000fe200078efcffULL,
0x0000008040407825ULL, 0x000fc600078e00ffULL, 0x00000039181a7210ULL, 0x000fe20007fbe0ffULL,
0x00000001423a7824ULL, 0x000fe200078e0211ULL, 0x0000004d40117212ULL, 0x000fe200078efcffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0xfffffff846577812ULL, 0x000fc600078ee23bULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000004d38437212ULL, 0x000fc600078efcffULL,
0x00000001191b7824ULL, 0x040fe200028e061bULL, 0x0000001118407210ULL, 0x000fe20007fbe0ffULL,
0x0000000142467824ULL, 0x000fe200078e0204ULL, 0x0000004d3a117212ULL, 0x000fe200078efcffULL,
0x0000000842597824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a457faeULL, 0x0003e2000e101c46ULL, 0x0000000119417824ULL, 0x000fe200028e0641ULL,
0x0000004318387210ULL, 0x000fe20007fbe0ffULL, 0x0000001047477824ULL, 0x100fe200078e0210ULL,
0x0000001118187210ULL, 0x000fe20007fde0ffULL, 0x0000001057577824ULL, 0x000fe200078e0210ULL,
0xfffffff859117812ULL, 0x000fe200078ee246ULL, 0x0000000119397824ULL, 0x040fe200028e0639ULL,
0x0000000040477faeULL, 0x0003e2000d901c46ULL, 0x0000000119197824ULL, 0x000fc400030e063bULL,
0x0000001011117824ULL, 0x000fe200078e0210ULL, 0x0000000038577faeULL, 0x0003e8000d101c46ULL,
0x0000000018117faeULL, 0x0003e2000c101c46ULL, 0x0000000000c07947ULL, 0x000fea0003800000ULL,
0x000000101a1b7812ULL, 0x000fc800078ec0ffULL, 0x0000001b041b7211ULL, 0x000fca00078fe8ffULL,
0x000000081b397836ULL, 0x000fe40000000000ULL, 0x000000041b407836ULL, 0x000fe40000000000ULL,
0x00000001393b7824ULL, 0x140fe400078e0204ULL, 0x0000000839427824ULL, 0x002fe400078e00ffULL,
0x000000011b1a7824ULL, 0x040fe400078e0204ULL, 0x000000081b477824ULL, 0x040fe200078e00ffULL,
0xfffffff842597812ULL, 0x000fe200078ee23bULL, 0x000000011b3a7824ULL, 0x000fc400078e0211ULL,
0x0000000140387824ULL, 0x040fe200078e0204ULL, 0xfffffff847477812ULL, 0x000fe200078ee21aULL,
0x0000000840577824ULL, 0x000fe400078e00ffULL, 0x0000000c1b1b7836ULL, 0x000fe40000000000ULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0xfffffff857577812ULL, 0x000fc600078ee238ULL,
0x0000000140407824ULL, 0x100fe400078e0211ULL, 0x00000001391a7824ULL, 0x100fe400078e0211ULL,
0x000000011b387824ULL, 0x040fe200078e0211ULL, 0x0000004d3a117212ULL, 0x000fe200078efcffULL,
0x000000011b427824ULL, 0x040fe400078e0204ULL, 0x000000081b5b7824ULL, 0x000fe200078e00ffULL,
0x00000011183a7210ULL, 0x000fe20007f1e0ffULL, 0x0000008040407825ULL, 0x000fc600078e00ffULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee242ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000004d40457212ULL, 0x000fc600078efcffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000004d1a437212ULL, 0x080fe400078efcffULL, 0x0000004518407210ULL, 0x000fe20007f5e0ffULL,
0x00000001193b7824ULL, 0x000fe200000e063bULL, 0x0000004d38117212ULL, 0x000fe200078efcffULL,
0x0000001047477824ULL, 0x100fe200078e0210ULL, 0x00000043181a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000119417824ULL, 0x000fe200010e0641ULL, 0x0000001118187210ULL, 0x000fe20007f7e0ffULL,
0x0000001057577824ULL, 0x000fe200078e0210ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a477faeULL, 0x0003e2000b901c46ULL, 0x00000001191b7824ULL, 0x000fc400000e061bULL,
0x0000001059597824ULL, 0x100fe200078e0210ULL, 0x0000000040577faeULL, 0x0003e2000b901c46ULL,
0x0000000119197824ULL, 0x000fe400018e0639ULL, 0x000000105b5b7824ULL, 0x000fe200078e0210ULL,
0x000000001a597faeULL, 0x0003e8000b901c46ULL, 0x00000000185b7faeULL, 0x0003e4000b901c46ULL,
0x00000c0001117983ULL, 0x002ee20000100800ULL, 0x000000030c1a7836ULL, 0x000fca0000000000ULL,
0x000000111a00720cULL, 0x008fe20003f06070ULL, 0xffffffffff117424ULL, 0x000fd800078e00ffULL,
0x00009200ff188b82ULL, 0x000e620000000a00ULL, 0x000000014b1b8824ULL, 0x000fe400078e021aULL,
0x00000008001a7824ULL, 0x000fe400078e00ffULL, 0x000000041b188825ULL, 0x002fc600078e0018ULL,
0xfffffff01a1b7812ULL, 0x000fe400078ec0ffULL, 0x0000000618118981ULL, 0x000326000c1e1900ULL,
0x00000001021b7824ULL, 0x000fe400078e021bULL, 0x00000001ff1a7424ULL, 0x000fc600078e00ffULL,
0x000000001b0472caULL, 0x000fe200000e0000ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000176b004047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x0176b01a1b1879a7ULL, 0x0002e4000850003fULL,
0x0176481a0d1a79a7ULL, 0x0022a4000850003fULL, 0x0000000000387805ULL, 0x000fce0000015200ULL,
0x0176481b0d0075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff407224ULL, 0x000fce00078e00ffULL, 0x000000104000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fce0000015200ULL,
0x0000003a38417210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09004100780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404100780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x000000413a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000140407836ULL, 0x000fce0000000000ULL, 0x0176481b0d0075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x00000020000d7824ULL, 0x002fe400078e00ffULL,
0x00000001ff3a7424ULL, 0x000fc600078e00ffULL, 0xffffff800d0d7812ULL, 0x000fc800078ec0ffULL,
0x00000100020d7810ULL, 0x000fc80007ffe00dULL, 0x0000000d521a7210ULL, 0x000fca0007ffe04dULL,
0x017000001a1b7984ULL, 0x000e680000000800ULL, 0x017200001a387984ULL, 0x0004a20000000800ULL,
0x0000000e1b00720bULL, 0x002fda0003f1d000ULL, 0x00000000000d7806ULL, 0x000fc800000e0100ULL,
0x0000ffff0d397812ULL, 0x000fe2000780c0ffULL, 0x000000ffff0d7224ULL, 0x000fd800078e000eULL,
0x0000000400008947ULL, 0x00cfea0003800000ULL, 0x00000002500d7836ULL, 0x000fe20000000000ULL,
0x0000000e1b00720bULL, 0x000fc80003f14000ULL, 0x000000000d00720cULL, 0x000fd20003f45270ULL,
0x00000000003a7806ULL, 0x000fc800000e0100ULL, 0x00000080001aa824ULL, 0x000fe200078e0202ULL,
0x0000000e1b0da209ULL, 0x000fc80007810000ULL, 0x0000001a5240a210ULL, 0x000fe40007ffe04dULL,
0x000099103a1a7816ULL, 0x000fc600000000ffULL, 0x0174000d4000a388ULL, 0x0003e20000000800ULL,
0x000000ff1a00720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000000e1b0d7209ULL, 0x000fe40007810000ULL, 0x000000ff3aff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff003aff7812ULL, 0x000fe2000784c0ffULL, 0x0000000e0d0d7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL, 0x0000000d001a7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x002fcc0000011604ULL,
0x00001f0d1a0d7589ULL, 0x004e6400000e0000ULL, 0x000000140d147220ULL, 0x042fe20000410000ULL,
0x000000150d157220ULL, 0x040fe20000410000ULL, 0x0000001c0d1c7220ULL, 0x040fe20000410000ULL,
0x0000001d0d1d7220ULL, 0x040fe20000410000ULL, 0x000000200d207220ULL, 0x040fe20000410000ULL,
0x000000210d217220ULL, 0x040fe20000410000ULL, 0x000000240d247220ULL, 0x040fe20000410000ULL,
0x000000250d257220ULL, 0x040fe20000410000ULL, 0x000000280d287220ULL, 0x040fe20000410000ULL,
0x000000290d297220ULL, 0x040fe20000410000ULL, 0x0000002c0d2c7220ULL, 0x040fe20000410000ULL,
0x0000002d0d2d7220ULL, 0x040fe20000410000ULL, 0x000000300d307220ULL, 0x040fe20000410000ULL,
0x000000310d317220ULL, 0x040fe20000410000ULL, 0x000000340d347220ULL, 0x040fe20000410000ULL,
0x000000350d357220ULL, 0x000fce0000410000ULL, 0x0000001a0f0f7220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x00000008040d7811ULL, 0x002fcc00078ff0ffULL,
0x00001f0d1a0d7589ULL, 0x000e6400000e0000ULL, 0x000000160d167220ULL, 0x042fe20000410000ULL,
0x000000170d177220ULL, 0x040fe20000410000ULL, 0x0000001e0d1e7220ULL, 0x040fe20000410000ULL,
0x0000001f0d1f7220ULL, 0x040fe20000410000ULL, 0x000000220d227220ULL, 0x040fe20000410000ULL,
0x000000230d237220ULL, 0x040fe20000410000ULL, 0x000000260d267220ULL, 0x040fe20000410000ULL,
0x000000270d277220ULL, 0x040fe20000410000ULL, 0x0000002a0d2a7220ULL, 0x040fe20000410000ULL,
0x0000002b0d2b7220ULL, 0x040fe20000410000ULL, 0x0000002e0d2e7220ULL, 0x040fe20000410000ULL,
0x0000002f0d2f7220ULL, 0x040fe20000410000ULL, 0x000000320d327220ULL, 0x040fe20000410000ULL,
0x000000330d337220ULL, 0x040fe20000410000ULL, 0x000000360d367220ULL, 0x040fe20000410000ULL,
0x000000370d377220ULL, 0x000fce0000410000ULL, 0x0000ffff39ff7812ULL, 0x000fe2000780603aULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000000e1b0d7209ULL, 0x002fd60007810000ULL,
0x8000000d1b1b0221ULL, 0x000fe20000010000ULL, 0x00007610ff3a0816ULL, 0x000fc6000000003aULL,
0x3fb8aa3b1b1b0820ULL, 0x000fc80000410000ULL, 0x0000001b00080308ULL, 0x000e640000000800ULL,
0x0000000838380220ULL, 0x002fce0000410000ULL, 0x0000000f380f7221ULL, 0x000fce0000010000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x00000008000e7824ULL, 0x000fca00078e00ffULL,
0xfffffff00e397812ULL, 0x000fca00078ec0ffULL, 0x0000000102417824ULL, 0x000fc800078e0239ULL,
0x0176a813410075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff407224ULL, 0x000fce00078e00ffULL, 0x000000104000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fce0000015200ULL,
0x000000381a3b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e1bULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc80000011439ULL, 0x0000003b0e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x000000020e0e7819ULL, 0x000fc80000001239ULL,
0x0000000e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000140407836ULL, 0x000fce0000000000ULL, 0x0176a813410075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000099103a0e7816ULL, 0x000fe200000000ffULL,
0x0001300007077836ULL, 0x000fc60000000000ULL, 0x000000ff0e00720cULL, 0x000fe20003f05270ULL,
0x0000001006407824ULL, 0x000fd800078e0207ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff057819ULL, 0x000fe40000011604ULL, 0x00000008ff03723eULL, 0x000fc600000000ffULL,
0x0000000805137836ULL, 0x000fe20000000000ULL, 0x0000541003067816ULL, 0x000fca0000000003ULL,
0x00001f0506057589ULL, 0x0002a800000e0000ULL, 0x00001f1306037589ULL, 0x0002e400000e0000ULL,
0x012000003c38783bULL, 0x0002e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000538387232ULL, 0x08cfe40000000000ULL, 0x000000053a3a7232ULL, 0x000fe40000000000ULL,
0x0000000339397232ULL, 0x080fe40000000000ULL, 0x000000033b3b7232ULL, 0x000fce0000000000ULL,
0x0000001044447824ULL, 0x000fe200078e0207ULL, 0x000000004040783bULL, 0x000f6a0000004200ULL,
0x000000004444783bULL, 0x000f640000004200ULL, 0x00000010ff657819ULL, 0x022fe40000011640ULL,
0x00000010ff667819ULL, 0x000fc40000011641ULL, 0x0000ffff41607812ULL, 0x040fe400078ec0ffULL,
0x0000ffff42617812ULL, 0x000fe400078ec0ffULL, 0x0000ffff40067812ULL, 0x040fe400078ec0ffULL,
0x00000010ff137819ULL, 0x000fe40000011642ULL, 0x000000ff40647812ULL, 0x000fe400078ec0ffULL,
0x000000ff41637812ULL, 0x000fc400078ec0ffULL, 0x00000018ff677819ULL, 0x008fe40000011646ULL,
0x000000ff65657812ULL, 0x000fe400078ec0ffULL, 0x000000ff66687812ULL, 0x000fe400078ec0ffULL,
0x00000008ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff627819ULL, 0x000fe40000011643ULL,
0x00000008ff697819ULL, 0x000fc40000011661ULL, 0x0000ffff43127812ULL, 0x000fe400078ec0ffULL,
0x00000008ff667819ULL, 0x000fe40000011606ULL, 0x000000ff13137812ULL, 0x000fe400078ec0ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000067ff06723eULL, 0x000fc400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000060ff67723eULL, 0x000fe400020006ffULL,
0x000000ff626a7812ULL, 0x000fe400078ec0ffULL, 0x00000069ff60723eULL, 0x000fe400020006ffULL,
0x00000013ff62723eULL, 0x000fc400020006ffULL, 0x00000008ff697819ULL, 0x000fe40000011612ULL,
0x00000018ff5e7819ULL, 0x000fe40000011640ULL, 0x00000018ff5f7819ULL, 0x000fe40000011641ULL,
0x0000541064127816ULL, 0x000fe40000000065ULL, 0x0000541063137816ULL, 0x000fe40000000068ULL,
0x0000005eff5e723eULL, 0x000fc400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x000000123814723cULL, 0x000fe20000001814ULL,
0x000000ff425b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff435a7812ULL, 0x000fe400078ec0ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x0000541066127816ULL, 0x000fc4000000005eULL,
0x0000541067137816ULL, 0x000fe4000000005fULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000006aff61723eULL, 0x000fe400020006ffULL, 0x00000018ff587819ULL, 0x000fe20000011642ULL,
0x00000012381c723cULL, 0x000fe2000000181cULL, 0x00000018ff577819ULL, 0x000fe40000011643ULL,
0x00000010ff5c7819ULL, 0x000fc40000011644ULL, 0x00000010ff5d7819ULL, 0x000fe40000011645ULL,
0x000054105b127816ULL, 0x000fe40000000062ULL, 0x000054105a137816ULL, 0x000fe40000000061ULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x000000123820723cULL, 0x000fe20000001820ULL,
0x000000ff44437812ULL, 0x000fc400078ec0ffULL, 0x000000ff45427812ULL, 0x000fe400078ec0ffULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL,
0x0000541060127816ULL, 0x000fe40000000058ULL, 0x0000541069137816ULL, 0x000fe40000000057ULL,
0x00000018ff3c7819ULL, 0x000fc40000011644ULL, 0x0000ffff44597812ULL, 0x000fe400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe20000011645ULL, 0x000000123824723cULL, 0x000fe20000001824ULL,
0x0000ffff45457812ULL, 0x000fe400078ec0ffULL, 0x00000010ff447819ULL, 0x000fe40000011646ULL,
0x000000ff461a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff417819ULL, 0x000fc40000011647ULL,
0x000000ff471b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff0e7819ULL, 0x000fe40000011647ULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fc400020006ffULL,
0x0000ffff46467812ULL, 0x000fe400078ec0ffULL, 0x0000ffff47477812ULL, 0x000fe400078ec0ffULL,
0x00000008ff597819ULL, 0x000fe40000011659ULL, 0x00000008ff457819ULL, 0x000fe40000011645ULL,
0x000000ff44447812ULL, 0x000fe400078ec0ffULL, 0x000000ff41417812ULL, 0x000fc400078ec0ffULL,
0x0000541043127816ULL, 0x000fe4000000005cULL, 0x0000541042137816ULL, 0x000fe4000000005dULL,
0x00000008ff467819ULL, 0x000fe40000011646ULL, 0x00000008ff477819ULL, 0x000fe40000011647ULL,
0x0000003cff3c723eULL, 0x000fe200020006ffULL, 0x000000123828723cULL, 0x000fe20000001828ULL,
0x00000040ff40723eULL, 0x000fc400020006ffULL, 0x0000001aff1a723eULL, 0x000fe400020006ffULL,
0x0000001bff1b723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fc400020006ffULL, 0x0000000eff0e723eULL, 0x000fe400020006ffULL,
0x00000046ff46723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x0000541059127816ULL, 0x000fe4000000003cULL, 0x0000541045137816ULL, 0x000fe20000000040ULL,
0x000000103e407824ULL, 0x000fe200078e0207ULL, 0x000054101a1a7816ULL, 0x000fc40000000044ULL,
0x000054101b1b7816ULL, 0x000fe40000000041ULL, 0x0000541046467816ULL, 0x000fe20000000006ULL,
0x00000012382c723cULL, 0x000fe2000000182cULL, 0x0000541047477816ULL, 0x000fca000000000eULL,
0x0000001a3830723cULL, 0x000fec0000001830ULL, 0x000000463838723cULL, 0x000fe20000001834ULL,
0x012000003f34783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000534347232ULL, 0x08cfe40000000000ULL,
0x0000000536367232ULL, 0x000fe40000000000ULL, 0x0000000335357232ULL, 0x080fe40000000000ULL,
0x0000000337377232ULL, 0x000fce0000000000ULL, 0x000000103d3d7824ULL, 0x000fe200078e0207ULL,
0x000000004040783bULL, 0x000f6a0000004200ULL, 0x000000003d3c783bULL, 0x002e620000004200ULL,
0x00000010ff647819ULL, 0x020fe40000011640ULL, 0x00000010ff637819ULL, 0x000fe40000011641ULL,
0x00000018ff067819ULL, 0x000fc40000011642ULL, 0x000000ff3d1b7812ULL, 0x002fe400078ec0ffULL,
0x00000010ff5a7819ULL, 0x000fe40000011642ULL, 0x000000ff3e667812ULL, 0x000fe400078ec0ffULL,
0x00000018ff657819ULL, 0x000fe4000001163eULL, 0x000000ff415f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff597819ULL, 0x000fc40000011641ULL, 0x0000ffff41627812ULL, 0x000fe400078ec0ffULL,
0x000000ff42577812ULL, 0x040fe400078ec0ffULL, 0x0000ffff425d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5c7819ULL, 0x000fe40000011643ULL, 0x0000ffff435e7812ULL, 0x040fe400078ec0ffULL,
0x000000ff43477812ULL, 0x000fc400078ec0ffULL, 0x00000018ff427819ULL, 0x000fe40000011643ULL,
0x00000010ff467819ULL, 0x100fe4000001163fULL, 0x000000ff3f687812ULL, 0x040fe400078ec0ffULL,
0x00000018ff677819ULL, 0x000fe4000001163fULL, 0x0000ffff3f417812ULL, 0x000fe400078ec0ffULL,
0x000000ff40607812ULL, 0x000fc400078ec0ffULL, 0x00000006ff43723eULL, 0x000fe400020006ffULL,
0x0000001bff3f723eULL, 0x000fe400020006ffULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x000000ff63637812ULL, 0x000fe400078ec0ffULL, 0x00000066ff1b723eULL, 0x000fe400020006ffULL,
0x00000065ff06723eULL, 0x000fc400020006ffULL, 0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5c657812ULL, 0x000fe400078ec0ffULL, 0x00000008ff667819ULL, 0x000fe4000001165eULL,
0x00000010ff127819ULL, 0x000fe4000001163cULL, 0x00000010ff137819ULL, 0x000fe4000001163dULL,
0x0000ffff40617812ULL, 0x000fc400078ec0ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000008ff5c7819ULL, 0x000fe4000001165dULL,
0x0000005aff5d723eULL, 0x000fc400020006ffULL, 0x00000065ff5e723eULL, 0x000fe400020006ffULL,
0x00000066ff5a723eULL, 0x000fe400020006ffULL, 0x000000ff12657812ULL, 0x000fe400078ec0ffULL,
0x000000ff13667812ULL, 0x000fe400078ec0ffULL, 0x00000018ff587819ULL, 0x000fe40000011640ULL,
0x00000008ff617819ULL, 0x000fc40000011661ULL, 0x00000008ff627819ULL, 0x000fe40000011662ULL,
0x0000541060127816ULL, 0x000fe40000000064ULL, 0x000054105f137816ULL, 0x000fe40000000063ULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x000000123414723cULL, 0x008fe20000001814ULL,
0x00000062ff62723eULL, 0x000fc400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x0000541061127816ULL, 0x000fe40000000058ULL,
0x0000541062137816ULL, 0x000fe40000000059ULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x0000ffff3c5b7812ULL, 0x040fe200078ec0ffULL,
0x00000012341c723cULL, 0x000fe2000000181cULL, 0x0000ffff3d447812ULL, 0x000fe400078ec0ffULL,
0x000000ff3c407812ULL, 0x000fe400078ec0ffULL, 0x00000018ff0e7819ULL, 0x000fe4000001163cULL,
0x0000541057127816ULL, 0x000fe4000000005dULL, 0x0000541047137816ULL, 0x000fc4000000005eULL,
0x00000018ff1a7819ULL, 0x000fe4000001163dULL, 0x00000008ff5b7819ULL, 0x000fe4000001165bULL,
0x00000008ff447819ULL, 0x000fe20000011644ULL, 0x000000123420723cULL, 0x000fe20000001820ULL,
0x00000010ff457819ULL, 0x000fe4000001163eULL, 0x0000ffff3e3e7812ULL, 0x000fe400078ec0ffULL,
0x00000040ff40723eULL, 0x000fc400020006ffULL, 0x000054105c127816ULL, 0x000fe40000000043ULL,
0x000054105a137816ULL, 0x000fe40000000042ULL, 0x0000000eff3c723eULL, 0x000fe400020006ffULL,
0x0000001aff3d723eULL, 0x000fe400020006ffULL, 0x00000065ff5f723eULL, 0x000fe200020006ffULL,
0x000000123424723cULL, 0x000fe20000001824ULL, 0x00000066ff60723eULL, 0x000fc400020006ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x0000000200137824ULL, 0x000fe200078e00ffULL, 0x00000008ff127819ULL, 0x000fe4000001163eULL,
0x00005410403e7816ULL, 0x000fe2000000005fULL, 0x00000001ff407424ULL, 0x000fe200078e00ffULL,
0x000054103f3f7816ULL, 0x000fe40000000060ULL, 0x000054105b3c7816ULL, 0x000fc4000000003cULL,
0x00005410443d7816ULL, 0x000fe4000000003dULL, 0x000000ff45457812ULL, 0x000fe200078ec0ffULL,
0x0000003e3428723cULL, 0x000fe20000001828ULL, 0x000000ff46467812ULL, 0x000fe400078ec0ffULL,
0xfffffff813137812ULL, 0x000fe400078ec0ffULL, 0x00000068ff1a723eULL, 0x000fe200020006ffULL,
0x0000003c342c723cULL, 0x000fe2000000182cULL, 0x00000045ff45723eULL, 0x000fc400020006ffULL,
0x00000046ff46723eULL, 0x000fe400020006ffULL, 0x00000008ff417819ULL, 0x000fe40000011641ULL,
0x00000012ff3e723eULL, 0x000fe200020006ffULL, 0x00000001023d7824ULL, 0x000fe200078e0213ULL,
0x00000067ff0e723eULL, 0x000fe200020006ffULL, 0x00000008533c7824ULL, 0x000fe200078e0202ULL,
0x00000041ff3f723eULL, 0x000fe400020006ffULL, 0x000054101b127816ULL, 0x000fc40000000045ULL,
0x000054101a137816ULL, 0x000fe40000000046ULL, 0x000054103e3e7816ULL, 0x000fe40000000006ULL,
0x000054103f3f7816ULL, 0x000fc6000000000eULL, 0x000000123430723cULL, 0x000fe20000001830ULL,
0x0176c8403c1279a7ULL, 0x0002ea000850003fULL, 0x0000003e3434723cULL, 0x000fe20000001838ULL,
0x017698403dff79a7ULL, 0x0003de000850003fULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x00000013090075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff0e7224ULL, 0x000fce00078e00ffULL,
0x000000100e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fce0000015200ULL, 0x000000381a3b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e1bULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011439ULL,
0x0000003b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000206067819ULL, 0x000fc80000001239ULL, 0x000000060000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010e0e7836ULL, 0x000fce0000000000ULL,
0x00000013090075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x0000100001387983ULL, 0x000ee20000100800ULL, 0x000000010a397836ULL, 0x000fe40000000000ULL,
0x000000030c0c7836ULL, 0x000fc60000000000ULL, 0x000000383900720cULL, 0x008fda0003f06070ULL,
0x0000000800100947ULL, 0x000fea0003800000ULL, 0x00009000ff127b82ULL, 0x000ee20000000a00ULL,
0x000000020a0c7836ULL, 0x000fe20000000000ULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x0000010039397824ULL, 0x000fe400078e0256ULL, 0x0000000411067c24ULL, 0x010fe2000f8e02ffULL,
0x000000380c00720cULL, 0x000fe40003f06070ULL, 0x0000002039117812ULL, 0x000fe200078ec0ffULL,
0x00000040061b7824ULL, 0x000fc800078e00ffULL, 0x000000014a117824ULL, 0x000fe400078e0211ULL,
0x000000801b127825ULL, 0x008fc800078e0012ULL, 0x0000000000fc8947ULL, 0x000fea0003800000ULL,
0x0000080001387983ULL, 0x000ee20000100800ULL, 0x00000010000c7824ULL, 0x000fca00078e00ffULL,
0x000000100c1b7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff0c7819ULL, 0x000fca0000011604ULL,
0x000000040c0e7836ULL, 0x000fe40000000000ULL, 0x000000080c1a7836ULL, 0x000fe20000000000ULL,
0x0000003938067248ULL, 0x008fe20007fe0000ULL, 0x0000000c0c387836ULL, 0x000fc80000000000ULL,
0x0000000106067824ULL, 0x000fe400078e0a39ULL, 0x00000001383e7824ULL, 0x000fc600078e021bULL,
0x000000061b067248ULL, 0x000fe20007fe0000ULL, 0x000000013e3f7824ULL, 0x000fc800078e0204ULL,
0x0000000106067824ULL, 0x000fca00078e0a1bULL, 0x000000060c00720cULL, 0x0c0fe20003f86070ULL,
0x000000010c0c7824ULL, 0x100fe200078e021bULL, 0x000000060e00720cULL, 0x0c0fe20003f66070ULL,
0x000000010e0e7824ULL, 0x100fe200078e021bULL, 0x000000061a00720cULL, 0x080fe20003f46070ULL,
0x000000080c397824ULL, 0x000fe200078e00ffULL, 0x000000063800720cULL, 0x000fe20003f06070ULL,
0x000000010c067824ULL, 0x100fe400078e0204ULL, 0x000000011a1a7824ULL, 0x000fe400078e021bULL,
0x000000010c387824ULL, 0x000fe200078e0211ULL, 0xfffffff839067812ULL, 0x000fe200078ee206ULL,
0x000000010e0c7824ULL, 0x000fc400078e0204ULL, 0x000000080e3b7824ULL, 0x000fe400078e00ffULL,
0x000000011a1b7824ULL, 0x040fe400078e0204ULL, 0x000000081a3c7824ULL, 0x002fe200078e00ffULL,
0xfffffff83b0c7812ULL, 0x000fe200078ee20cULL, 0x000000010e3a7824ULL, 0x000fe400078e0211ULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0xfffffff83c0e7812ULL, 0x000fc600078ee21bULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000004d383d7212ULL, 0x000fc600078efcffULL,
0x000000011a1a7824ULL, 0x100fe200078e0211ULL, 0x0000003d12387210ULL, 0x000fe20007fbe0ffULL,
0x000000013e3c7824ULL, 0x000fe200078e0211ULL, 0x0000004d3a117212ULL, 0x080fe200078efcffULL,
0x000000083e3e7824ULL, 0x000fe400078e00ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x00000011123a7210ULL, 0x000fe40007fde0ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee23fULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000004d1a3f7212ULL, 0x000fc600078efcffULL,
0x0000000113397824ULL, 0x040fe200028e0639ULL, 0x0000004d3c117212ULL, 0x000fe200078efcffULL,
0x0000001006417824ULL, 0x000fe200078e0207ULL, 0x0000003f12067210ULL, 0x000fe20007fbe0ffULL,
0x00000001133b7824ULL, 0x040fe200030e063bULL, 0x0000001112127210ULL, 0x000fe20007fde0ffULL,
0x000000100c437824ULL, 0x100fe200078e0207ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038417faeULL, 0x0003e2000e101c46ULL, 0x000000100e117824ULL, 0x100fe400078e0207ULL,
0x000000103e3f7824ULL, 0x000fe200078e0207ULL, 0x000000003a437faeULL, 0x0003e2000d901c46ULL,
0x0000000113077824ULL, 0x000fc400028e061bULL, 0x0000000113137824ULL, 0x000fc600030e063dULL,
0x0000000006117faeULL, 0x0003e8000d101c46ULL, 0x00000000123f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001000067824ULL, 0x000fca00078e00ffULL,
0x00000010061b7812ULL, 0x000fc800078ec0ffULL, 0x0000001b041b7211ULL, 0x000fca00078fe8ffULL,
0x000000011b067824ULL, 0x040fe400078e0204ULL, 0x000000081b397824ULL, 0x040fe400078e00ffULL,
0x000000041b0c7836ULL, 0x000fe40000000000ULL, 0x000000011b1a7824ULL, 0x000fe200078e0211ULL,
0xfffffff839067812ULL, 0x000fe200078ee206ULL, 0x000000081b397836ULL, 0x000fe40000000000ULL,
0x0000000c1b3b7836ULL, 0x000fc40000000000ULL, 0x000000010c387824ULL, 0x140fe400078e0211ULL,
0x000000010c0e7824ULL, 0x140fe400078e0204ULL, 0x000000080c3d7824ULL, 0x002fe400078e00ffULL,
0x00000001393a7824ULL, 0x040fe400078e0211ULL, 0x00000001390c7824ULL, 0x040fe200078e0204ULL,
0xfffffff83d0e7812ULL, 0x000fe200078ee20eULL, 0x00000008393f7824ULL, 0x000fc400078e00ffULL,
0x000000801a1a7825ULL, 0x000fc600078e00ffULL, 0xfffffff83f0c7812ULL, 0x000fe200078ee20cULL,
0x000000013b397824ULL, 0x040fe400078e0204ULL, 0x000000083b3e7824ULL, 0x040fe400078e00ffULL,
0x000000013b3c7824ULL, 0x000fe200078e0211ULL, 0x0000004d1a117212ULL, 0x080fe200078efcffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe400078ee239ULL,
0x00000011121a7210ULL, 0x000fe20007f1e0ffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000004d3a3f7212ULL, 0x000fc600078efcffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000004d38417212ULL, 0x080fe400078efcffULL, 0x0000003f12387210ULL, 0x000fe20007f5e0ffULL,
0x00000001131b7824ULL, 0x000fe200000e061bULL, 0x0000004d3c117212ULL, 0x000fe200078efcffULL,
0x0000001006437824ULL, 0x100fe200078e0207ULL, 0x0000004112067210ULL, 0x000fe20007f1e0ffULL,
0x000000100e457824ULL, 0x100fe200078e0207ULL, 0x0000001112127210ULL, 0x000fe20007f7e0ffULL,
0x000000100c477824ULL, 0x100fe200078e0207ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a437faeULL, 0x0003e2000b901c46ULL, 0x000000103e117824ULL, 0x000fc400078e0207ULL,
0x0000000113077824ULL, 0x040fe400000e0639ULL, 0x0000000113397824ULL, 0x040fe400010e063bULL,
0x0000000113137824ULL, 0x000fe200018e063dULL, 0x0000000006457faeULL, 0x0003e8000b901c46ULL,
0x0000000038477faeULL, 0x0003e8000b901c46ULL, 0x0000000012117faeULL, 0x0003e4000b901c46ULL,
0x00000c0001067983ULL, 0x002ee20000100800ULL, 0x000000044f0c7836ULL, 0x000fe40000000000ULL,
0xffffffffff117424ULL, 0x000fc600078e00ffULL, 0x000000060c00720cULL, 0x008fda0003f06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00009200ff067b82ULL, 0x000e620000000a00ULL,
0x000000014b117824ULL, 0x000fc800078e020cULL, 0x0000000411067825ULL, 0x002fca00078e0006ULL,
0x0000000606117981ULL, 0x000324000c1e1900ULL, 0x0000000800067824ULL, 0x002fe400078e00ffULL,
0x00000001ff387424ULL, 0x000fc600078e00ffULL, 0xfffffff006077812ULL, 0x000fca00078ec0ffULL,
0x0000000102077824ULL, 0x000fca00078e0207ULL, 0x00000000070472caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000176a804047890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0176a838070679a7ULL, 0x0002e4000850003fULL, 0x017668380b3879a7ULL, 0x0022a4000850003fULL,
0x000000ffff067224ULL, 0x00afce00078e0007ULL, 0x0000000000127805ULL, 0x000fce0000015200ULL,
0x017668390b0075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fce0000015200ULL,
0x0000001a120e7210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1a7824ULL, 0x000fe200000e0e13ULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1a00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1a00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc8000001141aULL, 0x0000000e07077211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e061aULL, 0x0000000207077819ULL, 0x000fc8000000120eULL,
0x000000070000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x017668390b0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000080500e7824ULL, 0x000fe400078e0202ULL,
0x00000001ff387424ULL, 0x000fc600078e00ffULL, 0x000001804d077810ULL, 0x000fca0007ffe00eULL,
0x00000001520e7824ULL, 0x000fca00078e0207ULL, 0x017000000e127984ULL, 0x000e680000000800ULL,
0x017200000e137984ULL, 0x0004a20000000800ULL, 0x0000000d1200720bULL, 0x002fda0003f1d000ULL,
0x0000000000077806ULL, 0x000fc800000e0100ULL, 0x0000ffff071a7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff077224ULL, 0x000fd800078e000dULL, 0x0000000400008947ULL, 0x004fea0003800000ULL,
0x0000000350077836ULL, 0x000fe20000000000ULL, 0x0000000d1200720bULL, 0x000fc80003f14000ULL,
0x000000000700720cULL, 0x000fd20003f45270ULL, 0x00000000001b7806ULL, 0x000fc800000e0100ULL,
0x00000080000ea824ULL, 0x000fe200078e0202ULL, 0x0000000d1207a209ULL, 0x000fc80007810000ULL,
0x0000000e5252a210ULL, 0x000fe40007ffe04dULL, 0x000099101b0e7816ULL, 0x000fc600000000ffULL,
0x017400075200a388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000000d120e7209ULL, 0x000fe40007810000ULL,
0x000000ff1bff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff001bff7812ULL, 0x000fe2000784c0ffULL,
0x0000000d0e077221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b07077820ULL, 0x000fc80000410000ULL,
0x00000007000e7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff077819ULL, 0x002fcc0000011604ULL, 0x00001f070e077589ULL, 0x004e6400000e0000ULL,
0x0000001407147220ULL, 0x042fe20000410000ULL, 0x0000001507157220ULL, 0x040fe20000410000ULL,
0x0000001c071c7220ULL, 0x040fe20000410000ULL, 0x0000001d071d7220ULL, 0x040fe20000410000ULL,
0x0000002007207220ULL, 0x040fe20000410000ULL, 0x0000002107217220ULL, 0x040fe20000410000ULL,
0x0000002407247220ULL, 0x040fe20000410000ULL, 0x0000002507257220ULL, 0x040fe20000410000ULL,
0x0000002807287220ULL, 0x040fe20000410000ULL, 0x0000002907297220ULL, 0x040fe20000410000ULL,
0x0000002c072c7220ULL, 0x040fe20000410000ULL, 0x0000002d072d7220ULL, 0x040fe20000410000ULL,
0x0000003007307220ULL, 0x040fe20000410000ULL, 0x0000003107317220ULL, 0x040fe20000410000ULL,
0x0000003407347220ULL, 0x040fe20000410000ULL, 0x0000003507357220ULL, 0x000fce0000410000ULL,
0x0000000e0f0f7220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x0000000804077811ULL, 0x002fcc00078ff0ffULL, 0x00001f070e077589ULL, 0x000e6400000e0000ULL,
0x0000001607167220ULL, 0x042fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000002607267220ULL, 0x040fe20000410000ULL, 0x0000002707277220ULL, 0x040fe20000410000ULL,
0x0000002a072a7220ULL, 0x040fe20000410000ULL, 0x0000002b072b7220ULL, 0x040fe20000410000ULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0x0000002f072f7220ULL, 0x040fe20000410000ULL,
0x0000003207327220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x040fe20000410000ULL,
0x0000003607367220ULL, 0x040fe20000410000ULL, 0x0000003707377220ULL, 0x000fce0000410000ULL,
0x0000ffff1aff7812ULL, 0x000fe2000780601bULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x0000000d12077209ULL, 0x002fd60007810000ULL, 0x8000000712120221ULL, 0x000fe20000010000ULL,
0x00007610ff380816ULL, 0x000fc60000000038ULL, 0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL,
0x0000001200080308ULL, 0x000e640000000800ULL, 0x0000000813130220ULL, 0x002fce0000410000ULL,
0x0000000f130f7221ULL, 0x000fce0000010000ULL, 0x0000000000127805ULL, 0x000fce0000015200ULL,
0x00000008000d7824ULL, 0x000fca00078e00ffULL, 0xfffffff00d0d7812ULL, 0x000fca00078ec0ffULL,
0x0000000102397824ULL, 0x000fc800078e020dULL, 0x0176b019390075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x0000001a120e7210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1a7824ULL, 0x000fe200000e0e13ULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1a00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1a00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc8000001141aULL,
0x0000000e0d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e061aULL,
0x000000020d0d7819ULL, 0x000fc8000000120eULL, 0x0000000d0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x0176b019390075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009910380d7816ULL, 0x000fe200000000ffULL, 0x00000004000e7824ULL, 0x000fe200078e00ffULL,
0x0000000804197812ULL, 0x000fe400078ec0ffULL, 0x000000ff0d00720cULL, 0x000fe20003f05270ULL,
0x00000800500d7824ULL, 0x000fe200078e0202ULL, 0x000000040e0e7812ULL, 0x000fc600078ec0ffULL,
0x000000104e187824ULL, 0x000fe200078e020dULL, 0x000000020e137812ULL, 0x000fe400078efcffULL,
0x00000007190d7812ULL, 0x000fe400078ef804ULL, 0x00000013040e7211ULL, 0x000fc600078fe0ffULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff057819ULL, 0x000fe40000011604ULL,
0x00000008ff03723eULL, 0x000fc600000000ffULL, 0x0000000805137836ULL, 0x000fe20000000000ULL,
0x0000541003127816ULL, 0x000fca0000000003ULL, 0x00001f0512057589ULL, 0x0002a800000e0000ULL,
0x00001f1312037589ULL, 0x0002e400000e0000ULL, 0x012800001818783bULL, 0x000e620000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000518187232ULL, 0x086fe40000000000ULL,
0x000000051a1a7232ULL, 0x000fe40000000000ULL, 0x0000000319197232ULL, 0x088fe40000000000ULL,
0x000000031b1b7232ULL, 0x000fce0000000000ULL, 0x000000080d137824ULL, 0x042fe200078e00ffULL,
0x000000004938783bULL, 0x000e620000004200ULL, 0x000000010d127824ULL, 0x000fe200078e020eULL,
0x0000000704417812ULL, 0x000fe200078ec0ffULL, 0x000000024c4c7836ULL, 0x000fc60000000000ULL,
0xfffffff813137812ULL, 0x000fe400078ee212ULL, 0x0000000841417812ULL, 0x000fc600078ef804ULL,
0x0000001013137824ULL, 0x000fe400078e0210ULL, 0x0000000841437824ULL, 0x000fe400078e00ffULL,
0x0000000350417836ULL, 0x000fe20000000000ULL, 0x00000000133c783bULL, 0x000f640000004200ULL,
0xfffffff843447812ULL, 0x000fe200078ee24cULL, 0x0000080041417824ULL, 0x000fc800078e0202ULL,
0x0000001044447824ULL, 0x000fe200078e0241ULL, 0x00000010ff5d7819ULL, 0x002fe40000011638ULL,
0x00000010ff5e7819ULL, 0x100fe40000011639ULL, 0x000000ff39597812ULL, 0x040fe400078ec0ffULL,
0x00000018ff527819ULL, 0x000fe40000011639ULL, 0x0000ffff395c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff38587812ULL, 0x000fc400078ec0ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011638ULL,
0x0000ffff38617812ULL, 0x000fe400078ec0ffULL, 0x000000ff3e5f7812ULL, 0x028fe400078ec0ffULL,
0x00000010ff127819ULL, 0x100fe4000001163cULL, 0x000000ff3c477812ULL, 0x000fe400078ec0ffULL,
0x00000018ff427819ULL, 0x000fc4000001163cULL, 0x0000ffff3c397812ULL, 0x000fe400078ec0ffULL,
0x00000010ff387819ULL, 0x100fe4000001163eULL, 0x00000018ff3c7819ULL, 0x000fe4000001163eULL,
0x0000ffff3e407812ULL, 0x000fe400078ec0ffULL, 0x0000005fff3e723eULL, 0x000fe400020006ffULL,
0x000000ff5d5d7812ULL, 0x000fc400078ec0ffULL, 0x000000ff5e5f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5b7819ULL, 0x100fe4000001163aULL, 0x000000ff3a4e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff497819ULL, 0x000fe4000001163aULL, 0x0000ffff3a577812ULL, 0x000fe400078ec0ffULL,
0x000000ff3f607812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5a7819ULL, 0x100fe4000001163bULL,
0x000000ff3b4d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3a7819ULL, 0x000fe4000001163bULL,
0x0000ffff3b137812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4c7819ULL, 0x000fe4000001163dULL,
0x000000ff3d467812ULL, 0x000fc400078ec0ffULL, 0x00000018ff437819ULL, 0x000fe4000001163dULL,
0x0000ffff3d3b7812ULL, 0x000fe400078ec0ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fc400020006ffULL, 0x00000010ff457819ULL, 0x100fe4000001163fULL,
0x00000018ff3d7819ULL, 0x000fe4000001163fULL, 0x0000ffff3f417812ULL, 0x000fe400078ec0ffULL,
0x00000060ff3f723eULL, 0x000fe400020006ffULL, 0x00000008ff5e7819ULL, 0x000fe40000011661ULL,
0x00000008ff607819ULL, 0x000fc40000011613ULL, 0x000000ff12617812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5c7819ULL, 0x000fe4000001165cULL, 0x0000541058127816ULL, 0x000fe4000000005dULL,
0x0000541059137816ULL, 0x000fe4000000005fULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x00000052ff52723eULL, 0x000fc400020006ffULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x000000121814723cULL, 0x000fe20000001814ULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL,
0x000054105e127816ULL, 0x000fe4000000004fULL, 0x000054105c137816ULL, 0x000fc40000000052ULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x00000012181c723cULL, 0x000fe2000000181cULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000008ff577819ULL, 0x000fe40000011657ULL,
0x00000049ff49723eULL, 0x000fc400020006ffULL, 0x000054104e127816ULL, 0x000fe4000000005bULL,
0x000054104d137816ULL, 0x000fe4000000005aULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x000000121820723cULL, 0x000fe20000001820ULL, 0x000000ff4c4c7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff397819ULL, 0x000fe40000011639ULL, 0x00000008ff3b7819ULL, 0x000fe4000001163bULL,
0x000000ff38387812ULL, 0x000fe400078ec0ffULL, 0x0000541057127816ULL, 0x000fe40000000049ULL,
0x0000541060137816ULL, 0x000fe4000000003aULL, 0x000000ff45457812ULL, 0x000fc400078ec0ffULL,
0x00000008ff407819ULL, 0x000fe40000011640ULL, 0x00000008ff417819ULL, 0x000fe20000011641ULL,
0x000000121824723cULL, 0x000fe20000001824ULL, 0x0000004cff4f723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fc400020006ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000061ff58723eULL, 0x000fe400020006ffULL,
0x00000039ff4c723eULL, 0x000fe400020006ffULL, 0x0000003bff4d723eULL, 0x000fe400020006ffULL,
0x00000038ff49723eULL, 0x000fc400020006ffULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x011000004438783bULL, 0x0002e20000000200ULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x0000541047127816ULL, 0x000fe40000000058ULL, 0x0000541046137816ULL, 0x000fc4000000004fULL,
0x000054104c4c7816ULL, 0x000fe40000000042ULL, 0x000054104d4d7816ULL, 0x000fe40000000043ULL,
0x000054103e3e7816ULL, 0x000fe20000000049ULL, 0x000000121828723cULL, 0x000fe20000001828ULL,
0x000054103f3f7816ULL, 0x000fe40000000045ULL, 0x0000541040407816ULL, 0x000fe4000000003cULL,
0x0000541041417816ULL, 0x000fe2000000003dULL, 0x0000004c182c723cULL, 0x000fec000000182cULL,
0x0000003e1830723cULL, 0x000fec0000001830ULL, 0x000000401834723cULL, 0x000fe20000001834ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000100947ULL, 0x002fde0003800000ULL,
0x0000000538387232ULL, 0x08cfe40000000000ULL, 0x000000053a3a7232ULL, 0x000fe40000000000ULL,
0x0000000339397232ULL, 0x080fe40000000000ULL, 0x000000033b3b7232ULL, 0x000fce0000000000ULL,
0x000000004818783bULL, 0x000e620000004200ULL, 0x000000100d0d7812ULL, 0x000fe200078efcffULL,
0x000000010a0a7836ULL, 0x000fc80000000000ULL, 0x000000010d0e7824ULL, 0x040fe400078e020eULL,
0x000000080d0d7824ULL, 0x000fca00078e00ffULL, 0xfffffff80d0d7812ULL, 0x000fca00078ee20eULL,
0x000000100d0d7824ULL, 0x000fca00078e0210ULL, 0x000000000d3c783bULL, 0x000b620000004200ULL,
0x00000010ff0e7819ULL, 0x002fe40000011618ULL, 0x00000010ff137819ULL, 0x000fe40000011619ULL,
0x000000ff18127812ULL, 0x000fe400078ec0ffULL, 0x000000ff19407812ULL, 0x000fe400078ec0ffULL,
0x000000ff0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff13137812ULL, 0x000fc400078ec0ffULL,
0x00000018ff107819ULL, 0x000fe40000011618ULL, 0x0000ffff18497812ULL, 0x000fe400078ec0ffULL,
0x00000018ff187819ULL, 0x000fe40000011619ULL, 0x0000ffff19487812ULL, 0x000fe400078ec0ffULL,
0x00000012ff12723eULL, 0x000fe400020006ffULL, 0x00000040ff40723eULL, 0x000fc400020006ffULL,
0x0000000eff0e723eULL, 0x000fe400020006ffULL, 0x00000013ff13723eULL, 0x000fe400020006ffULL,
0x00000010ff197819ULL, 0x100fe4000001161aULL, 0x00000018ff417819ULL, 0x000fe4000001161aULL,
0x00000018ff42723eULL, 0x000fe400020006ffULL, 0x000000ff1a437812ULL, 0x000fc400078ec0ffULL,
0x0000ffff1a4c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff0d7819ULL, 0x028fe40000011649ULL,
0x00000008ff187819ULL, 0x000fe40000011648ULL, 0x0000541012127816ULL, 0x000fe4000000000eULL,
0x0000541040137816ULL, 0x000fe40000000013ULL, 0x00000010ff1a7819ULL, 0x000fc4000001161bULL,
0x000000ff1b447812ULL, 0x000fe400078ec0ffULL, 0x000000ff19197812ULL, 0x000fe400078ec0ffULL,
0x00000041ff46723eULL, 0x000fe400020006ffULL, 0x00000010ff10723eULL, 0x000fe400020006ffULL,
0x0000000dff0d723eULL, 0x000fe400020006ffULL, 0x00000018ff41723eULL, 0x000fc400020006ffULL,
0x0000ffff1b4d7812ULL, 0x000fe400078ec0ffULL, 0x00000044ff47723eULL, 0x000fe400020006ffULL,
0x000000ff1a487812ULL, 0x000fe400078ec0ffULL, 0x00000018ff457819ULL, 0x000fe4000001161bULL,
0x00000019ff44723eULL, 0x000fe400020006ffULL, 0x000000123818723cULL, 0x000fe20000001814ULL,
0x00000043ff43723eULL, 0x000fc400020006ffULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000008ff0e7819ULL, 0x000fe4000001164cULL, 0x000054100d127816ULL, 0x000fe40000000010ULL,
0x0000541041137816ULL, 0x000fe40000000042ULL, 0x00000008ff147819ULL, 0x000fe4000001164dULL,
0x00000045ff0d723eULL, 0x000fc400020006ffULL, 0x00000014ff14723eULL, 0x000fe200020006ffULL,
0x00000012381c723cULL, 0x000fe2000000181cULL, 0x0000541043447816ULL, 0x000fe40000000044ULL,
0x0000541047457816ULL, 0x000fe40000000048ULL, 0x0000000eff0e723eULL, 0x000fe400020006ffULL,
0x00000010ff127819ULL, 0x004fe4000001163dULL, 0x0000541014477816ULL, 0x000fe2000000000dULL,
0x000000443820723cULL, 0x000fe20000001820ULL, 0x000054100e467816ULL, 0x000fc40000000046ULL,
0x00000010ff0d7819ULL, 0x100fe4000001163cULL, 0x00000018ff137819ULL, 0x000fe4000001163dULL,
0x000000ff12127812ULL, 0x000fe200078ec0ffULL, 0x000000463824723cULL, 0x000fe20000001824ULL,
0x0000ffff3d447812ULL, 0x000fe400078ec0ffULL, 0x000000ff3c107812ULL, 0x000fe400078ec0ffULL,
0x00000018ff0e7819ULL, 0x000fc4000001163cULL, 0x0000ffff3c437812ULL, 0x000fe400078ec0ffULL,
0x000000ff3d147812ULL, 0x000fe400078ec0ffULL, 0x000000ff0d0d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3c7819ULL, 0x100fe4000001163eULL, 0x00000013ff17723eULL, 0x000fe400020006ffULL,
0x00000010ff167819ULL, 0x000fc4000001163eULL, 0x00000012ff13723eULL, 0x000fe400020006ffULL,
0x000000ff3e3d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3e457812ULL, 0x000fe400078ec0ffULL,
0x00000008ff127819ULL, 0x000fe40000011644ULL, 0x00000010ff3e7819ULL, 0x000fe4000001163fULL,
0x000000ff3f417812ULL, 0x000fc400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe4000001163fULL,
0x0000ffff3f467812ULL, 0x000fe400078ec0ffULL, 0x00000010ff10723eULL, 0x000fe400020006ffULL,
0x00000014ff15723eULL, 0x000fe400020006ffULL, 0x0000000dff0d723eULL, 0x000fe400020006ffULL,
0x0000003cff3f723eULL, 0x000fc400020006ffULL, 0x000000ff163c7812ULL, 0x000fe400078ec0ffULL,
0x00000012ff16723eULL, 0x000fe400020006ffULL, 0x0000541010127816ULL, 0x000fe2000000000dULL,
0x00000001ff107424ULL, 0x000fe200078e00ffULL, 0x0000541015137816ULL, 0x000fe40000000013ULL,
0x000000ff3e3e7812ULL, 0x000fe400078ec0ffULL, 0x00000040ff42723eULL, 0x000fc400020006ffULL,
0x0000003eff40723eULL, 0x000fe200020006ffULL, 0x000000123828723cULL, 0x000fe20000001828ULL,
0x0000000eff14723eULL, 0x000fe200020006ffULL, 0x00000010091279a7ULL, 0x0002a2000850003fULL,
0x00000008ff3e7819ULL, 0x000fe40000011645ULL, 0x00000008ff0e7819ULL, 0x000fe40000011643ULL,
0x00000008ff0d7819ULL, 0x000fe40000011646ULL, 0x0000003dff3d723eULL, 0x000fc400020006ffULL,
0x0000003cff3c723eULL, 0x000fe200020006ffULL, 0x0000000850097824ULL, 0x002fe200078e0202ULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x0176a01009ff79a7ULL, 0x0003e2000850003fULL, 0x0000000eff0e723eULL, 0x000fe400020006ffULL,
0x0000000dff0d723eULL, 0x000fe400020006ffULL, 0x000054103d3c7816ULL, 0x000fc4000000003cULL,
0x000054103e3e7816ULL, 0x000fe4000000003fULL, 0x000054100e147816ULL, 0x000fe40000000014ULL,
0x0000541016157816ULL, 0x000fe40000000017ULL, 0x00005410413d7816ULL, 0x000fe40000000040ULL,
0x000054100d3f7816ULL, 0x000fe20000000042ULL, 0x000000ffff0d7224ULL, 0x004fe400078e0013ULL,
0x00000014382c723cULL, 0x000fec000000182cULL, 0x0000003c3830723cULL, 0x000fec0000001830ULL,
0x0000003e3834723cULL, 0x000fe20000001834ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffff7000889947ULL, 0x002fde000383ffffULL, 0x0000100001097983ULL, 0x008ee40000300800ULL,
0x000000ff0900720cULL, 0x008fda0003f05270ULL, 0x0000000000d48947ULL, 0x000fea0003800000ULL,
0x018000000f037836ULL, 0x002fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000003037812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000ac5000067802ULL, 0x004fce0000000f00ULL,
0x0000008400407944ULL, 0x010fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000000f00047308ULL, 0x000e640000001000ULL, 0xbf80000004037423ULL, 0x002fc8000000000fULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000304037223ULL, 0x000fce0000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009a00ff047b82ULL, 0x000f640000000a00ULL,
0x0000000604047981ULL, 0x02aee2000c1e9900ULL, 0x0000000000077919ULL, 0x004e640000000000ULL,
0x00000002ff067819ULL, 0x002fe40000011607ULL, 0x0000000807087811ULL, 0x000fe200078ff0ffULL,
0x0000000304037220ULL, 0x008fca0000410000ULL, 0x00001f0603067589ULL, 0x000e6800000e0000ULL,
0x00001f0803077589ULL, 0x000ea200000e0000ULL, 0x0000001806187220ULL, 0x042fe20000410000ULL,
0x0000001906197220ULL, 0x040fe20000410000ULL, 0x0000001c061c7220ULL, 0x040fe20000410000ULL,
0x0000001d061d7220ULL, 0x040fe20000410000ULL, 0x0000002006207220ULL, 0x040fe20000410000ULL,
0x0000002106217220ULL, 0x040fe20000410000ULL, 0x0000002406247220ULL, 0x040fe20000410000ULL,
0x0000002506257220ULL, 0x040fe20000410000ULL, 0x0000002806287220ULL, 0x040fe20000410000ULL,
0x0000002906297220ULL, 0x040fe20000410000ULL, 0x0000002c062c7220ULL, 0x040fe20000410000ULL,
0x0000002d062d7220ULL, 0x040fe20000410000ULL, 0x0000003006307220ULL, 0x040fe20000410000ULL,
0x0000003106317220ULL, 0x040fe20000410000ULL, 0x0000003406347220ULL, 0x040fe20000410000ULL,
0x0000003506357220ULL, 0x000fe20000410000ULL, 0x0000001a071a7220ULL, 0x044fe20000410000ULL,
0x0000001b071b7220ULL, 0x040fe20000410000ULL, 0x0000001e071e7220ULL, 0x040fe20000410000ULL,
0x0000001f071f7220ULL, 0x040fe20000410000ULL, 0x0000002207227220ULL, 0x040fe20000410000ULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000002607267220ULL, 0x040fe20000410000ULL,
0x0000002707277220ULL, 0x040fe20000410000ULL, 0x0000002a072a7220ULL, 0x040fe20000410000ULL,
0x0000002b072b7220ULL, 0x040fe20000410000ULL, 0x0000002e072e7220ULL, 0x040fe20000410000ULL,
0x0000002f072f7220ULL, 0x040fe20000410000ULL, 0x0000003207327220ULL, 0x040fe20000410000ULL,
0x0000003307337220ULL, 0x040fe20000410000ULL, 0x0000003607367220ULL, 0x040fe20000410000ULL,
0x0000003707377220ULL, 0x000fce0000410000ULL, 0x0000000000057919ULL, 0x000ee20000000000ULL,
0x0000002c2d2c723eULL, 0x000fe400000000ffULL, 0x000000303130723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000222322723eULL, 0x000fc400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x0000002e2f15723eULL, 0x000fe400000000ffULL,
0x000000323332723eULL, 0x000fe400000000ffULL, 0x000000ff5300720cULL, 0x000fe40003f05270ULL,
0x0000000805067811ULL, 0x00cfe400078ff0ffULL, 0x00000002ff0a7819ULL, 0x000fc40000011605ULL,
0x0000000205037812ULL, 0x002fe200078ec0ffULL, 0x00000008060e7824ULL, 0x000fe400078e00ffULL,
0x000000080a097824ULL, 0x040fe200078e00ffULL, 0x0000000a03047211ULL, 0x040fe200078ff8ffULL,
0x000000080a0b7824ULL, 0x040fe200078e00ffULL, 0x0000000603077211ULL, 0x000fe200078ff8ffULL,
0x000000080a0c7824ULL, 0x000fe200078e00ffULL, 0x0000000100037812ULL, 0x000fe200078ec0ffULL,
0x0000000204067836ULL, 0x000fe20000000000ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL,
0x000000080a077824ULL, 0x000fc400078e00ffULL, 0x0000100003027824ULL, 0x000fe200078e0202ULL,
0xfffffff809087812ULL, 0x000fe200078ee206ULL, 0x0000000404067836ULL, 0x000fe20000000000ULL,
0xfffffff807007812ULL, 0x000fe200078ee204ULL, 0x0000000604097836ULL, 0x000fe40000000000ULL,
0x0000000805047824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0a7812ULL, 0x000fe200078ee206ULL,
0x0000080053077824ULL, 0x000fe200078e0202ULL, 0xfffffff80c0c7812ULL, 0x000fe400078ee209ULL,
0x0000000804097812ULL, 0x000fe200078ec0ffULL, 0x0000001000067824ULL, 0x100fe200078e0207ULL,
0x000000181900723eULL, 0x000fe200000000ffULL, 0x000000100e0e7824ULL, 0x100fe200078e0207ULL,
0x0000001c1d04723eULL, 0x000fe200000000ffULL, 0x0000001008087824ULL, 0x100fe200078e0207ULL,
0x000000343518723eULL, 0x000fe200000000ffULL, 0x000000100a0a7824ULL, 0x100fe200078e0207ULL,
0x0000541000107816ULL, 0x100fe20000000004ULL, 0x000000100c0c7824ULL, 0x000fe200078e0207ULL,
0x0000763200117816ULL, 0x010fe20000000004ULL, 0x0000000106077824ULL, 0x000fe200078e0209ULL,
0x000000202100723eULL, 0x000fe200000000ffULL, 0x0000000109087824ULL, 0x000fe200078e0208ULL,
0x000000242504723eULL, 0x000fe200000000ffULL, 0x00000001090a7824ULL, 0x000fe200078e020aULL,
0x000000282906723eULL, 0x000fe200000000ffULL, 0x0000001007007388ULL, 0x0003e20000000a00ULL,
0x00000001090c7824ULL, 0x000fe200078e020cULL, 0x000000363719723eULL, 0x000fe200000000ffULL,
0x00000001090e7824ULL, 0x000fe200078e020eULL, 0x0000541006127816ULL, 0x000fc4000000002cULL,
0x0000763206137816ULL, 0x000fe4000000002cULL, 0x0000541030067816ULL, 0x000fe40000000018ULL,
0x000076322a097816ULL, 0x000fe40000000015ULL, 0x0000541000107816ULL, 0x142fe40000000004ULL,
0x0000763200117816ULL, 0x000fe40000000004ULL, 0x0000001a1b00723eULL, 0x000fc400000000ffULL,
0x0000001e1f04723eULL, 0x000fe200000000ffULL, 0x0000001008007388ULL, 0x0003e20000000a00ULL,
0x0000763230077816ULL, 0x000fc60000000018ULL, 0x000000120a007388ULL, 0x0005e80000000a00ULL,
0x000000060c007388ULL, 0x0007e20000000a00ULL, 0x000000262711723eULL, 0x002fe400000000ffULL,
0x0000541000127816ULL, 0x144fe40000000004ULL, 0x0000763200137816ULL, 0x000fe40000000004ULL,
0x00007632220f7816ULL, 0x000fe20000000011ULL, 0x0000000156077824ULL, 0x008fc400078e0205ULL,
0x000000120e007388ULL, 0x0003e40000000a00ULL, 0x0000001007077824ULL, 0x000fe200078e0202ULL,
0x00005410220e7816ULL, 0x002fca0000000011ULL, 0x0004000e08007388ULL, 0x0003e40000000a00ULL,
0x000054102a087816ULL, 0x002fe40000000015ULL, 0x00005410320e7816ULL, 0x140fe40000000019ULL,
0x00007632320f7816ULL, 0x000fe20000000019ULL, 0x000400080a007388ULL, 0x000fe80000000a00ULL,
0x0004000e0c007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000007107984ULL, 0x000e680000000c00ULL, 0x0004000007187984ULL, 0x000ea80000000c00ULL,
0x0008000007147984ULL, 0x000ee80000000c00ULL, 0x000c0000071c7984ULL, 0x000f220000000c00ULL,
0x200000ff13137230ULL, 0x002fc40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fe40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x200000ff1b1b7230ULL, 0x004fe40000000000ULL, 0x200000ff1a1a7230ULL, 0x000fe40000000000ULL,
0x200000ff19197230ULL, 0x000fc40000000000ULL, 0x200000ff18187230ULL, 0x000fe40000000000ULL,
0x0000001713137230ULL, 0x008fe40000000000ULL, 0x0000001612127230ULL, 0x000fe40000000000ULL,
0x0000001511117230ULL, 0x000fe40000000000ULL, 0x0000001410107230ULL, 0x000fe40000000000ULL,
0x0000001f1b1b7230ULL, 0x010fc40000000000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000000000ULL,
0x0000001007007388ULL, 0x0003e20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000000000ULL,
0x0000001c18187230ULL, 0x000fca0000000000ULL, 0x0004001807007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff047819ULL, 0x000fc80000011605ULL, 0x000000540400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000180001387983ULL, 0x000ea20000100800ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x0000000800087d06ULL, 0x000ee20008209000ULL, 0x00000008ff137c12ULL, 0x002fe2000f8e33ffULL,
0x0000850000097ab9ULL, 0x000fe20000000800ULL, 0x00008a0000047ab9ULL, 0x000fca0000000a00ULL,
0x0000000800087308ULL, 0x008e640000001000ULL, 0x0ffffffe08097836ULL, 0x002fcc0000000000ULL,
0x0000000900077305ULL, 0x000e64000021f000ULL, 0x000000ffff0b7224ULL, 0x002fc800078e0a07ULL,
0x000000080b0b7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000b07117227ULL, 0x000fc800078e0006ULL,
0x0000000138007824ULL, 0x004fe400078e0204ULL, 0x0000000104047824ULL, 0x000fe400078e0205ULL,
0x0000000011067227ULL, 0x000fc600078e00ffULL, 0x0000000704047812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x0000000807077c24ULL, 0x000fca000f8e0200ULL,
0x0000000807007c0cULL, 0x000fda000bf06070ULL, 0x8000000807070c36ULL, 0x000fe40008000000ULL,
0x0000000106060836ULL, 0x000fe20000000000ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x0000000807007c0cULL, 0x000fe4000bf26070ULL, 0x0ffffff804077812ULL, 0x000fca00078ef805ULL,
0x0000001007047824ULL, 0x000fca00078e0202ULL, 0x0000000004087984ULL, 0x0002a20000000c00ULL,
0x0000000106061836ULL, 0x000fca0000000000ULL, 0x0000000613067207ULL, 0x000fe40004000000ULL,
0x0000000705047812ULL, 0x002fc600078ec0ffULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a06ULL,
0x0000000906077c24ULL, 0x000fe4000f8e0251ULL, 0x000000080d007c24ULL, 0x000fe4000f8e0200ULL,
0x00000008030d7824ULL, 0x000fe400078e0204ULL, 0x0000000807007c24ULL, 0x000fca000f8e0200ULL,
0x0000000055077210ULL, 0x000fe20007f3e0ffULL, 0x0000002005007836ULL, 0x000fc80000000000ULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x0000000407067c11ULL, 0x040fe4000f8240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011600ULL, 0x0000000507077c11ULL, 0x000fe400088f440cULL,
0x000000540f00720cULL, 0x000fe20003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000138047824ULL, 0x100fe400078e020fULL, 0x00000001000f7824ULL, 0x000fe400078e020fULL,
0x0000000411067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a06ULL, 0x0ffffff80f0f7812ULL, 0x000fe200078ef800ULL,
0x0000000807077c24ULL, 0x000fe2000f8e0204ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0202ULL, 0x0000000807007c0cULL, 0x000fca000bf26070ULL,
0x000000000f0c7984ULL, 0x000e700000000c00ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fda000bf46070ULL,
0x0000000106062836ULL, 0x000fca0000000000ULL, 0x0000000613067207ULL, 0x000fca0004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a06ULL, 0x0000000906077c24ULL, 0x000fe4000f8e0251ULL,
0x0000000809047c24ULL, 0x000fe4000f8e0204ULL, 0x0000000803097824ULL, 0x000fe400078e0200ULL,
0x0000000807047c24ULL, 0x000fca000f8e0204ULL, 0x0000000455047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x0000000404067c11ULL, 0x000fc8000f8240ffULL,
0x0000000504077c11ULL, 0x000fe200088f4407ULL, 0x0000004005047836ULL, 0x000fe40000000000ULL,
0x0000001009067825ULL, 0x000fc600078e0006ULL, 0x00000003ff0b7819ULL, 0x000fc80000011604ULL,
0x000000540b00720cULL, 0x000fe20003f26070ULL, 0x0000000c06007986ULL, 0x0023d8000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000138007824ULL, 0x100fe400078e020bULL,
0x00000001040b7824ULL, 0x000fe400078e020bULL, 0x0000000011067227ULL, 0x002fc600078e00ffULL,
0x000000070b0b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc600078e0a06ULL,
0x0ffffff80b0b7812ULL, 0x000fe200078ef804ULL, 0x0000000807077c24ULL, 0x000fe2000f8e0200ULL,
0x0000000704047812ULL, 0x000fc600078ec0ffULL, 0x000000100b0b7824ULL, 0x000fe200078e0202ULL,
0x0000000807007c0cULL, 0x000fca000bf26070ULL, 0x000000000b087984ULL, 0x000e700000000c00ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000106061836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf46070ULL, 0x0000000106062836ULL, 0x000fca0000000000ULL,
0x0000000613067207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a06ULL,
0x0000000906077c24ULL, 0x000fe4000f8e0251ULL, 0x000000080d007c24ULL, 0x000fc8000f8e0200ULL,
0x0000000807007c24ULL, 0x000fca000f8e0200ULL, 0x0000000055007210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x0000000400067c11ULL, 0x000fc8000f8240ffULL,
0x0000000500077c11ULL, 0x000fe200088f4407ULL, 0x0000006005007836ULL, 0x000fe40000000000ULL,
0x0000000803057824ULL, 0x000fc600078e0204ULL, 0x00000003ff0d7819ULL, 0x000fe20000011600ULL,
0x0000001005047825ULL, 0x000fc600078e0006ULL, 0x000000540d00720cULL, 0x000fe20003f26070ULL,
0x0000000138067824ULL, 0x000fe200078e020dULL, 0x0000000804007986ULL, 0x0023f6000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000611047227ULL, 0x002fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x00000001000d7824ULL, 0x000fe400078e020dULL,
0x0000000805057c24ULL, 0x000fc6000f8e0206ULL, 0x000000070d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000000805007c0cULL, 0x000fe4000bf26070ULL, 0xfffffff80d0d7812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x000000100d0d7824ULL, 0x000fe400078e0202ULL,
0x0000000803037824ULL, 0x000fc800078e0200ULL, 0x8000000805051c36ULL, 0x000fe20008000000ULL,
0x000000000d0c7984ULL, 0x000e620000000c00ULL, 0x0000000104041836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fda000bf46070ULL, 0x0000000104042836ULL, 0x000fca0000000000ULL,
0x0000000413047207ULL, 0x000fca0004000000ULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x0000000904517c24ULL, 0x000fe4000f8e0251ULL, 0x0000000805067c24ULL, 0x000fc8000f8e0206ULL,
0x0000000851067c24ULL, 0x000fca000f8e0206ULL, 0x0000000655067210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff057224ULL, 0x000fe200000e06ffULL, 0x0000000406047c11ULL, 0x000fc8000f8040ffULL,
0x0000000506057c11ULL, 0x000fc600080f4405ULL, 0x0000001003027825ULL, 0x000fca00078e0004ULL,
0x0000000c02007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000c0001407983ULL, 0x000ea20000100800ULL, 0x00009a00ff0c7b82ULL, 0x002e620000000a00ULL,
0xffffffffff117424ULL, 0x000fe400078e00ffULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x0000080001427983ULL, 0x000f280000100800ULL, 0x000000060c0c7981ULL, 0x002f22000c1e9900ULL,
0x000000400000720cULL, 0x004fda0003f06070ULL, 0x00009600ff068b82ULL, 0x000e620000000800ULL,
0x0000000205078824ULL, 0x000fce00078e00ffULL, 0x00009200ff0e8b82ULL, 0x000ea20000000a00ULL,
0x0000000607078224ULL, 0x002fc800078e0200ULL, 0x00000004070e8825ULL, 0x004fe400078e000eULL,
0x01760009020679a7ULL, 0x0002a6000850003fULL, 0x000000060e118981ULL, 0x000762000c1e1900ULL,
0x00009000ff087b82ULL, 0x002e620000000a00ULL, 0x000001ff1000780cULL, 0x000fe20003f04070ULL,
0x0000004003037824ULL, 0x000fe400078e00ffULL, 0x00000040000e7824ULL, 0x008fc400078e00ffULL,
0x0000001103117224ULL, 0x020fe400078e02ffULL, 0x0000004051037824ULL, 0x000fe400078e00ffULL,
0x0000008011087825ULL, 0x002fc800078e0008ULL, 0x0000000c00200947ULL, 0x004fea0003800000ULL,
0x00000003ff207819ULL, 0x000fe20000011604ULL, 0x00004000001e7824ULL, 0x000fe200078e0202ULL,
0x0000000e420d7248ULL, 0x010fc60007fe0000ULL, 0x00000004200f7836ULL, 0x000fe40000000000ULL,
0x000000010d0d7824ULL, 0x000fe400078e0a0eULL, 0x000000010f0e7824ULL, 0x040fe400078e0204ULL,
0x000000080f217824ULL, 0x040fe200078e00ffULL, 0x0000000d0f00720cULL, 0x080fe20003f86070ULL,
0x00000008200f7836ULL, 0x000fe40000000000ULL, 0x0000004051517824ULL, 0x000fe200078e0220ULL,
0xfffffff821217812ULL, 0x000fe200078ee20eULL, 0x000000010f147824ULL, 0x040fe200078e0204ULL,
0x0000000d0f00720cULL, 0x040fe20003f06070ULL, 0x000000080f297824ULL, 0x000fc400078e00ffULL,
0x0000000c20117836ULL, 0x000fe40000000000ULL, 0x00000080510e7825ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe400078ee214ULL, 0x0000000d1100720cULL, 0x040fe20003f26070ULL,
0x0000000851127836ULL, 0x000fe20000000000ULL, 0x000000700e237812ULL, 0x000fe200078ef80aULL,
0x0000000451107836ULL, 0x000fe40000000000ULL, 0x0000000111157824ULL, 0x040fe200078e0204ULL,
0x0000002308227210ULL, 0x000fe20007f5e0ffULL, 0x0000000811167824ULL, 0x000fc400078e00ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff8162b7812ULL, 0x000fe200078ee215ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000007012157812ULL, 0x000fc600078ef80aULL,
0x0000000c51147836ULL, 0x000fe20000000000ULL, 0x00000070101d7812ULL, 0x000fe200078ef80aULL,
0x0000000109237824ULL, 0x000fe200010e060fULL, 0x00000015080e7210ULL, 0x000fe20007f7e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000001d081c7210ULL, 0x000fc60007f5e0ffULL,
0x0000001051107836ULL, 0x000fe20000000000ULL, 0x0000007014177812ULL, 0x000fe200078ef80aULL,
0x00000001091d7824ULL, 0x000fe400010e0611ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001708167210ULL, 0x000fc60007f5e0ffULL, 0x0000001851187836ULL, 0x000fe20000000000ULL,
0x00000070101f7812ULL, 0x000fe200078ef80aULL, 0x0000001c511a7836ULL, 0x000fe40000000000ULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000007018257812ULL, 0x000fc600078ef80aULL, 0x0000000109177824ULL, 0x040fe200010e0615ULL,
0x0000001f08147210ULL, 0x000fe20007f5e0ffULL, 0x0000001451127836ULL, 0x000fe20000000000ULL,
0x000000701a1f7812ULL, 0x000fe200078ef80aULL, 0x00000001090f7824ULL, 0x000fe200018e0613ULL,
0x0000002508107210ULL, 0x000fe20007f7e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000001f08187210ULL, 0x000fc60007fbe0ffULL, 0x0000000109157824ULL, 0x040fe200010e0611ULL,
0x0000007012277812ULL, 0x000fe200078ef80aULL, 0x0000000109117824ULL, 0x040fe400018e0619ULL,
0x0000000109197824ULL, 0x000fe200028e061bULL, 0x0000002708127210ULL, 0x000fe20007f5e0ffULL,
0x00000010201f7836ULL, 0x000fe20000000000ULL, 0x0000000d2000720cULL, 0x040fe20003fa6070ULL,
0x00000001201b7824ULL, 0x000fe400078e0204ULL, 0x00000020511a7836ULL, 0x000fc40000000000ULL,
0x000000011f247824ULL, 0x100fe200078e0204ULL, 0x000000071b277812ULL, 0x000fe200078ec0ffULL,
0x000000081f2d7824ULL, 0x000fe400078e00ffULL, 0x0000001420257836ULL, 0x000fe20000000000ULL,
0x0ffffff827277812ULL, 0x000fe200078ef804ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe400078ee224ULL, 0x0000000d2500720cULL, 0x080fe20003f66070ULL,
0x0000000109137824ULL, 0x000fe200010e0613ULL, 0x0000000d1f00720cULL, 0x000fe20003f46070ULL,
0x0000000125267824ULL, 0x040fe200078e0204ULL, 0x000000701a1f7812ULL, 0x000fe200078ef80aULL,
0x00000008252f7824ULL, 0x000fc400078e00ffULL, 0x0000002451247836ULL, 0x000fe20000000000ULL,
0x0000001f081a7210ULL, 0x000fe20007fde0ffULL, 0x000010001e1e7836ULL, 0x000fe20000000000ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee226ULL, 0x0000008024247825ULL, 0x000fc800078e00ffULL,
0x0000002851267836ULL, 0x000fe20000000000ULL, 0x0000007024317812ULL, 0x000fe200078ef80aULL,
0x00000010271f7824ULL, 0x000fe400078e021eULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000221f7faeULL, 0x0003e2000e901c46ULL,
0x0000001820287836ULL, 0x000fe40000000000ULL, 0x00000001091b7824ULL, 0x000fe400030e061bULL,
0x0000001021217824ULL, 0x000fe200078e021eULL, 0x0000000d2800720cULL, 0x0c0fe20003fa6070ULL,
0x0000001c202a7836ULL, 0x000fe40000000000ULL, 0x0000000128247824ULL, 0x040fe200078e0204ULL,
0x000000001c217faeULL, 0x0005e2000e101c46ULL, 0x0000000828337824ULL, 0x000fe200078e00ffULL,
0x0000003108227210ULL, 0x002fe20007fde0ffULL, 0x0000001029297824ULL, 0x000fe200078e021eULL,
0x00000070261f7812ULL, 0x000fe200078ef80aULL, 0x000000012a267824ULL, 0x040fe200078e0204ULL,
0x0000000d2a00720cULL, 0x000fe20003f86070ULL, 0x0000000109237824ULL, 0x000fe200030e0625ULL,
0x000000000e297faeULL, 0x0003e2000c101c46ULL, 0x000000102b2b7824ULL, 0x000fc400078e021eULL,
0x0000002420287836ULL, 0x000fe20000000000ULL, 0x0000001f081c7210ULL, 0x004fe20007fde0ffULL,
0x000000082a217824ULL, 0x000fe200078e00ffULL, 0xfffffff8331f7812ULL, 0x000fe200078ee224ULL,
0x0000002c51247836ULL, 0x000fe20000000000ULL, 0x00000000162b7faeULL, 0x0005e2000c901c46ULL,
0x000000102d2d7824ULL, 0x100fe200078e021eULL, 0xfffffff821217812ULL, 0x000fe200078ee226ULL,
0x0000002020267836ULL, 0x000fe20000000000ULL, 0x0000000d2800720cULL, 0x080fe20003f26070ULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x00000000142d7faeULL, 0x000fe4000d101c46ULL,
0x0000000d2600720cULL, 0x000fe20003f06070ULL, 0x00000001091d7824ULL, 0x000fe200030e0627ULL,
0x0000007024317812ULL, 0x000fe200078ef80aULL, 0x000000102f2f7824ULL, 0x000fc400078e021eULL,
0x0000000126277824ULL, 0x140fe200078e0204ULL, 0x00000031080e7210ULL, 0x002fe20007fde0ffULL,
0x0000000826267824ULL, 0x000fe200078e00ffULL, 0x00000000122f7faeULL, 0x0003e2000d901c46ULL,
0x0000000128247824ULL, 0x040fe400078e0204ULL, 0x00000008280f7824ULL, 0x000fe200078e00ffULL,
0xfffffff826277812ULL, 0x000fe200078ee227ULL, 0x000000101f1f7824ULL, 0x100fe400078e021eULL,
0x0000001021217824ULL, 0x100fe200078e021eULL, 0xfffffff80f177812ULL, 0x004fe200078ee224ULL,
0x0000001027277824ULL, 0x000fe200078e021eULL, 0x00000000101f7faeULL, 0x0005e2000e901c46ULL,
0x0000002820167836ULL, 0x000fc40000000000ULL, 0x0000003051127836ULL, 0x002fe20000000000ULL,
0x0000000018217faeULL, 0x000fe2000e101c46ULL, 0x0000001017177824ULL, 0x000fe200078e021eULL,
0x0000000d1600720cULL, 0x080fe20003fa6070ULL, 0x00000001090f7824ULL, 0x000fe200030e0625ULL,
0x000000001a277faeULL, 0x000fe2000c101c46ULL, 0x0000002c20157836ULL, 0x000fe40000000000ULL,
0x0000003020247836ULL, 0x000fe20000000000ULL, 0x0000000022177faeULL, 0x0003e2000c901c46ULL,
0x0000008012107825ULL, 0x004fe200078e00ffULL, 0x0000000d1500720cULL, 0x000fc40003f86070ULL,
0x0000000d2400720cULL, 0x080fe20003f66070ULL, 0x0000003451127836ULL, 0x000fe20000000000ULL,
0x0000007010137812ULL, 0x000fe200078ef80aULL, 0x0000003420257836ULL, 0x000fe40000000000ULL,
0x00000038201f7836ULL, 0x000fe20000000000ULL, 0x0000001308107210ULL, 0x000fe20007fde0ffULL,
0x0000003c20207836ULL, 0x000fe20000000000ULL, 0x0000000d2500720cULL, 0x080fe20003f46070ULL,
0x0000000116147824ULL, 0x040fe200078e0204ULL, 0x0000000d1f00720cULL, 0x080fe20003f26070ULL,
0x0000000816177824ULL, 0x002fe200078e00ffULL, 0x0000000d2000720cULL, 0x000fe20003f06070ULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff8170d7812ULL, 0x000fe200078ee214ULL,
0x0000000109117824ULL, 0x000fe200030e0611ULL, 0x0000007012177812ULL, 0x000fe200078ef80aULL,
0x0000000124127824ULL, 0x140fe400078e0204ULL, 0x00000008241b7824ULL, 0x000fe200078e00ffULL,
0x0000001708167210ULL, 0x000fe20007fde0ffULL, 0x0000000115147824ULL, 0x040fe400078e0204ULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee212ULL,
0x0000003851157836ULL, 0x000fc40000000000ULL, 0x0000000109177824ULL, 0x000fe200030e0613ULL,
0xfffffff819197812ULL, 0x000fe200078ee214ULL, 0x0000008015127825ULL, 0x000fc800078e00ffULL,
0x0000003c51147836ULL, 0x000fe40000000000ULL, 0x0000000125187824ULL, 0x100fe400078e0204ULL,
0x000000011f1a7824ULL, 0x040fe400078e0204ULL, 0x000000081f217824ULL, 0x000fe200078e00ffULL,
0x00000070121f7812ULL, 0x000fe200078ef80aULL, 0x0000000825257824ULL, 0x000fe400078e00ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000001f08127210ULL, 0x000fc40007fde0ffULL,
0xfffffff8251f7812ULL, 0x000fe200078ee218ULL, 0x0000000120047824ULL, 0x040fe200078e0204ULL,
0x0000007014257812ULL, 0x000fe200078ef80aULL, 0x0000000820237824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee21aULL, 0x0000000109137824ULL, 0x000fe200030e0613ULL,
0x0000002508087210ULL, 0x000fe20007fde0ffULL, 0x000000100d0d7824ULL, 0x100fe200078e021eULL,
0xfffffff823237812ULL, 0x000fe200078ee204ULL, 0x0000001019197824ULL, 0x100fe400078e021eULL,
0x000000101b1b7824ULL, 0x100fe200078e021eULL, 0x000000001c0d7faeULL, 0x0003e2000e901c46ULL,
0x000000101f1f7824ULL, 0x000fc400078e021eULL, 0x0000001021217824ULL, 0x100fe200078e021eULL,
0x000000000e197faeULL, 0x0003e2000e101c46ULL, 0x0000001023237824ULL, 0x000fe400078e021eULL,
0x0000000109097824ULL, 0x000fe200030e0615ULL, 0x00000000101b7faeULL, 0x0003e8000d901c46ULL,
0x00000000161f7faeULL, 0x0003e8000d101c46ULL, 0x0000000012217faeULL, 0x0003e8000c901c46ULL,
0x0000000008237faeULL, 0x0003e2000c101c46ULL, 0x0000000800d07947ULL, 0x000fea0003800000ULL,
0x00000004040f7811ULL, 0x040fe400078fe8ffULL, 0x0000000804127811ULL, 0x040fe400078fe8ffULL,
0x0000000c04137811ULL, 0x040fe200078fe8ffULL, 0x000000010f0d7824ULL, 0x140fe200078e0204ULL,
0x0000001804187811ULL, 0x040fe200078fe8ffULL, 0x000000080f0e7824ULL, 0x000fe200078e00ffULL,
0x0000001c04197811ULL, 0x000fe200078fe8ffULL, 0x0000000812147824ULL, 0x000fe200078e00ffULL,
0x0000001004157811ULL, 0x000fe200078fe8ffULL, 0x0000000813217824ULL, 0x040fe200078e00ffULL,
0xfffffff80e1d7812ULL, 0x000fe200078ee20dULL, 0x00000001120d7824ULL, 0x100fe200078e0204ULL,
0x0000001404177811ULL, 0x040fe200078fe8ffULL, 0x00000001130e7824ULL, 0x100fe200078e0204ULL,
0x00000020041a7811ULL, 0x000fe200078fe8ffULL, 0x0000000819297824ULL, 0x040fe200078e00ffULL,
0xfffffff8141f7812ULL, 0x000fe200078ee20dULL, 0x00000001180d7824ULL, 0x140fe200078e0204ULL,
0xfffffff821217812ULL, 0x000fe200078ee20eULL, 0x0000000818147824ULL, 0x000fe200078e00ffULL,
0x00000024041b7811ULL, 0x040fe200078fe8ffULL, 0x00000001190e7824ULL, 0x100fe200078e0204ULL,
0x0000002c04287811ULL, 0x040fe200078fe8ffULL, 0x0000000115107824ULL, 0x140fe200078e0204ULL,
0xfffffff814277812ULL, 0x000fe200078ee20dULL, 0x0000000815237824ULL, 0x000fe200078e00ffULL,
0xfffffff829147812ULL, 0x000fe200078ee20eULL, 0x0000000117117824ULL, 0x140fe200078e0204ULL,
0x0000002804297811ULL, 0x000fe200078fe8ffULL, 0x0000000817167824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee210ULL, 0x000000011a107824ULL, 0x100fe200078e0204ULL,
0x0000003004207811ULL, 0x000fe200078fe8ffULL, 0x000000081a2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff816257812ULL, 0x000fe200078ee211ULL, 0x00000001290d7824ULL, 0x140fe200078e0204ULL,
0x00000034041e7811ULL, 0x040fe200078fe8ffULL, 0x0000000829247824ULL, 0x000fe200078e00ffULL,
0xfffffff82b1c7812ULL, 0x000fe200078ee210ULL, 0x000000011b117824ULL, 0x140fe200078e0204ULL,
0x0000003804267811ULL, 0x000fe200078fe8ffULL, 0x000000081b227824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee20dULL, 0x00000001280e7824ULL, 0x100fe200078e0204ULL,
0x00000004040d7211ULL, 0x000fe200078fe8ffULL, 0x00000008282b7824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee211ULL, 0x0000000120107824ULL, 0x100fe200078e0204ULL,
0x0000003c042a7811ULL, 0x000fe200078fe8ffULL, 0x00000008202d7824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee20eULL, 0x000000011e117824ULL, 0x040fe200078e0204ULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000081e167824ULL, 0x000fe200078e00ffULL,
0x00000003040e7211ULL, 0x000fe200078fe8ffULL, 0x00000008262e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2c7812ULL, 0x000fe200078ee210ULL, 0x0000000103107824ULL, 0x000fe200078e020fULL,
0xfffffff8162d7812ULL, 0x000fe200078ee211ULL, 0x0000400000167824ULL, 0x000fe200078e0202ULL,
0x0ffffff80d0d7812ULL, 0x000fe200078ef804ULL, 0x0000000126117824ULL, 0x000fc400078e0204ULL,
0x000000012a047824ULL, 0x040fe400078e0204ULL, 0x000000082a337824ULL, 0x000fe200078e00ffULL,
0xfffffff82e317812ULL, 0x000fe200078ee211ULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff833307812ULL, 0x000fe200078ee204ULL, 0x0000100016167836ULL, 0x000fe20000000000ULL,
0x000000700e2f7812ULL, 0x000fe200078ef80aULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x0000002f080e7210ULL, 0x000fe20007f1e0ffULL, 0x0000001014047824ULL, 0x000fe200078e0216ULL,
0x00000070102f7812ULL, 0x000fe200078ef80aULL, 0x0000000103127824ULL, 0x040fe400078e0212ULL,
0x0000000103147824ULL, 0x000fe200078e0213ULL, 0x0000002f08107210ULL, 0x000fe20007f3e0ffULL,
0x000000100d0d7824ULL, 0x100fe400078e0216ULL, 0x000000101d1d7824ULL, 0x100fe400078e0216ULL,
0x000000101f1f7824ULL, 0x000fc400078e0216ULL, 0x0000001021217824ULL, 0x100fe400078e0216ULL,
0x0000001023237824ULL, 0x100fe400078e0216ULL, 0x0000001025257824ULL, 0x100fe400078e0216ULL,
0x0000001027277824ULL, 0x100fe400078e0216ULL, 0x000000101c1c7824ULL, 0x100fe400078e0216ULL,
0x0000001022227824ULL, 0x000fc400078e0216ULL, 0x0000001024247824ULL, 0x100fe400078e0216ULL,
0x000000102b2b7824ULL, 0x100fe400078e0216ULL, 0x000000102c2c7824ULL, 0x100fe400078e0216ULL,
0x000000102d2d7824ULL, 0x100fe400078e0216ULL, 0x0000001031317824ULL, 0x100fe400078e0216ULL,
0x0000001030307824ULL, 0x000fc400078e0216ULL, 0x0000000103167824ULL, 0x000fe400078e0215ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000007012397812ULL, 0x000fc600078ef80aULL, 0x00000001032e7824ULL, 0x000fe200078e0217ULL,
0x0000007014357812ULL, 0x000fe200078ef80aULL, 0x00000001090f7824ULL, 0x000fe200000e060fULL,
0x0000003908127210ULL, 0x000fe20007f1e0ffULL, 0x000000802e2e7825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0d7faeULL, 0x0003e2000b901c46ULL,
0x0000000103327824ULL, 0x000fe400078e0218ULL, 0x0000000109117824ULL, 0x040fe200008e0611ULL,
0x0000003508147210ULL, 0x000fe20007f3e0ffULL, 0x0000008032327825ULL, 0x000fe200078e00ffULL,
0x000000702e357812ULL, 0x000fe400078ef80aULL, 0x00000000101d7faeULL, 0x0003e2000b901c46ULL,
0x0000000109137824ULL, 0x000fe200000e0613ULL, 0x0000003508187210ULL, 0x000fe20007f1e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000007032357812ULL, 0x000fc400078ef80aULL,
0x00000000121f7faeULL, 0x0003e2000b901c46ULL, 0x00000001032e7824ULL, 0x000fe200078e0219ULL,
0x0000007016377812ULL, 0x000fe200078ef80aULL, 0x0000000109197824ULL, 0x000fe400000e062fULL,
0x0000000103327824ULL, 0x000fe200078e021aULL, 0x00000035081a7210ULL, 0x000fe20007f1e0ffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000003708167210ULL, 0x000fc60007f5e0ffULL,
0x0000000103367824ULL, 0x040fe200078e0229ULL, 0x000000702e397812ULL, 0x000fe200078ef80aULL,
0x0000000103347824ULL, 0x000fe400078e021bULL, 0x00000001091b7824ULL, 0x000fe400000e0633ULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x0000008032327825ULL, 0x000fc800078e00ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000007032297812ULL, 0x000fc600078ef80aULL,
0x0000000103387824ULL, 0x000fe200078e0228ULL, 0x0000003908287210ULL, 0x000fe20007f1e0ffULL,
0x0000000109177824ULL, 0x040fe200010e0617ULL, 0x0000007036397812ULL, 0x000fe200078ef80aULL,
0x0000000109157824ULL, 0x000fe200008e0615ULL, 0x00000070343b7812ULL, 0x000fe200078ef80aULL,
0x0000000103367824ULL, 0x000fe200078e0220ULL, 0x0000003908347210ULL, 0x000fe20007f5e0ffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x00000029082e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000014217faeULL, 0x0003e4000b901c46ULL, 0x0000000109297824ULL, 0x040fe200000e062fULL,
0x0000003b08327210ULL, 0x000fe20007f1e0ffULL, 0x00000001092f7824ULL, 0x000fe200008e0633ULL,
0x00000070383b7812ULL, 0x000fe200078ef80aULL, 0x00000001033a7824ULL, 0x000fe200078e021eULL,
0x0000000016237faeULL, 0x0003e2000b901c46ULL, 0x0000000109337824ULL, 0x000fe200000e0635ULL,
0x0000003b08387210ULL, 0x000fe20007f1e0ffULL, 0x00000001033c7824ULL, 0x000fe200078e0226ULL,
0x0000000018257faeULL, 0x0003e2000b901c46ULL, 0x0000000109357824ULL, 0x000fc400010e0637ULL,
0x00000001033e7824ULL, 0x000fe200078e022aULL, 0x000000001a277faeULL, 0x0003e2000b901c46ULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0x0000000028047faeULL, 0x0003e2000b901c46ULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000007036477812ULL, 0x000fe400078ef80aULL,
0x000000002e1c7faeULL, 0x0003e2000b901c46ULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x000000703a457812ULL, 0x000fe400078ef80aULL, 0x0000000032227faeULL, 0x0003e2000b901c46ULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x000000703c437812ULL, 0x000fc400078ef80aULL,
0x00000045083a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000109397824ULL, 0x040fe200000e0639ULL,
0x000000703e417812ULL, 0x000fe200078ef80aULL, 0x0000000034247faeULL, 0x0003e2000b901c46ULL,
0x0000004708367210ULL, 0x000fe20007f1e0ffULL, 0x00000001093b7824ULL, 0x040fe200008e063bULL,
0x00000043083c7210ULL, 0x000fe20007f5e0ffULL, 0x00000000382b7faeULL, 0x0003e2000b901c46ULL,
0x0000004108087210ULL, 0x000fe20007f7e0ffULL, 0x0000000109377824ULL, 0x040fe400000e0637ULL,
0x00000001093d7824ULL, 0x000fc400010e063dULL, 0x0000000109097824ULL, 0x000fe200018e063fULL,
0x00000000362c7faeULL, 0x0003e8000b901c46ULL, 0x000000003a2d7faeULL, 0x0003e8000b901c46ULL,
0x000000003c317faeULL, 0x0003e8000b901c46ULL, 0x0000000008307faeULL, 0x0003e4000b901c46ULL,
0x00000004007a7836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff0a7424ULL, 0x000fe200078e00ffULL, 0x0000840000047ab9ULL, 0x000fe40000000800ULL,
0x000000407a00720cULL, 0x000fda0003f06070ULL, 0x00009600ff048b82ULL, 0x002e620000000800ULL,
0x00000002050d8824ULL, 0x000fce00078e00ffULL, 0x00009200ff088b82ULL, 0x000ea20000000a00ULL,
0x000000040d0d8224ULL, 0x002fc800078e027aULL, 0x000000040d088825ULL, 0x004fca00078e0008ULL,
0x00000006080a8981ULL, 0x000ea2000c1e1900ULL, 0x0000001f04047890ULL, 0x000fc8000fffe03fULL,
0x000000053f047899ULL, 0x000fe20008011604ULL, 0x0000040a01007387ULL, 0x0043f60000100800ULL,
0x0000000000087805ULL, 0x000fe20000015200ULL, 0x01760007020075a7ULL, 0x000ea2000800017fULL,
0x0000000142047824ULL, 0x010fe400078e0a64ULL, 0x000000040b0b7c24ULL, 0x000fc6000f8e02ffULL,
0x00000008ff047819ULL, 0x000fca0000011604ULL, 0x0000140401007387ULL, 0x0007e20000100800ULL,
0x00008e00ff407b82ULL, 0x000f640000000a00ULL, 0x000000040b407825ULL, 0x022fe200078e0040ULL,
0x00000000005c0947ULL, 0x01efec0003800000ULL, 0x000000ffff0e7224ULL, 0x000fce00078e00ffULL,
0x000000100e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc8000001140bULL,
0x0000000d04047211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x0000000204047819ULL, 0x000fc8000000120bULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010e0e7836ULL, 0x000fce0000000000ULL,
0x01760007020075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000077919ULL, 0x000e620000000000ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000002000047824ULL, 0x002fca00078e0207ULL, 0x00000003ff067819ULL, 0x000fc80000011604ULL,
0x1ffffffe06077812ULL, 0x000fe400078ec0ffULL, 0x0000000f04067812ULL, 0x000fc600078ec0ffULL,
0x0000000104077824ULL, 0x000fe400078e0207ULL, 0x0000001006087824ULL, 0x040fe400078e00ffULL,
0x0000000107047836ULL, 0x000fe20000000000ULL, 0x0000000f07077812ULL, 0x000fe200078ec0ffULL,
0x0000001006097824ULL, 0x000fc600078e00ffULL, 0x0000000f04047812ULL, 0x000fe400078ec0ffULL,
0x000000f008077812ULL, 0x000fe400078ee207ULL, 0x000000f009097812ULL, 0x000fc600078ee204ULL,
0x0000001007077824ULL, 0x100fe400078e0202ULL, 0x0000001009097824ULL, 0x000fc600078e0202ULL,
0x0000000007147984ULL, 0x000e680000000c00ULL, 0x0000000009107984ULL, 0x000ea20000000c00ULL,
0x000000ffff187224ULL, 0x002fe400078e0014ULL, 0x000000ffff147224ULL, 0x000fe400078e0015ULL,
0x000000ffff197224ULL, 0x000fe400078e0016ULL, 0x000000ffff157224ULL, 0x000fc400078e0017ULL,
0x000000ffff1a7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0012ULL,
0x000000ffff167224ULL, 0x000fe400078e0011ULL, 0x000000ffff177224ULL, 0x000fe200078e0013ULL,
0x0000001807007388ULL, 0x0003e80000000c00ULL, 0x0000001409007388ULL, 0x0003e20000000c00ULL,
0x0176000b020a79a7ULL, 0x0002a4000850003fULL, 0x0000000000067805ULL, 0x002fe20000015200ULL,
0x0176000b020075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff0e7224ULL, 0x000fce00078e00ffULL, 0x000000100e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008060d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011409ULL, 0x0000000d04047211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000204047819ULL, 0x000fc80000001209ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010e0e7836ULL, 0x000fce0000000000ULL, 0x0176000b020075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000100001047983ULL, 0x000ea40000100800ULL,
0x000000ff0400720cULL, 0x004fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00009600ff047b82ULL, 0x000e620000000800ULL, 0x0000004000087824ULL, 0x040fe200078e00ffULL,
0x00000000005e7919ULL, 0x000ea20000000000ULL, 0x0000000800687824ULL, 0x000fe200078e0202ULL,
0x0000000104057899ULL, 0x000fe2000800063fULL, 0xffffffff646e7836ULL, 0x000fe40000000000ULL,
0x0000000964727836ULL, 0x000fe40000000000ULL, 0x000000ffff717224ULL, 0x000fe400078e00ffULL,
0x000000ffff187224ULL, 0x000fc400078e00ffULL, 0x0000000405067224ULL, 0x002fe400078e02ffULL,
0x3db504f30c047820ULL, 0x000fe20000410000ULL, 0x0000010008057836ULL, 0x000fe40000000000ULL,
0x0000002000057824ULL, 0x000fca00078e0202ULL, 0x0000000501007387ULL, 0x0003e40000100800ULL,
0x00001000010a7983ULL, 0x004ea20000100800ULL, 0x00008500ff087b82ULL, 0x000ee60000000800ULL,
0x0000040001097983ULL, 0x000f220000300800ULL, 0x0000000271057836ULL, 0x002fe20000000000ULL,
0x00000001187d7812ULL, 0x000fc600078e0cffULL, 0x00009000ff067b82ULL, 0x000e620000000a00ULL,
0x0000004008087824ULL, 0x008fe200078e00ffULL, 0x0000000a0500720cULL, 0x004fc60003f06070ULL,
0x0000000908057224ULL, 0x010fc800078e02ffULL, 0x0000008005067825ULL, 0x002fcc00078e0006ULL,
0x0000000c003c8947ULL, 0x000fea0003800000ULL, 0x0000080001087983ULL, 0x000ea20000100800ULL,
0x0000004000097824ULL, 0x000fc800078e00ffULL, 0x0000010009097836ULL, 0x000fe20000000000ULL,
0x00000003ff0c7819ULL, 0x000fc6000001165eULL, 0x00000100710b7824ULL, 0x000fe400078e0209ULL,
0x000000040c0e7836ULL, 0x000fe40000000000ULL, 0x0000000c0c127836ULL, 0x000fe40000000000ULL,
0x000000080c0a7836ULL, 0x000fe40000000000ULL, 0x000000010e057824ULL, 0x040fe400078e025eULL,
0x000000080e107824ULL, 0x000fc400078e00ffULL, 0x0000000112097824ULL, 0x140fe400078e025eULL,
0x0000000812147824ULL, 0x000fe400078e00ffULL, 0x000000080a237824ULL, 0x000fe400078e00ffULL,
0x000000100c1c7836ULL, 0x000fe20000000000ULL, 0xfffffff810217812ULL, 0x000fe400078ee205ULL,
0xfffffff814257812ULL, 0x000fe200078ee209ULL, 0x000000011c097824ULL, 0x000fc400078e025eULL,
0x000000081c107824ULL, 0x000fe400078e00ffULL, 0x000000105e057824ULL, 0x000fc600078e00ffULL,
0xfffffff810277812ULL, 0x000fe200078ee209ULL, 0x000000180c207836ULL, 0x000fe20000000000ULL,
0x0000007005057812ULL, 0x000fc600078ec0ffULL, 0x0000000820137824ULL, 0x000fe400078e00ffULL,
0x000000140c1e7836ULL, 0x000fe40000000000ULL, 0x000000010c167824ULL, 0x100fe400078e025eULL,
0x000000011e157824ULL, 0x040fe400078e025eULL, 0x000000081e147824ULL, 0x000fe200078e00ffULL,
0x00000007161f7812ULL, 0x000fc800078ec0ffULL, 0xfffffff814157812ULL, 0x000fe200078ee215ULL,
0x0000400000147824ULL, 0x000fe200078e0202ULL, 0x0ffffff81f1f7812ULL, 0x000fe200078ef85eULL,
0x000000200c227836ULL, 0x000fc80000000000ULL, 0x00000008222b7824ULL, 0x000fe200078e00ffULL,
0x0000000b08087248ULL, 0x004fca0007fe0000ULL, 0x00000001080b7824ULL, 0x000fe400078e0a0bULL,
0x000000010a087824ULL, 0x000fc600078e025eULL, 0x0000000b0e00720cULL, 0x000fe40003f46070ULL,
0xfffffff823237812ULL, 0x000fe200078ee208ULL, 0x0000000103087824ULL, 0x040fe400078e020cULL,
0x00000001030e7824ULL, 0x000fe400078e020eULL, 0x0000008008087825ULL, 0x000fc800078e00ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000508117212ULL, 0x000fe400078efcffULL,
0x0000000b1200720cULL, 0x000fe20003fa6070ULL, 0x0000000120087824ULL, 0x000fe200078e025eULL,
0x000000050e0d7212ULL, 0x000fe200078efcffULL, 0x0000000103127824ULL, 0x000fe200078e0212ULL,
0x0000001106107210ULL, 0x000fe40007f1e0ffULL, 0x0000000d060e7210ULL, 0x000fe40007f3e0ffULL,
0xfffffff8130d7812ULL, 0x000fe200078ee208ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000b1c00720cULL, 0x000fc60003f86070ULL, 0x0000000103087824ULL, 0x040fe400078e020aULL,
0x00000001031c7824ULL, 0x000fe200078e021cULL, 0x0000000512177212ULL, 0x000fe200078efcffULL,
0x0000000107117824ULL, 0x000fe400000e0609ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000001706167210ULL, 0x000fc60007fde0ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000000b0a00720cULL, 0x000fe40003f66070ULL, 0x00000005081b7212ULL, 0x000fe200078efcffULL,
0x00000001070f7824ULL, 0x000fe200008e060fULL, 0x0000000b0c00720cULL, 0x000fe20003f26070ULL,
0x000020007d0a7824ULL, 0x000fe200078e0214ULL, 0x000000051c197212ULL, 0x000fe200078efcffULL,
0x0000000103127824ULL, 0x000fe200078e021eULL, 0x0000001b061a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000107177824ULL, 0x000fe200030e0613ULL, 0x0000001906087210ULL, 0x000fe20007fde0ffULL,
0x000010000a0a7836ULL, 0x000fc40000000000ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x00000001071b7824ULL, 0x000fe400000e0609ULL, 0x000000101f197824ULL, 0x000fe400078e020aULL,
0x0000000107097824ULL, 0x000fe200030e061dULL, 0x00000005121d7212ULL, 0x000fe200078efcffULL,
0x0000000122127824ULL, 0x000fe200078e025eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010197faeULL, 0x0003e2000c901c46ULL, 0x00000001031c7824ULL, 0x000fe200078e0220ULL,
0x0000000b1e00720cULL, 0x000fe40003f06070ULL, 0xfffffff82b2b7812ULL, 0x000fc400078ee212ULL,
0x0000001d06107210ULL, 0x002fe20007fde0ffULL, 0x0000001c0c1e7836ULL, 0x000fc80000000000ULL,
0x0000000107117824ULL, 0x000fe400030e0613ULL, 0x000000801c127825ULL, 0x000fc800078e00ffULL,
0x0000001021197824ULL, 0x000fe200078e020aULL, 0x00000005121d7212ULL, 0x000fe200078efcffULL,
0x00000001031c7824ULL, 0x000fe200078e021eULL, 0x0000000b2000720cULL, 0x080fe20003f26070ULL,
0x000000011e1f7824ULL, 0x040fe200078e025eULL, 0x0000001d06127210ULL, 0x000fe20007fde0ffULL,
0x000000081e207824ULL, 0x000fe200078e00ffULL, 0x000000000e197faeULL, 0x0003e2000d101c46ULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000000b1e00720cULL, 0x000fc60003f46070ULL,
0x00000001031e7824ULL, 0x000fe200078e0222ULL, 0xfffffff820297812ULL, 0x000fe200078ee21fULL,
0x0000001023217824ULL, 0x000fe400078e020aULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x000000051c0f7212ULL, 0x002fc600078efcffULL, 0x000000240c207836ULL, 0x000fe20000000000ULL,
0x000000001a217faeULL, 0x0003e2000d901c46ULL, 0x0000000107137824ULL, 0x000fe200030e0613ULL,
0x0000000f060e7210ULL, 0x000fe20007fde0ffULL, 0x0000001025197824ULL, 0x000fe400078e020aULL,
0x00000001201c7824ULL, 0x040fe400078e025eULL, 0x0000000820237824ULL, 0x000fe200078e00ffULL,
0x0000000016197faeULL, 0x0005e2000e901c46ULL, 0x00000001070f7824ULL, 0x000fe200030e061dULL,
0x000000051e217212ULL, 0x002fe200078efcffULL, 0x00000001031b7824ULL, 0x000fc600078e0220ULL,
0x00000021061a7210ULL, 0x000fe40007fde0ffULL, 0xfffffff823217812ULL, 0x000fe200078ee21cULL,
0x000000801b167825ULL, 0x004fc800078e00ffULL, 0x000000280c1c7836ULL, 0x000fe20000000000ULL,
0x0000000516197212ULL, 0x000fe200078efcffULL, 0x00000010271d7824ULL, 0x000fe400078e020aULL,
0x000000011c1e7824ULL, 0x040fe400078e025eULL, 0x000000081c237824ULL, 0x000fe200078e00ffULL,
0x00000000081d7faeULL, 0x0003e2000e101c46ULL, 0x00000001071b7824ULL, 0x000fe200030e061fULL,
0x0000001906167210ULL, 0x000fe20007fde0ffULL, 0x0000000103197824ULL, 0x000fe200078e021cULL,
0xfffffff823237812ULL, 0x000fe200078ee21eULL, 0x0000001015157824ULL, 0x000fc400078e020aULL,
0x0000002c0c1e7836ULL, 0x000fe20000000000ULL, 0x0000000b2000720cULL, 0x080fe20003fa6070ULL,
0x000000300c207836ULL, 0x000fe20000000000ULL, 0x0000000b1c00720cULL, 0x080fe20003f86070ULL,
0x0000008019087825ULL, 0x002fe200078e00ffULL, 0x0000000b2200720cULL, 0x080fe20003f66070ULL,
0x0000000010157faeULL, 0x0003e4000c101c46ULL, 0x00000001031c7824ULL, 0x000fe200078e021eULL,
0x0000000b1e00720cULL, 0x040fe20003f06070ULL, 0x000000011e1f7824ULL, 0x000fc400078e025eULL,
0x000000081e227824ULL, 0x000fe200078e00ffULL, 0x0000000508197212ULL, 0x000fe200078efcffULL,
0x00000001031e7824ULL, 0x000fe400078e0220ULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0xfffffff822257812ULL, 0x000fc600078ee21fULL, 0x0000000107177824ULL, 0x000fe200030e0617ULL,
0x0000001906087210ULL, 0x000fe20007fde0ffULL, 0x000000100d0d7824ULL, 0x000fe400078e020aULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000000051c117212ULL, 0x002fe400078efcffULL,
0x00000000120d7faeULL, 0x0003e2000c901c46ULL, 0x0000000107097824ULL, 0x000fe200030e0609ULL,
0x0000000b2000720cULL, 0x040fe20003f26070ULL, 0x0000000120197824ULL, 0x000fe200078e025eULL,
0x000000051e157212ULL, 0x000fe200078efcffULL, 0x0000000820207824ULL, 0x000fe200078e00ffULL,
0x0000001106107210ULL, 0x000fe20007fde0ffULL, 0x000000340c1e7836ULL, 0x000fc60000000000ULL,
0xfffffff820277812ULL, 0x000fe200078ee219ULL, 0x0000000107117824ULL, 0x000fe400030e061dULL,
0x0000000103127824ULL, 0x002fe200078e021eULL, 0x00000015061c7210ULL, 0x000fe20007fde0ffULL,
0x000000380c207836ULL, 0x000fe40000000000ULL, 0x0000001029157824ULL, 0x100fe400078e020aULL,
0x000000102b0d7824ULL, 0x000fe400078e020aULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000000e157faeULL, 0x0003e6000d101c46ULL, 0x0000003c0c227836ULL, 0x000fe20000000000ULL,
0x000000001a0d7faeULL, 0x0005e2000d901c46ULL, 0x00000001030c7824ULL, 0x000fc400078e0220ULL,
0x00000001071d7824ULL, 0x000fe200030e061fULL, 0x00000005121f7212ULL, 0x000fe200078efcffULL,
0x0000001021197824ULL, 0x000fe200078e020aULL, 0x0000000b2000720cULL, 0x080fe20003f66070ULL,
0x00000001030e7824ULL, 0x002fe200078e0222ULL, 0x0000001f06127210ULL, 0x000fe40007fde0ffULL,
0x0000000016197faeULL, 0x0003e2000e901c46ULL, 0x000000800c0c7825ULL, 0x004fe200078e00ffULL,
0x0000000b1e00720cULL, 0x080fe40003fa6070ULL, 0x0000000b2200720cULL, 0x000fe20003f46070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000050c0b7212ULL, 0x000fc600078efcffULL,
0x0000000122177824ULL, 0x142fe400078e025eULL, 0x0000000822227824ULL, 0x000fe400078e00ffULL,
0x000000011e157824ULL, 0x140fe400078e025eULL, 0x0000000107137824ULL, 0x000fe200030e0613ULL,
0x0000000b060c7210ULL, 0x000fe20007fde0ffULL, 0x000000081e1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8221f7812ULL, 0x000fe200078ee217ULL, 0x0000000120167824ULL, 0x000fc400078e025eULL,
0x00000008201b7824ULL, 0x000fe200078e00ffULL, 0x000000050e177212ULL, 0x000fe200078efcffULL,
0x00000001070d7824ULL, 0x000fe200030e060dULL, 0xfffffff81e197812ULL, 0x000fe200078ee215ULL,
0x0000001023057824ULL, 0x100fe200078e020aULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee216ULL,
0x00000010250b7824ULL, 0x100fe200078e020aULL, 0x0000001706067210ULL, 0x000fe20007fde0ffULL,
0x0000001027157824ULL, 0x100fe200078e020aULL, 0x0000000008057faeULL, 0x0003e2000e101c46ULL,
0x0000001019177824ULL, 0x000fc400078e020aULL, 0x000000101b197824ULL, 0x100fe200078e020aULL,
0x00000000100b7faeULL, 0x0003e2000c101c46ULL, 0x000000101f1b7824ULL, 0x000fe400078e020aULL,
0x0000000107077824ULL, 0x000fe200030e060fULL, 0x000000001c157faeULL, 0x0003e8000c901c46ULL,
0x0000000012177faeULL, 0x0003e8000e901c46ULL, 0x000000000c197faeULL, 0x0003e8000d901c46ULL,
0x00000000061b7faeULL, 0x0003e2000d101c46ULL, 0x0000000800dc7947ULL, 0x000fea0003800000ULL,
0x000000085e0e7811ULL, 0x040fe400078fe8ffULL, 0x000000045e0a7811ULL, 0x040fe400078fe8ffULL,
0x000000105e117811ULL, 0x000fe200078fe8ffULL, 0x000000010e087824ULL, 0x100fe200078e025eULL,
0x000000145e127811ULL, 0x000fe200078fe8ffULL, 0x000000080e3b7824ULL, 0x000fe200078e00ffULL,
0x0000000c5e0f7811ULL, 0x000fe200078fe8ffULL, 0x000000010a057824ULL, 0x100fe200078e025eULL,
0x000000185e107811ULL, 0x000fe200078fe8ffULL, 0x000000080a0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee208ULL, 0x0000000111087824ULL, 0x140fe200078e025eULL,
0x000000205e1d7811ULL, 0x000fe200078fe8ffULL, 0x0000000811377824ULL, 0x000fe200078e00ffULL,
0xfffffff80c197812ULL, 0x000fe200078ee205ULL, 0x0000000112097824ULL, 0x100fe200078e025eULL,
0x000000245e1c7811ULL, 0x000fe200078fe8ffULL, 0x0000000812147824ULL, 0x000fe200078e00ffULL,
0x0000001c5e1e7811ULL, 0x000fe200078fe8ffULL, 0x000000010f057824ULL, 0x140fe200078e025eULL,
0xfffffff837377812ULL, 0x000fe200078ee208ULL, 0x000000080f0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff814357812ULL, 0x000fe200078ee209ULL, 0x00000001100b7824ULL, 0x100fe200078e025eULL,
0x000000285e1b7811ULL, 0x000fe200078fe8ffULL, 0x0000000810167824ULL, 0x000fe200078e00ffULL,
0xfffffff80c397812ULL, 0x000fe200078ee205ULL, 0x000000011d087824ULL, 0x140fe200078e025eULL,
0x000000305e247811ULL, 0x040fe200078fe8ffULL, 0x000000081d2f7824ULL, 0x000fe200078e00ffULL,
0x000000345e257811ULL, 0x000fe200078fe8ffULL, 0x000000011c097824ULL, 0x100fe200078e025eULL,
0x0000002c5e1a7811ULL, 0x000fe200078fe8ffULL, 0x000000081c147824ULL, 0x000fe200078e00ffULL,
0xfffffff816337812ULL, 0x000fe200078ee20bULL, 0x000000011e057824ULL, 0x140fe200078e025eULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee208ULL, 0x000000081e0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8142d7812ULL, 0x000fe200078ee209ULL, 0x000000011b0b7824ULL, 0x140fe200078e025eULL,
0x000000385e2c7811ULL, 0x000fe200078fe8ffULL, 0x000000081b167824ULL, 0x000fe200078e00ffULL,
0xfffffff80c317812ULL, 0x000fe200078ee205ULL, 0x0000000124087824ULL, 0x100fe200078e025eULL,
0x0000003c5e2e7811ULL, 0x000fe200078fe8ffULL, 0x0000000824137824ULL, 0x000fe200078e00ffULL,
0xfffffff8162b7812ULL, 0x000fe200078ee20bULL, 0x0000000125097824ULL, 0x000fc400078e025eULL,
0x0000000825147824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee208ULL,
0x000000011a057824ULL, 0x100fe200078e025eULL, 0x000000035e087211ULL, 0x000fe200078fe8ffULL,
0x000000081a0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff814277812ULL, 0x000fe200078ee209ULL,
0x000000012c0b7824ULL, 0x000fe200078e025eULL, 0x0000005e5e097211ULL, 0x000fe200078fe8ffULL,
0x000000082c167824ULL, 0x000fe200078e00ffULL, 0xfffffff80c297812ULL, 0x000fe200078ee205ULL,
0x000000105e057824ULL, 0x000fc400078e00ffULL, 0x0000400000147824ULL, 0x000fe200078e0202ULL,
0xfffffff816177812ULL, 0x000fe200078ee20bULL, 0x00000001030c7824ULL, 0x000fe200078e020aULL,
0x00000007090b7812ULL, 0x000fe200078ec0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000007005057812ULL, 0x000fe400078ec0ffULL, 0x0ffffff80b157812ULL, 0x000fe200078ef85eULL,
0x000020007d0a7824ULL, 0x000fe200078e0214ULL, 0x00000005080d7212ULL, 0x000fe200078efcffULL,
0x000000012e167824ULL, 0x000fc400078e025eULL, 0x000010000a2a7836ULL, 0x000fe20000000000ULL,
0x0000000d06087210ULL, 0x000fe20007f1e0ffULL, 0x000000800c0a7825ULL, 0x000fc800078e00ffULL,
0x000000082e1f7824ULL, 0x000fe200078e00ffULL, 0x000000050a0d7212ULL, 0x000fe200078efcffULL,
0x00000001030c7824ULL, 0x040fe400078e020eULL, 0x0000000103127824ULL, 0x000fe200078e0212ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee216ULL, 0x0000001015157824ULL, 0x000fe200078e022aULL,
0x0000000d060a7210ULL, 0x000fe20007f3e0ffULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x0000001019197824ULL, 0x100fe400078e022aULL, 0x000000103b3b7824ULL, 0x100fe400078e022aULL,
0x0000001039397824ULL, 0x100fe400078e022aULL, 0x0000001037377824ULL, 0x100fe400078e022aULL,
0x0000001035357824ULL, 0x100fe400078e022aULL, 0x0000001033337824ULL, 0x000fc400078e022aULL,
0x0000001031317824ULL, 0x100fe400078e022aULL, 0x000000102f2f7824ULL, 0x100fe400078e022aULL,
0x000000102d2d7824ULL, 0x100fe400078e022aULL, 0x000000102b2b7824ULL, 0x100fe400078e022aULL,
0x0000001029297824ULL, 0x100fe400078e022aULL, 0x0000001013287824ULL, 0x000fc400078e022aULL,
0x0000001027277824ULL, 0x100fe400078e022aULL, 0x0000001017267824ULL, 0x100fe400078e022aULL,
0x000000101f2a7824ULL, 0x000fe200078e022aULL, 0x000000050c1f7212ULL, 0x000fe200078efcffULL,
0x0000000103117824ULL, 0x000fe400078e0211ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000000109097824ULL, 0x000fe200000e0607ULL, 0x0000001f060c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000103167824ULL, 0x040fe200078e0210ULL, 0x00000005121f7212ULL, 0x000fe200078efcffULL,
0x00000001030f7824ULL, 0x000fe200078e020fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008157faeULL, 0x0003e2000b901c46ULL, 0x0000008011107825ULL, 0x000fc800078e00ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000000510237212ULL, 0x000fc600078efcffULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0x0000002306107210ULL, 0x000fc60007f5e0ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0607ULL, 0x0000001f06127210ULL, 0x000fe20007f1e0ffULL,
0x00000001031e7824ULL, 0x040fe200078e021eULL, 0x00000005161f7212ULL, 0x080fe200078efcffULL,
0x0000000103227824ULL, 0x040fe200078e021dULL, 0x000000050e217212ULL, 0x000fe200078efcffULL,
0x0000000103207824ULL, 0x000fe400078e021cULL, 0x000000801e1c7825ULL, 0x000fc800078e00ffULL,
0x0000008022227825ULL, 0x000fc800078e00ffULL, 0x0000000113137824ULL, 0x100fe200000e0607ULL,
0x0000001f06167210ULL, 0x000fe20007f1e0ffULL, 0x000000010b0b7824ULL, 0x000fe200008e0607ULL,
0x00000021060e7210ULL, 0x000fe20007f3e0ffULL, 0x00000001031e7824ULL, 0x000fe200078e021bULL,
0x000000051c1b7212ULL, 0x080fe200078efcffULL, 0x0000000117177824ULL, 0x100fe200000e0607ULL,
0x00000005223d7212ULL, 0x080fe200078efcffULL, 0x0000000103307824ULL, 0x000fe200078e021aULL,
0x0000001b061a7210ULL, 0x000fe20007f1e0ffULL, 0x000000010f0f7824ULL, 0x100fe200008e0607ULL,
0x0000003d061c7210ULL, 0x000fe20007f3e0ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x000000000a197faeULL, 0x0003e6000b901c46ULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x00000005203f7212ULL, 0x080fe200078efcffULL, 0x000000000c3b7faeULL, 0x0003e4000b901c46ULL,
0x000000011d1b7824ULL, 0x100fe200000e0607ULL, 0x000000051e437212ULL, 0x000fe200078efcffULL,
0x00000001231d7824ULL, 0x000fe200008e0607ULL, 0x0000003f06207210ULL, 0x000fe20007f1e0ffULL,
0x0000008030227825ULL, 0x000fe200078e00ffULL, 0x000000000e397faeULL, 0x0003e6000b901c46ULL,
0x00000001033e7824ULL, 0x000fc400078e0224ULL, 0x0000000103427824ULL, 0x040fe200078e0225ULL,
0x0000000522257212ULL, 0x080fe200078efcffULL, 0x00000001033c7824ULL, 0x000fe400078e022cULL,
0x0000000111117824ULL, 0x100fe200010e0607ULL, 0x00000043061e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000103247824ULL, 0x000fe400078e022eULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x0000000010377faeULL, 0x0003e6000b901c46ULL, 0x0000000121217824ULL, 0x100fe200000e0607ULL,
0x0000002506227210ULL, 0x000fe20007f1e0ffULL, 0x0000008042427825ULL, 0x000fe200078e00ffULL,
0x000000053e457212ULL, 0x080fe200078efcffULL, 0x0000000012357faeULL, 0x0003e4000b901c46ULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000000542477212ULL, 0x080fe200078efcffULL,
0x0000000016337faeULL, 0x0003e4000b901c46ULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x000000053c497212ULL, 0x080fe200078efcffULL, 0x000000001a317faeULL, 0x0003e2000b901c46ULL,
0x0000004706427210ULL, 0x000fe20007f3e0ffULL, 0x0000000123237824ULL, 0x100fe200000e0607ULL,
0x0000000524057212ULL, 0x000fe200078efcffULL, 0x000000011f1f7824ULL, 0x100fe200010e0607ULL,
0x00000045063e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000143437824ULL, 0x100fe200008e0607ULL,
0x00000049063c7210ULL, 0x000fe20007f5e0ffULL, 0x000000001c2f7faeULL, 0x0003e2000b901c46ULL,
0x0000000506067210ULL, 0x000fe20007f7e0ffULL, 0x000000013f3f7824ULL, 0x000fc400000e0607ULL,
0x000000013d3d7824ULL, 0x100fe200010e0607ULL, 0x00000000202d7faeULL, 0x0003e2000b901c46ULL,
0x0000000125077824ULL, 0x000fc600018e0607ULL, 0x000000001e2b7faeULL, 0x0003e8000b901c46ULL,
0x0000000022297faeULL, 0x0003e8000b901c46ULL, 0x000000003e287faeULL, 0x0003e8000b901c46ULL,
0x0000000042277faeULL, 0x0003e8000b901c46ULL, 0x000000003c267faeULL, 0x0003e8000b901c46ULL,
0x00000000062a7faeULL, 0x0003e4000b901c46ULL, 0x00000c0001077983ULL, 0x002ea20000100800ULL,
0x000000047a7a7836ULL, 0x000fe20000000000ULL, 0x00009600ff067b82ULL, 0x000e620000000800ULL,
0x0000000000057919ULL, 0x000e620000002700ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xfffffff85e697812ULL, 0x040fe200078ec0ffULL, 0x0000000605057224ULL, 0x002fe200078e02ffULL,
0x000000075e6f7812ULL, 0x000fe200078ec0ffULL, 0xffffffffff067424ULL, 0x000fe200078e00ffULL,
0x000000077a00720cULL, 0x004fe40003f06070ULL, 0x0000000000167805ULL, 0x000fc4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x00009200ff088b82ULL, 0x000e620000000a00ULL,
0x0000000205058824ULL, 0x000fe200078e027aULL, 0x0000000000307805ULL, 0x000fc4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000405088825ULL, 0x002fca00078e0008ULL,
0x0000000608068981ULL, 0x000ea2000c1e1900ULL, 0x000000205e057836ULL, 0x000fe20000000000ULL,
0x0000000769697812ULL, 0x000fe200078ef85eULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x000000086f707812ULL, 0x000fe400078ef85eULL, 0xfffffff805057812ULL, 0x000fc800078ec0ffULL,
0x0000000705057812ULL, 0x000fe200078ef85eULL, 0x0000040601007387ULL, 0x0043e40000100800ULL,
0x0000200018067824ULL, 0x002fe200078e0214ULL, 0x0000000000147805ULL, 0x000fc6000001ff00ULL,
0x0000100006067836ULL, 0x000fce0000000000ULL, 0x0000000169087824ULL, 0x140fe200078e0207ULL,
0x00000004ff0a7819ULL, 0x000fe2000001165eULL, 0x0000000869097824ULL, 0x040fe400078e00ffULL,
0x0000000107187836ULL, 0x000fe40000000000ULL, 0x00000008690b7824ULL, 0x000fe200078e00ffULL,
0xfffffff809097812ULL, 0x000fe200078ee208ULL, 0x0000000105087824ULL, 0x040fe400078e0207ULL,
0x00000008051b7824ULL, 0x000fc400078e00ffULL, 0x00000010090c7824ULL, 0x000fe400078e0206ULL,
0x0000000805097824ULL, 0x000fe400078e00ffULL, 0x0000001070197824ULL, 0x000fe400078e00ffULL,
0x000000000c0c783bULL, 0x000e620000000200ULL, 0xfffffff809097812ULL, 0x000fe200078ee208ULL,
0x0000000169087824ULL, 0x100fe400078e0218ULL, 0x0000000105187824ULL, 0x000fc400078e0218ULL,
0x0000001009107824ULL, 0x000fe200078e0206ULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee208ULL,
0x0000000207097824ULL, 0x000fe200078e020aULL, 0xfffffff81b187812ULL, 0x000fe200078ee218ULL,
0x00000010701a7824ULL, 0x040fe400078e00ffULL, 0x000000001010783bULL, 0x000ea20000000200ULL,
0x000000100b0b7824ULL, 0x100fe200078e0206ULL, 0x0000000270737810ULL, 0x140fe20007ffe009ULL,
0x00000001704a7824ULL, 0x000fe400078e0209ULL, 0x0000001018187824ULL, 0x000fe200078e0206ULL,
0xfffffff01a737812ULL, 0x000fe200078ee273ULL, 0x000000000b08783bULL, 0x000ee20000000200ULL,
0xfffffff0194a7812ULL, 0x000fe200078ee24aULL, 0x0000000207077836ULL, 0x000fc40000000000ULL,
0x000000001818783bULL, 0x000f260000000200ULL, 0x000000080700780cULL, 0x000fe40003f05270ULL,
0x00000010ff507819ULL, 0x102fe4000001160cULL, 0x0000ffff0c577812ULL, 0x040fe400078ec0ffULL,
0x00000018ff797819ULL, 0x000fe4000001160cULL, 0x000000ff0c787812ULL, 0x000fc400078ec0ffULL,
0x000000ff507c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7b7819ULL, 0x000fe40000011657ULL,
0x00000010ff3d7819ULL, 0x104fe40000011610ULL, 0x00000018ff627819ULL, 0x000fe40000011610ULL,
0x000000ff105f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff10457812ULL, 0x000fe200078ec0ffULL,
0x000000104a107824ULL, 0x000fe200078e0202ULL, 0x00000010ff467819ULL, 0x000fc40000011611ULL,
0x00000018ff5c7819ULL, 0x000fe40000011611ULL, 0x000000ff11587812ULL, 0x040fe400078ec0ffULL,
0x0000ffff11477812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3a7819ULL, 0x100fe40000011612ULL,
0x00000018ff527819ULL, 0x000fe40000011612ULL, 0x000000ff12517812ULL, 0x000fc400078ec0ffULL,
0x0000ffff123b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3c7819ULL, 0x100fe40000011613ULL,
0x00000018ff437819ULL, 0x000fe40000011613ULL, 0x000000ff13447812ULL, 0x040fe400078ec0ffULL,
0x0000ffff133e7812ULL, 0x000fe400078ec0ffULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x00000010ff4d7819ULL, 0x000fc4000001160fULL, 0x00000018ff667819ULL, 0x000fe4000001160fULL,
0x000000ff0f547812ULL, 0x040fe400078ec0ffULL, 0x0000ffff0f537812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4b7819ULL, 0x000fe4000001160eULL, 0x0000ffff0e4c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff397819ULL, 0x008fc40000011608ULL, 0x000000ff080f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff387819ULL, 0x000fe40000011609ULL, 0x00000010ff597819ULL, 0x100fe4000001160dULL,
0x00000018ff767819ULL, 0x000fe4000001160dULL, 0x000000ff0d747812ULL, 0x040fe400078ec0ffULL,
0x0000ffff0d5d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001160eULL,
0x000000ff0e4e7812ULL, 0x000fe400078ec0ffULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000010ff557819ULL, 0x000fe40000011608ULL,
0x0000ffff08617812ULL, 0x000fc400078ec0ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x00000010ff5a7819ULL, 0x000fe40000011609ULL,
0x000000ff090c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff095b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff567819ULL, 0x000fc4000001160aULL, 0x00000018ff0d7819ULL, 0x000fe4000001160aULL,
0x000000ff0a0e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff0a3f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff427819ULL, 0x100fe4000001160bULL, 0x00000018ff487819ULL, 0x000fe4000001160bULL,
0x000000ff0b497812ULL, 0x000fc400078ec0ffULL, 0x0000ffff0b087812ULL, 0x000fe400078ec0ffULL,
0x00000008ff657819ULL, 0x000fe40000011653ULL, 0x000000ff4b6d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6c7819ULL, 0x000fe4000001164cULL, 0x000000ff4d677812ULL, 0x000fe400078ec0ffULL,
0x000000ff3a537812ULL, 0x000fc400078ec0ffULL, 0x00000039ff09723eULL, 0x000fe400020006ffULL,
0x0000000fff0a723eULL, 0x000fe400020006ffULL, 0x00000038ff0b723eULL, 0x000fe400020006ffULL,
0x00000010ff0f7819ULL, 0x110fe40000011618ULL, 0x00000018ff4a7819ULL, 0x000fe40000011618ULL,
0x000000ff184b7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff18387812ULL, 0x000fe400078ec0ffULL,
0x00000010ff397819ULL, 0x100fe40000011619ULL, 0x00000018ff4c7819ULL, 0x000fe40000011619ULL,
0x000000ff194d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff193a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff59777812ULL, 0x000fc400078ec0ffULL, 0x00000008ff757819ULL, 0x000fe4000001165dULL,
0x000054107c197816ULL, 0x000fe40000000079ULL, 0x0000541078187816ULL, 0x000fe4000000007bULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x000000181034723cULL, 0x002fe20000001834ULL,
0x00000075ff75723eULL, 0x000fc400020006ffULL, 0x00000008ff607819ULL, 0x000fe40000011645ULL,
0x00000008ff577819ULL, 0x000fe4000001163bULL, 0x000000ff3c457812ULL, 0x000fe400078ec0ffULL,
0x0000541077197816ULL, 0x000fe40000000076ULL, 0x0000541074187816ULL, 0x000fe40000000075ULL,
0x00000010ff3b7819ULL, 0x000fc4000001161aULL, 0x00000018ff6b7819ULL, 0x000fe4000001161aULL,
0x000000ff1a6a7812ULL, 0x040fe200078ec0ffULL, 0x000000181030723cULL, 0x000fe20000001830ULL,
0x0000ffff1a3c7812ULL, 0x000fe200078ec0ffULL, 0x00000010731a7824ULL, 0x000fe200078e0202ULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fc400020006ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x000000ff465d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3d637812ULL, 0x000fe400078ec0ffULL,
0x00000008ff597819ULL, 0x000fe40000011647ULL, 0x00000008ff467819ULL, 0x000fe4000001163eULL,
0x000054106d4f7816ULL, 0x000fc4000000004fULL, 0x000054104e4e7816ULL, 0x000fe4000000006cULL,
0x00000010ff3e7819ULL, 0x100fe4000001161bULL, 0x00000018ff507819ULL, 0x000fe4000001161bULL,
0x000000ff1b3d7812ULL, 0x040fe200078ec0ffULL, 0x0000004e102c723cULL, 0x000fe2000000182cULL,
0x0000ffff1b477812ULL, 0x000fe400078ec0ffULL, 0x000000001a18783bULL, 0x000e620000000200ULL,
0x00000066ff66723eULL, 0x000fc400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x0000006aff4f723eULL, 0x000fe400020006ffULL, 0x000000ff556a7812ULL, 0x000fe400078ec0ffULL,
0x0000541067557816ULL, 0x000fc40000000066ULL, 0x0000541054547816ULL, 0x000fe40000000065ULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x000000541028723cULL, 0x000fe20000001828ULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000052ff52723eULL, 0x000fc400020006ffULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x0000541063557816ULL, 0x000fe40000000062ULL,
0x000054105f547816ULL, 0x000fe40000000060ULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x000000541024723cULL, 0x000fe20000001824ULL, 0x00000043ff43723eULL, 0x000fc400020006ffULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fc400020006ffULL,
0x0000541053537816ULL, 0x000fe40000000052ULL, 0x000054105d557816ULL, 0x000fe4000000005cULL,
0x0000541058547816ULL, 0x000fe40000000059ULL, 0x0000541051527816ULL, 0x000fe40000000057ULL,
0x0000541045457816ULL, 0x000fe40000000043ULL, 0x0000541044447816ULL, 0x000fe20000000046ULL,
0x000000541020723cULL, 0x000fe20000001820ULL, 0x00000008ff617819ULL, 0x000fc40000011661ULL,
0x0000006aff65723eULL, 0x000fe400020006ffULL, 0x00000061ff5f723eULL, 0x000fe200020006ffULL,
0x00000052101c723cULL, 0x000fe2000000181cULL, 0x0000541065097816ULL, 0x000fe40000000009ULL,
0x000000ff42427812ULL, 0x000fe400078ec0ffULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x000000441014723cULL, 0x000fe20000001814ULL, 0x00000049ff49723eULL, 0x000fc400020006ffULL,
0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5b7819ULL, 0x000fe4000001165bULL,
0x00000008ff117819ULL, 0x000fe40000011608ULL, 0x000054100a087816ULL, 0x000fe4000000005fULL,
0x00000042ff10723eULL, 0x000fe400020006ffULL, 0x000000ff0f0f7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff387819ULL, 0x000fe20000011638ULL, 0x000000081834723cULL, 0x002fe20000001834ULL,
0x0000000cff0c723eULL, 0x000fe400020006ffULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x00000011ff08723eULL, 0x000fe400020006ffULL,
0x0000541010097816ULL, 0x000fc40000000048ULL, 0x0000541049087816ULL, 0x000fe40000000008ULL,
0x0000005aff55723eULL, 0x000fe400020006ffULL, 0x0000005bff54723eULL, 0x000fe400020006ffULL,
0x0000000fff0f723eULL, 0x000fe200020006ffULL, 0x000000081828723cULL, 0x000fe20000001828ULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x00005410550b7816ULL, 0x000fc4000000000bULL,
0x000054100c0a7816ULL, 0x000fe40000000054ULL, 0x000054100f097816ULL, 0x000fe4000000004aULL,
0x000054104b087816ULL, 0x000fe40000000038ULL, 0x000000ff56567812ULL, 0x000fe200078ec0ffULL,
0x0000000a1830723cULL, 0x000fe20000001830ULL, 0x00000008ff3f7819ULL, 0x000fe4000001163fULL,
0x000000ff39397812ULL, 0x000fc400078ec0ffULL, 0x00000008ff3a7819ULL, 0x000fe2000001163aULL,
0x000000081824723cULL, 0x000fe20000001824ULL, 0x000000ff3b3b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3c7819ULL, 0x000fe4000001163cULL, 0x000000ff3e3e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff477819ULL, 0x000fe40000011647ULL, 0x0000000dff0d723eULL, 0x000fc400020006ffULL,
0x0000000eff0e723eULL, 0x000fe400020006ffULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x0000006bff4e723eULL, 0x000fe400020006ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x00000056ff51723eULL, 0x000fc400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x00000039ff39723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x0000003bff0a723eULL, 0x000fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x0000003dff08723eULL, 0x000fc400020006ffULL,
0x0000003eff09723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00005410510d7816ULL, 0x000fe4000000000dULL, 0x000054100e0c7816ULL, 0x000fe4000000003fULL,
0x00005410393b7816ULL, 0x000fe4000000004cULL, 0x000054104d3a7816ULL, 0x000fc4000000003aULL,
0x000054100a3d7816ULL, 0x000fe2000000004eULL, 0x0000000c182c723cULL, 0x000fe2000000182cULL,
0x000054104f3c7816ULL, 0x000fe4000000003cULL, 0x0000541009097816ULL, 0x000fe40000000050ULL,
0x0000541008087816ULL, 0x000fe20000000047ULL, 0x0000003a1820723cULL, 0x000fec0000001820ULL,
0x0000003c181c723cULL, 0x000fec000000181cULL, 0x000000081814723cULL, 0x000fe20000001814ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff0002c0947ULL, 0x000fde000383ffffULL,
0x00000001ff077424ULL, 0x000fe400078e00ffULL, 0x0000000434097220ULL, 0x080fe20000410000ULL,
0x0000000435357220ULL, 0x080fe20000410000ULL, 0x0000000436367220ULL, 0x080fe20000410000ULL,
0x0000000437377220ULL, 0x080fe20000410000ULL, 0x0000000430307220ULL, 0x080fe20000410000ULL,
0x01768807680679a7ULL, 0x000e62000850003fULL, 0x0000000431317220ULL, 0x080fe20000410000ULL,
0x0000000432327220ULL, 0x080fe20000410000ULL, 0x0000000433337220ULL, 0x080fe20000410000ULL,
0x000000042c2c7220ULL, 0x080fe20000410000ULL, 0x000000042d2d7220ULL, 0x080fe20000410000ULL,
0x000000042e2e7220ULL, 0x080fe20000410000ULL, 0x000000042f2f7220ULL, 0x080fe20000410000ULL,
0x0000000428287220ULL, 0x080fe20000410000ULL, 0x0000000429297220ULL, 0x080fe20000410000ULL,
0x000000042a2a7220ULL, 0x080fe20000410000ULL, 0x000000042b2b7220ULL, 0x080fe20000410000ULL,
0x0000000424247220ULL, 0x080fe20000410000ULL, 0x0000000425257220ULL, 0x080fe20000410000ULL,
0x0000000426267220ULL, 0x080fe20000410000ULL, 0x0000000427277220ULL, 0x080fe20000410000ULL,
0x0000000420207220ULL, 0x080fe20000410000ULL, 0x0000000421217220ULL, 0x080fe20000410000ULL,
0x0000000422227220ULL, 0x080fe20000410000ULL, 0x0000000423237220ULL, 0x080fe20000410000ULL,
0x000000041c1c7220ULL, 0x080fe20000410000ULL, 0x000000041d1d7220ULL, 0x080fe20000410000ULL,
0x000000041e117220ULL, 0x080fe20000410000ULL, 0x000000041f127220ULL, 0x080fe20000410000ULL,
0x0000000414087220ULL, 0x080fe20000410000ULL, 0x0000000415187220ULL, 0x080fe20000410000ULL,
0x0000000416107220ULL, 0x080fe20000410000ULL, 0x0000000417137220ULL, 0x000fe20000410000ULL,
0x00000000000a7805ULL, 0x000fe20000015200ULL, 0x01768807680075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0e7224ULL, 0x000fce00078e00ffULL,
0x000000100e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140dULL,
0x0000000c05057211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e060dULL,
0x0000000205057819ULL, 0x000fc8000000120cULL, 0x000000050000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010e0e7836ULL, 0x000fce0000000000ULL,
0x01768807680075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00001400010c7983ULL, 0x000ea20000100800ULL, 0x000000045e057824ULL, 0x000fe400078e00ffULL,
0x0000008000067824ULL, 0x000fc600078e0202ULL, 0xfffffff005057812ULL, 0x000fca00078ec0ffULL,
0x0000000106057824ULL, 0x000fca00078e0205ULL, 0x0174000005147984ULL, 0x0002620000000c00ULL,
0x0000000c7100720cULL, 0x004fda0003f06070ULL, 0x0000001400308947ULL, 0x002fea0003800000ULL,
0x0000180001197983ULL, 0x000ea20000100800ULL, 0x0000860000047ab9ULL, 0x000fc60000000800ULL,
0x00000800010f7983ULL, 0x000ee20000100800ULL, 0x00000004000a7d06ULL, 0x000e620008209000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00000004ff007c0cULL, 0x000fe2000bf85070ULL,
0x000000025e1a7824ULL, 0x000fca00078e00ffULL, 0x000000061a1a7812ULL, 0x000fca00078ec0ffULL,
0x000000011a1e7824ULL, 0x000fe200078e0264ULL, 0x0000000a000a7308ULL, 0x002e640000001000ULL,
0x0ffffffe0a0c7836ULL, 0x002fcc0000000000ULL, 0x0000000c00077305ULL, 0x000e64000021f000ULL,
0x000000ffff0b7224ULL, 0x002fc800078e0a07ULL, 0x000000040b0b7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000b070d7227ULL, 0x000fe200078e0006ULL, 0x000000101a1b7812ULL, 0x040fe400078efcffULL,
0x000000201a3a7812ULL, 0x000fc600078efcffULL, 0x000000011b347824ULL, 0x000fe400078e0264ULL,
0x00000001723e7824ULL, 0x000fe400078e023aULL, 0x000000013a3c7824ULL, 0x000fe200078e0264ULL,
0x000000301a427812ULL, 0x000fca00078efcffULL, 0x0000000172507824ULL, 0x000fe400078e0242ULL,
0x0000000142467824ULL, 0x000fe200078e0264ULL, 0x000000195e067211ULL, 0x004fe200078ff0ffULL,
0x0000004000197824ULL, 0x000fc800078e00ffULL, 0x000000060d077227ULL, 0x000fc800078e00ffULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a07ULL, 0x0000010071197824ULL, 0x000fe400078e0219ULL,
0x000000040b0a7c24ULL, 0x000fe4000f8e0206ULL, 0x0000000806067836ULL, 0x000fc60000000000ULL,
0x000000040a007c0cULL, 0x000fe2000bf06070ULL, 0x000000060d0c7227ULL, 0x000fc800078e00ffULL,
0x000000ffff0b7224ULL, 0x000fc800078e0a0cULL, 0x000000040b0b7c24ULL, 0x000fe2000f8e0206ULL,
0x000000190f067248ULL, 0x008fe40007fe0000ULL, 0x00000004ff0f7c12ULL, 0x000fe2000f8e33ffULL,
0x800000040a0a0c36ULL, 0x000fe20008000000ULL, 0x000000040b007c0cULL, 0x000fe2000bf46070ULL,
0x0000000106197824ULL, 0x000fe400078e0a19ULL, 0x0000000107070836ULL, 0x000fe20000000000ULL,
0x000000040a007c0cULL, 0x000fe2000bf26070ULL, 0x0000000172067824ULL, 0x000fc400078e021aULL,
0x000000ffff4b7224ULL, 0x000fc600078e0a19ULL, 0x000000190600720cULL, 0x000fe40003f66070ULL,
0x0000004b06067246ULL, 0x000fe2000380006eULL, 0x800000040b0b2c36ULL, 0x000fe20008000000ULL,
0x0000004b1e457246ULL, 0x000fe2000380006eULL, 0x000000010c0c2836ULL, 0x000fe20000000000ULL,
0x00000004ff067819ULL, 0x000fe20000011606ULL, 0x0000000107071836ULL, 0x000fe20000000000ULL,
0x000000040b007c0cULL, 0x000fe4000bf06070ULL, 0x000000ff060d7207ULL, 0x000fc40001800000ULL,
0x000000070f077207ULL, 0x000fe40006000000ULL, 0x000000191e00720cULL, 0x000fe40003f26070ULL,
0x000000076e077248ULL, 0x000fe40003fe0000ULL, 0x000000ff45457207ULL, 0x000fc60000800000ULL,
0x00000005074c7c24ULL, 0x000fe4000f8e02ffULL, 0x000000010c0c0836ULL, 0x000fe40000000000ULL,
0x000000014c077824ULL, 0x000fe200078e020dULL, 0x0000004c450b7211ULL, 0x000fe400078fe0ffULL,
0x0000000c0f0f7207ULL, 0x000fe20006000000ULL, 0x0000000207067825ULL, 0x000fc600078e0040ULL,
0x0000000f6e0f7248ULL, 0x000fe20003fe0000ULL, 0x000000020b0a7825ULL, 0x000fe200078e0040ULL,
0x0000000606497981ULL, 0x0002a6000c1e9500ULL, 0x000000050f4e7c24ULL, 0x000fe2000f8e02ffULL,
0x000000060a4a7981ULL, 0x0006a6000c1e9500ULL, 0x000000010d0d7824ULL, 0x000fe200078e024eULL,
0x0000004e450f7211ULL, 0x000fe200078fe0ffULL, 0x0000000172067824ULL, 0x002fe200078e021bULL,
0x000000193400720cULL, 0x000fe20003f06070ULL, 0x000000020d0c7825ULL, 0x000fc600078e0040ULL,
0x0000004b06077246ULL, 0x000fe2000380006eULL, 0x000000020f0e7825ULL, 0x000fe200078e0040ULL,
0x000000190600720cULL, 0x000fe20003f26070ULL, 0x000000060c477981ULL, 0x000f22000c1e9500ULL,
0x00000004ff077819ULL, 0x000fe40000011607ULL, 0x0000004b341f7246ULL, 0x000fe2000380006eULL,
0x000000060e527981ULL, 0x000322000c1e9500ULL, 0x000000ff073b7207ULL, 0x000fe40000800000ULL,
0x000000ff1f1f7207ULL, 0x000fc60000000000ULL, 0x000000014c077824ULL, 0x000fe200078e023bULL,
0x0000004c1f0b7211ULL, 0x008fc600078fe0ffULL, 0x0000000207067825ULL, 0x000fe200078e0040ULL,
0x0000004e1f0f7211ULL, 0x002fe400078fe0ffULL, 0x0000004b3e3d7246ULL, 0x000fe2000380006eULL,
0x000000013b0d7824ULL, 0x000fe200078e024eULL, 0x0000000606387981ULL, 0x0002e2000c1e9500ULL,
0x000000020b0a7825ULL, 0x100fe200078e0040ULL, 0x000000193e00720cULL, 0x080fe40003f26070ULL,
0x000000193c00720cULL, 0x000fe20003f06070ULL, 0x000000020d0c7825ULL, 0x100fe200078e0040ULL,
0x000000060a397981ULL, 0x000ae6000c1e9500ULL, 0x000000020f0e7825ULL, 0x000fe200078e0040ULL,
0x00000004ff067819ULL, 0x002fe2000001163dULL, 0x000000060c3b7981ULL, 0x0002e2000c1e9500ULL,
0x0000004b3c3d7246ULL, 0x000fc4000380006eULL, 0x000000ff06437207ULL, 0x000fe20000800000ULL,
0x000000060e3e7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff3d3d7207ULL, 0x000fe40000000000ULL,
0x0000004b504d7246ULL, 0x000fe2000380006eULL, 0x000000014c077824ULL, 0x000fe200078e0243ULL,
0x0000004c3d0b7211ULL, 0x020fe200078fe0ffULL, 0x00000001430d7824ULL, 0x002fe200078e024eULL,
0x0000004e3d0f7211ULL, 0x000fe200078fe0ffULL, 0x0000000207067825ULL, 0x000fe200078e0040ULL,
0x000000195000720cULL, 0x000fc40003f26070ULL, 0x00000004ff4d7819ULL, 0x000fe2000001164dULL,
0x000000020b0a7825ULL, 0x100fe200078e0040ULL, 0x000000194600720cULL, 0x000fe20003f06070ULL,
0x00000006063f7981ULL, 0x000362000c1e9500ULL, 0x0000004b464b7246ULL, 0x000fe2000380006eULL,
0x000000020d0c7825ULL, 0x100fe200078e0040ULL, 0x000000ff4d4d7207ULL, 0x000fe20000800000ULL,
0x000000060a447981ULL, 0x000364000c1e9500ULL, 0x000000020f0e7825ULL, 0x000fe200078e0040ULL,
0x000000ff4b4b7207ULL, 0x000fe20000000000ULL, 0x000000060c437981ULL, 0x000368000c1e9500ULL,
0x000000060e487981ULL, 0x000364000c1e9500ULL, 0x000000014c077824ULL, 0x002fe200078e024dULL,
0x0000004c4b0b7211ULL, 0x000fc600078fe0ffULL, 0x0000000207067825ULL, 0x000fc800078e0040ULL,
0x000000020b0a7825ULL, 0x000fe400078e0040ULL, 0x0000000606067981ULL, 0x000362000c1e9500ULL,
0x0000004e4b0d7211ULL, 0x000fc600078fe0ffULL, 0x000000060a0b7981ULL, 0x000362000c1e9500ULL,
0x000000014d0f7824ULL, 0x000fe400078e024eULL, 0x000000020d0c7825ULL, 0x000fc800078e0040ULL,
0x000000020f0e7825ULL, 0x000fe400078e0040ULL, 0x000000060c0c7981ULL, 0x000f68000c1e9500ULL,
0x000000060e0f7981ULL, 0x000362000c1e9500ULL, 0xfffffff0454c7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff457424ULL, 0x000fc800078e00ffULL, 0x0000000119077824ULL, 0x002fc800078e024cULL,
0x000000011e547824ULL, 0x100fe200078e0a07ULL, 0x000000081a4c7812ULL, 0x040fe400078efcffULL,
0x000000091a0a7812ULL, 0x000fe400078efcffULL, 0x0000005445547219ULL, 0x000fe200000006ffULL,
0x000000014c507824ULL, 0x100fe400078e0264ULL, 0x000000010a0e7824ULL, 0x000fe400078e0264ULL,
0x0000000150587824ULL, 0x000fc400078e0a07ULL, 0x000000010e5a7824ULL, 0x000fe200078e0a07ULL,
0x000000181a667812ULL, 0x000fe400078efcffULL, 0xfffffff01f787812ULL, 0x000fe400078ec0ffULL,
0x0000005845587219ULL, 0x040fe400000006ffULL, 0x0000005a455a7219ULL, 0x000fe200000006ffULL,
0x0000000166707824ULL, 0x000fe400078e0264ULL, 0x00000001194f7824ULL, 0x000fe200078e0278ULL,
0x000000111a6a7812ULL, 0x000fc600078efcffULL, 0x00000001704d7824ULL, 0x000fe200078e0a4fULL,
0x000000191a627812ULL, 0x000fe400078efcffULL, 0xfffffff03d7c7812ULL, 0x000fe400078ec0ffULL,
0x0000004d454d7219ULL, 0x000fe400000006ffULL, 0xfffffff04b4b7812ULL, 0x000fe200078ec0ffULL,
0x000000016a747824ULL, 0x100fe400078e0264ULL, 0x00000001626c7824ULL, 0x000fc400078e0264ULL,
0x0000000119557824ULL, 0x000fe200078e027cULL, 0x000000211a5c7812ULL, 0x000fc600078efcffULL,
0x000000013c517824ULL, 0x000fe400078e0a55ULL, 0x000000015c607824ULL, 0x000fc600078e0264ULL,
0x0000005145517219ULL, 0x000fe200000006ffULL, 0x0000000160577824ULL, 0x000fca00078e0a55ULL,
0x0000005745577219ULL, 0x000fe400000006ffULL, 0x000054104a497816ULL, 0x004fe40000000049ULL,
0x000000011a4a7812ULL, 0x000fe400078efcffULL, 0x0000004954ff7212ULL, 0x000fc6000780c0ffULL,
0x000000014a4e7824ULL, 0x000fe200078e0264ULL, 0x000000191e00720cULL, 0x000fc60000701470ULL,
0x000000014e567824ULL, 0x000fe200078e0a07ULL, 0x000000191a00720cULL, 0x000fe400007a1070ULL,
0x0000541052477816ULL, 0x010fe40000000047ULL, 0x0000005645567219ULL, 0x000fe400000006ffULL,
0xff80000009097808ULL, 0x000fe40002800000ULL, 0x0000004754ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004758ff7212ULL, 0x000fc400078cc0ffULL, 0x000000475aff7212ULL, 0x000fe400078ac0ffULL,
0x0000004956ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004958ff7212ULL, 0x080fe4000786c0ffULL,
0x000000495aff7212ULL, 0x000fe2000788c0ffULL, 0x0000000134497824ULL, 0x000fe200078e0a4fULL,
0x000000191e00720cULL, 0x080fe40001741470ULL, 0x000000195000720cULL, 0x000fc400037c1470ULL,
0x000000190e00720cULL, 0x080fe40002fa1470ULL, 0x000000191a00720cULL, 0x080fe40001741070ULL,
0x000000194c00720cULL, 0x080fe400037c1070ULL, 0x000000190a00720cULL, 0x000fe40002fa1070ULL,
0x0000004945497219ULL, 0x000fe400000006ffULL, 0x0000541039387816ULL, 0x008fc40000000038ULL,
0x000054103e3e7816ULL, 0x000fe4000000003bULL, 0xff80000036367808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fe40003000000ULL, 0xff80000033337808ULL, 0x000fe40002800000ULL,
0x0000004756ff7212ULL, 0x000fe4000780c0ffULL, 0x0000003849ff7212ULL, 0x000fc4000784c0ffULL,
0x0000003e49ff7212ULL, 0x080fe400078cc0ffULL, 0x0000003e4dff7212ULL, 0x000fe200078ac0ffULL,
0x0000000119477824ULL, 0x000fe200078e024bULL, 0x000000194e00720cULL, 0x080fe20000f21470ULL,
0x00000001744b7824ULL, 0x100fe200078e0a4fULL, 0x000000194e00720cULL, 0x080fe20000701470ULL,
0x000000016c4f7824ULL, 0x000fe200078e0a4fULL, 0x000000195000720cULL, 0x080fe40001f61470ULL,
0x000000190e00720cULL, 0x000fc40002781470ULL, 0x000000193400720cULL, 0x0c0fe40001741470ULL,
0x000000193400720cULL, 0x080fe400037c1470ULL, 0x000000197000720cULL, 0x080fe40002fa1470ULL,
0x000000281a5a7812ULL, 0x040fe400078efcffULL, 0x000000291a587812ULL, 0x000fe400078efcffULL,
0x000000194a00720cULL, 0x000fc40000f21070ULL, 0x000000194a00720cULL, 0x080fe40000701070ULL,
0x000000194c00720cULL, 0x080fe40001f61070ULL, 0x000000190a00720cULL, 0x080fe40002781070ULL,
0x000000191b00720cULL, 0x0c0fe40001741070ULL, 0x000000191b00720cULL, 0x080fe400037c1070ULL,
0x000000196600720cULL, 0x000fc40002fa1070ULL, 0x0000004b454b7219ULL, 0x040fe400000006ffULL,
0x0000004f454f7219ULL, 0x000fe400000006ffULL, 0x0000541044447816ULL, 0x020fe4000000003fULL,
0x0000541048487816ULL, 0x000fe20000000043ULL, 0x000000015a767824ULL, 0x100fe200078e0264ULL,
0xff80000035357808ULL, 0x000fe20000800000ULL, 0x0000000158787824ULL, 0x000fe200078e0264ULL,
0xff80000037377808ULL, 0x000fc40000000000ULL, 0xff80000030307808ULL, 0x000fe40001800000ULL,
0xff80000031317808ULL, 0x000fe40002000000ULL, 0xff8000002c2c7808ULL, 0x000fe40001000000ULL,
0xff8000002e2e7808ULL, 0x000fe40003000000ULL, 0xff8000002a2a7808ULL, 0x000fe40002800000ULL,
0x000000384bff7212ULL, 0x000fc4000782c0ffULL, 0x000000384dff7212ULL, 0x080fe4000780c0ffULL,
0x000000384fff7212ULL, 0x000fe4000786c0ffULL, 0x0000003e4bff7212ULL, 0x080fe4000788c0ffULL,
0x0000003e4fff7212ULL, 0x000fe4000784c0ffULL, 0x0000004451ff7212ULL, 0x040fe400078cc0ffULL,
0x0000004851ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000176597824ULL, 0x100fe200078e0a55ULL,
0x000000197400720cULL, 0x080fe20000f21470ULL, 0x0000000178557824ULL, 0x000fe200078e0a55ULL,
0x000000197400720cULL, 0x080fe20002781470ULL, 0x0000000146537824ULL, 0x000fe200078e0a47ULL,
0x000000197000720cULL, 0x000fc40000701470ULL, 0x000000196c00720cULL, 0x0c0fe40001f61470ULL,
0x000000196c00720cULL, 0x080fe40001741470ULL, 0x000000193c00720cULL, 0x0c0fe400037c1470ULL,
0x000000193c00720cULL, 0x000fe40002fa1470ULL, 0x000000311a567812ULL, 0x040fe400078efcffULL,
0x000000381a547812ULL, 0x000fc400078efcffULL, 0x000000391a527812ULL, 0x000fe400078efcffULL,
0x000000196a00720cULL, 0x0c0fe40000f21070ULL, 0x000000196a00720cULL, 0x080fe40002781070ULL,
0x000000196600720cULL, 0x080fe40000701070ULL, 0x000000196200720cULL, 0x0c0fe40001f61070ULL,
0x000000196200720cULL, 0x000fc40001741070ULL, 0x000000193a00720cULL, 0x0c0fe400037c1070ULL,
0x000000193a00720cULL, 0x000fe40002fa1070ULL, 0x0000005945597219ULL, 0x040fe400000006ffULL,
0x0000005545557219ULL, 0x040fe400000006ffULL, 0x0000005345537219ULL, 0x000fe400000006ffULL,
0x000054100b067816ULL, 0x000fe20000000006ULL, 0x00000001567c7824ULL, 0x100fe200078e0264ULL,
0xff8000002d2d7808ULL, 0x000fe20000800000ULL, 0x0000000154077824ULL, 0x100fe200078e0264ULL,
0xff8000002f2f7808ULL, 0x000fe20002000000ULL, 0x00000001520d7824ULL, 0x000fe200078e0264ULL,
0xff80000028287808ULL, 0x000fc40000000000ULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff80000024247808ULL, 0x000fe40003000000ULL,
0xff80000026267808ULL, 0x000fe40002800000ULL, 0x0000004457ff7212ULL, 0x080fe4000782c0ffULL,
0x0000004459ff7212ULL, 0x000fc4000788c0ffULL, 0x0000004455ff7212ULL, 0x000fe4000780c0ffULL,
0x0000004857ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004859ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004855ff7212ULL, 0x000fe400078cc0ffULL, 0x0000000653ff7212ULL, 0x000fe200078ac0ffULL,
0x000000017c1f7824ULL, 0x100fe200078e0a47ULL, 0x000000196000720cULL, 0x0c0fe20000f21470ULL,
0x00000001073d7824ULL, 0x100fe200078e0a47ULL, 0x000000196000720cULL, 0x080fe20001f61470ULL,
0x000000010d477824ULL, 0x000fe200078e0a47ULL, 0x000000197600720cULL, 0x000fc40002781470ULL,
0x000000197600720cULL, 0x080fe40001741470ULL, 0x000000197800720cULL, 0x0c0fe40000701470ULL,
0x000000197800720cULL, 0x080fe400037c1470ULL, 0x000000194600720cULL, 0x080fe40002fa1470ULL,
0x000000195c00720cULL, 0x0c0fe40000f21070ULL, 0x000000195c00720cULL, 0x000fc40001f61070ULL,
0x000000195a00720cULL, 0x0c0fe40002781070ULL, 0x000000195a00720cULL, 0x080fe40001741070ULL,
0x000000195800720cULL, 0x0c0fe40000701070ULL, 0x000000195800720cULL, 0x080fe400037c1070ULL,
0x000000194200720cULL, 0x000fe40002fa1070ULL, 0x0000001f451f7219ULL, 0x000fc400000006ffULL,
0x0000003d453d7219ULL, 0x040fe400000006ffULL, 0x0000004745477219ULL, 0x000fe400000006ffULL,
0x000054100c0c7816ULL, 0x000fe4000000000fULL, 0xff80000025257808ULL, 0x000fe40000800000ULL,
0xff80000027277808ULL, 0x000fe40001800000ULL, 0xff80000020207808ULL, 0x000fc40002000000ULL,
0xff80000022227808ULL, 0x000fe40001000000ULL, 0xff80000021217808ULL, 0x000fe40000000000ULL,
0xff80000023237808ULL, 0x000fe40003000000ULL, 0xff8000001c1c7808ULL, 0x000fe40002800000ULL,
0x000000061fff7212ULL, 0x080fe4000782c0ffULL, 0x000000063dff7212ULL, 0x000fc4000786c0ffULL,
0x0000000647ff7212ULL, 0x000fe4000788c0ffULL, 0x0000000c53ff7212ULL, 0x080fe4000784c0ffULL,
0x0000000c1fff7212ULL, 0x080fe4000780c0ffULL, 0x0000000c3dff7212ULL, 0x080fe400078cc0ffULL,
0x0000000c47ff7212ULL, 0x000fe400078ac0ffULL, 0x000000194600720cULL, 0x000fc40001741470ULL,
0x000000197c00720cULL, 0x0c0fe40000f21470ULL, 0x000000197c00720cULL, 0x080fe40000701470ULL,
0x000000190700720cULL, 0x0c0fe40001f61470ULL, 0x000000190700720cULL, 0x080fe400037c1470ULL,
0x000000190d00720cULL, 0x0c0fe40002781470ULL, 0x000000190d00720cULL, 0x000fc40002fa1470ULL,
0x000000194200720cULL, 0x080fe40001741070ULL, 0x000000195600720cULL, 0x0c0fe40000f21070ULL,
0x000000195600720cULL, 0x080fe40000701070ULL, 0x000000195400720cULL, 0x0c0fe40001f61070ULL,
0x000000195400720cULL, 0x080fe400037c1070ULL, 0x000000195200720cULL, 0x000fc40002781070ULL,
0x000000195200720cULL, 0x000fe40002fa1070ULL, 0xff8000001d1d7808ULL, 0x000fe40000800000ULL,
0xff80000008087808ULL, 0x000fe40001800000ULL, 0xff80000018187808ULL, 0x000fe40002000000ULL,
0xff80000011117808ULL, 0x000fe40001000000ULL, 0xff80000012127808ULL, 0x000fc40000000000ULL,
0xff80000010107808ULL, 0x000fe40003000000ULL, 0xff80000013137808ULL, 0x000fce0002800000ULL,
0x000000091400720bULL, 0x000fe20003f1e000ULL, 0x0000100001387983ULL, 0x000ee60000100800ULL,
0x0000001409147208ULL, 0x000fe20004000000ULL, 0x0000000001397983ULL, 0x000f260000100800ULL,
0x000000351400720bULL, 0x000fc80003f1e000ULL, 0x0000001435077208ULL, 0x000fc80004000000ULL,
0x000000300700720bULL, 0x000fc80003f1e000ULL, 0x0000000730067208ULL, 0x000fc80004000000ULL,
0x000000310600720bULL, 0x000fc80003f1e000ULL, 0x0000000631077208ULL, 0x000fc80004000000ULL,
0x0000002c0700720bULL, 0x000fc80003f1e000ULL, 0x000000072c067208ULL, 0x000fc80004000000ULL,
0x0000002d0600720bULL, 0x000fc80003f1e000ULL, 0x000000062d077208ULL, 0x000fc80004000000ULL,
0x000000280700720bULL, 0x000fc80003f1e000ULL, 0x0000000728067208ULL, 0x000fc80004000000ULL,
0x000000290600720bULL, 0x000fc80003f1e000ULL, 0x0000000629077208ULL, 0x000fc80004000000ULL,
0x000000240700720bULL, 0x000fc80003f1e000ULL, 0x0000000724067208ULL, 0x000fc80004000000ULL,
0x000000250600720bULL, 0x000fc80003f1e000ULL, 0x0000000625077208ULL, 0x000fc80004000000ULL,
0x000000200700720bULL, 0x000fc80003f1e000ULL, 0x0000000720067208ULL, 0x000fe40004000000ULL,
0x000000361500720bULL, 0x000fe40003f1e000ULL, 0x000000210600720bULL, 0x000fc80003f3e000ULL,
0x0000000621077208ULL, 0x000fe40004800000ULL, 0x0000001536067208ULL, 0x000fe40004000000ULL,
0x0000001c0700720bULL, 0x000fe40003f3e000ULL, 0x000000370600720bULL, 0x000fe40003f1e000ULL,
0x000000071c0a7208ULL, 0x000fe40004800000ULL, 0x0000000637077208ULL, 0x000fc80004000000ULL,
0x000000320700720bULL, 0x000fc80003f1e000ULL, 0x0000000732067208ULL, 0x000fc80004000000ULL,
0x000000330600720bULL, 0x000fc80003f1e000ULL, 0x0000000633077208ULL, 0x000fc80004000000ULL,
0x0000002e0700720bULL, 0x000fc80003f1e000ULL, 0x000000072e067208ULL, 0x000fc80004000000ULL,
0x0000002f0600720bULL, 0x000fc80003f1e000ULL, 0x000000062f077208ULL, 0x000fc80004000000ULL,
0x0000002a0700720bULL, 0x000fc80003f1e000ULL, 0x000000072a067208ULL, 0x000fc80004000000ULL,
0x0000002b0600720bULL, 0x000fc80003f1e000ULL, 0x000000062b077208ULL, 0x000fc80004000000ULL,
0x000000260700720bULL, 0x000fc80003f1e000ULL, 0x0000000726067208ULL, 0x000fc80004000000ULL,
0x000000270600720bULL, 0x000fc80003f1e000ULL, 0x0000000627077208ULL, 0x000fc80004000000ULL,
0x000000220700720bULL, 0x000fc80003f1e000ULL, 0x0000000722067208ULL, 0x000fc80004000000ULL,
0x000000230600720bULL, 0x000fc80003f1e000ULL, 0x0000000623067208ULL, 0x000fc80004000000ULL,
0x000000110600720bULL, 0x000fc80003f1e000ULL, 0x0000000611077208ULL, 0x000fe40004000000ULL,
0x0000001d0a00720bULL, 0x000fe40003f3e000ULL, 0x000000120700720bULL, 0x000fe40003f1e000ULL,
0x0000000a1d0b7208ULL, 0x000fe40004800000ULL, 0x0000000712077208ULL, 0x000fe40004000000ULL,
0x000000080b00720bULL, 0x000fc40003f3e000ULL, 0x000000100700720bULL, 0x000fe40003f1e000ULL,
0x0000000b080b7208ULL, 0x000fe40004800000ULL, 0x0000000710067208ULL, 0x000fe40004000000ULL,
0x000000180b00720bULL, 0x000fe40003f3e000ULL, 0x000000130600720bULL, 0x000fe40003f1e000ULL,
0x0000000b180b7208ULL, 0x000fc40004800000ULL, 0x0000000613067208ULL, 0x000fc60004000000ULL,
0x0c401f000b0a7f89ULL, 0x000e6800000e0000ULL, 0x0c401f0006077f89ULL, 0x000ea200000e0000ULL,
0x0000000a0b00720bULL, 0x002fe40003f3e000ULL, 0x000000070600720bULL, 0x004fe40003f1e000ULL,
0x0000000b0a0a7208ULL, 0x000fe40004800000ULL, 0x0000000607067208ULL, 0x000fc60004000000ULL,
0x0c201f000a0b7f89ULL, 0x000e6800000e0000ULL, 0x0c201f0006157f89ULL, 0x000ea200000e0000ULL,
0x0000000b0a00720bULL, 0x002fe40003f3e000ULL, 0x000000150600720bULL, 0x004fe40003f1e000ULL,
0x0000000a0b147208ULL, 0x000fe40004800000ULL, 0x0000000615157208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b140a7820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b15347820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b09097823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001080aULL,
0x3fb8aa3b31317823ULL, 0x000fe2000001080aULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b37377823ULL, 0x000fe20000010834ULL, 0x3fb8aa3b35357823ULL, 0x000fe2000001080aULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b33337823ULL, 0x000fe20000010834ULL,
0x0000000900097308ULL, 0x000ff00000000800ULL, 0x00000035000c7308ULL, 0x000e700000000800ULL,
0x00000032000b7308ULL, 0x000ff00000000800ULL, 0x0000003300067308ULL, 0x000eb00000000800ULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000003100317308ULL, 0x000f700000000800ULL,
0x0000003600367308ULL, 0x000ff00000000800ULL, 0x0000003700377308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b24197823ULL, 0x100fe2000001080aULL,
0x3fb8aa3b20247823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b251a7823ULL, 0x100fe2000001080aULL,
0x3fb8aa3b08207823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080aULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080aULL, 0x00000028000e7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001080aULL,
0x3fb8aa3b1c1b7823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b18257823ULL, 0x000fe2000001080aULL,
0x000000090c08723eULL, 0x002fe200000000ffULL, 0x3c003c00ff077424ULL, 0x000fe200078e00ffULL,
0x0000000b060b723eULL, 0x004fe200000000ffULL, 0x3c003c00ff067424ULL, 0x000fc400078e00ffULL,
0x3fb8aa3b1d287823ULL, 0x008fe2000001080aULL, 0x00000030310a723eULL, 0x020fe400000000ffULL,
0x000000363709723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b2b2b7823ULL, 0x000fe20000010834ULL, 0x0000002c002c7308ULL, 0x000fe40000000800ULL,
0x00000006081c723cULL, 0x000fec00000018ffULL, 0x0000002d002d7308ULL, 0x000e700000000800ULL,
0x0000002900297308ULL, 0x000eb00000000800ULL, 0x0000002e000d7308ULL, 0x000ff00000000800ULL,
0x0000002f00187308ULL, 0x000ef00000000800ULL, 0x0000002a000f7308ULL, 0x000bf00000000800ULL,
0x0000002b00307308ULL, 0x000f220000000800ULL, 0x0000002c2d0c723eULL, 0x002fc400000000ffULL,
0x0000000e290e723eULL, 0x004fe400000000ffULL, 0x0000000d180d723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b232a7823ULL, 0x120fe20000010834ULL,
0x0000000f300f723eULL, 0x010fe200000000ffULL, 0x0000001900197308ULL, 0x000fe20000000800ULL,
0x0c401f0016237f89ULL, 0x000e6a00000e0000ULL, 0x000000060c1c723cULL, 0x000fe4000000181cULL,
0x0000001a001a7308ULL, 0x000eb00000000800ULL, 0x0000002400247308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000ef00000000800ULL, 0x0000002600267308ULL, 0x000ff00000000800ULL,
0x0000002700277308ULL, 0x000f300000000800ULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002a00297308ULL, 0x000f620000000800ULL, 0x0c401f0017187f89ULL, 0x000e6200000e0000ULL,
0x3fb8aa3b112b7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b122c7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b102d7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b13347823ULL, 0x000fe20000010834ULL,
0x000000191a10723eULL, 0x004fc400000000ffULL, 0x000000242112723eULL, 0x008fe400000000ffULL,
0x000000262711723eULL, 0x010fe400000000ffULL, 0x000000222913723eULL, 0x020fe200000000ffULL,
0x0000001b001b7308ULL, 0x000fe20000000800ULL, 0x000000231600720bULL, 0x002fca0003f1e000ULL,
0x00000006101c723cULL, 0x000fe4000000181cULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x0000001623167208ULL, 0x000fce0004000000ULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002500257308ULL, 0x000e700000000800ULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x0000002c002c7308ULL, 0x000eb00000000800ULL, 0x0000002d002d7308ULL, 0x000ff00000000800ULL,
0x0000003400347308ULL, 0x000ee20000000800ULL, 0x000000181700720bULL, 0x000fe20003f3e000ULL,
0x0c201f0016297f89ULL, 0x000f2200000e0000ULL, 0x00000020251a723eULL, 0x002fc400000000ffULL,
0x0000001718177208ULL, 0x000fe40004800000ULL, 0x0000001b2818723eULL, 0x000fe400000000ffULL,
0x0000002b2c19723eULL, 0x004fe400000000ffULL, 0x00000003ff207819ULL, 0x000fe2000001165eULL,
0x0c201f0017287f89ULL, 0x000e6200000e0000ULL, 0x0000002d341b723eULL, 0x008fe400000000ffULL,
0xfffffff8ff6f7812ULL, 0x000fc400078ee26fULL, 0x0000000320207812ULL, 0x000fc600078ec0ffULL,
0x00000006181c723cULL, 0x000fe2000000181cULL, 0x000000086f237836ULL, 0x000fe40000000000ULL,
0x000000086f227824ULL, 0x040fe400078e00ffULL, 0x000000086f257824ULL, 0x000fe400078e00ffULL,
0x00000001206f7824ULL, 0x040fe400078e026fULL, 0x0000000120247824ULL, 0x000fc600078e0223ULL,
0xfffffff822207812ULL, 0x000fe200078ee26fULL, 0x000000046f227836ULL, 0x000fe20000000000ULL,
0x000000291600720bULL, 0x010fe20003f1e000ULL, 0x0000080000217824ULL, 0x000fe400078e0202ULL,
0x0000000823277824ULL, 0x040fe200078e00ffULL, 0xfffffff825227812ULL, 0x000fe200078ee222ULL,
0x00000008232a7824ULL, 0x000fe400078e00ffULL, 0x0000000c6f6f7836ULL, 0x000fe20000000000ULL,
0xfffffff827247812ULL, 0x000fe200078ee224ULL, 0x00011000212b7836ULL, 0x000fe20000000000ULL,
0x0000001629167208ULL, 0x000fc40004000000ULL, 0x000000035eff7812ULL, 0x000fe2000780c0ffULL,
0x0000001020067824ULL, 0x100fe200078e022bULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee26fULL,
0x0000001022077824ULL, 0x100fe200078e022bULL, 0x000000281700720bULL, 0x002fe20003f3e000ULL,
0x000000ffff207224ULL, 0x000fe400078e0008ULL, 0x00000010241d7824ULL, 0x000fe400078e022bULL,
0x000000ffff217224ULL, 0x000fe400078e000aULL, 0x000000ffff227224ULL, 0x000fc400078e000cULL,
0x000000ffff237224ULL, 0x000fe400078e000eULL, 0x000000ffff087224ULL, 0x000fe400078e0009ULL,
0x000000ffff247224ULL, 0x000fe400078e0010ULL, 0x000000ffff257224ULL, 0x000fe400078e0012ULL,
0x000000ffff267224ULL, 0x000fe400078e0018ULL, 0x000000ffff277224ULL, 0x000fc400078e001aULL,
0x000000ffff097224ULL, 0x000fe400078e000bULL, 0x000000ffff0a7224ULL, 0x000fe400078e000dULL,
0x000000ffff0b7224ULL, 0x000fe200078e000fULL, 0x0000001728177208ULL, 0x000fe20004800000ULL,
0x000000102a2a7824ULL, 0x000fe400078e022bULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fc400078e0013ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0019ULL,
0x000000ffff0f7224ULL, 0x000fe200078e001bULL, 0x0000002006007844ULL, 0x0003e20000000200ULL,
0x000000ffff107224ULL, 0x000fe400078e001cULL, 0x000000ffff117224ULL, 0x000fe200078e001eULL,
0x0000002407007844ULL, 0x0005e20000000200ULL, 0x0000000171717836ULL, 0x000fc60000000000ULL,
0x000000081d007844ULL, 0x0005e80000000200ULL, 0x0000000c2a007844ULL, 0x0005e80000000200ULL,
0x0170001405008388ULL, 0x0005e80000000c00ULL, 0x0172001005008388ULL, 0x0005e20000000a00ULL,
0x000000387100720cULL, 0x000fe20003f06070ULL, 0x00000001ff067424ULL, 0x002fc800078e00ffULL,
0x0176080639ff79a7ULL, 0x0005e2000850003fULL, 0x000000ffff187224ULL, 0x000fe200078e007dULL,
0x0176100639ff79a7ULL, 0x0005e2000850003fULL, 0x0176180639ff79a7ULL, 0x0005e2000850003fULL,
0x0176200639ff79a7ULL, 0x0005e8000850003fULL, 0xffffffac00608947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x018000000f037836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000003047812ULL, 0x000fc800078ec0ffULL,
0x018000000400780cULL, 0x000fda0003f05070ULL, 0x0000000f00038308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0400720cULL, 0x040fe40003f25070ULL,
0x008000000400780cULL, 0x000fe40003f02070ULL, 0x00000001ff047807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000304ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff0fff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000304ff7212ULL, 0x000fe4000780c0ffULL,
0x800000000f047812ULL, 0x000fd600078ec0ffULL, 0x0080000004030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0004ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000f00037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe400078e0006ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffffecc044c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x0000000000000577ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000006f8ULL, 0x0000000000000258ULL, 0x0000001700000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000950ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a30ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a84ULL, 0x0000000000000670ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000010f8ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000010f8ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000001140ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000001180ULL, 0x0000000000013380ULL, 0x0000001700000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000014500ULL, 0x0000000000000048ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000014550ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000014550ULL, 0x0000000000000278ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000014b48ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000014b48ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000001140ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000013380ULL, 0x0000000000013380ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000014500ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000014550ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000278ULL, 0x0000000000000278ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_16_sm_90_cubin_len = 85144;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
