/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000150d0ULL, 0x0000000000014d50ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL,
0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL,
0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL,
0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL,
0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000030ULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000001baULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000034ULL,
0x0000000000000004ULL, 0x000c00010000028dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000002dbULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000329ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c0001000003c5ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c00010000040bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000459ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000049fULL, 0x0000000000013110ULL,
0x0000000000000190ULL, 0x000b0022000004d2ULL, 0x00000000000132a0ULL, 0x0000000000000040ULL,
0x000b0022000004fdULL, 0x00000000000132e0ULL, 0x0000000000000070ULL, 0x000b002200000527ULL,
0x0000000000013350ULL, 0x0000000000000130ULL, 0x000a000300000595ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005b5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005e5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000013480ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001311000000000ULL,
0x0000040400000000ULL, 0x810c000001880400ULL, 0x004ab00400288080ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080860828808081ULL, 0x8808288080870828ULL, 0x2880808908288080ULL,
0x808d082880808a08ULL, 0x0828808092082880ULL, 0x8080950828808093ULL, 0xac08288080a10828ULL,
0x288080b408288080ULL, 0x808508288080b508ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080859200ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x0001311000000000ULL,
0x0000019000000000ULL, 0x00005c0400000000ULL, 0x8082288080850900ULL, 0x0000000000002880ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8708288080860828ULL, 0x2880808808288080ULL,
0x808a082880808908ULL, 0x0828808090082880ULL, 0x8080920828808091ULL, 0x9508288080930828ULL,
0x288080a108288080ULL, 0x80b408288080ac08ULL, 0x08288080b5082880ULL, 0x808280162880808cULL,
0x0000000000031028ULL, 0x2880808c92000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x0000013000000000ULL, 0x000132a000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8708288080860828ULL, 0x2880808808288080ULL,
0x808a082880808908ULL, 0x082880808d082880ULL, 0x8080920828808091ULL, 0xa108288080950828ULL,
0x288080ac08288080ULL, 0x80b508288080b408ULL, 0x1628808093082880ULL, 0x0000031028808280ULL,
0x9392000000000000ULL, 0x0000002200288080ULL, 0x0000002cffffffffULL, 0x000001f000000000ULL,
0x000132e000000000ULL, 0x0000007000000000ULL, 0x0000140400000000ULL, 0x8092288080930900ULL,
0x0000000000002880ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8708288080860828ULL,
0x2880808808288080ULL, 0x808a082880808908ULL, 0x0828808091082880ULL, 0x8080950828808093ULL,
0xac08288080a10828ULL, 0x288080b408288080ULL, 0x809208288080b508ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x2200288080929200ULL, 0x0000001cffffffffULL, 0x000002b800000000ULL,
0x0001335000000000ULL, 0x0000013000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL,
0x0008230400000080ULL, 0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL,
0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL,
0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL,
0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL,
0x0000001b00081204ULL, 0x0008110400000000ULL, 0x000000000000001bULL, 0x0000007b00043704ULL,
0x0000001800080a04ULL, 0x0068190300680160ULL, 0x00000000000c1704ULL, 0x0021f0000060000aULL,
0x00000000000c1704ULL, 0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0011f00000500008ULL,
0x00000000000c1704ULL, 0x0081f00000300007ULL, 0x00000000000c1704ULL, 0x0021f00000280006ULL,
0x00000000000c1704ULL, 0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL,
0x00000000000c1704ULL, 0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL,
0x00000000000c1704ULL, 0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400801b03ULL, 0x0134290400000b70ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x01342804ffffffffULL, 0x000003b000000300ULL, 0x000028b0000005b0ULL, 0x00002a5000002930ULL,
0x0000304000002bb0ULL, 0x000030c000003070ULL, 0x0000509000003110ULL, 0x0000525000005120ULL,
0x00005840000053b0ULL, 0x000058c000005870ULL, 0x0000766000005910ULL, 0x0000783000007700ULL,
0x00007e2000007990ULL, 0x00007ea000007e50ULL, 0x00009cc000007ef0ULL, 0x00009e9000009d60ULL,
0x0000a48000009ff0ULL, 0x0000a5000000a4b0ULL, 0x0000b7600000a550ULL, 0x00011a100000b770ULL,
0x00011a6000011a50ULL, 0x00011a8000011a70ULL, 0x00011b0000011ae0ULL, 0x0001275000011b20ULL,
0x000127e000012790ULL, 0x0001287000012820ULL, 0x00012910000128c0ULL, 0x000129a000012950ULL,
0x00012a30000129e0ULL, 0x00012ad000012a80ULL, 0x00012b6000012b10ULL, 0x00012bf000012ba0ULL,
0x00012c9000012c40ULL, 0x00012d2000012cd0ULL, 0x00012db000012d60ULL, 0x00012e5000012e00ULL,
0x00012f1000012eb0ULL, 0x00012fd000012f70ULL, 0x0001309000013030ULL, 0x04403904000130f0ULL,
0x000000ff00000410ULL, 0x003f01000000f600ULL, 0x0000000f00000450ULL, 0x003f01200000f608ULL,
0x0000000f000004d0ULL, 0x003f01200000f688ULL, 0x0000000f00000500ULL, 0x003f01200000f6a8ULL,
0x0000000f00000530ULL, 0x003f01200000f6c8ULL, 0x000000ff00000b90ULL, 0x003f01070000f600ULL,
0x0000000300000d80ULL, 0x003f010200000004ULL, 0x0000000300000e40ULL, 0x003f010100000000ULL,
0x0000000500001640ULL, 0x003f01070000f6a8ULL, 0x00000005000017a0ULL, 0x003f01010000f6a8ULL,
0x0000000600001800ULL, 0x003f01010000f6c8ULL, 0x0000000d000019b0ULL, 0x003f01050000f6ccULL,
0x0000000d00001b90ULL, 0x003f01050000f6ccULL, 0x00000011000024b0ULL, 0x003f01070000f6b0ULL,
0x0000001100002560ULL, 0x003f01010000f6b0ULL, 0x00000009000025c0ULL, 0x003f01010000f608ULL,
0x00000009000025e0ULL, 0x003f01050000f60cULL, 0x00000009000027b0ULL, 0x003f01050000f60cULL,
0x0000003400002da0ULL, 0x003f01050000f6acULL, 0x0000003400002f70ULL, 0x003f01050000f6acULL,
0x0000000c00004220ULL, 0x003f010100000000ULL, 0x0000006c00004280ULL, 0x003f01010000f688ULL,
0x00000005000042a0ULL, 0x003f010500000004ULL, 0x0000000500004470ULL, 0x003f010500000004ULL,
0x0000000d00004ca0ULL, 0x003f01070000f6a8ULL, 0x0000000d00004d70ULL, 0x003f01010000f6a8ULL,
0x0000000900004dd0ULL, 0x003f01010000f628ULL, 0x0000000900004df0ULL, 0x003f01050000f62cULL,
0x0000000900004fc0ULL, 0x003f01050000f62cULL, 0x00000036000055a0ULL, 0x003f01050000f6b4ULL,
0x0000003600005770ULL, 0x003f01050000f6b4ULL, 0x00000010000067f0ULL, 0x003f010100000000ULL,
0x0000000d00006850ULL, 0x003f01010000f690ULL, 0x0000000500006870ULL, 0x003f010500000004ULL,
0x0000000500006a40ULL, 0x003f010500000004ULL, 0x0000000d00007270ULL, 0x003f01070000f6b0ULL,
0x0000000d00007340ULL, 0x003f01010000f6b0ULL, 0x00000009000073a0ULL, 0x003f01010000f648ULL,
0x00000009000073c0ULL, 0x003f01050000f64cULL, 0x0000000900007590ULL, 0x003f01050000f64cULL,
0x0000003600007b80ULL, 0x003f01050000f6acULL, 0x0000003600007d50ULL, 0x003f01050000f6acULL,
0x0000001200008dd0ULL, 0x003f010100000000ULL, 0x0000000a00008e30ULL, 0x003f01010000f698ULL,
0x0000000500008e50ULL, 0x003f010500000004ULL, 0x0000000500009020ULL, 0x003f010500000004ULL,
0x0000000a00009920ULL, 0x003f01070000f6a8ULL, 0x0000000a000099b0ULL, 0x003f01010000f6a8ULL,
0x0000000400009a10ULL, 0x003f01010000f668ULL, 0x0000000400009a40ULL, 0x003f01050000f66cULL,
0x0000000400009c10ULL, 0x003f01050000f66cULL, 0x0000000f0000a1e0ULL, 0x003f01050000f6b4ULL,
0x0000000f0000a3b0ULL, 0x003f01050000f6b4ULL, 0x000000050000b530ULL, 0x003f010100000000ULL,
0x0000000d0000b5b0ULL, 0x003f010100000000ULL, 0x000000ff0000c930ULL, 0x003f01010000f600ULL,
0x000000ff0000d560ULL, 0x003f01050000f604ULL, 0x000000ff0000d770ULL, 0x003f01050000f604ULL,
0x000000ff0000d9a0ULL, 0x003f01010000f600ULL, 0x000000ff0000d9d0ULL, 0x003f01050000f604ULL,
0x000000ff0000db90ULL, 0x003f01050000f604ULL, 0x000000700000fdf0ULL, 0x003f010100000000ULL,
0x000000700000fe70ULL, 0x003f010500000004ULL, 0x0000007000010040ULL, 0x003f010500000004ULL,
0x00000074000125b0ULL, 0x003f010100000000ULL, 0x0000007400012610ULL, 0x003f010100000008ULL,
0x0000007400012670ULL, 0x003f010100000010ULL, 0x00000074000126e0ULL, 0x003f010100000018ULL,
0x00201c0400053803ULL, 0x0000c0100000bfe0ULL, 0x0000c4a00000c2b0ULL, 0x0000c8500000c6a0ULL,
0x000127200000dbf0ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000354ULL,
0x0000001b00000002ULL, 0x0000000000000294ULL, 0x0000001b00000002ULL, 0x00000000000001dcULL,
0x0000001b00000002ULL, 0x000000000000010cULL, 0x0000001b00000002ULL, 0x0000000000000044ULL,
0x0000001b00000002ULL, 0x0000000000000331ULL, 0x0000001b00000002ULL, 0x000000000000026eULL,
0x0000001b00000002ULL, 0x00000000000001b3ULL, 0x0000001b00000002ULL, 0x00000000000000e9ULL,
0x0000001b00000002ULL, 0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000006d7919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff040424ULL, 0x000fe200078e00ffULL,
0x000000016d020810ULL, 0x002fca0007ffe0ffULL, 0x00005c0002020625ULL, 0x000fc800078e0004ULL,
0x00005c006d040625ULL, 0x000fe200078e0004ULL, 0x0000000602680981ULL, 0x0002aa000c1e1900ULL,
0x0000000604050981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff6e7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000087919ULL, 0x000e680000002600ULL, 0x00000000000d7919ULL, 0x000e680000002300ULL,
0x00000000000b7919ULL, 0x000e620000002100ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00067810ULL, 0x010fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x000864000021f000ULL,
0x000000ffff067224ULL, 0x010fe400078e00ffULL, 0x000000ffff097224ULL, 0x002fc800078e0a07ULL,
0x0000590009097a24ULL, 0x000fc800078e02ffULL, 0x0000000907077227ULL, 0x000fcc00078e0006ULL,
0x0000040007097a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a09ULL,
0x0000040003007624ULL, 0x000fca00078e026eULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x0000000109091810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x0000000109092810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff09ba12ULL, 0x000fc800078e33ffULL, 0x0000000900007306ULL, 0x000e620000209000ULL,
0x000000ff0900720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002e4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000309047224ULL, 0x008fc800078e02ffULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000e640000002200ULL,
0x0000000703037227ULL, 0x000fcc00078e0002ULL, 0x00000008037a7227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a7aULL, 0x0000000009007224ULL, 0x000fca00078e0208ULL,
0x000000090000720cULL, 0x000fe20003fa6070ULL, 0x000001000d027a24ULL, 0x002fe400078e0204ULL,
0x00001fff0d0d7589ULL, 0x000fe400000e0000ULL, 0x00000000020f7a24ULL, 0x000fca00078e020bULL,
0x000000ff0f00720cULL, 0x000fc60003f65270ULL, 0x0000000100005824ULL, 0x000fe200078e0a09ULL,
0x000000017a7a5810ULL, 0x000fe40007ffe0ffULL, 0x0000000f0f00780cULL, 0x040fe40003f24070ULL,
0x000000090000720cULL, 0x000fe40003fc6070ULL, 0x00000005ff007819ULL, 0x000fe4000001160bULL,
0x0000007f0f00780cULL, 0x040fe40003f44070ULL, 0x000000030f00780cULL, 0x000fe20003fa4070ULL,
0x3fffff80ff02b424ULL, 0x000fe200078e00ffULL, 0x00001fff00007589ULL, 0x000e6200000e0000ULL,
0x7fffff80ff03b424ULL, 0x000fc400078e00ffULL, 0x3fffffc0ff069424ULL, 0x000fe400078e00ffULL,
0x000000017a7a6810ULL, 0x000fe20007ffe0ffULL, 0x7fffffc0ff079424ULL, 0x000fe200078e00ffULL,
0x00000009ff7ac212ULL, 0x000fe200078e33ffULL, 0x00f60002ff00b388ULL, 0x0007e20000000a00ULL,
0x000000010f00780cULL, 0x000fe20003f64070ULL, 0xff317217ff0ca424ULL, 0x000fe400078e00ffULL,
0x000000ffff797224ULL, 0x000fe200078e0a7aULL, 0x00f608060f009388ULL, 0x000fe60000008a00ULL,
0x0000007909797224ULL, 0x000fe200078e0208ULL, 0x00f4000c0f00a388ULL, 0x0009e20000004800ULL,
0x3fffff60ff02d424ULL, 0x008fc400078e00ffULL, 0x0000001079797824ULL, 0x000fe400078e00ffULL,
0x7fffff60ff03d424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff08d424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff09d424ULL, 0x000fe200078e00ffULL, 0x00f688020f00d388ULL, 0x0003e20000008a00ULL,
0x00005a00ff0c7624ULL, 0x010fe400078e00ffULL, 0x3fffffc0ff0ab424ULL, 0x000fe200078e00ffULL,
0x00f6a8080f00d388ULL, 0x000fe20000008a00ULL, 0x7fffffc0ff0bb424ULL, 0x000fc400078e00ffULL,
0x000059000c0c7a24ULL, 0x000fc600078e02ffULL, 0x00f6c80a0f00b388ULL, 0x000fe20000008a00ULL,
0x000000040d027824ULL, 0x002fe400078e0200ULL, 0x0000000168680824ULL, 0x004fe400078e0a05ULL,
0x00005800ff688624ULL, 0x000fe400078e00ffULL, 0x000058006d058a24ULL, 0x000fe400078e02ffULL,
0x00005a0068047a24ULL, 0x000fe400078e02ffULL, 0x0000000c057d7224ULL, 0x000fc400078e02ffULL,
0x0000000104067824ULL, 0x040fe200078e0a79ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000790400720cULL, 0x000fe20003f26070ULL, 0x0000000202047824ULL, 0x000fe200078e00ffULL,
0x0000001006067817ULL, 0x000fe20003800000ULL, 0x00005a007a0f7a24ULL, 0x000fc600078e027dULL,
0x000000ff067c7207ULL, 0x000fc80000800000ULL, 0x000000107c00780cULL, 0x000fda0003f05270ULL,
0x000002c000008947ULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000000497919ULL, 0x000ea20000000000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000600067308ULL, 0x002e620000001000ULL,
0x00000004ff077819ULL, 0x004fca0000011649ULL, 0x0000000104087824ULL, 0x000fe200078e0207ULL,
0x0ffffffe06037810ULL, 0x002fe20007ffe0ffULL, 0x0000001049067824ULL, 0x000fca00078e00ffULL,
0x0000000300037305ULL, 0x000e64000021f000ULL, 0x000000ffff097224ULL, 0x002fc800078e0a03ULL,
0x00005a0009097a24ULL, 0x000fc800078e02ffULL, 0x0000000903097227ULL, 0x000fc800078e0002ULL,
0x0000000179027824ULL, 0x000fc800078e0208ULL, 0x0000000209097227ULL, 0x000fc800078e00ffULL,
0x000000ffff0b7224ULL, 0x000fc800078e0a09ULL, 0x00005a000b037a24ULL, 0x000fca00078e0202ULL,
0x00005a0003007a0cULL, 0x000fda0003f06070ULL, 0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL,
0x0000000109090810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fda0003f26070ULL,
0x0000000109091810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff09aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a09ULL, 0x00005a0003027a24ULL, 0x000fe200078e0202ULL,
0x000000047c037217ULL, 0x000fc60007800000ULL, 0x000000010f027824ULL, 0x000fe400078e0202ULL,
0x0000000103047824ULL, 0x000fe400078e0a04ULL, 0x0000000c09027224ULL, 0x000fe200078e0202ULL,
0x000000f006097812ULL, 0x000fe400078ec0ffULL, 0x000000040700720cULL, 0x000fe20003f06070ULL,
0x0000010002027825ULL, 0x000fc800078e00ffULL, 0x0000000108047824ULL, 0x000fe200078e0249ULL,
0x0000000902097212ULL, 0x000fe200078efcffULL, 0x0000001008077824ULL, 0x000fc600078e00ffULL,
0x0000600009027a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff007047812ULL, 0x000fe400078ee204ULL,
0x0000610003037a10ULL, 0x000fc60000ffe4ffULL, 0x0000001004077824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e2000c101c46ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000000497919ULL, 0x000ea20000000000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000600067308ULL, 0x002e620000001000ULL,
0x0000000449047211ULL, 0x004fe400078fe0ffULL, 0x0ffffffe06087810ULL, 0x002fca0007ffe0ffULL,
0x0000000800037305ULL, 0x000e64000021f000ULL, 0x000000ffff077224ULL, 0x002fc800078e0a03ULL,
0x00005a0007077a24ULL, 0x000fc800078e02ffULL, 0x0000000703037227ULL, 0x000fc800078e0002ULL,
0x0000000179027824ULL, 0x000fc800078e0204ULL, 0x0000000203037227ULL, 0x000fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a03ULL, 0x00005a0007067a24ULL, 0x000fca00078e0202ULL,
0x00005a0006007a0cULL, 0x000fda0003f06070ULL, 0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103030810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe20003f26070ULL,
0x0000001049067824ULL, 0x000fca00078e00ffULL, 0x000000f006097812ULL, 0x000fce00078ec0ffULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff03aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a03ULL, 0x00005a0007027a24ULL, 0x000fe400078e0202ULL,
0x0000000104077824ULL, 0x040fe400078e0249ULL, 0x000000010f027824ULL, 0x000fe400078e0202ULL,
0x0000001004047824ULL, 0x000fe400078e00ffULL, 0x0000000c03027224ULL, 0x000fc600078e0202ULL,
0xfffffff004077812ULL, 0x000fe200078ee207ULL, 0x0000010002027825ULL, 0x000fc800078e00ffULL,
0x0000001007077824ULL, 0x000fe200078e00ffULL, 0x0000000902027212ULL, 0x000fc800078efcffULL,
0x0000600002027a10ULL, 0x000fc80007f1e0ffULL, 0x0000610003037a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000b901c46ULL,
0x0000000000037919ULL, 0x002e620000000000ULL, 0x0000000000047806ULL, 0x000fe200038e0000ULL,
0x00000004ff3e7424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400027300ULL, 0x000e7000000e0000ULL, 0x0000000400077309ULL, 0x000ea20000000000ULL,
0x000000030200720cULL, 0x002fe20003f02070ULL, 0x000068006d027625ULL, 0x000fc800078e003eULL,
0x000000ffff077224ULL, 0x004fd000078e0a07ULL, 0x00f60407ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000602027981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0d00720cULL, 0x000fe40003f05270ULL,
0x0000003f02657810ULL, 0x044fe40007ffe0ffULL, 0x000000ff02047810ULL, 0x000fc40007ffe0ffULL,
0x00000006ff657819ULL, 0x000fe40000011665ULL, 0x00000008ff667819ULL, 0x000fca0000011604ULL,
0x0000bb9000008947ULL, 0x000fea0003800000ULL, 0x00000002ff767819ULL, 0x000fe20000011600ULL,
0x00000003ff0c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff057424ULL, 0x000fe200078e00ffULL,
0x03ffffff760a7812ULL, 0x000fc800078ec0ffULL, 0x000000650a00720cULL, 0x000fda0003f06070ULL,
0x000000026d038824ULL, 0x000fe400078e00ffULL, 0x00006a00ff088624ULL, 0x000fc800078e00ffULL,
0x00006a0003078624ULL, 0x002fe200078e0208ULL, 0x0000f68800037811ULL, 0x000fc600078e18ffULL,
0x000000010a078824ULL, 0x000fe200078e0207ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040c03ff738cULL, 0x0003e20000000000ULL, 0x0000660007088625ULL, 0x000fe200078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000608058981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0400780cULL, 0x000fe20003f04070ULL, 0x000000407a6f7824ULL, 0x000fe200078e00ffULL,
0x00000001ff637819ULL, 0x000fe20000011600ULL, 0x00000080ff0c7424ULL, 0x002fe200078e00ffULL,
0x0000000003ff7f8cULL, 0x0003e2000c80043fULL, 0x0000000100047812ULL, 0x000fe400078ec0ffULL,
0x00000020630b7824ULL, 0x000fc400078e00ffULL, 0x0000590005057a24ULL, 0x004fc800078e02ffULL,
0x0000004005077824ULL, 0x000fe200078e00ffULL, 0x000000206f057812ULL, 0x000fc600078ef80bULL,
0x0000640007087625ULL, 0x000fe200078e000cULL, 0x000003e000000947ULL, 0x000fea0003800000ULL,
0x0000000b02037217ULL, 0x002fe20007800000ULL, 0x00000010040c7824ULL, 0x000fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fc60000011649ULL, 0x0000000103037824ULL, 0x000fe200078e0a0bULL,
0x00000004070f7810ULL, 0x000fe20007ffe0ffULL, 0x000000010c0e7824ULL, 0x000fc600078e0207ULL,
0x0000000c03037217ULL, 0x000fe20007800000ULL, 0x000000010e0b7824ULL, 0x040fe400078e0249ULL,
0x000000080e107824ULL, 0x000fe400078e00ffULL, 0x0000000103037824ULL, 0x000fe400078e0a0cULL,
0x00000001050d7824ULL, 0x000fe200078e020eULL, 0xfffffff8100b7812ULL, 0x000fe200078ee20bULL,
0x000000010c0e7824ULL, 0x000fe200078e020fULL, 0x0000000807107810ULL, 0x000fc40007ffe0ffULL,
0x000000030700720cULL, 0x0c0fe20003f66070ULL, 0x000000080e147824ULL, 0x000fe200078e00ffULL,
0x0000000c07077810ULL, 0x000fe40007ffe0ffULL, 0x000000031000720cULL, 0x080fe20003f26070ULL,
0x000000010c107824ULL, 0x040fe200078e0210ULL, 0x000000030f00720cULL, 0x080fe20003f46070ULL,
0x000000010c127824ULL, 0x000fe200078e0207ULL, 0x000000030700720cULL, 0x000fe20003f06070ULL,
0x000000800d0c7825ULL, 0x000fc800078e00ffULL, 0x0000000105037824ULL, 0x040fe200078e020eULL,
0x000000700c137812ULL, 0x000fe200078ef806ULL, 0x000000010e077824ULL, 0x100fe400078e0249ULL,
0x0000000105117824ULL, 0x040fe400078e0212ULL, 0x00000001120c7824ULL, 0x000fe200078e0249ULL,
0xfffffff814077812ULL, 0x000fe200078ee207ULL, 0x0000000812157824ULL, 0x000fe200078e00ffULL,
0x0000001308127210ULL, 0x000fe20007f9e0ffULL, 0x00000001050e7824ULL, 0x000fe200078e0210ULL,
0x0000b00063147811ULL, 0x000fe200078e68ffULL, 0x0000000110057824ULL, 0x040fe200078e0249ULL,
0xfffffff815157812ULL, 0x000fe200078ee20cULL, 0x0000000810107824ULL, 0x000fc400078e00ffULL,
0x0000000109137824ULL, 0x000fe400020e060dULL, 0x00000080030c7825ULL, 0x000fe200078e00ffULL,
0xfffffff810057812ULL, 0x000fc600078ee205ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c197812ULL, 0x000fc600078ef806ULL, 0x0000008011107825ULL, 0x000fe200078e00ffULL,
0x000000700e177812ULL, 0x000fc600078ef806ULL, 0x0000001007037824ULL, 0x000fe200078e0214ULL,
0x0000007010077812ULL, 0x000fe200078ef806ULL, 0x000000100b0b7824ULL, 0x100fe200078e0214ULL,
0x0000001908067210ULL, 0x040fe20007f9e0ffULL, 0x0000001005057824ULL, 0x100fe200078e0214ULL,
0x00000017080c7210ULL, 0x040fe20007fbe0ffULL, 0x0000001015157824ULL, 0x000fe200078e0214ULL,
0x0000000708087210ULL, 0x000fe20007fde0ffULL, 0x0000000109077824ULL, 0x040fe200020e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000120b7faeULL, 0x0003e2000d901c46ULL,
0x00000001090d7824ULL, 0x000fc400028e060fULL, 0x0000000109097824ULL, 0x000fe200030e0611ULL,
0x0000000006037faeULL, 0x0003e8000d101c46ULL, 0x000000000c057faeULL, 0x0003e8000c901c46ULL,
0x0000000008157faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x00000010040c7824ULL, 0x002fe200078e00ffULL, 0x0000b00063167811ULL, 0x000fc800078e68ffULL,
0x0000000c490c7211ULL, 0x000fc800078fe8ffULL, 0x000000040c0e7810ULL, 0x040fe20007ffe0ffULL,
0x000000010c037824ULL, 0x040fe200078e0249ULL, 0x0000000c0c127810ULL, 0x040fe20007ffe0ffULL,
0x000000080c107824ULL, 0x000fe400078e00ffULL, 0x00000001050d7824ULL, 0x040fe400078e020cULL,
0x0000000105077824ULL, 0x000fe200078e020eULL, 0xfffffff810037812ULL, 0x000fe200078ee203ULL,
0x000000010e0b7824ULL, 0x000fe200078e0249ULL, 0x000000080c107810ULL, 0x000fe20007ffe0ffULL,
0x000000800d0c7825ULL, 0x000fc800078e00ffULL, 0x000000080e147824ULL, 0x000fe200078e00ffULL,
0x000000700c137812ULL, 0x000fe200078ef806ULL, 0x0000000105117824ULL, 0x040fe400078e0212ULL,
0x00000001120c7824ULL, 0x000fe200078e0249ULL, 0xfffffff8140b7812ULL, 0x000fe200078ee20bULL,
0x00000008120f7824ULL, 0x000fe200078e00ffULL, 0x0000001308127210ULL, 0x000fe20007f1e0ffULL,
0x00000001050e7824ULL, 0x000fe400078e0210ULL, 0x0000000110057824ULL, 0x040fe200078e0249ULL,
0xfffffff80f147812ULL, 0x000fe200078ee20cULL, 0x0000000810107824ULL, 0x000fc400078e00ffULL,
0x0000000109137824ULL, 0x000fe400000e060dULL, 0x00000080070c7825ULL, 0x000fe200078e00ffULL,
0xfffffff810057812ULL, 0x000fc600078ee205ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c177812ULL, 0x000fc600078ef806ULL, 0x0000008011107825ULL, 0x000fe200078e00ffULL,
0x000000700e157812ULL, 0x000fc600078ef806ULL, 0x0000001003037824ULL, 0x000fe200078e0216ULL,
0x0000007010077812ULL, 0x000fe200078ef806ULL, 0x000000100b0b7824ULL, 0x100fe200078e0216ULL,
0x0000001708067210ULL, 0x040fe20007f1e0ffULL, 0x0000001005057824ULL, 0x100fe200078e0216ULL,
0x00000015080c7210ULL, 0x000fe20007f3e0ffULL, 0x0000001014157824ULL, 0x000fe200078e0216ULL,
0x0000000708087210ULL, 0x000fe20007f5e0ffULL, 0x0000000109077824ULL, 0x040fe200000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012037faeULL, 0x0003e2000b901c46ULL,
0x00000001090d7824ULL, 0x000fc400008e060fULL, 0x0000000109097824ULL, 0x000fe200010e0611ULL,
0x00000000060b7faeULL, 0x0003e8000b901c46ULL, 0x000000000c057faeULL, 0x0003e8000b901c46ULL,
0x0000000008157faeULL, 0x0003e4000b901c46ULL, 0x000000010a037810ULL, 0x002fe20007ffe0ffULL,
0xffffffffff0c7424ULL, 0x000fc600078e00ffULL, 0x000000650300720cULL, 0x000fda0003f06070ULL,
0x000000026d058824ULL, 0x000fe400078e00ffULL, 0x00006a00ff068624ULL, 0x000fc800078e00ffULL,
0x00006a0005068624ULL, 0x000fe400078e0206ULL, 0x0000001063057824ULL, 0x000fe400078e00ffULL,
0x00000001063f8824ULL, 0x000fe400078e0203ULL, 0x00000000050473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000066003f3e8625ULL, 0x000fca00078e003eULL,
0x000000063e0c8981ULL, 0x000522000c1e1900ULL, 0x000000ff6600720cULL, 0x000fe20003f05270ULL,
0x0000000863067824ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0x0000f6a804047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x00f6a800050e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6c80006067f8cULL, 0x000ee2000c80043fULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00009d4000008947ULL, 0x000fea0003800000ULL, 0x0000001005057812ULL, 0x002fe200078ec0ffULL,
0x000000026d707824ULL, 0x000fc400078e00ffULL, 0x00006a00ff0d7624ULL, 0x000fe400078e00ffULL,
0x0000002076057824ULL, 0x000fe400078e0205ULL, 0x000000ffff0e7224ULL, 0x004fe400078e000fULL,
0x000000ffff097224ULL, 0x008fe400078e0007ULL, 0x00006a0070707624ULL, 0x000fe400078e020dULL,
0x0000000804047824ULL, 0x000fc400078e0205ULL, 0xff317217ff0a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff487224ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fc400078e00ffULL,
0x000000ffff757224ULL, 0x00afca00078e0003ULL, 0x0000000000107805ULL, 0x000fc40000015200ULL,
0x0000000400057824ULL, 0x000fca00078e00ffULL, 0xfffffff8050d7812ULL, 0x000fc800078ec0ffULL,
0x0000f6c80d057810ULL, 0x000fe20007ffe0ffULL, 0x00f6cc000d127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011413ULL,
0x000000120f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x000000020f0f7819ULL, 0x000fc80000001212ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc000d127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000097824ULL, 0x000fe200078e00ffULL,
0x00000001480f7810ULL, 0x000fe20007ffe0ffULL, 0x000059000c0c7a24ULL, 0x010fc600078e02ffULL,
0xffffffe0090d7812ULL, 0x000fe200078ec0ffULL, 0x000000400c0c7824ULL, 0x000fe200078e00ffULL,
0x000000660f00720cULL, 0x000fc60003f26070ULL, 0x00000100480d7824ULL, 0x000fca00078e020dULL,
0x000000400d0f7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0d7424ULL, 0x000fc600078e00ffULL,
0x000000200f107812ULL, 0x000fe200078ec0ffULL, 0x000064000c0c7625ULL, 0x000fc800078e000dULL,
0x000000016f377824ULL, 0x000fe200078e0210ULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x0000001009107812ULL, 0x000fe200078ec0ffULL, 0x0000001049137824ULL, 0x000fe200078e00ffULL,
0x0000000f02097217ULL, 0x000fe40007800000ULL, 0x00000003ff117819ULL, 0x000fe40000011649ULL,
0x0000007013417812ULL, 0x000fe200078ec0ffULL, 0x0000000109097824ULL, 0x000fe200078e0a0fULL,
0x0000000411347810ULL, 0x040fe20007ffe0ffULL, 0x0000000111127824ULL, 0x040fe200078e0210ULL,
0x0000000c11357810ULL, 0x000fc40007ffe0ffULL, 0x0000001009097217ULL, 0x000fe20007800000ULL,
0x00000001120f7824ULL, 0x040fe400078e0249ULL, 0x0000000812367824ULL, 0x000fe400078e00ffULL,
0x0000000109097824ULL, 0x100fe400078e0a10ULL, 0x0000000135387824ULL, 0x100fe200078e0210ULL,
0xfffffff8360f7812ULL, 0x000fe400078ee20fULL, 0x000000093400720cULL, 0x0c0fe20003f66070ULL,
0x0000000134347824ULL, 0x100fe200078e0210ULL, 0x0000000811367810ULL, 0x040fe20007ffe0ffULL,
0x00000008383b7824ULL, 0x000fe200078e00ffULL, 0x000000091100720cULL, 0x080fe20003f86070ULL,
0x0000000134117824ULL, 0x000fe200078e0249ULL, 0x000000093600720cULL, 0x080fe20003f46070ULL,
0x00000008343a7824ULL, 0x000fe200078e00ffULL, 0x000000093500720cULL, 0x000fe20003f06070ULL,
0x0000000136367824ULL, 0x000fc400078e0210ULL, 0x0000000137107824ULL, 0x040fe200078e0212ULL,
0xfffffff83a097812ULL, 0x000fe200078ee211ULL, 0x0000000137127824ULL, 0x040fe400078e0234ULL,
0x0000000137347824ULL, 0x000fe400078e0236ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000136357824ULL, 0x000fe200078e0249ULL, 0x00000041103f7212ULL, 0x000fe200078efcffULL,
0x00000008363a7824ULL, 0x000fe400078e00ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000003f0c107210ULL, 0x000fe40007fbe0ffULL, 0xfffffff83a397812ULL, 0x000fe200078ee235ULL,
0x0000000138367824ULL, 0x000fe200078e0249ULL, 0x00000041123d7212ULL, 0x000fe200078efcffULL,
0x0000000137377824ULL, 0x000fe200078e0238ULL, 0x0000c00063387811ULL, 0x000fe200078e68ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fc400078ee236ULL,
0x0000003d0c127210ULL, 0x000fe20007fde0ffULL, 0x0000008037367825ULL, 0x000fe200078e00ffULL,
0x00000041343f7212ULL, 0x000fc600078efcffULL, 0x000000010d117824ULL, 0x040fe200028e0611ULL,
0x00000041363d7212ULL, 0x000fe200078efcffULL, 0x000000010d137824ULL, 0x000fe200030e0613ULL,
0x0000003f0c347210ULL, 0x040fe20007fbe0ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0238ULL,
0x0000003d0c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001009097824ULL, 0x100fe400078e0238ULL,
0x0000001039397824ULL, 0x000fe200078e0238ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100f7faeULL, 0x0003e2000e101c46ULL, 0x000000010d357824ULL, 0x000fc400028e0635ULL,
0x000000103b3b7824ULL, 0x000fe200078e0238ULL, 0x0000000012097faeULL, 0x0003e2000d901c46ULL,
0x000000010d0d7824ULL, 0x000fc600030e0637ULL, 0x0000000034397faeULL, 0x0003e8000d101c46ULL,
0x000000000c3b7faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001009107812ULL, 0x000fe200078ec0ffULL, 0x00000010490f7824ULL, 0x000fe200078e00ffULL,
0x0000c000633c7811ULL, 0x000fe400078e68ffULL, 0x0000001049107211ULL, 0x000fe400078fe8ffULL,
0x000000700f3b7812ULL, 0x000fc400078ec0ffULL, 0x0000000810347810ULL, 0x040fe20007ffe0ffULL,
0x0000000110097824ULL, 0x040fe200078e0249ULL, 0x0000000c10367810ULL, 0x040fe20007ffe0ffULL,
0x0000000810127824ULL, 0x000fe400078e00ffULL, 0x0000000137117824ULL, 0x040fe400078e0210ULL,
0x0000000137357824ULL, 0x000fe200078e0234ULL, 0xfffffff812097812ULL, 0x000fe200078ee209ULL,
0x00000008343d7824ULL, 0x000fe200078e00ffULL, 0x0000000410127810ULL, 0x000fe20007ffe0ffULL,
0x0000008011107825ULL, 0x000fc800078e00ffULL, 0x0000000137137824ULL, 0x000fe200078e0212ULL,
0x0000003b10397212ULL, 0x000fe200078efcffULL, 0x00000001120f7824ULL, 0x140fe400078e0249ULL,
0x0000000812387824ULL, 0x000fe200078e00ffULL, 0x000000390c107210ULL, 0x000fe20007f1e0ffULL,
0x0000000134127824ULL, 0x100fe400078e0249ULL, 0x0000000136347824ULL, 0x000fe200078e0249ULL,
0xfffffff8380f7812ULL, 0x000fe200078ee20fULL, 0x00000008363f7824ULL, 0x000fe200078e00ffULL,
0xfffffff83d387812ULL, 0x000fe200078ee212ULL, 0x0000000137377824ULL, 0x000fc400078e0236ULL,
0x0000008013127825ULL, 0x000fe200078e00ffULL, 0xfffffff83f3a7812ULL, 0x000fc600078ee234ULL,
0x0000008035347825ULL, 0x000fe200078e00ffULL, 0x0000003b123f7212ULL, 0x000fc600078efcffULL,
0x0000008037367825ULL, 0x000fe200078e00ffULL, 0x0000003b343d7212ULL, 0x000fc600078efcffULL,
0x000000010d117824ULL, 0x000fe200000e0611ULL, 0x0000003b363b7212ULL, 0x000fe200078efcffULL,
0x0000001009097824ULL, 0x100fe200078e023cULL, 0x0000003f0c127210ULL, 0x040fe20007f1e0ffULL,
0x000000100f0f7824ULL, 0x100fe200078e023cULL, 0x0000003d0c347210ULL, 0x000fe20007f5e0ffULL,
0x0000001038397824ULL, 0x000fe200078e023cULL, 0x0000003b0c0c7210ULL, 0x000fe20007f7e0ffULL,
0x000000010d137824ULL, 0x040fe200000e0613ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010097faeULL, 0x0003e2000b901c46ULL, 0x000000010d357824ULL, 0x000fc400010e0635ULL,
0x000000103a3b7824ULL, 0x000fe200078e023cULL, 0x00000000120f7faeULL, 0x0003e2000b901c46ULL,
0x000000010d0d7824ULL, 0x000fc600018e0637ULL, 0x0000000034397faeULL, 0x0003e8000b901c46ULL,
0x000000000c3b7faeULL, 0x0003e4000b901c46ULL, 0x0000000800097824ULL, 0x002fe200078e00ffULL,
0x00000001030c7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff4a7424ULL, 0x000fc600078e00ffULL,
0xfffffff009117812ULL, 0x040fe400078ec0ffULL, 0x000000650c00720cULL, 0x000fe40003f06070ULL,
0x00000000110473c2ULL, 0x000e6200000e0000ULL, 0xffffffe0090f7812ULL, 0x040fe400078ec0ffULL,
0x0000001009107812ULL, 0x040fe400078ec0ffULL, 0x0000000809097812ULL, 0x000fcc00078ec0ffULL,
0x00000001700c8824ULL, 0x000fe400078e020cULL, 0x00000004ff0d8424ULL, 0x000fe200078e00ffULL,
0x0000000f09097210ULL, 0x000fe40007ffe010ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000066000c0c8625ULL, 0x000fca00078e000dULL, 0x000000060c4a8981ULL, 0x000522000c1e1900ULL,
0x0000f6b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x00f6b00011107f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6080009347f8cULL, 0x0004e4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x00f60c00090f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x00cfe40007804835ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120c127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0dULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011413ULL,
0x000000120f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x000000020f0f7819ULL, 0x000fc80000001212ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60c00090f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001049517824ULL, 0x000fe200078e00ffULL, 0x00000001ff7b7819ULL, 0x000fe20000011649ULL,
0x00000020000c7824ULL, 0x000fc600078e00ffULL, 0x0000007051517812ULL, 0x000fe400078ec0ffULL,
0xffffff800c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c7b7b7812ULL, 0x000fc800078ec0ffULL,
0x0000000c7b0c7210ULL, 0x000fca0007ffe051ULL, 0x00f000000c0f7984ULL, 0x000ea80000000800ULL,
0x00f200000c347984ULL, 0x0006620000000800ULL, 0x0000000a0f00720bULL, 0x004fe20003f1d000ULL,
0x0000fe827f007947ULL, 0x000fd8000b800000ULL, 0x00000000000d7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0d377812ULL, 0x000fe2000780c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000001ff357424ULL, 0x000fd600078e00ffULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x000000007600720cULL, 0x000fe40003f05270ULL, 0x0000000a0f00720bULL, 0x000fe20003f54000ULL,
0x0000fe427f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x000fc400010e0100ULL,
0x0000008000128824ULL, 0x000fe200078e0251ULL, 0x0000000a0f137209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099100c0d7816ULL, 0x000fe200000000ffULL,
0x000000017b128824ULL, 0x000fca00078e0212ULL, 0x00f4001312008388ULL, 0x0005e20000000800ULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x800000130a0d7221ULL, 0x004fe20000010000ULL, 0x000000ff0cff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d00367308ULL, 0x000ea40000000800ULL, 0x000000360b0b7220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011649ULL,
0x0000fd727f007947ULL, 0x000fea000b800000ULL, 0x00001f0d360d7589ULL, 0x0004e400000e0000ULL,
0x0000000d20207220ULL, 0x08cfe20000410000ULL, 0x0000000d21217220ULL, 0x080fe20000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000d1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000d18187220ULL, 0x080fe20000410000ULL, 0x0000000d19197220ULL, 0x080fe20000410000ULL,
0x0000000d14147220ULL, 0x080fe20000410000ULL, 0x0000000d15157220ULL, 0x080fe20000410000ULL,
0x0000000d30307220ULL, 0x080fe20000410000ULL, 0x0000000d31317220ULL, 0x080fe20000410000ULL,
0x0000000d2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000d28287220ULL, 0x080fe20000410000ULL, 0x0000000d29297220ULL, 0x080fe20000410000ULL,
0x0000000d24247220ULL, 0x080fe20000410000ULL, 0x0000000d25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008490d7811ULL, 0x000fe200078ff0ffULL,
0x0000fc527f007947ULL, 0x000fea000b800000ULL, 0x00001f0d360d7589ULL, 0x0004e400000e0000ULL,
0x0000000d22227220ULL, 0x08cfe20000410000ULL, 0x0000000d23237220ULL, 0x080fe20000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000d1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000d1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000d1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000d16167220ULL, 0x080fe20000410000ULL, 0x0000000d17177220ULL, 0x080fe20000410000ULL,
0x0000000d32327220ULL, 0x080fe20000410000ULL, 0x0000000d33337220ULL, 0x080fe20000410000ULL,
0x0000000d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000d2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000d2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000d26267220ULL, 0x080fe20000410000ULL, 0x0000000d27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff37ff7812ULL, 0x000fe2000780600cULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x0000000a0f0a7209ULL, 0x000fd60007810000ULL,
0x8000000a0f0f0221ULL, 0x000fe20000010000ULL, 0x00007610ff350816ULL, 0x000fc60000000035ULL,
0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL, 0x0000000f00060308ULL, 0x000ea40000000800ULL,
0x0000000634340220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000b340b7221ULL, 0x002fc20000010000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x00000008000f7824ULL, 0x000fca00078e00ffULL, 0xfffffff00f347812ULL, 0x000fca00078ec0ffULL,
0x00f6ac00340f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780480eULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120c127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0dULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011413ULL,
0x000000120f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x000000020f0f7819ULL, 0x000fc80000001212ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac00340f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000780480eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910350c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000006ff07723eULL, 0x000fe400000000ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011649ULL,
0x00005410070c7816ULL, 0x000fe20000000007ULL, 0x0000f8027f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0c077589ULL, 0x0002a400000e0000ULL, 0x000000080f0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000f8327f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0c087589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100f0d7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e000cULL, 0x000030d000137802ULL, 0x000fc40000000f00ULL,
0x0001021000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180f0d7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e000cULL,
0x0000312000137802ULL, 0x000fc40000000f00ULL, 0x000101c000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002006c7824ULL, 0x000fe200078e00ffULL,
0x00000007490d7812ULL, 0x00cfe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x000000046c0c7812ULL, 0x002fc400078ec0ffULL, 0x000000080d0e7812ULL, 0x000fe400078ef849ULL,
0x0000000c49737211ULL, 0x040fe200078fe0ffULL, 0x00000200000c7824ULL, 0x000fe400078e00ffULL,
0x000000080e747824ULL, 0x040fe400078e00ffULL, 0x000000010e737824ULL, 0x000fe200078e0273ULL,
0xfffff8000c0f7812ULL, 0x000fe400078ec0ffULL, 0x00000008490c7812ULL, 0x000fc400078ec0ffULL,
0xfffffff874747812ULL, 0x000fca00078ee273ULL, 0x0000001074747824ULL, 0x000fc800078e00ffULL,
0x00000001744e7824ULL, 0x000fc600078e020fULL, 0x0000000400137824ULL, 0x000fe200078e00ffULL,
0x00000004ff3e7819ULL, 0x000fe20000011649ULL, 0x009000004e34783bULL, 0x000e620000000200ULL,
0x0000000d0c127212ULL, 0x000fe200078efcffULL, 0x000000080e507824ULL, 0x000fe200078e00ffULL,
0x0000000413137812ULL, 0x000fe400078ec0ffULL, 0x0000b00063717811ULL, 0x000fe200078e68ffULL,
0x00000008124d7824ULL, 0x000fe200078e00ffULL, 0x000000100c447812ULL, 0x000fe200078efe0dULL,
0x000000013e137824ULL, 0x000fe200078e0213ULL, 0xfffffff86c6c7812ULL, 0x000fe200078ec0ffULL,
0x00000008120d7824ULL, 0x000fc400078e00ffULL, 0x00000001123c7824ULL, 0x000fe400078e0213ULL,
0x00000008440c7824ULL, 0x040fe400078e00ffULL, 0x0000000113457824ULL, 0x000fe200078e0244ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee23cULL, 0x0000000844447824ULL, 0x000fe200078e00ffULL,
0x000000023c4c7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80c4b7812ULL, 0x000fe200078ee245ULL,
0x000000104d387824ULL, 0x100fe200078e0271ULL, 0xfffffff80d4c7812ULL, 0x000fe200078ee24cULL,
0x00000004630d7824ULL, 0x000fe200078e023eULL, 0x00000002454f7810ULL, 0x000fe20007ffe0ffULL,
0x000000104b407824ULL, 0x000fc400078e0271ULL, 0x000000003838783bULL, 0x000ea20000004200ULL,
0x000000104c3c7824ULL, 0x000fe200078e0271ULL, 0x000000020d137810ULL, 0x000fe40007ffe00eULL,
0x000000004040783bULL, 0x000fe20000004200ULL, 0xfffffff8444f7812ULL, 0x000fe400078ee24fULL,
0xfffffff850507812ULL, 0x000fe200078ee213ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x0000000734348232ULL, 0x002fc60000000000ULL, 0x0000001050507824ULL, 0x000fe200078e020fULL,
0x0000000736368232ULL, 0x000fe40000000000ULL, 0x0000000835358232ULL, 0x080fe40000000000ULL,
0x0000000837378232ULL, 0x000fe20000000000ULL, 0x0000ffff3a0d7812ULL, 0x004fe400078ec0ffULL,
0x00000018ff0c7819ULL, 0x000fe4000001163aULL, 0x00000008ff0d7819ULL, 0x000fc4000001160dULL,
0x0000000cff0e723eULL, 0x000fe400020006ffULL, 0x0000000dff0c723eULL, 0x000fe400020006ffULL,
0x0000ffff3b0d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff127819ULL, 0x000fe4000001163bULL,
0x00000008ff0d7819ULL, 0x000fe4000001160dULL, 0x00000012ff12723eULL, 0x000fc400020006ffULL,
0x0000000dff0d723eULL, 0x000fe400020006ffULL, 0x00000010ff467819ULL, 0x000fe40000011638ULL,
0x000054100d0d7816ULL, 0x000fe40000000012ULL, 0x00000010ff127819ULL, 0x000fe40000011639ULL,
0x000054100c0c7816ULL, 0x000fe4000000000eULL, 0x000000ff38547812ULL, 0x000fc400078ec0ffULL,
0x000000ff46467812ULL, 0x000fe400078ec0ffULL, 0x000000ff39477812ULL, 0x000fe200078ec0ffULL,
0x0000000c340c723cULL, 0x000be20000001814ULL, 0x000000ff12127812ULL, 0x000fe400078ec0ffULL,
0x00000018ff577819ULL, 0x000fe40000011638ULL, 0x0000ffff38387812ULL, 0x000fe400078ec0ffULL,
0x00000018ff567819ULL, 0x000fc40000011639ULL, 0x0000ffff39447812ULL, 0x000fe400078ec0ffULL,
0x00000010ff137819ULL, 0x000fe4000001163aULL, 0x000000ff3a787812ULL, 0x000fe400078ec0ffULL,
0x00000054ff39723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fc400020006ffULL, 0x00000012ff3a723eULL, 0x000fe400020006ffULL,
0x00000010ff147819ULL, 0x128fe4000001163eULL, 0x000000ff3e727812ULL, 0x040fe400078ec0ffULL,
0x00000018ff677819ULL, 0x000fe4000001163eULL, 0x0000ffff3e607812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3e7819ULL, 0x000fc40000011638ULL, 0x0000541039387816ULL, 0x000fe40000000046ULL,
0x0000541047397816ULL, 0x000fe4000000003aULL, 0x00000010ff457819ULL, 0x000fe4000001163bULL,
0x000000ff3b777812ULL, 0x000fe400078ec0ffULL, 0x000000ff423b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff447819ULL, 0x000fc40000011644ULL, 0x0000003bff12723eULL, 0x000fe400020006ffULL,
0x000000383438723cULL, 0x000be20000001820ULL, 0x00000010ff697819ULL, 0x100fe4000001163cULL,
0x000000ff3c6b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe4000001163cULL,
0x000000ff13217812ULL, 0x020fe400078ec0ffULL, 0x000000ff45207812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3c157812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6a7819ULL, 0x100fe4000001163dULL,
0x000000ff3d6e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001163dULL,
0x0000ffff3d167812ULL, 0x000fe400078ec0ffULL, 0x00000057ff3c723eULL, 0x000fc400020006ffULL,
0x00000056ff3d723eULL, 0x000fe400020006ffULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x00000021ff21723eULL, 0x000fc400020006ffULL,
0x00000020ff20723eULL, 0x000fe400020006ffULL, 0x00000018ff527819ULL, 0x100fe40000011640ULL,
0x000000ff40557812ULL, 0x000fe400078ec0ffULL, 0x00000018ff537819ULL, 0x000fe40000011641ULL,
0x000000ff41547812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5d7819ULL, 0x000fc40000011640ULL,
0x0000ffff405a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff597819ULL, 0x000fe40000011641ULL,
0x0000ffff415c7812ULL, 0x000fe400078ec0ffULL, 0x000054103e3c7816ULL, 0x000fe4000000003cULL,
0x00005410443d7816ULL, 0x000fe2000000003dULL, 0x000000104f447824ULL, 0x000fe200078e0271ULL,
0x0000541078407816ULL, 0x000fc40000000021ULL, 0x0000541077417816ULL, 0x000fe40000000020ULL,
0x000000ff3f177812ULL, 0x040fe200078ec0ffULL, 0x000000004444783bULL, 0x000fe20000004200ULL,
0x00000010ff647819ULL, 0x100fe4000001163fULL, 0x00000018ff617819ULL, 0x000fe4000001163fULL,
0x0000ffff3f627812ULL, 0x000fe400078ec0ffULL, 0x000000ff43227812ULL, 0x000fe200078ec0ffULL,
0x0000003c343c723cULL, 0x000be2000000181cULL, 0x00000010ff5b7819ULL, 0x000fc40000011642ULL,
0x00000018ff5e7819ULL, 0x000fe40000011642ULL, 0x0000ffff42567812ULL, 0x000fe400078ec0ffULL,
0x00000010ff577819ULL, 0x100fe40000011643ULL, 0x00000018ff5f7819ULL, 0x000fe40000011643ULL,
0x0000ffff43587812ULL, 0x000fe400078ec0ffULL, 0x000000403440723cULL, 0x000b640000001818ULL,
0x000000ff141e7812ULL, 0x020fc400078ec0ffULL, 0x00000068ff1c723eULL, 0x000fe400020006ffULL,
0x0000006dff1d723eULL, 0x000fe400020006ffULL, 0x00000008ff187819ULL, 0x000fe40000011615ULL,
0x00000017ff19723eULL, 0x000fe400020006ffULL, 0x00000008ff1a7819ULL, 0x000fe40000011616ULL,
0x009000005014783bULL, 0x000e620000000200ULL, 0x000000ff69697812ULL, 0x000fc400078ec0ffULL,
0x000000ff6a6a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff18723eULL, 0x000fe400020006ffULL,
0x0000001aff1b723eULL, 0x000fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x00000069ff20723eULL, 0x000fc400020006ffULL,
0x0000006aff21723eULL, 0x000fe400020006ffULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00005410181c7816ULL, 0x000fe4000000001cULL, 0x000054101b1d7816ULL, 0x000fe4000000001dULL,
0x00000072ff68723eULL, 0x000fe400020006ffULL, 0x000054106b207816ULL, 0x000fc40000000020ULL,
0x000054106e217816ULL, 0x000fe40000000021ULL, 0x0000001eff1a723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x0000001c341c723cULL, 0x000be2000000182cULL,
0x0000541068187816ULL, 0x000fe4000000001aULL, 0x0000541019197816ULL, 0x000fe40000000064ULL,
0x00000022ff13723eULL, 0x000fc400020006ffULL, 0x00000008ff2e7819ULL, 0x020fe20000011660ULL,
0x000000203420723cULL, 0x040b620000001830ULL, 0x00000008ff2d7819ULL, 0x000fe20000011662ULL,
0x0000000714148232ULL, 0x082fe20000000000ULL, 0x000000ff5b5b7812ULL, 0x000fe200078ec0ffULL,
0x0000000716168232ULL, 0x000fe20000000000ULL, 0x000000ff57577812ULL, 0x000fe200078ec0ffULL,
0x0000000815158232ULL, 0x080fe20000000000ULL, 0x00000067ff30723eULL, 0x020fe200020006ffULL,
0x000000183418723cULL, 0x000b620000001828ULL, 0x00000061ff2c723eULL, 0x000fe200020006ffULL,
0x0000000817178232ULL, 0x000fe20000000000ULL, 0x0000002eff2e723eULL, 0x000fc400020006ffULL,
0x0000002dff2d723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000008ff567819ULL, 0x000fe40000011656ULL, 0x00000008ff587819ULL, 0x000fe40000011658ULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x000054102e287816ULL, 0x020fc40000000030ULL,
0x000054102d297816ULL, 0x000fe4000000002cULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x000000283434723cULL, 0x000b620000001824ULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000541012127816ULL, 0x000fc4000000005bULL, 0x0000541013137816ULL, 0x000fe40000000057ULL,
0x00000008ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff2b7819ULL, 0x000fe40000011644ULL,
0x00000010ff677819ULL, 0x000fe20000011645ULL, 0x000000121424723cULL, 0x000b620000001840ULL,
0x00005410565e7816ULL, 0x000fe4000000005eULL, 0x00005410585f7816ULL, 0x000fc4000000005fULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000018ff2a7819ULL, 0x000fe40000011644ULL,
0x0000005aff29723eULL, 0x020fe400020006ffULL, 0x000000ff446a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff456b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff2b127812ULL, 0x000fc400078ec0ffULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x0000541029527816ULL, 0x000fe40000000052ULL,
0x0000002aff13723eULL, 0x000fe400020006ffULL, 0x0000005e1428723cULL, 0x000b62000000180cULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x0000ffff44617812ULL, 0x000fc400078ec0ffULL, 0x00000012ff0c723eULL, 0x020fe400020006ffULL,
0x00000067ff0d723eULL, 0x000fe400020006ffULL, 0x0000ffff45627812ULL, 0x000fe400078ec0ffULL,
0x000054106a0c7816ULL, 0x000fe4000000000cULL, 0x000054106b0d7816ULL, 0x000fe4000000000dULL,
0x00000018ff687819ULL, 0x000fc40000011645ULL, 0x00000008ff617819ULL, 0x000fe40000011661ULL,
0x00000008ff627819ULL, 0x000fe20000011662ULL, 0x0000000c1420723cULL, 0x000b620000001820ULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x000000ff5d2f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff607819ULL, 0x000fe40000011646ULL, 0x00000061ff0c723eULL, 0x020fc400020006ffULL,
0x00000062ff0d723eULL, 0x000fe400020006ffULL, 0x00000010ff5d7819ULL, 0x000fe40000011647ULL,
0x000054100c0c7816ULL, 0x000fe40000000013ULL, 0x000054100d0d7816ULL, 0x000fe40000000068ULL,
0x000000ff46697812ULL, 0x000fe400078ec0ffULL, 0x000000ff47647812ULL, 0x000fc400078ec0ffULL,
0x000000ff60607812ULL, 0x000fe200078ec0ffULL, 0x0000000c141c723cULL, 0x000b62000000181cULL,
0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000060ff0c723eULL, 0x020fe400020006ffULL,
0x0000005dff0d723eULL, 0x000fc400020006ffULL, 0x00000018ff457819ULL, 0x000fe40000011646ULL,
0x00000018ff447819ULL, 0x000fe40000011647ULL, 0x0000ffff46467812ULL, 0x000fe400078ec0ffULL,
0x0000ffff47477812ULL, 0x000fe400078ec0ffULL, 0x00005410690c7816ULL, 0x000fe4000000000cULL,
0x00005410640d7816ULL, 0x000fc4000000000dULL, 0x000000ff59597812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5c7819ULL, 0x000fe4000001165cULL, 0x00000008ff467819ULL, 0x000fe20000011646ULL,
0x0000000c1418723cULL, 0x000b620000001818ULL, 0x00000008ff477819ULL, 0x000fe40000011647ULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fc400020006ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x0000002fff2f723eULL, 0x000fe400020006ffULL,
0x00000059ff31723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000044ff44723eULL, 0x000fc400020006ffULL,
0x00000046ff0c723eULL, 0x020fe400020006ffULL, 0x00000047ff0d723eULL, 0x000fe400020006ffULL,
0x0000541055307816ULL, 0x000fe4000000002fULL, 0x0000541054317816ULL, 0x000fe40000000031ULL,
0x000054105c537816ULL, 0x000fe40000000053ULL, 0x000054100c0c7816ULL, 0x000fc40000000045ULL,
0x000054100d0d7816ULL, 0x000fe20000000044ULL, 0x000000301430723cULL, 0x040f700000001838ULL,
0x00000052142c723cULL, 0x040f70000000183cULL, 0x0000000c1414723cULL, 0x000b6e0000001834ULL,
0x0000f6c8630c7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000000c0c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f688006cff7f8cULL, 0x0005e4000c80043fULL, 0x00000000000e7805ULL, 0x000fc40000015200ULL,
0x0000040005137984ULL, 0x000ee40000000800ULL, 0x8000000013ff7812ULL, 0x00afc4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120e357210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0fULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000003512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040005137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010000e7824ULL, 0x000fe400078e00ffULL, 0x000059004a4a7a24ULL, 0x010fc600078e02ffULL,
0xffffffe00e0d7812ULL, 0x000fe200078ec0ffULL, 0x000000404a0c7824ULL, 0x000fc800078e00ffULL,
0x00000100480d7824ULL, 0x000fca00078e020dULL, 0x000000800d0f7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0d7424ULL, 0x000fc600078e00ffULL, 0x000000200f127812ULL, 0x000fe200078ec0ffULL,
0x000064000c0c7625ULL, 0x000fc800078e000dULL, 0x000000016f127824ULL, 0x000fe200078e0212ULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x000000100e137812ULL, 0x000fe400078ec0ffULL,
0x0000000f020e7217ULL, 0x000fe40007800000ULL, 0x00000003ff347819ULL, 0x000fc60000011649ULL,
0x000000010e0e7824ULL, 0x000fe200078e0a0fULL, 0x0000000434367810ULL, 0x040fe20007ffe0ffULL,
0x00000001340f7824ULL, 0x040fe200078e0213ULL, 0x0000000c34377810ULL, 0x000fe40007ffe0ffULL,
0x0000000e130e7217ULL, 0x000fe20007800000ULL, 0x000000010f357824ULL, 0x040fe400078e0249ULL,
0x000000080f387824ULL, 0x000fe400078e00ffULL, 0x000000010e0e7824ULL, 0x000fc400078e0a13ULL,
0x000000010f0f7824ULL, 0x000fe200078e0212ULL, 0xfffffff838387812ULL, 0x000fe200078ee235ULL,
0x00000001373d7824ULL, 0x100fe200078e0213ULL, 0x0000000e3600720cULL, 0x0c0fe20003f66070ULL,
0x0000000136367824ULL, 0x000fe200078e0213ULL, 0x0000000834357810ULL, 0x040fe20007ffe0ffULL,
0x000000013d3e7824ULL, 0x100fe200078e0249ULL, 0x0000000e3400720cULL, 0x080fe20003f86070ULL,
0x0000000136347824ULL, 0x040fe200078e0249ULL, 0x0000000e3500720cULL, 0x080fe20003f46070ULL,
0x0000000836397824ULL, 0x000fe200078e00ffULL, 0x0000000e3700720cULL, 0x000fe20003f06070ULL,
0x000000800f0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff8393a7812ULL, 0x000fe200078ee234ULL,
0x0000000135357824ULL, 0x000fe200078e0213ULL, 0x000000510e137212ULL, 0x000fe200078efcffULL,
0x0000000136367824ULL, 0x000fe400078e0212ULL, 0x0000000135397824ULL, 0x040fe200078e0249ULL,
0x000000130c0e7210ULL, 0x000fe20007fbe0ffULL, 0x00000008353c7824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee239ULL,
0x0000000135347824ULL, 0x100fe200078e0212ULL, 0x0000005136397212ULL, 0x000fe200078efcffULL,
0x000000013d127824ULL, 0x000fe400078e0212ULL, 0x0000008034347825ULL, 0x000fc800078e00ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000051343b7212ULL, 0x000fc600078efcffULL,
0x000000010d0f7824ULL, 0x000fe200028e060fULL, 0x000000390c367210ULL, 0x000fe20007fbe0ffULL,
0x000000083d3d7824ULL, 0x000fe200078e00ffULL, 0x0000005112397212ULL, 0x000fc600078efcffULL,
0x000000010d377824ULL, 0x000fe200028e0637ULL, 0x0000003b0c347210ULL, 0x000fe20007fbe0ffULL,
0x000000103c3b7824ULL, 0x100fe200078e0271ULL, 0x000000390c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001038397824ULL, 0x000fe200078e0271ULL, 0xfffffff83d3e7812ULL, 0x000fe200078ee23eULL,
0x000000010d357824ULL, 0x040fe400028e0635ULL, 0x000000010d0d7824ULL, 0x000fe200030e0613ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e397faeULL, 0x0003e2000e101c46ULL,
0x000000103a137824ULL, 0x000fc400078e0271ULL, 0x000000103e3d7824ULL, 0x000fc600078e0271ULL,
0x0000000036137faeULL, 0x0003e8000d901c46ULL, 0x00000000343b7faeULL, 0x0003e8000d101c46ULL,
0x000000000c3d7faeULL, 0x0003e2000c101c46ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x000000100e0e7812ULL, 0x000fc800078ec0ffULL, 0x0000000e490e7211ULL, 0x000fc800078fe8ffULL,
0x000000040e367810ULL, 0x040fe20007ffe0ffULL, 0x000000010e0f7824ULL, 0x140fe200078e0249ULL,
0x000000080e357810ULL, 0x040fe20007ffe0ffULL, 0x000000080e387824ULL, 0x000fe400078e00ffULL,
0x0000000136137824ULL, 0x040fe400078e0249ULL, 0x00000008363a7824ULL, 0x000fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee20fULL, 0x000000010e347824ULL, 0x040fe200078e0212ULL,
0x0000000c0e0f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000135377824ULL, 0x040fe200078e0249ULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee213ULL, 0x00000008353c7824ULL, 0x000fc400078e00ffULL,
0x0000000135137824ULL, 0x000fe400078e0212ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fc600078ee237ULL, 0x0000000136367824ULL, 0x100fe200078e0212ULL,
0x0000005134397212ULL, 0x000fe200078efcffULL, 0x000000010f0e7824ULL, 0x040fe400078e0212ULL,
0x000000010f3b7824ULL, 0x040fe200078e0249ULL, 0x000000390c347210ULL, 0x000fe20007f1e0ffULL,
0x000000080f3e7824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee23bULL, 0x0000008013127825ULL, 0x000fe200078e00ffULL,
0x00000051363d7212ULL, 0x000fc600078efcffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x00000051123b7212ULL, 0x000fe400078efcffULL, 0x0000003d0c367210ULL, 0x000fe20007f5e0ffULL,
0x000000010d357824ULL, 0x040fe200000e0635ULL, 0x000000510e397212ULL, 0x000fe200078efcffULL,
0x000000103e3d7824ULL, 0x000fe200078e0271ULL, 0x0000003b0c127210ULL, 0x040fe20007f1e0ffULL,
0x000000010d377824ULL, 0x000fe200010e0637ULL, 0x000000390c0c7210ULL, 0x000fe20007f7e0ffULL,
0x0000001038397824ULL, 0x000fc400078e0271ULL, 0x000000010d137824ULL, 0x040fe400000e0613ULL,
0x000000010d0d7824ULL, 0x000fe200018e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034397faeULL, 0x0003e2000b901c46ULL, 0x000000103a0f7824ULL, 0x100fe400078e0271ULL,
0x000000103c3b7824ULL, 0x000fc600078e0271ULL, 0x00000000360f7faeULL, 0x0003e8000b901c46ULL,
0x00000000123b7faeULL, 0x0003e8000b901c46ULL, 0x000000000c3d7faeULL, 0x0003e4000b901c46ULL,
0x00000008000d7824ULL, 0x002fe200078e00ffULL, 0x00000002030e7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0c7424ULL, 0x000fc600078e00ffULL, 0xfffffff00d0d7812ULL, 0x000fe400078ec0ffULL,
0x000000650e00720cULL, 0x000fe40003f06070ULL, 0x000000000d0473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x00000001700e8824ULL, 0x000fc400078e020eULL,
0x00000004ff0f8424ULL, 0x000fc800078e00ffULL, 0x000066000e0e8625ULL, 0x000fca00078e000fULL,
0x000000060e0c8981ULL, 0x000722000c1e1900ULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x008fec0000008000ULL, 0x00f6a8000d0e7f8cULL, 0x0002e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6280009127f8cULL, 0x0002a4000c80043fULL,
0x0000000000347805ULL, 0x000fc40000015200ULL, 0x00f62c00090d7984ULL, 0x002e640000000800ULL,
0x800000000dff7812ULL, 0x006fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634367210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc80000011437ULL, 0x000000360d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff367224ULL, 0x000fca00000e0637ULL, 0x000000020d0d7819ULL, 0x000fc80000001236ULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f62c00090d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020000d7824ULL, 0x000fca00078e00ffULL,
0xffffff800d127812ULL, 0x000fc800078ec0ffULL, 0x0000008051127810ULL, 0x000fca0007ffe012ULL,
0x000000017b127824ULL, 0x000fca00078e0212ULL, 0x00f0000012357984ULL, 0x000e680000000800ULL,
0x00f2000012347984ULL, 0x0004e20000000800ULL, 0x0000000a3500720bULL, 0x002fe20003f1d000ULL,
0x0000d8627f007947ULL, 0x000fd8000b800000ULL, 0x00000000000d7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0d377812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0d7424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000001760d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000a3500720bULL, 0x000fe40003f54000ULL,
0x000000000d00720cULL, 0x000fe20003f05270ULL, 0x0000d8127f007947ULL, 0x000fd4000b800000ULL,
0x0000000000367806ULL, 0x000fc400010e0100ULL, 0x0000008000128824ULL, 0x000fe200078e0251ULL,
0x0000000a350d8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x000000017b388824ULL, 0x000fe200078e0212ULL, 0x0000991036127816ULL, 0x000fc800000000ffULL,
0x00f4000d38008388ULL, 0x0003e20000000800ULL, 0x000000ff1200720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000a350d7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff36ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000a0d0d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d00387308ULL, 0x000e640000000800ULL, 0x000000380b0b7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011649ULL,
0x0000d7327f007947ULL, 0x000fea000b800000ULL, 0x00001f0d380d7589ULL, 0x0002a400000e0000ULL,
0x0000000d30307220ULL, 0x084fe20000410000ULL, 0x0000000d31317220ULL, 0x080fe20000410000ULL,
0x0000000d2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000d24247220ULL, 0x080fe20000410000ULL, 0x0000000d25257220ULL, 0x080fe20000410000ULL,
0x0000000d28287220ULL, 0x080fe20000410000ULL, 0x0000000d29297220ULL, 0x080fe20000410000ULL,
0x0000000d20207220ULL, 0x080fe20000410000ULL, 0x0000000d21217220ULL, 0x080fe20000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000d1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000d18187220ULL, 0x080fe20000410000ULL, 0x0000000d19197220ULL, 0x080fe20000410000ULL,
0x0000000d14147220ULL, 0x080fe20000410000ULL, 0x0000000d15157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0036ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008490d7811ULL, 0x000fe200078ff0ffULL,
0x0000d6127f007947ULL, 0x000fea000b800000ULL, 0x00001f0d380d7589ULL, 0x00046400000e0000ULL,
0x0000000d32327220ULL, 0x086fe20000410000ULL, 0x0000000d33337220ULL, 0x080fe20000410000ULL,
0x0000000d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000d26267220ULL, 0x080fe20000410000ULL, 0x0000000d27277220ULL, 0x080fe20000410000ULL,
0x0000000d2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000d2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000d22227220ULL, 0x080fe20000410000ULL, 0x0000000d23237220ULL, 0x080fe20000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000d1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000d1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000d1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000d16167220ULL, 0x080fe20000410000ULL, 0x0000000d17177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff37ff7812ULL, 0x000fe20007806036ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000a350a7209ULL, 0x000fd60007810000ULL,
0x8000000a35350221ULL, 0x000fe20000010000ULL, 0x00007610ff0d0816ULL, 0x000fc6000000000dULL,
0x3fb8aa3b35350820ULL, 0x000fc80000410000ULL, 0x0000003500060308ULL, 0x000e640000000800ULL,
0x0000000634340220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000b340b7221ULL, 0x008fc20000010000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000000800347824ULL, 0x000fca00078e00ffULL, 0xfffffff034367812ULL, 0x000fca00078ec0ffULL,
0x00f6b40036357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003412377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e13ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b40036357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100d0d7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000006ff07723eULL, 0x000fe400000000ffULL, 0x00000002ff117819ULL, 0x000fe40000011649ULL,
0x0000541007107816ULL, 0x000fe20000000007ULL, 0x0000d1c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1110077589ULL, 0x0002a400000e0000ULL, 0x00000008110d7810ULL, 0x000fe20007ffe0ffULL,
0x0000d1f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d10087589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010110d7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e0010ULL, 0x000058d000137802ULL, 0x000fc40000000f00ULL,
0x0000da1000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018110d7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e0010ULL,
0x0000592000137802ULL, 0x000fc40000000f00ULL, 0x0000d9c000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x00001000714a7810ULL, 0x000fe20007ffe0ffULL, 0x009800004e10783bULL, 0x00ae680000000200ULL,
0x000000104d6e7824ULL, 0x000fc400078e024aULL, 0x000000104c3c7824ULL, 0x100fe400078e024aULL,
0x000000104b647824ULL, 0x000fe200078e024aULL, 0x000000006e34783bULL, 0x000ee80000004200ULL,
0x000000003c3c783bULL, 0x000ea80000004200ULL, 0x000000006438783bULL, 0x000ea40000004200ULL,
0x0000000710108232ULL, 0x006fc40000000000ULL, 0x0000000712128232ULL, 0x000fe40000000000ULL,
0x0000000811118232ULL, 0x080fe40000000000ULL, 0x0000000813138232ULL, 0x000fe20000000000ULL,
0x000000ff34407812ULL, 0x008fe400078ec0ffULL, 0x00000010ff427819ULL, 0x000fe40000011634ULL,
0x00000010ff697819ULL, 0x000fe4000001163cULL, 0x000000ff3c5a7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff587819ULL, 0x000fe4000001163cULL, 0x0000ffff3c6a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3d3c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe40000011634ULL,
0x0000ffff34447812ULL, 0x000fe400078ec0ffULL, 0x00000010ff0d7819ULL, 0x000fc40000011635ULL,
0x00000040ff34723eULL, 0x000fe400020006ffULL, 0x00000010ff5f7819ULL, 0x100fe4000001163eULL,
0x000000ff3e437812ULL, 0x040fe400078ec0ffULL, 0x00000018ff527819ULL, 0x000fe4000001163eULL,
0x0000ffff3e407812ULL, 0x000fe400078ec0ffULL, 0x00000010ff457819ULL, 0x000fc40000011636ULL,
0x000000ff36597812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6d7819ULL, 0x000fe40000011636ULL,
0x0000ffff36557812ULL, 0x000fe400078ec0ffULL, 0x0000003cff3e723eULL, 0x000fe400020006ffULL,
0x00000018ff367819ULL, 0x000fe4000001163dULL, 0x00000058ff3c723eULL, 0x000fc400020006ffULL,
0x000000ff35417812ULL, 0x000fe400078ec0ffULL, 0x000000ff42587812ULL, 0x000fe400078ec0ffULL,
0x000000ff0d0d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6b7819ULL, 0x000fe4000001163dULL,
0x0000ffff3d677812ULL, 0x000fe400078ec0ffULL, 0x00000018ff477819ULL, 0x000fc40000011635ULL,
0x0000ffff35467812ULL, 0x000fe400078ec0ffULL, 0x00000036ff3d723eULL, 0x000fe400020006ffULL,
0x00000010ff537819ULL, 0x100fe40000011637ULL, 0x000000ff37567812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6c7819ULL, 0x000fe40000011637ULL, 0x0000ffff375b7812ULL, 0x000fc400078ec0ffULL,
0x00000041ff35723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000000dff36723eULL, 0x000fe400020006ffULL, 0x000000ff3f377812ULL, 0x000fe400078ec0ffULL,
0x0000541034347816ULL, 0x000fe40000000058ULL, 0x0000541035357816ULL, 0x000fc40000000036ULL,
0x00000037ff42723eULL, 0x000fe400020006ffULL, 0x00000018ff377819ULL, 0x000fe40000011638ULL,
0x00000008ff447819ULL, 0x000fe40000011644ULL, 0x00000008ff467819ULL, 0x000fe40000011646ULL,
0x00000037ff0d723eULL, 0x000fe400020006ffULL, 0x000000341034723cULL, 0x000b620000001830ULL,
0x00000057ff57723eULL, 0x000fc400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000044ff30723eULL, 0x020fe200020006ffULL,
0x000000104f447824ULL, 0x000fe200078e024aULL, 0x00000046ff31723eULL, 0x000fe400020006ffULL,
0x000000ff45337812ULL, 0x000fe400078ec0ffULL, 0x000000ff53327812ULL, 0x000fc400078ec0ffULL,
0x0000541030307816ULL, 0x000fe40000000057ULL, 0x0000541031317816ULL, 0x000fe40000000047ULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x000000004444783bULL, 0x000fe20000004200ULL,
0x00000033ff33723eULL, 0x000fe400020006ffULL, 0x00000032ff32723eULL, 0x000fe200020006ffULL,
0x00000030102c723cULL, 0x000b62000000182cULL, 0x0000006dff6d723eULL, 0x000fc400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x000000ff69697812ULL, 0x000fe400078ec0ffULL,
0x0000541059307816ULL, 0x020fe40000000033ULL, 0x0000541056317816ULL, 0x000fe40000000032ULL,
0x00000008ff327819ULL, 0x000fe4000001165bULL, 0x000000ff3b337812ULL, 0x000fc400078ec0ffULL,
0x000000ff6b6b7812ULL, 0x000fe200078ec0ffULL, 0x000000301024723cULL, 0x000b620000001824ULL,
0x00000010ff417819ULL, 0x100fe4000001163fULL, 0x00000018ff547819ULL, 0x000fe4000001163fULL,
0x0000ffff3f5c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff307819ULL, 0x020fe4000001163aULL,
0x00000008ff317819ULL, 0x000fc40000011655ULL, 0x00000030ff55723eULL, 0x000fe400020006ffULL,
0x00000031ff30723eULL, 0x000fe400020006ffULL, 0x00000032ff31723eULL, 0x000fe400020006ffULL,
0x0000541030307816ULL, 0x000fe4000000006dULL, 0x0000541031317816ULL, 0x000fe4000000006cULL,
0x000000ff38587812ULL, 0x000fc400078ec0ffULL, 0x00000018ff537819ULL, 0x100fe40000011639ULL,
0x000000ff39577812ULL, 0x040fe200078ec0ffULL, 0x000000301028723cULL, 0x000b620000001828ULL,
0x00000010ff687819ULL, 0x000fe40000011638ULL, 0x0000ffff38607812ULL, 0x000fe400078ec0ffULL,
0x00000010ff617819ULL, 0x000fe40000011639ULL, 0x0000ffff39627812ULL, 0x000fc400078ec0ffULL,
0x00000033ff5b723eULL, 0x000fe400020006ffULL, 0x0000005aff3f723eULL, 0x000fe200020006ffULL,
0x009800005030783bULL, 0x020e620000000200ULL, 0x00000069ff38723eULL, 0x000fe400020006ffULL,
0x0000006bff39723eULL, 0x000fe400020006ffULL, 0x00000008ff6a7819ULL, 0x000fe4000001166aULL,
0x00000008ff677819ULL, 0x000fc40000011667ULL, 0x000054103f387816ULL, 0x000fe40000000038ULL,
0x000054103e397816ULL, 0x000fe40000000039ULL, 0x0000006aff69723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000010ff5d7819ULL, 0x000fe4000001163aULL,
0x000000ff3a5a7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3a567812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x100fe4000001163bULL, 0x00000018ff727819ULL, 0x000fe4000001163bULL,
0x0000ffff3b597812ULL, 0x000fe400078ec0ffULL, 0x000000381038723cULL, 0x000b620000001820ULL,
0x00005410693c7816ULL, 0x000fe4000000003cULL, 0x00005410673d7816ULL, 0x000fc4000000003dULL,
0x000000ff41417812ULL, 0x000fe400078ec0ffULL, 0x000000ff5f217812ULL, 0x020fe400078ec0ffULL,
0x00000043ff43723eULL, 0x000fe200020006ffULL, 0x0000003c103c723cULL, 0x000b62000000181cULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x0000000730308232ULL, 0x082fe20000000000ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x0000000732328232ULL, 0x000fe20000000000ULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x0000000831318232ULL, 0x080fe20000000000ULL,
0x00000008ff1f7819ULL, 0x020fe20000011640ULL, 0x0000000833338232ULL, 0x000fe20000000000ULL,
0x00000008ff1e7819ULL, 0x000fc4000001165cULL, 0x0000541043407816ULL, 0x000fe40000000021ULL,
0x0000541042417816ULL, 0x000fe40000000041ULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x0000001fff1f723eULL, 0x000fe400020006ffULL, 0x0000001eff1e723eULL, 0x000fe200020006ffULL,
0x000000401040723cULL, 0x000b620000001818ULL, 0x000000ff681d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff61617812ULL, 0x000fe400078ec0ffULL, 0x00000008ff607819ULL, 0x000fe40000011660ULL,
0x000054101f187816ULL, 0x020fe40000000052ULL, 0x000054101e197816ULL, 0x000fe40000000054ULL,
0x00000008ff627819ULL, 0x000fe40000011662ULL, 0x00000058ff58723eULL, 0x000fc400020006ffULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x000000181010723cULL, 0x000b620000001814ULL,
0x0000001dff1d723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x00000018ff1a7819ULL, 0x000fe40000011644ULL, 0x00000061ff15723eULL, 0x020fe400020006ffULL,
0x00000060ff18723eULL, 0x000fc400020006ffULL, 0x00000062ff19723eULL, 0x000fe400020006ffULL,
0x0000541058147816ULL, 0x000fe4000000001dULL, 0x0000541057157816ULL, 0x000fe40000000015ULL,
0x0000541018187816ULL, 0x000fe4000000000dULL, 0x0000541019197816ULL, 0x000fe40000000053ULL,
0x000000ff451b7812ULL, 0x000fe200078ec0ffULL, 0x000000143014723cULL, 0x000b620000001834ULL,
0x000000ff5d5d7812ULL, 0x000fc400078ec0ffULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x0000001bff52723eULL, 0x000fe400020006ffULL, 0x0000001aff34723eULL, 0x020fe400020006ffULL,
0x000000183018723cULL, 0x000b62000000182cULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x000000ff44227812ULL, 0x000fc400078ec0ffULL,
0x0000005dff2d723eULL, 0x020fe400020006ffULL, 0x000054105b5b7816ULL, 0x000fe4000000005eULL,
0x000054105a5a7816ULL, 0x000fe4000000002dULL, 0x00000008ff567819ULL, 0x000fe40000011656ULL,
0x00000008ff597819ULL, 0x000fe40000011659ULL, 0x00000018ff1c7819ULL, 0x000fc40000011645ULL,
0x00000022ff5f723eULL, 0x000fe400020006ffULL, 0x00000010ff227819ULL, 0x000fe40000011645ULL,
0x000000ff46237812ULL, 0x000fe400078ec0ffULL, 0x00000072ff20723eULL, 0x000fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fc400020006ffULL,
0x0000001cff0d723eULL, 0x000fe400020006ffULL, 0x0000005a301c723cULL, 0x000b620000001824ULL,
0x00000023ff2c723eULL, 0x000fe400020006ffULL, 0x0000541059237816ULL, 0x000fe40000000020ULL,
0x0000ffff44687812ULL, 0x000fe400078ec0ffULL, 0x000000ff22257812ULL, 0x020fe400078ec0ffULL,
0x0000541056227816ULL, 0x000fc40000000055ULL, 0x00000010ff217819ULL, 0x000fe40000011644ULL,
0x0000ffff45697812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5c7819ULL, 0x100fe40000011646ULL,
0x00000018ff457819ULL, 0x000fe40000011646ULL, 0x00000010ff677819ULL, 0x000fe40000011647ULL,
0x000000ff476a7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff447819ULL, 0x000fe40000011647ULL,
0x00000008ff687819ULL, 0x000fe40000011668ULL, 0x0000ffff46467812ULL, 0x000fe400078ec0ffULL,
0x0000ffff47477812ULL, 0x000fe400078ec0ffULL, 0x000000ff21247812ULL, 0x000fe400078ec0ffULL,
0x000000223020723cULL, 0x000b620000001828ULL, 0x00000008ff697819ULL, 0x000fc40000011669ULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff67677812ULL, 0x000fe400078ec0ffULL,
0x00000025ff29723eULL, 0x020fe400020006ffULL, 0x00000068ff28723eULL, 0x000fe400020006ffULL,
0x00000008ff467819ULL, 0x000fe40000011646ULL, 0x00000008ff477819ULL, 0x000fc40000011647ULL,
0x0000541052257816ULL, 0x000fe40000000029ULL, 0x00000024ff24723eULL, 0x000fe400020006ffULL,
0x0000006aff2d723eULL, 0x000fe400020006ffULL, 0x00000069ff29723eULL, 0x000fe400020006ffULL,
0x0000541028287816ULL, 0x000fe40000000034ULL, 0x0000005cff5c723eULL, 0x000fc400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x00000046ff34723eULL, 0x000fe400020006ffULL,
0x00000047ff35723eULL, 0x000fe400020006ffULL, 0x000054105f247816ULL, 0x000fc40000000024ULL,
0x0000541029297816ULL, 0x000fe2000000000dULL, 0x00000002000d7824ULL, 0x000fe200078e00ffULL,
0x000054102c2c7816ULL, 0x000fe4000000005cULL, 0x000054102d2d7816ULL, 0x000fe20000000067ULL,
0x000000243024723cULL, 0x000f620000001838ULL, 0x0000541034347816ULL, 0x000fe40000000045ULL,
0x0000541035357816ULL, 0x000fe40000000044ULL, 0xfffffff80d0d7812ULL, 0x000fc600078ec0ffULL,
0x000000283028723cULL, 0x040f70000000183cULL, 0x0000002c302c723cULL, 0x040f700000001840ULL,
0x000000343030723cULL, 0x000b6e0000001810ULL, 0x0000f6c863107811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000010107f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f690000dff7f8cULL, 0x0005e4000c80043fULL,
0x0000000000127805ULL, 0x000fc40000015200ULL, 0x00000400050d7984ULL, 0x004ea40000000800ULL,
0x800000000dff7812ULL, 0x006fc40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003412347210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e13ULL,
0x003d09003400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc80000011435ULL, 0x000000340d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff347224ULL, 0x000fca00000e0635ULL, 0x000000020d0d7819ULL, 0x000fc80000001234ULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400050d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000117824ULL, 0x000fe400078e00ffULL,
0x000059000c0c7a24ULL, 0x010fe400078e02ffULL, 0x00000080ff137424ULL, 0x000fe200078e00ffULL,
0xffffffe0110d7812ULL, 0x000fe200078ec0ffULL, 0x000000400c0c7824ULL, 0x000fc800078e00ffULL,
0x00000100480d7824ULL, 0x000fe400078e020dULL, 0x000064000c127625ULL, 0x000fc600078e0013ULL,
0x000000c00d0d7810ULL, 0x000fc80007ffe0ffULL, 0x000000200d107812ULL, 0x000fca00078ec0ffULL,
0x000000016f107824ULL, 0x000fe200078e0210ULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x0000000d020c7217ULL, 0x000fe40007800000ULL, 0x0000001011117812ULL, 0x000fe400078ec0ffULL,
0x00000003ff347819ULL, 0x000fe20000011649ULL, 0x000000010c0c7824ULL, 0x000fc600078e0a0dULL,
0x0000000434367810ULL, 0x040fe20007ffe0ffULL, 0x00000001340d7824ULL, 0x040fe200078e0211ULL,
0x0000000c110c7217ULL, 0x000fe40007800000ULL, 0x0000000c34377810ULL, 0x000fe20007ffe0ffULL,
0x000000010d357824ULL, 0x040fe400078e0249ULL, 0x000000080d387824ULL, 0x040fe400078e00ffULL,
0x000000010c0c7824ULL, 0x000fe400078e0a11ULL, 0x000000010d0d7824ULL, 0x000fe200078e0210ULL,
0xfffffff8383d7812ULL, 0x000fe200078ee235ULL, 0x00000001373a7824ULL, 0x000fe200078e0211ULL,
0x0000000834357810ULL, 0x000fc40007ffe0ffULL, 0x0000000c3600720cULL, 0x0c0fe20003f66070ULL,
0x0000000136367824ULL, 0x100fe200078e0211ULL, 0x0000000c3400720cULL, 0x080fe20003f86070ULL,
0x000000083a437824ULL, 0x000fe200078e00ffULL, 0x0000000c3500720cULL, 0x0c0fe20003f46070ULL,
0x0000000135357824ULL, 0x000fe200078e0211ULL, 0x0000000c3700720cULL, 0x000fe20003f06070ULL,
0x000000800d0c7825ULL, 0x000fc800078e00ffULL, 0x0000000136347824ULL, 0x140fe400078e0249ULL,
0x00000008363f7824ULL, 0x040fe400078e00ffULL, 0x0000000136367824ULL, 0x100fe400078e0210ULL,
0x0000000135117824ULL, 0x000fe200078e0210ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee234ULL,
0x0000000135387824ULL, 0x040fe400078e0249ULL, 0x0000000835417824ULL, 0x000fe200078e00ffULL,
0x000000510c357212ULL, 0x000fe200078efcffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0x00000035120c7210ULL, 0x000fe20007fbe0ffULL, 0x000000013a347824ULL, 0x000fe200078e0210ULL,
0x0000005136397212ULL, 0x000fe200078efcffULL, 0x0000008011107825ULL, 0x000fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fc600078ee238ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x00000051103b7212ULL, 0x000fc600078efcffULL, 0x00000001130d7824ULL, 0x000fe200028e060dULL,
0x0000003912367210ULL, 0x000fe20007fbe0ffULL, 0x000000013a387824ULL, 0x000fe200078e0249ULL,
0x0000005134397212ULL, 0x000fc600078efcffULL, 0x0000000113377824ULL, 0x000fe200028e0637ULL,
0x0000003b12107210ULL, 0x040fe20007fbe0ffULL, 0x00000010413b7824ULL, 0x100fe200078e024aULL,
0x0000003912127210ULL, 0x000fe20007fde0ffULL, 0x000000103d397824ULL, 0x000fe200078e024aULL,
0xfffffff843437812ULL, 0x000fe200078ee238ULL, 0x0000000113117824ULL, 0x040fe400028e0611ULL,
0x0000000113137824ULL, 0x000fe200030e0635ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c397faeULL, 0x0003e2000e101c46ULL, 0x000000103f357824ULL, 0x000fc400078e024aULL,
0x00000010433d7824ULL, 0x000fc600078e024aULL, 0x0000000036357faeULL, 0x0003e8000d901c46ULL,
0x00000000103b7faeULL, 0x0003e8000d101c46ULL, 0x00000000123d7faeULL, 0x0003e2000c101c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x00000010110c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c490d7211ULL, 0x000fc800078fe8ffULL, 0x000000080d347810ULL, 0x040fe20007ffe0ffULL,
0x000000010d0c7824ULL, 0x140fe200078e0249ULL, 0x000000040d367810ULL, 0x040fe20007ffe0ffULL,
0x000000080d3f7824ULL, 0x000fe400078e00ffULL, 0x0000000134357824ULL, 0x140fe400078e0249ULL,
0x00000008343a7824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee20cULL,
0x0000000136117824ULL, 0x040fe400078e0249ULL, 0x0000000836387824ULL, 0x000fe200078e00ffULL,
0xfffffff83a437812ULL, 0x000fe200078ee235ULL, 0x000000010d0c7824ULL, 0x140fe200078e0210ULL,
0x0000000c0d357810ULL, 0x000fe20007ffe0ffULL, 0x0000000136367824ULL, 0x000fe200078e0210ULL,
0xfffffff838417812ULL, 0x000fe200078ee211ULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x0000000134117824ULL, 0x100fe200078e0210ULL, 0x000000510c397212ULL, 0x000fe200078efcffULL,
0x0000000135347824ULL, 0x040fe400078e0210ULL, 0x0000000135387824ULL, 0x040fe200078e0249ULL,
0x00000039120c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000835457824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ee238ULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0x00000051363d7212ULL, 0x000fc600078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x00000051103b7212ULL, 0x000fe400078efcffULL,
0x0000003d12367210ULL, 0x000fe20007f5e0ffULL, 0x00000001130d7824ULL, 0x000fe200000e060dULL,
0x0000005134397212ULL, 0x000fe200078efcffULL, 0x00000010453d7824ULL, 0x100fe200078e024aULL,
0x0000003b12107210ULL, 0x040fe20007f1e0ffULL, 0x0000000113377824ULL, 0x000fe200010e0637ULL,
0x0000003912127210ULL, 0x000fe20007f7e0ffULL, 0x000000103f397824ULL, 0x000fc400078e024aULL,
0x0000000113117824ULL, 0x040fe400000e0611ULL, 0x0000000113137824ULL, 0x000fe200018e0635ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c397faeULL, 0x0003e2000b901c46ULL,
0x0000001041357824ULL, 0x100fe400078e024aULL, 0x00000010433b7824ULL, 0x000fc600078e024aULL,
0x0000000036357faeULL, 0x0003e8000b901c46ULL, 0x00000000103b7faeULL, 0x0003e8000b901c46ULL,
0x00000000123d7faeULL, 0x0003e4000b901c46ULL, 0x00000008000d7824ULL, 0x002fe200078e00ffULL,
0x0000000303107810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff0c7424ULL, 0x000fc600078e00ffULL,
0xfffffff00d0d7812ULL, 0x000fe400078ec0ffULL, 0x000000651000720cULL, 0x000fe40003f06070ULL,
0x000000000d0473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000000170108824ULL, 0x000fc400078e0210ULL, 0x00000004ff118424ULL, 0x000fc800078e00ffULL,
0x0000660010108625ULL, 0x000fca00078e0011ULL, 0x00000006100c8981ULL, 0x000522000c1e1900ULL,
0x0000f6b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x00f6b0000d107f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6480009127f8cULL, 0x000664000c80043fULL, 0x0000000000347805ULL, 0x000fc40000015200ULL,
0x00f64c00090d7984ULL, 0x002e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634367210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011437ULL,
0x000000360d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff367224ULL, 0x000fca00000e0637ULL,
0x000000020d0d7819ULL, 0x000fc80000001236ULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c00090d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002000097824ULL, 0x008fca00078e00ffULL, 0xffffff8009127812ULL, 0x000fc800078ec0ffULL,
0x0000010051127810ULL, 0x000fca0007ffe012ULL, 0x000000017b127824ULL, 0x000fca00078e0212ULL,
0x00f0000012357984ULL, 0x000e680000000800ULL, 0x00f2000012347984ULL, 0x0006a20000000800ULL,
0x0000000a3500720bULL, 0x002fe20003f1d000ULL, 0x0000b4527f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0d367812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fd200078e000aULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000276097810ULL, 0x000fe40007ffe0ffULL, 0x0000000a3500720bULL, 0x000fe40003f54000ULL,
0x000000000900720cULL, 0x000fe20003f05270ULL, 0x0000b3f27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000097806ULL, 0x000fc400010e0100ULL, 0x0000008000128824ULL, 0x000fe200078e0251ULL,
0x0000000a350d8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x000000017b388824ULL, 0x000fe200078e0212ULL, 0x0000991009127816ULL, 0x000fc800000000ffULL,
0x00f4000d38008388ULL, 0x0003e20000000800ULL, 0x000000ff1200720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000a350d7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff09ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000a0d0d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d00387308ULL, 0x000e640000000800ULL, 0x000000380b0b7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011649ULL,
0x0000b3127f007947ULL, 0x000fea000b800000ULL, 0x00001f0d380d7589ULL, 0x0002e400000e0000ULL,
0x0000000d14147220ULL, 0x08cfe20000410000ULL, 0x0000000d15157220ULL, 0x080fe20000410000ULL,
0x0000000d18187220ULL, 0x080fe20000410000ULL, 0x0000000d19197220ULL, 0x080fe20000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000d1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000d20207220ULL, 0x080fe20000410000ULL, 0x0000000d21217220ULL, 0x080fe20000410000ULL,
0x0000000d24247220ULL, 0x080fe20000410000ULL, 0x0000000d25257220ULL, 0x080fe20000410000ULL,
0x0000000d28287220ULL, 0x080fe20000410000ULL, 0x0000000d29297220ULL, 0x080fe20000410000ULL,
0x0000000d2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000d30307220ULL, 0x080fe20000410000ULL, 0x0000000d31317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0009ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008490d7811ULL, 0x000fe200078ff0ffULL,
0x0000b1f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d380d7589ULL, 0x00066400000e0000ULL,
0x0000000d16167220ULL, 0x086fe20000410000ULL, 0x0000000d17177220ULL, 0x080fe20000410000ULL,
0x0000000d1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000d1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000d1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000d22227220ULL, 0x080fe20000410000ULL, 0x0000000d23237220ULL, 0x080fe20000410000ULL,
0x0000000d26267220ULL, 0x080fe20000410000ULL, 0x0000000d27277220ULL, 0x080fe20000410000ULL,
0x0000000d2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000d2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000d32327220ULL, 0x080fe20000410000ULL, 0x0000000d33337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff36ff7812ULL, 0x000fe20007806009ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000a35097209ULL, 0x000fd60007810000ULL,
0x8000000935350221ULL, 0x000fe20000010000ULL, 0x00007610ff0d0816ULL, 0x000fc6000000000dULL,
0x3fb8aa3b35350820ULL, 0x000fc80000410000ULL, 0x0000003500060308ULL, 0x000e640000000800ULL,
0x0000000634340220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000b340b7221ULL, 0x004fc20000010000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x00000008000a7824ULL, 0x000fca00078e00ffULL, 0xfffffff00a367812ULL, 0x000fca00078ec0ffULL,
0x00f6ac0036357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x008fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003412377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e13ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc80000011435ULL,
0x000000370a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x000000020a0a7819ULL, 0x000fc80000001235ULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0036357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100d0a7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000006ff07723eULL, 0x000fe400000000ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011649ULL,
0x00005410070a7816ULL, 0x000fe20000000007ULL, 0x0000ada27f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0a077589ULL, 0x0002a400000e0000ULL, 0x000000080f0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000add27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0a087589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100f0d7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e000aULL, 0x00007eb000137802ULL, 0x000fc40000000f00ULL,
0x0000b43000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180f0d7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e000aULL,
0x00007f0000137802ULL, 0x000fc40000000f00ULL, 0x0000b3e000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000104d387824ULL, 0x100fe200078e0271ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000104c3c7824ULL, 0x100fe200078e0271ULL,
0x00a000004e34783bULL, 0x000ee20000000200ULL, 0x000000104b0f7824ULL, 0x002fc600078e0271ULL,
0x000000003838783bULL, 0x000e680000004200ULL, 0x000000003c3c783bULL, 0x000ea40000004200ULL,
0x0000000734348232ULL, 0x08cfe40000000000ULL, 0x0000000736368232ULL, 0x000fe20000000000ULL,
0x00000010ff447819ULL, 0x102fe20000011638ULL, 0x0000000835358232ULL, 0x080fe20000000000ULL,
0x000000ff380a7812ULL, 0x000fe200078ec0ffULL, 0x0000000837378232ULL, 0x000fe20000000000ULL,
0x00000018ff137819ULL, 0x000fc40000011638ULL, 0x0000ffff38407812ULL, 0x000fe400078ec0ffULL,
0x00000010ff437819ULL, 0x100fe40000011639ULL, 0x000000ff394b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff477819ULL, 0x000fe40000011639ULL, 0x0000ffff39427812ULL, 0x000fe400078ec0ffULL,
0x00000010ff0d7819ULL, 0x000fc4000001163aULL, 0x000000ff3a627812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001163aULL, 0x0000ffff3a527812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4c7819ULL, 0x100fe4000001163bULL, 0x000000ff3b617812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fc4000001163bULL, 0x0000ffff3b607812ULL, 0x000fe400078ec0ffULL,
0x000000000f38783bULL, 0x0002a20000004200ULL, 0x000000ff44447812ULL, 0x000fe400078ec0ffULL,
0x000000ff43437812ULL, 0x000fe400078ec0ffULL, 0x00000010ff577819ULL, 0x100fe4000001163cULL,
0x000000ff3c5b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4e7819ULL, 0x000fc4000001163cULL,
0x0000ffff3c587812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5c7819ULL, 0x100fe4000001163dULL,
0x000000ff3d5a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff567819ULL, 0x000fe4000001163dULL,
0x0000ffff3d597812ULL, 0x000fe400078ec0ffULL, 0x0000000aff3c723eULL, 0x000fc400020006ffULL,
0x0000004bff3d723eULL, 0x000fe400020006ffULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x000054103c3c7816ULL, 0x000fe40000000044ULL,
0x000054103d3d7816ULL, 0x000fe40000000043ULL, 0x00000008ff427819ULL, 0x000fc40000011642ULL,
0x00000010ff0e7819ULL, 0x100fe4000001163eULL, 0x000000ff3e457812ULL, 0x040fe200078ec0ffULL,
0x0000003c3414723cULL, 0x000be20000001814ULL, 0x00000018ff4d7819ULL, 0x000fe4000001163eULL,
0x0000ffff3e0f7812ULL, 0x002fe200078ec0ffULL, 0x000000104f3e7824ULL, 0x000fe200078e0271ULL,
0x00000047ff0a723eULL, 0x000fe400020006ffULL, 0x00000042ff3d723eULL, 0x020fc400020006ffULL,
0x00000010ff477819ULL, 0x104fe40000011638ULL, 0x000000ff38697812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4f7819ULL, 0x000fe40000011638ULL, 0x0000ffff38427812ULL, 0x000fe400078ec0ffULL,
0x00000010ff437819ULL, 0x000fe40000011639ULL, 0x000000ff39687812ULL, 0x000fc400078ec0ffULL,
0x00000018ff5f7819ULL, 0x000fe40000011639ULL, 0x0000ffff39447812ULL, 0x000fe400078ec0ffULL,
0x000000ff0d387812ULL, 0x000fe400078ec0ffULL, 0x000000ff4c397812ULL, 0x000fe400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fc400020006ffULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x00000039ff39723eULL, 0x000fe400020006ffULL,
0x0000541062387816ULL, 0x000fe40000000038ULL, 0x0000541061397816ULL, 0x000fe40000000039ULL,
0x00000008ff407819ULL, 0x000fe40000011640ULL, 0x00000008ff527819ULL, 0x000fc40000011652ULL,
0x00000008ff607819ULL, 0x000fe20000011660ULL, 0x00000038341c723cULL, 0x000be2000000181cULL,
0x00000013ff13723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000040ff3c723eULL, 0x000fe400020006ffULL,
0x00000052ff38723eULL, 0x020fc400020006ffULL, 0x00000060ff39723eULL, 0x000fe400020006ffULL,
0x000054103c3c7816ULL, 0x000fe40000000013ULL, 0x000054103d3d7816ULL, 0x000fe4000000000aULL,
0x0000541038387816ULL, 0x000fe4000000005eULL, 0x0000541039397816ULL, 0x000fe4000000005dULL,
0x000000ff57577812ULL, 0x000fe200078ec0ffULL, 0x0000003c3418723cULL, 0x000be20000001818ULL,
0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff127819ULL, 0x100fe4000001163fULL,
0x000000ff3f467812ULL, 0x040fe400078ec0ffULL, 0x00000018ff677819ULL, 0x000fe2000001163fULL,
0x000000383420723cULL, 0x000be20000001820ULL, 0x0000ffff3f417812ULL, 0x000fe400078ec0ffULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x000000003e3c783bULL, 0x020fe20000004200ULL,
0x0000005aff5a723eULL, 0x000fc400020006ffULL, 0x00000057ff38723eULL, 0x000fe400020006ffULL,
0x0000005cff39723eULL, 0x000fe400020006ffULL, 0x000054105b387816ULL, 0x000fe40000000038ULL,
0x000054105a397816ULL, 0x000fe40000000039ULL, 0x00000010ff137819ULL, 0x000fe4000001163aULL,
0x000000ff3a537812ULL, 0x000fc400078ec0ffULL, 0x00000018ff547819ULL, 0x000fe4000001163aULL,
0x0000ffff3a0a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff407819ULL, 0x100fe4000001163bULL,
0x000000ff3b557812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4b7819ULL, 0x000fe4000001163bULL,
0x0000ffff3b0d7812ULL, 0x000fc400078ec0ffULL, 0x000000383438723cULL, 0x000b620000001824ULL,
0x00000008ff597819ULL, 0x000fe20000011659ULL, 0x00a000005024783bULL, 0x020e620000000200ULL,
0x00000053ff60723eULL, 0x000fe400020006ffULL, 0x00000008ff587819ULL, 0x000fe40000011658ULL,
0x000000ff0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff12537812ULL, 0x000fe400078ec0ffULL,
0x00000008ff127819ULL, 0x000fc4000001160fULL, 0x00000008ff417819ULL, 0x000fe40000011641ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x00000046ff46723eULL, 0x000fc400020006ffULL, 0x0000004dff4c723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x0000000eff0e723eULL, 0x000fe400020006ffULL,
0x00000053ff0f723eULL, 0x000fe400020006ffULL, 0x00000067ff4d723eULL, 0x000fe400020006ffULL,
0x00000012ff12723eULL, 0x000fc400020006ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x0000004fff5a723eULL, 0x000fe400020006ffULL, 0x00005410594f7816ULL, 0x000fe20000000056ULL,
0x0000000724248232ULL, 0x082fe20000000000ULL, 0x00005410584e7816ULL, 0x000fe2000000004eULL,
0x0000000726268232ULL, 0x000fe20000000000ULL, 0x00000010ff597819ULL, 0x000fe2000001163cULL,
0x0000000825258232ULL, 0x080fe20000000000ULL, 0x00000010ff5c7819ULL, 0x000fe2000001163dULL,
0x0000000827278232ULL, 0x000fe20000000000ULL, 0x00005410450e7816ULL, 0x000fe2000000000eULL,
0x0000004e3428723cULL, 0x000f620000001828ULL, 0x00005410460f7816ULL, 0x000fc4000000000fULL,
0x00005410124c7816ULL, 0x000fe4000000004cULL, 0x00005410414d7816ULL, 0x000fe4000000004dULL,
0x000000ff3c627812ULL, 0x000fe200078ec0ffULL, 0x0000000e342c723cULL, 0x000b62000000182cULL,
0x000000ff3d617812ULL, 0x000fe400078ec0ffULL, 0x000000ff59597812ULL, 0x000fe400078ec0ffULL,
0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL, 0x00000062ff0e723eULL, 0x020fe200020006ffULL,
0x0000004c3430723cULL, 0x000f620000001830ULL, 0x00000061ff0f723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000005fff5b723eULL, 0x000fe400020006ffULL, 0x00000018ff5f7819ULL, 0x000fc4000001163cULL,
0x0000ffff3c507812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001163dULL,
0x0000ffff3d567812ULL, 0x000fe400078ec0ffULL, 0x000000ff40407812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001163eULL, 0x000000ff3e5d7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001163eULL, 0x00000010ff4f7819ULL, 0x100fe4000001163fULL,
0x000000ff3f587812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001163fULL,
0x000054100e0e7816ULL, 0x000fe40000000059ULL, 0x000054100f0f7816ULL, 0x000fc4000000005cULL,
0x0000ffff3e3e7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x0000000e2438723cULL, 0x000b620000001838ULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x000000ff47477812ULL, 0x000fe400078ec0ffULL,
0x000000ff43437812ULL, 0x000fc400078ec0ffULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000008ff447819ULL, 0x000fe40000011644ULL, 0x000000ff13137812ULL, 0x000fe400078ec0ffULL,
0x00000008ff0a7819ULL, 0x000fe4000001160aULL, 0x00000008ff0d7819ULL, 0x000fe4000001160dULL,
0x00000008ff507819ULL, 0x000fc40000011650ULL, 0x00000008ff567819ULL, 0x000fe40000011656ULL,
0x000000ff4e4e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4f4f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3e7819ULL, 0x000fe4000001163eULL, 0x00000008ff3f7819ULL, 0x000fe4000001163fULL,
0x0000541055617816ULL, 0x000fc40000000040ULL, 0x00000069ff52723eULL, 0x000fe400020006ffULL,
0x00000068ff57723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fc400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000013ff13723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x0000000aff0a723eULL, 0x000fc400020006ffULL, 0x0000000dff55723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000050ff0e723eULL, 0x020fe400020006ffULL, 0x00000056ff0f723eULL, 0x000fe400020006ffULL,
0x0000004eff4e723eULL, 0x000fc400020006ffULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x0000541052527816ULL, 0x000fc40000000047ULL, 0x0000541057537816ULL, 0x000fe40000000043ULL,
0x00005410425a7816ULL, 0x000fe4000000005aULL, 0x00005410445b7816ULL, 0x000fe4000000005bULL,
0x0000541060607816ULL, 0x000fe20000000013ULL, 0x000000522414723cULL, 0x000b620000001814ULL,
0x000054100a547816ULL, 0x000fe20000000054ULL, 0x00000002000a7824ULL, 0x000fe200078e00ffULL,
0x0000541055557816ULL, 0x000fc4000000004bULL, 0x000054100e0e7816ULL, 0x000fe4000000005fULL,
0x000054100f0f7816ULL, 0x000fe2000000005eULL, 0x0000005a2418723cULL, 0x040b620000001818ULL,
0x000054105d4e7816ULL, 0x000fe4000000004eULL, 0x00005410584f7816ULL, 0x000fe4000000004fULL,
0x000054103e3e7816ULL, 0x000fe4000000003dULL, 0x000054103f3f7816ULL, 0x000fe2000000003cULL,
0x00000060241c723cULL, 0x000b62000000181cULL, 0x0000f6c863127811ULL, 0x000fc400078e18ffULL,
0xfffffff80a0a7812ULL, 0x000fca00078ec0ffULL, 0x000000542420723cULL, 0x040b700000001820ULL,
0x0000000e2428723cULL, 0x040b700000001828ULL, 0x0000004e242c723cULL, 0x040b70000000182cULL,
0x0000003e2424723cULL, 0x000b620000001830ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000012127f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f698000aff7f8cULL, 0x0005e4000c80043fULL,
0x00000000000e7805ULL, 0x020fc40000015200ULL, 0x00000400050d7984ULL, 0x000ee40000000800ULL,
0x800000000dff7812ULL, 0x00afc40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff327224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fcc0000015200ULL,
0x000000300e0d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000131307824ULL, 0x000fe200000e0e0fULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3000720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3000720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x004fc80000011430ULL, 0x0000000d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e0630ULL, 0x000000020a0a7819ULL, 0x000fc8000000120dULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000132327810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400050d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001480d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000303037810ULL, 0x000fe40007ffe0ffULL, 0x000000660d00720cULL, 0x000fda0003f06070ULL,
0x0000084000000947ULL, 0x000fea0003800000ULL, 0x0000000248037810ULL, 0x000fe20007ffe0ffULL,
0x00000020630a7824ULL, 0x004fe400078e00ffULL, 0x000059000c0c7a24ULL, 0x010fe200078e02ffULL,
0x000000660300720cULL, 0x000fe20003f06070ULL, 0x000001000d0e7824ULL, 0x000fe400078e020aULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x000000400c0c7824ULL, 0x000fe200078e00ffULL,
0x000000200e0a7812ULL, 0x000fc600078ec0ffULL, 0x000064000c0c7625ULL, 0x000fc800078e000dULL,
0x000000016f0a7824ULL, 0x000fe200078e020aULL, 0x000003e000008947ULL, 0x000fea0003800000ULL,
0x0000000e02037217ULL, 0x000fe20007800000ULL, 0x00000010000f7824ULL, 0x000fc800078e00ffULL,
0x0000000103037824ULL, 0x000fe200078e0a0eULL, 0x000000100f0e7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011649ULL, 0x000000030e037217ULL, 0x000fe40007800000ULL,
0x000000040f127810ULL, 0x040fe40007ffe0ffULL, 0x000000080f137810ULL, 0x000fe20007ffe0ffULL,
0x0000000103037824ULL, 0x000fe200078e0a0eULL, 0x0000000c0f307810ULL, 0x000fc80007ffe0ffULL,
0x000000030f00720cULL, 0x0c0fe20003f86070ULL, 0x000000010f0f7824ULL, 0x100fe200078e020eULL,
0x000000031200720cULL, 0x0c0fe20003f66070ULL, 0x0000000112127824ULL, 0x100fe200078e020eULL,
0x000000031300720cULL, 0x0c0fe20003f46070ULL, 0x0000000113137824ULL, 0x100fe200078e020eULL,
0x000000033000720cULL, 0x040fe20003f06070ULL, 0x0000000130357824ULL, 0x000fe400078e020eULL,
0x000000010f0e7824ULL, 0x040fe400078e020aULL, 0x000000010f037824ULL, 0x000fc400078e0249ULL,
0x000000080f347824ULL, 0x000fe400078e00ffULL, 0x00000001120f7824ULL, 0x040fe400078e0249ULL,
0x0000000812367824ULL, 0x000fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ee203ULL,
0x0000000113317824ULL, 0x040fe400078e0249ULL, 0x00000008133c7824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee20fULL, 0x0000000112307824ULL, 0x000fc400078e020aULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fc600078ee231ULL,
0x0000008030307825ULL, 0x000fe200078e00ffULL, 0x000000510e337212ULL, 0x000fc600078efcffULL,
0x0000000113127824ULL, 0x100fe200078e020aULL, 0x0000005130037212ULL, 0x000fe200078efcffULL,
0x0000000135327824ULL, 0x040fe200078e020aULL, 0x000000330c0e7210ULL, 0x040fe20007fbe0ffULL,
0x00000001350a7824ULL, 0x040fe200078e0249ULL, 0x000000030c307210ULL, 0x000fe20007fde0ffULL,
0x0000000835357824ULL, 0x000fe400078e00ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff8350a7812ULL, 0x000fe200078ee20aULL, 0x0000008032327825ULL, 0x000fe200078e00ffULL,
0x0000005112357212ULL, 0x000fc600078efcffULL, 0x000000010d0f7824ULL, 0x040fe200028e060fULL,
0x0000005132037212ULL, 0x000fe200078efcffULL, 0x000000010d317824ULL, 0x040fe200030e0631ULL,
0x000000350c127210ULL, 0x000fe20007fbe0ffULL, 0x0000001034377824ULL, 0x100fe200078e0271ULL,
0x000000030c0c7210ULL, 0x000fe20007fde0ffULL, 0x00000010363d7824ULL, 0x100fe400078e0271ULL,
0x000000103c037824ULL, 0x000fe200078e0271ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e377faeULL, 0x0003e2000e101c46ULL, 0x000000010d137824ULL, 0x000fc400028e0613ULL,
0x000000100a717824ULL, 0x000fe200078e0271ULL, 0x00000000303d7faeULL, 0x0003e2000d901c46ULL,
0x000000010d0d7824ULL, 0x000fc600030e0633ULL, 0x0000000012037faeULL, 0x0003e8000d101c46ULL,
0x000000000c717faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001000037824ULL, 0x000fca00078e00ffULL, 0x00000010030e7812ULL, 0x000fc800078ec0ffULL,
0x0000000e49037211ULL, 0x000fc800078fe8ffULL, 0x0000000403137810ULL, 0x040fe20007ffe0ffULL,
0x00000001030f7824ULL, 0x040fe200078e0249ULL, 0x0000000803337810ULL, 0x040fe20007ffe0ffULL,
0x0000000803347824ULL, 0x040fe200078e00ffULL, 0x0000000c03357810ULL, 0x040fe20007ffe0ffULL,
0x00000001030e7824ULL, 0x100fe400078e020aULL, 0x0000000113127824ULL, 0x040fe200078e020aULL,
0xfffffff834347812ULL, 0x000fe200078ee20fULL, 0x0000000113317824ULL, 0x040fe400078e0249ULL,
0x0000000813367824ULL, 0x000fc400078e00ffULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000000133137824ULL, 0x140fe200078e0249ULL, 0x000000510e037212ULL, 0x000fe200078efcffULL,
0x00000008333c7824ULL, 0x040fe400078e00ffULL, 0x0000000133307824ULL, 0x100fe200078e020aULL,
0x000000030c0e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000135337824ULL, 0x040fe400078e0249ULL,
0x00000008353e7824ULL, 0x040fe400078e00ffULL, 0x0000000135327824ULL, 0x000fe200078e020aULL,
0xfffffff8360a7812ULL, 0x000fe200078ee231ULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0xfffffff83c367812ULL, 0x000fc400078ee213ULL, 0xfffffff83e3c7812ULL, 0x000fe200078ee233ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000005130357212ULL, 0x000fc600078efcffULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0x0000005112377212ULL, 0x000fe400078efcffULL,
0x000000350c307210ULL, 0x000fe20007f5e0ffULL, 0x000000010d0f7824ULL, 0x040fe200000e060fULL,
0x0000005132037212ULL, 0x000fe200078efcffULL, 0x00000010343d7824ULL, 0x100fe200078e0271ULL,
0x000000370c127210ULL, 0x000fe20007f1e0ffULL, 0x000000100a3f7824ULL, 0x100fe200078e0271ULL,
0x000000030c0c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001036417824ULL, 0x000fe200078e0271ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3d7faeULL, 0x0003e2000b901c46ULL,
0x000000010d137824ULL, 0x000fc400000e0613ULL, 0x000000010d317824ULL, 0x040fe400010e0631ULL,
0x000000103c717824ULL, 0x000fe200078e0271ULL, 0x00000000123f7faeULL, 0x0003e2000b901c46ULL,
0x000000010d0d7824ULL, 0x000fc600018e0633ULL, 0x0000000030417faeULL, 0x0003e8000b901c46ULL,
0x000000000c717faeULL, 0x0003e4000b901c46ULL, 0x0000000475037810ULL, 0x002fe20007ffe0ffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0xffffffffff0c7424ULL, 0x000fe400078e00ffULL,
0x000000650300720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00000001700c7824ULL, 0x000fe400078e0203ULL, 0x00000004ff0d7424ULL, 0x000fc800078e00ffULL,
0x000066000c0c7625ULL, 0x000fcc00078e000dULL, 0x000000060c0c7981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008000a7824ULL, 0x004fca00078e00ffULL,
0xfffffff00a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000000a0473c2ULL, 0x000ea200000e0000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000f6a804047890ULL, 0x004fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8000a0e7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6680004127f8cULL, 0x000662000c80043fULL,
0x000000ffff0e7224ULL, 0x004fc600078e000fULL, 0x0000000000307805ULL, 0x000fc80000015200ULL,
0x00f66c00040d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x006fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x00000032300d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000133327824ULL, 0x000fe200000e0e31ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3200720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3200720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc80000011432ULL,
0x0000000d0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e0632ULL,
0x000000020a0a7819ULL, 0x000fc8000000120dULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c00040d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000180760a7811ULL, 0x000fc800078e38ffULL, 0x0000000a7b0a7210ULL, 0x000fca0007ffe051ULL,
0x00f000000a307984ULL, 0x000e680000000800ULL, 0x00f200000a0f7984ULL, 0x0004e20000000800ULL,
0x000000093000720bULL, 0x002fe20003f1d000ULL, 0x00008fb27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0d317812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0a7224ULL, 0x000fd200078e0009ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000003760d7810ULL, 0x000fe40007ffe0ffULL, 0x000000093000720bULL, 0x000fe40003f54000ULL,
0x000000000d00720cULL, 0x000fe20003f05270ULL, 0x00008f527f007947ULL, 0x000fd4000b800000ULL,
0x00000000000a7806ULL, 0x000fc400010e0100ULL, 0x0000008000128824ULL, 0x000fe200078e0251ULL,
0x00000009300d8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x000000017b328824ULL, 0x000fe200078e0212ULL, 0x000099100a127816ULL, 0x000fc800000000ffULL,
0x00f4000d32008388ULL, 0x0003e20000000800ULL, 0x000000ff1200720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000930127209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0aff7812ULL, 0x000fc6000780c0ffULL,
0x00000009120d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d00327308ULL, 0x000e640000000800ULL, 0x000000320b0b7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011649ULL,
0x00008e727f007947ULL, 0x000fea000b800000ULL, 0x00001f0d320d7589ULL, 0x0002a400000e0000ULL,
0x0000000d14147220ULL, 0x084fe20000410000ULL, 0x0000000d15157220ULL, 0x080fe20000410000ULL,
0x0000000d18187220ULL, 0x080fe20000410000ULL, 0x0000000d19197220ULL, 0x080fe20000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000d1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000d20207220ULL, 0x080fe20000410000ULL, 0x0000000d21217220ULL, 0x080fe20000410000ULL,
0x0000000d38387220ULL, 0x080fe20000410000ULL, 0x0000000d39397220ULL, 0x080fe20000410000ULL,
0x0000000d28287220ULL, 0x080fe20000410000ULL, 0x0000000d29297220ULL, 0x080fe20000410000ULL,
0x0000000d2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000d24247220ULL, 0x080fe20000410000ULL, 0x0000000d25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000aff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008490d7811ULL, 0x000fe200078ff0ffULL,
0x00008d527f007947ULL, 0x000fea000b800000ULL, 0x00001f0d320d7589ULL, 0x00046400000e0000ULL,
0x0000000d16167220ULL, 0x086fe20000410000ULL, 0x0000000d17177220ULL, 0x080fe20000410000ULL,
0x0000000d1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000d1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000d1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000d22227220ULL, 0x080fe20000410000ULL, 0x0000000d23237220ULL, 0x080fe20000410000ULL,
0x0000000d3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000d3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000d2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000d2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000d26267220ULL, 0x080fe20000410000ULL, 0x0000000d27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff31ff7812ULL, 0x000fe2000780600aULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000009300a7209ULL, 0x000fd60007810000ULL,
0x8000000a30300221ULL, 0x000fe20000010000ULL, 0x00007610ff0d0816ULL, 0x000fc6000000000dULL,
0x3fb8aa3b30300820ULL, 0x000fc80000410000ULL, 0x0000003000060308ULL, 0x000e640000000800ULL,
0x000000060f0f0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000b0f0b7221ULL, 0x008fc20000010000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000000800097824ULL, 0x000fca00078e00ffULL, 0xfffffff0090f7812ULL, 0x000fca00078ec0ffULL,
0x00f6b4000f097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000307805ULL, 0x000fcc0000015200ULL, 0x0000003012307210ULL, 0x000fca0007f1e1ffULL,
0x0000000131317824ULL, 0x000fe200000e0e13ULL, 0x003d09003000780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403000780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc80000011431ULL,
0x0000003009097211ULL, 0x000fca00078110ffULL, 0x000000ffff307224ULL, 0x000fca00000e0631ULL,
0x0000000209097819ULL, 0x000fc80000001230ULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000132327810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b4000f097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100d097816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0900720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000006ff07723eULL, 0x000fe400000000ffULL, 0x00000002ff107819ULL, 0x000fe40000011649ULL,
0x0000541007097816ULL, 0x000fe20000000007ULL, 0x000089027f007947ULL, 0x000fea000b800000ULL,
0x00001f1009077589ULL, 0x0002a400000e0000ULL, 0x00000008100d7810ULL, 0x000fe20007ffe0ffULL,
0x000089327f007947ULL, 0x000fea000b800000ULL, 0x00001f0d09087589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010100d7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e0009ULL, 0x0000a51000137802ULL, 0x000fc40000000f00ULL,
0x00008dd000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018100d7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e0009ULL,
0x0000a56000137802ULL, 0x000fc40000000f00ULL, 0x00008d8000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000080076307824ULL, 0x040fe200078e0274ULL, 0x0000000376587810ULL, 0x000fc40007ffe0ffULL,
0x000000006e10783bULL, 0x002e620000004200ULL, 0x0000000400097824ULL, 0x008fe200078e00ffULL,
0x0000000849427812ULL, 0x000fc400078ec0ffULL, 0x000000006434783bULL, 0x000fe20000004200ULL,
0x0000000749407812ULL, 0x000fe400078ec0ffULL, 0x0000000409097812ULL, 0x000fe200078ec0ffULL,
0x00a800003030783bULL, 0x000ee20000000200ULL, 0x00000007420d7812ULL, 0x104fe400078ef849ULL,
0x0000000840407812ULL, 0x000fe400078ef849ULL, 0x000000100d0f7812ULL, 0x000fe400078efcffULL,
0x0000000273737810ULL, 0x000fe20007ffe0ffULL, 0x0000000840447824ULL, 0x000fc400078e00ffULL,
0x000000080d407824ULL, 0x000fe400078e00ffULL, 0x000000080f557824ULL, 0x000fe200078e00ffULL,
0xfffffff844737812ULL, 0x000fe400078ee273ULL, 0x00000010ff3f7819ULL, 0x102fe40000011610ULL,
0x000000ff10527812ULL, 0x040fe400078ec0ffULL, 0x00000018ff437819ULL, 0x000fe40000011610ULL,
0x0000ffff103c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff507819ULL, 0x100fe20000011612ULL,
0x0000000730308232ULL, 0x088fe20000000000ULL, 0x000000ff12567812ULL, 0x040fe200078ec0ffULL,
0x0000000732328232ULL, 0x000fe20000000000ULL, 0x00000018ff107819ULL, 0x000fe20000011612ULL,
0x0000000831318232ULL, 0x080fe20000000000ULL, 0x0000ffff12417812ULL, 0x000fe200078ec0ffULL,
0x0000000833338232ULL, 0x000fe20000000000ULL, 0x0000000209127812ULL, 0x000fe400078efcffULL,
0x00000010ff3e7819ULL, 0x000fc40000011611ULL, 0x0000001249127211ULL, 0x000fe400078fe0ffULL,
0x000000ff11537812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4e7819ULL, 0x000fe20000011611ULL,
0x000000010d097824ULL, 0x100fe200078e0212ULL, 0x0000ffff113d7812ULL, 0x000fe200078ec0ffULL,
0x000000010f127824ULL, 0x000fe200078e0212ULL, 0x00000010ff517819ULL, 0x000fe40000011613ULL,
0x000000ff13597812ULL, 0x000fc400078ec0ffULL, 0x00000018ff117819ULL, 0x000fe40000011613ULL,
0x0000ffff13427812ULL, 0x000fe400078ec0ffULL, 0xfffffff840137812ULL, 0x000fe400078ee209ULL,
0xfffffff855557812ULL, 0x000fe200078ee212ULL, 0x0000008058127824ULL, 0x000fe200078e0273ULL,
0x00000010ff407819ULL, 0x000fe40000011634ULL, 0x000000ff345b7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff4f7819ULL, 0x000fe40000011634ULL, 0x0000ffff34477812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4b7819ULL, 0x100fe40000011635ULL, 0x000000ff35547812ULL, 0x040fe400078ec0ffULL,
0x00000018ff347819ULL, 0x000fe40000011635ULL, 0x0000ffff354c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3e3e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff447819ULL, 0x100fe40000011636ULL, 0x000000ff36357812ULL, 0x040fe400078ec0ffULL,
0x00000018ff457819ULL, 0x000fe40000011636ULL, 0x0000ffff36097812ULL, 0x000fe200078ec0ffULL,
0x0000001013367824ULL, 0x100fe200078e024aULL, 0x00000053ff58723eULL, 0x000fe200020006ffULL,
0x00000010554a7824ULL, 0x000fe200078e024aULL, 0x00000052ff55723eULL, 0x000fc400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x00000056ff53723eULL, 0x000fe400020006ffULL, 0x00000059ff52723eULL, 0x000fe400020006ffULL,
0x00000008ff567819ULL, 0x000fe4000001163cULL, 0x00000008ff597819ULL, 0x000fc4000001163dULL,
0x00005410553c7816ULL, 0x000fe4000000003fULL, 0x00005410583d7816ULL, 0x000fe4000000003eULL,
0x00000043ff57723eULL, 0x000fe400020006ffULL, 0x0000004eff5a723eULL, 0x000fe400020006ffULL,
0x000000ff50507812ULL, 0x000fe200078ec0ffULL, 0x0000003c303c723cULL, 0x000be20000001814ULL,
0x000000ff51517812ULL, 0x000fc400078ec0ffULL, 0x0000900012127811ULL, 0x000fe400078e20ffULL,
0x00000008ff417819ULL, 0x000fe40000011641ULL, 0x00000056ff14723eULL, 0x020fe400020006ffULL,
0x00000059ff15723eULL, 0x000fe400020006ffULL, 0x0000541014147816ULL, 0x000fe40000000057ULL,
0x0000541015157816ULL, 0x000fc4000000005aULL, 0x00000010ff467819ULL, 0x100fe40000011637ULL,
0x000000ff374d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff0d7819ULL, 0x000fe20000011637ULL,
0x000000143018723cULL, 0x000b620000001818ULL, 0x0000ffff370f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff37723eULL, 0x000fe400020006ffULL, 0x00000011ff43723eULL, 0x000fc400020006ffULL,
0x00000050ff14723eULL, 0x020fe200020006ffULL, 0x000000001210783bULL, 0x000e620000000200ULL,
0x00000051ff15723eULL, 0x000fe400020006ffULL, 0x0000541053147816ULL, 0x000fe40000000014ULL,
0x0000541052157816ULL, 0x000fe40000000015ULL, 0x000000ff40407812ULL, 0x000fe400078ec0ffULL,
0x00000041ff41723eULL, 0x000fc400020006ffULL, 0x00000035ff50723eULL, 0x000fe200020006ffULL,
0x000000143014723cULL, 0x000b62000000181cULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000008ff477819ULL, 0x000fe40000011647ULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000040ff1c723eULL, 0x020fe400020006ffULL, 0x00000034ff1e723eULL, 0x000fc400020006ffULL,
0x0000541041407816ULL, 0x000fe40000000037ULL, 0x000000003634783bULL, 0x000ea20000004200ULL,
0x0000541042417816ULL, 0x000fe40000000043ULL, 0x00000008ff4c7819ULL, 0x000fe4000001164cULL,
0x000000ff44447812ULL, 0x000fe400078ec0ffULL, 0x000000ff46467812ULL, 0x000fe200078ec0ffULL,
0x000000403040723cULL, 0x000b620000001820ULL, 0x0000005bff4e723eULL, 0x000fc400020006ffULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x0000004cff1d723eULL, 0x000fe200020006ffULL, 0x0000000710108232ULL, 0x082fe20000000000ULL,
0x0000004dff51723eULL, 0x000fe200020006ffULL, 0x0000000712128232ULL, 0x000fe20000000000ULL,
0x00000044ff44723eULL, 0x000fe200020006ffULL, 0x0000000811118232ULL, 0x080fe20000000000ULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x0000000813138232ULL, 0x000fe20000000000ULL,
0x000000ff4b4b7812ULL, 0x000fc400078ec0ffULL, 0x000054104e207816ULL, 0x020fe4000000001cULL,
0x00005410471c7816ULL, 0x000fe4000000004fULL, 0x000054101d1d7816ULL, 0x000fe4000000001eULL,
0x00000008ff097819ULL, 0x000fe40000011609ULL, 0x0000541050507816ULL, 0x000fe40000000044ULL,
0x0000541051517816ULL, 0x000fe20000000046ULL, 0x0000001c101c723cULL, 0x000fe20000001818ULL,
0x00000054ff54723eULL, 0x000fc400020006ffULL, 0x0000004bff21723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000009ff09723eULL, 0x000fe200020006ffULL,
0x000000501018723cULL, 0x000fe20000001814ULL, 0x000000ff344c7812ULL, 0x004fe400078ec0ffULL,
0x00000010ff4d7819ULL, 0x000fe40000011635ULL, 0x000000ff354f7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff4e7819ULL, 0x000fe40000011635ULL, 0x0000ffff355b7812ULL, 0x000fe400078ec0ffULL,
0x0000541054217816ULL, 0x000fe40000000021ULL, 0x00000018ff357819ULL, 0x000fe40000011636ULL,
0x00000010ff467819ULL, 0x100fe40000011634ULL, 0x00000018ff4b7819ULL, 0x000fe20000011634ULL,
0x000000201020723cULL, 0x000be2000000183cULL, 0x0000ffff345a7812ULL, 0x000fe200078ec0ffULL,
0x000000004a3c783bULL, 0x020e620000004200ULL, 0x0000541009147816ULL, 0x000fc40000000045ULL,
0x0000004cff34723eULL, 0x000fe400020006ffULL, 0x00000010ff517819ULL, 0x000fe40000011636ULL,
0x000000ff36537812ULL, 0x040fe400078ec0ffULL, 0x0000ffff36457812ULL, 0x000fe400078ec0ffULL,
0x00000035ff4c723eULL, 0x000fe400020006ffULL, 0x00000010ff367819ULL, 0x000fc40000011637ULL,
0x000000ff37567812ULL, 0x040fe400078ec0ffULL, 0x00000018ff547819ULL, 0x000fe40000011637ULL,
0x0000ffff37477812ULL, 0x000fe400078ec0ffULL, 0x000000ff46357812ULL, 0x000fe400078ec0ffULL,
0x000000ff4d377812ULL, 0x000fe400078ec0ffULL, 0x0000004eff55723eULL, 0x000fc400020006ffULL,
0x00000053ff4e723eULL, 0x000fe400020006ffULL, 0x00000035ff35723eULL, 0x000fe400020006ffULL,
0x0000004fff50723eULL, 0x000fe400020006ffULL, 0x00000037ff53723eULL, 0x000fe400020006ffULL,
0x0000541034347816ULL, 0x000fe40000000035ULL, 0x0000541050357816ULL, 0x000fc40000000053ULL,
0x00000054ff4d723eULL, 0x000fe400020006ffULL, 0x00000008ff377819ULL, 0x000fe4000001165aULL,
0x00000008ff547819ULL, 0x000fe2000001165bULL, 0x000000343038723cULL, 0x000b620000001838ULL,
0x0000004bff52723eULL, 0x000fe400020006ffULL, 0x000000ff51517812ULL, 0x000fe400078ec0ffULL,
0x000000ff36537812ULL, 0x000fc400078ec0ffULL, 0x00000037ff34723eULL, 0x020fe400020006ffULL,
0x00000054ff35723eULL, 0x000fe400020006ffULL, 0x0000541034347816ULL, 0x000fe40000000052ULL,
0x0000541035357816ULL, 0x000fe40000000055ULL, 0x00000008ff457819ULL, 0x000fe40000011645ULL,
0x00000008ff477819ULL, 0x000fc40000011647ULL, 0x00000008ff0f7819ULL, 0x000fe2000001160fULL,
0x000000343034723cULL, 0x000b620000001828ULL, 0x00000056ff4f723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000051ff28723eULL, 0x020fe400020006ffULL, 0x00000053ff29723eULL, 0x000fc400020006ffULL,
0x0000000dff0d723eULL, 0x000fe400020006ffULL, 0x0000000fff15723eULL, 0x000fe400020006ffULL,
0x000054104e287816ULL, 0x000fe40000000028ULL, 0x000054104f297816ULL, 0x000fe40000000029ULL,
0x00005410454c7816ULL, 0x000fe4000000004cULL, 0x00005410474d7816ULL, 0x000fc4000000004dULL,
0x0000541015157816ULL, 0x000fe2000000000dULL, 0x000000283028723cULL, 0x040f62000000182cULL,
0x000000ff3c587812ULL, 0x002fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe4000001163cULL,
0x000000ff3d597812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001163dULL,
0x0000004c3024723cULL, 0x000f620000001824ULL, 0x00000010ff0d7819ULL, 0x000fc4000001163eULL,
0x000000ff3e447812ULL, 0x040fe400078ec0ffULL, 0x00000018ff0f7819ULL, 0x000fe4000001163eULL,
0x00000018ff097819ULL, 0x000fe2000001163fULL, 0x000000141014723cULL, 0x000b620000001840ULL,
0x0000ffff3e3e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff0d0d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3e7819ULL, 0x000fc4000001163eULL, 0x00000010ff427819ULL, 0x020fe4000001163cULL,
0x0000ffff3c407812ULL, 0x000fe400078ec0ffULL, 0x00000010ff437819ULL, 0x000fe4000001163dULL,
0x00000010ff3c7819ULL, 0x000fe4000001163fULL, 0x000000ff3f417812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3d3d7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff42427812ULL, 0x000fe400078ec0ffULL, 0x000000ff43437812ULL, 0x000fe400078ec0ffULL,
0x00000008ff407819ULL, 0x000fe40000011640ULL, 0x00000008ff3d7819ULL, 0x000fe4000001163dULL,
0x000000ff3c3c7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff3f7819ULL, 0x000fe4000001163fULL,
0x00000041ff45723eULL, 0x000fe400020006ffULL, 0x00000058ff46723eULL, 0x000fe400020006ffULL,
0x00000059ff4b723eULL, 0x000fe400020006ffULL, 0x00000057ff50723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fc400020006ffULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x0000003dff41723eULL, 0x000fe400020006ffULL,
0x0000000fff0f723eULL, 0x000fc400020006ffULL, 0x0000000dff0d723eULL, 0x000fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000009ff09723eULL, 0x000fe400020006ffULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x0000541046467816ULL, 0x000fc40000000042ULL, 0x000054104b477816ULL, 0x000fe40000000043ULL,
0x0000541040407816ULL, 0x000fe40000000050ULL, 0x0000541041417816ULL, 0x000fe4000000004aULL,
0x0000541044447816ULL, 0x000fe2000000000dULL, 0x000000461030723cULL, 0x000b620000001838ULL,
0x0000541045457816ULL, 0x000fe4000000003cULL, 0x000054103e3e7816ULL, 0x000fc4000000000fULL,
0x000054103f3f7816ULL, 0x000fc60000000009ULL, 0x00000040102c723cULL, 0x040b700000001834ULL,
0x000000441028723cULL, 0x040b700000001828ULL, 0x0000003e1024723cULL, 0x000b620000001824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x0000000005107f8cULL, 0x0202a2000c80043fULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000f6a0760d7811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000dff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff097224ULL, 0x004fe200078e0011ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff637000007947ULL, 0x000fea000383ffffULL, 0x000000ff6600720cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x018000000b027810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000b68000057802ULL, 0x002fc40000000f00ULL, 0x00007a9000007944ULL, 0x01cfea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000b00047308ULL, 0x000e640000001000ULL,
0xbf80000004027423ULL, 0x002fc8000000000bULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000304047223ULL, 0x000fc40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006f00ff037624ULL, 0x000fe400078e00ffULL, 0x00006e00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000057919ULL, 0x000e680000000000ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x00000002ff077819ULL, 0x002fe40000011605ULL,
0x0000000808057811ULL, 0x004fe200078ff0ffULL, 0x0000000403067220ULL, 0x008fca0000410000ULL,
0x00001f0706047589ULL, 0x000e6800000e0000ULL, 0x00001f0506057589ULL, 0x000ea200000e0000ULL,
0x0000002004207220ULL, 0x042fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x040fe20000410000ULL,
0x0000001804187220ULL, 0x040fe20000410000ULL, 0x0000001904197220ULL, 0x040fe20000410000ULL,
0x0000001404147220ULL, 0x040fe20000410000ULL, 0x0000001504157220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x000fe20000410000ULL,
0x0000002205227220ULL, 0x044fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x040fe20000410000ULL,
0x0000001a051a7220ULL, 0x040fe20000410000ULL, 0x0000001b051b7220ULL, 0x040fe20000410000ULL,
0x0000001605167220ULL, 0x040fe20000410000ULL, 0x0000001705177220ULL, 0x040fe20000410000ULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x000fc20000410000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x0000100000077824ULL, 0x008fe200078e00ffULL,
0x0000002c2d2c723eULL, 0x000fe200000000ffULL, 0x00000020630e7824ULL, 0x004fe200078e00ffULL,
0x000000282928723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000001a1b1a723eULL, 0x000fc400000000ffULL, 0x000000323332723eULL, 0x000fe400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x000000ff6300720cULL, 0x000fe40003f05270ULL,
0x00000002ff067819ULL, 0x002fe40000011602ULL, 0x0000000202037812ULL, 0x040fe400078ec0ffULL,
0x0000000802087811ULL, 0x000fe200078ff0ffULL, 0x00000008060a7824ULL, 0x040fe200078e00ffULL,
0x0000000603057211ULL, 0x040fe200078ff8ffULL, 0x00000008060d7824ULL, 0x000fe200078e00ffULL,
0x0000000803047211ULL, 0x000fe200078ff8ffULL, 0x00000008080f7824ULL, 0x000fe200078e00ffULL,
0x0000000205037810ULL, 0x000fe20007ffe0ffULL, 0x0000000806087824ULL, 0x000fc600078e00ffULL,
0xfffffff80f0f7812ULL, 0x000fe400078ee204ULL, 0x0000100007047812ULL, 0x000fe400078ee2ffULL,
0xfffffff808097812ULL, 0x040fe400078ee203ULL, 0xfffffff808037812ULL, 0x000fe200078ee205ULL,
0x0000080063067824ULL, 0x000fe200078e0204ULL, 0x0000000405077810ULL, 0x040fe40007ffe0ffULL,
0x0000000605087810ULL, 0x000fe20007ffe0ffULL, 0x0000000802057824ULL, 0x000fe200078e00ffULL,
0xfffffff80a0b7812ULL, 0x000fe200078ee207ULL, 0x0000001003077824ULL, 0x000fe200078e0206ULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee208ULL, 0x000000100f0f7824ULL, 0x100fe200078e0206ULL,
0x0000000805087812ULL, 0x000fe200078ec0ffULL, 0x0000001009097824ULL, 0x100fe200078e0206ULL,
0x000000202103723eULL, 0x000fe200000000ffULL, 0x000000100b0b7824ULL, 0x100fe200078e0206ULL,
0x0000001c1d05723eULL, 0x000fe200000000ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0206ULL,
0x000000303106723eULL, 0x000fe200000000ffULL, 0x0000000107077824ULL, 0x000fe200078e0208ULL,
0x0000541003107816ULL, 0x040fe20000000005ULL, 0x00000001080f7824ULL, 0x040fe200078e020fULL,
0x0000763203117816ULL, 0x000fe20000000005ULL, 0x0000000108097824ULL, 0x040fe200078e0209ULL,
0x000000181903723eULL, 0x000fe200000000ffULL, 0x00000001080b7824ULL, 0x040fe200078e020bULL,
0x000000141505723eULL, 0x000fe200000000ffULL, 0x0000000108087824ULL, 0x000fe200078e020dULL,
0x000000242514723eULL, 0x000fe200000000ffULL, 0x0000001007007388ULL, 0x0003e20000000a00ULL,
0x00005410030c7816ULL, 0x010fc40000000005ULL, 0x00007632030d7816ULL, 0x000fe40000000005ULL,
0x000000222303723eULL, 0x000fe400000000ffULL, 0x0000001e1f05723eULL, 0x000fe200000000ffULL,
0x0000000c09007388ULL, 0x0005e20000000a00ULL, 0x0000002e2f19723eULL, 0x000fe400000000ffULL,
0x000000262715723eULL, 0x000fe400000000ffULL, 0x0000541006107816ULL, 0x002fc4000000002cULL,
0x0000763206117816ULL, 0x000fe4000000002cULL, 0x0000541028067816ULL, 0x140fe40000000014ULL,
0x0000763228077816ULL, 0x000fe20000000014ULL, 0x000000100b007388ULL, 0x000fe20000000a00ULL,
0x00000016170d723eULL, 0x004fe400000000ffULL, 0x000054102a0a7816ULL, 0x000fe20000000015ULL,
0x0000000608007388ULL, 0x0003e40000000a00ULL, 0x0000541003067816ULL, 0x002fc40000000005ULL,
0x0000763203077816ULL, 0x000fe20000000005ULL, 0x000000010e037824ULL, 0x000fc800078e0202ULL,
0x000000060f007388ULL, 0x0003e20000000a00ULL, 0x0000001003037824ULL, 0x000fe200078e0204ULL,
0x000054101a067816ULL, 0x142fe4000000000dULL, 0x000076321a077816ULL, 0x000fca000000000dULL,
0x0004000609007388ULL, 0x0003e40000000a00ULL, 0x0000541032067816ULL, 0x142fe40000000019ULL,
0x0000763232077816ULL, 0x000fca0000000019ULL, 0x000400060b007388ULL, 0x0003e40000000a00ULL,
0x000076322a0b7816ULL, 0x002fca0000000015ULL, 0x0004000a08007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000030c7984ULL, 0x000e680000000c00ULL,
0x0004000003147984ULL, 0x000ea80000000c00ULL, 0x0008000003107984ULL, 0x000ee80000000c00ULL,
0x000c000003187984ULL, 0x000ee20000000c00ULL, 0x200000ff0f0f7230ULL, 0x002fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x004fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x000000130f0f7230ULL, 0x008fe40000000000ULL,
0x000000120e0e7230ULL, 0x000fe40000000000ULL, 0x000000110d0d7230ULL, 0x000fe40000000000ULL,
0x000000100c0c7230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x000fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000c03007388ULL, 0x000fe20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001403007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff057819ULL, 0x000fc80000011602ULL,
0x0000007c0500720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000097b06ULL, 0x000e620000209000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00005a00ff0f7a12ULL, 0x000fe400078e33ffULL, 0x00000001000d7812ULL, 0x000fe400078ec0ffULL,
0x0000002002007810ULL, 0x040fe40007ffe0ffULL, 0x00000007020e7812ULL, 0x000fe200078ec0ffULL,
0x0000000900097308ULL, 0x002e640000001000ULL, 0x0ffffffe090a7810ULL, 0x002fcc0007ffe0ffULL,
0x0000000a00077305ULL, 0x000e64000021f000ULL, 0x000000ffff037224ULL, 0x002fc800078e0a07ULL,
0x00005a0003037a24ULL, 0x000fc800078e02ffULL, 0x0000000307107227ULL, 0x000fc800078e0006ULL,
0x0000000179037824ULL, 0x000fe400078e0205ULL, 0x0000000105057824ULL, 0x000fe400078e0202ULL,
0x0000000310067227ULL, 0x000fc600078e00ffULL, 0x0000000705057812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc600078e0a06ULL, 0x0ffffff805057812ULL, 0x000fe200078ef802ULL,
0x00005a0008077a24ULL, 0x000fc800078e0203ULL, 0x0000001005057824ULL, 0x000fe200078e0204ULL,
0x00005a0007007a0cULL, 0x000fc80003f06070ULL, 0x0000000005087984ULL, 0x0002a40000000c00ULL,
0x00000003ff057819ULL, 0x002fce0000011600ULL, 0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106060810ULL, 0x000fe40007ffe0ffULL, 0x00005a0007007a0cULL, 0x000fe40003f26070ULL,
0x00005a00ff007a0cULL, 0x000fd60003f05070ULL, 0x0000000106061810ULL, 0x000fc80007ffe0ffULL,
0x000000060f077207ULL, 0x000fca0004000000ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a07ULL,
0x0000590007067a24ULL, 0x000fe400078e027aULL, 0x00005a000c037a24ULL, 0x000fc800078e0203ULL,
0x00005a0006067a24ULL, 0x000fca00078e0203ULL, 0x000000067d037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0003067a11ULL, 0x000fc800078240ffULL,
0x00005f0003077a11ULL, 0x000fe200008f440cULL, 0x000000080d037824ULL, 0x000fe200078e020eULL,
0x0000007c0500720cULL, 0x000fc60003f26070ULL, 0x0000001003067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000179037824ULL, 0x100fe400078e0205ULL, 0x0000000100057824ULL, 0x000fe400078e0205ULL,
0x0000000310067227ULL, 0x002fc600078e00ffULL, 0x0000000705057812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc600078e0a06ULL, 0x0ffffff805057812ULL, 0x000fe200078ef800ULL,
0x00005a0008077a24ULL, 0x000fe200078e0203ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001005057824ULL, 0x000fe200078e0204ULL, 0x00005a0007007a0cULL, 0x000fc80003f26070ULL,
0x0000000005087984ULL, 0x0002b20000000c00ULL, 0x80005a0007071a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fc40007ffe0ffULL, 0x00005a0007007a0cULL, 0x000fda0003f46070ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x000000060f077207ULL, 0x000fca0004000000ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a07ULL, 0x0000590007067a24ULL, 0x000fe400078e027aULL,
0x00005a000c037a24ULL, 0x000fe200078e0203ULL, 0x00000040020c7810ULL, 0x000fc60007ffe0ffULL,
0x00005a0006067a24ULL, 0x000fe200078e0203ULL, 0x00000003ff057819ULL, 0x002fc8000001160cULL,
0x000000067d037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003067a11ULL, 0x000fc800078240ffULL, 0x00005f0003077a11ULL, 0x000fe200008f440eULL,
0x000000080d037824ULL, 0x000fe200078e0200ULL, 0x0000007c0500720cULL, 0x000fc60003f26070ULL,
0x0000001003067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000179007824ULL, 0x100fe400078e0205ULL,
0x000000010c057824ULL, 0x000fe400078e0205ULL, 0x0000000010037227ULL, 0x000fc600078e00ffULL,
0x0000000705057812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x002fc600078e0a03ULL,
0x0ffffff805057812ULL, 0x000fe200078ef80cULL, 0x00005a0007067a24ULL, 0x000fe200078e0200ULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001005057824ULL, 0x000fe200078e0204ULL,
0x00005a0006007a0cULL, 0x000fc80003f26070ULL, 0x0000000005087984ULL, 0x0002b20000000c00ULL,
0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL, 0x0000000103031810ULL, 0x000fc40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fda0003f46070ULL, 0x0000000103032810ULL, 0x000fc80007ffe0ffULL,
0x000000030f037207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e027aULL, 0x00005a0007007a24ULL, 0x000fc800078e0200ULL,
0x00005a0003007a24ULL, 0x000fca00078e0200ULL, 0x000000007d037210ULL, 0x000fe40007f3e0ffULL,
0x0000006002007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003067a11ULL, 0x040fe400078240ffULL, 0x00000003ff057819ULL, 0x002fe40000011600ULL,
0x00005f0003077a11ULL, 0x000fe200008f440eULL, 0x000000080d037824ULL, 0x000fe200078e020cULL,
0x0000007c0500720cULL, 0x000fe20003f26070ULL, 0x0000000179797824ULL, 0x000fe400078e0205ULL,
0x0000001003027825ULL, 0x000fca00078e0006ULL, 0x0000000802007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000007910027227ULL, 0x002fc800078e00ffULL,
0x000000ffff067224ULL, 0x000fe400078e0a02ULL, 0x0000000100057824ULL, 0x000fe400078e0205ULL,
0x00005a0006037a24ULL, 0x000fc600078e0279ULL, 0x0000000705057812ULL, 0x000fe400078ec0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f26070ULL, 0xfffffff805057812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001005057824ULL, 0x000fca00078e0204ULL,
0x0000000005087984ULL, 0x0002a20000000c00ULL, 0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL,
0x0000000102021810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fe20003f46070ULL,
0x000000080d057824ULL, 0x002fd800078e0200ULL, 0x0000000102022810ULL, 0x000fc80007ffe0ffULL,
0x000000020f037207ULL, 0x000fca0004000000ULL, 0x000000ffff047224ULL, 0x000fe400078e0a03ULL,
0x0000590003027a24ULL, 0x000fe400078e027aULL, 0x00005a0004797a24ULL, 0x000fc800078e0279ULL,
0x00005a0002027a24ULL, 0x000fca00078e0279ULL, 0x000000027d7d7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005e007d027a11ULL, 0x000fc800078040ffULL,
0x00005f007d037a11ULL, 0x000fca00000f4404ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x004fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000650000720cULL, 0x000fe20003f06070ULL, 0xffffffffff037424ULL, 0x000fd800078e00ffULL,
0x000000026d0b8824ULL, 0x000fc800078e00ffULL, 0x00006a000b0b8a24ULL, 0x000fc800078e0200ULL,
0x000066000b0a8625ULL, 0x000fe200078e003eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000060a038981ULL, 0x000ea2000c1e1900ULL, 0x00006e00ff0c7624ULL, 0x000fe400078e00ffULL,
0x00006f00ff0d7624ULL, 0x000fe200078e00ffULL, 0x00f60000ff087f8cULL, 0x000ee8000c80043fULL,
0x000000060c077981ULL, 0x002322000c1e9900ULL, 0x000001ff0400780cULL, 0x000fe20003f04070ULL,
0x00005800ff6c7624ULL, 0x000fc400078e00ffULL, 0x000000406e6e7824ULL, 0x000fe400078e00ffULL,
0x00000080ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000001f6c6c7810ULL, 0x000fe20007ffe0ffULL,
0x0000004000717824ULL, 0x000fe400078e00ffULL, 0x000000407a047824ULL, 0x000fe200078e00ffULL,
0x00000005ff6c7819ULL, 0x000fe2000001166cULL, 0x0000006e030e7224ULL, 0x004fc800078e02ffULL,
0x000064000e0a7625ULL, 0x000fe200078e000fULL, 0x0000060000000947ULL, 0x000fea0003800000ULL,
0x00000002ff217819ULL, 0x00afe40000011649ULL, 0x0000004949127211ULL, 0x000fe400078fe8ffULL,
0x00000008211b7810ULL, 0x000fe20007ffe0ffULL, 0x000000407a7a7824ULL, 0x000fe200078e0221ULL,
0x00000003121a7812ULL, 0x000fe400078ec0ffULL, 0x00001000001c7811ULL, 0x000fe200078e68ffULL,
0x000000807a0c7825ULL, 0x040fe200078e00ffULL, 0x000000087a0e7810ULL, 0x000fc40007ffe0ffULL,
0x000000107a107810ULL, 0x000fe40007ffe0ffULL, 0x000000300c157812ULL, 0x100fe200078ef806ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000287a127810ULL, 0x000fe40007ffe0ffULL,
0x000000150a147210ULL, 0x000fe20007f1e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000300e177812ULL, 0x100fe400078ef806ULL, 0x00000071020e7217ULL, 0x000fe20007800000ULL,
0x000000010b157824ULL, 0x000fe200000e060dULL, 0x0000003010137812ULL, 0x000fc400078ef806ULL,
0x000000170a167210ULL, 0x000fe20007f3e0ffULL, 0x000000010e187824ULL, 0x000fe200078e0a71ULL,
0x000000130a0c7210ULL, 0x000fe40007f5e0ffULL, 0x000000207a107810ULL, 0x040fe20007ffe0ffULL,
0x000000010b177824ULL, 0x040fe200008e060fULL, 0x000000187a0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0d7824ULL, 0x000fe200010e0611ULL, 0x000000181b00720cULL, 0x080fe20003f26070ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000182100720cULL, 0x000fc40003f06070ULL,
0x0ffffffc1a497812ULL, 0x000fe200078ef849ULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0x0000003010137812ULL, 0x000fe400078ef806ULL, 0x0000001021257810ULL, 0x000fe20007ffe0ffULL,
0x000000041b1b7824ULL, 0x000fe200078e00ffULL, 0x000000130a107210ULL, 0x000fe20007f7e0ffULL,
0x0000001049497824ULL, 0x000fe200078e021cULL, 0x000000300e197812ULL, 0x000fe400078ef806ULL,
0xfffffffc1b137812ULL, 0x000fe200078ee21aULL, 0x000000010b117824ULL, 0x000fe200018e0611ULL,
0x000000190a0e7210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014497faeULL, 0x0003e2000c101c46ULL, 0x00000020211b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001013197824ULL, 0x000fe200078e021cULL, 0x00000028211d7810ULL, 0x040fe20007ffe0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000030211f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000016197faeULL, 0x0005e2000c901c46ULL, 0x0000001821277810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0f7824ULL, 0x000fe200010e060fULL, 0x0000003012237812ULL, 0x000fe400078ef806ULL,
0x000000307a127810ULL, 0x040fe20007ffe0ffULL, 0x000000041b157824ULL, 0x002fe200078e00ffULL,
0x000000387a147810ULL, 0x000fe40007ffe0ffULL, 0x000000182500720cULL, 0x080fe40003fa6070ULL,
0x0000003821217810ULL, 0x000fe20007ffe0ffULL, 0x0000000425197824ULL, 0x004fe200078e00ffULL,
0x000000230a167210ULL, 0x000fe20007fde0ffULL, 0x000000041d237824ULL, 0x040fe200078e00ffULL,
0x000000181d00720cULL, 0x080fe20003f46070ULL, 0x000000041f257824ULL, 0x040fe200078e00ffULL,
0x000000181f00720cULL, 0x080fe20003f26070ULL, 0x000000010b177824ULL, 0x000fe200030e0613ULL,
0x000000182700720cULL, 0x000fe20003f86070ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0xfffffffc151d7812ULL, 0x000fc400078ee21aULL, 0x000000181b00720cULL, 0x080fe20003f66070ULL,
0x0000000427277824ULL, 0x000fe200078e00ffULL, 0x00000030121f7812ULL, 0x000fe200078ef806ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000182100720cULL, 0x040fe40003f06070ULL,
0x0000001f0a127210ULL, 0x000fe20007fde0ffULL, 0x0000000421297824ULL, 0x000fe200078e00ffULL,
0xfffffffc19197812ULL, 0x000fe200078ee21aULL, 0x000000101d1d7824ULL, 0x000fe200078e021cULL,
0xfffffffc25217812ULL, 0x100fe200078ee21aULL, 0x000000010b137824ULL, 0x000fe200030e0613ULL,
0xfffffffc271b7812ULL, 0x000fe200078ee21aULL, 0x0000001019197824ULL, 0x000fe200078e021cULL,
0x0000003014257812ULL, 0x000fe200078ef806ULL, 0x0000001021217824ULL, 0x000fe200078e021cULL,
0xfffffffc231f7812ULL, 0x000fe200078ee21aULL, 0x000000101b1b7824ULL, 0x000fe200078e021cULL,
0xfffffffc29237812ULL, 0x000fe200078ee21aULL, 0x000000000c197faeULL, 0x0003e2000e901c46ULL,
0x000000250a0a7210ULL, 0x000fe20007fde0ffULL, 0x000000101f1f7824ULL, 0x000fc400078e021cULL,
0x0000001023237824ULL, 0x000fe200078e021cULL, 0x000000000e1b7faeULL, 0x0003e2000e101c46ULL,
0x000000010b0b7824ULL, 0x000fc600030e0615ULL, 0x00000000101d7faeULL, 0x0003e8000d901c46ULL,
0x00000000161f7faeULL, 0x0003e8000d101c46ULL, 0x0000000012217faeULL, 0x0003e8000c901c46ULL,
0x000000000a237faeULL, 0x0003e2000c101c46ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x00000008491b7811ULL, 0x04afe400078ff0ffULL, 0x00000010490f7811ULL, 0x000fc400078ff0ffULL,
0x00000004490c7211ULL, 0x000fe200078ff0ffULL, 0x000000041b137824ULL, 0x000fe200078e00ffULL,
0x00000049490d7211ULL, 0x000fe200078fe8ffULL, 0x000000040f157824ULL, 0x000fe200078e00ffULL,
0x0000001849117811ULL, 0x040fe200078ff0ffULL, 0x00000001040e7824ULL, 0x040fe200078e021bULL,
0x0000002049177811ULL, 0x040fe200078ff0ffULL, 0x0000000104107824ULL, 0x000fe200078e020fULL,
0x0000002849257811ULL, 0x000fe200078ff0ffULL, 0x0000000411197824ULL, 0x000fe200078e00ffULL,
0x0000003049297811ULL, 0x000fe200078ff0ffULL, 0x00000004171d7824ULL, 0x000fe200078e00ffULL,
0x00000038492d7811ULL, 0x000fe200078ff0ffULL, 0x00000004251f7824ULL, 0x000fe200078e00ffULL,
0x000000030d1a7812ULL, 0x000fe200078ec0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x00001000002f7811ULL, 0x000fc400078e68ffULL, 0xfffffffc13127812ULL, 0x100fe200078ee21aULL,
0x0000000429217824ULL, 0x000fe200078e00ffULL, 0xfffffffc15137812ULL, 0x000fe200078ee21aULL,
0x000000042d237824ULL, 0x000fe200078e00ffULL, 0x000000300c1b7812ULL, 0x000fe200078ef806ULL,
0x0000000104147824ULL, 0x000fe200078e0211ULL, 0xfffffffc19157812ULL, 0x100fe200078ee21aULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0ffffffc1a497812ULL, 0x000fe400078ef849ULL,
0xfffffffc1d167812ULL, 0x100fe200078ee21aULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffffc1f187812ULL, 0x000fc400078ee21aULL, 0xfffffffc21197812ULL, 0x100fe200078ee21aULL,
0x00000010131f7824ULL, 0x100fe200078e022fULL, 0xfffffffc231a7812ULL, 0x000fe200078ee21aULL,
0x0000001049497824ULL, 0x100fe200078e022fULL, 0x0000001b0a0c7210ULL, 0x000fe20007f1e0ffULL,
0x00000010121d7824ULL, 0x100fe200078e022fULL, 0x000000300e137812ULL, 0x100fe200078ef806ULL,
0x0000001015217824ULL, 0x100fe200078e022fULL, 0x00000030101b7812ULL, 0x000fe200078ef806ULL,
0x0000001016237824ULL, 0x100fe400078e022fULL, 0x0000001018277824ULL, 0x100fe200078e022fULL,
0x000000130a187210ULL, 0x000fe20007f3e0ffULL, 0x00000010192b7824ULL, 0x000fc400078e022fULL,
0x000000101a2f7824ULL, 0x000fe200078e022fULL, 0x0000001b0a1a7210ULL, 0x000fe20007f5e0ffULL,
0x0000008014127825ULL, 0x000fc800078e00ffULL, 0x000000010b1b7824ULL, 0x040fe200010e0611ULL,
0x0000003012117812ULL, 0x000fe200078ef806ULL, 0x00000001040e7824ULL, 0x040fe400078e0217ULL,
0x0000000104107824ULL, 0x040fe400078e0225ULL, 0x0000000104147824ULL, 0x000fe400078e0229ULL,
0x000000010b0d7824ULL, 0x040fe200000e060dULL, 0x000000110a127210ULL, 0x000fe20007f1e0ffULL,
0x000000010b197824ULL, 0x000fc400008e060fULL, 0x0000000104167824ULL, 0x000fe200078e022dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c497faeULL, 0x0003e2000b901c46ULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0x00000000181d7faeULL, 0x0003e2000b901c46ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000300e317812ULL, 0x100fe400078ef806ULL,
0x000000001a1f7faeULL, 0x0003e2000b901c46ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x00000030102d7812ULL, 0x000fc600078ef806ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000003014297812ULL, 0x100fe400078ef806ULL, 0x0000002d0a107210ULL, 0x000fe20007f3e0ffULL,
0x000000010b137824ULL, 0x040fe200000e0613ULL, 0x0000003016257812ULL, 0x000fe400078ef806ULL,
0x000000310a0e7210ULL, 0x040fe20007f1e0ffULL, 0x000000010b117824ULL, 0x040fe200008e0611ULL,
0x000000290a147210ULL, 0x040fe20007f5e0ffULL, 0x0000000012217faeULL, 0x0003e2000b901c46ULL,
0x000000250a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000010b0f7824ULL, 0x000fc400000e060fULL,
0x000000010b157824ULL, 0x040fe400010e0615ULL, 0x000000010b0b7824ULL, 0x000fe200018e0617ULL,
0x000000000e237faeULL, 0x0003e8000b901c46ULL, 0x0000000010277faeULL, 0x0003e8000b901c46ULL,
0x00000000142b7faeULL, 0x0003e8000b901c46ULL, 0x000000000a2f7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x00000000000a7805ULL, 0x002fc40000015200ULL,
0x00f60400ff0d7984ULL, 0x000e620000000800ULL, 0x0000006c053f7224ULL, 0x000fc400078e02ffULL,
0x00000001026f7824ULL, 0x000fe400078e0a68ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x800000000dff7812ULL, 0x002fe20007804809ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000062003f3e7625ULL, 0x000fe200078e003eULL,
0x00000008ff6f7819ULL, 0x000fe2000001166fULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a067210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0c7824ULL, 0x000fe200000e0e0bULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140cULL,
0x0000000605057211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e060cULL,
0x0000000205057819ULL, 0x000fc80000001206ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002000057824ULL, 0x002fca00078e0205ULL,
0x00000003ff067819ULL, 0x000fc80000011605ULL, 0x1ffffffe06087812ULL, 0x000fe400078ec0ffULL,
0x0000000f05067812ULL, 0x000fc600078ec0ffULL, 0x0000000105087824ULL, 0x000fe400078e0208ULL,
0x00000010060a7824ULL, 0x040fe400078e00ffULL, 0x0000001006097824ULL, 0x000fe200078e00ffULL,
0x0000000f08057812ULL, 0x040fe400078ec0ffULL, 0x0000000108087810ULL, 0x000fe40007ffe0ffULL,
0x000000f00a057812ULL, 0x000fe400078ee205ULL, 0x0000000f08087812ULL, 0x000fc600078ec0ffULL,
0x0000000005107984ULL, 0x000e62000000cc00ULL, 0x000000f009087812ULL, 0x000fca00078ee208ULL,
0x00000000080c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fe400078e0013ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fc400078e000eULL, 0x000000ffff127224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fe200078e000fULL, 0x0000001405007388ULL, 0x0003e8000000cc00ULL,
0x0000001008007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff0c7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0e7224ULL, 0x000fc600078e00ffULL,
0x0000000000087805ULL, 0x002fc80000015200ULL, 0x00f60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x006fc4000780480dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a08067210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0a7824ULL, 0x000fe200000e0e09ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140aULL,
0x0000000605057211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e060aULL,
0x0000000205057819ULL, 0x000fc80000001206ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff6600720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x3db504f307067820ULL, 0x010fe20000410000ULL,
0x00006a006d6d7a24ULL, 0x000fe200078e02ffULL, 0x0000f68800707811ULL, 0x000fe200078e18ffULL,
0x000000026c6c7824ULL, 0x000fe200078e00ffULL, 0xffffffff68697810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x00000009686b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x0000f60800747811ULL, 0x000fe200078e28ffULL,
0x000000ffff097224ULL, 0x000fc400078e0000ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0008ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x01cfc4000001ff00ULL,
0x000000010a00780cULL, 0x040fe20003f25270ULL, 0x00000080ff107424ULL, 0x000fe200078e00ffULL,
0x0000000107127810ULL, 0x000fe20007ffe0ffULL, 0x00000bc000007945ULL, 0x000fe20003800000ULL,
0x000000010a0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200078e000aULL,
0x000000010b087812ULL, 0x000fc400078e0cffULL, 0x000000020c00780cULL, 0x040fe20003f06070ULL,
0x000000ffff0a7224ULL, 0x000fe200078e000cULL, 0x000000ff0c0e7207ULL, 0x000fc60000800000ULL,
0x000000ffff121224ULL, 0x000fca00078e0207ULL, 0x00000001120d7810ULL, 0x000fc80007ffe0ffULL,
0x000000660d00720cULL, 0x000fe20003f46070ULL, 0x0000006e030d7224ULL, 0x010fc800078e02ffULL,
0x000064000d0c7625ULL, 0x000fd000078e0010ULL, 0x000005e00000a947ULL, 0x020fea0003800000ULL,
0x0000001005107824ULL, 0x002fe200078e00ffULL, 0x00000002ff407819ULL, 0x000fe20000011605ULL,
0x0000010012197824ULL, 0x000fe400078e0271ULL, 0x00000002003c7824ULL, 0x000fe200078e0208ULL,
0x0000003010117812ULL, 0x000fe200078ec0ffULL, 0x0000000104137824ULL, 0x000fe200078e0240ULL,
0x0000001040447810ULL, 0x040fe40007ffe0ffULL, 0x0000000840417810ULL, 0x000fe20007ffe0ffULL,
0x000000400e107824ULL, 0x000fe200078e0211ULL, 0x00000019023a7217ULL, 0x000fe20007800000ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x0000001840467810ULL, 0x000fe20007ffe0ffULL,
0x00000001043b7824ULL, 0x000fe200078e0244ULL, 0x0000002040487810ULL, 0x000fe20007ffe0ffULL,
0x0000008013127825ULL, 0x000fe200078e0010ULL, 0x000010003c3c7811ULL, 0x000fc400078e60ffULL,
0x00000030404a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001041b7824ULL, 0x000fe200078e0241ULL,
0x000000120c187210ULL, 0x000fe20007f3e0ffULL, 0x000000013a3d7824ULL, 0x000fe200078e0a19ULL,
0x0000000505127211ULL, 0x000fe200078fe8ffULL, 0x000000803b3a7825ULL, 0x000fc600078e0010ULL,
0x0000000312427812ULL, 0x000fe200078ec0ffULL, 0x000000010d197824ULL, 0x000fe200008e0613ULL,
0x0000003a0c3a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000104137824ULL, 0x000fe200078e0246ULL,
0x0000003d4600720cULL, 0x000fe20003fa6070ULL, 0x000000801b1a7825ULL, 0x000fc800078e0010ULL,
0x0000008013127825ULL, 0x000fe200078e0010ULL, 0x0000001a0c387210ULL, 0x000fc60007f5e0ffULL,
0x000000010d3b7824ULL, 0x040fe200008e063bULL, 0x000000120c127210ULL, 0x000fe20007f7e0ffULL,
0x000000010d397824ULL, 0x000fe200010e061bULL, 0x0000003d4000720cULL, 0x080fe20003f26070ULL,
0x0000000441437824ULL, 0x040fe200078e00ffULL, 0x0000003d4100720cULL, 0x080fe20003f46070ULL,
0x000000010d137824ULL, 0x000fe200018e0613ULL, 0x0ffffffc42417812ULL, 0x000fe200078ef805ULL,
0x0000000444457824ULL, 0x040fe200078e00ffULL, 0x0000003d4400720cULL, 0x000fe20003f66070ULL,
0x00000001041b7824ULL, 0x000fe200078e0248ULL, 0x0000002840447810ULL, 0x000fe20007ffe0ffULL,
0x0000001041417824ULL, 0x000fe200078e023cULL, 0xfffffffc43437812ULL, 0x000fe200078ee242ULL,
0x000000801b1a7825ULL, 0x000fe200078e0010ULL, 0xfffffffc45457812ULL, 0x000fc400078ee242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018417faeULL, 0x0003e2000c901c46ULL,
0x0000000104477824ULL, 0x000fe200078e0244ULL, 0x0000001a0c1a7210ULL, 0x000fe20007f9e0ffULL,
0x0000001043437824ULL, 0x100fe200078e023cULL, 0x0000003840407810ULL, 0x000fe20007ffe0ffULL,
0x0000001045457824ULL, 0x000fe400078e023cULL, 0x0000000104497824ULL, 0x000fe200078e024aULL,
0x0000000038437faeULL, 0x0005e2000d101c46ULL, 0x000000010d1b7824ULL, 0x000fe200020e061bULL,
0x0000003d4800720cULL, 0x080fe20003f86070ULL, 0x00000001044b7824ULL, 0x000fe200078e0240ULL,
0x000000003a457faeULL, 0x0007e2000d901c46ULL, 0x0000008047187825ULL, 0x002fe200078e0010ULL,
0x0000003d4400720cULL, 0x000fc40003f66070ULL, 0x0000003d4a00720cULL, 0x080fe20003f46070ULL,
0x0000000444417824ULL, 0x000fe200078e00ffULL, 0x000000180c187210ULL, 0x000fe20007fde0ffULL,
0x0000008049387825ULL, 0x004fe200078e0010ULL, 0x0000003d4000720cULL, 0x000fe40003f26070ULL,
0xfffffffc41417812ULL, 0x100fe200078ee242ULL, 0x00000004463b7824ULL, 0x008fe400078e00ffULL,
0x00000004483d7824ULL, 0x000fe400078e00ffULL, 0x000000010d197824ULL, 0x000fe200030e0619ULL,
0x000000380c387210ULL, 0x000fe20007fde0ffULL, 0x000000044a437824ULL, 0x000fe200078e00ffULL,
0xfffffffc3b3b7812ULL, 0x000fe200078ee242ULL, 0x000000804b107825ULL, 0x000fe200078e0010ULL,
0xfffffffc3d3d7812ULL, 0x000fc400078ee242ULL, 0xfffffffc43437812ULL, 0x000fe200078ee242ULL,
0x0000000440457824ULL, 0x000fe400078e00ffULL, 0x000000010d397824ULL, 0x000fe200030e0639ULL,
0x000000100c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000103b3b7824ULL, 0x000fe200078e023cULL,
0xfffffffc45457812ULL, 0x000fe200078ee242ULL, 0x000000103d3d7824ULL, 0x100fe400078e023cULL,
0x0000001041417824ULL, 0x100fe200078e023cULL, 0x00000000123b7faeULL, 0x0003e2000e901c46ULL,
0x0000001043437824ULL, 0x000fc400078e023cULL, 0x0000001045457824ULL, 0x000fe200078e023cULL,
0x000000001a3d7faeULL, 0x0003e2000e101c46ULL, 0x000000010d0d7824ULL, 0x000fc600030e0611ULL,
0x0000000018417faeULL, 0x0003e8000d901c46ULL, 0x0000000038437faeULL, 0x0003e8000d101c46ULL,
0x000000000c457faeULL, 0x0003e2000c901c46ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x00000008051b7811ULL, 0x042fe200078ff0ffULL, 0x0000000200117824ULL, 0x000fe200078e0208ULL,
0x00000010053b7811ULL, 0x000fc400078ff0ffULL, 0x0000001805417811ULL, 0x000fe200078ff0ffULL,
0x000000041b457824ULL, 0x000fe200078e00ffULL, 0x0000002005537811ULL, 0x000fe200078ff0ffULL,
0x000000043b477824ULL, 0x000fe200078e00ffULL, 0x0000002805557811ULL, 0x000fe200078ff0ffULL,
0x0000000441497824ULL, 0x000fe200078e00ffULL, 0x0000003005577811ULL, 0x000fe200078ff0ffULL,
0x00000004534b7824ULL, 0x000fe200078e00ffULL, 0x0000003805597811ULL, 0x000fe200078ff0ffULL,
0x00000004554d7824ULL, 0x000fe200078e00ffULL, 0x0000000505107211ULL, 0x000fe200078fe8ffULL,
0x00000004574f7824ULL, 0x000fe200078e00ffULL, 0x0000100011127811ULL, 0x000fe200078e60ffULL,
0x0000000459517824ULL, 0x000fe200078e00ffULL, 0x0000000310107812ULL, 0x000fe200078ec0ffULL,
0x0000000104397824ULL, 0x040fe200078e021bULL, 0x0000000405197211ULL, 0x000fe200078ff0ffULL,
0x00000001043d7824ULL, 0x040fe200078e023bULL, 0xfffffffc45457812ULL, 0x100fe200078ee210ULL,
0x0000000104417824ULL, 0x040fe200078e0241ULL, 0xfffffffc47477812ULL, 0x100fe200078ee210ULL,
0x00000001043b7824ULL, 0x000fe200078e0253ULL, 0xfffffffc49497812ULL, 0x000fe200078ee210ULL,
0x0000001045457824ULL, 0x000fe200078e0212ULL, 0xfffffffc4b4b7812ULL, 0x000fe200078ee210ULL,
0x0000001047477824ULL, 0x000fe200078e0212ULL, 0xfffffffc4d4d7812ULL, 0x000fe200078ee210ULL,
0x0000001049497824ULL, 0x100fe200078e0212ULL, 0x0ffffffc10437812ULL, 0x000fe200078ef805ULL,
0x000000104b4b7824ULL, 0x000fe200078e0212ULL, 0xfffffffc4f4f7812ULL, 0x000fe200078ee210ULL,
0x000000104d4d7824ULL, 0x000fe200078e0212ULL, 0xfffffffc51517812ULL, 0x000fe200078ee210ULL,
0x0000001005107824ULL, 0x000fc400078e00ffULL, 0x0000001043437824ULL, 0x100fe400078e0212ULL,
0x000000104f4f7824ULL, 0x100fe200078e0212ULL, 0x0000003010137812ULL, 0x000fe200078ec0ffULL,
0x0000001051517824ULL, 0x000fe400078e0212ULL, 0x00000001041b7824ULL, 0x000fe400078e0255ULL,
0x000000400e127824ULL, 0x000fe400078e0213ULL, 0x000000ffff137224ULL, 0x000fc400078e00ffULL,
0x0000000104117824ULL, 0x000fe400078e0257ULL, 0x0000008019187825ULL, 0x000fc800078e0012ULL,
0x0000008039387825ULL, 0x000fe200078e0012ULL, 0x000000180c187210ULL, 0x000fc60007f3e0ffULL,
0x000000803d3c7825ULL, 0x000fe200078e0012ULL, 0x000000380c387210ULL, 0x000fc60007f5e0ffULL,
0x0000008041407825ULL, 0x000fe200078e0012ULL, 0x0000003c0c3c7210ULL, 0x000fc60007f7e0ffULL,
0x0000000104597824ULL, 0x000fe200078e0259ULL, 0x000000400c407210ULL, 0x000fe20007f9e0ffULL,
0x000000803b3a7825ULL, 0x000fc800078e0012ULL, 0x000000801b1a7825ULL, 0x000fc800078e0012ULL,
0x0000008011107825ULL, 0x000fc800078e0012ULL, 0x0000008059127825ULL, 0x000fc800078e0012ULL,
0x000000010d197824ULL, 0x040fe200008e0619ULL, 0x0000003a0c3a7210ULL, 0x040fe20007f3e0ffULL,
0x000000010d397824ULL, 0x040fe200010e0639ULL, 0x0000001a0c1a7210ULL, 0x040fe20007f5e0ffULL,
0x000000010d3d7824ULL, 0x040fe200018e063dULL, 0x000000100c107210ULL, 0x040fe20007f7e0ffULL,
0x000000010d417824ULL, 0x040fe200020e0641ULL, 0x000000120c0c7210ULL, 0x000fe20007f9e0ffULL,
0x000000010d3b7824ULL, 0x040fe200008e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018437faeULL, 0x0003e2000b901c46ULL, 0x000000010d1b7824ULL, 0x000fc400010e061bULL,
0x000000010d117824ULL, 0x040fe200018e0611ULL, 0x0000000038457faeULL, 0x0003e2000b901c46ULL,
0x000000010d0d7824ULL, 0x000fc600020e0613ULL, 0x000000003c477faeULL, 0x0003e8000b901c46ULL,
0x0000000040497faeULL, 0x0003e8000b901c46ULL, 0x000000003a4b7faeULL, 0x0003e8000b901c46ULL,
0x000000001a4d7faeULL, 0x0003e8000b901c46ULL, 0x00000000104f7faeULL, 0x0003e8000b901c46ULL,
0x000000000c517faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010e00780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x0000000409097810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff037424ULL, 0x000fc600078e00ffULL, 0x000000650900720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x000000026d0c7824ULL, 0x002fe400078e0209ULL,
0x00000004ff0d7424ULL, 0x000fc800078e00ffULL, 0x000066000c0c7625ULL, 0x000fca00078e000dULL,
0x000000060c037981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002005447810ULL, 0x040fe20007ffe0ffULL,
0x00000002000b7824ULL, 0x000fe200078e020bULL, 0xfffffff8050c7812ULL, 0x042fe200078ec0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0xfffffff844447812ULL, 0x000fe400078ec0ffULL,
0x0000000705107812ULL, 0x000fe400078ec0ffULL, 0x000000070c3d7812ULL, 0x100fe400078ef805ULL,
0x0000000744447812ULL, 0x000fc400078ef805ULL, 0x000010000b0b7811ULL, 0x000fe400078e60ffULL,
0x00000008100c7812ULL, 0x000fe400078ef805ULL, 0x00000001ff0d7819ULL, 0x000fe4000001163dULL,
0x00000001ff3c7819ULL, 0x000fe20000011644ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000013c107824ULL, 0x000fe200078e020eULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000444117824ULL, 0x000fe200078e00ffULL, 0x000000010e127810ULL, 0x000fe20007ffe0ffULL,
0x000000100c187824ULL, 0x020fc400078e00ffULL, 0x000000043d1a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc11107812ULL, 0x000fe200078ee210ULL, 0x000000043d117824ULL, 0x000fe400078e00ffULL,
0x000000010d137824ULL, 0x040fe400078e0212ULL, 0x0000001010407824ULL, 0x000fe400078e020bULL,
0x000000010d107824ULL, 0x000fe400078e020eULL, 0x0000000444197824ULL, 0x000fc400078e00ffULL,
0x000000004040783bULL, 0x000e620000000200ULL, 0xfffffffc11107812ULL, 0x000fe200078ee210ULL,
0x000000013c467824ULL, 0x000fe200078e0212ULL, 0xfffffffc1a127812ULL, 0x000fe200078ee213ULL,
0x000000100c457824ULL, 0x000fe400078e00ffULL, 0x0000001010387824ULL, 0x000fe200078e020bULL,
0xfffffffc19467812ULL, 0x000fe200078ee246ULL, 0x000000040f107824ULL, 0x000fe200078e020eULL,
0x000000020e0e7810ULL, 0x000fc60007ffe0ffULL, 0x0000000210107824ULL, 0x000fe200078e00ffULL,
0x000000003838783bULL, 0x000ea20000000200ULL, 0x000000040e00780cULL, 0x000fc60003f25270ULL,
0x0000001005117211ULL, 0x000fe400078fe0ffULL, 0x0000000210107810ULL, 0x000fc60007ffe0ffULL,
0x000000010c117824ULL, 0x000fe200078e0211ULL, 0x0000001005197211ULL, 0x000fc800078fe0ffULL,
0xfffffff018117812ULL, 0x000fe200078ee211ULL, 0x0000001012187824ULL, 0x000fe400078e020bULL,
0x000000010c527824ULL, 0x000fe400078e0219ULL, 0x0000001011117824ULL, 0x000fe400078e00ffULL,
0x000000001818783bULL, 0x000ee20000000200ULL, 0xfffffff045527812ULL, 0x000fc600078ee252ULL,
0x000000001110783bULL, 0x000ee20000000200ULL, 0x00000010ff5a7819ULL, 0x102fe40000011640ULL,
0x00000018ff597819ULL, 0x000fe40000011640ULL, 0x000000ff40587812ULL, 0x040fe400078ec0ffULL,
0x0000ffff405b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff497819ULL, 0x100fe40000011643ULL,
0x00000018ff637819ULL, 0x000fc40000011643ULL, 0x000000ff43617812ULL, 0x040fe400078ec0ffULL,
0x00000018ff407819ULL, 0x004fe40000011638ULL, 0x0000ffff434b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4d7819ULL, 0x100fe40000011641ULL, 0x00000018ff5d7819ULL, 0x000fe40000011641ULL,
0x000000ff415f7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff414e7812ULL, 0x000fe400078ec0ffULL,
0x00000040ff43723eULL, 0x000fe400020006ffULL, 0x000000ff38417812ULL, 0x040fe400078ec0ffULL,
0x00000010ff407819ULL, 0x000fe40000011638ULL, 0x0000ffff38387812ULL, 0x000fe400078ec0ffULL,
0x000000ff40407812ULL, 0x000fc400078ec0ffULL, 0x00000008ff387819ULL, 0x000fe40000011638ULL,
0x00000010ff477819ULL, 0x100fe40000011642ULL, 0x00000018ff627819ULL, 0x000fe40000011642ULL,
0x000000ff42677812ULL, 0x040fe400078ec0ffULL, 0x0000ffff42487812ULL, 0x000fe400078ec0ffULL,
0x00000041ff42723eULL, 0x000fc400020006ffULL, 0x00000040ff41723eULL, 0x000fe400020006ffULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x0000541041417816ULL, 0x000fe40000000043ULL,
0x0000541042407816ULL, 0x000fe20000000038ULL, 0x0000001046387824ULL, 0x000fe200078e020bULL,
0x0000ffff39437812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4a7819ULL, 0x008fc40000011618ULL,
0x00000018ff577819ULL, 0x000fe20000011618ULL, 0x000000401034723cULL, 0x000b620000001834ULL,
0x000000ff18517812ULL, 0x040fe400078ec0ffULL, 0x0000ffff184c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff457819ULL, 0x000fe40000011619ULL, 0x00000010ff417819ULL, 0x020fe40000011639ULL,
0x00000018ff537819ULL, 0x000fc40000011619ULL, 0x000000ff19547812ULL, 0x040fe400078ec0ffULL,
0x0000ffff19467812ULL, 0x000fe400078ec0ffULL, 0x00000018ff777819ULL, 0x000fe40000011639ULL,
0x000000ff39767812ULL, 0x000fe400078ec0ffULL, 0x000000ff41197812ULL, 0x000fe400078ec0ffULL,
0x00000008ff187819ULL, 0x000fc40000011643ULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000019ff19723eULL, 0x000fe400020006ffULL,
0x00000018ff18723eULL, 0x000fe400020006ffULL, 0x00000010ff737819ULL, 0x000fe4000001163aULL,
0x0000ffff3a757812ULL, 0x000fc400078ec0ffULL, 0x0000541019197816ULL, 0x000fe40000000077ULL,
0x0000541076187816ULL, 0x000fe40000000018ULL, 0x00000018ff607819ULL, 0x000fe4000001163aULL,
0x000000ff3a647812ULL, 0x000fe400078ec0ffULL, 0x000000ff73737812ULL, 0x000fe200078ec0ffULL,
0x000000181030723cULL, 0x000b620000001830ULL, 0x00000008ff757819ULL, 0x000fc40000011675ULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000073ff19723eULL, 0x020fe400020006ffULL, 0x00000075ff18723eULL, 0x000fe400020006ffULL,
0x00000010ff6a7819ULL, 0x000fe4000001163bULL, 0x0000ffff3b727812ULL, 0x000fc400078ec0ffULL,
0x0000541019197816ULL, 0x000fe40000000060ULL, 0x0000541064187816ULL, 0x000fe40000000018ULL,
0x00000018ff5e7819ULL, 0x000fe4000001163bULL, 0x000000ff3b5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff6a6a7812ULL, 0x000fe200078ec0ffULL, 0x00000018102c723cULL, 0x000b62000000182cULL,
0x00000008ff727819ULL, 0x000fe20000011672ULL, 0x000000003838783bULL, 0x000fe20000000200ULL,
0x0000005eff5e723eULL, 0x000fc400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000006aff19723eULL, 0x020fe400020006ffULL, 0x00000072ff18723eULL, 0x000fe400020006ffULL,
0x0000541019197816ULL, 0x000fe4000000005eULL, 0x000054105c187816ULL, 0x000fe40000000018ULL,
0x000000ff5a5a7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff5b7819ULL, 0x000fe4000001165bULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x000000181028723cULL, 0x000b620000001828ULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000010ff407819ULL, 0x100fe4000001161aULL,
0x00000018ff567819ULL, 0x000fe4000001161aULL, 0x0000005aff19723eULL, 0x020fc400020006ffULL,
0x0000005bff18723eULL, 0x000fe400020006ffULL, 0x0000541019197816ULL, 0x000fe40000000059ULL,
0x0000541058187816ULL, 0x000fe40000000018ULL, 0x000000ff1a557812ULL, 0x040fe400078ec0ffULL,
0x0000ffff1a427812ULL, 0x000fe400078ec0ffULL, 0x00000010ff417819ULL, 0x100fe2000001161bULL,
0x000000181024723cULL, 0x000b620000001824ULL, 0x00000018ff507819ULL, 0x000fc4000001161bULL,
0x000000ff1b4f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff1b437812ULL, 0x000fe400078ec0ffULL,
0x0000001052187824ULL, 0x020fe200078e00ffULL, 0x000000ff4d767812ULL, 0x000fe400078ec0ffULL,
0x00000008ff757819ULL, 0x000fe4000001164eULL, 0x000000ff49497812ULL, 0x000fe200078ec0ffULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0x0000005dff5d723eULL, 0x000fc400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x000000ff47737812ULL, 0x000fe400078ec0ffULL,
0x00000008ff477819ULL, 0x000fe4000001164bULL, 0x00000008ff727819ULL, 0x000fc40000011648ULL,
0x00000049ff4b723eULL, 0x000fe400020006ffULL, 0x0000541076497816ULL, 0x000fe4000000005dULL,
0x000054105f487816ULL, 0x000fe40000000075ULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x000000481020723cULL, 0x000b620000001820ULL, 0x00000063ff63723eULL, 0x000fc400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x0000541073497816ULL, 0x020fe40000000062ULL,
0x0000541067487816ULL, 0x000fe40000000072ULL, 0x000054104b637816ULL, 0x000fc40000000063ULL,
0x0000541061627816ULL, 0x000fe40000000047ULL, 0x000000ff4a4a7812ULL, 0x000fe200078ec0ffULL,
0x00000048101c723cULL, 0x040f62000000181cULL, 0x00000008ff4c7819ULL, 0x000fe4000001164cULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x000000ff45457812ULL, 0x000fe200078ec0ffULL, 0x000000621014723cULL, 0x000b620000001814ULL,
0x00000008ff467819ULL, 0x000fc40000011646ULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x0000004aff11723eULL, 0x020fe400020006ffULL,
0x0000004cff10723eULL, 0x000fe400020006ffULL, 0x0000541011117816ULL, 0x000fe40000000057ULL,
0x0000541051107816ULL, 0x000fc40000000010ULL, 0x000000ff40407812ULL, 0x000fe400078ec0ffULL,
0x00000008ff427819ULL, 0x000fe40000011642ULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x000000101834723cULL, 0x002b620000001834ULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x000000ff41417812ULL, 0x000fe400078ec0ffULL, 0x00000008ff437819ULL, 0x000fc40000011643ULL,
0x00000045ff11723eULL, 0x020fe400020006ffULL, 0x00000046ff10723eULL, 0x000fe400020006ffULL,
0x0000541011117816ULL, 0x000fe40000000053ULL, 0x0000541054107816ULL, 0x000fe40000000010ULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x0000004fff4f723eULL, 0x000fc400020006ffULL,
0x00000010ff5a7819ULL, 0x100fe20000011638ULL, 0x000000101830723cULL, 0x000b620000001830ULL,
0x0000ffff385b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe40000011638ULL,
0x000000ff38647812ULL, 0x000fe400078ec0ffULL, 0x00000040ff11723eULL, 0x020fe400020006ffULL,
0x00000042ff10723eULL, 0x000fc400020006ffULL, 0x0000541011117816ULL, 0x000fe40000000056ULL,
0x0000541055107816ULL, 0x000fe40000000010ULL, 0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5b7819ULL, 0x000fe4000001165bULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x00000010182c723cULL, 0x000b62000000182cULL, 0x00000064ff64723eULL, 0x000fc400020006ffULL,
0x00000010ff587819ULL, 0x100fe40000011639ULL, 0x00000018ff607819ULL, 0x000fe40000011639ULL,
0x00000041ff11723eULL, 0x020fe400020006ffULL, 0x00000043ff10723eULL, 0x000fe400020006ffULL,
0x0000541011117816ULL, 0x000fe40000000050ULL, 0x000054104f107816ULL, 0x000fc40000000010ULL,
0x000000ff395e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff387819ULL, 0x100fe4000001163aULL,
0x00000018ff5c7819ULL, 0x000fe2000001163aULL, 0x000000101828723cULL, 0x000b620000001828ULL,
0x000000ff3a597812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4d7819ULL, 0x100fe4000001163bULL,
0x00000018ff4e7819ULL, 0x000fc4000001163bULL, 0x0000005aff11723eULL, 0x020fe400020006ffULL,
0x0000005bff10723eULL, 0x000fe400020006ffULL, 0x0000541011117816ULL, 0x000fe4000000006aULL,
0x0000541064107816ULL, 0x000fe40000000010ULL, 0x000000ff3b527812ULL, 0x000fe400078ec0ffULL,
0x0000ffff39397812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3a3a7812ULL, 0x000fe200078ec0ffULL,
0x000000101824723cULL, 0x000b620000001824ULL, 0x0000ffff3b3b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff58587812ULL, 0x000fe400078ec0ffULL, 0x00000008ff397819ULL, 0x000fe40000011639ULL,
0x000000ff38387812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3a7819ULL, 0x000fc4000001163aULL,
0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff107819ULL, 0x020fe4000001163bULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fc400020006ffULL,
0x00000058ff5f723eULL, 0x000fe400020006ffULL, 0x00000039ff39723eULL, 0x000fe400020006ffULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x00000052ff52723eULL, 0x000fc400020006ffULL,
0x0000004dff53723eULL, 0x000fe400020006ffULL, 0x00000010ff10723eULL, 0x000fe400020006ffULL,
0x000054105f5f7816ULL, 0x000fe40000000060ULL, 0x000054105e5e7816ULL, 0x000fe40000000039ULL,
0x00005410383b7816ULL, 0x000fe4000000005cULL, 0x00005410593a7816ULL, 0x000fc4000000003aULL,
0x0000541053537816ULL, 0x000fe2000000004eULL, 0x0000005e1820723cULL, 0x000b620000001820ULL,
0x0000541052527816ULL, 0x000fce0000000010ULL, 0x0000003a181c723cULL, 0x040b70000000181cULL,
0x000000521814723cULL, 0x000b620000001814ULL, 0xfffff08000001947ULL, 0x000fce000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0008ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe2a000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000000635357220ULL, 0x080fe20000410000ULL,
0x0000000630307220ULL, 0x080fe20000410000ULL, 0x000000062d0a7220ULL, 0x080fe20000410000ULL,
0x0000000625257220ULL, 0x080fe20000410000ULL, 0x0000000621217220ULL, 0x0a0fe20000410000ULL,
0x0000000634197220ULL, 0x080fe20000410000ULL, 0x00000006320d7220ULL, 0x080fe20000410000ULL,
0x00000006330e7220ULL, 0x080fe20000410000ULL, 0x000000062f107220ULL, 0x080fe20000410000ULL,
0x00000006371a7220ULL, 0x080fe20000410000ULL, 0x00000006311b7220ULL, 0x080fe20000410000ULL,
0x000000062c337220ULL, 0x080fe20000410000ULL, 0x00000006282f7220ULL, 0x080fe20000410000ULL,
0x000000061c347220ULL, 0x080fe20000410000ULL, 0x000000061d327220ULL, 0x080fe20000410000ULL,
0x00000006360c7220ULL, 0x080fe20000410000ULL, 0x000000062e0f7220ULL, 0x080fe20000410000ULL,
0x0000000629387220ULL, 0x080fe20000410000ULL, 0x000000062a287220ULL, 0x080fe20000410000ULL,
0x000000062b377220ULL, 0x080fe20000410000ULL, 0x0000000620317220ULL, 0x080fe20000410000ULL,
0x000000061e1c7220ULL, 0x080fe20000410000ULL, 0x000000061f1d7220ULL, 0x080fe20000410000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0035ULL, 0x0000000624367220ULL, 0x080fe20000410000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0030ULL, 0x0000000626297220ULL, 0x080fe20000410000ULL,
0x0000000627187220ULL, 0x080fe20000410000ULL, 0x0000000622207220ULL, 0x080fe20000410000ULL,
0x0000000623117220ULL, 0x080fe20000410000ULL, 0x00000006142a7220ULL, 0x080fe20000410000ULL,
0x00000006152b7220ULL, 0x080fe20000410000ULL, 0x00000006161e7220ULL, 0x080fe20000410000ULL,
0x00000006171f7220ULL, 0x000fe20000410000ULL, 0x000000ffff2e7224ULL, 0x000fc400078e000aULL,
0x000000ffff307224ULL, 0x000fe400078e0025ULL, 0x000000ffff357224ULL, 0x000fe200078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000700a7f8cULL, 0x0002a2000c80043fULL,
0x000000ffff227224ULL, 0x000fe400078e000cULL, 0x000000ffff237224ULL, 0x000fe400078e000dULL,
0x000000ffff277224ULL, 0x000fe400078e000eULL, 0x000000ffff267224ULL, 0x000fc400078e000fULL,
0x000000ffff257224ULL, 0x000fe400078e0010ULL, 0x000000ffff217224ULL, 0x000fc400078e0011ULL,
0x00000000000c7805ULL, 0x002fca0000015200ULL, 0x00000400700f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x006fe4000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c117210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000110e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000110107810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400700f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000405177824ULL, 0x000fe200078e00ffULL,
0x0000006f0700720cULL, 0x000fc80003f06070ULL, 0xfffffff0170b7812ULL, 0x000fca00078ec0ffULL,
0x0000008000247824ULL, 0x000fca00078e020bULL, 0x00f40000240c7984ULL, 0x0002a20000000c00ULL,
0x000014f000008947ULL, 0x000fea0003800000ULL, 0x00005a0000127b06ULL, 0x000ee20000209000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fe20003f85070ULL,
0x0000000205397824ULL, 0x000fe200078e00ffULL, 0x00005a00ff147a12ULL, 0x000fc800078e33ffULL,
0x0000000639397812ULL, 0x000fca00078ec0ffULL, 0x00000001393b7824ULL, 0x000fe200078e0268ULL,
0x0000001200127308ULL, 0x008ee40000001000ULL, 0x0ffffffe120b7810ULL, 0x008fcc0007ffe0ffULL,
0x0000000b000b7305ULL, 0x000ee4000021f000ULL, 0x000000ffff117224ULL, 0x008fc800078e0a0bULL,
0x00005a0011117a24ULL, 0x000fc800078e02ffULL, 0x000000110b137227ULL, 0x000fe200078e000aULL,
0x00000079050a7211ULL, 0x000fca00078ff0ffULL, 0x0000000a13107227ULL, 0x000fc800078e00ffULL,
0x000000ffff117224ULL, 0x000fc800078e0a10ULL, 0x00005a0011117a24ULL, 0x000fe200078e020aULL,
0x000000080a0a7810ULL, 0x000fc80007ffe0ffULL, 0x00005a0011007a0cULL, 0x000fe20003f06070ULL,
0x0000000a13137227ULL, 0x000fc800078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc800078e0a13ULL,
0x00005a000b127a24ULL, 0x000fe400078e020aULL, 0x00000100070b7824ULL, 0x000fe400078e0271ULL,
0x80005a0011110a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0012007a0cULL, 0x000fe40003f46070ULL,
0x00005a0011007a0cULL, 0x000fe40003f26070ULL, 0x0000000b02167217ULL, 0x000fc40007800000ULL,
0x0000000110100810ULL, 0x000fc60007ffe0ffULL, 0x0000000116167824ULL, 0x000fe400078e0a0bULL,
0x000000016b0b7824ULL, 0x000fe400078e0239ULL, 0x80005a0012122a10ULL, 0x000fe40007ffe0ffULL,
0x000000010b0a7824ULL, 0x040fe200078e0a16ULL, 0x0000000110101810ULL, 0x000fe40007ffe0ffULL,
0x000000160b00720cULL, 0x000fe40003f66070ULL, 0x0000001014107207ULL, 0x000fc40006000000ULL,
0x00005a0012007a0cULL, 0x000fe40003f06070ULL, 0x0000000a690b7217ULL, 0x000fe20003800000ULL,
0x000000013b0a7824ULL, 0x000fe200078e0a16ULL, 0x0000001069557217ULL, 0x000fe40003800000ULL,
0x00000004ff0b7819ULL, 0x000fe4000001160bULL, 0x0000000113132810ULL, 0x000fe20007ffe0ffULL,
0x000000556c557224ULL, 0x000fe200078e02ffULL, 0x000000ff0b127207ULL, 0x000fc40001800000ULL,
0x000000163b00720cULL, 0x000fe40003f26070ULL, 0x0000000a690a7217ULL, 0x000fe20003800000ULL,
0x00000001550b7824ULL, 0x000fe200078e0212ULL, 0x0000000113130810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0a4a7207ULL, 0x000fe20000800000ULL, 0x000000020b0a7825ULL, 0x000fe200078e003eULL,
0x0000001314147207ULL, 0x000fe40006000000ULL, 0x0000001039417812ULL, 0x000fc400078efcffULL,
0x000000554a117211ULL, 0x000fe200078fe0ffULL, 0x000000060a4e7981ULL, 0x0046a2000c1e9500ULL,
0x0000001469577217ULL, 0x000fc60003800000ULL, 0x0000000211107825ULL, 0x000fc800078e003eULL,
0x000000016b0b7824ULL, 0x008fe200078e0241ULL, 0x0000000610537981ULL, 0x0006a2000c1e9500ULL,
0x000000576c577224ULL, 0x000fe400078e02ffULL, 0x000000010b0a7824ULL, 0x000fe400078e0a16ULL,
0x0000000112137824ULL, 0x000fe200078e0257ULL, 0x0000002039437812ULL, 0x000fe200078efcffULL,
0x00000001413d7824ULL, 0x000fe200078e0268ULL, 0x0000000a69107217ULL, 0x008fe20003800000ULL,
0x0000000213127825ULL, 0x000fe200078e003eULL, 0x000000160b00720cULL, 0x000fc40003f26070ULL,
0x00000004ff107819ULL, 0x000fe20000011610ULL, 0x000000013d0a7824ULL, 0x000fe200078e0a16ULL,
0x000000574a157211ULL, 0x000fe200078fe0ffULL, 0x0000000612487981ULL, 0x0006a2000c1e9500ULL,
0x000000016b497824ULL, 0x000fe200078e0243ULL, 0x000000163d00720cULL, 0x000fe40003f06070ULL,
0x0000000215147825ULL, 0x000fe200078e003eULL, 0x0000000a690a7217ULL, 0x000fe40003800000ULL,
0x000000ff10127207ULL, 0x008fe20000800000ULL, 0x0000000149427824ULL, 0x000fe200078e0a16ULL,
0x00000006145b7981ULL, 0x0006a6000c1e9500ULL, 0x00000001550b7824ULL, 0x000fe200078e0212ULL,
0x000000ff0a3a7207ULL, 0x000fc40000000000ULL, 0x0000004269427217ULL, 0x000fe20003800000ULL,
0x000000020b0a7825ULL, 0x000fe200078e003eULL, 0x000000164900720cULL, 0x080fe40003f26070ULL,
0x00000004ff427819ULL, 0x000fe20000011642ULL, 0x0000000143477824ULL, 0x000fe200078e0268ULL,
0x000000060a3c7981ULL, 0x0002a2000c1e9500ULL, 0x0000003039497812ULL, 0x000fe400078efcffULL,
0x000000ff42447207ULL, 0x000fe20000800000ULL, 0x0000000112137824ULL, 0x000fe200078e0257ULL,
0x000000553a117211ULL, 0x040fe200078fe0ffULL, 0x00000001470a7824ULL, 0x002fe200078e0a16ULL,
0x000000573a157211ULL, 0x008fe200078fe0ffULL, 0x00000001550b7824ULL, 0x000fe200078e0244ULL,
0x000000164700720cULL, 0x000fc40003f06070ULL, 0x0000000a690a7217ULL, 0x000fe20003800000ULL,
0x000000016b597824ULL, 0x000fe400078e0249ULL, 0x0000000211107825ULL, 0x000fe200078e003eULL,
0x000000ff0a467207ULL, 0x000fc60000000000ULL, 0x0000000213127825ULL, 0x100fe200078e003eULL,
0x0000000610457981ULL, 0x0002e6000c1e9500ULL, 0x0000000215147825ULL, 0x100fe200078e003eULL,
0x0000000612407981ULL, 0x0002e6000c1e9500ULL, 0x000000020b0a7825ULL, 0x000fe200078e003eULL,
0x00000006144b7981ULL, 0x0002e6000c1e9500ULL, 0x00000001594c7824ULL, 0x000fe200078e0a16ULL,
0x000000060a427981ULL, 0x0002e2000c1e9500ULL, 0x00000001494f7824ULL, 0x000fe200078e0268ULL,
0x0000005546117211ULL, 0x002fc400078fe0ffULL, 0x0000004c694c7217ULL, 0x000fe20003800000ULL,
0x0000000144137824ULL, 0x000fe200078e0257ULL, 0x0000005746157211ULL, 0x000fe200078fe0ffULL,
0x000000014f0a7824ULL, 0x000fe200078e0a16ULL, 0x000000165900720cULL, 0x080fe40003f26070ULL,
0x00000004ff4c7819ULL, 0x000fe2000001164cULL, 0x0000000211107825ULL, 0x100fe200078e003eULL,
0x000000164f00720cULL, 0x000fe40003f06070ULL, 0x0000000a690a7217ULL, 0x000fe20003800000ULL,
0x0000000213127825ULL, 0x100fe200078e003eULL, 0x000000ff4c507207ULL, 0x000fe20000800000ULL,
0x00000006104d7981ULL, 0x0002e4000c1e9500ULL, 0x0000000215147825ULL, 0x000fe200078e003eULL,
0x000000ff0a4c7207ULL, 0x000fe20000000000ULL, 0x0000000612447981ULL, 0x0002e8000c1e9500ULL,
0x0000000614517981ULL, 0x0002e2000c1e9500ULL, 0x00000001550b7824ULL, 0x000fe200078e0250ULL,
0x000000554c117211ULL, 0x002fc600078fe0ffULL, 0x000000020b0a7825ULL, 0x000fc800078e003eULL,
0x0000000211107825ULL, 0x000fe400078e003eULL, 0x000000060a0a7981ULL, 0x0002e2000c1e9500ULL,
0x000000574c137211ULL, 0x000fc600078fe0ffULL, 0x0000000610117981ULL, 0x0002e2000c1e9500ULL,
0x0000000150157824ULL, 0x000fe400078e0257ULL, 0x0000000213127825ULL, 0x000fc800078e003eULL,
0x0000000215147825ULL, 0x000fe400078e003eULL, 0x0000000612127981ULL, 0x0002e8000c1e9500ULL,
0x0000000614157981ULL, 0x0002e2000c1e9500ULL, 0xfffffff04a577812ULL, 0x000fe200078ec0ffULL,
0x00000001ff4a7424ULL, 0x000fc800078e00ffULL, 0x0000000116507824ULL, 0x000fc800078e0257ULL,
0x000000013b5d7824ULL, 0x000fe200078e0a50ULL, 0x0000000139557812ULL, 0x040fe400078efcffULL,
0x00000009390b7812ULL, 0x002fe400078efcffULL, 0x0000005d4a5d7219ULL, 0x000fe200000006ffULL,
0x0000000155597824ULL, 0x100fe400078e0268ULL, 0x000000010b137824ULL, 0x000fe400078e0268ULL,
0x00000001595f7824ULL, 0x000fc400078e0a50ULL, 0x0000000113637824ULL, 0x000fc600078e0a50ULL,
0x0000005f4a5f7219ULL, 0x040fe400000006ffULL, 0x000000634a637219ULL, 0x000fe400000006ffULL,
0x00000011397b7812ULL, 0x040fe400078efcffULL, 0x0000001839777812ULL, 0x040fe400078efcffULL,
0xfffffff046467812ULL, 0x000fe400078ec0ffULL, 0x0000001939757812ULL, 0x000fc400078efcffULL,
0xfffffff04c4c7812ULL, 0x000fe200078ec0ffULL, 0x000000017b147824ULL, 0x100fe400078e0268ULL,
0x0000000177107824ULL, 0x000fe400078e0268ULL, 0x0000000116647824ULL, 0x000fe400078e0246ULL,
0x00000001757d7824ULL, 0x000fe400078e0268ULL, 0x00000001475c7824ULL, 0x000fe200078e0a64ULL,
0x0000002139677812ULL, 0x000fc800078efcffULL, 0x0000005c4a5c7219ULL, 0x000fe200000006ffULL,
0x0000000167737824ULL, 0x000fc800078e0268ULL, 0x00000001735e7824ULL, 0x000fca00078e0a64ULL,
0x0000005e4a5e7219ULL, 0x000fe400000006ffULL, 0x00005410534e7816ULL, 0x004fe4000000004eULL,
0x0000000839537812ULL, 0x000fe400078efcffULL, 0x0000004e5dff7212ULL, 0x000fc6000780c0ffULL,
0x0000000153577824ULL, 0x000fe200078e0268ULL, 0x000000163b00720cULL, 0x000fc60000701470ULL,
0x0000000157617824ULL, 0x000fe200078e0a50ULL, 0x000000163900720cULL, 0x000fc800007a1070ULL,
0x000000614a617219ULL, 0x000fe400000006ffULL, 0xff80000019197808ULL, 0x000fe40002800000ULL,
0x000054105b487816ULL, 0x000fc80000000048ULL, 0x000000485dff7212ULL, 0x080fe4000784c0ffULL,
0x000000485fff7212ULL, 0x080fe4000780c0ffULL, 0x0000004861ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004863ff7212ULL, 0x000fe400078ac0ffULL, 0xfffffff03a487812ULL, 0x000fe400078ec0ffULL,
0x0000004e5fff7212ULL, 0x000fc6000782c0ffULL, 0x0000000116487824ULL, 0x040fe200078e0248ULL,
0x0000004e61ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004e63ff7212ULL, 0x000fe2000788c0ffULL,
0x00000001164e7824ULL, 0x000fe400078e024cULL, 0x000000013d467824ULL, 0x100fe200078e0a48ULL,
0x000000163b00720cULL, 0x080fe20001741470ULL, 0x00000001144c7824ULL, 0x100fe200078e0a48ULL,
0x000000165700720cULL, 0x080fe200037c1470ULL, 0x0000000110587824ULL, 0x100fe200078e0a48ULL,
0x000000161300720cULL, 0x000fe20002fa1470ULL, 0x000000017d727824ULL, 0x000fe200078e0a48ULL,
0x000000464a487219ULL, 0x000fc400000006ffULL, 0x0000004c4a467219ULL, 0x040fe400000006ffULL,
0x000000163900720cULL, 0x080fe40001741070ULL, 0x000000165300720cULL, 0x080fe400037c1070ULL,
0x000000160b00720cULL, 0x000fe40002fa1070ULL, 0x000000584a4c7219ULL, 0x000fe400000006ffULL,
0x0000541045457816ULL, 0x008fc4000000003cULL, 0x000054104b4b7816ULL, 0x000fe40000000040ULL,
0xff80000022227808ULL, 0x000fe40001000000ULL, 0xff80000023237808ULL, 0x000fe40003000000ULL,
0xff80000027277808ULL, 0x000fe40002800000ULL, 0x0000004548ff7212ULL, 0x040fe4000784c0ffULL,
0x0000004b48ff7212ULL, 0x000fc400078cc0ffULL, 0x0000004b4cff7212ULL, 0x000fe400078ac0ffULL,
0x000000165900720cULL, 0x0c0fe40000f21470ULL, 0x000000165900720cULL, 0x080fe40000701470ULL,
0x000000165700720cULL, 0x080fe40001f61470ULL, 0x000000161300720cULL, 0x080fe40002781470ULL,
0x000000163d00720cULL, 0x000fc40001741470ULL, 0x000000163d00720cULL, 0x080fe400037c1470ULL,
0x000000161000720cULL, 0x080fe40002fa1470ULL, 0x0000002839637812ULL, 0x040fe400078efcffULL,
0x0000002939617812ULL, 0x000fe400078efcffULL, 0x000000165500720cULL, 0x0c0fe40000f21070ULL,
0x000000165500720cULL, 0x000fc40000701070ULL, 0x000000165300720cULL, 0x080fe40001f61070ULL,
0x000000160b00720cULL, 0x080fe40002781070ULL, 0x000000164100720cULL, 0x0c0fe40001741070ULL,
0x000000164100720cULL, 0x080fe400037c1070ULL, 0x000000167700720cULL, 0x000fe40002fa1070ULL,
0x000000724a587219ULL, 0x000fc400000006ffULL, 0x000054104d4d7816ULL, 0x000fe40000000042ULL,
0x0000541051517816ULL, 0x000fe20000000044ULL, 0x00000001633a7824ULL, 0x100fe200078e0268ULL,
0xff8000002c2c7808ULL, 0x000fe20000800000ULL, 0x0000000161567824ULL, 0x000fe200078e0268ULL,
0xff8000001a1a7808ULL, 0x000fe40000000000ULL, 0xff8000002d2d7808ULL, 0x000fe40001800000ULL,
0xff8000001b1b7808ULL, 0x000fc40002000000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff80000026267808ULL, 0x000fe40003000000ULL, 0xff80000028287808ULL, 0x000fe40002800000ULL,
0x0000004546ff7212ULL, 0x080fe4000782c0ffULL, 0x000000454cff7212ULL, 0x080fe4000780c0ffULL,
0x0000004558ff7212ULL, 0x000fc4000786c0ffULL, 0x0000004b46ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004b58ff7212ULL, 0x000fe4000784c0ffULL, 0x0000004d5cff7212ULL, 0x040fe400078cc0ffULL,
0x000000515cff7212ULL, 0x000fe200078ac0ffULL, 0x000000013a6a7824ULL, 0x100fe200078e0a64ULL,
0x000000161400720cULL, 0x080fe20000f21470ULL, 0x0000000156647824ULL, 0x000fe200078e0a64ULL,
0x000000161400720cULL, 0x080fe20002781470ULL, 0x000000014f627824ULL, 0x000fe200078e0a4eULL,
0x000000161000720cULL, 0x000fc40000701470ULL, 0x000000167d00720cULL, 0x0c0fe40001f61470ULL,
0x000000167d00720cULL, 0x080fe40001741470ULL, 0x000000164700720cULL, 0x0c0fe400037c1470ULL,
0x000000164700720cULL, 0x000fe40002fa1470ULL, 0x00000031395f7812ULL, 0x040fe400078efcffULL,
0x00000038395d7812ULL, 0x000fc400078efcffULL, 0x00000039395b7812ULL, 0x000fe400078efcffULL,
0x000000167b00720cULL, 0x0c0fe40000f21070ULL, 0x000000167b00720cULL, 0x080fe40002781070ULL,
0x000000167700720cULL, 0x080fe40000701070ULL, 0x000000167500720cULL, 0x0c0fe40001f61070ULL,
0x000000167500720cULL, 0x000fc40001741070ULL, 0x000000164300720cULL, 0x0c0fe400037c1070ULL,
0x000000164300720cULL, 0x000fe40002fa1070ULL, 0x0000006a4a6a7219ULL, 0x040fe400000006ffULL,
0x000000644a647219ULL, 0x040fe400000006ffULL, 0x000000624a627219ULL, 0x000fe400000006ffULL,
0x0000541011117816ULL, 0x000fe2000000000aULL, 0x000000015f547824ULL, 0x100fe200078e0268ULL,
0xff8000002e2e7808ULL, 0x000fe20000800000ULL, 0x000000015d527824ULL, 0x100fe200078e0268ULL,
0xff80000025257808ULL, 0x000fe20002000000ULL, 0x000000015b507824ULL, 0x000fe200078e0268ULL,
0xff8000002f2f7808ULL, 0x000fc40000000000ULL, 0xff80000038387808ULL, 0x000fe40001800000ULL,
0xff80000037377808ULL, 0x000fe40001000000ULL, 0xff80000036367808ULL, 0x000fe40003000000ULL,
0xff80000029297808ULL, 0x000fe40002800000ULL, 0x0000004d5eff7212ULL, 0x080fe4000782c0ffULL,
0x0000004d6aff7212ULL, 0x000fc4000788c0ffULL, 0x0000004d64ff7212ULL, 0x000fe4000780c0ffULL,
0x000000515eff7212ULL, 0x080fe4000786c0ffULL, 0x000000516aff7212ULL, 0x080fe4000784c0ffULL,
0x0000005164ff7212ULL, 0x000fe400078cc0ffULL, 0x0000001162ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000154607824ULL, 0x100fe200078e0a4eULL, 0x000000167300720cULL, 0x0c0fe20000f21470ULL,
0x00000001525a7824ULL, 0x100fe200078e0a4eULL, 0x000000167300720cULL, 0x080fe20001f61470ULL,
0x00000001504e7824ULL, 0x000fe200078e0a4eULL, 0x000000163a00720cULL, 0x000fc40002781470ULL,
0x000000163a00720cULL, 0x080fe40001741470ULL, 0x000000165600720cULL, 0x0c0fe40000701470ULL,
0x000000165600720cULL, 0x080fe400037c1470ULL, 0x000000164f00720cULL, 0x080fe40002fa1470ULL,
0x000000166700720cULL, 0x0c0fe40000f21070ULL, 0x000000166700720cULL, 0x000fc40001f61070ULL,
0x000000166300720cULL, 0x0c0fe40002781070ULL, 0x000000166300720cULL, 0x080fe40001741070ULL,
0x000000166100720cULL, 0x0c0fe40000701070ULL, 0x000000166100720cULL, 0x080fe400037c1070ULL,
0x000000164900720cULL, 0x000fe40002fa1070ULL, 0x000000604a607219ULL, 0x000fc400000006ffULL,
0x0000005a4a5a7219ULL, 0x040fe400000006ffULL, 0x0000004e4a4e7219ULL, 0x000fe400000006ffULL,
0x0000541012157816ULL, 0x000fe40000000015ULL, 0xff80000030307808ULL, 0x000fe40000800000ULL,
0xff80000018187808ULL, 0x000fe40001800000ULL, 0xff80000031317808ULL, 0x000fc40002000000ULL,
0xff80000020207808ULL, 0x000fe40001000000ULL, 0xff80000035357808ULL, 0x000fe40000000000ULL,
0xff80000021217808ULL, 0x000fe40003000000ULL, 0xff80000034347808ULL, 0x000fe40002800000ULL,
0x0000001160ff7212ULL, 0x080fe4000782c0ffULL, 0x000000115aff7212ULL, 0x000fc4000786c0ffULL,
0x000000114eff7212ULL, 0x000fe4000788c0ffULL, 0x0000001562ff7212ULL, 0x080fe4000784c0ffULL,
0x0000001560ff7212ULL, 0x080fe4000780c0ffULL, 0x000000155aff7212ULL, 0x080fe400078cc0ffULL,
0x000000154eff7212ULL, 0x000fe400078ac0ffULL, 0x000000164f00720cULL, 0x000fc40001741470ULL,
0x000000165400720cULL, 0x0c0fe40000f21470ULL, 0x000000165400720cULL, 0x080fe40000701470ULL,
0x000000165200720cULL, 0x0c0fe40001f61470ULL, 0x000000165200720cULL, 0x080fe400037c1470ULL,
0x000000165000720cULL, 0x0c0fe40002781470ULL, 0x000000165000720cULL, 0x000fc40002fa1470ULL,
0x000000164900720cULL, 0x080fe40001741070ULL, 0x000000165f00720cULL, 0x0c0fe40000f21070ULL,
0x000000165f00720cULL, 0x080fe40000701070ULL, 0x000000165d00720cULL, 0x0c0fe40001f61070ULL,
0x000000165d00720cULL, 0x080fe400037c1070ULL, 0x000000165b00720cULL, 0x000fc40002781070ULL,
0x000000165b00720cULL, 0x000fe40002fa1070ULL, 0xff80000032327808ULL, 0x000fe40000800000ULL,
0xff8000002a2a7808ULL, 0x000fe40001800000ULL, 0xff8000002b2b7808ULL, 0x000fe40002000000ULL,
0xff8000001c1c7808ULL, 0x000fe40001000000ULL, 0xff8000001d1d7808ULL, 0x000fc40000000000ULL,
0xff8000001e1e7808ULL, 0x000fe40003000000ULL, 0xff8000001f1f7808ULL, 0x000fc40002800000ULL,
0x000000190c00720bULL, 0x004fe20003f1e000ULL, 0x0000001fff397424ULL, 0x000fe200078e00ffULL,
0x000000220d00720bULL, 0x000fe20003f3e000ULL, 0xffffffffff3a7424ULL, 0x000fe200078e00ffULL,
0x0000000c190b7208ULL, 0x000fe40004000000ULL, 0x0000000d220d7208ULL, 0x000fe40004800000ULL,
0x0000002c0b00720bULL, 0x000fc40003f1e000ULL, 0x0000001a0d00720bULL, 0x000fe40003f3e000ULL,
0x0000000b2c0a7208ULL, 0x000fe40004000000ULL, 0x0000000d1a0c7208ULL, 0x000fe40004800000ULL,
0x0000002d0a00720bULL, 0x000fe40003f1e000ULL, 0x000000230c00720bULL, 0x000fe40003f3e000ULL,
0x0000000a2d0a7208ULL, 0x000fc40004000000ULL, 0x0000000c230c7208ULL, 0x000fe40004800000ULL,
0x0000001b0a00720bULL, 0x000fe40003f1e000ULL, 0x000000270c00720bULL, 0x000fe40003f3e000ULL,
0x0000000a1b0a7208ULL, 0x000fe40004000000ULL, 0x0000000c270b7208ULL, 0x000fe40004800000ULL,
0x000000330a00720bULL, 0x000fc40003f1e000ULL, 0x000000260b00720bULL, 0x000fe40003f3e000ULL,
0x0000000a330d7208ULL, 0x000fe40004000000ULL, 0x0000000b260a7208ULL, 0x000fe40004800000ULL,
0x0000002e0d00720bULL, 0x000fe40003f1e000ULL, 0x000000250a00720bULL, 0x000fe40003f3e000ULL,
0x0000000d2e0c7208ULL, 0x000fc40004000000ULL, 0x0000000a250b7208ULL, 0x000fe40004800000ULL,
0x0000002f0c00720bULL, 0x000fe40003f1e000ULL, 0x000000280b00720bULL, 0x000fe40003f3e000ULL,
0x0000000c2f0d7208ULL, 0x000fe40004000000ULL, 0x0000000b280a7208ULL, 0x000fe40004800000ULL,
0x000000380d00720bULL, 0x000fc40003f1e000ULL, 0x000000370a00720bULL, 0x000fe40003f3e000ULL,
0x0000000d380d7208ULL, 0x000fe40004000000ULL, 0x0000000a370a7208ULL, 0x000fe40004800000ULL,
0x000000360d00720bULL, 0x000fe40003f1e000ULL, 0x000000290a00720bULL, 0x000fe40003f3e000ULL,
0x0000000d360d7208ULL, 0x000fc40004000000ULL, 0x0000000a290b7208ULL, 0x000fe40004800000ULL,
0x000000300d00720bULL, 0x000fe40003f1e000ULL, 0x000000180b00720bULL, 0x000fe40003f3e000ULL,
0x0000000d300a7208ULL, 0x000fe40004000000ULL, 0x0000000b180b7208ULL, 0x000fe40004800000ULL,
0x000000310a00720bULL, 0x000fc40003f1e000ULL, 0x000000200b00720bULL, 0x000fe40003f3e000ULL,
0x0000000a310a7208ULL, 0x000fe40004000000ULL, 0x0000000b200c7208ULL, 0x000fe40004800000ULL,
0x000000350a00720bULL, 0x000fe40003f1e000ULL, 0x000000210c00720bULL, 0x000fe40003f3e000ULL,
0x0000000a350b7208ULL, 0x000fc40004000000ULL, 0x0000000c210d7208ULL, 0x000fe40004800000ULL,
0x000000340b00720bULL, 0x000fe40003f1e000ULL, 0x0000001c0d00720bULL, 0x000fe40003f3e000ULL,
0x0000000b340b7208ULL, 0x000fe40004000000ULL, 0x0000000d1c0a7208ULL, 0x000fe40004800000ULL,
0x000000320b00720bULL, 0x000fc40003f1e000ULL, 0x0000001d0a00720bULL, 0x000fe40003f3e000ULL,
0x0000000b320b7208ULL, 0x000fe40004000000ULL, 0x0000000a1d0d7208ULL, 0x000fe40004800000ULL,
0x0000002a0b00720bULL, 0x000fe40003f1e000ULL, 0x0000001e0d00720bULL, 0x000fe40003f3e000ULL,
0x0000000b2a0a7208ULL, 0x000fc40004000000ULL, 0x0000000d1e0c7208ULL, 0x000fe40004800000ULL,
0x0000002b0a00720bULL, 0x000fe40003f1e000ULL, 0x0000001f0c00720bULL, 0x000fe40003f3e000ULL,
0x0000000a2b107208ULL, 0x000fe40004000000ULL, 0x0000000c1f127208ULL, 0x000fe20004800000ULL,
0x000014227f007947ULL, 0x000fec000b800000ULL, 0x0c401f00100a7f89ULL, 0x0004e400000e0000ULL,
0x0000000a1000720bULL, 0x008fc80003f1e000ULL, 0x000000100a137208ULL, 0x000fe20004000000ULL,
0x000014327f007947ULL, 0x000fea000b800000ULL, 0x0c401f00120a7f89ULL, 0x000ee800000e0000ULL,
0x0c401f000e0b7f89ULL, 0x000e6800000e0000ULL, 0x0c401f000f107f89ULL, 0x006e6800000e0000ULL,
0x0c201f0013147f89ULL, 0x000ea200000e0000ULL, 0x0000000a1200720bULL, 0x008fc40003f1e000ULL,
0x0000000b0e00720bULL, 0x000fe40003f3e000ULL, 0x000000120a0c7208ULL, 0x000fe40004000000ULL,
0x0000000e0b0d7208ULL, 0x000fe40004800000ULL, 0x000000100f00720bULL, 0x002fe20003f1e000ULL,
0x0c201f000c157f89ULL, 0x000e6600000e0000ULL, 0x0000000f100a7208ULL, 0x000fe20004000000ULL,
0x0c201f000d167f89ULL, 0x000ee200000e0000ULL, 0x000000141300720bULL, 0x004fc60003f1e000ULL,
0x0c201f000a0b7f89ULL, 0x0004a200000e0000ULL, 0x0000001314147208ULL, 0x000fe40004000000ULL,
0x000000150c00720bULL, 0x002fe40003f3e000ULL, 0x000000160d00720bULL, 0x008fe40003f5e000ULL,
0x0000000c15157208ULL, 0x000fe40004800000ULL, 0x0000000d16167208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b140c7820ULL, 0x004fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000305ff7812ULL, 0x000fc4000780c0ffULL, 0x3fb8aa3b2f137823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b312f7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b15317820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b330f7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010831ULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b30337823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b38387823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b35307823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b2b2b7823ULL, 0x000fe2000001080cULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010831ULL,
0x0000002c000e7308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b21217823ULL, 0x000fe20000010831ULL,
0x0000000b0a00720bULL, 0x000fc40003f3e000ULL, 0x0000002d000d7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b362c7823ULL, 0x004fce000001080cULL, 0x0000001b00107308ULL, 0x002e620000000800ULL,
0x3fb8aa3b342d7823ULL, 0x000fce000001080cULL, 0x0000000f00117308ULL, 0x000ff00000000800ULL,
0x0000002e00127308ULL, 0x0004700000000800ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b322e7823ULL, 0x004fe2000001080cULL, 0x000000190e0c723eULL, 0x008fc400000000ffULL,
0x0000000d100e723eULL, 0x002fc800000000ffULL, 0x0000001a000f7308ULL, 0x000e620000000800ULL,
0x000000111210723eULL, 0x000fce00000000ffULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000002700327308ULL, 0x0004e20000000800ULL, 0x000000220f0d723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b18227823ULL, 0x000fcc0000010831ULL, 0x0000002600347308ULL, 0x0003e20000000800ULL,
0x3c003c00ff277424ULL, 0x004fe200078e00ffULL, 0x00000023320f723eULL, 0x008fe200000000ffULL,
0x3c003c00ff267424ULL, 0x002fca00078e00ffULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c237823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b1e327823ULL, 0x000fe20000010831ULL,
0x000000260c18723cULL, 0x000f6a00000018ffULL, 0x0000003800387308ULL, 0x000e700000000800ULL,
0x0000002500257308ULL, 0x000eb00000000800ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x000000133812723eULL, 0x002fc400000000ffULL, 0x00000002ff387819ULL, 0x000fc80000011605ULL,
0x0000000238367810ULL, 0x040fe20007ffe0ffULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x000000342511723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b1d257823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b1f317823ULL, 0x000fe20000010831ULL, 0x0000000838397824ULL, 0x040fe200078e00ffULL,
0x0000000138347810ULL, 0x040fe20007ffe0ffULL, 0x0000000838357824ULL, 0x040fe200078e00ffULL,
0x00000008383d7810ULL, 0x000fe20007ffe0ffULL, 0x0000002c002c7308ULL, 0x000fe60000000800ULL,
0xfffffff835357812ULL, 0x000fc400078ee234ULL, 0x000000283713723eULL, 0x002fc600000000ffULL,
0x0000003300337308ULL, 0x000e620000000800ULL, 0x0000000838377824ULL, 0x000fc600078e00ffULL,
0x00000026101c723cULL, 0x020b640000001818ULL, 0xfffffff837377812ULL, 0x000fe400078ee236ULL,
0x0000002f002f7308ULL, 0x000fe60000000800ULL, 0x00000008381a7824ULL, 0x060fe200078e00ffULL,
0x0000000338187810ULL, 0x000fc80007ffe0ffULL, 0x0000003000307308ULL, 0x000ea20000000800ULL,
0x0000000438197810ULL, 0x000fe40007ffe0ffULL, 0xfffffff839397812ULL, 0x000fe400078ee218ULL,
0xfffffff81a3b7812ULL, 0x000fe400078ee219ULL, 0x0000002c3318723eULL, 0x002fe200000000ffULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x00000008382c7824ULL, 0x040fe400078e00ffULL,
0x0000000838337824ULL, 0x000fca00078e00ffULL, 0x0000002200227308ULL, 0x000e620000000800ULL,
0x0000002f301a723eULL, 0x004fe200000000ffULL, 0x000000083d307824ULL, 0x000fca00078e00ffULL,
0xfffffff8303d7812ULL, 0x000fe200078ee23dULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000ea20000000800ULL, 0x000000292219723eULL, 0x002fe200000000ffULL,
0x0000000838297824ULL, 0x040fe200078e00ffULL, 0xffffffff38227810ULL, 0x000fc80007ffe0ffULL,
0xfffffff833337812ULL, 0x000fe200078ee222ULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x00000020211b723eULL, 0x004fce00000000ffULL, 0x0000002500287308ULL, 0x0002a20000000800ULL,
0x0000000638217810ULL, 0x040fe40007ffe0ffULL, 0x0000000538207810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82c2f7812ULL, 0x000fe200078ee221ULL, 0x00000026181c723cULL, 0x000f62000000181cULL,
0xfffffff829297812ULL, 0x000fe200078ee220ULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x0000000838257824ULL, 0x002fca00078e00ffULL, 0xfffffff825257812ULL, 0x000fe400078ee238ULL,
0x0000002e002e7308ULL, 0x000e620000000800ULL, 0x000000232821723eULL, 0x004fe400000000ffULL,
0x0000000c17287812ULL, 0x000fe400078ec0ffULL, 0x0000000a0b177208ULL, 0x000fc60004800000ULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000002b002b7308ULL, 0x000ea20000000800ULL,
0x0000002d2e20723eULL, 0x002fce00000000ffULL, 0x0000003200327308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000e620000000800ULL, 0x0000002a2b22723eULL, 0x004fe400000000ffULL,
0x00009000002a7811ULL, 0x000fca00078e58ffULL, 0x0000001025257824ULL, 0x100fe400078e022aULL,
0x0000001035357824ULL, 0x100fe400078e022aULL, 0x0000001037377824ULL, 0x100fe400078e022aULL,
0x0000001039397824ULL, 0x100fe200078e022aULL, 0x000000323123723eULL, 0x002fe200000000ffULL,
0x000000103b3b7824ULL, 0x000fe400078e022aULL, 0x0000000125257824ULL, 0x000fc400078e0228ULL,
0x0000001029297824ULL, 0x100fe400078e022aULL, 0x00000026201c723cULL, 0x020f62000000181cULL,
0x0000000128357824ULL, 0x040fe200078e0235ULL, 0x0000000c25007388ULL, 0x0003e20000000800ULL,
0x000000102f2f7824ULL, 0x100fe400078e022aULL, 0x0000000128377824ULL, 0x040fe200078e0237ULL,
0x0000000e35007388ULL, 0x0003e20000000800ULL, 0x0000001033337824ULL, 0x100fe400078e022aULL,
0x0000000128397824ULL, 0x000fe200078e0239ULL, 0x0000001037007388ULL, 0x0003e20000000800ULL,
0x000000103d3d7824ULL, 0x000fc400078e022aULL, 0x00000001283b7824ULL, 0x040fe200078e023bULL,
0x0000001239007388ULL, 0x0003e20000000800ULL, 0x0000000128297824ULL, 0x040fe400078e0229ULL,
0x00000001282f7824ULL, 0x040fe200078e022fULL, 0x000000183b007388ULL, 0x0003e20000000800ULL,
0x0000000128337824ULL, 0x040fe400078e0233ULL, 0x0000000128287824ULL, 0x000fe200078e023dULL,
0x0000001a29007388ULL, 0x0003e40000000800ULL, 0x000000ffff1d7224ULL, 0x020fc400078e001eULL,
0x000000202f007388ULL, 0x0003e80000000800ULL, 0x0000002233007388ULL, 0x0003e80000000800ULL,
0x0000000d28007388ULL, 0x0003e80000000800ULL, 0x0004000f35007388ULL, 0x0003e80000000800ULL,
0x0004001137007388ULL, 0x0003e80000000800ULL, 0x0004001339007388ULL, 0x0003e80000000800ULL,
0x000400193b007388ULL, 0x0003e80000000800ULL, 0x0004001b29007388ULL, 0x0003e80000000800ULL,
0x000400212f007388ULL, 0x0003e80000000800ULL, 0x0004002333007388ULL, 0x0003e80000000800ULL,
0x00f0001424008388ULL, 0x0003e80000000c00ULL, 0x00f2001c24008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000074ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080074ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100074ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000107077810ULL, 0x000fe20007ffe0ffULL,
0x0000180074ff7f8cULL, 0x0003e6000c80043fULL, 0x000000660700720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb59000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0d7807ULL, 0x008fe40004000000ULL,
0x0001276000127802ULL, 0x000fc40000000f00ULL, 0x00000bf000007944ULL, 0x012fea0003c00000ULL,
0xffff015000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x000fe40005000000ULL,
0x000127a000127802ULL, 0x000fc40000000f00ULL, 0x00000bb000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e000dULL, 0xffff018000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0036ULL, 0x000127f000137802ULL, 0x000fc40000000f00ULL,
0x00000af000007944ULL, 0x012fea0003c00000ULL, 0xffff026000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0036ULL, 0x0001283000137802ULL, 0x000fc40000000f00ULL,
0x00000ab000007944ULL, 0x012fea0003c00000ULL, 0xffff038000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e000cULL, 0x0001288000137802ULL, 0x000fe20000000f00ULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x00000a6000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000dULL, 0xffff07b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e000cULL, 0x000128d000137802ULL, 0x000fc40000000f00ULL,
0x00000a1000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e000dULL,
0xffff079000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x004fe40004000000ULL,
0x0001292000127802ULL, 0x000fc40000000f00ULL, 0x00000a3000007944ULL, 0x018fea0003c00000ULL,
0xffff277000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x000fe40005000000ULL,
0x0001296000127802ULL, 0x000fc40000000f00ULL, 0x000009f000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff367224ULL, 0x000fe200078e000dULL, 0xffff27b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0038ULL, 0x000129b000137802ULL, 0x000fc40000000f00ULL,
0x0000093000007944ULL, 0x018fea0003c00000ULL, 0xffff28a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0038ULL, 0x000129f000137802ULL, 0x000fc40000000f00ULL,
0x000008f000007944ULL, 0x01afea0003c00000ULL, 0xffff29c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0010ULL, 0x00012a4000137802ULL, 0x000fe20000000f00ULL,
0x000000ffff0d7224ULL, 0x000fc400078e0011ULL, 0x000008a000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000dULL, 0xffff2df000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0010ULL, 0x00012a9000137802ULL, 0x000fc40000000f00ULL,
0x0000085000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e000dULL,
0xffff2dd000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x008fe40004000000ULL,
0x00012ae000127802ULL, 0x000fc40000000f00ULL, 0x0000087000007944ULL, 0x014fea0003c00000ULL,
0xffff4b8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x000fe40005000000ULL,
0x00012b2000127802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff097224ULL, 0x000fe200078e000dULL, 0xffff4bd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0038ULL, 0x00012b7000137802ULL, 0x000fc40000000f00ULL,
0x0000077000007944ULL, 0x014fea0003c00000ULL, 0xffff4cc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0038ULL, 0x00012bb000137802ULL, 0x000fc40000000f00ULL,
0x0000073000007944ULL, 0x016fea0003c00000ULL, 0xffff4de000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e000aULL, 0x00012c0000137802ULL, 0x000fe20000000f00ULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000006e000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000dULL, 0xffff521000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e000aULL, 0x00012c5000137802ULL, 0x000fc40000000f00ULL,
0x0000069000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e000dULL,
0xffff51f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x004fe40004000000ULL,
0x00012ca000127802ULL, 0x000fc40000000f00ULL, 0x000006b000007944ULL, 0x018fea0003c00000ULL,
0xffff702000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x000fe40005000000ULL,
0x00012ce000127802ULL, 0x000fc40000000f00ULL, 0x0000067000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e000dULL, 0xffff707000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0032ULL, 0x00012d3000137802ULL, 0x000fc40000000f00ULL,
0x000005b000007944ULL, 0x018fea0003c00000ULL, 0xffff716000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0032ULL, 0x00012d7000137802ULL, 0x000fc40000000f00ULL,
0x0000057000007944ULL, 0x01afea0003c00000ULL, 0xffff728000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0009ULL, 0x00012dc000137802ULL, 0x000fe20000000f00ULL,
0x000000ffff0d7224ULL, 0x000fc400078e0010ULL, 0x0000052000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000dULL, 0xffff76b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0009ULL, 0x00012e1000137802ULL, 0x000fc40000000f00ULL,
0x000004d000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e000dULL,
0xffff769000007947ULL, 0x000fea000383ffffULL, 0x00000002ff117424ULL, 0x000fe200078e00ffULL,
0x00012e60000c7802ULL, 0x000fc40000000f00ULL, 0x0000044000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e000bULL, 0xffffeba000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x006fe200078e0012ULL, 0x00012ec0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff117424ULL, 0x000fc400078e00ffULL, 0x000003e000007944ULL, 0x010fea0003c00000ULL,
0x0000000b1200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e000eULL,
0x00012f20000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff117424ULL, 0x000fe200078e00ffULL,
0x000000120b127208ULL, 0x000fc80004000000ULL, 0x0000038000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e000fULL,
0x00012f80000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff117424ULL, 0x000fe200078e00ffULL,
0x0000000e0b0e7208ULL, 0x000fc80004000000ULL, 0x0000032000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e0013ULL,
0x00012fe0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff117424ULL, 0x000fe200078e00ffULL,
0x0000000f0b0a7208ULL, 0x000fc80004000000ULL, 0x000002c000007944ULL, 0x000fea0003c00000ULL,
0x0000000b1300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e0012ULL,
0x00013040000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff117424ULL, 0x000fe200078e00ffULL,
0x000000130b147208ULL, 0x000fc80004000000ULL, 0x0000026000007944ULL, 0x000fea0003c00000ULL,
0x0000000b1200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e000eULL,
0x000130a0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff117424ULL, 0x000fe200078e00ffULL,
0x000000120b157208ULL, 0x000fc80004000000ULL, 0x0000020000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e000aULL,
0x00013100000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff117424ULL, 0x000fe200078e00ffULL,
0x0000000e0b167208ULL, 0x000fc80004000000ULL, 0x000001a000007944ULL, 0x000fea0003c00000ULL,
0xffffea7000007947ULL, 0x000fea000383ffffULL, 0x018000000b027810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000002037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000000b00028308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x040fe40003f25070ULL,
0x008000000300780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000203ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff0bff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000203ff7212ULL, 0x000fe4000780c0ffULL,
0x800000000b037812ULL, 0x000fd600078ec0ffULL, 0x0080000003020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0003ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000b00027308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x00cfe400078e0002ULL, 0x000000ffff027224ULL, 0x000fe400078e0005ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffecd6002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000003a00007348ULL, 0x000fe80003800000ULL,
0x0c000011100b7389ULL, 0x0002a200000e0039ULL, 0xfffecd200c007950ULL, 0x000fea0003c3ffffULL,
0xffffffffff3d7424ULL, 0x000fe400078e00ffULL, 0x0000001fff3c7424ULL, 0x000fe400078e00ffULL,
0x0000003d00007348ULL, 0x000fe80003800000ULL, 0x0000000d120d7389ULL, 0x0002a400000e003cULL,
0x000000ffff127224ULL, 0x002fc400078e0013ULL, 0x00000000ff137424ULL, 0x000fc800078e00ffULL,
0xfffeccb012007950ULL, 0x000fea0003c3ffffULL, 0x000000010d00780cULL, 0x000fe20003f45070ULL,
0xffffffffff137424ULL, 0x000fc800078e00ffULL, 0x0000001300007348ULL, 0x000ff00003800000ULL,
0x00000000000d7806ULL, 0x000fc800050e0100ULL, 0x000000130d0d7212ULL, 0x000fe200078ec0ffULL,
0x00000000ff137424ULL, 0x000fc800078e00ffULL, 0xfffecc4012007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005f4ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000750ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f0ULL, 0x0000000000000368ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d58ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e18ULL, 0x00000000000007ccULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015e8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015f8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001688ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000000168cULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000013480ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014d00ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014d50ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000150d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001688ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000013678ULL, 0x0000000000013678ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014d00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000150d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_16_sm_89_cubin_len = 86448;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
