/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x00000000000067e0ULL, 0x00000000000063a0ULL, 0x00380040005a0d5aULL, 0x0001001100400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL, 0x65722e0061686d5fULL, 0x2e747865742e616cULL,
0x6d5f6c656e72656bULL, 0x756265642e006168ULL, 0x00656d6172665f67ULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x6f632e766e2e616cULL, 0x0034746e6174736eULL,
0x2e6c65722e000000ULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x5f67756265642e61ULL,
0x6e2e00656d617266ULL, 0x72676c6c61632e76ULL, 0x2e766e2e00687061ULL, 0x7079746f746f7270ULL,
0x6f632e766e2e0065ULL, 0x2e30746e6174736eULL, 0x6d5f6c656e72656bULL, 0x0000000000006168ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x732e000000000000ULL, 0x0062617472747368ULL, 0x006261747274732eULL, 0x006261746d79732eULL,
0x5f6261746d79732eULL, 0x6e2e0078646e6873ULL, 0x2e006f666e692e76ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL, 0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL,
0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL, 0x6f632e766e2e0061ULL, 0x0033746e6174736eULL,
0x4d34456b00000000ULL, 0x6e2e0058414d5f33ULL, 0x6c61626f6c672e76ULL, 0x6d730074696e692eULL,
0x2e00657a69536d65ULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL, 0x79546c656e72656bULL,
0x0000000000006570ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7265746e695f5f24ULL,
0x5f245f305f6c616eULL, 0x6d735f616475635fULL, 0x725f7063725f3032ULL, 0x33665f7a74665f6eULL,
0x6170776f6c735f32ULL, 0x2e6c65722e006874ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e006369702e74ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x72656b0065707974ULL, 0x0061686d5f6c656eULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e000300000089ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000100000099ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0003000000a2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e0001000000b3ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d0022000000d3ULL, 0x0000000000005020ULL,
0x0000000000000260ULL, 0x0004000300000131ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000700030000018cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d1012000001a8ULL,
0x0000000000000000ULL, 0x0000000000005280ULL, 0x00100003000001b3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x0000002cffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000502000000000ULL, 0x0000580400000000ULL,
0x0400288080810c00ULL, 0x000000000000139cULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080870828808081ULL,
0x92082880808a0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808092920000ULL,
0x0000000000000022ULL, 0x00000034ffffffffULL, 0x0000006800000000ULL, 0x0000502000000000ULL,
0x0000026000000000ULL, 0x0000480400000000ULL, 0x80842880808a0900ULL, 0x0900000010042880ULL,
0x2880808a28808092ULL, 0x0000000c00082f04ULL, 0x000812040000002aULL, 0x0000000000000009ULL,
0x0000000900081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000007c00043704ULL, 0x00000000000c1704ULL,
0x0021f00000f80008ULL, 0x00000000000c1704ULL, 0x0021f00000f00007ULL, 0x00000000000c1704ULL,
0x0201f00000700006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL,
0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x00381b0380005003ULL, 0x000001f000043104ULL, 0xffffffff00442904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000001f000442804ULL, 0x000019d000001920ULL, 0x0000347000001a40ULL, 0x000034c000003490ULL,
0x00003500000034d0ULL, 0x0000379000003510ULL, 0x00003800000037d0ULL, 0x0000384000003810ULL,
0x00003e9000003850ULL, 0x0000036005903904ULL, 0x000089a0000000ffULL, 0x0000039000040100ULL,
0x000089a8000000ffULL, 0x000003b000040100ULL, 0x000089b0000000ffULL, 0x000003f000040100ULL,
0x000089b8000000ffULL, 0x0000041000040100ULL, 0x000089c0000000ffULL, 0x0000043000040100ULL,
0x000089c8000000ffULL, 0x0000045000040100ULL, 0x000089d0000000ffULL, 0x0000047000040100ULL,
0x000089d8000000ffULL, 0x0000049000040100ULL, 0x000089e0000000ffULL, 0x000004b000040100ULL,
0x000089e8000000ffULL, 0x000004d000040100ULL, 0x000089f0000000ffULL, 0x000004f000040100ULL,
0x000089f8000000ffULL, 0x0000051000040100ULL, 0x00008a00000000ffULL, 0x0000053000040100ULL,
0x00008a08000000ffULL, 0x0000055000040100ULL, 0x00008a10000000ffULL, 0x0000057000040100ULL,
0x00008a18000000ffULL, 0x0000096000040100ULL, 0x000089d80000000bULL, 0x00000990003f0101ULL,
0x000089d80000000bULL, 0x00000c40003f0109ULL, 0x000089b80000000bULL, 0x00000c70003f0101ULL,
0x000089b80000000bULL, 0x00000ed0003f0109ULL, 0x000089a800000003ULL, 0x00000ee0003f0101ULL,
0x000089a800000003ULL, 0x00001560003f0109ULL, 0x000089a000000003ULL, 0x000015c0003f0101ULL,
0x000089d800000003ULL, 0x000015e0003f0101ULL, 0x000089e800000003ULL, 0x000015f0003f0101ULL,
0x000089f800000003ULL, 0x00001600003f0101ULL, 0x00008a0800000003ULL, 0x00001630003f0101ULL,
0x00008a1800000003ULL, 0x00001640003f0101ULL, 0x00008a1800000003ULL, 0x000017c0003f0109ULL,
0x000089d000000007ULL, 0x000017f0003f0109ULL, 0x000089f000000011ULL, 0x00001870003f0101ULL,
0x000089f000000011ULL, 0x000018f0003f0109ULL, 0x00008a1800000003ULL, 0x00001ab0003f0101ULL,
0x00008a1800000003ULL, 0x00001cf0003f0109ULL, 0x00008a1800000003ULL, 0x00001d90003f0101ULL,
0x00008a1800000003ULL, 0x00002210003f0109ULL, 0x00008a1800000003ULL, 0x00002280003f0101ULL,
0x00008a1800000003ULL, 0x00002950003f0109ULL, 0x00008a1800000003ULL, 0x000029b0003f0101ULL,
0x00008a1800000003ULL, 0x00002a60003f0109ULL, 0x00008a1800000003ULL, 0x00002a70003f0101ULL,
0x00008a1800000003ULL, 0x00002c80003f0109ULL, 0x000089f800000005ULL, 0x00002c90003f0101ULL,
0x000089d800000005ULL, 0x00002d10003f0101ULL, 0x000089a800000003ULL, 0x00002d30003f0101ULL,
0x000089b800000003ULL, 0x00002d40003f0101ULL, 0x000089c800000003ULL, 0x00002d60003f0101ULL,
0x00008a1000000003ULL, 0x00002d70003f0101ULL, 0x00008a1000000003ULL, 0x00002d90003f0109ULL,
0x000089a000000003ULL, 0x00002da0003f0101ULL, 0x000089a000000003ULL, 0x00002fd0003f0109ULL,
0x000089b000000007ULL, 0x00003320003f0109ULL, 0x000089b80000000fULL, 0x00003630003f0101ULL,
0x00008a1000000003ULL, 0x00003670003f0101ULL, 0x00008a1000000003ULL, 0x000036a0003f0109ULL,
0x00008a1000000003ULL, 0x000036b0003f0101ULL, 0x00008a1000000003ULL, 0x00003960003f0109ULL,
0x000089f80000000fULL, 0x00003970003f0101ULL, 0x000089f80000000fULL, 0x00003b20003f0109ULL,
0x000089f00000000fULL, 0x00003b40003f0101ULL, 0x000089a800000003ULL, 0x00003c40003f0101ULL,
0x000089a000000003ULL, 0x00003d40003f0108ULL, 0x0000210000000003ULL, 0x00003db0003f0100ULL,
0x0000210800000003ULL, 0x00003e60003f0100ULL, 0x0000210800000003ULL, 0x000040c0003f0101ULL,
0x0000210800000003ULL, 0x000041c00005010aULL, 0x00002100000000ffULL, 0x0000447000060107ULL,
0x0000210000000003ULL, 0x000047000005010aULL, 0x00002108000000ffULL, 0x000048d000070101ULL,
0x0000210800000000ULL, 0x000048e0003f0108ULL, 0x0000210000000000ULL, 0x00004900003f0108ULL,
0x000089d80000000bULL, 0x00004960003f0109ULL, 0x000089b80000000bULL, 0x000049c0003f0109ULL,
0x000089a800000003ULL, 0x00004a20003f0109ULL, 0x00008a1800000003ULL, 0x00004a80003f0109ULL,
0x000089d000000007ULL, 0x00004ae0003f0109ULL, 0x000089f000000011ULL, 0x00004b40003f0109ULL,
0x00008a1800000003ULL, 0x00004ba0003f0109ULL, 0x00008a1800000003ULL, 0x00004c00003f0109ULL,
0x00008a1800000003ULL, 0x00004c60003f0109ULL, 0x00008a1800000003ULL, 0x00004cc0003f0109ULL,
0x00008a1000000003ULL, 0x00004d20003f0109ULL, 0x000089a000000003ULL, 0x00004d80003f0109ULL,
0x000089b000000007ULL, 0x00004de0003f0109ULL, 0x00008a1000000003ULL, 0x00004e40003f0109ULL,
0x00008a1000000003ULL, 0x00004ea0003f0109ULL, 0x000089f80000000fULL, 0x00004f30003f0109ULL,
0x0000210800000005ULL, 0x00004fc0003f010aULL, 0x000021000000000dULL, 0x00123803003f010aULL,
0x0000015000141c04ULL, 0x00003cb000003c50ULL, 0x000048f0000048b0ULL, 0x00000180000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x00080a0401001903ULL, 0x010002100000000dULL,
0x0000000800043604ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL,
0xfffffffc00000000ULL, 0x0000000000000008ULL, 0x0000000700000002ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000500000002ULL, 0x0000000000000000ULL, 0x00000000000000d4ULL,
0x0000000c00000002ULL, 0x0000000000005020ULL, 0x0000000000000044ULL, 0x0000000c00000002ULL,
0x0000000000000000ULL, 0x00000000000000aaULL, 0x0000000c00000002ULL, 0x0000000000000000ULL,
0x0000000043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e240000000800ULL, 0x00000000001079c3ULL, 0x000e620000002700ULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000820000127ab9ULL, 0x000fe20000000a00ULL,
0x00000004100478a5ULL, 0x002fcc000f8e0004ULL, 0x00000004ff087e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff097e24ULL, 0x000fca000f8e00ffULL, 0x0000001208087981ULL, 0x000ea2000c1e1900ULL,
0x00000000001579c3ULL, 0x000e620000002500ULL, 0x0000030000147ab9ULL, 0x000fe20000000800ULL,
0x00000000080472caULL, 0x004fda00000e0000ULL, 0x0000003f04047890ULL, 0x000fc8000fffe03fULL,
0x000000063f167899ULL, 0x000fe40008011604ULL, 0x0000007f0400788cULL, 0x000fe4000bf04070ULL,
0x000000141600728cULL, 0x000fe4000bf21070ULL, 0x000000011400788cULL, 0x000fe40008704070ULL,
0x00000014160e7287ULL, 0x000fe40008800000ULL, 0x0000003f15177287ULL, 0x002fc40008000000ULL,
0x000000010e0e7887ULL, 0x000fc80008000000ULL, 0x0000000e1700728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e620000002300ULL, 0x0000000e00047d06ULL, 0x000ea20008209000ULL,
0x0000042000007945ULL, 0x000fe20003800000ULL, 0x0000000000067919ULL, 0x000e620000002200ULL,
0x0000000000007919ULL, 0x000eea0000002100ULL, 0x0000000400047308ULL, 0x004ea20000001000ULL,
0x0000000706ff7212ULL, 0x002fc8000780fcffULL, 0x000000200000780cULL, 0x008fda0000705670ULL,
0x00006600ff028b82ULL, 0x000e620000000a00ULL, 0x00000000003f7886ULL, 0x000fe20000020000ULL,
0x0000007002058810ULL, 0x002fc80007f3e0ffULL, 0x00000000050482caULL, 0x000fe200000e0000ULL,
0x000000ffff028224ULL, 0x000fe200008e0603ULL, 0x0000000007ff7212ULL, 0x000fe2000782fe06ULL,
0x0ffffffe04057836ULL, 0x004fc60000000000ULL, 0x00000000020582caULL, 0x000fc600000e0000ULL,
0x0000000500057305ULL, 0x000e68000021f000ULL, 0x00000004ff027e24ULL, 0x000fca000f8e00ffULL,
0x00000000020482caULL, 0x000fe200000e0000ULL, 0x00000005ff037e24ULL, 0x000fca000f8e00ffULL,
0x00000000030582caULL, 0x000fda00000e0000ULL, 0x00000000040099b9ULL, 0x0003e40008040000ULL,
0x0000000000b41947ULL, 0x002fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001ffe8000067882ULL, 0x000fe20000000000ULL,
0x7ffa000000077882ULL, 0x000fe20000000000ULL, 0x001fff0000087882ULL, 0x000fe20000000000ULL,
0x7ffc000000097882ULL, 0x000fe20000000000ULL, 0x001ffefe000a7882ULL, 0x000fe20000000000ULL,
0x7ffbf800000b7882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x0089a006043f75b2ULL, 0x000e620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089a806043f75b2ULL, 0x0004620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x001ffe0000067882ULL, 0x004fe20000000000ULL, 0x7ff8000000077882ULL, 0x000fe20000000000ULL,
0x0089b008043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089b80a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089c008043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089c80a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089d008043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089d80a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089e008043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089e80a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089f006043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0089f806043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x008a0006043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x008a0806043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x008a1008043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x008a1808043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000050572caULL, 0x000fe200000e0000ULL,
0x8000000e3f067290ULL, 0x000fe2000fffe03fULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000173f0f7292ULL, 0x000fe2000f8e333fULL, 0x000000ff0700720cULL, 0x000fe20003f05270ULL,
0x0000003f0e00728cULL, 0x000fe4000bf65070ULL, 0x000000160e0f7290ULL, 0x000fc6000fffe00fULL,
0x00000000000c79c3ULL, 0x000fe20000002600ULL, 0x0000003f00047c82ULL, 0x000fe40008000000ULL,
0x00000005060672a4ULL, 0x000fc8000f8e023fULL, 0x00000006050472a5ULL, 0x000fc8000f8e0004ULL,
0x0000000f050472a5ULL, 0x000fce000f8e003fULL, 0x0000000500117c82ULL, 0x000fe40008000000ULL,
0x0000003f11047290ULL, 0x000fe4000fffe13fULL, 0x00000000000579c3ULL, 0x000e640000008800ULL,
0x000000040e0472a4ULL, 0x000fc8000f8e020fULL, 0x0000000e0400728cULL, 0x000fd6000bf26070ULL,
0x000000040e041290ULL, 0x000fe4000fffe13fULL, 0x0000000111111890ULL, 0x000fe4000fffe03fULL,
0x0000000e0400728cULL, 0x000fc6000bf46070ULL, 0x0000040000047882ULL, 0x000fe40000000000ULL,
0x0000065405047896ULL, 0x002fcc0008000004ULL, 0x0000000111112890ULL, 0x000fe2000fffe03fULL,
0x00000004ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000000e3f11b292ULL, 0x000fc6000f8e333fULL,
0x00000004000f7824ULL, 0x000fe200078e0203ULL, 0x00000024005c8947ULL, 0x000ff00003800000ULL,
0x000000010700780cULL, 0x000fe20003f05270ULL, 0x0000254000007945ULL, 0x000fd80003800000ULL,
0x0000000c007c8947ULL, 0x000fea0003800000ULL, 0x000000400000780cULL, 0x000fda0003f06070ULL,
0x0000000400948947ULL, 0x000fea0003800000ULL, 0x000000400000780cULL, 0x000fe20003f05270ULL,
0x0000007f08027836ULL, 0x000fca0000000000ULL, 0x00000007ff027819ULL, 0x000fce0000011602ULL,
0x0000000000c88947ULL, 0x000fea0003800000ULL, 0x000000600000780cULL, 0x000fda0003f05270ULL,
0x0000002400280947ULL, 0x000fea0003800000ULL, 0x0000000f0e00728cULL, 0x000fcc000bf24070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000024001c0947ULL, 0x000fea0003800000ULL,
0x0000000000087919ULL, 0x000e620000002700ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x0000000108087811ULL, 0x002fce00078e08ffULL, 0x00000017ff0a7e24ULL, 0x000fe4000f8e00ffULL,
0xffffffffff0e7424ULL, 0x000fe400078e00ffULL, 0x0000000e090a7c24ULL, 0x000fca000f8e020aULL,
0x00000001ff0b7819ULL, 0x000fc8000001160aULL, 0x000000020b00720cULL, 0x000fda0003f06070ULL,
0x00009000ff078b82ULL, 0x000e700000000800ULL, 0x00008c00ff048b82ULL, 0x000ea20000000a00ULL,
0x0000001009067824ULL, 0x000fca00078e00ffULL, 0x0000001006067812ULL, 0x000fe200078ec0ffULL,
0x0000000708078224ULL, 0x002fc800078e020bULL, 0x00000001030b7824ULL, 0x000fe400078e0206ULL,
0x0000000407048825ULL, 0x004fc800078e0004ULL, 0x00000001ff077424ULL, 0x000fe200078e00ffULL,
0x00000012040e8981ULL, 0x000362000c1e1900ULL, 0x00000001090c7812ULL, 0x000fc800078ec0ffULL,
0x0089d8070b0679a7ULL, 0x000ea2000850003fULL, 0x000022000c0d7824ULL, 0x140fe400078e0203ULL,
0x000000100c0c7824ULL, 0x000fe200078e0203ULL, 0x0089d8070b0075a7ULL, 0x004ea4000800017fULL,
0x0000003c00d48947ULL, 0x006fea0003800000ULL, 0x000000000a0b72caULL, 0x000fe200000e0000ULL,
0x0000660000047ab9ULL, 0x000fe20000000a00ULL, 0x000000000d0872caULL, 0x000fe200000e0000ULL,
0x0000007004047890ULL, 0x000fe2000ff3e03fULL, 0x000000000c0972caULL, 0x000fe200000e0000ULL,
0x0000003f000a7c82ULL, 0x000fe20008000000ULL, 0x000000000e0d72caULL, 0x020fe200000e0000ULL,
0x000000053f057290ULL, 0x000fe20008ffe43fULL, 0x000000000000781cULL, 0x000fca0003f0f070ULL,
0x000000060b0b7899ULL, 0x000fe4000800063fULL, 0x0000420008087890ULL, 0x000fe4000fffe03fULL,
0x000089d009097890ULL, 0x000fe4000fffe03fULL, 0x000000400b0b7892ULL, 0x000fd8000f8ec03fULL,
0x00000000003f082fULL, 0x000fe20003820000ULL, 0x00000008040075b4ULL, 0x0003d80008018000ULL,
0x000000000000181cULL, 0x000fe40000f0e170ULL, 0x000000000000781cULL, 0x000fd60003f2e170ULL,
0xfffffffd00ec0947ULL, 0x002fea000393ffffULL, 0x0000000109097836ULL, 0x000fca0000000000ULL,
0x0000001109007c0cULL, 0x000fda000bf06070ULL, 0xfffffffc005c8947ULL, 0x001fea000383ffffULL,
0x0000002000687947ULL, 0x000fea0003800000ULL, 0x0000000f0e00728cULL, 0x000fcc000bf24070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000020005c0947ULL, 0x000fea0003800000ULL,
0x00009000ff087b82ULL, 0x000e620000000800ULL, 0x000000ffff097224ULL, 0x000fe400078e00ffULL,
0x0000001008087c24ULL, 0x002fce000f8e02ffULL, 0x00000017ff0a7e24ULL, 0x000fe4000f8e00ffULL,
0xffffffffff0e7424ULL, 0x000fe400078e00ffULL, 0x0000000e090a7c24ULL, 0x000fca000f8e020aULL,
0x00000001ff077819ULL, 0x000fc8000001160aULL, 0x000000020700720cULL, 0x000fda0003f06070ULL,
0x00008c00ff048b82ULL, 0x000e620000000a00ULL, 0x0000001009067824ULL, 0x000fe400078e00ffULL,
0x0000000208078824ULL, 0x000fc600078e0207ULL, 0x0000001006067812ULL, 0x000fe200078ec0ffULL,
0x00000001ff0c7424ULL, 0x000fc800078e00ffULL, 0x00000001030b7824ULL, 0x000fe400078e0206ULL,
0x0000000407048825ULL, 0x002fca00078e0004ULL, 0x00000012040e8981ULL, 0x000362000c1e1900ULL,
0x0089b80c0b0679a7ULL, 0x0004e4000850003fULL, 0x00000001090c7812ULL, 0x004fca00078ec0ffULL,
0x000000100c0d7824ULL, 0x000fe200078e0203ULL, 0x0089b8070b0075a7ULL, 0x008ea4000800017fULL,
0x0000003c00348947ULL, 0x006fea0003800000ULL, 0x000000000a0b72caULL, 0x000fe200000e0000ULL,
0x0000660000067ab9ULL, 0x000fe20000000a00ULL, 0x000000000c0872caULL, 0x000fe200000e0000ULL,
0x0000007006067890ULL, 0x000fe2000ff3e03fULL, 0x00000000030472caULL, 0x000fe200000e0000ULL,
0x0000003f000a7c82ULL, 0x000fe20008000000ULL, 0x000000000d0972caULL, 0x000fe200000e0000ULL,
0x000000073f077290ULL, 0x000fe20008ffe43fULL, 0x000000000e0d72caULL, 0x020fe400000e0000ULL,
0x000000000000781cULL, 0x000fc60003f0f070ULL, 0x000000060b0b7899ULL, 0x000fc8000800063fULL,
0x0000000408087291ULL, 0x000fe4000f8e683fULL, 0x000089b009097890ULL, 0x000fe4000fffe03fULL,
0x000000400b0b7892ULL, 0x000fd8000f8ec03fULL, 0x00000000003f082fULL, 0x000fe20003820000ULL,
0x00000008060075b4ULL, 0x0003d80008018000ULL, 0x000000000000181cULL, 0x000fe40000f0e170ULL,
0x000000000000781cULL, 0x000fd60003f2e170ULL, 0xfffffffd00ec0947ULL, 0x002fea000393ffffULL,
0x0000000109097836ULL, 0x000fca0000000000ULL, 0x0000001109007c0cULL, 0x000fda000bf06070ULL,
0xfffffffc00608947ULL, 0x001fea000383ffffULL, 0x0000001c00ac7947ULL, 0x000fea0003800000ULL,
0x00008800ff047b82ULL, 0x000e620000000a00ULL, 0x0000004000027836ULL, 0x000fe20000000000ULL,
0x0000840000047ab9ULL, 0x000fe40000000800ULL, 0x00000004100472a4ULL, 0x000fe4000f8e020cULL,
0x0000007f0200780cULL, 0x000fc80003f24070ULL, 0x00000004ff097e24ULL, 0x000fc8000f8e00ffULL,
0x0000008009097824ULL, 0x000fca00078e0200ULL, 0x0000004009079836ULL, 0x040fe40000000000ULL,
0x0000001009087825ULL, 0x002fc800078e0004ULL, 0x0000001007049825ULL, 0x000fe400078e0004ULL,
0x0000001208087981ULL, 0x000f68000c1e9d00ULL, 0x0000001204049981ULL, 0x000f62000c1e9d00ULL,
0x00000001ff0c7424ULL, 0x000fc800078e00ffULL, 0x0089a80c030e79a7ULL, 0x000e64000850003fULL,
0x0089a80f030075a7ULL, 0x002e64000800017fULL, 0x0000003800b08947ULL, 0x002fea0003800000ULL,
0x0000007f0000780cULL, 0x000fe40003f04070ULL, 0x00000000000e7805ULL, 0x000fe4000001ff00ULL,
0x0000773204119816ULL, 0x020fe200000000ffULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x0000773205129816ULL, 0x000fe200000000ffULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x0000773206139816ULL, 0x000fe200000000ffULL, 0x000005e000017945ULL, 0x000fe20003800000ULL,
0x0000773207149816ULL, 0x000fc400000000ffULL, 0x0000ffff040d9812ULL, 0x000fe400078ec0ffULL,
0x0000ffff050e9812ULL, 0x000fe400078ec0ffULL, 0x0000000000047805ULL, 0x000fe4000001ff00ULL,
0x0000ffff060f9812ULL, 0x000fe200078ec0ffULL, 0x000000ffff049224ULL, 0x000fe200078e0011ULL,
0x0000ffff07109812ULL, 0x000fe400078ec0ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x000000ffff059224ULL, 0x000fc400078e0012ULL, 0x000000ffff069224ULL, 0x000fe400078e0013ULL,
0x000000ffff079224ULL, 0x000fe200078e0014ULL, 0x0000000400440947ULL, 0x000fec0003800000ULL,
0x0000773208117816ULL, 0x040fe400000000ffULL, 0x0000ffff08087812ULL, 0x000fe400078ec0ffULL,
0x00000011ff16723eULL, 0x000fe400048032ffULL, 0x00000008ff08723eULL, 0x000fe400048032ffULL,
0x00000004ff157819ULL, 0x000fe40000011600ULL, 0x0000761008147816ULL, 0x000fc40000000014ULL,
0x00000001ff087819ULL, 0x000fe40000011600ULL, 0x0000ffff09117812ULL, 0x040fe400078ec0ffULL,
0x0000000708087812ULL, 0x000fe400078ec0ffULL, 0x0000773209177816ULL, 0x000fe400000000ffULL,
0x0000ffff0a097812ULL, 0x000fe400078ec0ffULL, 0x0000001508127212ULL, 0x000fc400078e3cffULL,
0x000077320a187816ULL, 0x000fe400000000ffULL, 0x0000ffff0b137812ULL, 0x000fe200078ec0ffULL,
0x0000000815127824ULL, 0x000fe200078e0212ULL, 0x000077320b197816ULL, 0x000fe400000000ffULL,
0x000000ff140a7812ULL, 0x000fe200078ec0ffULL, 0x0000001012127824ULL, 0x000fe200078e0203ULL,
0x0000ffff160b7812ULL, 0x000fe400078ec0ffULL, 0x00000009ff09723eULL, 0x000fc400048032ffULL,
0x00000011ff11723eULL, 0x000fe400048032ffULL, 0x000076040b0a7816ULL, 0x000fe2000000000aULL,
0x000000ffff0b7224ULL, 0x000fe200078e0018ULL, 0x0000761009157816ULL, 0x000fe20000000015ULL,
0x000000ffff097224ULL, 0x000fe200078e0017ULL, 0x0000761011147816ULL, 0x000fe20000000014ULL,
0x000000ffff117224ULL, 0x000fe200078e0019ULL, 0x0000000bff16723eULL, 0x000fe400048032ffULL,
0x00000009ff09723eULL, 0x000fc400048032ffULL, 0x00000011ff17723eULL, 0x000fe400048032ffULL,
0x00007610090b7816ULL, 0x000fe4000000000bULL, 0x0000761016117816ULL, 0x000fe40000000011ULL,
0x00000013ff13723eULL, 0x000fe400048032ffULL, 0x0000761017167816ULL, 0x000fe40000000016ULL,
0x000000ff14147812ULL, 0x000fc400078ec0ffULL, 0x0000ffff0b0b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff15157812ULL, 0x000fe400078ec0ffULL, 0x000000ff13137812ULL, 0x000fe400078ec0ffULL,
0x0000ffff11187812ULL, 0x000fe400078ec0ffULL, 0x0000ffff16167812ULL, 0x000fe400078ec0ffULL,
0x0000000100097812ULL, 0x000fc400078ec0ffULL, 0x000076040b0b7816ULL, 0x000fe40000000014ULL,
0x0000760418187816ULL, 0x000fe20000000015ULL, 0x0000000809127824ULL, 0x000fe200078e0212ULL,
0x0000760416137816ULL, 0x000fe40000000013ULL, 0x000054100a0a7816ULL, 0x000fe4000000000bULL,
0x00005410180b7816ULL, 0x000fca0000000013ULL, 0x0084000a12007388ULL, 0x0003e20000000a00ULL,
0x0000000000801947ULL, 0x000fea0003800000ULL, 0x00000010ff10723eULL, 0x000fe400048032ffULL,
0x00000007ff0a723eULL, 0x002fe400048032ffULL, 0x00000004ff077819ULL, 0x100fe40000011602ULL,
0x0000761010027816ULL, 0x000fe40000000002ULL, 0x00000006ff06723eULL, 0x000fe400048032ffULL,
0x0000000708087212ULL, 0x000fc400078e3cffULL, 0x000000ff02027812ULL, 0x000fe400078ec0ffULL,
0x0000ffff0a0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000807087824ULL, 0x000fe200078e0208ULL,
0x0000000eff0e723eULL, 0x000fe400048032ffULL, 0x0000000fff0f723eULL, 0x000fe200048032ffULL,
0x0000001008087824ULL, 0x000fe200078e0203ULL, 0x00007610060a7816ULL, 0x000fe4000000000aULL,
0x000076040b0b7816ULL, 0x000fe20000000002ULL, 0x0000000809087824ULL, 0x000fe200078e0208ULL,
0x00000005ff06723eULL, 0x000fc400048032ffULL, 0x0000000dff02723eULL, 0x000fe400048032ffULL,
0x00000004ff04723eULL, 0x000fe400048032ffULL, 0x000076100e057816ULL, 0x000fe40000000005ULL,
0x000076100f077816ULL, 0x000fe40000000007ULL, 0x000000ff05057812ULL, 0x000fe400078ec0ffULL,
0x0000ffff06067812ULL, 0x000fc400078ec0ffULL, 0x000000ff02027812ULL, 0x000fe400078ec0ffULL,
0x0000ffff040d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff07077812ULL, 0x000fe400078ec0ffULL,
0x0000ffff0a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000760406057816ULL, 0x000fe40000000005ULL,
0x000076040d027816ULL, 0x000fc40000000002ULL, 0x000076040a0a7816ULL, 0x000fe40000000007ULL,
0x0000541002047816ULL, 0x000fe40000000005ULL, 0x000054100a057816ULL, 0x000fca000000000bULL,
0x0084000408007388ULL, 0x0003e40000000a00ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0089a00c03ff79a7ULL, 0x0005e2000850003fULL, 0x0000001400cc7947ULL, 0x000fea0003800000ULL,
0x00009400ff067b82ULL, 0x000e640000000a00ULL, 0x0000001206067981ULL, 0x002362000c1e9900ULL,
0x000000070000780cULL, 0x000fe20003f04070ULL, 0x00000001ff047424ULL, 0x000fc800078e00ffULL,
0x0089d80403ff79a7ULL, 0x0003f0000850003fULL, 0xff800000ff028424ULL, 0x000fe200078e00ffULL,
0x0089e80403ff79a7ULL, 0x0003e2000850003fULL, 0x0089f80403ff79a7ULL, 0x0003e2000850003fULL,
0x008a080403ff79a7ULL, 0x0003e4000850003fULL, 0x008960020f008388ULL, 0x0003e80000000800ULL,
0x008980ff0f008388ULL, 0x0003e20000000800ULL, 0x008a1804030479a7ULL, 0x000ea4000850003fULL,
0x008a1805030075a7ULL, 0x004ea4000800017fULL, 0x0000003000f08947ULL, 0x006fea0003800000ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00000000000079c5ULL, 0x000fe20000000000ULL,
0x0000000f0e00728cULL, 0x000fcc000bf24070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000001400800947ULL, 0x000fea0003800000ULL, 0x00000000000c7919ULL, 0x000e620000000000ULL,
0x3b124925060e7820ULL, 0x020fe20000410000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0xffffffff0e0a7890ULL, 0x000fd8000fffe03fULL, 0x000000100d027824ULL, 0x040fe200078e00ffULL,
0x000000010d127812ULL, 0x000fe200078ec0ffULL, 0x00000040ff047424ULL, 0x000fe200078e00ffULL,
0x0000008000017945ULL, 0x000fe40003800000ULL, 0x0000001002027812ULL, 0x000fe200078ec0ffULL,
0x0000001012117824ULL, 0x000fc800078e0203ULL, 0x0000000103077824ULL, 0x000fe400078e0202ULL,
0x00000001ff027424ULL, 0x000fe400078e00ffULL, 0x0089d004070479a7ULL, 0x000ea4000800003fULL,
0x0089d005070075a7ULL, 0x004ea4000800017fULL, 0x0000003000a88947ULL, 0x004fea0003800000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0089f002110479a7ULL, 0x000ea2000850003fULL,
0x000000070c00780cULL, 0x002fe20003f24070ULL, 0x0000008000017945ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fd200078e00ffULL,
0x0000002012079824ULL, 0x100fe400078e0203ULL, 0x000000040c109824ULL, 0x040fe400078e0203ULL,
0x000000040c099824ULL, 0x000fe200078e0207ULL, 0x0089f005110075a7ULL, 0x004e64000800017fULL,
0x0000003000948947ULL, 0x002fea0003800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0088000009069984ULL, 0x000fe20000000800ULL, 0x000000ffff077224ULL, 0x000fe400078e00ffULL,
0x000000040c089824ULL, 0x000fe200078e0203ULL, 0x00896000100b9984ULL, 0x000e680000000800ULL,
0x0089800008079984ULL, 0x0004a20000000800ULL, 0x008a1802030479a7ULL, 0x0004a4000850003fULL,
0x000000060b00720bULL, 0x006fda0003f1e000ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00000000000a7806ULL, 0x000fc800040e0100ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x0000000000548947ULL, 0x000fea0003800000ULL, 0x800000060b0b7221ULL, 0x000fe20000010000ULL,
0x000000550aff7812ULL, 0x000fe2000784c0ffULL, 0x000000020c087824ULL, 0x000fe200078e00ffULL,
0x000000aa0aff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b0b0b7820ULL, 0x000fc60000410000ULL,
0x0000000608087812ULL, 0x000fc600078ec0ffULL, 0x0000000b000b7308ULL, 0x000e680000000800ULL,
0x000000000014a947ULL, 0x000fea0003800000ULL, 0x00001f080b097589ULL, 0x002e6400000e0000ULL,
0x000000091c1c7220ULL, 0x082fe20000410000ULL, 0x000000091e1e7220ULL, 0x080fe20000410000ULL,
0x0000000918187220ULL, 0x080fe20000410000ULL, 0x000000091a1a7220ULL, 0x000fce0000410000ULL,
0x000000000018b947ULL, 0x000fea0003800000ULL, 0x0000000108087836ULL, 0x000fcc0000000000ULL,
0x00001f080b087589ULL, 0x002e6400000e0000ULL, 0x000000081d1d7220ULL, 0x082fe20000410000ULL,
0x000000081f1f7220ULL, 0x080fe20000410000ULL, 0x0000000819197220ULL, 0x080fe20000410000ULL,
0x000000081b1b7220ULL, 0x000fce0000410000ULL, 0x0000000b07077220ULL, 0x002fce0000410000ULL,
0x0000006000017945ULL, 0x000fe20003800000ULL, 0x008a1805030075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x008a18050300a5a7ULL, 0x000e24000804007fULL, 0xfffffffc00eca947ULL, 0x001fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000005ff117819ULL, 0x000fe20000011600ULL,
0x000001c000017945ULL, 0x000fe60003800000ULL, 0x000000031100780cULL, 0x000fda0003f45270ULL,
0x0000000000642947ULL, 0x000fea0003800000ULL, 0x000000070c00780cULL, 0x000fe20004704470ULL,
0x0000008012059824ULL, 0x140fe400078e0203ULL, 0x000000ffff087224ULL, 0x000fe400078e00ffULL,
0x0000008012099824ULL, 0x000fe400078e0203ULL, 0x000000040c059824ULL, 0x000fe400078e0205ULL,
0x000000ffff047224ULL, 0x000fe400078e00ffULL, 0x0000008012139824ULL, 0x000fc400078e0203ULL,
0x000000040c0b8824ULL, 0x040fe400078e0203ULL, 0x000000040c109824ULL, 0x000fe400078e0209ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x008960060b008388ULL, 0x000fe20000000800ULL,
0x0000008012159824ULL, 0x000fe400078e0203ULL, 0x000000040c139824ULL, 0x000fe200078e0213ULL,
0x0088400005089984ULL, 0x000e620000000800ULL, 0x000000ffff097224ULL, 0x000fc400078e00ffULL,
0x000000040c159824ULL, 0x000fe200078e0215ULL, 0x0088600010049984ULL, 0x000ea80000000800ULL,
0x00888000130a9984ULL, 0x000ee80000000800ULL, 0x0088a00015099984ULL, 0x000f220000000800ULL,
0x0000000807077221ULL, 0x002fc80000010000ULL, 0x0000000407077221ULL, 0x004fe20000010000ULL,
0x000000040c049824ULL, 0x000fc600078e0203ULL, 0x0000000a070a7221ULL, 0x008fc80000010000ULL,
0x000000090a097221ULL, 0x010fca0000010000ULL, 0x0089800904009388ULL, 0x0003e40000000800ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x008a1802030479a7ULL, 0x002e62000850003fULL,
0x0000220012127824ULL, 0x000fe200078e0203ULL, 0x0000000400147811ULL, 0x000fe200078fd8ffULL,
0x000000b000017945ULL, 0x000fe40003800000ULL, 0x0000420012137836ULL, 0x000fca0000000000ULL,
0x0000000c13067211ULL, 0x000fc800078fc8ffULL, 0x0000000706067812ULL, 0x000fc800078ec0ffULL,
0x0000000611077212ULL, 0x080fe400078e3cffULL, 0x0000000614097212ULL, 0x000fc600078e3cffULL,
0x000000080c067824ULL, 0x040fe200078e0207ULL, 0x008a1805030075a7ULL, 0x002e62000800017fULL,
0x000000080c107824ULL, 0x000fe400078e0209ULL, 0x0000001006087824ULL, 0x000fe200078e0213ULL,
0x0000002c005c8947ULL, 0x002fec0003800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000001010047824ULL, 0x000fe200078e0213ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x000000000808783bULL, 0x000e620000004200ULL, 0x0000400012107836ULL, 0x040fe40000000000ULL,
0x0000402012127836ULL, 0x000fe20000000000ULL, 0x000000000404783bULL, 0x000ea20000004200ULL,
0x0000040010177824ULL, 0x040fe200078e00ffULL, 0x0003fff010157812ULL, 0x000fc400078ec0ffULL,
0x000001f010ff7812ULL, 0x000fe4000780c0ffULL, 0x00000004ff157819ULL, 0x000fe40000011615ULL,
0x000e000017177812ULL, 0x000fe400078ec0ffULL, 0x00003f0015167812ULL, 0x000fe400078ec0ffULL,
0x0003fff012127812ULL, 0x000fe400078ec0ffULL, 0x000000ff16167812ULL, 0x000fc400078ef815ULL,
0x00000004ff127819ULL, 0x000fe40000011612ULL, 0x0000624008247816ULL, 0x142fe40000000009ULL,
0x0000735108257816ULL, 0x000fe40000000009ULL, 0x8000002017087812ULL, 0x000fe400078efcffULL,
0x000062400a267816ULL, 0x140fe4000000000bULL, 0x000073510a277816ULL, 0x000fc4000000000bULL,
0x0000624004207816ULL, 0x144fe40000000005ULL, 0x0000735104217816ULL, 0x000fe20000000005ULL,
0x000000200c047836ULL, 0x000fe20000000000ULL, 0x0000624006227816ULL, 0x140fe40000000007ULL,
0x0000735106237816ULL, 0x000fe40000000007ULL, 0x8000002008177807ULL, 0x000fe40000000000ULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x00000000160672caULL, 0x000fc400000e0000ULL,
0x00000000170772caULL, 0x000fe400000e0000ULL, 0x0000000413057211ULL, 0x000fc800078fc8ffULL,
0x0000000705057812ULL, 0x000fc800078ec0ffULL, 0x0000000511077212ULL, 0x080fe400078e3cffULL,
0x0000000514057212ULL, 0x000fe200078e3cffULL, 0x00000004241c7df3ULL, 0x000fe2000870081cULL,
0x00000000160672caULL, 0x000fe200000e0000ULL, 0x0000000804067824ULL, 0x040fe200078e0207ULL,
0x00000000170772caULL, 0x000fe200000e0000ULL, 0x0000000804047824ULL, 0x000fe400078e0205ULL,
0x0000001006087824ULL, 0x100fe400078e0213ULL, 0x0000001004047824ULL, 0x000fe200078e0213ULL,
0x00003f0012137812ULL, 0x000fc800078ec0ffULL, 0x000000ff13167812ULL, 0x000fc600078ef812ULL,
0x0000000420187df3ULL, 0x000fe60008000818ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x000000000808783bULL, 0x000e680000004200ULL, 0x000000000404783bULL, 0x000ea20000004200ULL,
0x0000624008247816ULL, 0x002fc40000000009ULL, 0x0000735108257816ULL, 0x000fe40000000009ULL,
0x000062400a267816ULL, 0x140fe4000000000bULL, 0x000073510a277816ULL, 0x000fe4000000000bULL,
0x0000624004207816ULL, 0x144fe40000000005ULL, 0x0000735104217816ULL, 0x000fe20000000005ULL,
0x00000011ff047e24ULL, 0x000fe2000f8e00ffULL, 0x0000624006227816ULL, 0x000fc40000000007ULL,
0x0000735106237816ULL, 0x000fe20000000007ULL, 0xffffffff04047836ULL, 0x000fc60000000000ULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x00000000160672caULL, 0x000fe400000e0000ULL,
0x00000000170772caULL, 0x000fe400000e0000ULL, 0x000000040d00720cULL, 0x000fd60003f05270ULL,
0x00000004241c7df3ULL, 0x000fe2000870081cULL, 0x00000000160672caULL, 0x000fe400000e0000ULL,
0x00000000170772caULL, 0x000fda00000e0000ULL, 0x0000000420187df3ULL, 0x000fe60008000818ULL,
0x00008000000079c5ULL, 0x000fe40000010000ULL, 0x00000a4000017945ULL, 0x000fe80003800000ULL,
0x0000000800880947ULL, 0x000fea0003800000ULL, 0x008a1802030479a7ULL, 0x000e62000850003fULL,
0x000000080c067824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000006000027945ULL, 0x000fe60003800000ULL, 0x0000001806067812ULL, 0x000fe400078ec0ffULL,
0x000000070000780cULL, 0x000fc60004724470ULL, 0x0000000103077824ULL, 0x000fe200078e0206ULL,
0x008a1805030075a7ULL, 0x002e64000804017fULL, 0x000000280040a947ULL, 0x002fee0003800000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0089800007047984ULL, 0x000e620000000a00ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x0000920000087ab9ULL, 0x000fe20000000800ULL,
0x00000004100972a4ULL, 0x000fe2000f8e020cULL, 0x008960000f099984ULL, 0x000fe20000000800ULL,
0x00000004140472a4ULL, 0x000fe2000f8e023fULL, 0x000002b000027945ULL, 0x000fe20003800000ULL,
0x00000014090772a4ULL, 0x000fe2000f8e0215ULL, 0x008980000f089984ULL, 0x000ea20000000800ULL,
0x0000000604067899ULL, 0x000fe4000800063fULL, 0x0000000309097899ULL, 0x000fc4000800063fULL,
0x000007ff060674a4ULL, 0x000fe2000f8e0208ULL, 0x00000007ff157e24ULL, 0x000fe2000f8e00ffULL,
0x0000c20000047ab9ULL, 0x000fe40000000a00ULL, 0x0000000706067291ULL, 0x000fe2000f8fa83fULL,
0x00000004ff0a7e24ULL, 0x000fe4000f8e00ffULL, 0x00000005ff0b7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000306087899ULL, 0x000fe2000800063fULL, 0x0000000815159824ULL, 0x000fe400078e0200ULL,
0x0000860000067ab9ULL, 0x000fe20000000a00ULL, 0x00000100080478a5ULL, 0x000fe2000f8e0004ULL,
0x0000000815149825ULL, 0x000fe200078e000aULL, 0x00000100090678a5ULL, 0x000fc8000f8e0006ULL,
0x0000000604087287ULL, 0x000fe40008000000ULL, 0x00000004ff127e24ULL, 0x000fe2000f8e00ffULL,
0x0000000705067287ULL, 0x000fe40008000000ULL, 0x00000005ff0b7e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff137e24ULL, 0x000fe4000f8e00ffULL, 0x00000004ff0a7e24ULL, 0x000fe4000f8e00ffULL,
0x0180000004077836ULL, 0x002fc40000000000ULL, 0x00000008ff0a7e24ULL, 0x000fe4000f8e00ffULL,
0x00000006ff137e24ULL, 0x000fe2000f8e00ffULL, 0x7f80000007077812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0a9224ULL, 0x000fe400078e0012ULL, 0x000000ffff139224ULL, 0x000fe200078e000bULL,
0x01ffffff0700780cULL, 0x000fe20003f44070ULL, 0x0000000814009986ULL, 0x0043e4000c101b12ULL,
0x000000ffff087224ULL, 0x002fc400078e000aULL, 0x000000ffff097224ULL, 0x000fd000078e0013ULL,
0x0000000000142947ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0004ULL,
0x0000256000127802ULL, 0x000fce0000000f00ULL, 0x0000002800b07944ULL, 0x001fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0004ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000400077308ULL, 0x000e640000001000ULL, 0xbf800000040a7423ULL, 0x002fc80000000007ULL,
0x800000ff0a0a7221ULL, 0x000fc80000010100ULL, 0x0000000a07077223ULL, 0x000fce0000000007ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0180000005047836ULL, 0x000fe20000000000ULL,
0x000000d000027945ULL, 0x000fe80003800000ULL, 0x7f80000004047812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0400780cULL, 0x000fda0003f24070ULL, 0x0000000000141947ULL, 0x000fea0003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0005ULL, 0x0000265000127802ULL, 0x000fce0000000f00ULL,
0x0000002800747944ULL, 0x001fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e0004ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000500047308ULL, 0x000e640000001000ULL,
0xbf800000050a7423ULL, 0x002fc80000000004ULL, 0x800000ff0a0b7221ULL, 0x000fc80000010100ULL,
0x0000000b040b7223ULL, 0x000fce0000000004ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x000000070e077220ULL, 0x040fe20000410000ULL, 0x0000000b0e047220ULL, 0x000fe20000410000ULL,
0x00000040110b7811ULL, 0x000fe400078e20ffULL, 0x000000071c1c7220ULL, 0x080fe20000410000ULL,
0x000000041d1d7220ULL, 0x080fe20000410000ULL, 0x000000071e1e7220ULL, 0x080fe20000410000ULL,
0x000000041f1f7220ULL, 0x080fe20000410000ULL, 0x0000000718187220ULL, 0x080fe20000410000ULL,
0x0000000419197220ULL, 0x080fe20000410000ULL, 0x000000071a1a7220ULL, 0x000fe20000410000ULL,
0x000000041b1b7220ULL, 0x000fe20000410000ULL, 0x0000001c1d05723eULL, 0x000fc400000000ffULL,
0x0000001e1f0a723eULL, 0x000fe400000000ffULL, 0x000000181907723eULL, 0x000fe400000000ffULL,
0x0000001a1b12723eULL, 0x000fe200000000ffULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x000000000505723aULL, 0x000fe20000000000ULL, 0x00000002ff047819ULL, 0x000fc4000001160cULL,
0x00000004ff0b7819ULL, 0x000fe2000001160bULL, 0x000000000a0a723aULL, 0x000e620000000000ULL,
0x0000000311117812ULL, 0x000fe400078e7804ULL, 0x000000030b0b7812ULL, 0x000fe200078e7804ULL,
0x000000000707723aULL, 0x000fe20000000000ULL, 0x00000004ff137819ULL, 0x000fe20000011600ULL,
0x0000000804117824ULL, 0x040fe400078e0211ULL, 0x000000001212723aULL, 0x000ea20000000000ULL,
0x00000008040b7824ULL, 0x000fe200078e020bULL, 0x0000016000027945ULL, 0x000fe20003800000ULL,
0x0000002011117824ULL, 0x000fc400078e0210ULL, 0x000000200b0b7824ULL, 0x000fe400078e0210ULL,
0x0000000106117824ULL, 0x040fe400078e0211ULL, 0x00000001060b7824ULL, 0x000fe200078e020bULL,
0x0000541005047816ULL, 0x142fe4000000000aULL, 0x0000763205057816ULL, 0x000fe4000000000aULL,
0x0000000e000a7812ULL, 0x000fc600078ec0ffULL, 0x0000000411007388ULL, 0x0003e20000000a00ULL,
0x0000541007147816ULL, 0x144fe40000000012ULL, 0x0000763207157816ULL, 0x000fe20000000012ULL,
0x0000001000127824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fc6000001160aULL,
0x000000140b007388ULL, 0x0005e20000000a00ULL, 0x008a1802030679a7ULL, 0x000ee2000850003fULL,
0x000000030a0a7812ULL, 0x000fe400078e7813ULL, 0x0000001012047812ULL, 0x002fc600078ec0ffULL,
0x0000000813057824ULL, 0x000fc800078e020aULL, 0x0000002005057824ULL, 0x000fc800078e0210ULL,
0x0000000105047824ULL, 0x000fe200078e0204ULL, 0x008a1807030075a7ULL, 0x008e64000802017fULL,
0x00000020008c9947ULL, 0x006fea0003800000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000004047984ULL, 0x000e620000000c00ULL, 0x0000010013087825ULL, 0x000fe200078e0008ULL,
0x000000f0120b7812ULL, 0x000fe200078ec0ffULL, 0x0000008000027945ULL, 0x000fe20003800000ULL,
0x000000ff0000720cULL, 0x000fe40004705670ULL, 0x0000000b080a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fca00008e0609ULL, 0x000000040a007986ULL, 0x0023e2000c101d12ULL,
0x008a1802030879a7ULL, 0x000ea4000850003fULL, 0x008a1809030075a7ULL, 0x004ea4000802017fULL,
0x0000002000749947ULL, 0x006fea0003800000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000000600947ULL, 0x000fea0003800000ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x0000000aff077e24ULL, 0x000fe2000f8e00ffULL, 0x00000004100672a4ULL, 0x000fc6000f8e020cULL,
0x0000c00000047ab9ULL, 0x000fe40000000a00ULL, 0x00000004060478a5ULL, 0x000fcc000f8e0004ULL,
0x00000004ff047e24ULL, 0x000fe4000f8e00ffULL, 0x00000005ff057e24ULL, 0x000fe2000f8e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x0003ec0000008000ULL, 0x0000000000007992ULL, 0x002fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000007040479a8ULL, 0x000ea800099ee1d2ULL, 0x00000000ff00798fULL, 0x004fe20002000000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fc40000000000ULL,
0x0000065405047896ULL, 0x002fcc0008000004ULL, 0x00000004ff037e24ULL, 0x000fe2000f8e00ffULL,
0x0000000a04007c0cULL, 0x000fc8000bf05270ULL, 0x00000001ff067807ULL, 0x000fca0000000000ULL,
0x008a200603007388ULL, 0x0003e80000000000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000010d047812ULL, 0x040fe200078ec0ffULL, 0x000000010d0d7836ULL, 0x000fc80000000000ULL,
0x0000001004057824ULL, 0x000fe200078e0203ULL, 0x000000110d007c0cULL, 0x000fc6000bf06070ULL,
0x0089f80205ff79a7ULL, 0x0005e2000850003fULL, 0x0089d80205ff79a7ULL, 0x0005f2000850003fULL,
0xffffffe800a08947ULL, 0x007fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000c00a07947ULL, 0x000fea0003800000ULL, 0x00009400ff067b82ULL, 0x000e640000000a00ULL,
0x0000001206067981ULL, 0x002362000c1e9900ULL, 0x000000070000780cULL, 0x000fe20003f04070ULL,
0x00000001ff027424ULL, 0x000fc800078e00ffULL, 0x0089a80203ff79a7ULL, 0x0003f0000850003fULL,
0xff317217ff0a8424ULL, 0x000fe200078e00ffULL, 0x0089b80203ff79a7ULL, 0x0003e2000850003fULL,
0x0089c80203ff79a7ULL, 0x0003e6000850003fULL, 0x0089400a0f008388ULL, 0x0003e20000000800ULL,
0x008a1002030479a7ULL, 0x000ea4000850003fULL, 0x008a1005030075a7ULL, 0x004ea4000800017fULL,
0x0000001c00cc8947ULL, 0x006fea0003800000ULL, 0x0089a002030479a7ULL, 0x000e64000850003fULL,
0x0089a005030075a7ULL, 0x002e64000800017fULL, 0x0000001c00d88947ULL, 0x002fea0003800000ULL,
0x0000000f0e00728cULL, 0x000fe2000bf24070ULL, 0x00000005ff0d7819ULL, 0x000fca0000011600ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000c00500947ULL, 0x000fea0003800000ULL,
0x00000000000c7919ULL, 0x000e620000000000ULL, 0x000000100d097824ULL, 0x000fe400078e00ffULL,
0x3db504f3060b7820ULL, 0x020fe20000410000ULL, 0x000000ffff0a7224ULL, 0x000fe400078e00ffULL,
0x000000090c097211ULL, 0x002fce00078ff0ffULL, 0x00000017ff057e24ULL, 0x000fe2000f8e00ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000e0a067c24ULL, 0x000fce000f8e0205ULL,
0x000000100a047824ULL, 0x000fe200078e00ffULL, 0x00000000000079c5ULL, 0x000fe20000000000ULL,
0x00000040ff0e7424ULL, 0x000fe200078e00ffULL, 0x00000000030672caULL, 0x040fe400000e0000ULL,
0x0000001004047812ULL, 0x000fe400078ec0ffULL, 0x00000000030972caULL, 0x000fc600000e0000ULL,
0x0000000103077824ULL, 0x000fc800078e0204ULL, 0x0089b00e070479a7ULL, 0x0002a4000800003fULL,
0x0000000a06057899ULL, 0x000fe4000800063fULL, 0x000003ff063f7892ULL, 0x000fe4000f82c03fULL,
0x0000840009047890ULL, 0x000fe4000fffe03fULL, 0x000e000005077892ULL, 0x000fe2000f8ec03fULL,
0x000000010a0e7812ULL, 0x002fe200078ec0ffULL, 0x000003ff043f7892ULL, 0x000fc4000f84c03fULL,
0x0000000a04067899ULL, 0x000fe4000800063fULL, 0x000020000e0f7824ULL, 0x000fe200078e0203ULL,
0x0003fff004057892ULL, 0x000fe4000f8ec03fULL, 0x0000003f07077287ULL, 0x000fe40008800000ULL,
0x000000000f0872caULL, 0x000fe200000e0000ULL, 0x000e000006067892ULL, 0x000fe4000f8ec03fULL,
0x000000043f0a7899ULL, 0x000fe20008011605ULL, 0x0089b005070075a7ULL, 0x004e62000800017fULL,
0x4000004007057892ULL, 0x000fc4000f8efc3fULL, 0x0000003f06077287ULL, 0x000fe40009000000ULL,
0x00003f000a0b7892ULL, 0x000fe4000f8ec03fULL, 0x4000004007077892ULL, 0x000fe4000f8efc3fULL,
0x0003fff008047892ULL, 0x000fe4000f8ec03fULL, 0x000000ff0b0b7892ULL, 0x000fe4000f8ef80aULL,
0x000000043f047899ULL, 0x000fc80008011604ULL, 0x00003f0004067892ULL, 0x000fc8000f8ec03fULL,
0x000000ff06047892ULL, 0x000fe2000f8ef804ULL, 0x0000001c00408947ULL, 0x002ff60003800000ULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x0000000b00067c82ULL, 0x000fe20008000000ULL,
0x0000000106047836ULL, 0x000fe40000000000ULL, 0x000000100e0f7824ULL, 0x000fe400078e0203ULL,
0x00000000041879f3ULL, 0x000fe2000c7008ffULL, 0x0000842009067890ULL, 0x000fe2000fffe03fULL,
0x0000001604007c0cULL, 0x000fe2000bf05270ULL, 0x0000002008047890ULL, 0x000fe4000fffe03fULL,
0x0003fff006067892ULL, 0x000fc4000f8ec03fULL, 0x0003fff004047892ULL, 0x000fe4000f8ec03fULL,
0x000000043f0a7899ULL, 0x000fe40008011606ULL, 0x000000043f047899ULL, 0x000fe40008011604ULL,
0x00003f000a0b7892ULL, 0x000fe4000f8ec03fULL, 0x00003f0004067892ULL, 0x000fe4000f8ec03fULL,
0x000000ff0b0b7892ULL, 0x000fc4000f8ef80aULL, 0x000000ff06047892ULL, 0x000fca000f8ef804ULL,
0x0000000b00067c82ULL, 0x000fc80008000000ULL, 0x00000000041879f3ULL, 0x000fe20008700818ULL,
0x0000844009067890ULL, 0x000fe4000fffe03fULL, 0x0000004008047890ULL, 0x000fe4000fffe03fULL,
0x0003fff006067892ULL, 0x000fe4000f8ec03fULL, 0x0003fff004047892ULL, 0x000fe4000f8ec03fULL,
0x000000043f0a7899ULL, 0x000fe40008011606ULL, 0x000000043f047899ULL, 0x000fc40008011604ULL,
0x00003f000a0b7892ULL, 0x000fe4000f8ec03fULL, 0x00003f0004067892ULL, 0x000fe4000f8ec03fULL,
0x000000ff0b0b7892ULL, 0x000fe4000f8ef80aULL, 0x000000ff06047892ULL, 0x000fe4000f8ef804ULL,
0x0000846009097890ULL, 0x000fe4000fffe03fULL, 0x0000006008087890ULL, 0x000fe2000fffe03fULL,
0x0000000b00067c82ULL, 0x000fe20008000000ULL, 0x0003fff009097892ULL, 0x000fc4000f8ec03fULL,
0x0003fff008087892ULL, 0x000fe4000f8ec03fULL, 0x000000043f097899ULL, 0x000fe40008011609ULL,
0x000000043f087899ULL, 0x000fe20008011608ULL, 0x00000000041879f3ULL, 0x000fe20008700818ULL,
0x00003f0009067892ULL, 0x000fe4000f8ec03fULL, 0x00003f0008047892ULL, 0x000fe4000f8ec03fULL,
0x000000ff06067892ULL, 0x000fc4000f8ef809ULL, 0x000000ff04047892ULL, 0x000fd2000f8ef808ULL,
0x00000000041879f3ULL, 0x000fe60008000818ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x0089b8020fff79a7ULL, 0x0003e2000850003fULL, 0x0000000b18187220ULL, 0x080fe20000410000ULL,
0x0000000b19197220ULL, 0x080fe20000410000ULL, 0x0000000b1a117220ULL, 0x080fe20000410000ULL,
0x0000000b1b107220ULL, 0x000fe20000410000ULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x0000004006057824ULL, 0x000fca00078e00ffULL, 0x0000000508047248ULL, 0x000fca0007fe0000ULL,
0x0000000104047824ULL, 0x000fe400078e0a05ULL, 0x0000000809057836ULL, 0x000fc60000000000ULL,
0x000000040900720cULL, 0x080fe40003f06070ULL, 0x000000040500720cULL, 0x000fe40003f26070ULL,
0xff80000018187808ULL, 0x000fe40004000000ULL, 0xff80000019197808ULL, 0x000fe40004000000ULL,
0xff80000011117808ULL, 0x000fe40004800000ULL, 0xff80000010107808ULL, 0x000fce0004800000ULL,
0x0000001811047209ULL, 0x000fe20007810000ULL, 0x000000010a0a7836ULL, 0x000fe20000000000ULL,
0x0000001910067209ULL, 0x000fe20007810000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000000030c00780cULL, 0x000fe20003f04070ULL, 0x0e001f0004057f89ULL, 0x000ea200000e0000ULL,
0x000000110a007c0cULL, 0x000fc6000bf26070ULL, 0x0e001f0006077f89ULL, 0x000ee200000e0000ULL,
0x0000000504057209ULL, 0x004fe40007810000ULL, 0x0000000706077209ULL, 0x008fc60007810000ULL,
0x0d001f0005127f89ULL, 0x000ea800000e0000ULL, 0x0d001f0007147f89ULL, 0x000ee200000e0000ULL,
0x0000001205127209ULL, 0x004fe40007810000ULL, 0x0000001407147209ULL, 0x008fc60007810000ULL,
0x0c801f0012137f89ULL, 0x000ea800000e0000ULL, 0x0c801f0014157f89ULL, 0x000ee200000e0000ULL,
0x0000001312137209ULL, 0x004fe40007810000ULL, 0x0000001514157209ULL, 0x008fe20007810000ULL,
0x0000000000340947ULL, 0x000fec0003800000ULL, 0x000000ff1300720bULL, 0x000fe20003f56000ULL,
0x0000006000017945ULL, 0x000fe20003800000ULL, 0x000000080c047824ULL, 0x000fd600078e0203ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x0089401304ff738cULL, 0x0005e20001000200ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0089401304ff738cULL, 0x0005e40000800000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff1500720bULL, 0x000fda0003f56000ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x0089441504ff738cULL, 0x0007e20001000200ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0089441504ff738cULL, 0x0007e40000800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x008a1002030479a7ULL, 0x00cea2000850003fULL,
0x000000080c127824ULL, 0x000fca00078e00ffULL, 0x0000001812067812ULL, 0x000fca00078ec0ffULL,
0x0000000103167824ULL, 0x000fe200078e0206ULL, 0x008a1005030075a7ULL, 0x004ea4000804017fULL,
0x0000001400d4a947ULL, 0x004fea0003800000ULL, 0x0089400016047984ULL, 0x000ea20000000a00ULL,
0x008a1002030679a7ULL, 0x000ee4000850003fULL, 0x008a1007030075a7ULL, 0x008ee2000804017fULL,
0x3fb8aa3b04147820ULL, 0x004fe20000410000ULL, 0x3fb8aa3b05157820ULL, 0x000fc60000410000ULL,
0x3fb8aa3b18137823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b11147823ULL, 0x000fe20000010814ULL,
0x3fb8aa3b19117823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b10107823ULL, 0x000fc60000010815ULL,
0x0000001300137308ULL, 0x000ff00000000800ULL, 0x0000001400147308ULL, 0x000eb00000000800ULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x0000001413177221ULL, 0x004fce0000010000ULL,
0x0000001000107308ULL, 0x000ea40000000800ULL, 0x0000001011197221ULL, 0x004fc20000010000ULL,
0x0000001400aca947ULL, 0x008fec0003800000ULL, 0x0e001f0017067f89ULL, 0x000ea200000e0000ULL,
0x000000070c00780cULL, 0x000fe20003f44070ULL, 0x000001a000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1a7224ULL, 0x000fe200078e00ffULL, 0x0e001f0019167f89ULL, 0x000ee200000e0000ULL,
0x0000000617067221ULL, 0x004fc20000010000ULL, 0x0000001619077221ULL, 0x008fc80000010000ULL,
0x0d001f0006157f89ULL, 0x000ea800000e0000ULL, 0x0d001f0007167f89ULL, 0x000ee200000e0000ULL,
0x0000001506157221ULL, 0x004fc20000010000ULL, 0x0000001607167221ULL, 0x008fc80000010000ULL,
0x0c801f0015187f89ULL, 0x0004e800000e0000ULL, 0x0c801f0016177f89ULL, 0x00052200000e0000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000001c7919ULL, 0x000f620000003000ULL,
0x00000001ff077819ULL, 0x000fe2000001160cULL, 0x000000040c197824ULL, 0x040fe200078e00ffULL,
0x000000060c067812ULL, 0x000fe400078ec0ffULL, 0x7ffffffc071a7812ULL, 0x000fe400078ec0ffULL,
0x00000001ff077819ULL, 0x000fc60000011606ULL, 0x000000010d1a7824ULL, 0x000fca00078e021aULL,
0x000000071a077212ULL, 0x000fe200078e3cffULL, 0x00000001031b7824ULL, 0x020fe200078e021cULL,
0x0000001c191c7812ULL, 0x000fc600078ec0ffULL, 0x000022000e067824ULL, 0x000fe400078e021bULL,
0x0000000107077824ULL, 0x000fc800078e021cULL, 0x0000001007067824ULL, 0x000fc800078e0206ULL,
0x00004000061a7836ULL, 0x000fce0000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0089f8020f0679a7ULL, 0x000f64000850003fULL, 0x0089f8070f0075a7ULL, 0x020f64000804017fULL,
0x000000140044a947ULL, 0x020fea0003800000ULL, 0x00000000000479c3ULL, 0x000f620000003000ULL,
0x43e0000013137820ULL, 0x000fe20000410000ULL, 0x43e0000014147820ULL, 0x000fe20000410000ULL,
0x43e0000011117820ULL, 0x000fe20000410000ULL, 0x43e0000010107820ULL, 0x000fe20000410000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000001815187221ULL, 0x008fc20000010000ULL,
0x000000131413723eULL, 0x000fe20004807113ULL, 0x0000001716177221ULL, 0x010fc20000010000ULL,
0x000000111010723eULL, 0x000fc80004807110ULL, 0x0000541013137816ULL, 0x000fe20000000010ULL,
0x800000041a067c36ULL, 0x020fca0008000000ULL, 0x0000001306007844ULL, 0x0007e20000004000ULL,
0x0000000000280947ULL, 0x000fea0003800000ULL, 0x000000ff0d00720cULL, 0x040fe20003f05270ULL,
0x000000800e067824ULL, 0x148fe400078e0203ULL, 0x000000200e077824ULL, 0x000fe400078e0203ULL,
0x000000200d117824ULL, 0x000fe400078e0206ULL, 0x0000000112077824ULL, 0x000fe400078e0207ULL,
0x000000080c117824ULL, 0x000fc800078e0211ULL, 0x0088000407008388ULL, 0x0007e80000000800ULL,
0x0088401811007388ULL, 0x0007e80000000800ULL, 0x0088040507008388ULL, 0x0007e80000000800ULL,
0x0088441711007388ULL, 0x0007e40000000800ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0089f0020fff79a7ULL, 0x0009e4000850003fULL, 0xfffffff000c49947ULL, 0x01ffea000383ffffULL,
0x0089a80203ff79a7ULL, 0x0003e4000850003fULL, 0x0000000000047919ULL, 0x002e620000002300ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000783f047890ULL, 0x000fe2000ff3e03fULL, 0x000000000000781cULL, 0x000fc60003f2f008ULL,
0x0000003f3f057290ULL, 0x000fe20008ffe43fULL, 0x0000010000067ab9ULL, 0x000fe20000000800ULL,
0x0000000000077919ULL, 0x000e640000002200ULL, 0x0000000304047899ULL, 0x000fc60008001205ULL,
0x0000000000057ab9ULL, 0x000fe20000000800ULL, 0x0000000104047890ULL, 0x000fe2000fffe03fULL,
0x0000000604057c24ULL, 0x002fc8000f8e0207ULL, 0x0000000505027c24ULL, 0x000fca000f8e0200ULL,
0x0000000402007c0cULL, 0x000fda000bf06070ULL, 0x0000000802038824ULL, 0x004fc800078e0203ULL,
0x0089a000030089b1ULL, 0x0002a4000800003fULL, 0x000000000000994dULL, 0x004fea0003800000ULL,
0x00000000000479c3ULL, 0x000ee20000008800ULL, 0x0000040000057882ULL, 0x000fe40000000000ULL,
0x0000065404057896ULL, 0x008fd20008000005ULL, 0x008a2005ff037984ULL, 0x006e640008000000ULL,
0x000000ff0300720cULL, 0x002fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000407ff7212ULL, 0x000fc8000784fcffULL,
0x000000040000780cULL, 0x000fda0005741070ULL, 0x00000000005ca947ULL, 0x000fea0003800000ULL,
0x0000000500037c11ULL, 0x000fe2000f8e20ffULL, 0x001ffffe00067882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x7ffff80000077882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x00000000030412caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x00210006043f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x001ffe0000067882ULL, 0x002fe20000000000ULL,
0x7ff8000000077882ULL, 0x000fd60000000000ULL, 0x00000000030412caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x00210806043f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x00000100ff047424ULL, 0x000fc800078e00ffULL,
0x0021080403ff79a7ULL, 0x0045e6000850003fULL, 0x00000005ff027819ULL, 0x000fe20000011602ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001fff02027589ULL, 0x000ee400000e0000ULL,
0x00000000020672caULL, 0x00afe200000e0000ULL, 0x0000000000007b1dULL, 0x000fd80000010000ULL,
0x000000080600788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000400108947ULL, 0x000fea0003800000ULL, 0x0000000b060e7890ULL, 0x000fc8000fffe10eULL,
0x000000023f0e7899ULL, 0x000fcc000801160eULL, 0x0000000eff007c0cULL, 0x000fda000bf05270ULL,
0x00000008005c8947ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x000e620000000000ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x00009200000a7ab9ULL, 0x000fe20000000800ULL,
0x00000004140772a4ULL, 0x000fe4000f8e023fULL, 0x00000004100872a4ULL, 0x000fe4000f8e020cULL,
0x0000000607077899ULL, 0x000fe4000800063fULL, 0xfffffff806097890ULL, 0x000fe4000fffe03fULL,
0x00000014080872a4ULL, 0x000fc4000f8e023fULL, 0x000007ff070d74a4ULL, 0x000fe2000f8e020aULL,
0x0000003f00047c82ULL, 0x000fd60008000000ULL, 0x0000000904067291ULL, 0x000fe2000f8e103fULL,
0x000000070700780cULL, 0x042fe20003f24070ULL, 0x0000000104047890ULL, 0x000fe2000fffe03fULL,
0x000000ff0700720cULL, 0x000fe20003f05270ULL, 0x0000000406077892ULL, 0x000fe4000f8ec03fULL,
0x00000004060a7899ULL, 0x000fe4000800063fULL, 0x000000023f077899ULL, 0x000fe40008011607ULL,
0x000000300a0a7892ULL, 0x000fc4000f8ec03fULL, 0x0000001f07077899ULL, 0x000fe4000800063fULL,
0x0000000e0400728cULL, 0x000fe4000bf06070ULL, 0x0000000aff037e24ULL, 0x004fe2000f8e00ffULL,
0x00000006080f7290ULL, 0x000fe2000fffe03fULL, 0x00000007ff027e24ULL, 0x000fe2000f8e00ffULL,
0x00000003060b7892ULL, 0x000fe4000f8ec03fULL, 0x0000000a050a7290ULL, 0x000fe4000fffe03fULL,
0x00210802030075a7ULL, 0x000e640008060145ULL, 0x0000000c0088b947ULL, 0x002ff00003800000ULL,
0x0000013000007945ULL, 0x000fe80003800000ULL, 0x0000000000441947ULL, 0x000fea0003800000ULL,
0x0000c20000067ab9ULL, 0x000fe20000000a00ULL, 0x000000050b0a7291ULL, 0x000fe4000f8e303fULL,
0x000000400f0678a5ULL, 0x000fc8000f8e0006ULL, 0x0000000a07057c11ULL, 0x040fe4000f8e18ffULL,
0x00000006ff027e24ULL, 0x000fe2000f8e00ffULL, 0x000000050b067291ULL, 0x000fe2000f8e203fULL,
0x00000007ff037e24ULL, 0x000fe4000f8e00ffULL, 0x0000000807027825ULL, 0x000fca00078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0200000002057faeULL, 0x0003e2000b921a52ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000210006067890ULL, 0x000fd2000fffe03fULL,
0x000000ffffff79a7ULL, 0x000fe20008200406ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a86ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000d000007945ULL, 0x000fe80003800000ULL, 0x00000000002c0947ULL, 0x000fea0003800000ULL,
0x0000000f0d0a7291ULL, 0x000fe2000f8fa83fULL, 0x00000800ff027424ULL, 0x000fe200078e00ffULL,
0x000000050b117291ULL, 0x000fe2000f8e203fULL, 0x0000c20000067ab9ULL, 0x000fe20000000a00ULL,
0x000000050b167291ULL, 0x000fe4000f8e583fULL, 0x000008000a0678a5ULL, 0x000fe4000f8e0006ULL,
0x0000210011177890ULL, 0x000fe2000fffe03fULL, 0x00000080000a7882ULL, 0x000fd00000000000ULL,
0x00000016060073baULL, 0x0003e2000800020aULL, 0x00210002ffff79a7ULL, 0x0003e40008000011ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0xfffffffc002c8947ULL, 0x021fea000383ffffULL,
0x00000004005c7947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x004e620000000000ULL,
0x0000000eff007c0cULL, 0x000fda000bf05270ULL, 0x0000000000f48947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0xff317217ff067424ULL, 0x020fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff057224ULL, 0x000fe400078e00ffULL, 0x000000ffff0a7224ULL, 0x000fce00078e00ffULL,
0x0000000404077892ULL, 0x000fe4000f8ec03fULL, 0x0000000404087899ULL, 0x000fe4000800063fULL,
0x000000023f077899ULL, 0x000fe40008011607ULL, 0x0000003008087892ULL, 0x000fe4000f8ec03fULL,
0x0000001f070a7899ULL, 0x000fe4000800063fULL, 0x00000003040b7892ULL, 0x000fc4000f8ec03fULL,
0x00000008ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000000805087290ULL, 0x000fe2000fffe03fULL,
0x0000000aff027e24ULL, 0x000fe2000f8e00ffULL, 0x000000050b097291ULL, 0x000fe4000f8e583fULL,
0x000000050b077291ULL, 0x000fe4000f8e303fULL, 0x00210002030075a7ULL, 0x000ea20008000145ULL,
0x0000000906097291ULL, 0x000fe4000f8e403fULL, 0x0000000706077291ULL, 0x000fc8000f8e183fULL,
0x00000009040b7c11ULL, 0x002fe2000f8e18ffULL, 0x0000000800b48947ULL, 0x004fee0003800000ULL,
0x00200007ff027984ULL, 0x000e620008000a00ULL, 0x0000000104047890ULL, 0x000fc6000fffe03fULL,
0x000000000b0c7984ULL, 0x000ea20000000a00ULL, 0x0000000e0400728cULL, 0x000fe2000bf06070ULL,
0x000000060300720bULL, 0x002fe20003f14000ULL, 0x2000000cff0f7230ULL, 0x004fe40000004100ULL,
0x3000000cff0c7230ULL, 0x000fe40000004100ULL, 0x2000000dff117230ULL, 0x000fe40000004100ULL,
0x3000000dff0e7230ULL, 0x000fcc0000004100ULL, 0x0000000000280947ULL, 0x000fea0003800000ULL,
0x0000000306037221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b03037820ULL, 0x000fcc0000410000ULL,
0x0000000300037308ULL, 0x000e640000000800ULL, 0x0000000302027220ULL, 0x002fc80000410000ULL,
0x000000020f0a7223ULL, 0x080fe2000001000aULL, 0x000000020c097223ULL, 0x080fe20000010009ULL,
0x0000000211087223ULL, 0x080fe20000010008ULL, 0x000000020e057223ULL, 0x000fe20000010005ULL,
0x0000000702077221ULL, 0x000fe20000010000ULL, 0x0000000000347947ULL, 0x000fec0003800000ULL,
0x8000000306067221ULL, 0x000fe20000010000ULL, 0x0000000f020d7220ULL, 0x040fe20000410000ULL,
0x00000011020f7220ULL, 0x000fe40000410000ULL, 0x3fb8aa3b060b7820ULL, 0x000fe20000410000ULL,
0x0000000c02067220ULL, 0x040fe20000410000ULL, 0x0000000e020c7220ULL, 0x000fc80000410000ULL,
0x0000000b000b7308ULL, 0x000e640000000800ULL, 0x000000090b097223ULL, 0x042fe20000010006ULL,
0x000000070b077223ULL, 0x040fe20000010002ULL, 0x0000000a0b0a7223ULL, 0x040fe2000001000dULL,
0x000000080b087223ULL, 0x040fe2000001000fULL, 0x000000050b057223ULL, 0x000fe2000001000cULL,
0x000000ffff067224ULL, 0x000fce00078e0003ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000000050b077291ULL, 0x000fe2000f8e203fULL, 0x00000001ff027424ULL, 0x000fd000078e00ffULL,
0x00210802ffff79a7ULL, 0x0003e60008500007ULL, 0xfffffffc00288947ULL, 0x003fea000383ffffULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x000000ffff057224ULL, 0x000fe400078e00ffULL,
0x000000ffff0a7224ULL, 0x000fce00078e00ffULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x0000000700077308ULL, 0x000ea20000001000ULL, 0x00000004100472a4ULL, 0x000fe2000f8e020cULL,
0x0000860000087ab9ULL, 0x000fc60000000a00ULL, 0x0000000604067291ULL, 0x000fc8000f80183fULL,
0x0000003f3f077290ULL, 0x000fe400087fe43fULL, 0x0000000806047291ULL, 0x000fc8000f80403fULL,
0x0000000906067291ULL, 0x000fe200080f4407ULL, 0x0000000a070a7220ULL, 0x044fe20000410000ULL,
0x0000000907097220ULL, 0x040fe20000410000ULL, 0x0000000807087220ULL, 0x040fe20000410000ULL,
0x0000000507057220ULL, 0x000fe20000410000ULL, 0x00000004ff027e24ULL, 0x000fe4000f8e00ffULL,
0x00000006ff037e24ULL, 0x000fe4000f8e00ffULL, 0x0000000404077824ULL, 0x002fe200078e00ffULL,
0x0000000a0904723eULL, 0x000fc400000000ffULL, 0x000000080505723eULL, 0x000fe200000000ffULL,
0x0000000207027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x0003e4000c101b12ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000000000a94dULL, 0x000fea0003800000ULL,
0x0000000500007c11ULL, 0x000fc8000f8e20ffULL, 0x00210800000079b1ULL, 0x000e24000800003fULL,
0x00210000000079b1ULL, 0x001fe2000800003fULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0089d8070b0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x0089d8070b0085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffc000147947ULL, 0x021fea000383ffffULL,
0x0089b8070b0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x0089b8070b0085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffc000b47947ULL, 0x021fea000383ffffULL,
0x0089a80f030075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x0089a80f030085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffc400387947ULL, 0x021fea000383ffffULL,
0x008a1805030075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x008a1805030085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffc800f87947ULL, 0x021fea000383ffffULL,
0x0089d005070075a7ULL, 0x0004a2000800017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x0089d005070085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffcc00407947ULL, 0x003fea000383ffffULL,
0x0089f005110075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x0089f005110085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffcc00547947ULL, 0x001fea000383ffffULL,
0x008a1805030075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x008a1805030085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffd0008c7947ULL, 0x001fea000383ffffULL,
0x008a1805030075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x008a18050300a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffd400a87947ULL, 0x001fea000383ffffULL,
0x008a1807030075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x008a1807030095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffdc005c7947ULL, 0x001fea000383ffffULL,
0x008a1809030075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x008a1809030095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffdc00747947ULL, 0x001fea000383ffffULL,
0x008a1005030075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x008a1005030085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffe0001c7947ULL, 0x021fea000383ffffULL,
0x0089a005030075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x0089a005030085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffe000107947ULL, 0x021fea000383ffffULL,
0x0089b005070075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x0089b005070085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffe000a87947ULL, 0x001fea000383ffffULL,
0x008a1005030075a7ULL, 0x0004a2000804017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x008a10050300a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffe800147947ULL, 0x003fea000383ffffULL,
0x008a1007030075a7ULL, 0x0004a2000804017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x008a10070300a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffe8003c7947ULL, 0x003fea000383ffffULL,
0x0089f8070f0075a7ULL, 0x000b62000804017fULL, 0x0000d0000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x0089f8070f00a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffe800a47947ULL, 0x01ffea000383ffffULL,
0x00000007ff027e24ULL, 0x000fe4000f8e00ffULL, 0x00000007ff037e24ULL, 0x000fce000f8e00ffULL,
0x0000000aff057e24ULL, 0x000fc8000f8e00ffULL, 0x00210803050075a7ULL, 0x000262000806017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000b95dULL, 0x000fea0003900000ULL,
0x002108030500b5a7ULL, 0x000e24000806007fULL, 0xfffffffc00e8b947ULL, 0x001fea000383ffffULL,
0xfffffff000547947ULL, 0x021fea000383ffffULL, 0x0000000aff027e24ULL, 0x000fe4000f8e00ffULL,
0x0000000aff037e24ULL, 0x000fce000f8e00ffULL, 0x00000008ff0d7e24ULL, 0x000fc8000f8e00ffULL,
0x002100030d0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x002100030d0085a7ULL, 0x000e24000800007fULL,
0xfffffffc00e88947ULL, 0x001fea000383ffffULL, 0xfffffff400287947ULL, 0x001fea000383ffffULL,
0x018000000a047836ULL, 0x000fe20000000000ULL, 0x0000013000037945ULL, 0x000fe80003800000ULL,
0x7f800000040b7812ULL, 0x000fc800078ec0ffULL, 0x018000000b00780cULL, 0x000fda0003f25070ULL,
0x0000000a00049308ULL, 0x0000620000001000ULL, 0x0000000000389947ULL, 0x000fea0003800000ULL,
0x000000ff0b00720cULL, 0x040fe40003f45070ULL, 0x008000000b00780cULL, 0x000fe40003f22070ULL,
0x00000001ff0b7807ULL, 0x000fe40001000000ULL, 0x00000001ff047807ULL, 0x002fc80004800000ULL,
0x000000040bff7212ULL, 0x000fda000782fcffULL, 0x00000000001c9947ULL, 0x000fea0003800000ULL,
0x007fffff0aff7812ULL, 0x040fe4000782c0ffULL, 0x800000000a0a7812ULL, 0x001fe400078ec0ffULL,
0x00000001ff047807ULL, 0x000fc80000800000ULL, 0x000000040bff7212ULL, 0x000fda000782c0ffULL,
0x008000000a041812ULL, 0x000fe200078efcffULL, 0x000000ffff049224ULL, 0x000fe200078e000aULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000a00047308ULL, 0x0002a40000001000ULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x003fe400078e0012ULL,
0x00000000ff0b7424ULL, 0x000fc800078e00ffULL, 0xffffffac0a987950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100008a80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000015bULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001c5ULL,
0x00000000000001ccULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000398ULL,
0x0000000000000150ULL, 0x0000000c00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000cbULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000004e8ULL,
0x0000000000000100ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000029ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000005e8ULL,
0x0000000000000048ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000043ULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000630ULL,
0x0000000000000718ULL, 0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000100000126ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d48ULL,
0x0000000000000020ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x00000004000000b5ULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000d68ULL,
0x0000000000000000ULL, 0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000edULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000d68ULL,
0x0000000000000030ULL, 0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x0000000400000114ULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000d98ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000006dULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000de0ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x000000010000008fULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000de8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000100000032ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e00ULL,
0x0000000000005280ULL, 0x0000000c00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007fULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000006080ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000057ULL, 0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000006090ULL,
0x0000000000000400ULL, 0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000100000142ULL, 0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000006090ULL,
0x0000000000000310ULL, 0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x00000000000067e0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x00000000000067e0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000de0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000e00ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000005280ULL, 0x0000000000005280ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000006080ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000410ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000006090ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000310ULL,
0x0000000000000310ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_90_cubin_len = 26928;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
