/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000011590ULL, 0x0000000000011110ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x000000000000f860ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x000000000000f9d0ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x000000000000fa10ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x000000000000fa50ULL,
0x0000000000000130ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x000000000000fb80ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000f86000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x003cd40400288080ULL, 0x0000000000000000ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x9a082880808d0828ULL, 0x288080a108288080ULL, 0x80a508288080a208ULL, 0x08288080a7082880ULL,
0x8080a908288080a8ULL, 0xac08288080aa0828ULL, 0x288080ad08288080ULL, 0x80af08288080ae08ULL,
0x08288080b1082880ULL, 0x8080ba08288080b7ULL, 0x8408288080bb0828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x0028808084920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x0000f86000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x000000a4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8f08288080840828ULL, 0x2880809008288080ULL,
0x8095082880809208ULL, 0x082880809a082880ULL, 0x8080a208288080a1ULL, 0xa708288080a50828ULL,
0x288080a808288080ULL, 0x80aa08288080a908ULL, 0x08288080ac082880ULL, 0x8080ae08288080adULL,
0xb108288080af0828ULL, 0x288080bb08288080ULL, 0x8280162880808808ULL, 0x0000000003102880ULL,
0x8080889200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000014000000000ULL,
0x0000f9d000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000a4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8808288080840828ULL, 0x2880808f08288080ULL, 0x8092082880809008ULL,
0x0828808095082880ULL, 0x8080a1082880809aULL, 0xa508288080a20828ULL, 0x288080a708288080ULL,
0x80aa08288080a908ULL, 0x08288080ac082880ULL, 0x8080ae08288080adULL, 0xb108288080af0828ULL,
0x288080b708288080ULL, 0x80a808288080bb08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080a89200ULL, 0x0000001cffffffffULL, 0x0000021800000000ULL, 0x0000fa1000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000a4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8808288080840828ULL, 0x2880808f08288080ULL, 0x8092082880809008ULL, 0x0828808095082880ULL,
0x8080a1082880809aULL, 0xa508288080a20828ULL, 0x288080a708288080ULL, 0x80a908288080a808ULL,
0x08288080aa082880ULL, 0x8080ae08288080acULL, 0xb108288080af0828ULL, 0x288080b708288080ULL,
0x80ad08288080bb08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080ad9200ULL,
0x0000002cffffffffULL, 0x000002f000000000ULL, 0x0000fa5000000000ULL, 0x0000013000000000ULL,
0x0000180400000000ULL, 0x80a8288080ad0900ULL, 0x0000000000002880ULL, 0x0000001200082f04ULL,
0x0008120400000073ULL, 0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000007c00043704ULL, 0x0000000e00080a04ULL, 0x0058190300580160ULL,
0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x001c310400ff1b03ULL, 0x0000deb000000020ULL, 0x0000e2200000e210ULL, 0x0000e3a00000e390ULL,
0x016029040000e3b0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500001d0500001dULL, 0x0500001d0500001dULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000000f001602804ULL, 0x00001a1000000110ULL, 0x00001b6000001aa0ULL,
0x00001f6000001b90ULL, 0x00001ff000001f90ULL, 0x0000318000002050ULL, 0x000032e000003210ULL,
0x0000372000003400ULL, 0x000037a000003740ULL, 0x0000477000003800ULL, 0x000048d000004800ULL,
0x00004d00000049f0ULL, 0x00004d8000004d20ULL, 0x00005c4000004de0ULL, 0x00005da000005cd0ULL,
0x000061e000005ec0ULL, 0x0000626000006200ULL, 0x00006c10000062c0ULL, 0x0000926000006c20ULL,
0x00009a60000094a0ULL, 0x0000dc5000009a90ULL, 0x0000dc900000dc80ULL, 0x0000dcc00000dca0ULL,
0x0000dd000000dce0ULL, 0x0000e3800000dd10ULL, 0x0000e3f00000e3e0ULL, 0x0000eb100000e400ULL,
0x0000ebd00000eb60ULL, 0x0000ecb00000ec40ULL, 0x0000ed700000ed20ULL, 0x0000ee200000edc0ULL,
0x0000eef00000ee90ULL, 0x0000efb00000ef60ULL, 0x0000f0600000f000ULL, 0x0000f1300000f0d0ULL,
0x0000f1f00000f1a0ULL, 0x0000f2a00000f240ULL, 0x0000f3700000f310ULL, 0x0000f4400000f3e0ULL,
0x0000f4f00000f4a0ULL, 0x0000f5900000f540ULL, 0x0000f6300000f5e0ULL, 0x0000f6f00000f680ULL,
0x0000f7d00000f770ULL, 0x04c039040000f830ULL, 0x000000ff00000220ULL, 0x003f01000000f600ULL,
0x0000000b00000290ULL, 0x003f01200000f608ULL, 0x0000000b000002d0ULL, 0x003f01200000f688ULL,
0x0000000b00000360ULL, 0x003f01200000f6a8ULL, 0x0000000b000003a0ULL, 0x003f01200000f6c8ULL,
0x000000ff00000460ULL, 0x003f01070000f600ULL, 0x0000004000000630ULL, 0x003f01020000f68cULL,
0x00000040000006e0ULL, 0x003f01010000f688ULL, 0x000000ff00000ca0ULL, 0x0004010700000000ULL,
0x000000ff00000d40ULL, 0x0004010100000000ULL, 0x0000003900000da0ULL, 0x003f010100000020ULL,
0x0000006100000ef0ULL, 0x003f010500000004ULL, 0x0000003900000f60ULL, 0x003f010500000024ULL,
0x0000003900000fe0ULL, 0x003f010500000024ULL, 0x00000031000016d0ULL, 0x003f010700000000ULL,
0x00000031000017d0ULL, 0x003f010100000000ULL, 0x00000033000017e0ULL, 0x003f010500000004ULL,
0x0000006300001850ULL, 0x003f01010000f608ULL, 0x0000006300001870ULL, 0x003f01050000f60cULL,
0x0000002b00001910ULL, 0x003f01050000f60cULL, 0x0000003300001e50ULL, 0x003f010500000004ULL,
0x0000003300001ed0ULL, 0x003f010500000004ULL, 0x0000003900002820ULL, 0x003f010100000020ULL,
0x00000051000028a0ULL, 0x003f01010000f688ULL, 0x00000061000028f0ULL, 0x003f010500000004ULL,
0x0000003900002940ULL, 0x003f010500000024ULL, 0x00000039000029c0ULL, 0x003f010500000024ULL,
0x0000005700002ef0ULL, 0x003f010700000000ULL, 0x0000005700002f70ULL, 0x003f010100000000ULL,
0x0000005600002f80ULL, 0x003f010500000004ULL, 0x0000006400002ff0ULL, 0x003f01010000f628ULL,
0x0000006400003010ULL, 0x003f01050000f62cULL, 0x00000028000030d0ULL, 0x003f01050000f62cULL,
0x00000028000035f0ULL, 0x003f01050000f6acULL, 0x0000002800003670ULL, 0x003f01050000f6acULL,
0x0000003900003e20ULL, 0x003f010100000020ULL, 0x0000005100003e90ULL, 0x003f01010000f690ULL,
0x0000006100003ed0ULL, 0x003f010500000004ULL, 0x0000003900003f20ULL, 0x003f010500000024ULL,
0x0000003900003fa0ULL, 0x003f010500000024ULL, 0x0000006e000044d0ULL, 0x0005010700000000ULL,
0x0000006e00004550ULL, 0x0005010100000000ULL, 0x0000003300004560ULL, 0x0005010500000004ULL,
0x00000063000045d0ULL, 0x003f01010000f648ULL, 0x00000063000045f0ULL, 0x003f01050000f64cULL,
0x0000002a000046c0ULL, 0x003f01050000f64cULL, 0x0000002900004bd0ULL, 0x003f01050000f6acULL,
0x0000002900004c50ULL, 0x003f01050000f6acULL, 0x00000039000053f0ULL, 0x003f010100000020ULL,
0x0000005100005460ULL, 0x003f01010000f698ULL, 0x00000061000054c0ULL, 0x003f010500000004ULL,
0x0000003900005510ULL, 0x003f010500000024ULL, 0x0000003900005590ULL, 0x003f010500000024ULL,
0x00000057000059d0ULL, 0x003f010700000000ULL, 0x0000003000005a50ULL, 0x003f010100000000ULL,
0x0000005600005a60ULL, 0x003f010500000004ULL, 0x0000006400005ad0ULL, 0x003f01010000f668ULL,
0x0000006400005af0ULL, 0x003f01050000f66cULL, 0x0000006400005b90ULL, 0x003f01050000f66cULL,
0x00000028000060b0ULL, 0x003f01050000f6acULL, 0x0000002800006130ULL, 0x003f01050000f6acULL,
0x0000003900006840ULL, 0x003f010100000020ULL, 0x00000051000068a0ULL, 0x003f01010000f6a0ULL,
0x000000ff0000a7e0ULL, 0x003f01010000f600ULL, 0x000000ff0000b5f0ULL, 0x003f01050000f604ULL,
0x000000ff0000b690ULL, 0x003f01050000f604ULL, 0x000000ff0000b8a0ULL, 0x003f01010000f600ULL,
0x000000ff0000b8b0ULL, 0x003f01050000f604ULL, 0x000000ff0000b940ULL, 0x003f01050000f604ULL,
0x000000300000d0b0ULL, 0x003f010100000000ULL, 0x000000300000d0f0ULL, 0x003f010500000004ULL,
0x000000300000d550ULL, 0x003f010500000004ULL, 0x000000330000e970ULL, 0x003f010100000000ULL,
0x000000330000e9d0ULL, 0x003f010100000008ULL, 0x000000330000ea30ULL, 0x003f010100000010ULL,
0x000000330000eaa0ULL, 0x003f010100000018ULL, 0x00141c0400053803ULL, 0x0000a6e00000a490ULL,
0x0000ba500000b9a0ULL, 0x000004010000eae0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL,
0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000003b4ULL,
0x0000001200000002ULL, 0x00000000000002dcULL, 0x0000001200000002ULL, 0x0000000000000204ULL,
0x0000001200000002ULL, 0x000000000000012cULL, 0x0000001200000002ULL, 0x0000000000000044ULL,
0x0000001200000002ULL, 0x0000000000000391ULL, 0x0000001200000002ULL, 0x00000000000002b9ULL,
0x0000001200000002ULL, 0x00000000000001dcULL, 0x0000001200000002ULL, 0x0000000000000102ULL,
0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x00000000000e7806ULL, 0x000fe200038e0000ULL, 0x00005800ff2e7624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea20000002300ULL,
0x0000000e00047300ULL, 0x000ee200000e0000ULL, 0x00000100ff157424ULL, 0x000fe400078e00ffULL,
0x0000000000007919ULL, 0x000ea80000002200ULL, 0x0000000000417919ULL, 0x000f220000000000ULL,
0x0000000e000e7309ULL, 0x000f660000000000ULL, 0x00000000002b7919ULL, 0x000ee80000002600ULL,
0x0000000000057919ULL, 0x000f620000000000ULL, 0x00000005ff267819ULL, 0x002fc6000001160bULL,
0x0000000000287919ULL, 0x000e680000002700ULL, 0x00001fff26267589ULL, 0x000fe200000e0000ULL,
0x000000010d007824ULL, 0x004fc600078e0200ULL, 0x00001fff0d0d7589ULL, 0x000ea200000e0000ULL,
0x00000080000b7824ULL, 0x000fe200078e020bULL, 0x00000004ff0f7819ULL, 0x010fe20000011641ULL,
0x000000082e007824ULL, 0x000fe400078e00ffULL, 0x000000082b077824ULL, 0x008fe200078e00ffULL,
0x000000ff0b00720cULL, 0x000fe20003f45270ULL, 0x00000010410a7824ULL, 0x000fe200078e00ffULL,
0x0000000f0b00780cULL, 0x040fe40003f64070ULL, 0x000000030b00780cULL, 0x000fc40003f24070ULL,
0x0000007f0b00780cULL, 0x000fe40003f84070ULL, 0x000000050400720cULL, 0x020fe20003f02070ULL,
0x0000002800007224ULL, 0x002fe200078e0207ULL, 0x000000f00a137812ULL, 0x000fc600078ec0ffULL,
0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL,
0x000000040d067824ULL, 0x004fe400078e0226ULL, 0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL,
0x00f60002ff00a388ULL, 0x0003e20000000a00ULL, 0x000000010b00780cULL, 0x000fe20003f44070ULL,
0x0000000206087824ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff05b424ULL, 0x000fc400078e00ffULL,
0x0000000108117824ULL, 0x040fe200078e020fULL, 0x0000000808097817ULL, 0x000fe20007800000ULL,
0x3fffff60ff069424ULL, 0x000fe200078e00ffULL, 0x00f608040b00b388ULL, 0x0005e20000008a00ULL,
0x7fffff60ff079424ULL, 0x000fe400078e00ffULL, 0x0000000100027824ULL, 0x002fe400078e0211ULL,
0x0000000109007824ULL, 0x000fe200078e0a08ULL, 0x00f688060b009388ULL, 0x000fe20000008a00ULL,
0xff317217ff0cc424ULL, 0x000fc400078e00ffULL, 0x3fffffc0ff08a424ULL, 0x000fe200078e00ffULL,
0x000000000f00720cULL, 0x000fe20003f66070ULL, 0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL,
0x00f4000c0b00c388ULL, 0x0003e20000004800ULL, 0x3fffff80ff049424ULL, 0x004fe400078e00ffULL,
0x7fffff80ff059424ULL, 0x000fe400078e00ffULL, 0x00005c0002027625ULL, 0x000fc600078e0015ULL,
0x00f6a8040b009388ULL, 0x0005e20000008a00ULL, 0x000000ffff007224ULL, 0x000fe200078e0a0eULL,
0x00000007110c7812ULL, 0x002fe200078ec0ffULL, 0x00000004ff0f7424ULL, 0x000fe200078e00ffULL,
0x00f6c8080b00a388ULL, 0x0003e80000008a00ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000f0c0c7812ULL, 0x000fe400078e7841ULL, 0x0000001302027210ULL, 0x000fe20007f9e0ffULL,
0x0000620028047625ULL, 0x004fc800078e000fULL, 0x00000010110c7824ULL, 0x000fe400078e020cULL,
0x000000ffff037224ULL, 0x000fe400020e0603ULL, 0x000000100c077824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604247981ULL, 0x000ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x00000004ff257e24ULL, 0x008fe2000f8e00ffULL,
0x0000007f24037810ULL, 0x006fc40007ffe0ffULL, 0x000000ff24027810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff037819ULL, 0x000fe40000011603ULL, 0x00000008ff027819ULL, 0x000fca0000011602ULL,
0x0000a18000008947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe20000011626ULL,
0x0000000826407824ULL, 0x000fe400078e00ffULL, 0x00000003ff077424ULL, 0x000fe200078e00ffULL,
0x01ffffff00007812ULL, 0x000fe200078ec0ffULL, 0xffffffffff3f7424ULL, 0x000fc800078e00ffULL,
0x0000000225547824ULL, 0x000fca00078e0200ULL, 0x000000035400720cULL, 0x000fda0003f06070ULL,
0x0000000228008824ULL, 0x000fe400078e00ffULL, 0x00006400ff058624ULL, 0x000fc800078e00ffULL,
0x0000640000058624ULL, 0x000fc800078e0205ULL, 0x0000000154058824ULL, 0x000fe200078e0205ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f68c0740ff738cULL, 0x0003e20000000000ULL,
0x0000600005048625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000006043f8981ULL, 0x0004e2000c1e1900ULL, 0x00000001263e7812ULL, 0x000fe200078ec0ffULL,
0x000000802b3d7824ULL, 0x000fe200078e00ffULL, 0x00000003ff087819ULL, 0x000fe20000011641ULL,
0x00f6880040ff7f8cULL, 0x0009e2000c80043fULL, 0x00000001ff437819ULL, 0x000fe20000011626ULL,
0x000000103e067824ULL, 0x000fe200078e00ffULL, 0x00000004080b7810ULL, 0x000fe20007ffe0ffULL,
0xff317217ff3b7424ULL, 0x000fe200078e00ffULL, 0x0000000125077810ULL, 0x002fe20007ffe0ffULL,
0x0000000106097824ULL, 0x000fe200078e0208ULL, 0x0000000808107810ULL, 0x000fe20007ffe0ffULL,
0x00000001060c7824ULL, 0x000fe200078e020bULL, 0x0000000c08127810ULL, 0x000fe20007ffe0ffULL,
0x00000008090f7824ULL, 0x040fe200078e00ffULL, 0x0000004109007212ULL, 0x080fe200078e3cffULL,
0x00000008250d7824ULL, 0x000fe200078e0243ULL, 0x000000410c057212ULL, 0x0c4fe200078e3cffULL,
0x000000080c0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f047812ULL, 0x000fe200078ee200ULL,
0x000000200d007824ULL, 0x000fe200078e00ffULL, 0x000000020700720cULL, 0x000fe20003f06070ULL,
0x0000000106077824ULL, 0x000fe200078e0210ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee205ULL,
0x0000000106117824ULL, 0x000fe200078e0212ULL, 0x0000000024057217ULL, 0x000fe20007800000ULL,
0x00002000433c7824ULL, 0x000fe200078e00ffULL, 0x00000041070f7212ULL, 0x0c0fe200078e3cffULL,
0x0000000807167824ULL, 0x000fe200078e00ffULL, 0x0000004111147212ULL, 0x000fe200078e3cffULL,
0x0000000105057824ULL, 0x100fe200078e0a00ULL, 0x000000603d007812ULL, 0x000fe200078ef800ULL,
0x00000000430473c2ULL, 0x000e6200000e0000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e00ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000002005057807ULL, 0x000fe20000000000ULL,
0x0000000100097824ULL, 0x040fe200078e0209ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000001000d7824ULL, 0x040fe200078e020cULL, 0x0000000605057217ULL, 0x000fe20007800000ULL,
0x0000000100137824ULL, 0x000fe200078e0207ULL, 0x0000b0003c077810ULL, 0x000fe20007ffe0ffULL,
0x0000000100177824ULL, 0x000fe200078e0211ULL, 0xfffffff8160c7812ULL, 0x000fe200078ee20fULL,
0x0000000811117824ULL, 0x000fe200078e00ffULL, 0x0000f6a843397811ULL, 0x000fe200078e18ffULL,
0x0000000105057824ULL, 0x000fc400078e0a06ULL, 0x00000010040f7824ULL, 0x100fe200078e0207ULL,
0xfffffff811147812ULL, 0x000fe200078ee214ULL, 0x000000100e117824ULL, 0x100fe200078e0207ULL,
0x000000050800720cULL, 0x080fe20003f66070ULL, 0x000000100c157824ULL, 0x100fe200078e0207ULL,
0x000000050b00720cULL, 0x080fe20003f46070ULL, 0x00000010141d7824ULL, 0x000fe200078e0207ULL,
0x000000051000720cULL, 0x080fe20003f26070ULL, 0x0000f6a804047891ULL, 0x002fe2000f8e203fULL,
0x000000051200720cULL, 0x000fe20003f06070ULL, 0x000058003f007a24ULL, 0x008fc800078e02ffULL,
0x0000008000007824ULL, 0x000fca00078e00ffULL, 0x0000000900097210ULL, 0x040fe40007f9e0ffULL,
0x0000000d000d7210ULL, 0x040fe40007fde0ffULL, 0x00005e00090e7a11ULL, 0x000fe200078a38ffULL,
0x000000ffff067224ULL, 0x000fe200020e06ffULL, 0x00005e000d087a11ULL, 0x000fe200078838ffULL,
0x000000ffff047224ULL, 0x000fe200030e06ffULL, 0x0000001300137210ULL, 0x000fe40007fde0ffULL,
0x00005f0009097a11ULL, 0x000fc400028f3c06ULL, 0x0000001700007210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff067224ULL, 0x000fe200030e06ffULL, 0x00005f000d077a11ULL, 0x000fe200020f3c04ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x000000700a0d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fe200028e06ffULL, 0x00005e00130a7a11ULL, 0x000fe400078838ffULL,
0x00005e00000c7a11ULL, 0x000fe400078c38ffULL, 0x0000000e0d047210ULL, 0x000fc40007fbe0ffULL,
0x00005f0013067a11ULL, 0x000fe400020f3c06ULL, 0x0000000d08087210ULL, 0x080fe20007f9e0ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00005f0000007a11ULL, 0x000fe200030f3c05ULL,
0x000000ffff057224ULL, 0x000fe200028e0609ULL, 0x0000000d0a0a7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200020e0607ULL, 0x0000000d0c0c7210ULL, 0x000fe40007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e2000d901c46ULL,
0x000000ffff0b7224ULL, 0x000fc400028e0606ULL, 0x000000ffff0d7224ULL, 0x000fe200020e0600ULL,
0x0000000008117faeULL, 0x0005e2000d101c46ULL, 0x0000000000067805ULL, 0x000fc6000001ff00ULL,
0x000000000a157faeULL, 0x0007e2000c901c46ULL, 0x000000022500720cULL, 0x000fc60003f26070ULL,
0x000000000c1d7faeULL, 0x0009e2000c101c46ULL, 0x0000000000047805ULL, 0x002fc6000001ff00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000107805ULL, 0x004fc6000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000147805ULL, 0x008fe2000001ff00ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff667f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00002000392a7f8cULL, 0x0004e2000c80043fULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x010fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000002039617810ULL, 0x000fe20007ffe0ffULL,
0x00005ac000001947ULL, 0x000fea0003800000ULL, 0x0000000228387824ULL, 0x004fe400078e00ffULL,
0x00006400ff077624ULL, 0x000fc400078e00ffULL, 0x000000ffff297224ULL, 0x008fe400078e002bULL,
0x0000640038387624ULL, 0x000fe400078e0207ULL, 0xff317217ff3b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff6b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e00ffULL,
0x0000010025277824ULL, 0x000fca00078e00ffULL, 0x000000242700720cULL, 0x000fda0003f06070ULL,
0x000059e000000947ULL, 0x026fea0003800000ULL, 0x0000040061007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804829ULL, 0x0000000000007918ULL, 0x000fee0000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x000000ffff657224ULL, 0x000fe400078e0054ULL,
0x000000ffff277224ULL, 0x000fe200078e006bULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240039007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000287305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000280000735dULL, 0x008fe40003800000ULL,
0x0000240039287984ULL, 0x000ea40000000800ULL, 0x8000000028ff7812ULL, 0x004fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000300ff667624ULL, 0x002fe200078e00ffULL,
0x0000000154007812ULL, 0x000fe200078ec0ffULL, 0x000058003f2a7a24ULL, 0x000fe200078e02ffULL,
0x00000003ff2e7819ULL, 0x000fe20000011641ULL, 0xffffffffff3f7424ULL, 0x000fe200078e00ffULL,
0x000000010000780cULL, 0x000fc40003f05070ULL, 0xffffffff66667811ULL, 0x000fc800078e08ffULL,
0x0000000166667807ULL, 0x000fca0004000000ULL, 0x0000000154547824ULL, 0x000fe400078e0266ULL,
0x0000001026007824ULL, 0x000fc600078e00ffULL, 0x000000035400720cULL, 0x000fe40003f06070ULL,
0x00000010002d7812ULL, 0x000fca00078ec0ffULL, 0x000000012e447824ULL, 0x040fe200078e022dULL,
0x000000042e347810ULL, 0x000fe20007ffe0ffULL, 0x0000010025507824ULL, 0x000fe200078e00ffULL,
0x00000001ff437819ULL, 0x000fe20000011626ULL, 0x0000000844007824ULL, 0x000fe400078e00ffULL,
0x0000006638288210ULL, 0x000fe20007ffe065ULL, 0x00000004ff298424ULL, 0x000fe200078e00ffULL,
0x00000041445b7212ULL, 0x000fe200078e3cffULL, 0x0000000134467824ULL, 0x000fe400078e022dULL,
0x0000600028288625ULL, 0x000fe200078e0029ULL, 0xfffffff8005b7812ULL, 0x000fc600078ee25bULL,
0x0000002043007824ULL, 0x000fe200078e0250ULL, 0x00000006283f8981ULL, 0x000362000c1e1900ULL,
0x00000041465a7212ULL, 0x080fe200078e3cffULL, 0x000000802a2c7824ULL, 0x000fe200078e00ffULL,
0x000000082e367810ULL, 0x000fe20007ffe0ffULL, 0x0000001041457824ULL, 0x000fe200078e00ffULL,
0x0000004000007810ULL, 0x000fe20007ffe0ffULL, 0x0000058000007945ULL, 0x000fe20003800000ULL,
0x00000001252b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000136487824ULL, 0x100fe200078e022dULL,
0x0000000c2e4c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000846297824ULL, 0x002fe200078e00ffULL,
0x000000022b00720cULL, 0x000fe20003f06070ULL, 0x00000008482b7824ULL, 0x040fe200078e00ffULL,
0x00000041485e7212ULL, 0x000fe200078e3cffULL, 0x000000014c4a7824ULL, 0x000fe200078e022dULL,
0xfffffff8295a7812ULL, 0x000fc400078ee25aULL, 0x0000000024297217ULL, 0x000fe20007800000ULL,
0x000000084a307824ULL, 0x040fe200078e00ffULL, 0xfffffff82b5e7812ULL, 0x000fe400078ee25eULL,
0x000000414a5d7212ULL, 0x000fe200078e3cffULL, 0x0000000129287824ULL, 0x100fe200078e0a00ULL,
0x000000603d297812ULL, 0x000fe400078ef800ULL, 0xfffffff8305d7812ULL, 0x000fe400078ee25dULL,
0x0000002028287807ULL, 0x000fe20000000000ULL, 0x0000000129007824ULL, 0x000fe200078e0244ULL,
0x0000007045357812ULL, 0x000fe200078ec0ffULL, 0x00000001292a7824ULL, 0x040fe200078e0246ULL,
0x0000002d28287217ULL, 0x000fe20007800000ULL, 0x00000001292b7824ULL, 0x040fe200078e0248ULL,
0x000000002c007210ULL, 0x040fe20007f5e0ffULL, 0x0000000129297824ULL, 0x000fe200078e024aULL,
0x0000002a2c2a7210ULL, 0x000fe20007f7e0ffULL, 0x00000001282d7824ULL, 0x000fe200078e0a2dULL,
0x0000002b2c2b7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff337224ULL, 0x000fe200010e06ffULL,
0x00005e00002f7a11ULL, 0x000fe200078438ffULL, 0x000000ffff317224ULL, 0x000fe200018e06ffULL,
0x000000292c297210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff327224ULL, 0x000fe200020e06ffULL,
0x00005f0000337a11ULL, 0x000fe200010f3c33ULL, 0x000010006b007824ULL, 0x000fe200078e00ffULL,
0x00005e002a307a11ULL, 0x000fc400078438ffULL, 0x00005e002b2c7a11ULL, 0x000fe400078638ffULL,
0x0000100000007812ULL, 0x000fe400078e0cffULL, 0x00005f002a317a11ULL, 0x000fe200010f3c31ULL,
0x000000ffff2a7224ULL, 0x000fe200000e06ffULL, 0x0000002d2e00720cULL, 0x000fe20003f46070ULL,
0x0000200043007824ULL, 0x000fe200078e0200ULL, 0x00005f002b327a11ULL, 0x000fe400018f3c32ULL,
0x00005e00292e7a11ULL, 0x000fc400078038ffULL, 0x000000352f287210ULL, 0x080fe40007f7e0ffULL,
0x0000b00000007810ULL, 0x000fe40007ffe0ffULL, 0x00005f00292f7a11ULL, 0x000fe200000f3c2aULL,
0x000000ffff297224ULL, 0x000fe200018e0633ULL, 0x00000035302a7210ULL, 0x000fe20007fbe0ffULL,
0x000000105b5f7824ULL, 0x100fe200078e0200ULL, 0x0000002d3400720cULL, 0x000fe20003f06070ULL,
0x000000086b337824ULL, 0x000fe200078e00ffULL, 0x000000352c2c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200028e0631ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000285f7faeULL, 0x0003e2000d101c46ULL, 0x0000002d3600720cULL, 0x080fe20003f46070ULL,
0x000000105a587824ULL, 0x100fe200078e0200ULL, 0x0000002d4c00720cULL, 0x000fe20003fa6070ULL,
0x000000105e607824ULL, 0x100fe200078e0200ULL, 0xfffffff0402d7812ULL, 0x000fe200078ec0ffULL,
0x000000105d627824ULL, 0x000fe200078e0200ULL, 0x000000352e2e7210ULL, 0x000fc40007f9e0ffULL,
0x0000f6a82d307810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2d7224ULL, 0x000fe200018e0632ULL,
0x0000000833317812ULL, 0x000fe200078e0cffULL, 0x000000ffff2f7224ULL, 0x000fe200020e062fULL,
0x000000002a587faeULL, 0x0005e2000c101c46ULL, 0xffffffe040007812ULL, 0x000fe400078ec0ffULL,
0x0000000130317824ULL, 0x000fe200078e0231ULL, 0x000000002c607faeULL, 0x0007e2000d101c46ULL,
0x0000001040297812ULL, 0x002fe400078ec0ffULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x000000002e627faeULL, 0x0007e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000001002b7824ULL, 0x004fe200078e0229ULL, 0x0000000840007812ULL, 0x000fca00078ec0ffULL,
0x000000012b637824ULL, 0x000fe400078e0200ULL, 0x00000000310403c2ULL, 0x000e640000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x002fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000130337824ULL, 0x000fe200078e0233ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000031687f8cULL, 0x0002a8000c80043fULL,
0x0000040033007984ULL, 0x0003220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6080063287f8cULL, 0x000fe2000c80043fULL,
0x8000000000ff7812ULL, 0x010fc60007844867ULL, 0x00f60c00632d7984ULL, 0x008ee40000000800ULL,
0x800000002dff7812ULL, 0x008fe40007804829ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x000000083e2b7824ULL, 0x000fe400078e022bULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x00000000002a7305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x0000002a0000735dULL, 0x010fe20003800000ULL, 0x00f60c002b2d7984ULL, 0x000ee40000000800ULL,
0x800000002dff7812ULL, 0x008fc40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020264c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff477819ULL, 0x000fe20000011641ULL,
0xffffffffff497424ULL, 0x000fe200078e00ffULL, 0x0000007045457812ULL, 0x000fe400078ec0ffULL,
0xffffff804c4c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c47477812ULL, 0x000fc800078ec0ffULL,
0x0000004c47007210ULL, 0x000fca0007ffe045ULL, 0x00f00000002a7984ULL, 0x000ee80000000800ULL,
0x00f20000002b7984ULL, 0x0008620000000800ULL, 0x0000003b2a00720bULL, 0x008fe20003f1d000ULL,
0x0000d0e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x010fc800000e0100ULL,
0x0000ffff002e7812ULL, 0x000fe2000780c0ffULL, 0x000003e000007945ULL, 0x000fe20003800000ULL,
0x00000001ff307424ULL, 0x000fd600078e00ffULL, 0x000003b000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe40000011626ULL, 0x0000003b2a00720bULL, 0x000fe40003f14000ULL,
0x000000262900720cULL, 0x000fe20003f65270ULL, 0x0000d0a27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000007806ULL, 0x000fe400000e0100ULL, 0x000000802628b824ULL, 0x000fe200078e0245ULL,
0x0000002a3b2f7209ULL, 0x000fe40007810000ULL, 0x0000ffff002d7812ULL, 0x000fe200078e3cffULL,
0x000000014728b824ULL, 0x000fe200078e0228ULL, 0x00000002ff007819ULL, 0x000fe20000011641ULL,
0x8000002f3b297221ULL, 0x000fe20000010000ULL, 0x0000002d2eff7212ULL, 0x000fc4000780c0ffULL,
0x00f4002f2800b388ULL, 0x0007e20000000800ULL, 0x3fb8aa3b29297820ULL, 0x000fc80000410000ULL,
0x0000002900367308ULL, 0x0007220000000800ULL, 0x0000d0327f007947ULL, 0x000fea000b800000ULL,
0x00001f00362c7589ULL, 0x0108e400000e0000ULL, 0x0000000800007810ULL, 0x010fe20007ffe0ffULL,
0x0000d0727f007947ULL, 0x000fea000b800000ULL, 0x00001f0036007589ULL, 0x0008e400000e0000ULL,
0x8000002f2a2a0221ULL, 0x100fe20000010000ULL, 0x000000363a3a7220ULL, 0x000fe20000410000ULL,
0x0000000007077220ULL, 0x088fe20000410000ULL, 0x0000000006067220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b2a2a0820ULL, 0x000fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x000000001a1a7220ULL, 0x080fe20000410000ULL, 0x0000000017177220ULL, 0x080fe20000410000ULL,
0x0000002a00420308ULL, 0x000ee20000000800ULL, 0x0000000016167220ULL, 0x080fe20000410000ULL,
0x0000000013137220ULL, 0x080fe20000410000ULL, 0x0000000012127220ULL, 0x080fe20000410000ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x0000000023237220ULL, 0x080fe20000410000ULL, 0x0000000022227220ULL, 0x080fe20000410000ULL,
0x000000001f1f7220ULL, 0x080fe20000410000ULL, 0x000000001e1e7220ULL, 0x080fe20000410000ULL,
0x000000000b0b7220ULL, 0x080fe20000410000ULL, 0x000000000a0a7220ULL, 0x000fe20000410000ULL,
0x00000001ff307807ULL, 0x000fe20000000000ULL, 0x0000002c05057220ULL, 0x080fe20000410000ULL,
0x0000002c04047220ULL, 0x080fe20000410000ULL, 0x0000002c19197220ULL, 0x080fe20000410000ULL,
0x0000002c18187220ULL, 0x080fe20000410000ULL, 0x0000002c15157220ULL, 0x080fe20000410000ULL,
0x0000002c14147220ULL, 0x080fe20000410000ULL, 0x0000002c11117220ULL, 0x080fe20000410000ULL,
0x0000002c10107220ULL, 0x080fe20000410000ULL, 0x0000002c0d0d7220ULL, 0x080fe20000410000ULL,
0x0000002c0c0c7220ULL, 0x080fe20000410000ULL, 0x0000002c21217220ULL, 0x080fe20000410000ULL,
0x0000002c20207220ULL, 0x080fe20000410000ULL, 0x0000002c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000002c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000002c09097220ULL, 0x080fe20000410000ULL,
0x0000002c08087220ULL, 0x000fe20000410000ULL, 0x000000ffff3b7224ULL, 0x000fe200078e002fULL,
0x000000422b2b0220ULL, 0x00afc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000003a2b3a7221ULL, 0x002fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0000040033007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000287305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000280000735dULL, 0x008fe40003800000ULL, 0x0000040033287984ULL, 0x000e640000000800ULL,
0x8000000028ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000042ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff2b7819ULL, 0x000fc40000011641ULL,
0x0000541000367816ULL, 0x010fe20000000000ULL, 0x0000cd127f007947ULL, 0x000fea000b800000ULL,
0x00001f2b36517589ULL, 0x0002e400000e0000ULL, 0x000000082b4b7810ULL, 0x000fe20007ffe0ffULL,
0x0000cd527f007947ULL, 0x000fea000b800000ULL, 0x00001f4b36007589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000102b377810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff6d7424ULL, 0x000fe200078e00ffULL, 0x0000200000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0000da1000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000182b377810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff6d7424ULL, 0x000fe200078e00ffULL, 0x0000206000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0000d9b000007944ULL, 0x03cfea0003c00000ULL,
0x0000000226537824ULL, 0x040fe200078e00ffULL, 0x0000000741287812ULL, 0x000fe200078ec0ffULL,
0x0000020026297824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x00000004532a7812ULL, 0x000fc400078ec0ffULL, 0x0000000828317812ULL, 0x000fe400078ef841ULL,
0x0000002a41327211ULL, 0x000fe400078fe0ffULL, 0xfffff800294e7812ULL, 0x000fe400078ec0ffULL,
0x0000000732287812ULL, 0x000fca00078e7831ULL, 0x00000008314d7824ULL, 0x000fe200078e0228ULL,
0x0000000841287812ULL, 0x000fc600078ec0ffULL, 0x000000104d4d7824ULL, 0x000fe400078e024eULL,
0x0000000426297824ULL, 0x000fe200078e00ffULL, 0x0000000728357812ULL, 0x100fe200078ec841ULL,
0x00001000262b7824ULL, 0x002fe200078e00ffULL, 0x0000000728337812ULL, 0x000fe400078ef841ULL,
0x00000004292a7812ULL, 0x000fe400078ec0ffULL, 0xffffe0002b2c7812ULL, 0x000fe400078ec0ffULL,
0x0000002a41347211ULL, 0x004fe400078fe0ffULL, 0x0000991030307816ULL, 0x000fe200000000ffULL,
0x000010006b2c7824ULL, 0x000fe200078e022cULL, 0x0000003435527212ULL, 0x000fc400078e3cffULL,
0x0000000234347810ULL, 0x000fe40007ffe0ffULL, 0x0000b0002c367810ULL, 0x010fe20007ffe0ffULL,
0x00000008336a7824ULL, 0x000fe200078e0252ULL, 0x009000004d2c783bULL, 0x000e620000000200ULL,
0x0000003435567212ULL, 0x000fe400078e3cffULL, 0x000000106a287824ULL, 0x000fe200078e0236ULL,
0x000000ff3000720cULL, 0x000fe40003f05270ULL, 0x0000000833557824ULL, 0x000fe200078e0256ULL,
0x0000000232327810ULL, 0x000fc40007ffe0ffULL, 0x000000002828783bULL, 0x000ea20000004200ULL,
0x0000001055367824ULL, 0x000fe200078e0236ULL, 0x0000000732327812ULL, 0x000fca00078e7831ULL,
0x000000003634783bULL, 0x000f220000004200ULL, 0x0000000831317824ULL, 0x000fc800078e0232ULL,
0x00000010314e7824ULL, 0x000fe200078e024eULL, 0x000000512c2c8232ULL, 0x08afe40000000000ULL,
0x000000512e2e8232ULL, 0x000fe40000000000ULL, 0x000000002d2d8232ULL, 0x080fe40000000000ULL,
0x000000002f2f8232ULL, 0x000fe20000000000ULL, 0x0000312028307816ULL, 0x004fe400000000ffULL,
0x00003120294f7816ULL, 0x000fc400000000ffULL, 0x00000030ff28723eULL, 0x000fe400020006ffULL,
0x0000004fff29723eULL, 0x000fe400020006ffULL, 0x000031202b6d7816ULL, 0x000fe400000000ffULL,
0x0000312034347816ULL, 0x010fe400000000ffULL, 0x0000312035357816ULL, 0x000fe200000000ffULL,
0x000000282c08723cULL, 0x000fe20000001808ULL, 0x0000312036577816ULL, 0x000fc400000000ffULL,
0x0000312037597816ULL, 0x000fc800000000ffULL, 0x00000030ff28723eULL, 0x000fe400030006ffULL,
0x0000004fff29723eULL, 0x000fe400030006ffULL, 0x000031202a307816ULL, 0x000fe200000000ffULL,
0x000010006b2a7824ULL, 0x000fe200078e023cULL, 0x00000080334f7811ULL, 0x000fe400078e18ffULL,
0x00000030ff6c723eULL, 0x000fe200030006ffULL, 0x000000282c1c723cULL, 0x000fe2000000181cULL,
0x0000b0002a5c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000152527824ULL, 0x000fc400078e024fULL,
0x00000001564f7824ULL, 0x000fe200078e024fULL, 0x00000057ff56723eULL, 0x000fe200030006ffULL,
0x0000001052317824ULL, 0x100fe200078e025cULL, 0x0000006dff29723eULL, 0x080fe200020006ffULL,
0x000000104f367824ULL, 0x000fe200078e025cULL, 0x0000006dff6d723eULL, 0x000fe400030006ffULL,
0x00000030ff28723eULL, 0x000fe400020006ffULL, 0x000000003130783bULL, 0x000e660000004200ULL,
0x0000006c2c0c723cULL, 0x040fee000000180cULL, 0x00000034ff6c723eULL, 0x080fe200020006ffULL,
0x000000282c20723cULL, 0x000fe20000001820ULL, 0x00000035ff6d723eULL, 0x000fe200020006ffULL,
0x009000004e28783bULL, 0x000ea20000000200ULL, 0x00000034ff34723eULL, 0x000fc400030006ffULL,
0x00000035ff35723eULL, 0x000fc600030006ffULL, 0x0000006c2c10723cULL, 0x040ff00000001810ULL,
0x000000342c14723cULL, 0x000fee0000001814ULL, 0x00000057ff34723eULL, 0x000fc400020006ffULL,
0x00000059ff35723eULL, 0x080fe400020006ffULL, 0x00000059ff57723eULL, 0x000fe400030006ffULL,
0x0000312030307816ULL, 0x002fe400000000ffULL, 0x0000312031317816ULL, 0x000fe200000000ffULL,
0x000000342c18723cULL, 0x000fe20000001818ULL, 0x000000003634783bULL, 0x000e620000004200ULL,
0x0000312032327816ULL, 0x000fe400000000ffULL, 0x0000312033337816ULL, 0x000fc800000000ffULL,
0x000000562c04723cULL, 0x000fe20000001804ULL, 0x0000005128288232ULL, 0x084fe40000000000ULL,
0x000000512a2a8232ULL, 0x000fe40000000000ULL, 0x0000000029298232ULL, 0x080fe40000000000ULL,
0x00000030ff2c723eULL, 0x080fe200020006ffULL, 0x000000002b2b8232ULL, 0x000fe20000000000ULL,
0x00000031ff2d723eULL, 0x000fe400020006ffULL, 0x00000030ff30723eULL, 0x000fc400030006ffULL,
0x00000031ff31723eULL, 0x000fc600030006ffULL, 0x0000002c2808723cULL, 0x040fee0000001808ULL,
0x00000032ff2c723eULL, 0x080fe200020006ffULL, 0x00000030281c723cULL, 0x000fe2000000181cULL,
0x00000033ff2d723eULL, 0x000fe400020006ffULL, 0x00000032ff32723eULL, 0x000fc400030006ffULL,
0x00000033ff33723eULL, 0x000fc600030006ffULL, 0x0000002c2820723cULL, 0x040fe20000001820ULL,
0x0000312034347816ULL, 0x002fe400000000ffULL, 0x0000312035357816ULL, 0x000fe400000000ffULL,
0x0000312036367816ULL, 0x000fe400000000ffULL, 0x00000034ff2c723eULL, 0x000fe200020006ffULL,
0x00000032280c723cULL, 0x000fe2000000180cULL, 0x00000035ff2d723eULL, 0x000fe400020006ffULL,
0x0000312037377816ULL, 0x000fc400000000ffULL, 0x00000034ff34723eULL, 0x000fe400030006ffULL,
0x00000035ff35723eULL, 0x000fe200030006ffULL, 0x0000002c2810723cULL, 0x040fee0000001810ULL,
0x00000036ff2c723eULL, 0x000fe200020006ffULL, 0x000000342814723cULL, 0x000fe20000001814ULL,
0x00000037ff2d723eULL, 0x000fc400020006ffULL, 0x00000036ff36723eULL, 0x000fe400030006ffULL,
0x00000037ff37723eULL, 0x000fc600030006ffULL, 0x0000002c2818723cULL, 0x040ff00000001818ULL,
0x000000362804723cULL, 0x000fe20000001804ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200039287f8cULL, 0x0002a2000c80043fULL, 0xfffffff853517812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000040502b7810ULL, 0x000fe20007ffe0ffULL,
0x00f6880051ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff677224ULL, 0x000fe200078e0069ULL,
0x000000016b6b7812ULL, 0x000fc400078e0cffULL, 0x000000242b00720cULL, 0x000fda0003f06070ULL,
0x00003fe000000947ULL, 0x000fea0003800000ULL, 0x0000040061007984ULL, 0x008ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804829ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240039007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000287305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000280000735dULL, 0x008fe40003800000ULL,
0x0000240039287984ULL, 0x000ea40000000800ULL, 0x8000000028ff7812ULL, 0x004fc40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff437819ULL, 0x000fe20000011626ULL,
0x00000008275c7824ULL, 0x000fe200078e00ffULL, 0x0000000125297810ULL, 0x000fe20007ffe0ffULL,
0x00001000276c7824ULL, 0x000fe200078e00ffULL, 0x00000003ff327819ULL, 0x000fe20000011641ULL,
0x0000001043007824ULL, 0x040fe200078e00ffULL, 0x000000085c577812ULL, 0x000fe200078ec0ffULL,
0x0000002043287824ULL, 0x000fe200078e0250ULL, 0x000000022900720cULL, 0x000fe20003f46070ULL,
0x000058003f2d7a24ULL, 0x020fe200078e02ffULL, 0x0000f6a800567810ULL, 0x000fe20007ffe0ffULL,
0x00000010262c7824ULL, 0x000fe200078e00ffULL, 0x000010006c2a7812ULL, 0x000fe200078ec0ffULL,
0x000000802d2f7824ULL, 0x000fe200078e00ffULL, 0x0000000857297812ULL, 0x000fe200078e3cffULL,
0x0000000156577824ULL, 0x000fe200078e0257ULL, 0x0000008028287810ULL, 0x000fe20007ffe0ffULL,
0x00002000432a7824ULL, 0x000fe200078e022aULL, 0x000000102c337812ULL, 0x000fe200078ec0ffULL,
0x0000000156567824ULL, 0x000fe200078e0229ULL, 0x0000002824297217ULL, 0x000fe20007800000ULL,
0x00000000570473c2ULL, 0x000ea200000e0000ULL, 0x0000b0002a2b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000432367810ULL, 0x040fe20007ffe0ffULL, 0x00000001292a7824ULL, 0x100fe200078e0a28ULL,
0x000000603d297812ULL, 0x000fe200078ef828ULL, 0x000000105b5b7824ULL, 0x100fe200078e022bULL,
0x0000000832347810ULL, 0x000fe20007ffe0ffULL, 0x000000105a5a7824ULL, 0x000fe200078e022bULL,
0x000000202a2a7807ULL, 0x000fe20001000000ULL, 0x0000000144287824ULL, 0x000fe200078e0229ULL,
0x0000001000647812ULL, 0x000fe200078ec0ffULL, 0x000000105e5e7824ULL, 0x100fe200078e022bULL,
0x0000002a332a7217ULL, 0x000fe20007800000ULL, 0x000000105d5d7824ULL, 0x000fe200078e022bULL,
0x000000282f287210ULL, 0x000fe20007f1e0ffULL, 0x00000001462b7824ULL, 0x000fc400078e0229ULL,
0x00000001482c7824ULL, 0x100fe400078e0229ULL, 0x000000014a297824ULL, 0x000fe200078e0229ULL,
0x0000002b2f2b7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200000e06ffULL,
0x00005e0028307a11ULL, 0x040fe400078038ffULL, 0x0000002c2f317210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x000000292f2f7210ULL, 0x000fe40007f9e0ffULL,
0x00005f0028297a11ULL, 0x000fe200000f3c2dULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x00005e00312c7a11ULL, 0x000fe200078438ffULL, 0x000000012a2d7824ULL, 0x000fe200078e0a33ULL,
0x00005e002b2a7a11ULL, 0x000fc400078038ffULL, 0x00005f0031317a11ULL, 0x000fe400010f3c28ULL,
0x0000004530287210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff307224ULL, 0x000fe200020e06ffULL,
0x00005f002b2b7a11ULL, 0x000fe400000f3c2eULL, 0x0000002d3200720cULL, 0x040fe20003f46070ULL,
0x000000ffff297224ULL, 0x000fe200028e0629ULL, 0x00005e002f2e7a11ULL, 0x000fe400078838ffULL,
0x0000000c32327810ULL, 0x000fc40007ffe0ffULL, 0x000000452c2c7210ULL, 0x000fe40007fbe0ffULL,
0x0000002d3600720cULL, 0x080fe40003f66070ULL, 0x0000002d3400720cULL, 0x080fe40003f06070ULL,
0x00005f002f2f7a11ULL, 0x000fe200020f3c30ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000285b7faeULL, 0x0007e2000d101c46ULL, 0x0000002d3200720cULL, 0x000fe20003f86070ULL,
0x000000ffff2d7224ULL, 0x000fe200028e0631ULL, 0x000000452a2a7210ULL, 0x000fc40007fde0ffULL,
0x000000452e2e7210ULL, 0x000fe40007fbe0ffULL, 0x0000000840317812ULL, 0x040fe200078ec0ffULL,
0x000000ffff2b7224ULL, 0x000fe200030e062bULL, 0xffffffe040307812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2f7224ULL, 0x000fc600028e062fULL, 0x000000002a5a7faeULL, 0x0007e2000d901c46ULL,
0x0000003031647210ULL, 0x000fc60007ffe064ULL, 0x000000002c5e7faeULL, 0x0007e8000c101c46ULL,
0x000000002e5d7faeULL, 0x0007e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x004fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000057287f8cULL, 0x0084e8000c80043fULL,
0x00000400562d7984ULL, 0x0005220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f62800642a7f8cULL, 0x000fe2000c80043fULL,
0x800000002dff7812ULL, 0x010fc60007844869ULL, 0x00f62c00642f7984ULL, 0x000f240000000800ULL,
0x800000002fff7812ULL, 0x010fe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000ffff677224ULL, 0x008fe200078e0029ULL,
0x000000a000000947ULL, 0x000fea0003800000ULL, 0x0000001040287812ULL, 0x000fe200078ec0ffULL,
0x3e000000ff007424ULL, 0x000fc600078e00ffULL, 0x0000003031287210ULL, 0x000fe40007ffe028ULL,
0x0000000000297305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000290000735dULL, 0x010fe40003800000ULL, 0x00f62c0028297984ULL, 0x000ee40000000800ULL,
0x8000000029ff7812ULL, 0x008fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008045007810ULL, 0x000fca0007ffe04cULL, 0x0000000147007824ULL, 0x000fca00078e0200ULL,
0x00f00000002a7984ULL, 0x000ee80000000800ULL, 0x00f20000002b7984ULL, 0x0008620000000800ULL,
0x0000003b2a00720bULL, 0x008fe20003f1d000ULL, 0x0000bbd27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x010fc800000e0100ULL, 0x0000ffff002e7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff307424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000126297811ULL, 0x000fe400078ff0ffULL,
0x0000003b2a00720bULL, 0x000fe40003f14000ULL, 0x000000262900720cULL, 0x000fe20003f65270ULL,
0x0000bb927f007947ULL, 0x000ff4000b800000ULL, 0x0000000000007806ULL, 0x000fe400000e0100ULL,
0x0000002a3b287209ULL, 0x000fe20007810000ULL, 0x00000080262cb824ULL, 0x000fe200078e0245ULL,
0x0000ffff002d7812ULL, 0x000fe400078e3cffULL, 0x00000002ff377819ULL, 0x000fe20000011641ULL,
0x00000001472fb824ULL, 0x000fe200078e022cULL, 0x800000283b297221ULL, 0x000fe20000010000ULL,
0x0000002d2eff7212ULL, 0x000fc6000780c0ffULL, 0x3fb8aa3b29297820ULL, 0x000fe20000410000ULL,
0x00f400282f00b388ULL, 0x0007e60000000800ULL, 0x0000002900367308ULL, 0x000f240000000800ULL,
0x000000363a3a7220ULL, 0x010fe20000410000ULL, 0x0000bb127f007947ULL, 0x000fea000b800000ULL,
0x00001f3736007589ULL, 0x00872400000e0000ULL, 0x0000000008087220ULL, 0x090fe20000410000ULL,
0x0000000009097220ULL, 0x080fe20000410000ULL, 0x000000001c1c7220ULL, 0x080fe20000410000ULL,
0x000000001d1d7220ULL, 0x080fe20000410000ULL, 0x0000000020207220ULL, 0x080fe20000410000ULL,
0x0000000021217220ULL, 0x080fe20000410000ULL, 0x000000000c0c7220ULL, 0x080fe20000410000ULL,
0x000000000d0d7220ULL, 0x080fe20000410000ULL, 0x0000000010107220ULL, 0x080fe20000410000ULL,
0x0000000011117220ULL, 0x080fe20000410000ULL, 0x0000000014147220ULL, 0x080fe20000410000ULL,
0x0000000015157220ULL, 0x080fe20000410000ULL, 0x0000000018187220ULL, 0x080fe20000410000ULL,
0x0000000019197220ULL, 0x080fe20000410000ULL, 0x0000000004047220ULL, 0x080fe20000410000ULL,
0x0000000005057220ULL, 0x000fe20000410000ULL, 0x0000ba527f007947ULL, 0x000fea000b800000ULL,
0x00001f4b36007589ULL, 0x0008a400000e0000ULL, 0x0000002a3b3b7209ULL, 0x000fe20007810000ULL,
0x000000000a0a7220ULL, 0x084fe20000410000ULL, 0x00000001ff307807ULL, 0x000fe20000000000ULL,
0x000000000b0b7220ULL, 0x080fe20000410000ULL, 0x000000001e1e7220ULL, 0x080fe20000410000ULL,
0x8000003b2a2a0221ULL, 0x000fe20000010000ULL, 0x000000001f1f7220ULL, 0x080fe20000410000ULL,
0x0000000022227220ULL, 0x080fe20000410000ULL, 0x0000000023237220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b2a2a0820ULL, 0x000fe20000410000ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x0000000012127220ULL, 0x080fe20000410000ULL,
0x0000002a00420308ULL, 0x000ea20000000800ULL, 0x0000000013137220ULL, 0x080fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x0000000017177220ULL, 0x080fe20000410000ULL,
0x000000001a1a7220ULL, 0x080fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x0000000006067220ULL, 0x080fe20000410000ULL, 0x0000000007077220ULL, 0x000fe20000410000ULL,
0x0000002b422b0220ULL, 0x006fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000003a2b3a7221ULL, 0x002fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x0000000827007824ULL, 0x000fe200078e00ffULL,
0xfffffff040297812ULL, 0x000fc800078ec0ffULL, 0x0000000800007812ULL, 0x000fca00078e0cffULL,
0x0000000129287824ULL, 0x000fca00078e0200ULL, 0x00f6ac0028297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000297305ULL, 0x000364000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000290000735dULL, 0x020fe40003800000ULL, 0x00f6ac0028297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fc40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff377819ULL, 0x008fe40000011641ULL, 0x00000042ff00723eULL, 0x000fe400000000ffULL,
0x00000018372a7810ULL, 0x040fe40007ffe0ffULL, 0x00000010372b7810ULL, 0x000fe40007ffe0ffULL,
0x0000541000367816ULL, 0x010fe20000000000ULL, 0x0000b7a27f007947ULL, 0x000fea000b800000ULL,
0x00001f37366b7589ULL, 0x0002e400000e0000ULL, 0x0000b7e27f007947ULL, 0x000fea000b800000ULL,
0x00001f4b36007589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff377224ULL, 0x002fe200078e002bULL, 0x000037b000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x0000c26000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff377224ULL, 0x002fe200078e002aULL, 0x0000381000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x0000c20000007944ULL, 0x01cfea0003c00000ULL, 0x0000100027317824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100026287824ULL, 0x000fe200078e00ffULL,
0x0000991030307816ULL, 0x000fe400000000ffULL, 0x0000100031317812ULL, 0x000fe400078e0cffULL,
0xffffe00028287812ULL, 0x000fc400078ec0ffULL, 0x000000ff3000720cULL, 0x000fe40003f05270ULL,
0x0000b00028687810ULL, 0x100fe40007ffe031ULL, 0x009800004d28783bULL, 0x000f620000000200ULL,
0x0000b0003c537810ULL, 0x000fe40007ffe031ULL, 0x000000106a697824ULL, 0x100fe400078e0268ULL,
0x0000001055687824ULL, 0x000fe400078e0268ULL, 0x0000001052597824ULL, 0x100fe200078e0253ULL,
0x00000000692c783bULL, 0x000f220000004200ULL, 0x000000104f537824ULL, 0x000fc600078e0253ULL,
0x000000006834783bULL, 0x016e620000004200ULL, 0x0000006b28288232ULL, 0x0a8fe40000000000ULL,
0x0000006b2a2a8232ULL, 0x000fe40000000000ULL, 0x0000000029298232ULL, 0x080fe40000000000ULL,
0x000000002b2b8232ULL, 0x000fe20000000000ULL, 0x000031202c2c7816ULL, 0x000fe400000000ffULL,
0x000031202d2d7816ULL, 0x000fc400000000ffULL, 0x0000002cff32723eULL, 0x080fe400020006ffULL,
0x0000002dff33723eULL, 0x080fe400020006ffULL, 0x0000002cff2c723eULL, 0x000fe400030006ffULL,
0x0000002dff2d723eULL, 0x000fe400030006ffULL, 0x000031202f6f7816ULL, 0x000fe200000000ffULL,
0x000000322808723cULL, 0x000fe20000001808ULL, 0x000031202e307816ULL, 0x000fc400000000ffULL,
0x0000312034347816ULL, 0x002fe400000000ffULL, 0x00000030ff6e723eULL, 0x000fe400030006ffULL,
0x0000312035357816ULL, 0x000fe200000000ffULL, 0x0000002c281c723cULL, 0x000fe2000000181cULL,
0x00003120366d7816ULL, 0x000fcc00000000ffULL, 0x0000006fff2d723eULL, 0x080fe400020006ffULL,
0x0000006fff6f723eULL, 0x000fe400030006ffULL, 0x00000030ff2c723eULL, 0x000fe400020006ffULL,
0x000000005930783bULL, 0x000e660000004200ULL, 0x0000006e280c723cULL, 0x040fee000000180cULL,
0x00000034ff6e723eULL, 0x080fe200020006ffULL, 0x0000002c2820723cULL, 0x000fe20000001820ULL,
0x00000035ff6f723eULL, 0x000fe200020006ffULL, 0x009800004e2c783bULL, 0x000ea20000000200ULL,
0x00000034ff34723eULL, 0x000fc400030006ffULL, 0x00000035ff35723eULL, 0x000fc600030006ffULL,
0x0000006e2810723cULL, 0x040fee0000001810ULL, 0x00003120376f7816ULL, 0x000fe200000000ffULL,
0x000000342814723cULL, 0x000fe20000001814ULL, 0x0000006dff6e723eULL, 0x000fcc00030006ffULL,
0x0000006dff34723eULL, 0x000fe400020006ffULL, 0x0000006fff35723eULL, 0x080fe400020006ffULL,
0x0000006fff6f723eULL, 0x000fe400030006ffULL, 0x0000312030307816ULL, 0x002fe400000000ffULL,
0x0000312031317816ULL, 0x000fe200000000ffULL, 0x000000342818723cULL, 0x000fe20000001818ULL,
0x000000005334783bULL, 0x000e620000004200ULL, 0x0000312032327816ULL, 0x000fc400000000ffULL,
0x0000312033337816ULL, 0x000fc800000000ffULL, 0x0000006e2804723cULL, 0x000fe20000001804ULL,
0x0000006b2c2c8232ULL, 0x084fe40000000000ULL, 0x0000006b2e2e8232ULL, 0x000fe40000000000ULL,
0x000000002d2d8232ULL, 0x080fe40000000000ULL, 0x00000030ff28723eULL, 0x080fe200020006ffULL,
0x000000002f2f8232ULL, 0x000fe20000000000ULL, 0x00000031ff29723eULL, 0x000fe400020006ffULL,
0x00000030ff30723eULL, 0x000fc400030006ffULL, 0x00000031ff31723eULL, 0x000fc600030006ffULL,
0x000000282c08723cULL, 0x040fee0000001808ULL, 0x00000032ff28723eULL, 0x080fe200020006ffULL,
0x000000302c1c723cULL, 0x000fe2000000181cULL, 0x00000033ff29723eULL, 0x000fe400020006ffULL,
0x00000032ff32723eULL, 0x000fc400030006ffULL, 0x00000033ff33723eULL, 0x000fc600030006ffULL,
0x000000282c20723cULL, 0x040fe20000001820ULL, 0x0000312034347816ULL, 0x002fe400000000ffULL,
0x0000312035357816ULL, 0x000fe400000000ffULL, 0x0000312036367816ULL, 0x000fe400000000ffULL,
0x00000034ff28723eULL, 0x000fe200020006ffULL, 0x000000322c0c723cULL, 0x000fe2000000180cULL,
0x00000035ff29723eULL, 0x000fe400020006ffULL, 0x0000312037377816ULL, 0x000fc400000000ffULL,
0x00000034ff34723eULL, 0x000fe400030006ffULL, 0x00000035ff35723eULL, 0x000fe200030006ffULL,
0x000000282c10723cULL, 0x040fee0000001810ULL, 0x00000036ff28723eULL, 0x000fe200020006ffULL,
0x000000342c14723cULL, 0x000fe20000001814ULL, 0x00000037ff29723eULL, 0x000fc400020006ffULL,
0x00000036ff36723eULL, 0x000fe400030006ffULL, 0x00000037ff37723eULL, 0x000fc600030006ffULL,
0x000000282c18723cULL, 0x040ff00000001818ULL, 0x000000362c04723cULL, 0x000fe20000001804ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200039287f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000080502b7810ULL, 0x000fe20007ffe0ffULL, 0x00f6900051ff7f8cULL, 0x0007e2000c80043fULL,
0x00000001276b7812ULL, 0x000fc400078ec0ffULL, 0x000000242b00720cULL, 0x000fda0003f06070ULL,
0x00002a0000000947ULL, 0x000fea0003800000ULL, 0x0000040061007984ULL, 0x008ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804829ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240039007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000287305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000280000735dULL, 0x008fe40003800000ULL,
0x0000240039287984ULL, 0x000ea40000000800ULL, 0x8000000028ff7812ULL, 0x004fc40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000165657824ULL, 0x000fe400078e0266ULL,
0x00000300ff007624ULL, 0x000fe400078e00ffULL, 0x000058003f2a7a24ULL, 0x000fe200078e02ffULL,
0x0000000165287812ULL, 0x000fe200078ec0ffULL, 0xffffffffff3f7424ULL, 0x000fe200078e00ffULL,
0xffffffff00007811ULL, 0x000fe400078e08ffULL, 0x000000012800780cULL, 0x000fc80003f05070ULL,
0x0000000100667807ULL, 0x000fca0004000000ULL, 0x0000000165007824ULL, 0x000fca00078e0266ULL,
0x000000030000720cULL, 0x000fe40003f06070ULL, 0x00000001ff437819ULL, 0x000fca0000011626ULL,
0x0000002043007824ULL, 0x000fcc00078e0250ULL, 0x0000006638288210ULL, 0x000fe20007ffe065ULL,
0x00000004ff298424ULL, 0x000fe200078e00ffULL, 0x000000c000007810ULL, 0x000fc60007ffe0ffULL,
0x0000600028288625ULL, 0x000fe200078e0029ULL, 0x00000000242b7217ULL, 0x000fe40007800000ULL,
0x00000001252d7810ULL, 0x000fe40007ffe0ffULL, 0x00000006283f8981ULL, 0x000562000c1e1900ULL,
0x000000012b2b7824ULL, 0x000fe200078e0a00ULL, 0x000000022d00720cULL, 0x000fe20003f46070ULL,
0x000000802a2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff0402e7812ULL, 0x000fe200078ec0ffULL,
0x00000010262c7824ULL, 0x000fe200078e00ffULL, 0x000000085c337812ULL, 0x000fc400078ec0ffULL,
0x000000202b2b7807ULL, 0x000fe20001000000ULL, 0x000000002e0573c2ULL, 0x000ee200000e0000ULL,
0x000000603d297812ULL, 0x004fe400078ef800ULL, 0x000000102c2c7812ULL, 0x000fe400078ec0ffULL,
0x00000008336e7812ULL, 0x000fe200078e3cffULL, 0x0000000144007824ULL, 0x100fe200078e0229ULL,
0x0000002b2c2b7217ULL, 0x000fe20007800000ULL, 0x0000000146287824ULL, 0x100fe200078e0229ULL,
0x000000006e0473c2ULL, 0x000ea200000e0000ULL, 0x00000001482a7824ULL, 0x100fe200078e0229ULL,
0x000000002d007210ULL, 0x040fe20007f1e0ffULL, 0x000000014a297824ULL, 0x000fe200078e0229ULL,
0x000000282d287210ULL, 0x000fe20007f5e0ffULL, 0x000000012b2b7824ULL, 0x000fe200078e0a2cULL,
0x0000002a2d2a7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff317224ULL, 0x000fe200000e06ffULL,
0x00005e0000327a11ULL, 0x040fe200078038ffULL, 0x000000ffff2f7224ULL, 0x000fe200010e06ffULL,
0x000000292d297210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200018e06ffULL,
0x00005f0000317a11ULL, 0x000fc400000f3c31ULL, 0x00005e0028307a11ULL, 0x000fe200078038ffULL,
0x000000ffff007224ULL, 0x000fe200020e06ffULL, 0x00000003ff347819ULL, 0x000fe20000011641ULL,
0x0000f6a805057890ULL, 0x008fe2000fffe03fULL, 0x00005e002a2c7a11ULL, 0x000fe400078438ffULL,
0x00005f00282f7a11ULL, 0x000fe400000f3c2fULL, 0x0000002b3400720cULL, 0x000fe40003f06070ULL,
0x00005f002a2d7a11ULL, 0x000fe200010f3c2dULL, 0x0000000405047290ULL, 0x004fe2000fffe03fULL,
0x00005e00292e7a11ULL, 0x000fc400078638ffULL, 0x0000004532287210ULL, 0x000fe40007f5e0ffULL,
0x00000008342a7810ULL, 0x040fe40007ffe0ffULL, 0x0000000434327810ULL, 0x040fe40007ffe0ffULL,
0x00005f0029007a11ULL, 0x000fe200018f3c00ULL, 0x000000ffff297224ULL, 0x000fe200010e0631ULL,
0x0000000c34347810ULL, 0x000fe40007ffe0ffULL, 0x0000002b2a00720cULL, 0x000fc40003f66070ULL,
0x00000045302a7210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000285f7faeULL, 0x0005e2000c101c46ULL, 0x0000002b3200720cULL, 0x080fe40003f86070ULL,
0x0000002b3400720cULL, 0x000fe20003f46070ULL, 0x000000ffff2b7224ULL, 0x000fe200028e062fULL,
0x000000452c2c7210ULL, 0x080fe40007f1e0ffULL, 0x000000452e2e7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff2d7224ULL, 0x000fe400000e062dULL, 0x000000ffff2f7224ULL, 0x000fe400028e0600ULL,
0x000000002a587faeULL, 0x0005e8000e101c46ULL, 0x000000002c607faeULL, 0x0005e8000d901c46ULL,
0x000000002e627faeULL, 0x0005e8000d101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000006e6e7f8cULL, 0x000ee8000c800405ULL,
0x0000040533007984ULL, 0x0008620008000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480063287f8cULL, 0x004fe2000c80043fULL,
0x8000000000ff7812ULL, 0x002fc60007844867ULL, 0x00f64c00632b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe40007804829ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0xffffffe0402a7812ULL, 0x040fe200078ec0ffULL, 0x3e000000ff007424ULL, 0x000fe200078e00ffULL,
0x00000010402b7812ULL, 0x040fe400078ec0ffULL, 0x00000008402c7812ULL, 0x000fc800078ec0ffULL,
0x0000002a2c2a7210ULL, 0x000fe40007ffe02bULL, 0x00000000002b7305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x0000002b0000735dULL, 0x004fe40003800000ULL,
0x00f64c002a2b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010045007810ULL, 0x000fca0007ffe04cULL,
0x0000000147007824ULL, 0x000fca00078e0200ULL, 0x00f00000002a7984ULL, 0x000e680000000800ULL,
0x00f20000002b7984ULL, 0x0005220000000800ULL, 0x0000003b2a00720bULL, 0x002fe20003f1d000ULL,
0x0000a8227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x004fc800000e0100ULL,
0x0000ffff002e7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff307424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000226297811ULL, 0x000fe400078ff0ffULL, 0x0000003b2a00720bULL, 0x000fe40003f14000ULL,
0x000000262900720cULL, 0x000fe20003f65270ULL, 0x0000a7e27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000007806ULL, 0x000fe400000e0100ULL, 0x0000002a3b287209ULL, 0x000fe20007810000ULL,
0x00000080262cb824ULL, 0x000fe200078e0245ULL, 0x0000ffff002d7812ULL, 0x000fe400078e3cffULL,
0x00000002ff377819ULL, 0x000fe20000011641ULL, 0x00000001472fb824ULL, 0x000fe200078e022cULL,
0x800000283b297221ULL, 0x000fe20000010000ULL, 0x0000002d2eff7212ULL, 0x000fc6000780c0ffULL,
0x3fb8aa3b29297820ULL, 0x000fe20000410000ULL, 0x00f400282f00b388ULL, 0x0003e60000000800ULL,
0x0000002900367308ULL, 0x000ea40000000800ULL, 0x000000363a3a7220ULL, 0x004fe20000410000ULL,
0x0000a7627f007947ULL, 0x000fea000b800000ULL, 0x00001f3736007589ULL, 0x0022a400000e0000ULL,
0x0000000008087220ULL, 0x084fe20000410000ULL, 0x0000000009097220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x0000000020207220ULL, 0x080fe20000410000ULL, 0x0000000021217220ULL, 0x080fe20000410000ULL,
0x000000000c0c7220ULL, 0x080fe20000410000ULL, 0x000000000d0d7220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x080fe20000410000ULL,
0x0000000014147220ULL, 0x080fe20000410000ULL, 0x0000000015157220ULL, 0x080fe20000410000ULL,
0x0000000018187220ULL, 0x080fe20000410000ULL, 0x0000000019197220ULL, 0x080fe20000410000ULL,
0x0000000004047220ULL, 0x080fe20000410000ULL, 0x0000000005057220ULL, 0x000fe20000410000ULL,
0x0000a6a27f007947ULL, 0x000fea000b800000ULL, 0x00001f4b36007589ULL, 0x00046400000e0000ULL,
0x0000002a3b3b7209ULL, 0x000fe20007810000ULL, 0x000000000a0a7220ULL, 0x082fe20000410000ULL,
0x00000001ff307807ULL, 0x000fe20000000000ULL, 0x000000000b0b7220ULL, 0x080fe20000410000ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x8000003b2a2a0221ULL, 0x000fe20000010000ULL,
0x000000001f1f7220ULL, 0x080fe20000410000ULL, 0x0000000022227220ULL, 0x080fe20000410000ULL,
0x0000000023237220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b2a2a0820ULL, 0x000fe20000410000ULL,
0x000000000e0e7220ULL, 0x080fe20000410000ULL, 0x000000000f0f7220ULL, 0x080fe20000410000ULL,
0x0000000012127220ULL, 0x080fe20000410000ULL, 0x0000002a00420308ULL, 0x000e620000000800ULL,
0x0000000013137220ULL, 0x080fe20000410000ULL, 0x0000000016167220ULL, 0x080fe20000410000ULL,
0x0000000017177220ULL, 0x080fe20000410000ULL, 0x000000001a1a7220ULL, 0x080fe20000410000ULL,
0x000000001b1b7220ULL, 0x080fe20000410000ULL, 0x0000000006067220ULL, 0x080fe20000410000ULL,
0x0000000007077220ULL, 0x000fe20000410000ULL, 0x0000002b422b0220ULL, 0x012fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0000003a2b3a7221ULL, 0x010fe20000010000ULL, 0x000000f000002947ULL, 0x000fea0003800000ULL,
0x000000085c297812ULL, 0x000fe400078ec0ffULL, 0xfffffff040007812ULL, 0x000fca00078ec0ffULL,
0x0000000100297824ULL, 0x000fca00078e0229ULL, 0x00f6ac0029007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000287305ULL, 0x000324000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000280000735dULL, 0x010fe40003800000ULL, 0x00f6ac0029287984ULL, 0x000e640000000800ULL,
0x8000000028ff7812ULL, 0x002fc40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff377819ULL, 0x000fe40000011641ULL, 0x00000042ff00723eULL, 0x000fe400000000ffULL,
0x00000018372a7810ULL, 0x040fe40007ffe0ffULL, 0x00000010372b7810ULL, 0x000fe40007ffe0ffULL,
0x0000541000367816ULL, 0x004fe20000000000ULL, 0x0000a4027f007947ULL, 0x000fea000b800000ULL,
0x00001f37365f7589ULL, 0x0002a400000e0000ULL, 0x0000a4427f007947ULL, 0x000fea000b800000ULL,
0x00001f4b36007589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff377224ULL, 0x002fe200078e002bULL, 0x00004d9000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x0000ac8000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff377224ULL, 0x002fe200078e002aULL, 0x00004df000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x0000ac2000007944ULL, 0x03cfea0003c00000ULL, 0x0000100026287824ULL, 0x000fe200078e00ffULL,
0x000010006c337812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000991030307816ULL, 0x000fe400000000ffULL, 0xffffe00028287812ULL, 0x000fe400078ec0ffULL,
0x000000ff3000720cULL, 0x000fc40003f05270ULL, 0x0000b00028317810ULL, 0x100fe40007ffe033ULL,
0x00a000004d28783bULL, 0x000f220000000200ULL, 0x0000b0003c587810ULL, 0x000fe40007ffe033ULL,
0x000000106a2c7824ULL, 0x100fe400078e0231ULL, 0x0000001055347824ULL, 0x004fc800078e0231ULL,
0x000000002c2c783bULL, 0x000ea80000004200ULL, 0x000000003434783bULL, 0x012e620000004200ULL,
0x0000005f28288232ULL, 0x080fe40000000000ULL, 0x0000005f2a2a8232ULL, 0x000fe40000000000ULL,
0x0000000029298232ULL, 0x080fe40000000000ULL, 0x000000002b2b8232ULL, 0x000fe20000000000ULL,
0x000031202c307816ULL, 0x004fc400000000ffULL, 0x000031202d317816ULL, 0x000fe400000000ffULL,
0x00000030ff2c723eULL, 0x080fe400020006ffULL, 0x00000031ff2d723eULL, 0x080fe400020006ffULL,
0x000031202f557816ULL, 0x000fe400000000ffULL, 0x000031202e327816ULL, 0x000fe400000000ffULL,
0x00000030ff30723eULL, 0x000fe200030006ffULL, 0x0000002c2808723cULL, 0x000fe20000001808ULL,
0x00000031ff31723eULL, 0x000fc400030006ffULL, 0x00000032ff54723eULL, 0x080fe400030006ffULL,
0x0000312034347816ULL, 0x002fe400000000ffULL, 0x00000055ff2d723eULL, 0x080fe200020006ffULL,
0x00000030281c723cULL, 0x000fe2000000181cULL, 0x00000055ff55723eULL, 0x000fe400030006ffULL,
0x0000312035357816ULL, 0x000fe400000000ffULL, 0x00000032ff2c723eULL, 0x000fc400020006ffULL,
0x0000001052307824ULL, 0x100fe200078e0258ULL, 0x00000054280c723cULL, 0x000fe2000000180cULL,
0x0000312036527816ULL, 0x000fe200000000ffULL, 0x000000104f367824ULL, 0x000fc600078e0258ULL,
0x000000003030783bULL, 0x000e640000004200ULL, 0x00000034ff54723eULL, 0x080fe200020006ffULL,
0x0000002c2820723cULL, 0x000fe20000001820ULL, 0x00000035ff55723eULL, 0x080fe200020006ffULL,
0x00a000004e2c783bULL, 0x000ea20000000200ULL, 0x00000034ff34723eULL, 0x000fe400030006ffULL,
0x00000035ff35723eULL, 0x000fc600030006ffULL, 0x000000542810723cULL, 0x040fee0000001810ULL,
0x0000312037557816ULL, 0x000fe200000000ffULL, 0x000000342814723cULL, 0x000fe20000001814ULL,
0x00000052ff54723eULL, 0x000fcc00030006ffULL, 0x00000052ff34723eULL, 0x000fe400020006ffULL,
0x00000055ff35723eULL, 0x080fe400020006ffULL, 0x00000055ff55723eULL, 0x000fca00030006ffULL,
0x000000342818723cULL, 0x000fe20000001818ULL, 0x000000003634783bULL, 0x000f220000004200ULL,
0x0000312030307816ULL, 0x002fe400000000ffULL, 0x0000312031317816ULL, 0x000fc800000000ffULL,
0x000000542804723cULL, 0x000fe20000001804ULL, 0x0000312032327816ULL, 0x000fe200000000ffULL,
0x0000005f2c2c8232ULL, 0x084fe20000000000ULL, 0x0000312033337816ULL, 0x000fe200000000ffULL,
0x0000005f2e2e8232ULL, 0x000fe40000000000ULL, 0x000000002d2d8232ULL, 0x080fe20000000000ULL,
0x00000030ff28723eULL, 0x080fe200020006ffULL, 0x000000002f2f8232ULL, 0x000fe20000000000ULL,
0x00000031ff29723eULL, 0x000fe400020006ffULL, 0x00000030ff30723eULL, 0x000fc400030006ffULL,
0x00000031ff31723eULL, 0x000fc600030006ffULL, 0x000000282c08723cULL, 0x040fee0000001808ULL,
0x00000032ff28723eULL, 0x080fe200020006ffULL, 0x000000302c1c723cULL, 0x000fe2000000181cULL,
0x00000033ff29723eULL, 0x000fe400020006ffULL, 0x00000032ff32723eULL, 0x000fc400030006ffULL,
0x00000033ff33723eULL, 0x000fc600030006ffULL, 0x000000282c20723cULL, 0x040fe20000001820ULL,
0x0000312034347816ULL, 0x010fe400000000ffULL, 0x0000312035357816ULL, 0x000fe400000000ffULL,
0x0000312036367816ULL, 0x000fe400000000ffULL, 0x00000034ff28723eULL, 0x000fe200020006ffULL,
0x000000322c0c723cULL, 0x000fe2000000180cULL, 0x00000035ff29723eULL, 0x000fe400020006ffULL,
0x0000312037377816ULL, 0x000fc400000000ffULL, 0x00000034ff34723eULL, 0x000fe400030006ffULL,
0x00000035ff35723eULL, 0x000fe200030006ffULL, 0x000000282c10723cULL, 0x040fee0000001810ULL,
0x00000036ff28723eULL, 0x000fe200020006ffULL, 0x000000342c14723cULL, 0x000fe20000001814ULL,
0x00000037ff29723eULL, 0x000fc400020006ffULL, 0x00000036ff36723eULL, 0x000fe400030006ffULL,
0x00000037ff37723eULL, 0x000fc600030006ffULL, 0x000000282c18723cULL, 0x040ff00000001818ULL,
0x000000362c04723cULL, 0x000fe20000001804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200039287f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c0502b7810ULL, 0x000fe20007ffe0ffULL,
0x00f6980051ff7f8cULL, 0x0009e2000c80043fULL, 0x0000000165547824ULL, 0x000fe200078e0266ULL,
0x00000001276b7812ULL, 0x000fe200078e0cffULL, 0x000000ffff677224ULL, 0x008fe200078e006fULL,
0x000000242b00720cULL, 0x000fda0003f06070ULL, 0x0000141000000947ULL, 0x000fea0003800000ULL,
0x0000040061007984ULL, 0x010ee40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804829ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000240039007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000287305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000280000735dULL, 0x008fe40003800000ULL, 0x0000240039287984ULL, 0x000ea40000000800ULL,
0x8000000028ff7812ULL, 0x004fc40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000f6a843337811ULL, 0x000fe200078e20ffULL, 0x000058003f2a7a24ULL, 0x020fe200078e02ffULL,
0x0000030025007a10ULL, 0x000fe20007ffe0ffULL, 0x00000000570473c2ULL, 0x0004e200000e0000ULL,
0x00000001ff437819ULL, 0x000fe20000011626ULL, 0x000000802a2d7824ULL, 0x000fe200078e00ffULL,
0x0000000100297810ULL, 0x040fe40007ffe0ffULL, 0x00000003ff317819ULL, 0x000fe20000011641ULL,
0x0000000800287824ULL, 0x000fe200078e0243ULL, 0x000000022900720cULL, 0x000fe20003f06070ULL,
0x0000001026007824ULL, 0x000fe200078e00ffULL, 0x0000000431377810ULL, 0x040fe20007ffe0ffULL,
0x0000002028287824ULL, 0x000fe200078e00ffULL, 0x0000000831357810ULL, 0x000fc40007ffe0ffULL,
0x0000001000007812ULL, 0x000fe400078ec0ffULL, 0x00000028242b7217ULL, 0x000fe40007800000ULL,
0x000000603d297812ULL, 0x100fe400078ef828ULL, 0x000000085c5c7812ULL, 0x000fe200078ec0ffULL,
0x000000012b2b7824ULL, 0x000fe400078e0a28ULL, 0x0000000144447824ULL, 0x100fe400078e0229ULL,
0x0000000146467824ULL, 0x100fe200078e0229ULL, 0x000000202b2b7807ULL, 0x000fe20000000000ULL,
0x0000000148487824ULL, 0x100fe200078e0229ULL, 0x000000442d447210ULL, 0x000fe20007f5e0ffULL,
0x000000014a297824ULL, 0x000fe200078e0229ULL, 0x0000002b002b7217ULL, 0x000fc40007800000ULL,
0x000000462d467210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200010e06ffULL,
0x00005e0044287a11ULL, 0x040fe200078038ffULL, 0x000000012b007824ULL, 0x000fe200078e0a00ULL,
0x000000482d487210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200018e06ffULL,
0x000000292d2d7210ULL, 0x000fe40007f9e0ffULL, 0x00005f0044297a11ULL, 0x000fe200000f3c2fULL,
0x000000ffff2f7224ULL, 0x000fe200010e06ffULL, 0x00005e00462a7a11ULL, 0x000fe200078038ffULL,
0x000000ffff307224ULL, 0x000fe200020e06ffULL, 0x00005e00482c7a11ULL, 0x000fc400078438ffULL,
0x00005f00462b7a11ULL, 0x000fe400000f3c2bULL, 0x000000452a2a7210ULL, 0x080fe40007fbe0ffULL,
0x000000003100720cULL, 0x0c0fe40003f66070ULL, 0x0000004528287210ULL, 0x000fe20007fde0ffULL,
0x000000ffff2b7224ULL, 0x000fe200028e062bULL, 0x0000000c31317810ULL, 0x000fe40007ffe0ffULL,
0x00005f00482f7a11ULL, 0x000fe200010f3c2fULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x000000003700720cULL, 0x000fc40003f46070ULL, 0x00005e002d2e7a11ULL, 0x000fe400078838ffULL,
0x000000003500720cULL, 0x080fe20003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000285b7faeULL, 0x0009e2000d901c46ULL, 0x000000003100720cULL, 0x000fe40003fa6070ULL,
0x000000452c2c7210ULL, 0x080fe40007fde0ffULL, 0x00005f002d007a11ULL, 0x000fe200020f3c30ULL,
0x0000000133307824ULL, 0x000fe200078e025cULL, 0x000000452e2e7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200030e062fULL, 0x000000002a5a7faeULL, 0x0009e6000d101c46ULL,
0x000000ffff2f7224ULL, 0x000fe200020e0600ULL, 0x000000002c5e7faeULL, 0x0009e8000c101c46ULL,
0x000000002e5d7faeULL, 0x0009e8000e901c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x008fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000030287f8cULL, 0x0104e8000c80043fULL,
0x00000400562d7984ULL, 0x0005220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f66800642a7f8cULL, 0x000fe2000c80043fULL,
0x800000002dff7812ULL, 0x010fc6000784486fULL, 0x00f66c00642f7984ULL, 0x000f240000000800ULL,
0x800000002fff7812ULL, 0x010fe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x000000ffff677224ULL, 0x008fe200078e0029ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000287305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000280000735dULL, 0x010fe20003800000ULL, 0x00f66c0064297984ULL, 0x000ee40000000800ULL,
0x8000000029ff7812ULL, 0x008fc4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000180454c7810ULL, 0x000fca0007ffe04cULL, 0x00000001474c7824ULL, 0x000fca00078e024cULL,
0x00f000004c007984ULL, 0x000ee80000000800ULL, 0x00f200004c2b7984ULL, 0x0008620000000800ULL,
0x0000003b0000720bULL, 0x008fe20003f1d000ULL, 0x000095927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000287806ULL, 0x010fc800000e0100ULL, 0x0000ffff282a7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2c7424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000326297811ULL, 0x000fe400078ff0ffULL,
0x0000003b0000720bULL, 0x000fe40003f14000ULL, 0x000000262900720cULL, 0x000fe20003f65270ULL,
0x000095527f007947ULL, 0x000ff4000b800000ULL, 0x0000000000287806ULL, 0x000fe400000e0100ULL,
0x000000003b2e7209ULL, 0x000fe20007810000ULL, 0x00000080262cb824ULL, 0x000fe200078e0245ULL,
0x0000ffff282d7812ULL, 0x000fe400078e3cffULL, 0x00000002ff377819ULL, 0x000fe20000011641ULL,
0x000000014747b824ULL, 0x000fe200078e022cULL, 0x8000002e3b297221ULL, 0x000fe20000010000ULL,
0x0000002d2aff7212ULL, 0x000fc6000780c0ffULL, 0x3fb8aa3b29297820ULL, 0x000fe20000410000ULL,
0x00f4002e4700b388ULL, 0x0007e60000000800ULL, 0x0000002900367308ULL, 0x000f240000000800ULL,
0x000000363a3a7220ULL, 0x010fe20000410000ULL, 0x000094d27f007947ULL, 0x000fea000b800000ULL,
0x00001f3736287589ULL, 0x00872400000e0000ULL, 0x0000002808087220ULL, 0x090fe20000410000ULL,
0x0000002809097220ULL, 0x080fe20000410000ULL, 0x000000281c1c7220ULL, 0x080fe20000410000ULL,
0x000000281d1d7220ULL, 0x080fe20000410000ULL, 0x0000002820207220ULL, 0x080fe20000410000ULL,
0x0000002821217220ULL, 0x080fe20000410000ULL, 0x000000280c0c7220ULL, 0x080fe20000410000ULL,
0x000000280d0d7220ULL, 0x080fe20000410000ULL, 0x0000002810107220ULL, 0x080fe20000410000ULL,
0x0000002811117220ULL, 0x080fe20000410000ULL, 0x0000002814147220ULL, 0x080fe20000410000ULL,
0x0000002815157220ULL, 0x080fe20000410000ULL, 0x0000002818187220ULL, 0x080fe20000410000ULL,
0x0000002819197220ULL, 0x080fe20000410000ULL, 0x0000002804047220ULL, 0x080fe20000410000ULL,
0x0000002805057220ULL, 0x000fe20000410000ULL, 0x000094127f007947ULL, 0x000fea000b800000ULL,
0x00001f4b36287589ULL, 0x0008a400000e0000ULL, 0x8000002e00000221ULL, 0x100fe20000010000ULL,
0x00000001ff2c7807ULL, 0x000fe20000000000ULL, 0x000000280a0a7220ULL, 0x084fe20000410000ULL,
0x000000280b0b7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b00000820ULL, 0x000fe20000410000ULL,
0x000000281e1e7220ULL, 0x080fe20000410000ULL, 0x000000281f1f7220ULL, 0x080fe20000410000ULL,
0x0000002822227220ULL, 0x080fe20000410000ULL, 0x0000000000420308ULL, 0x000ea20000000800ULL,
0x0000002823237220ULL, 0x080fe20000410000ULL, 0x000000280e0e7220ULL, 0x080fe20000410000ULL,
0x000000280f0f7220ULL, 0x080fe20000410000ULL, 0x0000002812127220ULL, 0x080fe20000410000ULL,
0x0000002813137220ULL, 0x080fe20000410000ULL, 0x0000002816167220ULL, 0x080fe20000410000ULL,
0x0000002817177220ULL, 0x080fe20000410000ULL, 0x000000281a1a7220ULL, 0x080fe20000410000ULL,
0x000000281b1b7220ULL, 0x080fe20000410000ULL, 0x0000002806067220ULL, 0x080fe20000410000ULL,
0x0000002807077220ULL, 0x000fe20000410000ULL, 0x000000ffff3b7224ULL, 0x000fe200078e002eULL,
0x0000002b422b0220ULL, 0x006fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000003a2b3a7221ULL, 0x002fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x0000000827007824ULL, 0x000fe200078e00ffULL,
0xfffffff040297812ULL, 0x000fc800078ec0ffULL, 0x0000000800007812ULL, 0x000fca00078e0cffULL,
0x0000000129287824ULL, 0x000fca00078e0200ULL, 0x00f6ac0028297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000297305ULL, 0x000364000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000290000735dULL, 0x020fe40003800000ULL, 0x00f6ac0028297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fc4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff377819ULL, 0x008fe40000011641ULL, 0x00000042ff00723eULL, 0x000fe400000000ffULL,
0x00000018372a7810ULL, 0x040fe40007ffe0ffULL, 0x00000010372b7810ULL, 0x000fe40007ffe0ffULL,
0x0000541000367816ULL, 0x010fe20000000000ULL, 0x000091627f007947ULL, 0x000fea000b800000ULL,
0x00001f37362d7589ULL, 0x0002e400000e0000ULL, 0x000091a27f007947ULL, 0x000fea000b800000ULL,
0x00001f4b36007589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff377224ULL, 0x002fe200078e002bULL, 0x0000627000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x000097a000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff377224ULL, 0x002fe200078e002aULL, 0x000062d000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x0000974000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006930783bULL, 0x004ea20000004200ULL, 0x000099102c2c7816ULL, 0x000fc600000000ffULL,
0x00a800004d28783bULL, 0x000f620000000200ULL, 0x000000ff2c00720cULL, 0x000fc60003f05270ULL,
0x000000006834783bULL, 0x012e680000004200ULL, 0x000000005958783bULL, 0x000fe80000004200ULL,
0x00a800004e4c783bULL, 0x000f220000000200ULL, 0x0000312030307816ULL, 0x004fe400000000ffULL,
0x0000312031317816ULL, 0x000fc400000000ffULL, 0x00000030ff2e723eULL, 0x080fe200020006ffULL,
0x0000002d28288232ULL, 0x0a8fe20000000000ULL, 0x00000031ff2f723eULL, 0x080fe200020006ffULL,
0x0000002d2a2a8232ULL, 0x000fe20000000000ULL, 0x0000312032327816ULL, 0x000fe200000000ffULL,
0x0000000029298232ULL, 0x080fe20000000000ULL, 0x0000312033337816ULL, 0x000fe200000000ffULL,
0x000000002b2b8232ULL, 0x000fe20000000000ULL, 0x00000030ff30723eULL, 0x000fe400030006ffULL,
0x00000031ff31723eULL, 0x000fc400030006ffULL, 0x0000312034347816ULL, 0x002fe200000000ffULL,
0x0000002d4c4c8232ULL, 0x090fe20000000000ULL, 0x0000002e2808723cULL, 0x040fe20000001808ULL,
0x0000312035357816ULL, 0x000fe200000000ffULL, 0x0000002d4e4e8232ULL, 0x000fe20000000000ULL,
0x0000312036367816ULL, 0x000fe200000000ffULL, 0x000000004d4d8232ULL, 0x080fe20000000000ULL,
0x0000312037377816ULL, 0x000fe200000000ffULL, 0x000000004f4f8232ULL, 0x000fe20000000000ULL,
0x00000032ff2e723eULL, 0x000fe200020006ffULL, 0x00000030281c723cULL, 0x000fe2000000181cULL,
0x00000033ff2f723eULL, 0x000fc400020006ffULL, 0x00000032ff32723eULL, 0x000fe400030006ffULL,
0x00000033ff33723eULL, 0x000fe400030006ffULL, 0x0000312058587816ULL, 0x000fe200000000ffULL,
0x0000002e2820723cULL, 0x000fe20000001820ULL, 0x0000312059597816ULL, 0x000fe400000000ffULL,
0x000031205a5a7816ULL, 0x000fe400000000ffULL, 0x000031205b5b7816ULL, 0x000fc400000000ffULL,
0x00000034ff2e723eULL, 0x080fe200020006ffULL, 0x00000032280c723cULL, 0x000fe2000000180cULL,
0x000000005330783bULL, 0x000e620000004200ULL, 0x00000035ff2f723eULL, 0x080fe400020006ffULL,
0x00000034ff34723eULL, 0x000fe400030006ffULL, 0x00000035ff35723eULL, 0x000fc600030006ffULL,
0x0000002e2810723cULL, 0x040fee0000001810ULL, 0x00000036ff2e723eULL, 0x080fe200020006ffULL,
0x000000342814723cULL, 0x000fe20000001814ULL, 0x00000037ff2f723eULL, 0x000fe400020006ffULL,
0x00000036ff36723eULL, 0x000fc400030006ffULL, 0x00000037ff37723eULL, 0x000fc600030006ffULL,
0x0000002e2818723cULL, 0x040ff00000001818ULL, 0x000000362828723cULL, 0x000fee0000001804ULL,
0x00000058ff04723eULL, 0x000fc400020006ffULL, 0x00000059ff05723eULL, 0x000fe400020006ffULL,
0x0000312030307816ULL, 0x002fe400000000ffULL, 0x0000312031317816ULL, 0x000fe400000000ffULL,
0x0000312032327816ULL, 0x000fe200000000ffULL, 0x000000044c08723cULL, 0x000fe20000001808ULL,
0x0000312033337816ULL, 0x000fe400000000ffULL, 0x00000058ff58723eULL, 0x000fc400030006ffULL,
0x00000059ff59723eULL, 0x000fe400030006ffULL, 0x0000005aff04723eULL, 0x080fe400020006ffULL,
0x0000005bff05723eULL, 0x080fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe200030006ffULL,
0x000000584c1c723cULL, 0x000fe2000000181cULL, 0x0000005bff5b723eULL, 0x000fce00030006ffULL,
0x000000044c20723cULL, 0x040fee0000001820ULL, 0x00000030ff04723eULL, 0x080fe200020006ffULL,
0x0000005a4c0c723cULL, 0x000fe2000000180cULL, 0x00000031ff05723eULL, 0x000fe400020006ffULL,
0x00000030ff30723eULL, 0x000fc400030006ffULL, 0x00000031ff31723eULL, 0x000fc600030006ffULL,
0x000000044c10723cULL, 0x040fee0000001810ULL, 0x00000032ff04723eULL, 0x000fe200020006ffULL,
0x000000304c14723cULL, 0x000fe20000001814ULL, 0x00000033ff05723eULL, 0x000fce00020006ffULL,
0x000000044c18723cULL, 0x000fee0000001818ULL, 0x00000032ff04723eULL, 0x000fe400030006ffULL,
0x00000033ff05723eULL, 0x000fce00030006ffULL, 0x000000044c04723cULL, 0x000fe20000001828ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200039287f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a00051ff7f8cULL, 0x0007e2000c80043fULL, 0x0000000165547824ULL, 0x000fe200078e0266ULL,
0x00000001276b7812ULL, 0x000fe400078ec0ffULL, 0x0000030025257a10ULL, 0x018fc80007ffe0ffULL,
0x000000022500720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffa5b000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x004ea20000002500ULL,
0x000000ffff2f7224ULL, 0x000fe400078e001aULL, 0x000000ffff2c7224ULL, 0x000fe400078e0017ULL,
0x000000ffff307224ULL, 0x000fe400078e001bULL, 0x000000ffff2a7224ULL, 0x008fe400078e0015ULL,
0x000000ffff287224ULL, 0x000fe400078e0013ULL, 0x000000ffff247224ULL, 0x000fc400078e0011ULL,
0x000000ffff1a7224ULL, 0x000fe400078e000fULL, 0x000000ffff177224ULL, 0x000fe400078e000dULL,
0x000000ffff347224ULL, 0x000fe400078e0007ULL, 0x000000ffff337224ULL, 0x000fe400078e0006ULL,
0x000000ffff327224ULL, 0x000fe400078e0005ULL, 0x000000ffff317224ULL, 0x000fe200078e0004ULL,
0x0000000402007c0cULL, 0x004fe2000bf03070ULL, 0x000000ffff2e7224ULL, 0x000fc400078e0019ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0018ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0016ULL,
0x000000ffff297224ULL, 0x000fe400078e0014ULL, 0x000000ffff277224ULL, 0x000fe400078e0012ULL,
0x000000ffff257224ULL, 0x000fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fc400078e000eULL,
0x000000ffff157224ULL, 0x000fe400078e000cULL, 0x000000ffff137224ULL, 0x000fe400078e000bULL,
0x000000ffff117224ULL, 0x000fe400078e000aULL, 0x000000ffff0f7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0008ULL, 0x0000037000000947ULL, 0x000fea0003800000ULL,
0x018000003a007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x00006b3000047802ULL, 0x000fe40000000f00ULL,
0x00008d3000007944ULL, 0x022fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003a00037308ULL, 0x000ea40000001000ULL, 0xbf80000003007423ULL, 0x004fc8000000003aULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000f28000c1e9900ULL,
0x0000000000047919ULL, 0x000ee80000000000ULL, 0x0000000000077919ULL, 0x000ea20000000000ULL,
0x00000002ff067819ULL, 0x008fe40000011604ULL, 0x0000000807047811ULL, 0x004fe200078ff0ffULL,
0x0000000003057220ULL, 0x010fca0000410000ULL, 0x00001f0605007589ULL, 0x000ea800000e0000ULL,
0x00001f0405047589ULL, 0x000ee200000e0000ULL, 0x0000000d000d7220ULL, 0x044fe20000410000ULL,
0x0000000f000f7220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000001500157220ULL, 0x040fe20000410000ULL,
0x0000001700177220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002900297220ULL, 0x040fe20000410000ULL,
0x0000002a002a7220ULL, 0x040fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000002e002e7220ULL, 0x040fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000003200327220ULL, 0x000fe20000410000ULL, 0x0000001104117220ULL, 0x048fe20000410000ULL,
0x0000001304137220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x000fe20000410000ULL, 0x0000000000007919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000200027812ULL, 0x004fc400078ec0ffULL,
0x00000002ff0e7819ULL, 0x000fe40000011600ULL, 0x00000001ff037819ULL, 0x000fe40000011602ULL,
0x0000000402077811ULL, 0x000fe400078ff8ffULL, 0x0000000800167811ULL, 0x000fe400078ff0ffULL,
0x0000000202047811ULL, 0x040fe400078ff8ffULL, 0x00000006020a7811ULL, 0x000fc400078ff8ffULL,
0x0000000703027812ULL, 0x100fe400078e780eULL, 0x0000000707097812ULL, 0x040fe400078e780eULL,
0x0000000707077812ULL, 0x000fe200078e7816ULL, 0x000000080e067824ULL, 0x000fe200078e0202ULL,
0x0000000704057812ULL, 0x000fe200078e780eULL, 0x000010003e027824ULL, 0x000fe200078e00ffULL,
0x0000000703037812ULL, 0x000fe200078e7816ULL, 0x0000000816147824ULL, 0x000fe200078e0207ULL,
0x000000070a0b7812ULL, 0x000fe200078e780eULL, 0x0000000800077824ULL, 0x000fe200078e00ffULL,
0x0000000704047812ULL, 0x100fe200078e7816ULL, 0x0000000816107824ULL, 0x000fe200078e0203ULL,
0x000000070a0a7812ULL, 0x000fe200078e7816ULL, 0x000000080e087824ULL, 0x040fe200078e0205ULL,
0x0000000807077812ULL, 0x000fe200078ec0ffULL, 0x000000080e0c7824ULL, 0x000fe200078e0209ULL,
0x0000001c1d05723eULL, 0x000fe200000000ffULL, 0x0000000816127824ULL, 0x000fe200078e0204ULL,
0x0000000d0f04723eULL, 0x000fe200000000ffULL, 0x0000080043037824ULL, 0x000fc400078e0202ULL,
0x000000080e0e7824ULL, 0x000fe200078e020bULL, 0x0000541004187816ULL, 0x100fe20000000005ULL,
0x0000000816167824ULL, 0x000fe200078e020aULL, 0x0000763204197816ULL, 0x000fe20000000005ULL,
0x0000001006067824ULL, 0x100fe200078e0203ULL, 0x000000252404723eULL, 0x000fe200000000ffULL,
0x00000010080a7824ULL, 0x100fe200078e0203ULL, 0x000000292a05723eULL, 0x000fe200000000ffULL,
0x000000100c0c7824ULL, 0x100fe400078e0203ULL, 0x0000001010107824ULL, 0x000fc400078e0203ULL,
0x0000001012127824ULL, 0x100fe400078e0203ULL, 0x000000100e0e7824ULL, 0x100fe400078e0203ULL,
0x0000001014147824ULL, 0x100fe400078e0203ULL, 0x0000001016167824ULL, 0x000fe400078e0203ULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x000000202106723eULL, 0x000fe200000000ffULL,
0x00000001070a7824ULL, 0x000fc400078e020aULL, 0x00000001070c7824ULL, 0x040fe200078e020cULL,
0x0000001808007388ULL, 0x0005e20000000a00ULL, 0x0000000107107824ULL, 0x040fe400078e0210ULL,
0x0000000107127824ULL, 0x040fe400078e0212ULL, 0x00000001070e7824ULL, 0x040fe400078e020eULL,
0x0000000107147824ULL, 0x040fe400078e0214ULL, 0x0000000107167824ULL, 0x000fe200078e0216ULL,
0x000000151707723eULL, 0x000fe200000000ffULL, 0x00000020430b7824ULL, 0x000fc600078e0200ULL,
0x0000541006087816ULL, 0x144fe40000000007ULL, 0x0000763206097816ULL, 0x000fe40000000007ULL,
0x0000002d2e06723eULL, 0x000fe400000000ffULL, 0x000000313207723eULL, 0x000fe200000000ffULL,
0x000000080a007388ULL, 0x0005e40000000a00ULL, 0x0000541004087816ULL, 0x144fe20000000005ULL,
0x000000100b0a7824ULL, 0x000fe200078e0202ULL, 0x0000763204097816ULL, 0x000fc40000000005ULL,
0x000000111304723eULL, 0x000fe400000000ffULL, 0x0000001e1f05723eULL, 0x000fe200000000ffULL,
0x000000080c007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x144fe40000000007ULL,
0x0000763206097816ULL, 0x000fe40000000007ULL, 0x000000222306723eULL, 0x000fe400000000ffULL,
0x0000001b1a07723eULL, 0x000fe200000000ffULL, 0x000000080e007388ULL, 0x0005e40000000a00ULL,
0x0000541004087816ULL, 0x004fc40000000005ULL, 0x0000763204097816ULL, 0x000fe40000000005ULL,
0x000000272804723eULL, 0x000fe400000000ffULL, 0x0000002b2c05723eULL, 0x000fe200000000ffULL,
0x0000000810007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x144fe40000000007ULL,
0x0000763206097816ULL, 0x000fe40000000007ULL, 0x0000002f3006723eULL, 0x000fc400000000ffULL,
0x000000333407723eULL, 0x000fe200000000ffULL, 0x0000000812007388ULL, 0x0005e40000000a00ULL,
0x0000541004087816ULL, 0x144fe40000000005ULL, 0x0000763204097816ULL, 0x000fca0000000005ULL,
0x0000000814007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x144fe40000000007ULL,
0x0000763206097816ULL, 0x000fca0000000007ULL, 0x0000000816007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000400000a107984ULL, 0x000ea80000000c00ULL,
0x000c00000a187984ULL, 0x000ee80000000c00ULL, 0x000000000a047984ULL, 0x000f280000000c00ULL,
0x000800000a0c7984ULL, 0x000e620000000c00ULL, 0x200000ff10107230ULL, 0x004fc40000000000ULL,
0x200000ff13137230ULL, 0x000fe40000000000ULL, 0x0000001810107230ULL, 0x008fe20000000000ULL,
0x00000300ff187624ULL, 0x000fe200078e00ffULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff07077230ULL, 0x010fe40000000000ULL, 0x000000011800780cULL, 0x000fe20003f05270ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fc40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fe40000000000ULL,
0x0000000f07077230ULL, 0x002fe40000000000ULL, 0x0000000e06067230ULL, 0x000fe40000000000ULL,
0x0000000d05057230ULL, 0x000fe40000000000ULL, 0x0000000c04047230ULL, 0x000fc40000000000ULL,
0x0000001b13137230ULL, 0x000fe40000000000ULL, 0x0000001a12127230ULL, 0x000fe20000000000ULL,
0x000000040a007388ULL, 0x0003e20000000c00ULL, 0x0000001911117230ULL, 0x000fca0000000000ULL,
0x000400100a007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00002f3000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x000ea20000002700ULL,
0x0000580018047a24ULL, 0x002fe200078e02ffULL, 0x0000000143ff7812ULL, 0x000fe2000780f826ULL,
0x00000800ff097424ULL, 0x000fe200078e00ffULL, 0x0000000000057919ULL, 0x000ea20000002600ULL,
0x0000660004077a24ULL, 0x000fe200078e02ffULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000004003e067824ULL, 0x000fe200078e00ffULL, 0x000000000a147984ULL, 0x0002e20000000c00ULL,
0x000000ff0000720cULL, 0x000fe20000725670ULL, 0x000058000e0e7a24ULL, 0x004fe200078e0205ULL,
0x000007ff07057811ULL, 0x000fc400078e40ffULL, 0x01ffffff07077812ULL, 0x000fe200078ec0ffULL,
0x000003000e047a24ULL, 0x000fca00078e02ffULL, 0x0000000404107c10ULL, 0x000fc8000fffe0ffULL,
0x0000001005087211ULL, 0x000fca00078fa8ffULL, 0x00006c0008087625ULL, 0x000fca00078e0009ULL,
0x00000006080c7210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fc800010e0609ULL,
0x000000100b0c7825ULL, 0x000fe200078e000cULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x00afe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000001100a7824ULL, 0x000fe200078e0207ULL,
0x00000070080f7812ULL, 0x000fe400078ec0ffULL, 0x0000000c09117812ULL, 0x000fe200078ec0ffULL,
0x00006c0010087625ULL, 0x000fc800078e000bULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000811087210ULL, 0x000fc80007a1e00fULL, 0x0000000a110a7210ULL, 0x000fe40007c7e00fULL,
0x00000009ff097210ULL, 0x000fe400007e44ffULL, 0x0000000bff0b7210ULL, 0x000fc60001fe84ffULL,
0x0000003b08007986ULL, 0x0003e8000c101906ULL, 0x0000003a0a007986ULL, 0x0003e4000c101906ULL,
0x0000000000007941ULL, 0x00afea0003800000ULL, 0x000000140c007986ULL, 0x0003e2000c101d06ULL,
0x0000011000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff097424ULL, 0x000fe200078e00ffULL,
0xffffffff180b7810ULL, 0x000fc60007ffe0ffULL, 0x00006a000e087625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b080879a8ULL, 0x000ea400099ee1c6ULL, 0x0000000b0800720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0a7807ULL, 0x000fca0000000000ULL,
0x0000000aff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff087984ULL, 0x000ee40000000000ULL,
0x000000ff0800720cULL, 0x008fda0003f05270ULL, 0x00002b8000008947ULL, 0x000fea0003800000ULL,
0x000000ff2600720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011600ULL,
0x00000080ff177424ULL, 0x002fe200078e00ffULL, 0x00000001040a7810ULL, 0x004fe40007ffe0ffULL,
0x0000007008197812ULL, 0x000fe400078ec0ffULL, 0x0000000c090e7812ULL, 0x000fe200078ec0ffULL,
0x00006c0004087625ULL, 0x000fc800078e0017ULL, 0x00006c000a0a7625ULL, 0x000fe200078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x0000000a0e0a7210ULL, 0x000fe40007b5e019ULL,
0x00000009ff097210ULL, 0x000fe400007e24ffULL, 0x0000000bff0b7210ULL, 0x000fc600017e64ffULL,
0x00000006080c7981ULL, 0x000368000c1e1900ULL, 0x000000060a0d7981ULL, 0x000362000c1e1900ULL,
0x000000021800780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x0000000204087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080f7981ULL, 0x000362000c1e1900ULL, 0x000000041800780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x0000000304087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608117981ULL, 0x000362000c1e1900ULL,
0x000000041800780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x0000000404087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608137981ULL, 0x000362000c1e1900ULL, 0x000000061800780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000000504087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608157981ULL, 0x000362000c1e1900ULL,
0x000000061800780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081800780cULL, 0x002fe40003f06070ULL, 0x0000000604087810ULL, 0x000fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fe40007a3e019ULL,
0x00000007040a0810ULL, 0x000fe40007ffe0ffULL, 0x00000009ff097210ULL, 0x000fc60000fe44ffULL,
0x00006c000a0a0625ULL, 0x000fe400078e0017ULL, 0x0000000608177981ULL, 0x000366000c1e1900ULL,
0x0000000a0e0a0210ULL, 0x000fc80007c7e019ULL, 0x0000000bff0b0210ULL, 0x000fcc0001fe84ffULL,
0x000000060a0b0981ULL, 0x000366000c1e1900ULL, 0x0000000718087810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0a7819ULL, 0x004fc80000011608ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff197224ULL, 0x000fe400078e00ffULL,
0x000000ffff1b7224ULL, 0x020fe400078e000cULL, 0x00000008190e7824ULL, 0x040fe200078e00ffULL,
0x0000000119197810ULL, 0x000fc80007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x0000000a1900720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080e097810ULL, 0x040fe40007ffe0ffULL, 0x000000010e087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001b0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x00000070101b7812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e01bULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006081b7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090e097810ULL, 0x042fe40007ffe0ffULL,
0x000000020e087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000000d0c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000d7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080d7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0e097810ULL, 0x042fe40007ffe0ffULL, 0x000000030e087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000000f0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000f7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e00fULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080f7981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0e097810ULL, 0x042fe40007ffe0ffULL,
0x000000040e087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x000000110c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010117812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x000fc80007b3e011ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608117981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0e097810ULL, 0x042fe40007ffe0ffULL, 0x000000050e087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x000000130c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010137812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e013ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608137981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0e097810ULL, 0x042fe40007ffe0ffULL,
0x000000060e087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x000000150c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010157812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x000fc80007b3e015ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608157981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0e097810ULL, 0x042fe40007ffe0ffULL, 0x000000070e087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x000000170c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010177812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e017ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608177981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0e097810ULL, 0x002fe40007ffe0ffULL,
0x0000000b0c0c7209ULL, 0x000fe40007810000ULL, 0x0000030009007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff0e7819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000b7824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700b0b7812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007a3e00bULL, 0x00000009ff097210ULL, 0x000fca0000fe44ffULL,
0x00000006080b7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x0000001000087824ULL, 0x006fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fc80000011600ULL, 0x0000007008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097812ULL, 0x000fca00078ec0ffULL, 0x0000000109097824ULL, 0x000fca00078e0208ULL,
0x0000000c09007388ULL, 0x0203e40000000800ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x0000001000097824ULL, 0x002fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011600ULL,
0x0000000143107824ULL, 0x000fe200078e0204ULL, 0x00000002ff0c7819ULL, 0x000fe20000011626ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000070090a7812ULL, 0x004fe200078ec0ffULL,
0x00000800ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000020026267824ULL, 0x000fe200078e00ffULL, 0x0000001005087211ULL, 0x000fe200078fa8ffULL,
0x000000013c3c7824ULL, 0x000fe200078e0202ULL, 0x000010d000007945ULL, 0x000fe20003800000ULL,
0x000000010b307824ULL, 0x000fe200078e020aULL, 0x000000010c0a7812ULL, 0x000fe200078ec0ffULL,
0x00000002430b8824ULL, 0x000fe200078e023eULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00006c0008087625ULL, 0x000fe200078e000dULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000020b158824ULL, 0x000fe200078e020aULL, 0x00000800260b7812ULL, 0x000fe200078ec0ffULL,
0x00000002430d8824ULL, 0x000fe200078e023eULL, 0x0000000608087210ULL, 0x000fe20007f3e0ffULL,
0x00000001070e8824ULL, 0x000fe200078e0210ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000080ff0f8424ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000080ff118424ULL, 0x000fe200078e00ffULL, 0x0000000030307984ULL, 0x000e620000000800ULL,
0x000000020d178824ULL, 0x000fe200078e020aULL, 0x00000020000d7810ULL, 0x000fe20007ffe0ffULL,
0x000000013c0b7824ULL, 0x000fe200078e020bULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000030043007a0cULL, 0x000fe20003f26070ULL,
0x00006c000e0e8625ULL, 0x000fe200078e000fULL, 0x0000000000267805ULL, 0x000fc6000001ff00ULL,
0x00006c0010108625ULL, 0x000fc800078e0011ULL, 0x0000000815158824ULL, 0x100fe400078e0200ULL,
0x0000000817178824ULL, 0x000fe400078e0200ULL, 0x0000001000137824ULL, 0x040fe200078e020bULL,
0x0000458015158811ULL, 0x000fe200078e20ffULL, 0x00000010000a7825ULL, 0x000fe200078e0008ULL,
0x0000418017178811ULL, 0x000fc600078e20ffULL, 0x000000100d0c7825ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000a137faeULL, 0x0005e2000b901c46ULL,
0x0000000000087805ULL, 0x000fe4000001ff00ULL, 0x00000010000e8825ULL, 0x040fe200078e000eULL,
0x003800000c137faeULL, 0x0007e6000b901c46ULL, 0x0000001000108825ULL, 0x000fe200078e0010ULL,
0x000000000e158faeULL, 0x0009e6000b901c46ULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0x0000000010178faeULL, 0x0003e2000b901c46ULL, 0x00000000000a7805ULL, 0x004fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000c7805ULL, 0x008fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x010fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x002fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000d6000001947ULL, 0x000fea0003800000ULL,
0x000000ffff087224ULL, 0x000fe400078e00ffULL, 0x000000ffff327224ULL, 0x000fca00078e0043ULL,
0x0000000232337810ULL, 0x000fe20007ffe0ffULL, 0x0000029000017945ULL, 0x000fe60003800000ULL,
0x0000030033007a0cULL, 0x000fda0003f06070ULL, 0x0000026000000947ULL, 0x000fea0003800000ULL,
0x000000070000780cULL, 0x000fe20003f24070ULL, 0x00000001042e7824ULL, 0x100fe200078e0233ULL,
0x00000001ff287819ULL, 0x000fe20000011633ULL, 0x00000800ff347424ULL, 0x000fe200078e00ffULL,
0x0000002000397810ULL, 0x000fe20007ffe0ffULL, 0x00000400332a7824ULL, 0x000fe200078e00ffULL,
0x0000002e05297211ULL, 0x000fe400078fa8ffULL, 0x00000001282c7812ULL, 0x000fc600078ec0ffULL,
0x00006c0029287625ULL, 0x000fc800078e0034ULL, 0x00000002432d9824ULL, 0x000fe200078e023eULL,
0x0000000628287210ULL, 0x000fe20007f1e0ffULL, 0x00000001072b9824ULL, 0x000fe400078e022eULL,
0x000000022d3b9824ULL, 0x000fe200078e022cULL, 0x000008002a2d7812ULL, 0x000fe200078ec0ffULL,
0x00000080ff349424ULL, 0x000fe400078e00ffULL, 0x0000000243379824ULL, 0x000fe400078e023eULL,
0x00006c002b2a9625ULL, 0x000fc800078e0034ULL, 0x0000000237379824ULL, 0x000fe400078e022cULL,
0x00000080ff2f9424ULL, 0x000fe400078e00ffULL, 0x000000013c2d7824ULL, 0x000fe400078e022dULL,
0x000000ffff297224ULL, 0x000fe400000e0629ULL, 0x00006c002e2e9625ULL, 0x000fc800078e002fULL,
0x0000001000357824ULL, 0x040fe400078e022dULL, 0x0000000837379824ULL, 0x000fe400078e0200ULL,
0x00000010002c9825ULL, 0x000fc600078e002aULL, 0x0000458037379811ULL, 0x000fe200078e20ffULL,
0x000000083b3b9824ULL, 0x000fe400078e0200ULL, 0x00000010392a7825ULL, 0x000fc600078e0028ULL,
0x000041803b399811ULL, 0x000fe200078e20ffULL, 0x0000001000287825ULL, 0x000fc800078e0028ULL,
0x00000010002e9825ULL, 0x000fe200078e002eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000028357faeULL, 0x0003e8000b901c46ULL, 0x003800002a357faeULL, 0x0003e8000b901c46ULL,
0x000000002c379faeULL, 0x0003e8000b901c46ULL, 0x000000002e399faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff2d7224ULL, 0x002fe200078e0032ULL, 0x00000001ff2a7819ULL, 0x000fe20000011600ULL,
0x00000002432b7824ULL, 0x000fe200078e023eULL, 0x00000002ff357819ULL, 0x000fe20000011600ULL,
0x000000402d287824ULL, 0x000fe200078e00ffULL, 0x0000000c2a2a7812ULL, 0x000fe200078ec0ffULL,
0x0000001000297824ULL, 0x000fe200078e00ffULL, 0x0000000735387812ULL, 0x040fe200078ec0ffULL,
0x00000008352f7824ULL, 0x040fe200078e00ffULL, 0x0000008028287812ULL, 0x000fe200078ec0ffULL,
0x0000000835377824ULL, 0x000fe200078e00ffULL, 0x0000007029297812ULL, 0x000fc400078ec0ffULL,
0x00000035ff3a7212ULL, 0x000fe200078e33ffULL, 0x000001002b287824ULL, 0x000fc600078e0028ULL,
0xfffffff8373a7812ULL, 0x000fe400078ee23aULL, 0x000000282a2a7210ULL, 0x000fe20007ffe029ULL,
0x0000000835297824ULL, 0x000fe200078e00ffULL, 0xfffffff82f287812ULL, 0x000fe200078ee238ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180002a2b7984ULL, 0x000e620000000800ULL,
0x00000001292c7812ULL, 0x140fe400078ef638ULL, 0x00000002292e7812ULL, 0x140fe200078ef638ULL,
0x004580002a4e7984ULL, 0x0004e20000000800ULL, 0x0000000329327812ULL, 0x140fe400078ef638ULL,
0x0000000429347812ULL, 0x140fe400078ef638ULL, 0x0000000529367812ULL, 0x140fe400078ef638ULL,
0x0000000629387812ULL, 0x000fe200078ef638ULL, 0x000004002d297824ULL, 0x000fe200078e00ffULL,
0x0000000835377810ULL, 0x000fe20007ffe0ffULL, 0x00000004002a7824ULL, 0x004fc600078e00ffULL,
0x0000080029297812ULL, 0x000fe200078ec0ffULL, 0x0000000837427824ULL, 0x040fe200078e00ffULL,
0x00000007372d7812ULL, 0x040fe200078ec0ffULL, 0x0000000837407824ULL, 0x040fe200078e00ffULL,
0x000001803c297810ULL, 0x000fe20007ffe029ULL, 0x0000000837397824ULL, 0x000fe200078e00ffULL,
0x00000037ff4c7212ULL, 0x000fe400078e33ffULL, 0x0000000240447812ULL, 0x000fe200078ef62dULL,
0x0000001028287824ULL, 0x000fe200078e0229ULL, 0x0000000340467812ULL, 0x000fe200078ef62dULL,
0x000000103a3a7824ULL, 0x000fe200078e0229ULL, 0x0000000440487812ULL, 0x000fe200078ef62dULL,
0x000000102c2c7824ULL, 0x000fe200078e0229ULL, 0x00000005404a7812ULL, 0x000fe200078ef62dULL,
0x0000001032327824ULL, 0x100fe200078e0229ULL, 0xfffffff8394c7812ULL, 0x000fe200078ee24cULL,
0x000000102e2e7824ULL, 0x000fc400078e0229ULL, 0x0000001036367824ULL, 0x100fe400078e0229ULL,
0x0000001034347824ULL, 0x000fe200078e0229ULL, 0x0000002b302b7221ULL, 0x002fe20000010100ULL,
0x0000001038387824ULL, 0x100fe400078e0229ULL, 0x0000001044447824ULL, 0x100fe200078e0229ULL,
0x3fb8aa3b2b2f7820ULL, 0x000fe20000410000ULL, 0x0000000c2a2b7812ULL, 0x000fe200078ec0ffULL,
0x0000001046467824ULL, 0x000fe200078e0229ULL, 0xfffffff8422a7812ULL, 0x000fe200078ee22dULL,
0x0000001048487824ULL, 0x000fe200078e0229ULL, 0x0000000140427812ULL, 0x000fe200078ef62dULL,
0x0000000128287824ULL, 0x000fe200078e022bULL, 0x0000002f002f7308ULL, 0x000ee20000000800ULL,
0x000000012b3a7824ULL, 0x040fe200078e023aULL, 0x0000000640407812ULL, 0x000fe200078ef62dULL,
0x000000012b2c7824ULL, 0x000fc400078e022cULL, 0x0000000028287984ULL, 0x000e620000000800ULL,
0x000000012b327824ULL, 0x040fe400078e0232ULL, 0x000000012b2e7824ULL, 0x040fe200078e022eULL,
0x000000003a3a7984ULL, 0x000ea20000000800ULL, 0x000000012b367824ULL, 0x040fe400078e0236ULL,
0x000000012b347824ULL, 0x040fe200078e0234ULL, 0x000000002c2c7984ULL, 0x000fe20000000800ULL,
0x000000012b387824ULL, 0x000fe200078e0238ULL, 0x0000004e2f507220ULL, 0x008fc40000410000ULL,
0x0000000032327984ULL, 0x000fe20000000800ULL, 0x000000102a2a7824ULL, 0x100fe400078e0229ULL,
0x0000001042427824ULL, 0x000fe200078e0229ULL, 0x000000002e2e7984ULL, 0x000fe20000000800ULL,
0x000000012b2a7824ULL, 0x040fe200078e022aULL, 0x0000003150317221ULL, 0x000fe20000010000ULL,
0x000000012b427824ULL, 0x040fe200078e0242ULL, 0x0000000036367984ULL, 0x000fe20000000800ULL,
0x000000012b447824ULL, 0x040fe400078e0244ULL, 0x000000012b467824ULL, 0x000fe200078e0246ULL,
0x00001f35502d7589ULL, 0x000ee200000e0000ULL, 0x000000104a4a7824ULL, 0x000fc400078e0229ULL,
0x0000001040407824ULL, 0x100fe200078e0229ULL, 0x0000000034347984ULL, 0x000f220000000800ULL,
0x000000104c4c7824ULL, 0x000fe400078e0229ULL, 0x000000012b487824ULL, 0x040fe200078e0248ULL,
0x0000000038387984ULL, 0x000f220000000800ULL, 0x000000012b4a7824ULL, 0x040fe400078e024aULL,
0x000000012b407824ULL, 0x040fe200078e0240ULL, 0x000000002a2a7984ULL, 0x000f220000000800ULL,
0x000000012b4c7824ULL, 0x000fc600078e024cULL, 0x0000000042427984ULL, 0x000f220000000800ULL,
0x20000028ff4e7230ULL, 0x102fe40000004100ULL, 0x30000028ff2b7230ULL, 0x000fe20000004100ULL,
0x0000000044447984ULL, 0x000e620000000800ULL, 0x2000003aff287230ULL, 0x104fe40000004100ULL,
0x3000003aff2f7230ULL, 0x000fe20000004100ULL, 0x0000000046467984ULL, 0x000fe20000000800ULL,
0x0000002d2b267223ULL, 0x088fe20000010026ULL, 0x0000002d28197223ULL, 0x080fe20000010019ULL,
0x2000002cff287230ULL, 0x100fe20000004100ULL, 0x0000000048487984ULL, 0x000fe20000000800ULL,
0x3000002cff2b7230ULL, 0x000fe20000004100ULL, 0x0000002d2f187223ULL, 0x080fe20000010018ULL,
0x0000002d4e277223ULL, 0x080fe20000010027ULL, 0x000000004a4a7984ULL, 0x000fe20000000800ULL,
0x0000002d28257223ULL, 0x080fe20000010025ULL, 0x20000032ff287230ULL, 0x000fe20000004100ULL,
0x0000002d2b247223ULL, 0x000fe20000010024ULL, 0x0000000040407984ULL, 0x000fe20000000800ULL,
0x3000002eff2f7230ULL, 0x000fc40000004100ULL, 0x0000002d28217223ULL, 0x080fe20000010021ULL,
0x000000004c4c7984ULL, 0x000fe20000000800ULL, 0x30000032ff2b7230ULL, 0x000fe20000004100ULL,
0x0000002d2f227223ULL, 0x080fe20000010022ULL, 0x20000036ff287230ULL, 0x000fe20000004100ULL,
0x00001f3750297589ULL, 0x000ea200000e0000ULL, 0x2000002eff2c7230ULL, 0x000fe20000004100ULL,
0x0000002d2b207223ULL, 0x080fe20000010020ULL, 0x30000034ff2f7230ULL, 0x010fe20000004100ULL,
0x0000002d281d7223ULL, 0x080fe2000001001dULL, 0x30000036ff2b7230ULL, 0x000fe20000004100ULL,
0x0000002d2c237223ULL, 0x080fe20000010023ULL, 0x20000038ff287230ULL, 0x000fe20000004100ULL,
0x0000002d2f1e7223ULL, 0x080fe2000001001eULL, 0x20000034ff2c7230ULL, 0x000fe20000004100ULL,
0x0000002d2b1c7223ULL, 0x080fe2000001001cULL, 0x30000038ff2f7230ULL, 0x000fe20000004100ULL,
0x0000002d281b7223ULL, 0x080fe2000001001bULL, 0x3000002aff2b7230ULL, 0x000fe20000004100ULL,
0x0000002d2c1f7223ULL, 0x080fe2000001001fULL, 0x20000042ff287230ULL, 0x000fe20000004100ULL,
0x0000002d2f1a7223ULL, 0x000fe2000001001aULL, 0x000000ffff327224ULL, 0x000fc400078e0033ULL,
0x2000002aff2c7230ULL, 0x000fe40000004100ULL, 0x20000044ff2a7230ULL, 0x102fe20000004100ULL,
0x0000030032007a0cULL, 0x000fe20003f06070ULL, 0x30000044ff2d7230ULL, 0x000fe20000004100ULL,
0x000000292b167223ULL, 0x084fe20000010016ULL, 0x0000002928157223ULL, 0x080fe20000010015ULL,
0x30000042ff2b7230ULL, 0x000fe20000004100ULL, 0x000000292a137223ULL, 0x080fe20000010013ULL,
0x20000046ff287230ULL, 0x000fe20000004100ULL, 0x000000292d127223ULL, 0x080fe20000010012ULL,
0x30000048ff2d7230ULL, 0x000fe20000004100ULL, 0x000000292b147223ULL, 0x080fe20000010014ULL,
0x30000046ff2b7230ULL, 0x000fe20000004100ULL, 0x0000002928117223ULL, 0x080fe20000010011ULL,
0x20000048ff287230ULL, 0x000fe20000004100ULL, 0x000000292d0e7223ULL, 0x080fe2000001000eULL,
0x2000004aff2a7230ULL, 0x100fe20000004100ULL, 0x000000292b107223ULL, 0x080fe20000010010ULL,
0x3000004aff2b7230ULL, 0x000fe20000004100ULL, 0x00000029280f7223ULL, 0x080fe2000001000fULL,
0x20000040ff287230ULL, 0x100fe20000004100ULL, 0x000000292a0d7223ULL, 0x080fe2000001000dULL,
0x30000040ff2d7230ULL, 0x000fe20000004100ULL, 0x000000292c177223ULL, 0x080fe20000010017ULL,
0x2000004cff2a7230ULL, 0x100fe20000004100ULL, 0x000000292b0c7223ULL, 0x080fe2000001000cULL,
0x3000004cff2f7230ULL, 0x000fe20000004100ULL, 0x00000029280b7223ULL, 0x080fe2000001000bULL,
0x000000292d0a7223ULL, 0x080fe2000001000aULL, 0x000000292a097223ULL, 0x000fc40000010009ULL,
0x000000292f087223ULL, 0x000fe20000010008ULL, 0xfffff2c000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000ff3e00720cULL, 0x000fe20003f05270ULL, 0x0000001000047824ULL, 0x002fe200078e00ffULL,
0x00000001ff007819ULL, 0x000fc80000011600ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c00057812ULL, 0x000fca00078ec0ffULL, 0x0000000105067824ULL, 0x000fe200078e0204ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x0000001000047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011600ULL,
0x0000007004007812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc600078ec0ffULL,
0x0000008043007824ULL, 0x000fc800078e0200ULL, 0x0000000105007824ULL, 0x000fca00078e0200ULL,
0x0049803100007388ULL, 0x0003e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800006007984ULL, 0x002e680000000800ULL,
0x004a000006057984ULL, 0x000ea20000000800ULL, 0x00000000ff007221ULL, 0x002fc80000010000ULL,
0x0000000500007221ULL, 0x004fca0000010000ULL, 0x0180000000047810ULL, 0x000fc80007ffe0ffULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0000ULL, 0x000099b000047802ULL, 0x000fe40000000f00ULL,
0x00005eb000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff047224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000057308ULL, 0x000e640000001000ULL,
0xbf80000000047423ULL, 0x002fc80000000005ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000405047223ULL, 0x000fe40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff077819ULL, 0x004fe40000011600ULL, 0x0000000800407811ULL, 0x000fc600078ff0ffULL,
0x00001f0704057589ULL, 0x000ea200000e0000ULL, 0x00000040ff427212ULL, 0x000fe200078e33ffULL,
0x0000000840297824ULL, 0x000fe400078e00ffULL, 0x00001f4004067589ULL, 0x00072600000e0000ULL,
0xfffffff829427812ULL, 0x000fca00078ee242ULL, 0x0000001042427824ULL, 0x000fe200078e0203ULL,
0x00000007ff047212ULL, 0x008fe200078e33ffULL, 0x0000002705277220ULL, 0x044fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002505257220ULL, 0x040fe20000410000ULL,
0x0000002405247220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002105217220ULL, 0x040fe20000410000ULL,
0x0000002005207220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001d051d7220ULL, 0x040fe20000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x0000001b051b7220ULL, 0x040fe20000410000ULL,
0x0000001a051a7220ULL, 0x040fe20000410000ULL, 0x0000001905197220ULL, 0x040fe20000410000ULL,
0x0000001805187220ULL, 0x000fe20000410000ULL, 0x0000000807057824ULL, 0x000fe200078e00ffULL,
0x0000001706177220ULL, 0x050fe20000410000ULL, 0x0000001606167220ULL, 0x040fe20000410000ULL,
0x0000001506157220ULL, 0x040fe20000410000ULL, 0x0000001406147220ULL, 0x040fe20000410000ULL,
0x0000001306137220ULL, 0x040fe20000410000ULL, 0x0000001206127220ULL, 0x040fe20000410000ULL,
0x0000001106117220ULL, 0x040fe20000410000ULL, 0x0000001006107220ULL, 0x040fe20000410000ULL,
0x0000000f060f7220ULL, 0x040fe20000410000ULL, 0x0000000e060e7220ULL, 0x040fe20000410000ULL,
0x0000000d060d7220ULL, 0x040fe20000410000ULL, 0x0000000c060c7220ULL, 0x040fe20000410000ULL,
0x0000000b060b7220ULL, 0x040fe20000410000ULL, 0x0000000a060a7220ULL, 0x040fe20000410000ULL,
0x0000000906097220ULL, 0x040fe20000410000ULL, 0x0000000806067220ULL, 0x000fe20000410000ULL,
0xfffffff805447812ULL, 0x000fe200078ee204ULL, 0x0000000807047824ULL, 0x040fe200078e00ffULL,
0x0000000707057812ULL, 0x000fc400078ec0ffULL, 0x000000090606723eULL, 0x000fe200000000ffULL,
0x0000000840097824ULL, 0x000fe200078e00ffULL, 0x0000000105087812ULL, 0x040fe400078e3cffULL,
0x0000000205287812ULL, 0x040fe400078e3cffULL, 0x00000003052a7812ULL, 0x000fe200078e3cffULL,
0x0000000807087824ULL, 0x000fe200078e0208ULL, 0x00000004052c7812ULL, 0x000fe200078e3cffULL,
0x0000000807287824ULL, 0x000fe200078e0228ULL, 0x00000005052e7812ULL, 0x000fe200078e3cffULL,
0x00000008072a7824ULL, 0x000fe200078e022aULL, 0x0000000605307812ULL, 0x000fe200078e3cffULL,
0x00000008072c7824ULL, 0x040fe200078e022cULL, 0x0000000f0e0e723eULL, 0x000fe200000000ffULL,
0x00000008072e7824ULL, 0x040fe200078e022eULL, 0x00000007400f7812ULL, 0x000fe200078ec0ffULL,
0x0000000807307824ULL, 0x000fe200078e0230ULL, 0x000000111010723eULL, 0x000fe200000000ffULL,
0x0000000400117824ULL, 0x000fe200078e00ffULL, 0x0000000d0c0c723eULL, 0x000fe200000000ffULL,
0x0000001008087824ULL, 0x100fe200078e0203ULL, 0x0000000b0a0a723eULL, 0x000fe200000000ffULL,
0x0000001028287824ULL, 0x000fe200078e0203ULL, 0xfffffff804047812ULL, 0x000fe200078ee207ULL,
0x000000102a2a7824ULL, 0x100fe200078e0203ULL, 0xfffffff809327812ULL, 0x000fe200078ee240ULL,
0x000000102c2c7824ULL, 0x100fe200078e0203ULL, 0x000000010f057812ULL, 0x040fe200078e3cffULL,
0x0000001004047824ULL, 0x100fe200078e0203ULL, 0x000000020f077812ULL, 0x040fe200078e3cffULL,
0x0000001032327824ULL, 0x000fe200078e0203ULL, 0x000000030f097812ULL, 0x040fe200078e3cffULL,
0x0000000840347824ULL, 0x040fe200078e0205ULL, 0x000000040f0b7812ULL, 0x040fe200078e3cffULL,
0x0000000840367824ULL, 0x040fe200078e0207ULL, 0x000000050f0d7812ULL, 0x040fe200078e3cffULL,
0x0000000840387824ULL, 0x040fe200078e0209ULL, 0x000000060f0f7812ULL, 0x000fe200078e3cffULL,
0x00000008403a7824ULL, 0x002fe200078e020bULL, 0x0000001d1c1c723eULL, 0x000fe200000000ffULL,
0x00000008403c7824ULL, 0x040fe200078e020dULL, 0x0000000c111d7812ULL, 0x000fe200078ec0ffULL,
0x0000000840407824ULL, 0x000fe200078e020fULL, 0x000000272626723eULL, 0x000fe200000000ffULL,
0x0000001044077824ULL, 0x100fe200078e0203ULL, 0x000000252424723eULL, 0x000fe200000000ffULL,
0x000000011d057824ULL, 0x040fe200078e0204ULL, 0x000000232222723eULL, 0x000fe200000000ffULL,
0x000000102e2e7824ULL, 0x100fe200078e0203ULL, 0x000000212020723eULL, 0x000fe200000000ffULL,
0x0000001030307824ULL, 0x100fe200078e0203ULL, 0x0000001f1e1e723eULL, 0x000fe200000000ffULL,
0x0000001034347824ULL, 0x100fe200078e0203ULL, 0x0000002605007388ULL, 0x0003e20000000800ULL,
0x0000001036367824ULL, 0x100fe200078e0203ULL, 0x0000001b1a1a723eULL, 0x000fe200000000ffULL,
0x0000001038387824ULL, 0x100fe200078e0203ULL, 0x000000191818723eULL, 0x000fe200000000ffULL,
0x000000103a3a7824ULL, 0x100fe200078e0203ULL, 0x000000131212723eULL, 0x000fe200000000ffULL,
0x000000103c3c7824ULL, 0x100fe200078e0203ULL, 0x000000171616723eULL, 0x000fe200000000ffULL,
0x0000001040407824ULL, 0x000fe200078e0203ULL, 0x000000151414723eULL, 0x000fe200000000ffULL,
0x000000011d117824ULL, 0x000fc400078e0207ULL, 0x000000011d037824ULL, 0x040fe400078e0208ULL,
0x000000011d077824ULL, 0x040fe400078e0228ULL, 0x000000011d097824ULL, 0x040fe200078e022aULL,
0x0000002403007388ULL, 0x0005e20000000800ULL, 0x000000011d0b7824ULL, 0x040fe400078e022cULL,
0x000000011d0d7824ULL, 0x040fe200078e022eULL, 0x0000002207007388ULL, 0x000fe20000000800ULL,
0x000000011d0f7824ULL, 0x000fc400078e0230ULL, 0x000000011d137824ULL, 0x040fe200078e0232ULL,
0x0000002009007388ULL, 0x000fe20000000800ULL, 0x000000011d157824ULL, 0x040fe400078e0234ULL,
0x000000011d057824ULL, 0x042fe200078e0236ULL, 0x0000001e0b007388ULL, 0x000fe20000000800ULL,
0x000000011d177824ULL, 0x040fe400078e0238ULL, 0x000000011d197824ULL, 0x040fe200078e023aULL,
0x0000001c0d007388ULL, 0x000fe20000000800ULL, 0x000000011d1f7824ULL, 0x000fc400078e0242ULL,
0x000000011d1b7824ULL, 0x040fe200078e023cULL, 0x0000001a0f007388ULL, 0x000fe20000000800ULL,
0x000000011d1d7824ULL, 0x000fe400078e0240ULL, 0x0000002043217824ULL, 0x000fe200078e0200ULL,
0x0000001811007388ULL, 0x000fe60000000800ULL, 0x0000001021037824ULL, 0x004fe200078e0202ULL,
0x0000001613007388ULL, 0x000fe80000000800ULL, 0x0000001415007388ULL, 0x000fe80000000800ULL,
0x0000001205007388ULL, 0x000fe80000000800ULL, 0x0000001017007388ULL, 0x000fe80000000800ULL,
0x0000000e19007388ULL, 0x000fe80000000800ULL, 0x0000000c1b007388ULL, 0x000fe80000000800ULL,
0x0000000a1d007388ULL, 0x000fe80000000800ULL, 0x000000061f007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000003207984ULL, 0x000e680000000c00ULL,
0x0004000003287984ULL, 0x000ea80000000c00ULL, 0x0008000003247984ULL, 0x000ee80000000c00ULL,
0x000c0000032c7984ULL, 0x000f220000000c00ULL, 0x200000ff23237230ULL, 0x002fc40000000000ULL,
0x200000ff22227230ULL, 0x000fe40000000000ULL, 0x200000ff21217230ULL, 0x000fe40000000000ULL,
0x200000ff20207230ULL, 0x000fe40000000000ULL, 0x200000ff2b2b7230ULL, 0x004fe40000000000ULL,
0x200000ff2a2a7230ULL, 0x000fe40000000000ULL, 0x200000ff29297230ULL, 0x000fc40000000000ULL,
0x200000ff28287230ULL, 0x000fe40000000000ULL, 0x0000002723237230ULL, 0x008fe40000000000ULL,
0x0000002622227230ULL, 0x000fe40000000000ULL, 0x0000002521217230ULL, 0x000fe40000000000ULL,
0x0000002420207230ULL, 0x000fe40000000000ULL, 0x0000002f2b2b7230ULL, 0x010fc40000000000ULL,
0x0000002e2a2a7230ULL, 0x000fe20000000000ULL, 0x0000002003007388ULL, 0x0003e20000000c00ULL,
0x0000002d29297230ULL, 0x000fe40000000000ULL, 0x0000002c28287230ULL, 0x000fca0000000000ULL,
0x0004002803007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff4300720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000002000117810ULL, 0x002fe20007ffe0ffULL, 0x0000000000067919ULL, 0x000e620000002600ULL,
0x00000003ff077819ULL, 0x100fe20000011600ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x00000003ff047819ULL, 0x100fe20000011611ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000707037812ULL, 0x100fe200078e4800ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000704057812ULL, 0x000fe400078e4811ULL, 0x0ffffff803037812ULL, 0x000fc400078ef800ULL,
0x0ffffff805057812ULL, 0x000fc600078ef811ULL, 0x0000001003037824ULL, 0x100fe400078e0202ULL,
0x0000001005057824ULL, 0x000fc600078e0202ULL, 0x0000000003087984ULL, 0x004ea80000000c00ULL,
0x00000000050c7984ULL, 0x0008a20000000c00ULL, 0x0000000806027824ULL, 0x042fe400078e00ffULL,
0x0000000806137824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x008fe4000f8e023fULL,
0xfffffff802027812ULL, 0x000fc400078ee207ULL, 0xfffffff813047812ULL, 0x000fe200078ee204ULL,
0x000000083e137824ULL, 0x000fe200078e00ffULL, 0x0000000402077c10ULL, 0x000fe2000ff1e0ffULL,
0x000000083e3e7824ULL, 0x000fe200078e00ffULL, 0x0000000404067c10ULL, 0x000fc6000ff3e0ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x00005a0007027a11ULL, 0x040fe200078040ffULL,
0x000000ffff057224ULL, 0x010fe200008e06ffULL, 0x00005a0006047a11ULL, 0x040fe400078240ffULL,
0x00005b0007037a11ULL, 0x000fe400000f4410ULL, 0xfffffff813077812ULL, 0x000fe400078ee200ULL,
0x00005b0006057a11ULL, 0x000fe400008f4405ULL, 0xfffffff83e117812ULL, 0x000fe200078ee211ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x004fe8000c101d06ULL, 0x0000000c04007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff2a7819ULL, 0x000fe20000011626ULL,
0xffffffffff277424ULL, 0x000fc800078e00ffULL, 0x00000002252a7824ULL, 0x000fca00078e022aULL,
0x000000032a00720cULL, 0x000fda0003f06070ULL, 0x0000000228058824ULL, 0x000fc800078e00ffULL,
0x0000640005068a24ULL, 0x000fc800078e022aULL, 0x0000600006068625ULL, 0x000fe200078e000fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff087624ULL, 0x000fe200078e00ffULL,
0x0000000606278981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff097624ULL, 0x000fc600078e00ffULL,
0x00f60000ff047f8cULL, 0x000e68000c80043fULL, 0x00000006082f7981ULL, 0x000762000c1e9900ULL,
0x00000001250b7810ULL, 0x000fe20007ffe0ffULL, 0x00000040262c7824ULL, 0x000fe400078e00ffULL,
0x000000802b2b7824ULL, 0x000fe200078e00ffULL, 0x000000020b00720cULL, 0x000fe20003f06070ULL,
0x00000100250b7824ULL, 0x000fc400078e022cULL, 0x000000802e2e7824ULL, 0x000fc600078e00ffULL,
0x000000402b1a7812ULL, 0x000fe200078ef80bULL, 0x0000002e271b7224ULL, 0x004fcc00078e02ffULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000002ff177819ULL, 0x00afe40000011641ULL,
0x0000000b24007217ULL, 0x000fe40007800000ULL, 0x0000000817137810ULL, 0x040fe20007ffe0ffULL,
0x0000000117067824ULL, 0x140fe200078e021aULL, 0x0000001017157810ULL, 0x040fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a0bULL, 0x00000018171d7810ULL, 0x000fe40007ffe0ffULL,
0x000000061b0f7210ULL, 0x000fe20007f1e0ffULL, 0x0000000113067824ULL, 0x100fe200078e021aULL,
0x000000300a197812ULL, 0x000fe200078ec0ffULL, 0x0000000115077824ULL, 0x000fe200078e021aULL,
0x00000003ff0c7819ULL, 0x000fe20000011641ULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e000f147a11ULL, 0x000fc400078038ffULL, 0x000000071b107210ULL, 0x000fe40007f3e0ffULL,
0x00005f000f0f7a11ULL, 0x000fe200000f3c08ULL, 0x000000011d087824ULL, 0x000fe200078e021aULL,
0x000000061b067210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x00005e00100b7a11ULL, 0x000fe400078238ffULL, 0x000000081b087210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x00005e00060d7a11ULL, 0x000fc400078038ffULL,
0x00005f0010107a11ULL, 0x000fe200008f3c09ULL, 0x000000ffff077224ULL, 0x000fe200010e06ffULL,
0x00005f0006117a11ULL, 0x000fe200000f3c11ULL, 0x0000000413097824ULL, 0x000fe200078e00ffULL,
0x00005e0008127a11ULL, 0x000fe400078438ffULL, 0x0000001419067210ULL, 0x000fe40007f7e0ffULL,
0x000000030c0c7812ULL, 0x000fe400078e4841ULL, 0x00005f0008187a11ULL, 0x000fe200010f3c07ULL,
0x000000ffff077224ULL, 0x000fe200018e060fULL, 0x00001000260e7811ULL, 0x000fc400078e68ffULL,
0xfffffffc09097812ULL, 0x000fe400078ee20cULL, 0x000000190d087210ULL, 0x080fe40007f7e0ffULL,
0x000000001700720cULL, 0x080fe20003f06070ULL, 0x00000010090d7824ULL, 0x100fe200078e020eULL,
0x0ffffffc0c417812ULL, 0x000fe200078ef841ULL, 0x000000ffff097224ULL, 0x000fe200018e0611ULL,
0x000000001500720cULL, 0x040fe20003f46070ULL, 0x0000000415157824ULL, 0x000fe200078e00ffULL,
0x000000190b0a7210ULL, 0x000fe20007f9e0ffULL, 0x0000001041417824ULL, 0x000fe200078e020eULL,
0x0000002017117810ULL, 0x000fc40007ffe0ffULL, 0x000000001300720cULL, 0x080fe20003f26070ULL,
0x000000ffff0b7224ULL, 0x000fe200020e0610ULL, 0xfffffffc150f7812ULL, 0x000fe200078ee20cULL,
0x000000011a107824ULL, 0x000fe200078e0211ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006417faeULL, 0x0003e2000c101c46ULL, 0x000000001d00720cULL, 0x040fe20003f86070ULL,
0x000000041d1d7824ULL, 0x000fe200078e00ffULL, 0x0000002817137810ULL, 0x000fe20007ffe0ffULL,
0x000000100f0f7824ULL, 0x000fe200078e020eULL, 0x000000101b107210ULL, 0x000fe40007f1e0ffULL,
0x0000003017157810ULL, 0x000fc40007ffe0ffULL, 0x0000003817177810ULL, 0x000fe20007ffe0ffULL,
0x00000000080d7faeULL, 0x0005e2000c901c46ULL, 0x000000001100720cULL, 0x080fe20003f66070ULL,
0x000000ffff077224ULL, 0x002fe200000e06ffULL, 0x000000001500720cULL, 0x080fe20003f26070ULL,
0x000000000a0f7faeULL, 0x0003e2000d101c46ULL, 0x000000001300720cULL, 0x000fe40003f46070ULL,
0x00005e0010147a11ULL, 0x000fe400078c38ffULL, 0x0000001912067210ULL, 0x000fc40007fbe0ffULL,
0x000000001700720cULL, 0x000fe20003f06070ULL, 0x000000011a007824ULL, 0x000fe200078e0213ULL,
0xfffffffc1d097812ULL, 0x004fe200078ee20cULL, 0x00000004130d7824ULL, 0x000fe200078e00ffULL,
0x00005f0010167a11ULL, 0x000fe200030f3c07ULL, 0x000000ffff077224ULL, 0x000fe200028e0618ULL,
0x000000001b127210ULL, 0x000fe20007fbe0ffULL, 0x0000001009097824ULL, 0x000fe200078e020eULL,
0xfffffffc0d0d7812ULL, 0x000fe200078ee20cULL, 0x000000011a087824ULL, 0x040fe400078e0215ULL,
0x000000011a0a7824ULL, 0x002fe200078e0217ULL, 0x0000000006097faeULL, 0x0003e2000e101c46ULL,
0x00000004110b7824ULL, 0x000fe200078e00ffULL, 0x000000081b107210ULL, 0x000fe20007f9e0ffULL,
0x0000000417177824ULL, 0x000fe200078e00ffULL, 0x0000000a1b007210ULL, 0x000fe20007fde0ffULL,
0x000000100d117824ULL, 0x000fe200078e020eULL, 0xfffffffc0b0b7812ULL, 0x000fe200078ee20cULL,
0x0000000415137824ULL, 0x000fc800078e00ffULL, 0x000000100b0f7824ULL, 0x000fe200078e020eULL,
0xfffffffc17077812ULL, 0x102fe200078ee20cULL, 0x000000ffff097224ULL, 0x000fe200028e06ffULL,
0x00005e0012087a11ULL, 0x040fe200078a38ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e06ffULL,
0xfffffffc13137812ULL, 0x000fe200078ee20cULL, 0x0000001007157824ULL, 0x100fe200078e020eULL,
0x00005f00120d7a11ULL, 0x000fe200028f3c09ULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x0000001914067210ULL, 0x000fe20007fbe0ffULL, 0x0000001013137824ULL, 0x000fe200078e020eULL,
0x00005e00100a7a11ULL, 0x000fc400078838ffULL, 0x00005e00000c7a11ULL, 0x000fe200078c38ffULL,
0x000000ffff077224ULL, 0x000fe200028e0616ULL, 0x0000001908087210ULL, 0x080fe40007fbe0ffULL,
0x00005f00100b7a11ULL, 0x000fe400020f3c0bULL, 0x00005f0000007a11ULL, 0x000fe200030f3c09ULL,
0x000000ffff097224ULL, 0x000fe200028e060dULL, 0x000000190a0a7210ULL, 0x080fe20007f9e0ffULL,
0x00000000060f7faeULL, 0x0003e2000d901c46ULL, 0x000000190c0c7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200020e060bULL, 0x0000000008117faeULL, 0x0003e2000d101c46ULL,
0x000000ffff0d7224ULL, 0x000fc600028e0600ULL, 0x000000000a137faeULL, 0x0003e8000c901c46ULL,
0x000000000c157faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000001a41007211ULL, 0x04afe400078ff0ffULL, 0x0000001041067811ULL, 0x000fe400078ff0ffULL,
0x000000001b007210ULL, 0x000fe40007f1e0ffULL, 0x0000001841087811ULL, 0x000fc400078ff0ffULL,
0x0000000841137811ULL, 0x040fe200078ff0ffULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0x00005e0000167a11ULL, 0x000fe200078038ffULL, 0x000000011a097824ULL, 0x000fe200078e0208ULL,
0x00000020410b7811ULL, 0x040fe400078ff0ffULL, 0x00005f0000227a11ULL, 0x000fe200000f3c07ULL,
0x000000011a077824ULL, 0x040fe200078e0206ULL, 0x00000028410d7811ULL, 0x000fe200078ff0ffULL,
0x0000000113007824ULL, 0x000fe200078e021aULL, 0x00000030410f7811ULL, 0x040fe200078ff0ffULL,
0x000000011a0c7824ULL, 0x040fe200078e020bULL, 0x0000003841117811ULL, 0x000fe200078ff0ffULL,
0x000000011a0e7824ULL, 0x040fe200078e020dULL, 0x00000003ff147819ULL, 0x000fe20000011641ULL,
0x000000011a107824ULL, 0x040fe200078e020fULL, 0x000000071b1c7210ULL, 0x040fe20007fbe0ffULL,
0x000000011a127824ULL, 0x000fe200078e0211ULL, 0x000000091b1a7210ULL, 0x040fe20007f1e0ffULL,
0x0000000406077824ULL, 0x000fe200078e00ffULL, 0x0000000314147812ULL, 0x000fe200078e4841ULL,
0x0000000408097824ULL, 0x000fe200078e00ffULL, 0x000000001b207210ULL, 0x000fe20007fde0ffULL,
0x000000040d157824ULL, 0x000fe200078e00ffULL, 0xfffffffc07067812ULL, 0x100fe200078ee214ULL,
0x000000040b0b7824ULL, 0x000fe200078e00ffULL, 0x0000100026237811ULL, 0x000fe200078e68ffULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc09077812ULL, 0x100fe200078ee214ULL,
0x000000ffff0d7224ULL, 0x000fe200030e06ffULL, 0x0000000c1b187210ULL, 0x000fe20007f3e0ffULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0xfffffffc15097812ULL, 0x100fe200078ee214ULL,
0x0000000413137824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b087812ULL, 0x100fe200078ee214ULL,
0x0000001006197824ULL, 0x100fe200078e0223ULL, 0x00005e00201e7a11ULL, 0x000fe200078c38ffULL,
0x00000010091f7824ULL, 0x100fe200078e0223ULL, 0x0000000e1b0e7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x000000101b107210ULL, 0x040fe20007f7e0ffULL,
0x00000010081d7824ULL, 0x100fe200078e0223ULL, 0x000000121b127210ULL, 0x000fe20007f9e0ffULL,
0x00000010071b7824ULL, 0x000fe200078e0223ULL, 0xfffffffc0f0b7812ULL, 0x100fe200078ee214ULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005f0020207a11ULL, 0x000fe200030f3c0dULL,
0x000000ffff157224ULL, 0x000fe200018e06ffULL, 0x00005e00180f7a11ULL, 0x000fe200078238ffULL,
0x000000100b217824ULL, 0x000fe200078e0223ULL, 0xfffffffc110c7812ULL, 0x000fe200078ee214ULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x00005e001a0d7a11ULL, 0x000fc400078038ffULL,
0x000000300a307812ULL, 0x000fe400078ec0ffULL, 0x00005e001c0b7a11ULL, 0x000fe400078a38ffULL,
0xfffffffc13007812ULL, 0x000fe400078ee214ULL, 0x00005f0018187a11ULL, 0x000fe200008f3c07ULL,
0x000000ffff077224ULL, 0x000fe200020e06ffULL, 0x0ffffffc14417812ULL, 0x000fe200078ef841ULL,
0x0000001000177824ULL, 0x000fe200078e0223ULL, 0x00005f001a1a7a11ULL, 0x000fe200000f3c09ULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x00005e0012147a11ULL, 0x000fe200078638ffULL,
0x0000001041417824ULL, 0x100fe200078e0223ULL, 0x0000001630067210ULL, 0x000fe20007f1e0ffULL,
0x000000100c237824ULL, 0x000fe200078e0223ULL, 0x00005f001c1c7a11ULL, 0x000fc400028f3c11ULL,
0x00005e000e117a11ULL, 0x000fe400078238ffULL, 0x00005e0010137a11ULL, 0x000fe400078438ffULL,
0x00005f0012007a11ULL, 0x000fe200018f3c07ULL, 0x000000ffff077224ULL, 0x000fe200000e0622ULL,
0x00005f000e167a11ULL, 0x000fe400008f3c09ULL, 0x0000001e30087210ULL, 0x000fe40007f1e0ffULL,
0x00005f0010157a11ULL, 0x000fe200010f3c15ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006417faeULL, 0x0003e2000b901c46ULL, 0x0000000b300a7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0620ULL, 0x0000000d300c7210ULL, 0x000fc40007f5e0ffULL,
0x0000000f300e7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e061cULL,
0x0000001130107210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e061aULL,
0x0000001330127210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e0618ULL,
0x0000001430147210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200020e0616ULL,
0x0000000008177faeULL, 0x0003e2000b901c46ULL, 0x000000ffff137224ULL, 0x000fe400028e0615ULL,
0x000000ffff157224ULL, 0x000fe200000e0600ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x000000000c1b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e4000b901c46ULL, 0x00f60400ff077984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000007ff7812ULL, 0x002fc60007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe20003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002026007824ULL, 0x002fc800078e0205ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x000000f006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105077812ULL, 0x040fe400078efcffULL, 0x0000000705057812ULL, 0x100fe400078e7800ULL,
0x0000000707077812ULL, 0x000fc600078e7800ULL, 0x0000000105057824ULL, 0x000fe400078e0206ULL,
0x0000000106077824ULL, 0x000fc600078e0207ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001005007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff047f8cULL, 0x002fe8000c80043fULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000022500720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000002d7919ULL, 0x000e620000000000ULL,
0x3db504f32f2f7820ULL, 0x020fe20000410000ULL, 0x0000640028317a24ULL, 0x000fe200078e02ffULL,
0x0000f68826307811ULL, 0x000fe200078e18ffULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0xffffffff02327810ULL, 0x000fe40007ffe0ffULL, 0x0000f60826337811ULL, 0x000fe400078e28ffULL,
0x0000010025297824ULL, 0x008fe200078e022cULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000292400720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x034fea0003800000ULL,
0x000000ffff377224ULL, 0x000fe200078e0035ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fc4000001ff00ULL,
0x0000000100347810ULL, 0x000fe20007ffe0ffULL, 0x00000d9000007945ULL, 0x000fe20003800000ULL,
0x0000002e27477224ULL, 0x020fc400078e02ffULL, 0x00000001ff287819ULL, 0x000fe40000011634ULL,
0x000000023400780cULL, 0x040fe40003f06070ULL, 0x0000000134547812ULL, 0x000fe200078ec0ffULL,
0x0000030028357a24ULL, 0x000fe400078e0225ULL, 0x000000ffff287224ULL, 0x000fe400078e0000ULL,
0x00000100353f7824ULL, 0x040fe200078e022cULL, 0x0000000135397810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff007224ULL, 0x000fe200078e0034ULL, 0x0000000137357812ULL, 0x000fc400078e0cffULL,
0x000000023900720cULL, 0x000fe40003f26070ULL, 0x000000403f367812ULL, 0x000fca00078ec0ffULL,
0x000000012b447824ULL, 0x000fcc00078e0236ULL, 0x000006b000009947ULL, 0x000fea0003800000ULL,
0x00000002ff417819ULL, 0x002fc8000001162dULL, 0x0000000841497810ULL, 0x040fe20007ffe0ffULL,
0x0000000141347824ULL, 0x140fe200078e0244ULL, 0x00000010414f7810ULL, 0x040fe40007ffe0ffULL,
0x0000001841517810ULL, 0x000fe20007ffe0ffULL, 0x0000000149367824ULL, 0x100fe200078e0244ULL,
0x0000003447397210ULL, 0x000fe20007f3e0ffULL, 0x000000014f387824ULL, 0x000fe200078e0244ULL,
0x0000003f24347217ULL, 0x000fe20007800000ULL, 0x00000004494d7824ULL, 0x000fe200078e00ffULL,
0x00000036473b7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff407224ULL, 0x000fe200008e06ffULL,
0x0000003847367210ULL, 0x000fe20007f7e0ffULL, 0x0000000134347824ULL, 0x000fe200078e0a3fULL,
0x00005e0039387a11ULL, 0x000fe200078238ffULL, 0x000000ffff3e7224ULL, 0x000fe200010e06ffULL,
0x0000002841557810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3d7224ULL, 0x000fe200018e06ffULL,
0x00005e00363c7a11ULL, 0x000fc400078638ffULL, 0x0000003041577810ULL, 0x000fe20007ffe0ffULL,
0x00000001553f7824ULL, 0x100fe200078e0244ULL, 0x00005f00363d7a11ULL, 0x000fe200018f3c3dULL,
0x0000000151367824ULL, 0x000fe200078e0244ULL, 0x00005e003b3a7a11ULL, 0x000fe400078438ffULL,
0x0000002041537810ULL, 0x040fe40007ffe0ffULL, 0x0000003841597810ULL, 0x000fe40007ffe0ffULL,
0x00005f0039397a11ULL, 0x000fe200008f3c40ULL, 0x0000000157407824ULL, 0x000fe200078e0244ULL,
0x00005f003b3b7a11ULL, 0x000fe200010f3c3eULL, 0x00000001533e7824ULL, 0x100fe200078e0244ULL,
0x0000003647427210ULL, 0x000fe20007f3e0ffULL, 0x0000000159367824ULL, 0x000fe200078e0244ULL,
0x000000344100720cULL, 0x000fe20003f46070ULL, 0x0000000454447824ULL, 0x000fe200078e00ffULL,
0x0000003f47437210ULL, 0x040fe20007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe200008e06ffULL,
0x0000004047457210ULL, 0x000fc40007f9e0ffULL, 0x0000003e47417210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff4c7224ULL, 0x000fe200030e06ffULL, 0x00000003ff407819ULL, 0x000fe2000001162dULL,
0x000000ffff4a7224ULL, 0x000fe200020e06ffULL, 0x00005e00423e7a11ULL, 0x000fe400078238ffULL,
0x0000003647477210ULL, 0x000fe20007f7e0ffULL, 0x0000000226367824ULL, 0x000fe200078e0235ULL,
0x00000003404e7812ULL, 0x000fe400078e482dULL, 0x00005f00423f7a11ULL, 0x000fe200008f3c3fULL,
0x000000ffff427224ULL, 0x000fe200028e06ffULL, 0x000000344900720cULL, 0x000fe20003f26070ULL,
0x000000ffff487224ULL, 0x000fe200018e06ffULL, 0x0000100036367811ULL, 0x000fc400078e60ffULL,
0x0ffffffc4e4b7812ULL, 0x100fe400078ef82dULL, 0xfffffffc44497812ULL, 0x000fe400078ee22dULL,
0xfffffffc4d4d7812ULL, 0x000fe200078ee24eULL, 0x000000104b4b7824ULL, 0x000fe200078e0236ULL,
0x00005e0041407a11ULL, 0x000fe200078a38ffULL, 0x0000001049387825ULL, 0x000fe200078e0038ULL,
0x00005e0045447a11ULL, 0x000fe400078638ffULL, 0x00005f0041417a11ULL, 0x000fe200028f3c42ULL,
0x000000104d4d7824ULL, 0x000fe200078e0236ULL, 0x00005e0047467a11ULL, 0x000fe200078838ffULL,
0x00000010493a7825ULL, 0x000fe200078e003aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000384b7faeULL, 0x0003e2000d101c46ULL, 0x00005e0043427a11ULL, 0x000fc400078a38ffULL,
0x00005f0045457a11ULL, 0x000fe200018f3c4aULL, 0x000000003a4d7faeULL, 0x0005e2000c901c46ULL,
0x000000344f00720cULL, 0x0c0fe20003f26070ULL, 0x000000044f4f7824ULL, 0x000fe200078e00ffULL,
0x000000345100720cULL, 0x0c0fe20003f46070ULL, 0x0000000451517824ULL, 0x000fe200078e00ffULL,
0x00005f0047477a11ULL, 0x000fe400020f3c48ULL, 0x000000345300720cULL, 0x0c0fe20003f66070ULL,
0x0000000453537824ULL, 0x000fe200078e00ffULL, 0x00005f0043437a11ULL, 0x000fe200028f3c4cULL,
0x0000001049387825ULL, 0x002fe200078e003cULL, 0x000000345500720cULL, 0x000fc40003f86070ULL,
0x000000345700720cULL, 0x080fe20003fa6070ULL, 0x0000000455557824ULL, 0x000fe200078e00ffULL,
0x000000345900720cULL, 0x000fe20003fc6070ULL, 0x0000000457577824ULL, 0x000fe200078e00ffULL,
0xfffffffc4f4b7812ULL, 0x100fe200078ee24eULL, 0x0000000459597824ULL, 0x000fe200078e00ffULL,
0xfffffffc514d7812ULL, 0x004fe200078ee24eULL, 0x00000010493a7825ULL, 0x000fe200078e003eULL,
0xfffffffc534f7812ULL, 0x100fe400078ee24eULL, 0xfffffffc55517812ULL, 0x000fe200078ee24eULL,
0x000000104b4b7824ULL, 0x000fe200078e0236ULL, 0xfffffffc57537812ULL, 0x000fe200078ee24eULL,
0x000000104d4d7824ULL, 0x000fe200078e0236ULL, 0xfffffffc59557812ULL, 0x000fe200078ee24eULL,
0x000000104f4f7824ULL, 0x000fe200078e0236ULL, 0x00000000384b7faeULL, 0x0003e2000c901c46ULL,
0x00000010493c7825ULL, 0x000fc600078e0040ULL, 0x000000003a4d7faeULL, 0x0003e2000d101c46ULL,
0x0000001051517824ULL, 0x000fe400078e0236ULL, 0x00000010493e7825ULL, 0x000fe200078e0042ULL,
0x000000003c4f7faeULL, 0x0003e6000d901c46ULL, 0x0000001053537824ULL, 0x000fe200078e0236ULL,
0x000000003e517faeULL, 0x0003e2000e101c46ULL, 0x0000001049407825ULL, 0x000fc800078e0044ULL,
0x0000001055557824ULL, 0x000fe200078e0236ULL, 0x0000000040537faeULL, 0x0003e2000e901c46ULL,
0x0000001049427825ULL, 0x000fca00078e0046ULL, 0x0000000042557faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x000000082d3d7811ULL, 0x042fe400078ff0ffULL,
0x000000442d347211ULL, 0x040fe400078ff0ffULL, 0x000000102d3f7811ULL, 0x000fe200078ff0ffULL,
0x000000013d367824ULL, 0x000fe200078e0244ULL, 0x0000003447347210ULL, 0x000fe20007f3e0ffULL,
0x000000043d4d7824ULL, 0x000fe200078e00ffULL, 0x000000182d417811ULL, 0x000fe200078ff0ffULL,
0x000000043f4f7824ULL, 0x000fe200078e00ffULL, 0x0000003647367210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x00005e0034387a11ULL, 0x000fc400078238ffULL,
0x000000202d437811ULL, 0x000fe200078ff0ffULL, 0x000000ffff3b7224ULL, 0x000fe200010e06ffULL,
0x00005e00363a7a11ULL, 0x000fe400078438ffULL, 0x00005f0034397a11ULL, 0x000fe200008f3c39ULL,
0x00000001433c7824ULL, 0x040fe200078e0244ULL, 0x00000003ff347819ULL, 0x000fe2000001162dULL,
0x0000000443437824ULL, 0x000fe200078e00ffULL, 0x00005f00363b7a11ULL, 0x000fe200010f3c3bULL,
0x0000000226367824ULL, 0x000fe200078e0235ULL, 0x000000282d457811ULL, 0x000fc400078ff0ffULL,
0x000000302d497811ULL, 0x040fe400078ff0ffULL, 0x000000382d4b7811ULL, 0x000fe200078ff0ffULL,
0x00000001453d7824ULL, 0x100fe200078e0244ULL, 0x0000000334407812ULL, 0x100fe200078e482dULL,
0x000000013f347824ULL, 0x100fe200078e0244ULL, 0x0000100036557811ULL, 0x000fe200078e60ffULL,
0x0000000141367824ULL, 0x000fe200078e0244ULL, 0xfffffffc4d467812ULL, 0x000fe200078ee240ULL,
0x00000001493e7824ULL, 0x100fe200078e0244ULL, 0x0000003447427210ULL, 0x000fe20007f7e0ffULL,
0x000000014b3f7824ULL, 0x000fe200078e0244ULL, 0xfffffffc4f487812ULL, 0x100fe200078ee240ULL,
0x0000000441417824ULL, 0x000fe200078e00ffULL, 0xfffffffc434c7812ULL, 0x100fe200078ee240ULL,
0x0000000445457824ULL, 0x000fe200078e00ffULL, 0x0ffffffc40447812ULL, 0x000fe200078ef82dULL,
0x0000000449497824ULL, 0x000fe200078e00ffULL, 0xfffffffc414a7812ULL, 0x100fe200078ee240ULL,
0x000000044b4b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc454e7812ULL, 0x100fe200078ee240ULL,
0x000000ffff457224ULL, 0x000fe200018e06ffULL, 0xfffffffc49507812ULL, 0x100fe200078ee240ULL,
0x000000104a4d7824ULL, 0x100fe200078e0255ULL, 0xfffffffc4b527812ULL, 0x000fe200078ee240ULL,
0x00000010484b7824ULL, 0x100fe200078e0255ULL, 0x0000003647407210ULL, 0x040fe20007f5e0ffULL,
0x0000001044597824ULL, 0x100fe200078e0255ULL, 0x0000003c47417210ULL, 0x040fe20007f3e0ffULL,
0x0000001046497824ULL, 0x100fe200078e0255ULL, 0x00005e00423c7a11ULL, 0x000fe200078c38ffULL,
0x000000104c4f7824ULL, 0x000fe200078e0255ULL, 0x0000003d47437210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200008e06ffULL, 0x0000003f47347210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200010e06ffULL, 0x0000003e47367210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff487224ULL, 0x000fe200018e06ffULL, 0x00005f00423d7a11ULL, 0x000fe200030f3c45ULL,
0x0000000454427824ULL, 0x000fe200078e00ffULL, 0x00005e00403e7a11ULL, 0x000fe200078438ffULL,
0x000000ffff457224ULL, 0x000fe200020e06ffULL, 0x00005e0036447a11ULL, 0x000fe200078638ffULL,
0x000000ffff477224ULL, 0x000fe200028e06ffULL, 0x00005f00403f7a11ULL, 0x000fe200010f3c3fULL,
0x000000104e517824ULL, 0x000fe200078e0255ULL, 0xfffffffc42577812ULL, 0x000fe200078ee22dULL,
0x0000001050537824ULL, 0x100fe200078e0255ULL, 0x00005e0041407a11ULL, 0x000fe200078238ffULL,
0x0000001052557824ULL, 0x000fe200078e0255ULL, 0x00005e0043427a11ULL, 0x000fe200078438ffULL,
0x0000001057387825ULL, 0x000fe200078e0038ULL, 0x00005e0034467a11ULL, 0x000fc400078838ffULL,
0x00005f0041417a11ULL, 0x000fe200008f3c4aULL, 0x00000010573a7825ULL, 0x000fe200078e003aULL,
0x00005f0043437a11ULL, 0x000fe200010f3c48ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038597faeULL, 0x0003e2000b901c46ULL, 0x00005f0036457a11ULL, 0x000fe200018f3c45ULL,
0x00000010573c7825ULL, 0x040fe200078e003cULL, 0x00005f0034477a11ULL, 0x000fe200020f3c47ULL,
0x000000003a497faeULL, 0x0003e4000b901c46ULL, 0x00000010573e7825ULL, 0x040fe400078e003eULL,
0x000000003c4b7faeULL, 0x0003e4000b901c46ULL, 0x0000001057407825ULL, 0x000fc400078e0040ULL,
0x000000003e4d7faeULL, 0x0003e4000b901c46ULL, 0x0000001057427825ULL, 0x040fe400078e0042ULL,
0x00000000404f7faeULL, 0x0003e4000b901c46ULL, 0x0000001057447825ULL, 0x040fe400078e0044ULL,
0x0000000042517faeULL, 0x0003e4000b901c46ULL, 0x0000001057467825ULL, 0x000fc400078e0046ULL,
0x0000000044537faeULL, 0x0003e8000b901c46ULL, 0x0000000046557faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5400720cULL, 0x000fe20003f25270ULL,
0x000000b000007945ULL, 0x000fd80003800000ULL, 0x0000009000009947ULL, 0x000fea0003800000ULL,
0x00000300ff277624ULL, 0x000fc800078e00ffULL, 0x00000002272a7824ULL, 0x000fe400078e022aULL,
0xffffffffff277424ULL, 0x000fc600078e00ffULL, 0x000000032a00720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000231387824ULL, 0x002fe400078e022aULL,
0x00000004ff397424ULL, 0x000fc800078e00ffULL, 0x0000600038387625ULL, 0x000fca00078e0039ULL,
0x0000000638277981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000202d367810ULL, 0x040fe20007ffe0ffULL,
0x0000000226387824ULL, 0x002fe200078e0237ULL, 0xfffffff82d347812ULL, 0x040fe200078ec0ffULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe400078ec0ffULL,
0x0000000734447812ULL, 0x100fe200078ef82dULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x0000000736467812ULL, 0x000fe400078ef82dULL, 0x000000072d3a7812ULL, 0x000fc400078ec0ffULL,
0x00000001ff367819ULL, 0x000fe40000011644ULL, 0x00000001ff377819ULL, 0x000fe40000011646ULL,
0x0000100038547811ULL, 0x000fe400078e60ffULL, 0x000000083a557812ULL, 0x000fe400078ef82dULL,
0x0000000336457812ULL, 0x000fe400078ec0ffULL, 0x0000000337477812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000003445377212ULL, 0x000fe200078e3cffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000282d367211ULL, 0x000fc400078fe0ffULL,
0x00000034473d7212ULL, 0x000fe200078e3cffULL, 0x0000000444387824ULL, 0x000fe200078e0237ULL,
0x0000000736377812ULL, 0x000fe400078e7855ULL, 0x00000001344c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001038407824ULL, 0x100fe200078e0254ULL, 0x0000000236367810ULL, 0x000fe20007ffe0ffULL,
0x0000001055377824ULL, 0x000fe200078e0237ULL, 0x0000000234347810ULL, 0x000fe20007ffe0ffULL,
0x00000004463d7824ULL, 0x000fe200078e023dULL, 0x0000000736367812ULL, 0x000fe200078e7855ULL,
0x000000004040783bULL, 0x000e620000000200ULL, 0x0000001037377824ULL, 0x000fe200078e00ffULL,
0x000000043400780cULL, 0x000fe20003f25270ULL, 0x000000103d3d7824ULL, 0x000fe200078e0254ULL,
0x0000000428287810ULL, 0x000fe20007ffe0ffULL, 0x0000001055367824ULL, 0x000fe200078e0236ULL,
0x000000003738783bULL, 0x0004e60000000200ULL, 0x0000001036367824ULL, 0x000fe200078e00ffULL,
0x000000003d3c783bULL, 0x000f220000000200ULL, 0x0000004c45377212ULL, 0x004fca00078e3cffULL,
0x0000000444377824ULL, 0x000fc800078e0237ULL, 0x0000001037377824ULL, 0x000fca00078e0254ULL,
0x000000003750783bULL, 0x000ea20000000200ULL, 0x00000040ff48723eULL, 0x082fe400020006ffULL,
0x00000040ff49723eULL, 0x000fe400030006ffULL, 0x00000041ff4a723eULL, 0x080fe400020006ffULL,
0x00000041ff4b723eULL, 0x000fe400030006ffULL, 0x00000042ff40723eULL, 0x080fe200020006ffULL,
0x000000483818723cULL, 0x008fe20000001818ULL, 0x00000042ff41723eULL, 0x000fc400030006ffULL,
0x00000043ff42723eULL, 0x080fe400020006ffULL, 0x00000043ff43723eULL, 0x000fc600030006ffULL,
0x0000004a381c723cULL, 0x040ff0000000181cULL, 0x000000423848723cULL, 0x040fee0000001804ULL,
0x0000004c47077212ULL, 0x000fe200078e3cffULL, 0x000000403820723cULL, 0x000fe20000001820ULL,
0x000000003640783bULL, 0x000e620000000200ULL, 0x0000003cff04723eULL, 0x010fc400020006ffULL,
0x0000000446077824ULL, 0x000fe200078e0207ULL, 0x0000003cff05723eULL, 0x000fe400030006ffULL,
0x0000003dff3c723eULL, 0x080fe200020006ffULL, 0x0000001007077824ULL, 0x000fe200078e0254ULL,
0x0000003dff3d723eULL, 0x000fc600030006ffULL, 0x000000043808723cULL, 0x040fe20000001808ULL,
0x00000000074c783bULL, 0x000eec0000000200ULL, 0x0000003eff04723eULL, 0x080fe200020006ffULL,
0x0000003c380c723cULL, 0x000fe2000000180cULL, 0x0000003eff05723eULL, 0x000fe400030006ffULL,
0x0000003fff3e723eULL, 0x000fc400020006ffULL, 0x0000003fff3f723eULL, 0x000fc600030006ffULL,
0x000000043810723cULL, 0x040fee0000001810ULL, 0x00000050ff04723eULL, 0x084fe200020006ffULL,
0x0000003e3814723cULL, 0x000fe20000001814ULL, 0x00000050ff05723eULL, 0x000fe400030006ffULL,
0x00000051ff50723eULL, 0x000fc400020006ffULL, 0x00000051ff51723eULL, 0x000fc600030006ffULL,
0x000000044018723cULL, 0x042fee0000001818ULL, 0x00000052ff04723eULL, 0x000fe200020006ffULL,
0x00000050401c723cULL, 0x000fe2000000181cULL, 0x0000004cff36723eULL, 0x088fe400020006ffULL,
0x0000004cff37723eULL, 0x000fc400030006ffULL, 0x00000052ff05723eULL, 0x000fe400030006ffULL,
0x0000004dff4c723eULL, 0x080fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe200030006ffULL,
0x000000364008723cULL, 0x040fee0000001808ULL, 0x0000004eff36723eULL, 0x080fe200020006ffULL,
0x000000044020723cULL, 0x000fe20000001820ULL, 0x0000004eff37723eULL, 0x000fc400030006ffULL,
0x0000004fff4e723eULL, 0x080fe400020006ffULL, 0x0000004fff4f723eULL, 0x000fe400030006ffULL,
0x00000053ff04723eULL, 0x080fe200020006ffULL, 0x0000004c400c723cULL, 0x000fe2000000180cULL,
0x00000053ff05723eULL, 0x000fce00030006ffULL, 0x000000044004723cULL, 0x040ff00000001848ULL,
0x000000364010723cULL, 0x040ff00000001810ULL, 0x0000004e4014723cULL, 0x000fe20000001814ULL,
0xfffffb0000001947ULL, 0x000fee000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff377224ULL, 0x000fe200078e0035ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffeb3000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000030367f8cULL, 0x000fe2000c80043fULL,
0x000000192f197220ULL, 0x040fe20000410000ULL, 0x0000001e2f387220ULL, 0x040fe20000410000ULL,
0x000000182f187220ULL, 0x040fe20000410000ULL, 0x0000040030397984ULL, 0x000e620000000800ULL,
0x0000001a2f287220ULL, 0x040fe20000410000ULL, 0x0000001b2f347220ULL, 0x040fe20000410000ULL,
0x000000152f1e7220ULL, 0x040fe20000410000ULL, 0x0000001d2f1d7220ULL, 0x040fe20000410000ULL,
0x0000001f2f1f7220ULL, 0x040fe20000410000ULL, 0x000000202f207220ULL, 0x040fe20000410000ULL,
0x000000212f217220ULL, 0x040fe20000410000ULL, 0x000000112f1a7220ULL, 0x040fe20000410000ULL,
0x000000142f1b7220ULL, 0x040fe20000410000ULL, 0x000000222f227220ULL, 0x040fe20000410000ULL,
0x000000232f237220ULL, 0x040fe20000410000ULL, 0x000000062f3a7220ULL, 0x040fe20000410000ULL,
0x000000072f3b7220ULL, 0x040fe20000410000ULL, 0x0000000a2f3c7220ULL, 0x040fe20000410000ULL,
0x0000001c2f1c7220ULL, 0x040fe20000410000ULL, 0x000000042f047220ULL, 0x040fe20000410000ULL,
0x000000052f057220ULL, 0x040fe20000410000ULL, 0x000000082f087220ULL, 0x040fe20000410000ULL,
0x000000092f097220ULL, 0x040fe20000410000ULL, 0x0000000b2f3d7220ULL, 0x040fe20000410000ULL,
0x0000000c2f007220ULL, 0x040fe20000410000ULL, 0x0000000d2f067220ULL, 0x040fe20000410000ULL,
0x0000000e2f3e7220ULL, 0x040fe20000410000ULL, 0x0000000f2f3f7220ULL, 0x040fe20000410000ULL,
0x000000102f077220ULL, 0x040fe20000410000ULL, 0x000000122f407220ULL, 0x040fe20000410000ULL,
0x000000132f417220ULL, 0x040fe20000410000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0019ULL,
0x000000172f437220ULL, 0x040fe20000410000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0018ULL,
0x000000162f427220ULL, 0x000fe20000410000ULL, 0x000000ffff197224ULL, 0x000fc400078e001eULL,
0x000000ffff0d7224ULL, 0x000fe400078e001dULL, 0x000000ffff0e7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0021ULL, 0x000000ffff177224ULL, 0x000fe200078e001aULL,
0x8000000039ff7812ULL, 0x002fe20007804837ULL, 0x000000ffff187224ULL, 0x000fe400078e001bULL,
0x000000ffff1e7224ULL, 0x000fc400078e001fULL, 0x000000ffff1a7224ULL, 0x000fe400078e0028ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0034ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0038ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0022ULL, 0x000000ffff207224ULL, 0x000fe400078e0023ULL,
0x000000ffff217224ULL, 0x000fc400078e003aULL, 0x000000ffff0c7224ULL, 0x000fe400078e001cULL,
0x000000ffff107224ULL, 0x000fe400078e0004ULL, 0x000000ffff117224ULL, 0x000fe400078e0005ULL,
0x000000ffff127224ULL, 0x000fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fe400078e0009ULL,
0x000000ffff147224ULL, 0x000fc400078e0000ULL, 0x000000ffff157224ULL, 0x000fe400078e0006ULL,
0x000000ffff167224ULL, 0x000fe400078e0007ULL, 0x000000ffff227224ULL, 0x000fe400078e003bULL,
0x000000ffff237224ULL, 0x000fe400078e003cULL, 0x000000ffff287224ULL, 0x000fe400078e003dULL,
0x000000ffff347224ULL, 0x000fc400078e003eULL, 0x000000ffff387224ULL, 0x000fe400078e003fULL,
0x000000ffff397224ULL, 0x000fe400078e0040ULL, 0x000000ffff3a7224ULL, 0x000fe200078e0041ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3b7224ULL, 0x000fe400078e0042ULL, 0x000000ffff3c7224ULL, 0x000fe200078e0043ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x0000040030057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000042d1c7824ULL, 0x000fe200078e00ffULL, 0x000000322500720cULL, 0x000fc80003f05270ULL,
0xfffffff01c057812ULL, 0x000fca00078ec0ffULL, 0x0000008026007824ULL, 0x000fca00078e0205ULL,
0x00f4000000047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x000000022d087824ULL, 0x000fe400078e00ffULL, 0x0000000124297824ULL, 0x000fc600078e0a29ULL,
0x0000000608087812ULL, 0x000fc800078ec0ffULL, 0x0000000108367812ULL, 0x040fe400078efcffULL,
0x00000008083e7812ULL, 0x000fe400078efcffULL, 0x000000293600720cULL, 0x080fe40003f26070ULL,
0x0000001008367812ULL, 0x000fe400078efcffULL, 0x000000293e00720cULL, 0x080fe40003f06070ULL,
0x000000293600720cULL, 0x000fc40003fc6070ULL, 0x00000011083e7812ULL, 0x040fe400078efcffULL,
0x0000001808367812ULL, 0x040fe400078efcffULL, 0x000000290800720cULL, 0x080fe40003f46070ULL,
0x000000293e00720cULL, 0x080fe40003fa6070ULL, 0x000000293600720cULL, 0x000fe40003f66070ULL,
0x0000000908407812ULL, 0x000fc400078efcffULL, 0x00000019083e7812ULL, 0x040fe400078efcffULL,
0x0000002008367812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x000000294000720cULL, 0x080fe40003f86070ULL,
0x000000293e00720cULL, 0x080fe40003f46070ULL, 0x000000293600720cULL, 0x000fe40003f26070ULL,
0x00000021083e7812ULL, 0x040fe400078efcffULL, 0x0000002808367812ULL, 0x000fe400078efcffULL,
0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x000000293e00720cULL, 0x080fe40003f06070ULL, 0x000000293600720cULL, 0x000fe40003f86070ULL,
0x00000029083e7812ULL, 0x000fc400078efcffULL, 0x0000003008367812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x000000293e00720cULL, 0x000fc40003fc6070ULL, 0x000000293600720cULL, 0x000fe40003fa6070ULL,
0x00000031083e7812ULL, 0x040fe400078efcffULL, 0x0000003808367812ULL, 0x040fe400078efcffULL,
0x0000003908087812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x000000293e00720cULL, 0x080fe40003f66070ULL,
0x000000293600720cULL, 0x000fc40003f46070ULL, 0x000000290800720cULL, 0x000fe40003f26070ULL,
0xff7fffff28287808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff34347808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff38387808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff39397808ULL, 0x000fe40006800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff3a3a7808ULL, 0x000fe40005800000ULL,
0xff7fffff18187808ULL, 0x000fc40005000000ULL, 0xff7fffff3b3b7808ULL, 0x000fe40005000000ULL,
0xff7fffff19197808ULL, 0x000fe40004800000ULL, 0xff7fffff3c3c7808ULL, 0x000fe40004800000ULL,
0x0000000b04097209ULL, 0x004fe20007810000ULL, 0x0000001fff3f7424ULL, 0x000fe200078e00ffULL,
0x0000001a05047209ULL, 0x000fe20007810000ULL, 0xffffffffff427424ULL, 0x000fe200078e00ffULL,
0x0000000a09097209ULL, 0x000fe40007810000ULL, 0x0000001b04047209ULL, 0x000fc40007810000ULL,
0x0000000c09087209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000000d08097209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000000e09087209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fc40007810000ULL,
0x0000000f08097209ULL, 0x000fe40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x0000001009087209ULL, 0x000fe40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fc40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x0000002304057209ULL, 0x000fe40007810000ULL,
0x0000001308097209ULL, 0x000fe40007810000ULL, 0x0000002805057209ULL, 0x000fe40007810000ULL,
0x0000001409047209ULL, 0x000fe40007810000ULL, 0x0000003405057209ULL, 0x000fc40007810000ULL,
0x0000001504097209ULL, 0x000fe40007810000ULL, 0x0000003805047209ULL, 0x000fe40007810000ULL,
0x0000001609087209ULL, 0x000fe40007810000ULL, 0x0000003904057209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x0000003a05047209ULL, 0x000fc40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x0000003b04057209ULL, 0x000fe40007810000ULL,
0x0000001908377209ULL, 0x000fe40007810000ULL, 0x0000003c053d7209ULL, 0x000fe20007810000ULL,
0x000017c27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0037047f89ULL, 0x0004e400000e0000ULL,
0x0000000437377209ULL, 0x00cfe20007810000ULL, 0x000017f27f007947ULL, 0x000fea000b800000ULL,
0x0c401f003d047f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006057f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007367f89ULL, 0x000f2200000e0000ULL, 0x000000043d087209ULL, 0x004fc60007810000ULL,
0x0c201f0037047f89ULL, 0x000ea200000e0000ULL, 0x0000000506097209ULL, 0x008fc60007810000ULL,
0x0c201f0008057f89ULL, 0x000ee200000e0000ULL, 0x0000003607367209ULL, 0x010fc60007810000ULL,
0x0c201f00093e7f89ULL, 0x002e6800000e0000ULL, 0x0c201f0036297f89ULL, 0x00092200000e0000ULL,
0x0000000437047209ULL, 0x004fe40007810000ULL, 0x0000000508057209ULL, 0x008fe40007810000ULL,
0x0000003e09067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3c003c00ff3e7424ULL, 0x002fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3c003c00ff3f7424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x0000000000057886ULL, 0x000fc400038e0100ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010819ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b3c197823ULL, 0x000fc80000010819ULL,
0x0000000d000d7308ULL, 0x000ee20000000800ULL, 0x000000080908723eULL, 0x002fce00000000ffULL,
0x0000001a001a7308ULL, 0x000ff00000000800ULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x008fce00000000ffULL, 0x0000001d000b7308ULL, 0x0007f00000000800ULL,
0x0000001e001e7308ULL, 0x000f220000000800ULL, 0x0000001a1b09723eULL, 0x002fe200000000ffULL,
0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000b1e0b723eULL, 0x010fce00000000ffULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x0000003e0840723cULL, 0x000fee00000018ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000001100117308ULL, 0x000ee20000000800ULL, 0x0000000e0f0c723eULL, 0x002fce00000000ffULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x00000010110e723eULL, 0x008fce00000000ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002200227308ULL, 0x000ee20000000800ULL, 0x0000001f200d723eULL, 0x002fce00000000ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x00000021220f723eULL, 0x008fce00000000ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x0000003e0c40723cULL, 0x000fee0000001840ULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ee20000000800ULL,
0x000000121310723eULL, 0x002fce00000000ffULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000002800287308ULL, 0x000e620000000800ULL, 0x000000141512723eULL, 0x008fe400000000ffULL,
0xfffffffc2d147812ULL, 0x000fc800078ec0ffULL, 0x000000141d1d7219ULL, 0x000fe200000006ffULL,
0x0000003400347308ULL, 0x000fe60000000800ULL, 0x000000001d1e73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0473c4ULL, 0x000f280000004000ULL, 0x00000038001b7308ULL, 0x000ea20000000800ULL,
0x000000232811723eULL, 0x002fce00000000ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000341b13723eULL, 0x004fce00000000ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000051dff7c12ULL, 0x008fe2000f80401eULL, 0x0000003e1040723cULL, 0x000fec0000001840ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000000700077308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000000ffULL, 0x0000003900397308ULL, 0x000ff00000000800ULL,
0x0000003a003a7308ULL, 0x000e620000000800ULL, 0x000000180716723eULL, 0x004fe400000000ffULL,
0x0000003629077209ULL, 0x000fca0007810000ULL, 0x0000003b003b7308ULL, 0x000ff00000000800ULL,
0x00000019001a7308ULL, 0x000ea20000000800ULL, 0x000000393a15723eULL, 0x002fe400000000ffULL,
0x0000003b1a17723eULL, 0x004fce00000000ffULL, 0x0000003e1440723cULL, 0x000fe20000001840ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000132204008947ULL, 0x010fde000b800000ULL,
0x001c1fff40187589ULL, 0x0002a400000e0000ULL, 0x000000001d1a73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x000000051dff7c12ULL, 0x008fda000f80401aULL, 0x0000134204008947ULL, 0x010fea000b800000ULL,
0x001c1fff42197589ULL, 0x00072800000e0000ULL, 0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL,
0x001c1fff001b7589ULL, 0x0006a400000e0000ULL, 0x00000002ff1d7819ULL, 0x00afe4000001162dULL,
0x0000000c1c437812ULL, 0x000fc400078ec0ffULL, 0x000000071d1e7812ULL, 0x040fe200078ec0ffULL,
0x000000081d237824ULL, 0x040fe200078e00ffULL, 0x0000001dff217212ULL, 0x000fe200078e33ffULL,
0x000000081d1f7824ULL, 0x000fe200078e00ffULL, 0x000000032dff7812ULL, 0x000fe2000780c0ffULL,
0x000000081d3c7824ULL, 0x040fe200078e00ffULL, 0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823207812ULL, 0x100fe400078ee21eULL, 0x000000011f227812ULL, 0x100fe200078ef61eULL,
0x000000081d4c7824ULL, 0x000fe200078e00ffULL, 0x000000021f287812ULL, 0x100fe200078ef61eULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0x000000031f347812ULL, 0x000fc400078ef61eULL,
0x000000041f367812ULL, 0x140fe400078ef61eULL, 0x000000051f387812ULL, 0x140fe400078ef61eULL,
0x000000061f3a7812ULL, 0x000fe200078ef61eULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee221ULL, 0x0000001dff217212ULL, 0x000fe400078e33ffULL,
0x000000071d1e7812ULL, 0x000fc400078ec0ffULL, 0x00009000261d7811ULL, 0x000fe400078e58ffULL,
0xfffffff8233e7812ULL, 0x100fe400078ee21eULL, 0x000000011f407812ULL, 0x140fe200078ef61eULL,
0x00000010201c7824ULL, 0x000fe200078e021dULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee221ULL,
0x0000001028207824ULL, 0x100fe200078e021dULL, 0x000000021f427812ULL, 0x140fe200078ef61eULL,
0x0000001036287824ULL, 0x100fe200078e021dULL, 0x000000031f447812ULL, 0x140fe200078ef61eULL,
0x000000103a367824ULL, 0x100fe200078e021dULL, 0x000000041f467812ULL, 0x140fe200078ef61eULL,
0x00000010403a7824ULL, 0x100fe200078e021dULL, 0x000000051f487812ULL, 0x140fe200078ef61eULL,
0x00000010443d7824ULL, 0x100fe200078e021dULL, 0x000000061f4a7812ULL, 0x000fe200078ef61eULL,
0x00000010221e7824ULL, 0x000fc400078e021dULL, 0x0000001034227824ULL, 0x100fe400078e021dULL,
0x0000001038347824ULL, 0x100fe400078e021dULL, 0x00000001431f7824ULL, 0x000fe400078e021cULL,
0x000000103c387824ULL, 0x100fe400078e021dULL, 0x000000103e1c7824ULL, 0x100fe200078e021dULL,
0x000000081f007388ULL, 0x0003e20000000800ULL, 0x00000010423c7824ULL, 0x000fc400078e021dULL,
0x00000010463e7824ULL, 0x100fe400078e021dULL, 0x00000010483f7824ULL, 0x100fe400078e021dULL,
0x000000104a407824ULL, 0x100fe400078e021dULL, 0x000000104c417824ULL, 0x000fe400078e021dULL,
0x00000001431d7824ULL, 0x040fe400078e021eULL, 0x0000000143217824ULL, 0x000fc400078e0220ULL,
0x0000000143237824ULL, 0x040fe200078e0222ULL, 0x0000000a1d007388ULL, 0x0007e20000000800ULL,
0x0000000143297824ULL, 0x040fe400078e0228ULL, 0x0000000143377824ULL, 0x040fe200078e0234ULL,
0x0000000c21007388ULL, 0x0007e20000000800ULL, 0x0000000143397824ULL, 0x040fe400078e0236ULL,
0x00000001433b7824ULL, 0x040fe200078e0238ULL, 0x0000000e23007388ULL, 0x0007e20000000800ULL,
0x00000001431c7824ULL, 0x000fc400078e021cULL, 0x00000001433a7824ULL, 0x040fe200078e023aULL,
0x0000001029007388ULL, 0x0007e20000000800ULL, 0x00000001433c7824ULL, 0x040fe400078e023cULL,
0x0000000143087824ULL, 0x042fe200078e023dULL, 0x0000001237007388ULL, 0x0007e20000000800ULL,
0x00000001433e7824ULL, 0x040fe400078e023eULL, 0x00000001431e7824ULL, 0x040fe200078e023fULL,
0x0000001439007388ULL, 0x0007e20000000800ULL, 0x0000000143407824ULL, 0x000fc400078e0240ULL,
0x0000000143207824ULL, 0x000fe200078e0241ULL, 0x000000163b007388ULL, 0x0007e80000000800ULL,
0x000000091c007388ULL, 0x0007e80000000800ULL, 0x0000000b3a007388ULL, 0x0007e80000000800ULL,
0x0000000d3c007388ULL, 0x0007e80000000800ULL, 0x0000000f08007388ULL, 0x0007e80000000800ULL,
0x000000113e007388ULL, 0x0007e80000000800ULL, 0x000000131e007388ULL, 0x0007e80000000800ULL,
0x0000001540007388ULL, 0x0007e80000000800ULL, 0x0000001720007388ULL, 0x0007e80000000800ULL,
0x00f0000400008388ULL, 0x0007e80000000c00ULL, 0x00f2001800008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000033ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080033ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100033ff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030025257a10ULL, 0x000fe20007ffe0ffULL,
0x0000180033ff7f8cULL, 0x0003e6000c80043fULL, 0x000000022500720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffcf4000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff287807ULL, 0x010fe40004000000ULL,
0x0000eb20002d7802ULL, 0x000fe40000000f00ULL, 0x00000f3000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e002cULL, 0xffff2ee000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40004000000ULL, 0x0000eb70002d7802ULL, 0x000fe40000000f00ULL,
0x00000ee000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e002cULL,
0xffff2f2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff377224ULL, 0x000fe200078e0000ULL,
0x0000ebe000287802ULL, 0x008fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff707424ULL, 0x000fc400078e00ffULL, 0x00000e3000007944ULL, 0x036fea0003c00000ULL,
0x000000ffff2c7224ULL, 0x004fe200078e0034ULL, 0xffff2f7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff377224ULL, 0x002fe200078e0000ULL, 0x0000ec5000287802ULL, 0x008fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x00000dc000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0034ULL,
0xffff2f3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff377224ULL, 0x000fe200078e002bULL,
0x0000ecc000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x00000d5000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff517224ULL, 0x004fe200078e0034ULL, 0xffff329000007947ULL, 0x000fea000383ffffULL,
0x000000ffff377224ULL, 0x002fe200078e004bULL, 0x0000ed3000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff707424ULL, 0x000fc400078e00ffULL,
0x00000ce000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0034ULL,
0xffff325000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x010fe40004000000ULL,
0x0000ed80002d7802ULL, 0x000fc40000000f00ULL, 0x00000cd000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e002cULL, 0xffff43f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40004000000ULL, 0x0000edd0002d7802ULL, 0x000fc40000000f00ULL,
0x00000c8000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e002cULL,
0xffff443000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6d7424ULL, 0x008fe200078e00ffULL,
0x0000ee3000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff707424ULL, 0x000fc400078e00ffULL,
0x00000be000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0034ULL,
0xffff44a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff377224ULL, 0x00afe200078e004bULL,
0x0000eea000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x00000b7000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e0034ULL, 0xffff455000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6d7424ULL, 0x000fe200078e00ffULL, 0x0000ef0000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x00000b1000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff6b7224ULL, 0x004fe200078e0034ULL, 0xffff481000007947ULL, 0x000fea000383ffffULL,
0x000000ffff377224ULL, 0x002fe200078e004bULL, 0x0000ef7000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x00000aa000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0034ULL,
0xffff47c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x004fe40004000000ULL,
0x0000efc0002d7802ULL, 0x000fc40000000f00ULL, 0x00000a9000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e002cULL, 0xffff57a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40004000000ULL, 0x0000f010002d7802ULL, 0x000fc40000000f00ULL,
0x00000a4000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e002cULL,
0xffff57e000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6d7424ULL, 0x002fe200078e00ffULL,
0x0000f07000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff707424ULL, 0x000fc400078e00ffULL,
0x000009a000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0034ULL,
0xffff585000007947ULL, 0x000fea000383ffffULL, 0x000000ffff377224ULL, 0x002fe200078e004bULL,
0x0000f0e000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0000093000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e0034ULL, 0xffff590000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6d7424ULL, 0x000fe200078e00ffULL, 0x0000f14000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x000008d000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff5f7224ULL, 0x004fe200078e0034ULL, 0xffff5bb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff377224ULL, 0x002fe200078e004bULL, 0x0000f1b000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x0000086000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0034ULL,
0xffff5b6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x010fe40004000000ULL,
0x0000f200002d7802ULL, 0x000fc40000000f00ULL, 0x0000085000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff287224ULL, 0x000fe200078e002cULL, 0xffff6a3000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40004000000ULL, 0x0000f250002d7802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff287224ULL, 0x000fe200078e002cULL,
0xffff6a7000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6d7424ULL, 0x008fe200078e00ffULL,
0x0000f2b000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff707424ULL, 0x000fc400078e00ffULL,
0x0000076000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff287224ULL, 0x004fe200078e0034ULL,
0xffff6ae000007947ULL, 0x000fea000383ffffULL, 0x000000ffff377224ULL, 0x00afe200078e004bULL,
0x0000f32000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x000006f000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff287224ULL, 0x004fe200078e0034ULL, 0xffff6b9000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6d7424ULL, 0x000fe200078e00ffULL, 0x0000f38000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0000069000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff2d7224ULL, 0x004fe200078e0034ULL, 0xffff6e5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff377224ULL, 0x002fe200078e004bULL, 0x0000f3f000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x0000062000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0034ULL,
0xffff6e0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff297224ULL, 0x000fe200078e0037ULL,
0x0000f45000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3e7424ULL, 0x000fc400078e00ffULL,
0x0000058000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0029ULL,
0xffffe7f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff297224ULL, 0x000fe200078e003dULL,
0x0000f4b000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3e7424ULL, 0x002fc400078e00ffULL,
0x0000052000007944ULL, 0x020fea0003c00000ULL, 0x000000293d407209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e0006ULL, 0x0000f50000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff3e7424ULL, 0x002fc400078e00ffULL, 0x000004d000007944ULL, 0x000fea0003c00000ULL,
0x0000002906067209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e0007ULL,
0x0000f55000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3e7424ULL, 0x002fc400078e00ffULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x0000002907367209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e0037ULL, 0x0000f5a000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff3e7424ULL, 0x002fc400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x0000002937047209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e0040ULL,
0x0000f5f000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff3e7424ULL, 0x002fc400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x0000002940057209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e0006ULL, 0x0000f64000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff3e7424ULL, 0x002fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000002906067209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e0036ULL,
0x0000f69000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff3e7424ULL, 0x002fc400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0xffffe6b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e0040ULL, 0x0000f70000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fc400078e00ffULL, 0x00001c1fff6d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff707224ULL, 0x000fe400078e001dULL, 0x0000031000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e0034ULL, 0xffffec7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x002fe200078e0042ULL, 0x0000f78000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fe400078e00ffULL, 0x00001c1fff6d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff707224ULL, 0x000fe400078e001dULL, 0x0000029000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff377224ULL, 0x002fe200078e00ffULL, 0x0000f7e000287802ULL, 0x000fe20000000f00ULL,
0x00001c1fff6d7424ULL, 0x000fc400078e00ffULL, 0x000000ffff707224ULL, 0x000fe400078e001dULL,
0x000000ffff197224ULL, 0x004fe400078e0034ULL, 0x0000023000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff707224ULL, 0x002fe200078e001dULL, 0x0000f84000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fe400078e00ffULL, 0x00001c1fff6d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1a7224ULL, 0x004fe400078e0034ULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0034ULL, 0xffffebb000007947ULL, 0x000fea000383ffffULL,
0x018000003a007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000003a00008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000005ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff3aff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000005ff7212ULL, 0x000fe4000780c0ffULL, 0x800000003a057812ULL, 0x000fd600078ec0ffULL,
0x0080000005000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003a00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xffff063004007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000004200007348ULL, 0x000fe80003800000ULL, 0x0c00003e29297389ULL, 0x0002a200000e003fULL,
0xffff05f008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff297424ULL, 0x000fe200078e00ffULL,
0x0000007000007348ULL, 0x000fe80003800000ULL, 0x0000003736347389ULL, 0x0002a200000e006dULL,
0xffff05b028007950ULL, 0x000fea0003c3ffffULL, 0x000000012800780cULL, 0x000fe20003f05070ULL,
0x0000004900007348ULL, 0x000fe80003800000ULL, 0x00000000ff297424ULL, 0x000fd000078e00ffULL,
0x0000000000287806ULL, 0x000fc800040e0100ULL, 0x00000049282c7212ULL, 0x000fe200078ec0ffULL,
0x000000ffff287224ULL, 0x000fc800078e002dULL, 0xffff054028007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000003d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009b8ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000a48ULL, 0x0000000000000880ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000012c8ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000012e8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000012f8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001318ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000013a8ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000013b0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000013c0ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001580ULL, 0x000000000000fb80ULL, 0x7300001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000011100ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000011110ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000011110ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000011590ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000013a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000fd58ULL, 0x000000000000fd58ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000011100ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000011590ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_89_cubin_len = 71280;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
