/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_16_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x000000000000fc90ULL, 0x000000000000f810ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x000000000000e3f0ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x000000000000e560ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x000000000000e5a0ULL, 0x00000000000000e0ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x000000000000e680ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000e3f000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x0038540400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808892ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0000e3f000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80809c0828808081ULL, 0xaa08288080ac0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080aa920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL,
0x0000e56000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80809c0828808081ULL, 0xac08288080aa0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080ac920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000016000000000ULL,
0x0000e5a000000000ULL, 0x000000e000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL,
0x0008120400000076ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000007c00043704ULL, 0x0000000d00080a04ULL,
0x0058190300580160ULL, 0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL,
0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL,
0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x0018310400ff1b03ULL, 0x0000d7f00000d270ULL, 0x0000d8700000d800ULL,
0x0000d8900000d880ULL, 0xffffffff00e82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500000fffffffffULL, 0x0500000f0500000fULL, 0xffffffff0500000fULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00e82804ffffffffULL, 0x00000100000000c0ULL,
0x00001950000018b0ULL, 0x00001a00000019c0ULL, 0x00001fc000001f90ULL, 0x00002ee000002e40ULL,
0x00002f9000002f60ULL, 0x0000346000003420ULL, 0x0000432000004280ULL, 0x000043d0000043a0ULL,
0x0000488000004850ULL, 0x000055a000005500ULL, 0x0000564000005610ULL, 0x00005a7000005a60ULL,
0x0000626000006250ULL, 0x00008cf000008cd0ULL, 0x00009200000091d0ULL, 0x0000d1700000d140ULL,
0x0000d1900000d180ULL, 0x0000d1d00000d1b0ULL, 0x0000d2000000d1f0ULL, 0x0000d8c00000d860ULL,
0x0000d8e00000d8d0ULL, 0x0000df800000df10ULL, 0x0000e0300000dfd0ULL, 0x0000e0d00000e080ULL,
0x0000e1700000e120ULL, 0x0000e2100000e1c0ULL, 0x0000e3000000e280ULL, 0x0000e3c00000e360ULL,
0x0000017003e03904ULL, 0x0000f600000000ffULL, 0x000001b0003f0100ULL, 0x0000f60800000011ULL,
0x000001e0003f0130ULL, 0x0000f61000000011ULL, 0x00000210003f0130ULL, 0x0000f64800000011ULL,
0x00000240003f0120ULL, 0x0000f66800000011ULL, 0x00000460003f0120ULL, 0x0000f600000000ffULL,
0x00000660003f0107ULL, 0x0000f61400000049ULL, 0x00000780003f0102ULL, 0x0000f61000000049ULL,
0x00000c90003f0101ULL, 0x00000000000000ffULL, 0x00000d2000040107ULL, 0x0000002000000006ULL,
0x00000ea0003f0101ULL, 0x0000002400000006ULL, 0x00000f50003f0106ULL, 0x0000002400000006ULL,
0x00000fe0003f0106ULL, 0x0000002400000006ULL, 0x00001640003f0106ULL, 0x0000000000000066ULL,
0x000016b000040107ULL, 0x000000040000001cULL, 0x000016d000040106ULL, 0x0000f60c0000000fULL,
0x000017d0003f0106ULL, 0x0000f60c0000000fULL, 0x00001c80003f0106ULL, 0x000000040000001cULL,
0x00001d2000040106ULL, 0x000000040000001cULL, 0x000025a000040106ULL, 0x0000002000000006ULL,
0x00002620003f0101ULL, 0x0000000000000018ULL, 0x000026d0003f0101ULL, 0x0000002400000006ULL,
0x00002720003f0106ULL, 0x0000002400000006ULL, 0x000027b0003f0106ULL, 0x0000002400000006ULL,
0x00002c10003f0106ULL, 0x00000000000000ffULL, 0x00002c8000060107ULL, 0x000000040000005dULL,
0x00002ca0003f0106ULL, 0x0000f61c0000000fULL, 0x00002da0003f0106ULL, 0x0000f61c0000000fULL,
0x00003250003f0106ULL, 0x0000f64c00000057ULL, 0x00003310003f0106ULL, 0x0000f64c00000057ULL,
0x000039c0003f0106ULL, 0x0000002000000006ULL, 0x00003a50003f0101ULL, 0x0000000000000018ULL,
0x00003ae0003f0101ULL, 0x0000002400000006ULL, 0x00003b40003f0106ULL, 0x0000002400000006ULL,
0x00003bd0003f0106ULL, 0x0000002400000006ULL, 0x00004010003f0106ULL, 0x0000000000000066ULL,
0x0000408000040107ULL, 0x0000000400000040ULL, 0x000040a0003f0106ULL, 0x0000f62c0000000fULL,
0x000041e0003f0106ULL, 0x0000f62c0000000fULL, 0x00004670003f0106ULL, 0x0000f64c00000018ULL,
0x00004750003f0106ULL, 0x000000040000001aULL, 0x00004de0003f0106ULL, 0x0000002000000006ULL,
0x00004e60003f0101ULL, 0x0000000000000018ULL, 0x00004f00003f0101ULL, 0x0000002400000006ULL,
0x00004f50003f0106ULL, 0x0000002400000006ULL, 0x00004fe0003f0106ULL, 0x0000002400000006ULL,
0x00005300003f0106ULL, 0x00000000000000ffULL, 0x0000537000060107ULL, 0x000000040000005dULL,
0x00005390003f0106ULL, 0x0000f63c0000000fULL, 0x00005470003f0106ULL, 0x0000f63c0000000fULL,
0x00005910003f0106ULL, 0x0000f64c0000000aULL, 0x000059a0003f0106ULL, 0x000000040000005fULL,
0x00005f90003f0106ULL, 0x0000002000000006ULL, 0x00005ff0003f0101ULL, 0x0000f6400000000fULL,
0x0000ad80003f0101ULL, 0x0000f604000000ffULL, 0x0000ae10003f0106ULL, 0x0000f604000000ffULL,
0x0000b030003f0106ULL, 0x0000f600000000ffULL, 0x0000b040003f0101ULL, 0x0000f604000000ffULL,
0x0000b0c0003f0106ULL, 0x0000f604000000ffULL, 0x0000c630003f0106ULL, 0x0000f6140000003aULL,
0x0000ca20003f0106ULL, 0x0000f6140000003aULL, 0x0000de60003f0106ULL, 0x0000f6080000003aULL,
0x00053803003f0101ULL, 0x00009bf000141c04ULL, 0x0000b1100000a040ULL, 0x0000dec00000b1e0ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001ccULL, 0x0000001100000002ULL,
0x000000000000014cULL, 0x0000001100000002ULL, 0x00000000000000ccULL, 0x0000001100000002ULL,
0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001a2ULL, 0x0000001100000002ULL,
0x0000000000000122ULL, 0x0000001100000002ULL, 0x00000000000000a8ULL, 0x0000001100000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002300ULL,
0x00000004ff147424ULL, 0x000fe200078e00ffULL, 0x0000460000087ab9ULL, 0x000fe20000000a00ULL,
0x00005800ff127624ULL, 0x000fe200078e00ffULL, 0x0000000000037919ULL, 0x000e680000002200ULL,
0x0000000000097919ULL, 0x000ea80000002100ULL, 0x0000000000077919ULL, 0x000ee80000002700ULL,
0x0000000000177919ULL, 0x000f220000002600ULL, 0x0000000106007824ULL, 0x002fc800078e0203ULL,
0x0000008000117824ULL, 0x104fe200078e0209ULL, 0x00000005ff507819ULL, 0x000fe20000011609ULL,
0x00001fff06007589ULL, 0x000e6200000e0000ULL, 0x0000620007087625ULL, 0x008fe400078e0014ULL,
0x000000ff1100720cULL, 0x040fe40003f05270ULL, 0x000000031100780cULL, 0x040fe20003f44070ULL,
0x00001fff50507589ULL, 0x000ea200000e0000ULL, 0x0000007f1100780cULL, 0x040fe40003f24070ULL,
0x000000011100780cULL, 0x000fce0003f64070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff04a424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff05a424ULL, 0x000fe200078e00ffULL, 0x00f60002ff008388ULL, 0x0007e20000000a00ULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0x3fffff80ff0ca424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0da424ULL, 0x000fe200078e00ffULL, 0x00f608041100a388ULL, 0x0007e2000000ca00ULL,
0x3fffffc0ff0aa424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL,
0x00f6100c1100a388ULL, 0x0007e2000000ca00ULL, 0xff317217ff109424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0eb424ULL, 0x000fe200078e00ffULL, 0x00f6480a1100a388ULL, 0x0007e20000008a00ULL,
0x7fffffc0ff0fb424ULL, 0x000fc600078e00ffULL, 0x00f4001011009388ULL, 0x0007e80000004800ULL,
0x00f6680e1100b388ULL, 0x0007e80000008a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x01ce620000000000ULL,
0x0000000450047824ULL, 0x000fc400078e00ffULL, 0x0000001012027824ULL, 0x000fe400078e00ffULL,
0x0000001017037824ULL, 0x000fe400078e00ffULL, 0x00000100ff0e7424ULL, 0x000fe400078e00ffULL,
0x0000000702027224ULL, 0x000fe200078e0203ULL, 0x000000040f0b7211ULL, 0x042fe200078fe0ffULL,
0x000000100f047824ULL, 0x000fc600078e00ffULL, 0x000000020b0d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000102037824ULL, 0x040fe200078e020bULL, 0x000000070b057812ULL, 0x000fe400078ec0ffULL,
0x000000070d0c7812ULL, 0x000fe200078ec0ffULL, 0x00000001020a7824ULL, 0x000fe200078e020dULL,
0x000000f004117812ULL, 0x000fe200078ec0ffULL, 0x00005c0003027625ULL, 0x080fe200078e000eULL,
0x0000000f05067812ULL, 0x100fe400078e780fULL, 0x0000000f0c0c7812ULL, 0x000fe200078e780fULL,
0x00005c000a047625ULL, 0x000fe200078e000eULL, 0x0000001102027210ULL, 0x000fc60007f1e0ffULL,
0x000000100b067824ULL, 0x000fe200078e0206ULL, 0x0000001104047210ULL, 0x000fe20007f3e0ffULL,
0x000000100d0c7824ULL, 0x000fe400078e020cULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x00000010060b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x000000100c0d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e8000b901c48ULL, 0x00000000040d7faeULL, 0x0003e8000b901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008084e7981ULL, 0x014ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000f220000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000004ff527e24ULL, 0x010fe2000f8e00ffULL, 0x0000007f4e4f7810ULL, 0x004fc40007ffe0ffULL,
0x000000ff4e4d7810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff4f7819ULL, 0x000fe4000001164fULL,
0x00000008ff4d7819ULL, 0x000fca000001164dULL, 0x00009af000008947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe20000011650ULL, 0x0000001050497824ULL, 0x000fe400078e00ffULL,
0xffffffffff487424ULL, 0x000fe200078e00ffULL, 0x01ffffff00037812ULL, 0x00afca00078ec0ffULL,
0x00000002524a7824ULL, 0x000fca00078e0203ULL, 0x0000004f4a00720cULL, 0x000fda0003f06070ULL,
0x0000000207008824ULL, 0x000fe400078e00ffULL, 0x00006400ff038624ULL, 0x000fc800078e00ffULL,
0x0000640000038624ULL, 0x000fe400078e0203ULL, 0x00000003ff007424ULL, 0x000fe400078e00ffULL,
0x000000014a038824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6140049ff738cULL, 0x0003e20000000000ULL, 0x0000600003028625ULL, 0x000fe200078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000802488981ULL, 0x0004e2000c1e1900ULL,
0x00000001504c7812ULL, 0x000fe200078ec0ffULL, 0x0000008017177824ULL, 0x000fe200078e00ffULL,
0x00000001ff4b7819ULL, 0x000fe20000011650ULL, 0x0000000000007919ULL, 0x002e620000000000ULL,
0x0000000152047810ULL, 0x000fe20007ffe0ffULL, 0x000000104c067824ULL, 0x000fe200078e00ffULL,
0x000000004b0473c2ULL, 0x000f2200000e0000ULL, 0x00000080ff237424ULL, 0x000fe200078e00ffULL,
0x0000004d0400720cULL, 0x000fe20003f06070ULL, 0x0000000852027824ULL, 0x004fe200078e024bULL,
0x00f6100049ff7f8cULL, 0x0005e2000c80043fULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000002002047824ULL, 0x000fe200078e00ffULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fc4000001ff00ULL, 0x000000044e037217ULL, 0x000fca0007800000ULL,
0x0000000103037824ULL, 0x100fe200078e0a04ULL, 0x0000006017047812ULL, 0x000fe400078ef804ULL,
0x00000003ff057819ULL, 0x002fe20000011600ULL, 0x0000001000217824ULL, 0x000fe200078e00ffULL,
0x0000002003037807ULL, 0x000fe20000000000ULL, 0x0000f64804047891ULL, 0x010fe2000f8e203fULL,
0x00000004050d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000106097824ULL, 0x040fe200078e0205ULL,
0x0000000805157810ULL, 0x040fe40007ffe0ffULL, 0x0000000c051d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008090b7824ULL, 0x040fe200078e00ffULL, 0x0000000009087212ULL, 0x000fe200078e3cffULL,
0x00000001060f7824ULL, 0x040fe200078e020dULL, 0x0000000603037217ULL, 0x000fe20007800000ULL,
0x0000000106197824ULL, 0x040fe200078e0215ULL, 0xfffffff80b087812ULL, 0x000fe200078ee208ULL,
0x000000080f0b7824ULL, 0x040fe200078e00ffULL, 0x000000000f027212ULL, 0x080fe200078e3cffULL,
0x0000000819117824ULL, 0x000fe200078e00ffULL, 0x0000007f09097812ULL, 0x000fe200078ec0ffULL,
0x00000001061f7824ULL, 0x000fe200078e021dULL, 0xfffffff80b0a7812ULL, 0x000fe200078ee202ULL,
0x0000000103067824ULL, 0x000fe200078e0a06ULL, 0x0000000019027212ULL, 0x080fe200078e3cffULL,
0x000000081f0e7824ULL, 0x040fe200078e00ffULL, 0x000000001f0b7212ULL, 0x000fe200078e3cffULL,
0x0000008012037824ULL, 0x000fe200078e00ffULL, 0xfffffff8110c7812ULL, 0x000fe200078ee202ULL,
0x000020004b027824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fc400078ee20bULL,
0x0000007f0f0f7812ULL, 0x000fe400078ec0ffULL, 0x0000b000020b7810ULL, 0x000fe40007ffe0ffULL,
0x000000060500720cULL, 0x080fe40003f46070ULL, 0x0000007f19197812ULL, 0x000fe200078ec0ffULL,
0x0000001008117824ULL, 0x100fe200078e020bULL, 0x0000007f1f1f7812ULL, 0x000fe200078ec0ffULL,
0x000000100a137824ULL, 0x100fe200078e020bULL, 0x0000007021217812ULL, 0x000fe200078ec0ffULL,
0x000000100c1b7824ULL, 0x100fe200078e020bULL, 0x000000060d00720cULL, 0x080fe20003f26070ULL,
0x000000100e257824ULL, 0x000fe200078e020bULL, 0x000000061500720cULL, 0x000fe20003f06070ULL,
0x0000000348087224ULL, 0x008fc800078e0204ULL, 0x0000000108047824ULL, 0x040fe400078e0209ULL,
0x0000000108097824ULL, 0x000fe400078e020fULL, 0x00005e0004047625ULL, 0x000fc800078e0023ULL,
0x00000001080a7824ULL, 0x000fe200078e0219ULL, 0x00000021040e7210ULL, 0x000fe20007f7e0ffULL,
0x00000001080c7824ULL, 0x000fe400078e021fULL, 0x00005e0009087625ULL, 0x000fc800078e0023ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0023ULL, 0x0000002108087210ULL, 0x000fc60007f9e0ffULL,
0x00005e000c0c7625ULL, 0x000fe200078e0023ULL, 0x000000210a0a7210ULL, 0x080fe20007fbe0ffULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x000000ffff0f7224ULL, 0x000fe200018e0605ULL,
0x000000061d00720cULL, 0x000fe20003f66070ULL, 0x000000ffff097224ULL, 0x000fe200020e0609ULL,
0x000000210c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0b7224ULL, 0x000fe200028e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e117faeULL, 0x0005e2000d101c48ULL,
0xff317217ff047424ULL, 0x000fe200078e00ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0d7224ULL, 0x000fe200030e060dULL, 0x0000000008137faeULL, 0x0005e2000c901c48ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x0000f6484b067811ULL, 0x000fc400078e18ffULL,
0x000000000a1b7faeULL, 0x0005e2000c101c48ULL, 0x0000004d5200720cULL, 0x000fc60003f06070ULL,
0x000000000c257faeULL, 0x0003e8000d901c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x000000ffff257224ULL, 0x002fc600078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0000200006ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x000052f000000947ULL, 0x000fea0003800000ULL, 0x0000000207077824ULL, 0x002fe200078e00ffULL,
0x00007610ff6a7816ULL, 0x000fe2000000006aULL, 0x00006400ff087624ULL, 0x000fe200078e00ffULL,
0x00007610ff6b7816ULL, 0x000fe2000000006bULL, 0xff317217ff047424ULL, 0x000fc400078e00ffULL,
0x0000640007077624ULL, 0x000fe200078e0208ULL, 0x00007610ff087816ULL, 0x000fe20000000008ULL,
0x000000ffff717224ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fe400078e00ffULL,
0xffffffc049097812ULL, 0x000fca00078ec0ffULL, 0x0000010052097824ULL, 0x000fca00078e0209ULL,
0x0000004e0900720cULL, 0x000fda0003f06070ULL, 0x000051c000000947ULL, 0x022fea0003800000ULL,
0x00002400060a7984ULL, 0x000e620000000800ULL, 0x0000ffff6a097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff697224ULL, 0x000fc600078e004aULL, 0x00008880090d7816ULL, 0x000fe200000000ffULL,
0x000000ffff097224ULL, 0x000fc800078e0071ULL, 0x800000000d0b7824ULL, 0x000fca00078e00ffULL,
0x800000000aff7812ULL, 0x002fe2000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000076106b677816ULL, 0x000fe40000000067ULL, 0x000076106a0a7816ULL, 0x000fe2000000000aULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00002400060c7984ULL, 0x000e640000000800ULL,
0x800000000cff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000000d0d7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL, 0x0000000b000c7305ULL, 0x0002a4000021f000ULL,
0x3fa000000b0b7823ULL, 0x002fe200000100ffULL, 0x0000000c0000735dULL, 0x004fe40003800000ULL,
0x00002400060c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fc4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000300ff5e7624ULL, 0x000fe200078e00ffULL, 0x000000014a0b7812ULL, 0x000fe200078ec0ffULL,
0x0000010052647824ULL, 0x000fe200078e00ffULL, 0x00000001ff4b7819ULL, 0x000fe40000011650ULL,
0x000000010b00780cULL, 0x000fe40003f05070ULL, 0xffffffff5e5e7811ULL, 0x000fe200078e08ffULL,
0x000000204b0b7824ULL, 0x000fc600078e0264ULL, 0x000000015e5e7807ULL, 0x000fe40004000000ULL,
0x000000400b0b7810ULL, 0x000fc60007ffe0ffULL, 0x000000014a4a7824ULL, 0x000fe200078e025eULL,
0x00000060170c7812ULL, 0x000fc800078ef80bULL, 0x0000004f4a00720cULL, 0x000fe20003f06070ULL,
0x0000000348157224ULL, 0x000fe200078e020cULL, 0x00000003ff167819ULL, 0x000fe20000011600ULL,
0xffffffffff487424ULL, 0x000fe200078e00ffULL, 0x00000010490f7812ULL, 0x000fe400078ec0ffULL,
0x0000000416407810ULL, 0x000fce0007ffe0ffULL, 0x0000005e070d8210ULL, 0x000fe20007ffe069ULL,
0x00000004ff0e8424ULL, 0x000fe200078e00ffULL, 0x0000000b4e107217ULL, 0x000fe20007800000ULL,
0x0000000116117824ULL, 0x000fe400078e020fULL, 0x000060000d0c8625ULL, 0x000fc800078e000eULL,
0x0000000140137824ULL, 0x000fe200078e020fULL, 0x000000080c488981ULL, 0x000362000c1e1900ULL,
0x0000000110107824ULL, 0x000fe200078e0a0bULL, 0x0000007f110b7812ULL, 0x040fe200078ec0ffULL,
0x0000000811197824ULL, 0x000fe200078e00ffULL, 0x00000000135b7212ULL, 0x080fe200078e3cffULL,
0x00000080ff1d7424ULL, 0x000fe200078e00ffULL, 0x00000001520e7810ULL, 0x000fe20007ffe0ffULL,
0x00000010001e7824ULL, 0x000fe200078e00ffULL, 0x0000000011127212ULL, 0x000fe200078e3cffULL,
0x0000000850577824ULL, 0x000fe200078e00ffULL, 0x0000000816427810ULL, 0x000fe20007ffe0ffULL,
0x00000008130c7824ULL, 0x002fe200078e00ffULL, 0x0000004d0e00720cULL, 0x000fe20003f06070ULL,
0x00000008711c7824ULL, 0x000fe200078e00ffULL, 0x0000000c16447810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80c5b7812ULL, 0x000fe200078ee25bULL, 0x00000001150c7824ULL, 0x000fe200078e020bULL,
0xfffffff819627812ULL, 0x000fe200078ee212ULL, 0x0000000142197824ULL, 0x100fe200078e020fULL,
0x0000002010107807ULL, 0x000fe20000000000ULL, 0x00005e000c0c7625ULL, 0x000fe200078e001dULL,
0x000000701e1f7812ULL, 0x000fe400078ec0ffULL, 0xfffffff057577812ULL, 0x000fe200078ec0ffULL,
0x00000001441b7824ULL, 0x100fe200078e020fULL, 0x0000000f100e7217ULL, 0x000fe20007800000ULL,
0x0000000819117824ULL, 0x040fe200078e00ffULL, 0x00000000195a7212ULL, 0x080fe200078e3cffULL,
0x000000081b127824ULL, 0x040fe200078e00ffULL, 0x0000001f0c107210ULL, 0x000fe20007f1e0ffULL,
0x00000000570473c2ULL, 0x000e6200000e0000ULL, 0x000000081c667812ULL, 0x000fe200078e0cffULL,
0x000000010e0f7824ULL, 0x000fe200078e0a0fULL, 0x000000001b597212ULL, 0x000fc400078e3cffULL,
0x0000007f130c7812ULL, 0x000fe400078ec0ffULL, 0xfffffff8115a7812ULL, 0x000fe200078ee25aULL,
0x000000ffff117224ULL, 0x000fe200000e060dULL, 0x00000000660573c2ULL, 0x000ea200000e0000ULL,
0x00001000710d7824ULL, 0x000fe200078e00ffULL, 0xfffffff812597812ULL, 0x000fe200078ee259ULL,
0x0000000115127824ULL, 0x000fe200078e020cULL, 0x0000000f1600720cULL, 0x000fe40003f06070ULL,
0x000010000d167812ULL, 0x000fe200078e0cffULL, 0x00005e0012127625ULL, 0x000fe200078e001dULL,
0x0000007f190d7812ULL, 0x000fc400078ec0ffULL, 0x0000007f1b0e7812ULL, 0x000fe200078ec0ffULL,
0x000020004b167824ULL, 0x000fe200078e0216ULL, 0x0000001f12127210ULL, 0x000fe20007f5e0ffULL,
0x0000000115187824ULL, 0x040fe200078e020dULL, 0x0000000f4000720cULL, 0x000fe20003f26070ULL,
0x00000001151a7824ULL, 0x000fe200078e020eULL, 0x0000b00016167810ULL, 0x000fe20007ffe0ffULL,
0x00005e0018187625ULL, 0x000fe200078e001dULL, 0x0000000f4400720cULL, 0x000fe20003f66070ULL,
0x0000f64804047890ULL, 0x002fe4000fffe03fULL, 0x00005e001a1a7625ULL, 0x000fe200078e001dULL,
0x0000001f18187210ULL, 0x000fe20007f9e0ffULL, 0x0000000504057290ULL, 0x004fc4000fffe03fULL,
0x000000ffff137224ULL, 0x000fe200010e0613ULL, 0x0000000f4200720cULL, 0x000fe20003f46070ULL,
0x0000001062627824ULL, 0x100fe200078e0216ULL, 0x0000001f1a1a7210ULL, 0x000fe20007fbe0ffULL,
0x000000105b617824ULL, 0x100fe400078e0216ULL, 0x000000ffff197224ULL, 0x000fe200020e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010627faeULL, 0x0003e2000c101c48ULL,
0x000000105a607824ULL, 0x100fe400078e0216ULL, 0x000000ffff1b7224ULL, 0x000fe200028e061bULL,
0x0000000012617faeULL, 0x0003e2000c901c48ULL, 0x00000010595f7824ULL, 0x000fc400078e0216ULL,
0x00000004500f7824ULL, 0x000fe200078e00ffULL, 0x0000000018607faeULL, 0x0003e8000d101c48ULL,
0x000000001a5f7faeULL, 0x0003e2000d901c48ULL, 0xfffffff00f0f7812ULL, 0x000fc600078ec0ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000004041c127984ULL, 0x0022a20008000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f60c000f167984ULL, 0x000ee20000000800ULL,
0x0000ffff6b107812ULL, 0x000fe400078ec0ffULL, 0x0000ffff08117812ULL, 0x000fe400078ec0ffULL,
0x00008880101d7816ULL, 0x000fc400000000ffULL, 0x0000888011107816ULL, 0x000fc600000000ffULL,
0x800000001d117824ULL, 0x000fe400078e00ffULL, 0x8000000010137824ULL, 0x000fc600078e00ffULL,
0x8000000012ff7812ULL, 0x004fe40007804811ULL, 0x8000000016ff7812ULL, 0x008fe20007824813ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff117424ULL, 0x000fe400078e00ffULL, 0x8000000010137824ULL, 0x000fe400078e00ffULL,
0x0000001100127305ULL, 0x0004e4000021f000ULL, 0x3fa0000011117823ULL, 0x004fe200000100ffULL,
0x000000120000735dULL, 0x008fe40003800000ULL, 0x00f60c000f127984ULL, 0x000ea40000000800ULL,
0x8000000012ff7812ULL, 0x004fc40007824813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000002050127824ULL, 0x000fe200078e00ffULL,
0x00000001ff137819ULL, 0x000fe20000011600ULL, 0x00000001ff407424ULL, 0x000fe200078e00ffULL,
0x000000701e117812ULL, 0x000fe400078ec0ffULL, 0xffffff8012127812ULL, 0x000fe400078ec0ffULL,
0x0000000c13137812ULL, 0x000fc800078ec0ffULL, 0x0000001213157210ULL, 0x000fca0007ffe011ULL,
0x00f0000015197984ULL, 0x000ea80000000800ULL, 0x00f2000015167984ULL, 0x0007220000000800ULL,
0x000000041900720bULL, 0x004fda0003f3d000ULL, 0x0000000000187806ULL, 0x000fc800008e0100ULL,
0x0000ffff181e7812ULL, 0x000fda000782c0ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000041900720bULL, 0x018fe40003f34000ULL, 0x0000001904417209ULL, 0x000fe40007810000ULL,
0x00000002ff1a7819ULL, 0x000fc60000011600ULL, 0x8000004104157221ULL, 0x000fe20000010000ULL,
0x000000081a1b7810ULL, 0x000fc60007ffe0ffULL, 0x3fb8aa3b15187820ULL, 0x000fe20000410000ULL,
0x00000002ff157819ULL, 0x000fe40000011650ULL, 0x0000000000047806ULL, 0x000fe400008e0100ULL,
0x000000501500720cULL, 0x000fe20003f25270ULL, 0x0000001800187308ULL, 0x000ea20000000800ULL,
0x0000ffff041f7812ULL, 0x000fc800078e3cffULL, 0x0000001f1eff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff407807ULL, 0x000fc60001000000ULL, 0x0000008050049824ULL, 0x000fe200078e0211ULL,
0x00001f1b181b7589ULL, 0x004ea600000e0000ULL, 0x0000000113049824ULL, 0x000fe400078e0204ULL,
0x8000004119192221ULL, 0x000fe20000010000ULL, 0x0000001805057220ULL, 0x000fe20000410000ULL,
0x00001f1a181a7589ULL, 0x000ee400000e0000ULL, 0x3fb8aa3b19192820ULL, 0x000fc40000410000ULL,
0x00f4004104009388ULL, 0x0009e40000000800ULL, 0x0000001900142308ULL, 0x000e620000000800ULL,
0x000000ffff047224ULL, 0x010fe200078e0041ULL, 0x0000001b23237220ULL, 0x084fe20000410000ULL,
0x0000001b22227220ULL, 0x080fe20000410000ULL, 0x0000001b33337220ULL, 0x080fe20000410000ULL,
0x0000001b32327220ULL, 0x080fe20000410000ULL, 0x0000001b37377220ULL, 0x080fe20000410000ULL,
0x0000001b36367220ULL, 0x080fe20000410000ULL, 0x0000001b27277220ULL, 0x080fe20000410000ULL,
0x0000001b26267220ULL, 0x080fe20000410000ULL, 0x0000001b2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001b2a2a7220ULL, 0x080fe20000410000ULL, 0x0000001b3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001b3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001b3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001b3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001b2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001b2e2e7220ULL, 0x000fe20000410000ULL, 0x0000001a21217220ULL, 0x088fe20000410000ULL,
0x0000001a20207220ULL, 0x080fe20000410000ULL, 0x0000001a31317220ULL, 0x080fe20000410000ULL,
0x0000001a30307220ULL, 0x080fe20000410000ULL, 0x0000001a35357220ULL, 0x080fe20000410000ULL,
0x0000001a34347220ULL, 0x080fe20000410000ULL, 0x0000001a25257220ULL, 0x080fe20000410000ULL,
0x0000001a24247220ULL, 0x080fe20000410000ULL, 0x0000001a29297220ULL, 0x080fe20000410000ULL,
0x0000001a28287220ULL, 0x080fe20000410000ULL, 0x0000001a39397220ULL, 0x080fe20000410000ULL,
0x0000001a38387220ULL, 0x080fe20000410000ULL, 0x0000001a3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001a3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001a2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001a2c2c7220ULL, 0x000fe20000410000ULL, 0x0000001416162220ULL, 0x002fc80000410000ULL,
0x0000000516057221ULL, 0x018fe20000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x000004041c157984ULL, 0x000ea20008000800ULL, 0x800000001d167824ULL, 0x000fca00078e00ffULL,
0x8000000015ff7812ULL, 0x004fe20007804816ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000001d1d7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff157424ULL, 0x000fc800078e00ffULL, 0x0000001500167305ULL, 0x0004e4000021f000ULL,
0x3fa0000015157823ULL, 0x004fe200000100ffULL, 0x000000160000735dULL, 0x008fe40003800000ULL,
0x000004041c167984ULL, 0x000ea40008000800ULL, 0x8000000016ff7812ULL, 0x004fc4000780481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000004501b7824ULL, 0x000fe200078e00ffULL, 0x0000000800157812ULL, 0x000fe200078ec0ffULL,
0x0000100050187824ULL, 0x000fe200078e00ffULL, 0x0000000700197812ULL, 0x000fe200078ec0ffULL,
0x0000000250167824ULL, 0x000fe200078e00ffULL, 0x000000041b1b7812ULL, 0x000fe400078ec0ffULL,
0xffffe00018187812ULL, 0x000fe400078ec0ffULL, 0x0000000715517812ULL, 0x140fe400078ef800ULL,
0x0000000715457812ULL, 0x000fe200078ec800ULL, 0x0000100071187824ULL, 0x000fe200078e0218ULL,
0x0000001b00447211ULL, 0x000fc400078fe0ffULL, 0x0000000416157812ULL, 0x000fe200078ec0ffULL,
0x0000020050167824ULL, 0x000fe200078e00ffULL, 0x0000004445547212ULL, 0x000fe400078e3cffULL,
0x0000000819427812ULL, 0x000fe400078ef800ULL, 0x0000001500437211ULL, 0x000fe200078fe0ffULL,
0x0000000851657824ULL, 0x000fe200078e0254ULL, 0x0000b00018467810ULL, 0x000fe40007ffe0ffULL,
0x0000000743157812ULL, 0x000fc400078e7842ULL, 0xfffff80016587812ULL, 0x000fe200078ec0ffULL,
0x0000001065187824ULL, 0x000fe200078e0246ULL, 0x0000000244447810ULL, 0x000fe20007ffe0ffULL,
0x0000000842157824ULL, 0x000fe200078e0215ULL, 0x00000002ff687819ULL, 0x000fe40000011600ULL,
0x00000044455c7212ULL, 0x000fe200078e3cffULL, 0x0000001015157824ULL, 0x000fe200078e0258ULL,
0x000000001818783bULL, 0x000ea20000004200ULL, 0x00000014ff41723eULL, 0x000fe400000000ffULL,
0x0000000851557824ULL, 0x000fe200078e025cULL, 0x00900000151c783bULL, 0x002fe20000000200ULL,
0x0000000868167810ULL, 0x000fc40007ffe0ffULL, 0x0000541041477816ULL, 0x000fe20000000041ULL,
0x0000001055467824ULL, 0x000fe200078e0246ULL, 0x0000991040407816ULL, 0x000fe400000000ffULL,
0x0000000243437810ULL, 0x000fe20007ffe0ffULL, 0x00001f68475d7589ULL, 0x000e6200000e0000ULL,
0x000000ff4000720cULL, 0x000fe40003f05270ULL, 0x0000000743437812ULL, 0x000fe200078e7842ULL,
0x00001f1647567589ULL, 0x000ee200000e0000ULL, 0x0000008051637811ULL, 0x000fc600078e18ffULL,
0x000000004644783bULL, 0x000f220000004200ULL, 0x0000000842437824ULL, 0x000fe400078e0243ULL,
0x0000000154547824ULL, 0x000fe400078e0263ULL, 0x0000001043517824ULL, 0x000fe200078e0258ULL,
0x0000312018407816ULL, 0x004fe400000000ffULL, 0x0000312019417816ULL, 0x000fe200000000ffULL,
0x0000005d1c1c8232ULL, 0x082fe20000000000ULL, 0x00000040ff18723eULL, 0x000fe200020006ffULL,
0x0000005d1e1e8232ULL, 0x000fe20000000000ULL, 0x00000041ff19723eULL, 0x000fe200020006ffULL,
0x000000561d1d8232ULL, 0x088fe20000000000ULL, 0x000031201a6c7816ULL, 0x000fe200000000ffULL,
0x000000561f1f8232ULL, 0x000fe20000000000ULL, 0x000031201b6d7816ULL, 0x000fcc00000000ffULL,
0x000000181c2c723cULL, 0x000fe2000000182cULL, 0x0000312044537816ULL, 0x010fe400000000ffULL,
0x0000312045587816ULL, 0x000fc800000000ffULL, 0x00000040ff18723eULL, 0x000fe400030006ffULL,
0x00000041ff19723eULL, 0x000fe400030006ffULL, 0x00000053ff44723eULL, 0x000fe400020006ffULL,
0x00000058ff45723eULL, 0x000fc600020006ffULL, 0x000000181c3c723cULL, 0x040fee000000183cULL,
0x0000100071187824ULL, 0x000fe200078e0202ULL, 0x0000006dff19723eULL, 0x080fe200020006ffULL,
0x000000441c24723cULL, 0x000fe20000001824ULL, 0x0000006dff6d723eULL, 0x000fc400030006ffULL,
0x0000b00018687810ULL, 0x000fe40007ffe0ffULL, 0x0000006cff18723eULL, 0x080fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe200030006ffULL, 0x0000001054407824ULL, 0x100fe200078e0268ULL,
0x00000053ff44723eULL, 0x000fe200030006ffULL, 0x000000015c537824ULL, 0x000fe200078e0263ULL,
0x00000058ff45723eULL, 0x000fe200030006ffULL, 0x000000181c38723cULL, 0x040fe20000001838ULL,
0x009000005118783bULL, 0x000e680000000200ULL, 0x000000004040783bULL, 0x000ea60000004200ULL,
0x0000006c1c28723cULL, 0x040fee0000001828ULL, 0x00003120466c7816ULL, 0x000fe200000000ffULL,
0x000000441c34723cULL, 0x000fe20000001834ULL, 0x00003120476d7816ULL, 0x000fe200000000ffULL,
0x0000001053467824ULL, 0x000fca00078e0268ULL, 0x0000006cff44723eULL, 0x080fe400020006ffULL,
0x0000006dff45723eULL, 0x080fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe400030006ffULL,
0x0000006dff6d723eULL, 0x000fc600030006ffULL, 0x000000441c30723cULL, 0x040fe20000001830ULL,
0x000000004644783bULL, 0x000eee0000004200ULL, 0x0000006c1c20723cULL, 0x000fe20000001820ULL,
0x0000005d18188232ULL, 0x082fe40000000000ULL, 0x0000005d1a1a8232ULL, 0x000fe20000000000ULL,
0x0000312040407816ULL, 0x004fe200000000ffULL, 0x0000005619198232ULL, 0x080fe20000000000ULL,
0x0000312041417816ULL, 0x000fe200000000ffULL, 0x000000561b1b8232ULL, 0x000fe20000000000ULL,
0x00000040ff1c723eULL, 0x000fe200020006ffULL, 0x0000010052567824ULL, 0x000fe200078e00ffULL,
0x00000041ff1d723eULL, 0x000fc400020006ffULL, 0x0000312042427816ULL, 0x000fe400000000ffULL,
0x0000312043437816ULL, 0x000fe400000000ffULL, 0x00000040ff40723eULL, 0x000fe200030006ffULL,
0x0000001c182c723cULL, 0x000fe2000000182cULL, 0x00000041ff41723eULL, 0x000fcc00030006ffULL,
0x00000042ff1c723eULL, 0x080fe200020006ffULL, 0x00000040183c723cULL, 0x040fe2000000183cULL,
0x00000043ff1d723eULL, 0x080fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400030006ffULL,
0x00000043ff43723eULL, 0x000fe400030006ffULL, 0x0000312044447816ULL, 0x008fe200000000ffULL,
0x0000001c1838723cULL, 0x000fe20000001838ULL, 0x0000312045457816ULL, 0x000fc400000000ffULL,
0x0000312046467816ULL, 0x000fe400000000ffULL, 0x0000312047477816ULL, 0x000fe400000000ffULL,
0x00000044ff1c723eULL, 0x080fe200020006ffULL, 0x000000421828723cULL, 0x000fe20000001828ULL,
0x00000045ff1d723eULL, 0x080fe400020006ffULL, 0x00000044ff44723eULL, 0x000fe400030006ffULL,
0x00000045ff45723eULL, 0x000fc600030006ffULL, 0x0000001c1824723cULL, 0x040fee0000001824ULL,
0x00000046ff1c723eULL, 0x080fe200020006ffULL, 0x000000441834723cULL, 0x000fe20000001834ULL,
0x00000047ff1d723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fc400030006ffULL,
0x00000047ff47723eULL, 0x000fc600030006ffULL, 0x0000001c1830723cULL, 0x040fee0000001830ULL,
0x00000002ff1d7819ULL, 0x000fe20000011650ULL, 0x000000461820723cULL, 0x000fee0000001820ULL,
0x0000f6101d187811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x0000200006ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000401d197824ULL, 0x000fe200078e0256ULL, 0x000000ff6bff7812ULL, 0x000fe2000780c0ffULL,
0x0000000018ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff6aff7812ULL, 0x000fc4000784c0ffULL,
0x0000004019197810ULL, 0x000fe40007ffe0ffULL, 0x00000001ff6e7807ULL, 0x000fe40000000000ULL,
0x0000004e1900720cULL, 0x000fe40003f06070ULL, 0x000000017100780cULL, 0x000fe40003f25270ULL,
0x00000001ff637807ULL, 0x000fe40001000000ULL, 0x0000006b6e6b7207ULL, 0x000fc40004800000ULL,
0x00007610636a7816ULL, 0x000fe4000000006aULL, 0x0000000171717812ULL, 0x000fc600078e0cffULL,
0x0000399000000947ULL, 0x000fea0003800000ULL, 0x0000240006197984ULL, 0x004ea20000000800ULL,
0x8000000063187824ULL, 0x000fca00078e00ffULL, 0x8000000019ff7812ULL, 0x004fe20007804818ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x0000240006197984ULL, 0x000ea40000000800ULL, 0x8000000019ff7812ULL, 0x004fe40007804818ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff187424ULL, 0x000fe400078e00ffULL, 0x80000000631a7824ULL, 0x000fe400078e00ffULL,
0x0000001800197305ULL, 0x0004e4000021f000ULL, 0x3fa0000018187823ULL, 0x004fe200000100ffULL,
0x000000190000735dULL, 0x008fe40003800000ULL, 0x0000240006197984ULL, 0x000ea40000000800ULL,
0x8000000019ff7812ULL, 0x004fc4000780481aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000001ff4b7819ULL, 0x000fe20000011650ULL,
0x00000008096f7824ULL, 0x000fe200078e00ffULL, 0x0000000152187810ULL, 0x000fe20007ffe0ffULL,
0x00005800481e7a24ULL, 0x020fe200078e02ffULL, 0x00000010491d7812ULL, 0x000fe200078ec0ffULL,
0x000000204b1b7824ULL, 0x000fe200078e0264ULL, 0x0000004d1800720cULL, 0x000fe20003f06070ULL,
0x00001000096d7824ULL, 0x000fe200078e00ffULL, 0x0000001d00197211ULL, 0x000fe200078fe8ffULL,
0x00000080ff437424ULL, 0x000fe200078e00ffULL, 0x000000801b1b7810ULL, 0x000fc40007ffe0ffULL,
0x000000086f1a7812ULL, 0x000fe400078ec0ffULL, 0x0000001b4e187217ULL, 0x000fe40007800000ULL,
0x0000f6484b407811ULL, 0x000fe200078e20ffULL, 0x000000001a0773c2ULL, 0x0004e200000e0000ULL,
0x000000086f5d7812ULL, 0x000fe200078e0cffULL, 0x00000001181c7824ULL, 0x100fe200078e0a1bULL,
0x0000000019187212ULL, 0x040fe200078e3cffULL, 0x0000000819197824ULL, 0x000fe200078e00ffULL,
0x00000060171b7812ULL, 0x000fe200078ef81bULL, 0x00000001405d7824ULL, 0x000fe200078e025dULL,
0x000000201c1c7807ULL, 0x000fe20000000000ULL, 0x00000000400673c2ULL, 0x0008e200000e0000ULL,
0xfffffff8195c7812ULL, 0x000fe200078ee218ULL, 0x000000801e1b7824ULL, 0x000fe200078e021bULL,
0x0000001c1d1c7217ULL, 0x000fc40007800000ULL, 0x00000003ff197819ULL, 0x000fe20000011600ULL,
0x000000010b187824ULL, 0x000fe200078e021bULL, 0x000010006d1a7812ULL, 0x004fe200078ec0ffULL,
0x000000011c1c7824ULL, 0x000fe200078e0a1dULL, 0x0000000c191d7810ULL, 0x040fe20007ffe0ffULL,
0x000000010c1e7824ULL, 0x000fe200078e021bULL, 0x0000000419417810ULL, 0x000fe20007ffe0ffULL,
0x000020004b1a7824ULL, 0x000fe200078e021aULL, 0x00000008191f7810ULL, 0x040fe40007ffe0ffULL,
0x0000001c1900720cULL, 0x080fe20003f66070ULL, 0x00005e0018187625ULL, 0x000fe200078e0043ULL,
0x0000001c4100720cULL, 0x000fc40003f46070ULL, 0x0000001c1f00720cULL, 0x080fe20003f26070ULL,
0x00005e001e1e7625ULL, 0x000fe200078e0043ULL, 0x0000001c1d00720cULL, 0x000fe40003f06070ULL,
0x0000001118187210ULL, 0x000fe20007f9e0ffULL, 0x000000010d1c7824ULL, 0x100fe200078e021bULL,
0x0000b0001a407810ULL, 0x010fe20007ffe0ffULL, 0x000000010e1b7824ULL, 0x000fe200078e021bULL,
0x0000000706067290ULL, 0x008fe2000fffe03fULL, 0x00005e001c1c7625ULL, 0x000fc800078e0043ULL,
0x00005e001b1a7625ULL, 0x000fe200078e0043ULL, 0x000000111c1c7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff197224ULL, 0x000fe200020e0619ULL, 0x000000111e1e7210ULL, 0x080fe20007f9e0ffULL,
0x000000105c5c7824ULL, 0x100fe200078e0240ULL, 0x000000111a1a7210ULL, 0x000fe20007fde0ffULL,
0x000000105b5b7824ULL, 0x100fe400078e0240ULL, 0x000000ffff1f7224ULL, 0x000fe200020e061fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000185c7faeULL, 0x0005e2000d901c48ULL,
0x000000105a5a7824ULL, 0x100fe400078e0240ULL, 0x000000ffff1d7224ULL, 0x000fe200028e061dULL,
0x000000001e5b7faeULL, 0x0005e2000d101c48ULL, 0x0000001059597824ULL, 0x000fc400078e0240ULL,
0x000000ffff1b7224ULL, 0x000fe200030e061bULL, 0x000000001c5a7faeULL, 0x0005e8000c901c48ULL,
0x000000001a597faeULL, 0x0005e8000c101c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000004005d197984ULL, 0x0044e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f61c000f1a7984ULL, 0x000f220000000800ULL, 0x0000ffff6b6b7812ULL, 0x000fe200078ec0ffULL,
0x80000000101b7824ULL, 0x000fc600078e00ffULL, 0x000088806b187816ULL, 0x000fca00000000ffULL,
0x8000000018187824ULL, 0x000fca00078e00ffULL, 0x8000000019ff7812ULL, 0x008fe40007804818ULL,
0x800000001aff7812ULL, 0x010fe2000782481bULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x00000004500f7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff187424ULL, 0x000fe400078e00ffULL, 0x80000000101a7824ULL, 0x000fe200078e00ffULL,
0xfffffff00f0f7812ULL, 0x000fe400078ec0ffULL, 0x0000001800197305ULL, 0x000724000021f000ULL,
0x3fa0000018187823ULL, 0x008fe200000100ffULL, 0x000000190000735dULL, 0x010fe40003800000ULL,
0x00f61c000f197984ULL, 0x000ee40000000800ULL, 0x8000000019ff7812ULL, 0x008fc4000782481aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000008011187810ULL, 0x000fe20007ffe012ULL, 0x00000001ff407424ULL, 0x000fc800078e00ffULL,
0x0000000113187824ULL, 0x000fca00078e0218ULL, 0x00f0000018197984ULL, 0x000ee80000000800ULL,
0x00f20000181a7984ULL, 0x0008620000000800ULL, 0x000000041900720bULL, 0x008fda0003f3d000ULL,
0x00000000001b7806ULL, 0x000fc800008e0100ULL, 0x0000ffff1b1e7812ULL, 0x000fda000782c0ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000041900720bULL, 0x012fe40003f34000ULL,
0x00000019041c7209ULL, 0x080fe40007810000ULL, 0x00000001501b7811ULL, 0x000fe400078ff0ffULL,
0x00000002ff427819ULL, 0x000fe20000011600ULL, 0x8000001c04187221ULL, 0x040fe20000010000ULL,
0x0000001904047209ULL, 0x000fc60007810000ULL, 0x3fb8aa3b181d7820ULL, 0x000fe40000410000ULL,
0x0000000000187806ULL, 0x000fe400008e0100ULL, 0x000000501b00720cULL, 0x000fe40003f25270ULL,
0x0000ffff181f7812ULL, 0x000fe200078e3cffULL, 0x0000001d001d7308ULL, 0x000e660000000800ULL,
0x0000001f1eff7212ULL, 0x000fce000784c0ffULL, 0x0000008050409824ULL, 0x000fc800078e0211ULL,
0x00000001131f9824ULL, 0x000fe200078e0240ULL, 0x00000001ff407807ULL, 0x000fe20001000000ULL,
0x00001f421d187589ULL, 0x002e6200000e0000ULL, 0x8000001c191e2221ULL, 0x000fe20000010000ULL,
0x0000001d05057220ULL, 0x000fe40000410000ULL, 0x00001f161d1b7589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b1e1e2820ULL, 0x000fc60000410000ULL, 0x00f4001c1f009388ULL, 0x0009e20000000800ULL,
0x0000001e00142308ULL, 0x000f620000000800ULL, 0x000000182c2c7220ULL, 0x082fe20000410000ULL,
0x000000182d2d7220ULL, 0x080fe20000410000ULL, 0x000000183c3c7220ULL, 0x080fe20000410000ULL,
0x000000183d3d7220ULL, 0x080fe20000410000ULL, 0x0000001838387220ULL, 0x080fe20000410000ULL,
0x0000001839397220ULL, 0x080fe20000410000ULL, 0x0000001828287220ULL, 0x080fe20000410000ULL,
0x0000001829297220ULL, 0x080fe20000410000ULL, 0x0000001824247220ULL, 0x080fe20000410000ULL,
0x0000001825257220ULL, 0x080fe20000410000ULL, 0x0000001834347220ULL, 0x080fe20000410000ULL,
0x0000001835357220ULL, 0x080fe20000410000ULL, 0x0000001830307220ULL, 0x080fe20000410000ULL,
0x0000001831317220ULL, 0x080fe20000410000ULL, 0x0000001820207220ULL, 0x080fe20000410000ULL,
0x0000001821217220ULL, 0x000fe20000410000ULL, 0x0000001b2e2e7220ULL, 0x088fe20000410000ULL,
0x0000001b2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001b3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001b3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001b3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001b3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001b2a2a7220ULL, 0x080fe20000410000ULL,
0x0000001b2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001b26267220ULL, 0x080fe20000410000ULL,
0x0000001b27277220ULL, 0x080fe20000410000ULL, 0x0000001b36367220ULL, 0x080fe20000410000ULL,
0x0000001b37377220ULL, 0x080fe20000410000ULL, 0x0000001b32327220ULL, 0x080fe20000410000ULL,
0x0000001b33337220ULL, 0x080fe20000410000ULL, 0x0000001b22227220ULL, 0x080fe20000410000ULL,
0x0000001b23237220ULL, 0x000fe20000410000ULL, 0x0000001a141a2220ULL, 0x020fc80000410000ULL,
0x000000051a057221ULL, 0x012fe20000010000ULL, 0x0000015000000947ULL, 0x000fea0003800000ULL,
0x0000000809187824ULL, 0x040fe200078e00ffULL, 0x000000010900780cULL, 0x000fc80003f05270ULL,
0x0000000818187812ULL, 0x000fca00078e0cffULL, 0x0000000157577824ULL, 0x000fe200078e0218ULL,
0x000000676e187207ULL, 0x000fc80004000000ULL, 0x00f64c0057197984ULL, 0x000e620000000800ULL,
0x0000ffff18187812ULL, 0x000fc800078ec0ffULL, 0x00008880181a7816ULL, 0x000fca00000000ffULL,
0x800000001a187824ULL, 0x000fca00078e00ffULL, 0x8000000019ff7812ULL, 0x002fe20007804818ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000001a1a7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x0000001800197305ULL, 0x0002e4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x000000190000735dULL, 0x008fe40003800000ULL, 0x00f64c0057197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fc4000780481aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000100009437824ULL, 0x000fe200078e00ffULL,
0x00980000151c783bULL, 0x000fe20000000200ULL, 0x0000100050187824ULL, 0x000fe200078e00ffULL,
0x00000014ff41723eULL, 0x000fe400000000ffULL, 0x0000100043437812ULL, 0x000fe400078e0cffULL,
0xffffe00018187812ULL, 0x000fe400078ec0ffULL, 0x00000002ff717819ULL, 0x000fe40000011600ULL,
0x0000b00018427810ULL, 0x000fc40007ffe043ULL, 0x0000541041417816ULL, 0x000fe40000000041ULL,
0x0000991040407816ULL, 0x000fe200000000ffULL, 0x0000001065587824ULL, 0x100fe200078e0242ULL,
0x0000b00002737810ULL, 0x000fe20007ffe043ULL, 0x0000001055577824ULL, 0x000fe200078e0242ULL,
0x00001f7141717589ULL, 0x000e6200000e0000ULL, 0x000000ff4000720cULL, 0x000fe40003f05270ULL,
0x0000001054687824ULL, 0x000fe200078e0273ULL, 0x000000005818783bULL, 0x000fe80000004200ULL,
0x00001f1641707589ULL, 0x000ee800000e0000ULL, 0x000000005744783bULL, 0x000f240000004200ULL,
0x000000711c1c8232ULL, 0x002fc40000000000ULL, 0x000000711e1e8232ULL, 0x000fe40000000000ULL,
0x000000701d1d8232ULL, 0x088fe40000000000ULL, 0x000000701f1f8232ULL, 0x000fe20000000000ULL,
0x0000312018187816ULL, 0x000fe400000000ffULL, 0x0000312019197816ULL, 0x000fe400000000ffULL,
0x00000018ff40723eULL, 0x000fe400020006ffULL, 0x00000019ff41723eULL, 0x000fc400020006ffULL,
0x00000018ff18723eULL, 0x000fe400030006ffULL, 0x00000019ff19723eULL, 0x000fe400030006ffULL,
0x000031201a6a7816ULL, 0x000fe200000000ffULL, 0x000000401c2c723cULL, 0x000fe2000000182cULL,
0x000031201b6b7816ULL, 0x000fe200000000ffULL, 0x000000006840783bULL, 0x000e620000004200ULL,
0x00003120446c7816ULL, 0x010fe400000000ffULL, 0x0000312045727816ULL, 0x000fc400000000ffULL,
0x0000006cff44723eULL, 0x000fe200020006ffULL, 0x000000181c3c723cULL, 0x000fe2000000183cULL,
0x00000072ff45723eULL, 0x000fcc00020006ffULL, 0x0000006aff18723eULL, 0x080fe200020006ffULL,
0x000000441c24723cULL, 0x040fe20000001824ULL, 0x0000006bff19723eULL, 0x080fe400020006ffULL,
0x0000006aff6a723eULL, 0x000fe400030006ffULL, 0x0000006bff6b723eULL, 0x000fe400030006ffULL,
0x0000006cff44723eULL, 0x000fe200030006ffULL, 0x000000181c38723cULL, 0x000fe20000001838ULL,
0x009800005118783bULL, 0x000ee20000000200ULL, 0x00000072ff45723eULL, 0x000fe200030006ffULL,
0x00000010536c7824ULL, 0x000fca00078e0273ULL, 0x0000006a1c28723cULL, 0x040fee0000001828ULL,
0x00003120466a7816ULL, 0x000fe200000000ffULL, 0x000000441c34723cULL, 0x000fe20000001834ULL,
0x00003120476b7816ULL, 0x000fe400000000ffULL, 0x0000312040407816ULL, 0x002fc400000000ffULL,
0x0000312041417816ULL, 0x000fe400000000ffULL, 0x0000006aff44723eULL, 0x080fe400020006ffULL,
0x0000006bff45723eULL, 0x080fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400030006ffULL,
0x0000006bff6b723eULL, 0x000fe400030006ffULL, 0x0000312042427816ULL, 0x000fe200000000ffULL,
0x000000441c30723cULL, 0x000fe20000001830ULL, 0x000000006c44783bULL, 0x000e620000004200ULL,
0x0000312043437816ULL, 0x000fcc00000000ffULL, 0x0000006a1c20723cULL, 0x000fe20000001820ULL,
0x0000007118188232ULL, 0x088fe40000000000ULL, 0x000000711a1a8232ULL, 0x000fe40000000000ULL,
0x0000007019198232ULL, 0x080fe40000000000ULL, 0x000000701b1b8232ULL, 0x000fe20000000000ULL,
0x00000040ff1c723eULL, 0x000fe400020006ffULL, 0x00000041ff1d723eULL, 0x000fc400020006ffULL,
0x000000010900780cULL, 0x000fca0003f05270ULL, 0x0000001c182c723cULL, 0x000fee000000182cULL,
0x00000040ff1c723eULL, 0x000fe400030006ffULL, 0x00000041ff1d723eULL, 0x000fce00030006ffULL,
0x0000001c183c723cULL, 0x000fe2000000183cULL, 0x0000312044447816ULL, 0x002fe400000000ffULL,
0x0000312045457816ULL, 0x000fe400000000ffULL, 0x0000312046467816ULL, 0x000fe400000000ffULL,
0x00000042ff1c723eULL, 0x000fe400020006ffULL, 0x00000043ff1d723eULL, 0x000fe400020006ffULL,
0x0000312047477816ULL, 0x000fca00000000ffULL, 0x0000001c1838723cULL, 0x000fee0000001838ULL,
0x00000042ff1c723eULL, 0x000fe400030006ffULL, 0x00000043ff1d723eULL, 0x000fce00030006ffULL,
0x0000001c1828723cULL, 0x000fee0000001828ULL, 0x00000044ff1c723eULL, 0x000fe400020006ffULL,
0x00000045ff1d723eULL, 0x000fce00020006ffULL, 0x0000001c1824723cULL, 0x000fee0000001824ULL,
0x00000044ff1c723eULL, 0x000fe400030006ffULL, 0x00000045ff1d723eULL, 0x000fce00030006ffULL,
0x0000001c1834723cULL, 0x000fee0000001834ULL, 0x00000046ff1c723eULL, 0x080fe400020006ffULL,
0x00000047ff1d723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fc400030006ffULL,
0x00000047ff47723eULL, 0x000fc600030006ffULL, 0x0000001c1830723cULL, 0x040fee0000001830ULL,
0x00000002ff1d7819ULL, 0x000fe20000011650ULL, 0x000000461820723cULL, 0x000fee0000001820ULL,
0x0000f6201d187811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x0000200006ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000676e6e7207ULL, 0x000fe20004000000ULL, 0x0000000452197824ULL, 0x000fe200078e021dULL,
0x000000ff0aff7812ULL, 0x000fe2000780c0ffULL, 0x0000000018ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ff6eff7812ULL, 0x000fc4000782c0ffULL, 0x0000008019197811ULL, 0x000fe400078e30ffULL,
0x00000001ff677807ULL, 0x000fe40000800000ULL, 0x0000004e1900720cULL, 0x000fe40003f26070ULL,
0x0000000109717812ULL, 0x000fe4000784c0ffULL, 0x00000001ff6a7807ULL, 0x000fe40004000000ULL,
0x0000006e676b7207ULL, 0x000fce0005000000ULL, 0x0000258000001947ULL, 0x000fea0003800000ULL,
0x0000240006197984ULL, 0x008ee20000000800ULL, 0x00000001ff1a7807ULL, 0x000fca0004000000ULL,
0x800000001a187824ULL, 0x000fca00078e00ffULL, 0x8000000019ff7812ULL, 0x008fe20007824818ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x0000240006197984ULL, 0x000ee40000000800ULL, 0x8000000019ff7812ULL, 0x008fe40007824818ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x800000001a1a7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x0000001800197305ULL, 0x000724000021f000ULL, 0x3fa0000018187823ULL, 0x008fe200000100ffULL,
0x000000190000735dULL, 0x010fe40003800000ULL, 0x0000240006197984ULL, 0x000ee40000000800ULL,
0x8000000019ff7812ULL, 0x008fc4000782481aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x00000001694a7824ULL, 0x000fe400078e025eULL,
0x00000300ff187624ULL, 0x000fe400078e00ffULL, 0x00005800481c7a24ULL, 0x000fe200078e02ffULL,
0x000000014a197812ULL, 0x000fe200078ec0ffULL, 0xffffffffff487424ULL, 0x000fe200078e00ffULL,
0xffffffff18187811ULL, 0x000fe400078e08ffULL, 0x000000011900780cULL, 0x000fc80003f25070ULL,
0x0000000118197807ULL, 0x000fca0004800000ULL, 0x000000014a4a7824ULL, 0x000fe200078e0219ULL,
0x00000001ff4b7819ULL, 0x000fc80000011650ULL, 0x0000004f4a00720cULL, 0x000fe20003f26070ULL,
0x000000204b1a7824ULL, 0x000fca00078e0264ULL, 0x000000c01a1a7810ULL, 0x000fce0007ffe0ffULL,
0x000000014a189824ULL, 0x000fe400078e0207ULL, 0x00000004ff199424ULL, 0x000fe200078e00ffULL,
0x0000001a4e1d7217ULL, 0x000fc60007800000ULL, 0x0000600018189625ULL, 0x000fe200078e0019ULL,
0x00000001521e7810ULL, 0x000fc60007ffe0ffULL, 0x000000011d1d7824ULL, 0x100fe200078e0a1aULL,
0x0000000818489981ULL, 0x000762000c1e1900ULL, 0x0000004d1e00720cULL, 0x000fe20003f26070ULL,
0x00000080ff457424ULL, 0x000fe200078e00ffULL, 0x00000060171b7812ULL, 0x000fe200078ef81aULL,
0x00000008505e7824ULL, 0x000fe200078e00ffULL, 0x0000001049407812ULL, 0x000fe400078ec0ffULL,
0x000000201d1d7807ULL, 0x000fe20000800000ULL, 0x000000801c1c7824ULL, 0x000fe200078e021bULL,
0x00000003ff417819ULL, 0x000fc40000011600ULL, 0x0000001d401d7217ULL, 0x000fe20007800000ULL,
0x000000010b187824ULL, 0x108fe200078e021cULL, 0x00000004411f7810ULL, 0x040fe20007ffe0ffULL,
0x000000010c1a7824ULL, 0x000fe200078e021cULL, 0x0000000841437810ULL, 0x000fe20007ffe0ffULL,
0x000000011d407824ULL, 0x000fe200078e0a40ULL, 0xfffffff05e5e7812ULL, 0x000fe200078ec0ffULL,
0x000000010d1d7824ULL, 0x000fe400078e021cULL, 0x00005e0018187625ULL, 0x000fe200078e0045ULL,
0x000000404100720cULL, 0x000fc40003f46070ULL, 0x0000000c41417810ULL, 0x000fe20007ffe0ffULL,
0x00005e001a1a7625ULL, 0x000fe200078e0045ULL, 0x0000001118187210ULL, 0x000fc60007f3e0ffULL,
0x000000010e1e7824ULL, 0x000fe200078e021cULL, 0x000000111a1a7210ULL, 0x000fe20007f7e0ffULL,
0x00005e001d1c7625ULL, 0x000fc800078e0045ULL, 0x000000ffff197224ULL, 0x000fe200008e0619ULL,
0x000000111c1c7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e061bULL,
0x000000401f00720cULL, 0x080fe20003f26070ULL, 0x00005e001e1e7625ULL, 0x000fe200078e0045ULL,
0x000000404300720cULL, 0x080fe20003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018627faeULL, 0x0007e4000d101c48ULL, 0x000000ffff1d7224ULL, 0x000fe200020e061dULL,
0x000000404100720cULL, 0x000fe40003f86070ULL, 0x000000111e1e7210ULL, 0x000fc40007fbe0ffULL,
0x000000086f407812ULL, 0x000fe400078ec0ffULL, 0x0000f6485e417810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1f7224ULL, 0x000fe200028e061fULL, 0x000000001a617faeULL, 0x0007e6000c901c48ULL,
0x0000000141407824ULL, 0x000fe200078e0240ULL, 0x000000001c607faeULL, 0x0007e8000d901c48ULL,
0x000000001e5f7faeULL, 0x0007e8000e101c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000040040197984ULL, 0x0087220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f62c000f1a7984ULL, 0x000e620000000800ULL, 0x0000000109ff7812ULL, 0x000fe2000782c0ffULL,
0x80000000101b7824ULL, 0x000fe200078e00ffULL, 0x000000086f5f7812ULL, 0x000fc400078e0cffULL,
0x0000006e67607207ULL, 0x000fc80004800000ULL, 0x0000ffff60187812ULL, 0x000fc800078ec0ffULL,
0x00008880181f7816ULL, 0x000fca00000000ffULL, 0x800000001f187824ULL, 0x000fca00078e00ffULL,
0x8000000019ff7812ULL, 0x010fe40007844818ULL, 0x800000001aff7812ULL, 0x002fe2000786481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x00000001415f7824ULL, 0x000fe200078e025fULL,
0x000000b000003947ULL, 0x000fea0003800000ULL, 0x00000004500f7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff187424ULL, 0x000fe400078e00ffULL, 0x80000000101a7824ULL, 0x000fe200078e00ffULL,
0xfffffff00f0f7812ULL, 0x000fe400078ec0ffULL, 0x0000001800197305ULL, 0x000324000021f000ULL,
0x3fa0000018187823ULL, 0x002fe200000100ffULL, 0x000000190000735dULL, 0x010fe40003800000ULL,
0x00f62c000f197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fc4000786481aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000b947ULL, 0x000fea000383ffffULL,
0x0000010011187810ULL, 0x000fe20007ffe012ULL, 0x00000001ff407424ULL, 0x008fc800078e00ffULL,
0x0000000113187824ULL, 0x000fca00078e0218ULL, 0x00f0000018197984ULL, 0x000e680000000800ULL,
0x00f20000181a7984ULL, 0x0007220000000800ULL, 0x000000041900720bULL, 0x002fda0003f7d000ULL,
0x00000000001b7806ULL, 0x000fc800018e0100ULL, 0x0000ffff1b1e7812ULL, 0x000fda000786c0ffULL,
0x000003700000b947ULL, 0x000fea0003800000ULL, 0x000000041900720bULL, 0x018fe40003f74000ULL,
0x00000019041c7209ULL, 0x080fe40007810000ULL, 0x00000002501b7811ULL, 0x000fe400078ff0ffULL,
0x00000002ff427819ULL, 0x000fe20000011600ULL, 0x8000001c04187221ULL, 0x040fe20000010000ULL,
0x0000001904047209ULL, 0x000fc60007810000ULL, 0x3fb8aa3b181d7820ULL, 0x000fe40000410000ULL,
0x0000000000187806ULL, 0x000fe400018e0100ULL, 0x000000501b00720cULL, 0x000fe40003f65270ULL,
0x0000ffff18417812ULL, 0x000fe200078e3cffULL, 0x0000001d001d7308ULL, 0x000e660000000800ULL,
0x000000411eff7212ULL, 0x000fce000788c0ffULL, 0x000000805040b824ULL, 0x000fc800078e0211ULL,
0x000000011341b824ULL, 0x000fe200078e0240ULL, 0x00000001ff407807ULL, 0x000fe20002000000ULL,
0x00001f421d187589ULL, 0x002e6200000e0000ULL, 0x8000001c191e4221ULL, 0x000fe20000010000ULL,
0x0000001d05057220ULL, 0x000fe40000410000ULL, 0x00001f161d1b7589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b1e1e4820ULL, 0x000fc60000410000ULL, 0x00f4001c4100b388ULL, 0x0009e20000000800ULL,
0x0000001e00144308ULL, 0x000ea20000000800ULL, 0x000000182c2c7220ULL, 0x082fe20000410000ULL,
0x000000182d2d7220ULL, 0x080fe20000410000ULL, 0x000000183c3c7220ULL, 0x080fe20000410000ULL,
0x000000183d3d7220ULL, 0x080fe20000410000ULL, 0x0000001838387220ULL, 0x080fe20000410000ULL,
0x0000001839397220ULL, 0x080fe20000410000ULL, 0x0000001828287220ULL, 0x080fe20000410000ULL,
0x0000001829297220ULL, 0x080fe20000410000ULL, 0x0000001824247220ULL, 0x080fe20000410000ULL,
0x0000001825257220ULL, 0x080fe20000410000ULL, 0x0000001834347220ULL, 0x080fe20000410000ULL,
0x0000001835357220ULL, 0x080fe20000410000ULL, 0x0000001830307220ULL, 0x080fe20000410000ULL,
0x0000001831317220ULL, 0x080fe20000410000ULL, 0x0000001820207220ULL, 0x080fe20000410000ULL,
0x0000001821217220ULL, 0x000fe20000410000ULL, 0x0000001b2e2e7220ULL, 0x088fe20000410000ULL,
0x0000001b2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001b3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001b3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001b3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001b3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001b2a2a7220ULL, 0x080fe20000410000ULL,
0x0000001b2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001b26267220ULL, 0x080fe20000410000ULL,
0x0000001b27277220ULL, 0x080fe20000410000ULL, 0x0000001b36367220ULL, 0x080fe20000410000ULL,
0x0000001b37377220ULL, 0x080fe20000410000ULL, 0x0000001b32327220ULL, 0x080fe20000410000ULL,
0x0000001b33337220ULL, 0x080fe20000410000ULL, 0x0000001b22227220ULL, 0x080fe20000410000ULL,
0x0000001b23237220ULL, 0x000fe20000410000ULL, 0x0000001a141a4220ULL, 0x004fc80000410000ULL,
0x000000051a057221ULL, 0x018fe20000010000ULL, 0x0000015000002947ULL, 0x000fea0003800000ULL,
0x000000086f6f7812ULL, 0x000fe200078ec0ffULL, 0x800000001f197824ULL, 0x000fc800078e00ffULL,
0x000000015e187824ULL, 0x000fcc00078e026fULL, 0x00f64c0018187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fe40007844819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x00000008505e7824ULL, 0x000fe400078e00ffULL,
0x0000000809197824ULL, 0x000fe400078e00ffULL, 0x800000001f1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff05e5e7812ULL, 0x000fe200078ec0ffULL, 0x3e000000ff187424ULL, 0x000fe200078e00ffULL,
0x0000000819197812ULL, 0x000fc800078ec0ffULL, 0x0000f648191a7810ULL, 0x000fe40007ffe05eULL,
0x0000001800197305ULL, 0x0002e4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x000000190000735dULL, 0x008fe40003800000ULL, 0x000004001a197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fe4000784481cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000100050187824ULL, 0x000fe200078e00ffULL,
0x000010006d6d7812ULL, 0x000fe200078ec0ffULL, 0x00a00000151c783bULL, 0x000fe20000000200ULL,
0x00000014ff41723eULL, 0x000fc400000000ffULL, 0xffffe00018187812ULL, 0x000fe400078ec0ffULL,
0x00000002ff617819ULL, 0x000fe40000011600ULL, 0x0000b00018427810ULL, 0x000fe40007ffe06dULL,
0x0000541041417816ULL, 0x000fe40000000041ULL, 0x0000991040407816ULL, 0x000fe200000000ffULL,
0x0000001065187824ULL, 0x100fe200078e0242ULL, 0x0000b00002647810ULL, 0x000fe20007ffe06dULL,
0x0000001055447824ULL, 0x000fe200078e0242ULL, 0x00001f6141617589ULL, 0x000e6200000e0000ULL,
0x000000ff4000720cULL, 0x000fc60003f45270ULL, 0x000000001818783bULL, 0x000fe80000004200ULL,
0x00001f1641627589ULL, 0x000ee800000e0000ULL, 0x000000004444783bULL, 0x000f240000004200ULL,
0x000000611c1ca232ULL, 0x002fc40000000000ULL, 0x000000611e1ea232ULL, 0x000fe40000000000ULL,
0x000000621d1da232ULL, 0x088fe40000000000ULL, 0x000000621f1fa232ULL, 0x000fe20000000000ULL,
0x0000312018187816ULL, 0x000fe400000000ffULL, 0x0000312019197816ULL, 0x000fe400000000ffULL,
0x00000018ff40723eULL, 0x000fe400020006ffULL, 0x00000019ff41723eULL, 0x000fc400020006ffULL,
0x00000018ff18723eULL, 0x000fe400030006ffULL, 0x00000019ff19723eULL, 0x000fe400030006ffULL,
0x000031201b557816ULL, 0x000fe200000000ffULL, 0x000000401c2c723cULL, 0x000fe2000000182cULL,
0x0000312044447816ULL, 0x010fe400000000ffULL, 0x0000312045457816ULL, 0x000fc800000000ffULL,
0x000031201a407816ULL, 0x000fe200000000ffULL, 0x000000181c3c723cULL, 0x000fe2000000183cULL,
0x0000001054417824ULL, 0x000fe400078e0264ULL, 0x00000040ff54723eULL, 0x000fc800030006ffULL,
0x00000055ff19723eULL, 0x080fe400020006ffULL, 0x00000055ff55723eULL, 0x000fe400030006ffULL,
0x00000040ff18723eULL, 0x000fe400020006ffULL, 0x000000004140783bULL, 0x000e660000004200ULL,
0x000000541c28723cULL, 0x040fee0000001828ULL, 0x00000044ff54723eULL, 0x080fe200020006ffULL,
0x000000181c38723cULL, 0x000fe20000001838ULL, 0x00000045ff55723eULL, 0x000fe200020006ffULL,
0x00a000005118783bULL, 0x000ee20000000200ULL, 0x00000044ff44723eULL, 0x000fc400030006ffULL,
0x00000045ff45723eULL, 0x000fc600030006ffULL, 0x000000541c24723cULL, 0x040fee0000001824ULL,
0x0000312046547816ULL, 0x000fe200000000ffULL, 0x000000441c34723cULL, 0x000fe20000001834ULL,
0x0000312047557816ULL, 0x000fe200000000ffULL, 0x0000001053467824ULL, 0x000fca00078e0264ULL,
0x00000054ff44723eULL, 0x080fe400020006ffULL, 0x00000055ff45723eULL, 0x080fe400020006ffULL,
0x00000054ff54723eULL, 0x000fe400030006ffULL, 0x00000055ff55723eULL, 0x000fe400030006ffULL,
0x0000312040407816ULL, 0x002fe200000000ffULL, 0x000000441c30723cULL, 0x000fe20000001830ULL,
0x000000004644783bULL, 0x000e620000004200ULL, 0x0000312041417816ULL, 0x000fc400000000ffULL,
0x0000312042427816ULL, 0x000fe400000000ffULL, 0x0000312043437816ULL, 0x000fe400000000ffULL,
0x000000541c20723cULL, 0x000fe20000001820ULL, 0x000000611818a232ULL, 0x088fe40000000000ULL,
0x000000611a1aa232ULL, 0x000fe40000000000ULL, 0x000000621919a232ULL, 0x080fe40000000000ULL,
0x00000040ff1c723eULL, 0x000fe200020006ffULL, 0x000000621b1ba232ULL, 0x000fe20000000000ULL,
0x00000041ff1d723eULL, 0x000fc400020006ffULL, 0x00000040ff40723eULL, 0x000fe400030006ffULL,
0x00000041ff41723eULL, 0x000fc600030006ffULL, 0x0000001c182c723cULL, 0x040fee000000182cULL,
0x00000042ff1c723eULL, 0x080fe200020006ffULL, 0x00000040183c723cULL, 0x000fe2000000183cULL,
0x00000043ff1d723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fc400030006ffULL,
0x00000043ff43723eULL, 0x000fc600030006ffULL, 0x0000001c1838723cULL, 0x040fe20000001838ULL,
0x0000312044447816ULL, 0x002fe400000000ffULL, 0x0000312045457816ULL, 0x000fe400000000ffULL,
0x0000312046467816ULL, 0x000fe400000000ffULL, 0x00000044ff1c723eULL, 0x000fe200020006ffULL,
0x000000421828723cULL, 0x000fe20000001828ULL, 0x00000045ff1d723eULL, 0x000fe400020006ffULL,
0x0000312047477816ULL, 0x000fc400000000ffULL, 0x00000044ff44723eULL, 0x000fe400030006ffULL,
0x00000045ff45723eULL, 0x000fe200030006ffULL, 0x0000001c1824723cULL, 0x040fee0000001824ULL,
0x00000046ff1c723eULL, 0x000fe200020006ffULL, 0x000000441834723cULL, 0x000fe20000001834ULL,
0x00000047ff1d723eULL, 0x000fc400020006ffULL, 0x00000046ff46723eULL, 0x000fe400030006ffULL,
0x00000047ff47723eULL, 0x000fc600030006ffULL, 0x0000001c1830723cULL, 0x040fee0000001830ULL,
0x00000002ff1d7819ULL, 0x000fe20000011650ULL, 0x000000461820723cULL, 0x000fee0000001820ULL,
0x0000f6301d187811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x0000200006ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000401d197824ULL, 0x000fe200078e0256ULL, 0x000000ff60ff7812ULL, 0x000fe2000784c0ffULL,
0x0000000018ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ff0aff7812ULL, 0x000fc4000786c0ffULL,
0x000000c019197810ULL, 0x000fe40007ffe0ffULL, 0x00000001ff1c7807ULL, 0x000fe40001000000ULL,
0x0000004e1900720cULL, 0x000fe40003f46070ULL, 0x0000000109717812ULL, 0x000fe400078ec0ffULL,
0x00000001ff6a7807ULL, 0x000fe40001800000ULL, 0x0000001c676b7207ULL, 0x000fc40004800000ULL,
0x0000000171717812ULL, 0x000fca00078e3cffULL, 0x0000116000002947ULL, 0x000fea0003800000ULL,
0x00002400060a7984ULL, 0x008ee20000000800ULL, 0x8000000063197824ULL, 0x000fca00078e00ffULL,
0x800000000aff7812ULL, 0x008fe20007844819ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000002947ULL, 0x000fea0003800000ULL, 0x00002400060a7984ULL, 0x000ee40000000800ULL,
0x800000000aff7812ULL, 0x008fe40007844819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x8000000063637824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL, 0x0000000a00187305ULL, 0x000724000021f000ULL,
0x3fa000000a0a7823ULL, 0x008fe200000100ffULL, 0x000000180000735dULL, 0x010fe40003800000ULL,
0x0000240006187984ULL, 0x000ee40000000800ULL, 0x8000000018ff7812ULL, 0x008fc40007844863ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00000001ff4b7819ULL, 0x000fe20000011650ULL, 0x00000080ff1f7424ULL, 0x000fe200078e00ffULL,
0x00000300520a7a10ULL, 0x000fe40007ffe0ffULL, 0x00000003ff1e7819ULL, 0x000fe40000011600ULL,
0x000000010a1a7810ULL, 0x040fe20007ffe0ffULL, 0x000000080a187824ULL, 0x000fe200078e024bULL,
0x000000041e407810ULL, 0x000fe40007ffe0ffULL, 0x0000004d1a00720cULL, 0x000fe20003f46070ULL,
0x0000002018187824ULL, 0x000fe200078e00ffULL, 0x00000010491a7812ULL, 0x000fc800078ec0ffULL,
0x000000184e197217ULL, 0x000fe40007800000ULL, 0x00000060170a7812ULL, 0x000fc600078ef818ULL,
0x0000000119197824ULL, 0x000fe400078e0a18ULL, 0x0000000348187224ULL, 0x020fc600078e020aULL,
0x0000002019197807ULL, 0x000fe20001000000ULL, 0x000000010b0b7824ULL, 0x100fe400078e0218ULL,
0x000000010c0c7824ULL, 0x000fe200078e0218ULL, 0x000000191a197217ULL, 0x000fe20007800000ULL,
0x00005e000b0a7625ULL, 0x000fc800078e001fULL, 0x00000001191d7824ULL, 0x000fe200078e0a1aULL,
0x000000110a1a7210ULL, 0x000fe20007f5e0ffULL, 0x000000010d0a7824ULL, 0x000fe400078e0218ULL,
0x00005e000c0c7625ULL, 0x000fe200078e001fULL, 0x0000001d1e00720cULL, 0x000fc60003f66070ULL,
0x000000ffff1b7224ULL, 0x000fe200010e060bULL, 0x000000110c0c7210ULL, 0x000fe20007fbe0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e001fULL, 0x0000001d4000720cULL, 0x000fc60003f46070ULL,
0x000000010e187824ULL, 0x000fe200078e0218ULL, 0x0000000c1e0e7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x000000081e1e7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0018187625ULL, 0x000fe200078e001fULL, 0x000000110a0a7210ULL, 0x000fe20007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a5c7faeULL, 0x0007e2000d901c48ULL,
0x0000001d1e00720cULL, 0x080fe40003fc6070ULL, 0x0000001d0e00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff0b7224ULL, 0x000fe200020e060bULL, 0x0000001118187210ULL, 0x000fe20007f9e0ffULL,
0x000000000c5b7faeULL, 0x0007e8000d101c48ULL, 0x000000ffff197224ULL, 0x000fc800020e0619ULL,
0x000000000a5a7faeULL, 0x0007e8000f101c48ULL, 0x0000000018597faeULL, 0x0007e8000e901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a06ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000004005d5d7984ULL, 0x004ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f63c000f0b7984ULL, 0x008ee20000000800ULL,
0x0000001c67677207ULL, 0x000fe20004800000ULL, 0x80000000100c7824ULL, 0x000fc600078e00ffULL,
0x0000ffff670e7812ULL, 0x000fca00078ec0ffULL, 0x800000000e0a7824ULL, 0x000fca00078e00ffULL,
0x800000005dff7812ULL, 0x004fe4000784480aULL, 0x800000000bff7812ULL, 0x008fe2000786480cULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000003947ULL, 0x000fea0003800000ULL,
0x8000000010107824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL,
0x0000000a000b7305ULL, 0x0004e4000021f000ULL, 0x3fa000000a0a7823ULL, 0x004fe200000100ffULL,
0x0000000b0000735dULL, 0x008fe40003800000ULL, 0x00f63c000f0b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fc40007864810ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000b947ULL, 0x000fea000383ffffULL, 0x0000018011127810ULL, 0x000fca0007ffe012ULL,
0x0000000113127824ULL, 0x000fca00078e0212ULL, 0x00f00000120b7984ULL, 0x000ea80000000800ULL,
0x00f20000120a7984ULL, 0x0007220000000800ULL, 0x000000040b00720bULL, 0x004fda0003f7d000ULL,
0x00000000000c7806ULL, 0x000fc800018e0100ULL, 0x0000ffff0c107812ULL, 0x000fe2000786c0ffULL,
0x00000001ff0c7424ULL, 0x000fd800078e00ffULL, 0x000003700000b947ULL, 0x000fea0003800000ULL,
0x000000040b00720bULL, 0x018fe40003f74000ULL, 0x0000000b04127209ULL, 0x000fe40007810000ULL,
0x00000003500d7811ULL, 0x000fe400078ff0ffULL, 0x00000002ff1b7819ULL, 0x000fe20000011600ULL,
0x80000012040c7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fe40000410000ULL,
0x0000000000047806ULL, 0x000fe400018e0100ULL, 0x000000500d00720cULL, 0x000fe40003f65270ULL,
0x0000ffff04197812ULL, 0x000fe200078e3cffULL, 0x0000000c000c7308ULL, 0x000ea60000000800ULL,
0x0000001910ff7212ULL, 0x000fce000788c0ffULL, 0x000000805010b824ULL, 0x000fc800078e0211ULL,
0x000000011313b824ULL, 0x000fe200078e0210ULL, 0x00001f1b0c047589ULL, 0x004ea200000e0000ULL,
0x800000120b0d4221ULL, 0x000fe20000010000ULL, 0x0000000c05057220ULL, 0x000fe40000410000ULL,
0x00001f160c0b7589ULL, 0x00072200000e0000ULL, 0x3fb8aa3b0d0d4820ULL, 0x000fc60000410000ULL,
0x00f400121300b388ULL, 0x0003e20000000800ULL, 0x0000000d00144308ULL, 0x000f620000000800ULL,
0x00000001ff0c7807ULL, 0x008fe20002000000ULL, 0x000000042c2c7220ULL, 0x084fe20000410000ULL,
0x000000042d2d7220ULL, 0x080fe20000410000ULL, 0x000000043c3c7220ULL, 0x080fe20000410000ULL,
0x000000043d3d7220ULL, 0x080fe20000410000ULL, 0x0000000438387220ULL, 0x080fe20000410000ULL,
0x0000000439397220ULL, 0x080fe20000410000ULL, 0x0000000428287220ULL, 0x080fe20000410000ULL,
0x0000000429297220ULL, 0x080fe20000410000ULL, 0x0000000424247220ULL, 0x080fe20000410000ULL,
0x0000000425257220ULL, 0x080fe20000410000ULL, 0x0000000434347220ULL, 0x080fe20000410000ULL,
0x0000000435357220ULL, 0x080fe20000410000ULL, 0x0000000430307220ULL, 0x080fe20000410000ULL,
0x0000000431317220ULL, 0x080fe20000410000ULL, 0x0000000420207220ULL, 0x080fe20000410000ULL,
0x0000000421217220ULL, 0x000fe20000410000ULL, 0x0000000b2e2e7220ULL, 0x090fe20000410000ULL,
0x0000000b2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000b3e3e7220ULL, 0x080fe20000410000ULL,
0x0000000b3f3f7220ULL, 0x080fe20000410000ULL, 0x0000000b3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000b3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000b2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000b2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000b26267220ULL, 0x080fe20000410000ULL,
0x0000000b27277220ULL, 0x080fe20000410000ULL, 0x0000000b36367220ULL, 0x080fe20000410000ULL,
0x0000000b37377220ULL, 0x080fe20000410000ULL, 0x0000000b32327220ULL, 0x080fe20000410000ULL,
0x0000000b33337220ULL, 0x080fe20000410000ULL, 0x0000000b22227220ULL, 0x080fe20000410000ULL,
0x0000000b23237220ULL, 0x000fe20000410000ULL, 0x000000ffff047224ULL, 0x000fe200078e0012ULL,
0x0000000a140a4220ULL, 0x020fc80000410000ULL, 0x000000050a057221ULL, 0x01afe20000010000ULL,
0x0000011000002947ULL, 0x000fea0003800000ULL, 0x00000008090a7824ULL, 0x000fca00078e00ffULL,
0x000000080a0b7812ULL, 0x000fca00078e0cffULL, 0x000000015e0a7824ULL, 0x000fe400078e020bULL,
0x800000000e0b7824ULL, 0x000fc800078e00ffULL, 0x00f64c000a0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fe4000784480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x800000000e0e7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL, 0x0000000a000b7305ULL, 0x0002a4000021f000ULL,
0x3fa000000a0a7823ULL, 0x002fe200000100ffULL, 0x0000000b0000735dULL, 0x004fe40003800000ULL,
0x000004005f0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fc4000784480eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000000005858783bULL, 0x000e620000004200ULL, 0x00000014ff0a723eULL, 0x000fe400000000ffULL,
0x00000002ff0b7819ULL, 0x000fe20000011600ULL, 0x00a800001510783bULL, 0x000fe20000000200ULL,
0x000054100a0e7816ULL, 0x000fe4000000000aULL, 0x000099100c0a7816ULL, 0x000fe200000000ffULL,
0x000000005754783bULL, 0x000fe60000004200ULL, 0x000000ff0a00720cULL, 0x000fe20003f45270ULL,
0x00001f0b0e0b7589ULL, 0x000ea800000e0000ULL, 0x00001f160e167589ULL, 0x000ee800000e0000ULL,
0x000000006868783bULL, 0x000f280000004200ULL, 0x00a800005118783bULL, 0x000f680000000200ULL,
0x000000006c6c783bULL, 0x000f620000004200ULL, 0x0000312058587816ULL, 0x002fc400000000ffULL,
0x0000312059597816ULL, 0x000fe400000000ffULL, 0x00000058ff0c723eULL, 0x000fe200020006ffULL,
0x0000000b1010a232ULL, 0x084fe20000000000ULL, 0x00000059ff0d723eULL, 0x000fe200020006ffULL,
0x0000000b1212a232ULL, 0x000fe20000000000ULL, 0x000031205a5a7816ULL, 0x000fe200000000ffULL,
0x000000161111a232ULL, 0x088fe20000000000ULL, 0x000031205b5b7816ULL, 0x000fe200000000ffULL,
0x000000161313a232ULL, 0x000fe20000000000ULL, 0x0000312054547816ULL, 0x000fc400000000ffULL,
0x0000312055557816ULL, 0x000fe400000000ffULL, 0x0000312056567816ULL, 0x000fe400000000ffULL,
0x0000000c102c723cULL, 0x000fe2000000182cULL, 0x0000312057577816ULL, 0x000fe400000000ffULL,
0x0000312068687816ULL, 0x010fe400000000ffULL, 0x0000312069697816ULL, 0x000fe200000000ffULL,
0x0000000b1818a232ULL, 0x0a0fe20000000000ULL, 0x0000005aff0c723eULL, 0x000fe200020006ffULL,
0x0000000b1a1aa232ULL, 0x000fe20000000000ULL, 0x0000005bff0d723eULL, 0x000fe200020006ffULL,
0x000000161919a232ULL, 0x080fe20000000000ULL, 0x00000068ff0a723eULL, 0x000fe200020006ffULL,
0x000000161b1ba232ULL, 0x000fe20000000000ULL, 0x00000069ff0b723eULL, 0x000fc400020006ffULL,
0x00000058ff58723eULL, 0x000fe200030006ffULL, 0x0000000c1038723cULL, 0x000fe20000001838ULL,
0x00000059ff59723eULL, 0x000fe400030006ffULL, 0x0000005aff5a723eULL, 0x000fe400030006ffULL,
0x0000005bff5b723eULL, 0x000fe400030006ffULL, 0x00000054ff0c723eULL, 0x000fe200020006ffULL,
0x0000000a182c723cULL, 0x000fe2000000182cULL, 0x00000055ff0d723eULL, 0x000fc400020006ffULL,
0x00000054ff54723eULL, 0x000fe400030006ffULL, 0x00000055ff55723eULL, 0x000fe400030006ffULL,
0x000031206a6a7816ULL, 0x000fe200000000ffULL, 0x0000000c1024723cULL, 0x000fe20000001824ULL,
0x000031206b6b7816ULL, 0x000fe400000000ffULL, 0x0000006aff0a723eULL, 0x000fe400020006ffULL,
0x0000006bff0b723eULL, 0x000fc400020006ffULL, 0x00000056ff0c723eULL, 0x080fe200020006ffULL,
0x00000058103c723cULL, 0x040fe2000000183cULL, 0x00000057ff0d723eULL, 0x080fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe400030006ffULL, 0x00000057ff57723eULL, 0x000fe400030006ffULL,
0x000031206c6c7816ULL, 0x000fe200000000ffULL, 0x0000005a1028723cULL, 0x000fe20000001828ULL,
0x000031206d6d7816ULL, 0x000fc400000000ffULL, 0x000031206e6e7816ULL, 0x000fe400000000ffULL,
0x000031206f6f7816ULL, 0x000fe400000000ffULL, 0x00000068ff68723eULL, 0x000fe200030006ffULL,
0x000000541034723cULL, 0x000fe20000001834ULL, 0x00000069ff69723eULL, 0x000fe400030006ffULL,
0x0000006aff6a723eULL, 0x000fe400030006ffULL, 0x0000006bff6b723eULL, 0x000fc600030006ffULL,
0x0000000c1030723cULL, 0x040ff00000001830ULL, 0x000000561020723cULL, 0x000ff00000001820ULL,
0x0000000a1838723cULL, 0x040fee0000001838ULL, 0x0000006cff0a723eULL, 0x000fe200020006ffULL,
0x00000068183c723cULL, 0x000fe2000000183cULL, 0x0000006dff0b723eULL, 0x000fc400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400030006ffULL, 0x0000006dff6d723eULL, 0x000fc600030006ffULL,
0x0000000a1824723cULL, 0x040fee0000001824ULL, 0x0000006eff0a723eULL, 0x080fe200020006ffULL,
0x0000006a1828723cULL, 0x000fe20000001828ULL, 0x0000006fff0b723eULL, 0x000fe400020006ffULL,
0x0000006eff6e723eULL, 0x000fc400030006ffULL, 0x0000006fff6f723eULL, 0x000fc600030006ffULL,
0x0000006c1834723cULL, 0x040ff00000001834ULL, 0x0000000a1830723cULL, 0x040ff00000001830ULL,
0x0000006e1820723cULL, 0x000fe20000001820ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200006ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f640000fff7f8cULL, 0x0005e2000c80043fULL,
0x00009910670a7816ULL, 0x000fc400000000ffULL, 0x00000001ff6a7807ULL, 0x000fe40004000000ULL,
0x000000ff0a00720cULL, 0x000fe40003f45270ULL, 0x0000000109717812ULL, 0x000fe400078ec0ffULL,
0x00000001ff1c9807ULL, 0x000fc80001000000ULL, 0x000076101c6b7816ULL, 0x000fe4000000006bULL,
0x0000030052527a10ULL, 0x00cfe40007ffe0ffULL, 0x000000ff08ff7812ULL, 0x000fe4000780c0ffULL,
0x0000004d5200720cULL, 0x000fe40003f26070ULL, 0x00000001ff087807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffffada000007947ULL, 0x000fea000383ffffULL,
0x00000000000479c3ULL, 0x002e640000002500ULL, 0x000000044d007c0cULL, 0x002fda000bf03070ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x0180000005007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x000fe200078e0005ULL, 0x0000617000087802ULL, 0x000fe40000000f00ULL,
0x0000828000007944ULL, 0x020fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000500007308ULL, 0x000e640000001000ULL, 0xbf80000000037423ULL, 0x002fc80000000005ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff077624ULL, 0x006fe400078e00ffULL,
0x00006800ff067624ULL, 0x000fca00078e00ffULL, 0x0000000806077981ULL, 0x000ea8000c1e9900ULL,
0x0000000000037919ULL, 0x000e680000000000ULL, 0x00000000000a7919ULL, 0x000f220000000000ULL,
0x00000002ff097819ULL, 0x002fe40000011603ULL, 0x000000080a037811ULL, 0x010fe200078ff0ffULL,
0x0000000007087220ULL, 0x00cfca0000410000ULL, 0x00001f0908007589ULL, 0x000e6800000e0000ULL,
0x00001f0308037589ULL, 0x000ea200000e0000ULL, 0x0000002c002c7220ULL, 0x042fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000003c003c7220ULL, 0x040fe20000410000ULL,
0x0000003d003d7220ULL, 0x040fe20000410000ULL, 0x0000003800387220ULL, 0x040fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x000fe20000410000ULL, 0x0000002e032e7220ULL, 0x044fe20000410000ULL,
0x0000002f032f7220ULL, 0x040fe20000410000ULL, 0x0000003e033e7220ULL, 0x040fe20000410000ULL,
0x0000003f033f7220ULL, 0x040fe20000410000ULL, 0x0000003a033a7220ULL, 0x040fe20000410000ULL,
0x0000003b033b7220ULL, 0x040fe20000410000ULL, 0x0000002a032a7220ULL, 0x040fe20000410000ULL,
0x0000002b032b7220ULL, 0x040fe20000410000ULL, 0x0000002603267220ULL, 0x040fe20000410000ULL,
0x0000002703277220ULL, 0x040fe20000410000ULL, 0x0000003603367220ULL, 0x040fe20000410000ULL,
0x0000003703377220ULL, 0x040fe20000410000ULL, 0x0000003203327220ULL, 0x040fe20000410000ULL,
0x0000003303337220ULL, 0x040fe20000410000ULL, 0x0000002203227220ULL, 0x040fe20000410000ULL,
0x0000002303237220ULL, 0x000fc80000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000222322723eULL, 0x000fc600000000ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000200037812ULL, 0x042fe200078ec0ffULL, 0x000000204b147824ULL, 0x100fe200078e0200ULL,
0x00000002ff117819ULL, 0x000fe40000011600ULL, 0x00000001ff067819ULL, 0x000fe40000011603ULL,
0x00000004030a7811ULL, 0x040fe400078ff8ffULL, 0x0000000800197811ULL, 0x000fe400078ff0ffULL,
0x0000000203077811ULL, 0x000fc400078ff8ffULL, 0x00000006030d7811ULL, 0x000fe400078ff8ffULL,
0x0000000706037812ULL, 0x100fe400078e7811ULL, 0x000000070a0c7812ULL, 0x040fe400078e7811ULL,
0x000000070a0a7812ULL, 0x000fe200078e7819ULL, 0x0000000811097824ULL, 0x000fe200078e0203ULL,
0x0000000707087812ULL, 0x000fe200078e7811ULL, 0x000010004c037824ULL, 0x000fe200078e00ffULL,
0x0000000706067812ULL, 0x000fe200078e7819ULL, 0x0000000819177824ULL, 0x000fe200078e020aULL,
0x000000070d0e7812ULL, 0x000fe200078e7811ULL, 0x00000008000a7824ULL, 0x000fe200078e00ffULL,
0x0000000707077812ULL, 0x100fe200078e7819ULL, 0x0000000819137824ULL, 0x000fe200078e0206ULL,
0x000000070d0d7812ULL, 0x000fe200078e7819ULL, 0x00000008110b7824ULL, 0x040fe200078e0208ULL,
0x000000080a0a7812ULL, 0x000fe200078ec0ffULL, 0x00000008110f7824ULL, 0x000fe200078e020cULL,
0x0000003c3d08723eULL, 0x000fe200000000ffULL, 0x0000000819157824ULL, 0x000fe200078e0207ULL,
0x0000002c2d07723eULL, 0x000fe200000000ffULL, 0x000008004b067824ULL, 0x000fc400078e0203ULL,
0x0000000811117824ULL, 0x000fe200078e020eULL, 0x00005410071a7816ULL, 0x100fe20000000008ULL,
0x0000000819197824ULL, 0x000fe200078e020dULL, 0x00007632071b7816ULL, 0x000fe20000000008ULL,
0x0000001009097824ULL, 0x100fe200078e0206ULL, 0x000000242507723eULL, 0x000fe200000000ffULL,
0x000000100b0d7824ULL, 0x100fe200078e0206ULL, 0x000000343508723eULL, 0x000fe200000000ffULL,
0x000000100f0f7824ULL, 0x100fe400078e0206ULL, 0x0000001013137824ULL, 0x000fe200078e0206ULL,
0x00005410070c7816ULL, 0x000fe20000000008ULL, 0x0000001015157824ULL, 0x000fc400078e0206ULL,
0x0000001011117824ULL, 0x100fe400078e0206ULL, 0x0000001017177824ULL, 0x100fe400078e0206ULL,
0x0000001019197824ULL, 0x000fe400078e0206ULL, 0x00000001090b7824ULL, 0x000fe200078e020aULL,
0x000000383909723eULL, 0x000fe200000000ffULL, 0x000000010a0d7824ULL, 0x040fe400078e020dULL,
0x000000010a0f7824ULL, 0x040fe200078e020fULL, 0x0000001a0b007388ULL, 0x0003e20000000a00ULL,
0x000000010a137824ULL, 0x000fc400078e0213ULL, 0x000000010a157824ULL, 0x040fe400078e0215ULL,
0x000000010a117824ULL, 0x040fe400078e0211ULL, 0x000000010a177824ULL, 0x040fe400078e0217ULL,
0x000000010a197824ULL, 0x000fe200078e0219ULL, 0x00000028290a723eULL, 0x000fe200000000ffULL,
0x0000001014107824ULL, 0x000fc600078e0203ULL, 0x00005410091a7816ULL, 0x142fe4000000000aULL,
0x00007632091b7816ULL, 0x000fe4000000000aULL, 0x000000303109723eULL, 0x000fe400000000ffULL,
0x00000020210a723eULL, 0x000fe200000000ffULL, 0x0000001a0d007388ULL, 0x0003e40000000a00ULL,
0x00007632070d7816ULL, 0x002fe40000000008ULL, 0x0000002e2f07723eULL, 0x000fc400000000ffULL,
0x0000003e3f08723eULL, 0x000fe200000000ffULL, 0x0000000c0f007388ULL, 0x0003e40000000a00ULL,
0x00005410090c7816ULL, 0x142fe4000000000aULL, 0x00007632090d7816ULL, 0x000fe4000000000aULL,
0x0000003a3b09723eULL, 0x000fe400000000ffULL, 0x0000002a2b0a723eULL, 0x000fe200000000ffULL,
0x0000000c11007388ULL, 0x0003e40000000a00ULL, 0x00005410070c7816ULL, 0x002fc40000000008ULL,
0x00007632070d7816ULL, 0x000fe40000000008ULL, 0x000000262707723eULL, 0x000fe400000000ffULL,
0x000000363708723eULL, 0x000fe200000000ffULL, 0x0000000c13007388ULL, 0x0003e60000000a00ULL,
0x0000541007127816ULL, 0x000fe40000000008ULL, 0x00005410090c7816ULL, 0x002fc4000000000aULL,
0x00007632090d7816ULL, 0x000fe4000000000aULL, 0x0000763207137816ULL, 0x000fe40000000008ULL,
0x000000323309723eULL, 0x000fe200000000ffULL, 0x0000000c15007388ULL, 0x000fe80000000a00ULL,
0x0000001217007388ULL, 0x0003e40000000a00ULL, 0x0000541009127816ULL, 0x002fc40000000022ULL,
0x0000763209137816ULL, 0x000fca0000000022ULL, 0x0000001219007388ULL, 0x0003e80000000a00ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000300ff197624ULL, 0x002fca00078e00ffULL,
0x000000011900780cULL, 0x000fe20003f05270ULL, 0x0000000010087984ULL, 0x000e680000000c00ULL,
0x00040000101c7984ULL, 0x000ea80000000c00ULL, 0x00080000100c7984ULL, 0x000ee80000000c00ULL,
0x000c000010207984ULL, 0x000f220000000c00ULL, 0x200000ff0b0b7230ULL, 0x002fc40000000000ULL,
0x200000ff0a0a7230ULL, 0x000fe40000000000ULL, 0x200000ff09097230ULL, 0x000fe40000000000ULL,
0x200000ff08087230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x004fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fc40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x0000000f0b0b7230ULL, 0x008fe40000000000ULL,
0x0000000e0a0a7230ULL, 0x000fe40000000000ULL, 0x0000000d09097230ULL, 0x000fe40000000000ULL,
0x0000000c08087230ULL, 0x000fe40000000000ULL, 0x000000231f1f7230ULL, 0x010fc40000000000ULL,
0x000000221e1e7230ULL, 0x000fe20000000000ULL, 0x0000000810007388ULL, 0x0003e20000000c00ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fca0000000000ULL,
0x0004001c10007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000305000008947ULL, 0x000fea0003800000ULL, 0x0000000000187919ULL, 0x000ea20000002700ULL,
0x0000580019077a24ULL, 0x000fe200078e02ffULL, 0x000000014bff7812ULL, 0x000fe2000780f850ULL,
0x00001000ff0b7424ULL, 0x002fe200078e00ffULL, 0x0000000000097919ULL, 0x000ea20000002600ULL,
0x0000660007117a24ULL, 0x000fe200078e02ffULL, 0x0000004014177810ULL, 0x000fc40007ffe0ffULL,
0x00000000100c7984ULL, 0x0002e40000000c00ULL, 0x00000fff11077811ULL, 0x000fe400078e40ffULL,
0x00040000101c7984ULL, 0x0003220000000c00ULL, 0x0000580018187a24ULL, 0x004fe400078e0209ULL,
0x000008004c097824ULL, 0x000fe400078e00ffULL, 0x0000030018087a24ULL, 0x000fca00078e02ffULL,
0x0000000408127c10ULL, 0x000fc8000fffe0ffULL, 0x00000012070a7211ULL, 0x000fca00078fa0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000bULL, 0x000000090a0a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x000000ff0000720cULL, 0x000fc60000725670ULL,
0x0000001014147825ULL, 0x000fc800078e000aULL, 0x0000001017167825ULL, 0x000fe200078e000aULL,
0x01ffffff110a7812ULL, 0x000fe200078ec0ffULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001000107824ULL, 0x01afe200078e00ffULL, 0x00000001ff117819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000000112137824ULL, 0x000fe200078e020aULL,
0x00000070101b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c111a7812ULL, 0x000fe200078ec0ffULL,
0x00006c0012107625ULL, 0x000fc800078e000bULL, 0x00006c0013127625ULL, 0x000fe200078e000bULL,
0x000000101a107210ULL, 0x000fc80007a1e01bULL, 0x000000121a127210ULL, 0x000fe40007c7e01bULL,
0x00000011ff117210ULL, 0x000fe400007e44ffULL, 0x00000013ff137210ULL, 0x000fc60001fe84ffULL,
0x0000000410007986ULL, 0x0003e8000c101908ULL, 0x0000000512007986ULL, 0x0003e4000c101908ULL,
0x0000000c14007986ULL, 0x01a3e2000c101d08ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x0000001c16007986ULL, 0x0003e8000c101d08ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff057424ULL, 0x000fe200078e00ffULL,
0xffffffff190b7810ULL, 0x000fc60007ffe0ffULL, 0x00006a0018047625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b040479a8ULL, 0x000ea400099ee1c8ULL, 0x0000000b0400720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0c7807ULL, 0x002fca0000000000ULL,
0x0000000cff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff047984ULL, 0x000ea40000000000ULL,
0x000000ff0400720cULL, 0x004fda0003f05270ULL, 0x00002c8000008947ULL, 0x000fea0003800000ULL,
0x000000ff5000720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0000001000047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe20000011600ULL,
0x00000080ff0f7424ULL, 0x002fe200078e00ffULL, 0x00000001080c7810ULL, 0x000fe40007ffe0ffULL,
0x0000007004177812ULL, 0x000fe400078ec0ffULL, 0x0000000c05107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008047625ULL, 0x000fc800078e000fULL, 0x00006c000c0c7625ULL, 0x000fe200078e000fULL,
0x0000000410047210ULL, 0x000fc8000791e017ULL, 0x0000000c100c7210ULL, 0x000fe40007b5e017ULL,
0x00000005ff057210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x0000000804047981ULL, 0x000368000c1e1900ULL, 0x000000080c0b7981ULL, 0x000362000c1e1900ULL,
0x000000021900780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002080c7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e000fULL,
0x0000000c100c7210ULL, 0x000fc8000791e017ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000080c057981ULL, 0x000362000c1e1900ULL, 0x000000041900780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003080c7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e000fULL, 0x0000000c100c7210ULL, 0x000fc8000791e017ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000080c117981ULL, 0x000362000c1e1900ULL,
0x000000041900780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004080c7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e000fULL,
0x0000000c100c7210ULL, 0x000fc8000791e017ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000080c137981ULL, 0x000362000c1e1900ULL, 0x000000061900780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005080c7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e000fULL, 0x0000000c100c7210ULL, 0x000fc8000791e017ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000080c157981ULL, 0x000362000c1e1900ULL,
0x000000061900780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081900780cULL, 0x002fe40003f06070ULL, 0x00000006080c7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e000fULL, 0x0000000c100c7210ULL, 0x000fe40007a3e017ULL,
0x00000007080e0810ULL, 0x000fe40007ffe0ffULL, 0x0000000dff0d7210ULL, 0x000fc60000fe44ffULL,
0x00006c000e0e0625ULL, 0x000fca00078e000fULL, 0x0000000e100e0210ULL, 0x000fe40007c7e017ULL,
0x000000080c177981ULL, 0x000364000c1e1900ULL, 0x0000000fff0f0210ULL, 0x000fcc0001fe84ffULL,
0x000000080e0f0981ULL, 0x000366000c1e1900ULL, 0x00000007190c7810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0e7819ULL, 0x000fc8000001160cULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff197224ULL, 0x000fe400078e00ffULL,
0x000000ffff1b7224ULL, 0x020fe400078e0004ULL, 0x0000000819107824ULL, 0x040fe200078e00ffULL,
0x0000000119197810ULL, 0x000fc80007ffe0ffULL, 0x0000030010007a0cULL, 0x000fe40003f26070ULL,
0x0000000e1900720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x00000008100d7810ULL, 0x040fe40007ffe0ffULL, 0x00000001100c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x0000001b04047209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001080c7824ULL, 0x000fe200078e020dULL, 0x00000001ff147819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x00000070121b7812ULL, 0x000fc800078ec0ffULL, 0x0000000c140c7210ULL, 0x000fc80007b3e01bULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c1b7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x00000009100d7810ULL, 0x042fe40007ffe0ffULL,
0x00000002100c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x0000000b04047209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001080c7824ULL, 0x000fe200078e020dULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x00000010000b7824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x000000700b0b7812ULL, 0x000fc800078ec0ffULL,
0x0000000c120c7210ULL, 0x000fc80007b3e00bULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c0b7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a100d7810ULL, 0x042fe40007ffe0ffULL, 0x00000003100c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x0000000504047209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001080c7824ULL, 0x000fe200078e020dULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007005057812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007b3e005ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c057981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b100d7810ULL, 0x042fe40007ffe0ffULL,
0x00000004100c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x0000001104047209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001080c7824ULL, 0x000fe200078e020dULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000c120c7210ULL, 0x000fc80007b3e011ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c117981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c100d7810ULL, 0x042fe40007ffe0ffULL, 0x00000005100c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x0000001304047209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001080c7824ULL, 0x000fe200078e020dULL, 0x00000001ff147819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007012137812ULL, 0x000fc800078ec0ffULL, 0x0000000c140c7210ULL, 0x000fc80007b3e013ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c137981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d100d7810ULL, 0x042fe40007ffe0ffULL,
0x00000006100c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x0000001504047209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001080c7824ULL, 0x000fe200078e020dULL,
0x00000001ff147819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001000127824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007012157812ULL, 0x000fc800078ec0ffULL,
0x0000000c140c7210ULL, 0x000fc80007b3e015ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c157981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e100d7810ULL, 0x042fe40007ffe0ffULL, 0x00000007100c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x0000001704047209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001080c7824ULL, 0x000fe200078e020dULL, 0x00000001ff147819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007012177812ULL, 0x000fc800078ec0ffULL, 0x0000000c140c7210ULL, 0x000fc80007b3e017ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c177981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f100d7810ULL, 0x002fe40007ffe0ffULL,
0x0000000f04047209ULL, 0x000fe40007810000ULL, 0x000003000d007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001080c7824ULL, 0x000fe200078e020dULL,
0x00000001ff107819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x00000010000f7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000c100c7210ULL, 0x000fc80007a3e00fULL, 0x0000000dff0d7210ULL, 0x000fca0000fe44ffULL,
0x000000080c0f7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x0000001000057824ULL, 0x024fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011600ULL, 0x0000007005057812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0c7812ULL, 0x002fca00078ec0ffULL, 0x000000010c057824ULL, 0x000fca00078e0205ULL,
0x0000000405007388ULL, 0x0003e40000000800ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x0000001000057824ULL, 0x002fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011600ULL,
0x000000014b167824ULL, 0x000fe200078e0208ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011650ULL, 0x00001000ff0f7424ULL, 0x000fe200078e00ffULL,
0x00000070050d7812ULL, 0x000fe200078ec0ffULL, 0x0000020050507824ULL, 0x000fe200078e00ffULL,
0x0000000c0b0e7812ULL, 0x000fe200078ec0ffULL, 0x0000000102027824ULL, 0x000fe200078e0203ULL,
0x0000001607047211ULL, 0x000fe200078fa0ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000010c0b7812ULL, 0x000fe200078ec0ffULL, 0x000000010e187824ULL, 0x000fe200078e020dULL,
0x0000004000117810ULL, 0x040fe20007ffe0ffULL, 0x000000024b0c8824ULL, 0x140fe200078e024cULL,
0x0000006000137810ULL, 0x000fe20007ffe0ffULL, 0x00006c0004047625ULL, 0x000fe200078e000fULL,
0x00000020000f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000000024b0e8824ULL, 0x000fe200078e024cULL,
0x0000000904047210ULL, 0x000fe20007f3e0ffULL, 0x000000020c1b8824ULL, 0x100fe200078e020bULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000020e1d8824ULL, 0x000fe200078e020bULL,
0x00000800500b7812ULL, 0x000fe200078ec0ffULL, 0x000000010a148824ULL, 0x000fe200078e0216ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x00000080ff158424ULL, 0x000fe200078e00ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000080ff178424ULL, 0x000fc400078e00ffULL,
0x000000ffff057224ULL, 0x000fe200008e0605ULL, 0x000003004b007a0cULL, 0x000fe20003f26070ULL,
0x00000001020b7824ULL, 0x000fe400078e020bULL, 0x00006c0014148625ULL, 0x000fc800078e0015ULL,
0x00006c0016168625ULL, 0x000fc800078e0017ULL, 0x000000081b1b8824ULL, 0x000fe400078e0200ULL,
0x0000001000197824ULL, 0x040fe400078e020bULL, 0x00000010000c7825ULL, 0x000fe200078e0004ULL,
0x000045801b1b8811ULL, 0x000fc600078e20ffULL, 0x000000081d1d8824ULL, 0x000fe400078e0200ULL,
0x000000100f0e7825ULL, 0x000fc600078e0004ULL, 0x000041801d1d8811ULL, 0x000fe200078e20ffULL,
0x0000001011107825ULL, 0x000fc800078e0004ULL, 0x0000001013127825ULL, 0x000fe400078e0004ULL,
0x0000000018047984ULL, 0x0002a40000000800ULL, 0x0000001000148825ULL, 0x040fe400078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c197faeULL, 0x0007e4000b901c48ULL,
0x0000001000168825ULL, 0x000fe400078e0016ULL, 0x003800000e197faeULL, 0x0009e4000b901c48ULL,
0x000000ffff057224ULL, 0x000fc400078e00ffULL, 0x0058000010197faeULL, 0x0003e2000b901c48ULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x0078000012197faeULL, 0x0003e2000b901c48ULL, 0x00000000000c7805ULL, 0x008fc6000001ff00ULL,
0x00000000141b8faeULL, 0x0007e2000b901c48ULL, 0x00000000000e7805ULL, 0x010fc6000001ff00ULL,
0x00000000161d8faeULL, 0x0009e2000b901c48ULL, 0x0000000000107805ULL, 0x002fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x008fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x010fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000e0000001947ULL, 0x000fea0003800000ULL,
0x00000df000007945ULL, 0x000fe20003800000ULL, 0x000000ffff057224ULL, 0x000fe400078e00ffULL,
0x000000ffff2e7224ULL, 0x000fca00078e004bULL, 0x000000022e2d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff437224ULL, 0x000fe200078e002eULL, 0x00000002ff2c7819ULL, 0x000fe20000011600ULL,
0x000000024b417824ULL, 0x000fe200078e024cULL, 0x000003002d007a0cULL, 0x000fe20003f06070ULL,
0x00000040432e7824ULL, 0x000fe200078e00ffULL, 0x000000072c467812ULL, 0x040fe200078ec0ffULL,
0x000000082c2f7824ULL, 0x040fe200078e00ffULL, 0x0000002cff487212ULL, 0x020fe200078e33ffULL,
0x000000082c2b7824ULL, 0x002fe200078e00ffULL, 0x000000802e2e7812ULL, 0x000fe200078ec0ffULL,
0x000000082c317824ULL, 0x000fe200078e00ffULL, 0x0000039000017945ULL, 0x000fe20003800000ULL,
0xfffffff82f3a7812ULL, 0x100fe200078ee246ULL, 0x0000001000477824ULL, 0x000fe200078e00ffULL,
0x000000012b3c7812ULL, 0x000fe200078ef646ULL, 0x0000010041417824ULL, 0x000fe200078e002eULL,
0x000000022b3e7812ULL, 0x000fc400078ef646ULL, 0x000000032b407812ULL, 0x140fe400078ef646ULL,
0x000000042b427812ULL, 0x140fe400078ef646ULL, 0x000000052b447812ULL, 0x140fe400078ef646ULL,
0x000000062b467812ULL, 0x000fe400078ef646ULL, 0xfffffff831487812ULL, 0x000fe400078ee248ULL,
0x000000082c2b7810ULL, 0x000fe20007ffe0ffULL, 0x000002c000000947ULL, 0x000fea0003800000ULL,
0x000000070000780cULL, 0x000fe20003f24070ULL, 0x0000000108387824ULL, 0x100fe200078e022dULL,
0x00000001ff307819ULL, 0x000fe2000001162dULL, 0x00001000ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000002000337810ULL, 0x000fc40007ffe0ffULL, 0x00000038072e7211ULL, 0x000fe400078fa0ffULL,
0x0000000130317812ULL, 0x000fe200078ec0ffULL, 0x000004002d307824ULL, 0x000fe200078e00ffULL,
0x0000004000357810ULL, 0x000fe20007ffe0ffULL, 0x00006c002e2e7625ULL, 0x000fe200078e002fULL,
0x00000060003f7810ULL, 0x000fc60007ffe0ffULL, 0x000000024b329824ULL, 0x140fe200078e024cULL,
0x000000092e2e7210ULL, 0x000fe20007f1e0ffULL, 0x000000024b349824ULL, 0x000fe400078e024cULL,
0x00000002323d9824ULL, 0x100fe400078e0231ULL, 0x0000000234459824ULL, 0x000fe200078e0231ULL,
0x0000080030317812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2f7224ULL, 0x000fe400000e062fULL,
0x000000010a369824ULL, 0x000fc400078e0238ULL, 0x0000000102317824ULL, 0x000fe400078e0231ULL,
0x00000080ff379424ULL, 0x000fe400078e00ffULL, 0x00000080ff399424ULL, 0x000fe400078e00ffULL,
0x00000010003b7824ULL, 0x000fe400078e0231ULL, 0x00006c0036369625ULL, 0x000fc800078e0037ULL,
0x0000001000307825ULL, 0x000fc800078e002eULL, 0x0000001033327825ULL, 0x100fe200078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000303b7faeULL, 0x0003e6000b901c48ULL,
0x0000001035347825ULL, 0x100fe200078e002eULL, 0x00380000323b7faeULL, 0x0003e6000b901c48ULL,
0x00006c0038389625ULL, 0x000fe200078e0039ULL, 0x00580000343b7faeULL, 0x0003e6000b901c48ULL,
0x000000103f2e7825ULL, 0x000fc800078e002eULL, 0x000000083d3d9824ULL, 0x100fe200078e0200ULL,
0x007800002e3b7faeULL, 0x0003e2000b901c48ULL, 0x00000008453f9824ULL, 0x000fe400078e0200ULL,
0x0000001000369825ULL, 0x040fe200078e0036ULL, 0x000045803d3d9811ULL, 0x000fe400078e20ffULL,
0x000041803f3f9811ULL, 0x000fe200078e20ffULL, 0x0000001000389825ULL, 0x000fe400078e0038ULL,
0x00000000363d9faeULL, 0x0003e8000b901c48ULL, 0x00000000383f9faeULL, 0x0003e4000b901c48ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000001ff307819ULL, 0x002fe20000011600ULL, 0x000000082b347824ULL, 0x000fe200078e00ffULL,
0x0000007047507812ULL, 0x000fe200078ec0ffULL, 0x000000082b327824ULL, 0x000fe200078e00ffULL,
0x0000000c30317812ULL, 0x000fe200078ec0ffULL, 0x00000400432e7824ULL, 0x000fe200078e00ffULL,
0x000000072b2f7812ULL, 0x000fc400078ec0ffULL, 0x0000004131417210ULL, 0x000fe20007ffe050ULL,
0x000000082b317824ULL, 0x000fe200078e00ffULL, 0xfffffff834307812ULL, 0x100fe400078ee22fULL,
0x0000000132347812ULL, 0x140fe400078ef62fULL, 0x0000000232367812ULL, 0x140fe400078ef62fULL,
0x0000000332387812ULL, 0x140fe400078ef62fULL, 0x00000004324a7812ULL, 0x000fc400078ef62fULL,
0x00000005324e7812ULL, 0x140fe400078ef62fULL, 0x0000000632327812ULL, 0x000fe200078ef62fULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800041337984ULL, 0x000e620000000800ULL,
0x000008002e2f7812ULL, 0x000fe200078ec0ffULL, 0x00000004002e7824ULL, 0x000fe200078e00ffULL,
0x0000002bff507212ULL, 0x000fe200078e33ffULL, 0x0045800041527984ULL, 0x000ee20000000800ULL,
0x00000180022f7810ULL, 0x000fe40007ffe02fULL, 0xfffffff831507812ULL, 0x000fe400078ee250ULL,
0x0000000c2e317812ULL, 0x000fe200078ec0ffULL, 0x000000103e3e7824ULL, 0x000fc400078e022fULL,
0x0000001040407824ULL, 0x100fe400078e022fULL, 0x0000001034347824ULL, 0x100fe400078e022fULL,
0x0000001042427824ULL, 0x100fe400078e022fULL, 0x0000001036367824ULL, 0x100fe400078e022fULL,
0x0000001044447824ULL, 0x100fe400078e022fULL, 0x0000001038387824ULL, 0x000fc400078e022fULL,
0x0000001046467824ULL, 0x100fe400078e022fULL, 0x000000104a4a7824ULL, 0x100fe400078e022fULL,
0x00000001313e7824ULL, 0x000fe400078e023eULL, 0x000000103a3a7824ULL, 0x100fe400078e022fULL,
0x000000104e4e7824ULL, 0x100fe400078e022fULL, 0x0000001048487824ULL, 0x100fe200078e022fULL,
0x000000003e3e7984ULL, 0x000f220000000800ULL, 0x0000001050507824ULL, 0x000fc400078e022fULL,
0x0000000131407824ULL, 0x040fe400078e0240ULL, 0x0000000131347824ULL, 0x000fe200078e0234ULL,
0x0000003304337221ULL, 0x006fe20000010100ULL, 0x000000103c3c7824ULL, 0x100fe400078e022fULL,
0x0000001030307824ULL, 0x100fe200078e022fULL, 0x0000000040407984ULL, 0x000e620000000800ULL,
0x0000001032327824ULL, 0x000fe200078e022fULL, 0x3fb8aa3b33337820ULL, 0x000fe20000410000ULL,
0x0000000131427824ULL, 0x040fe200078e0242ULL, 0x0000000034347984ULL, 0x000ea20000000800ULL,
0x0000000131367824ULL, 0x000fc400078e0236ULL, 0x0000000131447824ULL, 0x040fe200078e0244ULL,
0x0000003300337308ULL, 0x000ee20000000800ULL, 0x0000000131387824ULL, 0x040fe200078e0238ULL,
0x0000000042427984ULL, 0x000f620000000800ULL, 0x0000000131467824ULL, 0x040fe400078e0246ULL,
0x00000001314a7824ULL, 0x040fe200078e024aULL, 0x0000000036367984ULL, 0x000f620000000800ULL,
0x000000013a3a7824ULL, 0x000fe400078e0231ULL, 0x0000000131487824ULL, 0x040fe200078e0248ULL,
0x0000000044447984ULL, 0x000f620000000800ULL, 0x00000001314e7824ULL, 0x000fc400078e024eULL,
0x0000000131507824ULL, 0x040fe200078e0250ULL, 0x0000000038387984ULL, 0x000f620000000800ULL,
0x00000001313c7824ULL, 0x040fe400078e023cULL, 0x0000000131307824ULL, 0x040fe200078e0230ULL,
0x0000000046467984ULL, 0x000f620000000800ULL, 0x0000000131327824ULL, 0x000fe200078e0232ULL,
0x0000005233317220ULL, 0x008fe20000410000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e002dULL,
0x000000004a4a7984ULL, 0x000ee20000000800ULL, 0x2000003eff547230ULL, 0x110fe20000004100ULL,
0x0000002a312a7221ULL, 0x000fe20000010000ULL, 0x3000003eff397230ULL, 0x000fe20000004100ULL,
0x000000003a3a7984ULL, 0x000f220000000800ULL, 0x000003002e007a0cULL, 0x000fc60003f06070ULL,
0x0000000048487984ULL, 0x000f220000000800ULL, 0x20000040ff3e7230ULL, 0x002fc60000004100ULL,
0x000000004e4e7984ULL, 0x000e620000000800ULL, 0x30000040ff3b7230ULL, 0x000fe40000004100ULL,
0x20000034ff567230ULL, 0x104fe20000004100ULL, 0x0000000050507984ULL, 0x000ea20000000800ULL,
0x30000034ff477230ULL, 0x000fc60000004100ULL, 0x000000003c3c7984ULL, 0x000ea20000000800ULL,
0x20000042ff407230ULL, 0x120fe40000004100ULL, 0x30000042ff3d7230ULL, 0x000fe20000004100ULL,
0x0000000030307984ULL, 0x000f620000000800ULL, 0x20000036ff347230ULL, 0x100fe40000004100ULL,
0x30000036ff497230ULL, 0x000fe20000004100ULL, 0x0000000032327984ULL, 0x000f620000000800ULL,
0x20000044ff427230ULL, 0x100fe40000004100ULL, 0x30000044ff3f7230ULL, 0x000fc40000004100ULL,
0x20000038ff367230ULL, 0x100fe40000004100ULL, 0x30000038ff4d7230ULL, 0x000fe40000004100ULL,
0x20000046ff447230ULL, 0x100fe40000004100ULL, 0x30000046ff417230ULL, 0x000fe40000004100ULL,
0x2000004aff387230ULL, 0x108fe40000004100ULL, 0x3000004aff4f7230ULL, 0x000fc40000004100ULL,
0x2000003aff527230ULL, 0x110fe40000004100ULL, 0x3000003aff357230ULL, 0x000fe40000004100ULL,
0x20000048ff467230ULL, 0x100fe40000004100ULL, 0x30000048ff437230ULL, 0x000fe40000004100ULL,
0x2000004eff4a7230ULL, 0x102fe40000004100ULL, 0x3000004eff517230ULL, 0x000fc40000004100ULL,
0x20000050ff587230ULL, 0x104fe40000004100ULL, 0x30000050ff507230ULL, 0x000fe40000004100ULL,
0x2000003cff3a7230ULL, 0x100fe40000004100ULL, 0x3000003cff377230ULL, 0x000fe40000004100ULL,
0x20000030ff487230ULL, 0x120fe40000004100ULL, 0x30000030ff457230ULL, 0x000fc40000004100ULL,
0x20000032ff4e7230ULL, 0x100fe40000004100ULL, 0x30000032ff537230ULL, 0x000fe20000004100ULL,
0x000052027f007947ULL, 0x000fea000b800000ULL, 0x00001f2c312f7589ULL, 0x0002a400000e0000ULL,
0x000052527f007947ULL, 0x000fea000b800000ULL, 0x00001f2b312c7589ULL, 0x0022e400000e0000ULL,
0x0000002f52297223ULL, 0x084fe20000010029ULL, 0x0000002f35287223ULL, 0x080fe20000010028ULL,
0x0000002f3a257223ULL, 0x080fe20000010025ULL, 0x0000002f37247223ULL, 0x080fe20000010024ULL,
0x0000002f54217223ULL, 0x080fe20000010021ULL, 0x0000002f39207223ULL, 0x080fe20000010020ULL,
0x0000002f3e1d7223ULL, 0x080fe2000001001dULL, 0x0000002f3b1c7223ULL, 0x080fe2000001001cULL,
0x0000002f40197223ULL, 0x080fe20000010019ULL, 0x0000002f3d187223ULL, 0x080fe20000010018ULL,
0x0000002f42157223ULL, 0x080fe20000010015ULL, 0x0000002f3f147223ULL, 0x080fe20000010014ULL,
0x0000002f44117223ULL, 0x080fe20000010011ULL, 0x0000002f41107223ULL, 0x080fe20000010010ULL,
0x0000002f460d7223ULL, 0x080fe2000001000dULL, 0x0000002f430c7223ULL, 0x000fe2000001000cULL,
0x0000002c48277223ULL, 0x088fe20000010027ULL, 0x0000002c45267223ULL, 0x080fe20000010026ULL,
0x0000002c56237223ULL, 0x080fe20000010023ULL, 0x0000002c47227223ULL, 0x080fe20000010022ULL,
0x0000002c341f7223ULL, 0x080fe2000001001fULL, 0x0000002c491e7223ULL, 0x080fe2000001001eULL,
0x0000002c361b7223ULL, 0x080fe2000001001bULL, 0x0000002c4d1a7223ULL, 0x080fe2000001001aULL,
0x0000002c38177223ULL, 0x080fe20000010017ULL, 0x0000002c4f167223ULL, 0x080fe20000010016ULL,
0x0000002c4a137223ULL, 0x080fe20000010013ULL, 0x0000002c51127223ULL, 0x080fe20000010012ULL,
0x0000002c4e0f7223ULL, 0x080fe2000001000fULL, 0x0000002c530e7223ULL, 0x080fe2000001000eULL,
0x0000002c580b7223ULL, 0x080fe2000001000bULL, 0x0000002c50057223ULL, 0x000fe20000010005ULL,
0xfffff24000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x000000ff4c00720cULL, 0x000fe20003f05270ULL,
0x0000001000027824ULL, 0x008fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c00077812ULL, 0x000fca00078ec0ffULL,
0x0000000107087824ULL, 0x000fe200078e0202ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ee40000000000ULL, 0x0000001000027824ULL, 0x008fe200078e00ffULL,
0x00000001ff047819ULL, 0x004fc80000011600ULL, 0x0000007002007812ULL, 0x000fe400078ec0ffULL,
0x0000000c04077812ULL, 0x000fc600078ec0ffULL, 0x000000804b007824ULL, 0x000fc800078e0200ULL,
0x0000000107077824ULL, 0x000fca00078e0200ULL, 0x0049802a07007388ULL, 0x0005e40000000800ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800008007984ULL, 0x000ee80000000800ULL,
0x004a000008077984ULL, 0x004ea20000000800ULL, 0x00000000ff007221ULL, 0x008fc80000010000ULL,
0x0000000700007221ULL, 0x004fca0000010000ULL, 0x0180000000027810ULL, 0x000fc80007ffe0ffULL,
0x7f80000002027812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x000fe200078e0000ULL, 0x0000911000087802ULL, 0x000fe40000000f00ULL,
0x000052e000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff027224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000077308ULL, 0x000ea40000001000ULL,
0xbf80000000027423ULL, 0x004fc80000000007ULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000207027223ULL, 0x000fe40000000007ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000008002f7811ULL, 0x004fe400078ff0ffULL, 0x00000002ff2d7819ULL, 0x000fe40000011600ULL,
0x0000002fff2b7212ULL, 0x002fe200078e33ffULL, 0x00001f2f02087589ULL, 0x000e6200000e0000ULL,
0x000000082f0a7824ULL, 0x000fc400078e00ffULL, 0x000000082d317824ULL, 0x000fe200078e00ffULL,
0x00001f2d02047589ULL, 0x0004e200000e0000ULL, 0x000000082f307824ULL, 0x000fe200078e00ffULL,
0xfffffff80a2b7812ULL, 0x000fe200078ee22bULL, 0x000000082d0a7824ULL, 0x000fc800078e00ffULL,
0x000000102b2b7824ULL, 0x000fe200078e0206ULL, 0x0000002dff027212ULL, 0x004fc800078e33ffULL,
0xfffffff831317812ULL, 0x000fe400078ee202ULL, 0x000000072d027812ULL, 0x000fe200078ec0ffULL,
0x0000002308237220ULL, 0x042fe20000410000ULL, 0x0000002208227220ULL, 0x040fe20000410000ULL,
0x0000002708277220ULL, 0x040fe20000410000ULL, 0x0000002608267220ULL, 0x040fe20000410000ULL,
0x0000001f081f7220ULL, 0x040fe20000410000ULL, 0x0000001e081e7220ULL, 0x040fe20000410000ULL,
0x0000001b081b7220ULL, 0x040fe20000410000ULL, 0x0000001a081a7220ULL, 0x040fe20000410000ULL,
0x0000001708177220ULL, 0x040fe20000410000ULL, 0x0000001608167220ULL, 0x040fe20000410000ULL,
0x0000001308137220ULL, 0x040fe20000410000ULL, 0x0000001208127220ULL, 0x040fe20000410000ULL,
0x0000000f080f7220ULL, 0x040fe20000410000ULL, 0x0000000e080e7220ULL, 0x040fe20000410000ULL,
0x0000000b080b7220ULL, 0x000fe20000410000ULL, 0x0000002104217220ULL, 0x048fe20000410000ULL,
0x0000002004207220ULL, 0x000fe20000410000ULL, 0x0000000508087220ULL, 0x000fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001904197220ULL, 0x040fe20000410000ULL, 0x0000001804187220ULL, 0x040fe20000410000ULL,
0x0000001504157220ULL, 0x040fe20000410000ULL, 0x0000001404147220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000000d040d7220ULL, 0x000fe20000410000ULL, 0xfffffff80a057812ULL, 0x000fe200078ee22dULL,
0x0000000c04047220ULL, 0x000fe20000410000ULL, 0x00000001020a7812ULL, 0x000fc400078e3cffULL,
0x000000232222723eULL, 0x000fe200000000ffULL, 0x0000000400237824ULL, 0x000fe200078e00ffULL,
0x00000002020c7812ULL, 0x040fe200078e3cffULL, 0x000000082d077824ULL, 0x000fe200078e020aULL,
0x00000003022a7812ULL, 0x040fe200078e3cffULL, 0x0000001005057824ULL, 0x000fe200078e0206ULL,
0x00000004022c7812ULL, 0x040fe200078e3cffULL, 0x000000082d097824ULL, 0x000fe200078e020cULL,
0x00000005022e7812ULL, 0x040fe200078e3cffULL, 0x0000001007077824ULL, 0x100fe200078e0206ULL,
0x0000000602027812ULL, 0x000fe200078e3cffULL, 0x0000001009097824ULL, 0x000fe200078e0206ULL,
0x000000212020723eULL, 0x000fc400000000ffULL, 0x000000072f217812ULL, 0x000fe400078ec0ffULL,
0x0000000b0808723eULL, 0x000fe200000000ffULL, 0x000000082d0b7824ULL, 0x040fe200078e022aULL,
0x000000111010723eULL, 0x000fe200000000ffULL, 0x000000082d117824ULL, 0x040fe200078e0202ULL,
0x0000000d0404723eULL, 0x000fe200000000ffULL, 0x000000082d0d7824ULL, 0x000fe200078e022cULL,
0x0000000c232a7812ULL, 0x000fe200078ec0ffULL, 0x000000100b0b7824ULL, 0x000fe200078e0206ULL,
0x0000000f0e0e723eULL, 0x000fe200000000ffULL, 0x000000082d0f7824ULL, 0x000fe200078e022eULL,
0x0000000121027812ULL, 0x040fe200078e3cffULL, 0x000000012a057824ULL, 0x000fe200078e0205ULL,
0x00000002210a7812ULL, 0x000fe200078e3cffULL, 0x000000100d0d7824ULL, 0x100fe200078e0206ULL,
0x000000191818723eULL, 0x000fe200000000ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0206ULL,
0x000000131212723eULL, 0x000fe200000000ffULL, 0x000000012a077824ULL, 0x000fe200078e0207ULL,
0x00000003210c7812ULL, 0x000fe200078e3cffULL, 0x0000001011117824ULL, 0x000fe200078e0206ULL,
0x0000001f1e1e723eULL, 0x000fe200000000ffULL, 0x000000012a097824ULL, 0x000fe200078e0209ULL,
0xfffffff830137812ULL, 0x000fe200078ee22fULL, 0x000000012a0b7824ULL, 0x040fe200078e020bULL,
0x0000000421197812ULL, 0x000fe200078e3cffULL, 0x000000012a0d7824ULL, 0x000fe200078e020dULL,
0x000000292828723eULL, 0x000fe200000000ffULL, 0x000000012a0f7824ULL, 0x000fe200078e020fULL,
0x000000151414723eULL, 0x000fe200000000ffULL, 0x000000082f157824ULL, 0x000fe200078e0202ULL,
0x00000005211f7812ULL, 0x000fe200078e3cffULL, 0x0000001031027824ULL, 0x000fe200078e0206ULL,
0x000000252424723eULL, 0x000fe200000000ffULL, 0x0000002805007388ULL, 0x000fe20000000800ULL,
0x000000171616723eULL, 0x000fe200000000ffULL, 0x000000082f177824ULL, 0x000fe200078e020aULL,
0x0000000621217812ULL, 0x000fe200078e3cffULL, 0x00000010130a7824ULL, 0x000fe200078e0206ULL,
0x0000001b1a1a723eULL, 0x000fe200000000ffULL, 0x000000082f1b7824ULL, 0x040fe200078e020cULL,
0x0000001d1c1c723eULL, 0x000fe200000000ffULL, 0x000000082f1d7824ULL, 0x040fe200078e0219ULL,
0x0000002407007388ULL, 0x000fe20000000800ULL, 0x000000082f1f7824ULL, 0x000fe200078e021fULL,
0x000000272626723eULL, 0x000fe200000000ffULL, 0x00000010150c7824ULL, 0x000fe200078e0206ULL,
0x0000002009007388ULL, 0x000fe20000000800ULL, 0x000000082f217824ULL, 0x000fc400078e0221ULL,
0x0000001017197824ULL, 0x100fe200078e0206ULL, 0x0000001c0b007388ULL, 0x000fe20000000800ULL,
0x000000012a117824ULL, 0x040fe400078e0211ULL, 0x000000101b1b7824ULL, 0x000fe200078e0206ULL,
0x000000180d007388ULL, 0x000fe20000000800ULL, 0x000000012a137824ULL, 0x040fe400078e0202ULL,
0x000000101d1d7824ULL, 0x000fe200078e0206ULL, 0x000000140f007388ULL, 0x000fe20000000800ULL,
0x000000012a157824ULL, 0x000fc400078e020aULL, 0x000000101f1f7824ULL, 0x000fe200078e0206ULL,
0x0000001011007388ULL, 0x000fe20000000800ULL, 0x000000012a177824ULL, 0x040fe400078e020cULL,
0x0000001021217824ULL, 0x000fe200078e0206ULL, 0x0000000413007388ULL, 0x000fe20000000800ULL,
0x000000012a197824ULL, 0x040fe400078e0219ULL, 0x000000012a1b7824ULL, 0x040fe200078e021bULL,
0x0000002615007388ULL, 0x000fe20000000800ULL, 0x000000012a1d7824ULL, 0x000fc400078e021dULL,
0x000000012a1f7824ULL, 0x040fe200078e021fULL, 0x0000002217007388ULL, 0x000fe20000000800ULL,
0x000000012a217824ULL, 0x040fe400078e0221ULL, 0x000000012a2b7824ULL, 0x000fe200078e022bULL,
0x0000001e19007388ULL, 0x000fe20000000800ULL, 0x000000204b027824ULL, 0x000fc600078e0200ULL,
0x0000001a1b007388ULL, 0x000fe20000000800ULL, 0x0000001002027824ULL, 0x000fc600078e0203ULL,
0x000000161d007388ULL, 0x000fe80000000800ULL, 0x000000121f007388ULL, 0x000fe80000000800ULL,
0x0000000e21007388ULL, 0x000fe80000000800ULL, 0x000000082b007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000002047984ULL, 0x000e680000000c00ULL,
0x00040000022c7984ULL, 0x000ea80000000c00ULL, 0x0008000002247984ULL, 0x000ee80000000c00ULL,
0x000c000002307984ULL, 0x000f220000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff2f2f7230ULL, 0x004fe40000000000ULL,
0x200000ff2e2e7230ULL, 0x000fe40000000000ULL, 0x200000ff2d2d7230ULL, 0x000fc40000000000ULL,
0x200000ff2c2c7230ULL, 0x000fe40000000000ULL, 0x0000002707077230ULL, 0x008fe40000000000ULL,
0x0000002606067230ULL, 0x000fe40000000000ULL, 0x0000002505057230ULL, 0x000fe40000000000ULL,
0x0000002404047230ULL, 0x000fe40000000000ULL, 0x000000332f2f7230ULL, 0x010fc40000000000ULL,
0x000000322e2e7230ULL, 0x000fe20000000000ULL, 0x0000000402007388ULL, 0x0003e20000000c00ULL,
0x000000312d2d7230ULL, 0x000fe40000000000ULL, 0x000000302c2c7230ULL, 0x000fca0000000000ULL,
0x0004002c02007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff4b00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000187919ULL, 0x000ea20000002600ULL, 0x00000020001d7810ULL, 0x042fe20007ffe0ffULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0x00000040001f7810ULL, 0x040fe20007ffe0ffULL,
0x0000580000057ab9ULL, 0x000fe20000000800ULL, 0x00000060001e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000405057899ULL, 0x000fe2000800063fULL, 0x00000003ff057819ULL, 0x000fe20000011600ULL,
0x000000084c1b7824ULL, 0x040fe200078e00ffULL, 0x00000003ff157819ULL, 0x000fe2000001161dULL,
0x000000084c1a7824ULL, 0x040fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe2000001161fULL,
0x000000084c1c7824ULL, 0x040fe200078e00ffULL, 0x00000003ff177819ULL, 0x000fe2000001161eULL,
0x000000084c217824ULL, 0x000fe200078e00ffULL, 0x0000000715047812ULL, 0x000fc400078e481dULL,
0x0000000716067812ULL, 0x000fe400078e481fULL, 0x0000000717077812ULL, 0x100fe400078e481eULL,
0x0ffffff804047812ULL, 0x000fe400078ef81dULL, 0x0ffffff806067812ULL, 0x000fe200078ef81fULL,
0x0000001018147824ULL, 0x004fe200078e00ffULL, 0x0ffffff8070a7812ULL, 0x000fe200078ef81eULL,
0x0000001004087824ULL, 0x100fe200078e0203ULL, 0x00000004050472a4ULL, 0x002fe2000f8e023fULL,
0x00000010060c7824ULL, 0x000fe200078e0203ULL, 0xfffffff014147812ULL, 0x000fe200078ee205ULL,
0x000000100a107824ULL, 0x100fe200078e0203ULL, 0x0000000705057812ULL, 0x100fe200078e4800ULL,
0x0000000008087984ULL, 0x000fe20000000c00ULL, 0x0000000414147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001018197824ULL, 0x040fe200078e00ffULL, 0x0ffffff805027812ULL, 0x100fe200078ef800ULL,
0x000000000c0c7984ULL, 0x000fe20000000c00ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL,
0x0000001018007824ULL, 0x000fe200078e00ffULL, 0xfffffff019167812ULL, 0x000fe200078ee216ULL,
0x0000001002027824ULL, 0x000fe200078e0203ULL, 0x0000000010107984ULL, 0x000fe20000000c00ULL,
0x0000001018187824ULL, 0x000fe200078e00ffULL, 0xfffffff000157812ULL, 0x000fe200078ee215ULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x0000000002047984ULL, 0x0002a20000000c00ULL,
0xfffffff81a1d7812ULL, 0x000fc400078ee21dULL, 0xfffffff018177812ULL, 0x000fe400078ee217ULL,
0x00000004161a7c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000417007c10ULL, 0x000fe4000ff5e0ffULL,
0x00005a0014027a11ULL, 0x002fe200078040ffULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0xfffffff81c1f7812ULL, 0x000fe200078ee21fULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x00005b0014037a11ULL, 0x000fc400000f4403ULL, 0x0000000415157c10ULL, 0x000fe4000ff1e0ffULL,
0x00005a001a167a11ULL, 0x000fe200078240ffULL, 0x000000101b027825ULL, 0x000fe200078e0002ULL,
0x00005a0000187a11ULL, 0x000fe400078440ffULL, 0x00005b001a177a11ULL, 0x000fe200008f4417ULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x00005a0015147a11ULL, 0x000fe400078040ffULL,
0xfffffff821217812ULL, 0x000fe200078ee21eULL, 0x000000101f167825ULL, 0x000fe200078e0016ULL,
0x00005b0015157a11ULL, 0x000fc400000f441cULL, 0x00005b0000197a11ULL, 0x000fc600010f4419ULL,
0x000000101d147825ULL, 0x000fc800078e0014ULL, 0x0000001021187825ULL, 0x000fe200078e0018ULL,
0x0000000402007986ULL, 0x004fe8000c101d08ULL, 0x0000000814007986ULL, 0x000fe8000c101d08ULL,
0x0000000c16007986ULL, 0x000fe8000c101d08ULL, 0x0000001018007986ULL, 0x000fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006800ff087624ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x00afe20000011650ULL, 0x00006900ff097624ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fe200078e00ffULL, 0x01ffffff03037812ULL, 0x000fe400078ec0ffULL,
0x0000000808357981ULL, 0x000366000c1e9900ULL, 0x0000000252367824ULL, 0x000fca00078e0203ULL,
0x0000004f3600720cULL, 0x000fe40003f06070ULL, 0x0000000152007810ULL, 0x000fd60007ffe0ffULL,
0x0000000207038824ULL, 0x000fc800078e00ffULL, 0x0000640003048a24ULL, 0x000fc800078e0236ULL,
0x0000600004048625ULL, 0x000fca00078e0014ULL, 0x0000000804348981ULL, 0x000362000c1e1900ULL,
0x0000004d0000720cULL, 0x000fe20003f06070ULL, 0x0000004050037824ULL, 0x000fe400078e00ffULL,
0x0000008017027824ULL, 0x000fe400078e00ffULL, 0x00000100520d7824ULL, 0x000fe400078e0203ULL,
0x0000008012067824ULL, 0x000fc600078e00ffULL, 0x00000040020b7812ULL, 0x000fc600078ef80dULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x0000000000117919ULL, 0x002e620000000000ULL,
0x0000003406067224ULL, 0x020fe200078e020bULL, 0x0000000d4e007217ULL, 0x000fe20007800000ULL,
0x00000080ff1a7424ULL, 0x000fe200078e00ffULL, 0x0000100050157811ULL, 0x000fc600078e68ffULL,
0x0000000100007824ULL, 0x000fe200078e0a0dULL, 0x00000002ff1f7819ULL, 0x102fe20000011611ULL,
0x0000001011217824ULL, 0x000fe200078e00ffULL, 0x00000003ff147819ULL, 0x000fe40000011611ULL,
0x0000007f1f057812ULL, 0x040fe400078ec0ffULL, 0x000000081f137810ULL, 0x000fe40007ffe0ffULL,
0x0000003021217812ULL, 0x000fe200078ec0ffULL, 0x0000000106057824ULL, 0x000fe200078e0205ULL,
0x0000007f13097812ULL, 0x000fc400078ec0ffULL, 0x000000101f237810ULL, 0x000fe20007ffe0ffULL,
0x00005e0005047625ULL, 0x080fe200078e001aULL, 0x000000181f257810ULL, 0x000fe40007ffe0ffULL,
0x0000007f230b7812ULL, 0x000fe200078ec0ffULL, 0x0000000106097824ULL, 0x000fe200078e0209ULL,
0x00000021040c7210ULL, 0x000fe40007f1e0ffULL, 0x000000201f197810ULL, 0x000fe20007ffe0ffULL,
0x00005e0009087625ULL, 0x000fe200078e001aULL, 0x0000000314147812ULL, 0x000fc400078e4811ULL,
0x000000281f1b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0605ULL,
0x0000007f25057812ULL, 0x000fe200078ec0ffULL, 0x00000001060b7824ULL, 0x000fe200078e020bULL,
0x00000021080e7210ULL, 0x000fe40007f1e0ffULL, 0x000000301f1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000106057824ULL, 0x000fe200078e0205ULL, 0x000000002300720cULL, 0x000fe20003fa6070ULL,
0x00005e000b0a7625ULL, 0x000fe200078e001aULL, 0x000000002500720cULL, 0x000fc60003f86070ULL,
0x00005e0005047625ULL, 0x000fe200078e001aULL, 0x000000210a0a7210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e0609ULL, 0x0000007f19097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000002104107210ULL, 0x000fe20007f5e0ffULL,
0x0000000423237824ULL, 0x000fe200078e00ffULL, 0x000000001f00720cULL, 0x080fe20003f06070ULL,
0x0000000106097824ULL, 0x000fe200078e0209ULL, 0x0ffffffc14047812ULL, 0x000fe200078ef811ULL,
0x000000ffff117224ULL, 0x000fe200010e0605ULL, 0x000000001300720cULL, 0x000fe20003f26070ULL,
0x00005e0009087625ULL, 0x000fe200078e001aULL, 0x0000007f1b057812ULL, 0x000fc400078ec0ffULL,
0x000000381f1f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000413137824ULL, 0x000fe200078e00ffULL,
0x0000002108127210ULL, 0x000fe20007f7e0ffULL, 0x0000001004177824ULL, 0x000fe200078e0215ULL,
0x000000001b00720cULL, 0x000fe20003f46070ULL, 0x0000000106057824ULL, 0x000fe200078e0205ULL,
0xfffffffc13087812ULL, 0x000fe200078ee214ULL, 0x000000ffff137224ULL, 0x000fe200018e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c177faeULL, 0x0003e2000c101c48ULL,
0x00005e0005047625ULL, 0x000fe200078e001aULL, 0x000000001900720cULL, 0x000fc40003f66070ULL,
0x000000001f00720cULL, 0x080fe20003f06070ULL, 0x0000001008097824ULL, 0x000fe400078e0215ULL,
0x0000000425257824ULL, 0x000fe400078e00ffULL, 0x0000000419197824ULL, 0x000fe200078e00ffULL,
0x000000000e097faeULL, 0x0005e2000c901c48ULL, 0x000000001d00720cULL, 0x000fe20003f26070ULL,
0x000000041b1b7824ULL, 0x000fe200078e00ffULL, 0x0000007f1d0d7812ULL, 0x042fe200078ec0ffULL,
0x000000041d1d7824ULL, 0x000fe200078e00ffULL, 0x00000021040c7210ULL, 0x000fc40007fde0ffULL,
0xfffffffc23007812ULL, 0x100fe200078ee214ULL, 0x0000000106047824ULL, 0x000fe200078e020dULL,
0xfffffffc1b167812ULL, 0x100fe200078ee214ULL, 0x000000ffff0d7224ULL, 0x000fe200030e0605ULL,
0xfffffffc1d187812ULL, 0x100fe200078ee214ULL, 0x00005e0004047625ULL, 0x080fe200078e001aULL,
0x0000007f1f097812ULL, 0x004fe400078ec0ffULL, 0xfffffffc190e7812ULL, 0x100fe200078ee214ULL,
0x000000041f1f7824ULL, 0x000fe200078e00ffULL, 0x0000002104047210ULL, 0x000fe20007fde0ffULL,
0x0000000106097824ULL, 0x000fe200078e0209ULL, 0xfffffffc25067812ULL, 0x100fe200078ee214ULL,
0x00000010000f7824ULL, 0x000fe200078e0215ULL, 0xfffffffc1f147812ULL, 0x000fe200078ee214ULL,
0x00005e0009087625ULL, 0x000fc600078e001aULL, 0x000000000a0f7faeULL, 0x0003e2000e901c48ULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x0000002108087210ULL, 0x000fe20007fde0ffULL,
0x0000001006177824ULL, 0x100fe400078e0215ULL, 0x000000100e197824ULL, 0x100fe400078e0215ULL,
0x00000010161b7824ULL, 0x100fe200078e0215ULL, 0x0000000010177faeULL, 0x0003e2000e101c48ULL,
0x00000010181d7824ULL, 0x100fe400078e0215ULL, 0x0000001014157824ULL, 0x000fe200078e0215ULL,
0x0000000012197faeULL, 0x0003e2000d901c48ULL, 0x000000ffff097224ULL, 0x000fc600030e0609ULL,
0x000000000c1b7faeULL, 0x0003e8000d101c48ULL, 0x00000000041d7faeULL, 0x0003e8000c901c48ULL,
0x0000000008157faeULL, 0x0003e2000c101c48ULL, 0x000005a000007947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x002e620000000000ULL, 0x0000003406067224ULL, 0x020fe200078e020bULL,
0x00000002ff047819ULL, 0x002fc40000011600ULL, 0x00000003ff057819ULL, 0x000fe40000011600ULL,
0x0000007f04097812ULL, 0x040fe400078ec0ffULL, 0x0000000804087810ULL, 0x040fe40007ffe0ffULL,
0x00000010040b7810ULL, 0x040fe40007ffe0ffULL, 0x00000018040e7810ULL, 0x040fe40007ffe0ffULL,
0x0000002004117810ULL, 0x000fc40007ffe0ffULL, 0x0000002804147810ULL, 0x040fe40007ffe0ffULL,
0x0000003004177810ULL, 0x040fe20007ffe0ffULL, 0x00000004111c7824ULL, 0x000fe200078e00ffULL,
0x0000003804187810ULL, 0x000fe20007ffe0ffULL, 0x0000000106047824ULL, 0x000fe200078e0209ULL,
0x0000007f08097812ULL, 0x000fe200078ec0ffULL, 0x0000000414207824ULL, 0x000fe200078e00ffULL,
0x0000007f0b0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000417227824ULL, 0x000fe200078e00ffULL,
0x0000007f0e0f7812ULL, 0x000fe200078ec0ffULL, 0x00000001060a7824ULL, 0x040fe200078e0209ULL,
0x0000007f11137812ULL, 0x000fe200078ec0ffULL, 0x00000001060c7824ULL, 0x000fe200078e020dULL,
0x0000007f14157812ULL, 0x000fe200078ec0ffULL, 0x0000000106107824ULL, 0x040fe200078e020fULL,
0x0000007f17197812ULL, 0x000fe200078ec0ffULL, 0x0000000106127824ULL, 0x000fe200078e0213ULL,
0x0000007f181b7812ULL, 0x000fe200078ec0ffULL, 0x0000000106167824ULL, 0x040fe200078e0215ULL,
0x0000000305097812ULL, 0x000fe200078e4800ULL, 0x00000001061a7824ULL, 0x000fe200078e0219ULL,
0x00001000500d7811ULL, 0x000fe200078e68ffULL, 0x00000001061e7824ULL, 0x000fe200078e021bULL,
0xfffffffc1c147812ULL, 0x100fe200078ee209ULL, 0x0000000408067824ULL, 0x000fe200078e00ffULL,
0xfffffffc221c7812ULL, 0x000fe200078ee209ULL, 0x000000040b087824ULL, 0x000fc400078e00ffULL,
0x0000001000057824ULL, 0x000fe200078e00ffULL, 0x0ffffffc09007812ULL, 0x000fe200078ef800ULL,
0x000000040e0e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc08087812ULL, 0x100fe200078ee209ULL,
0x0000000418247824ULL, 0x000fe200078e00ffULL, 0xfffffffc20187812ULL, 0x000fe200078ee209ULL,
0x00000080ff157424ULL, 0x000fe200078e00ffULL, 0x0000003005177812ULL, 0x000fe200078ec0ffULL,
0x00000010081d7824ULL, 0x000fe200078e020dULL, 0xfffffffc06067812ULL, 0x100fe200078ee209ULL,
0x00005e0004047625ULL, 0x000fe200078e0015ULL, 0xfffffffc0e0e7812ULL, 0x000fc400078ee209ULL,
0xfffffffc24207812ULL, 0x000fe200078ee209ULL, 0x00005e000a087625ULL, 0x000fe200078e0015ULL,
0x0000001704047210ULL, 0x000fc60007f1e0ffULL, 0x0000001000197824ULL, 0x100fe200078e020dULL,
0x0000001708087210ULL, 0x000fe20007f3e0ffULL, 0x00000010061b7824ULL, 0x100fe400078e020dULL,
0x000000100e1f7824ULL, 0x100fe400078e020dULL, 0x0000001014217824ULL, 0x100fe400078e020dULL,
0x0000001018237824ULL, 0x000fe400078e020dULL, 0x00005e000c0a7625ULL, 0x000fc800078e0015ULL,
0x000000101c257824ULL, 0x100fe200078e020dULL, 0x000000170a0a7210ULL, 0x000fe20007f5e0ffULL,
0x0000001020277824ULL, 0x000fe400078e020dULL, 0x00005e00100c7625ULL, 0x000fc800078e0015ULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x000000170c0c7210ULL, 0x000fe20007f1e0ffULL,
0x00005e00120e7625ULL, 0x000fc600078e0015ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004197faeULL, 0x0003e2000b901c48ULL, 0x00005e0016107625ULL, 0x000fc800078e0015ULL,
0x00005e001a127625ULL, 0x000fc800078e0015ULL, 0x00005e001e147625ULL, 0x000fc800078e0015ULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x000000170e0e7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000001710107210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000001712127210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e060fULL, 0x0000001714147210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x00000000081b7faeULL, 0x0003e2000b901c48ULL,
0x000000ffff137224ULL, 0x000fc400010e0613ULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0x000000000a1d7faeULL, 0x0003e8000b901c48ULL, 0x000000000c1f7faeULL, 0x0003e8000b901c48ULL,
0x000000000e217faeULL, 0x0003e8000b901c48ULL, 0x0000000010237faeULL, 0x0003e8000b901c48ULL,
0x0000000012257faeULL, 0x0003e8000b901c48ULL, 0x0000000014277faeULL, 0x0003e4000b901c48ULL,
0x00f60400ff007984ULL, 0x000ea80000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000000ff7812ULL, 0x004fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x00f60400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000035000780cULL, 0x000fda0003f04070ULL,
0x0000017000000947ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x002e640000000000ULL,
0x0000002050007824ULL, 0x002fc800078e0205ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x000000f006067812ULL, 0x000fe400078ec0ffULL, 0x0000000105097812ULL, 0x040fe400078efcffULL,
0x0000000705057812ULL, 0x100fe400078e7800ULL, 0x0000000709097812ULL, 0x000fc600078e7800ULL,
0x0000000105057824ULL, 0x000fe400078e0206ULL, 0x0000000106097824ULL, 0x000fc600078e0209ULL,
0x0000000005107984ULL, 0x000e68000000cc00ULL, 0x00000000090c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fc400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff127224ULL, 0x000fe400078e000dULL, 0x000000ffff137224ULL, 0x000fe200078e000fULL,
0x0000001405007388ULL, 0x0003e8000000cc00ULL, 0x0000001009007388ULL, 0x0003e4000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ffff7f8cULL, 0x000fe8000c80043fULL,
0x00f60400ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x00f60400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000004d5200720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000377919ULL, 0x000ea20000000000ULL, 0x3db504f335357820ULL, 0x000fe20000410000ULL,
0x00006400073d7a24ULL, 0x000fe200078e02ffULL, 0xffffffff4d3b7810ULL, 0x000fe20007ffe0ffULL,
0x00000010503a7824ULL, 0x000fe200078e00ffULL, 0x00007610ff387816ULL, 0x000fe20000000038ULL,
0x000000ffff397224ULL, 0x000fe200078e00ffULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000704047899ULL, 0x000fe4000800063fULL, 0x00000100523f7824ULL, 0x000fe200078e0203ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000003f4e00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x028fea0003800000ULL, 0x000000ffff217224ULL, 0x002fe200078e0039ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fc4000001ff00ULL, 0x0000000100227810ULL, 0x000fe20007ffe0ffULL,
0x00000bd000007945ULL, 0x000fe20003800000ULL, 0x0000000121397812ULL, 0x000fc400078e0cffULL,
0x00000001ff237819ULL, 0x000fe40000011622ULL, 0x000000022200780cULL, 0x040fe40003f06070ULL,
0x00000001223c7812ULL, 0x000fe200078ec0ffULL, 0x0000030023207a24ULL, 0x000fc800078e0252ULL,
0x0000010020257824ULL, 0x040fe200078e0203ULL, 0x0000000120247810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff207224ULL, 0x000fe400078e0000ULL, 0x000000ffff007224ULL, 0x000fe200078e0022ULL,
0x0000004d2400720cULL, 0x000fe40003f26070ULL, 0x0000004025237812ULL, 0x000fca00078ec0ffULL,
0x0000000102237824ULL, 0x000fcc00078e0223ULL, 0x000005d000009947ULL, 0x020fea0003800000ULL,
0x00000002ff317819ULL, 0x004fe20000011637ULL, 0x000000043c247824ULL, 0x000fe200078e00ffULL,
0x000000254e227217ULL, 0x000fe20007800000ULL, 0x0000000434277c24ULL, 0x000fe2000f8e0223ULL,
0x0000000831237810ULL, 0x040fe20007ffe0ffULL, 0x00000002502c7824ULL, 0x000fe200078e0239ULL,
0xfffffffc24337812ULL, 0x000fe200078ee237ULL, 0x0000000122267824ULL, 0x000fe200078e0a25ULL,
0x00000003ff227819ULL, 0x000fe20000011637ULL, 0x00000080ff517424ULL, 0x000fe200078e00ffULL,
0x0000007f31247812ULL, 0x000fe200078ec0ffULL, 0x00000004232f7824ULL, 0x040fe200078e00ffULL,
0x0000007f232e7812ULL, 0x000fc400078ec0ffULL, 0x0000000322327812ULL, 0x000fe200078e4837ULL,
0x0000000124227824ULL, 0x100fe200078e0227ULL, 0x000000263100720cULL, 0x080fe20003f26070ULL,
0x000000012e247824ULL, 0x000fe200078e0227ULL, 0x000000262300720cULL, 0x000fe20003f46070ULL,
0x00005e0022227625ULL, 0x080fe200078e0051ULL, 0x000010002c2c7811ULL, 0x000fe400078e60ffULL,
0x0ffffffc322d7812ULL, 0x000fe200078ef837ULL, 0x00005e0024247625ULL, 0x000fe200078e0051ULL,
0xfffffffc2f2f7812ULL, 0x000fc400078ee232ULL, 0x0000001031417810ULL, 0x000fe20007ffe0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e022cULL, 0x0000001831437810ULL, 0x000fe20007ffe0ffULL,
0x0000001033227825ULL, 0x000fe200078e0022ULL, 0x0000002031457810ULL, 0x040fe40007ffe0ffULL,
0x0000002831477810ULL, 0x000fe20007ffe0ffULL, 0x000000102f2f7824ULL, 0x000fe200078e022cULL,
0x0000003031497810ULL, 0x000fe20007ffe0ffULL, 0x0000001033247825ULL, 0x000fe200078e0024ULL,
0x0000003831317810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000222d7faeULL, 0x0003e2000c901c48ULL, 0x000000264100720cULL, 0x000fc40003f26070ULL,
0x000000264500720cULL, 0x080fe20003f66070ULL, 0x00000000242f7faeULL, 0x0005e2000d101c48ULL,
0x000000264300720cULL, 0x080fe20003f46070ULL, 0x00000004314b7824ULL, 0x000fe200078e00ffULL,
0x000000264700720cULL, 0x080fe40003f86070ULL, 0x000000264900720cULL, 0x080fe40003fa6070ULL,
0x000000263100720cULL, 0x000fe40003fc6070ULL, 0x0000007f41227812ULL, 0x042fe200078ec0ffULL,
0x0000000441417824ULL, 0x000fe200078e00ffULL, 0x0000007f45267812ULL, 0x040fe200078ec0ffULL,
0x0000000445457824ULL, 0x000fe200078e00ffULL, 0x0000007f43247812ULL, 0x044fe200078ec0ffULL,
0x0000000443437824ULL, 0x000fe200078e00ffULL, 0x0000007f472e7812ULL, 0x040fe200078ec0ffULL,
0x0000000447477824ULL, 0x000fe200078e00ffULL, 0x0000007f49307812ULL, 0x040fe200078ec0ffULL,
0x0000000449497824ULL, 0x000fe200078e00ffULL, 0x0000007f313e7812ULL, 0x000fe200078ec0ffULL,
0x0000000122227824ULL, 0x100fe200078e0227ULL, 0xfffffffc41417812ULL, 0x100fe200078ee232ULL,
0x0000000124247824ULL, 0x100fe200078e0227ULL, 0xfffffffc43437812ULL, 0x100fe200078ee232ULL,
0x0000000126267824ULL, 0x100fe200078e0227ULL, 0xfffffffc45457812ULL, 0x100fe200078ee232ULL,
0x000000012e2d7824ULL, 0x100fe200078e0227ULL, 0xfffffffc47477812ULL, 0x100fe200078ee232ULL,
0x00000001302e7824ULL, 0x000fe200078e0227ULL, 0xfffffffc49497812ULL, 0x100fe200078ee232ULL,
0x00005e0022227625ULL, 0x000fe200078e0051ULL, 0xfffffffc4b4b7812ULL, 0x000fc600078ee232ULL,
0x000000013e307824ULL, 0x000fe400078e0227ULL, 0x00005e0024247625ULL, 0x000fc800078e0051ULL,
0x0000001041417824ULL, 0x100fe400078e022cULL, 0x0000001043437824ULL, 0x100fe400078e022cULL,
0x0000001045457824ULL, 0x100fe400078e022cULL, 0x0000001047477824ULL, 0x100fe400078e022cULL,
0x0000001049497824ULL, 0x100fe400078e022cULL, 0x000000104b4b7824ULL, 0x000fc400078e022cULL,
0x00005e0026267625ULL, 0x000fc800078e0051ULL, 0x00005e002d2c7625ULL, 0x000fc800078e0051ULL,
0x00005e002e2e7625ULL, 0x000fc800078e0051ULL, 0x00005e0030307625ULL, 0x000fc800078e0051ULL,
0x0000001033227825ULL, 0x000fc800078e0022ULL, 0x0000001033247825ULL, 0x040fe200078e0024ULL,
0x0000000022417faeULL, 0x0003e6000c901c48ULL, 0x0000001033267825ULL, 0x040fe200078e0026ULL,
0x0000000024437faeULL, 0x0003e6000d101c48ULL, 0x00000010332c7825ULL, 0x040fe200078e002cULL,
0x0000000026457faeULL, 0x0003e6000d901c48ULL, 0x00000010332e7825ULL, 0x040fe200078e002eULL,
0x000000002c477faeULL, 0x0003e6000e101c48ULL, 0x0000001033307825ULL, 0x000fe200078e0030ULL,
0x000000002e497faeULL, 0x0003e8000e901c48ULL, 0x00000000304b7faeULL, 0x0003e2000f101c48ULL,
0x0000052000007947ULL, 0x000fea0003800000ULL, 0x00000002ff227819ULL, 0x004fe20000011637ULL,
0x0000000434237c24ULL, 0x000fc4000f8e0223ULL, 0x00000080ff417424ULL, 0x000fe200078e00ffULL,
0x0000000822257810ULL, 0x040fe40007ffe0ffULL, 0x0000001022277810ULL, 0x040fe40007ffe0ffULL,
0x00000018222d7810ULL, 0x040fe40007ffe0ffULL, 0x00000020222f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000427457824ULL, 0x000fe200078e00ffULL, 0x0000002822317810ULL, 0x040fe20007ffe0ffULL,
0x000000042d477824ULL, 0x000fe200078e00ffULL, 0x0000003022337810ULL, 0x040fe20007ffe0ffULL,
0x000000042f497824ULL, 0x000fe200078e00ffULL, 0x0000003822447810ULL, 0x040fe20007ffe0ffULL,
0x00000004314b7824ULL, 0x000fe200078e00ffULL, 0x0000007f22247812ULL, 0x000fe200078ec0ffULL,
0x0000000433557824ULL, 0x000fe200078e00ffULL, 0x0000007f25227812ULL, 0x000fe200078ec0ffULL,
0x0000000444577824ULL, 0x000fe200078e00ffULL, 0x0000007f27267812ULL, 0x000fe200078ec0ffULL,
0x0000000124247824ULL, 0x100fe200078e0223ULL, 0x0000007f2d2c7812ULL, 0x000fe200078ec0ffULL,
0x00000001222e7824ULL, 0x100fe200078e0223ULL, 0x0000007f2f3e7812ULL, 0x000fe200078ec0ffULL,
0x0000000126307824ULL, 0x100fe200078e0223ULL, 0x0000007f31407812ULL, 0x000fe200078ec0ffULL,
0x000000012c327824ULL, 0x100fe200078e0223ULL, 0x0000007f33427812ULL, 0x000fe200078ec0ffULL,
0x000000013e3e7824ULL, 0x100fe200078e0223ULL, 0x0000007f44467812ULL, 0x000fe200078ec0ffULL,
0x0000000140407824ULL, 0x000fe200078e0223ULL, 0x00000003ff227819ULL, 0x000fe20000011637ULL,
0x0000000142427824ULL, 0x000fc400078e0223ULL, 0x0000000146467824ULL, 0x000fe400078e0223ULL,
0x000000043c267824ULL, 0x000fe400078e00ffULL, 0x0000000250237824ULL, 0x000fc600078e0239ULL,
0xfffffffc26437812ULL, 0x100fe400078ee237ULL, 0x00001000232c7811ULL, 0x000fe200078e60ffULL,
0x0000000425237824ULL, 0x000fe200078e00ffULL, 0x0000000322267812ULL, 0x000fc800078e4837ULL,
0x0ffffffc26257812ULL, 0x000fe400078ef837ULL, 0xfffffffc23277812ULL, 0x100fe200078ee226ULL,
0x00005e0024227625ULL, 0x080fe200078e0041ULL, 0xfffffffc452d7812ULL, 0x100fe400078ee226ULL,
0xfffffffc472f7812ULL, 0x000fe200078ee226ULL, 0x0000001025457824ULL, 0x000fe200078e022cULL,
0xfffffffc49317812ULL, 0x000fe200078ee226ULL, 0x0000001027477824ULL, 0x000fe200078e022cULL,
0xfffffffc4b337812ULL, 0x100fe200078ee226ULL, 0x00005e002e247625ULL, 0x000fe200078e0041ULL,
0xfffffffc55557812ULL, 0x000fc400078ee226ULL, 0xfffffffc57577812ULL, 0x000fe200078ee226ULL,
0x000000102d497824ULL, 0x100fe400078e022cULL, 0x000000102f4b7824ULL, 0x100fe400078e022cULL,
0x0000001031517824ULL, 0x100fe400078e022cULL, 0x0000001033537824ULL, 0x100fe400078e022cULL,
0x0000001055557824ULL, 0x100fe400078e022cULL, 0x0000001057577824ULL, 0x000fc400078e022cULL,
0x00005e0030267625ULL, 0x000fc800078e0041ULL, 0x00005e00322c7625ULL, 0x000fc800078e0041ULL,
0x00005e003e2e7625ULL, 0x000fc800078e0041ULL, 0x00005e0040307625ULL, 0x000fc800078e0041ULL,
0x0000001043227825ULL, 0x000fc800078e0022ULL, 0x00005e0042327625ULL, 0x080fe200078e0041ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022457faeULL, 0x0003e6000b901c48ULL,
0x00005e0046407625ULL, 0x000fc800078e0041ULL, 0x0000001043247825ULL, 0x000fc800078e0024ULL,
0x0000001043267825ULL, 0x040fe200078e0026ULL, 0x0000000024477faeULL, 0x0003e6000b901c48ULL,
0x00000010432c7825ULL, 0x040fe200078e002cULL, 0x0000000026497faeULL, 0x0003e6000b901c48ULL,
0x00000010432e7825ULL, 0x040fe200078e002eULL, 0x000000002c4b7faeULL, 0x0003e6000b901c48ULL,
0x0000001043307825ULL, 0x040fe200078e0030ULL, 0x000000002e517faeULL, 0x0003e6000b901c48ULL,
0x0000001043327825ULL, 0x040fe200078e0032ULL, 0x0000000030537faeULL, 0x0003e6000b901c48ULL,
0x0000001043407825ULL, 0x000fe200078e0040ULL, 0x0000000032557faeULL, 0x0003e8000b901c48ULL,
0x0000000040577faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff3c00720cULL, 0x000fe20003f25270ULL, 0x000000b000007945ULL, 0x000fd80003800000ULL,
0x0000009000009947ULL, 0x000fea0003800000ULL, 0x00000300ff237624ULL, 0x002fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fe400078e00ffULL, 0x0000000223367824ULL, 0x000fca00078e0236ULL,
0x0000004f3600720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x000000023d227824ULL, 0x000fe400078e0236ULL, 0x00000004ff237424ULL, 0x000fc800078e00ffULL,
0x0000600022227625ULL, 0x000fca00078e0023ULL, 0x0000000822347981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002037227810ULL, 0x042fe20007ffe0ffULL, 0x00000008203c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8373e7812ULL, 0x040fe200078ec0ffULL, 0x0000000250427824ULL, 0x000fe200078e0221ULL,
0xfffffff822227812ULL, 0x000fe200078ec0ffULL, 0x000000ffff407224ULL, 0x000fe200078e00ffULL,
0x000000073e3e7812ULL, 0x100fe400078ef837ULL, 0x0000000722437812ULL, 0x000fe400078ef837ULL,
0x0000000737207812ULL, 0x000fc400078ec0ffULL, 0x00000001ff457819ULL, 0x000fe4000001163eULL,
0x00000001ff477819ULL, 0x000fe40000011643ULL, 0x0000100042427811ULL, 0x000fe400078e60ffULL,
0x0000000820417812ULL, 0x000fe400078ef837ULL, 0x0000000345457812ULL, 0x000fe400078ec0ffULL,
0x0000000347477812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000004045217212ULL, 0x000fe200078e3cffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000003c37307211ULL, 0x000fc400078fe0ffULL, 0x00000040472c7212ULL, 0x000fe200078e3cffULL,
0x000000043e217824ULL, 0x000fe200078e0221ULL, 0x0000000730207812ULL, 0x100fe400078e7841ULL,
0x0000000140447810ULL, 0x000fe20007ffe0ffULL, 0x0000001021247824ULL, 0x000fe200078e0242ULL,
0x0000000230307810ULL, 0x000fe20007ffe0ffULL, 0x0000001041207824ULL, 0x000fe200078e0220ULL,
0x0000004445317212ULL, 0x080fe200078e3cffULL, 0x00000004432d7824ULL, 0x000fe200078e022cULL,
0x0000000730307812ULL, 0x000fe200078e7841ULL, 0x000000002424783bULL, 0x000e620000000200ULL,
0x0000001020207824ULL, 0x000fe200078e00ffULL, 0x0000004447447212ULL, 0x000fe200078e3cffULL,
0x000000102d2d7824ULL, 0x100fe200078e0242ULL, 0x0000000240407810ULL, 0x000fe20007ffe0ffULL,
0x000000043e317824ULL, 0x000fe200078e0231ULL, 0x000000043c3c7810ULL, 0x000fe20007ffe0ffULL,
0x000000002020783bULL, 0x000ea20000000200ULL, 0x000000044000780cULL, 0x000fe20003f25270ULL,
0x0000001031317824ULL, 0x000fc400078e0242ULL, 0x000000002d2c783bULL, 0x000ee20000000200ULL,
0x00000025ff48723eULL, 0x082fe400020006ffULL, 0x00000025ff49723eULL, 0x000fe400030006ffULL,
0x00000024ff32723eULL, 0x080fe400020006ffULL, 0x00000024ff33723eULL, 0x000fe400030006ffULL,
0x00000026ff24723eULL, 0x080fe200020006ffULL, 0x000000482018723cULL, 0x004fe20000001818ULL,
0x00000026ff25723eULL, 0x000fc400030006ffULL, 0x00000027ff26723eULL, 0x080fe400020006ffULL,
0x00000027ff27723eULL, 0x000fe400030006ffULL, 0x0000002cff48723eULL, 0x088fe200020006ffULL,
0x000000242014723cULL, 0x000fe20000001814ULL, 0x0000002cff49723eULL, 0x000fe400030006ffULL,
0x0000002dff2c723eULL, 0x080fe400020006ffULL, 0x0000002dff2d723eULL, 0x000fc400030006ffULL,
0x0000001041247824ULL, 0x000fe200078e0230ULL, 0x00000032201c723cULL, 0x000fe2000000181cULL,
0x000000003130783bULL, 0x000e640000000200ULL, 0x0000001024247824ULL, 0x000fca00078e00ffULL,
0x0000002c200c723cULL, 0x040fee000000180cULL, 0x0000002eff2c723eULL, 0x080fe200020006ffULL,
0x000000482010723cULL, 0x000fe20000001810ULL, 0x0000002eff2d723eULL, 0x000fcc00030006ffULL,
0x0000000443497824ULL, 0x000fe200078e0244ULL, 0x000000262028723cULL, 0x000fe20000001828ULL,
0x000000002424783bULL, 0x000ea20000000200ULL, 0x0000002fff48723eULL, 0x000fcc00020006ffULL,
0x0000002c2008723cULL, 0x000fee0000001808ULL, 0x00000010492c7824ULL, 0x000fe200078e0242ULL,
0x0000002fff49723eULL, 0x000fca00030006ffULL, 0x000000002c2c783bULL, 0x000ee40000000200ULL,
0x000000482004723cULL, 0x000fee0000001804ULL, 0x00000030ff20723eULL, 0x082fe400020006ffULL,
0x00000030ff21723eULL, 0x000fc400030006ffULL, 0x00000031ff30723eULL, 0x080fe400020006ffULL,
0x00000031ff31723eULL, 0x000fc600030006ffULL, 0x00000020241c723cULL, 0x044fee000000181cULL,
0x00000032ff20723eULL, 0x080fe200020006ffULL, 0x000000302418723cULL, 0x000fe20000001818ULL,
0x00000032ff21723eULL, 0x000fe400030006ffULL, 0x00000033ff32723eULL, 0x000fc400020006ffULL,
0x00000033ff33723eULL, 0x000fc600030006ffULL, 0x000000202414723cULL, 0x040fee0000001814ULL,
0x0000002cff20723eULL, 0x088fe200020006ffULL, 0x000000322428723cULL, 0x000fe20000001828ULL,
0x0000002cff21723eULL, 0x000fe400030006ffULL, 0x0000002dff2c723eULL, 0x000fc400020006ffULL,
0x0000002dff2d723eULL, 0x000fc600030006ffULL, 0x000000202410723cULL, 0x040fee0000001810ULL,
0x0000002eff20723eULL, 0x080fe200020006ffULL, 0x0000002c240c723cULL, 0x000fe2000000180cULL,
0x0000002eff21723eULL, 0x000fe400030006ffULL, 0x0000002fff2e723eULL, 0x000fc400020006ffULL,
0x0000002fff2f723eULL, 0x000fc600030006ffULL, 0x000000202408723cULL, 0x040ff00000001808ULL,
0x0000002e2404723cULL, 0x000fe20000001804ULL, 0xfffffb0000001947ULL, 0x000fee000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff217224ULL, 0x000fe200078e0039ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffecf000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00f614003a217984ULL, 0x000e620000000800ULL,
0x0000ffff38007812ULL, 0x000fe200078ec0ffULL, 0x0000001935257220ULL, 0x040fe20000410000ULL,
0x0000001435247220ULL, 0x040fe20000410000ULL, 0x0000001c351c7220ULL, 0x040fe20000410000ULL,
0x00008880002f7816ULL, 0x000fe200000000ffULL, 0x0000001e35267220ULL, 0x040fe20000410000ULL,
0x0000001835277220ULL, 0x040fe20000410000ULL, 0x0000001b35197220ULL, 0x040fe20000410000ULL,
0x0000002935147220ULL, 0x000fe20000410000ULL, 0x800000002f007824ULL, 0x000fe200078e00ffULL,
0x0000001035207220ULL, 0x040fe20000410000ULL, 0x0000001d351d7220ULL, 0x040fe20000410000ULL,
0x0000001a35187220ULL, 0x040fe20000410000ULL, 0x0000000c351e7220ULL, 0x040fe20000410000ULL,
0x0000000e35107220ULL, 0x040fe20000410000ULL, 0x0000000f350f7220ULL, 0x040fe20000410000ULL,
0x0000000835087220ULL, 0x040fe20000410000ULL, 0x0000001f352c7220ULL, 0x040fe20000410000ULL,
0x00000016352d7220ULL, 0x040fe20000410000ULL, 0x00000017352e7220ULL, 0x040fe20000410000ULL,
0x0000002a352a7220ULL, 0x040fe20000410000ULL, 0x0000002b352b7220ULL, 0x040fe20000410000ULL,
0x0000000d350d7220ULL, 0x040fe20000410000ULL, 0x0000000a350c7220ULL, 0x040fe20000410000ULL,
0x0000000b350e7220ULL, 0x040fe20000410000ULL, 0x0000002835227220ULL, 0x040fe20000410000ULL,
0x00000011351f7220ULL, 0x040fe20000410000ULL, 0x000000ffff297224ULL, 0x000fe200078e001cULL,
0x0000001535237220ULL, 0x040fe20000410000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0019ULL,
0x0000001335117220ULL, 0x040fe20000410000ULL, 0x00000009351b7220ULL, 0x040fe20000410000ULL,
0x000000ffff287224ULL, 0x000fe200078e001dULL, 0x0000001235127220ULL, 0x040fe20000410000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0008ULL, 0x00000004351a7220ULL, 0x040fe20000410000ULL,
0x000000ffff197224ULL, 0x000fe200078e000fULL, 0x0000000535177220ULL, 0x040fe20000410000ULL,
0x0000000635067220ULL, 0x000fe20000410000ULL, 0x8000000021ff7812ULL, 0x002fe20007804800ULL,
0x000000ffff217224ULL, 0x000fe200078e0014ULL, 0x0000000735077220ULL, 0x000fe20000410000ULL,
0x000000ffff147224ULL, 0x000fc400078e0018ULL, 0x000000ffff1d7224ULL, 0x000fe400078e000dULL,
0x000000ffff167224ULL, 0x000fe400078e0026ULL, 0x000000ffff157224ULL, 0x000fe400078e002cULL,
0x000000ffff0a7224ULL, 0x000fe400078e002dULL, 0x000000ffff097224ULL, 0x000fe400078e002eULL,
0x000000ffff087224ULL, 0x000fc400078e002aULL, 0x000000ffff137224ULL, 0x000fe400078e002bULL,
0x000000ffff187224ULL, 0x000fe400078e000cULL, 0x000000ffff0f7224ULL, 0x000fe200078e000eULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0006ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0007ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000002f2f7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x00f614003a047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fc4000780482fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000437007824ULL, 0x000fe200078e00ffULL,
0x0000003b5200720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff000057812ULL, 0x000fca00078ec0ffULL, 0x00000080500c7824ULL, 0x000fca00078e0205ULL,
0x00f400000c047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000237267824ULL, 0x000fe400078e00ffULL, 0x000000014e3f7824ULL, 0x000fc600078e0a3fULL,
0x0000000626267812ULL, 0x000fc800078ec0ffULL, 0x00000001262a7812ULL, 0x040fe400078efcffULL,
0x00000008262c7812ULL, 0x000fe400078efcffULL, 0x0000003f2a00720cULL, 0x080fe40003f26070ULL,
0x00000010262a7812ULL, 0x000fe400078efcffULL, 0x0000003f2c00720cULL, 0x080fe40003f06070ULL,
0x0000003f2a00720cULL, 0x000fc40003fc6070ULL, 0x00000011262c7812ULL, 0x040fe400078efcffULL,
0x00000018262a7812ULL, 0x040fe400078efcffULL, 0x0000003f2600720cULL, 0x080fe40003f46070ULL,
0x0000003f2c00720cULL, 0x080fe40003fa6070ULL, 0x0000003f2a00720cULL, 0x000fe40003f66070ULL,
0x00000009262e7812ULL, 0x000fc400078efcffULL, 0x00000019262c7812ULL, 0x040fe400078efcffULL,
0x00000020262a7812ULL, 0x000fe400078efcffULL, 0xff7fffff16167808ULL, 0x000fe40005000000ULL,
0xff7fffff29297808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40004800000ULL,
0xff7fffff28287808ULL, 0x000fc40004800000ULL, 0x0000003f2e00720cULL, 0x080fe40003f86070ULL,
0x0000003f2c00720cULL, 0x080fe40003f46070ULL, 0x0000003f2a00720cULL, 0x000fe40003f26070ULL,
0x00000021262c7812ULL, 0x040fe400078efcffULL, 0x00000028262a7812ULL, 0x000fe400078efcffULL,
0xff7fffff14147808ULL, 0x000fc40004000000ULL, 0xff7fffff27277808ULL, 0x000fe40004000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40006000000ULL, 0xff7fffff25257808ULL, 0x000fe40006000000ULL,
0x0000003f2c00720cULL, 0x080fe40003f06070ULL, 0x0000003f2a00720cULL, 0x000fe40003f86070ULL,
0x00000029262c7812ULL, 0x000fc400078efcffULL, 0x00000030262a7812ULL, 0x000fe400078efcffULL,
0xff7fffff0a0a7808ULL, 0x000fe40007000000ULL, 0xff7fffff24247808ULL, 0x000fe40007000000ULL,
0xff7fffff09097808ULL, 0x000fe40006800000ULL, 0xff7fffff23237808ULL, 0x000fe40006800000ULL,
0x0000003f2c00720cULL, 0x000fc40003fc6070ULL, 0x0000003f2a00720cULL, 0x000fe40003fa6070ULL,
0x00000031262c7812ULL, 0x040fe400078efcffULL, 0x00000038262a7812ULL, 0x040fe400078efcffULL,
0x0000003926267812ULL, 0x000fe400078efcffULL, 0xff7fffff08087808ULL, 0x000fe40005800000ULL,
0xff7fffff22227808ULL, 0x000fc40005800000ULL, 0xff7fffff13137808ULL, 0x000fe40005000000ULL,
0xff7fffff21217808ULL, 0x000fe40005000000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0xff7fffff20207808ULL, 0x000fe40004800000ULL, 0x0000003f2c00720cULL, 0x080fe40003f66070ULL,
0x0000003f2a00720cULL, 0x000fc40003f46070ULL, 0x0000003f2600720cULL, 0x000fe40003f26070ULL,
0xff7fffff11117808ULL, 0x000fe40004000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40004000000ULL,
0xff7fffff10107808ULL, 0x000fe40006000000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL,
0xff7fffff19197808ULL, 0x000fc40007000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40007000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40006800000ULL, 0xff7fffff18187808ULL, 0x000fe40006800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40005800000ULL,
0xff7fffff1a1a7808ULL, 0x000fc40005000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40005000000ULL,
0xff7fffff17177808ULL, 0x000fe40004800000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000029042b7209ULL, 0x004fe20007810000ULL,
0x0000001fff307424ULL, 0x000fe200078e00ffULL, 0x0000001605267209ULL, 0x000fe20007810000ULL,
0xffffffffff317424ULL, 0x000fe200078e00ffULL, 0x000000282b047209ULL, 0x000fe40007810000ULL,
0x0000001526057209ULL, 0x000fc40007810000ULL, 0x0000002704047209ULL, 0x000fe40007810000ULL,
0x0000001405267209ULL, 0x000fe40007810000ULL, 0x0000002504057209ULL, 0x000fe40007810000ULL,
0x0000000b262b7209ULL, 0x000fe40007810000ULL, 0x0000002405047209ULL, 0x000fe40007810000ULL,
0x0000000a2b267209ULL, 0x000fc40007810000ULL, 0x0000002304057209ULL, 0x000fe40007810000ULL,
0x00000009262b7209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fe40007810000ULL,
0x000000082b267209ULL, 0x000fe40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x00000013262b7209ULL, 0x000fc40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x000000122b267209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fe40007810000ULL,
0x00000011262b7209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x000000102b267209ULL, 0x000fc40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x00000019262b7209ULL, 0x000fe40007810000ULL, 0x0000001c05047209ULL, 0x000fe40007810000ULL,
0x000000182b267209ULL, 0x000fe40007810000ULL, 0x0000001b04057209ULL, 0x000fe40007810000ULL,
0x0000000f262b7209ULL, 0x000fc40007810000ULL, 0x0000001a05047209ULL, 0x000fe40007810000ULL,
0x0000000e2b267209ULL, 0x000fe40007810000ULL, 0x00000017042c7209ULL, 0x000fe40007810000ULL,
0x0000000d262e7209ULL, 0x000fe20007810000ULL, 0x00000e727f007947ULL, 0x000fea000b800000ULL,
0x0c401f002c047f89ULL, 0x0004e400000e0000ULL, 0x000000042c2f7209ULL, 0x008fe20007810000ULL,
0x00000e927f007947ULL, 0x000fea000b800000ULL, 0x0c401f002e047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007267f89ULL, 0x000e6200000e0000ULL,
0x000000042e2a7209ULL, 0x008fc60007810000ULL, 0x0c201f002f047f89ULL, 0x000ee200000e0000ULL,
0x00000005062b7209ULL, 0x010fc60007810000ULL, 0x0c201f002a057f89ULL, 0x000f2200000e0000ULL,
0x0000002607267209ULL, 0x002fc60007810000ULL, 0x0c201f002b2c7f89ULL, 0x004e6800000e0000ULL,
0x0c201f00262d7f89ULL, 0x0004a200000e0000ULL, 0x000000042f047209ULL, 0x008fe40007810000ULL,
0x000000052a057209ULL, 0x010fe40007810000ULL, 0x0000002c2b067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b042a7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b052f7820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000067886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001082fULL, 0x0000001b002e7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082aULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0b1b7823ULL, 0x108fe2000001082fULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b1e1e7823ULL, 0x000fe2000001082aULL,
0x3fb8aa3b08307823ULL, 0x102fe2000001082fULL, 0x0000002800287308ULL, 0x000e620000000800ULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b0d0d7823ULL, 0x000fc8000001082fULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x00000025002c7308ULL, 0x000ee20000000800ULL,
0x000000292808723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b10297823ULL, 0x000fcc000001082fULL,
0x0000001600167308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ff00000000800ULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000001b000b7308ULL, 0x0003300000000800ULL,
0x0000001a002b7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b121b7823ULL, 0x002fce000001082fULL,
0x00000017002a7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b0a1a7823ULL, 0x104fe2000001082fULL,
0x000000272c0a723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b11277823ULL, 0x000fe2000001082fULL,
0x000000140b0b723eULL, 0x010fc800000000ffULL, 0x0000001d00077308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b09177823ULL, 0x002fe2000001082fULL, 0x000000161509723eULL, 0x000fcc00000000ffULL,
0x0000001c00257308ULL, 0x0003e20000000800ULL, 0x3c003c00ff1d7424ULL, 0x004fce00078e00ffULL,
0x0000001700317308ULL, 0x0005e20000000800ULL, 0x3c003c00ff1c7424ULL, 0x002fce00078e00ffULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x0000001c0814723cULL, 0x004fee00000018ffULL,
0x0000002300237308ULL, 0x000e700000000800ULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000ea20000000800ULL, 0x000000242310723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b18237823ULL, 0x000fcc000001082fULL, 0x0000001a001a7308ULL, 0x000e700000000800ULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x000000222112723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b19217823ULL, 0x000fcc000001082fULL, 0x0000001300137308ULL, 0x000ea20000000800ULL,
0x0000001a3111723eULL, 0x002fce00000000ffULL, 0x0000001b001b7308ULL, 0x000fe20000000800ULL,
0x000000301313723eULL, 0x004fce00000000ffULL, 0x0000002700287308ULL, 0x000e620000000800ULL,
0x0000001c1014723cULL, 0x000fee0000001814ULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000001f001f7308ULL, 0x000ea20000000800ULL, 0x0000001b2819723eULL, 0x002fce00000000ffULL,
0x0000001e001e7308ULL, 0x000e700000000800ULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x000000201f18723eULL, 0x004fce00000000ffULL, 0x0000002100227308ULL, 0x000ea20000000800ULL,
0x0000001e071a723eULL, 0x002fe400000000ffULL, 0xfffffffc37077812ULL, 0x000fca00078ec0ffULL,
0x0000000f00247308ULL, 0x000fe20000000800ULL, 0x00000029221b723eULL, 0x004fce00000000ffULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x0000001c1830723cULL, 0x000fee0000001814ULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000fff147424ULL, 0x000fe200078e00ffULL,
0x0000002b2a16723eULL, 0x000fcc00000000ffULL, 0x0000000d000d7308ULL, 0x000ea20000000800ULL,
0x000000232415723eULL, 0x002fe400000000ffULL, 0x00000007140f7219ULL, 0x000fe400000006ffULL,
0x000000252e14723eULL, 0x000fe400000000ffULL, 0x000000000f1e73a1ULL, 0x000e6200000e8000ULL,
0x000000000f0573c4ULL, 0x000ee20000004000ULL, 0x000000262d077209ULL, 0x000fe40007810000ULL,
0x0000000e0d17723eULL, 0x004fce00000000ffULL, 0x0000001c1420723cULL, 0x000fe20000001830ULL,
0x000000060fff7c12ULL, 0x002fda000f80401eULL, 0x000009d205008947ULL, 0x008ff4000b800000ULL,
0x001c1fff201c7589ULL, 0x0002a400000e0000ULL, 0x000000000f0e73a1ULL, 0x000ee200000e8000ULL,
0x000000000f0573c4ULL, 0x000f220000004000ULL, 0x0000000000067886ULL, 0x000fe400038e0100ULL,
0x000000060fff7c12ULL, 0x008fda000f80400eULL, 0x000009f205008947ULL, 0x010fea000b800000ULL,
0x001c1fff221d7589ULL, 0x00072800000e0000ULL, 0x001c1fff1e1e7589ULL, 0x00066800000e0000ULL,
0x001c1fff001f7589ULL, 0x0006a400000e0000ULL, 0x00000002ff0d7819ULL, 0x000fe40000011637ULL,
0x0000000c00337812ULL, 0x002fc400078ec0ffULL, 0x000000070d0e7812ULL, 0x040fe200078ec0ffULL,
0x000000080d237824ULL, 0x040fe200078e00ffULL, 0x0000000dff217212ULL, 0x000fe200078e33ffULL,
0x000000080d0f7824ULL, 0x008fe200078e00ffULL, 0x0000000337ff7812ULL, 0x000fe2000780c0ffULL,
0x000000080d2e7824ULL, 0x040fe200078e00ffULL, 0x000000080d0d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823207812ULL, 0x100fe400078ee20eULL, 0x000000010f227812ULL, 0x100fe200078ef60eULL,
0x000000080d467824ULL, 0x000fe200078e00ffULL, 0x000000020f247812ULL, 0x100fe200078ef60eULL,
0x000000080d237824ULL, 0x000fe200078e00ffULL, 0x000000030f267812ULL, 0x000fc400078ef60eULL,
0x000000040f287812ULL, 0x140fe400078ef60eULL, 0x000000050f2a7812ULL, 0x140fe400078ef60eULL,
0x000000060f2c7812ULL, 0x000fe200078ef60eULL, 0x000000080d0f7824ULL, 0x040fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe400078ee221ULL, 0x0000000dff217212ULL, 0x000fe400078e33ffULL,
0x000000070d0e7812ULL, 0x000fc400078ec0ffULL, 0x00009000500d7811ULL, 0x000fe400078e58ffULL,
0xfffffff823307812ULL, 0x100fe400078ee20eULL, 0x000000010f327812ULL, 0x140fe200078ef60eULL,
0x0000001020007824ULL, 0x000fe200078e020dULL, 0xfffffff846467812ULL, 0x000fe200078ee221ULL,
0x0000001024207824ULL, 0x100fe200078e020dULL, 0x000000020f3c7812ULL, 0x140fe200078ef60eULL,
0x0000001028247824ULL, 0x100fe200078e020dULL, 0x000000030f3e7812ULL, 0x140fe200078ef60eULL,
0x000000102c287824ULL, 0x100fe200078e020dULL, 0x000000040f407812ULL, 0x140fe200078ef60eULL,
0x00000010322c7824ULL, 0x100fe200078e020dULL, 0x000000050f427812ULL, 0x140fe200078ef60eULL,
0x000000103c2d7824ULL, 0x100fe200078e020dULL, 0x000000060f447812ULL, 0x000fe200078ef60eULL,
0x00000010220e7824ULL, 0x000fc400078e020dULL, 0x0000001026227824ULL, 0x100fe400078e020dULL,
0x000000102a267824ULL, 0x100fe400078e020dULL, 0x00000001330f7824ULL, 0x000fe400078e0200ULL,
0x000000102e2a7824ULL, 0x100fe400078e020dULL, 0x0000001030007824ULL, 0x100fe200078e020dULL,
0x000000080f007388ULL, 0x0003e20000000800ULL, 0x000000103e2e7824ULL, 0x000fc400078e020dULL,
0x00000010402f7824ULL, 0x100fe400078e020dULL, 0x0000001042307824ULL, 0x100fe400078e020dULL,
0x0000001044317824ULL, 0x100fe400078e020dULL, 0x0000001046327824ULL, 0x000fe400078e020dULL,
0x00000001330d7824ULL, 0x040fe400078e020eULL, 0x0000000133217824ULL, 0x000fc400078e0220ULL,
0x0000000133237824ULL, 0x040fe200078e0222ULL, 0x0000000a0d007388ULL, 0x0007e20000000800ULL,
0x0000000133257824ULL, 0x040fe400078e0224ULL, 0x0000000133277824ULL, 0x040fe200078e0226ULL,
0x0000001021007388ULL, 0x0007e20000000800ULL, 0x0000000133297824ULL, 0x040fe400078e0228ULL,
0x00000001332b7824ULL, 0x040fe200078e022aULL, 0x0000001223007388ULL, 0x0007e20000000800ULL,
0x0000000133007824ULL, 0x000fc400078e0200ULL, 0x00000001332c7824ULL, 0x040fe200078e022cULL,
0x0000001825007388ULL, 0x0007e20000000800ULL, 0x00000001330e7824ULL, 0x040fe400078e022dULL,
0x00000001332e7824ULL, 0x040fe200078e022eULL, 0x0000001a27007388ULL, 0x0007e20000000800ULL,
0x0000000133087824ULL, 0x042fe400078e022fULL, 0x0000000133307824ULL, 0x040fe200078e0230ULL,
0x0000001429007388ULL, 0x0007e20000000800ULL, 0x0000000133207824ULL, 0x000fc400078e0231ULL,
0x0000000133327824ULL, 0x000fe200078e0232ULL, 0x000000162b007388ULL, 0x0007e80000000800ULL,
0x0000000900007388ULL, 0x0007e80000000800ULL, 0x0000000b2c007388ULL, 0x0007e80000000800ULL,
0x000000110e007388ULL, 0x0007e80000000800ULL, 0x000000132e007388ULL, 0x0007e80000000800ULL,
0x0000001908007388ULL, 0x0007e80000000800ULL, 0x0000001b30007388ULL, 0x0007e80000000800ULL,
0x0000001520007388ULL, 0x0007e80000000800ULL, 0x0000001732007388ULL, 0x0007e80000000800ULL,
0x00f000040c008388ULL, 0x0007e80000000c00ULL, 0x00f2001c0c008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030052527a10ULL, 0x000fe20007ffe0ffULL,
0x00f608003aff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff38ff7812ULL, 0x000fc4000780c0ffULL,
0x0000004d5200720cULL, 0x000fe40003f26070ULL, 0x00000001ff387807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffd2f000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff327224ULL, 0x000fe200078e002cULL,
0x0000df20002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fe400078e00ffULL, 0x0000068000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2f7224ULL, 0x004fe200078e0030ULL, 0xffffada000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x002fe200078e002bULL, 0x0000df90002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fe400078e00ffULL,
0x0000061000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff2c7224ULL, 0x004fe200078e0030ULL,
0xffffad5000007947ULL, 0x000fea000383ffffULL, 0x00000002ff2d7424ULL, 0x000fe200078e00ffULL,
0x0000dfe0002a7802ULL, 0x000fc40000000f00ULL, 0x0000058000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e002dULL, 0xfffff15000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2c7224ULL, 0x006fe200078e002eULL, 0x0000e040002a7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2d7424ULL, 0x000fc400078e00ffULL, 0x0000052000007944ULL, 0x020fea0003c00000ULL,
0x0000002d2e2e7209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x002fe200078e0006ULL,
0x0000e090002a7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2d7424ULL, 0x000fc400078e00ffULL,
0x000004d000007944ULL, 0x000fea0003c00000ULL, 0x0000002d06067209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x002fe200078e0007ULL, 0x0000e0e0002a7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2d7424ULL, 0x000fc400078e00ffULL, 0x0000048000007944ULL, 0x000fea0003c00000ULL,
0x0000002d07267209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x002fe200078e002fULL,
0x0000e130002a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2d7424ULL, 0x000fc400078e00ffULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x0000002d2f047209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x002fe200078e002eULL, 0x0000e180002a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2d7424ULL, 0x000fc400078e00ffULL, 0x000003e000007944ULL, 0x000fea0003c00000ULL,
0x0000002d2e057209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x002fe200078e0006ULL,
0x0000e1d0002a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2d7424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x0000002d06067209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x002fe200078e0026ULL, 0x0000e220002a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2d7424ULL, 0x000fc400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0xfffff01000007947ULL, 0x000fea000383ffffULL, 0x000000ffff317224ULL, 0x000fe200078e0020ULL,
0x0000e290002c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff327224ULL, 0x000fc400078e00ffULL,
0x00001c1fff337424ULL, 0x000fe400078e00ffULL, 0x000000ffff3c7224ULL, 0x000fe400078e000fULL,
0x0000031000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e0030ULL,
0xfffff5c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff317224ULL, 0x002fe200078e0022ULL,
0x0000e310002c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff327224ULL, 0x000fe400078e00ffULL,
0x00001c1fff337424ULL, 0x000fe400078e00ffULL, 0x000000ffff3c7224ULL, 0x000fe400078e000fULL,
0x0000029000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff327224ULL, 0x002fe200078e00ffULL,
0x0000e370002c7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff337424ULL, 0x000fc400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fe400078e000fULL, 0x000000ffff1d7224ULL, 0x004fe400078e0030ULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff3c7224ULL, 0x002fe200078e000fULL,
0x0000e3d0002c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff327224ULL, 0x000fe400078e00ffULL,
0x00001c1fff337424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x004fe400078e0030ULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x004fe200078e0030ULL,
0xfffff50000007947ULL, 0x000fea000383ffffULL, 0x0180000007007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000097812ULL, 0x000fc800078ec0ffULL,
0x018000000900780cULL, 0x000fda0003f05070ULL, 0x0000000700008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0900720cULL, 0x040fe40003f25070ULL,
0x008000000900780cULL, 0x000fe40003f02070ULL, 0x00000001ff097807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000009ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000007077812ULL, 0x002fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000009ff7212ULL, 0x000fda000780c0ffULL, 0x0080000007000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0007ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xffff1aa008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2b7424ULL, 0x000fe200078e00ffULL, 0x0000003100007348ULL, 0x000fe80003800000ULL,
0x0c00002d2c2d7389ULL, 0x0002a200000e0030ULL, 0xffff1a602a007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2d7424ULL, 0x000fe200078e00ffULL, 0x0000003c00007348ULL, 0x000fe80003800000ULL,
0x0000003231307389ULL, 0x0002a200000e0033ULL, 0xffff1a202c007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000778ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007f0ULL, 0x00000000000006acULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e9cULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ec0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ed0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ef0ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f60ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f68ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000f78ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x000000000000e680ULL, 0x7600001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000000f800ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x000000000000f810ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000000f810ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000000fc90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f60ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000e8a0ULL, 0x000000000000e8a0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000000f800ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000000fc90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_16_m_16_sm_89_cubin_len = 64880;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
