/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000018a38ULL, 0x00000000000186b8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x346a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4532336a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL,
0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL, 0x45316a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x324545386a4c4532ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x0000000000000067ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x656b240061686d5fULL,
0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x65642e0066754265ULL, 0x6d6172665f677562ULL,
0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL, 0x665f67756265642eULL,
0x766e2e00656d6172ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x00000061686d5f6cULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000001beULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000b000100000204ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b00010000024bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000291ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000002dfULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000032dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000b00010000037bULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000003c9ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a002200000424ULL, 0x0000000000017050ULL, 0x0000000000000230ULL,
0x000400030000049aULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL,
0x0000000000000000ULL, 0x0000000000017280ULL, 0x000d0003000004caULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001705000000000ULL, 0x0001380400000000ULL,
0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL,
0x0001705000000000ULL, 0x0000023000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000001500082f04ULL, 0x00082304000000c9ULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001500082304ULL,
0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL, 0x0004370400000000ULL,
0x000c17040000007bULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL, 0x0058000900000000ULL,
0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL,
0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0xffffffff00dc2904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000020000dc2804ULL,
0x000009f000000360ULL, 0x00002f2000002eb0ULL, 0x0000313000003000ULL, 0x000033a000003260ULL,
0x0000393000003920ULL, 0x0000395000003940ULL, 0x00005750000056c0ULL, 0x0000596000005830ULL,
0x00005bd000005a90ULL, 0x0000607000006060ULL, 0x0000609000006080ULL, 0x00007dd000007d40ULL,
0x00007fe000007eb0ULL, 0x0000825000008110ULL, 0x0000869000008680ULL, 0x000086b0000086a0ULL,
0x0000a3f00000a380ULL, 0x0000a6100000a4e0ULL, 0x0000a8800000a740ULL, 0x0000ad900000ad80ULL,
0x0000adb00000ada0ULL, 0x0000c0300000c020ULL, 0x0000c0500000c040ULL, 0x0001591000015860ULL,
0x00015cf000015bf0ULL, 0x000161d0000160e0ULL, 0x00016530000164a0ULL, 0x0000053004303904ULL,
0x0001a600000000ffULL, 0x0000061000040100ULL, 0x0001a60800000008ULL, 0x00000720003f0100ULL,
0x0001a68800000008ULL, 0x00000860003f0100ULL, 0x0001a6a800000002ULL, 0x00000960003f0100ULL,
0x0001a6c800000004ULL, 0x000013d0003f0100ULL, 0x0001a60000000008ULL, 0x00001560003f0107ULL,
0x0001a68800000003ULL, 0x00001ef0003f0101ULL, 0x00000000000000ffULL, 0x00001f7000040107ULL,
0x00000000000000ffULL, 0x00001ff000040101ULL, 0x0000002000000002ULL, 0x00002100003f0101ULL,
0x0001a6c800000038ULL, 0x00002280003f0109ULL, 0x0001a6c800000038ULL, 0x00002bd0003f0109ULL,
0x0001a6b00000003aULL, 0x00002c20003f0107ULL, 0x0001a6b00000003aULL, 0x00002c30003f0101ULL,
0x0001a60800000080ULL, 0x00002c50003f0101ULL, 0x0001a60800000080ULL, 0x00002dc0003f0109ULL,
0x0001a60800000080ULL, 0x00003530003f0109ULL, 0x0001a6a80000003aULL, 0x000036c0003f0109ULL,
0x0001a6a80000003aULL, 0x00004a90003f0109ULL, 0x0001a6c800000034ULL, 0x00004ab0003f0101ULL,
0x0001a6880000007dULL, 0x00004b20003f0101ULL, 0x0000000000000006ULL, 0x00004c90003f0109ULL,
0x0000000000000006ULL, 0x00005440003f0109ULL, 0x00000000000000ffULL, 0x0000548000050107ULL,
0x00000000000000ffULL, 0x0000549000050101ULL, 0x0001a62800000080ULL, 0x000054b0003f0101ULL,
0x0001a62800000080ULL, 0x00005620003f0109ULL, 0x0001a62800000080ULL, 0x00005db0003f0109ULL,
0x0001a6b000000037ULL, 0x00005f20003f0109ULL, 0x0001a6b000000037ULL, 0x000070c0003f0109ULL,
0x0001a6c800000034ULL, 0x000070f0003f0101ULL, 0x0001a69000000036ULL, 0x00007140003f0101ULL,
0x0000000000000006ULL, 0x000072b0003f0109ULL, 0x0000000000000006ULL, 0x00007a40003f0109ULL,
0x00000008000000ffULL, 0x00007b0000040107ULL, 0x0000000800000086ULL, 0x00007b10003f0101ULL,
0x0001a64800000080ULL, 0x00007b30003f0101ULL, 0x0001a64800000080ULL, 0x00007ca0003f0109ULL,
0x0001a64800000080ULL, 0x00008400003f0109ULL, 0x00000000000000ffULL, 0x0000857000050109ULL,
0x00000000000000ffULL, 0x000096c000050109ULL, 0x0000000000000006ULL, 0x000096f0003f0101ULL,
0x0001a69800000036ULL, 0x00009750003f0101ULL, 0x0000000000000006ULL, 0x000098c0003f0109ULL,
0x0000000000000006ULL, 0x0000a0b0003f0109ULL, 0x00000000000000ffULL, 0x0000a14000040107ULL,
0x00000000000000ffULL, 0x0000a15000050101ULL, 0x0001a66800000037ULL, 0x0000a170003f0101ULL,
0x0001a66800000037ULL, 0x0000a2e0003f0109ULL, 0x0001a66800000037ULL, 0x0000aa50003f0109ULL,
0x0001a6b000000037ULL, 0x0000abc0003f0109ULL, 0x0001a6b000000037ULL, 0x0000bdc0003f0109ULL,
0x0000000000000006ULL, 0x0000be30003f0101ULL, 0x0001a6a000000006ULL, 0x0000e070003f0101ULL,
0x0001a60000000008ULL, 0x0000f9c0003f0101ULL, 0x0001a60000000008ULL, 0x0000fb80003f0109ULL,
0x0001a60000000008ULL, 0x0000fed0003f0109ULL, 0x0001a60000000008ULL, 0x0000fef0003f0101ULL,
0x0001a60000000008ULL, 0x00010060003f0109ULL, 0x0001a60000000008ULL, 0x00012ed0003f0109ULL,
0x0001a68800000051ULL, 0x000132a0003f0101ULL, 0x0001a68800000051ULL, 0x00013410003f0109ULL,
0x0001a68800000051ULL, 0x00016ff0003f0109ULL, 0x0001a60800000078ULL, 0x00017000003f0101ULL,
0x0001a61000000078ULL, 0x00017010003f0101ULL, 0x0001a61800000078ULL, 0x00017020003f0101ULL,
0x0001a62000000078ULL, 0x00053803003f0101ULL, 0x0000cf6000301c04ULL, 0x0000d2500000cf90ULL,
0x0000d6300000d440ULL, 0x0000da100000d820ULL, 0x0000de000000dc00ULL, 0x000100900000dfb0ULL,
0x000c050400017040ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0068190300000000ULL,
0x0000001600080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL, 0x0000001500000002ULL,
0x0000000000017050ULL, 0x0000000000000044ULL, 0x0000001500000002ULL, 0x0000000000000000ULL,
0x0000000000000098ULL, 0x0000001500000002ULL, 0x0000000000000000ULL, 0x000000000001a700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x00000000007a7919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fcc0000000a00ULL,
0x00008500ff007b82ULL, 0x000f220000000800ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff022b82ULL, 0x000ea20000000a00ULL,
0x000000017a052836ULL, 0x008fe40000000000ULL, 0x000000047a062825ULL, 0x004fc800078e0002ULL,
0x0000000405022825ULL, 0x000fe400078e0002ULL, 0x0000000606062981ULL, 0x000ea8000c1e1900ULL,
0x0000000602092981ULL, 0x0006a2000c1e1900ULL, 0x0000000000087306ULL, 0x010f220000209000ULL,
0x00000400ff0a7b82ULL, 0x000f620000000800ULL, 0x000000ff0000720cULL, 0x000fe20003f65070ULL,
0x0000000000767919ULL, 0x000ee20000002600ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x00000000000e7919ULL, 0x000ee40000002300ULL,
0x0000000800087308ULL, 0x010f240000001000ULL, 0x0ffffffe08047836ULL, 0x010fc40000000000ULL,
0x0000000000087919ULL, 0x000f280000002100ULL, 0x0000000400057305ULL, 0x000764000021f000ULL,
0x000000ffff047224ULL, 0x00afe400078e00ffULL, 0x000000ffff0b7224ULL, 0x020fc800078e0a05ULL,
0x000000000b0b7224ULL, 0x000fc800078e02ffULL, 0x0000000b05057227ULL, 0x000fe400078e0004ULL,
0x00000000000b7919ULL, 0x000e680000002200ULL, 0x0000000a05057227ULL, 0x000fe200078e00ffULL,
0x00000005ff777819ULL, 0x010fc60000011608ULL, 0x000000ffff037224ULL, 0x000fc600078e0a05ULL,
0x00001fff77777589ULL, 0x000f2200000e0000ULL, 0x0000000300037224ULL, 0x000fca00078e020aULL,
0x000000000300720cULL, 0x000fda0003f06070ULL, 0x0000000103030824ULL, 0x000fe400078e0a00ULL,
0x0000000105050836ULL, 0x000fc60000000000ULL, 0x000000000300720cULL, 0x000fda0003f26070ULL,
0x0000000105051836ULL, 0x000fe20000000000ULL, 0x00000000ff05b212ULL, 0x000fc800078e33ffULL,
0x0000000500047306ULL, 0x000ee20000209000ULL, 0x000000ff0500720cULL, 0x000fce0003f65070ULL,
0x0000000400047308ULL, 0x008ee40000001000ULL, 0x0ffffffe04027836ULL, 0x008fcc0000000000ULL,
0x0000000200037305ULL, 0x000764000021f000ULL, 0x000000ffff027224ULL, 0x008fe400078e00ffULL,
0x0000000305077224ULL, 0x020fc800078e02ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a07ULL,
0x0000000703037227ULL, 0x000fe400078e0002ULL, 0x00008400ff07ab82ULL, 0x000f280000000800ULL,
0x0000007603797227ULL, 0x000fc800078e00ffULL, 0x000000040e037c24ULL, 0x002fe2000f8e020bULL,
0x0000000000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff027224ULL, 0x000fe200078e0a79ULL,
0x00001fff0e0e7589ULL, 0x000f2200000e0000ULL, 0x0000000403047c24ULL, 0x000fe4000f8e0208ULL,
0x0000000205027224ULL, 0x000fc600078e0276ULL, 0x0000007f0400780cULL, 0x000fe40003fa4070ULL,
0x000000050200720cULL, 0x000fe40003f06070ULL, 0x000000030400780cULL, 0x000fd20003f84070ULL,
0x00000000000ad919ULL, 0x000e640000008800ULL, 0x0000000102020824ULL, 0x000fe400078e0a05ULL,
0x0000000179790836ULL, 0x000fe20000000000ULL, 0x000000ff0400720cULL, 0x000fe40003f05270ULL,
0x000000050200720cULL, 0x000fda0003f26070ULL, 0x0000000179791836ULL, 0x000fe20000000000ULL,
0x00000005ff79b212ULL, 0x000fe400078e33ffULL, 0x0000000f0400780cULL, 0x040fe40003f24070ULL,
0x000000010400780cULL, 0x000fe20003f64070ULL, 0x000000ffff027224ULL, 0x000fc800078e0a79ULL,
0x0000000205767224ULL, 0x000fe400078e0276ULL, 0xff317217ff05d424ULL, 0x000fe400078e00ffULL,
0x0000000109032824ULL, 0x004fe200078e0a06ULL, 0x000004000009d802ULL, 0x000fc80000000f00ULL,
0x000006540a09d816ULL, 0x002fe20000000009ULL, 0x00008400ff03ab82ULL, 0x000ee80000000800ULL,
0x000000040402d824ULL, 0x000fe200078e0209ULL, 0x0000000000240947ULL, 0x010fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01a60008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404087c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000080812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a60804083f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404087c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000080812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a68804083f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01a400050200d388ULL, 0x0003e20000000800ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000002076767824ULL, 0x000fc600078e00ffULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000404027c11ULL, 0x002fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6a804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000040912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6c804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000803057c24ULL, 0x00afe2000f8e02ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff027224ULL, 0x000fe200078e0a76ULL, 0x000000760500720cULL, 0x000fe20003f06070ULL,
0x000000077a06a224ULL, 0x000fc400078e02ffULL, 0x0000000800157c24ULL, 0x000fe2000f8e02ffULL,
0x00000020050b7446ULL, 0x000fe20003800002ULL, 0x000000040e027824ULL, 0x000fe400078e0277ULL,
0x00000015060a7224ULL, 0x000fe200078e02ffULL, 0x000000ff0b0b7207ULL, 0x000fe20000000000ULL,
0x0000000402027824ULL, 0x000fe400078e00ffULL, 0x0000000879197c24ULL, 0x000fe2000f8e020aULL,
0x000000200b00780cULL, 0x000fda0003f05270ULL, 0x00000004002c8947ULL, 0x000fea0003800000ULL,
0x0000000800087d06ULL, 0x000e620008209000ULL, 0x0000000000097919ULL, 0x000ea20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00008c0000047ab9ULL, 0x000fca0000000a00ULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe08057836ULL, 0x002fe20000000000ULL,
0x00000004ff077819ULL, 0x004fca0000011609ULL, 0x0000000500057305ULL, 0x000e62000021f000ULL,
0x0000000207107836ULL, 0x000fe40000000000ULL, 0x00000001020f7824ULL, 0x040fe400078e0207ULL,
0x0000000102117824ULL, 0x000fc800078e0210ULL, 0x0000000176127824ULL, 0x000fe400078e0211ULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a05ULL, 0x000000080d0d7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000d050d7227ULL, 0x000fc800078e0004ULL, 0x0000000176047824ULL, 0x000fc800078e020fULL,
0x000000040d057227ULL, 0x000fc800078e00ffULL, 0x000000120d0d7227ULL, 0x000fc800078e00ffULL,
0x000000ffff137224ULL, 0x000fe400078e0a05ULL, 0x000000ffff177224ULL, 0x000fe400078e0a0dULL,
0x0000000813087c24ULL, 0x000fe4000f8e0204ULL, 0x00000008170c7c24ULL, 0x000fe4000f8e0212ULL,
0x0000000000177919ULL, 0x000e620000008800ULL, 0x0000000808007c0cULL, 0x000fe4000bf06070ULL,
0x000000080c007c0cULL, 0x000fd6000bf46070ULL, 0x8000000808080c36ULL, 0x000fe40008000000ULL,
0x800000080c0c2c36ULL, 0x000fe40008000000ULL, 0x0000000105050836ULL, 0x000fe20000000000ULL,
0x0000000808007c0cULL, 0x000fe2000bf26070ULL, 0x000000010d0d2836ULL, 0x000fe20000000000ULL,
0x000000080c007c0cULL, 0x000fe4000bf66070ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x00000008ff087c12ULL, 0x000fce000f8e33ffULL, 0x0000000105051836ULL, 0x000fe40000000000ULL,
0x000000010d0d3836ULL, 0x000fc60000000000ULL, 0x00000005080c7207ULL, 0x040fe40004000000ULL,
0x0000000d08137207ULL, 0x000fe40004000000ULL, 0x0000040000087802ULL, 0x000fe20000000f00ULL,
0x000000ffff057224ULL, 0x000fe400078e0a0cULL, 0x000000ffff0d7224ULL, 0x000fe200078e0a13ULL,
0x0000065417087816ULL, 0x002fe20000000008ULL, 0x0000000805047c24ULL, 0x000fe2000f8e0204ULL,
0x000000020b057248ULL, 0x000fe20007fe0000ULL, 0x000000080d127c24ULL, 0x000fc4000f8e0212ULL,
0x00000001190d7824ULL, 0x040fe400078e0204ULL, 0x0000000119127824ULL, 0x000fe400078e0212ULL,
0x0000000105057824ULL, 0x000fe400078e0a02ULL, 0x000000150c047224ULL, 0x000fe400078e020dULL,
0x0000001009027824ULL, 0x000fe200078e00ffULL, 0x000000050700720cULL, 0x000fe20003f06070ULL,
0x00000015130c7224ULL, 0x000fe200078e0212ULL, 0x000000051000720cULL, 0x000fe20003f26070ULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x000000f002077812ULL, 0x000fc600078ec0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000704047212ULL, 0x000fc600078efcffULL,
0x000000010f107824ULL, 0x140fe200078e0209ULL, 0x000000070c0c7212ULL, 0x000fe200078efcffULL,
0x000000100f137824ULL, 0x000fe200078e00ffULL, 0x0000000404047c10ULL, 0x000fe2000ff5e0ffULL,
0x00000001110f7824ULL, 0x040fe200078e0209ULL, 0x000000040c0c7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001011127824ULL, 0x000fe200078e00ffULL, 0xfffffff013077812ULL, 0x000fe400078ee210ULL,
0x0000000505057c10ULL, 0x000fe400097fe4ffULL, 0xfffffff0120f7812ULL, 0x000fe200078ee20fULL,
0x0000001007077824ULL, 0x000fe200078e0208ULL, 0x000000050d0d7c10ULL, 0x000fc60009ffe4ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e8000c101c46ULL, 0x000000000c0f7faeULL, 0x0003e2000c901c46ULL,
0x0000000400107947ULL, 0x000fea0003800000ULL, 0x0000000800087d06ULL, 0x000e620008209000ULL,
0x0000000000097919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000000000f7919ULL, 0x000ee80000008800ULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe08057836ULL, 0x002fe20000000000ULL,
0x0000000209077211ULL, 0x004fca00078fe0ffULL, 0x0000000500057305ULL, 0x000e62000021f000ULL,
0x0000000207107836ULL, 0x000fe40000000000ULL, 0x0000000176027824ULL, 0x040fe400078e0207ULL,
0x0000000176087824ULL, 0x000fe400078e0210ULL, 0x0000001007127824ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a05ULL, 0x000000080d0d7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000d050d7227ULL, 0x000fcc00078e0004ULL, 0x000000020d047227ULL, 0x000fc800078e00ffULL,
0x000000080d0c7227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a0cULL, 0x0000000805057c24ULL, 0x000fe4000f8e0202ULL,
0x000000080d0d7c24ULL, 0x000fc6000f8e0208ULL, 0x0000000805007c0cULL, 0x000fe4000bf06070ULL,
0x000000080d007c0cULL, 0x000fd6000bf46070ULL, 0x8000000805050c36ULL, 0x000fe40008000000ULL,
0x800000080d0d2c36ULL, 0x000fe40008000000ULL, 0x0000000104040836ULL, 0x000fe20000000000ULL,
0x0000000805007c0cULL, 0x000fe2000bf26070ULL, 0x000000010c0c2836ULL, 0x000fe20000000000ULL,
0x000000080d007c0cULL, 0x000fe4000bf66070ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x00000008ff057c12ULL, 0x000fce000f8e33ffULL, 0x0000000104041836ULL, 0x000fe40000000000ULL,
0x000000010c0c3836ULL, 0x000fc60000000000ULL, 0x0000000405047207ULL, 0x040fe40004000000ULL,
0x0000000c050c7207ULL, 0x000fc60004000000ULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a0cULL, 0x0000000805027c24ULL, 0x000fe4000f8e0202ULL,
0x000000080d087c24ULL, 0x000fe4000f8e0208ULL, 0x0000000119057824ULL, 0x040fe400078e0202ULL,
0x00000001190d7824ULL, 0x000fe200078e0208ULL, 0x0000040000087802ULL, 0x000fe20000000f00ULL,
0x0000001009027824ULL, 0x000fc400078e00ffULL, 0x0000001504057224ULL, 0x080fe200078e0205ULL,
0x000006540f087816ULL, 0x008fe20000000008ULL, 0x000000150c0d7224ULL, 0x000fe200078e020dULL,
0x000000f002117812ULL, 0x000fe200078ec0ffULL, 0x0000010005047825ULL, 0x000fc800078e00ffULL,
0x000001000d0c7825ULL, 0x000fe200078e00ffULL, 0x0000001104047212ULL, 0x000fc600078efcffULL,
0x00000001070f7824ULL, 0x100fe200078e0209ULL, 0x000000110c0c7212ULL, 0x000fe200078efcffULL,
0x0000000110077824ULL, 0x040fe200078e0209ULL, 0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001010107824ULL, 0x000fe200078e00ffULL, 0xfffffff0120f7812ULL, 0x000fe400078ee20fULL,
0x000000040c0c7c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff010077812ULL, 0x000fe200078ee207ULL,
0x000000100f0f7824ULL, 0x000fe200078e0208ULL, 0x0000000505057c10ULL, 0x000fc400087fe4ffULL,
0x000000050d0d7c10ULL, 0x000fe20008ffe4ffULL, 0x0000001007077824ULL, 0x000fe400078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e8000b901c46ULL,
0x000000000c077faeULL, 0x0003e4000b901c46ULL, 0x00000000080472caULL, 0x000fe200000e0000ULL,
0x00009400ff047b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0001a60004047890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x000000047a047825ULL, 0x002fe200078e0004ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0000000604747981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0e00720cULL, 0x000fe20003f05270ULL, 0x0000007f74757836ULL, 0x004fe40000000000ULL,
0x000000ff740c7836ULL, 0x000fc60000000000ULL, 0x00000007ff757819ULL, 0x000fe40000011675ULL,
0x00000008ff627819ULL, 0x000fca000001160cULL, 0x000000c800c88947ULL, 0x000fea0003800000ULL,
0x00000003ff607819ULL, 0x000fe20000011677ULL, 0xffffffffff817424ULL, 0x000fc600078e00ffULL,
0x01ffffff60607812ULL, 0x000fc800078ec0ffULL, 0x000000756000720cULL, 0x000fda0003f06070ULL,
0x00009600ff048b82ULL, 0x000e620000000800ULL, 0x000000027a038824ULL, 0x000fce00078e00ffULL,
0x00009200ff068b82ULL, 0x000ea20000000a00ULL, 0x0000000403038224ULL, 0x002fe400078e0204ULL,
0x00000004ff047424ULL, 0x000fe400078e00ffULL, 0x0000000160058824ULL, 0x000fe400078e0203ULL,
0x0000000877037824ULL, 0x000fe400078e0208ULL, 0x0000000405068825ULL, 0x004fe400078e0006ULL,
0x01a6880403ff79a7ULL, 0x0003e6000850003fULL, 0x0000000606818981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0c00780cULL, 0x000fe20003f04070ULL, 0x00000080795a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff637819ULL, 0x000fca0000011677ULL, 0x0000002063617824ULL, 0x000fe200078e00ffULL,
0x00009000ff047b82ULL, 0x002e620000000a00ULL, 0x0000000081007224ULL, 0x004fc800078e02ffULL,
0x0000008000037824ULL, 0x000fe200078e00ffULL, 0x000000605a007812ULL, 0x000fc600078ef861ULL,
0x0000008003047825ULL, 0x002fe200078e0004ULL, 0x0000000177037812ULL, 0x000fe200078ec0ffULL,
0x0000000000fc0947ULL, 0x000fec0003800000ULL, 0x0000006174067248ULL, 0x000fe20007fe0000ULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0x00000003ff077819ULL, 0x000fc60000011609ULL,
0x0000000106067824ULL, 0x000fe400078e0a61ULL, 0x00000001030c7824ULL, 0x000fe400078e0207ULL,
0x00000004070e7836ULL, 0x000fe20000000000ULL, 0x0000000306067248ULL, 0x000fe20007fe0000ULL,
0x000000010c0d7824ULL, 0x040fe400078e0209ULL, 0x000000080c127824ULL, 0x000fe400078e00ffULL,
0x0000000106067824ULL, 0x000fc400078e0a03ULL, 0x0000000c070f7836ULL, 0x000fe20000000000ULL,
0xfffffff812127812ULL, 0x000fe200078ee20dULL, 0x00000008070d7836ULL, 0x000fe20000000000ULL,
0x000000060e00720cULL, 0x080fe20003f46070ULL, 0x00000001030e7824ULL, 0x000fe200078e020eULL,
0x000000060700720cULL, 0x080fe20003f66070ULL, 0x0000000100077824ULL, 0x000fe200078e020cULL,
0x000000060d00720cULL, 0x080fe20003f26070ULL, 0x000000010e0c7824ULL, 0x040fe200078e0209ULL,
0x000000060f00720cULL, 0x000fe20003f06070ULL, 0x000000080e117824ULL, 0x000fc400078e00ffULL,
0x0000008007067825ULL, 0x000fc600078e00ffULL, 0xfffffff811147812ULL, 0x000fe200078ee20cULL,
0x00000001030d7824ULL, 0x040fe200078e020dULL, 0x0000007006117812ULL, 0x000fe200078ef802ULL,
0x0000000103107824ULL, 0x000fe400078e020fULL, 0x00000001000c7824ULL, 0x040fe400078e020dULL,
0x000000010d037824ULL, 0x040fe400078e0209ULL, 0x000000080d167824ULL, 0x000fe400078e00ffULL,
0x00000001000f7824ULL, 0x000fc400078e0210ULL, 0x0000000110067824ULL, 0x040fe200078e0209ULL,
0xfffffff816167812ULL, 0x000fe200078ee203ULL, 0x00000008100d7824ULL, 0x000fe200078e00ffULL,
0x0000001104107210ULL, 0x000fe20007f9e0ffULL, 0x00000001000e7824ULL, 0x000fe400078e020eULL,
0x0000200063007824ULL, 0x000fe200078e0208ULL, 0xfffffff80d187812ULL, 0x000fe200078ee206ULL,
0x0000000105117824ULL, 0x000fe400020e0607ULL, 0x000000800e067825ULL, 0x000fc800078e00ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x00000070061d7812ULL, 0x000fc600078ef802ULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c1b7812ULL, 0x000fc600078ef802ULL,
0x0001600000037836ULL, 0x000fe20000000000ULL, 0x000000700e197812ULL, 0x000fe400078ef802ULL,
0x0000001d04027210ULL, 0x000fe20007f9e0ffULL, 0x0000001012137824ULL, 0x100fe200078e0203ULL,
0x0000001b04067210ULL, 0x000fe20007fbe0ffULL, 0x0000001014157824ULL, 0x100fe200078e0203ULL,
0x0000001904047210ULL, 0x000fe20007fde0ffULL, 0x0000001016177824ULL, 0x100fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000d901c46ULL,
0x0000001018197824ULL, 0x000fc400078e0203ULL, 0x0000000105037824ULL, 0x040fe400020e0607ULL,
0x0000000105077824ULL, 0x040fe400028e060dULL, 0x0000000105057824ULL, 0x000fe200030e060fULL,
0x0000000002157faeULL, 0x0003e8000d101c46ULL, 0x0000000006177faeULL, 0x0003e8000c901c46ULL,
0x0000000004197faeULL, 0x0003e2000c101c46ULL, 0x0000000000c87947ULL, 0x000fea0003800000ULL,
0x0000001003067824ULL, 0x000fca00078e00ffULL, 0x0000000609037211ULL, 0x000fca00078fe8ffULL,
0x0000000103077824ULL, 0x040fe400078e0209ULL, 0x0000000803127824ULL, 0x000fe400078e00ffULL,
0x00000004030c7836ULL, 0x000fe40000000000ULL, 0x0000000100067824ULL, 0x000fe200078e0203ULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x000000010c0d7824ULL, 0x040fe400078e0209ULL,
0x000000080c147824ULL, 0x000fc400078e00ffULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee20dULL, 0x00000008030d7836ULL, 0x000fe20000000000ULL,
0x0000007006117812ULL, 0x000fe200078ef802ULL, 0x0000000c030e7836ULL, 0x000fe40000000000ULL,
0x00000001000c7824ULL, 0x040fe200078e020cULL, 0x0000001104107210ULL, 0x000fe20007f1e0ffULL,
0x0000000100037824ULL, 0x040fe400078e020dULL, 0x00000001000f7824ULL, 0x000fe400078e020eULL,
0x000000010e067824ULL, 0x000fc400078e0209ULL, 0x000000080e157824ULL, 0x000fe400078e00ffULL,
0x000000010d007824ULL, 0x040fe400078e0209ULL, 0x000000080d137824ULL, 0x000fe200078e00ffULL,
0xfffffff815167812ULL, 0x000fe200078ee206ULL, 0x00002000630d7824ULL, 0x000fe400078e0208ULL,
0x0000000105117824ULL, 0x000fe200000e0607ULL, 0xfffffff813007812ULL, 0x000fe200078ee200ULL,
0x000160000d1d7836ULL, 0x000fc40000000000ULL, 0x000000800c067825ULL, 0x000fc800078e00ffULL,
0x00000080030c7825ULL, 0x000fe200078e00ffULL, 0x00000070061b7812ULL, 0x000fc600078ef802ULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c197812ULL, 0x000fc600078ef802ULL,
0x0000001012137824ULL, 0x100fe200078e021dULL, 0x000000700e037812ULL, 0x000fe200078ef802ULL,
0x0000001014157824ULL, 0x100fe200078e021dULL, 0x0000001b04027210ULL, 0x000fe20007f1e0ffULL,
0x0000001000177824ULL, 0x100fe200078e021dULL, 0x0000001904067210ULL, 0x000fe20007f3e0ffULL,
0x0000001016197824ULL, 0x000fe200078e021dULL, 0x0000000304047210ULL, 0x000fe20007f5e0ffULL,
0x0000000105037824ULL, 0x040fe200000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0003e2000b901c46ULL, 0x0000000105077824ULL, 0x000fc400008e060dULL,
0x0000000105057824ULL, 0x000fe200010e060fULL, 0x0000000002157faeULL, 0x0003e8000b901c46ULL,
0x0000000006177faeULL, 0x0003e8000b901c46ULL, 0x0000000004197faeULL, 0x0003e4000b901c46ULL,
0x0001a6a808007836ULL, 0x000fe20000000000ULL, 0x00000000630472caULL, 0x000fe200000e0000ULL,
0x00000001ff037424ULL, 0x002fe200078e00ffULL, 0x000000ff6200720cULL, 0x000fe20003f05270ULL,
0x000000ffff847224ULL, 0x000fe200078e00ffULL, 0x00000000000572caULL, 0x000fe400000e0000ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000504047291ULL, 0x000fe2000f8e203fULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000000e7805ULL, 0x000fc4000001ff00ULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000527805ULL, 0x000fc4000001ff00ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x000000ffff497224ULL, 0x000fe400078e00ffULL, 0x0000000863027824ULL, 0x000fe200078e0200ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000003ff7e79a7ULL, 0x0002a20008500004ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x0000000000467805ULL, 0x000fc4000001ff00ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00002003020279a7ULL, 0x002e62000850003fULL,
0x0000000000567805ULL, 0x000fc4000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000009c00948947ULL, 0x000fec0003800000ULL, 0x00009600ff007b82ULL, 0x000ee20000000800ULL,
0x000000027a077824ULL, 0x000fe200078e00ffULL, 0x00000002ff5b7819ULL, 0x000fe20000011677ULL,
0x000000ffff397224ULL, 0x002fe200078e0003ULL, 0x0000000163597812ULL, 0x000fe200078ec0ffULL,
0xff317217ff7a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff587224ULL, 0x000fe400078e00ffULL,
0x000000ffff2f7224ULL, 0x000fe400078e00ffULL, 0x0000000007077224ULL, 0x008fce00078e0200ULL,
0x0000000000347805ULL, 0x010fce0000015200ULL, 0x0000000477067824ULL, 0x000fca00078e00ffULL,
0xfffffff806377812ULL, 0x000fca00078ec0ffULL, 0x0000000108387824ULL, 0x000fc800078e0237ULL,
0x01a6c839380075a7ULL, 0x000e62000800017fULL, 0x0001a6c838067836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x01a6c839380075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009000ff347b82ULL, 0x000e620000000a00ULL, 0x0000001077367824ULL, 0x000fe200078e00ffULL,
0x0000850000057ab9ULL, 0x000fe20000000800ULL, 0x0000000158397836ULL, 0x000fe40000000000ULL,
0x0000000581817c24ULL, 0x000fe2000f8e02ffULL, 0xffffffe036377812ULL, 0x000fe400078ec0ffULL,
0x000000623900720cULL, 0x000fe20003f26070ULL, 0x0000008081817824ULL, 0x000fe400078e00ffULL,
0x0000010058377824ULL, 0x000fc800078e0237ULL, 0x00000040373b7836ULL, 0x000fca0000000000ULL,
0x000000603b377812ULL, 0x000fe200078ec0ffULL, 0x0000008081347825ULL, 0x002fc800078e0034ULL,
0x000000015a4d7824ULL, 0x000fe200078e0237ULL, 0x0000000400049947ULL, 0x000fec0003800000ULL,
0x0000001036377812ULL, 0x000fe400078ec0ffULL, 0x0000003b74367248ULL, 0x000fe40007fe0000ULL,
0x00000003ff3a7819ULL, 0x000fc60000011609ULL, 0x0000000136367824ULL, 0x000fe400078e0a3bULL,
0x000000013a387824ULL, 0x000fe400078e0237ULL, 0x000000083a4c7836ULL, 0x000fe20000000000ULL,
0x0000003736367248ULL, 0x000fe20007fe0000ULL, 0x0000000138397824ULL, 0x040fe400078e0209ULL,
0x00000008384e7824ULL, 0x000fe400078e00ffULL, 0x0000000136367824ULL, 0x000fc400078e0a37ULL,
0x0000000c3a4f7836ULL, 0x000fe20000000000ULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee239ULL,
0x000000043a397836ULL, 0x000fe20000000000ULL, 0x000000363a00720cULL, 0x080fe20003f86070ULL,
0x00000010093b7824ULL, 0x000fe200078e00ffULL, 0x000000364c00720cULL, 0x0c0fe20003f46070ULL,
0x00000001393a7824ULL, 0x140fe200078e0237ULL, 0x000000363900720cULL, 0x080fe20003f66070ULL,
0x000000014c4c7824ULL, 0x100fe200078e0237ULL, 0x000000364f00720cULL, 0x040fe20003f06070ULL,
0x000000014f5c7824ULL, 0x000fe200078e0237ULL, 0x000000703b657812ULL, 0x000fe200078ec0ffULL,
0x000000014d367824ULL, 0x000fc400078e0238ULL, 0x000000014d387824ULL, 0x040fe400078e023aULL,
0x000000013a3b7824ULL, 0x140fe400078e0209ULL, 0x000000083a5e7824ULL, 0x000fe400078e00ffULL,
0x000000014d3a7824ULL, 0x040fe400078e024cULL, 0x000000014d4f7824ULL, 0x000fe400078e025cULL,
0x000000014c4d7824ULL, 0x000fc400078e0209ULL, 0x000000084c647824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x0000008038387825ULL, 0x000fc800078e00ffULL,
0x000000015c4c7824ULL, 0x040fe400078e0209ULL, 0x000000085c5d7824ULL, 0x000fe200078e00ffULL,
0xfffffff85e5c7812ULL, 0x000fe400078ee23bULL, 0xfffffff8645e7812ULL, 0x000fe400078ee24dULL,
0x00000065363b7212ULL, 0x080fe400078efcffULL, 0x00000065384d7212ULL, 0x000fe400078efcffULL,
0x0000003b34367210ULL, 0x000fe20007fbe0ffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0xfffffff85d647812ULL, 0x000fc400078ee24cULL, 0x0000004d34387210ULL, 0x000fe20007fde0ffULL,
0x000000804f4c7825ULL, 0x000fe200078e00ffULL, 0x000000653a677212ULL, 0x000fc600078efcffULL,
0x00002000635d7824ULL, 0x000fe200078e0208ULL, 0x000000654c657212ULL, 0x000fe200078efcffULL,
0x0000000135377824ULL, 0x040fe200028e0637ULL, 0x00000067343a7210ULL, 0x000fe20007fbe0ffULL,
0x000170005d4f7836ULL, 0x000fe40000000000ULL, 0x0000000135397824ULL, 0x000fe200030e0639ULL,
0x0000006534347210ULL, 0x000fe20007fde0ffULL, 0x000000104e5d7824ULL, 0x100fe400078e024fULL,
0x000000105c5f7824ULL, 0x000fc400078e024fULL, 0x000000105e657824ULL, 0x000fe200078e024fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000365d7faeULL, 0x0003e2000e101c46ULL,
0x00000001353b7824ULL, 0x040fe400028e063bULL, 0x00000010644f7824ULL, 0x000fe200078e024fULL,
0x00000000385f7faeULL, 0x0003e2000d901c46ULL, 0x0000000135357824ULL, 0x000fc600030e064dULL,
0x000000003a657faeULL, 0x0003e8000d101c46ULL, 0x00000000344f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x0000001036367812ULL, 0x000fe200078ec0ffULL,
0x00000010093a7824ULL, 0x000fc600078e00ffULL, 0x0000003609367211ULL, 0x000fe400078fe8ffULL,
0x000000703a657812ULL, 0x000fc600078ec0ffULL, 0x0000000436387836ULL, 0x000fe40000000000ULL,
0x0000000136377824ULL, 0x140fe400078e0209ULL, 0x00000008364e7824ULL, 0x000fe400078e00ffULL,
0x0000000138397824ULL, 0x040fe400078e0209ULL, 0x00000008385c7824ULL, 0x000fe200078e00ffULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee237ULL, 0x000000014d377824ULL, 0x000fc400078e0236ULL,
0x00000008363a7836ULL, 0x000fe20000000000ULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee239ULL,
0x0000000c364c7836ULL, 0x000fe40000000000ULL, 0x0000008037367825ULL, 0x000fc800078e00ffULL,
0x000000014d3b7824ULL, 0x040fe200078e023aULL, 0x00000065364f7212ULL, 0x000fe200078efcffULL,
0x000000013a397824ULL, 0x140fe400078e0209ULL, 0x000000083a5e7824ULL, 0x000fe200078e00ffULL,
0x0000004f34367210ULL, 0x000fe20007f1e0ffULL, 0x000000014d387824ULL, 0x000fe400078e0238ULL,
0x000000014c3a7824ULL, 0x040fe200078e0209ULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee239ULL,
0x000000084c5d7824ULL, 0x000fc400078e00ffULL, 0x000000014d4d7824ULL, 0x000fe400078e024cULL,
0x00002000634c7824ULL, 0x000fe200078e0208ULL, 0xfffffff85d647812ULL, 0x000fe200078ee23aULL,
0x0000008038387825ULL, 0x000fc800078e00ffULL, 0x000170004c6b7836ULL, 0x000fe20000000000ULL,
0x0000006538697212ULL, 0x000fe200078efcffULL, 0x000000803b3a7825ULL, 0x000fc800078e00ffULL,
0x000000804d4c7825ULL, 0x000fe200078e00ffULL, 0x000000653a677212ULL, 0x000fc600078efcffULL,
0x0000000135377824ULL, 0x040fe200000e0637ULL, 0x000000654c657212ULL, 0x000fe200078efcffULL,
0x000000104e4f7824ULL, 0x100fe200078e026bULL, 0x0000006934387210ULL, 0x000fe20007f1e0ffULL,
0x000000105c5d7824ULL, 0x100fe200078e026bULL, 0x00000067343a7210ULL, 0x000fe20007f5e0ffULL,
0x000000105e5f7824ULL, 0x000fe200078e026bULL, 0x0000006534347210ULL, 0x000fe20007f7e0ffULL,
0x0000000135397824ULL, 0x040fe200000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000364f7faeULL, 0x0003e2000b901c46ULL, 0x00000001353b7824ULL, 0x000fc400010e063bULL,
0x0000001064657824ULL, 0x000fe200078e026bULL, 0x00000000385d7faeULL, 0x0003e2000b901c46ULL,
0x0000000135357824ULL, 0x000fc600018e064dULL, 0x000000003a5f7faeULL, 0x0003e8000b901c46ULL,
0x0000000034657faeULL, 0x0003e4000b901c46ULL, 0x0000000160367836ULL, 0x002fe40000000000ULL,
0xffffffffff7b7424ULL, 0x000fc600078e00ffULL, 0x000000753600720cULL, 0x000fda0003f06070ULL,
0x00009200ff348b82ULL, 0x000e620000000a00ULL, 0x0000000107378824ULL, 0x000fe400078e0236ULL,
0x0000000877367824ULL, 0x000fe400078e00ffULL, 0x0000000437348825ULL, 0x002fc600078e0034ULL,
0xfffffff036377812ULL, 0x040fe400078ec0ffULL, 0x0000001036387812ULL, 0x000fe200078ec0ffULL,
0x00000006347b8981ULL, 0x000324000c1e1900ULL, 0x00000001083a7824ULL, 0x000fe200078e0237ULL,
0xffffffe036377812ULL, 0x040fe200078ec0ffULL, 0x00000001ff397424ULL, 0x000fe200078e00ffULL,
0x0000000836807812ULL, 0x000fe400078ec0ffULL, 0x000000003a0572caULL, 0x000fc400000e0000ULL,
0x0000000838377210ULL, 0x000fe20007ffe037ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000137807824ULL, 0x000fcc00078e0280ULL, 0x0001a6b005057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x002fe40000000000ULL,
0x01a6b0393a8679a7ULL, 0x0002e4000850003fULL, 0x01a60839803879a7ULL, 0x0022a4000850003fULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x01a60839800075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a60839800075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x00000010096d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff707819ULL, 0x000fe20000011609ULL,
0x0000002077347824ULL, 0x000fe400078e00ffULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x000000706d6d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff857224ULL, 0x000fe200078e007aULL,
0xffffff8034347812ULL, 0x000fe400078ec0ffULL, 0x0000000c70707812ULL, 0x000fe400078ec0ffULL,
0x000000086d357210ULL, 0x000fca0007ffe034ULL, 0x0000000135357824ULL, 0x000fca00078e0270ULL,
0x01a0000035377984ULL, 0x000ea80000000800ULL, 0x01a2000035397984ULL, 0x000b620000000800ULL,
0x0000007a3700720bULL, 0x004fda0003f1d000ULL, 0x0000000000367806ULL, 0x000fc800000e0100ULL,
0x000000ff3600720cULL, 0x000fda0003f05270ULL, 0x00000004008c8947ULL, 0x02afea0003800000ULL,
0x000000775b00720cULL, 0x000fe40003f45270ULL, 0x0000007a3700720bULL, 0x0c0fe40003f14000ULL,
0x0000007a37857209ULL, 0x000fd20007810000ULL, 0x000000807734a824ULL, 0x000fe400078e0208ULL,
0x0000000000357806ULL, 0x000fc600000e0100ULL, 0x000000347034a210ULL, 0x000fe40007ffe06dULL,
0x000000ff3500720cULL, 0x000fc60003f05270ULL, 0x01a400853400a388ULL, 0x0003f40000000800ULL,
0x0000000400508947ULL, 0x002fea0003800000ULL, 0x0000007a85347221ULL, 0x000fe20000010100ULL,
0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0035ff7812ULL, 0x040fe2000784c0ffULL,
0x3fb8aa3b34347820ULL, 0x000fe20000410000ULL, 0x00ff000035ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000035ff7812ULL, 0x000fe2000788c0ffULL, 0x00000034003b7308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff347819ULL, 0x002fcc0000011609ULL,
0x00001f343b347589ULL, 0x004e6400000e0000ULL, 0x0000003454547220ULL, 0x082fe20000410000ULL,
0x0000003455557220ULL, 0x080fe20000410000ULL, 0x000000343c3c7220ULL, 0x080fe20000410000ULL,
0x000000343d3d7220ULL, 0x080fe20000410000ULL, 0x0000003440407220ULL, 0x080fe20000410000ULL,
0x0000003441417220ULL, 0x080fe20000410000ULL, 0x0000003444447220ULL, 0x080fe20000410000ULL,
0x0000003445457220ULL, 0x080fe20000410000ULL, 0x0000003448487220ULL, 0x080fe20000410000ULL,
0x0000003449497220ULL, 0x080fe20000410000ULL, 0x0000003450507220ULL, 0x080fe20000410000ULL,
0x0000003451517220ULL, 0x080fe20000410000ULL, 0x0000003428287220ULL, 0x080fe20000410000ULL,
0x0000003429297220ULL, 0x080fe20000410000ULL, 0x0000003424247220ULL, 0x080fe20000410000ULL,
0x0000003425257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000000809347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343b347589ULL, 0x004e6400000e0000ULL,
0x0000003456567220ULL, 0x082fe20000410000ULL, 0x0000003457577220ULL, 0x080fe20000410000ULL,
0x000000343e3e7220ULL, 0x080fe20000410000ULL, 0x000000343f3f7220ULL, 0x080fe20000410000ULL,
0x0000003442427220ULL, 0x080fe20000410000ULL, 0x0000003443437220ULL, 0x080fe20000410000ULL,
0x0000003446467220ULL, 0x080fe20000410000ULL, 0x0000003447477220ULL, 0x080fe20000410000ULL,
0x000000344a4a7220ULL, 0x080fe20000410000ULL, 0x000000344b4b7220ULL, 0x080fe20000410000ULL,
0x0000003452527220ULL, 0x080fe20000410000ULL, 0x0000003453537220ULL, 0x080fe20000410000ULL,
0x000000342a2a7220ULL, 0x080fe20000410000ULL, 0x000000342b2b7220ULL, 0x080fe20000410000ULL,
0x0000003426267220ULL, 0x080fe20000410000ULL, 0x0000003427277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x0000001009347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343b347589ULL, 0x004e6400000e0000ULL, 0x000000340c0c7220ULL, 0x082fe20000410000ULL,
0x000000340d0d7220ULL, 0x080fe20000410000ULL, 0x0000003410107220ULL, 0x080fe20000410000ULL,
0x0000003411117220ULL, 0x080fe20000410000ULL, 0x0000003414147220ULL, 0x080fe20000410000ULL,
0x0000003415157220ULL, 0x080fe20000410000ULL, 0x0000003418187220ULL, 0x080fe20000410000ULL,
0x0000003419197220ULL, 0x080fe20000410000ULL, 0x000000341c1c7220ULL, 0x080fe20000410000ULL,
0x000000341d1d7220ULL, 0x080fe20000410000ULL, 0x0000003420207220ULL, 0x080fe20000410000ULL,
0x0000003421217220ULL, 0x080fe20000410000ULL, 0x0000003430307220ULL, 0x080fe20000410000ULL,
0x0000003431317220ULL, 0x080fe20000410000ULL, 0x000000342c2c7220ULL, 0x080fe20000410000ULL,
0x000000342d2d7220ULL, 0x000fce0000410000ULL, 0x0000003b84847220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x0000001809347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343b347589ULL, 0x000e6400000e0000ULL, 0x000000340e0e7220ULL, 0x082fe20000410000ULL,
0x000000340f0f7220ULL, 0x080fe20000410000ULL, 0x0000003412127220ULL, 0x080fe20000410000ULL,
0x0000003413137220ULL, 0x080fe20000410000ULL, 0x0000003416167220ULL, 0x080fe20000410000ULL,
0x0000003417177220ULL, 0x080fe20000410000ULL, 0x000000341a1a7220ULL, 0x080fe20000410000ULL,
0x000000341b1b7220ULL, 0x080fe20000410000ULL, 0x000000341e1e7220ULL, 0x080fe20000410000ULL,
0x000000341f1f7220ULL, 0x080fe20000410000ULL, 0x0000003422227220ULL, 0x080fe20000410000ULL,
0x0000003423237220ULL, 0x080fe20000410000ULL, 0x0000003432327220ULL, 0x080fe20000410000ULL,
0x0000003433337220ULL, 0x080fe20000410000ULL, 0x000000342e2e7220ULL, 0x080fe20000410000ULL,
0x000000342f2f7220ULL, 0x000fce0000410000ULL, 0x0000003536ff7212ULL, 0x000fda00078030ffULL,
0x8000008537370221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b37370820ULL, 0x000fc80000410000ULL, 0x0000003700040308ULL, 0x000ea40000000800ULL,
0x0000000439390220ULL, 0x004fce0000410000ULL, 0x0000008439847221ULL, 0x000fce0000010000ULL,
0x0000000000347805ULL, 0x002fce0000015200ULL, 0x01a6a87f3a0075a7ULL, 0x000e62000800017fULL,
0x0001a6a83a397836ULL, 0x000fca0000000000ULL, 0x00000000390572caULL, 0x000fe200000e0000ULL,
0x0000000000600947ULL, 0x002fdc0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a6a87f3a0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000000390572caULL, 0x000fde00000e0000ULL, 0x00000002777d7824ULL, 0x000fe200078e00ffULL,
0x00000008096c7812ULL, 0x000fe200078ec0ffULL, 0x0000000477367824ULL, 0x000fe200078e00ffULL,
0x0000991038347816ULL, 0x000fe400000000ffULL, 0x000000047d727812ULL, 0x000fe400078ec0ffULL,
0x000000076c6c7812ULL, 0x000fe400078ef809ULL, 0x0000007209357211ULL, 0x000fe400078fe0ffULL,
0x000000106c787812ULL, 0x040fe200078efcffULL, 0x000000086c387824ULL, 0x000fe200078e00ffULL,
0x000000ff3400720cULL, 0x000fe20003f05270ULL, 0x000000016c7f7824ULL, 0x000fe200078e0235ULL,
0x0000000436367812ULL, 0x000fe200078ec0ffULL, 0x0000040077347824ULL, 0x000fc400078e00ffULL,
0x00000001357e7824ULL, 0x000fe200078e0278ULL, 0xfffffff8387f7812ULL, 0x000fe200078ee27fULL,
0x0000000878357824ULL, 0x000fe200078e00ffULL, 0x0000003609717211ULL, 0x000fe200078fe0ffULL,
0x0000100077387824ULL, 0x000fe200078e00ffULL, 0xfffff00034377812ULL, 0x000fe200078ec0ffULL,
0x000000086c3b7824ULL, 0x040fe200078e00ffULL, 0xfffffff8357e7812ULL, 0x000fe200078ee27eULL,
0x000000016c5c7824ULL, 0x000fe200078e0271ULL, 0x00012000087a7810ULL, 0x000fe40007ffe037ULL,
0xffffe00038397812ULL, 0x000fc400078ec0ffULL, 0xfffffff83b6e7812ULL, 0x000fe200078ee25cULL,
0x000000107f367824ULL, 0x100fe200078e027aULL, 0x00016000085d7810ULL, 0x000fe20007ffe039ULL,
0x000000107e387824ULL, 0x000fe200078e027aULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000000ffULL,
0x0000001003057836ULL, 0x000fe20000000000ULL, 0x0000541000347816ULL, 0x000fe20000000000ULL,
0x0000000803357836ULL, 0x000fe40000000000ULL, 0x0000001803377836ULL, 0x000fe40000000000ULL,
0x00001f0534057589ULL, 0x0002a800000e0000ULL, 0x00001f3534027589ULL, 0x0002e800000e0000ULL,
0x00001f0334037589ULL, 0x00026800000e0000ULL, 0x00001f3734007589ULL, 0x00026400000e0000ULL,
0x000000003634783bULL, 0x002e620000000200ULL, 0x000000106e4c7824ULL, 0x000fc600078e025dULL,
0x000000003838783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x088fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x0000000538387232ULL, 0x084fe40000000000ULL, 0x000000053a3a7232ULL, 0x000fc40000000000ULL,
0x0000000039397232ULL, 0x080fe40000000000ULL, 0x000000003b3b7232ULL, 0x000fce0000000000ULL,
0x000000086c5e7824ULL, 0x000fe200078e00ffULL, 0x000000004c4c783bULL, 0x000f620000004200ULL,
0x000000025c737836ULL, 0x000fe20000000000ULL, 0x0000000272727812ULL, 0x000fc800078efcffULL,
0xfffffff85e737812ULL, 0x000fca00078ee273ULL, 0x00000010735d7824ULL, 0x000fcc00078e025dULL,
0x000000005d5c783bULL, 0x000f640000004200ULL, 0x00000010ff907819ULL, 0x028fe4000001164cULL,
0x00000018ff657819ULL, 0x000fe4000001164eULL, 0x00000010ff917819ULL, 0x000fe4000001164dULL,
0x000000ff4c8e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4c6a7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff677819ULL, 0x000fe4000001164fULL, 0x000000ff90907812ULL, 0x000fe400078ec0ffULL,
0x00000018ff897819ULL, 0x000fe4000001164cULL, 0x00000010ff8c7819ULL, 0x000fe4000001164eULL,
0x000000ff5d927812ULL, 0x004fe400078ec0ffULL, 0x00000010ff827819ULL, 0x000fc4000001165eULL,
0x000000ff5e947812ULL, 0x040fe400078ec0ffULL, 0x00000018ff937819ULL, 0x000fe4000001165eULL,
0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001165dULL,
0x00000065ff5e723eULL, 0x000fe400020006ffULL, 0x00000092ff65723eULL, 0x000fc400020006ffULL,
0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x100fe4000001165fULL,
0x000000ff5f957812ULL, 0x040fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe4000001165fULL,
0x0000ffff5f6f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff91927812ULL, 0x000fc400078ec0ffULL,
0x000000ff4e887812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4e8b7812ULL, 0x000fe400078ec0ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x00000067ff5f723eULL, 0x000fe400020006ffULL,
0x00000008ff917819ULL, 0x000fe4000001166aULL, 0x00000090ff90723eULL, 0x000fc400020006ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001165cULL, 0x0000006bff67723eULL, 0x000fe400020006ffULL,
0x00000094ff6b723eULL, 0x000fe400020006ffULL, 0x000000ff4d8f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001164dULL, 0x0000ffff4d8d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff947819ULL, 0x000fe4000001164cULL,
0x00000010ff4d7819ULL, 0x000fe4000001164fULL, 0x000000ff5c817812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001165cULL, 0x00000089ff89723eULL, 0x000fc400020006ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x000054108e4c7816ULL, 0x000fe40000000090ULL,
0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e8e7812ULL, 0x000fe400078ec0ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000008ff8d7819ULL, 0x000fc4000001168dULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x00005410914e7816ULL, 0x000fe40000000089ULL, 0x000000ff4f697812ULL, 0x000fe400078ec0ffULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fc400020006ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000008ff897819ULL, 0x000fe4000001165cULL, 0x00000010ff4f7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d837812ULL, 0x000fe400078ec0ffULL, 0x00000093ff6a723eULL, 0x000fc400020006ffULL,
0x0000008dff93723eULL, 0x000fe400020006ffULL, 0x00005410885c7816ULL, 0x000fe4000000008cULL,
0x0000004dff8d723eULL, 0x000fe400020006ffULL, 0x000000ff64887812ULL, 0x000fe400078ec0ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x000054108f4d7816ULL, 0x000fc40000000092ULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x000000ff82827812ULL, 0x000fe400078ec0ffULL,
0x0000541081647816ULL, 0x000fe2000000008eULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x00000008ff8b7819ULL, 0x000fe4000001168bULL, 0x000000ff4f8f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff837819ULL, 0x000fe20000011683ULL, 0x0000004c380c723cULL, 0x000fe2000000180cULL,
0x00000008ff817819ULL, 0x000fc40000011666ULL, 0x00000008ff6f7819ULL, 0x000fe4000001166fULL,
0x00000069ff5d723eULL, 0x000fe400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x0000541089667816ULL, 0x000fe4000000007cULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x00000095ff69723eULL, 0x000fc400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000068ff7c723eULL, 0x000fc400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x000054106b687816ULL, 0x000fe40000000082ULL,
0x00005410934f7816ULL, 0x000fe4000000008aULL, 0x000054105d5d7816ULL, 0x000fe4000000008dULL,
0x000054108b5e7816ULL, 0x000fc4000000005eULL, 0x00005410945f7816ULL, 0x000fe2000000005fULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x0000541065657816ULL, 0x000fe4000000008fULL,
0x0000541083677816ULL, 0x000fe40000000067ULL, 0x0000541069697816ULL, 0x000fe20000000088ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x00005410816a7816ULL, 0x000fe4000000006aULL,
0x000054106f6b7816ULL, 0x000fc6000000007cULL, 0x0000005e3444723cULL, 0x000fec0000001844ULL,
0x000000643448723cULL, 0x000fec0000001848ULL, 0x000000663450723cULL, 0x000fec0000001850ULL,
0x000000683428723cULL, 0x000fec0000001828ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x0000005c3814723cULL, 0x000fe20000001814ULL, 0x0000007209357211ULL, 0x000fe200078fe0ffULL,
0x000000086c347824ULL, 0x000fc400078e00ffULL, 0x0000000878377824ULL, 0x000fe400078e00ffULL,
0x000000016c6f7824ULL, 0x100fe200078e0235ULL, 0x0000004e3810723cULL, 0x000fe20000001810ULL,
0x0000000178357824ULL, 0x040fe400078e0235ULL, 0x00000001785c7824ULL, 0x040fe200078e0271ULL,
0xfffffff8346f7812ULL, 0x000fe200078ee26fULL, 0x0000000878347824ULL, 0x000fe200078e00ffULL,
0x0000005e3818723cULL, 0x000fe20000001818ULL, 0x0000200063727824ULL, 0x000fe200078e0208ULL,
0xfffffff8377c7812ULL, 0x000fc400078ee25cULL, 0xfffffff834717812ULL, 0x000fe200078ee235ULL,
0x000000106f347824ULL, 0x100fe200078e027aULL, 0x00000064381c723cULL, 0x000fe2000000181cULL,
0x0001600072837836ULL, 0x000fe40000000000ULL, 0x00000010717a7824ULL, 0x000fe400078e027aULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0x000000663820723cULL, 0x000fe20000001820ULL,
0x000000107c4c7824ULL, 0x000fca00078e0283ULL, 0x000000683830723cULL, 0x000fec0000001830ULL,
0x0000006a3838723cULL, 0x000fe2000000182cULL, 0x000000007a2c783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x080fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x00000008785d7824ULL, 0x000fe200078e00ffULL, 0x000000004c4c783bULL, 0x000f620000004200ULL,
0x000000025c7a7836ULL, 0x004fe20000000000ULL, 0xfffffff87d7d7812ULL, 0x000fc800078ec0ffULL,
0xfffffff85d7a7812ULL, 0x000fe200078ee27aULL, 0x00000001087d7824ULL, 0x000fc800078e027dULL,
0x000000107a5c7824ULL, 0x000fcc00078e0283ULL, 0x000000005c5c783bULL, 0x000ea20000004200ULL,
0x00000018ff677819ULL, 0x020fe4000001164fULL, 0x00000010ff947819ULL, 0x100fe4000001164dULL,
0x000000ff4d927812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001164dULL,
0x00000018ff657819ULL, 0x000fe4000001164eULL, 0x00000010ff937819ULL, 0x000fc4000001164cULL,
0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4c6a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8c7819ULL, 0x000fe4000001164eULL, 0x00000018ff6b7819ULL, 0x004fe4000001165dULL,
0x000000ff5e977812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x000fc4000001165fULL,
0x000000ff5f987812ULL, 0x040fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe4000001165fULL,
0x0000ffff5f817812ULL, 0x000fe400078ec0ffULL, 0x00000067ff5f723eULL, 0x000fe400020006ffULL,
0x0000006bff67723eULL, 0x000fe400020006ffULL, 0x000000ff5d967812ULL, 0x000fc400078ec0ffULL,
0x00000097ff6b723eULL, 0x000fe400020006ffULL, 0x000000ff94977812ULL, 0x000fe400078ec0ffULL,
0x00000010ff897819ULL, 0x100fe4000001165eULL, 0x00000018ff957819ULL, 0x000fe4000001165eULL,
0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL, 0x00000065ff5e723eULL, 0x000fc400020006ffULL,
0x00000096ff65723eULL, 0x000fe400020006ffULL, 0x000000ff93937812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4d7819ULL, 0x000fe4000001164dULL, 0x00000018ff8d7819ULL, 0x000fe4000001164cULL,
0x000000ff4e8b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4e907812ULL, 0x000fc400078ec0ffULL,
0x000000ff4f697812ULL, 0x000fe400078ec0ffULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000008ff967819ULL, 0x000fe4000001166aULL, 0x00000097ff97723eULL, 0x000fe400020006ffULL,
0x000000ff4c917812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4e7819ULL, 0x000fc4000001165cULL,
0x00000010ff8f7819ULL, 0x000fe4000001164fULL, 0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL,
0x00000095ff6a723eULL, 0x000fe400020006ffULL, 0x00000010ff4f7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d8a7812ULL, 0x000fe400078ec0ffULL, 0x00000093ff94723eULL, 0x000fc400020006ffULL,
0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL, 0x0000004dff95723eULL, 0x000fe400020006ffULL,
0x000000ff5c887812ULL, 0x000fe400078ec0ffULL, 0x00000018ff827819ULL, 0x000fe4000001165cULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x00000069ff5d723eULL, 0x000fc400020006ffULL,
0x00000096ff93723eULL, 0x000fe400020006ffULL, 0x00005410924d7816ULL, 0x000fe40000000097ULL,
0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x00000098ff69723eULL, 0x000fe400020006ffULL,
0x000000ff4e927812ULL, 0x000fe400078ec0ffULL, 0x000000ff8f987812ULL, 0x000fc400078ec0ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000008ff967819ULL, 0x000fe40000011690ULL,
0x0000008cff8f723eULL, 0x000fe400020006ffULL, 0x00005410934e7816ULL, 0x000fe4000000008dULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fc400020006ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000008ff8d7819ULL, 0x000fe4000001165cULL,
0x00000096ff8c723eULL, 0x000fe400020006ffULL, 0x000054108b5c7816ULL, 0x000fe4000000008fULL,
0x00000008ff967819ULL, 0x000fe4000001164cULL, 0x000000ff648b7812ULL, 0x000fc400078ec0ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00005410914c7816ULL, 0x000fe40000000094ULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x000000ff89897812ULL, 0x000fe400078ec0ffULL,
0x0000541088647816ULL, 0x000fe20000000092ULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x000000ff4f947812ULL, 0x000fc400078ec0ffULL, 0x00000008ff8a7819ULL, 0x000fe4000001168aULL,
0x00000008ff887819ULL, 0x000fe20000011666ULL, 0x0000004c2c0c723cULL, 0x008fe2000000180cULL,
0x00000008ff817819ULL, 0x000fe40000011681ULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x000054108d667816ULL, 0x000fe40000000082ULL, 0x0000008eff8e723eULL, 0x000fc400020006ffULL,
0x00000098ff90723eULL, 0x000fe400020006ffULL, 0x00000096ff91723eULL, 0x000fe400020006ffULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000068ff82723eULL, 0x000fc400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x000054106b687816ULL, 0x000fe40000000089ULL, 0x00005410954f7816ULL, 0x000fe4000000008eULL,
0x000054105d5d7816ULL, 0x000fe40000000090ULL, 0x000054108c5e7816ULL, 0x000fc4000000005eULL,
0x00005410915f7816ULL, 0x000fe2000000005fULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x0000541065657816ULL, 0x000fe40000000094ULL, 0x000054108a677816ULL, 0x000fe40000000067ULL,
0x0000541069697816ULL, 0x000fe2000000008bULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x00005410886a7816ULL, 0x000fe4000000006aULL, 0x00005410816b7816ULL, 0x000fc60000000082ULL,
0x0000005e3444723cULL, 0x000fec0000001844ULL, 0x000000643448723cULL, 0x000fec0000001848ULL,
0x000000663450723cULL, 0x000fec0000001850ULL, 0x000000683428723cULL, 0x000fec0000001828ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x0000000863347824ULL, 0x000fc400078e0208ULL, 0x00000001ff367424ULL, 0x000fc600078e00ffULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x01a6c836343479a7ULL, 0x00026a000850003fULL,
0x0000005e2c18723cULL, 0x000fe20000001818ULL, 0x01a688367dff79a7ULL, 0x0003ea000850003fULL,
0x000000642c1c723cULL, 0x000fec000000181cULL, 0x000000662c20723cULL, 0x000fec0000001820ULL,
0x000000682c30723cULL, 0x000fec0000001830ULL, 0x0000006a2c38723cULL, 0x002fde0000001838ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000372e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00009000ff8a7b82ULL, 0x000e620000000a00ULL,
0x00000010772c7824ULL, 0x000fe200078e00ffULL, 0x0000850000087ab9ULL, 0x000fe40000000800ULL,
0x000000087b7b7c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe02c2d7812ULL, 0x000fe400078ec0ffULL,
0x000000807b7b7824ULL, 0x000fc600078e00ffULL, 0x00000100582d7824ULL, 0x000fc800078e022dULL,
0x000000802d2f7836ULL, 0x000fca0000000000ULL, 0x000000602f2d7812ULL, 0x000fe200078ec0ffULL,
0x000000807b8a7825ULL, 0x002fc800078e008aULL, 0x000000015a2e7824ULL, 0x000fe200078e022dULL,
0x0000000000f49947ULL, 0x000fec0003800000ULL, 0x000000102c357812ULL, 0x000fe400078ec0ffULL,
0x0000002f742c7248ULL, 0x000fe40007fe0000ULL, 0x00000003ff2d7819ULL, 0x000fc60000011609ULL,
0x000000012c2c7824ULL, 0x000fe400078e0a2fULL, 0x000000012d2f7824ULL, 0x000fe400078e0235ULL,
0x000000042d367836ULL, 0x000fe20000000000ULL, 0x0000002c352c7248ULL, 0x000fe20007fe0000ULL,
0x000000012f347824ULL, 0x040fe400078e0209ULL, 0x000000082f377824ULL, 0x000fe400078e00ffULL,
0x000000012c2c7824ULL, 0x000fc600078e0a35ULL, 0xfffffff8374c7812ULL, 0x000fe200078ee234ULL,
0x0000000136347824ULL, 0x040fe200078e0235ULL, 0x0000002c3600720cULL, 0x080fe20003f66070ULL,
0x000000082d377836ULL, 0x000fe20000000000ULL, 0x0000002c2d00720cULL, 0x080fe20003f86070ULL,
0x0000000c2d367836ULL, 0x000fe40000000000ULL, 0x000000012f2d7824ULL, 0x000fe200078e022eULL,
0x0000002c3700720cULL, 0x080fe20003f46070ULL, 0x00000001342f7824ULL, 0x000fe200078e0209ULL,
0x0000002c3600720cULL, 0x000fe20003f06070ULL, 0x00000008344e7824ULL, 0x000fc400078e00ffULL,
0x000000802d2c7825ULL, 0x000fc600078e00ffULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee22fULL,
0x0000000137377824ULL, 0x100fe200078e0235ULL, 0x0000006d2c2f7212ULL, 0x000fe200078efcffULL,
0x0000000134347824ULL, 0x000fe400078e022eULL, 0x00000001365d7824ULL, 0x000fe200078e0235ULL,
0x0000002f8a2c7210ULL, 0x000fe20007fbe0ffULL, 0x00000001374d7824ULL, 0x040fe400078e0209ULL,
0x00000008375c7824ULL, 0x000fe400078e00ffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee24dULL, 0x0000000137367824ULL, 0x100fe200078e022eULL,
0x0000006d344d7212ULL, 0x000fe200078efcffULL, 0x000000015d2e7824ULL, 0x000fe400078e022eULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000006d364f7212ULL, 0x000fc600078efcffULL, 0x000000018b2d7824ULL, 0x000fe200028e062dULL,
0x0000004d8a347210ULL, 0x000fe20007fbe0ffULL, 0x000000015d5e7824ULL, 0x040fe200078e0209ULL,
0x0000006d2e4d7212ULL, 0x000fe200078efcffULL, 0x000000085d5d7824ULL, 0x000fe400078e00ffULL,
0x000000018b357824ULL, 0x040fe200028e0635ULL, 0x0000004f8a367210ULL, 0x000fe20007fbe0ffULL,
0x000000104e4f7824ULL, 0x100fe200078e0283ULL, 0x0000004d8a2e7210ULL, 0x000fe20007fde0ffULL,
0x000000104c4d7824ULL, 0x000fe200078e0283ULL, 0xfffffff85d5e7812ULL, 0x000fe200078ee25eULL,
0x000000018b377824ULL, 0x000fc400028e0637ULL, 0x000000105c5d7824ULL, 0x000fe200078e0283ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c4d7faeULL, 0x0003e2000e101c46ULL,
0x000000018b2f7824ULL, 0x000fe400030e062fULL, 0x000000105e5f7824ULL, 0x000fe200078e0283ULL,
0x00000000344f7faeULL, 0x0003e8000d901c46ULL, 0x00000000365d7faeULL, 0x0003e8000d101c46ULL,
0x000000002e5f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c07947ULL, 0x000fea0003800000ULL,
0x000000102c2c7812ULL, 0x000fc800078ec0ffULL, 0x0000002c092d7211ULL, 0x000fca00078fe8ffULL,
0x000000042d347836ULL, 0x000fe40000000000ULL, 0x000000012d2c7824ULL, 0x140fe400078e0209ULL,
0x000000082d377824ULL, 0x000fe400078e00ffULL, 0x00000001342f7824ULL, 0x040fe400078e0209ULL,
0x00000008344e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8374c7812ULL, 0x000fe200078ee22cULL,
0x000000082d367836ULL, 0x000fc40000000000ULL, 0x000000012d2c7824ULL, 0x000fe200078e022eULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee22fULL, 0x0000000136357824ULL, 0x040fe400078e0209ULL,
0x00000008365c7824ULL, 0x000fe400078e00ffULL, 0x0000000c2d2f7836ULL, 0x000fe40000000000ULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0xfffffff85c5c7812ULL, 0x000fc600078ee235ULL,
0x0000000134347824ULL, 0x100fe200078e022eULL, 0x0000006d2c4d7212ULL, 0x000fe200078efcffULL,
0x0000000136367824ULL, 0x100fe400078e022eULL, 0x000000012f2e7824ULL, 0x040fe200078e022eULL,
0x0000004d8a2c7210ULL, 0x000fe20007f1e0ffULL, 0x000000012f4f7824ULL, 0x040fe400078e0209ULL,
0x000000082f5e7824ULL, 0x000fe400078e00ffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee24fULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000006d345d7212ULL, 0x000fc600078efcffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000006d364f7212ULL, 0x080fe400078efcffULL, 0x0000005d8a347210ULL, 0x000fe20007f5e0ffULL,
0x000000018b2d7824ULL, 0x040fe200000e062dULL, 0x0000006d2e4d7212ULL, 0x000fe200078efcffULL,
0x000000105c5d7824ULL, 0x000fe200078e0283ULL, 0x0000004f8a367210ULL, 0x000fe20007f1e0ffULL,
0x000000018b357824ULL, 0x000fe200010e0635ULL, 0x0000004d8a2e7210ULL, 0x000fe20007f7e0ffULL,
0x000000104c4d7824ULL, 0x000fc400078e0283ULL, 0x000000104e4f7824ULL, 0x000fe400078e0283ULL,
0x000000018b377824ULL, 0x040fe200000e0637ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c4d7faeULL, 0x0003e2000b901c46ULL, 0x000000018b2f7824ULL, 0x000fe400018e062fULL,
0x000000105e5f7824ULL, 0x000fe200078e0283ULL, 0x00000000344f7faeULL, 0x0003e8000b901c46ULL,
0x00000000365d7faeULL, 0x0003e8000b901c46ULL, 0x000000002e5f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff2d7424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000002dff8879a7ULL, 0x0002a40008500005ULL, 0x01a6282d802c79a7ULL, 0x0022e4000850003fULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x01a6282d800075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x000000342e377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e2fULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6282d800075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x00000020772c7824ULL, 0x000fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fc600078e00ffULL,
0xffffff802c2d7812ULL, 0x000fc800078ec0ffULL, 0x00000080082c7810ULL, 0x000fc80007ffe02dULL,
0x0000002c702c7210ULL, 0x000fca0007ffe06dULL, 0x01a000002c2e7984ULL, 0x000ee80000000800ULL,
0x01a200002c2d7984ULL, 0x0009220000000800ULL, 0x000000852e00720bULL, 0x008fda0003f1d000ULL,
0x00000000002f7806ULL, 0x000fc800000e0100ULL, 0x000000ff2f00720cULL, 0x000fda0003f05270ULL,
0x00000004009c8947ULL, 0x016fea0003800000ULL, 0x000000015b2c7836ULL, 0x000fe20000000000ULL,
0x000000852e00720bULL, 0x000fc80003f14000ULL, 0x000000772c00720cULL, 0x000fda0003f45270ULL,
0x000000807734a824ULL, 0x000fe200078e0208ULL, 0x000000852e2ca209ULL, 0x000fc80007810000ULL,
0x000000347035a210ULL, 0x000fe40007ffe06dULL, 0x0000000000347806ULL, 0x000fc600000e0100ULL,
0x01a4002c3500a388ULL, 0x0003e20000000800ULL, 0x000000ff3400720cULL, 0x000fda0003f05270ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x000000852e2c7209ULL, 0x000fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x000000852c2c7221ULL, 0x000fe20000010100ULL, 0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000034ff7812ULL, 0x000fe2000788c0ffULL, 0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL,
0x0000002c00357308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff2c7819ULL, 0x002fcc0000011609ULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x000000542c547220ULL, 0x042fe20000410000ULL, 0x000000552c557220ULL, 0x040fe20000410000ULL,
0x0000003c2c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d2c3d7220ULL, 0x040fe20000410000ULL,
0x000000402c407220ULL, 0x040fe20000410000ULL, 0x000000412c417220ULL, 0x040fe20000410000ULL,
0x000000442c447220ULL, 0x040fe20000410000ULL, 0x000000452c457220ULL, 0x040fe20000410000ULL,
0x000000482c487220ULL, 0x040fe20000410000ULL, 0x000000492c497220ULL, 0x040fe20000410000ULL,
0x000000502c507220ULL, 0x040fe20000410000ULL, 0x000000512c517220ULL, 0x040fe20000410000ULL,
0x000000282c287220ULL, 0x040fe20000410000ULL, 0x000000292c297220ULL, 0x040fe20000410000ULL,
0x000000242c247220ULL, 0x040fe20000410000ULL, 0x000000252c257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x00000008092c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x000000562c567220ULL, 0x042fe20000410000ULL,
0x000000572c577220ULL, 0x040fe20000410000ULL, 0x0000003e2c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f2c3f7220ULL, 0x040fe20000410000ULL, 0x000000422c427220ULL, 0x040fe20000410000ULL,
0x000000432c437220ULL, 0x040fe20000410000ULL, 0x000000462c467220ULL, 0x040fe20000410000ULL,
0x000000472c477220ULL, 0x040fe20000410000ULL, 0x0000004a2c4a7220ULL, 0x040fe20000410000ULL,
0x0000004b2c4b7220ULL, 0x040fe20000410000ULL, 0x000000522c527220ULL, 0x040fe20000410000ULL,
0x000000532c537220ULL, 0x040fe20000410000ULL, 0x0000002a2c2a7220ULL, 0x040fe20000410000ULL,
0x0000002b2c2b7220ULL, 0x040fe20000410000ULL, 0x000000262c267220ULL, 0x040fe20000410000ULL,
0x000000272c277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x00000010092c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x0000000c2c0c7220ULL, 0x042fe20000410000ULL, 0x0000000d2c0d7220ULL, 0x040fe20000410000ULL,
0x000000102c107220ULL, 0x040fe20000410000ULL, 0x000000112c117220ULL, 0x040fe20000410000ULL,
0x000000142c147220ULL, 0x040fe20000410000ULL, 0x000000152c157220ULL, 0x040fe20000410000ULL,
0x000000182c187220ULL, 0x040fe20000410000ULL, 0x000000192c197220ULL, 0x040fe20000410000ULL,
0x0000001c2c1c7220ULL, 0x040fe20000410000ULL, 0x0000001d2c1d7220ULL, 0x040fe20000410000ULL,
0x000000202c207220ULL, 0x040fe20000410000ULL, 0x000000212c217220ULL, 0x040fe20000410000ULL,
0x000000302c307220ULL, 0x040fe20000410000ULL, 0x000000312c317220ULL, 0x040fe20000410000ULL,
0x000000382c387220ULL, 0x040fe20000410000ULL, 0x000000392c397220ULL, 0x000fce0000410000ULL,
0x0000003584847220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x00000018092c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x000e6400000e0000ULL,
0x0000000e2c0e7220ULL, 0x042fe20000410000ULL, 0x0000000f2c0f7220ULL, 0x040fe20000410000ULL,
0x000000122c127220ULL, 0x040fe20000410000ULL, 0x000000132c137220ULL, 0x040fe20000410000ULL,
0x000000162c167220ULL, 0x040fe20000410000ULL, 0x000000172c177220ULL, 0x040fe20000410000ULL,
0x0000001a2c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b2c1b7220ULL, 0x040fe20000410000ULL,
0x0000001e2c1e7220ULL, 0x040fe20000410000ULL, 0x0000001f2c1f7220ULL, 0x040fe20000410000ULL,
0x000000222c227220ULL, 0x040fe20000410000ULL, 0x000000232c237220ULL, 0x040fe20000410000ULL,
0x000000322c327220ULL, 0x040fe20000410000ULL, 0x000000332c337220ULL, 0x040fe20000410000ULL,
0x0000003a2c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b2c3b7220ULL, 0x000fce0000410000ULL,
0x000000342fff7212ULL, 0x000fe200078030ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x000000852e857209ULL, 0x000fd60007810000ULL, 0x800000852e2e0221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL,
0x0000002e00040308ULL, 0x000ea40000000800ULL, 0x000000042d2d0220ULL, 0x004fce0000410000ULL,
0x000000842d847221ULL, 0x000fe20000010000ULL, 0x00000000002c7805ULL, 0x002fe20000015200ULL,
0x00000008772e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2f7812ULL, 0x000fca00078ec0ffULL,
0x0000000108377824ULL, 0x000fc800078e022fULL, 0x01a6b087370075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6b087370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009910342c7816ULL, 0x000fe200000000ffULL, 0x00000400772d7824ULL, 0x040fe400078e00ffULL,
0x00001000772e7824ULL, 0x000fe200078e00ffULL, 0x000000ff2c00720cULL, 0x000fe40003f05270ULL,
0xfffff0002d2d7812ULL, 0x000fe400078ec0ffULL, 0xffffe0002e2f7812ULL, 0x000fe400078ec0ffULL,
0x0001300008827810ULL, 0x000fc40007ffe02dULL, 0x00017000085c7810ULL, 0x000fc60007ffe02fULL,
0x000000107f347824ULL, 0x100fe400078e0282ULL, 0x000000107e2c7824ULL, 0x000fe400078e0282ULL,
0x000000106e4c7824ULL, 0x000fe200078e025cULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff2e7819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000000ffULL,
0x000000082e027836ULL, 0x000fe20000000000ULL, 0x00005410002d7816ULL, 0x000fe20000000000ULL,
0x000000102e367836ULL, 0x000fe40000000000ULL, 0x000000182e4e7836ULL, 0x000fe40000000000ULL,
0x00001f022d027589ULL, 0x0002a800000e0000ULL, 0x00001f362d057589ULL, 0x0002e800000e0000ULL,
0x00001f2e2d037589ULL, 0x00026800000e0000ULL, 0x00001f4e2d007589ULL, 0x00026400000e0000ULL,
0x000000003434783bULL, 0x002e680000000200ULL, 0x000000002c2c783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x084fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x088fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x00000010735c7824ULL, 0x000fe200078e025cULL,
0x000000004c4c783bULL, 0x000f2a0000004200ULL, 0x000000005c5c783bULL, 0x000f620000004200ULL,
0x00000018ff677819ULL, 0x010fe4000001164fULL, 0x00000010ff957819ULL, 0x000fe4000001164dULL,
0x000000ff4d937812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6b7819ULL, 0x028fe4000001165dULL,
0x000000ff5e987812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x100fe4000001165fULL,
0x000000ff5f997812ULL, 0x040fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe4000001165fULL,
0x0000ffff5f7b7812ULL, 0x000fc400078ec0ffULL, 0x00000067ff5f723eULL, 0x000fe400020006ffULL,
0x00000018ff8e7819ULL, 0x000fe4000001164dULL, 0x00000018ff657819ULL, 0x000fe4000001164eULL,
0x0000006bff67723eULL, 0x000fe400020006ffULL, 0x00000010ff947819ULL, 0x000fe4000001164cULL,
0x0000ffff4d4d7812ULL, 0x000fc400078ec0ffULL, 0x000000ff5d977812ULL, 0x000fe400078ec0ffULL,
0x00000098ff6b723eULL, 0x000fe400020006ffULL, 0x0000ffff4c6a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff95987812ULL, 0x000fe400078ec0ffULL, 0x00000010ff877819ULL, 0x100fe4000001165eULL,
0x00000018ff967819ULL, 0x000fc4000001165eULL, 0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL,
0x00000065ff5e723eULL, 0x000fe400020006ffULL, 0x00000097ff65723eULL, 0x000fe400020006ffULL,
0x000000ff94947812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4d7819ULL, 0x000fe4000001164dULL,
0x00000018ff8f7819ULL, 0x000fc4000001164cULL, 0x00000010ff8d7819ULL, 0x000fe4000001164eULL,
0x000000ff4e8c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4e917812ULL, 0x000fe400078ec0ffULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x00000008ff977819ULL, 0x000fe4000001166aULL,
0x00000098ff98723eULL, 0x000fc400020006ffULL, 0x00000010ff4e7819ULL, 0x000fe4000001165cULL,
0x00000096ff6a723eULL, 0x000fe400020006ffULL, 0x00000094ff95723eULL, 0x000fe400020006ffULL,
0x0000004dff96723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000097ff94723eULL, 0x000fc400020006ffULL, 0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL,
0x00005410934d7816ULL, 0x000fe40000000098ULL, 0x000000ff5c817812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001165cULL, 0x000000ff4e937812ULL, 0x000fe400078ec0ffULL,
0x000000ff4c927812ULL, 0x000fc400078ec0ffULL, 0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff977819ULL, 0x000fe40000011691ULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x0000008dff91723eULL, 0x000fe400020006ffULL, 0x00005410944e7816ULL, 0x000fe4000000008fULL,
0x0000ffff4f4c7812ULL, 0x000fc400078ec0ffULL, 0x00000093ff8f723eULL, 0x000fe400020006ffULL,
0x00000010ff907819ULL, 0x000fe4000001164fULL, 0x000000ff4f697812ULL, 0x000fe400078ec0ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x00000008ff937819ULL, 0x000fc4000001165cULL, 0x00000010ff4f7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d867812ULL, 0x000fe400078ec0ffULL, 0x00000097ff8d723eULL, 0x000fe400020006ffULL,
0x000054108c5c7816ULL, 0x000fe40000000091ULL, 0x00000008ff977819ULL, 0x000fe4000001164cULL,
0x000000ff648c7812ULL, 0x000fc400078ec0ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x00005410924c7816ULL, 0x000fe40000000095ULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x000000ff87877812ULL, 0x000fe400078ec0ffULL,
0x0000541081647816ULL, 0x000fe2000000008fULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x000000ff90907812ULL, 0x000fc400078ec0ffULL, 0x000000ff4f957812ULL, 0x000fe400078ec0ffULL,
0x00000008ff867819ULL, 0x000fe20000011686ULL, 0x0000004c2c0c723cULL, 0x000fe2000000180cULL,
0x00000008ff817819ULL, 0x000fe40000011666ULL, 0x00000008ff7b7819ULL, 0x000fe4000001167bULL,
0x00000069ff5d723eULL, 0x000fe400020006ffULL, 0x00005410964f7816ULL, 0x000fc4000000008eULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x0000541093667816ULL, 0x000fe4000000007dULL,
0x00000099ff69723eULL, 0x000fe200020006ffULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000097ff92723eULL, 0x000fe400020006ffULL,
0x00000095ff8e723eULL, 0x000fe200020006ffULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x00000086ff86723eULL, 0x000fc400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000068ff7d723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x000054106b687816ULL, 0x000fe40000000087ULL,
0x000054105d5d7816ULL, 0x000fc40000000090ULL, 0x000054108d5e7816ULL, 0x000fe4000000005eULL,
0x00005410925f7816ULL, 0x000fe4000000005fULL, 0x0000541065657816ULL, 0x000fe2000000008eULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x0000541086677816ULL, 0x000fe40000000067ULL,
0x0000541069697816ULL, 0x000fe4000000008cULL, 0x00005410816a7816ULL, 0x000fe2000000006aULL,
0x0000005e3444723cULL, 0x000fe20000001844ULL, 0x000054107b6b7816ULL, 0x000fe2000000007dULL,
0x00017000727b7836ULL, 0x000fc80000000000ULL, 0x000000643448723cULL, 0x000fe20000001848ULL,
0x000000107c7d7824ULL, 0x000fca00078e027bULL, 0x000000663450723cULL, 0x000fec0000001850ULL,
0x000000683428723cULL, 0x000fec0000001828ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x000000106f347824ULL, 0x000fc400078e0282ULL,
0x0000001071827824ULL, 0x000fc600078e0282ULL, 0x0000005e2c18723cULL, 0x000fe20000001818ULL,
0x000000003434783bULL, 0x000e6a0000000200ULL, 0x000000642c1c723cULL, 0x000fec000000181cULL,
0x000000662c20723cULL, 0x000fec0000001820ULL, 0x000000682c30723cULL, 0x000fec0000001830ULL,
0x0000006a2c38723cULL, 0x000fe20000001838ULL, 0x00000000822c783bULL, 0x0006a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x084fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x080fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x000000107a5c7824ULL, 0x000fe200078e027bULL, 0x000000007d4c783bULL, 0x000f2a0000004200ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x00000018ff657819ULL, 0x010fe4000001164eULL,
0x00000010ff957819ULL, 0x000fe4000001164cULL, 0x00000018ff677819ULL, 0x000fc4000001164fULL,
0x000000ff5d987812ULL, 0x028fe400078ec0ffULL, 0x0000ffff4c6a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001165dULL, 0x00000010ff8c7819ULL, 0x100fe4000001165eULL,
0x000000ff5e997812ULL, 0x000fe400078ec0ffULL, 0x00000018ff977819ULL, 0x000fc4000001165eULL,
0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff967819ULL, 0x000fe4000001164dULL,
0x00000010ff647819ULL, 0x100fe4000001165fULL, 0x000000ff5f9a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff687819ULL, 0x000fe4000001165fULL, 0x0000ffff5f817812ULL, 0x000fc400078ec0ffULL,
0x00000065ff5e723eULL, 0x000fe400020006ffULL, 0x00000067ff5f723eULL, 0x000fe400020006ffULL,
0x00000098ff65723eULL, 0x000fe400020006ffULL, 0x000000ff95957812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8e7819ULL, 0x000fe4000001164eULL, 0x0000006bff67723eULL, 0x000fc400020006ffULL,
0x00000008ff987819ULL, 0x000fe4000001166aULL, 0x0000ffff4e927812ULL, 0x000fe400078ec0ffULL,
0x00000099ff6b723eULL, 0x000fe400020006ffULL, 0x000000ff4d937812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8f7819ULL, 0x000fe4000001164dULL, 0x000000ff96997812ULL, 0x000fc400078ec0ffULL,
0x000000ff4c947812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x00000095ff96723eULL, 0x000fe400020006ffULL, 0x00000098ff95723eULL, 0x000fe400020006ffULL,
0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff907819ULL, 0x000fc4000001164cULL,
0x00000008ff987819ULL, 0x000fe40000011692ULL, 0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4e8d7812ULL, 0x000fe400078ec0ffULL, 0x00000094ff94723eULL, 0x000fe400020006ffULL,
0x00000008ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff4e7819ULL, 0x000fc4000001165cULL,
0x0000008eff92723eULL, 0x000fe400020006ffULL, 0x00000010ff917819ULL, 0x000fe4000001164fULL,
0x000000ff4f697812ULL, 0x000fe400078ec0ffULL, 0x00000098ff8e723eULL, 0x000fe400020006ffULL,
0x00000010ff4f7819ULL, 0x000fe4000001165dULL, 0x00000097ff6a723eULL, 0x000fc400020006ffULL,
0x00000008ff987819ULL, 0x000fe4000001164cULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x0000004dff97723eULL, 0x000fe400020006ffULL, 0x00005410944c7816ULL, 0x000fe40000000096ULL,
0x000000ff5c867812ULL, 0x000fe400078ec0ffULL, 0x00000018ff827819ULL, 0x000fc4000001165cULL,
0x000000ff4e947812ULL, 0x000fe400078ec0ffULL, 0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f967812ULL, 0x000fe400078ec0ffULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00005410974f7816ULL, 0x000fe4000000008fULL, 0x00000094ff8f723eULL, 0x000fc400020006ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000008ff947819ULL, 0x000fe4000001165cULL,
0x0000ffff5d877812ULL, 0x000fe400078ec0ffULL, 0x000054108d5c7816ULL, 0x000fe40000000092ULL,
0x000000ff648d7812ULL, 0x000fe400078ec0ffULL, 0x00000093ff93723eULL, 0x000fc400020006ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x00000099ff99723eULL, 0x000fe400020006ffULL, 0x00000094ff94723eULL, 0x000fe400020006ffULL,
0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL, 0x0000541086647816ULL, 0x000fc4000000008fULL,
0x000000ff91917812ULL, 0x000fe400078ec0ffULL, 0x00000008ff877819ULL, 0x000fe40000011687ULL,
0x00000008ff867819ULL, 0x000fe40000011666ULL, 0x00000008ff817819ULL, 0x000fe40000011681ULL,
0x00000069ff5d723eULL, 0x000fe400020006ffULL, 0x00005410934d7816ULL, 0x000fc40000000099ULL,
0x00005410954e7816ULL, 0x000fe40000000090ULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x0000541094667816ULL, 0x000fe20000000082ULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x0000009aff69723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x00000098ff93723eULL, 0x000fe200020006ffULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x00000096ff90723eULL, 0x000fc400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x0000008dff8d723eULL, 0x000fe200020006ffULL, 0x0000004c2c0c723cULL, 0x004fe2000000180cULL,
0x00000068ff82723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x000054106b687816ULL, 0x000fc4000000008cULL, 0x000054105d5d7816ULL, 0x000fe40000000091ULL,
0x000054108e5e7816ULL, 0x000fe4000000005eULL, 0x00005410935f7816ULL, 0x000fe4000000005fULL,
0x0000541065657816ULL, 0x000fe20000000090ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x0000541087677816ULL, 0x000fe40000000067ULL, 0x0000541069697816ULL, 0x000fc4000000008dULL,
0x00005410866a7816ULL, 0x000fe2000000006aULL, 0x0000005e3444723cULL, 0x000fe20000001844ULL,
0x00005410816b7816ULL, 0x000fca0000000082ULL, 0x000000643448723cULL, 0x000fec0000001848ULL,
0x000000663450723cULL, 0x000fec0000001850ULL, 0x000000683428723cULL, 0x000fec0000001828ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x0000005c2c14723cULL, 0x000fe20000001814ULL,
0x0000000277347824ULL, 0x000fc400078e00ffULL, 0x00000001ff377424ULL, 0x000fc600078e00ffULL,
0xfffffff834357812ULL, 0x000fe200078ec0ffULL, 0x0000000863347824ULL, 0x000fe200078e0208ULL,
0x0000005e2c18723cULL, 0x000fe60000001818ULL, 0x0000000108367824ULL, 0x000fe400078e0235ULL,
0x01a6c837343479a7ULL, 0x0002a2000850003fULL, 0x000000642c1c723cULL, 0x000fec000000181cULL,
0x000000662c20723cULL, 0x000fe20000001820ULL, 0x01a6903736ff79a7ULL, 0x0003ea000850003fULL,
0x000000682c30723cULL, 0x000fec0000001830ULL, 0x0000006a2c38723cULL, 0x002fde0000001838ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x00000000002c7805ULL, 0x000fe20000015200ULL,
0x00000035060075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fcc0000015200ULL,
0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000372e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000010058827824ULL, 0x000fc800078e0261ULL,
0x000000c0822f7836ULL, 0x000fca0000000000ULL, 0x000000602f2d7812ULL, 0x000fca00078ec0ffULL,
0x000000015a4c7824ULL, 0x000fe200078e022dULL, 0x0000000000f89947ULL, 0x000fec0003800000ULL,
0x0000002f742c7248ULL, 0x000fe20007fe0000ULL, 0x00000010772d7824ULL, 0x000fc800078e00ffULL,
0x000000012c2c7824ULL, 0x000fe200078e0a2fULL, 0x000000102d2f7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff2d7819ULL, 0x000fe40000011609ULL, 0x0000002c2f2c7248ULL, 0x000fc60007fe0000ULL,
0x000000012d2e7824ULL, 0x140fe400078e022fULL, 0x000000012c2c7824ULL, 0x100fe400078e0a2fULL,
0x000000042d347836ULL, 0x000fe40000000000ULL, 0x000000082d357836ULL, 0x000fe20000000000ULL,
0x0000002c2d00720cULL, 0x080fe20003f86070ULL, 0x0000000c2d377836ULL, 0x000fe20000000000ULL,
0x0000002c3400720cULL, 0x080fe20003f66070ULL, 0x000000012e2d7824ULL, 0x000fe200078e024cULL,
0x0000002c3500720cULL, 0x080fe20003f46070ULL, 0x0000000134367824ULL, 0x000fe200078e022fULL,
0x0000002c3700720cULL, 0x000fe20003f06070ULL, 0x000000012e347824ULL, 0x000fc400078e0209ULL,
0x000000082e4d7824ULL, 0x000fe400078e00ffULL, 0x000000802d2c7825ULL, 0x000fc600078e00ffULL,
0xfffffff84d4e7812ULL, 0x000fe200078ee234ULL, 0x0000000135357824ULL, 0x000fe400078e022fULL,
0x00000001362e7824ULL, 0x040fe400078e0209ULL, 0x00000008364f7824ULL, 0x040fe400078e00ffULL,
0x0000000136367824ULL, 0x000fe400078e024cULL, 0x00000001375d7824ULL, 0x000fe200078e022fULL,
0x0000006d2c2f7212ULL, 0x000fe200078efcffULL, 0x00000001354d7824ULL, 0x040fe200078e0209ULL,
0xfffffff84f5c7812ULL, 0x000fe200078ee22eULL, 0x00000008355e7824ULL, 0x000fe200078e00ffULL,
0x0000002f8a2c7210ULL, 0x000fe20007fbe0ffULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x00000001352e7824ULL, 0x100fe400078e024cULL, 0x000000015d347824ULL, 0x000fe200078e024cULL,
0xfffffff85e4c7812ULL, 0x000fe200078ee24dULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000006d364d7212ULL, 0x000fc600078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000006d2e4f7212ULL, 0x000fc600078efcffULL, 0x000000018b2d7824ULL, 0x000fe200028e062dULL,
0x0000004d8a367210ULL, 0x000fe20007fbe0ffULL, 0x000000015d5e7824ULL, 0x040fe200078e0209ULL,
0x0000006d344d7212ULL, 0x000fe200078efcffULL, 0x000000085d5d7824ULL, 0x000fe400078e00ffULL,
0x000000018b377824ULL, 0x040fe200028e0637ULL, 0x0000004f8a2e7210ULL, 0x000fe20007fbe0ffULL,
0x000000105c4f7824ULL, 0x100fe200078e027bULL, 0x0000004d8a347210ULL, 0x000fe20007fde0ffULL,
0x000000104e4d7824ULL, 0x000fe200078e027bULL, 0xfffffff85d5e7812ULL, 0x000fe200078ee25eULL,
0x000000018b2f7824ULL, 0x000fc400028e062fULL, 0x000000104c5d7824ULL, 0x000fe200078e027bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c4d7faeULL, 0x0003e2000e101c46ULL,
0x000000018b357824ULL, 0x000fe400030e0635ULL, 0x000000105e5f7824ULL, 0x000fe200078e027bULL,
0x00000000364f7faeULL, 0x0003e8000d901c46ULL, 0x000000002e5d7faeULL, 0x0003e8000d101c46ULL,
0x00000000345f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x00000010772c7824ULL, 0x000fca00078e00ffULL, 0x000000102c2c7812ULL, 0x000fc800078ec0ffULL,
0x0000002c092c7211ULL, 0x000fca00078fe8ffULL, 0x000000082c2f7836ULL, 0x000fe40000000000ULL,
0x000000042c367836ULL, 0x000fe40000000000ULL, 0x000000012c2d7824ULL, 0x140fe400078e0209ULL,
0x000000082c4e7824ULL, 0x040fe400078e00ffULL, 0x000000012f357824ULL, 0x040fe400078e0209ULL,
0x000000082f5e7824ULL, 0x000fe200078e00ffULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee22dULL,
0x000000012c347824ULL, 0x000fc400078e024cULL, 0x00000001362e7824ULL, 0x040fe200078e0209ULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee235ULL, 0x0000000836377824ULL, 0x000fe400078e00ffULL,
0x0000000c2c2d7836ULL, 0x000fe40000000000ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0xfffffff8375c7812ULL, 0x000fc600078ee22eULL, 0x0000000136367824ULL, 0x100fe200078e024cULL,
0x0000006d344d7212ULL, 0x000fe200078efcffULL, 0x000000012f2c7824ULL, 0x100fe400078e024cULL,
0x000000012d2e7824ULL, 0x040fe200078e024cULL, 0x0000004d8a347210ULL, 0x000fe20007f1e0ffULL,
0x000000012d4c7824ULL, 0x040fe400078e0209ULL, 0x000000082d4f7824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff84f4c7812ULL, 0x000fe200078ee24cULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x0000006d365d7212ULL, 0x000fc600078efcffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000006d2c4f7212ULL, 0x080fe400078efcffULL,
0x0000005d8a367210ULL, 0x000fe20007f5e0ffULL, 0x000000018b357824ULL, 0x040fe200000e0635ULL,
0x0000006d2e4d7212ULL, 0x000fe200078efcffULL, 0x000000105e5d7824ULL, 0x000fe200078e027bULL,
0x0000004f8a2c7210ULL, 0x000fe20007f1e0ffULL, 0x000000018b377824ULL, 0x000fe200010e0637ULL,
0x0000004d8a2e7210ULL, 0x000fe20007f7e0ffULL, 0x000000104e4d7824ULL, 0x000fc400078e027bULL,
0x000000105c4f7824ULL, 0x000fe400078e027bULL, 0x000000018b2d7824ULL, 0x040fe200000e062dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000344d7faeULL, 0x0003e2000b901c46ULL,
0x000000018b2f7824ULL, 0x000fe400018e062fULL, 0x000000104c5f7824ULL, 0x000fe200078e027bULL,
0x00000000364f7faeULL, 0x0003e8000b901c46ULL, 0x000000002c5d7faeULL, 0x0003e8000b901c46ULL,
0x000000002e5f7faeULL, 0x0003e4000b901c46ULL, 0x0000000260607836ULL, 0x000fe20000000000ULL,
0x0000000804087890ULL, 0x000fe2000fffe03fULL, 0xffffffffff817424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x000000756000720cULL, 0x000fca0003f06070ULL,
0x00000000ff0079b0ULL, 0x000ff00008000a48ULL, 0x00009200ff2c8b82ULL, 0x000e620000000a00ULL,
0x00000001602f8824ULL, 0x000fe400078e0207ULL, 0x00000008772e7824ULL, 0x000fc400078e00ffULL,
0x000000042f2c8825ULL, 0x002fca00078e002cULL, 0x000000062c818981ULL, 0x000322000c1e1900ULL,
0xfffffff02e2f7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff357424ULL, 0x000fc600078e00ffULL,
0x0001a6a82f867810ULL, 0x000fe20007ffe008ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000835868679a7ULL, 0x0004e2000850003fULL, 0x01a64835802c79a7ULL, 0x002464000850003fULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x01a6482d800075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x004fce0000015200ULL, 0x000000342e377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e2fULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6482d800075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000020772c7824ULL, 0x000fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fc600078e00ffULL,
0xffffff802c2d7812ULL, 0x000fc800078ec0ffULL, 0x00000100082c7810ULL, 0x000fc80007ffe02dULL,
0x0000002c702c7210ULL, 0x000fca0007ffe06dULL, 0x01a000002c2e7984ULL, 0x000e680000000800ULL,
0x01a200002c2d7984ULL, 0x000b620000000800ULL, 0x000000852e00720bULL, 0x002fda0003f1d000ULL,
0x00000000002f7806ULL, 0x000fc800000e0100ULL, 0x000000ff2f00720cULL, 0x000fda0003f05270ULL,
0x00000004009c8947ULL, 0x02cfea0003800000ULL, 0x000000025b2c7836ULL, 0x000fe20000000000ULL,
0x000000852e00720bULL, 0x000fc80003f14000ULL, 0x000000772c00720cULL, 0x000fda0003f45270ULL,
0x000000807734a824ULL, 0x000fe200078e0208ULL, 0x000000852e2ca209ULL, 0x000fc80007810000ULL,
0x000000347035a210ULL, 0x000fe40007ffe06dULL, 0x0000000000347806ULL, 0x000fc600000e0100ULL,
0x01a4002c3500a388ULL, 0x0003e20000000800ULL, 0x000000ff3400720cULL, 0x000fda0003f05270ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x000000852e2c7209ULL, 0x000fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x000000852c2c7221ULL, 0x000fe20000010100ULL, 0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000034ff7812ULL, 0x000fe2000788c0ffULL, 0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL,
0x0000002c00357308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff2c7819ULL, 0x002fcc0000011609ULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x000000542c547220ULL, 0x042fe20000410000ULL, 0x000000552c557220ULL, 0x040fe20000410000ULL,
0x0000003c2c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d2c3d7220ULL, 0x040fe20000410000ULL,
0x000000402c407220ULL, 0x040fe20000410000ULL, 0x000000412c417220ULL, 0x040fe20000410000ULL,
0x000000442c447220ULL, 0x040fe20000410000ULL, 0x000000452c457220ULL, 0x040fe20000410000ULL,
0x000000482c487220ULL, 0x040fe20000410000ULL, 0x000000492c497220ULL, 0x040fe20000410000ULL,
0x000000502c507220ULL, 0x040fe20000410000ULL, 0x000000512c517220ULL, 0x040fe20000410000ULL,
0x000000282c287220ULL, 0x040fe20000410000ULL, 0x000000292c297220ULL, 0x040fe20000410000ULL,
0x000000242c247220ULL, 0x040fe20000410000ULL, 0x000000252c257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x00000008092c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x000000562c567220ULL, 0x042fe20000410000ULL,
0x000000572c577220ULL, 0x040fe20000410000ULL, 0x0000003e2c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f2c3f7220ULL, 0x040fe20000410000ULL, 0x000000422c427220ULL, 0x040fe20000410000ULL,
0x000000432c437220ULL, 0x040fe20000410000ULL, 0x000000462c467220ULL, 0x040fe20000410000ULL,
0x000000472c477220ULL, 0x040fe20000410000ULL, 0x0000004a2c4a7220ULL, 0x040fe20000410000ULL,
0x0000004b2c4b7220ULL, 0x040fe20000410000ULL, 0x000000522c527220ULL, 0x040fe20000410000ULL,
0x000000532c537220ULL, 0x040fe20000410000ULL, 0x0000002a2c2a7220ULL, 0x040fe20000410000ULL,
0x0000002b2c2b7220ULL, 0x040fe20000410000ULL, 0x000000262c267220ULL, 0x040fe20000410000ULL,
0x000000272c277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x00000010092c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x0000000c2c0c7220ULL, 0x042fe20000410000ULL, 0x0000000d2c0d7220ULL, 0x040fe20000410000ULL,
0x000000102c107220ULL, 0x040fe20000410000ULL, 0x000000112c117220ULL, 0x040fe20000410000ULL,
0x000000142c147220ULL, 0x040fe20000410000ULL, 0x000000152c157220ULL, 0x040fe20000410000ULL,
0x000000182c187220ULL, 0x040fe20000410000ULL, 0x000000192c197220ULL, 0x040fe20000410000ULL,
0x0000001c2c1c7220ULL, 0x040fe20000410000ULL, 0x0000001d2c1d7220ULL, 0x040fe20000410000ULL,
0x000000202c207220ULL, 0x040fe20000410000ULL, 0x000000212c217220ULL, 0x040fe20000410000ULL,
0x000000302c307220ULL, 0x040fe20000410000ULL, 0x000000312c317220ULL, 0x040fe20000410000ULL,
0x000000382c387220ULL, 0x040fe20000410000ULL, 0x000000392c397220ULL, 0x000fce0000410000ULL,
0x0000003584847220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x00000018092c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x000e6400000e0000ULL,
0x0000000e2c0e7220ULL, 0x042fe20000410000ULL, 0x0000000f2c0f7220ULL, 0x040fe20000410000ULL,
0x000000122c127220ULL, 0x040fe20000410000ULL, 0x000000132c137220ULL, 0x040fe20000410000ULL,
0x000000162c167220ULL, 0x040fe20000410000ULL, 0x000000172c177220ULL, 0x040fe20000410000ULL,
0x0000001a2c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b2c1b7220ULL, 0x040fe20000410000ULL,
0x0000001e2c1e7220ULL, 0x040fe20000410000ULL, 0x0000001f2c1f7220ULL, 0x040fe20000410000ULL,
0x000000222c227220ULL, 0x040fe20000410000ULL, 0x000000232c237220ULL, 0x040fe20000410000ULL,
0x000000322c327220ULL, 0x040fe20000410000ULL, 0x000000332c337220ULL, 0x040fe20000410000ULL,
0x0000003a2c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b2c3b7220ULL, 0x000fce0000410000ULL,
0x000000342fff7212ULL, 0x000fe200078030ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x000000852e857209ULL, 0x000fd60007810000ULL, 0x800000852e2e0221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL,
0x0000002e00040308ULL, 0x000ea40000000800ULL, 0x000000042d2d0220ULL, 0x004fce0000410000ULL,
0x000000842d847221ULL, 0x000fce0000010000ULL, 0x00000000002c7805ULL, 0x002fce0000015200ULL,
0x00000089ff0075a7ULL, 0x000e640008000145ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000352e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000089ff0075a7ULL, 0x000e640008000145ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00009910342c7816ULL, 0x000fe200000000ffULL,
0x00000400772d7824ULL, 0x000fe400078e00ffULL, 0x000000106e4c7824ULL, 0x000fe200078e0283ULL,
0x000000ff2c00720cULL, 0x000fe40003f05270ULL, 0xfffff0002d2d7812ULL, 0x000fc800078ec0ffULL,
0x0001400008807810ULL, 0x000fca0007ffe02dULL, 0x000000107f347824ULL, 0x100fe400078e0280ULL,
0x000000107e2c7824ULL, 0x000fe200078e0280ULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff2e7819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000000ffULL,
0x000000082e027836ULL, 0x000fe20000000000ULL, 0x00005410002d7816ULL, 0x000fe20000000000ULL,
0x000000102e367836ULL, 0x000fe40000000000ULL, 0x000000182e4e7836ULL, 0x000fe40000000000ULL,
0x00001f022d027589ULL, 0x0002a800000e0000ULL, 0x00001f362d057589ULL, 0x0002e800000e0000ULL,
0x00001f2e2d037589ULL, 0x00026800000e0000ULL, 0x00001f4e2d007589ULL, 0x00026400000e0000ULL,
0x000000003434783bULL, 0x002e680000000200ULL, 0x000000002c2c783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x084fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x088fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x00000010735c7824ULL, 0x000fe200078e0283ULL,
0x000000004c4c783bULL, 0x000f6a0000004200ULL, 0x000000005c5c783bULL, 0x000f640000004200ULL,
0x00000018ff677819ULL, 0x028fe4000001164fULL, 0x00000010ff917819ULL, 0x000fc4000001164cULL,
0x00000018ff657819ULL, 0x000fe4000001164eULL, 0x00000018ff6b7819ULL, 0x004fe4000001165dULL,
0x0000ffff4d8c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5d947812ULL, 0x000fe400078ec0ffULL,
0x000000ff5e957812ULL, 0x000fe400078ec0ffULL, 0x00000010ff927819ULL, 0x000fc4000001164dULL,
0x0000ffff4e8d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x100fe4000001165fULL,
0x000000ff5f967812ULL, 0x040fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe4000001165fULL,
0x0000ffff5f737812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4c6a7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff887819ULL, 0x100fe4000001165eULL, 0x00000018ff937819ULL, 0x000fe4000001165eULL,
0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL, 0x00000067ff5f723eULL, 0x000fe400020006ffULL,
0x000000ff4c907812ULL, 0x000fe400078ec0ffULL, 0x00000065ff5e723eULL, 0x000fc400020006ffULL,
0x0000006bff67723eULL, 0x000fe400020006ffULL, 0x000000ff91917812ULL, 0x000fe400078ec0ffULL,
0x00000094ff65723eULL, 0x000fe400020006ffULL, 0x00000095ff6b723eULL, 0x000fe400020006ffULL,
0x00000008ff8c7819ULL, 0x000fe4000001168cULL, 0x00000018ff8a7819ULL, 0x000fc4000001164cULL,
0x000000ff4d8f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fe4000001164dULL,
0x000000ff92947812ULL, 0x000fe400078ec0ffULL, 0x00000008ff957819ULL, 0x000fe4000001168dULL,
0x00000010ff4d7819ULL, 0x000fe4000001164eULL, 0x0000ffff4f4c7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff927819ULL, 0x000fe4000001166aULL, 0x000000ff4e897812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f697812ULL, 0x000fe400078ec0ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000093ff6a723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fc400020006ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001165cULL, 0x0000008cff93723eULL, 0x000fe400020006ffULL,
0x00000010ff8e7819ULL, 0x000fe4000001164fULL, 0x00000095ff8c723eULL, 0x000fe400020006ffULL,
0x00000010ff4f7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d837812ULL, 0x000fc400078ec0ffULL,
0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff957819ULL, 0x000fe4000001164cULL,
0x000000ff5c7f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001165cULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000069ff5d723eULL, 0x000fc400020006ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00005410904c7816ULL, 0x000fe40000000091ULL,
0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x00000096ff69723eULL, 0x000fe400020006ffULL,
0x000000ff4e907812ULL, 0x000fe400078ec0ffULL, 0x000000ff8e967812ULL, 0x000fc400078ec0ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x0000004dff8e723eULL, 0x000fe400020006ffULL,
0x00005410924e7816ULL, 0x000fe4000000008aULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000008ff8a7819ULL, 0x000fc4000001165cULL,
0x00005410895c7816ULL, 0x000fe4000000008eULL, 0x000000ff64897812ULL, 0x000fe400078ec0ffULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fc400020006ffULL,
0x000000ff88887812ULL, 0x000fe400078ec0ffULL, 0x000054107f647816ULL, 0x000fe40000000090ULL,
0x000000ff4f917812ULL, 0x000fe400078ec0ffULL, 0x00000008ff837819ULL, 0x000fe40000011683ULL,
0x00000008ff7f7819ULL, 0x000fe40000011666ULL, 0x00000008ff737819ULL, 0x000fc40000011673ULL,
0x000054108f4d7816ULL, 0x000fe40000000094ULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x000054108a667816ULL, 0x000fe4000000007eULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x0000004c3454723cULL, 0x002fe20000001854ULL, 0x00000096ff8d723eULL, 0x000fe400020006ffULL,
0x00000095ff8f723eULL, 0x000fc400020006ffULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x0000004c2c0c723cULL, 0x000fe2000000180cULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000068ff7e723eULL, 0x000fe400020006ffULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x000054106b687816ULL, 0x000fe40000000088ULL, 0x00005410934f7816ULL, 0x000fe4000000008bULL,
0x000054105d5d7816ULL, 0x000fe4000000008dULL, 0x000054108c5e7816ULL, 0x000fe4000000005eULL,
0x000054108f5f7816ULL, 0x000fe2000000005fULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x0000541065657816ULL, 0x000fc40000000091ULL, 0x0000541083677816ULL, 0x000fe40000000067ULL,
0x0000541069697816ULL, 0x000fe20000000089ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x000054107f6a7816ULL, 0x000fe4000000006aULL, 0x00005410736b7816ULL, 0x000fe2000000007eULL,
0x0001600072737836ULL, 0x000fe40000000000ULL, 0x0000005e3444723cULL, 0x000fe40000001844ULL,
0x000000107c4c7824ULL, 0x000fc800078e0273ULL, 0x000000643448723cULL, 0x000fec0000001848ULL,
0x000000663450723cULL, 0x000fec0000001850ULL, 0x000000683428723cULL, 0x000fec0000001828ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x000000106f347824ULL, 0x000fc400078e0280ULL, 0x0000001071807824ULL, 0x000fc600078e0280ULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x000000003434783bULL, 0x000e6a0000000200ULL,
0x0000005e2c18723cULL, 0x000fec0000001818ULL, 0x000000642c1c723cULL, 0x000fec000000181cULL,
0x000000662c20723cULL, 0x000fec0000001820ULL, 0x000000682c30723cULL, 0x000fec0000001830ULL,
0x0000006a2c38723cULL, 0x000fe20000001838ULL, 0x00000000802c783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x080fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x000000107a5c7824ULL, 0x000fe200078e0273ULL, 0x000000004c4c783bULL, 0x000f6a0000004200ULL,
0x000000005c5c783bULL, 0x000f640000004200ULL, 0x00000018ff657819ULL, 0x024fe4000001164eULL,
0x00000010ff8f7819ULL, 0x000fc4000001164dULL, 0x0000ffff4c697812ULL, 0x000fe400078ec0ffULL,
0x000000ff5d907812ULL, 0x008fe400078ec0ffULL, 0x00000010ff7f7819ULL, 0x100fe4000001165eULL,
0x00000018ff917819ULL, 0x000fe4000001165eULL, 0x000000ff5e927812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5e667812ULL, 0x000fc400078ec0ffULL, 0x00000065ff5e723eULL, 0x000fe400020006ffULL,
0x00000090ff65723eULL, 0x000fe400020006ffULL, 0x000000ff4d897812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f6a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8f907812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8e7819ULL, 0x000fc4000001164cULL, 0x000000ff4c8a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff837819ULL, 0x000fe4000001164cULL, 0x00000018ff887819ULL, 0x000fe4000001164dULL,
0x0000ffff4d8d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8b7819ULL, 0x100fe4000001164fULL,
0x00000018ff677819ULL, 0x000fc4000001164fULL, 0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8c7819ULL, 0x000fe4000001164eULL, 0x0000ffff4e4d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4f7819ULL, 0x100fe4000001165dULL, 0x00000018ff6b7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d7e7812ULL, 0x000fc400078ec0ffULL, 0x000000ff4e807812ULL, 0x000fe400078ec0ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x0000006aff5d723eULL, 0x000fe400020006ffULL,
0x00000008ff8f7819ULL, 0x000fe40000011669ULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000010ff4e7819ULL, 0x000fc4000001165cULL, 0x00000091ff6a723eULL, 0x000fe400020006ffULL,
0x000000ff8b917812ULL, 0x000fe400078ec0ffULL, 0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8b7819ULL, 0x000fe4000001164dULL, 0x000000ff5c7c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7a7819ULL, 0x000fc4000001165cULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x00005410894d7816ULL, 0x000fe40000000090ULL,
0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4e897812ULL, 0x000fc400078ec0ffULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x00000010ff647819ULL, 0x100fe4000001165fULL,
0x00000018ff687819ULL, 0x000fe4000001165fULL, 0x000000ff5f937812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5f727812ULL, 0x000fc400078ec0ffULL, 0x000054108f4e7816ULL, 0x000fe40000000083ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000067ff5f723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fc400020006ffULL, 0x00000008ff837819ULL, 0x000fe4000001165cULL,
0x0000006bff67723eULL, 0x000fe400020006ffULL, 0x00000092ff6b723eULL, 0x000fe400020006ffULL,
0x00005410805c7816ULL, 0x000fe4000000008cULL, 0x00000008ff927819ULL, 0x000fe4000001164cULL,
0x000000ff64807812ULL, 0x000fc400078ec0ffULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x000054108a4c7816ULL, 0x000fe4000000008eULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL, 0x000054107c647816ULL, 0x000fe20000000089ULL,
0x0000004c3454723cULL, 0x002fe20000001854ULL, 0x00000008ff8d7819ULL, 0x000fc4000001168dULL,
0x000000ff4f8a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7e7819ULL, 0x000fe2000001167eULL,
0x0000004c2c0c723cULL, 0x000fe2000000180cULL, 0x00000008ff7c7819ULL, 0x000fe40000011666ULL,
0x00000008ff727819ULL, 0x000fe40000011672ULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x0000541083667816ULL, 0x000fc4000000007aULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000093ff69723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000092ff92723eULL, 0x000fc400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000068ff7a723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x00000072ff72723eULL, 0x000fc400020006ffULL, 0x000054106b687816ULL, 0x000fe4000000007fULL,
0x000054108d4f7816ULL, 0x000fe40000000088ULL, 0x000054105d5d7816ULL, 0x000fe40000000091ULL,
0x000054108b5e7816ULL, 0x000fe4000000005eULL, 0x00005410925f7816ULL, 0x000fe2000000005fULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x0000541065657816ULL, 0x000fc4000000008aULL,
0x000054107e677816ULL, 0x000fe40000000067ULL, 0x0000541069697816ULL, 0x000fe20000000080ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x000054107c6a7816ULL, 0x000fe4000000006aULL,
0x00005410726b7816ULL, 0x000fc6000000007aULL, 0x0000005e3444723cULL, 0x000fec0000001844ULL,
0x000000643448723cULL, 0x000fec0000001848ULL, 0x000000663450723cULL, 0x000fec0000001850ULL,
0x000000683428723cULL, 0x000fec0000001828ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x0000004e2c10723cULL, 0x000fe20000001810ULL, 0x0000000277347824ULL, 0x000fc400078e00ffULL,
0x00000001ff377424ULL, 0x000fc600078e00ffULL, 0xfffffff834357812ULL, 0x000fe200078ec0ffULL,
0x0000005c2c14723cULL, 0x000fe80000001814ULL, 0x0000000108367824ULL, 0x000fe400078e0235ULL,
0x00000037063479a7ULL, 0x000262000850003fULL, 0x0000005e2c18723cULL, 0x000fec0000001818ULL,
0x000000642c1c723cULL, 0x000fe2000000181cULL, 0x01a6983736ff79a7ULL, 0x0003ea000850003fULL,
0x000000662c20723cULL, 0x000fec0000001820ULL, 0x000000682c30723cULL, 0x000fec0000001830ULL,
0x0000006a2c38723cULL, 0x002fde0000001838ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x00000035060075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000001582d7836ULL, 0x000fca0000000000ULL, 0x000000622d00720cULL, 0x000fda0003f06070ULL,
0x0000000400e80947ULL, 0x000fea0003800000ULL, 0x00009000ff2c7b82ULL, 0x000e620000000a00ULL,
0x00000002582f7836ULL, 0x000fe20000000000ULL, 0x0000850000087ab9ULL, 0x000fe20000000800ULL,
0x0000010082357836ULL, 0x000fe40000000000ULL, 0x00000008812e7c24ULL, 0x010fe2000f8e02ffULL,
0x000000622f00720cULL, 0x000fe40003f06070ULL, 0x00000060352f7812ULL, 0x000fe200078ec0ffULL,
0x000000802e377824ULL, 0x000fc800078e00ffULL, 0x000000015a4c7824ULL, 0x000fe400078e022fULL,
0x00000080372c7825ULL, 0x002fc800078e002cULL, 0x0000000000f88947ULL, 0x000fea0003800000ULL,
0x00000035742e7248ULL, 0x000fe20007fe0000ULL, 0x00000010772f7824ULL, 0x000fe200078e00ffULL,
0x00000003ff347819ULL, 0x000fc60000011609ULL, 0x000000012e2e7824ULL, 0x000fe200078e0a35ULL,
0x000000102f2f7812ULL, 0x000fe200078ec0ffULL, 0x0000000434367836ULL, 0x000fe40000000000ULL,
0x0000000834377836ULL, 0x000fe20000000000ULL, 0x0000002e2f2e7248ULL, 0x000fe20007fe0000ULL,
0x0000000c344e7836ULL, 0x000fe40000000000ULL, 0x0000000134357824ULL, 0x100fe400078e022fULL,
0x000000012e2e7824ULL, 0x000fc400078e0a2fULL, 0x00000001374d7824ULL, 0x100fe400078e022fULL,
0x000000014e5d7824ULL, 0x100fe200078e022fULL, 0x0000002e3600720cULL, 0x0c0fe20003f66070ULL,
0x0000000136367824ULL, 0x000fe200078e022fULL, 0x0000002e3400720cULL, 0x080fe20003f86070ULL,
0x0000000135347824ULL, 0x000fe200078e024cULL, 0x0000002e3700720cULL, 0x080fe20003f46070ULL,
0x0000000835377824ULL, 0x040fe200078e00ffULL, 0x0000002e4e00720cULL, 0x000fe20003f06070ULL,
0x00000001352e7824ULL, 0x000fc400078e0209ULL, 0x00000001362f7824ULL, 0x140fe400078e0209ULL,
0x00000008365c7824ULL, 0x040fe200078e00ffULL, 0xfffffff8374e7812ULL, 0x000fe200078ee22eULL,
0x0000000136367824ULL, 0x000fe400078e024cULL, 0x000000014d357824ULL, 0x040fe200078e0209ULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee22fULL, 0x000000084d5e7824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee235ULL,
0x0000008034347825ULL, 0x000fc800078e00ffULL, 0x000000014d2e7824ULL, 0x100fe200078e024cULL,
0x0000006d364d7212ULL, 0x080fe200078efcffULL, 0x000000015d4c7824ULL, 0x000fe200078e024cULL,
0x0000006d344f7212ULL, 0x000fe200078efcffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000004d2c367210ULL, 0x000fe40007fde0ffULL, 0x0000004f2c347210ULL, 0x000fe20007fbe0ffULL,
0x000000804c4c7825ULL, 0x000fc800078e00ffULL, 0x000000015d5f7824ULL, 0x040fe200078e0209ULL,
0x0000006d4c4f7212ULL, 0x080fe200078efcffULL, 0x000000085d647824ULL, 0x000fe200078e00ffULL,
0x0000006d2e5d7212ULL, 0x000fe200078efcffULL, 0x000000012d357824ULL, 0x040fe400028e0635ULL,
0x000000012d377824ULL, 0x000fe200030e0637ULL, 0x0000005d2c2e7210ULL, 0x000fe20007fbe0ffULL,
0x000000105c657824ULL, 0x100fe200078e0273ULL, 0xfffffff864647812ULL, 0x000fe200078ee25fULL,
0x000000104e5f7824ULL, 0x100fe200078e0273ULL, 0x0000004f2c2c7210ULL, 0x000fe20007fde0ffULL,
0x000000105e4f7824ULL, 0x000fc400078e0273ULL, 0x000000012d2f7824ULL, 0x040fe200028e062fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000345f7faeULL, 0x0003e2000e101c46ULL,
0x0000001064737824ULL, 0x000fe400078e0273ULL, 0x000000012d2d7824ULL, 0x000fe200030e064dULL,
0x0000000036657faeULL, 0x0003e8000d901c46ULL, 0x000000002e4f7faeULL, 0x0003e8000d101c46ULL,
0x000000002c737faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x00000010772e7824ULL, 0x000fca00078e00ffULL, 0x000000102e2e7812ULL, 0x000fc800078ec0ffULL,
0x0000002e092f7211ULL, 0x000fca00078fe8ffULL, 0x000000012f2e7824ULL, 0x040fe400078e024cULL,
0x000000012f347824ULL, 0x040fe400078e0209ULL, 0x000000082f377824ULL, 0x000fe400078e00ffULL,
0x000000042f357836ULL, 0x000fe40000000000ULL, 0x000000082f4d7836ULL, 0x000fe20000000000ULL,
0xfffffff8374e7812ULL, 0x000fe200078ee234ULL, 0x0000000c2f5c7836ULL, 0x000fc40000000000ULL,
0x000000802e2e7825ULL, 0x000fc800078e00ffULL, 0x0000000135347824ULL, 0x140fe400078e024cULL,
0x0000000135377824ULL, 0x140fe400078e0209ULL, 0x00000008355e7824ULL, 0x000fe200078e00ffULL,
0x0000006d2e357212ULL, 0x000fe200078efcffULL, 0x000000014d367824ULL, 0x040fe400078e024cULL,
0x000000014d4f7824ULL, 0x040fe200078e0209ULL, 0x000000352c2e7210ULL, 0x000fe20007f1e0ffULL,
0x000000084d647824ULL, 0x000fc400078e00ffULL, 0x000000015c4d7824ULL, 0x040fe400078e0209ULL,
0x000000085c667824ULL, 0x040fe400078e00ffULL, 0x000000015c4c7824ULL, 0x000fe200078e024cULL,
0xfffffff85e5c7812ULL, 0x000fe200078ee237ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0xfffffff8645e7812ULL, 0x000fe400078ee24fULL, 0xfffffff866647812ULL, 0x000fe200078ee24dULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000006d345f7212ULL, 0x000fc600078efcffULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x0000006d365d7212ULL, 0x000fc600078efcffULL,
0x000000012d2f7824ULL, 0x040fe200000e062fULL, 0x0000006d4c4f7212ULL, 0x000fe200078efcffULL,
0x000000104e657824ULL, 0x100fe200078e0273ULL, 0x0000005f2c347210ULL, 0x000fe20007f1e0ffULL,
0x000000105c677824ULL, 0x100fe200078e0273ULL, 0x0000005d2c367210ULL, 0x000fe20007f5e0ffULL,
0x000000105e697824ULL, 0x000fe200078e0273ULL, 0x0000004f2c2c7210ULL, 0x000fe20007f7e0ffULL,
0x000000012d357824ULL, 0x040fe200000e0635ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e657faeULL, 0x0003e2000b901c46ULL, 0x000000012d377824ULL, 0x000fc400010e0637ULL,
0x0000001064737824ULL, 0x000fe200078e0273ULL, 0x0000000034677faeULL, 0x0003e2000b901c46ULL,
0x000000012d2d7824ULL, 0x000fc600018e064dULL, 0x0000000036697faeULL, 0x0003e8000b901c46ULL,
0x000000002c737faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000008772d7824ULL, 0x000fe400078e00ffULL, 0x000000205b2c7824ULL, 0x000fe200078e0208ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x000000082d2d7812ULL, 0x000fe200078ec0ffULL, 0x00000010592c7824ULL, 0x000fe200078e022cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000012d377824ULL, 0x000fe200078e022cULL,
0x00000034ff7e79a7ULL, 0x0002a60008500005ULL, 0x01a66834373479a7ULL, 0x0022e6000850003fULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x01a66835370075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c4d7210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09004d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x0000004d2e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a66835370075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x000000805b2c7824ULL, 0x000fe400078e0208ULL, 0x00000001ff347424ULL, 0x000fe400078e00ffULL,
0x000000ffff7a7224ULL, 0x000fe200078e0085ULL, 0x000001806d2d7810ULL, 0x000fca0007ffe02cULL,
0x00000001702d7824ULL, 0x000fca00078e022dULL, 0x01a000002d2c7984ULL, 0x000ee80000000800ULL,
0x01a200002d2f7984ULL, 0x000b620000000800ULL, 0x000000852c00720bULL, 0x008fda0003f1d000ULL,
0x0000000000357806ULL, 0x000fc800000e0100ULL, 0x000000ff3500720cULL, 0x000fda0003f05270ULL,
0x0000000400948947ULL, 0x026fea0003800000ULL, 0x000000035b2e7836ULL, 0x000fe20000000000ULL,
0x000000852c00720bULL, 0x0c0fe40003f14000ULL, 0x000000852c7a7209ULL, 0x000fe40007810000ULL,
0x000000772e00720cULL, 0x000fd20003f45270ULL, 0x00000000002e7806ULL, 0x000fc800000e0100ULL,
0x00000080772da824ULL, 0x000fe200078e0208ULL, 0x000000ff2e00720cULL, 0x000fc80003f05270ULL,
0x0000002d702da210ULL, 0x000fca0007ffe06dULL, 0x01a4007a2d00a388ULL, 0x0003e80000000800ULL,
0x0000000400508947ULL, 0x000fea0003800000ULL, 0x000000857a2d7221ULL, 0x002fe20000010100ULL,
0x000000ff2eff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff002eff7812ULL, 0x040fe2000784c0ffULL,
0x3fb8aa3b2d2d7820ULL, 0x000fe20000410000ULL, 0x00ff00002eff7812ULL, 0x040fe4000786c0ffULL,
0xff0000002eff7812ULL, 0x000fe2000788c0ffULL, 0x0000002d00377308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff347819ULL, 0x000fca0000011609ULL,
0x00001f34372d7589ULL, 0x006e6400000e0000ULL, 0x000000542d547220ULL, 0x042fe20000410000ULL,
0x000000552d557220ULL, 0x040fe20000410000ULL, 0x0000003c2d3c7220ULL, 0x040fe20000410000ULL,
0x0000003d2d3d7220ULL, 0x040fe20000410000ULL, 0x000000402d407220ULL, 0x040fe20000410000ULL,
0x000000412d417220ULL, 0x040fe20000410000ULL, 0x000000442d447220ULL, 0x040fe20000410000ULL,
0x000000452d457220ULL, 0x040fe20000410000ULL, 0x000000482d487220ULL, 0x040fe20000410000ULL,
0x000000492d497220ULL, 0x040fe20000410000ULL, 0x000000502d507220ULL, 0x040fe20000410000ULL,
0x000000512d517220ULL, 0x040fe20000410000ULL, 0x000000282d287220ULL, 0x040fe20000410000ULL,
0x000000292d297220ULL, 0x040fe20000410000ULL, 0x000000242d247220ULL, 0x040fe20000410000ULL,
0x000000252d257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000000809347811ULL, 0x000fca00078ff0ffULL, 0x00001f34372d7589ULL, 0x006e6400000e0000ULL,
0x000000562d567220ULL, 0x042fe20000410000ULL, 0x000000572d577220ULL, 0x040fe20000410000ULL,
0x0000003e2d3e7220ULL, 0x040fe20000410000ULL, 0x0000003f2d3f7220ULL, 0x040fe20000410000ULL,
0x000000422d427220ULL, 0x040fe20000410000ULL, 0x000000432d437220ULL, 0x040fe20000410000ULL,
0x000000462d467220ULL, 0x040fe20000410000ULL, 0x000000472d477220ULL, 0x040fe20000410000ULL,
0x0000004a2d4a7220ULL, 0x040fe20000410000ULL, 0x0000004b2d4b7220ULL, 0x040fe20000410000ULL,
0x000000522d527220ULL, 0x040fe20000410000ULL, 0x000000532d537220ULL, 0x040fe20000410000ULL,
0x0000002a2d2a7220ULL, 0x040fe20000410000ULL, 0x0000002b2d2b7220ULL, 0x040fe20000410000ULL,
0x000000262d267220ULL, 0x040fe20000410000ULL, 0x000000272d277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x0000001009347811ULL, 0x000fca00078ff0ffULL,
0x00001f34372d7589ULL, 0x006e6400000e0000ULL, 0x0000000c2d0c7220ULL, 0x042fe20000410000ULL,
0x0000000d2d0d7220ULL, 0x040fe20000410000ULL, 0x000000102d107220ULL, 0x040fe20000410000ULL,
0x000000112d117220ULL, 0x040fe20000410000ULL, 0x000000142d147220ULL, 0x040fe20000410000ULL,
0x000000152d157220ULL, 0x040fe20000410000ULL, 0x000000182d187220ULL, 0x040fe20000410000ULL,
0x000000192d197220ULL, 0x040fe20000410000ULL, 0x0000001c2d1c7220ULL, 0x040fe20000410000ULL,
0x0000001d2d1d7220ULL, 0x040fe20000410000ULL, 0x000000202d207220ULL, 0x040fe20000410000ULL,
0x000000212d217220ULL, 0x040fe20000410000ULL, 0x000000302d307220ULL, 0x040fe20000410000ULL,
0x000000312d317220ULL, 0x040fe20000410000ULL, 0x000000382d387220ULL, 0x040fe20000410000ULL,
0x000000392d397220ULL, 0x000fce0000410000ULL, 0x0000003784847220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x0000001809347811ULL, 0x000fca00078ff0ffULL,
0x00001f34372d7589ULL, 0x002e6400000e0000ULL, 0x0000000e2d0e7220ULL, 0x042fe20000410000ULL,
0x0000000f2d0f7220ULL, 0x040fe20000410000ULL, 0x000000122d127220ULL, 0x040fe20000410000ULL,
0x000000132d137220ULL, 0x040fe20000410000ULL, 0x000000162d167220ULL, 0x040fe20000410000ULL,
0x000000172d177220ULL, 0x040fe20000410000ULL, 0x0000001a2d1a7220ULL, 0x040fe20000410000ULL,
0x0000001b2d1b7220ULL, 0x040fe20000410000ULL, 0x0000001e2d1e7220ULL, 0x040fe20000410000ULL,
0x0000001f2d1f7220ULL, 0x040fe20000410000ULL, 0x000000222d227220ULL, 0x040fe20000410000ULL,
0x000000232d237220ULL, 0x040fe20000410000ULL, 0x000000322d327220ULL, 0x040fe20000410000ULL,
0x000000332d337220ULL, 0x040fe20000410000ULL, 0x0000003a2d3a7220ULL, 0x040fe20000410000ULL,
0x0000003b2d3b7220ULL, 0x000fce0000410000ULL, 0x0000002e35ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff347424ULL, 0x000fd800078e00ffULL, 0x0000002c7a2c0221ULL, 0x000fe20000010100ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b2c2c0820ULL, 0x000fc80000410000ULL,
0x0000002c00040308ULL, 0x000ea40000000800ULL, 0x000000042f2f0220ULL, 0x004fce0000410000ULL,
0x000000842f847221ULL, 0x000fce0000010000ULL, 0x00000000002c7805ULL, 0x002fce0000015200ULL,
0x00000008772e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2f7812ULL, 0x000fca00078ec0ffULL,
0x0000000108377824ULL, 0x000fc800078e022fULL, 0x01a6b087370075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6b087370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000004ff2e7819ULL, 0x000fe20000011609ULL, 0x00000004772f7824ULL, 0x000fe200078e00ffULL,
0x00009910342c7816ULL, 0x000fe200000000ffULL, 0x000000086c357824ULL, 0x000fe400078e00ffULL,
0x00000004592d7824ULL, 0x000fe200078e022eULL, 0x000000ff2c00720cULL, 0x000fe20003f05270ULL,
0x0000000878367824ULL, 0x000fe200078e00ffULL, 0x000000042f2f7812ULL, 0x000fe200078ec0ffULL,
0x000000016c2c7824ULL, 0x100fe400078e022dULL, 0x00000001782d7824ULL, 0x000fe200078e022dULL,
0x000000022f347812ULL, 0x000fe200078efcffULL, 0x000010005b2e7824ULL, 0x000fe200078e0208ULL,
0xfffffff8352c7812ULL, 0x000fc400078ee22cULL, 0xfffffff8362d7812ULL, 0x000fe200078ee22dULL,
0x000150002e647836ULL, 0x000fe20000000000ULL, 0x0000003409837211ULL, 0x000fe200078fe0ffULL,
0x000000106e2e7824ULL, 0x000fe400078e027bULL, 0x000000102c2c7824ULL, 0x100fe400078e0264ULL,
0x000000102d2d7824ULL, 0x000fe200078e0264ULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff347819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000000ffULL,
0x0000000834027836ULL, 0x000fe20000000000ULL, 0x00005410002f7816ULL, 0x000fe20000000000ULL,
0x0000001034367836ULL, 0x000fe40000000000ULL, 0x00000018344c7836ULL, 0x000fe40000000000ULL,
0x00001f022f027589ULL, 0x0002a800000e0000ULL, 0x00001f362f057589ULL, 0x0002e800000e0000ULL,
0x00001f342f037589ULL, 0x00026800000e0000ULL, 0x00001f4c2f007589ULL, 0x00026400000e0000ULL,
0x000000002c5c783bULL, 0x0006a80000000200ULL, 0x000000002d34783bULL, 0x0026620000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000035c5c7232ULL, 0x084fe40000000000ULL,
0x000000035e5e7232ULL, 0x000fe40000000000ULL, 0x000000025d5d7232ULL, 0x080fe40000000000ULL,
0x000000025f5f7232ULL, 0x000fe40000000000ULL, 0x0000000534347232ULL, 0x08afe40000000000ULL,
0x0000000536367232ULL, 0x000fc40000000000ULL, 0x0000000035357232ULL, 0x080fe40000000000ULL,
0x0000000037377232ULL, 0x000fce0000000000ULL, 0x000000086c4d7824ULL, 0x040fe200078e00ffULL,
0x000000002e2c783bULL, 0x008ee20000004200ULL, 0x000000016c6c7824ULL, 0x000fe400078e0283ULL,
0x000000106f6f7824ULL, 0x100fe400078e0264ULL, 0x0000001071717824ULL, 0x000fe200078e0264ULL,
0xfffffff84d6c7812ULL, 0x000fca00078ee26cULL, 0x000000106c4c7824ULL, 0x000fcc00078e027bULL,
0x000000004c4c783bULL, 0x000f620000004200ULL, 0x00000018ff697819ULL, 0x008fe4000001162cULL,
0x00000010ff887819ULL, 0x100fe4000001162dULL, 0x000000ff2d827812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001162dULL, 0x0000ffff2d8c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff2f6c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff857819ULL, 0x100fe4000001162eULL,
0x000000ff2e2d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001162eULL,
0x0000ffff2e647812ULL, 0x000fe400078ec0ffULL, 0x00000010ff667819ULL, 0x024fe4000001164cULL,
0x000000ff4c6d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001164cULL,
0x0000ffff4c677812ULL, 0x000fe400078ec0ffULL, 0x000000ff4d727812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4c7819ULL, 0x100fe4000001164fULL, 0x000000ff4f8a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff897819ULL, 0x000fc4000001164fULL, 0x0000ffff4f2e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff737819ULL, 0x000fe4000001164eULL, 0x00000069ff4f723eULL, 0x000fe400020006ffULL,
0x0000006cff69723eULL, 0x000fe400020006ffULL, 0x00000010ff877819ULL, 0x000fe4000001162cULL,
0x0000006dff6c723eULL, 0x000fc400020006ffULL, 0x00000072ff6d723eULL, 0x000fe400020006ffULL,
0x00000018ff707819ULL, 0x000fe4000001164dULL, 0x00000073ff72723eULL, 0x000fe400020006ffULL,
0x000000ff2c807812ULL, 0x040fe400078ec0ffULL, 0x0000ffff2c8b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff867819ULL, 0x000fc4000001162fULL, 0x00000018ff6b7819ULL, 0x000fe4000001162fULL,
0x0000ffff2f657812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e7c7812ULL, 0x040fe400078ec0ffULL,
0x00000089ff73723eULL, 0x000fe400020006ffULL, 0x00000010ff2f7819ULL, 0x000fe4000001164eULL,
0x0000ffff4e2c7812ULL, 0x000fc400078ec0ffULL, 0x000000ff87877812ULL, 0x000fe400078ec0ffULL,
0x000000ff88897812ULL, 0x000fe400078ec0ffULL, 0x0000002dff4e723eULL, 0x000fe400020006ffULL,
0x00000070ff2d723eULL, 0x000fe400020006ffULL, 0x000000ff85857812ULL, 0x000fe400078ec0ffULL,
0x0000007cff70723eULL, 0x000fc400020006ffULL, 0x00000008ff657819ULL, 0x000fe40000011665ULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x0000008aff7c723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fc400020006ffULL, 0x00000010ff687819ULL, 0x000fe4000001164dULL,
0x00000008ff887819ULL, 0x000fe4000001168bULL, 0x00000008ff8a7819ULL, 0x000fe4000001168cULL,
0x000000ff868c7812ULL, 0x000fe400078ec0ffULL, 0x00000085ff8b723eULL, 0x000fe400020006ffULL,
0x00000008ff867819ULL, 0x000fc40000011664ULL, 0x00000065ff85723eULL, 0x000fe400020006ffULL,
0x0000541080647816ULL, 0x000fe40000000087ULL, 0x0000541082657816ULL, 0x000fe40000000089ULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x000000ff66807812ULL, 0x000fe200078ec0ffULL, 0x00000064340c723cULL, 0x002fe2000000180cULL,
0x000000ff68827812ULL, 0x000fc400078ec0ffULL, 0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff687819ULL, 0x000fe20000011667ULL, 0x000000645c54723cULL, 0x000fe20000001854ULL,
0x000054108a677816ULL, 0x000fe4000000007eULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000068ff7e723eULL, 0x000fc400020006ffULL,
0x00000008ff4d7819ULL, 0x000fe4000001164dULL, 0x000054104e687816ULL, 0x000fe4000000008bULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x000000ff2f4e7812ULL, 0x000fc400078ec0ffULL,
0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x000054106c6c7816ULL, 0x000fe40000000080ULL, 0x000054106d6d7816ULL, 0x000fe40000000082ULL,
0x0000004dff2f723eULL, 0x000fe400020006ffULL, 0x00000008ff807819ULL, 0x000fc4000001162cULL,
0x00000008ff827819ULL, 0x000fe2000001162eULL, 0x0000006c341c723cULL, 0x000fe2000000181cULL,
0x00005410866a7816ULL, 0x000fe4000000006aULL, 0x00005410856b7816ULL, 0x000fe4000000006bULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x0000006c5c48723cULL, 0x000fe20000001848ULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x0000541088667816ULL, 0x000fc4000000004fULL,
0x0000004eff85723eULL, 0x000fe200020006ffULL, 0x0000006a3418723cULL, 0x000fe20000001818ULL,
0x0000004cff86723eULL, 0x000fe400020006ffULL, 0x000000006f4c783bULL, 0x0002a20000000200ULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x000000663410723cULL, 0x000fe20000001810ULL, 0x0000541069697816ULL, 0x000fe4000000008cULL,
0x000054107e6e7816ULL, 0x000fc4000000006eULL, 0x000054102f6f7816ULL, 0x002fe2000000002dULL,
0x000000665c3c723cULL, 0x000fe2000000183cULL, 0x00000000712c783bULL, 0x0002a20000000200ULL,
0x0000541070707816ULL, 0x000fe40000000085ULL, 0x0000541080727816ULL, 0x000fe40000000072ULL,
0x0000541082737816ULL, 0x000fe20000000073ULL, 0x000000683414723cULL, 0x000fe20000001814ULL,
0x000054107c717816ULL, 0x002fca0000000086ULL, 0x0000006e3420723cULL, 0x000fec0000001820ULL,
0x000000703430723cULL, 0x000fec0000001830ULL, 0x000000685c40723cULL, 0x000fec0000001840ULL,
0x0000006a5c44723cULL, 0x000fec0000001844ULL, 0x0000006e5c50723cULL, 0x000fec0000001850ULL,
0x000000705c28723cULL, 0x000fec0000001828ULL, 0x000000725c24723cULL, 0x000fec0000001824ULL,
0x000000723434723cULL, 0x000fe20000001838ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000200947ULL, 0x004fde0003800000ULL, 0x000000034c4c7232ULL, 0x080fe40000000000ULL,
0x000000034e4e7232ULL, 0x000fe40000000000ULL, 0x000000024d4d7232ULL, 0x080fe40000000000ULL,
0x000000024f4f7232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x080fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000007d5c783bULL, 0x000e620000004200ULL,
0x0000000178837824ULL, 0x040fe400078e0283ULL, 0x0000000878387824ULL, 0x000fe400078e00ffULL,
0x0000000158587836ULL, 0x000fc60000000000ULL, 0xfffffff838387812ULL, 0x000fca00078ee283ULL,
0x0000001038387824ULL, 0x000fe200078e027bULL, 0x00000010ff397819ULL, 0x002fe4000001165cULL,
0x00000010ff3b7819ULL, 0x000fe4000001165dULL, 0x000000ff5d647812ULL, 0x000fe400078ec0ffULL,
0x000000ff5c3a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff39397812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b3b7812ULL, 0x000fc400078ec0ffULL, 0x00000064ff65723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x00000039ff39723eULL, 0x000fe400020006ffULL,
0x0000003bff3b723eULL, 0x000fe400020006ffULL, 0x0000ffff5c647812ULL, 0x000fe400078ec0ffULL,
0x0000ffff5d687812ULL, 0x000fc400078ec0ffULL, 0x00000018ff677819ULL, 0x000fe4000001165dULL,
0x00000008ff5d7819ULL, 0x000fe40000011664ULL, 0x000054103a647816ULL, 0x000fe40000000039ULL,
0x0000541065657816ULL, 0x000fe4000000003bULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x00000018ff5c7819ULL, 0x000fe4000001165cULL, 0x00000008ff687819ULL, 0x000fc40000011668ULL,
0x0000005cff66723eULL, 0x000fe200020006ffULL, 0x000000644c54723cULL, 0x000fe20000001854ULL,
0x0000005dff5c723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000068ff5d723eULL, 0x000fe200020006ffULL, 0x000000642c0c723cULL, 0x000fe2000000180cULL,
0x000054105c5c7816ULL, 0x000fe40000000066ULL, 0x000054105d5d7816ULL, 0x000fc40000000067ULL,
0x000000ff5e687812ULL, 0x040fe400078ec0ffULL, 0x00000010ff647819ULL, 0x100fe4000001165eULL,
0x00000018ff657819ULL, 0x000fe2000001165eULL, 0x0000005c4c3c723cULL, 0x000fe2000000183cULL,
0x0000ffff5e6b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5e7819ULL, 0x100fe4000001165fULL,
0x000000ff5f697812ULL, 0x000fe200078ec0ffULL, 0x0000005c2c10723cULL, 0x000fe20000001810ULL,
0x00000018ff6a7819ULL, 0x000fc4000001165fULL, 0x0000ffff5f5f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5c7819ULL, 0x000fe4000001166bULL,
0x00000008ff5d7819ULL, 0x000fe4000001165fULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fc400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x000054105c5c7816ULL, 0x000fe40000000065ULL, 0x000054105d5d7816ULL, 0x000fe4000000006aULL,
0x0000541068687816ULL, 0x000fe40000000064ULL, 0x0000541069697816ULL, 0x000fe4000000005eULL,
0x00000010ff5f7819ULL, 0x002fe20000011639ULL, 0x0000005c4c44723cULL, 0x000fe20000001844ULL,
0x000000ff39657812ULL, 0x000fc400078ec0ffULL, 0x00000018ff647819ULL, 0x000fe40000011639ULL,
0x0000ffff396d7812ULL, 0x000fe200078ec0ffULL, 0x0000005c2c18723cULL, 0x000fe20000001818ULL,
0x00000018ff397819ULL, 0x100fe4000001163aULL, 0x0000ffff386c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff667819ULL, 0x000fe2000001163aULL, 0x000000684c40723cULL, 0x000fe20000001840ULL,
0x00000010ff5c7819ULL, 0x000fc40000011638ULL, 0x000000ff3a677812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3a6e7812ULL, 0x000fe200078ec0ffULL, 0x000000682c14723cULL, 0x000fe20000001814ULL,
0x00000018ff6a7819ULL, 0x100fe4000001163bULL, 0x000000ff3b3a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3b6f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff697819ULL, 0x000fc4000001163bULL,
0x00000039ff68723eULL, 0x000fe400020006ffULL, 0x00000018ff5d7819ULL, 0x000fe40000011638ULL,
0x00000008ff397819ULL, 0x000fe4000001166cULL, 0x00000008ff3b7819ULL, 0x000fe4000001166dULL,
0x000000ff385e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x0000003aff6b723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000039ff3a723eULL, 0x000fe400020006ffULL, 0x0000003bff3b723eULL, 0x000fc400020006ffULL,
0x0000005eff38723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x000054103a3a7816ULL, 0x000fe4000000005dULL, 0x000054103b3b7816ULL, 0x000fc40000000064ULL,
0x000000ff66667812ULL, 0x000fe400078ec0ffULL, 0x000000ff69697812ULL, 0x000fe400078ec0ffULL,
0x0000541038387816ULL, 0x000fe2000000005cULL, 0x0000003a4c50723cULL, 0x000fe20000001850ULL,
0x0000541065397816ULL, 0x000fe4000000005fULL, 0x00000008ff5c7819ULL, 0x000fe4000001166eULL,
0x00000008ff5f7819ULL, 0x000fe2000001166fULL, 0x0000003a2c20723cULL, 0x000fe20000001820ULL,
0x00000067ff67723eULL, 0x000fc400020006ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x000000384c48723cULL, 0x000fe20000001848ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x00000001ff3b7424ULL, 0x000fe200078e00ffULL,
0x0000005cff5e723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x000000382c1c723cULL, 0x000fe2000000181cULL, 0x00005410675c7816ULL, 0x000fe20000000066ULL,
0x0000003b063879a7ULL, 0x0002e2000850003fULL, 0x000054106b5d7816ULL, 0x000fc40000000069ULL,
0x000054105e5e7816ULL, 0x000fe40000000068ULL, 0x000054105f5f7816ULL, 0x000fc6000000006aULL,
0x0000005c2c30723cULL, 0x000fe20000001830ULL, 0x000000085b067824ULL, 0x002fca00078e0208ULL,
0x0000005c4c28723cULL, 0x000fe20000001828ULL, 0x01a6a03b06ff79a7ULL, 0x0007ea000850003fULL,
0x0000005e4c24723cULL, 0x000fec0000001824ULL, 0x0000005e2c2c723cULL, 0x000fe20000001834ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffff6000909947ULL, 0x00cfde000383ffffULL,
0x000000ff6200720cULL, 0x000fe20003f05270ULL, 0x000000ffff377224ULL, 0x000fe400078e0041ULL,
0x000000ffff357224ULL, 0x000fe400078e0040ULL, 0x000000ffff097224ULL, 0x000fd000078e003cULL,
0x0000000400648947ULL, 0x000fea0003800000ULL, 0x0180000084007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000bf4000047802ULL, 0x000fce0000000f00ULL, 0x000000b000447944ULL, 0x016fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000008400037308ULL, 0x002e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000084ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009a00ff027b82ULL, 0x000f640000000a00ULL, 0x0000000602037981ULL, 0x02aee2000c1e9900ULL,
0x0000000000067919ULL, 0x000e640000000000ULL, 0x0000000806057811ULL, 0x042fe400078ff0ffULL,
0x0000001806077811ULL, 0x040fe400078ff0ffULL, 0x00000002ff397819ULL, 0x000fe40000011606ULL,
0x00000010063b7811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x00cfca0000410000ULL,
0x00001f3900047589ULL, 0x000e6800000e0000ULL, 0x00001f0500057589ULL, 0x000ea800000e0000ULL,
0x00001f3b00067589ULL, 0x000ee800000e0000ULL, 0x00001f0700077589ULL, 0x000f6200000e0000ULL,
0x0000005404547220ULL, 0x042fe20000410000ULL, 0x0000005504557220ULL, 0x040fe20000410000ULL,
0x0000000904097220ULL, 0x040fe20000410000ULL, 0x0000003d043d7220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000003704377220ULL, 0x040fe20000410000ULL,
0x0000004404447220ULL, 0x040fe20000410000ULL, 0x0000004504457220ULL, 0x040fe20000410000ULL,
0x0000004804487220ULL, 0x040fe20000410000ULL, 0x0000004904497220ULL, 0x040fe20000410000ULL,
0x0000005004507220ULL, 0x040fe20000410000ULL, 0x0000005104517220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x000fe20000410000ULL,
0x0000005605567220ULL, 0x044fe20000410000ULL, 0x0000005705577220ULL, 0x040fe20000410000ULL,
0x0000003e053e7220ULL, 0x040fe20000410000ULL, 0x0000003f053f7220ULL, 0x040fe20000410000ULL,
0x0000004205427220ULL, 0x040fe20000410000ULL, 0x0000004305437220ULL, 0x040fe20000410000ULL,
0x0000004605467220ULL, 0x040fe20000410000ULL, 0x0000004705477220ULL, 0x040fe20000410000ULL,
0x0000004a054a7220ULL, 0x040fe20000410000ULL, 0x0000004b054b7220ULL, 0x040fe20000410000ULL,
0x0000005205527220ULL, 0x040fe20000410000ULL, 0x0000005305537220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x000fe20000410000ULL,
0x0000000c060c7220ULL, 0x048fe20000410000ULL, 0x0000000d060d7220ULL, 0x040fe20000410000ULL,
0x0000001006107220ULL, 0x040fe20000410000ULL, 0x0000001106117220ULL, 0x040fe20000410000ULL,
0x0000001406147220ULL, 0x040fe20000410000ULL, 0x0000001506157220ULL, 0x040fe20000410000ULL,
0x0000001806187220ULL, 0x040fe20000410000ULL, 0x0000001906197220ULL, 0x040fe20000410000ULL,
0x0000001c061c7220ULL, 0x040fe20000410000ULL, 0x0000001d061d7220ULL, 0x040fe20000410000ULL,
0x0000002006207220ULL, 0x040fe20000410000ULL, 0x0000002106217220ULL, 0x040fe20000410000ULL,
0x0000003006307220ULL, 0x040fe20000410000ULL, 0x0000003106317220ULL, 0x040fe20000410000ULL,
0x0000002c062c7220ULL, 0x040fe20000410000ULL, 0x0000002d062d7220ULL, 0x000fe20000410000ULL,
0x0000000e070e7220ULL, 0x060fe20000410000ULL, 0x0000000f070f7220ULL, 0x040fe20000410000ULL,
0x0000001207127220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000001607167220ULL, 0x040fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001b071b7220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000003207327220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x040fe20000410000ULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0x0000002f072f7220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x0000000177777812ULL, 0x000fe400078ec0ffULL,
0x000000484948723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000200077087824ULL, 0x000fe200078e0208ULL, 0x000000505150723eULL, 0x000fc400000000ffULL,
0x000000282928723eULL, 0x000fe400000000ffULL, 0x000000242524723eULL, 0x000fe400000000ffULL,
0x000000565756723eULL, 0x000fe400000000ffULL, 0x0000003e3f3e723eULL, 0x000fe400000000ffULL,
0x000000424342723eULL, 0x000fe400000000ffULL, 0x000000464746723eULL, 0x000fc400000000ffULL,
0x0000004a4b4a723eULL, 0x000fe400000000ffULL, 0x000000525325723eULL, 0x000fe400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x000000262726723eULL, 0x000fe200000000ffULL,
0x0000000161617824ULL, 0x008fe200078e0200ULL, 0x0000000800057811ULL, 0x040fe400078ff0ffULL,
0x0000000200027812ULL, 0x002fe200078ec0ffULL, 0x0000001061617824ULL, 0x000fe200078e0208ULL,
0x00000002ff077819ULL, 0x000fe20000011600ULL, 0x0000000805387824ULL, 0x000fe200078e00ffULL,
0x0000000502037211ULL, 0x000fc400078ff8ffULL, 0x0000001000057811ULL, 0x040fe200078ff0ffULL,
0x0000000807347824ULL, 0x040fe200078e00ffULL, 0xfffffff838387812ULL, 0x000fe200078ee203ULL,
0x0000000807367824ULL, 0x000fe200078e00ffULL, 0x0000001800397811ULL, 0x000fe200078ff0ffULL,
0x00000008053b7824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x040fe400078ff8ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x00000008393c7824ULL, 0x000fe200078e00ffULL,
0x0000003902057211ULL, 0x000fe200078ff8ffULL, 0x0000000807397824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3a7812ULL, 0x000fe200078ee204ULL, 0x0000000203027836ULL, 0x000fe20000000000ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee205ULL, 0x0000000403057836ULL, 0x000fe20000000000ULL,
0x0000000c0d0c723eULL, 0x000fe200000000ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff839067812ULL, 0x000fe200078ee202ULL, 0x0000000807027824ULL, 0x000fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe200078ee205ULL, 0x0000000603077836ULL, 0x000fe20000000000ULL,
0x0000000804057812ULL, 0x000fc400078ec0ffULL, 0xfffffff802027812ULL, 0x000fe200078ee203ULL,
0x0000100063037824ULL, 0x000fe200078e0208ULL, 0xfffffff836367812ULL, 0x000fe400078ee207ULL,
0x000000141514723eULL, 0x000fe200000000ffULL, 0x0000001002047824ULL, 0x100fe200078e0203ULL,
0x000000545502723eULL, 0x000fe200000000ffULL, 0x0000001038387824ULL, 0x100fe200078e0203ULL,
0x000000181918723eULL, 0x000fe200000000ffULL, 0x000000103a3a7824ULL, 0x100fe200078e0203ULL,
0x0000001c1d1c723eULL, 0x000fe200000000ffULL, 0x000000103c3c7824ULL, 0x100fe200078e0203ULL,
0x000000202120723eULL, 0x000fe200000000ffULL, 0x0000001006067824ULL, 0x100fe200078e0203ULL,
0x000000303130723eULL, 0x000fe200000000ffULL, 0x0000001034347824ULL, 0x100fe200078e0203ULL,
0x0000000e0f0e723eULL, 0x000fe200000000ffULL, 0x0000001036367824ULL, 0x000fe200078e0203ULL,
0x000000093d03723eULL, 0x000fe200000000ffULL, 0x0000000104047824ULL, 0x000fe200078e0205ULL,
0x000000121307723eULL, 0x000fe200000000ffULL, 0x0000000105387824ULL, 0x040fe200078e0238ULL,
0x0000541002407816ULL, 0x140fe20000000003ULL, 0x00000001053a7824ULL, 0x040fe200078e023aULL,
0x0000763202417816ULL, 0x000fe20000000003ULL, 0x00000001053c7824ULL, 0x000fe200078e023cULL,
0x000000353702723eULL, 0x000fe200000000ffULL, 0x0000000105097824ULL, 0x000fe200078e0206ULL,
0x000000444503723eULL, 0x000fe200000000ffULL, 0x0000004004007388ULL, 0x0003e20000000a00ULL,
0x0000000105347824ULL, 0x000fe200078e0234ULL, 0x000000101106723eULL, 0x000fe200000000ffULL,
0x0000000105367824ULL, 0x000fe200078e0236ULL, 0x0000763202057816ULL, 0x000fc40000000003ULL,
0x000000161716723eULL, 0x000fe400000000ffULL, 0x0000001a1b1a723eULL, 0x000fe400000000ffULL,
0x0000001e1f1e723eULL, 0x000fe400000000ffULL, 0x0000541002047816ULL, 0x002fe40000000003ULL,
0x0000541048027816ULL, 0x140fe40000000050ULL, 0x0000763248037816ULL, 0x000fe20000000050ULL,
0x0000000409007388ULL, 0x000fe20000000a00ULL, 0x00000022230f723eULL, 0x000fc400000000ffULL,
0x000000323332723eULL, 0x000fe200000000ffULL, 0x0000000234007388ULL, 0x0003e20000000a00ULL,
0x0000002e2f19723eULL, 0x000fe400000000ffULL, 0x000000ff6300720cULL, 0x000fe40003f05270ULL,
0x0000763232297816ULL, 0x000fe40000000019ULL, 0x0000541028027816ULL, 0x142fe40000000024ULL,
0x0000763228037816ULL, 0x000fc40000000024ULL, 0x000054104a247816ULL, 0x140fe40000000025ULL,
0x000076324a257816ULL, 0x000fe20000000025ULL, 0x0000000236007388ULL, 0x0003e20000000a00ULL,
0x0000541032287816ULL, 0x000fe40000000019ULL, 0x0000541056027816ULL, 0x142fe4000000003eULL,
0x0000763256037816ULL, 0x000fca000000003eULL, 0x0000000238007388ULL, 0x0003e40000000a00ULL,
0x0000541042027816ULL, 0x142fe40000000046ULL, 0x0000763242037816ULL, 0x000fca0000000046ULL,
0x0004000209007388ULL, 0x0003e80000000a00ULL, 0x0004002434007388ULL, 0x000fe20000000a00ULL,
0x000054102a027816ULL, 0x142fe40000000026ULL, 0x000076322a037816ULL, 0x000fca0000000026ULL,
0x0004000236007388ULL, 0x0003e40000000a00ULL, 0x000054100c027816ULL, 0x142fe40000000006ULL,
0x000076320c037816ULL, 0x000fe40000000006ULL, 0x000054100e067816ULL, 0x140fe40000000007ULL,
0x000076320e077816ULL, 0x000fe20000000007ULL, 0x000000023a007388ULL, 0x0003e40000000a00ULL,
0x0000541014027816ULL, 0x002fc40000000018ULL, 0x0000763214037816ULL, 0x000fe40000000018ULL,
0x0000002c2d18723eULL, 0x000fc600000000ffULL, 0x0008000209007388ULL, 0x0003e40000000a00ULL,
0x000054101c027816ULL, 0x142fe40000000020ULL, 0x000076321c037816ULL, 0x000fca0000000020ULL,
0x0008000234007388ULL, 0x0003e40000000a00ULL, 0x0000541030027816ULL, 0x142fe40000000018ULL,
0x0000763230037816ULL, 0x000fca0000000018ULL, 0x0008000236007388ULL, 0x0003e80000000a00ULL,
0x000000063c007388ULL, 0x000fe20000000a00ULL, 0x0000541016027816ULL, 0x142fe4000000001aULL,
0x0000763216037816ULL, 0x000fca000000001aULL, 0x000c000209007388ULL, 0x0003e40000000a00ULL,
0x000054101e027816ULL, 0x142fe4000000000fULL, 0x000076321e037816ULL, 0x000fca000000000fULL,
0x000c000234007388ULL, 0x000fe80000000a00ULL, 0x000c002836007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000061047984ULL, 0x000e680000000c00ULL,
0x0004000061107984ULL, 0x000ee80000000c00ULL, 0x0008000061187984ULL, 0x000f680000000c00ULL,
0x000c000061207984ULL, 0x000f680000000c00ULL, 0x00100000610c7984ULL, 0x000f680000000c00ULL,
0x0014000061147984ULL, 0x000f680000000c00ULL, 0x00180000611c7984ULL, 0x000f680000000c00ULL,
0x001c000061247984ULL, 0x000f620000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff13137230ULL, 0x008fe40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fc40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x200000ff1b1b7230ULL, 0x024fe40000000000ULL,
0x200000ff1a1a7230ULL, 0x000fe40000000000ULL, 0x200000ff19197230ULL, 0x000fe40000000000ULL,
0x200000ff18187230ULL, 0x000fe40000000000ULL, 0x200000ff23237230ULL, 0x000fc40000000000ULL,
0x200000ff22227230ULL, 0x000fe40000000000ULL, 0x200000ff21217230ULL, 0x000fe40000000000ULL,
0x200000ff20207230ULL, 0x000fe40000000000ULL, 0x0000000f07077230ULL, 0x000fe40000000000ULL,
0x0000000e06067230ULL, 0x000fe40000000000ULL, 0x0000000d05057230ULL, 0x000fc40000000000ULL,
0x0000000c04047230ULL, 0x000fe40000000000ULL, 0x0000001713137230ULL, 0x000fe40000000000ULL,
0x0000001612127230ULL, 0x000fe20000000000ULL, 0x0000000461007388ULL, 0x0003e20000000c00ULL,
0x0000001511117230ULL, 0x000fe40000000000ULL, 0x0000001410107230ULL, 0x000fe40000000000ULL,
0x0000001f1b1b7230ULL, 0x000fc40000000000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000000000ULL,
0x0004001061007388ULL, 0x0003e20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000000000ULL,
0x0000001c18187230ULL, 0x000fe40000000000ULL, 0x0000002723237230ULL, 0x000fe40000000000ULL,
0x0000002622227230ULL, 0x000fe20000000000ULL, 0x0008001861007388ULL, 0x0003e20000000c00ULL,
0x0000002521217230ULL, 0x000fc40000000000ULL, 0x0000002420207230ULL, 0x000fca0000000000ULL,
0x000c002061007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fc80000011600ULL,
0x0000000b0900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x0000000176047824ULL, 0x002fe200078e0209ULL,
0x0000000800067d06ULL, 0x000e620008209000ULL, 0x0000850000097ab9ULL, 0x000fe20000000800ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000700127812ULL, 0x000fca00078ec0ffULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe06027836ULL, 0x002fcc0000000000ULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fc800078e0a03ULL, 0x0000000805057c24ULL, 0x000fc8000f8e02ffULL,
0x0000000503037227ULL, 0x000fc800078e0002ULL, 0x0000000109027824ULL, 0x000fe400078e0200ULL,
0x0000000403077227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x0000000805007c0cULL, 0x000fda000bf06070ULL,
0x8000000805050c36ULL, 0x000fe40008000000ULL, 0x0000000107070836ULL, 0x000fe20000000000ULL,
0x00000008ff007c0cULL, 0x000fe4000bf05070ULL, 0x0000000805007c0cULL, 0x000fe4000bf26070ULL,
0x0000000702057812ULL, 0x000fe400078ec0ffULL, 0x00000008ff027c12ULL, 0x000fe4000f8e33ffULL,
0x0ffffff805057812ULL, 0x000fca00078ef800ULL, 0x0000001005067824ULL, 0x000fe400078e0208ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x00000000060c7984ULL, 0x0002a40000000c00ULL,
0x0000000702107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe4000f8e0279ULL, 0x0000000807047c24ULL, 0x000fe4000f8e0204ULL,
0x0000002000067836ULL, 0x002fe40000000000ULL, 0x0000000805057c24ULL, 0x000fe4000f8e0204ULL,
0x0000000877077824ULL, 0x000fe200078e0212ULL, 0x00000003ff097819ULL, 0x000fc40000011606ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4410ULL,
0x0000000b0900720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000176047824ULL, 0x102fe400078e0209ULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x0000000403057227ULL, 0x000fc600078e00ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff809097812ULL, 0x000fe200078ef806ULL,
0x0000000807077c24ULL, 0x000fe2000f8e0204ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001009097824ULL, 0x000fe200078e0208ULL, 0x0000000807007c0cULL, 0x000fc8000bf26070ULL,
0x00000000090c7984ULL, 0x0002a40000000c00ULL, 0x0000004000097836ULL, 0x002fce0000000000ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf46070ULL, 0x0000000105052836ULL, 0x000fca0000000000ULL,
0x0000000502107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe4000f8e0279ULL, 0x0000000807047c24ULL, 0x000fe4000f8e0204ULL,
0x0000000877077824ULL, 0x000fe200078e0206ULL, 0x00000003ff067819ULL, 0x000fe20000011609ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4410ULL, 0x0000000b0600720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000176047824ULL, 0x102fe400078e0206ULL,
0x0000000109067824ULL, 0x000fe400078e0206ULL, 0x0000000403077227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x8000000805051c36ULL, 0x000fe40008000000ULL, 0x0000000107071836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef809ULL,
0x0000001005067824ULL, 0x000fca00078e0208ULL, 0x00000000060c7984ULL, 0x0002a20000000c00ULL,
0x0000000107072836ULL, 0x000fca0000000000ULL, 0x0000000702107207ULL, 0x000fe20004000000ULL,
0x0000006000067836ULL, 0x002fc80000000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe2000f8e0279ULL, 0x0000000709107812ULL, 0x000fe200078ec0ffULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x00000003ff097819ULL, 0x000fc60000011606ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000877077824ULL, 0x000fc600078e0210ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4412ULL,
0x0000000b0900720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000176047824ULL, 0x102fe400078e0209ULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x0000000403057227ULL, 0x000fc600078e00ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff809097812ULL, 0x000fe200078ef806ULL,
0x0000000807077c24ULL, 0x000fe2000f8e0204ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001009097824ULL, 0x000fe200078e0208ULL, 0x0000000807007c0cULL, 0x000fc8000bf26070ULL,
0x00000000090c7984ULL, 0x0002a40000000c00ULL, 0x0000008000097836ULL, 0x002fce0000000000ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf46070ULL, 0x0000000105052836ULL, 0x000fca0000000000ULL,
0x0000000502107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe4000f8e0279ULL, 0x0000000807047c24ULL, 0x000fe4000f8e0204ULL,
0x0000000877077824ULL, 0x000fe200078e0206ULL, 0x00000003ff067819ULL, 0x000fe20000011609ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4410ULL, 0x0000000b0600720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000176047824ULL, 0x102fe400078e0206ULL,
0x0000000109067824ULL, 0x000fe400078e0206ULL, 0x0000000403077227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x8000000805051c36ULL, 0x000fe40008000000ULL, 0x0000000107071836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef809ULL,
0x0000001005067824ULL, 0x000fca00078e0208ULL, 0x00000000060c7984ULL, 0x0002a20000000c00ULL,
0x0000000107072836ULL, 0x000fca0000000000ULL, 0x0000000702107207ULL, 0x000fe20004000000ULL,
0x000000a000067836ULL, 0x002fc80000000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe2000f8e0279ULL, 0x0000000709107812ULL, 0x000fe200078ec0ffULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x00000003ff097819ULL, 0x000fc60000011606ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000877077824ULL, 0x000fc600078e0210ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4412ULL,
0x0000000b0900720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000176047824ULL, 0x102fe400078e0209ULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x0000000403057227ULL, 0x000fc600078e00ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff809097812ULL, 0x000fe200078ef806ULL,
0x0000000807077c24ULL, 0x000fe2000f8e0204ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001009097824ULL, 0x000fe200078e0208ULL, 0x0000000807007c0cULL, 0x000fc8000bf26070ULL,
0x00000000090c7984ULL, 0x0002a40000000c00ULL, 0x000000c000097836ULL, 0x002fce0000000000ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf46070ULL, 0x0000000105052836ULL, 0x000fca0000000000ULL,
0x0000000502107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe4000f8e0279ULL, 0x0000000807047c24ULL, 0x000fe4000f8e0204ULL,
0x0000000877077824ULL, 0x000fe200078e0206ULL, 0x00000003ff067819ULL, 0x000fe20000011609ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4410ULL, 0x0000000b0600720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000176047824ULL, 0x102fe400078e0206ULL,
0x0000000109067824ULL, 0x000fe400078e0206ULL, 0x0000000403077227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a07ULL,
0x000000e000007836ULL, 0x000fe40000000000ULL, 0x0000000805057c24ULL, 0x000fca000f8e0204ULL,
0x0000000805007c0cULL, 0x000fda000bf26070ULL, 0x8000000805051c36ULL, 0x000fe40008000000ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef809ULL, 0x0000001005067824ULL, 0x000fca00078e0208ULL,
0x00000000060c7984ULL, 0x000e620000000c00ULL, 0x0000000107072836ULL, 0x000fca0000000000ULL,
0x0000000702107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe2000f8e0279ULL, 0x0000000709107812ULL, 0x000fe200078ec0ffULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x00000003ff097819ULL, 0x000fc60000011600ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000877077824ULL, 0x000fe400078e0210ULL,
0x0000000176767824ULL, 0x000fe200078e0209ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4412ULL, 0x0000000b0900720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0023ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000007603037227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x002fe400078e0a03ULL, 0x0000000100097824ULL, 0x000fe400078e0209ULL,
0x0000000805047c24ULL, 0x000fc6000f8e0276ULL, 0x0000000709097812ULL, 0x000fe400078ec0ffULL,
0x0000000804007c0cULL, 0x000fe4000bf26070ULL, 0xfffffff809097812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001009097824ULL, 0x000fe400078e0208ULL,
0x0000000877777824ULL, 0x000fc800078e0200ULL, 0x8000000804041c36ULL, 0x000fe40008000000ULL,
0x0000000103031836ULL, 0x000fc60000000000ULL, 0x0000000804007c0cULL, 0x000fe4000bf46070ULL,
0x0000000009047984ULL, 0x000e760000000c00ULL, 0x0000000103032836ULL, 0x000fca0000000000ULL,
0x0000000302027207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a02ULL,
0x0000000902037c24ULL, 0x000fe4000f8e0279ULL, 0x000000080b767c24ULL, 0x000fc8000f8e0276ULL,
0x0000000803037c24ULL, 0x000fca000f8e0276ULL, 0x000000030a037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000403027c11ULL, 0x000fc8000f8040ffULL,
0x0000000503037c11ULL, 0x000fc600080f4408ULL, 0x0000001077027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff7e7819ULL, 0x000fe20000011677ULL, 0x00009a00ff107b82ULL, 0x000e620000000a00ULL,
0xffffffffff077424ULL, 0x000fe400078e00ffULL, 0x000000757e00720cULL, 0x000fe20003f06070ULL,
0x00000001ff0b7424ULL, 0x000fd800078e00ffULL, 0x00009600ff048b82ULL, 0x000ea20000000800ULL,
0x000000027a058824ULL, 0x000fce00078e00ffULL, 0x00009200ff0e8b82ULL, 0x000ee20000000a00ULL,
0x0000000610717981ULL, 0x002322000c1e9900ULL, 0x0000000405058224ULL, 0x004fc800078e027eULL,
0x00000004050e8825ULL, 0x008fe400078e000eULL, 0x01a6000b080479a7ULL, 0x000466000850003fULL,
0x000000060e078981ULL, 0x000ee2000c1e1900ULL, 0x00009000ff0a7b82ULL, 0x004ea20000000a00ULL,
0x000001ff0c00780cULL, 0x000fe20003f04070ULL, 0x0000008000007824ULL, 0x000fe400078e00ffULL,
0x0000008079797824ULL, 0x000fc400078e00ffULL, 0x00000040777c7824ULL, 0x000fca00078e00ffULL,
0x00000040790c7812ULL, 0x000fe200078ef87cULL, 0x0000000700077224ULL, 0x008fc800078e02ffULL,
0x00000080070a7825ULL, 0x004fe200078e000aULL, 0x0000000c00200947ULL, 0x002fec0003800000ULL,
0x00000003ff307819ULL, 0x000fe40000011609ULL, 0x0000007c74077248ULL, 0x000fc60007fe0000ULL,
0x0000000830127836ULL, 0x000fe40000000000ULL, 0x0000000430107836ULL, 0x000fe40000000000ULL,
0x0000000107077824ULL, 0x000fe400078e0a7cULL, 0x00000001120f7824ULL, 0x040fe400078e0209ULL,
0x0000000812167824ULL, 0x000fe200078e00ffULL, 0x000000071000720cULL, 0x000fe20003fa6070ULL,
0x000000010c0e7824ULL, 0x000fc400078e0230ULL, 0x00000001100d7824ULL, 0x040fe200078e0209ULL,
0xfffffff816257812ULL, 0x000fe200078ee20fULL, 0x0000000810147824ULL, 0x000fe400078e00ffULL,
0x000000010c107824ULL, 0x000fe400078e0210ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff814237812ULL, 0x000fc600078ee20dULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000700e1d7812ULL, 0x000fc600078ef802ULL, 0x0000001030147836ULL, 0x000fe20000000000ULL,
0x0000007010137812ULL, 0x000fe200078ef802ULL, 0x0000000c30167836ULL, 0x000fe20000000000ULL,
0x0000001d0a1c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001140e7824ULL, 0x040fe200078e0209ULL,
0x000000130a107210ULL, 0x000fe20007f3e0ffULL, 0x0000000814297824ULL, 0x000fe200078e00ffULL,
0x000000071600720cULL, 0x080fe20003f46070ULL, 0x000000010b1d7824ULL, 0x040fe200000e060fULL,
0x000000071400720cULL, 0x080fe20003f06070ULL, 0x000000010b117824ULL, 0x000fe200008e0611ULL,
0xfffffff829297812ULL, 0x000fe200078ee20eULL, 0x000000010c0e7824ULL, 0x000fe200078e0212ULL,
0x000000071200720cULL, 0x000fe20003f26070ULL, 0x000000010c127824ULL, 0x000fc400078e0216ULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x000000010c147824ULL, 0x000fe200078e0214ULL,
0x000000700e197812ULL, 0x000fe200078ef802ULL, 0x00000001160d7824ULL, 0x040fe400078e0209ULL,
0x0000000816187824ULL, 0x000fe400078e00ffULL, 0x0000001430207836ULL, 0x000fe40000000000ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff818277812ULL, 0x000fe400078ee20dULL,
0x000000190a187210ULL, 0x000fe20007f7e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x00000070121f7812ULL, 0x000fc600078ef802ULL, 0x0000001830227836ULL, 0x000fe20000000000ULL,
0x00000070140d7812ULL, 0x000fe200078ef802ULL, 0x000000010c167824ULL, 0x040fe200078e0220ULL,
0x0000001f0a1e7210ULL, 0x000fe20007f9e0ffULL, 0x000000010c1a7824ULL, 0x000fe400078e0222ULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x000000010b197824ULL, 0x000fe200018e060fULL,
0x0000000d0a127210ULL, 0x000fe20007f7e0ffULL, 0x0000001c30267836ULL, 0x000fe20000000000ULL,
0x00000070160f7812ULL, 0x000fe200078ef802ULL, 0x000000801a1a7825ULL, 0x000fc800078e00ffULL,
0x000000010c0e7824ULL, 0x000fe200078e0226ULL, 0x000000701a0d7812ULL, 0x000fe200078ef802ULL,
0x000000010b1f7824ULL, 0x040fe400020e0613ULL, 0x000000010b137824ULL, 0x000fe200018e0615ULL,
0x0000000f0a147210ULL, 0x000fe20007f7e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000d0a167210ULL, 0x000fc60007f9e0ffULL, 0x00004000770d7824ULL, 0x000fe200078e0208ULL,
0x000000700e217812ULL, 0x000fe200078ef802ULL, 0x00000001301a7824ULL, 0x000fe400078e0209ULL,
0x000000010b157824ULL, 0x040fe200018e0617ULL, 0x000000072000720cULL, 0x080fe20003f66070ULL,
0x000020000d247836ULL, 0x000fe20000000000ULL, 0x000000071a1a7812ULL, 0x000fe200078ec0ffULL,
0x0000002030287836ULL, 0x000fe40000000000ULL, 0x000000010b177824ULL, 0x000fe200020e061bULL,
0x000000073000720cULL, 0x000fe20003f86070ULL, 0x00000001200d7824ULL, 0x040fe200078e0209ULL,
0x0ffffff81a1b7812ULL, 0x000fe200078ef809ULL, 0x00000008202a7824ULL, 0x000fe200078e00ffULL,
0x000000210a207210ULL, 0x000fe20007fde0ffULL, 0x000000010c0e7824ULL, 0x000fc400078e0228ULL,
0x00000028302c7836ULL, 0x000fe20000000000ULL, 0xfffffff82a2b7812ULL, 0x000fe200078ee20dULL,
0x000000010b217824ULL, 0x000fe400030e060fULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x000000101b0d7824ULL, 0x000fe200078e0224ULL, 0x000000700e1b7812ULL, 0x000fe200078ef802ULL,
0x00000024302a7836ULL, 0x000fe40000000000ULL, 0x00000001220e7824ULL, 0x000fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c0d7faeULL, 0x0003e2000e101c46ULL,
0x000000010c1a7824ULL, 0x000fe200078e022aULL, 0x000000072200720cULL, 0x040fe20003f86070ULL,
0x00000008222d7824ULL, 0x000fe200078e00ffULL, 0x0000001b0a227210ULL, 0x000fe20007fde0ffULL,
0x000000801a1a7825ULL, 0x000fc600078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee20eULL,
0x000000010c2e7824ULL, 0x000fe400078e022cULL, 0x0000001025257824ULL, 0x100fe200078e0224ULL,
0x000000701a1d7812ULL, 0x002fe200078ef802ULL, 0x00000010230d7824ULL, 0x000fe400078e0224ULL,
0x000000010b237824ULL, 0x000fe200030e060fULL, 0x0000001d0a1a7210ULL, 0x000fe20007fde0ffULL,
0x000000802e0e7825ULL, 0x000fe200078e00ffULL, 0x00000000100d7faeULL, 0x0003e2000e901c46ULL,
0x000000072600720cULL, 0x000fc40003fa6070ULL, 0x00000001261c7824ULL, 0x140fe200078e0209ULL,
0x0000000018257faeULL, 0x0005e2000c901c46ULL, 0x00000008262f7824ULL, 0x000fe200078e00ffULL,
0x000000700e1d7812ULL, 0x000fe200078ef802ULL, 0x0000002c30267836ULL, 0x000fe20000000000ULL,
0x000000072800720cULL, 0x0c0fe20003f26070ULL, 0x0000001027277824ULL, 0x100fe400078e0224ULL,
0x0000001029297824ULL, 0x000fe400078e0224ULL, 0x00000001280d7824ULL, 0x042fe200078e0209ULL,
0x000000001e277faeULL, 0x000fe2000d101c46ULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0x000000072a00720cULL, 0x000fe20003f46070ULL, 0x000000010c107824ULL, 0x000fe200078e0226ULL,
0x0000000012297faeULL, 0x0003e2000c101c46ULL, 0x000000010b1b7824ULL, 0x000fe200030e061bULL,
0x0000001d0a0e7210ULL, 0x000fe20007fde0ffULL, 0x0000003030187836ULL, 0x004fe20000000000ULL,
0xfffffff82f1d7812ULL, 0x000fe200078ee21cULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff8280d7812ULL, 0x000fc600078ee20dULL, 0x000000012a1c7824ULL, 0x040fe200078e0209ULL,
0x00000070102f7812ULL, 0x000fe200078ef802ULL, 0x000000082a317824ULL, 0x000fe400078e00ffULL,
0x000000102b2b7824ULL, 0x000fe400078e0224ULL, 0x000000010c127824ULL, 0x002fe200078e0218ULL,
0xfffffff831197812ULL, 0x000fe200078ee21cULL, 0x000000102d2d7824ULL, 0x100fe200078e0224ULL,
0x00000000142b7faeULL, 0x0003e2000d901c46ULL, 0x000000101d1d7824ULL, 0x100fe200078e0224ULL,
0x000000071800720cULL, 0x080fe20003f66070ULL, 0x000000100d0d7824ULL, 0x000fe200078e0224ULL,
0x00000000162d7faeULL, 0x0005e2000e101c46ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000072600720cULL, 0x000fc40003f86070ULL, 0x00000000201d7faeULL, 0x000fe2000e901c46ULL,
0x000000010b0f7824ULL, 0x000fe200030e060fULL, 0x0000002f0a107210ULL, 0x000fe20007fde0ffULL,
0x00000034301c7836ULL, 0x000fe20000000000ULL, 0x00000000220d7faeULL, 0x0007e2000c901c46ULL,
0x0000001019197824ULL, 0x000fe200078e0224ULL, 0x000000072c00720cULL, 0x080fe20003fa6070ULL,
0x000000010c147824ULL, 0x002fe400078e021cULL, 0x00000038301e7836ULL, 0x000fe20000000000ULL,
0x000000001a197faeULL, 0x0003e2000d101c46ULL, 0x0000003c30287836ULL, 0x000fe20000000000ULL,
0x000000071c00720cULL, 0x080fe20003f46070ULL, 0x000000012c177824ULL, 0x004fe200078e0209ULL,
0x000000071e00720cULL, 0x080fe20003f26070ULL, 0x000000010b117824ULL, 0x000fe200030e0611ULL,
0x00000070120d7812ULL, 0x008fe200078ef802ULL, 0x000000082c2c7824ULL, 0x000fe200078e00ffULL,
0x000000072800720cULL, 0x000fe20003f06070ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000d0a167210ULL, 0x000fc40007fde0ffULL, 0xfffffff82c077812ULL, 0x000fe200078ee217ULL,
0x0000000118127824ULL, 0x040fe400078e0209ULL, 0x000000010b177824ULL, 0x000fe200030e0613ULL,
0x0000007014137812ULL, 0x000fe200078ef802ULL, 0x00000008181b7824ULL, 0x002fe400078e00ffULL,
0x00000001260d7824ULL, 0x000fe200078e0209ULL, 0x000000130a147210ULL, 0x000fe20007fde0ffULL,
0x000000010c137824ULL, 0x000fe200078e021eULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee212ULL,
0x0000000826267824ULL, 0x000fc400078e00ffULL, 0x0000008013127825ULL, 0x000fc600078e00ffULL,
0xfffffff826197812ULL, 0x000fe200078ee20dULL, 0x000000010c0c7824ULL, 0x000fe200078e0228ULL,
0x00000070121d7812ULL, 0x000fe200078ef802ULL, 0x000000011e1a7824ULL, 0x040fe400078e0209ULL,
0x000000081e217824ULL, 0x000fe400078e00ffULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x000000010b157824ULL, 0x040fe200030e0615ULL, 0x0000001d0a127210ULL, 0x000fe20007fde0ffULL,
0x000000011c187824ULL, 0x140fe200078e0209ULL, 0xfffffff8211d7812ULL, 0x000fe200078ee21aULL,
0x000000081c1f7824ULL, 0x000fe200078e00ffULL, 0x000000700c217812ULL, 0x000fe200078ef802ULL,
0x00000001281c7824ULL, 0x040fe400078e0209ULL, 0x0000000828237824ULL, 0x000fe200078e00ffULL,
0xfffffff81f097812ULL, 0x000fe200078ee218ULL, 0x000000010b137824ULL, 0x000fe200030e0613ULL,
0x000000210a0a7210ULL, 0x000fe20007fde0ffULL, 0x0000001007077824ULL, 0x100fe200078e0224ULL,
0xfffffff8231f7812ULL, 0x000fe200078ee21cULL, 0x0000001019197824ULL, 0x000fc400078e0224ULL,
0x000000101b1b7824ULL, 0x100fe200078e0224ULL, 0x000000000e077faeULL, 0x0003e2000e901c46ULL,
0x0000001009097824ULL, 0x100fe400078e0224ULL, 0x000000101d1d7824ULL, 0x100fe200078e0224ULL,
0x0000000010197faeULL, 0x0003e2000e101c46ULL, 0x000000101f1f7824ULL, 0x000fe400078e0224ULL,
0x000000010b0b7824ULL, 0x000fe200030e060dULL, 0x00000000161b7faeULL, 0x0003e8000d901c46ULL,
0x0000000014097faeULL, 0x0003e8000d101c46ULL, 0x00000000121d7faeULL, 0x0003e8000c901c46ULL,
0x000000000a1f7faeULL, 0x0003e2000c101c46ULL, 0x0000000800d07947ULL, 0x000fea0003800000ULL,
0x0000000809107811ULL, 0x040fe400078fe8ffULL, 0x00000004090f7811ULL, 0x040fe400078fe8ffULL,
0x0000000c09117811ULL, 0x040fe200078fe8ffULL, 0x00000001100d7824ULL, 0x140fe200078e0209ULL,
0x00000018091a7811ULL, 0x040fe200078fe8ffULL, 0x0000000810187824ULL, 0x000fe200078e00ffULL,
0x0000001009167811ULL, 0x000fe200078fe8ffULL, 0x000000010f077824ULL, 0x100fe200078e0209ULL,
0x0000001c091c7811ULL, 0x000fe200078fe8ffULL, 0x000000080f127824ULL, 0x000fe200078e00ffULL,
0xfffffff818137812ULL, 0x000fe200078ee20dULL, 0x00000001110e7824ULL, 0x100fe200078e0209ULL,
0x0000001409187811ULL, 0x000fe200078fe8ffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x000000011a0d7824ULL, 0x100fe200078e0209ULL,
0x00000020091e7811ULL, 0x040fe200078fe8ffULL, 0x0000000118077824ULL, 0x140fe200078e0209ULL,
0xfffffff815157812ULL, 0x000fe200078ee20eULL, 0x0000000818207824ULL, 0x000fe200078e00ffULL,
0x0000002c09287811ULL, 0x040fe200078fe8ffULL, 0x000000081a227824ULL, 0x000fe200078e00ffULL,
0x0000002809237811ULL, 0x040fe200078fe8ffULL, 0x0000000116147824ULL, 0x140fe200078e0209ULL,
0xfffffff820197812ULL, 0x000fe200078ee207ULL, 0x0000000816177824ULL, 0x000fe200078e00ffULL,
0x0000002409207811ULL, 0x040fe200078fe8ffULL, 0x000000011c0e7824ULL, 0x140fe200078e0209ULL,
0xfffffff8221b7812ULL, 0x000fe200078ee20dULL, 0x000000081c1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee214ULL, 0x0000000120077824ULL, 0x140fe200078e0209ULL,
0x00000030092a7811ULL, 0x040fe200078fe8ffULL, 0x0000000820227824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee20eULL, 0x000000011e147824ULL, 0x140fe200078e0209ULL,
0x00000034092d7811ULL, 0x040fe200078fe8ffULL, 0x000000081e1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee207ULL, 0x00000001280e7824ULL, 0x140fe200078e0209ULL,
0x0000000909077211ULL, 0x000fe200078fe8ffULL, 0x0000000828297824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee214ULL, 0x00000001230d7824ULL, 0x100fe200078e0209ULL,
0x00000038092f7811ULL, 0x000fe200078fe8ffULL, 0x0000000823247824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee20eULL, 0x000000012a147824ULL, 0x040fe200078e0209ULL,
0x00000007070e7812ULL, 0x000fe200078ec0ffULL, 0x000000082a2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff824277812ULL, 0x000fe200078ee20dULL, 0x000000010c247824ULL, 0x040fe200078e021eULL,
0x0000003c09317811ULL, 0x040fe200078fe8ffULL, 0x000000010c0f7824ULL, 0x040fe200078e020fULL,
0x0000000c090d7211ULL, 0x000fe200078fe8ffULL, 0x000000010c257824ULL, 0x040fe200078e0220ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee214ULL, 0x000000010c147824ULL, 0x000fe200078e0211ULL,
0x0ffffff80e077812ULL, 0x000fe200078ef809ULL, 0x00004000770e7824ULL, 0x000fc400078e0208ULL,
0x000000012d117824ULL, 0x100fe400078e0209ULL, 0x000000012f1e7824ULL, 0x000fe400078e0209ULL,
0x000000010c107824ULL, 0x040fe400078e0210ULL, 0x000000010c167824ULL, 0x040fe400078e0216ULL,
0x000000010c187824ULL, 0x040fe400078e0218ULL, 0x000000010c1a7824ULL, 0x000fc400078e021aULL,
0x000000010c217824ULL, 0x040fe400078e021cULL, 0x000000010c267824ULL, 0x040fe400078e0223ULL,
0x000000010c287824ULL, 0x040fe400078e0228ULL, 0x000000010c2c7824ULL, 0x040fe400078e022aULL,
0x000000010c2e7824ULL, 0x040fe400078e022dULL, 0x000000010c307824ULL, 0x000fc400078e022fULL,
0x000000010c327824ULL, 0x000fe400078e0231ULL, 0x0000000131097824ULL, 0x040fe400078e0209ULL,
0x0000000831207824ULL, 0x000fe400078e00ffULL, 0x000000082d1c7824ULL, 0x000fe400078e00ffULL,
0x000000800d0c7825ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe400078ee209ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee211ULL, 0x000020000e2a7836ULL, 0x000fe20000000000ULL,
0x000000700c097812ULL, 0x000fe200078ef802ULL, 0x000000800f0e7825ULL, 0x000fc600078e00ffULL,
0x000000090a0c7210ULL, 0x000fe20007f1e0ffULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x00000010132d7824ULL, 0x100fe200078e022aULL, 0x000000700e137812ULL, 0x000fe200078ef802ULL,
0x000000082f2f7824ULL, 0x000fe400078e00ffULL, 0x0000001017317824ULL, 0x100fe200078e022aULL,
0x000000130a0e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001012097824ULL, 0x000fe200078e022aULL,
0x0000007010177812ULL, 0x000fe200078ef802ULL, 0x0000008014127825ULL, 0x000fe200078e00ffULL,
0xfffffff82f1e7812ULL, 0x000fc600078ee21eULL, 0x000000010b0d7824ULL, 0x000fe200000e060dULL,
0x000000170a107210ULL, 0x000fe20007f1e0ffULL, 0x00000010152f7824ULL, 0x100fe400078e022aULL,
0x000000101d377824ULL, 0x000fe200078e022aULL, 0x00000070121d7812ULL, 0x000fe200078ef802ULL,
0x0000008016147825ULL, 0x000fc800078e00ffULL, 0x0000008018167825ULL, 0x000fc800078e00ffULL,
0x000000101f397824ULL, 0x100fe200078e022aULL, 0x00000070141f7812ULL, 0x000fe200078ef802ULL,
0x000000101c437824ULL, 0x100fe400078e022aULL, 0x000000010b117824ULL, 0x000fe200000e0611ULL,
0x0000001d0a1c7210ULL, 0x000fe20007f1e0ffULL, 0x0000001019337824ULL, 0x100fe400078e022aULL,
0x000000101b357824ULL, 0x000fe200078e022aULL, 0x00000070161b7812ULL, 0x000fe200078ef802ULL,
0x000000801a187825ULL, 0x000fc800078e00ffULL, 0x000000101e457824ULL, 0x100fe200078e022aULL,
0x0000007018237812ULL, 0x000fe200078ef802ULL, 0x000000010b0f7824ULL, 0x040fe200008e060fULL,
0x0000001f0a1e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001020477824ULL, 0x000fe400078e022aULL,
0x000000010b1d7824ULL, 0x000fe200000e0613ULL, 0x0000001b0a207210ULL, 0x000fe20007f1e0ffULL,
0x0000008021127825ULL, 0x000fc800078e00ffULL, 0x000000010b1f7824ULL, 0x000fe400008e0615ULL,
0x00000010223b7824ULL, 0x000fe200078e022aULL, 0x000000230a227210ULL, 0x000fe20007f5e0ffULL,
0x0000008024147825ULL, 0x000fc800078e00ffULL, 0x000000010b217824ULL, 0x000fe400000e0617ULL,
0x0000008025167825ULL, 0x000fe200078e00ffULL, 0x0000007012257812ULL, 0x000fc600078ef802ULL,
0x00000010273d7824ULL, 0x000fe200078e022aULL, 0x0000007014277812ULL, 0x000fe200078ef802ULL,
0x000000010b237824ULL, 0x000fe200010e0619ULL, 0x000000250a247210ULL, 0x000fe20007f1e0ffULL,
0x0000008026187825ULL, 0x000fe200078e00ffULL, 0x000000270a267210ULL, 0x000fc60007f3e0ffULL,
0x00000010293f7824ULL, 0x000fe200078e022aULL, 0x0000007016297812ULL, 0x000fe200078ef802ULL,
0x00000080281a7825ULL, 0x000fc800078e00ffULL, 0x000000102b417824ULL, 0x100fe200078e022aULL,
0x00000070182b7812ULL, 0x000fe200078ef802ULL, 0x000000010b257824ULL, 0x040fe200000e0613ULL,
0x000000290a287210ULL, 0x000fe20007f1e0ffULL, 0x000000010b277824ULL, 0x000fe200008e0615ULL,
0x000000701a157812ULL, 0x000fe200078ef802ULL, 0x0000001007077824ULL, 0x000fe200078e022aULL,
0x0000002b0a2a7210ULL, 0x000fe20007f5e0ffULL, 0x000000010b297824ULL, 0x040fe200000e0617ULL,
0x000000150a1a7210ULL, 0x000fe20007f1e0ffULL, 0x000000802c127825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c077faeULL, 0x0003e6000b901c46ULL,
0x000000802e147825ULL, 0x000fe200078e00ffULL, 0x00000070124f7812ULL, 0x000fe200078ef802ULL,
0x000000000e097faeULL, 0x0003e4000b901c46ULL, 0x000000010b2b7824ULL, 0x040fe200010e0619ULL,
0x00000070144d7812ULL, 0x000fe200078ef802ULL, 0x0000008030167825ULL, 0x000fe200078e00ffULL,
0x00000000102d7faeULL, 0x0003e4000b901c46ULL, 0x0000004d0a147210ULL, 0x000fe20007f3e0ffULL,
0x0000008032187825ULL, 0x000fe200078e00ffULL, 0x00000070164b7812ULL, 0x000fe200078ef802ULL,
0x000000001c2f7faeULL, 0x0003e4000b901c46ULL, 0x000000010b1b7824ULL, 0x040fe200000e061bULL,
0x0000007018497812ULL, 0x000fe200078ef802ULL, 0x000000001e317faeULL, 0x0003e2000b901c46ULL,
0x0000004f0a127210ULL, 0x000fe20007f1e0ffULL, 0x000000010b157824ULL, 0x040fe200008e0615ULL,
0x0000004b0a167210ULL, 0x000fe20007f5e0ffULL, 0x0000000020337faeULL, 0x0003e2000b901c46ULL,
0x000000490a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000010b137824ULL, 0x000fc400000e0613ULL,
0x0000000022357faeULL, 0x0003e2000b901c46ULL, 0x000000010b177824ULL, 0x040fe400010e0617ULL,
0x000000010b0b7824ULL, 0x000fe200018e0619ULL, 0x0000000024377faeULL, 0x0003e8000b901c46ULL,
0x0000000026397faeULL, 0x0003e8000b901c46ULL, 0x00000000283b7faeULL, 0x0003e8000b901c46ULL,
0x000000002a3d7faeULL, 0x0003e8000b901c46ULL, 0x000000001a3f7faeULL, 0x0003e8000b901c46ULL,
0x0000000012417faeULL, 0x0003e8000b901c46ULL, 0x0000000014437faeULL, 0x0003e8000b901c46ULL,
0x0000000016457faeULL, 0x0003e8000b901c46ULL, 0x000000000a477faeULL, 0x0003e4000b901c46ULL,
0x000000027e7e7836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff7f7424ULL, 0x000fe200078e00ffULL, 0x0000840000047ab9ULL, 0x000fe40000000800ULL,
0x000000757e00720cULL, 0x000fda0003f06070ULL, 0x00009600ff028b82ULL, 0x000ea20000000800ULL,
0x000000027a078824ULL, 0x002fce00078e00ffULL, 0x00009200ff0a8b82ULL, 0x000e620000000a00ULL,
0x0000000207078224ULL, 0x004fc800078e027eULL, 0x00000004070a8825ULL, 0x002fca00078e000aULL,
0x000000060a7f8981ULL, 0x000322000c1e1900ULL, 0x0000001f04047890ULL, 0x000fc8000fffe03fULL,
0x000000053f047899ULL, 0x000fd80008011604ULL, 0x00000000000a7805ULL, 0x002fce0000015200ULL,
0x01a60005080075a7ULL, 0x000e62000800017fULL, 0x0000000174707824ULL, 0x000fe400078e0a03ULL,
0x0000000406077c24ULL, 0x000fc6000f8e02ffULL, 0x00000008ff707819ULL, 0x000fe20000011670ULL,
0x00008e00ff807b82ULL, 0x000ea40000000a00ULL, 0x0000000407807825ULL, 0x004fe200078e0080ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff0c7224ULL, 0x000fce00078e00ffULL,
0x000000100c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fce0000015200ULL, 0x000000060a097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e0bULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011407ULL,
0x0000000902027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010c0c7836ULL, 0x000fce0000000000ULL,
0x01a60005080075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000027919ULL, 0x000e640000000000ULL, 0x0000002077027824ULL, 0x002fc800078e0202ULL,
0x0000000102067836ULL, 0x000fe20000000000ULL, 0x00000004ff047819ULL, 0x000fc80000011602ULL,
0x0ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x0000001f02047812ULL, 0x000fc600078ec0ffULL,
0x0000000105097824ULL, 0x000fe400078e0206ULL, 0x0000000102077824ULL, 0x000fe400078e0205ULL,
0x00000010040c7824ULL, 0x040fe200078e00ffULL, 0x0000000f09097812ULL, 0x000fe200078ec0ffULL,
0x00000010040a7824ULL, 0x040fe200078e00ffULL, 0x0000000f07077812ULL, 0x000fe200078ec0ffULL,
0x0000000805057836ULL, 0x000fe20000000000ULL, 0x000001f00c097812ULL, 0x000fe200078ee209ULL,
0x00000010040b7824ULL, 0x000fe200078e00ffULL, 0x000001f00a077812ULL, 0x000fe200078ee207ULL,
0x0000000102027824ULL, 0x000fc400078e0205ULL, 0x0000001009097824ULL, 0x100fe400078e0208ULL,
0x0000001007077824ULL, 0x000fe200078e0208ULL, 0x0000000f02027812ULL, 0x000fe200078ec0ffULL,
0x0000000106057824ULL, 0x000fe200078e0205ULL, 0x00000000090c7984ULL, 0x000e620000000c00ULL,
0x0000001004157824ULL, 0x000fc600078e00ffULL, 0x0000000007107984ULL, 0x000ea20000000c00ULL,
0x0000000f05047812ULL, 0x000fe400078ec0ffULL, 0x000001f00b057812ULL, 0x000fe400078ee202ULL,
0x000001f0150b7812ULL, 0x000fc600078ee204ULL, 0x0000001005057824ULL, 0x100fe400078e0208ULL,
0x000000100b027824ULL, 0x000fe400078e0208ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff167224ULL, 0x002fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff147224ULL, 0x004fc400078e0010ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff1a7224ULL, 0x000fe400078e000dULL, 0x000000ffff1b7224ULL, 0x000fe200078e000fULL,
0x0000001407007388ULL, 0x000fe20000000c00ULL, 0x000000ffff187224ULL, 0x000fe400078e0011ULL,
0x000000ffff197224ULL, 0x000fca00078e0013ULL, 0x0000001809007388ULL, 0x000fe80000000c00ULL,
0x00000000020c7984ULL, 0x000e680000000c00ULL, 0x0000000005107984ULL, 0x000ea20000000c00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000eULL, 0x000000ffff1e7224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1c7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000001c05007388ULL, 0x0003e80000000c00ULL,
0x0000000c02007388ULL, 0x0003e20000000c00ULL, 0x01a6000b080a79a7ULL, 0x0002a4000850003fULL,
0x0000000000047805ULL, 0x002fce0000015200ULL, 0x01a6000b080075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fce00078e00ffULL,
0x000000100c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fce0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011407ULL,
0x0000000902027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010c0c7836ULL, 0x000fce0000000000ULL,
0x01a6000b080075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ff6200720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00009600ff057b82ULL, 0x000e620000000800ULL, 0x0000000000097919ULL, 0x000ea20000000000ULL,
0x000001007c7c7836ULL, 0x000fe40000000000ULL, 0x3db504f371717820ULL, 0x010fe20000410000ULL,
0x0000000877517824ULL, 0x140fe200078e0208ULL, 0x0000000104057899ULL, 0x000fe2000800063fULL,
0xffffffff03637836ULL, 0x000fe40000000000ULL, 0x00000009035d7836ULL, 0x000fe40000000000ULL,
0x0000002077787824ULL, 0x000fc400078e0208ULL, 0x000000ffff7d7224ULL, 0x000fe400078e00ffULL,
0x000000ffff027224ULL, 0x000fe400078e00ffULL, 0x000000057a7a7224ULL, 0x002fce00078e02ffULL,
0x00009000ff047b82ULL, 0x004e620000000a00ULL, 0x000000027d077836ULL, 0x000fe20000000000ULL,
0x00000001025c7812ULL, 0x000fe200078e0cffULL, 0x000001007d537824ULL, 0x000fe400078e027cULL,
0x0000007f007f7224ULL, 0x010fe200078e02ffULL, 0x000000620700720cULL, 0x000fe40003f06070ULL,
0x0000004053067812ULL, 0x000fca00078ec0ffULL, 0x0000000179067824ULL, 0x000fe400078e0206ULL,
0x000000807f047825ULL, 0x002fc800078e0004ULL, 0x0000000c002c8947ULL, 0x000fea0003800000ULL,
0x00000003ff247819ULL, 0x004fe20000011609ULL, 0x00000010091a7824ULL, 0x000fe200078e00ffULL,
0x00000053740a7248ULL, 0x000fc60007fe0000ULL, 0x00000004240c7836ULL, 0x000fe20000000000ULL,
0x000000701a1a7812ULL, 0x000fe200078ec0ffULL, 0x000000010a1b7824ULL, 0x000fe400078e0a53ULL,
0x000000010c077824ULL, 0x040fe400078e0209ULL, 0x000000080c107824ULL, 0x040fe200078e00ffULL,
0x0000001b0c00720cULL, 0x000fe20003fa6070ULL, 0x00000008240e7836ULL, 0x000fe40000000000ULL,
0x00000001240a7824ULL, 0x100fe200078e0206ULL, 0xfffffff810237812ULL, 0x000fe200078ee207ULL,
0x000000010c0c7824ULL, 0x000fc400078e0206ULL, 0x000000010e077824ULL, 0x040fe400078e0209ULL,
0x000000080e107824ULL, 0x000fe400078e00ffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0xfffffff810257812ULL, 0x000fe200078ee207ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000001a0a177212ULL, 0x000fc600078efcffULL, 0x0000001024127836ULL, 0x000fe20000000000ULL,
0x0000001a0c077212ULL, 0x000fe200078efcffULL, 0x0000000c24107836ULL, 0x000fe20000000000ULL,
0x0000001704167210ULL, 0x000fe20007f1e0ffULL, 0x00000001120c7824ULL, 0x040fe200078e0209ULL,
0x00000007040a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000812297824ULL, 0x000fe200078e00ffULL,
0x0000001b1000720cULL, 0x080fe20003f46070ULL, 0x0000000105177824ULL, 0x000fe200000e060bULL,
0x0000001b1200720cULL, 0x000fe20003f06070ULL, 0x00000001100f7824ULL, 0x000fe200078e0209ULL,
0xfffffff829297812ULL, 0x000fe200078ee20cULL, 0x000000010e0c7824ULL, 0x000fc400078e0206ULL,
0x0000000810147824ULL, 0x000fe400078e00ffULL, 0x00000001050b7824ULL, 0x000fe200008e060dULL,
0x0000001b0e00720cULL, 0x000fe20003f26070ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffff814277812ULL, 0x000fc600078ee20fULL, 0x00000001100e7824ULL, 0x100fe200078e0206ULL,
0x0000001a0c077212ULL, 0x000fe200078efcffULL, 0x0000000112107824ULL, 0x000fe400078e0206ULL,
0x0000001424227836ULL, 0x000fe20000000000ULL, 0x00000007040c7210ULL, 0x000fe20007f7e0ffULL,
0x0000001824267836ULL, 0x000fe40000000000ULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000001a0e137212ULL, 0x000fc600078efcffULL,
0x0000000122147824ULL, 0x100fe200078e0206ULL, 0x0000001a10077212ULL, 0x000fe200078efcffULL,
0x0000000126187824ULL, 0x000fe200078e0206ULL, 0x0000001304127210ULL, 0x000fe20007f9e0ffULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000001a141d7212ULL, 0x000fc600078efcffULL, 0x00000001050d7824ULL, 0x040fe200018e060dULL,
0x00000007040e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000105137824ULL, 0x040fe200020e060fULL,
0x0000001a18077212ULL, 0x000fe200078efcffULL, 0x0000001c242a7836ULL, 0x000fe20000000000ULL,
0x0000001d04107210ULL, 0x000fe20007f9e0ffULL, 0x00000001050f7824ULL, 0x000fe200018e0611ULL,
0x0000000704147210ULL, 0x000fe20007f7e0ffULL, 0x000000012a187824ULL, 0x000fe400078e0206ULL,
0x0000400077077824ULL, 0x000fc400078e0208ULL, 0x0000000105117824ULL, 0x040fe200020e0615ULL,
0x0000001b2400720cULL, 0x080fe20003f86070ULL, 0x0000000105157824ULL, 0x000fe200018e0619ULL,
0x0000001b2200720cULL, 0x000fe20003f66070ULL, 0x00000001241d7824ULL, 0x000fe400078e0209ULL,
0x0000008018187825ULL, 0x000fc600078e00ffULL, 0x000000071d1e7812ULL, 0x000fe200078ec0ffULL,
0x000020005c1c7824ULL, 0x000fe200078e0207ULL, 0x0000001a181d7212ULL, 0x000fe200078efcffULL,
0x00000020242c7836ULL, 0x000fe20000000000ULL, 0x0ffffff81e217812ULL, 0x000fe200078ef809ULL,
0x000020001c207836ULL, 0x000fe20000000000ULL, 0x0000001d04187210ULL, 0x000fe20007fde0ffULL,
0x000000012c1c7824ULL, 0x000fe400078e0206ULL, 0x00000001221f7824ULL, 0x040fe400078e0209ULL,
0x0000000822227824ULL, 0x000fc400078e00ffULL, 0x000000801c1c7825ULL, 0x000fc600078e00ffULL,
0xfffffff8222b7812ULL, 0x000fe200078ee21fULL, 0x00000024242e7836ULL, 0x000fe20000000000ULL,
0x0000001a1c1f7212ULL, 0x000fe200078efcffULL, 0x0000001021217824ULL, 0x000fe400078e0220ULL,
0x000000012e1e7824ULL, 0x000fe400078e0206ULL, 0x0000000105197824ULL, 0x000fe200030e0619ULL,
0x0000001f041c7210ULL, 0x000fe20007fde0ffULL, 0x0000002824307836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016217faeULL, 0x0003e2000e101c46ULL,
0x0000000126287824ULL, 0x040fe200078e0209ULL, 0x0000001b2600720cULL, 0x040fe20003f86070ULL,
0x00000008262d7824ULL, 0x000fc400078e00ffULL, 0x000000801e1e7825ULL, 0x000fc600078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee228ULL, 0x0000000130227824ULL, 0x000fe400078e0206ULL,
0x0000002c24287836ULL, 0x000fe40000000000ULL, 0x0000001023217824ULL, 0x002fe200078e0220ULL,
0x0000001a1e237212ULL, 0x000fe200078efcffULL, 0x0000008022167825ULL, 0x000fc600078e00ffULL,
0x000000000a217faeULL, 0x0003e2000e901c46ULL, 0x00000001051d7824ULL, 0x040fe200030e061dULL,
0x00000023041e7210ULL, 0x000fe20007fde0ffULL, 0x000000012a227824ULL, 0x000fe200078e0209ULL,
0x0000001a16237212ULL, 0x000fe200078efcffULL, 0x000000082a2f7824ULL, 0x040fe200078e00ffULL,
0x0000001b2a00720cULL, 0x000fe20003fa6070ULL, 0x00000001051f7824ULL, 0x000fe200030e061fULL,
0x0000002304167210ULL, 0x000fe20007fde0ffULL, 0x0000001025237824ULL, 0x000fe200078e0220ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee222ULL, 0x000000012c227824ULL, 0x000fc400078e0209ULL,
0x00000001280a7824ULL, 0x002fe200078e0206ULL, 0x000000000c237faeULL, 0x0003e2000c901c46ULL,
0x0000001027217824ULL, 0x000fe200078e0220ULL, 0x0000001b2c00720cULL, 0x000fe20003f26070ULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0x0000000012217faeULL, 0x0005e2000d101c46ULL,
0x000000082c277824ULL, 0x000fe200078e00ffULL, 0x0000001a0a257212ULL, 0x000fe200078efcffULL,
0x0000000105177824ULL, 0x000fe200030e0617ULL, 0x0000001b2e00720cULL, 0x040fe20003f46070ULL,
0x000000012e267824ULL, 0x040fe200078e0209ULL, 0x00000025040a7210ULL, 0x000fe20007fde0ffULL,
0x00000010290d7824ULL, 0x002fe200078e0220ULL, 0xfffffff827257812ULL, 0x000fe200078ee222ULL,
0x0000003024227836ULL, 0x000fe40000000000ULL, 0x000000082e317824ULL, 0x000fe200078e00ffULL,
0x000000000e0d7faeULL, 0x0003e2000c101c46ULL, 0x00000001220c7824ULL, 0x000fc400078e0206ULL,
0x000000102b137824ULL, 0x104fe200078e0220ULL, 0xfffffff831277812ULL, 0x000fe200078ee226ULL,
0x0000003424267836ULL, 0x000fe40000000000ULL, 0x00000001050b7824ULL, 0x000fe200030e060bULL,
0x0000000010137faeULL, 0x0005e2000d901c46ULL, 0x000000102d217824ULL, 0x100fe200078e0220ULL,
0x0000001b2200720cULL, 0x080fe20003f66070ULL, 0x000000102f237824ULL, 0x000fe400078e0220ULL,
0x000000800c0c7825ULL, 0x002fe200078e00ffULL, 0x0000000014217faeULL, 0x000fe2000e101c46ULL,
0x0000001b2800720cULL, 0x000fc40003f86070ULL, 0x00000001260e7824ULL, 0x000fe200078e0206ULL,
0x0000000018237faeULL, 0x0003e2000e901c46ULL, 0x0000001025257824ULL, 0x100fe200078e0220ULL,
0x0000001a0c117212ULL, 0x084fe200078efcffULL, 0x0000001027277824ULL, 0x000fe200078e0220ULL,
0x0000001b3000720cULL, 0x080fe20003fa6070ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001104107210ULL, 0x000fe20007fde0ffULL, 0x000000001c257faeULL, 0x000fe4000c901c46ULL,
0x00000038242a7836ULL, 0x000fe20000000000ULL, 0x0000001a0e137212ULL, 0x000fe200078efcffULL,
0x0000000105117824ULL, 0x000fe200030e060dULL, 0x000000001e277faeULL, 0x0005e2000d101c46ULL,
0x0000003c24247836ULL, 0x000fe20000000000ULL, 0x0000001b2600720cULL, 0x080fe20003f46070ULL,
0x00000001280d7824ULL, 0x100fe200078e0209ULL, 0x0000001b2a00720cULL, 0x080fe20003f26070ULL,
0x0000000130127824ULL, 0x000fe200078e0209ULL, 0x0000001b2400720cULL, 0x000fe20003f06070ULL,
0x0000000830197824ULL, 0x002fc400078e00ffULL, 0x0000000828287824ULL, 0x000fe400078e00ffULL,
0x00000001220e7824ULL, 0x140fe200078e0209ULL, 0xfffffff819197812ULL, 0x000fe200078ee212ULL,
0x00000008221f7824ULL, 0x004fe200078e00ffULL, 0xfffffff8281b7812ULL, 0x000fe200078ee20dULL,
0x000000012a0c7824ULL, 0x000fe200078e0206ULL, 0x0000001304127210ULL, 0x000fe20007fde0ffULL,
0x0000000126147824ULL, 0x000fe200078e0209ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20eULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x00000001240e7824ULL, 0x000fe200078e0206ULL,
0x0000001a0c157212ULL, 0x000fe200078efcffULL, 0x0000000105137824ULL, 0x000fe400030e060fULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x00000015040c7210ULL, 0x000fc60007fde0ffULL,
0x0000000826217824ULL, 0x000fe200078e00ffULL, 0x0000001a0e1d7212ULL, 0x000fe200078efcffULL,
0x000000012a067824ULL, 0x140fe400078e0209ULL, 0x000000082a237824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee214ULL, 0x0000000124187824ULL, 0x040fe400078e0209ULL,
0x0000000824257824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee206ULL,
0x00000001050d7824ULL, 0x000fe200030e060dULL, 0x0000001d04047210ULL, 0x000fe20007fde0ffULL,
0x0000001019157824ULL, 0x100fe200078e0220ULL, 0xfffffff825257812ULL, 0x000fe200078ee218ULL,
0x000000101b197824ULL, 0x000fc400078e0220ULL, 0x000000101f1b7824ULL, 0x100fe200078e0220ULL,
0x0000000016157faeULL, 0x0003e2000e901c46ULL, 0x00000010211d7824ULL, 0x100fe400078e0220ULL,
0x00000010231f7824ULL, 0x100fe200078e0220ULL, 0x000000000a197faeULL, 0x0003e2000e101c46ULL,
0x0000001025217824ULL, 0x000fe400078e0220ULL, 0x0000000105057824ULL, 0x000fe200030e060fULL,
0x00000000101b7faeULL, 0x0003e8000d901c46ULL, 0x00000000121d7faeULL, 0x0003e8000d101c46ULL,
0x000000000c1f7faeULL, 0x0003e8000c901c46ULL, 0x0000000004217faeULL, 0x0003e2000c101c46ULL,
0x0000000800dc7947ULL, 0x000fea0003800000ULL, 0x00000008090e7811ULL, 0x044fe400078fe8ffULL,
0x00000004090c7811ULL, 0x040fe400078fe8ffULL, 0x0000001009127811ULL, 0x040fe200078fe8ffULL,
0x000000010e0a7824ULL, 0x140fe200078e0209ULL, 0x0000001809167811ULL, 0x040fe200078fe8ffULL,
0x000000080e0b7824ULL, 0x000fe200078e00ffULL, 0x0000001409147811ULL, 0x040fe200078fe8ffULL,
0x000000010c077824ULL, 0x140fe200078e0209ULL, 0x0000000c09107811ULL, 0x040fe200078fe8ffULL,
0x000000080c247824ULL, 0x000fe200078e00ffULL, 0xfffffff80b267812ULL, 0x000fe200078ee20aULL,
0x00000001120a7824ULL, 0x140fe200078e0209ULL, 0x00000020091a7811ULL, 0x040fe200078fe8ffULL,
0x00000008120f7824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee207ULL,
0x00000001160d7824ULL, 0x140fe200078e0209ULL, 0x00000028091e7811ULL, 0x040fe200078fe8ffULL,
0x0000000816347824ULL, 0x000fe200078e00ffULL, 0x00000024091c7811ULL, 0x040fe200078fe8ffULL,
0x00000001140b7824ULL, 0x140fe200078e0209ULL, 0x0000001c09187811ULL, 0x040fe200078fe8ffULL,
0x0000000814327824ULL, 0x000fe200078e00ffULL, 0xfffffff80f307812ULL, 0x000fe200078ee20aULL,
0x0000000110077824ULL, 0x140fe200078e0209ULL, 0xfffffff834347812ULL, 0x000fe200078ee20dULL,
0x0000000810287824ULL, 0x000fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe200078ee20bULL,
0x000000011a0a7824ULL, 0x140fe200078e0209ULL, 0x00000030092a7811ULL, 0x040fe200078fe8ffULL,
0x000000081a0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee207ULL,
0x000000011e0d7824ULL, 0x140fe200078e0209ULL, 0x00000038092e7811ULL, 0x040fe200078fe8ffULL,
0x000000081e3c7824ULL, 0x000fe200078e00ffULL, 0x00000034092c7811ULL, 0x040fe200078fe8ffULL,
0x000000011c0b7824ULL, 0x140fe200078e0209ULL, 0x0000002c09207811ULL, 0x000fe200078fe8ffULL,
0x000000081c3a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f387812ULL, 0x000fe200078ee20aULL,
0x0000000118077824ULL, 0x140fe200078e0209ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee20dULL,
0x0000000818367824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee20bULL,
0x000000012a0a7824ULL, 0x000fc400078e0209ULL, 0x000000082a0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee207ULL, 0x000000012e0d7824ULL, 0x140fe400078e0209ULL,
0x000000082e447824ULL, 0x000fe200078e00ffULL, 0xfffffff80f407812ULL, 0x000fe200078ee20aULL,
0x000000012c0b7824ULL, 0x140fe200078e0209ULL, 0x0000003c090f7811ULL, 0x040fe200078fe8ffULL,
0x000000082c427824ULL, 0x000fe200078e00ffULL, 0xfffffff844447812ULL, 0x000fe200078ee20dULL,
0x0000000120077824ULL, 0x140fe200078e0209ULL, 0x00000006090a7211ULL, 0x040fe200078fe8ffULL,
0x00000008203e7824ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee20bULL,
0x00000010090d7824ULL, 0x040fe200078e00ffULL, 0x00000009090b7211ULL, 0x000fe200078fe8ffULL,
0x000000010f117824ULL, 0x000fe200078e0209ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee207ULL,
0x0000400077077824ULL, 0x000fe200078e0208ULL, 0x000000070b227812ULL, 0x000fe200078ec0ffULL,
0x000000080f467824ULL, 0x000fe200078e00ffULL, 0x000000700d4b7812ULL, 0x000fe200078ec0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0ffffff822227812ULL, 0x000fc400078ef809ULL,
0xfffffff846467812ULL, 0x000fe200078ee211ULL, 0x000020005c0d7824ULL, 0x000fe200078e0207ULL,
0x0000004b0a117212ULL, 0x000fe200078efcffULL, 0x000000010c0c7824ULL, 0x100fe400078e0206ULL,
0x000020000d497836ULL, 0x000fe20000000000ULL, 0x00000011040a7210ULL, 0x000fe20007f1e0ffULL,
0x000000010e0e7824ULL, 0x000fe400078e0206ULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x0000000110107824ULL, 0x100fe200078e0206ULL, 0x0000004b0c117212ULL, 0x000fe200078efcffULL,
0x0000000112127824ULL, 0x100fe400078e0206ULL, 0x0000000114147824ULL, 0x100fe200078e0206ULL,
0x00000011040c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000116167824ULL, 0x100fe400078e0206ULL,
0x0000000118187824ULL, 0x100fe400078e0206ULL, 0x000000011a1a7824ULL, 0x000fc400078e0206ULL,
0x000000011c1c7824ULL, 0x100fe400078e0206ULL, 0x000000011e1e7824ULL, 0x100fe400078e0206ULL,
0x0000000120207824ULL, 0x100fe400078e0206ULL, 0x000000012a2a7824ULL, 0x100fe400078e0206ULL,
0x000000012c2c7824ULL, 0x100fe400078e0206ULL, 0x000000012e2e7824ULL, 0x000fc400078e0206ULL,
0x000000010f067824ULL, 0x000fe400078e0206ULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000004b0e157212ULL, 0x000fc600078efcffULL,
0x00000001050b7824ULL, 0x000fe200000e060bULL, 0x00000015040e7210ULL, 0x000fe20007f1e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004b10197212ULL, 0x000fc600078efcffULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x00000001050f7824ULL, 0x040fe200000e060fULL,
0x0000001904107210ULL, 0x000fe20007f1e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000004b16197212ULL, 0x080fe400078efcffULL, 0x0000004b141b7212ULL, 0x080fe200078efcffULL,
0x0000000105117824ULL, 0x000fe200000e0611ULL, 0x0000001904167210ULL, 0x000fe20007f5e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000004b121d7212ULL, 0x080fe400078efcffULL,
0x0000001b04147210ULL, 0x000fe20007f1e0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000004b18237212ULL, 0x000fc600078efcffULL, 0x00000001050d7824ULL, 0x000fe200008e060dULL,
0x0000001d04127210ULL, 0x000fe20007f3e0ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000004b1a257212ULL, 0x000fc600078efcffULL, 0x00000010222b7824ULL, 0x000fe200078e0249ULL,
0x0000004b1c277212ULL, 0x080fe200078efcffULL, 0x0000000105157824ULL, 0x040fe200000e0615ULL,
0x0000002304227210ULL, 0x000fe20007f1e0ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a2b7faeULL, 0x0003e6000b901c46ULL,
0x00000010242d7824ULL, 0x000fe200078e0249ULL, 0x0000004b1e297212ULL, 0x000fe200078efcffULL,
0x0000000105137824ULL, 0x000fe200008e0613ULL, 0x0000002504247210ULL, 0x000fe20007f3e0ffULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x000000000c2d7faeULL, 0x0003e6000b901c46ULL,
0x00000010262f7824ULL, 0x000fc400078e0249ULL, 0x0000000105237824ULL, 0x040fe200000e0619ULL,
0x0000002704267210ULL, 0x000fe20007f1e0ffULL, 0x0000000105257824ULL, 0x040fe200008e061bULL,
0x0000004b201b7212ULL, 0x080fe200078efcffULL, 0x0000001028317824ULL, 0x000fe200078e0249ULL,
0x000000000e2f7faeULL, 0x0003e2000b901c46ULL, 0x0000000105177824ULL, 0x040fe200010e0617ULL,
0x0000002904287210ULL, 0x000fe20007f5e0ffULL, 0x0000000105277824ULL, 0x000fe200000e061dULL,
0x0000001b04207210ULL, 0x000fe20007f1e0ffULL, 0x000000802a187825ULL, 0x000fe200078e00ffULL,
0x0000000010317faeULL, 0x0003e6000b901c46ULL, 0x000000802c1a7825ULL, 0x000fe200078e00ffULL,
0x0000004b18557212ULL, 0x000fc600078efcffULL, 0x0000000105297824ULL, 0x000fe200010e061fULL,
0x0000004b1a4f7212ULL, 0x000fe200078efcffULL, 0x000000802e1c7825ULL, 0x000fc600078e00ffULL,
0x0000004f041a7210ULL, 0x000fe20007f3e0ffULL, 0x00000080061e7825ULL, 0x000fe200078e00ffULL,
0x0000004b1c4d7212ULL, 0x000fc600078efcffULL, 0x0000001030337824ULL, 0x100fe200078e0249ULL,
0x0000004b1e4b7212ULL, 0x000fe200078efcffULL, 0x0000001032357824ULL, 0x100fe200078e0249ULL,
0x0000004d041c7210ULL, 0x000fe20007f5e0ffULL, 0x0000001034377824ULL, 0x000fe200078e0249ULL,
0x0000000012337faeULL, 0x0003e2000b901c46ULL, 0x0000000105217824ULL, 0x000fe200000e0621ULL,
0x0000005504187210ULL, 0x000fe20007f1e0ffULL, 0x0000001036397824ULL, 0x100fe200078e0249ULL,
0x0000004b04047210ULL, 0x000fe20007f7e0ffULL, 0x00000010383b7824ULL, 0x100fe200078e0249ULL,
0x0000000014357faeULL, 0x0003e2000b901c46ULL, 0x000000103a3d7824ULL, 0x000fc400078e0249ULL,
0x000000103c3f7824ULL, 0x100fe200078e0249ULL, 0x0000000016377faeULL, 0x0003e2000b901c46ULL,
0x000000103e417824ULL, 0x100fe400078e0249ULL, 0x0000001040437824ULL, 0x000fe200078e0249ULL,
0x0000000022397faeULL, 0x0003e2000b901c46ULL, 0x0000000105197824ULL, 0x040fe400000e0619ULL,
0x0000001042457824ULL, 0x000fe200078e0249ULL, 0x00000000243b7faeULL, 0x0003e2000b901c46ULL,
0x00000001051b7824ULL, 0x000fc400008e061bULL, 0x0000001044477824ULL, 0x000fe200078e0249ULL,
0x00000000263d7faeULL, 0x0003e2000b901c46ULL, 0x00000001051d7824ULL, 0x040fe400010e061dULL,
0x0000001046497824ULL, 0x000fe200078e0249ULL, 0x00000000283f7faeULL, 0x0003e2000b901c46ULL,
0x0000000105057824ULL, 0x000fc600018e061fULL, 0x0000000020417faeULL, 0x0003e8000b901c46ULL,
0x0000000018437faeULL, 0x0003e8000b901c46ULL, 0x000000001a457faeULL, 0x0003e8000b901c46ULL,
0x000000001c477faeULL, 0x0003e8000b901c46ULL, 0x0000000004497faeULL, 0x0003e4000b901c46ULL,
0x000000027e7e7836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff7f7424ULL, 0x000fc600078e00ffULL, 0x000000757e00720cULL, 0x000fda0003f06070ULL,
0x00009200ff048b82ULL, 0x002e620000000a00ULL, 0x000000027a0b8824ULL, 0x000fe200078e027eULL,
0x0000000809507812ULL, 0x040fe200078ec0ffULL, 0x0000002009727836ULL, 0x000fe40000000000ULL,
0x0000200002527824ULL, 0x000fe200078e0207ULL, 0xfffffff809027812ULL, 0x000fe200078ec0ffULL,
0x000000ffff7b7224ULL, 0x000fe200078e00ffULL, 0xfffffff872727812ULL, 0x000fe400078ec0ffULL,
0x0000000000467805ULL, 0x000fc4000001ff00ULL, 0x0000000750507812ULL, 0x000fe400078ef809ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x0000000702737812ULL, 0x000fe400078ef809ULL,
0x0000000000067805ULL, 0x000fe4000001ff00ULL, 0x00000004ff0a7819ULL, 0x000fe40000011609ULL,
0x00000000000e7805ULL, 0x000fc4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000040b048825ULL, 0x002fe200078e0004ULL,
0x00000007090b7812ULL, 0x000fe400078ec0ffULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000006047f8981ULL, 0x000322000c1e1900ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000047805ULL, 0x002fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fc4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000200052527836ULL, 0x000fe20000000000ULL, 0x0000000772727812ULL, 0x000fe200078ef809ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000001050027812ULL, 0x000fce00078efcffULL,
0x0000000173487824ULL, 0x140fe400078e027bULL, 0x0000000873497824ULL, 0x000fe400078e00ffULL,
0x000000027b837824ULL, 0x000fe400078e020aULL, 0x0000001050577824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee248ULL, 0x0000000172487824ULL, 0x000fe400078e027bULL,
0x000000017b557836ULL, 0x000fc40000000000ULL, 0x00000010494c7824ULL, 0x100fe400078e0252ULL,
0x0000000872497824ULL, 0x000fe400078e00ffULL, 0x0000000150547824ULL, 0x000fe400078e0283ULL,
0x000000004c4c783bULL, 0x000e620000000200ULL, 0xfffffff849497812ULL, 0x000fe200078ee248ULL,
0x00000001736d7824ULL, 0x100fe400078e0255ULL, 0x0000000172597824ULL, 0x000fe200078e0255ULL,
0xfffffff057557812ULL, 0x000fe200078ee254ULL, 0x0000001049497824ULL, 0x000fc400078e0252ULL,
0x0000000873587824ULL, 0x000fe400078e00ffULL, 0x00000008725a7824ULL, 0x000fe400078e00ffULL,
0x000000004948783bULL, 0x000ea20000000200ULL, 0x0000001002567824ULL, 0x040fe200078e00ffULL,
0xfffffff8586d7812ULL, 0x000fe200078ee26dULL, 0x00000001025b7824ULL, 0x000fe200078e0283ULL,
0xfffffff85a597812ULL, 0x000fe200078ee259ULL, 0x0000001055557824ULL, 0x000fe400078e0208ULL,
0x0000000283837836ULL, 0x000fe20000000000ULL, 0xfffffff0565b7812ULL, 0x000fe200078ee25bULL,
0x0000001059597824ULL, 0x000fc400078e0252ULL, 0x000000005554783bULL, 0x000ee20000000200ULL,
0x000000027b7b7836ULL, 0x000fca0000000000ULL, 0x000000087b00780cULL, 0x000fe40003f05270ULL,
0x00000018ff5e7819ULL, 0x102fe4000001164dULL, 0x00000010ff877819ULL, 0x000fe4000001164dULL,
0x000000ff4d6c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4d8d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f607812ULL, 0x000fc400078ec0ffULL, 0x00000010ff8a7819ULL, 0x000fe4000001164eULL,
0x00000010ff887819ULL, 0x104fe40000011648ULL, 0x00000018ff617819ULL, 0x000fe40000011648ULL,
0x000000ff48657812ULL, 0x040fe400078ec0ffULL, 0x0000ffff484d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6f7819ULL, 0x000fc4000001164eULL, 0x000000ff4e857812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e897812ULL, 0x000fe400078ec0ffULL, 0x00000018ff487819ULL, 0x000fe40000011649ULL,
0x00000010ff677819ULL, 0x000fe4000001164cULL, 0x0000005eff4e723eULL, 0x000fe400020006ffULL,
0x00000060ff5e723eULL, 0x000fc400020006ffULL, 0x00000065ff60723eULL, 0x000fe400020006ffULL,
0x00000048ff65723eULL, 0x000fe400020006ffULL, 0x000000ff67487812ULL, 0x000fe400078ec0ffULL,
0x0000ffff4c8c7812ULL, 0x000fe400078ec0ffULL, 0x00000048ff8b723eULL, 0x000fe400020006ffULL,
0x00000018ff6b7819ULL, 0x000fc4000001164cULL, 0x000000ff4c6a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff487819ULL, 0x000fe4000001168cULL, 0x00000010ff4c7819ULL, 0x000fe40000011649ULL,
0x000000ff49827812ULL, 0x040fe400078ec0ffULL, 0x0000ffff496e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff587819ULL, 0x000fc4000001164aULL, 0x00000018ff497819ULL, 0x000fe4000001164aULL,
0x000000ff4a687812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4a5a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff8a4a7812ULL, 0x000fe400078ec0ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x00000048ff8a723eULL, 0x000fe200020006ffULL, 0x000000105b487824ULL, 0x000fe200078e0208ULL,
0x00000008ff4d7819ULL, 0x000fc4000001164dULL, 0x000000ff87877812ULL, 0x000fe400078ec0ffULL,
0x00000049ff67723eULL, 0x000fe400020006ffULL, 0x000054106a6a7816ULL, 0x000fe4000000008aULL,
0x00000010ff867819ULL, 0x100fe4000001164fULL, 0x00000018ff5f7819ULL, 0x000fe4000001164fULL,
0x00000008ff497819ULL, 0x000fc4000001168dULL, 0x0000004dff8a723eULL, 0x000fe200020006ffULL,
0x000000106d4d7824ULL, 0x000fe200078e0252ULL, 0x0000ffff4f4f7812ULL, 0x000fe400078ec0ffULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x00000087ff8d723eULL, 0x000fe400020006ffULL,
0x00000049ff8c723eULL, 0x000fe400020006ffULL, 0x000000ff86497812ULL, 0x000fc400078ec0ffULL,
0x000054108b6b7816ULL, 0x000fe4000000006bULL, 0x00000008ff867819ULL, 0x000fe4000001164fULL,
0x000000ff4c8b7812ULL, 0x000fe400078ec0ffULL, 0x000054108d6d7816ULL, 0x000fe2000000004eULL,
0x0000006a5440723cULL, 0x008fe20000001840ULL, 0x000000004d4c783bULL, 0x000fe20000000200ULL,
0x000000ff885b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x000fc4000001164bULL,
0x00000018ff697819ULL, 0x000fe4000001164bULL, 0x000000ff4b667812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4b847812ULL, 0x000fe400078ec0ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x0000004aff87723eULL, 0x000fe400020006ffULL, 0x00000049ff88723eULL, 0x000fc400020006ffULL,
0x000000004848783bULL, 0x000e620000000200ULL, 0x00000008ff897819ULL, 0x000fe40000011689ULL,
0x000054106c6c7816ULL, 0x000fe4000000008cULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x00000008ff8c7819ULL, 0x000fe4000001166eULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x0000006c543c723cULL, 0x000fe2000000183cULL, 0x00000089ff89723eULL, 0x000fc400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00005410876f7816ULL, 0x000fe4000000006fULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000008ff5a7819ULL, 0x000fe4000001165aULL, 0x000000ff58587812ULL, 0x000fc400078ec0ffULL,
0x000000ff64877812ULL, 0x000fe400078ec0ffULL, 0x00000008ff847819ULL, 0x000fe40000011684ULL,
0x00005410856e7816ULL, 0x000fe40000000089ULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x000054105e5e7816ULL, 0x000fe40000000086ULL, 0x0000005aff85723eULL, 0x000fe200020006ffULL,
0x0000006e5438723cULL, 0x000fe20000001838ULL, 0x0000541082647816ULL, 0x000fc4000000008cULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x0000006a4820723cULL, 0x002fe20000001820ULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x0000006c481c723cULL, 0x000fe2000000181cULL, 0x00000058ff86723eULL, 0x000fc400020006ffULL,
0x00000066ff82723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x0000006e4818723cULL, 0x000fe20000001818ULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x0000541068667816ULL, 0x000fe40000000085ULL, 0x00005410885f7816ULL, 0x000fe4000000005fULL,
0x000054105b617816ULL, 0x000fc40000000061ULL, 0x0000541060607816ULL, 0x000fe2000000008aULL,
0x000000005958783bULL, 0x000e620000000200ULL, 0x000054108b657816ULL, 0x000fe20000000065ULL,
0x0000005e5434723cULL, 0x000fe20000001834ULL, 0x0000541086677816ULL, 0x000fe40000000067ULL,
0x0000541087697816ULL, 0x000fe40000000069ULL, 0x0000541082687816ULL, 0x000fe20000000084ULL,
0x000000605430723cULL, 0x000fe20000001830ULL, 0x00000010ff8d7819ULL, 0x000fc4000001164cULL,
0x00000018ff897819ULL, 0x000fe4000001164cULL, 0x000000ff4c887812ULL, 0x040fe200078ec0ffULL,
0x00000064542c723cULL, 0x000fe2000000182cULL, 0x0000ffff4c8e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8f7819ULL, 0x000fe4000001164dULL, 0x000000ff4d857812ULL, 0x040fe200078ec0ffULL,
0x000000665428723cULL, 0x000fe20000001828ULL, 0x0000ffff4d907812ULL, 0x000fc400078ec0ffULL,
0x00000010ff8a7819ULL, 0x100fe4000001164eULL, 0x00000018ff957819ULL, 0x000fe2000001164eULL,
0x000000685424723cULL, 0x000fe20000001824ULL, 0x000000ff4e967812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e8b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8c7819ULL, 0x100fe2000001164fULL,
0x0000005e4814723cULL, 0x000fe20000001814ULL, 0x0000001050577824ULL, 0x040fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe2000001164fULL, 0x0000000150547824ULL, 0x100fe200078e0283ULL,
0x000000ff4f937812ULL, 0x000fe200078ec0ffULL, 0x0000001002567824ULL, 0x040fe200078e00ffULL,
0x000000604810723cULL, 0x000fe20000001810ULL, 0x0000000102557824ULL, 0x000fe200078e0283ULL,
0xfffffff057577812ULL, 0x000fc400078ee254ULL, 0x0000ffff4f547812ULL, 0x000fe400078ec0ffULL,
0xfffffff056557812ULL, 0x000fe200078ee255ULL, 0x00000010574c7824ULL, 0x000fe200078e0208ULL,
0x00000018ff567819ULL, 0x000fe2000001164dULL, 0x00000064480c723cULL, 0x000fe2000000180cULL,
0x00000010ff867819ULL, 0x002fe20000011658ULL, 0x0000001055557824ULL, 0x000fe200078e0208ULL,
0x00000018ff987819ULL, 0x000fe20000011658ULL, 0x000000004c4c783bULL, 0x000e620000000200ULL,
0x000000ff58947812ULL, 0x000fe200078ec0ffULL, 0x000000664804723cULL, 0x000fe20000001804ULL,
0x000000ff8f647812ULL, 0x000fc400078ec0ffULL, 0x0000ffff58877812ULL, 0x000fe400078ec0ffULL,
0x00000056ff57723eULL, 0x000fe200020006ffULL, 0x000000684844723cULL, 0x000fe20000001844ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x000000005548783bULL, 0x000ea20000000200ULL,
0x00000010ff587819ULL, 0x000fe40000011659ULL, 0x00000008ff657819ULL, 0x000fe40000011690ULL,
0x000000ff8a677812ULL, 0x000fc400078ec0ffULL, 0x00000008ff667819ULL, 0x000fe4000001168bULL,
0x0000ffff59837812ULL, 0x000fe400078ec0ffULL, 0x00000010ff847819ULL, 0x000fe4000001165aULL,
0x0000ffff5a827812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6e7819ULL, 0x000fe4000001165bULL,
0x0000ffff5b6f7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff927819ULL, 0x000fe40000011659ULL,
0x000000ff596d7812ULL, 0x000fe400078ec0ffULL, 0x00000085ff56723eULL, 0x000fe400020006ffULL,
0x0000541064577816ULL, 0x000fe40000000057ULL, 0x00000095ff59723eULL, 0x000fe400020006ffULL,
0x00000096ff85723eULL, 0x000fc400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x000000ff58647812ULL, 0x000fe400078ec0ffULL, 0x00000018ff917819ULL, 0x000fe4000001165aULL,
0x000000ff5a6c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001165bULL,
0x000000ff5b6b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8e7819ULL, 0x000fe4000001168eULL, 0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff697819ULL, 0x000fc40000011654ULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x00000008ff877819ULL, 0x000fe40000011687ULL, 0x00000008ff837819ULL, 0x000fe40000011683ULL,
0x000000ff84847812ULL, 0x000fe400078ec0ffULL, 0x00000008ff827819ULL, 0x000fe40000011682ULL,
0x000000ff6e6e7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff6f7819ULL, 0x000fe4000001166fULL,
0x00000092ff61723eULL, 0x000fe400020006ffULL, 0x0000006dff60723eULL, 0x000fe400020006ffULL,
0x0000541056567816ULL, 0x000fe40000000065ULL, 0x0000541067597816ULL, 0x000fe40000000059ULL,
0x0000541085587816ULL, 0x000fc40000000066ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x000000564c3c723cULL, 0x002fe2000000183cULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000097ff5b723eULL, 0x000fe200020006ffULL,
0x000000584c38723cULL, 0x000fe20000001838ULL, 0x00000093ff5a723eULL, 0x000fe400020006ffULL,
0x00000098ff5f723eULL, 0x000fc400020006ffULL, 0x00000094ff5e723eULL, 0x000fe200020006ffULL,
0x00000056481c723cULL, 0x004fe2000000181cULL, 0x00000091ff6d723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x000000584818723cULL, 0x000fe20000001818ULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x0000008eff8e723eULL, 0x000fc400020006ffULL, 0x0000008cff68723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000084ff65723eULL, 0x000fc400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x0000006bff66723eULL, 0x000fe400020006ffULL, 0x0000006eff67723eULL, 0x000fe400020006ffULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x0000541064617816ULL, 0x000fe40000000061ULL,
0x000054108d557816ULL, 0x000fc40000000089ULL, 0x0000541088547816ULL, 0x000fe4000000008eULL,
0x00005410685b7816ULL, 0x000fe4000000005bULL, 0x000054105a5a7816ULL, 0x000fe40000000069ULL,
0x00005410865f7816ULL, 0x000fe2000000005fULL, 0x000000544c40723cULL, 0x000fe20000001840ULL,
0x000054105e5e7816ULL, 0x000fe40000000087ULL, 0x0000541060607816ULL, 0x000fc40000000083ULL,
0x0000541065657816ULL, 0x000fe2000000006dULL, 0x0000005a4c34723cULL, 0x000fe20000001834ULL,
0x000054106c647816ULL, 0x000fe40000000082ULL, 0x0000541067677816ULL, 0x000fe4000000006aULL,
0x0000541066667816ULL, 0x000fe2000000006fULL, 0x0000005e4c30723cULL, 0x000fec0000001830ULL,
0x000000604c2c723cULL, 0x000fec000000182cULL, 0x000000644c28723cULL, 0x000fec0000001828ULL,
0x000000664c24723cULL, 0x000fec0000001824ULL, 0x000000544820723cULL, 0x000fec0000001820ULL,
0x0000005a4814723cULL, 0x000fec0000001814ULL, 0x0000005e4810723cULL, 0x000fec0000001810ULL,
0x00000060480c723cULL, 0x000fec000000180cULL, 0x000000644804723cULL, 0x000fec0000001804ULL,
0x000000664844723cULL, 0x000fe20000001844ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffec00c40947ULL, 0x000fde000383ffffULL, 0x00000001ff4c7424ULL, 0x000fe400078e00ffULL,
0x0000007140497220ULL, 0x080fe20000410000ULL, 0x00000071204b7220ULL, 0x080fe20000410000ULL,
0x0000007141417220ULL, 0x080fe20000410000ULL, 0x0000007142427220ULL, 0x080fe20000410000ULL,
0x0000007143437220ULL, 0x080fe20000410000ULL, 0x01a6884c514c79a7ULL, 0x000262000850003fULL,
0x000000713c3c7220ULL, 0x080fe20000410000ULL, 0x000000713d3d7220ULL, 0x080fe20000410000ULL,
0x000000713e3e7220ULL, 0x080fe20000410000ULL, 0x000000713f3f7220ULL, 0x080fe20000410000ULL,
0x0000007138387220ULL, 0x080fe20000410000ULL, 0x0000007139397220ULL, 0x080fe20000410000ULL,
0x000000713a3a7220ULL, 0x080fe20000410000ULL, 0x000000713b3b7220ULL, 0x080fe20000410000ULL,
0x0000007134347220ULL, 0x080fe20000410000ULL, 0x0000007135357220ULL, 0x080fe20000410000ULL,
0x0000007136367220ULL, 0x080fe20000410000ULL, 0x0000007137377220ULL, 0x080fe20000410000ULL,
0x0000007130307220ULL, 0x080fe20000410000ULL, 0x0000007131317220ULL, 0x080fe20000410000ULL,
0x0000007132327220ULL, 0x080fe20000410000ULL, 0x0000007133337220ULL, 0x080fe20000410000ULL,
0x000000712c2c7220ULL, 0x080fe20000410000ULL, 0x000000712d2d7220ULL, 0x080fe20000410000ULL,
0x000000712e2e7220ULL, 0x080fe20000410000ULL, 0x000000712f2f7220ULL, 0x080fe20000410000ULL,
0x0000007128287220ULL, 0x080fe20000410000ULL, 0x0000007129297220ULL, 0x080fe20000410000ULL,
0x000000712a2a7220ULL, 0x080fe20000410000ULL, 0x000000712b2b7220ULL, 0x080fe20000410000ULL,
0x0000007124247220ULL, 0x080fe20000410000ULL, 0x0000007125257220ULL, 0x080fe20000410000ULL,
0x0000007126267220ULL, 0x080fe20000410000ULL, 0x0000007127277220ULL, 0x080fe20000410000ULL,
0x0000007121217220ULL, 0x080fe20000410000ULL, 0x0000007122227220ULL, 0x080fe20000410000ULL,
0x0000007123237220ULL, 0x080fe20000410000ULL, 0x000000711c1c7220ULL, 0x080fe20000410000ULL,
0x000000711d1d7220ULL, 0x080fe20000410000ULL, 0x000000711e1e7220ULL, 0x080fe20000410000ULL,
0x000000711f1f7220ULL, 0x080fe20000410000ULL, 0x0000007118187220ULL, 0x080fe20000410000ULL,
0x0000007119197220ULL, 0x080fe20000410000ULL, 0x000000711a1a7220ULL, 0x080fe20000410000ULL,
0x000000711b1b7220ULL, 0x080fe20000410000ULL, 0x0000007114147220ULL, 0x080fe20000410000ULL,
0x0000007115157220ULL, 0x080fe20000410000ULL, 0x0000007116167220ULL, 0x080fe20000410000ULL,
0x0000007117177220ULL, 0x080fe20000410000ULL, 0x0000007110107220ULL, 0x080fe20000410000ULL,
0x0000007111117220ULL, 0x080fe20000410000ULL, 0x0000007112127220ULL, 0x080fe20000410000ULL,
0x0000007113137220ULL, 0x080fe20000410000ULL, 0x000000710c0c7220ULL, 0x080fe20000410000ULL,
0x000000710d0d7220ULL, 0x080fe20000410000ULL, 0x000000710e0e7220ULL, 0x080fe20000410000ULL,
0x000000710f0f7220ULL, 0x080fe20000410000ULL, 0x0000007104027220ULL, 0x080fe20000410000ULL,
0x00000071050a7220ULL, 0x080fe20000410000ULL, 0x0000007106207220ULL, 0x080fe20000410000ULL,
0x0000007107407220ULL, 0x080fe20000410000ULL, 0x0000007144447220ULL, 0x080fe20000410000ULL,
0x0000007145457220ULL, 0x080fe20000410000ULL, 0x0000007146467220ULL, 0x080fe20000410000ULL,
0x0000007147477220ULL, 0x002fce0000410000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x01a6884d510075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff487224ULL, 0x000fce00078e00ffULL, 0x000000104800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fce0000015200ULL,
0x00000004064f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e07ULL,
0x003d09004f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000004f04047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000148487836ULL, 0x000fce0000000000ULL, 0x01a6884d510075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000409047824ULL, 0x000fe200078e00ffULL,
0x000000707d00720cULL, 0x000fe20003f06070ULL, 0x0000008077057824ULL, 0x000fc600078e0208ULL,
0xfffffff004047812ULL, 0x000fca00078ec0ffULL, 0x0000000105487824ULL, 0x000fca00078e0204ULL,
0x01a4000048047984ULL, 0x0002a20000000c00ULL, 0x0000002000648947ULL, 0x000fea0003800000ULL,
0x0000860000047ab9ULL, 0x000fe20000000800ULL, 0x00000076094a7211ULL, 0x040fe200078ff0ffULL,
0x00000004004e7d06ULL, 0x000ee20008209000ULL, 0xffffff0053537836ULL, 0x000fe40000000000ULL,
0x0000000209b07824ULL, 0x000fe400078e00ffULL, 0x000000104a507836ULL, 0x000fe40000000000ULL,
0x000000184a547836ULL, 0x000fe20000000000ULL, 0x00000006b0b07812ULL, 0x000fca00078ec0ffULL,
0x00000001b0ae7824ULL, 0x000fe200078e0203ULL, 0x0000004e004e7308ULL, 0x008ee40000001000ULL,
0x0ffffffe4e4c7836ULL, 0x008fcc0000000000ULL, 0x0000004c004d7305ULL, 0x000764000021f000ULL,
0x000000ffff4c7224ULL, 0x008fe400078e00ffULL, 0x000000ffff4f7224ULL, 0x022fc800078e0a4dULL,
0x000000044f4f7c24ULL, 0x000fc8000f8e02ffULL, 0x0000004f4d557227ULL, 0x000fc800078e004cULL,
0x000000084a4d7836ULL, 0x000fe40000000000ULL, 0x0000004a554c7227ULL, 0x000fc800078e00ffULL,
0x0000004d554f7227ULL, 0x000fc800078e00ffULL, 0x000000ffff4e7224ULL, 0x000fe400078e0a4fULL,
0x0000005055527227ULL, 0x000fc800078e00ffULL, 0x000000044e4e7c24ULL, 0x000fe4000f8e024dULL,
0x000000ffff4d7224ULL, 0x000fe400078e0a4cULL, 0x0000005455567227ULL, 0x000fe200078e00ffULL,
0x000000044e007c0cULL, 0x000fc6000bf06070ULL, 0x000000044d4d7c24ULL, 0x000fe2000f8e024aULL,
0x00000053744a7248ULL, 0x000fe20007fe0000ULL, 0x000000ffff557224ULL, 0x000fe400078e0a52ULL,
0x000000ffff577224ULL, 0x000fe200078e0a56ULL, 0x000000044d007c0cULL, 0x000fe2000bfa6070ULL,
0x0000000455507c24ULL, 0x000fe4000f8e0250ULL, 0x0000000457547c24ULL, 0x000fe4000f8e0254ULL,
0x800000044e4e0c36ULL, 0x000fe20008000000ULL, 0x0000000450007c0cULL, 0x000fe2000bf46070ULL,
0x000000014f4f0836ULL, 0x000fe20000000000ULL, 0x0000000454007c0cULL, 0x000fe2000bf66070ULL,
0x000000014aaf7824ULL, 0x000fe200078e0a53ULL, 0x000000044e007c0cULL, 0x000fe2000bfc6070ULL,
0x000000015d4a7824ULL, 0x000fe200078e02b0ULL, 0x00000004ff537c12ULL, 0x000fe2000f8e33ffULL,
0x800000044d4d5c36ULL, 0x000fc40008000000ULL, 0x000000014c4c5836ULL, 0x000fe20000000000ULL,
0x000000af4a00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff4e7224ULL, 0x000fe200078e0aafULL,
0x000000044d007c0cULL, 0x000fe2000bf86070ULL, 0x8000000450502c36ULL, 0x000fe40008000000ULL,
0x8000000454543c36ULL, 0x000fe20008000000ULL, 0x0000004e4a4a7246ULL, 0x000fe20003800063ULL,
0x000000014f4f6836ULL, 0x000fe20000000000ULL, 0x0000000450007c0cULL, 0x000fe2000bf26070ULL,
0x0000000152522836ULL, 0x000fe20000000000ULL, 0x00000004ff007c0cULL, 0x000fe2000bfc5070ULL,
0x0000000156563836ULL, 0x000fe20000000000ULL, 0x0000000454007c0cULL, 0x000fc4000bf06070ULL,
0x0000004eaec07246ULL, 0x000fe20003800063ULL, 0x000000014c4c4836ULL, 0x000fe20000000000ULL,
0x000000afae00720cULL, 0x000fe40003f86070ULL, 0x00000004ff4a7819ULL, 0x000fe4000001164aULL,
0x0000004c534c7207ULL, 0x000fe20007000000ULL, 0x0000000152521836ULL, 0x000fe20000000000ULL,
0x000000ffc0c07207ULL, 0x000fe40002000000ULL, 0x0000004c634c7248ULL, 0x000fe20003fe0000ULL,
0x0000000156560836ULL, 0x000fe20000000000ULL, 0x000000ff4a4a7207ULL, 0x000fc40002800000ULL,
0x0000004f53507207ULL, 0x040fe20007000000ULL, 0x000000054c857c24ULL, 0x000fe2000f8e02ffULL,
0x0000005253527207ULL, 0x000fe40007000000ULL, 0x0000005063507248ULL, 0x000fe20003fe0000ULL,
0x0000000185557824ULL, 0x000fe200078e024aULL, 0x00000085c04d7211ULL, 0x000fe400078fe0ffULL,
0x0000005263837248ULL, 0x000fe20003fe0000ULL, 0x0000000255547825ULL, 0x000fe200078e0080ULL,
0x0000005653567207ULL, 0x000fc60007000000ULL, 0x000000024d4c7825ULL, 0x000fe200078e0080ULL,
0x0000000654ad7981ULL, 0x000ee2000c1e9500ULL, 0x0000005663567248ULL, 0x000fe40003fe0000ULL,
0x00000005507b7c24ULL, 0x000fe2000f8e02ffULL, 0x000000064cac7981ULL, 0x000ee2000c1e9500ULL,
0x0000000583837c24ULL, 0x000fe4000f8e02ffULL, 0x000000014a537824ULL, 0x000fe200078e027bULL,
0x0000007bc05f7211ULL, 0x000fe200078fe0ffULL, 0x000000014a5b7824ULL, 0x000fe200078e0283ULL,
0x00000083c0597211ULL, 0x000fe200078fe0ffULL, 0x0000000253527825ULL, 0x000fe200078e0080ULL,
0x00000010b0947812ULL, 0x000fc600078efcffULL, 0x0000000556577c24ULL, 0x000fe4000f8e02ffULL,
0x000000025f5e7825ULL, 0x100fe200078e0080ULL, 0x0000000652567981ULL, 0x000366000c1e9500ULL,
0x000000025b5a7825ULL, 0x000fc800078e0080ULL, 0x0000000259587825ULL, 0x000fe200078e0080ULL,
0x000000065e537981ULL, 0x002f66000c1e9500ULL, 0x000000015d507824ULL, 0x000fe400078e0294ULL,
0x000000014a617824ULL, 0x000fe200078e0257ULL, 0x00000006586b7981ULL, 0x000f62000c1e9500ULL,
0x0000000194967824ULL, 0x000fc600078e0203ULL, 0x000000065a4a7981ULL, 0x000f62000c1e9500ULL,
0x00000057c04f7211ULL, 0x000fe400078fe0ffULL, 0x0000004e50607246ULL, 0x000fe20003800063ULL,
0x0000000261547825ULL, 0x100fe200078e0080ULL, 0x000000af5000720cULL, 0x080fe40003f26070ULL,
0x000000af9600720cULL, 0x000fe20003f06070ULL, 0x000000024f4c7825ULL, 0x004fe200078e0080ULL,
0x00000004ff607819ULL, 0x000fe20000011660ULL, 0x00000006544f7981ULL, 0x0002a2000c1e9500ULL,
0x0000004e969e7246ULL, 0x000fc40003800063ULL, 0x000000ff60607207ULL, 0x000fe20000800000ULL,
0x000000064c527981ULL, 0x0002a2000c1e9500ULL, 0x000000ff9e9e7207ULL, 0x000fc60000000000ULL,
0x0000000160997824ULL, 0x000fe200078e027bULL, 0x000000859e9b7211ULL, 0x040fe200078fe0ffULL,
0x0000000185557824ULL, 0x002fe200078e0260ULL, 0x0000007b9e5f7211ULL, 0x000fe200078fe0ffULL,
0x0000000299987825ULL, 0x000fe200078e0080ULL, 0x00000020b0827812ULL, 0x000fc600078efcffULL,
0x000000029b9a7825ULL, 0x100fe200078e0080ULL, 0x000000579e617211ULL, 0x040fe200078fe0ffULL,
0x0000000698987981ULL, 0x000ea4000c1e9500ULL, 0x0000000255547825ULL, 0x100fe200078e0080ULL,
0x000000839e5b7211ULL, 0x000fe200078fe0ffULL, 0x000000069a9a7981ULL, 0x000ea4000c1e9500ULL,
0x000000025f5e7825ULL, 0x000fe400078e0080ULL, 0x0000000654697981ULL, 0x0002a4000c1e9500ULL,
0x00000001604d7824ULL, 0x000fc400078e0283ULL, 0x0000000160597824ULL, 0x000fe200078e0257ULL,
0x000000065e737981ULL, 0x000ea2000c1e9500ULL, 0x000000015d607824ULL, 0x000fe400078e0282ULL,
0x0000000182847824ULL, 0x000fe400078e0203ULL, 0x0000000261547825ULL, 0x002fe200078e0080ULL,
0x0000004e60617246ULL, 0x000fc60003800063ULL, 0x000000025b5a7825ULL, 0x000fe200078e0080ULL,
0x000000af6000720cULL, 0x080fe20003f26070ULL, 0x00000006546d7981ULL, 0x000ea2000c1e9500ULL,
0x00000004ff617819ULL, 0x000fe20000011661ULL, 0x000000024d4c7825ULL, 0x100fe200078e0080ULL,
0x000000af8400720cULL, 0x000fe20003f06070ULL, 0x000000065a6f7981ULL, 0x0002a2000c1e9500ULL,
0x0000004e84a27246ULL, 0x000fe20003800063ULL, 0x0000000259587825ULL, 0x000fe400078e0080ULL,
0x000000064c4c7981ULL, 0x000ea2000c1e9500ULL, 0x000000ffa2a27207ULL, 0x000fc60000000000ULL,
0x0000000658507981ULL, 0x0002a4000c1e9500ULL, 0x000000ff615a7207ULL, 0x002fe40000800000ULL,
0x0000007ba25f7211ULL, 0x000fc600078fe0ffULL, 0x000000015a897824ULL, 0x000fe400078e027bULL,
0x000000025f5e7825ULL, 0x000fe200078e0080ULL, 0x00000085a2597211ULL, 0x000fc600078fe0ffULL,
0x0000000289887825ULL, 0x100fe200078e0080ULL, 0x000000065e657981ULL, 0x000ea2000c1e9500ULL,
0x00000083a2877211ULL, 0x040fe400078fe0ffULL, 0x0000000259587825ULL, 0x000fe400078e0080ULL,
0x0000000688887981ULL, 0x000ea2000c1e9500ULL, 0x00000057a24d7211ULL, 0x000fe200078fe0ffULL,
0x00000001858b7824ULL, 0x000fe400078e025aULL, 0x000000015a557824ULL, 0x040fe200078e0257ULL,
0x0000000658677981ULL, 0x0002a2000c1e9500ULL, 0x000000015a5b7824ULL, 0x000fe200078e0283ULL,
0x00000030b0607812ULL, 0x000fe200078efcffULL, 0x000000028b8a7825ULL, 0x000fc800078e0080ULL,
0x0000000287867825ULL, 0x100fe400078e0080ULL, 0x000000068a8a7981ULL, 0x000ea4000c1e9500ULL,
0x0000000255547825ULL, 0x100fe400078e0080ULL, 0x0000000686867981ULL, 0x000ea4000c1e9500ULL,
0x000000025b5a7825ULL, 0x100fe400078e0080ULL, 0x0000000654547981ULL, 0x000ea4000c1e9500ULL,
0x000000024d587825ULL, 0x002fc400078e0080ULL, 0x000000065a4d7981ULL, 0x000ea4000c1e9500ULL,
0x000000015d667824ULL, 0x000fe400078e0260ULL, 0x0000000658617981ULL, 0x0002a2000c1e9500ULL,
0x0000000160647824ULL, 0x000fe400078e0203ULL, 0x0000004e66687246ULL, 0x000fe40003800063ULL,
0x000000af6600720cULL, 0x080fe40003f26070ULL, 0x000000af6400720cULL, 0x000fc40003f06070ULL,
0x0000004e649c7246ULL, 0x000fe40003800063ULL, 0x00000004ff687819ULL, 0x000fe40000011668ULL,
0x000000ff9c9c7207ULL, 0x000fe40000000000ULL, 0x000000ff68667207ULL, 0x000fe40000800000ULL,
0x000000859c5f7211ULL, 0x040fe400078fe0ffULL, 0x000000839c597211ULL, 0x002fe200078fe0ffULL,
0x0000000185917824ULL, 0x000fc400078e0266ULL, 0x00000001668d7824ULL, 0x000fe400078e0283ULL,
0x000000025f5e7825ULL, 0x000fc800078e0080ULL, 0x0000000259587825ULL, 0x100fe400078e0080ULL,
0x000000065e5f7981ULL, 0x000ea4000c1e9500ULL, 0x0000000291907825ULL, 0x100fe400078e0080ULL,
0x0000000658597981ULL, 0x000ea4000c1e9500ULL, 0x000000028d8c7825ULL, 0x000fe400078e0080ULL,
0x00000006906a7981ULL, 0x0002a2000c1e9500ULL, 0x0000007b9c5b7211ULL, 0x000fc600078fe0ffULL,
0x000000068c4e7981ULL, 0x000ea2000c1e9500ULL, 0x00000001668f7824ULL, 0x000fe400078e027bULL,
0x000000025b5a7825ULL, 0x000fc800078e0080ULL, 0x000000028f8e7825ULL, 0x000fe400078e0080ULL,
0x000000065a5b7981ULL, 0x000ea2000c1e9500ULL, 0x000000579ca57211ULL, 0x000fc600078fe0ffULL,
0x000000068e687981ULL, 0x0002a2000c1e9500ULL, 0x0000000166a17824ULL, 0x000fe400078e0257ULL,
0x00000002a5a47825ULL, 0x000fc800078e0080ULL, 0x00000002a1a07825ULL, 0x000fe200078e0080ULL,
0x00000006a4577981ULL, 0x000ea8000c1e9500ULL, 0x00000006a0667981ULL, 0x0002a2000c1e9500ULL,
0xfffffff0c0c07812ULL, 0x000fe200078ec0ffULL, 0x00000001ff557424ULL, 0x000fc800078e00ffULL,
0x00000001afc07824ULL, 0x000fc800078e02c0ULL, 0x00000001aec67824ULL, 0x000fe200078e0ac0ULL,
0x00000001b0aa7812ULL, 0x000fc800078efcffULL, 0x000000c655ab7219ULL, 0x000fe200000006ffULL,
0x00000001aaa97824ULL, 0x000fe200078e0203ULL, 0x00000008b0a87812ULL, 0x000fc600078efcffULL,
0x00000001a9c47824ULL, 0x000fe200078e0ac0ULL, 0x00000009b0927812ULL, 0x000fe200078efcffULL,
0x00000001a8a67824ULL, 0x000fc600078e0203ULL, 0x000000c455a77219ULL, 0x000fe200000006ffULL,
0x00000001927b7824ULL, 0x000fe400078e0203ULL, 0x00000001a6c27824ULL, 0x100fe400078e0ac0ULL,
0x000000017bc07824ULL, 0x000fe200078e0ac0ULL, 0x00000011b0907812ULL, 0x002fe400078efcffULL,
0xfffffff09e9e7812ULL, 0x000fe400078ec0ffULL, 0x000000c255957219ULL, 0x000fc400000006ffULL,
0x000000c055977219ULL, 0x000fe200000006ffULL, 0x0000000190837824ULL, 0x000fe400078e0203ULL,
0x00000001af9e7824ULL, 0x000fe200078e029eULL, 0x00000018b08e7812ULL, 0x000fc600078efcffULL,
0x0000000196be7824ULL, 0x100fe400078e0a9eULL, 0x0000000183bc7824ULL, 0x000fe200078e0a9eULL,
0x00000019b08c7812ULL, 0x000fe400078efcffULL, 0x000000be55997219ULL, 0x000fe400000006ffULL,
0x00005410acac7816ULL, 0x008fc800000000adULL, 0x000000acabff7212ULL, 0x000fc800078ac0ffULL,
0x000000afae00720cULL, 0x000fc80002fa1470ULL, 0x000000afb000720cULL, 0x000fe40002fa1070ULL,
0x000000aca7ff7212ULL, 0x000fe4000782c0ffULL, 0xff80000049497808ULL, 0x000fe40002800000ULL,
0x0000541053567816ULL, 0x020fc80000000056ULL, 0x00000056abff7212ULL, 0x080fe4000784c0ffULL,
0x000054106b4a7816ULL, 0x000fe4000000004aULL, 0x00000056a7ff7212ULL, 0x000fe400078ac0ffULL,
0x0000004aabff7212ULL, 0x000fe4000788c0ffULL, 0x000000afae00720cULL, 0x0c0fe40001741470ULL,
0x000000afae00720cULL, 0x000fc40002781470ULL, 0x000000afa900720cULL, 0x0c0fe40000f21470ULL,
0x000000afa900720cULL, 0x080fe40002fa1470ULL, 0x000000afb000720cULL, 0x0c0fe40001741070ULL,
0x000000afb000720cULL, 0x080fe40002781070ULL, 0x000000afaa00720cULL, 0x0c0fe40000f21070ULL,
0x000000afaa00720cULL, 0x000fc40002fa1070ULL, 0x0000541052527816ULL, 0x004fe4000000004fULL,
0xff80000042427808ULL, 0x000fe40001000000ULL, 0xff8000004b4b7808ULL, 0x000fe40002000000ULL,
0xff80000041417808ULL, 0x000fe40000800000ULL, 0xff80000043437808ULL, 0x000fe40002800000ULL,
0x000000ac95ff7212ULL, 0x000fc4000786c0ffULL, 0x00000052abff7212ULL, 0x000fe4000780c0ffULL,
0x0000004aa7ff7212ULL, 0x040fe4000784c0ffULL, 0x00000052a7ff7212ULL, 0x000fe4000788c0ffULL,
0x0000005697ff7212ULL, 0x000fe4000782c0ffULL, 0x0000004a95ff7212ULL, 0x000fe400078ac0ffULL,
0x000000afae00720cULL, 0x000fc40000701470ULL, 0x000000afa900720cULL, 0x0c0fe40001741470ULL,
0x000000afa900720cULL, 0x080fe40002781470ULL, 0x000000afa600720cULL, 0x0c0fe40001f61470ULL,
0x000000afa600720cULL, 0x080fe40002fa1470ULL, 0x000000af7b00720cULL, 0x080fe40000f21470ULL,
0x000000afb000720cULL, 0x000fc40000701070ULL, 0x000000afaa00720cULL, 0x0c0fe40001741070ULL,
0x000000afaa00720cULL, 0x080fe40002781070ULL, 0x000000afa800720cULL, 0x0c0fe40001f61070ULL,
0x000000afa800720cULL, 0x080fe40002fa1070ULL, 0x000000af9200720cULL, 0x000fe40000f21070ULL,
0x000000bc559b7219ULL, 0x000fc400000006ffULL, 0x000054109a9a7816ULL, 0x000fe40000000069ULL,
0x0000541073987816ULL, 0x000fe20000000098ULL, 0x000000018e857824ULL, 0x100fe200078e0203ULL,
0xff80000022227808ULL, 0x000fe20000000000ULL, 0x000000018c877824ULL, 0x000fe200078e0203ULL,
0xff80000021217808ULL, 0x000fe40001000000ULL, 0xff80000023237808ULL, 0x000fe40002000000ULL,
0xff8000003c3c7808ULL, 0x000fc40001800000ULL, 0xff8000001c1c7808ULL, 0x000fe40002800000ULL,
0xff8000003f3f7808ULL, 0x000fe40000800000ULL, 0x0000005695ff7212ULL, 0x000fe4000780c0ffULL,
0x0000004a97ff7212ULL, 0x000fe4000784c0ffULL, 0x0000005295ff7212ULL, 0x080fe4000788c0ffULL,
0x0000005297ff7212ULL, 0x000fc4000786c0ffULL, 0x0000009a9bff7212ULL, 0x000fe400078ac0ffULL,
0x0000009899ff7212ULL, 0x000fe2000782c0ffULL, 0x0000000185ba7824ULL, 0x100fe200078e0a9eULL,
0x000000afa600720cULL, 0x0c0fe20000701470ULL, 0x00000001879e7824ULL, 0x000fe200078e0a9eULL,
0x000000afa600720cULL, 0x080fe40002781470ULL, 0x000000af7b00720cULL, 0x0c0fe40001741470ULL,
0x000000af7b00720cULL, 0x000fc40001f61470ULL, 0x000000af9600720cULL, 0x080fe40000f21470ULL,
0x000000af8300720cULL, 0x080fe40002fa1470ULL, 0xfffffff0a2a27812ULL, 0x000fe400078ec0ffULL,
0x000000afa800720cULL, 0x0c0fe40000701070ULL, 0x000000afa800720cULL, 0x080fe40002781070ULL,
0x000000af9200720cULL, 0x000fc40001741070ULL, 0x000000af9200720cULL, 0x080fe40001f61070ULL,
0x000000af9400720cULL, 0x080fe40000f21070ULL, 0x000000af9000720cULL, 0x000fe40002fa1070ULL,
0x000000ba559d7219ULL, 0x040fe400000006ffULL, 0x0000009e559e7219ULL, 0x000fe400000006ffULL,
0x000054106f4c7816ULL, 0x000fc4000000004cULL, 0x000054106d507816ULL, 0x000fe20000000050ULL,
0x00000001afa27824ULL, 0x000fe200078e02a2ULL, 0xff8000003e3e7808ULL, 0x000fe40000000000ULL,
0xff8000001e1e7808ULL, 0x000fe40002000000ULL, 0xff8000001d1d7808ULL, 0x000fe40001000000ULL,
0xff8000001f1f7808ULL, 0x000fe40001800000ULL, 0xff8000003a3a7808ULL, 0x000fc40000800000ULL,
0xff80000039397808ULL, 0x000fe40002800000ULL, 0x0000009a99ff7212ULL, 0x080fe4000780c0ffULL,
0x0000009a9dff7212ULL, 0x000fe4000788c0ffULL, 0x0000004c99ff7212ULL, 0x040fe4000784c0ffULL,
0x0000005099ff7212ULL, 0x000fe4000786c0ffULL, 0x0000004c9bff7212ULL, 0x000fc4000782c0ffULL,
0x000000989eff7212ULL, 0x000fe200078ac0ffULL, 0x0000000184b87824ULL, 0x000fe200078e0aa2ULL,
0x000000af9600720cULL, 0x0c0fe40000701470ULL, 0x000000af9600720cULL, 0x0c0fe40001741470ULL,
0x000000af9600720cULL, 0x080fe40001f61470ULL, 0x000000af8300720cULL, 0x080fe40000f21470ULL,
0x000000af8500720cULL, 0x000fc40002781470ULL, 0x000000af8700720cULL, 0x080fe40002fa1470ULL,
0x00000021b0727812ULL, 0x000fe400078efcffULL, 0x000000af9400720cULL, 0x0c0fe40000701070ULL,
0x000000af9400720cULL, 0x0c0fe40001741070ULL, 0x000000af9400720cULL, 0x080fe40001f61070ULL,
0x000000af9000720cULL, 0x000fc40000f21070ULL, 0x000000af8e00720cULL, 0x080fe40002781070ULL,
0x000000af8c00720cULL, 0x000fe40002fa1070ULL, 0x000000b8559f7219ULL, 0x000fe400000006ffULL,
0x0000541065657816ULL, 0x000fe20000000088ULL, 0x0000000172897824ULL, 0x000fe200078e0203ULL,
0xff80000038387808ULL, 0x000fe40000000000ULL, 0xff80000018187808ULL, 0x000fc40001000000ULL,
0xff8000001a1a7808ULL, 0x000fe40001800000ULL, 0xff80000019197808ULL, 0x000fe40000800000ULL,
0xff80000034347808ULL, 0x000fe40002000000ULL, 0xff80000037377808ULL, 0x000fe40002800000ULL,
0x000000989bff7212ULL, 0x040fe4000780c0ffULL, 0x000000509bff7212ULL, 0x000fc4000784c0ffULL,
0x000000989dff7212ULL, 0x000fe4000786c0ffULL, 0x0000004c9eff7212ULL, 0x040fe4000782c0ffULL,
0x000000509eff7212ULL, 0x000fe4000788c0ffULL, 0x000000659fff7212ULL, 0x000fe200078ac0ffULL,
0x0000000189a07824ULL, 0x000fe200078e0aa2ULL, 0x000000af8300720cULL, 0x0c0fe40000701470ULL,
0x000000af8300720cULL, 0x000fc40001741470ULL, 0x000000af8500720cULL, 0x080fe40001f61470ULL,
0x000000af8700720cULL, 0x0c0fe40000f21470ULL, 0x000000af8700720cULL, 0x080fe40002781470ULL,
0x000000af8400720cULL, 0x000fe40002fa1470ULL, 0x00000028b06e7812ULL, 0x040fe400078efcffULL,
0x00000029b06c7812ULL, 0x000fc400078efcffULL, 0x000000af9000720cULL, 0x0c0fe40000701070ULL,
0x000000af9000720cULL, 0x080fe40001741070ULL, 0x000000af8e00720cULL, 0x080fe40001f61070ULL,
0x000000af8c00720cULL, 0x0c0fe40000f21070ULL, 0x000000af8c00720cULL, 0x080fe40002781070ULL,
0x000000af8200720cULL, 0x000fc40002fa1070ULL, 0x000000a055a07219ULL, 0x000fe400000006ffULL,
0x0000541067677816ULL, 0x000fe4000000008aULL, 0x00005410864d7816ULL, 0x000fe4000000004dULL,
0x0000541061547816ULL, 0x000fe20000000054ULL, 0x000000016e8b7824ULL, 0x100fe200078e0203ULL,
0xff8000003b3b7808ULL, 0x000fe20000000000ULL, 0x000000016c8d7824ULL, 0x000fe200078e0203ULL,
0xff8000001b1b7808ULL, 0x000fc40001000000ULL, 0xff80000036367808ULL, 0x000fe40001800000ULL,
0xff80000015157808ULL, 0x000fe40000800000ULL, 0xff80000017177808ULL, 0x000fe40002000000ULL,
0xff80000032327808ULL, 0x000fe40002800000ULL, 0x000000ac97ff7212ULL, 0x000fe400078cc0ffULL,
0x0000004c9dff7212ULL, 0x000fc4000780c0ffULL, 0x000000509dff7212ULL, 0x000fe4000784c0ffULL,
0x000000679fff7212ULL, 0x040fe4000786c0ffULL, 0x0000004d9fff7212ULL, 0x0c0fe4000782c0ffULL,
0x000000549fff7212ULL, 0x000fe4000788c0ffULL, 0x0000004da0ff7212ULL, 0x000fe200078ac0ffULL,
0x000000018bb67824ULL, 0x100fe200078e0aa2ULL, 0x000000af7b00720cULL, 0x080fe200037c1470ULL,
0x000000018da27824ULL, 0x000fe200078e0aa2ULL, 0x000000af8500720cULL, 0x000fc40000701470ULL,
0x000000af8500720cULL, 0x080fe40001741470ULL, 0x000000af8400720cULL, 0x0c0fe40001f61470ULL,
0x000000af8400720cULL, 0x0c0fe40000f21470ULL, 0x000000af8400720cULL, 0x080fe40002781470ULL,
0x000000af8900720cULL, 0x000fe40002fa1470ULL, 0xfffffff09c9c7812ULL, 0x000fc400078ec0ffULL,
0x000000af9200720cULL, 0x080fe400037c1070ULL, 0x000000af8e00720cULL, 0x0c0fe40000701070ULL,
0x000000af8e00720cULL, 0x080fe40001741070ULL, 0x000000af8200720cULL, 0x0c0fe40001f61070ULL,
0x000000af8200720cULL, 0x0c0fe40000f21070ULL, 0x000000af8200720cULL, 0x000fc40002781070ULL,
0x000000af7200720cULL, 0x000fe40002fa1070ULL, 0x000000b655a17219ULL, 0x040fe400000006ffULL,
0x000000a255a27219ULL, 0x000fe200000006ffULL, 0x00000001af9c7824ULL, 0x000fe200078e029cULL,
0xff8000003d3d7808ULL, 0x000fe40003000000ULL, 0xff80000014147808ULL, 0x000fe40000000000ULL,
0xff80000016167808ULL, 0x000fc40001000000ULL, 0xff80000030307808ULL, 0x000fe40001800000ULL,
0xff80000010107808ULL, 0x000fe40000800000ULL, 0xff80000012127808ULL, 0x000fe40002000000ULL,
0xff80000011117808ULL, 0x000fe40002800000ULL, 0x0000009a9eff7212ULL, 0x000fe400078cc0ffULL,
0x00000067a0ff7212ULL, 0x000fc4000780c0ffULL, 0x00000067a1ff7212ULL, 0x040fe4000784c0ffULL,
0x00000065a0ff7212ULL, 0x0c0fe4000786c0ffULL, 0x00000054a0ff7212ULL, 0x000fe4000782c0ffULL,
0x00000065a1ff7212ULL, 0x000fe4000788c0ffULL, 0x0000004da2ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000164b47824ULL, 0x000fe200078e0a9cULL, 0x000000af8700720cULL, 0x000fc400037c1470ULL,
0x000000af8900720cULL, 0x0c0fe40000701470ULL, 0x000000af8900720cULL, 0x0c0fe40001f61470ULL,
0x000000af8900720cULL, 0x080fe40000f21470ULL, 0x000000af8b00720cULL, 0x0c0fe40001741470ULL,
0x000000af8b00720cULL, 0x080fe40002781470ULL, 0x000000af8d00720cULL, 0x000fc40002fa1470ULL,
0x00000031b05e7812ULL, 0x040fe400078efcffULL, 0x00000038b05a7812ULL, 0x040fe400078efcffULL,
0x00000039b0587812ULL, 0x000fe400078efcffULL, 0x000000af8c00720cULL, 0x080fe400037c1070ULL,
0x000000af7200720cULL, 0x0c0fe40000701070ULL, 0x000000af7200720cULL, 0x000fc40001f61070ULL,
0x000000af7200720cULL, 0x080fe40000f21070ULL, 0x000000af6e00720cULL, 0x0c0fe40001741070ULL,
0x000000af6e00720cULL, 0x080fe40002781070ULL, 0x000000af6c00720cULL, 0x000fe40002fa1070ULL,
0x000000b455a37219ULL, 0x000fe400000006ffULL, 0x000054105f5f7816ULL, 0x000fc4000000006aULL,
0x00005410594e7816ULL, 0x000fe2000000004eULL, 0x000000015e8f7824ULL, 0x100fe200078e0203ULL,
0xff80000035357808ULL, 0x000fe20003000000ULL, 0x000000015a917824ULL, 0x100fe200078e0203ULL,
0xff80000031317808ULL, 0x000fe20000000000ULL, 0x0000000158937824ULL, 0x000fe200078e0203ULL,
0xff80000033337808ULL, 0x000fe40001800000ULL, 0xff80000013137808ULL, 0x000fe40000800000ULL,
0xff8000002c2c7808ULL, 0x000fc40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40002000000ULL,
0xff8000000d0d7808ULL, 0x000fe40002800000ULL, 0x00000067a2ff7212ULL, 0x040fe400078cc0ffULL,
0x00000065a2ff7212ULL, 0x000fe4000780c0ffULL, 0x0000004da1ff7212ULL, 0x040fe4000786c0ffULL,
0x00000054a1ff7212ULL, 0x000fc4000782c0ffULL, 0x00000054a2ff7212ULL, 0x000fe4000784c0ffULL,
0x0000005fa3ff7212ULL, 0x040fe4000788c0ffULL, 0x0000004ea3ff7212ULL, 0x000fe200078ac0ffULL,
0x000000018fa47824ULL, 0x100fe200078e0a9cULL, 0x000000af8b00720cULL, 0x080fe20001f61470ULL,
0x0000000191b27824ULL, 0x100fe200078e0a9cULL, 0x000000af8b00720cULL, 0x080fe20000f21470ULL,
0x00000001939c7824ULL, 0x000fe200078e0a9cULL, 0x000000af8d00720cULL, 0x000fc400037c1470ULL,
0x000000af8d00720cULL, 0x0c0fe40000701470ULL, 0x000000af8d00720cULL, 0x080fe40001741470ULL,
0x000000af6400720cULL, 0x0c0fe40002781470ULL, 0x000000af6400720cULL, 0x080fe40002fa1470ULL,
0x000000af6e00720cULL, 0x0c0fe40001f61070ULL, 0x000000af6e00720cULL, 0x000fc40000f21070ULL,
0x000000af6c00720cULL, 0x0c0fe400037c1070ULL, 0x000000af6c00720cULL, 0x0c0fe40000701070ULL,
0x000000af6c00720cULL, 0x080fe40001741070ULL, 0x000000af6000720cULL, 0x0c0fe40002781070ULL,
0x000000af6000720cULL, 0x000fe40002fa1070ULL, 0x000000a455a47219ULL, 0x000fc400000006ffULL,
0x000000b255a57219ULL, 0x040fe400000006ffULL, 0x0000009c559c7219ULL, 0x000fe400000006ffULL,
0x000054105b5b7816ULL, 0x000fe40000000068ULL, 0xff8000000c0c7808ULL, 0x000fe40001800000ULL,
0xff8000000e0e7808ULL, 0x000fe40000800000ULL, 0xff8000002d2d7808ULL, 0x000fc40003000000ULL,
0xff8000002f2f7808ULL, 0x000fe40000000000ULL, 0xff8000000f0f7808ULL, 0x000fe40001000000ULL,
0xff80000028287808ULL, 0x000fe40002000000ULL, 0xff80000002027808ULL, 0x000fe40002800000ULL,
0x0000005fa4ff7212ULL, 0x080fe4000786c0ffULL, 0x0000005fa5ff7212ULL, 0x000fc4000782c0ffULL,
0x0000005f9cff7212ULL, 0x000fe400078cc0ffULL, 0x0000005ba3ff7212ULL, 0x080fe4000780c0ffULL,
0x0000005ba4ff7212ULL, 0x0c0fe4000784c0ffULL, 0x0000005ba5ff7212ULL, 0x000fe4000788c0ffULL,
0x0000004ea4ff7212ULL, 0x000fe400078ac0ffULL, 0x000000af6400720cULL, 0x000fc40000701470ULL,
0x000000af8f00720cULL, 0x0c0fe40001f61470ULL, 0x000000af8f00720cULL, 0x0c0fe40001741470ULL,
0x000000af8f00720cULL, 0x080fe40002fa1470ULL, 0x000000af9100720cULL, 0x080fe40000f21470ULL,
0x000000af9300720cULL, 0x080fe400037c1470ULL, 0x000000af9100720cULL, 0x000fc40002781470ULL,
0x000000af6000720cULL, 0x080fe40000701070ULL, 0x000000af5e00720cULL, 0x0c0fe40001f61070ULL,
0x000000af5e00720cULL, 0x0c0fe40001741070ULL, 0x000000af5e00720cULL, 0x080fe40002fa1070ULL,
0x000000af5a00720cULL, 0x080fe40000f21070ULL, 0x000000af5800720cULL, 0x000fc400037c1070ULL,
0x000000af5a00720cULL, 0x000fe40002781070ULL, 0x0000541057577816ULL, 0x000fe40000000066ULL,
0xff8000002a2a7808ULL, 0x000fe40000000000ULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff8000000a0a7808ULL, 0x000fc40002800000ULL,
0xff80000024247808ULL, 0x000fe40000800000ULL, 0xff80000025257808ULL, 0x000fe40003000000ULL,
0xff80000026267808ULL, 0x000fe40002000000ULL, 0x0000005b9cff7212ULL, 0x040fe4000780c0ffULL,
0x0000004ea5ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004e9cff7212ULL, 0x000fc4000784c0ffULL,
0x00000057a3ff7212ULL, 0x080fe400078ac0ffULL, 0x00000057a4ff7212ULL, 0x080fe4000782c0ffULL,
0x00000057a5ff7212ULL, 0x080fe400078cc0ffULL, 0x000000579cff7212ULL, 0x000fe4000788c0ffULL,
0x000000af6400720cULL, 0x080fe40002fa1470ULL, 0x000000af8f00720cULL, 0x000fc40000f21470ULL,
0x000000af9100720cULL, 0x0c0fe40001f61470ULL, 0x000000af9100720cULL, 0x080fe400037c1470ULL,
0x000000af9300720cULL, 0x0c0fe40000701470ULL, 0x000000af9300720cULL, 0x0c0fe40001741470ULL,
0x000000af9300720cULL, 0x080fe40002781470ULL, 0x000000af6000720cULL, 0x000fc40002fa1070ULL,
0x000000af5e00720cULL, 0x080fe40000f21070ULL, 0x000000af5800720cULL, 0x080fe40000701070ULL,
0x000000af5a00720cULL, 0x0c0fe40001f61070ULL, 0x000000af5a00720cULL, 0x080fe400037c1070ULL,
0x000000af5800720cULL, 0x0c0fe40001741070ULL, 0x000000af5800720cULL, 0x000fc40002781070ULL,
0xff80000027277808ULL, 0x000fe40000000000ULL, 0xff80000044447808ULL, 0x000fe40001800000ULL,
0xff80000045457808ULL, 0x000fe40001000000ULL, 0xff80000020207808ULL, 0x000fe40002800000ULL,
0xff80000040407808ULL, 0x000fe40000800000ULL, 0xff80000046467808ULL, 0x000fc40003000000ULL,
0xff80000047477808ULL, 0x000fce0002000000ULL, 0x000000490400720bULL, 0x004fe20003f1e000ULL,
0x000000017d7d7836ULL, 0x000fc60000000000ULL, 0x0000000449047208ULL, 0x000fc80004000000ULL,
0x000000410400720bULL, 0x000fc80003f1e000ULL, 0x00000004414d7208ULL, 0x000fc80004000000ULL,
0x0000003c4d00720bULL, 0x000fc80003f1e000ULL, 0x0000004d3c047208ULL, 0x000fc80004000000ULL,
0x0000003d0400720bULL, 0x000fc80003f1e000ULL, 0x000000043d4d7208ULL, 0x000fc80004000000ULL,
0x000000384d00720bULL, 0x000fc80003f1e000ULL, 0x0000004d38047208ULL, 0x000fc80004000000ULL,
0x000000390400720bULL, 0x000fc80003f1e000ULL, 0x00000004394d7208ULL, 0x000fc80004000000ULL,
0x000000344d00720bULL, 0x000fc80003f1e000ULL, 0x0000004d34047208ULL, 0x000fc80004000000ULL,
0x000000350400720bULL, 0x000fc80003f1e000ULL, 0x00000004354d7208ULL, 0x000fc80004000000ULL,
0x000000304d00720bULL, 0x000fc80003f1e000ULL, 0x0000004d30047208ULL, 0x000fc80004000000ULL,
0x000000310400720bULL, 0x000fc80003f1e000ULL, 0x00000004314d7208ULL, 0x000fc80004000000ULL,
0x0000002c4d00720bULL, 0x000fc80003f1e000ULL, 0x0000004d2c047208ULL, 0x000fc80004000000ULL,
0x0000002d0400720bULL, 0x000fc80003f1e000ULL, 0x000000042d4d7208ULL, 0x000fc80004000000ULL,
0x000000284d00720bULL, 0x000fc80003f1e000ULL, 0x0000004d28047208ULL, 0x000fc80004000000ULL,
0x000000290400720bULL, 0x000fc80003f1e000ULL, 0x00000004294d7208ULL, 0x000fc80004000000ULL,
0x000000244d00720bULL, 0x000fc80003f1e000ULL, 0x0000004d24047208ULL, 0x000fe40004000000ULL,
0x000000420500720bULL, 0x000fe40003f1e000ULL, 0x000000250400720bULL, 0x000fc80003f3e000ULL,
0x00000004254a7208ULL, 0x000fe40004800000ULL, 0x0000000542047208ULL, 0x000fc60004000000ULL,
0x0c401f004a4d7f89ULL, 0x000ea200000e0000ULL, 0x000000430400720bULL, 0x000fc80003f1e000ULL,
0x0000000443057208ULL, 0x000fc80004000000ULL, 0x0000003e0500720bULL, 0x000fc80003f1e000ULL,
0x000000053e047208ULL, 0x000fc80004000000ULL, 0x0000003f0400720bULL, 0x000fc80003f1e000ULL,
0x000000043f057208ULL, 0x000fe40004000000ULL, 0x0000004d4a00720bULL, 0x004fe40003f3e000ULL,
0x0000003a0500720bULL, 0x000fe40003f1e000ULL, 0x0000004a4d4d7208ULL, 0x000fe40004800000ULL,
0x000000053a047208ULL, 0x000fc60004000000ULL, 0x0c201f004d4a7f89ULL, 0x000ea200000e0000ULL,
0x0000003b0400720bULL, 0x000fc80003f1e000ULL, 0x000000043b057208ULL, 0x000fc80004000000ULL,
0x000000360500720bULL, 0x000fc80003f1e000ULL, 0x0000000536047208ULL, 0x000fc80004000000ULL,
0x000000370400720bULL, 0x000fc80003f1e000ULL, 0x0000000437057208ULL, 0x000fe40004000000ULL,
0x0000004a4d00720bULL, 0x004fe40003f3e000ULL, 0x000000320500720bULL, 0x000fe40003f1e000ULL,
0x0000004d4a047208ULL, 0x000fe40004800000ULL, 0x00000005324a7208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b04527820ULL, 0x000fe20000410000ULL, 0x000000334a00720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b3c4d7823ULL, 0x100fe20000010852ULL, 0x0000004a33057208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b414a7823ULL, 0x100fe20000010852ULL, 0x3fb8aa3b38417823ULL, 0x100fe20000010852ULL,
0x3fb8aa3b394e7823ULL, 0x100fe20000010852ULL, 0x0000002e0500720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b3d4f7823ULL, 0x100fe20000010852ULL, 0x3fb8aa3b253d7823ULL, 0x100fe20000010852ULL,
0x3fb8aa3b35507823ULL, 0x100fe20000010852ULL, 0x000000052e4c7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b31357823ULL, 0x100fe20000010852ULL, 0x3fb8aa3b49497823ULL, 0x100fe20000010852ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010852ULL, 0x0000002f4c00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b28317823ULL, 0x000fe20000010852ULL, 0x0000004a004a7308ULL, 0x000fe40000000800ULL,
0x0000004c2f057208ULL, 0x000fc80004000000ULL, 0x0000002a0500720bULL, 0x000fe40003f1e000ULL,
0x0000004d004c7308ULL, 0x0005e40000000800ULL, 0x000000052a3c7208ULL, 0x000fc80004000000ULL,
0x0000002b3c00720bULL, 0x000fe40003f1e000ULL, 0x0000004900497308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b344d7823ULL, 0x104fe20000010852ULL, 0x0000003c2b057208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b2c347823ULL, 0x100fe20000010852ULL, 0x3fb8aa3b2d3c7823ULL, 0x000fe40000010852ULL,
0x000000260500720bULL, 0x000fe40003f1e000ULL, 0x0000004f004f7308ULL, 0x000fe40000000800ULL,
0x0000000526387208ULL, 0x000fc80004000000ULL, 0x000000273800720bULL, 0x000fe40003f1e000ULL,
0x0000004100417308ULL, 0x000fe40000000800ULL, 0x0000003827387208ULL, 0x000fe40004000000ULL,
0x0000004b0600720bULL, 0x000fc60003f1e000ULL, 0x0c401f0038397f89ULL, 0x000ea200000e0000ULL,
0x000000064b067208ULL, 0x000fe20004000000ULL, 0x0000004e004e7308ULL, 0x000fe60000000800ULL,
0x000000210600720bULL, 0x000fc80003f1e000ULL, 0x0000000621057208ULL, 0x000fe20004000000ULL,
0x0000004d004d7308ULL, 0x000fe60000000800ULL, 0x0000001c0500720bULL, 0x000fc80003f1e000ULL,
0x000000051c067208ULL, 0x000fe20004000000ULL, 0x0000005000507308ULL, 0x000fe60000000800ULL,
0x0000001d0600720bULL, 0x000fe40003f1e000ULL, 0x000000393800720bULL, 0x004fe40003f3e000ULL,
0x000000061d057208ULL, 0x000fe20004000000ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x00000038392c7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b24387823ULL, 0x000fe20000010852ULL,
0x000000180500720bULL, 0x000fc60003f1e000ULL, 0x0c201f002c2d7f89ULL, 0x000ea200000e0000ULL,
0x0000000518067208ULL, 0x000fe20004000000ULL, 0x0000003400397308ULL, 0x000be60000000800ULL,
0x000000190600720bULL, 0x000fc80003f1e000ULL, 0x0000000619057208ULL, 0x000fe20004000000ULL,
0x0000003500357308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b29347823ULL, 0x022fe40000010852ULL,
0x000000140500720bULL, 0x000fc80003f1e000ULL, 0x0000000514067208ULL, 0x000fe20004000000ULL,
0x0000003c003c7308ULL, 0x000fe60000000800ULL, 0x000000150600720bULL, 0x000fe40003f1e000ULL,
0x0000002d2c00720bULL, 0x004fe40003f3e000ULL, 0x0000000615297208ULL, 0x000fe20004000000ULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x0000002c2d057208ULL, 0x000fc40004800000ULL,
0x000000102900720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b05527820ULL, 0x000fe20000410000ULL,
0x0000002910067208ULL, 0x000fe20004000000ULL, 0x0000003400347308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b3f2d7823ULL, 0x100fe20000010852ULL, 0x000000110600720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b3e287823ULL, 0x100fe20000010852ULL, 0x3fb8aa3b3b3e7823ULL, 0x100fe20000010852ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010852ULL, 0x0000000611257208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b43437823ULL, 0x100fe20000010852ULL, 0x3fb8aa3b42247823ULL, 0x100fe20000010852ULL,
0x3fb8aa3b37427823ULL, 0x100fe20000010852ULL, 0x0000000c2500720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b2b377823ULL, 0x100fe20000010852ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010852ULL, 0x000000250c067208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010852ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010852ULL,
0x3fb8aa3b2f2f7823ULL, 0x000fe20000010852ULL, 0x0000000d0600720bULL, 0x000fc40003f1e000ULL,
0x0000004300257308ULL, 0x000fe40000000800ULL, 0x000000060d297208ULL, 0x000fe40004000000ULL,
0x000000220700720bULL, 0x000fe40003f1e000ULL, 0x000000022900720bULL, 0x000fe40003f3e000ULL,
0x0000000722067208ULL, 0x000fe20004000000ULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x0000002902297208ULL, 0x000fc40004800000ULL, 0x000000230600720bULL, 0x000fe40003f1e000ULL,
0x0000000a2900720bULL, 0x000fe40003f3e000ULL, 0x0000000623077208ULL, 0x000fe20004000000ULL,
0x0000004200427308ULL, 0x000fe20000000800ULL, 0x000000290a3f7208ULL, 0x000fe40004800000ULL,
0x0000001e0700720bULL, 0x000fe40003f1e000ULL, 0x000000443f00720bULL, 0x000fc40003f3e000ULL,
0x000000071e067208ULL, 0x000fe20004000000ULL, 0x0000003a00297308ULL, 0x0003e20000000800ULL,
0x0000003f442c7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b363f7823ULL, 0x100fe20000010852ULL,
0x0000001f0600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2a367823ULL, 0x100fe20000010852ULL,
0x000000452c00720bULL, 0x000fe40003f3e000ULL, 0x000000061f077208ULL, 0x000fe20004000000ULL,
0x0000003f003f7308ULL, 0x000fe20000000800ULL, 0x0000002c452c7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b263a7823ULL, 0x002fe20000010852ULL, 0x0000001a0700720bULL, 0x000fc60003f1e000ULL,
0x0c401f002c3b7f89ULL, 0x000e6200000e0000ULL, 0x000000071a067208ULL, 0x000fe20004000000ULL,
0x0000002400247308ULL, 0x000ea60000000800ULL, 0x0000001b0600720bULL, 0x000fc80003f1e000ULL,
0x000000061b077208ULL, 0x000fe20004000000ULL, 0x0000003e003e7308ULL, 0x000f660000000800ULL,
0x000000160700720bULL, 0x000fc80003f1e000ULL, 0x0000000716067208ULL, 0x000fe20004000000ULL,
0x0000003200327308ULL, 0x000fe60000000800ULL, 0x000000170600720bULL, 0x000fe40003f1e000ULL,
0x0000003b2c00720bULL, 0x002fe40003f3e000ULL, 0x0000000617077208ULL, 0x000fe20004000000ULL,
0x0000003300337308ULL, 0x000fe20000000800ULL, 0x0000002c3b2c7208ULL, 0x000fc40004800000ULL,
0x000000120700720bULL, 0x000fc60003f1e000ULL, 0x0c201f002c3b7f89ULL, 0x000e6200000e0000ULL,
0x0000000712067208ULL, 0x000fe20004000000ULL, 0x0000002e002e7308ULL, 0x000fe60000000800ULL,
0x000000130600720bULL, 0x000fc80003f1e000ULL, 0x0000000613077208ULL, 0x000fe20004000000ULL,
0x0000002f002f7308ULL, 0x000fe60000000800ULL, 0x0000000e0700720bULL, 0x000fc80003f1e000ULL,
0x000000070e067208ULL, 0x000fe20004000000ULL, 0x0000003600367308ULL, 0x000fe60000000800ULL,
0x0000000f0600720bULL, 0x000fe40003f1e000ULL, 0x0000003b2c00720bULL, 0x002fe40003f3e000ULL,
0x000000060f077208ULL, 0x000fe20004000000ULL, 0x0000003700377308ULL, 0x000fe20000000800ULL,
0x0000002c3b067208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b273b7823ULL, 0x000fe20000010852ULL,
0x000000200700720bULL, 0x000fe20003f1e000ULL, 0x3c003c00ff2c7424ULL, 0x000fc400078e00ffULL,
0x3fb8aa3b06277820ULL, 0x000fe20000410000ULL, 0x0000000720077208ULL, 0x000fe20004000000ULL,
0x0000003800387308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b10437823ULL, 0x100fe20000010827ULL,
0x000000400700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010827ULL,
0x0000000740077208ULL, 0x000fe20004000000ULL, 0x00000021002b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b11527823ULL, 0x100fe20000010827ULL,
0x000000460700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b0c537823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010827ULL,
0x0000000746267208ULL, 0x000fe20004000000ULL, 0x0000004b002a7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010827ULL,
0x000000472600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b0d547823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b02027823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010827ULL,
0x0000002647267208ULL, 0x000fe20004000000ULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0a4b7823ULL, 0x102fe20000010827ULL, 0x3fb8aa3b440a7823ULL, 0x000fc40000010827ULL,
0x0c401f0026077f89ULL, 0x000e6800000e0000ULL, 0x0000001d001d7308ULL, 0x000e700000000800ULL,
0x0000001400577308ULL, 0x0007f00000000800ULL, 0x0000001500587308ULL, 0x0005e20000000800ULL,
0x000000494a14723eULL, 0x008fc400000000ffULL, 0x000000072600720bULL, 0x002fc80003f1e000ULL,
0x0000002607077208ULL, 0x000fe20004000000ULL, 0x0000001900567308ULL, 0x000be20000000800ULL,
0x000000242515723eULL, 0x004fc600000000ffULL, 0x0c201f0007107f89ULL, 0x000e6800000e0000ULL,
0x0000001800557308ULL, 0x0005e20000000800ULL, 0x000000293e19723eULL, 0x020fce00000000ffULL,
0x0000004300437308ULL, 0x000fe20000000800ULL, 0x000000414e18723eULL, 0x004fce00000000ffULL,
0x0000005200527308ULL, 0x000fe20000000800ULL, 0x000000100700720bULL, 0x002fc80003f1e000ULL,
0x0000000710077208ULL, 0x000fc60004000000ULL, 0x0000005300537308ULL, 0x000fe20000000800ULL,
0x0000000309ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b07217820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b16107823ULL, 0x100fe20000010821ULL,
0x0000002200117308ULL, 0x000fe20000000800ULL, 0x0000004c4f16723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010821ULL,
0x00000023000c7308ULL, 0x0002a20000000800ULL, 0x3fb8aa3b47477823ULL, 0x000fce0000010821ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b17237823ULL, 0x102fe20000010821ULL,
0x000000282d17723eULL, 0x000fe200000000ffULL, 0x3c003c00ff2d7424ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b12287823ULL, 0x100fe20000010821ULL, 0x0000001c1d12723eULL, 0x000fe400000000ffULL,
0x000000110c11723eULL, 0x004fe200000000ffULL, 0x0000001f001f7308ULL, 0x000e620000000800ULL,
0x00000055561c723eULL, 0x000fe200000000ffULL, 0x0000002c1424723cULL, 0x000fec00000018ffULL,
0x0000001b00447308ULL, 0x0005f00000000800ULL, 0x0000001000227308ULL, 0x0007e20000000800ULL,
0x0000003f421b723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b133f7823ULL, 0x000fe20000010821ULL,
0x0000001e1f13723eULL, 0x002fc400000000ffULL, 0x00000057581e723eULL, 0x000fe400000000ffULL,
0x000000363721723eULL, 0x000fe200000000ffULL, 0x00000028003e7308ULL, 0x0003e20000000800ULL,
0x0000002a2b10723eULL, 0x008fce00000000ffULL, 0x0000001a000d7308ULL, 0x0004e20000000800ULL,
0x0000002c1028723cULL, 0x002fee00000018ffULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x0000004d501a723eULL, 0x004fe400000000ffULL, 0x00000003ff507819ULL, 0x000fc40000011609ULL,
0x0000000d441d723eULL, 0x008fc600000000ffULL, 0x0000002c1824723cULL, 0x000fe20000001824ULL,
0xfffffff8ff447812ULL, 0x000fe200078ee20bULL, 0x0000005400547308ULL, 0x000ea20000000800ULL,
0x00000004090c7810ULL, 0x000fe40007ffe050ULL, 0x00000032330d723eULL, 0x000fe200000000ffULL,
0x00000008444a7836ULL, 0x000fe20000000000ULL, 0x00000022231f723eULL, 0x002fe200000000ffULL,
0x00000010444c7836ULL, 0x000fe20000000000ULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000003f003f7308ULL, 0x000fe20000000800ULL, 0x00000018444e7836ULL, 0x000fc40000000000ULL,
0x0000000844497824ULL, 0x000fe200078e00ffULL, 0x0000002c1c28723cULL, 0x000fe20000001828ULL,
0x000000084a4d7824ULL, 0x000fe400078e00ffULL, 0x000000084c4f7824ULL, 0x000fe200078e00ffULL,
0x0000000e000b7308ULL, 0x0003e20000000800ULL, 0x000000084e557824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee20cULL, 0x0000000844447824ULL, 0x000fe200078e00ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee20cULL, 0x000000084a4a7824ULL, 0x000fe200078e00ffULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee20cULL, 0x000000084c4c7824ULL, 0x000fe200078e00ffULL,
0x0000000f00427308ULL, 0x0007620000000800ULL, 0xfffffff855557812ULL, 0x000fe200078ee20cULL,
0x000000084e4e7824ULL, 0x000fe200078e00ffULL, 0x00000030350c723eULL, 0x000fe200000000ffULL,
0x0000100077357824ULL, 0x000fe200078e0208ULL, 0x000000393c0e723eULL, 0x002fe200000000ffULL,
0x000000ffff397224ULL, 0x000fe200078e0016ULL, 0x000000435230723eULL, 0x000fe200000000ffULL,
0x0000002000417308ULL, 0x0003e20000000800ULL, 0x0000002e2f0f723eULL, 0x008fe200000000ffULL,
0x000000ffff167224ULL, 0x000fe200078e0019ULL, 0x000000535432723eULL, 0x004fe200000000ffULL,
0x000000ffff197224ULL, 0x000fe200078e0012ULL, 0x00000003502e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff127224ULL, 0x000fe200078e001dULL, 0x0000000b4233723eULL, 0x020fe200000000ffULL,
0x0000002c0c24723cULL, 0x000fe20000001824ULL, 0x000000313420723eULL, 0x002fe200000000ffULL,
0x0000000200027308ULL, 0x000fe20000000800ULL, 0x0000003e3f31723eULL, 0x000fe200000000ffULL,
0x000000012e0b7824ULL, 0x000fc400078e0209ULL, 0x000000ffff1d7224ULL, 0x000fc600078e0033ULL,
0x000000070b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000004b004b7308ULL, 0x000e620000000800ULL,
0x0000002c3028723cULL, 0x000fe40000001828ULL, 0xfffffff8442f7812ULL, 0x000fe400078ee20bULL,
0xfffffff84c3f7812ULL, 0x000fc600078ee20bULL, 0x0000003d003d7308ULL, 0x000ea20000000800ULL,
0x000000024b34723eULL, 0x002fce00000000ffULL, 0x0000003a003a7308ULL, 0x000fe20000000800ULL,
0x0001200035027836ULL, 0x000fc80000000000ULL, 0x0000001049497824ULL, 0x000fe200078e0202ULL,
0x000000383d22723eULL, 0x004fe400000000ffULL, 0x0000003b003b7308ULL, 0x000e620000000800ULL,
0xfffffff84a3d7812ULL, 0x000fe200078ee20bULL, 0x000000ffff387224ULL, 0x000fe200078e0014ULL,
0xfffffff84e0b7812ULL, 0x000fe200078ee20bULL, 0x000000ffff147224ULL, 0x000fe400078e0015ULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x0000000a000a7308ULL, 0x000fe20000000800ULL,
0x000000103d3d7824ULL, 0x000fc400078e0202ULL, 0x000000ffff177224ULL, 0x000fe400078e001bULL,
0x000000104d4d7824ULL, 0x000fe200078e0202ULL, 0x0000003a3b23723eULL, 0x002fe400000000ffULL,
0x0000004500457308ULL, 0x000e620000000800ULL, 0x000000ffff3a7224ULL, 0x000fe400078e0018ULL,
0x000000ffff3b7224ULL, 0x000fe400078e001aULL, 0x000000ffff187224ULL, 0x000fe200078e0010ULL,
0x0000002c2024723cULL, 0x000fe20000001824ULL, 0x000000103f3f7824ULL, 0x000fe200078e0202ULL,
0x0000004000407308ULL, 0x000ea20000000800ULL, 0x000000ffff1a7224ULL, 0x000fc400078e001cULL,
0x000000ffff1b7224ULL, 0x000fe400078e001eULL, 0x000000ffff107224ULL, 0x000fe200078e0011ULL,
0x0000000a4536723eULL, 0x002fe400000000ffULL, 0x0000004600377308ULL, 0x000fe20000000800ULL,
0x000000102f0a7824ULL, 0x000fe400078e0202ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0022ULL,
0x000000104f4f7824ULL, 0x000fe200078e0202ULL, 0x000000380a007844ULL, 0x000fe20000000200ULL,
0x000000414035723eULL, 0x004fe200000000ffULL, 0x00000047002e7308ULL, 0x000e620000000800ULL,
0x000000ffff227224ULL, 0x000fc400078e0034ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000100b0b7824ULL, 0x100fe400078e0202ULL, 0x000000ffff137224ULL, 0x000fe400078e001fULL,
0x0000001055557824ULL, 0x000fe400078e0202ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0031ULL,
0x000000ffff1e7224ULL, 0x000fe200078e0035ULL, 0x000000372e37723eULL, 0x002fe200000000ffULL,
0x000000ffff2e7224ULL, 0x000fc400078e0020ULL, 0x000000ffff207224ULL, 0x000fe400078e0030ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0037ULL, 0x0000002c3428723cULL, 0x000fe20000001828ULL,
0x000000ffff257224ULL, 0x000fe400078e0026ULL, 0x000000ffff027224ULL, 0x000fc800078e005cULL,
0x000000ffff2c7224ULL, 0x000fe400078e000cULL, 0x000000ffff2d7224ULL, 0x000fe400078e000eULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff0d7224ULL, 0x000fe200078e000fULL,
0x0000002c49007844ULL, 0x000fe20000000200ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0021ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0023ULL, 0x000000143d007844ULL, 0x000fe20000000200ULL,
0x000000ffff217224ULL, 0x000fc400078e0032ULL, 0x000000ffff237224ULL, 0x000fe200078e0036ULL,
0x0000000c4d007844ULL, 0x0003e40000000200ULL, 0x000000ffff267224ULL, 0x000fe400078e0028ULL,
0x000000ffff277224ULL, 0x000fe200078e002aULL, 0x000000183f007844ULL, 0x0005e80000000200ULL,
0x000000204f007844ULL, 0x0005e80000000200ULL, 0x000000100b007844ULL, 0x0005e20000000200ULL,
0x00000001ff0d7424ULL, 0x002fc600078e00ffULL, 0x0000001c55007844ULL, 0x0005e80000000200ULL,
0x01a0000448008388ULL, 0x0005e80000000c00ULL, 0x01a2002448008388ULL, 0x0005e20000000c00ULL,
0x000000627d00720cULL, 0x000fe20003f06070ULL, 0x01a6080d78ff79a7ULL, 0x0005e2000850003fULL,
0x01a6100d78ff79a7ULL, 0x0005e2000850003fULL, 0x01a6180d78ff79a7ULL, 0x0005e2000850003fULL,
0x01a6200d78ff79a7ULL, 0x0005f2000850003fULL, 0xffffff9000488947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000084007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000008400008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff84ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000084027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000008400007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffe8c028c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004e3ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000660ULL, 0x0000000000000228ULL,
0x0000001500000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000888ULL, 0x00000000000000e0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000968ULL, 0x0000000000000054ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000009bcULL, 0x0000000000000710ULL,
0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010d0ULL, 0x0000000000000000ULL,
0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010d0ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001118ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000017280ULL,
0x0000001500000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000018400ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000018440ULL, 0x0000000000000400ULL,
0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000018440ULL, 0x0000000000000278ULL,
0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000018a38ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000018a38ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001118ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000017280ULL, 0x0000000000017280ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000018400ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000018440ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000278ULL, 0x0000000000000278ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_32_sm_90_cubin_len = 101256;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
