/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000014a48ULL, 0x00000000000146c8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x326a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL,
0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL, 0x45316a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x000000676e696469ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL, 0x305f6c616e726574ULL,
0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL,
0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL, 0x616c65722e006168ULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL,
0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL,
0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000135ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b0001000001beULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000b000100000204ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b00010000024bULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000291ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b0001000002dfULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000032dULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b00010000037bULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003c9ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b00010000040fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b00010000045dULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004b8ULL, 0x0000000000013000ULL,
0x0000000000000280ULL, 0x000400030000052eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000013280ULL, 0x000d00030000055eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001300000000000ULL,
0x0000140400000000ULL, 0x0020288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL,
0x0000006000000000ULL, 0x0001300000000000ULL, 0x0000028000000000ULL, 0x0000580400000000ULL,
0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL, 0x0008230400000080ULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000020ULL, 0x0000002000000015ULL,
0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000002000000017ULL, 0x0000001700081104ULL,
0x0004370400000020ULL, 0x000c17040000007bULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0xffffffff00942904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000047000942804ULL,
0x00000a6000000480ULL, 0x00002c2000002b90ULL, 0x00002e3000002cf0ULL, 0x0000338000003370ULL,
0x00004fa000004f30ULL, 0x000051e0000050a0ULL, 0x000055f0000055e0ULL, 0x00007190000070f0ULL,
0x000073a000007260ULL, 0x000077b0000077a0ULL, 0x000093b000009310ULL, 0x000095c000009480ULL,
0x00009ac000009ab0ULL, 0x0000abd00000abc0ULL, 0x000124e000012430ULL, 0x000127b000012700ULL,
0x00012a5000012870ULL, 0x00012c6000012c10ULL, 0x0000054004303904ULL, 0x00017600000000ffULL,
0x0000062000040100ULL, 0x0001760800000008ULL, 0x00000730003f0100ULL, 0x0001768800000008ULL,
0x00000880003f0100ULL, 0x000176a800000005ULL, 0x00000980003f0100ULL, 0x000176c800000003ULL,
0x000010e0003f0100ULL, 0x00017600000000ffULL, 0x0000128000080107ULL, 0x0001768800000000ULL,
0x00001b80003f0101ULL, 0x00000000000000ffULL, 0x00001bb000040107ULL, 0x00000000000000ffULL,
0x00001c3000040101ULL, 0x0000002000000008ULL, 0x00001d90003f0101ULL, 0x000176c800000007ULL,
0x00001f3000080109ULL, 0x000176c80000000fULL, 0x00002810003f0109ULL, 0x000176b00000000fULL,
0x0000291000080107ULL, 0x000176b000000046ULL, 0x00002920003f0101ULL, 0x000176080000000aULL,
0x00002940003f0101ULL, 0x000176080000000aULL, 0x00002ab0003f0109ULL, 0x000176080000000aULL,
0x00002ff0003f0109ULL, 0x000176a800000017ULL, 0x0000317000080109ULL, 0x000176a800000013ULL,
0x00004300003f0109ULL, 0x000176c80000003cULL, 0x00004310003f0101ULL, 0x0001768800000013ULL,
0x0000433000080101ULL, 0x000000000000000bULL, 0x000044a0003f0109ULL, 0x000000000000000bULL,
0x00004ca0003f0109ULL, 0x000176a800000014ULL, 0x00004cf000080107ULL, 0x000176a800000015ULL,
0x00004d00003f0101ULL, 0x000176280000000aULL, 0x00004d20003f0101ULL, 0x000176280000000aULL,
0x00004e90003f0109ULL, 0x000176280000000aULL, 0x000053b0003f0109ULL, 0x000176b00000001bULL,
0x0000553000080109ULL, 0x000176b00000003fULL, 0x00006470003f0109ULL, 0x000176c80000003cULL,
0x00006490003f0101ULL, 0x0001769000000042ULL, 0x000064c000080101ULL, 0x000000000000000bULL,
0x00006630003f0109ULL, 0x000000000000000bULL, 0x00006dd0003f0109ULL, 0x00000008000000ffULL,
0x00006ea000040107ULL, 0x0000000800000013ULL, 0x00006eb0003f0101ULL, 0x000176480000000aULL,
0x00006ed0003f0101ULL, 0x000176480000000aULL, 0x00007040003f0109ULL, 0x000176480000000aULL,
0x00007570003f0109ULL, 0x000176a800000011ULL, 0x000076f000080109ULL, 0x000176a800000013ULL,
0x000086b0003f0109ULL, 0x000176c80000001dULL, 0x000086d0003f0101ULL, 0x0001769800000015ULL,
0x00008700003f0101ULL, 0x000000000000000bULL, 0x00008870003f0109ULL, 0x000000000000000bULL,
0x00009080003f0109ULL, 0x00000000000000ffULL, 0x000090d000040107ULL, 0x000176a800000010ULL,
0x000090e0003f0101ULL, 0x000176680000000dULL, 0x00009110003f0101ULL, 0x000176680000000dULL,
0x00009280003f0109ULL, 0x000176680000000dULL, 0x00009780003f0109ULL, 0x000176b00000001dULL,
0x00009930003f0109ULL, 0x000176b00000001dULL, 0x0000a870003f0109ULL, 0x000176a80000000aULL,
0x0000aa20003f0101ULL, 0x000176a00000000aULL, 0x0000bdb0003f0101ULL, 0x00017600000000ffULL,
0x0000d71000080101ULL, 0x00017600000000ffULL, 0x0000d8e000080109ULL, 0x00017600000000ffULL,
0x0000dac000080109ULL, 0x00017600000000ffULL, 0x0000dae000080101ULL, 0x00017600000000ffULL,
0x0000dc5000080109ULL, 0x00017600000000ffULL, 0x000108d000080109ULL, 0x000176880000005eULL,
0x00010aa0003f0101ULL, 0x000176880000005eULL, 0x00010c10003f0109ULL, 0x000176880000005eULL,
0x00012fa0003f0109ULL, 0x000176080000007dULL, 0x00012fb0003f0101ULL, 0x000176100000007dULL,
0x00012fc0003f0101ULL, 0x000176180000007dULL, 0x00012fd0003f0101ULL, 0x000176200000007dULL,
0x00053803003f0101ULL, 0x0000b42000201c04ULL, 0x0000b7200000b450ULL, 0x0000bb100000b910ULL,
0x0000dc900000bcc0ULL, 0x000c050400012ff0ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0068190300000000ULL, 0x0000001800080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL,
0x0000001700000002ULL, 0x0000000000013000ULL, 0x0000000000000044ULL, 0x0000001700000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001700000002ULL, 0x0000000000000000ULL,
0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000047919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fe20000000a00ULL,
0xffffffe001017836ULL, 0x002fca0000000000ULL, 0x00008500ff097b82ULL, 0x000e620000000800ULL,
0x000000ff0200720cULL, 0x004fc80003f45070ULL, 0x000000ff0300720cULL, 0x000fda0003f45320ULL,
0x00008800ff022b82ULL, 0x000ea20000000a00ULL, 0x0000000104052836ULL, 0x008fe40000000000ULL,
0x00000004040a2825ULL, 0x004fc800078e0002ULL, 0x0000000405022825ULL, 0x000fe400078e0002ULL,
0x000000060a0a2981ULL, 0x0004e8000c1e1900ULL, 0x0000000602052981ULL, 0x0008e2000c1e1900ULL,
0x0000000900007306ULL, 0x002e620000209000ULL, 0x00000400ff087b82ULL, 0x000f620000000800ULL,
0x000000ff0900720cULL, 0x000fe20003f65070ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x0000046000007945ULL, 0x000fe20003800000ULL, 0x00000000000b7919ULL, 0x004ea60000002100ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00067836ULL, 0x002fcc0000000000ULL,
0x0000000600077305ULL, 0x0002a4000021f000ULL, 0x000000ffff067224ULL, 0x002fe400078e00ffULL,
0x000000ffff0c7224ULL, 0x004fc800078e0a07ULL, 0x000000090c0d7224ULL, 0x000fe400078e02ffULL,
0x00000000000c7919ULL, 0x000e640000002300ULL, 0x0000000d07077227ULL, 0x000fe400078e0006ULL,
0x00000000000d7919ULL, 0x000e680000002200ULL, 0x0000000807077227ULL, 0x020fc800078e00ffULL,
0x000000ffff027224ULL, 0x010fc800078e0a07ULL, 0x0000000209007224ULL, 0x000fe400078e0208ULL,
0x0000000000087919ULL, 0x000ea60000002600ULL, 0x000000090000720cULL, 0x000fda0003f06070ULL,
0x0000000100000824ULL, 0x000fe400078e0a09ULL, 0x0000000107070836ULL, 0x000fc60000000000ULL,
0x000000090000720cULL, 0x000fda0003f26070ULL, 0x0000000107071836ULL, 0x000fe20000000000ULL,
0x00000009ff07b212ULL, 0x000fc800078e33ffULL, 0x0000000700007306ULL, 0x000f220000209000ULL,
0x000000ff0700720cULL, 0x000fce0003f65070ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00027836ULL, 0x010fe40000000000ULL, 0x000000040c007c24ULL, 0x002fe2000f8e020dULL,
0x0000000000047ab9ULL, 0x000fc60000000800ULL, 0x0000000200037305ULL, 0x000322000021f000ULL,
0x00008400ff0dab82ULL, 0x000f620000000800ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000307067224ULL, 0x010fc800078e02ffULL, 0x000000ffff0f7224ULL, 0x000fc800078e0a06ULL,
0x0000000f03037227ULL, 0x000fcc00078e0002ULL, 0x00000008034d7227ULL, 0x004fc800078e00ffULL,
0x0000000400037c24ULL, 0x000fe4000f8e020bULL, 0x000000ffff027224ULL, 0x000fc600078e0a4dULL,
0x0000007f0300780cULL, 0x000fe20003fa4070ULL, 0x0000000207007224ULL, 0x000fe200078e0208ULL,
0x000000030300780cULL, 0x000fc80003f84070ULL, 0x000000070000720cULL, 0x000fce0003f06070ULL,
0x00000000000fd919ULL, 0x000e620000008800ULL, 0x000004000002d802ULL, 0x000fe20000000f00ULL,
0xff317217ff06d424ULL, 0x000fc800078e00ffULL, 0x0000000100000824ULL, 0x000fe400078e0a07ULL,
0x000000014d4d0836ULL, 0x000fe20000000000ULL, 0x000000ff0300720cULL, 0x000fe40003f05270ULL,
0x000000070000720cULL, 0x000fda0003f26070ULL, 0x000000014d4d1836ULL, 0x000fe20000000000ULL,
0x00000007ff4db212ULL, 0x000fe400078e33ffULL, 0x0000000f0300780cULL, 0x040fe40003f24070ULL,
0x000000010300780cULL, 0x000fe40003f64070ULL, 0x000006540f0ed816ULL, 0x002fe40000000002ULL,
0x00000005ff027819ULL, 0x000fe4000001160bULL, 0x00001fff0c0b7589ULL, 0x000b6800000e0000ULL,
0x00001fff02027589ULL, 0x000f6200000e0000ULL, 0x0000000105002824ULL, 0x008fc400078e0a0aULL,
0x000000ffff057224ULL, 0x000fc800078e0a4dULL, 0x00008400ff00ab82ULL, 0x000ee20000000800ULL,
0x0000000507077224ULL, 0x000fe400078e0208ULL, 0x000000040305d824ULL, 0x000fe200078e020eULL,
0x0000000000240947ULL, 0x020fec0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000087882ULL, 0x000fe20000000000ULL,
0x7ffc000000097882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01760008043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000403087c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000080812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01760804083f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000403087c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000080812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01768804083f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x017400060500d388ULL, 0x0003e20000000800ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0000001007057824ULL, 0x002fca00078e00ffULL, 0x0000180501007387ULL, 0x0003e20000100800ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000403057c11ULL, 0x002fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000050912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x0176a804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000403037c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000030912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x0176c804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000180001137983ULL, 0x000ea20000100800ULL,
0x0000000800037c24ULL, 0x008fe4000f8e02ffULL, 0x0000000d040aa224ULL, 0x000fe400078e02ffULL,
0x00000008090f7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000f0a527224ULL, 0x000fc800078e02ffULL,
0x000000084d127c24ULL, 0x000fe2000f8e0252ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ffff067224ULL, 0x004fe200078e0a13ULL,
0x000000130300720cULL, 0x000fc80003f06070ULL, 0x0000001003517446ULL, 0x000fe20003800006ULL,
0x000000040b037824ULL, 0x000fc600078e0202ULL, 0x000000ff51517207ULL, 0x000fe20000000000ULL,
0x0000000203087824ULL, 0x000fc600078e00ffULL, 0x000000105100780cULL, 0x000fda0003f05270ULL,
0x0000000000c48947ULL, 0x000fea0003800000ULL, 0x0000000800057d06ULL, 0x002e620008209000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x00000008ff007c0cULL, 0x000fe2000bf45070ULL,
0x00008c0000047ab9ULL, 0x000fca0000000a00ULL, 0x0000000500057308ULL, 0x002e640000001000ULL,
0x0ffffffe05067836ULL, 0x002fe20000000000ULL, 0x00000004ff0d7819ULL, 0x004fca0000011603ULL,
0x0000000600077305ULL, 0x0002a2000021f000ULL, 0x00000001080c7824ULL, 0x000fc800078e020dULL,
0x0000000113057824ULL, 0x000fe400078e020cULL, 0x000000ffff067224ULL, 0x002fe400078e00ffULL,
0x000000ffff117224ULL, 0x004fc800078e0a07ULL, 0x0000000811117c24ULL, 0x000fc8000f8e02ffULL,
0x00000011070e7227ULL, 0x000fe200078e0006ULL, 0x0000000851077248ULL, 0x000fe20007fe0000ULL,
0x0000000000117919ULL, 0x000e680000008800ULL, 0x000000050e0e7227ULL, 0x000fc800078e00ffULL,
0x000000ffff107224ULL, 0x000fe400078e0a0eULL, 0x0000000107087824ULL, 0x000fe400078e0a08ULL,
0x0000000810067c24ULL, 0x000fca000f8e0205ULL, 0x0000000806007c0cULL, 0x000fda000bf06070ULL,
0x8000000806060c36ULL, 0x000fe40008000000ULL, 0x000000010e0e0836ULL, 0x000fe20000000000ULL,
0x000000080d00720cULL, 0x000fe20003f06070ULL, 0x000000010c087824ULL, 0x000fe200078e0203ULL,
0x0000000806007c0cULL, 0x000fe2000bf26070ULL, 0x000000100c0d7824ULL, 0x000fca00078e00ffULL,
0xfffffff00d087812ULL, 0x000fce00078ee208ULL, 0x000000010e0e1836ULL, 0x000fe20000000000ULL,
0x00000008ff0eac12ULL, 0x000fca000f8e33ffULL, 0x000000ffff067224ULL, 0x000fc800078e0a0eULL,
0x0000000806057c24ULL, 0x000fe2000f8e0205ULL, 0x0000040000067802ULL, 0x000fc60000000f00ULL,
0x0000000112057824ULL, 0x000fe200078e0205ULL, 0x0000065411117816ULL, 0x002fc60000000006ULL,
0x0000000f0e067224ULL, 0x000fe200078e0205ULL, 0x00000000110872caULL, 0x000fe200000e0000ULL,
0x0000001003057824ULL, 0x000fe400078e00ffULL, 0x0000010006067825ULL, 0x000fc600078e00ffULL,
0x000000f0050f7812ULL, 0x000fc800078ec0ffULL, 0x0000000f060f7212ULL, 0x000fc600078efcffULL,
0x00000008080d7c11ULL, 0x000fe4000f8e20ffULL, 0x000000040f067c10ULL, 0x000fc8000ff3e0ffULL,
0x0000000507077c10ULL, 0x000fca0008ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e2000c101c46ULL, 0x0000000000b07947ULL, 0x000fea0003800000ULL,
0x00000008000c7d06ULL, 0x000ea20008209000ULL, 0x0000000000037919ULL, 0x000ee20000000000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00000008ff007c0cULL, 0x000fe2000bf45070ULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000000000e7919ULL, 0x000f260000008800ULL,
0x0000000c000c7308ULL, 0x004ea40000001000ULL, 0x0ffffffe0c0d7836ULL, 0x004fe20000000000ULL,
0x0000000803087211ULL, 0x008fca00078fe0ffULL, 0x0000000d00077305ULL, 0x000ea4000021f000ULL,
0x000000ffff057224ULL, 0x006fc800078e0a07ULL, 0x0000000805057c24ULL, 0x000fc8000f8e02ffULL,
0x0000000507067227ULL, 0x000fc800078e0006ULL, 0x0000000113057824ULL, 0x000fc800078e0208ULL,
0x0000000506067227ULL, 0x000fc800078e00ffULL, 0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL,
0x000000080c077c24ULL, 0x000fca000f8e0205ULL, 0x0000000807007c0cULL, 0x000fda000bf06070ULL,
0x8000000807070c36ULL, 0x000fe40008000000ULL, 0x0000000106060836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fe4000bf26070ULL, 0x0000040000077802ULL, 0x000fc80000000f00ULL,
0x000006540e077816ULL, 0x010fce0000000007ULL, 0x0000000106061836ULL, 0x000fe20000000000ULL,
0x00000008ff06ac12ULL, 0x000fca000f8e33ffULL, 0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL,
0x000000080c057c24ULL, 0x000fe2000f8e0205ULL, 0x00000000070872caULL, 0x000fe200000e0000ULL,
0x00000001080c7824ULL, 0x000fe400078e0203ULL, 0x0000000112057824ULL, 0x000fc800078e0205ULL,
0x0000000f06067224ULL, 0x000fe400078e0205ULL, 0x0000001003057824ULL, 0x000fe400078e00ffULL,
0x0000010006067825ULL, 0x000fc600078e00ffULL, 0x000000f0050d7812ULL, 0x000fc800078ec0ffULL,
0x0000000d06067212ULL, 0x000fe200078efcffULL, 0x00000010080d7824ULL, 0x000fc600078e00ffULL,
0x0000000406067c10ULL, 0x000fe4000ff1e0ffULL, 0xfffffff00d0c7812ULL, 0x000fe400078ee20cULL,
0x0000000507077c10ULL, 0x000fe400087fe4ffULL, 0x000000080c0d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e4000b901c46ULL,
0x0001760008047890ULL, 0x000fe2000fffe03fULL, 0x00009400ff067b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000404067825ULL, 0x002fe200078e0006ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x00000006060f7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe20003f05270ULL, 0x000000ff0f0c7836ULL, 0x004fe40000000000ULL,
0x0000040f01007387ULL, 0x0003e20000100800ULL, 0x0000007f0f087836ULL, 0x000fe40000000000ULL,
0x00000008ff187819ULL, 0x000fc6000001160cULL, 0x00000007ff0d7819ULL, 0x000fe40000011608ULL,
0x0000081801007387ULL, 0x0003e80000100800ULL, 0x00000c0d01007387ULL, 0x0003e20000100800ULL,
0x000000a800c08947ULL, 0x000fea0003800000ULL, 0x00000003ff0e7819ULL, 0x000fe20000011602ULL,
0xffffffffff127424ULL, 0x000fc600078e00ffULL, 0x01ffffff0e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000d0e00720cULL, 0x000fe20003f06070ULL, 0x00000004ff0d7424ULL, 0x002fd800078e00ffULL,
0x00009600ff078b82ULL, 0x000e620000000800ULL, 0x0000000204008824ULL, 0x000fce00078e00ffULL,
0x00009200ff0a8b82ULL, 0x000ea20000000a00ULL, 0x0000000700078224ULL, 0x002fe200078e0207ULL,
0x0000000802007c11ULL, 0x000fc6000f8e18ffULL, 0x000000010e078824ULL, 0x000fe200078e0207ULL,
0x0176880d00ff79a7ULL, 0x0003e6000850003fULL, 0x00000004070a8825ULL, 0x004fca00078e000aULL,
0x000000060a128981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0c00780cULL, 0x000fe20003f04070ULL,
0x000000804d487824ULL, 0x000fe200078e00ffULL, 0x00000001ff4e7819ULL, 0x000fe40000011602ULL,
0x0000000102507812ULL, 0x000fe200078ec0ffULL, 0x00009000ff067b82ULL, 0x000ee40000000a00ULL,
0x000000204e537824ULL, 0x000fca00078e00ffULL, 0x0000006048007812ULL, 0x002fe200078ef853ULL,
0x0000000912097224ULL, 0x004fc800078e02ffULL, 0x0000008009097824ULL, 0x000fc800078e00ffULL,
0x0000008009067825ULL, 0x008fe200078e0006ULL, 0x0000000000fc0947ULL, 0x000fec0003800000ULL,
0x000000530f087248ULL, 0x000fe20007fe0000ULL, 0x0000001050097824ULL, 0x000fe200078e00ffULL,
0x00000003ff0a7819ULL, 0x000fc60000011603ULL, 0x0000000108087824ULL, 0x000fe400078e0a53ULL,
0x00000001090b7824ULL, 0x000fe400078e020aULL, 0x000000040a0d7836ULL, 0x000fe20000000000ULL,
0x0000000908087248ULL, 0x000fe20007fe0000ULL, 0x000000010b0c7824ULL, 0x040fe400078e0203ULL,
0x000000080b0f7824ULL, 0x000fe400078e00ffULL, 0x0000000108087824ULL, 0x000fc400078e0a09ULL,
0x0000000c0a107836ULL, 0x000fe20000000000ULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee20cULL,
0x000000080a0c7836ULL, 0x000fe20000000000ULL, 0x000000080d00720cULL, 0x080fe20003f46070ULL,
0x00000001000b7824ULL, 0x000fe200078e020bULL, 0x000000080a00720cULL, 0x080fe20003f66070ULL,
0x00000001090d7824ULL, 0x040fe200078e020dULL, 0x000000080c00720cULL, 0x080fe20003f26070ULL,
0x00000001090c7824ULL, 0x040fe200078e020cULL, 0x000000081000720cULL, 0x000fe20003f06070ULL,
0x0000000109117824ULL, 0x000fc400078e0210ULL, 0x000000800b087825ULL, 0x000fc800078e00ffULL,
0x000000010d0a7824ULL, 0x140fe200078e0203ULL, 0x0000007008157812ULL, 0x000fe200078ef805ULL,
0x000000080d137824ULL, 0x000fe400078e00ffULL, 0x000000010c0b7824ULL, 0x100fe200078e0203ULL,
0x0000001506107210ULL, 0x000fe20007f9e0ffULL, 0x0000000111087824ULL, 0x040fe200078e0203ULL,
0xfffffff813137812ULL, 0x000fe200078ee20aULL, 0x00000001000a7824ULL, 0x000fe400078e020cULL,
0x0000000811177824ULL, 0x000fc400078e00ffULL, 0x000000080c0c7824ULL, 0x000fe400078e00ffULL,
0x00000001000d7824ULL, 0x040fe200078e020dULL, 0xfffffff817177812ULL, 0x000fe200078ee208ULL,
0x0000000100147824ULL, 0x000fe200078e0211ULL, 0xfffffff80c157812ULL, 0x000fe200078ee20bULL,
0x0000000107117824ULL, 0x000fe200020e0609ULL, 0x000000084e007c11ULL, 0x000fe2000f8e68ffULL,
0x000000800d087825ULL, 0x000fc800078e00ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x00000070081b7812ULL, 0x000fc600078ef805ULL, 0x00000080140c7825ULL, 0x000fe200078e00ffULL,
0x000000700a197812ULL, 0x000fe400078ef805ULL, 0x0000001b06087210ULL, 0x000fe20007f9e0ffULL,
0x0001300000007836ULL, 0x000fe20000000000ULL, 0x000000700c057812ULL, 0x000fe400078ef805ULL,
0x00000019060a7210ULL, 0x000fe20007fbe0ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0200ULL,
0x0000000506067210ULL, 0x000fe20007fde0ffULL, 0x0000001013137824ULL, 0x000fc400078e0200ULL,
0x0000000107097824ULL, 0x000fe200020e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100f7faeULL, 0x0003e2000d901c46ULL, 0x0000001015157824ULL, 0x100fe400078e0200ULL,
0x00000001070b7824ULL, 0x000fe200028e060bULL, 0x0000000008137faeULL, 0x0003e2000d101c46ULL,
0x0000001017177824ULL, 0x000fe400078e0200ULL, 0x0000000107077824ULL, 0x000fe200030e060dULL,
0x000000000a157faeULL, 0x0003e8000c901c46ULL, 0x0000000006177faeULL, 0x0003e2000c101c46ULL,
0x0000000000c87947ULL, 0x000fea0003800000ULL, 0x0000001050087824ULL, 0x000fca00078e00ffULL,
0x0000000803087211ULL, 0x000fca00078fe8ffULL, 0x00000001080a7824ULL, 0x040fe400078e0203ULL,
0x00000008080f7824ULL, 0x000fe400078e00ffULL, 0x0000000100097824ULL, 0x000fe400078e0208ULL,
0x00000004080b7836ULL, 0x000fe20000000000ULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee20aULL,
0x00000008080a7836ULL, 0x000fe40000000000ULL, 0x0000000c080d7836ULL, 0x000fc40000000000ULL,
0x0000008009087825ULL, 0x000fc800078e00ffULL, 0x000000010b0c7824ULL, 0x040fe200078e0203ULL,
0x0000007008117812ULL, 0x000fe200078ef805ULL, 0x000000080b137824ULL, 0x000fe400078e00ffULL,
0x00000001000b7824ULL, 0x040fe200078e020bULL, 0x0000001106107210ULL, 0x000fe20007f1e0ffULL,
0x0000000100147824ULL, 0x040fe200078e020dULL, 0xfffffff813137812ULL, 0x000fe200078ee20cULL,
0x00000001000c7824ULL, 0x000fe400078e020aULL, 0x000000010a007824ULL, 0x000fc400078e0203ULL,
0x000000080a157824ULL, 0x000fe200078e00ffULL, 0x000000084e0a7c11ULL, 0x000fe2000f8e68ffULL,
0x000000010d087824ULL, 0x040fe400078e0203ULL, 0x000000080d0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff815007812ULL, 0x000fe200078ee200ULL, 0x0000000107117824ULL, 0x000fe400000e0609ULL,
0x000130000a167836ULL, 0x000fe20000000000ULL, 0xfffffff80d157812ULL, 0x000fe200078ee208ULL,
0x000000800b087825ULL, 0x000fc800078e00ffULL, 0x000000800c0a7825ULL, 0x000fe200078e00ffULL,
0x00000070081b7812ULL, 0x000fc600078ef805ULL, 0x00000080140c7825ULL, 0x000fe200078e00ffULL,
0x000000700a197812ULL, 0x000fe400078ef805ULL, 0x0000001b06087210ULL, 0x000fe20007f1e0ffULL,
0x000000100f0f7824ULL, 0x100fe200078e0216ULL, 0x000000700c177812ULL, 0x000fe200078ef805ULL,
0x0000001013137824ULL, 0x100fe200078e0216ULL, 0x00000019060a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000107097824ULL, 0x040fe200000e0609ULL, 0x0000001706067210ULL, 0x000fe20007f5e0ffULL,
0x0000001000057824ULL, 0x000fe200078e0216ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100f7faeULL, 0x0003e2000b901c46ULL, 0x00000001070b7824ULL, 0x000fc400008e060bULL,
0x0000001015157824ULL, 0x000fe200078e0216ULL, 0x0000000008137faeULL, 0x0003e2000b901c46ULL,
0x0000000107077824ULL, 0x000fc600010e060dULL, 0x000000000a057faeULL, 0x0003e8000b901c46ULL,
0x0000000006157faeULL, 0x0003e4000b901c46ULL, 0x00000008ff4c7e24ULL, 0x000fe2000f8e00ffULL,
0x000000004e0472caULL, 0x000fe200000e0000ULL, 0x00000001ff097424ULL, 0x002fe200078e00ffULL,
0x000000ff1800720cULL, 0x000fe20003f05270ULL, 0x000176a84c4c7836ULL, 0x000fe20000000000ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x000000004c0572caULL, 0x000fc400000e0000ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff297224ULL, 0x000fe400078e00ffULL,
0x000000084e087824ULL, 0x000fe400078e024cULL, 0x0000000504047291ULL, 0x000fe2000f8e203fULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000009ff0679a7ULL, 0x0002a20008500004ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fc4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00002009080879a7ULL, 0x002e62000850003fULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000008c007c8947ULL, 0x000fec0003800000ULL, 0x00009600ff0f7b82ULL, 0x000ee20000000800ULL,
0x00000002ff4b7819ULL, 0x000fe20000011602ULL, 0x0000000802057824ULL, 0x000fe200078e00ffULL,
0x000000014e007812ULL, 0x000fe200078ec0ffULL, 0x00000002044a7824ULL, 0x000fe200078e00ffULL,
0x000000084b0b7c11ULL, 0x000fe2000f8e28ffULL, 0x000000ffff067224ULL, 0x004fe200078e0007ULL,
0x0000000805057812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0c7224ULL, 0x000fe400078e00ffULL,
0x0000001000087824ULL, 0x002fc400078e020bULL, 0x000000ffff007224ULL, 0x000fe400078e0009ULL,
0x00000001050d7824ULL, 0x000fe400078e0208ULL, 0xff317217ff087424ULL, 0x000fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x000fe400078e00ffULL, 0x0000000f4a4a7224ULL, 0x008fce00078e020fULL,
0x0000000000107805ULL, 0x016fe20000015200ULL, 0x0000000402077824ULL, 0x000fca00078e00ffULL,
0xfffffff807077812ULL, 0x000fc800078ec0ffULL, 0x0176c800070075a7ULL, 0x000e620008000148ULL,
0x00000008070f7c36ULL, 0x000fc80008000000ULL, 0x000176c80f137836ULL, 0x000fc80000000000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0013ULL, 0x0000000000600947ULL, 0x002fec0003800000ULL,
0x000000ffff147224ULL, 0x000fce00078e00ffULL, 0x000000101400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a100a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e11ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc8000001140bULL, 0x0000000a07077211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000207077819ULL, 0x000fc8000000120aULL,
0x000000070000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000114147836ULL, 0x000fce0000000000ULL, 0x0176c8000f0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ffff0b7224ULL, 0x000fce00078e0013ULL,
0x00000800010f7983ULL, 0x000ea20000100800ULL, 0x00009000ff107b82ULL, 0x000e620000000a00ULL,
0x0000001002007824ULL, 0x000fe200078e00ffULL, 0x0000850000057ab9ULL, 0x000fe20000000800ULL,
0x000000010c0a7836ULL, 0x000fe40000000000ULL, 0x0000000512127c24ULL, 0x000fe2000f8e02ffULL,
0xffffffe000077812ULL, 0x000fca00078ec0ffULL, 0x000001000c077824ULL, 0x000fc800078e0207ULL,
0x0000004007137836ULL, 0x000fca0000000000ULL, 0x0000006013077812ULL, 0x000fca00078ec0ffULL,
0x00000001481b7824ULL, 0x000fe200078e0207ULL, 0x0000000f0a00720cULL, 0x004fe20003f26070ULL,
0x00000080120f7824ULL, 0x000fc800078e00ffULL, 0x000000800f107825ULL, 0x002fd000078e0010ULL,
0x0000000400089947ULL, 0x000fea0003800000ULL, 0x0000040001147983ULL, 0x000ea20000100800ULL,
0x0000001000077812ULL, 0x000fe400078ec0ffULL, 0x00000003ff127819ULL, 0x000fca0000011603ULL,
0x00000001120a7824ULL, 0x000fe400078e0207ULL, 0x00000008121a7836ULL, 0x000fe40000000000ULL,
0x000000010a0f7824ULL, 0x040fe200078e0203ULL, 0x0000001314007248ULL, 0x004fe20007fe0000ULL,
0x000000080a147824ULL, 0x000fc800078e00ffULL, 0x0000000100007824ULL, 0x000fe200078e0a13ULL,
0xfffffff8140f7812ULL, 0x000fe200078ee20fULL, 0x0000000412147836ULL, 0x000fe40000000000ULL,
0x0000001003137824ULL, 0x000fe200078e00ffULL, 0x0000000700007248ULL, 0x000fc80007fe0000ULL,
0x0000007013437812ULL, 0x000fe200078ec0ffULL, 0x0000000100007824ULL, 0x000fca00078e0a07ULL,
0x000000001200720cULL, 0x080fe20003f86070ULL, 0x0000000c12127836ULL, 0x000fe20000000000ULL,
0x000000001400720cULL, 0x0c0fe20003f66070ULL, 0x0000000114147824ULL, 0x100fe200078e0207ULL,
0x000000001a00720cULL, 0x0c0fe20003f46070ULL, 0x000000011a1a7824ULL, 0x100fe200078e0207ULL,
0x000000001200720cULL, 0x040fe20003f06070ULL, 0x00000001123c7824ULL, 0x000fe400078e0207ULL,
0x000000011b127824ULL, 0x040fe400078e020aULL, 0x000000011b187824ULL, 0x000fc400078e0214ULL,
0x0000000114007824ULL, 0x140fe400078e0203ULL, 0x0000000814077824ULL, 0x000fe400078e00ffULL,
0x000000011b147824ULL, 0x040fe400078e021aULL, 0x000000011b1b7824ULL, 0x000fe200078e023cULL,
0xfffffff807077812ULL, 0x000fe200078ee200ULL, 0x000000013c157824ULL, 0x000fe200078e0203ULL,
0x000000084e007c11ULL, 0x000fe2000f8e68ffULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x000000083c3c7824ULL, 0x000fe200078e00ffULL, 0x0000004312417212ULL, 0x000fe200078efcffULL,
0x0000008018187825ULL, 0x000fc600078e00ffULL, 0xfffffff83c3d7812ULL, 0x000fe200078ee215ULL,
0x000000011a0a7824ULL, 0x000fe200078e0203ULL, 0x00000043183f7212ULL, 0x080fe200078efcffULL,
0x000000081a177824ULL, 0x000fe200078e00ffULL, 0x0000004110127210ULL, 0x000fe20007fbe0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000003f10187210ULL, 0x000fe40007fde0ffULL,
0xfffffff817177812ULL, 0x000fe200078ee20aULL, 0x000000801b1a7825ULL, 0x000fe200078e00ffULL,
0x0000004314417212ULL, 0x000fc600078efcffULL, 0x0000000111137824ULL, 0x040fe200028e0613ULL,
0x000000431a3f7212ULL, 0x000fe200078efcffULL, 0x0001400000007836ULL, 0x000fe20000000000ULL,
0x0000004110147210ULL, 0x000fe20007fbe0ffULL, 0x0000000111197824ULL, 0x000fe200030e0619ULL,
0x0000003f10107210ULL, 0x000fe20007fde0ffULL, 0x000000100f0f7824ULL, 0x100fe400078e0200ULL,
0x0000001007077824ULL, 0x100fe400078e0200ULL, 0x0000001017177824ULL, 0x000fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000120f7faeULL, 0x0003e2000e101c46ULL,
0x0000000111157824ULL, 0x000fc400028e0615ULL, 0x000000103d3d7824ULL, 0x000fe200078e0200ULL,
0x0000000018077faeULL, 0x0003e2000d901c46ULL, 0x0000000111117824ULL, 0x000fc600030e061bULL,
0x0000000014177faeULL, 0x0003e8000d101c46ULL, 0x00000000103d7faeULL, 0x0003e2000c101c46ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x0000001000007812ULL, 0x000fe200078ec0ffULL,
0x0000001003137824ULL, 0x000fc600078e00ffULL, 0x0000000003007211ULL, 0x000fe400078fe8ffULL,
0x00000070133d7812ULL, 0x000fc600078ec0ffULL, 0x0000000100077824ULL, 0x140fe400078e0203ULL,
0x0000000800127824ULL, 0x000fe400078e00ffULL, 0x00000004000a7836ULL, 0x000fe40000000000ULL,
0x0000000800187836ULL, 0x000fe20000000000ULL, 0xfffffff812077812ULL, 0x000fe200078ee207ULL,
0x000000011b127824ULL, 0x000fe400078e0200ULL, 0x000000010a0f7824ULL, 0x000fc400078e0203ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x000000080a147824ULL, 0x000fe200078e00ffULL,
0x0000003d12157212ULL, 0x000fe200078efcffULL, 0x0000000c001a7836ULL, 0x000fe40000000000ULL,
0x000000011b197824ULL, 0x040fe200078e0218ULL, 0x0000001510127210ULL, 0x000fe20007f1e0ffULL,
0x0000000118007824ULL, 0x000fe200078e0203ULL, 0x000000084e157c11ULL, 0x000fe2000f8e68ffULL,
0x0000000818177824ULL, 0x000fe200078e00ffULL, 0xfffffff8140f7812ULL, 0x000fe200078ee20fULL,
0x000000011b147824ULL, 0x000fc400078e020aULL, 0x000000011b1b7824ULL, 0x000fe200078e021aULL,
0xfffffff817007812ULL, 0x000fe200078ee200ULL, 0x00014000153c7836ULL, 0x000fe40000000000ULL,
0x000000011a0a7824ULL, 0x040fe400078e0203ULL, 0x000000081a3f7824ULL, 0x000fe400078e00ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff83f0a7812ULL, 0x000fe200078ee20aULL,
0x0000008019187825ULL, 0x000fe200078e00ffULL, 0x0000003d14417212ULL, 0x000fc600078efcffULL,
0x000000801b1a7825ULL, 0x000fe200078e00ffULL, 0x0000003d183f7212ULL, 0x000fc600078efcffULL,
0x0000000111137824ULL, 0x000fe200000e0613ULL, 0x0000003d1a3d7212ULL, 0x000fe200078efcffULL,
0x0000001007077824ULL, 0x100fe200078e023cULL, 0x0000004110147210ULL, 0x000fe20007f1e0ffULL,
0x000000100f0f7824ULL, 0x100fe200078e023cULL, 0x0000003f10187210ULL, 0x000fe20007f5e0ffULL,
0x0000001000177824ULL, 0x000fe200078e023cULL, 0x0000003d10107210ULL, 0x000fe20007f7e0ffULL,
0x0000000111157824ULL, 0x040fe200000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012077faeULL, 0x0003e2000b901c46ULL, 0x0000000111197824ULL, 0x000fc400010e0619ULL,
0x000000100a3d7824ULL, 0x000fe200078e023cULL, 0x00000000140f7faeULL, 0x0003e2000b901c46ULL,
0x0000000111117824ULL, 0x000fc600018e061bULL, 0x0000000018177faeULL, 0x0003e8000b901c46ULL,
0x00000000103d7faeULL, 0x0003e4000b901c46ULL, 0x00000c0001007983ULL, 0x000ea20000100800ULL,
0x000000010e077836ULL, 0x002fe40000000000ULL, 0x0000000802177824ULL, 0x000fe400078e00ffULL,
0xffffffffff127424ULL, 0x000fc600078e00ffULL, 0xfffffff0170f7812ULL, 0x000fca00078ec0ffULL,
0x000000080f467c36ULL, 0x000fe20008000000ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x00000000460572caULL, 0x000fda00000e0000ULL, 0x000176b005057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x00000001ff197424ULL, 0x000fe200078e00ffULL,
0x000000000700720cULL, 0x004fda0003f06070ULL, 0x00009200ff108b82ULL, 0x000e620000000a00ULL,
0x000000014a078824ULL, 0x000fe200078e0207ULL, 0xffffffe017007812ULL, 0x000fc600078ec0ffULL,
0x0000000407108825ULL, 0x002fca00078e0010ULL, 0x0000000610128981ULL, 0x000322000c1e1900ULL,
0x0000001017077812ULL, 0x000fc800078ec0ffULL, 0x0000000807007c10ULL, 0x000fe4000fffe000ULL,
0x0000000817077812ULL, 0x000fca00078ec0ffULL, 0x00000001000a7824ULL, 0x000fe200078e0207ULL,
0x0000000000007918ULL, 0x002fcc0000000000ULL, 0x0176b019464679a7ULL, 0x0002a4000850003fULL,
0x017608190a1879a7ULL, 0x0022e4000850003fULL, 0x0000000000107805ULL, 0x000fce0000015200ULL,
0x017608190a0075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff0f7224ULL, 0x000fce00078e00ffULL, 0x000000100f00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000001410077210ULL, 0x000fca0007f1e1ffULL, 0x0000000115147824ULL, 0x000fe200000e0e11ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011414ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0614ULL, 0x0000000200007819ULL, 0x000fc80000001207ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010f0f7836ULL, 0x000fce0000000000ULL, 0x017608190a0075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x0000001003497824ULL, 0x000fe200078e00ffULL,
0x00000001ff4f7819ULL, 0x000fe20000011603ULL, 0x0000002002007824ULL, 0x000fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200078e0008ULL, 0x0000007049497812ULL, 0x000fe400078ec0ffULL,
0xffffff8000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c4f4f7812ULL, 0x000fe400078ec0ffULL,
0x0000000849007c10ULL, 0x000fca000fffe000ULL, 0x0000000100007824ULL, 0x000fca00078e024fULL,
0x0170000000077984ULL, 0x000ee80000000800ULL, 0x0172000000107984ULL, 0x000b620000000800ULL,
0x000000080700720bULL, 0x008fda0003f1d000ULL, 0x00000000000f7806ULL, 0x000fc800000e0100ULL,
0x0000ffff0f137812ULL, 0x000fe2000780c0ffULL, 0x00000001ff0f7424ULL, 0x000fd800078e00ffULL,
0x0000000000fc8947ULL, 0x026fea0003800000ULL, 0x000000024b00720cULL, 0x000fe40003f45270ULL,
0x000000080700720bULL, 0x000fd60003f14000ULL, 0x000000080214ac11ULL, 0x000fe4000f8e38ffULL,
0x000000080700a209ULL, 0x000fe40007810000ULL, 0x000000144f0fa210ULL, 0x000fe40007ffe049ULL,
0x0000000000147806ULL, 0x000fc600000e0100ULL, 0x017400000f00a388ULL, 0x0003e20000000800ULL,
0x0000991014117816ULL, 0x000fc800000000ffULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x00000008070f7209ULL, 0x000fe40007810000ULL,
0x000000ff14ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0014ff7812ULL, 0x000fe2000784c0ffULL,
0x000000080f007221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b00007820ULL, 0x000fc80000410000ULL,
0x00000000000f7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff007819ULL, 0x002fcc0000011603ULL, 0x00001f000f007589ULL, 0x004e6400000e0000ULL,
0x0000000038387220ULL, 0x082fe20000410000ULL, 0x0000000039397220ULL, 0x080fe20000410000ULL,
0x0000000034347220ULL, 0x080fe20000410000ULL, 0x0000000035357220ULL, 0x080fe20000410000ULL,
0x0000000030307220ULL, 0x080fe20000410000ULL, 0x0000000031317220ULL, 0x080fe20000410000ULL,
0x000000002c2c7220ULL, 0x080fe20000410000ULL, 0x000000002d2d7220ULL, 0x080fe20000410000ULL,
0x0000000028287220ULL, 0x080fe20000410000ULL, 0x0000000029297220ULL, 0x080fe20000410000ULL,
0x0000000024247220ULL, 0x080fe20000410000ULL, 0x0000000025257220ULL, 0x080fe20000410000ULL,
0x0000000020207220ULL, 0x080fe20000410000ULL, 0x0000000021217220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x000fce0000410000ULL,
0x0000000f16167220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x0000000803007811ULL, 0x002fcc00078ff0ffULL, 0x00001f000f007589ULL, 0x000e6400000e0000ULL,
0x000000003a3a7220ULL, 0x082fe20000410000ULL, 0x000000003b3b7220ULL, 0x080fe20000410000ULL,
0x0000000036367220ULL, 0x080fe20000410000ULL, 0x0000000037377220ULL, 0x080fe20000410000ULL,
0x0000000032327220ULL, 0x080fe20000410000ULL, 0x0000000033337220ULL, 0x080fe20000410000ULL,
0x000000002e2e7220ULL, 0x080fe20000410000ULL, 0x000000002f2f7220ULL, 0x080fe20000410000ULL,
0x000000002a2a7220ULL, 0x080fe20000410000ULL, 0x000000002b2b7220ULL, 0x080fe20000410000ULL,
0x0000000026267220ULL, 0x080fe20000410000ULL, 0x0000000027277220ULL, 0x080fe20000410000ULL,
0x0000000022227220ULL, 0x080fe20000410000ULL, 0x0000000023237220ULL, 0x080fe20000410000ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x000000001f1f7220ULL, 0x000fce0000410000ULL,
0x0000ffff13ff7812ULL, 0x000fe20007806014ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000807117209ULL, 0x000fd60007810000ULL, 0x8000001107070221ULL, 0x000fe20000010000ULL,
0x00007610ff0f0816ULL, 0x000fc6000000000fULL, 0x3fb8aa3b07070820ULL, 0x000fc80000410000ULL,
0x0000000700090308ULL, 0x000ea40000000800ULL, 0x0000000910100220ULL, 0x004fce0000410000ULL,
0x0000001610167221ULL, 0x000fce0000010000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0xfffffff017177812ULL, 0x000fc800078ec0ffULL, 0x0176a806170075a7ULL, 0x000ea20008000148ULL,
0x0000000817137c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x004fec0003800000ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x000000100800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fce0000015200ULL,
0x0000001814077210ULL, 0x000fca0007f1e1ffULL, 0x0000000119187824ULL, 0x000fe200000e0e15ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff1800720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff1800720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x002fc80000011418ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0618ULL, 0x0000000200007819ULL, 0x000fc80000001207ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000108087836ULL, 0x000fce0000000000ULL, 0x0176a806130075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x000099100f007816ULL, 0x002fe200000000ffULL,
0x0000000202137824ULL, 0x040fe200078e00ffULL, 0x0000000703177812ULL, 0x000fe200078ec0ffULL,
0x0000000402157824ULL, 0x000fe200078e00ffULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x0000020002067824ULL, 0x000fe200078e00ffULL, 0x0000000413007812ULL, 0x000fe400078ec0ffULL,
0x0000000817547812ULL, 0x000fe400078ef803ULL, 0x0000000003077211ULL, 0x000fc400078fe0ffULL,
0x0000000803107812ULL, 0x000fe200078ec0ffULL, 0x0000000854007824ULL, 0x040fe200078e00ffULL,
0x00000004ff557819ULL, 0x000fe20000011603ULL, 0x0000000154077824ULL, 0x000fe200078e0207ULL,
0x0000000415157812ULL, 0x000fe400078ec0ffULL, 0xfffff80006067812ULL, 0x000fe400078ec0ffULL,
0x0000001710407212ULL, 0x000fe200078efcffULL, 0x0000000155157824ULL, 0x000fe200078e0215ULL,
0x000000084e087c11ULL, 0x000fe2000f8e68ffULL, 0x0000000806447c36ULL, 0x000fe20008000000ULL,
0xfffffff800457812ULL, 0x000fe200078ee207ULL, 0x0000000840067824ULL, 0x000fc400078e00ffULL,
0x0000000140417824ULL, 0x000fe400078e0215ULL, 0x0001300008147836ULL, 0x000fe40000000000ULL,
0x0000001045457824ULL, 0x000fe200078e0244ULL, 0xfffffff806067812ULL, 0x000fe200078ee241ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff057819ULL, 0x000fe40000011603ULL,
0x00000009ff00723eULL, 0x000fc600000000ffULL, 0x00000008050f7836ULL, 0x000fe20000000000ULL,
0x0000541000007816ULL, 0x000fca0000000000ULL, 0x00001f0500057589ULL, 0x0002a800000e0000ULL,
0x00001f0f00047589ULL, 0x0002e400000e0000ULL, 0x011000004518783bULL, 0x0002e20000000200ULL,
0x00000010063c7824ULL, 0x000fe200078e0214ULL, 0x0000000000100947ULL, 0x000fec0003800000ULL,
0x0000000518187232ULL, 0x08cfe40000000000ULL, 0x000000051a1a7232ULL, 0x000fe40000000000ULL,
0x0000000419197232ULL, 0x080fe40000000000ULL, 0x000000041b1b7232ULL, 0x000fce0000000000ULL,
0x00000008400f7824ULL, 0x002fe200078e00ffULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0x0000000241007836ULL, 0x000fe20000000000ULL, 0x0000001010107812ULL, 0x000fc800078efe17ULL,
0xfffffff80f007812ULL, 0x000fe200078ee200ULL, 0x000000044e0f7824ULL, 0x000fe400078e0255ULL,
0x0000000115157824ULL, 0x000fe400078e0210ULL, 0x0000001000407824ULL, 0x000fe200078e0214ULL,
0x000000020f0f7810ULL, 0x000fe20007ffe054ULL, 0x0000000854547824ULL, 0x000fc800078e00ffULL,
0x000000004040783bULL, 0x000f620000004200ULL, 0xfffffff8540f7812ULL, 0x000fca00078ee20fULL,
0x000000100f447824ULL, 0x000fe200078e0244ULL, 0x00000010ff5f7819ULL, 0x102fe4000001163fULL,
0x000000ff3f5d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff697819ULL, 0x000fe4000001163fULL,
0x0000ffff3f547812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6a7819ULL, 0x000fe4000001163cULL,
0x000000ff3c677812ULL, 0x000fc400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe4000001163cULL,
0x0000ffff3c687812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6b7819ULL, 0x000fe4000001163dULL,
0x000000ff423f7812ULL, 0x028fe400078ec0ffULL, 0x00000010ff3c7819ULL, 0x000fe4000001163eULL,
0x000000ff3e5e7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff177819ULL, 0x000fe4000001163eULL,
0x0000ffff3e587812ULL, 0x000fe400078ec0ffULL, 0x000000ff3d667812ULL, 0x000fe400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe4000001163dULL, 0x00000010ff657819ULL, 0x000fe40000011640ULL,
0x000000ff405a7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe40000011640ULL,
0x0000ffff40637812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3e7819ULL, 0x100fe40000011642ULL,
0x0000ffff3d3d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5b7819ULL, 0x000fe40000011642ULL,
0x0000ffff42557812ULL, 0x000fc400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011643ULL,
0x0000003fff42723eULL, 0x000fe400020006ffULL, 0x000000ff6a6a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL, 0x00000017ff3f723eULL, 0x000fe400020006ffULL,
0x0000003eff17723eULL, 0x000fc400020006ffULL, 0x00000040ff3e723eULL, 0x000fe400020006ffULL,
0x00000008ff3d7819ULL, 0x000fe4000001163dULL, 0x000000ff3c3c7812ULL, 0x000fe400078ec0ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000069ff40723eULL, 0x000fc400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x000000ff5f697812ULL, 0x000fe400078ec0ffULL,
0x000000ff655f7812ULL, 0x000fe400078ec0ffULL, 0x0000003dff6c723eULL, 0x000fe400020006ffULL,
0x0000003cff65723eULL, 0x000fc400020006ffULL, 0x00000008ff687819ULL, 0x000fe40000011668ULL,
0x00005410673c7816ULL, 0x000fe4000000006aULL, 0x00005410663d7816ULL, 0x000fe4000000006bULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x0000003c1838723cULL, 0x000fe20000001838ULL,
0x00000010ff647819ULL, 0x000fc40000011641ULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00005410683c7816ULL, 0x000fe40000000062ULL,
0x000054106c3d7816ULL, 0x000fe40000000061ULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x000000ff41597812ULL, 0x000fc400078ec0ffULL, 0x000000ff64647812ULL, 0x000fe200078ec0ffULL,
0x0000003c1834723cULL, 0x000fe20000001834ULL, 0x0000ffff41607812ULL, 0x000fe400078ec0ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x000054105e3c7816ULL, 0x000fe40000000065ULL, 0x000054105d3d7816ULL, 0x000fc40000000069ULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000018ff567819ULL, 0x000fe20000011641ULL, 0x0000003c1830723cULL, 0x000fe20000001830ULL,
0x00000008ff637819ULL, 0x000fe40000011663ULL, 0x00000008ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff5c7819ULL, 0x000fc40000011643ULL, 0x000054105a3c7816ULL, 0x000fe4000000005fULL,
0x00005410593d7816ULL, 0x000fe40000000064ULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x0000003c1828723cULL, 0x000fe20000001828ULL, 0x00000060ff60723eULL, 0x000fc400020006ffULL,
0x000000ff43417812ULL, 0x000fe400078ec0ffULL, 0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x00005410633c7816ULL, 0x000fe40000000057ULL,
0x00005410603d7816ULL, 0x000fe40000000056ULL, 0x00000041ff41723eULL, 0x000fc400020006ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x0000003c1824723cULL, 0x000fe20000001824ULL, 0x00000008ff587819ULL, 0x000fe40000011658ULL,
0x00000008ff547819ULL, 0x000fe40000011654ULL, 0x0000ffff43437812ULL, 0x000fe400078ec0ffULL,
0x00005410423c7816ULL, 0x000fe2000000005bULL, 0x0000000810427824ULL, 0x000fe200078e00ffULL,
0x00005410413d7816ULL, 0x000fc4000000005cULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000008ff557819ULL, 0x000fe20000011655ULL,
0x0000003c1820723cULL, 0x000fe20000001820ULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fc400020006ffULL,
0x00005410583c7816ULL, 0x000fe4000000003fULL, 0x00005410543d7816ULL, 0x000fe40000000040ULL,
0xfffffff8420f7812ULL, 0x000fca00078ee215ULL, 0x0000003c182c723cULL, 0x000fee000000182cULL,
0x00005410553c7816ULL, 0x000fe40000000017ULL, 0x00005410433d7816ULL, 0x000fce000000003eULL,
0x0000003c181c723cULL, 0x000fe2000000181cULL, 0x011000004418783bULL, 0x0002ec0000000200ULL,
0x000000100f3c7824ULL, 0x000fe200078e0214ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000518187232ULL, 0x08cfe40000000000ULL,
0x000000051a1a7232ULL, 0x000fe40000000000ULL, 0x0000000419197232ULL, 0x080fe40000000000ULL,
0x000000041b1b7232ULL, 0x000fce0000000000ULL, 0x0000000810177824ULL, 0x000fe200078e00ffULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x0000000215107836ULL, 0x000fe20000000000ULL,
0xfffffff813137812ULL, 0x000fc800078ec0ffULL, 0xfffffff817107812ULL, 0x000fca00078ee210ULL,
0x0000001010407824ULL, 0x000fcc00078e0214ULL, 0x000000004040783bULL, 0x000f640000004200ULL,
0x00000010ff687819ULL, 0x122fe4000001163dULL, 0x000000ff3d667812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001163dULL, 0x0000ffff3d5e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff627819ULL, 0x000fc4000001163eULL, 0x000000ff3e5d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff587819ULL, 0x000fe4000001163eULL, 0x0000ffff3e647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff677819ULL, 0x000fe4000001163cULL, 0x00000018ff157819ULL, 0x008fe40000011640ULL,
0x000000ff3c657812ULL, 0x000fc400078ec0ffULL, 0x00000018ff607819ULL, 0x000fe4000001163cULL,
0x0000ffff3c177812ULL, 0x000fe400078ec0ffULL, 0x00000010ff637819ULL, 0x100fe4000001163fULL,
0x000000ff3f5c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe4000001163fULL,
0x0000ffff3f3d7812ULL, 0x000fc400078ec0ffULL, 0x000000ff413e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe40000011642ULL, 0x00000010ff3c7819ULL, 0x000fe40000011640ULL,
0x000000ff40567812ULL, 0x040fe400078ec0ffULL, 0x0000ffff40597812ULL, 0x000fe400078ec0ffULL,
0x000000ff423f7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff617819ULL, 0x100fe40000011641ULL,
0x00000018ff407819ULL, 0x000fe40000011641ULL, 0x0000ffff415a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff436b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff547819ULL, 0x100fe40000011643ULL,
0x00000018ff697819ULL, 0x000fc40000011643ULL, 0x0000ffff43557812ULL, 0x000fe400078ec0ffULL,
0x00000015ff41723eULL, 0x000fe400020006ffULL, 0x0000003eff43723eULL, 0x000fe400020006ffULL,
0x0000006aff15723eULL, 0x000fe400020006ffULL, 0x000000ff67677812ULL, 0x000fe400078ec0ffULL,
0x0000003fff3e723eULL, 0x000fc400020006ffULL, 0x00000008ff6a7819ULL, 0x000fe40000011617ULL,
0x0000006bff3f723eULL, 0x000fe400020006ffULL, 0x000000ff686b7812ULL, 0x000fe400078ec0ffULL,
0x00000067ff68723eULL, 0x000fe400020006ffULL, 0x0000006aff67723eULL, 0x000fe400020006ffULL,
0x00000008ff5e7819ULL, 0x000fc4000001165eULL, 0x000000ff62627812ULL, 0x000fe400078ec0ffULL,
0x000000ff636a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff647819ULL, 0x000fe40000011664ULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000069ff17723eULL, 0x000fc400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x0000005eff69723eULL, 0x000fe400020006ffULL, 0x00000062ff63723eULL, 0x000fe400020006ffULL,
0x0000006aff62723eULL, 0x000fe400020006ffULL, 0x00000064ff5e723eULL, 0x000fe400020006ffULL,
0x00000008ff647819ULL, 0x000fc4000001163dULL, 0x000000ff3c6a7812ULL, 0x000fe400078ec0ffULL,
0x00005410653c7816ULL, 0x000fe40000000068ULL, 0x00005410663d7816ULL, 0x000fe4000000006bULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x0000003c1838723cULL, 0x000fe20000001838ULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00005410673c7816ULL, 0x000fe40000000060ULL,
0x00005410693d7816ULL, 0x000fe4000000005fULL, 0x00000064ff65723eULL, 0x000fe400020006ffULL,
0x000000ff61617812ULL, 0x000fc400078ec0ffULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x0000003c1834723cULL, 0x000fe20000001834ULL, 0x0000006aff64723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000008ff597819ULL, 0x000fe40000011659ULL,
0x000054105d3c7816ULL, 0x000fe40000000063ULL, 0x000054105c3d7816ULL, 0x000fc40000000062ULL,
0x00000008ff5a7819ULL, 0x000fe4000001165aULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x0000003c1830723cULL, 0x000fe20000001830ULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000010ff5b7819ULL, 0x000fe40000011642ULL,
0x0000ffff42427812ULL, 0x000fc400078ec0ffULL, 0x000054105e3c7816ULL, 0x000fe40000000058ULL,
0x00005410653d7816ULL, 0x000fe40000000057ULL, 0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff54547812ULL, 0x000fe400078ec0ffULL, 0x00000008ff427819ULL, 0x000fe20000011642ULL,
0x0000003c182c723cULL, 0x000fe2000000182cULL, 0x00000008ff557819ULL, 0x000fc40000011655ULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x00005410563c7816ULL, 0x000fe40000000064ULL, 0x00005410433d7816ULL, 0x000fe40000000061ULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x00000055ff43723eULL, 0x000fc400020006ffULL,
0x000054103e3e7816ULL, 0x000fe2000000005bULL, 0x0000003c1828723cULL, 0x000fe20000001828ULL,
0x000054103f3f7816ULL, 0x000fe40000000054ULL, 0x0000541042427816ULL, 0x000fe40000000015ULL,
0x0000541043437816ULL, 0x000fe40000000017ULL, 0x00005410593c7816ULL, 0x000fe20000000041ULL,
0x0000003e1820723cULL, 0x000fe20000001820ULL, 0x000054105a3d7816ULL, 0x000fe20000000040ULL,
0x00000001ff407424ULL, 0x000fc800078e00ffULL, 0x00000042181c723cULL, 0x000fec000000181cULL,
0x0000003c1824723cULL, 0x000fee0000001824ULL, 0x000000084e3c7c11ULL, 0x000fcc000f8e18ffULL,
0x0176c8403c3c79a7ULL, 0x0002e2000850003fULL, 0x0176884013ff79a7ULL, 0x0003f40008500008ULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x0000003d0b0075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff157224ULL, 0x000fce00078e00ffULL,
0x000000101500780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x0000001a181a7210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0e19ULL, 0x003d09001a00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401a00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x002fc8000001141bULL,
0x0000001a13137211ULL, 0x000fca00078110ffULL, 0x000000ffff1a7224ULL, 0x000fca00000e061bULL,
0x0000000213137819ULL, 0x000fc8000000121aULL, 0x000000130000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000115157836ULL, 0x000fce0000000000ULL,
0x0000003d0b0075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x00009000ff187b82ULL, 0x000ee20000000a00ULL, 0x00000010021b7824ULL, 0x000fe200078e00ffULL,
0x0000850000057ab9ULL, 0x000fe40000000800ULL, 0x0000000512127c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe01b137812ULL, 0x002fca00078ec0ffULL, 0x000001000c137824ULL, 0x000fc800078e0213ULL,
0x00000080131a7836ULL, 0x000fe40000000000ULL, 0x0000008012137824ULL, 0x000fc600078e00ffULL,
0x000000601a157812ULL, 0x000fe200078ec0ffULL, 0x0000008013127825ULL, 0x008fc800078e0018ULL,
0x0000000148177824ULL, 0x000fe200078e0215ULL, 0x0000000000f89947ULL, 0x000fec0003800000ULL,
0x00000400013e7983ULL, 0x000ee20000100800ULL, 0x000000101b3c7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff187819ULL, 0x000fca0000011603ULL, 0x00000004181b7836ULL, 0x000fe40000000000ULL,
0x0000000c183d7836ULL, 0x000fc80000000000ULL, 0x000000013d407824ULL, 0x000fc800078e023cULL,
0x0000000140417824ULL, 0x000fe200078e0203ULL, 0x0000001a3e157248ULL, 0x008fca0007fe0000ULL,
0x0000000115157824ULL, 0x000fe400078e0a1aULL, 0x00000001181a7824ULL, 0x000fc600078e023cULL,
0x000000153c157248ULL, 0x000fe20007fe0000ULL, 0x000000011a197824ULL, 0x040fe400078e0203ULL,
0x000000081a3e7824ULL, 0x000fe400078e00ffULL, 0x0000000115157824ULL, 0x000fc600078e0a3cULL,
0xfffffff83e557812ULL, 0x000fe200078ee219ULL, 0x0000000818197836ULL, 0x000fe20000000000ULL,
0x000000151800720cULL, 0x080fe20003f86070ULL, 0x000000011b3e7824ULL, 0x140fe200078e023cULL,
0x000000151b00720cULL, 0x080fe20003f66070ULL, 0x000000011a187824ULL, 0x000fe200078e0217ULL,
0x000000151900720cULL, 0x0c0fe20003f46070ULL, 0x00000001191a7824ULL, 0x000fe200078e023cULL,
0x000000153d00720cULL, 0x000fe20003f06070ULL, 0x000000013e197824ULL, 0x040fe400078e0203ULL,
0x000000083e3c7824ULL, 0x000fc400078e00ffULL, 0x000000013e3e7824ULL, 0x000fe400078e0217ULL,
0x000000011a1b7824ULL, 0x000fe200078e0203ULL, 0xfffffff83c577812ULL, 0x000fe200078ee219ULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x000000081a427824ULL, 0x000fe400078e00ffULL,
0x000000803e3e7825ULL, 0x000fc600078e00ffULL, 0xfffffff842597812ULL, 0x000fe200078ee21bULL,
0x000000011a3c7824ULL, 0x100fe200078e0217ULL, 0x000000493e157212ULL, 0x080fe200078efcffULL,
0x00000001401a7824ULL, 0x000fe200078e0217ULL, 0x0000004918177212ULL, 0x080fe200078efcffULL,
0x0000000840407824ULL, 0x000fe200078e00ffULL, 0x00000015123e7210ULL, 0x000fe20007fde0ffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000001712187210ULL, 0x000fe40007fbe0ffULL,
0xfffffff8405b7812ULL, 0x000fe200078ee241ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x000000493c437212ULL, 0x000fc600078efcffULL, 0x0000000113197824ULL, 0x040fe200028e0619ULL,
0x000000491a417212ULL, 0x000fe200078efcffULL, 0x00000001133f7824ULL, 0x000fe200030e063fULL,
0x00000043123c7210ULL, 0x000fe20007fbe0ffULL, 0x0000001055157824ULL, 0x100fe200078e0214ULL,
0x00000041121a7210ULL, 0x000fe20007fde0ffULL, 0x0000001057177824ULL, 0x100fe400078e0214ULL,
0x0000001059417824ULL, 0x000fe200078e0214ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018157faeULL, 0x0003e2000e101c46ULL, 0x00000001133d7824ULL, 0x000fc400028e063dULL,
0x000000105b437824ULL, 0x000fe200078e0214ULL, 0x000000003e177faeULL, 0x0003e2000d901c46ULL,
0x00000001131b7824ULL, 0x000fc600030e061bULL, 0x000000003c417faeULL, 0x0003e8000d101c46ULL,
0x000000001a437faeULL, 0x0003e2000c101c46ULL, 0x0000000000c07947ULL, 0x000fea0003800000ULL,
0x000000101b187812ULL, 0x000fc800078ec0ffULL, 0x00000018031a7211ULL, 0x000fca00078fe8ffULL,
0x000000011a157824ULL, 0x040fe400078e0203ULL, 0x000000081a3c7824ULL, 0x040fe400078e00ffULL,
0x000000041a3e7836ULL, 0x000fe40000000000ULL, 0x000000081a407836ULL, 0x000fe20000000000ULL,
0xfffffff83c417812ULL, 0x000fe200078ee215ULL, 0x000000011a187824ULL, 0x000fe400078e0217ULL,
0x0000000c1a427836ULL, 0x000fc40000000000ULL, 0x000000013e3c7824ULL, 0x040fe400078e0217ULL,
0x000000013e1b7824ULL, 0x040fe400078e0203ULL, 0x000000083e547824ULL, 0x000fe400078e00ffULL,
0x00000001403e7824ULL, 0x040fe400078e0217ULL, 0x00000001403d7824ULL, 0x000fe400078e0203ULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x00000001421a7824ULL, 0x000fe200078e0217ULL,
0x0000004918157212ULL, 0x000fe200078efcffULL, 0x0000000840407824ULL, 0x000fe200078e00ffULL,
0xfffffff854177812ULL, 0x000fe200078ee21bULL, 0x00000001423f7824ULL, 0x040fe200078e0203ULL,
0x0000001512187210ULL, 0x000fe20007f1e0ffULL, 0x0000000842427824ULL, 0x000fe200078e00ffULL,
0xfffffff840597812ULL, 0x000fe200078ee23dULL, 0x000000803c3c7825ULL, 0x000fc600078e00ffULL,
0xfffffff8425b7812ULL, 0x000fe200078ee23fULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x000000493c577212ULL, 0x000fc600078efcffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x000000493e557212ULL, 0x000fc600078efcffULL, 0x0000000113197824ULL, 0x000fe200000e0619ULL,
0x000000491a437212ULL, 0x000fe200078efcffULL, 0x0000001041157824ULL, 0x100fe200078e0214ULL,
0x00000057123c7210ULL, 0x000fe20007f1e0ffULL, 0x0000001017177824ULL, 0x100fe200078e0214ULL,
0x00000055123e7210ULL, 0x000fe20007f5e0ffULL, 0x0000001059417824ULL, 0x000fe200078e0214ULL,
0x00000043121a7210ULL, 0x000fe20007f7e0ffULL, 0x00000001133d7824ULL, 0x040fe200000e063dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018157faeULL, 0x0003e2000b901c46ULL,
0x00000001133f7824ULL, 0x000fc400010e063fULL, 0x000000105b437824ULL, 0x000fe200078e0214ULL,
0x000000003c177faeULL, 0x0003e2000b901c46ULL, 0x00000001131b7824ULL, 0x000fc600018e061bULL,
0x000000003e417faeULL, 0x0003e8000b901c46ULL, 0x000000001a437faeULL, 0x0003e4000b901c46ULL,
0x0000000802147824ULL, 0x000fe400078e00ffULL, 0x00000001ff1a7424ULL, 0x002fc600078e00ffULL,
0xfffffff014147812ULL, 0x000fca00078ec0ffULL, 0x0000000814157c36ULL, 0x000fe20008000000ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x00000000150572caULL, 0x000fda00000e0000ULL,
0x000176a805057890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0176a81a151479a7ULL, 0x0002e4000850003fULL,
0x0176281a0a1a79a7ULL, 0x0022a4000850003fULL, 0x0000000000187805ULL, 0x000fce0000015200ULL,
0x0176281b0a0075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fce0000015200ULL,
0x0000003c183c7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e19ULL,
0x003d09003c00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403c00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff177819ULL, 0x000fc8000001143dULL, 0x0000003c17177211ULL, 0x000fca00078110ffULL,
0x000000ffff3c7224ULL, 0x000fca00000e063dULL, 0x0000000217177819ULL, 0x000fc8000000123cULL,
0x000000170000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x0176281b0a0075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000002002177824ULL, 0x000fe400078e00ffULL,
0x00000008ff187e24ULL, 0x000fc6000f8e00ffULL, 0xffffff8017177812ULL, 0x000fc800078ec0ffULL,
0x0000008018187810ULL, 0x000fc80007ffe017ULL, 0x000000184f187210ULL, 0x000fca0007ffe049ULL,
0x01700000181a7984ULL, 0x000ea80000000800ULL, 0x0172000018197984ULL, 0x0009220000000800ULL,
0x000000111a00720bULL, 0x004fda0003f1d000ULL, 0x0000000000177806ULL, 0x000fc800000e0100ULL,
0x0000ffff171b7812ULL, 0x000fe2000780c0ffULL, 0x00000001ff177424ULL, 0x000fd800078e00ffULL,
0x0000000400008947ULL, 0x01afea0003800000ULL, 0x000000014b177836ULL, 0x000fe20000000000ULL,
0x000000111a00720bULL, 0x000fc80003f14000ULL, 0x000000021700720cULL, 0x000fd20003f45270ULL,
0x00000000003c7806ULL, 0x000fc800000e0100ULL, 0x000000080218ac11ULL, 0x000fe4000f8e38ffULL,
0x000000111a17a209ULL, 0x000fe40007810000ULL, 0x000000184f3ea210ULL, 0x000fe40007ffe049ULL,
0x000099103c187816ULL, 0x000fc600000000ffULL, 0x017400173e00a388ULL, 0x0003e20000000800ULL,
0x000000ff1800720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x000000111a187209ULL, 0x000fe40007810000ULL, 0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff003cff7812ULL, 0x000fe2000784c0ffULL, 0x0000001118177221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b17177820ULL, 0x000fc80000410000ULL, 0x00000017003d7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff187819ULL, 0x000fca0000011603ULL,
0x00001f183d177589ULL, 0x006e6400000e0000ULL, 0x0000003817387220ULL, 0x042fe20000410000ULL,
0x0000003917397220ULL, 0x040fe20000410000ULL, 0x0000003417347220ULL, 0x040fe20000410000ULL,
0x0000003517357220ULL, 0x040fe20000410000ULL, 0x0000003017307220ULL, 0x040fe20000410000ULL,
0x0000003117317220ULL, 0x040fe20000410000ULL, 0x0000002c172c7220ULL, 0x040fe20000410000ULL,
0x0000002d172d7220ULL, 0x040fe20000410000ULL, 0x0000002817287220ULL, 0x040fe20000410000ULL,
0x0000002917297220ULL, 0x040fe20000410000ULL, 0x0000002417247220ULL, 0x040fe20000410000ULL,
0x0000002517257220ULL, 0x040fe20000410000ULL, 0x0000002017207220ULL, 0x040fe20000410000ULL,
0x0000002117217220ULL, 0x040fe20000410000ULL, 0x0000001c171c7220ULL, 0x040fe20000410000ULL,
0x0000001d171d7220ULL, 0x000fce0000410000ULL, 0x0000003d16167220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x0000000803187811ULL, 0x000fca00078ff0ffULL,
0x00001f183d177589ULL, 0x002e6400000e0000ULL, 0x0000003a173a7220ULL, 0x042fe20000410000ULL,
0x0000003b173b7220ULL, 0x040fe20000410000ULL, 0x0000003617367220ULL, 0x040fe20000410000ULL,
0x0000003717377220ULL, 0x040fe20000410000ULL, 0x0000003217327220ULL, 0x040fe20000410000ULL,
0x0000003317337220ULL, 0x040fe20000410000ULL, 0x0000002e172e7220ULL, 0x040fe20000410000ULL,
0x0000002f172f7220ULL, 0x040fe20000410000ULL, 0x0000002a172a7220ULL, 0x040fe20000410000ULL,
0x0000002b172b7220ULL, 0x040fe20000410000ULL, 0x0000002617267220ULL, 0x040fe20000410000ULL,
0x0000002717277220ULL, 0x040fe20000410000ULL, 0x0000002217227220ULL, 0x040fe20000410000ULL,
0x0000002317237220ULL, 0x040fe20000410000ULL, 0x0000001e171e7220ULL, 0x040fe20000410000ULL,
0x0000001f171f7220ULL, 0x000fce0000410000ULL, 0x0000ffff1bff7812ULL, 0x000fe2000780603cULL,
0x00000001ff177424ULL, 0x002fe200078e00ffULL, 0x000000111a117209ULL, 0x000fd60007810000ULL,
0x800000111a1a0221ULL, 0x000fe20000010000ULL, 0x00007610ff170816ULL, 0x000fc60000000017ULL,
0x3fb8aa3b1a1a0820ULL, 0x000fc80000410000ULL, 0x0000001a00090308ULL, 0x000e640000000800ULL,
0x0000000919190220ULL, 0x002fce0000410000ULL, 0x0000001619167221ULL, 0x000fe20000010000ULL,
0x0000000000187805ULL, 0x000fe20000015200ULL, 0x00000008021a7824ULL, 0x000fca00078e00ffULL,
0xfffffff01a1b7812ULL, 0x000fc800078ec0ffULL, 0x0176b0471b0075a7ULL, 0x000e620008000148ULL,
0x000000081b3f7c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff3c7224ULL, 0x000fce00078e00ffULL, 0x000000103c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fcc0000015200ULL,
0x0000001a183d7210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1b7824ULL, 0x000fe200000e0e19ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff1a7819ULL, 0x000fc8000001141bULL, 0x0000003d1a1a7211ULL, 0x000fca00078110ffULL,
0x000000ffff1b7224ULL, 0x000fca00000e061bULL, 0x000000021a1a7819ULL, 0x000fc8000000121bULL,
0x0000001a0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013c3c7836ULL, 0x000fce0000000000ULL, 0x0176b0473f0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991017177816ULL, 0x000fc800000000ffULL,
0x000000ff1700720cULL, 0x000fe20003f05270ULL, 0x0001400008177836ULL, 0x000fc80000000000ULL,
0x00000010063c7824ULL, 0x000fd000078e0217ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff057819ULL, 0x000fe40000011603ULL, 0x00000009ff04723eULL, 0x000fc600000000ffULL,
0x0000000805197836ULL, 0x000fe20000000000ULL, 0x0000541004187816ULL, 0x000fca0000000004ULL,
0x00001f0518057589ULL, 0x0002a800000e0000ULL, 0x00001f1918047589ULL, 0x0002e400000e0000ULL,
0x011800004518783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000518187232ULL, 0x08cfe40000000000ULL, 0x000000051a1a7232ULL, 0x000fe40000000000ULL,
0x0000000419197232ULL, 0x080fe40000000000ULL, 0x000000041b1b7232ULL, 0x000fce0000000000ULL,
0x0000001000407824ULL, 0x000fe200078e0217ULL, 0x000000003c3c783bULL, 0x000f2a0000004200ULL,
0x000000004040783bULL, 0x000f620000004200ULL, 0x00000010ff687819ULL, 0x010fe4000001163cULL,
0x00000010ff697819ULL, 0x000fe4000001163dULL, 0x00000010ff607819ULL, 0x000fc4000001163eULL,
0x000000ff3d667812ULL, 0x040fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe4000001163dULL,
0x0000ffff3e647812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3d3d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x022fe40000011640ULL, 0x000000ff40567812ULL, 0x000fc400078ec0ffULL,
0x00000018ff477819ULL, 0x000fe40000011640ULL, 0x0000ffff405b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3c657812ULL, 0x000fe400078ec0ffULL, 0x00000010ff637819ULL, 0x000fe4000001163fULL,
0x00000010ff5f7819ULL, 0x000fe40000011641ULL, 0x000000ff41557812ULL, 0x000fc400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011641ULL, 0x0000ffff41587812ULL, 0x000fe400078ec0ffULL,
0x000000ff68687812ULL, 0x000fe400078ec0ffULL, 0x000000ff69697812ULL, 0x000fe400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe4000001163cULL, 0x0000ffff3c677812ULL, 0x000fc400078ec0ffULL,
0x000000ff42417812ULL, 0x000fe400078ec0ffULL, 0x000000ff60607812ULL, 0x000fe400078ec0ffULL,
0x000000ff3f5c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff597819ULL, 0x000fe4000001163fULL,
0x0000ffff3f3c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff436a7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff6b7819ULL, 0x000fe40000011664ULL, 0x00000010ff547819ULL, 0x100fe40000011643ULL,
0x00000018ff3f7819ULL, 0x000fe40000011643ULL, 0x0000ffff43467812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3d7819ULL, 0x000fe4000001163dULL, 0x00000065ff65723eULL, 0x000fc400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000040ff43723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x000000ff636c7812ULL, 0x000fe400078ec0ffULL, 0x00000041ff40723eULL, 0x000fc400020006ffULL,
0x00000060ff63723eULL, 0x000fe400020006ffULL, 0x0000006aff41723eULL, 0x000fe400020006ffULL,
0x0000006bff60723eULL, 0x000fe400020006ffULL, 0x0000003dff6a723eULL, 0x000fe400020006ffULL,
0x00000008ff6b7819ULL, 0x000fe4000001163cULL, 0x00000008ff677819ULL, 0x000fc40000011667ULL,
0x00005410653c7816ULL, 0x000fe40000000068ULL, 0x00005410663d7816ULL, 0x000fe40000000069ULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x0000003c1838723cULL, 0x008fe20000001838ULL,
0x000000ff3e5d7812ULL, 0x000fc400078ec0ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00005410673c7816ULL, 0x000fe40000000061ULL,
0x000054106a3d7816ULL, 0x000fe40000000062ULL, 0x0000006cff64723eULL, 0x000fe400020006ffULL,
0x00000018ff5a7819ULL, 0x000fc4000001163eULL, 0x00000059ff59723eULL, 0x000fe200020006ffULL,
0x0000003c1834723cULL, 0x000fe20000001834ULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000006bff65723eULL, 0x000fe400020006ffULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x000054105d3c7816ULL, 0x000fe40000000063ULL, 0x000054105c3d7816ULL, 0x000fc40000000064ULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x0000003c1830723cULL, 0x000fe20000001830ULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000010ff577819ULL, 0x000fc40000011642ULL, 0x00005410603c7816ULL, 0x000fe4000000005aULL,
0x00005410653d7816ULL, 0x000fe40000000059ULL, 0x00000018ff3e7819ULL, 0x000fe40000011642ULL,
0x00000008ff587819ULL, 0x000fe40000011658ULL, 0x0000ffff42427812ULL, 0x000fe200078ec0ffULL,
0x0000003c182c723cULL, 0x000fe2000000182cULL, 0x00000008ff5b7819ULL, 0x000fc4000001165bULL,
0x000000ff57577812ULL, 0x000fe400078ec0ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00005410563c7816ULL, 0x000fe4000000005eULL, 0x00005410553d7816ULL, 0x000fe4000000005fULL,
0x000000ff54547812ULL, 0x000fe400078ec0ffULL, 0x00000008ff427819ULL, 0x000fc40000011642ULL,
0x00000008ff467819ULL, 0x000fe20000011646ULL, 0x0000003c1828723cULL, 0x000fe20000001828ULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x00005410583d7816ULL, 0x000fc40000000043ULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000046ff43723eULL, 0x000fe400020006ffULL, 0x000054105b3c7816ULL, 0x000fe40000000047ULL,
0x0000541040407816ULL, 0x000fc40000000057ULL, 0x0000541041417816ULL, 0x000fe40000000054ULL,
0x0000541042427816ULL, 0x000fe2000000003eULL, 0x0000003c1824723cULL, 0x000fe20000001824ULL,
0x0000541043437816ULL, 0x000fca000000003fULL, 0x000000401820723cULL, 0x000fe20000001820ULL,
0x000000100f3c7824ULL, 0x000fca00078e0217ULL, 0x000000421818723cULL, 0x000fe2000000181cULL,
0x01180000441c783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x000000051c1c7232ULL, 0x08cfe40000000000ULL,
0x000000051e1e7232ULL, 0x000fe40000000000ULL, 0x000000041d1d7232ULL, 0x080fe40000000000ULL,
0x000000041f1f7232ULL, 0x000fce0000000000ULL, 0x0000001010407824ULL, 0x000fe200078e0217ULL,
0x000000003c3c783bULL, 0x000f2a0000004200ULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x00000010ff5c7819ULL, 0x110fe4000001163eULL, 0x000000ff3e5b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff577819ULL, 0x000fc4000001163eULL, 0x0000ffff3e5d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3e7819ULL, 0x022fe40000011640ULL, 0x00000010ff687819ULL, 0x100fe4000001163cULL,
0x000000ff3c647812ULL, 0x040fe400078ec0ffULL, 0x00000018ff607819ULL, 0x000fe4000001163cULL,
0x0000ffff3c667812ULL, 0x000fc400078ec0ffULL, 0x00000018ff697819ULL, 0x000fe40000011642ULL,
0x0000ffff3d657812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3c7819ULL, 0x000fe40000011640ULL,
0x000000ff40547812ULL, 0x040fe400078ec0ffULL, 0x0000ffff405e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff597819ULL, 0x000fc40000011642ULL, 0x000000ff42407812ULL, 0x040fe400078ec0ffULL,
0x0000ffff42447812ULL, 0x000fe400078ec0ffULL, 0x00000010ff617819ULL, 0x100fe4000001163fULL,
0x000000ff3f5a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff567819ULL, 0x000fe4000001163fULL,
0x0000ffff3f627812ULL, 0x000fc400078ec0ffULL, 0x0000003eff42723eULL, 0x000fe400020006ffULL,
0x00000010ff677819ULL, 0x000fe4000001163dULL, 0x00000018ff3f7819ULL, 0x000fe40000011641ULL,
0x00000069ff3e723eULL, 0x000fe400020006ffULL, 0x00000008ff667819ULL, 0x000fe40000011666ULL,
0x000000ff3d637812ULL, 0x000fc400078ec0ffULL, 0x00000018ff5f7819ULL, 0x000fe4000001163dULL,
0x00000018ff6a7819ULL, 0x000fe40000011643ULL, 0x00000008ff697819ULL, 0x000fe40000011665ULL,
0x00000010ff3d7819ULL, 0x000fe40000011641ULL, 0x000000ff41467812ULL, 0x040fe400078ec0ffULL,
0x0000ffff41587812ULL, 0x000fc400078ec0ffULL, 0x00000010ff557819ULL, 0x000fe40000011643ULL,
0x000000ff43417812ULL, 0x040fe400078ec0ffULL, 0x0000ffff43477812ULL, 0x000fe400078ec0ffULL,
0x0000003fff43723eULL, 0x000fe400020006ffULL, 0x000000ff68687812ULL, 0x000fe400078ec0ffULL,
0x000000ff67677812ULL, 0x000fc400078ec0ffULL, 0x00000066ff65723eULL, 0x000fe400020006ffULL,
0x0000006aff3f723eULL, 0x000fe400020006ffULL, 0x00000069ff66723eULL, 0x000fe400020006ffULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff61697812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6a7819ULL, 0x000fc40000011662ULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000005cff61723eULL, 0x000fe400020006ffULL,
0x00000069ff62723eULL, 0x000fc400020006ffULL, 0x0000006aff5c723eULL, 0x000fe400020006ffULL,
0x000000ff3c697812ULL, 0x000fe400078ec0ffULL, 0x000000ff3d6a7812ULL, 0x000fe400078ec0ffULL,
0x00005410643c7816ULL, 0x000fe40000000068ULL, 0x00005410633d7816ULL, 0x000fe40000000067ULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x0000003c1c38723cULL, 0x008fe20000001838ULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000008ff5d7819ULL, 0x000fe4000001165dULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00005410653c7816ULL, 0x000fc40000000060ULL,
0x00005410663d7816ULL, 0x000fe4000000005fULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x0000003c1c34723cULL, 0x000fe20000001834ULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000069ff63723eULL, 0x000fc400020006ffULL, 0x0000006aff64723eULL, 0x000fe400020006ffULL,
0x000054105b3c7816ULL, 0x000fe40000000061ULL, 0x000054105a3d7816ULL, 0x000fe40000000062ULL,
0x00000008ff5e7819ULL, 0x000fe4000001165eULL, 0x00000008ff587819ULL, 0x000fe40000011658ULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x0000003c1c30723cULL, 0x000fe20000001830ULL,
0x00000058ff58723eULL, 0x000fc400020006ffULL, 0x000000ff59597812ULL, 0x000fe400078ec0ffULL,
0x000000ff55557812ULL, 0x000fe400078ec0ffULL, 0x000054105d3c7816ULL, 0x000fe40000000057ULL,
0x000054105c3d7816ULL, 0x000fe40000000056ULL, 0x00000008ff447819ULL, 0x000fe40000011644ULL,
0x00000008ff477819ULL, 0x000fc40000011647ULL, 0x000054105e427816ULL, 0x000fe20000000042ULL,
0x0000003c1c2c723cULL, 0x000fe2000000182cULL, 0x0000541058437816ULL, 0x000fe40000000043ULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x00005410543c7816ULL, 0x000fe20000000063ULL, 0x000000421c24723cULL, 0x000fe20000001824ULL,
0x00005410463d7816ULL, 0x000fc40000000064ULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000044ff44723eULL, 0x000fe200020006ffULL,
0x0000003c1c28723cULL, 0x000fe20000001828ULL, 0x00000047ff47723eULL, 0x000fe200020006ffULL,
0x00000001ff437424ULL, 0x000fe200078e00ffULL, 0x0000541040407816ULL, 0x000fe40000000059ULL,
0x0000541041417816ULL, 0x000fc40000000055ULL, 0x00000002023d7824ULL, 0x000fe200078e00ffULL,
0x000000084e3c7c11ULL, 0x000fe4000f8e18ffULL, 0x00005410443e7816ULL, 0x000fe4000000003eULL,
0x00005410473f7816ULL, 0x000fe2000000003fULL, 0x000000401c20723cULL, 0x000fe20000001820ULL,
0xfffffff83d427812ULL, 0x000fe400078ec0ffULL, 0x0176c8433c3c79a7ULL, 0x0002e6000850003fULL,
0x0000003e1c18723cULL, 0x000fe20000001818ULL, 0x0176904342ff79a7ULL, 0x0003de0008500008ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000000001c7805ULL, 0x000fce0000015200ULL,
0x0000003d0b0075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fce0000015200ULL,
0x0000001e1c3f7210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x0000003f1e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x0000003d0b0075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x000001000c1c7824ULL, 0x000fc800078e0253ULL,
0x000000c01c1e7836ULL, 0x000fca0000000000ULL, 0x000000601e1d7812ULL, 0x000fca00078ec0ffULL,
0x00000001483d7824ULL, 0x000fe200078e021dULL, 0x0000000000fc9947ULL, 0x000fec0003800000ULL,
0x00000400011f7983ULL, 0x000ee40000100800ULL, 0x0000001e1f1d7248ULL, 0x008fe20007fe0000ULL,
0x00000010021f7824ULL, 0x000fc800078e00ffULL, 0x000000011d1d7824ULL, 0x000fe200078e0a1eULL,
0x000000101f3c7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff1e7819ULL, 0x000fe40000011603ULL,
0x0000001d3c1d7248ULL, 0x000fc60007fe0000ULL, 0x000000041e1f7836ULL, 0x000fe40000000000ULL,
0x000000011d1d7824ULL, 0x100fe400078e0a3cULL, 0x000000011e3e7824ULL, 0x140fe400078e023cULL,
0x000000011f407824ULL, 0x040fe200078e023cULL, 0x0000001d1f00720cULL, 0x080fe20003f66070ULL,
0x000000081e3f7836ULL, 0x000fe20000000000ULL, 0x0000001d1e00720cULL, 0x000fe20003f86070ULL,
0x000000013e1f7824ULL, 0x000fc400078e0203ULL, 0x000000083e427824ULL, 0x042fe200078e00ffULL,
0x0000001d3f00720cULL, 0x0c0fe20003f46070ULL, 0x0000000c1e417836ULL, 0x000fe40000000000ULL,
0x000000013e1e7824ULL, 0x000fe200078e023dULL, 0xfffffff842427812ULL, 0x000fe200078ee21fULL,
0x000000013f467824ULL, 0x000fe200078e023cULL, 0x0000001d4100720cULL, 0x000fe20003f06070ULL,
0x00000001403e7824ULL, 0x040fe400078e0203ULL, 0x00000008403f7824ULL, 0x000fc400078e00ffULL,
0x000000801e1e7825ULL, 0x000fc600078e00ffULL, 0xfffffff83f447812ULL, 0x000fe200078ee23eULL,
0x0000000140407824ULL, 0x100fe200078e023dULL, 0x000000491e1d7212ULL, 0x000fe200078efcffULL,
0x0000000141547824ULL, 0x000fe400078e023cULL, 0x00000001463c7824ULL, 0x040fe200078e023dULL,
0x0000001d121e7210ULL, 0x000fe20007fbe0ffULL, 0x00000001463f7824ULL, 0x000fe400078e0203ULL,
0x0000008040407825ULL, 0x000fc800078e00ffULL, 0x0000000846467824ULL, 0x000fe200078e00ffULL,
0x00000049401d7212ULL, 0x000fe200078efcffULL, 0x00000001543e7824ULL, 0x000fe400078e023dULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0xfffffff846467812ULL, 0x000fc600078ee23fULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x000000493c437212ULL, 0x000fc600078efcffULL,
0x00000001131f7824ULL, 0x040fe200028e061fULL, 0x0000001d12407210ULL, 0x000fe20007fbe0ffULL,
0x0000000154477824ULL, 0x000fe200078e0203ULL, 0x000000493e1d7212ULL, 0x000fe200078efcffULL,
0x00000008543e7824ULL, 0x000fe400078e00ffULL, 0x0000000113417824ULL, 0x040fe200028e0641ULL,
0x00000043123c7210ULL, 0x000fe20007fbe0ffULL, 0x0000001046437824ULL, 0x100fe200078e0217ULL,
0x0000001d12127210ULL, 0x000fe20007fde0ffULL, 0x00000010421d7824ULL, 0x000fe200078e0217ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee247ULL, 0x00000001133d7824ULL, 0x000fc400028e063dULL,
0x0000000113137824ULL, 0x000fe200030e063fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e1d7faeULL, 0x0003e2000e101c46ULL, 0x00000010443f7824ULL, 0x100fe400078e0217ULL,
0x000000103e477824ULL, 0x000fc600078e0217ULL, 0x00000000403f7faeULL, 0x0003e8000d901c46ULL,
0x000000003c437faeULL, 0x0003e8000d101c46ULL, 0x0000000012477faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x00000010021d7824ULL, 0x000fca00078e00ffULL,
0x000000101d1e7812ULL, 0x000fc800078ec0ffULL, 0x0000001e033c7211ULL, 0x000fca00078fe8ffULL,
0x000000043c3e7836ULL, 0x000fe40000000000ULL, 0x000000083c407836ULL, 0x000fe40000000000ULL,
0x000000013e1e7824ULL, 0x140fe400078e0203ULL, 0x000000083e3f7824ULL, 0x000fe400078e00ffULL,
0x00000001401f7824ULL, 0x040fe400078e0203ULL, 0x0000000840467824ULL, 0x000fe200078e00ffULL,
0xfffffff83f447812ULL, 0x000fe200078ee21eULL, 0x000000013c1e7824ULL, 0x000fc400078e023dULL,
0x000000013c1d7824ULL, 0x040fe200078e0203ULL, 0xfffffff846467812ULL, 0x000fe200078ee21fULL,
0x000000083c427824ULL, 0x002fe400078e00ffULL, 0x0000000c3c547836ULL, 0x000fe40000000000ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fc600078ee21dULL,
0x000000013e3c7824ULL, 0x100fe200078e023dULL, 0x000000491e1d7212ULL, 0x000fe200078efcffULL,
0x00000001403e7824ULL, 0x100fe400078e023dULL, 0x0000000154407824ULL, 0x040fe200078e023dULL,
0x0000001d121e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000154437824ULL, 0x040fe400078e0203ULL,
0x0000000854547824ULL, 0x000fe400078e00ffULL, 0x000000803c3c7825ULL, 0x000fc600078e00ffULL,
0xfffffff854547812ULL, 0x000fe200078ee243ULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x000000493c477212ULL, 0x000fc600078efcffULL, 0x0000008040407825ULL, 0x000fe200078e00ffULL,
0x000000493e437212ULL, 0x080fe400078efcffULL, 0x00000047123c7210ULL, 0x000fe20007f5e0ffULL,
0x00000001131f7824ULL, 0x040fe200000e061fULL, 0x00000049401d7212ULL, 0x000fe200078efcffULL,
0x0000001054477824ULL, 0x000fe200078e0217ULL, 0x00000043123e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001133d7824ULL, 0x000fe200010e063dULL, 0x0000001d12127210ULL, 0x000fe20007f7e0ffULL,
0x00000010421d7824ULL, 0x000fc400078e0217ULL, 0x00000001133f7824ULL, 0x040fe400000e063fULL,
0x0000000113137824ULL, 0x000fe200018e0641ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e1d7faeULL, 0x0003e2000b901c46ULL, 0x0000001044417824ULL, 0x100fe400078e0217ULL,
0x0000001046437824ULL, 0x000fc600078e0217ULL, 0x000000003c417faeULL, 0x0003e8000b901c46ULL,
0x000000003e437faeULL, 0x0003e8000b901c46ULL, 0x0000000012477faeULL, 0x0003e4000b901c46ULL,
0x00000c0001127983ULL, 0x002ee20000100800ULL, 0x000000020e0e7836ULL, 0x000fe20000000000ULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x00000001ff3c7424ULL, 0x000fe200078e00ffULL,
0x000000120e00720cULL, 0x008fe20003f06070ULL, 0xffffffffff127424ULL, 0x000fd800078e00ffULL,
0x00009200ff1e8b82ULL, 0x000e620000000a00ULL, 0x000000010e138824ULL, 0x000fc800078e024aULL,
0x00000004131e8825ULL, 0x002fca00078e001eULL, 0x000000061e128981ULL, 0x000322000c1e1900ULL,
0x0000000802137824ULL, 0x000fca00078e00ffULL, 0xfffffff013137812ULL, 0x000fca00078ec0ffULL,
0x000000014c137824ULL, 0x000fe200078e0213ULL, 0x0000000000007918ULL, 0x002fcc0000000000ULL,
0x0000083c131e79a7ULL, 0x0002e4000850003fULL, 0x0176483c0a3c79a7ULL, 0x0022a4000850003fULL,
0x00000000003e7805ULL, 0x000fce0000015200ULL, 0x0176483d0a0075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000407805ULL, 0x000fce0000015200ULL, 0x000000403e407210ULL, 0x000fca0007f1e1ffULL,
0x0000000141417824ULL, 0x000fe200000e0e3fULL, 0x003d09004000780cULL, 0x000fc80003f06070ULL,
0x000000ff4100720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404000780cULL, 0x000fc80003f06070ULL, 0x000000ff4100720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011441ULL,
0x0000004013137211ULL, 0x000fca00078110ffULL, 0x000000ffff407224ULL, 0x000fca00000e0641ULL,
0x0000000213137819ULL, 0x000fc80000001240ULL, 0x000000130000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x0176483d0a0075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x00000020020a7824ULL, 0x002fe400078e00ffULL, 0x00000008ff137e24ULL, 0x000fe4000f8e00ffULL,
0x00000001ff407424ULL, 0x000fe200078e00ffULL, 0xffffff800a0a7812ULL, 0x000fc800078ec0ffULL,
0x00000100130a7810ULL, 0x000fc80007ffe00aULL, 0x0000000a4f137210ULL, 0x000fca0007ffe049ULL,
0x01700000133c7984ULL, 0x000e680000000800ULL, 0x01720000131d7984ULL, 0x0004a20000000800ULL,
0x000000113c00720bULL, 0x002fda0003f1d000ULL, 0x00000000000a7806ULL, 0x000fc800000e0100ULL,
0x0000ffff0a3d7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff0a7224ULL, 0x000fd800078e0011ULL,
0x0000000400008947ULL, 0x00cfea0003800000ULL, 0x000000024b137836ULL, 0x000fe20000000000ULL,
0x000000113c00720bULL, 0x000fc80003f14000ULL, 0x000000021300720cULL, 0x000fda0003f45270ULL,
0x00000008023eac11ULL, 0x000fe4000f8e38ffULL, 0x000000113c0aa209ULL, 0x000fe40007810000ULL,
0x0000003e4f3fa210ULL, 0x000fe40007ffe049ULL, 0x00000000003e7806ULL, 0x000fc600000e0100ULL,
0x0174000a3f00a388ULL, 0x0003e20000000800ULL, 0x000099103e137816ULL, 0x000fc800000000ffULL,
0x000000ff1300720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x000000113c0a7209ULL, 0x000fe40007810000ULL, 0x000000ff3eff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff003eff7812ULL, 0x000fe2000784c0ffULL, 0x000000110a0a7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL, 0x0000000a00137308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff0a7819ULL, 0x002fcc0000011603ULL,
0x00001f0a130a7589ULL, 0x004e6400000e0000ULL, 0x000000380a387220ULL, 0x042fe20000410000ULL,
0x000000390a397220ULL, 0x040fe20000410000ULL, 0x000000340a347220ULL, 0x040fe20000410000ULL,
0x000000350a357220ULL, 0x040fe20000410000ULL, 0x000000300a307220ULL, 0x040fe20000410000ULL,
0x000000310a317220ULL, 0x040fe20000410000ULL, 0x0000002c0a2c7220ULL, 0x040fe20000410000ULL,
0x0000002d0a2d7220ULL, 0x040fe20000410000ULL, 0x000000280a287220ULL, 0x040fe20000410000ULL,
0x000000290a297220ULL, 0x040fe20000410000ULL, 0x000000240a247220ULL, 0x040fe20000410000ULL,
0x000000250a257220ULL, 0x040fe20000410000ULL, 0x000000200a207220ULL, 0x040fe20000410000ULL,
0x000000210a217220ULL, 0x040fe20000410000ULL, 0x000000180a187220ULL, 0x040fe20000410000ULL,
0x000000190a197220ULL, 0x000fce0000410000ULL, 0x0000001316167220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x00000008030a7811ULL, 0x002fcc00078ff0ffULL,
0x00001f0a130a7589ULL, 0x000e6400000e0000ULL, 0x0000003a0a3a7220ULL, 0x042fe20000410000ULL,
0x0000003b0a3b7220ULL, 0x040fe20000410000ULL, 0x000000360a367220ULL, 0x040fe20000410000ULL,
0x000000370a377220ULL, 0x040fe20000410000ULL, 0x000000320a327220ULL, 0x040fe20000410000ULL,
0x000000330a337220ULL, 0x040fe20000410000ULL, 0x0000002e0a2e7220ULL, 0x040fe20000410000ULL,
0x0000002f0a2f7220ULL, 0x040fe20000410000ULL, 0x0000002a0a2a7220ULL, 0x040fe20000410000ULL,
0x0000002b0a2b7220ULL, 0x040fe20000410000ULL, 0x000000260a267220ULL, 0x040fe20000410000ULL,
0x000000270a277220ULL, 0x040fe20000410000ULL, 0x000000220a227220ULL, 0x040fe20000410000ULL,
0x000000230a237220ULL, 0x040fe20000410000ULL, 0x0000001a0a1a7220ULL, 0x040fe20000410000ULL,
0x0000001b0a1b7220ULL, 0x000fce0000410000ULL, 0x0000ffff3dff7812ULL, 0x000fe2000780603eULL,
0x00000001ff407424ULL, 0x000fe200078e00ffULL, 0x000000113c0a7209ULL, 0x002fd60007810000ULL,
0x8000000a3c3c0221ULL, 0x000fe20000010000ULL, 0x00007610ff400816ULL, 0x000fc60000000040ULL,
0x3fb8aa3b3c3c0820ULL, 0x000fc80000410000ULL, 0x0000003c00090308ULL, 0x000e640000000800ULL,
0x000000091d1d0220ULL, 0x002fce0000410000ULL, 0x000000161d167221ULL, 0x000fce0000010000ULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x0000000802117824ULL, 0x000fca00078e00ffULL,
0xfffffff011117812ULL, 0x000fc800078ec0ffULL, 0x0176a815110075a7ULL, 0x000e620008000148ULL,
0x0000000811137c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003e7805ULL, 0x000fce0000015200ULL,
0x0000003e3c3e7210ULL, 0x000fca0007f1e1ffULL, 0x000000013f3f7824ULL, 0x000fe200000e0e3dULL,
0x003d09003e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff117819ULL, 0x000fc8000001143fULL, 0x0000003e11117211ULL, 0x000fca00078110ffULL,
0x000000ffff3e7224ULL, 0x000fca00000e063fULL, 0x0000000211117819ULL, 0x000fc8000000123eULL,
0x000000110000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x0176a815130075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991040117816ULL, 0x000fe200000000ffULL,
0x0001300008087836ULL, 0x000fc60000000000ULL, 0x000000ff1100720cULL, 0x000fe20003f05270ULL,
0x00000010063c7824ULL, 0x000fd800078e0208ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff057819ULL, 0x000fe40000011603ULL, 0x00000009ff04723eULL, 0x000fc600000000ffULL,
0x0000000805117836ULL, 0x000fe20000000000ULL, 0x0000541004067816ULL, 0x000fca0000000004ULL,
0x00001f0506057589ULL, 0x0002a800000e0000ULL, 0x00001f1106047589ULL, 0x0002e400000e0000ULL,
0x012000004544783bULL, 0x000e620000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000544447232ULL, 0x086fe40000000000ULL, 0x0000000546467232ULL, 0x000fe40000000000ULL,
0x0000000445457232ULL, 0x088fe40000000000ULL, 0x0000000447477232ULL, 0x000fce0000000000ULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x0000001000407824ULL, 0x000fe200078e0208ULL,
0x0000000703007812ULL, 0x000fc800078ec0ffULL, 0x0000000800067812ULL, 0x002fe200078ef803ULL,
0x000000004040783bULL, 0x000e620000004200ULL, 0x0000000207007836ULL, 0x000fc60000000000ULL,
0x0000000806117824ULL, 0x000fca00078e00ffULL, 0xfffffff811007812ULL, 0x000fe400078ee200ULL,
0x00000010ff657819ULL, 0x028fe4000001163cULL, 0x0000ffff3c627812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x000fe4000001163dULL, 0x0000ffff3d637812ULL, 0x000fe400078ec0ffULL,
0x00000010ff157819ULL, 0x000fc4000001163eULL, 0x000000ff3c607812ULL, 0x000fe400078ec0ffULL,
0x000000ff3d617812ULL, 0x000fe400078ec0ffULL, 0x000000ff65657812ULL, 0x000fe400078ec0ffULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x00000008ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff5e7819ULL, 0x000fc4000001163fULL, 0x0000ffff3f5f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff147819ULL, 0x002fe40000011640ULL, 0x00000008ff667819ULL, 0x000fe40000011663ULL,
0x000000ff15157812ULL, 0x000fe400078ec0ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fc400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000062ff63723eULL, 0x000fe400020006ffULL,
0x000000ff5e627812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5e7819ULL, 0x000fe4000001165fULL,
0x00000015ff5f723eULL, 0x000fc400020006ffULL, 0x000000ff14677812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fe4000001163cULL, 0x00000018ff5c7819ULL, 0x000fe4000001163dULL,
0x0000541060147816ULL, 0x000fe40000000065ULL, 0x0000541061157816ULL, 0x000fe40000000064ULL,
0x0000005bff5b723eULL, 0x000fc400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x000000144438723cULL, 0x000fe20000001838ULL,
0x000000ff3e587812ULL, 0x040fe400078ec0ffULL, 0x000000ff3f577812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3e5d7812ULL, 0x000fe400078ec0ffULL, 0x0000541063147816ULL, 0x000fc4000000005bULL,
0x0000541066157816ULL, 0x000fe4000000005cULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x000000144434723cULL, 0x000fe20000001834ULL, 0x00000018ff557819ULL, 0x000fe4000001163eULL,
0x00000018ff547819ULL, 0x000fc4000001163fULL, 0x00000008ff5d7819ULL, 0x000fe4000001165dULL,
0x0000541058147816ULL, 0x000fe4000000005fULL, 0x0000541057157816ULL, 0x000fe40000000062ULL,
0x00000010ff5a7819ULL, 0x000fe40000011641ULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x000000144430723cULL, 0x000fe20000001830ULL,
0x0000005dff5d723eULL, 0x000fc400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x000000ff403f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff40597812ULL, 0x000fe400078ec0ffULL,
0x000000ff413e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff41567812ULL, 0x000fe400078ec0ffULL,
0x000000ff5a5a7812ULL, 0x000fc400078ec0ffULL, 0x000054105d147816ULL, 0x000fe40000000055ULL,
0x000054105e157816ULL, 0x000fe20000000054ULL, 0x0000020002547824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe40000011640ULL, 0x00000018ff3d7819ULL, 0x000fe40000011641ULL,
0x0000003fff3f723eULL, 0x000fe200020006ffULL, 0x00000014442c723cULL, 0x000fe2000000182cULL,
0x0000003eff3e723eULL, 0x000fc400020006ffULL, 0x00000067ff60723eULL, 0x000fe400020006ffULL,
0x00000008ff597819ULL, 0x000fe40000011659ULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000008ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff407819ULL, 0x000fe40000011642ULL,
0x000000ff42137812ULL, 0x000fc400078ec0ffULL, 0x00000018ff067819ULL, 0x000fe40000011642ULL,
0x00000010ff417819ULL, 0x100fe40000011643ULL, 0x000000ff431d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff117819ULL, 0x000fe40000011643ULL, 0x0000ffff42427812ULL, 0x000fe400078ec0ffULL,
0x0000ffff43437812ULL, 0x000fc400078ec0ffULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x000054103f147816ULL, 0x000fe40000000060ULL,
0x000054103e157816ULL, 0x000fc4000000005aULL, 0x000000ff40407812ULL, 0x000fe400078ec0ffULL,
0x000000ff41417812ULL, 0x000fe400078ec0ffULL, 0xfffff80054547812ULL, 0x000fe200078ec0ffULL,
0x000000144428723cULL, 0x000fe20000001828ULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000008ff437819ULL, 0x000fe40000011643ULL, 0x00005410593c7816ULL, 0x000fc4000000003cULL,
0x00005410563d7816ULL, 0x000fe2000000003dULL, 0x0000000854157c36ULL, 0x000fe20008000000ULL,
0x00000013ff13723eULL, 0x000fe400020006ffULL, 0x0000001dff1d723eULL, 0x000fe400020006ffULL,
0x00000006ff06723eULL, 0x000fe200020006ffULL, 0x0000003c4424723cULL, 0x000fe20000001824ULL,
0x00000011ff11723eULL, 0x000fe400020006ffULL, 0x00000040ff40723eULL, 0x000fc400020006ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe200020006ffULL,
0x00000010003c7824ULL, 0x000fe200078e0215ULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x0000541013407816ULL, 0x000fe40000000040ULL, 0x000054101d417816ULL, 0x000fe20000000041ULL,
0x012000003c3c783bULL, 0x000e620000000200ULL, 0x0000541042427816ULL, 0x000fc40000000006ULL,
0x0000541043437816ULL, 0x000fc60000000011ULL, 0x000000404420723cULL, 0x000fec0000001820ULL,
0x000000424418723cULL, 0x000fe20000001818ULL, 0x000000100f407824ULL, 0x000fe200078e0208ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x000000053c3c7232ULL, 0x086fe40000000000ULL, 0x000000053e3e7232ULL, 0x000fe40000000000ULL,
0x000000043d3d7232ULL, 0x080fe40000000000ULL, 0x000000043f3f7232ULL, 0x000fce0000000000ULL,
0x0000001010447824ULL, 0x000fe200078e0208ULL, 0x000000004040783bULL, 0x000eea0000004200ULL,
0x000000004444783bULL, 0x000f620000004200ULL, 0x00000018ff067819ULL, 0x008fe40000011642ULL,
0x00000010ff617819ULL, 0x000fe40000011640ULL, 0x00000010ff627819ULL, 0x000fc40000011641ULL,
0x00000018ff637819ULL, 0x024fe40000011646ULL, 0x00000010ff5f7819ULL, 0x000fe40000011642ULL,
0x000000ff42577812ULL, 0x040fe400078ec0ffULL, 0x0000ffff425b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff107819ULL, 0x000fe40000011644ULL, 0x000000ff44427812ULL, 0x000fc400078ec0ffULL,
0x00000018ff157819ULL, 0x000fe40000011644ULL, 0x0000ffff44547812ULL, 0x000fe400078ec0ffULL,
0x00000006ff44723eULL, 0x000fe400020006ffULL, 0x00000063ff06723eULL, 0x000fe400020006ffULL,
0x000000ff405c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff415d7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff137819ULL, 0x000fe40000011643ULL, 0x000000ff61617812ULL, 0x000fe400078ec0ffULL,
0x000000ff62637812ULL, 0x000fe400078ec0ffULL, 0x0000ffff400f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff46147812ULL, 0x000fe400078ec0ffULL, 0x000000ff47657812ULL, 0x000fc400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe40000011647ULL, 0x00000010ff5e7819ULL, 0x000fe40000011643ULL,
0x000000ff43567812ULL, 0x040fe400078ec0ffULL, 0x0000ffff43117812ULL, 0x000fe400078ec0ffULL,
0x0000ffff41607812ULL, 0x000fe400078ec0ffULL, 0x0000005cff5c723eULL, 0x000fc400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000013ff43723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000014ff13723eULL, 0x000fe400020006ffULL, 0x00000008ff627819ULL, 0x000fc4000001160fULL,
0x00000065ff14723eULL, 0x000fe400020006ffULL, 0x00000064ff0f723eULL, 0x000fe400020006ffULL,
0x00000008ff647819ULL, 0x000fe40000011611ULL, 0x000000ff10657812ULL, 0x000fe400078ec0ffULL,
0x00000018ff587819ULL, 0x000fe40000011640ULL, 0x00000018ff597819ULL, 0x000fc40000011641ULL,
0x00000008ff607819ULL, 0x000fe40000011660ULL, 0x000054105c107816ULL, 0x000fe40000000061ULL,
0x000054105d117816ULL, 0x000fe40000000063ULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x000000103c38723cULL, 0x002fe20000001838ULL, 0x00000060ff60723eULL, 0x000fc400020006ffULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x0000541062107816ULL, 0x000fe40000000058ULL, 0x0000541060117816ULL, 0x000fe40000000059ULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000056ff56723eULL, 0x000fc400020006ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x000000103c34723cULL, 0x000fe20000001834ULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000008ff5b7819ULL, 0x000fe4000001165bULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x0000541057107816ULL, 0x000fe4000000005fULL,
0x0000541056117816ULL, 0x000fc4000000005eULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000010ff5a7819ULL, 0x000fe40000011645ULL, 0x000000ff45417812ULL, 0x000fe200078ec0ffULL,
0x000000103c30723cULL, 0x000fe20000001830ULL, 0x000000ff5a667812ULL, 0x000fe400078ec0ffULL,
0x00000010ff407819ULL, 0x000fe40000011647ULL, 0x00000018ff1d7819ULL, 0x000fc40000011645ULL,
0x000054105b107816ULL, 0x000fe40000000044ULL, 0x0000541064117816ULL, 0x000fe40000000043ULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x00000065ff5a723eULL, 0x000fe200020006ffULL, 0x000000103c2c723cULL, 0x000fe2000000182cULL,
0x00000066ff5c723eULL, 0x000fc400020006ffULL, 0x0000ffff45457812ULL, 0x000fe400078ec0ffULL,
0x0000541041417816ULL, 0x000fe4000000005cULL, 0x000000ff40107812ULL, 0x000fe400078ec0ffULL,
0x0000541042407816ULL, 0x000fe2000000005aULL, 0x00000001ff427424ULL, 0x000fe200078e00ffULL,
0x00000008ff547819ULL, 0x000fe40000011654ULL, 0x00000008ff457819ULL, 0x000fc40000011645ULL,
0x00000010ff557819ULL, 0x000fe20000011646ULL, 0x000000403c28723cULL, 0x000fe20000001828ULL,
0x00000015ff15723eULL, 0x000fe400020006ffULL, 0x0000001dff1d723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x00000010ff40723eULL, 0x000fc400020006ffULL, 0x0000ffff46467812ULL, 0x000fe400078ec0ffULL,
0x0000ffff47477812ULL, 0x000fe400078ec0ffULL, 0x000000ff55557812ULL, 0x000fe400078ec0ffULL,
0x0000541054107816ULL, 0x000fe40000000015ULL, 0x0000541045117816ULL, 0x000fe4000000001dULL,
0x00000055ff55723eULL, 0x000fc400020006ffULL, 0x00000008ff467819ULL, 0x000fe40000011646ULL,
0x00000008ff477819ULL, 0x000fe20000011647ULL, 0x000000103c24723cULL, 0x000fe20000001824ULL,
0x00000046ff46723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x000000084e1d7c11ULL, 0x000fe4000f8e18ffULL, 0x0000541013107816ULL, 0x000fc40000000055ULL,
0x0000541014117816ULL, 0x000fe40000000040ULL, 0x0000541046467816ULL, 0x000fe40000000006ULL,
0x0000541047477816ULL, 0x000fe4000000000fULL, 0x000000084b157c11ULL, 0x000fe2000f8e18ffULL,
0x000000103c20723cULL, 0x000fe20000001820ULL, 0x0176c8421d1079a7ULL, 0x0002aa000850003fULL,
0x000000463c18723cULL, 0x000fe20000001818ULL, 0x0176984215ff79a7ULL, 0x0003de000850003fULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0x000000110b0075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff137224ULL, 0x000fce00078e00ffULL, 0x000000101300780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fce0000015200ULL,
0x0000003c140f7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3c7824ULL, 0x000fe200000e0e15ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3c00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3c00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc8000001143cULL, 0x0000000f06067211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e063cULL, 0x0000000206067819ULL, 0x000fc8000000120fULL,
0x000000060000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000113137836ULL, 0x000fce0000000000ULL, 0x000000110b0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000800011d7983ULL, 0x000ea20000100800ULL,
0x000000010c067836ULL, 0x000fca0000000000ULL, 0x0000001d0600720cULL, 0x004fda0003f06070ULL,
0x0000000400ec0947ULL, 0x000fea0003800000ULL, 0x00009000ff107b82ULL, 0x000e620000000a00ULL,
0x000000020c067836ULL, 0x000fe20000000000ULL, 0x0000850000057ab9ULL, 0x000fe20000000800ULL,
0x000001001c0f7836ULL, 0x000fe40000000000ULL, 0x0000000512137c24ULL, 0x010fe2000f8e02ffULL,
0x0000001d0600720cULL, 0x000fe40003f06070ULL, 0x000000600f0b7812ULL, 0x000fe200078ec0ffULL,
0x0000008013137824ULL, 0x000fc800078e00ffULL, 0x00000001480b7824ULL, 0x000fe400078e020bULL,
0x0000008013107825ULL, 0x002fc800078e0010ULL, 0x0000000000fc8947ULL, 0x000fea0003800000ULL,
0x00000400011d7983ULL, 0x000ea20000100800ULL, 0x0000001002137824ULL, 0x000fca00078e00ffULL,
0x0000001013137812ULL, 0x000fe400078ec0ffULL, 0x0000000f1d067248ULL, 0x004fca0007fe0000ULL,
0x0000000106067824ULL, 0x000fe200078e0a0fULL, 0x00000003ff0f7819ULL, 0x000fc80000011603ULL,
0x0000000613067248ULL, 0x000fe20007fe0000ULL, 0x000000040f157836ULL, 0x000fe40000000000ULL,
0x000000080f1c7836ULL, 0x000fe40000000000ULL, 0x0000000106067824ULL, 0x100fe400078e0a13ULL,
0x0000000c0f1d7836ULL, 0x000fe40000000000ULL, 0x000000010f147824ULL, 0x140fe200078e0213ULL,
0x000000060f00720cULL, 0x080fe20003f86070ULL, 0x00000001153c7824ULL, 0x140fe200078e0213ULL,
0x000000061500720cULL, 0x080fe20003f66070ULL, 0x000000011c3e7824ULL, 0x140fe200078e0213ULL,
0x000000061c00720cULL, 0x080fe20003f46070ULL, 0x000000011d407824ULL, 0x040fe200078e0213ULL,
0x000000061d00720cULL, 0x000fe20003f06070ULL, 0x00000001141c7824ULL, 0x000fc400078e020bULL,
0x0000000114067824ULL, 0x140fe400078e0203ULL, 0x0000000814137824ULL, 0x000fe400078e00ffULL,
0x000000013c0f7824ULL, 0x140fe400078e0203ULL, 0x000000083c427824ULL, 0x000fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee206ULL, 0x000000013e147824ULL, 0x040fe400078e0203ULL,
0x000000083e437824ULL, 0x000fe200078e00ffULL, 0xfffffff842417812ULL, 0x000fe200078ee20fULL,
0x000000013c3c7824ULL, 0x000fc400078e020bULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fc600078ee214ULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x000000491c0f7212ULL, 0x000fc600078efcffULL, 0x000000013e147824ULL, 0x100fe200078e020bULL,
0x0000000f101c7210ULL, 0x000fe20007fbe0ffULL, 0x00000001403e7824ULL, 0x000fe200078e020bULL,
0x000000493c0b7212ULL, 0x000fe200078efcffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x0000000b103c7210ULL, 0x000fe20007fde0ffULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x00000049140f7212ULL, 0x000fc600078efcffULL, 0x0000000140067824ULL, 0x000fe200078e0203ULL,
0x000000493e0b7212ULL, 0x000fe200078efcffULL, 0x0000000840457824ULL, 0x000fe400078e00ffULL,
0x00000001111d7824ULL, 0x040fe200028e061dULL, 0x0000000f10147210ULL, 0x000fe20007fbe0ffULL,
0x00000001113d7824ULL, 0x000fe200030e063dULL, 0xfffffff845457812ULL, 0x000fe200078ee206ULL,
0x0000001013137824ULL, 0x100fe200078e0208ULL, 0x0000000b10107210ULL, 0x000fe20007fde0ffULL,
0x0000001041417824ULL, 0x000fc400078e0208ULL, 0x0000001043437824ULL, 0x100fe200078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c137faeULL, 0x0003e2000e101c46ULL,
0x0000000111157824ULL, 0x000fe400028e0615ULL, 0x0000001045457824ULL, 0x000fe200078e0208ULL,
0x000000003c417faeULL, 0x0003e2000d901c46ULL, 0x0000000111117824ULL, 0x000fc600030e063fULL,
0x0000000014437faeULL, 0x0003e8000d101c46ULL, 0x0000000010457faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001002067824ULL, 0x000fca00078e00ffULL,
0x0000001006067812ULL, 0x000fc800078ec0ffULL, 0x0000000603067211ULL, 0x000fca00078fe8ffULL,
0x0000000106147824ULL, 0x040fe400078e020bULL, 0x00000001060f7824ULL, 0x040fe400078e0203ULL,
0x00000008061c7824ULL, 0x000fe400078e00ffULL, 0x00000004063c7836ULL, 0x000fe40000000000ULL,
0x0000000c06427836ULL, 0x000fe20000000000ULL, 0xfffffff81c0f7812ULL, 0x000fe200078ee20fULL,
0x0000000806407836ULL, 0x000fc40000000000ULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x000000013c1c7824ULL, 0x040fe400078e020bULL, 0x000000013c067824ULL, 0x040fe400078e0203ULL,
0x000000083c3d7824ULL, 0x000fe400078e00ffULL, 0x00000001423e7824ULL, 0x040fe400078e020bULL,
0x00000001421d7824ULL, 0x000fe400078e0203ULL, 0x00000001403c7824ULL, 0x000fe200078e020bULL,
0x00000049140b7212ULL, 0x000fe200078efcffULL, 0x0000000842427824ULL, 0x000fc400078e00ffULL,
0x0000000140137824ULL, 0x040fe200078e0203ULL, 0x0000000b10147210ULL, 0x000fe20007f1e0ffULL,
0x0000000840407824ULL, 0x000fe200078e00ffULL, 0xfffffff842477812ULL, 0x000fe200078ee21dULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0xfffffff83d0b7812ULL, 0x000fe400078ee206ULL,
0xfffffff840457812ULL, 0x000fe200078ee213ULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x000000491c137212ULL, 0x000fc600078efcffULL, 0x000000803e3e7825ULL, 0x000fc800078e00ffULL,
0x000000100f417824ULL, 0x100fe200078e0208ULL, 0x000000493c0f7212ULL, 0x080fe200078efcffULL,
0x000000100b437824ULL, 0x100fe200078e0208ULL, 0x000000493e0b7212ULL, 0x000fe200078efcffULL,
0x0000000111157824ULL, 0x000fe200000e0615ULL, 0x00000013101c7210ULL, 0x000fe20007f1e0ffULL,
0x0000001045457824ULL, 0x100fe200078e0208ULL, 0x0000000f103c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001047477824ULL, 0x000fe200078e0208ULL, 0x0000000b10107210ULL, 0x000fe20007f7e0ffULL,
0x00000001111d7824ULL, 0x040fe200000e061dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014417faeULL, 0x0003e2000b901c46ULL, 0x00000001113d7824ULL, 0x000fc400010e063dULL,
0x0000000111117824ULL, 0x000fe200018e063fULL, 0x000000001c437faeULL, 0x0003e8000b901c46ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x0000000010477faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000084e107c11ULL, 0x002fe2000f8e20ffULL,
0x00000001ff1c7424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0176a81c101079a7ULL, 0x0002a4000850003fULL,
0x0176681c0d1c79a7ULL, 0x0022e4000850003fULL, 0x000000ffff067224ULL, 0x006fce00078e0011ULL,
0x0000000000107805ULL, 0x000fce0000015200ULL, 0x0176681d0d0075a7ULL, 0x008e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0f7224ULL, 0x000fce00078e00ffULL,
0x000000100f00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x00000014100b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000115147824ULL, 0x000fe200000e0e11ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011414ULL,
0x0000000b08087211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e0614ULL,
0x0000000208087819ULL, 0x000fc8000000120bULL, 0x000000080000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010f0f7836ULL, 0x000fce0000000000ULL,
0x0176681d0d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000084b087c11ULL, 0x000fe2000f8e38ffULL, 0x00000001ff137424ULL, 0x000fc600078e00ffULL,
0x0000018049087810ULL, 0x000fca0007ffe008ULL, 0x000000014f0b7824ULL, 0x000fca00078e0208ULL,
0x017000000b0f7984ULL, 0x000e680000000800ULL, 0x017200000b107984ULL, 0x0004a20000000800ULL,
0x0000000a0f00720bULL, 0x002fda0003f1d000ULL, 0x0000000000087806ULL, 0x000fc800000e0100ULL,
0x0000ffff08117812ULL, 0x000fe2000780c0ffULL, 0x000000ffff087224ULL, 0x000fd800078e000aULL,
0x0000000400008947ULL, 0x004fea0003800000ULL, 0x000000034b0b7836ULL, 0x000fe20000000000ULL,
0x0000000a0f00720bULL, 0x000fc80003f14000ULL, 0x000000020b00720cULL, 0x000fda0003f45270ULL,
0x000000080214ac11ULL, 0x000fe4000f8e38ffULL, 0x0000000a0f08a209ULL, 0x000fe40007810000ULL,
0x000000144f49a210ULL, 0x000fe40007ffe049ULL, 0x0000000000147806ULL, 0x000fc600000e0100ULL,
0x017400084900a388ULL, 0x0003e20000000800ULL, 0x00009910140b7816ULL, 0x000fc800000000ffULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000000a0f0b7209ULL, 0x000fe40007810000ULL, 0x000000ff14ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0014ff7812ULL, 0x000fe2000784c0ffULL, 0x0000000a0b087221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x00000008000b7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff087819ULL, 0x002fcc0000011603ULL,
0x00001f080b087589ULL, 0x004e6400000e0000ULL, 0x0000003808387220ULL, 0x042fe20000410000ULL,
0x0000003908397220ULL, 0x040fe20000410000ULL, 0x0000003408347220ULL, 0x040fe20000410000ULL,
0x0000003508357220ULL, 0x040fe20000410000ULL, 0x0000003008307220ULL, 0x040fe20000410000ULL,
0x0000003108317220ULL, 0x040fe20000410000ULL, 0x0000002c082c7220ULL, 0x040fe20000410000ULL,
0x0000002d082d7220ULL, 0x040fe20000410000ULL, 0x0000002808287220ULL, 0x040fe20000410000ULL,
0x0000002908297220ULL, 0x040fe20000410000ULL, 0x0000002408247220ULL, 0x040fe20000410000ULL,
0x0000002508257220ULL, 0x040fe20000410000ULL, 0x0000002008207220ULL, 0x040fe20000410000ULL,
0x0000002108217220ULL, 0x040fe20000410000ULL, 0x0000001808187220ULL, 0x040fe20000410000ULL,
0x0000001908197220ULL, 0x000fce0000410000ULL, 0x0000000b16167220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x0000000803087811ULL, 0x002fcc00078ff0ffULL,
0x00001f080b087589ULL, 0x000e6400000e0000ULL, 0x0000003a083a7220ULL, 0x042fe20000410000ULL,
0x0000003b083b7220ULL, 0x040fe20000410000ULL, 0x0000003608367220ULL, 0x040fe20000410000ULL,
0x0000003708377220ULL, 0x040fe20000410000ULL, 0x0000003208327220ULL, 0x040fe20000410000ULL,
0x0000003308337220ULL, 0x040fe20000410000ULL, 0x0000002e082e7220ULL, 0x040fe20000410000ULL,
0x0000002f082f7220ULL, 0x040fe20000410000ULL, 0x0000002a082a7220ULL, 0x040fe20000410000ULL,
0x0000002b082b7220ULL, 0x040fe20000410000ULL, 0x0000002608267220ULL, 0x040fe20000410000ULL,
0x0000002708277220ULL, 0x040fe20000410000ULL, 0x0000002208227220ULL, 0x040fe20000410000ULL,
0x0000002308237220ULL, 0x040fe20000410000ULL, 0x0000001a081a7220ULL, 0x040fe20000410000ULL,
0x0000001b081b7220ULL, 0x000fce0000410000ULL, 0x0000ffff11ff7812ULL, 0x000fe20007806014ULL,
0x00000001ff137424ULL, 0x000fe200078e00ffULL, 0x0000000a0f087209ULL, 0x002fd60007810000ULL,
0x800000080f0f0221ULL, 0x000fe20000010000ULL, 0x00007610ff130816ULL, 0x000fc60000000013ULL,
0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL, 0x0000000f00090308ULL, 0x000e640000000800ULL,
0x0000000910100220ULL, 0x002fce0000410000ULL, 0x0000001610167221ULL, 0x000fe20000010000ULL,
0x000000084e1d7c11ULL, 0x000fce000f8e20ffULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0176b01f1d0075a7ULL, 0x000e62000800017fULL, 0x00000004020f7824ULL, 0x000fca00078e00ffULL,
0x000000040f147812ULL, 0x000fe200078ec0ffULL, 0x00000004500f7824ULL, 0x000fc800078e00ffULL,
0x0000000214147836ULL, 0x000fe20000000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fce0000015200ULL,
0x000000100a157210ULL, 0x000fca0007f1e1ffULL, 0x0000000111117824ULL, 0x000fe200000e0e0bULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x000fc80000011411ULL, 0x0000001510107211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0611ULL, 0x0000000210107819ULL, 0x000fc80000001211ULL,
0x000000100000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x0176b01f1d0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000007030a7812ULL, 0x040fe400078ec0ffULL,
0x00000008030b7812ULL, 0x000fe400078ec0ffULL, 0x0000991013117816ULL, 0x000fe200000000ffULL,
0x000000034b137836ULL, 0x000fe20000000000ULL, 0x000000080a107812ULL, 0x000fe400078ef803ULL,
0x0000000f030f7211ULL, 0x000fe400078fe0ffULL, 0x0000000a0b407212ULL, 0x000fe200078efcffULL,
0x00000008103c7824ULL, 0x000fe200078e00ffULL, 0x000000ff1100720cULL, 0x000fc40003f05270ULL,
0x0000000813117c11ULL, 0x000fe2000f8e58ffULL, 0x0000000140107824ULL, 0x040fe200078e020fULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee207ULL, 0x0000000840157824ULL, 0x000fe200078e00ffULL,
0x0000001403077211ULL, 0x000fc600078fe0ffULL, 0x000000103c3c7824ULL, 0x000fe200078e0211ULL,
0xfffffff815107812ULL, 0x000fca00078ee210ULL, 0x0000001010107824ULL, 0x000fe200078e0217ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff147819ULL, 0x000fe40000011603ULL,
0x00000009ff04723eULL, 0x000fc600000000ffULL, 0x00000008141c7836ULL, 0x000fe20000000000ULL,
0x0000541004137816ULL, 0x000fca0000000004ULL, 0x00001f1413057589ULL, 0x0002a800000e0000ULL,
0x00001f1c13047589ULL, 0x0002e400000e0000ULL, 0x011000003c3c783bULL, 0x000e620000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x000000053c3c7232ULL, 0x086fe40000000000ULL,
0x000000053e3e7232ULL, 0x000fe40000000000ULL, 0x000000043d3d7232ULL, 0x088fe40000000000ULL,
0x000000043f3f7232ULL, 0x000fce0000000000ULL, 0x0000000140137824ULL, 0x042fe200078e0207ULL,
0x00000000101c783bULL, 0x000e620000004200ULL, 0x0000000840147824ULL, 0x000fe400078e00ffULL,
0x0000001000447824ULL, 0x000fc600078e0211ULL, 0xfffffff814147812ULL, 0x000fca00078ee213ULL,
0x0000001014147824ULL, 0x000fca00078e0217ULL, 0x000000001440783bULL, 0x000f620000004200ULL,
0x00000010ff5c7819ULL, 0x102fe4000001161eULL, 0x000000ff1e557812ULL, 0x040fe400078ec0ffULL,
0x00000018ff497819ULL, 0x000fe4000001161eULL, 0x0000ffff1e5a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff007819ULL, 0x000fe4000001161cULL, 0x00000010ff5f7819ULL, 0x000fc4000001161dULL,
0x000000ff1d597812ULL, 0x000fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe4000001161dULL,
0x00000018ff147819ULL, 0x028fe40000011640ULL, 0x00000018ff157819ULL, 0x000fe40000011641ULL,
0x000000ff425e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff43607812ULL, 0x000fc400078ec0ffULL,
0x0000ffff1d5d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5b7819ULL, 0x100fe4000001161fULL,
0x000000ff1f547812ULL, 0x040fe400078ec0ffULL, 0x00000018ff1e7819ULL, 0x000fe4000001161fULL,
0x0000ffff1f117812ULL, 0x000fe400078ec0ffULL, 0x00000010ff107819ULL, 0x000fc40000011640ULL,
0x000000ff40477812ULL, 0x040fe400078ec0ffULL, 0x0000ffff401d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4f7819ULL, 0x000fe40000011641ULL, 0x000000ff41467812ULL, 0x040fe400078ec0ffULL,
0x0000ffff411f7812ULL, 0x000fe400078ec0ffULL, 0x00000014ff40723eULL, 0x000fc400020006ffULL,
0x00000015ff41723eULL, 0x000fe400020006ffULL, 0x0000005eff14723eULL, 0x000fe400020006ffULL,
0x00000060ff15723eULL, 0x000fe400020006ffULL, 0x000000ff1c587812ULL, 0x000fe400078ec0ffULL,
0x000000ff005e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5f607812ULL, 0x000fc400078ec0ffULL,
0x0000ffff1c627812ULL, 0x000fe400078ec0ffULL, 0x00000018ff617819ULL, 0x000fe40000011642ULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fc400020006ffULL,
0x00000008ff5f7819ULL, 0x000fe40000011662ULL, 0x00000061ff00723eULL, 0x000fe400020006ffULL,
0x00000008ff617819ULL, 0x000fe40000011611ULL, 0x000000ff10627812ULL, 0x000fe400078ec0ffULL,
0x00000018ff567819ULL, 0x000fe4000001161cULL, 0x00000008ff5d7819ULL, 0x000fc4000001165dULL,
0x0000541058107816ULL, 0x000fe4000000005eULL, 0x0000541059117816ULL, 0x000fe40000000060ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x000000103c38723cULL, 0x000fe20000001838ULL,
0x0000005dff5d723eULL, 0x000fc400020006ffULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x000054105f107816ULL, 0x000fe40000000056ULL,
0x000054105d117816ULL, 0x000fe40000000057ULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fc400020006ffULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x000000103c34723cULL, 0x000fe20000001834ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000008ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff1c7819ULL, 0x000fe40000011642ULL,
0x0000541055107816ULL, 0x000fe4000000005cULL, 0x0000541054117816ULL, 0x000fc4000000005bULL,
0x00000010ff457819ULL, 0x100fe40000011643ULL, 0x00000018ff137819ULL, 0x000fe40000011643ULL,
0x0000ffff42427812ULL, 0x000fe200078ec0ffULL, 0x000000103c30723cULL, 0x000fe20000001830ULL,
0x0000ffff43437812ULL, 0x000fe400078ec0ffULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x0000001eff1e723eULL, 0x000fc400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x000000ff4f4f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff1d7819ULL, 0x000fe4000001161dULL, 0x00000008ff1f7819ULL, 0x000fe4000001161fULL,
0x000000ff1c1c7812ULL, 0x000fc400078ec0ffULL, 0x000054105a107816ULL, 0x000fe40000000049ULL,
0x0000541061117816ULL, 0x000fe4000000001eULL, 0x000000ff45457812ULL, 0x000fe400078ec0ffULL,
0x00000008ff427819ULL, 0x000fe40000011642ULL, 0x00000008ff437819ULL, 0x000fe20000011643ULL,
0x000000103c2c723cULL, 0x000fe2000000182cULL, 0x0000004fff56723eULL, 0x000fc400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000062ff58723eULL, 0x000fe400020006ffULL, 0x0000001dff4f723eULL, 0x000fe400020006ffULL,
0x0000001fff54723eULL, 0x000fe400020006ffULL, 0x0000001cff49723eULL, 0x000fc400020006ffULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x01100000441c783bULL, 0x0002e20000000200ULL,
0x00000013ff13723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x0000541047107816ULL, 0x000fe40000000058ULL,
0x0000541046117816ULL, 0x000fc40000000056ULL, 0x000054104f407816ULL, 0x000fe40000000040ULL,
0x0000541054417816ULL, 0x000fe40000000041ULL, 0x0000541014147816ULL, 0x000fe20000000049ULL,
0x000000103c28723cULL, 0x000fe20000001828ULL, 0x0000541015157816ULL, 0x000fe40000000045ULL,
0x0000541042427816ULL, 0x000fe40000000000ULL, 0x0000541043437816ULL, 0x000fe20000000013ULL,
0x000000403c24723cULL, 0x000fec0000001824ULL, 0x000000143c20723cULL, 0x000fec0000001820ULL,
0x000000423c18723cULL, 0x000fe20000001818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000100947ULL, 0x002fde0003800000ULL, 0x000000051c1c7232ULL, 0x08cfe40000000000ULL,
0x000000051e1e7232ULL, 0x000fe40000000000ULL, 0x000000041d1d7232ULL, 0x080fe40000000000ULL,
0x000000041f1f7232ULL, 0x000fce0000000000ULL, 0x000000100b0a7812ULL, 0x000fe200078efe0aULL,
0x000000010c0c7836ULL, 0x000fc80000000000ULL, 0x000000010a0f7824ULL, 0x040fe400078e020fULL,
0x000000080a007824ULL, 0x040fe400078e00ffULL, 0x000000010a077824ULL, 0x040fe400078e0207ULL,
0x000000080a0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff800007812ULL, 0x000fc800078ee20fULL,
0xfffffff80a0a7812ULL, 0x000fe200078ee207ULL, 0x0000001000007824ULL, 0x000fc800078e0217ULL,
0x000000100a0a7824ULL, 0x000fe200078e0217ULL, 0x00000000003c783bULL, 0x000e680000004200ULL,
0x000000000a40783bULL, 0x000f620000004200ULL, 0x000000ff3e007812ULL, 0x002fe400078ec0ffULL,
0x00000010ff077819ULL, 0x000fe4000001163cULL, 0x00000010ff567819ULL, 0x000fc4000001163dULL,
0x000000ff3d497812ULL, 0x040fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fe4000001163dULL,
0x0000ffff3d5c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff577819ULL, 0x028fe40000011642ULL,
0x00000010ff597819ULL, 0x100fe4000001163eULL, 0x00000018ff3d7819ULL, 0x000fc4000001163eULL,
0x0000ffff3e4f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5a7819ULL, 0x100fe4000001163fULL,
0x000000ff3f447812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001163fULL,
0x0000ffff3f547812ULL, 0x000fe400078ec0ffULL, 0x00000000ff3f723eULL, 0x000fc400020006ffULL,
0x000000ff3c0b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff07557812ULL, 0x000fe400078ec0ffULL,
0x00000057ff00723eULL, 0x000fe400020006ffULL, 0x000000ff56577812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3c5b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff0a7819ULL, 0x000fc40000011641ULL,
0x00000018ff587819ULL, 0x000fe40000011643ULL, 0x0000000bff0b723eULL, 0x000fe400020006ffULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000008ff567819ULL, 0x000fc4000001165bULL,
0x000000ff0a5b7812ULL, 0x000fe400078ec0ffULL, 0x00000058ff07723eULL, 0x000fe400020006ffULL,
0x000054100b0a7816ULL, 0x000fe40000000055ULL, 0x00000018ff457819ULL, 0x000fe4000001163cULL,
0x00000008ff587819ULL, 0x000fe4000001165cULL, 0x00005410490b7816ULL, 0x000fc40000000057ULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x0000000a1c38723cULL, 0x000fe20000001838ULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x000000ff59597812ULL, 0x000fe400078ec0ffULL,
0x000000ff5a5a7812ULL, 0x000fc400078ec0ffULL, 0x00005410560a7816ULL, 0x000fe40000000045ULL,
0x00005410580b7816ULL, 0x000fe40000000046ULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x0000000a1c34723cULL, 0x000fe20000001834ULL, 0x00000008ff4f7819ULL, 0x000fc4000001164fULL,
0x00000008ff547819ULL, 0x000fe40000011654ULL, 0x00000010ff477819ULL, 0x000fe40000011640ULL,
0x000054103f0a7816ULL, 0x000fe40000000059ULL, 0x00005410440b7816ULL, 0x000fe4000000005aULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x0000003eff3e723eULL, 0x000fc400020006ffULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x0000000a1c30723cULL, 0x000fe20000001830ULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000010ff157819ULL, 0x000fe40000011643ULL,
0x000000ff40147812ULL, 0x000fe400078ec0ffULL, 0x000000ff41177812ULL, 0x000fe400078ec0ffULL,
0x000000ff47477812ULL, 0x000fc400078ec0ffULL, 0x000054104f0a7816ULL, 0x000fe4000000003dULL,
0x00005410540b7816ULL, 0x000fe4000000003eULL, 0x000000ff15157812ULL, 0x000fe400078ec0ffULL,
0x00000014ff14723eULL, 0x000fe400020006ffULL, 0x00000017ff17723eULL, 0x000fe200020006ffULL,
0x0000000a1c2c723cULL, 0x000fe2000000182cULL, 0x00000047ff47723eULL, 0x000fc400020006ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000015ff3d723eULL, 0x000fe400020006ffULL,
0x0000541014147816ULL, 0x000fe20000000047ULL, 0x000000044e0a7836ULL, 0x000fe20000000000ULL,
0x0000541017157816ULL, 0x000fe4000000005bULL, 0x00000018ff117819ULL, 0x000fe40000011640ULL,
0x000000080a0a7c11ULL, 0x000fc4000f8e18ffULL, 0x00000018ff137819ULL, 0x000fe20000011641ULL,
0x000000141c28723cULL, 0x000fe20000001828ULL, 0x0000ffff40407812ULL, 0x000fe400078ec0ffULL,
0x0000ffff41417812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3c7819ULL, 0x000fe40000011642ULL,
0x00000001ff157424ULL, 0x000fe200078e00ffULL, 0x000000ff420f7812ULL, 0x040fe400078ec0ffULL,
0x000000ff43107812ULL, 0x000fe200078ec0ffULL, 0x0176a8150a0a79a7ULL, 0x000e62000850003fULL,
0x0000ffff42427812ULL, 0x000fc400078ec0ffULL, 0x0000ffff43437812ULL, 0x000fe400078ec0ffULL,
0x00000008ff407819ULL, 0x000fe40000011640ULL, 0x00000008ff417819ULL, 0x000fe40000011641ULL,
0x000000ff3c3c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000008ff437819ULL, 0x000fc40000011643ULL, 0x00000011ff11723eULL, 0x000fe400020006ffULL,
0x00000013ff13723eULL, 0x000fe400020006ffULL, 0x0000000fff0f723eULL, 0x000fe400020006ffULL,
0x00000010ff10723eULL, 0x000fe400020006ffULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fc400020006ffULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x0000541040407816ULL, 0x000fe40000000011ULL, 0x0000541041417816ULL, 0x000fe40000000013ULL,
0x000054100f3c7816ULL, 0x000fc4000000003cULL, 0x00005410103d7816ULL, 0x000fe4000000003dULL,
0x0000541042427816ULL, 0x000fe20000000000ULL, 0x000000401c24723cULL, 0x000fe20000001824ULL,
0x0000541043437816ULL, 0x000fe20000000007ULL, 0x000000ffff007224ULL, 0x002fe200078e000bULL,
0x000000084b0a7c11ULL, 0x000fc6000f8e18ffULL, 0x0000003c1c20723cULL, 0x000fe20000001820ULL,
0x0176a0150aff79a7ULL, 0x0003ea000850003fULL, 0x000000421c1c723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffff7000c09947ULL, 0x000fde000383ffffULL,
0x0000080001077983ULL, 0x004ea40000300800ULL, 0x000000ff0700720cULL, 0x004fda0003f05270ULL,
0x0000000000d48947ULL, 0x000fea0003800000ULL, 0x0180000016007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000ab0000047802ULL, 0x000fce0000000f00ULL, 0x0000008400407944ULL, 0x012fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000001600037308ULL, 0x000ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc80000000016ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009a00ff027b82ULL, 0x000f640000000a00ULL, 0x0000000602037981ULL, 0x028ee2000c1e9900ULL,
0x0000000000057919ULL, 0x000f640000000000ULL, 0x00000002ff077819ULL, 0x024fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x008fca0000410000ULL,
0x00001f0700047589ULL, 0x000ea800000e0000ULL, 0x00001f0500057589ULL, 0x000ee200000e0000ULL,
0x0000003804387220ULL, 0x044fe20000410000ULL, 0x0000003904397220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x000fe20000410000ULL,
0x0000003a053a7220ULL, 0x048fe20000410000ULL, 0x0000003b053b7220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x000000242524723eULL, 0x000fe400000000ffULL,
0x000000202120723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000323332723eULL, 0x000fc400000000ffULL, 0x0000002e2f19723eULL, 0x000fe400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x0000541032187816ULL, 0x140fe40000000019ULL,
0x0000763232197816ULL, 0x000fe40000000019ULL, 0x000000262715723eULL, 0x002fe400000000ffULL,
0x000000222322723eULL, 0x000fc400000000ffULL, 0x000000ff4e00720cULL, 0x000fe40003f05270ULL,
0x00000002ff057819ULL, 0x004fe40000011600ULL, 0x0000000200027812ULL, 0x040fe400078ec0ffULL,
0x0000000800077811ULL, 0x000fe200078ff0ffULL, 0x0000000805097824ULL, 0x040fe200078e00ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000000702037211ULL, 0x000fe200078ff8ffULL, 0x00000008070e7824ULL, 0x000fc400078e00ffULL,
0x0000000204027836ULL, 0x000fe40000000000ULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL, 0x0000000404067836ULL, 0x000fe20000000000ULL,
0x0000000850037c11ULL, 0x000fe4000f8e60ffULL, 0xfffffff809087812ULL, 0x000fe400078ee202ULL,
0xfffffff807027812ULL, 0x000fe200078ee204ULL, 0x0000000604077836ULL, 0x000fe20000000000ULL,
0xfffffff8090a7812ULL, 0x000fe200078ee206ULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0x000076322a097816ULL, 0x000fe20000000015ULL, 0x000008004e057824ULL, 0x000fe200078e0203ULL,
0xfffffff80c0c7812ULL, 0x000fc400078ee207ULL, 0x0000000804077812ULL, 0x000fe200078ec0ffULL,
0x0000001002067824ULL, 0x100fe200078e0205ULL, 0x000000383902723eULL, 0x000fe200000000ffULL,
0x000000100e0e7824ULL, 0x000fe200078e0205ULL, 0x000000343504723eULL, 0x000fe200000000ffULL,
0x0000000106067824ULL, 0x000fe400078e0207ULL, 0x0000001008087824ULL, 0x100fe200078e0205ULL,
0x0000541002107816ULL, 0x100fe20000000004ULL, 0x000000100a0a7824ULL, 0x100fe200078e0205ULL,
0x0000763202117816ULL, 0x000fe20000000004ULL, 0x000000100c0c7824ULL, 0x000fe200078e0205ULL,
0x000000303102723eULL, 0x000fe200000000ffULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x0000002c2d04723eULL, 0x000fe200000000ffULL, 0x0000001006007388ULL, 0x0003e20000000a00ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x000000282905723eULL, 0x000fe200000000ffULL,
0x00000001070a7824ULL, 0x000fc400078e020aULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x0000763202077816ULL, 0x140fe40000000004ULL, 0x0000541002067816ULL, 0x002fe40000000004ULL,
0x0000001c1d10723eULL, 0x000fe400000000ffULL, 0x0000003a3b02723eULL, 0x000fe200000000ffULL,
0x0000000608007388ULL, 0x0003e20000000a00ULL, 0x000000363704723eULL, 0x000fe400000000ffULL,
0x0000001e1f11723eULL, 0x000fc800000000ffULL, 0x00007632220f7816ULL, 0x000fe40000000011ULL,
0x0000541005067816ULL, 0x142fe40000000024ULL, 0x0000763205077816ULL, 0x000fca0000000024ULL,
0x000000060a007388ULL, 0x0003e40000000a00ULL, 0x0000541020067816ULL, 0x142fe40000000010ULL,
0x0000763220077816ULL, 0x000fca0000000010ULL, 0x000000060c007388ULL, 0x0003e40000000a00ULL,
0x0000541002067816ULL, 0x142fe40000000004ULL, 0x0000763202077816ULL, 0x000fe20000000004ULL,
0x0000000153027824ULL, 0x000fc800078e0200ULL, 0x000000060e007388ULL, 0x0003e20000000a00ULL,
0x0000001002027824ULL, 0x000fc600078e0203ULL, 0x0004001808007388ULL, 0x0005e20000000a00ULL,
0x00005410220e7816ULL, 0x002fe40000000011ULL, 0x000054102a087816ULL, 0x004fca0000000015ULL,
0x000400080a007388ULL, 0x000fe80000000a00ULL, 0x0004000e0c007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000002047984ULL, 0x000e680000000c00ULL,
0x0004000002147984ULL, 0x000ea80000000c00ULL, 0x0008000002107984ULL, 0x010ee80000000c00ULL,
0x000c000002187984ULL, 0x000f220000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x004fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x0000001307077230ULL, 0x008fe40000000000ULL,
0x0000001206067230ULL, 0x000fe40000000000ULL, 0x0000001105057230ULL, 0x000fe40000000000ULL,
0x0000001004047230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x010fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000402007388ULL, 0x0003e20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001402007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff067819ULL, 0x002fc80000011600ULL,
0x000000510600720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00001800013c7983ULL, 0x000ea20000100800ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x0000850000097ab9ULL, 0x000fe20000000800ULL, 0x0000000800087d06ULL, 0x000e620008209000ULL,
0x00000008ff0e7c12ULL, 0x000fe2000f8e33ffULL, 0x00008a0000047ab9ULL, 0x000fcc0000000a00ULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe08047836ULL, 0x002fcc0000000000ULL,
0x0000000400057305ULL, 0x0002e4000021f000ULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000ffff077224ULL, 0x008fc800078e0a05ULL, 0x0000000807077c24ULL, 0x000fc8000f8e02ffULL,
0x00000007050d7227ULL, 0x000fc800078e0004ULL, 0x0000000106047824ULL, 0x000fe400078e0200ULL,
0x000000013c027824ULL, 0x004fc800078e0206ULL, 0x000000020d077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x0000000805057c24ULL, 0x000fca000f8e0202ULL,
0x0000000805007c0cULL, 0x000fda000bf06070ULL, 0x8000000805050c36ULL, 0x000fe40008000000ULL,
0x0000000107070836ULL, 0x000fe20000000000ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x0000000805007c0cULL, 0x000fe4000bf26070ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fca00078ef800ULL, 0x0000001004067824ULL, 0x000fe400078e0203ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x0000000006087984ULL, 0x0002a40000000c00ULL,
0x000000070e047207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a04ULL,
0x0000000904057c24ULL, 0x000fe4000f8e024dULL, 0x0000000807027c24ULL, 0x000fe2000f8e0202ULL,
0x0000000700077812ULL, 0x000fc600078ec0ffULL, 0x0000000805057c24ULL, 0x000fe4000f8e0202ULL,
0x0000002000027836ULL, 0x000fe40000000000ULL, 0x0000000850077824ULL, 0x000fe200078e0207ULL,
0x0000000552057210ULL, 0x000fe40007f3e0ffULL, 0x00000003ff067819ULL, 0x002fc60000011602ULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f440cULL, 0x000000510600720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000013c047824ULL, 0x102fe400078e0206ULL,
0x0000000102067824ULL, 0x000fe400078e0206ULL, 0x000000040d077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x0000000805057c24ULL, 0x000fca000f8e0204ULL,
0x0000000805007c0cULL, 0x000fda000bf26070ULL, 0x8000000805051c36ULL, 0x000fe40008000000ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fe4000bf46070ULL,
0x0000000706057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805067812ULL, 0x000fca00078ef802ULL,
0x0000001006067824ULL, 0x000fe400078e0203ULL, 0x0000000107072836ULL, 0x000fc60000000000ULL,
0x0000000006087984ULL, 0x0002a40000000c00ULL, 0x000000070e0c7207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a0cULL, 0x000000090c057c24ULL, 0x000fe4000f8e024dULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x0000000702077812ULL, 0x000fe200078ec0ffULL,
0x0000004000027836ULL, 0x000fe40000000000ULL, 0x0000000805057c24ULL, 0x000fe4000f8e0204ULL,
0x0000000850077824ULL, 0x000fe200078e0207ULL, 0x00000003ff067819ULL, 0x002fc40000011602ULL,
0x0000000552057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f440cULL,
0x000000510600720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000013c047824ULL, 0x102fe400078e0206ULL, 0x0000000102067824ULL, 0x000fe400078e0206ULL,
0x000000040d077227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a07ULL,
0x0000006000007836ULL, 0x000fe40000000000ULL, 0x0000000805057c24ULL, 0x000fca000f8e0204ULL,
0x0000000805007c0cULL, 0x000fda000bf26070ULL, 0x8000000805051c36ULL, 0x000fe40008000000ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fe4000bf46070ULL,
0x0000000706057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805067812ULL, 0x000fca00078ef802ULL,
0x0000001006067824ULL, 0x000fe400078e0203ULL, 0x0000000107072836ULL, 0x000fc60000000000ULL,
0x0000000006087984ULL, 0x0002a40000000c00ULL, 0x000000070e0c7207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a0cULL, 0x000000090c057c24ULL, 0x000fe4000f8e024dULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x0000000702077812ULL, 0x000fe400078ec0ffULL,
0x00000003ff027819ULL, 0x000fe20000011600ULL, 0x0000000805057c24ULL, 0x000fe4000f8e0204ULL,
0x0000000850077824ULL, 0x000fc400078e0207ULL, 0x000000013c067824ULL, 0x002fe200078e0202ULL,
0x0000000552057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f440cULL,
0x000000510200720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000060d077227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x002fe400078e0a07ULL,
0x0000000100027824ULL, 0x000fe400078e0202ULL, 0x0000000805047c24ULL, 0x000fc6000f8e0206ULL,
0x0000000702057812ULL, 0x000fe400078ec0ffULL, 0x0000000804007c0cULL, 0x000fe4000bf26070ULL,
0xfffffff805027812ULL, 0x000fd600078ef800ULL, 0x8000000804041c36ULL, 0x000fe40008000000ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x0000000804007c0cULL, 0x000fe2000bf46070ULL,
0x0000001002047824ULL, 0x000fca00078e0203ULL, 0x0000000004087984ULL, 0x000e6e0000000c00ULL,
0x0000000107072836ULL, 0x000fca0000000000ULL, 0x000000070e027207ULL, 0x000fca0004000000ULL,
0x000000ffff057224ULL, 0x000fe400078e0a02ULL, 0x0000000902037c24ULL, 0x000fe4000f8e024dULL,
0x0000000805067c24ULL, 0x000fe2000f8e0206ULL, 0x0000000700057812ULL, 0x000fc600078ec0ffULL,
0x0000000803037c24ULL, 0x000fe4000f8e0206ULL, 0x0000000850057824ULL, 0x000fc600078e0205ULL,
0x0000000352037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x0000000403027c11ULL, 0x000fc8000f8040ffULL, 0x0000000503037c11ULL, 0x000fc600080f4406ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000c0001407983ULL, 0x000ea20000100800ULL,
0x00000001ff727819ULL, 0x000fe20000011602ULL, 0x00009a00ff127b82ULL, 0x000ee20000000a00ULL,
0xffffffffff087424ULL, 0x000fe200078e00ffULL, 0x0000040001427983ULL, 0x000b2c0000100800ULL,
0x00009000ff0e7b82ULL, 0x002e620000000a00ULL, 0x00000006120b7981ULL, 0x008b22000c1e9900ULL,
0x000000407200720cULL, 0x004fda0003f06070ULL, 0x00009600ff068b82ULL, 0x000ea20000000800ULL,
0x0000000204078824ULL, 0x000fce00078e00ffULL, 0x00009200ff108b82ULL, 0x000ee20000000a00ULL,
0x0000000607078224ULL, 0x004fe400078e0272ULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x0000000407108825ULL, 0x008fc800078e0010ULL, 0x01760006ff0679a7ULL, 0x000f620008500008ULL,
0x0000000610088981ULL, 0x000ea2000c1e1900ULL, 0x000000804d0d7824ULL, 0x000fca00078e00ffULL,
0x0000100d01007387ULL, 0x000be20000100800ULL, 0x000001ff0c00780cULL, 0x000fe20003f04070ULL,
0x0000008009097824ULL, 0x000fe400078e00ffULL, 0x00000040020c7824ULL, 0x000fe400078e00ffULL,
0x0000000809097224ULL, 0x004fc800078e02ffULL, 0x0000008009087825ULL, 0x002fe200078e000eULL,
0x000000400d0e7812ULL, 0x000fc600078ef80cULL, 0x0000000c00200947ULL, 0x020fea0003800000ULL,
0x00000003ff227819ULL, 0x000fe40000011603ULL, 0x0000000c420d7248ULL, 0x010fc60007fe0000ULL,
0x0000000822147836ULL, 0x000fe40000000000ULL, 0x0000000422127836ULL, 0x000fe40000000000ULL,
0x000000010d0d7824ULL, 0x000fe400078e0a0cULL, 0x0000000114117824ULL, 0x040fe400078e0203ULL,
0x00000008142a7824ULL, 0x000fe200078e00ffULL, 0x0000000d1200720cULL, 0x000fe20003fa6070ULL,
0x000000010e107824ULL, 0x000fc400078e0222ULL, 0x00000001120f7824ULL, 0x040fe200078e0203ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee211ULL, 0x0000000812287824ULL, 0x000fe400078e00ffULL,
0x000000010e127824ULL, 0x000fe400078e0212ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fc600078ee20fULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000007010217812ULL, 0x000fc600078ef805ULL, 0x0000000c22187836ULL, 0x000fe20000000000ULL,
0x0000007012157812ULL, 0x000fe200078ef805ULL, 0x0000001022167836ULL, 0x000fe20000000000ULL,
0x0000002108207210ULL, 0x000fe20007f1e0ffULL, 0x000000010e127824ULL, 0x000fe200078e0214ULL,
0x0000001508107210ULL, 0x000fe20007f3e0ffULL, 0x0000000116267824ULL, 0x000fe200078e0203ULL,
0x0000000d1800720cULL, 0x080fe20003f46070ULL, 0x0000000109217824ULL, 0x040fe200000e0611ULL,
0x0000000d1600720cULL, 0x080fe20003f06070ULL, 0x0000000109117824ULL, 0x000fe200008e0613ULL,
0x0000000d1400720cULL, 0x000fe20003f26070ULL, 0x000000010e147824ULL, 0x000fc400078e0218ULL,
0x0000000816177824ULL, 0x000fe400078e00ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff817267812ULL, 0x000fe200078ee226ULL, 0x000000010e167824ULL, 0x000fe200078e0216ULL,
0x00000070121d7812ULL, 0x000fe200078ef805ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x0000001d081c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001422247836ULL, 0x000fe20000000000ULL,
0x00000070141b7812ULL, 0x000fe200078ef805ULL, 0x00000001180f7824ULL, 0x040fe400078e0203ULL,
0x00000008182c7824ULL, 0x000fe200078e00ffULL, 0x0000001b081a7210ULL, 0x000fe20007f9e0ffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee20fULL,
0x000000010e187824ULL, 0x000fe200078e0224ULL, 0x00000070160f7812ULL, 0x000fe200078ef805ULL,
0x0000001822307836ULL, 0x000fe40000000000ULL, 0x0000008018187825ULL, 0x000fc800078e00ffULL,
0x000000010e1e7824ULL, 0x000fe400078e0230ULL, 0x00000001091d7824ULL, 0x040fe200018e0613ULL,
0x0000000f08167210ULL, 0x000fe20007f7e0ffULL, 0x00000001091b7824ULL, 0x000fe200020e0615ULL,
0x0000007018157812ULL, 0x000fe200078ef805ULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x00000008020f7c11ULL, 0x000fc6000f8e70ffULL, 0x0000001c22327836ULL, 0x000fe20000000000ULL,
0x000000701e137812ULL, 0x000fe200078ef805ULL, 0x0000000109177824ULL, 0x040fe200018e0617ULL,
0x0000001508147210ULL, 0x000fe20007f7e0ffULL, 0x000000010e187824ULL, 0x000fe200078e0232ULL,
0x0000001308127210ULL, 0x000fe20007f9e0ffULL, 0x00000001221e7824ULL, 0x000fe400078e0203ULL,
0x0000000109157824ULL, 0x000fe200018e0619ULL, 0x0000000d2400720cULL, 0x000fe20003f66070ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x000000071e2e7812ULL, 0x000fc600078ec0ffULL,
0x0000000109137824ULL, 0x000fe200020e061fULL, 0x00000070181f7812ULL, 0x000fe200078ef805ULL,
0x0000002022347836ULL, 0x000fe20000000000ULL, 0x0000000d2200720cULL, 0x000fe20003f86070ULL,
0x00000001241e7824ULL, 0x040fe200078e0203ULL, 0x0000001f08187210ULL, 0x000fe20007fde0ffULL,
0x0000000824237824ULL, 0x000fe200078e00ffULL, 0x0ffffff82e247812ULL, 0x000fe200078ef803ULL,
0x000000010e1f7824ULL, 0x000fe400078e0234ULL, 0x000010000f0f7836ULL, 0x000fe20000000000ULL,
0xfffffff8232e7812ULL, 0x000fe200078ee21eULL, 0x000000801f1e7825ULL, 0x000fc800078e00ffULL,
0x0000001024237824ULL, 0x000fe200078e020fULL, 0x000000701e257812ULL, 0x000fe200078ef805ULL,
0x0000002422367836ULL, 0x000fe40000000000ULL, 0x0000000109197824ULL, 0x000fe200030e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e2000e101c46ULL,
0x000000010e247824ULL, 0x000fe200078e0236ULL, 0x0000000d3000720cULL, 0x040fe20003f86070ULL,
0x0000000130277824ULL, 0x040fe200078e0203ULL, 0x00000025081e7210ULL, 0x000fe20007fde0ffULL,
0x0000000830307824ULL, 0x000fc400078e00ffULL, 0x0000008024247825ULL, 0x000fc600078e00ffULL,
0xfffffff830307812ULL, 0x000fe200078ee227ULL, 0x0000002822387836ULL, 0x000fe20000000000ULL,
0x0000007024277812ULL, 0x000fe200078ef805ULL, 0x00000001091f7824ULL, 0x000fe400030e061fULL,
0x000000010e297824ULL, 0x000fe200078e0238ULL, 0x0000002708247210ULL, 0x000fe20007fde0ffULL,
0x0000001028237824ULL, 0x002fe400078e020fULL, 0x0000000132277824ULL, 0x040fe400078e0203ULL,
0x0000000832287824ULL, 0x040fe200078e00ffULL, 0x0000000010237faeULL, 0x0003e2000e901c46ULL,
0x0000008029207825ULL, 0x000fe200078e00ffULL, 0x0000000d3200720cULL, 0x000fc40003fa6070ULL,
0xfffffff828287812ULL, 0x000fe200078ee227ULL, 0x000000102a277824ULL, 0x000fe200078e020fULL,
0x0000007020297812ULL, 0x000fe200078ef805ULL, 0x0000000109257824ULL, 0x000fe400030e0625ULL,
0x0000002c22327836ULL, 0x000fe20000000000ULL, 0x0000002908207210ULL, 0x000fe20007fde0ffULL,
0x000000001c277faeULL, 0x0005e2000c901c46ULL, 0x0000000d3400720cULL, 0x040fe20003f26070ULL,
0x0000000134297824ULL, 0x040fe400078e0203ULL, 0x0000000834347824ULL, 0x000fc400078e00ffULL,
0x000000102c237824ULL, 0x002fe400078e020fULL, 0x000000010e107824ULL, 0x000fe400078e0232ULL,
0x0000000109217824ULL, 0x000fe200030e0621ULL, 0x000000001a237faeULL, 0x0003e2000d101c46ULL,
0xfffffff8341c7812ULL, 0x004fe200078ee229ULL, 0x00000010261d7824ULL, 0x000fe200078e020fULL,
0x0000000d3600720cULL, 0x000fe20003f46070ULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x00000000161d7faeULL, 0x0005e2000c101c46ULL, 0x000000101c297824ULL, 0x100fe200078e020fULL,
0x00000070102b7812ULL, 0x000fe200078ef805ULL, 0x00000030221c7836ULL, 0x000fe40000000000ULL,
0x000000102e1b7824ULL, 0x102fe200078e020fULL, 0x0000002b08107210ULL, 0x000fe20007fde0ffULL,
0x0000001030237824ULL, 0x000fe400078e020fULL, 0x0000003422267836ULL, 0x000fe20000000000ULL,
0x00000000141b7faeULL, 0x0003e2000d901c46ULL, 0x00000001362a7824ULL, 0x000fe200078e0203ULL,
0x0000000d1c00720cULL, 0x080fe20003f66070ULL, 0x000000010e167824ULL, 0x004fe200078e021cULL,
0x0000000012237faeULL, 0x0005e2000e101c46ULL, 0x00000008362d7824ULL, 0x000fe200078e00ffULL,
0x0000000d3200720cULL, 0x000fe20003f86070ULL, 0x0000000109117824ULL, 0x000fc400030e0611ULL,
0x0000001028277824ULL, 0x000fe200078e020fULL, 0xfffffff82d2a7812ULL, 0x000fe200078ee22aULL,
0x0000000838177824ULL, 0x000fe400078e00ffULL, 0x000000010e147824ULL, 0x002fe200078e0226ULL,
0x0000000018277faeULL, 0x0003e2000e901c46ULL, 0x0000003822287836ULL, 0x000fe20000000000ULL,
0x0000000d3800720cULL, 0x080fe20003fa6070ULL, 0x0000008016127825ULL, 0x004fe200078e00ffULL,
0x000000001e297faeULL, 0x0005e4000c901c46ULL, 0x0000000d2800720cULL, 0x000fe20003f26070ULL,
0x0000000138167824ULL, 0x000fe200078e0203ULL, 0x0000007012157812ULL, 0x000fe200078ef805ULL,
0x000000102a2b7824ULL, 0x000fc400078e020fULL, 0x0000003c22227836ULL, 0x000fe20000000000ULL,
0x0000001508127210ULL, 0x000fe20007fde0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff8171a7812ULL, 0x000fe200078ee216ULL, 0x00000000242b7faeULL, 0x0007e2000d101c46ULL,
0x0000000d2600720cULL, 0x080fe20003f46070ULL, 0x0000000109137824ULL, 0x000fe200030e0613ULL,
0x0000007014197812ULL, 0x002fe200078ef805ULL, 0x000000011c147824ULL, 0x000fe200078e0203ULL,
0x0000000d2200720cULL, 0x000fe20003f06070ULL, 0x000000081c177824ULL, 0x000fe200078e00ffULL,
0x0000001908187210ULL, 0x000fe20007fde0ffULL, 0x000000010e167824ULL, 0x000fc400078e0228ULL,
0x00000001320d7824ULL, 0x000fe200078e0203ULL, 0xfffffff8171e7812ULL, 0x004fe200078ee214ULL,
0x0000000109197824ULL, 0x000fe400030e0615ULL, 0x0000008016147825ULL, 0x000fc800078e00ffULL,
0x0000000832327824ULL, 0x000fe200078e00ffULL, 0x00000070141d7812ULL, 0x000fe200078ef805ULL,
0x000000010e167824ULL, 0x000fe400078e0222ULL, 0x00000001281b7824ULL, 0x040fe200078e0203ULL,
0xfffffff8321c7812ULL, 0x000fe200078ee20dULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0x0000001d08147210ULL, 0x000fe20007fde0ffULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x00000001260d7824ULL, 0x140fe400078e0203ULL, 0x0000000826267824ULL, 0x000fe400078e00ffULL,
0x0000000122037824ULL, 0x040fe400078e0203ULL, 0x0000000822247824ULL, 0x008fe200078e00ffULL,
0xfffffff828227812ULL, 0x000fe200078ee21bULL, 0x0000000109157824ULL, 0x000fe200030e0615ULL,
0x00000070161b7812ULL, 0x000fe200078ef805ULL, 0x000000101c057824ULL, 0x100fe200078e020fULL,
0xfffffff8260e7812ULL, 0x000fe200078ee20dULL, 0x000000101e0d7824ULL, 0x100fe200078e020fULL,
0xfffffff824247812ULL, 0x000fe200078ee203ULL, 0x000000101a037824ULL, 0x100fe200078e020fULL,
0x0000001b08087210ULL, 0x000fe20007fde0ffULL, 0x000000100e1b7824ULL, 0x000fc400078e020fULL,
0x00000010221d7824ULL, 0x100fe200078e020fULL, 0x0000000020037faeULL, 0x0003e2000e901c46ULL,
0x00000010240f7824ULL, 0x000fe400078e020fULL, 0x0000000109097824ULL, 0x000fe200030e0617ULL,
0x0000000010057faeULL, 0x0003e8000e101c46ULL, 0x00000000120d7faeULL, 0x0003e8000d901c46ULL,
0x00000000181b7faeULL, 0x0003e8000d101c46ULL, 0x00000000141d7faeULL, 0x0003e8000c901c46ULL,
0x00000000080f7faeULL, 0x0003e2000c101c46ULL, 0x0000000800d07947ULL, 0x000fea0003800000ULL,
0x0000000403117811ULL, 0x040fe400078fe8ffULL, 0x0000000c03137811ULL, 0x040fe400078fe8ffULL,
0x0000001403177811ULL, 0x000fe200078fe8ffULL, 0x00000001110d7824ULL, 0x100fe200078e0203ULL,
0x0000000803127811ULL, 0x000fe200078fe8ffULL, 0x0000000811167824ULL, 0x000fe200078e00ffULL,
0x0000001003147811ULL, 0x000fe200078fe8ffULL, 0x0000000113107824ULL, 0x100fe200078e0203ULL,
0x0000001c031b7811ULL, 0x000fe200078fe8ffULL, 0x0000000813237824ULL, 0x000fe200078e00ffULL,
0xfffffff8161d7812ULL, 0x000fe200078ee20dULL, 0x00000001170d7824ULL, 0x100fe200078e0203ULL,
0x00000024031e7811ULL, 0x000fe200078fe8ffULL, 0x0000000817167824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee210ULL, 0x00000001120f7824ULL, 0x140fe200078e0203ULL,
0x0000001803197811ULL, 0x040fe200078fe8ffULL, 0x0000000812187824ULL, 0x000fe200078e00ffULL,
0x00000020031c7811ULL, 0x040fe200078fe8ffULL, 0x0000000114157824ULL, 0x140fe200078e0203ULL,
0xfffffff8162b7812ULL, 0x000fe200078ee20dULL, 0x00000008141a7824ULL, 0x000fe200078e00ffULL,
0x0000002c03227811ULL, 0x000fe200078fe8ffULL, 0x000000011b107824ULL, 0x140fe200078e0203ULL,
0xfffffff8181f7812ULL, 0x000fe200078ee20fULL, 0x000000081b2f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a277812ULL, 0x000fe200078ee215ULL, 0x000000011e0d7824ULL, 0x140fe200078e0203ULL,
0x0000002803217811ULL, 0x000fe200078fe8ffULL, 0x000000081e167824ULL, 0x000fe200078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee210ULL, 0x00000001190f7824ULL, 0x100fe200078e0203ULL,
0x0000003003257811ULL, 0x000fe200078fe8ffULL, 0x0000000819187824ULL, 0x000fe200078e00ffULL,
0xfffffff816337812ULL, 0x000fe200078ee20dULL, 0x000000011c157824ULL, 0x140fe200078e0203ULL,
0x00000003030d7211ULL, 0x040fe200078fe8ffULL, 0x000000081c1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8182d7812ULL, 0x000fe200078ee20fULL, 0x0000000122107824ULL, 0x140fe200078e0203ULL,
0x00000038032e7811ULL, 0x000fe200078fe8ffULL, 0x0000000822297824ULL, 0x000fe200078e00ffULL,
0xfffffff81a317812ULL, 0x000fe200078ee215ULL, 0x00000001210f7824ULL, 0x100fe200078e0203ULL,
0x0000003c03307811ULL, 0x000fe200078fe8ffULL, 0x0000000821267824ULL, 0x000fe200078e00ffULL,
0xfffffff8292a7812ULL, 0x000fe200078ee210ULL, 0x0000000125157824ULL, 0x000fe200078e0203ULL,
0x000000070d107812ULL, 0x000fe200078ec0ffULL, 0x00000008252c7824ULL, 0x000fe200078e00ffULL,
0x0000003403297811ULL, 0x040fe200078fe8ffULL, 0x000000010e167824ULL, 0x040fe200078e0214ULL,
0xfffffff826267812ULL, 0x000fe200078ee20fULL, 0x000000010e187824ULL, 0x000fe200078e0217ULL,
0x0ffffff810147812ULL, 0x000fe200078ef803ULL, 0x000000012e177824ULL, 0x040fe200078e0203ULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee215ULL, 0x000000082e387824ULL, 0x000fe200078e00ffULL,
0x0000000e030f7211ULL, 0x000fe200078fe8ffULL, 0x000000010e157824ULL, 0x000fe200078e0213ULL,
0x0000000802107c11ULL, 0x000fe2000f8e70ffULL, 0x000000010e117824ULL, 0x000fe200078e0211ULL,
0xfffffff838177812ULL, 0x000fe200078ee217ULL, 0x0000000129137824ULL, 0x000fc400078e0203ULL,
0x000000010e247824ULL, 0x040fe400078e021cULL, 0x000000010e287824ULL, 0x040fe400078e021eULL,
0x000000010e367824ULL, 0x040fe400078e0222ULL, 0x0000000829327824ULL, 0x000fe400078e00ffULL,
0x000000010e0d7824ULL, 0x000fe400078e0230ULL, 0x0000000130037824ULL, 0x000fc400078e0203ULL,
0x000000010e127824ULL, 0x040fe400078e0212ULL, 0x000000010e1a7824ULL, 0x040fe400078e0219ULL,
0x000000010e207824ULL, 0x040fe400078e021bULL, 0x000000010e347824ULL, 0x040fe400078e0221ULL,
0x000000010e227824ULL, 0x040fe400078e0225ULL, 0x000000010e1e7824ULL, 0x000fc400078e0229ULL,
0x000000010e1c7824ULL, 0x000fe200078e022eULL, 0xfffffff8322e7812ULL, 0x000fe200078ee213ULL,
0x0000000830307824ULL, 0x000fe400078e00ffULL, 0x000000800f0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff830327812ULL, 0x000fe200078ee203ULL, 0x0000100010387836ULL, 0x000fe20000000000ULL,
0x000000700e037812ULL, 0x000fe200078ef805ULL, 0x0000008011107825ULL, 0x000fc600078e00ffULL,
0x00000003080e7210ULL, 0x000fe20007f1e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000007010197812ULL, 0x000fc600078ef805ULL, 0x0000001014037824ULL, 0x000fe200078e0238ULL,
0x0000001908107210ULL, 0x000fe20007f3e0ffULL, 0x0000008015147825ULL, 0x000fe200078e00ffULL,
0x0000007012197812ULL, 0x000fc600078ef805ULL, 0x00000001090f7824ULL, 0x040fe200000e060fULL,
0x0000001908127210ULL, 0x000fe20007f1e0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000007014217812ULL, 0x000fe400078ef805ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e037faeULL, 0x0003e2000b901c46ULL, 0x0000000109137824ULL, 0x000fe200000e0613ULL,
0x0000002108147210ULL, 0x000fe20007f1e0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x000000701a217812ULL, 0x000fc600078ef805ULL, 0x0000001017307824ULL, 0x000fe200078e0238ULL,
0x0000007018257812ULL, 0x000fe200078ef805ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000021081a7210ULL, 0x000fc60007f5e0ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000007016297812ULL, 0x000fc600078ef805ULL, 0x0000000109157824ULL, 0x040fe200000e0615ULL,
0x0000002508187210ULL, 0x000fe20007f1e0ffULL, 0x0000000109117824ULL, 0x000fe200008e0611ULL,
0x0000002908167210ULL, 0x000fe20007f3e0ffULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x0000007020397812ULL, 0x000fc600078ef805ULL, 0x0000008034347825ULL, 0x000fc800078e00ffULL,
0x0000000109197824ULL, 0x000fe200000e0619ULL, 0x0000003908207210ULL, 0x000fe20007f1e0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000007028397812ULL, 0x000fe400078ef805ULL,
0x00000070343f7812ULL, 0x000fe200078ef805ULL, 0x0000008024247825ULL, 0x000fc800078e00ffULL,
0x00000001091b7824ULL, 0x040fe200010e061bULL, 0x0000003f083e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000109217824ULL, 0x000fe200000e0621ULL, 0x0000003908287210ULL, 0x000fe20007f1e0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0238ULL, 0x0000007036397812ULL, 0x000fe200078ef805ULL,
0x00000001093f7824ULL, 0x040fe200010e0635ULL, 0x00000070243b7812ULL, 0x000fe200078ef805ULL,
0x0000000109297824ULL, 0x000fe200000e0629ULL, 0x0000003908367210ULL, 0x000fe20007f1e0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0238ULL, 0x00000000101d7faeULL, 0x0003e2000b901c46ULL,
0x0000001023237824ULL, 0x000fc400078e0238ULL, 0x0000001027277824ULL, 0x100fe200078e0238ULL,
0x00000000121f7faeULL, 0x0003e2000b901c46ULL, 0x000000102b2b7824ULL, 0x100fe400078e0238ULL,
0x000000102d2d7824ULL, 0x100fe200078e0238ULL, 0x0000000014237faeULL, 0x0003e2000b901c46ULL,
0x000000102f2f7824ULL, 0x100fe400078e0238ULL, 0x0000001031317824ULL, 0x100fe400078e0238ULL,
0x0000001033337824ULL, 0x000fc400078e0238ULL, 0x0000001026267824ULL, 0x100fe400078e0238ULL,
0x000000102a2a7824ULL, 0x100fe400078e0238ULL, 0x000000102c2c7824ULL, 0x100fe400078e0238ULL,
0x000000102e2e7824ULL, 0x100fe400078e0238ULL, 0x0000001032327824ULL, 0x000fe400078e0238ULL,
0x0000000109177824ULL, 0x000fe200008e0617ULL, 0x0000003b08247210ULL, 0x000fe20007f3e0ffULL,
0x0000008022347825ULL, 0x000fc600078e00ffULL, 0x0000000016277faeULL, 0x0003e2000b901c46ULL,
0x000000801e387825ULL, 0x000fe200078e00ffULL, 0x0000007034437812ULL, 0x000fe400078ef805ULL,
0x00000000182b7faeULL, 0x0003e2000b901c46ULL, 0x000000801c3a7825ULL, 0x000fe200078e00ffULL,
0x0000007038417812ULL, 0x000fe400078ef805ULL, 0x000000001a2d7faeULL, 0x0003e2000b901c46ULL,
0x000000800d3c7825ULL, 0x000fe200078e00ffULL, 0x000000703a0d7812ULL, 0x000fc400078ef805ULL,
0x00000000202f7faeULL, 0x0003e2000b901c46ULL, 0x0000000109377824ULL, 0x040fe200000e0637ULL,
0x000000703c057812ULL, 0x000fe200078ef805ULL, 0x0000000109257824ULL, 0x040fe200008e0625ULL,
0x0000004308347210ULL, 0x000fe40007f1e0ffULL, 0x0000004108387210ULL, 0x000fe40007f3e0ffULL,
0x0000000d083a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000109357824ULL, 0x040fe200000e0635ULL,
0x0000000508087210ULL, 0x000fe20007f7e0ffULL, 0x0000000109397824ULL, 0x040fe200008e0639ULL,
0x0000000024317faeULL, 0x0003e2000b901c46ULL, 0x00000001093b7824ULL, 0x000fc400010e063bULL,
0x0000000109097824ULL, 0x000fe200018e063dULL, 0x0000000028337faeULL, 0x0003e8000b901c46ULL,
0x000000003e267faeULL, 0x0003e8000b901c46ULL, 0x00000000362a7faeULL, 0x0003e8000b901c46ULL,
0x00000000342c7faeULL, 0x0003e8000b901c46ULL, 0x00000000382e7faeULL, 0x0003e8000b901c46ULL,
0x000000003a307faeULL, 0x0003e8000b901c46ULL, 0x0000000008327faeULL, 0x0003e4000b901c46ULL,
0x0000000272727836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff0d7424ULL, 0x002fe200078e00ffULL, 0x0000840000047ab9ULL, 0x000fe40000000800ULL,
0x000000407200720cULL, 0x000fda0003f06070ULL, 0x00009600ff058b82ULL, 0x000e620000000800ULL,
0x0000000204038824ULL, 0x000fce00078e00ffULL, 0x00009200ff088b82ULL, 0x000ea20000000a00ULL,
0x0000000503038224ULL, 0x002fc800078e0272ULL, 0x0000000403088825ULL, 0x004fca00078e0008ULL,
0x00000006080d8981ULL, 0x000ea2000c1e1900ULL, 0x0000001f04047890ULL, 0x000fc8000fffe03fULL,
0x000000053f047899ULL, 0x000fe20008011604ULL, 0x0000000d01007387ULL, 0x0043f60000100800ULL,
0x0000000000087805ULL, 0x000fe20000015200ULL, 0x01760007ff0075a7ULL, 0x000ea20008000148ULL,
0x0000000142037824ULL, 0x010fe400078e0a00ULL, 0x000000040a057c24ULL, 0x000fc6000f8e02ffULL,
0x00000008ff037819ULL, 0x000fca0000011603ULL, 0x0000140301007387ULL, 0x0007e20000100800ULL,
0x00008e00ff407b82ULL, 0x000f640000000a00ULL, 0x0000000405407825ULL, 0x022fe200078e0040ULL,
0x00000000005c0947ULL, 0x01efec0003800000ULL, 0x000000ffff057224ULL, 0x000fce00078e00ffULL,
0x000000100500780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e080a7210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0e7824ULL, 0x000fe200000e0e09ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0e00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0e00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc8000001140eULL,
0x0000000a03037211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e060eULL,
0x0000000203037819ULL, 0x000fc8000000120aULL, 0x000000030000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000105057836ULL, 0x000fce0000000000ULL,
0x01760007ff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x00000001ff0e7424ULL, 0x000fe400078e00ffULL,
0x0000002002037824ULL, 0x002fca00078e0203ULL, 0x00000003ff057819ULL, 0x000fc80000011603ULL,
0x1ffffffe05067812ULL, 0x000fe400078ec0ffULL, 0x0000000f03057812ULL, 0x000fc600078ec0ffULL,
0x0000000103067824ULL, 0x000fe400078e0206ULL, 0x0000001005077824ULL, 0x040fe400078e00ffULL,
0x0000000106037836ULL, 0x000fe20000000000ULL, 0x0000000f06067812ULL, 0x000fe200078ec0ffULL,
0x0000001005087824ULL, 0x000fc600078e00ffULL, 0x0000000f03037812ULL, 0x000fe400078ec0ffULL,
0x000000f007067812ULL, 0x000fe400078ee206ULL, 0x000000f008037812ULL, 0x000fe400078ee203ULL,
0x0000000806067c11ULL, 0x000fe4000f8e20ffULL, 0x0000000803037c11ULL, 0x000fc6000f8e20ffULL,
0x0000000006147984ULL, 0x000e680000000c00ULL, 0x0000000003107984ULL, 0x000ea20000000c00ULL,
0x000000ffff187224ULL, 0x002fe400078e0014ULL, 0x000000ffff147224ULL, 0x000fe400078e0015ULL,
0x000000ffff197224ULL, 0x000fe400078e0016ULL, 0x000000ffff157224ULL, 0x000fc400078e0017ULL,
0x000000ffff1a7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0012ULL,
0x000000ffff167224ULL, 0x000fe400078e0011ULL, 0x000000ffff177224ULL, 0x000fe200078e0013ULL,
0x0000001806007388ULL, 0x0003e80000000c00ULL, 0x0000001403007388ULL, 0x0003e20000000c00ULL,
0x0176000eff0e79a7ULL, 0x000ea40008500008ULL, 0x0000000000067805ULL, 0x002fe20000015200ULL,
0x0176000fff0075a7ULL, 0x004e640008000148ULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff057224ULL, 0x000fce00078e00ffULL, 0x000000100500780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000806087210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011409ULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e0609ULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000105057836ULL, 0x000fce0000000000ULL, 0x0176000fff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000080001037983ULL, 0x000ea40000100800ULL,
0x000000ff0300720cULL, 0x004fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00009600ff057b82ULL, 0x000e620000000800ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x000001000c067836ULL, 0x000fe20000000000ULL, 0x00000008025e7c11ULL, 0x040fe2000f8e18ffULL,
0xffffffff00687836ULL, 0x000fe20000000000ULL, 0x00000008027d7c11ULL, 0x000fe2000f8e28ffULL,
0x0000000900717836ULL, 0x000fe20000000000ULL, 0x0000000104057899ULL, 0x000fe2000800063fULL,
0x000000ffff6f7224ULL, 0x000fe400078e00ffULL, 0x000000ffff1c7224ULL, 0x000fc400078e00ffULL,
0x0000000504057224ULL, 0x002fe400078e02ffULL, 0x3db504f30b047820ULL, 0x000fce0000410000ULL,
0x00000800010b7983ULL, 0x004ea20000100800ULL, 0x00008500ff087b82ULL, 0x000e660000000800ULL,
0x00000000010a7983ULL, 0x000ee80000300800ULL, 0x0000100001097983ULL, 0x000f220000100800ULL,
0x00009000ff067b82ULL, 0x000f620000000a00ULL, 0x000000026f057836ULL, 0x000fe20000000000ULL,
0x000000011c7c7812ULL, 0x000fe200078e0cffULL, 0x00000040020c7824ULL, 0x000fc800078e00ffULL,
0x000001000c0c7836ULL, 0x000fc80000000000ULL, 0x000001006f707824ULL, 0x000fe400078e020cULL,
0x0000008008087824ULL, 0x002fe200078e00ffULL, 0x0000000b0500720cULL, 0x004fc60003f06070ULL,
0x0000000a08057224ULL, 0x008fe200078e02ffULL, 0x0000004070087812ULL, 0x000fc600078ec0ffULL,
0x0000008005067825ULL, 0x020fc800078e0006ULL, 0x0000000109087824ULL, 0x010fe400078e0208ULL,
0x0000000c00308947ULL, 0x000fea0003800000ULL, 0x00000400010a7983ULL, 0x000ea20000100800ULL,
0x00000003ff1b7819ULL, 0x000fca0000011603ULL, 0x000000041b0b7836ULL, 0x000fe40000000000ULL,
0x000000081b0f7836ULL, 0x000fe40000000000ULL, 0x000000010b097824ULL, 0x140fe400078e0203ULL,
0x000000080b287824ULL, 0x040fe400078e00ffULL, 0x000000010b0c7824ULL, 0x000fe400078e0208ULL,
0x000000010f247824ULL, 0x000fe200078e0203ULL, 0xfffffff828287812ULL, 0x000fe200078ee209ULL,
0x0000001003097824ULL, 0x000fc400078e00ffULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0x0000007009097812ULL, 0x000fe200078ec0ffULL, 0x000000101b137836ULL, 0x000fe40000000000ULL,
0x000000141b217836ULL, 0x000fe20000000000ULL, 0x000000090c117212ULL, 0x000fe200078efcffULL,
0x00000001130e7824ULL, 0x140fe400078e0208ULL, 0x0000000113227824ULL, 0x040fe200078e0203ULL,
0x0000001106107210ULL, 0x000fe20007f3e0ffULL, 0x0000000813197824ULL, 0x000fe400078e00ffULL,
0x0000000121167824ULL, 0x000fc400078e0208ULL, 0x0000000107117824ULL, 0x000fe200008e060dULL,
0xfffffff819227812ULL, 0x000fe200078ee222ULL, 0x000000181b257836ULL, 0x000fe40000000000ULL,
0x0000001c1b297836ULL, 0x000fe40000000000ULL, 0x00000001251e7824ULL, 0x000fe400078e0208ULL,
0x000000201b2b7836ULL, 0x000fe40000000000ULL, 0x000000801e1e7825ULL, 0x000fc800078e00ffULL,
0x0000000121237824ULL, 0x140fe400078e0203ULL, 0x00000008212a7824ULL, 0x000fe400078e00ffULL,
0x000000241b2d7836ULL, 0x000fe40000000000ULL, 0x000000281b2f7836ULL, 0x000fe20000000000ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee223ULL, 0x0000000125277824ULL, 0x040fe400078e0203ULL,
0x00000008252c7824ULL, 0x000fc400078e00ffULL, 0x0000002c1b317836ULL, 0x000fe40000000000ULL,
0x000000381b337836ULL, 0x000fe20000000000ULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee227ULL,
0x0000000129277824ULL, 0x000fe400078e0203ULL, 0x0000003c1b357836ULL, 0x000fe20000000000ULL,
0x000000700a057248ULL, 0x004fe20007fe0000ULL, 0x000000011b0a7824ULL, 0x000fc800078e0208ULL,
0x00000001051a7824ULL, 0x000fe400078e0a70ULL, 0x000000080f057824ULL, 0x000fc600078e00ffULL,
0x0000001a0b00720cULL, 0x080fe20003fa6070ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff805247812ULL, 0x000fe400078ee224ULL, 0x0000001a0f00720cULL, 0x0c0fe20003f26070ULL,
0x0000000c1b057836ULL, 0x000fe20000000000ULL, 0x000000090a157212ULL, 0x000fe200078efcffULL,
0x000000010f0a7824ULL, 0x100fe400078e0208ULL, 0x00000001050c7824ULL, 0x040fe200078e0208ULL,
0x0000001506147210ULL, 0x000fe20007f1e0ffULL, 0x0000000105267824ULL, 0x040fe200078e0203ULL,
0x0000001a0500720cULL, 0x040fe20003f46070ULL, 0x0000000805177824ULL, 0x000fc400078e00ffULL,
0x0000000107157824ULL, 0x000fe200000e060bULL, 0x0000001a1300720cULL, 0x000fe20003f06070ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff817267812ULL, 0x000fc600078ee226ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000090a137212ULL, 0x000fc600078efcffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000090c057212ULL, 0x080fe400078efcffULL,
0x0000001306127210ULL, 0x000fe20007f7e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000090e197212ULL, 0x080fe400078efcffULL, 0x0000000506187210ULL, 0x000fe20007f9e0ffULL,
0x0000000107137824ULL, 0x000fe200018e060bULL, 0x0000000916057212ULL, 0x000fe200078efcffULL,
0x0000000129167824ULL, 0x000fe200078e0208ULL, 0x00000019060e7210ULL, 0x000fe20007f7e0ffULL,
0x0000000107197824ULL, 0x000fe200020e060dULL, 0x00000005060c7210ULL, 0x000fc40007f9e0ffULL,
0x000000091e0b7212ULL, 0x080fe200078efcffULL, 0x000000011b1e7824ULL, 0x000fe200078e0203ULL,
0x0000000802057c11ULL, 0x000fe2000f8e70ffULL, 0x00000001070f7824ULL, 0x040fe200018e060fULL,
0x0000000b060a7210ULL, 0x000fe20007f7e0ffULL, 0x00000001070d7824ULL, 0x000fe200020e0617ULL,
0x000000071e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000001a1b00720cULL, 0x080fe40003f86070ULL, 0x0ffffff81e207812ULL, 0x000fe200078ef803ULL,
0x00000001070b7824ULL, 0x000fe200018e061fULL, 0x00000009161f7212ULL, 0x000fe200078efcffULL,
0x000020007c1d7824ULL, 0x000fe200078e0205ULL, 0x0000001a2100720cULL, 0x000fe20003f66070ULL,
0x000000012b1e7824ULL, 0x000fe200078e0208ULL, 0x0000001f06167210ULL, 0x000fe20007fde0ffULL,
0x000010001d1d7836ULL, 0x000fc40000000000ULL, 0x000000801e1e7825ULL, 0x000fc800078e00ffULL,
0x0000001020237824ULL, 0x000fe200078e021dULL, 0x000000091e217212ULL, 0x000fe200078efcffULL,
0x000000012d207824ULL, 0x100fe400078e0208ULL, 0x0000000107177824ULL, 0x000fe200030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014237faeULL, 0x0003e2000e101c46ULL,
0x0000001a2500720cULL, 0x000fe20003f86070ULL, 0x000000012f257824ULL, 0x000fe200078e0208ULL,
0x00000021061e7210ULL, 0x000fe20007fde0ffULL, 0x0000008020207825ULL, 0x000fc800078e00ffULL,
0x00000001071f7824ULL, 0x000fe400030e061fULL, 0x0000008025147825ULL, 0x002fe200078e00ffULL,
0x0000000920257212ULL, 0x000fc600078efcffULL, 0x0000001028237824ULL, 0x000fe200078e021dULL,
0x0000002506207210ULL, 0x000fe20007fde0ffULL, 0x0000000829287824ULL, 0x000fe200078e00ffULL,
0x0000000914257212ULL, 0x000fe400078efcffULL, 0x0000000010237faeULL, 0x0003e2000e901c46ULL,
0x0000000107217824ULL, 0x000fe200030e0621ULL, 0x0000002506147210ULL, 0x000fe20007fde0ffULL,
0x0000001024257824ULL, 0x000fe200078e021dULL, 0x0000001a2900720cULL, 0x080fe20003fa6070ULL,
0x000000012b247824ULL, 0x000fe200078e0203ULL, 0xfffffff828287812ULL, 0x000fe200078ee227ULL,
0x0000000107157824ULL, 0x000fe200030e0615ULL, 0x0000000012257faeULL, 0x0005e2000c901c46ULL,
0x0000001a2b00720cULL, 0x040fe20003f26070ULL, 0x000000082b2b7824ULL, 0x000fc400078e00ffULL,
0x0000001026237824ULL, 0x002fe400078e021dULL, 0x0000000131107824ULL, 0x000fe200078e0208ULL,
0xfffffff82b247812ULL, 0x000fe200078ee224ULL, 0x000000301b2b7836ULL, 0x000fe20000000000ULL,
0x0000000018237faeULL, 0x0003e2000d101c46ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001a2d00720cULL, 0x000fc60003f46070ULL, 0x0000001022137824ULL, 0x004fe200078e021dULL,
0x0000000910277212ULL, 0x000fe200078efcffULL, 0x000000012d267824ULL, 0x040fe400078e0203ULL,
0x000000082d2d7824ULL, 0x000fe200078e00ffULL, 0x000000000e137faeULL, 0x0005e2000c101c46ULL,
0x0000002706107210ULL, 0x000fe20007fde0ffULL, 0x000000102a197824ULL, 0x102fe200078e021dULL,
0x0000001a3500720cULL, 0x080fe20003f06070ULL, 0x000000102c237824ULL, 0x100fe200078e021dULL,
0xfffffff82d267812ULL, 0x000fe200078ee226ULL, 0x000000341b2d7836ULL, 0x000fe20000000000ULL,
0x000000000c197faeULL, 0x0003e2000d901c46ULL, 0x0000001028257824ULL, 0x000fe200078e021dULL,
0x0000001a2b00720cULL, 0x080fe20003f66070ULL, 0x0000000107117824ULL, 0x000fe200030e0611ULL,
0x000000000a237faeULL, 0x0007e2000e101c46ULL, 0x000000012b0e7824ULL, 0x004fe200078e0208ULL,
0x0000001a3100720cULL, 0x080fe20003f86070ULL, 0x0000001024277824ULL, 0x100fe200078e021dULL,
0x0000000016257faeULL, 0x0005e2000e901c46ULL, 0x0000001a2f00720cULL, 0x000fe20003fa6070ULL,
0x0000001026297824ULL, 0x000fc400078e021dULL, 0x000000012d0c7824ULL, 0x002fe200078e0208ULL,
0x000000001e277faeULL, 0x0003e2000c901c46ULL, 0x0000000131127824ULL, 0x100fe200078e0203ULL,
0x0000001a3300720cULL, 0x080fe20003f26070ULL, 0x000000800e0a7825ULL, 0x008fe200078e00ffULL,
0x0000000020297faeULL, 0x0007e2000d101c46ULL, 0x0000001a2d00720cULL, 0x000fe40003f46070ULL,
0x000000012f0e7824ULL, 0x040fe200078e0203ULL, 0x000000090a0d7212ULL, 0x000fe200078efcffULL,
0x000000082f2f7824ULL, 0x000fc400078e00ffULL, 0x0000000831317824ULL, 0x000fe200078e00ffULL,
0x0000000d060a7210ULL, 0x000fe20007fde0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffff82f167812ULL, 0x004fe400078ee20eULL, 0xfffffff831187812ULL, 0x000fe200078ee212ULL,
0x00000001330e7824ULL, 0x000fe200078e0208ULL, 0x000000090c0f7212ULL, 0x000fe200078efcffULL,
0x00000001070b7824ULL, 0x000fe400030e060bULL, 0x000000012b137824ULL, 0x040fe200078e0203ULL,
0x0000000f060c7210ULL, 0x000fe20007fde0ffULL, 0x000000082b1a7824ULL, 0x000fc400078e00ffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee213ULL,
0x0000000135127824ULL, 0x000fe200078e0208ULL, 0x000000090e177212ULL, 0x000fe200078efcffULL,
0x000000012d197824ULL, 0x140fe400078e0203ULL, 0x000000082d1e7824ULL, 0x002fe400078e00ffULL,
0x00000001331b7824ULL, 0x040fe400078e0203ULL, 0x0000000833207824ULL, 0x008fe200078e00ffULL,
0xfffffff81e087812ULL, 0x000fe200078ee219ULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff8201e7812ULL, 0x000fe200078ee21bULL, 0x00000001070d7824ULL, 0x000fe200030e060dULL,
0x00000017060e7210ULL, 0x000fe20007fde0ffULL, 0x00000001351f7824ULL, 0x040fe200078e0203ULL,
0x00000009121b7212ULL, 0x000fe200078efcffULL, 0x0000000835227824ULL, 0x000fe400078e00ffULL,
0x00000001070f7824ULL, 0x000fe200030e060fULL, 0x0000001b06067210ULL, 0x000fe20007fde0ffULL,
0x0000001016097824ULL, 0x100fe200078e021dULL, 0xfffffff822207812ULL, 0x000fe200078ee21fULL,
0x0000001018177824ULL, 0x000fc400078e021dULL, 0x000000101a197824ULL, 0x100fe200078e021dULL,
0x0000000014097faeULL, 0x0003e2000e901c46ULL, 0x00000010081b7824ULL, 0x100fe400078e021dULL,
0x000000101e1f7824ULL, 0x100fe200078e021dULL, 0x0000000010177faeULL, 0x0003e2000e101c46ULL,
0x00000010201d7824ULL, 0x000fe400078e021dULL, 0x0000000107077824ULL, 0x000fe200030e0613ULL,
0x000000000a197faeULL, 0x0003e8000d901c46ULL, 0x000000000c1b7faeULL, 0x0003e8000d101c46ULL,
0x000000000e1f7faeULL, 0x0003e8000c901c46ULL, 0x00000000061d7faeULL, 0x0003e2000c101c46ULL,
0x0000000800dc7947ULL, 0x000fea0003800000ULL, 0x00000004030b7811ULL, 0x040fe200078fe8ffULL,
0x0000001003497824ULL, 0x040fe200078e00ffULL, 0x00000008030c7811ULL, 0x040fe400078fe8ffULL,
0x0000001403127811ULL, 0x000fe200078fe8ffULL, 0x000000010b057824ULL, 0x100fe200078e0203ULL,
0x0000001803147811ULL, 0x000fe200078fe8ffULL, 0x000000080b2a7824ULL, 0x000fe200078e00ffULL,
0x0000000c030e7811ULL, 0x040fe200078fe8ffULL, 0x000000010c097824ULL, 0x140fe200078e0203ULL,
0x0000001003167811ULL, 0x040fe200078fe8ffULL, 0x000000080c2c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee205ULL, 0x00000001120a7824ULL, 0x140fe200078e0203ULL,
0x00000024031e7811ULL, 0x040fe200078fe8ffULL, 0x00000008120f7824ULL, 0x000fe200078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee209ULL, 0x00000001140d7824ULL, 0x140fe200078e0203ULL,
0x0000002803207811ULL, 0x040fe200078fe8ffULL, 0x0000000814347824ULL, 0x000fe200078e00ffULL,
0x0000001c03197811ULL, 0x040fe200078fe8ffULL, 0x000000010e057824ULL, 0x140fe200078e0203ULL,
0x00000020031a7811ULL, 0x040fe200078fe8ffULL, 0x000000080e2e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f327812ULL, 0x000fe200078ee20aULL, 0x0000000116097824ULL, 0x140fe200078e0203ULL,
0xfffffff834347812ULL, 0x000fe200078ee20dULL, 0x0000000816307824ULL, 0x000fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee205ULL, 0x000000011e0a7824ULL, 0x140fe200078e0203ULL,
0x0000003403287811ULL, 0x040fe200078fe8ffULL, 0x000000081e0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff830307812ULL, 0x000fe200078ee209ULL, 0x00000001200d7824ULL, 0x140fe200078e0203ULL,
0x0000003803267811ULL, 0x040fe200078fe8ffULL, 0x00000008203c7824ULL, 0x000fe200078e00ffULL,
0x0000002c03187811ULL, 0x000fe200078fe8ffULL, 0x0000000119057824ULL, 0x100fe200078e0203ULL,
0x0000003003227811ULL, 0x000fe200078fe8ffULL, 0x0000000819367824ULL, 0x000fe200078e00ffULL,
0xfffffff80f3a7812ULL, 0x000fe200078ee20aULL, 0x000000011a097824ULL, 0x140fe200078e0203ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20dULL, 0x000000081a387824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee205ULL, 0x00000001280a7824ULL, 0x140fe200078e0203ULL,
0x0000007049497812ULL, 0x000fe200078ec0ffULL, 0x00000008280f7824ULL, 0x000fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee209ULL, 0x00000001260d7824ULL, 0x000fc400078e0203ULL,
0x0000000826467824ULL, 0x000fe200078e00ffULL, 0xfffffff80f447812ULL, 0x000fe200078ee20aULL,
0x0000000118057824ULL, 0x140fe200078e0203ULL, 0x00000003030a7211ULL, 0x040fe200078fe8ffULL,
0x00000008183e7824ULL, 0x000fe200078e00ffULL, 0xfffffff846467812ULL, 0x000fe200078ee20dULL,
0x0000000122097824ULL, 0x040fe200078e0203ULL, 0x0000003c030d7811ULL, 0x040fe200078fe8ffULL,
0x0000000822427824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee205ULL,
0x000000010c0c7824ULL, 0x100fe200078e0208ULL, 0x0000000802057c11ULL, 0x000fe2000f8e70ffULL,
0x000000010e0e7824ULL, 0x100fe200078e0208ULL, 0xfffffff842427812ULL, 0x000fe200078ee209ULL,
0x0000000116167824ULL, 0x100fe200078e0208ULL, 0x0000000803097211ULL, 0x000fe200078fe8ffULL,
0x0000000112127824ULL, 0x100fe200078e0208ULL, 0x000000070a107812ULL, 0x000fe200078ec0ffULL,
0x000000010b0a7824ULL, 0x000fc400078e0208ULL, 0x0000000114147824ULL, 0x100fe200078e0208ULL,
0x0ffffff810107812ULL, 0x000fe200078ef803ULL, 0x0000000119197824ULL, 0x100fe400078e0208ULL,
0x000000011a1a7824ULL, 0x100fe400078e0208ULL, 0x000000011e1e7824ULL, 0x100fe400078e0208ULL,
0x0000000120207824ULL, 0x100fe400078e0208ULL, 0x0000000118187824ULL, 0x000fc400078e0208ULL,
0x0000000122227824ULL, 0x100fe400078e0208ULL, 0x0000000128287824ULL, 0x100fe400078e0208ULL,
0x0000000126267824ULL, 0x100fe400078e0208ULL, 0x000000010d247824ULL, 0x040fe400078e0208ULL,
0x000000010d0f7824ULL, 0x040fe400078e0203ULL, 0x000000080d487824ULL, 0x000fc400078e00ffULL,
0x0000008009087825ULL, 0x000fc600078e00ffULL, 0xfffffff848487812ULL, 0x000fe200078ee20fULL,
0x000020007c0b7824ULL, 0x000fe200078e0205ULL, 0x00000049080f7212ULL, 0x000fe200078efcffULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0x0000000f06087210ULL, 0x000fe20007f1e0ffULL,
0x000010000b1d7836ULL, 0x000fe20000000000ULL, 0x000000490c117212ULL, 0x000fe200078efcffULL,
0x000000800a0a7825ULL, 0x000fc800078e00ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000490a0f7212ULL, 0x000fc600078efcffULL, 0x0000000107097824ULL, 0x040fe200000e0609ULL,
0x0000000f060a7210ULL, 0x000fe20007f3e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x00000011060c7210ULL, 0x000fe40007f1e0ffULL, 0x0000004916117212ULL, 0x080fe200078efcffULL,
0x0000001010477824ULL, 0x000fe200078e021dULL, 0x000000490e1b7212ULL, 0x080fe200078efcffULL,
0x00000001070d7824ULL, 0x040fe400000e060dULL, 0x00000001070b7824ULL, 0x040fe200008e060bULL,
0x0000001b06107210ULL, 0x000fe20007f1e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x00000011060e7210ULL, 0x000fe20007f3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008477faeULL, 0x0003e4000b901c46ULL, 0x0000000107117824ULL, 0x040fe200000e060fULL,
0x00000049121f7212ULL, 0x000fe200078efcffULL, 0x00000001070f7824ULL, 0x000fc400008e0617ULL,
0x0000008019167825ULL, 0x000fe200078e00ffULL, 0x0000001f06127210ULL, 0x000fc60007f1e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000004916237212ULL, 0x000fc600078efcffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x00000049141b7212ULL, 0x000fc600078efcffULL,
0x0000000107137824ULL, 0x000fe200000e0613ULL, 0x0000002306167210ULL, 0x000fe20007f1e0ffULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000001b06147210ULL, 0x000fe40007f5e0ffULL,
0x000000491e257212ULL, 0x080fe200078efcffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000004920237212ULL, 0x000fc600078efcffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x000000491a277212ULL, 0x000fc600078efcffULL, 0x0000000107177824ULL, 0x040fe200000e0617ULL,
0x00000025061e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000107157824ULL, 0x000fe200010e0615ULL,
0x0000004918257212ULL, 0x080fe200078efcffULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x0000002306207210ULL, 0x000fe40007f5e0ffULL, 0x00000027061a7210ULL, 0x000fe20007f3e0ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x00000049284d7212ULL, 0x000fc600078efcffULL,
0x00000001071f7824ULL, 0x000fe200000e061fULL, 0x0000002506187210ULL, 0x000fe20007f1e0ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x00000049224f7212ULL, 0x000fc600078efcffULL,
0x000000102a457824ULL, 0x000fe200078e021dULL, 0x00000049264b7212ULL, 0x000fe200078efcffULL,
0x0000008024247825ULL, 0x000fc600078e00ffULL, 0x000000000a457faeULL, 0x0003e2000b901c46ULL,
0x000000102c437824ULL, 0x100fe200078e021dULL, 0x0000004924497212ULL, 0x000fe200078efcffULL,
0x000000102e3f7824ULL, 0x100fe400078e021dULL, 0x00000010303d7824ULL, 0x100fe200078e021dULL,
0x000000000c437faeULL, 0x0003e2000b901c46ULL, 0x00000010323b7824ULL, 0x100fe400078e021dULL,
0x0000001034397824ULL, 0x000fe200078e021dULL, 0x00000000103f7faeULL, 0x0003e2000b901c46ULL,
0x0000000107197824ULL, 0x040fe200000e0619ULL, 0x0000004f06227210ULL, 0x000fe20007f1e0ffULL,
0x0000001036377824ULL, 0x000fe200078e021dULL, 0x000000000e3d7faeULL, 0x0003e2000b901c46ULL,
0x00000001071b7824ULL, 0x040fe200008e061bULL, 0x0000004d06287210ULL, 0x000fe20007f3e0ffULL,
0x0000001038357824ULL, 0x000fe200078e021dULL, 0x00000000123b7faeULL, 0x0003e2000b901c46ULL,
0x0000000107217824ULL, 0x000fe200010e0621ULL, 0x0000004b06267210ULL, 0x000fe20007f5e0ffULL,
0x000000103a337824ULL, 0x100fe200078e021dULL, 0x0000004906067210ULL, 0x000fe20007f7e0ffULL,
0x000000103c317824ULL, 0x100fe200078e021dULL, 0x0000000014397faeULL, 0x0003e2000b901c46ULL,
0x000000103e2f7824ULL, 0x000fc400078e021dULL, 0x00000010422d7824ULL, 0x000fe200078e021dULL,
0x0000000016377faeULL, 0x0003e2000b901c46ULL, 0x0000000107237824ULL, 0x040fe400000e0623ULL,
0x00000010442b7824ULL, 0x000fe200078e021dULL, 0x000000001a357faeULL, 0x0003e2000b901c46ULL,
0x0000000107297824ULL, 0x040fe400008e0629ULL, 0x00000010462a7824ULL, 0x000fe200078e021dULL,
0x000000001e337faeULL, 0x0003e2000b901c46ULL, 0x0000000107277824ULL, 0x000fc400010e0627ULL,
0x00000010481d7824ULL, 0x000fe200078e021dULL, 0x0000000020317faeULL, 0x0003e2000b901c46ULL,
0x0000000107077824ULL, 0x000fc600018e0625ULL, 0x00000000182f7faeULL, 0x0003e8000b901c46ULL,
0x00000000222d7faeULL, 0x0003e8000b901c46ULL, 0x00000000282b7faeULL, 0x0003e8000b901c46ULL,
0x00000000262a7faeULL, 0x0003e8000b901c46ULL, 0x00000000061d7faeULL, 0x0003e4000b901c46ULL,
0x00000c0001087983ULL, 0x002ea20000100800ULL, 0x0000000272727836ULL, 0x000fe20000000000ULL,
0x00009600ff077b82ULL, 0x000e620000000800ULL, 0x0000000000067919ULL, 0x000e620000002700ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xfffffff803647812ULL, 0x040fe200078ec0ffULL,
0x0000000706067224ULL, 0x002fe200078e02ffULL, 0x000000087200720cULL, 0x004fe40003f06070ULL,
0x0000000703697812ULL, 0x000fe400078ec0ffULL, 0x0000000000167805ULL, 0x000fc4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00009200ff088b82ULL, 0x000e620000000a00ULL,
0x0000000206078824ULL, 0x000fe200078e0272ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0xffffffffff067424ULL, 0x000fe200078e00ffULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fc4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000407088825ULL, 0x002fca00078e0008ULL, 0x0000000608068981ULL, 0x000ea2000c1e1900ULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x0000000764647812ULL, 0x000fe400078ef803ULL,
0x00000008696e7812ULL, 0x000fe200078ef803ULL, 0x0000000601007387ULL, 0x0043e40000100800ULL,
0x000020001c067824ULL, 0x002fe200078e0205ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000002003057836ULL, 0x000fe40000000000ULL, 0x0000100006067836ULL, 0x000fc60000000000ULL,
0xfffffff805087812ULL, 0x000fc800078ec0ffULL, 0x0000000708057812ULL, 0x000fce00078ef803ULL,
0x0000000164087824ULL, 0x040fe200078e0207ULL, 0x00000004ff0a7819ULL, 0x000fe20000011603ULL,
0x0000000864097824ULL, 0x000fe400078e00ffULL, 0x00000008050b7824ULL, 0x040fe400078e00ffULL,
0x0000000107187836ULL, 0x000fe20000000000ULL, 0xfffffff809097812ULL, 0x000fe200078ee208ULL,
0x0000000105087824ULL, 0x040fe400078e0207ULL, 0x0000000805397824ULL, 0x000fc400078e00ffULL,
0x0000001009097824ULL, 0x000fe200078e0206ULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee208ULL,
0x0000000164087824ULL, 0x140fe400078e0218ULL, 0x0000000105187824ULL, 0x000fe200078e0218ULL,
0x00000000090c783bULL, 0x000e620000000200ULL, 0x000000100b107824ULL, 0x000fe400078e0206ULL,
0x00000008640b7824ULL, 0x000fe200078e00ffULL, 0xfffffff839187812ULL, 0x000fe200078ee218ULL,
0x0000000207197824ULL, 0x000fc400078e020aULL, 0x000000001010783bULL, 0x000ea20000000200ULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee208ULL, 0x000000106e1b7824ULL, 0x040fe200078e00ffULL,
0x000000026e737810ULL, 0x140fe20007ffe019ULL, 0x000000016e4a7824ULL, 0x040fe400078e0219ULL,
0x000000100b0b7824ULL, 0x100fe400078e0206ULL, 0x000000106e1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff01b4a7812ULL, 0x000fe200078ee24aULL, 0x0000001018187824ULL, 0x000fc400078e0206ULL,
0x000000000b08783bULL, 0x000ee20000000200ULL, 0xfffffff01a737812ULL, 0x000fe200078ee273ULL,
0x0000000207077836ULL, 0x000fe40000000000ULL, 0x000000001818783bULL, 0x000f260000000200ULL,
0x000000080700780cULL, 0x000fe40003f05270ULL, 0x00000010ff507819ULL, 0x002fe4000001160cULL,
0x0000ffff0c577812ULL, 0x000fc400078ec0ffULL, 0x00000018ff7a7819ULL, 0x000fe4000001160cULL,
0x000000ff0c787812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3b7819ULL, 0x104fe40000011610ULL,
0x00000018ff627819ULL, 0x000fe40000011610ULL, 0x000000ff105f7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff10437812ULL, 0x000fc400078ec0ffULL, 0x000000084a107c11ULL, 0x000fe4000f8e20ffULL,
0x00000010ff447819ULL, 0x100fe40000011611ULL, 0x00000018ff5c7819ULL, 0x000fe40000011611ULL,
0x000000ff11587812ULL, 0x040fe400078ec0ffULL, 0x0000ffff11457812ULL, 0x000fe400078ec0ffULL,
0x00000010ff387819ULL, 0x000fc40000011612ULL, 0x00000018ff527819ULL, 0x000fe40000011612ULL,
0x000000ff12517812ULL, 0x040fe400078ec0ffULL, 0x0000ffff12397812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3a7819ULL, 0x100fe40000011613ULL, 0x00000018ff3f7819ULL, 0x000fe40000011613ULL,
0x000000ff13427812ULL, 0x000fc400078ec0ffULL, 0x0000ffff133c7812ULL, 0x000fe400078ec0ffULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x000000ff507b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff797819ULL, 0x000fe40000011657ULL, 0x00000010ff597819ULL, 0x100fe4000001160dULL,
0x00000018ff767819ULL, 0x000fe4000001160dULL, 0x000000ff0d747812ULL, 0x000fc400078ec0ffULL,
0x0000ffff0d5d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4b7819ULL, 0x100fe4000001160eULL,
0x00000018ff4f7819ULL, 0x000fe4000001160eULL, 0x000000ff0e4e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff0e4c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4d7819ULL, 0x000fc4000001160fULL,
0x00000018ff667819ULL, 0x000fe4000001160fULL, 0x000000ff0f547812ULL, 0x040fe400078ec0ffULL,
0x0000ffff0f537812ULL, 0x000fe400078ec0ffULL, 0x00000018ff0f7819ULL, 0x008fe40000011608ULL,
0x000000ff080d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff0e7819ULL, 0x000fc40000011609ULL,
0x00000010ff557819ULL, 0x000fe40000011608ULL, 0x0000ffff08617812ULL, 0x000fe400078ec0ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x00000079ff79723eULL, 0x000fc400020006ffULL,
0x00000010ff5a7819ULL, 0x000fe40000011609ULL, 0x000000ff090c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff095b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff567819ULL, 0x100fe4000001160aULL,
0x00000018ff467819ULL, 0x000fe4000001160aULL, 0x000000ff0a477812ULL, 0x000fc400078ec0ffULL,
0x0000ffff0a3d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3e7819ULL, 0x100fe4000001160bULL,
0x00000018ff487819ULL, 0x000fe4000001160bULL, 0x000000ff0b497812ULL, 0x040fe400078ec0ffULL,
0x0000ffff0b087812ULL, 0x000fe400078ec0ffULL, 0x00000008ff657819ULL, 0x000fc40000011653ULL,
0x000000ff4b6d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6c7819ULL, 0x000fe4000001164cULL,
0x000000ff4d677812ULL, 0x000fe400078ec0ffULL, 0x000000ff38537812ULL, 0x000fe400078ec0ffULL,
0x0000000fff09723eULL, 0x000fe400020006ffULL, 0x0000000dff0a723eULL, 0x000fc400020006ffULL,
0x0000000eff0b723eULL, 0x000fe400020006ffULL, 0x00000010ff0d7819ULL, 0x110fe40000011618ULL,
0x00000018ff4a7819ULL, 0x000fe40000011618ULL, 0x000000ff184b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff180e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff0f7819ULL, 0x000fc40000011619ULL,
0x00000018ff4c7819ULL, 0x000fe40000011619ULL, 0x000000ff194d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff19387812ULL, 0x000fe400078ec0ffULL, 0x000000ff59777812ULL, 0x000fe400078ec0ffULL,
0x00000008ff757819ULL, 0x000fe4000001165dULL, 0x000054107b197816ULL, 0x000fc4000000007aULL,
0x0000541078187816ULL, 0x000fe40000000079ULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x00000077ff77723eULL, 0x000fe200020006ffULL,
0x000000181034723cULL, 0x002fe20000001834ULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x00000008ff607819ULL, 0x000fc40000011643ULL, 0x00000008ff577819ULL, 0x000fe40000011639ULL,
0x000000ff3a437812ULL, 0x000fe400078ec0ffULL, 0x0000541077197816ULL, 0x000fe40000000076ULL,
0x0000541074187816ULL, 0x000fe40000000075ULL, 0x00000010ff397819ULL, 0x100fe4000001161aULL,
0x00000018ff6b7819ULL, 0x000fc4000001161aULL, 0x000000ff1a6a7812ULL, 0x040fe200078ec0ffULL,
0x000000181030723cULL, 0x000fe20000001830ULL, 0x0000ffff1a3a7812ULL, 0x000fe400078ec0ffULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fc400020006ffULL,
0x00000008731a7c11ULL, 0x000fe4000f8e20ffULL, 0x000000ff445d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b637812ULL, 0x000fe400078ec0ffULL, 0x00000008ff597819ULL, 0x000fe40000011645ULL,
0x00000008ff447819ULL, 0x000fe4000001163cULL, 0x000054106d4f7816ULL, 0x000fc4000000004fULL,
0x000054104e4e7816ULL, 0x000fe4000000006cULL, 0x00000010ff3c7819ULL, 0x100fe4000001161bULL,
0x00000018ff507819ULL, 0x000fe4000001161bULL, 0x000000ff1b3b7812ULL, 0x040fe200078ec0ffULL,
0x0000004e102c723cULL, 0x000fe2000000182cULL, 0x0000ffff1b457812ULL, 0x000fe400078ec0ffULL,
0x000000001a18783bULL, 0x000e620000000200ULL, 0x00000066ff66723eULL, 0x000fc400020006ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x0000006aff4f723eULL, 0x000fe400020006ffULL,
0x000000ff556a7812ULL, 0x000fe400078ec0ffULL, 0x0000541067557816ULL, 0x000fc40000000066ULL,
0x0000541054547816ULL, 0x000fe40000000065ULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x000000541028723cULL, 0x000fe20000001828ULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000052ff52723eULL, 0x000fc400020006ffULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x0000541063557816ULL, 0x000fe40000000062ULL, 0x000054105f547816ULL, 0x000fe40000000060ULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000051ff51723eULL, 0x000fe200020006ffULL, 0x000000541024723cULL, 0x000fe20000001824ULL,
0x0000003fff3f723eULL, 0x000fc400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x00000044ff44723eULL, 0x000fc400020006ffULL, 0x0000541053537816ULL, 0x000fe40000000052ULL,
0x000054105d557816ULL, 0x000fe4000000005cULL, 0x0000541058547816ULL, 0x000fe40000000059ULL,
0x0000541051527816ULL, 0x000fe40000000057ULL, 0x0000541043437816ULL, 0x000fe4000000003fULL,
0x0000541042427816ULL, 0x000fe20000000044ULL, 0x000000541020723cULL, 0x000fe20000001820ULL,
0x00000008ff617819ULL, 0x000fc40000011661ULL, 0x0000006aff65723eULL, 0x000fe400020006ffULL,
0x00000061ff5f723eULL, 0x000fe200020006ffULL, 0x00000052101c723cULL, 0x000fe2000000181cULL,
0x000000ff56567812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3d7819ULL, 0x000fe4000001163dULL,
0x0000541065097816ULL, 0x000fe20000000009ULL, 0x000000421014723cULL, 0x000fe20000001814ULL,
0x00000046ff46723eULL, 0x000fc400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000056ff51723eULL, 0x000fe400020006ffULL, 0x00000008ff117819ULL, 0x000fe40000011608ULL,
0x000054100a087816ULL, 0x000fe4000000005fULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x000000ff3e3e7812ULL, 0x000fc400078ec0ffULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x000000081834723cULL, 0x002fe20000001834ULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x0000003eff10723eULL, 0x000fe400020006ffULL, 0x00000011ff11723eULL, 0x000fe400020006ffULL,
0x0000541051097816ULL, 0x000fe40000000046ULL, 0x0000541047087816ULL, 0x000fc4000000003dULL,
0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5b7819ULL, 0x000fe4000001165bULL,
0x000000ff0d0d7812ULL, 0x000fe200078ec0ffULL, 0x00000008182c723cULL, 0x000fe2000000182cULL,
0x00000008ff0e7819ULL, 0x000fe4000001160eULL, 0x0000000cff0c723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fc400020006ffULL, 0x0000541010097816ULL, 0x000fe40000000048ULL,
0x0000541049087816ULL, 0x000fe40000000011ULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x0000005aff55723eULL, 0x000fe400020006ffULL, 0x0000005bff54723eULL, 0x000fe200020006ffULL,
0x000000081828723cULL, 0x000fe20000001828ULL, 0x0000000dff0d723eULL, 0x000fc400020006ffULL,
0x0000000eff0e723eULL, 0x000fe400020006ffULL, 0x00005410550b7816ULL, 0x000fe4000000000bULL,
0x000054100c0a7816ULL, 0x000fe40000000054ULL, 0x000054100d097816ULL, 0x000fe4000000004aULL,
0x000054104b087816ULL, 0x000fe4000000000eULL, 0x000000ff0f0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000a1830723cULL, 0x000fe20000001830ULL, 0x00000008ff387819ULL, 0x000fc40000011638ULL,
0x000000ff39397812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3a7819ULL, 0x000fe2000001163aULL,
0x000000081824723cULL, 0x000fe20000001824ULL, 0x000000ff3c3c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff457819ULL, 0x000fe40000011645ULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x0000004dff4d723eULL, 0x000fc400020006ffULL, 0x0000006bff4e723eULL, 0x000fe400020006ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x0000000fff0f723eULL, 0x000fe400020006ffULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x00000039ff0a723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fc400020006ffULL, 0x0000003bff08723eULL, 0x000fe400020006ffULL,
0x0000003cff09723eULL, 0x000fe400020006ffULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x000054100f397816ULL, 0x000fe4000000004cULL, 0x000054104d387816ULL, 0x000fe40000000038ULL,
0x000054100a3b7816ULL, 0x000fc4000000004eULL, 0x000054104f3a7816ULL, 0x000fe4000000003aULL,
0x0000541009097816ULL, 0x000fe20000000050ULL, 0x000000381820723cULL, 0x000fe20000001820ULL,
0x0000541008087816ULL, 0x000fca0000000045ULL, 0x0000003a181c723cULL, 0x000fec000000181cULL,
0x000000081814723cULL, 0x000fe20000001814ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xfffffff0002c0947ULL, 0x000fde000383ffffULL, 0x00000001ff077424ULL, 0x000fe400078e00ffULL,
0x0000000434097220ULL, 0x080fe20000410000ULL, 0x0000000435357220ULL, 0x080fe20000410000ULL,
0x0000000436367220ULL, 0x080fe20000410000ULL, 0x0000000437377220ULL, 0x080fe20000410000ULL,
0x0000000430307220ULL, 0x080fe20000410000ULL, 0x017688075e0679a7ULL, 0x000e62000850003fULL,
0x0000000431317220ULL, 0x080fe20000410000ULL, 0x0000000432327220ULL, 0x080fe20000410000ULL,
0x0000000433337220ULL, 0x080fe20000410000ULL, 0x000000042c2c7220ULL, 0x080fe20000410000ULL,
0x000000042d2d7220ULL, 0x080fe20000410000ULL, 0x000000042e2e7220ULL, 0x080fe20000410000ULL,
0x000000042f2f7220ULL, 0x080fe20000410000ULL, 0x0000000428287220ULL, 0x080fe20000410000ULL,
0x0000000429297220ULL, 0x080fe20000410000ULL, 0x000000042a2a7220ULL, 0x080fe20000410000ULL,
0x000000042b2b7220ULL, 0x080fe20000410000ULL, 0x0000000424247220ULL, 0x080fe20000410000ULL,
0x0000000425257220ULL, 0x080fe20000410000ULL, 0x0000000426267220ULL, 0x080fe20000410000ULL,
0x0000000427277220ULL, 0x080fe20000410000ULL, 0x0000000420207220ULL, 0x080fe20000410000ULL,
0x0000000421217220ULL, 0x080fe20000410000ULL, 0x0000000422227220ULL, 0x080fe20000410000ULL,
0x0000000423237220ULL, 0x080fe20000410000ULL, 0x000000041c1c7220ULL, 0x080fe20000410000ULL,
0x000000041d1d7220ULL, 0x080fe20000410000ULL, 0x000000041e117220ULL, 0x080fe20000410000ULL,
0x000000041f127220ULL, 0x080fe20000410000ULL, 0x0000000414087220ULL, 0x080fe20000410000ULL,
0x0000000415187220ULL, 0x080fe20000410000ULL, 0x0000000416107220ULL, 0x080fe20000410000ULL,
0x0000000417137220ULL, 0x000fe20000410000ULL, 0x00000000000a7805ULL, 0x000fe20000015200ULL,
0x017688075e0075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0e7224ULL, 0x000fce00078e00ffULL, 0x000000100e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e0bULL,
0x003d09000c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140dULL, 0x0000000c05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0c7224ULL, 0x000fca00000e060dULL, 0x0000000205057819ULL, 0x000fc8000000120cULL,
0x000000050000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010e0e7836ULL, 0x000fce0000000000ULL, 0x017688075e0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00001400010c7983ULL, 0x000ea20000100800ULL,
0x0000000403057824ULL, 0x000fe200078e00ffULL, 0x0000000802067c11ULL, 0x000fc8000f8e38ffULL,
0xfffffff005057812ULL, 0x000fca00078ec0ffULL, 0x0000000106057824ULL, 0x000fca00078e0205ULL,
0x0174000005147984ULL, 0x0002620000000c00ULL, 0x0000000c6f00720cULL, 0x004fda0003f06070ULL,
0x00000014002c8947ULL, 0x002fea0003800000ULL, 0x0000180001197983ULL, 0x000ea20000100800ULL,
0x0000860000047ab9ULL, 0x000fc60000000800ULL, 0x00000400010f7983ULL, 0x000ee20000100800ULL,
0x00000004000b7d06ULL, 0x000e620008209000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00000004ff007c0cULL, 0x000fe2000bf85070ULL, 0xffffff00701a7836ULL, 0x000fe20000000000ULL,
0x00000004ff0e7c12ULL, 0x000fc8000f8e33ffULL, 0x0000000b000b7308ULL, 0x002e640000001000ULL,
0x0ffffffe0b0c7836ULL, 0x002fcc0000000000ULL, 0x0000000c00077305ULL, 0x000e64000021f000ULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a07ULL, 0x000000040d0d7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000d070d7227ULL, 0x000fe200078e0006ULL, 0x0000001903067211ULL, 0x004fc600078ff0ffULL,
0x0000000203197824ULL, 0x000fe400078e00ffULL, 0x000000060d0a7227ULL, 0x000fc600078e00ffULL,
0x0000000619197812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a0aULL,
0x00000001191b7824ULL, 0x000fe400078e0200ULL, 0x0000000407077c24ULL, 0x000fe4000f8e0206ULL,
0x0000000806067836ULL, 0x000fc60000000000ULL, 0x0000000407007c0cULL, 0x000fe2000bf06070ULL,
0x000000060d0d7227ULL, 0x000fc800078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc800078e0a0dULL,
0x000000040b067c24ULL, 0x000fe4000f8e0206ULL, 0x00000001710b7824ULL, 0x000fe400078e0219ULL,
0x8000000407070c36ULL, 0x000fe20008000000ULL, 0x0000000406007c0cULL, 0x000fe2000bf46070ULL,
0x000000010a0a0836ULL, 0x000fc60000000000ULL, 0x0000000407007c0cULL, 0x000fe4000bf26070ULL,
0x0000001a0f077248ULL, 0x008fca0007fe0000ULL, 0x00000001071a7824ULL, 0x000fe400078e0a1aULL,
0x8000000406062c36ULL, 0x000fe40008000000ULL, 0x000000ffff4f7224ULL, 0x000fe200078e0a1aULL,
0x0000001a0b00720cULL, 0x000fe20003f66070ULL, 0x000000010a0a1836ULL, 0x000fe20000000000ULL,
0x0000000406007c0cULL, 0x000fe2000bf06070ULL, 0x000000010d0d2836ULL, 0x000fe20000000000ULL,
0x0000004f0b0b7246ULL, 0x000fe40003800068ULL, 0x0000000a0e077207ULL, 0x000fc40006000000ULL,
0x00000004ff0b7819ULL, 0x000fe4000001160bULL, 0x0000000768077248ULL, 0x000fe40003fe0000ULL,
0x000000ff0b0c7207ULL, 0x000fe40001800000ULL, 0x0000001a1b00720cULL, 0x000fe20003f26070ULL,
0x0000000507517c24ULL, 0x000fe2000f8e02ffULL, 0x0000004f1b447246ULL, 0x000fe20003800068ULL,
0x000000010d0d0836ULL, 0x000fe40000000000ULL, 0x0000000151077824ULL, 0x000fe200078e020cULL,
0x0000001019397812ULL, 0x000fc400078efcffULL, 0x000000ff44447207ULL, 0x000fe20000800000ULL,
0x0000000207067825ULL, 0x100fe200078e0040ULL, 0x0000000d0e0d7207ULL, 0x000fe40006000000ULL,
0x00000051440b7211ULL, 0x000fe400078fe0ffULL, 0x0000000606487981ULL, 0x0002a2000c1e9500ULL,
0x0000000d680d7248ULL, 0x000fe40003fe0000ULL, 0x000000020b0a7825ULL, 0x000fc800078e0040ULL,
0x0000000171077824ULL, 0x002fe200078e0239ULL, 0x000000060a4d7981ULL, 0x0002a8000c1e9500ULL,
0x0000004f07067246ULL, 0x000fe40003800068ULL, 0x0000001a0700720cULL, 0x000fe40003f26070ULL,
0x00000004ff067819ULL, 0x000fe20000011606ULL, 0x000000050d537c24ULL, 0x000fe2000f8e02ffULL,
0x00000020193d7812ULL, 0x000fc400078efcffULL, 0x000000ff06387207ULL, 0x000fe20000800000ULL,
0x00000001391f7824ULL, 0x000fe200078e0200ULL, 0x00000053440f7211ULL, 0x000fe200078fe0ffULL,
0x000000010c0d7824ULL, 0x000fe400078e0253ULL, 0x0000000151077824ULL, 0x000fe400078e0238ULL,
0x0000000171437824ULL, 0x000fe200078e023dULL, 0x0000001a1f00720cULL, 0x000fe20003f06070ULL,
0x0000000207067825ULL, 0x000fe200078e0040ULL, 0x0000004f1f1e7246ULL, 0x000fc40003800068ULL,
0x0000004f433a7246ULL, 0x000fe20003800068ULL, 0x000000020d0c7825ULL, 0x000fc800078e0040ULL,
0x000000020f0e7825ULL, 0x000fe200078e0040ULL, 0x000000ff1e1e7207ULL, 0x000fe20000000000ULL,
0x0000000606347981ULL, 0x000722000c1e9500ULL, 0x0000001a4300720cULL, 0x000fc60003f26070ULL,
0x000000060c427981ULL, 0x000b22000c1e9500ULL, 0x000000511e0b7211ULL, 0x002fc600078fe0ffULL,
0x000000060e557981ULL, 0x000322000c1e9500ULL, 0x00000004ff067819ULL, 0x008fe2000001163aULL,
0x000000013d3f7824ULL, 0x000fe200078e0200ULL, 0x0000003019457812ULL, 0x000fe200078efcffULL,
0x00000001380d7824ULL, 0x020fe200078e0253ULL, 0x000000ff063e7207ULL, 0x000fe40000800000ULL,
0x000000531e0f7211ULL, 0x002fe200078fe0ffULL, 0x000000020b0a7825ULL, 0x100fe200078e0040ULL,
0x0000001a3f00720cULL, 0x000fe40003f06070ULL, 0x0000004f3f3a7246ULL, 0x000fe20003800068ULL,
0x000000020d0c7825ULL, 0x100fe200078e0040ULL, 0x000000060a3b7981ULL, 0x0002e6000c1e9500ULL,
0x000000020f0e7825ULL, 0x000fe200078e0040ULL, 0x000000ff3a3a7207ULL, 0x000fe20000000000ULL,
0x000000060c387981ULL, 0x000ae4000c1e9500ULL, 0x0000000151077824ULL, 0x000fc400078e023eULL,
0x0000000171577824ULL, 0x000fe200078e0245ULL, 0x000000060e437981ULL, 0x000ae2000c1e9500ULL,
0x0000000207067825ULL, 0x000fe200078e0040ULL, 0x000000513a0b7211ULL, 0x002fe400078fe0ffULL,
0x0000004f57467246ULL, 0x000fe20003800068ULL, 0x0000000145497824ULL, 0x000fe200078e0200ULL,
0x00000006063c7981ULL, 0x0002e2000c1e9500ULL, 0x000000013e0d7824ULL, 0x020fe200078e0253ULL,
0x000000533a0f7211ULL, 0x000fe200078fe0ffULL, 0x000000020b0a7825ULL, 0x000fe200078e0040ULL,
0x0000001a5700720cULL, 0x000fc40003f26070ULL, 0x0000001a4900720cULL, 0x000fe40003f06070ULL,
0x00000004ff067819ULL, 0x002fe20000011646ULL, 0x000000020d0c7825ULL, 0x100fe200078e0040ULL,
0x0000004f49467246ULL, 0x000fe20003800068ULL, 0x000000060a477981ULL, 0x000364000c1e9500ULL,
0x000000020f0e7825ULL, 0x000fe200078e0040ULL, 0x000000ff064a7207ULL, 0x000fe20000800000ULL,
0x000000060c3e7981ULL, 0x000362000c1e9500ULL, 0x000000ff46467207ULL, 0x000fc60000000000ULL,
0x000000060e4b7981ULL, 0x000362000c1e9500ULL, 0x0000000151077824ULL, 0x000fe200078e024aULL,
0x00000051460b7211ULL, 0x002fc600078fe0ffULL, 0x0000000207067825ULL, 0x000fc800078e0040ULL,
0x000000020b0a7825ULL, 0x000fe400078e0040ULL, 0x0000000606067981ULL, 0x000362000c1e9500ULL,
0x00000053460d7211ULL, 0x000fc600078fe0ffULL, 0x000000060a0b7981ULL, 0x000f62000c1e9500ULL,
0x000000014a0f7824ULL, 0x000fe400078e0253ULL, 0x000000020d0c7825ULL, 0x000fc800078e0040ULL,
0x000000020f0e7825ULL, 0x000fe400078e0040ULL, 0x000000060c0c7981ULL, 0x000368000c1e9500ULL,
0x000000060e0f7981ULL, 0x000362000c1e9500ULL, 0xfffffff044517812ULL, 0x000fe200078ec0ffULL,
0x00000001ff447424ULL, 0x000fc800078e00ffULL, 0x000000011a4a7824ULL, 0x000fc800078e0251ULL,
0x000000011b577824ULL, 0x000fe200078e0a4aULL, 0x0000000919077812ULL, 0x002fc800078efcffULL,
0x0000005744577219ULL, 0x000fe200000006ffULL, 0x00000001070d7824ULL, 0x000fe200078e0200ULL,
0x00000001194f7812ULL, 0x000fc600078efcffULL, 0x000000010d5d7824ULL, 0x000fe400078e0a4aULL,
0x000000014f537824ULL, 0x000fe200078e0200ULL, 0x00000011196b7812ULL, 0x000fe400078efcffULL,
0xfffffff01e797812ULL, 0x000fe200078ec0ffULL, 0x0000000153597824ULL, 0x000fe200078e0a4aULL,
0x0000001819677812ULL, 0x000fe400078efcffULL, 0x0000005d445d7219ULL, 0x000fe200000006ffULL,
0x000000016b757824ULL, 0x100fe200078e0200ULL, 0x0000001919657812ULL, 0x000fe200078efcffULL,
0x000000011a0a7824ULL, 0x000fe200078e0279ULL, 0x0000005944597219ULL, 0x000fe200000006ffULL,
0x0000000167737824ULL, 0x100fe200078e0200ULL, 0xfffffff046467812ULL, 0x000fe200078ec0ffULL,
0x00000001656d7824ULL, 0x000fe200078e0200ULL, 0xfffffff03a7b7812ULL, 0x000fe200078ec0ffULL,
0x00000001751e7824ULL, 0x000fc400078e0a0aULL, 0x000000011f0e7824ULL, 0x100fe400078e0a0aULL,
0x00000001733a7824ULL, 0x000fc600078e0a0aULL, 0x0000000e440e7219ULL, 0x000fe200000006ffULL,
0x000000011a547824ULL, 0x000fe200078e027bULL, 0x00000021195f7812ULL, 0x000fc600078efcffULL,
0x000000013f567824ULL, 0x000fe400078e0a54ULL, 0x000000015f637824ULL, 0x000fc800078e0200ULL,
0x0000000163507824ULL, 0x000fca00078e0a54ULL, 0x0000005044507219ULL, 0x000fe400000006ffULL,
0x000054104d487816ULL, 0x004fe40000000048ULL, 0x00000008194d7812ULL, 0x000fe400078efcffULL,
0x0000004857ff7212ULL, 0x000fc6000780c0ffULL, 0x000000014d517824ULL, 0x000fe200078e0200ULL,
0x0000001a1b00720cULL, 0x000fc60000701470ULL, 0x00000001515b7824ULL, 0x000fe200078e0a4aULL,
0x0000001a1900720cULL, 0x000fc800007a1070ULL, 0x0000005b445b7219ULL, 0x000fe400000006ffULL,
0xff80000009097808ULL, 0x000fe40002800000ULL, 0x0000004859ff7212ULL, 0x080fe4000782c0ffULL,
0x000000485bff7212ULL, 0x080fe4000786c0ffULL, 0x000000485dff7212ULL, 0x000fe2000788c0ffULL,
0x000000011a487824ULL, 0x000fe400078e0246ULL, 0x000000016d467824ULL, 0x000fe200078e0a0aULL,
0x0000541055427816ULL, 0x010fc80000000042ULL, 0x0000004257ff7212ULL, 0x080fe4000784c0ffULL,
0x000000425bff7212ULL, 0x080fe400078cc0ffULL, 0x000000425dff7212ULL, 0x000fe400078ac0ffULL,
0x0000001a1b00720cULL, 0x080fe40001741470ULL, 0x0000001a5100720cULL, 0x080fe400037c1470ULL,
0x0000001a0d00720cULL, 0x000fc40002fa1470ULL, 0x0000001e440a7219ULL, 0x040fe400000006ffULL,
0x0000001a1900720cULL, 0x080fe40001741070ULL, 0x0000001a4d00720cULL, 0x080fe400037c1070ULL,
0x0000001a0700720cULL, 0x000fe40002fa1070ULL, 0x0000003a441e7219ULL, 0x000fe400000006ffULL,
0x000054103b3b7816ULL, 0x008fc40000000034ULL, 0x0000541043437816ULL, 0x000fe40000000038ULL,
0xff80000036367808ULL, 0x000fe40001000000ULL, 0xff80000032327808ULL, 0x000fe40003000000ULL,
0xff80000033337808ULL, 0x000fe40002800000ULL, 0x0000004259ff7212ULL, 0x000fe4000780c0ffULL,
0x0000003b0eff7212ULL, 0x000fc4000784c0ffULL, 0x000000430eff7212ULL, 0x080fe400078cc0ffULL,
0x000000431eff7212ULL, 0x000fe400078ac0ffULL, 0x0000001a5300720cULL, 0x0c0fe40000f21470ULL,
0x0000001a5300720cULL, 0x080fe40000701470ULL, 0x0000001a5100720cULL, 0x080fe40001f61470ULL,
0x0000001a0d00720cULL, 0x000fc40002781470ULL, 0x0000001a1f00720cULL, 0x0c0fe40001741470ULL,
0x0000001a1f00720cULL, 0x080fe400037c1470ULL, 0x0000001a7300720cULL, 0x080fe40002fa1470ULL,
0x00000028195d7812ULL, 0x040fe400078efcffULL, 0x00000029195b7812ULL, 0x000fe400078efcffULL,
0x0000001a4f00720cULL, 0x000fc40000f21070ULL, 0x0000001a4f00720cULL, 0x080fe40000701070ULL,
0x0000001a4d00720cULL, 0x080fe40001f61070ULL, 0x0000001a0700720cULL, 0x080fe40002781070ULL,
0x0000001a3900720cULL, 0x0c0fe40001741070ULL, 0x0000001a3900720cULL, 0x080fe400037c1070ULL,
0x0000001a6700720cULL, 0x000fc40002fa1070ULL, 0x0000004644467219ULL, 0x040fe400000006ffULL,
0x00000056443a7219ULL, 0x000fe400000006ffULL, 0x0000541047477816ULL, 0x020fe4000000003cULL,
0x000054104b4b7816ULL, 0x000fe2000000003eULL, 0x000000015d617824ULL, 0x100fe200078e0200ULL,
0xff80000035357808ULL, 0x000fe20000800000ULL, 0x000000015b777824ULL, 0x000fe200078e0200ULL,
0xff80000037377808ULL, 0x000fc40000000000ULL, 0xff80000030307808ULL, 0x000fe40001800000ULL,
0xff80000031317808ULL, 0x000fe40002000000ULL, 0xff8000002c2c7808ULL, 0x000fe40001000000ULL,
0xff8000002e2e7808ULL, 0x000fe40003000000ULL, 0xff8000002a2a7808ULL, 0x000fe40002800000ULL,
0x0000003b0aff7212ULL, 0x000fc4000782c0ffULL, 0x0000003b1eff7212ULL, 0x080fe4000780c0ffULL,
0x0000003b46ff7212ULL, 0x000fe4000786c0ffULL, 0x000000430aff7212ULL, 0x080fe4000788c0ffULL,
0x0000004346ff7212ULL, 0x000fe4000784c0ffULL, 0x000000473aff7212ULL, 0x040fe400078cc0ffULL,
0x0000004b3aff7212ULL, 0x000fe200078ac0ffULL, 0x0000000161527824ULL, 0x100fe200078e0a54ULL,
0x0000001a7500720cULL, 0x080fe20000f21470ULL, 0x0000000177547824ULL, 0x000fe200078e0a54ULL,
0x0000001a7500720cULL, 0x080fe20002781470ULL, 0x00000001494e7824ULL, 0x000fe200078e0a48ULL,
0x0000001a7300720cULL, 0x000fc40000701470ULL, 0x0000001a6d00720cULL, 0x0c0fe40001f61470ULL,
0x0000001a6d00720cULL, 0x080fe40001741470ULL, 0x0000001a3f00720cULL, 0x0c0fe400037c1470ULL,
0x0000001a3f00720cULL, 0x000fe40002fa1470ULL, 0x0000003119597812ULL, 0x040fe400078efcffULL,
0x0000003819577812ULL, 0x000fc400078efcffULL, 0x0000003919557812ULL, 0x000fe400078efcffULL,
0x0000001a6b00720cULL, 0x0c0fe40000f21070ULL, 0x0000001a6b00720cULL, 0x080fe40002781070ULL,
0x0000001a6700720cULL, 0x080fe40000701070ULL, 0x0000001a6500720cULL, 0x0c0fe40001f61070ULL,
0x0000001a6500720cULL, 0x000fc40001741070ULL, 0x0000001a3d00720cULL, 0x0c0fe400037c1070ULL,
0x0000001a3d00720cULL, 0x000fe40002fa1070ULL, 0x0000005244527219ULL, 0x040fe400000006ffULL,
0x0000005444547219ULL, 0x040fe400000006ffULL, 0x0000004e444e7219ULL, 0x000fe400000006ffULL,
0x000054100b0b7816ULL, 0x000fe20000000006ULL, 0x0000000159427824ULL, 0x100fe200078e0200ULL,
0xff8000002d2d7808ULL, 0x000fe20000800000ULL, 0x00000001577b7824ULL, 0x100fe200078e0200ULL,
0xff8000002f2f7808ULL, 0x000fe20002000000ULL, 0x0000000155797824ULL, 0x000fe200078e0200ULL,
0xff80000028287808ULL, 0x000fc40000000000ULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff80000024247808ULL, 0x000fe40003000000ULL,
0xff80000026267808ULL, 0x000fe40002800000ULL, 0x0000004750ff7212ULL, 0x080fe4000782c0ffULL,
0x0000004752ff7212ULL, 0x000fc4000788c0ffULL, 0x0000004754ff7212ULL, 0x000fe4000780c0ffULL,
0x0000004b50ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004b52ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004b54ff7212ULL, 0x000fe400078cc0ffULL, 0x0000000b4eff7212ULL, 0x000fe200078ac0ffULL,
0x00000001424c7824ULL, 0x100fe200078e0a48ULL, 0x0000001a6300720cULL, 0x080fe20000f21470ULL,
0x000000017b4a7824ULL, 0x100fe200078e0a48ULL, 0x0000001a6300720cULL, 0x080fe20001f61470ULL,
0x0000000179487824ULL, 0x000fe200078e0a48ULL, 0x0000001a6100720cULL, 0x000fc40002781470ULL,
0x0000001a6100720cULL, 0x080fe40001741470ULL, 0x0000001a7700720cULL, 0x0c0fe40000701470ULL,
0x0000001a7700720cULL, 0x080fe400037c1470ULL, 0x0000001a4900720cULL, 0x080fe40002fa1470ULL,
0x0000001a5f00720cULL, 0x0c0fe40000f21070ULL, 0x0000001a5f00720cULL, 0x000fc40001f61070ULL,
0x0000001a5d00720cULL, 0x0c0fe40002781070ULL, 0x0000001a5d00720cULL, 0x080fe40001741070ULL,
0x0000001a5b00720cULL, 0x0c0fe40000701070ULL, 0x0000001a5b00720cULL, 0x080fe400037c1070ULL,
0x0000001a4500720cULL, 0x000fe40002fa1070ULL, 0x0000004c444c7219ULL, 0x000fc400000006ffULL,
0x0000004a444a7219ULL, 0x040fe400000006ffULL, 0x0000004844487219ULL, 0x000fe400000006ffULL,
0x000054100c0f7816ULL, 0x000fe4000000000fULL, 0xff80000025257808ULL, 0x000fe40000800000ULL,
0xff80000027277808ULL, 0x000fe40001800000ULL, 0xff80000020207808ULL, 0x000fc40002000000ULL,
0xff80000022227808ULL, 0x000fe40001000000ULL, 0xff80000021217808ULL, 0x000fe40000000000ULL,
0xff80000023237808ULL, 0x000fe40003000000ULL, 0xff8000001c1c7808ULL, 0x000fe40002800000ULL,
0x0000000b4cff7212ULL, 0x080fe4000782c0ffULL, 0x0000000b4aff7212ULL, 0x000fc4000786c0ffULL,
0x0000000b48ff7212ULL, 0x000fe4000788c0ffULL, 0x0000000f4eff7212ULL, 0x080fe4000784c0ffULL,
0x0000000f4cff7212ULL, 0x080fe4000780c0ffULL, 0x0000000f4aff7212ULL, 0x080fe400078cc0ffULL,
0x0000000f48ff7212ULL, 0x000fe400078ac0ffULL, 0x0000001a4900720cULL, 0x000fc40001741470ULL,
0x0000001a4200720cULL, 0x0c0fe40000f21470ULL, 0x0000001a4200720cULL, 0x080fe40000701470ULL,
0x0000001a7b00720cULL, 0x0c0fe40001f61470ULL, 0x0000001a7b00720cULL, 0x080fe400037c1470ULL,
0x0000001a7900720cULL, 0x0c0fe40002781470ULL, 0x0000001a7900720cULL, 0x000fc40002fa1470ULL,
0x0000001a4500720cULL, 0x080fe40001741070ULL, 0x0000001a5900720cULL, 0x0c0fe40000f21070ULL,
0x0000001a5900720cULL, 0x080fe40000701070ULL, 0x0000001a5700720cULL, 0x0c0fe40001f61070ULL,
0x0000001a5700720cULL, 0x080fe400037c1070ULL, 0x0000001a5500720cULL, 0x000fc40002781070ULL,
0x0000001a5500720cULL, 0x000fe40002fa1070ULL, 0xff8000001d1d7808ULL, 0x000fe40000800000ULL,
0xff80000008087808ULL, 0x000fe40001800000ULL, 0xff80000018187808ULL, 0x000fe40002000000ULL,
0xff80000011117808ULL, 0x000fe40001000000ULL, 0xff80000012127808ULL, 0x000fc40000000000ULL,
0xff80000010107808ULL, 0x000fe40003000000ULL, 0xff80000013137808ULL, 0x000fce0002800000ULL,
0x000000091400720bULL, 0x000fe20003f1e000ULL, 0x0000080001387983ULL, 0x000ee20000100800ULL,
0xfffffff8ff697812ULL, 0x000fe200078ee269ULL, 0x000000016f6f7836ULL, 0x000fe20000000000ULL,
0x0000001409147208ULL, 0x000fc80004000000ULL, 0x000000351400720bULL, 0x000fc80003f1e000ULL,
0x0000001435077208ULL, 0x000fc80004000000ULL, 0x000000300700720bULL, 0x000fc80003f1e000ULL,
0x0000000730067208ULL, 0x000fc80004000000ULL, 0x000000310600720bULL, 0x000fc80003f1e000ULL,
0x0000000631077208ULL, 0x000fc80004000000ULL, 0x0000002c0700720bULL, 0x000fc80003f1e000ULL,
0x000000072c067208ULL, 0x000fc80004000000ULL, 0x0000002d0600720bULL, 0x000fc80003f1e000ULL,
0x000000062d077208ULL, 0x000fc80004000000ULL, 0x000000280700720bULL, 0x000fc80003f1e000ULL,
0x0000000728067208ULL, 0x000fc80004000000ULL, 0x000000290600720bULL, 0x000fc80003f1e000ULL,
0x0000000629077208ULL, 0x000fc80004000000ULL, 0x000000240700720bULL, 0x000fc80003f1e000ULL,
0x0000000724067208ULL, 0x000fc80004000000ULL, 0x000000250600720bULL, 0x000fc80003f1e000ULL,
0x0000000625077208ULL, 0x000fc80004000000ULL, 0x000000200700720bULL, 0x000fc80003f1e000ULL,
0x0000000720067208ULL, 0x000fe40004000000ULL, 0x000000361500720bULL, 0x000fe40003f1e000ULL,
0x000000210600720bULL, 0x000fc80003f3e000ULL, 0x0000000621077208ULL, 0x000fe40004800000ULL,
0x0000001536067208ULL, 0x000fe40004000000ULL, 0x0000001c0700720bULL, 0x000fe40003f3e000ULL,
0x000000370600720bULL, 0x000fe40003f1e000ULL, 0x000000071c0a7208ULL, 0x000fe40004800000ULL,
0x0000000637077208ULL, 0x000fc40004000000ULL, 0x0000001d0a00720bULL, 0x000fe40003f3e000ULL,
0x000000320700720bULL, 0x000fe40003f1e000ULL, 0x0000000a1d0b7208ULL, 0x000fe40004800000ULL,
0x0000000732067208ULL, 0x000fe40004000000ULL, 0x000000080b00720bULL, 0x000fe40003f3e000ULL,
0x000000330600720bULL, 0x000fc40003f1e000ULL, 0x0000000b080b7208ULL, 0x000fe40004800000ULL,
0x0000000633077208ULL, 0x000fe40004000000ULL, 0x000000180b00720bULL, 0x000fe40003f3e000ULL,
0x0000002e0700720bULL, 0x000fe40003f1e000ULL, 0x0000000b180b7208ULL, 0x000fe40004800000ULL,
0x000000072e067208ULL, 0x000fc60004000000ULL, 0x0c401f000b0a7f89ULL, 0x000e6200000e0000ULL,
0x0000002f0600720bULL, 0x000fc80003f1e000ULL, 0x000000062f077208ULL, 0x000fc80004000000ULL,
0x0000002a0700720bULL, 0x000fc80003f1e000ULL, 0x000000072a067208ULL, 0x000fc80004000000ULL,
0x0000002b0600720bULL, 0x000fc80003f1e000ULL, 0x000000062b077208ULL, 0x000fe40004000000ULL,
0x0000000a0b00720bULL, 0x002fe40003f3e000ULL, 0x000000260700720bULL, 0x000fe40003f1e000ULL,
0x0000000b0a0a7208ULL, 0x000fe40004800000ULL, 0x0000000726067208ULL, 0x000fc60004000000ULL,
0x0c201f000a0b7f89ULL, 0x000e6200000e0000ULL, 0x000000270600720bULL, 0x000fc80003f1e000ULL,
0x0000000627077208ULL, 0x000fc80004000000ULL, 0x000000220700720bULL, 0x000fc80003f1e000ULL,
0x0000000722067208ULL, 0x000fc80004000000ULL, 0x000000230600720bULL, 0x000fc80003f1e000ULL,
0x0000000623067208ULL, 0x000fe40004000000ULL, 0x0000000b0a00720bULL, 0x002fe40003f3e000ULL,
0x000000110600720bULL, 0x000fe40003f1e000ULL, 0x0000000a0b147208ULL, 0x000fe40004800000ULL,
0x0000000611077208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b140a7820ULL, 0x000fe20000410000ULL,
0x000000120700720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b09097823ULL, 0x100fe2000001080aULL,
0x0000000712077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001080aULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001080aULL,
0x000000100700720bULL, 0x000fe20003f1e000ULL, 0x0000000900097308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b24197823ULL, 0x100fe2000001080aULL,
0x0000000710067208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b20247823ULL, 0x100fe2000001080aULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080aULL,
0x000000130600720bULL, 0x000fe20003f1e000ULL, 0x00000035000c7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b251a7823ULL, 0x100fe2000001080aULL,
0x0000000613067208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001080aULL,
0x3fb8aa3b1c1b7823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b08207823ULL, 0x000fc4000001080aULL,
0x0c401f0006077f89ULL, 0x000ea200000e0000ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x000000090c08723eULL, 0x002fce00000000ffULL, 0x0000003100317308ULL, 0x000e700000000800ULL,
0x00000028000e7308ULL, 0x0009e20000000800ULL, 0x000000070600720bULL, 0x004fce0003f1e000ULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1d287823ULL, 0x110fe2000001080aULL,
0x3fb8aa3b180a7823ULL, 0x000fe2000001080aULL, 0x0000000607067208ULL, 0x000fe20004000000ULL,
0x3c003c00ff077424ULL, 0x000fc800078e00ffULL, 0x0c201f0006157f89ULL, 0x000ea200000e0000ULL,
0x0000000a00357308ULL, 0x0003f00000000800ULL, 0x0000002d002d7308ULL, 0x000f220000000800ULL,
0x00000030310a723eULL, 0x002fce00000000ffULL, 0x0000002900297308ULL, 0x000e620000000800ULL,
0x000000150600720bULL, 0x004fce0003f1e000ULL, 0x0000002100257308ULL, 0x0005e20000000800ULL,
0x0000002c2d0c723eULL, 0x010fe400000000ffULL, 0x0000000615157208ULL, 0x000fe40004000000ULL,
0x0000000e290e723eULL, 0x002fc600000000ffULL, 0x3fb8aa3b15347820ULL, 0x000fe20000410000ULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x0c401f0016217f89ULL, 0x004e6400000e0000ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010834ULL,
0x00000032000b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b11297823ULL, 0x000fe20000010834ULL,
0x0000003300067308ULL, 0x000eb00000000800ULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x000000211600720bULL, 0x002fc80003f1e000ULL, 0x0000001621167208ULL, 0x000fe40004000000ULL,
0x0000000b060b723eULL, 0x004fe200000000ffULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x3c003c00ff067424ULL, 0x000fe200078e00ffULL, 0x0000000802217c11ULL, 0x000fcc000f8e58ffULL,
0x0000002e000d7308ULL, 0x000fe20000000800ULL, 0x000000363709723eULL, 0x002fce00000000ffULL,
0x0000002f00187308ULL, 0x000e620000000800ULL, 0x00000006081c723cULL, 0x000fee00000018ffULL,
0x0000002a000f7308ULL, 0x0005e20000000800ULL, 0x0000000d180d723eULL, 0x002fce00000000ffULL,
0x0000002b00307308ULL, 0x0003220000000800ULL, 0x0c401f0017187f89ULL, 0x000f6200000e0000ULL,
0x3fb8aa3b122a7823ULL, 0x004fcc0000010834ULL, 0x0000001a001a7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b102b7823ULL, 0x102fe20000010834ULL, 0x3fb8aa3b13347823ULL, 0x000fe20000010834ULL,
0x0000000f300f723eULL, 0x010fca00000000ffULL, 0x0000002400247308ULL, 0x000e640000000800ULL,
0x000000060c1c723cULL, 0x000fe2000000181cULL, 0x000000191a10723eULL, 0x004fca00000000ffULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x000000181700720bULL, 0x020fc80003f3e000ULL,
0x0000001718177208ULL, 0x000fe40004800000ULL, 0x000000242512723eULL, 0x002fe200000000ffULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x0000000869257824ULL, 0x000fce00078e00ffULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x000000262711723eULL, 0x002fce00000000ffULL,
0x0000002300237308ULL, 0x000e700000000800ULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x000000222313723eULL, 0x002fce00000000ffULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x0000000869237836ULL, 0x000fe40000000000ULL, 0x0000000869227824ULL, 0x000fe400078e00ffULL,
0x0000000823277824ULL, 0x000fe200078e00ffULL, 0x00000006101c723cULL, 0x000fe4000000181cULL,
0x0000001b001b7308ULL, 0x000fe20000000800ULL, 0x000000292a19723eULL, 0x002fce00000000ffULL,
0x0000002800287308ULL, 0x000e620000000800ULL, 0x0c201f0016297f89ULL, 0x000ea200000e0000ULL,
0x00000008232a7824ULL, 0x000fcc00078e00ffULL, 0x0000002000207308ULL, 0x000f220000000800ULL,
0x0000001b2818723eULL, 0x002fce00000000ffULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x0c201f0017287f89ULL, 0x000e6200000e0000ULL, 0x000000ffff267224ULL, 0x000fe200078e0018ULL,
0x00000020351a723eULL, 0x010fca00000000ffULL, 0x0000003400347308ULL, 0x000f220000000800ULL,
0x00000003ff207819ULL, 0x000fe40000011603ULL, 0x000000291600720bULL, 0x004fe40003f1e000ULL,
0x0000000320207812ULL, 0x000fe400078ec0ffULL, 0x0000001629167208ULL, 0x000fe40004000000ULL,
0x0000000303ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000120697824ULL, 0x000fc400078e0269ULL,
0x0000000120247824ULL, 0x000fe400078e0223ULL, 0x000000ffff237224ULL, 0x000fe200078e000eULL,
0x0000002b341b723eULL, 0x010fe200000000ffULL, 0x00011000212b7836ULL, 0x000fe20000000000ULL,
0xfffffff822207812ULL, 0x000fe200078ee269ULL, 0x0000000469227836ULL, 0x000fe20000000000ULL,
0xfffffff827247812ULL, 0x000fe200078ee224ULL, 0x0000000c69697836ULL, 0x000fe20000000000ULL,
0x000000281700720bULL, 0x002fe20003f3e000ULL, 0x00000006181c723cULL, 0x000fe2000000181cULL,
0xfffffff825227812ULL, 0x000fe200078ee222ULL, 0x000000ffff217224ULL, 0x000fe200078e000aULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee269ULL, 0x000000ffff257224ULL, 0x000fe200078e0012ULL,
0x0000001728177208ULL, 0x000fe20004800000ULL, 0x000000ffff277224ULL, 0x000fc400078e001aULL,
0x0000001020067824ULL, 0x100fe400078e022bULL, 0x0000001022077824ULL, 0x000fe400078e022bULL,
0x000000ffff207224ULL, 0x000fe400078e0008ULL, 0x000000ffff227224ULL, 0x000fe400078e000cULL,
0x000000ffff087224ULL, 0x000fe400078e0009ULL, 0x000000ffff097224ULL, 0x000fe200078e000bULL,
0x0000002006007844ULL, 0x0003e20000000200ULL, 0x00000010241d7824ULL, 0x000fc400078e022bULL,
0x000000ffff247224ULL, 0x000fe400078e0010ULL, 0x000000ffff0a7224ULL, 0x000fe400078e000dULL,
0x000000ffff0b7224ULL, 0x000fe200078e000fULL, 0x0000002407007844ULL, 0x0005e20000000200ULL,
0x000000102a2a7824ULL, 0x000fe400078e022bULL, 0x000000ffff0c7224ULL, 0x000fe200078e0011ULL,
0x000000081d007844ULL, 0x0005e20000000200ULL, 0x000000ffff0d7224ULL, 0x000fc400078e0013ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0019ULL, 0x000000ffff0f7224ULL, 0x000fe400078e001bULL,
0x000000ffff107224ULL, 0x000fe400078e001cULL, 0x000000ffff117224ULL, 0x000fe200078e001eULL,
0x0000000c2a007844ULL, 0x0005e20000000200ULL, 0x00000001ff067424ULL, 0x002fe400078e00ffULL,
0x000000ffff1c7224ULL, 0x000fe200078e007cULL, 0x0170001405008388ULL, 0x0005e80000000c00ULL,
0x0172001005008388ULL, 0x0005e20000000a00ULL, 0x000000386f00720cULL, 0x008fe20003f06070ULL,
0x017608067dff79a7ULL, 0x0005e2000850003fULL, 0x017610067dff79a7ULL, 0x0005e2000850003fULL,
0x017618067dff79a7ULL, 0x0005e2000850003fULL, 0x017620067dff79a7ULL, 0x0005f2000850003fULL,
0xffffffac005c8947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000016007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000001600008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff16ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000016027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000001600007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffecc02a07950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x0000000000000577ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000006f8ULL, 0x0000000000000258ULL, 0x0000001700000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000950ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a30ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a84ULL, 0x0000000000000670ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000010f8ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000010f8ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000001140ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000001180ULL, 0x0000000000013280ULL, 0x0000001700000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000014400ULL, 0x0000000000000048ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000014450ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000014450ULL, 0x0000000000000278ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000014a48ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000014a48ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000001140ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000013280ULL, 0x0000000000013280ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000014400ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000014450ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000278ULL, 0x0000000000000278ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_16_sm_90_cubin_len = 84888;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
