/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000150d0ULL, 0x0000000000014d50ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL,
0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL,
0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL,
0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL,
0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000030ULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000001baULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000034ULL,
0x0000000000000004ULL, 0x000c00010000028dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000002dbULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000329ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c0001000003c5ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c00010000040bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000459ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000049fULL, 0x0000000000013090ULL,
0x0000000000000180ULL, 0x000b0022000004d2ULL, 0x0000000000013210ULL, 0x0000000000000040ULL,
0x000b0022000004fdULL, 0x0000000000013250ULL, 0x0000000000000050ULL, 0x000b002200000527ULL,
0x00000000000132a0ULL, 0x0000000000000160ULL, 0x000a000300000595ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005b5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005e5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000013400ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001309000000000ULL,
0x0000040400000000ULL, 0x810c000000100400ULL, 0x004c080408288080ULL, 0x0000000000000000ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8508288080820828ULL, 0x2880808708288080ULL,
0x808b082880808808ULL, 0x082880808d082880ULL, 0x808090082880808eULL, 0x9408288080920828ULL,
0x2880809508288080ULL, 0x809a082880809808ULL, 0x082880809b082880ULL, 0x8080a708288080a2ULL,
0x8408288080ae0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808084920000ULL,
0x0000000000000022ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001309000000000ULL,
0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL,
0x2880808228808084ULL, 0x000000a4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808508288080ULL, 0x8088082880808708ULL, 0x082880808a082880ULL, 0x80808d082880808bULL,
0x90082880808e0828ULL, 0x2880809108288080ULL, 0x8095082880809208ULL, 0x0828808098082880ULL,
0x80809b082880809aULL, 0xa708288080a20828ULL, 0x288080ae08288080ULL, 0x8280162880808c08ULL,
0x0000000003102880ULL, 0x80808c9200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL,
0x0000015800000000ULL, 0x0001321000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808508288080ULL,
0x8088082880808708ULL, 0x082880808b082880ULL, 0x80808e082880808dULL, 0x9108288080900828ULL,
0x2880809208288080ULL, 0x8098082880809408ULL, 0x082880809a082880ULL, 0x8080a2082880809bULL,
0xae08288080a70828ULL, 0x2880809508288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x0000220028808095ULL, 0x0000002cffffffffULL, 0x0000023000000000ULL, 0x0001325000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8090288080950900ULL, 0x0000000000002880ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808508288080ULL,
0x8088082880808708ULL, 0x082880808b082880ULL, 0x80808e082880808dULL, 0x9108288080900828ULL,
0x2880809208288080ULL, 0x8098082880809508ULL, 0x082880809a082880ULL, 0x8080a2082880809bULL,
0xae08288080a70828ULL, 0x2880809408288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x0000220028808094ULL, 0x0000001cffffffffULL, 0x0000031000000000ULL, 0x000132a000000000ULL,
0x0000016000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x0008230400000080ULL,
0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL,
0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL,
0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL, 0x0000001b00081204ULL,
0x0008110400000008ULL, 0x000000080000001bULL, 0x0000007b00043704ULL, 0x0000001800080a04ULL,
0x0068190300680160ULL, 0x00000000000c1704ULL, 0x0021f0000060000aULL, 0x00000000000c1704ULL,
0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0011f00000500008ULL, 0x00000000000c1704ULL,
0x0081f00000300007ULL, 0x00000000000c1704ULL, 0x0021f00000280006ULL, 0x00000000000c1704ULL,
0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL,
0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL,
0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400801b03ULL,
0x0134290400000b90ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01342804ffffffffULL,
0x000003e000000330ULL, 0x00002810000005c0ULL, 0x000029f0000028c0ULL, 0x00002fd000002b50ULL,
0x0000305000003000ULL, 0x00004fa0000030a0ULL, 0x0000517000005040ULL, 0x00005760000052d0ULL,
0x000057e000005790ULL, 0x0000756000005830ULL, 0x0000773000007600ULL, 0x00007d2000007890ULL,
0x00007da000007d50ULL, 0x00009b8000007df0ULL, 0x00009d5000009c20ULL, 0x0000a38000009eb0ULL,
0x0000a4000000a3b0ULL, 0x0000b6d00000a450ULL, 0x000119900000b6e0ULL, 0x000119e0000119d0ULL,
0x00011a00000119f0ULL, 0x00011a8000011a60ULL, 0x000126d000011aa0ULL, 0x0001276000012710ULL,
0x000127f0000127a0ULL, 0x0001289000012840ULL, 0x00012920000128d0ULL, 0x000129b000012960ULL,
0x00012a5000012a00ULL, 0x00012ae000012a90ULL, 0x00012b7000012b20ULL, 0x00012c1000012bc0ULL,
0x00012ca000012c50ULL, 0x00012d3000012ce0ULL, 0x00012dd000012d80ULL, 0x00012e9000012e30ULL,
0x00012f5000012ef0ULL, 0x0001301000012fb0ULL, 0x0440390400013070ULL, 0x000000ff00000440ULL,
0x003f01000000f600ULL, 0x0000000900000480ULL, 0x003f01200000f608ULL, 0x0000000900000510ULL,
0x003f01200000f688ULL, 0x0000000900000530ULL, 0x003f01200000f6a8ULL, 0x0000000900000540ULL,
0x003f01200000f6c8ULL, 0x000000ff00000bb0ULL, 0x003f01070000f600ULL, 0x0000000800000da0ULL,
0x003f010200000004ULL, 0x0000000800000e60ULL, 0x003f010100000000ULL, 0x0000007b00001620ULL,
0x003f01070000f6a8ULL, 0x0000007b00001730ULL, 0x003f01010000f6a8ULL, 0x0000000400001790ULL,
0x003f01010000f6c8ULL, 0x0000000d000018f0ULL, 0x003f01050000f6ccULL, 0x0000000d00001ae0ULL,
0x003f01050000f6ccULL, 0x000000ff00002430ULL, 0x000501070000f6b0ULL, 0x000000ff000024b0ULL,
0x000501010000f6b0ULL, 0x0000000d00002510ULL, 0x003f01010000f608ULL, 0x0000000d00002530ULL,
0x003f01050000f60cULL, 0x0000000d00002700ULL, 0x003f01050000f60cULL, 0x0000001600002d30ULL,
0x003f01050000f6acULL, 0x0000001600002f00ULL, 0x003f01050000f6acULL, 0x00000010000041a0ULL,
0x003f010100000000ULL, 0x0000003600004200ULL, 0x003f01010000f688ULL, 0x0000000800004220ULL,
0x003f010500000004ULL, 0x00000008000043f0ULL, 0x003f010500000004ULL, 0x0000000e00004bf0ULL,
0x003f01070000f6a8ULL, 0x0000000e00004c80ULL, 0x003f01010000f6a8ULL, 0x0000000d00004ce0ULL,
0x003f01010000f628ULL, 0x0000000d00004d00ULL, 0x003f01050000f62cULL, 0x0000000d00004ed0ULL,
0x003f01050000f62cULL, 0x00000036000054c0ULL, 0x003f01050000f6b4ULL, 0x0000003600005690ULL,
0x003f01050000f6b4ULL, 0x0000001000006720ULL, 0x003f010100000000ULL, 0x0000000f00006780ULL,
0x003f01010000f690ULL, 0x00000008000067a0ULL, 0x003f010500000004ULL, 0x0000000800006970ULL,
0x003f010500000004ULL, 0x0000007b00007140ULL, 0x003f01070000f6b0ULL, 0x0000001400007240ULL,
0x003f01010000f6b0ULL, 0x0000000d000072a0ULL, 0x003f01010000f648ULL, 0x0000000d000072c0ULL,
0x003f01050000f64cULL, 0x0000000d00007490ULL, 0x003f01050000f64cULL, 0x0000003800007a80ULL,
0x003f01050000f6acULL, 0x0000003800007c50ULL, 0x003f01050000f6acULL, 0x0000001200008d30ULL,
0x003f010100000000ULL, 0x0000001000008d90ULL, 0x003f010100000000ULL, 0x0000000800008db0ULL,
0x003f010500000004ULL, 0x0000000800008f80ULL, 0x003f010500000004ULL, 0x000000ff00009790ULL,
0x0004010700000000ULL, 0x0000007b00009870ULL, 0x003f01010000f6a8ULL, 0x00000008000098d0ULL,
0x003f01010000f668ULL, 0x0000000800009900ULL, 0x003f01050000f66cULL, 0x0000000800009ad0ULL,
0x003f01050000f66cULL, 0x0000007b0000a080ULL, 0x003f01050000f6b4ULL, 0x0000007b0000a2a0ULL,
0x003f01050000f6b4ULL, 0x000000080000b4a0ULL, 0x003f010100000000ULL, 0x0000000d0000b520ULL,
0x003f010100000000ULL, 0x000000ff0000c8b0ULL, 0x003f01010000f600ULL, 0x000000ff0000d4e0ULL,
0x003f01050000f604ULL, 0x000000ff0000d6f0ULL, 0x003f01050000f604ULL, 0x000000ff0000d920ULL,
0x003f01010000f600ULL, 0x000000ff0000d950ULL, 0x003f01050000f604ULL, 0x000000ff0000db10ULL,
0x003f01050000f604ULL, 0x000000700000fd70ULL, 0x003f010100000000ULL, 0x000000700000fdf0ULL,
0x003f010500000004ULL, 0x000000700000ffc0ULL, 0x003f010500000004ULL, 0x0000007400012530ULL,
0x003f010100000000ULL, 0x0000007400012590ULL, 0x003f010100000008ULL, 0x00000074000125f0ULL,
0x003f010100000010ULL, 0x0000007400012660ULL, 0x003f010100000018ULL, 0x00201c0400053803ULL,
0x0000bf700000bf40ULL, 0x0000c4000000c210ULL, 0x0000c7b00000c600ULL, 0x000126a00000db70ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000003ccULL, 0x0000001b00000002ULL,
0x00000000000002ecULL, 0x0000001b00000002ULL, 0x000000000000021cULL, 0x0000001b00000002ULL,
0x000000000000012cULL, 0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL,
0x00000000000003a7ULL, 0x0000001b00000002ULL, 0x00000000000002c7ULL, 0x0000001b00000002ULL,
0x00000000000001f4ULL, 0x0000001b00000002ULL, 0x0000000000000102ULL, 0x0000001b00000002ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000077919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000087ab9ULL, 0x000fe20000000a00ULL,
0xfffffff801017810ULL, 0x000fe40007ffe0ffULL, 0x00005d00ff007a0cULL, 0x000fda0003f05300ULL,
0x00000004ff080424ULL, 0x000fe200078e00ffULL, 0x0000000107020810ULL, 0x002fca0007ffe0ffULL,
0x00005c0002020625ULL, 0x000fc800078e0008ULL, 0x00005c0007080625ULL, 0x000fe200078e0008ULL,
0x0000000802650981ULL, 0x0002aa000c1e1900ULL, 0x0000000808080981ULL, 0x0006a2000c1e1900ULL,
0x0000590000007b06ULL, 0x000f220000209000ULL, 0x00005900ff6e7624ULL, 0x000fe200078e00ffULL,
0x00005900ff007a0cULL, 0x000fe20003f65070ULL, 0x0000000000067919ULL, 0x000e620000002600ULL,
0x00005a00ff117624ULL, 0x000fc600078e00ffULL, 0x00000000000f7919ULL, 0x000e620000002300ULL,
0x0000590011117a24ULL, 0x000fc600078e02ffULL, 0x00000000000d7919ULL, 0x000ee20000002100ULL,
0x0000000000007308ULL, 0x010f240000001000ULL, 0x0ffffffe00047810ULL, 0x010fcc0007ffe0ffULL,
0x0000000400057305ULL, 0x000864000021f000ULL, 0x000000ffff047224ULL, 0x010fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x002fc800078e0a05ULL, 0x000059000b0b7a24ULL, 0x000fc800078e02ffULL,
0x0000000b05057227ULL, 0x000fcc00078e0004ULL, 0x00000400050b7a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a0bULL, 0x0000040003007624ULL, 0x000fca00078e026eULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x8000590000001a10ULL, 0x000fe40007ffe0ffULL,
0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f46070ULL,
0x000000010b0b2810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff0bba12ULL, 0x000fc800078e33ffULL,
0x0000000b00007306ULL, 0x000e620000209000ULL, 0x000000ff0b00720cULL, 0x000fce0003f85070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000030b047224ULL, 0x010fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x0000000000047919ULL, 0x000e640000002200ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x00000006037a7227ULL, 0x000fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a7aULL,
0x000000000b007224ULL, 0x000fca00078e0206ULL, 0x0000000b0000720cULL, 0x000fe20003fa6070ULL,
0x000001000f027a24ULL, 0x002fe400078e0204ULL, 0x00001fff0f0f7589ULL, 0x000fe400000e0000ULL,
0x0000000002097a24ULL, 0x008fca00078e020dULL, 0x000000ff0900720cULL, 0x000fc60003f65270ULL,
0x0000000100005824ULL, 0x000fe200078e0a0bULL, 0x0000000f0900780cULL, 0x040fe40003f24070ULL,
0x000000017a7a5810ULL, 0x000fe40007ffe0ffULL, 0x0000000b0000720cULL, 0x000fe40003fc6070ULL,
0x00000005ff007819ULL, 0x000fe4000001160dULL, 0x000000030900780cULL, 0x040fe40003fa4070ULL,
0x0000007f0900780cULL, 0x000fe20003f44070ULL, 0x3fffff80ff02b424ULL, 0x000fe200078e00ffULL,
0x00001fff00007589ULL, 0x000e6200000e0000ULL, 0x7fffff80ff03b424ULL, 0x000fc400078e00ffULL,
0x3fffffc0ff049424ULL, 0x000fe400078e00ffULL, 0x000000017a7a6810ULL, 0x000fe20007ffe0ffULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x0000000bff7ac212ULL, 0x000fe200078e33ffULL,
0x00f60002ff00b388ULL, 0x0007e20000000a00ULL, 0x000000010900780cULL, 0x000fe20003f64070ULL,
0x3fffff80ff0ad424ULL, 0x000fe400078e00ffULL, 0x000000ffff797224ULL, 0x000fe200078e0a7aULL,
0x00f6080409009388ULL, 0x000fe20000008a00ULL, 0xff317217ff0ea424ULL, 0x000fc400078e00ffULL,
0x000000790b797224ULL, 0x000fe400078e0206ULL, 0x3fffff60ff02d424ULL, 0x008fe200078e00ffULL,
0x00f4000e0900a388ULL, 0x000fe20000004800ULL, 0x0000001079797824ULL, 0x000fe400078e00ffULL,
0x7fffff60ff03d424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff0bd424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL, 0x00f688020900d388ULL, 0x0003e20000008a00ULL,
0x7fffffc0ff0db424ULL, 0x000fc600078e00ffULL, 0x00f6a80a0900d388ULL, 0x000fe80000008a00ULL,
0x00f6c80c0900b388ULL, 0x000fe20000008a00ULL, 0x000000040f027824ULL, 0x002fe400078e0200ULL,
0x0000000165650824ULL, 0x004fe400078e0a08ULL, 0x00005800ff658624ULL, 0x000fe400078e00ffULL,
0x0000580007088a24ULL, 0x000fc400078e02ffULL, 0x00005a0065047a24ULL, 0x000fe400078e02ffULL,
0x0000001108107224ULL, 0x000fe400078e02ffULL, 0x0000000104057824ULL, 0x040fe200078e0a79ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000790400720cULL, 0x000fe20003f26070ULL,
0x0000001001007387ULL, 0x0003e20000100800ULL, 0x0000001005057817ULL, 0x000fe20003800000ULL,
0x0000000202047824ULL, 0x000fc400078e00ffULL, 0x00005a007a0d7a24ULL, 0x000fe200078e0210ULL,
0x000000ff057d7207ULL, 0x000fc80000800000ULL, 0x000000107d00780cULL, 0x000fda0003f05270ULL,
0x000002c000008947ULL, 0x000fea0003800000ULL, 0x00005a0000097b06ULL, 0x002e620000209000ULL,
0x0000000000067919ULL, 0x000ea20000000000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000900097308ULL, 0x002e620000001000ULL,
0x00000004ff057819ULL, 0x004fca0000011606ULL, 0x00000001040a7824ULL, 0x000fe200078e0205ULL,
0x0ffffffe09037810ULL, 0x002fcc0007ffe0ffULL, 0x0000000300037305ULL, 0x000e64000021f000ULL,
0x000000ffff0b7224ULL, 0x002fc800078e0a03ULL, 0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL,
0x0000000b030b7227ULL, 0x000fc800078e0002ULL, 0x0000000179027824ULL, 0x000fc800078e020aULL,
0x000000020b0b7227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a0bULL,
0x00005a0009037a24ULL, 0x000fe400078e0202ULL, 0x0000001006097824ULL, 0x000fc600078e00ffULL,
0x00005a0003007a0cULL, 0x000fda0003f06070ULL, 0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL,
0x000000010b0b0810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fda0003f26070ULL,
0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff0baa12ULL, 0x000fca00078e33ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a0bULL, 0x00005a0003027a24ULL, 0x000fe200078e0202ULL,
0x000000047d037217ULL, 0x000fc60007800000ULL, 0x000000010d027824ULL, 0x000fe400078e0202ULL,
0x0000000103047824ULL, 0x000fe400078e0a04ULL, 0x000000110b027224ULL, 0x000fe200078e0202ULL,
0x000000f0090b7812ULL, 0x000fe400078ec0ffULL, 0x000000040500720cULL, 0x000fe20003f06070ULL,
0x0000010002027825ULL, 0x000fc800078e00ffULL, 0x000000010a047824ULL, 0x000fe200078e0206ULL,
0x0000000b020b7212ULL, 0x000fe200078efcffULL, 0x000000100a057824ULL, 0x000fc600078e00ffULL,
0x000060000b027a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff005047812ULL, 0x000fe400078ee204ULL,
0x0000610003037a10ULL, 0x000fc60000ffe4ffULL, 0x0000001004057824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e2000c101c48ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x00005a0000057b06ULL, 0x002e620000209000ULL,
0x0000000000067919ULL, 0x000ea20000000000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000500057308ULL, 0x002e620000001000ULL,
0x0000000406047211ULL, 0x004fe400078fe0ffULL, 0x0ffffffe05097810ULL, 0x002fca0007ffe0ffULL,
0x0000000900037305ULL, 0x0002a4000021f000ULL, 0x0000001006097824ULL, 0x002fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x004fc800078e0a03ULL, 0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL,
0x0000000b03037227ULL, 0x000fe200078e0002ULL, 0x000000f0090b7812ULL, 0x000fc600078ec0ffULL,
0x0000000179027824ULL, 0x000fc800078e0204ULL, 0x0000000203037227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a03ULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103030810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff03aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a03ULL, 0x00005a0005027a24ULL, 0x000fe400078e0202ULL,
0x0000000104057824ULL, 0x040fe400078e0206ULL, 0x000000010d027824ULL, 0x000fe400078e0202ULL,
0x0000001004047824ULL, 0x000fe400078e00ffULL, 0x0000001103027224ULL, 0x000fc600078e0202ULL,
0xfffffff004057812ULL, 0x000fe200078ee205ULL, 0x0000010002027825ULL, 0x000fc800078e00ffULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x0000000b02027212ULL, 0x000fc800078efcffULL,
0x0000600002027a10ULL, 0x000fc80007f1e0ffULL, 0x0000610003037a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e8000b901c48ULL,
0x0000000000047919ULL, 0x000ea20000000000ULL, 0x0000000000027806ULL, 0x002fe200038e0000ULL,
0x00000004ff3e7424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000200037300ULL, 0x000eb000000e0000ULL, 0x0000000200057309ULL, 0x000e620000000000ULL,
0x000000040300720cULL, 0x004fe20003f02070ULL, 0x000000ffff037224ULL, 0x002fc400078e0a05ULL,
0x0000680007047625ULL, 0x000fd400078e003eULL, 0x00f60403ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000804027981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0f00720cULL, 0x000fe40003f05270ULL,
0x0000007f02667810ULL, 0x044fe40007ffe0ffULL, 0x000000ff02107810ULL, 0x000fc40007ffe0ffULL,
0x00000007ff667819ULL, 0x000fe40000011666ULL, 0x00000008ff037819ULL, 0x002fca0000011610ULL,
0x0000bad000008947ULL, 0x000fea0003800000ULL, 0x00000003ff6d7819ULL, 0x000fe20000011600ULL,
0xffffffffff6a7424ULL, 0x000fe200078e00ffULL, 0x0000f68800087811ULL, 0x000fe400078e18ffULL,
0x01ffffff6d6d7812ULL, 0x000fc800078ec0ffULL, 0x000000666d00720cULL, 0x000fda0003f06070ULL,
0x0000000207048824ULL, 0x000fe400078e00ffULL, 0x00006a00ff058624ULL, 0x000fc800078e00ffULL,
0x00006a0004048624ULL, 0x000fe400078e0205ULL, 0x00000003ff057424ULL, 0x000fe400078e00ffULL,
0x000000016d3f8824ULL, 0x000fe200078e0204ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040508ff738cULL, 0x0003e20000000000ULL, 0x000066003f3e8625ULL, 0x000fe200078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000083e6a8981ULL, 0x000ea2000c1e1900ULL,
0x000001ff1000780cULL, 0x000fe20003f04070ULL, 0x000000807a737824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011600ULL, 0x00000080ff057424ULL, 0x002fe200078e00ffULL,
0x0000000008ff7f8cULL, 0x0003e2000c80043fULL, 0x00000001007c7812ULL, 0x000fc400078ec0ffULL,
0x000000200a0e7824ULL, 0x000fca00078e00ffULL, 0x00000060730b7812ULL, 0x000fe200078ef80eULL,
0x000059006a047a24ULL, 0x004fc800078e02ffULL, 0x0000008004047824ULL, 0x000fc800078e00ffULL,
0x0000640004047625ULL, 0x000fe200078e0005ULL, 0x000003e000000947ULL, 0x000fea0003800000ULL,
0x0000000e02087217ULL, 0x002fe20007800000ULL, 0x000000107c0d7824ULL, 0x000fe200078e00ffULL,
0x00000003ff0c7819ULL, 0x000fc60000011606ULL, 0x0000000108087824ULL, 0x000fe200078e0a0eULL,
0x000000040c107810ULL, 0x040fe20007ffe0ffULL, 0x000000010d0e7824ULL, 0x000fe200078e020cULL,
0x0000000c0c117810ULL, 0x000fe40007ffe0ffULL, 0x0000000d08087217ULL, 0x000fe20007800000ULL,
0x000000010e0f7824ULL, 0x040fe400078e0206ULL, 0x000000080e147824ULL, 0x000fe400078e00ffULL,
0x0000000108087824ULL, 0x000fc400078e0a0dULL, 0x000000010d127824ULL, 0x000fe200078e0211ULL,
0xfffffff814147812ULL, 0x000fe400078ee20fULL, 0x000000080c0f7810ULL, 0x040fe40007ffe0ffULL,
0x000000080c00720cULL, 0x080fe20003f66070ULL, 0x000000010b0c7824ULL, 0x000fe200078e020eULL,
0x000000081000720cULL, 0x080fe20003f46070ULL, 0x000000010d107824ULL, 0x000fe200078e0210ULL,
0x000000080f00720cULL, 0x080fe20003f26070ULL, 0x000000010d0f7824ULL, 0x000fe200078e020fULL,
0x000000081100720cULL, 0x000fe20003f06070ULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x000000010b087824ULL, 0x040fe200078e0210ULL, 0x000000700c137812ULL, 0x000fe200078ef809ULL,
0x00000001100e7824ULL, 0x040fe400078e0206ULL, 0x0000000810157824ULL, 0x000fe400078e00ffULL,
0x000000010b107824ULL, 0x040fe400078e020fULL, 0x000000010b117824ULL, 0x000fe200078e0212ULL,
0xfffffff815167812ULL, 0x000fe200078ee20eULL, 0x000000010f0b7824ULL, 0x000fc400078e0206ULL,
0x000000080f187824ULL, 0x000fe400078e00ffULL, 0x00000001120c7824ULL, 0x040fe400078e0206ULL,
0x00000008120f7824ULL, 0x000fe200078e00ffULL, 0x0000001304127210ULL, 0x000fe40007f9e0ffULL,
0xfffffff818187812ULL, 0x000fe400078ee20bULL, 0xfffffff80f1a7812ULL, 0x000fe200078ee20cULL,
0x0000000105137824ULL, 0x000fe200020e060dULL, 0x0000b0000a0b7811ULL, 0x000fe200078e68ffULL,
0x00000080080c7825ULL, 0x000fc800078e00ffULL, 0x00000080100e7825ULL, 0x000fe200078e00ffULL,
0x000000700c1d7812ULL, 0x000fc600078ef809ULL, 0x0000008011107825ULL, 0x000fe200078e00ffULL,
0x000000700e1b7812ULL, 0x000fe400078ef809ULL, 0x0000001d04087210ULL, 0x000fe20007f9e0ffULL,
0x0000001014157824ULL, 0x000fe200078e020bULL, 0x0000007010097812ULL, 0x000fe200078ef809ULL,
0x0000001016177824ULL, 0x100fe200078e020bULL, 0x0000001b040c7210ULL, 0x000fe20007fbe0ffULL,
0x0000001018197824ULL, 0x000fe200078e020bULL, 0x0000000904047210ULL, 0x000fe20007fde0ffULL,
0x0000000105097824ULL, 0x040fe200020e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012157faeULL, 0x0003e2000d901c48ULL, 0x00000001050d7824ULL, 0x000fc400028e060fULL,
0x000000101a0b7824ULL, 0x000fe200078e020bULL, 0x0000000008177faeULL, 0x0003e2000d101c48ULL,
0x0000000105057824ULL, 0x000fc600030e0611ULL, 0x000000000c197faeULL, 0x0003e8000c901c48ULL,
0x00000000040b7faeULL, 0x0003e2000c101c48ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x000000107c0d7824ULL, 0x002fe200078e00ffULL, 0x0000b0000a1d7811ULL, 0x000fc800078e68ffULL,
0x0000000d06087211ULL, 0x000fc800078fe8ffULL, 0x00000004080e7810ULL, 0x040fe20007ffe0ffULL,
0x00000001080d7824ULL, 0x040fe200078e0206ULL, 0x0000000c08117810ULL, 0x040fe20007ffe0ffULL,
0x0000000808147824ULL, 0x040fe200078e00ffULL, 0x0000000808107810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0c7824ULL, 0x040fe400078e0208ULL, 0x000000010b087824ULL, 0x000fe200078e020eULL,
0xfffffff814147812ULL, 0x000fe200078ee20dULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x000000010e0f7824ULL, 0x100fe200078e0206ULL, 0x000000700c137812ULL, 0x000fe200078ef809ULL,
0x000000080e167824ULL, 0x000fe400078e00ffULL, 0x000000010b177824ULL, 0x000fe200078e0211ULL,
0x0000001304127210ULL, 0x000fe20007f1e0ffULL, 0x00000001110c7824ULL, 0x000fe200078e0206ULL,
0xfffffff816157812ULL, 0x000fe200078ee20fULL, 0x000000010b0e7824ULL, 0x000fe400078e0210ULL,
0x0000000811117824ULL, 0x000fc400078e00ffULL, 0x00000001100b7824ULL, 0x040fe400078e0206ULL,
0x0000000810107824ULL, 0x000fe200078e00ffULL, 0xfffffff811187812ULL, 0x000fe200078ee20cULL,
0x0000000105137824ULL, 0x000fe400000e060dULL, 0x00000080080c7825ULL, 0x000fe200078e00ffULL,
0xfffffff810167812ULL, 0x000fc600078ee20bULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c1b7812ULL, 0x000fc600078ef809ULL, 0x0000008017107825ULL, 0x000fe200078e00ffULL,
0x000000700e197812ULL, 0x000fe400078ef809ULL, 0x0000001b04087210ULL, 0x000fe20007f1e0ffULL,
0x00000010140b7824ULL, 0x000fe200078e021dULL, 0x0000007010097812ULL, 0x000fe200078ef809ULL,
0x0000001015157824ULL, 0x100fe200078e021dULL, 0x00000019040c7210ULL, 0x000fe20007f3e0ffULL,
0x0000001016177824ULL, 0x000fe200078e021dULL, 0x0000000904047210ULL, 0x000fe20007f5e0ffULL,
0x0000000105097824ULL, 0x040fe200000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120b7faeULL, 0x0003e2000b901c48ULL, 0x00000001050d7824ULL, 0x000fc400008e060fULL,
0x0000001018197824ULL, 0x000fe200078e021dULL, 0x0000000008157faeULL, 0x0003e2000b901c48ULL,
0x0000000105057824ULL, 0x000fc600010e0611ULL, 0x000000000c177faeULL, 0x0003e8000b901c48ULL,
0x0000000004197faeULL, 0x0003e4000b901c48ULL, 0x000000100a7b7824ULL, 0x040fe200078e00ffULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x000000080a047824ULL, 0x002fe200078e00ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x000000007b0473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8007b0e7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6c80004047f8cULL, 0x000ee2000c80043fULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00009d2000008947ULL, 0x000fea0003800000ULL,
0x0000000207747824ULL, 0x000fe200078e00ffULL, 0x00000002ff787819ULL, 0x000fe20000011600ULL,
0x00006a00ff077624ULL, 0x000fc400078e00ffULL, 0x000000ffff0b7224ULL, 0x008fe400078e0005ULL,
0x00006a0074747624ULL, 0x000fe400078e0207ULL, 0xff317217ff127424ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x000fc400078e00ffULL,
0x0000000000107805ULL, 0x01afca0000015200ULL, 0x0000000400087824ULL, 0x000fca00078e00ffULL,
0xfffffff8080d7812ULL, 0x000fca00078ec0ffULL, 0x00f6cc000d087984ULL, 0x000ee40000000800ULL,
0x8000000008ff7812ULL, 0x008fe4000780480bULL, 0x0000f6c80d087810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000ff00000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410137210ULL, 0x000fca0007f1e1ffULL, 0x0000000115147824ULL, 0x000fe200000e0e11ULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x004fc80000011414ULL, 0x000000130e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0614ULL, 0x000000020e0e7819ULL, 0x000fc80000001213ULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6cc000d0e7984ULL, 0x004ea40000000800ULL, 0x800000000eff7812ULL, 0x004fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010000b7824ULL, 0x000fe200078e00ffULL, 0x0000000109107810ULL, 0x000fe20007ffe0ffULL,
0x000059006a6a7a24ULL, 0x000fe400078e02ffULL, 0x00000080ff117424ULL, 0x000fe200078e00ffULL,
0xffffffe00b0e7812ULL, 0x004fc400078ec0ffULL, 0x000000031000720cULL, 0x000fe20003f26070ULL,
0x000000806a107824ULL, 0x000fe400078e00ffULL, 0x00000100090e7824ULL, 0x000fe400078e020eULL,
0x0000640010107625ULL, 0x000fc600078e0011ULL, 0x000000400e0d7810ULL, 0x000fc80007ffe0ffULL,
0x000000600d0e7812ULL, 0x000fca00078ec0ffULL, 0x0000000173367824ULL, 0x000fe200078e020eULL,
0x0000040000009947ULL, 0x000fea0003800000ULL, 0x000000100b0e7812ULL, 0x000fe400078ec0ffULL,
0x0000000d020b7217ULL, 0x000fe40007800000ULL, 0x00000003ff147819ULL, 0x000fc60000011606ULL,
0x000000010b0b7824ULL, 0x000fe200078e0a0dULL, 0x0000000414157810ULL, 0x040fe20007ffe0ffULL,
0x00000001140d7824ULL, 0x040fe200078e020eULL, 0x0000000814177810ULL, 0x040fe40007ffe0ffULL,
0x0000000e0b0b7217ULL, 0x000fe20007800000ULL, 0x000000010d137824ULL, 0x040fe200078e0206ULL,
0x0000000c14347810ULL, 0x000fe20007ffe0ffULL, 0x000000080d167824ULL, 0x000fe400078e00ffULL,
0x000000010b0b7824ULL, 0x000fc400078e0a0eULL, 0x0000000134357824ULL, 0x100fe200078e020eULL,
0xfffffff816137812ULL, 0x000fe200078ee213ULL, 0x0000001006167824ULL, 0x000fe200078e00ffULL,
0x0000000b1500720cULL, 0x0c0fe20003f66070ULL, 0x0000000115157824ULL, 0x000fe200078e020eULL,
0x0000000b1400720cULL, 0x080fe20003f86070ULL, 0x00000008353d7824ULL, 0x000fe200078e00ffULL,
0x0000000b1700720cULL, 0x080fe20003f46070ULL, 0x0000000115147824ULL, 0x040fe200078e0206ULL,
0x0000000b3400720cULL, 0x000fe20003f06070ULL, 0x0000000815377824ULL, 0x000fe200078e00ffULL,
0x00000070163f7812ULL, 0x000fe200078ec0ffULL, 0x0000000117177824ULL, 0x000fc400078e020eULL,
0x0000000136167824ULL, 0x040fe200078e0215ULL, 0xfffffff8370b7812ULL, 0x000fe200078ee214ULL,
0x0000000136147824ULL, 0x040fe400078e020dULL, 0x0000000136347824ULL, 0x000fe400078e0217ULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x00000001170d7824ULL, 0x040fe400078e0206ULL,
0x00000008173c7824ULL, 0x000fe400078e00ffULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0xfffffff83c0d7812ULL, 0x000fe200078ee20dULL, 0x0000000136367824ULL, 0x000fe200078e0235ULL,
0x0000003f16377212ULL, 0x080fe200078efcffULL, 0x00000001350e7824ULL, 0x000fe200078e0206ULL,
0x0000003f14357212ULL, 0x000fe400078efcffULL, 0x0000003710167210ULL, 0x000fe20007fde0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000003510147210ULL, 0x000fe40007fbe0ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee20eULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000c0000a0e7811ULL, 0x000fc600078e68ffULL, 0x0000000111157824ULL, 0x040fe200028e0615ULL,
0x0000003f34417212ULL, 0x080fe200078efcffULL, 0x0000000111177824ULL, 0x000fe200030e0617ULL,
0x0000003f363f7212ULL, 0x000fe200078efcffULL, 0x0000001013137824ULL, 0x100fe200078e020eULL,
0x0000004110347210ULL, 0x040fe20007fbe0ffULL, 0x000000100b0b7824ULL, 0x100fe200078e020eULL,
0x0000003f10107210ULL, 0x000fe20007fde0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e020eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014137faeULL, 0x0005e2000e101c48ULL,
0x0000000111357824ULL, 0x000fc400028e0635ULL, 0x000000103d3d7824ULL, 0x000fe200078e020eULL,
0x00000000160b7faeULL, 0x0005e2000d901c48ULL, 0x0000000111117824ULL, 0x000fc600030e0637ULL,
0x00000000340d7faeULL, 0x0005e8000d101c48ULL, 0x00000000103d7faeULL, 0x0005e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x000000100b0b7812ULL, 0x000fe200078ec0ffULL,
0x00000010060e7824ULL, 0x000fc600078e00ffULL, 0x0000000b060b7211ULL, 0x000fe400078fe8ffULL,
0x000000700e3d7812ULL, 0x000fe400078ec0ffULL, 0x000000080b177810ULL, 0x040fe20007ffe0ffULL,
0x0000000136147824ULL, 0x000fe200078e020bULL, 0x000000040b137810ULL, 0x040fe20007ffe0ffULL,
0x000000010b0d7824ULL, 0x040fe200078e0206ULL, 0x0000000c0b357810ULL, 0x040fe20007ffe0ffULL,
0x000000080b167824ULL, 0x000fe400078e00ffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x0000000136347824ULL, 0x000fe200078e0217ULL,
0x0000003d14377212ULL, 0x000fe200078efcffULL, 0x00000001170e7824ULL, 0x040fe400078e0206ULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0x0000003710147210ULL, 0x000fe20007f1e0ffULL,
0x0000000136167824ULL, 0x040fe400078e0213ULL, 0x0000000136367824ULL, 0x000fe200078e0235ULL,
0xfffffff8170e7812ULL, 0x000fe200078ee20eULL, 0x00000001130b7824ULL, 0x000fc400078e0206ULL,
0x00000008133c7824ULL, 0x000fe400078e00ffULL, 0x0000000135137824ULL, 0x040fe400078e0206ULL,
0x00000008353e7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c0b7812ULL, 0x000fe200078ee20bULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0xfffffff83e3c7812ULL, 0x000fe200078ee213ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000003d16417212ULL, 0x080fe400078efcffULL,
0x0000c0000a3e7811ULL, 0x000fe200078e68ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000003d343f7212ULL, 0x000fc600078efcffULL, 0x0000000111157824ULL, 0x000fe200000e0615ULL,
0x0000003d363d7212ULL, 0x000fe200078efcffULL, 0x000000100d0d7824ULL, 0x100fe200078e023eULL,
0x0000004110167210ULL, 0x040fe20007f1e0ffULL, 0x000000100b0b7824ULL, 0x100fe200078e023eULL,
0x0000003f10347210ULL, 0x000fe20007f5e0ffULL, 0x000000100e137824ULL, 0x000fe200078e023eULL,
0x0000003d10107210ULL, 0x000fe20007f7e0ffULL, 0x0000000111177824ULL, 0x040fe200000e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0005e2000b901c48ULL,
0x0000000111357824ULL, 0x000fc400010e0635ULL, 0x000000103c3d7824ULL, 0x000fe200078e023eULL,
0x00000000160b7faeULL, 0x0005e2000b901c48ULL, 0x0000000111117824ULL, 0x000fc600018e0637ULL,
0x0000000034137faeULL, 0x0005e8000b901c48ULL, 0x00000000103d7faeULL, 0x0005e4000b901c48ULL,
0x0000000800137824ULL, 0x004fe200078e00ffULL, 0x000000016d0b7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0e7424ULL, 0x000fe400078e00ffULL, 0x00000000130573c2ULL, 0x000ea200000e0000ULL,
0x000000660b00720cULL, 0x000fe40003f06070ULL, 0xffffffe0130d7812ULL, 0x000fc400078ec0ffULL,
0x0000001013147812ULL, 0x000fd200078ec0ffULL, 0x0000000174108824ULL, 0x000fe400078e020bULL,
0x00000004ff118424ULL, 0x000fe200078e00ffULL, 0x00000008130b7812ULL, 0x000fc600078ec0ffULL,
0x0000660010108625ULL, 0x000fe200078e0011ULL, 0xfffffff005057892ULL, 0x004fe2000f8ec03fULL,
0x0000000d0b0d7210ULL, 0x000fc60007ffe014ULL, 0x00000008100e8981ULL, 0x000522000c1e1900ULL,
0x0000f6b005067890ULL, 0x000fc8000fffe03fULL, 0x0000000000007918ULL, 0x000fea0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x00f6b000ff347f8cULL, 0x000ea2000c800405ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f608000d167f8cULL, 0x000664000c80043fULL,
0x0000000000107805ULL, 0x000fc40000015200ULL, 0x00f60c000d0b7984ULL, 0x000ee40000000800ULL,
0x800000000bff7812ULL, 0x00afe40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc80000011415ULL, 0x000000140b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x000000020b0b7819ULL, 0x000fc80000001214ULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60c000d0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001006627824ULL, 0x000fe200078e00ffULL,
0x00000001ff6b7819ULL, 0x000fe20000011606ULL, 0x00000020000b7824ULL, 0x000fe400078e00ffULL,
0xffffffffff707424ULL, 0x000fe200078e00ffULL, 0x0000007062627812ULL, 0x000fc400078ec0ffULL,
0xffffff800b0b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c6b6b7812ULL, 0x000fc800078ec0ffULL,
0x0000000b6b0b7210ULL, 0x000fca0007ffe062ULL, 0x00f000000b177984ULL, 0x000e680000000800ULL,
0x00f200000b167984ULL, 0x0006a20000000800ULL, 0x000000121700720bULL, 0x002fe20003f1d000ULL,
0x0000fea27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x008fc800000e0100ULL,
0x0000ffff10367812ULL, 0x000fe2000780c0ffULL, 0x000004c000007945ULL, 0x000fe20003800000ULL,
0x00000001ff147424ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc400078e0012ULL,
0x0000001fff757424ULL, 0x000fe400078e00ffULL, 0xffffffffff727424ULL, 0x000fca00078e00ffULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000007800720cULL, 0x000fe40003f05270ULL,
0x000000121700720bULL, 0x000fe20003f54000ULL, 0x0000fe327f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x000fc400010e0100ULL, 0x0000008000148824ULL, 0x000fe200078e0262ULL,
0x0000001217108209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x000000016b118824ULL, 0x000fe200078e0214ULL, 0x000099100b147816ULL, 0x000fc800000000ffULL,
0x00f4001011008388ULL, 0x0003e20000000800ULL, 0x000000ff1400720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000001217117209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0bff7812ULL, 0x000fc6000780c0ffULL,
0x0000001211107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000377308ULL, 0x000e640000000800ULL, 0x000000370c0c7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe20000011606ULL,
0x0000fd527f007947ULL, 0x000fea000b800000ULL, 0x00001f1037147589ULL, 0x0002e400000e0000ULL,
0x0000001438387220ULL, 0x08cfe20000410000ULL, 0x0000001439397220ULL, 0x080fe20000410000ULL,
0x000000141c1c7220ULL, 0x080fe20000410000ULL, 0x000000141d1d7220ULL, 0x080fe20000410000ULL,
0x0000001420207220ULL, 0x080fe20000410000ULL, 0x0000001421217220ULL, 0x080fe20000410000ULL,
0x0000001424247220ULL, 0x080fe20000410000ULL, 0x0000001425257220ULL, 0x080fe20000410000ULL,
0x0000001428287220ULL, 0x080fe20000410000ULL, 0x0000001429297220ULL, 0x080fe20000410000ULL,
0x000000142c2c7220ULL, 0x080fe20000410000ULL, 0x000000142d2d7220ULL, 0x080fe20000410000ULL,
0x0000001430307220ULL, 0x080fe20000410000ULL, 0x0000001431317220ULL, 0x080fe20000410000ULL,
0x0000001418187220ULL, 0x080fe20000410000ULL, 0x0000001419197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000bff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000806107811ULL, 0x002fe200078ff0ffULL,
0x0000fc327f007947ULL, 0x000fea000b800000ULL, 0x00001f1037147589ULL, 0x0002e400000e0000ULL,
0x000000143a3a7220ULL, 0x08cfe20000410000ULL, 0x000000143b3b7220ULL, 0x080fe20000410000ULL,
0x000000141e1e7220ULL, 0x080fe20000410000ULL, 0x000000141f1f7220ULL, 0x080fe20000410000ULL,
0x0000001422227220ULL, 0x080fe20000410000ULL, 0x0000001423237220ULL, 0x080fe20000410000ULL,
0x0000001426267220ULL, 0x080fe20000410000ULL, 0x0000001427277220ULL, 0x080fe20000410000ULL,
0x000000142a2a7220ULL, 0x080fe20000410000ULL, 0x000000142b2b7220ULL, 0x080fe20000410000ULL,
0x000000142e2e7220ULL, 0x080fe20000410000ULL, 0x000000142f2f7220ULL, 0x080fe20000410000ULL,
0x0000001432327220ULL, 0x080fe20000410000ULL, 0x0000001433337220ULL, 0x080fe20000410000ULL,
0x000000141a1a7220ULL, 0x080fe20000410000ULL, 0x000000141b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff36ff7812ULL, 0x000fe2000780600bULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x00000012170b7209ULL, 0x000fd60007810000ULL,
0x8000000b17170221ULL, 0x000fe20000010000ULL, 0x00007610ff140816ULL, 0x000fc60000000014ULL,
0x3fb8aa3b17170820ULL, 0x000fc80000410000ULL, 0x0000001700070308ULL, 0x000e640000000800ULL,
0x0000000716160220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000c160c7221ULL, 0x004fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0xfffffff013167812ULL, 0x000fca00078ec0ffULL, 0x00f6ac0016127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff177224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210157210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001512127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000117177810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac0016127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910140f7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0f00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000007ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff127819ULL, 0x000fe40000011606ULL, 0x00005410040f7816ULL, 0x000fe20000000004ULL,
0x0000f7f27f007947ULL, 0x000fea000b800000ULL, 0x00001f120f057589ULL, 0x0002a400000e0000ULL,
0x0000000812107810ULL, 0x000fe20007ffe0ffULL, 0x0000f8227f007947ULL, 0x000fea000b800000ULL,
0x00001f100f047589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001012107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200078e000fULL,
0x0000306000157802ULL, 0x000fc40000000f00ULL, 0x000101f000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001812107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200078e000fULL, 0x000030b000157802ULL, 0x000fc40000000f00ULL,
0x000101a000007944ULL, 0x016fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000200367824ULL, 0x000fe200078e00ffULL, 0x0000000706117812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x00000004360f7812ULL, 0x00afc400078ec0ffULL,
0x0000000811377812ULL, 0x000fe400078ef806ULL, 0x0000000f06107211ULL, 0x000fe200078fe0ffULL,
0x00000200000f7824ULL, 0x000fe400078e00ffULL, 0x0000000837127824ULL, 0x040fe400078e00ffULL,
0x0000000137637824ULL, 0x000fe200078e0210ULL, 0xfffff8000f0f7812ULL, 0x000fe400078ec0ffULL,
0x0000000806107812ULL, 0x000fc400078ec0ffULL, 0xfffffff812127812ULL, 0x000fca00078ee263ULL,
0x0000001012477824ULL, 0x000fc400078e020fULL, 0x0000000400127824ULL, 0x000fe200078e00ffULL,
0x00000004ff3f7819ULL, 0x000fe20000011606ULL, 0x00000008374e7824ULL, 0x000fe200078e00ffULL,
0x00000011103c7212ULL, 0x000fe400078efcffULL, 0x0000000412127812ULL, 0x000fe200078ec0ffULL,
0x000000040a487824ULL, 0x040fe200078e023fULL, 0x0000b0000a697811ULL, 0x000fe200078e68ffULL,
0x000000083c467824ULL, 0x000fe200078e00ffULL, 0x0000001010507812ULL, 0x000fe200078efe11ULL,
0x000000013f137824ULL, 0x000fe200078e0212ULL, 0x0000000248497810ULL, 0x000fc40007ffe037ULL,
0xfffffff836367812ULL, 0x000fe200078ec0ffULL, 0x000000013c3d7824ULL, 0x000fe200078e0213ULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee249ULL, 0x0000000850447824ULL, 0x000fe400078e00ffULL,
0x00000001134b7824ULL, 0x000fe200078e0250ULL, 0xfffffff846467812ULL, 0x000fe200078ee23dULL,
0x009000004710783bULL, 0x000e620000000200ULL, 0x000000083c3c7824ULL, 0x000fe200078e00ffULL,
0x000000023d457810ULL, 0x000fe20007ffe0ffULL, 0x00000008504f7824ULL, 0x000fe200078e00ffULL,
0xfffffff844447812ULL, 0x000fe200078ee24bULL, 0x0000001046147824ULL, 0x004fe200078e0269ULL,
0xfffffff83c457812ULL, 0x000fe200078ee245ULL, 0x000000104e0f7824ULL, 0x000fc400078e020fULL,
0x0000001044407824ULL, 0x100fe400078e0269ULL, 0x000000001414783bULL, 0x000ea20000004200ULL,
0x00000010453c7824ULL, 0x000fc600078e0269ULL, 0x000000004040783bULL, 0x000ee80000004200ULL,
0x000000003c3c783bULL, 0x000ee20000004200ULL, 0x0000000510108232ULL, 0x082fe40000000000ULL,
0x0000000512128232ULL, 0x000fe40000000000ULL, 0x0000000411118232ULL, 0x080fe40000000000ULL,
0x0000000413138232ULL, 0x000fe20000000000ULL, 0x00000018ff377819ULL, 0x004fc40000011616ULL,
0x0000ffff16487812ULL, 0x000fe400078ec0ffULL, 0x00000037ff49723eULL, 0x000fe400020006ffULL,
0x0000ffff17377812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4a7819ULL, 0x000fe40000011617ULL,
0x00000008ff487819ULL, 0x000fe40000011648ULL, 0x00000008ff377819ULL, 0x000fc40000011637ULL,
0x0000004aff4c723eULL, 0x000fe400020006ffULL, 0x00000048ff4a723eULL, 0x000fe400020006ffULL,
0x000000024b487810ULL, 0x000fe40007ffe0ffULL, 0x00000037ff4b723eULL, 0x000fe400020006ffULL,
0x000054104a4a7816ULL, 0x000fe40000000049ULL, 0x000054104b4b7816ULL, 0x000fc4000000004cULL,
0x00000018ff4d7819ULL, 0x008fe40000011640ULL, 0x000000ff14527812ULL, 0x000fe400078ec0ffULL,
0xfffffff84f487812ULL, 0x000fe200078ee248ULL, 0x0000004a1024723cULL, 0x000be20000001824ULL,
0x000000ff15547812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011614ULL,
0x0000004dff37723eULL, 0x000fc400020006ffULL, 0x00000010ff4b7819ULL, 0x020fe40000011614ULL,
0x00000010ff4a7819ULL, 0x100fe40000011615ULL, 0x000000ff4b4b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff14147812ULL, 0x000fe400078ec0ffULL,
0x00000018ff537819ULL, 0x000fc40000011615ULL, 0x0000ffff15497812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4d7819ULL, 0x000fe40000011616ULL, 0x000000ff16687812ULL, 0x000fe400078ec0ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x0000004bff15723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fc400020006ffULL, 0x0000004aff16723eULL, 0x000fe400020006ffULL,
0x00000010ff507819ULL, 0x100fe4000001163eULL, 0x000000ff3e657812ULL, 0x040fe400078ec0ffULL,
0x00000018ff577819ULL, 0x000fe4000001163eULL, 0x0000ffff3e4c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3e7819ULL, 0x000fc40000011614ULL, 0x0000541052147816ULL, 0x000fe40000000015ULL,
0x0000541054157816ULL, 0x000fe40000000016ULL, 0x00000010ff567819ULL, 0x000fe40000011617ULL,
0x000000ff17677812ULL, 0x000fe400078ec0ffULL, 0x00000018ff177819ULL, 0x000fe40000011641ULL,
0x00000008ff497819ULL, 0x000fc40000011649ULL, 0x00000017ff4a723eULL, 0x000fe400020006ffULL,
0x000000141014723cULL, 0x000b620000001838ULL, 0x00000010ff5f7819ULL, 0x100fe4000001163cULL,
0x000000ff3c5d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001163cULL,
0x0000ffff3c597812ULL, 0x000fe400078ec0ffULL, 0x00000010ff617819ULL, 0x000fc4000001163dULL,
0x000000ff3d647812ULL, 0x040fe400078ec0ffULL, 0x00000018ff607819ULL, 0x000fe4000001163dULL,
0x0000ffff3d5a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff41387812ULL, 0x020fe400078ec0ffULL,
0x0000004fff3c723eULL, 0x000fe400020006ffULL, 0x00000053ff3d723eULL, 0x000fc400020006ffULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x00000049ff39723eULL, 0x000fe400020006ffULL,
0x000000ff4d3a7812ULL, 0x000fe400078ec0ffULL, 0x00000038ff4d723eULL, 0x000fe400020006ffULL,
0x000054103e387816ULL, 0x000fe2000000003cULL, 0x00000010483c7824ULL, 0x000fe200078e0269ULL,
0x0000541039397816ULL, 0x000fc4000000003dULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fe200020006ffULL,
0x00000038101c723cULL, 0x000b62000000181cULL, 0x00000010ff517819ULL, 0x100fe4000001163fULL,
0x000000ff3f5b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff587819ULL, 0x000fc4000001163fULL,
0x000000ff56397812ULL, 0x020fe400078ec0ffULL, 0x0000ffff3f4e7812ULL, 0x000fe400078ec0ffULL,
0x00000039ff39723eULL, 0x000fe200020006ffULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0x0000541068387816ULL, 0x000fe4000000003aULL, 0x0000541067397816ULL, 0x000fe40000000039ULL,
0x000000ff5f5f7812ULL, 0x000fc400078ec0ffULL, 0x000000ff61617812ULL, 0x000fe400078ec0ffULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x000000381020723cULL, 0x000b620000001820ULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x000000ff423b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff597819ULL, 0x000fe40000011659ULL, 0x0000005fff38723eULL, 0x020fc400020006ffULL,
0x00000061ff39723eULL, 0x000fe400020006ffULL, 0x000054105d387816ULL, 0x000fe40000000038ULL,
0x0000541064397816ULL, 0x000fe40000000039ULL, 0x0000003bff49723eULL, 0x000fe400020006ffULL,
0x00000008ff5a7819ULL, 0x000fe4000001165aULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x000000381028723cULL, 0x000b620000001828ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x009000000f38783bULL, 0x020ea20000000200ULL, 0x00000059ff59723eULL, 0x000fc400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x000000ff505d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff515f7812ULL, 0x000fe400078ec0ffULL, 0x0000541059507816ULL, 0x000fe4000000005eULL,
0x000054105a517816ULL, 0x000fe40000000060ULL, 0x000000ff435c7812ULL, 0x000fc400078ec0ffULL,
0x00000058ff68723eULL, 0x000fe400020006ffULL, 0x0000005cff59723eULL, 0x000fe200020006ffULL,
0x00000050102c723cULL, 0x000b62000000182cULL, 0x000000ff3c617812ULL, 0x042fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001163cULL, 0x0000ffff3c587812ULL, 0x000fe400078ec0ffULL,
0x0000005dff50723eULL, 0x020fc400020006ffULL, 0x00000010ff5d7819ULL, 0x000fe4000001163cULL,
0x00000008ff3c7819ULL, 0x000fe4000001164cULL, 0x00000008ff4e7819ULL, 0x000fe4000001164eULL,
0x0000005fff51723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fc400020006ffULL, 0x00000010ff5e7819ULL, 0x100fe2000001163dULL,
0x0000000538388232ULL, 0x084fe20000000000ULL, 0x000000ff3d647812ULL, 0x040fe200078ec0ffULL,
0x000000053a3a8232ULL, 0x000fe20000000000ULL, 0x00000018ff5f7819ULL, 0x000fe2000001163dULL,
0x0000000439398232ULL, 0x080fe20000000000ULL, 0x0000ffff3d5a7812ULL, 0x000fe200078ec0ffULL,
0x000000043b3b8232ULL, 0x000fe20000000000ULL, 0x00000057ff67723eULL, 0x000fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fc400020006ffULL, 0x0000004eff3d723eULL, 0x000fe400020006ffULL,
0x0000541065507816ULL, 0x000fe40000000050ULL, 0x000054105b517816ULL, 0x000fe40000000051ULL,
0x00000010ff547819ULL, 0x000fe40000011640ULL, 0x00000010ff4f7819ULL, 0x000fe40000011641ULL,
0x000054103c3c7816ULL, 0x000fe20000000067ULL, 0x000000501030723cULL, 0x000f620000001830ULL,
0x000054103d3d7816ULL, 0x000fc40000000068ULL, 0x000000ff404b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff54547812ULL, 0x000fe400078ec0ffULL, 0x000000ff4f4f7812ULL, 0x000fe200078ec0ffULL,
0x0000003c1010723cULL, 0x000b620000001818ULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x00000054ff4e723eULL, 0x000fe400020006ffULL, 0x0000ffff40527812ULL, 0x000fc400078ec0ffULL,
0x0000004fff19723eULL, 0x020fe400020006ffULL, 0x0000ffff41537812ULL, 0x000fe400078ec0ffULL,
0x000054104b187816ULL, 0x000fe4000000004eULL, 0x000054104d197816ULL, 0x000fe40000000019ULL,
0x00000008ff527819ULL, 0x000fe40000011652ULL, 0x00000008ff537819ULL, 0x000fc40000011653ULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x000000183818723cULL, 0x000b620000001814ULL,
0x00000010ff417819ULL, 0x000fe40000011642ULL, 0x00000010ff407819ULL, 0x000fe40000011643ULL,
0x000000ff41417812ULL, 0x000fe400078ec0ffULL, 0x00000053ff15723eULL, 0x020fe400020006ffULL,
0x0000541052147816ULL, 0x000fc40000000037ULL, 0x0000541015157816ULL, 0x000fe4000000004aULL,
0x000000ff40407812ULL, 0x000fe400078ec0ffULL, 0x00000018ff557819ULL, 0x000fe40000011642ULL,
0x00000018ff567819ULL, 0x000fe20000011643ULL, 0x00000014381c723cULL, 0x000b62000000181cULL,
0x0000ffff42427812ULL, 0x000fe400078ec0ffULL, 0x0000ffff43437812ULL, 0x000fc400078ec0ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000040ff15723eULL, 0x020fe400020006ffULL,
0x00000008ff427819ULL, 0x000fe40000011642ULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x0000541049147816ULL, 0x000fe40000000041ULL, 0x0000541059157816ULL, 0x000fc40000000015ULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x000000143820723cULL, 0x000b620000001820ULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5e5e7812ULL, 0x000fc400078ec0ffULL, 0x0000541042147816ULL, 0x020fe40000000055ULL,
0x0000541043157816ULL, 0x000fe40000000056ULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000010ff517819ULL, 0x000fe2000001163eULL,
0x000000143824723cULL, 0x000b620000001824ULL, 0x000000ff3e607812ULL, 0x000fc400078ec0ffULL,
0x00000018ff507819ULL, 0x000fe4000001163eULL, 0x00000010ff577819ULL, 0x100fe4000001163fULL,
0x0000005dff14723eULL, 0x020fe400020006ffULL, 0x0000005eff15723eULL, 0x000fe400020006ffULL,
0x000000ff3f5b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4c7819ULL, 0x000fc4000001163fULL,
0x0000541061147816ULL, 0x000fe40000000014ULL, 0x0000541064157816ULL, 0x000fe40000000015ULL,
0x0000ffff3e3e7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff587819ULL, 0x000fe20000011658ULL, 0x000000143828723cULL, 0x000b620000001828ULL,
0x00000008ff5a7819ULL, 0x000fc4000001165aULL, 0x000000ff51517812ULL, 0x000fe400078ec0ffULL,
0x000000ff57577812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3e7819ULL, 0x000fe4000001163eULL,
0x00000008ff3f7819ULL, 0x000fe4000001163fULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fc400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000058ff14723eULL, 0x020fe400020006ffULL,
0x0000005aff15723eULL, 0x000fe400020006ffULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fc400020006ffULL, 0x00000050ff50723eULL, 0x000fe400020006ffULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x0000541014147816ULL, 0x000fe4000000005cULL,
0x0000541015157816ULL, 0x000fc4000000005fULL, 0x0000541060607816ULL, 0x000fe40000000051ULL,
0x000054105b617816ULL, 0x000fe40000000057ULL, 0x000054103e3e7816ULL, 0x000fe20000000050ULL,
0x00000014382c723cULL, 0x000f62000000182cULL, 0x000054103f3f7816ULL, 0x000fce000000004cULL,
0x000000603830723cULL, 0x040f700000001830ULL, 0x0000003e3838723cULL, 0x000b6e0000001810ULL,
0x0000f6c80a107811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000010107f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6880036ff7f8cULL, 0x0005e4000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x0000040008157984ULL, 0x000ee40000000800ULL, 0x8000000015ff7812ULL, 0x00afc40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001412177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001714147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040008157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000107824ULL, 0x000fe400078e00ffULL, 0x000059000e0e7a24ULL, 0x010fe400078e02ffULL,
0x00000080ff177424ULL, 0x000fe200078e00ffULL, 0xffffffe010127812ULL, 0x000fe200078ec0ffULL,
0x000000800e167824ULL, 0x000fc800078e00ffULL, 0x0000010009117824ULL, 0x000fe400078e0212ULL,
0x0000640016167625ULL, 0x000fc600078e0017ULL, 0x0000008011117810ULL, 0x000fc80007ffe0ffULL,
0x00000060110e7812ULL, 0x000fca00078ec0ffULL, 0x0000000173377824ULL, 0x000fe200078e020eULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x00000011020e7217ULL, 0x000fe40007800000ULL,
0x0000001010137812ULL, 0x000fe400078ec0ffULL, 0x00000003ff107819ULL, 0x000fe20000011606ULL,
0x000000010e0e7824ULL, 0x000fc600078e0a11ULL, 0x0000000410147810ULL, 0x040fe20007ffe0ffULL,
0x0000000110117824ULL, 0x000fe200078e0213ULL, 0x0000000e130e7217ULL, 0x000fc60007800000ULL,
0x0000000111127824ULL, 0x040fe400078e0206ULL, 0x000000010e0e7824ULL, 0x000fe400078e0a13ULL,
0x0000000811157824ULL, 0x000fc600078e00ffULL, 0x0000000e1400720cULL, 0x0c0fe20003f66070ULL,
0x0000000114147824ULL, 0x000fe200078e0213ULL, 0xfffffff8153c7812ULL, 0x000fe400078ee212ULL,
0x0000000810127810ULL, 0x000fe20007ffe0ffULL, 0x0000000814367824ULL, 0x004fe200078e00ffULL,
0x0000000e1000720cULL, 0x0c0fe40003f86070ULL, 0x0000000c10157810ULL, 0x000fe20007ffe0ffULL,
0x0000000111107824ULL, 0x000fe200078e0237ULL, 0x0000000e1200720cULL, 0x080fe20003f46070ULL,
0x0000000114117824ULL, 0x000fe200078e0206ULL, 0x0000000e1500720cULL, 0x000fe20003f06070ULL,
0x0000000112127824ULL, 0x000fc400078e0213ULL, 0x0000000114147824ULL, 0x000fe200078e0237ULL,
0xfffffff8360e7812ULL, 0x000fe200078ee211ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000115407824ULL, 0x000fe200078e0213ULL, 0x0000006210137212ULL, 0x000fe200078efcffULL,
0x00000001123d7824ULL, 0x040fe400078e0206ULL, 0x00000008123e7824ULL, 0x000fe200078e00ffULL,
0x0000001316107210ULL, 0x000fe20007fbe0ffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee23dULL, 0x0000000112367824ULL, 0x100fe200078e0237ULL,
0x00000062143d7212ULL, 0x000fe200078efcffULL, 0x0000000140127824ULL, 0x000fe400078e0237ULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x00000062363f7212ULL, 0x000fc600078efcffULL, 0x0000000117117824ULL, 0x040fe200028e0611ULL,
0x0000003d16147210ULL, 0x000fe20007fbe0ffULL, 0x0000000140417824ULL, 0x000fe200078e0206ULL,
0x00000062123d7212ULL, 0x000fe200078efcffULL, 0x0000000840407824ULL, 0x000fe400078e00ffULL,
0x0000000117157824ULL, 0x040fe200028e0615ULL, 0x0000003f16367210ULL, 0x000fe20007fbe0ffULL,
0x000000100e3f7824ULL, 0x100fe200078e0269ULL, 0x0000003d16127210ULL, 0x000fe20007fde0ffULL,
0x000000103c3d7824ULL, 0x000fe200078e0269ULL, 0xfffffff840407812ULL, 0x000fe200078ee241ULL,
0x0000000117377824ULL, 0x000fc400028e0637ULL, 0x000000103e417824ULL, 0x000fe200078e0269ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000103d7faeULL, 0x0003e2000e101c48ULL,
0x0000000117137824ULL, 0x000fe400030e0613ULL, 0x0000001040437824ULL, 0x000fe200078e0269ULL,
0x00000000143f7faeULL, 0x0003e8000d901c48ULL, 0x0000000036417faeULL, 0x0003e8000d101c48ULL,
0x0000000012437faeULL, 0x0003e2000c101c48ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001010117812ULL, 0x000fc800078ec0ffULL, 0x0000001106117211ULL, 0x000fc800078fe8ffULL,
0x0000000811367810ULL, 0x044fe20007ffe0ffULL, 0x0000000111127824ULL, 0x040fe200078e0237ULL,
0x0000000411147810ULL, 0x040fe20007ffe0ffULL, 0x00000001110e7824ULL, 0x140fe400078e0206ULL,
0x0000000136137824ULL, 0x140fe400078e0206ULL, 0x00000008363e7824ULL, 0x000fe400078e00ffULL,
0x0000000811157824ULL, 0x040fe200078e00ffULL, 0x0000000c11117810ULL, 0x000fe20007ffe0ffULL,
0x0000000114107824ULL, 0x000fe200078e0206ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL,
0x00000008143d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8150e7812ULL, 0x000fe200078ee20eULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff83d3c7812ULL, 0x000fe200078ee210ULL,
0x0000000114147824ULL, 0x100fe200078e0237ULL, 0x00000062123d7212ULL, 0x000fe200078efcffULL,
0x0000000136367824ULL, 0x100fe400078e0237ULL, 0x0000000111107824ULL, 0x040fe200078e0237ULL,
0x0000003d16127210ULL, 0x000fe20007f1e0ffULL, 0x00000001113f7824ULL, 0x040fe400078e0206ULL,
0x0000000811407824ULL, 0x000fe400078e00ffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee23fULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000006214417212ULL, 0x000fc600078efcffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x00000062363f7212ULL, 0x080fe400078efcffULL, 0x0000004116147210ULL, 0x000fe20007f5e0ffULL,
0x0000000117137824ULL, 0x040fe200000e0613ULL, 0x00000062103d7212ULL, 0x000fe200078efcffULL,
0x000000103e417824ULL, 0x000fe200078e0269ULL, 0x0000003f16367210ULL, 0x040fe20007f1e0ffULL,
0x0000000117157824ULL, 0x000fe200010e0615ULL, 0x0000003d16107210ULL, 0x000fe20007f7e0ffULL,
0x000000100e3d7824ULL, 0x000fc400078e0269ULL, 0x000000103c3f7824ULL, 0x000fe400078e0269ULL,
0x0000000117377824ULL, 0x040fe200000e0637ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000123d7faeULL, 0x0003e2000b901c48ULL, 0x0000000117117824ULL, 0x000fe400018e0611ULL,
0x0000001040437824ULL, 0x000fe200078e0269ULL, 0x00000000143f7faeULL, 0x0003e8000b901c48ULL,
0x0000000036417faeULL, 0x0003e8000b901c48ULL, 0x0000000010437faeULL, 0x0003e4000b901c48ULL,
0x00000008000e7824ULL, 0x000fca00078e00ffULL, 0xfffffff00e0e7812ULL, 0x000fc800078ec0ffULL,
0x000000000e0573c2ULL, 0x000ea200000e0000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000f6a805057890ULL, 0x004fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a8000e127f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f628000d107f8cULL, 0x000664000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x00f62c000d377984ULL, 0x000f240000000800ULL, 0x8000000037ff7812ULL, 0x012fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x00000036143d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e15ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc80000011437ULL,
0x0000003d0e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x000000020e0e7819ULL, 0x000fc80000001237ULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f62c000d377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020000e7824ULL, 0x000fca00078e00ffULL, 0xffffff800e117812ULL, 0x000fc800078ec0ffULL,
0x00000080620e7810ULL, 0x000fca0007ffe011ULL, 0x000000016b0e7824ULL, 0x000fca00078e020eULL,
0x00f000000e367984ULL, 0x000e680000000800ULL, 0x00f200000e377984ULL, 0x0006a20000000800ULL,
0x0000000b3600720bULL, 0x002fe20003f1d000ULL, 0x0000d8d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x008fc800000e0100ULL, 0x0000ffff103d7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff3c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0e7224ULL, 0x000fd200078e000bULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000178117810ULL, 0x000fe40007ffe0ffULL, 0x0000000b3600720bULL, 0x000fe40003f54000ULL,
0x000000001100720cULL, 0x000fe20003f05270ULL, 0x0000d8727f007947ULL, 0x000fd4000b800000ULL,
0x00000000000e7806ULL, 0x000fc400010e0100ULL, 0x0000008000148824ULL, 0x000fe200078e0262ULL,
0x0000000b36108209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x000099100e117816ULL, 0x000fe200000000ffULL, 0x000000016b158824ULL, 0x000fca00078e0214ULL,
0x00f4001015008388ULL, 0x0003e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000b36107209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0eff7812ULL, 0x000fc6000780c0ffULL,
0x0000000b10107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x00000010003f7308ULL, 0x000e640000000800ULL, 0x0000003f0c0c7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe20000011606ULL,
0x0000d7927f007947ULL, 0x000fea000b800000ULL, 0x00001f103f147589ULL, 0x0002e400000e0000ULL,
0x0000001418187220ULL, 0x08cfe20000410000ULL, 0x0000001419197220ULL, 0x080fe20000410000ULL,
0x000000141c1c7220ULL, 0x080fe20000410000ULL, 0x000000141d1d7220ULL, 0x080fe20000410000ULL,
0x0000001420207220ULL, 0x080fe20000410000ULL, 0x0000001421217220ULL, 0x080fe20000410000ULL,
0x0000001424247220ULL, 0x080fe20000410000ULL, 0x0000001425257220ULL, 0x080fe20000410000ULL,
0x0000001428287220ULL, 0x080fe20000410000ULL, 0x0000001429297220ULL, 0x080fe20000410000ULL,
0x000000142c2c7220ULL, 0x080fe20000410000ULL, 0x000000142d2d7220ULL, 0x080fe20000410000ULL,
0x0000001430307220ULL, 0x080fe20000410000ULL, 0x0000001431317220ULL, 0x080fe20000410000ULL,
0x0000001438387220ULL, 0x080fe20000410000ULL, 0x0000001439397220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000eff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000806107811ULL, 0x002fe200078ff0ffULL,
0x0000d6727f007947ULL, 0x000fea000b800000ULL, 0x00001f103f147589ULL, 0x0002e400000e0000ULL,
0x000000141a1a7220ULL, 0x08cfe20000410000ULL, 0x000000141b1b7220ULL, 0x080fe20000410000ULL,
0x000000141e1e7220ULL, 0x080fe20000410000ULL, 0x000000141f1f7220ULL, 0x080fe20000410000ULL,
0x0000001422227220ULL, 0x080fe20000410000ULL, 0x0000001423237220ULL, 0x080fe20000410000ULL,
0x0000001426267220ULL, 0x080fe20000410000ULL, 0x0000001427277220ULL, 0x080fe20000410000ULL,
0x000000142a2a7220ULL, 0x080fe20000410000ULL, 0x000000142b2b7220ULL, 0x080fe20000410000ULL,
0x000000142e2e7220ULL, 0x080fe20000410000ULL, 0x000000142f2f7220ULL, 0x080fe20000410000ULL,
0x0000001432327220ULL, 0x080fe20000410000ULL, 0x0000001433337220ULL, 0x080fe20000410000ULL,
0x000000143a3a7220ULL, 0x080fe20000410000ULL, 0x000000143b3b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff3dff7812ULL, 0x000fe2000780600eULL,
0x00000001ff3c7424ULL, 0x000fe200078e00ffULL, 0x0000000b360e7209ULL, 0x000fd60007810000ULL,
0x8000000e36360221ULL, 0x000fe20000010000ULL, 0x00007610ff3c0816ULL, 0x000fc6000000003cULL,
0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL, 0x0000003600070308ULL, 0x000e640000000800ULL,
0x0000000737370220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000c370c7221ULL, 0x004fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x00000008000b7824ULL, 0x000fca00078e00ffULL, 0xfffffff00b367812ULL, 0x000fca00078ec0ffULL,
0x00f6b400360b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410147210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011415ULL,
0x000000140b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff147224ULL, 0x000fca00000e0615ULL,
0x000000020b0b7819ULL, 0x000fc80000001214ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000137377810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b400360b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099103c0b7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000007ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff347819ULL, 0x000fe40000011606ULL,
0x00005410040b7816ULL, 0x000fe20000000004ULL, 0x0000d2227f007947ULL, 0x000fea000b800000ULL,
0x00001f340b057589ULL, 0x0002a400000e0000ULL, 0x0000000834107810ULL, 0x000fe20007ffe0ffULL,
0x0000d2527f007947ULL, 0x000fea000b800000ULL, 0x00001f100b047589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001034107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200078e000bULL, 0x000057f000157802ULL, 0x000fc40000000f00ULL,
0x0000da6000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001834107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200078e000bULL,
0x0000584000157802ULL, 0x000fc40000000f00ULL, 0x0000da1000007944ULL, 0x006fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x00001000690b7810ULL, 0x00afe20007ffe0ffULL, 0x00980000473c783bULL, 0x000e680000000200ULL,
0x0000001046347824ULL, 0x000fc400078e020bULL, 0x0000001045407824ULL, 0x000fc800078e020bULL,
0x000000003434783bULL, 0x000ee80000004200ULL, 0x000000004040783bULL, 0x000f220000004200ULL,
0x000000053c3c8232ULL, 0x086fe40000000000ULL, 0x000000053e3e8232ULL, 0x000fe40000000000ULL,
0x000000043d3d8232ULL, 0x080fe40000000000ULL, 0x000000043f3f8232ULL, 0x000fe20000000000ULL,
0x00000010ff497819ULL, 0x008fc40000011634ULL, 0x00000018ff557819ULL, 0x000fe40000011634ULL,
0x000000ff34587812ULL, 0x040fe400078ec0ffULL, 0x0000ffff34147812ULL, 0x000fe200078ec0ffULL,
0x0000001044347824ULL, 0x000fe200078e020bULL, 0x00000010ff157819ULL, 0x100fe40000011635ULL,
0x00000018ff5e7819ULL, 0x000fe40000011635ULL, 0x000000ff355f7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff35537812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4a7819ULL, 0x100fe40000011636ULL,
0x000000ff365d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe40000011636ULL,
0x0000ffff36597812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4c7819ULL, 0x000fc40000011637ULL,
0x000000ff375b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff677819ULL, 0x000fe40000011637ULL,
0x0000ffff375a7812ULL, 0x000fe400078ec0ffULL, 0x000000003434783bULL, 0x000e620000004200ULL,
0x000000ff49497812ULL, 0x000fe400078ec0ffULL, 0x000000ff15157812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5c7819ULL, 0x010fc40000011640ULL, 0x000000ff40647812ULL, 0x040fe400078ec0ffULL,
0x00000018ff527819ULL, 0x000fe40000011640ULL, 0x0000ffff40567812ULL, 0x000fe400078ec0ffULL,
0x000000ff42547812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4d7819ULL, 0x000fe40000011643ULL,
0x000000ff43507812ULL, 0x000fc400078ec0ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011643ULL,
0x0000ffff43117812ULL, 0x000fe400078ec0ffULL, 0x00000055ff43723eULL, 0x000fe400020006ffULL,
0x0000005bff40723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000005fff55723eULL, 0x000fc400020006ffULL, 0x00000049ff5b723eULL, 0x000fe400020006ffULL,
0x00000015ff15723eULL, 0x000fe400020006ffULL, 0x00000054ff49723eULL, 0x000fe400020006ffULL,
0x00000008ff547819ULL, 0x000fe40000011614ULL, 0x0000541058147816ULL, 0x000fe4000000005bULL,
0x0000541055157816ULL, 0x000fc40000000015ULL, 0x00000008ff537819ULL, 0x000fe40000011653ULL,
0x00000010ff4b7819ULL, 0x100fe40000011642ULL, 0x00000018ff4e7819ULL, 0x000fe20000011642ULL,
0x000000143c18723cULL, 0x000b620000001818ULL, 0x0000ffff42107812ULL, 0x000fe400078ec0ffULL,
0x0000005eff42723eULL, 0x000fe400020006ffULL, 0x000000ff4a4a7812ULL, 0x000fc400078ec0ffULL,
0x00000054ff14723eULL, 0x020fe400020006ffULL, 0x00000053ff15723eULL, 0x000fe400020006ffULL,
0x0000541014147816ULL, 0x000fe40000000043ULL, 0x0000541015157816ULL, 0x000fe20000000042ULL,
0x0000001048427824ULL, 0x000fe200078e020bULL, 0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff657819ULL, 0x000fc40000011641ULL, 0x000000ff41607812ULL, 0x040fe200078ec0ffULL,
0x000000143c1c723cULL, 0x000be2000000181cULL, 0x00000018ff517819ULL, 0x000fe40000011641ULL,
0x0000ffff41577812ULL, 0x000fe400078ec0ffULL, 0x0000005dff41723eULL, 0x000fe400020006ffULL,
0x0000004aff14723eULL, 0x020fe400020006ffULL, 0x0000004cff15723eULL, 0x000fc400020006ffULL,
0x0000541041147816ULL, 0x000fe40000000014ULL, 0x0000541040157816ULL, 0x000fe40000000015ULL,
0x00000010ff587819ULL, 0x102fe20000011634ULL, 0x000000004240783bULL, 0x000fe20000004200ULL,
0x000000ff346c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe20000011634ULL,
0x000000143c20723cULL, 0x000be20000001820ULL, 0x0000ffff34537812ULL, 0x000fc400078ec0ffULL,
0x00000010ff547819ULL, 0x100fe40000011635ULL, 0x000000ff35347812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5e7819ULL, 0x000fe40000011635ULL, 0x0000ffff35557812ULL, 0x000fe400078ec0ffULL,
0x00000008ff357819ULL, 0x000fe40000011659ULL, 0x00000008ff5a7819ULL, 0x000fc4000001165aULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000010ff4a7819ULL, 0x100fe40000011636ULL,
0x000000ff365f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011636ULL,
0x0000ffff36147812ULL, 0x020fe400078ec0ffULL, 0x00000035ff35723eULL, 0x000fc400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000005aff36723eULL, 0x000fe400020006ffULL,
0x00000034ff5a723eULL, 0x000fe400020006ffULL, 0x0000541035347816ULL, 0x000fe40000000068ULL,
0x0000541036357816ULL, 0x000fe40000000067ULL, 0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff65657812ULL, 0x000fe400078ec0ffULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x000000343c24723cULL, 0x000b620000001824ULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000010ff4c7819ULL, 0x000fe40000011637ULL, 0x000000ff37617812ULL, 0x000fe400078ec0ffULL,
0x0000005cff34723eULL, 0x020fc400020006ffULL, 0x00000065ff35723eULL, 0x000fe400020006ffULL,
0x0000541064347816ULL, 0x000fe40000000034ULL, 0x0000541060357816ULL, 0x000fe40000000035ULL,
0x00000018ff5d7819ULL, 0x000fe40000011637ULL, 0x0000ffff37157812ULL, 0x000fe400078ec0ffULL,
0x00000008ff567819ULL, 0x000fe20000011656ULL, 0x000000343c28723cULL, 0x000b620000001828ULL,
0x00000008ff577819ULL, 0x000fe20000011657ULL, 0x009800000f34783bULL, 0x020e620000000200ULL,
0x00000008ff107819ULL, 0x000fc40000011610ULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000008ff647819ULL, 0x000fe40000011611ULL,
0x0000004eff4e723eULL, 0x000fc400020006ffULL, 0x00000010ff11723eULL, 0x000fe400020006ffULL,
0x000000ff58107812ULL, 0x000fe400078ec0ffULL, 0x000000ff54547812ULL, 0x000fe400078ec0ffULL,
0x000000ff4b4b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x0000541056567816ULL, 0x000fc40000000052ULL, 0x0000541057577816ULL, 0x000fe40000000051ULL,
0x00005410114e7816ULL, 0x000fe4000000004eULL, 0x0000006cff59723eULL, 0x000fe400020006ffULL,
0x00000010ff10723eULL, 0x000fe200020006ffULL, 0x000000563c2c723cULL, 0x000b62000000182cULL,
0x00000054ff11723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x0000004bff4b723eULL, 0x000fe200020006ffULL, 0x0000000534348232ULL, 0x082fe20000000000ULL,
0x0000004dff4d723eULL, 0x000fe200020006ffULL, 0x0000000536368232ULL, 0x000fe20000000000ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x0000000435358232ULL, 0x080fe20000000000ULL,
0x00000064ff68723eULL, 0x000fe200020006ffULL, 0x0000000437378232ULL, 0x000fe20000000000ULL,
0x0000541059107816ULL, 0x000fe40000000010ULL, 0x000054105a117816ULL, 0x000fc40000000011ULL,
0x0000541049567816ULL, 0x020fe4000000004bULL, 0x0000541050577816ULL, 0x000fe4000000004dULL,
0x00005410684f7816ULL, 0x000fe2000000004fULL, 0x000000103418723cULL, 0x000be20000001818ULL,
0x00000008ff147819ULL, 0x000fe40000011614ULL, 0x00000008ff157819ULL, 0x000fe40000011615ULL,
0x0000005bff5b723eULL, 0x000fc400020006ffULL, 0x0000005dff64723eULL, 0x000fe200020006ffULL,
0x000000563c30723cULL, 0x040b640000001830ULL, 0x00000014ff10723eULL, 0x020fe400020006ffULL,
0x00000015ff11723eULL, 0x000fe400020006ffULL, 0x00000010ff517819ULL, 0x100fe40000011640ULL,
0x000000ff40677812ULL, 0x000fe200078ec0ffULL, 0x0000004e3c38723cULL, 0x000f620000001838ULL,
0x00000018ff607819ULL, 0x000fc40000011640ULL, 0x0000ffff404b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff527819ULL, 0x100fe40000011641ULL, 0x000000ff41657812ULL, 0x040fe400078ec0ffULL,
0x00000018ff577819ULL, 0x000fe40000011641ULL, 0x0000ffff414d7812ULL, 0x000fe400078ec0ffULL,
0x0000541010107816ULL, 0x000fc4000000005bULL, 0x0000541011117816ULL, 0x000fe40000000064ULL,
0x00000010ff417819ULL, 0x100fe40000011642ULL, 0x000000ff42567812ULL, 0x000fe400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe20000011642ULL, 0x000000103424723cULL, 0x000b620000001824ULL,
0x00000010ff497819ULL, 0x000fe40000011643ULL, 0x000000ff43507812ULL, 0x000fc400078ec0ffULL,
0x00000018ff0f7819ULL, 0x000fe40000011643ULL, 0x0000ffff42427812ULL, 0x000fe400078ec0ffULL,
0x0000ffff43437812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4d7819ULL, 0x000fe4000001164dULL,
0x00000008ff537819ULL, 0x000fe40000011653ULL, 0x00000008ff557819ULL, 0x000fc40000011655ULL,
0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff51517812ULL, 0x000fe400078ec0ffULL, 0x000000ff52527812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4b7819ULL, 0x000fe4000001164bULL, 0x000000ff41417812ULL, 0x000fc400078ec0ffULL,
0x000000ff49497812ULL, 0x000fe400078ec0ffULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000008ff437819ULL, 0x000fe40000011643ULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x0000004dff11723eULL, 0x020fe400020006ffULL, 0x0000006aff5c723eULL, 0x000fc400020006ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000067ff58723eULL, 0x000fe400020006ffULL,
0x00000065ff3c723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fc400020006ffULL,
0x00000055ff5d723eULL, 0x000fe400020006ffULL, 0x00000060ff3d723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000051ff51723eULL, 0x000fc400020006ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe400020006ffULL,
0x0000004bff10723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x00000040ff40723eULL, 0x000fc400020006ffULL,
0x0000000fff0f723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x0000541011117816ULL, 0x000fe40000000057ULL,
0x00005410535c7816ULL, 0x000fe4000000005cULL, 0x000054105d5d7816ULL, 0x000fc4000000005eULL,
0x000054105f607816ULL, 0x000fe4000000004aULL, 0x0000541061617816ULL, 0x000fe4000000004cULL,
0x0000541058587816ULL, 0x000fe20000000051ULL, 0x0000005c341c723cULL, 0x000f62000000181cULL,
0x000054103c597816ULL, 0x000fe40000000052ULL, 0x0000541010107816ULL, 0x000fe4000000003dULL,
0x0000541056567816ULL, 0x000fc40000000041ULL, 0x0000541050577816ULL, 0x000fe20000000049ULL,
0x000000603420723cULL, 0x000f620000001820ULL, 0x0000541042427816ULL, 0x000fe40000000040ULL,
0x0000541043437816ULL, 0x000fca000000000fULL, 0x000000583428723cULL, 0x040f700000001828ULL,
0x00000010342c723cULL, 0x040b6e000000182cULL, 0x0000000200117824ULL, 0x020fe200078e00ffULL,
0x000000563430723cULL, 0x000b620000001830ULL, 0x0000f6c80a107811ULL, 0x000fc600078e18ffULL,
0xfffffff8110f7812ULL, 0x000fc800078ec0ffULL, 0x000000423434723cULL, 0x000b620000001838ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000010107f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f690000fff7f8cULL, 0x0005e4000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x00000400080f7984ULL, 0x004ea40000000800ULL, 0x800000000fff7812ULL, 0x006fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3a7224ULL, 0x020fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x0000003814387210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e15ULL, 0x003d09003800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011439ULL,
0x000000380f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff387224ULL, 0x000fca00000e0639ULL,
0x000000020f0f7819ULL, 0x000fc80000001238ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400080f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000200a0f7824ULL, 0x000fc800078e00ffULL, 0x00000100090f7824ULL, 0x000fca00078e020fULL,
0x000000c00f117810ULL, 0x000fc80007ffe0ffULL, 0x0000006011147812ULL, 0x000fca00078ec0ffULL,
0x0000000173147824ULL, 0x000fe200078e0214ULL, 0x000003e000009947ULL, 0x000fea0003800000ULL,
0x0000001102107217ULL, 0x000fe20007800000ULL, 0x0000001000157824ULL, 0x000fc800078e00ffULL,
0x0000000110107824ULL, 0x000fe200078e0a11ULL, 0x0000001015157812ULL, 0x000fe400078ec0ffULL,
0x00000003ff117819ULL, 0x000fe40000011606ULL, 0x0000001015107217ULL, 0x000fe40007800000ULL,
0x0000000411387810ULL, 0x040fe20007ffe0ffULL, 0x0000000111397824ULL, 0x140fe200078e0215ULL,
0x00000008113a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000110107824ULL, 0x100fe200078e0a15ULL,
0x0000000c113c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001383b7824ULL, 0x000fc400078e0215ULL,
0x00000008393f7824ULL, 0x000fe200078e00ffULL, 0x000000101100720cULL, 0x080fe20003f86070ULL,
0x0000000139117824ULL, 0x040fe200078e0214ULL, 0x000000103800720cULL, 0x080fe20003f66070ULL,
0x0000000139387824ULL, 0x100fe200078e0206ULL, 0x000000103a00720cULL, 0x080fe20003f46070ULL,
0x000000013b397824ULL, 0x040fe200078e0206ULL, 0x000000103c00720cULL, 0x000fe20003f06070ULL,
0x000000083b3e7824ULL, 0x000fe400078e00ffULL, 0x0000008011107825ULL, 0x000fc600078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee239ULL, 0x000000013a3d7824ULL, 0x100fe400078e0215ULL,
0x000000013b3a7824ULL, 0x000fe400078e0214ULL, 0x000000013c417824ULL, 0x000fe200078e0215ULL,
0x0000006210157212ULL, 0x000fe200078efcffULL, 0x000000013d397824ULL, 0x000fe200078e0206ULL,
0xfffffff83f3c7812ULL, 0x000fe200078ee238ULL, 0x000000083d407824ULL, 0x000fe200078e00ffULL,
0x0000001516107210ULL, 0x000fe20007fbe0ffULL, 0x000000803a3a7825ULL, 0x000fc600078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee239ULL, 0x000000013d387824ULL, 0x100fe200078e0214ULL,
0x000000623a3d7212ULL, 0x000fe200078efcffULL, 0x0000000141147824ULL, 0x000fe400078e0214ULL,
0x0000008038387825ULL, 0x000fc800078e00ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x00000062383f7212ULL, 0x000fc600078efcffULL, 0x0000000117117824ULL, 0x000fe200028e0611ULL,
0x0000003d163a7210ULL, 0x000fe20007fbe0ffULL, 0x0000000141427824ULL, 0x040fe200078e0206ULL,
0x00000062143d7212ULL, 0x000fe200078efcffULL, 0x0000000841417824ULL, 0x000fe400078e00ffULL,
0x00000001173b7824ULL, 0x000fe200028e063bULL, 0x0000003f16387210ULL, 0x000fe20007fbe0ffULL,
0x00000010403f7824ULL, 0x100fe200078e020bULL, 0x0000003d16147210ULL, 0x000fe20007fde0ffULL,
0x000000103c3d7824ULL, 0x000fe200078e020bULL, 0xfffffff841427812ULL, 0x000fe200078ee242ULL,
0x0000000117397824ULL, 0x000fc400028e0639ULL, 0x0000000117157824ULL, 0x000fe200030e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000103d7faeULL, 0x0003e2000e101c48ULL,
0x000000103e177824ULL, 0x100fe400078e020bULL, 0x0000001042417824ULL, 0x000fc600078e020bULL,
0x000000003a177faeULL, 0x0003e8000d901c48ULL, 0x00000000383f7faeULL, 0x0003e8000d101c48ULL,
0x0000000014417faeULL, 0x0003e2000c101c48ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001000107824ULL, 0x000fca00078e00ffULL, 0x0000001010117812ULL, 0x000fc800078ec0ffULL,
0x0000001106117211ULL, 0x000fc800078fe8ffULL, 0x0000000411157810ULL, 0x040fe20007ffe0ffULL,
0x0000000111107824ULL, 0x140fe200078e0206ULL, 0x0000000811397810ULL, 0x040fe20007ffe0ffULL,
0x00000008113b7824ULL, 0x000fe400078e00ffULL, 0x0000000115387824ULL, 0x040fe400078e0206ULL,
0x00000008153d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3c7812ULL, 0x000fe200078ee210ULL,
0x00000001393a7824ULL, 0x040fe400078e0206ULL, 0x00000008393f7824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3e7812ULL, 0x000fe200078ee238ULL, 0x0000000111387824ULL, 0x040fe200078e0214ULL,
0x0000000c11117810ULL, 0x000fc40007ffe0ffULL, 0xfffffff83f407812ULL, 0x000fe200078ee23aULL,
0x00000001153a7824ULL, 0x100fe400078e0214ULL, 0x0000000139157824ULL, 0x000fe400078e0214ULL,
0x0000008038387825ULL, 0x000fc800078e00ffULL, 0x0000000111107824ULL, 0x040fe200078e0214ULL,
0x00000062383d7212ULL, 0x000fe200078efcffULL, 0x00000001113f7824ULL, 0x040fe400078e0206ULL,
0x0000000811427824ULL, 0x000fe200078e00ffULL, 0x0000003d16387210ULL, 0x000fe20007f1e0ffULL,
0x000000803a3a7825ULL, 0x000fc600078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee23fULL,
0x0000008015147825ULL, 0x000fe200078e00ffULL, 0x000000623a417212ULL, 0x000fc600078efcffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x00000062143f7212ULL, 0x080fe400078efcffULL,
0x00000041163a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000117397824ULL, 0x040fe200000e0639ULL,
0x00000062103d7212ULL, 0x000fe200078efcffULL, 0x0000001042417824ULL, 0x000fe200078e020bULL,
0x0000003f16147210ULL, 0x040fe20007f1e0ffULL, 0x00000001173b7824ULL, 0x000fe200010e063bULL,
0x0000003d16107210ULL, 0x000fe20007f7e0ffULL, 0x000000103c3d7824ULL, 0x000fc400078e020bULL,
0x0000000117157824ULL, 0x040fe400000e0615ULL, 0x0000000117117824ULL, 0x000fe200018e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383d7faeULL, 0x0003e2000b901c48ULL,
0x000000103e177824ULL, 0x100fe400078e020bULL, 0x00000010403f7824ULL, 0x000fc600078e020bULL,
0x000000003a177faeULL, 0x0003e8000b901c48ULL, 0x00000000143f7faeULL, 0x0003e8000b901c48ULL,
0x0000000010417faeULL, 0x0003e4000b901c48ULL, 0x000000007b0573c2ULL, 0x000ea200000e0000ULL,
0x000000026d6d7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff6a7424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x000000666d00720cULL, 0x000fda0003f06070ULL,
0x000000016d108824ULL, 0x000fe400078e0274ULL, 0x00000004ff118424ULL, 0x000fe200078e00ffULL,
0x0000f6b005057890ULL, 0x004fc6000fffe03fULL, 0x0000660010108625ULL, 0x000fca00078e0011ULL,
0x00000008106a8981ULL, 0x000322000c1e1900ULL, 0x0000000800147824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a05ULL, 0xfffffff014147812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6b00014167f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f648000d107f8cULL, 0x0022a4000c80043fULL, 0x0000000000147805ULL, 0x004fc40000015200ULL,
0x00f64c000d397984ULL, 0x000ea40000000800ULL, 0x8000000039ff7812ULL, 0x004fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x00000038143b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e15ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff387819ULL, 0x000fc80000011439ULL,
0x0000003b38387211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000238387819ULL, 0x000fc80000001239ULL, 0x000000380000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c000d397984ULL, 0x000ea40000000800ULL,
0x8000000039ff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020000d7824ULL, 0x002fca00078e00ffULL, 0xffffff800d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000010062107810ULL, 0x000fca0007ffe00dULL, 0x000000016b107824ULL, 0x000fca00078e0210ULL,
0x00f0000010397984ULL, 0x000e680000000800ULL, 0x00f2000010387984ULL, 0x0004e20000000800ULL,
0x0000000e3900720bULL, 0x002fe20003f1d000ULL, 0x0000b4d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x004fc800000e0100ULL, 0x0000ffff103c7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff3a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x000fd200078e000eULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000002780d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000e3900720bULL, 0x000fe40003f54000ULL,
0x000000000d00720cULL, 0x000fe20003f05270ULL, 0x0000b4727f007947ULL, 0x000fd4000b800000ULL,
0x00000000000d7806ULL, 0x000fc400010e0100ULL, 0x0000008000148824ULL, 0x000fe200078e0262ULL,
0x0000000e39108209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x000099100d117816ULL, 0x000fe200000000ffULL, 0x000000016b158824ULL, 0x000fca00078e0214ULL,
0x00f4001015008388ULL, 0x0003e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000e39117209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0dff7812ULL, 0x000fc6000780c0ffULL,
0x0000000e11107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x00000010003b7308ULL, 0x000e640000000800ULL, 0x0000003b0c0c7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe20000011606ULL,
0x0000b3927f007947ULL, 0x000fea000b800000ULL, 0x00001f103b147589ULL, 0x0002a400000e0000ULL,
0x0000001418187220ULL, 0x084fe20000410000ULL, 0x0000001419197220ULL, 0x080fe20000410000ULL,
0x000000141c1c7220ULL, 0x080fe20000410000ULL, 0x000000141d1d7220ULL, 0x080fe20000410000ULL,
0x0000001420207220ULL, 0x080fe20000410000ULL, 0x0000001421217220ULL, 0x080fe20000410000ULL,
0x0000001424247220ULL, 0x080fe20000410000ULL, 0x0000001425257220ULL, 0x080fe20000410000ULL,
0x0000001428287220ULL, 0x080fe20000410000ULL, 0x0000001429297220ULL, 0x080fe20000410000ULL,
0x000000142c2c7220ULL, 0x080fe20000410000ULL, 0x000000142d2d7220ULL, 0x080fe20000410000ULL,
0x0000001430307220ULL, 0x080fe20000410000ULL, 0x0000001431317220ULL, 0x080fe20000410000ULL,
0x0000001434347220ULL, 0x080fe20000410000ULL, 0x0000001435357220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000806107811ULL, 0x002fe200078ff0ffULL,
0x0000b2727f007947ULL, 0x000fea000b800000ULL, 0x00001f103b147589ULL, 0x0002a400000e0000ULL,
0x000000141a1a7220ULL, 0x084fe20000410000ULL, 0x000000141b1b7220ULL, 0x080fe20000410000ULL,
0x000000141e1e7220ULL, 0x080fe20000410000ULL, 0x000000141f1f7220ULL, 0x080fe20000410000ULL,
0x0000001422227220ULL, 0x080fe20000410000ULL, 0x0000001423237220ULL, 0x080fe20000410000ULL,
0x0000001426267220ULL, 0x080fe20000410000ULL, 0x0000001427277220ULL, 0x080fe20000410000ULL,
0x000000142a2a7220ULL, 0x080fe20000410000ULL, 0x000000142b2b7220ULL, 0x080fe20000410000ULL,
0x000000142e2e7220ULL, 0x080fe20000410000ULL, 0x000000142f2f7220ULL, 0x080fe20000410000ULL,
0x0000001432327220ULL, 0x080fe20000410000ULL, 0x0000001433337220ULL, 0x080fe20000410000ULL,
0x0000001436367220ULL, 0x080fe20000410000ULL, 0x0000001437377220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff3cff7812ULL, 0x000fe2000780600dULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000000e390d7209ULL, 0x000fd60007810000ULL,
0x8000000d39390221ULL, 0x000fe20000010000ULL, 0x00007610ff3a0816ULL, 0x000fc6000000003aULL,
0x3fb8aa3b39390820ULL, 0x000fc80000410000ULL, 0x0000003900070308ULL, 0x000e640000000800ULL,
0x0000000738380220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000c380c7221ULL, 0x008fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x00000008000e7824ULL, 0x000fca00078e00ffULL, 0xfffffff00e387812ULL, 0x000fca00078ec0ffULL,
0x00f6ac0038157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410397210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc80000011415ULL,
0x000000390e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x000000020e0e7819ULL, 0x000fc80000001215ULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013b3b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0038157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099103a0e7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000007ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe40000011606ULL,
0x00005410040e7816ULL, 0x000fe20000000004ULL, 0x0000ae227f007947ULL, 0x000fea000b800000ULL,
0x00001f130e057589ULL, 0x0002a400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x0000ae527f007947ULL, 0x000fea000b800000ULL, 0x00001f100e047589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200078e000eULL, 0x00007db000157802ULL, 0x000fc40000000f00ULL,
0x0000b4a000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200078e000eULL,
0x00007e0000157802ULL, 0x000fc40000000f00ULL, 0x0000b45000007944ULL, 0x016fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001046107824ULL, 0x108fe200078e0269ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000001045387824ULL, 0x100fe200078e0269ULL,
0x0000000706437812ULL, 0x000fe200078ec0ffULL, 0x00000010443c7824ULL, 0x000fe200078e0269ULL,
0x00000002630e7810ULL, 0x002fe20007ffe0ffULL, 0x000000001010783bULL, 0x000e620000004200ULL,
0x0000000843437812ULL, 0x000fc600078ef806ULL, 0x000000003838783bULL, 0x000ee40000004200ULL,
0x0000000843437824ULL, 0x000fe400078e00ffULL, 0x000000003c3c783bULL, 0x000ea60000004200ULL,
0xfffffff8430e7812ULL, 0x000fe400078ee20eULL, 0x00000010ff147819ULL, 0x006fe40000011610ULL,
0x000000ff10157812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6e7819ULL, 0x000fe40000011610ULL,
0x0000ffff10517812ULL, 0x000fe400078ec0ffULL, 0x00000010ff407819ULL, 0x100fe40000011611ULL,
0x000000ff11417812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011611ULL,
0x0000ffff11547812ULL, 0x000fc400078ec0ffULL, 0x00000010ff467819ULL, 0x100fe40000011612ULL,
0x000000ff12657812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011612ULL,
0x0000ffff125f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff677819ULL, 0x000fe40000011613ULL,
0x000000ff13647812ULL, 0x000fc400078ec0ffULL, 0x00000018ff5a7819ULL, 0x000fe40000011613ULL,
0x0000ffff13617812ULL, 0x000fe400078ec0ffULL, 0x00a000004710783bULL, 0x0002a20000000200ULL,
0x00000010ff557819ULL, 0x108fe40000011639ULL, 0x000000ff39587812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fe40000011639ULL, 0x0000ffff39577812ULL, 0x000fc400078ec0ffULL,
0x00000041ff39723eULL, 0x000fe400020006ffULL, 0x00000010ff457819ULL, 0x100fe4000001163cULL,
0x00000018ff717819ULL, 0x000fe4000001163cULL, 0x000000ff3c477812ULL, 0x042fe400078ec0ffULL,
0x0000ffff3c417812ULL, 0x000fe400078ec0ffULL, 0x00000010ff427819ULL, 0x000fc4000001163dULL,
0x00000018ff6f7819ULL, 0x000fe4000001163dULL, 0x000000ff3d3c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3d437812ULL, 0x000fe400078ec0ffULL, 0x000000ff403d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff507819ULL, 0x000fe40000011638ULL, 0x000000ff38597812ULL, 0x000fc400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe40000011638ULL, 0x0000ffff384c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff527819ULL, 0x100fe4000001163aULL, 0x000000ff3a4f7812ULL, 0x040fe200078ec0ffULL,
0x0000000510108232ULL, 0x084fe20000000000ULL, 0x00000018ff447819ULL, 0x000fe2000001163aULL,
0x0000000512128232ULL, 0x000fe20000000000ULL, 0x0000ffff3a4a7812ULL, 0x000fe200078ec0ffULL,
0x0000000411118232ULL, 0x080fe20000000000ULL, 0x000000ff14387812ULL, 0x000fe200078ec0ffULL,
0x0000000413138232ULL, 0x000fe20000000000ULL, 0x00000015ff3a723eULL, 0x000fc400020006ffULL,
0x00000010ff147819ULL, 0x100fe4000001163eULL, 0x000000ff3e687812ULL, 0x040fe400078ec0ffULL,
0x00000018ff567819ULL, 0x000fe4000001163eULL, 0x0000ffff3e607812ULL, 0x000fe400078ec0ffULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x00000010ff157819ULL, 0x000fc4000001163fULL,
0x000000ff3f3e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff497819ULL, 0x000fe4000001163fULL,
0x0000ffff3f5e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff517819ULL, 0x000fe40000011651ULL,
0x00000008ff3f7819ULL, 0x000fe40000011654ULL, 0x0000541039397816ULL, 0x000fc4000000003dULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x00000051ff3d723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x0000003cff51723eULL, 0x000fe400020006ffULL, 0x000054103d3c7816ULL, 0x000fc4000000006eULL,
0x000054103f3d7816ULL, 0x000fe4000000006cULL, 0x000000ff46467812ULL, 0x000fe400078ec0ffULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x0000003c101c723cULL, 0x000b62000000181cULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000008ff5f7819ULL, 0x000fc4000001165fULL, 0x00000008ff617819ULL, 0x000fe40000011661ULL,
0x00000046ff3c723eULL, 0x020fe400020006ffULL, 0x00000067ff3d723eULL, 0x000fe400020006ffULL,
0x00005410653c7816ULL, 0x000fe4000000003cULL, 0x00005410643d7816ULL, 0x000fe4000000003dULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x000000ff503f7812ULL, 0x000fe200078ec0ffULL, 0x0000003c1020723cULL, 0x000b620000001820ULL,
0x0000003eff50723eULL, 0x000fe400020006ffULL, 0x0000003fff3e723eULL, 0x000fe200020006ffULL,
0x00000200003f7824ULL, 0x000fe200078e00ffULL, 0x000000ff55557812ULL, 0x000fe400078ec0ffULL,
0x0000005fff3c723eULL, 0x020fc400020006ffULL, 0x00000061ff3d723eULL, 0x000fe400020006ffULL,
0x000054103c3c7816ULL, 0x000fe4000000005cULL, 0x000054103d3d7816ULL, 0x000fe4000000005aULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x0000003c1024723cULL, 0x000b620000001824ULL,
0xfffff8003f3f7812ULL, 0x000fc400078ec0ffULL, 0x000054103a387816ULL, 0x000fe40000000038ULL,
0x00000010ff537819ULL, 0x100fe4000001163bULL, 0x00000055ff3d723eULL, 0x020fe400020006ffULL,
0x000000ff3b4d7812ULL, 0x040fe200078ec0ffULL, 0x000000381018723cULL, 0x000b620000001818ULL,
0x00000018ff4b7819ULL, 0x000fe4000001163bULL, 0x0000ffff3b4e7812ULL, 0x000fe200078ec0ffULL,
0x00000010483b7824ULL, 0x000fe200078e0269ULL, 0x00005410593c7816ULL, 0x000fe2000000003eULL,
0x000000100e487824ULL, 0x000fe200078e023fULL, 0x00005410583d7816ULL, 0x000fc4000000003dULL,
0x00000068ff46723eULL, 0x000fe200020006ffULL, 0x000000003b38783bULL, 0x020fe20000004200ULL,
0x00000008ff687819ULL, 0x000fe4000001164cULL, 0x00000008ff677819ULL, 0x000fe20000011657ULL,
0x0000003c103c723cULL, 0x000b620000001828ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x00a000004828783bULL, 0x020e620000000200ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fc400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x000000ff526c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff536e7812ULL, 0x000fe400078ec0ffULL,
0x0000541068527816ULL, 0x000fe4000000005dULL, 0x0000541067537816ULL, 0x000fe4000000005bULL,
0x0000004fff4f723eULL, 0x000fc400020006ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x0000004dff4d723eULL, 0x000fe200020006ffULL, 0x00000052102c723cULL, 0x000b62000000182cULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x00000008ff4a7819ULL, 0x000fe4000001164aULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x00000008ff527819ULL, 0x020fc4000001164eULL,
0x000054104f4e7816ULL, 0x000fe4000000006cULL, 0x000054104d4f7816ULL, 0x000fe4000000006eULL,
0x000000ff454d7812ULL, 0x000fe400078ec0ffULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe200020006ffULL, 0x0000004e1030723cULL, 0x000f620000001830ULL,
0x00000052ff45723eULL, 0x000fe200020006ffULL, 0x0000000528288232ULL, 0x082fe20000000000ULL,
0x00000008ff417819ULL, 0x000fe20000011641ULL, 0x000000052a2a8232ULL, 0x000fe20000000000ULL,
0x00000008ff437819ULL, 0x000fe20000011643ULL, 0x0000000429298232ULL, 0x080fe20000000000ULL,
0x000000ff14147812ULL, 0x000fe200078ec0ffULL, 0x000000042b2b8232ULL, 0x000fe20000000000ULL,
0x000000ff15157812ULL, 0x000fc400078ec0ffULL, 0x00000071ff40723eULL, 0x000fe400020006ffULL,
0x00000047ff54723eULL, 0x000fe400020006ffULL, 0x000054104a447816ULL, 0x000fe40000000044ULL,
0x0000541045457816ULL, 0x000fe4000000004bULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x0000006fff47723eULL, 0x000fc400020006ffULL, 0x00000043ff43723eULL, 0x000fe200020006ffULL,
0x000000441010723cULL, 0x000b620000001834ULL, 0x00000014ff14723eULL, 0x000fe400020006ffULL,
0x00000015ff15723eULL, 0x000fe400020006ffULL, 0x00000008ff607819ULL, 0x000fe40000011660ULL,
0x00000008ff5e7819ULL, 0x000fe4000001165eULL, 0x0000541041407816ULL, 0x000fc40000000040ULL,
0x0000541043417816ULL, 0x000fe40000000047ULL, 0x0000541046467816ULL, 0x000fe40000000014ULL,
0x0000541050477816ULL, 0x000fe40000000015ULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x00000040281c723cULL, 0x000f62000000181cULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x00000060ff14723eULL, 0x000fc400020006ffULL, 0x0000005eff15723eULL, 0x000fe400020006ffULL,
0x00000010ff597819ULL, 0x100fe20000011638ULL, 0x000000462820723cULL, 0x000f620000001820ULL,
0x000000ff38657812ULL, 0x040fe400078ec0ffULL, 0x00000018ff617819ULL, 0x000fe40000011638ULL,
0x0000ffff38557812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5a7819ULL, 0x000fc40000011639ULL,
0x000000ff39647812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5f7819ULL, 0x000fe40000011639ULL,
0x0000ffff39577812ULL, 0x000fe400078ec0ffULL, 0x00000010ff397819ULL, 0x100fe4000001163aULL,
0x000000ff3a5c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff487819ULL, 0x000fc4000001163aULL,
0x00000010ff4c7819ULL, 0x100fe4000001163bULL, 0x000000ff3b587812ULL, 0x000fe400078ec0ffULL,
0x00000018ff387819ULL, 0x000fe4000001163bULL, 0x0000541014147816ULL, 0x000fe40000000056ULL,
0x0000541015157816ULL, 0x000fe40000000049ULL, 0x0000ffff3a3a7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3b3b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff42427812ULL, 0x000fe200078ec0ffULL,
0x000000142824723cULL, 0x000b620000001824ULL, 0x000000ff59597812ULL, 0x000fe400078ec0ffULL,
0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff557819ULL, 0x000fe40000011655ULL,
0x00000008ff577819ULL, 0x000fc40000011657ULL, 0x000000ff39397812ULL, 0x000fe400078ec0ffULL,
0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3a7819ULL, 0x000fe4000001163aULL,
0x00000008ff3b7819ULL, 0x000fe4000001163bULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x0000004dff4d723eULL, 0x000fc400020006ffULL, 0x00000042ff35723eULL, 0x020fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000059ff14723eULL, 0x000fc400020006ffULL, 0x0000005aff15723eULL, 0x000fe400020006ffULL,
0x00000058ff5d723eULL, 0x000fe400020006ffULL, 0x00000055ff5e723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000039ff39723eULL, 0x000fe400020006ffULL,
0x0000004cff4c723eULL, 0x000fc400020006ffULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x0000003bff3b723eULL, 0x000fe400020006ffULL, 0x0000541054347816ULL, 0x000fe4000000004dULL,
0x0000541051357816ULL, 0x000fc40000000035ULL, 0x0000541065147816ULL, 0x000fe40000000014ULL,
0x0000541064157816ULL, 0x000fe40000000015ULL, 0x000054105e5e7816ULL, 0x000fe20000000061ULL,
0x000000342818723cULL, 0x000f620000001818ULL, 0x00005410575f7816ULL, 0x000fe4000000005fULL,
0x000054105c5c7816ULL, 0x000fe40000000039ULL, 0x000054105d5d7816ULL, 0x000fc4000000004cULL,
0x000054103a3a7816ULL, 0x000fe20000000048ULL, 0x00000014283c723cULL, 0x000f62000000183cULL,
0x000054103b3b7816ULL, 0x000fce0000000038ULL, 0x0000005e282c723cULL, 0x040f70000000182cULL,
0x0000005c2830723cULL, 0x040f700000001830ULL, 0x0000003a2828723cULL, 0x000b6e0000001810ULL,
0x0000f6c80a127811ULL, 0x020fc400078e18ffULL, 0x0000f69878107811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000000012127f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000010ff7f8cULL, 0x0005e4000c80043fULL,
0x0000000000107805ULL, 0x004fc40000015200ULL, 0x0000040008157984ULL, 0x000ea40000000800ULL,
0x8000000015ff7812ULL, 0x006fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410357210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000003514147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040008157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000109087810ULL, 0x000fc80007ffe0ffULL,
0x000000030800720cULL, 0x000fda0003f06070ULL, 0x0000079000000947ULL, 0x000fea0003800000ULL,
0x0000000209087810ULL, 0x000fe20007ffe0ffULL, 0x000059006a107a24ULL, 0x010fe200078e02ffULL,
0x000001000f0f7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff117424ULL, 0x000fe200078e00ffULL,
0x000000030800720cULL, 0x000fe20003f06070ULL, 0x0000008010107824ULL, 0x000fe200078e00ffULL,
0x000000600f087812ULL, 0x000fc600078ec0ffULL, 0x0000640010107625ULL, 0x000fc800078e0011ULL,
0x0000000173367824ULL, 0x000fc800078e0208ULL, 0x000003e000008947ULL, 0x000fea0003800000ULL,
0x0000000f02087217ULL, 0x000fe20007800000ULL, 0x0000001000127824ULL, 0x000fc800078e00ffULL,
0x0000000108087824ULL, 0x000fe200078e0a0fULL, 0x00000010120f7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff127819ULL, 0x000fe40000011606ULL, 0x000000080f087217ULL, 0x000fe40007800000ULL,
0x0000000812347810ULL, 0x040fe20007ffe0ffULL, 0x0000000112137824ULL, 0x140fe200078e020fULL,
0x0000000412147810ULL, 0x000fe20007ffe0ffULL, 0x0000000108087824ULL, 0x100fe200078e0a0fULL,
0x0000000c12357810ULL, 0x000fe20007ffe0ffULL, 0x0000000134377824ULL, 0x000fc400078e020fULL,
0x0000000114157824ULL, 0x140fe200078e020fULL, 0x000000081400720cULL, 0x080fe20003f66070ULL,
0x0000000113147824ULL, 0x000fe200078e0236ULL, 0x000000081200720cULL, 0x080fe20003f86070ULL,
0x0000000135397824ULL, 0x040fe200078e020fULL, 0x000000083500720cULL, 0x080fe20003f06070ULL,
0x0000000137127824ULL, 0x140fe200078e0206ULL, 0x000000083400720cULL, 0x000fe20003f46070ULL,
0x0000000837357824ULL, 0x000fe400078e00ffULL, 0x00000001150f7824ULL, 0x000fc400078e0206ULL,
0x0000000815387824ULL, 0x000fe200078e00ffULL, 0xfffffff8353a7812ULL, 0x000fe200078ee212ULL,
0x0000000115347824ULL, 0x000fe400078e0236ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fc600078ee20fULL, 0x0000000113087824ULL, 0x040fe400078e0206ULL,
0x0000000813137824ULL, 0x000fe400078e00ffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff813087812ULL, 0x000fe200078ee208ULL, 0x0000000137127824ULL, 0x100fe200078e0236ULL,
0x0000006214377212ULL, 0x080fe200078efcffULL, 0x0000000139367824ULL, 0x000fe200078e0236ULL,
0x00000062340f7212ULL, 0x000fe200078efcffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000003710147210ULL, 0x040fe40007fbe0ffULL, 0x0000000f10347210ULL, 0x000fe20007fde0ffULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x00000001393b7824ULL, 0x040fe200078e0206ULL,
0x00000062360f7212ULL, 0x080fe200078efcffULL, 0x0000000839407824ULL, 0x000fe200078e00ffULL,
0x0000006212397212ULL, 0x000fe200078efcffULL, 0x0000000111157824ULL, 0x040fe400028e0615ULL,
0x0000000111357824ULL, 0x000fe200030e0635ULL, 0x0000003910127210ULL, 0x000fe20007fbe0ffULL,
0x0000001038417824ULL, 0x000fe200078e0269ULL, 0xfffffff840407812ULL, 0x000fe200078ee23bULL,
0x00000010083b7824ULL, 0x100fe200078e0269ULL, 0x0000000f10107210ULL, 0x000fe20007fde0ffULL,
0x000000103a0f7824ULL, 0x000fc400078e0269ULL, 0x0000000111137824ULL, 0x040fe200028e0613ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143b7faeULL, 0x0003e2000e101c48ULL,
0x0000001040697824ULL, 0x000fe400078e0269ULL, 0x0000000111117824ULL, 0x000fe200030e0637ULL,
0x0000000034417faeULL, 0x0003e8000d901c48ULL, 0x00000000120f7faeULL, 0x0003e8000d101c48ULL,
0x0000000010697faeULL, 0x0003e2000c101c48ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x000fca00078e00ffULL, 0x00000010080f7812ULL, 0x000fc800078ec0ffULL,
0x0000000f060f7211ULL, 0x000fc800078fe8ffULL, 0x000000040f157810ULL, 0x040fe20007ffe0ffULL,
0x000000010f087824ULL, 0x040fe200078e0206ULL, 0x000000080f377810ULL, 0x040fe20007ffe0ffULL,
0x000000080f137824ULL, 0x040fe200078e00ffULL, 0x0000000c0f397810ULL, 0x040fe20007ffe0ffULL,
0x000000010f127824ULL, 0x100fe400078e0236ULL, 0x0000000115147824ULL, 0x000fe200078e0236ULL,
0xfffffff813087812ULL, 0x000fe200078ee208ULL, 0x0000000115357824ULL, 0x040fe400078e0206ULL,
0x0000000815387824ULL, 0x000fc400078e00ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee235ULL, 0x0000000137157824ULL, 0x040fe200078e0206ULL,
0x00000062120f7212ULL, 0x000fe200078efcffULL, 0x00000008373a7824ULL, 0x040fe400078e00ffULL,
0x0000000137347824ULL, 0x000fe200078e0236ULL, 0x0000000f10127210ULL, 0x000fe20007f1e0ffULL,
0x0000000139377824ULL, 0x040fe200078e0206ULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee215ULL,
0x0000000839407824ULL, 0x040fe400078e00ffULL, 0x0000000139367824ULL, 0x000fc400078e0236ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fc600078ee237ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x00000062143b7212ULL, 0x000fc600078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000006234397212ULL, 0x000fc600078efcffULL,
0x0000000111137824ULL, 0x040fe200000e0613ULL, 0x00000062360f7212ULL, 0x000fe200078efcffULL,
0x0000001008417824ULL, 0x100fe200078e0269ULL, 0x0000003b10147210ULL, 0x000fe20007f1e0ffULL,
0x0000001038437824ULL, 0x100fe200078e0269ULL, 0x0000003910347210ULL, 0x000fe20007f5e0ffULL,
0x000000103a457824ULL, 0x000fe200078e0269ULL, 0x0000000f10107210ULL, 0x000fe20007f7e0ffULL,
0x0000000111157824ULL, 0x040fe200000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012417faeULL, 0x0003e2000b901c48ULL, 0x0000000111357824ULL, 0x000fc400010e0635ULL,
0x0000001040697824ULL, 0x000fe200078e0269ULL, 0x0000000014437faeULL, 0x0003e2000b901c48ULL,
0x0000000111117824ULL, 0x000fc600018e0637ULL, 0x0000000034457faeULL, 0x0003e8000b901c48ULL,
0x0000000010697faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000100a0f7824ULL, 0x000fe400078e00ffULL, 0x0000000800087824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a04ULL, 0x000000100f0f7812ULL, 0x000fc400078ee2ffULL,
0x0000000808087812ULL, 0x000fc600078ec0ffULL, 0x00000020780f7824ULL, 0x000fc800078e020fULL,
0x0000000108087824ULL, 0x000fe200078e020fULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8007b127f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6680008107f8cULL, 0x000662000c80043fULL,
0x000000ffff0f7224ULL, 0x004fc600078e0013ULL, 0x0000000000127805ULL, 0x000fc80000015200ULL,
0x00f66c0008157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x006fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001412357210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000003514147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c0008157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018078087811ULL, 0x008fc800078e38ffULL, 0x000000086b087210ULL, 0x000fca0007ffe062ULL,
0x00f0000008347984ULL, 0x000e680000000800ULL, 0x00f2000008137984ULL, 0x0004e20000000800ULL,
0x0000000d3400720bULL, 0x002fe20003f1d000ULL, 0x000090727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x004fc800000e0100ULL, 0x0000ffff10357812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff087424ULL, 0x000fe400078e00ffULL,
0x000000ffff127224ULL, 0x000fd200078e000dULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000378117810ULL, 0x000fe40007ffe0ffULL, 0x0000000d3400720bULL, 0x000fe40003f54000ULL,
0x000000001100720cULL, 0x000fe20003f05270ULL, 0x000090127f007947ULL, 0x000fd4000b800000ULL,
0x0000000000087806ULL, 0x000fc400010e0100ULL, 0x0000008000628824ULL, 0x000fe200078e0262ULL,
0x0000000d34108209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991008117816ULL, 0x000fe200000000ffULL, 0x000000016b6b8824ULL, 0x000fca00078e0262ULL,
0x00f400106b008388ULL, 0x0003e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000d34107209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff08ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000d10107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000377308ULL, 0x000e640000000800ULL, 0x000000370c0c7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe20000011606ULL,
0x00008f327f007947ULL, 0x000fea000b800000ULL, 0x00001f1037147589ULL, 0x0002a400000e0000ULL,
0x0000001418187220ULL, 0x084fe20000410000ULL, 0x0000001419197220ULL, 0x080fe20000410000ULL,
0x000000141c1c7220ULL, 0x080fe20000410000ULL, 0x000000141d1d7220ULL, 0x080fe20000410000ULL,
0x0000001420207220ULL, 0x080fe20000410000ULL, 0x0000001421217220ULL, 0x080fe20000410000ULL,
0x0000001424247220ULL, 0x080fe20000410000ULL, 0x0000001425257220ULL, 0x080fe20000410000ULL,
0x000000143c3c7220ULL, 0x080fe20000410000ULL, 0x000000143d3d7220ULL, 0x080fe20000410000ULL,
0x000000142c2c7220ULL, 0x080fe20000410000ULL, 0x000000142d2d7220ULL, 0x080fe20000410000ULL,
0x0000001430307220ULL, 0x080fe20000410000ULL, 0x0000001431317220ULL, 0x080fe20000410000ULL,
0x0000001428287220ULL, 0x080fe20000410000ULL, 0x0000001429297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0008ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000806107811ULL, 0x002fe200078ff0ffULL,
0x00008e127f007947ULL, 0x000fea000b800000ULL, 0x00001f1037147589ULL, 0x0002a400000e0000ULL,
0x000000141a1a7220ULL, 0x084fe20000410000ULL, 0x000000141b1b7220ULL, 0x080fe20000410000ULL,
0x000000141e1e7220ULL, 0x080fe20000410000ULL, 0x000000141f1f7220ULL, 0x080fe20000410000ULL,
0x0000001422227220ULL, 0x080fe20000410000ULL, 0x0000001423237220ULL, 0x080fe20000410000ULL,
0x0000001426267220ULL, 0x080fe20000410000ULL, 0x0000001427277220ULL, 0x080fe20000410000ULL,
0x000000143e3e7220ULL, 0x080fe20000410000ULL, 0x000000143f3f7220ULL, 0x080fe20000410000ULL,
0x000000142e2e7220ULL, 0x080fe20000410000ULL, 0x000000142f2f7220ULL, 0x080fe20000410000ULL,
0x0000001432327220ULL, 0x080fe20000410000ULL, 0x0000001433337220ULL, 0x080fe20000410000ULL,
0x000000142a2a7220ULL, 0x080fe20000410000ULL, 0x000000142b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806008ULL,
0x00000001ff087424ULL, 0x000fe200078e00ffULL, 0x0000000d34127209ULL, 0x000fd60007810000ULL,
0x8000001234340221ULL, 0x000fe20000010000ULL, 0x00007610ff080816ULL, 0x000fc60000000008ULL,
0x3fb8aa3b34340820ULL, 0x000fc80000410000ULL, 0x0000003400070308ULL, 0x000e640000000800ULL,
0x0000000713130220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000c130c7221ULL, 0x008fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x00f6b4007b137984ULL, 0x000e620000000800ULL, 0x00000004000d7824ULL, 0x000fca00078e00ffULL,
0x000000040d347812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0d7224ULL, 0x000fc600078e00ffULL,
0x0000000234347810ULL, 0x000fe40007ffe0ffULL, 0x8000000013ff7812ULL, 0x002fe20007804817ULL,
0x000000047c137824ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410357210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000003514147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6b4007b157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991008087816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0800720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000007ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011606ULL,
0x0000541004087816ULL, 0x000fe20000000004ULL, 0x000089827f007947ULL, 0x000fea000b800000ULL,
0x00001f0d08057589ULL, 0x0002a400000e0000ULL, 0x000000080d107810ULL, 0x000fe20007ffe0ffULL,
0x000089b27f007947ULL, 0x000fea000b800000ULL, 0x00001f1008047589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100d107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200078e0008ULL, 0x0000a41000157802ULL, 0x000fc40000000f00ULL,
0x00008e4000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180d107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200078e0008ULL,
0x0000a46000157802ULL, 0x000fc40000000f00ULL, 0x00008df000007944ULL, 0x016fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000706367812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000003785d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000836087812ULL, 0x00afe400078ef806ULL, 0x0000000806357812ULL, 0x000fe200078ec0ffULL,
0x000008005d5d7824ULL, 0x000fe400078e00ffULL, 0x0000000808087824ULL, 0x000fca00078e00ffULL,
0xfffffff808087812ULL, 0x000fca00078ee263ULL, 0x0000001008117824ULL, 0x000fc400078e025dULL,
0x0000001306137211ULL, 0x000fe200078fe0ffULL, 0x000000100e5d7824ULL, 0x000fe200078e025dULL,
0x0000003635107212ULL, 0x040fe400078efcffULL, 0x0000003406397211ULL, 0x000fe400078fe0ffULL,
0x00000010353a7812ULL, 0x000fe200078efe36ULL, 0x0000000110087824ULL, 0x040fe400078e0213ULL,
0x00000008100d7824ULL, 0x000fe400078e00ffULL, 0x000000083a387824ULL, 0x000fc600078e00ffULL,
0xfffffff80d087812ULL, 0x000fe200078ee208ULL, 0x00000001100d7824ULL, 0x040fe400078e0239ULL,
0x0000000810107824ULL, 0x000fe400078e00ffULL, 0x0000001008087824ULL, 0x000fc600078e020bULL,
0xfffffff810107812ULL, 0x000fe200078ee20dULL, 0x000000013a0d7824ULL, 0x000fe200078e0213ULL,
0x000000000814783bULL, 0x0042a60000004200ULL, 0x0000001010107824ULL, 0x000fe200078e020bULL,
0xfffffff838387812ULL, 0x000fe200078ee20dULL, 0x000000083a0d7824ULL, 0x000fc600078e00ffULL,
0x000000001034783bULL, 0x0006e20000004200ULL, 0x000000013a087824ULL, 0x002fe400078e0239ULL,
0x0000001038387824ULL, 0x000fc600078e020bULL, 0xfffffff80d087812ULL, 0x000fc600078ee208ULL,
0x000000003838783bULL, 0x000e640000004200ULL, 0x0000001008407824ULL, 0x000fe200078e020bULL,
0x00000010ff0d7819ULL, 0x104fe40000011614ULL, 0x000000ff140e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff767819ULL, 0x000fe40000011614ULL, 0x0000ffff14087812ULL, 0x000fe400078ec0ffULL,
0x00000010ff0b7819ULL, 0x000fc40000011615ULL, 0x000000ff15137812ULL, 0x040fe400078ec0ffULL,
0x00000018ff757819ULL, 0x000fe40000011615ULL, 0x0000ffff15107812ULL, 0x008fe400078ec0ffULL,
0x00000010ff6e7819ULL, 0x100fe40000011616ULL, 0x000000ff16727812ULL, 0x000fe400078ec0ffULL,
0x00000018ff687819ULL, 0x000fc40000011616ULL, 0x0000ffff16577812ULL, 0x000fe400078ec0ffULL,
0x00000010ff707819ULL, 0x100fe40000011617ULL, 0x000000ff17717812ULL, 0x040fe400078ec0ffULL,
0x00000018ff677819ULL, 0x000fe40000011617ULL, 0x0000ffff176b7812ULL, 0x000fe400078ec0ffULL,
0x009000001114783bULL, 0x000ea20000000200ULL, 0x00000010ff5e7819ULL, 0x000fc40000011634ULL,
0x000000ff34627812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011634ULL,
0x0000ffff345a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff607819ULL, 0x100fe40000011635ULL,
0x000000ff35617812ULL, 0x000fe400078ec0ffULL, 0x00000018ff597819ULL, 0x000fc40000011635ULL,
0x0000ffff355b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff557819ULL, 0x100fe40000011636ULL,
0x000000ff36517812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4d7819ULL, 0x000fe40000011636ULL,
0x0000ffff364b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff567819ULL, 0x000fc40000011637ULL,
0x000000ff37527812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4e7819ULL, 0x000fe40000011637ULL,
0x0000ffff374c7812ULL, 0x000fe400078ec0ffULL, 0x000000004034783bULL, 0x000ee20000004200ULL,
0x000000ff0d0d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff0b0b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff497819ULL, 0x002fc40000011638ULL, 0x000000ff38477812ULL, 0x040fe200078ec0ffULL,
0x0000000514148232ULL, 0x084fe20000000000ULL, 0x00000018ff6f7819ULL, 0x000fe20000011638ULL,
0x0000000516168232ULL, 0x000fe20000000000ULL, 0x0000ffff38437812ULL, 0x000fe200078ec0ffULL,
0x0000000415158232ULL, 0x080fe20000000000ULL, 0x00000010ff447819ULL, 0x100fe20000011639ULL,
0x0000000417178232ULL, 0x000fe20000000000ULL, 0x000000ff39547812ULL, 0x000fe400078ec0ffULL,
0x00000018ff657819ULL, 0x000fc40000011639ULL, 0x0000ffff39467812ULL, 0x000fe400078ec0ffULL,
0x0000000eff38723eULL, 0x000fe400020006ffULL, 0x00000013ff39723eULL, 0x000fe400020006ffULL,
0x0000000dff0d723eULL, 0x000fe400020006ffULL, 0x0000000bff0b723eULL, 0x000fe400020006ffULL,
0x0000541038387816ULL, 0x000fc4000000000dULL, 0x0000541039397816ULL, 0x000fe4000000000bULL,
0x00000010ff417819ULL, 0x100fe4000001163aULL, 0x000000ff3a5f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff507819ULL, 0x000fe4000001163aULL, 0x0000ffff3a117812ULL, 0x000fe400078ec0ffULL,
0x00000010ff137819ULL, 0x008fc40000011634ULL, 0x000000ff34537812ULL, 0x040fe400078ec0ffULL,
0x00000018ff487819ULL, 0x000fe40000011634ULL, 0x0000ffff340d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff427819ULL, 0x100fe4000001163bULL, 0x000000ff3b587812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fc4000001163bULL, 0x0000ffff3b407812ULL, 0x000fe400078ec0ffULL,
0x00000008ff777819ULL, 0x000fe20000011608ULL, 0x000000381438723cULL, 0x000b620000001818ULL,
0x00000010ff347819ULL, 0x100fe40000011635ULL, 0x000000ff354f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff457819ULL, 0x000fe40000011635ULL, 0x0000ffff350e7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff637819ULL, 0x100fe40000011636ULL, 0x000000ff36357812ULL, 0x040fe400078ec0ffULL,
0x00000018ff087819ULL, 0x000fe40000011636ULL, 0x0000ffff36697812ULL, 0x000fe400078ec0ffULL,
0x00000008ff197819ULL, 0x020fe40000011610ULL, 0x00000008ff367819ULL, 0x000fc40000011657ULL,
0x00000008ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff0b7819ULL, 0x100fe40000011637ULL,
0x000000ff37107812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011637ULL,
0x0000ffff37647812ULL, 0x000fe400078ec0ffULL, 0x00000076ff76723eULL, 0x000fc400020006ffULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x00000019ff19723eULL, 0x000fe400020006ffULL, 0x00000036ff36723eULL, 0x000fc400020006ffULL,
0x0000006bff37723eULL, 0x000fe400020006ffULL, 0x0000541077187816ULL, 0x000fe40000000076ULL,
0x0000541019197816ULL, 0x000fe40000000075ULL, 0x0000541036367816ULL, 0x000fe40000000068ULL,
0x0000541037377816ULL, 0x000fe40000000067ULL, 0x000000ff6e6e7812ULL, 0x000fe200078ec0ffULL,
0x00000018141c723cULL, 0x000be2000000181cULL, 0x000000ff70707812ULL, 0x000fc400078ec0ffULL,
0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff60607812ULL, 0x000fe400078ec0ffULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x000000361424723cULL, 0x000be20000001824ULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fc400020006ffULL, 0x0000006eff18723eULL, 0x020fe400020006ffULL,
0x00000070ff19723eULL, 0x000fe400020006ffULL, 0x0000005eff36723eULL, 0x000fe400020006ffULL,
0x00000060ff37723eULL, 0x000fe400020006ffULL, 0x0000541072187816ULL, 0x000fe40000000018ULL,
0x0000541071197816ULL, 0x000fc40000000019ULL, 0x0000541062367816ULL, 0x000fe40000000036ULL,
0x0000541061377816ULL, 0x000fe40000000037ULL, 0x00000008ff5a7819ULL, 0x000fe2000001165aULL,
0x000000181420723cULL, 0x000b620000001820ULL, 0x00000008ff5b7819ULL, 0x000fe2000001165bULL,
0x009000005d18783bULL, 0x020e620000000200ULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fc400020006ffULL, 0x000000ff55557812ULL, 0x000fe200078ec0ffULL,
0x00000036143c723cULL, 0x000be2000000183cULL, 0x000000ff56567812ULL, 0x000fe400078ec0ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x0000005aff36723eULL, 0x020fe400020006ffULL, 0x0000005bff37723eULL, 0x000fc400020006ffULL,
0x0000541036367816ULL, 0x000fe4000000005cULL, 0x0000541037377816ULL, 0x000fe40000000059ULL,
0x00000008ff4b7819ULL, 0x000fe4000001164bULL, 0x00000008ff4c7819ULL, 0x000fe4000001164cULL,
0x0000004dff4d723eULL, 0x000fe200020006ffULL, 0x00000036142c723cULL, 0x000be2000000182cULL,
0x0000004eff4e723eULL, 0x000fc400020006ffULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x000000ff49497812ULL, 0x000fe400078ec0ffULL, 0x00000055ff36723eULL, 0x020fe400020006ffULL,
0x00000056ff37723eULL, 0x000fe400020006ffULL, 0x0000541051367816ULL, 0x000fe40000000036ULL,
0x0000541052377816ULL, 0x000fe20000000037ULL, 0x0000000518188232ULL, 0x082fe20000000000ULL,
0x000000ff44447812ULL, 0x000fe200078ec0ffULL, 0x000000051a1a8232ULL, 0x000fe20000000000ULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x0000000419198232ULL, 0x080fe20000000000ULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x000000361430723cULL, 0x000b620000001830ULL,
0x00000049ff49723eULL, 0x000fe200020006ffULL, 0x000000041b1b8232ULL, 0x000fe20000000000ULL,
0x000000ff41417812ULL, 0x000fc400078ec0ffULL, 0x000000ff42427812ULL, 0x000fe400078ec0ffULL,
0x0000004cff37723eULL, 0x020fe400020006ffULL, 0x000054104b367816ULL, 0x000fe4000000004dULL,
0x0000541037377816ULL, 0x000fe4000000004eULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fc400020006ffULL, 0x00000008ff117819ULL, 0x000fe20000011611ULL,
0x000000361414723cULL, 0x000b620000001828ULL, 0x000000ff63637812ULL, 0x000fe400078ec0ffULL,
0x000000ff0b0b7812ULL, 0x000fe400078ec0ffULL, 0x00000035ff35723eULL, 0x000fe400020006ffULL,
0x00000044ff2a723eULL, 0x020fe400020006ffULL, 0x0000541047287816ULL, 0x000fc40000000049ULL,
0x0000541054297816ULL, 0x000fe4000000002aULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x0000000bff0b723eULL, 0x000fe400020006ffULL, 0x00000008ff407819ULL, 0x000fe20000011640ULL,
0x000000281838723cULL, 0x000b620000001838ULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x00000008ff467819ULL, 0x000fc40000011646ULL, 0x000000ff13137812ULL, 0x000fe400078ec0ffULL,
0x00000041ff28723eULL, 0x020fe400020006ffULL, 0x00000042ff29723eULL, 0x000fe400020006ffULL,
0x000054105f287816ULL, 0x000fe40000000028ULL, 0x0000541058297816ULL, 0x000fe40000000029ULL,
0x000000ff34347812ULL, 0x000fc400078ec0ffULL, 0x00000008ff0d7819ULL, 0x000fe4000001160dULL,
0x00000008ff0e7819ULL, 0x000fe2000001160eULL, 0x000000281820723cULL, 0x000b620000001820ULL,
0x00000008ff697819ULL, 0x000fe40000011669ULL, 0x00000008ff647819ULL, 0x000fe40000011664ULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x00000011ff28723eULL, 0x020fc400020006ffULL,
0x00000010ff11723eULL, 0x000fe400020006ffULL, 0x0000541035107816ULL, 0x000fe40000000063ULL,
0x0000541011117816ULL, 0x000fe4000000000bULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x00000040ff29723eULL, 0x000fe400020006ffULL, 0x0000006fff57723eULL, 0x000fe200020006ffULL,
0x000000101830723cULL, 0x000b620000001830ULL, 0x00000065ff5d723eULL, 0x000fc400020006ffULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x00000043ff5c723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x00000045ff45723eULL, 0x000fc400020006ffULL,
0x00000013ff13723eULL, 0x000fe400020006ffULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x0000000dff0d723eULL, 0x000fe400020006ffULL, 0x0000000eff49723eULL, 0x000fe400020006ffULL,
0x00000008ff0e723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fc400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000064ff11723eULL, 0x020fe400020006ffULL,
0x0000541028287816ULL, 0x000fe40000000050ULL, 0x0000541029297816ULL, 0x000fe4000000004aULL,
0x000054105c5c7816ULL, 0x000fe40000000057ULL, 0x00005410465d7816ULL, 0x000fc4000000005dULL,
0x00005410534e7816ULL, 0x000fe20000000013ULL, 0x000000281824723cULL, 0x040b620000001824ULL,
0x000054104f4f7816ULL, 0x000fe40000000034ULL, 0x000054100d487816ULL, 0x000fe40000000048ULL,
0x0000541049497816ULL, 0x000fe40000000045ULL, 0x0000541069107816ULL, 0x000fe2000000000eULL,
0x0000005c181c723cULL, 0x000b62000000181cULL, 0x0000541011117816ULL, 0x000fc4000000006cULL,
0x000000040a087810ULL, 0x000fc80007ffe0ffULL, 0x0000f6a808087811ULL, 0x000fe200078e18ffULL,
0x0000004e1828723cULL, 0x040b70000000183cULL, 0x00000048182c723cULL, 0x040b70000000182cULL,
0x000000101818723cULL, 0x000b620000001814ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000008107f8cULL, 0x0202a2000c80043fULL, 0x0000000109097810ULL, 0x000fc40007ffe0ffULL,
0x0000f6a0780d7811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000dff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff0b7224ULL, 0x004fe200078e0011ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff636000007947ULL, 0x000fea000383ffffULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x018000000c007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000b5f000047802ULL, 0x008fc40000000f00ULL,
0x00007aa000007944ULL, 0x016fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000c00037308ULL, 0x000e640000001000ULL, 0xbf80000003007423ULL, 0x002fc8000000000cULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006f00ff037624ULL, 0x000fe400078e00ffULL,
0x00006e00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000047919ULL, 0x000e680000000000ULL, 0x0000000000077919ULL, 0x000ea20000000000ULL,
0x00000002ff067819ULL, 0x002fe40000011604ULL, 0x0000000807047811ULL, 0x004fe200078ff0ffULL,
0x0000000003057220ULL, 0x008fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000003800387220ULL, 0x042fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001900197220ULL, 0x000fe20000410000ULL, 0x0000003a043a7220ULL, 0x044fe20000410000ULL,
0x0000003b043b7220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000003204327220ULL, 0x040fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x000fc20000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x0000002c2d2c723eULL, 0x000fe200000000ffULL, 0x000000200a0b7824ULL, 0x000fe200078e00ffULL,
0x000000303130723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000181918723eULL, 0x000fc400000000ffULL, 0x000000222322723eULL, 0x000fe400000000ffULL,
0x000000262711723eULL, 0x000fe400000000ffULL, 0x0000002a2b2a723eULL, 0x000fe400000000ffULL,
0x0000002e2f15723eULL, 0x000fe400000000ffULL, 0x000000323332723eULL, 0x000fe400000000ffULL,
0x0000001a1b19723eULL, 0x000fc400000000ffULL, 0x00000002ff057819ULL, 0x00afe40000011600ULL,
0x0000000200027812ULL, 0x040fe400078ec0ffULL, 0x0000000800077811ULL, 0x000fe200078ff0ffULL,
0x0000000805097824ULL, 0x040fe200078e00ffULL, 0x0000000502047211ULL, 0x040fe200078ff8ffULL,
0x00000008050e7824ULL, 0x004fe200078e00ffULL, 0x0000000702037211ULL, 0x000fe200078ff8ffULL,
0x0000000807107824ULL, 0x000fe200078e00ffULL, 0x0000000204027810ULL, 0x040fe20007ffe0ffULL,
0x0000000805077824ULL, 0x000fe200078e00ffULL, 0x0000000404067810ULL, 0x000fc40007ffe0ffULL,
0xfffffff810107812ULL, 0x000fe200078ee203ULL, 0x000010007c037824ULL, 0x000fe200078e00ffULL,
0xfffffff809087812ULL, 0x000fe400078ee202ULL, 0xfffffff807027812ULL, 0x000fe200078ee204ULL,
0x000008000a057824ULL, 0x000fe200078e0203ULL, 0x0000000604077810ULL, 0x000fe20007ffe0ffULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff8090c7812ULL, 0x000fe200078ee206ULL,
0x0000001002067824ULL, 0x000fe200078e0205ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL,
0x0000001010107824ULL, 0x100fe200078e0205ULL, 0x0000000804077812ULL, 0x000fe200078ec0ffULL,
0x0000001008087824ULL, 0x100fe200078e0205ULL, 0x000000383902723eULL, 0x000fe200000000ffULL,
0x000000100c0c7824ULL, 0x000fe200078e0205ULL, 0x0000001c1d04723eULL, 0x000fe200000000ffULL,
0x0000000106067824ULL, 0x000fe200078e0207ULL, 0x000076322a097816ULL, 0x000fe20000000015ULL,
0x000000100e0e7824ULL, 0x000fe200078e0205ULL, 0x0000541002127816ULL, 0x040fe20000000004ULL,
0x0000000107107824ULL, 0x040fe200078e0210ULL, 0x0000763202137816ULL, 0x000fe20000000004ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x000000202102723eULL, 0x000fe200000000ffULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x000000242504723eULL, 0x000fe200000000ffULL,
0x0000001206007388ULL, 0x0003e20000000a00ULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x000000282905723eULL, 0x000fc400000000ffULL, 0x0000763202077816ULL, 0x100fe40000000004ULL,
0x00005410321c7816ULL, 0x140fe40000000019ULL, 0x00007632321d7816ULL, 0x000fe40000000019ULL,
0x000000ff0a00720cULL, 0x000fe40003f05270ULL, 0x0000541002067816ULL, 0x002fe40000000004ULL,
0x0000003a3b02723eULL, 0x000fc400000000ffULL, 0x0000001e1f04723eULL, 0x000fe200000000ffULL,
0x0000000608007388ULL, 0x0003e40000000a00ULL, 0x0000541005067816ULL, 0x142fe4000000002cULL,
0x0000763205077816ULL, 0x000fca000000002cULL, 0x000000060c007388ULL, 0x0003e40000000a00ULL,
0x0000541030067816ULL, 0x142fe40000000018ULL, 0x0000763230077816ULL, 0x000fca0000000018ULL,
0x000000060e007388ULL, 0x0003e40000000a00ULL, 0x0000541002067816ULL, 0x142fe40000000004ULL,
0x0000763202077816ULL, 0x000fe20000000004ULL, 0x000000010b027824ULL, 0x000fc800078e0200ULL,
0x0000000610007388ULL, 0x0003e20000000a00ULL, 0x0000001002027824ULL, 0x000fe200078e0203ULL,
0x0000541022107816ULL, 0x142fe40000000011ULL, 0x0000763222117816ULL, 0x000fca0000000011ULL,
0x0004001008007388ULL, 0x0003e40000000a00ULL, 0x000054102a087816ULL, 0x002fca0000000015ULL,
0x000400080c007388ULL, 0x000fe80000000a00ULL, 0x0004001c0e007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000002047984ULL, 0x000e680000000c00ULL,
0x0004000002147984ULL, 0x000ea80000000c00ULL, 0x0008000002107984ULL, 0x000ee80000000c00ULL,
0x000c000002187984ULL, 0x000ee20000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x004fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x0000001307077230ULL, 0x008fe40000000000ULL,
0x0000001206067230ULL, 0x000fe40000000000ULL, 0x0000001105057230ULL, 0x000fe40000000000ULL,
0x0000001004047230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x000fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000402007388ULL, 0x000fe20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001402007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff067819ULL, 0x000fc80000011600ULL,
0x0000007d0600720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000011e7983ULL, 0x000ea20000100800ULL, 0x00005a0000087b06ULL, 0x000e620000209000ULL,
0x0000000179027824ULL, 0x000fe200078e0206ULL, 0x00005a00ff0f7a12ULL, 0x000fcc00078e33ffULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe08047810ULL, 0x002fcc0007ffe0ffULL,
0x0000000400057305ULL, 0x0002e4000021f000ULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000ffff077224ULL, 0x008fc800078e0a05ULL, 0x00005a0007077a24ULL, 0x000fc800078e02ffULL,
0x00000007050d7227ULL, 0x000fc800078e0004ULL, 0x0000000106047824ULL, 0x000fe400078e0200ULL,
0x000000020d077227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fca00078e0202ULL, 0x00005a0005007a0cULL, 0x000fda0003f06070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x0000000704057812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x0ffffff805047812ULL, 0x000fca00078ef800ULL,
0x0000001004067824ULL, 0x000fe400078e0203ULL, 0x0000000107071810ULL, 0x000fc60007ffe0ffULL,
0x0000000006087984ULL, 0x0002e20000000c00ULL, 0x000000070f077207ULL, 0x000fca0004000000ULL,
0x000000ffff057224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e027aULL,
0x00005a0005027a24ULL, 0x000fc800078e0202ULL, 0x00005a0007027a24ULL, 0x000fe200078e0202ULL,
0x0000000700077812ULL, 0x000fca00078ec0ffULL, 0x000000087c077824ULL, 0x000fe200078e0207ULL,
0x000000021e057210ULL, 0x004fe40007f3e0ffULL, 0x0000002000027810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x040fe400078240ffULL,
0x00000003ff067819ULL, 0x002fe40000011602ULL, 0x00005f0005057a11ULL, 0x000fe400008f440cULL,
0x0000007d0600720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0083ea000c101d08ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000179047824ULL, 0x102fe200078e0206ULL, 0x00000040000c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000102067824ULL, 0x000fe400078e0206ULL, 0x000000040d077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x00005a0005057a24ULL, 0x000fca00078e0204ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0000000706057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805067812ULL, 0x000fca00078ef802ULL,
0x0000001006067824ULL, 0x000fe400078e0203ULL, 0x0000000107072810ULL, 0x000fc60007ffe0ffULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x000000070f077207ULL, 0x000fca0004000000ULL,
0x000000ffff057224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e027aULL,
0x00005a0005047a24ULL, 0x000fc800078e0204ULL, 0x00005a0007047a24ULL, 0x000fe200078e0204ULL,
0x0000000702077812ULL, 0x000fe400078ec0ffULL, 0x00000003ff027819ULL, 0x000fe4000001160cULL,
0x000000041e057210ULL, 0x000fe20007f3e0ffULL, 0x000000087c077824ULL, 0x000fc800078e0207ULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f440eULL, 0x0000007d0200720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000179047824ULL, 0x102fe200078e0202ULL,
0x0000006000007810ULL, 0x000fe20007ffe0ffULL, 0x000000010c027824ULL, 0x000fe400078e0202ULL,
0x000000040d067227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a06ULL,
0x00005a0005057a24ULL, 0x000fca00078e0204ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0000000702057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805027812ULL, 0x000fca00078ef80cULL, 0x0000001002027824ULL, 0x000fe400078e0203ULL,
0x0000000106062810ULL, 0x000fc60007ffe0ffULL, 0x0000000002087984ULL, 0x0002a20000000c00ULL,
0x000000060f057207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a05ULL,
0x0000590005057a24ULL, 0x000fe200078e027aULL, 0x00000003ff027819ULL, 0x002fe20000011600ULL,
0x00005a0007047a24ULL, 0x000fe200078e0204ULL, 0x000000070c077812ULL, 0x000fc600078ec0ffULL,
0x00005a0005047a24ULL, 0x000fe400078e0204ULL, 0x000000087c077824ULL, 0x000fe400078e0207ULL,
0x0000000179797824ULL, 0x000fe200078e0202ULL, 0x000000041e057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f4406ULL, 0x0000007d0200720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d08ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000790d067227ULL, 0x000fc800078e00ffULL,
0x000000ffff047224ULL, 0x002fe400078e0a06ULL, 0x0000000100027824ULL, 0x000fe400078e0202ULL,
0x00005a0004047a24ULL, 0x000fc600078e0279ULL, 0x0000000702057812ULL, 0x000fe400078ec0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f26070ULL, 0xfffffff805027812ULL, 0x000fe400078ef800ULL,
0x0000000700057812ULL, 0x000fca00078ec0ffULL, 0x000000087c057824ULL, 0x000fc800078e0205ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe20003f46070ULL, 0x0000001002047824ULL, 0x000fca00078e0203ULL,
0x0000000004087984ULL, 0x000e6e0000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x000000060f037207ULL, 0x000fca0004000000ULL, 0x000000ffff027224ULL, 0x000fe400078e0a03ULL,
0x00005900037a7a24ULL, 0x000fe400078e027aULL, 0x00005a0002797a24ULL, 0x000fc800078e0279ULL,
0x00005a007a797a24ULL, 0x000fca00078e0279ULL, 0x000000791e797210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x00005e0079027a11ULL, 0x000fc800078040ffULL,
0x00005f0079037a11ULL, 0x000fca00000f4406ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff047819ULL, 0x000fe20000011600ULL, 0xffffffffff057424ULL, 0x000fc600078e00ffULL,
0x000000660400720cULL, 0x000fda0003f06070ULL, 0x00000002070d8824ULL, 0x000fc800078e00ffULL,
0x00006a000d0d8a24ULL, 0x000fc800078e0204ULL, 0x000066000d0c8625ULL, 0x000fe200078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000080c058981ULL, 0x000ea2000c1e1900ULL,
0x000001ff1000780cULL, 0x000fe20003f04070ULL, 0x00005800ff107624ULL, 0x000fe400078e00ffULL,
0x000000806e6e7824ULL, 0x000fe200078e00ffULL, 0x00f60000ff0a7f8cULL, 0x000e62000c80043fULL,
0x00006e00ff0e7624ULL, 0x000fe400078e00ffULL, 0x00006f00ff0f7624ULL, 0x000fe200078e00ffULL,
0x0000001f10107810ULL, 0x000fe20007ffe0ffULL, 0x000000807a687824ULL, 0x000fc400078e00ffULL,
0x0000004000717824ULL, 0x000fe200078e00ffULL, 0x000000080e0e7981ULL, 0x000722000c1e9900ULL,
0x00000080ff117424ULL, 0x000fc600078e00ffULL, 0x00000040681f7812ULL, 0x000fe400078ef871ULL,
0x00000005ff0f7819ULL, 0x008fe20000011610ULL, 0x0000006e050c7224ULL, 0x004fc800078e02ffULL,
0x000064000c0c7625ULL, 0x000fe200078e0011ULL, 0x0000060000000947ULL, 0x000fea0003800000ULL,
0x00000002ff227819ULL, 0x002fe40000011606ULL, 0x0000100000237811ULL, 0x000fe400078e68ffULL,
0x0000000822207810ULL, 0x040fe20007ffe0ffULL, 0x000000011f107824ULL, 0x040fe200078e0222ULL,
0x0000001022247810ULL, 0x040fe40007ffe0ffULL, 0x0000001822267810ULL, 0x040fe20007ffe0ffULL,
0x000000011f127824ULL, 0x000fe200078e0220ULL, 0x00000020221e7810ULL, 0x000fe20007ffe0ffULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x000000011f147824ULL, 0x000fe200078e0224ULL,
0x0000003010197812ULL, 0x000fe200078ef809ULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0x000000190c187210ULL, 0x000fe20007f1e0ffULL, 0x000000011f167824ULL, 0x000fe200078e0226ULL,
0x00000030121b7812ULL, 0x000fe200078ef809ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x0000001b0c1a7210ULL, 0x000fe20007f3e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000030141d7812ULL, 0x000fe400078ef809ULL, 0x0000007102147217ULL, 0x000fe20007800000ULL,
0x000000010d197824ULL, 0x000fe200000e0611ULL, 0x0000003016117812ULL, 0x000fe200078ef809ULL,
0x000000011f1c7824ULL, 0x000fe200078e021eULL, 0x0000001d0c107210ULL, 0x040fe20007f1e0ffULL,
0x000000010d1b7824ULL, 0x040fe200008e0613ULL, 0x000000110c127210ULL, 0x000fe20007f3e0ffULL,
0x00000001141d7824ULL, 0x000fe200078e0a71ULL, 0x0000000606167211ULL, 0x000fe200078fe8ffULL,
0x000000010d117824ULL, 0x000fc400000e0615ULL, 0x000000801c147825ULL, 0x000fe200078e00ffULL,
0x0000000316217812ULL, 0x000fe400078ec0ffULL, 0x0000001d2200720cULL, 0x080fe20003f06070ULL,
0x000000010d137824ULL, 0x000fe200008e0617ULL, 0x0000001d2000720cULL, 0x040fe20003f26070ULL,
0x0000000420167824ULL, 0x000fe200078e00ffULL, 0x0000003014177812ULL, 0x000fe400078ef809ULL,
0x0000002822207810ULL, 0x000fe40007ffe0ffULL, 0xfffffffc16167812ULL, 0x000fc400078ee221ULL,
0x000000170c147210ULL, 0x000fe20007f5e0ffULL, 0x000000011f177824ULL, 0x000fe200078e0220ULL,
0x0ffffffc21067812ULL, 0x000fe200078ef806ULL, 0x0000001016277824ULL, 0x100fe200078e0223ULL,
0x0000001d2400720cULL, 0x080fe20003fa6070ULL, 0x0000008017167825ULL, 0x000fe200078e00ffULL,
0x0000001d2600720cULL, 0x080fe40003f86070ULL, 0x0000001d1e00720cULL, 0x000fe20003f66070ULL,
0x0000001006257824ULL, 0x000fe200078e0223ULL, 0x0000003016297812ULL, 0x000fe200078ef809ULL,
0x000000010d157824ULL, 0x000fe200010e0615ULL, 0x0000003022067810ULL, 0x000fe20007ffe0ffULL,
0x0000000424247824ULL, 0x000fe200078e00ffULL, 0x0000003822227810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e2000c101c48ULL,
0x000000290c1c7210ULL, 0x000fe20007fde0ffULL, 0x000000011f167824ULL, 0x000fe200078e0206ULL,
0x0000001d2000720cULL, 0x080fe20003f46070ULL, 0x000000001a277faeULL, 0x0005e2000c901c48ULL,
0x0000001d0600720cULL, 0x080fe20003f26070ULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x0000001d2200720cULL, 0x000fe20003f06070ULL, 0x000000010d1d7824ULL, 0x000fc400030e0617ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0xfffffffc1e1e7812ULL, 0x000fc600078ee221ULL,
0x000000011f187824ULL, 0x002fe400078e0222ULL, 0x00000004261a7824ULL, 0x004fe200078e00ffULL,
0x00000030161b7812ULL, 0x000fe200078ef809ULL, 0x0000000420207824ULL, 0x000fe400078e00ffULL,
0x0000000406267824ULL, 0x000fe200078e00ffULL, 0xfffffffc24067812ULL, 0x100fe200078ee221ULL,
0x0000000422287824ULL, 0x000fe200078e00ffULL, 0x0000001b0c167210ULL, 0x000fe20007fde0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0xfffffffc1a1a7812ULL, 0x000fc400078ee221ULL,
0xfffffffc20207812ULL, 0x000fe200078ee221ULL, 0x000000010d177824ULL, 0x000fe200030e0617ULL,
0xfffffffc26227812ULL, 0x000fe200078ee221ULL, 0x000000101a1b7824ULL, 0x000fe200078e0223ULL,
0xfffffffc28247812ULL, 0x000fe200078ee221ULL, 0x000000101e1f7824ULL, 0x000fe200078e0223ULL,
0x0000003018217812ULL, 0x000fe200078ef809ULL, 0x0000001006097824ULL, 0x100fe400078e0223ULL,
0x0000001022257824ULL, 0x100fe200078e0223ULL, 0x000000210c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001020217824ULL, 0x100fe200078e0223ULL, 0x0000000010097faeULL, 0x0003e2000e901c48ULL,
0x0000001024237824ULL, 0x000fc400078e0223ULL, 0x000000010d0d7824ULL, 0x000fe200030e0619ULL,
0x00000000121b7faeULL, 0x0003e8000e101c48ULL, 0x00000000141f7faeULL, 0x0003e8000d901c48ULL,
0x000000001c217faeULL, 0x0003e8000d101c48ULL, 0x0000000016257faeULL, 0x0003e8000c901c48ULL,
0x000000000c237faeULL, 0x0003e2000c101c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000001006147811ULL, 0x042fe400078ff0ffULL, 0x0000001806167811ULL, 0x000fc400078ff0ffULL,
0x00000028061a7811ULL, 0x040fe200078ff0ffULL, 0x000000011f157824ULL, 0x040fe200078e0214ULL,
0x00000038061e7811ULL, 0x040fe200078ff0ffULL, 0x000000011f177824ULL, 0x040fe200078e0216ULL,
0x0000000806207811ULL, 0x040fe200078ff0ffULL, 0x000000011f227824ULL, 0x040fe200078e021aULL,
0x0000002006187811ULL, 0x040fe200078ff0ffULL, 0x000000011f267824ULL, 0x000fe200078e021eULL,
0x00000030061c7811ULL, 0x000fe200078ff0ffULL, 0x0000000420287824ULL, 0x000fe200078e00ffULL,
0x0000000606117211ULL, 0x000fe200078fe8ffULL, 0x0000000414147824ULL, 0x000fe200078e00ffULL,
0x0000001f06107211ULL, 0x000fe200078ff0ffULL, 0x0000000416167824ULL, 0x000fe200078e00ffULL,
0x0000000311137812ULL, 0x000fe200078ec0ffULL, 0x00000004182a7824ULL, 0x000fe200078e00ffULL,
0x00001000002d7811ULL, 0x000fe200078e68ffULL, 0x000000041a1a7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc13217812ULL, 0x000fe200078ef806ULL, 0x000000041c2c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc28067812ULL, 0x100fe200078ee213ULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc16197812ULL, 0x100fe200078ee213ULL, 0x000000011f127824ULL, 0x000fe200078e0220ULL,
0xfffffffc2a1b7812ULL, 0x100fe200078ee213ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffffc2c1d7812ULL, 0x000fc400078ee213ULL, 0xfffffffc1e1e7812ULL, 0x100fe200078ee213ULL,
0x000000011f207824ULL, 0x040fe200078e0218ULL, 0xfffffffc14187812ULL, 0x100fe200078ee213ULL,
0x000000011f247824ULL, 0x000fe200078e021cULL, 0xfffffffc1a1c7812ULL, 0x000fe200078ee213ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000030101f7812ULL, 0x000fc600078ef809ULL,
0x0000008015147825ULL, 0x000fe200078e00ffULL, 0x0000001f0c1a7210ULL, 0x000fc60007f1e0ffULL,
0x0000001019257824ULL, 0x000fe200078e022dULL, 0x0000003012197812ULL, 0x100fe200078ef809ULL,
0x0000008017167825ULL, 0x000fe200078e00ffULL, 0x00000030141f7812ULL, 0x000fc600078ef809ULL,
0x0000001021357824ULL, 0x100fe400078e022dULL, 0x0000001006217824ULL, 0x100fe400078e022dULL,
0x0000001018237824ULL, 0x100fe400078e022dULL, 0x000000101b277824ULL, 0x100fe400078e022dULL,
0x000000101c297824ULL, 0x100fe200078e022dULL, 0x000000190c1c7210ULL, 0x000fe20007f3e0ffULL,
0x000000101d2b7824ULL, 0x000fe200078e022dULL, 0x0000003016197812ULL, 0x000fe200078ef809ULL,
0x000000101e2d7824ULL, 0x000fe200078e022dULL, 0x0000001f0c1e7210ULL, 0x040fe20007f5e0ffULL,
0x000000010d1b7824ULL, 0x040fe200000e0611ULL, 0x000000190c167210ULL, 0x000fe20007f1e0ffULL,
0x000000010d1d7824ULL, 0x000fc400008e0613ULL, 0x0000008020107825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a357faeULL, 0x0003e6000b901c48ULL,
0x000000010d1f7824ULL, 0x000fe200010e0615ULL, 0x0000003010337812ULL, 0x100fe200078ef809ULL,
0x0000008022127825ULL, 0x000fe200078e00ffULL, 0x000000001c217faeULL, 0x0003e6000b901c48ULL,
0x0000008024147825ULL, 0x000fe200078e00ffULL, 0x0000003012317812ULL, 0x100fe200078ef809ULL,
0x000000001e237faeULL, 0x0003e4000b901c48ULL, 0x0000008026187825ULL, 0x000fe200078e00ffULL,
0x00000030142f7812ULL, 0x000fc400078ef809ULL, 0x000000310c127210ULL, 0x000fe20007f3e0ffULL,
0x000000010d177824ULL, 0x040fe200000e0617ULL, 0x0000003018097812ULL, 0x000fe400078ef809ULL,
0x000000330c107210ULL, 0x040fe20007f1e0ffULL, 0x000000010d137824ULL, 0x040fe200008e0613ULL,
0x0000002f0c147210ULL, 0x040fe20007f5e0ffULL, 0x0000000016257faeULL, 0x0003e2000b901c48ULL,
0x000000090c0c7210ULL, 0x000fe20007f7e0ffULL, 0x000000010d117824ULL, 0x040fe400000e0611ULL,
0x000000010d157824ULL, 0x000fc400010e0615ULL, 0x000000010d0d7824ULL, 0x000fe200018e0619ULL,
0x0000000010277faeULL, 0x0003e8000b901c48ULL, 0x0000000012297faeULL, 0x0003e8000b901c48ULL,
0x00000000142b7faeULL, 0x0003e8000b901c48ULL, 0x000000000c2d7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x00000000000c7805ULL, 0x002fc40000015200ULL,
0x00f60400ff097984ULL, 0x000e620000000800ULL, 0x0000000f083f7224ULL, 0x000fc400078e02ffULL,
0x00000001026f7824ULL, 0x000fe400078e0a65ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x8000000009ff7812ULL, 0x002fe2000780480bULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000062003f3e7625ULL, 0x000fe200078e003eULL,
0x00000008ff6f7819ULL, 0x000fe2000001166fULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x000000080c117210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e0dULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011409ULL,
0x0000001106067211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000206067819ULL, 0x000fc80000001209ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000110107810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000097919ULL, 0x000e640000000000ULL, 0x0000002000067824ULL, 0x002fca00078e0209ULL,
0x00000003ff087819ULL, 0x000fc80000011606ULL, 0x1ffffffe08097812ULL, 0x000fe400078ec0ffULL,
0x0000000f06087812ULL, 0x000fc600078ec0ffULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x00000010080b7824ULL, 0x040fe400078e00ffULL, 0x0000001008087824ULL, 0x000fe200078e00ffULL,
0x0000000f09067812ULL, 0x040fe400078ec0ffULL, 0x0000000109097810ULL, 0x000fe40007ffe0ffULL,
0x000000f00b067812ULL, 0x000fe400078ee206ULL, 0x0000000f09097812ULL, 0x000fc600078ec0ffULL,
0x0000000006147984ULL, 0x000e62000000cc00ULL, 0x000000f008097812ULL, 0x000fca00078ee209ULL,
0x0000000009107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff187224ULL, 0x002fe400078e0014ULL,
0x000000ffff147224ULL, 0x000fe400078e0015ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x000000ffff1a7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1b7224ULL, 0x000fc400078e0012ULL, 0x000000ffff167224ULL, 0x000fe400078e0011ULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x0000001806007388ULL, 0x0003e8000000cc00ULL,
0x0000001409007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff0c7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff107224ULL, 0x000fc600078e00ffULL,
0x0000000000087805ULL, 0x002fc80000015200ULL, 0x00f60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x006fc4000780480dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a08117210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc8000001140bULL,
0x0000001106067211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x0000000206067819ULL, 0x000fc8000000120bULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000110107810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000e620000000000ULL, 0x00006a00076d7a24ULL, 0x000fe200078e02ffULL,
0x3db504f30e077820ULL, 0x010fe20000410000ULL, 0x000000020f6c7824ULL, 0x000fe200078e00ffULL,
0x0000f68800707811ULL, 0x040fe200078e18ffULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0xffffffff65697810ULL, 0x040fe40007ffe0ffULL, 0x00000009656b7810ULL, 0x000fe40007ffe0ffULL,
0x0000f60800747811ULL, 0x000fc400078e28ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0009ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x01cfc4000001ff00ULL,
0x000000010a00780cULL, 0x000fe20003f25270ULL, 0x0000006e05107224ULL, 0x010fe200078e02ffULL,
0x00000001080c7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff117424ULL, 0x000fe200078e00ffULL,
0x000000010a0d7810ULL, 0x000fe20007ffe0ffULL, 0x00000bc000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000aULL, 0x000000010b097812ULL, 0x000fc400078e0cffULL,
0x000000020d00780cULL, 0x000fe20003f06070ULL, 0x000000ffff0a7224ULL, 0x000fc600078e000dULL,
0x000000ffff0c1224ULL, 0x000fc800078e0208ULL, 0x000001000c1b7824ULL, 0x060fe200078e0271ULL,
0x000000010c0e7810ULL, 0x000fc80007ffe0ffULL, 0x000000030e00720cULL, 0x000fe40003f46070ULL,
0x000000401b3d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff0d0e7207ULL, 0x000fe20000800000ULL,
0x00006400100c7625ULL, 0x000fc800078e0011ULL, 0x00000001683d7824ULL, 0x000fc800078e023dULL,
0x000005d00000a947ULL, 0x000fea0003800000ULL, 0x0000001006107824ULL, 0x002fe200078e00ffULL,
0x00000002ff447819ULL, 0x000fe20000011606ULL, 0x00000002003c7824ULL, 0x000fe200078e0209ULL,
0x0000001b021a7217ULL, 0x000fe40007800000ULL, 0x0000003010117812ULL, 0x000fe200078ec0ffULL,
0x0000000144137824ULL, 0x040fe200078e023dULL, 0x0000000844437810ULL, 0x000fe20007ffe0ffULL,
0x000000011a427824ULL, 0x000fe200078e0a1bULL, 0x0000001844467810ULL, 0x000fe20007ffe0ffULL,
0x000000400e107824ULL, 0x000fe200078e0211ULL, 0x0000001044457810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x0000002044487810ULL, 0x000fe20007ffe0ffULL,
0x0000000143197824ULL, 0x000fe200078e023dULL, 0x000010003c3c7811ULL, 0x000fe200078e60ffULL,
0x0000008013127825ULL, 0x000fe200078e0010ULL, 0x00000030444b7810ULL, 0x000fc40007ffe0ffULL,
0x000000424600720cULL, 0x040fe20003fa6070ULL, 0x0000000146417824ULL, 0x000fe200078e023dULL,
0x000000120c1a7210ULL, 0x000fe20007f3e0ffULL, 0x0000008019187825ULL, 0x000fc800078e0010ULL,
0x0000008041407825ULL, 0x000fe200078e0010ULL, 0x000000180c387210ULL, 0x000fe40007f5e0ffULL,
0x0000000606187211ULL, 0x000fe200078fe8ffULL, 0x00000001453b7824ULL, 0x000fe400078e023dULL,
0x000000010d1b7824ULL, 0x000fe200008e0613ULL, 0x000000400c127210ULL, 0x000fe20007f3e0ffULL,
0x000000803b3a7825ULL, 0x000fe200078e0010ULL, 0x0000000318497812ULL, 0x000fc600078ec0ffULL,
0x00000004454a7824ULL, 0x000fe200078e00ffULL, 0x0000003a0c3a7210ULL, 0x000fe20007f7e0ffULL,
0x000000010d137824ULL, 0x040fe200008e0641ULL, 0x000000424400720cULL, 0x080fe20003f26070ULL,
0x000000010d397824ULL, 0x000fe200010e0619ULL, 0x000000424300720cULL, 0x0c0fe20003f46070ULL,
0x0000000443407824ULL, 0x000fe200078e00ffULL, 0xfffffffc4a477812ULL, 0x000fe200078ee249ULL,
0x000000010d3b7824ULL, 0x000fe200018e063bULL, 0x0ffffffc49437812ULL, 0x000fe200078ef806ULL,
0x0000000148197824ULL, 0x000fe200078e023dULL, 0x00000028444a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001047477824ULL, 0x100fe200078e023cULL, 0x000000424500720cULL, 0x080fe20003f66070ULL,
0x0000001043437824ULL, 0x000fe200078e023cULL, 0xfffffffc40457812ULL, 0x000fe200078ee249ULL,
0x000000014a417824ULL, 0x000fe200078e023dULL, 0x0000003844447810ULL, 0x000fe20007ffe0ffULL,
0x0000008019187825ULL, 0x000fe200078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a437faeULL, 0x0003e4000c901c48ULL, 0x000000424400720cULL, 0x000fe20003f26070ULL,
0x0000001045457824ULL, 0x000fe200078e023cULL, 0x000000180c187210ULL, 0x000fe20007f9e0ffULL,
0x0000008041407825ULL, 0x000fc600078e0010ULL, 0x0000000038457faeULL, 0x0005e2000d101c48ULL,
0x000000010d197824ULL, 0x000fe200020e0619ULL, 0x000000424800720cULL, 0x000fe20003f86070ULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0x000000400c1a7210ULL, 0x002fe20007fde0ffULL,
0x000000014b1b7824ULL, 0x140fe200078e023dULL, 0x000000003a477faeULL, 0x0003e2000d901c48ULL,
0x00000001443d7824ULL, 0x000fe200078e023dULL, 0x000000424a00720cULL, 0x080fe20003f66070ULL,
0x0000000448487824ULL, 0x000fe200078e00ffULL, 0x000000424b00720cULL, 0x000fe20003f46070ULL,
0x000000044a4a7824ULL, 0x000fc400078e00ffULL, 0x000000801b387825ULL, 0x004fc800078e0010ULL,
0x000000010d1b7824ULL, 0x000fe200030e0641ULL, 0x000000380c387210ULL, 0x000fe20007fde0ffULL,
0x000000044b3a7824ULL, 0x002fe200078e00ffULL, 0xfffffffc463b7812ULL, 0x000fe200078ee249ULL,
0x000000803d107825ULL, 0x000fe200078e0010ULL, 0xfffffffc483d7812ULL, 0x100fe400078ee249ULL,
0xfffffffc4a417812ULL, 0x100fe200078ee249ULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0xfffffffc3a437812ULL, 0x000fe200078ee249ULL, 0x000000010d397824ULL, 0x000fe200030e0639ULL,
0x000000100c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000103b3b7824ULL, 0x100fe200078e023cULL,
0xfffffffc44457812ULL, 0x000fe200078ee249ULL, 0x000000103d3d7824ULL, 0x000fc400078e023cULL,
0x0000001041417824ULL, 0x100fe200078e023cULL, 0x00000000123b7faeULL, 0x0003e2000e901c48ULL,
0x0000001043437824ULL, 0x100fe400078e023cULL, 0x0000001045457824ULL, 0x000fe200078e023cULL,
0x00000000183d7faeULL, 0x0003e2000e101c48ULL, 0x000000010d0d7824ULL, 0x000fc600030e0611ULL,
0x000000001a417faeULL, 0x0003e8000d901c48ULL, 0x0000000038437faeULL, 0x0003e8000d101c48ULL,
0x000000000c457faeULL, 0x0003e2000c901c48ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x0000000606117211ULL, 0x042fe200078fe8ffULL, 0x0000001006107824ULL, 0x040fe200078e00ffULL,
0x0000000806187811ULL, 0x000fe200078ff0ffULL, 0x0000000200127824ULL, 0x000fe200078e0209ULL,
0x00000010061a7811ULL, 0x000fc400078ff0ffULL, 0x0000001806387811ULL, 0x000fe200078ff0ffULL,
0x00000001181b7824ULL, 0x100fe200078e023dULL, 0x00000020063a7811ULL, 0x000fe200078ff0ffULL,
0x000000011a397824ULL, 0x100fe200078e023dULL, 0x00000028063c7811ULL, 0x000fe200078ff0ffULL,
0x00000001383b7824ULL, 0x100fe200078e023dULL, 0x0000003006407811ULL, 0x000fe200078ff0ffULL,
0x0000000418187824ULL, 0x000fe200078e00ffULL, 0x0000003806427811ULL, 0x000fe200078ff0ffULL,
0x000000013c417824ULL, 0x100fe200078e023dULL, 0x0000000311197812ULL, 0x000fe200078ec0ffULL,
0x000000013a117824ULL, 0x100fe200078e023dULL, 0x0000003010137812ULL, 0x000fe200078ec0ffULL,
0x00000001404d7824ULL, 0x000fe200078e023dULL, 0x0000100012537811ULL, 0x000fe200078e60ffULL,
0x000000041a1a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc18187812ULL, 0x100fe200078ee219ULL,
0x0000000438387824ULL, 0x000fe200078e00ffULL, 0x0ffffffc19107812ULL, 0x000fe200078ef806ULL,
0x000000043a3a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1a1a7812ULL, 0x100fe200078ee219ULL,
0x000000043c3c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc38387812ULL, 0x100fe200078ee219ULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0xfffffffc3a3a7812ULL, 0x100fe200078ee219ULL,
0x0000000442447824ULL, 0x000fe200078e00ffULL, 0xfffffffc3c3c7812ULL, 0x000fe200078ee219ULL,
0x000000400e127824ULL, 0x000fe200078e0213ULL, 0xfffffffc40407812ULL, 0x100fe200078ee219ULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0xfffffffc44447812ULL, 0x000fe200078ee219ULL,
0x0000001018437824ULL, 0x100fe200078e0253ULL, 0x0000003d06197211ULL, 0x000fe200078ff0ffULL,
0x000000101a457824ULL, 0x000fc400078e0253ULL, 0x0000001038477824ULL, 0x000fe400078e0253ULL,
0x0000008019187825ULL, 0x000fc800078e0012ULL, 0x000000801b1a7825ULL, 0x000fe200078e0012ULL,
0x000000180c187210ULL, 0x000fc60007f3e0ffULL, 0x000000103a497824ULL, 0x000fe200078e0253ULL,
0x0000001a0c1a7210ULL, 0x000fe20007f5e0ffULL, 0x0000008039387825ULL, 0x000fc800078e0012ULL,
0x000000803b3a7825ULL, 0x000fe200078e0012ULL, 0x000000380c387210ULL, 0x000fc60007f7e0ffULL,
0x0000000142517824ULL, 0x000fe200078e023dULL, 0x0000003a0c3a7210ULL, 0x000fe20007f9e0ffULL,
0x000000103c4b7824ULL, 0x100fe400078e0253ULL, 0x00000010404f7824ULL, 0x000fe400078e0253ULL,
0x00000080113c7825ULL, 0x000fc800078e0012ULL, 0x0000001010557824ULL, 0x000fe400078e0253ULL,
0x0000008041407825ULL, 0x000fc800078e0012ULL, 0x000000804d107825ULL, 0x000fc800078e0012ULL,
0x0000008051127825ULL, 0x000fc800078e0012ULL, 0x000000010d197824ULL, 0x040fe200008e0619ULL,
0x0000003c0c3c7210ULL, 0x040fe20007f3e0ffULL, 0x000000010d1b7824ULL, 0x040fe200010e061bULL,
0x000000400c407210ULL, 0x040fe20007f5e0ffULL, 0x000000010d397824ULL, 0x040fe200018e0639ULL,
0x000000100c107210ULL, 0x040fe20007f7e0ffULL, 0x000000010d3b7824ULL, 0x040fe200020e063bULL,
0x000000120c0c7210ULL, 0x000fe20007f9e0ffULL, 0x000000010d3d7824ULL, 0x040fe200008e063dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018557faeULL, 0x0003e2000b901c48ULL,
0x000000010d417824ULL, 0x000fc400010e0641ULL, 0x000000010d117824ULL, 0x040fe200018e0611ULL,
0x000000001a437faeULL, 0x0003e2000b901c48ULL, 0x0000001044537824ULL, 0x000fe400078e0253ULL,
0x000000010d0d7824ULL, 0x000fe200020e0613ULL, 0x0000000038457faeULL, 0x0003e8000b901c48ULL,
0x000000003a477faeULL, 0x0003e8000b901c48ULL, 0x000000003c497faeULL, 0x0003e8000b901c48ULL,
0x00000000404b7faeULL, 0x0003e8000b901c48ULL, 0x00000000104f7faeULL, 0x0003e8000b901c48ULL,
0x000000000c537faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010e00780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x0000000204047810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff057424ULL, 0x000fc600078e00ffULL, 0x000000660400720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x000000026d0c7824ULL, 0x002fe400078e0204ULL,
0x00000004ff0d7424ULL, 0x000fc800078e00ffULL, 0x000066000c0c7625ULL, 0x000fca00078e000dULL,
0x000000080c057981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000020060d7810ULL, 0x002fe20007ffe0ffULL,
0x00000002000c7824ULL, 0x000fe200078e020bULL, 0xfffffff8063d7812ULL, 0x040fe200078ec0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0xfffffff80d0b7812ULL, 0x000fe400078ec0ffULL,
0x00000007060d7812ULL, 0x000fe400078ec0ffULL, 0x000000073d3d7812ULL, 0x100fe400078ef806ULL,
0x000000070b447812ULL, 0x000fc400078ef806ULL, 0x000010000c0b7811ULL, 0x000fe400078e60ffULL,
0x000000080d0c7812ULL, 0x000fe400078ef806ULL, 0x00000001ff0d7819ULL, 0x000fe4000001163dULL,
0x00000001ff3c7819ULL, 0x000fe20000011644ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000013c107824ULL, 0x000fe200078e020eULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000444117824ULL, 0x000fe200078e00ffULL, 0x000000010e127810ULL, 0x000fe20007ffe0ffULL,
0x000000100c1a7824ULL, 0x020fc400078e00ffULL, 0x000000043d197824ULL, 0x000fe200078e00ffULL,
0xfffffffc11107812ULL, 0x000fe200078ee210ULL, 0x000000043d117824ULL, 0x000fe400078e00ffULL,
0x000000010d187824ULL, 0x040fe400078e0212ULL, 0x0000001010407824ULL, 0x000fe400078e020bULL,
0x000000010d107824ULL, 0x000fe200078e020eULL, 0xfffffffc19187812ULL, 0x000fe200078ee218ULL,
0x00000004441b7824ULL, 0x000fc400078e00ffULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0xfffffffc11107812ULL, 0x000fe200078ee210ULL, 0x000000040f117824ULL, 0x000fe200078e020eULL,
0x000000020e0e7810ULL, 0x000fe20007ffe0ffULL, 0x000000013c467824ULL, 0x000fe400078e0212ULL,
0x0000001010107824ULL, 0x100fe200078e020bULL, 0x000000040e00780cULL, 0x000fe20003f25270ULL,
0x0000000211117824ULL, 0x000fe200078e00ffULL, 0xfffffffc1b467812ULL, 0x000fe200078ee246ULL,
0x0000001018187824ULL, 0x000fe200078e020bULL, 0x000000001038783bULL, 0x000ea20000000200ULL,
0x000000100c457824ULL, 0x000fe200078e00ffULL, 0x0000001106137211ULL, 0x000fc400078fe0ffULL,
0x0000000211117810ULL, 0x000fc60007ffe0ffULL, 0x000000010c137824ULL, 0x000fe200078e0213ULL,
0x0000001106197211ULL, 0x000fc800078fe0ffULL, 0xfffffff01a137812ULL, 0x000fe200078ee213ULL,
0x000000010c527824ULL, 0x000fe400078e0219ULL, 0x000000001818783bULL, 0x000ee40000000200ULL,
0x0000001013137824ULL, 0x000fe200078e00ffULL, 0xfffffff045527812ULL, 0x000fca00078ee252ULL,
0x000000001310783bULL, 0x000ee20000000200ULL, 0x00000010ff5a7819ULL, 0x102fe40000011640ULL,
0x00000018ff597819ULL, 0x000fe40000011640ULL, 0x000000ff40587812ULL, 0x040fe400078ec0ffULL,
0x0000ffff405b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff497819ULL, 0x100fe40000011643ULL,
0x00000018ff637819ULL, 0x000fc40000011643ULL, 0x00000018ff407819ULL, 0x004fe40000011638ULL,
0x000000ff43617812ULL, 0x040fe400078ec0ffULL, 0x0000ffff434b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4d7819ULL, 0x100fe40000011641ULL, 0x00000018ff5d7819ULL, 0x000fe40000011641ULL,
0x000000ff415f7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff414e7812ULL, 0x000fe400078ec0ffULL,
0x00000040ff43723eULL, 0x000fe400020006ffULL, 0x000000ff38417812ULL, 0x040fe400078ec0ffULL,
0x00000010ff407819ULL, 0x000fe40000011638ULL, 0x0000ffff38387812ULL, 0x000fe400078ec0ffULL,
0x000000ff40407812ULL, 0x000fc400078ec0ffULL, 0x00000008ff387819ULL, 0x000fe40000011638ULL,
0x00000010ff477819ULL, 0x100fe40000011642ULL, 0x00000018ff627819ULL, 0x000fe40000011642ULL,
0x000000ff42677812ULL, 0x040fe400078ec0ffULL, 0x0000ffff42487812ULL, 0x000fe400078ec0ffULL,
0x00000041ff42723eULL, 0x000fc400020006ffULL, 0x00000040ff41723eULL, 0x000fe400020006ffULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x0000541041417816ULL, 0x000fe40000000043ULL,
0x0000541042407816ULL, 0x000fe20000000038ULL, 0x0000001046387824ULL, 0x000fe200078e020bULL,
0x0000ffff39437812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4a7819ULL, 0x008fc40000011618ULL,
0x00000018ff577819ULL, 0x000fe20000011618ULL, 0x000000401034723cULL, 0x000b620000001834ULL,
0x000000ff18517812ULL, 0x040fe400078ec0ffULL, 0x0000ffff184c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff457819ULL, 0x000fe40000011619ULL, 0x00000010ff417819ULL, 0x020fe40000011639ULL,
0x00000018ff537819ULL, 0x000fc40000011619ULL, 0x000000ff19547812ULL, 0x040fe400078ec0ffULL,
0x0000ffff19467812ULL, 0x000fe400078ec0ffULL, 0x00000018ff777819ULL, 0x000fe40000011639ULL,
0x000000ff39767812ULL, 0x000fe400078ec0ffULL, 0x000000ff41197812ULL, 0x000fe400078ec0ffULL,
0x00000008ff187819ULL, 0x000fc40000011643ULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000019ff19723eULL, 0x000fe400020006ffULL,
0x00000018ff18723eULL, 0x000fe400020006ffULL, 0x00000010ff737819ULL, 0x000fe4000001163aULL,
0x0000ffff3a757812ULL, 0x000fc400078ec0ffULL, 0x0000541019197816ULL, 0x000fe40000000077ULL,
0x0000541076187816ULL, 0x000fe40000000018ULL, 0x00000018ff607819ULL, 0x000fe4000001163aULL,
0x000000ff3a647812ULL, 0x000fe400078ec0ffULL, 0x000000ff73737812ULL, 0x000fe200078ec0ffULL,
0x000000181030723cULL, 0x000b620000001830ULL, 0x00000008ff757819ULL, 0x000fc40000011675ULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000073ff19723eULL, 0x020fe400020006ffULL, 0x00000075ff18723eULL, 0x000fe400020006ffULL,
0x00000010ff6a7819ULL, 0x000fe4000001163bULL, 0x0000ffff3b727812ULL, 0x000fc400078ec0ffULL,
0x0000541019197816ULL, 0x000fe40000000060ULL, 0x0000541064187816ULL, 0x000fe40000000018ULL,
0x00000018ff5e7819ULL, 0x000fe4000001163bULL, 0x000000ff3b5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff6a6a7812ULL, 0x000fe200078ec0ffULL, 0x00000018102c723cULL, 0x000b62000000182cULL,
0x00000008ff727819ULL, 0x000fe20000011672ULL, 0x000000003838783bULL, 0x000fe20000000200ULL,
0x0000005eff5e723eULL, 0x000fc400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000006aff19723eULL, 0x020fe400020006ffULL, 0x00000072ff18723eULL, 0x000fe400020006ffULL,
0x0000541019197816ULL, 0x000fe4000000005eULL, 0x000054105c187816ULL, 0x000fe40000000018ULL,
0x000000ff5a5a7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff5b7819ULL, 0x000fe4000001165bULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x000000181028723cULL, 0x000b620000001828ULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000010ff407819ULL, 0x100fe4000001161aULL,
0x00000018ff567819ULL, 0x000fe4000001161aULL, 0x0000005aff19723eULL, 0x020fc400020006ffULL,
0x0000005bff18723eULL, 0x000fe400020006ffULL, 0x0000541019197816ULL, 0x000fe40000000059ULL,
0x0000541058187816ULL, 0x000fe40000000018ULL, 0x000000ff1a557812ULL, 0x040fe400078ec0ffULL,
0x0000ffff1a427812ULL, 0x000fe400078ec0ffULL, 0x00000010ff417819ULL, 0x100fe2000001161bULL,
0x000000181024723cULL, 0x000b620000001824ULL, 0x00000018ff507819ULL, 0x000fc4000001161bULL,
0x000000ff1b4f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff1b437812ULL, 0x000fe400078ec0ffULL,
0x0000001052187824ULL, 0x020fe200078e00ffULL, 0x000000ff4d767812ULL, 0x000fe400078ec0ffULL,
0x00000008ff757819ULL, 0x000fe4000001164eULL, 0x000000ff49497812ULL, 0x000fe200078ec0ffULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0x0000005dff5d723eULL, 0x000fc400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x000000ff47737812ULL, 0x000fe400078ec0ffULL,
0x00000008ff477819ULL, 0x000fe4000001164bULL, 0x00000008ff727819ULL, 0x000fc40000011648ULL,
0x00000049ff4b723eULL, 0x000fe400020006ffULL, 0x0000541076497816ULL, 0x000fe4000000005dULL,
0x000054105f487816ULL, 0x000fe40000000075ULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x000000481020723cULL, 0x000b620000001820ULL, 0x00000063ff63723eULL, 0x000fc400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x0000541073497816ULL, 0x020fe40000000062ULL,
0x0000541067487816ULL, 0x000fe40000000072ULL, 0x000054104b637816ULL, 0x000fc40000000063ULL,
0x0000541061627816ULL, 0x000fe40000000047ULL, 0x000000ff4a4a7812ULL, 0x000fe200078ec0ffULL,
0x00000048101c723cULL, 0x040f62000000181cULL, 0x00000008ff4c7819ULL, 0x000fe4000001164cULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x000000ff45457812ULL, 0x000fe200078ec0ffULL, 0x000000621014723cULL, 0x000b620000001814ULL,
0x00000008ff467819ULL, 0x000fc40000011646ULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x0000004aff11723eULL, 0x020fe400020006ffULL,
0x0000004cff10723eULL, 0x000fe400020006ffULL, 0x0000541011117816ULL, 0x000fe40000000057ULL,
0x0000541051107816ULL, 0x000fc40000000010ULL, 0x000000ff40407812ULL, 0x000fe400078ec0ffULL,
0x00000008ff427819ULL, 0x000fe40000011642ULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x000000101834723cULL, 0x002b620000001834ULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x000000ff41417812ULL, 0x000fe400078ec0ffULL, 0x00000008ff437819ULL, 0x000fc40000011643ULL,
0x00000045ff11723eULL, 0x020fe400020006ffULL, 0x00000046ff10723eULL, 0x000fe400020006ffULL,
0x0000541011117816ULL, 0x000fe40000000053ULL, 0x0000541054107816ULL, 0x000fe40000000010ULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x0000004fff4f723eULL, 0x000fc400020006ffULL,
0x00000010ff5a7819ULL, 0x100fe20000011638ULL, 0x000000101830723cULL, 0x000b620000001830ULL,
0x0000ffff385b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe40000011638ULL,
0x000000ff38647812ULL, 0x000fe400078ec0ffULL, 0x00000040ff11723eULL, 0x020fe400020006ffULL,
0x00000042ff10723eULL, 0x000fc400020006ffULL, 0x0000541011117816ULL, 0x000fe40000000056ULL,
0x0000541055107816ULL, 0x000fe40000000010ULL, 0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5b7819ULL, 0x000fe4000001165bULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x00000010182c723cULL, 0x000b62000000182cULL, 0x00000064ff64723eULL, 0x000fc400020006ffULL,
0x00000010ff587819ULL, 0x100fe40000011639ULL, 0x00000018ff607819ULL, 0x000fe40000011639ULL,
0x00000041ff11723eULL, 0x020fe400020006ffULL, 0x00000043ff10723eULL, 0x000fe400020006ffULL,
0x0000541011117816ULL, 0x000fe40000000050ULL, 0x000054104f107816ULL, 0x000fc40000000010ULL,
0x000000ff395e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff387819ULL, 0x100fe4000001163aULL,
0x00000018ff5c7819ULL, 0x000fe2000001163aULL, 0x000000101828723cULL, 0x000b620000001828ULL,
0x000000ff3a597812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4d7819ULL, 0x100fe4000001163bULL,
0x00000018ff4e7819ULL, 0x000fc4000001163bULL, 0x0000005aff11723eULL, 0x020fe400020006ffULL,
0x0000005bff10723eULL, 0x000fe400020006ffULL, 0x0000541011117816ULL, 0x000fe4000000006aULL,
0x0000541064107816ULL, 0x000fe40000000010ULL, 0x000000ff3b527812ULL, 0x000fe400078ec0ffULL,
0x0000ffff39397812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3a3a7812ULL, 0x000fe200078ec0ffULL,
0x000000101824723cULL, 0x000b620000001824ULL, 0x0000ffff3b3b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff58587812ULL, 0x000fe400078ec0ffULL, 0x00000008ff397819ULL, 0x000fe40000011639ULL,
0x000000ff38387812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3a7819ULL, 0x000fc4000001163aULL,
0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff107819ULL, 0x020fe4000001163bULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fc400020006ffULL,
0x00000058ff5f723eULL, 0x000fe400020006ffULL, 0x00000039ff39723eULL, 0x000fe400020006ffULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x00000052ff52723eULL, 0x000fc400020006ffULL,
0x0000004dff53723eULL, 0x000fe400020006ffULL, 0x00000010ff10723eULL, 0x000fe400020006ffULL,
0x000054105f5f7816ULL, 0x000fe40000000060ULL, 0x000054105e5e7816ULL, 0x000fe40000000039ULL,
0x00005410383b7816ULL, 0x000fe4000000005cULL, 0x00005410593a7816ULL, 0x000fc4000000003aULL,
0x0000541053537816ULL, 0x000fe2000000004eULL, 0x0000005e1820723cULL, 0x000b620000001820ULL,
0x0000541052527816ULL, 0x000fce0000000010ULL, 0x0000003a181c723cULL, 0x040b70000000181cULL,
0x000000521814723cULL, 0x000b620000001814ULL, 0xfffff08000001947ULL, 0x000fce000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0009ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe28000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000000735357220ULL, 0x080fe20000410000ULL,
0x0000000730307220ULL, 0x080fe20000410000ULL, 0x000000072d0a7220ULL, 0x080fe20000410000ULL,
0x0000000725257220ULL, 0x080fe20000410000ULL, 0x0000000721217220ULL, 0x0a0fe20000410000ULL,
0x0000000734197220ULL, 0x080fe20000410000ULL, 0x00000007320d7220ULL, 0x080fe20000410000ULL,
0x00000007330e7220ULL, 0x080fe20000410000ULL, 0x000000072f107220ULL, 0x080fe20000410000ULL,
0x00000007371a7220ULL, 0x080fe20000410000ULL, 0x00000007311b7220ULL, 0x080fe20000410000ULL,
0x000000072c337220ULL, 0x080fe20000410000ULL, 0x00000007282f7220ULL, 0x080fe20000410000ULL,
0x000000071c347220ULL, 0x080fe20000410000ULL, 0x000000071d327220ULL, 0x080fe20000410000ULL,
0x00000007360c7220ULL, 0x080fe20000410000ULL, 0x000000072e0f7220ULL, 0x080fe20000410000ULL,
0x0000000729387220ULL, 0x080fe20000410000ULL, 0x000000072a287220ULL, 0x080fe20000410000ULL,
0x000000072b377220ULL, 0x080fe20000410000ULL, 0x0000000720317220ULL, 0x080fe20000410000ULL,
0x000000071e1c7220ULL, 0x080fe20000410000ULL, 0x000000071f1d7220ULL, 0x080fe20000410000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0035ULL, 0x0000000724367220ULL, 0x080fe20000410000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0030ULL, 0x0000000726297220ULL, 0x080fe20000410000ULL,
0x0000000727187220ULL, 0x080fe20000410000ULL, 0x0000000722207220ULL, 0x080fe20000410000ULL,
0x0000000723117220ULL, 0x080fe20000410000ULL, 0x00000007142a7220ULL, 0x080fe20000410000ULL,
0x00000007152b7220ULL, 0x080fe20000410000ULL, 0x00000007161e7220ULL, 0x080fe20000410000ULL,
0x00000007171f7220ULL, 0x000fe20000410000ULL, 0x000000ffff2e7224ULL, 0x000fc400078e000aULL,
0x000000ffff307224ULL, 0x000fe400078e0025ULL, 0x000000ffff357224ULL, 0x000fe200078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000700a7f8cULL, 0x0002a2000c80043fULL,
0x000000ffff227224ULL, 0x000fe400078e000cULL, 0x000000ffff237224ULL, 0x000fe400078e000dULL,
0x000000ffff277224ULL, 0x000fe400078e000eULL, 0x000000ffff267224ULL, 0x000fc400078e000fULL,
0x000000ffff257224ULL, 0x000fe400078e0010ULL, 0x000000ffff217224ULL, 0x000fc400078e0011ULL,
0x00000000000c7805ULL, 0x002fca0000015200ULL, 0x00000400700f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x006fe4000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c117210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000110e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000110107810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400700f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000406177824ULL, 0x000fe200078e00ffULL,
0x0000006f0800720cULL, 0x000fc80003f06070ULL, 0xfffffff0170b7812ULL, 0x000fca00078ec0ffULL,
0x0000008000247824ULL, 0x000fca00078e020bULL, 0x00f40000240c7984ULL, 0x0002a20000000c00ULL,
0x000014f000008947ULL, 0x000fea0003800000ULL, 0x00005a0000127b06ULL, 0x000ee20000209000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fe20003f85070ULL,
0x0000000206397824ULL, 0x000fe200078e00ffULL, 0x00005a00ff147a12ULL, 0x000fc800078e33ffULL,
0x0000000639397812ULL, 0x000fca00078ec0ffULL, 0x00000001393b7824ULL, 0x000fe200078e0265ULL,
0x0000001200127308ULL, 0x008ee40000001000ULL, 0x0ffffffe120b7810ULL, 0x008fcc0007ffe0ffULL,
0x0000000b000b7305ULL, 0x000ee4000021f000ULL, 0x000000ffff117224ULL, 0x008fc800078e0a0bULL,
0x00005a0011117a24ULL, 0x000fc800078e02ffULL, 0x000000110b137227ULL, 0x000fe200078e000aULL,
0x00000079060a7211ULL, 0x000fca00078ff0ffULL, 0x0000000a13107227ULL, 0x000fc800078e00ffULL,
0x000000ffff117224ULL, 0x000fc800078e0a10ULL, 0x00005a0011117a24ULL, 0x000fe200078e020aULL,
0x000000080a0a7810ULL, 0x000fc80007ffe0ffULL, 0x00005a0011007a0cULL, 0x000fe20003f06070ULL,
0x0000000a13137227ULL, 0x000fc800078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc800078e0a13ULL,
0x00005a000b127a24ULL, 0x000fe400078e020aULL, 0x00000100080b7824ULL, 0x000fe400078e0271ULL,
0x80005a0011110a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0012007a0cULL, 0x000fe40003f46070ULL,
0x00005a0011007a0cULL, 0x000fe40003f26070ULL, 0x0000000b02167217ULL, 0x000fc40007800000ULL,
0x0000000110100810ULL, 0x000fc60007ffe0ffULL, 0x0000000116167824ULL, 0x000fe400078e0a0bULL,
0x000000016b0b7824ULL, 0x000fe400078e0239ULL, 0x80005a0012122a10ULL, 0x000fe40007ffe0ffULL,
0x000000010b0a7824ULL, 0x040fe200078e0a16ULL, 0x0000000110101810ULL, 0x000fe40007ffe0ffULL,
0x000000160b00720cULL, 0x000fe40003f66070ULL, 0x0000001014107207ULL, 0x000fc40006000000ULL,
0x00005a0012007a0cULL, 0x000fe40003f06070ULL, 0x0000000a690b7217ULL, 0x000fe20003800000ULL,
0x000000013b0a7824ULL, 0x000fe200078e0a16ULL, 0x0000001069517217ULL, 0x000fe40003800000ULL,
0x00000004ff0b7819ULL, 0x000fe4000001160bULL, 0x0000000113132810ULL, 0x000fe20007ffe0ffULL,
0x000000516c517224ULL, 0x000fe200078e02ffULL, 0x000000ff0b127207ULL, 0x000fc40001800000ULL,
0x000000163b00720cULL, 0x000fe40003f26070ULL, 0x0000000a690a7217ULL, 0x000fe20003800000ULL,
0x00000001510b7824ULL, 0x000fe200078e0212ULL, 0x0000000113130810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0a4e7207ULL, 0x000fe20000800000ULL, 0x000000020b0a7825ULL, 0x000fe200078e003eULL,
0x0000001314147207ULL, 0x000fe40006000000ULL, 0x00000010393a7812ULL, 0x000fc400078efcffULL,
0x000000514e117211ULL, 0x000fe200078fe0ffULL, 0x000000080a4f7981ULL, 0x0046a2000c1e9500ULL,
0x0000001469537217ULL, 0x000fc60003800000ULL, 0x0000000211107825ULL, 0x000fc800078e003eULL,
0x000000016b0b7824ULL, 0x008fe200078e023aULL, 0x0000000810527981ULL, 0x0006a2000c1e9500ULL,
0x000000536c537224ULL, 0x000fe400078e02ffULL, 0x000000010b0a7824ULL, 0x000fe400078e0a16ULL,
0x0000000112137824ULL, 0x000fe200078e0253ULL, 0x00000020393c7812ULL, 0x000fe200078efcffULL,
0x000000013a3d7824ULL, 0x000fe200078e0265ULL, 0x0000000a69107217ULL, 0x008fe20003800000ULL,
0x0000000213127825ULL, 0x000fe200078e003eULL, 0x000000160b00720cULL, 0x000fc40003f26070ULL,
0x00000004ff107819ULL, 0x000fe20000011610ULL, 0x000000013d0a7824ULL, 0x000fe200078e0a16ULL,
0x00000008124c7981ULL, 0x0006a2000c1e9500ULL, 0x000000016b457824ULL, 0x000fe200078e023cULL,
0x000000163d00720cULL, 0x000fe40003f06070ULL, 0x0000000a690a7217ULL, 0x000fe20003800000ULL,
0x0000000145467824ULL, 0x000fe200078e0a16ULL, 0x000000ff10127207ULL, 0x008fe40000800000ULL,
0x000000534e157211ULL, 0x000fc600078fe0ffULL, 0x00000001510b7824ULL, 0x000fe200078e0212ULL,
0x000000ff0a407207ULL, 0x000fe40000000000ULL, 0x0000004669467217ULL, 0x000fe20003800000ULL,
0x000000020b0a7825ULL, 0x000fe200078e003eULL, 0x000000164500720cULL, 0x000fe40003f26070ULL,
0x00000004ff467819ULL, 0x000fe20000011646ULL, 0x0000000215147825ULL, 0x000fe200078e003eULL,
0x000000080a417981ULL, 0x0006a6000c1e9500ULL, 0x000000013c437824ULL, 0x000fe200078e0265ULL,
0x0000000814577981ULL, 0x0002a2000c1e9500ULL, 0x000000ff46487207ULL, 0x000fc40000800000ULL,
0x0000003039457812ULL, 0x000fe200078efcffULL, 0x00000001430a7824ULL, 0x048fe200078e0a16ULL,
0x0000005140117211ULL, 0x000fe200078fe0ffULL, 0x0000000112137824ULL, 0x000fe200078e0253ULL,
0x000000164300720cULL, 0x000fe40003f06070ULL, 0x0000005340157211ULL, 0x002fe200078fe0ffULL,
0x00000001510b7824ULL, 0x000fe200078e0248ULL, 0x0000000a690a7217ULL, 0x000fe20003800000ULL,
0x000000016b557824ULL, 0x000fe400078e0245ULL, 0x0000000211107825ULL, 0x000fe200078e003eULL,
0x000000ff0a4a7207ULL, 0x000fc60000000000ULL, 0x0000000213127825ULL, 0x100fe200078e003eULL,
0x0000000810427981ULL, 0x0002e6000c1e9500ULL, 0x0000000215147825ULL, 0x100fe200078e003eULL,
0x0000000812447981ULL, 0x0002e6000c1e9500ULL, 0x000000020b0a7825ULL, 0x000fe200078e003eULL,
0x0000000814477981ULL, 0x0002e6000c1e9500ULL, 0x0000000155507824ULL, 0x000fe200078e0a16ULL,
0x000000080a467981ULL, 0x0002e2000c1e9500ULL, 0x00000001454b7824ULL, 0x000fe200078e0265ULL,
0x000000514a117211ULL, 0x002fc400078fe0ffULL, 0x0000005069507217ULL, 0x000fe20003800000ULL,
0x0000000148137824ULL, 0x000fe200078e0253ULL, 0x000000534a157211ULL, 0x000fe200078fe0ffULL,
0x000000014b0a7824ULL, 0x000fe200078e0a16ULL, 0x000000165500720cULL, 0x080fe40003f26070ULL,
0x00000004ff507819ULL, 0x000fe20000011650ULL, 0x0000000211107825ULL, 0x100fe200078e003eULL,
0x000000164b00720cULL, 0x000fe40003f06070ULL, 0x0000000a690a7217ULL, 0x000fe20003800000ULL,
0x0000000213127825ULL, 0x100fe200078e003eULL, 0x000000ff50547207ULL, 0x000fe20000800000ULL,
0x0000000810497981ULL, 0x0002e4000c1e9500ULL, 0x0000000215147825ULL, 0x000fe200078e003eULL,
0x000000ff0a507207ULL, 0x000fe20000000000ULL, 0x0000000812487981ULL, 0x0002e8000c1e9500ULL,
0x00000008144d7981ULL, 0x0002e2000c1e9500ULL, 0x00000001510b7824ULL, 0x000fe200078e0254ULL,
0x0000005150117211ULL, 0x002fc600078fe0ffULL, 0x000000020b0a7825ULL, 0x000fc800078e003eULL,
0x0000000211107825ULL, 0x000fe400078e003eULL, 0x000000080a0a7981ULL, 0x0002e2000c1e9500ULL,
0x0000005350137211ULL, 0x000fc600078fe0ffULL, 0x0000000810117981ULL, 0x0002e2000c1e9500ULL,
0x0000000154157824ULL, 0x000fe400078e0253ULL, 0x0000000213127825ULL, 0x000fc800078e003eULL,
0x0000000215147825ULL, 0x000fe400078e003eULL, 0x0000000812127981ULL, 0x0002e8000c1e9500ULL,
0x0000000814157981ULL, 0x0002e2000c1e9500ULL, 0xfffffff04e537812ULL, 0x000fe200078ec0ffULL,
0x00000001ff4e7424ULL, 0x000fc800078e00ffULL, 0x0000000116547824ULL, 0x000fc800078e0253ULL,
0x000000013b597824ULL, 0x000fe200078e0a54ULL, 0x00000009390b7812ULL, 0x002fc800078efcffULL,
0x000000594e597219ULL, 0x000fe200000006ffULL, 0x000000010b137824ULL, 0x000fe200078e0265ULL,
0xfffffff040407812ULL, 0x000fc600078ec0ffULL, 0x00000001135f7824ULL, 0x000fe200078e0a54ULL,
0x0000001139757812ULL, 0x040fe400078efcffULL, 0x0000000139517812ULL, 0x040fe400078efcffULL,
0x0000001839737812ULL, 0x040fe400078efcffULL, 0x0000005f4e5f7219ULL, 0x000fe200000006ffULL,
0x0000000116407824ULL, 0x000fe200078e0240ULL, 0x0000001939677812ULL, 0x000fe400078efcffULL,
0xfffffff04a4a7812ULL, 0x000fe200078ec0ffULL, 0x00000001757d7824ULL, 0x000fc400078e0265ULL,
0x0000000151557824ULL, 0x100fe400078e0265ULL, 0x00000001737b7824ULL, 0x100fe400078e0265ULL,
0x0000000167777824ULL, 0x000fe400078e0265ULL, 0x0000000116647824ULL, 0x000fe400078e024aULL,
0x000000013d147824ULL, 0x100fe400078e0a40ULL, 0x000000017d4a7824ULL, 0x000fc400078e0a40ULL,
0x00000001555b7824ULL, 0x000fe400078e0a54ULL, 0x000000017b587824ULL, 0x100fe400078e0a40ULL,
0x0000000177727824ULL, 0x000fe200078e0a40ULL, 0x000000144e407219ULL, 0x040fe400000006ffULL,
0x0000004a4e147219ULL, 0x040fe400000006ffULL, 0x0000005b4e5b7219ULL, 0x040fe400000006ffULL,
0x000000584e4a7219ULL, 0x000fe200000006ffULL, 0x00000001435c7824ULL, 0x000fe200078e0a64ULL,
0x0000002139617812ULL, 0x000fc400078efcffULL, 0xfffffff050507812ULL, 0x000fe400078ec0ffULL,
0x000000724e587219ULL, 0x040fe400000006ffULL, 0x0000005c4e5c7219ULL, 0x000fe200000006ffULL,
0x0000000161637824ULL, 0x000fc800078e0265ULL, 0x00000001635e7824ULL, 0x000fca00078e0a64ULL,
0x0000005e4e5e7219ULL, 0x000fe400000006ffULL, 0x0000541052527816ULL, 0x004fe4000000004fULL,
0x00000008394f7812ULL, 0x000fe400078efcffULL, 0x0000005259ff7212ULL, 0x000fc6000780c0ffULL,
0x000000014f537824ULL, 0x000fe200078e0265ULL, 0x000000163b00720cULL, 0x000fc60000701470ULL,
0x00000001535d7824ULL, 0x000fe200078e0a54ULL, 0x000000163900720cULL, 0x000fc800007a1070ULL,
0x0000005d4e5d7219ULL, 0x000fe400000006ffULL, 0xff80000019197808ULL, 0x000fe40002800000ULL,
0x000000525bff7212ULL, 0x080fe4000782c0ffULL, 0x000000525dff7212ULL, 0x080fe4000786c0ffULL,
0x000000525fff7212ULL, 0x000fe4000788c0ffULL, 0x00005410574c7816ULL, 0x000fc8000000004cULL,
0x0000004c59ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004c5dff7212ULL, 0x080fe400078cc0ffULL,
0x0000004c5fff7212ULL, 0x000fe400078ac0ffULL, 0x000000163b00720cULL, 0x080fe40001741470ULL,
0x000000165300720cULL, 0x080fe400037c1470ULL, 0x000000161300720cULL, 0x000fc40002fa1470ULL,
0x000000163900720cULL, 0x080fe40001741070ULL, 0x000000164f00720cULL, 0x080fe400037c1070ULL,
0x000000160b00720cULL, 0x000fe40002fa1070ULL, 0x0000541042417816ULL, 0x008fe40000000041ULL,
0xff80000022227808ULL, 0x000fe40001000000ULL, 0xff80000023237808ULL, 0x000fc40003000000ULL,
0x0000541047477816ULL, 0x000fe40000000044ULL, 0xff80000027277808ULL, 0x000fe40002800000ULL,
0x0000004c5bff7212ULL, 0x000fe4000780c0ffULL, 0x0000004140ff7212ULL, 0x040fe4000784c0ffULL,
0x0000004740ff7212ULL, 0x080fe400078cc0ffULL, 0x000000474aff7212ULL, 0x000fc400078ac0ffULL,
0x000000165500720cULL, 0x0c0fe40000f21470ULL, 0x000000165500720cULL, 0x080fe40000701470ULL,
0x000000165300720cULL, 0x080fe40001f61470ULL, 0x000000161300720cULL, 0x080fe40002781470ULL,
0x000000163d00720cULL, 0x0c0fe40001741470ULL, 0x000000163d00720cULL, 0x000fc400037c1470ULL,
0x000000167b00720cULL, 0x080fe40002fa1470ULL, 0x00000028395f7812ULL, 0x040fe400078efcffULL,
0x00000029395d7812ULL, 0x000fe400078efcffULL, 0x000000165100720cULL, 0x0c0fe40000f21070ULL,
0x000000165100720cULL, 0x080fe40000701070ULL, 0x000000164f00720cULL, 0x000fc40001f61070ULL,
0x000000160b00720cULL, 0x080fe40002781070ULL, 0x000000163a00720cULL, 0x0c0fe40001741070ULL,
0x000000163a00720cULL, 0x080fe400037c1070ULL, 0x000000167300720cULL, 0x000fe40002fa1070ULL,
0x0000541049497816ULL, 0x000fe40000000046ULL, 0x000054104d4d7816ULL, 0x000fe20000000048ULL,
0x000000015f107824ULL, 0x100fe200078e0265ULL, 0xff8000002c2c7808ULL, 0x000fe20000800000ULL,
0x000000015d567824ULL, 0x000fe200078e0265ULL, 0xff8000001a1a7808ULL, 0x000fe20000000000ULL,
0x00000001164c7824ULL, 0x000fe200078e0250ULL, 0xff8000002d2d7808ULL, 0x000fc40001800000ULL,
0xff8000001b1b7808ULL, 0x000fe40002000000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff80000026267808ULL, 0x000fe40003000000ULL, 0xff80000028287808ULL, 0x000fe40002800000ULL,
0x0000004114ff7212ULL, 0x080fe4000782c0ffULL, 0x000000414aff7212ULL, 0x000fc4000780c0ffULL,
0x0000004158ff7212ULL, 0x000fe4000786c0ffULL, 0x0000004714ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004758ff7212ULL, 0x000fe4000784c0ffULL, 0x000000495cff7212ULL, 0x040fe400078cc0ffULL,
0x0000004d5cff7212ULL, 0x000fe200078ac0ffULL, 0x00000001106a7824ULL, 0x100fe200078e0a64ULL,
0x000000167d00720cULL, 0x0c0fe20000f21470ULL, 0x0000000156647824ULL, 0x000fe200078e0a64ULL,
0x000000167d00720cULL, 0x080fe20002781470ULL, 0x000000014b627824ULL, 0x000fe200078e0a4cULL,
0x000000167b00720cULL, 0x000fc40000701470ULL, 0x000000167700720cULL, 0x0c0fe40001f61470ULL,
0x000000167700720cULL, 0x080fe40001741470ULL, 0x000000164300720cULL, 0x0c0fe400037c1470ULL,
0x000000164300720cULL, 0x000fe40002fa1470ULL, 0x00000031395b7812ULL, 0x040fe400078efcffULL,
0x0000003839597812ULL, 0x000fc400078efcffULL, 0x0000003939577812ULL, 0x000fe400078efcffULL,
0x000000167500720cULL, 0x0c0fe40000f21070ULL, 0x000000167500720cULL, 0x080fe40002781070ULL,
0x000000167300720cULL, 0x080fe40000701070ULL, 0x000000166700720cULL, 0x0c0fe40001f61070ULL,
0x000000166700720cULL, 0x000fc40001741070ULL, 0x000000163c00720cULL, 0x0c0fe400037c1070ULL,
0x000000163c00720cULL, 0x000fe40002fa1070ULL, 0x0000006a4e6a7219ULL, 0x040fe400000006ffULL,
0x000000644e647219ULL, 0x040fe400000006ffULL, 0x000000624e627219ULL, 0x000fe400000006ffULL,
0x0000541011117816ULL, 0x000fe2000000000aULL, 0x000000015b547824ULL, 0x100fe200078e0265ULL,
0xff8000002e2e7808ULL, 0x000fe20000800000ULL, 0x0000000159527824ULL, 0x100fe200078e0265ULL,
0xff80000025257808ULL, 0x000fe20002000000ULL, 0x0000000157507824ULL, 0x000fe200078e0265ULL,
0xff8000002f2f7808ULL, 0x000fc40000000000ULL, 0xff80000038387808ULL, 0x000fe40001800000ULL,
0xff80000037377808ULL, 0x000fe40001000000ULL, 0xff80000036367808ULL, 0x000fe40003000000ULL,
0xff80000029297808ULL, 0x000fe40002800000ULL, 0x000000495eff7212ULL, 0x080fe4000782c0ffULL,
0x000000496aff7212ULL, 0x000fc4000788c0ffULL, 0x0000004964ff7212ULL, 0x000fe4000780c0ffULL,
0x0000004d5eff7212ULL, 0x080fe4000786c0ffULL, 0x0000004d6aff7212ULL, 0x080fe4000784c0ffULL,
0x0000004d64ff7212ULL, 0x000fe400078cc0ffULL, 0x0000001162ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000154607824ULL, 0x100fe200078e0a4cULL, 0x000000166300720cULL, 0x0c0fe20000f21470ULL,
0x00000001525a7824ULL, 0x100fe200078e0a4cULL, 0x000000166300720cULL, 0x080fe20001f61470ULL,
0x00000001504c7824ULL, 0x000fe200078e0a4cULL, 0x000000161000720cULL, 0x000fc40002781470ULL,
0x000000161000720cULL, 0x080fe40001741470ULL, 0x000000165600720cULL, 0x0c0fe40000701470ULL,
0x000000165600720cULL, 0x080fe400037c1470ULL, 0x000000164b00720cULL, 0x080fe40002fa1470ULL,
0x000000166100720cULL, 0x0c0fe40000f21070ULL, 0x000000166100720cULL, 0x000fc40001f61070ULL,
0x000000165f00720cULL, 0x0c0fe40002781070ULL, 0x000000165f00720cULL, 0x080fe40001741070ULL,
0x000000165d00720cULL, 0x0c0fe40000701070ULL, 0x000000165d00720cULL, 0x080fe400037c1070ULL,
0x000000164500720cULL, 0x000fe40002fa1070ULL, 0x000000604e607219ULL, 0x000fc400000006ffULL,
0x0000005a4e5a7219ULL, 0x040fe400000006ffULL, 0x0000004c4e4c7219ULL, 0x000fe400000006ffULL,
0x0000541012157816ULL, 0x000fe40000000015ULL, 0xff80000030307808ULL, 0x000fe40000800000ULL,
0xff80000018187808ULL, 0x000fe40001800000ULL, 0xff80000031317808ULL, 0x000fc40002000000ULL,
0xff80000020207808ULL, 0x000fe40001000000ULL, 0xff80000035357808ULL, 0x000fe40000000000ULL,
0xff80000021217808ULL, 0x000fe40003000000ULL, 0xff80000034347808ULL, 0x000fe40002800000ULL,
0x0000001160ff7212ULL, 0x080fe4000782c0ffULL, 0x000000115aff7212ULL, 0x000fc4000786c0ffULL,
0x000000114cff7212ULL, 0x000fe4000788c0ffULL, 0x0000001562ff7212ULL, 0x080fe4000784c0ffULL,
0x0000001560ff7212ULL, 0x080fe4000780c0ffULL, 0x000000155aff7212ULL, 0x080fe400078cc0ffULL,
0x000000154cff7212ULL, 0x000fe400078ac0ffULL, 0x000000164b00720cULL, 0x000fc40001741470ULL,
0x000000165400720cULL, 0x0c0fe40000f21470ULL, 0x000000165400720cULL, 0x080fe40000701470ULL,
0x000000165200720cULL, 0x0c0fe40001f61470ULL, 0x000000165200720cULL, 0x080fe400037c1470ULL,
0x000000165000720cULL, 0x0c0fe40002781470ULL, 0x000000165000720cULL, 0x000fc40002fa1470ULL,
0x000000164500720cULL, 0x080fe40001741070ULL, 0x000000165b00720cULL, 0x0c0fe40000f21070ULL,
0x000000165b00720cULL, 0x080fe40000701070ULL, 0x000000165900720cULL, 0x0c0fe40001f61070ULL,
0x000000165900720cULL, 0x080fe400037c1070ULL, 0x000000165700720cULL, 0x000fc40002781070ULL,
0x000000165700720cULL, 0x000fe40002fa1070ULL, 0xff80000032327808ULL, 0x000fe40000800000ULL,
0xff8000002a2a7808ULL, 0x000fe40001800000ULL, 0xff8000002b2b7808ULL, 0x000fe40002000000ULL,
0xff8000001c1c7808ULL, 0x000fe40001000000ULL, 0xff8000001d1d7808ULL, 0x000fc40000000000ULL,
0xff8000001e1e7808ULL, 0x000fe40003000000ULL, 0xff8000001f1f7808ULL, 0x000fc40002800000ULL,
0x000000190c00720bULL, 0x004fe20003f1e000ULL, 0x0000001fff397424ULL, 0x000fe200078e00ffULL,
0x000000220d00720bULL, 0x000fe20003f3e000ULL, 0xffffffffff3a7424ULL, 0x000fe200078e00ffULL,
0x0000000c190b7208ULL, 0x000fe40004000000ULL, 0x0000000d220d7208ULL, 0x000fe40004800000ULL,
0x0000002c0b00720bULL, 0x000fc40003f1e000ULL, 0x0000001a0d00720bULL, 0x000fe40003f3e000ULL,
0x0000000b2c0a7208ULL, 0x000fe40004000000ULL, 0x0000000d1a0c7208ULL, 0x000fe40004800000ULL,
0x0000002d0a00720bULL, 0x000fe40003f1e000ULL, 0x000000230c00720bULL, 0x000fe40003f3e000ULL,
0x0000000a2d0a7208ULL, 0x000fc40004000000ULL, 0x0000000c230c7208ULL, 0x000fe40004800000ULL,
0x0000001b0a00720bULL, 0x000fe40003f1e000ULL, 0x000000270c00720bULL, 0x000fe40003f3e000ULL,
0x0000000a1b0a7208ULL, 0x000fe40004000000ULL, 0x0000000c270b7208ULL, 0x000fe40004800000ULL,
0x000000330a00720bULL, 0x000fc40003f1e000ULL, 0x000000260b00720bULL, 0x000fe40003f3e000ULL,
0x0000000a330d7208ULL, 0x000fe40004000000ULL, 0x0000000b260a7208ULL, 0x000fe40004800000ULL,
0x0000002e0d00720bULL, 0x000fe40003f1e000ULL, 0x000000250a00720bULL, 0x000fe40003f3e000ULL,
0x0000000d2e0c7208ULL, 0x000fc40004000000ULL, 0x0000000a250b7208ULL, 0x000fe40004800000ULL,
0x0000002f0c00720bULL, 0x000fe40003f1e000ULL, 0x000000280b00720bULL, 0x000fe40003f3e000ULL,
0x0000000c2f0d7208ULL, 0x000fe40004000000ULL, 0x0000000b280a7208ULL, 0x000fe40004800000ULL,
0x000000380d00720bULL, 0x000fc40003f1e000ULL, 0x000000370a00720bULL, 0x000fe40003f3e000ULL,
0x0000000d380d7208ULL, 0x000fe40004000000ULL, 0x0000000a370a7208ULL, 0x000fe40004800000ULL,
0x000000360d00720bULL, 0x000fe40003f1e000ULL, 0x000000290a00720bULL, 0x000fe40003f3e000ULL,
0x0000000d360d7208ULL, 0x000fc40004000000ULL, 0x0000000a290b7208ULL, 0x000fe40004800000ULL,
0x000000300d00720bULL, 0x000fe40003f1e000ULL, 0x000000180b00720bULL, 0x000fe40003f3e000ULL,
0x0000000d300a7208ULL, 0x000fe40004000000ULL, 0x0000000b180b7208ULL, 0x000fe40004800000ULL,
0x000000310a00720bULL, 0x000fc40003f1e000ULL, 0x000000200b00720bULL, 0x000fe40003f3e000ULL,
0x0000000a310a7208ULL, 0x000fe40004000000ULL, 0x0000000b200c7208ULL, 0x000fe40004800000ULL,
0x000000350a00720bULL, 0x000fe40003f1e000ULL, 0x000000210c00720bULL, 0x000fe40003f3e000ULL,
0x0000000a350b7208ULL, 0x000fc40004000000ULL, 0x0000000c210d7208ULL, 0x000fe40004800000ULL,
0x000000340b00720bULL, 0x000fe40003f1e000ULL, 0x0000001c0d00720bULL, 0x000fe40003f3e000ULL,
0x0000000b340b7208ULL, 0x000fe40004000000ULL, 0x0000000d1c0a7208ULL, 0x000fe40004800000ULL,
0x000000320b00720bULL, 0x000fc40003f1e000ULL, 0x0000001d0a00720bULL, 0x000fe40003f3e000ULL,
0x0000000b320b7208ULL, 0x000fe40004000000ULL, 0x0000000a1d0d7208ULL, 0x000fe40004800000ULL,
0x0000002a0b00720bULL, 0x000fe40003f1e000ULL, 0x0000001e0d00720bULL, 0x000fe40003f3e000ULL,
0x0000000b2a0a7208ULL, 0x000fc40004000000ULL, 0x0000000d1e0c7208ULL, 0x000fe40004800000ULL,
0x0000002b0a00720bULL, 0x000fe40003f1e000ULL, 0x0000001f0c00720bULL, 0x000fe40003f3e000ULL,
0x0000000a2b107208ULL, 0x000fe40004000000ULL, 0x0000000c1f127208ULL, 0x000fe20004800000ULL,
0x000014227f007947ULL, 0x000fec000b800000ULL, 0x0c401f00100a7f89ULL, 0x0004e400000e0000ULL,
0x0000000a1000720bULL, 0x008fc80003f1e000ULL, 0x000000100a137208ULL, 0x000fe20004000000ULL,
0x000014327f007947ULL, 0x000fea000b800000ULL, 0x0c401f00120a7f89ULL, 0x000ee800000e0000ULL,
0x0c401f000e0b7f89ULL, 0x000e6800000e0000ULL, 0x0c401f000f107f89ULL, 0x006e6800000e0000ULL,
0x0c201f0013147f89ULL, 0x000ea200000e0000ULL, 0x0000000a1200720bULL, 0x008fc40003f1e000ULL,
0x0000000b0e00720bULL, 0x000fe40003f3e000ULL, 0x000000120a0c7208ULL, 0x000fe40004000000ULL,
0x0000000e0b0d7208ULL, 0x000fe40004800000ULL, 0x000000100f00720bULL, 0x002fe20003f1e000ULL,
0x0c201f000c157f89ULL, 0x000e6600000e0000ULL, 0x0000000f100a7208ULL, 0x000fe20004000000ULL,
0x0c201f000d167f89ULL, 0x000ee200000e0000ULL, 0x000000141300720bULL, 0x004fc60003f1e000ULL,
0x0c201f000a0b7f89ULL, 0x0004a200000e0000ULL, 0x0000001314147208ULL, 0x000fe40004000000ULL,
0x000000150c00720bULL, 0x002fe40003f3e000ULL, 0x000000160d00720bULL, 0x008fe40003f5e000ULL,
0x0000000c15157208ULL, 0x000fe40004800000ULL, 0x0000000d16167208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b140c7820ULL, 0x004fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000306ff7812ULL, 0x000fc4000780c0ffULL, 0x3fb8aa3b2f137823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b312f7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b15317820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b330f7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010831ULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b30337823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b38387823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b35307823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b2b2b7823ULL, 0x000fe2000001080cULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010831ULL,
0x0000002c000e7308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b21217823ULL, 0x000fe20000010831ULL,
0x0000000b0a00720bULL, 0x000fc40003f3e000ULL, 0x0000002d000d7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b362c7823ULL, 0x004fce000001080cULL, 0x0000001b00107308ULL, 0x002e620000000800ULL,
0x3fb8aa3b342d7823ULL, 0x000fce000001080cULL, 0x0000000f00117308ULL, 0x000ff00000000800ULL,
0x0000002e00127308ULL, 0x0004700000000800ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b322e7823ULL, 0x004fe2000001080cULL, 0x000000190e0c723eULL, 0x008fc400000000ffULL,
0x0000000d100e723eULL, 0x002fc800000000ffULL, 0x0000001a000f7308ULL, 0x000e620000000800ULL,
0x000000111210723eULL, 0x000fce00000000ffULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000002700327308ULL, 0x0004e20000000800ULL, 0x000000220f0d723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b18227823ULL, 0x000fcc0000010831ULL, 0x0000002600347308ULL, 0x0003e20000000800ULL,
0x3c003c00ff277424ULL, 0x004fe200078e00ffULL, 0x00000023320f723eULL, 0x008fe200000000ffULL,
0x3c003c00ff267424ULL, 0x002fca00078e00ffULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c237823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b1e327823ULL, 0x000fe20000010831ULL,
0x000000260c18723cULL, 0x000f6a00000018ffULL, 0x0000003800387308ULL, 0x000e700000000800ULL,
0x0000002500257308ULL, 0x000eb00000000800ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x000000133812723eULL, 0x002fc400000000ffULL, 0x00000002ff387819ULL, 0x000fc80000011606ULL,
0x0000000238367810ULL, 0x040fe20007ffe0ffULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x000000342511723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b1d257823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b1f317823ULL, 0x000fe20000010831ULL, 0x0000000838397824ULL, 0x040fe200078e00ffULL,
0x0000000138347810ULL, 0x040fe20007ffe0ffULL, 0x0000000838357824ULL, 0x040fe200078e00ffULL,
0x00000008383d7810ULL, 0x000fe20007ffe0ffULL, 0x0000002c002c7308ULL, 0x000fe60000000800ULL,
0xfffffff835357812ULL, 0x000fc400078ee234ULL, 0x000000283713723eULL, 0x002fc600000000ffULL,
0x0000003300337308ULL, 0x000e620000000800ULL, 0x0000000838377824ULL, 0x000fc600078e00ffULL,
0x00000026101c723cULL, 0x020b640000001818ULL, 0xfffffff837377812ULL, 0x000fe400078ee236ULL,
0x0000002f002f7308ULL, 0x000fe60000000800ULL, 0x00000008381a7824ULL, 0x060fe200078e00ffULL,
0x0000000338187810ULL, 0x000fc80007ffe0ffULL, 0x0000003000307308ULL, 0x000ea20000000800ULL,
0x0000000438197810ULL, 0x000fe40007ffe0ffULL, 0xfffffff839397812ULL, 0x000fe400078ee218ULL,
0xfffffff81a3b7812ULL, 0x000fe400078ee219ULL, 0x0000002c3318723eULL, 0x002fe200000000ffULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x00000008382c7824ULL, 0x040fe400078e00ffULL,
0x0000000838337824ULL, 0x000fca00078e00ffULL, 0x0000002200227308ULL, 0x000e620000000800ULL,
0x0000002f301a723eULL, 0x004fe200000000ffULL, 0x000000083d307824ULL, 0x000fca00078e00ffULL,
0xfffffff8303d7812ULL, 0x000fe200078ee23dULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000ea20000000800ULL, 0x000000292219723eULL, 0x002fe200000000ffULL,
0x0000000838297824ULL, 0x040fe200078e00ffULL, 0xffffffff38227810ULL, 0x000fc80007ffe0ffULL,
0xfffffff833337812ULL, 0x000fe200078ee222ULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x00000020211b723eULL, 0x004fce00000000ffULL, 0x0000002500287308ULL, 0x0002a20000000800ULL,
0x0000000638217810ULL, 0x040fe40007ffe0ffULL, 0x0000000538207810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82c2f7812ULL, 0x000fe200078ee221ULL, 0x00000026181c723cULL, 0x000f62000000181cULL,
0xfffffff829297812ULL, 0x000fe200078ee220ULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x0000000838257824ULL, 0x002fca00078e00ffULL, 0xfffffff825257812ULL, 0x000fe400078ee238ULL,
0x0000002e002e7308ULL, 0x000e620000000800ULL, 0x000000232821723eULL, 0x004fe400000000ffULL,
0x0000000c17287812ULL, 0x000fe400078ec0ffULL, 0x0000000a0b177208ULL, 0x000fc60004800000ULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000002b002b7308ULL, 0x000ea20000000800ULL,
0x0000002d2e20723eULL, 0x002fce00000000ffULL, 0x0000003200327308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000e620000000800ULL, 0x0000002a2b22723eULL, 0x004fe400000000ffULL,
0x00009000002a7811ULL, 0x000fca00078e58ffULL, 0x0000001025257824ULL, 0x100fe400078e022aULL,
0x0000001035357824ULL, 0x100fe400078e022aULL, 0x0000001037377824ULL, 0x100fe400078e022aULL,
0x0000001039397824ULL, 0x100fe200078e022aULL, 0x000000323123723eULL, 0x002fe200000000ffULL,
0x000000103b3b7824ULL, 0x000fe400078e022aULL, 0x0000000125257824ULL, 0x000fc400078e0228ULL,
0x0000001029297824ULL, 0x100fe400078e022aULL, 0x00000026201c723cULL, 0x020f62000000181cULL,
0x0000000128357824ULL, 0x040fe200078e0235ULL, 0x0000000c25007388ULL, 0x0003e20000000800ULL,
0x000000102f2f7824ULL, 0x100fe400078e022aULL, 0x0000000128377824ULL, 0x040fe200078e0237ULL,
0x0000000e35007388ULL, 0x0003e20000000800ULL, 0x0000001033337824ULL, 0x100fe400078e022aULL,
0x0000000128397824ULL, 0x000fe200078e0239ULL, 0x0000001037007388ULL, 0x0003e20000000800ULL,
0x000000103d3d7824ULL, 0x000fc400078e022aULL, 0x00000001283b7824ULL, 0x040fe200078e023bULL,
0x0000001239007388ULL, 0x0003e20000000800ULL, 0x0000000128297824ULL, 0x040fe400078e0229ULL,
0x00000001282f7824ULL, 0x040fe200078e022fULL, 0x000000183b007388ULL, 0x0003e20000000800ULL,
0x0000000128337824ULL, 0x040fe400078e0233ULL, 0x0000000128287824ULL, 0x000fe200078e023dULL,
0x0000001a29007388ULL, 0x0003e40000000800ULL, 0x000000ffff1d7224ULL, 0x020fc400078e001eULL,
0x000000202f007388ULL, 0x0003e80000000800ULL, 0x0000002233007388ULL, 0x0003e80000000800ULL,
0x0000000d28007388ULL, 0x0003e80000000800ULL, 0x0004000f35007388ULL, 0x0003e80000000800ULL,
0x0004001137007388ULL, 0x0003e80000000800ULL, 0x0004001339007388ULL, 0x0003e80000000800ULL,
0x000400193b007388ULL, 0x0003e80000000800ULL, 0x0004001b29007388ULL, 0x0003e80000000800ULL,
0x000400212f007388ULL, 0x0003e80000000800ULL, 0x0004002333007388ULL, 0x0003e80000000800ULL,
0x00f0001424008388ULL, 0x0003e80000000c00ULL, 0x00f2001c24008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000074ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080074ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100074ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000108087810ULL, 0x000fe20007ffe0ffULL,
0x0000180074ff7f8cULL, 0x0003e6000c80043fULL, 0x000000030800720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb57000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff107807ULL, 0x008fe40004000000ULL,
0x000126e000147802ULL, 0x000fc40000000f00ULL, 0x00000bc000007944ULL, 0x014fea0003c00000ULL,
0xffff013000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40005000000ULL,
0x0001272000147802ULL, 0x000fc40000000f00ULL, 0x00000b8000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0010ULL, 0xffff019000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0037ULL, 0x0001277000157802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x014fea0003c00000ULL, 0xffff028000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0037ULL, 0x000127b000157802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x014fea0003c00000ULL, 0xffff03a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000fULL, 0x0001280000157802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0012ULL, 0x00000a5000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0014ULL, 0xffff07c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000fULL, 0x0001285000157802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0014ULL,
0xffff07a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x008fe40004000000ULL,
0x000128a000147802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x004fea0003c00000ULL,
0xffff270000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40005000000ULL,
0x000128e000147802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0010ULL, 0xffff275000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e003fULL, 0x0001293000157802ULL, 0x000fc40000000f00ULL,
0x0000092000007944ULL, 0x004fea0003c00000ULL, 0xffff284000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e003fULL, 0x0001297000157802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x004fea0003c00000ULL, 0xffff296000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000bULL, 0x000129c000157802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0034ULL, 0x0000089000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0014ULL, 0xffff2d9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000bULL, 0x00012a1000157802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0014ULL,
0xffff2d7000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x004fe40004000000ULL,
0x00012a6000147802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x018fea0003c00000ULL,
0xffff4b0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40005000000ULL,
0x00012aa000147802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0010ULL, 0xffff4b5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e003bULL, 0x00012af000157802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x018fea0003c00000ULL, 0xffff4c4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e003bULL, 0x00012b3000157802ULL, 0x000fc40000000f00ULL,
0x0000072000007944ULL, 0x018fea0003c00000ULL, 0xffff4d6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000eULL, 0x00012b8000157802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0013ULL, 0x000006d000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0014ULL, 0xffff519000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000eULL, 0x00012bd000157802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0014ULL,
0xffff517000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x004fe40004000000ULL,
0x00012c2000147802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x018fea0003c00000ULL,
0xffff6f6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40005000000ULL,
0x00012c6000147802ULL, 0x000fc40000000f00ULL, 0x0000064000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e0010ULL, 0xffff6fb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0037ULL, 0x00012cb000157802ULL, 0x000fc40000000f00ULL,
0x000005a000007944ULL, 0x018fea0003c00000ULL, 0xffff70a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0037ULL, 0x00012cf000157802ULL, 0x000fc40000000f00ULL,
0x0000056000007944ULL, 0x018fea0003c00000ULL, 0xffff71c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0008ULL, 0x00012d4000157802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e000dULL, 0x0000051000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0014ULL, 0xffff763000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0008ULL, 0x00012d9000157802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0014ULL,
0xffff761000007947ULL, 0x000fea000383ffffULL, 0x00000002ff117424ULL, 0x000fe200078e00ffULL,
0x00012de0000c7802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e000bULL, 0xffffeba000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x006fe200078e0012ULL, 0x00012e40000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff117424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x010fea0003c00000ULL,
0x0000000b1200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e000eULL,
0x00012ea0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff117424ULL, 0x000fe200078e00ffULL,
0x000000120b127208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e000fULL,
0x00012f00000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff117424ULL, 0x000fe200078e00ffULL,
0x0000000e0b0e7208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e0013ULL,
0x00012f60000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff117424ULL, 0x000fe200078e00ffULL,
0x0000000f0b0a7208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x0000000b1300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e0012ULL,
0x00012fc0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff117424ULL, 0x000fe200078e00ffULL,
0x000000130b147208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x0000000b1200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e000eULL,
0x00013020000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff117424ULL, 0x000fe200078e00ffULL,
0x000000120b157208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff107224ULL, 0x002fe200078e000aULL,
0x00013080000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff117424ULL, 0x000fe200078e00ffULL,
0x0000000e0b167208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffea7000007947ULL, 0x000fea000383ffffULL, 0x018000000c007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000c00008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff0cff7812ULL, 0x040fe4000780c0ffULL,
0x800000000c027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000c00007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffecdf002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003a00007348ULL, 0x000fe80003800000ULL, 0x0c000011100b7389ULL, 0x0002a200000e0039ULL,
0xfffecdb00c007950ULL, 0x000fea0003c3ffffULL, 0x0000007200007348ULL, 0x000fe80003800000ULL,
0x0000001011147389ULL, 0x0002a400000e0075ULL, 0x000000ffff107224ULL, 0x002fc400078e0015ULL,
0x00000000ff117424ULL, 0x000fc800078e00ffULL, 0xfffecd6010007950ULL, 0x000fea0003c3ffffULL,
0x000000011000780cULL, 0x000fe20003f45070ULL, 0x00000000ff157424ULL, 0x000fe200078e00ffULL,
0x0000007000007348ULL, 0x000ff60003800000ULL, 0x0000000000107806ULL, 0x000fc800050e0100ULL,
0x0000007010107212ULL, 0x000fe200078ec0ffULL, 0xfffecd0014007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005f4ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000750ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f0ULL, 0x00000000000003e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000dd0ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e90ULL, 0x00000000000007ccULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001660ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001670ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001700ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001704ULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001900ULL, 0x0000000000013400ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014d00ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014d50ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000150d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000013600ULL, 0x0000000000013600ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014d00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000150d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_16_sm_89_cubin_len = 86448;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
