/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000010990ULL, 0x0000000000010510ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x000000000000eac0ULL, 0x0000000000000190ULL,
0x000e002200000106ULL, 0x000000000000ec50ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x000000000000ec90ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x000000000000ecd0ULL,
0x0000000000000130ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x000000000000ee00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000eac000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x00396c0400288080ULL, 0x0000000000000000ULL, 0x000000dcffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8e08288080820828ULL, 0x2880809208288080ULL, 0x8098082880809708ULL, 0x0828808099082880ULL,
0x80809f082880809bULL, 0xa308288080a10828ULL, 0x288080a408288080ULL, 0x80a608288080a508ULL,
0x08288080a7082880ULL, 0x8080a908288080a8ULL, 0xab08288080aa0828ULL, 0x288080ad08288080ULL,
0x80b008288080ae08ULL, 0x08288080b1082880ULL, 0x8080b608288080b3ULL, 0xbd08288080bc0828ULL,
0x288080c208288080ULL, 0x80dd08288080d308ULL, 0x08288080e3082880ULL, 0x8082801628808086ULL,
0x0000000000031028ULL, 0x2880808692000000ULL, 0x0000000000002200ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x0000eac000000000ULL, 0x0000019000000000ULL, 0x0000580400000000ULL,
0x8084288080820900ULL, 0x0900000004042880ULL, 0x2880808228808086ULL, 0x000000f4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808608288080ULL, 0x8091082880808808ULL,
0x0828808092082880ULL, 0x8080950828808093ULL, 0x9808288080970828ULL, 0x2880809908288080ULL,
0x809c082880809b08ULL, 0x082880809d082880ULL, 0x80809f082880809eULL, 0xa308288080a20828ULL,
0x288080a408288080ULL, 0x80a608288080a508ULL, 0x08288080a8082880ULL, 0x8080aa08288080a9ULL,
0xae08288080ab0828ULL, 0x288080b008288080ULL, 0x80b308288080b108ULL, 0x08288080b6082880ULL,
0x8080c208288080bcULL, 0xdd08288080d30828ULL, 0x288080e308288080ULL, 0x8280162880808c08ULL,
0x0000000003102880ULL, 0x80808c9200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL,
0x0000019800000000ULL, 0x0000ec5000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x000000f4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808608288080ULL,
0x808c082880808808ULL, 0x0828808091082880ULL, 0x8080930828808092ULL, 0x9708288080950828ULL,
0x2880809808288080ULL, 0x809b082880809908ULL, 0x082880809c082880ULL, 0x80809e082880809dULL,
0xa2082880809f0828ULL, 0x288080a308288080ULL, 0x80a508288080a408ULL, 0x08288080a6082880ULL,
0x8080a908288080a8ULL, 0xab08288080aa0828ULL, 0x288080ad08288080ULL, 0x80b108288080b008ULL,
0x08288080b3082880ULL, 0x8080bc08288080b6ULL, 0xd308288080c20828ULL, 0x288080dd08288080ULL,
0x80ae08288080e308ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080ae9200ULL,
0x0000001cffffffffULL, 0x000002c000000000ULL, 0x0000ec9000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x000000f4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808608288080ULL, 0x808c082880808808ULL, 0x0828808091082880ULL, 0x8080930828808092ULL,
0x9708288080950828ULL, 0x2880809808288080ULL, 0x809b082880809908ULL, 0x082880809c082880ULL,
0x80809e082880809dULL, 0xa2082880809f0828ULL, 0x288080a308288080ULL, 0x80a508288080a408ULL,
0x08288080a6082880ULL, 0x8080a908288080a8ULL, 0xab08288080aa0828ULL, 0x288080ae08288080ULL,
0x80b108288080b008ULL, 0x08288080b3082880ULL, 0x8080bc08288080b6ULL, 0xd308288080c20828ULL,
0x288080dd08288080ULL, 0x80ad08288080e308ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080ad9200ULL, 0x0000002cffffffffULL, 0x000003e800000000ULL, 0x0000ecd000000000ULL,
0x0000013000000000ULL, 0x0000180400000000ULL, 0x80aa288080ad0900ULL, 0x0000000000002880ULL,
0x0000001200082f04ULL, 0x0008120400000072ULL, 0x000000000000000dULL, 0x0000000d00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL, 0x0000000e00080a04ULL,
0x0050190300500160ULL, 0x00000000000c1704ULL, 0x0021f00000480007ULL, 0x00000000000c1704ULL,
0x0021f00000400006ULL, 0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL,
0x0011f00000300004ULL, 0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x001c310400ff1b03ULL, 0x0000d25000000020ULL, 0x0000d4a00000d470ULL,
0x0000d6000000d5f0ULL, 0x016029040000d610ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500002105000021ULL, 0x0500002105000021ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000010001602804ULL, 0x000016c000000120ULL,
0x0000181000001750ULL, 0x00001c1000001840ULL, 0x00001ca000001c40ULL, 0x00002e4000001d00ULL,
0x00002fa000002ed0ULL, 0x000033e0000030c0ULL, 0x0000346000003400ULL, 0x000041e0000034c0ULL,
0x0000434000004270ULL, 0x0000477000004460ULL, 0x000047f000004790ULL, 0x000055b000004850ULL,
0x0000571000005640ULL, 0x00005b6000005830ULL, 0x00005be000005b80ULL, 0x000065d000005c40ULL,
0x00008c20000065e0ULL, 0x0000942000008e60ULL, 0x0000ceb000009450ULL, 0x0000cef00000cee0ULL,
0x0000cf200000cf00ULL, 0x0000cf600000cf40ULL, 0x0000d5e00000cf70ULL, 0x0000d6500000d640ULL,
0x0000dd700000d660ULL, 0x0000de300000ddc0ULL, 0x0000df100000dea0ULL, 0x0000dfd00000df80ULL,
0x0000e0800000e020ULL, 0x0000e1500000e0f0ULL, 0x0000e2100000e1c0ULL, 0x0000e2c00000e260ULL,
0x0000e3900000e330ULL, 0x0000e4500000e400ULL, 0x0000e5000000e4a0ULL, 0x0000e5d00000e570ULL,
0x0000e6a00000e640ULL, 0x0000e7500000e700ULL, 0x0000e7f00000e7a0ULL, 0x0000e8900000e840ULL,
0x0000e9500000e8e0ULL, 0x0000ea300000e9d0ULL, 0x04c039040000ea90ULL, 0x000000ff00000220ULL,
0x003f01000000f600ULL, 0x0000000b00000290ULL, 0x003f01200000f608ULL, 0x0000000b000002e0ULL,
0x003f01200000f688ULL, 0x0000000b00000370ULL, 0x003f01200000f6a8ULL, 0x0000000b000003b0ULL,
0x003f01200000f6c8ULL, 0x000000ff00000460ULL, 0x003f01070000f600ULL, 0x00000038000006e0ULL,
0x003f01020000f68cULL, 0x0000003800000a00ULL, 0x003f01010000f688ULL, 0x000000ff00000b30ULL,
0x0004010700000000ULL, 0x000000ff00000bd0ULL, 0x0004010100000000ULL, 0x0000003e00000c30ULL,
0x003f010100000020ULL, 0x0000006200000d50ULL, 0x003f010500000004ULL, 0x0000003e00000db0ULL,
0x003f010500000024ULL, 0x0000003e00000e30ULL, 0x003f010500000024ULL, 0x0000003100001390ULL,
0x003f010700000000ULL, 0x0000003100001460ULL, 0x003f010100000000ULL, 0x0000004600001470ULL,
0x003f010500000004ULL, 0x00000041000014e0ULL, 0x003f01010000f608ULL, 0x0000004100001500ULL,
0x003f01050000f60cULL, 0x00000026000015c0ULL, 0x003f01050000f60cULL, 0x0000004600001b00ULL,
0x003f010500000004ULL, 0x0000004600001b80ULL, 0x003f010500000004ULL, 0x0000003e000024d0ULL,
0x003f010100000020ULL, 0x0000004c00002550ULL, 0x003f01010000f688ULL, 0x00000062000025b0ULL,
0x003f010500000004ULL, 0x0000003e00002600ULL, 0x003f010500000024ULL, 0x0000003e00002680ULL,
0x003f010500000024ULL, 0x0000005600002ba0ULL, 0x003f010700000000ULL, 0x0000005600002c20ULL,
0x003f010100000000ULL, 0x0000005a00002c30ULL, 0x003f010500000004ULL, 0x0000004100002ca0ULL,
0x003f01010000f628ULL, 0x0000004100002cc0ULL, 0x003f01050000f62cULL, 0x0000002800002d90ULL,
0x003f01050000f62cULL, 0x00000027000032b0ULL, 0x003f01050000f6acULL, 0x0000002700003330ULL,
0x003f01050000f6acULL, 0x0000003e00003ae0ULL, 0x003f010100000020ULL, 0x0000004c00003b50ULL,
0x003f01010000f690ULL, 0x0000006200003ba0ULL, 0x003f010500000004ULL, 0x0000003e00003bf0ULL,
0x003f010500000024ULL, 0x0000003e00003c70ULL, 0x003f010500000024ULL, 0x0000005a00003f80ULL,
0x003f010700000000ULL, 0x0000005a00004000ULL, 0x003f010100000000ULL, 0x0000005600004010ULL,
0x003f010500000004ULL, 0x0000004100004080ULL, 0x003f01010000f648ULL, 0x00000041000040a0ULL,
0x003f01050000f64cULL, 0x0000004100004130ULL, 0x003f01050000f64cULL, 0x0000002500004640ULL,
0x003f01050000f6acULL, 0x00000025000046c0ULL, 0x003f01050000f6acULL, 0x0000003e00004e60ULL,
0x003f010100000020ULL, 0x0000004c00004ed0ULL, 0x003f01010000f698ULL, 0x0000006200004f30ULL,
0x003f010500000004ULL, 0x0000003e00004f80ULL, 0x003f010500000024ULL, 0x0000003e00005000ULL,
0x003f010500000024ULL, 0x0000005600005340ULL, 0x003f010700000000ULL, 0x00000057000053c0ULL,
0x003f010100000000ULL, 0x0000005a000053d0ULL, 0x003f010500000004ULL, 0x0000004100005440ULL,
0x003f01010000f668ULL, 0x0000004100005460ULL, 0x003f01050000f66cULL, 0x0000004100005500ULL,
0x003f01050000f66cULL, 0x0000002600005a30ULL, 0x003f01050000f6acULL, 0x0000002600005ab0ULL,
0x003f01050000f6acULL, 0x0000003e000061c0ULL, 0x003f010100000020ULL, 0x0000004c00006220ULL,
0x003f01010000f6a0ULL, 0x000000ff0000a140ULL, 0x003f01010000f600ULL, 0x000000ff0000ac30ULL,
0x003f01050000f604ULL, 0x000000ff0000acd0ULL, 0x003f01050000f604ULL, 0x000000ff0000aee0ULL,
0x003f01010000f600ULL, 0x000000ff0000aef0ULL, 0x003f01050000f604ULL, 0x000000ff0000af80ULL,
0x003f01050000f604ULL, 0x000000280000c310ULL, 0x003f010100000000ULL, 0x000000280000c350ULL,
0x003f010500000004ULL, 0x000000280000c7b0ULL, 0x003f010500000004ULL, 0x000000290000dbd0ULL,
0x003f010100000000ULL, 0x000000290000dc30ULL, 0x003f010100000008ULL, 0x000000290000dc90ULL,
0x003f010100000010ULL, 0x000000290000dd00ULL, 0x003f010100000018ULL, 0x00141c0400053803ULL,
0x0000a09000009e40ULL, 0x0000b0800000afe0ULL, 0x000004010000dd40ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x00000000000004fcULL, 0x0000001200000002ULL, 0x00000000000003d4ULL, 0x0000001200000002ULL,
0x00000000000002acULL, 0x0000001200000002ULL, 0x000000000000016cULL, 0x0000001200000002ULL,
0x0000000000000044ULL, 0x0000001200000002ULL, 0x00000000000004d9ULL, 0x0000001200000002ULL,
0x00000000000003b1ULL, 0x0000001200000002ULL, 0x0000000000000284ULL, 0x0000001200000002ULL,
0x0000000000000143ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff077624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000a7919ULL, 0x000ea20000002300ULL,
0x0000001200047300ULL, 0x000ee200000e0000ULL, 0x0000000807077824ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000ea20000002200ULL, 0x00000100ff157424ULL, 0x000fc600078e00ffULL,
0x0000000000367919ULL, 0x000f220000000000ULL, 0x0000001200127309ULL, 0x000f660000000000ULL,
0x0000000000107919ULL, 0x000ee80000002600ULL, 0x0000000000057919ULL, 0x000f620000000000ULL,
0x00000005ff357819ULL, 0x002fc6000001160bULL, 0x0000000000377919ULL, 0x000e680000002700ULL,
0x00001fff35357589ULL, 0x000fe200000e0000ULL, 0x000000010a007824ULL, 0x004fc600078e0203ULL,
0x00001fff0a0a7589ULL, 0x000ea200000e0000ULL, 0x00000080000b7824ULL, 0x000fe200078e020bULL,
0x00000004ff0d7819ULL, 0x010fe20000011636ULL, 0x00000010360c7824ULL, 0x000fe400078e00ffULL,
0x0000000810007824ULL, 0x008fe200078e00ffULL, 0x000000ff0b00720cULL, 0x040fe40003f45270ULL,
0x0000000f0b00780cULL, 0x040fe40003f64070ULL, 0x000000030b00780cULL, 0x000fc40003f24070ULL,
0x0000007f0b00780cULL, 0x000fe40003f84070ULL, 0x000000050400720cULL, 0x020fe20003f02070ULL,
0x0000003707007224ULL, 0x002fe200078e0200ULL, 0x000000f00c137812ULL, 0x000fc600078ec0ffULL,
0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL,
0x000000040a067824ULL, 0x004fe400078e0235ULL, 0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL,
0x00f60002ff00a388ULL, 0x0003e20000000a00ULL, 0x000000010b00780cULL, 0x000fe20003f44070ULL,
0x0000000206087824ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff05b424ULL, 0x000fc400078e00ffULL,
0x00000001080f7824ULL, 0x040fe200078e020dULL, 0x0000000808097817ULL, 0x000fe20007800000ULL,
0x3fffff60ff069424ULL, 0x000fe200078e00ffULL, 0x00f608040b00b388ULL, 0x0005e20000008a00ULL,
0x7fffff60ff079424ULL, 0x000fe200078e00ffULL, 0x000000070f117812ULL, 0x000fe200078ec0ffULL,
0x0000000100027824ULL, 0x002fe400078e020fULL, 0x0000000109007824ULL, 0x000fe200078e0a08ULL,
0x00f688060b009388ULL, 0x0003e20000008a00ULL, 0xff317217ff0ec424ULL, 0x000fc400078e00ffULL,
0x3fffffc0ff08a424ULL, 0x000fe200078e00ffULL, 0x000000000d00720cULL, 0x000fe20003f66070ULL,
0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL, 0x00f4000e0b00c388ULL, 0x0007e20000004800ULL,
0x3fffff80ff049424ULL, 0x004fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x00005c0002027625ULL, 0x000fc600078e0015ULL, 0x00f6a8040b009388ULL, 0x0005e20000008a00ULL,
0x000000ffff067224ULL, 0x002fe200078e0a12ULL, 0x0000000f110e7812ULL, 0x008fe200078e7836ULL,
0x00000004ff007424ULL, 0x000fe200078e00ffULL, 0x00f6c8080b00a388ULL, 0x0003e80000008a00ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000001302027210ULL, 0x000fe20007f9e0ffULL,
0x000000100f0e7824ULL, 0x000fc400078e020eULL, 0x0000600037047625ULL, 0x004fc800078e0000ULL,
0x000000ffff037224ULL, 0x000fe400020e0603ULL, 0x000000100e077824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604347981ULL, 0x000ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0a00720cULL, 0x000fe20003f05270ULL, 0x00000004ff037e24ULL, 0x00afe2000f8e00ffULL,
0x000000ff34027810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff027819ULL, 0x000fce0000011602ULL,
0x00009b5000008947ULL, 0x000fea0003800000ULL, 0x0000001035397824ULL, 0x000fe200078e00ffULL,
0x00000003ff0d7819ULL, 0x000fe20000011636ULL, 0x0000000237377824ULL, 0x000fe200078e00ffULL,
0x0000580010007a10ULL, 0x000fe20007ffe0ffULL, 0x0000000835387824ULL, 0x000fe200078e00ffULL,
0x0000001039397812ULL, 0x000fe200078ec0ffULL, 0x00000003ff137424ULL, 0x000fe200078e00ffULL,
0x0000000103057810ULL, 0x000fe20007ffe0ffULL, 0x0000580037377a24ULL, 0x000fe200078e0200ULL,
0x00000001ff487819ULL, 0x000fe20000011635ULL, 0x0000000139077824ULL, 0x000fe200078e020dULL,
0x000000020500720cULL, 0x000fc40003f06070ULL, 0x000000040d0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000803047824ULL, 0x000fe200078e0248ULL, 0x0000003607007212ULL, 0x040fe200078e3cffULL,
0x0000000807057824ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000139097824ULL, 0x000fe200078e020eULL, 0xfffffff805087812ULL, 0x000fe200078ee200ULL,
0x0000002004007824ULL, 0x000fe200078e00ffULL, 0x000000080d0f7810ULL, 0x000fe20007ffe0ffULL,
0x00000008090b7824ULL, 0x040fe200078e00ffULL, 0x0000003609047212ULL, 0x000fe200078e3cffULL,
0x00002000483a7824ULL, 0x000fe200078e00ffULL, 0x0000000c0d107810ULL, 0x000fe20007ffe0ffULL,
0x00f68c1338ff738cULL, 0x0003e20000000000ULL, 0x0000000034057217ULL, 0x000fe20007800000ULL,
0x00000080ff167424ULL, 0x000fe200078e00ffULL, 0xfffffff80b0a7812ULL, 0x000fe200078ee204ULL,
0x00000001390b7824ULL, 0x040fe200078e020fULL, 0x00000000480473c2ULL, 0x0004e200000e0000ULL,
0x0000000139117824ULL, 0x000fe200078e0210ULL, 0x000000700c197812ULL, 0x000fe200078ec0ffULL,
0x0000000105067824ULL, 0x100fe200078e0a00ULL, 0x000000360b057212ULL, 0x080fe200078e3cffULL,
0x0000620037007a24ULL, 0x000fe200078e0200ULL, 0x0000003611137212ULL, 0x002fe200078e3cffULL,
0x000000080b147824ULL, 0x000fc400078e00ffULL, 0x0000000811187824ULL, 0x000fe400078e00ffULL,
0x0000000100047824ULL, 0x000fe200078e0207ULL, 0x0000b0003a077810ULL, 0x000fe20007ffe0ffULL,
0x0000000100097824ULL, 0x040fe400078e0209ULL, 0x00000001000b7824ULL, 0x040fe400078e020bULL,
0x0000000100127824ULL, 0x000fe200078e0211ULL, 0xfffffff814007812ULL, 0x000fe200078ee205ULL,
0x00005e0004047625ULL, 0x000fe200078e0016ULL, 0xfffffff818147812ULL, 0x000fc600078ee213ULL,
0x0000001000157824ULL, 0x100fe200078e0207ULL, 0x0000002006007807ULL, 0x000fe20000000000ULL,
0x0000001008117824ULL, 0x100fe200078e0207ULL, 0x0000001904047210ULL, 0x000fe20007f1e0ffULL,
0x000000100a137824ULL, 0x100fe200078e0207ULL, 0x0000003900007217ULL, 0x000fe20007800000ULL,
0x0000001014177824ULL, 0x000fe400078e0207ULL, 0x00005e0009067625ULL, 0x000fc800078e0016ULL,
0x00005e000b087625ULL, 0x000fc800078e0016ULL, 0x00005e00120a7625ULL, 0x000fe200078e0016ULL,
0x0000001908087210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000001906067210ULL, 0x080fe20007f1e0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a39ULL,
0x000000190a0a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe400008e0609ULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x000000000d00720cULL, 0x080fe20003f06070ULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x000000000e00720cULL, 0x080fe40003f26070ULL,
0x000000000f00720cULL, 0x000fc40003f46070ULL, 0x000000001000720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x00cfec0000008000ULL, 0x0000f6a804047891ULL, 0x000fe2000f8e203fULL,
0x00f6880038ff7f8cULL, 0x0003e2000c80043fULL, 0x00000001353b7812ULL, 0x000fe200078ec0ffULL,
0xff317217ff3c7424ULL, 0x000fe200078e00ffULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004117faeULL, 0x0003e2000c101c46ULL,
0x000000020300720cULL, 0x000fe20003f06070ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000006137faeULL, 0x0003e2000c901c46ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000008157faeULL, 0x0005e2000d101c46ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000f6a8483e7811ULL, 0x000fc400078e18ffULL,
0x000000000a177faeULL, 0x0007e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000087805ULL, 0x004fe2000001ff00ULL,
0x00000000000a7805ULL, 0x008fc4000001ff00ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x002fec0000008000ULL, 0x00000000ff5c7f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000020003e247f8cULL, 0x0004e2000c80043fULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x000000203e627810ULL, 0x000fe20007ffe0ffULL, 0x000055b000000947ULL, 0x000fea0003800000ULL,
0x000000ffff267224ULL, 0x00cfe400078e0025ULL, 0xff317217ff3c7424ULL, 0x000fc400078e00ffULL,
0x000000ffff277224ULL, 0x000fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x0000010003257824ULL, 0x000fca00078e00ffULL, 0x000000342500720cULL, 0x000fda0003f06070ULL,
0x0000550000000947ULL, 0x002fea0003800000ULL, 0x0000040062257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x004fe40007804826ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e0027ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003e257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x004fe40007804826ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe20003800000ULL, 0x000024003e257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x004fc40007804826ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000100027007824ULL, 0x000fe200078e00ffULL, 0x00000001ff487819ULL, 0x000fe20000011635ULL,
0x0000010003497824ULL, 0x040fe200078e00ffULL, 0x00000003ff2f7819ULL, 0x000fe20000011636ULL,
0x0000001036427824ULL, 0x000fe200078e00ffULL, 0x0000100000297812ULL, 0x000fe200078e0cffULL,
0x0000002048007824ULL, 0x040fe200078e0249ULL, 0x0000000103257810ULL, 0x000fe20007ffe0ffULL,
0x00000001392b7824ULL, 0x000fe200078e022fULL, 0x000000082f327810ULL, 0x040fe20007ffe0ffULL,
0x0000200048297824ULL, 0x000fe200078e0229ULL, 0x000000042f307810ULL, 0x000fe20007ffe0ffULL,
0x000000082b517824ULL, 0x000fe200078e00ffULL, 0x0000004000007810ULL, 0x000fe20007ffe0ffULL,
0x0000000139317824ULL, 0x000fe200078e0232ULL, 0x000000022500720cULL, 0x000fe20003f06070ULL,
0x00000001392d7824ULL, 0x000fe200078e0230ULL, 0x0000000034257217ULL, 0x000fe20007800000ULL,
0x00000008314f7824ULL, 0x000fe200078e00ffULL, 0x000000362b247212ULL, 0x080fe200078e3cffULL,
0x000000082d417824ULL, 0x000fe200078e00ffULL, 0x0000000c2f437810ULL, 0x000fe20007ffe0ffULL,
0x0000000125257824ULL, 0x000fe200078e0a00ULL, 0xfffffff851517812ULL, 0x000fe200078ee224ULL,
0x0000620037007a24ULL, 0x000fe200078e0200ULL, 0x0000003631267212ULL, 0x080fe200078e3cffULL,
0x0000000139337824ULL, 0x000fe200078e0243ULL, 0x000000362d247212ULL, 0x0c0fe200078e3cffULL,
0x000000012d287824ULL, 0x000fe200078e0200ULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee226ULL,
0x0000000131267824ULL, 0x000fe200078e0200ULL, 0xfffffff841417812ULL, 0x000fe200078ee224ULL,
0x000000012b247824ULL, 0x100fe200078e0200ULL, 0x00000036332a7212ULL, 0x040fe200078e3cffULL,
0x00000001332e7824ULL, 0x000fe200078e0200ULL, 0x0000002025007807ULL, 0x000fe20000000000ULL,
0x00000080ff317424ULL, 0x000fe200078e00ffULL, 0x0000b000294e7810ULL, 0x000fe20007ffe0ffULL,
0x00000008332b7824ULL, 0x000fe200078e00ffULL, 0x0000007042337812ULL, 0x000fe200078ec0ffULL,
0x00005e0024247625ULL, 0x080fe200078e0031ULL, 0x0000000039007217ULL, 0x000fe20007800000ULL,
0x0000030000007945ULL, 0x000fe20003800000ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee22aULL,
0x00005e0028287625ULL, 0x000fe200078e0031ULL, 0x00000033242a7210ULL, 0x000fc60007f1e0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a39ULL, 0x00000033282c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001051517824ULL, 0x100fe400078e024eULL, 0x0000001041507824ULL, 0x100fe200078e024eULL,
0x000000003200720cULL, 0x000fe20003f66070ULL, 0x000000104f4f7824ULL, 0x000fe200078e024eULL,
0x0000004e2b4e7211ULL, 0x000fe200078e20ffULL, 0x000000ffff2b7224ULL, 0x000fe200000e0625ULL,
0x000000002f00720cULL, 0x080fe20003f06070ULL, 0x000000ffff2d7224ULL, 0x000fe200010e0629ULL,
0x000000003000720cULL, 0x080fe20003f46070ULL, 0x00005e0026247625ULL, 0x000fe200078e0031ULL,
0x000000004300720cULL, 0x000fc60003f86070ULL, 0x00005e002e287625ULL, 0x000fe200078e0031ULL,
0x0000003324247210ULL, 0x080fe40007fbe0ffULL, 0x00000008382e7812ULL, 0x000fe200078ec0ffULL,
0x0000000827307824ULL, 0x000fe200078e00ffULL, 0x0000003328287210ULL, 0x000fe20007fde0ffULL,
0x0000001048267824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a517faeULL, 0x0005e2000c101c46ULL, 0x000000ffff257224ULL, 0x000fe200028e0625ULL,
0x0000000830007812ULL, 0x000fe200078e0cffULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x0000f6a8262f7810ULL, 0x040fe20007ffe0ffULL, 0x000000002c507faeULL, 0x0005e2000d101c46ULL,
0x0000001026417812ULL, 0x000fc400078ec0ffULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x000000012f317824ULL, 0x000fe200078e0200ULL, 0x00000000244f7faeULL, 0x0005e2000d901c46ULL,
0xffffffe038007812ULL, 0x000fc600078ec0ffULL, 0x00000000284e7faeULL, 0x0005e2000e101c46ULL,
0x000000002e417210ULL, 0x000fc60007ffe041ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000310403c2ULL, 0x000ee40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x008fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000012f467824ULL, 0x000fe200078e0230ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000031247f8cULL, 0x0044e8000c80043fULL, 0x0000040046267984ULL, 0x0005220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6080041287f8cULL, 0x000fe2000c80043fULL, 0x8000000026ff7812ULL, 0x012fc6000784485dULL,
0x00f60c00412b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe40007804829ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000b000000947ULL, 0x000fea0003800000ULL, 0x00000010382b7812ULL, 0x000fca00078ec0ffULL,
0x0000000100267824ULL, 0x000fe400078e022bULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x000000083b267824ULL, 0x000fe400078e0226ULL, 0x00000000002a7305ULL, 0x000324000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x0000002a0000735dULL, 0x010fe20003800000ULL,
0x00f60c00262b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fc40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002035437824ULL, 0x000fe200078e00ffULL,
0x00000001ff447819ULL, 0x000fe20000011636ULL, 0xffffffffff457424ULL, 0x000fe200078e00ffULL,
0x0000007042427812ULL, 0x000fe400078ec0ffULL, 0xffffff8043437812ULL, 0x000fe400078ec0ffULL,
0x0000000c44447812ULL, 0x000fc800078ec0ffULL, 0x0000004344007210ULL, 0x000fca0007ffe042ULL,
0x00f0000000297984ULL, 0x000e680000000800ULL, 0x00f2000000267984ULL, 0x0008a20000000800ULL,
0x0000003c2900720bULL, 0x002fe20003f1d000ULL, 0x0000c6927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x010fc800000e0100ULL, 0x0000ffff002e7812ULL, 0x000fe2000780c0ffULL,
0x000003e000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2c7424ULL, 0x000fd600078e00ffULL,
0x000003b000008947ULL, 0x000fea0003800000ULL, 0x00000002ff007819ULL, 0x000fe40000011635ULL,
0x0000003c2900720bULL, 0x000fe40003f14000ULL, 0x000000350000720cULL, 0x000fe20003f65270ULL,
0x0000c6527f007947ULL, 0x000ff4000b800000ULL, 0x0000000000007806ULL, 0x000fe400000e0100ULL,
0x00000080352bb824ULL, 0x000fe200078e0242ULL, 0x000000293c2a7209ULL, 0x000fe40007810000ULL,
0x0000ffff002d7812ULL, 0x000fe200078e3cffULL, 0x00000001442bb824ULL, 0x000fe200078e022bULL,
0x00000002ff007819ULL, 0x000fe20000011636ULL, 0x8000002a3c287221ULL, 0x000fe20000010000ULL,
0x0000002d2eff7212ULL, 0x000fc4000780c0ffULL, 0x00f4002a2b00b388ULL, 0x0003e20000000800ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x0000002800307308ULL, 0x0003220000000800ULL,
0x0000c5e27f007947ULL, 0x000fea000b800000ULL, 0x00001f0030287589ULL, 0x01232400000e0000ULL,
0x0000000800007810ULL, 0x002fe20007ffe0ffULL, 0x0000c6227f007947ULL, 0x000fea000b800000ULL,
0x00001f0030007589ULL, 0x00032400000e0000ULL, 0x8000002a29290221ULL, 0x100fe20000010000ULL,
0x000000303d3d7220ULL, 0x000fe20000410000ULL, 0x000000000f0f7220ULL, 0x090fe20000410000ULL,
0x000000000e0e7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b29290820ULL, 0x000fe20000410000ULL,
0x0000000023237220ULL, 0x080fe20000410000ULL, 0x0000000022227220ULL, 0x080fe20000410000ULL,
0x000000001f1f7220ULL, 0x080fe20000410000ULL, 0x0000002900400308ULL, 0x000f220000000800ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x000000000b0b7220ULL, 0x080fe20000410000ULL,
0x000000000a0a7220ULL, 0x080fe20000410000ULL, 0x0000000007077220ULL, 0x080fe20000410000ULL,
0x0000000006067220ULL, 0x080fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x000000001a1a7220ULL, 0x080fe20000410000ULL, 0x0000000017177220ULL, 0x080fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x0000000013137220ULL, 0x080fe20000410000ULL,
0x0000000012127220ULL, 0x000fe20000410000ULL, 0x00000001ff2c7807ULL, 0x000fe20000000000ULL,
0x000000280d0d7220ULL, 0x080fe20000410000ULL, 0x000000280c0c7220ULL, 0x080fe20000410000ULL,
0x0000002821217220ULL, 0x080fe20000410000ULL, 0x0000002820207220ULL, 0x080fe20000410000ULL,
0x000000281d1d7220ULL, 0x080fe20000410000ULL, 0x000000281c1c7220ULL, 0x080fe20000410000ULL,
0x0000002809097220ULL, 0x080fe20000410000ULL, 0x0000002808087220ULL, 0x080fe20000410000ULL,
0x0000002805057220ULL, 0x080fe20000410000ULL, 0x0000002804047220ULL, 0x080fe20000410000ULL,
0x0000002819197220ULL, 0x080fe20000410000ULL, 0x0000002818187220ULL, 0x080fe20000410000ULL,
0x0000002815157220ULL, 0x080fe20000410000ULL, 0x0000002814147220ULL, 0x080fe20000410000ULL,
0x0000002811117220ULL, 0x080fe20000410000ULL, 0x0000002810107220ULL, 0x000fe20000410000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e002aULL, 0x0000004026260220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000003d263d7221ULL, 0x004fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0000040046007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc4000780485dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000267305ULL, 0x000524000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000260000735dULL, 0x010fe40003800000ULL,
0x0000040046267984ULL, 0x000ea40000000800ULL, 0x8000000026ff7812ULL, 0x004fe4000780485dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000040ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff297819ULL, 0x000fc40000011636ULL, 0x0000541000307816ULL, 0x002fe20000000000ULL,
0x0000c2c27f007947ULL, 0x000fea000b800000ULL, 0x00001f2930537589ULL, 0x0002a400000e0000ULL,
0x0000000829467810ULL, 0x000fe20007ffe0ffULL, 0x0000c3027f007947ULL, 0x000fea000b800000ULL,
0x00001f4630007589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001029317810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff327424ULL, 0x000fe200078e00ffULL,
0x00001cb0002e7802ULL, 0x000fe20000000f00ULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0000cfe000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001829317810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff327424ULL, 0x000fe200078e00ffULL,
0x00001d10002e7802ULL, 0x000fe20000000f00ULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0000cf8000007944ULL, 0x01cfea0003c00000ULL, 0x00000002354c7824ULL, 0x040fe200078e00ffULL,
0x0000000736297812ULL, 0x002fe200078ec0ffULL, 0x0000020035287824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x000000044c2b7812ULL, 0x000fc400078ec0ffULL,
0x0000000829267812ULL, 0x000fe400078ef836ULL, 0x0000002b364b7211ULL, 0x000fe400078fe0ffULL,
0xfffff800284a7812ULL, 0x000fe400078ec0ffULL, 0x000000074b297812ULL, 0x000fca00078e7826ULL,
0x0000000826477824ULL, 0x000fe200078e0229ULL, 0x0000000836297812ULL, 0x000fc600078ec0ffULL,
0x0000001047477824ULL, 0x000fe400078e024aULL, 0x0000000435287824ULL, 0x000fe200078e00ffULL,
0x00000007292e7812ULL, 0x100fe200078ec836ULL, 0x00001000352a7824ULL, 0x000fe200078e00ffULL,
0x00000007294d7812ULL, 0x000fe400078ef836ULL, 0x00000004282b7812ULL, 0x000fe400078ec0ffULL,
0xffffe0002a2a7812ULL, 0x000fe400078ec0ffULL, 0x0000002b362d7211ULL, 0x004fe400078fe0ffULL,
0x000099102c2c7816ULL, 0x000fe200000000ffULL, 0x00001000272a7824ULL, 0x000fe200078e022aULL,
0x0000002d2e527212ULL, 0x000fc400078e3cffULL, 0x000000022d2d7810ULL, 0x000fe40007ffe0ffULL,
0x0000b0002a2f7810ULL, 0x000fe20007ffe0ffULL, 0x000000084d5e7824ULL, 0x000fe200078e0252ULL,
0x0000002d2e5a7212ULL, 0x000fe200078e3cffULL, 0x009000004728783bULL, 0x000e620000000200ULL,
0x000000ff2c00720cULL, 0x000fe20003f05270ULL, 0x000000105e307824ULL, 0x010fe200078e022fULL,
0x000000024b4b7810ULL, 0x000fe20007ffe0ffULL, 0x000000084d587824ULL, 0x040fe200078e025aULL,
0x000000804d597811ULL, 0x000fc400078e18ffULL, 0x000000074b4b7812ULL, 0x000fe200078e7826ULL,
0x000000003030783bULL, 0x000ea20000004200ULL, 0x00000010582f7824ULL, 0x000fe400078e022fULL,
0x00000001524d7824ULL, 0x000fe400078e0259ULL, 0x00000008264b7824ULL, 0x000fe400078e024bULL,
0x000000002f2c783bULL, 0x000f240000004200ULL, 0x000000104b4a7824ULL, 0x000fc400078e024aULL,
0x000000015a4b7824ULL, 0x000fe200078e0259ULL, 0x0000005328288232ULL, 0x082fe40000000000ULL,
0x000000532a2a8232ULL, 0x000fe40000000000ULL, 0x0000000029298232ULL, 0x080fe40000000000ULL,
0x000000002b2b8232ULL, 0x000fe20000000000ULL, 0x0000312030547816ULL, 0x004fe400000000ffULL,
0x0000312031557816ULL, 0x000fc400000000ffULL, 0x00000054ff30723eULL, 0x080fe400020006ffULL,
0x00000055ff31723eULL, 0x080fe400020006ffULL, 0x0000312032267816ULL, 0x000fe200000000ffULL,
0x0000100027327824ULL, 0x000fe200078e023aULL, 0x00000054ff54723eULL, 0x000fe400030006ffULL,
0x00000055ff55723eULL, 0x000fe200030006ffULL, 0x000000302810723cULL, 0x000fe20000001810ULL,
0x00003120335d7816ULL, 0x000fc400000000ffULL, 0x0000b00032607810ULL, 0x000fe40007ffe0ffULL,
0x00000026ff5c723eULL, 0x000fe400030006ffULL, 0x0000005dff31723eULL, 0x080fe200020006ffULL,
0x000000542814723cULL, 0x000fe20000001814ULL, 0x0000005dff5d723eULL, 0x000fe400030006ffULL,
0x000031202c2c7816ULL, 0x010fe400000000ffULL, 0x000031202d2d7816ULL, 0x000fc400000000ffULL,
0x000000104d547824ULL, 0x100fe200078e0260ULL, 0x00000026ff30723eULL, 0x000fe200020006ffULL,
0x0000005c2804723cULL, 0x040fe20000001804ULL, 0x000031202e267816ULL, 0x000fe200000000ffULL,
0x000000104b2e7824ULL, 0x000fe200078e0260ULL, 0x000031202f5b7816ULL, 0x000fe200000000ffULL,
0x000000005454783bULL, 0x000e620000004200ULL, 0x00000026ff5a723eULL, 0x000fe400030006ffULL,
0x0000002cff5c723eULL, 0x080fe200020006ffULL, 0x000000302818723cULL, 0x000fe20000001818ULL,
0x0000002dff5d723eULL, 0x000fe200020006ffULL, 0x009000004a30783bULL, 0x000ea20000000200ULL,
0x0000002cff2c723eULL, 0x000fc400030006ffULL, 0x0000002dff2d723eULL, 0x000fc600030006ffULL,
0x0000005c2808723cULL, 0x040ff00000001808ULL, 0x0000002c281c723cULL, 0x000fee000000181cULL,
0x00000026ff2c723eULL, 0x000fc400020006ffULL, 0x0000005bff2d723eULL, 0x080fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fca00030006ffULL, 0x0000002c2820723cULL, 0x000fe20000001820ULL,
0x000000002e2c783bULL, 0x000f220000004200ULL, 0x0000312054547816ULL, 0x002fe400000000ffULL,
0x0000312055557816ULL, 0x000fc800000000ffULL, 0x0000005a280c723cULL, 0x000fe2000000180cULL,
0x0000312056567816ULL, 0x000fe200000000ffULL, 0x0000005330308232ULL, 0x084fe20000000000ULL,
0x0000312057577816ULL, 0x000fe200000000ffULL, 0x0000005332328232ULL, 0x000fe40000000000ULL,
0x0000000031318232ULL, 0x080fe20000000000ULL, 0x00000054ff28723eULL, 0x080fe200020006ffULL,
0x0000000033338232ULL, 0x000fe20000000000ULL, 0x00000055ff29723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fc400030006ffULL, 0x00000055ff55723eULL, 0x000fc600030006ffULL,
0x000000283010723cULL, 0x040fee0000001810ULL, 0x00000056ff28723eULL, 0x080fe200020006ffULL,
0x000000543014723cULL, 0x000fe20000001814ULL, 0x00000057ff29723eULL, 0x000fe400020006ffULL,
0x00000056ff56723eULL, 0x000fc400030006ffULL, 0x00000057ff57723eULL, 0x000fc600030006ffULL,
0x000000283018723cULL, 0x040fe20000001818ULL, 0x000031202c2c7816ULL, 0x010fe400000000ffULL,
0x000031202d2d7816ULL, 0x000fe400000000ffULL, 0x000031202e2e7816ULL, 0x000fe400000000ffULL,
0x0000002cff28723eULL, 0x000fe200020006ffULL, 0x000000563004723cULL, 0x000fe20000001804ULL,
0x0000002dff29723eULL, 0x000fe400020006ffULL, 0x000031202f2f7816ULL, 0x000fc400000000ffULL,
0x0000002cff2c723eULL, 0x000fe400030006ffULL, 0x0000002dff2d723eULL, 0x000fe200030006ffULL,
0x000000283008723cULL, 0x040fee0000001808ULL, 0x0000002eff28723eULL, 0x000fe200020006ffULL,
0x0000002c301c723cULL, 0x000fe2000000181cULL, 0x0000002fff29723eULL, 0x000fc400020006ffULL,
0x0000002eff2e723eULL, 0x000fe400030006ffULL, 0x0000002fff2f723eULL, 0x000fc600030006ffULL,
0x000000283020723cULL, 0x040ff00000001820ULL, 0x0000002e300c723cULL, 0x000fe2000000180cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003e287f8cULL, 0x0002a2000c80043fULL,
0xfffffff84c4c7812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000040492b7810ULL, 0x000fe20007ffe0ffULL, 0x00f688004cff7f8cULL, 0x0009e2000c80043fULL,
0x000000ffff267224ULL, 0x004fe200078e0029ULL, 0x0000000127277812ULL, 0x000fe200078e0cffULL,
0x000000ffff5d7224ULL, 0x008fe200078e0025ULL, 0x000000342b00720cULL, 0x000fda0003f06070ULL,
0x00003ca000000947ULL, 0x000fea0003800000ULL, 0x0000040062277984ULL, 0x010ea40000000800ULL,
0x8000000027ff7812ULL, 0x004fe40007804826ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x000024003e277984ULL, 0x000ea40000000800ULL, 0x8000000027ff7812ULL, 0x004fe40007804826ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000277305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000270000735dULL, 0x008fe40003800000ULL,
0x000024003e277984ULL, 0x000ea40000000800ULL, 0x8000000027ff7812ULL, 0x004fc40007804826ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000436007811ULL, 0x040fe200078fe8ffULL,
0x00000080ff337424ULL, 0x000fe200078e00ffULL, 0x00000001ff487819ULL, 0x000fe20000011635ULL,
0x000000083f597824ULL, 0x000fe200078e00ffULL, 0x0000003936277211ULL, 0x000fe200078fe8ffULL,
0x0000000139297824ULL, 0x000fe200078e0200ULL, 0x00000001032b7810ULL, 0x000fe20007ffe0ffULL,
0x0000002048287824ULL, 0x000fe200078e0249ULL, 0x0000003627267212ULL, 0x0c0fe200078e3cffULL,
0x0000000827557824ULL, 0x000fe200078e00ffULL, 0x0000003629007212ULL, 0x040fe200078e3cffULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0x0000008028287810ULL, 0x000fe20007ffe0ffULL,
0x000010003f617824ULL, 0x000fe200078e00ffULL, 0xfffffff855557812ULL, 0x000fc400078ee226ULL,
0xfffffff829547812ULL, 0x000fe200078ee200ULL, 0x00006200372e7a24ULL, 0x000fe200078e0228ULL,
0x0000002834297217ULL, 0x000fe40007800000ULL, 0x00000003ff2f7819ULL, 0x000fe40000011636ULL,
0x0000000836007811ULL, 0x040fe400078fe8ffULL, 0x0000000c36267811ULL, 0x000fe400078fe8ffULL,
0x000000022b00720cULL, 0x000fe20003f06070ULL, 0x00000001292b7824ULL, 0x000fe200078e0a28ULL,
0x000000042f317810ULL, 0x000fe20007ffe0ffULL, 0x0000000139277824ULL, 0x040fe200078e0200ULL,
0x0000f6a848577811ULL, 0x000fe200078e20ffULL, 0x0000000139297824ULL, 0x000fe200078e0226ULL,
0x0000002f2e267210ULL, 0x140fe20007ffe039ULL, 0x0000000827537824ULL, 0x000fe200078e00ffULL,
0x000000312e287210ULL, 0x000fc40007ffe039ULL, 0x000000202b2c7807ULL, 0x000fe20000000000ULL,
0x00000008292b7824ULL, 0x000fe200078e00ffULL, 0x00000036272a7212ULL, 0x080fe200078e3cffULL,
0x00005e0026267625ULL, 0x080fe200078e0033ULL, 0x0000003629007212ULL, 0x000fe400078e3cffULL,
0x0000002c39307217ULL, 0x000fe20007800000ULL, 0x00005e0028287625ULL, 0x000fe200078e0033ULL,
0xfffffff853537812ULL, 0x000fe400078ee22aULL, 0x00000042262a7210ULL, 0x080fe20007f1e0ffULL,
0x0000000130307824ULL, 0x000fe200078e0a39ULL, 0x00000042282c7210ULL, 0x000fc40007f5e0ffULL,
0x00000008595a7812ULL, 0x000fe400078ec0ffULL, 0xfffffff82b007812ULL, 0x000fe200078ee200ULL,
0x000000ffff2b7224ULL, 0x000fe200000e0627ULL, 0x0000100061277812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2d7224ULL, 0x000fe200010e0629ULL, 0x000000082f297810ULL, 0x000fe20007ffe0ffULL,
0x0000000157567824ULL, 0x000fe200078e025aULL, 0x000000302f00720cULL, 0x040fe20003f06070ULL,
0x0000200048277824ULL, 0x000fe200078e0227ULL, 0x0000000c2f2f7810ULL, 0x000fe20007ffe0ffULL,
0x00000000560473c2ULL, 0x000ea200000e0000ULL, 0x000000292e267210ULL, 0x000fc40007ffe039ULL,
0x0000002f2e287210ULL, 0x000fe40007ffe039ULL, 0x000000302900720cULL, 0x080fe40003f66070ULL,
0x0000b00027527810ULL, 0x000fe20007ffe0ffULL, 0x00005e0026267625ULL, 0x080fe200078e0033ULL,
0x000000303100720cULL, 0x080fe40003f46070ULL, 0x000000302f00720cULL, 0x000fe20003f86070ULL,
0x00005e0028287625ULL, 0x000fe200078e0033ULL, 0x0000004226267210ULL, 0x000fc40007fbe0ffULL,
0x000000085a5a7812ULL, 0x000fe200078e3cffULL, 0x0000001055557824ULL, 0x100fe200078e0252ULL,
0x0000004228287210ULL, 0x000fe20007fde0ffULL, 0x0000001054547824ULL, 0x100fe200078e0252ULL,
0x00000027ff277210ULL, 0x000fe20002ffe4ffULL, 0x0000001053537824ULL, 0x100fe200078e0252ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a557faeULL, 0x0007e2000c101c46ULL,
0x0000001000527824ULL, 0x000fe400078e0252ULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x000000002c547faeULL, 0x0007e2000d101c46ULL, 0x00000001575a7824ULL, 0x000fc600078e025aULL,
0x0000000026537faeULL, 0x0007e8000d901c46ULL, 0x0000000028527faeULL, 0x0007e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x004fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000565c7f8cULL, 0x000528000c80043fULL, 0x000004005a297984ULL, 0x0084e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6280041267f8cULL, 0x000fe2000c80043fULL, 0x8000000029ff7812ULL, 0x008fc60007844825ULL,
0x00f62c00412b7984ULL, 0x000ee40000000800ULL, 0x800000002bff7812ULL, 0x008fe40007804827ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0xffffffe038287812ULL, 0x040fe200078ec0ffULL,
0x3e000000ff007424ULL, 0x000fe200078e00ffULL, 0x0000001038297812ULL, 0x040fe400078ec0ffULL,
0x00000008382a7812ULL, 0x000fc800078ec0ffULL, 0x000000282a287210ULL, 0x000fe40007ffe029ULL,
0x0000000000297305ULL, 0x000764000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000290000735dULL, 0x020fe40003800000ULL, 0x00f62c0028297984ULL, 0x000ee40000000800ULL,
0x8000000029ff7812ULL, 0x008fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008042277810ULL, 0x000fca0007ffe043ULL, 0x0000000144277824ULL, 0x000fca00078e0227ULL,
0x00f0000027297984ULL, 0x000ee80000000800ULL, 0x00f2000027007984ULL, 0x0002a20000000800ULL,
0x0000003c2900720bULL, 0x008fe20003f1d000ULL, 0x0000b1727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000267806ULL, 0x002fc800000e0100ULL, 0x0000ffff262e7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2c7424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000135267811ULL, 0x000fe400078ff0ffULL,
0x0000003c2900720bULL, 0x000fe40003f14000ULL, 0x000000352600720cULL, 0x000fe20003f65270ULL,
0x0000b1327f007947ULL, 0x000ff4000b800000ULL, 0x0000000000267806ULL, 0x000fe400000e0100ULL,
0x000000293c277209ULL, 0x000fe20007810000ULL, 0x00000080352bb824ULL, 0x000fe200078e0242ULL,
0x00000002ff317819ULL, 0x000fc60000011636ULL, 0x00000001442ab824ULL, 0x000fe200078e022bULL,
0x800000273c287221ULL, 0x000fe20000010000ULL, 0x0000ffff262b7812ULL, 0x000fc600078e3cffULL,
0x3fb8aa3b28287820ULL, 0x000fe20000410000ULL, 0x00f400272a00b388ULL, 0x0003e20000000800ULL,
0x0000002b2eff7212ULL, 0x000fe4000780c0ffULL, 0x0000002800307308ULL, 0x000ee40000000800ULL,
0x000000303d3d7220ULL, 0x008fe20000410000ULL, 0x0000b0b27f007947ULL, 0x000fec000b800000ULL,
0x00001f3130267589ULL, 0x0022e400000e0000ULL, 0x0000002610107220ULL, 0x088fe20000410000ULL,
0x0000002611117220ULL, 0x080fe20000410000ULL, 0x0000002614147220ULL, 0x080fe20000410000ULL,
0x0000002615157220ULL, 0x080fe20000410000ULL, 0x0000002618187220ULL, 0x080fe20000410000ULL,
0x0000002619197220ULL, 0x080fe20000410000ULL, 0x0000002604047220ULL, 0x080fe20000410000ULL,
0x0000002605057220ULL, 0x080fe20000410000ULL, 0x0000002608087220ULL, 0x080fe20000410000ULL,
0x0000002609097220ULL, 0x080fe20000410000ULL, 0x000000261c1c7220ULL, 0x080fe20000410000ULL,
0x000000261d1d7220ULL, 0x080fe20000410000ULL, 0x0000002620207220ULL, 0x080fe20000410000ULL,
0x0000002621217220ULL, 0x080fe20000410000ULL, 0x000000260c0c7220ULL, 0x080fe20000410000ULL,
0x000000260d0d7220ULL, 0x000fe20000410000ULL, 0x0000aff27f007947ULL, 0x000fea000b800000ULL,
0x00001f4630267589ULL, 0x00066400000e0000ULL, 0x000000293c3c7209ULL, 0x000fe20007810000ULL,
0x0000002612127220ULL, 0x082fe20000410000ULL, 0x00000001ff2c7807ULL, 0x000fe20000000000ULL,
0x0000002613137220ULL, 0x080fe20000410000ULL, 0x0000002616167220ULL, 0x080fe20000410000ULL,
0x8000003c29290221ULL, 0x000fe20000010000ULL, 0x0000002617177220ULL, 0x080fe20000410000ULL,
0x000000261a1a7220ULL, 0x080fe20000410000ULL, 0x000000261b1b7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b29290820ULL, 0x000fe20000410000ULL, 0x0000002606067220ULL, 0x080fe20000410000ULL,
0x0000002607077220ULL, 0x080fe20000410000ULL, 0x000000260a0a7220ULL, 0x080fe20000410000ULL,
0x0000002900400308ULL, 0x000e620000000800ULL, 0x000000260b0b7220ULL, 0x080fe20000410000ULL,
0x000000261e1e7220ULL, 0x080fe20000410000ULL, 0x000000261f1f7220ULL, 0x080fe20000410000ULL,
0x0000002622227220ULL, 0x080fe20000410000ULL, 0x0000002623237220ULL, 0x080fe20000410000ULL,
0x000000260e0e7220ULL, 0x080fe20000410000ULL, 0x000000260f0f7220ULL, 0x000fe20000410000ULL,
0x0000000040000220ULL, 0x006fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000003d003d7221ULL, 0x004fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x000000083f007824ULL, 0x000fe200078e00ffULL,
0xfffffff038277812ULL, 0x000fc800078ec0ffULL, 0x0000000800007812ULL, 0x000fca00078e0cffULL,
0x0000000100277824ULL, 0x000fca00078e0227ULL, 0x00f6ac0027297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000267305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000260000735dULL, 0x004fe20003800000ULL, 0x00f6ac0027297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff317819ULL, 0x000fe40000011636ULL, 0x00000040ff00723eULL, 0x000fe400000000ffULL,
0x0000001831247810ULL, 0x040fe40007ffe0ffULL, 0x0000001031257810ULL, 0x000fe40007ffe0ffULL,
0x0000541000307816ULL, 0x008fe20000000000ULL, 0x0000ad427f007947ULL, 0x000fea000b800000ULL,
0x00001f3130637589ULL, 0x0002a400000e0000ULL, 0x0000ad827f007947ULL, 0x000fea000b800000ULL,
0x00001f4630007589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff317224ULL, 0x002fe200078e0025ULL, 0x00003470002e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff327424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0000b82000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff317224ULL, 0x002fe200078e0024ULL, 0x000034d0002e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff327424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0000b7c000007944ULL, 0x01cfea0003c00000ULL, 0x000010003f2d7824ULL, 0x004fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100035247824ULL, 0x000fe200078e00ffULL,
0x009800004728783bULL, 0x000ea20000000200ULL, 0x000099102c2c7816ULL, 0x000fe400000000ffULL,
0x000010002d2d7812ULL, 0x000fc400078e0cffULL, 0xffffe00024247812ULL, 0x000fe400078ec0ffULL,
0x000000ff2c00720cULL, 0x000fe40003f05270ULL, 0x0000b000245b7810ULL, 0x100fe40007ffe02dULL,
0x0000b0003a607810ULL, 0x000fc60007ffe02dULL, 0x000000105e5f7824ULL, 0x100fe400078e025bULL,
0x00000010585b7824ULL, 0x000fe400078e025bULL, 0x000000104d5c7824ULL, 0x110fe200078e0260ULL,
0x000000005f24783bULL, 0x000f220000004200ULL, 0x000000104b607824ULL, 0x000fc600078e0260ULL,
0x000000005b30783bULL, 0x00ae620000004200ULL, 0x0000006328288232ULL, 0x084fe40000000000ULL,
0x000000632a2a8232ULL, 0x000fe40000000000ULL, 0x0000000029298232ULL, 0x080fe40000000000ULL,
0x000000002b2b8232ULL, 0x000fe20000000000ULL, 0x0000312024247816ULL, 0x010fe400000000ffULL,
0x0000312025257816ULL, 0x000fc400000000ffULL, 0x00000024ff2e723eULL, 0x080fe400020006ffULL,
0x00000025ff2f723eULL, 0x080fe400020006ffULL, 0x00000024ff24723eULL, 0x000fe400030006ffULL,
0x00000025ff25723eULL, 0x000fe400030006ffULL, 0x0000312027657816ULL, 0x000fe200000000ffULL,
0x0000002e2810723cULL, 0x000fe20000001810ULL, 0x00003120262c7816ULL, 0x000fc400000000ffULL,
0x0000312030307816ULL, 0x002fe400000000ffULL, 0x0000002cff64723eULL, 0x000fe400030006ffULL,
0x0000312031317816ULL, 0x000fe200000000ffULL, 0x000000242814723cULL, 0x000fee0000001814ULL,
0x00000065ff25723eULL, 0x000fc400020006ffULL, 0x00000065ff65723eULL, 0x000fe400030006ffULL,
0x0000002cff24723eULL, 0x000fe400020006ffULL, 0x000000005c2c783bULL, 0x000e660000004200ULL,
0x000000642804723cULL, 0x040fee0000001804ULL, 0x00000030ff64723eULL, 0x080fe200020006ffULL,
0x000000242818723cULL, 0x000fe20000001818ULL, 0x00000031ff65723eULL, 0x000fe200020006ffULL,
0x009800004a24783bULL, 0x000ea20000000200ULL, 0x00000030ff30723eULL, 0x000fc400030006ffULL,
0x00000031ff31723eULL, 0x000fc600030006ffULL, 0x000000642808723cULL, 0x040fee0000001808ULL,
0x0000312032647816ULL, 0x000fe200000000ffULL, 0x00000030281c723cULL, 0x000fe2000000181cULL,
0x0000312033657816ULL, 0x000fcc00000000ffULL, 0x00000064ff30723eULL, 0x080fe400020006ffULL,
0x00000065ff31723eULL, 0x080fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400030006ffULL,
0x00000065ff65723eULL, 0x000fe400030006ffULL, 0x000031202c2c7816ULL, 0x002fe200000000ffULL,
0x000000302820723cULL, 0x000fe20000001820ULL, 0x000000006030783bULL, 0x000e620000004200ULL,
0x000031202d2d7816ULL, 0x000fc400000000ffULL, 0x000031202e2e7816ULL, 0x000fe400000000ffULL,
0x000031202f2f7816ULL, 0x000fe400000000ffULL, 0x00000064280c723cULL, 0x000fe2000000180cULL,
0x0000006324248232ULL, 0x084fe40000000000ULL, 0x0000006326268232ULL, 0x000fe40000000000ULL,
0x0000000025258232ULL, 0x080fe40000000000ULL, 0x0000002cff28723eULL, 0x000fe200020006ffULL,
0x0000000027278232ULL, 0x000fe20000000000ULL, 0x0000002dff29723eULL, 0x000fc400020006ffULL,
0x0000002cff2c723eULL, 0x000fe400030006ffULL, 0x0000002dff2d723eULL, 0x000fc600030006ffULL,
0x000000282410723cULL, 0x040fee0000001810ULL, 0x0000002eff28723eULL, 0x080fe200020006ffULL,
0x0000002c2414723cULL, 0x000fe20000001814ULL, 0x0000002fff29723eULL, 0x000fe400020006ffULL,
0x0000002eff2e723eULL, 0x000fc400030006ffULL, 0x0000002fff2f723eULL, 0x000fc600030006ffULL,
0x000000282418723cULL, 0x040fe20000001818ULL, 0x0000312030307816ULL, 0x002fe400000000ffULL,
0x0000312031317816ULL, 0x000fe400000000ffULL, 0x0000312032327816ULL, 0x000fe400000000ffULL,
0x00000030ff28723eULL, 0x000fe200020006ffULL, 0x0000002e2404723cULL, 0x000fe20000001804ULL,
0x00000031ff29723eULL, 0x000fe400020006ffULL, 0x0000312033337816ULL, 0x000fc400000000ffULL,
0x00000030ff30723eULL, 0x000fe400030006ffULL, 0x00000031ff31723eULL, 0x000fe200030006ffULL,
0x000000282408723cULL, 0x040fee0000001808ULL, 0x00000032ff28723eULL, 0x000fe200020006ffULL,
0x00000030241c723cULL, 0x000fe2000000181cULL, 0x00000033ff29723eULL, 0x000fc400020006ffULL,
0x00000032ff32723eULL, 0x000fe400030006ffULL, 0x00000033ff33723eULL, 0x000fc600030006ffULL,
0x000000282420723cULL, 0x040ff00000001820ULL, 0x00000032240c723cULL, 0x000fe2000000180cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020003e247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008049277810ULL, 0x000fe20007ffe0ffULL, 0x00f690004cff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff267224ULL, 0x004fc400078e0025ULL, 0x000000342700720cULL, 0x000fe40003f06070ULL,
0x000000013f277812ULL, 0x000fd600078ec0ffULL, 0x000026b000000947ULL, 0x000fea0003800000ULL,
0x0000040062257984ULL, 0x008ea40000000800ULL, 0x8000000025ff7812ULL, 0x004fe40007804826ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003e257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x004fe40007804826ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe20003800000ULL, 0x000024003e257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x004fc40007804826ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff487819ULL, 0x000fe20000011635ULL, 0x00000080ff337424ULL, 0x000fe200078e00ffULL,
0x00000003ff297819ULL, 0x000fe20000011636ULL, 0x000000005a0473c2ULL, 0x000ea200000e0000ULL,
0x0000000103277810ULL, 0x000fe20007ffe0ffULL, 0x0000002048007824ULL, 0x000fe200078e0249ULL,
0x00000004292f7810ULL, 0x000fe40007ffe0ffULL, 0x000000022700720cULL, 0x000fe40003f06070ULL,
0x000000c000007810ULL, 0x000fc40007ffe0ffULL, 0x0000000829317810ULL, 0x000fe40007ffe0ffULL,
0x0000000034257217ULL, 0x000fe20007800000ULL, 0x0000620037267a24ULL, 0x000fe200078e0200ULL,
0x0000000c292d7810ULL, 0x000fc60007ffe0ffULL, 0x0000000125007824ULL, 0x000fe200078e0a00ULL,
0x0000002926247210ULL, 0x140fe40007ffe039ULL, 0x0000003126277210ULL, 0x100fe40007ffe039ULL,
0x0000002000007807ULL, 0x000fe20000000000ULL, 0x00005e0024247625ULL, 0x000fe200078e0033ULL,
0x0000002d26287210ULL, 0x000fe40007ffe039ULL, 0x0000000039007217ULL, 0x000fe40007800000ULL,
0x00000042242a7210ULL, 0x000fc40007f1e0ffULL, 0x0000002f26247210ULL, 0x100fe20007ffe039ULL,
0x0000000100007824ULL, 0x000fe400078e0a39ULL, 0x000000ffff2b7224ULL, 0x000fe400000e0625ULL,
0x00005e0024247625ULL, 0x080fe200078e0033ULL, 0x000000002900720cULL, 0x080fe40003f46070ULL,
0x000000002f00720cULL, 0x000fe20003f06070ULL, 0x00005e0027267625ULL, 0x000fe200078e0033ULL,
0x0000004224247210ULL, 0x000fc40007f7e0ffULL, 0x000000002d00720cULL, 0x000fe20003f86070ULL,
0x00005e0028287625ULL, 0x000fe200078e0033ULL, 0x0000004226267210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff257224ULL, 0x000fe200018e0625ULL, 0x000000003100720cULL, 0x000fe20003f66070ULL,
0x000000ffff277224ULL, 0x000fe200028e0627ULL, 0x0000004228287210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a517faeULL, 0x0007e8000d101c46ULL,
0x000000ffff297224ULL, 0x000fe200030e0629ULL, 0x0000000024507faeULL, 0x0007ea000c101c46ULL,
0x00000000264f7faeULL, 0x0007e8000d901c46ULL, 0x00000000284e7faeULL, 0x0007e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x004fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000005a287f8cULL, 0x0084e8000c80043fULL, 0x0000040056007984ULL, 0x0005220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6480041247f8cULL, 0x000fe2000c80043fULL, 0x8000000000ff7812ULL, 0x010fc6000784485dULL,
0x00f64c0041277984ULL, 0x000f240000000800ULL, 0x8000000027ff7812ULL, 0x010fe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000267305ULL, 0x000964000021f000ULL, 0x3fa0000000007823ULL, 0x010fe200000100ffULL,
0x000000260000735dULL, 0x020fe20003800000ULL, 0x00f64c0041277984ULL, 0x000f240000000800ULL,
0x8000000027ff7812ULL, 0x010fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010042257810ULL, 0x000fca0007ffe043ULL, 0x0000000144257824ULL, 0x000fca00078e0225ULL,
0x00f0000025277984ULL, 0x000f280000000800ULL, 0x00f2000025007984ULL, 0x0002a20000000800ULL,
0x0000003c2700720bULL, 0x010fe20003f1d000ULL, 0x0000a0127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x002fc800000e0100ULL, 0x0000ffff242e7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2a7424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000235247811ULL, 0x000fe400078ff0ffULL,
0x0000003c2700720bULL, 0x000fe40003f14000ULL, 0x000000352400720cULL, 0x000fe20003f65270ULL,
0x00009fd27f007947ULL, 0x000ff4000b800000ULL, 0x0000000000247806ULL, 0x000fe400000e0100ULL,
0x000000273c257209ULL, 0x000fe20007810000ULL, 0x00000080352bb824ULL, 0x000fe200078e0242ULL,
0x00000002ff317819ULL, 0x000fc60000011636ULL, 0x00000001442ab824ULL, 0x000fe200078e022bULL,
0x800000253c267221ULL, 0x000fe20000010000ULL, 0x0000ffff242b7812ULL, 0x000fc600078e3cffULL,
0x3fb8aa3b26267820ULL, 0x000fe20000410000ULL, 0x00f400252a00b388ULL, 0x0003e20000000800ULL,
0x0000002b2eff7212ULL, 0x000fe4000780c0ffULL, 0x0000002600307308ULL, 0x000f240000000800ULL,
0x000000303d3d7220ULL, 0x010fe20000410000ULL, 0x00009f527f007947ULL, 0x000fec000b800000ULL,
0x00001f3130247589ULL, 0x00232400000e0000ULL, 0x0000002410107220ULL, 0x090fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x0000002404047220ULL, 0x080fe20000410000ULL,
0x0000002405057220ULL, 0x080fe20000410000ULL, 0x0000002408087220ULL, 0x080fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002420207220ULL, 0x080fe20000410000ULL,
0x0000002421217220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x000fe20000410000ULL, 0x00009e927f007947ULL, 0x000fea000b800000ULL,
0x00001f4630247589ULL, 0x00086400000e0000ULL, 0x000000273c3c7209ULL, 0x000fe20007810000ULL,
0x0000002412127220ULL, 0x082fe20000410000ULL, 0x00000001ff2a7807ULL, 0x000fe20000000000ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x8000003c27270221ULL, 0x000fe20000010000ULL, 0x0000002417177220ULL, 0x080fe20000410000ULL,
0x000000241a1a7220ULL, 0x080fe20000410000ULL, 0x000000241b1b7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL, 0x0000002406067220ULL, 0x080fe20000410000ULL,
0x0000002407077220ULL, 0x080fe20000410000ULL, 0x000000240a0a7220ULL, 0x080fe20000410000ULL,
0x0000002700400308ULL, 0x000e620000000800ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x000000241e1e7220ULL, 0x080fe20000410000ULL, 0x000000241f1f7220ULL, 0x080fe20000410000ULL,
0x0000002422227220ULL, 0x080fe20000410000ULL, 0x0000002423237220ULL, 0x080fe20000410000ULL,
0x000000240e0e7220ULL, 0x080fe20000410000ULL, 0x000000240f0f7220ULL, 0x000fe20000410000ULL,
0x0000000040000220ULL, 0x006fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0x0000003d003d7221ULL, 0x004fe20000010000ULL,
0x000000f000002947ULL, 0x000fea0003800000ULL, 0x0000000859257812ULL, 0x000fe400078ec0ffULL,
0xfffffff038007812ULL, 0x000fca00078ec0ffULL, 0x0000000100257824ULL, 0x000fca00078e0225ULL,
0x00f6ac0025007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000780485dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x004fe40003800000ULL,
0x00f6ac0025247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc4000780485dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x000fe40000011636ULL,
0x00000040ff00723eULL, 0x000fe400000000ffULL, 0x0000001831247810ULL, 0x040fe40007ffe0ffULL,
0x0000001031257810ULL, 0x000fe40007ffe0ffULL, 0x0000541000307816ULL, 0x010fe20000000000ULL,
0x00009bf27f007947ULL, 0x000fea000b800000ULL, 0x00001f31302b7589ULL, 0x0002a400000e0000ULL,
0x00009c327f007947ULL, 0x000fea000b800000ULL, 0x00001f4630007589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff317224ULL, 0x002fe200078e0025ULL,
0x00004800002e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff327424ULL, 0x000fc400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x0000a49000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff317224ULL, 0x002fe200078e0024ULL,
0x00004860002e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff327424ULL, 0x000fe400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x0000a43000007944ULL, 0x01cfea0003c00000ULL,
0x0000100035247824ULL, 0x000fe200078e00ffULL, 0x0000100061617812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000099102a2a7816ULL, 0x000fe400000000ffULL,
0xffffe00024247812ULL, 0x000fe400078ec0ffULL, 0x000000ff2a00720cULL, 0x000fc40003f05270ULL,
0x0000b00024317810ULL, 0x002fe40007ffe061ULL, 0x00a000004724783bULL, 0x000e660000000200ULL,
0x000000105e2c7824ULL, 0x100fe400078e0231ULL, 0x0000001058317824ULL, 0x000fe200078e0231ULL,
0x0000b0003a587810ULL, 0x000fc60007ffe061ULL, 0x000000002c2c783bULL, 0x004ea40000004200ULL,
0x000000104d647824ULL, 0x000fe400078e0258ULL, 0x000000003130783bULL, 0x010f280000004200ULL,
0x000000006464783bULL, 0x000f620000004200ULL, 0x0000002b24248232ULL, 0x082fe40000000000ULL,
0x0000002b26268232ULL, 0x000fc40000000000ULL, 0x0000000025258232ULL, 0x080fe40000000000ULL,
0x0000000027278232ULL, 0x000fe20000000000ULL, 0x000031202d4f7816ULL, 0x004fe400000000ffULL,
0x000031202c2a7816ULL, 0x000fe400000000ffULL, 0x0000004fff2d723eULL, 0x080fe400020006ffULL,
0x0000002aff4e723eULL, 0x000fe400030006ffULL, 0x0000004fff4f723eULL, 0x000fc400030006ffULL,
0x0000002aff2c723eULL, 0x000fe400020006ffULL, 0x000031202e2a7816ULL, 0x000fe400000000ffULL,
0x000031202f507816ULL, 0x000fe200000000ffULL, 0x0000004e2414723cULL, 0x000fe20000001814ULL,
0x0000312030307816ULL, 0x010fe400000000ffULL, 0x0000312031317816ULL, 0x000fe400000000ffULL,
0x0000312064647816ULL, 0x020fc400000000ffULL, 0x0000002aff4e723eULL, 0x000fe200030006ffULL,
0x0000002c2410723cULL, 0x040fe20000001810ULL, 0x00000050ff4f723eULL, 0x000fe400030006ffULL,
0x0000312065657816ULL, 0x000fe400000000ffULL, 0x0000312066667816ULL, 0x000fe400000000ffULL,
0x0000002aff2c723eULL, 0x000fe200020006ffULL, 0x0000004e2404723cULL, 0x000fe20000001804ULL,
0x00000050ff2d723eULL, 0x000fc400020006ffULL, 0x00003120322a7816ULL, 0x000fe400000000ffULL,
0x000000584b327211ULL, 0x000fe400078e20ffULL, 0x00000030ff4e723eULL, 0x080fe200020006ffULL,
0x0000002c2418723cULL, 0x000fe20000001818ULL, 0x00000031ff4f723eULL, 0x080fe200020006ffULL,
0x00a000004a2c783bULL, 0x000e620000000200ULL, 0x00000030ff30723eULL, 0x000fe400030006ffULL,
0x00000031ff31723eULL, 0x000fc400030006ffULL, 0x0000312067677816ULL, 0x000fe200000000ffULL,
0x0000004e2408723cULL, 0x040fee0000001808ULL, 0x00003120334f7816ULL, 0x000fe200000000ffULL,
0x00000030241c723cULL, 0x000fe2000000181cULL, 0x0000002aff4e723eULL, 0x000fcc00030006ffULL,
0x0000002aff30723eULL, 0x000fe400020006ffULL, 0x0000004fff31723eULL, 0x080fe400020006ffULL,
0x0000004fff4f723eULL, 0x000fca00030006ffULL, 0x000000302420723cULL, 0x040fe20000001820ULL,
0x000000003230783bULL, 0x000eae0000004200ULL, 0x0000004e240c723cULL, 0x000fe2000000180cULL,
0x0000002b2c2c8232ULL, 0x082fe40000000000ULL, 0x0000002b2e2e8232ULL, 0x000fc40000000000ULL,
0x000000002d2d8232ULL, 0x080fe40000000000ULL, 0x00000064ff24723eULL, 0x080fe200020006ffULL,
0x000000002f2f8232ULL, 0x000fe20000000000ULL, 0x00000065ff25723eULL, 0x080fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400030006ffULL, 0x00000065ff65723eULL, 0x000fc600030006ffULL,
0x000000242c10723cULL, 0x040fee0000001810ULL, 0x00000066ff24723eULL, 0x080fe200020006ffULL,
0x000000642c14723cULL, 0x000fe20000001814ULL, 0x00000067ff25723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fc400030006ffULL, 0x00000067ff67723eULL, 0x000fc600030006ffULL,
0x000000242c18723cULL, 0x040fe20000001818ULL, 0x0000312030307816ULL, 0x004fe400000000ffULL,
0x0000312031317816ULL, 0x000fe400000000ffULL, 0x0000312032327816ULL, 0x000fe400000000ffULL,
0x00000030ff24723eULL, 0x000fe200020006ffULL, 0x000000662c04723cULL, 0x000fe20000001804ULL,
0x00000031ff25723eULL, 0x000fe400020006ffULL, 0x0000312033337816ULL, 0x000fc400000000ffULL,
0x00000030ff30723eULL, 0x000fe400030006ffULL, 0x00000031ff31723eULL, 0x000fe200030006ffULL,
0x000000242c08723cULL, 0x040fee0000001808ULL, 0x00000032ff24723eULL, 0x000fe200020006ffULL,
0x000000302c1c723cULL, 0x000fe2000000181cULL, 0x00000033ff25723eULL, 0x000fc400020006ffULL,
0x00000032ff32723eULL, 0x000fe400030006ffULL, 0x00000033ff33723eULL, 0x000fc600030006ffULL,
0x000000242c20723cULL, 0x040ff00000001820ULL, 0x000000322c0c723cULL, 0x000fe2000000180cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020003e247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c049497810ULL, 0x000fe20007ffe0ffULL, 0x00f698004cff7f8cULL, 0x0009e2000c80043fULL,
0x000000ffff267224ULL, 0x004fe200078e0025ULL, 0x000000013f277812ULL, 0x000fe200078e0cffULL,
0x000000ffff5d7224ULL, 0x008fe200078e0029ULL, 0x000000344900720cULL, 0x000fda0003f06070ULL,
0x0000132000000947ULL, 0x000fea0003800000ULL, 0x0000040062257984ULL, 0x010ea40000000800ULL,
0x8000000025ff7812ULL, 0x004fe40007804826ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x000024003e257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x004fe40007804826ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe20003800000ULL,
0x000024003e257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x004fc40007804826ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff487819ULL, 0x000fe20000011635ULL,
0x00000080ff4b7424ULL, 0x000fe200078e00ffULL, 0x0000030003257a10ULL, 0x000fe20007ffe0ffULL,
0x00000000560473c2ULL, 0x0004e200000e0000ULL, 0x00000003ff2f7819ULL, 0x000fe40000011636ULL,
0x0000000125277810ULL, 0x040fe20007ffe0ffULL, 0x0000000825007824ULL, 0x000fe200078e0248ULL,
0x000000042f317810ULL, 0x000fe40007ffe0ffULL, 0x000000022700720cULL, 0x000fe20003f06070ULL,
0x0000002000007824ULL, 0x000fe200078e00ffULL, 0x000000082f337810ULL, 0x000fc40007ffe0ffULL,
0x0000000c2f497810ULL, 0x000fe20007ffe0ffULL, 0x00006200372e7a24ULL, 0x000fe200078e0200ULL,
0x00000000342b7217ULL, 0x000fc80007800000ULL, 0x0000002f2e247210ULL, 0x140fe20007ffe039ULL,
0x000000012b2b7824ULL, 0x000fe200078e0a00ULL, 0x000000312e267210ULL, 0x000fc60007ffe039ULL,
0x00005e0024247625ULL, 0x000fe200078e004bULL, 0x000000202b007807ULL, 0x000fc60000000000ULL,
0x00005e0026267625ULL, 0x000fe200078e004bULL, 0x0000000039007217ULL, 0x000fe40007800000ULL,
0x00000042242a7210ULL, 0x080fe40007f5e0ffULL, 0x00000042262c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000100007824ULL, 0x100fe200078e0a39ULL, 0x000000332e247210ULL, 0x040fe20007ffe039ULL,
0x000000ffff2b7224ULL, 0x000fe200010e0625ULL, 0x000000492e267210ULL, 0x000fe20007ffe039ULL,
0x000000ffff2d7224ULL, 0x000fe200000e0627ULL, 0x000000002f00720cULL, 0x080fe20003f06070ULL,
0x00005e0024247625ULL, 0x000fe200078e004bULL, 0x000000003100720cULL, 0x000fc40003f46070ULL,
0x000000003300720cULL, 0x080fe20003f66070ULL, 0x00005e0026267625ULL, 0x000fe200078e004bULL,
0x000000004900720cULL, 0x000fe40003f86070ULL, 0x0000004224247210ULL, 0x080fe40007fbe0ffULL,
0x0000004226267210ULL, 0x000fe40007fde0ffULL, 0x0000000859007812ULL, 0x000fe200078ec0ffULL,
0x000000ffff257224ULL, 0x000fe200028e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a557faeULL, 0x0009e2000c101c46ULL, 0x000000ffff277224ULL, 0x000fc400030e0627ULL,
0x0000000157577824ULL, 0x000fe200078e0200ULL, 0x000000002c547faeULL, 0x0009e8000d101c46ULL,
0x0000000024537faeULL, 0x0009e8000d901c46ULL, 0x0000000026527faeULL, 0x0009e8000e101c46ULL,
0x0000000000007918ULL, 0x004fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x008fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000057247f8cULL, 0x0104e8000c80043fULL, 0x000004005a2b7984ULL, 0x0005220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6680041267f8cULL, 0x000fe2000c80043fULL, 0x800000002bff7812ULL, 0x010fc60007844829ULL,
0x00f66c00412d7984ULL, 0x000f240000000800ULL, 0x800000002dff7812ULL, 0x010fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x000000ffff5d7224ULL, 0x008fe200078e0025ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000240000735dULL, 0x010fe20003800000ULL,
0x00f66c0041257984ULL, 0x000ee40000000800ULL, 0x8000000025ff7812ULL, 0x008fc40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018042437810ULL, 0x000fca0007ffe043ULL,
0x0000000144437824ULL, 0x000fca00078e0243ULL, 0x00f0000043257984ULL, 0x000ee80000000800ULL,
0x00f2000043007984ULL, 0x0008620000000800ULL, 0x0000003c2500720bULL, 0x008fe20003f1d000ULL,
0x00008e827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x010fc800000e0100ULL,
0x0000ffff24277812ULL, 0x000fe2000780c0ffULL, 0x000003e000007945ULL, 0x000fe20003800000ULL,
0x00000001ff247424ULL, 0x000fd600078e00ffULL, 0x000003b000008947ULL, 0x000fea0003800000ULL,
0x0000000335247811ULL, 0x000fe400078ff0ffULL, 0x0000003c2500720bULL, 0x000fe40003f14000ULL,
0x000000352400720cULL, 0x000fe20003f65270ULL, 0x00008e427f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x000000253c2a7209ULL, 0x000fe20007810000ULL,
0x00000080352bb824ULL, 0x000fe200078e0242ULL, 0x0000ffff24247812ULL, 0x000fe400078e3cffULL,
0x00000002ff317819ULL, 0x000fe20000011636ULL, 0x00000001442bb824ULL, 0x000fe200078e022bULL,
0x8000002a3c267221ULL, 0x000fe20000010000ULL, 0x0000002427ff7212ULL, 0x000fc6000780c0ffULL,
0x3fb8aa3b26267820ULL, 0x000fe20000410000ULL, 0x00f4002a2b00b388ULL, 0x0007e60000000800ULL,
0x0000002600307308ULL, 0x000f240000000800ULL, 0x000000303d3d7220ULL, 0x010fe20000410000ULL,
0x00008dc27f007947ULL, 0x000fea000b800000ULL, 0x00001f3130247589ULL, 0x00872400000e0000ULL,
0x0000002410107220ULL, 0x090fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x0000002404047220ULL, 0x080fe20000410000ULL, 0x0000002405057220ULL, 0x080fe20000410000ULL,
0x0000002408087220ULL, 0x080fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002420207220ULL, 0x080fe20000410000ULL, 0x0000002421217220ULL, 0x080fe20000410000ULL,
0x000000240c0c7220ULL, 0x080fe20000410000ULL, 0x000000240d0d7220ULL, 0x000fe20000410000ULL,
0x00008d027f007947ULL, 0x000fea000b800000ULL, 0x00001f4630247589ULL, 0x0008a400000e0000ULL,
0x8000002a25250221ULL, 0x100fe20000010000ULL, 0x00000001ff267807ULL, 0x000fe20000000000ULL,
0x0000002412127220ULL, 0x084fe20000410000ULL, 0x0000002413137220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b25250820ULL, 0x000fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002417177220ULL, 0x080fe20000410000ULL, 0x000000241a1a7220ULL, 0x080fe20000410000ULL,
0x0000002500400308ULL, 0x000ea20000000800ULL, 0x000000241b1b7220ULL, 0x080fe20000410000ULL,
0x0000002406067220ULL, 0x080fe20000410000ULL, 0x0000002407077220ULL, 0x080fe20000410000ULL,
0x000000240a0a7220ULL, 0x080fe20000410000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x000000241e1e7220ULL, 0x080fe20000410000ULL, 0x000000241f1f7220ULL, 0x080fe20000410000ULL,
0x0000002422227220ULL, 0x080fe20000410000ULL, 0x0000002423237220ULL, 0x080fe20000410000ULL,
0x000000240e0e7220ULL, 0x080fe20000410000ULL, 0x000000240f0f7220ULL, 0x000fe20000410000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e002aULL, 0x0000761026247816ULL, 0x000fe20000000024ULL,
0x0000000040000220ULL, 0x006fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000003d003d7221ULL, 0x002fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x000000083f007824ULL, 0x000fe200078e00ffULL,
0xfffffff038257812ULL, 0x000fc800078ec0ffULL, 0x0000000800007812ULL, 0x000fca00078e0cffULL,
0x0000000100267824ULL, 0x000fca00078e0225ULL, 0x00f6ac0026257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000257305ULL, 0x000364000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000250000735dULL, 0x020fe40003800000ULL, 0x00f6ac0026257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fc40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff317819ULL, 0x008fe40000011636ULL, 0x00000040ff00723eULL, 0x000fe400000000ffULL,
0x0000001831257810ULL, 0x040fe40007ffe0ffULL, 0x0000001031267810ULL, 0x000fe40007ffe0ffULL,
0x0000541000307816ULL, 0x010fe20000000000ULL, 0x00008a427f007947ULL, 0x000fea000b800000ULL,
0x00001f3130297589ULL, 0x0002e400000e0000ULL, 0x00008a827f007947ULL, 0x000fea000b800000ULL,
0x00001f4630007589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff317224ULL, 0x002fe200078e0026ULL, 0x00005bf0002e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff327424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x000090a000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff317224ULL, 0x002fe200078e0025ULL, 0x00005c50002e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff327424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0000904000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000005f2c783bULL, 0x004ea20000004200ULL, 0x0000991024247816ULL, 0x000fc600000000ffULL,
0x00a800004744783bULL, 0x010f220000000200ULL, 0x000000ff2400720cULL, 0x000fc60003f05270ULL,
0x000000005b58783bULL, 0x000f620000004200ULL, 0x000031202c2c7816ULL, 0x004fe400000000ffULL,
0x000031202d2d7816ULL, 0x000fe400000000ffULL, 0x0000002cff24723eULL, 0x000fca00020006ffULL,
0x0000002944448232ULL, 0x098fe20000000000ULL, 0x0000002dff25723eULL, 0x080fe200020006ffULL,
0x0000002946468232ULL, 0x000fe20000000000ULL, 0x000031202e2e7816ULL, 0x000fe200000000ffULL,
0x0000000045458232ULL, 0x082fe20000000000ULL, 0x000031202f2f7816ULL, 0x000fe200000000ffULL,
0x0000000047478232ULL, 0x000fe20000000000ULL, 0x0000002cff2c723eULL, 0x000fe400030006ffULL,
0x0000002dff2d723eULL, 0x000fe400030006ffULL, 0x0000312058587816ULL, 0x020fc400000000ffULL,
0x000000244430723cULL, 0x040fe20000001810ULL, 0x0000312059597816ULL, 0x000fe200000000ffULL,
0x00a800004a24783bULL, 0x000e620000000200ULL, 0x000031205a5a7816ULL, 0x000fe400000000ffULL,
0x000031205b5b7816ULL, 0x000fe400000000ffULL, 0x0000002eff10723eULL, 0x080fe200020006ffULL,
0x0000002c4450723cULL, 0x000fe20000001814ULL, 0x0000002fff11723eULL, 0x000fe200020006ffULL,
0x000000005c14783bULL, 0x000ea20000004200ULL, 0x0000002eff2e723eULL, 0x000fc400030006ffULL,
0x0000002fff2f723eULL, 0x000fc600030006ffULL, 0x000000104454723cULL, 0x040ff00000001818ULL,
0x0000002e442c723cULL, 0x000fee0000001804ULL, 0x00000058ff04723eULL, 0x000fc400020006ffULL,
0x00000059ff05723eULL, 0x080fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400030006ffULL,
0x00000059ff59723eULL, 0x000fc600030006ffULL, 0x000000044464723cULL, 0x040fe20000001808ULL,
0x0000000025258232ULL, 0x082fe40000000000ULL, 0x0000000027278232ULL, 0x000fe40000000000ULL,
0x0000002924248232ULL, 0x080fe40000000000ULL, 0x0000005aff04723eULL, 0x080fe200020006ffULL,
0x000000584468723cULL, 0x000fe2000000181cULL, 0x00000000601c783bULL, 0x000e620000004200ULL,
0x0000005bff05723eULL, 0x000fe200020006ffULL, 0x0000002926268232ULL, 0x000fe20000000000ULL,
0x0000005aff5a723eULL, 0x000fc400030006ffULL, 0x0000005bff5b723eULL, 0x000fe400030006ffULL,
0x0000312016007816ULL, 0x004fe200000000ffULL, 0x00000004446c723cULL, 0x040fe20000001820ULL,
0x0000312014147816ULL, 0x000fe400000000ffULL, 0x0000312015157816ULL, 0x000fe400000000ffULL,
0x00000000ff18723eULL, 0x080fe400020006ffULL, 0x0000312017057816ULL, 0x000fe200000000ffULL,
0x0000005a4444723cULL, 0x000fe2000000180cULL, 0x00000000ff04723eULL, 0x000fc400030006ffULL,
0x00000014ff10723eULL, 0x080fe400020006ffULL, 0x00000015ff11723eULL, 0x000fe400020006ffULL,
0x00000005ff19723eULL, 0x000fe400020006ffULL, 0x00000014ff14723eULL, 0x000fe400030006ffULL,
0x00000015ff15723eULL, 0x000fe200030006ffULL, 0x000000102410723cULL, 0x000fe20000001830ULL,
0x00000005ff05723eULL, 0x000fce00030006ffULL, 0x000000142414723cULL, 0x000fe20000001850ULL,
0x000031201c1c7816ULL, 0x002fe400000000ffULL, 0x000031201d1d7816ULL, 0x000fe400000000ffULL,
0x000031201f0d7816ULL, 0x000fc600000000ffULL, 0x000000182418723cULL, 0x040fe20000001854ULL,
0x000031201e007816ULL, 0x000fe400000000ffULL, 0x0000001cff08723eULL, 0x080fe400020006ffULL,
0x0000001dff09723eULL, 0x000fe400020006ffULL, 0x0000000dff21723eULL, 0x000fe200020006ffULL,
0x000000042404723cULL, 0x000fe2000000182cULL, 0x0000001cff1c723eULL, 0x000fe400030006ffULL,
0x0000001dff1d723eULL, 0x000fc400030006ffULL, 0x00000000ff20723eULL, 0x080fe400020006ffULL,
0x00000000ff0c723eULL, 0x000fe200030006ffULL, 0x000000082408723cULL, 0x000fe20000001864ULL,
0x0000000dff0d723eULL, 0x000fce00030006ffULL, 0x0000001c241c723cULL, 0x040ff00000001868ULL,
0x000000202420723cULL, 0x040ff0000000186cULL, 0x0000000c240c723cULL, 0x000fe20000001844ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020003e247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a0004cff7f8cULL, 0x0007e2000c80043fULL, 0x000000013f277812ULL, 0x000fe200078ec0ffULL,
0x000000ffff267224ULL, 0x004fc400078e0025ULL, 0x0000030003037a10ULL, 0x018fc80007ffe0ffULL,
0x000000020300720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffaa9000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x004ea20000002500ULL,
0x000000ffff377224ULL, 0x000fe400078e000eULL, 0x000000ffff287224ULL, 0x000fe400078e0021ULL,
0x000000ffff267224ULL, 0x000fe400078e001fULL, 0x000000ffff2a7224ULL, 0x000fe400078e0023ULL,
0x000000ffff317224ULL, 0x000fe400078e0022ULL, 0x000000ffff2f7224ULL, 0x000fc400078e0020ULL,
0x000000ffff2d7224ULL, 0x000fe400078e001eULL, 0x000000ffff247224ULL, 0x008fe400078e001dULL,
0x000000ffff2b7224ULL, 0x000fe400078e001cULL, 0x000000ffff217224ULL, 0x000fe400078e001bULL,
0x000000ffff1f7224ULL, 0x000fe400078e0019ULL, 0x000000ffff0e7224ULL, 0x000fe200078e0017ULL,
0x0000000402007c0cULL, 0x004fe2000bf03070ULL, 0x000000ffff2e7224ULL, 0x000fc400078e000fULL,
0x000000ffff2c7224ULL, 0x000fe400078e000dULL, 0x000000ffff337224ULL, 0x000fe400078e000cULL,
0x000000ffff227224ULL, 0x000fe400078e000bULL, 0x000000ffff297224ULL, 0x000fe400078e000aULL,
0x000000ffff207224ULL, 0x000fe400078e0009ULL, 0x000000ffff277224ULL, 0x000fc400078e0008ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0007ULL, 0x000000ffff257224ULL, 0x000fe400078e0006ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0005ULL, 0x000000ffff237224ULL, 0x000fe400078e0004ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0016ULL, 0x000000ffff1b7224ULL, 0x000fc400078e0015ULL,
0x000000ffff197224ULL, 0x000fe400078e0013ULL, 0x000000ffff177224ULL, 0x000fe200078e0011ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x018000003d007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000064e000067802ULL, 0x000fe40000000f00ULL, 0x000085e000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0004ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003d00007308ULL, 0x000ea40000001000ULL, 0xbf80000000027423ULL, 0x004fc8000000003dULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff037624ULL, 0x000fe400078e00ffULL,
0x00006600ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000047919ULL, 0x000ee80000000000ULL, 0x0000000000077919ULL, 0x000f220000000000ULL,
0x00000002ff067819ULL, 0x008fe40000011604ULL, 0x0000000807047811ULL, 0x010fe200078ff0ffULL,
0x0000000003057220ULL, 0x004fca0000410000ULL, 0x00001f0605007589ULL, 0x000ea800000e0000ULL,
0x00001f0405047589ULL, 0x000ee200000e0000ULL, 0x0000001000107220ULL, 0x044fe20000410000ULL,
0x0000001700177220ULL, 0x040fe20000410000ULL, 0x0000001400147220ULL, 0x040fe20000410000ULL,
0x0000001b001b7220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001f001f7220ULL, 0x040fe20000410000ULL, 0x0000002300237220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000002700277220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002b002b7220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002f002f7220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000003300337220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x000fe20000410000ULL, 0x0000001204127220ULL, 0x048fe20000410000ULL,
0x0000001904197220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x040fe20000410000ULL,
0x0000000e040e7220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000003704377220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x000fe20000410000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000203007812ULL, 0x004fc400078ec0ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011603ULL, 0x0000000200047811ULL, 0x040fe400078ff8ffULL,
0x0000000400067811ULL, 0x000fe400078ff8ffULL, 0x0000000803157811ULL, 0x000fe400078ff0ffULL,
0x00000001ff027819ULL, 0x000fe40000011600ULL, 0x0000000704057812ULL, 0x000fc400078e780dULL,
0x00000006000a7811ULL, 0x000fe400078ff8ffULL, 0x0000000706087812ULL, 0x040fe200078e780dULL,
0x000000080d097824ULL, 0x000fe200078e0205ULL, 0x0000000706067812ULL, 0x000fe200078e7815ULL,
0x000010003b057824ULL, 0x000fe200078e00ffULL, 0x0000000702007812ULL, 0x100fe200078e780dULL,
0x000000080d0b7824ULL, 0x000fe200078e0208ULL, 0x000000070a0c7812ULL, 0x000fe200078e780dULL,
0x0000000815137824ULL, 0x000fe200078e0206ULL, 0x0000000704047812ULL, 0x100fe200078e7815ULL,
0x0000000803067824ULL, 0x000fe200078e00ffULL, 0x0000000702027812ULL, 0x100fe200078e7815ULL,
0x000000080d077824ULL, 0x000fe200078e0200ULL, 0x000000070a0a7812ULL, 0x000fe200078e7815ULL,
0x0000000815117824ULL, 0x040fe200078e0204ULL, 0x00000002150f7211ULL, 0x000fe200078e18ffULL,
0x0000080048007824ULL, 0x000fe200078e0205ULL, 0x0000000806067812ULL, 0x000fe200078ec0ffULL,
0x000000080d0d7824ULL, 0x000fe200078e020cULL, 0x000000101702723eULL, 0x000fe200000000ffULL,
0x0000000815157824ULL, 0x000fe200078e020aULL, 0x000000141b04723eULL, 0x000fe200000000ffULL,
0x0000001007077824ULL, 0x000fc400078e0200ULL, 0x0000001009097824ULL, 0x000fe200078e0200ULL,
0x0000541002167816ULL, 0x040fe20000000004ULL, 0x000000100b0b7824ULL, 0x000fe200078e0200ULL,
0x0000763202177816ULL, 0x000fe20000000004ULL, 0x000000100f0f7824ULL, 0x100fe200078e0200ULL,
0x000000272002723eULL, 0x000fe200000000ffULL, 0x0000001011117824ULL, 0x100fe200078e0200ULL,
0x0000002b2404723eULL, 0x000fe200000000ffULL, 0x000000100d0d7824ULL, 0x100fe400078e0200ULL,
0x0000001013137824ULL, 0x000fc400078e0200ULL, 0x0000001015157824ULL, 0x000fe400078e0200ULL,
0x0000000107087824ULL, 0x000fe200078e0206ULL, 0x000000231c07723eULL, 0x000fe200000000ffULL,
0x0000000106097824ULL, 0x040fe400078e0209ULL, 0x00000001060b7824ULL, 0x040fe200078e020bULL,
0x0000001608007388ULL, 0x0005e20000000a00ULL, 0x00000001060f7824ULL, 0x040fe400078e020fULL,
0x0000000106117824ULL, 0x000fc400078e0211ULL, 0x00000001060d7824ULL, 0x040fe400078e020dULL,
0x0000000106137824ULL, 0x040fe400078e0213ULL, 0x0000000106157824ULL, 0x000fe200078e0215ULL,
0x000000181f06723eULL, 0x000fe200000000ffULL, 0x00000020480a7824ULL, 0x000fe200078e0203ULL,
0x0000541002087816ULL, 0x004fe20000000004ULL, 0x00000300ff147624ULL, 0x000fe200078e00ffULL,
0x0000541006167816ULL, 0x140fe40000000007ULL, 0x0000763206177816ULL, 0x000fc40000000007ULL,
0x0000002f2806723eULL, 0x000fe400000000ffULL, 0x000000332c07723eULL, 0x000fe200000000ffULL,
0x0000001609007388ULL, 0x0005e20000000a00ULL, 0x000000011400780cULL, 0x000fe40003f05270ULL,
0x0000763202097816ULL, 0x004fe40000000004ULL, 0x000000121902723eULL, 0x000fe400000000ffULL,
0x0000001d0e04723eULL, 0x000fe200000000ffULL, 0x000000080b007388ULL, 0x0005e40000000a00ULL,
0x0000541006087816ULL, 0x004fe20000000007ULL, 0x000000100a0b7824ULL, 0x000fe200078e0205ULL,
0x0000763206097816ULL, 0x000fc40000000007ULL, 0x0000001a2106723eULL, 0x000fe400000000ffULL,
0x000000251e07723eULL, 0x000fe200000000ffULL, 0x000000080d007388ULL, 0x0005e40000000a00ULL,
0x0000541002087816ULL, 0x144fe40000000004ULL, 0x0000763202097816ULL, 0x000fe40000000004ULL,
0x000000292202723eULL, 0x000fe400000000ffULL, 0x0000002d2604723eULL, 0x000fe200000000ffULL,
0x000000080f007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x004fc40000000007ULL,
0x0000763206097816ULL, 0x000fe40000000007ULL, 0x000000312a06723eULL, 0x000fe400000000ffULL,
0x000000372e07723eULL, 0x000fe200000000ffULL, 0x0000000811007388ULL, 0x0005e40000000a00ULL,
0x0000541002087816ULL, 0x144fe40000000004ULL, 0x0000763202097816ULL, 0x000fca0000000004ULL,
0x0000000813007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x144fe40000000007ULL,
0x0000763206097816ULL, 0x000fca0000000007ULL, 0x0000000815007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000000b0c7984ULL, 0x000ea80000000c00ULL,
0x000400000b1c7984ULL, 0x000ee80000000c00ULL, 0x000800000b187984ULL, 0x000f280000000c00ULL,
0x000c00000b207984ULL, 0x000f620000000c00ULL, 0x200000ff0f0f7230ULL, 0x004fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x008fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fc40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x0000001b0f0f7230ULL, 0x010fe40000000000ULL,
0x0000001a0e0e7230ULL, 0x000fe40000000000ULL, 0x000000190d0d7230ULL, 0x000fe40000000000ULL,
0x000000180c0c7230ULL, 0x000fe40000000000ULL, 0x000000231f1f7230ULL, 0x020fc40000000000ULL,
0x000000221e1e7230ULL, 0x000fe20000000000ULL, 0x0000000c0b007388ULL, 0x0005e20000000c00ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fca0000000000ULL,
0x0004001c0b007388ULL, 0x0005e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00002f2000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x004ea20000002700ULL,
0x0000580014027a24ULL, 0x000fe200078e02ffULL, 0x0000000148ff7812ULL, 0x000fe2000780f835ULL,
0x00000800ff097424ULL, 0x000fe200078e00ffULL, 0x0000000000077919ULL, 0x000ea20000002600ULL,
0x0000640002067a24ULL, 0x000fe200078e02ffULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000004003b047824ULL, 0x000fe200078e00ffULL, 0x000000000b107984ULL, 0x0007220000000c00ULL,
0x000000ff0300720cULL, 0x000fc40000725670ULL, 0x000007ff06027811ULL, 0x040fe400078e40ffULL,
0x01ffffff06067812ULL, 0x000fe200078ec0ffULL, 0x000058000e0e7a24ULL, 0x004fc800078e0207ULL,
0x000003000e077a24ULL, 0x000fca00078e02ffULL, 0x00000004070f7c10ULL, 0x000fc8000fffe0ffULL,
0x0000000f02087211ULL, 0x000fca00078fa8ffULL, 0x00006a0008087625ULL, 0x000fca00078e0009ULL,
0x00000004080c7210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fc800010e0609ULL,
0x000000100a0c7825ULL, 0x000fe200078e000cULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001003087824ULL, 0x018fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x000000010f0a7824ULL, 0x000fe200078e0206ULL,
0x0000007008157812ULL, 0x000fe400078ec0ffULL, 0x0000000c09167812ULL, 0x000fe200078ec0ffULL,
0x00006a000f087625ULL, 0x000fc800078e000bULL, 0x00006a000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000816087210ULL, 0x000fc80007a1e015ULL, 0x0000000a160a7210ULL, 0x000fe40007c7e015ULL,
0x00000009ff097210ULL, 0x000fe400007e44ffULL, 0x0000000bff0b7210ULL, 0x000fc60001fe84ffULL,
0x0000003c08007986ULL, 0x0005e8000c101906ULL, 0x0000003d0a007986ULL, 0x0005e4000c101906ULL,
0x0000000000007941ULL, 0x018fea0003800000ULL, 0x000000100c007986ULL, 0x0007e2000c101d06ULL,
0x0000011000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff097424ULL, 0x004fe200078e00ffULL,
0xffffffff140b7810ULL, 0x000fc60007ffe0ffULL, 0x000068000e087625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b080879a8ULL, 0x000ea400099ee1c6ULL, 0x0000000b0800720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0a7807ULL, 0x000fca0000000000ULL,
0x0000000aff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff087984ULL, 0x004ea40000000000ULL,
0x000000ff0800720cULL, 0x004fda0003f05270ULL, 0x00002b7000008947ULL, 0x000fea0003800000ULL,
0x000000ff3500720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0000001003087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011603ULL,
0x00000080ff177424ULL, 0x000fe200078e00ffULL, 0x00000001070a7810ULL, 0x000fe40007ffe0ffULL,
0x0000007008197812ULL, 0x000fe400078ec0ffULL, 0x0000000c090e7812ULL, 0x000fe200078ec0ffULL,
0x00006a0007087625ULL, 0x000fc800078e0017ULL, 0x00006a000a0a7625ULL, 0x000fe200078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x0000000a0e0a7210ULL, 0x000fe40007b5e019ULL,
0x00000009ff097210ULL, 0x000fe400007e24ffULL, 0x0000000bff0b7210ULL, 0x000fc600017e64ffULL,
0x00000006080c7981ULL, 0x008568000c1e1900ULL, 0x000000060a0d7981ULL, 0x000562000c1e1900ULL,
0x000000021400780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x0000000207087810ULL, 0x004fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080f7981ULL, 0x000562000c1e1900ULL, 0x000000041400780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x0000000307087810ULL, 0x004fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608117981ULL, 0x000562000c1e1900ULL,
0x000000041400780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x0000000407087810ULL, 0x004fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608137981ULL, 0x000562000c1e1900ULL, 0x000000061400780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000000507087810ULL, 0x004fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608157981ULL, 0x000562000c1e1900ULL,
0x000000061400780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081400780cULL, 0x004fe40003f06070ULL, 0x0000000607087810ULL, 0x000fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fe40007a3e019ULL,
0x00000007070a0810ULL, 0x000fe40007ffe0ffULL, 0x00000009ff097210ULL, 0x000fc60000fe44ffULL,
0x00006a000a0a0625ULL, 0x000fe400078e0017ULL, 0x0000000608177981ULL, 0x000566000c1e1900ULL,
0x0000000a0e0a0210ULL, 0x000fc80007c7e019ULL, 0x0000000bff0b0210ULL, 0x000fcc0001fe84ffULL,
0x000000060a0b0981ULL, 0x000566000c1e1900ULL, 0x0000000714087810ULL, 0x004fc80007ffe0ffULL,
0x00000003ff0a7819ULL, 0x000fc80000011608ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff197224ULL, 0x000fe400078e00ffULL,
0x000000ffff1b7224ULL, 0x020fe400078e000cULL, 0x00000008190e7824ULL, 0x040fe200078e00ffULL,
0x0000000119197810ULL, 0x000fc80007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x0000000a1900720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x024fea0003800000ULL,
0x000000080e087810ULL, 0x040fe40007ffe0ffULL, 0x000000010e097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001b0c0c7209ULL, 0x008fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x00000070101b7812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e01bULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006081b7981ULL, 0x000568000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090e087810ULL, 0x044fe40007ffe0ffULL,
0x000000020e097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000d0c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030d7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080d7981ULL, 0x000568000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0e087810ULL, 0x044fe40007ffe0ffULL, 0x000000030e097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000f0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030f7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e00fULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080f7981ULL, 0x000568000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0e087810ULL, 0x044fe40007ffe0ffULL,
0x000000040e097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000110c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010117812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x000fc80007b3e011ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608117981ULL, 0x000568000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0e087810ULL, 0x044fe40007ffe0ffULL, 0x000000050e097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000130c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010137812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e013ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608137981ULL, 0x000568000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0e087810ULL, 0x044fe40007ffe0ffULL,
0x000000060e097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000150c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010157812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x000fc80007b3e015ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608157981ULL, 0x000568000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0e087810ULL, 0x044fe40007ffe0ffULL, 0x000000070e097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000170c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010177812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x000fc80007b3e017ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608177981ULL, 0x000568000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0e087810ULL, 0x004fe40007ffe0ffULL,
0x0000000b0c0c7209ULL, 0x000fe40007810000ULL, 0x0000030008007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030b7824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x000000700b0b7812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007a3e00bULL, 0x00000009ff097210ULL, 0x000fca0000fe44ffULL,
0x00000006080b7981ULL, 0x000568000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000f240000000000ULL, 0x0000001003087824ULL, 0x014fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fc80000011603ULL, 0x0000007008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097812ULL, 0x000fca00078ec0ffULL, 0x0000000109097824ULL, 0x000fca00078e0208ULL,
0x0000000c09007388ULL, 0x0205e40000000800ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x0000001003097824ULL, 0x004fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011603ULL,
0x0000000148117824ULL, 0x008fe200078e0207ULL, 0x00000002ff0c7819ULL, 0x000fe20000011635ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000070090a7812ULL, 0x000fe200078ec0ffULL,
0x00000800ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000020035357824ULL, 0x000fe200078e00ffULL, 0x0000001102087211ULL, 0x000fe200078fa8ffULL,
0x000000013a3a7824ULL, 0x000fe200078e0205ULL, 0x000010d000007945ULL, 0x000fe20003800000ULL,
0x000000010b307824ULL, 0x000fe200078e020aULL, 0x000000010c0a7812ULL, 0x000fe200078ec0ffULL,
0x00000002480b8824ULL, 0x100fe200078e023bULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00006a0008087625ULL, 0x000fe200078e000dULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000020b0c8824ULL, 0x100fe200078e020aULL, 0x00000800350b7812ULL, 0x000fe200078ec0ffULL,
0x00000002480d8824ULL, 0x000fe200078e023bULL, 0x0000000408087210ULL, 0x000fe20007f3e0ffULL,
0x00000001060e8824ULL, 0x000fe200078e0211ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000080ff0f8424ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000080ff108424ULL, 0x000fe200078e00ffULL, 0x0000000030307984ULL, 0x000ea20000000800ULL,
0x000000020d128824ULL, 0x000fe200078e020aULL, 0x00000020030d7810ULL, 0x000fe20007ffe0ffULL,
0x000000013a0a7824ULL, 0x000fe200078e020bULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000030048007a0cULL, 0x000fe20003f26070ULL,
0x00006a000e0e8625ULL, 0x000fe200078e000fULL, 0x0000000000267805ULL, 0x000fc6000001ff00ULL,
0x00006a0011108625ULL, 0x000fc800078e0010ULL, 0x000000080c158824ULL, 0x100fe400078e0203ULL,
0x0000000812128824ULL, 0x000fe400078e0203ULL, 0x0000001003137824ULL, 0x000fe200078e020aULL,
0x0000458015158811ULL, 0x000fe200078e20ffULL, 0x00000010030a7825ULL, 0x000fe200078e0008ULL,
0x0000418012178811ULL, 0x000fc600078e20ffULL, 0x000000100d0c7825ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000a137faeULL, 0x0007e2000b901c46ULL,
0x0000000000087805ULL, 0x000fe4000001ff00ULL, 0x00000010030e8825ULL, 0x040fe200078e000eULL,
0x003800000c137faeULL, 0x0009e6000b901c46ULL, 0x0000001003108825ULL, 0x000fe200078e0010ULL,
0x000000000e158faeULL, 0x000be6000b901c46ULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0x0000000010178faeULL, 0x0003e2000b901c46ULL, 0x00000000000a7805ULL, 0x008fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000c7805ULL, 0x010fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x020fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x002fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000d6000001947ULL, 0x000fea0003800000ULL,
0x000000ff00087202ULL, 0x004fe20000000f00ULL, 0x000000ffff327224ULL, 0x000fca00078e0048ULL,
0x0000000232347810ULL, 0x000fe20007ffe0ffULL, 0x0000029000017945ULL, 0x000fe60003800000ULL,
0x0000030034007a0cULL, 0x000fda0003f06070ULL, 0x0000026000000947ULL, 0x000fea0003800000ULL,
0x000000070300780cULL, 0x000fe20003f24070ULL, 0x00000001072f7824ULL, 0x100fe200078e0234ULL,
0x00000001ff287819ULL, 0x000fe20000011634ULL, 0x00000800ff2e7424ULL, 0x000fe200078e00ffULL,
0x0000002003377810ULL, 0x000fe20007ffe0ffULL, 0x00000400342a7824ULL, 0x000fe200078e00ffULL,
0x0000002f02297211ULL, 0x000fe400078fa8ffULL, 0x00000001282c7812ULL, 0x000fc600078ec0ffULL,
0x00006a0029287625ULL, 0x000fc800078e002eULL, 0x00000002482d9824ULL, 0x000fe200078e023bULL,
0x0000000428287210ULL, 0x000fe20007f1e0ffULL, 0x00000001062b9824ULL, 0x000fe400078e022fULL,
0x000000022d369824ULL, 0x100fe200078e022cULL, 0x000008002a2d7812ULL, 0x000fe200078ec0ffULL,
0x0000000248339824ULL, 0x000fe400078e023bULL, 0x00000080ff2e9424ULL, 0x000fe400078e00ffULL,
0x00000002333c9824ULL, 0x000fc400078e022cULL, 0x00006a002b2a9625ULL, 0x000fc800078e002eULL,
0x00000080ff389424ULL, 0x000fe400078e00ffULL, 0x000000013a2c7824ULL, 0x000fe400078e022dULL,
0x000000ffff297224ULL, 0x000fe400000e0629ULL, 0x00006a002f2e9625ULL, 0x000fc800078e0038ULL,
0x0000001003337824ULL, 0x040fe400078e022cULL, 0x0000000836359824ULL, 0x000fe400078e0203ULL,
0x00000010032c9825ULL, 0x000fc600078e002aULL, 0x0000458035359811ULL, 0x000fe200078e20ffULL,
0x000000083c3c9824ULL, 0x000fe400078e0203ULL, 0x00000010372a7825ULL, 0x000fc600078e0028ULL,
0x000041803c379811ULL, 0x000fe200078e20ffULL, 0x0000001003287825ULL, 0x000fc800078e0028ULL,
0x00000010032e9825ULL, 0x000fe200078e002eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000028337faeULL, 0x0003e8000b901c46ULL, 0x003800002a337faeULL, 0x0003e8000b901c46ULL,
0x000000002c359faeULL, 0x0003e8000b901c46ULL, 0x000000002e379faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff2d7224ULL, 0x002fe200078e0032ULL, 0x00000001ff2a7819ULL, 0x000fe20000011603ULL,
0x00000002482b7824ULL, 0x000fe200078e023bULL, 0x00000002ff337819ULL, 0x000fe20000011603ULL,
0x000000402d287824ULL, 0x000fe200078e00ffULL, 0x0000000c2a2a7812ULL, 0x000fe200078ec0ffULL,
0x0000001003297824ULL, 0x000fe200078e00ffULL, 0x00000007333c7812ULL, 0x040fe200078ec0ffULL,
0x00000008332f7824ULL, 0x040fe200078e00ffULL, 0x0000008028287812ULL, 0x000fe200078ec0ffULL,
0x0000000833357824ULL, 0x000fe200078e00ffULL, 0x0000007029297812ULL, 0x000fc400078ec0ffULL,
0x00000033ff3e7212ULL, 0x000fe200078e33ffULL, 0x000001002b287824ULL, 0x000fc600078e0028ULL,
0xfffffff8353e7812ULL, 0x000fe400078ee23eULL, 0x000000282a2a7210ULL, 0x000fe20007ffe029ULL,
0x0000000833297824ULL, 0x000fe200078e00ffULL, 0xfffffff82f287812ULL, 0x000fe200078ee23cULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180002a2b7984ULL, 0x000e620000000800ULL,
0x00000001292c7812ULL, 0x140fe400078ef63cULL, 0x00000002292e7812ULL, 0x140fe200078ef63cULL,
0x004580002a507984ULL, 0x0004e20000000800ULL, 0x0000000329327812ULL, 0x140fe400078ef63cULL,
0x0000000429367812ULL, 0x140fe400078ef63cULL, 0x0000000529387812ULL, 0x140fe400078ef63cULL,
0x00000006293c7812ULL, 0x000fe200078ef63cULL, 0x000004002d297824ULL, 0x000fe200078e00ffULL,
0x0000000833357810ULL, 0x000fe20007ffe0ffULL, 0x00000004032a7824ULL, 0x004fc600078e00ffULL,
0x0000080029297812ULL, 0x000fe200078ec0ffULL, 0x0000000835427824ULL, 0x040fe200078e00ffULL,
0x00000007352d7812ULL, 0x040fe200078ec0ffULL, 0x0000000835407824ULL, 0x040fe200078e00ffULL,
0x000001803a297810ULL, 0x000fe20007ffe029ULL, 0x0000000835377824ULL, 0x000fe200078e00ffULL,
0x00000035ff4e7212ULL, 0x000fe400078e33ffULL, 0x0000000240447812ULL, 0x000fe200078ef62dULL,
0x0000001028287824ULL, 0x000fe200078e0229ULL, 0x0000000340467812ULL, 0x000fe200078ef62dULL,
0x000000103e3e7824ULL, 0x000fe200078e0229ULL, 0x00000004404a7812ULL, 0x000fe200078ef62dULL,
0x000000102c2c7824ULL, 0x000fe200078e0229ULL, 0x00000005404c7812ULL, 0x000fe200078ef62dULL,
0x0000001032327824ULL, 0x100fe200078e0229ULL, 0xfffffff8374e7812ULL, 0x000fe200078ee24eULL,
0x000000102e2e7824ULL, 0x000fc400078e0229ULL, 0x0000001038387824ULL, 0x100fe400078e0229ULL,
0x0000001036367824ULL, 0x000fe200078e0229ULL, 0x0000002b302b7221ULL, 0x002fe20000010100ULL,
0x000000103c3c7824ULL, 0x100fe400078e0229ULL, 0x0000001044447824ULL, 0x100fe200078e0229ULL,
0x3fb8aa3b2b2f7820ULL, 0x000fe20000410000ULL, 0x0000000c2a2b7812ULL, 0x000fe200078ec0ffULL,
0x0000001046467824ULL, 0x000fe200078e0229ULL, 0xfffffff8422a7812ULL, 0x000fe200078ee22dULL,
0x000000104a4a7824ULL, 0x000fe200078e0229ULL, 0x0000000140427812ULL, 0x000fe200078ef62dULL,
0x0000000128287824ULL, 0x000fe200078e022bULL, 0x0000002f002f7308ULL, 0x000ee20000000800ULL,
0x000000012b3e7824ULL, 0x040fe200078e023eULL, 0x0000000640407812ULL, 0x000fe200078ef62dULL,
0x000000012b2c7824ULL, 0x000fc400078e022cULL, 0x0000000028287984ULL, 0x000e620000000800ULL,
0x000000012b327824ULL, 0x040fe400078e0232ULL, 0x000000012b2e7824ULL, 0x040fe200078e022eULL,
0x000000003e3e7984ULL, 0x000ea20000000800ULL, 0x000000012b387824ULL, 0x040fe400078e0238ULL,
0x000000012b367824ULL, 0x040fe200078e0236ULL, 0x000000002c2c7984ULL, 0x000fe20000000800ULL,
0x000000012b3c7824ULL, 0x000fe200078e023cULL, 0x000000502f527220ULL, 0x008fc40000410000ULL,
0x0000000032327984ULL, 0x000fe20000000800ULL, 0x000000102a2a7824ULL, 0x100fe400078e0229ULL,
0x0000001042427824ULL, 0x000fe200078e0229ULL, 0x000000002e2e7984ULL, 0x000fe20000000800ULL,
0x000000012b2a7824ULL, 0x040fe200078e022aULL, 0x0000003152317221ULL, 0x000fe20000010000ULL,
0x000000012b427824ULL, 0x040fe200078e0242ULL, 0x0000000038387984ULL, 0x000fe20000000800ULL,
0x000000012b447824ULL, 0x040fe400078e0244ULL, 0x000000012b467824ULL, 0x000fe200078e0246ULL,
0x00001f33522d7589ULL, 0x000ee200000e0000ULL, 0x000000104c4c7824ULL, 0x000fc400078e0229ULL,
0x0000001040407824ULL, 0x100fe200078e0229ULL, 0x0000000036367984ULL, 0x000f220000000800ULL,
0x000000104e4e7824ULL, 0x000fe400078e0229ULL, 0x000000012b4a7824ULL, 0x040fe200078e024aULL,
0x000000003c3c7984ULL, 0x000f620000000800ULL, 0x000000012b4c7824ULL, 0x040fe400078e024cULL,
0x000000012b407824ULL, 0x040fe200078e0240ULL, 0x000000002a2a7984ULL, 0x000f620000000800ULL,
0x000000012b4e7824ULL, 0x000fc600078e024eULL, 0x0000000042427984ULL, 0x000f620000000800ULL,
0x20000028ff507230ULL, 0x102fe40000004100ULL, 0x30000028ff2b7230ULL, 0x000fe20000004100ULL,
0x0000000044447984ULL, 0x000e620000000800ULL, 0x2000003eff287230ULL, 0x104fe40000004100ULL,
0x3000003eff2f7230ULL, 0x000fe20000004100ULL, 0x0000000046467984ULL, 0x000fe20000000800ULL,
0x0000002d2b267223ULL, 0x088fe20000010026ULL, 0x0000002d28197223ULL, 0x080fe20000010019ULL,
0x2000002cff287230ULL, 0x100fe20000004100ULL, 0x000000004a4a7984ULL, 0x000fe20000000800ULL,
0x3000002cff2b7230ULL, 0x000fe20000004100ULL, 0x0000002d2f187223ULL, 0x080fe20000010018ULL,
0x0000002d50277223ULL, 0x080fe20000010027ULL, 0x000000004c4c7984ULL, 0x000fe20000000800ULL,
0x0000002d28257223ULL, 0x080fe20000010025ULL, 0x20000032ff287230ULL, 0x000fe20000004100ULL,
0x0000002d2b247223ULL, 0x000fe20000010024ULL, 0x0000000040407984ULL, 0x000fe20000000800ULL,
0x3000002eff2f7230ULL, 0x000fc40000004100ULL, 0x0000002d28217223ULL, 0x080fe20000010021ULL,
0x000000004e4e7984ULL, 0x000fe20000000800ULL, 0x30000032ff2b7230ULL, 0x000fe20000004100ULL,
0x0000002d2f227223ULL, 0x080fe20000010022ULL, 0x20000038ff287230ULL, 0x000fe20000004100ULL,
0x00001f3552297589ULL, 0x000ea200000e0000ULL, 0x2000002eff2c7230ULL, 0x000fe20000004100ULL,
0x0000002d2b207223ULL, 0x080fe20000010020ULL, 0x30000036ff2f7230ULL, 0x010fe20000004100ULL,
0x0000002d281d7223ULL, 0x080fe2000001001dULL, 0x30000038ff2b7230ULL, 0x000fe20000004100ULL,
0x0000002d2c237223ULL, 0x080fe20000010023ULL, 0x2000003cff287230ULL, 0x020fe20000004100ULL,
0x0000002d2f1e7223ULL, 0x080fe2000001001eULL, 0x20000036ff2c7230ULL, 0x000fe20000004100ULL,
0x0000002d2b1c7223ULL, 0x080fe2000001001cULL, 0x3000003cff2f7230ULL, 0x000fe20000004100ULL,
0x0000002d281b7223ULL, 0x080fe2000001001bULL, 0x3000002aff2b7230ULL, 0x000fe20000004100ULL,
0x0000002d2c1f7223ULL, 0x080fe2000001001fULL, 0x20000042ff287230ULL, 0x000fe20000004100ULL,
0x0000002d2f1a7223ULL, 0x000fe2000001001aULL, 0x000000ffff327224ULL, 0x000fc400078e0034ULL,
0x2000002aff2c7230ULL, 0x000fe40000004100ULL, 0x20000044ff2a7230ULL, 0x102fe20000004100ULL,
0x0000030032007a0cULL, 0x000fe20003f06070ULL, 0x30000044ff2d7230ULL, 0x000fe20000004100ULL,
0x000000292b167223ULL, 0x084fe20000010016ULL, 0x0000002928157223ULL, 0x080fe20000010015ULL,
0x30000042ff2b7230ULL, 0x000fe20000004100ULL, 0x000000292a137223ULL, 0x080fe20000010013ULL,
0x20000046ff287230ULL, 0x000fe20000004100ULL, 0x000000292d127223ULL, 0x080fe20000010012ULL,
0x3000004aff2d7230ULL, 0x000fe20000004100ULL, 0x000000292b147223ULL, 0x080fe20000010014ULL,
0x30000046ff2b7230ULL, 0x000fe20000004100ULL, 0x0000002928117223ULL, 0x080fe20000010011ULL,
0x2000004aff287230ULL, 0x000fe20000004100ULL, 0x000000292d0e7223ULL, 0x080fe2000001000eULL,
0x2000004cff2a7230ULL, 0x100fe20000004100ULL, 0x000000292b107223ULL, 0x080fe20000010010ULL,
0x3000004cff2b7230ULL, 0x000fe20000004100ULL, 0x00000029280f7223ULL, 0x080fe2000001000fULL,
0x20000040ff287230ULL, 0x100fe20000004100ULL, 0x000000292a0d7223ULL, 0x080fe2000001000dULL,
0x30000040ff2d7230ULL, 0x000fe20000004100ULL, 0x000000292c177223ULL, 0x080fe20000010017ULL,
0x2000004eff2a7230ULL, 0x100fe20000004100ULL, 0x000000292b0c7223ULL, 0x080fe2000001000cULL,
0x3000004eff2f7230ULL, 0x000fe20000004100ULL, 0x00000029280b7223ULL, 0x080fe2000001000bULL,
0x000000292d0a7223ULL, 0x080fe2000001000aULL, 0x000000292a097223ULL, 0x000fc40000010009ULL,
0x000000292f087223ULL, 0x000fe20000010008ULL, 0xfffff2c000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x004fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x000000ff3b00720cULL, 0x000fe20003f05270ULL, 0x0000001002037824ULL, 0x002fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011602ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c02027812ULL, 0x000fca00078ec0ffULL, 0x0000000102047824ULL, 0x000fe200078e0203ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x0000001002037824ULL, 0x002fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fc80000011602ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c02077812ULL, 0x000fc600078ec0ffULL,
0x0000008048027824ULL, 0x000fc800078e0203ULL, 0x0000000107027824ULL, 0x000fca00078e0202ULL,
0x0049803102007388ULL, 0x0003e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0x0049800004027984ULL, 0x002e680000000800ULL,
0x004a000004037984ULL, 0x000ea20000000800ULL, 0x00000002ff027221ULL, 0x002fc80000010000ULL,
0x0000000302027221ULL, 0x004fca0000010000ULL, 0x0180000002037810ULL, 0x000fc80007ffe0ffULL,
0x7f80000003037812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e0002ULL, 0x0000937000067802ULL, 0x000fe40000000f00ULL,
0x0000575000007944ULL, 0x000fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000200037308ULL, 0x000e640000001000ULL, 0xbf80000002047423ULL, 0x002fc80000000003ULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x0000000403047223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000008032d7811ULL, 0x004fe400078ff0ffULL,
0x00000002ff2b7819ULL, 0x000fe40000011603ULL, 0x0000002dff297212ULL, 0x000fe200078e33ffULL,
0x00001f2d04067589ULL, 0x000ea200000e0000ULL, 0x000000082d2e7824ULL, 0x000fc400078e00ffULL,
0x000000082b2f7824ULL, 0x000fe200078e00ffULL, 0x00001f2b04027589ULL, 0x00072400000e0000ULL,
0x0000002bff047212ULL, 0x008fc800078e33ffULL, 0xfffffff82f2f7812ULL, 0x000fe400078ee204ULL,
0x000000072b047812ULL, 0x040fe200078ec0ffULL, 0x0000001706177220ULL, 0x044fe20000410000ULL,
0x0000001606167220ULL, 0x040fe20000410000ULL, 0x0000001506157220ULL, 0x040fe20000410000ULL,
0x0000001406147220ULL, 0x040fe20000410000ULL, 0x0000001306137220ULL, 0x040fe20000410000ULL,
0x0000001206127220ULL, 0x040fe20000410000ULL, 0x0000001106117220ULL, 0x040fe20000410000ULL,
0x0000001006107220ULL, 0x040fe20000410000ULL, 0x0000000f060f7220ULL, 0x040fe20000410000ULL,
0x0000000e060e7220ULL, 0x040fe20000410000ULL, 0x0000000d060d7220ULL, 0x040fe20000410000ULL,
0x0000000c060c7220ULL, 0x040fe20000410000ULL, 0x0000000b060b7220ULL, 0x040fe20000410000ULL,
0x0000000a060a7220ULL, 0x040fe20000410000ULL, 0x0000000906097220ULL, 0x000fe20000410000ULL,
0x0000002702277220ULL, 0x050fe20000410000ULL, 0x0000002602267220ULL, 0x040fe20000410000ULL,
0x0000002502257220ULL, 0x040fe20000410000ULL, 0x0000002402247220ULL, 0x040fe20000410000ULL,
0x0000002302237220ULL, 0x040fe20000410000ULL, 0x0000002202227220ULL, 0x040fe20000410000ULL,
0x0000002102217220ULL, 0x040fe20000410000ULL, 0x0000002002207220ULL, 0x040fe20000410000ULL,
0x0000001f021f7220ULL, 0x040fe20000410000ULL, 0x0000001e021e7220ULL, 0x040fe20000410000ULL,
0x0000001d021d7220ULL, 0x040fe20000410000ULL, 0x0000001c021c7220ULL, 0x040fe20000410000ULL,
0x0000001b021b7220ULL, 0x040fe20000410000ULL, 0x0000001a021a7220ULL, 0x040fe20000410000ULL,
0x0000001902197220ULL, 0x000fe20000410000ULL, 0x0000000806067220ULL, 0x000fe20000410000ULL,
0x0000001802027220ULL, 0x000fe20000410000ULL, 0x000000082b087824ULL, 0x000fe200078e00ffULL,
0x000000252424723eULL, 0x000fe200000000ffULL, 0x000000082d187824ULL, 0x000fe200078e00ffULL,
0x0000000304287812ULL, 0x000fe200078e3cffULL, 0x0000000403257824ULL, 0x000fe200078e00ffULL,
0xfffffff808077812ULL, 0x000fc400078ee22bULL, 0xfffffff818297812ULL, 0x000fe400078ee229ULL,
0x0000000104087812ULL, 0x040fe200078e3cffULL, 0x0000001007077824ULL, 0x100fe200078e0200ULL,
0x0000000204187812ULL, 0x040fe200078e3cffULL, 0x0000001029297824ULL, 0x000fe200078e0200ULL,
0x00000004042a7812ULL, 0x040fe400078e3cffULL, 0x00000005042c7812ULL, 0x040fe400078e3cffULL,
0x0000000604047812ULL, 0x000fc400078e3cffULL, 0x000000232222723eULL, 0x000fe400000000ffULL,
0x000000090606723eULL, 0x000fe200000000ffULL, 0x000000082b097824ULL, 0x000fe200078e0208ULL,
0x000000072d237812ULL, 0x000fe400078ec0ffULL, 0x0000000d0c0c723eULL, 0x000fe200000000ffULL,
0x000000082b0d7824ULL, 0x040fe200078e0228ULL, 0x0000000b0a0a723eULL, 0x000fe200000000ffULL,
0x000000082b0b7824ULL, 0x040fe200078e0218ULL, 0x000000131212723eULL, 0x000fe200000000ffULL,
0x000000082b137824ULL, 0x040fe200078e0204ULL, 0x0000000f0e0e723eULL, 0x000fe200000000ffULL,
0x000000082b0f7824ULL, 0x000fe200078e022aULL, 0x0000000c25287812ULL, 0x000fe200078ec0ffULL,
0x0000001009097824ULL, 0x000fe200078e0200ULL, 0x000000111010723eULL, 0x000fe200000000ffULL,
0x000000082b117824ULL, 0x000fe200078e022cULL, 0x0000000123047812ULL, 0x000fe200078e3cffULL,
0x000000100b0b7824ULL, 0x100fe200078e0200ULL, 0x0000000223087812ULL, 0x000fe200078e3cffULL,
0x000000100d0d7824ULL, 0x100fe200078e0200ULL, 0x0000001b1a1a723eULL, 0x000fe200000000ffULL,
0x0000000128077824ULL, 0x000fe200078e0207ULL, 0x000000151414723eULL, 0x000fe200000000ffULL,
0x000000100f0f7824ULL, 0x100fe200078e0200ULL, 0x0000000323187812ULL, 0x000fe200078e3cffULL,
0x0000001011117824ULL, 0x100fe200078e0200ULL, 0x000000212020723eULL, 0x000fe200000000ffULL,
0x0000000128097824ULL, 0x000fe200078e0209ULL, 0xfffffff82e157812ULL, 0x000fe200078ee22dULL,
0x0000001013137824ULL, 0x000fe200078e0200ULL, 0x00000004231b7812ULL, 0x000fe200078e3cffULL,
0x00000001280b7824ULL, 0x000fe200078e020bULL, 0x000000272626723eULL, 0x000fe200000000ffULL,
0x00000001280d7824ULL, 0x000fe200078e020dULL, 0x000000171616723eULL, 0x000fe200000000ffULL,
0x000000082d177824ULL, 0x000fe200078e0204ULL, 0x0000000523217812ULL, 0x000fe200078e3cffULL,
0x000000102f047824ULL, 0x000fe200078e0200ULL, 0x0000001d1c1c723eULL, 0x000fe200000000ffULL,
0x00000001280f7824ULL, 0x000fe200078e020fULL, 0x000000190202723eULL, 0x000fe200000000ffULL,
0x000000082d197824ULL, 0x000fe200078e0208ULL, 0x0000000623237812ULL, 0x000fe200078e3cffULL,
0x0000001015087824ULL, 0x100fe200078e0200ULL, 0x000000182d1d7211ULL, 0x040fe200078e18ffULL,
0x000000082d217824ULL, 0x040fe200078e0221ULL, 0x0000001f1e1e723eULL, 0x000fe200000000ffULL,
0x000000082d1f7824ULL, 0x000fe200078e021bULL, 0x0000002607007388ULL, 0x000fe20000000800ULL,
0x0000001017187824ULL, 0x000fc400078e0200ULL, 0x0000000128117824ULL, 0x040fe200078e0211ULL,
0x0000002409007388ULL, 0x000fe20000000800ULL, 0x000000082d237824ULL, 0x000fe400078e0223ULL,
0x00000010191b7824ULL, 0x100fe200078e0200ULL, 0x000000220b007388ULL, 0x000fe20000000800ULL,
0x0000000128137824ULL, 0x040fe400078e0213ULL, 0x000000101d1d7824ULL, 0x000fe200078e0200ULL,
0x000000200d007388ULL, 0x000fe20000000800ULL, 0x0000000128157824ULL, 0x000fc400078e0204ULL,
0x000000101f1f7824ULL, 0x000fe200078e0200ULL, 0x0000001e0f007388ULL, 0x000fe20000000800ULL,
0x0000000128177824ULL, 0x040fe400078e0208ULL, 0x0000001021217824ULL, 0x000fe200078e0200ULL,
0x0000001c11007388ULL, 0x000fe20000000800ULL, 0x0000000128197824ULL, 0x040fe400078e0218ULL,
0x0000001023237824ULL, 0x000fe200078e0200ULL, 0x0000001a13007388ULL, 0x000fe20000000800ULL,
0x00000001281b7824ULL, 0x000fc400078e021bULL, 0x00000001281d7824ULL, 0x040fe200078e021dULL,
0x0000000215007388ULL, 0x000fe20000000800ULL, 0x00000001281f7824ULL, 0x040fe400078e021fULL,
0x0000000128217824ULL, 0x040fe200078e0221ULL, 0x0000001617007388ULL, 0x000fe20000000800ULL,
0x0000000128237824ULL, 0x040fe400078e0223ULL, 0x0000000128297824ULL, 0x000fe200078e0229ULL,
0x0000001419007388ULL, 0x000fe20000000800ULL, 0x0000002048007824ULL, 0x000fc600078e0203ULL,
0x000000121b007388ULL, 0x000fe20000000800ULL, 0x0000001000007824ULL, 0x000fc600078e0205ULL,
0x000000101d007388ULL, 0x000fe80000000800ULL, 0x0000000e1f007388ULL, 0x000fe80000000800ULL,
0x0000000c21007388ULL, 0x000fe80000000800ULL, 0x0000000a23007388ULL, 0x000fe80000000800ULL,
0x0000000629007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000247984ULL, 0x000ea80000000c00ULL, 0x00040000002c7984ULL, 0x000ee80000000c00ULL,
0x0008000000147984ULL, 0x000f280000000c00ULL, 0x000c000000187984ULL, 0x000f620000000c00ULL,
0x200000ff27277230ULL, 0x004fc40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fe40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x200000ff2f2f7230ULL, 0x008fe40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fc40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x0000001727277230ULL, 0x010fe40000000000ULL, 0x0000001626267230ULL, 0x000fe40000000000ULL,
0x0000001525257230ULL, 0x000fe40000000000ULL, 0x0000001424247230ULL, 0x000fe40000000000ULL,
0x0000001b2f2f7230ULL, 0x020fc40000000000ULL, 0x0000001a2e2e7230ULL, 0x000fe20000000000ULL,
0x0000002400007388ULL, 0x0005e20000000c00ULL, 0x000000192d2d7230ULL, 0x000fe40000000000ULL,
0x000000182c2c7230ULL, 0x000fca0000000000ULL, 0x0004002c00007388ULL, 0x0005e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff4800720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002003117810ULL, 0x008fe20007ffe0ffULL,
0x0000000000067919ULL, 0x000ee20000002600ULL, 0x00000003ff107819ULL, 0x000fe20000011603ULL,
0x00000000000579c3ULL, 0x000f220000002700ULL, 0x00000003ff047819ULL, 0x000fe20000011611ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000710007812ULL, 0x004fe200078e4803ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000704027812ULL, 0x000fe200078e4811ULL,
0x000000083b127824ULL, 0x000fe200078e00ffULL, 0x0ffffff800007812ULL, 0x000fc400078ef803ULL,
0x0ffffff802027812ULL, 0x100fe400078ef811ULL, 0xfffffff812117812ULL, 0x000fe200078ee211ULL,
0x0000001000007824ULL, 0x100fe400078e0205ULL, 0x0000001002057824ULL, 0x000fc600078e0205ULL,
0x0000000000087984ULL, 0x0005680000000c00ULL, 0x00000000050c7984ULL, 0x0003620000000c00ULL,
0x0000000806077824ULL, 0x048fe400078e00ffULL, 0x0000000806137824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x010fe2000f8e023fULL, 0x000000083b007824ULL, 0x004fe200078e00ffULL,
0xfffffff807027812ULL, 0x000fc400078ee210ULL, 0xfffffff813047812ULL, 0x000fe400078ee204ULL,
0x0000000402107c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000404027c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff800037812ULL, 0x000fe200078ee203ULL, 0x000000ffff057224ULL, 0x002fe200000e06ffULL,
0x00005a0010047a11ULL, 0x000fe200078040ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005a0002067a11ULL, 0x000fc400078240ffULL, 0x00005b0010057a11ULL, 0x000fe400000f4405ULL,
0x00005b0002077a11ULL, 0x000fc600008f4407ULL, 0x0000001003027825ULL, 0x000fc800078e0004ULL,
0x0000001011047825ULL, 0x000fe200078e0006ULL, 0x0000000802007986ULL, 0x020fe8000c101d06ULL,
0x0000000c04007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff047624ULL, 0x000fe400078e00ffULL, 0x00006700ff057624ULL, 0x000fca00078e00ffULL,
0x0000000604207981ULL, 0x000362000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000103097810ULL, 0x000fe20007ffe0ffULL, 0x0000000237057824ULL, 0x002fe200078e00ffULL,
0x00f60000ff067f8cULL, 0x000e62000c80043fULL, 0x0000004035047824ULL, 0x000fe200078e00ffULL,
0x000000020900720cULL, 0x000fe20003f06070ULL, 0x0000580005057a24ULL, 0x000fe400078e0210ULL,
0x00000100030d7824ULL, 0x000fc800078e0204ULL, 0x00006200051c7a24ULL, 0x000fcc00078e020dULL,
0x000005a000008947ULL, 0x000fea0003800000ULL, 0x00000002ff257819ULL, 0x000fe20000011636ULL,
0x00000080ff297424ULL, 0x000fe200078e00ffULL, 0x000000300c277812ULL, 0x000fe400078ec0ffULL,
0x0000000825137810ULL, 0x040fe20007ffe0ffULL, 0x0000000125087824ULL, 0x040fe200078e021cULL,
0x00000020251f7810ULL, 0x040fe40007ffe0ffULL, 0x00000010252b7810ULL, 0x040fe20007ffe0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0029ULL, 0x00000018252d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000d34007217ULL, 0x000fe20007800000ULL, 0x00000001130a7824ULL, 0x000fe200078e021cULL,
0x0000002708107210ULL, 0x000fe20007f1e0ffULL, 0x000000011c087824ULL, 0x000fe200078e021fULL,
0x00000003ff177819ULL, 0x100fe20000011636ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0029ULL,
0x0000100035197811ULL, 0x000fe400078e68ffULL, 0x0000000317177812ULL, 0x000fe200078e4836ULL,
0x000000012b0c7824ULL, 0x100fe200078e021cULL, 0x000000270a0a7210ULL, 0x000fe20007f3e0ffULL,
0x000000012d0e7824ULL, 0x000fe200078e021cULL, 0x0000002825217810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200000e0609ULL, 0x0ffffffc17367812ULL, 0x000fe200078ef836ULL,
0x0000000100007824ULL, 0x000fe200078e0a0dULL, 0x0000003025237810ULL, 0x000fe20007ffe0ffULL,
0x00005e0008087625ULL, 0x000fc600078e0029ULL, 0x000000002b00720cULL, 0x080fe20003fa6070ULL,
0x00005e000c0c7625ULL, 0x000fe200078e0029ULL, 0x0000002708127210ULL, 0x080fe40007f5e0ffULL,
0x000000002d00720cULL, 0x080fe20003f86070ULL, 0x0000000413147824ULL, 0x000fe200078e00ffULL,
0x000000270c0c7210ULL, 0x000fe20007f1e0ffULL, 0x00005e000e0e7625ULL, 0x000fe200078e0029ULL,
0x000000001f00720cULL, 0x080fe40003f66070ULL, 0xfffffffc14087812ULL, 0x000fe200078ee217ULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x000000270e0e7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x000000002500720cULL, 0x0c0fe20003f06070ULL,
0x00000010081d7824ULL, 0x000fe200078e0219ULL, 0x0000003825257810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x000000001300720cULL, 0x000fe20003f26070ULL,
0x000000011c087824ULL, 0x000fc400078e0221ULL, 0x000000ffff137224ULL, 0x000fe200010e0609ULL,
0x000000002100720cULL, 0x000fe20003f46070ULL, 0x00005e0008087625ULL, 0x000fc800078e0029ULL,
0x00000010361b7824ULL, 0x000fe200078e0219ULL, 0x0000002708147210ULL, 0x000fe20007fde0ffULL,
0x000000011c087824ULL, 0x000fe400078e0223ULL, 0x000000041f167824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101b7faeULL, 0x0005e2000c101c46ULL,
0x000000ffff157224ULL, 0x000fe200030e0609ULL, 0x000000002500720cULL, 0x080fe20003f06070ULL,
0x00005e0008087625ULL, 0x000fe200078e0029ULL, 0x000000000a1d7faeULL, 0x0007e2000c901c46ULL,
0x000000002300720cULL, 0x000fc40003f26070ULL, 0x000000042b007824ULL, 0x000fe200078e00ffULL,
0x0000002708087210ULL, 0x000fe20007fde0ffULL, 0x0000000421187824ULL, 0x000fe200078e00ffULL,
0xfffffffc16167812ULL, 0x100fe200078ee217ULL, 0x00000004231a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc00007812ULL, 0x100fe200078ee217ULL, 0x000000042d107824ULL, 0x004fe200078e00ffULL,
0xfffffffc18187812ULL, 0x000fe200078ee217ULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0xfffffffc1a1a7812ULL, 0x000fe200078ee217ULL, 0x000000011c0a7824ULL, 0x008fe200078e0225ULL,
0xfffffffc10107812ULL, 0x000fe200078ee217ULL, 0x00000004251c7824ULL, 0x000fc400078e00ffULL,
0x00005e000a0a7625ULL, 0x000fc600078e0029ULL, 0xfffffffc1c1c7812ULL, 0x000fe200078ee217ULL,
0x0000001000117824ULL, 0x100fe200078e0219ULL, 0x000000270a0a7210ULL, 0x000fe20007fde0ffULL,
0x0000001010177824ULL, 0x100fe400078e0219ULL, 0x00000010161b7824ULL, 0x100fe200078e0219ULL,
0x000000000c117faeULL, 0x0005e2000e901c46ULL, 0x00000010181d7824ULL, 0x100fe400078e0219ULL,
0x000000101a1f7824ULL, 0x000fe200078e0219ULL, 0x000000191c197211ULL, 0x000fe200078e20ffULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x000000000e177faeULL, 0x0005e8000e101c46ULL,
0x00000000121b7faeULL, 0x0005e8000d901c46ULL, 0x00000000141d7faeULL, 0x0005e8000d101c46ULL,
0x00000000081f7faeULL, 0x0005e8000c901c46ULL, 0x000000000a197faeULL, 0x0005e2000c101c46ULL,
0x000004e000007947ULL, 0x000fea0003800000ULL, 0x0000000836157811ULL, 0x040fe200078ff0ffULL,
0x00000080ff277424ULL, 0x000fe200078e00ffULL, 0x0000001036097811ULL, 0x000fc400078ff0ffULL,
0x0000001c36087211ULL, 0x000fe200078ff0ffULL, 0x0000000415127824ULL, 0x000fe200078e00ffULL,
0x00000003ff117819ULL, 0x000fe20000011636ULL, 0x000000011c0a7824ULL, 0x000fe200078e0209ULL,
0x00000020360d7811ULL, 0x040fe200078ff0ffULL, 0x0000000409147824ULL, 0x000fe200078e00ffULL,
0x00000028360e7811ULL, 0x000fe200078ff0ffULL, 0x00005e0008087625ULL, 0x000fe200078e0027ULL,
0x00000018360b7811ULL, 0x040fe400078ff0ffULL, 0x00000030360f7811ULL, 0x040fe200078ff0ffULL,
0x000000040d1e7824ULL, 0x000fe200078e00ffULL, 0x0000003836107811ULL, 0x000fe200078ff0ffULL,
0x000000011c187824ULL, 0x000fe200078e020eULL, 0x0000000311137812ULL, 0x100fe200078e4836ULL,
0x000000040e227824ULL, 0x000fe200078e00ffULL, 0x000000300c297812ULL, 0x000fe200078ec0ffULL,
0x000000040b167824ULL, 0x000fe200078e00ffULL, 0xfffffffc120e7812ULL, 0x000fe200078ee213ULL,
0x000000040f247824ULL, 0x000fe200078e00ffULL, 0x0000002908127210ULL, 0x000fe20007f1e0ffULL,
0x0000000410267824ULL, 0x000fe200078e00ffULL, 0x0ffffffc13367812ULL, 0x000fe200078ef836ULL,
0x000000011c1a7824ULL, 0x000fe200078e020fULL, 0xfffffffc140f7812ULL, 0x100fe200078ee213ULL,
0x0000000115007824ULL, 0x000fe200078e021cULL, 0xfffffffc1e147812ULL, 0x000fe200078ee213ULL,
0x000000011c0c7824ULL, 0x000fe200078e020bULL, 0xfffffffc22157812ULL, 0x000fe200078ee213ULL,
0x000000011c117824ULL, 0x000fe200078e020dULL, 0xfffffffc24177812ULL, 0x100fe200078ee213ULL,
0x000000011c1c7824ULL, 0x000fe200078e0210ULL, 0xfffffffc16107812ULL, 0x100fe200078ee213ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0027ULL, 0xfffffffc261e7812ULL, 0x000fc400078ee213ULL,
0x0000100035257811ULL, 0x000fe200078e68ffULL, 0x000000ffff137224ULL, 0x000fe200000e0609ULL,
0x000000290a167210ULL, 0x000fe20007f3e0ffULL, 0x00005e0000087625ULL, 0x000fc800078e0027ULL,
0x00000010141f7824ULL, 0x000fe200078e0225ULL, 0x0000002908147210ULL, 0x000fe20007f1e0ffULL,
0x00005e000c0c7625ULL, 0x000fc800078e0027ULL, 0x0000001015217824ULL, 0x000fe400078e0225ULL,
0x000000ffff157224ULL, 0x000fe200000e0609ULL, 0x000000290c0c7210ULL, 0x000fe20007f1e0ffULL,
0x0000001017237824ULL, 0x000fe400078e0225ULL, 0x000000ffff177224ULL, 0x000fe400008e060bULL,
0x00005e0011087625ULL, 0x000fc800078e0027ULL, 0x000000100e197824ULL, 0x100fe400078e0225ULL,
0x000000100f1b7824ULL, 0x000fe400078e0225ULL, 0x00005e00180a7625ULL, 0x000fc800078e0027ULL,
0x00000010101d7824ULL, 0x000fe200078e0225ULL, 0x000000290a0a7210ULL, 0x000fe20007f3e0ffULL,
0x00005e001a0e7625ULL, 0x000fc800078e0027ULL, 0x00005e001c107625ULL, 0x000fe200078e0027ULL,
0x000000290e0e7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000002908087210ULL, 0x080fe20007f1e0ffULL, 0x00000010362b7824ULL, 0x000fe200078e0225ULL,
0x0000002910107210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe400008e060bULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000122b7faeULL, 0x0005e2000b901c46ULL, 0x000000ffff0f7224ULL, 0x000fe400010e060fULL,
0x000000101e257824ULL, 0x000fe200078e0225ULL, 0x0000000014197faeULL, 0x0005e2000b901c46ULL,
0x000000ffff117224ULL, 0x000fc600018e0611ULL, 0x00000000161b7faeULL, 0x0005e8000b901c46ULL,
0x000000000c1d7faeULL, 0x0005e8000b901c46ULL, 0x00000000081f7faeULL, 0x0005e8000b901c46ULL,
0x000000000a217faeULL, 0x0005e8000b901c46ULL, 0x000000000e237faeULL, 0x0005e8000b901c46ULL,
0x0000000010257faeULL, 0x0005e4000b901c46ULL, 0x00f60400ff097984ULL, 0x004ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000009ff7812ULL, 0x006fc60007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000087305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000080000735dULL, 0x004fe20003800000ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e640000000000ULL, 0x0000002035007824ULL, 0x002fc800078e0200ULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x00000003ff067819ULL, 0x000fc80000011600ULL,
0x1ffffffe06077812ULL, 0x000fe400078ec0ffULL, 0x000000f008087812ULL, 0x000fe400078ec0ffULL,
0x0000000107097812ULL, 0x040fe400078efcffULL, 0x0000000707077812ULL, 0x100fe400078e7800ULL,
0x0000000709097812ULL, 0x000fc600078e7800ULL, 0x0000000107077824ULL, 0x000fe400078e0208ULL,
0x0000000108097824ULL, 0x000fc600078e0209ULL, 0x0000000007107984ULL, 0x000e68000000cc00ULL,
0x00000000090c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fc400078e0013ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff127224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fe200078e000fULL, 0x0000001407007388ULL, 0x0003e8000000cc00ULL,
0x0000001009007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff067f8cULL, 0x002fe8000c80043fULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007804807ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000087305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000080000735dULL, 0x004fe20003800000ULL,
0x00f60400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000020300720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000e620000000000ULL,
0x3db504f320077820ULL, 0x020fe20000410000ULL, 0x0000f68835287811ULL, 0x040fe200078e18ffULL,
0x000000ffff2c7224ULL, 0x000fe200078e00ffULL, 0xffffffff022a7810ULL, 0x000fe40007ffe0ffULL,
0x0000f60835297811ULL, 0x000fe400078e28ffULL, 0x00000100032b7824ULL, 0x008fe200078e0204ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000002b3400720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x014fea0003800000ULL, 0x000000ffff407224ULL, 0x000fe200078e002cULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x00000001002d7810ULL, 0x000fe20007ffe0ffULL,
0x00000a9000007945ULL, 0x000fe20003800000ULL, 0x000000ffff427224ULL, 0x000fc400078e0000ULL,
0x00000001ff2c7819ULL, 0x100fe2000001162dULL, 0x000000ffff007224ULL, 0x000fe200078e002dULL,
0x000000022d00780cULL, 0x040fe40003f06070ULL, 0x000000012d2e7812ULL, 0x000fe200078ec0ffULL,
0x000003002c2f7a24ULL, 0x000fe200078e0203ULL, 0x00000001402c7812ULL, 0x000fc600078e0cffULL,
0x000001002f307824ULL, 0x040fe200078e0204ULL, 0x000000012f317810ULL, 0x000fc60007ffe0ffULL,
0x0000620005397a24ULL, 0x000fe200078e0230ULL, 0x000000023100720cULL, 0x000fda0003f26070ULL,
0x0000054000009947ULL, 0x000fea0003800000ULL, 0x00000030342d7217ULL, 0x000fe20007800000ULL,
0x000000042e3d7824ULL, 0x000fe200078e00ffULL, 0x00000002ff327819ULL, 0x002fe20000011606ULL,
0x00000002353c7824ULL, 0x000fe200078e022cULL, 0x00000003ff2f7819ULL, 0x000fe20000011606ULL,
0x000000012d2d7824ULL, 0x000fe200078e0a30ULL, 0x0000000832367810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff3b7424ULL, 0x000fe200078e00ffULL, 0x000000032f3f7812ULL, 0x100fe200078e4806ULL,
0x00000001322e7824ULL, 0x100fe200078e0239ULL, 0x0000002d3600720cULL, 0x0c0fe20003f46070ULL,
0x0000000136307824ULL, 0x000fe200078e0239ULL, 0x0000002d3200720cULL, 0x000fe20003f26070ULL,
0x0000000436367824ULL, 0x000fe200078e00ffULL, 0xfffffffc3d3d7812ULL, 0x000fe200078ee206ULL,
0x00005e002e2e7625ULL, 0x000fe200078e003bULL, 0x000010003c3c7811ULL, 0x000fc400078e60ffULL,
0x0ffffffc3f337812ULL, 0x000fe200078ef806ULL, 0x00005e0030307625ULL, 0x000fe200078e003bULL,
0xfffffffc36377812ULL, 0x000fe400078ee23fULL, 0x0000001032367810ULL, 0x040fe20007ffe0ffULL,
0x0000001033337824ULL, 0x000fe200078e023cULL, 0x0000001832387810ULL, 0x040fe20007ffe0ffULL,
0x000000103d2e7825ULL, 0x000fe200078e002eULL, 0x00000020323a7810ULL, 0x040fe40007ffe0ffULL,
0x00000028323e7810ULL, 0x040fe20007ffe0ffULL, 0x0000001037377824ULL, 0x000fe200078e023cULL,
0x0000003032447810ULL, 0x040fe20007ffe0ffULL, 0x000000103d307825ULL, 0x000fe200078e0030ULL,
0x0000003832467810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e337faeULL, 0x0003e2000c901c46ULL, 0x0000002d3600720cULL, 0x0c0fe20003f26070ULL,
0x0000000436487824ULL, 0x000fe200078e00ffULL, 0x0000002d3a00720cULL, 0x080fe20003f66070ULL,
0x0000000030377faeULL, 0x0005e2000d101c46ULL, 0x0000002d3800720cULL, 0x0c0fe20003f46070ULL,
0x00000004384a7824ULL, 0x000fe200078e00ffULL, 0x0000002d3e00720cULL, 0x080fe20003f86070ULL,
0x000000013a327824ULL, 0x100fe200078e0239ULL, 0x0000002d4400720cULL, 0x080fe20003fa6070ULL,
0x000000043a4c7824ULL, 0x000fe200078e00ffULL, 0x0000002d4600720cULL, 0x000fe20003fc6070ULL,
0x00000001362e7824ULL, 0x002fe200078e0239ULL, 0xfffffffc482d7812ULL, 0x000fe200078ee23fULL,
0x000000013e367824ULL, 0x000fe200078e0239ULL, 0xfffffffc4a417812ULL, 0x000fe200078ee23fULL,
0x0000000138307824ULL, 0x004fe200078e0239ULL, 0xfffffffc4c437812ULL, 0x000fe200078ee23fULL,
0x0000000144387824ULL, 0x000fc400078e0239ULL, 0x00000001463a7824ULL, 0x000fe400078e0239ULL,
0x000000043e3e7824ULL, 0x000fe400078e00ffULL, 0x00005e002e2e7625ULL, 0x000fc600078e003bULL,
0xfffffffc3e457812ULL, 0x000fe200078ee23fULL, 0x00005e0030307625ULL, 0x000fc800078e003bULL,
0x00005e0032327625ULL, 0x000fc800078e003bULL, 0x00005e0036367625ULL, 0x000fc800078e003bULL,
0x00005e0038387625ULL, 0x000fc800078e003bULL, 0x0000000444447824ULL, 0x000fe400078e00ffULL,
0x00005e003a3a7625ULL, 0x000fc600078e003bULL, 0xfffffffc44477812ULL, 0x000fe200078ee23fULL,
0x0000000446467824ULL, 0x000fe400078e00ffULL, 0x000000103d2e7825ULL, 0x000fc600078e002eULL,
0xfffffffc46497812ULL, 0x000fe200078ee23fULL, 0x000000103d307825ULL, 0x000fc800078e0030ULL,
0x000000103d327825ULL, 0x000fc800078e0032ULL, 0x000000103d367825ULL, 0x000fc800078e0036ULL,
0x000000103d387825ULL, 0x000fc800078e0038ULL, 0x000000103d3a7825ULL, 0x000fc800078e003aULL,
0x000000102d2d7824ULL, 0x100fe400078e023cULL, 0x00000010413d7824ULL, 0x100fe400078e023cULL,
0x00000010433f7824ULL, 0x100fe200078e023cULL, 0x000000002e2d7faeULL, 0x0003e2000c901c46ULL,
0x0000001045417824ULL, 0x100fe400078e023cULL, 0x0000001047437824ULL, 0x100fe200078e023cULL,
0x00000000303d7faeULL, 0x0003e2000d101c46ULL, 0x0000001049457824ULL, 0x000fc600078e023cULL,
0x00000000323f7faeULL, 0x0003e8000d901c46ULL, 0x0000000036417faeULL, 0x0003e8000e101c46ULL,
0x0000000038437faeULL, 0x0003e8000e901c46ULL, 0x000000003a457faeULL, 0x0003e2000f101c46ULL,
0x0000048000007947ULL, 0x000fea0003800000ULL, 0x0000000235307824ULL, 0x000fe200078e022cULL,
0x0000000806327811ULL, 0x002fe200078ff0ffULL, 0x000000042e2d7824ULL, 0x000fe200078e00ffULL,
0x0000001006367811ULL, 0x000fc400078ff0ffULL, 0x0000001806387811ULL, 0x000fe200078ff0ffULL,
0x0000000432487824ULL, 0x000fe200078e00ffULL, 0x00000020063a7811ULL, 0x000fe200078ff0ffULL,
0x00000004364a7824ULL, 0x000fe200078e00ffULL, 0x00000028063c7811ULL, 0x000fe200078ff0ffULL,
0x00000004384c7824ULL, 0x000fe200078e00ffULL, 0x0000100030447811ULL, 0x000fe200078e60ffULL,
0x0000000132307824ULL, 0x100fe200078e0239ULL, 0x00000030063e7811ULL, 0x000fe200078ff0ffULL,
0x0000000136327824ULL, 0x100fe200078e0239ULL, 0x0000003806467811ULL, 0x000fe200078ff0ffULL,
0x0000000138367824ULL, 0x100fe200078e0239ULL, 0x00000003ff2f7819ULL, 0x100fe20000011606ULL,
0x000000013a387824ULL, 0x100fe200078e0239ULL, 0x00000039062e7211ULL, 0x000fe200078ff0ffULL,
0x000000043a4e7824ULL, 0x000fe200078e00ffULL, 0x00000080003f7802ULL, 0x000fe20000000f00ULL,
0x000000013c3a7824ULL, 0x140fe200078e0239ULL, 0x000000032f317812ULL, 0x100fe200078e4806ULL,
0x000000043c507824ULL, 0x000fe200078e00ffULL, 0xfffffffc2d2d7812ULL, 0x000fe200078ee206ULL,
0x000000013e3c7824ULL, 0x000fe200078e0239ULL, 0xfffffffc48437812ULL, 0x100fe200078ee231ULL,
0x000000043e527824ULL, 0x000fe200078e00ffULL, 0xfffffffc4a457812ULL, 0x000fe200078ee231ULL,
0x00000001463e7824ULL, 0x000fe200078e0239ULL, 0xfffffffc4c477812ULL, 0x100fe200078ee231ULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0xfffffffc4e497812ULL, 0x100fe200078ee231ULL,
0x00005e002e2e7625ULL, 0x000fe200078e003fULL, 0xfffffffc504b7812ULL, 0x000fc400078ee231ULL,
0xfffffffc524f7812ULL, 0x100fe200078ee231ULL, 0x00005e0032327625ULL, 0x080fe200078e003fULL,
0xfffffffc46517812ULL, 0x000fe400078ee231ULL, 0x0ffffffc31417812ULL, 0x000fe200078ef806ULL,
0x00005e0030307625ULL, 0x000fc800078e003fULL, 0x00005e0036367625ULL, 0x000fc800078e003fULL,
0x00005e0038387625ULL, 0x000fc800078e003fULL, 0x00005e003a3a7625ULL, 0x000fc800078e003fULL,
0x00005e003c3c7625ULL, 0x000fc800078e003fULL, 0x00005e003e3e7625ULL, 0x000fc800078e003fULL,
0x000000102d2e7825ULL, 0x000fc800078e002eULL, 0x000000102d307825ULL, 0x000fc800078e0030ULL,
0x000000102d327825ULL, 0x000fc800078e0032ULL, 0x000000102d367825ULL, 0x000fc800078e0036ULL,
0x000000102d387825ULL, 0x000fc800078e0038ULL, 0x000000102d3a7825ULL, 0x000fc800078e003aULL,
0x000000102d3c7825ULL, 0x000fc800078e003cULL, 0x000000102d3e7825ULL, 0x000fc800078e003eULL,
0x00000010414d7824ULL, 0x100fe400078e0244ULL, 0x00000010432d7824ULL, 0x100fe400078e0244ULL,
0x0000001045417824ULL, 0x100fe200078e0244ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e4d7faeULL, 0x0003e2000b901c46ULL, 0x0000001047437824ULL, 0x100fe400078e0244ULL,
0x0000001049457824ULL, 0x100fe200078e0244ULL, 0x00000000302d7faeULL, 0x0003e2000b901c46ULL,
0x000000104b477824ULL, 0x000fc400078e0244ULL, 0x000000104f497824ULL, 0x100fe200078e0244ULL,
0x0000000032417faeULL, 0x0003e2000b901c46ULL, 0x00000010514b7824ULL, 0x000fc600078e0244ULL,
0x0000000036437faeULL, 0x0003e8000b901c46ULL, 0x0000000038457faeULL, 0x0003e8000b901c46ULL,
0x000000003a477faeULL, 0x0003e8000b901c46ULL, 0x000000003c497faeULL, 0x0003e8000b901c46ULL,
0x000000003e4b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002006317810ULL, 0x042fe20007ffe0ffULL,
0x0000000235327824ULL, 0x000fe200078e0240ULL, 0xfffffff8062f7812ULL, 0x000fe200078ec0ffULL,
0x00000008422d7824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x000000072f367812ULL, 0x000fc400078ef806ULL,
0x00000007313c7812ULL, 0x000fe400078ef806ULL, 0x0000000706337812ULL, 0x000fe400078ec0ffULL,
0x00000001ff2f7819ULL, 0x000fe40000011636ULL, 0x00000001ff307819ULL, 0x000fe4000001163cULL,
0x0000100032507811ULL, 0x000fe400078e60ffULL, 0x0000000833527812ULL, 0x000fc400078ef806ULL,
0x000000032f377812ULL, 0x000fe400078ec0ffULL, 0x00000003303d7812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000002e37317212ULL, 0x080fe200078e3cffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000002d062f7211ULL, 0x000fe400078fe0ffULL,
0x0000002e3d3f7212ULL, 0x000fe200078e3cffULL, 0x0000000436317824ULL, 0x000fe200078e0231ULL,
0x000000072f307812ULL, 0x000fe400078e7852ULL, 0x000000012e3e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001031387824ULL, 0x000fe200078e0250ULL, 0x000000022f2f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001052307824ULL, 0x000fe200078e0230ULL, 0x000000022e2e7810ULL, 0x000fe20007ffe0ffULL,
0x000000043c3f7824ULL, 0x000fe200078e023fULL, 0x000000072f2f7812ULL, 0x000fe200078e7852ULL,
0x000000003838783bULL, 0x000e620000000200ULL, 0x0000001030307824ULL, 0x000fe200078e00ffULL,
0x000000042e00780cULL, 0x000fe20003f25270ULL, 0x000000103f3f7824ULL, 0x000fe200078e0250ULL,
0x000000042d2d7810ULL, 0x000fe20007ffe0ffULL, 0x00000010522f7824ULL, 0x000fc400078e022fULL,
0x000000003030783bULL, 0x000ea40000000200ULL, 0x000000102f2f7824ULL, 0x000fe400078e00ffULL,
0x000000003f40783bULL, 0x0007220000000200ULL, 0x00000038ff44723eULL, 0x082fe400020006ffULL,
0x00000038ff45723eULL, 0x000fe400030006ffULL, 0x00000039ff46723eULL, 0x080fe400020006ffULL,
0x00000039ff47723eULL, 0x000fc400030006ffULL, 0x0000003aff38723eULL, 0x080fe200020006ffULL,
0x00000044301c723cULL, 0x044fe2000000181cULL, 0x0000003aff39723eULL, 0x000fe400030006ffULL,
0x0000003bff3a723eULL, 0x080fe400020006ffULL, 0x0000003bff3b723eULL, 0x000fe400030006ffULL,
0x0000003e37457212ULL, 0x000fe200078e3cffULL, 0x000000383024723cULL, 0x000fe80000001824ULL,
0x0000000436457824ULL, 0x000fc800078e0245ULL, 0x0000003a3038723cULL, 0x000fe20000001808ULL,
0x00000010453f7824ULL, 0x008fca00078e0250ULL, 0x000000003f48783bULL, 0x000e620000000200ULL,
0x0000003e3d0b7212ULL, 0x000fe200078e3cffULL, 0x000000463020723cULL, 0x000fe20000001820ULL,
0x00000040ff08723eULL, 0x090fe200020006ffULL, 0x000000002f44783bULL, 0x000ea20000000200ULL,
0x00000040ff09723eULL, 0x000fe200030006ffULL, 0x000000043c0b7824ULL, 0x000fe200078e020bULL,
0x00000041ff40723eULL, 0x080fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe200030006ffULL,
0x000000100b0b7824ULL, 0x000fc400078e0250ULL, 0x00000008300c723cULL, 0x040fe6000000180cULL,
0x000000000b4c783bULL, 0x000ee80000000200ULL, 0x00000042ff08723eULL, 0x080fe200020006ffULL,
0x000000403010723cULL, 0x000fe20000001810ULL, 0x00000042ff09723eULL, 0x000fe400030006ffULL,
0x00000043ff42723eULL, 0x000fc400020006ffULL, 0x00000043ff43723eULL, 0x000fc600030006ffULL,
0x000000083014723cULL, 0x040ff00000001814ULL, 0x000000423018723cULL, 0x000fe20000001818ULL,
0x00000048ff08723eULL, 0x082fe400020006ffULL, 0x00000048ff09723eULL, 0x000fc400030006ffULL,
0x00000049ff48723eULL, 0x080fe400020006ffULL, 0x00000049ff49723eULL, 0x000fc600030006ffULL,
0x00000008441c723cULL, 0x004fe2000000181cULL, 0x0000004cff30723eULL, 0x088fe400020006ffULL,
0x0000004cff31723eULL, 0x000fca00030006ffULL, 0x000000484420723cULL, 0x040fe20000001820ULL,
0x0000004aff08723eULL, 0x080fe400020006ffULL, 0x0000004aff09723eULL, 0x000fe400030006ffULL,
0x0000004dff4c723eULL, 0x080fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe200030006ffULL,
0x00000030440c723cULL, 0x040fee000000180cULL, 0x0000004eff30723eULL, 0x080fe200020006ffULL,
0x000000084424723cULL, 0x000fe20000001824ULL, 0x0000004eff31723eULL, 0x000fc400030006ffULL,
0x0000004fff4e723eULL, 0x080fe400020006ffULL, 0x0000004fff4f723eULL, 0x000fe400030006ffULL,
0x0000004bff08723eULL, 0x080fe200020006ffULL, 0x0000004c4410723cULL, 0x000fe20000001810ULL,
0x0000004bff09723eULL, 0x000fce00030006ffULL, 0x000000084408723cULL, 0x040ff00000001838ULL,
0x000000304414723cULL, 0x040ff00000001814ULL, 0x0000004e4418723cULL, 0x000fe20000001818ULL,
0xfffffb0000001947ULL, 0x000fee000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff407224ULL, 0x000fe200078e002cULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffef0000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000282e7f8cULL, 0x000fe2000c80043fULL,
0x0000001d071d7220ULL, 0x040fe20000410000ULL, 0x0000002207327220ULL, 0x040fe20000410000ULL,
0x0000001c071c7220ULL, 0x040fe20000410000ULL, 0x00000400282d7984ULL, 0x000e620000000800ULL,
0x0000001e07307220ULL, 0x040fe20000410000ULL, 0x0000001f07317220ULL, 0x040fe20000410000ULL,
0x0000001907227220ULL, 0x040fe20000410000ULL, 0x0000002107217220ULL, 0x040fe20000410000ULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000002407247220ULL, 0x040fe20000410000ULL,
0x0000002507257220ULL, 0x040fe20000410000ULL, 0x00000015071e7220ULL, 0x040fe20000410000ULL,
0x00000018071f7220ULL, 0x040fe20000410000ULL, 0x0000002607267220ULL, 0x040fe20000410000ULL,
0x0000002707277220ULL, 0x040fe20000410000ULL, 0x0000000a07337220ULL, 0x040fe20000410000ULL,
0x0000000b07367220ULL, 0x040fe20000410000ULL, 0x0000000e07377220ULL, 0x040fe20000410000ULL,
0x0000002007207220ULL, 0x040fe20000410000ULL, 0x0000000807087220ULL, 0x040fe20000410000ULL,
0x0000000907097220ULL, 0x040fe20000410000ULL, 0x0000000c070c7220ULL, 0x040fe20000410000ULL,
0x0000000d070d7220ULL, 0x040fe20000410000ULL, 0x0000000f07387220ULL, 0x040fe20000410000ULL,
0x0000001007007220ULL, 0x040fe20000410000ULL, 0x00000011070a7220ULL, 0x040fe20000410000ULL,
0x0000001207397220ULL, 0x040fe20000410000ULL, 0x00000013073a7220ULL, 0x040fe20000410000ULL,
0x00000014070b7220ULL, 0x040fe20000410000ULL, 0x00000016073b7220ULL, 0x040fe20000410000ULL,
0x00000017073c7220ULL, 0x040fe20000410000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e001dULL,
0x0000001b073e7220ULL, 0x040fe20000410000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e001cULL,
0x0000001a073d7220ULL, 0x000fe20000410000ULL, 0x000000ffff1d7224ULL, 0x000fc400078e0022ULL,
0x000000ffff117224ULL, 0x000fe400078e0021ULL, 0x000000ffff127224ULL, 0x000fe400078e0024ULL,
0x000000ffff137224ULL, 0x000fe400078e0025ULL, 0x000000ffff1b7224ULL, 0x000fe200078e001eULL,
0x800000002dff7812ULL, 0x002fe2000780482fULL, 0x000000ffff1c7224ULL, 0x000fe400078e001fULL,
0x000000ffff227224ULL, 0x000fc400078e0023ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0030ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0031ULL, 0x000000ffff217224ULL, 0x000fe400078e0032ULL,
0x000000ffff237224ULL, 0x000fe400078e0026ULL, 0x000000ffff247224ULL, 0x000fe400078e0027ULL,
0x000000ffff257224ULL, 0x000fc400078e0033ULL, 0x000000ffff107224ULL, 0x000fe400078e0020ULL,
0x000000ffff147224ULL, 0x000fe400078e0008ULL, 0x000000ffff157224ULL, 0x000fe400078e0009ULL,
0x000000ffff167224ULL, 0x000fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000dULL,
0x000000ffff187224ULL, 0x000fc400078e0000ULL, 0x000000ffff197224ULL, 0x000fe400078e000aULL,
0x000000ffff1a7224ULL, 0x000fe400078e000bULL, 0x000000ffff267224ULL, 0x000fe400078e0036ULL,
0x000000ffff277224ULL, 0x000fe400078e0037ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0038ULL,
0x000000ffff307224ULL, 0x000fc400078e0039ULL, 0x000000ffff317224ULL, 0x000fe400078e003aULL,
0x000000ffff327224ULL, 0x000fe400078e003bULL, 0x000000ffff337224ULL, 0x000fe200078e003cULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe400078e003dULL, 0x000000ffff377224ULL, 0x000fe200078e003eULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000087305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000080000735dULL, 0x004fe20003800000ULL, 0x0000040028097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc4000780482fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000406207824ULL, 0x000fe200078e00ffULL, 0x0000002a0300720cULL, 0x000fc80003f05270ULL,
0xfffffff020007812ULL, 0x000fca00078ec0ffULL, 0x0000008035007824ULL, 0x000fca00078e0200ULL,
0x00f4000000087984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x00000002060c7824ULL, 0x000fe400078e00ffULL, 0x00000001342b7824ULL, 0x000fc600078e0a2bULL,
0x000000060c0c7812ULL, 0x000fc800078ec0ffULL, 0x000000010c2e7812ULL, 0x040fe400078efcffULL,
0x000000080c387812ULL, 0x000fe400078efcffULL, 0x0000002b2e00720cULL, 0x080fe40003f26070ULL,
0x000000100c2e7812ULL, 0x000fe400078efcffULL, 0x0000002b3800720cULL, 0x080fe40003f06070ULL,
0x0000002b2e00720cULL, 0x000fc40003fc6070ULL, 0x000000110c387812ULL, 0x040fe400078efcffULL,
0x000000180c2e7812ULL, 0x040fe400078efcffULL, 0x0000002b0c00720cULL, 0x080fe40003f46070ULL,
0x0000002b3800720cULL, 0x080fe40003fa6070ULL, 0x0000002b2e00720cULL, 0x000fe40003f66070ULL,
0x000000090c3a7812ULL, 0x000fc400078efcffULL, 0x000000190c387812ULL, 0x040fe400078efcffULL,
0x000000200c2e7812ULL, 0x000fe400078efcffULL, 0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40005000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL,
0xff7fffff0e0e7808ULL, 0x000fc40004800000ULL, 0x0000002b3a00720cULL, 0x080fe40003f86070ULL,
0x0000002b3800720cULL, 0x080fe40003f46070ULL, 0x0000002b2e00720cULL, 0x000fe40003f26070ULL,
0x000000210c387812ULL, 0x040fe400078efcffULL, 0x000000280c2e7812ULL, 0x000fe400078efcffULL,
0xff7fffff21217808ULL, 0x000fc40004000000ULL, 0xff7fffff10107808ULL, 0x000fe40004000000ULL,
0xff7fffff22227808ULL, 0x000fe40006000000ULL, 0xff7fffff11117808ULL, 0x000fe40006000000ULL,
0x0000002b3800720cULL, 0x080fe40003f06070ULL, 0x0000002b2e00720cULL, 0x000fe40003f86070ULL,
0x000000290c387812ULL, 0x000fc400078efcffULL, 0x000000300c2e7812ULL, 0x000fe400078efcffULL,
0xff7fffff23237808ULL, 0x000fe40007000000ULL, 0xff7fffff12127808ULL, 0x000fe40007000000ULL,
0xff7fffff24247808ULL, 0x000fe40006800000ULL, 0xff7fffff13137808ULL, 0x000fe40006800000ULL,
0x0000002b3800720cULL, 0x000fc40003fc6070ULL, 0x0000002b2e00720cULL, 0x000fe40003fa6070ULL,
0x000000310c387812ULL, 0x040fe400078efcffULL, 0x000000380c2e7812ULL, 0x040fe400078efcffULL,
0x000000390c0c7812ULL, 0x000fe400078efcffULL, 0xff7fffff25257808ULL, 0x000fe40005800000ULL,
0xff7fffff14147808ULL, 0x000fc40005800000ULL, 0xff7fffff26267808ULL, 0x000fe40005000000ULL,
0xff7fffff15157808ULL, 0x000fe40005000000ULL, 0xff7fffff27277808ULL, 0x000fe40004800000ULL,
0xff7fffff16167808ULL, 0x000fe40004800000ULL, 0x0000002b3800720cULL, 0x080fe40003f66070ULL,
0x0000002b2e00720cULL, 0x000fc40003f46070ULL, 0x0000002b0c00720cULL, 0x000fe40003f26070ULL,
0xff7fffff2d2d7808ULL, 0x000fe40004000000ULL, 0xff7fffff17177808ULL, 0x000fe40004000000ULL,
0xff7fffff30307808ULL, 0x000fe40006000000ULL, 0xff7fffff18187808ULL, 0x000fe40006000000ULL,
0xff7fffff31317808ULL, 0x000fc40007000000ULL, 0xff7fffff19197808ULL, 0x000fe40007000000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL, 0xff7fffff32327808ULL, 0x000fe40006800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL, 0xff7fffff33337808ULL, 0x000fe40005800000ULL,
0xff7fffff1c1c7808ULL, 0x000fc40005000000ULL, 0xff7fffff36367808ULL, 0x000fe40005000000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL, 0xff7fffff37377808ULL, 0x000fe40004800000ULL,
0x0000000f080d7209ULL, 0x004fe20007810000ULL, 0x0000001fff3b7424ULL, 0x000fe200078e00ffULL,
0x0000001e09087209ULL, 0x000fe20007810000ULL, 0xffffffffff3c7424ULL, 0x000fe200078e00ffULL,
0x0000000e0d0d7209ULL, 0x000fe40007810000ULL, 0x0000001f08087209ULL, 0x000fc40007810000ULL,
0x000000100d0c7209ULL, 0x000fe40007810000ULL, 0x0000002108097209ULL, 0x000fe40007810000ULL,
0x000000110c0d7209ULL, 0x000fe40007810000ULL, 0x0000002209087209ULL, 0x000fe40007810000ULL,
0x000000120d0c7209ULL, 0x000fe40007810000ULL, 0x0000002308097209ULL, 0x000fc40007810000ULL,
0x000000130c0d7209ULL, 0x000fe40007810000ULL, 0x0000002409087209ULL, 0x000fe40007810000ULL,
0x000000140d0c7209ULL, 0x000fe40007810000ULL, 0x0000002508097209ULL, 0x000fe40007810000ULL,
0x000000150c0d7209ULL, 0x000fe40007810000ULL, 0x0000002609087209ULL, 0x000fc40007810000ULL,
0x000000160d0c7209ULL, 0x000fe40007810000ULL, 0x0000002708087209ULL, 0x000fe40007810000ULL,
0x000000170c097209ULL, 0x000fe40007810000ULL, 0x0000002d080d7209ULL, 0x000fe40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x000000300d0c7209ULL, 0x000fc40007810000ULL,
0x0000001908097209ULL, 0x000fe40007810000ULL, 0x000000310c0d7209ULL, 0x000fe40007810000ULL,
0x0000001a09087209ULL, 0x000fe40007810000ULL, 0x000000320d0c7209ULL, 0x000fe40007810000ULL,
0x0000001b08097209ULL, 0x000fe40007810000ULL, 0x000000330c0d7209ULL, 0x000fc40007810000ULL,
0x0000001c09087209ULL, 0x000fe40007810000ULL, 0x000000360d0c7209ULL, 0x000fe40007810000ULL,
0x0000001d08097209ULL, 0x000fe40007810000ULL, 0x000000370c2f7209ULL, 0x000fe20007810000ULL,
0x000017c27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0009087f89ULL, 0x0004e400000e0000ULL,
0x0000000809397209ULL, 0x008fe20007810000ULL, 0x000017f27f007947ULL, 0x000fea000b800000ULL,
0x0c401f002f087f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a097f89ULL, 0x004ea800000e0000ULL,
0x0c401f000b2e7f89ULL, 0x000f2200000e0000ULL, 0x000000082f0c7209ULL, 0x008fc60007810000ULL,
0x0c201f0039087f89ULL, 0x000ee200000e0000ULL, 0x000000090a0d7209ULL, 0x004fc60007810000ULL,
0x0c201f000c097f89ULL, 0x000ea200000e0000ULL, 0x0000002e0b2e7209ULL, 0x010fc60007810000ULL,
0x0c201f000d387f89ULL, 0x002e6800000e0000ULL, 0x0c201f002e2b7f89ULL, 0x00092200000e0000ULL,
0x0000000839087209ULL, 0x008fe40007810000ULL, 0x000000090c097209ULL, 0x004fe40007810000ULL,
0x000000380d0a7209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b080b7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b09387820ULL, 0x002fe20000410000ULL, 0x3c003c00ff3a7424ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b10107823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b11117823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010838ULL, 0x0000000f000c7308ULL, 0x000fe20000000800ULL,
0x3c003c00ff3b7424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b12127823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b15157823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010838ULL, 0x0000000e000d7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010838ULL, 0x0000001000107308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b1d0b7823ULL, 0x000fe2000001080bULL, 0x0000001100117308ULL, 0x000ee20000000800ULL,
0x0000000c0d0c723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b37377823ULL, 0x000fe20000010838ULL, 0x0000000000057886ULL, 0x000fc400038e0100ULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000001f001f7308ULL, 0x000e620000000800ULL,
0x00000010110e723eULL, 0x008fce00000000ffULL, 0x00000021000f7308ULL, 0x0007f00000000800ULL,
0x0000002200227308ULL, 0x000f620000000800ULL, 0x0000001e1f0d723eULL, 0x002fe200000000ffULL,
0x0000000fff217424ULL, 0x008fcc00078e00ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x0000000f220f723eULL, 0x020fce00000000ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000003a0c3c723cULL, 0x000fee00000018ffULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ee20000000800ULL, 0x000000121310723eULL, 0x002fce00000000ffULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000002400247308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x008fce00000000ffULL, 0x0000002500257308ULL, 0x000ff00000000800ULL,
0x0000002600267308ULL, 0x000ee20000000800ULL, 0x000000232411723eULL, 0x002fce00000000ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000252613723eULL, 0x008fce00000000ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x0000003a103c723cULL, 0x000fee000000183cULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000001900197308ULL, 0x000ee20000000800ULL,
0x000000161714723eULL, 0x002fce00000000ffULL, 0x0000002700277308ULL, 0x000ff00000000800ULL,
0x0000002d001e7308ULL, 0x000e620000000800ULL, 0x000000181916723eULL, 0x008fe400000000ffULL,
0xfffffffc06187812ULL, 0x000fc800078ec0ffULL, 0x0000001821217219ULL, 0x000fe200000006ffULL,
0x0000003000307308ULL, 0x000fe60000000800ULL, 0x00000000210473c4ULL, 0x000eea0000004000ULL,
0x0000003100317308ULL, 0x000f620000000800ULL, 0x000000271e15723eULL, 0x002fc400000000ffULL,
0x00000000211e73a1ULL, 0x000e6a00000e8000ULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x000000303117723eULL, 0x020fce00000000ffULL, 0x0000001b001b7308ULL, 0x000f620000000800ULL,
0x0000003a143c723cULL, 0x000fee000000183cULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x0000000521ff7c12ULL, 0x002fce000f80401eULL, 0x0000000b000b7308ULL, 0x000e620000000800ULL,
0x0000001a1b18723eULL, 0x020fce00000000ffULL, 0x0000003200327308ULL, 0x000ff00000000800ULL,
0x0000003300337308ULL, 0x000f620000000800ULL, 0x0000001c0b1a723eULL, 0x002fe400000000ffULL,
0x0000002e2b0b7209ULL, 0x014fca0007810000ULL, 0x0000003600367308ULL, 0x000ff00000000800ULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x000000323319723eULL, 0x020fe400000000ffULL,
0x00000036371b723eULL, 0x002fce00000000ffULL, 0x0000003a183c723cULL, 0x000fe2000000183cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000132204008947ULL, 0x008fde000b800000ULL,
0x001c1fff3c1c7589ULL, 0x0002a400000e0000ULL, 0x00000000211e73a1ULL, 0x000ee200000e8000ULL,
0x00000000210473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x0000000521ff7c12ULL, 0x008fda000f80401eULL, 0x0000134204008947ULL, 0x010fea000b800000ULL,
0x001c1fff3e1d7589ULL, 0x00072800000e0000ULL, 0x001c1fff1e1e7589ULL, 0x00066800000e0000ULL,
0x001c1fff001f7589ULL, 0x0006a400000e0000ULL, 0x00000002ff217819ULL, 0x00afe40000011606ULL,
0x0000000c203b7812ULL, 0x000fc400078ec0ffULL, 0x0000000721227812ULL, 0x040fe200078ec0ffULL,
0x0000000821277824ULL, 0x040fe200078e00ffULL, 0x00000021ff257212ULL, 0x000fe200078e33ffULL,
0x0000000821237824ULL, 0x040fe200078e00ffULL, 0x0000000306ff7812ULL, 0x000fe2000780c0ffULL,
0x00000008213a7824ULL, 0x040fe200078e00ffULL, 0x0000000821217810ULL, 0x000fe40007ffe0ffULL,
0xfffffff827247812ULL, 0x100fe400078ee222ULL, 0x0000000123267812ULL, 0x100fe200078ef622ULL,
0x00000008214a7824ULL, 0x000fe200078e00ffULL, 0x00000002232e7812ULL, 0x100fe200078ef622ULL,
0x0000000821277824ULL, 0x000fe200078e00ffULL, 0x0000000323307812ULL, 0x000fc400078ef622ULL,
0x0000000423327812ULL, 0x140fe400078ef622ULL, 0x0000000523367812ULL, 0x140fe400078ef622ULL,
0x0000000623387812ULL, 0x000fe200078ef622ULL, 0x0000000821237824ULL, 0x040fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe400078ee225ULL, 0x00000021ff257212ULL, 0x000fe400078e33ffULL,
0x0000000721227812ULL, 0x000fc400078ec0ffULL, 0x0000900035217811ULL, 0x000fe400078e58ffULL,
0xfffffff84a4a7812ULL, 0x000fe400078ee225ULL, 0xfffffff8273c7812ULL, 0x100fe200078ee222ULL,
0x0000001024207824ULL, 0x100fe200078e0221ULL, 0x00000001233e7812ULL, 0x140fe200078ef622ULL,
0x000000102e247824ULL, 0x100fe200078e0221ULL, 0x0000000223407812ULL, 0x140fe200078ef622ULL,
0x00000010322b7824ULL, 0x100fe200078e0221ULL, 0x0000000323427812ULL, 0x140fe200078ef622ULL,
0x00000010362d7824ULL, 0x100fe200078e0221ULL, 0x0000000423447812ULL, 0x140fe200078ef622ULL,
0x00000010382e7824ULL, 0x100fe200078e0221ULL, 0x0000000523467812ULL, 0x140fe200078ef622ULL,
0x000000103e327824ULL, 0x100fe200078e0221ULL, 0x0000000623487812ULL, 0x000fe200078ef622ULL,
0x0000001026227824ULL, 0x000fc400078e0221ULL, 0x0000001030267824ULL, 0x100fe400078e0221ULL,
0x000000103a307824ULL, 0x100fe400078e0221ULL, 0x000000013b237824ULL, 0x000fe400078e0220ULL,
0x000000103c207824ULL, 0x100fe400078e0221ULL, 0x0000001040337824ULL, 0x100fe200078e0221ULL,
0x0000000c23007388ULL, 0x0003e20000000800ULL, 0x0000001042367824ULL, 0x000fc400078e0221ULL,
0x0000001044377824ULL, 0x100fe400078e0221ULL, 0x0000001046387824ULL, 0x100fe400078e0221ULL,
0x0000001048397824ULL, 0x100fe400078e0221ULL, 0x000000104a3a7824ULL, 0x000fe400078e0221ULL,
0x000000013b217824ULL, 0x040fe400078e0222ULL, 0x000000013b257824ULL, 0x000fc400078e0224ULL,
0x000000013b277824ULL, 0x040fe200078e0226ULL, 0x0000000e21007388ULL, 0x0007e20000000800ULL,
0x000000013b2b7824ULL, 0x040fe400078e022bULL, 0x000000013b2d7824ULL, 0x040fe200078e022dULL,
0x0000001025007388ULL, 0x0007e20000000800ULL, 0x000000013b2f7824ULL, 0x040fe400078e022eULL,
0x000000013b317824ULL, 0x040fe200078e0230ULL, 0x0000001227007388ULL, 0x0007e20000000800ULL,
0x000000013b207824ULL, 0x000fc400078e0220ULL, 0x000000013b327824ULL, 0x040fe200078e0232ULL,
0x000000142b007388ULL, 0x0007e20000000800ULL, 0x000000013b227824ULL, 0x040fe400078e0233ULL,
0x000000013b367824ULL, 0x040fe200078e0236ULL, 0x000000162d007388ULL, 0x0007e20000000800ULL,
0x000000013b0c7824ULL, 0x042fe400078e0237ULL, 0x000000013b387824ULL, 0x040fe200078e0238ULL,
0x000000182f007388ULL, 0x0007e20000000800ULL, 0x000000013b247824ULL, 0x000fc400078e0239ULL,
0x000000013b3a7824ULL, 0x000fe200078e023aULL, 0x0000001a31007388ULL, 0x0007e80000000800ULL,
0x0000000d20007388ULL, 0x0007e80000000800ULL, 0x0000000f32007388ULL, 0x0007e80000000800ULL,
0x0000001122007388ULL, 0x0007e80000000800ULL, 0x0000001336007388ULL, 0x0007e80000000800ULL,
0x000000150c007388ULL, 0x0007e80000000800ULL, 0x0000001738007388ULL, 0x0007e80000000800ULL,
0x0000001924007388ULL, 0x0007e80000000800ULL, 0x0000001b3a007388ULL, 0x0007e80000000800ULL,
0x00f0000800008388ULL, 0x0007e80000000c00ULL, 0x00f2001c00008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000029ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080029ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100029ff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030003037a10ULL, 0x000fe20007ffe0ffULL,
0x0000180029ff7f8cULL, 0x0003e6000c80043fULL, 0x000000020300720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffd31000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff2a7807ULL, 0x010fe40004000000ULL,
0x0000dd80002d7802ULL, 0x000fe40000000f00ULL, 0x00000f5000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e002cULL, 0xffff393000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2a7807ULL, 0x000fe40004000000ULL, 0x0000ddd0002d7802ULL, 0x000fe40000000f00ULL,
0x00000f0000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e002cULL,
0xffff397000007947ULL, 0x000fea000383ffffULL, 0x000000ffff317224ULL, 0x004fe200078e0000ULL,
0x0000de40002e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff327424ULL, 0x000fe400078e00ffULL,
0xffffffffff337424ULL, 0x000fc400078e00ffULL, 0x00000e5000007944ULL, 0x01afea0003c00000ULL,
0x000000ffff287224ULL, 0x004fe200078e002dULL, 0xffff39c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff317224ULL, 0x004fe200078e0000ULL, 0x0000deb0002e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff327424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x00000de000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e002dULL,
0xffff398000007947ULL, 0x000fea000383ffffULL, 0x000000ffff317224ULL, 0x000fe200078e0029ULL,
0x0000df20002e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff327424ULL, 0x000fe400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x00000d7000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff537224ULL, 0x004fe200078e002dULL, 0xffff3ce000007947ULL, 0x000fea000383ffffULL,
0x000000ffff317224ULL, 0x002fe200078e0046ULL, 0x0000df90002e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff327424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x00000d0000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e002dULL,
0xffff3ca000007947ULL, 0x000fea000383ffffULL, 0x00000001ff2a7807ULL, 0x002fe40004000000ULL,
0x0000dfe0002d7802ULL, 0x000fc40000000f00ULL, 0x00000cf000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff267224ULL, 0x000fe200078e002cULL, 0xffff4e5000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2a7807ULL, 0x000fe40004000000ULL, 0x0000e030002d7802ULL, 0x000fc40000000f00ULL,
0x00000ca000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff267224ULL, 0x000fe200078e002cULL,
0xffff4e9000007947ULL, 0x000fea000383ffffULL, 0x0000001fff327424ULL, 0x002fe200078e00ffULL,
0x0000e090002e7802ULL, 0x000fe20000000f00ULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x00000c0000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e002dULL,
0xffff4f0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff317224ULL, 0x002fe200078e0046ULL,
0x0000e100002e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff327424ULL, 0x000fc400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x00000b9000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e002dULL, 0xffff4fb000007947ULL, 0x000fea000383ffffULL,
0x0000001fff327424ULL, 0x000fe200078e00ffULL, 0x0000e160002e7802ULL, 0x000fe20000000f00ULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x00000b3000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff637224ULL, 0x004fe200078e002dULL, 0xffff527000007947ULL, 0x000fea000383ffffULL,
0x000000ffff317224ULL, 0x002fe200078e0046ULL, 0x0000e1d0002e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff327424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x00000ac000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e002dULL,
0xffff522000007947ULL, 0x000fea000383ffffULL, 0x00000001ff2a7807ULL, 0x002fe40004000000ULL,
0x0000e220002d7802ULL, 0x000fc40000000f00ULL, 0x00000ab000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e002cULL, 0xffff5fb000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2a7807ULL, 0x000fe40004000000ULL, 0x0000e270002d7802ULL, 0x000fc40000000f00ULL,
0x00000a6000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e002cULL,
0xffff5ff000007947ULL, 0x000fea000383ffffULL, 0x0000001fff327424ULL, 0x002fe200078e00ffULL,
0x0000e2d0002e7802ULL, 0x000fe20000000f00ULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x000009c000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002dULL,
0xffff606000007947ULL, 0x000fea000383ffffULL, 0x000000ffff317224ULL, 0x002fe200078e0046ULL,
0x0000e340002e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff327424ULL, 0x000fc400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x0000095000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002dULL, 0xffff611000007947ULL, 0x000fea000383ffffULL,
0x0000001fff327424ULL, 0x000fe200078e00ffULL, 0x0000e3a0002e7802ULL, 0x000fe20000000f00ULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x000008f000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff2b7224ULL, 0x004fe200078e002dULL, 0xffff63c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff317224ULL, 0x002fe200078e0046ULL, 0x0000e410002e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff327424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0000088000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e002dULL,
0xffff637000007947ULL, 0x000fea000383ffffULL, 0x00000001ff2a7807ULL, 0x010fe40004000000ULL,
0x0000e460002d7802ULL, 0x000fc40000000f00ULL, 0x0000087000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e002cULL, 0xffff714000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2a7807ULL, 0x000fe40004000000ULL, 0x0000e4b0002d7802ULL, 0x000fc40000000f00ULL,
0x0000082000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e002cULL,
0xffff718000007947ULL, 0x000fea000383ffffULL, 0x0000001fff327424ULL, 0x008fe200078e00ffULL,
0x0000e510002e7802ULL, 0x000fe20000000f00ULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000078000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002dULL,
0xffff71f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff317224ULL, 0x00afe200078e0046ULL,
0x0000e580002e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff327424ULL, 0x000fc400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x0000071000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002dULL, 0xffff72a000007947ULL, 0x000fea000383ffffULL,
0x0000001fff327424ULL, 0x000fe200078e00ffULL, 0x0000e5e0002e7802ULL, 0x000fe20000000f00ULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x000006b000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff297224ULL, 0x004fe200078e002dULL, 0xffff757000007947ULL, 0x000fea000383ffffULL,
0x000000ffff317224ULL, 0x002fe200078e0046ULL, 0x0000e650002e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff327424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0000064000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e002dULL,
0xffff752000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x000fe200078e0009ULL,
0x0000e6b0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff387424ULL, 0x000fc400078e00ffULL,
0x000005a000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e002bULL,
0xffffe7f000007947ULL, 0x000fea000383ffffULL, 0x0000002f002b7202ULL, 0x000fe20000000f00ULL,
0x00000002ff387424ULL, 0x002fe200078e00ffULL, 0x0000e710000c7802ULL, 0x000fc40000000f00ULL,
0x0000054000007944ULL, 0x004fea0003c00000ULL, 0x0000002b2f3a7209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e000aULL, 0x0000e760000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff387424ULL, 0x002fc400078e00ffULL, 0x000004f000007944ULL, 0x000fea0003c00000ULL,
0x0000002b0a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e000bULL,
0x0000e7b0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff387424ULL, 0x002fc400078e00ffULL,
0x000004a000007944ULL, 0x000fea0003c00000ULL, 0x0000002b0b2e7209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0039ULL, 0x0000e800000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff387424ULL, 0x002fc400078e00ffULL, 0x0000045000007944ULL, 0x000fea0003c00000ULL,
0x0000002b39087209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e003aULL,
0x0000e850000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff387424ULL, 0x002fc400078e00ffULL,
0x0000040000007944ULL, 0x000fea0003c00000ULL, 0x0000002b3a097209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e000aULL, 0x0000e8a0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff387424ULL, 0x002fc400078e00ffULL, 0x000003b000007944ULL, 0x000fea0003c00000ULL,
0x0000002b0a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e002eULL,
0x0000e8f0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff387424ULL, 0x002fc400078e00ffULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0xffffe6b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e003cULL, 0x0000e960002e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff317224ULL, 0x000fc400078e00ffULL, 0x00001c1fff327424ULL, 0x000fe400078e00ffULL,
0x000000ffff337224ULL, 0x000fe400078e0021ULL, 0x0000033000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e002dULL, 0xffffec7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x002fe200078e003eULL, 0x0000e9e0002e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff317224ULL, 0x000fe400078e00ffULL, 0x00001c1fff327424ULL, 0x000fe400078e00ffULL,
0x000000ffff337224ULL, 0x000fe400078e0021ULL, 0x000002b000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff317224ULL, 0x002fe200078e00ffULL, 0x0000ea40002e7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff327424ULL, 0x000fc400078e00ffULL, 0x000000ffff337224ULL, 0x000fe400078e0021ULL,
0x000000ffff1d7224ULL, 0x004fe400078e002dULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff337224ULL, 0x002fe200078e0021ULL, 0x0000eaa0002e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff317224ULL, 0x000fe400078e00ffULL, 0x00001c1fff327424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x004fe400078e002dULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x004fe200078e002dULL, 0xffffebb000007947ULL, 0x000fea000383ffffULL,
0x018000003d027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000003d00028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff3dff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x800000003d037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003d00027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0006ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xffff13b002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003c00007348ULL, 0x000fe80003800000ULL, 0x0c0000382b2b7389ULL, 0x0002a200000e003bULL,
0xffff13700c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000003300007348ULL, 0x000fe80003800000ULL, 0x00000031302d7389ULL, 0x0002a200000e0032ULL,
0xffff13302e007950ULL, 0x000fea0003c3ffffULL, 0x000000012a00780cULL, 0x000fe20003f05070ULL,
0x0000004500007348ULL, 0x000fe80003800000ULL, 0x00000000ff2b7424ULL, 0x000fd000078e00ffULL,
0x00000000002a7806ULL, 0x000fc800040e0100ULL, 0x000000452a2c7212ULL, 0x000fe200078ec0ffULL,
0x000000ffff2a7224ULL, 0x000fc800078e002dULL, 0xffff12c02a007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000520ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000b00ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000b90ULL, 0x0000000000000880ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001410ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001430ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001440ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001460ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000014f0ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000014f8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001508ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001700ULL, 0x000000000000ee00ULL, 0x7200001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000010500ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000010510ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000010510ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000010990ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000014f0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000f010ULL, 0x000000000000f010ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000010500ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000010990ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_89_cubin_len = 68208;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
