/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000014440ULL, 0x00000000000140c0ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x326a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL,
0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL, 0x45316a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x000000676e696469ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL, 0x305f6c616e726574ULL,
0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL,
0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL, 0x616c65722e006168ULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL,
0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL,
0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000135ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b0001000001beULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000b000100000204ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b00010000024bULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000291ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b0001000002dfULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000032dULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b00010000037bULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003c9ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b00010000040fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b00010000045dULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004b8ULL, 0x0000000000012a50ULL,
0x0000000000000230ULL, 0x000400030000052eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000012c80ULL, 0x000d00030000055eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00012a5000000000ULL,
0x0000140400000000ULL, 0x0008288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL,
0x0000006000000000ULL, 0x00012a5000000000ULL, 0x0000023000000000ULL, 0x0000580400000000ULL,
0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL, 0x0008230400000080ULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000008ULL, 0x0000000800000015ULL,
0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000000800000017ULL, 0x0000001700081104ULL,
0x0004370400000008ULL, 0x000c17040000007bULL, 0x0058000a00000000ULL, 0x000c17040021f000ULL,
0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040061f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0xffffffff00942904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000036000942804ULL,
0x00000a60000004b0ULL, 0x00002970000028f0ULL, 0x00002b8000002a40ULL, 0x0000309000003080ULL,
0x00004ca000004c30ULL, 0x00004ec000004d80ULL, 0x000053c0000053b0ULL, 0x00006f6000006f00ULL,
0x000071a000007060ULL, 0x000075f0000075e0ULL, 0x00009190000090f0ULL, 0x0000939000009250ULL,
0x0000982000009810ULL, 0x0000a8f00000a8e0ULL, 0x00011e8000011bd0ULL, 0x0001216000011f30ULL,
0x00012510000121e0ULL, 0x00012780000126a0ULL, 0x0000054004303904ULL, 0x00017600000000ffULL,
0x0000062000040100ULL, 0x0001760800000006ULL, 0x00000730003f0100ULL, 0x0001768800000006ULL,
0x00000880003f0100ULL, 0x000176a800000004ULL, 0x00000980003f0100ULL, 0x000176c800000003ULL,
0x000010e0003f0100ULL, 0x00017600000000ffULL, 0x0000122000080107ULL, 0x000176880000004bULL,
0x00001a9000080101ULL, 0x00000000000000ffULL, 0x00001ac000040107ULL, 0x00000000000000ffULL,
0x00001b4000040101ULL, 0x0000002000000004ULL, 0x00001c00003f0101ULL, 0x000176c800000009ULL,
0x00001d9000080109ULL, 0x000176c800000015ULL, 0x000025e0003f0109ULL, 0x000176b000000004ULL,
0x0000265000080107ULL, 0x000176b000000006ULL, 0x00002660003f0101ULL, 0x000176080000001aULL,
0x000026a0003f0101ULL, 0x0001760800000010ULL, 0x00002810003f0109ULL, 0x0001760800000010ULL,
0x00002d30003f0109ULL, 0x000176a800000006ULL, 0x00002eb000080109ULL, 0x000176a80000000aULL,
0x00003fe0003f0109ULL, 0x000176c800000007ULL, 0x00004010003f0101ULL, 0x000176880000003cULL,
0x0000404000080101ULL, 0x0000000000000012ULL, 0x000041b0003f0109ULL, 0x0000000000000012ULL,
0x00004950003f0109ULL, 0x000176a800000006ULL, 0x000049d000080107ULL, 0x000176a800000014ULL,
0x000049e0003f0101ULL, 0x0001762800000007ULL, 0x00004a00003f0101ULL, 0x0001762800000010ULL,
0x00004b70003f0109ULL, 0x0001762800000010ULL, 0x00005070003f0109ULL, 0x000176b000000017ULL,
0x000051f000080109ULL, 0x000176b00000001bULL, 0x000062e0003f0109ULL, 0x000176c80000003cULL,
0x000062f0003f0101ULL, 0x0001769000000046ULL, 0x0000632000080101ULL, 0x0000000000000012ULL,
0x00006490003f0109ULL, 0x0000000000000012ULL, 0x00006bf0003f0109ULL, 0x00000008000000ffULL,
0x00006c6000040107ULL, 0x0000000800000046ULL, 0x00006c70003f0101ULL, 0x0001764800000010ULL,
0x00006ce0003f0101ULL, 0x0001764800000041ULL, 0x00006e50003f0109ULL, 0x0001764800000041ULL,
0x00007360003f0109ULL, 0x000176a80000001fULL, 0x000074e000080109ULL, 0x000176a80000003fULL,
0x00008490003f0109ULL, 0x0000000000000012ULL, 0x000084c0003f0101ULL, 0x0001769800000018ULL,
0x00008500003f0101ULL, 0x0000000000000012ULL, 0x00008670003f0109ULL, 0x0000000000000012ULL,
0x00008e10003f0109ULL, 0x00000000000000ffULL, 0x00008ea000040107ULL, 0x000176a800000010ULL,
0x00008ec0003f0101ULL, 0x000176680000000dULL, 0x00008ef0003f0101ULL, 0x000176680000000dULL,
0x00009060003f0109ULL, 0x000176680000000dULL, 0x00009550003f0109ULL, 0x000176b000000015ULL,
0x000096f000080109ULL, 0x000176b00000001bULL, 0x0000a540003f0109ULL, 0x0000000000000012ULL,
0x0000a750003f0101ULL, 0x000176a000000004ULL, 0x0000ba90003f0101ULL, 0x00017600000000ffULL,
0x0000d2e000080101ULL, 0x00017600000000ffULL, 0x0000d4b000080109ULL, 0x00017600000000ffULL,
0x0000d69000080109ULL, 0x00017600000000ffULL, 0x0000d6b000080101ULL, 0x00017600000000ffULL,
0x0000d82000080109ULL, 0x00017600000000ffULL, 0x0001034000080109ULL, 0x0001768800000005ULL,
0x00010510003f0101ULL, 0x0001768800000005ULL, 0x00010680003f0109ULL, 0x0001768800000005ULL,
0x000129e0003f0109ULL, 0x0001760800000079ULL, 0x00012a00003f0101ULL, 0x0001761000000079ULL,
0x00012a10003f0101ULL, 0x0001761800000079ULL, 0x00012a20003f0101ULL, 0x0001762000000079ULL,
0x00053803003f0101ULL, 0x0000b15000201c04ULL, 0x0000b4500000b180ULL, 0x0000b8400000b640ULL,
0x0000d8500000b9f0ULL, 0x000c050400012a40ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0060190300000000ULL, 0x0000001800080a04ULL, 0x0000000000600210ULL, 0x00000000000000bcULL,
0x0000001700000002ULL, 0x0000000000012a50ULL, 0x0000000000000044ULL, 0x0000001700000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001700000002ULL, 0x0000000000000000ULL,
0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000097919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fe20000000a00ULL,
0xfffffff801017836ULL, 0x002fca0000000000ULL, 0x00008500ff0a7b82ULL, 0x000e620000000800ULL,
0x000000ff0200720cULL, 0x004fc80003f45070ULL, 0x000000ff0300720cULL, 0x000fda0003f45320ULL,
0x00008800ff022b82ULL, 0x000ea20000000a00ULL, 0x0000000109072836ULL, 0x008fe40000000000ULL,
0x0000000409042825ULL, 0x004fc800078e0002ULL, 0x0000000407022825ULL, 0x000fe400078e0002ULL,
0x0000000604072981ULL, 0x000ea8000c1e1900ULL, 0x0000000602002981ULL, 0x0006a2000c1e1900ULL,
0x0000000a00067306ULL, 0x002e620000209000ULL, 0x0000040000047ab9ULL, 0x000fe20000000800ULL,
0x000000ff0a00720cULL, 0x000fe20003f65070ULL, 0x0000000000087919ULL, 0x000f220000002200ULL,
0x0000010000057ab9ULL, 0x000fe20000000800ULL, 0x0000045000007945ULL, 0x000fe60003800000ULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe060c7836ULL, 0x002fc40000000000ULL,
0x0000000000067919ULL, 0x000e680000002100ULL, 0x0000000c000d7305ULL, 0x000ae4000021f000ULL,
0x000000ffff0c7224ULL, 0x020fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x008fc800078e0a0dULL,
0x0000000a0b0b7224ULL, 0x000fc800078e02ffULL, 0x0000000b0d0d7227ULL, 0x000fe400078e000cULL,
0x00000000000b7919ULL, 0x000f280000002300ULL, 0x000000040d0d7c27ULL, 0x000fc8000f8e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a0dULL, 0x000000040a037e24ULL, 0x000fe2000f8e0203ULL,
0x00000000000479c3ULL, 0x000ee80000002600ULL, 0x0000000a0300720cULL, 0x000fda0003f06070ULL,
0x0000000103030824ULL, 0x000fe400078e0a0aULL, 0x000000010d0d0836ULL, 0x000fc60000000000ULL,
0x0000000a0300720cULL, 0x000fda0003f26070ULL, 0x000000010d0d1836ULL, 0x000fe20000000000ULL,
0x0000000aff0db212ULL, 0x000fc800078e33ffULL, 0x0000000d00047306ULL, 0x000f620000209000ULL,
0x000000ff0d00720cULL, 0x000fce0003f65070ULL, 0x0000000400047308ULL, 0x020f640000001000ULL,
0x0ffffffe04027836ULL, 0x020fcc0000000000ULL, 0x0000000200037305ULL, 0x000a64000021f000ULL,
0x000000ffff027224ULL, 0x020fe400078e00ffULL, 0x000000030d057224ULL, 0x002fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a05ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x00000004037d7c27ULL, 0x008fc8000f8e00ffULL, 0x000000050b037c24ULL, 0x010fe2000f8e0208ULL,
0x0000000000057ab9ULL, 0x000fe20000000800ULL, 0x000000ffff027224ULL, 0x000fe200078e0a7dULL,
0x00008400ff08ab82ULL, 0x000e620000000800ULL, 0x0000000503037c24ULL, 0x000fe2000f8e0206ULL,
0x00001fff0b0b7589ULL, 0x000e6200000e0000ULL, 0x000000040d027e24ULL, 0x000fc6000f8e0202ULL,
0x0000007f0300780cULL, 0x040fe40003fa4070ULL, 0x0000000d0200720cULL, 0x000fe40003f06070ULL,
0x000000030300780cULL, 0x000fd20003f84070ULL, 0x000000000005d919ULL, 0x000ee40000008800ULL,
0x0000000102020824ULL, 0x000fe400078e0a0dULL, 0x000000017d7d0836ULL, 0x000fe20000000000ULL,
0x000000ff0300720cULL, 0x000fe40003f05270ULL, 0x0000000d0200720cULL, 0x000fe40003f26070ULL,
0x000004000002d802ULL, 0x000fd60000000f00ULL, 0x000000017d7d1836ULL, 0x000fe20000000000ULL,
0x0000000dff7db212ULL, 0x000fe400078e33ffULL, 0x0000000f0300780cULL, 0x040fe40003f24070ULL,
0x000000010300780cULL, 0x000fe20003f64070ULL, 0x000000ffff047224ULL, 0x000fc800078e0a7dULL,
0x000000040d0d7e24ULL, 0x000fe2000f8e0204ULL, 0x00000654050cd816ULL, 0x008fe20000000002ULL,
0xff317217ff05d424ULL, 0x000fe200078e00ffULL, 0x00000005ff027819ULL, 0x000fc60000011606ULL,
0x000000040304d824ULL, 0x000fc600078e020cULL, 0x00001fff02027589ULL, 0x000e6200000e0000ULL,
0x0000000100002824ULL, 0x004fcc00078e0a07ULL, 0x00008400ff00ab82ULL, 0x000ee20000000800ULL,
0x0000000000240947ULL, 0x002fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000087882ULL, 0x000fe20000000000ULL,
0x7ffc000000097882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01760008043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000403067c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000060812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01760804083f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000403067c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000060812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01768804083f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x017400050400d388ULL, 0x0003e20000000800ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x000000100d047824ULL, 0x002fca00078e00ffULL, 0x0000040401007387ULL, 0x0003e20000100800ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000403047c11ULL, 0x002fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000040912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x0176a804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000403037c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000030912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x0176c804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000040001107983ULL, 0x000ea20000100800ULL,
0x0000000800037c24ULL, 0x008fe4000f8e02ffULL, 0x000000080907a224ULL, 0x000fe400078e02ffULL,
0x000000080a0e7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000e07507224ULL, 0x000fc800078e02ffULL,
0x000000087d137c24ULL, 0x000fe2000f8e0250ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ffff047224ULL, 0x006fe200078e0a10ULL,
0x000000100300720cULL, 0x000fc80003f06070ULL, 0x00000010034f7446ULL, 0x000fe20003800004ULL,
0x000000040b037824ULL, 0x000fc600078e0202ULL, 0x000000ff4f4f7207ULL, 0x000fe20000000000ULL,
0x0000000203087824ULL, 0x000fc600078e00ffULL, 0x000000104f00780cULL, 0x000fda0003f05270ULL,
0x0000000000c48947ULL, 0x000fea0003800000ULL, 0x0000000800067d06ULL, 0x000e620008209000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00000008ff007c0cULL, 0x000fe2000bf45070ULL, 0x00008c0000047ab9ULL, 0x000fc80000000a00ULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe06057836ULL, 0x002fe20000000000ULL,
0x0000040000067802ULL, 0x000fe40000000f00ULL, 0x00000004ff0d7819ULL, 0x004fc60000011603ULL,
0x0000000500057305ULL, 0x000e64000021f000ULL, 0x00000001080c7824ULL, 0x000fe400078e020dULL,
0x000000ffff0f7224ULL, 0x002fc800078e0a05ULL, 0x000000080f0f7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000f050f7227ULL, 0x000fc800078e0004ULL, 0x0000000110047824ULL, 0x000fc800078e020cULL,
0x000000040f0f7227ULL, 0x000fc800078e00ffULL, 0x000000ffff117224ULL, 0x000fc800078e0a0fULL,
0x0000000811057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000000117919ULL, 0x000e660000008800ULL,
0x0000000805007c0cULL, 0x000fda000bf06070ULL, 0x8000000805050c36ULL, 0x000fe40008000000ULL,
0x000000010f0f0836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fe4000bf26070ULL,
0x0000065411117816ULL, 0x002fe20000000006ULL, 0x0000001003067824ULL, 0x000fd400078e00ffULL,
0x000000010f0f1836ULL, 0x000fe20000000000ULL, 0x00000008ff0fac12ULL, 0x000fca000f8e33ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a0fULL, 0x0000000805047c24ULL, 0x000fe2000f8e0204ULL,
0x000000084f057248ULL, 0x000fe40007fe0000ULL, 0x00000000110872caULL, 0x000fe200000e0000ULL,
0x0000000113047824ULL, 0x000fe400078e0204ULL, 0x0000000105087824ULL, 0x000fe400078e0a08ULL,
0x0000000e0f047224ULL, 0x000fe200078e0204ULL, 0x000000f0060f7812ULL, 0x000fe400078ec0ffULL,
0x000000080d00720cULL, 0x000fe20003f06070ULL, 0x0000010004047825ULL, 0x000fc800078e00ffULL,
0x000000010c087824ULL, 0x000fe200078e0203ULL, 0x0000000f040f7212ULL, 0x000fe200078efcffULL,
0x000000100c0d7824ULL, 0x000fc600078e00ffULL, 0x000000040f047c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff00d087812ULL, 0x000fe400078ee208ULL, 0x0000000505057c10ULL, 0x000fe40008ffe4ffULL,
0x00000008080d7c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e2000c101c46ULL, 0x0000000000b07947ULL, 0x000fea0003800000ULL,
0x0000000800067d06ULL, 0x000e620008209000ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00000008ff007c0cULL, 0x000fe2000bf45070ULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000000000f7919ULL, 0x000ee60000008800ULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe060c7836ULL, 0x002fe20000000000ULL,
0x0000000803087211ULL, 0x004fca00078fe0ffULL, 0x0000000c00057305ULL, 0x0002a4000021f000ULL,
0x00000001080c7824ULL, 0x002fe400078e0203ULL, 0x000000ffff0d7224ULL, 0x004fc800078e0a05ULL,
0x000000080d0d7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000d05057227ULL, 0x000fc800078e0004ULL,
0x0000000110047824ULL, 0x000fc800078e0208ULL, 0x0000000405057227ULL, 0x000fc800078e00ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a05ULL, 0x000000080d067c24ULL, 0x000fca000f8e0204ULL,
0x0000000806007c0cULL, 0x000fda000bf06070ULL, 0x8000000806060c36ULL, 0x000fe40008000000ULL,
0x0000000105050836ULL, 0x000fc60000000000ULL, 0x0000000806007c0cULL, 0x000fe4000bf26070ULL,
0x0000040000067802ULL, 0x000fc80000000f00ULL, 0x000006540f0f7816ULL, 0x008fe20000000006ULL,
0x0000001003067824ULL, 0x000fcc00078e00ffULL, 0x0000000105051836ULL, 0x000fe20000000000ULL,
0x00000008ff05ac12ULL, 0x000fca000f8e33ffULL, 0x000000ffff0d7224ULL, 0x000fc800078e0a05ULL,
0x000000080d047c24ULL, 0x000fe2000f8e0204ULL, 0x000000f0060d7812ULL, 0x000fe400078ec0ffULL,
0x000000000f0872caULL, 0x000fe200000e0000ULL, 0x0000000113047824ULL, 0x000fc800078e0204ULL,
0x0000000e05047224ULL, 0x000fc800078e0204ULL, 0x0000010004047825ULL, 0x000fc600078e00ffULL,
0x0000000d04047212ULL, 0x000fe200078efcffULL, 0x00000010080d7824ULL, 0x000fc600078e00ffULL,
0x0000000404047c10ULL, 0x000fe4000ff1e0ffULL, 0xfffffff00d0c7812ULL, 0x000fe400078ee20cULL,
0x0000000505057c10ULL, 0x000fe400087fe4ffULL, 0x000000080c0d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e4000b901c46ULL,
0x0001760008047890ULL, 0x000fe2000fffe03fULL, 0x00009200ff047b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000409047825ULL, 0x002fe200078e0004ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x00000006047a7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe20003f05270ULL, 0x000000ff7a0b7836ULL, 0x004fca0000000000ULL,
0x00000008ff7b7819ULL, 0x000fce000001160bULL, 0x000000a800208947ULL, 0x000fea0003800000ULL,
0x0000000209097824ULL, 0x000fe200078e00ffULL, 0x000001ff0b00780cULL, 0x000fe20003f04070ULL,
0x00000008024b7824ULL, 0x040fe200078e00ffULL, 0x00000001ff4d7819ULL, 0x000fe20000011602ULL,
0x0000000a09167224ULL, 0x000fe200078e020aULL, 0x0000940000047ab9ULL, 0x000fe20000000800ULL,
0x00000004ff007424ULL, 0x000fe200078e00ffULL, 0x0000000102497812ULL, 0x000fe200078ec0ffULL,
0x000000204d517824ULL, 0x000fe400078e00ffULL, 0x000000017d167824ULL, 0x000fe200078e0216ULL,
0x017688004bff79a7ULL, 0x0003e60008500008ULL, 0x0000000416007c24ULL, 0x002fe2000f8e0251ULL,
0x0000000400000947ULL, 0x000fec0003800000ULL, 0x000000517a047248ULL, 0x000fe20007fe0000ULL,
0x0000001049057824ULL, 0x000fe200078e00ffULL, 0x00000003ff077819ULL, 0x000fe20000011603ULL,
0x0000900000047ab9ULL, 0x000fe40000000a00ULL, 0x0000000104047824ULL, 0x000fe400078e0a51ULL,
0x0000000105087824ULL, 0x000fe400078e0207ULL, 0x00000004070a7836ULL, 0x000fe20000000000ULL,
0x0000000504047248ULL, 0x000fe20007fe0000ULL, 0x0000000108097824ULL, 0x000fc400078e0203ULL,
0x00000008080e7824ULL, 0x000fe400078e00ffULL, 0x0000000104047824ULL, 0x000fe400078e0a05ULL,
0x0000000c070b7836ULL, 0x000fe20000000000ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL,
0x0000000807097836ULL, 0x000fe20000000000ULL, 0x000000040a00720cULL, 0x080fe20003f46070ULL,
0x0000000100087824ULL, 0x000fe200078e0208ULL, 0x000000040700720cULL, 0x080fe20003f66070ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x000000040900720cULL, 0x080fe20003f26070ULL,
0x0000000105097824ULL, 0x000fe200078e0209ULL, 0x000000040b00720cULL, 0x000fe20003f06070ULL,
0x00000001050c7824ULL, 0x000fc400078e020bULL, 0x0000008008047825ULL, 0x000fc800078e00ffULL,
0x000000010a077824ULL, 0x040fe200078e0203ULL, 0x00000070040d7812ULL, 0x000fe200078ef806ULL,
0x000000080a107824ULL, 0x000fe400078e00ffULL, 0x0000000100087824ULL, 0x040fe400078e0209ULL,
0x0000000809127824ULL, 0x040fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee207ULL,
0x0000000109077824ULL, 0x000fe400078e0203ULL, 0x00000001000b7824ULL, 0x000fc400078e020cULL,
0x000000010c047824ULL, 0x040fe200078e0203ULL, 0xfffffff812127812ULL, 0x000fe200078ee207ULL,
0x000000080c097824ULL, 0x000fe200078e00ffULL, 0x000000040d0c7c10ULL, 0x000fe2000ff9e0ffULL,
0x00000001000a7824ULL, 0x000fe200078e020aULL, 0x000000084d007c11ULL, 0x000fe4000f8e68ffULL,
0xfffffff809147812ULL, 0x000fe200078ee204ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x00000005050d7c10ULL, 0x000fc6000a7fe4ffULL, 0x000000800a047825ULL, 0x000fc800078e00ffULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0x0000007004047812ULL, 0x000fc600078ef806ULL,
0x0001300000077836ULL, 0x000fe20000000000ULL, 0x0000007008007812ULL, 0x000fe400078ef806ULL,
0x000000700a087812ULL, 0x000fe200078ef806ULL, 0x000000100e0f7824ULL, 0x100fe200078e0207ULL,
0x0000000404047c10ULL, 0x000fe2000ff9e0ffULL, 0x0000001010117824ULL, 0x100fe200078e0207ULL,
0x0000000400067c10ULL, 0x000fe2000ffbe0ffULL, 0x0000001012137824ULL, 0x100fe200078e0207ULL,
0x0000000408087c10ULL, 0x000fe2000ffde0ffULL, 0x0000001014157824ULL, 0x000fe200078e0207ULL,
0x0000000505057c10ULL, 0x000fe2000a7fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0f7faeULL, 0x0003e2000d901c46ULL, 0x0000000509077c10ULL, 0x000fc4000affe4ffULL,
0x000000050b097c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000004117faeULL, 0x0003e8000d101c46ULL,
0x0000000006137faeULL, 0x0003e8000c901c46ULL, 0x0000000008157faeULL, 0x0003e2000c101c46ULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x0000001049047824ULL, 0x000fe200078e00ffULL,
0x0000900000047ab9ULL, 0x000fc80000000a00ULL, 0x0000000403047211ULL, 0x000fca00078fe8ffULL,
0x0000000404087836ULL, 0x000fe40000000000ULL, 0x0000000104057824ULL, 0x140fe400078e0203ULL,
0x00000008040a7824ULL, 0x000fe400078e00ffULL, 0x0000000108097824ULL, 0x040fe400078e0203ULL,
0x00000008080e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a077812ULL, 0x000fe200078ee205ULL,
0x0000000100057824ULL, 0x000fc400078e0204ULL, 0x0000000c040b7836ULL, 0x000fe20000000000ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL, 0x0000000804097836ULL, 0x000fe40000000000ULL,
0x0000008005047825ULL, 0x000fc800078e00ffULL, 0x0000000100087824ULL, 0x040fe200078e0208ULL,
0x00000070040c7812ULL, 0x000fe200078ef806ULL, 0x00000001000a7824ULL, 0x040fe400078e0209ULL,
0x00000001000f7824ULL, 0x000fe200078e020bULL, 0x000000040c0c7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000109007824ULL, 0x140fe400078e0203ULL, 0x00000008090d7824ULL, 0x000fe200078e00ffULL,
0x000000084d097c11ULL, 0x000fe2000f8e68ffULL, 0x000000010b047824ULL, 0x000fc400078e0203ULL,
0x000000080b0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d007812ULL, 0x000fe200078ee200ULL,
0x0001300009157836ULL, 0x000fe20000000000ULL, 0x00000005050d7c10ULL, 0x000fe400087fe4ffULL,
0xfffffff80b107812ULL, 0x000fe200078ee204ULL, 0x0000008008047825ULL, 0x000fc800078e00ffULL,
0x000000800a087825ULL, 0x000fe200078e00ffULL, 0x0000007004047812ULL, 0x000fc600078ef806ULL,
0x000000800f0a7825ULL, 0x000fe200078e00ffULL, 0x0000000404047c10ULL, 0x000fc6000ff1e0ffULL,
0x00000010070f7824ULL, 0x100fe200078e0215ULL, 0x0000007008077812ULL, 0x000fe200078ef806ULL,
0x000000100e117824ULL, 0x100fe200078e0215ULL, 0x000000700a087812ULL, 0x000fe200078ef806ULL,
0x0000001000137824ULL, 0x100fe200078e0215ULL, 0x0000000407067c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001010157824ULL, 0x000fe200078e0215ULL, 0x0000000408087c10ULL, 0x000fe2000ff5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0f7faeULL, 0x0003e2000b901c46ULL,
0x0000000505057c10ULL, 0x000fe400087fe4ffULL, 0x0000000509077c10ULL, 0x000fc40008ffe4ffULL,
0x000000050b097c10ULL, 0x000fe200097fe4ffULL, 0x0000000004117faeULL, 0x0003e8000b901c46ULL,
0x0000000006137faeULL, 0x0003e8000b901c46ULL, 0x0000000008157faeULL, 0x0003e4000b901c46ULL,
0x00000008ff007e24ULL, 0x000fe2000f8e00ffULL, 0x000000004d0472caULL, 0x000fe200000e0000ULL,
0x00000001ff057424ULL, 0x002fe200078e00ffULL, 0x000000ff7b00720cULL, 0x000fe20003f05270ULL,
0x000176a800007836ULL, 0x000fe20000000000ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x00000000000572caULL, 0x000fc400000e0000ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff297224ULL, 0x000fe400078e00ffULL, 0x000000084d047824ULL, 0x000fe400078e0200ULL,
0x0000000504047291ULL, 0x000fe2000f8e203fULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000005ff0679a7ULL, 0x0002a20008500004ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fc4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00002005040479a7ULL, 0x002e62000850003fULL, 0x00000000003a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000008c00048947ULL, 0x000fec0003800000ULL,
0x000000ffff007224ULL, 0x002fe200078e0005ULL, 0x00000002ff4c7819ULL, 0x000fe20000011602ULL,
0xff317217ff0d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff137224ULL, 0x000fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x000fce00078e00ffULL, 0x0000000000047805ULL, 0x006fe20000015200ULL,
0x0000000402067824ULL, 0x004fca00078e00ffULL, 0xfffffff806097812ULL, 0x000fc800078ec0ffULL,
0x0176c800090075a7ULL, 0x000e620008000148ULL, 0x0000000809157c36ULL, 0x000fc80008000000ULL,
0x000176c815127836ULL, 0x000fe20000000000ULL, 0x00000000005c0947ULL, 0x006fec0003800000ULL,
0x000000ffff0a7224ULL, 0x000fce00078e00ffULL, 0x000000100a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x0000001004097210ULL, 0x000fca0007f1e1ffULL, 0x0000000111107824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff1000720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff1000720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011410ULL, 0x0000000906067211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0610ULL, 0x0000000206067819ULL, 0x000fc80000001209ULL,
0x000000060000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010a0a7836ULL, 0x000fce0000000000ULL, 0x0176c800150075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000113007836ULL, 0x000fe20000000000ULL,
0x0000940000057ab9ULL, 0x000fe20000000800ULL, 0x0000010013117824ULL, 0x000fc600078e0251ULL,
0x0000007b0000720cULL, 0x000fe20003f26070ULL, 0x0000004011057836ULL, 0x000fc80000000000ULL,
0x00000005161a7c24ULL, 0x000fd0000f8e0205ULL, 0x0000000400089947ULL, 0x000fea0003800000ULL,
0x000000057a007248ULL, 0x000fe20007fe0000ULL, 0x0000001049097824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fe20000011603ULL, 0x00009000000a7ab9ULL, 0x000fe40000000a00ULL,
0x0000000100007824ULL, 0x000fe400078e0a05ULL, 0x0000000109057824ULL, 0x000fe400078e0204ULL,
0x00000004040a7836ULL, 0x000fe20000000000ULL, 0x0000000009007248ULL, 0x000fe20007fe0000ULL,
0x0000000105067824ULL, 0x000fc400078e0203ULL, 0x0000000805177824ULL, 0x000fe400078e00ffULL,
0x0000000100007824ULL, 0x000fe400078e0a09ULL, 0x0000000109147824ULL, 0x040fe200078e020aULL,
0xfffffff817177812ULL, 0x000fe200078ee206ULL, 0x0000000804067836ULL, 0x000fe20000000000ULL,
0x000000000a00720cULL, 0x080fe20003f66070ULL, 0x0000000c040a7836ULL, 0x000fe20000000000ULL,
0x000000000400720cULL, 0x080fe20003f86070ULL, 0x0000000114047824ULL, 0x000fe200078e0203ULL,
0x000000000600720cULL, 0x080fe20003f46070ULL, 0x00000008143d7824ULL, 0x000fe200078e00ffULL,
0x000000000a00720cULL, 0x000fe20003f06070ULL, 0x0000000109067824ULL, 0x000fc400078e0206ULL,
0x0000000109097824ULL, 0x000fe200078e020aULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee204ULL,
0x0000001003007824ULL, 0x000fe400078e00ffULL, 0x0000000105047824ULL, 0x100fe400078e021aULL,
0x0000000114147824ULL, 0x100fe400078e021aULL, 0x0000000106187824ULL, 0x040fe400078e021aULL,
0x00000001060a7824ULL, 0x000fc400078e0203ULL, 0x00000008063f7824ULL, 0x000fe400078e00ffULL,
0x00000001091a7824ULL, 0x040fe400078e021aULL, 0x0000000109067824ULL, 0x040fe200078e0203ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee20aULL, 0x0000000809417824ULL, 0x000fe200078e00ffULL,
0x0000007000097812ULL, 0x000fe200078ec0ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x000000084d007c11ULL, 0x000fe4000f8e68ffULL, 0xfffffff841417812ULL, 0x000fe200078ee206ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000904047212ULL, 0x000fc600078efcffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000000914147212ULL, 0x080fe400078efcffULL,
0x0000000a04047c10ULL, 0x000fe2000ffbe0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000a14147c10ULL, 0x000fe4000ffde0ffULL, 0x0000000918187212ULL, 0x080fe200078efcffULL,
0x0001400000007836ULL, 0x000fe20000000000ULL, 0x000000091a1a7212ULL, 0x000fe400078efcffULL,
0x0000000b05057c10ULL, 0x000fe2000affe4ffULL, 0x0000001017097824ULL, 0x100fe200078e0200ULL,
0x0000000b15157c10ULL, 0x000fe2000b7fe4ffULL, 0x000000103d177824ULL, 0x100fe200078e0200ULL,
0x0000000a18187c10ULL, 0x000fe2000ffbe0ffULL, 0x000000103f3d7824ULL, 0x100fe200078e0200ULL,
0x0000000a1a1a7c10ULL, 0x000fe2000ffde0ffULL, 0x00000010413f7824ULL, 0x000fe200078e0200ULL,
0x0000000b19197c10ULL, 0x000fe2000affe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e2000e101c46ULL, 0x0000000b1b1b7c10ULL, 0x000fc6000b7fe4ffULL,
0x0000000014177faeULL, 0x0003e8000d901c46ULL, 0x00000000183d7faeULL, 0x0003e8000d101c46ULL,
0x000000001a3f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000d47947ULL, 0x000fea0003800000ULL,
0x0000001049007824ULL, 0x000fe200078e00ffULL, 0x00009000000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000001003057824ULL, 0x000fc600078e00ffULL, 0x0000000003007211ULL, 0x000fe400078fe8ffULL,
0x00000070053d7812ULL, 0x000fc600078ec0ffULL, 0x0000000400147836ULL, 0x000fe40000000000ULL,
0x0000000100047824ULL, 0x140fe400078e0203ULL, 0x0000000800097824ULL, 0x000fe400078e00ffULL,
0x0000000114067824ULL, 0x040fe400078e0203ULL, 0x0000000814177824ULL, 0x000fe200078e00ffULL,
0xfffffff809097812ULL, 0x000fe200078ee204ULL, 0x0000000100047824ULL, 0x000fc400078e021aULL,
0x0000000114147824ULL, 0x000fe200078e021aULL, 0xfffffff817177812ULL, 0x000fe200078ee206ULL,
0x0000000800067836ULL, 0x000fe40000000000ULL, 0x0000000c00007836ULL, 0x000fe40000000000ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x0000000106187824ULL, 0x100fe200078e021aULL,
0x0000003d04047212ULL, 0x000fe200078efcffULL, 0x00000001001a7824ULL, 0x000fe400078e021aULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000a04047c10ULL, 0x000fc6000ff1e0ffULL,
0x00000001060a7824ULL, 0x100fe200078e0203ULL, 0x0000003d14147212ULL, 0x080fe200078efcffULL,
0x00000008063f7824ULL, 0x000fe200078e00ffULL, 0x0000000b05057c10ULL, 0x000fe200087fe4ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000000a14147c10ULL, 0x000fe4000ff1e0ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee20aULL, 0x0000000100067824ULL, 0x000fe200078e0203ULL,
0x0000003d18187212ULL, 0x000fe200078efcffULL, 0x0000000800417824ULL, 0x000fe200078e00ffULL,
0x000000084d007c11ULL, 0x000fe2000f8e68ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000a18187c10ULL, 0x000fc4000ff5e0ffULL, 0xfffffff841417812ULL, 0x000fe200078ee206ULL,
0x0001400000007836ULL, 0x000fe20000000000ULL, 0x0000003d1a1a7212ULL, 0x000fe400078efcffULL,
0x0000000b15157c10ULL, 0x000fe200087fe4ffULL, 0x0000001009097824ULL, 0x100fe200078e0200ULL,
0x0000000a1a1a7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001017177824ULL, 0x100fe200078e0200ULL,
0x0000000b19197c10ULL, 0x000fe200097fe4ffULL, 0x000000103f3d7824ULL, 0x100fe200078e0200ULL,
0x0000000b1b1b7c10ULL, 0x000fe20009ffe4ffULL, 0x00000010413f7824ULL, 0x000fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e8000b901c46ULL,
0x0000000014177faeULL, 0x0003e8000b901c46ULL, 0x00000000183d7faeULL, 0x0003e8000b901c46ULL,
0x000000001a3f7faeULL, 0x0003e4000b901c46ULL, 0xfffffff04b047812ULL, 0x042fe200078ec0ffULL,
0x00000001ff1b7424ULL, 0x000fe200078e00ffULL, 0xffffffe04b007812ULL, 0x040fe400078ec0ffULL,
0x000000104b057812ULL, 0x000fe200078ec0ffULL, 0x0000000804067c36ULL, 0x000fe20008000000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000805007c10ULL, 0x000fe4000fffe000ULL,
0x00000000060572caULL, 0x000fc600000e0000ULL, 0x00000008491a7824ULL, 0x000fd400078e0200ULL,
0x000176b005057890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0176b01b060479a7ULL, 0x0002a4000850003fULL,
0x0176081b1a1a79a7ULL, 0x002e64000850003fULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x000000084b097812ULL, 0x000fca00078ec0ffULL, 0x0000000100107824ULL, 0x000fc800078e0209ULL,
0x0176081b100075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff067224ULL, 0x000fce00078e00ffULL, 0x000000100600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fce0000015200ULL,
0x0000001814097210ULL, 0x000fca0007f1e1ffULL, 0x0000000119187824ULL, 0x000fe200000e0e15ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff1800720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff1800720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011418ULL, 0x0000000900007211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0618ULL, 0x0000000200007819ULL, 0x000fc80000001209ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000106067836ULL, 0x000fce0000000000ULL, 0x0176081b100075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000010034a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff4e7819ULL, 0x000fe20000011603ULL, 0x0000002002007824ULL, 0x000fe400078e00ffULL,
0x00000001ff0e7424ULL, 0x000fe200078e00ffULL, 0x000000704a4a7812ULL, 0x000fe400078ec0ffULL,
0xffffff8000097812ULL, 0x000fe400078ec0ffULL, 0x0000000c4e4e7812ULL, 0x000fe400078ec0ffULL,
0x000000084a097c10ULL, 0x000fca000fffe009ULL, 0x0000000109097824ULL, 0x000fca00078e024eULL,
0x0170000009067984ULL, 0x000e680000000800ULL, 0x01720000090a7984ULL, 0x0006e20000000800ULL,
0x0000000d0600720bULL, 0x002fda0003f1d000ULL, 0x0000000000007806ULL, 0x000fc800000e0100ULL,
0x0000ffff00147812ULL, 0x000fe2000780c0ffULL, 0x000000ffff007224ULL, 0x000fd800078e000dULL,
0x0000000000f48947ULL, 0x00cfea0003800000ULL, 0x000000024c00720cULL, 0x000fe40003f45270ULL,
0x0000000d0600720bULL, 0x0c0fe40003f14000ULL, 0x0000000d06007209ULL, 0x000fd20007810000ULL,
0x000000080209ac11ULL, 0x000fe4000f8e38ffULL, 0x0000000000157806ULL, 0x000fe400000e0100ULL,
0x000000094e09a210ULL, 0x000fe40007ffe04aULL, 0x00009910150e7816ULL, 0x000fc600000000ffULL,
0x017400000900a388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x0000000d00097221ULL, 0x000fe20000010100ULL,
0x000000ff15ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0015ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x00000009000e7308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff097819ULL, 0x002fcc0000011603ULL,
0x00001f090e097589ULL, 0x004e6400000e0000ULL, 0x0000000938387220ULL, 0x082fe20000410000ULL,
0x0000000939397220ULL, 0x080fe20000410000ULL, 0x0000000934347220ULL, 0x080fe20000410000ULL,
0x0000000935357220ULL, 0x080fe20000410000ULL, 0x0000000930307220ULL, 0x080fe20000410000ULL,
0x0000000931317220ULL, 0x080fe20000410000ULL, 0x000000092c2c7220ULL, 0x080fe20000410000ULL,
0x000000092d2d7220ULL, 0x080fe20000410000ULL, 0x0000000928287220ULL, 0x080fe20000410000ULL,
0x0000000929297220ULL, 0x080fe20000410000ULL, 0x0000000924247220ULL, 0x080fe20000410000ULL,
0x0000000925257220ULL, 0x080fe20000410000ULL, 0x0000000920207220ULL, 0x080fe20000410000ULL,
0x0000000921217220ULL, 0x080fe20000410000ULL, 0x000000091c1c7220ULL, 0x080fe20000410000ULL,
0x000000091d1d7220ULL, 0x000fce0000410000ULL, 0x0000000e08087220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x0000000803097811ULL, 0x002fcc00078ff0ffULL,
0x00001f090e097589ULL, 0x000e6400000e0000ULL, 0x000000093a3a7220ULL, 0x082fe20000410000ULL,
0x000000093b3b7220ULL, 0x080fe20000410000ULL, 0x0000000936367220ULL, 0x080fe20000410000ULL,
0x0000000937377220ULL, 0x080fe20000410000ULL, 0x0000000932327220ULL, 0x080fe20000410000ULL,
0x0000000933337220ULL, 0x080fe20000410000ULL, 0x000000092e2e7220ULL, 0x080fe20000410000ULL,
0x000000092f2f7220ULL, 0x080fe20000410000ULL, 0x000000092a2a7220ULL, 0x080fe20000410000ULL,
0x000000092b2b7220ULL, 0x080fe20000410000ULL, 0x0000000926267220ULL, 0x080fe20000410000ULL,
0x0000000927277220ULL, 0x080fe20000410000ULL, 0x0000000922227220ULL, 0x080fe20000410000ULL,
0x0000000923237220ULL, 0x080fe20000410000ULL, 0x000000091e1e7220ULL, 0x080fe20000410000ULL,
0x000000091f1f7220ULL, 0x000fce0000410000ULL, 0x0000ffff14ff7812ULL, 0x000fe20007806015ULL,
0x00000001ff0e7424ULL, 0x000fd800078e00ffULL, 0x8000000006060221ULL, 0x000fe20000010000ULL,
0x00007610ff0e0816ULL, 0x000fc6000000000eULL, 0x3fb8aa3b06060820ULL, 0x000fc80000410000ULL,
0x00000006000f0308ULL, 0x000ea40000000800ULL, 0x0000000f0a0a0220ULL, 0x004fce0000410000ULL,
0x000000080a087221ULL, 0x000fce0000010000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0xfffffff04b067812ULL, 0x000fc800078ec0ffULL, 0x0176a807060075a7ULL, 0x000ea20008000148ULL,
0x00000008060a7c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x004fec0003800000ULL,
0x000000ffff0d7224ULL, 0x000fce00078e00ffULL, 0x000000100d00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x0000001814097210ULL, 0x002fca0007f1e1ffULL, 0x0000000119187824ULL, 0x000fe200000e0e15ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff1800720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x002fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff1800720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011418ULL, 0x0000000906067211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0618ULL, 0x0000000206067819ULL, 0x000fc80000001209ULL,
0x000000060000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010d0d7836ULL, 0x000fce0000000000ULL, 0x0176a8070a0075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x000099100e097816ULL, 0x002fe200000000ffULL,
0x0000020002067824ULL, 0x000fe200078e00ffULL, 0x0000000703077812ULL, 0x040fe400078ec0ffULL,
0x00000004ff0e7819ULL, 0x000fe40000011603ULL, 0x00000008030a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff0900720cULL, 0x000fe20003f05270ULL, 0x000000044d0d7824ULL, 0x100fe200078e020eULL,
0x0000000807147812ULL, 0x000fe200078ef803ULL, 0x0000000449097824ULL, 0x000fe200078e020eULL,
0x000000070a407212ULL, 0x000fc400078efcffULL, 0xfffff80006067812ULL, 0x000fe200078ec0ffULL,
0x0000000114157824ULL, 0x040fe200078e020dULL, 0x000000084d487c11ULL, 0x000fe2000f8e68ffULL,
0x0000000814187824ULL, 0x000fe400078e00ffULL, 0x0000000140177824ULL, 0x040fe400078e0209ULL,
0x00000008401a7824ULL, 0x000fe400078e00ffULL, 0x00000008060d7c36ULL, 0x000fe20008000000ULL,
0xfffffff818067812ULL, 0x000fe200078ee215ULL, 0x00013000480e7836ULL, 0x000fe20000000000ULL,
0xfffffff81a197812ULL, 0x000fc600078ee217ULL, 0x0000001006187824ULL, 0x000fe400078e020dULL,
0x00000010193c7824ULL, 0x000fe200078e020eULL, 0x0000000000180947ULL, 0x000fec0003800000ULL,
0x00000002ff197819ULL, 0x000fe40000011603ULL, 0x0000000fff06723eULL, 0x000fc600000000ffULL,
0x00000008190b7836ULL, 0x000fe20000000000ULL, 0x0000541006067816ULL, 0x000fca0000000006ULL,
0x00001f19060c7589ULL, 0x0002a800000e0000ULL, 0x00001f0b060b7589ULL, 0x0002e400000e0000ULL,
0x011000001818783bULL, 0x002e620000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000c18187232ULL, 0x086fe40000000000ULL, 0x0000000c1a1a7232ULL, 0x000fe40000000000ULL,
0x0000000b19197232ULL, 0x088fe40000000000ULL, 0x0000000b1b1b7232ULL, 0x000fce0000000000ULL,
0x0000000840407824ULL, 0x000fe200078e00ffULL, 0x000000003c3c783bULL, 0x000f220000004200ULL,
0x0000000217177836ULL, 0x000fe20000000000ULL, 0x000000100a0a7812ULL, 0x000fe200078efe07ULL,
0x0000000814457824ULL, 0x000fe400078e00ffULL, 0x0000000215147836ULL, 0x000fe20000000000ULL,
0xfffffff840177812ULL, 0x000fe200078ee217ULL, 0x0000000109097824ULL, 0x000fc600078e020aULL,
0xfffffff845147812ULL, 0x000fe200078ee214ULL, 0x0000001017177824ULL, 0x000fca00078e020eULL,
0x000000001740783bULL, 0x000f620000004200ULL, 0x00000010ff5f7819ULL, 0x010fe4000001163cULL,
0x00000010ff607819ULL, 0x000fe4000001163dULL, 0x0000ffff3c627812ULL, 0x040fe400078ec0ffULL,
0x00000010ff5b7819ULL, 0x000fe4000001163fULL, 0x000000ff3c597812ULL, 0x000fe400078ec0ffULL,
0x000000ff3d5a7812ULL, 0x000fc400078ec0ffULL, 0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff157819ULL, 0x028fe40000011641ULL,
0x00000018ff177819ULL, 0x000fe40000011642ULL, 0x00000018ff617819ULL, 0x000fe40000011643ULL,
0x00000010ff077819ULL, 0x000fc40000011641ULL, 0x000000ff41467812ULL, 0x040fe400078ec0ffULL,
0x0000ffff41547812ULL, 0x000fe400078ec0ffULL, 0x00000015ff41723eULL, 0x000fe400020006ffULL,
0x00000010ff5c7819ULL, 0x000fe40000011640ULL, 0x00000017ff15723eULL, 0x000fe400020006ffULL,
0x00000061ff17723eULL, 0x000fc400020006ffULL, 0x000000ff60617812ULL, 0x000fe400078ec0ffULL,
0x00000008ff607819ULL, 0x000fe40000011662ULL, 0x000000ff5c627812ULL, 0x000fe400078ec0ffULL,
0x0000ffff40067812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3d5e7812ULL, 0x000fe400078ec0ffULL,
0x00000059ff59723eULL, 0x000fc400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x0000005bff5c723eULL, 0x000fe400020006ffULL, 0x00000062ff5b723eULL, 0x000fe400020006ffULL,
0x000000ff07637812ULL, 0x000fc400078ec0ffULL, 0x00000008ff627819ULL, 0x000fe40000011606ULL,
0x00000018ff577819ULL, 0x000fe4000001163cULL, 0x00000018ff587819ULL, 0x000fe4000001163dULL,
0x00000008ff5e7819ULL, 0x000fe4000001165eULL, 0x0000541059067816ULL, 0x000fe4000000005fULL,
0x000054105a077816ULL, 0x000fc40000000061ULL, 0x00000010ff5d7819ULL, 0x000fe4000001163eULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x000000061838723cULL, 0x002fe20000001838ULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x000000ff3e567812ULL, 0x000fc400078ec0ffULL,
0x000000ff3f557812ULL, 0x000fe400078ec0ffULL, 0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL,
0x0000541060067816ULL, 0x000fe40000000057ULL, 0x000054105e077816ULL, 0x000fe40000000058ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000055ff55723eULL, 0x000fc400020006ffULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x000000061834723cULL, 0x000fe20000001834ULL,
0x000000ff40477812ULL, 0x000fe400078ec0ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x0000541056067816ULL, 0x000fe4000000005dULL,
0x0000541055077816ULL, 0x000fc4000000005cULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001163fULL, 0x00000018ff457819ULL, 0x000fe20000011640ULL,
0x000000061830723cULL, 0x000fe20000001830ULL, 0x0000ffff3e447812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff547819ULL, 0x000fc40000011654ULL,
0x0000541047067816ULL, 0x000fe4000000005bULL, 0x0000541046077816ULL, 0x000fe40000000063ULL,
0x00000018ff3c7819ULL, 0x000fe4000001163eULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x000000061828723cULL, 0x000fe20000001828ULL,
0x00000010ff527819ULL, 0x000fc40000011642ULL, 0x000000ff423e7812ULL, 0x040fe400078ec0ffULL,
0x00000010ff537819ULL, 0x000fe40000011643ULL, 0x000000ff43407812ULL, 0x000fe400078ec0ffULL,
0x00000008ff447819ULL, 0x000fe40000011644ULL, 0x00000008ff3f7819ULL, 0x000fe4000001163fULL,
0x0000ffff42427812ULL, 0x000fc400078ec0ffULL, 0x0000ffff43437812ULL, 0x000fe400078ec0ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x0000541062067816ULL, 0x000fe40000000045ULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x00000044ff44723eULL, 0x000fc400020006ffULL, 0x0000003fff45723eULL, 0x000fe400020006ffULL,
0x000000ff52527812ULL, 0x000fe400078ec0ffULL, 0x000000ff53537812ULL, 0x000fe400078ec0ffULL,
0x00000008ff427819ULL, 0x000fe40000011642ULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x0000541054077816ULL, 0x000fc40000000041ULL, 0x0000541044447816ULL, 0x000fe4000000003cULL,
0x0000541045457816ULL, 0x000fe4000000003dULL, 0x0000003eff3e723eULL, 0x000fe200020006ffULL,
0x000000061824723cULL, 0x000fe20000001824ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x00000044182c723cULL, 0x000fe2000000182cULL, 0x00000042ff42723eULL, 0x000fe200020006ffULL,
0x000000080a067824ULL, 0x000fe200078e00ffULL, 0x00000043ff43723eULL, 0x000fc400020006ffULL,
0x000054103e3e7816ULL, 0x000fe40000000052ULL, 0x00005410403f7816ULL, 0x000fe20000000053ULL,
0x0000001014457824ULL, 0x000fe200078e020dULL, 0x0000541042427816ULL, 0x000fe40000000015ULL,
0x0000541043437816ULL, 0x000fe40000000017ULL, 0xfffffff806077812ULL, 0x000fe200078ee209ULL,
0x0000003e1820723cULL, 0x000fe80000001820ULL, 0x0000001007077824ULL, 0x000fc400078e020eULL,
0x00000042181c723cULL, 0x000fe2000000181cULL, 0x011000004518783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000c18187232ULL, 0x08cfe40000000000ULL, 0x0000000c1a1a7232ULL, 0x000fe40000000000ULL,
0x0000000b19197232ULL, 0x080fe40000000000ULL, 0x0000000b1b1b7232ULL, 0x000fce0000000000ULL,
0x000000080a067824ULL, 0x000fe200078e00ffULL, 0x00000000073c783bULL, 0x000f220000004200ULL,
0x0000000209097836ULL, 0x000fca0000000000ULL, 0xfffffff806097812ULL, 0x000fca00078ee209ULL,
0x0000001009097824ULL, 0x000fca00078e020eULL, 0x000000000940783bULL, 0x0009640000004200ULL,
0x00000018ff097819ULL, 0x010fe4000001163fULL, 0x00000010ff5e7819ULL, 0x100fe4000001163dULL,
0x000000ff3d587812ULL, 0x040fe400078ec0ffULL, 0x00000018ff567819ULL, 0x000fe4000001163dULL,
0x0000ffff3d617812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5b7819ULL, 0x100fe4000001163eULL,
0x000000ff3e547812ULL, 0x040fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fe4000001163eULL,
0x00000018ff147819ULL, 0x022fe40000011642ULL, 0x0000ffff3e597812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5f7819ULL, 0x000fc40000011643ULL, 0x00000010ff5d7819ULL, 0x000fe4000001163cULL,
0x00000010ff077819ULL, 0x100fe40000011641ULL, 0x000000ff413e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff3d7819ULL, 0x000fe40000011641ULL, 0x0000ffff41477812ULL, 0x000fe400078ec0ffULL,
0x00000009ff41723eULL, 0x000fc400020006ffULL, 0x00000014ff09723eULL, 0x000fe400020006ffULL,
0x0000005fff14723eULL, 0x000fe400020006ffULL, 0x000000ff3c577812ULL, 0x000fe400078ec0ffULL,
0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5e5f7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3c607812ULL, 0x000fc400078ec0ffULL, 0x00000010ff067819ULL, 0x000fe40000011640ULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000008ff5e7819ULL, 0x000fc40000011660ULL, 0x00000008ff607819ULL, 0x000fe40000011661ULL,
0x000000ff06617812ULL, 0x000fe400078ec0ffULL, 0x000000ff07627812ULL, 0x000fe400078ec0ffULL,
0x00000018ff557819ULL, 0x000fe4000001163cULL, 0x0000541057067816ULL, 0x000fe4000000005dULL,
0x0000541058077816ULL, 0x000fc4000000005fULL, 0x00000010ff5c7819ULL, 0x000fe4000001163fULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x000000061838723cULL, 0x008fe20000001838ULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x000000ff3f537812ULL, 0x000fc400078ec0ffULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000054105e067816ULL, 0x000fe40000000055ULL, 0x0000541060077816ULL, 0x000fe40000000056ULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fc400020006ffULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x000000061834723cULL, 0x000fe20000001834ULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000ffff3f5a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff597819ULL, 0x000fe40000011659ULL, 0x0000541054067816ULL, 0x000fe4000000005bULL,
0x0000541053077816ULL, 0x000fc4000000005cULL, 0x00000008ff5a7819ULL, 0x000fe4000001165aULL,
0x000000ff403f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3c7819ULL, 0x000fe20000011640ULL,
0x000000061830723cULL, 0x000fe20000001830ULL, 0x0000ffff40527812ULL, 0x000fe400078ec0ffULL,
0x00000010ff407819ULL, 0x000fe40000011643ULL, 0x00000046ff46723eULL, 0x000fc400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x000000ff40067812ULL, 0x000fe400078ec0ffULL, 0x0000541059407816ULL, 0x000fe40000000046ULL,
0x000054105a417816ULL, 0x000fe40000000041ULL, 0x0000003fff3f723eULL, 0x000fc400020006ffULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x00000040182c723cULL, 0x000fe2000000182cULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000010ff447819ULL, 0x000fe40000011642ULL, 0x000000ff42177812ULL, 0x000fe400078ec0ffULL,
0x000000ff43157812ULL, 0x000fc400078ec0ffULL, 0x00000006ff40723eULL, 0x000fe400020006ffULL,
0x0000ffff42427812ULL, 0x000fe400078ec0ffULL, 0x0000ffff43437812ULL, 0x000fe400078ec0ffULL,
0x000054103f067816ULL, 0x000fe40000000061ULL, 0x000054103e077816ULL, 0x000fe40000000062ULL,
0x00000008ff477819ULL, 0x000fc40000011647ULL, 0x00000008ff527819ULL, 0x000fe40000011652ULL,
0x000000ff44447812ULL, 0x000fe200078ec0ffULL, 0x000000061828723cULL, 0x000fe20000001828ULL,
0x00000008ff427819ULL, 0x000fe40000011642ULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x00000047ff53723eULL, 0x000fe200020006ffULL,
0x0000000202067824ULL, 0x000fe200078e00ffULL, 0x0000003cff3c723eULL, 0x000fc400020006ffULL,
0x00000017ff17723eULL, 0x000fe400020006ffULL, 0x00000015ff15723eULL, 0x000fe400020006ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fc400020006ffULL,
0x000000084d077c11ULL, 0x000fe4000f8e18ffULL, 0x0000541053537816ULL, 0x000fe2000000003dULL,
0x00000001ff3d7424ULL, 0x000fe200078e00ffULL, 0x0000541052527816ULL, 0x000fe4000000003cULL,
0x00005410173e7816ULL, 0x000fe40000000044ULL, 0x00005410153f7816ULL, 0x000fe40000000040ULL,
0x0000541042427816ULL, 0x000fe20000000009ULL, 0x000000521824723cULL, 0x000fe20000001824ULL,
0x0000541043437816ULL, 0x000fc40000000014ULL, 0xfffffff8063c7812ULL, 0x000fe400078ec0ffULL,
0x0176c83d070679a7ULL, 0x0002e2000850003fULL, 0x0000003e1820723cULL, 0x000fec0000001820ULL,
0x00000042181c723cULL, 0x000fe2000000181cULL, 0x0176883d3cff79a7ULL, 0x0003de0008500008ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000007120075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff177224ULL, 0x000fce00078e00ffULL, 0x000000101700780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fce0000015200ULL,
0x0000001814187210ULL, 0x000fca0007f1e1ffULL, 0x0000000119197824ULL, 0x000fe200000e0e15ULL,
0x003d09001800780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401800780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011419ULL, 0x0000001809097211ULL, 0x000fca00078110ffULL,
0x000000ffff187224ULL, 0x000fca00000e0619ULL, 0x0000000209097819ULL, 0x000fc80000001218ULL,
0x000000090000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000117177836ULL, 0x000fce0000000000ULL, 0x00000007120075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x0000008011077836ULL, 0x000fe20000000000ULL,
0x0000940000057ab9ULL, 0x000fc60000000800ULL, 0x0000000516097c24ULL, 0x000fe2000f8e0207ULL,
0x0000000000f89947ULL, 0x000fec0003800000ULL, 0x000000077a067248ULL, 0x000fe20007fe0000ULL,
0x0000001049157824ULL, 0x000fe200078e00ffULL, 0x00000003ff147819ULL, 0x000fe20000011603ULL,
0x00009000000a7ab9ULL, 0x000fe40000000a00ULL, 0x0000000106067824ULL, 0x000fe400078e0a07ULL,
0x0000000115187824ULL, 0x000fe400078e0214ULL, 0x0000000414197836ULL, 0x000fe20000000000ULL,
0x0000000615067248ULL, 0x000fe20007fe0000ULL, 0x0000000118077824ULL, 0x000fc400078e0203ULL,
0x00000008181a7824ULL, 0x000fe400078e00ffULL, 0x0000000106067824ULL, 0x000fe400078e0a15ULL,
0x00000008141b7836ULL, 0x000fe20000000000ULL, 0xfffffff81a177812ULL, 0x000fe200078ee207ULL,
0x00000001151a7824ULL, 0x000fe200078e0219ULL, 0x000000061900720cULL, 0x080fe20003f66070ULL,
0x0000000c14197836ULL, 0x000fe20000000000ULL, 0x000000061400720cULL, 0x080fe20003f86070ULL,
0x000000011a147824ULL, 0x040fe200078e0203ULL, 0x000000061b00720cULL, 0x080fe20003f46070ULL,
0x000000081a3d7824ULL, 0x002fe200078e00ffULL, 0x000000061900720cULL, 0x000fe20003f06070ULL,
0x0000000118077824ULL, 0x000fc400078e0209ULL, 0x00000001153c7824ULL, 0x000fe200078e021bULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee214ULL, 0x0000008007067825ULL, 0x000fc800078e00ffULL,
0x000000011a147824ULL, 0x000fe200078e0209ULL, 0x0000004a06067212ULL, 0x000fe200078efcffULL,
0x00000001153e7824ULL, 0x000fe400078e0219ULL, 0x000000013c187824ULL, 0x040fe200078e0209ULL,
0x0000000a06067c10ULL, 0x000fe2000ffbe0ffULL, 0x000000013c197824ULL, 0x040fe400078e0203ULL,
0x000000083c3c7824ULL, 0x000fe200078e00ffULL, 0x0000000b07077c10ULL, 0x000fe2000affe4ffULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x000000013e1a7824ULL, 0x000fe200078e0209ULL,
0xfffffff83c097812ULL, 0x000fe200078ee219ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000004a14147212ULL, 0x000fc600078efcffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000a14147c10ULL, 0x000fe4000ffbe0ffULL, 0x0000004a18187212ULL, 0x080fe200078efcffULL,
0x000000013e3c7824ULL, 0x000fe200078e0203ULL, 0x0000004a1a1a7212ULL, 0x000fe200078efcffULL,
0x000000083e3f7824ULL, 0x000fe200078e00ffULL, 0x0000000b15157c10ULL, 0x000fe2000affe4ffULL,
0x0000001017177824ULL, 0x100fe200078e020eULL, 0x0000000a18187c10ULL, 0x000fe2000ffbe0ffULL,
0x000000103d3d7824ULL, 0x100fe200078e020eULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee23cULL,
0x0000001009097824ULL, 0x100fe200078e020eULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ffde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006177faeULL, 0x0003e2000e101c46ULL,
0x0000000b19197c10ULL, 0x000fe2000affe4ffULL, 0x000000103f3f7824ULL, 0x000fe200078e020eULL,
0x0000000b1b1b7c10ULL, 0x000fe2000b7fe4ffULL, 0x00000000143d7faeULL, 0x0003e8000d901c46ULL,
0x0000000018097faeULL, 0x0003e8000d101c46ULL, 0x000000001a3f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001049067824ULL, 0x000fe200078e00ffULL,
0x00009000000a7ab9ULL, 0x000fc80000000a00ULL, 0x0000000603147211ULL, 0x000fca00078fe8ffULL,
0x0000000114077824ULL, 0x040fe400078e0203ULL, 0x00000008141a7824ULL, 0x040fe400078e00ffULL,
0x0000000414187836ULL, 0x000fe40000000000ULL, 0x0000000c143e7836ULL, 0x000fe20000000000ULL,
0xfffffff81a177812ULL, 0x000fe200078ee207ULL, 0x00000008143c7836ULL, 0x002fe40000000000ULL,
0x0000000114067824ULL, 0x000fc400078e0209ULL, 0x00000001181a7824ULL, 0x040fe400078e0209ULL,
0x0000000118157824ULL, 0x040fe400078e0203ULL, 0x0000000818407824ULL, 0x000fe400078e00ffULL,
0x000000013e187824ULL, 0x040fe400078e0209ULL, 0x000000013e1b7824ULL, 0x040fe400078e0203ULL,
0x000000083e3e7824ULL, 0x000fc400078e00ffULL, 0x000000013c147824ULL, 0x040fe200078e0209ULL,
0xfffffff840097812ULL, 0x000fe200078ee215ULL, 0x000000013c197824ULL, 0x040fe200078e0203ULL,
0xfffffff83e3f7812ULL, 0x000fe200078ee21bULL, 0x000000083c3c7824ULL, 0x000fe400078e00ffULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0xfffffff83c3d7812ULL, 0x000fe200078ee219ULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000004a06067212ULL, 0x000fc600078efcffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000004a1a1a7212ULL, 0x080fe400078efcffULL,
0x0000000a06067c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000004a14147212ULL, 0x080fe400078efcffULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001017177824ULL, 0x100fe200078e020eULL, 0x0000004a18187212ULL, 0x000fe200078efcffULL,
0x0000001009097824ULL, 0x100fe200078e020eULL, 0x0000000b07077c10ULL, 0x000fe200087fe4ffULL,
0x000000103d3d7824ULL, 0x100fe200078e020eULL, 0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL,
0x000000103f3f7824ULL, 0x000fe200078e020eULL, 0x0000000a18187c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006177faeULL, 0x0003e2000b901c46ULL,
0x0000000b1b1b7c10ULL, 0x000fc400097fe4ffULL, 0x0000000b15157c10ULL, 0x000fe400087fe4ffULL,
0x0000000b19197c10ULL, 0x000fe20009ffe4ffULL, 0x000000001a097faeULL, 0x0003e8000b901c46ULL,
0x00000000143d7faeULL, 0x0003e8000b901c46ULL, 0x00000000183f7faeULL, 0x0003e4000b901c46ULL,
0x000000104d067824ULL, 0x002fe200078e00ffULL, 0xffffffe04b187812ULL, 0x000fe200078ec0ffULL,
0x00000001ff1a7424ULL, 0x000fe400078e00ffULL, 0x0000000806147c36ULL, 0x000fe20008000000ULL,
0x0000001006077812ULL, 0x000fe200078ec0ffULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000140572caULL, 0x000fe400000e0000ULL, 0x0000000807077c10ULL, 0x000fe4000fffe018ULL,
0x000000084b187812ULL, 0x000fca00078ec0ffULL, 0x0000000118077824ULL, 0x000fc800078e0207ULL,
0x000176a805057890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0176a81a141479a7ULL, 0x0002e4000850003fULL,
0x0176281a071a79a7ULL, 0x0022a4000850003fULL, 0x0000000000067805ULL, 0x002fce0000015200ULL,
0x0176281b100075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff177224ULL, 0x000fce00078e00ffULL, 0x000000101700780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fce0000015200ULL,
0x0000001806187210ULL, 0x000fca0007f1e1ffULL, 0x0000000119197824ULL, 0x000fe200000e0e07ULL,
0x003d09001800780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401800780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011419ULL, 0x0000001809097211ULL, 0x000fca00078110ffULL,
0x000000ffff187224ULL, 0x000fca00000e0619ULL, 0x0000000209097819ULL, 0x000fc80000001218ULL,
0x000000090000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000117177836ULL, 0x000fce0000000000ULL, 0x0176281b100075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000002002067824ULL, 0x000fe400078e00ffULL,
0x00000008ff077e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff1a7424ULL, 0x000fe200078e00ffULL,
0xffffff8006067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fc600078e0000ULL,
0x0000008007077810ULL, 0x000fc80007ffe006ULL, 0x000000074e077210ULL, 0x000fca0007ffe04aULL,
0x0170000007177984ULL, 0x000e680000000800ULL, 0x0172000007187984ULL, 0x0004a20000000800ULL,
0x000000001700720bULL, 0x002fda0003f1d000ULL, 0x0000000000067806ULL, 0x000fc800000e0100ULL,
0x0000ffff06197812ULL, 0x000fda000780c0ffULL, 0x0000000000f88947ULL, 0x00cfea0003800000ULL,
0x000000014c077836ULL, 0x000fe20000000000ULL, 0x000000001700720bULL, 0x0c0fe40003f14000ULL,
0x0000000017097209ULL, 0x000fe40007810000ULL, 0x000000020700720cULL, 0x000fd20003f45270ULL,
0x00000000001a7806ULL, 0x000fc800000e0100ULL, 0x000000080207ac11ULL, 0x000fe4000f8e38ffULL,
0x000099101a067816ULL, 0x000fe400000000ffULL, 0x000000074e3ca210ULL, 0x000fe40007ffe04aULL,
0x000000ff0600720cULL, 0x000fc60003f05270ULL, 0x017400093c00a388ULL, 0x0003f40000000800ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x8000000900007221ULL, 0x000fe20000010000ULL,
0x000000ff1aff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff001aff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b00007820ULL, 0x000fc80000410000ULL, 0x0000000000077308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff007819ULL, 0x002fcc0000011603ULL,
0x00001f0007007589ULL, 0x004e6400000e0000ULL, 0x0000003800387220ULL, 0x042fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x000fce0000410000ULL, 0x0000000708087220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x0000000803007811ULL, 0x002fcc00078ff0ffULL,
0x00001f0007007589ULL, 0x000e6400000e0000ULL, 0x0000003a003a7220ULL, 0x042fe20000410000ULL,
0x0000003b003b7220ULL, 0x040fe20000410000ULL, 0x0000003600367220ULL, 0x040fe20000410000ULL,
0x0000003700377220ULL, 0x040fe20000410000ULL, 0x0000003200327220ULL, 0x040fe20000410000ULL,
0x0000003300337220ULL, 0x040fe20000410000ULL, 0x0000002e002e7220ULL, 0x040fe20000410000ULL,
0x0000002f002f7220ULL, 0x040fe20000410000ULL, 0x0000002a002a7220ULL, 0x040fe20000410000ULL,
0x0000002b002b7220ULL, 0x040fe20000410000ULL, 0x0000002600267220ULL, 0x040fe20000410000ULL,
0x0000002700277220ULL, 0x040fe20000410000ULL, 0x0000002200227220ULL, 0x040fe20000410000ULL,
0x0000002300237220ULL, 0x040fe20000410000ULL, 0x0000001e001e7220ULL, 0x040fe20000410000ULL,
0x0000001f001f7220ULL, 0x000fce0000410000ULL, 0x0000ffff19ff7812ULL, 0x000fe2000780601aULL,
0x00000001ff1a7424ULL, 0x000fd800078e00ffULL, 0x8000000917170221ULL, 0x000fe20000010000ULL,
0x00007610ff1a0816ULL, 0x000fc6000000001aULL, 0x3fb8aa3b17170820ULL, 0x000fc80000410000ULL,
0x00000017000f0308ULL, 0x000ea40000000800ULL, 0x0000000f18180220ULL, 0x004fce0000410000ULL,
0x0000000818087221ULL, 0x000fce0000010000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0xfffffff04b177812ULL, 0x000fc800078ec0ffULL, 0x0176b005170075a7ULL, 0x000ea20008000148ULL,
0x00000008171b7c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x004fec0003800000ULL,
0x000000ffff3c7224ULL, 0x000fce00078e00ffULL, 0x000000103c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fce0000015200ULL,
0x0000001806177210ULL, 0x000fca0007f1e1ffULL, 0x0000000119187824ULL, 0x000fe200000e0e07ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1800720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1800720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x002fc80000011418ULL, 0x0000001700007211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0618ULL, 0x0000000200007819ULL, 0x000fc80000001217ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013c3c7836ULL, 0x000fce0000000000ULL, 0x0176b0051b0075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000000202467824ULL, 0x000fe200078e00ffULL,
0x000099101a1a7816ULL, 0x000fe200000000ffULL, 0x0000000402047824ULL, 0x000fe200078e00ffULL,
0x0000000703067812ULL, 0x040fe400078ec0ffULL, 0x0000000803057812ULL, 0x000fe400078ec0ffULL,
0x0000000446007812ULL, 0x002fe400078ec0ffULL, 0x0000000605427212ULL, 0x000fe200078efcffULL,
0x000000ffff057224ULL, 0x000fe200078e001aULL, 0x0000000806177812ULL, 0x000fc400078ef803ULL,
0x0000000003007211ULL, 0x000fe200078fe0ffULL, 0x0000000842197824ULL, 0x000fe200078e00ffULL,
0x000000ff0500720cULL, 0x000fe20003f05270ULL, 0x0001400048057836ULL, 0x000fe20000000000ULL,
0x0000000404047812ULL, 0x000fe200078ec0ffULL, 0x0000000117067824ULL, 0x040fe400078e0200ULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0x0000000403077211ULL, 0x000fc800078fe0ffULL,
0xfffffff817007812ULL, 0x000fe200078ee206ULL, 0x0000000142407824ULL, 0x000fc800078e0207ULL,
0x0000001000177824ULL, 0x000fe200078e020dULL, 0xfffffff819047812ULL, 0x000fe200078ee240ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff197819ULL, 0x000fe40000011603ULL,
0x0000000fff00723eULL, 0x000fc600000000ffULL, 0x00000008190b7836ULL, 0x000fe20000000000ULL,
0x0000541000007816ULL, 0x000fca0000000000ULL, 0x00001f19000c7589ULL, 0x0002a800000e0000ULL,
0x00001f0b000b7589ULL, 0x0002e400000e0000ULL, 0x011800001718783bULL, 0x0022e20000000200ULL,
0x0000001004047824ULL, 0x000fe200078e0205ULL, 0x0000000000100947ULL, 0x000fec0003800000ULL,
0x0000000c18187232ULL, 0x08cfe40000000000ULL, 0x0000000c1a1a7232ULL, 0x000fe40000000000ULL,
0x0000000b19197232ULL, 0x080fe40000000000ULL, 0x0000000b1b1b7232ULL, 0x000fce0000000000ULL,
0x0000000842417824ULL, 0x000fe200078e00ffULL, 0x00000000043c783bULL, 0x000f220000004200ULL,
0x0000000240007836ULL, 0x000fca0000000000ULL, 0xfffffff841007812ULL, 0x000fca00078ee200ULL,
0x0000001000407824ULL, 0x000fcc00078e0205ULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x00000010ff667819ULL, 0x010fe4000001163cULL, 0x00000010ff677819ULL, 0x000fe4000001163dULL,
0x0000ffff3d607812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5f7819ULL, 0x100fe4000001163eULL,
0x000000ff3e5b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fc4000001163eULL,
0x0000ffff3e617812ULL, 0x000fe400078ec0ffULL, 0x00000010ff627819ULL, 0x000fe4000001163fULL,
0x000000ff3c647812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3e7819ULL, 0x022fe40000011640ULL,
0x00000018ff5d7819ULL, 0x000fe4000001163cULL, 0x0000ffff3c657812ULL, 0x000fc400078ec0ffULL,
0x00000018ff687819ULL, 0x000fe40000011642ULL, 0x000000ff3d637812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3c7819ULL, 0x000fe40000011640ULL, 0x000000ff40547812ULL, 0x040fe400078ec0ffULL,
0x0000ffff40587812ULL, 0x000fe400078ec0ffULL, 0x000000ff66667812ULL, 0x000fc400078ec0ffULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x00000008ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff557819ULL, 0x000fe40000011642ULL, 0x000000ff42407812ULL, 0x040fe400078ec0ffULL,
0x0000ffff42477812ULL, 0x000fe400078ec0ffULL, 0x000000ff5f5f7812ULL, 0x000fc400078ec0ffULL,
0x000000ff62697812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001163dULL,
0x0000003eff42723eULL, 0x000fe400020006ffULL, 0x00000008ff627819ULL, 0x000fe40000011661ULL,
0x0000ffff3f3d7812ULL, 0x000fe400078ec0ffULL, 0x00000068ff3e723eULL, 0x000fc400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000060ff68723eULL, 0x000fe400020006ffULL, 0x0000005fff60723eULL, 0x000fc400020006ffULL,
0x00000069ff61723eULL, 0x000fe400020006ffULL, 0x00000062ff5f723eULL, 0x000fe400020006ffULL,
0x00000008ff627819ULL, 0x000fe4000001163dULL, 0x000000ff3c697812ULL, 0x000fe400078ec0ffULL,
0x00000008ff657819ULL, 0x000fe40000011665ULL, 0x00005410643c7816ULL, 0x000fc40000000066ULL,
0x00005410633d7816ULL, 0x000fe40000000067ULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x0000003c1838723cULL, 0x008fe20000001838ULL, 0x000000ff3f5a7812ULL, 0x000fe400078ec0ffULL,
0x0000005bff5b723eULL, 0x000fc400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00005410653c7816ULL, 0x000fe4000000005dULL, 0x00005410683d7816ULL, 0x000fe4000000005eULL,
0x00000018ff567819ULL, 0x000fe4000001163fULL, 0x00000010ff5c7819ULL, 0x000fe40000011641ULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x0000003c1834723cULL, 0x000fe20000001834ULL,
0x00000056ff56723eULL, 0x000fc400020006ffULL, 0x00000062ff63723eULL, 0x000fe400020006ffULL,
0x000000ff41537812ULL, 0x000fe400078ec0ffULL, 0x000054105b3c7816ULL, 0x000fe40000000060ULL,
0x000054105a3d7816ULL, 0x000fe40000000061ULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x00000054ff54723eULL, 0x000fc400020006ffULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x0000003c1830723cULL, 0x000fe20000001830ULL, 0x00000069ff62723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000ffff41597812ULL, 0x000fe400078ec0ffULL,
0x000054105f3c7816ULL, 0x000fe40000000057ULL, 0x00005410633d7816ULL, 0x000fc40000000056ULL,
0x00000018ff447819ULL, 0x000fe40000011641ULL, 0x00000008ff587819ULL, 0x000fe40000011658ULL,
0x00000008ff597819ULL, 0x000fe20000011659ULL, 0x0000003c182c723cULL, 0x000fe2000000182cULL,
0x00000010ff527819ULL, 0x100fe40000011643ULL, 0x000000ff43417812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3f7819ULL, 0x000fc40000011643ULL, 0x00005410543c7816ULL, 0x000fe40000000062ULL,
0x00005410533d7816ULL, 0x000fe4000000005cULL, 0x0000ffff43437812ULL, 0x000fe400078ec0ffULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x0000003c1828723cULL, 0x000fe20000001828ULL, 0x00000059ff59723eULL, 0x000fc400020006ffULL,
0x000000ff55557812ULL, 0x000fe400078ec0ffULL, 0x000000ff52527812ULL, 0x000fe400078ec0ffULL,
0x00000008ff477819ULL, 0x000fe20000011647ULL, 0x000000080a3d7824ULL, 0x000fe200078e00ffULL,
0x00000008ff3c7819ULL, 0x000fe40000011643ULL, 0x0000541058427816ULL, 0x000fe40000000042ULL,
0x0000541059437816ULL, 0x000fc40000000044ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x000000421824723cULL, 0x000fe20000001824ULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fc400020006ffULL,
0x0000003cff3c723eULL, 0x000fe200020006ffULL, 0x000000010a427824ULL, 0x000fe200078e0207ULL,
0x0000541040407816ULL, 0x000fe40000000055ULL, 0x0000541041417816ULL, 0x000fe40000000052ULL,
0x00005410473e7816ULL, 0x000fe4000000003eULL, 0x000054103c3f7816ULL, 0x000fe4000000003fULL,
0xfffffff83d447812ULL, 0x000fe200078ee242ULL, 0x000000401820723cULL, 0x000fe80000001820ULL,
0x00000010443c7824ULL, 0x000fc400078e0205ULL, 0x0000003e1818723cULL, 0x000fe2000000181cULL,
0x01180000451c783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000c1c1c7232ULL, 0x08cfe40000000000ULL,
0x0000000c1e1e7232ULL, 0x000fe40000000000ULL, 0x0000000b1d1d7232ULL, 0x080fe40000000000ULL,
0x0000000b1f1f7232ULL, 0x000fce0000000000ULL, 0x000000080a407824ULL, 0x000fe200078e00ffULL,
0x000000003c3c783bULL, 0x000f220000004200ULL, 0x0000000242457836ULL, 0x002fe20000000000ULL,
0xfffffff846467812ULL, 0x000fc800078ec0ffULL, 0xfffffff840457812ULL, 0x000fca00078ee245ULL,
0x0000001045407824ULL, 0x000fcc00078e0205ULL, 0x000000004040783bULL, 0x000e620000004200ULL,
0x00000010ff677819ULL, 0x110fe4000001163cULL, 0x000000ff3c657812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001163cULL, 0x0000ffff3c667812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5d7819ULL, 0x000fe4000001163eULL, 0x000000ff3e5c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff577819ULL, 0x000fe4000001163eULL, 0x0000ffff3e627812ULL, 0x000fe400078ec0ffULL,
0x00000010ff687819ULL, 0x000fe4000001163dULL, 0x00000010ff3c7819ULL, 0x102fe40000011640ULL,
0x000000ff40557812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3e7819ULL, 0x000fc40000011640ULL,
0x0000ffff40587812ULL, 0x000fe400078ec0ffULL, 0x00000010ff607819ULL, 0x100fe40000011641ULL,
0x000000ff41537812ULL, 0x040fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x0000ffff41597812ULL, 0x000fe400078ec0ffULL, 0x000000ff42417812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3d617812ULL, 0x000fe400078ec0ffULL, 0x000000ff436a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff637819ULL, 0x000fe4000001163fULL, 0x00000010ff5a7819ULL, 0x100fe40000011642ULL,
0x00000018ff697819ULL, 0x000fe40000011642ULL, 0x0000ffff42477812ULL, 0x000fc400078ec0ffULL,
0x00000040ff42723eULL, 0x000fe400020006ffULL, 0x000000ff3d647812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001163dULL, 0x00000041ff40723eULL, 0x000fe400020006ffULL,
0x000000ff3f5b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff567819ULL, 0x000fc4000001163fULL,
0x0000ffff3f3d7812ULL, 0x000fe400078ec0ffULL, 0x0000006aff41723eULL, 0x000fe400020006ffULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x000000ff68687812ULL, 0x000fe400078ec0ffULL,
0x00000008ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff527819ULL, 0x000fc40000011643ULL,
0x00000018ff3f7819ULL, 0x000fe40000011643ULL, 0x0000ffff43547812ULL, 0x000fe400078ec0ffULL,
0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff636a7812ULL, 0x000fe400078ec0ffULL,
0x0000003eff43723eULL, 0x000fe400020006ffULL, 0x00000008ff637819ULL, 0x000fc40000011662ULL,
0x00000069ff3e723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000061ff69723eULL, 0x000fc400020006ffULL,
0x0000005dff61723eULL, 0x000fe400020006ffULL, 0x0000006aff62723eULL, 0x000fe400020006ffULL,
0x00000063ff5d723eULL, 0x000fe400020006ffULL, 0x00000008ff637819ULL, 0x000fe4000001163dULL,
0x000000ff3c6a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff667819ULL, 0x000fc40000011666ULL,
0x00005410653c7816ULL, 0x000fe40000000067ULL, 0x00005410643d7816ULL, 0x000fe40000000068ULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x0000003c1c38723cULL, 0x008fe20000001838ULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00005410663c7816ULL, 0x000fe4000000005eULL,
0x00005410693d7816ULL, 0x000fe4000000005fULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000063ff64723eULL, 0x000fc400020006ffULL, 0x000000ff606b7812ULL, 0x000fe200078ec0ffULL,
0x0000003c1c34723cULL, 0x000fe20000001834ULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x0000006aff60723eULL, 0x000fe400020006ffULL,
0x000054105c3c7816ULL, 0x000fe40000000061ULL, 0x000054105b3d7816ULL, 0x000fc40000000062ULL,
0x0000006bff63723eULL, 0x000fe400020006ffULL, 0x00000008ff587819ULL, 0x000fe40000011658ULL,
0x00000008ff597819ULL, 0x000fe20000011659ULL, 0x0000003c1c30723cULL, 0x000fe20000001830ULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x000000ff5a5a7812ULL, 0x000fc400078ec0ffULL, 0x000054105d3c7816ULL, 0x000fe40000000057ULL,
0x00005410643d7816ULL, 0x000fe40000000056ULL, 0x000000ff52527812ULL, 0x000fe400078ec0ffULL,
0x00000008ff477819ULL, 0x000fe40000011647ULL, 0x00000008ff547819ULL, 0x000fe20000011654ULL,
0x0000003c1c2c723cULL, 0x000fe2000000182cULL, 0x0000003fff3f723eULL, 0x000fc400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x00005410553c7816ULL, 0x000fe40000000060ULL, 0x00005410533d7816ULL, 0x000fe40000000063ULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fc400020006ffULL,
0x0000541040407816ULL, 0x000fe2000000005aULL, 0x0000003c1c28723cULL, 0x000fe20000001828ULL,
0x0000541041417816ULL, 0x000fe40000000052ULL, 0x00005410473e7816ULL, 0x000fe4000000003eULL,
0x00005410543f7816ULL, 0x000fe4000000003fULL, 0x00005410583c7816ULL, 0x000fe20000000043ULL,
0x00000001ff437424ULL, 0x000fe200078e00ffULL, 0x00005410593d7816ULL, 0x000fe20000000042ULL,
0x000000401c20723cULL, 0x000fec0000001820ULL, 0x0000003c1c24723cULL, 0x000fec0000001824ULL,
0x0000003e1c18723cULL, 0x000fe20000001818ULL, 0x000000084d3c7c11ULL, 0x000fcc000f8e18ffULL,
0x0176c8433c3c79a7ULL, 0x0002e2000850003fULL, 0x0176904346ff79a7ULL, 0x0003de0008500008ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000001c7805ULL, 0x000fce0000015200ULL,
0x0000003d120075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fce0000015200ULL,
0x0000001e1c3f7210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x0000003f1e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x0000003d120075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x000000c0111d7836ULL, 0x000fe20000000000ULL,
0x0000940000057ab9ULL, 0x000fc60000000800ULL, 0x00000005161f7c24ULL, 0x000fe2000f8e021dULL,
0x0000000000f89947ULL, 0x000fec0003800000ULL, 0x0000001d7a1c7248ULL, 0x000fe20007fe0000ULL,
0x00000010493d7824ULL, 0x000fe200078e00ffULL, 0x00000003ff1e7819ULL, 0x000fe20000011603ULL,
0x00009000000a7ab9ULL, 0x000fe40000000a00ULL, 0x000000011c1c7824ULL, 0x000fe400078e0a1dULL,
0x000000013d3c7824ULL, 0x000fe400078e021eULL, 0x000000041e3e7836ULL, 0x000fe20000000000ULL,
0x0000001c3d1c7248ULL, 0x000fe20007fe0000ULL, 0x000000013c1d7824ULL, 0x000fc400078e0203ULL,
0x000000083c407824ULL, 0x000fe400078e00ffULL, 0x000000011c1c7824ULL, 0x000fe400078e0a3dULL,
0x000000081e3f7836ULL, 0x000fe20000000000ULL, 0xfffffff840407812ULL, 0x000fe200078ee21dULL,
0x0000000c1e417836ULL, 0x000fe20000000000ULL, 0x0000001c3e00720cULL, 0x080fe20003f66070ULL,
0x000000013d3e7824ULL, 0x000fe200078e023eULL, 0x0000001c1e00720cULL, 0x080fe20003f86070ULL,
0x000000013c1d7824ULL, 0x000fe200078e021fULL, 0x0000001c3f00720cULL, 0x080fe20003f46070ULL,
0x000000013e1e7824ULL, 0x040fe200078e0203ULL, 0x0000001c4100720cULL, 0x000fe20003f06070ULL,
0x000000083e437824ULL, 0x002fc400078e00ffULL, 0x000000801d1c7825ULL, 0x000fc600078e00ffULL,
0xfffffff843427812ULL, 0x000fe200078ee21eULL, 0x000000013d3c7824ULL, 0x040fe200078e023fULL,
0x0000004a1c1c7212ULL, 0x000fe200078efcffULL, 0x000000013e3e7824ULL, 0x000fe400078e021fULL,
0x000000013d527824ULL, 0x000fe200078e0241ULL, 0x0000000a1c1c7c10ULL, 0x000fe2000ffbe0ffULL,
0x000000013c3d7824ULL, 0x040fe400078e0203ULL, 0x000000083c467824ULL, 0x000fe200078e00ffULL,
0x0000000b1d1d7c10ULL, 0x000fe2000affe4ffULL, 0x000000803e3e7825ULL, 0x000fc600078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee23dULL, 0x000000013c1e7824ULL, 0x100fe200078e021fULL,
0x0000004a3e3e7212ULL, 0x000fe200078efcffULL, 0x00000001523c7824ULL, 0x000fe400078e021fULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000000a3e3e7c10ULL, 0x000fc6000ffbe0ffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000004a1e1e7212ULL, 0x080fe400078efcffULL,
0x0000000b3f3f7c10ULL, 0x000fe2000affe4ffULL, 0x0000000152417824ULL, 0x000fe200078e0203ULL,
0x0000004a3c3c7212ULL, 0x000fe200078efcffULL, 0x0000000852527824ULL, 0x000fe200078e00ffULL,
0x0000000a1e1e7c10ULL, 0x000fe2000ffbe0ffULL, 0x0000001042437824ULL, 0x100fe200078e0205ULL,
0x0000000a3c3c7c10ULL, 0x000fe2000ffde0ffULL, 0x0000001046477824ULL, 0x100fe200078e0205ULL,
0xfffffff852527812ULL, 0x000fe200078ee241ULL, 0x0000001040417824ULL, 0x000fe200078e0205ULL,
0x0000000b1f1f7c10ULL, 0x000fc4000affe4ffULL, 0x0000000b3d3d7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001052537824ULL, 0x000fe200078e0205ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c417faeULL, 0x0003e8000e101c46ULL, 0x000000003e437faeULL, 0x0003e8000d901c46ULL,
0x000000001e477faeULL, 0x0003e8000d101c46ULL, 0x000000003c537faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x00000010491c7824ULL, 0x000fe200078e00ffULL,
0x00009000000a7ab9ULL, 0x000fc80000000a00ULL, 0x0000001c031e7211ULL, 0x000fca00078fe8ffULL,
0x000000041e3c7836ULL, 0x000fe40000000000ULL, 0x000000081e427836ULL, 0x000fe40000000000ULL,
0x0000000c1e467836ULL, 0x002fe40000000000ULL, 0x000000011e1d7824ULL, 0x040fe400078e0203ULL,
0x000000081e407824ULL, 0x040fe400078e00ffULL, 0x000000011e1c7824ULL, 0x000fc400078e021fULL,
0x000000013c1e7824ULL, 0x040fe200078e021fULL, 0xfffffff840407812ULL, 0x000fe200078ee21dULL,
0x000000013c3d7824ULL, 0x040fe400078e0203ULL, 0x000000083c527824ULL, 0x000fe400078e00ffULL,
0x00000001423c7824ULL, 0x100fe400078e021fULL, 0x00000001463e7824ULL, 0x000fe400078e021fULL,
0x00000001421f7824ULL, 0x000fc400078e0203ULL, 0x0000000842547824ULL, 0x000fe200078e00ffULL,
0xfffffff852427812ULL, 0x000fe200078ee23dULL, 0x00000001463f7824ULL, 0x040fe400078e0203ULL,
0x0000000846567824ULL, 0x000fe200078e00ffULL, 0xfffffff854467812ULL, 0x000fe200078ee21fULL,
0x000000801c1c7825ULL, 0x000fc600078e00ffULL, 0xfffffff856527812ULL, 0x000fe200078ee23fULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000004a1c1c7212ULL, 0x000fc600078efcffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000004a1e1e7212ULL, 0x080fe400078efcffULL,
0x0000000a1c1c7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x0000004a3c3c7212ULL, 0x080fe400078efcffULL, 0x0000000a1e1e7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001040417824ULL, 0x100fe200078e0205ULL, 0x0000004a3e3e7212ULL, 0x000fe200078efcffULL,
0x0000001042437824ULL, 0x100fe200078e0205ULL, 0x0000000b1d1d7c10ULL, 0x000fe200087fe4ffULL,
0x0000001046477824ULL, 0x100fe200078e0205ULL, 0x0000000a3c3c7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001052537824ULL, 0x000fe200078e0205ULL, 0x0000000a3e3e7c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c417faeULL, 0x0003e2000b901c46ULL,
0x0000000b1f1f7c10ULL, 0x000fc400097fe4ffULL, 0x0000000b3d3d7c10ULL, 0x000fe400087fe4ffULL,
0x0000000b3f3f7c10ULL, 0x000fe20009ffe4ffULL, 0x000000001e437faeULL, 0x0003e8000b901c46ULL,
0x000000003c477faeULL, 0x0003e8000b901c46ULL, 0x000000003e537faeULL, 0x0003e4000b901c46ULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000008ff1d7e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff04b467812ULL, 0x000fe200078ec0ffULL,
0x00000001ff1f7424ULL, 0x000fc600078e00ffULL, 0x000176a846467810ULL, 0x000fe40007ffe01dULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000081f464679a7ULL, 0x0002e4000850003fULL, 0x0176481f101e79a7ULL, 0x0022a4000850003fULL,
0x00000000001c7805ULL, 0x000fce0000015200ULL, 0xffffffe04b107812ULL, 0x042fe400078ec0ffULL,
0x000000104b3d7812ULL, 0x040fe400078ec0ffULL, 0x000000084b3c7812ULL, 0x000fe400078ec0ffULL,
0x000000083d3d7c10ULL, 0x000fca000fffe010ULL, 0x000000013d417824ULL, 0x000fc800078e023cULL,
0x0176481f410075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fce0000015200ULL,
0x0000003c1c3f7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e1dULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x000fc8000001143dULL, 0x0000003f10107211ULL, 0x000fca00078110ffULL,
0x000000ffff3d7224ULL, 0x000fca00000e063dULL, 0x0000000210107819ULL, 0x000fc8000000123dULL,
0x000000100000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x0176481f410075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000002002107824ULL, 0x000fe400078e00ffULL,
0x00000008ff1d7e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff3c7424ULL, 0x000fe200078e00ffULL,
0xffffff8010107812ULL, 0x000fc800078ec0ffULL, 0x000001001d1d7810ULL, 0x000fc80007ffe010ULL,
0x0000001d4e1d7210ULL, 0x000fca0007ffe04aULL, 0x017000001d107984ULL, 0x000e680000000800ULL,
0x017200001d1e7984ULL, 0x0004a20000000800ULL, 0x000000091000720bULL, 0x002fda0003f1d000ULL,
0x00000000001c7806ULL, 0x000fc800000e0100ULL, 0x0000ffff1c1f7812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x00cfea0003800000ULL, 0x000000024c1d7836ULL, 0x000fe20000000000ULL,
0x000000091000720bULL, 0x000fc80003f14000ULL, 0x000000021d00720cULL, 0x000fd20003f45270ULL,
0x00000000003c7806ULL, 0x000fc800000e0100ULL, 0x00000008021dac11ULL, 0x000fe4000f8e38ffULL,
0x00000009101ca209ULL, 0x000fe40007810000ULL, 0x0000001d4e3da210ULL, 0x000fe40007ffe04aULL,
0x000099103c1d7816ULL, 0x000fc600000000ffULL, 0x0174001c3d00a388ULL, 0x0003e20000000800ULL,
0x000000ff1d00720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x00000009101c7209ULL, 0x000fe40007810000ULL, 0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff003cff7812ULL, 0x000fe2000784c0ffULL, 0x000000091c1c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL, 0x0000001c001d7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff1c7819ULL, 0x002fcc0000011603ULL,
0x00001f1c1d1c7589ULL, 0x004e6400000e0000ULL, 0x000000381c387220ULL, 0x042fe20000410000ULL,
0x000000391c397220ULL, 0x040fe20000410000ULL, 0x000000341c347220ULL, 0x040fe20000410000ULL,
0x000000351c357220ULL, 0x040fe20000410000ULL, 0x000000301c307220ULL, 0x040fe20000410000ULL,
0x000000311c317220ULL, 0x040fe20000410000ULL, 0x0000002c1c2c7220ULL, 0x040fe20000410000ULL,
0x0000002d1c2d7220ULL, 0x040fe20000410000ULL, 0x000000281c287220ULL, 0x040fe20000410000ULL,
0x000000291c297220ULL, 0x040fe20000410000ULL, 0x000000241c247220ULL, 0x040fe20000410000ULL,
0x000000251c257220ULL, 0x040fe20000410000ULL, 0x000000201c207220ULL, 0x040fe20000410000ULL,
0x000000211c217220ULL, 0x040fe20000410000ULL, 0x000000181c187220ULL, 0x040fe20000410000ULL,
0x000000191c197220ULL, 0x000fce0000410000ULL, 0x0000001d08087220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x00000008031c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f1c1d1c7589ULL, 0x000e6400000e0000ULL, 0x0000003a1c3a7220ULL, 0x042fe20000410000ULL,
0x0000003b1c3b7220ULL, 0x040fe20000410000ULL, 0x000000361c367220ULL, 0x040fe20000410000ULL,
0x000000371c377220ULL, 0x040fe20000410000ULL, 0x000000321c327220ULL, 0x040fe20000410000ULL,
0x000000331c337220ULL, 0x040fe20000410000ULL, 0x0000002e1c2e7220ULL, 0x040fe20000410000ULL,
0x0000002f1c2f7220ULL, 0x040fe20000410000ULL, 0x0000002a1c2a7220ULL, 0x040fe20000410000ULL,
0x0000002b1c2b7220ULL, 0x040fe20000410000ULL, 0x000000261c267220ULL, 0x040fe20000410000ULL,
0x000000271c277220ULL, 0x040fe20000410000ULL, 0x000000221c227220ULL, 0x040fe20000410000ULL,
0x000000231c237220ULL, 0x040fe20000410000ULL, 0x0000001a1c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b1c1b7220ULL, 0x000fce0000410000ULL, 0x0000ffff1fff7812ULL, 0x000fe2000780603cULL,
0x00000001ff3c7424ULL, 0x000fe200078e00ffULL, 0x0000000910097209ULL, 0x000fd60007810000ULL,
0x8000000910100221ULL, 0x000fe20000010000ULL, 0x00007610ff3c0816ULL, 0x000fc6000000003cULL,
0x3fb8aa3b10100820ULL, 0x000fc80000410000ULL, 0x00000010000f0308ULL, 0x000ea40000000800ULL,
0x0000000f1e1e0220ULL, 0x004fce0000410000ULL, 0x000000081e087221ULL, 0x000fe20000010000ULL,
0x00000000001c7805ULL, 0x002fe40000015200ULL, 0xfffffff04b1f7812ULL, 0x000fc800078ec0ffULL,
0x0176a8151f0075a7ULL, 0x000ea20008000148ULL, 0x000000081f3f7c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x006fec0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c3d7210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc8000001141fULL,
0x0000003d10107211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x0000000210107819ULL, 0x000fc8000000121fULL, 0x000000100000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x0176a8153f0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000803107812ULL, 0x000fe400078ec0ffULL, 0x000099103c3c7816ULL, 0x000fe400000000ffULL,
0x0000000710147812ULL, 0x000fc600078ef803ULL, 0x000000ffff107224ULL, 0x000fe400078e003cULL,
0x0000000114077824ULL, 0x040fe400078e0207ULL, 0x0000000814147824ULL, 0x000fe200078e00ffULL,
0x000000ff1000720cULL, 0x000fc80003f05270ULL, 0xfffffff814077812ULL, 0x000fca00078ee207ULL,
0x00000010071c7824ULL, 0x000fc800078e020eULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe40000011603ULL, 0x0000000fff07723eULL, 0x000fc600000000ffULL,
0x000000080c107836ULL, 0x000fe20000000000ULL, 0x0000541007077816ULL, 0x000fca0000000007ULL,
0x00001f0c070c7589ULL, 0x0002a800000e0000ULL, 0x00001f10070b7589ULL, 0x0002e400000e0000ULL,
0x01200000173c783bULL, 0x0002e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000c3c3c7232ULL, 0x08cfe40000000000ULL, 0x0000000c3e3e7232ULL, 0x000fe40000000000ULL,
0x0000000b3d3d7232ULL, 0x080fe40000000000ULL, 0x0000000b3f3f7232ULL, 0x000fce0000000000ULL,
0x0000001000407824ULL, 0x000fe200078e020eULL, 0x000000001c1c783bULL, 0x000f220000004200ULL,
0x0000000703007812ULL, 0x000fc800078ec0ffULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x0000000800077812ULL, 0x002fe200078ef803ULL, 0x0000000206007836ULL, 0x000fc80000000000ULL,
0x0000000807077824ULL, 0x000fca00078e00ffULL, 0xfffffff807007812ULL, 0x000fca00078ee200ULL,
0x00000010000d7824ULL, 0x000fe200078e020dULL, 0x00000010ff627819ULL, 0x110fe4000001161cULL,
0x000000ff1c5e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5b7819ULL, 0x000fe4000001161cULL,
0x0000ffff1c077812ULL, 0x000fe400078ec0ffULL, 0x000000ff40177812ULL, 0x020fe400078ec0ffULL,
0x00000010ff637819ULL, 0x000fc4000001161dULL, 0x000000ff1d5d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001161dULL, 0x0000ffff1d617812ULL, 0x000fe400078ec0ffULL,
0x000000ff421c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff607819ULL, 0x000fe4000001161eULL,
0x000000ff1e5a7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff557819ULL, 0x000fe4000001161eULL,
0x0000ffff1e157812ULL, 0x000fe400078ec0ffULL, 0x00000010ff577819ULL, 0x100fe40000011640ULL,
0x00000018ff1d7819ULL, 0x000fe40000011640ULL, 0x0000ffff40567812ULL, 0x000fe400078ec0ffULL,
0x000000ff43647812ULL, 0x000fc400078ec0ffULL, 0x00000010ff587819ULL, 0x100fe40000011641ULL,
0x000000ff41407812ULL, 0x040fe400078ec0ffULL, 0x00000018ff1e7819ULL, 0x000fe40000011641ULL,
0x0000ffff41527812ULL, 0x000fe400078ec0ffULL, 0x00000017ff41723eULL, 0x000fe400020006ffULL,
0x0000001cff17723eULL, 0x000fc400020006ffULL, 0x00000064ff1c723eULL, 0x000fe400020006ffULL,
0x000000ff62627812ULL, 0x000fe400078ec0ffULL, 0x000000ff63647812ULL, 0x000fe400078ec0ffULL,
0x00000018ff657819ULL, 0x000fe40000011642ULL, 0x00000010ff5f7819ULL, 0x000fe4000001161fULL,
0x0000ffff1f147812ULL, 0x000fc400078ec0ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000008ff637819ULL, 0x000fe40000011607ULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000065ff07723eULL, 0x000fc400020006ffULL, 0x000000ff5f657812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5f7819ULL, 0x000fe40000011615ULL, 0x00000008ff667819ULL, 0x000fe40000011614ULL,
0x00000008ff617819ULL, 0x000fe40000011661ULL, 0x000054105e147816ULL, 0x000fe40000000062ULL,
0x000054105d157816ULL, 0x000fc40000000064ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x000000143c38723cULL, 0x008fe20000001838ULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x000000ff1f597812ULL, 0x000fe400078ec0ffULL, 0x000000ff60607812ULL, 0x000fc400078ec0ffULL,
0x0000541063147816ULL, 0x000fe4000000005bULL, 0x0000541061157816ULL, 0x000fe4000000005cULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x000000143c34723cULL, 0x000fe20000001834ULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x00000018ff547819ULL, 0x000fe4000001161fULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x000054105a147816ULL, 0x000fe40000000060ULL,
0x0000541059157816ULL, 0x000fe40000000065ULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fc400020006ffULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x000000143c30723cULL, 0x000fe20000001830ULL, 0x000000ff57577812ULL, 0x000fe400078ec0ffULL,
0x000000ff58587812ULL, 0x000fe400078ec0ffULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x000054105f147816ULL, 0x000fe40000000055ULL, 0x0000541066157816ULL, 0x000fc40000000054ULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000008ff567819ULL, 0x000fe20000011656ULL, 0x000000143c2c723cULL, 0x000fe2000000182cULL,
0x00000008ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff537819ULL, 0x000fe40000011642ULL,
0x00000010ff1f7819ULL, 0x000fc40000011643ULL, 0x0000541041147816ULL, 0x000fe40000000057ULL,
0x0000541040157816ULL, 0x000fe40000000058ULL, 0x00000018ff107819ULL, 0x000fe40000011643ULL,
0x0000001dff1d723eULL, 0x000fe400020006ffULL, 0x0000001eff1e723eULL, 0x000fe200020006ffULL,
0x000000143c28723cULL, 0x000fe20000001828ULL, 0x00000056ff56723eULL, 0x000fc400020006ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x0000ffff42427812ULL, 0x000fe400078ec0ffULL,
0x0000ffff43437812ULL, 0x000fe400078ec0ffULL, 0x000000ff53537812ULL, 0x000fe400078ec0ffULL,
0x000000ff1f1f7812ULL, 0x000fe400078ec0ffULL, 0x0000541056147816ULL, 0x000fc4000000001dULL,
0x0000541052157816ULL, 0x000fe4000000001eULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000008ff437819ULL, 0x000fe40000011643ULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x000000143c24723cULL, 0x000fe20000001824ULL, 0x0000001fff1f723eULL, 0x000fe400020006ffULL,
0x00000010ff10723eULL, 0x000fc400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x0000541017147816ULL, 0x000fe40000000053ULL,
0x000054101c157816ULL, 0x000fe4000000001fULL, 0x0000541042427816ULL, 0x000fe20000000007ULL,
0x012000000d1c783bULL, 0x0002e20000000200ULL, 0x0000541043437816ULL, 0x000fc60000000010ULL,
0x000000143c20723cULL, 0x000fec0000001820ULL, 0x000000423c3c723cULL, 0x000fee0000001818ULL,
0x0000001044187824ULL, 0x000fe200078e020eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000100947ULL, 0x002fde0003800000ULL, 0x0000000c1c1c7232ULL, 0x08cfe40000000000ULL,
0x0000000c1e1e7232ULL, 0x000fe40000000000ULL, 0x0000000b1d1d7232ULL, 0x080fe40000000000ULL,
0x0000000b1f1f7232ULL, 0x000fce0000000000ULL, 0x0000001045407824ULL, 0x000fe200078e020eULL,
0x000000001818783bULL, 0x000e6a0000004200ULL, 0x000000004040783bULL, 0x000f220000004200ULL,
0x00000010ff607819ULL, 0x102fe40000011618ULL, 0x000000ff185b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff587819ULL, 0x000fc40000011618ULL, 0x000000ff40077812ULL, 0x010fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe40000011642ULL, 0x0000ffff180d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff617819ULL, 0x000fe40000011619ULL, 0x00000010ff157819ULL, 0x100fe40000011640ULL,
0x00000018ff187819ULL, 0x000fc40000011640ULL, 0x0000ffff40537812ULL, 0x000fe400078ec0ffULL,
0x00000007ff40723eULL, 0x000fe400020006ffULL, 0x00000062ff07723eULL, 0x000fe400020006ffULL,
0x000000ff195c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff60607812ULL, 0x000fe400078ec0ffULL,
0x000000ff61627812ULL, 0x000fc400078ec0ffULL, 0x00000018ff637819ULL, 0x000fe40000011643ULL,
0x0000ffff1b147812ULL, 0x000fe400078ec0ffULL, 0x0000ffff195f7812ULL, 0x000fe400078ec0ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000008ff617819ULL, 0x000fe4000001160dULL, 0x00000063ff0d723eULL, 0x000fe400020006ffULL,
0x00000008ff637819ULL, 0x000fe40000011614ULL, 0x000000ff15647812ULL, 0x000fe400078ec0ffULL,
0x00000018ff597819ULL, 0x000fc40000011619ULL, 0x00000008ff5f7819ULL, 0x000fe4000001165fULL,
0x000054105b147816ULL, 0x000fe40000000060ULL, 0x000054105c157816ULL, 0x000fe40000000062ULL,
0x00000010ff5e7819ULL, 0x000fe4000001161aULL, 0x00000010ff5d7819ULL, 0x000fe4000001161bULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x000000141c38723cULL, 0x008fe20000001838ULL,
0x00000059ff59723eULL, 0x000fc400020006ffULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x000000ff1a577812ULL, 0x000fe400078ec0ffULL,
0x000000ff1b567812ULL, 0x000fe400078ec0ffULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5d5d7812ULL, 0x000fc400078ec0ffULL, 0x0000541061147816ULL, 0x000fe40000000058ULL,
0x000054105f157816ULL, 0x000fe40000000059ULL, 0x0000ffff1a5a7812ULL, 0x000fe400078ec0ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x000000141c34723cULL, 0x000fe20000001834ULL, 0x0000005eff5e723eULL, 0x000fc400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000018ff527819ULL, 0x000fe4000001161aULL,
0x00000018ff457819ULL, 0x000fe4000001161bULL, 0x00000008ff5a7819ULL, 0x000fe4000001165aULL,
0x0000541057147816ULL, 0x000fe4000000005eULL, 0x0000541056157816ULL, 0x000fc4000000005dULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x000000141c30723cULL, 0x000fe20000001830ULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x0000ffff41547812ULL, 0x000fe400078ec0ffULL,
0x00000010ff557819ULL, 0x000fc40000011641ULL, 0x000054105a147816ULL, 0x000fe40000000052ULL,
0x0000541063157816ULL, 0x000fe40000000045ULL, 0x000000ff411b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff197819ULL, 0x000fe40000011641ULL, 0x00000010ff417819ULL, 0x000fe20000011642ULL,
0x000000141c2c723cULL, 0x000fe2000000182cULL, 0x00000010ff1a7819ULL, 0x000fc40000011643ULL,
0x00000008ff537819ULL, 0x000fe40000011653ULL, 0x00000008ff547819ULL, 0x000fe40000011654ULL,
0x000000ff42107812ULL, 0x040fe400078ec0ffULL, 0x000000ff43177812ULL, 0x040fe400078ec0ffULL,
0x0000ffff42427812ULL, 0x000fe400078ec0ffULL, 0x0000ffff43437812ULL, 0x000fc400078ec0ffULL,
0x00000018ff18723eULL, 0x000fe400020006ffULL, 0x00000019ff19723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x000000ff41417812ULL, 0x000fe400078ec0ffULL, 0x000000ff1a147812ULL, 0x000fc400078ec0ffULL,
0x000000ff55557812ULL, 0x000fe400078ec0ffULL, 0x00000010ff10723eULL, 0x000fe400020006ffULL,
0x00000017ff17723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x00000008ff427819ULL, 0x000fe40000011642ULL, 0x00000014ff15723eULL, 0x000fc400020006ffULL,
0x00000008ff437819ULL, 0x000fe40000011643ULL, 0x0000541053187816ULL, 0x000fe40000000018ULL,
0x0000541054197816ULL, 0x000fe40000000019ULL, 0x0000001bff1b723eULL, 0x000fe400020006ffULL,
0x00000064ff5b723eULL, 0x000fe400020006ffULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x000000181c24723cULL, 0x000fe20000001824ULL, 0x00000042ff42723eULL, 0x000fc400020006ffULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x0000541010147816ULL, 0x000fe40000000041ULL,
0x0000541017157816ULL, 0x000fe20000000015ULL, 0x00000001ff197424ULL, 0x000fe200078e00ffULL,
0x00005410401a7816ULL, 0x000fe4000000005bULL, 0x000054101b1b7816ULL, 0x000fe40000000055ULL,
0x0000541042427816ULL, 0x000fe20000000007ULL, 0x000000141c20723cULL, 0x000fe20000001820ULL,
0x0000541043437816ULL, 0x000fe2000000000dULL, 0x00000019121479a7ULL, 0x0002e2000850003fULL,
0x000000084c187c11ULL, 0x000fc6000f8e18ffULL, 0x0000001a1c28723cULL, 0x000fe20000001828ULL,
0x0176981918ff79a7ULL, 0x0003ea000850003fULL, 0x000000421c1c723cULL, 0x000fde000000183cULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000000187805ULL, 0x002fce0000015200ULL,
0x00000015120075a7ULL, 0x008e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0d7224ULL, 0x000fce00078e00ffULL, 0x000000100d00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fce0000015200ULL,
0x0000001a18107210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1a7824ULL, 0x000fe200000e0e19ULL,
0x003d09001000780cULL, 0x000fc80003f06070ULL, 0x000000ff1a00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401000780cULL, 0x000fc80003f06070ULL,
0x000000ff1a00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc8000001141aULL, 0x0000001007077211ULL, 0x000fca00078110ffULL,
0x000000ffff107224ULL, 0x000fca00000e061aULL, 0x0000000207077819ULL, 0x000fc80000001210ULL,
0x000000070000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010d0d7836ULL, 0x000fce0000000000ULL, 0x00000015120075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000113107836ULL, 0x000fca0000000000ULL,
0x0000007b1000720cULL, 0x000fda0003f06070ULL, 0x0000000400d40947ULL, 0x000fea0003800000ULL,
0x0000000213107836ULL, 0x000fe20000000000ULL, 0x0000940000057ab9ULL, 0x000fe20000000800ULL,
0x0000010011117836ULL, 0x000fc60000000000ULL, 0x0000007b1000720cULL, 0x000fe20003f06070ULL,
0x00000005160d7c24ULL, 0x000fd8000f8e0211ULL, 0x0000000000f88947ULL, 0x000fea0003800000ULL,
0x000000117a077248ULL, 0x000fe20007fe0000ULL, 0x0000001049107824ULL, 0x000fe200078e00ffULL,
0x00000003ff147819ULL, 0x000fe20000011603ULL, 0x00009000000a7ab9ULL, 0x000fe40000000a00ULL,
0x0000000107077824ULL, 0x000fe400078e0a11ULL, 0x0000000110187824ULL, 0x000fe400078e0214ULL,
0x0000000414157836ULL, 0x000fe20000000000ULL, 0x0000000710077248ULL, 0x000fe20007fe0000ULL,
0x0000000118117824ULL, 0x000fc400078e0203ULL, 0x00000008181a7824ULL, 0x000fe400078e00ffULL,
0x0000000107077824ULL, 0x000fc600078e0a10ULL, 0xfffffff81a177812ULL, 0x000fe200078ee211ULL,
0x0000000814117836ULL, 0x000fe20000000000ULL, 0x000000071400720cULL, 0x080fe20003f86070ULL,
0x0000000c14147836ULL, 0x000fe20000000000ULL, 0x000000071500720cULL, 0x080fe20003f66070ULL,
0x00000001103c7824ULL, 0x040fe200078e0211ULL, 0x000000071100720cULL, 0x080fe20003f46070ULL,
0x00000001101a7824ULL, 0x000fe200078e0215ULL, 0x000000071400720cULL, 0x000fe20003f06070ULL,
0x00000001103e7824ULL, 0x000fe400078e0214ULL, 0x000000013c107824ULL, 0x000fc400078e0203ULL,
0x000000083c3d7824ULL, 0x000fe400078e00ffULL, 0x0000000118147824ULL, 0x100fe400078e020dULL,
0x000000011a187824ULL, 0x000fe200078e020dULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee210ULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x000000011a077824ULL, 0x000fe200078e0203ULL,
0x0000004a14147212ULL, 0x080fe200078efcffULL, 0x000000081a407824ULL, 0x000fe400078e00ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000000a14147c10ULL, 0x000fe4000ffbe0ffULL,
0xfffffff840077812ULL, 0x000fe200078ee207ULL, 0x000000013c107824ULL, 0x100fe200078e020dULL,
0x0000004a18187212ULL, 0x000fe200078efcffULL, 0x000000013e1a7824ULL, 0x000fe200078e020dULL,
0x0000000b15157c10ULL, 0x000fe2000affe4ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000a18187c10ULL, 0x000fc6000ffde0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000004a10107212ULL, 0x080fe400078efcffULL, 0x0000000b19197c10ULL, 0x000fe2000b7fe4ffULL,
0x000000013e0d7824ULL, 0x000fe200078e0203ULL, 0x0000004a1a1a7212ULL, 0x000fe200078efcffULL,
0x000000083e3e7824ULL, 0x000fe200078e00ffULL, 0x0000000a10107c10ULL, 0x000fe2000ffbe0ffULL,
0x0000001017177824ULL, 0x100fe200078e020eULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ffde0ffULL,
0x0000001007077824ULL, 0x100fe200078e020eULL, 0xfffffff83e0d7812ULL, 0x000fe200078ee20dULL,
0x000000103d3d7824ULL, 0x100fe200078e020eULL, 0x0000000b11117c10ULL, 0x000fe2000affe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000e101c46ULL,
0x0000000b1b1b7c10ULL, 0x000fe2000b7fe4ffULL, 0x000000100d0d7824ULL, 0x000fc400078e020eULL,
0x0000000018077faeULL, 0x0003e8000d901c46ULL, 0x00000000103d7faeULL, 0x0003e8000d101c46ULL,
0x000000001a0d7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x0000001049107824ULL, 0x000fe200078e00ffULL, 0x00009000000a7ab9ULL, 0x000fc80000000a00ULL,
0x0000001003147211ULL, 0x000fca00078fe8ffULL, 0x0000000114077824ULL, 0x040fe400078e0203ULL,
0x0000000814187824ULL, 0x040fe400078e00ffULL, 0x0000000114107824ULL, 0x000fe400078e020dULL,
0x0000000c143e7836ULL, 0x000fe20000000000ULL, 0xfffffff818077812ULL, 0x000fe200078ee207ULL,
0x0000000414187836ULL, 0x000fe40000000000ULL, 0x00000008143c7836ULL, 0x000fc40000000000ULL,
0x0000000118147824ULL, 0x040fe400078e020dULL, 0x0000000118157824ULL, 0x040fe400078e0203ULL,
0x0000000818407824ULL, 0x000fe400078e00ffULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x000000013e187824ULL, 0x000fe200078e020dULL, 0x0000004a10107212ULL, 0x080fe200078efcffULL,
0x000000013e197824ULL, 0x040fe400078e0203ULL, 0x000000083e3e7824ULL, 0x000fe200078e00ffULL,
0x0000000a10107c10ULL, 0x000fe2000ff1e0ffULL, 0x000000013c1a7824ULL, 0x000fe200078e020dULL,
0xfffffff8400d7812ULL, 0x000fe200078ee215ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff83e3d7812ULL, 0x000fe400078ee219ULL, 0x0000000b11117c10ULL, 0x000fe200087fe4ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000004a14147212ULL, 0x000fc600078efcffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000004a1a1a7212ULL, 0x080fe400078efcffULL,
0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL, 0x000000013c177824ULL, 0x000fe200078e0203ULL,
0x0000004a18187212ULL, 0x000fe200078efcffULL, 0x000000083c3c7824ULL, 0x000fe200078e00ffULL,
0x0000000a1a1a7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001007077824ULL, 0x100fe200078e020eULL,
0x0000000a18187c10ULL, 0x000fe2000ff7e0ffULL, 0x000000100d0d7824ULL, 0x100fe200078e020eULL,
0xfffffff83c177812ULL, 0x000fe200078ee217ULL, 0x000000103d3d7824ULL, 0x100fe200078e020eULL,
0x0000000b15157c10ULL, 0x000fe200087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010077faeULL, 0x0003e2000b901c46ULL, 0x0000000b1b1b7c10ULL, 0x000fe200097fe4ffULL,
0x0000001017177824ULL, 0x000fe200078e020eULL, 0x0000000b19197c10ULL, 0x000fe20009ffe4ffULL,
0x00000000140d7faeULL, 0x0003e8000b901c46ULL, 0x000000001a177faeULL, 0x0003e8000b901c46ULL,
0x00000000183d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000014d077812ULL, 0x000fe200078ec0ffULL, 0x00000001ff187424ULL, 0x000fe200078e00ffULL,
0x000000084c0e7c11ULL, 0x000fe2000f8e28ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x000000084b147812ULL, 0x000fe400078ec0ffULL, 0x000000084d107c11ULL, 0x000fe2000f8e20ffULL,
0x0000001007077824ULL, 0x000fe200078e020eULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0176a818101079a7ULL, 0x0002e2000850003fULL, 0x00000001140d7824ULL, 0x000fc800078e0207ULL,
0x017668180d1879a7ULL, 0x0022a4000850003fULL, 0x000000ffff077224ULL, 0x00afce00078e0011ULL,
0x0000000000107805ULL, 0x000fe20000015200ULL, 0x017668190d0075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc80000011415ULL,
0x000000170e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x000000020e0e7819ULL, 0x000fc80000001215ULL, 0x0000000e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x017668190d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000084c0d7c11ULL, 0x000fe2000f8e38ffULL, 0x00000001ff177424ULL, 0x000fc600078e00ffULL,
0x000001804a0d7810ULL, 0x000fca0007ffe00dULL, 0x000000014e0e7824ULL, 0x000fca00078e020dULL,
0x017000000e107984ULL, 0x000e680000000800ULL, 0x017200000e117984ULL, 0x0004a20000000800ULL,
0x000000091000720bULL, 0x002fda0003f1d000ULL, 0x00000000000d7806ULL, 0x000fc800000e0100ULL,
0x0000ffff0d147812ULL, 0x000fe2000780c0ffULL, 0x000000ffff0d7224ULL, 0x000fd800078e0009ULL,
0x0000000000f88947ULL, 0x004fea0003800000ULL, 0x000000034c0d7836ULL, 0x000fe20000000000ULL,
0x000000091000720bULL, 0x000fc80003f14000ULL, 0x000000020d00720cULL, 0x000fe40003f45270ULL,
0x00000009100d7209ULL, 0x000fd60007810000ULL, 0x000000080215ac11ULL, 0x000fc8000f8e38ffULL,
0x000000154e4aa210ULL, 0x000fe40007ffe04aULL, 0x0000000000157806ULL, 0x000fc600000e0100ULL,
0x0174000d4a00a388ULL, 0x0003e20000000800ULL, 0x00009910150e7816ULL, 0x000fc800000000ffULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x000000090d097221ULL, 0x000fe20000010100ULL, 0x000000ff15ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0015ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x0000000900177308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff0e7819ULL, 0x000fca0000011603ULL, 0x00001f0e17097589ULL, 0x006e6400000e0000ULL,
0x0000003809387220ULL, 0x042fe20000410000ULL, 0x0000003909397220ULL, 0x040fe20000410000ULL,
0x0000003409347220ULL, 0x040fe20000410000ULL, 0x0000003509357220ULL, 0x040fe20000410000ULL,
0x0000003009307220ULL, 0x040fe20000410000ULL, 0x0000003109317220ULL, 0x040fe20000410000ULL,
0x0000002c092c7220ULL, 0x040fe20000410000ULL, 0x0000002d092d7220ULL, 0x040fe20000410000ULL,
0x0000002809287220ULL, 0x040fe20000410000ULL, 0x0000002909297220ULL, 0x040fe20000410000ULL,
0x0000002409247220ULL, 0x040fe20000410000ULL, 0x0000002509257220ULL, 0x040fe20000410000ULL,
0x0000002009207220ULL, 0x040fe20000410000ULL, 0x0000002109217220ULL, 0x040fe20000410000ULL,
0x0000001c091c7220ULL, 0x040fe20000410000ULL, 0x0000001d091d7220ULL, 0x000fce0000410000ULL,
0x0000001708087220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x00000008030e7811ULL, 0x000fca00078ff0ffULL, 0x00001f0e17097589ULL, 0x002e6400000e0000ULL,
0x0000003a093a7220ULL, 0x042fe20000410000ULL, 0x0000003b093b7220ULL, 0x040fe20000410000ULL,
0x0000003609367220ULL, 0x040fe20000410000ULL, 0x0000003709377220ULL, 0x040fe20000410000ULL,
0x0000003209327220ULL, 0x040fe20000410000ULL, 0x0000003309337220ULL, 0x040fe20000410000ULL,
0x0000002e092e7220ULL, 0x040fe20000410000ULL, 0x0000002f092f7220ULL, 0x040fe20000410000ULL,
0x0000002a092a7220ULL, 0x040fe20000410000ULL, 0x0000002b092b7220ULL, 0x040fe20000410000ULL,
0x0000002609267220ULL, 0x040fe20000410000ULL, 0x0000002709277220ULL, 0x040fe20000410000ULL,
0x0000002209227220ULL, 0x040fe20000410000ULL, 0x0000002309237220ULL, 0x040fe20000410000ULL,
0x0000001e091e7220ULL, 0x040fe20000410000ULL, 0x0000001f091f7220ULL, 0x000fce0000410000ULL,
0x0000ffff14ff7812ULL, 0x000fe20007806015ULL, 0x00000001ff177424ULL, 0x000fd800078e00ffULL,
0x000000100d100221ULL, 0x000fe20000010100ULL, 0x00007610ff170816ULL, 0x000fc60000000017ULL,
0x3fb8aa3b10100820ULL, 0x000fc80000410000ULL, 0x00000010000f0308ULL, 0x000ea40000000800ULL,
0x0000000f11110220ULL, 0x004fce0000410000ULL, 0x0000000811087221ULL, 0x000fce0000010000ULL,
0x0000000000107805ULL, 0x000fe40000015200ULL, 0xfffffff04b157812ULL, 0x000fe200078ec0ffULL,
0x0000000402097824ULL, 0x002fc600078e00ffULL, 0x0176b047150075a7ULL, 0x000ea20008000148ULL,
0x00000008151b7c36ULL, 0x000fe20008000000ULL, 0x0000000409097812ULL, 0x000fc800078ec0ffULL,
0x0000000209097812ULL, 0x000fe200078efcffULL, 0x00000000005c0947ULL, 0x006fec0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410197210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc80000011415ULL, 0x000000190e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x000000020e0e7819ULL, 0x000fc80000001215ULL,
0x0000000e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187836ULL, 0x000fce0000000000ULL, 0x0176b0471b0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000703117812ULL, 0x000fe400078ec0ffULL,
0x00009910170e7816ULL, 0x000fe400000000ffULL, 0x0000000811107812ULL, 0x000fe400078ef803ULL,
0x000000ff0e00720cULL, 0x000fe40003f05270ULL, 0x0000000903097211ULL, 0x040fe200078fe0ffULL,
0x0000000810157824ULL, 0x000fe200078e00ffULL, 0x0000000803107812ULL, 0x000fc800078ec0ffULL,
0xfffffff815157812ULL, 0x000fe400078ee206ULL, 0x000000084c067c11ULL, 0x000fe4000f8e58ffULL,
0x0000001110107212ULL, 0x000fc600078efcffULL, 0x0000001015067824ULL, 0x000fe200078e0206ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff117819ULL, 0x000fe40000011603ULL,
0x0000000fff0b723eULL, 0x000fc600000000ffULL, 0x0000000811157836ULL, 0x000fe20000000000ULL,
0x000054100b0e7816ULL, 0x000fca000000000bULL, 0x00001f110e0c7589ULL, 0x0002a800000e0000ULL,
0x00001f150e0b7589ULL, 0x0002e400000e0000ULL, 0x012800000618783bULL, 0x0002e20000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000c18187232ULL, 0x08cfe40000000000ULL,
0x0000000c1a1a7232ULL, 0x000fe40000000000ULL, 0x0000000b19197232ULL, 0x080fe40000000000ULL,
0x0000000b1b1b7232ULL, 0x000fce0000000000ULL, 0x0000000110067824ULL, 0x042fe200078e0209ULL,
0x00000000043c783bULL, 0x000e620000004200ULL, 0x0000000810117824ULL, 0x000fca00078e00ffULL,
0xfffffff811067812ULL, 0x000fe200078ee206ULL, 0x000000034c117836ULL, 0x000fc80000000000ULL,
0x0000001006067824ULL, 0x000fe200078e0205ULL, 0x0000000811117c11ULL, 0x000fc8000f8e58ffULL,
0x000000000640783bULL, 0x000f220000004200ULL, 0x0000001000117824ULL, 0x000fe200078e0211ULL,
0x00000018ff157819ULL, 0x002fe4000001163eULL, 0x00000010ff007819ULL, 0x000fe4000001163cULL,
0x00000010ff557819ULL, 0x000fe4000001163dULL, 0x00000010ff5a7819ULL, 0x000fe4000001163fULL,
0x000000ff3f4a7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff457819ULL, 0x000fe4000001163fULL,
0x0000ffff3f057812ULL, 0x000fe400078ec0ffULL, 0x000000ff3d107812ULL, 0x000fe400078ec0ffULL,
0x00000018ff177819ULL, 0x010fe40000011640ULL, 0x000000ff40547812ULL, 0x000fe400078ec0ffULL,
0x00000018ff577819ULL, 0x000fc40000011641ULL, 0x00000018ff4e7819ULL, 0x000fe4000001163dULL,
0x0000ffff3d5f7812ULL, 0x000fe400078ec0ffULL, 0x00000015ff3f723eULL, 0x000fe400020006ffULL,
0x00000010ff047819ULL, 0x000fe40000011640ULL, 0x0000ffff403d7812ULL, 0x000fe400078ec0ffULL,
0x00000017ff15723eULL, 0x000fc400020006ffULL, 0x00000054ff40723eULL, 0x000fe400020006ffULL,
0x00000057ff17723eULL, 0x000fe400020006ffULL, 0x000000ff3c0e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff00547812ULL, 0x000fe400078ec0ffULL, 0x000000ff55577812ULL, 0x000fe400078ec0ffULL,
0x000000ff425c7812ULL, 0x000fc400078ec0ffULL, 0x000000ff435d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff41587812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3c5e7812ULL, 0x000fe400078ec0ffULL,
0x0000000eff53723eULL, 0x000fe400020006ffULL, 0x00000010ff56723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fc400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000010ff597819ULL, 0x000fe4000001163eULL, 0x000000ff3e477812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3e607812ULL, 0x000fe400078ec0ffULL, 0x00000010ff467819ULL, 0x000fe40000011641ULL,
0x0000ffff413e7812ULL, 0x000fc400078ec0ffULL, 0x0000005cff0e723eULL, 0x000fe400020006ffULL,
0x0000005dff10723eULL, 0x000fe400020006ffULL, 0x00000058ff41723eULL, 0x000fe400020006ffULL,
0x00000008ff5c7819ULL, 0x000fe40000011605ULL, 0x000000ff045d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff527819ULL, 0x000fc4000001163cULL, 0x00000008ff557819ULL, 0x000fe4000001165eULL,
0x00000008ff587819ULL, 0x000fe4000001165fULL, 0x0000541053047816ULL, 0x000fe40000000054ULL,
0x0000541056057816ULL, 0x000fe40000000057ULL, 0x00000018ff5b7819ULL, 0x000fe40000011642ULL,
0x00000052ff52723eULL, 0x000fc400020006ffULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x000000041838723cULL, 0x008fe20000001838ULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x0000005bff00723eULL, 0x000fe400020006ffULL,
0x000000ff59597812ULL, 0x000fe400078ec0ffULL, 0x000000ff5a5b7812ULL, 0x000fc400078ec0ffULL,
0x0000541055047816ULL, 0x000fe40000000052ULL, 0x0000541058057816ULL, 0x000fe4000000004eULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x000000041834723cULL, 0x000fe20000001834ULL,
0x0000005bff5b723eULL, 0x000fc400020006ffULL, 0x00000008ff5a7819ULL, 0x000fe40000011660ULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x0000541047047816ULL, 0x000fe40000000059ULL,
0x000054104a057816ULL, 0x000fe4000000005bULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x00000010ff3c7819ULL, 0x000fe20000011642ULL,
0x000000041830723cULL, 0x000fe20000001830ULL, 0x00000010ff147819ULL, 0x100fe40000011643ULL,
0x00000018ff067819ULL, 0x000fe40000011643ULL, 0x0000ffff42427812ULL, 0x000fe400078ec0ffULL,
0x0000ffff43437812ULL, 0x000fe400078ec0ffULL, 0x000054105a047816ULL, 0x000fc4000000003fULL,
0x000054105c057816ULL, 0x000fe40000000045ULL, 0x000000ff46467812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3d7819ULL, 0x000fe4000001163dULL, 0x00000008ff3e7819ULL, 0x000fe2000001163eULL,
0x00000004182c723cULL, 0x000fe2000000182cULL, 0x000000ff3c3c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff14147812ULL, 0x000fc400078ec0ffULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000008ff437819ULL, 0x000fe40000011643ULL, 0x00000046ff4e723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000003dff46723eULL, 0x000fe400020006ffULL,
0x0000003eff47723eULL, 0x000fc400020006ffULL, 0x0000003cff04723eULL, 0x000fe400020006ffULL,
0x00000014ff05723eULL, 0x000fe200020006ffULL, 0x01100000113c783bULL, 0x0002e20000000200ULL,
0x00000006ff06723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x0000541040407816ULL, 0x000fc4000000005dULL,
0x0000541041417816ULL, 0x000fe4000000004eULL, 0x0000541046467816ULL, 0x000fe40000000015ULL,
0x0000541047477816ULL, 0x000fe40000000017ULL, 0x000054100e047816ULL, 0x000fe20000000004ULL,
0x000000401828723cULL, 0x000fe20000001828ULL, 0x0000541010057816ULL, 0x000fe40000000005ULL,
0x0000541042427816ULL, 0x000fc40000000000ULL, 0x0000541043437816ULL, 0x000fe20000000006ULL,
0x000000461824723cULL, 0x000fec0000001824ULL, 0x000000041820723cULL, 0x000fec0000001820ULL,
0x00000042181c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000100947ULL, 0x002fde0003800000ULL, 0x0000000c3c3c7232ULL, 0x08cfe40000000000ULL,
0x0000000c3e3e7232ULL, 0x000fe40000000000ULL, 0x0000000b3d3d7232ULL, 0x080fe40000000000ULL,
0x0000000b3f3f7232ULL, 0x000fce0000000000ULL, 0x0001400048487836ULL, 0x000fe40000000000ULL,
0x000000010a097824ULL, 0x040fe400078e0209ULL, 0x000000080a0a7824ULL, 0x000fe400078e00ffULL,
0x0000001044187824ULL, 0x000fe400078e0248ULL, 0x0000000113137836ULL, 0x000fe20000000000ULL,
0xfffffff80a097812ULL, 0x000fc600078ee209ULL, 0x000000001818783bULL, 0x000e640000004200ULL,
0x0000001009097824ULL, 0x000fca00078e0248ULL, 0x000000000940783bULL, 0x000f220000004200ULL,
0x000000ff190e7812ULL, 0x042fe400078ec0ffULL, 0x00000010ff007819ULL, 0x000fe40000011618ULL,
0x00000010ff067819ULL, 0x000fe40000011619ULL, 0x0000ffff18107812ULL, 0x000fe400078ec0ffULL,
0x00000010ff157819ULL, 0x000fe4000001161aULL, 0x0000ffff19457812ULL, 0x000fc400078ec0ffULL,
0x0000ffff1a467812ULL, 0x000fe400078ec0ffULL, 0x0000000eff52723eULL, 0x000fe400020006ffULL,
0x000000ff18057812ULL, 0x000fe400078ec0ffULL, 0x0000ffff1b557812ULL, 0x000fe400078ec0ffULL,
0x000000ff00007812ULL, 0x000fe400078ec0ffULL, 0x000000ff060e7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff067819ULL, 0x000fe40000011610ULL, 0x000000ff15157812ULL, 0x000fe400078ec0ffULL,
0x00000018ff577819ULL, 0x110fe40000011640ULL, 0x00000008ff107819ULL, 0x000fe40000011645ULL,
0x00000010ff047819ULL, 0x000fe40000011640ULL, 0x00000008ff457819ULL, 0x000fc40000011646ULL,
0x00000005ff05723eULL, 0x000fe400020006ffULL, 0x00000000ff4a723eULL, 0x000fe400020006ffULL,
0x00000008ff467819ULL, 0x000fe40000011655ULL, 0x0000000eff53723eULL, 0x000fe400020006ffULL,
0x00000015ff55723eULL, 0x000fe400020006ffULL, 0x00000057ff15723eULL, 0x000fc400020006ffULL,
0x000000ff04577812ULL, 0x000fe400078ec0ffULL, 0x0000541005047816ULL, 0x000fe4000000004aULL,
0x00000018ff477819ULL, 0x000fe40000011618ULL, 0x00000018ff487819ULL, 0x000fe40000011619ULL,
0x0000541052057816ULL, 0x000fe40000000053ULL, 0x00000010ff197819ULL, 0x000fc4000001161bULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x000000043c38723cULL, 0x008fe20000001838ULL, 0x00000006ff4e723eULL, 0x000fe400020006ffULL,
0x00000010ff54723eULL, 0x000fe400020006ffULL, 0x000000ff1a187812ULL, 0x000fe400078ec0ffULL,
0x000000ff1b177812ULL, 0x000fc400078ec0ffULL, 0x000000ff19197812ULL, 0x000fe400078ec0ffULL,
0x000054104e047816ULL, 0x000fe40000000047ULL, 0x0000541054057816ULL, 0x000fe40000000048ULL,
0x00000018ff18723eULL, 0x000fe400020006ffULL, 0x00000017ff17723eULL, 0x000fe400020006ffULL,
0x00000019ff56723eULL, 0x000fe200020006ffULL, 0x000000043c34723cULL, 0x000fe20000001834ULL,
0x00000018ff117819ULL, 0x000fc4000001161aULL, 0x00000018ff147819ULL, 0x000fe4000001161bULL,
0x00000010ff1a7819ULL, 0x000fe40000011641ULL, 0x0000541018047816ULL, 0x000fe40000000055ULL,
0x0000541017057816ULL, 0x000fe40000000056ULL, 0x00000011ff11723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fc400020006ffULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x000000043c30723cULL, 0x000fe20000001830ULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x000000ff401b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff41447812ULL, 0x000fe400078ec0ffULL,
0x000000ff1a1a7812ULL, 0x000fe400078ec0ffULL, 0x0000541045047816ULL, 0x000fe20000000011ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x0000541046057816ULL, 0x000fc40000000014ULL,
0x0000001bff1b723eULL, 0x000fe400020006ffULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x000000043c2c723cULL, 0x000fe2000000182cULL,
0x0000001aff1a723eULL, 0x000fe400020006ffULL, 0x0000ffff40407812ULL, 0x000fe400078ec0ffULL,
0x00000018ff587819ULL, 0x000fc40000011641ULL, 0x000054101b047816ULL, 0x000fe40000000057ULL,
0x0000541044057816ULL, 0x000fe4000000001aULL, 0x00000010ff097819ULL, 0x100fe40000011642ULL,
0x000000ff425a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff597819ULL, 0x000fe20000011642ULL,
0x000000043c28723cULL, 0x000fe20000001828ULL, 0x00000010ff0a7819ULL, 0x000fe20000011643ULL,
0x00000011120479a7ULL, 0x000e62000850003fULL, 0x000000ff435c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fe40000011643ULL, 0x0000ffff41417812ULL, 0x000fe400078ec0ffULL,
0x0000ffff42427812ULL, 0x000fe400078ec0ffULL, 0x0000ffff43437812ULL, 0x000fe400078ec0ffULL,
0x00000008ff407819ULL, 0x000fe40000011640ULL, 0x00000008ff417819ULL, 0x000fc40000011641ULL,
0x000000ff09097812ULL, 0x000fe400078ec0ffULL, 0x000000ff0a0a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff427819ULL, 0x000fe40000011642ULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000058ff19723eULL, 0x000fc400020006ffULL,
0x0000005aff0e723eULL, 0x000fe400020006ffULL, 0x0000005cff10723eULL, 0x000fe400020006ffULL,
0x00000059ff00723eULL, 0x000fe400020006ffULL, 0x0000005bff06723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000009ff09723eULL, 0x000fc400020006ffULL,
0x0000000aff0a723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x0000541040407816ULL, 0x000fe40000000015ULL,
0x0000541041417816ULL, 0x000fe40000000019ULL, 0x000054100e147816ULL, 0x000fc40000000009ULL,
0x0000541010157816ULL, 0x000fe4000000000aULL, 0x0000541042427816ULL, 0x000fe20000000000ULL,
0x000000403c24723cULL, 0x000fe20000001824ULL, 0x0000541043437816ULL, 0x000fe20000000006ULL,
0x000000ffff007224ULL, 0x002fe200078e0005ULL, 0x000000084c047c11ULL, 0x000fc6000f8e18ffULL,
0x000000143c20723cULL, 0x000fe20000001820ULL, 0x0176a01104ff79a7ULL, 0x0003ea000850003fULL,
0x000000423c1c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffff7400109947ULL, 0x000fde000383ffffULL, 0x000000ff7b00720cULL, 0x000fda0003f05270ULL,
0x0000000000d48947ULL, 0x000fea0003800000ULL, 0x0180000008007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000a82000047802ULL, 0x002fce0000000f00ULL, 0x00000080008c7944ULL, 0x004fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000000800037308ULL, 0x000ee40000001000ULL,
0xbf80000003007423ULL, 0x008fc80000000008ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009800ff027b82ULL, 0x000f240000000a00ULL, 0x0000000602037981ULL, 0x010f22000c1e9900ULL,
0x0000000000057919ULL, 0x002e640000000000ULL, 0x00000002ff077819ULL, 0x006fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x018fca0000410000ULL,
0x00001f0700047589ULL, 0x000e6800000e0000ULL, 0x00001f0500057589ULL, 0x000ea200000e0000ULL,
0x0000003804387220ULL, 0x042fe20000410000ULL, 0x0000003904397220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x000fe20000410000ULL,
0x0000003a053a7220ULL, 0x044fe20000410000ULL, 0x0000003b053b7220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x000000242524723eULL, 0x000fe400000000ffULL,
0x000000202120723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000323332723eULL, 0x000fc400000000ffULL, 0x0000002e2f19723eULL, 0x000fe400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x0000541032187816ULL, 0x140fe40000000019ULL,
0x0000763232197816ULL, 0x000fe40000000019ULL, 0x000000262715723eULL, 0x000fe400000000ffULL,
0x000000222322723eULL, 0x000fc400000000ffULL, 0x000000ff4d00720cULL, 0x000fe40003f05270ULL,
0x00000002ff057819ULL, 0x10afe20000011600ULL, 0x0000000151517824ULL, 0x000fe200078e0200ULL,
0x0000000200027812ULL, 0x040fe400078ec0ffULL, 0x0000000800077811ULL, 0x004fe200078ff0ffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x040fe400078ff8ffULL,
0x0000000702047211ULL, 0x000fe200078ff8ffULL, 0x0000000807097824ULL, 0x000fc400078e00ffULL,
0x0000000805077824ULL, 0x040fe400078e00ffULL, 0x0000000203027836ULL, 0x000fe20000000000ULL,
0xfffffff8090e7812ULL, 0x000fe200078ee204ULL, 0x0000000805047824ULL, 0x040fe400078e00ffULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0xfffffff807087812ULL, 0x000fe200078ee202ULL,
0x0000000403067836ULL, 0x000fe20000000000ULL, 0x0000000849027c11ULL, 0x000fe2000f8e60ffULL,
0x0000000603077836ULL, 0x000fe20000000000ULL, 0xfffffff804047812ULL, 0x000fe200078ee203ULL,
0x0000000800057824ULL, 0x000fe200078e00ffULL, 0xfffffff8090a7812ULL, 0x000fe200078ee206ULL,
0x000008004d037824ULL, 0x100fe200078e0202ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x0000001051517824ULL, 0x000fe200078e0202ULL, 0x0000000805067812ULL, 0x000fe200078ec0ffULL,
0x0000001004057824ULL, 0x100fe200078e0203ULL, 0x000000343504723eULL, 0x000fe200000000ffULL,
0x000000100e0f7824ULL, 0x000fc400078e0203ULL, 0x0000001008097824ULL, 0x000fe200078e0203ULL,
0x000054102a087816ULL, 0x000fe20000000015ULL, 0x000000100a0b7824ULL, 0x100fe400078e0203ULL,
0x000000100c0d7824ULL, 0x000fe200078e0203ULL, 0x000000383903723eULL, 0x000fe200000000ffULL,
0x0000000105077824ULL, 0x000fe200078e0206ULL, 0x000000282905723eULL, 0x000fe200000000ffULL,
0x00000001060f7824ULL, 0x040fe200078e020fULL, 0x0000541003107816ULL, 0x140fe20000000004ULL,
0x0000000106097824ULL, 0x040fe200078e0209ULL, 0x0000763203117816ULL, 0x000fe20000000004ULL,
0x00000001060b7824ULL, 0x040fe200078e020bULL, 0x000000303103723eULL, 0x000fe200000000ffULL,
0x00000001060d7824ULL, 0x000fe200078e020dULL, 0x0000002c2d04723eULL, 0x000fe200000000ffULL,
0x0000001007007388ULL, 0x0003e60000000a00ULL, 0x0000541003067816ULL, 0x000fc40000000004ULL,
0x0000763203077816ULL, 0x002fe40000000004ULL, 0x0000001c1d10723eULL, 0x000fe400000000ffULL,
0x0000003a3b03723eULL, 0x000fe200000000ffULL, 0x0000000609007388ULL, 0x0003e20000000a00ULL,
0x000000363704723eULL, 0x000fe400000000ffULL, 0x0000001e1f11723eULL, 0x000fc800000000ffULL,
0x00005410220a7816ULL, 0x000fe40000000011ULL, 0x0000541005067816ULL, 0x142fe40000000024ULL,
0x0000763205077816ULL, 0x000fca0000000024ULL, 0x000000060b007388ULL, 0x0003e40000000a00ULL,
0x0000541020067816ULL, 0x142fe40000000010ULL, 0x0000763220077816ULL, 0x000fca0000000010ULL,
0x000000060d007388ULL, 0x0003e40000000a00ULL, 0x0000541003067816ULL, 0x142fe40000000004ULL,
0x0000763203077816ULL, 0x000fca0000000004ULL, 0x000000060f007388ULL, 0x000fe80000000a00ULL,
0x0004001809007388ULL, 0x0003e40000000a00ULL, 0x000076322a097816ULL, 0x002fca0000000015ULL,
0x000400080b007388ULL, 0x0003e40000000a00ULL, 0x00007632220b7816ULL, 0x002fca0000000011ULL,
0x0004000a0d007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000051047984ULL, 0x000e680000000c00ULL, 0x0004000051147984ULL, 0x000ea80000000c00ULL,
0x0008000051107984ULL, 0x000ee80000000c00ULL, 0x000c000051187984ULL, 0x000f220000000c00ULL,
0x200000ff07077230ULL, 0x002fc40000000000ULL, 0x200000ff06067230ULL, 0x000fe40000000000ULL,
0x200000ff05057230ULL, 0x000fe40000000000ULL, 0x200000ff04047230ULL, 0x000fe40000000000ULL,
0x200000ff17177230ULL, 0x004fe40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fc40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x0000001307077230ULL, 0x008fe40000000000ULL, 0x0000001206067230ULL, 0x000fe40000000000ULL,
0x0000001105057230ULL, 0x000fe40000000000ULL, 0x0000001004047230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x010fc40000000000ULL, 0x0000001a16167230ULL, 0x000fe20000000000ULL,
0x0000000451007388ULL, 0x0003e20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fca0000000000ULL, 0x0004001451007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff067819ULL, 0x002fc80000011600ULL, 0x0000004f0600720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000400013c7983ULL, 0x000ea20000100800ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x0000000800087d06ULL, 0x000e620008209000ULL, 0x00000008ff0d7c12ULL, 0x000fe2000f8e33ffULL,
0x0000850000097ab9ULL, 0x000fe20000000800ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000007000e7812ULL, 0x000fc800078ec0ffULL, 0x0000000800087308ULL, 0x002e640000001000ULL,
0x0ffffffe08097836ULL, 0x002fcc0000000000ULL, 0x0000000900057305ULL, 0x000e64000021f000ULL,
0x000000ffff037224ULL, 0x002fc800078e0a05ULL, 0x0000000803037c24ULL, 0x000fc8000f8e02ffULL,
0x0000000305107227ULL, 0x000fc800078e0004ULL, 0x000000013c037824ULL, 0x004fc800078e0206ULL,
0x0000000310077227ULL, 0x000fc800078e00ffULL, 0x000000ffff047224ULL, 0x000fc800078e0a07ULL,
0x0000000804057c24ULL, 0x000fe4000f8e0203ULL, 0x0000000106047824ULL, 0x000fc600078e0200ULL,
0x0000000805007c0cULL, 0x000fda000bf06070ULL, 0x8000000805050c36ULL, 0x000fe40008000000ULL,
0x0000000107070836ULL, 0x000fe20000000000ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x0000000805007c0cULL, 0x000fe4000bf26070ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805057812ULL, 0x000fca00078ef800ULL, 0x0000001005067824ULL, 0x000fe400078e0202ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x0000000006087984ULL, 0x0002a40000000c00ULL,
0x000000070d047207ULL, 0x000fca0004000000ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000000904047c24ULL, 0x000fe4000f8e027dULL, 0x000000080c037c24ULL, 0x000fe4000f8e0203ULL,
0x0000002000067836ULL, 0x002fe40000000000ULL, 0x0000000804037c24ULL, 0x000fc6000f8e0203ULL,
0x00000003ff077819ULL, 0x000fe40000011606ULL, 0x0000000350037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x0000000403047c11ULL, 0x000fc8000f8240ffULL,
0x0000000503057c11ULL, 0x000fe200088f440cULL, 0x0000000849037824ULL, 0x000fe200078e020eULL,
0x0000004f0700720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000013c037824ULL, 0x100fe400078e0207ULL, 0x0000000106077824ULL, 0x000fe400078e0207ULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000707077812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc600078e0a04ULL, 0x0ffffff807077812ULL, 0x000fe200078ef806ULL,
0x0000000808057c24ULL, 0x000fe2000f8e0203ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001007077824ULL, 0x000fe200078e0202ULL, 0x0000000805007c0cULL, 0x000fc8000bf26070ULL,
0x0000000007087984ULL, 0x0002a40000000c00ULL, 0x0000004000077836ULL, 0x002fce0000000000ULL,
0x8000000805051c36ULL, 0x000fe40008000000ULL, 0x0000000104041836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fda000bf46070ULL, 0x0000000104042836ULL, 0x000fca0000000000ULL,
0x000000040d047207ULL, 0x000fca0004000000ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000000904047c24ULL, 0x000fe4000f8e027dULL, 0x000000080c037c24ULL, 0x000fc8000f8e0203ULL,
0x0000000804037c24ULL, 0x000fca000f8e0203ULL, 0x0000000350037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x0000000403047c11ULL, 0x000fc8000f8240ffULL,
0x0000000503057c11ULL, 0x000fe200088f440cULL, 0x0000000849037824ULL, 0x000fe200078e0206ULL,
0x00000003ff067819ULL, 0x000fc60000011607ULL, 0x0000001003047825ULL, 0x000fe200078e0004ULL,
0x0000004f0600720cULL, 0x000fc80003f26070ULL, 0x0000000804007986ULL, 0x0043f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000013c037824ULL, 0x100fe400078e0206ULL,
0x0000000107067824ULL, 0x000fe400078e0206ULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fe400078e0a04ULL,
0x0000006000007836ULL, 0x000fe40000000000ULL, 0x0000000808057c24ULL, 0x000fca000f8e0203ULL,
0x0000000805007c0cULL, 0x000fda000bf26070ULL, 0x8000000805051c36ULL, 0x000fe40008000000ULL,
0x0000000104041836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef807ULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042836ULL, 0x000fca0000000000ULL,
0x000000040d047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc60000011600ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000000904047c24ULL, 0x000fe4000f8e027dULL,
0x000000080c037c24ULL, 0x000fe2000f8e0203ULL, 0x00000007070c7812ULL, 0x000fe200078ec0ffULL,
0x000000013c077824ULL, 0x000fe400078e0206ULL, 0x0000000804037c24ULL, 0x000fca000f8e0203ULL,
0x0000000350037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x0000000403047c11ULL, 0x000fc8000f8240ffULL, 0x0000000503057c11ULL, 0x000fe200088f440eULL,
0x0000000849037824ULL, 0x000fe200078e020cULL, 0x0000004f0600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000710057227ULL, 0x002fc800078e00ffULL,
0x000000ffff047224ULL, 0x000fe400078e0a05ULL, 0x0000000100067824ULL, 0x000fe400078e0206ULL,
0x0000000804037c24ULL, 0x000fca000f8e0207ULL, 0x0000000803007c0cULL, 0x000fda000bf26070ULL,
0x8000000803031c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000803007c0cULL, 0x000fe4000bf46070ULL, 0x0000000706037812ULL, 0x000fc800078ec0ffULL,
0xfffffff803037812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001003047824ULL, 0x000fe400078e0202ULL, 0x0000000105052836ULL, 0x000fe40000000000ULL,
0x0000000849497824ULL, 0x000fe200078e0200ULL, 0x0000000004087984ULL, 0x000e640000000c00ULL,
0x000000050d027207ULL, 0x000fca0004000000ULL, 0x000000ffff067224ULL, 0x000fe400078e0a02ULL,
0x0000000902027c24ULL, 0x000fe4000f8e027dULL, 0x0000000806077c24ULL, 0x000fc8000f8e0207ULL,
0x0000000802077c24ULL, 0x000fca000f8e0207ULL, 0x0000000750077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000000407027c11ULL, 0x000fc8000f8040ffULL,
0x0000000507037c11ULL, 0x000fc600080f4406ULL, 0x0000001049027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00009800ff0c7b82ULL, 0x000e620000000a00ULL, 0x000001ff0b00780cULL, 0x000fe20003f04070ULL,
0x00000002090e7824ULL, 0x000fe200078e00ffULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x00000001ff047424ULL, 0x000fe200078e00ffULL, 0x0000940000057ab9ULL, 0x000fe20000000800ULL,
0x000000060c087981ULL, 0x002322000c1e9900ULL, 0x0000001f04047890ULL, 0x000fe2000fffe03fULL,
0x0000004002097824ULL, 0x000fe400078e00ffULL, 0x01760004ff0479a7ULL, 0x000ea20008500008ULL,
0x0000000a0e7d7224ULL, 0x000fe200078e027dULL, 0x000000053f047899ULL, 0x000fc60008011604ULL,
0x000000057d0a7c24ULL, 0x000fe2000f8e0209ULL, 0x0000000c00240947ULL, 0x000ff00003800000ULL,
0x00000003ff207819ULL, 0x000fe20000011603ULL, 0x00009000000a7ab9ULL, 0x000fe20000000a00ULL,
0x000000097a0c7248ULL, 0x002fc60007fe0000ULL, 0x00000004200e7836ULL, 0x000fe40000000000ULL,
0x0000000820167836ULL, 0x000fe40000000000ULL, 0x000000010e0d7824ULL, 0x040fe400078e0203ULL,
0x000000080e107824ULL, 0x000fe400078e00ffULL, 0x000000010c0b7824ULL, 0x000fe400078e0a09ULL,
0x00000001160f7824ULL, 0x040fe200078e0203ULL, 0xfffffff810217812ULL, 0x000fe200078ee20dULL,
0x0000000816107824ULL, 0x000fe200078e00ffULL, 0x0000000b0e00720cULL, 0x000fe20003fa6070ULL,
0x000000010a0e7824ULL, 0x000fc400078e020eULL, 0x000000010a0c7824ULL, 0x000fe200078e0220ULL,
0xfffffff810257812ULL, 0x000fe200078ee20fULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700e147812ULL, 0x000fc600078ef806ULL,
0x0000001020127836ULL, 0x000fe20000000000ULL, 0x000000700c1a7812ULL, 0x000fe200078ef806ULL,
0x0000000c20187836ULL, 0x000fe20000000000ULL, 0x0000000a14147c10ULL, 0x000fe2000ff3e0ffULL,
0x00000001120c7824ULL, 0x040fe200078e0203ULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000812297824ULL, 0x000fe200078e00ffULL, 0x0000000b0f157c10ULL, 0x000fe20008ffe4ffULL,
0x000000010a0e7824ULL, 0x040fe200078e0218ULL, 0x0000000b0d1b7c10ULL, 0x000fe200087fe4ffULL,
0x0000001820227836ULL, 0x000fe20000000000ULL, 0xfffffff829297812ULL, 0x000fe200078ee20cULL,
0x000000010a0c7824ULL, 0x000fe200078e0216ULL, 0x0000000b1600720cULL, 0x080fe20003f26070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000b1800720cULL, 0x000fc40003f46070ULL,
0x0000000b1200720cULL, 0x000fe20003f06070ULL, 0x0000000118107824ULL, 0x040fe200078e0203ULL,
0x000000700e167812ULL, 0x000fe200078ef806ULL, 0x0000000818277824ULL, 0x000fe400078e00ffULL,
0x000000010a1c7824ULL, 0x000fe200078e0222ULL, 0x0000000a16167c10ULL, 0x000fe2000ff9e0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe400078ee210ULL,
0x0000000b0f177c10ULL, 0x000fe2000a7fe4ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000700c187812ULL, 0x000fc600078ef806ULL, 0x000000010a107824ULL, 0x000fe200078e0212ULL,
0x000000701c0c7812ULL, 0x000fe200078ef806ULL, 0x00000014201e7836ULL, 0x000fe20000000000ULL,
0x0000000a18187c10ULL, 0x000fe2000ff7e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000a0c0c7c10ULL, 0x000fe4000ff9e0ffULL, 0x0000000b0d197c10ULL, 0x000fe20009ffe4ffULL,
0x000000010a127824ULL, 0x000fe200078e021eULL, 0x0000007010107812ULL, 0x000fe200078ef806ULL,
0x0000001c20267836ULL, 0x000fe20000000000ULL, 0x0000000b1d0d7c10ULL, 0x000fe2000a7fe4ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000a10107c10ULL, 0x000fc4000ff7e0ffULL,
0x00000008021c7c11ULL, 0x000fe2000f8e70ffULL, 0x00000001201d7824ULL, 0x100fe200078e0203ULL,
0x00000070120e7812ULL, 0x000fe200078ef806ULL, 0x000000010a127824ULL, 0x000fe200078e0226ULL,
0x0000000b11117c10ULL, 0x000fe20009ffe4ffULL, 0x000000081e2a7824ULL, 0x040fe200078e00ffULL,
0x000000071d247812ULL, 0x000fe200078ec0ffULL, 0x000000011e1d7824ULL, 0x100fe200078e0203ULL,
0x0000000a0e0e7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000002020287836ULL, 0x000fe20000000000ULL,
0x0000000b2000720cULL, 0x080fe20003f86070ULL, 0x000010001c1c7836ULL, 0x000fe20000000000ULL,
0x0ffffff8241f7812ULL, 0x000fe200078ef803ULL, 0x0000000122247824ULL, 0x000fe200078e0203ULL,
0x0000000b130f7c10ULL, 0x000fe20009ffe4ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000b1e00720cULL, 0x000fc40003f66070ULL, 0xfffffff82a2b7812ULL, 0x000fe200078ee21dULL,
0x000000010a1e7824ULL, 0x000fe200078e0228ULL, 0x0000007012127812ULL, 0x000fe200078ef806ULL,
0x00000024202a7836ULL, 0x000fe40000000000ULL, 0x000000101f1d7824ULL, 0x000fe200078e021cULL,
0x0000000a12127c10ULL, 0x000fe2000ffde0ffULL, 0x000000801e1e7825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a1d7faeULL, 0x0003e2000e101c46ULL,
0x00000008222d7824ULL, 0x040fe200078e00ffULL, 0x0000000b2200720cULL, 0x080fe20003f86070ULL,
0x0000001021217824ULL, 0x000fe200078e021cULL, 0x000000701e1e7812ULL, 0x000fe200078ef806ULL,
0x000000010a237824ULL, 0x000fe200078e022aULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee224ULL,
0x00000028202c7836ULL, 0x000fe20000000000ULL, 0x0000000014217faeULL, 0x0007e2000e901c46ULL,
0x0000008023227825ULL, 0x000fe200078e00ffULL, 0x0000000b2600720cULL, 0x000fc40003fa6070ULL,
0x0000000b13137c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001025257824ULL, 0x000fe200078e021cULL,
0x0000000a1e1e7c10ULL, 0x000fe2000ffde0ffULL, 0x000000010a2e7824ULL, 0x000fe200078e022cULL,
0x0000007022227812ULL, 0x000fe200078ef806ULL, 0x00000001261d7824ULL, 0x042fe200078e0203ULL,
0x0000000018257faeULL, 0x000fe2000c901c46ULL, 0x0000000826247824ULL, 0x000fe200078e00ffULL,
0x0000000b1f1f7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001027277824ULL, 0x000fe200078e021cULL,
0x0000000a22227c10ULL, 0x000fe2000ffde0ffULL, 0x0000002c20267836ULL, 0x000fe20000000000ULL,
0xfffffff8241d7812ULL, 0x000fe200078ee21dULL, 0x000000802e1a7825ULL, 0x000fe200078e00ffULL,
0x0000000016277faeULL, 0x0003e2000d101c46ULL, 0x0000000b2800720cULL, 0x000fc40003f26070ULL,
0x0000001029297824ULL, 0x000fe200078e021cULL, 0x000000701a1a7812ULL, 0x000fe200078ef806ULL,
0x000000010a147824ULL, 0x008fe200078e0226ULL, 0x0000000b23237c10ULL, 0x000fe2000b7fe4ffULL,
0x000000102b2b7824ULL, 0x100fe200078e021cULL, 0x0000000010297faeULL, 0x0007e2000c101c46ULL,
0x000000102d2d7824ULL, 0x000fe200078e021cULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ffde0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000000e2b7faeULL, 0x000fe2000d901c46ULL,
0x0000000b2a00720cULL, 0x000fc40003f46070ULL, 0x0000003020167836ULL, 0x006fe20000000000ULL,
0x000000000c2d7faeULL, 0x0003e2000e101c46ULL, 0x0000000128217824ULL, 0x140fe200078e0203ULL,
0x0000007014147812ULL, 0x000fe200078ef806ULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0x0000000b1b1b7c10ULL, 0x000fe2000b7fe4ffULL, 0x000000010a107824ULL, 0x008fe200078e0216ULL,
0x0000000a14147c10ULL, 0x000fe2000ffde0ffULL, 0x000000012a247824ULL, 0x040fe200078e0203ULL,
0xfffffff828217812ULL, 0x000fe200078ee221ULL, 0x000000082a2f7824ULL, 0x000fe200078e00ffULL,
0x0000000b15157c10ULL, 0x000fe2000b7fe4ffULL, 0x000000101d1d7824ULL, 0x000fe200078e021cULL,
0x0000000b2600720cULL, 0x000fe20003f86070ULL, 0x00000080100c7825ULL, 0x002fe200078e00ffULL,
0xfffffff82f177812ULL, 0x000fc400078ee224ULL, 0x00000000121d7faeULL, 0x0003e2000e901c46ULL,
0x0000003420187836ULL, 0x000fe20000000000ULL, 0x000000700c107812ULL, 0x000fe200078ef806ULL,
0x000000012c117824ULL, 0x140fe200078e0203ULL, 0x0000000b2c00720cULL, 0x0c0fe20003fa6070ULL,
0x000000082c2c7824ULL, 0x000fe200078e00ffULL, 0x0000000a10107c10ULL, 0x000fe2000ffde0ffULL,
0x0000001021217824ULL, 0x100fe200078e021cULL, 0x0000000b1600720cULL, 0x080fe20003f66070ULL,
0x0000001017177824ULL, 0x000fe400078e021cULL, 0x0000003820247836ULL, 0x000fe20000000000ULL,
0xfffffff82c137812ULL, 0x002fe200078ee211ULL, 0x000000010a0e7824ULL, 0x000fe200078e0218ULL,
0x000000001e217faeULL, 0x000fe2000c901c46ULL, 0x0000003c20207836ULL, 0x000fe20000000000ULL,
0x0000000b0d117c10ULL, 0x000fe2000b7fe4ffULL, 0x00000001160c7824ULL, 0x040fe200078e0203ULL,
0x0000000022177faeULL, 0x0003e2000d101c46ULL, 0x0000000816197824ULL, 0x000fe200078e00ffULL,
0x0000000b1800720cULL, 0x080fe20003f46070ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000b2400720cULL, 0x000fc40003f26070ULL, 0x0000000b2000720cULL, 0x000fe20003f06070ULL,
0x000000010a0d7824ULL, 0x000fe200078e0224ULL, 0xfffffff819197812ULL, 0x000fe200078ee20cULL,
0x00000001260b7824ULL, 0x140fe200078e0203ULL, 0x000000700e0e7812ULL, 0x000fe200078ef806ULL,
0x0000000826267824ULL, 0x000fe400078e00ffULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x0000000a0e0e7c10ULL, 0x000fe4000ffde0ffULL, 0xfffffff826177812ULL, 0x002fe200078ee20bULL,
0x000000010a0a7824ULL, 0x000fe200078e0220ULL, 0x000000700c0c7812ULL, 0x000fe200078ef806ULL,
0x0000000118127824ULL, 0x000fe200078e0203ULL, 0x0000000b0f0f7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000000a0c0c7c10ULL, 0x000fc6000ffde0ffULL,
0x00000008181d7824ULL, 0x000fe200078e00ffULL, 0x000000700a067812ULL, 0x000fe200078ef806ULL,
0x0000000124167824ULL, 0x140fe200078e0203ULL, 0x0000000b0d0d7c10ULL, 0x000fe2000b7fe4ffULL,
0x00000008241f7824ULL, 0x000fe200078e00ffULL, 0x0000000a060a7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000120187824ULL, 0x040fe200078e0203ULL, 0xfffffff81d037812ULL, 0x000fe200078ee212ULL,
0x0000000820217824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1d7812ULL, 0x000fe200078ee216ULL,
0x0000001013137824ULL, 0x100fe200078e021cULL, 0x0000000b0b0b7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001017177824ULL, 0x100fe200078e021cULL, 0xfffffff8211f7812ULL, 0x000fe200078ee218ULL,
0x0000001019197824ULL, 0x100fe200078e021cULL, 0x000000001a137faeULL, 0x0003e2000e901c46ULL,
0x0000001003037824ULL, 0x000fc400078e021cULL, 0x000000101d1d7824ULL, 0x100fe200078e021cULL,
0x0000000014177faeULL, 0x0003e2000e101c46ULL, 0x000000101f1f7824ULL, 0x000fc600078e021cULL,
0x0000000010197faeULL, 0x0003e8000d901c46ULL, 0x000000000e037faeULL, 0x0003e8000d101c46ULL,
0x000000000c1d7faeULL, 0x0003e8000c901c46ULL, 0x000000000a1f7faeULL, 0x0003e2000c101c46ULL,
0x0000000800d47947ULL, 0x000fea0003800000ULL, 0x00000004030d7811ULL, 0x042fe200078fe8ffULL,
0x00009000000a7ab9ULL, 0x000fe20000000a00ULL, 0x0000001403137811ULL, 0x040fe400078fe8ffULL,
0x0000000c030f7811ULL, 0x000fe200078fe8ffULL, 0x000000010d0b7824ULL, 0x100fe200078e0203ULL,
0x00000008030e7811ULL, 0x000fe200078fe8ffULL, 0x000000080d0c7824ULL, 0x000fe200078e00ffULL,
0x00000024031a7811ULL, 0x000fe200078fe8ffULL, 0x0000000113127824ULL, 0x100fe200078e0203ULL,
0x0000001003107811ULL, 0x000fe200078fe8ffULL, 0x0000000813237824ULL, 0x000fe200078e00ffULL,
0xfffffff80c197812ULL, 0x000fe200078ee20bULL, 0x000000010f0c7824ULL, 0x100fe200078e0203ULL,
0x0000001c03177811ULL, 0x000fe200078fe8ffULL, 0x000000080f1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee212ULL, 0x000000010e0b7824ULL, 0x140fe200078e0203ULL,
0x0000001803157811ULL, 0x040fe200078fe8ffULL, 0x000000080e147824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee20cULL, 0x000000011a127824ULL, 0x140fe200078e0203ULL,
0x0000002003187811ULL, 0x040fe200078fe8ffULL, 0x000000081a1d7824ULL, 0x000fe200078e00ffULL,
0x0000002c031e7811ULL, 0x000fe200078fe8ffULL, 0x0000000110117824ULL, 0x140fe200078e0203ULL,
0xfffffff8141b7812ULL, 0x000fe200078ee20bULL, 0x0000000810167824ULL, 0x000fe200078e00ffULL,
0xfffffff81d227812ULL, 0x000fe200078ee212ULL, 0x00000001170c7824ULL, 0x100fe200078e0203ULL,
0x00000028031d7811ULL, 0x000fe200078fe8ffULL, 0x0000000817277824ULL, 0x000fe200078e00ffULL,
0xfffffff816217812ULL, 0x000fe200078ee211ULL, 0x00000001150b7824ULL, 0x100fe200078e0203ULL,
0x0000003003247811ULL, 0x000fe200078fe8ffULL, 0x0000000815147824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee20cULL, 0x0000000118117824ULL, 0x140fe200078e0203ULL,
0x00000034032d7811ULL, 0x040fe200078fe8ffULL, 0x0000000818207824ULL, 0x000fe200078e00ffULL,
0xfffffff814257812ULL, 0x000fe200078ee20bULL, 0x000000011e0c7824ULL, 0x140fe200078e0203ULL,
0x0000003803307811ULL, 0x000fe200078fe8ffULL, 0x000000081e297824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee211ULL, 0x000000011d0b7824ULL, 0x100fe200078e0203ULL,
0x0000003c03317811ULL, 0x000fe200078fe8ffULL, 0x000000081d267824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee20cULL, 0x0000000124117824ULL, 0x140fe200078e0203ULL,
0x00000003030c7211ULL, 0x000fe200078fe8ffULL, 0x0000000824147824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee20bULL, 0x000000012d127824ULL, 0x000fe200078e0203ULL,
0x0000000a030b7211ULL, 0x000fe200078fe8ffULL, 0x000000082d2f7824ULL, 0x000fe200078e00ffULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000010a2a7824ULL, 0x040fe200078e021aULL,
0xfffffff8142b7812ULL, 0x000fe200078ee211ULL, 0x000000010a117824ULL, 0x040fe200078e020fULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee212ULL, 0x000000010a127824ULL, 0x040fe200078e0210ULL,
0x0ffffff80c107812ULL, 0x000fe200078ef803ULL, 0x000000010a287824ULL, 0x000fe200078e0218ULL,
0x00000008020c7c11ULL, 0x000fe2000f8e70ffULL, 0x000000010a2e7824ULL, 0x000fc400078e021eULL,
0x000000010a1a7824ULL, 0x000fe400078e0230ULL, 0x00000001300f7824ULL, 0x000fe400078e0203ULL,
0x000000010a0d7824ULL, 0x040fe400078e020dULL, 0x000000010a0e7824ULL, 0x040fe400078e020eULL,
0x000000010a147824ULL, 0x040fe400078e0213ULL, 0x000000010a167824ULL, 0x000fc400078e0215ULL,
0x000000010a1c7824ULL, 0x040fe400078e0217ULL, 0x000000010a2c7824ULL, 0x040fe400078e021dULL,
0x000000010a247824ULL, 0x040fe400078e0224ULL, 0x000000010a1e7824ULL, 0x000fe400078e022dULL,
0x0000000830307824ULL, 0x000fe400078e00ffULL, 0x000000010a187824ULL, 0x000fc400078e0231ULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff830137812ULL, 0x000fc600078ee20fULL,
0x0000000131037824ULL, 0x040fe200078e0203ULL, 0x000000700a0a7812ULL, 0x000fe200078ef806ULL,
0x0000000831327824ULL, 0x000fe400078e00ffULL, 0x000010000c307836ULL, 0x000fe20000000000ULL,
0x0000000a0a0a7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff832157812ULL, 0x000fe400078ee203ULL, 0x0000000b0b0b7c10ULL, 0x000fe200087fe4ffULL,
0x0000001010037824ULL, 0x000fe200078e0230ULL, 0x000000700e0e7812ULL, 0x000fe200078ef806ULL,
0x0000008011107825ULL, 0x000fc600078e00ffULL, 0x0000000a0e0e7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000800d0c7825ULL, 0x000fe200078e00ffULL, 0x0000007010107812ULL, 0x000fe200078ef806ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a037faeULL, 0x0003e2000b901c46ULL,
0x0000000b0f0f7c10ULL, 0x000fe200087fe4ffULL, 0x0000001015417824ULL, 0x100fe200078e0230ULL,
0x000000700c0c7812ULL, 0x000fe200078ef806ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000a10107c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000a0c0c7c10ULL, 0x000fe2000ff3e0ffULL,
0x00000010133f7824ULL, 0x000fe200078e0230ULL, 0x0000007014147812ULL, 0x000fe200078ef806ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000b11117c10ULL, 0x000fc400087fe4ffULL,
0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000007012127812ULL, 0x000fe400078ef806ULL, 0x0000000b0d0d7c10ULL, 0x000fe20008ffe4ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x000000701c1c7812ULL, 0x000fe400078ef806ULL,
0x0000000a12127c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001029397824ULL, 0x100fe200078e0230ULL,
0x0000007016167812ULL, 0x000fe200078ef806ULL, 0x000000102b3b7824ULL, 0x000fe200078e0230ULL,
0x0000000b15157c10ULL, 0x000fe200087fe4ffULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x0000000a1c1c7c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000a16167c10ULL, 0x000fe2000ff5e0ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000007028327812ULL, 0x000fe400078ef806ULL,
0x0000000b13137c10ULL, 0x000fe20008ffe4ffULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x000000702a347812ULL, 0x000fe400078ef806ULL, 0x0000000a32327c10ULL, 0x000fe2000ff3e0ffULL,
0x000000102f3d7824ULL, 0x000fe200078e0230ULL, 0x000000702c367812ULL, 0x000fe200078ef806ULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000000b1d1d7c10ULL, 0x000fc400087fe4ffULL,
0x0000000b17177c10ULL, 0x000fe200097fe4ffULL, 0x0000001019197824ULL, 0x100fe200078e0230ULL,
0x0000000a34347c10ULL, 0x000fe2000ff1e0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0230ULL,
0x0000000a36367c10ULL, 0x000fe2000ff5e0ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0230ULL,
0x0000000b29337c10ULL, 0x000fe20008ffe4ffULL, 0x0000008024287825ULL, 0x000fe200078e00ffULL,
0x000000702e2e7812ULL, 0x000fe200078ef806ULL, 0x000000000c197faeULL, 0x0003e2000b901c46ULL,
0x0000000b2b357c10ULL, 0x000fe200087fe4ffULL, 0x000000801e2a7825ULL, 0x000fe200078e00ffULL,
0x0000000b2d377c10ULL, 0x000fe200097fe4ffULL, 0x000000000e1b7faeULL, 0x0003e2000b901c46ULL,
0x0000000a2e2e7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001021217824ULL, 0x100fe200078e0230ULL,
0x0000007028287812ULL, 0x000fe200078ef806ULL, 0x0000001023237824ULL, 0x100fe200078e0230ULL,
0x000000702a2a7812ULL, 0x000fe200078ef806ULL, 0x0000001025257824ULL, 0x100fe200078e0230ULL,
0x0000000b2f2f7c10ULL, 0x000fe200087fe4ffULL, 0x0000001027277824ULL, 0x100fe200078e0230ULL,
0x0000000a28287c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001020207824ULL, 0x100fe200078e0230ULL,
0x00000000101f7faeULL, 0x0003e2000b901c46ULL, 0x0000001022227824ULL, 0x100fe200078e0230ULL,
0x0000000a2a2a7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001026267824ULL, 0x000fe200078e0230ULL,
0x0000000012217faeULL, 0x0003e2000b901c46ULL, 0x000000801a2c7825ULL, 0x000fe200078e00ffULL,
0x0000000b29297c10ULL, 0x000fc400087fe4ffULL, 0x0000000014237faeULL, 0x0003e2000b901c46ULL,
0x0000008018307825ULL, 0x000fe200078e00ffULL, 0x000000702c2c7812ULL, 0x000fe400078ef806ULL,
0x0000000016257faeULL, 0x0003e2000b901c46ULL, 0x0000000b2b2b7c10ULL, 0x000fe40008ffe4ffULL,
0x0000007030067812ULL, 0x000fe200078ef806ULL, 0x000000001c277faeULL, 0x0003e2000b901c46ULL,
0x0000000a2c2c7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000a06307c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000032207faeULL, 0x0003e2000b901c46ULL, 0x0000000b2d2d7c10ULL, 0x000fc400097fe4ffULL,
0x0000000b31317c10ULL, 0x000fe20009ffe4ffULL, 0x0000000034227faeULL, 0x0003e8000b901c46ULL,
0x0000000036267faeULL, 0x0003e8000b901c46ULL, 0x000000002e397faeULL, 0x0003e8000b901c46ULL,
0x00000000283b7faeULL, 0x0003e8000b901c46ULL, 0x000000002a3d7faeULL, 0x0003e8000b901c46ULL,
0x000000002c3f7faeULL, 0x0003e8000b901c46ULL, 0x0000000030417faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x00000000000a7805ULL, 0x002fce0000015200ULL,
0x01760005ff0075a7ULL, 0x004e620008000148ULL, 0x000000017a037824ULL, 0x000fe400078e0a00ULL,
0x0000000407077c24ULL, 0x000fc6000f8e02ffULL, 0x00000008ff037819ULL, 0x000fca0000011603ULL,
0x0000000301007387ULL, 0x0005e20000100800ULL, 0x00008e00ff427b82ULL, 0x000ee40000000a00ULL,
0x0000000407427825ULL, 0x008fe200078e0042ULL, 0x00000000005c0947ULL, 0x006fec0003800000ULL,
0x000000ffff0c7224ULL, 0x000fce00078e00ffULL, 0x000000100c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x000000060a067210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e0bULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011407ULL, 0x0000000603037211ULL, 0x000fca00078110ffULL,
0x000000ffff067224ULL, 0x000fca00000e0607ULL, 0x0000000203037819ULL, 0x000fc80000001206ULL,
0x000000030000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010c0c7836ULL, 0x000fce0000000000ULL, 0x01760005ff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x00000001ff0a7424ULL, 0x000fe400078e00ffULL, 0x0000002002037824ULL, 0x002fca00078e0203ULL,
0x00000003ff047819ULL, 0x000fc80000011603ULL, 0x1ffffffe04067812ULL, 0x000fe400078ec0ffULL,
0x0000000f03047812ULL, 0x000fc600078ec0ffULL, 0x0000000103067824ULL, 0x000fe400078e0206ULL,
0x0000001004057824ULL, 0x000fe400078e00ffULL, 0x0000000106037836ULL, 0x000fe20000000000ULL,
0x0000000f06067812ULL, 0x000fe200078ec0ffULL, 0x0000001004047824ULL, 0x000fc600078e00ffULL,
0x0000000f03037812ULL, 0x000fe400078ec0ffULL, 0x000000f005067812ULL, 0x000fe400078ee206ULL,
0x000000f004037812ULL, 0x000fe400078ee203ULL, 0x0000000806067c11ULL, 0x000fe4000f8e20ffULL,
0x0000000803037c11ULL, 0x000fc6000f8e20ffULL, 0x0000000006107984ULL, 0x000e680000000c00ULL,
0x00000000030c7984ULL, 0x000ea20000000c00ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fc400078e0013ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff127224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fe200078e000fULL, 0x0000001406007388ULL, 0x0003e80000000c00ULL,
0x0000001003007388ULL, 0x0003e20000000c00ULL, 0x0176000aff0a79a7ULL, 0x000ea40008500008ULL,
0x0000000000047805ULL, 0x000fce0000015200ULL, 0x0176000bff0075a7ULL, 0x004ea40008000148ULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fce00078e00ffULL,
0x000000100c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x002fce0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010c0c7836ULL, 0x000fce0000000000ULL,
0x0176000bff0075a7ULL, 0x000ea40008000148ULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x000000ff7b00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x002e620000000000ULL, 0x0000010009057836ULL, 0x000fe40000000000ULL,
0x3db504f308047820ULL, 0x010fe20000410000ULL, 0x0000000802057c11ULL, 0x040fe2000f8e18ffULL,
0xffffffff00697836ULL, 0x000fe20000000000ULL, 0x0000000802797c11ULL, 0x000fe2000f8e28ffULL,
0x0000000900777836ULL, 0x000fe20000000000ULL, 0x0000000104057899ULL, 0x000fe2000800063fULL,
0x000000ffff6f7224ULL, 0x000fe400078e00ffULL, 0x000000ffff0c7224ULL, 0x000fd200078e00ffULL,
0x000000026f067836ULL, 0x008fe20000000000ULL, 0x0000940000047ab9ULL, 0x000fe20000000800ULL,
0x0000004002077824ULL, 0x000fe200078e00ffULL, 0x000000010c787812ULL, 0x000fe400078e0cffULL,
0x0000007b0600720cULL, 0x000fe20003f06070ULL, 0x0000010007077836ULL, 0x000fc80000000000ULL,
0x000001006f707824ULL, 0x000fc800078e0207ULL, 0x000000047d067c24ULL, 0x000fc8000f8e0270ULL,
0x0000000c00308947ULL, 0x000fea0003800000ULL, 0x00000003ff197819ULL, 0x002fe20000011603ULL,
0x00009000000a7ab9ULL, 0x000fe20000000a00ULL, 0x000000707a077248ULL, 0x000fc60007fe0000ULL,
0x00000008190d7836ULL, 0x000fe40000000000ULL, 0x0000000419097836ULL, 0x000fe40000000000ULL,
0x000000010d237824ULL, 0x140fe400078e0203ULL, 0x000000080d0a7824ULL, 0x000fe400078e00ffULL,
0x0000000107187824ULL, 0x000fe400078e0a70ULL, 0x0000001003077824ULL, 0x000fe200078e00ffULL,
0xfffffff80a237812ULL, 0x000fe200078ee223ULL, 0x00000001090a7824ULL, 0x040fe200078e0206ULL,
0x000000180900720cULL, 0x000fe20003fa6070ULL, 0x0000000c190f7836ULL, 0x000fe20000000000ULL,
0x0000007007077812ULL, 0x000fe200078ec0ffULL, 0x0000000109087824ULL, 0x000fc400078e0203ULL,
0x0000000809277824ULL, 0x000fe200078e00ffULL, 0x000000180f00720cULL, 0x000fe20003f46070ULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee208ULL,
0x000000010f0e7824ULL, 0x140fe200078e0203ULL, 0x000000070a147212ULL, 0x000fe200078efcffULL,
0x000000080f297824ULL, 0x000fe400078e00ffULL, 0x0000001019117836ULL, 0x000fe20000000000ULL,
0x0000000a14147c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000119087824ULL, 0x100fe200078e0206ULL,
0xfffffff829297812ULL, 0x000fe200078ee20eULL, 0x00000001111f7824ULL, 0x040fe200078e0203ULL,
0x0000000b0b157c10ULL, 0x000fe20008ffe4ffULL, 0x00000008110a7824ULL, 0x000fe200078e00ffULL,
0x000000180d00720cULL, 0x000fe20003f26070ULL, 0x000000010f0e7824ULL, 0x000fc400078e0206ULL,
0x0000001419217836ULL, 0x000fe20000000000ULL, 0xfffffff80a1f7812ULL, 0x000fe200078ee21fULL,
0x0000008008087825ULL, 0x000fc800078e00ffULL, 0x00000018192d7836ULL, 0x000fe20000000000ULL,
0x0000000708087212ULL, 0x000fe200078efcffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x0000000a08087c10ULL, 0x000fe2000ff1e0ffULL, 0x00000001211a7824ULL, 0x100fe200078e0206ULL,
0x000000070e167212ULL, 0x080fe200078efcffULL, 0x000000010d0a7824ULL, 0x100fe200078e0206ULL,
0x0000000b09097c10ULL, 0x000fe200087fe4ffULL, 0x000000012d1c7824ULL, 0x000fe200078e0206ULL,
0x0000000a16167c10ULL, 0x000fe2000ff9e0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x000000181100720cULL, 0x000fe40003f06070ULL, 0x0000000b0f177c10ULL, 0x000fe2000a7fe4ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000071a0e7212ULL, 0x000fc400078efcffULL,
0x00000008020d7c11ULL, 0x000fe2000f8e70ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000070a127212ULL, 0x080fe400078efcffULL, 0x0000000a0e0e7c10ULL, 0x000fe2000ff9e0ffULL,
0x0000000111107824ULL, 0x000fe200078e0206ULL, 0x000000071c0a7212ULL, 0x000fe200078efcffULL,
0x00000001191c7824ULL, 0x000fe200078e0203ULL, 0x0000000a12127c10ULL, 0x000fe2000ff7e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000b1b0f7c10ULL, 0x000fc4000a7fe4ffULL,
0x000000071c1c7812ULL, 0x000fe200078ec0ffULL, 0x00002000781e7824ULL, 0x000fe200078e020dULL,
0x0000000710107212ULL, 0x000fe200078efcffULL, 0x0000002819357836ULL, 0x000fe20000000000ULL,
0x000000181900720cULL, 0x000fe20003f86070ULL, 0x000010001e1e7836ULL, 0x000fe20000000000ULL,
0x0000000b0b137c10ULL, 0x000fe20009ffe4ffULL, 0x0000001c192f7836ULL, 0x000fe20000000000ULL,
0x0ffffff81c257812ULL, 0x000fe200078ef803ULL, 0x0000000135227824ULL, 0x100fe200078e0206ULL,
0x0000000a10107c10ULL, 0x000fe2000ff7e0ffULL, 0x000000012f1a7824ULL, 0x000fc400078e0206ULL,
0x0000001025257824ULL, 0x000fe200078e021eULL, 0x0000000b11117c10ULL, 0x000fe20009ffe4ffULL,
0x0000002019317836ULL, 0x000fe20000000000ULL, 0x0000000a0a0a7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000821207824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008257faeULL, 0x0003e2000e101c46ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000b1d0b7c10ULL, 0x000fe40009ffe4ffULL, 0x000000182d00720cULL, 0x080fe20003f86070ULL,
0x00000001211d7824ULL, 0x000fe200078e0203ULL, 0x000000071a1a7212ULL, 0x000fe200078efcffULL,
0x00000001311c7824ULL, 0x000fe200078e0206ULL, 0x000000182100720cULL, 0x000fe20003f66070ULL,
0x0000002419337836ULL, 0x000fe20000000000ULL, 0xfffffff8202b7812ULL, 0x000fe200078ee21dULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000000a1a1a7c10ULL, 0x000fc6000ffde0ffULL,
0x0000001027257824ULL, 0x002fe200078e021eULL, 0x000000071c1c7212ULL, 0x080fe200078efcffULL,
0x0000008022087825ULL, 0x000fe200078e00ffULL, 0x0000000b1b1b7c10ULL, 0x000fe4000b7fe4ffULL,
0x0000000014257faeULL, 0x0003e2000e901c46ULL, 0x000000012f227824ULL, 0x140fe200078e0203ULL,
0x0000000a1c1c7c10ULL, 0x000fe2000ffde0ffULL, 0x000000082f277824ULL, 0x000fe200078e00ffULL,
0x0000000708087212ULL, 0x000fe200078efcffULL, 0x0000000133207824ULL, 0x000fe200078e0206ULL,
0x0000000b1d1d7c10ULL, 0x000fe2000b7fe4ffULL, 0x000000012d247824ULL, 0x100fe200078e0203ULL,
0xfffffff827277812ULL, 0x000fe200078ee222ULL, 0x0000000131227824ULL, 0x000fe200078e0203ULL,
0x000000182f00720cULL, 0x000fe20003fa6070ULL, 0x000000082d2d7824ULL, 0x000fc400078e00ffULL,
0x0000001029257824ULL, 0x102fe400078e021eULL, 0x0000000831297824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee224ULL, 0x0000001023237824ULL, 0x100fe400078e021eULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe400078ee222ULL,
0x0000000012237faeULL, 0x0003e2000c901c46ULL, 0x0000002c19377836ULL, 0x000fe20000000000ULL,
0x0000000720207212ULL, 0x000fe200078efcffULL, 0x000000101f1f7824ULL, 0x000fe200078e021eULL,
0x0000000016257faeULL, 0x0005e2000d101c46ULL, 0x0000000137147824ULL, 0x000fe200078e0206ULL,
0x0000000a20207c10ULL, 0x000fe2000ffde0ffULL, 0x0000000133247824ULL, 0x000fe200078e0203ULL,
0x00000000101f7faeULL, 0x0007e2000c101c46ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000b21217c10ULL, 0x000fc4000b7fe4ffULL, 0x0000000a08087c10ULL, 0x000fe2000ffde0ffULL,
0x000000102b137824ULL, 0x102fe200078e021eULL, 0x0000000714147212ULL, 0x000fe200078efcffULL,
0x00000008332f7824ULL, 0x000fe200078e00ffULL, 0x0000000b09097c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001029257824ULL, 0x104fe200078e021eULL, 0x000000000e137faeULL, 0x0003e2000d901c46ULL,
0x0000003019297836ULL, 0x000fe20000000000ULL, 0x0000000a14147c10ULL, 0x000fe2000ffde0ffULL,
0x000000102d177824ULL, 0x000fe200078e021eULL, 0x000000183100720cULL, 0x080fe20003f26070ULL,
0x0000000129107824ULL, 0x108fe200078e0206ULL, 0x0000000b15157c10ULL, 0x000fe2000b7fe4ffULL,
0x00000034191f7836ULL, 0x000fe20000000000ULL, 0x000000000a177faeULL, 0x0005e2000e101c46ULL,
0x000000183300720cULL, 0x080fe20003f46070ULL, 0x00000038192b7836ULL, 0x000fe20000000000ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee224ULL, 0x000000011f0e7824ULL, 0x002fe200078e0206ULL,
0x000000183700720cULL, 0x080fe20003f86070ULL, 0x0000003c192d7836ULL, 0x000fe20000000000ULL,
0x000000182900720cULL, 0x000fe20003f66070ULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x000000182d00720cULL, 0x000fe20003f06070ULL, 0x00000080100a7825ULL, 0x004fe200078e00ffULL,
0x000000070e127212ULL, 0x000fc600078efcffULL, 0x0000000135107824ULL, 0x140fe200078e0203ULL,
0x000000070a0a7212ULL, 0x000fe200078efcffULL, 0x0000000835177824ULL, 0x000fe400078e00ffULL,
0x0000000837197824ULL, 0x000fe200078e00ffULL, 0x0000000a0a0a7c10ULL, 0x000fe2000ffde0ffULL,
0x000000012b0e7824ULL, 0x000fe200078e0206ULL, 0xfffffff817177812ULL, 0x000fe200078ee210ULL,
0x0000000137107824ULL, 0x100fe200078e0203ULL, 0x0000000b0b0b7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001027237824ULL, 0x100fe200078e021eULL, 0x0000000a12127c10ULL, 0x000fe2000ffde0ffULL,
0x0000000129117824ULL, 0x040fe200078e0203ULL, 0xfffffff819197812ULL, 0x000fe200078ee210ULL,
0x0000000829167824ULL, 0x000fe200078e00ffULL, 0x0000000b0f137c10ULL, 0x000fe2000b7fe4ffULL,
0x000000102f277824ULL, 0x000fe200078e021eULL, 0x000000001a237faeULL, 0x0003e2000e901c46ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000183500720cULL, 0x000fc40003fa6070ULL,
0x000000001c257faeULL, 0x0005e2000c901c46ULL, 0x000000012d107824ULL, 0x000fe200078e0206ULL,
0x000000070e0e7212ULL, 0x080fe200078efcffULL, 0x000000012b067824ULL, 0x100fe200078e0203ULL,
0x0000000020277faeULL, 0x0007e2000d101c46ULL, 0x000000181f00720cULL, 0x080fe20003f46070ULL,
0x0000001017177824ULL, 0x000fe200078e021eULL, 0x000000182b00720cULL, 0x000fe20003f26070ULL,
0x000000012d187824ULL, 0x100fe200078e0203ULL, 0xfffffff8161b7812ULL, 0x002fe200078ee211ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000a0e0e7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000008177faeULL, 0x0003e4000e901c46ULL, 0x000000011f167824ULL, 0x040fe200078e0203ULL,
0x0000000710077212ULL, 0x000fe200078efcffULL, 0x000000081f1d7824ULL, 0x004fe200078e00ffULL,
0x0000000b0f0f7c10ULL, 0x000fe2000b7fe4ffULL, 0x000000082b1f7824ULL, 0x000fc400078e00ffULL,
0x000000082d217824ULL, 0x008fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee216ULL,
0x0000001019197824ULL, 0x100fe200078e021eULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee206ULL,
0x000000101b1b7824ULL, 0x100fe200078e021eULL, 0xfffffff821217812ULL, 0x000fe200078ee218ULL,
0x000000101d1d7824ULL, 0x100fe200078e021eULL, 0x0000000a07067c10ULL, 0x000fe2000ffde0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e021eULL, 0x0000000014197faeULL, 0x0003e2000e101c46ULL,
0x0000001021217824ULL, 0x000fe200078e021eULL, 0x0000000b11077c10ULL, 0x000fc4000b7fe4ffULL,
0x000000000a1b7faeULL, 0x0003e8000d901c46ULL, 0x00000000121d7faeULL, 0x0003e8000d101c46ULL,
0x000000000e1f7faeULL, 0x0003e8000c901c46ULL, 0x0000000006217faeULL, 0x0003e2000c101c46ULL,
0x0000000800e07947ULL, 0x000fea0003800000ULL, 0x00000008030a7811ULL, 0x042fe200078fe8ffULL,
0x00000010033d7824ULL, 0x040fe200078e00ffULL, 0x0000000403087811ULL, 0x040fe200078fe8ffULL,
0x00009000000a7ab9ULL, 0x000fe20000000a00ULL, 0x0000001003107811ULL, 0x040fe200078fe8ffULL,
0x000000010a097824ULL, 0x140fe200078e0203ULL, 0x0000000c030e7811ULL, 0x040fe200078fe8ffULL,
0x000000080a2c7824ULL, 0x000fe200078e00ffULL, 0x0000001803147811ULL, 0x040fe200078fe8ffULL,
0x0000000108077824ULL, 0x140fe200078e0203ULL, 0x0000001403127811ULL, 0x040fe200078fe8ffULL,
0x0000000808227824ULL, 0x000fe200078e00ffULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee209ULL,
0x0000000110097824ULL, 0x140fe200078e0203ULL, 0x0000002003187811ULL, 0x040fe200078fe8ffULL,
0x0000000810307824ULL, 0x000fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee207ULL,
0x000000010e077824ULL, 0x140fe200078e0203ULL, 0x0000001c03167811ULL, 0x040fe200078fe8ffULL,
0x000000080e2e7824ULL, 0x000fe200078e00ffULL, 0x00000028031c7811ULL, 0x040fe200078fe8ffULL,
0x00000001140d7824ULL, 0x140fe200078e0203ULL, 0xfffffff830307812ULL, 0x000fe200078ee209ULL,
0x0000000814347824ULL, 0x000fe200078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee207ULL,
0x00000001120b7824ULL, 0x140fe200078e0203ULL, 0x00000024031a7811ULL, 0x040fe200078fe8ffULL,
0x0000000812327824ULL, 0x000fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ee20dULL,
0x0000000118097824ULL, 0x140fe200078e0203ULL, 0x00000030032a7811ULL, 0x040fe200078fe8ffULL,
0x0000000818387824ULL, 0x000fe200078e00ffULL, 0x0000002c031e7811ULL, 0x040fe200078fe8ffULL,
0x0000000116077824ULL, 0x140fe200078e0203ULL, 0x0000003803267811ULL, 0x040fe200078fe8ffULL,
0x0000000816367824ULL, 0x000fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe200078ee20bULL,
0x000000011c0d7824ULL, 0x140fe200078e0203ULL, 0xfffffff838387812ULL, 0x000fe200078ee209ULL,
0x000000081c3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee207ULL,
0x000000011a0b7824ULL, 0x140fe200078e0203ULL, 0x0000003403287811ULL, 0x040fe200078fe8ffULL,
0x000000081a3a7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee20dULL,
0x000000012a097824ULL, 0x140fe200078e0203ULL, 0x0000003c03247811ULL, 0x000fe200078fe8ffULL,
0x000000082a407824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee20bULL,
0x000000011e077824ULL, 0x140fe200078e0203ULL, 0x000000703d3d7812ULL, 0x000fe200078ec0ffULL,
0x000000081e3e7824ULL, 0x000fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee209ULL,
0x00000001260d7824ULL, 0x000fc400078e0203ULL, 0x0000000826467824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee207ULL, 0x00000001280b7824ULL, 0x140fe200078e0203ULL,
0x0000000303077211ULL, 0x000fe200078fe8ffULL, 0x0000000828447824ULL, 0x000fe200078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee20dULL, 0x0000000124097824ULL, 0x000fe200078e0203ULL,
0x00000008020d7c11ULL, 0x000fe2000f8e70ffULL, 0x0000000824487824ULL, 0x000fe200078e00ffULL,
0x0000000707207812ULL, 0x000fe200078ec0ffULL, 0x0000000108087824ULL, 0x100fe200078e0206ULL,
0xfffffff844447812ULL, 0x000fe200078ee20bULL, 0x000000010a0a7824ULL, 0x100fe200078e0206ULL,
0xfffffff848487812ULL, 0x000fe200078ee209ULL, 0x000000010e0e7824ULL, 0x100fe200078e0206ULL,
0x0ffffff820207812ULL, 0x000fe200078ef803ULL, 0x0000000110107824ULL, 0x000fc400078e0206ULL,
0x0000000112127824ULL, 0x100fe400078e0206ULL, 0x0000000114147824ULL, 0x100fe400078e0206ULL,
0x0000000116167824ULL, 0x100fe400078e0206ULL, 0x0000000118187824ULL, 0x100fe400078e0206ULL,
0x000000011a1a7824ULL, 0x100fe400078e0206ULL, 0x000000011c1c7824ULL, 0x000fc400078e0206ULL,
0x000000011e1e7824ULL, 0x100fe400078e0206ULL, 0x000000012a2a7824ULL, 0x100fe400078e0206ULL,
0x0000000128287824ULL, 0x100fe400078e0206ULL, 0x0000000126267824ULL, 0x100fe400078e0206ULL,
0x0000000124247824ULL, 0x000fe200078e0206ULL, 0x0000000603067211ULL, 0x000fe200078fe8ffULL,
0x0000200078097824ULL, 0x000fc400078e020dULL, 0x000000800a0a7825ULL, 0x000fc800078e00ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000003d0a0a7212ULL, 0x000fc600078efcffULL,
0x00001000090f7836ULL, 0x000fe20000000000ULL, 0x0000003d06067212ULL, 0x000fe200078efcffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0x0000000a06067c10ULL, 0x000fe2000ff1e0ffULL,
0x00000010203b7824ULL, 0x100fe200078e020fULL, 0x0000003d12127212ULL, 0x000fe200078efcffULL,
0x0000001022397824ULL, 0x100fe200078e020fULL, 0x0000000b07077c10ULL, 0x000fe200087fe4ffULL,
0x000000102c377824ULL, 0x100fe200078e020fULL, 0x0000000a0a0a7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000102e357824ULL, 0x100fe400078e020fULL, 0x0000001030337824ULL, 0x100fe200078e020fULL,
0x0000000b0b0b7c10ULL, 0x000fe200087fe4ffULL, 0x0000001032317824ULL, 0x100fe200078e020fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000063b7faeULL, 0x0003e2000b901c46ULL,
0x00000010342f7824ULL, 0x000fc400078e020fULL, 0x00000010362d7824ULL, 0x100fe400078e020fULL,
0x00000010382b7824ULL, 0x100fe400078e020fULL, 0x000000103a297824ULL, 0x100fe400078e020fULL,
0x000000103c277824ULL, 0x100fe400078e020fULL, 0x000000103e257824ULL, 0x100fe400078e020fULL,
0x0000001040237824ULL, 0x000fc400078e020fULL, 0x0000001044227824ULL, 0x100fe400078e020fULL,
0x0000001046217824ULL, 0x100fe400078e020fULL, 0x0000001048207824ULL, 0x000fe400078e020fULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000003d0e0e7212ULL, 0x000fc600078efcffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000000a0e0e7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000003d16167212ULL, 0x080fe200078efcffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000000b0f0f7c10ULL, 0x000fe400087fe4ffULL,
0x0000000a12127c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000003d08087212ULL, 0x000fe400078efcffULL, 0x0000000b13137c10ULL, 0x000fe200087fe4ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000a16167c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000a08087c10ULL, 0x000fe2000ff3e0ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000003d1a1a7212ULL, 0x080fe400078efcffULL, 0x0000003d10107212ULL, 0x080fe200078efcffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000003d14147212ULL, 0x000fe400078efcffULL,
0x0000000b17177c10ULL, 0x000fe200087fe4ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000000b09097c10ULL, 0x000fc40008ffe4ffULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000802a3e7825ULL, 0x000fe200078e00ffULL, 0x0000000a10107c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000008397faeULL, 0x0003e2000b901c46ULL, 0x0000003d1e1e7212ULL, 0x080fe200078efcffULL,
0x0000008028407825ULL, 0x000fe200078e00ffULL, 0x0000000a14147c10ULL, 0x000fe2000ff5e0ffULL,
0x000000000a377faeULL, 0x0003e2000b901c46ULL, 0x0000003d18187212ULL, 0x080fe200078efcffULL,
0x0000008026447825ULL, 0x000fe200078e00ffULL, 0x0000003d1c1c7212ULL, 0x000fe200078efcffULL,
0x000000000e357faeULL, 0x0003e2000b901c46ULL, 0x0000000b1b1b7c10ULL, 0x000fe200087fe4ffULL,
0x0000008024467825ULL, 0x000fe200078e00ffULL, 0x0000000b11117c10ULL, 0x000fc40008ffe4ffULL,
0x0000000a1e1e7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000b15157c10ULL, 0x000fe200097fe4ffULL,
0x0000000010337faeULL, 0x0003e2000b901c46ULL, 0x0000000a18187c10ULL, 0x000fe4000ff3e0ffULL,
0x0000003d3e3c7212ULL, 0x080fe200078efcffULL, 0x0000000012317faeULL, 0x0003e2000b901c46ULL,
0x0000000a1c1c7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000003d403e7212ULL, 0x080fe200078efcffULL,
0x00000000142f7faeULL, 0x0003e2000b901c46ULL, 0x0000003d44407212ULL, 0x000fc400078efcffULL,
0x0000000b1f1f7c10ULL, 0x000fe200087fe4ffULL, 0x00000000162d7faeULL, 0x0003e2000b901c46ULL,
0x0000003d463d7212ULL, 0x000fe400078efcffULL, 0x0000000b19197c10ULL, 0x000fe40008ffe4ffULL,
0x0000000a3c3c7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000b1d1d7c10ULL, 0x000fe200097fe4ffULL,
0x00000000182b7faeULL, 0x0003e2000b901c46ULL, 0x0000000a3e3e7c10ULL, 0x000fc4000ff3e0ffULL,
0x0000000a40407c10ULL, 0x000fe2000ff5e0ffULL, 0x000000001a297faeULL, 0x0003e2000b901c46ULL,
0x0000000a3d447c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000b3f3d7c10ULL, 0x000fe200087fe4ffULL,
0x000000001c277faeULL, 0x0003e2000b901c46ULL, 0x0000000b413f7c10ULL, 0x000fe40008ffe4ffULL,
0x0000000b45417c10ULL, 0x000fe200097fe4ffULL, 0x000000001e257faeULL, 0x0003e2000b901c46ULL,
0x0000000b47457c10ULL, 0x000fc60009ffe4ffULL, 0x000000003c237faeULL, 0x0003e8000b901c46ULL,
0x000000003e227faeULL, 0x0003e8000b901c46ULL, 0x0000000040217faeULL, 0x0003e8000b901c46ULL,
0x0000000044207faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002003067836ULL, 0x002fe20000000000ULL, 0xfffffff803647812ULL, 0x040fe200078ec0ffULL,
0x000020000c077824ULL, 0x000fe200078e020dULL, 0x00000007036a7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0xfffffff806067812ULL, 0x000fe400078ec0ffULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fc4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fc4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000100007077836ULL, 0x000fe20000000000ULL, 0x0000000764647812ULL, 0x000fe200078ef803ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000086a6e7812ULL, 0x000fe400078ef803ULL,
0x0000000706067812ULL, 0x000fce00078ef803ULL, 0x0000000164097824ULL, 0x140fe200078e0208ULL,
0x00000004ff0d7819ULL, 0x000fe20000011603ULL, 0x00000008640a7824ULL, 0x000fe400078e00ffULL,
0x00000008060c7824ULL, 0x040fe400078e00ffULL, 0x00000001080b7836ULL, 0x000fe20000000000ULL,
0xfffffff80a0a7812ULL, 0x000fe200078ee209ULL, 0x0000000106097824ULL, 0x000fe400078e0208ULL,
0x00000008640e7824ULL, 0x000fc400078e00ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0207ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee209ULL, 0x0000000164097824ULL, 0x000fe400078e020bULL,
0x000000106e197824ULL, 0x000fe200078e00ffULL, 0x000000000a38783bULL, 0x0002a20000000200ULL,
0x000000100c0c7824ULL, 0x000fe200078e0207ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL,
0x0000000208097824ULL, 0x000fe400078e020dULL, 0x0000000806407824ULL, 0x040fe200078e00ffULL,
0x000000000c10783bULL, 0x000ee20000000200ULL, 0x00000001060b7824ULL, 0x000fe200078e020bULL,
0x000000026e1a7810ULL, 0x140fe20007ffe009ULL, 0x000000016e0a7824ULL, 0x002fc400078e0209ULL,
0x000000106e1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee20bULL,
0x000000100e0e7824ULL, 0x000fe200078e0207ULL, 0xfffffff0190a7812ULL, 0x000fe200078ee20aULL,
0x0000000208087836ULL, 0x000fe20000000000ULL, 0xfffffff01b1a7812ULL, 0x000fc600078ee21aULL,
0x000000000e0c783bULL, 0x000fe20000000200ULL, 0x000000081a1a7c11ULL, 0x000fe4000f8e20ffULL,
0x000000080800780cULL, 0x000fe40003f05270ULL, 0x00000010ff487819ULL, 0x004fe40000011638ULL,
0x0000ffff384c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff48757812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5d7819ULL, 0x008fc40000011611ULL, 0x00000018ff5a7819ULL, 0x000fe40000011611ULL,
0x000000ff11597812ULL, 0x040fe400078ec0ffULL, 0x0000ffff115e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff13117812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3d7819ULL, 0x100fe40000011610ULL,
0x00000018ff627819ULL, 0x000fc40000011610ULL, 0x000000ff105f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff507819ULL, 0x100fe40000011612ULL, 0x00000018ff537819ULL, 0x000fe40000011612ULL,
0x000000ff12527812ULL, 0x040fe400078ec0ffULL, 0x0000ffff12517812ULL, 0x000fe400078ec0ffULL,
0x00000011ff48723eULL, 0x000fc400020006ffULL, 0x0000ffff3a607812ULL, 0x000fe400078ec0ffULL,
0x0000ffff10107812ULL, 0x000fe400078ec0ffULL, 0x00000018ff127819ULL, 0x000fe40000011613ULL,
0x000000080a117c11ULL, 0x000fe4000f8e20ffULL, 0x00000008ff747819ULL, 0x000fe4000001164cULL,
0x00000008ff6c7819ULL, 0x000fc40000011660ULL, 0x00000010ff577819ULL, 0x000fe40000011613ULL,
0x0000ffff13587812ULL, 0x000fe400078ec0ffULL, 0x00000012ff4c723eULL, 0x000fe400020006ffULL,
0x00000008ff607819ULL, 0x000fe40000011610ULL, 0x000000001110783bULL, 0x000e620000000200ULL,
0x00000018ff197819ULL, 0x000fe40000011638ULL, 0x000000ff38187812ULL, 0x000fe200078ec0ffULL,
0x0000001040387824ULL, 0x000fe200078e0207ULL, 0x00000010ff3e7819ULL, 0x000fc40000011639ULL,
0x00000018ff727819ULL, 0x000fe40000011639ULL, 0x000000ff391b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff393f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4d7819ULL, 0x100fe4000001163aULL,
0x00000018ff4f7819ULL, 0x000fe4000001163aULL, 0x000000ff3a4e7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff0b7819ULL, 0x100fe4000001163bULL, 0x00000018ff677819ULL, 0x000fe4000001163bULL,
0x000000ff3b547812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3b3c7812ULL, 0x000fe400078ec0ffULL,
0x000000003838783bULL, 0x000ea20000000200ULL, 0x00000019ff19723eULL, 0x000fe400020006ffULL,
0x00000018ff18723eULL, 0x000fc400020006ffULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x000000ff3e737812ULL, 0x000fe400078ec0ffULL,
0x00000008ff717819ULL, 0x000fe4000001163fULL, 0x0000541075197816ULL, 0x000fe40000000019ULL,
0x0000541018187816ULL, 0x000fc40000000074ULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x0000001bff1b723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x000000181034723cULL, 0x002fe20000001834ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x000000ff4d6d7812ULL, 0x000fe400078ec0ffULL, 0x0000004fff4f723eULL, 0x000fc400020006ffULL,
0x0000541073197816ULL, 0x000fe40000000072ULL, 0x000054101b187816ULL, 0x000fe40000000071ULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x000000181030723cULL, 0x000fe20000001830ULL,
0x000054106d4f7816ULL, 0x000fe2000000004fULL, 0x000000001a18783bULL, 0x000e620000000200ULL,
0x000054104e4e7816ULL, 0x000fc4000000006cULL, 0x000000ff0b687812ULL, 0x000fe400078ec0ffULL,
0x00000008ff667819ULL, 0x000fe4000001163cULL, 0x000000ff3a6b7812ULL, 0x004fe200078ec0ffULL,
0x0000004e102c723cULL, 0x000fe2000000182cULL, 0x00000010ff557819ULL, 0x000fe4000001160cULL,
0x00000010ff567819ULL, 0x100fe4000001160eULL, 0x00000018ff447819ULL, 0x000fc4000001160eULL,
0x000000ff0e457812ULL, 0x040fe400078ec0ffULL, 0x0000ffff0e497812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4a7819ULL, 0x100fe4000001160fULL, 0x00000018ff4b7819ULL, 0x000fe4000001160fULL,
0x000000ff0f417812ULL, 0x040fe400078ec0ffULL, 0x0000ffff0f097812ULL, 0x000fc400078ec0ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000010ff0e7819ULL, 0x100fe4000001163aULL, 0x00000018ff4d7819ULL, 0x000fc4000001163aULL,
0x0000ffff3a0f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3a7819ULL, 0x000fe4000001165eULL, 0x0000006bff4e723eULL, 0x000fe400020006ffULL,
0x000000ff50507812ULL, 0x000fe400078ec0ffULL, 0x00000008ff517819ULL, 0x000fc40000011651ULL,
0x000000ff556b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3d637812ULL, 0x000fe400078ec0ffULL,
0x0000005dff5e723eULL, 0x000fe400020006ffULL, 0x0000541068557816ULL, 0x000fe40000000067ULL,
0x0000541054547816ULL, 0x000fe40000000066ULL, 0x0000003aff5d723eULL, 0x000fc400020006ffULL,
0x000000ff573a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7c7819ULL, 0x000fe20000011658ULL,
0x000000541028723cULL, 0x000fe20000001828ULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000050ff58723eULL, 0x000fe400020006ffULL,
0x00000051ff57723eULL, 0x000fc400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x0000541058537816ULL, 0x000fe40000000053ULL,
0x0000541052527816ULL, 0x000fc40000000057ULL, 0x0000541063557816ULL, 0x000fe40000000062ULL,
0x000054105f547816ULL, 0x000fe40000000060ULL, 0x0000ffff0c617812ULL, 0x000fe200078ec0ffULL,
0x00000052101c723cULL, 0x000fe2000000181cULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000003aff50723eULL, 0x000fe200020006ffULL,
0x000000541024723cULL, 0x000fe20000001824ULL, 0x0000007cff51723eULL, 0x000fc400020006ffULL,
0x00000018ff657819ULL, 0x000fe4000001163bULL, 0x00000008ff537819ULL, 0x000fe40000011649ULL,
0x00000018ff477819ULL, 0x000fe4000001160cULL, 0x000000ff0c407812ULL, 0x000fe400078ec0ffULL,
0x00000008ff617819ULL, 0x000fe40000011661ULL, 0x000054105e557816ULL, 0x000fc4000000005aULL,
0x0000541059547816ULL, 0x000fe4000000005dULL, 0x0000541050497816ULL, 0x000fe4000000004cULL,
0x0000541048487816ULL, 0x000fe40000000051ULL, 0x00000065ff4f723eULL, 0x000fe200020006ffULL,
0x000000541020723cULL, 0x000fe20000001820ULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000040ff3a723eULL, 0x000fc400020006ffULL, 0x0000006bff65723eULL, 0x000fe200020006ffULL,
0x000000481014723cULL, 0x000fe20000001814ULL, 0x00000061ff5f723eULL, 0x000fe400020006ffULL,
0x00000010ff0a7819ULL, 0x000fe40000011638ULL, 0x0000ffff380b7812ULL, 0x000fe400078ec0ffULL,
0x0000541065117816ULL, 0x000fe40000000047ULL, 0x000054103a107816ULL, 0x000fc4000000005fULL,
0x000000ff56567812ULL, 0x000fe400078ec0ffULL, 0x000000ff0a0a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff0b7819ULL, 0x000fe2000001160bULL, 0x000000101834723cULL, 0x002fe20000001834ULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x00000056ff52723eULL, 0x000fc400020006ffULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x00000010ff5c7819ULL, 0x100fe4000001160dULL, 0x00000018ff767819ULL, 0x000fe4000001160dULL,
0x000000ff0d467812ULL, 0x040fe400078ec0ffULL, 0x0000ffff0d5b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3e7819ULL, 0x000fc40000011638ULL, 0x000000ff383f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff0c7819ULL, 0x100fe40000011639ULL, 0x00000018ff3c7819ULL, 0x000fe40000011639ULL,
0x000000ff393d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff390d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff397819ULL, 0x000fc4000001163bULL, 0x000000ff3b387812ULL, 0x040fe400078ec0ffULL,
0x0000000aff11723eULL, 0x000fe400020006ffULL, 0x0000000bff10723eULL, 0x000fe400020006ffULL,
0x0000ffff3b3b7812ULL, 0x000fe400078ec0ffULL, 0x00005410520b7816ULL, 0x000fe40000000044ULL,
0x00005410450a7816ULL, 0x000fc40000000053ULL, 0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5b7819ULL, 0x000fe2000001165bULL,
0x0000000a182c723cULL, 0x000fe2000000182cULL, 0x00000008ff097819ULL, 0x000fe40000011609ULL,
0x000000ff0c0c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff0d7819ULL, 0x000fc4000001160dULL,
0x000000ff0e0e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff0f7819ULL, 0x000fe4000001160fULL,
0x000000ff39397812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3b7819ULL, 0x000fe4000001163bULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x0000004aff4a723eULL, 0x000fc400020006ffULL,
0x00000076ff40723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fc400020006ffULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x0000005cff55723eULL, 0x000fe400020006ffULL, 0x0000005bff54723eULL, 0x000fe400020006ffULL,
0x00000009ff09723eULL, 0x000fe400020006ffULL, 0x0000000cff0b723eULL, 0x000fc400020006ffULL,
0x0000000dff0d723eULL, 0x000fe400020006ffULL, 0x0000000eff0e723eULL, 0x000fe400020006ffULL,
0x0000000fff0f723eULL, 0x000fe400020006ffULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x0000003bff3b723eULL, 0x000fc400020006ffULL,
0x000054104a4b7816ULL, 0x000fe4000000004bULL, 0x0000541055477816ULL, 0x000fe40000000040ULL,
0x0000541046467816ULL, 0x000fe40000000054ULL, 0x00005410414a7816ULL, 0x000fe40000000009ULL,
0x0000541011117816ULL, 0x000fe4000000003eULL, 0x000054103f107816ULL, 0x000fe20000000010ULL,
0x000000461830723cULL, 0x000fe20000001830ULL, 0x000054100b0b7816ULL, 0x000fc4000000003cULL,
0x000054103d0a7816ULL, 0x000fe4000000000dULL, 0x000054100e4d7816ULL, 0x000fe2000000004dULL,
0x0000004a1828723cULL, 0x000fe20000001828ULL, 0x000054104e4c7816ULL, 0x000fe4000000000fULL,
0x0000541039397816ULL, 0x000fe4000000004fULL, 0x0000541038387816ULL, 0x000fe2000000003bULL,
0x000000101824723cULL, 0x000fec0000001824ULL, 0x0000000a1820723cULL, 0x000fec0000001820ULL,
0x0000004c181c723cULL, 0x000fec000000181cULL, 0x000000381814723cULL, 0x000fe20000001814ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff0002c0947ULL, 0x000fde000383ffffULL,
0x00000001ff067424ULL, 0x000fe400078e00ffULL, 0x0000000434137220ULL, 0x080fe20000410000ULL,
0x0000000435357220ULL, 0x080fe20000410000ULL, 0x0000000436367220ULL, 0x080fe20000410000ULL,
0x0000000437377220ULL, 0x080fe20000410000ULL, 0x0000000430307220ULL, 0x080fe20000410000ULL,
0x01768806050679a7ULL, 0x000e62000850003fULL, 0x0000000431317220ULL, 0x080fe20000410000ULL,
0x0000000432327220ULL, 0x080fe20000410000ULL, 0x0000000433337220ULL, 0x080fe20000410000ULL,
0x000000042c2c7220ULL, 0x080fe20000410000ULL, 0x000000042d2d7220ULL, 0x080fe20000410000ULL,
0x000000042e2e7220ULL, 0x080fe20000410000ULL, 0x000000042f2f7220ULL, 0x080fe20000410000ULL,
0x0000000428287220ULL, 0x080fe20000410000ULL, 0x0000000429297220ULL, 0x080fe20000410000ULL,
0x000000042a2a7220ULL, 0x080fe20000410000ULL, 0x000000042b2b7220ULL, 0x080fe20000410000ULL,
0x0000000424247220ULL, 0x080fe20000410000ULL, 0x0000000425257220ULL, 0x080fe20000410000ULL,
0x0000000426267220ULL, 0x080fe20000410000ULL, 0x0000000427277220ULL, 0x080fe20000410000ULL,
0x0000000420207220ULL, 0x080fe20000410000ULL, 0x0000000421217220ULL, 0x080fe20000410000ULL,
0x0000000422227220ULL, 0x080fe20000410000ULL, 0x0000000423237220ULL, 0x080fe20000410000ULL,
0x000000041c1c7220ULL, 0x080fe20000410000ULL, 0x000000041d1d7220ULL, 0x080fe20000410000ULL,
0x000000041e1e7220ULL, 0x080fe20000410000ULL, 0x000000041f1f7220ULL, 0x080fe20000410000ULL,
0x0000000414147220ULL, 0x080fe20000410000ULL, 0x0000000415157220ULL, 0x080fe20000410000ULL,
0x0000000416167220ULL, 0x080fe20000410000ULL, 0x0000000417177220ULL, 0x000fe20000410000ULL,
0x0000000000087805ULL, 0x000fe20000015200ULL, 0x01768807050075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fce00078e00ffULL,
0x000000100c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000000d0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010c0c7836ULL, 0x000fce0000000000ULL,
0x01768807050075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000000010d7983ULL, 0x000ea20000100800ULL, 0x0000000403067824ULL, 0x000fe200078e00ffULL,
0x0000000802077c11ULL, 0x000fc8000f8e38ffULL, 0xfffffff006067812ULL, 0x000fca00078ec0ffULL,
0x0000000107127824ULL, 0x000fca00078e0206ULL, 0x0174000012087984ULL, 0x0002620000000c00ULL,
0x0000000d6f00720cULL, 0x004fda0003f06070ULL, 0x0000001400288947ULL, 0x002fea0003800000ULL,
0x0000040001107983ULL, 0x000ea20000100800ULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00000004000c7d06ULL, 0x000e620008209000ULL,
0xffffff0070197836ULL, 0x000fe20000000000ULL, 0x00000004ff007c0cULL, 0x000fe2000bf85070ULL,
0x00000002031a7824ULL, 0x000fe200078e00ffULL, 0x00000004ff347c12ULL, 0x000fc8000f8e33ffULL,
0x000000061a1a7812ULL, 0x000fca00078ec0ffULL, 0x000000011a187824ULL, 0x000fe200078e0200ULL,
0x0000000c000c7308ULL, 0x002e640000001000ULL, 0x0ffffffe0c0e7836ULL, 0x002fcc0000000000ULL,
0x0000000e00077305ULL, 0x000e64000021f000ULL, 0x000000ffff0d7224ULL, 0x002fc800078e0a07ULL,
0x000000040d0d7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000d070f7227ULL, 0x000fe200078e0006ULL,
0x000000201a3c7812ULL, 0x000fca00078efcffULL, 0x0000000177407824ULL, 0x000fe400078e023cULL,
0x000000013c3e7824ULL, 0x000fe200078e0200ULL, 0x000000301a447812ULL, 0x000fca00078efcffULL,
0x0000000177567824ULL, 0x000fe400078e0244ULL, 0x0000000144487824ULL, 0x000fe200078e0200ULL,
0x0000001003067211ULL, 0x004fca00078ff0ffULL, 0x000000060f077227ULL, 0x000fc800078e00ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a07ULL, 0x000000040d0c7c24ULL, 0x000fe4000f8e0206ULL,
0x0000000806067836ULL, 0x000fc60000000000ULL, 0x000000040c007c0cULL, 0x000fe2000bf06070ULL,
0x000000060f0d7227ULL, 0x000fc800078e00ffULL, 0x000000ffff0f7224ULL, 0x000fc800078e0a0dULL,
0x000000040f0e7c24ULL, 0x000fe2000f8e0206ULL, 0x000000197a067248ULL, 0x000fc60007fe0000ULL,
0x800000040c0c0c36ULL, 0x000fe20008000000ULL, 0x000000040e007c0cULL, 0x000fe2000bf46070ULL,
0x0000000106197824ULL, 0x000fe400078e0a19ULL, 0x0000000107070836ULL, 0x000fe20000000000ULL,
0x000000040c007c0cULL, 0x000fe2000bf26070ULL, 0x00000001770c7824ULL, 0x000fe400078e021aULL,
0x000000ffff507224ULL, 0x000fc600078e0a19ULL, 0x000000190c00720cULL, 0x080fe40003f66070ULL,
0x000000500c0c7246ULL, 0x000fe20003800069ULL, 0x800000040e0e2c36ULL, 0x000fe20008000000ULL,
0x0000005018497246ULL, 0x000fe20003800069ULL, 0x000000010d0d2836ULL, 0x000fe20000000000ULL,
0x00000004ff0c7819ULL, 0x000fe2000001160cULL, 0x0000000107071836ULL, 0x000fe20000000000ULL,
0x000000040e007c0cULL, 0x000fe4000bf06070ULL, 0x000000191800720cULL, 0x000fc40003f26070ULL,
0x0000000734067207ULL, 0x000fe40006000000ULL, 0x000000ff0c077207ULL, 0x000fe40001800000ULL,
0x0000000669067248ULL, 0x000fe40003fe0000ULL, 0x000000ff49497207ULL, 0x000fc60000800000ULL,
0x0000000506527c24ULL, 0x000fe4000f8e02ffULL, 0x000000010d0d0836ULL, 0x000fe40000000000ULL,
0x00000001520f7824ULL, 0x000fe200078e0207ULL, 0x0000005249117211ULL, 0x000fe400078fe0ffULL,
0x0000000d34067207ULL, 0x000fe20006000000ULL, 0x000000020f0e7825ULL, 0x000fe200078e0042ULL,
0x000000101a347812ULL, 0x000fc600078efcffULL, 0x0000000211107825ULL, 0x000fe200078e0042ULL,
0x000000060e4b7981ULL, 0x0002a6000c1e9500ULL, 0x0000000134387824ULL, 0x000fe200078e0200ULL,
0x0000000669067248ULL, 0x000fe20003fe0000ULL, 0x00000006104e7981ULL, 0x0006a2000c1e9500ULL,
0x00000001770e7824ULL, 0x002fe400078e0234ULL, 0x000000193800720cULL, 0x000fe20003f06070ULL,
0x0000000506547c24ULL, 0x000fe2000f8e02ffULL, 0x00000050381b7246ULL, 0x000fc40003800069ULL,
0x000000500e0f7246ULL, 0x000fe20003800069ULL, 0x00000001070d7824ULL, 0x000fe200078e0254ULL,
0x000000190e00720cULL, 0x000fe40003f26070ULL, 0x00000004ff0f7819ULL, 0x000fe2000001160fULL,
0x000000020d0c7825ULL, 0x000fe200078e0042ULL, 0x000000ff1b1b7207ULL, 0x000fe40000000000ULL,
0x000000ff0f3b7207ULL, 0x000fe40000800000ULL, 0x000000521b0f7211ULL, 0x000fe200078fe0ffULL,
0x000000060c457981ULL, 0x000322000c1e9500ULL, 0x0000005449077211ULL, 0x000fc600078fe0ffULL,
0x000000020f0e7825ULL, 0x000fe200078e0042ULL, 0x00000050403d7246ULL, 0x000fc60003800069ULL,
0x0000000207067825ULL, 0x000fe200078e0042ULL, 0x000000060e3a7981ULL, 0x000b22000c1e9500ULL,
0x000000194000720cULL, 0x000fc60003f26070ULL, 0x00000006064c7981ULL, 0x000b22000c1e9500ULL,
0x0000000152117824ULL, 0x008fe200078e023bULL, 0x000000541b0d7211ULL, 0x002fe400078fe0ffULL,
0x00000004ff0e7819ULL, 0x020fe4000001163dULL, 0x000000193e00720cULL, 0x000fe20003f06070ULL,
0x000000013b077824ULL, 0x000fe200078e0254ULL, 0x000000ff0e417207ULL, 0x000fe40000800000ULL,
0x000000503e3d7246ULL, 0x000fe20003800069ULL, 0x0000000211107825ULL, 0x000fc600078e0042ULL,
0x000000ff3d3d7207ULL, 0x000fe20000000000ULL, 0x0000000207067825ULL, 0x100fe200078e0042ULL,
0x0000000610397981ULL, 0x0002e6000c1e9500ULL, 0x000000020d0c7825ULL, 0x000fe200078e0042ULL,
0x00000006063b7981ULL, 0x000ae6000c1e9500ULL, 0x00000001520f7824ULL, 0x000fe200078e0241ULL,
0x000000060c407981ULL, 0x000ae2000c1e9500ULL, 0x000000523d117211ULL, 0x002fc400078fe0ffULL,
0x000000020f0e7825ULL, 0x000fe200078e0042ULL, 0x0000005056477246ULL, 0x000fc60003800069ULL,
0x0000000141077824ULL, 0x020fe200078e0254ULL, 0x000000060e3f7981ULL, 0x000362000c1e9500ULL,
0x000000543d0d7211ULL, 0x000fe200078fe0ffULL, 0x0000000211107825ULL, 0x100fe200078e0042ULL,
0x000000195600720cULL, 0x080fe40003f26070ULL, 0x000000194800720cULL, 0x000fe20003f06070ULL,
0x0000000207067825ULL, 0x000fe200078e0042ULL, 0x0000000610467981ULL, 0x000364000c1e9500ULL,
0x00000004ff0e7819ULL, 0x002fe20000011647ULL, 0x000000020d0c7825ULL, 0x000fe200078e0042ULL,
0x0000005048477246ULL, 0x000fe20003800069ULL, 0x0000000606417981ULL, 0x000366000c1e9500ULL,
0x000000ff47477207ULL, 0x000fe20000000000ULL, 0x000000060c4a7981ULL, 0x000362000c1e9500ULL,
0x000000ff0e117207ULL, 0x000fc40000800000ULL, 0x00000052470f7211ULL, 0x000fc600078fe0ffULL,
0x00000001524d7824ULL, 0x000fc800078e0211ULL, 0x000000024d067825ULL, 0x002fc800078e0042ULL,
0x000000020f0c7825ULL, 0x000fe400078e0042ULL, 0x0000000606067981ULL, 0x000362000c1e9500ULL,
0x00000054470f7211ULL, 0x000fc600078fe0ffULL, 0x000000060c0d7981ULL, 0x000362000c1e9500ULL,
0x0000000111117824ULL, 0x000fe400078e0254ULL, 0x000000020f0e7825ULL, 0x000fc800078e0042ULL,
0x0000000211107825ULL, 0x000fe400078e0042ULL, 0x000000060e0e7981ULL, 0x000368000c1e9500ULL,
0x0000000610117981ULL, 0x000562000c1e9500ULL, 0xfffffff049507812ULL, 0x000fe200078ec0ffULL,
0x00000001ff497424ULL, 0x000fc800078e00ffULL, 0x0000000119077824ULL, 0x002fc800078e0250ULL,
0x0000000118587824ULL, 0x100fe200078e0a07ULL, 0x000000081a567812ULL, 0x040fe400078efcffULL,
0x000000091a547812ULL, 0x000fe400078efcffULL, 0x0000005849587219ULL, 0x000fe200000006ffULL,
0x0000000156507824ULL, 0x100fe400078e0200ULL, 0x00000001540c7824ULL, 0x000fe400078e0200ULL,
0x00000001505a7824ULL, 0x000fc400078e0a07ULL, 0x000000010c5c7824ULL, 0x000fe200078e0a07ULL,
0x000000181a6e7812ULL, 0x000fe400078efcffULL, 0xfffffff01b7c7812ULL, 0x000fe400078ec0ffULL,
0x0000005a495a7219ULL, 0x040fe400000006ffULL, 0x0000005c495c7219ULL, 0x000fe400000006ffULL,
0xfffffff03d3d7812ULL, 0x000fe400078ec0ffULL, 0xfffffff0470f7812ULL, 0x000fe200078ec0ffULL,
0x000000016e747824ULL, 0x000fe200078e0200ULL, 0x000000111a707812ULL, 0x000fc400078efcffULL,
0x000000191a6c7812ULL, 0x000fe200078efcffULL, 0x0000000119477824ULL, 0x040fe400078e023dULL,
0x0000000119517824ULL, 0x000fe400078e020fULL, 0x0000000170767824ULL, 0x100fe400078e0200ULL,
0x000000016c727824ULL, 0x000fe200078e0200ULL, 0x000000211a607812ULL, 0x040fe400078efcffULL,
0x000000281a5e7812ULL, 0x000fc600078efcffULL, 0x0000000160667824ULL, 0x100fe400078e0200ULL,
0x000000015e647824ULL, 0x000fe400078e0200ULL, 0x00000001664d7824ULL, 0x100fe400078e0a47ULL,
0x00000001644f7824ULL, 0x000fe400078e0a47ULL, 0x0000000148537824ULL, 0x000fe200078e0a51ULL,
0x0000004d494d7219ULL, 0x040fe400000006ffULL, 0x0000004f494f7219ULL, 0x000fc400000006ffULL,
0x0000005349537219ULL, 0x000fe400000006ffULL, 0x000054104e4b7816ULL, 0x004fe4000000004bULL,
0x000000011a4e7812ULL, 0x000fe400078efcffULL, 0x0000004b58ff7212ULL, 0x000fc8000780c0ffULL,
0x000000191800720cULL, 0x000fe20000701470ULL, 0x000000014e527824ULL, 0x000fc600078e0200ULL,
0x000000191a00720cULL, 0x000fe200007a1070ULL, 0x0000000152107824ULL, 0x000fe400078e0a07ULL,
0x0000000119077824ULL, 0x000fe200078e027cULL, 0xff80000013137808ULL, 0x000fe40002800000ULL,
0x0000001049107219ULL, 0x000fe200000006ffULL, 0x00000001380f7824ULL, 0x100fe400078e0a07ULL,
0x00000001743d7824ULL, 0x000fe200078e0a07ULL, 0x000054104c457816ULL, 0x010fc80000000045ULL,
0x0000004558ff7212ULL, 0x080fe4000784c0ffULL, 0x000000455aff7212ULL, 0x080fe400078cc0ffULL,
0x000000455cff7212ULL, 0x000fe400078ac0ffULL, 0x000000191800720cULL, 0x080fe40001741470ULL,
0x000000195000720cULL, 0x080fe400037c1470ULL, 0x000000190c00720cULL, 0x000fe20002fa1470ULL,
0x00000001761b7824ULL, 0x100fe200078e0a07ULL, 0x0000004510ff7212ULL, 0x000fe2000780c0ffULL,
0x0000000172457824ULL, 0x000fe200078e0a07ULL, 0x000000191a00720cULL, 0x000fc40001741070ULL,
0x000000195600720cULL, 0x080fe400037c1070ULL, 0x000000195400720cULL, 0x000fe40002fa1070ULL,
0x0000000f49077219ULL, 0x040fe400000006ffULL, 0x0000003d493d7219ULL, 0x000fe400000006ffULL,
0x000054103a3a7816ULL, 0x008fe40000000039ULL, 0x0000541040407816ULL, 0x000fc4000000003bULL,
0xff80000036367808ULL, 0x000fe40001000000ULL, 0xff80000032327808ULL, 0x000fe40003000000ULL,
0xff80000033337808ULL, 0x000fe40002800000ULL, 0x0000004b10ff7212ULL, 0x080fe4000782c0ffULL,
0x0000004b5aff7212ULL, 0x080fe4000786c0ffULL, 0x0000004b5cff7212ULL, 0x000fc4000788c0ffULL,
0x0000003a07ff7212ULL, 0x040fe4000784c0ffULL, 0x0000004007ff7212ULL, 0x080fe400078cc0ffULL,
0x000000403dff7212ULL, 0x000fe200078ac0ffULL, 0x000000013e4b7824ULL, 0x000fe200078e0a47ULL,
0x000000195200720cULL, 0x0c0fe40000f21470ULL, 0x000000195200720cULL, 0x080fe40000701470ULL,
0x000000195000720cULL, 0x000fc40001f61470ULL, 0x000000190c00720cULL, 0x080fe40002781470ULL,
0x000000193800720cULL, 0x0c0fe40001741470ULL, 0x000000193800720cULL, 0x080fe400037c1470ULL,
0x000000197400720cULL, 0x080fe40002fa1470ULL, 0x000000291a5c7812ULL, 0x000fe400078efcffULL,
0x000000194e00720cULL, 0x000fc40000f21070ULL, 0x000000194e00720cULL, 0x080fe40000701070ULL,
0x000000195600720cULL, 0x080fe40001f61070ULL, 0x000000195400720cULL, 0x080fe40002781070ULL,
0x000000193400720cULL, 0x0c0fe40001741070ULL, 0x000000193400720cULL, 0x080fe400037c1070ULL,
0x000000196e00720cULL, 0x000fc40002fa1070ULL, 0x0000001b490f7219ULL, 0x040fe400000006ffULL,
0x0000004549457219ULL, 0x040fe400000006ffULL, 0x0000004b494b7219ULL, 0x000fe400000006ffULL,
0x00005410463f7816ULL, 0x020fe4000000003fULL, 0x000054104a4a7816ULL, 0x000fe20000000041ULL,
0x000000015c627824ULL, 0x000fe200078e0200ULL, 0xff80000035357808ULL, 0x000fc40000800000ULL,
0xff80000037377808ULL, 0x000fe40000000000ULL, 0xff80000030307808ULL, 0x000fe40001800000ULL,
0xff80000031317808ULL, 0x000fe40002000000ULL, 0xff8000002c2c7808ULL, 0x000fe40001000000ULL,
0xff8000002e2e7808ULL, 0x000fe40003000000ULL, 0xff8000002a2a7808ULL, 0x000fc40002800000ULL,
0x0000003a0fff7212ULL, 0x080fe4000782c0ffULL, 0x0000003a3dff7212ULL, 0x080fe4000780c0ffULL,
0x0000003a45ff7212ULL, 0x000fe4000786c0ffULL, 0x000000400fff7212ULL, 0x080fe4000788c0ffULL,
0x0000004045ff7212ULL, 0x000fe4000784c0ffULL, 0x0000003f4bff7212ULL, 0x000fc400078cc0ffULL,
0x0000004a4bff7212ULL, 0x000fe200078ac0ffULL, 0x0000000162477824ULL, 0x000fe200078e0a47ULL,
0x000000197600720cULL, 0x0c0fe40000f21470ULL, 0x000000197600720cULL, 0x080fe40002781470ULL,
0x000000197400720cULL, 0x080fe40000701470ULL, 0x000000197200720cULL, 0x0c0fe40001f61470ULL,
0x000000197200720cULL, 0x000fc40001741470ULL, 0x000000193e00720cULL, 0x0c0fe400037c1470ULL,
0x000000193e00720cULL, 0x080fe40002fa1470ULL, 0x000000311a587812ULL, 0x040fe400078efcffULL,
0x000000381a4c7812ULL, 0x040fe400078efcffULL, 0x000000391a107812ULL, 0x000fe400078efcffULL,
0x000000197000720cULL, 0x000fc40000f21070ULL, 0x000000197000720cULL, 0x080fe40002781070ULL,
0x000000196e00720cULL, 0x080fe40000701070ULL, 0x000000196c00720cULL, 0x0c0fe40001f61070ULL,
0x000000196c00720cULL, 0x080fe40001741070ULL, 0x000000193c00720cULL, 0x0c0fe400037c1070ULL,
0x000000193c00720cULL, 0x000fc40002fa1070ULL, 0x0000004749477219ULL, 0x000fe400000006ffULL,
0x000054100d067816ULL, 0x000fe20000000006ULL, 0x00000001585a7824ULL, 0x100fe200078e0200ULL,
0xff8000002d2d7808ULL, 0x000fe20000800000ULL, 0x000000014c687824ULL, 0x100fe200078e0200ULL,
0xff8000002f2f7808ULL, 0x000fe20002000000ULL, 0x00000001107c7824ULL, 0x000fe200078e0200ULL,
0xff80000028287808ULL, 0x000fe40000000000ULL, 0xff80000029297808ULL, 0x000fc40001800000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff80000024247808ULL, 0x000fe40003000000ULL,
0xff80000026267808ULL, 0x000fe40002800000ULL, 0x0000003f4dff7212ULL, 0x080fe4000782c0ffULL,
0x0000003f4fff7212ULL, 0x080fe4000788c0ffULL, 0x0000003f47ff7212ULL, 0x000fc4000780c0ffULL,
0x0000004a4dff7212ULL, 0x080fe4000786c0ffULL, 0x0000004a4fff7212ULL, 0x080fe4000784c0ffULL,
0x0000004a47ff7212ULL, 0x000fe400078cc0ffULL, 0x0000000653ff7212ULL, 0x000fe200078ac0ffULL,
0x000000015a557824ULL, 0x100fe200078e0a51ULL, 0x000000196600720cULL, 0x080fe20000f21470ULL,
0x0000000168577824ULL, 0x100fe200078e0a51ULL, 0x000000196600720cULL, 0x080fe20001f61470ULL,
0x000000017c517824ULL, 0x000fe200078e0a51ULL, 0x000000196400720cULL, 0x000fc40002781470ULL,
0x000000196400720cULL, 0x080fe40001741470ULL, 0x000000196200720cULL, 0x0c0fe40000701470ULL,
0x000000196200720cULL, 0x080fe400037c1470ULL, 0x000000194800720cULL, 0x080fe40002fa1470ULL,
0x000000196000720cULL, 0x0c0fe40000f21070ULL, 0x000000196000720cULL, 0x000fc40001f61070ULL,
0x000000195e00720cULL, 0x0c0fe40002781070ULL, 0x000000195e00720cULL, 0x080fe40001741070ULL,
0x000000195c00720cULL, 0x0c0fe40000701070ULL, 0x000000195c00720cULL, 0x080fe400037c1070ULL,
0x000000194400720cULL, 0x000fe40002fa1070ULL, 0x0000005549557219ULL, 0x000fc400000006ffULL,
0x0000005749577219ULL, 0x040fe400000006ffULL, 0x0000005149517219ULL, 0x000fe400000006ffULL,
0x000054100e0e7816ULL, 0x000fe40000000011ULL, 0xff80000025257808ULL, 0x000fe40000800000ULL,
0xff80000027277808ULL, 0x000fe40001800000ULL, 0xff80000020207808ULL, 0x000fc40002000000ULL,
0xff80000022227808ULL, 0x000fe40001000000ULL, 0xff80000021217808ULL, 0x000fe40000000000ULL,
0xff80000023237808ULL, 0x000fe40003000000ULL, 0xff8000001c1c7808ULL, 0x000fe40002800000ULL,
0x0000000655ff7212ULL, 0x080fe4000782c0ffULL, 0x0000000657ff7212ULL, 0x000fc4000786c0ffULL,
0x0000000651ff7212ULL, 0x000fe4000788c0ffULL, 0x0000000e53ff7212ULL, 0x080fe4000784c0ffULL,
0x0000000e55ff7212ULL, 0x080fe4000780c0ffULL, 0x0000000e57ff7212ULL, 0x080fe400078cc0ffULL,
0x0000000e51ff7212ULL, 0x000fe400078ac0ffULL, 0x000000194800720cULL, 0x000fc40001741470ULL,
0x000000195a00720cULL, 0x0c0fe40000f21470ULL, 0x000000195a00720cULL, 0x080fe40000701470ULL,
0x000000196800720cULL, 0x0c0fe40001f61470ULL, 0x000000196800720cULL, 0x080fe400037c1470ULL,
0x000000197c00720cULL, 0x0c0fe40002781470ULL, 0x000000197c00720cULL, 0x000fc40002fa1470ULL,
0x000000194400720cULL, 0x080fe40001741070ULL, 0x000000195800720cULL, 0x0c0fe40000f21070ULL,
0x000000195800720cULL, 0x080fe40000701070ULL, 0x000000194c00720cULL, 0x0c0fe40001f61070ULL,
0x000000194c00720cULL, 0x080fe400037c1070ULL, 0x000000191000720cULL, 0x000fc40002781070ULL,
0x000000191000720cULL, 0x000fe40002fa1070ULL, 0xff8000001d1d7808ULL, 0x000fe40000800000ULL,
0xff80000014147808ULL, 0x000fe40001800000ULL, 0xff80000015157808ULL, 0x000fe40002000000ULL,
0xff8000001e1e7808ULL, 0x000fe40001000000ULL, 0xff8000001f1f7808ULL, 0x000fc40000000000ULL,
0xff80000016167808ULL, 0x000fe40003000000ULL, 0xff80000017177808ULL, 0x000fce0002800000ULL,
0x000000130800720bULL, 0x000fe20003f1e000ULL, 0x0c401f000a117f89ULL, 0x000fe200000e0000ULL,
0x000000016f6f7836ULL, 0x000fe40000000000ULL, 0x0000000813087208ULL, 0x000fc80004000000ULL,
0x000000350800720bULL, 0x000fc80003f1e000ULL, 0x0000000835077208ULL, 0x000fc80004000000ULL,
0x000000300700720bULL, 0x000fc80003f1e000ULL, 0x0000000730067208ULL, 0x000fc80004000000ULL,
0x000000310600720bULL, 0x000fc80003f1e000ULL, 0x0000000631077208ULL, 0x000fc80004000000ULL,
0x0000002c0700720bULL, 0x000fc80003f1e000ULL, 0x000000072c067208ULL, 0x000fc80004000000ULL,
0x0000002d0600720bULL, 0x000fc80003f1e000ULL, 0x000000062d077208ULL, 0x000fc80004000000ULL,
0x000000280700720bULL, 0x000fc80003f1e000ULL, 0x0000000728067208ULL, 0x000fc80004000000ULL,
0x000000290600720bULL, 0x000fc80003f1e000ULL, 0x0000000629077208ULL, 0x000fc80004000000ULL,
0x000000240700720bULL, 0x000fc80003f1e000ULL, 0x0000000724067208ULL, 0x000fc80004000000ULL,
0x000000250600720bULL, 0x000fc80003f1e000ULL, 0x0000000625077208ULL, 0x000fc80004000000ULL,
0x000000200700720bULL, 0x000fc80003f1e000ULL, 0x0000000720067208ULL, 0x000fe40004000000ULL,
0x000000360900720bULL, 0x000fe40003f1e000ULL, 0x000000210600720bULL, 0x000fc80003f3e000ULL,
0x0000000621077208ULL, 0x000fe40004800000ULL, 0x0000000936067208ULL, 0x000fe40004000000ULL,
0x0000001c0700720bULL, 0x000fe40003f3e000ULL, 0x000000370600720bULL, 0x000fe40003f1e000ULL,
0x000000071c087208ULL, 0x000fe40004800000ULL, 0x0000000637077208ULL, 0x000fc40004000000ULL,
0x0000001d0800720bULL, 0x000fe40003f3e000ULL, 0x000000320700720bULL, 0x000fe40003f1e000ULL,
0x000000081d097208ULL, 0x000fe40004800000ULL, 0x0000000732067208ULL, 0x000fe40004000000ULL,
0x000000140900720bULL, 0x000fe40003f3e000ULL, 0x000000330600720bULL, 0x000fc40003f1e000ULL,
0x0000000914087208ULL, 0x000fe40004800000ULL, 0x0000000633077208ULL, 0x000fe40004000000ULL,
0x000000150800720bULL, 0x000fe40003f3e000ULL, 0x0000002e0700720bULL, 0x000fe40003f1e000ULL,
0x0000000815087208ULL, 0x000fe40004800000ULL, 0x000000072e067208ULL, 0x000fc60004000000ULL,
0x0c401f0008097f89ULL, 0x000e6200000e0000ULL, 0x0000002f0600720bULL, 0x000fc80003f1e000ULL,
0x000000062f077208ULL, 0x000fc80004000000ULL, 0x0000002a0700720bULL, 0x000fc80003f1e000ULL,
0x000000072a067208ULL, 0x000fc80004000000ULL, 0x0000002b0600720bULL, 0x000fc80003f1e000ULL,
0x000000062b077208ULL, 0x000fe40004000000ULL, 0x000000090800720bULL, 0x002fe40003f3e000ULL,
0x000000260700720bULL, 0x000fe40003f1e000ULL, 0x0000000809097208ULL, 0x000fe40004800000ULL,
0x0000000726067208ULL, 0x000fc60004000000ULL, 0x0c201f0009087f89ULL, 0x000e6200000e0000ULL,
0x000000270600720bULL, 0x000fc80003f1e000ULL, 0x0000000627077208ULL, 0x000fc80004000000ULL,
0x000000220700720bULL, 0x000fc80003f1e000ULL, 0x0000000722067208ULL, 0x000fc80004000000ULL,
0x000000230600720bULL, 0x000fc80003f1e000ULL, 0x0000000623077208ULL, 0x000fe40004000000ULL,
0x000000080900720bULL, 0x002fe40003f3e000ULL, 0x0000001e0700720bULL, 0x000fe40003f1e000ULL,
0x0000000908087208ULL, 0x000fe40004800000ULL, 0x000000071e067208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b080c7820ULL, 0x000fe20000410000ULL, 0x0000001f0600720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001080cULL, 0x000000061f077208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b35357823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001080cULL, 0x000000160700720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001080cULL, 0x0000000716067208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001080cULL, 0x000000170600720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001080cULL, 0x0000000617067208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b150c7823ULL, 0x000fe2000001080cULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x0c401f0006077f89ULL, 0x000e6e00000e0000ULL, 0x00000035000e7308ULL, 0x000eb00000000800ULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000003100317308ULL, 0x000ee20000000800ULL,
0x000000070600720bULL, 0x002fc80003f1e000ULL, 0x0000000607067208ULL, 0x000fe20004000000ULL,
0x3c003c00ff077424ULL, 0x000fe400078e00ffULL, 0x0000000c00397308ULL, 0x0005e40000000800ULL,
0x0c201f0006097f89ULL, 0x000e6c00000e0000ULL, 0x0000002400347308ULL, 0x000fe20000000800ULL,
0x000000130e0c723eULL, 0x004fc400000000ffULL, 0x00000030310e723eULL, 0x008fca00000000ffULL,
0x0000002500357308ULL, 0x000ff00000000800ULL, 0x00000028001a7308ULL, 0x000fe20000000800ULL,
0x000000090600720bULL, 0x002fc80003f1e000ULL, 0x0000000609097208ULL, 0x000fc60004000000ULL,
0x0000002c00187308ULL, 0x000fe20000000800ULL, 0x000000110a00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b09157820ULL, 0x000fc60000410000ULL, 0x0000000a110a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010815ULL,
0x00000036000d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010815ULL,
0x0000003700067308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x000fe20000010815ULL,
0xfffffff8ff117812ULL, 0x000fcc00078ee26aULL, 0x00000032000f7308ULL, 0x000fe20000000800ULL,
0x0000000d060d723eULL, 0x002fce00000000ffULL, 0x0000003300107308ULL, 0x000e620000000800ULL,
0x3c003c00ff067424ULL, 0x000fce00078e00ffULL, 0x0000002a001b7308ULL, 0x0005e20000000800ULL,
0x0000000f100f723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b26107823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b272a7823ULL, 0x004fca0000010815ULL, 0x0000001400287308ULL, 0x000fe20000000800ULL,
0x000000060c24723cULL, 0x000fee00000018ffULL, 0x0000002d002d7308ULL, 0x000e700000000800ULL,
0x0000002900297308ULL, 0x000ea20000000800ULL, 0x000000182d18723eULL, 0x002fce00000000ffULL,
0x0000002e00197308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b172d7823ULL, 0x000fe20000010815ULL,
0x0000001a291a723eULL, 0x004fcc00000000ffULL, 0x0000002f00147308ULL, 0x000e700000000800ULL,
0x0000002b002c7308ULL, 0x0004e20000000800ULL, 0x000000191419723eULL, 0x002fce00000000ffULL,
0x0000001000137308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b162b7823ULL, 0x004fe20000010815ULL,
0x000000343514723eULL, 0x000fe400000000ffULL, 0x0000001b2c1b723eULL, 0x008fc800000000ffULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x0c401f000b107f89ULL, 0x002e6400000e0000ULL,
0x000000061824723cULL, 0x000fea0000001824ULL, 0x0000002100217308ULL, 0x000eb00000000800ULL,
0x0000002a002a7308ULL, 0x000ee20000000800ULL, 0x000000202116723eULL, 0x004fce00000000ffULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x000000100b00720bULL, 0x002fe40003f3e000ULL,
0x0000000802217c11ULL, 0x000fe4000f8e58ffULL, 0x0000000b100b7208ULL, 0x000fe40004800000ULL,
0x000000132a15723eULL, 0x008fe200000000ffULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x00000003ff107819ULL, 0x000fc80000011603ULL, 0x0000000310107812ULL, 0x000fc600078ec0ffULL,
0x0000001c001c7308ULL, 0x000fe40000000800ULL, 0x0000000110137824ULL, 0x000fe200078e0211ULL,
0x000000222317723eULL, 0x002fca00000000ffULL, 0x0000001d001d7308ULL, 0x000e620000000800ULL,
0x0000000811237836ULL, 0x000fe40000000000ULL, 0x0000000413227836ULL, 0x000fe20000000000ULL,
0x000000061424723cULL, 0x000fe80000001824ULL, 0x0000001e00297308ULL, 0x0005e20000000800ULL,
0x0000001c1d1c723eULL, 0x002fce00000000ffULL, 0x0000001f002c7308ULL, 0x000e620000000800ULL,
0x00000028391e723eULL, 0x004fe200000000ffULL, 0x0000000110287824ULL, 0x000fe400078e0223ULL,
0x0c201f000b107f89ULL, 0x000ea200000e0000ULL, 0x000000ffff2a7224ULL, 0x000fc600078e001cULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x000000292c1d723eULL, 0x002fce00000000ffULL,
0x0000002d00207308ULL, 0x000e620000000800ULL, 0x0000000811297824ULL, 0x000fe400078e00ffULL,
0x00000008232c7824ULL, 0x000fc600078e00ffULL, 0xfffffff829227812ULL, 0x000fe200078ee222ULL,
0x000000ffff297224ULL, 0x000fe400078e0016ULL, 0x000000ffff167224ULL, 0x000fe200078e001dULL,
0x000000100b00720bULL, 0x004fe40003f3e000ULL, 0x0000002b201f723eULL, 0x002fe200000000ffULL,
0x0000000811207824ULL, 0x000fe200078e00ffULL, 0x0000000b100b7208ULL, 0x000fe20004800000ULL,
0x0c201f000a117f89ULL, 0x000e6200000e0000ULL, 0x00000008232b7824ULL, 0x000fc400078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee213ULL, 0x000000061c24723cULL, 0x000fe20000001824ULL,
0x0000000c13237836ULL, 0x000fe20000000000ULL, 0xfffffff82b287812ULL, 0x000fe200078ee228ULL,
0x0001100021137836ULL, 0x000fe40000000000ULL, 0x000000ffff217224ULL, 0x000fe200078e000eULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee223ULL, 0x0000001020067824ULL, 0x100fe400078e0213ULL,
0x0000001022077824ULL, 0x000fc400078e0213ULL, 0x000000ffff207224ULL, 0x000fe400078e000cULL,
0x000000ffff227224ULL, 0x000fe400078e0018ULL, 0x000000ffff237224ULL, 0x000fe400078e001aULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff2b7224ULL, 0x000fe200078e001eULL,
0x000000110a00720bULL, 0x002fe20003f1e000ULL, 0x0000001028257824ULL, 0x000fe200078e0213ULL,
0x0000002006007844ULL, 0x0003e20000000200ULL, 0x000000ffff287224ULL, 0x000fe200078e0014ULL,
0x0000000a110a7208ULL, 0x000fe20004000000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e000fULL,
0x0000000303ff7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0x0000002807007844ULL, 0x000fe20000000200ULL, 0x000000ffff0e7224ULL, 0x000fc400078e0019ULL,
0x000000ffff0f7224ULL, 0x000fe400078e001bULL, 0x000000ffff157224ULL, 0x000fe400078e0017ULL,
0x000000102c2c7824ULL, 0x000fe200078e0213ULL, 0x0000000c25007844ULL, 0x0005e20000000200ULL,
0x000000ffff177224ULL, 0x000fe400078e001fULL, 0x000000ffff107224ULL, 0x000fe400078e0024ULL,
0x000000ffff117224ULL, 0x000fe200078e0026ULL, 0x000000142c007844ULL, 0x0007e20000000200ULL,
0x00000001ff067424ULL, 0x002fc600078e00ffULL, 0x0170000812008388ULL, 0x0007e80000000c00ULL,
0x0172001012008388ULL, 0x0007e20000000a00ULL, 0x0000007b6f00720cULL, 0x000fe20003f06070ULL,
0x0176080679ff79a7ULL, 0x0007e2000850003fULL, 0x000000ffff0c7224ULL, 0x004fe200078e0078ULL,
0x0176100679ff79a7ULL, 0x0007e2000850003fULL, 0x0176180679ff79a7ULL, 0x0007e2000850003fULL,
0x0176200679ff79a7ULL, 0x0007f0000850003fULL, 0xffffffac00b08947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000008007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000800008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff08ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000008027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000800007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffed4020c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL,
0x0000000000000577ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006f8ULL,
0x0000000000000258ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000950ULL,
0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a30ULL,
0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a84ULL,
0x0000000000000670ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010f8ULL,
0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010f8ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001140ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL,
0x0000000000012c80ULL, 0x0000001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000013e00ULL,
0x0000000000000048ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000013e50ULL,
0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000013e50ULL,
0x0000000000000270ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x0000000000014440ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000014440ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001140ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012c80ULL, 0x0000000000012c80ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000013e00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000013e50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000270ULL,
0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_16_sm_90_cubin_len = 83344;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
