/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000014c50ULL, 0x00000000000148d0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL,
0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL,
0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL,
0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL,
0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000030ULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000001baULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000034ULL,
0x0000000000000004ULL, 0x000c00010000028dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000002dbULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000329ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c0001000003c5ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c00010000040bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000459ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000049fULL, 0x0000000000012c70ULL,
0x0000000000000180ULL, 0x000b0022000004d2ULL, 0x0000000000012df0ULL, 0x0000000000000040ULL,
0x000b0022000004fdULL, 0x0000000000012e30ULL, 0x0000000000000050ULL, 0x000b002200000527ULL,
0x0000000000012e80ULL, 0x0000000000000100ULL, 0x000a000300000595ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005b5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005e5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000012f80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00012c7000000000ULL,
0x0000040400000000ULL, 0x810c000001880400ULL, 0x0049880400288080ULL, 0x0000000000000000ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8308288080820828ULL, 0x2880808508288080ULL,
0x808c082880808708ULL, 0x082880808f082880ULL, 0x8080910828808090ULL, 0x9308288080920828ULL,
0x2880809408288080ULL, 0x8096082880809508ULL, 0x082880809c082880ULL, 0x8080ac08288080abULL,
0x8408288080b60828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808084920000ULL,
0x0000000000000022ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x00012c7000000000ULL,
0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL,
0x2880808228808084ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8308288080820828ULL,
0x2880808408288080ULL, 0x8086082880808508ULL, 0x0828808087082880ULL, 0x808090082880808eULL,
0x9208288080910828ULL, 0x2880809308288080ULL, 0x8095082880809408ULL, 0x0828808096082880ULL,
0x8080ab082880809cULL, 0xb608288080ac0828ULL, 0x2880808c08288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x000022002880808cULL, 0x0000001cffffffffULL, 0x0000015800000000ULL,
0x00012df000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000009cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8308288080820828ULL, 0x2880808408288080ULL, 0x8087082880808508ULL,
0x082880808c082880ULL, 0x808090082880808fULL, 0x9208288080910828ULL, 0x2880809408288080ULL,
0x8096082880809508ULL, 0x082880809c082880ULL, 0x8080ac08288080abULL, 0x9308288080b60828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808093920000ULL, 0x0000000000000022ULL,
0x0000002cffffffffULL, 0x0000022800000000ULL, 0x00012e3000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x8092288080930900ULL, 0x0000000000002880ULL, 0x0000009cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8308288080820828ULL, 0x2880808408288080ULL, 0x8087082880808508ULL,
0x082880808c082880ULL, 0x808090082880808fULL, 0x9308288080910828ULL, 0x2880809408288080ULL,
0x8096082880809508ULL, 0x082880809c082880ULL, 0x8080ac08288080abULL, 0x9208288080b60828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808092920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x0000030800000000ULL, 0x00012e8000000000ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x0008230400000080ULL, 0x0000000000000017ULL,
0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL,
0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0008230400000000ULL, 0x000000000000001bULL, 0x0000001b00081204ULL, 0x0008110400000000ULL,
0x000000000000001bULL, 0x0000007b00043704ULL, 0x0000001800080a04ULL, 0x0060190300600160ULL,
0x00000000000c1704ULL, 0x0021f0000058000aULL, 0x00000000000c1704ULL, 0x0021f00000500009ULL,
0x00000000000c1704ULL, 0x0011f00000480008ULL, 0x00000000000c1704ULL, 0x0061f00000300007ULL,
0x00000000000c1704ULL, 0x0021f00000280006ULL, 0x00000000000c1704ULL, 0x0021f00000200005ULL,
0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL, 0x0021f00000100003ULL,
0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL, 0x0011f00000040001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400801b03ULL, 0x0134290400000b70ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01342804ffffffffULL, 0x0000053000000460ULL,
0x0000263000000570ULL, 0x00002800000026e0ULL, 0x00002dd000002960ULL, 0x00002e5000002e00ULL,
0x00004cf000002ea0ULL, 0x00004ea000004d80ULL, 0x0000548000005000ULL, 0x00005500000054b0ULL,
0x0000736000005550ULL, 0x0000753000007400ULL, 0x00007b1000007690ULL, 0x00007b9000007b40ULL,
0x0000993000007be0ULL, 0x00009af0000099d0ULL, 0x0000a11000009c50ULL, 0x0000a1900000a140ULL,
0x0000b3c00000a1e0ULL, 0x000115700000b3d0ULL, 0x000115c0000115b0ULL, 0x000115e0000115d0ULL,
0x0001166000011640ULL, 0x000122b000011680ULL, 0x00012340000122f0ULL, 0x000123d000012380ULL,
0x0001247000012420ULL, 0x00012500000124b0ULL, 0x0001259000012540ULL, 0x00012630000125e0ULL,
0x000126c000012670ULL, 0x0001275000012700ULL, 0x000127f0000127a0ULL, 0x0001288000012830ULL,
0x00012910000128c0ULL, 0x000129b000012960ULL, 0x00012a7000012a10ULL, 0x00012b3000012ad0ULL,
0x00012bf000012b90ULL, 0x0440390400012c50ULL, 0x000000ff000003f0ULL, 0x003f01000000f600ULL,
0x0000001100000490ULL, 0x003f01200000f608ULL, 0x00000011000004d0ULL, 0x003f01200000f688ULL,
0x00000011000004f0ULL, 0x003f01200000f6a8ULL, 0x0000001100000500ULL, 0x003f01200000f6c8ULL,
0x000000ff00000b90ULL, 0x003f01070000f600ULL, 0x0000000a00000ce0ULL, 0x003f01020000f68cULL,
0x0000000a00000d70ULL, 0x003f01010000f688ULL, 0x000000ff000015a0ULL, 0x0004010700000000ULL,
0x000000ff00001620ULL, 0x0004010100000000ULL, 0x0000000400001680ULL, 0x003f010100000020ULL,
0x00000007000017d0ULL, 0x003f01050000f6ccULL, 0x00000007000019b0ULL, 0x003f01050000f6ccULL,
0x0000000d000021d0ULL, 0x003f01070000f6b0ULL, 0x0000000d00002290ULL, 0x003f01010000f6b0ULL,
0x00000030000022f0ULL, 0x003f01010000f608ULL, 0x0000000700002330ULL, 0x003f01050000f60cULL,
0x0000000700002510ULL, 0x003f01050000f60cULL, 0x0000003200002b30ULL, 0x003f01050000f6acULL,
0x0000003200002d00ULL, 0x003f01050000f6acULL, 0x0000003400003f60ULL, 0x003f010100000000ULL,
0x0000000f00003fc0ULL, 0x003f01010000f688ULL, 0x0000000800003fe0ULL, 0x003f010500000004ULL,
0x00000008000041b0ULL, 0x003f010500000004ULL, 0x000000ff00004900ULL, 0x0004010700000000ULL,
0x000000ff000049d0ULL, 0x0004010100000000ULL, 0x0000000f00004a30ULL, 0x003f01010000f628ULL,
0x0000000700004a50ULL, 0x003f01050000f62cULL, 0x0000000700004c20ULL, 0x003f01050000f62cULL,
0x00000038000051e0ULL, 0x003f01050000f6b4ULL, 0x00000038000053b0ULL, 0x003f01050000f6b4ULL,
0x00000012000065c0ULL, 0x003f010100000000ULL, 0x0000006b00006620ULL, 0x003f01010000f690ULL,
0x0000000800006640ULL, 0x003f010500000004ULL, 0x0000000800006810ULL, 0x003f010500000004ULL,
0x000000ff00006f70ULL, 0x0004010700000008ULL, 0x0000001c00007000ULL, 0x003f01010000f6b0ULL,
0x0000000700007060ULL, 0x003f01010000f648ULL, 0x00000007000070c0ULL, 0x003f01050000f64cULL,
0x0000000700007290ULL, 0x003f01050000f64cULL, 0x0000003100007870ULL, 0x003f01050000f6acULL,
0x0000003100007a40ULL, 0x003f01050000f6acULL, 0x0000000800008b60ULL, 0x003f010100000000ULL,
0x0000000c00008bc0ULL, 0x003f010100000000ULL, 0x0000000800008be0ULL, 0x003f010500000004ULL,
0x0000000800008db0ULL, 0x003f010500000004ULL, 0x000000ff00009550ULL, 0x0004010700000000ULL,
0x000000ff00009620ULL, 0x0004010100000000ULL, 0x0000000f00009680ULL, 0x003f01010000f668ULL,
0x0000000f000096b0ULL, 0x003f01050000f66cULL, 0x0000000f00009880ULL, 0x003f01050000f66cULL,
0x0000001e00009e30ULL, 0x003f01050000f6b4ULL, 0x0000001e0000a030ULL, 0x003f01050000f6b4ULL,
0x000000080000b190ULL, 0x003f010100000000ULL, 0x000000070000b210ULL, 0x003f010100000000ULL,
0x000000ff0000c530ULL, 0x003f01010000f600ULL, 0x000000ff0000d110ULL, 0x003f01050000f604ULL,
0x000000ff0000d320ULL, 0x003f01050000f604ULL, 0x000000ff0000d550ULL, 0x003f01010000f600ULL,
0x000000ff0000d580ULL, 0x003f01050000f604ULL, 0x000000ff0000d740ULL, 0x003f01050000f604ULL,
0x000000790000f900ULL, 0x003f010100000000ULL, 0x000000790000f9d0ULL, 0x003f010500000004ULL,
0x000000790000fba0ULL, 0x003f010500000004ULL, 0x0000007c00012110ULL, 0x003f010100000000ULL,
0x0000007c00012170ULL, 0x003f010100000008ULL, 0x0000007c000121d0ULL, 0x003f010100000010ULL,
0x0000007c00012240ULL, 0x003f010100000018ULL, 0x00201c0400053803ULL, 0x0000bc500000bc20ULL,
0x0000c0d00000bee0ULL, 0x0000c4800000c2d0ULL, 0x000122800000d7a0ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x00000000000003c4ULL, 0x0000001b00000002ULL, 0x00000000000002e4ULL,
0x0000001b00000002ULL, 0x0000000000000214ULL, 0x0000001b00000002ULL, 0x000000000000012cULL,
0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL, 0x000000000000039aULL,
0x0000001b00000002ULL, 0x00000000000002baULL, 0x0000001b00000002ULL, 0x00000000000001efULL,
0x0000001b00000002ULL, 0x0000000000000102ULL, 0x0000001b00000002ULL, 0x000000000000f700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000057919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff020424ULL, 0x000fe200078e00ffULL,
0x0000000105060810ULL, 0x002fca0007ffe0ffULL, 0x00005c0006060625ULL, 0x000fc800078e0002ULL,
0x00005c0005020625ULL, 0x000fe200078e0002ULL, 0x0000000606000981ULL, 0x0002aa000c1e1900ULL,
0x0000000602030981ULL, 0x0006a2000c1e1900ULL, 0x0000590000047b06ULL, 0x000f220000209000ULL,
0x00005900ff007a0cULL, 0x000fe40003f65070ULL, 0x00000000000c7919ULL, 0x000ee20000002600ULL,
0x00005900ff067624ULL, 0x002fc600078e00ffULL, 0x0000000000127919ULL, 0x000e680000002300ULL,
0x00000000000d7919ULL, 0x000e620000002100ULL, 0x0000000400047308ULL, 0x010f240000001000ULL,
0x0ffffffe04087810ULL, 0x010fe40007ffe0ffULL, 0x00000005ff107819ULL, 0x002fc8000001160dULL,
0x0000000800097305ULL, 0x000324000021f000ULL, 0x000000ffff087224ULL, 0x002fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x010fc800078e0a09ULL, 0x000059000b0b7a24ULL, 0x000fc800078e02ffULL,
0x0000000b09097227ULL, 0x000fcc00078e0008ULL, 0x0000040009077a27ULL, 0x000fc800078e00ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a07ULL, 0x0000040009027624ULL, 0x008fca00078e0206ULL,
0x0000590002007a0cULL, 0x000fda0003f26070ULL, 0x8000590002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x0000590002007a0cULL, 0x000fda0003f46070ULL,
0x0000000107072810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff07ba12ULL, 0x000fc800078e33ffULL,
0x0000000700027306ULL, 0x000e620000209000ULL, 0x000000ff0700720cULL, 0x000fce0003f85070ULL,
0x0000000200027308ULL, 0x002e640000001000ULL, 0x0ffffffe02087810ULL, 0x002fcc0007ffe0ffULL,
0x0000000800097305ULL, 0x0002e4000021f000ULL, 0x000000ffff087224ULL, 0x002fe400078e00ffULL,
0x0000000907047224ULL, 0x008fc800078e02ffULL, 0x000000ffff0b7224ULL, 0x000fc800078e0a04ULL,
0x0000000b09097227ULL, 0x000fe400078e0008ULL, 0x00000000000b7919ULL, 0x000e680000002200ULL,
0x0000000c09727227ULL, 0x000fc800078e00ffULL, 0x000000ffff027224ULL, 0x000fc800078e0a72ULL,
0x0000000207027224ULL, 0x000fca00078e020cULL, 0x000000070200720cULL, 0x000fe20003fa6070ULL,
0x0000010012047a24ULL, 0x002fc800078e020bULL, 0x0000000004117a24ULL, 0x000fd000078e020dULL,
0x0000000102025824ULL, 0x000fe200078e0a07ULL, 0x0000000172725810ULL, 0x000fe40007ffe0ffULL,
0x000000ff1100720cULL, 0x040fe40003f65270ULL, 0x000000070200720cULL, 0x000fe40003fc6070ULL,
0x0000007f1100780cULL, 0x040fe40003f44070ULL, 0x0000000f1100780cULL, 0x040fe40003f24070ULL,
0x000000031100780cULL, 0x000fca0003fa4070ULL, 0x3fffff80ff08b424ULL, 0x000fe400078e00ffULL,
0x0000000172726810ULL, 0x000fe20007ffe0ffULL, 0x7fffff80ff09b424ULL, 0x000fe200078e00ffULL,
0x00000007ff72c212ULL, 0x000fe200078e33ffULL, 0xff317217ff04a424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0a9424ULL, 0x000fe200078e00ffULL, 0x00f60008ff00b388ULL, 0x0003e20000000a00ULL,
0x000000ffff7b7224ULL, 0x000fe200078e0a72ULL, 0x000000011100780cULL, 0x000fe20003f64070ULL,
0x7fffffc0ff0b9424ULL, 0x000fe200078e00ffULL, 0x00f400041100a388ULL, 0x0007e20000004800ULL,
0x0000007b077b7224ULL, 0x000fc400078e020cULL, 0x3fffff80ff0cd424ULL, 0x000fe200078e00ffULL,
0x00001fff12077589ULL, 0x000fe200000e0000ULL, 0x000000107b7b7824ULL, 0x000fe400078e00ffULL,
0x3fffff60ff08d424ULL, 0x002fe200078e00ffULL, 0x00f6080a11009388ULL, 0x000fe20000008a00ULL,
0x7fffff60ff09d424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff0dd424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0eb424ULL, 0x000fe200078e00ffULL, 0x00f688081100d388ULL, 0x000fe20000008a00ULL,
0x7fffffc0ff0fb424ULL, 0x000fc600078e00ffULL, 0x00f6a80c1100d388ULL, 0x000fe80000008a00ULL,
0x00f6c80e1100b388ULL, 0x000fe20000008a00ULL, 0x0000000100710824ULL, 0x004fe400078e0a03ULL,
0x00005800ff718624ULL, 0x000fe200078e00ffULL, 0x00001fff10007589ULL, 0x000e6200000e0000ULL,
0x0000580005038a24ULL, 0x000fe400078e02ffULL, 0x00005a0071027a24ULL, 0x000fc800078e02ffULL,
0x0000000102047824ULL, 0x048fe200078e0a7bULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000007b0200720cULL, 0x000fe20003f26070ULL, 0x00005a00ff107624ULL, 0x000fe200078e00ffULL,
0x0000001004047817ULL, 0x000fc60003800000ULL, 0x0000590010107a24ULL, 0x000fe200078e02ffULL,
0x000000ff04757207ULL, 0x000fc60000800000ULL, 0x0000001003767224ULL, 0x000fe200078e02ffULL,
0x000000107500780cULL, 0x000fe20003f05270ULL, 0x0000000407027824ULL, 0x002fe400078e0200ULL,
0x00005a00720f7a24ULL, 0x000fe400078e0276ULL, 0x00000002020a7824ULL, 0x000fd000078e00ffULL,
0x000002c000008947ULL, 0x000fea0003800000ULL, 0x00005a0000047b06ULL, 0x000e620000209000ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x00005a00ff007a0cULL, 0x000fcc0003f45070ULL,
0x0000000400047308ULL, 0x002e620000001000ULL, 0x00000004ff0b7819ULL, 0x004fca0000011602ULL,
0x000000010a0c7824ULL, 0x000fe200078e020bULL, 0x0ffffffe04087810ULL, 0x002fc60007ffe0ffULL,
0x000000017b047824ULL, 0x000fe200078e020cULL, 0x0000000800097305ULL, 0x0002a4000021f000ULL,
0x000000ffff087224ULL, 0x002fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x004fc800078e0a09ULL,
0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL, 0x0000000d09097227ULL, 0x000fcc00078e0008ULL,
0x00000004090d7227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a0dULL,
0x00005a0009087a24ULL, 0x000fca00078e0204ULL, 0x00005a0008007a0cULL, 0x000fda0003f06070ULL,
0x80005a0008080a10ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d0810ULL, 0x000fe40007ffe0ffULL,
0x00005a0008007a0cULL, 0x000fda0003f26070ULL, 0x000000010d0d1810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff0daa12ULL, 0x000fca00078e33ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a0dULL,
0x00005a0009047a24ULL, 0x000fe200078e0204ULL, 0x0000000a75097217ULL, 0x000fc60007800000ULL,
0x000000010f047824ULL, 0x000fe400078e0204ULL, 0x00000001090a7824ULL, 0x000fe400078e0a0aULL,
0x000000100d087224ULL, 0x000fe400078e0204ULL, 0x0000001002047824ULL, 0x000fe200078e00ffULL,
0x0000000a0b00720cULL, 0x000fe20003f06070ULL, 0x0000010008087825ULL, 0x000fc600078e00ffULL,
0x000000f0040d7812ULL, 0x000fe200078ec0ffULL, 0x000000010c0a7824ULL, 0x040fe400078e0202ULL,
0x000000100c0b7824ULL, 0x000fe200078e00ffULL, 0x0000000d080d7212ULL, 0x000fc800078efcffULL,
0xfffffff00b0a7812ULL, 0x000fe400078ee20aULL, 0x000060000d087a10ULL, 0x000fc60007f3e0ffULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0x0000610009097a10ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e2000c101c46ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x00005a00000b7b06ULL, 0x000e620000209000ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000b000b7308ULL, 0x002e620000001000ULL,
0x0000000a020a7211ULL, 0x004fca00078fe0ffULL, 0x000000017b047824ULL, 0x000fe200078e020aULL,
0x0ffffffe0b0c7810ULL, 0x002fe20007ffe0ffULL, 0x000000010a0b7824ULL, 0x040fe400078e0202ULL,
0x000000100a0a7824ULL, 0x000fe200078e00ffULL, 0x0000000c00097305ULL, 0x000e68000021f000ULL,
0xfffffff00a0b7812ULL, 0x000fca00078ee20bULL, 0x000000100b0b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a09ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d090d7227ULL, 0x000fcc00078e0008ULL, 0x000000040d087227ULL, 0x000fc800078e00ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a08ULL, 0x00005a0009097a24ULL, 0x000fca00078e0204ULL,
0x00005a0009007a0cULL, 0x000fda0003f06070ULL, 0x80005a0009090a10ULL, 0x000fe40007ffe0ffULL,
0x0000000108080810ULL, 0x000fe40007ffe0ffULL, 0x00005a0009007a0cULL, 0x000fda0003f26070ULL,
0x0000000108081810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff08aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a08ULL, 0x00005a0009047a24ULL, 0x000fc800078e0204ULL,
0x000000010f097824ULL, 0x000fe400078e0204ULL, 0x0000001002047824ULL, 0x000fe400078e00ffULL,
0x0000001008097224ULL, 0x000fc600078e0209ULL, 0x000000f0040d7812ULL, 0x000fe200078ec0ffULL,
0x0000010009087825ULL, 0x000fca00078e00ffULL, 0x0000000d08087212ULL, 0x000fc800078efcffULL,
0x0000600008087a10ULL, 0x000fc80007f1e0ffULL, 0x0000610009097a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e8000b901c46ULL,
0x0000000000097919ULL, 0x002e620000000000ULL, 0x00000000000a7806ULL, 0x000fe200038e0000ULL,
0x00000004ff6e7424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000a00087300ULL, 0x000e7000000e0000ULL, 0x0000000a000b7309ULL, 0x000ea20000000000ULL,
0x000000090800720cULL, 0x002fe20003f02070ULL, 0x0000660005087625ULL, 0x000fc800078e006eULL,
0x000000ffff0b7224ULL, 0x004fd000078e0a0bULL, 0x00f6040bffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006086d7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0700720cULL, 0x000fe40003f05270ULL,
0x000000ff6d0b7810ULL, 0x006fc80007ffe0ffULL, 0x00000008ff707819ULL, 0x000fce000001160bULL,
0x0000b7e000008947ULL, 0x000fea0003800000ULL, 0x00000008000a7824ULL, 0x000fe400078e00ffULL,
0x00000003ff037424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f68c030aff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0b00780cULL, 0x000fe20003f04070ULL, 0x0000000205057824ULL, 0x000fe200078e00ffULL,
0x00000001ff647819ULL, 0x000fe20000011600ULL, 0x00f688000aff7f8cULL, 0x0005e2000c80043fULL,
0x0000000100667812ULL, 0x000fe200078ec0ffULL, 0x0000590005057624ULL, 0x000fe400078e0206ULL,
0x0000002064777824ULL, 0x000fc400078e00ffULL, 0x00000001726a7824ULL, 0x000fc800078e0205ULL,
0x000068006a037a24ULL, 0x002fe200078e0277ULL, 0x000003e000000947ULL, 0x000fea0003800000ULL,
0x000000776d067217ULL, 0x004fe20007800000ULL, 0x0000001066057824ULL, 0x000fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fc60000011602ULL, 0x0000000106067824ULL, 0x000fe200078e0a77ULL,
0x00000004070c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000105087824ULL, 0x000fe200078e0207ULL,
0x0000000c070d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000506067217ULL, 0x000fe20007800000ULL,
0x0000000108097824ULL, 0x040fe400078e0202ULL, 0x00000008080e7824ULL, 0x000fe400078e00ffULL,
0x0000000106067824ULL, 0x000fc600078e0a05ULL, 0xfffffff80e0b7812ULL, 0x000fe200078ee209ULL,
0x00000001050e7824ULL, 0x000fe200078e020dULL, 0x0000000807097810ULL, 0x040fe40007ffe0ffULL,
0x000000060700720cULL, 0x080fe20003f66070ULL, 0x0000000103077824ULL, 0x000fe200078e0208ULL,
0x000000060c00720cULL, 0x080fe20003f46070ULL, 0x00000001050c7824ULL, 0x000fe200078e020cULL,
0x000000060900720cULL, 0x080fe20003f26070ULL, 0x0000000105097824ULL, 0x000fe200078e0209ULL,
0x000000060d00720cULL, 0x000fe20003f06070ULL, 0x0000008007067825ULL, 0x000fc800078e00ffULL,
0x0000000103127824ULL, 0x000fe200078e020eULL, 0x00000070060f7812ULL, 0x000fe200078ef804ULL,
0x000000010e067824ULL, 0x140fe400078e0202ULL, 0x000000080e137824ULL, 0x000fe200078e00ffULL,
0x000064000f0e7a10ULL, 0x000fe20007f9e0ffULL, 0x000000010c087824ULL, 0x040fe400078e0202ULL,
0x000000080c117824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee206ULL,
0x0000000103057824ULL, 0x000fe200078e020cULL, 0x00006500070f7a10ULL, 0x000fe200027fe4ffULL,
0x00000001090d7824ULL, 0x000fc400078e0202ULL, 0x0000000809107824ULL, 0x000fe400078e00ffULL,
0x00000001030c7824ULL, 0x000fe200078e0209ULL, 0xfffffff811037812ULL, 0x000fe200078ee208ULL,
0x0000008005067825ULL, 0x000fe200078e00ffULL, 0xfffffff810117812ULL, 0x000fe400078ee20dULL,
0x0000b00064107811ULL, 0x000fe200078e68ffULL, 0x000000800c087825ULL, 0x000fe200078e00ffULL,
0x0000007006057812ULL, 0x000fc600078ef804ULL, 0x00000080120c7825ULL, 0x000fe200078e00ffULL,
0x0000007008067812ULL, 0x000fc600078ef804ULL, 0x000000100b0b7824ULL, 0x000fe200078e0210ULL,
0x000000700c087812ULL, 0x000fe200078ef804ULL, 0x0000001003037824ULL, 0x100fe200078e0210ULL,
0x0000640005047a10ULL, 0x000fe20007f9e0ffULL, 0x0000001011117824ULL, 0x100fe200078e0210ULL,
0x0000640006067a10ULL, 0x000fe20007fbe0ffULL, 0x0000001013137824ULL, 0x000fe200078e0210ULL,
0x0000640008087a10ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0b7faeULL, 0x0003e2000d901c46ULL, 0x0000650007057a10ULL, 0x000fe400027fe4ffULL,
0x0000650009077a10ULL, 0x000fc40002ffe4ffULL, 0x000065000d097a10ULL, 0x000fe200037fe4ffULL,
0x0000000004037faeULL, 0x0003e8000d101c46ULL, 0x0000000006117faeULL, 0x0003e8000c901c46ULL,
0x0000000008137faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001066057824ULL, 0x004fca00078e00ffULL, 0x0000000502057211ULL, 0x000fc800078fe8ffULL,
0x0000000405087810ULL, 0x040fe20007ffe0ffULL, 0x0000000105077824ULL, 0x140fe200078e0202ULL,
0x0000000c050e7810ULL, 0x040fe20007ffe0ffULL, 0x00000008050c7824ULL, 0x000fe400078e00ffULL,
0x0000000103067824ULL, 0x000fe400078e0205ULL, 0x0000000108097824ULL, 0x000fe200078e0202ULL,
0xfffffff80c0b7812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x00000008050c7810ULL, 0x000fc60007ffe0ffULL, 0x0000000103057824ULL, 0x040fe200078e0208ULL,
0x00000070060f7812ULL, 0x000fe200078ef804ULL, 0x0000000808107824ULL, 0x000fe400078e00ffULL,
0x0000000103117824ULL, 0x000fe400078e020eULL, 0x000000010e067824ULL, 0x040fe400078e0202ULL,
0x000000080e137824ULL, 0x000fe200078e00ffULL, 0x000064000f0e7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000103087824ULL, 0x000fe200078e020cULL, 0xfffffff810037812ULL, 0x000fe200078ee209ULL,
0x000000010c0d7824ULL, 0x040fe200078e0202ULL, 0xfffffff813127812ULL, 0x000fe200078ee206ULL,
0x000000080c0c7824ULL, 0x000fe200078e00ffULL, 0x00006500070f7a10ULL, 0x000fe200007fe4ffULL,
0x0000008005067825ULL, 0x000fe200078e00ffULL, 0x0000b00064137811ULL, 0x000fc400078e68ffULL,
0xfffffff80c107812ULL, 0x000fe200078ee20dULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000007006057812ULL, 0x000fc600078ef804ULL, 0x00000080110c7825ULL, 0x000fe200078e00ffULL,
0x0000007008067812ULL, 0x000fc600078ef804ULL, 0x000000100b0b7824ULL, 0x100fe200078e0213ULL,
0x000000700c087812ULL, 0x000fe200078ef804ULL, 0x0000001003037824ULL, 0x100fe200078e0213ULL,
0x0000640005047a10ULL, 0x000fe20007f1e0ffULL, 0x0000001010117824ULL, 0x100fe200078e0213ULL,
0x0000640006067a10ULL, 0x000fe20007f3e0ffULL, 0x0000001012137824ULL, 0x000fe200078e0213ULL,
0x0000640008087a10ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0b7faeULL, 0x0003e2000b901c46ULL, 0x0000650007057a10ULL, 0x000fe400007fe4ffULL,
0x0000650009077a10ULL, 0x000fc40000ffe4ffULL, 0x000065000d097a10ULL, 0x000fe200017fe4ffULL,
0x0000000004037faeULL, 0x0003e8000b901c46ULL, 0x0000000006117faeULL, 0x0003e8000b901c46ULL,
0x0000000008137faeULL, 0x0003e4000b901c46ULL, 0x00000000640473c2ULL, 0x000ea200000e0000ULL,
0x000000ff7000720cULL, 0x000fe20003f05270ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x0000f6a864047811ULL, 0x002fe200078e18ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047891ULL, 0x004fd2000f8e203fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff107f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200004047f8cULL, 0x000ea2000c80043fULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00009b2000008947ULL, 0x000fea0003800000ULL, 0x000000ffff107224ULL, 0x002fe200078e0011ULL,
0x00000002ff6e7819ULL, 0x000fe20000011600ULL, 0x000000ffff037224ULL, 0x004fc400078e0005ULL,
0xff317217ff117424ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe400078e00ffULL,
0x000000ffff177224ULL, 0x000fc400078e00ffULL, 0x000000ffff127224ULL, 0x00afca00078e00ffULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x0000000400077824ULL, 0x000fca00078e00ffULL,
0xfffffff807077812ULL, 0x000fca00078ec0ffULL, 0x00f6cc0007087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007804803ULL, 0x0000f6c807087810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c0e7210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc8000001140fULL,
0x0000000e0b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e060fULL,
0x000000020b0b7819ULL, 0x000fc8000000120eULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc00070e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000109037810ULL, 0x040fe20007ffe0ffULL,
0x0000010009407824ULL, 0x000fc600078e0277ULL, 0x000000700300720cULL, 0x000fe40003f26070ULL,
0x00000040400c7810ULL, 0x000fca0007ffe0ffULL, 0x000068006a307a24ULL, 0x000fcc00078e020cULL,
0x0000040000009947ULL, 0x000fea0003800000ULL, 0x0000000c6d037217ULL, 0x000fe20007800000ULL,
0x00000010660e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff077819ULL, 0x000fc60000011602ULL,
0x0000000103037824ULL, 0x000fe200078e0a0cULL, 0x00000004070c7810ULL, 0x040fe20007ffe0ffULL,
0x000000010e0d7824ULL, 0x040fe200078e0207ULL, 0x0000000c07127810ULL, 0x000fe40007ffe0ffULL,
0x000000030e037217ULL, 0x040fe20007800000ULL, 0x000000010e0f7824ULL, 0x000fe400078e020cULL,
0x000000010d0b7824ULL, 0x000fe400078e0202ULL, 0x0000000103037824ULL, 0x000fc400078e0a0eULL,
0x000000080d327824ULL, 0x000fe400078e00ffULL, 0x000000010e317824ULL, 0x000fe200078e0212ULL,
0x000000030c00720cULL, 0x080fe20003f66070ULL, 0x000000080f3a7824ULL, 0x000fe200078e00ffULL,
0x00000008070c7810ULL, 0x000fe20007ffe0ffULL, 0x00000008313e7824ULL, 0x000fe200078e00ffULL,
0xfffffff832327812ULL, 0x000fe200078ee20bULL, 0x00000010020b7824ULL, 0x000fe200078e00ffULL,
0x000000030c00720cULL, 0x080fe20003f46070ULL, 0x000000010e137824ULL, 0x000fe200078e020cULL,
0x000000030700720cULL, 0x080fe20003f86070ULL, 0x000000010d0c7824ULL, 0x100fe200078e0230ULL,
0x000000031200720cULL, 0x000fe20003f06070ULL, 0x000000010f0e7824ULL, 0x000fe200078e0230ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x000000010f077824ULL, 0x000fc400078e0202ULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee207ULL,
0x0000000113127824ULL, 0x000fe200078e0230ULL, 0x0000000b0c0c7212ULL, 0x000fe200078efcffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0x000064000c0c7a10ULL, 0x000fe20007fbe0ffULL,
0x0000000131307824ULL, 0x000fe200078e0230ULL, 0x0000000b0e0e7212ULL, 0x000fe200078efcffULL,
0x0000000113037824ULL, 0x100fe200078e0202ULL, 0x000065000d0d7a10ULL, 0x000fe20002ffe4ffULL,
0x00000008133c7824ULL, 0x000fe200078e00ffULL, 0x000064000e0e7a10ULL, 0x000fe20007fde0ffULL,
0x0000000131077824ULL, 0x000fe400078e0202ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fc400078ee203ULL, 0x0000c00064037811ULL, 0x000fe200078e68ffULL,
0x0000008030307825ULL, 0x000fe200078e00ffULL, 0x0000000b12127212ULL, 0x080fe400078efcffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee207ULL, 0x0000001032077824ULL, 0x100fe200078e0203ULL,
0x0000000b30307212ULL, 0x000fe200078efcffULL, 0x000000103a0b7824ULL, 0x100fe200078e0203ULL,
0x000065000f0f7a10ULL, 0x000fe200037fe4ffULL, 0x000000103c337824ULL, 0x100fe200078e0203ULL,
0x0000640012127a10ULL, 0x000fe20007fbe0ffULL, 0x000000103e037824ULL, 0x000fe200078e0203ULL,
0x0000640030307a10ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c077faeULL, 0x0003e2000e101c46ULL, 0x0000650013137a10ULL, 0x000fc40002ffe4ffULL,
0x0000650031317a10ULL, 0x000fe200037fe4ffULL, 0x000000000e0b7faeULL, 0x0003e8000d901c46ULL,
0x0000000012337faeULL, 0x0003e8000d101c46ULL, 0x0000000030037faeULL, 0x0003e2000c101c46ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001066037824ULL, 0x000fe400078e00ffULL,
0x0000001002077824ULL, 0x000fc600078e00ffULL, 0x0000000302037211ULL, 0x000fe400078fe8ffULL,
0x00000070070b7812ULL, 0x000fe400078ec0ffULL, 0x00000004030f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001030d7824ULL, 0x040fe200078e0202ULL, 0x0000000803137810ULL, 0x040fe20007ffe0ffULL,
0x00000008030e7824ULL, 0x040fe200078e00ffULL, 0x0000000c03317810ULL, 0x040fe20007ffe0ffULL,
0x00000001030c7824ULL, 0x000fe400078e0230ULL, 0x000000010f037824ULL, 0x040fe200078e0202ULL,
0xfffffff80e077812ULL, 0x000fe200078ee20dULL, 0x000000010f0e7824ULL, 0x000fc400078e0230ULL,
0x000000080f327824ULL, 0x000fe400078e00ffULL, 0x0000000113127824ULL, 0x040fe400078e0230ULL,
0x00000001130f7824ULL, 0x040fe200078e0202ULL, 0xfffffff832337812ULL, 0x000fe200078ee203ULL,
0x00000008133a7824ULL, 0x000fe200078e00ffULL, 0x0000c00064327811ULL, 0x000fe200078e68ffULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff83a397812ULL, 0x000fe200078ee20fULL,
0x0000000131137824ULL, 0x040fe200078e0202ULL, 0x0000000b0c0c7212ULL, 0x080fe200078efcffULL,
0x00000008313c7824ULL, 0x040fe400078e00ffULL, 0x0000000131307824ULL, 0x000fe200078e0230ULL,
0x000064000c0c7a10ULL, 0x000fe20007f1e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff83c3b7812ULL, 0x000fe400078ee213ULL, 0x000065000d0d7a10ULL, 0x000fe200007fe4ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000b0e0e7212ULL, 0x000fc600078efcffULL,
0x0000008030307825ULL, 0x000fe200078e00ffULL, 0x0000000b12127212ULL, 0x080fe400078efcffULL,
0x000064000e0e7a10ULL, 0x000fe20007f1e0ffULL, 0x0000001007037824ULL, 0x100fe200078e0232ULL,
0x0000000b30307212ULL, 0x000fe200078efcffULL, 0x0000001033077824ULL, 0x100fe200078e0232ULL,
0x0000640012127a10ULL, 0x000fe20007f5e0ffULL, 0x00000010390b7824ULL, 0x100fe200078e0232ULL,
0x0000640030307a10ULL, 0x000fe20007f7e0ffULL, 0x000000103b337824ULL, 0x000fe200078e0232ULL,
0x000065000f0f7a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c037faeULL, 0x0003e2000b901c46ULL, 0x0000650013137a10ULL, 0x000fc400017fe4ffULL,
0x0000650031317a10ULL, 0x000fe20001ffe4ffULL, 0x000000000e077faeULL, 0x0003e8000b901c46ULL,
0x00000000120b7faeULL, 0x0003e8000b901c46ULL, 0x0000000030337faeULL, 0x0003e4000b901c46ULL,
0xfffffff00a0d7812ULL, 0x042fe400078ec0ffULL, 0xffffffe00a037812ULL, 0x000fc400078ec0ffULL,
0x000000000d0573c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000100a0c7812ULL, 0x000fca00078ec0ffULL, 0x0000000103037824ULL, 0x000fc800078e020cULL,
0x0000000866307824ULL, 0x000fe200078e0203ULL, 0x0000f6b005057890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6b0000d0c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6080030307f8cULL, 0x000ea4000c80043fULL,
0x00000000000e7805ULL, 0x000fc40000015200ULL, 0x000000080a127812ULL, 0x000fca00078ec0ffULL,
0x0000000103077824ULL, 0x000fca00078e0212ULL, 0x00f60c0007037984ULL, 0x000ee40000000800ULL,
0x8000000003ff7812ULL, 0x00cfe40007804831ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120e127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0fULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011413ULL,
0x0000001203037211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x0000000203037819ULL, 0x000fc80000001212ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f60c0007037984ULL, 0x000ea40000000800ULL,
0x8000000003ff7812ULL, 0x004fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001002657824ULL, 0x000fe200078e00ffULL,
0x00000001ff747819ULL, 0x000fe20000011602ULL, 0x0000002000037824ULL, 0x000fe400078e00ffULL,
0xffffffffff787424ULL, 0x000fe200078e00ffULL, 0x0000007065657812ULL, 0x000fc400078ec0ffULL,
0xffffff8003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c74747812ULL, 0x000fc800078ec0ffULL,
0x0000000374037210ULL, 0x000fca0007ffe065ULL, 0x00f00000030e7984ULL, 0x000ea80000000800ULL,
0x00f2000003317984ULL, 0x0006620000000800ULL, 0x000000110e00720bULL, 0x004fe20003f1d000ULL,
0x0000fc627f007947ULL, 0x000fd8000b800000ULL, 0x00000000000f7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0f307812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff037424ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc400078e0011ULL,
0x0000001fff7a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff797424ULL, 0x000fca00078e00ffULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000006e00720cULL, 0x000fe40003f05270ULL,
0x000000110e00720bULL, 0x000fe20003f54000ULL, 0x0000fbf27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000037806ULL, 0x000fc400010e0100ULL, 0x00000080000f8824ULL, 0x000fe200078e0265ULL,
0x000000110e0b7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x0000000174128824ULL, 0x000fe200078e020fULL, 0x00009910030f7816ULL, 0x000fc800000000ffULL,
0x00f4000b12008388ULL, 0x0005e20000000800ULL, 0x000000ff0f00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x000000110b0f7221ULL, 0x004fe20000010100ULL,
0x000000ff03ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL, 0x0000000f00327308ULL, 0x000ea40000000800ULL,
0x0000003238387220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0f7819ULL, 0x000fe20000011602ULL, 0x0000fb227f007947ULL, 0x000fea000b800000ULL,
0x00001f0f320f7589ULL, 0x0004e400000e0000ULL, 0x0000000f34347220ULL, 0x08cfe20000410000ULL,
0x0000000f35357220ULL, 0x080fe20000410000ULL, 0x0000000f18187220ULL, 0x080fe20000410000ULL,
0x0000000f19197220ULL, 0x080fe20000410000ULL, 0x0000000f1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000f1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000f20207220ULL, 0x080fe20000410000ULL,
0x0000000f21217220ULL, 0x080fe20000410000ULL, 0x0000000f24247220ULL, 0x080fe20000410000ULL,
0x0000000f25257220ULL, 0x080fe20000410000ULL, 0x0000000f28287220ULL, 0x080fe20000410000ULL,
0x0000000f29297220ULL, 0x080fe20000410000ULL, 0x0000000f2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000f2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000f14147220ULL, 0x080fe20000410000ULL,
0x0000000f15157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0003ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008020f7811ULL, 0x000fe200078ff0ffULL, 0x0000fa027f007947ULL, 0x000fea000b800000ULL,
0x00001f0f320f7589ULL, 0x0004e400000e0000ULL, 0x0000000f36367220ULL, 0x08cfe20000410000ULL,
0x0000000f37377220ULL, 0x080fe20000410000ULL, 0x0000000f1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000f1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000f1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000f1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000f22227220ULL, 0x080fe20000410000ULL,
0x0000000f23237220ULL, 0x080fe20000410000ULL, 0x0000000f26267220ULL, 0x080fe20000410000ULL,
0x0000000f27277220ULL, 0x080fe20000410000ULL, 0x0000000f2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000f2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000f2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000f2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000f16167220ULL, 0x080fe20000410000ULL,
0x0000000f17177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff30ff7812ULL, 0x000fe20007806003ULL, 0x00000001ff037424ULL, 0x000fd800078e00ffULL,
0x8000000b0e0e0221ULL, 0x000fe20000010000ULL, 0x00007610ff030816ULL, 0x000fc60000000003ULL,
0x3fb8aa3b0e0e0820ULL, 0x000fc80000410000ULL, 0x0000000e00060308ULL, 0x000ea40000000800ULL,
0x0000000631310220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000038310e7221ULL, 0x002fc20000010000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0xfffffff00a327812ULL, 0x000fca00078ec0ffULL, 0x00f6ac00320f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804810ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fcc0000015200ULL,
0x0000003012307210ULL, 0x000fca0007f1e1ffULL, 0x0000000131317824ULL, 0x000fe200000e0e13ULL,
0x003d09003000780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403000780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011431ULL, 0x000000300f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff307224ULL, 0x000fca00000e0631ULL, 0x000000020f0f7819ULL, 0x000fc80000001230ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000111117810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac00320f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804810ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991003037816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0300720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x000fe400000000ffULL,
0x00000002ff107819ULL, 0x000fe40000011602ULL, 0x0000541003037816ULL, 0x000fe20000000003ULL,
0x0000f5d27f007947ULL, 0x000fea000b800000ULL, 0x00001f1003057589ULL, 0x0002a400000e0000ULL,
0x00000008100f7810ULL, 0x000fe20007ffe0ffULL, 0x0000f6027f007947ULL, 0x000fea000b800000ULL,
0x00001f0f03047589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010100f7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e0003ULL,
0x00002e6000137802ULL, 0x000fc40000000f00ULL, 0x0000ffd000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018100f7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e0003ULL, 0x00002eb000137802ULL, 0x000fc40000000f00ULL,
0x0000ff8000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000702107812ULL, 0x002fe200078ec0ffULL, 0x0000020000417824ULL, 0x000fe200078e00ffULL,
0x00000004ff137819ULL, 0x100fe20000011602ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000008100f7812ULL, 0x00cfc400078ef802ULL, 0xfffff80041417812ULL, 0x000fe200078ec0ffULL,
0x0000000464127824ULL, 0x000fe400078e0213ULL, 0x000000080f037824ULL, 0x040fe400078e00ffULL,
0x000000010f127824ULL, 0x000fca00078e0212ULL, 0xfffffff803307812ULL, 0x000fe400078ee212ULL,
0x0000000802037812ULL, 0x000fc600078ec0ffULL, 0x0000001030117824ULL, 0x000fc400078e0241ULL,
0x0000000466307824ULL, 0x000fe200078e0213ULL, 0x0000001003137212ULL, 0x040fe400078efcffULL,
0x0000b00064677811ULL, 0x000fe400078e68ffULL, 0x0000001003037812ULL, 0x000fe200078efe10ULL,
0x0000000113317824ULL, 0x040fe200078e0230ULL, 0x0000000212617810ULL, 0x000fe20007ffe0ffULL,
0x0000000813327824ULL, 0x040fe400078e00ffULL, 0x00000008133c7824ULL, 0x000fc400078e00ffULL,
0x0000000130307824ULL, 0x000fe200078e0203ULL, 0xfffffff832327812ULL, 0x000fe200078ee231ULL,
0x0000000803137824ULL, 0x000fe200078e00ffULL, 0x0000000231317810ULL, 0x000fe20007ffe0ffULL,
0x000000080f127824ULL, 0x000fe200078e00ffULL, 0x0000000230447810ULL, 0x000fe20007ffe0ffULL,
0x0000001032327824ULL, 0x000fe200078e0267ULL, 0xfffffff813107812ULL, 0x000fe200078ee230ULL,
0x00000008030f7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee231ULL,
0x000000003238783bULL, 0x000e620000004200ULL, 0x0000001010307824ULL, 0x000fe200078e0267ULL,
0xfffffff812617812ULL, 0x000fe200078ee261ULL, 0x000000103c3c7824ULL, 0x000fe200078e0267ULL,
0x009000001110783bULL, 0x000ea20000000200ULL, 0xfffffff80f447812ULL, 0x000fc400078ee244ULL,
0x0000001061617824ULL, 0x000fe200078e0241ULL, 0x000000003030783bULL, 0x000ee80000004200ULL,
0x000000003c48783bULL, 0x0008e20000004200ULL, 0x00000010ff0f7819ULL, 0x102fe40000011638ULL,
0x00000010ff3f7819ULL, 0x000fe40000011639ULL, 0x000000ff383d7812ULL, 0x000fe200078ec0ffULL,
0x0000000510108232ULL, 0x084fe20000000000ULL, 0x000000ff0f0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000512128232ULL, 0x000fe20000000000ULL, 0x000000ff39437812ULL, 0x000fe200078ec0ffULL,
0x0000000411118232ULL, 0x080fe20000000000ULL, 0x000000ff3f3f7812ULL, 0x000fe200078ec0ffULL,
0x0000000413138232ULL, 0x000fe20000000000ULL, 0x00000018ff6b7819ULL, 0x000fc40000011638ULL,
0x0000ffff383c7812ULL, 0x010fe400078ec0ffULL, 0x00000018ff697819ULL, 0x000fe40000011639ULL,
0x0000ffff39427812ULL, 0x000fe400078ec0ffULL, 0x0000003dff38723eULL, 0x000fe400020006ffULL,
0x0000000fff39723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fc400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x0000541038387816ULL, 0x000fe40000000039ULL,
0x0000541043397816ULL, 0x000fe4000000003fULL, 0x00000018ff0f7819ULL, 0x108fe40000011630ULL,
0x000000ff303d7812ULL, 0x040fe400078ec0ffULL, 0x00000010ff477819ULL, 0x000fe20000011630ULL,
0x000000381034723cULL, 0x000b620000001834ULL, 0x0000ffff30437812ULL, 0x000fc400078ec0ffULL,
0x00000010ff457819ULL, 0x100fe40000011632ULL, 0x000000ff32307812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4d7819ULL, 0x000fe20000011632ULL, 0x0000001044387824ULL, 0x020fe200078e0267ULL,
0x0000ffff32627812ULL, 0x000fe400078ec0ffULL, 0x00000010ff637819ULL, 0x000fe40000011633ULL,
0x000000ff33327812ULL, 0x000fc400078ec0ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011633ULL,
0x0000ffff333f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3c7819ULL, 0x000fe4000001163cULL,
0x00000008ff337819ULL, 0x000fe40000011642ULL, 0x00000010ff517819ULL, 0x000fe40000011648ULL,
0x000000ff48507812ULL, 0x000fc400078ec0ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011648ULL,
0x0000ffff48527812ULL, 0x000fe400078ec0ffULL, 0x00000010ff447819ULL, 0x100fe40000011631ULL,
0x00000018ff487819ULL, 0x000fe40000011631ULL, 0x000000ff316c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff31467812ULL, 0x000fc400078ec0ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x0000003cff31723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000033ff33723eULL, 0x000fe400020006ffULL, 0x00000030ff3c723eULL, 0x000fe400020006ffULL,
0x0000541031307816ULL, 0x000fc4000000006bULL, 0x0000541033317816ULL, 0x000fe40000000069ULL,
0x00000010ff607819ULL, 0x000fe4000001163aULL, 0x00000010ff687819ULL, 0x000fe4000001163bULL,
0x0000ffff3a3e7812ULL, 0x040fe200078ec0ffULL, 0x000000301018723cULL, 0x000b620000001818ULL,
0x000000ff3a5f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3b5c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff60607812ULL, 0x000fe400078ec0ffULL, 0x000000ff68687812ULL, 0x000fe400078ec0ffULL,
0x00000008ff317819ULL, 0x020fe4000001163eULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000060ff30723eULL, 0x000fc400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000032ff3e723eULL, 0x000fe400020006ffULL,
0x00000031ff32723eULL, 0x000fe400020006ffULL, 0x0000ffff3b5b7812ULL, 0x000fe400078ec0ffULL,
0x000054105f307816ULL, 0x000fe40000000030ULL, 0x000054105c317816ULL, 0x000fc40000000068ULL,
0x00000018ff577819ULL, 0x000fe4000001163aULL, 0x00000018ff567819ULL, 0x000fe4000001163bULL,
0x00000008ff5b7819ULL, 0x000fe2000001165bULL, 0x00000030101c723cULL, 0x000be2000000181cULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x000000003838783bULL, 0x000fe20000004200ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000010ff547819ULL, 0x000fc40000011649ULL,
0x0000005bff31723eULL, 0x020fe400020006ffULL, 0x0000541032307816ULL, 0x000fe40000000057ULL,
0x0000541031317816ULL, 0x000fe40000000056ULL, 0x000000ff49557812ULL, 0x000fe400078ec0ffULL,
0x000000ff51517812ULL, 0x000fe400078ec0ffULL, 0x000000ff54547812ULL, 0x000fe200078ec0ffULL,
0x000000301020723cULL, 0x000b620000001820ULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x0000ffff49587812ULL, 0x000fe400078ec0ffULL,
0x00000051ff30723eULL, 0x020fe400020006ffULL, 0x00000054ff31723eULL, 0x000fe400020006ffULL,
0x0000541050307816ULL, 0x000fe40000000030ULL, 0x0000541055317816ULL, 0x000fc40000000031ULL,
0x00000018ff4e7819ULL, 0x000fe40000011649ULL, 0x00000008ff527819ULL, 0x000fe40000011652ULL,
0x00000008ff587819ULL, 0x000fe20000011658ULL, 0x000000301024723cULL, 0x000b620000001824ULL,
0x00000010ff537819ULL, 0x000fe2000001164aULL, 0x009000006130783bULL, 0x020e620000000200ULL,
0x0000004cff68723eULL, 0x000fe400020006ffULL, 0x0000004eff69723eULL, 0x000fc400020006ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000058ff6b723eULL, 0x000fe400020006ffULL,
0x00000010ff5e7819ULL, 0x000fe4000001164bULL, 0x000000ff53587812ULL, 0x000fe400078ec0ffULL,
0x0000541052527816ULL, 0x000fe40000000068ULL, 0x000054106b537816ULL, 0x000fc40000000069ULL,
0x000000ff4a5a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4b5d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5e5e7812ULL, 0x000fe200078ec0ffULL, 0x000000521028723cULL, 0x000b620000001828ULL,
0x00000018ff597819ULL, 0x000fe4000001164aULL, 0x0000ffff4a497812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fc4000001164bULL, 0x0000ffff4b4b7812ULL, 0x000fe400078ec0ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000008ff527819ULL, 0x020fe20000011649ULL, 0x0000000530308232ULL, 0x082fe20000000000ULL,
0x0000004aff49723eULL, 0x000fe200020006ffULL, 0x0000000532328232ULL, 0x000fe20000000000ULL,
0x00000008ff537819ULL, 0x000fe2000001164bULL, 0x0000000431318232ULL, 0x080fe20000000000ULL,
0x000054105a4a7816ULL, 0x000fe20000000058ULL, 0x0000000433338232ULL, 0x000fe20000000000ULL,
0x000054105d4b7816ULL, 0x000fc4000000005eULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x000000ff47477812ULL, 0x000fe200078ec0ffULL,
0x0000004a102c723cULL, 0x000b62000000182cULL, 0x000000ff44447812ULL, 0x000fe400078ec0ffULL,
0x00000048ff42723eULL, 0x000fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fc400020006ffULL,
0x00000053ff4b723eULL, 0x020fe400020006ffULL, 0x00005410524a7816ULL, 0x000fe40000000059ULL,
0x000054104b4b7816ULL, 0x000fe40000000049ULL, 0x0000006cff48723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000008ff437819ULL, 0x000fe20000011643ULL,
0x0000004a1010723cULL, 0x000b620000001814ULL, 0x00000008ff467819ULL, 0x000fc40000011646ULL,
0x0000000fff0f723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x00000044ff15723eULL, 0x020fe400020006ffULL, 0x000054103d147816ULL, 0x000fe40000000047ULL,
0x0000541048157816ULL, 0x000fe40000000015ULL, 0x00000008ff627819ULL, 0x000fc40000011662ULL,
0x00000008ff3f7819ULL, 0x000fe4000001163fULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x000000143014723cULL, 0x000b620000001834ULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x00000010ff547819ULL, 0x000fe40000011638ULL, 0x00000010ff557819ULL, 0x000fe40000011639ULL,
0x00000046ff35723eULL, 0x020fc400020006ffULL, 0x0000541043347816ULL, 0x000fe2000000000fULL,
0x00000002000f7824ULL, 0x000fe200078e00ffULL, 0x0000541035357816ULL, 0x000fe40000000042ULL,
0x000000ff385b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff395c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff54547812ULL, 0x000fe200078ec0ffULL, 0x000000343018723cULL, 0x000b620000001818ULL,
0x000000ff55557812ULL, 0x000fc400078ec0ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000062ff34723eULL, 0x020fe400020006ffULL,
0x0000003fff35723eULL, 0x000fe400020006ffULL, 0x0000541034347816ULL, 0x000fe4000000004dULL,
0x0000541035357816ULL, 0x000fc4000000004fULL, 0x00000018ff517819ULL, 0x000fe40000011638ULL,
0x0000ffff384c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff567819ULL, 0x000fe20000011639ULL,
0x000000343020723cULL, 0x000b620000001820ULL, 0x0000ffff394e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff387819ULL, 0x000fe4000001163aULL, 0x000000ff3a577812ULL, 0x000fc400078ec0ffULL,
0x00000054ff34723eULL, 0x020fe400020006ffULL, 0x00000055ff35723eULL, 0x000fe400020006ffULL,
0x00000018ff397819ULL, 0x000fe4000001163aULL, 0x0000ffff3a5f7812ULL, 0x000fe400078ec0ffULL,
0x000054105b347816ULL, 0x000fe40000000034ULL, 0x000054105c357816ULL, 0x000fc40000000035ULL,
0x00000010ff3a7819ULL, 0x100fe4000001163bULL, 0x000000ff3b507812ULL, 0x040fe400078ec0ffULL,
0x00000018ff607819ULL, 0x000fe2000001163bULL, 0x000000343024723cULL, 0x000b620000001824ULL,
0x0000ffff3b3b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff45457812ULL, 0x000fe400078ec0ffULL,
0x000000ff63637812ULL, 0x000fc400078ec0ffULL, 0x00000008ff4c7819ULL, 0x000fe4000001164cULL,
0x00000008ff4e7819ULL, 0x000fe4000001164eULL, 0x000000ff38387812ULL, 0x000fe400078ec0ffULL,
0x000000ff3a3a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5f7819ULL, 0x000fe4000001165fULL,
0x00000008ff3b7819ULL, 0x000fc4000001163bULL, 0x00000039ff34723eULL, 0x020fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000063ff3d723eULL, 0x000fe400020006ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fc400020006ffULL, 0x00000050ff50723eULL, 0x000fe400020006ffULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x0000004eff4d723eULL, 0x000fe400020006ffULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x0000003aff39723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000003bff35723eULL, 0x000fe400020006ffULL, 0x000054103c3c7816ULL, 0x000fe40000000045ULL,
0x000054103e3d7816ULL, 0x000fe4000000003dULL, 0x000054104c4c7816ULL, 0x000fe40000000051ULL,
0x000054104d4d7816ULL, 0x000fc40000000056ULL, 0x0000541057387816ULL, 0x000fe20000000038ULL,
0x0000003c301c723cULL, 0x040f62000000181cULL, 0x0000541050397816ULL, 0x000fe40000000039ULL,
0x000054105f347816ULL, 0x000fe40000000034ULL, 0x0000541035357816ULL, 0x000fe40000000060ULL,
0xfffffff80f0f7812ULL, 0x000fe200078ec0ffULL, 0x0000004c3028723cULL, 0x040f700000001828ULL,
0x00000038302c723cULL, 0x040f70000000182cULL, 0x000000343030723cULL, 0x000b6e0000001810ULL,
0x0000f6c864347811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000034347f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f688000fff7f8cULL, 0x0005e4000c80043fULL, 0x0000000000107805ULL, 0x000fc40000015200ULL,
0x00000400080f7984ULL, 0x004ea40000000800ULL, 0x800000000fff7812ULL, 0x006fc40007804835ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011413ULL,
0x000000120f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x000000020f0f7819ULL, 0x000fc80000001212ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400080f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008040107810ULL, 0x000fca0007ffe0ffULL, 0x000068006a357a24ULL, 0x000fe200078e0210ULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x000000106d0f7217ULL, 0x000fe20007800000ULL,
0x0000001066127824ULL, 0x000fe200078e00ffULL, 0x00000003ff117819ULL, 0x000fc60000011602ULL,
0x000000010f0f7824ULL, 0x000fe200078e0a10ULL, 0x0000000411347810ULL, 0x040fe20007ffe0ffULL,
0x0000000112107824ULL, 0x040fe200078e0211ULL, 0x0000000c11367810ULL, 0x000fe40007ffe0ffULL,
0x0000000f120f7217ULL, 0x000fe20007800000ULL, 0x0000000110137824ULL, 0x040fe400078e0202ULL,
0x0000000810387824ULL, 0x000fe400078e00ffULL, 0x000000010f0f7824ULL, 0x000fc400078e0a12ULL,
0x0000000110107824ULL, 0x000fe200078e0235ULL, 0xfffffff838387812ULL, 0x000fe200078ee213ULL,
0x0000000112397824ULL, 0x000fe200078e0236ULL, 0x0000000f3400720cULL, 0x080fe20003f66070ULL,
0x0000000112347824ULL, 0x000fe200078e0234ULL, 0x0000000811137810ULL, 0x000fe20007ffe0ffULL,
0x00000008393e7824ULL, 0x000fe200078e00ffULL, 0x0000000f1100720cULL, 0x080fe20003f86070ULL,
0x0000000134117824ULL, 0x040fe200078e0202ULL, 0x0000000f1300720cULL, 0x080fe20003f46070ULL,
0x00000008343a7824ULL, 0x000fe200078e00ffULL, 0x0000000f3600720cULL, 0x000fe20003f06070ULL,
0x0000000112137824ULL, 0x000fc400078e0213ULL, 0x0000000134127824ULL, 0x000fe200078e0235ULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee211ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000113347824ULL, 0x040fe200078e0235ULL, 0x0000006510107212ULL, 0x000fe200078efcffULL,
0x00000001130f7824ULL, 0x040fe400078e0202ULL, 0x00000008133c7824ULL, 0x000fe200078e00ffULL,
0x0000640010107a10ULL, 0x000fe20007fbe0ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20fULL, 0x0000000139367824ULL, 0x000fe200078e0235ULL,
0x0000006512127212ULL, 0x080fe200078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000650011117a10ULL, 0x000fe40002ffe4ffULL, 0x0000640012127a10ULL, 0x000fe20007fbe0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000006534347212ULL, 0x080fe400078efcffULL,
0x0000650013137a10ULL, 0x000fe20002ffe4ffULL, 0x00000001390f7824ULL, 0x000fe200078e0202ULL,
0x0000006536367212ULL, 0x000fe200078efcffULL, 0x000000103a397824ULL, 0x100fe200078e0267ULL,
0x0000640034347a10ULL, 0x000fe20007fbe0ffULL, 0x000000103c3b7824ULL, 0x000fe200078e0267ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee20fULL, 0x00000010380f7824ULL, 0x000fe200078e0267ULL,
0x0000640036367a10ULL, 0x000fc40007fde0ffULL, 0x0000650035357a10ULL, 0x000fe20002ffe4ffULL,
0x000000103e3d7824ULL, 0x000fe200078e0267ULL, 0x0000650037377a10ULL, 0x000fe200037fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100f7faeULL, 0x0003e8000e101c46ULL,
0x0000000012397faeULL, 0x0003e8000d901c46ULL, 0x00000000343b7faeULL, 0x0003e8000d101c46ULL,
0x00000000363d7faeULL, 0x0003e2000c101c46ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x00000010660f7824ULL, 0x000fca00078e00ffULL, 0x0000000f020f7211ULL, 0x000fc800078fe8ffULL,
0x000000040f367810ULL, 0x040fe20007ffe0ffULL, 0x000000010f107824ULL, 0x140fe200078e0202ULL,
0x000000080f127810ULL, 0x040fe20007ffe0ffULL, 0x000000080f377824ULL, 0x000fe400078e00ffULL,
0x0000000136117824ULL, 0x040fe400078e0202ULL, 0x00000008363a7824ULL, 0x000fe200078e00ffULL,
0xfffffff837387812ULL, 0x000fe200078ee210ULL, 0x000000010f107824ULL, 0x040fe200078e0235ULL,
0x0000000c0f0f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000112137824ULL, 0x000fe200078e0202ULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee211ULL, 0x00000008123c7824ULL, 0x000fc400078e00ffULL,
0x0000000136367824ULL, 0x000fe400078e0235ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fc600078ee213ULL, 0x0000000112127824ULL, 0x100fe200078e0235ULL,
0x0000006510107212ULL, 0x000fe200078efcffULL, 0x000000010f347824ULL, 0x000fe400078e0235ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000640010107a10ULL, 0x000fc60007f1e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000006536367212ULL, 0x080fe400078efcffULL,
0x0000650011117a10ULL, 0x000fe200007fe4ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000006512127212ULL, 0x080fe400078efcffULL, 0x0000640036367a10ULL, 0x000fe20007f5e0ffULL,
0x000000010f397824ULL, 0x040fe200078e0202ULL, 0x0000006534347212ULL, 0x000fe200078efcffULL,
0x000000080f3e7824ULL, 0x000fe200078e00ffULL, 0x0000640012127a10ULL, 0x000fe20007f1e0ffULL,
0x00000010380f7824ULL, 0x100fe200078e0267ULL, 0x0000640034347a10ULL, 0x000fe20007f7e0ffULL,
0x000000103c3b7824ULL, 0x000fe200078e0267ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee239ULL,
0x000000103a397824ULL, 0x100fe200078e0267ULL, 0x0000650037377a10ULL, 0x000fe200017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100f7faeULL, 0x0003e2000b901c46ULL,
0x0000650013137a10ULL, 0x000fe200007fe4ffULL, 0x000000103e3d7824ULL, 0x000fe200078e0267ULL,
0x0000650035357a10ULL, 0x000fe20001ffe4ffULL, 0x0000000036397faeULL, 0x0003e8000b901c46ULL,
0x00000000123b7faeULL, 0x0003e8000b901c46ULL, 0x00000000343d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000010640f7824ULL, 0x000fe200078e00ffULL,
0xffffffe00a107812ULL, 0x000fc400078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x000000080a117812ULL, 0x000fe400078ec0ffULL, 0x000000100f0f7812ULL, 0x000fc800078ec0ffULL,
0x00000010110f7210ULL, 0x000fe20007ffe00fULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff107f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f628000f367f8cULL, 0x0004e4000c80043fULL,
0x0000000000127805ULL, 0x000fc40000015200ULL, 0x00f62c00070f7984ULL, 0x004ea40000000800ULL,
0x800000000fff7812ULL, 0x00cfe40007804837ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003412347210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e13ULL,
0x003d09003400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011435ULL, 0x000000340f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff347224ULL, 0x000fca00000e0635ULL, 0x000000020f0f7819ULL, 0x000fc80000001234ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f62c00070f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x004fe40007804837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020000f7824ULL, 0x000fca00078e00ffULL,
0xffffff800f127812ULL, 0x000fc800078ec0ffULL, 0x00000080650f7810ULL, 0x000fca0007ffe012ULL,
0x00000001740f7824ULL, 0x000fca00078e020fULL, 0x00f000000f347984ULL, 0x000ea80000000800ULL,
0x00f200000f357984ULL, 0x0006620000000800ULL, 0x0000000b3400720bULL, 0x004fe20003f1d000ULL,
0x0000d7627f007947ULL, 0x000fd8000b800000ULL, 0x00000000000f7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0f377812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0f7424ULL, 0x000fd600078e00ffULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x000000016e0f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000b3400720bULL, 0x000fe40003f54000ULL,
0x000000000f00720cULL, 0x000fe20003f05270ULL, 0x0000d7127f007947ULL, 0x000fd4000b800000ULL,
0x0000000000367806ULL, 0x000fc400010e0100ULL, 0x00000080000f8824ULL, 0x000fe200078e0265ULL,
0x0000000b34127209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x0000000174138824ULL, 0x000fe200078e020fULL, 0x00009910360f7816ULL, 0x000fc800000000ffULL,
0x00f4001213008388ULL, 0x0005e20000000800ULL, 0x000000ff0f00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x800000120b0f7221ULL, 0x004fe20000010000ULL,
0x000000ff36ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL, 0x0000000f00397308ULL, 0x000ea40000000800ULL,
0x000000390e0e7220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0f7819ULL, 0x000fe20000011602ULL, 0x0000d6427f007947ULL, 0x000fea000b800000ULL,
0x00001f0f390f7589ULL, 0x0004e400000e0000ULL, 0x0000000f14147220ULL, 0x08cfe20000410000ULL,
0x0000000f15157220ULL, 0x080fe20000410000ULL, 0x0000000f18187220ULL, 0x080fe20000410000ULL,
0x0000000f19197220ULL, 0x080fe20000410000ULL, 0x0000000f1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000f1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000f20207220ULL, 0x080fe20000410000ULL,
0x0000000f21217220ULL, 0x080fe20000410000ULL, 0x0000000f24247220ULL, 0x080fe20000410000ULL,
0x0000000f25257220ULL, 0x080fe20000410000ULL, 0x0000000f28287220ULL, 0x080fe20000410000ULL,
0x0000000f29297220ULL, 0x080fe20000410000ULL, 0x0000000f2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000f2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000f30307220ULL, 0x080fe20000410000ULL,
0x0000000f31317220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0036ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008020f7811ULL, 0x000fe200078ff0ffULL, 0x0000d5227f007947ULL, 0x000fea000b800000ULL,
0x00001f0f390f7589ULL, 0x0004e400000e0000ULL, 0x0000000f16167220ULL, 0x08cfe20000410000ULL,
0x0000000f17177220ULL, 0x080fe20000410000ULL, 0x0000000f1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000f1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000f1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000f1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000f22227220ULL, 0x080fe20000410000ULL,
0x0000000f23237220ULL, 0x080fe20000410000ULL, 0x0000000f26267220ULL, 0x080fe20000410000ULL,
0x0000000f27277220ULL, 0x080fe20000410000ULL, 0x0000000f2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000f2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000f2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000f2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000f32327220ULL, 0x080fe20000410000ULL,
0x0000000f33337220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff37ff7812ULL, 0x000fe20007806036ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000b340b7209ULL, 0x000fd60007810000ULL, 0x8000000b34340221ULL, 0x000fe20000010000ULL,
0x00007610ff0f0816ULL, 0x000fc6000000000fULL, 0x3fb8aa3b34340820ULL, 0x000fc80000410000ULL,
0x0000003400060308ULL, 0x000ea40000000800ULL, 0x0000000635350220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000e350e7221ULL, 0x002fc20000010000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0xfffffff00a387812ULL, 0x000fca00078ec0ffULL,
0x00f6b40038357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003412377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e13ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b40038357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100f0c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000006ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011602ULL,
0x00005410040c7816ULL, 0x000fe20000000004ULL, 0x0000d0e27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0c057589ULL, 0x0002a400000e0000ULL, 0x000000080d0f7810ULL, 0x000fe20007ffe0ffULL,
0x0000d1127f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0c047589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100d0f7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e000cULL, 0x0000551000137802ULL, 0x000fc40000000f00ULL,
0x0000d92000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180d0f7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e000cULL,
0x0000556000137802ULL, 0x000fc40000000f00ULL, 0x0000d8d000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002006b7824ULL, 0x000fe200078e00ffULL,
0x0000000702137812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x000000046b0d7812ULL, 0x002fc400078ec0ffULL, 0x00000008130c7812ULL, 0x008fe400078ef802ULL,
0x0000000d020d7211ULL, 0x000fc600078fe0ffULL, 0x000000080c487824ULL, 0x040fe400078e00ffULL,
0x000000010c0d7824ULL, 0x000fe200078e020dULL, 0x00000008020c7812ULL, 0x000fc800078ec0ffULL,
0xfffffff848487812ULL, 0x000fca00078ee20dULL, 0x0000001048487824ULL, 0x000fc400078e0241ULL,
0x00000004000f7824ULL, 0x004fe200078e00ffULL, 0x000000130c137212ULL, 0x000fe200078efcffULL,
0x00000008034c7824ULL, 0x000fe200078e00ffULL, 0x00001000676c7810ULL, 0x000fe20007ffe0ffULL,
0x009800004834783bULL, 0x000e620000000200ULL, 0x000000040f0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000813127824ULL, 0x000fe200078e00ffULL, 0xfffffff86b6b7812ULL, 0x000fe400078ec0ffULL,
0x0000000f020c7211ULL, 0x000fca00078fe0ffULL, 0x00000001130f7824ULL, 0x000fe400078e020cULL,
0x0000000803137824ULL, 0x000fc600078e00ffULL, 0xfffffff8124d7812ULL, 0x040fe400078ee20fULL,
0x000000020f437810ULL, 0x000fe20007ffe0ffULL, 0x00000001030f7824ULL, 0x000fe400078e020cULL,
0x000000104d4d7824ULL, 0x100fe200078e026cULL, 0xfffffff812437812ULL, 0x000fe400078ee243ULL,
0xfffffff84c4c7812ULL, 0x000fe400078ee20fULL, 0x000000004d3c783bULL, 0x000ea20000004200ULL,
0x0000001043447824ULL, 0x100fe200078e026cULL, 0x000000020f427810ULL, 0x000fe20007ffe0ffULL,
0x000000104c387824ULL, 0x000fc600078e026cULL, 0xfffffff813427812ULL, 0x000fe200078ee242ULL,
0x000000004444783bULL, 0x000ee80000004200ULL, 0x000000003838783bULL, 0x000f220000004200ULL,
0x0000000534348232ULL, 0x082fe40000000000ULL, 0x0000000536368232ULL, 0x000fe40000000000ULL,
0x0000000435358232ULL, 0x000fc40000000000ULL, 0x0000000437378232ULL, 0x000fe20000000000ULL,
0x00000010ff137819ULL, 0x004fe4000001163cULL, 0x00000010ff127819ULL, 0x000fe4000001163dULL,
0x000000ff3c497812ULL, 0x000fe400078ec0ffULL, 0x000000ff13137812ULL, 0x000fe400078ec0ffULL,
0x000000ff3d527812ULL, 0x000fe400078ec0ffULL, 0x000000ff12127812ULL, 0x000fc400078ec0ffULL,
0x00000018ff537819ULL, 0x000fe4000001163cULL, 0x000000ff3e557812ULL, 0x000fe400078ec0ffULL,
0x0000ffff3c3c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff547819ULL, 0x000fe4000001163dULL,
0x0000ffff3d0f7812ULL, 0x000fe400078ec0ffULL, 0x00000049ff3d723eULL, 0x000fc400020006ffULL,
0x00000010ff5f7819ULL, 0x108fe40000011645ULL, 0x000000ff45607812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5e7819ULL, 0x000fe40000011645ULL, 0x0000ffff455a7812ULL, 0x000fe400078ec0ffULL,
0x00000013ff56723eULL, 0x000fe400020006ffULL, 0x00000052ff45723eULL, 0x000fc400020006ffULL,
0x00000012ff12723eULL, 0x000fe400020006ffULL, 0x00000055ff52723eULL, 0x000fe400020006ffULL,
0x00000008ff557819ULL, 0x000fe4000001163cULL, 0x000054103d3c7816ULL, 0x000fe40000000056ULL,
0x00005410453d7816ULL, 0x000fe40000000012ULL, 0x00000008ff0f7819ULL, 0x000fc4000001160fULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x0000003c3414723cULL, 0x000be20000001814ULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000010ff4b7819ULL, 0x000fe4000001163eULL, 0x00000010ff4e7819ULL, 0x000fe4000001163fULL,
0x000000ff3a3c7812ULL, 0x030fc400078ec0ffULL, 0x0000000fff3d723eULL, 0x000fe400020006ffULL,
0x0000003cff0f723eULL, 0x000fe400020006ffULL, 0x00005410553c7816ULL, 0x000fe40000000053ULL,
0x000054103d3d7816ULL, 0x000fe40000000054ULL, 0x000000ff3f4f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4b4b7812ULL, 0x000fc400078ec0ffULL, 0x000000ff4e4e7812ULL, 0x000fe200078ec0ffULL,
0x0000003c3418723cULL, 0x000b620000001818ULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x00000018ff697819ULL, 0x000fe4000001163eULL, 0x00000018ff637819ULL, 0x000fe4000001163fULL,
0x0000004bff3c723eULL, 0x020fe400020006ffULL, 0x0000004eff3d723eULL, 0x000fc400020006ffULL,
0x00005410523c7816ULL, 0x000fe4000000003cULL, 0x000054104f3d7816ULL, 0x000fe4000000003dULL,
0x0000ffff3e3e7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff737819ULL, 0x000fe4000001163eULL, 0x00000008ff717819ULL, 0x000fc4000001163fULL,
0x0000003c343c723cULL, 0x000be2000000181cULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000010421c7824ULL, 0x020fe200078e026cULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000010ff5d7819ULL, 0x000fc40000011644ULL, 0x000000ff446f7812ULL, 0x040fe200078ec0ffULL,
0x000000001c1c783bULL, 0x000e620000004200ULL, 0x00000018ff5c7819ULL, 0x000fe40000011644ULL,
0x0000ffff44597812ULL, 0x000fe400078ec0ffULL, 0x000000ff38447812ULL, 0x000fe400078ec0ffULL,
0x000000ff39137812ULL, 0x000fe400078ec0ffULL, 0x00000018ff127819ULL, 0x000fc40000011638ULL,
0x00000018ff457819ULL, 0x100fe40000011639ULL, 0x00000010ff567819ULL, 0x000fe40000011638ULL,
0x0000ffff38537812ULL, 0x000fe400078ec0ffULL, 0x00000010ff527819ULL, 0x000fe40000011639ULL,
0x0000ffff39557812ULL, 0x000fe400078ec0ffULL, 0x0000541073387816ULL, 0x000fc40000000069ULL,
0x0000541071397816ULL, 0x000fe40000000063ULL, 0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff597819ULL, 0x000fe20000011659ULL,
0x000000383420723cULL, 0x000b620000001820ULL, 0x00000008ff5a7819ULL, 0x000fe4000001165aULL,
0x0000006fff6f723eULL, 0x000fc400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000005dff38723eULL, 0x020fe400020006ffULL, 0x0000005fff39723eULL, 0x000fe400020006ffULL,
0x00000010ff507819ULL, 0x000fe40000011646ULL, 0x00000010ff517819ULL, 0x000fe40000011647ULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x000054106f387816ULL, 0x000fe40000000038ULL, 0x0000541060397816ULL, 0x000fe40000000039ULL,
0x000000ff505d7812ULL, 0x000fc400078ec0ffULL, 0x000000ff515f7812ULL, 0x000fe400078ec0ffULL,
0x0000541059507816ULL, 0x000fe4000000005cULL, 0x000054105a517816ULL, 0x000fe4000000005eULL,
0x000000ff46627812ULL, 0x000fe400078ec0ffULL, 0x000000ff475b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff547819ULL, 0x100fe2000001163aULL, 0x000000503428723cULL, 0x000fe20000001828ULL,
0x00000018ff577819ULL, 0x000fc4000001163aULL, 0x0000ffff3a4b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4e7819ULL, 0x100fe4000001163bULL, 0x000000ff3b687812ULL, 0x040fe400078ec0ffULL,
0x00000018ff587819ULL, 0x000fe4000001163bULL, 0x0000ffff3b4f7812ULL, 0x000fe400078ec0ffULL,
0x000000383438723cULL, 0x000b620000001824ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x009800006124783bULL, 0x0204e20000000200ULL, 0x0000005bff5b723eULL, 0x000fc400020006ffULL,
0x0000005dff50723eULL, 0x000fe400020006ffULL, 0x0000005fff51723eULL, 0x000fe400020006ffULL,
0x0000541062507816ULL, 0x000fe40000000050ULL, 0x000054105b517816ULL, 0x000fe40000000051ULL,
0x00000018ff497819ULL, 0x000fe40000011646ULL, 0x00000018ff4a7819ULL, 0x000fc40000011647ULL,
0x0000ffff46467812ULL, 0x000fe200078ec0ffULL, 0x00000050342c723cULL, 0x000b62000000182cULL,
0x0000ffff47477812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5d7819ULL, 0x102fe4000001161cULL,
0x000000ff1c617812ULL, 0x044fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001161cULL,
0x0000ffff1c517812ULL, 0x020fc400078ec0ffULL, 0x00000008ff1c7819ULL, 0x000fe40000011646ULL,
0x00000008ff477819ULL, 0x000fe40000011647ULL, 0x00000068ff59723eULL, 0x000fe400020006ffULL,
0x00000010ff5e7819ULL, 0x100fe4000001161dULL, 0x000000ff1d627812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5f7819ULL, 0x000fc4000001161dULL, 0x0000ffff1d5a7812ULL, 0x000fe200078ec0ffULL,
0x0000000524248232ULL, 0x088fe20000000000ULL, 0x00000049ff63723eULL, 0x000fe200020006ffULL,
0x0000000526268232ULL, 0x000fe20000000000ULL, 0x0000004aff68723eULL, 0x000fe200020006ffULL,
0x0000000425258232ULL, 0x080fe20000000000ULL, 0x0000001cff1c723eULL, 0x000fe200020006ffULL,
0x0000000427278232ULL, 0x000fe20000000000ULL, 0x00000047ff1d723eULL, 0x000fe400020006ffULL,
0x000054101c1c7816ULL, 0x000fc40000000063ULL, 0x000054101d1d7816ULL, 0x000fe40000000068ULL,
0x000000ff52527812ULL, 0x000fe400078ec0ffULL, 0x00000013ff13723eULL, 0x000fe400020006ffULL,
0x00000008ff537819ULL, 0x000fe20000011653ULL, 0x0000001c3430723cULL, 0x000b620000001830ULL,
0x00000008ff557819ULL, 0x000fe40000011655ULL, 0x00000012ff12723eULL, 0x000fc400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000052ff1d723eULL, 0x020fe400020006ffULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x00005410131d7816ULL, 0x000fe4000000001dULL,
0x00000055ff13723eULL, 0x000fe400020006ffULL, 0x0000541053127816ULL, 0x000fc40000000012ULL,
0x0000541013137816ULL, 0x000fe40000000045ULL, 0x00000008ff4b7819ULL, 0x000fe4000001164bULL,
0x00000008ff4f7819ULL, 0x000fe4000001164fULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x000000122418723cULL, 0x000b620000001818ULL, 0x00000058ff47723eULL, 0x000fe400020006ffULL,
0x000000ff5d5d7812ULL, 0x000fc400078ec0ffULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x0000004bff12723eULL, 0x020fe400020006ffULL, 0x0000004fff13723eULL, 0x000fe400020006ffULL,
0x0000541012127816ULL, 0x000fe40000000057ULL, 0x0000541013137816ULL, 0x000fe40000000047ULL,
0x00000061ff61723eULL, 0x000fc400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000010ff4a7819ULL, 0x100fe2000001161eULL, 0x000000122420723cULL, 0x000b620000001820ULL,
0x000000ff1e607812ULL, 0x000fe400078ec0ffULL, 0x00000018ff497819ULL, 0x000fe4000001161eULL,
0x00000010ff507819ULL, 0x000fe4000001161fULL, 0x0000005dff12723eULL, 0x020fc400020006ffULL,
0x0000005eff13723eULL, 0x000fe400020006ffULL, 0x000000ff1f5b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff467819ULL, 0x000fe4000001161fULL, 0x000000ff54547812ULL, 0x000fe400078ec0ffULL,
0x0000541061127816ULL, 0x000fe40000000012ULL, 0x0000541062137816ULL, 0x000fc40000000013ULL,
0x0000ffff1e1e7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff1f1f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff56567812ULL, 0x000fe200078ec0ffULL, 0x000000122438723cULL, 0x000b620000001838ULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x000000ff4e4e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff517819ULL, 0x000fc40000011651ULL, 0x00000008ff5a7819ULL, 0x000fe4000001165aULL,
0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff50507812ULL, 0x000fe400078ec0ffULL,
0x00000008ff1e7819ULL, 0x000fe4000001161eULL, 0x00000008ff1f7819ULL, 0x000fe4000001161fULL,
0x00000044ff44723eULL, 0x000fc400020006ffULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x000054100f587816ULL, 0x000fe40000000054ULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000051ff12723eULL, 0x020fe400020006ffULL, 0x0000005aff13723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe400020006ffULL,
0x00000049ff0f723eULL, 0x000fc400020006ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x0000001eff1e723eULL, 0x000fe400020006ffULL, 0x0000001fff1f723eULL, 0x000fe400020006ffULL,
0x00005410441c7816ULL, 0x000fe40000000056ULL, 0x0000541059597816ULL, 0x000fe4000000004eULL,
0x0000541012127816ULL, 0x000fc4000000005cULL, 0x0000541013137816ULL, 0x000fe2000000005fULL,
0x0000001c2414723cULL, 0x040f620000001814ULL, 0x0000541060607816ULL, 0x000fe4000000004aULL,
0x000054105b617816ULL, 0x000fe40000000050ULL, 0x000054101e1e7816ULL, 0x000fe4000000000fULL,
0x000054101f1f7816ULL, 0x000fe20000000046ULL, 0x00000058243c723cULL, 0x040f70000000183cULL,
0x000000122428723cULL, 0x040b6e0000001828ULL, 0x0000f6c864127811ULL, 0x020fe200078e18ffULL,
0x00000060242c723cULL, 0x040b70000000182cULL, 0x0000001e2424723cULL, 0x000b620000001830ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000012127f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f690006bff7f8cULL, 0x0005e4000c80043fULL, 0x00000000001c7805ULL, 0x000fc40000015200ULL,
0x00000400080f7984ULL, 0x000ee40000000800ULL, 0x800000000fff7812ULL, 0x00afc40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x020fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c1e7210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09001e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc8000001141fULL,
0x0000001e0f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff1e7224ULL, 0x000fca00000e061fULL,
0x000000020f0f7819ULL, 0x000fc8000000121eULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000130307810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400080f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000c040127810ULL, 0x000fca0007ffe0ffULL, 0x000068006a317a24ULL, 0x000fe200078e0212ULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x000000126d0f7217ULL, 0x000fe20007800000ULL,
0x00000010661c7824ULL, 0x000fe200078e00ffULL, 0x00000003ff137819ULL, 0x000fc60000011602ULL,
0x000000010f0f7824ULL, 0x000fe200078e0a12ULL, 0x00000004131e7810ULL, 0x040fe20007ffe0ffULL,
0x000000011c127824ULL, 0x040fe200078e0213ULL, 0x0000000c131f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1c0f7217ULL, 0x000fe20007800000ULL, 0x00000001121d7824ULL, 0x040fe400078e0202ULL,
0x0000000812307824ULL, 0x000fe400078e00ffULL, 0x000000010f0f7824ULL, 0x000fc400078e0a1cULL,
0x0000000112127824ULL, 0x000fe200078e0231ULL, 0xfffffff830337812ULL, 0x000fe200078ee21dULL,
0x000000011c327824ULL, 0x000fe200078e021fULL, 0x0000000f1e00720cULL, 0x080fe20003f66070ULL,
0x000000011c1e7824ULL, 0x000fe200078e021eULL, 0x00000008131d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000f1300720cULL, 0x080fe20003f86070ULL, 0x000000011e137824ULL, 0x040fe200078e0202ULL,
0x0000000f1d00720cULL, 0x080fe20003f46070ULL, 0x000000081e307824ULL, 0x040fe200078e00ffULL,
0x0000000f1f00720cULL, 0x000fe20003f06070ULL, 0x000000011e1e7824ULL, 0x000fc400078e0231ULL,
0x000000011c1d7824ULL, 0x000fe200078e021dULL, 0xfffffff830357812ULL, 0x000fe200078ee213ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000006512127212ULL, 0x000fc600078efcffULL, 0x000000011d307824ULL, 0x140fe200078e0231ULL,
0x0000640012127a10ULL, 0x000fe20007fbe0ffULL, 0x000000011d0f7824ULL, 0x040fe200078e0202ULL,
0x000000651e1e7212ULL, 0x080fe200078efcffULL, 0x000000081d347824ULL, 0x000fe200078e00ffULL,
0x0000650013137a10ULL, 0x000fe20002ffe4ffULL, 0x00000001321c7824ULL, 0x000fe200078e0231ULL,
0x000064001e1e7a10ULL, 0x000fe20007fbe0ffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0xfffffff834377812ULL, 0x000fe400078ee20fULL, 0x000065001f1f7a10ULL, 0x000fe20002ffe4ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000006530307212ULL, 0x000fc600078efcffULL,
0x00000001320f7824ULL, 0x000fe200078e0202ULL, 0x000000651c1c7212ULL, 0x000fe200078efcffULL,
0x0000000832327824ULL, 0x000fe200078e00ffULL, 0x0000640030307a10ULL, 0x000fe40007fbe0ffULL,
0x000064001c1c7a10ULL, 0x000fe40007fde0ffULL, 0xfffffff832457812ULL, 0x000fe200078ee20fULL,
0x00000010330f7824ULL, 0x100fe200078e026cULL, 0x0000650031317a10ULL, 0x000fe20002ffe4ffULL,
0x0000001035337824ULL, 0x100fe200078e026cULL, 0x000065001d1d7a10ULL, 0x000fe200037fe4ffULL,
0x0000001037357824ULL, 0x100fe200078e026cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120f7faeULL, 0x0003e2000e101c46ULL, 0x0000001045377824ULL, 0x000fc600078e026cULL,
0x000000001e337faeULL, 0x0003e8000d901c46ULL, 0x0000000030357faeULL, 0x0003e8000d101c46ULL,
0x000000001c377faeULL, 0x0003e2000c101c46ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x00000010660f7824ULL, 0x000fca00078e00ffULL, 0x0000000f020f7211ULL, 0x000fc800078fe8ffULL,
0x000000040f1e7810ULL, 0x040fe20007ffe0ffULL, 0x000000010f127824ULL, 0x140fe200078e0202ULL,
0x000000080f307810ULL, 0x040fe20007ffe0ffULL, 0x000000080f337824ULL, 0x000fe400078e00ffULL,
0x000000011e137824ULL, 0x040fe400078e0202ULL, 0x000000081e1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee212ULL, 0x00000001301d7824ULL, 0x040fe400078e0202ULL,
0x0000000830327824ULL, 0x000fe200078e00ffULL, 0xfffffff81c357812ULL, 0x000fe200078ee213ULL,
0x000000010f1c7824ULL, 0x140fe200078e0231ULL, 0x0000000c0f0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000011e1e7824ULL, 0x000fe200078e0231ULL, 0xfffffff832377812ULL, 0x000fe200078ee21dULL,
0x000000801c1c7825ULL, 0x000fc800078e00ffULL, 0x0000000130307824ULL, 0x100fe200078e0231ULL,
0x000000651c1c7212ULL, 0x000fe200078efcffULL, 0x000000010f127824ULL, 0x000fe400078e0231ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000064001c1c7a10ULL, 0x000fc60007f1e0ffULL,
0x0000008030307825ULL, 0x000fe200078e00ffULL, 0x000000651e1e7212ULL, 0x080fe400078efcffULL,
0x000065001d1d7a10ULL, 0x000fe200007fe4ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000006530307212ULL, 0x080fe400078efcffULL, 0x000064001e1e7a10ULL, 0x000fe20007f5e0ffULL,
0x000000010f327824ULL, 0x040fe200078e0202ULL, 0x0000006512127212ULL, 0x000fe200078efcffULL,
0x000000080f457824ULL, 0x000fe200078e00ffULL, 0x0000640030307a10ULL, 0x000fe20007f1e0ffULL,
0x00000010330f7824ULL, 0x100fe200078e026cULL, 0x0000640012127a10ULL, 0x000fe20007f7e0ffULL,
0x0000001035337824ULL, 0x000fe200078e026cULL, 0xfffffff845457812ULL, 0x000fe200078ee232ULL,
0x0000001037357824ULL, 0x100fe200078e026cULL, 0x000065001f1f7a10ULL, 0x000fe200017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c0f7faeULL, 0x0003e2000b901c46ULL,
0x0000650031317a10ULL, 0x000fe200007fe4ffULL, 0x0000001045377824ULL, 0x000fe200078e026cULL,
0x0000650013137a10ULL, 0x000fe20001ffe4ffULL, 0x000000001e337faeULL, 0x0003e8000b901c46ULL,
0x0000000030357faeULL, 0x0003e8000b901c46ULL, 0x0000000012377faeULL, 0x0003e4000b901c46ULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0xfffffff00a1c7812ULL, 0x000fce00078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6b0001c1c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6480007127f8cULL, 0x0006a4000c80043fULL, 0x00000000001e7805ULL, 0x000fc40000015200ULL,
0xffffffe00a077812ULL, 0x048fe400078ec0ffULL, 0x000000100a307812ULL, 0x040fe400078ec0ffULL,
0x000000080a0f7812ULL, 0x000fc800078ec0ffULL, 0x000000070f077210ULL, 0x000fca0007ffe030ULL,
0x00f64c00070f7984ULL, 0x000ee40000000800ULL, 0x800000000fff7812ULL, 0x00cfe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000307805ULL, 0x000fcc0000015200ULL, 0x000000301e307210ULL, 0x000fca0007f1e1ffULL,
0x0000000131317824ULL, 0x000fe200000e0e1fULL, 0x003d09003000780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403000780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011431ULL,
0x000000300f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff307224ULL, 0x000fca00000e0631ULL,
0x000000020f0f7819ULL, 0x000fc80000001230ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000132327810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c00070f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002000077824ULL, 0x000fca00078e00ffULL, 0xffffff8007127812ULL, 0x000fc800078ec0ffULL,
0x0000010065077810ULL, 0x000fca0007ffe012ULL, 0x0000000174077824ULL, 0x000fca00078e0207ULL,
0x00f00000071e7984ULL, 0x000ea80000000800ULL, 0x00f20000071f7984ULL, 0x0006620000000800ULL,
0x0000000b1e00720bULL, 0x004fe20003f1d000ULL, 0x0000b2b27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000f7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0f307812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fd200078e000bULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000026e077810ULL, 0x000fe40007ffe0ffULL, 0x0000000b1e00720bULL, 0x000fe40003f54000ULL,
0x000000000700720cULL, 0x000fe20003f05270ULL, 0x0000b2527f007947ULL, 0x000fd4000b800000ULL,
0x0000000000077806ULL, 0x000fc400010e0100ULL, 0x0000008000138824ULL, 0x000fe200078e0265ULL,
0x0000000b1e0f8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991007127816ULL, 0x000fe200000000ffULL, 0x0000000174328824ULL, 0x000fca00078e0213ULL,
0x00f4000f32008388ULL, 0x0005e20000000800ULL, 0x000000ff1200720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000b1e127209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff07ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000b120f7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL,
0x0000000f00317308ULL, 0x000ea40000000800ULL, 0x000000310e0e7220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0f7819ULL, 0x000fe20000011602ULL,
0x0000b1727f007947ULL, 0x000fea000b800000ULL, 0x00001f0f310f7589ULL, 0x0004e400000e0000ULL,
0x0000000f14147220ULL, 0x08cfe20000410000ULL, 0x0000000f15157220ULL, 0x080fe20000410000ULL,
0x0000000f18187220ULL, 0x080fe20000410000ULL, 0x0000000f19197220ULL, 0x080fe20000410000ULL,
0x0000000f3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000f3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000f20207220ULL, 0x080fe20000410000ULL, 0x0000000f21217220ULL, 0x080fe20000410000ULL,
0x0000000f38387220ULL, 0x080fe20000410000ULL, 0x0000000f39397220ULL, 0x080fe20000410000ULL,
0x0000000f28287220ULL, 0x080fe20000410000ULL, 0x0000000f29297220ULL, 0x080fe20000410000ULL,
0x0000000f2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000f2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000f24247220ULL, 0x080fe20000410000ULL, 0x0000000f25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0007ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008020f7811ULL, 0x000fe200078ff0ffULL,
0x0000b0527f007947ULL, 0x000fea000b800000ULL, 0x00001f0f310f7589ULL, 0x0004e400000e0000ULL,
0x0000000f16167220ULL, 0x08cfe20000410000ULL, 0x0000000f17177220ULL, 0x080fe20000410000ULL,
0x0000000f1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000f1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000f3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000f22227220ULL, 0x080fe20000410000ULL, 0x0000000f23237220ULL, 0x080fe20000410000ULL,
0x0000000f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000f2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000f26267220ULL, 0x080fe20000410000ULL, 0x0000000f27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff30ff7812ULL, 0x000fe20007806007ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000b1e077209ULL, 0x000fd60007810000ULL,
0x800000071e1e0221ULL, 0x000fe20000010000ULL, 0x00007610ff0f0816ULL, 0x000fc6000000000fULL,
0x3fb8aa3b1e1e0820ULL, 0x000fc80000410000ULL, 0x0000001e00060308ULL, 0x000ea40000000800ULL,
0x000000061f1f0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000e1f0e7221ULL, 0x002fc20000010000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0xfffffff00a317812ULL, 0x000fca00078ec0ffULL, 0x00f6ac00310b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e121e7210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e13ULL,
0x003d09001e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc8000001141fULL, 0x0000001e0b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff1e7224ULL, 0x000fca00000e061fULL, 0x000000020b0b7819ULL, 0x000fc8000000121eULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000130307810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac00310b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100f0b7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0b00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000006ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff107819ULL, 0x000fe40000011602ULL, 0x00005410040b7816ULL, 0x000fe20000000004ULL,
0x0000ac127f007947ULL, 0x000fea000b800000ULL, 0x00001f100b057589ULL, 0x0002a400000e0000ULL,
0x00000008100f7810ULL, 0x000fe20007ffe0ffULL, 0x0000ac427f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0b047589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010100f7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e000bULL,
0x00007ba000137802ULL, 0x000fc40000000f00ULL, 0x0000b29000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018100f7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e000bULL, 0x00007bf000137802ULL, 0x000fc40000000f00ULL,
0x0000b24000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001043107824ULL, 0x102fe200078e0267ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000001042307824ULL, 0x000fe200078e0267ULL, 0x00a000004848783bULL, 0x000e620000000200ULL,
0x00000008020f7812ULL, 0x00cfc600078ec0ffULL, 0x000000001010783bULL, 0x000ea20000004200ULL,
0x000000070f377812ULL, 0x000fc600078ef802ULL, 0x000000003030783bULL, 0x000ee20000004200ULL,
0x0000000548488232ULL, 0x082fe40000000000ULL, 0x000000054a4a8232ULL, 0x000fe20000000000ULL,
0x00000010ff577819ULL, 0x104fe20000011611ULL, 0x0000000449498232ULL, 0x080fe20000000000ULL,
0x000000ff115a7812ULL, 0x040fe200078ec0ffULL, 0x000000044b4b8232ULL, 0x000fe20000000000ULL,
0x00000018ff587819ULL, 0x000fe40000011611ULL, 0x0000ffff111f7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff567819ULL, 0x100fe40000011613ULL, 0x000000ff13117812ULL, 0x040fe400078ec0ffULL,
0x00000018ff457819ULL, 0x000fe40000011613ULL, 0x0000ffff13467812ULL, 0x000fe400078ec0ffULL,
0x0000000702137812ULL, 0x000fe400078ec0ffULL, 0x00000010ff477819ULL, 0x000fc40000011612ULL,
0x0000000813137812ULL, 0x000fe400078ef802ULL, 0x000000ff125c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff447819ULL, 0x000fe20000011612ULL, 0x0000000813137824ULL, 0x000fe200078e00ffULL,
0x0000ffff12557812ULL, 0x000fe400078ec0ffULL, 0x000000020d127810ULL, 0x000fe40007ffe0ffULL,
0x00000018ff0b7819ULL, 0x000fc40000011610ULL, 0xfffffff813127812ULL, 0x000fe400078ee212ULL,
0x00000010ff507819ULL, 0x000fe40000011610ULL, 0x00000010ff347819ULL, 0x108fe40000011631ULL,
0x000000ff31537812ULL, 0x040fe400078ec0ffULL, 0x00000018ff597819ULL, 0x000fe40000011631ULL,
0x0000ffff31527812ULL, 0x000fe200078ec0ffULL, 0x0000000837317824ULL, 0x000fe200078e00ffULL,
0x00000010ff437819ULL, 0x000fc40000011632ULL, 0x000000ff32367812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4e7819ULL, 0x000fe40000011632ULL, 0x0000ffff320f7812ULL, 0x000fe200078ec0ffULL,
0x0000000137327824ULL, 0x000fe200078e020cULL, 0x000000ff105b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff101e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff357819ULL, 0x000fc40000011630ULL,
0x000000ff30547812ULL, 0x040fe400078ec0ffULL, 0x00000018ff107819ULL, 0x000fe40000011630ULL,
0x0000ffff30517812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4f7819ULL, 0x100fe40000011633ULL,
0x000000ff33377812ULL, 0x000fe400078ec0ffULL, 0x00000018ff0c7819ULL, 0x000fc40000011633ULL,
0x0000ffff33427812ULL, 0x000fe400078ec0ffULL, 0x0000000bff33723eULL, 0x000fe200020006ffULL,
0x00000010120b7824ULL, 0x000fe200078e00ffULL, 0x00000011ff30723eULL, 0x000fe400020006ffULL,
0x000000ff50117812ULL, 0x000fe400078ec0ffULL, 0x000000ff57577812ULL, 0x000fe400078ec0ffULL,
0xfffffff831327812ULL, 0x000fc400078ee232ULL, 0x0000005cff31723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x0000001032327824ULL, 0x000fe200078e0267ULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000011ff5c723eULL, 0x000fe400020006ffULL,
0x00000057ff5d723eULL, 0x000fe400020006ffULL, 0x0000a00041127810ULL, 0x000fc40007ffe00bULL,
0x00000059ff41723eULL, 0x000fe400020006ffULL, 0x00000008ff577819ULL, 0x000fe4000001161eULL,
0x00000008ff597819ULL, 0x000fe4000001161fULL, 0x000054105b1e7816ULL, 0x000fe4000000005cULL,
0x000054105a1f7816ULL, 0x000fe4000000005dULL, 0x00000058ff58723eULL, 0x000fc400020006ffULL,
0x00000010ff50723eULL, 0x000fe400020006ffULL, 0x000000ff47477812ULL, 0x000fe200078ec0ffULL,
0x0000001e4838723cULL, 0x000be20000001838ULL, 0x000000ff56567812ULL, 0x000fe200078ec0ffULL,
0x000000001210783bULL, 0x000e620000000200ULL, 0x00000008ff557819ULL, 0x000fe40000011655ULL,
0x00000008ff467819ULL, 0x000fe40000011646ULL, 0x00000057ff1e723eULL, 0x020fc400020006ffULL,
0x00000059ff1f723eULL, 0x000fe400020006ffULL, 0x000054101e1e7816ULL, 0x000fe40000000033ULL,
0x000054101f1f7816ULL, 0x000fe40000000058ULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe200020006ffULL,
0x0000001e4828723cULL, 0x000b620000001828ULL, 0x000000ff35357812ULL, 0x000fc400078ec0ffULL,
0x0000541046457816ULL, 0x000fe40000000045ULL, 0x000000ff34347812ULL, 0x000fe400078ec0ffULL,
0x00000047ff1e723eULL, 0x020fe400020006ffULL, 0x00000056ff1f723eULL, 0x000fe400020006ffULL,
0x00005410311e7816ULL, 0x000fe4000000001eULL, 0x00005410301f7816ULL, 0x000fc4000000001fULL,
0x00000055ff47723eULL, 0x000fe200020006ffULL, 0x000000003230783bULL, 0x000ea20000004200ULL,
0x00000036ff55723eULL, 0x000fe400020006ffULL, 0x0000541047447816ULL, 0x000fe20000000044ULL,
0x0000001e482c723cULL, 0x040b62000000182cULL, 0x00000037ff56723eULL, 0x000fe200020006ffULL,
0x0000000510108232ULL, 0x082fe20000000000ULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x0000000512128232ULL, 0x000fe20000000000ULL, 0x00000008ff517819ULL, 0x000fe20000011651ULL,
0x0000000411118232ULL, 0x080fe20000000000ULL, 0x00000035ff1e723eULL, 0x020fe200020006ffULL,
0x000000104c357824ULL, 0x000fe200078e0267ULL, 0x000000444844723cULL, 0x000b620000001824ULL,
0x00000008ff527819ULL, 0x000fe20000011652ULL, 0x0000000413138232ULL, 0x000fe20000000000ULL,
0x00000053ff53723eULL, 0x000fc400020006ffULL, 0x00000052ff1f723eULL, 0x000fe400020006ffULL,
0x00000034ff25723eULL, 0x020fe400020006ffULL, 0x000000003534783bULL, 0x000e620000004200ULL,
0x0000541054247816ULL, 0x000fe4000000001eULL, 0x00000051ff1e723eULL, 0x000fe400020006ffULL,
0x000054101f1f7816ULL, 0x000fe40000000041ULL, 0x000054101e1e7816ULL, 0x000fc40000000050ULL,
0x0000541053257816ULL, 0x000fe40000000025ULL, 0x000000ff43437812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f4f7812ULL, 0x000fe200078ec0ffULL, 0x0000001e1028723cULL, 0x000be20000001828ULL,
0x00000008ff0f7819ULL, 0x000fe4000001160fULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000043ff43723eULL, 0x000fc400020006ffULL, 0x0000004fff1f723eULL, 0x020fe200020006ffULL,
0x000000241024723cULL, 0x000be20000001838ULL, 0x0000000cff0c723eULL, 0x000fe400020006ffULL,
0x0000000fff0f723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x0000004eff38723eULL, 0x020fe400020006ffULL, 0x00005410551e7816ULL, 0x000fc40000000043ULL,
0x00005410561f7816ULL, 0x000fe4000000001fULL, 0x00000010ff587819ULL, 0x104fe40000011630ULL,
0x000000ff305d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe20000011630ULL,
0x0000001e102c723cULL, 0x000be2000000182cULL, 0x0000ffff30557812ULL, 0x000fe400078ec0ffULL,
0x00000010ff597819ULL, 0x000fc40000011631ULL, 0x000000ff315e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5a7819ULL, 0x000fe40000011631ULL, 0x0000ffff31567812ULL, 0x000fe400078ec0ffULL,
0x000054100f307816ULL, 0x000fe40000000038ULL, 0x0000541042317816ULL, 0x000fe4000000000cULL,
0x000000ff58587812ULL, 0x000fc400078ec0ffULL, 0x000000ff59597812ULL, 0x000fe400078ec0ffULL,
0x00000010ff527819ULL, 0x100fe40000011632ULL, 0x000000ff325b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff537819ULL, 0x000fe40000011632ULL, 0x0000ffff321e7812ULL, 0x020fe400078ec0ffULL,
0x00000010ff547819ULL, 0x000fc40000011633ULL, 0x000000ff33577812ULL, 0x040fe400078ec0ffULL,
0x00000018ff1f7819ULL, 0x000fe40000011633ULL, 0x0000ffff334e7812ULL, 0x000fe400078ec0ffULL,
0x000000301030723cULL, 0x000be20000001844ULL, 0x00000010ff4f7819ULL, 0x102fe40000011634ULL,
0x00000018ff417819ULL, 0x000fe40000011634ULL, 0x0000ffff34437812ULL, 0x000fc400078ec0ffULL,
0x000000ff34477812ULL, 0x020fe400078ec0ffULL, 0x00000010ff507819ULL, 0x100fe40000011635ULL,
0x000000ff35467812ULL, 0x040fe400078ec0ffULL, 0x00000018ff427819ULL, 0x000fe40000011635ULL,
0x0000ffff35447812ULL, 0x000fe400078ec0ffULL, 0x0000005dff34723eULL, 0x000fc400020006ffULL,
0x0000005eff35723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000541034347816ULL, 0x000fe40000000058ULL,
0x0000541035357816ULL, 0x000fe40000000059ULL, 0x00000008ff557819ULL, 0x000fc40000011655ULL,
0x00000008ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff397819ULL, 0x100fe40000011636ULL,
0x000000ff36517812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3a7819ULL, 0x000fe40000011636ULL,
0x0000ffff360c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3b7819ULL, 0x000fc40000011637ULL,
0x000000ff37457812ULL, 0x040fe400078ec0ffULL, 0x00000018ff0f7819ULL, 0x000fe40000011637ULL,
0x0000ffff37387812ULL, 0x000fe400078ec0ffULL, 0x000000344834723cULL, 0x000b620000001814ULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x000000ff52527812ULL, 0x000fc400078ec0ffULL, 0x00000055ff14723eULL, 0x020fe400020006ffULL,
0x00000056ff15723eULL, 0x000fe400020006ffULL, 0x0000541014147816ULL, 0x000fe4000000005cULL,
0x0000541015157816ULL, 0x000fe4000000005aULL, 0x000000ff54547812ULL, 0x000fe400078ec0ffULL,
0x00000008ff1e7819ULL, 0x000fc4000001161eULL, 0x00000008ff4e7819ULL, 0x000fe2000001164eULL,
0x000000144818723cULL, 0x000b620000001818ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x00000052ff14723eULL, 0x020fe400020006ffULL, 0x00000054ff15723eULL, 0x000fc400020006ffULL,
0x0000001fff52723eULL, 0x000fe400020006ffULL, 0x0000001eff1e723eULL, 0x000fe400020006ffULL,
0x0000004eff1f723eULL, 0x000fe400020006ffULL, 0x000054105b147816ULL, 0x000fe40000000014ULL,
0x0000541057157816ULL, 0x000fe40000000015ULL, 0x000054101e1e7816ULL, 0x000fc40000000053ULL,
0x000054101f1f7816ULL, 0x000fe40000000052ULL, 0x000000ff4f4f7812ULL, 0x000fe200078ec0ffULL,
0x000000144814723cULL, 0x040f62000000183cULL, 0x000000ff50507812ULL, 0x000fe400078ec0ffULL,
0x00000008ff437819ULL, 0x000fe40000011643ULL, 0x00000008ff447819ULL, 0x000fe40000011644ULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x0000001e4848723cULL, 0x000b620000001820ULL,
0x00000046ff46723eULL, 0x000fc400020006ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x0000004fff20723eULL, 0x020fe400020006ffULL,
0x00000050ff23723eULL, 0x000fe400020006ffULL, 0x00000043ff1e723eULL, 0x000fe400020006ffULL,
0x00000044ff1f723eULL, 0x000fc400020006ffULL, 0x0000541047207816ULL, 0x000fe40000000020ULL,
0x0000541046217816ULL, 0x000fe40000000023ULL, 0x000054101e1e7816ULL, 0x000fe40000000041ULL,
0x000054101f1f7816ULL, 0x000fe40000000042ULL, 0x000000ff39397812ULL, 0x000fe200078ec0ffULL,
0x000000201020723cULL, 0x000f620000001834ULL, 0x000000ff3b3b7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff0c7819ULL, 0x000fe4000001160cULL, 0x00000008ff387819ULL, 0x000fe40000011638ULL,
0x00000051ff51723eULL, 0x000fe200020006ffULL, 0x0000001e1018723cULL, 0x000b620000001818ULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x00000039ff39723eULL, 0x000fc400020006ffULL, 0x0000003bff1f723eULL, 0x020fe400020006ffULL,
0x0000000fff0f723eULL, 0x000fe400020006ffULL, 0x0000000cff0c723eULL, 0x000fe400020006ffULL,
0x00000038ff35723eULL, 0x000fe400020006ffULL, 0x00005410511e7816ULL, 0x000fe40000000039ULL,
0x00005410451f7816ULL, 0x000fc4000000001fULL, 0x000054100c347816ULL, 0x000fe4000000003aULL,
0x0000541035357816ULL, 0x000fe4000000000fULL, 0x0000f6986e0c7811ULL, 0x000fe200078e18ffULL,
0x0000001e1014723cULL, 0x040b700000001814ULL, 0x000000341034723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000008107f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000cff7f8cULL, 0x0007e4000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x00000400080f7984ULL, 0x000f240000000800ULL, 0x800000000fff7812ULL, 0x014fc40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e120f7210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1e7824ULL, 0x000fe200000e0e13ULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1e00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1e00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x008fc8000001141eULL,
0x0000000f0c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e061eULL,
0x000000020c0c7819ULL, 0x000fc8000000120fULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400080f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001090f7810ULL, 0x000fc80007ffe0ffULL, 0x000000700f00720cULL, 0x000fda0003f06070ULL,
0x0000072000000947ULL, 0x000fea0003800000ULL, 0x00000002090f7810ULL, 0x000fc80007ffe0ffULL,
0x000000700f00720cULL, 0x000fe40003f06070ULL, 0x00000100400f7810ULL, 0x000fca0007ffe0ffULL,
0x000068006a1f7a24ULL, 0x000fcc00078e020fULL, 0x000003d000008947ULL, 0x000fea0003800000ULL,
0x0000000f6d0c7217ULL, 0x008fe20007800000ULL, 0x0000001066117824ULL, 0x000fe200078e00ffULL,
0x00000003ff107819ULL, 0x000fc60000011602ULL, 0x000000010c0c7824ULL, 0x000fe200078e0a0fULL,
0x0000000410137810ULL, 0x040fe20007ffe0ffULL, 0x0000000111127824ULL, 0x040fe200078e0210ULL,
0x00000008101e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c110c7217ULL, 0x000fe20007800000ULL,
0x00000001120f7824ULL, 0x040fe400078e0202ULL, 0x00000008123a7824ULL, 0x000fe400078e00ffULL,
0x000000010c0c7824ULL, 0x000fc400078e0a11ULL, 0x0000000112127824ULL, 0x000fe200078e021fULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee20fULL, 0x00000001110f7824ULL, 0x000fe200078e0213ULL,
0x0000000c1300720cULL, 0x080fe20003f66070ULL, 0x0000000111387824ULL, 0x000fe200078e021eULL,
0x0000000c1000720cULL, 0x0c0fe20003f86070ULL, 0x000000080f397824ULL, 0x040fe200078e00ffULL,
0x0000000c10137810ULL, 0x000fe20007ffe0ffULL, 0x000000010f107824ULL, 0x000fe200078e0202ULL,
0x0000000c1e00720cULL, 0x080fe20003f46070ULL, 0x00000001381e7824ULL, 0x000fe200078e021fULL,
0x0000000c1300720cULL, 0x000fe20003f06070ULL, 0x00000001113b7824ULL, 0x000fe200078e0213ULL,
0xfffffff8390c7812ULL, 0x000fe200078ee210ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x000000010f107824ULL, 0x000fe200078e021fULL, 0x0000006512127212ULL, 0x000fe200078efcffULL,
0x00000001380f7824ULL, 0x000fe400078e0202ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fc60007fbe0ffULL, 0x00000008383c7824ULL, 0x000fe200078e00ffULL,
0x0000006510107212ULL, 0x080fe200078efcffULL, 0x000000013b387824ULL, 0x000fe200078e021fULL,
0x0000650013137a10ULL, 0x000fe20002ffe4ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee20fULL, 0x0000640010107a10ULL, 0x000fe20007fbe0ffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x000000651e1e7212ULL, 0x080fe400078efcffULL,
0x0000650011117a10ULL, 0x000fe20002ffe4ffULL, 0x000000013b0f7824ULL, 0x040fe200078e0202ULL,
0x0000006538387212ULL, 0x000fe200078efcffULL, 0x000000083b3e7824ULL, 0x000fe200078e00ffULL,
0x000064001e1e7a10ULL, 0x000fe20007fbe0ffULL, 0x000000100c3b7824ULL, 0x100fe200078e0267ULL,
0x0000640038387a10ULL, 0x000fe20007fde0ffULL, 0x000000103c3d7824ULL, 0x000fe200078e0267ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee20fULL, 0x000000103a0f7824ULL, 0x000fe200078e0267ULL,
0x000065001f1f7a10ULL, 0x000fc40002ffe4ffULL, 0x0000650039397a10ULL, 0x000fe200037fe4ffULL,
0x000000103e3f7824ULL, 0x000fe200078e0267ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120f7faeULL, 0x0005e8000e101c46ULL, 0x00000000103b7faeULL, 0x0005e8000d901c46ULL,
0x000000001e3d7faeULL, 0x0005e8000d101c46ULL, 0x00000000383f7faeULL, 0x0005e2000c101c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x00000010660f7824ULL, 0x000fca00078e00ffULL,
0x0000000f020f7211ULL, 0x000fc800078fe8ffULL, 0x000000040f387810ULL, 0x040fe20007ffe0ffULL,
0x000000010f0c7824ULL, 0x148fe200078e0202ULL, 0x000000080f1e7810ULL, 0x040fe20007ffe0ffULL,
0x000000080f137824ULL, 0x000fe400078e00ffULL, 0x0000000138107824ULL, 0x040fe400078e0202ULL,
0x0000000838397824ULL, 0x000fe200078e00ffULL, 0xfffffff8130c7812ULL, 0x000fe200078ee20cULL,
0x000000011e117824ULL, 0x040fe400078e0202ULL, 0x000000081e3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8393a7812ULL, 0x000fe200078ee210ULL, 0x000000010f107824ULL, 0x140fe200078e021fULL,
0x0000000c0f0f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000138387824ULL, 0x000fe200078e021fULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee211ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x000000011e1e7824ULL, 0x100fe200078e021fULL, 0x0000006510107212ULL, 0x000fe200078efcffULL,
0x000000010f127824ULL, 0x000fe400078e021fULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000640010107a10ULL, 0x000fc60007f1e0ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000006538387212ULL, 0x080fe400078efcffULL, 0x0000650011117a10ULL, 0x000fe200007fe4ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000651e1e7212ULL, 0x080fe400078efcffULL,
0x0000640038387a10ULL, 0x000fe20007f5e0ffULL, 0x000000010f3b7824ULL, 0x040fe200078e0202ULL,
0x0000006512127212ULL, 0x000fe200078efcffULL, 0x000000080f3e7824ULL, 0x000fe200078e00ffULL,
0x000064001e1e7a10ULL, 0x000fe20007f1e0ffULL, 0x000000100c0f7824ULL, 0x100fe200078e0267ULL,
0x0000640012127a10ULL, 0x000fe20007f7e0ffULL, 0x000000103c3d7824ULL, 0x000fe200078e0267ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee23bULL, 0x000000103a3b7824ULL, 0x100fe200078e0267ULL,
0x0000650039397a10ULL, 0x000fe200017fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100f7faeULL, 0x0005e2000b901c46ULL, 0x000065001f1f7a10ULL, 0x000fe200007fe4ffULL,
0x000000103e3f7824ULL, 0x000fe200078e0267ULL, 0x0000650013137a10ULL, 0x000fe20001ffe4ffULL,
0x00000000383b7faeULL, 0x0005e8000b901c46ULL, 0x000000001e3d7faeULL, 0x0005e8000b901c46ULL,
0x00000000123f7faeULL, 0x0005e4000b901c46ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x00000010640f7824ULL, 0x000fe200078e00ffULL, 0x000000080a0c7812ULL, 0x008fc400078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a04ULL, 0x000000100f0f7812ULL, 0x000fca00078ee2ffULL,
0x000000206e0f7824ULL, 0x000fc800078e020fULL, 0x000000010c0f7824ULL, 0x000fe200078e020fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff107f8cULL, 0x000ea2000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f668000f127f8cULL, 0x000662000c80043fULL, 0x000000ffff107224ULL, 0x004fc600078e0011ULL,
0x00000000001e7805ULL, 0x000fc80000015200ULL, 0x00f66c000f117984ULL, 0x000ea40000000800ULL,
0x8000000011ff7812ULL, 0x006fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x000000381e117210ULL, 0x000fca0007f1e1ffULL, 0x0000000139387824ULL, 0x000fe200000e0e1fULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff3800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff3800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc80000011438ULL, 0x000000110c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0638ULL, 0x000000020c0c7819ULL, 0x000fc80000001211ULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f66c000f117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001806e0c7811ULL, 0x000fc800078e38ffULL,
0x0000000c740c7210ULL, 0x000fca0007ffe065ULL, 0x00f000000c1e7984ULL, 0x000e680000000800ULL,
0x00f200000c1f7984ULL, 0x0004e20000000800ULL, 0x000000071e00720bULL, 0x002fe20003f1d000ULL,
0x00008ea27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000f7806ULL, 0x00cfc800000e0100ULL,
0x0000ffff0f397812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff117224ULL, 0x000fd200078e0007ULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x000000036e0f7810ULL, 0x000fe40007ffe0ffULL,
0x000000071e00720bULL, 0x000fe40003f54000ULL, 0x000000000f00720cULL, 0x000fe20003f05270ULL,
0x00008e427f007947ULL, 0x000fd4000b800000ULL, 0x00000000000c7806ULL, 0x000fc400010e0100ULL,
0x0000008000658824ULL, 0x000fe200078e0265ULL, 0x000000071e117209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099100c0f7816ULL, 0x000fe200000000ffULL,
0x0000000174748824ULL, 0x000fca00078e0265ULL, 0x00f4001174008388ULL, 0x0003e20000000800ULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000711077221ULL, 0x002fe20000010100ULL, 0x000000ff0cff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b07077820ULL, 0x000fcc0000410000ULL,
0x0000000700077308ULL, 0x000e640000000800ULL, 0x000000070e0e7220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0f7819ULL, 0x000fe20000011602ULL,
0x00008d727f007947ULL, 0x000fea000b800000ULL, 0x00001f0f070f7589ULL, 0x0002a400000e0000ULL,
0x0000000f20207220ULL, 0x084fe20000410000ULL, 0x0000000f21217220ULL, 0x080fe20000410000ULL,
0x0000000f18187220ULL, 0x080fe20000410000ULL, 0x0000000f19197220ULL, 0x080fe20000410000ULL,
0x0000000f14147220ULL, 0x080fe20000410000ULL, 0x0000000f15157220ULL, 0x080fe20000410000ULL,
0x0000000f34347220ULL, 0x080fe20000410000ULL, 0x0000000f35357220ULL, 0x080fe20000410000ULL,
0x0000000f24247220ULL, 0x080fe20000410000ULL, 0x0000000f25257220ULL, 0x080fe20000410000ULL,
0x0000000f28287220ULL, 0x080fe20000410000ULL, 0x0000000f29297220ULL, 0x080fe20000410000ULL,
0x0000000f2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000f2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000f30307220ULL, 0x080fe20000410000ULL, 0x0000000f31317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008020f7811ULL, 0x000fe200078ff0ffULL,
0x00008c527f007947ULL, 0x000fea000b800000ULL, 0x00001f0f070f7589ULL, 0x0004e400000e0000ULL,
0x0000000f22227220ULL, 0x08cfe20000410000ULL, 0x0000000f23237220ULL, 0x080fe20000410000ULL,
0x0000000f1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000f1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000f16167220ULL, 0x080fe20000410000ULL, 0x0000000f17177220ULL, 0x080fe20000410000ULL,
0x0000000f36367220ULL, 0x080fe20000410000ULL, 0x0000000f37377220ULL, 0x080fe20000410000ULL,
0x0000000f26267220ULL, 0x080fe20000410000ULL, 0x0000000f27277220ULL, 0x080fe20000410000ULL,
0x0000000f2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000f32327220ULL, 0x080fe20000410000ULL, 0x0000000f33337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff39ff7812ULL, 0x000fe2000780600cULL,
0x00000001ff0c7424ULL, 0x000fd800078e00ffULL, 0x0000001e111e0221ULL, 0x000fe20000010100ULL,
0x00007610ff0c0816ULL, 0x000fc6000000000cULL, 0x3fb8aa3b1e1e0820ULL, 0x000fc80000410000ULL,
0x0000001e00060308ULL, 0x000e640000000800ULL, 0x000000061f1f0220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000e1f387221ULL, 0x000fc40000010000ULL,
0x00000000000e7805ULL, 0x000fca0000015200ULL, 0xfffffff00a1e7812ULL, 0x000fe200078ec0ffULL,
0x0000000400127824ULL, 0x000fc800078e00ffULL, 0x00f6b4001e077984ULL, 0x000e620000000800ULL,
0x0000000412127812ULL, 0x000fe400078ec0ffULL, 0x8000000007ff7812ULL, 0x002fe4000780481dULL,
0x0000000212077812ULL, 0x000fe200078efcffULL, 0x0000000000007918ULL, 0x000ff00000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000103900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120e1f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0fULL, 0x003d09001f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001f12127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000139397810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6b4001e137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100c0c7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000006ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff1d7819ULL, 0x000fe40000011602ULL, 0x00005410040c7816ULL, 0x000fe20000000004ULL,
0x000087d27f007947ULL, 0x000fea000b800000ULL, 0x00001f1d0c057589ULL, 0x0002a400000e0000ULL,
0x000000081d0f7810ULL, 0x000fe20007ffe0ffULL, 0x000088027f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0c047589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000101d0f7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e000cULL,
0x0000a1a000137802ULL, 0x000fc40000000f00ULL, 0x00008c9000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000181d0f7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e000cULL, 0x0000a1f000137802ULL, 0x000fc40000000f00ULL,
0x00008c4000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000702137812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000802127812ULL, 0x000fc400078ec0ffULL, 0x00000008130c7812ULL, 0x00afe400078ef802ULL,
0x000000036e3a7810ULL, 0x000fc60007ffe0ffULL, 0x000000080c0c7824ULL, 0x000fca00078e00ffULL,
0xfffffff80c0d7812ULL, 0x000fca00078ee20dULL, 0x000000806e3c7824ULL, 0x000fca00078e020dULL,
0x0000a8003c3c7811ULL, 0x000fc400078e20ffULL, 0x0000100067677810ULL, 0x000fe20007ffe0ffULL,
0x000000004d0c783bULL, 0x004e620000004200ULL, 0x0000001312137212ULL, 0x000fe200078efcffULL,
0x00000008034b7824ULL, 0x000fe200078e00ffULL, 0x0000000702127211ULL, 0x000fe200078fe0ffULL,
0x000000104c1c7824ULL, 0x000fe400078e0267ULL, 0x00000008133e7824ULL, 0x040fe400078e00ffULL,
0x0000000113077824ULL, 0x100fe400078e0212ULL, 0x000000001c1c783bULL, 0x000fe20000004200ULL,
0x0000000103127824ULL, 0x000fc400078e0212ULL, 0xfffffff83e077812ULL, 0x000fe200078ee207ULL,
0x000008003a577824ULL, 0x000fe200078e020bULL, 0x000000003c3c783bULL, 0x000ea20000000200ULL,
0xfffffff84b4b7812ULL, 0x000fe400078ee212ULL, 0x0000001007407824ULL, 0x000fc600078e026cULL,
0x000000104b4b7824ULL, 0x000fe200078e0267ULL, 0x00000010ff127819ULL, 0x102fe4000001160cULL,
0x00000010ff507819ULL, 0x000fe4000001160dULL, 0x00000018ff137819ULL, 0x000fe4000001160cULL,
0x0000ffff0c587812ULL, 0x000fe400078ec0ffULL, 0x000000ff0e537812ULL, 0x000fe400078ec0ffULL,
0x000000ff0c467812ULL, 0x000fc400078ec0ffULL, 0x000000ff0d477812ULL, 0x000fe400078ec0ffULL,
0x000000ff12127812ULL, 0x000fe200078ec0ffULL, 0x000000053c3c8232ULL, 0x084fe20000000000ULL,
0x000000ff50507812ULL, 0x000fe200078ec0ffULL, 0x000000053e3e8232ULL, 0x000fe20000000000ULL,
0x00000010ff427819ULL, 0x100fe2000001161cULL, 0x000000043d3d8232ULL, 0x080fe20000000000ULL,
0x000000ff1c4c7812ULL, 0x000fe200078ec0ffULL, 0x000000043f3f8232ULL, 0x000fe20000000000ULL,
0x00000018ff437819ULL, 0x000fc4000001161cULL, 0x0000ffff1c487812ULL, 0x000fe400078ec0ffULL,
0x00000010ff417819ULL, 0x100fe4000001161dULL, 0x000000ff1d1c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff447819ULL, 0x000fe4000001161dULL, 0x0000ffff1d497812ULL, 0x000fe400078ec0ffULL,
0x00000013ff51723eULL, 0x000fc400020006ffULL, 0x00000010ff3b7819ULL, 0x100fe4000001161fULL,
0x000000ff1f4a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff077819ULL, 0x000fe4000001161fULL,
0x0000ffff1f0b7812ULL, 0x000fe400078ec0ffULL, 0x00000053ff1d723eULL, 0x000fe400020006ffULL,
0x00000008ff137819ULL, 0x000fc40000011658ULL, 0x00000046ff1f723eULL, 0x000fe400020006ffULL,
0x00000047ff52723eULL, 0x000fe400020006ffULL, 0x00000012ff12723eULL, 0x000fe400020006ffULL,
0x00000050ff53723eULL, 0x000fe400020006ffULL, 0x000000ff0f547812ULL, 0x000fe400078ec0ffULL,
0x00000013ff50723eULL, 0x000fc400020006ffULL, 0x0000ffff0d597812ULL, 0x000fe400078ec0ffULL,
0x000054101f127816ULL, 0x000fe40000000012ULL, 0x0000541052137816ULL, 0x000fe40000000053ULL,
0x00000010ff3a7819ULL, 0x100fe4000001161eULL, 0x000000ff1e457812ULL, 0x040fe400078ec0ffULL,
0x00000018ff397819ULL, 0x000fe2000001161eULL, 0x000000123c20723cULL, 0x000b620000001820ULL,
0x0000ffff1e037812ULL, 0x000fc400078ec0ffULL, 0x00000054ff1e723eULL, 0x000fe400020006ffULL,
0x00000018ff0c7819ULL, 0x000fe4000001160dULL, 0x00000008ff547819ULL, 0x000fe40000011659ULL,
0x00000010ff567819ULL, 0x100fe4000001160eULL, 0x00000018ff0d7819ULL, 0x000fe4000001160eULL,
0x0000ffff0e4e7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff0e7819ULL, 0x100fe4000001160fULL,
0x0000000cff55723eULL, 0x000fe400020006ffULL, 0x00000054ff13723eULL, 0x020fe400020006ffULL,
0x00000010ff4f7819ULL, 0x000fe4000001160fULL, 0x0000ffff0f4d7812ULL, 0x000fe400078ec0ffULL,
0x0000000dff47723eULL, 0x000fc400020006ffULL, 0x0000000eff46723eULL, 0x000fe400020006ffULL,
0x00900000570c783bULL, 0x000e620000000200ULL, 0x000000ff56567812ULL, 0x000fe400078ec0ffULL,
0x0000541050127816ULL, 0x000fe40000000051ULL, 0x0000541013137816ULL, 0x000fe40000000055ULL,
0x000000ff4f4f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4e7819ULL, 0x000fc4000001164eULL,
0x00000008ff4d7819ULL, 0x000fe2000001164dULL, 0x000000123c18723cULL, 0x000be20000001818ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x0000001cff50723eULL, 0x000fc400020006ffULL, 0x000054101d1c7816ULL, 0x000fe40000000056ULL,
0x00000044ff51723eULL, 0x000fe400020006ffULL, 0x00000045ff12723eULL, 0x020fe400020006ffULL,
0x000054101e1d7816ULL, 0x000fe4000000004fULL, 0x000054104e447816ULL, 0x000fe40000000047ULL,
0x000054104d457816ULL, 0x000fc40000000046ULL, 0x000000ff42427812ULL, 0x000fe200078ec0ffULL,
0x0000001c3c1c723cULL, 0x040b620000001814ULL, 0x00000043ff4f723eULL, 0x000fe200020006ffULL,
0x000000004b14783bULL, 0x020ea20000004200ULL, 0x00000042ff13723eULL, 0x000fe200020006ffULL,
0x000000050c0c8232ULL, 0x082fe20000000000ULL, 0x0000004cff4c723eULL, 0x000fe200020006ffULL,
0x000000050e0e8232ULL, 0x000fe20000000000ULL, 0x000000ff3a3a7812ULL, 0x000fe200078ec0ffULL,
0x000000443c44723cULL, 0x000b620000001834ULL, 0x000000040d0d8232ULL, 0x080fe20000000000ULL,
0x000054104c4c7816ULL, 0x000fe20000000013ULL, 0x000000040f0f8232ULL, 0x000fe20000000000ULL,
0x000000ff3b3b7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff037819ULL, 0x000fe40000011603ULL,
0x000000ff41347812ULL, 0x020fe400078ec0ffULL, 0x000000004040783bULL, 0x000e620000004200ULL,
0x00000008ff0b7819ULL, 0x000fe4000001160bULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x00005410504d7816ULL, 0x000fc40000000034ULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x0000003bff13723eULL, 0x000fe400020006ffULL,
0x0000541012127816ULL, 0x000fe2000000003aULL, 0x0000004c0c34723cULL, 0x000be20000001820ULL,
0x000054104a137816ULL, 0x000fe40000000013ULL, 0x00000008ff487819ULL, 0x000fe40000011648ULL,
0x00000008ff497819ULL, 0x000fc40000011649ULL, 0x00000039ff21723eULL, 0x020fe200020006ffULL,
0x000000120c1c723cULL, 0x000be2000000181cULL, 0x00000003ff20723eULL, 0x000fe400020006ffULL,
0x00000007ff23723eULL, 0x000fe400020006ffULL, 0x0000000bff22723eULL, 0x000fe400020006ffULL,
0x0000541020207816ULL, 0x000fe40000000021ULL, 0x0000541022217816ULL, 0x000fc40000000023ULL,
0x00000010ff3b7819ULL, 0x104fe40000011617ULL, 0x000000ff174a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff077819ULL, 0x000fe20000011617ULL, 0x000000200c20723cULL, 0x000be20000001844ULL,
0x0000ffff170b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff127819ULL, 0x022fe40000011640ULL,
0x000000ff40177812ULL, 0x000fc400078ec0ffULL, 0x00000018ff137819ULL, 0x000fe40000011640ULL,
0x0000ffff40557812ULL, 0x000fe400078ec0ffULL, 0x00000010ff407819ULL, 0x000fe40000011641ULL,
0x000000ff41457812ULL, 0x000fe400078ec0ffULL, 0x000000ff12127812ULL, 0x000fe400078ec0ffULL,
0x000000ff40407812ULL, 0x000fc400078ec0ffULL, 0x00000045ff46723eULL, 0x000fe400020006ffULL,
0x00000018ff447819ULL, 0x000fe40000011641ULL, 0x0000ffff41567812ULL, 0x000fe400078ec0ffULL,
0x00000013ff45723eULL, 0x000fe400020006ffULL, 0x00000017ff41723eULL, 0x000fe400020006ffULL,
0x00000012ff12723eULL, 0x000fc400020006ffULL, 0x00000040ff13723eULL, 0x000fe400020006ffULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x00000018ff477819ULL, 0x000fe40000011642ULL, 0x0000541041127816ULL, 0x000fe40000000012ULL,
0x0000541046137816ULL, 0x000fc40000000013ULL, 0x0000541048487816ULL, 0x000fe4000000004fULL,
0x0000541049497816ULL, 0x000fe40000000051ULL, 0x00000044ff4f723eULL, 0x000fe200020006ffULL,
0x000000123c24723cULL, 0x000be20000001824ULL, 0x00000047ff17723eULL, 0x000fe400020006ffULL,
0x00000008ff447819ULL, 0x000fe40000011655ULL, 0x00000008ff477819ULL, 0x000fc40000011656ULL,
0x00000044ff12723eULL, 0x020fe200020006ffULL, 0x000000480c18723cULL, 0x000be20000001818ULL,
0x00000047ff13723eULL, 0x000fe400020006ffULL, 0x00000010ff4b7819ULL, 0x100fe40000011614ULL,
0x000000ff144c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4e7819ULL, 0x000fe40000011614ULL,
0x0000ffff14487812ULL, 0x020fc400078ec0ffULL, 0x00000010ff147819ULL, 0x100fe40000011615ULL,
0x000000ff15547812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4d7819ULL, 0x000fe40000011615ULL,
0x0000ffff15497812ULL, 0x000fe400078ec0ffULL, 0x00000010ff397819ULL, 0x000fe40000011616ULL,
0x000000ff16157812ULL, 0x000fc400078ec0ffULL, 0x00000018ff3a7819ULL, 0x000fe40000011616ULL,
0x0000ffff16037812ULL, 0x000fe400078ec0ffULL, 0x00000010ff507819ULL, 0x000fe40000011642ULL,
0x00000010ff527819ULL, 0x000fe40000011643ULL, 0x0000541012127816ULL, 0x000fe40000000045ULL,
0x0000541013137816ULL, 0x000fc4000000004fULL, 0x00000018ff167819ULL, 0x000fe40000011643ULL,
0x000000ff42517812ULL, 0x040fe400078ec0ffULL, 0x000000ff43537812ULL, 0x040fe200078ec0ffULL,
0x000000123c28723cULL, 0x000be20000001828ULL, 0x0000ffff42427812ULL, 0x000fe400078ec0ffULL,
0x0000ffff43437812ULL, 0x000fe400078ec0ffULL, 0x000000ff50507812ULL, 0x000fc400078ec0ffULL,
0x000000ff52527812ULL, 0x000fe400078ec0ffULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000008ff437819ULL, 0x000fe40000011643ULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x00000050ff12723eULL, 0x020fc400020006ffULL,
0x00000052ff13723eULL, 0x000fe400020006ffULL, 0x00000016ff16723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x0000541051127816ULL, 0x000fe40000000012ULL, 0x0000541053137816ULL, 0x000fc40000000013ULL,
0x0000541042427816ULL, 0x000fe40000000017ULL, 0x0000541043437816ULL, 0x000fe40000000016ULL,
0x000000ff39397812ULL, 0x000fe200078ec0ffULL, 0x000000123c2c723cULL, 0x000b62000000182cULL,
0x000000ff3b3b7812ULL, 0x000fe400078ec0ffULL, 0x00000054ff40723eULL, 0x000fe400020006ffULL,
0x00000039ff39723eULL, 0x000fc400020006ffULL, 0x00000015ff13723eULL, 0x020fe400020006ffULL,
0x000000ff14127812ULL, 0x000fe400078ec0ffULL, 0x000000423c14723cULL, 0x000f620000001830ULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x00000012ff12723eULL, 0x000fe400020006ffULL,
0x0000003bff3b723eULL, 0x000fe400020006ffULL, 0x0000004dff41723eULL, 0x000fc400020006ffULL,
0x000000ff4b4b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff487819ULL, 0x000fe40000011648ULL,
0x00000008ff497819ULL, 0x000fe40000011649ULL, 0x00000008ff037819ULL, 0x000fe40000011603ULL,
0x00000008ff0b7819ULL, 0x000fe4000001160bULL, 0x00005410404d7816ULL, 0x000fc40000000012ULL,
0x0000541013127816ULL, 0x000fe40000000039ULL, 0x000054104a137816ULL, 0x000fe4000000003bULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x0000004bff4b723eULL, 0x000fe200020006ffULL, 0x000000120c2c723cULL, 0x000b62000000182cULL,
0x00000048ff48723eULL, 0x000fc400020006ffULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x00000007ff07723eULL, 0x000fe400020006ffULL,
0x00000003ff03723eULL, 0x000fe400020006ffULL, 0x0000000bff3b723eULL, 0x000fe400020006ffULL,
0x000054104c4c7816ULL, 0x000fc4000000004bULL, 0x0000541048487816ULL, 0x000fe4000000004eULL,
0x0000541049497816ULL, 0x000fe40000000041ULL, 0x00005410033a7816ULL, 0x000fe2000000003aULL,
0x0000004c0c24723cULL, 0x000b620000001824ULL, 0x000054103b3b7816ULL, 0x000fce0000000007ULL,
0x000000480c28723cULL, 0x040b700000001828ULL, 0x0000003a0c14723cULL, 0x020b620000001814ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x00000000080c7f8cULL, 0x0202a2000c80043fULL,
0x0000000109097810ULL, 0x000fc40007ffe0ffULL, 0x0000f6a06e077811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000007ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff037224ULL, 0x004fe200078e000dULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff654000007947ULL, 0x000fea000383ffffULL, 0x000000ff7000720cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0180000038007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000b2e000047802ULL, 0x004fc40000000f00ULL, 0x0000799000007944ULL, 0x00afea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003800037308ULL, 0x000f240000001000ULL,
0xbf80000003007423ULL, 0x010fc80000000038ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000f28000c1e9900ULL, 0x0000000000047919ULL, 0x004ea80000000000ULL,
0x0000000000077919ULL, 0x008ee20000000000ULL, 0x00000002ff067819ULL, 0x004fe40000011604ULL,
0x0000000807047811ULL, 0x008fe200078ff0ffULL, 0x0000000003057220ULL, 0x010fca0000410000ULL,
0x00001f0605007589ULL, 0x000ea800000e0000ULL, 0x00001f0405047589ULL, 0x000ee200000e0000ULL,
0x0000003400347220ULL, 0x044fe20000410000ULL, 0x0000003500357220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001900197220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002100217220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002900297220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000001400147220ULL, 0x040fe20000410000ULL, 0x0000001500157220ULL, 0x000fe20000410000ULL,
0x0000003604367220ULL, 0x048fe20000410000ULL, 0x0000003704377220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000001604167220ULL, 0x040fe20000410000ULL, 0x0000001704177220ULL, 0x000fc20000410000ULL,
0x0000000000007919ULL, 0x000f220000000000ULL, 0x000000282928723eULL, 0x000fc400000000ffULL,
0x0000002c2d2c723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000141514723eULL, 0x000fe400000000ffULL, 0x0000001e1f1e723eULL, 0x000fe400000000ffULL,
0x00000022230f723eULL, 0x000fc400000000ffULL, 0x000000262726723eULL, 0x000fe400000000ffULL,
0x0000002a2b13723eULL, 0x000fe400000000ffULL, 0x0000002e2f2e723eULL, 0x000fe400000000ffULL,
0x000000161717723eULL, 0x000fe400000000ffULL, 0x00000002ff057819ULL, 0x014fe40000011600ULL,
0x0000000200027812ULL, 0x000fc400078ec0ffULL, 0x0000000800077811ULL, 0x008fe200078ff0ffULL,
0x0000000805097824ULL, 0x040fe200078e00ffULL, 0x0000000502047211ULL, 0x040fe200078ff8ffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x000fe200078ff8ffULL,
0x00000008070e7824ULL, 0x000fe200078e00ffULL, 0x0000000204027810ULL, 0x040fe20007ffe0ffULL,
0x0000000805077824ULL, 0x000fe200078e00ffULL, 0x0000000404067810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL, 0x0000100066037824ULL, 0x000fe200078e00ffULL,
0xfffffff809087812ULL, 0x002fc400078ee202ULL, 0xfffffff807027812ULL, 0x000fe200078ee204ULL,
0x0000080064057824ULL, 0x000fe200078e0203ULL, 0x0000000604077810ULL, 0x000fe20007ffe0ffULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff8090a7812ULL, 0x000fe200078ee206ULL,
0x0000001002067824ULL, 0x000fe200078e0205ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x000000100e0e7824ULL, 0x100fe200078e0205ULL, 0x0000000804077812ULL, 0x000fe200078ec0ffULL,
0x0000001008087824ULL, 0x100fe200078e0205ULL, 0x000000343502723eULL, 0x000fe200000000ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0205ULL, 0x000000181904723eULL, 0x000fe200000000ffULL,
0x0000000106067824ULL, 0x000fe200078e0207ULL, 0x0000763226097816ULL, 0x000fe20000000013ULL,
0x000000100c0c7824ULL, 0x000fe200078e0205ULL, 0x0000541002107816ULL, 0x040fe20000000004ULL,
0x00000001070e7824ULL, 0x040fe200078e020eULL, 0x0000763202117816ULL, 0x000fe20000000004ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x0000001c1d02723eULL, 0x000fe200000000ffULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x000000202104723eULL, 0x000fe200000000ffULL,
0x0000001006007388ULL, 0x0003e20000000a00ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x000000242505723eULL, 0x000fc400000000ffULL, 0x0000763202077816ULL, 0x100fe40000000004ULL,
0x000000ff6400720cULL, 0x000fe40003f05270ULL, 0x0000541002067816ULL, 0x002fe40000000004ULL,
0x000000363702723eULL, 0x000fe400000000ffULL, 0x0000001a1b04723eULL, 0x000fe200000000ffULL,
0x0000000608007388ULL, 0x0003e40000000a00ULL, 0x0000541005067816ULL, 0x002fc40000000028ULL,
0x0000763205077816ULL, 0x000fca0000000028ULL, 0x000000060a007388ULL, 0x0003e40000000a00ULL,
0x000054102c067816ULL, 0x142fe40000000014ULL, 0x000076322c077816ULL, 0x000fca0000000014ULL,
0x000000060c007388ULL, 0x0003e40000000a00ULL, 0x0000541002067816ULL, 0x142fe40000000004ULL,
0x0000763202077816ULL, 0x000fe20000000004ULL, 0x0000000177027824ULL, 0x000fc800078e0200ULL,
0x000000060e007388ULL, 0x0003e20000000a00ULL, 0x0000001002027824ULL, 0x000fe200078e0203ULL,
0x000054101e0e7816ULL, 0x142fe4000000000fULL, 0x000076321e0f7816ULL, 0x000fca000000000fULL,
0x0004000e08007388ULL, 0x0003e40000000a00ULL, 0x0000541026087816ULL, 0x002fe40000000013ULL,
0x000054102e0e7816ULL, 0x140fe40000000017ULL, 0x000076322e0f7816ULL, 0x000fe20000000017ULL,
0x000400080a007388ULL, 0x000fe80000000a00ULL, 0x0004000e0c007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000002047984ULL, 0x000e680000000c00ULL,
0x0004000002147984ULL, 0x000ea80000000c00ULL, 0x0008000002107984ULL, 0x000ee80000000c00ULL,
0x000c000002187984ULL, 0x000f220000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x004fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x0000001307077230ULL, 0x008fe40000000000ULL,
0x0000001206067230ULL, 0x000fe40000000000ULL, 0x0000001105057230ULL, 0x000fe40000000000ULL,
0x0000001004047230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x010fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000402007388ULL, 0x000fe20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001402007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff067819ULL, 0x000fc80000011600ULL,
0x000000750600720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000087b06ULL, 0x000e620000209000ULL, 0x000000017b027824ULL, 0x000fe200078e0206ULL,
0x00005a00ff107a12ULL, 0x000fcc00078e33ffULL, 0x0000000800087308ULL, 0x002e640000001000ULL,
0x0ffffffe08047810ULL, 0x002fcc0007ffe0ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000ffff077224ULL, 0x004fc800078e0a05ULL,
0x00005a0007077a24ULL, 0x000fc800078e02ffULL, 0x00000007050f7227ULL, 0x000fc800078e0004ULL,
0x0000000106047824ULL, 0x000fe400078e0200ULL, 0x000000020f077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x0000000704057812ULL, 0x000fe400078ec0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x0ffffff805047812ULL, 0x000fca00078ef800ULL, 0x0000001004067824ULL, 0x000fe400078e0203ULL,
0x0000000107071810ULL, 0x000fc60007ffe0ffULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000710077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007057a24ULL, 0x000fe200078e0272ULL, 0x0000000700077812ULL, 0x000fe200078ec0ffULL,
0x00005a000d027a24ULL, 0x000fc800078e0202ULL, 0x00005a0005057a24ULL, 0x000fe200078e0202ULL,
0x0000002000027810ULL, 0x000fe20007ffe0ffULL, 0x0000000866077824ULL, 0x000fc600078e0207ULL,
0x0000000576057210ULL, 0x000fe40007f3e0ffULL, 0x00000003ff067819ULL, 0x002fc60000011602ULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f440cULL, 0x000000750600720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000017b047824ULL, 0x102fe200078e0206ULL,
0x00000040000c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000102067824ULL, 0x000fe400078e0206ULL,
0x000000040f077227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fca00078e0204ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0000000706057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805067812ULL, 0x000fca00078ef802ULL, 0x0000001006067824ULL, 0x000fe400078e0203ULL,
0x0000000107072810ULL, 0x000fc60007ffe0ffULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000710077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007057a24ULL, 0x000fe200078e0272ULL, 0x0000000702077812ULL, 0x000fe200078ec0ffULL,
0x00005a000d047a24ULL, 0x000fe200078e0204ULL, 0x00000003ff027819ULL, 0x000fc6000001160cULL,
0x00005a0005057a24ULL, 0x000fe400078e0204ULL, 0x0000000866077824ULL, 0x000fc600078e0207ULL,
0x0000000576057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f440eULL,
0x000000750200720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000017b047824ULL, 0x102fe200078e0202ULL, 0x0000006000007810ULL, 0x000fe20007ffe0ffULL,
0x000000010c027824ULL, 0x000fe400078e0202ULL, 0x000000040f067227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a06ULL, 0x00005a0005057a24ULL, 0x000fca00078e0204ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0000000702057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805027812ULL, 0x000fca00078ef80cULL,
0x0000001002027824ULL, 0x000fe400078e0203ULL, 0x0000000106062810ULL, 0x000fc60007ffe0ffULL,
0x0000000002087984ULL, 0x0002a20000000c00ULL, 0x0000000610057207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a05ULL, 0x0000590005057a24ULL, 0x000fe200078e0272ULL,
0x00000003ff027819ULL, 0x002fe20000011600ULL, 0x00005a0007047a24ULL, 0x000fe200078e0204ULL,
0x000000070c077812ULL, 0x000fc600078ec0ffULL, 0x00005a0005057a24ULL, 0x000fe400078e0204ULL,
0x0000000866077824ULL, 0x000fe400078e0207ULL, 0x000000017b7b7824ULL, 0x000fe200078e0202ULL,
0x0000000576057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f4406ULL,
0x000000750200720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000007b0f067227ULL, 0x000fc800078e00ffULL, 0x000000ffff047224ULL, 0x002fe400078e0a06ULL,
0x0000000100027824ULL, 0x000fe400078e0202ULL, 0x00005a0004047a24ULL, 0x000fc600078e027bULL,
0x0000000702057812ULL, 0x000fe400078ec0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f26070ULL,
0xfffffff805027812ULL, 0x000fe400078ef800ULL, 0x0000000700057812ULL, 0x000fca00078ec0ffULL,
0x0000000866057824ULL, 0x000fc800078e0205ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe20003f46070ULL,
0x0000001002047824ULL, 0x000fca00078e0203ULL, 0x0000000004087984ULL, 0x000e6e0000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000610037207ULL, 0x000fca0004000000ULL,
0x000000ffff027224ULL, 0x000fe400078e0a03ULL, 0x0000590003727a24ULL, 0x000fe400078e0272ULL,
0x00005a00027b7a24ULL, 0x000fc800078e027bULL, 0x00005a00727b7a24ULL, 0x000fca00078e027bULL,
0x0000007b767b7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x00005e007b027a11ULL, 0x000fc800078040ffULL, 0x00005f007b037a11ULL, 0x000fca00000f4406ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006c00ff067624ULL, 0x000fe400078e00ffULL,
0x00006d00ff077624ULL, 0x000fca00078e00ffULL, 0x0000000606637981ULL, 0x000322000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0b00780cULL, 0x000fe20003f04070ULL,
0x0000001fff087424ULL, 0x000fe200078e00ffULL, 0x00f60000ff067f8cULL, 0x002e62000c80043fULL,
0x0000000205057824ULL, 0x000fe400078e00ffULL, 0x00000040007a7824ULL, 0x000fe200078e00ffULL,
0x0000580008087a10ULL, 0x000fe20007ffe0ffULL, 0x0000590005727a24ULL, 0x000fc600078e0272ULL,
0x00000005ff087819ULL, 0x000fe20000011608ULL, 0x0000680072057a24ULL, 0x000fe400078e027aULL,
0x0000060000000947ULL, 0x000fea0003800000ULL, 0x00000002ff1c7819ULL, 0x000fe40000011602ULL,
0x0000007a6d097217ULL, 0x000fe40007800000ULL, 0x000000081c167810ULL, 0x040fe20007ffe0ffULL,
0x00000001050a7824ULL, 0x000fe200078e021cULL, 0x000000181c207810ULL, 0x040fe20007ffe0ffULL,
0x0000000109097824ULL, 0x000fe200078e0a7aULL, 0x000000101c1e7810ULL, 0x040fe20007ffe0ffULL,
0x00000001050c7824ULL, 0x040fe200078e0216ULL, 0x000000281c1a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105107824ULL, 0x000fe200078e0220ULL, 0x00001000001b7811ULL, 0x000fe200078e68ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000201c187810ULL, 0x000fc40007ffe0ffULL,
0x000000091e00720cULL, 0x080fe20003fa6070ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000300c147812ULL, 0x100fe400078ef804ULL, 0x000000091800720cULL, 0x000fe20003f66070ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x00000030100c7812ULL, 0x000fe400078ef804ULL,
0x0000000202107211ULL, 0x000fe200078fe8ffULL, 0x00000001050e7824ULL, 0x000fe200078e021eULL,
0x0000640014147a10ULL, 0x000fe20007f3e0ffULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x000000300a127812ULL, 0x000fe200078ef804ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000310197812ULL, 0x000fc400078ec0ffULL, 0x000065000d157a10ULL, 0x000fe20000ffe4ffULL,
0x0000000416107824ULL, 0x000fe200078e00ffULL, 0x0000640012127a10ULL, 0x000fe40007f1e0ffULL,
0x000064000c0c7a10ULL, 0x000fe40007f3e0ffULL, 0x000000300e0a7812ULL, 0x000fe200078ef804ULL,
0x00000001050e7824ULL, 0x000fe200078e0218ULL, 0xfffffffc10107812ULL, 0x000fe200078ee219ULL,
0x0000000418187824ULL, 0x000fe200078e00ffULL, 0x000065000b137a10ULL, 0x000fc400007fe4ffULL,
0x00006500110d7a10ULL, 0x000fe20000ffe4ffULL, 0x0000000105117824ULL, 0x000fe200078e021aULL,
0x000064000a0a7a10ULL, 0x000fe20007f1e0ffULL, 0x00000010101f7824ULL, 0x100fe200078e021bULL,
0x0ffffffc19027812ULL, 0x000fe200078ef802ULL, 0x0000008011107825ULL, 0x000fe200078e00ffULL,
0x000065000f0b7a10ULL, 0x000fe400007fe4ffULL, 0x000000091c00720cULL, 0x080fe20003f06070ULL,
0x00000010021d7824ULL, 0x000fe200078e021bULL, 0x000000091600720cULL, 0x000fe20003f26070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000301c027810ULL, 0x000fc40007ffe0ffULL,
0x0000003010167812ULL, 0x100fe400078ef804ULL, 0x000000300e0e7812ULL, 0x000fe200078ef804ULL,
0x0000000105107824ULL, 0x000fe200078e0202ULL, 0x0000640016167a10ULL, 0x000fe40007fde0ffULL,
0x000000381c1c7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121d7faeULL, 0x0005e2000c101c46ULL, 0x0000650011177a10ULL, 0x000fe200037fe4ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000064000e0e7a10ULL, 0x000fe20007f5e0ffULL,
0x00000000141f7faeULL, 0x0007e2000c901c46ULL, 0x000000092000720cULL, 0x000fe20003f86070ULL,
0x000000041c227824ULL, 0x000fe200078e00ffULL, 0x000065000f0f7a10ULL, 0x000fc400017fe4ffULL,
0x000000091a00720cULL, 0x0c0fe20003f46070ULL, 0x000000041a1a7824ULL, 0x000fe200078e00ffULL,
0x0000003010107812ULL, 0x000fe200078ef804ULL, 0x0000000105127824ULL, 0x004fe200078e021cULL,
0x000000090200720cULL, 0x080fe40003f26070ULL, 0x0000640010107a10ULL, 0x000fe20007fde0ffULL,
0x0000000420147824ULL, 0x008fe200078e00ffULL, 0x000000091c00720cULL, 0x000fe20003f06070ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffffc18187812ULL, 0x000fc400078ee219ULL,
0xfffffffc14147812ULL, 0x100fe200078ee219ULL, 0x0000000402207824ULL, 0x000fe200078e00ffULL,
0xfffffffc1e027812ULL, 0x000fe400078ee219ULL, 0x0000003012047812ULL, 0x000fe200078ef804ULL,
0x0000001014157824ULL, 0x000fe200078e021bULL, 0xfffffffc1a1a7812ULL, 0x000fe200078ee219ULL,
0x0000001002097824ULL, 0x000fe200078e021bULL, 0xfffffffc201c7812ULL, 0x100fe400078ee219ULL,
0xfffffffc221e7812ULL, 0x000fe200078ee219ULL, 0x0000001018197824ULL, 0x100fe200078e021bULL,
0x0000650011117a10ULL, 0x000fe200037fe4ffULL, 0x000000101a1d7824ULL, 0x100fe200078e021bULL,
0x0000640004047a10ULL, 0x000fe20007fde0ffULL, 0x000000101c1f7824ULL, 0x100fe200078e021bULL,
0x000000000a097faeULL, 0x0005e2000e901c46ULL, 0x000000101e1b7824ULL, 0x000fe200078e021bULL,
0x0000650013057a10ULL, 0x000fc400037fe4ffULL, 0x000000000c157faeULL, 0x0005e8000e101c46ULL,
0x000000000e197faeULL, 0x0005e8000d901c46ULL, 0x00000000161d7faeULL, 0x0005e8000d101c46ULL,
0x00000000101f7faeULL, 0x0005e8000c901c46ULL, 0x00000000041b7faeULL, 0x0005e2000c101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x00000008021a7811ULL, 0x040fe400078ff0ffULL,
0x0000002802147811ULL, 0x000fc400078ff0ffULL, 0x00000010020e7811ULL, 0x040fe200078ff0ffULL,
0x00000001050c7824ULL, 0x040fe200078e021aULL, 0x0000000202097211ULL, 0x000fe200078fe8ffULL,
0x000000041a207824ULL, 0x000fe200078e00ffULL, 0x0000001802107811ULL, 0x040fe200078ff0ffULL,
0x00000001051a7824ULL, 0x040fe200078e0214ULL, 0x0000002002127811ULL, 0x040fe200078ff0ffULL,
0x00000001050f7824ULL, 0x040fe200078e020eULL, 0x0000003002167811ULL, 0x000fe200078ff0ffULL,
0x0000000414147824ULL, 0x000fe200078e00ffULL, 0x0000003802187811ULL, 0x000fe200078ff0ffULL,
0x000000040e0e7824ULL, 0x000fe200078e00ffULL, 0x00000005020a7211ULL, 0x000fe200078ff0ffULL,
0x0000000105117824ULL, 0x000fe200078e0210ULL, 0x0000000309097812ULL, 0x000fe200078ec0ffULL,
0x0000000410107824ULL, 0x000fe200078e00ffULL, 0x0000100000257811ULL, 0x000fe200078e68ffULL,
0x0000000412227824ULL, 0x000fe200078e00ffULL, 0x0ffffffc09197812ULL, 0x000fe200078ef802ULL,
0x00000001051c7824ULL, 0x040fe200078e0216ULL, 0xfffffffc20027812ULL, 0x100fe200078ee209ULL,
0x0000000416247824ULL, 0x000fe200078e00ffULL, 0xfffffffc14167812ULL, 0x100fe200078ee209ULL,
0x00000001051e7824ULL, 0x040fe200078e0218ULL, 0xfffffffc22157812ULL, 0x100fe200078ee209ULL,
0x0000000105137824ULL, 0x000fe200078e0212ULL, 0xfffffffc0e057812ULL, 0x100fe200078ee209ULL,
0x0000000418187824ULL, 0x000fe200078e00ffULL, 0xfffffffc10127812ULL, 0x100fe200078ee209ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc24177812ULL, 0x000fc400078ee209ULL,
0xfffffffc18187812ULL, 0x000fe200078ee209ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000300a147812ULL, 0x000fc600078ef804ULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0x0000640014147a10ULL, 0x000fc60007f1e0ffULL, 0x0000001016217824ULL, 0x100fe200078e0225ULL,
0x000000300c167812ULL, 0x100fe200078ef804ULL, 0x0000001019277824ULL, 0x000fe200078e0225ULL,
0x000000300e197812ULL, 0x000fe200078ef804ULL, 0x0000008011107825ULL, 0x000fe200078e00ffULL,
0x0000640016167a10ULL, 0x000fc60007f3e0ffULL, 0x0000001002097824ULL, 0x100fe200078e0225ULL,
0x0000003010107812ULL, 0x100fe200078ef804ULL, 0x00000010051b7824ULL, 0x100fe400078e0225ULL,
0x00000010121d7824ULL, 0x100fe400078e0225ULL, 0x00000010151f7824ULL, 0x100fe200078e0225ULL,
0x000065000b157a10ULL, 0x000fe200007fe4ffULL, 0x0000001017237824ULL, 0x100fe200078e0225ULL,
0x000065000d177a10ULL, 0x000fe20000ffe4ffULL, 0x0000001018257824ULL, 0x000fe200078e0225ULL,
0x0000640019187a10ULL, 0x000fe20007f5e0ffULL, 0x00000080130a7825ULL, 0x000fe200078e00ffULL,
0x0000640010107a10ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014277faeULL, 0x0005e2000b901c46ULL, 0x000065000f197a10ULL, 0x000fe200017fe4ffULL,
0x000000801a0c7825ULL, 0x000fe200078e00ffULL, 0x000000300a057812ULL, 0x100fe200078ef804ULL,
0x0000000016097faeULL, 0x0005e2000b901c46ULL, 0x0000650011117a10ULL, 0x000fe200007fe4ffULL,
0x000000801c0e7825ULL, 0x000fe200078e00ffULL, 0x000000300c0a7812ULL, 0x100fe200078ef804ULL,
0x00000000181b7faeULL, 0x0005e4000b901c46ULL, 0x000000801e127825ULL, 0x000fe200078e00ffULL,
0x000000300e0c7812ULL, 0x000fe200078ef804ULL, 0x00000000101d7faeULL, 0x0005e2000b901c46ULL,
0x000064000a0a7a10ULL, 0x000fc40007f3e0ffULL, 0x00000030120e7812ULL, 0x000fe400078ef804ULL,
0x0000640005047a10ULL, 0x000fe40007f1e0ffULL, 0x000064000c0c7a10ULL, 0x000fe40007f5e0ffULL,
0x000064000e0e7a10ULL, 0x000fe40007f7e0ffULL, 0x000065000b057a10ULL, 0x000fe400007fe4ffULL,
0x000065000d0b7a10ULL, 0x000fc40000ffe4ffULL, 0x000065000f0d7a10ULL, 0x000fe200017fe4ffULL,
0x00000000041f7faeULL, 0x0005e2000b901c46ULL, 0x00006500130f7a10ULL, 0x000fc60001ffe4ffULL,
0x000000000a217faeULL, 0x0005e8000b901c46ULL, 0x000000000c237faeULL, 0x0005e8000b901c46ULL,
0x000000000e257faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000047805ULL, 0x004fc40000015200ULL, 0x00f60400ff097984ULL, 0x000ea20000000800ULL,
0x00000008036f7224ULL, 0x000fe400078e02ffULL, 0x000000016d787824ULL, 0x000fc400078e0a71ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x8000000009ff7812ULL, 0x006fe20007804807ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000062006f6e7625ULL, 0x000fe200078e006eULL, 0x00000008ff787819ULL, 0x000fe20000011678ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000027805ULL, 0x000fcc0000015200ULL,
0x0000000204097210ULL, 0x000fca0007f1e1ffULL, 0x0000000103037824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011403ULL, 0x0000000902027211ULL, 0x000fca00078110ffULL,
0x000000ffff037224ULL, 0x000fca00000e0603ULL, 0x0000000202027819ULL, 0x000fc80000001203ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000002000027824ULL, 0x002fca00078e0203ULL, 0x00000003ff037819ULL, 0x000fc80000011602ULL,
0x1ffffffe03057812ULL, 0x000fe400078ec0ffULL, 0x0000000f02037812ULL, 0x000fc600078ec0ffULL,
0x0000000102057824ULL, 0x000fe400078e0205ULL, 0x0000001003077824ULL, 0x040fe400078e00ffULL,
0x0000001003047824ULL, 0x000fe200078e00ffULL, 0x0000000f05027812ULL, 0x040fe400078ec0ffULL,
0x0000000105057810ULL, 0x000fe40007ffe0ffULL, 0x000000f007027812ULL, 0x000fe400078ee202ULL,
0x0000000f05057812ULL, 0x000fc600078ec0ffULL, 0x0000000002107984ULL, 0x000e62000000cc00ULL,
0x000000f004057812ULL, 0x000fca00078ee205ULL, 0x00000000050c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fc400078e000eULL,
0x000000ffff127224ULL, 0x000fe400078e000dULL, 0x000000ffff137224ULL, 0x000fe200078e000fULL,
0x0000001402007388ULL, 0x0003e8000000cc00ULL, 0x0000001005007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff067f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000027805ULL, 0x002fc80000015200ULL,
0x00f60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x006fc40007804807ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402097210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000904047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff7000720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0000000208777824ULL, 0x000fe200078e00ffULL, 0x3db504f363637820ULL, 0x010fe20000410000ULL,
0x0000f68800797811ULL, 0x040fe200078e18ffULL, 0x000000ffff037224ULL, 0x000fe200078e00ffULL,
0xffffffff71737810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x0000000971747810ULL, 0x000fe40007ffe0ffULL, 0x0000f608007c7811ULL, 0x000fc400078e28ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e0004ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x00cfc4000001ff00ULL, 0x000000010500780cULL, 0x000fe20003f25270ULL,
0x00000bc000007945ULL, 0x000fe20003800000ULL, 0x0000000103097810ULL, 0x000fc40007ffe0ffULL,
0x0000000105067810ULL, 0x000fe40007ffe0ffULL, 0x0000000107047812ULL, 0x000fe400078e0cffULL,
0x000000020600780cULL, 0x040fe40003f06070ULL, 0x000000ff060a7207ULL, 0x000fc60000800000ULL,
0x000000ffff091224ULL, 0x000fc800078e0203ULL, 0x0000010009117824ULL, 0x040fe200078e027aULL,
0x00000001090b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe400078e0005ULL,
0x000000ffff057224ULL, 0x000fe200078e0006ULL, 0x000000700b00720cULL, 0x000fe20003f46070ULL,
0x00006800721b7a24ULL, 0x020fd800078e0211ULL, 0x000005d00000a947ULL, 0x000fea0003800000ULL,
0x0000001002067824ULL, 0x002fe200078e00ffULL, 0x00000002ff1a7819ULL, 0x000fe20000011602ULL,
0x0000000200087824ULL, 0x000fc600078e0204ULL, 0x00000030060b7812ULL, 0x000fe200078ec0ffULL,
0x000000011a0d7824ULL, 0x040fe200078e021bULL, 0x000000081a3a7810ULL, 0x040fe40007ffe0ffULL,
0x000000181a3e7810ULL, 0x000fe20007ffe0ffULL, 0x000000400a0a7824ULL, 0x000fe200078e020bULL,
0x000000101a3c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200078e00ffULL,
0x000000116d067217ULL, 0x000fe20007800000ULL, 0x000000013a0f7824ULL, 0x000fe200078e021bULL,
0x000000201a407810ULL, 0x000fe20007ffe0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e000aULL,
0x0000100008087811ULL, 0x000fc600078e60ffULL, 0x000000013e397824ULL, 0x000fe200078e021bULL,
0x000064000c127a10ULL, 0x000fe20007f3e0ffULL, 0x000000800f0e7825ULL, 0x000fc600078e000aULL,
0x000065000d137a10ULL, 0x000fe20000ffe4ffULL, 0x000000013c197824ULL, 0x000fe200078e021bULL,
0x000064000e107a10ULL, 0x000fe20007f5e0ffULL, 0x0000008039387825ULL, 0x000fe200078e000aULL,
0x00000002020e7211ULL, 0x000fc600078fe8ffULL, 0x0000008019187825ULL, 0x000fe200078e000aULL,
0x00006400380c7a10ULL, 0x000fe40007f3e0ffULL, 0x000000030e417812ULL, 0x000fe200078ec0ffULL,
0x0000000106067824ULL, 0x000fe200078e0a11ULL, 0x000065000f117a10ULL, 0x000fe200017fe4ffULL,
0x00000001400f7824ULL, 0x000fe200078e021bULL, 0x0000640018187a10ULL, 0x000fe40007f7e0ffULL,
0x000000063a00720cULL, 0x0c0fe20003f46070ULL, 0x000000043a3a7824ULL, 0x000fe200078e00ffULL,
0x00006500390d7a10ULL, 0x000fe20000ffe4ffULL, 0x000000800f0e7825ULL, 0x000fe200078e000aULL,
0x000000061a00720cULL, 0x000fc40003f26070ULL, 0x0000650019197a10ULL, 0x000fe40001ffe4ffULL,
0x000000063c00720cULL, 0x0c0fe20003f66070ULL, 0x000000043c3c7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc413b7812ULL, 0x000fe400078ef802ULL, 0xfffffffc3a3d7812ULL, 0x100fe400078ee241ULL,
0x000000281a3a7810ULL, 0x000fe20007ffe0ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0208ULL,
0xfffffffc3c3f7812ULL, 0x000fe200078ee241ULL, 0x000000103d3d7824ULL, 0x100fe200078e0208ULL,
0x000000301a3c7810ULL, 0x000fe20007ffe0ffULL, 0x000000013a397824ULL, 0x000fe200078e021bULL,
0x000064000e0e7a10ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000123b7faeULL, 0x0003e2000c901c46ULL, 0x000000103f3f7824ULL, 0x000fe200078e0208ULL,
0x000000381a1a7810ULL, 0x000fe20007ffe0ffULL, 0x0000008039387825ULL, 0x000fe200078e000aULL,
0x000065000f0f7a10ULL, 0x000fe200027fe4ffULL, 0x00000000103d7faeULL, 0x0005e2000d101c46ULL,
0x000000063e00720cULL, 0x0c0fe20003fa6070ULL, 0x000000043e3e7824ULL, 0x000fe200078e00ffULL,
0x000000064000720cULL, 0x080fe20003f86070ULL, 0x00000000183f7faeULL, 0x0007e2000d901c46ULL,
0x000000063a00720cULL, 0x080fe20003f66070ULL, 0x0000000440407824ULL, 0x000fe200078e00ffULL,
0x000000063c00720cULL, 0x0c0fe20003f46070ULL, 0x000000013c137824ULL, 0x102fe200078e021bULL,
0x000000061a00720cULL, 0x040fe20003f26070ULL, 0x000000011a1b7824ULL, 0x000fe200078e021bULL,
0x0000640038107a10ULL, 0x004fe20007fde0ffULL, 0x0000008013127825ULL, 0x000fc600078e000aULL,
0x0000650039117a10ULL, 0x000fe200037fe4ffULL, 0x000000043a3a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc3e197812ULL, 0x108fe200078ee241ULL, 0x000000043c3c7824ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fe20007fde0ffULL, 0x000000041a1a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc3a397812ULL, 0x000fe200078ee241ULL, 0x000000801b0a7825ULL, 0x000fe200078e000aULL,
0xfffffffc401b7812ULL, 0x100fe400078ee241ULL, 0xfffffffc3c3b7812ULL, 0x100fe200078ee241ULL,
0x0000001019197824ULL, 0x100fe200078e0208ULL, 0xfffffffc1a3d7812ULL, 0x000fe200078ee241ULL,
0x000000101b1b7824ULL, 0x100fe200078e0208ULL, 0x0000650013137a10ULL, 0x000fe200037fe4ffULL,
0x0000001039397824ULL, 0x100fe200078e0208ULL, 0x000064000a0a7a10ULL, 0x000fe20007fde0ffULL,
0x000000103b3b7824ULL, 0x100fe200078e0208ULL, 0x000000000c197faeULL, 0x0003e2000e901c46ULL,
0x000000103d3d7824ULL, 0x000fe200078e0208ULL, 0x000065000b0b7a10ULL, 0x000fc400037fe4ffULL,
0x000000000e1b7faeULL, 0x0003e8000e101c46ULL, 0x0000000010397faeULL, 0x0003e8000d901c46ULL,
0x00000000123b7faeULL, 0x0003e8000d101c46ULL, 0x000000000a3d7faeULL, 0x0003e2000c901c46ULL,
0x0000051000007947ULL, 0x000fea0003800000ULL, 0x0000001002067824ULL, 0x042fe200078e00ffULL,
0x00000008020c7811ULL, 0x000fe200078ff0ffULL, 0x0000000200087824ULL, 0x000fe200078e0204ULL,
0x00000010020e7811ULL, 0x000fc400078ff0ffULL, 0x00000030060b7812ULL, 0x000fe200078ec0ffULL,
0x000000010c0f7824ULL, 0x100fe200078e021bULL, 0x0000001802107811ULL, 0x000fe200078ff0ffULL,
0x000000010e117824ULL, 0x000fe200078e021bULL, 0x0000002002127811ULL, 0x000fe200078ff0ffULL,
0x000000400a0a7824ULL, 0x000fe200078e020bULL, 0x0000002802187811ULL, 0x000fe200078ff0ffULL,
0x0000000110137824ULL, 0x100fe200078e021bULL, 0x0000000202067211ULL, 0x000fe200078fe8ffULL,
0x0000000112197824ULL, 0x100fe200078e021bULL, 0x00000030021a7811ULL, 0x000fe200078ff0ffULL,
0x0000000118397824ULL, 0x000fe200078e021bULL, 0x0000003802387811ULL, 0x000fe200078ff0ffULL,
0x000000040c0c7824ULL, 0x000fe200078e00ffULL, 0x00000003060b7812ULL, 0x000fe200078ec0ffULL,
0x000000040e0e7824ULL, 0x000fe200078e00ffULL, 0x0000100008087811ULL, 0x000fe200078e60ffULL,
0x0000000410107824ULL, 0x000fe200078e00ffULL, 0xfffffffc0c3b7812ULL, 0x100fe200078ee20bULL,
0x0000000412127824ULL, 0x000fe200078e00ffULL, 0xfffffffc0e3d7812ULL, 0x100fe200078ee20bULL,
0x0000000418187824ULL, 0x000fe200078e00ffULL, 0xfffffffc103f7812ULL, 0x100fe200078ee20bULL,
0x000000041a067824ULL, 0x000fe200078e00ffULL, 0xfffffffc12417812ULL, 0x100fe200078ee20bULL,
0x00000004383a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc18437812ULL, 0x000fe200078ee20bULL,
0x000000011a457824ULL, 0x000fe200078e021bULL, 0xfffffffc06477812ULL, 0x000fe200078ee20bULL,
0x0000000138497824ULL, 0x000fe200078e021bULL, 0xfffffffc3a4b7812ULL, 0x000fe200078ee20bULL,
0x000000103b3b7824ULL, 0x000fe200078e0208ULL, 0x0ffffffc0b0b7812ULL, 0x000fe200078ef802ULL,
0x000000103d3d7824ULL, 0x100fe200078e0208ULL, 0x0000001b020d7211ULL, 0x000fe200078ff0ffULL,
0x000000103f3f7824ULL, 0x000fc400078e0208ULL, 0x000000100b4d7824ULL, 0x100fe400078e0208ULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x0000001041417824ULL, 0x000fe400078e0208ULL,
0x000000800d0c7825ULL, 0x000fc800078e000aULL, 0x000000800f0e7825ULL, 0x000fe200078e000aULL,
0x000064000c0c7a10ULL, 0x000fc60007f3e0ffULL, 0x0000008011107825ULL, 0x100fe200078e000aULL,
0x000064000e0e7a10ULL, 0x000fe40007f5e0ffULL, 0x000065000d0d7a10ULL, 0x000fe20000ffe4ffULL,
0x0000008013127825ULL, 0x100fe200078e000aULL, 0x0000640010107a10ULL, 0x000fe40007f7e0ffULL,
0x000065000f0f7a10ULL, 0x000fe200017fe4ffULL, 0x0000008019187825ULL, 0x100fe200078e000aULL,
0x0000640012127a10ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c4d7faeULL, 0x0003e2000b901c46ULL, 0x0000650011117a10ULL, 0x000fe20001ffe4ffULL,
0x00000080391a7825ULL, 0x100fe200078e000aULL, 0x0000640018187a10ULL, 0x000fe20007f3e0ffULL,
0x000000000e3b7faeULL, 0x0003e2000b901c46ULL, 0x0000650013137a10ULL, 0x000fe200027fe4ffULL,
0x0000008045387825ULL, 0x100fe200078e000aULL, 0x000064001a1a7a10ULL, 0x000fe20007f5e0ffULL,
0x00000000103d7faeULL, 0x0003e2000b901c46ULL, 0x0000650019197a10ULL, 0x000fe20000ffe4ffULL,
0x00000080490a7825ULL, 0x000fe200078e000aULL, 0x0000640038387a10ULL, 0x000fe20007f7e0ffULL,
0x00000000123f7faeULL, 0x0003e2000b901c46ULL, 0x000065001b1b7a10ULL, 0x000fe200017fe4ffULL,
0x0000001043437824ULL, 0x100fe200078e0208ULL, 0x000064000a0a7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001047477824ULL, 0x100fe200078e0208ULL, 0x0000650039397a10ULL, 0x000fe20001ffe4ffULL,
0x000000104b4b7824ULL, 0x000fe200078e0208ULL, 0x000065000b0b7a10ULL, 0x000fe200027fe4ffULL,
0x0000000018417faeULL, 0x0003e8000b901c46ULL, 0x000000001a437faeULL, 0x0003e8000b901c46ULL,
0x0000000038477faeULL, 0x0003e8000b901c46ULL, 0x000000000a4b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000200067824ULL, 0x000fe200078e0207ULL, 0x0000002002077810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0xfffffff8020b7812ULL, 0x002fc400078ec0ffULL,
0xfffffff807077812ULL, 0x000fe400078ec0ffULL, 0x00000007020d7812ULL, 0x000fe400078ec0ffULL,
0x000000070b0b7812ULL, 0x100fe400078ef802ULL, 0x00000007070c7812ULL, 0x100fe400078ef802ULL,
0x0000100006067811ULL, 0x000fe400078e60ffULL, 0x000000080d077812ULL, 0x000fc400078ef802ULL,
0x00000001ff5f7819ULL, 0x000fe4000001160bULL, 0x00000001ff0a7819ULL, 0x000fe2000001160cULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000015f0d7824ULL, 0x000fe200078e0208ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000040b0e7824ULL, 0x060fe200078e00ffULL,
0x00000001080f7810ULL, 0x000fe20007ffe0ffULL, 0x000000040b3d7824ULL, 0x000fe400078e00ffULL,
0x00000010073b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc0e0d7812ULL, 0x000fe200078ee20dULL,
0x000000040c0e7824ULL, 0x000fc400078e00ffULL, 0x000000015f387824ULL, 0x100fe400078e020fULL,
0x000000100d187824ULL, 0x000fe400078e0206ULL, 0x000000010a0d7824ULL, 0x040fe400078e0208ULL,
0x000000010a397824ULL, 0x000fe200078e020fULL, 0xfffffffc3d0f7812ULL, 0x000fe200078ee238ULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0xfffffffc0e0d7812ULL, 0x000fe200078ee20dULL,
0x000000040c3a7824ULL, 0x000fc400078e00ffULL, 0x000000100f0f7824ULL, 0x100fe400078e0206ULL,
0x000000100d107824ULL, 0x000fe200078e0206ULL, 0xfffffffc3a437812ULL, 0x000fe200078ee239ULL,
0x00000004090d7824ULL, 0x000fe200078e0208ULL, 0x0000000208087810ULL, 0x000fc60007ffe0ffULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x000000020d0d7824ULL, 0x000fe200078e00ffULL,
0x000000040800780cULL, 0x000fc80003f25270ULL, 0x0000000d020e7211ULL, 0x000fe400078fe0ffULL,
0x000000020d0d7810ULL, 0x000fc60007ffe0ffULL, 0x00000001070e7824ULL, 0x000fca00078e020eULL,
0xfffffff03b0e7812ULL, 0x000fe400078ee20eULL, 0x000000000f38783bULL, 0x000ee60000000200ULL,
0x000000100e0e7824ULL, 0x000fe200078e00ffULL, 0x00000010ff3d7819ULL, 0x102fe40000011618ULL,
0x00000018ff4a7819ULL, 0x000fe40000011618ULL, 0x000000ff18497812ULL, 0x000fc400078ec0ffULL,
0x0000ffff18477812ULL, 0x000fe400078ec0ffULL, 0x0000000d02187211ULL, 0x000fe400078fe0ffULL,
0x00000010ff3c7819ULL, 0x000fe40000011619ULL, 0x00000010ff677819ULL, 0x004fe20000011610ULL,
0x0000000107187824ULL, 0x000fe200078e0218ULL, 0x00000018ff627819ULL, 0x000fe40000011610ULL,
0x000000ff10527812ULL, 0x000fc400078ec0ffULL, 0x0000ffff10647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff657819ULL, 0x100fe40000011611ULL, 0x00000018ff617819ULL, 0x000fe40000011611ULL,
0x000000ff11607812ULL, 0x040fe400078ec0ffULL, 0x0000ffff11537812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5b7819ULL, 0x000fc40000011612ULL, 0x00000018ff557819ULL, 0x000fe40000011612ULL,
0x000000ff12567812ULL, 0x040fe400078ec0ffULL, 0x0000ffff12597812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5a7819ULL, 0x100fe40000011613ULL, 0x00000018ff4b7819ULL, 0x000fe40000011613ULL,
0x000000ff13577812ULL, 0x000fc400078ec0ffULL, 0x0000ffff135d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff417819ULL, 0x000fe20000011619ULL, 0x000000000e10783bULL, 0x0002a20000000200ULL,
0x000000ff19407812ULL, 0x040fe400078ec0ffULL, 0x0000ffff19427812ULL, 0x000fe200078ec0ffULL,
0x0000001007197824ULL, 0x000fe200078e00ffULL, 0x00000010ff3e7819ULL, 0x100fe4000001161aULL,
0x00000018ff6c7819ULL, 0x000fc4000001161aULL, 0xfffffff019667812ULL, 0x000fe200078ee218ULL,
0x0000001043187824ULL, 0x000fe200078e0206ULL, 0x000000ff1a6b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff1a3f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff487819ULL, 0x100fe4000001161bULL,
0x00000018ff6a7819ULL, 0x000fe4000001161bULL, 0x000000ff1b697812ULL, 0x000fc400078ec0ffULL,
0x0000ffff1b687812ULL, 0x000fe400078ec0ffULL, 0x000000001818783bULL, 0x000f220000000200ULL,
0x000000ff3d3d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff477819ULL, 0x000fe40000011647ULL,
0x00000010ff0d7819ULL, 0x108fe40000011639ULL, 0x00000018ff4e7819ULL, 0x000fe40000011639ULL,
0x000000ff394f7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff390f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff0e7819ULL, 0x102fe4000001163aULL, 0x00000018ff517819ULL, 0x000fe4000001163aULL,
0x000000ff3a547812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3a397812ULL, 0x000fe400078ec0ffULL,
0x000000ff3c3a7812ULL, 0x000fc400078ec0ffULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x00000047ff3c723eULL, 0x000fe400020006ffULL, 0x000054103d3d7816ULL, 0x000fe4000000004aULL,
0x00005410493c7816ULL, 0x000fc4000000003cULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000040ff40723eULL, 0x000fe200020006ffULL,
0x0000003c1034723cULL, 0x004b620000001834ULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x000000ff3e767812ULL, 0x000fe400078ec0ffULL, 0x00000008ff757819ULL, 0x000fc4000001163fULL,
0x00000042ff3c723eULL, 0x020fe400020006ffULL, 0x000054103a3d7816ULL, 0x000fe40000000041ULL,
0x00005410403c7816ULL, 0x000fe4000000003cULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x0000003c1030723cULL, 0x000b620000001830ULL, 0x00000075ff75723eULL, 0x000fc400020006ffULL,
0x00000010ff3a7819ULL, 0x110fe40000011618ULL, 0x00000018ff5e7819ULL, 0x000fe40000011618ULL,
0x000000ff18587812ULL, 0x040fe400078ec0ffULL, 0x0000ffff183d7812ULL, 0x020fe400078ec0ffULL,
0x00000010ff3c7819ULL, 0x100fe40000011619ULL, 0x00000018ff507819ULL, 0x000fc40000011619ULL,
0x000000ff193e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff193f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff407819ULL, 0x100fe4000001161aULL, 0x00000018ff417819ULL, 0x000fe4000001161aULL,
0x000000ff1a427812ULL, 0x040fe400078ec0ffULL, 0x0000ffff1a477812ULL, 0x000fc400078ec0ffULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x0000541076197816ULL, 0x000fe4000000006cULL,
0x000054106b187816ULL, 0x000fe40000000075ULL, 0x00000008ff647819ULL, 0x000fe40000011664ULL,
0x000000ff481a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff487819ULL, 0x100fe2000001161bULL,
0x00000018102c723cULL, 0x000b62000000182cULL, 0x00000018ff497819ULL, 0x000fc4000001161bULL,
0x000000ff1b4a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff1b4d7812ULL, 0x000fe200078ec0ffULL,
0x00000010661b7824ULL, 0x000fe200078e00ffULL, 0x00000008ff537819ULL, 0x000fe40000011653ULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x00000008ff687819ULL, 0x000fc40000011668ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000064ff66723eULL, 0x000fe400020006ffULL, 0x00000053ff64723eULL, 0x000fe400020006ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x0000001aff1a723eULL, 0x000fc400020006ffULL, 0x00000068ff18723eULL, 0x020fe400020006ffULL,
0x0000541067537816ULL, 0x000fe40000000062ULL, 0x0000541052527816ULL, 0x000fe40000000066ULL,
0x000054101a197816ULL, 0x000fe4000000006aULL, 0x0000541069187816ULL, 0x000fe40000000018ULL,
0x000000ff65657812ULL, 0x000fe200078ec0ffULL, 0x000000521024723cULL, 0x000be20000001824ULL,
0x00000008ff597819ULL, 0x000fc40000011659ULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000008ff527819ULL, 0x020fe2000001165dULL,
0x000000181028723cULL, 0x000b620000001828ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x000000001b18783bULL, 0x020e620000000200ULL, 0x00000059ff5d723eULL, 0x000fe400020006ffULL,
0x00000052ff59723eULL, 0x000fc400020006ffULL, 0x0000541065537816ULL, 0x000fe40000000061ULL,
0x0000541060527816ULL, 0x000fe40000000064ULL, 0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff384c7812ULL, 0x000fe400078ec0ffULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x000000521020723cULL, 0x000b620000001820ULL, 0x00000056ff56723eULL, 0x000fc400020006ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL,
0x0000004cff53723eULL, 0x020fe400020006ffULL, 0x00000054ff4c723eULL, 0x000fe400020006ffULL,
0x000054105b557816ULL, 0x000fe40000000055ULL, 0x0000541056547816ULL, 0x000fc4000000005dULL,
0x00000010ff437819ULL, 0x000fe40000011638ULL, 0x0000ffff38447812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b457812ULL, 0x000fe200078ec0ffULL, 0x00000054101c723cULL, 0x000b62000000181cULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fc400020006ffULL, 0x000000ff43547812ULL, 0x020fe400078ec0ffULL,
0x00000045ff52723eULL, 0x000fe400020006ffULL, 0x00000008ff437819ULL, 0x000fe40000011644ULL,
0x000054105a457816ULL, 0x000fe4000000004bULL, 0x0000541057447816ULL, 0x000fe40000000059ULL,
0x00000018ff5c7819ULL, 0x000fc40000011638ULL, 0x000000ff0d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x000000441014723cULL, 0x000b620000001814ULL,
0x00000008ff0f7819ULL, 0x000fe4000001160fULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x00000054ff11723eULL, 0x020fc400020006ffULL,
0x00000043ff10723eULL, 0x000fe400020006ffULL, 0x0000541011117816ULL, 0x000fe4000000005cULL,
0x0000541053107816ULL, 0x000fe40000000010ULL, 0x00000010ff387819ULL, 0x100fe4000001163bULL,
0x00000018ff467819ULL, 0x000fe4000001163bULL, 0x000000ff0e127812ULL, 0x000fe200078ec0ffULL,
0x000000101834723cULL, 0x002b620000001834ULL, 0x0000ffff3b3b7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff397819ULL, 0x000fe40000011639ULL, 0x000000ff38387812ULL, 0x000fe400078ec0ffULL,
0x0000000dff11723eULL, 0x020fe400020006ffULL, 0x0000000fff10723eULL, 0x000fe400020006ffULL,
0x00005410110f7816ULL, 0x000fe4000000004eULL, 0x000054104f0e7816ULL, 0x000fc40000000010ULL,
0x00000008ff3b7819ULL, 0x000fe4000001163bULL, 0x000000ff3a3a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3d7819ULL, 0x000fe2000001163dULL, 0x0000000e1830723cULL, 0x000b620000001830ULL,
0x000000ff3c3c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3f7819ULL, 0x000fe4000001163fULL,
0x000000ff40407812ULL, 0x000fc400078ec0ffULL, 0x00000008ff477819ULL, 0x000fe40000011647ULL,
0x000000ff48487812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4d7819ULL, 0x000fe4000001164dULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fc400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000050ff0d723eULL, 0x000fe400020006ffULL, 0x00000012ff12723eULL, 0x000fe400020006ffULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x00000038ff53723eULL, 0x000fc400020006ffULL, 0x0000003bff3b723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x0000003aff59723eULL, 0x000fe400020006ffULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x0000003cff0f723eULL, 0x020fc400020006ffULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x00000040ff43723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x00000048ff4b723eULL, 0x000fc400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x0000541012517816ULL, 0x000fe40000000051ULL, 0x000054104c507816ULL, 0x000fe40000000039ULL,
0x0000541053537816ULL, 0x000fe40000000046ULL, 0x0000541052527816ULL, 0x000fe4000000003bULL,
0x0000541059597816ULL, 0x000fe2000000005eULL, 0x00000050182c723cULL, 0x000b62000000182cULL,
0x0000541058587816ULL, 0x000fc4000000003dULL, 0x000054100f0f7816ULL, 0x000fe4000000000dULL,
0x000054103e0e7816ULL, 0x000fe4000000003fULL, 0x0000541043437816ULL, 0x000fe20000000041ULL,
0x000000521828723cULL, 0x000b620000001828ULL, 0x0000541042427816ULL, 0x000fe40000000047ULL,
0x000054104b4b7816ULL, 0x000fe40000000049ULL, 0x000054104a4a7816ULL, 0x000fc6000000004dULL,
0x000000581824723cULL, 0x040b700000001824ULL, 0x0000000e1820723cULL, 0x040b700000001820ULL,
0x00000042181c723cULL, 0x040b70000000181cULL, 0x0000004a1814723cULL, 0x000b620000001814ULL,
0xfffff08000001947ULL, 0x000fce000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff077224ULL, 0x000fe200078e0004ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe38000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000006330307220ULL, 0x080fe20000410000ULL, 0x000000632c2c7220ULL, 0x0a0fe20000410000ULL,
0x000000632d2d7220ULL, 0x080fe20000410000ULL, 0x0000006328287220ULL, 0x080fe20000410000ULL,
0x0000006334347220ULL, 0x080fe20000410000ULL, 0x0000006335357220ULL, 0x080fe20000410000ULL,
0x0000006331317220ULL, 0x080fe20000410000ULL, 0x0000006324057220ULL, 0x080fe20000410000ULL,
0x0000006325067220ULL, 0x080fe20000410000ULL, 0x0000006321217220ULL, 0x080fe20000410000ULL,
0x000000631c1c7220ULL, 0x080fe20000410000ULL, 0x0000006332087220ULL, 0x080fe20000410000ULL,
0x000000632b0c7220ULL, 0x080fe20000410000ULL, 0x00000063260d7220ULL, 0x080fe20000410000ULL,
0x00000063270e7220ULL, 0x080fe20000410000ULL, 0x000000632e097220ULL, 0x080fe20000410000ULL,
0x0000006329327220ULL, 0x080fe20000410000ULL, 0x000000632a0b7220ULL, 0x080fe20000410000ULL,
0x00000063220f7220ULL, 0x080fe20000410000ULL, 0x0000006323107220ULL, 0x080fe20000410000ULL,
0x00000063171a7220ULL, 0x080fe20000410000ULL, 0x000000ffff257224ULL, 0x000fe200078e0030ULL,
0x0000006336367220ULL, 0x080fe20000410000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e002cULL,
0x00000063371b7220ULL, 0x080fe20000410000ULL, 0x000000ffff267224ULL, 0x000fe200078e002dULL,
0x0000006333337220ULL, 0x080fe20000410000ULL, 0x000000ffff277224ULL, 0x000fe200078e0028ULL,
0x000000632f0a7220ULL, 0x080fe20000410000ULL, 0x0000006320297220ULL, 0x080fe20000410000ULL,
0x000000631d2a7220ULL, 0x080fe20000410000ULL, 0x000000631e137220ULL, 0x080fe20000410000ULL,
0x000000631f187220ULL, 0x080fe20000410000ULL, 0x0000006314227220ULL, 0x080fe20000410000ULL,
0x0000006315237220ULL, 0x080fe20000410000ULL, 0x0000006316197220ULL, 0x000fe20000410000ULL,
0x000000ffff177224ULL, 0x000fc400078e0034ULL, 0x000000ffff247224ULL, 0x000fe400078e0035ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0031ULL, 0x000000ffff307224ULL, 0x000fe400078e0005ULL,
0x000000ffff287224ULL, 0x000fe400078e0006ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0021ULL,
0x000000ffff2c7224ULL, 0x000fe200078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000079067f8cULL, 0x0002a2000c80043fULL, 0x000000ffff1c7224ULL, 0x000fc400078e0036ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0008ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0033ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1e7224ULL, 0x000fe400078e000aULL,
0x000000ffff207224ULL, 0x000fe400078e000bULL, 0x000000ffff317224ULL, 0x000fc400078e000cULL,
0x000000ffff217224ULL, 0x000fe400078e000dULL, 0x000000ffff167224ULL, 0x000fe400078e000eULL,
0x000000ffff147224ULL, 0x000fe400078e000fULL, 0x000000ffff157224ULL, 0x000fc400078e0010ULL,
0x0000000000087805ULL, 0x002fca0000015200ULL, 0x0000040079057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x006fe40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140bULL, 0x0000000a05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000205057819ULL, 0x000fc8000000120aULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040079057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000402127824ULL, 0x000fe200078e00ffULL,
0x000000780300720cULL, 0x000fc80003f06070ULL, 0xfffffff012057812ULL, 0x000fca00078ec0ffULL,
0x0000008000057824ULL, 0x000fca00078e0205ULL, 0x00f4000005087984ULL, 0x0002a20000000c00ULL,
0x000014f000008947ULL, 0x000fea0003800000ULL, 0x00005a00000d7b06ULL, 0x000ee20000209000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fe20003f85070ULL,
0x0000010003347824ULL, 0x000fe200078e027aULL, 0x00005a00ff367a12ULL, 0x000fe200078e33ffULL,
0x0000000202357824ULL, 0x000fca00078e00ffULL, 0x0000000635357812ULL, 0x000fca00078ec0ffULL,
0x0000000135337824ULL, 0x000fe200078e0271ULL, 0x0000000d000d7308ULL, 0x008ee40000001000ULL,
0x0ffffffe0d0e7810ULL, 0x008fcc0007ffe0ffULL, 0x0000000e00077305ULL, 0x000ee4000021f000ULL,
0x000000ffff0f7224ULL, 0x008fc800078e0a07ULL, 0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL,
0x0000000f070f7227ULL, 0x000fe200078e0006ULL, 0x0000007b02067211ULL, 0x000fca00078ff0ffULL,
0x000000060f0c7227ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a0cULL,
0x00005a0007077a24ULL, 0x000fe200078e0206ULL, 0x0000000806067810ULL, 0x000fc80007ffe0ffULL,
0x00005a0007007a0cULL, 0x000fe20003f06070ULL, 0x000000060f0d7227ULL, 0x000fc800078e00ffULL,
0x000000ffff0f7224ULL, 0x000fc800078e0a0dULL, 0x00005a000f0e7a24ULL, 0x000fc800078e0206ULL,
0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL, 0x00005a000e007a0cULL, 0x000fe40003f46070ULL,
0x00005a0007007a0cULL, 0x000fe40003f26070ULL, 0x000000346d077217ULL, 0x000fe40007800000ULL,
0x000000010c0c0810ULL, 0x000fc60007ffe0ffULL, 0x0000000107347824ULL, 0x000fe400078e0a34ULL,
0x0000000174077824ULL, 0x000fe400078e0235ULL, 0x80005a000e0e2a10ULL, 0x000fe40007ffe0ffULL,
0x000000010c0c1810ULL, 0x000fe20007ffe0ffULL, 0x0000000107067824ULL, 0x040fe200078e0a34ULL,
0x000000340700720cULL, 0x000fe40003f66070ULL, 0x0000000c360c7207ULL, 0x000fc40006000000ULL,
0x0000000673077217ULL, 0x000fe20003800000ULL, 0x0000000133067824ULL, 0x000fe200078e0a34ULL,
0x0000000c730c7217ULL, 0x000fe40003800000ULL, 0x00005a000e007a0cULL, 0x000fe40003f06070ULL,
0x00000004ff077819ULL, 0x000fe20000011607ULL, 0x0000000c774f7224ULL, 0x000fe200078e02ffULL,
0x000000010d0d2810ULL, 0x000fe40007ffe0ffULL, 0x000000ff070c7207ULL, 0x000fc40001800000ULL,
0x000000343300720cULL, 0x000fe40003f26070ULL, 0x0000000673067217ULL, 0x000fe20003800000ULL,
0x000000014f0f7824ULL, 0x000fe400078e020cULL, 0x000000010d0d0810ULL, 0x000fe40007ffe0ffULL,
0x000000ff06467207ULL, 0x000fe20000800000ULL, 0x000000020f0e7825ULL, 0x000fe200078e006eULL,
0x0000001035397812ULL, 0x000fe400078efcffULL, 0x0000000d36067207ULL, 0x000fc40006000000ULL,
0x0000004f46117211ULL, 0x000fe200078fe0ffULL, 0x000000060e487981ULL, 0x000722000c1e9500ULL,
0x0000000673067217ULL, 0x000fc60003800000ULL, 0x0000000211107825ULL, 0x000fc800078e006eULL,
0x00000001740f7824ULL, 0x008fe200078e0239ULL, 0x00000006104d7981ULL, 0x000722000c1e9500ULL,
0x0000000677517224ULL, 0x000fe400078e02ffULL, 0x000000010f0e7824ULL, 0x000fe200078e0a34ULL,
0x00000020353b7812ULL, 0x000fe400078efcffULL, 0x0000005146077211ULL, 0x000fe400078fe0ffULL,
0x0000000e73107217ULL, 0x008fe40003800000ULL, 0x000000340f00720cULL, 0x000fc40003f26070ULL,
0x00000004ff107819ULL, 0x000fe20000011610ULL, 0x0000000207067825ULL, 0x000fc600078e006eULL,
0x000000ff10107207ULL, 0x000fe20000800000ULL, 0x0000000174417824ULL, 0x000fe200078e023bULL,
0x00000006064b7981ULL, 0x0046a2000c1e9500ULL, 0x0000000139377824ULL, 0x000fe400078e0271ULL,
0x00000001413c7824ULL, 0x100fe400078e0a34ULL, 0x00000001370e7824ULL, 0x000fe400078e0a34ULL,
0x000000010c0d7824ULL, 0x000fe400078e0251ULL, 0x000000014f077824ULL, 0x008fe200078e0210ULL,
0x0000003c733c7217ULL, 0x000fe20003800000ULL, 0x000000020d0c7825ULL, 0x000fe200078e006eULL,
0x000000343700720cULL, 0x000fc60003f06070ULL, 0x0000000207067825ULL, 0x000fe200078e006eULL,
0x0000000e730e7217ULL, 0x000fe20003800000ULL, 0x000000060c427981ULL, 0x0006a2000c1e9500ULL,
0x000000344100720cULL, 0x080fe20003f26070ULL, 0x000000013b3f7824ULL, 0x000fe200078e0271ULL,
0x00000004ff3c7819ULL, 0x000fe2000001163cULL, 0x0000000606387981ULL, 0x0002a2000c1e9500ULL,
0x000000ff0e367207ULL, 0x000fe40000000000ULL, 0x000000ff3c407207ULL, 0x000fe40000800000ULL,
0x0000003035417812ULL, 0x000fe200078efcffULL, 0x000000013f067824ULL, 0x002fe200078e0a34ULL,
0x0000004f360d7211ULL, 0x008fe200078fe0ffULL, 0x00000001100f7824ULL, 0x000fe200078e0251ULL,
0x0000005136117211ULL, 0x000fe200078fe0ffULL, 0x000000014f077824ULL, 0x000fe200078e0240ULL,
0x000000343f00720cULL, 0x000fc40003f06070ULL, 0x0000000673067217ULL, 0x000fe20003800000ULL,
0x0000000174537824ULL, 0x000fe400078e0241ULL, 0x000000020d0c7825ULL, 0x000fe200078e006eULL,
0x000000ff063c7207ULL, 0x000fc60000000000ULL, 0x000000020f0e7825ULL, 0x100fe200078e006eULL,
0x000000060c3d7981ULL, 0x0002e6000c1e9500ULL, 0x0000000211107825ULL, 0x100fe200078e006eULL,
0x000000060e3a7981ULL, 0x0002e6000c1e9500ULL, 0x0000000207067825ULL, 0x000fe200078e006eULL,
0x0000000610437981ULL, 0x0002e6000c1e9500ULL, 0x0000000153447824ULL, 0x000fe200078e0a34ULL,
0x00000006063e7981ULL, 0x0002e2000c1e9500ULL, 0x0000000141477824ULL, 0x000fe200078e0271ULL,
0x0000004f3c0d7211ULL, 0x002fc400078fe0ffULL, 0x0000004473447217ULL, 0x000fe20003800000ULL,
0x00000001400f7824ULL, 0x000fe200078e0251ULL, 0x000000513c117211ULL, 0x000fe200078fe0ffULL,
0x0000000147067824ULL, 0x000fe200078e0a34ULL, 0x000000345300720cULL, 0x080fe40003f26070ULL,
0x00000004ff447819ULL, 0x000fe20000011644ULL, 0x000000020d0c7825ULL, 0x100fe200078e006eULL,
0x000000344700720cULL, 0x000fe40003f06070ULL, 0x0000000673067217ULL, 0x000fe20003800000ULL,
0x000000020f0e7825ULL, 0x100fe200078e006eULL, 0x000000ff444a7207ULL, 0x000fe20000800000ULL,
0x000000060c457981ULL, 0x0002e4000c1e9500ULL, 0x0000000211107825ULL, 0x000fe200078e006eULL,
0x000000ff06447207ULL, 0x000fe20000000000ULL, 0x000000060e407981ULL, 0x0002e8000c1e9500ULL,
0x0000000610497981ULL, 0x0002e2000c1e9500ULL, 0x000000014f077824ULL, 0x000fe200078e024aULL,
0x0000004f440d7211ULL, 0x002fc600078fe0ffULL, 0x0000000207067825ULL, 0x000fc800078e006eULL,
0x000000020d0c7825ULL, 0x000fe400078e006eULL, 0x0000000606067981ULL, 0x0002e2000c1e9500ULL,
0x00000051440f7211ULL, 0x000fc600078fe0ffULL, 0x000000060c0d7981ULL, 0x0002e2000c1e9500ULL,
0x000000014a117824ULL, 0x000fe400078e0251ULL, 0x000000020f0e7825ULL, 0x000fc800078e006eULL,
0x0000000211107825ULL, 0x000fe400078e006eULL, 0x000000060e0e7981ULL, 0x0002e8000c1e9500ULL,
0x0000000610117981ULL, 0x0002e2000c1e9500ULL, 0xfffffff0464f7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff467424ULL, 0x000fc800078e00ffULL, 0x00000001344a7824ULL, 0x000fe200078e024fULL,
0x0000000135077812ULL, 0x002fc600078efcffULL, 0x0000000133557824ULL, 0x000fe200078e0a4aULL,
0x0000000935517812ULL, 0x000fe200078efcffULL, 0x0000000107537824ULL, 0x000fc600078e0271ULL,
0x0000005546557219ULL, 0x040fe200000006ffULL, 0x00000001510f7824ULL, 0x000fe400078e0271ULL,
0x0000000153577824ULL, 0x100fe400078e0a4aULL, 0x000000010f5b7824ULL, 0x000fe200078e0a4aULL,
0x0000001835757812ULL, 0x000fe400078efcffULL, 0x0000005746577219ULL, 0x040fe400000006ffULL,
0x0000005b465b7219ULL, 0x000fc400000006ffULL, 0xfffffff036367812ULL, 0x000fe400078ec0ffULL,
0xfffffff044447812ULL, 0x000fe200078ec0ffULL, 0x0000000175107824ULL, 0x000fc800078e0271ULL,
0x0000000134507824ULL, 0x000fe200078e0244ULL, 0x00000019356b7812ULL, 0x040fe400078efcffULL,
0x00000011357d7812ULL, 0x040fe400078efcffULL, 0x00000021355f7812ULL, 0x040fe400078efcffULL,
0x00000028355d7812ULL, 0x000fe200078efcffULL, 0x000000016b0c7824ULL, 0x100fe400078e0271ULL,
0x000000015f677824ULL, 0x000fc400078e0271ULL, 0x000000015d657824ULL, 0x000fe400078e0271ULL,
0x00000001475a7824ULL, 0x000fca00078e0a50ULL, 0x0000005a465a7219ULL, 0x000fe400000006ffULL,
0x000054104d487816ULL, 0x010fe40000000048ULL, 0x00000008354d7812ULL, 0x000fe400078efcffULL,
0x0000004855ff7212ULL, 0x000fc6000780c0ffULL, 0x000000014d4f7824ULL, 0x000fe200078e0271ULL,
0x000000343300720cULL, 0x000fc60000701470ULL, 0x000000014f597824ULL, 0x000fe200078e0a4aULL,
0x000000343500720cULL, 0x000fc800007a1070ULL, 0x0000005946597219ULL, 0x000fe400000006ffULL,
0x0000004857ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004859ff7212ULL, 0x080fe4000786c0ffULL,
0x000000485bff7212ULL, 0x000fe4000788c0ffULL, 0xff80000017177808ULL, 0x000fe40002800000ULL,
0xfffffff03c487812ULL, 0x000fe200078ec0ffULL, 0x00000001343c7824ULL, 0x000fe200078e0236ULL,
0x000054104b427816ULL, 0x004fc80000000042ULL, 0x0000004255ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004259ff7212ULL, 0x080fe400078cc0ffULL, 0x000000425bff7212ULL, 0x000fe200078ac0ffULL,
0x0000000137447824ULL, 0x100fe200078e0a3cULL, 0x000000343300720cULL, 0x080fe20001741470ULL,
0x00000001104c7824ULL, 0x000fe200078e0a3cULL, 0x000000344f00720cULL, 0x080fe400037c1470ULL,
0x000000340f00720cULL, 0x000fc40002fa1470ULL, 0x000000343500720cULL, 0x080fe40001741070ULL,
0x000000344d00720cULL, 0x080fe400037c1070ULL, 0x000000345100720cULL, 0x000fe40002fa1070ULL,
0x0000004446447219ULL, 0x040fe400000006ffULL, 0x0000004c464c7219ULL, 0x000fe400000006ffULL,
0x0000004257ff7212ULL, 0x000fc4000780c0ffULL, 0x00000029355b7812ULL, 0x000fe400078efcffULL,
0x000054103d3d7816ULL, 0x008fe40000000038ULL, 0x0000003135577812ULL, 0x040fe400078efcffULL,
0x0000003835557812ULL, 0x000fe400078efcffULL, 0x0000541043437816ULL, 0x000fe4000000003aULL,
0x00000039354b7812ULL, 0x000fe200078efcffULL, 0x000000017d427824ULL, 0x000fe200078e0271ULL,
0xff8000001c1c7808ULL, 0x000fe20001000000ULL, 0x0000000134487824ULL, 0x000fe200078e0248ULL,
0xff8000001d1d7808ULL, 0x000fc40003000000ULL, 0xff8000002f2f7808ULL, 0x000fe40002800000ULL,
0x0000003d44ff7212ULL, 0x040fe4000784c0ffULL, 0x0000004344ff7212ULL, 0x080fe400078cc0ffULL,
0x000000434cff7212ULL, 0x000fe200078ac0ffULL, 0x000000015b617824ULL, 0x100fe200078e0271ULL,
0x000000345300720cULL, 0x080fe20000f21470ULL, 0x0000000157597824ULL, 0x100fe200078e0271ULL,
0x000000345300720cULL, 0x080fe20000701470ULL, 0x0000000155697824ULL, 0x100fe200078e0271ULL,
0x000000344f00720cULL, 0x080fe20001f61470ULL, 0x000000014b367824ULL, 0x000fe200078e0271ULL,
0x000000340f00720cULL, 0x080fe20002781470ULL, 0x000000010c4e7824ULL, 0x100fe200078e0a3cULL,
0x000000343700720cULL, 0x0c0fe20001741470ULL, 0x00000001424a7824ULL, 0x000fe200078e0a3cULL,
0x000000343700720cULL, 0x080fe200037c1470ULL, 0x000000013f527824ULL, 0x100fe200078e0a48ULL,
0x000000341000720cULL, 0x000fe20002fa1470ULL, 0x0000000167547824ULL, 0x000fc400078e0a48ULL,
0x0000000165567824ULL, 0x100fe400078e0a48ULL, 0x0000000161587824ULL, 0x000fe200078e0a48ULL,
0x000000340700720cULL, 0x080fe20000f21070ULL, 0x00000001595c7824ULL, 0x100fe200078e0a50ULL,
0x000000340700720cULL, 0x080fe20000701070ULL, 0x00000001693c7824ULL, 0x100fe200078e0a50ULL,
0x000000344d00720cULL, 0x000fe20001f61070ULL, 0x0000000136487824ULL, 0x000fe200078e0a50ULL,
0x0000004e46507219ULL, 0x000fe400000006ffULL, 0x000000345100720cULL, 0x000fc40002781070ULL,
0x000000343900720cULL, 0x0c0fe40001741070ULL, 0x000000343900720cULL, 0x080fe400037c1070ULL,
0x000000347500720cULL, 0x000fe40002fa1070ULL, 0x0000004a464a7219ULL, 0x040fe400000006ffULL,
0x00000052464e7219ULL, 0x000fe400000006ffULL, 0x0000541045457816ULL, 0x000fc4000000003eULL,
0x0000541049497816ULL, 0x000fe40000000040ULL, 0xff80000024247808ULL, 0x000fe40000800000ULL,
0xff8000001b1b7808ULL, 0x000fe40000000000ULL, 0xff80000025257808ULL, 0x000fe40001800000ULL,
0xff8000002e2e7808ULL, 0x000fe40002000000ULL, 0xff8000002b2b7808ULL, 0x000fc40001000000ULL,
0xff8000001f1f7808ULL, 0x000fe40003000000ULL, 0xff80000020207808ULL, 0x000fe40002800000ULL,
0x0000003d4aff7212ULL, 0x080fe4000782c0ffULL, 0x0000003d4cff7212ULL, 0x080fe4000780c0ffULL,
0x0000003d50ff7212ULL, 0x000fe4000786c0ffULL, 0x000000434aff7212ULL, 0x000fc4000788c0ffULL,
0x0000004350ff7212ULL, 0x000fe4000784c0ffULL, 0x000000454eff7212ULL, 0x040fe400078cc0ffULL,
0x000000494eff7212ULL, 0x000fe400078ac0ffULL, 0x000000344200720cULL, 0x0c0fe40000f21470ULL,
0x000000344200720cULL, 0x080fe40002781470ULL, 0x000000341000720cULL, 0x000fc40000701470ULL,
0x000000340c00720cULL, 0x0c0fe40001f61470ULL, 0x000000340c00720cULL, 0x080fe40001741470ULL,
0x000000343f00720cULL, 0x0c0fe400037c1470ULL, 0x000000343f00720cULL, 0x080fe40002fa1470ULL,
0x000000347d00720cULL, 0x0c0fe40000f21070ULL, 0x000000347d00720cULL, 0x000fc40002781070ULL,
0x000000347500720cULL, 0x080fe40000701070ULL, 0x000000346b00720cULL, 0x0c0fe40001f61070ULL,
0x000000346b00720cULL, 0x080fe40001741070ULL, 0x000000343b00720cULL, 0x0c0fe400037c1070ULL,
0x000000343b00720cULL, 0x000fe40002fa1070ULL, 0x0000005446547219ULL, 0x000fc400000006ffULL,
0x0000005646567219ULL, 0x040fe400000006ffULL, 0x0000005846587219ULL, 0x000fe400000006ffULL,
0x000054100d067816ULL, 0x000fe40000000006ULL, 0xff80000026267808ULL, 0x000fe40000800000ULL,
0xff8000001e1e7808ULL, 0x000fe40002000000ULL, 0xff80000027277808ULL, 0x000fc40000000000ULL,
0xff80000032327808ULL, 0x000fe40001800000ULL, 0xff80000031317808ULL, 0x000fe40001000000ULL,
0xff80000030307808ULL, 0x000fe40003000000ULL, 0xff80000021217808ULL, 0x000fe40002800000ULL,
0x0000004554ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004556ff7212ULL, 0x000fc4000788c0ffULL,
0x0000004558ff7212ULL, 0x000fe4000780c0ffULL, 0x0000004954ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004956ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004958ff7212ULL, 0x000fe400078cc0ffULL,
0x000000065aff7212ULL, 0x000fe400078ac0ffULL, 0x000000346700720cULL, 0x000fc40000f21470ULL,
0x000000346700720cULL, 0x080fe40001f61470ULL, 0x000000346500720cULL, 0x0c0fe40002781470ULL,
0x000000346500720cULL, 0x080fe40001741470ULL, 0x000000346100720cULL, 0x0c0fe40000701470ULL,
0x000000346100720cULL, 0x080fe400037c1470ULL, 0x000000344700720cULL, 0x000fc40002fa1470ULL,
0x000000345f00720cULL, 0x0c0fe40000f21070ULL, 0x000000345f00720cULL, 0x080fe40001f61070ULL,
0x000000345d00720cULL, 0x0c0fe40002781070ULL, 0x000000345d00720cULL, 0x080fe40001741070ULL,
0x000000345b00720cULL, 0x0c0fe40000701070ULL, 0x000000345b00720cULL, 0x000fc400037c1070ULL,
0x000000344100720cULL, 0x000fe40002fa1070ULL, 0x0000005c465c7219ULL, 0x040fe400000006ffULL,
0x0000003c463c7219ULL, 0x040fe400000006ffULL, 0x0000004846487219ULL, 0x000fe400000006ffULL,
0x000054100e117816ULL, 0x000fe40000000011ULL, 0xff80000028287808ULL, 0x000fc40000800000ULL,
0xff80000016167808ULL, 0x000fe40001800000ULL, 0xff80000029297808ULL, 0x000fe40002000000ULL,
0xff80000014147808ULL, 0x000fe40001000000ULL, 0xff8000002d2d7808ULL, 0x000fe40000000000ULL,
0xff80000015157808ULL, 0x000fe40003000000ULL, 0xff8000002c2c7808ULL, 0x000fc40002800000ULL,
0x000000065cff7212ULL, 0x080fe4000782c0ffULL, 0x000000063cff7212ULL, 0x080fe4000786c0ffULL,
0x0000000648ff7212ULL, 0x000fe4000788c0ffULL, 0x000000115aff7212ULL, 0x080fe4000784c0ffULL,
0x000000115cff7212ULL, 0x080fe4000780c0ffULL, 0x000000113cff7212ULL, 0x000fc400078cc0ffULL,
0x0000001148ff7212ULL, 0x000fe400078ac0ffULL, 0x000000344700720cULL, 0x080fe40001741470ULL,
0x000000345900720cULL, 0x0c0fe40000f21470ULL, 0x000000345900720cULL, 0x080fe40000701470ULL,
0x000000346900720cULL, 0x0c0fe40001f61470ULL, 0x000000346900720cULL, 0x000fc400037c1470ULL,
0x000000343600720cULL, 0x0c0fe40002781470ULL, 0x000000343600720cULL, 0x080fe40002fa1470ULL,
0x000000344100720cULL, 0x080fe40001741070ULL, 0x000000345700720cULL, 0x0c0fe40000f21070ULL,
0x000000345700720cULL, 0x080fe40000701070ULL, 0x000000345500720cULL, 0x000fc40001f61070ULL,
0x000000345500720cULL, 0x080fe400037c1070ULL, 0x000000344b00720cULL, 0x0c0fe40002781070ULL,
0x000000344b00720cULL, 0x000fe40002fa1070ULL, 0xff8000002a2a7808ULL, 0x000fe40000800000ULL,
0xff80000022227808ULL, 0x000fe40001800000ULL, 0xff80000023237808ULL, 0x000fc40002000000ULL,
0xff80000013137808ULL, 0x000fe40001000000ULL, 0xff80000018187808ULL, 0x000fe40000000000ULL,
0xff80000019197808ULL, 0x000fe40003000000ULL, 0xff8000001a1a7808ULL, 0x000fc40002800000ULL,
0x000000170800720bULL, 0x004fe20003f1e000ULL, 0x0000001fff117424ULL, 0x000fe200078e00ffULL,
0x0000001c0900720bULL, 0x000fe20003f3e000ULL, 0xffffffffff367424ULL, 0x000fe200078e00ffULL,
0x0000000817077208ULL, 0x000fc40004000000ULL, 0x000000091c067208ULL, 0x000fe40004800000ULL,
0x000000240700720bULL, 0x000fe40003f1e000ULL, 0x0000001b0600720bULL, 0x000fe40003f3e000ULL,
0x0000000724087208ULL, 0x000fe40004000000ULL, 0x000000061b067208ULL, 0x000fe40004800000ULL,
0x000000250800720bULL, 0x000fc40003f1e000ULL, 0x0000001d0600720bULL, 0x000fe40003f3e000ULL,
0x0000000825077208ULL, 0x000fe40004000000ULL, 0x000000061d067208ULL, 0x000fe40004800000ULL,
0x0000002e0700720bULL, 0x000fe40003f1e000ULL, 0x0000002f0600720bULL, 0x000fe40003f3e000ULL,
0x000000072e087208ULL, 0x000fc40004000000ULL, 0x000000062f067208ULL, 0x000fe40004800000ULL,
0x0000002b0800720bULL, 0x000fe40003f1e000ULL, 0x0000001f0600720bULL, 0x000fe40003f3e000ULL,
0x000000082b077208ULL, 0x000fe40004000000ULL, 0x000000061f097208ULL, 0x000fe40004800000ULL,
0x000000260700720bULL, 0x000fc40003f1e000ULL, 0x0000001e0900720bULL, 0x000fe40003f3e000ULL,
0x0000000726067208ULL, 0x000fe40004000000ULL, 0x000000091e097208ULL, 0x000fe40004800000ULL,
0x000000270600720bULL, 0x000fe40003f1e000ULL, 0x000000200900720bULL, 0x000fe40003f3e000ULL,
0x0000000627077208ULL, 0x000fc40004000000ULL, 0x0000000920067208ULL, 0x000fe40004800000ULL,
0x000000320700720bULL, 0x000fe40003f1e000ULL, 0x000000310600720bULL, 0x000fe40003f3e000ULL,
0x0000000732077208ULL, 0x000fe40004000000ULL, 0x0000000631067208ULL, 0x000fe40004800000ULL,
0x000000300700720bULL, 0x000fc40003f1e000ULL, 0x000000210600720bULL, 0x000fe40003f3e000ULL,
0x0000000730077208ULL, 0x000fe40004000000ULL, 0x0000000621097208ULL, 0x000fe40004800000ULL,
0x000000280700720bULL, 0x000fe40003f1e000ULL, 0x000000160900720bULL, 0x000fe40003f3e000ULL,
0x0000000728067208ULL, 0x000fc40004000000ULL, 0x0000000916097208ULL, 0x000fe40004800000ULL,
0x000000290600720bULL, 0x000fe40003f1e000ULL, 0x000000140900720bULL, 0x000fe40003f3e000ULL,
0x0000000629067208ULL, 0x000fe40004000000ULL, 0x0000000914087208ULL, 0x000fe40004800000ULL,
0x0000002d0600720bULL, 0x000fc40003f1e000ULL, 0x000000150800720bULL, 0x000fe40003f3e000ULL,
0x000000062d077208ULL, 0x000fe40004000000ULL, 0x0000000815087208ULL, 0x000fe40004800000ULL,
0x0000002c0700720bULL, 0x000fe40003f1e000ULL, 0x000000130800720bULL, 0x000fe40003f3e000ULL,
0x000000072c077208ULL, 0x000fc40004000000ULL, 0x0000000813097208ULL, 0x000fe40004800000ULL,
0x0000002a0700720bULL, 0x000fe40003f1e000ULL, 0x000000180900720bULL, 0x000fe40003f3e000ULL,
0x000000072a077208ULL, 0x000fe40004000000ULL, 0x0000000918067208ULL, 0x000fe40004800000ULL,
0x000000220700720bULL, 0x000fc40003f1e000ULL, 0x000000190600720bULL, 0x000fe40003f3e000ULL,
0x0000000722087208ULL, 0x000fe40004000000ULL, 0x0000000619077208ULL, 0x000fe40004800000ULL,
0x000000230800720bULL, 0x000fe40003f1e000ULL, 0x0000001a0700720bULL, 0x000fe40003f3e000ULL,
0x00000008230e7208ULL, 0x000fc40004000000ULL, 0x000000071a107208ULL, 0x000fe20004800000ULL,
0x000014227f007947ULL, 0x000fec000b800000ULL, 0x0c401f000e067f89ULL, 0x0004e400000e0000ULL,
0x000000060e00720bULL, 0x008fc80003f1e000ULL, 0x0000000e06347208ULL, 0x000fe20004000000ULL,
0x000014327f007947ULL, 0x000fea000b800000ULL, 0x0c401f0010067f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a077f89ULL, 0x000f2800000e0000ULL, 0x0c401f000b087f89ULL, 0x000e6800000e0000ULL,
0x0c201f0034097f89ULL, 0x000ea200000e0000ULL, 0x000000061000720bULL, 0x008fc40003f1e000ULL,
0x000000070a00720bULL, 0x010fe40003f3e000ULL, 0x00000010060c7208ULL, 0x000fe40004000000ULL,
0x0000000a070d7208ULL, 0x000fe40004800000ULL, 0x000000080b00720bULL, 0x002fe20003f1e000ULL,
0x0c201f000c0f7f89ULL, 0x000e6600000e0000ULL, 0x0000000b08067208ULL, 0x000fe20004000000ULL,
0x0c201f000d0e7f89ULL, 0x004ea200000e0000ULL, 0x000000093400720bULL, 0x000fc60003f1e000ULL,
0x0c201f0006077f89ULL, 0x0006e200000e0000ULL, 0x0000003409087208ULL, 0x000fe40004000000ULL,
0x0000000f0c00720bULL, 0x002fe40003f3e000ULL, 0x0000000e0d00720bULL, 0x004fe40003f5e000ULL,
0x0000000c0f097208ULL, 0x000fe40004800000ULL, 0x0000000d0e0a7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b080d7820ULL, 0x008fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000c12127812ULL, 0x000fc400078ec0ffULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b260b7823ULL, 0x100fe2000001080dULL, 0x00000024000f7308ULL, 0x0023e20000000800ULL,
0x3fb8aa3b27107823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b28267823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b29277823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b2d287823ULL, 0x100fe2000001080dULL, 0x00000017000c7308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b2a247823ULL, 0x102fe2000001080dULL, 0x3fb8aa3b092a7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001080dULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001082aULL, 0x00000025000e7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b142d7823ULL, 0x100fe2000001082aULL, 0x0000000c0f0c723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001082aULL, 0x0000000b00347308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b30257823ULL, 0x002fe2000001080dULL, 0x3fb8aa3b13137823ULL, 0x000fe2000001082aULL,
0x000000070600720bULL, 0x004fca0003f3e000ULL, 0x0000001000177308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2c0b7823ULL, 0x008fce000001080dULL, 0x0000002e00117308ULL, 0x000e700000000800ULL,
0x0000001c000d7308ULL, 0x000ff00000000800ULL, 0x0000001b00107308ULL, 0x0004e20000000800ULL,
0x0000000e110e723eULL, 0x002fe200000000ffULL, 0x3c003c00ff117424ULL, 0x000fcc00078e00ffULL,
0x0000001d001d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b161b7823ULL, 0x004fce000001082aULL,
0x0000002f002c7308ULL, 0x0002a20000000800ULL, 0x0000000d100d723eULL, 0x008fe200000000ffULL,
0x3c003c00ff107424ULL, 0x000fcc00078e00ffULL, 0x0000001f00297308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b152f7823ULL, 0x002fe2000001082aULL, 0x0000001d2c0f723eULL, 0x004fcc00000000ffULL,
0x0000001e002e7308ULL, 0x0002b00000000800ULL, 0x0000003200327308ULL, 0x000ee20000000800ULL,
0x000000100c1c723cULL, 0x002f6e00000018ffULL, 0x0000002b002b7308ULL, 0x000e620000000800ULL,
0x000000292e15723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b1a297823ULL, 0x000fcc000001082aULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x000000173216723eULL, 0x008fe400000000ffULL,
0x00000002ff327819ULL, 0x000fc80000011602ULL, 0x00000003321a7810ULL, 0x000fe20007ffe0ffULL,
0x0000003100317308ULL, 0x000ea20000000800ULL, 0x0000002b3414723eULL, 0x002fe200000000ffULL,
0x00000008322b7824ULL, 0x040fe200078e00ffULL, 0x00000004322e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000832347824ULL, 0x040fe400078e00ffULL, 0x0000000832337824ULL, 0x040fe400078e00ffULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x0000000832357824ULL, 0x000fc400078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee22eULL, 0x00000008322e7824ULL, 0x040fe400078e00ffULL,
0x0000000832377824ULL, 0x040fe200078e00ffULL, 0x000000203117723eULL, 0x004fe200000000ffULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b19207823ULL, 0x000fe2000001082aULL,
0x0000000832317824ULL, 0x040fe200078e00ffULL, 0x0000000232197810ULL, 0x000fc60007ffe0ffULL,
0x00000010141c723cULL, 0x020f62000000181cULL, 0xfffffff831317812ULL, 0x000fe200078ee21aULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000002800287308ULL, 0x000e700000000800ULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x0000001b002c7308ULL, 0x0004e20000000800ULL,
0x00000027281a723eULL, 0x002fe200000000ffULL, 0x0000000832277824ULL, 0x040fe200078e00ffULL,
0x0000000632287810ULL, 0x000fc80007ffe0ffULL, 0xfffffff827277812ULL, 0x000fe200078ee232ULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b181b7823ULL, 0x004fe2000001082aULL,
0x0000000132187810ULL, 0x000fe40007ffe0ffULL, 0xfffffff835357812ULL, 0x000fe400078ee228ULL,
0xfffffff82b2b7812ULL, 0x000fe400078ee218ULL, 0x0000002f00307308ULL, 0x0002a20000000800ULL,
0x000000252618723eULL, 0x000fce00000000ffULL, 0x0000001b002a7308ULL, 0x0005e20000000800ULL,
0xfffffff8342f7812ULL, 0x002fe400078ee219ULL, 0x000000212c19723eULL, 0x008fe400000000ffULL,
0x0000000532217810ULL, 0x040fe40007ffe0ffULL, 0xffffffff322c7810ULL, 0x000fe20007ffe0ffULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x0000002d301b723eULL, 0x004fe400000000ffULL,
0xfffffff82e2d7812ULL, 0x000fc400078ee221ULL, 0xfffffff837377812ULL, 0x000fc600078ee22cULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x00000010181c723cULL, 0x020f6e000000181cULL,
0x0000000b000b7308ULL, 0x000ff00000000800ULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x000000222322723eULL, 0x002fce00000000ffULL, 0x0000001300137308ULL, 0x000e700000000800ULL,
0x0000002000257308ULL, 0x0005f00000000800ULL, 0x0000002900267308ULL, 0x0007220000000800ULL,
0x0000000832207810ULL, 0x004fc40007ffe0ffULL, 0x000000132a21723eULL, 0x002fc600000000ffULL,
0x0000000820397824ULL, 0x000fca00078e00ffULL, 0xfffffff839297812ULL, 0x008fe400078ee220ULL,
0x0000000b2420723eULL, 0x000fe400000000ffULL, 0x0000900000247811ULL, 0x000fe400078e58ffULL,
0x000000252623723eULL, 0x010fe400000000ffULL, 0x00000006070b7208ULL, 0x000fe20004800000ULL,
0x0000001027277824ULL, 0x100fe400078e0224ULL, 0x000000102b2b7824ULL, 0x000fc400078e0224ULL,
0x00000010201c723cULL, 0x020f62000000181cULL, 0x000000102f2f7824ULL, 0x100fe400078e0224ULL,
0x0000001031317824ULL, 0x100fe400078e0224ULL, 0x0000001033337824ULL, 0x000fe400078e0224ULL,
0x0000000127277824ULL, 0x000fe400078e0212ULL, 0x000000102d2d7824ULL, 0x100fe400078e0224ULL,
0x00000001122b7824ULL, 0x000fe200078e022bULL, 0x0000000c27007388ULL, 0x0003e20000000800ULL,
0x0000001035357824ULL, 0x000fc400078e0224ULL, 0x00000001122f7824ULL, 0x040fe200078e022fULL,
0x0000000e2b007388ULL, 0x0003e20000000800ULL, 0x0000001037377824ULL, 0x100fe400078e0224ULL,
0x0000000112317824ULL, 0x040fe200078e0231ULL, 0x000000142f007388ULL, 0x0003e20000000800ULL,
0x0000001029297824ULL, 0x000fe400078e0224ULL, 0x0000000112337824ULL, 0x040fe200078e0233ULL,
0x0000001631007388ULL, 0x0003e20000000800ULL, 0x00000001122d7824ULL, 0x000fc400078e022dULL,
0x0000000112357824ULL, 0x040fe200078e0235ULL, 0x0000001833007388ULL, 0x0003e20000000800ULL,
0x0000000112377824ULL, 0x040fe400078e0237ULL, 0x0000000112127824ULL, 0x000fe200078e0229ULL,
0x0000001a2d007388ULL, 0x0003e20000000800ULL, 0x000000ffff1d7224ULL, 0x020fc600078e001eULL,
0x0000002035007388ULL, 0x0003e80000000800ULL, 0x0000002237007388ULL, 0x0003e80000000800ULL,
0x0000000d12007388ULL, 0x0003e80000000800ULL, 0x0004000f2b007388ULL, 0x0003e80000000800ULL,
0x000400152f007388ULL, 0x0003e80000000800ULL, 0x0004001731007388ULL, 0x0003e80000000800ULL,
0x0004001933007388ULL, 0x0003e80000000800ULL, 0x0004001b2d007388ULL, 0x0003e80000000800ULL,
0x0004002135007388ULL, 0x0003e80000000800ULL, 0x0004002337007388ULL, 0x0003e80000000800ULL,
0x00f0000805008388ULL, 0x0003e80000000c00ULL, 0x00f2001c05008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000007cff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008007cff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010007cff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000103037810ULL, 0x000fe20007ffe0ffULL,
0x000018007cff7f8cULL, 0x0003e6000c80043fULL, 0x000000700300720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb5c000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0f7807ULL, 0x008fe40004000000ULL,
0x000122c000127802ULL, 0x000fc40000000f00ULL, 0x00000bc000007944ULL, 0x002fea0003c00000ULL,
0xffff037000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0f7807ULL, 0x000fe40005000000ULL,
0x0001230000127802ULL, 0x000fc40000000f00ULL, 0x00000b8000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff037224ULL, 0x000fe200078e000fULL, 0xffff03d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0032ULL, 0x0001235000137802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x002fea0003c00000ULL, 0xffff04b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0032ULL, 0x0001239000137802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x002fea0003c00000ULL, 0xffff05d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0003ULL, 0x000123e000137802ULL, 0x000fe20000000f00ULL,
0x000000ffff0f7224ULL, 0x000fc400078e0010ULL, 0x00000a5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e000fULL, 0xffff09e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0003ULL, 0x0001243000137802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e000fULL,
0xffff09c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0f7807ULL, 0x008fe40004000000ULL,
0x0001248000127802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x002fea0003c00000ULL,
0xffff287000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0f7807ULL, 0x000fe40005000000ULL,
0x000124c000127802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff367224ULL, 0x000fe200078e000fULL, 0xffff28b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0039ULL, 0x0001251000137802ULL, 0x000fc40000000f00ULL,
0x0000092000007944ULL, 0x002fea0003c00000ULL, 0xffff299000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0039ULL, 0x0001255000137802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x002fea0003c00000ULL, 0xffff2ab000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e000cULL, 0x000125a000137802ULL, 0x000fe20000000f00ULL,
0x000000ffff0f7224ULL, 0x000fc400078e000dULL, 0x0000089000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e000fULL, 0xffff2ed000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e000cULL, 0x000125f000137802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e000fULL,
0xffff2eb000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0f7807ULL, 0x008fe40004000000ULL,
0x0001264000127802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x002fea0003c00000ULL,
0xffff4d2000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0f7807ULL, 0x000fe40005000000ULL,
0x0001268000127802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff077224ULL, 0x000fe200078e000fULL, 0xffff4d7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0031ULL, 0x000126d000137802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x002fea0003c00000ULL, 0xffff4e6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0031ULL, 0x0001271000137802ULL, 0x000fc40000000f00ULL,
0x0000072000007944ULL, 0x002fea0003c00000ULL, 0xffff4f8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e000bULL, 0x0001276000137802ULL, 0x000fe20000000f00ULL,
0x000000ffff0f7224ULL, 0x000fc400078e0010ULL, 0x000006d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e000fULL, 0xffff53a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e000bULL, 0x000127b000137802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e000fULL,
0xffff538000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0f7807ULL, 0x00cfe40004000000ULL,
0x0001280000127802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x000fea0003c00000ULL,
0xffff713000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0f7807ULL, 0x000fe40005000000ULL,
0x0001284000127802ULL, 0x000fc40000000f00ULL, 0x0000064000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e000fULL, 0xffff718000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0007ULL, 0x0001289000137802ULL, 0x000fc40000000f00ULL,
0x000005a000007944ULL, 0x000fea0003c00000ULL, 0xffff726000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e0007ULL, 0x000128d000137802ULL, 0x000fc40000000f00ULL,
0x0000056000007944ULL, 0x002fea0003c00000ULL, 0xffff738000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e000cULL, 0x0001292000137802ULL, 0x000fe20000000f00ULL,
0x000000ffff0f7224ULL, 0x000fc400078e001dULL, 0x0000051000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e000fULL, 0xffff77e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff127224ULL, 0x000fe200078e000cULL, 0x0001297000137802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e000fULL,
0xffff77c000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x000129c0000c7802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0007ULL, 0xffffeba000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x006fe200078e0010ULL, 0x00012a20000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x000000071000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x00012a80000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001007107208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000070a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000bULL,
0x00012ae0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a070a7208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000070b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0034ULL,
0x00012b40000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000b07067208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000073400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0010ULL,
0x00012ba0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000003407087208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000071000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x00012c00000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001007097208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000070a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0006ULL,
0x00012c60000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a070a7208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffea7000007947ULL, 0x000fea000383ffffULL, 0x0180000038007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000003800008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff38ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000038027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003800007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffed21002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0c00000f0e077389ULL, 0x0002a200000e0011ULL,
0xfffed1d00c007950ULL, 0x000fea0003c3ffffULL, 0x0000007900007348ULL, 0x000fe80003800000ULL,
0x0000000f120f7389ULL, 0x0002a400000e007aULL, 0x000000ffff127224ULL, 0x002fc400078e0013ULL,
0x00000000ff137424ULL, 0x000fc800078e00ffULL, 0xfffed18012007950ULL, 0x000fea0003c3ffffULL,
0x000000010f00780cULL, 0x000fe20003f45070ULL, 0x00000000ff137424ULL, 0x000fe200078e00ffULL,
0x0000007800007348ULL, 0x000ff60003800000ULL, 0x00000000000f7806ULL, 0x000fc800050e0100ULL,
0x000000780f0f7212ULL, 0x000fe200078ec0ffULL, 0xfffed12012007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005f4ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000750ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f0ULL, 0x00000000000003d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000dc8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e88ULL, 0x00000000000007ccULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001658ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001668ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000016f8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000016fcULL, 0x00000000000001c0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001900ULL, 0x0000000000012f80ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014880ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000148d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000014c50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000016f8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000013188ULL, 0x0000000000013188ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014880ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000014c50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_16_sm_89_cubin_len = 85296;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
