/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_4_kvt_int8_pagedKV_64_nqpkv_1_m_1_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000002c550ULL, 0x000000000002c1d0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45346a4c4545346aULL,
0x7461324545386a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL,
0x30326d735f616475ULL, 0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL,
0x65746e695f5f2400ULL, 0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x6c66625f636e7973ULL, 0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL,
0x635f5f245f335f6cULL, 0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL,
0x65746e695f5f2400ULL, 0x245f345f6c616e72ULL, 0x735f616475635f5fULL, 0x707261775f30376dULL,
0x65722e00636e7973ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL, 0x2e6c65722e006168ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x5f6c656e72656b24ULL, 0x6d656d732461686dULL,
0x0066754265747942ULL, 0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL,
0x006d617261705f00ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x2e6c65722e766e2eULL,
0x00006e6f69746361ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b9ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000407ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044cULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000492ULL, 0x0000000000029f90ULL,
0x0000000000000180ULL, 0x000b0022000004c5ULL, 0x000000000002a110ULL, 0x0000000000000040ULL,
0x000b0022000004f0ULL, 0x000000000002a150ULL, 0x0000000000000040ULL, 0x000b00220000051aULL,
0x000000000002a190ULL, 0x0000000000000070ULL, 0x000b002200000545ULL, 0x000000000002a200ULL,
0x0000000000000100ULL, 0x000a0003000005acULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000005ccULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005fcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x000000000002a300ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00029f9000000000ULL, 0x0000040400000000ULL,
0x810c0000015c0400ULL, 0x00a6780400288080ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8308288080820828ULL, 0x2880808808288080ULL, 0x8090082880808908ULL,
0x0828808096082880ULL, 0x8080a90828808098ULL, 0xae08288080aa0828ULL, 0x288080b808288080ULL,
0x80be08288080bc08ULL, 0x08288080bf082880ULL, 0x80808408288080cfULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x00029f9000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808084ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8308288080820828ULL, 0x2880808408288080ULL, 0x8089082880808808ULL, 0x0828808090082880ULL,
0x8080980828808096ULL, 0xaa08288080a90828ULL, 0x288080ae08288080ULL, 0x80bc08288080b808ULL,
0x08288080bf082880ULL, 0x80809208288080cfULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880809292ULL, 0x0000001cffffffffULL, 0x0000014800000000ULL, 0x0002a11000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8308288080820828ULL, 0x2880808408288080ULL, 0x8089082880808808ULL, 0x0828808090082880ULL,
0x8080980828808096ULL, 0xaa08288080a90828ULL, 0x288080ae08288080ULL, 0x80be08288080bc08ULL,
0x08288080bf082880ULL, 0x8080b808288080cfULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x002200288080b892ULL, 0x0000001cffffffffULL, 0x0000020800000000ULL, 0x0002a15000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8308288080820828ULL, 0x2880808408288080ULL, 0x8089082880808808ULL, 0x0828808090082880ULL,
0x8080980828808096ULL, 0xaa08288080a90828ULL, 0x288080ae08288080ULL, 0x80bf08288080b808ULL,
0x08288080cf082880ULL, 0x80828016288080bcULL, 0x0000000000031028ULL, 0x288080bc92000000ULL,
0x0000000000002200ULL, 0x0000002cffffffffULL, 0x000002c800000000ULL, 0x0002a19000000000ULL,
0x0000007000000000ULL, 0x0000180400000000ULL, 0x80b8288080bc0900ULL, 0x0000000000002880ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8308288080820828ULL, 0x2880808408288080ULL,
0x8089082880808808ULL, 0x0828808090082880ULL, 0x8080980828808096ULL, 0xaa08288080a90828ULL,
0x288080b808288080ULL, 0x80be08288080bc08ULL, 0x08288080bf082880ULL, 0x8080ae08288080cfULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080ae92ULL, 0x0000001cffffffffULL,
0x0000039800000000ULL, 0x0002a20000000000ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000001b00082f04ULL, 0x00082304000000faULL, 0x0000000000000017ULL, 0x0000001700081204ULL,
0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001b00082304ULL, 0x0008120400000000ULL, 0x000000000000001bULL, 0x0000001b00081104ULL,
0x0004370400000000ULL, 0x000035010000007bULL, 0x0000001800080a04ULL, 0x0068190300680160ULL,
0x00000000000c1704ULL, 0x0021f00000600007ULL, 0x00000000000c1704ULL, 0x0021f00000580006ULL,
0x00000000000c1704ULL, 0x0011f00000500005ULL, 0x00000000000c1704ULL, 0x0061f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400ff1b03ULL, 0x01bc290400000030ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01bc2804ffffffffULL, 0x0000013000000100ULL, 0x0000346000000380ULL,
0x000035f0000034f0ULL, 0x0000398000003750ULL, 0x00003a20000039b0ULL, 0x0000709000003a90ULL,
0x00007120000070b0ULL, 0x0000abc000007190ULL, 0x0000ad400000ac50ULL, 0x0000b0b00000ae90ULL,
0x0000b1400000b0d0ULL, 0x0000e5d00000b1b0ULL, 0x0000e6600000e5f0ULL, 0x00011fe00000e6d0ULL,
0x0001216000012070ULL, 0x000124d0000122b0ULL, 0x00012560000124f0ULL, 0x000159f0000125d0ULL,
0x00015a8000015a10ULL, 0x0001940000015af0ULL, 0x0001958000019490ULL, 0x000198f0000196d0ULL,
0x0001998000019910ULL, 0x0001ce10000199f0ULL, 0x0001cea00001ce30ULL, 0x0001f1800001cf10ULL,
0x0001f8b00001f2c0ULL, 0x0001fd200001f8d0ULL, 0x000229c000021f30ULL, 0x00024ae0000229e0ULL,
0x00027eb000024b00ULL, 0x00027f0000027ef0ULL, 0x00027f6000027f10ULL, 0x00027fa000027f80ULL,
0x00028c3000027fb0ULL, 0x00028d1000028c90ULL, 0x00028e1000028d90ULL, 0x00028f1000028e90ULL,
0x00028ff000028f90ULL, 0x000290c000029050ULL, 0x000291c000029140ULL, 0x000292c000029240ULL,
0x000293a000029340ULL, 0x0002947000029400ULL, 0x00029570000294f0ULL, 0x00029670000295f0ULL,
0x00029750000296f0ULL, 0x00029820000297b0ULL, 0x00029920000298a0ULL, 0x00029a20000299a0ULL,
0x00029b1000029aa0ULL, 0x00029bf000029b80ULL, 0x00029ce000029c60ULL, 0x00029de000029d60ULL,
0x00029ee000029e60ULL, 0x07e0390400029f60ULL, 0x000000ff00000200ULL, 0x003f010000018ad0ULL,
0x0000000b00000260ULL, 0x003f012000018ad8ULL, 0x0000000b00000290ULL, 0x003f012000018b58ULL,
0x0000000b000002b0ULL, 0x003f012000018b78ULL, 0x000000ff00000370ULL, 0x003f010000018b88ULL,
0x000000ff00000500ULL, 0x003f010700018ad0ULL, 0x000000ff000007e0ULL, 0x0005010200018b5cULL,
0x000000ff00000840ULL, 0x0005010100018b58ULL, 0x000000ff000009c0ULL, 0x003f010100018b88ULL,
0x000000ff00000a00ULL, 0x003f010500018b8cULL, 0x000000ff00000bc0ULL, 0x003f010500018b8cULL,
0x000000ff000015d0ULL, 0x003f010100018b88ULL, 0x000000ff00001600ULL, 0x003f010500018b8cULL,
0x000000ff000017d0ULL, 0x003f010500018b8cULL, 0x000000ff00001940ULL, 0x003f010700018b78ULL,
0x000000ff000019c0ULL, 0x003f010100018b78ULL, 0x000000ff00001a30ULL, 0x003f010100018b88ULL,
0x000000ff00001cc0ULL, 0x003f010500018b7cULL, 0x000000ff00001e80ULL, 0x003f010500018b7cULL,
0x000000ff00001ee0ULL, 0x003f010500018b8cULL, 0x000000ff000020b0ULL, 0x003f010500018b8cULL,
0x000000ff00002b10ULL, 0x003f010100018b88ULL, 0x000000ff00002b40ULL, 0x003f010500018b8cULL,
0x000000ff00002d10ULL, 0x003f010500018b8cULL, 0x000000ff00003070ULL, 0x003f010700018b80ULL,
0x000000ff00003100ULL, 0x003f010100018b80ULL, 0x000000ff00003180ULL, 0x0005010100018ad8ULL,
0x000000ff000031b0ULL, 0x0005010500018adcULL, 0x000000ff00003380ULL, 0x0005010500018adcULL,
0x000000ff00005ce0ULL, 0x003f010100018b88ULL, 0x000000ff00005db0ULL, 0x003f010500018b84ULL,
0x000000ff00005f70ULL, 0x003f010500018b84ULL, 0x000000ff00005fd0ULL, 0x003f010500018b8cULL,
0x000000ff000061a0ULL, 0x003f010500018b8cULL, 0x000000ff00006bd0ULL, 0x003f010100018b88ULL,
0x000000ff00006c00ULL, 0x003f010500018b8cULL, 0x000000ff00006dd0ULL, 0x003f010500018b8cULL,
0x000000ff00006fa0ULL, 0x003f010700018b78ULL, 0x000000ff00007020ULL, 0x003f010100018b78ULL,
0x000000ff000092a0ULL, 0x003f010100018b88ULL, 0x000000ff00009370ULL, 0x003f010100018b58ULL,
0x000000ff00009450ULL, 0x003f010500018b7cULL, 0x000000ff00009610ULL, 0x003f010500018b7cULL,
0x000000ff00009670ULL, 0x003f010500018b8cULL, 0x000000ff00009840ULL, 0x003f010500018b8cULL,
0x000000ff0000a290ULL, 0x003f010100018b88ULL, 0x000000ff0000a2c0ULL, 0x003f010500018b8cULL,
0x000000ff0000a490ULL, 0x003f010500018b8cULL, 0x000000ff0000a7c0ULL, 0x003f010700018b80ULL,
0x000000ff0000a840ULL, 0x003f010100018b80ULL, 0x000000ff0000a8e0ULL, 0x0005010100018af8ULL,
0x000000ff0000a910ULL, 0x0005010500018afcULL, 0x000000ff0000aae0ULL, 0x0005010500018afcULL,
0x000000ff0000d210ULL, 0x003f010100018b88ULL, 0x000000ff0000d2f0ULL, 0x003f010500018b84ULL,
0x000000ff0000d4b0ULL, 0x003f010500018b84ULL, 0x000000ff0000d510ULL, 0x003f010500018b8cULL,
0x000000ff0000d6e0ULL, 0x003f010500018b8cULL, 0x000000ff0000e110ULL, 0x003f010100018b88ULL,
0x000000ff0000e140ULL, 0x003f010500018b8cULL, 0x000000ff0000e310ULL, 0x003f010500018b8cULL,
0x000000ff0000e4e0ULL, 0x003f010700018b78ULL, 0x000000ff0000e560ULL, 0x003f010100018b78ULL,
0x000000ff000106e0ULL, 0x003f010100018b88ULL, 0x000000ff00010790ULL, 0x003f010100018b60ULL,
0x000000ff00010870ULL, 0x003f010500018b7cULL, 0x000000ff00010a30ULL, 0x003f010500018b7cULL,
0x000000ff00010a90ULL, 0x003f010500018b8cULL, 0x000000ff00010c60ULL, 0x003f010500018b8cULL,
0x000000ff000116b0ULL, 0x003f010100018b88ULL, 0x000000ff000116e0ULL, 0x003f010500018b8cULL,
0x000000ff000118b0ULL, 0x003f010500018b8cULL, 0x000000ff00011be0ULL, 0x003f010700018b80ULL,
0x000000ff00011c60ULL, 0x003f010100018b80ULL, 0x000000ff00011d00ULL, 0x0005010100018b18ULL,
0x000000ff00011d30ULL, 0x0005010500018b1cULL, 0x000000ff00011f00ULL, 0x0005010500018b1cULL,
0x000000ff00014630ULL, 0x003f010100018b88ULL, 0x000000ff00014710ULL, 0x003f010500018b84ULL,
0x000000ff000148d0ULL, 0x003f010500018b84ULL, 0x000000ff00014930ULL, 0x003f010500018b8cULL,
0x000000ff00014b00ULL, 0x003f010500018b8cULL, 0x000000ff00015530ULL, 0x003f010100018b88ULL,
0x000000ff00015560ULL, 0x003f010500018b8cULL, 0x000000ff00015730ULL, 0x003f010500018b8cULL,
0x000000ff00015900ULL, 0x003f010700018b78ULL, 0x000000ff00015980ULL, 0x003f010100018b78ULL,
0x000000ff00017b00ULL, 0x003f010100018b88ULL, 0x000000ff00017bb0ULL, 0x003f010100018b68ULL,
0x000000ff00017c90ULL, 0x003f010500018b7cULL, 0x000000ff00017e50ULL, 0x003f010500018b7cULL,
0x000000ff00017eb0ULL, 0x003f010500018b8cULL, 0x000000ff00018080ULL, 0x003f010500018b8cULL,
0x000000ff00018ad0ULL, 0x003f010100018b88ULL, 0x000000ff00018b00ULL, 0x003f010500018b8cULL,
0x000000ff00018cd0ULL, 0x003f010500018b8cULL, 0x000000ff00019000ULL, 0x003f010700018b80ULL,
0x000000ff00019080ULL, 0x003f010100018b80ULL, 0x000000ff00019120ULL, 0x0005010100018b38ULL,
0x000000ff00019150ULL, 0x0005010500018b3cULL, 0x000000ff00019320ULL, 0x0005010500018b3cULL,
0x000000ff0001ba50ULL, 0x003f010100018b88ULL, 0x000000ff0001bb30ULL, 0x003f010500018b84ULL,
0x000000ff0001bcf0ULL, 0x003f010500018b84ULL, 0x000000ff0001bd50ULL, 0x003f010500018b8cULL,
0x000000ff0001bf20ULL, 0x003f010500018b8cULL, 0x000000ff0001c950ULL, 0x003f010100018b88ULL,
0x000000ff0001c980ULL, 0x003f010500018b8cULL, 0x000000ff0001cb50ULL, 0x003f010500018b8cULL,
0x000000ff0001cd20ULL, 0x003f010700018b78ULL, 0x000000ff0001cda0ULL, 0x003f010100018b78ULL,
0x000000ff0001ef20ULL, 0x003f010100018b88ULL, 0x000000ff0001efc0ULL, 0x003f010100018b70ULL,
0x000000ff0001fb00ULL, 0x003f010100018ad0ULL, 0x000000ff00021f60ULL, 0x003f010500018ad4ULL,
0x000000ff00022130ULL, 0x003f010500018ad4ULL, 0x000000ff000224c0ULL, 0x003f010100018ad0ULL,
0x000000ff00022500ULL, 0x003f010500018ad4ULL, 0x000000ff000226c0ULL, 0x003f010500018ad4ULL,
0x00000004000270d0ULL, 0x003f010100000000ULL, 0x0000000400027400ULL, 0x003f010500000004ULL,
0x00000004000275d0ULL, 0x003f010500000004ULL, 0x0000000600028a80ULL, 0x003f010100000000ULL,
0x0000000600028ae0ULL, 0x003f010100000008ULL, 0x0000000600028b40ULL, 0x003f010100000010ULL,
0x0000000600028bb0ULL, 0x003f010100000018ULL, 0x00101c0400053803ULL, 0x000227200001fa00ULL,
0x00028bf000022800ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000444ULL,
0x0000001b00000002ULL, 0x0000000000000374ULL, 0x0000001b00000002ULL, 0x00000000000002b4ULL,
0x0000001b00000002ULL, 0x00000000000001f4ULL, 0x0000001b00000002ULL, 0x000000000000011cULL,
0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL, 0x0000000000000420ULL,
0x0000001b00000002ULL, 0x000000000000034bULL, 0x0000001b00000002ULL, 0x0000000000000290ULL,
0x0000001b00000002ULL, 0x00000000000001d0ULL, 0x0000001b00000002ULL, 0x00000000000000f8ULL,
0x0000001b00000002ULL, 0x0000000000018c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x00000000000d79c3ULL, 0x000ea20000002700ULL, 0x0000000000127806ULL, 0x000fe200038e0000ULL,
0x00005800ff0f7624ULL, 0x000fe200078e00ffULL, 0x00000000000a7919ULL, 0x000ee20000002300ULL,
0x00004600000a7ab9ULL, 0x000fe20000000a00ULL, 0x0000001200067300ULL, 0x000fe200000e0000ULL,
0x0000000400097882ULL, 0x000fe20000000000ULL, 0x0000000000037919ULL, 0x000ee80000002200ULL,
0x0000000000107919ULL, 0x000f240000000000ULL, 0x0000001200127309ULL, 0x000ee40000000000ULL,
0x0000000000357919ULL, 0x000f280000002600ULL, 0x0000000000077919ULL, 0x000f220000000000ULL,
0x00000005ff007819ULL, 0x002fe2000001160bULL, 0x000000020d0c7899ULL, 0x004fca000800063fULL,
0x00001fff00007589ULL, 0x000e6200000e0000ULL, 0x000000ffff127224ULL, 0x008fe400078e0a12ULL,
0x000001000a027a24ULL, 0x000fe400078e0203ULL, 0x00001fff0a0a7589ULL, 0x000ea400000e0000ULL,
0x00000000020b7a24ULL, 0x000fca00078e020bULL, 0x000000ff0b00720cULL, 0x040fe40003f25270ULL,
0x0000007f0b00780cULL, 0x040fe40003f84070ULL, 0x0000000f0b00780cULL, 0x040fe40003f44070ULL,
0x000000030b00780cULL, 0x040fe40003f64070ULL, 0x000000010b00780cULL, 0x000fe40003fa4070ULL,
0x000000070600720cULL, 0x010fe20003f02070ULL, 0x00000000000873c2ULL, 0x002ea400000e0000ULL,
0x3fffff80ff029424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff039424ULL, 0x000fe400078e00ffULL,
0xff317217ff0cc424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff04a424ULL, 0x000fe200078e00ffULL,
0x018ad002ff009388ULL, 0x0003e20000000a00ULL, 0x7fffffc0ff05a424ULL, 0x000fe400078e00ffULL,
0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL, 0x0184000c0b00c388ULL, 0x000fe20000004800ULL,
0x7fffff60ff07b424ULL, 0x000fc400078e00ffULL, 0x3fffff00ff08d424ULL, 0x000fe200078e00ffULL,
0x018ad8040b00a388ULL, 0x0007e20000008a00ULL, 0x7fffff00ff09d424ULL, 0x000fe400078e00ffULL,
0x0000001010037824ULL, 0x002fe200078e00ffULL, 0x018b58060b00b388ULL, 0x0003e20000008a00ULL,
0x000000080a007c11ULL, 0x004fc6000f8e10ffULL, 0x018b78080b00d388ULL, 0x000fe20000008a00ULL,
0x00000200ff057424ULL, 0x008fe400078e00ffULL, 0x00000002000d7824ULL, 0x000fe400078e00ffULL,
0x3fffff80ff069424ULL, 0x002fe400078e00ffULL, 0x000000010d007824ULL, 0x040fe200078e0210ULL,
0x000000040d027817ULL, 0x040fe20007800000ULL, 0x000000200d117824ULL, 0x000fe400078e00ffULL,
0x7fffff80ff079424ULL, 0x000fc400078e00ffULL, 0x00000001020c7824ULL, 0x000fe200078e0a0dULL,
0xffffffe0110e7812ULL, 0x000fe200078ee200ULL, 0x000000040f007824ULL, 0x000fe200078e00ffULL,
0x000000010d0f7810ULL, 0x040fe20007ffe0ffULL, 0x018b8806ff009388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000d00007c24ULL, 0x000fe2000f8e0235ULL,
0x000000ff0c00720cULL, 0x000fe20003f43070ULL, 0x000000100e097824ULL, 0x000fe200078e00ffULL,
0x000000010c00780cULL, 0x000fe20003f63070ULL, 0x000058000d027a24ULL, 0x100fe200078e0200ULL,
0x000001f0030d7812ULL, 0x000fe200078ec0ffULL, 0x000058000f047a24ULL, 0x000fc400078e0200ULL,
0x00005c0002027625ULL, 0x000fc800078e0005ULL, 0x000000010f007824ULL, 0x000fe200078e0210ULL,
0x0000000d02027210ULL, 0x000fe20007f9e0ffULL, 0x00005c0004047625ULL, 0x000fc800078e0005ULL,
0x000000200f0f7824ULL, 0x000fe200078e00ffULL, 0x0000000d04047210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff037224ULL, 0x000fc600020e0603ULL, 0xffffffe00f007812ULL, 0x000fe200078ee200ULL,
0x000000ffff057224ULL, 0x000fe200028e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e6000d101c4aULL, 0x00000010000b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff007224ULL, 0x000fc600078e0012ULL, 0x00000000040b7faeULL, 0x0003e8000d901c4aULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x018ad400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x018ad000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000620000047ab9ULL, 0x000fe40000000a00ULL, 0x000000090c0472a5ULL, 0x000fc4000f8e0004ULL,
0x00006a0000067ab9ULL, 0x000fe40000000a00ULL, 0x000000090c0672a5ULL, 0x000fe4000f8e0006ULL,
0x00000004ff607e24ULL, 0x000fe4000f8e00ffULL, 0x00000005ff617e24ULL, 0x000fe4000f8e00ffULL,
0x00000006ff027e24ULL, 0x002fe4000f8e00ffULL, 0x00000007ff037e24ULL, 0x000fe2000f8e00ffULL,
0x0000000a60607981ULL, 0x000ea8000c1e1900ULL, 0x0000000a02027981ULL, 0x000ee2000c1e1900ULL,
0x000000ff0a00720cULL, 0x000fc40003f05270ULL, 0x0000003f60377810ULL, 0x044fe40007ffe0ffULL,
0x000000ff60007810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff347819ULL, 0x008fe40000011602ULL,
0x00000006ff377819ULL, 0x000fe40000011637ULL, 0x00000008ff367819ULL, 0x000fc60000011600ULL,
0x0001f38000008947ULL, 0x000fea0003800000ULL, 0x00000008ff337e24ULL, 0x000fe2000f8e00ffULL,
0x0000000308057899ULL, 0x000fe2000800063fULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x00000003ff047424ULL, 0x000fe400078e00ffULL, 0x0000002033057824ULL, 0x000fca00078e0210ULL,
0x0000001f0500780cULL, 0x040fe40003f04070ULL, 0x000000030500780cULL, 0x000fd60003f24070ULL,
0x0000007000000947ULL, 0x000fea0003800000ULL, 0x0000000cff027e24ULL, 0x000fe2000f8e00ffULL,
0x000000600500720cULL, 0x040fe20003f06070ULL, 0x00000004ff037424ULL, 0x000fe200078e00ffULL,
0x00018a0005077811ULL, 0x000fe200078e10ffULL, 0x0000680002027a24ULL, 0x000fc800078e0205ULL,
0x0000660002027625ULL, 0x000fcc00078e0003ULL, 0x0000000002077faeULL, 0x0003e4000c12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b5c04ffff798cULL, 0x0005e20008000005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b5800ffff7f8cULL, 0x000fe2000c800405ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x002e620000002700ULL,
0x00006400ff037624ULL, 0x000fe200078e00ffULL, 0x000000ff3700720cULL, 0x000fe20003f05270ULL,
0x00000004ff077424ULL, 0x000fe400078e00ffULL, 0x0000000402027824ULL, 0x002fe200078e0205ULL,
0x00018ac005057811ULL, 0x000fc600078e10ffULL, 0x0000000202027824ULL, 0x000fc800078e00ffULL,
0x0000640002027624ULL, 0x000fc800078e0203ULL, 0x0000600002027625ULL, 0x000fca00078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e4000812184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff027f8cULL, 0x002e62000c80043fULL, 0x000000ffff067224ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x002fc400078e0003ULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x018b8c00ff047984ULL, 0x004e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000704047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x018b8c00ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001ff0000780cULL, 0x000fe20003f04070ULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x0000000604047899ULL, 0x000fd4000800063fULL,
0x000004f000000947ULL, 0x000fea0003800000ULL, 0x0000000000137919ULL, 0x000e620000000000ULL,
0x0000000560007c17ULL, 0x000fe2000f800000ULL, 0x00000100ff117424ULL, 0x000fc600078e00ffULL,
0x8000000500007c10ULL, 0x000fe4000fffe0ffULL, 0x00000004ff077819ULL, 0x002fe20000011613ULL,
0x00000010130f7824ULL, 0x000fc600078e00ffULL, 0x0000000507067c10ULL, 0x000fe4000fffe0ffULL,
0x000000f00f0f7812ULL, 0x000fe400078ec0ffULL, 0x000000000700720cULL, 0x000fe20003f06070ULL,
0x018a000006047984ULL, 0x000e620000004800ULL, 0x0000004035097824ULL, 0x000fe400078e0206ULL,
0x0000000106057824ULL, 0x040fe400078e0213ULL, 0x0000001006087824ULL, 0x000fe200078e00ffULL,
0x00000002090d7810ULL, 0x000fe20007ffe0ffULL, 0x018ac00004047984ULL, 0x002e640000004800ULL,
0x0000000404027c24ULL, 0x002fc8000f8e0209ULL, 0x00005e0002027625ULL, 0x000fca00078e0011ULL,
0x0000000f02047210ULL, 0x000fe40007f3e0ffULL, 0xfffffff008027812ULL, 0x000fc600078ee205ULL,
0x000000ffff057224ULL, 0x000fe200008e0603ULL, 0x00014000020b7811ULL, 0x000fe400078e20ffULL,
0x0000000207037810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e2000c101c4aULL, 0x0000000503087c10ULL, 0x040fe4000fffe0ffULL,
0x000000000300720cULL, 0x000fe20003f06070ULL, 0x018a0800060a7984ULL, 0x000ea40000004800ULL,
0x00000001080c7824ULL, 0x000fe400078e0213ULL, 0x018ac0000a0a7984ULL, 0x004ea40000004800ULL,
0x000000040a027c24ULL, 0x004fc4000f8e020dULL, 0x00000010080d7824ULL, 0x000fe400078e00ffULL,
0x00005e0002027625ULL, 0x000fc600078e0011ULL, 0xfffffff00d0c7812ULL, 0x000fe400078ee20cULL,
0x0000000f02047210ULL, 0x002fe40007f3e0ffULL, 0x000140000c0b7811ULL, 0x000fe400078e20ffULL,
0x00000004090d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff057224ULL, 0x000fe200008e0603ULL,
0x0000000407037810ULL, 0x000fe40007ffe0ffULL, 0x0000000609097810ULL, 0x000fc40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e2000c101c4aULL,
0x0000000503087c10ULL, 0x040fe4000fffe0ffULL, 0x000000000300720cULL, 0x000fe20003f06070ULL,
0x018a1000060a7984ULL, 0x000ea20000004800ULL, 0x0000000607077810ULL, 0x000fe20007ffe0ffULL,
0x00000001080c7824ULL, 0x000fe400078e0213ULL, 0x018ac0000a0a7984ULL, 0x004ea40000004800ULL,
0x000000040a027c24ULL, 0x004fc4000f8e020dULL, 0x00000010080d7824ULL, 0x000fe200078e00ffULL,
0x0000000507087c10ULL, 0x000fe2000fffe0ffULL, 0x00005e0002027625ULL, 0x000fc600078e0011ULL,
0xfffffff00d0c7812ULL, 0x000fe400078ee20cULL, 0x0000000f02047210ULL, 0x002fe40007f3e0ffULL,
0x000140000c0b7811ULL, 0x000fc600078e20ffULL, 0x000000ffff057224ULL, 0x000fca00008e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e2000c101c4aULL,
0x000000000700720cULL, 0x000fe20003f06070ULL, 0x0000000108007824ULL, 0x040fe400078e0213ULL,
0x018a180006067984ULL, 0x000ea20000004800ULL, 0x0000001008077824ULL, 0x000fca00078e00ffULL,
0xfffffff007007812ULL, 0x000fc800078ee200ULL, 0x0001400000057811ULL, 0x002fe200078e20ffULL,
0x018ac00006027984ULL, 0x004e640000004800ULL, 0x0000000402027c24ULL, 0x002fc8000f8e0209ULL,
0x00005e0002027625ULL, 0x000fca00078e0011ULL, 0x0000000f02027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c101c4aULL, 0x0000044000007947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x000e620000000000ULL, 0x00000100ff0a7424ULL, 0x000fe200078e00ffULL,
0x000000050d007c11ULL, 0x042fe2000f8fe0ffULL, 0x000000100d037824ULL, 0x000fc800078e00ffULL,
0x018a000000067984ULL, 0x000e620000004800ULL, 0x0000004035097824ULL, 0x000fe200078e0200ULL,
0x000000f0030f7812ULL, 0x000fe200078ec0ffULL, 0x0000000100057824ULL, 0x040fe400078e020dULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x018ac00006067984ULL, 0x002e640000004800ULL,
0x0000000406027c24ULL, 0x002fe2000f8e0209ULL, 0x0000000200067810ULL, 0x000fc60007ffe0ffULL,
0x00005e0002027625ULL, 0x000fc800078e000aULL, 0x0000000106077824ULL, 0x000fe200078e020dULL,
0x0000000f02047210ULL, 0x000fe20007f1e0ffULL, 0x00000010060c7824ULL, 0x000fe200078e00ffULL,
0xfffffff008027812ULL, 0x000fc600078ee205ULL, 0x000000ffff057224ULL, 0x000fe200000e0603ULL,
0x00014000020b7811ULL, 0x000fe400078e20ffULL, 0x0000000209037810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e8000b901c4aULL,
0x018a080000087984ULL, 0x000ea20000004800ULL, 0x0000000400047810ULL, 0x002fca0007ffe0ffULL,
0x0000000104057824ULL, 0x000fe200078e020dULL, 0x018ac00008087984ULL, 0x004e640000004800ULL,
0x0000000408037c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0003027625ULL, 0x000fca00078e000aULL,
0x0000000f02067210ULL, 0x000fe40007f1e0ffULL, 0xfffffff00c027812ULL, 0x000fe200078ee207ULL,
0x00000010040c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe200000e0603ULL,
0x00014000020b7811ULL, 0x000fe400078e20ffULL, 0x0000000409037810ULL, 0x040fe40007ffe0ffULL,
0x0000000609097810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060b7faeULL, 0x0003e8000b901c4aULL, 0x018a100000087984ULL, 0x000ea20000004800ULL,
0x0000000600067810ULL, 0x002fc60007ffe0ffULL, 0x018ac00008087984ULL, 0x004e640000004800ULL,
0x0000000408037c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0003027625ULL, 0x000fca00078e000aULL,
0x0000000f02047210ULL, 0x000fe40007f1e0ffULL, 0xfffffff00c027812ULL, 0x000fc600078ee205ULL,
0x000000ffff057224ULL, 0x000fe200000e0603ULL, 0x0001400002077811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000b901c4aULL,
0x018a180000087984ULL, 0x000ea80000004800ULL, 0x018ac00008087984ULL, 0x004ea40000004800ULL,
0x0000000408027c24ULL, 0x004fc4000f8e0209ULL, 0x0000000106097824ULL, 0x000fe400078e020dULL,
0x00005e0002027625ULL, 0x000fc800078e000aULL, 0x0000001006067824ULL, 0x000fe200078e00ffULL,
0x0000000f02027210ULL, 0x000fc80007f1e0ffULL, 0xfffffff006097812ULL, 0x000fe200078ee209ULL,
0x000000ffff037224ULL, 0x000fc600000e0603ULL, 0x0001400009097811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e4000b901c4aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff027f8cULL, 0x002e64000c80043fULL,
0x000000ffff097224ULL, 0x002fc400078e0003ULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x018b8c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000700007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x018b8c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000327919ULL, 0x000e620000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000002033007824ULL, 0x002fca00078e0232ULL, 0x0000001f0000780cULL, 0x000fda0003f04070ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000000cff057e24ULL, 0x000fe2000f8e00ffULL,
0x0000002000037810ULL, 0x000fc60007ffe0ffULL, 0x0000680005027a24ULL, 0x000fe200078e0200ULL,
0x000000600300720cULL, 0x000fe20003f06070ULL, 0x00000004ff037424ULL, 0x000fe200078e00ffULL,
0x00018a0000057811ULL, 0x000fe400078e10ffULL, 0x0000002002027810ULL, 0x000fca0007ffe0ffULL,
0x0000660002027625ULL, 0x000fca00078e0003ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e4000c12184aULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b7800ff027f8cULL, 0x002e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000ff3600720cULL, 0x000fe20003f05270ULL, 0x018b8800ff047f8cULL, 0x000ea2000c80043fULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x0001d4c000008947ULL, 0x000fea0003800000ULL,
0x00005800ff0d7624ULL, 0x000fe200078e00ffULL, 0x0001d4a000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6b7224ULL, 0x002fe200078e0003ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3c7224ULL, 0x004fc400078e0005ULL, 0xff317217ff107424ULL, 0x000fe400078e00ffULL,
0x000000ffff317224ULL, 0x000fe400078e00ffULL, 0x000000400d0d7824ULL, 0x000fc400078e00ffULL,
0x000001000f037824ULL, 0x000fca00078e00ffULL, 0x000000600300720cULL, 0x000fda0003f06070ULL,
0x0001d3c000000947ULL, 0x000fea0003800000ULL, 0x000000ffff6a7224ULL, 0x000fc600078e00ffULL,
0x0000000f3400720cULL, 0x000fe20003fa4070ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x00000002ff037819ULL, 0x000fe2000001166aULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x000000036a027812ULL, 0x040fe400078ec0ffULL, 0x000000036a007207ULL, 0x000fe40002800000ULL,
0x000000ff02387207ULL, 0x000fe40006800000ULL, 0x00000003003b7812ULL, 0x000fc400078ec0ffULL,
0x0000000f003d7211ULL, 0x000fc400078ff0ffULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x018b7c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b7c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x018b8c00ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000700007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000013d037810ULL, 0x000fe20007ffe0ffULL, 0x000009a000017945ULL, 0x000fe60003800000ULL,
0x000000360300720cULL, 0x000fda0003f06070ULL, 0x0000053000008947ULL, 0x000fea0003800000ULL,
0x00000004ff397819ULL, 0x100fe20000011632ULL, 0x000000043d037824ULL, 0x000fe200078e023bULL,
0x0000002035067811ULL, 0x000fe200078e30ffULL, 0x0000001032047824ULL, 0x000fe200078e00ffULL,
0x00000005393f7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff417424ULL, 0x000fe200078e00ffULL,
0x0000002003037811ULL, 0x000fe400078e30ffULL, 0x000000f004437812ULL, 0x000fe200078ec0ffULL,
0x018a00003f027984ULL, 0x000e620000004800ULL, 0x0000000360007217ULL, 0x000fe20007800000ULL,
0x000000013f057824ULL, 0x000fe200078e0232ULL, 0x0000000239457810ULL, 0x000fe20007ffe0ffULL,
0x000000103f0c7824ULL, 0x000fc400078e00ffULL, 0x0000000100007824ULL, 0x000fe200078e0a03ULL,
0x0000000545477c10ULL, 0x000fe2000fffe0ffULL, 0x000000013f037824ULL, 0x000fe200078e0206ULL,
0xfffffff00c077812ULL, 0x000fe400078ee205ULL, 0x0000000500007c17ULL, 0x000fe2000f800000ULL,
0x00000001473a7824ULL, 0x000fe200078e0232ULL, 0x0001600007077811ULL, 0x000fe400078e20ffULL,
0x8000000500007c10ULL, 0x000fc8000fffe0ffULL, 0x000000003900720cULL, 0x000fe20003f06070ULL,
0x018ac00002027984ULL, 0x002e640000004800ULL, 0x000000020d037224ULL, 0x002fc800078e0203ULL,
0x00005e0003027625ULL, 0x000fca00078e0041ULL, 0x0000004302047210ULL, 0x000fe20007f3e0ffULL,
0x0000000147027824ULL, 0x040fe400078e0206ULL, 0x0000001047477824ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fca00008e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000c101c4aULL, 0x000000004500720cULL, 0x000fe40003f06070ULL,
0x0000000439457810ULL, 0x040fe20007ffe0ffULL, 0x018a08003f0c7984ULL, 0x000ea20000004800ULL,
0x0000000639397810ULL, 0x000fe40007ffe0ffULL, 0xfffffff047077812ULL, 0x002fe400078ee23aULL,
0x0000000545477c10ULL, 0x000fe4000fffe0ffULL, 0x0001600007077811ULL, 0x000fc600078e20ffULL,
0x00000001473a7824ULL, 0x000fe200078e0232ULL, 0x018ac0000c0c7984ULL, 0x004e640000004800ULL,
0x0000000c0d027224ULL, 0x002fc800078e0202ULL, 0x00005e0002027625ULL, 0x000fca00078e0041ULL,
0x0000004302047210ULL, 0x000fe20007f3e0ffULL, 0x0000000147027824ULL, 0x040fe400078e0206ULL,
0x0000001047477824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fca00008e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e2000c101c4aULL,
0x000000004500720cULL, 0x000fe40003f06070ULL, 0x0000000539457c10ULL, 0x000fe2000fffe0ffULL,
0x018a10003f0c7984ULL, 0x000ea80000004800ULL, 0x0000000145067824ULL, 0x000fe200078e0206ULL,
0xfffffff047077812ULL, 0x002fc800078ee23aULL, 0x0001600007077811ULL, 0x000fe200078e20ffULL,
0x018ac0000c0c7984ULL, 0x004e640000004800ULL, 0x0000000c0d027224ULL, 0x002fc800078e0202ULL,
0x00005e0002027625ULL, 0x000fca00078e0041ULL, 0x0000004302047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000c101c4aULL, 0x000000003900720cULL, 0x000fc60003f06070ULL,
0x018a18003f0c7984ULL, 0x000ea80000004800ULL, 0x018ac0000c0c7984ULL, 0x004ea40000004800ULL,
0x0000000c0d027224ULL, 0x004fe400078e0206ULL, 0x0000000145067824ULL, 0x000fe400078e0232ULL,
0x00005e0002027625ULL, 0x000fc800078e0041ULL, 0x0000001045457824ULL, 0x000fe200078e00ffULL,
0x0000004302027210ULL, 0x000fc80007f3e0ffULL, 0xfffffff045057812ULL, 0x002fe200078ee206ULL,
0x000000ffff037224ULL, 0x000fc600008e0603ULL, 0x0001600005057811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e2000c101c4aULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x00000005323f7c11ULL, 0x040fe2000f8fe0ffULL,
0x0000001032037824ULL, 0x000fe200078e00ffULL, 0x00000020350c7811ULL, 0x000fe200078e30ffULL,
0x00000100ff417424ULL, 0x000fe200078e00ffULL, 0x000000023f077810ULL, 0x000fe20007ffe0ffULL,
0x018a00003f007984ULL, 0x000e620000004800ULL, 0x000000f003437812ULL, 0x000fe200078ec0ffULL,
0x000000013f027824ULL, 0x040fe400078e020cULL, 0x000000013f057824ULL, 0x000fc400078e0232ULL,
0x000000103f067824ULL, 0x000fe400078e00ffULL, 0x00000001073a7824ULL, 0x000fc600078e0232ULL,
0xfffffff006397812ULL, 0x000fc800078ee205ULL, 0x0001600039397811ULL, 0x000fe200078e20ffULL,
0x018ac00000007984ULL, 0x002e640000004800ULL, 0x000000000d027224ULL, 0x002fc800078e0202ULL,
0x00005e0002027625ULL, 0x000fca00078e0041ULL, 0x0000004302047210ULL, 0x000fe20007f1e0ffULL,
0x0000000107027824ULL, 0x040fe400078e020cULL, 0x0000001007077824ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fc600000e0603ULL, 0xfffffff0073a7812ULL, 0x000fe400078ee23aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004397faeULL, 0x0003e8000b901c4aULL,
0x018a08003f007984ULL, 0x000ea20000004800ULL, 0x000160003a397811ULL, 0x002fe400078e20ffULL,
0x000000043f057810ULL, 0x000fca0007ffe0ffULL, 0x00000001053a7824ULL, 0x000fe200078e0232ULL,
0x018ac00000007984ULL, 0x004e640000004800ULL, 0x000000000d027224ULL, 0x002fc800078e0202ULL,
0x00005e0002027625ULL, 0x000fca00078e0041ULL, 0x0000004302067210ULL, 0x000fe20007f1e0ffULL,
0x0000000105027824ULL, 0x040fe400078e020cULL, 0x0000001005057824ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fc600000e0603ULL, 0xfffffff0053a7812ULL, 0x000fe400078ee23aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006397faeULL, 0x0003e8000b901c4aULL,
0x018a10003f007984ULL, 0x000ea20000004800ULL, 0x000160003a077811ULL, 0x002fe400078e20ffULL,
0x000000063f397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139067824ULL, 0x000fe200078e0232ULL,
0x018ac00000007984ULL, 0x004e640000004800ULL, 0x000000000d027224ULL, 0x002fc800078e0202ULL,
0x00005e0002027625ULL, 0x000fca00078e0041ULL, 0x0000004302047210ULL, 0x000fe20007f1e0ffULL,
0x0000000139027824ULL, 0x040fe400078e020cULL, 0x0000001039397824ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fc600000e0603ULL, 0xfffffff039067812ULL, 0x000fe400078ee206ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000b901c4aULL,
0x018a18003f007984ULL, 0x000ea20000004800ULL, 0x0001600006057811ULL, 0x002fc600078e20ffULL,
0x018ac00000007984ULL, 0x004e640000004800ULL, 0x000000000d027224ULL, 0x002fc800078e0202ULL,
0x00005e0002027625ULL, 0x000fca00078e0041ULL, 0x0000004302027210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff037224ULL, 0x000fca00000e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e6000b901c4aULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff027f8cULL, 0x002e64000c80043fULL,
0x000000ffff397224ULL, 0x002fc400078e0003ULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x018b8c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804839ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000700007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000003d3400720cULL, 0x000fe20003f04070ULL, 0x00000020330c7824ULL, 0x000fe200078e0232ULL,
0x0000000138007810ULL, 0x040fe20007ffe0ffULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000033800780cULL, 0x000fe40003f45270ULL, 0x0000000300027812ULL, 0x000fc400078ec0ffULL,
0x0000003d3400720cULL, 0x000fe40003f24070ULL, 0x0000001f0c00780cULL, 0x000fe40003f84070ULL,
0x000000ff02047207ULL, 0x000fe40004000000ULL, 0x00000002ff008819ULL, 0x000fca0000011600ULL,
0x000000013b007824ULL, 0x000fc800078e0200ULL, 0x0000004000037824ULL, 0x040fe200078e00ffULL,
0x0000003d00007211ULL, 0x000fc800078ff0ffULL, 0x000000c003037812ULL, 0x000fca00078ec0ffULL,
0x0000010000077824ULL, 0x000fe200078e0203ULL, 0x0000011000009947ULL, 0x000fea0001000000ULL,
0x0000002033027824ULL, 0x000fe200078e0232ULL, 0x000000010e0e7810ULL, 0x000fc80007ffe0ffULL,
0x000000030200780cULL, 0x000fda0003f04070ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000002700ULL, 0x000064000e007a10ULL, 0x040fe20007ffe0ffULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0x000000370e00720cULL, 0x000fe40003f06070ULL,
0x00018ac002397811ULL, 0x000fe200078e10ffULL, 0x0000000403037824ULL, 0x002fc800078e0202ULL,
0x0000000203037824ULL, 0x000fc800078e00ffULL, 0x0000640003007a24ULL, 0x000fc800078e0200ULL,
0x0000600000027625ULL, 0x000fca00078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002397faeULL, 0x0003e4000c12184aULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000e000017945ULL, 0x000fe20003800000ULL, 0x000000c000004947ULL, 0x000fea0003800000ULL,
0x0000000c04007c10ULL, 0x000fe2000fffe0ffULL, 0x000000010c057824ULL, 0x100fe400078e0207ULL,
0x00000004ff027424ULL, 0x002fe400078e00ffULL, 0x0000680000037a24ULL, 0x000fe200078e0207ULL,
0x000000600500720cULL, 0x000fe40003f06070ULL, 0x00018a000c057811ULL, 0x040fe200078e10ffULL,
0x000000010c037824ULL, 0x000fc800078e0203ULL, 0x0000660003027625ULL, 0x000fcc00078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e4000c12184aULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x018b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff6a00720cULL, 0x000fe20003f05270ULL,
0x018b8000ff647f8cULL, 0x000ea2000c80043fULL, 0x000007f000017945ULL, 0x000ff60003800000ULL,
0x000007d000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018ad800ff027f8cULL, 0x002e64000c800405ULL, 0x000000ffff0b7224ULL, 0x002fc400078e0003ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x018adc05ff007984ULL, 0x000e640008000800ULL,
0x8000000000ff7812ULL, 0x002fc4000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x018adc05ff007984ULL, 0x000e640008000800ULL, 0x8000000000ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001032007824ULL, 0x000fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011632ULL, 0x0000007000007812ULL, 0x000fe400078ec0ffULL,
0x0000000c02037812ULL, 0x000fca00078ec0ffULL, 0x0000000100007824ULL, 0x000fca00078e0203ULL,
0x0180000000037984ULL, 0x000e680000000800ULL, 0x0182000000027984ULL, 0x0006a20000000800ULL,
0x000000100300720bULL, 0x002fe20003f1d000ULL, 0x000257a27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000047806ULL, 0x008fc800000e0100ULL, 0x0000ffff04077812ULL, 0x000fe2000780c0ffULL,
0x0000045000027945ULL, 0x000fe20003800000ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fd200078e0010ULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x00000008ff007c0cULL, 0x000fe4000bf05270ULL, 0x000000100300720bULL, 0x000fe20003f34000ULL,
0x000257727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000047806ULL, 0x000fc400008e0100ULL,
0x0000000310057209ULL, 0x000fe20007810000ULL, 0x0000035000037945ULL, 0x000fe20003800000ULL,
0x0000991004067816ULL, 0x000fc600000000ffULL, 0x0184000500008388ULL, 0x0003e20000000800ULL,
0x000000ff0600720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000000510007221ULL, 0x002fe20000010000ULL, 0x000000ff04ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b00007820ULL, 0x000fc80000410000ULL,
0x00000000003b7308ULL, 0x000e640000000800ULL, 0x0000003b11117220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff007819ULL, 0x000fe20000011632ULL,
0x000256d27f007947ULL, 0x000fea000b800000ULL, 0x00001f003b007589ULL, 0x0002e400000e0000ULL,
0x0000000012127220ULL, 0x088fe40000410000ULL, 0x0000000013137220ULL, 0x080fe40000410000ULL,
0x0000000016167220ULL, 0x080fe40000410000ULL, 0x0000000017177220ULL, 0x080fe40000410000ULL,
0x000000001a1a7220ULL, 0x080fe40000410000ULL, 0x000000001b1b7220ULL, 0x000fc40000410000ULL,
0x000000001e1e7220ULL, 0x080fe40000410000ULL, 0x000000001f1f7220ULL, 0x080fe40000410000ULL,
0x0000000022227220ULL, 0x080fe40000410000ULL, 0x0000000023237220ULL, 0x080fe40000410000ULL,
0x0000000026267220ULL, 0x080fe40000410000ULL, 0x0000000027277220ULL, 0x000fc40000410000ULL,
0x000000002a2a7220ULL, 0x080fe40000410000ULL, 0x000000002b2b7220ULL, 0x080fe40000410000ULL,
0x000000002e2e7220ULL, 0x080fe40000410000ULL, 0x000000002f2f7220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0004ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000832007811ULL, 0x000fe200078ff0ffULL,
0x000255f27f007947ULL, 0x000fea000b800000ULL, 0x00001f003b007589ULL, 0x00066400000e0000ULL,
0x0000000014147220ULL, 0x082fe40000410000ULL, 0x0000000015157220ULL, 0x080fe40000410000ULL,
0x0000000018187220ULL, 0x080fe40000410000ULL, 0x0000000019197220ULL, 0x080fe40000410000ULL,
0x000000001c1c7220ULL, 0x080fe40000410000ULL, 0x000000001d1d7220ULL, 0x000fc40000410000ULL,
0x0000000020207220ULL, 0x080fe40000410000ULL, 0x0000000021217220ULL, 0x080fe40000410000ULL,
0x0000000024247220ULL, 0x080fe40000410000ULL, 0x0000000025257220ULL, 0x080fe40000410000ULL,
0x0000000028287220ULL, 0x080fe40000410000ULL, 0x0000000029297220ULL, 0x000fc40000410000ULL,
0x000000002c2c7220ULL, 0x080fe40000410000ULL, 0x000000002d2d7220ULL, 0x080fe40000410000ULL,
0x0000000030307220ULL, 0x080fe40000410000ULL, 0x0000000031317220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff07ff7812ULL, 0x000fda0007806004ULL,
0x8000000503030221ULL, 0x000fe20000010000ULL, 0x00007610ff0b0816ULL, 0x000fc6000000000bULL,
0x3fb8aa3b03030820ULL, 0x000fc80000410000ULL, 0x00000003000a0308ULL, 0x000e640000000800ULL,
0x0000000a02020220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001102117221ULL, 0x004fe40000010000ULL, 0x000000ffff107224ULL, 0x000fc400078e0005ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff0bff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000017945ULL, 0x000fd80003800000ULL, 0x0000016000001947ULL, 0x000fea0003800000ULL,
0x0000000aff00723eULL, 0x000fe400000010ffULL, 0x00000002ff037819ULL, 0x002fe40000011632ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x000254427f007947ULL, 0x000fea000b800000ULL,
0x00001f0300097589ULL, 0x0002e400000e0000ULL, 0x0000000803087810ULL, 0x000fe20007ffe0ffULL,
0x000254927f007947ULL, 0x000fea000b800000ULL, 0x00001f0800087589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010033f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0000ULL, 0x00003a3000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0002672000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000018033f7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3e7224ULL, 0x004fe200078e0000ULL,
0x00003aa000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff407424ULL, 0x000fc400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000266b000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000832037812ULL, 0x002fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff077819ULL, 0x100fe20000011632ULL,
0x0000000208047891ULL, 0x000fe2000f8e103fULL, 0x00000007035c7812ULL, 0x000fe200078ef832ULL,
0x0000205000017945ULL, 0x000fe40003800000ULL, 0x00000004335f7824ULL, 0x000fe200078e0207ULL,
0x000000105c387812ULL, 0x040fe200078efcffULL, 0x000000105c037824ULL, 0x040fe200078e00ffULL,
0x00000004075d7c10ULL, 0x000fe2000fffe0ffULL, 0x000000015c007824ULL, 0x000fe200078e025fULL,
0x0000000438637c10ULL, 0x000fe2000fffe007ULL, 0x000000015f647824ULL, 0x004fc600078e0238ULL,
0xfffffff003007812ULL, 0x000fc800078ee200ULL, 0x0001400000067811ULL, 0x000fe200078e20ffULL,
0x000000015c007824ULL, 0x000fc800078e025dULL, 0x00000000063c783bULL, 0x000e620000004200ULL,
0xfffffff003007812ULL, 0x000fe200078ee200ULL, 0x0000001038037824ULL, 0x040fe400078e00ffULL,
0x0000001038387824ULL, 0x000fe200078e00ffULL, 0x0001400000057811ULL, 0x000fe400078e20ffULL,
0xfffffff003647812ULL, 0x000fe400078ee264ULL, 0xfffffff038637812ULL, 0x000fe200078ee263ULL,
0x000000000540783bULL, 0x000ea20000004200ULL, 0x0001400064047811ULL, 0x000fc400078e20ffULL,
0x0001400063037811ULL, 0x000fc600078e20ffULL, 0x000000000444783bULL, 0x000f280000004200ULL,
0x000000000338783bULL, 0x008ee20000004200ULL, 0x00000018ff027819ULL, 0x002fe2000001143cULL,
0x0000003c00837306ULL, 0x000fe20000009400ULL, 0x00000018ff4a7819ULL, 0x000fe2000001143fULL,
0x000001003d4b7824ULL, 0x040fe200078e00ffULL, 0x00000018ff007819ULL, 0x000fe2000001143dULL,
0x000100003d4c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000000200ac7306ULL, 0x000fe20000209400ULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000010040817824ULL, 0x004fca00078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011481ULL,
0x0000000200b77306ULL, 0x000e620000205400ULL, 0x00000018ff537819ULL, 0x010fe40000011444ULL,
0x00000018ff827819ULL, 0x008fe40000011439ULL, 0x00000018ff617819ULL, 0x000fe40000011446ULL,
0x00000018ff757819ULL, 0x000fe20000011438ULL, 0x0000004a00a87306ULL, 0x000fe20000209400ULL,
0x00000018ff857819ULL, 0x000fc4000001143bULL, 0x00000018ff5e7819ULL, 0x000fe40000011445ULL,
0x00000018ff737819ULL, 0x000fe40000011447ULL, 0x00000018ff847819ULL, 0x000fe2000001143aULL,
0x0000004a00b37306ULL, 0x000fe20000205400ULL, 0x000000b7ac00720bULL, 0x002fe20003f5d000ULL,
0x0000010047ac7824ULL, 0x000fca00078e00ffULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x0000004a005a7306ULL, 0x0003f0000020d400ULL, 0x0000003c00b47306ULL, 0x000ea20000005400ULL,
0x000001003c4a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000003c00a47306ULL, 0x0002f0000000d400ULL, 0x0000004a00b87306ULL, 0x000fe20000209400ULL,
0x000100003c3c7824ULL, 0x002fe200078e00ffULL, 0x000000b48300720bULL, 0x004fc80003f7d000ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000004a00bf7306ULL, 0x000e6e0000205400ULL,
0x00000001a4a43812ULL, 0x008fe200078efcffULL, 0x00000002009c7306ULL, 0x0004f0000020d400ULL,
0x0000000000bb7306ULL, 0x000fe20000209400ULL, 0x00000018ff027819ULL, 0x004fc4000001143eULL,
0x000000bfb800720bULL, 0x002fca0003fdd000ULL, 0x0000000000b27306ULL, 0x000e620000205400ULL,
0x000000019c9c2812ULL, 0x008fce00078efcffULL, 0x0000003c00ba7306ULL, 0x000ff00000209400ULL,
0x0000003c00c17306ULL, 0x000ea20000205400ULL, 0x000000b2bb00720bULL, 0x002fce0003f5d000ULL,
0x0000004a00a57306ULL, 0x0002f0000020d400ULL, 0x0000004b00c37306ULL, 0x000fe20000209400ULL,
0x000001003e4a7824ULL, 0x002fe200078e00ffULL, 0x000000c1ba00720bULL, 0x004fc80003f1d000ULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000004b00bc7306ULL, 0x000e620000205400ULL,
0x00000001a5a56812ULL, 0x008fce00078efcffULL, 0x0000000000987306ULL, 0x000eb0000020d400ULL,
0x0000000200b07306ULL, 0x000fe20000209400ULL, 0x000000bcc300720bULL, 0x002fce0003fdd000ULL,
0x0000000200b97306ULL, 0x000e620000205400ULL, 0x0000000198982812ULL, 0x004fce00078efcffULL,
0x0000003d00b57306ULL, 0x000ff00000009400ULL, 0x0000003d008a7306ULL, 0x000ea20000005400ULL,
0x000000b9b000720bULL, 0x002fce0003f5d000ULL, 0x0000003c009d7306ULL, 0x0002f0000020d400ULL,
0x0000004c00c77306ULL, 0x000fe20000209400ULL, 0x000001003f3c7824ULL, 0x002fe200078e00ffULL,
0x0000008ab500720bULL, 0x004fc80003f7d000ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004c00c07306ULL, 0x000e620000205400ULL, 0x000000019d9d0812ULL, 0x008fce00078efcffULL,
0x0000003d009e7306ULL, 0x000eb0000000d400ULL, 0x0000004b003d7306ULL, 0x000722000020d400ULL,
0x000000c0c700720bULL, 0x002fce0003f1d000ULL, 0x0000003e00947306ULL, 0x000fe20000009400ULL,
0x000000019e9e3812ULL, 0x004fe400078efcffULL, 0x00000018ff4b7819ULL, 0x008fca0000011442ULL,
0x0000003e00af7306ULL, 0x000e620000005400ULL, 0x000000013d3d6812ULL, 0x010fc800078efcffULL,
0x0000009e3d3d723eULL, 0x000fc600000010ffULL, 0x0000003e00587306ULL, 0x0004f0000000d400ULL,
0x0000004a00c97306ULL, 0x000fe20000209400ULL, 0x000100003e3e7824ULL, 0x004fe200078e00ffULL,
0x000000af9400720bULL, 0x002fc80003f7d000ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000004a00c27306ULL, 0x000e6e0000205400ULL, 0x0000000158583812ULL, 0x008fe200078efcffULL,
0x00000002005b7306ULL, 0x000eb0000020d400ULL, 0x0000004c009b7306ULL, 0x000ee2000020d400ULL,
0x000000c2c900720bULL, 0x002fce0003fdd000ULL, 0x0000003e00c47306ULL, 0x000fe20000209400ULL,
0x000000015b5b2812ULL, 0x004fe400078efcffULL, 0x000000b3a800720bULL, 0x000fca0003f5d000ULL,
0x0000003e00cb7306ULL, 0x000e620000205400ULL, 0x000000019b9b0812ULL, 0x008fce00078efcffULL,
0x0000004a00997306ULL, 0x0004e2000020d400ULL, 0x000000015a5a2812ULL, 0x000fce00078efcffULL,
0x0000003f00937306ULL, 0x000fe20000009400ULL, 0x00000018ff4a7819ULL, 0x004fe40000011440ULL,
0x000000cbc400720bULL, 0x002fca0003f1d000ULL, 0x0000003f00567306ULL, 0x000e620000005400ULL,
0x0000000199996812ULL, 0x008fc800078efcffULL, 0x000000589958723eULL, 0x000fc600000010ffULL,
0x0000003f00597306ULL, 0x0004f0000000d400ULL, 0x0000003c00cd7306ULL, 0x000fe20000209400ULL,
0x000100003f3f7824ULL, 0x004fe200078e00ffULL, 0x000000569300720bULL, 0x002fc80003f7d000ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000003c00c67306ULL, 0x000e6e0000205400ULL,
0x0000000159593812ULL, 0x008fe200078efcffULL, 0x0000004a00ca7306ULL, 0x000ff00000209400ULL,
0x0000004a00d17306ULL, 0x000ea20000205400ULL, 0x000000c6cd00720bULL, 0x002fce0003fdd000ULL,
0x0000003e00967306ULL, 0x0002f0000020d400ULL, 0x0000003f00d37306ULL, 0x000fe20000209400ULL,
0x00000018ff3e7819ULL, 0x002fe40000011441ULL, 0x000000d1ca00720bULL, 0x004fca0003f5d000ULL,
0x0000003f00cc7306ULL, 0x000e620000205400ULL, 0x0000000196960812ULL, 0x008fce00078efcffULL,
0x0000003c009a7306ULL, 0x000eb0000020d400ULL, 0x00000040006c7306ULL, 0x000fe20000009400ULL,
0x000000ccd300720bULL, 0x002fce0003f1d000ULL, 0x0000004000b17306ULL, 0x000e620000005400ULL,
0x000000019a9a6812ULL, 0x004fc800078efcffULL, 0x000000599a59723eULL, 0x000fc600000010ffULL,
0x0000004000487306ULL, 0x0004f0000000d400ULL, 0x0000008100d57306ULL, 0x000fe20000209400ULL,
0x0001000040407824ULL, 0x004fe200078e00ffULL, 0x000000b16c00720bULL, 0x002fe20003f7d000ULL,
0x00000100386c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000008100ce7306ULL, 0x000e6e0000205400ULL, 0x0000000148483812ULL, 0x008fe200078efcffULL,
0x0000004a004c7306ULL, 0x000eb0000020d400ULL, 0x0000003e00c87306ULL, 0x000fe20000209400ULL,
0x000000ced500720bULL, 0x002fce0003fdd000ULL, 0x0000003e00cf7306ULL, 0x000e620000205400ULL,
0x000000014c4c2812ULL, 0x004fce00078efcffULL, 0x00000082007e7306ULL, 0x000ff00000209400ULL,
0x00000082007f7306ULL, 0x000fe20000205400ULL, 0x000000cfc800720bULL, 0x002fce0003f5d000ULL,
0x0000008200697306ULL, 0x0003f0000020d400ULL, 0x0000003f00977306ULL, 0x0004e2000020d400ULL,
0x0000010041827824ULL, 0x002fca00078e00ffULL, 0x00000018ff827819ULL, 0x000fe40000011482ULL,
0x0000004000d97306ULL, 0x000fe20000209400ULL, 0x00000018ff3f7819ULL, 0x004fce0000011443ULL,
0x0000004000d07306ULL, 0x000e620000205400ULL, 0x0000000197970812ULL, 0x008fce00078efcffULL,
0x0000008100957306ULL, 0x0004f0000020d400ULL, 0x0000004100677306ULL, 0x000fe20000009400ULL,
0x000000d0d900720bULL, 0x002fe20003f1d000ULL, 0x0000010042817824ULL, 0x004fca00078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000004100547306ULL, 0x000e620000005400ULL,
0x0000000195956812ULL, 0x008fc800078efcffULL, 0x000000489548723eULL, 0x000fc600000010ffULL,
0x0000004100497306ULL, 0x0004f0000000d400ULL, 0x0000008200db7306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x004fe200078e00ffULL, 0x000000546700720bULL, 0x002fc40003f7d000ULL,
0x0000000732677812ULL, 0x000fe400078ec0ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000008200d47306ULL, 0x000e6e0000205400ULL, 0x0000000149493812ULL, 0x008fe200078efcffULL,
0x0000003e004d7306ULL, 0x000eb0000020d400ULL, 0x0000004b00be7306ULL, 0x000fe20000209400ULL,
0x000000d4db00720bULL, 0x002fce0003fdd000ULL, 0x0000004b00c57306ULL, 0x000e620000205400ULL,
0x000000014d4d2812ULL, 0x004fce00078efcffULL, 0x00000040008f7306ULL, 0x0004f0000020d400ULL,
0x0000004300007306ULL, 0x000fe20000009400ULL, 0x0000010043407824ULL, 0x004fe200078e00ffULL,
0x000000c5be00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000004300557306ULL, 0x000fe20000005400ULL, 0x000000018f8f0812ULL, 0x008fc800078efcffULL,
0x0000008f4c4c723eULL, 0x000fc600000010ffULL, 0x0000004300517306ULL, 0x0003f0000000d400ULL,
0x0000004100e37306ULL, 0x000fe20000209400ULL, 0x0001000043437824ULL, 0x002fca00078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000004100da7306ULL, 0x000e700000205400ULL,
0x0000008200927306ULL, 0x000eb0000020d400ULL, 0x0000004200577306ULL, 0x000fe20000009400ULL,
0x000000dae300720bULL, 0x002fce0003f1d000ULL, 0x0000004200027306ULL, 0x000e620000005400ULL,
0x0000000192926812ULL, 0x004fc800078efcffULL, 0x000000499249723eULL, 0x000fc600000010ffULL,
0x0000004200887306ULL, 0x0004f0000000d400ULL, 0x0000004b00527306ULL, 0x000f22000020d400ULL,
0x0001000042427824ULL, 0x004fe200078e00ffULL, 0x000000025700720bULL, 0x002fc80003fdd000ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x0000004300d77306ULL, 0x000fee0000209400ULL,
0x0000000188886812ULL, 0x008fe200078efcffULL, 0x0000004300d27306ULL, 0x000e620000205400ULL,
0x0000000152522812ULL, 0x010fc400078efcffULL, 0x000000550000720bULL, 0x000fe20003fdd000ULL,
0x0000010039007824ULL, 0x000fc800078e00ffULL, 0x00000041008e7306ULL, 0x0004f0000020d400ULL,
0x0000004400a27306ULL, 0x000fe20000009400ULL, 0x0000010044417824ULL, 0x004fe200078e00ffULL,
0x000000d2d700720bULL, 0x002fc40003f5d000ULL, 0x0000000151516812ULL, 0x000fe400078efcffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000044009f7306ULL, 0x000e620000005400ULL,
0x000000018e8e0812ULL, 0x008fc800078efcffULL, 0x0000008e4d4d723eULL, 0x000fc600000010ffULL,
0x00000044007b7306ULL, 0x0004f0000000d400ULL, 0x0000008100dc7306ULL, 0x000fe20000209400ULL,
0x0001000044447824ULL, 0x004fe200078e00ffULL, 0x0000009fa200720bULL, 0x002fcc0003fdd000ULL,
0x0000008100e17306ULL, 0x000e6e0000205400ULL, 0x000000017b7b6812ULL, 0x008fe200078efcffULL,
0x0000004200e57306ULL, 0x000ff00000209400ULL, 0x0000004200de7306ULL, 0x000ea20000205400ULL,
0x000000e1dc00720bULL, 0x002fce0003f7d000ULL, 0x0000004000df7306ULL, 0x000ff00000209400ULL,
0x0000004000d87306ULL, 0x000fe20000205400ULL, 0x000000dee500720bULL, 0x004fce0003f1d000ULL,
0x00000040008c7306ULL, 0x0003f0000020d400ULL, 0x0000003f00b67306ULL, 0x000fe20000209400ULL,
0x00000018ff407819ULL, 0x002fce0000011444ULL, 0x0000003f00bd7306ULL, 0x000ff00000205400ULL,
0x0000003f00807306ULL, 0x000ff0000020d400ULL, 0x0000005300aa7306ULL, 0x000ff00000209400ULL,
0x0000005300a97306ULL, 0x000ff00000205400ULL, 0x00000053007d7306ULL, 0x000ff0000020d400ULL,
0x00000061003e7306ULL, 0x000ff00000209400ULL, 0x00000061003f7306ULL, 0x000ff00000205400ULL,
0x0000006100797306ULL, 0x000ff0000020d400ULL, 0x0000007500537306ULL, 0x000ff00000209400ULL,
0x0000007500867306ULL, 0x000ff00000205400ULL, 0x00000075006d7306ULL, 0x000ff0000020d400ULL,
0x0000008500747306ULL, 0x000ff00000209400ULL, 0x0000008500757306ULL, 0x000ff00000205400ULL,
0x0000008500617306ULL, 0x000ff0000020d400ULL, 0x0000004300857306ULL, 0x000e70000020d400ULL,
0x0000004000ad7306ULL, 0x000ff00000209400ULL, 0x0000004000447306ULL, 0x000ea20000205400ULL,
0x0000000185852812ULL, 0x002fce00078efcffULL, 0x00000081008d7306ULL, 0x000e70000020d400ULL,
0x00000042008b7306ULL, 0x000722000020d400ULL, 0x00000044ad00720bULL, 0x004fe20003f5d000ULL,
0x000100003bad7824ULL, 0x000fca00078e00ffULL, 0x00000018ffad7819ULL, 0x000fe200000114adULL,
0x0000004500a07306ULL, 0x000fe20000009400ULL, 0x0000010045427824ULL, 0x008fe200078e00ffULL,
0x000000018d8d3812ULL, 0x002fe400078efcffULL, 0x000000d8df00720bULL, 0x000fe40003f7d000ULL,
0x00000018ff437819ULL, 0x000fe40000011442ULL, 0x0000004500a37306ULL, 0x000e620000005400ULL,
0x000000018b8b0812ULL, 0x010fc400078efcffULL, 0x000000bdb600720bULL, 0x000fe40003f1d000ULL,
0x00000018ffb67819ULL, 0x000fc60000011400ULL, 0x00000045007c7306ULL, 0x0005e2000000d400ULL,
0x000000018c8c3812ULL, 0x000fc800078efcffULL, 0x000000518c51723eULL, 0x000fc600000010ffULL,
0x0000004000827306ULL, 0x000ee2000020d400ULL, 0x0001000045457824ULL, 0x004fe200078e00ffULL,
0x0000000180800812ULL, 0x000fe400078efcffULL, 0x000000a9aa00720bULL, 0x000fe20003f1d000ULL,
0x000001003aa97824ULL, 0x040fe200078e00ffULL, 0x00000018ffe07819ULL, 0x000fe20000011445ULL,
0x000100003aaa7824ULL, 0x000fe200078e00ffULL, 0x0000005e003c7306ULL, 0x000fe20000209400ULL,
0x000000a3a000720bULL, 0x002fe40003fdd000ULL, 0x00000018ffa97819ULL, 0x000fc400000114a9ULL,
0x00000018ffaa7819ULL, 0x000fc600000114aaULL, 0x000000e000457306ULL, 0x000fe20000209400ULL,
0x0000000182822812ULL, 0x008fe400078efcffULL, 0x000000017d7d0812ULL, 0x000fc600078efcffULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x000000e000427306ULL, 0x000e620000205400ULL,
0x0000003f3e00720bULL, 0x000fce0003fdd000ULL, 0x0000005e00a77306ULL, 0x000fec0000205400ULL,
0x0000000179796812ULL, 0x000fe400078efcffULL, 0x0000005e007a7306ULL, 0x000fe2000020d400ULL,
0x000000424500720bULL, 0x002fe40003f5d000ULL, 0x000000975a45723eULL, 0x000fca00000010ffULL,
0x00000073004a7306ULL, 0x000ff00000209400ULL, 0x00000073004b7306ULL, 0x000e700000205400ULL,
0x0000007300717306ULL, 0x000eb0000020d400ULL, 0x0000008400727306ULL, 0x000fe20000209400ULL,
0x0000004b4a00720bULL, 0x002fce0003fdd000ULL, 0x0000008400737306ULL, 0x000fec0000205400ULL,
0x0000000171716812ULL, 0x004fe400078efcffULL, 0x00000084005e7306ULL, 0x000fe2000020d400ULL,
0x000000865300720bULL, 0x000fce0003fdd000ULL, 0x0000004100d67306ULL, 0x000fec0000209400ULL,
0x000000016d6d6812ULL, 0x000fe400078efcffULL, 0x0000004100dd7306ULL, 0x000e700000205400ULL,
0x0000004100847306ULL, 0x0004f0000020d400ULL, 0x000000e000817306ULL, 0x000f22000020d400ULL,
0x0000010046417824ULL, 0x004fe200078e00ffULL, 0x000000ddd600720bULL, 0x002fc80003f7d000ULL,
0x00000018ffe27819ULL, 0x000fe40000011441ULL, 0x000000ac00af7306ULL, 0x000fee0000209400ULL,
0x0000000184843812ULL, 0x008fe200078efcffULL, 0x000000e200407306ULL, 0x000fe20000209400ULL,
0x0000000181812812ULL, 0x010fc400078efcffULL, 0x0000007b8484723eULL, 0x000fca00000010ffULL,
0x000000e200417306ULL, 0x000e700000205400ULL, 0x000000ac00b07306ULL, 0x000ff00000205400ULL,
0x000000ac00937306ULL, 0x0005e2000020d400ULL, 0x000000414000720bULL, 0x002fce0003f5d000ULL,
0x0000004300ab7306ULL, 0x000fe20000209400ULL, 0x00000018ffac7819ULL, 0x004fe4000001146cULL,
0x00000008676c7812ULL, 0x000fca00078ef832ULL, 0x0000004300ae7306ULL, 0x000e620000205400ULL,
0x0000000107677824ULL, 0x000fe400078e026cULL, 0x000000086c027824ULL, 0x040fe400078e00ffULL,
0x000000086cb77824ULL, 0x000fe200078e00ffULL, 0x0000000267007810ULL, 0x000fe40007ffe0ffULL,
0x0000004600a67306ULL, 0x000fe20000009400ULL, 0xfffffff802027812ULL, 0x000fe400078ee267ULL,
0xfffffff8b7007812ULL, 0x000fc400078ee200ULL, 0x0001200002547811ULL, 0x000fe400078e20ffULL,
0x0001200000407811ULL, 0x000fe200078e20ffULL, 0x0000004600a17306ULL, 0x000ea20000005400ULL,
0x000000aeab00720bULL, 0x002fe20003f7d000ULL, 0x000001003bab7824ULL, 0x000fca00078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x0000004700917306ULL, 0x000ff00000009400ULL,
0x0000004700907306ULL, 0x000fe20000005400ULL, 0x000000a1a600720bULL, 0x004fce0003f1d000ULL,
0x00000047006e7306ULL, 0x0003f0000000d400ULL, 0x000000e200837306ULL, 0x000ea2000020d400ULL,
0x0001000047477824ULL, 0x002fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe40000011447ULL,
0x0000004600767306ULL, 0x0002f0000000d400ULL, 0x0000004300877306ULL, 0x000f22000020d400ULL,
0x0001000046467824ULL, 0x002fe200078e00ffULL, 0x0000000183832812ULL, 0x004fc400078efcffULL,
0x000000b0af00720bULL, 0x000fe40003f5d000ULL, 0x00000018ffb47819ULL, 0x000fe40000011446ULL,
0x0000005600477306ULL, 0x000fe20000209400ULL, 0x0000000176760812ULL, 0x008fe400078efcffULL,
0x000000909100720bULL, 0x000fe40003f1d000ULL, 0x000000768376723eULL, 0x000fc600000010ffULL,
0x0000005600b27306ULL, 0x000fe20000205400ULL, 0x0000000187873812ULL, 0x010fe400078efcffULL,
0x000000a73c00720bULL, 0x000fe40003f7d000ULL, 0x0000000193932812ULL, 0x000fe400078efcffULL,
0x000000a4a53c723eULL, 0x000fe200000010ffULL, 0x0000005600947306ULL, 0x0003e2000020d400ULL,
0x000000016e6e0812ULL, 0x000fce00078efcffULL, 0x000000b400437306ULL, 0x000fe20000209400ULL,
0x000000005454783bULL, 0x002e620000000200ULL, 0x000000017a7a3812ULL, 0x000fc800078efcffULL,
0x000000817a81723eULL, 0x000fe400000010ffULL, 0x000000b400467306ULL, 0x000eb00000205400ULL,
0x000000b4008a7306ULL, 0x000ef0000020d400ULL, 0x000000ac00b17306ULL, 0x000fe20000209400ULL,
0x000000464300720bULL, 0x004fc40003f7d000ULL, 0x000000004040783bULL, 0x000eaa0000000200ULL,
0x000000ac00b47306ULL, 0x000f2c0000205400ULL, 0x000000018a8a3812ULL, 0x008fc400078efcffULL,
0x00000038004f7306ULL, 0x000fe20000009400ULL, 0x000000b24700720bULL, 0x000fe20003f7d000ULL,
0x0000000954549231ULL, 0x082fe400003400ffULL, 0x0000000956569231ULL, 0x000fe400003400ffULL,
0x0000000855559231ULL, 0x080fe400003400ffULL, 0x0000003800507306ULL, 0x000e620000005400ULL,
0x000000b4b100720bULL, 0x010fe20003f5d000ULL, 0x0000000857579231ULL, 0x000fc800003400ffULL,
0x0000000194943812ULL, 0x000fe400078efcffULL, 0x00000038006b7306ULL, 0x000722000000d400ULL,
0x0000003c543c723cULL, 0x000f6200000418ffULL, 0x000000947171723eULL, 0x000fcc00000010ffULL,
0x000000ac00a87306ULL, 0x000f22000020d400ULL, 0x0001000038387824ULL, 0x008fe200078e00ffULL,
0x000000504f00720bULL, 0x002fe20003f1d000ULL, 0x0000000940409231ULL, 0x084fe200003400ffULL,
0x000000888d50723eULL, 0x000fe200000010ffULL, 0x0000000942429231ULL, 0x000fe200003400ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000000841419231ULL, 0x080fe200003400ffULL,
0x0000003900897306ULL, 0x000fe20000009400ULL, 0x0000008b5288723eULL, 0x000fe200000010ffULL,
0x0000000843439231ULL, 0x000fe200003400ffULL, 0x000000485448723cULL, 0x000f6800000418ffULL,
0x000000016b6b0812ULL, 0x010fe200078efcffULL, 0x00000039004e7306ULL, 0x000e620000005400ULL,
0x00000001a8a82812ULL, 0x000fc400078efcffULL, 0x000000505450723cULL, 0x000fe400000418ffULL,
0x0000006ba89e723eULL, 0x000fc600000010ffULL, 0x0000003900687306ULL, 0x0004f0000000d400ULL,
0x0000003800b37306ULL, 0x000fe20000209400ULL, 0x0001000039397824ULL, 0x004fe200078e00ffULL,
0x0000004e8900720bULL, 0x002fc40003f7d000ULL, 0x000000858089723eULL, 0x000fe200000010ffULL,
0x0000004c544c723cULL, 0x000f6200000418ffULL, 0x00000018ff447819ULL, 0x000fe40000011439ULL,
0x0000003800b87306ULL, 0x000e620000205400ULL, 0x0000009b9839723eULL, 0x000fe400000010ffULL,
0x0000007c8785723eULL, 0x000fe400000010ffULL, 0x000000827d80723eULL, 0x000fe400000010ffULL,
0x0000000168683812ULL, 0x008fe200078efcffULL, 0x000000b600b57306ULL, 0x000fe40000209400ULL,
0x00000084403c723cULL, 0x020fec000004183cULL, 0x000000b600a27306ULL, 0x000ea20000205400ULL,
0x000000b8b300720bULL, 0x002fce0003f5d000ULL, 0x0000004400a07306ULL, 0x000ff00000209400ULL,
0x0000004400a17306ULL, 0x000e620000205400ULL, 0x000000a2b500720bULL, 0x004fce0003f1d000ULL,
0x0000003800ac7306ULL, 0x0004f0000020d400ULL, 0x000000b6009f7306ULL, 0x000f22000020d400ULL,
0x0000009d9c38723eULL, 0x004fe400000010ffULL, 0x000000a1a000720bULL, 0x002fca0003fdd000ULL,
0x000000a900987306ULL, 0x000fe20000209400ULL, 0x00000001acac2812ULL, 0x008fe400078efcffULL,
0x0000007f7e00720bULL, 0x000fca0003f5d000ULL, 0x000000a900977306ULL, 0x000e620000205400ULL,
0x000000019f9f0812ULL, 0x010fc800078efcffULL, 0x000000689f9f723eULL, 0x000fe400000010ffULL,
0x000000ac6d68723eULL, 0x000fe200000010ffULL, 0x00000044009c7306ULL, 0x0004e2000020d400ULL,
0x0000000169692812ULL, 0x000fc600078efcffULL, 0x0000009e4048723cULL, 0x000fe80000041848ULL,
0x000000ab008f7306ULL, 0x000fe20000209400ULL, 0x000000965b44723eULL, 0x004fe400000010ffULL,
0x000000979800720bULL, 0x002fe20003f1d000ULL, 0x000000585458723cULL, 0x000fe800000418ffULL,
0x000000ab008e7306ULL, 0x000e620000205400ULL, 0x000000019c9c6812ULL, 0x008fc600078efcffULL,
0x000000445444723cULL, 0x000f6200000418ffULL, 0x0000009c6969723eULL, 0x000fc600000010ffULL,
0x0000003b006f7306ULL, 0x000fe80000009400ULL, 0x00000068404c723cULL, 0x000fe8000004184cULL,
0x0000003b00707306ULL, 0x000ea20000005400ULL, 0x0000008e8f00720bULL, 0x002fce0003fdd000ULL,
0x000000a900917306ULL, 0x000e70000020d400ULL, 0x0000003a00777306ULL, 0x000fe20000009400ULL,
0x000000706f00720bULL, 0x004fe40003f5d000ULL, 0x0000008a7970723eULL, 0x000fca00000010ffULL,
0x0000003a00787306ULL, 0x000ea20000005400ULL, 0x0000000191910812ULL, 0x002fe200078efcffULL,
0x000000704044723cULL, 0x020be20000041844ULL, 0x000000737200720bULL, 0x000fca0003f1d000ULL,
0x000000ab008b7306ULL, 0x000e70000020d400ULL, 0x000000aa007b7306ULL, 0x000fe20000209400ULL,
0x000000787700720bULL, 0x004fe40003f7d000ULL, 0x0000006e9377723eULL, 0x000fc400000010ffULL,
0x000000015e5e0812ULL, 0x000fe400078efcffULL, 0x0000000f3400720cULL, 0x000fe20003f03070ULL,
0x000000aa007c7306ULL, 0x000ea20000205400ULL, 0x000000018b8b6812ULL, 0x002fe200078efcffULL,
0x000000764058723cULL, 0x000fec0000041858ULL, 0x0000003b00667306ULL, 0x000e70000000d400ULL,
0x000000ad007a7306ULL, 0x000fe20000209400ULL, 0x0000007c7b00720bULL, 0x004fce0003fdd000ULL,
0x000000ad007d7306ULL, 0x000ea20000205400ULL, 0x0000000166662812ULL, 0x002fc800078efcffULL,
0x000000668b6f723eULL, 0x000fc600000010ffULL, 0x0000003a00627306ULL, 0x0002f0000000d400ULL,
0x000000aa00737306ULL, 0x000f22000020d400ULL, 0x0000007d7a00720bULL, 0x004fe20003f5d000ULL,
0x000000385438723cULL, 0x042f6c00000418ffULL, 0x000000ad00707306ULL, 0x020e62000020d400ULL,
0x0000000162623812ULL, 0x008fe200078efcffULL, 0x000000885454723cULL, 0x000f6200000418ffULL,
0x000000757400720bULL, 0x000fc40003f7d000ULL, 0x00000062916e723eULL, 0x000fe400000010ffULL,
0x00000002ff627819ULL, 0x000fe40000011632ULL, 0x0000000173736812ULL, 0x010fe400078efcffULL,
0x0000000f3400720cULL, 0x000fe20003fc3070ULL, 0x0000006e4050723cULL, 0x000b620000041850ULL,
0x000000735e68723eULL, 0x000fe400000010ffULL, 0x000000016a5e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000170702812ULL, 0x002fe400078efcffULL, 0x0000006a6200720cULL, 0x040fe20003f46070ULL,
0x000000804038723cULL, 0x000b620000041838ULL, 0x0000000161613812ULL, 0x000fe400078efcffULL,
0x0000005e6200720cULL, 0x040fe40005746470ULL, 0x000000706169723eULL, 0x000fe400000010ffULL,
0x0000000862617810ULL, 0x000fc80007ffe0ffULL, 0x0000006a6100720cULL, 0x040fe20003f66070ULL,
0x000000684054723cULL, 0x020b660000041854ULL, 0x0000005e6100720cULL, 0x000fe20005f66470ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000003c12127221ULL, 0x020fe40000010000ULL,
0x0000003d13137221ULL, 0x000fe40000010000ULL, 0x0000003816167221ULL, 0x000fe40000010000ULL,
0x0000003917177221ULL, 0x000fc40000010000ULL, 0x000000581a1a7221ULL, 0x000fe40000010000ULL,
0x000000591b1b7221ULL, 0x000fe40000010000ULL, 0x000000441e1e7221ULL, 0x000fe40000010000ULL,
0x000000451f1f7221ULL, 0x000fe40000010000ULL, 0x0000004822227221ULL, 0x000fe40000010000ULL,
0x0000004923237221ULL, 0x000fc40000010000ULL, 0x0000004c26267221ULL, 0x000fe40000010000ULL,
0x0000004d27277221ULL, 0x000fe40000010000ULL, 0x000000502a2a7221ULL, 0x000fe40000010000ULL,
0x000000512b2b7221ULL, 0x000fe40000010000ULL, 0x000000542e2e7221ULL, 0x000fe40000010000ULL,
0x000000552f2f7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x020fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0000000000ULL,
0x0000003e14147221ULL, 0x000fe40000010000ULL, 0x0000003f15157221ULL, 0x000fc40000010000ULL,
0x0000003a18187221ULL, 0x000fe40000010000ULL, 0x0000003b19197221ULL, 0x000fe40000010000ULL,
0x0000005a1c1c7221ULL, 0x000fe40000010000ULL, 0x0000005b1d1d7221ULL, 0x000fe40000010000ULL,
0x0000004620207221ULL, 0x000fe40000010000ULL, 0x0000004721217221ULL, 0x000fc40000010000ULL,
0x0000004a24247221ULL, 0x000fe40000010000ULL, 0x0000004b25257221ULL, 0x000fe40000010000ULL,
0x0000004e28287221ULL, 0x000fe40000010000ULL, 0x0000004f29297221ULL, 0x000fe40000010000ULL,
0x000000522c2c7221ULL, 0x000fe40000010000ULL, 0x000000532d2d7221ULL, 0x000fc40000010000ULL,
0x0000005630307221ULL, 0x000fe40000010000ULL, 0x0000005731317221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff387f8cULL, 0x000e62000c80043fULL, 0x00000002ff3b7819ULL, 0x000fe2000001165eULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000f3400720cULL, 0x0c0fe40003f03070ULL,
0x0000000f3400720cULL, 0x000fe40003fc3070ULL, 0x00000001ff8c7803ULL, 0x000fe40000000000ULL,
0x000000035e387812ULL, 0x042fe200078ec0ffULL, 0x000000ffff3f7224ULL, 0x000fe200078e0039ULL,
0x0000003b5e5e7207ULL, 0x000fc40002800000ULL, 0x000000ff38407207ULL, 0x000fe40006800000ULL,
0x000000035e417812ULL, 0x040fe400078ec0ffULL, 0x0000000f5e437211ULL, 0x000fc400078ff0ffULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b8400ff3a7984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe20007804865ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8400ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804865ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x018b8c00ff3a7984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x800000003aff7812ULL, 0x002fe2000780483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000143397810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x000000363900720cULL, 0x000fda0003f06070ULL,
0x0000051000008947ULL, 0x000fea0003800000ULL, 0x0000000507427c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff457424ULL, 0x000fe400078e00ffULL, 0x00000010323a7824ULL, 0x000fe400078e00ffULL,
0x018a0000423c7984ULL, 0x000e620000004800ULL, 0x0000004035447824ULL, 0x000fe400078e0242ULL,
0x000000f03a477812ULL, 0x000fe200078ec0ffULL, 0x018ac0003c3c7984ULL, 0x002e640000004800ULL,
0x0000003c0d387224ULL, 0x002fc400078e0244ULL, 0x00000010423c7824ULL, 0x000fe400078e00ffULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe400000e0639ULL, 0x0000000443397824ULL, 0x000fc800078e0241ULL,
0x0000004039397824ULL, 0x000fca00078e00ffULL, 0x0000003960387217ULL, 0x000fca0007800000ULL,
0x0000000138387824ULL, 0x000fe400078e0a39ULL, 0x0000000142397824ULL, 0x000fc600078e0232ULL,
0x0000000538387c17ULL, 0x000fe4000f800000ULL, 0xfffffff03c397812ULL, 0x000fe400078ee239ULL,
0x80000005383e7c10ULL, 0x000fe4000fffe0ffULL, 0x0001400039497811ULL, 0x000fe400078e20ffULL,
0x0000003e0700720cULL, 0x000fe40003f06070ULL, 0x0000000244397810ULL, 0x000fd60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a497faeULL, 0x0003e8000c101c4aULL,
0x018a0800423f7984ULL, 0x000ea80000004800ULL, 0x018ac0003f387984ULL, 0x004ea40000004800ULL,
0x000000380d387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e0639ULL,
0x0000000207397810ULL, 0x000fc80007ffe0ffULL, 0x00000005394b7c10ULL, 0x040fe4000fffe0ffULL,
0x0000003e3900720cULL, 0x000fe40003f06070ULL, 0x0000000444397810ULL, 0x000fe20007ffe0ffULL,
0x000000014b387824ULL, 0x040fe400078e0232ULL, 0x000000104b4b7824ULL, 0x000fca00078e00ffULL,
0xfffffff04b387812ULL, 0x000fc800078ee238ULL, 0x0001400038497811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c497faeULL, 0x0003e8000c101c4aULL,
0x018a1000423f7984ULL, 0x000ea80000004800ULL, 0x018ac0003f387984ULL, 0x0044e40000004800ULL,
0x00000006073f7810ULL, 0x004fe20007ffe0ffULL, 0x000000380d387224ULL, 0x008fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200000e0639ULL, 0x0000000407397810ULL, 0x000fc80007ffe0ffULL,
0x00000005394b7c10ULL, 0x040fe4000fffe0ffULL, 0x0000003e3900720cULL, 0x000fc60003f06070ULL,
0x000000014b387824ULL, 0x040fe400078e0232ULL, 0x000000104b4b7824ULL, 0x000fca00078e00ffULL,
0xfffffff04b387812ULL, 0x000fc800078ee238ULL, 0x00014000383d7811ULL, 0x002fe400078e20ffULL,
0x0000000644387810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000c101c4aULL, 0x018a1800423c7984ULL, 0x000ea80000004800ULL,
0x018ac0003c3c7984ULL, 0x004ea40000004800ULL, 0x0000003c0d387224ULL, 0x004fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fe200078e0045ULL, 0x000000053f457c10ULL, 0x000fc8000fffe0ffULL,
0x0000004738387210ULL, 0x000fe20007f1e0ffULL, 0x0000000145447824ULL, 0x040fe400078e0232ULL,
0x0000001045457824ULL, 0x000fe400078e00ffULL, 0x000000ffff397224ULL, 0x000fe200000e0639ULL,
0x0000003e3f00720cULL, 0x000fe40003f06070ULL, 0xfffffff045447812ULL, 0x000fc800078ee244ULL,
0x00014000443b7811ULL, 0x002fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000c101c4aULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x0000000507427c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff457424ULL, 0x000fe400078e00ffULL,
0x00000010323a7824ULL, 0x000fe400078e00ffULL, 0x018a0000423c7984ULL, 0x000e620000004800ULL,
0x0000004035447824ULL, 0x000fe400078e0242ULL, 0x000000f03a477812ULL, 0x000fe200078ec0ffULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0244ULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000142387824ULL, 0x000fc800078e0232ULL, 0x000000ffff3b7224ULL, 0x000fe400000e0639ULL,
0x0000001042397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x00014000383f7811ULL, 0x000fe400078e20ffULL, 0x0000000244387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3f7faeULL, 0x0003e8000b901c4aULL,
0x018a0800423e7984ULL, 0x000ea80000004800ULL, 0x018ac0003e3e7984ULL, 0x004ea40000004800ULL,
0x0000003e0d387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e0639ULL,
0x0000000242397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0232ULL,
0x0000001039397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x00014000383f7811ULL, 0x002fe400078e20ffULL, 0x0000000444387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c3f7faeULL, 0x0003e8000b901c4aULL,
0x018a1000423e7984ULL, 0x000ea20000004800ULL, 0x00000006423f7810ULL, 0x002fc60007ffe0ffULL,
0x018ac0003e3e7984ULL, 0x004e640000004800ULL, 0x0000003e0d387224ULL, 0x002fe400078e0238ULL,
0x000000013f3e7824ULL, 0x000fe400078e0232ULL, 0x00005e0038387625ULL, 0x000fc800078e0045ULL,
0x000000103f3f7824ULL, 0x000fe200078e00ffULL, 0x00000047383a7210ULL, 0x000fc80007f1e0ffULL,
0xfffffff03f3e7812ULL, 0x000fe200078ee23eULL, 0x000000ffff3b7224ULL, 0x000fe200000e0639ULL,
0x0000000442397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0232ULL,
0x0000001039397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x00014000383d7811ULL, 0x000fe400078e20ffULL, 0x0000000644387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c4aULL,
0x018a1800423c7984ULL, 0x000ea20000004800ULL, 0x000140003e3b7811ULL, 0x002fc600078e20ffULL,
0x018ac0003c3c7984ULL, 0x004e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x0000004738387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c4aULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x018b8c00ff3a7984ULL, 0x000e620000000800ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe2000780483fULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000433400720cULL, 0x000fe20003f04070ULL, 0x00000004ff3a7424ULL, 0x000fe200078e00ffULL,
0x00018a000c3d7811ULL, 0x000fe400078e10ffULL, 0x000000ff40387207ULL, 0x000fc40000000000ULL,
0x000000ff40407207ULL, 0x000fc60004000000ULL, 0x0000000141387824ULL, 0x000fc800078e0238ULL,
0x0000004038397824ULL, 0x040fe200078e00ffULL, 0x0000004338387211ULL, 0x000fc800078ff0ffULL,
0x000000c039397812ULL, 0x000fca00078ec0ffULL, 0x0000010038387824ULL, 0x000fe200078e0239ULL,
0x0000000c40397c10ULL, 0x000fc8000fffe0ffULL, 0x0000002038387810ULL, 0x000fca0007ffe0ffULL,
0x000000010c3b7824ULL, 0x100fe400078e0238ULL, 0x0000680039397a24ULL, 0x000fc600078e0238ULL,
0x000000603b00720cULL, 0x000fe20003f06070ULL, 0x000000010c397824ULL, 0x000fc800078e0239ULL,
0x0000660039387625ULL, 0x000fd000078e003aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383d7faeULL, 0x0003e4000c12184aULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b7800ff387f8cULL, 0x000e62000c80043fULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x000000ffff6b7224ULL, 0x002fe200078e0039ULL, 0x0000014000001947ULL, 0x000fea0003800000ULL,
0x0000000aff08723eULL, 0x000fc800000010ffULL, 0x00005410083a7816ULL, 0x000fe20000000008ULL,
0x00021e327f007947ULL, 0x000fea000b800000ULL, 0x00001f623a097589ULL, 0x0002a400000e0000ULL,
0x00021e927f007947ULL, 0x000fea000b800000ULL, 0x00001f613a087589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010623f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0000713000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0002302000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018623f7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff407424ULL, 0x000fe200078e00ffULL, 0x000071a000387802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00022fb000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0001600064647811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0001600063637811ULL, 0x000fe200078e20ffULL,
0x000000015c5f7824ULL, 0x040fe200078e025fULL, 0x0000000467687810ULL, 0x040fe20007ffe0ffULL,
0x00000000643c783bULL, 0x006e620000004200ULL, 0x000000015c5d7824ULL, 0x000fe200078e025dULL,
0x0000000667677810ULL, 0x000fe20007ffe0ffULL, 0x00001ed000017945ULL, 0x000fe20003800000ULL,
0x0000003c00387306ULL, 0x002ff00000009400ULL, 0x0000003c00397306ULL, 0x000e700000005400ULL,
0x0000003c007d7306ULL, 0x000ea2000000d400ULL, 0x000000393800720bULL, 0x002fce0003f1d000ULL,
0x0000003d007b7306ULL, 0x000ff0000000d400ULL, 0x0000003d00387306ULL, 0x000fe20000009400ULL,
0x000000017d7d0812ULL, 0x004fce00078efcffULL, 0x0000003d00397306ULL, 0x000e700000005400ULL,
0x0000003e00757306ULL, 0x000fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003f1d000ULL,
0x0000003f00737306ULL, 0x000ff0000000d400ULL, 0x0000003e00387306ULL, 0x000fe20000009400ULL,
0x000000017b7b0812ULL, 0x000fce00078efcffULL, 0x0000003e00397306ULL, 0x000e640000005400ULL,
0x000000393800720bULL, 0x002fcc0003f1d000ULL, 0x0000003f00387306ULL, 0x000ff00000009400ULL,
0x0000003f00397306ULL, 0x000e620000005400ULL, 0x0000000175750812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fc40003f1d000ULL, 0x000000006338783bULL, 0x008e760000004200ULL,
0x0000000173730812ULL, 0x000fe200078efcffULL, 0x0000003800407306ULL, 0x002fe20000009400ULL,
0x00000018ff467819ULL, 0x000fce000001143aULL, 0x0000003800417306ULL, 0x000e700000005400ULL,
0x0000003800727306ULL, 0x000ea2000000d400ULL, 0x000000414000720bULL, 0x002fce0003f1d000ULL,
0x00000039006f7306ULL, 0x000ff0000000d400ULL, 0x0000003900407306ULL, 0x000fe20000009400ULL,
0x0000000172720812ULL, 0x004fce00078efcffULL, 0x0000003900417306ULL, 0x000e700000005400ULL,
0x0000003a006e7306ULL, 0x000fe2000000d400ULL, 0x000000414000720bULL, 0x002fce0003f1d000ULL,
0x0000004600697306ULL, 0x000ff0000020d400ULL, 0x0000003a00407306ULL, 0x000fe20000009400ULL,
0x000000016f6f0812ULL, 0x000fce00078efcffULL, 0x0000003a00417306ULL, 0x000e640000005400ULL,
0x000000414000720bULL, 0x002fe40003f1d000ULL, 0x00000018ff407819ULL, 0x000fc8000001143cULL,
0x0000004000417306ULL, 0x000fee0000209400ULL, 0x000000016e6e0812ULL, 0x000fe200078efcffULL,
0x0000004000427306ULL, 0x000e700000205400ULL, 0x0000004000777306ULL, 0x000ea2000020d400ULL,
0x000000424100720bULL, 0x002fc40003f1d000ULL, 0x00000018ff417819ULL, 0x000fca000001143dULL,
0x0000004100427306ULL, 0x000fec0000209400ULL, 0x0000000177770812ULL, 0x004fe400078efcffULL,
0x0000004100437306ULL, 0x000e700000205400ULL, 0x0000004100767306ULL, 0x0004e2000020d400ULL,
0x000000434200720bULL, 0x002fc40003f1d000ULL, 0x00000018ff427819ULL, 0x000fe4000001143eULL,
0x00000018ff417819ULL, 0x004fc60000011438ULL, 0x0000004200437306ULL, 0x000fec0000209400ULL,
0x0000000176760812ULL, 0x008fe400078efcffULL, 0x0000004200407306ULL, 0x000e700000205400ULL,
0x0000004200747306ULL, 0x000ea2000020d400ULL, 0x000000404300720bULL, 0x002fce0003f1d000ULL,
0x0000004100427306ULL, 0x000fe20000205400ULL, 0x00000018ff407819ULL, 0x000fce000001143fULL,
0x0000004000437306ULL, 0x000fe20000209400ULL, 0x0000000174740812ULL, 0x004fce00078efcffULL,
0x0000004000447306ULL, 0x000e700000205400ULL, 0x0000004000717306ULL, 0x000ea2000020d400ULL,
0x000000444300720bULL, 0x002fce0003f1d000ULL, 0x0000004100707306ULL, 0x000ff0000020d400ULL,
0x0000004100437306ULL, 0x000e620000209400ULL, 0x0000000171710812ULL, 0x004fce00078efcffULL,
0x0000004600417306ULL, 0x000fe20000205400ULL, 0x000000424300720bULL, 0x002fe40003f1d000ULL,
0x00000018ff427819ULL, 0x000fca0000011439ULL, 0x0000004200437306ULL, 0x000fec0000209400ULL,
0x0000000170700812ULL, 0x000fe400078efcffULL, 0x0000004200407306ULL, 0x000e700000205400ULL,
0x00000042006d7306ULL, 0x000ea2000020d400ULL, 0x000000404300720bULL, 0x002fce0003f1d000ULL,
0x0000004600407306ULL, 0x000e6c0000209400ULL, 0x000000016d6d0812ULL, 0x004fe400078efcffULL,
0x000000414000720bULL, 0x002fe20003f1d000ULL, 0x000000105c407824ULL, 0x040fe400078e00ffULL,
0x000000105c5c7824ULL, 0x000fc600078e00ffULL, 0xfffffff0405f7812ULL, 0x000fe400078ee25fULL,
0xfffffff05c5d7812ULL, 0x000fe400078ee25dULL, 0x000160005f667811ULL, 0x000fe400078e20ffULL,
0x000160005d657811ULL, 0x000fe400078e20ffULL, 0x0000000169690812ULL, 0x000fe200078efcffULL,
0x000000006640783bULL, 0x000e640000004200ULL, 0x0000004000447306ULL, 0x002ff00000009400ULL,
0x0000004000457306ULL, 0x000e700000005400ULL, 0x0000004000587306ULL, 0x000ea2000000d400ULL,
0x000000454400720bULL, 0x002fce0003f1d000ULL, 0x0000004100597306ULL, 0x000ff0000000d400ULL,
0x0000004100447306ULL, 0x000fe20000009400ULL, 0x0000000158580812ULL, 0x004fce00078efcffULL,
0x0000004100457306ULL, 0x000e700000005400ULL, 0x0000004200507306ULL, 0x000fe2000000d400ULL,
0x000000454400720bULL, 0x002fce0003f1d000ULL, 0x0000004300517306ULL, 0x000ff0000000d400ULL,
0x0000004200447306ULL, 0x000fe20000009400ULL, 0x0000000159590812ULL, 0x000fce00078efcffULL,
0x0000004200457306ULL, 0x000e640000005400ULL, 0x000000454400720bULL, 0x002fcc0003f1d000ULL,
0x0000004300447306ULL, 0x000ff00000009400ULL, 0x0000004300457306ULL, 0x000e620000005400ULL,
0x0000000150500812ULL, 0x000fe400078efcffULL, 0x000000454400720bULL, 0x002fc40003f1d000ULL,
0x000000006544783bULL, 0x000e760000004200ULL, 0x0000000151510812ULL, 0x000fe200078efcffULL,
0x0000004400487306ULL, 0x002ff00000009400ULL, 0x00000044004b7306ULL, 0x000e700000005400ULL,
0x0000004400497306ULL, 0x000ea2000000d400ULL, 0x0000004b4800720bULL, 0x002fce0003f1d000ULL,
0x00000045004a7306ULL, 0x000ff00000009400ULL, 0x00000045004b7306ULL, 0x000e620000005400ULL,
0x0000000149490812ULL, 0x004fce00078efcffULL, 0x0000004500487306ULL, 0x000ea2000000d400ULL,
0x0000004b4a00720bULL, 0x002fce0003f1d000ULL, 0x0000004600877306ULL, 0x000ff0000000d400ULL,
0x00000046004a7306ULL, 0x000fe20000009400ULL, 0x0000000148480812ULL, 0x004fce00078efcffULL,
0x00000046004b7306ULL, 0x000e700000005400ULL, 0x0000004700857306ULL, 0x000fe2000000d400ULL,
0x0000004b4a00720bULL, 0x002fce0003f1d000ULL, 0x00000047004a7306ULL, 0x000ff00000009400ULL,
0x00000047004b7306ULL, 0x000e620000005400ULL, 0x0000000187870812ULL, 0x000fe400078efcffULL,
0x0000004b4a00720bULL, 0x002fe20003f1d000ULL, 0x000001003c4a7824ULL, 0x000fc400078e00ffULL,
0x000100003c3c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000004a004b7306ULL, 0x000fe60000209400ULL,
0x0000000185850812ULL, 0x000fca00078efcffULL, 0x0000004a004c7306ULL, 0x000e700000205400ULL,
0x0000004a00847306ULL, 0x000ea2000020d400ULL, 0x0000004c4b00720bULL, 0x002fce0003f1d000ULL,
0x0000003c00827306ULL, 0x000ff0000020d400ULL, 0x0000003c004b7306ULL, 0x000fe20000209400ULL,
0x0000000184840812ULL, 0x004fce00078efcffULL, 0x0000003c004c7306ULL, 0x000e620000205400ULL,
0x0000007d8484723eULL, 0x000fe400000010ffULL, 0x0000004c4b00720bULL, 0x002fe20003f1d000ULL,
0x000001003d4b7824ULL, 0x040fe400078e00ffULL, 0x000100003d3d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000004b004a7306ULL, 0x000fe60000209400ULL, 0x0000000182820812ULL, 0x000fc800078efcffULL,
0x000000827782723eULL, 0x000fe200000010ffULL, 0x0000004b004d7306ULL, 0x000e700000205400ULL,
0x0000004b00867306ULL, 0x000ea2000020d400ULL, 0x0000004d4a00720bULL, 0x002fce0003f1d000ULL,
0x0000003d003c7306ULL, 0x000ff00000209400ULL, 0x0000003d004d7306ULL, 0x000e620000205400ULL,
0x0000000186860812ULL, 0x004fce00078efcffULL, 0x0000003d00837306ULL, 0x000ea2000020d400ULL,
0x0000004d3c00720bULL, 0x002fe20003f1d000ULL, 0x000001003e3c7824ULL, 0x040fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003c004a7306ULL, 0x000fe60000209400ULL,
0x0000000183830812ULL, 0x004fc800078efcffULL, 0x000000837683723eULL, 0x000fe200000010ffULL,
0x0000003c004b7306ULL, 0x000e700000205400ULL, 0x0000003c00807306ULL, 0x000ea2000020d400ULL,
0x0000004b4a00720bULL, 0x002fce0003f1d000ULL, 0x0000003e003d7306ULL, 0x000ff00000209400ULL,
0x0000003e004a7306ULL, 0x000e620000205400ULL, 0x0000000180800812ULL, 0x004fce00078efcffULL,
0x0000003e00817306ULL, 0x000ea2000020d400ULL, 0x000000758076723eULL, 0x000fe400000010ffULL,
0x0000004a3d00720bULL, 0x002fe20003f1d000ULL, 0x000001003f3d7824ULL, 0x040fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000003d003c7306ULL, 0x000fe60000209400ULL,
0x0000000181810812ULL, 0x004fc800078efcffULL, 0x000000817474723eULL, 0x000fe200000010ffULL,
0x0000003d004b7306ULL, 0x000e700000205400ULL, 0x0000003d007e7306ULL, 0x000ea2000020d400ULL,
0x0000004b3c00720bULL, 0x002fce0003f1d000ULL, 0x0000003f007c7306ULL, 0x000ff0000020d400ULL,
0x0000003f003c7306ULL, 0x000fe20000209400ULL, 0x000000017e7e0812ULL, 0x004fce00078efcffULL,
0x0000003f004b7306ULL, 0x000e620000205400ULL, 0x000000737e77723eULL, 0x000fe400000010ffULL,
0x0000004b3c00720bULL, 0x002fe20003f1d000ULL, 0x00000100383c7824ULL, 0x040fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003c003d7306ULL, 0x000fe60000209400ULL,
0x000000017c7c0812ULL, 0x000fc800078efcffULL, 0x0000007c7175723eULL, 0x000fe200000010ffULL,
0x0000003c003e7306ULL, 0x000e700000205400ULL, 0x0000003c007f7306ULL, 0x000ea2000020d400ULL,
0x0000003e3d00720bULL, 0x002fce0003f1d000ULL, 0x0000003800797306ULL, 0x000ff0000020d400ULL,
0x00000038003d7306ULL, 0x000fe20000209400ULL, 0x000000017f7f0812ULL, 0x004fce00078efcffULL,
0x00000038003e7306ULL, 0x000e620000205400ULL, 0x000000727f72723eULL, 0x000fe400000010ffULL,
0x0000003e3d00720bULL, 0x002fe20003f1d000ULL, 0x00000100393d7824ULL, 0x040fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff387819ULL, 0x000fe40000011439ULL, 0x0000003d003c7306ULL, 0x000fe60000209400ULL,
0x0000000179790812ULL, 0x000fca00078efcffULL, 0x0000003d003f7306ULL, 0x000e700000205400ULL,
0x0000003d007a7306ULL, 0x000ea2000020d400ULL, 0x0000003f3c00720bULL, 0x002fce0003f1d000ULL,
0x0000003800397306ULL, 0x000ff00000209400ULL, 0x00000038003c7306ULL, 0x000e620000205400ULL,
0x000000017a7a0812ULL, 0x004fce00078efcffULL, 0x0000003800787306ULL, 0x000ea2000020d400ULL,
0x0000006f7a73723eULL, 0x000fe400000010ffULL, 0x0000003c3900720bULL, 0x002fe20003f1d000ULL,
0x000001003a397824ULL, 0x040fe400078e00ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc80000011439ULL, 0x0000003c003d7306ULL, 0x000fe60000209400ULL,
0x0000000178780812ULL, 0x004fc800078efcffULL, 0x000000786d6d723eULL, 0x000fe200000010ffULL,
0x0000003c003e7306ULL, 0x000e700000205400ULL, 0x0000003c00397306ULL, 0x000ea2000020d400ULL,
0x0000003e3d00720bULL, 0x002fc40003f1d000ULL, 0x00000018ff3d7819ULL, 0x000fca000001143aULL,
0x0000003d00387306ULL, 0x000fec0000209400ULL, 0x0000000139390812ULL, 0x004fe400078efcffULL,
0x0000003d003f7306ULL, 0x000e640000205400ULL, 0x0000006e396e723eULL, 0x000fcc00000010ffULL,
0x0000003d003a7306ULL, 0x000ea2000020d400ULL, 0x0000003f3800720bULL, 0x002fe20003f1d000ULL,
0x000001003b387824ULL, 0x000fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fc80000011438ULL,
0x0000003f003c7306ULL, 0x000fe60000209400ULL, 0x000000013a3a0812ULL, 0x004fc800078efcffULL,
0x0000003a693a723eULL, 0x000fe200000010ffULL, 0x0000003f004b7306ULL, 0x000e700000205400ULL,
0x0000003f00387306ULL, 0x000ea2000020d400ULL, 0x0000004b3c00720bULL, 0x002fc40003f1d000ULL,
0x00000018ff3c7819ULL, 0x000fca0000011440ULL, 0x0000003c003d7306ULL, 0x000fec0000209400ULL,
0x0000000138380812ULL, 0x004fe400078efcffULL, 0x0000003c003e7306ULL, 0x000e700000205400ULL,
0x0000003c004b7306ULL, 0x000ea2000020d400ULL, 0x0000003e3d00720bULL, 0x002fc40003f1d000ULL,
0x00000018ff3d7819ULL, 0x000fca0000011441ULL, 0x0000003d003e7306ULL, 0x000fec0000209400ULL,
0x000000014b4b0812ULL, 0x004fe400078efcffULL, 0x0000003d003f7306ULL, 0x000e700000205400ULL,
0x0000003d004a7306ULL, 0x0004e2000020d400ULL, 0x0000003f3e00720bULL, 0x002fc40003f1d000ULL,
0x00000018ff3e7819ULL, 0x000fe40000011442ULL, 0x00000018ff3d7819ULL, 0x004fc60000011444ULL,
0x0000003e003f7306ULL, 0x000fec0000209400ULL, 0x000000014a4a0812ULL, 0x008fe400078efcffULL,
0x0000003e003c7306ULL, 0x000e700000205400ULL, 0x0000003e004f7306ULL, 0x000ea2000020d400ULL,
0x0000003c3f00720bULL, 0x002fce0003f1d000ULL, 0x0000003d003e7306ULL, 0x000fe20000205400ULL,
0x00000018ff3c7819ULL, 0x000fce0000011443ULL, 0x0000003c003f7306ULL, 0x000fe20000209400ULL,
0x000000014f4f0812ULL, 0x004fce00078efcffULL, 0x0000003c004c7306ULL, 0x000e700000205400ULL,
0x0000003c008d7306ULL, 0x000ea2000020d400ULL, 0x0000004c3f00720bULL, 0x002fce0003f1d000ULL,
0x0000003d008b7306ULL, 0x000fe2000020d400ULL, 0x00000018ff4c7819ULL, 0x000fce0000011447ULL,
0x0000003d003f7306ULL, 0x000e620000209400ULL, 0x000000018d8d0812ULL, 0x004fce00078efcffULL,
0x0000004c00897306ULL, 0x000fe2000020d400ULL, 0x0000003e3f00720bULL, 0x002fe40003f1d000ULL,
0x00000018ff3e7819ULL, 0x000fca0000011445ULL, 0x0000003e003f7306ULL, 0x000fec0000209400ULL,
0x000000018b8b0812ULL, 0x000fe400078efcffULL, 0x0000003e003c7306ULL, 0x000e700000205400ULL,
0x0000003e008a7306ULL, 0x000ea2000020d400ULL, 0x0000003c3f00720bULL, 0x002fc40003f1d000ULL,
0x00000018ff3f7819ULL, 0x000fca0000011446ULL, 0x0000003f003c7306ULL, 0x000fec0000209400ULL,
0x000000018a8a0812ULL, 0x004fe400078efcffULL, 0x0000003f003d7306ULL, 0x000e700000205400ULL,
0x0000003f00887306ULL, 0x000ea2000020d400ULL, 0x0000003d3c00720bULL, 0x002fce0003f1d000ULL,
0x0000004c003c7306ULL, 0x000ff00000209400ULL, 0x0000004c003d7306ULL, 0x000e620000205400ULL,
0x0000000188880812ULL, 0x004fe400078efcffULL, 0x0000003d3c00720bULL, 0x002fe20003f1d000ULL,
0x00000100403c7824ULL, 0x000fc400078e00ffULL, 0x0001000040407824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000003c003d7306ULL, 0x000fe60000209400ULL, 0x0000000189890812ULL, 0x000fca00078efcffULL,
0x0000003c003e7306ULL, 0x000e700000205400ULL, 0x0000003c003f7306ULL, 0x000ea2000020d400ULL,
0x0000003e3d00720bULL, 0x002fce0003f1d000ULL, 0x0000004000547306ULL, 0x000ff0000020d400ULL,
0x00000040003d7306ULL, 0x000fe20000209400ULL, 0x000000013f3f0812ULL, 0x004fce00078efcffULL,
0x00000040003e7306ULL, 0x000e620000205400ULL, 0x000000583f58723eULL, 0x000fe400000010ffULL,
0x0000003e3d00720bULL, 0x002fe20003f1d000ULL, 0x00000100413d7824ULL, 0x040fe400078e00ffULL,
0x0001000041417824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000003d003c7306ULL, 0x000fe60000209400ULL,
0x0000000154540812ULL, 0x000fc800078efcffULL, 0x000000544b54723eULL, 0x000fe200000010ffULL,
0x0000003d004d7306ULL, 0x000e700000205400ULL, 0x0000003d003e7306ULL, 0x000ea2000020d400ULL,
0x0000004d3c00720bULL, 0x002fce0003f1d000ULL, 0x0000004100557306ULL, 0x000ff0000020d400ULL,
0x00000041003c7306ULL, 0x000fe20000209400ULL, 0x000000013e3e0812ULL, 0x004fce00078efcffULL,
0x00000041004d7306ULL, 0x000e620000205400ULL, 0x000000593e59723eULL, 0x000fe400000010ffULL,
0x0000004d3c00720bULL, 0x002fe20003f1d000ULL, 0x00000100423c7824ULL, 0x040fe400078e00ffULL,
0x0001000042427824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x0000003c003d7306ULL, 0x000fe60000209400ULL,
0x0000000155550812ULL, 0x000fc800078efcffULL, 0x000000554a55723eULL, 0x000fe200000010ffULL,
0x0000003c00407306ULL, 0x000e700000205400ULL, 0x0000003c004d7306ULL, 0x000ea2000020d400ULL,
0x000000403d00720bULL, 0x002fce0003f1d000ULL, 0x00000042004c7306ULL, 0x000ff0000020d400ULL,
0x00000042003d7306ULL, 0x000fe20000209400ULL, 0x000000014d4d0812ULL, 0x004fce00078efcffULL,
0x0000004200407306ULL, 0x000e620000205400ULL, 0x000000504d50723eULL, 0x000fe400000010ffULL,
0x000000403d00720bULL, 0x002fe20003f1d000ULL, 0x00000100433d7824ULL, 0x040fe400078e00ffULL,
0x0001000043437824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000003d003c7306ULL, 0x000fe60000209400ULL,
0x000000014c4c0812ULL, 0x000fc800078efcffULL, 0x0000004c4f4c723eULL, 0x000fe200000010ffULL,
0x0000003d00417306ULL, 0x000e700000205400ULL, 0x0000003d00407306ULL, 0x000ea2000020d400ULL,
0x000000413c00720bULL, 0x002fce0003f1d000ULL, 0x0000004300427306ULL, 0x000ff0000020d400ULL,
0x00000043003c7306ULL, 0x000fe20000209400ULL, 0x0000000140400812ULL, 0x004fce00078efcffULL,
0x0000004300417306ULL, 0x000e620000205400ULL, 0x000000514051723eULL, 0x000fe400000010ffULL,
0x000000413c00720bULL, 0x002fe20003f1d000ULL, 0x00000100443c7824ULL, 0x040fe400078e00ffULL,
0x0001000044447824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000003c003d7306ULL, 0x000fe60000209400ULL,
0x0000000142420812ULL, 0x000fc800078efcffULL, 0x000000428d4d723eULL, 0x000fe200000010ffULL,
0x0000003c004e7306ULL, 0x000e700000205400ULL, 0x0000003c008e7306ULL, 0x000ea2000020d400ULL,
0x0000004e3d00720bULL, 0x002fce0003f1d000ULL, 0x0000004400907306ULL, 0x000ff0000020d400ULL,
0x00000044003d7306ULL, 0x000fe20000209400ULL, 0x000000018e8e0812ULL, 0x004fce00078efcffULL,
0x00000044004e7306ULL, 0x000e620000205400ULL, 0x000000498e4a723eULL, 0x000fe400000010ffULL,
0x0000004e3d00720bULL, 0x002fe20003f1d000ULL, 0x00000100453d7824ULL, 0x040fe400078e00ffULL,
0x0001000045457824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000003d003c7306ULL, 0x000fe60000209400ULL,
0x0000000190900812ULL, 0x000fca00078efcffULL, 0x0000003d00417306ULL, 0x000e700000205400ULL,
0x0000003d00437306ULL, 0x000ea2000020d400ULL, 0x000000413c00720bULL, 0x002fce0003f1d000ULL,
0x00000045008f7306ULL, 0x000ff0000020d400ULL, 0x00000045003c7306ULL, 0x000fe20000209400ULL,
0x0000000143430812ULL, 0x004fce00078efcffULL, 0x0000004500417306ULL, 0x000e620000205400ULL,
0x00000048434b723eULL, 0x000fe400000010ffULL, 0x000000413c00720bULL, 0x002fe20003f1d000ULL,
0x00000100463c7824ULL, 0x040fe400078e00ffULL, 0x0001000046467824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000003c003d7306ULL, 0x000fe60000209400ULL, 0x000000018f8f0812ULL, 0x000fc800078efcffULL,
0x0000008f8a45723eULL, 0x000fe200000010ffULL, 0x0000003c00447306ULL, 0x000e700000205400ULL,
0x0000003c00927306ULL, 0x000ea2000020d400ULL, 0x000000443d00720bULL, 0x002fce0003f1d000ULL,
0x0000004600917306ULL, 0x000ff0000020d400ULL, 0x00000046003d7306ULL, 0x000fe20000209400ULL,
0x0000000192920812ULL, 0x004fce00078efcffULL, 0x0000004600447306ULL, 0x000e620000205400ULL,
0x000000879240723eULL, 0x000fce00000010ffULL, 0x0000003b00877306ULL, 0x000fe2000000d400ULL,
0x000000443d00720bULL, 0x002fe20003f1d000ULL, 0x00000100473d7824ULL, 0x000fe200078e00ffULL,
0x000000908b44723eULL, 0x000fe200000010ffULL, 0x0001000047477824ULL, 0x000fc800078e00ffULL,
0x0000003b008b7306ULL, 0x000fe20000005400ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff477819ULL, 0x000fca0000011447ULL, 0x0000003d003c7306ULL, 0x000fe20000209400ULL,
0x0000000191910812ULL, 0x000fc800078efcffULL, 0x000000918888723eULL, 0x000fc600000010ffULL,
0x0000003d00417306ULL, 0x000e700000205400ULL, 0x0000003d00947306ULL, 0x0004e2000020d400ULL,
0x000000413c00720bULL, 0x002fe20003f1d000ULL, 0x000000086c3d7824ULL, 0x004fcc00078e00ffULL,
0x00000047003c7306ULL, 0x000fe20000209400ULL, 0x000000086c6c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83d687812ULL, 0x000fc800078ee268ULL, 0xfffffff86c677812ULL, 0x000fe400078ee267ULL,
0x0000004700417306ULL, 0x000e620000205400ULL, 0x0000000194940812ULL, 0x008fce00078efcffULL,
0x0000004700967306ULL, 0x000ea2000020d400ULL, 0x000000413c00720bULL, 0x002fce0003f1d000ULL,
0x0000003b006c7306ULL, 0x000e620000009400ULL, 0x00012000683c7811ULL, 0x000fe400078e20ffULL,
0x000000859441723eULL, 0x000fe200000010ffULL, 0x000100003b857824ULL, 0x000fe400078e00ffULL,
0x000000003c5c783bULL, 0x0007260000000200ULL, 0x00000018ff8a7819ULL, 0x000fe40000011485ULL,
0x0000007b8685723eULL, 0x000fc400000010ffULL, 0x0000008a008d7306ULL, 0x000fe20000209400ULL,
0x00012000673c7811ULL, 0x008fe400078e20ffULL, 0x0000000196960812ULL, 0x004fe400078efcffULL,
0x0000008b6c00720bULL, 0x002fe40003f1d000ULL, 0x000000003c3c783bULL, 0x000e620000000200ULL,
0x0000008a00867306ULL, 0x000ea20000205400ULL, 0x00000018ff7b7819ULL, 0x000fe4000001143bULL,
0x000000968989723eULL, 0x000fca00000010ffULL, 0x0000008a003b7306ULL, 0x000ee4000020d400ULL,
0x0000000187870812ULL, 0x000fc800078efcffULL, 0x00000087386f723eULL, 0x000fe400000010ffULL,
0x0000007b006c7306ULL, 0x000fe20000209400ULL, 0x000000868d00720bULL, 0x004fce0003f1d000ULL,
0x0000007b007d7306ULL, 0x000ea20000205400ULL, 0x000000095c5c9231ULL, 0x090fe400003400ffULL,
0x000000095e5e9231ULL, 0x000fe400003400ffULL, 0x000000085d5d9231ULL, 0x080fe200003400ffULL,
0x000000013b3b0812ULL, 0x008fe200078efcffULL, 0x000000085f5f9231ULL, 0x000fce00003400ffULL,
0x0000004c5c4c723cULL, 0x040f6200000418ffULL, 0x000000093c3c9231ULL, 0x082fe200003400ffULL,
0x0000007d6c00720bULL, 0x004fe20003f1d000ULL, 0x000000093e3e9231ULL, 0x000fe200003400ffULL,
0x00000079706c723eULL, 0x000fe200000010ffULL, 0x000000083d3d9231ULL, 0x080fe400003400ffULL,
0x000000083f3f9231ULL, 0x000fe200003400ffULL, 0x000000585c58723cULL, 0x000f6200000418ffULL,
0x000000ff8c00720cULL, 0x000fce0003f25270ULL, 0x000000545c54723cULL, 0x000f7000000418ffULL,
0x000000743c4c723cULL, 0x020be4000004184cULL, 0x0000007b00747306ULL, 0x020e6c000020d400ULL,
0x000000505c50723cULL, 0x040f7000000418ffULL, 0x0000004a5c48723cULL, 0x000f6200000418ffULL,
0x0000000174740812ULL, 0x002fc800078efcffULL, 0x0000003b743b723eULL, 0x000fc600000010ffULL,
0x000000445c44723cULL, 0x040f7000000418ffULL, 0x000000405c40723cULL, 0x040f7000000418ffULL,
0x000000885c5c723cULL, 0x000f7000000418ffULL, 0x000000843c58723cULL, 0x040b700000041858ULL,
0x000000823c54723cULL, 0x040b700000041854ULL, 0x000000763c50723cULL, 0x060b700000041850ULL,
0x000000723c48723cULL, 0x040b700000041848ULL, 0x0000006c3c44723cULL, 0x040b700000041844ULL,
0x0000006e3c40723cULL, 0x040b700000041840ULL, 0x0000003a3c5c723cULL, 0x000b62000004185cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0000800000ULL,
0x0000005812127221ULL, 0x000fe40000010000ULL, 0x0000005913137221ULL, 0x000fc40000010000ULL,
0x0000005416167221ULL, 0x000fe40000010000ULL, 0x0000005517177221ULL, 0x000fe40000010000ULL,
0x000000501a1a7221ULL, 0x020fe40000010000ULL, 0x000000511b1b7221ULL, 0x000fe40000010000ULL,
0x0000004c1e1e7221ULL, 0x000fe40000010000ULL, 0x0000004d1f1f7221ULL, 0x000fc40000010000ULL,
0x0000004822227221ULL, 0x000fe40000010000ULL, 0x0000004923237221ULL, 0x000fe40000010000ULL,
0x0000004426267221ULL, 0x000fe40000010000ULL, 0x0000004527277221ULL, 0x000fe40000010000ULL,
0x000000402a2a7221ULL, 0x000fe40000010000ULL, 0x000000412b2b7221ULL, 0x000fc40000010000ULL,
0x0000005c2e2e7221ULL, 0x000fe40000010000ULL, 0x0000005d2f2f7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0003000000ULL, 0x0000005a14147221ULL, 0x000fe40000010000ULL,
0x0000005b15157221ULL, 0x000fe40000010000ULL, 0x0000005618187221ULL, 0x000fe40000010000ULL,
0x0000005719197221ULL, 0x000fe40000010000ULL, 0x000000521c1c7221ULL, 0x020fc40000010000ULL,
0x000000531d1d7221ULL, 0x000fe40000010000ULL, 0x0000004e20207221ULL, 0x000fe40000010000ULL,
0x0000004f21217221ULL, 0x000fe40000010000ULL, 0x0000004a24247221ULL, 0x000fe40000010000ULL,
0x0000004b25257221ULL, 0x000fe40000010000ULL, 0x0000004628287221ULL, 0x000fc40000010000ULL,
0x0000004729297221ULL, 0x000fe40000010000ULL, 0x000000422c2c7221ULL, 0x000fe40000010000ULL,
0x000000432d2d7221ULL, 0x000fe40000010000ULL, 0x0000005e30307221ULL, 0x000fe40000010000ULL,
0x0000005f31317221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff387f8cULL, 0x000e62000c80043fULL, 0x00000004ff697424ULL, 0x000fca00078e00ffULL,
0x0000000169697807ULL, 0x000fc80006800000ULL, 0x000000696a00720cULL, 0x000fe20003f06070ULL,
0x000000ffff3c7224ULL, 0x022fd800078e0039ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff891000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000400f397811ULL, 0x000fe200078e40ffULL, 0x018b5800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000603900720cULL, 0x000fda0003f06070ULL, 0x00015c3000000947ULL, 0x000fea0003800000ULL,
0x000000ffff6a7224ULL, 0x000fca00078e00ffULL, 0x00000002ff397819ULL, 0x000fe2000001166aULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000036a3a7812ULL, 0x040fe200078ec0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x000000396a397207ULL, 0x000fe40002800000ULL,
0x000000ff3a407207ULL, 0x000fe40006800000ULL, 0x0000000139387810ULL, 0x000fc80007ffe0ffULL,
0x0000000338417812ULL, 0x040fe400078ec0ffULL, 0x0000000f38437211ULL, 0x000fc400078ff0ffULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x018b8c00ff3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff3b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000143397810ULL, 0x000fe20007ffe0ffULL,
0x0000099000017945ULL, 0x000fe60003800000ULL, 0x000000363900720cULL, 0x000fda0003f06070ULL,
0x0000052000008947ULL, 0x000fea0003800000ULL, 0x00000005073f7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000443397824ULL, 0x000fe200078e0241ULL, 0x00000020353e7811ULL, 0x000fe200078e30ffULL,
0x00000010323b7824ULL, 0x000fe200078e00ffULL, 0x00000002074b7810ULL, 0x000fe20007ffe0ffULL,
0x018a00003f3a7984ULL, 0x000e620000004800ULL, 0x0000002039397811ULL, 0x000fe200078e30ffULL,
0x00000100ff457424ULL, 0x000fe200078e00ffULL, 0x000000f03b477812ULL, 0x000fe200078ec0ffULL,
0x000000013f3b7824ULL, 0x040fe200078e0232ULL, 0x0000003960387217ULL, 0x000fe20007800000ULL,
0x000000103f427824ULL, 0x000fe200078e00ffULL, 0x000000054b4d7c10ULL, 0x000fc6000fffe0ffULL,
0x0000000138387824ULL, 0x000fe400078e0a39ULL, 0x000000013f397824ULL, 0x000fc600078e023eULL,
0x0000000538387c17ULL, 0x000fc8000f800000ULL, 0x80000005383c7c10ULL, 0x000fc8000fffe0ffULL,
0x0000003c0700720cULL, 0x000fe20003f06070ULL, 0x018ac0003a3a7984ULL, 0x002e640000004800ULL,
0x0000003a0d397224ULL, 0x002fc800078e0239ULL, 0x00005e0039387625ULL, 0x000fca00078e0045ULL,
0x00000047383a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffff042387812ULL, 0x000fe200078ee23bULL,
0x000000014d427824ULL, 0x040fe400078e0232ULL, 0x000000ffff3b7224ULL, 0x000fe200008e0639ULL,
0x0001600038497811ULL, 0x000fe200078e20ffULL, 0x000000014d397824ULL, 0x040fe400078e023eULL,
0x000000104d4d7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a497faeULL, 0x0003e2000c101c4aULL, 0x0000003c4b00720cULL, 0x000fc40003f06070ULL,
0xfffffff04d427812ULL, 0x000fe200078ee242ULL, 0x018a08003f3d7984ULL, 0x000ea20000004800ULL,
0x00000004074b7810ULL, 0x000fc80007ffe0ffULL, 0x000000054b4d7c10ULL, 0x000fe4000fffe0ffULL,
0x0001600042497811ULL, 0x002fc600078e20ffULL, 0x000000014d427824ULL, 0x000fe200078e0232ULL,
0x018ac0003d387984ULL, 0x004e640000004800ULL, 0x000000380d387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff3b7224ULL, 0x000fe400008e0639ULL, 0x000000014d397824ULL, 0x040fe400078e023eULL,
0x000000104d4d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a497faeULL, 0x0003e2000c101c4aULL, 0x0000003c4b00720cULL, 0x000fe40003f06070ULL,
0x00000006074b7810ULL, 0x000fe20007ffe0ffULL, 0x018a10003f3d7984ULL, 0x000ea20000004800ULL,
0xfffffff04d427812ULL, 0x000fc400078ee242ULL, 0x000000054b4d7c10ULL, 0x000fe4000fffe0ffULL,
0x0001600042497811ULL, 0x002fc600078e20ffULL, 0x000000014d3e7824ULL, 0x000fe200078e023eULL,
0x018ac0003d387984ULL, 0x004e640000004800ULL, 0x000000380d387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff3b7224ULL, 0x000fca00008e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a497faeULL, 0x0003e2000c101c4aULL, 0x0000003c4b00720cULL, 0x000fc60003f06070ULL,
0x018a18003f3d7984ULL, 0x000ea80000004800ULL, 0x018ac0003d387984ULL, 0x004ea40000004800ULL,
0x000000380d387224ULL, 0x004fe400078e023eULL, 0x000000014d3e7824ULL, 0x000fe400078e0232ULL,
0x00005e0038387625ULL, 0x000fc800078e0045ULL, 0x000000104d4d7824ULL, 0x000fe200078e00ffULL,
0x0000004738387210ULL, 0x000fc80007f3e0ffULL, 0xfffffff04d3e7812ULL, 0x000fe200078ee23eULL,
0x000000ffff397224ULL, 0x000fc600008e0639ULL, 0x000160003e3b7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e2000c101c4aULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x0000000507457c10ULL, 0x000fe2000fffe0ffULL,
0x0000001032397824ULL, 0x000fe200078e00ffULL, 0x0000002035427811ULL, 0x000fe200078e30ffULL,
0x00000100ff477424ULL, 0x000fe200078e00ffULL, 0x00000002453d7810ULL, 0x000fe20007ffe0ffULL,
0x018a0000453c7984ULL, 0x000e620000004800ULL, 0x000000f039497812ULL, 0x000fe200078ec0ffULL,
0x0000000145387824ULL, 0x040fe400078e0242ULL, 0x00000001453b7824ULL, 0x000fc400078e0232ULL,
0x00000010453e7824ULL, 0x000fe400078e00ffULL, 0x000000013d447824ULL, 0x000fe200078e0232ULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff03e387812ULL, 0x000fc600078ee23bULL, 0x000000ffff3b7224ULL, 0x000fe200000e0639ULL,
0x00016000383f7811ULL, 0x000fe200078e20ffULL, 0x0000000142387824ULL, 0x000fe400078e023dULL,
0x000000103d3d7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3f7faeULL, 0x0003e6000b901c4aULL, 0xfffffff03d447812ULL, 0x000fe200078ee244ULL,
0x018a0800453e7984ULL, 0x000ea60000004800ULL, 0x00016000443f7811ULL, 0x002fc400078e20ffULL,
0x00000004453b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b447824ULL, 0x000fe200078e0232ULL,
0x018ac0003e3e7984ULL, 0x004e640000004800ULL, 0x0000003e0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000142387824ULL, 0x000fe400078e023bULL, 0x000000103b3b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e0639ULL, 0xfffffff03b447812ULL, 0x000fe400078ee244ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c3f7faeULL, 0x0003e8000b901c4aULL,
0x018a1000453e7984ULL, 0x000ea20000004800ULL, 0x00016000443d7811ULL, 0x002fe400078e20ffULL,
0x00000006453f7810ULL, 0x000fe20007ffe0ffULL, 0x018ac0003e3e7984ULL, 0x004e640000004800ULL,
0x0000003e0d387224ULL, 0x002fc400078e0238ULL, 0x000000013f3e7824ULL, 0x000fe400078e0232ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000142387824ULL, 0x000fe400078e023fULL, 0x000000103f3f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600000e0639ULL, 0xfffffff03f3e7812ULL, 0x000fe400078ee23eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c4aULL,
0x018a1800453c7984ULL, 0x000ea20000004800ULL, 0x000160003e3b7811ULL, 0x002fc600078e20ffULL,
0x018ac0003c3c7984ULL, 0x004e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x0000004938387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c4aULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000433400720cULL, 0x000fe20003f04070ULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000034000780cULL, 0x000fda0003f25270ULL, 0x0000010000008947ULL, 0x000fea0000800000ULL,
0x000000030c00780cULL, 0x000fe40003f04070ULL, 0x000000010e0e7810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000397919ULL, 0x000e620000002700ULL,
0x000000370e00720cULL, 0x000fe20003f06070ULL, 0x00000004ff3b7424ULL, 0x000fe200078e00ffULL,
0x00018ac00c3d7811ULL, 0x000fe200078e10ffULL, 0x0000000439387824ULL, 0x002fe200078e020cULL,
0x000064000e397a10ULL, 0x000fc60007ffe0ffULL, 0x0000000238387824ULL, 0x000fc800078e00ffULL,
0x0000640038387a24ULL, 0x000fc800078e0239ULL, 0x0000600038387625ULL, 0x000fca00078e003bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383d7faeULL, 0x0003e4000c12184aULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000433400720cULL, 0x000fe40003f04070ULL,
0x0000000140387810ULL, 0x002fc80007ffe0ffULL, 0x0000000338397812ULL, 0x000fc800078ec0ffULL,
0x000000ff39397207ULL, 0x000fc60004000000ULL, 0x00000002ff388819ULL, 0x000fca0000011638ULL,
0x0000000141387824ULL, 0x000fc800078e0238ULL, 0x00000040383a7824ULL, 0x040fe200078e00ffULL,
0x0000004338387211ULL, 0x000fc800078ff0ffULL, 0x000000c03a3b7812ULL, 0x000fca00078ec0ffULL,
0x00000100383d7824ULL, 0x000fe200078e023bULL, 0x0000000c39387c10ULL, 0x000fc6000fffe0ffULL,
0x000000010c3b7824ULL, 0x100fe400078e023dULL, 0x0000680038397a24ULL, 0x000fe400078e023dULL,
0x00000004ff387424ULL, 0x000fe200078e00ffULL, 0x000000603b00720cULL, 0x000fe20003f06070ULL,
0x000000010c397824ULL, 0x040fe200078e0239ULL, 0x00018a000c3b7811ULL, 0x000fc600078e10ffULL,
0x0000660039387625ULL, 0x000fd000078e0038ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000c12184aULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8000ff387f8cULL, 0x000e62000c80043fULL, 0x000000ff6a00720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff6b7224ULL, 0x002fd600078e0039ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018af800ff387f8cULL, 0x000e64000c800405ULL, 0x000000ffff3c7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018afc05ff0b7984ULL, 0x000e640008000800ULL,
0x800000000bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc8000001143bULL, 0x0000003a0b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff3a7224ULL, 0x000fca00000e063bULL, 0x000000020b0b7819ULL, 0x000fc8000000123aULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x018afc05ff0b7984ULL, 0x000e640008000800ULL, 0x800000000bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00000010320b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff387819ULL, 0x000fc80000011632ULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c38387812ULL, 0x000fca00078ec0ffULL, 0x000000010b3f7824ULL, 0x000fca00078e0238ULL,
0x018080003f3b7984ULL, 0x000e680000000800ULL, 0x018280003f3a7984ULL, 0x0004e20000000800ULL,
0x000000103b00720bULL, 0x002fe20003f1d000ULL, 0x0001e4027f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0b427812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fd200078e0010ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000013300780cULL, 0x000fe40003f05270ULL, 0x000000103b00720bULL, 0x000fe20003f34000ULL,
0x0001e3d27f007947ULL, 0x000fd8000b800000ULL, 0x00000000003d7806ULL, 0x000fc400008e0100ULL,
0x0000003b103c7209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x000099103d387816ULL, 0x000fc600000000ffULL, 0x0184803c3f008388ULL, 0x0003e20000000800ULL,
0x000000ff3800720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000003c10107221ULL, 0x002fe20000010000ULL, 0x000000ff3dff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000447308ULL, 0x000e640000000800ULL, 0x0000004411117220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0001e3327f007947ULL, 0x000fea000b800000ULL,
0x00001f6244107589ULL, 0x0002a400000e0000ULL, 0x0000001012127220ULL, 0x084fe40000410000ULL,
0x0000001013137220ULL, 0x080fe40000410000ULL, 0x0000001016167220ULL, 0x080fe40000410000ULL,
0x0000001017177220ULL, 0x080fe40000410000ULL, 0x000000101a1a7220ULL, 0x080fe40000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x000000101e1e7220ULL, 0x080fe40000410000ULL,
0x000000101f1f7220ULL, 0x080fe40000410000ULL, 0x0000001022227220ULL, 0x080fe40000410000ULL,
0x0000001023237220ULL, 0x080fe40000410000ULL, 0x0000001026267220ULL, 0x080fe40000410000ULL,
0x0000001027277220ULL, 0x000fc40000410000ULL, 0x000000102a2a7220ULL, 0x080fe40000410000ULL,
0x000000102b2b7220ULL, 0x080fe40000410000ULL, 0x000000102e2e7220ULL, 0x080fe40000410000ULL,
0x000000102f2f7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff003dff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0001e2627f007947ULL, 0x000fea000b800000ULL, 0x00001f6144107589ULL, 0x00046400000e0000ULL,
0x0000001014147220ULL, 0x082fe40000410000ULL, 0x0000001015157220ULL, 0x080fe40000410000ULL,
0x0000001018187220ULL, 0x080fe40000410000ULL, 0x0000001019197220ULL, 0x080fe40000410000ULL,
0x000000101c1c7220ULL, 0x080fe40000410000ULL, 0x000000101d1d7220ULL, 0x000fc40000410000ULL,
0x0000001020207220ULL, 0x080fe40000410000ULL, 0x0000001021217220ULL, 0x080fe40000410000ULL,
0x0000001024247220ULL, 0x080fe40000410000ULL, 0x0000001025257220ULL, 0x080fe40000410000ULL,
0x0000001028287220ULL, 0x080fe40000410000ULL, 0x0000001029297220ULL, 0x000fc40000410000ULL,
0x000000102c2c7220ULL, 0x080fe40000410000ULL, 0x000000102d2d7220ULL, 0x080fe40000410000ULL,
0x0000001030307220ULL, 0x080fe40000410000ULL, 0x0000001031317220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff42ff7812ULL, 0x000fda000780603dULL,
0x8000003c3b3b0221ULL, 0x000fe20000010000ULL, 0x00007610ff0b0816ULL, 0x000fc6000000000bULL,
0x3fb8aa3b3b3b0820ULL, 0x000fc80000410000ULL, 0x0000003b000a0308ULL, 0x000e640000000800ULL,
0x0000000a3a3a0220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x000000113a117221ULL, 0x008fe40000010000ULL, 0x000000ffff107224ULL, 0x000fc400078e003cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff0bff7812ULL, 0x000fe2000786c0ffULL,
0x0000016000017945ULL, 0x000fd80003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x0000000aff08723eULL, 0x000fc800000010ffULL, 0x00005410083a7816ULL, 0x000fe20000000008ULL,
0x0001e0c27f007947ULL, 0x000fea000b800000ULL, 0x00001f623a097589ULL, 0x0002e400000e0000ULL,
0x0001e1227f007947ULL, 0x000fea000b800000ULL, 0x00001f613a087589ULL, 0x0002a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010623f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0000b15000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0001f00000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018623f7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff407424ULL, 0x000fe200078e00ffULL, 0x0000b1c000387802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0001ef9000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000000640783bULL, 0x002e620000004200ULL, 0x00001e9000017945ULL, 0x000fe60003800000ULL,
0x000000000444783bULL, 0x004fe80000004200ULL, 0x00000000053c783bULL, 0x000ea80000004200ULL,
0x000000000338783bULL, 0x000f220000004200ULL, 0x00000018ff4d7819ULL, 0x002fe20000011443ULL,
0x0000010040797824ULL, 0x000fe200078e00ffULL, 0x0000004000cf7306ULL, 0x000fe20000009400ULL,
0x00000018ff4a7819ULL, 0x000fc40000011440ULL, 0x00000018ff4b7819ULL, 0x000fe40000011441ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000018ff7a7819ULL, 0x004fe2000001143dULL,
0x0000004d00c07306ULL, 0x000fe20000209400ULL, 0x00000018ff7f7819ULL, 0x000fe4000001143eULL,
0x00000018ff587819ULL, 0x010fe4000001143aULL, 0x00000018ff5c7819ULL, 0x000fc4000001143bULL,
0x00000018ff4c7819ULL, 0x000fe20000011442ULL, 0x0000004d00c37306ULL, 0x000fe20000205400ULL,
0x00000018ff807819ULL, 0x000fce000001143fULL, 0x0000004d005a7306ULL, 0x0003f0000020d400ULL,
0x0000007a00a37306ULL, 0x000fe20000209400ULL, 0x00000018ff4d7819ULL, 0x002fce0000011447ULL,
0x0000004d00b07306ULL, 0x000ff00000209400ULL, 0x0000004d00b17306ULL, 0x000ff00000205400ULL,
0x0000004d00747306ULL, 0x000ff0000020d400ULL, 0x0000007a00a27306ULL, 0x000ff00000205400ULL,
0x0000007a004d7306ULL, 0x000ff0000020d400ULL, 0x00000079007a7306ULL, 0x000ff00000209400ULL,
0x0000007900d17306ULL, 0x000e700000205400ULL, 0x0000005800757306ULL, 0x000ff00000209400ULL,
0x0000005800767306ULL, 0x000fe20000205400ULL, 0x000000d17a00720bULL, 0x002fce0003f5d000ULL,
0x00000058006c7306ULL, 0x000ff0000020d400ULL, 0x0000005c00777306ULL, 0x000ff00000209400ULL,
0x0000005c00787306ULL, 0x000ff00000205400ULL, 0x0000005c006d7306ULL, 0x000ff0000020d400ULL,
0x0000007f009f7306ULL, 0x000ff00000209400ULL, 0x0000007f00587306ULL, 0x000ff00000205400ULL,
0x0000007f005c7306ULL, 0x0003f0000020d400ULL, 0x0000004000ca7306ULL, 0x000ea20000005400ULL,
0x00000100417f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000007900b37306ULL, 0x000330000020d400ULL, 0x0000007f00ce7306ULL, 0x000fe20000209400ULL,
0x0000010042797824ULL, 0x002fe200078e00ffULL, 0x000000cacf00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000007f00d57306ULL, 0x000e620000205400ULL,
0x00000001b3b32812ULL, 0x010fce00078efcffULL, 0x0000004000a87306ULL, 0x000530000000d400ULL,
0x0000004a00cd7306ULL, 0x000fe20000209400ULL, 0x0001000040407824ULL, 0x004fe200078e00ffULL,
0x000000d5ce00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000004a00c87306ULL, 0x000e620000205400ULL, 0x00000001a8a86812ULL, 0x010fce00078efcffULL,
0x0000004a00a07306ULL, 0x000530000020d400ULL, 0x0000004100c47306ULL, 0x000fe20000009400ULL,
0x00000018ff4a7819ULL, 0x004fe40000011444ULL, 0x000000c8cd00720bULL, 0x002fca0003f3d000ULL,
0x0000004100c97306ULL, 0x000e700000005400ULL, 0x0000004b00c77306ULL, 0x000fe20000209400ULL,
0x00000001a0a01812ULL, 0x010fce00078efcffULL, 0x0000004b00c27306ULL, 0x000ea20000205400ULL,
0x000000c9c400720bULL, 0x002fce0003fdd000ULL, 0x0000004b009e7306ULL, 0x000330000020d400ULL,
0x0000004a00b87306ULL, 0x000fe20000209400ULL, 0x00000018ff4b7819ULL, 0x002fe40000011445ULL,
0x000000c2c700720bULL, 0x004fca0003f3d000ULL, 0x0000004a00bd7306ULL, 0x000ff00000205400ULL,
0x0000004a00887306ULL, 0x0003e2000020d400ULL, 0x000000019e9e1812ULL, 0x010fce00078efcffULL,
0x0000004200be7306ULL, 0x000fe20000009400ULL, 0x00000018ff4a7819ULL, 0x002fce0000011438ULL,
0x0000004200c57306ULL, 0x000ff00000005400ULL, 0x00000042009c7306ULL, 0x0003f0000000d400ULL,
0x0000007f00af7306ULL, 0x000522000020d400ULL, 0x0001000042427824ULL, 0x002fce00078e00ffULL,
0x0000007900d97306ULL, 0x000fe20000209400ULL, 0x00000018ff7f7819ULL, 0x004fe20000011442ULL,
0x0000010043427824ULL, 0x000fcc00078e00ffULL, 0x0000007900d27306ULL, 0x000e620000205400ULL,
0x00000001afaf2812ULL, 0x010fce00078efcffULL, 0x0000004c00cb7306ULL, 0x000ff00000209400ULL,
0x0000004c00c67306ULL, 0x000ea20000205400ULL, 0x000000d2d900720bULL, 0x002fce0003f5d000ULL,
0x0000004c005b7306ULL, 0x000330000020d400ULL, 0x0000004b00ba7306ULL, 0x000fe20000209400ULL,
0x00000018ff4c7819ULL, 0x002fe40000011446ULL, 0x000000c6cb00720bULL, 0x004fca0003f3d000ULL,
0x0000004b00c17306ULL, 0x000e700000205400ULL, 0x0000004b00847306ULL, 0x0004e2000020d400ULL,
0x000000015b5b1812ULL, 0x010fe400078efcffULL, 0x000000c3c000720bULL, 0x000fca0003f3d000ULL,
0x0000004a00527306ULL, 0x000fe20000209400ULL, 0x00000018ff4b7819ULL, 0x004fce0000011439ULL,
0x0000004a00537306ULL, 0x000fe20000205400ULL, 0x000000015a5a1812ULL, 0x000fe400078efcffULL,
0x000000bdb800720bULL, 0x000fca0003f3d000ULL, 0x0000004a00727306ULL, 0x0005f0000020d400ULL,
0x0000004000cc7306ULL, 0x000fe20000209400ULL, 0x00000018ff4a7819ULL, 0x004fe4000001143cULL,
0x0000000188881812ULL, 0x000fc400078efcffULL, 0x000000c1ba00720bULL, 0x002fe20003f3d000ULL,
0x000001003eba7824ULL, 0x000fe400078e00ffULL, 0x0000004000d37306ULL, 0x000e660000205400ULL,
0x00000018ffba7819ULL, 0x000fca00000114baULL, 0x0000004100a47306ULL, 0x000524000000d400ULL,
0x0000000184841812ULL, 0x008fcc00078efcffULL, 0x0000004c00b77306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x004fe200078e00ffULL, 0x000000d3cc00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004c00b47306ULL, 0x000e620000205400ULL,
0x00000001a4a46812ULL, 0x010fe400078efcffULL, 0x000000c5be00720bULL, 0x000fe20003fdd000ULL,
0x000001003dbe7824ULL, 0x000fc800078e00ffULL, 0x0000004c007e7306ULL, 0x000ea2000020d400ULL,
0x00000018ffbe7819ULL, 0x000fce00000114beULL, 0x0000004b00897306ULL, 0x000fe20000209400ULL,
0x000000019c9c6812ULL, 0x000fe400078efcffULL, 0x000000b4b700720bULL, 0x002fca0003f3d000ULL,
0x0000004b008a7306ULL, 0x000ff00000205400ULL, 0x0000004b006e7306ULL, 0x000fe2000020d400ULL,
0x000000017e7e1812ULL, 0x004fe400078efcffULL, 0x000000b1b000720bULL, 0x000fe20003f3d000ULL,
0x000001003bb17824ULL, 0x000fc400078e00ffULL, 0x000100003ab07824ULL, 0x000fe400078e00ffULL,
0x0000004a00b57306ULL, 0x000fe20000209400ULL, 0x00000018ffb17819ULL, 0x000fe400000114b1ULL,
0x00000018ffb07819ULL, 0x000fca00000114b0ULL, 0x0000004a00ac7306ULL, 0x000e620000205400ULL,
0x0000000174741812ULL, 0x000fce00078efcffULL, 0x0000004a004c7306ULL, 0x000eb0000020d400ULL,
0x00000080004b7306ULL, 0x000fe20000209400ULL, 0x000000acb500720bULL, 0x002fe20003f3d000ULL,
0x000100003bac7824ULL, 0x000fca00078e00ffULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x00000080004a7306ULL, 0x000fec0000205400ULL, 0x000000014c4c1812ULL, 0x004fe400078efcffULL,
0x00000080005d7306ULL, 0x0003f0000020d400ULL, 0x0000007900a17306ULL, 0x0004e2000020d400ULL,
0x00000018ff807819ULL, 0x002fce0000011442ULL, 0x0000008000e07306ULL, 0x000fe20000209400ULL,
0x0000010044797824ULL, 0x004fca00078e00ffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000008000e77306ULL, 0x000e620000205400ULL, 0x00000001a1a12812ULL, 0x008fce00078efcffULL,
0x0000004000a77306ULL, 0x000eb0000020d400ULL, 0x0000004100d07306ULL, 0x000fe20000209400ULL,
0x000000e7e000720bULL, 0x002fce0003f5d000ULL, 0x0000004100d77306ULL, 0x000e620000205400ULL,
0x00000001a7a70812ULL, 0x004fce00078efcffULL, 0x0000004300b67306ULL, 0x000ff00000009400ULL,
0x0000004300bf7306ULL, 0x000ea20000005400ULL, 0x000000d7d000720bULL, 0x002fce0003f1d000ULL,
0x0000008000427306ULL, 0x000e70000020d400ULL, 0x0000007900eb7306ULL, 0x000fe20000209400ULL,
0x000000bfb600720bULL, 0x004fce0003fdd000ULL, 0x0000007900e47306ULL, 0x000ea20000205400ULL,
0x0000000142422812ULL, 0x002fce00078efcffULL, 0x0000004100a57306ULL, 0x000e70000020d400ULL,
0x0000007f00de7306ULL, 0x000fe20000209400ULL, 0x000000e4eb00720bULL, 0x004fce0003f5d000ULL,
0x0000007f00e57306ULL, 0x000ea20000205400ULL, 0x00000001a5a50812ULL, 0x002fce00078efcffULL,
0x0000007f00407306ULL, 0x0003f0000020d400ULL, 0x0000004300597306ULL, 0x000722000000d400ULL,
0x00000100457f7824ULL, 0x002fe200078e00ffULL, 0x000000e5de00720bULL, 0x004fc80003f1d000ULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000004400bc7306ULL, 0x000fe20000009400ULL,
0x0001000043437824ULL, 0x008fca00078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004400bb7306ULL, 0x000e620000005400ULL, 0x0000000159596812ULL, 0x010fe400078efcffULL,
0x0000000140400812ULL, 0x000fe400078efcffULL, 0x000000594259723eULL, 0x000fe400000010ffULL,
0x0001280000427811ULL, 0x000fe200078e20ffULL, 0x0000007900937306ULL, 0x000eb0000020d400ULL,
0x0000007f00db7306ULL, 0x000fe20000209400ULL, 0x000000bbbc00720bULL, 0x002fce0003fdd000ULL,
0x0000007f00d47306ULL, 0x000e620000205400ULL, 0x0000000193932812ULL, 0x004fce00078efcffULL,
0x0000004300e27306ULL, 0x000ff00000209400ULL, 0x0000004300e97306ULL, 0x000ea20000205400ULL,
0x000000d4db00720bULL, 0x002fce0003f5d000ULL, 0x0000004300417306ULL, 0x0003f0000020d400ULL,
0x00000044005e7306ULL, 0x000722000000d400ULL, 0x0000010046437824ULL, 0x002fe200078e00ffULL,
0x000000e9e200720bULL, 0x004fc80003f1d000ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004500b27306ULL, 0x000fe20000009400ULL, 0x0001000044447824ULL, 0x008fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000004500b97306ULL, 0x000e620000005400ULL,
0x000000015e5e6812ULL, 0x010fe400078efcffULL, 0x0000000141410812ULL, 0x000fe400078efcffULL,
0x0000005e935e723eULL, 0x000fc600000010ffULL, 0x0000007f00947306ULL, 0x000eb0000020d400ULL,
0x0000004300da7306ULL, 0x000fe20000209400ULL, 0x000000b9b200720bULL, 0x002fce0003fdd000ULL,
0x0000004300e17306ULL, 0x000e620000205400ULL, 0x0000000194942812ULL, 0x004fce00078efcffULL,
0x0000004400e67306ULL, 0x000ff00000209400ULL, 0x0000004400ed7306ULL, 0x000ea20000205400ULL,
0x000000e1da00720bULL, 0x002fce0003f5d000ULL, 0x00000044008d7306ULL, 0x0003f0000020d400ULL,
0x00000045005f7306ULL, 0x000722000000d400ULL, 0x0000010047447824ULL, 0x002fe200078e00ffULL,
0x000000ede600720bULL, 0x004fc80003f1d000ULL, 0x00000018ff797819ULL, 0x000fe40000011444ULL,
0x0000004600577306ULL, 0x000fe20000009400ULL, 0x0001000045457824ULL, 0x008fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004600567306ULL, 0x000e620000005400ULL,
0x000000015f5f6812ULL, 0x010fe400078efcffULL, 0x000000018d8d0812ULL, 0x000fe400078efcffULL,
0x0000005f945f723eULL, 0x000fe400000010ffULL, 0x0000008d8888723eULL, 0x000fe200000010ffULL,
0x00000043008e7306ULL, 0x000eb0000020d400ULL, 0x0000007900d87306ULL, 0x000fe20000209400ULL,
0x000000565700720bULL, 0x002fc40003fdd000ULL, 0x0001280002567811ULL, 0x000fca00078e20ffULL,
0x0000007900dd7306ULL, 0x000e620000205400ULL, 0x000000018e8e2812ULL, 0x004fce00078efcffULL,
0x0000004600817306ULL, 0x0004f0000000d400ULL, 0x0000004500dc7306ULL, 0x000fe20000209400ULL,
0x0001000046467824ULL, 0x004fe200078e00ffULL, 0x000000ddd800720bULL, 0x002fc80003f5d000ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000004500e37306ULL, 0x000e620000205400ULL,
0x0000000181816812ULL, 0x008fc800078efcffULL, 0x000000818e8e723eULL, 0x000fc600000010ffULL,
0x00000045008b7306ULL, 0x0004f0000020d400ULL, 0x0000004700547306ULL, 0x000fe20000009400ULL,
0x0000010038457824ULL, 0x004fe200078e00ffULL, 0x000000e3dc00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff8f7819ULL, 0x000fe40000011445ULL, 0x0000004700557306ULL, 0x000e6e0000005400ULL,
0x000000018b8b0812ULL, 0x008fe200078efcffULL, 0x00000038004f7306ULL, 0x000ff00000009400ULL,
0x0000003800507306ULL, 0x000fe20000005400ULL, 0x000000555400720bULL, 0x002fc40003fdd000ULL,
0x000000005654783bULL, 0x000e6a0000000200ULL, 0x0000003800737306ULL, 0x0005f0000000d400ULL,
0x0000004600df7306ULL, 0x000fe20000209400ULL, 0x0001000038387824ULL, 0x004fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004600d67306ULL, 0x000eb00000205400ULL,
0x0000004600877306ULL, 0x000ef0000020d400ULL, 0x00000079008c7306ULL, 0x0008e2000020d400ULL,
0x000000d6df00720bULL, 0x004fe20003f1d000ULL, 0x000000095454b231ULL, 0x002fc400003400ffULL,
0x000000095656b231ULL, 0x000fe400003400ffULL, 0x000000085555b231ULL, 0x080fe400003400ffULL,
0x0000008f00457306ULL, 0x000fe20000209400ULL, 0x0000010039797824ULL, 0x010fe200078e00ffULL,
0x000000085757b231ULL, 0x000fc800003400ffULL, 0x0000000187870812ULL, 0x008fe400078efcffULL,
0x0000008f00467306ULL, 0x000e620000205400ULL, 0x000000018c8c2812ULL, 0x000fce00078efcffULL,
0x0000003800987306ULL, 0x000ff00000209400ULL, 0x00000038009b7306ULL, 0x000fe20000205400ULL,
0x000000464500720bULL, 0x002fe40003f5d000ULL, 0x000000415a45723eULL, 0x000fca00000010ffULL,
0x00000038007f7306ULL, 0x0003f0000020d400ULL, 0x0000003c00ad7306ULL, 0x000fe20000009400ULL,
0x000001003c387824ULL, 0x002fca00078e00ffULL, 0x00000018ffca7819ULL, 0x000fe40000011438ULL,
0x0000003c00ae7306ULL, 0x000ff00000005400ULL, 0x0000003c00487306ULL, 0x0003f0000000d400ULL,
0x00000047007b7306ULL, 0x0004e2000000d400ULL, 0x000100003c3c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000008f00867306ULL, 0x000322000020d400ULL,
0x0001000047477824ULL, 0x004fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000003c00c27306ULL, 0x000fe20000209400ULL, 0x000000017b7b6812ULL, 0x008fe200078efcffULL,
0x000001003a8f7824ULL, 0x002fe200078e00ffULL, 0x000000aead00720bULL, 0x000fc80003fdd000ULL,
0x00000018ffe87819ULL, 0x000fe2000001148fULL, 0x0000003c00c77306ULL, 0x000e620000205400ULL,
0x0000000186862812ULL, 0x010fce00078efcffULL, 0x0000004700447306ULL, 0x000fe20000209400ULL,
0x0000000148486812ULL, 0x000fce00078efcffULL, 0x0000004700437306ULL, 0x000ea20000205400ULL,
0x000000c7c200720bULL, 0x002fce0003f5d000ULL, 0x0000003900997306ULL, 0x000ff00000009400ULL,
0x00000039004e7306ULL, 0x000fe20000005400ULL, 0x000000434400720bULL, 0x004fce0003f1d000ULL,
0x0000003900717306ULL, 0x0003f0000000d400ULL, 0x0000003d00ab7306ULL, 0x000fe20000009400ULL,
0x0001000039397824ULL, 0x002fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003d00a67306ULL, 0x000e700000005400ULL, 0x0000003c00c57306ULL, 0x000eb0000020d400ULL,
0x000000be00bf7306ULL, 0x000fe20000209400ULL, 0x000000a6ab00720bULL, 0x002fce0003fdd000ULL,
0x000000be003c7306ULL, 0x000e620000205400ULL, 0x00000001c5c52812ULL, 0x004fc800078efcffULL,
0x000000c54c4c723eULL, 0x000fc600000010ffULL, 0x0000004700857306ULL, 0x0004f0000020d400ULL,
0x0000003900917306ULL, 0x000fe20000209400ULL, 0x00000018ff477819ULL, 0x004fe40000011479ULL,
0x0000003cbf00720bULL, 0x002fc40003f5d000ULL, 0x000000a8b33c723eULL, 0x000fc600000010ffULL,
0x0000003900927306ULL, 0x000fe20000205400ULL, 0x0000000185850812ULL, 0x008fc800078efcffULL,
0x000000857485723eULL, 0x000fc600000010ffULL, 0x0000003900797306ULL, 0x000ff0000020d400ULL,
0x000000ca00387306ULL, 0x000ff00000209400ULL, 0x000000ca00397306ULL, 0x000e700000205400ULL,
0x0000003d00497306ULL, 0x0004f0000000d400ULL, 0x0000003e00a97306ULL, 0x000fe20000009400ULL,
0x000100003d3d7824ULL, 0x004fe200078e00ffULL, 0x000000393800720bULL, 0x002fe20003f1d000ULL,
0x000001003f387824ULL, 0x000fe200078e00ffULL, 0x000000a59e39723eULL, 0x000fc400000010ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003e00aa7306ULL, 0x000fe20000005400ULL,
0x0000000149496812ULL, 0x008fe400078efcffULL, 0x000000a2a300720bULL, 0x000fe40003fdd000ULL,
0x00000018ffae7819ULL, 0x000fe40000011438ULL, 0x000000a7a038723eULL, 0x000fe200000010ffULL,
0x0000003e00977306ULL, 0x0003f0000000d400ULL, 0x000000be00b67306ULL, 0x000ea2000020d400ULL,
0x000100003e3e7824ULL, 0x002fe200078e00ffULL, 0x000000014d4d6812ULL, 0x000fc800078efcffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003d00b87306ULL, 0x000ff00000209400ULL,
0x0000003d00b97306ULL, 0x000e620000205400ULL, 0x00000001b6b62812ULL, 0x004fc400078efcffULL,
0x000000589f00720bULL, 0x000fe40003f5d000ULL, 0x0000009ca158723eULL, 0x000fe400000010ffULL,
0x00000049b649723eULL, 0x000fe200000010ffULL, 0x0000003f009d7306ULL, 0x000ff00000009400ULL,
0x0000003f009a7306ULL, 0x000fe20000005400ULL, 0x000000b9b800720bULL, 0x002fc40003f3d000ULL,
0x000000015c5c2812ULL, 0x000fca00078efcffULL, 0x0000003f00517306ULL, 0x0003f0000000d400ULL,
0x0000004700957306ULL, 0x000fe20000209400ULL, 0x000100003f3f7824ULL, 0x002fce00078e00ffULL,
0x0000004700967306ULL, 0x000ff00000205400ULL, 0x0000004700807306ULL, 0x000ff0000020d400ULL,
0x0000003e00437306ULL, 0x000ff00000209400ULL, 0x0000003e00447306ULL, 0x000e700000205400ULL,
0x000000ca00477306ULL, 0x000eb0000020d400ULL, 0x0000003d00b27306ULL, 0x000722000020d400ULL,
0x000000444300720bULL, 0x002fc40003fdd000ULL, 0x000000405b44723eULL, 0x000fe400000010ffULL,
0x000000004240783bULL, 0x000e620000000200ULL, 0x000000585458723cULL, 0x000fe400000418ffULL,
0x000000ba00bb7306ULL, 0x000fe20000209400ULL, 0x000000a4af3d723eULL, 0x008fe400000010ffULL,
0x00000018ffa47819ULL, 0x000fe4000001143fULL, 0x0000000147470812ULL, 0x004fc400078efcffULL,
0x000000aaa900720bULL, 0x000fe20003f1d000ULL, 0x000000ba00b47306ULL, 0x000ea20000205400ULL,
0x00000001b2b21812ULL, 0x010fe400078efcffULL, 0x000000484748723eULL, 0x000fe400000010ffULL,
0x000000b24d4d723eULL, 0x000fc600000010ffULL, 0x000000a4009e7306ULL, 0x000fe80000209400ULL,
0x0000000197970812ULL, 0x000fe400078efcffULL, 0x0000009a9d00720bULL, 0x000fe40003f1d000ULL,
0x000000a4009f7306ULL, 0x000ee20000205400ULL, 0x000000b4bb00720bULL, 0x004fce0003f3d000ULL,
0x0000003e00ad7306ULL, 0x000526000020d400ULL, 0x0000000151510812ULL, 0x000fe400078efcffULL,
0x000000504f00720bULL, 0x000fe20003f1d000ULL, 0x000000094040b231ULL, 0x082fe400003400ffULL,
0x000000ba00bc7306ULL, 0x000e62000020d400ULL, 0x0000009f9e00720bULL, 0x008fe20003f5d000ULL,
0x0000003c543c723cULL, 0x004f6200000418ffULL, 0x000000094242b231ULL, 0x000fc400003400ffULL,
0x000000084141b231ULL, 0x080fe400003400ffULL, 0x000000084343b231ULL, 0x000fe200003400ffULL,
0x000000a400a47306ULL, 0x000ea2000020d400ULL, 0x00000001adad6812ULL, 0x010fe400078efcffULL,
0x0000004a4b00720bULL, 0x000fe40003fdd000ULL, 0x000000ad5c5c723eULL, 0x000fe200000010ffULL,
0x000000485448723cULL, 0x000fe200000418ffULL, 0x0000000173730812ULL, 0x000fe200078efcffULL,
0x000000ae00467306ULL, 0x000fe20000209400ULL, 0x00000001bcbc1812ULL, 0x002fc400078efcffULL,
0x000000969500720bULL, 0x000fe40003f1d000ULL, 0x00000097bc50723eULL, 0x000fe400000010ffULL,
0x000000738686723eULL, 0x000fe200000010ffULL, 0x000000ae00a97306ULL, 0x000e620000205400ULL,
0x00000001a4a42812ULL, 0x004fe200078efcffULL, 0x0000005e403c723cULL, 0x020fe2000004183cULL,
0x000000535200720bULL, 0x000fe40003f5d000ULL, 0x000000015d5d6812ULL, 0x000fc400078efcffULL,
0x0000009b9800720bULL, 0x000fe20003fdd000ULL, 0x000000ae00ae7306ULL, 0x000ea2000020d400ULL,
0x000000a45d5d723eULL, 0x000fe400000010ffULL, 0x0000000180800812ULL, 0x000fe400078efcffULL,
0x000000a94600720bULL, 0x002fc60003f3d000ULL, 0x000000b1009a7306ULL, 0x000fe20000209400ULL,
0x0000000172722812ULL, 0x000fe200078efcffULL, 0x000000445444723cULL, 0x000f6200000418ffULL,
0x000000929100720bULL, 0x000fe40003f5d000ULL, 0x000000017f7f6812ULL, 0x000fe400078efcffULL,
0x0000008a8900720bULL, 0x000fe20003fdd000ULL, 0x000000b100977306ULL, 0x000e620000205400ULL,
0x0000008b8489723eULL, 0x000fe400000010ffULL, 0x000000877e84723eULL, 0x000fc400000010ffULL,
0x00000001aeae1812ULL, 0x004fe400078efcffULL, 0x0000004e9900720bULL, 0x000fe20003f3d000ULL,
0x0000003b007c7306ULL, 0x000fe20000009400ULL, 0x00000051ae51723eULL, 0x000fe200000010ffULL,
0x0000004c544c723cULL, 0x040f6200000418ffULL, 0x0000000179792812ULL, 0x000fe400078efcffULL,
0x000000016e6e6812ULL, 0x000fe400078efcffULL, 0x0000007f7272723eULL, 0x000fe200000010ffULL,
0x0000003b007d7306ULL, 0x000ea20000005400ULL, 0x000000979a00720bULL, 0x002fe20003f5d000ULL,
0x000000505450723cULL, 0x000fe200000418ffULL, 0x000000796e73723eULL, 0x000fc400000010ffULL,
0x0000000171711812ULL, 0x000fc600078efcffULL, 0x0000003a00827306ULL, 0x000fe20000009400ULL,
0x000000718087723eULL, 0x000fe200000010ffULL, 0x000000844044723cULL, 0x060fec0000041844ULL,
0x0000003a00837306ULL, 0x000e620000005400ULL, 0x0000007d7c00720bULL, 0x004fe20003fdd000ULL,
0x000000864048723cULL, 0x040fec0000041848ULL, 0x000000e8008f7306ULL, 0x000fe40000209400ULL,
0x00000072404c723cULL, 0x000fec000004184cULL, 0x000000e800907306ULL, 0x000ea20000205400ULL,
0x000000838200720bULL, 0x002fce0003f3d000ULL, 0x0000003a006f7306ULL, 0x000e70000000d400ULL,
0x0000003b00707306ULL, 0x000722000000d400ULL, 0x000000908f00720bULL, 0x004fe40003f1d000ULL,
0x0000007b8c8f723eULL, 0x000fca00000010ffULL, 0x000000b100997306ULL, 0x000ea2000020d400ULL,
0x000000385438723cULL, 0x008f6200000418ffULL, 0x000000016f6f1812ULL, 0x002fe400078efcffULL,
0x000000787700720bULL, 0x000fc80003f3d000ULL, 0x000000b000937306ULL, 0x000fe20000209400ULL,
0x0000005c5454723cULL, 0x000b6200000418ffULL, 0x0000000170706812ULL, 0x010fcc00078efcffULL,
0x000000b0005c7306ULL, 0x020e620000205400ULL, 0x0000000199992812ULL, 0x004fe200078efcffULL,
0x0000008e4058723cULL, 0x040b620000041858ULL, 0x000000016d6d1812ULL, 0x000fe400078efcffULL,
0x00000070997b723eULL, 0x000fe400000010ffULL, 0x0000006a6100720cULL, 0x000fe20003f26070ULL,
0x000000ac005e7306ULL, 0x000fe40000209400ULL, 0x000000884038723cULL, 0x000b6c0000041838ULL,
0x000000ac005f7306ULL, 0x000ea20000205400ULL, 0x0000005c9300720bULL, 0x002fc40003f5d000ULL,
0x000000016a5c7810ULL, 0x000fc80007ffe0ffULL, 0x0000005c6100720cULL, 0x000fe20004f26470ULL,
0x000000e8007a7306ULL, 0x000e70000020d400ULL, 0x000000b0005d7306ULL, 0x000ee2000020d400ULL,
0x0000005f5e00720bULL, 0x004fce0003fdd000ULL, 0x000000ac00ac7306ULL, 0x000ea2000020d400ULL,
0x000000017a7a0812ULL, 0x002fe400078efcffULL, 0x000000767500720bULL, 0x000fe40003f1d000ULL,
0x0000006f7a7a723eULL, 0x000fe400000010ffULL, 0x000000015d5d2812ULL, 0x008fe400078efcffULL,
0x0000006a6200720cULL, 0x000fc60003f46070ULL, 0x0000007a4050723cULL, 0x000b620000041850ULL,
0x0000005c6200720cULL, 0x000fe40005746470ULL, 0x00000001acac6812ULL, 0x004fe400078efcffULL,
0x0000000f3400720cULL, 0x000fe40003fc3070ULL, 0x000000016c6c0812ULL, 0x000fe400078efcffULL,
0x000000ac6d6d723eULL, 0x000fe400000010ffULL, 0x0000005d6c6c723eULL, 0x000fc400000010ffULL,
0x0000000f3400720cULL, 0x000fca0003f03070ULL, 0x0000006c4054723cULL, 0x000b620000041854ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000003c12127221ULL, 0x000fe40000010000ULL, 0x0000003d13137221ULL, 0x000fe40000010000ULL,
0x0000003816167221ULL, 0x020fe40000010000ULL, 0x0000003917177221ULL, 0x000fe40000010000ULL,
0x000000581a1a7221ULL, 0x000fe40000010000ULL, 0x000000591b1b7221ULL, 0x000fc40000010000ULL,
0x000000441e1e7221ULL, 0x000fe40000010000ULL, 0x000000451f1f7221ULL, 0x000fe40000010000ULL,
0x0000004822227221ULL, 0x000fe40000010000ULL, 0x0000004923237221ULL, 0x000fe40000010000ULL,
0x0000004c26267221ULL, 0x000fe40000010000ULL, 0x0000004d27277221ULL, 0x000fc40000010000ULL,
0x000000502a2a7221ULL, 0x000fe40000010000ULL, 0x000000512b2b7221ULL, 0x000fe40000010000ULL,
0x000000542e2e7221ULL, 0x000fe40000010000ULL, 0x000000552f2f7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000003e14147221ULL, 0x000fe40000010000ULL,
0x0000003f15157221ULL, 0x000fe40000010000ULL, 0x0000003a18187221ULL, 0x020fc40000010000ULL,
0x0000003b19197221ULL, 0x000fe40000010000ULL, 0x0000005a1c1c7221ULL, 0x000fe40000010000ULL,
0x0000005b1d1d7221ULL, 0x000fe40000010000ULL, 0x0000004620207221ULL, 0x000fe40000010000ULL,
0x0000004721217221ULL, 0x000fe40000010000ULL, 0x0000004a24247221ULL, 0x000fc40000010000ULL,
0x0000004b25257221ULL, 0x000fe40000010000ULL, 0x0000004e28287221ULL, 0x000fe40000010000ULL,
0x0000004f29297221ULL, 0x000fe40000010000ULL, 0x000000522c2c7221ULL, 0x000fe40000010000ULL,
0x000000532d2d7221ULL, 0x000fe40000010000ULL, 0x0000005630307221ULL, 0x000fc40000010000ULL,
0x0000005731317221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x020e62000c80043fULL,
0x00000002ff3b7819ULL, 0x000fe2000001165cULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000f3400720cULL, 0x000fe40003fc3070ULL, 0x0000003b5c3b7207ULL, 0x040fe40002800000ULL,
0x000000035c5c7812ULL, 0x000fe400078ec0ffULL, 0x0000000f3400720cULL, 0x000fe40003f03070ULL,
0x00000040ff587803ULL, 0x000fc40000000000ULL, 0x000000ff5c5c7207ULL, 0x000fe40006800000ULL,
0x000000013b387810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3f7224ULL, 0x000fc600078e0039ULL,
0x0000000338417812ULL, 0x040fe400078ec0ffULL, 0x0000000f38437211ULL, 0x000fc400078ff0ffULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b8400ff3a7984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe200078c486bULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8400ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe400078c486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x018b8c00ff3a7984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000143397810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x000000363900720cULL, 0x000fda0003fc6070ULL,
0x000005100000e947ULL, 0x000fea0003800000ULL, 0x0000000507407c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff457424ULL, 0x000fe400078e00ffULL, 0x00000010323a7824ULL, 0x000fe400078e00ffULL,
0x018a0000403c7984ULL, 0x000e620000004800ULL, 0x0000004035427824ULL, 0x000fe400078e0240ULL,
0x000000f03a477812ULL, 0x000fe200078ec0ffULL, 0x018ac0003c3c7984ULL, 0x002e640000004800ULL,
0x0000003c0d387224ULL, 0x002fc400078e0242ULL, 0x00000010403c7824ULL, 0x000fe400078e00ffULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe400030e0639ULL, 0x0000000443397824ULL, 0x000fc800078e0241ULL,
0x0000004039397824ULL, 0x000fca00078e00ffULL, 0x0000003960387217ULL, 0x000fca0007800000ULL,
0x0000000138387824ULL, 0x000fe400078e0a39ULL, 0x0000000140397824ULL, 0x000fc600078e0232ULL,
0x0000000538387c17ULL, 0x000fe4000f800000ULL, 0xfffffff03c397812ULL, 0x000fe400078ee239ULL,
0x80000005383e7c10ULL, 0x000fe4000fffe0ffULL, 0x0001400039497811ULL, 0x000fe400078e20ffULL,
0x0000003e0700720cULL, 0x000fe40003fc6070ULL, 0x0000000242397810ULL, 0x000fd60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a497faeULL, 0x0003e8000f101c4aULL,
0x018a0800403f7984ULL, 0x000ea80000004800ULL, 0x018ac0003f387984ULL, 0x004ea40000004800ULL,
0x000000380d387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x0000000207397810ULL, 0x000fc80007ffe0ffULL, 0x00000005394b7c10ULL, 0x040fe4000fffe0ffULL,
0x0000003e3900720cULL, 0x000fe40003fc6070ULL, 0x0000000442397810ULL, 0x000fe20007ffe0ffULL,
0x000000014b387824ULL, 0x040fe400078e0232ULL, 0x000000104b4b7824ULL, 0x000fca00078e00ffULL,
0xfffffff04b387812ULL, 0x000fc800078ee238ULL, 0x0001400038497811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c497faeULL, 0x0003e8000f101c4aULL,
0x018a1000403f7984ULL, 0x000ea80000004800ULL, 0x018ac0003f387984ULL, 0x0044e40000004800ULL,
0x00000006073f7810ULL, 0x004fe20007ffe0ffULL, 0x000000380d387224ULL, 0x008fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x0000000407397810ULL, 0x000fc80007ffe0ffULL,
0x00000005394b7c10ULL, 0x040fe4000fffe0ffULL, 0x0000003e3900720cULL, 0x000fc60003fc6070ULL,
0x000000014b387824ULL, 0x040fe400078e0232ULL, 0x000000104b4b7824ULL, 0x000fca00078e00ffULL,
0xfffffff04b387812ULL, 0x000fc800078ee238ULL, 0x00014000383d7811ULL, 0x002fe400078e20ffULL,
0x0000000642387810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000f101c4aULL, 0x018a1800403c7984ULL, 0x000ea80000004800ULL,
0x018ac0003c3c7984ULL, 0x004ea40000004800ULL, 0x0000003c0d387224ULL, 0x004fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fe200078e0045ULL, 0x000000053f457c10ULL, 0x000fc8000fffe0ffULL,
0x0000004738387210ULL, 0x000fe20007fde0ffULL, 0x0000000145427824ULL, 0x040fe400078e0232ULL,
0x0000001045457824ULL, 0x000fe400078e00ffULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x0000003e3f00720cULL, 0x000fe40003fc6070ULL, 0xfffffff045427812ULL, 0x000fc800078ee242ULL,
0x00014000423b7811ULL, 0x002fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000f101c4aULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x00000005073f7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff457424ULL, 0x000fe400078e00ffULL,
0x00000010323a7824ULL, 0x000fe400078e00ffULL, 0x018a00003f3c7984ULL, 0x000e620000004800ULL,
0x0000004035407824ULL, 0x000fe400078e023fULL, 0x000000f03a477812ULL, 0x000fe200078ec0ffULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0240ULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fe20007fde0ffULL,
0x000000013f387824ULL, 0x000fc800078e0232ULL, 0x000000ffff3b7224ULL, 0x000fe400030e0639ULL,
0x000000103f397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0001400038497811ULL, 0x000fe400078e20ffULL, 0x0000000240387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a497faeULL, 0x0003e8000b901c4aULL,
0x018a08003f3e7984ULL, 0x000ea80000004800ULL, 0x018ac0003e3e7984ULL, 0x004ea40000004800ULL,
0x0000003e0d387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000023f397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0232ULL,
0x0000001039397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0001400038497811ULL, 0x002fe400078e20ffULL, 0x0000000440387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c497faeULL, 0x0003e8000b901c4aULL,
0x018a10003f3e7984ULL, 0x000ea80000004800ULL, 0x018ac0003e3e7984ULL, 0x004ea40000004800ULL,
0x0000003e0d387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000043f397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0232ULL,
0x0000001039397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x00014000383d7811ULL, 0x002fe400078e20ffULL, 0x0000000640387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c4aULL,
0x018a18003f3c7984ULL, 0x000ea80000004800ULL, 0x018ac0003c3c7984ULL, 0x004ea40000004800ULL,
0x0000003c0d387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fe200078e0045ULL,
0x000000063f457810ULL, 0x000fc80007ffe0ffULL, 0x0000004738387210ULL, 0x000fe20007fde0ffULL,
0x00000001453e7824ULL, 0x040fe400078e0232ULL, 0x0000001045457824ULL, 0x000fe400078e00ffULL,
0x000000ffff397224ULL, 0x000fc600030e0639ULL, 0xfffffff0453e7812ULL, 0x000fc800078ee23eULL,
0x000140003e3b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000b901c4aULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x018b8c00ff3a7984ULL, 0x000e620000000800ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe200078c483fULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe400078c483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000433400720cULL, 0x000fe20003fc4070ULL, 0x00000004ff3a7424ULL, 0x000fe200078e00ffULL,
0x00018a000c3d7811ULL, 0x000fe400078e10ffULL, 0x000000ff5c387207ULL, 0x000fc40003000000ULL,
0x000000ff5c5c7207ULL, 0x000fc60007000000ULL, 0x0000000141387824ULL, 0x000fc800078e0238ULL,
0x0000004038397824ULL, 0x040fe200078e00ffULL, 0x0000004338387211ULL, 0x000fc800078ff0ffULL,
0x000000c039397812ULL, 0x000fca00078ec0ffULL, 0x0000010038387824ULL, 0x000fe200078e0239ULL,
0x0000000c5c397c10ULL, 0x000fc8000fffe0ffULL, 0x0000002038387810ULL, 0x000fca0007ffe0ffULL,
0x000000010c3b7824ULL, 0x100fe400078e0238ULL, 0x0000680039397a24ULL, 0x000fc600078e0238ULL,
0x000000603b00720cULL, 0x000fe20003fc6070ULL, 0x000000010c397824ULL, 0x000fc800078e0239ULL,
0x0000660039387625ULL, 0x000fd000078e003aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383d7faeULL, 0x0003e4000f12184aULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b7800ff387f8cULL, 0x000e62000c80043fULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x000000ffff6b7224ULL, 0x002fe200078e0039ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x0000000aff08723eULL, 0x000fc800000010ffULL, 0x00005410083a7816ULL, 0x000fe20000000008ULL,
0x0001aca27f007947ULL, 0x000fea000b800000ULL, 0x00001f623a097589ULL, 0x0002a400000e0000ULL,
0x0001ad027f007947ULL, 0x000fea000b800000ULL, 0x00001f613a087589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010623f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0000e67000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0001bae000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018623f7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff407424ULL, 0x000fe200078e00ffULL, 0x0000e6e000387802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0001ba7000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000663c783bULL, 0x006e620000004200ULL, 0x00001e3000017945ULL, 0x000fe60003800000ULL,
0x000000006540783bULL, 0x000ea80000004200ULL, 0x000000006444783bULL, 0x000f220000004200ULL,
0x0000003c00387306ULL, 0x002ff00000009400ULL, 0x0000003c00397306ULL, 0x000e700000005400ULL,
0x0000003c004c7306ULL, 0x000ee2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000003d004d7306ULL, 0x000ff0000000d400ULL, 0x0000003d00387306ULL, 0x000fe20000009400ULL,
0x000000014c4c6812ULL, 0x008fce00078efcffULL, 0x0000003d00397306ULL, 0x000e700000005400ULL,
0x0000003e004b7306ULL, 0x000fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000003f004a7306ULL, 0x000ff0000000d400ULL, 0x0000003e00387306ULL, 0x000fe20000009400ULL,
0x000000014d4d6812ULL, 0x000fce00078efcffULL, 0x0000003e00397306ULL, 0x000e700000005400ULL,
0x0000004000497306ULL, 0x004fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000004100487306ULL, 0x000ff0000000d400ULL, 0x0000003f00387306ULL, 0x000fe20000009400ULL,
0x000000014b4b6812ULL, 0x000fce00078efcffULL, 0x0000003f00397306ULL, 0x000e700000005400ULL,
0x00000042007a7306ULL, 0x000fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000004300787306ULL, 0x000ff0000000d400ULL, 0x0000004000387306ULL, 0x000fe20000009400ULL,
0x000000014a4a6812ULL, 0x000fce00078efcffULL, 0x0000004000397306ULL, 0x000e700000005400ULL,
0x0000004400767306ULL, 0x010fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000004500757306ULL, 0x000ff0000000d400ULL, 0x0000004100387306ULL, 0x000fe20000009400ULL,
0x0000000149496812ULL, 0x000fce00078efcffULL, 0x0000004100397306ULL, 0x000e700000005400ULL,
0x0000004600727306ULL, 0x000fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000004700707306ULL, 0x000ff0000000d400ULL, 0x0000004200387306ULL, 0x000fe20000009400ULL,
0x0000000148486812ULL, 0x000fce00078efcffULL, 0x0000004200397306ULL, 0x000e640000005400ULL,
0x000000393800720bULL, 0x002fcc0003fdd000ULL, 0x0000004300387306ULL, 0x000ff00000009400ULL,
0x0000004300397306ULL, 0x000e620000005400ULL, 0x000000017a7a6812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fca0003fdd000ULL, 0x0000004400387306ULL, 0x000ff00000009400ULL,
0x0000004400397306ULL, 0x000e620000005400ULL, 0x0000000178786812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fca0003fdd000ULL, 0x0000004500387306ULL, 0x000ff00000009400ULL,
0x0000004500397306ULL, 0x000e620000005400ULL, 0x0000000176766812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fca0003fdd000ULL, 0x0000004600387306ULL, 0x000ff00000009400ULL,
0x0000004600397306ULL, 0x000e620000005400ULL, 0x0000000175756812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fca0003fdd000ULL, 0x0000004700387306ULL, 0x000ff00000009400ULL,
0x0000004700397306ULL, 0x000e620000005400ULL, 0x0000000172726812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fc40003fdd000ULL, 0x000000006338783bULL, 0x000e760000004200ULL,
0x0000000170706812ULL, 0x000fe200078efcffULL, 0x00000038004e7306ULL, 0x002ff00000009400ULL,
0x00000038004f7306ULL, 0x000e700000005400ULL, 0x00000038006e7306ULL, 0x000ea2000000d400ULL,
0x0000004f4e00720bULL, 0x002fce0003fdd000ULL, 0x00000039006d7306ULL, 0x000ff0000000d400ULL,
0x00000039004e7306ULL, 0x000fe20000009400ULL, 0x000000016e6e6812ULL, 0x004fce00078efcffULL,
0x00000039004f7306ULL, 0x000e700000005400ULL, 0x0000003a006c7306ULL, 0x000fe2000000d400ULL,
0x0000004f4e00720bULL, 0x002fce0003fdd000ULL, 0x0000003a004e7306ULL, 0x000ff00000009400ULL,
0x0000003a004f7306ULL, 0x000e620000005400ULL, 0x000000016d6d6812ULL, 0x000fe400078efcffULL,
0x0000004f4e00720bULL, 0x002fc40003fdd000ULL, 0x00000018ff4e7819ULL, 0x000fc8000001143cULL,
0x0000004e004f7306ULL, 0x000fee0000209400ULL, 0x000000016c6c6812ULL, 0x000fe200078efcffULL,
0x0000004e00507306ULL, 0x000e700000205400ULL, 0x0000004e00517306ULL, 0x000ea2000020d400ULL,
0x000000504f00720bULL, 0x002fc40003fdd000ULL, 0x00000018ff4f7819ULL, 0x000fca000001143dULL,
0x0000004f00527306ULL, 0x000fec0000209400ULL, 0x0000000151516812ULL, 0x004fe400078efcffULL,
0x0000004f00537306ULL, 0x000e700000205400ULL, 0x0000004f00507306ULL, 0x000ea2000020d400ULL,
0x000000535200720bULL, 0x002fc40003fdd000ULL, 0x00000018ff527819ULL, 0x000fca000001143eULL,
0x0000005200537306ULL, 0x000fec0000209400ULL, 0x0000000150506812ULL, 0x004fe400078efcffULL,
0x0000005200547306ULL, 0x000e700000205400ULL, 0x00000052004e7306ULL, 0x000ea2000020d400ULL,
0x000000545300720bULL, 0x002fc40003fdd000ULL, 0x00000018ff537819ULL, 0x000fca000001143fULL,
0x0000005300547306ULL, 0x000fec0000209400ULL, 0x000000014e4e6812ULL, 0x004fe400078efcffULL,
0x0000005300557306ULL, 0x000e700000205400ULL, 0x00000053004f7306ULL, 0x0004e2000020d400ULL,
0x000000555400720bULL, 0x002fc40003fdd000ULL, 0x00000018ff547819ULL, 0x000fe40000011440ULL,
0x00000018ff537819ULL, 0x004fc60000011442ULL, 0x0000005400557306ULL, 0x000fec0000209400ULL,
0x000000014f4f6812ULL, 0x008fe400078efcffULL, 0x0000005400527306ULL, 0x000e700000205400ULL,
0x00000054007f7306ULL, 0x000ea2000020d400ULL, 0x000000525500720bULL, 0x002fce0003fdd000ULL,
0x0000005300547306ULL, 0x000fe20000205400ULL, 0x00000018ff527819ULL, 0x000fce0000011441ULL,
0x0000005200557306ULL, 0x000fe20000209400ULL, 0x000000017f7f6812ULL, 0x004fce00078efcffULL,
0x0000005200567306ULL, 0x000e700000205400ULL, 0x00000052007e7306ULL, 0x000ea2000020d400ULL,
0x000000565500720bULL, 0x002fce0003fdd000ULL, 0x00000053007c7306ULL, 0x000ff0000020d400ULL,
0x0000005300557306ULL, 0x0002e20000209400ULL, 0x000000017e7e6812ULL, 0x004fe400078efcffULL,
0x00000018ff537819ULL, 0x002fca0000011445ULL, 0x0000005300797306ULL, 0x000fe2000020d400ULL,
0x000000545500720bULL, 0x008fe40003fdd000ULL, 0x00000018ff547819ULL, 0x000fca0000011443ULL,
0x0000005400557306ULL, 0x000fec0000209400ULL, 0x000000017c7c6812ULL, 0x000fe400078efcffULL,
0x0000005400527306ULL, 0x000e700000205400ULL, 0x00000054007d7306ULL, 0x000ea2000020d400ULL,
0x000000525500720bULL, 0x002fce0003fdd000ULL, 0x0000005300547306ULL, 0x000fe20000205400ULL,
0x00000018ff527819ULL, 0x000fce0000011444ULL, 0x0000005200557306ULL, 0x000fe20000209400ULL,
0x000000017d7d6812ULL, 0x004fce00078efcffULL, 0x0000005200567306ULL, 0x000e700000205400ULL,
0x00000052007b7306ULL, 0x000ea2000020d400ULL, 0x000000565500720bULL, 0x002fce0003fdd000ULL,
0x0000005300557306ULL, 0x0002e40000209400ULL, 0x00000018ff537819ULL, 0x002fc80000011438ULL,
0x000000017b7b6812ULL, 0x004fe400078efcffULL, 0x0000005300737306ULL, 0x000fe2000020d400ULL,
0x000000545500720bULL, 0x008fe40003fdd000ULL, 0x00000018ff547819ULL, 0x000fca0000011446ULL,
0x0000005400557306ULL, 0x000fec0000209400ULL, 0x0000000179796812ULL, 0x000fe400078efcffULL,
0x0000005400527306ULL, 0x000e700000205400ULL, 0x0000005400777306ULL, 0x000ea2000020d400ULL,
0x000000525500720bULL, 0x002fce0003fdd000ULL, 0x0000005300547306ULL, 0x000fe20000205400ULL,
0x00000018ff527819ULL, 0x000fce0000011447ULL, 0x0000005200557306ULL, 0x000fe20000209400ULL,
0x0000000177776812ULL, 0x004fce00078efcffULL, 0x0000005200567306ULL, 0x000e700000205400ULL,
0x0000005200747306ULL, 0x000ea2000020d400ULL, 0x000000565500720bULL, 0x002fce0003fdd000ULL,
0x0000005300557306ULL, 0x000e620000209400ULL, 0x00000018ff567819ULL, 0x000fce000001143aULL,
0x0000005600537306ULL, 0x000fe20000205400ULL, 0x0000000174746812ULL, 0x004fe400078efcffULL,
0x000000545500720bULL, 0x002fca0003fdd000ULL, 0x00000056006f7306ULL, 0x000fe2000020d400ULL,
0x00000018ff547819ULL, 0x000fce0000011439ULL, 0x0000005400557306ULL, 0x000fe20000209400ULL,
0x0000000173736812ULL, 0x000fce00078efcffULL, 0x0000005400527306ULL, 0x000e700000205400ULL,
0x0000005400717306ULL, 0x000ea2000020d400ULL, 0x000000525500720bULL, 0x002fce0003fdd000ULL,
0x0000005600527306ULL, 0x000e6c0000209400ULL, 0x0000000171716812ULL, 0x004fe400078efcffULL,
0x000000535200720bULL, 0x002fe20003fdd000ULL, 0x000001003c527824ULL, 0x040fe400078e00ffULL,
0x000100003c3c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff527819ULL, 0x000fc80000011452ULL,
0x0000005200547306ULL, 0x000fe60000209400ULL, 0x000000016f6f6812ULL, 0x000fca00078efcffULL,
0x0000005200557306ULL, 0x000e700000205400ULL, 0x0000005200537306ULL, 0x000ea2000020d400ULL,
0x000000555400720bULL, 0x002fe40003fdd000ULL, 0x00000018ff557819ULL, 0x000fca000001143cULL,
0x00000055003c7306ULL, 0x000fec0000209400ULL, 0x0000000153536812ULL, 0x004fe400078efcffULL,
0x0000005500577306ULL, 0x000e640000205400ULL, 0x0000004c534c723eULL, 0x000fcc00000010ffULL,
0x0000005500547306ULL, 0x000ea2000020d400ULL, 0x000000573c00720bULL, 0x002fe20003fdd000ULL,
0x000001003d3c7824ULL, 0x040fe400078e00ffULL, 0x000100003d3d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff527819ULL, 0x000fe4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005200567306ULL, 0x000fe60000209400ULL, 0x0000000154546812ULL, 0x004fc800078efcffULL,
0x000000545154723eULL, 0x000fe200000010ffULL, 0x0000005200577306ULL, 0x000e700000205400ULL,
0x00000052003c7306ULL, 0x000ea2000020d400ULL, 0x000000575600720bULL, 0x002fce0003fdd000ULL,
0x0000003d00557306ULL, 0x000ff0000020d400ULL, 0x0000003d00567306ULL, 0x000fe20000209400ULL,
0x000000013c3c6812ULL, 0x004fce00078efcffULL, 0x0000003d00577306ULL, 0x000e620000205400ULL,
0x0000004d3c4d723eULL, 0x000fe400000010ffULL, 0x00012800673c7811ULL, 0x000fe400078e20ffULL,
0x000000575600720bULL, 0x002fe20003fdd000ULL, 0x000001003e567824ULL, 0x040fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000005600577306ULL, 0x000fe60000209400ULL,
0x0000000155556812ULL, 0x000fc800078efcffULL, 0x000000555055723eULL, 0x000fe200000010ffULL,
0x00000056005a7306ULL, 0x000e700000205400ULL, 0x0000005600527306ULL, 0x000ea2000020d400ULL,
0x0000005a5700720bULL, 0x002fce0003fdd000ULL, 0x0000003e003d7306ULL, 0x000ff0000020d400ULL,
0x0000003e00577306ULL, 0x000fe20000209400ULL, 0x0000000152526812ULL, 0x004fce00078efcffULL,
0x0000003e005a7306ULL, 0x000e620000205400ULL, 0x0000004b5250723eULL, 0x000fe400000010ffULL,
0x0000005a5700720bULL, 0x002fe20003fdd000ULL, 0x000001003f577824ULL, 0x040fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000005700567306ULL, 0x000fe60000209400ULL,
0x000000013d3d6812ULL, 0x000fc800078efcffULL, 0x0000003d4e4e723eULL, 0x000fe200000010ffULL,
0x0000005700597306ULL, 0x000e700000205400ULL, 0x0000005700817306ULL, 0x000ea2000020d400ULL,
0x000000595600720bULL, 0x002fce0003fdd000ULL, 0x0000003f003e7306ULL, 0x000ff0000020d400ULL,
0x0000003f00567306ULL, 0x000fe20000209400ULL, 0x0000000181816812ULL, 0x004fce00078efcffULL,
0x0000003f00597306ULL, 0x000e620000205400ULL, 0x0000004a8151723eULL, 0x000fe400000010ffULL,
0x000000595600720bULL, 0x002fe20003fdd000ULL, 0x0000010040567824ULL, 0x040fe400078e00ffULL,
0x0001000040407824ULL, 0x000fc600078e00ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x00000018ff3f7819ULL, 0x000fe40000011440ULL, 0x0000005600577306ULL, 0x000fe60000209400ULL,
0x000000013e3e6812ULL, 0x000fc800078efcffULL, 0x0000003e4f4f723eULL, 0x000fe200000010ffULL,
0x00000056005a7306ULL, 0x000e700000205400ULL, 0x0000005600807306ULL, 0x000ea2000020d400ULL,
0x0000005a5700720bULL, 0x002fce0003fdd000ULL, 0x0000003f00407306ULL, 0x000ff0000020d400ULL,
0x0000003f00577306ULL, 0x000fe20000209400ULL, 0x0000000180806812ULL, 0x004fce00078efcffULL,
0x0000003f005a7306ULL, 0x000e620000205400ULL, 0x00000049804a723eULL, 0x000fe400000010ffULL,
0x0000005a5700720bULL, 0x002fe20003fdd000ULL, 0x0000010041577824ULL, 0x040fe400078e00ffULL,
0x0001000041417824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000018ff3f7819ULL, 0x000fe40000011441ULL, 0x0000005700567306ULL, 0x000fe60000209400ULL,
0x0000000140406812ULL, 0x000fc800078efcffULL, 0x000000407f40723eULL, 0x000fe200000010ffULL,
0x0000005700597306ULL, 0x000e700000205400ULL, 0x0000005700877306ULL, 0x000ea2000020d400ULL,
0x000000595600720bULL, 0x002fce0003fdd000ULL, 0x0000003f00417306ULL, 0x000ff0000020d400ULL,
0x0000003f00567306ULL, 0x000fe20000209400ULL, 0x0000000187876812ULL, 0x004fce00078efcffULL,
0x0000003f00597306ULL, 0x000e620000205400ULL, 0x00000048874b723eULL, 0x000fce00000010ffULL,
0x0000003b007f7306ULL, 0x000fe20000005400ULL, 0x000000595600720bULL, 0x002fe20003fdd000ULL,
0x0000010042567824ULL, 0x040fe400078e00ffULL, 0x0001000042427824ULL, 0x000fc600078e00ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x0000005600577306ULL, 0x000fe60000209400ULL, 0x0000000141416812ULL, 0x000fc800078efcffULL,
0x000000417e41723eULL, 0x000fe200000010ffULL, 0x00000056005a7306ULL, 0x000e700000205400ULL,
0x0000005600857306ULL, 0x000ea2000020d400ULL, 0x0000005a5700720bULL, 0x002fce0003fdd000ULL,
0x00000042003f7306ULL, 0x000ff00000209400ULL, 0x00000042005a7306ULL, 0x000e620000205400ULL,
0x0000000185856812ULL, 0x004fce00078efcffULL, 0x0000004200837306ULL, 0x000ea2000020d400ULL,
0x0000005a3f00720bULL, 0x002fe20003fdd000ULL, 0x00000100433f7824ULL, 0x040fe400078e00ffULL,
0x0001000043437824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000003f00567306ULL, 0x000fe60000209400ULL,
0x0000000183836812ULL, 0x004fc800078efcffULL, 0x000000837c7c723eULL, 0x000fe200000010ffULL,
0x0000003f00577306ULL, 0x000e700000205400ULL, 0x0000003f00897306ULL, 0x000ea2000020d400ULL,
0x000000575600720bULL, 0x002fce0003fdd000ULL, 0x0000004300427306ULL, 0x000ff00000209400ULL,
0x0000004300577306ULL, 0x000e620000205400ULL, 0x0000000189896812ULL, 0x004fce00078efcffULL,
0x0000004300887306ULL, 0x000ea2000020d400ULL, 0x000000574200720bULL, 0x002fe20003fdd000ULL,
0x0000010044427824ULL, 0x040fe400078e00ffULL, 0x0001000044447824ULL, 0x000fc600078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x00000042003f7306ULL, 0x000fe60000209400ULL, 0x0000000188886812ULL, 0x004fc800078efcffULL,
0x000000887d7d723eULL, 0x000fe200000010ffULL, 0x0000004200567306ULL, 0x000e700000205400ULL,
0x00000042008b7306ULL, 0x000ea2000020d400ULL, 0x000000563f00720bULL, 0x002fce0003fdd000ULL,
0x0000004400827306ULL, 0x000ff0000020d400ULL, 0x00000044003f7306ULL, 0x000fe20000209400ULL,
0x000000018b8b6812ULL, 0x004fce00078efcffULL, 0x0000004400567306ULL, 0x000e640000205400ULL,
0x000000563f00720bULL, 0x002fe20003fdd000ULL, 0x00000100453f7824ULL, 0x040fe400078e00ffULL,
0x0001000045457824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000003f00427306ULL, 0x000fe60000209400ULL,
0x0000000182826812ULL, 0x000fca00078efcffULL, 0x0000003f00437306ULL, 0x000e700000205400ULL,
0x0000003f008a7306ULL, 0x000ea2000020d400ULL, 0x000000434200720bULL, 0x002fce0003fdd000ULL,
0x0000004500847306ULL, 0x000ff0000020d400ULL, 0x0000004500427306ULL, 0x000fe20000209400ULL,
0x000000018a8a6812ULL, 0x004fce00078efcffULL, 0x0000004500437306ULL, 0x000e640000205400ULL,
0x000000434200720bULL, 0x002fe20003fdd000ULL, 0x0000010046427824ULL, 0x040fe400078e00ffULL,
0x0001000046467824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000042003f7306ULL, 0x000fe60000209400ULL,
0x0000000184846812ULL, 0x000fc800078efcffULL, 0x000000847979723eULL, 0x000fe200000010ffULL,
0x0000004200447306ULL, 0x000e700000205400ULL, 0x00000042008d7306ULL, 0x000ea2000020d400ULL,
0x000000443f00720bULL, 0x002fce0003fdd000ULL, 0x0000004600867306ULL, 0x000ff0000020d400ULL,
0x00000046003f7306ULL, 0x000fe20000209400ULL, 0x000000018d8d6812ULL, 0x004fce00078efcffULL,
0x0000004600447306ULL, 0x000e640000205400ULL, 0x000000443f00720bULL, 0x002fe20003fdd000ULL,
0x00000100473f7824ULL, 0x040fe400078e00ffULL, 0x0001000047477824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000003f00427306ULL, 0x000fe60000209400ULL, 0x0000000186866812ULL, 0x000fc800078efcffULL,
0x000000867786723eULL, 0x000fe200000010ffULL, 0x0000003f00437306ULL, 0x000e700000205400ULL,
0x0000003f008f7306ULL, 0x000ea2000020d400ULL, 0x000000434200720bULL, 0x002fce0003fdd000ULL,
0x0000004700917306ULL, 0x000ff0000020d400ULL, 0x0000004700427306ULL, 0x000fe20000209400ULL,
0x000000018f8f6812ULL, 0x004fce00078efcffULL, 0x0000004700437306ULL, 0x000e640000205400ULL,
0x000000434200720bULL, 0x002fe20003fdd000ULL, 0x0000010038427824ULL, 0x040fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000042003f7306ULL, 0x000fe60000209400ULL,
0x0000000191916812ULL, 0x000fc800078efcffULL, 0x000000917487723eULL, 0x000fe200000010ffULL,
0x0000004200447306ULL, 0x000e700000205400ULL, 0x0000004200937306ULL, 0x000ea2000020d400ULL,
0x000000443f00720bULL, 0x002fce0003fdd000ULL, 0x00000038008c7306ULL, 0x000ff0000020d400ULL,
0x00000038003f7306ULL, 0x000fe20000209400ULL, 0x0000000193936812ULL, 0x004fce00078efcffULL,
0x0000003800447306ULL, 0x000e640000205400ULL, 0x000000443f00720bULL, 0x002fe20003fdd000ULL,
0x00000100393f7824ULL, 0x040fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003f00427306ULL, 0x000fe60000209400ULL, 0x000000018c8c6812ULL, 0x000fca00078efcffULL,
0x0000003f00437306ULL, 0x000e700000205400ULL, 0x0000003f008e7306ULL, 0x000ea2000020d400ULL,
0x000000434200720bULL, 0x002fce0003fdd000ULL, 0x0000003900387306ULL, 0x000ff00000209400ULL,
0x0000003900437306ULL, 0x000e620000205400ULL, 0x000000018e8e6812ULL, 0x004fce00078efcffULL,
0x0000003900907306ULL, 0x000ea2000020d400ULL, 0x000000433800720bULL, 0x002fe20003fdd000ULL,
0x000001003a387824ULL, 0x040fe200078e00ffULL, 0x000000788943723eULL, 0x000fe200000010ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000000827b78723eULL, 0x000fe400000010ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000038003f7306ULL, 0x000fe60000209400ULL, 0x0000000190906812ULL, 0x004fc800078efcffULL,
0x000000907171723eULL, 0x000fe200000010ffULL, 0x0000003800427306ULL, 0x000e700000205400ULL,
0x0000003800957306ULL, 0x000ea2000020d400ULL, 0x000000423f00720bULL, 0x002fce0003fdd000ULL,
0x0000003a00397306ULL, 0x000ff00000209400ULL, 0x0000003a00427306ULL, 0x000e620000205400ULL,
0x0000000195956812ULL, 0x004fce00078efcffULL, 0x0000003a00927306ULL, 0x000ea2000020d400ULL,
0x0000006c956c723eULL, 0x000fe400000010ffULL, 0x000000423900720bULL, 0x002fe20003fdd000ULL,
0x000001003b397824ULL, 0x000fc800078e00ffULL, 0x0000003b003a7306ULL, 0x000fe20000009400ULL,
0x0000007a8542723eULL, 0x000fe400000010ffULL, 0x00000018ff397819ULL, 0x000fca0000011439ULL,
0x0000003900387306ULL, 0x000fe20000209400ULL, 0x0000000192926812ULL, 0x004fc800078efcffULL,
0x000000926f92723eULL, 0x000fc600000010ffULL, 0x00000039003f7306ULL, 0x000e700000205400ULL,
0x0000003900977306ULL, 0x0004e2000020d400ULL, 0x0000003f3800720bULL, 0x002fce0003fdd000ULL,
0x0000003b007a7306ULL, 0x000322000000d400ULL, 0x0001280068387811ULL, 0x000fe200078e20ffULL,
0x000000003c3c783bULL, 0x000f220000000200ULL, 0x000000758a39723eULL, 0x004fc600000010ffULL,
0x00000000385c783bULL, 0x0005220000000200ULL, 0x0000000197976812ULL, 0x008fe200078efcffULL,
0x000100003b387824ULL, 0x004fe200078e00ffULL, 0x000000ff5800720cULL, 0x000fe40003fc5270ULL,
0x00000018ff3b7819ULL, 0x002fe4000001143bULL, 0x00000018ff7e7819ULL, 0x000fe40000011438ULL,
0x000000768b38723eULL, 0x000fe400000010ffULL, 0x0000007e00807306ULL, 0x000ff00000209400ULL,
0x0000007e00757306ULL, 0x000e700000205400ULL, 0x0000003b00767306ULL, 0x000fe20000209400ULL,
0x000000093c3cb231ULL, 0x010fc400003400ffULL, 0x000000093e3eb231ULL, 0x080fe400003400ffULL,
0x000000095c5cb231ULL, 0x080fe400003400ffULL, 0x000000095e5eb231ULL, 0x000fe400003400ffULL,
0x000000085d5db231ULL, 0x080fe400003400ffULL, 0x000000085f5fb231ULL, 0x080fe400003400ffULL,
0x000000083d3db231ULL, 0x000fc400003400ffULL, 0x000000083f3fb231ULL, 0x000fe200003400ffULL,
0x0000007f3a00720bULL, 0x000fe40003f7d000ULL, 0x0000004c5c58723cULL, 0x040f6200000418ffULL,
0x0000007e003a7306ULL, 0x000eae000020d400ULL, 0x000000505c50723cULL, 0x000f6600000418ffULL,
0x000000017a7a3812ULL, 0x000fc400078efcffULL, 0x000000758000720bULL, 0x002fe40003f7d000ULL,
0x0000003b00757306ULL, 0x000e620000205400ULL, 0x000000405c44723cULL, 0x000ff000000418ffULL,
0x000000383c58723cULL, 0x020be40000041858ULL, 0x000000013a3a3812ULL, 0x004fca00078efcffULL,
0x000000728d38723eULL, 0x020fe200000010ffULL, 0x000000545c54723cULL, 0x000f6200000418ffULL,
0x000000708f39723eULL, 0x000fe400000010ffULL, 0x000000757600720bULL, 0x002fe40003f7d000ULL,
0x0000008c7370723eULL, 0x000fc600000010ffULL, 0x000000383c50723cULL, 0x000bee0000041850ULL,
0x0000006e9338723eULL, 0x020fe200000010ffULL, 0x0000004e5c4c723cULL, 0x000f6200000418ffULL,
0x0000003b00937306ULL, 0x000e62000020d400ULL, 0x0000006d8e39723eULL, 0x000fc400000010ffULL,
0x0000007a976d723eULL, 0x000fc800000010ffULL, 0x0000004a5c48723cULL, 0x040f7000000418ffULL,
0x000000425c40723cULL, 0x000f6200000418ffULL, 0x0000000193933812ULL, 0x002fc800078efcffULL,
0x0000003a9393723eULL, 0x000fc600000010ffULL, 0x0000007c5c5c723cULL, 0x000f7000000418ffULL,
0x000000783c54723cULL, 0x040b700000041854ULL, 0x000000863c4c723cULL, 0x060b70000004184cULL,
0x000000383c48723cULL, 0x040b700000041848ULL, 0x000000703c44723cULL, 0x040b700000041844ULL,
0x0000006c3c40723cULL, 0x040b700000041840ULL, 0x000000923c5c723cULL, 0x000b62000004185cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000005812127221ULL, 0x000fe40000010000ULL, 0x0000005913137221ULL, 0x000fc40000010000ULL,
0x0000005416167221ULL, 0x000fe40000010000ULL, 0x0000005517177221ULL, 0x000fe40000010000ULL,
0x000000501a1a7221ULL, 0x000fe40000010000ULL, 0x000000511b1b7221ULL, 0x000fe40000010000ULL,
0x0000004c1e1e7221ULL, 0x020fe40000010000ULL, 0x0000004d1f1f7221ULL, 0x000fc40000010000ULL,
0x0000004822227221ULL, 0x000fe40000010000ULL, 0x0000004923237221ULL, 0x000fe40000010000ULL,
0x0000004426267221ULL, 0x000fe40000010000ULL, 0x0000004527277221ULL, 0x000fe40000010000ULL,
0x000000402a2a7221ULL, 0x000fe40000010000ULL, 0x000000412b2b7221ULL, 0x000fc40000010000ULL,
0x0000005c2e2e7221ULL, 0x000fe40000010000ULL, 0x0000005d2f2f7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000005a14147221ULL, 0x000fe40000010000ULL,
0x0000005b15157221ULL, 0x000fe40000010000ULL, 0x0000005618187221ULL, 0x000fe40000010000ULL,
0x0000005719197221ULL, 0x000fe40000010000ULL, 0x000000521c1c7221ULL, 0x000fc40000010000ULL,
0x000000531d1d7221ULL, 0x000fe40000010000ULL, 0x0000004e20207221ULL, 0x020fe40000010000ULL,
0x0000004f21217221ULL, 0x000fe40000010000ULL, 0x0000004a24247221ULL, 0x000fe40000010000ULL,
0x0000004b25257221ULL, 0x000fe40000010000ULL, 0x0000004628287221ULL, 0x000fc40000010000ULL,
0x0000004729297221ULL, 0x000fe40000010000ULL, 0x000000422c2c7221ULL, 0x000fe40000010000ULL,
0x000000432d2d7221ULL, 0x000fe40000010000ULL, 0x0000005e30307221ULL, 0x000fe40000010000ULL,
0x0000005f31317221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff387f8cULL, 0x020e62000c80043fULL, 0x000000696a00720cULL, 0x000fe20003f06070ULL,
0x000000ffff3c7224ULL, 0x002fd800078e0039ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff8c8000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000800f397811ULL, 0x000fe200078e40ffULL, 0x018b6000ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000603900720cULL, 0x000fda0003f06070ULL, 0x0000e81000000947ULL, 0x000fea0003800000ULL,
0x000000ffff6a7224ULL, 0x000fca00078e00ffULL, 0x00000002ff397819ULL, 0x000fe2000001166aULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000036a3a7812ULL, 0x040fe200078ec0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x000000396a397207ULL, 0x000fe40002800000ULL,
0x000000ff3a3f7207ULL, 0x000fe40006800000ULL, 0x0000000239387810ULL, 0x000fc80007ffe0ffULL,
0x0000000338417812ULL, 0x040fe400078ec0ffULL, 0x0000000f38437211ULL, 0x000fc400078ff0ffULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x018b8c00ff3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff3b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000143397810ULL, 0x000fe20007ffe0ffULL,
0x0000099000017945ULL, 0x000fe60003800000ULL, 0x000000363900720cULL, 0x000fda0003f06070ULL,
0x0000052000008947ULL, 0x000fea0003800000ULL, 0x0000000507457c10ULL, 0x000fe2000fffe0ffULL,
0x0000000443397824ULL, 0x000fe200078e0241ULL, 0x00000020353e7811ULL, 0x000fe200078e30ffULL,
0x00000010323b7824ULL, 0x000fe200078e00ffULL, 0x00000002074d7810ULL, 0x000fe20007ffe0ffULL,
0x018a0000453a7984ULL, 0x000e620000004800ULL, 0x0000002039397811ULL, 0x000fe200078e30ffULL,
0x00000100ff477424ULL, 0x000fe200078e00ffULL, 0x000000f03b497812ULL, 0x000fe200078ec0ffULL,
0x00000001453b7824ULL, 0x040fe200078e0232ULL, 0x0000003960387217ULL, 0x000fe20007800000ULL,
0x0000001045407824ULL, 0x000fe200078e00ffULL, 0x000000054d4f7c10ULL, 0x000fc6000fffe0ffULL,
0x0000000138387824ULL, 0x000fe400078e0a39ULL, 0x0000000145397824ULL, 0x000fc600078e023eULL,
0x0000000538387c17ULL, 0x000fc8000f800000ULL, 0x80000005383c7c10ULL, 0x000fc8000fffe0ffULL,
0x0000003c0700720cULL, 0x000fe20003f06070ULL, 0x018ac0003a3a7984ULL, 0x002e640000004800ULL,
0x0000003a0d397224ULL, 0x002fc800078e0239ULL, 0x00005e0039387625ULL, 0x000fca00078e0047ULL,
0x00000049383a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffff040387812ULL, 0x000fe200078ee23bULL,
0x000000014f407824ULL, 0x040fe400078e0232ULL, 0x000000ffff3b7224ULL, 0x000fe200008e0639ULL,
0x00016000384b7811ULL, 0x000fe200078e20ffULL, 0x000000014f397824ULL, 0x040fe400078e023eULL,
0x000000104f4f7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a4b7faeULL, 0x0003e2000c101c4aULL, 0x0000003c4d00720cULL, 0x000fc40003f06070ULL,
0xfffffff04f407812ULL, 0x000fe200078ee240ULL, 0x018a0800453d7984ULL, 0x000ea20000004800ULL,
0x00000004074d7810ULL, 0x000fc80007ffe0ffULL, 0x000000054d4f7c10ULL, 0x000fe4000fffe0ffULL,
0x00016000404b7811ULL, 0x002fc600078e20ffULL, 0x000000014f407824ULL, 0x000fe200078e0232ULL,
0x018ac0003d387984ULL, 0x004e640000004800ULL, 0x000000380d387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff3b7224ULL, 0x000fe400008e0639ULL, 0x000000014f397824ULL, 0x040fe400078e023eULL,
0x000000104f4f7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a4b7faeULL, 0x0003e2000c101c4aULL, 0x0000003c4d00720cULL, 0x000fe40003f06070ULL,
0x00000006074d7810ULL, 0x000fe20007ffe0ffULL, 0x018a1000453d7984ULL, 0x000ea20000004800ULL,
0xfffffff04f407812ULL, 0x000fc400078ee240ULL, 0x000000054d4f7c10ULL, 0x000fe4000fffe0ffULL,
0x00016000404b7811ULL, 0x002fc600078e20ffULL, 0x000000014f3e7824ULL, 0x000fe200078e023eULL,
0x018ac0003d387984ULL, 0x004e640000004800ULL, 0x000000380d387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff3b7224ULL, 0x000fca00008e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a4b7faeULL, 0x0003e2000c101c4aULL, 0x0000003c4d00720cULL, 0x000fc60003f06070ULL,
0x018a1800453d7984ULL, 0x000ea80000004800ULL, 0x018ac0003d387984ULL, 0x004ea40000004800ULL,
0x000000380d387224ULL, 0x004fe400078e023eULL, 0x000000014f3e7824ULL, 0x000fe400078e0232ULL,
0x00005e0038387625ULL, 0x000fc800078e0047ULL, 0x000000104f4f7824ULL, 0x000fe200078e00ffULL,
0x0000004938387210ULL, 0x000fc80007f3e0ffULL, 0xfffffff04f3e7812ULL, 0x000fe200078ee23eULL,
0x000000ffff397224ULL, 0x000fc600008e0639ULL, 0x000160003e3b7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e2000c101c4aULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x0000000507457c10ULL, 0x000fe2000fffe0ffULL,
0x0000001032397824ULL, 0x000fe200078e00ffULL, 0x0000002035407811ULL, 0x000fe200078e30ffULL,
0x00000100ff477424ULL, 0x000fe200078e00ffULL, 0x00000002453d7810ULL, 0x000fe20007ffe0ffULL,
0x018a0000453c7984ULL, 0x000e620000004800ULL, 0x000000f039497812ULL, 0x000fe200078ec0ffULL,
0x0000000145387824ULL, 0x040fe400078e0240ULL, 0x00000001453b7824ULL, 0x000fc400078e0232ULL,
0x00000010453e7824ULL, 0x000fe400078e00ffULL, 0x000000013d427824ULL, 0x000fe200078e0232ULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff03e387812ULL, 0x000fc600078ee23bULL, 0x000000ffff3b7224ULL, 0x000fe200000e0639ULL,
0x00016000384b7811ULL, 0x000fe200078e20ffULL, 0x0000000140387824ULL, 0x000fe400078e023dULL,
0x000000103d3d7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a4b7faeULL, 0x0003e6000b901c4aULL, 0xfffffff03d427812ULL, 0x000fe200078ee242ULL,
0x018a0800453e7984ULL, 0x000ea60000004800ULL, 0x00016000424b7811ULL, 0x002fc400078e20ffULL,
0x00000004453b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b427824ULL, 0x000fe200078e0232ULL,
0x018ac0003e3e7984ULL, 0x004e640000004800ULL, 0x0000003e0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000140387824ULL, 0x000fe400078e023bULL, 0x000000103b3b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e0639ULL, 0xfffffff03b427812ULL, 0x000fe400078ee242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c4b7faeULL, 0x0003e8000b901c4aULL,
0x018a1000453e7984ULL, 0x000ea20000004800ULL, 0x00016000423d7811ULL, 0x002fe400078e20ffULL,
0x00000006454b7810ULL, 0x000fe20007ffe0ffULL, 0x018ac0003e3e7984ULL, 0x004e640000004800ULL,
0x0000003e0d387224ULL, 0x002fc400078e0238ULL, 0x000000014b3e7824ULL, 0x000fe400078e0232ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000140387824ULL, 0x000fe400078e024bULL, 0x000000104b4b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600000e0639ULL, 0xfffffff04b3e7812ULL, 0x000fe400078ee23eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c4aULL,
0x018a1800453c7984ULL, 0x000ea20000004800ULL, 0x000160003e3b7811ULL, 0x002fc600078e20ffULL,
0x018ac0003c3c7984ULL, 0x004e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x0000004938387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c4aULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff457224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000433400720cULL, 0x000fe20003f04070ULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000033f00780cULL, 0x000fda0003f25270ULL, 0x0000010000008947ULL, 0x000fea0000800000ULL,
0x000000030c00780cULL, 0x000fe40003f04070ULL, 0x000000010e0e7810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000397919ULL, 0x000e620000002700ULL,
0x000000370e00720cULL, 0x000fe20003f06070ULL, 0x00000004ff3b7424ULL, 0x000fe200078e00ffULL,
0x00018ac00c3d7811ULL, 0x000fe200078e10ffULL, 0x0000000439387824ULL, 0x002fe200078e020cULL,
0x000064000e397a10ULL, 0x000fc60007ffe0ffULL, 0x0000000238387824ULL, 0x000fc800078e00ffULL,
0x0000640038387a24ULL, 0x000fc800078e0239ULL, 0x0000600038387625ULL, 0x000fca00078e003bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383d7faeULL, 0x0003e4000c12184aULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000433400720cULL, 0x000fe40003f04070ULL,
0x000000013f387810ULL, 0x002fc80007ffe0ffULL, 0x0000000338397812ULL, 0x000fc800078ec0ffULL,
0x000000ff39397207ULL, 0x000fc60004000000ULL, 0x00000002ff388819ULL, 0x000fca0000011638ULL,
0x0000000141387824ULL, 0x000fc800078e0238ULL, 0x00000040383a7824ULL, 0x040fe200078e00ffULL,
0x0000004338387211ULL, 0x000fc800078ff0ffULL, 0x000000c03a3b7812ULL, 0x000fca00078ec0ffULL,
0x00000100383d7824ULL, 0x000fe200078e023bULL, 0x0000000c39387c10ULL, 0x000fc6000fffe0ffULL,
0x000000010c3b7824ULL, 0x100fe400078e023dULL, 0x0000680038397a24ULL, 0x000fe400078e023dULL,
0x00000004ff387424ULL, 0x000fe200078e00ffULL, 0x000000603b00720cULL, 0x000fe20003f06070ULL,
0x000000010c397824ULL, 0x040fe200078e0239ULL, 0x00018a000c3b7811ULL, 0x000fc600078e10ffULL,
0x0000660039387625ULL, 0x000fd000078e0038ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000c12184aULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8000ff387f8cULL, 0x000e62000c80043fULL, 0x000000ff6a00720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff6b7224ULL, 0x002fd600078e0039ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b1800ff387f8cULL, 0x000e64000c800405ULL, 0x000000ffff3c7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b1c05ff0b7984ULL, 0x000e640008000800ULL,
0x800000000bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc8000001143bULL, 0x0000003a0b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff3a7224ULL, 0x000fca00000e063bULL, 0x000000020b0b7819ULL, 0x000fc8000000123aULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x018b1c05ff0b7984ULL, 0x000e640008000800ULL, 0x800000000bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00000010320b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff387819ULL, 0x000fc80000011632ULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c38387812ULL, 0x000fca00078ec0ffULL, 0x000000010b3f7824ULL, 0x000fca00078e0238ULL,
0x018100003f3b7984ULL, 0x000e680000000800ULL, 0x018300003f3a7984ULL, 0x0004e20000000800ULL,
0x000000103b00720bULL, 0x002fe20003f1d000ULL, 0x000173927f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0b427812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fd200078e0010ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000023300780cULL, 0x000fe40003f05270ULL, 0x000000103b00720bULL, 0x000fe20003f34000ULL,
0x000173627f007947ULL, 0x000fd8000b800000ULL, 0x00000000003d7806ULL, 0x000fc400008e0100ULL,
0x0000003b103c7209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x000099103d387816ULL, 0x000fc600000000ffULL, 0x0185003c3f008388ULL, 0x0003e20000000800ULL,
0x000000ff3800720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000003c10107221ULL, 0x002fe20000010000ULL, 0x000000ff3dff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000447308ULL, 0x000e640000000800ULL, 0x0000004411117220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000172c27f007947ULL, 0x000fea000b800000ULL,
0x00001f6244107589ULL, 0x0002a400000e0000ULL, 0x0000001012127220ULL, 0x084fe40000410000ULL,
0x0000001013137220ULL, 0x080fe40000410000ULL, 0x0000001016167220ULL, 0x080fe40000410000ULL,
0x0000001017177220ULL, 0x080fe40000410000ULL, 0x000000101a1a7220ULL, 0x080fe40000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x000000101e1e7220ULL, 0x080fe40000410000ULL,
0x000000101f1f7220ULL, 0x080fe40000410000ULL, 0x0000001022227220ULL, 0x080fe40000410000ULL,
0x0000001023237220ULL, 0x080fe40000410000ULL, 0x0000001026267220ULL, 0x080fe40000410000ULL,
0x0000001027277220ULL, 0x000fc40000410000ULL, 0x000000102a2a7220ULL, 0x080fe40000410000ULL,
0x000000102b2b7220ULL, 0x080fe40000410000ULL, 0x000000102e2e7220ULL, 0x080fe40000410000ULL,
0x000000102f2f7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff003dff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000171f27f007947ULL, 0x000fea000b800000ULL, 0x00001f6144107589ULL, 0x00046400000e0000ULL,
0x0000001014147220ULL, 0x082fe40000410000ULL, 0x0000001015157220ULL, 0x080fe40000410000ULL,
0x0000001018187220ULL, 0x080fe40000410000ULL, 0x0000001019197220ULL, 0x080fe40000410000ULL,
0x000000101c1c7220ULL, 0x080fe40000410000ULL, 0x000000101d1d7220ULL, 0x000fc40000410000ULL,
0x0000001020207220ULL, 0x080fe40000410000ULL, 0x0000001021217220ULL, 0x080fe40000410000ULL,
0x0000001024247220ULL, 0x080fe40000410000ULL, 0x0000001025257220ULL, 0x080fe40000410000ULL,
0x0000001028287220ULL, 0x080fe40000410000ULL, 0x0000001029297220ULL, 0x000fc40000410000ULL,
0x000000102c2c7220ULL, 0x080fe40000410000ULL, 0x000000102d2d7220ULL, 0x080fe40000410000ULL,
0x0000001030307220ULL, 0x080fe40000410000ULL, 0x0000001031317220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff42ff7812ULL, 0x000fda000780603dULL,
0x8000003c3b3b0221ULL, 0x000fe20000010000ULL, 0x00007610ff0b0816ULL, 0x000fc6000000000bULL,
0x3fb8aa3b3b3b0820ULL, 0x000fc80000410000ULL, 0x0000003b000a0308ULL, 0x000e640000000800ULL,
0x0000000a3a3a0220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x000000113a117221ULL, 0x008fe40000010000ULL, 0x000000ffff107224ULL, 0x000fc400078e003cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff0bff7812ULL, 0x000fe2000786c0ffULL,
0x0000016000017945ULL, 0x000fd80003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x0000000aff08723eULL, 0x000fc800000010ffULL, 0x00005410083a7816ULL, 0x000fe20000000008ULL,
0x000170527f007947ULL, 0x000fea000b800000ULL, 0x00001f623a097589ULL, 0x0002e400000e0000ULL,
0x000170b27f007947ULL, 0x000fea000b800000ULL, 0x00001f613a087589ULL, 0x0002a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010623f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0001257000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00017be000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018623f7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff407424ULL, 0x000fe200078e00ffULL, 0x000125e000387802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00017b7000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000000640783bULL, 0x002e620000004200ULL, 0x00001e9000017945ULL, 0x000fe60003800000ULL,
0x000000000444783bULL, 0x004fe80000004200ULL, 0x00000000053c783bULL, 0x000ea80000004200ULL,
0x000000000338783bULL, 0x000f220000004200ULL, 0x00000018ff4d7819ULL, 0x002fe20000011443ULL,
0x0000010040797824ULL, 0x000fe200078e00ffULL, 0x0000004000cf7306ULL, 0x000fe20000009400ULL,
0x00000018ff4a7819ULL, 0x000fc40000011440ULL, 0x00000018ff4b7819ULL, 0x000fe40000011441ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000018ff7a7819ULL, 0x004fe2000001143dULL,
0x0000004d00c07306ULL, 0x000fe20000209400ULL, 0x00000018ff7f7819ULL, 0x000fe4000001143eULL,
0x00000018ff587819ULL, 0x010fe4000001143aULL, 0x00000018ff5c7819ULL, 0x000fc4000001143bULL,
0x00000018ff4c7819ULL, 0x000fe20000011442ULL, 0x0000004d00c37306ULL, 0x000fe20000205400ULL,
0x00000018ff807819ULL, 0x000fce000001143fULL, 0x0000004d005a7306ULL, 0x0003f0000020d400ULL,
0x0000007a00a37306ULL, 0x000fe20000209400ULL, 0x00000018ff4d7819ULL, 0x002fce0000011447ULL,
0x0000004d00b07306ULL, 0x000ff00000209400ULL, 0x0000004d00b17306ULL, 0x000ff00000205400ULL,
0x0000004d00747306ULL, 0x000ff0000020d400ULL, 0x0000007a00a27306ULL, 0x000ff00000205400ULL,
0x0000007a004d7306ULL, 0x000ff0000020d400ULL, 0x00000079007a7306ULL, 0x000ff00000209400ULL,
0x0000007900d17306ULL, 0x000e700000205400ULL, 0x0000005800757306ULL, 0x000ff00000209400ULL,
0x0000005800767306ULL, 0x000fe20000205400ULL, 0x000000d17a00720bULL, 0x002fce0003f5d000ULL,
0x00000058006c7306ULL, 0x000ff0000020d400ULL, 0x0000005c00777306ULL, 0x000ff00000209400ULL,
0x0000005c00787306ULL, 0x000ff00000205400ULL, 0x0000005c006d7306ULL, 0x000ff0000020d400ULL,
0x0000007f009f7306ULL, 0x000ff00000209400ULL, 0x0000007f00587306ULL, 0x000ff00000205400ULL,
0x0000007f005c7306ULL, 0x0003f0000020d400ULL, 0x0000004000ca7306ULL, 0x000ea20000005400ULL,
0x00000100417f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000007900b37306ULL, 0x000330000020d400ULL, 0x0000007f00ce7306ULL, 0x000fe20000209400ULL,
0x0000010042797824ULL, 0x002fe200078e00ffULL, 0x000000cacf00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000007f00d57306ULL, 0x000e620000205400ULL,
0x00000001b3b32812ULL, 0x010fce00078efcffULL, 0x0000004000a87306ULL, 0x000530000000d400ULL,
0x0000004a00cd7306ULL, 0x000fe20000209400ULL, 0x0001000040407824ULL, 0x004fe200078e00ffULL,
0x000000d5ce00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000004a00c87306ULL, 0x000e620000205400ULL, 0x00000001a8a86812ULL, 0x010fce00078efcffULL,
0x0000004a00a07306ULL, 0x000530000020d400ULL, 0x0000004100c47306ULL, 0x000fe20000009400ULL,
0x00000018ff4a7819ULL, 0x004fe40000011444ULL, 0x000000c8cd00720bULL, 0x002fca0003f3d000ULL,
0x0000004100c97306ULL, 0x000e700000005400ULL, 0x0000004b00c77306ULL, 0x000fe20000209400ULL,
0x00000001a0a01812ULL, 0x010fce00078efcffULL, 0x0000004b00c27306ULL, 0x000ea20000205400ULL,
0x000000c9c400720bULL, 0x002fce0003fdd000ULL, 0x0000004b009e7306ULL, 0x000330000020d400ULL,
0x0000004a00b87306ULL, 0x000fe20000209400ULL, 0x00000018ff4b7819ULL, 0x002fe40000011445ULL,
0x000000c2c700720bULL, 0x004fca0003f3d000ULL, 0x0000004a00bd7306ULL, 0x000ff00000205400ULL,
0x0000004a00887306ULL, 0x0003e2000020d400ULL, 0x000000019e9e1812ULL, 0x010fce00078efcffULL,
0x0000004200be7306ULL, 0x000fe20000009400ULL, 0x00000018ff4a7819ULL, 0x002fce0000011438ULL,
0x0000004200c57306ULL, 0x000ff00000005400ULL, 0x00000042009c7306ULL, 0x0003f0000000d400ULL,
0x0000007f00af7306ULL, 0x000522000020d400ULL, 0x0001000042427824ULL, 0x002fce00078e00ffULL,
0x0000007900d97306ULL, 0x000fe20000209400ULL, 0x00000018ff7f7819ULL, 0x004fe20000011442ULL,
0x0000010043427824ULL, 0x000fcc00078e00ffULL, 0x0000007900d27306ULL, 0x000e620000205400ULL,
0x00000001afaf2812ULL, 0x010fce00078efcffULL, 0x0000004c00cb7306ULL, 0x000ff00000209400ULL,
0x0000004c00c67306ULL, 0x000ea20000205400ULL, 0x000000d2d900720bULL, 0x002fce0003f5d000ULL,
0x0000004c005b7306ULL, 0x000330000020d400ULL, 0x0000004b00ba7306ULL, 0x000fe20000209400ULL,
0x00000018ff4c7819ULL, 0x002fe40000011446ULL, 0x000000c6cb00720bULL, 0x004fca0003f3d000ULL,
0x0000004b00c17306ULL, 0x000e700000205400ULL, 0x0000004b00847306ULL, 0x0004e2000020d400ULL,
0x000000015b5b1812ULL, 0x010fe400078efcffULL, 0x000000c3c000720bULL, 0x000fca0003f3d000ULL,
0x0000004a00527306ULL, 0x000fe20000209400ULL, 0x00000018ff4b7819ULL, 0x004fce0000011439ULL,
0x0000004a00537306ULL, 0x000fe20000205400ULL, 0x000000015a5a1812ULL, 0x000fe400078efcffULL,
0x000000bdb800720bULL, 0x000fca0003f3d000ULL, 0x0000004a00727306ULL, 0x0005f0000020d400ULL,
0x0000004000cc7306ULL, 0x000fe20000209400ULL, 0x00000018ff4a7819ULL, 0x004fe4000001143cULL,
0x0000000188881812ULL, 0x000fc400078efcffULL, 0x000000c1ba00720bULL, 0x002fe20003f3d000ULL,
0x000001003eba7824ULL, 0x000fe400078e00ffULL, 0x0000004000d37306ULL, 0x000e660000205400ULL,
0x00000018ffba7819ULL, 0x000fca00000114baULL, 0x0000004100a47306ULL, 0x000524000000d400ULL,
0x0000000184841812ULL, 0x008fcc00078efcffULL, 0x0000004c00b77306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x004fe200078e00ffULL, 0x000000d3cc00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004c00b47306ULL, 0x000e620000205400ULL,
0x00000001a4a46812ULL, 0x010fe400078efcffULL, 0x000000c5be00720bULL, 0x000fe20003fdd000ULL,
0x000001003dbe7824ULL, 0x000fc800078e00ffULL, 0x0000004c007e7306ULL, 0x000ea2000020d400ULL,
0x00000018ffbe7819ULL, 0x000fce00000114beULL, 0x0000004b00897306ULL, 0x000fe20000209400ULL,
0x000000019c9c6812ULL, 0x000fe400078efcffULL, 0x000000b4b700720bULL, 0x002fca0003f3d000ULL,
0x0000004b008a7306ULL, 0x000ff00000205400ULL, 0x0000004b006e7306ULL, 0x000fe2000020d400ULL,
0x000000017e7e1812ULL, 0x004fe400078efcffULL, 0x000000b1b000720bULL, 0x000fe20003f3d000ULL,
0x000001003bb17824ULL, 0x000fc400078e00ffULL, 0x000100003ab07824ULL, 0x000fe400078e00ffULL,
0x0000004a00b57306ULL, 0x000fe20000209400ULL, 0x00000018ffb17819ULL, 0x000fe400000114b1ULL,
0x00000018ffb07819ULL, 0x000fca00000114b0ULL, 0x0000004a00ac7306ULL, 0x000e620000205400ULL,
0x0000000174741812ULL, 0x000fce00078efcffULL, 0x0000004a004c7306ULL, 0x000eb0000020d400ULL,
0x00000080004b7306ULL, 0x000fe20000209400ULL, 0x000000acb500720bULL, 0x002fe20003f3d000ULL,
0x000100003bac7824ULL, 0x000fca00078e00ffULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x00000080004a7306ULL, 0x000fec0000205400ULL, 0x000000014c4c1812ULL, 0x004fe400078efcffULL,
0x00000080005d7306ULL, 0x0003f0000020d400ULL, 0x0000007900a17306ULL, 0x0004e2000020d400ULL,
0x00000018ff807819ULL, 0x002fce0000011442ULL, 0x0000008000e07306ULL, 0x000fe20000209400ULL,
0x0000010044797824ULL, 0x004fca00078e00ffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000008000e77306ULL, 0x000e620000205400ULL, 0x00000001a1a12812ULL, 0x008fce00078efcffULL,
0x0000004000a77306ULL, 0x000eb0000020d400ULL, 0x0000004100d07306ULL, 0x000fe20000209400ULL,
0x000000e7e000720bULL, 0x002fce0003f5d000ULL, 0x0000004100d77306ULL, 0x000e620000205400ULL,
0x00000001a7a70812ULL, 0x004fce00078efcffULL, 0x0000004300b67306ULL, 0x000ff00000009400ULL,
0x0000004300bf7306ULL, 0x000ea20000005400ULL, 0x000000d7d000720bULL, 0x002fce0003f1d000ULL,
0x0000008000427306ULL, 0x000e70000020d400ULL, 0x0000007900eb7306ULL, 0x000fe20000209400ULL,
0x000000bfb600720bULL, 0x004fce0003fdd000ULL, 0x0000007900e47306ULL, 0x000ea20000205400ULL,
0x0000000142422812ULL, 0x002fce00078efcffULL, 0x0000004100a57306ULL, 0x000e70000020d400ULL,
0x0000007f00de7306ULL, 0x000fe20000209400ULL, 0x000000e4eb00720bULL, 0x004fce0003f5d000ULL,
0x0000007f00e57306ULL, 0x000ea20000205400ULL, 0x00000001a5a50812ULL, 0x002fce00078efcffULL,
0x0000007f00407306ULL, 0x0003f0000020d400ULL, 0x0000004300597306ULL, 0x000722000000d400ULL,
0x00000100457f7824ULL, 0x002fe200078e00ffULL, 0x000000e5de00720bULL, 0x004fc80003f1d000ULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000004400bc7306ULL, 0x000fe20000009400ULL,
0x0001000043437824ULL, 0x008fca00078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004400bb7306ULL, 0x000e620000005400ULL, 0x0000000159596812ULL, 0x010fe400078efcffULL,
0x0000000140400812ULL, 0x000fe400078efcffULL, 0x000000594259723eULL, 0x000fe400000010ffULL,
0x0001300000427811ULL, 0x000fe200078e20ffULL, 0x0000007900937306ULL, 0x000eb0000020d400ULL,
0x0000007f00db7306ULL, 0x000fe20000209400ULL, 0x000000bbbc00720bULL, 0x002fce0003fdd000ULL,
0x0000007f00d47306ULL, 0x000e620000205400ULL, 0x0000000193932812ULL, 0x004fce00078efcffULL,
0x0000004300e27306ULL, 0x000ff00000209400ULL, 0x0000004300e97306ULL, 0x000ea20000205400ULL,
0x000000d4db00720bULL, 0x002fce0003f5d000ULL, 0x0000004300417306ULL, 0x0003f0000020d400ULL,
0x00000044005e7306ULL, 0x000722000000d400ULL, 0x0000010046437824ULL, 0x002fe200078e00ffULL,
0x000000e9e200720bULL, 0x004fc80003f1d000ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004500b27306ULL, 0x000fe20000009400ULL, 0x0001000044447824ULL, 0x008fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000004500b97306ULL, 0x000e620000005400ULL,
0x000000015e5e6812ULL, 0x010fe400078efcffULL, 0x0000000141410812ULL, 0x000fe400078efcffULL,
0x0000005e935e723eULL, 0x000fc600000010ffULL, 0x0000007f00947306ULL, 0x000eb0000020d400ULL,
0x0000004300da7306ULL, 0x000fe20000209400ULL, 0x000000b9b200720bULL, 0x002fce0003fdd000ULL,
0x0000004300e17306ULL, 0x000e620000205400ULL, 0x0000000194942812ULL, 0x004fce00078efcffULL,
0x0000004400e67306ULL, 0x000ff00000209400ULL, 0x0000004400ed7306ULL, 0x000ea20000205400ULL,
0x000000e1da00720bULL, 0x002fce0003f5d000ULL, 0x00000044008d7306ULL, 0x0003f0000020d400ULL,
0x00000045005f7306ULL, 0x000722000000d400ULL, 0x0000010047447824ULL, 0x002fe200078e00ffULL,
0x000000ede600720bULL, 0x004fc80003f1d000ULL, 0x00000018ff797819ULL, 0x000fe40000011444ULL,
0x0000004600577306ULL, 0x000fe20000009400ULL, 0x0001000045457824ULL, 0x008fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004600567306ULL, 0x000e620000005400ULL,
0x000000015f5f6812ULL, 0x010fe400078efcffULL, 0x000000018d8d0812ULL, 0x000fe400078efcffULL,
0x0000005f945f723eULL, 0x000fe400000010ffULL, 0x0000008d8888723eULL, 0x000fe200000010ffULL,
0x00000043008e7306ULL, 0x000eb0000020d400ULL, 0x0000007900d87306ULL, 0x000fe20000209400ULL,
0x000000565700720bULL, 0x002fc40003fdd000ULL, 0x0001300002567811ULL, 0x000fca00078e20ffULL,
0x0000007900dd7306ULL, 0x000e620000205400ULL, 0x000000018e8e2812ULL, 0x004fce00078efcffULL,
0x0000004600817306ULL, 0x0004f0000000d400ULL, 0x0000004500dc7306ULL, 0x000fe20000209400ULL,
0x0001000046467824ULL, 0x004fe200078e00ffULL, 0x000000ddd800720bULL, 0x002fc80003f5d000ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000004500e37306ULL, 0x000e620000205400ULL,
0x0000000181816812ULL, 0x008fc800078efcffULL, 0x000000818e8e723eULL, 0x000fc600000010ffULL,
0x00000045008b7306ULL, 0x0004f0000020d400ULL, 0x0000004700547306ULL, 0x000fe20000009400ULL,
0x0000010038457824ULL, 0x004fe200078e00ffULL, 0x000000e3dc00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff8f7819ULL, 0x000fe40000011445ULL, 0x0000004700557306ULL, 0x000e6e0000005400ULL,
0x000000018b8b0812ULL, 0x008fe200078efcffULL, 0x00000038004f7306ULL, 0x000ff00000009400ULL,
0x0000003800507306ULL, 0x000fe20000005400ULL, 0x000000555400720bULL, 0x002fc40003fdd000ULL,
0x000000005654783bULL, 0x000e6a0000000200ULL, 0x0000003800737306ULL, 0x0005f0000000d400ULL,
0x0000004600df7306ULL, 0x000fe20000209400ULL, 0x0001000038387824ULL, 0x004fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004600d67306ULL, 0x000eb00000205400ULL,
0x0000004600877306ULL, 0x000ef0000020d400ULL, 0x00000079008c7306ULL, 0x0008e2000020d400ULL,
0x000000d6df00720bULL, 0x004fe20003f1d000ULL, 0x000000095454b231ULL, 0x002fc400003400ffULL,
0x000000095656b231ULL, 0x000fe400003400ffULL, 0x000000085555b231ULL, 0x080fe400003400ffULL,
0x0000008f00457306ULL, 0x000fe20000209400ULL, 0x0000010039797824ULL, 0x010fe200078e00ffULL,
0x000000085757b231ULL, 0x000fc800003400ffULL, 0x0000000187870812ULL, 0x008fe400078efcffULL,
0x0000008f00467306ULL, 0x000e620000205400ULL, 0x000000018c8c2812ULL, 0x000fce00078efcffULL,
0x0000003800987306ULL, 0x000ff00000209400ULL, 0x00000038009b7306ULL, 0x000fe20000205400ULL,
0x000000464500720bULL, 0x002fe40003f5d000ULL, 0x000000415a45723eULL, 0x000fca00000010ffULL,
0x00000038007f7306ULL, 0x0003f0000020d400ULL, 0x0000003c00ad7306ULL, 0x000fe20000009400ULL,
0x000001003c387824ULL, 0x002fca00078e00ffULL, 0x00000018ffca7819ULL, 0x000fe40000011438ULL,
0x0000003c00ae7306ULL, 0x000ff00000005400ULL, 0x0000003c00487306ULL, 0x0003f0000000d400ULL,
0x00000047007b7306ULL, 0x0004e2000000d400ULL, 0x000100003c3c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000008f00867306ULL, 0x000322000020d400ULL,
0x0001000047477824ULL, 0x004fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000003c00c27306ULL, 0x000fe20000209400ULL, 0x000000017b7b6812ULL, 0x008fe200078efcffULL,
0x000001003a8f7824ULL, 0x002fe200078e00ffULL, 0x000000aead00720bULL, 0x000fc80003fdd000ULL,
0x00000018ffe87819ULL, 0x000fe2000001148fULL, 0x0000003c00c77306ULL, 0x000e620000205400ULL,
0x0000000186862812ULL, 0x010fce00078efcffULL, 0x0000004700447306ULL, 0x000fe20000209400ULL,
0x0000000148486812ULL, 0x000fce00078efcffULL, 0x0000004700437306ULL, 0x000ea20000205400ULL,
0x000000c7c200720bULL, 0x002fce0003f5d000ULL, 0x0000003900997306ULL, 0x000ff00000009400ULL,
0x00000039004e7306ULL, 0x000fe20000005400ULL, 0x000000434400720bULL, 0x004fce0003f1d000ULL,
0x0000003900717306ULL, 0x0003f0000000d400ULL, 0x0000003d00ab7306ULL, 0x000fe20000009400ULL,
0x0001000039397824ULL, 0x002fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003d00a67306ULL, 0x000e700000005400ULL, 0x0000003c00c57306ULL, 0x000eb0000020d400ULL,
0x000000be00bf7306ULL, 0x000fe20000209400ULL, 0x000000a6ab00720bULL, 0x002fce0003fdd000ULL,
0x000000be003c7306ULL, 0x000e620000205400ULL, 0x00000001c5c52812ULL, 0x004fc800078efcffULL,
0x000000c54c4c723eULL, 0x000fc600000010ffULL, 0x0000004700857306ULL, 0x0004f0000020d400ULL,
0x0000003900917306ULL, 0x000fe20000209400ULL, 0x00000018ff477819ULL, 0x004fe40000011479ULL,
0x0000003cbf00720bULL, 0x002fc40003f5d000ULL, 0x000000a8b33c723eULL, 0x000fc600000010ffULL,
0x0000003900927306ULL, 0x000fe20000205400ULL, 0x0000000185850812ULL, 0x008fc800078efcffULL,
0x000000857485723eULL, 0x000fc600000010ffULL, 0x0000003900797306ULL, 0x000ff0000020d400ULL,
0x000000ca00387306ULL, 0x000ff00000209400ULL, 0x000000ca00397306ULL, 0x000e700000205400ULL,
0x0000003d00497306ULL, 0x0004f0000000d400ULL, 0x0000003e00a97306ULL, 0x000fe20000009400ULL,
0x000100003d3d7824ULL, 0x004fe200078e00ffULL, 0x000000393800720bULL, 0x002fe20003f1d000ULL,
0x000001003f387824ULL, 0x000fe200078e00ffULL, 0x000000a59e39723eULL, 0x000fc400000010ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003e00aa7306ULL, 0x000fe20000005400ULL,
0x0000000149496812ULL, 0x008fe400078efcffULL, 0x000000a2a300720bULL, 0x000fe40003fdd000ULL,
0x00000018ffae7819ULL, 0x000fe40000011438ULL, 0x000000a7a038723eULL, 0x000fe200000010ffULL,
0x0000003e00977306ULL, 0x0003f0000000d400ULL, 0x000000be00b67306ULL, 0x000ea2000020d400ULL,
0x000100003e3e7824ULL, 0x002fe200078e00ffULL, 0x000000014d4d6812ULL, 0x000fc800078efcffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003d00b87306ULL, 0x000ff00000209400ULL,
0x0000003d00b97306ULL, 0x000e620000205400ULL, 0x00000001b6b62812ULL, 0x004fc400078efcffULL,
0x000000589f00720bULL, 0x000fe40003f5d000ULL, 0x0000009ca158723eULL, 0x000fe400000010ffULL,
0x00000049b649723eULL, 0x000fe200000010ffULL, 0x0000003f009d7306ULL, 0x000ff00000009400ULL,
0x0000003f009a7306ULL, 0x000fe20000005400ULL, 0x000000b9b800720bULL, 0x002fc40003f3d000ULL,
0x000000015c5c2812ULL, 0x000fca00078efcffULL, 0x0000003f00517306ULL, 0x0003f0000000d400ULL,
0x0000004700957306ULL, 0x000fe20000209400ULL, 0x000100003f3f7824ULL, 0x002fce00078e00ffULL,
0x0000004700967306ULL, 0x000ff00000205400ULL, 0x0000004700807306ULL, 0x000ff0000020d400ULL,
0x0000003e00437306ULL, 0x000ff00000209400ULL, 0x0000003e00447306ULL, 0x000e700000205400ULL,
0x000000ca00477306ULL, 0x000eb0000020d400ULL, 0x0000003d00b27306ULL, 0x000722000020d400ULL,
0x000000444300720bULL, 0x002fc40003fdd000ULL, 0x000000405b44723eULL, 0x000fe400000010ffULL,
0x000000004240783bULL, 0x000e620000000200ULL, 0x000000585458723cULL, 0x000fe400000418ffULL,
0x000000ba00bb7306ULL, 0x000fe20000209400ULL, 0x000000a4af3d723eULL, 0x008fe400000010ffULL,
0x00000018ffa47819ULL, 0x000fe4000001143fULL, 0x0000000147470812ULL, 0x004fc400078efcffULL,
0x000000aaa900720bULL, 0x000fe20003f1d000ULL, 0x000000ba00b47306ULL, 0x000ea20000205400ULL,
0x00000001b2b21812ULL, 0x010fe400078efcffULL, 0x000000484748723eULL, 0x000fe400000010ffULL,
0x000000b24d4d723eULL, 0x000fc600000010ffULL, 0x000000a4009e7306ULL, 0x000fe80000209400ULL,
0x0000000197970812ULL, 0x000fe400078efcffULL, 0x0000009a9d00720bULL, 0x000fe40003f1d000ULL,
0x000000a4009f7306ULL, 0x000ee20000205400ULL, 0x000000b4bb00720bULL, 0x004fce0003f3d000ULL,
0x0000003e00ad7306ULL, 0x000526000020d400ULL, 0x0000000151510812ULL, 0x000fe400078efcffULL,
0x000000504f00720bULL, 0x000fe20003f1d000ULL, 0x000000094040b231ULL, 0x082fe400003400ffULL,
0x000000ba00bc7306ULL, 0x000e62000020d400ULL, 0x0000009f9e00720bULL, 0x008fe20003f5d000ULL,
0x0000003c543c723cULL, 0x004f6200000418ffULL, 0x000000094242b231ULL, 0x000fc400003400ffULL,
0x000000084141b231ULL, 0x080fe400003400ffULL, 0x000000084343b231ULL, 0x000fe200003400ffULL,
0x000000a400a47306ULL, 0x000ea2000020d400ULL, 0x00000001adad6812ULL, 0x010fe400078efcffULL,
0x0000004a4b00720bULL, 0x000fe40003fdd000ULL, 0x000000ad5c5c723eULL, 0x000fe200000010ffULL,
0x000000485448723cULL, 0x000fe200000418ffULL, 0x0000000173730812ULL, 0x000fe200078efcffULL,
0x000000ae00467306ULL, 0x000fe20000209400ULL, 0x00000001bcbc1812ULL, 0x002fc400078efcffULL,
0x000000969500720bULL, 0x000fe40003f1d000ULL, 0x00000097bc50723eULL, 0x000fe400000010ffULL,
0x000000738686723eULL, 0x000fe200000010ffULL, 0x000000ae00a97306ULL, 0x000e620000205400ULL,
0x00000001a4a42812ULL, 0x004fe200078efcffULL, 0x0000005e403c723cULL, 0x020fe2000004183cULL,
0x000000535200720bULL, 0x000fe40003f5d000ULL, 0x000000015d5d6812ULL, 0x000fc400078efcffULL,
0x0000009b9800720bULL, 0x000fe20003fdd000ULL, 0x000000ae00ae7306ULL, 0x000ea2000020d400ULL,
0x000000a45d5d723eULL, 0x000fe400000010ffULL, 0x0000000180800812ULL, 0x000fe400078efcffULL,
0x000000a94600720bULL, 0x002fc60003f3d000ULL, 0x000000b1009a7306ULL, 0x000fe20000209400ULL,
0x0000000172722812ULL, 0x000fe200078efcffULL, 0x000000445444723cULL, 0x000f6200000418ffULL,
0x000000929100720bULL, 0x000fe40003f5d000ULL, 0x000000017f7f6812ULL, 0x000fe400078efcffULL,
0x0000008a8900720bULL, 0x000fe20003fdd000ULL, 0x000000b100977306ULL, 0x000e620000205400ULL,
0x0000008b8489723eULL, 0x000fe400000010ffULL, 0x000000877e84723eULL, 0x000fc400000010ffULL,
0x00000001aeae1812ULL, 0x004fe400078efcffULL, 0x0000004e9900720bULL, 0x000fe20003f3d000ULL,
0x0000003b007c7306ULL, 0x000fe20000009400ULL, 0x00000051ae51723eULL, 0x000fe200000010ffULL,
0x0000004c544c723cULL, 0x040f6200000418ffULL, 0x0000000179792812ULL, 0x000fe400078efcffULL,
0x000000016e6e6812ULL, 0x000fe400078efcffULL, 0x0000007f7272723eULL, 0x000fe200000010ffULL,
0x0000003b007d7306ULL, 0x000ea20000005400ULL, 0x000000979a00720bULL, 0x002fe20003f5d000ULL,
0x000000505450723cULL, 0x000fe200000418ffULL, 0x000000796e73723eULL, 0x000fc400000010ffULL,
0x0000000171711812ULL, 0x000fc600078efcffULL, 0x0000003a00827306ULL, 0x000fe20000009400ULL,
0x000000718087723eULL, 0x000fe200000010ffULL, 0x000000844044723cULL, 0x060fec0000041844ULL,
0x0000003a00837306ULL, 0x000e620000005400ULL, 0x0000007d7c00720bULL, 0x004fe20003fdd000ULL,
0x000000864048723cULL, 0x040fec0000041848ULL, 0x000000e8008f7306ULL, 0x000fe40000209400ULL,
0x00000072404c723cULL, 0x000fec000004184cULL, 0x000000e800907306ULL, 0x000ea20000205400ULL,
0x000000838200720bULL, 0x002fce0003f3d000ULL, 0x0000003a006f7306ULL, 0x000e70000000d400ULL,
0x0000003b00707306ULL, 0x000722000000d400ULL, 0x000000908f00720bULL, 0x004fe40003f1d000ULL,
0x0000007b8c8f723eULL, 0x000fca00000010ffULL, 0x000000b100997306ULL, 0x000ea2000020d400ULL,
0x000000385438723cULL, 0x008f6200000418ffULL, 0x000000016f6f1812ULL, 0x002fe400078efcffULL,
0x000000787700720bULL, 0x000fc80003f3d000ULL, 0x000000b000937306ULL, 0x000fe20000209400ULL,
0x0000005c5454723cULL, 0x000b6200000418ffULL, 0x0000000170706812ULL, 0x010fcc00078efcffULL,
0x000000b0005c7306ULL, 0x020e620000205400ULL, 0x0000000199992812ULL, 0x004fe200078efcffULL,
0x0000008e4058723cULL, 0x040b620000041858ULL, 0x000000016d6d1812ULL, 0x000fe400078efcffULL,
0x00000070997b723eULL, 0x000fe400000010ffULL, 0x0000006a6100720cULL, 0x000fe20003f26070ULL,
0x000000ac005e7306ULL, 0x000fe40000209400ULL, 0x000000884038723cULL, 0x000b6c0000041838ULL,
0x000000ac005f7306ULL, 0x000ea20000205400ULL, 0x0000005c9300720bULL, 0x002fc40003f5d000ULL,
0x000000016a5c7810ULL, 0x000fc80007ffe0ffULL, 0x0000005c6100720cULL, 0x000fe20004f26470ULL,
0x000000e8007a7306ULL, 0x000e70000020d400ULL, 0x000000b0005d7306ULL, 0x000ee2000020d400ULL,
0x0000005f5e00720bULL, 0x004fce0003fdd000ULL, 0x000000ac00ac7306ULL, 0x000ea2000020d400ULL,
0x000000017a7a0812ULL, 0x002fe400078efcffULL, 0x000000767500720bULL, 0x000fe40003f1d000ULL,
0x0000006f7a7a723eULL, 0x000fe400000010ffULL, 0x000000015d5d2812ULL, 0x008fe400078efcffULL,
0x0000006a6200720cULL, 0x000fc60003f46070ULL, 0x0000007a4050723cULL, 0x000b620000041850ULL,
0x0000005c6200720cULL, 0x000fe40005746470ULL, 0x00000001acac6812ULL, 0x004fe400078efcffULL,
0x0000000f3400720cULL, 0x000fe40003fc3070ULL, 0x000000016c6c0812ULL, 0x000fe400078efcffULL,
0x000000ac6d6d723eULL, 0x000fe400000010ffULL, 0x0000005d6c6c723eULL, 0x000fc400000010ffULL,
0x0000000f3400720cULL, 0x000fca0003f03070ULL, 0x0000006c4054723cULL, 0x000b620000041854ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000003c12127221ULL, 0x000fe40000010000ULL, 0x0000003d13137221ULL, 0x000fe40000010000ULL,
0x0000003816167221ULL, 0x020fe40000010000ULL, 0x0000003917177221ULL, 0x000fe40000010000ULL,
0x000000581a1a7221ULL, 0x000fe40000010000ULL, 0x000000591b1b7221ULL, 0x000fc40000010000ULL,
0x000000441e1e7221ULL, 0x000fe40000010000ULL, 0x000000451f1f7221ULL, 0x000fe40000010000ULL,
0x0000004822227221ULL, 0x000fe40000010000ULL, 0x0000004923237221ULL, 0x000fe40000010000ULL,
0x0000004c26267221ULL, 0x000fe40000010000ULL, 0x0000004d27277221ULL, 0x000fc40000010000ULL,
0x000000502a2a7221ULL, 0x000fe40000010000ULL, 0x000000512b2b7221ULL, 0x000fe40000010000ULL,
0x000000542e2e7221ULL, 0x000fe40000010000ULL, 0x000000552f2f7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000003e14147221ULL, 0x000fe40000010000ULL,
0x0000003f15157221ULL, 0x000fe40000010000ULL, 0x0000003a18187221ULL, 0x020fc40000010000ULL,
0x0000003b19197221ULL, 0x000fe40000010000ULL, 0x0000005a1c1c7221ULL, 0x000fe40000010000ULL,
0x0000005b1d1d7221ULL, 0x000fe40000010000ULL, 0x0000004620207221ULL, 0x000fe40000010000ULL,
0x0000004721217221ULL, 0x000fe40000010000ULL, 0x0000004a24247221ULL, 0x000fc40000010000ULL,
0x0000004b25257221ULL, 0x000fe40000010000ULL, 0x0000004e28287221ULL, 0x000fe40000010000ULL,
0x0000004f29297221ULL, 0x000fe40000010000ULL, 0x000000522c2c7221ULL, 0x000fe40000010000ULL,
0x000000532d2d7221ULL, 0x000fe40000010000ULL, 0x0000005630307221ULL, 0x000fc40000010000ULL,
0x0000005731317221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x020e62000c80043fULL,
0x00000002ff3b7819ULL, 0x000fe2000001165cULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000f3400720cULL, 0x000fe40003fc3070ULL, 0x0000003b5c3b7207ULL, 0x040fe40002800000ULL,
0x000000035c5c7812ULL, 0x000fe400078ec0ffULL, 0x0000000f3400720cULL, 0x000fe40003f03070ULL,
0x00000040ff587803ULL, 0x000fc40000000000ULL, 0x000000ff5c5c7207ULL, 0x000fe40006800000ULL,
0x000000023b387810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3f7224ULL, 0x000fc600078e0039ULL,
0x0000000338417812ULL, 0x040fe400078ec0ffULL, 0x0000000f38437211ULL, 0x000fc400078ff0ffULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b8400ff3a7984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe200078c486bULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8400ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe400078c486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x018b8c00ff3a7984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000143397810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x000000363900720cULL, 0x000fda0003fc6070ULL,
0x000005100000e947ULL, 0x000fea0003800000ULL, 0x0000000507407c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff457424ULL, 0x000fe400078e00ffULL, 0x00000010323a7824ULL, 0x000fe400078e00ffULL,
0x018a0000403c7984ULL, 0x000e620000004800ULL, 0x0000004035427824ULL, 0x000fe400078e0240ULL,
0x000000f03a477812ULL, 0x000fe200078ec0ffULL, 0x018ac0003c3c7984ULL, 0x002e640000004800ULL,
0x0000003c0d387224ULL, 0x002fc400078e0242ULL, 0x00000010403c7824ULL, 0x000fe400078e00ffULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe400030e0639ULL, 0x0000000443397824ULL, 0x000fc800078e0241ULL,
0x0000004039397824ULL, 0x000fca00078e00ffULL, 0x0000003960387217ULL, 0x000fca0007800000ULL,
0x0000000138387824ULL, 0x000fe400078e0a39ULL, 0x0000000140397824ULL, 0x000fc600078e0232ULL,
0x0000000538387c17ULL, 0x000fe4000f800000ULL, 0xfffffff03c397812ULL, 0x000fe400078ee239ULL,
0x80000005383e7c10ULL, 0x000fe4000fffe0ffULL, 0x0001400039497811ULL, 0x000fe400078e20ffULL,
0x0000003e0700720cULL, 0x000fe40003fc6070ULL, 0x0000000242397810ULL, 0x000fd60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a497faeULL, 0x0003e8000f101c4aULL,
0x018a0800403f7984ULL, 0x000ea80000004800ULL, 0x018ac0003f387984ULL, 0x004ea40000004800ULL,
0x000000380d387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x0000000207397810ULL, 0x000fc80007ffe0ffULL, 0x00000005394b7c10ULL, 0x040fe4000fffe0ffULL,
0x0000003e3900720cULL, 0x000fe40003fc6070ULL, 0x0000000442397810ULL, 0x000fe20007ffe0ffULL,
0x000000014b387824ULL, 0x040fe400078e0232ULL, 0x000000104b4b7824ULL, 0x000fca00078e00ffULL,
0xfffffff04b387812ULL, 0x000fc800078ee238ULL, 0x0001400038497811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c497faeULL, 0x0003e8000f101c4aULL,
0x018a1000403f7984ULL, 0x000ea80000004800ULL, 0x018ac0003f387984ULL, 0x0044e40000004800ULL,
0x00000006073f7810ULL, 0x004fe20007ffe0ffULL, 0x000000380d387224ULL, 0x008fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x0000000407397810ULL, 0x000fc80007ffe0ffULL,
0x00000005394b7c10ULL, 0x040fe4000fffe0ffULL, 0x0000003e3900720cULL, 0x000fc60003fc6070ULL,
0x000000014b387824ULL, 0x040fe400078e0232ULL, 0x000000104b4b7824ULL, 0x000fca00078e00ffULL,
0xfffffff04b387812ULL, 0x000fc800078ee238ULL, 0x00014000383d7811ULL, 0x002fe400078e20ffULL,
0x0000000642387810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000f101c4aULL, 0x018a1800403c7984ULL, 0x000ea80000004800ULL,
0x018ac0003c3c7984ULL, 0x004ea40000004800ULL, 0x0000003c0d387224ULL, 0x004fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fe200078e0045ULL, 0x000000053f457c10ULL, 0x000fc8000fffe0ffULL,
0x0000004738387210ULL, 0x000fe20007fde0ffULL, 0x0000000145427824ULL, 0x040fe400078e0232ULL,
0x0000001045457824ULL, 0x000fe400078e00ffULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x0000003e3f00720cULL, 0x000fe40003fc6070ULL, 0xfffffff045427812ULL, 0x000fc800078ee242ULL,
0x00014000423b7811ULL, 0x002fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000f101c4aULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x00000005073f7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff457424ULL, 0x000fe400078e00ffULL,
0x00000010323a7824ULL, 0x000fe400078e00ffULL, 0x018a00003f3c7984ULL, 0x000e620000004800ULL,
0x0000004035407824ULL, 0x000fe400078e023fULL, 0x000000f03a477812ULL, 0x000fe200078ec0ffULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0240ULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fe20007fde0ffULL,
0x000000013f387824ULL, 0x000fc800078e0232ULL, 0x000000ffff3b7224ULL, 0x000fe400030e0639ULL,
0x000000103f397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0001400038497811ULL, 0x000fe400078e20ffULL, 0x0000000240387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a497faeULL, 0x0003e8000b901c4aULL,
0x018a08003f3e7984ULL, 0x000ea80000004800ULL, 0x018ac0003e3e7984ULL, 0x004ea40000004800ULL,
0x0000003e0d387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000023f397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0232ULL,
0x0000001039397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0001400038497811ULL, 0x002fe400078e20ffULL, 0x0000000440387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c497faeULL, 0x0003e8000b901c4aULL,
0x018a10003f3e7984ULL, 0x000ea80000004800ULL, 0x018ac0003e3e7984ULL, 0x004ea40000004800ULL,
0x0000003e0d387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000043f397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0232ULL,
0x0000001039397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x00014000383d7811ULL, 0x002fe400078e20ffULL, 0x0000000640387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c4aULL,
0x018a18003f3c7984ULL, 0x000ea80000004800ULL, 0x018ac0003c3c7984ULL, 0x004ea40000004800ULL,
0x0000003c0d387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fe200078e0045ULL,
0x000000063f457810ULL, 0x000fc80007ffe0ffULL, 0x0000004738387210ULL, 0x000fe20007fde0ffULL,
0x00000001453e7824ULL, 0x040fe400078e0232ULL, 0x0000001045457824ULL, 0x000fe400078e00ffULL,
0x000000ffff397224ULL, 0x000fc600030e0639ULL, 0xfffffff0453e7812ULL, 0x000fc800078ee23eULL,
0x000140003e3b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000b901c4aULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x018b8c00ff3a7984ULL, 0x000e620000000800ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe200078c483fULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe400078c483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000433400720cULL, 0x000fe20003fc4070ULL, 0x00000004ff3a7424ULL, 0x000fe200078e00ffULL,
0x00018a000c3d7811ULL, 0x000fe400078e10ffULL, 0x000000ff5c387207ULL, 0x000fc40003000000ULL,
0x000000ff5c5c7207ULL, 0x000fc60007000000ULL, 0x0000000141387824ULL, 0x000fc800078e0238ULL,
0x0000004038397824ULL, 0x040fe200078e00ffULL, 0x0000004338387211ULL, 0x000fc800078ff0ffULL,
0x000000c039397812ULL, 0x000fca00078ec0ffULL, 0x0000010038387824ULL, 0x000fe200078e0239ULL,
0x0000000c5c397c10ULL, 0x000fc8000fffe0ffULL, 0x0000002038387810ULL, 0x000fca0007ffe0ffULL,
0x000000010c3b7824ULL, 0x100fe400078e0238ULL, 0x0000680039397a24ULL, 0x000fc600078e0238ULL,
0x000000603b00720cULL, 0x000fe20003fc6070ULL, 0x000000010c397824ULL, 0x000fc800078e0239ULL,
0x0000660039387625ULL, 0x000fd000078e003aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383d7faeULL, 0x0003e4000f12184aULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b7800ff387f8cULL, 0x000e62000c80043fULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x000000ffff6b7224ULL, 0x002fe200078e0039ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x0000000aff08723eULL, 0x000fc800000010ffULL, 0x00005410083a7816ULL, 0x000fe20000000008ULL,
0x00013c327f007947ULL, 0x000fea000b800000ULL, 0x00001f623a097589ULL, 0x0002a400000e0000ULL,
0x00013c927f007947ULL, 0x000fea000b800000ULL, 0x00001f613a087589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010623f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x00015a9000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000146c000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018623f7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff407424ULL, 0x000fe200078e00ffULL, 0x00015b0000387802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0001465000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000663c783bULL, 0x006e620000004200ULL, 0x00001e3000017945ULL, 0x000fe60003800000ULL,
0x000000006540783bULL, 0x000ea80000004200ULL, 0x000000006444783bULL, 0x000f220000004200ULL,
0x0000003c00387306ULL, 0x002ff00000009400ULL, 0x0000003c00397306ULL, 0x000e700000005400ULL,
0x0000003c004c7306ULL, 0x000ee2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000003d004d7306ULL, 0x000ff0000000d400ULL, 0x0000003d00387306ULL, 0x000fe20000009400ULL,
0x000000014c4c6812ULL, 0x008fce00078efcffULL, 0x0000003d00397306ULL, 0x000e700000005400ULL,
0x0000003e004b7306ULL, 0x000fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000003f004a7306ULL, 0x000ff0000000d400ULL, 0x0000003e00387306ULL, 0x000fe20000009400ULL,
0x000000014d4d6812ULL, 0x000fce00078efcffULL, 0x0000003e00397306ULL, 0x000e700000005400ULL,
0x0000004000497306ULL, 0x004fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000004100487306ULL, 0x000ff0000000d400ULL, 0x0000003f00387306ULL, 0x000fe20000009400ULL,
0x000000014b4b6812ULL, 0x000fce00078efcffULL, 0x0000003f00397306ULL, 0x000e700000005400ULL,
0x00000042007a7306ULL, 0x000fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000004300787306ULL, 0x000ff0000000d400ULL, 0x0000004000387306ULL, 0x000fe20000009400ULL,
0x000000014a4a6812ULL, 0x000fce00078efcffULL, 0x0000004000397306ULL, 0x000e700000005400ULL,
0x0000004400767306ULL, 0x010fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000004500757306ULL, 0x000ff0000000d400ULL, 0x0000004100387306ULL, 0x000fe20000009400ULL,
0x0000000149496812ULL, 0x000fce00078efcffULL, 0x0000004100397306ULL, 0x000e700000005400ULL,
0x0000004600727306ULL, 0x000fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000004700707306ULL, 0x000ff0000000d400ULL, 0x0000004200387306ULL, 0x000fe20000009400ULL,
0x0000000148486812ULL, 0x000fce00078efcffULL, 0x0000004200397306ULL, 0x000e640000005400ULL,
0x000000393800720bULL, 0x002fcc0003fdd000ULL, 0x0000004300387306ULL, 0x000ff00000009400ULL,
0x0000004300397306ULL, 0x000e620000005400ULL, 0x000000017a7a6812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fca0003fdd000ULL, 0x0000004400387306ULL, 0x000ff00000009400ULL,
0x0000004400397306ULL, 0x000e620000005400ULL, 0x0000000178786812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fca0003fdd000ULL, 0x0000004500387306ULL, 0x000ff00000009400ULL,
0x0000004500397306ULL, 0x000e620000005400ULL, 0x0000000176766812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fca0003fdd000ULL, 0x0000004600387306ULL, 0x000ff00000009400ULL,
0x0000004600397306ULL, 0x000e620000005400ULL, 0x0000000175756812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fca0003fdd000ULL, 0x0000004700387306ULL, 0x000ff00000009400ULL,
0x0000004700397306ULL, 0x000e620000005400ULL, 0x0000000172726812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fc40003fdd000ULL, 0x000000006338783bULL, 0x000e760000004200ULL,
0x0000000170706812ULL, 0x000fe200078efcffULL, 0x00000038004e7306ULL, 0x002ff00000009400ULL,
0x00000038004f7306ULL, 0x000e700000005400ULL, 0x00000038006e7306ULL, 0x000ea2000000d400ULL,
0x0000004f4e00720bULL, 0x002fce0003fdd000ULL, 0x00000039006d7306ULL, 0x000ff0000000d400ULL,
0x00000039004e7306ULL, 0x000fe20000009400ULL, 0x000000016e6e6812ULL, 0x004fce00078efcffULL,
0x00000039004f7306ULL, 0x000e700000005400ULL, 0x0000003a006c7306ULL, 0x000fe2000000d400ULL,
0x0000004f4e00720bULL, 0x002fce0003fdd000ULL, 0x0000003a004e7306ULL, 0x000ff00000009400ULL,
0x0000003a004f7306ULL, 0x000e620000005400ULL, 0x000000016d6d6812ULL, 0x000fe400078efcffULL,
0x0000004f4e00720bULL, 0x002fc40003fdd000ULL, 0x00000018ff4e7819ULL, 0x000fc8000001143cULL,
0x0000004e004f7306ULL, 0x000fee0000209400ULL, 0x000000016c6c6812ULL, 0x000fe200078efcffULL,
0x0000004e00507306ULL, 0x000e700000205400ULL, 0x0000004e00517306ULL, 0x000ea2000020d400ULL,
0x000000504f00720bULL, 0x002fc40003fdd000ULL, 0x00000018ff4f7819ULL, 0x000fca000001143dULL,
0x0000004f00527306ULL, 0x000fec0000209400ULL, 0x0000000151516812ULL, 0x004fe400078efcffULL,
0x0000004f00537306ULL, 0x000e700000205400ULL, 0x0000004f00507306ULL, 0x000ea2000020d400ULL,
0x000000535200720bULL, 0x002fc40003fdd000ULL, 0x00000018ff527819ULL, 0x000fca000001143eULL,
0x0000005200537306ULL, 0x000fec0000209400ULL, 0x0000000150506812ULL, 0x004fe400078efcffULL,
0x0000005200547306ULL, 0x000e700000205400ULL, 0x00000052004e7306ULL, 0x000ea2000020d400ULL,
0x000000545300720bULL, 0x002fc40003fdd000ULL, 0x00000018ff537819ULL, 0x000fca000001143fULL,
0x0000005300547306ULL, 0x000fec0000209400ULL, 0x000000014e4e6812ULL, 0x004fe400078efcffULL,
0x0000005300557306ULL, 0x000e700000205400ULL, 0x00000053004f7306ULL, 0x0004e2000020d400ULL,
0x000000555400720bULL, 0x002fc40003fdd000ULL, 0x00000018ff547819ULL, 0x000fe40000011440ULL,
0x00000018ff537819ULL, 0x004fc60000011442ULL, 0x0000005400557306ULL, 0x000fec0000209400ULL,
0x000000014f4f6812ULL, 0x008fe400078efcffULL, 0x0000005400527306ULL, 0x000e700000205400ULL,
0x00000054007f7306ULL, 0x000ea2000020d400ULL, 0x000000525500720bULL, 0x002fce0003fdd000ULL,
0x0000005300547306ULL, 0x000fe20000205400ULL, 0x00000018ff527819ULL, 0x000fce0000011441ULL,
0x0000005200557306ULL, 0x000fe20000209400ULL, 0x000000017f7f6812ULL, 0x004fce00078efcffULL,
0x0000005200567306ULL, 0x000e700000205400ULL, 0x00000052007e7306ULL, 0x000ea2000020d400ULL,
0x000000565500720bULL, 0x002fce0003fdd000ULL, 0x00000053007c7306ULL, 0x000ff0000020d400ULL,
0x0000005300557306ULL, 0x0002e20000209400ULL, 0x000000017e7e6812ULL, 0x004fe400078efcffULL,
0x00000018ff537819ULL, 0x002fca0000011445ULL, 0x0000005300797306ULL, 0x000fe2000020d400ULL,
0x000000545500720bULL, 0x008fe40003fdd000ULL, 0x00000018ff547819ULL, 0x000fca0000011443ULL,
0x0000005400557306ULL, 0x000fec0000209400ULL, 0x000000017c7c6812ULL, 0x000fe400078efcffULL,
0x0000005400527306ULL, 0x000e700000205400ULL, 0x00000054007d7306ULL, 0x000ea2000020d400ULL,
0x000000525500720bULL, 0x002fce0003fdd000ULL, 0x0000005300547306ULL, 0x000fe20000205400ULL,
0x00000018ff527819ULL, 0x000fce0000011444ULL, 0x0000005200557306ULL, 0x000fe20000209400ULL,
0x000000017d7d6812ULL, 0x004fce00078efcffULL, 0x0000005200567306ULL, 0x000e700000205400ULL,
0x00000052007b7306ULL, 0x000ea2000020d400ULL, 0x000000565500720bULL, 0x002fce0003fdd000ULL,
0x0000005300557306ULL, 0x0002e40000209400ULL, 0x00000018ff537819ULL, 0x002fc80000011438ULL,
0x000000017b7b6812ULL, 0x004fe400078efcffULL, 0x0000005300737306ULL, 0x000fe2000020d400ULL,
0x000000545500720bULL, 0x008fe40003fdd000ULL, 0x00000018ff547819ULL, 0x000fca0000011446ULL,
0x0000005400557306ULL, 0x000fec0000209400ULL, 0x0000000179796812ULL, 0x000fe400078efcffULL,
0x0000005400527306ULL, 0x000e700000205400ULL, 0x0000005400777306ULL, 0x000ea2000020d400ULL,
0x000000525500720bULL, 0x002fce0003fdd000ULL, 0x0000005300547306ULL, 0x000fe20000205400ULL,
0x00000018ff527819ULL, 0x000fce0000011447ULL, 0x0000005200557306ULL, 0x000fe20000209400ULL,
0x0000000177776812ULL, 0x004fce00078efcffULL, 0x0000005200567306ULL, 0x000e700000205400ULL,
0x0000005200747306ULL, 0x000ea2000020d400ULL, 0x000000565500720bULL, 0x002fce0003fdd000ULL,
0x0000005300557306ULL, 0x000e620000209400ULL, 0x00000018ff567819ULL, 0x000fce000001143aULL,
0x0000005600537306ULL, 0x000fe20000205400ULL, 0x0000000174746812ULL, 0x004fe400078efcffULL,
0x000000545500720bULL, 0x002fca0003fdd000ULL, 0x00000056006f7306ULL, 0x000fe2000020d400ULL,
0x00000018ff547819ULL, 0x000fce0000011439ULL, 0x0000005400557306ULL, 0x000fe20000209400ULL,
0x0000000173736812ULL, 0x000fce00078efcffULL, 0x0000005400527306ULL, 0x000e700000205400ULL,
0x0000005400717306ULL, 0x000ea2000020d400ULL, 0x000000525500720bULL, 0x002fce0003fdd000ULL,
0x0000005600527306ULL, 0x000e6c0000209400ULL, 0x0000000171716812ULL, 0x004fe400078efcffULL,
0x000000535200720bULL, 0x002fe20003fdd000ULL, 0x000001003c527824ULL, 0x040fe400078e00ffULL,
0x000100003c3c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff527819ULL, 0x000fc80000011452ULL,
0x0000005200547306ULL, 0x000fe60000209400ULL, 0x000000016f6f6812ULL, 0x000fca00078efcffULL,
0x0000005200557306ULL, 0x000e700000205400ULL, 0x0000005200537306ULL, 0x000ea2000020d400ULL,
0x000000555400720bULL, 0x002fe40003fdd000ULL, 0x00000018ff557819ULL, 0x000fca000001143cULL,
0x00000055003c7306ULL, 0x000fec0000209400ULL, 0x0000000153536812ULL, 0x004fe400078efcffULL,
0x0000005500577306ULL, 0x000e640000205400ULL, 0x0000004c534c723eULL, 0x000fcc00000010ffULL,
0x0000005500547306ULL, 0x000ea2000020d400ULL, 0x000000573c00720bULL, 0x002fe20003fdd000ULL,
0x000001003d3c7824ULL, 0x040fe400078e00ffULL, 0x000100003d3d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff527819ULL, 0x000fe4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005200567306ULL, 0x000fe60000209400ULL, 0x0000000154546812ULL, 0x004fc800078efcffULL,
0x000000545154723eULL, 0x000fe200000010ffULL, 0x0000005200577306ULL, 0x000e700000205400ULL,
0x00000052003c7306ULL, 0x000ea2000020d400ULL, 0x000000575600720bULL, 0x002fce0003fdd000ULL,
0x0000003d00557306ULL, 0x000ff0000020d400ULL, 0x0000003d00567306ULL, 0x000fe20000209400ULL,
0x000000013c3c6812ULL, 0x004fce00078efcffULL, 0x0000003d00577306ULL, 0x000e620000205400ULL,
0x0000004d3c4d723eULL, 0x000fe400000010ffULL, 0x00013000673c7811ULL, 0x000fe400078e20ffULL,
0x000000575600720bULL, 0x002fe20003fdd000ULL, 0x000001003e567824ULL, 0x040fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000005600577306ULL, 0x000fe60000209400ULL,
0x0000000155556812ULL, 0x000fc800078efcffULL, 0x000000555055723eULL, 0x000fe200000010ffULL,
0x00000056005a7306ULL, 0x000e700000205400ULL, 0x0000005600527306ULL, 0x000ea2000020d400ULL,
0x0000005a5700720bULL, 0x002fce0003fdd000ULL, 0x0000003e003d7306ULL, 0x000ff0000020d400ULL,
0x0000003e00577306ULL, 0x000fe20000209400ULL, 0x0000000152526812ULL, 0x004fce00078efcffULL,
0x0000003e005a7306ULL, 0x000e620000205400ULL, 0x0000004b5250723eULL, 0x000fe400000010ffULL,
0x0000005a5700720bULL, 0x002fe20003fdd000ULL, 0x000001003f577824ULL, 0x040fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000005700567306ULL, 0x000fe60000209400ULL,
0x000000013d3d6812ULL, 0x000fc800078efcffULL, 0x0000003d4e4e723eULL, 0x000fe200000010ffULL,
0x0000005700597306ULL, 0x000e700000205400ULL, 0x0000005700817306ULL, 0x000ea2000020d400ULL,
0x000000595600720bULL, 0x002fce0003fdd000ULL, 0x0000003f003e7306ULL, 0x000ff0000020d400ULL,
0x0000003f00567306ULL, 0x000fe20000209400ULL, 0x0000000181816812ULL, 0x004fce00078efcffULL,
0x0000003f00597306ULL, 0x000e620000205400ULL, 0x0000004a8151723eULL, 0x000fe400000010ffULL,
0x000000595600720bULL, 0x002fe20003fdd000ULL, 0x0000010040567824ULL, 0x040fe400078e00ffULL,
0x0001000040407824ULL, 0x000fc600078e00ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x00000018ff3f7819ULL, 0x000fe40000011440ULL, 0x0000005600577306ULL, 0x000fe60000209400ULL,
0x000000013e3e6812ULL, 0x000fc800078efcffULL, 0x0000003e4f4f723eULL, 0x000fe200000010ffULL,
0x00000056005a7306ULL, 0x000e700000205400ULL, 0x0000005600807306ULL, 0x000ea2000020d400ULL,
0x0000005a5700720bULL, 0x002fce0003fdd000ULL, 0x0000003f00407306ULL, 0x000ff0000020d400ULL,
0x0000003f00577306ULL, 0x000fe20000209400ULL, 0x0000000180806812ULL, 0x004fce00078efcffULL,
0x0000003f005a7306ULL, 0x000e620000205400ULL, 0x00000049804a723eULL, 0x000fe400000010ffULL,
0x0000005a5700720bULL, 0x002fe20003fdd000ULL, 0x0000010041577824ULL, 0x040fe400078e00ffULL,
0x0001000041417824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000018ff3f7819ULL, 0x000fe40000011441ULL, 0x0000005700567306ULL, 0x000fe60000209400ULL,
0x0000000140406812ULL, 0x000fc800078efcffULL, 0x000000407f40723eULL, 0x000fe200000010ffULL,
0x0000005700597306ULL, 0x000e700000205400ULL, 0x0000005700877306ULL, 0x000ea2000020d400ULL,
0x000000595600720bULL, 0x002fce0003fdd000ULL, 0x0000003f00417306ULL, 0x000ff0000020d400ULL,
0x0000003f00567306ULL, 0x000fe20000209400ULL, 0x0000000187876812ULL, 0x004fce00078efcffULL,
0x0000003f00597306ULL, 0x000e620000205400ULL, 0x00000048874b723eULL, 0x000fce00000010ffULL,
0x0000003b007f7306ULL, 0x000fe20000005400ULL, 0x000000595600720bULL, 0x002fe20003fdd000ULL,
0x0000010042567824ULL, 0x040fe400078e00ffULL, 0x0001000042427824ULL, 0x000fc600078e00ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x0000005600577306ULL, 0x000fe60000209400ULL, 0x0000000141416812ULL, 0x000fc800078efcffULL,
0x000000417e41723eULL, 0x000fe200000010ffULL, 0x00000056005a7306ULL, 0x000e700000205400ULL,
0x0000005600857306ULL, 0x000ea2000020d400ULL, 0x0000005a5700720bULL, 0x002fce0003fdd000ULL,
0x00000042003f7306ULL, 0x000ff00000209400ULL, 0x00000042005a7306ULL, 0x000e620000205400ULL,
0x0000000185856812ULL, 0x004fce00078efcffULL, 0x0000004200837306ULL, 0x000ea2000020d400ULL,
0x0000005a3f00720bULL, 0x002fe20003fdd000ULL, 0x00000100433f7824ULL, 0x040fe400078e00ffULL,
0x0001000043437824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000003f00567306ULL, 0x000fe60000209400ULL,
0x0000000183836812ULL, 0x004fc800078efcffULL, 0x000000837c7c723eULL, 0x000fe200000010ffULL,
0x0000003f00577306ULL, 0x000e700000205400ULL, 0x0000003f00897306ULL, 0x000ea2000020d400ULL,
0x000000575600720bULL, 0x002fce0003fdd000ULL, 0x0000004300427306ULL, 0x000ff00000209400ULL,
0x0000004300577306ULL, 0x000e620000205400ULL, 0x0000000189896812ULL, 0x004fce00078efcffULL,
0x0000004300887306ULL, 0x000ea2000020d400ULL, 0x000000574200720bULL, 0x002fe20003fdd000ULL,
0x0000010044427824ULL, 0x040fe400078e00ffULL, 0x0001000044447824ULL, 0x000fc600078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x00000042003f7306ULL, 0x000fe60000209400ULL, 0x0000000188886812ULL, 0x004fc800078efcffULL,
0x000000887d7d723eULL, 0x000fe200000010ffULL, 0x0000004200567306ULL, 0x000e700000205400ULL,
0x00000042008b7306ULL, 0x000ea2000020d400ULL, 0x000000563f00720bULL, 0x002fce0003fdd000ULL,
0x0000004400827306ULL, 0x000ff0000020d400ULL, 0x00000044003f7306ULL, 0x000fe20000209400ULL,
0x000000018b8b6812ULL, 0x004fce00078efcffULL, 0x0000004400567306ULL, 0x000e640000205400ULL,
0x000000563f00720bULL, 0x002fe20003fdd000ULL, 0x00000100453f7824ULL, 0x040fe400078e00ffULL,
0x0001000045457824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000003f00427306ULL, 0x000fe60000209400ULL,
0x0000000182826812ULL, 0x000fca00078efcffULL, 0x0000003f00437306ULL, 0x000e700000205400ULL,
0x0000003f008a7306ULL, 0x000ea2000020d400ULL, 0x000000434200720bULL, 0x002fce0003fdd000ULL,
0x0000004500847306ULL, 0x000ff0000020d400ULL, 0x0000004500427306ULL, 0x000fe20000209400ULL,
0x000000018a8a6812ULL, 0x004fce00078efcffULL, 0x0000004500437306ULL, 0x000e640000205400ULL,
0x000000434200720bULL, 0x002fe20003fdd000ULL, 0x0000010046427824ULL, 0x040fe400078e00ffULL,
0x0001000046467824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000042003f7306ULL, 0x000fe60000209400ULL,
0x0000000184846812ULL, 0x000fc800078efcffULL, 0x000000847979723eULL, 0x000fe200000010ffULL,
0x0000004200447306ULL, 0x000e700000205400ULL, 0x00000042008d7306ULL, 0x000ea2000020d400ULL,
0x000000443f00720bULL, 0x002fce0003fdd000ULL, 0x0000004600867306ULL, 0x000ff0000020d400ULL,
0x00000046003f7306ULL, 0x000fe20000209400ULL, 0x000000018d8d6812ULL, 0x004fce00078efcffULL,
0x0000004600447306ULL, 0x000e640000205400ULL, 0x000000443f00720bULL, 0x002fe20003fdd000ULL,
0x00000100473f7824ULL, 0x040fe400078e00ffULL, 0x0001000047477824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000003f00427306ULL, 0x000fe60000209400ULL, 0x0000000186866812ULL, 0x000fc800078efcffULL,
0x000000867786723eULL, 0x000fe200000010ffULL, 0x0000003f00437306ULL, 0x000e700000205400ULL,
0x0000003f008f7306ULL, 0x000ea2000020d400ULL, 0x000000434200720bULL, 0x002fce0003fdd000ULL,
0x0000004700917306ULL, 0x000ff0000020d400ULL, 0x0000004700427306ULL, 0x000fe20000209400ULL,
0x000000018f8f6812ULL, 0x004fce00078efcffULL, 0x0000004700437306ULL, 0x000e640000205400ULL,
0x000000434200720bULL, 0x002fe20003fdd000ULL, 0x0000010038427824ULL, 0x040fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000042003f7306ULL, 0x000fe60000209400ULL,
0x0000000191916812ULL, 0x000fc800078efcffULL, 0x000000917487723eULL, 0x000fe200000010ffULL,
0x0000004200447306ULL, 0x000e700000205400ULL, 0x0000004200937306ULL, 0x000ea2000020d400ULL,
0x000000443f00720bULL, 0x002fce0003fdd000ULL, 0x00000038008c7306ULL, 0x000ff0000020d400ULL,
0x00000038003f7306ULL, 0x000fe20000209400ULL, 0x0000000193936812ULL, 0x004fce00078efcffULL,
0x0000003800447306ULL, 0x000e640000205400ULL, 0x000000443f00720bULL, 0x002fe20003fdd000ULL,
0x00000100393f7824ULL, 0x040fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003f00427306ULL, 0x000fe60000209400ULL, 0x000000018c8c6812ULL, 0x000fca00078efcffULL,
0x0000003f00437306ULL, 0x000e700000205400ULL, 0x0000003f008e7306ULL, 0x000ea2000020d400ULL,
0x000000434200720bULL, 0x002fce0003fdd000ULL, 0x0000003900387306ULL, 0x000ff00000209400ULL,
0x0000003900437306ULL, 0x000e620000205400ULL, 0x000000018e8e6812ULL, 0x004fce00078efcffULL,
0x0000003900907306ULL, 0x000ea2000020d400ULL, 0x000000433800720bULL, 0x002fe20003fdd000ULL,
0x000001003a387824ULL, 0x040fe200078e00ffULL, 0x000000788943723eULL, 0x000fe200000010ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000000827b78723eULL, 0x000fe400000010ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000038003f7306ULL, 0x000fe60000209400ULL, 0x0000000190906812ULL, 0x004fc800078efcffULL,
0x000000907171723eULL, 0x000fe200000010ffULL, 0x0000003800427306ULL, 0x000e700000205400ULL,
0x0000003800957306ULL, 0x000ea2000020d400ULL, 0x000000423f00720bULL, 0x002fce0003fdd000ULL,
0x0000003a00397306ULL, 0x000ff00000209400ULL, 0x0000003a00427306ULL, 0x000e620000205400ULL,
0x0000000195956812ULL, 0x004fce00078efcffULL, 0x0000003a00927306ULL, 0x000ea2000020d400ULL,
0x0000006c956c723eULL, 0x000fe400000010ffULL, 0x000000423900720bULL, 0x002fe20003fdd000ULL,
0x000001003b397824ULL, 0x000fc800078e00ffULL, 0x0000003b003a7306ULL, 0x000fe20000009400ULL,
0x0000007a8542723eULL, 0x000fe400000010ffULL, 0x00000018ff397819ULL, 0x000fca0000011439ULL,
0x0000003900387306ULL, 0x000fe20000209400ULL, 0x0000000192926812ULL, 0x004fc800078efcffULL,
0x000000926f92723eULL, 0x000fc600000010ffULL, 0x00000039003f7306ULL, 0x000e700000205400ULL,
0x0000003900977306ULL, 0x0004e2000020d400ULL, 0x0000003f3800720bULL, 0x002fce0003fdd000ULL,
0x0000003b007a7306ULL, 0x000322000000d400ULL, 0x0001300068387811ULL, 0x000fe200078e20ffULL,
0x000000003c3c783bULL, 0x000f220000000200ULL, 0x000000758a39723eULL, 0x004fc600000010ffULL,
0x00000000385c783bULL, 0x0005220000000200ULL, 0x0000000197976812ULL, 0x008fe200078efcffULL,
0x000100003b387824ULL, 0x004fe200078e00ffULL, 0x000000ff5800720cULL, 0x000fe40003fc5270ULL,
0x00000018ff3b7819ULL, 0x002fe4000001143bULL, 0x00000018ff7e7819ULL, 0x000fe40000011438ULL,
0x000000768b38723eULL, 0x000fe400000010ffULL, 0x0000007e00807306ULL, 0x000ff00000209400ULL,
0x0000007e00757306ULL, 0x000e700000205400ULL, 0x0000003b00767306ULL, 0x000fe20000209400ULL,
0x000000093c3cb231ULL, 0x010fc400003400ffULL, 0x000000093e3eb231ULL, 0x080fe400003400ffULL,
0x000000095c5cb231ULL, 0x080fe400003400ffULL, 0x000000095e5eb231ULL, 0x000fe400003400ffULL,
0x000000085d5db231ULL, 0x080fe400003400ffULL, 0x000000085f5fb231ULL, 0x080fe400003400ffULL,
0x000000083d3db231ULL, 0x000fc400003400ffULL, 0x000000083f3fb231ULL, 0x000fe200003400ffULL,
0x0000007f3a00720bULL, 0x000fe40003f7d000ULL, 0x0000004c5c58723cULL, 0x040f6200000418ffULL,
0x0000007e003a7306ULL, 0x000eae000020d400ULL, 0x000000505c50723cULL, 0x000f6600000418ffULL,
0x000000017a7a3812ULL, 0x000fc400078efcffULL, 0x000000758000720bULL, 0x002fe40003f7d000ULL,
0x0000003b00757306ULL, 0x000e620000205400ULL, 0x000000405c44723cULL, 0x000ff000000418ffULL,
0x000000383c58723cULL, 0x020be40000041858ULL, 0x000000013a3a3812ULL, 0x004fca00078efcffULL,
0x000000728d38723eULL, 0x020fe200000010ffULL, 0x000000545c54723cULL, 0x000f6200000418ffULL,
0x000000708f39723eULL, 0x000fe400000010ffULL, 0x000000757600720bULL, 0x002fe40003f7d000ULL,
0x0000008c7370723eULL, 0x000fc600000010ffULL, 0x000000383c50723cULL, 0x000bee0000041850ULL,
0x0000006e9338723eULL, 0x020fe200000010ffULL, 0x0000004e5c4c723cULL, 0x000f6200000418ffULL,
0x0000003b00937306ULL, 0x000e62000020d400ULL, 0x0000006d8e39723eULL, 0x000fc400000010ffULL,
0x0000007a976d723eULL, 0x000fc800000010ffULL, 0x0000004a5c48723cULL, 0x040f7000000418ffULL,
0x000000425c40723cULL, 0x000f6200000418ffULL, 0x0000000193933812ULL, 0x002fc800078efcffULL,
0x0000003a9393723eULL, 0x000fc600000010ffULL, 0x0000007c5c5c723cULL, 0x000f7000000418ffULL,
0x000000783c54723cULL, 0x040b700000041854ULL, 0x000000863c4c723cULL, 0x060b70000004184cULL,
0x000000383c48723cULL, 0x040b700000041848ULL, 0x000000703c44723cULL, 0x040b700000041844ULL,
0x0000006c3c40723cULL, 0x040b700000041840ULL, 0x000000923c5c723cULL, 0x000b62000004185cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000005812127221ULL, 0x000fe40000010000ULL, 0x0000005913137221ULL, 0x000fc40000010000ULL,
0x0000005416167221ULL, 0x000fe40000010000ULL, 0x0000005517177221ULL, 0x000fe40000010000ULL,
0x000000501a1a7221ULL, 0x000fe40000010000ULL, 0x000000511b1b7221ULL, 0x000fe40000010000ULL,
0x0000004c1e1e7221ULL, 0x020fe40000010000ULL, 0x0000004d1f1f7221ULL, 0x000fc40000010000ULL,
0x0000004822227221ULL, 0x000fe40000010000ULL, 0x0000004923237221ULL, 0x000fe40000010000ULL,
0x0000004426267221ULL, 0x000fe40000010000ULL, 0x0000004527277221ULL, 0x000fe40000010000ULL,
0x000000402a2a7221ULL, 0x000fe40000010000ULL, 0x000000412b2b7221ULL, 0x000fc40000010000ULL,
0x0000005c2e2e7221ULL, 0x000fe40000010000ULL, 0x0000005d2f2f7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000005a14147221ULL, 0x000fe40000010000ULL,
0x0000005b15157221ULL, 0x000fe40000010000ULL, 0x0000005618187221ULL, 0x000fe40000010000ULL,
0x0000005719197221ULL, 0x000fe40000010000ULL, 0x000000521c1c7221ULL, 0x000fc40000010000ULL,
0x000000531d1d7221ULL, 0x000fe40000010000ULL, 0x0000004e20207221ULL, 0x020fe40000010000ULL,
0x0000004f21217221ULL, 0x000fe40000010000ULL, 0x0000004a24247221ULL, 0x000fe40000010000ULL,
0x0000004b25257221ULL, 0x000fe40000010000ULL, 0x0000004628287221ULL, 0x000fc40000010000ULL,
0x0000004729297221ULL, 0x000fe40000010000ULL, 0x000000422c2c7221ULL, 0x000fe40000010000ULL,
0x000000432d2d7221ULL, 0x000fe40000010000ULL, 0x0000005e30307221ULL, 0x000fe40000010000ULL,
0x0000005f31317221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff387f8cULL, 0x020e62000c80043fULL, 0x000000696a00720cULL, 0x000fe20003f06070ULL,
0x000000ffff3c7224ULL, 0x002fd800078e0039ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff8c8000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c00f397811ULL, 0x000fe200078e40ffULL, 0x018b6800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000603900720cULL, 0x000fda0003f06070ULL, 0x000073f000000947ULL, 0x000fea0003800000ULL,
0x000000ffff6a7224ULL, 0x000fca00078e00ffULL, 0x00000002ff397819ULL, 0x000fe2000001166aULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000036a3a7812ULL, 0x040fe200078ec0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x000000396a397207ULL, 0x000fe40002800000ULL,
0x000000ff3a3f7207ULL, 0x000fe40006800000ULL, 0x0000000339387810ULL, 0x000fc80007ffe0ffULL,
0x0000000338417812ULL, 0x040fe400078ec0ffULL, 0x0000000f38437211ULL, 0x000fc400078ff0ffULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x018b8c00ff3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff3b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000143397810ULL, 0x000fe20007ffe0ffULL,
0x0000099000017945ULL, 0x000fe60003800000ULL, 0x000000363900720cULL, 0x000fda0003f06070ULL,
0x0000052000008947ULL, 0x000fea0003800000ULL, 0x0000000507457c10ULL, 0x000fe2000fffe0ffULL,
0x0000000443397824ULL, 0x000fe200078e0241ULL, 0x00000020353e7811ULL, 0x000fe200078e30ffULL,
0x00000010323b7824ULL, 0x000fe200078e00ffULL, 0x00000002074d7810ULL, 0x000fe20007ffe0ffULL,
0x018a0000453a7984ULL, 0x000e620000004800ULL, 0x0000002039397811ULL, 0x000fe200078e30ffULL,
0x00000100ff477424ULL, 0x000fe200078e00ffULL, 0x000000f03b497812ULL, 0x000fe200078ec0ffULL,
0x00000001453b7824ULL, 0x040fe200078e0232ULL, 0x0000003960387217ULL, 0x000fe20007800000ULL,
0x0000001045407824ULL, 0x000fe200078e00ffULL, 0x000000054d4f7c10ULL, 0x000fc6000fffe0ffULL,
0x0000000138387824ULL, 0x000fe400078e0a39ULL, 0x0000000145397824ULL, 0x000fc600078e023eULL,
0x0000000538387c17ULL, 0x000fc8000f800000ULL, 0x80000005383c7c10ULL, 0x000fc8000fffe0ffULL,
0x0000003c0700720cULL, 0x000fe20003f06070ULL, 0x018ac0003a3a7984ULL, 0x002e640000004800ULL,
0x0000003a0d397224ULL, 0x002fc800078e0239ULL, 0x00005e0039387625ULL, 0x000fca00078e0047ULL,
0x00000049383a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffff040387812ULL, 0x000fe200078ee23bULL,
0x000000014f407824ULL, 0x040fe400078e0232ULL, 0x000000ffff3b7224ULL, 0x000fe200008e0639ULL,
0x00016000384b7811ULL, 0x000fe200078e20ffULL, 0x000000014f397824ULL, 0x040fe400078e023eULL,
0x000000104f4f7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a4b7faeULL, 0x0003e2000c101c4aULL, 0x0000003c4d00720cULL, 0x000fc40003f06070ULL,
0xfffffff04f407812ULL, 0x000fe200078ee240ULL, 0x018a0800453d7984ULL, 0x000ea20000004800ULL,
0x00000004074d7810ULL, 0x000fc80007ffe0ffULL, 0x000000054d4f7c10ULL, 0x000fe4000fffe0ffULL,
0x00016000404b7811ULL, 0x002fc600078e20ffULL, 0x000000014f407824ULL, 0x000fe200078e0232ULL,
0x018ac0003d387984ULL, 0x004e640000004800ULL, 0x000000380d387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff3b7224ULL, 0x000fe400008e0639ULL, 0x000000014f397824ULL, 0x040fe400078e023eULL,
0x000000104f4f7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a4b7faeULL, 0x0003e2000c101c4aULL, 0x0000003c4d00720cULL, 0x000fe40003f06070ULL,
0x00000006074d7810ULL, 0x000fe20007ffe0ffULL, 0x018a1000453d7984ULL, 0x000ea20000004800ULL,
0xfffffff04f407812ULL, 0x000fc400078ee240ULL, 0x000000054d4f7c10ULL, 0x000fe4000fffe0ffULL,
0x00016000404b7811ULL, 0x002fc600078e20ffULL, 0x000000014f3e7824ULL, 0x000fe200078e023eULL,
0x018ac0003d387984ULL, 0x004e640000004800ULL, 0x000000380d387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff3b7224ULL, 0x000fca00008e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a4b7faeULL, 0x0003e2000c101c4aULL, 0x0000003c4d00720cULL, 0x000fc60003f06070ULL,
0x018a1800453d7984ULL, 0x000ea80000004800ULL, 0x018ac0003d387984ULL, 0x004ea40000004800ULL,
0x000000380d387224ULL, 0x004fe400078e023eULL, 0x000000014f3e7824ULL, 0x000fe400078e0232ULL,
0x00005e0038387625ULL, 0x000fc800078e0047ULL, 0x000000104f4f7824ULL, 0x000fe200078e00ffULL,
0x0000004938387210ULL, 0x000fc80007f3e0ffULL, 0xfffffff04f3e7812ULL, 0x000fe200078ee23eULL,
0x000000ffff397224ULL, 0x000fc600008e0639ULL, 0x000160003e3b7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e2000c101c4aULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x0000000507457c10ULL, 0x000fe2000fffe0ffULL,
0x0000001032397824ULL, 0x000fe200078e00ffULL, 0x0000002035407811ULL, 0x000fe200078e30ffULL,
0x00000100ff477424ULL, 0x000fe200078e00ffULL, 0x00000002453d7810ULL, 0x000fe20007ffe0ffULL,
0x018a0000453c7984ULL, 0x000e620000004800ULL, 0x000000f039497812ULL, 0x000fe200078ec0ffULL,
0x0000000145387824ULL, 0x040fe400078e0240ULL, 0x00000001453b7824ULL, 0x000fc400078e0232ULL,
0x00000010453e7824ULL, 0x000fe400078e00ffULL, 0x000000013d427824ULL, 0x000fe200078e0232ULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff03e387812ULL, 0x000fc600078ee23bULL, 0x000000ffff3b7224ULL, 0x000fe200000e0639ULL,
0x00016000384b7811ULL, 0x000fe200078e20ffULL, 0x0000000140387824ULL, 0x000fe400078e023dULL,
0x000000103d3d7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a4b7faeULL, 0x0003e6000b901c4aULL, 0xfffffff03d427812ULL, 0x000fe200078ee242ULL,
0x018a0800453e7984ULL, 0x000ea60000004800ULL, 0x00016000424b7811ULL, 0x002fc400078e20ffULL,
0x00000004453b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b427824ULL, 0x000fe200078e0232ULL,
0x018ac0003e3e7984ULL, 0x004e640000004800ULL, 0x0000003e0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000140387824ULL, 0x000fe400078e023bULL, 0x000000103b3b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e0639ULL, 0xfffffff03b427812ULL, 0x000fe400078ee242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c4b7faeULL, 0x0003e8000b901c4aULL,
0x018a1000453e7984ULL, 0x000ea20000004800ULL, 0x00016000423d7811ULL, 0x002fe400078e20ffULL,
0x00000006454b7810ULL, 0x000fe20007ffe0ffULL, 0x018ac0003e3e7984ULL, 0x004e640000004800ULL,
0x0000003e0d387224ULL, 0x002fc400078e0238ULL, 0x000000014b3e7824ULL, 0x000fe400078e0232ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000140387824ULL, 0x000fe400078e024bULL, 0x000000104b4b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600000e0639ULL, 0xfffffff04b3e7812ULL, 0x000fe400078ee23eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c4aULL,
0x018a1800453c7984ULL, 0x000ea20000004800ULL, 0x000160003e3b7811ULL, 0x002fc600078e20ffULL,
0x018ac0003c3c7984ULL, 0x004e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x0000004938387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c4aULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff457224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000433400720cULL, 0x000fe20003f04070ULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000033f00780cULL, 0x000fda0003f25270ULL, 0x0000010000008947ULL, 0x000fea0000800000ULL,
0x000000030c00780cULL, 0x000fe40003f04070ULL, 0x000000010e0e7810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000397919ULL, 0x000e620000002700ULL,
0x000000370e00720cULL, 0x000fe20003f06070ULL, 0x00000004ff3b7424ULL, 0x000fe200078e00ffULL,
0x00018ac00c3d7811ULL, 0x000fe200078e10ffULL, 0x0000000439387824ULL, 0x002fe200078e020cULL,
0x000064000e397a10ULL, 0x000fc60007ffe0ffULL, 0x0000000238387824ULL, 0x000fc800078e00ffULL,
0x0000640038387a24ULL, 0x000fc800078e0239ULL, 0x0000600038387625ULL, 0x000fca00078e003bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383d7faeULL, 0x0003e4000c12184aULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000433400720cULL, 0x000fe40003f04070ULL,
0x000000013f387810ULL, 0x002fc80007ffe0ffULL, 0x0000000338397812ULL, 0x000fc800078ec0ffULL,
0x000000ff39397207ULL, 0x000fc60004000000ULL, 0x00000002ff388819ULL, 0x000fca0000011638ULL,
0x0000000141387824ULL, 0x000fc800078e0238ULL, 0x00000040383a7824ULL, 0x040fe200078e00ffULL,
0x0000004338387211ULL, 0x000fc800078ff0ffULL, 0x000000c03a3b7812ULL, 0x000fca00078ec0ffULL,
0x00000100383d7824ULL, 0x000fe200078e023bULL, 0x0000000c39387c10ULL, 0x000fc6000fffe0ffULL,
0x000000010c3b7824ULL, 0x100fe400078e023dULL, 0x0000680038397a24ULL, 0x000fe400078e023dULL,
0x00000004ff387424ULL, 0x000fe200078e00ffULL, 0x000000603b00720cULL, 0x000fe20003f06070ULL,
0x000000010c397824ULL, 0x040fe200078e0239ULL, 0x00018a000c3b7811ULL, 0x000fc600078e10ffULL,
0x0000660039387625ULL, 0x000fd000078e0038ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000c12184aULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8000ff387f8cULL, 0x000e62000c80043fULL, 0x000000ff6a00720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff6b7224ULL, 0x002fd600078e0039ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b3800ff387f8cULL, 0x000e64000c800405ULL, 0x000000ffff3c7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b3c05ff0b7984ULL, 0x000e640008000800ULL,
0x800000000bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc8000001143bULL, 0x0000003a0b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff3a7224ULL, 0x000fca00000e063bULL, 0x000000020b0b7819ULL, 0x000fc8000000123aULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x018b3c05ff0b7984ULL, 0x000e640008000800ULL, 0x800000000bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00000010320b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff387819ULL, 0x000fc80000011632ULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c38387812ULL, 0x000fca00078ec0ffULL, 0x000000010b3f7824ULL, 0x000fca00078e0238ULL,
0x018180003f3b7984ULL, 0x000e680000000800ULL, 0x018380003f3a7984ULL, 0x0004e20000000800ULL,
0x000000103b00720bULL, 0x002fe20003f1d000ULL, 0x000103227f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0b427812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fd200078e0010ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000033300780cULL, 0x000fe40003f05270ULL, 0x000000103b00720bULL, 0x000fe20003f34000ULL,
0x000102f27f007947ULL, 0x000fd8000b800000ULL, 0x00000000003d7806ULL, 0x000fc400008e0100ULL,
0x0000003b103c7209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x000099103d387816ULL, 0x000fc600000000ffULL, 0x0185803c3f008388ULL, 0x0003e20000000800ULL,
0x000000ff3800720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000003c10107221ULL, 0x002fe20000010000ULL, 0x000000ff3dff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000447308ULL, 0x000e640000000800ULL, 0x0000004411117220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000102527f007947ULL, 0x000fea000b800000ULL,
0x00001f6244107589ULL, 0x0002a400000e0000ULL, 0x0000001012127220ULL, 0x084fe40000410000ULL,
0x0000001013137220ULL, 0x080fe40000410000ULL, 0x0000001016167220ULL, 0x080fe40000410000ULL,
0x0000001017177220ULL, 0x080fe40000410000ULL, 0x000000101a1a7220ULL, 0x080fe40000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x000000101e1e7220ULL, 0x080fe40000410000ULL,
0x000000101f1f7220ULL, 0x080fe40000410000ULL, 0x0000001022227220ULL, 0x080fe40000410000ULL,
0x0000001023237220ULL, 0x080fe40000410000ULL, 0x0000001026267220ULL, 0x080fe40000410000ULL,
0x0000001027277220ULL, 0x000fc40000410000ULL, 0x000000102a2a7220ULL, 0x080fe40000410000ULL,
0x000000102b2b7220ULL, 0x080fe40000410000ULL, 0x000000102e2e7220ULL, 0x080fe40000410000ULL,
0x000000102f2f7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff003dff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000101827f007947ULL, 0x000fea000b800000ULL, 0x00001f6144107589ULL, 0x00046400000e0000ULL,
0x0000001014147220ULL, 0x082fe40000410000ULL, 0x0000001015157220ULL, 0x080fe40000410000ULL,
0x0000001018187220ULL, 0x080fe40000410000ULL, 0x0000001019197220ULL, 0x080fe40000410000ULL,
0x000000101c1c7220ULL, 0x080fe40000410000ULL, 0x000000101d1d7220ULL, 0x000fc40000410000ULL,
0x0000001020207220ULL, 0x080fe40000410000ULL, 0x0000001021217220ULL, 0x080fe40000410000ULL,
0x0000001024247220ULL, 0x080fe40000410000ULL, 0x0000001025257220ULL, 0x080fe40000410000ULL,
0x0000001028287220ULL, 0x080fe40000410000ULL, 0x0000001029297220ULL, 0x000fc40000410000ULL,
0x000000102c2c7220ULL, 0x080fe40000410000ULL, 0x000000102d2d7220ULL, 0x080fe40000410000ULL,
0x0000001030307220ULL, 0x080fe40000410000ULL, 0x0000001031317220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff42ff7812ULL, 0x000fda000780603dULL,
0x8000003c3b3b0221ULL, 0x000fe20000010000ULL, 0x00007610ff0b0816ULL, 0x000fc6000000000bULL,
0x3fb8aa3b3b3b0820ULL, 0x000fc80000410000ULL, 0x0000003b000a0308ULL, 0x000e640000000800ULL,
0x0000000a3a3a0220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x000000113a117221ULL, 0x008fe40000010000ULL, 0x000000ffff107224ULL, 0x000fc400078e003cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff0bff7812ULL, 0x000fe2000786c0ffULL,
0x0000016000017945ULL, 0x000fd80003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x0000000aff08723eULL, 0x000fc800000010ffULL, 0x00005410083a7816ULL, 0x000fe20000000008ULL,
0x0000ffe27f007947ULL, 0x000fea000b800000ULL, 0x00001f623a097589ULL, 0x0002e400000e0000ULL,
0x000100427f007947ULL, 0x000fea000b800000ULL, 0x00001f613a087589ULL, 0x0002a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010623f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0001999000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000107c000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018623f7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff407424ULL, 0x000fe200078e00ffULL, 0x00019a0000387802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0001075000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000000640783bULL, 0x002e620000004200ULL, 0x00001e9000017945ULL, 0x000fe60003800000ULL,
0x000000000444783bULL, 0x004fe80000004200ULL, 0x00000000053c783bULL, 0x000ea80000004200ULL,
0x000000000338783bULL, 0x000f220000004200ULL, 0x00000018ff4d7819ULL, 0x002fe20000011443ULL,
0x0000010040797824ULL, 0x000fe200078e00ffULL, 0x0000004000cf7306ULL, 0x000fe20000009400ULL,
0x00000018ff4a7819ULL, 0x000fc40000011440ULL, 0x00000018ff4b7819ULL, 0x000fe40000011441ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000018ff7a7819ULL, 0x004fe2000001143dULL,
0x0000004d00c07306ULL, 0x000fe20000209400ULL, 0x00000018ff7f7819ULL, 0x000fe4000001143eULL,
0x00000018ff587819ULL, 0x010fe4000001143aULL, 0x00000018ff5c7819ULL, 0x000fc4000001143bULL,
0x00000018ff4c7819ULL, 0x000fe20000011442ULL, 0x0000004d00c37306ULL, 0x000fe20000205400ULL,
0x00000018ff807819ULL, 0x000fce000001143fULL, 0x0000004d005a7306ULL, 0x0003f0000020d400ULL,
0x0000007a00a37306ULL, 0x000fe20000209400ULL, 0x00000018ff4d7819ULL, 0x002fce0000011447ULL,
0x0000004d00b07306ULL, 0x000ff00000209400ULL, 0x0000004d00b17306ULL, 0x000ff00000205400ULL,
0x0000004d00747306ULL, 0x000ff0000020d400ULL, 0x0000007a00a27306ULL, 0x000ff00000205400ULL,
0x0000007a004d7306ULL, 0x000ff0000020d400ULL, 0x00000079007a7306ULL, 0x000ff00000209400ULL,
0x0000007900d17306ULL, 0x000e700000205400ULL, 0x0000005800757306ULL, 0x000ff00000209400ULL,
0x0000005800767306ULL, 0x000fe20000205400ULL, 0x000000d17a00720bULL, 0x002fce0003f5d000ULL,
0x00000058006c7306ULL, 0x000ff0000020d400ULL, 0x0000005c00777306ULL, 0x000ff00000209400ULL,
0x0000005c00787306ULL, 0x000ff00000205400ULL, 0x0000005c006d7306ULL, 0x000ff0000020d400ULL,
0x0000007f009f7306ULL, 0x000ff00000209400ULL, 0x0000007f00587306ULL, 0x000ff00000205400ULL,
0x0000007f005c7306ULL, 0x0003f0000020d400ULL, 0x0000004000ca7306ULL, 0x000ea20000005400ULL,
0x00000100417f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000007900b37306ULL, 0x000330000020d400ULL, 0x0000007f00ce7306ULL, 0x000fe20000209400ULL,
0x0000010042797824ULL, 0x002fe200078e00ffULL, 0x000000cacf00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000007f00d57306ULL, 0x000e620000205400ULL,
0x00000001b3b32812ULL, 0x010fce00078efcffULL, 0x0000004000a87306ULL, 0x000530000000d400ULL,
0x0000004a00cd7306ULL, 0x000fe20000209400ULL, 0x0001000040407824ULL, 0x004fe200078e00ffULL,
0x000000d5ce00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000004a00c87306ULL, 0x000e620000205400ULL, 0x00000001a8a86812ULL, 0x010fce00078efcffULL,
0x0000004a00a07306ULL, 0x000530000020d400ULL, 0x0000004100c47306ULL, 0x000fe20000009400ULL,
0x00000018ff4a7819ULL, 0x004fe40000011444ULL, 0x000000c8cd00720bULL, 0x002fca0003f3d000ULL,
0x0000004100c97306ULL, 0x000e700000005400ULL, 0x0000004b00c77306ULL, 0x000fe20000209400ULL,
0x00000001a0a01812ULL, 0x010fce00078efcffULL, 0x0000004b00c27306ULL, 0x000ea20000205400ULL,
0x000000c9c400720bULL, 0x002fce0003fdd000ULL, 0x0000004b009e7306ULL, 0x000330000020d400ULL,
0x0000004a00b87306ULL, 0x000fe20000209400ULL, 0x00000018ff4b7819ULL, 0x002fe40000011445ULL,
0x000000c2c700720bULL, 0x004fca0003f3d000ULL, 0x0000004a00bd7306ULL, 0x000ff00000205400ULL,
0x0000004a00887306ULL, 0x0003e2000020d400ULL, 0x000000019e9e1812ULL, 0x010fce00078efcffULL,
0x0000004200be7306ULL, 0x000fe20000009400ULL, 0x00000018ff4a7819ULL, 0x002fce0000011438ULL,
0x0000004200c57306ULL, 0x000ff00000005400ULL, 0x00000042009c7306ULL, 0x0003f0000000d400ULL,
0x0000007f00af7306ULL, 0x000522000020d400ULL, 0x0001000042427824ULL, 0x002fce00078e00ffULL,
0x0000007900d97306ULL, 0x000fe20000209400ULL, 0x00000018ff7f7819ULL, 0x004fe20000011442ULL,
0x0000010043427824ULL, 0x000fcc00078e00ffULL, 0x0000007900d27306ULL, 0x000e620000205400ULL,
0x00000001afaf2812ULL, 0x010fce00078efcffULL, 0x0000004c00cb7306ULL, 0x000ff00000209400ULL,
0x0000004c00c67306ULL, 0x000ea20000205400ULL, 0x000000d2d900720bULL, 0x002fce0003f5d000ULL,
0x0000004c005b7306ULL, 0x000330000020d400ULL, 0x0000004b00ba7306ULL, 0x000fe20000209400ULL,
0x00000018ff4c7819ULL, 0x002fe40000011446ULL, 0x000000c6cb00720bULL, 0x004fca0003f3d000ULL,
0x0000004b00c17306ULL, 0x000e700000205400ULL, 0x0000004b00847306ULL, 0x0004e2000020d400ULL,
0x000000015b5b1812ULL, 0x010fe400078efcffULL, 0x000000c3c000720bULL, 0x000fca0003f3d000ULL,
0x0000004a00527306ULL, 0x000fe20000209400ULL, 0x00000018ff4b7819ULL, 0x004fce0000011439ULL,
0x0000004a00537306ULL, 0x000fe20000205400ULL, 0x000000015a5a1812ULL, 0x000fe400078efcffULL,
0x000000bdb800720bULL, 0x000fca0003f3d000ULL, 0x0000004a00727306ULL, 0x0005f0000020d400ULL,
0x0000004000cc7306ULL, 0x000fe20000209400ULL, 0x00000018ff4a7819ULL, 0x004fe4000001143cULL,
0x0000000188881812ULL, 0x000fc400078efcffULL, 0x000000c1ba00720bULL, 0x002fe20003f3d000ULL,
0x000001003eba7824ULL, 0x000fe400078e00ffULL, 0x0000004000d37306ULL, 0x000e660000205400ULL,
0x00000018ffba7819ULL, 0x000fca00000114baULL, 0x0000004100a47306ULL, 0x000524000000d400ULL,
0x0000000184841812ULL, 0x008fcc00078efcffULL, 0x0000004c00b77306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x004fe200078e00ffULL, 0x000000d3cc00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004c00b47306ULL, 0x000e620000205400ULL,
0x00000001a4a46812ULL, 0x010fe400078efcffULL, 0x000000c5be00720bULL, 0x000fe20003fdd000ULL,
0x000001003dbe7824ULL, 0x000fc800078e00ffULL, 0x0000004c007e7306ULL, 0x000ea2000020d400ULL,
0x00000018ffbe7819ULL, 0x000fce00000114beULL, 0x0000004b00897306ULL, 0x000fe20000209400ULL,
0x000000019c9c6812ULL, 0x000fe400078efcffULL, 0x000000b4b700720bULL, 0x002fca0003f3d000ULL,
0x0000004b008a7306ULL, 0x000ff00000205400ULL, 0x0000004b006e7306ULL, 0x000fe2000020d400ULL,
0x000000017e7e1812ULL, 0x004fe400078efcffULL, 0x000000b1b000720bULL, 0x000fe20003f3d000ULL,
0x000001003bb17824ULL, 0x000fc400078e00ffULL, 0x000100003ab07824ULL, 0x000fe400078e00ffULL,
0x0000004a00b57306ULL, 0x000fe20000209400ULL, 0x00000018ffb17819ULL, 0x000fe400000114b1ULL,
0x00000018ffb07819ULL, 0x000fca00000114b0ULL, 0x0000004a00ac7306ULL, 0x000e620000205400ULL,
0x0000000174741812ULL, 0x000fce00078efcffULL, 0x0000004a004c7306ULL, 0x000eb0000020d400ULL,
0x00000080004b7306ULL, 0x000fe20000209400ULL, 0x000000acb500720bULL, 0x002fe20003f3d000ULL,
0x000100003bac7824ULL, 0x000fca00078e00ffULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x00000080004a7306ULL, 0x000fec0000205400ULL, 0x000000014c4c1812ULL, 0x004fe400078efcffULL,
0x00000080005d7306ULL, 0x0003f0000020d400ULL, 0x0000007900a17306ULL, 0x0004e2000020d400ULL,
0x00000018ff807819ULL, 0x002fce0000011442ULL, 0x0000008000e07306ULL, 0x000fe20000209400ULL,
0x0000010044797824ULL, 0x004fca00078e00ffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000008000e77306ULL, 0x000e620000205400ULL, 0x00000001a1a12812ULL, 0x008fce00078efcffULL,
0x0000004000a77306ULL, 0x000eb0000020d400ULL, 0x0000004100d07306ULL, 0x000fe20000209400ULL,
0x000000e7e000720bULL, 0x002fce0003f5d000ULL, 0x0000004100d77306ULL, 0x000e620000205400ULL,
0x00000001a7a70812ULL, 0x004fce00078efcffULL, 0x0000004300b67306ULL, 0x000ff00000009400ULL,
0x0000004300bf7306ULL, 0x000ea20000005400ULL, 0x000000d7d000720bULL, 0x002fce0003f1d000ULL,
0x0000008000427306ULL, 0x000e70000020d400ULL, 0x0000007900eb7306ULL, 0x000fe20000209400ULL,
0x000000bfb600720bULL, 0x004fce0003fdd000ULL, 0x0000007900e47306ULL, 0x000ea20000205400ULL,
0x0000000142422812ULL, 0x002fce00078efcffULL, 0x0000004100a57306ULL, 0x000e70000020d400ULL,
0x0000007f00de7306ULL, 0x000fe20000209400ULL, 0x000000e4eb00720bULL, 0x004fce0003f5d000ULL,
0x0000007f00e57306ULL, 0x000ea20000205400ULL, 0x00000001a5a50812ULL, 0x002fce00078efcffULL,
0x0000007f00407306ULL, 0x0003f0000020d400ULL, 0x0000004300597306ULL, 0x000722000000d400ULL,
0x00000100457f7824ULL, 0x002fe200078e00ffULL, 0x000000e5de00720bULL, 0x004fc80003f1d000ULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000004400bc7306ULL, 0x000fe20000009400ULL,
0x0001000043437824ULL, 0x008fca00078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004400bb7306ULL, 0x000e620000005400ULL, 0x0000000159596812ULL, 0x010fe400078efcffULL,
0x0000000140400812ULL, 0x000fe400078efcffULL, 0x000000594259723eULL, 0x000fe400000010ffULL,
0x0001380000427811ULL, 0x000fe200078e20ffULL, 0x0000007900937306ULL, 0x000eb0000020d400ULL,
0x0000007f00db7306ULL, 0x000fe20000209400ULL, 0x000000bbbc00720bULL, 0x002fce0003fdd000ULL,
0x0000007f00d47306ULL, 0x000e620000205400ULL, 0x0000000193932812ULL, 0x004fce00078efcffULL,
0x0000004300e27306ULL, 0x000ff00000209400ULL, 0x0000004300e97306ULL, 0x000ea20000205400ULL,
0x000000d4db00720bULL, 0x002fce0003f5d000ULL, 0x0000004300417306ULL, 0x0003f0000020d400ULL,
0x00000044005e7306ULL, 0x000722000000d400ULL, 0x0000010046437824ULL, 0x002fe200078e00ffULL,
0x000000e9e200720bULL, 0x004fc80003f1d000ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004500b27306ULL, 0x000fe20000009400ULL, 0x0001000044447824ULL, 0x008fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000004500b97306ULL, 0x000e620000005400ULL,
0x000000015e5e6812ULL, 0x010fe400078efcffULL, 0x0000000141410812ULL, 0x000fe400078efcffULL,
0x0000005e935e723eULL, 0x000fc600000010ffULL, 0x0000007f00947306ULL, 0x000eb0000020d400ULL,
0x0000004300da7306ULL, 0x000fe20000209400ULL, 0x000000b9b200720bULL, 0x002fce0003fdd000ULL,
0x0000004300e17306ULL, 0x000e620000205400ULL, 0x0000000194942812ULL, 0x004fce00078efcffULL,
0x0000004400e67306ULL, 0x000ff00000209400ULL, 0x0000004400ed7306ULL, 0x000ea20000205400ULL,
0x000000e1da00720bULL, 0x002fce0003f5d000ULL, 0x00000044008d7306ULL, 0x0003f0000020d400ULL,
0x00000045005f7306ULL, 0x000722000000d400ULL, 0x0000010047447824ULL, 0x002fe200078e00ffULL,
0x000000ede600720bULL, 0x004fc80003f1d000ULL, 0x00000018ff797819ULL, 0x000fe40000011444ULL,
0x0000004600577306ULL, 0x000fe20000009400ULL, 0x0001000045457824ULL, 0x008fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004600567306ULL, 0x000e620000005400ULL,
0x000000015f5f6812ULL, 0x010fe400078efcffULL, 0x000000018d8d0812ULL, 0x000fe400078efcffULL,
0x0000005f945f723eULL, 0x000fe400000010ffULL, 0x0000008d8888723eULL, 0x000fe200000010ffULL,
0x00000043008e7306ULL, 0x000eb0000020d400ULL, 0x0000007900d87306ULL, 0x000fe20000209400ULL,
0x000000565700720bULL, 0x002fc40003fdd000ULL, 0x0001380002567811ULL, 0x000fca00078e20ffULL,
0x0000007900dd7306ULL, 0x000e620000205400ULL, 0x000000018e8e2812ULL, 0x004fce00078efcffULL,
0x0000004600817306ULL, 0x0004f0000000d400ULL, 0x0000004500dc7306ULL, 0x000fe20000209400ULL,
0x0001000046467824ULL, 0x004fe200078e00ffULL, 0x000000ddd800720bULL, 0x002fc80003f5d000ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000004500e37306ULL, 0x000e620000205400ULL,
0x0000000181816812ULL, 0x008fc800078efcffULL, 0x000000818e8e723eULL, 0x000fc600000010ffULL,
0x00000045008b7306ULL, 0x0004f0000020d400ULL, 0x0000004700547306ULL, 0x000fe20000009400ULL,
0x0000010038457824ULL, 0x004fe200078e00ffULL, 0x000000e3dc00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff8f7819ULL, 0x000fe40000011445ULL, 0x0000004700557306ULL, 0x000e6e0000005400ULL,
0x000000018b8b0812ULL, 0x008fe200078efcffULL, 0x00000038004f7306ULL, 0x000ff00000009400ULL,
0x0000003800507306ULL, 0x000fe20000005400ULL, 0x000000555400720bULL, 0x002fc40003fdd000ULL,
0x000000005654783bULL, 0x000e6a0000000200ULL, 0x0000003800737306ULL, 0x0005f0000000d400ULL,
0x0000004600df7306ULL, 0x000fe20000209400ULL, 0x0001000038387824ULL, 0x004fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004600d67306ULL, 0x000eb00000205400ULL,
0x0000004600877306ULL, 0x000ef0000020d400ULL, 0x00000079008c7306ULL, 0x0008e2000020d400ULL,
0x000000d6df00720bULL, 0x004fe20003f1d000ULL, 0x000000095454b231ULL, 0x002fc400003400ffULL,
0x000000095656b231ULL, 0x000fe400003400ffULL, 0x000000085555b231ULL, 0x080fe400003400ffULL,
0x0000008f00457306ULL, 0x000fe20000209400ULL, 0x0000010039797824ULL, 0x010fe200078e00ffULL,
0x000000085757b231ULL, 0x000fc800003400ffULL, 0x0000000187870812ULL, 0x008fe400078efcffULL,
0x0000008f00467306ULL, 0x000e620000205400ULL, 0x000000018c8c2812ULL, 0x000fce00078efcffULL,
0x0000003800987306ULL, 0x000ff00000209400ULL, 0x00000038009b7306ULL, 0x000fe20000205400ULL,
0x000000464500720bULL, 0x002fe40003f5d000ULL, 0x000000415a45723eULL, 0x000fca00000010ffULL,
0x00000038007f7306ULL, 0x0003f0000020d400ULL, 0x0000003c00ad7306ULL, 0x000fe20000009400ULL,
0x000001003c387824ULL, 0x002fca00078e00ffULL, 0x00000018ffca7819ULL, 0x000fe40000011438ULL,
0x0000003c00ae7306ULL, 0x000ff00000005400ULL, 0x0000003c00487306ULL, 0x0003f0000000d400ULL,
0x00000047007b7306ULL, 0x0004e2000000d400ULL, 0x000100003c3c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000008f00867306ULL, 0x000322000020d400ULL,
0x0001000047477824ULL, 0x004fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000003c00c27306ULL, 0x000fe20000209400ULL, 0x000000017b7b6812ULL, 0x008fe200078efcffULL,
0x000001003a8f7824ULL, 0x002fe200078e00ffULL, 0x000000aead00720bULL, 0x000fc80003fdd000ULL,
0x00000018ffe87819ULL, 0x000fe2000001148fULL, 0x0000003c00c77306ULL, 0x000e620000205400ULL,
0x0000000186862812ULL, 0x010fce00078efcffULL, 0x0000004700447306ULL, 0x000fe20000209400ULL,
0x0000000148486812ULL, 0x000fce00078efcffULL, 0x0000004700437306ULL, 0x000ea20000205400ULL,
0x000000c7c200720bULL, 0x002fce0003f5d000ULL, 0x0000003900997306ULL, 0x000ff00000009400ULL,
0x00000039004e7306ULL, 0x000fe20000005400ULL, 0x000000434400720bULL, 0x004fce0003f1d000ULL,
0x0000003900717306ULL, 0x0003f0000000d400ULL, 0x0000003d00ab7306ULL, 0x000fe20000009400ULL,
0x0001000039397824ULL, 0x002fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003d00a67306ULL, 0x000e700000005400ULL, 0x0000003c00c57306ULL, 0x000eb0000020d400ULL,
0x000000be00bf7306ULL, 0x000fe20000209400ULL, 0x000000a6ab00720bULL, 0x002fce0003fdd000ULL,
0x000000be003c7306ULL, 0x000e620000205400ULL, 0x00000001c5c52812ULL, 0x004fc800078efcffULL,
0x000000c54c4c723eULL, 0x000fc600000010ffULL, 0x0000004700857306ULL, 0x0004f0000020d400ULL,
0x0000003900917306ULL, 0x000fe20000209400ULL, 0x00000018ff477819ULL, 0x004fe40000011479ULL,
0x0000003cbf00720bULL, 0x002fc40003f5d000ULL, 0x000000a8b33c723eULL, 0x000fc600000010ffULL,
0x0000003900927306ULL, 0x000fe20000205400ULL, 0x0000000185850812ULL, 0x008fc800078efcffULL,
0x000000857485723eULL, 0x000fc600000010ffULL, 0x0000003900797306ULL, 0x000ff0000020d400ULL,
0x000000ca00387306ULL, 0x000ff00000209400ULL, 0x000000ca00397306ULL, 0x000e700000205400ULL,
0x0000003d00497306ULL, 0x0004f0000000d400ULL, 0x0000003e00a97306ULL, 0x000fe20000009400ULL,
0x000100003d3d7824ULL, 0x004fe200078e00ffULL, 0x000000393800720bULL, 0x002fe20003f1d000ULL,
0x000001003f387824ULL, 0x000fe200078e00ffULL, 0x000000a59e39723eULL, 0x000fc400000010ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003e00aa7306ULL, 0x000fe20000005400ULL,
0x0000000149496812ULL, 0x008fe400078efcffULL, 0x000000a2a300720bULL, 0x000fe40003fdd000ULL,
0x00000018ffae7819ULL, 0x000fe40000011438ULL, 0x000000a7a038723eULL, 0x000fe200000010ffULL,
0x0000003e00977306ULL, 0x0003f0000000d400ULL, 0x000000be00b67306ULL, 0x000ea2000020d400ULL,
0x000100003e3e7824ULL, 0x002fe200078e00ffULL, 0x000000014d4d6812ULL, 0x000fc800078efcffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003d00b87306ULL, 0x000ff00000209400ULL,
0x0000003d00b97306ULL, 0x000e620000205400ULL, 0x00000001b6b62812ULL, 0x004fc400078efcffULL,
0x000000589f00720bULL, 0x000fe40003f5d000ULL, 0x0000009ca158723eULL, 0x000fe400000010ffULL,
0x00000049b649723eULL, 0x000fe200000010ffULL, 0x0000003f009d7306ULL, 0x000ff00000009400ULL,
0x0000003f009a7306ULL, 0x000fe20000005400ULL, 0x000000b9b800720bULL, 0x002fc40003f3d000ULL,
0x000000015c5c2812ULL, 0x000fca00078efcffULL, 0x0000003f00517306ULL, 0x0003f0000000d400ULL,
0x0000004700957306ULL, 0x000fe20000209400ULL, 0x000100003f3f7824ULL, 0x002fce00078e00ffULL,
0x0000004700967306ULL, 0x000ff00000205400ULL, 0x0000004700807306ULL, 0x000ff0000020d400ULL,
0x0000003e00437306ULL, 0x000ff00000209400ULL, 0x0000003e00447306ULL, 0x000e700000205400ULL,
0x000000ca00477306ULL, 0x000eb0000020d400ULL, 0x0000003d00b27306ULL, 0x000722000020d400ULL,
0x000000444300720bULL, 0x002fc40003fdd000ULL, 0x000000405b44723eULL, 0x000fe400000010ffULL,
0x000000004240783bULL, 0x000e620000000200ULL, 0x000000585458723cULL, 0x000fe400000418ffULL,
0x000000ba00bb7306ULL, 0x000fe20000209400ULL, 0x000000a4af3d723eULL, 0x008fe400000010ffULL,
0x00000018ffa47819ULL, 0x000fe4000001143fULL, 0x0000000147470812ULL, 0x004fc400078efcffULL,
0x000000aaa900720bULL, 0x000fe20003f1d000ULL, 0x000000ba00b47306ULL, 0x000ea20000205400ULL,
0x00000001b2b21812ULL, 0x010fe400078efcffULL, 0x000000484748723eULL, 0x000fe400000010ffULL,
0x000000b24d4d723eULL, 0x000fc600000010ffULL, 0x000000a4009e7306ULL, 0x000fe80000209400ULL,
0x0000000197970812ULL, 0x000fe400078efcffULL, 0x0000009a9d00720bULL, 0x000fe40003f1d000ULL,
0x000000a4009f7306ULL, 0x000ee20000205400ULL, 0x000000b4bb00720bULL, 0x004fce0003f3d000ULL,
0x0000003e00ad7306ULL, 0x000526000020d400ULL, 0x0000000151510812ULL, 0x000fe400078efcffULL,
0x000000504f00720bULL, 0x000fe20003f1d000ULL, 0x000000094040b231ULL, 0x082fe400003400ffULL,
0x000000ba00bc7306ULL, 0x000e62000020d400ULL, 0x0000009f9e00720bULL, 0x008fe20003f5d000ULL,
0x0000003c543c723cULL, 0x004f6200000418ffULL, 0x000000094242b231ULL, 0x000fc400003400ffULL,
0x000000084141b231ULL, 0x080fe400003400ffULL, 0x000000084343b231ULL, 0x000fe200003400ffULL,
0x000000a400a47306ULL, 0x000ea2000020d400ULL, 0x00000001adad6812ULL, 0x010fe400078efcffULL,
0x0000004a4b00720bULL, 0x000fe40003fdd000ULL, 0x000000ad5c5c723eULL, 0x000fe200000010ffULL,
0x000000485448723cULL, 0x000fe200000418ffULL, 0x0000000173730812ULL, 0x000fe200078efcffULL,
0x000000ae00467306ULL, 0x000fe20000209400ULL, 0x00000001bcbc1812ULL, 0x002fc400078efcffULL,
0x000000969500720bULL, 0x000fe40003f1d000ULL, 0x00000097bc50723eULL, 0x000fe400000010ffULL,
0x000000738686723eULL, 0x000fe200000010ffULL, 0x000000ae00a97306ULL, 0x000e620000205400ULL,
0x00000001a4a42812ULL, 0x004fe200078efcffULL, 0x0000005e403c723cULL, 0x020fe2000004183cULL,
0x000000535200720bULL, 0x000fe40003f5d000ULL, 0x000000015d5d6812ULL, 0x000fc400078efcffULL,
0x0000009b9800720bULL, 0x000fe20003fdd000ULL, 0x000000ae00ae7306ULL, 0x000ea2000020d400ULL,
0x000000a45d5d723eULL, 0x000fe400000010ffULL, 0x0000000180800812ULL, 0x000fe400078efcffULL,
0x000000a94600720bULL, 0x002fc60003f3d000ULL, 0x000000b1009a7306ULL, 0x000fe20000209400ULL,
0x0000000172722812ULL, 0x000fe200078efcffULL, 0x000000445444723cULL, 0x000f6200000418ffULL,
0x000000929100720bULL, 0x000fe40003f5d000ULL, 0x000000017f7f6812ULL, 0x000fe400078efcffULL,
0x0000008a8900720bULL, 0x000fe20003fdd000ULL, 0x000000b100977306ULL, 0x000e620000205400ULL,
0x0000008b8489723eULL, 0x000fe400000010ffULL, 0x000000877e84723eULL, 0x000fc400000010ffULL,
0x00000001aeae1812ULL, 0x004fe400078efcffULL, 0x0000004e9900720bULL, 0x000fe20003f3d000ULL,
0x0000003b007c7306ULL, 0x000fe20000009400ULL, 0x00000051ae51723eULL, 0x000fe200000010ffULL,
0x0000004c544c723cULL, 0x040f6200000418ffULL, 0x0000000179792812ULL, 0x000fe400078efcffULL,
0x000000016e6e6812ULL, 0x000fe400078efcffULL, 0x0000007f7272723eULL, 0x000fe200000010ffULL,
0x0000003b007d7306ULL, 0x000ea20000005400ULL, 0x000000979a00720bULL, 0x002fe20003f5d000ULL,
0x000000505450723cULL, 0x000fe200000418ffULL, 0x000000796e73723eULL, 0x000fc400000010ffULL,
0x0000000171711812ULL, 0x000fc600078efcffULL, 0x0000003a00827306ULL, 0x000fe20000009400ULL,
0x000000718087723eULL, 0x000fe200000010ffULL, 0x000000844044723cULL, 0x060fec0000041844ULL,
0x0000003a00837306ULL, 0x000e620000005400ULL, 0x0000007d7c00720bULL, 0x004fe20003fdd000ULL,
0x000000864048723cULL, 0x040fec0000041848ULL, 0x000000e8008f7306ULL, 0x000fe40000209400ULL,
0x00000072404c723cULL, 0x000fec000004184cULL, 0x000000e800907306ULL, 0x000ea20000205400ULL,
0x000000838200720bULL, 0x002fce0003f3d000ULL, 0x0000003a006f7306ULL, 0x000e70000000d400ULL,
0x0000003b00707306ULL, 0x000722000000d400ULL, 0x000000908f00720bULL, 0x004fe40003f1d000ULL,
0x0000007b8c8f723eULL, 0x000fca00000010ffULL, 0x000000b100997306ULL, 0x000ea2000020d400ULL,
0x000000385438723cULL, 0x008f6200000418ffULL, 0x000000016f6f1812ULL, 0x002fe400078efcffULL,
0x000000787700720bULL, 0x000fc80003f3d000ULL, 0x000000b000937306ULL, 0x000fe20000209400ULL,
0x0000005c5454723cULL, 0x000b6200000418ffULL, 0x0000000170706812ULL, 0x010fcc00078efcffULL,
0x000000b0005c7306ULL, 0x020e620000205400ULL, 0x0000000199992812ULL, 0x004fe200078efcffULL,
0x0000008e4058723cULL, 0x040b620000041858ULL, 0x000000016d6d1812ULL, 0x000fe400078efcffULL,
0x00000070997b723eULL, 0x000fe400000010ffULL, 0x0000006a6100720cULL, 0x000fe20003f26070ULL,
0x000000ac005e7306ULL, 0x000fe40000209400ULL, 0x000000884038723cULL, 0x000b6c0000041838ULL,
0x000000ac005f7306ULL, 0x000ea20000205400ULL, 0x0000005c9300720bULL, 0x002fc40003f5d000ULL,
0x000000016a5c7810ULL, 0x000fc80007ffe0ffULL, 0x0000005c6100720cULL, 0x000fe20004f26470ULL,
0x000000e8007a7306ULL, 0x000e70000020d400ULL, 0x000000b0005d7306ULL, 0x000ee2000020d400ULL,
0x0000005f5e00720bULL, 0x004fce0003fdd000ULL, 0x000000ac00ac7306ULL, 0x000ea2000020d400ULL,
0x000000017a7a0812ULL, 0x002fe400078efcffULL, 0x000000767500720bULL, 0x000fe40003f1d000ULL,
0x0000006f7a7a723eULL, 0x000fe400000010ffULL, 0x000000015d5d2812ULL, 0x008fe400078efcffULL,
0x0000006a6200720cULL, 0x000fc60003f46070ULL, 0x0000007a4050723cULL, 0x000b620000041850ULL,
0x0000005c6200720cULL, 0x000fe40005746470ULL, 0x00000001acac6812ULL, 0x004fe400078efcffULL,
0x0000000f3400720cULL, 0x000fe40003fc3070ULL, 0x000000016c6c0812ULL, 0x000fe400078efcffULL,
0x000000ac6d6d723eULL, 0x000fe400000010ffULL, 0x0000005d6c6c723eULL, 0x000fc400000010ffULL,
0x0000000f3400720cULL, 0x000fca0003f03070ULL, 0x0000006c4054723cULL, 0x000b620000041854ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000003c12127221ULL, 0x000fe40000010000ULL, 0x0000003d13137221ULL, 0x000fe40000010000ULL,
0x0000003816167221ULL, 0x020fe40000010000ULL, 0x0000003917177221ULL, 0x000fe40000010000ULL,
0x000000581a1a7221ULL, 0x000fe40000010000ULL, 0x000000591b1b7221ULL, 0x000fc40000010000ULL,
0x000000441e1e7221ULL, 0x000fe40000010000ULL, 0x000000451f1f7221ULL, 0x000fe40000010000ULL,
0x0000004822227221ULL, 0x000fe40000010000ULL, 0x0000004923237221ULL, 0x000fe40000010000ULL,
0x0000004c26267221ULL, 0x000fe40000010000ULL, 0x0000004d27277221ULL, 0x000fc40000010000ULL,
0x000000502a2a7221ULL, 0x000fe40000010000ULL, 0x000000512b2b7221ULL, 0x000fe40000010000ULL,
0x000000542e2e7221ULL, 0x000fe40000010000ULL, 0x000000552f2f7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000003e14147221ULL, 0x000fe40000010000ULL,
0x0000003f15157221ULL, 0x000fe40000010000ULL, 0x0000003a18187221ULL, 0x020fc40000010000ULL,
0x0000003b19197221ULL, 0x000fe40000010000ULL, 0x0000005a1c1c7221ULL, 0x000fe40000010000ULL,
0x0000005b1d1d7221ULL, 0x000fe40000010000ULL, 0x0000004620207221ULL, 0x000fe40000010000ULL,
0x0000004721217221ULL, 0x000fe40000010000ULL, 0x0000004a24247221ULL, 0x000fc40000010000ULL,
0x0000004b25257221ULL, 0x000fe40000010000ULL, 0x0000004e28287221ULL, 0x000fe40000010000ULL,
0x0000004f29297221ULL, 0x000fe40000010000ULL, 0x000000522c2c7221ULL, 0x000fe40000010000ULL,
0x000000532d2d7221ULL, 0x000fe40000010000ULL, 0x0000005630307221ULL, 0x000fc40000010000ULL,
0x0000005731317221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x020e62000c80043fULL,
0x00000002ff3b7819ULL, 0x000fe2000001165cULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000f3400720cULL, 0x000fe40003fc3070ULL, 0x0000003b5c3b7207ULL, 0x040fe40002800000ULL,
0x000000035c5c7812ULL, 0x000fe400078ec0ffULL, 0x0000000f3400720cULL, 0x000fe40003f03070ULL,
0x00000040ff587803ULL, 0x000fc40000000000ULL, 0x000000ff5c5c7207ULL, 0x000fe40006800000ULL,
0x000000033b387810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3f7224ULL, 0x000fc600078e0039ULL,
0x0000000338417812ULL, 0x040fe400078ec0ffULL, 0x0000000f38437211ULL, 0x000fc400078ff0ffULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b8400ff3a7984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe200078c486bULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8400ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe400078c486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x018b8c00ff3a7984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000143397810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x000000363900720cULL, 0x000fda0003fc6070ULL,
0x000005100000e947ULL, 0x000fea0003800000ULL, 0x0000000507407c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff457424ULL, 0x000fe400078e00ffULL, 0x00000010323a7824ULL, 0x000fe400078e00ffULL,
0x018a0000403c7984ULL, 0x000e620000004800ULL, 0x0000004035427824ULL, 0x000fe400078e0240ULL,
0x000000f03a477812ULL, 0x000fe200078ec0ffULL, 0x018ac0003c3c7984ULL, 0x002e640000004800ULL,
0x0000003c0d387224ULL, 0x002fc400078e0242ULL, 0x00000010403c7824ULL, 0x000fe400078e00ffULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe400030e0639ULL, 0x0000000443397824ULL, 0x000fc800078e0241ULL,
0x0000004039397824ULL, 0x000fca00078e00ffULL, 0x0000003960387217ULL, 0x000fca0007800000ULL,
0x0000000138387824ULL, 0x000fe400078e0a39ULL, 0x0000000140397824ULL, 0x000fc600078e0232ULL,
0x0000000538387c17ULL, 0x000fe4000f800000ULL, 0xfffffff03c397812ULL, 0x000fe400078ee239ULL,
0x80000005383e7c10ULL, 0x000fe4000fffe0ffULL, 0x0001400039497811ULL, 0x000fe400078e20ffULL,
0x0000003e0700720cULL, 0x000fe40003fc6070ULL, 0x0000000242397810ULL, 0x000fd60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a497faeULL, 0x0003e8000f101c4aULL,
0x018a0800403f7984ULL, 0x000ea80000004800ULL, 0x018ac0003f387984ULL, 0x004ea40000004800ULL,
0x000000380d387224ULL, 0x004fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x0000000207397810ULL, 0x000fc80007ffe0ffULL, 0x00000005394b7c10ULL, 0x040fe4000fffe0ffULL,
0x0000003e3900720cULL, 0x000fe40003fc6070ULL, 0x0000000442397810ULL, 0x000fe20007ffe0ffULL,
0x000000014b387824ULL, 0x040fe400078e0232ULL, 0x000000104b4b7824ULL, 0x000fca00078e00ffULL,
0xfffffff04b387812ULL, 0x000fc800078ee238ULL, 0x0001400038497811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c497faeULL, 0x0003e8000f101c4aULL,
0x018a1000403f7984ULL, 0x000ea80000004800ULL, 0x018ac0003f387984ULL, 0x0044e40000004800ULL,
0x00000006073f7810ULL, 0x004fe20007ffe0ffULL, 0x000000380d387224ULL, 0x008fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x0000000407397810ULL, 0x000fc80007ffe0ffULL,
0x00000005394b7c10ULL, 0x040fe4000fffe0ffULL, 0x0000003e3900720cULL, 0x000fc60003fc6070ULL,
0x000000014b387824ULL, 0x040fe400078e0232ULL, 0x000000104b4b7824ULL, 0x000fca00078e00ffULL,
0xfffffff04b387812ULL, 0x000fc800078ee238ULL, 0x00014000383d7811ULL, 0x002fe400078e20ffULL,
0x0000000642387810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000f101c4aULL, 0x018a1800403c7984ULL, 0x000ea80000004800ULL,
0x018ac0003c3c7984ULL, 0x004ea40000004800ULL, 0x0000003c0d387224ULL, 0x004fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fe200078e0045ULL, 0x000000053f457c10ULL, 0x000fc8000fffe0ffULL,
0x0000004738387210ULL, 0x000fe20007fde0ffULL, 0x0000000145427824ULL, 0x040fe400078e0232ULL,
0x0000001045457824ULL, 0x000fe400078e00ffULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x0000003e3f00720cULL, 0x000fe40003fc6070ULL, 0xfffffff045427812ULL, 0x000fc800078ee242ULL,
0x00014000423b7811ULL, 0x002fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000f101c4aULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x00000005073f7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff457424ULL, 0x000fe400078e00ffULL,
0x00000010323a7824ULL, 0x000fe400078e00ffULL, 0x018a00003f3c7984ULL, 0x000e620000004800ULL,
0x0000004035407824ULL, 0x000fe400078e023fULL, 0x000000f03a477812ULL, 0x000fe200078ec0ffULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0240ULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fe20007fde0ffULL,
0x000000013f387824ULL, 0x000fc800078e0232ULL, 0x000000ffff3b7224ULL, 0x000fe400030e0639ULL,
0x000000103f397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0001400038497811ULL, 0x000fe400078e20ffULL, 0x0000000240387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a497faeULL, 0x0003e8000b901c4aULL,
0x018a08003f3e7984ULL, 0x000ea80000004800ULL, 0x018ac0003e3e7984ULL, 0x004ea40000004800ULL,
0x0000003e0d387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000023f397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0232ULL,
0x0000001039397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0001400038497811ULL, 0x002fe400078e20ffULL, 0x0000000440387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c497faeULL, 0x0003e8000b901c4aULL,
0x018a10003f3e7984ULL, 0x000ea80000004800ULL, 0x018ac0003e3e7984ULL, 0x004ea40000004800ULL,
0x0000003e0d387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000043f397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0232ULL,
0x0000001039397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x00014000383d7811ULL, 0x002fe400078e20ffULL, 0x0000000640387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c4aULL,
0x018a18003f3c7984ULL, 0x000ea80000004800ULL, 0x018ac0003c3c7984ULL, 0x004ea40000004800ULL,
0x0000003c0d387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fe200078e0045ULL,
0x000000063f457810ULL, 0x000fc80007ffe0ffULL, 0x0000004738387210ULL, 0x000fe20007fde0ffULL,
0x00000001453e7824ULL, 0x040fe400078e0232ULL, 0x0000001045457824ULL, 0x000fe400078e00ffULL,
0x000000ffff397224ULL, 0x000fc600030e0639ULL, 0xfffffff0453e7812ULL, 0x000fc800078ee23eULL,
0x000140003e3b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000b901c4aULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x018b8c00ff3a7984ULL, 0x000e620000000800ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe200078c483fULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe400078c483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000433400720cULL, 0x000fe20003fc4070ULL, 0x00000004ff3a7424ULL, 0x000fe200078e00ffULL,
0x00018a000c3d7811ULL, 0x000fe400078e10ffULL, 0x000000ff5c387207ULL, 0x000fc40003000000ULL,
0x000000ff5c5c7207ULL, 0x000fc60007000000ULL, 0x0000000141387824ULL, 0x000fc800078e0238ULL,
0x0000004038397824ULL, 0x040fe200078e00ffULL, 0x0000004338387211ULL, 0x000fc800078ff0ffULL,
0x000000c039397812ULL, 0x000fca00078ec0ffULL, 0x0000010038387824ULL, 0x000fe200078e0239ULL,
0x0000000c5c397c10ULL, 0x000fc8000fffe0ffULL, 0x0000002038387810ULL, 0x000fca0007ffe0ffULL,
0x000000010c3b7824ULL, 0x100fe400078e0238ULL, 0x0000680039397a24ULL, 0x000fc600078e0238ULL,
0x000000603b00720cULL, 0x000fe20003fc6070ULL, 0x000000010c397824ULL, 0x000fc800078e0239ULL,
0x0000660039387625ULL, 0x000fd000078e003aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383d7faeULL, 0x0003e4000f12184aULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b7800ff387f8cULL, 0x000e62000c80043fULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x000000ffff6b7224ULL, 0x002fe200078e0039ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x0000000aff08723eULL, 0x000fc800000010ffULL, 0x00005410083a7816ULL, 0x000fe20000000008ULL,
0x0000cbc27f007947ULL, 0x000fea000b800000ULL, 0x00001f623a097589ULL, 0x0002a400000e0000ULL,
0x0000cc227f007947ULL, 0x000fea000b800000ULL, 0x00001f613a087589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010623f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0001ceb000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000d2a000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018623f7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff407424ULL, 0x000fe200078e00ffULL, 0x0001cf2000387802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000d23000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000663c783bULL, 0x006e620000004200ULL, 0x00001e3000017945ULL, 0x000fe60003800000ULL,
0x000000006540783bULL, 0x000ea80000004200ULL, 0x000000006444783bULL, 0x000f220000004200ULL,
0x0000003c00387306ULL, 0x002ff00000009400ULL, 0x0000003c00397306ULL, 0x000e700000005400ULL,
0x0000003c004c7306ULL, 0x000ee2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000003d004d7306ULL, 0x000ff0000000d400ULL, 0x0000003d00387306ULL, 0x000fe20000009400ULL,
0x000000014c4c6812ULL, 0x008fce00078efcffULL, 0x0000003d00397306ULL, 0x000e700000005400ULL,
0x0000003e004b7306ULL, 0x000fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000003f004a7306ULL, 0x000ff0000000d400ULL, 0x0000003e00387306ULL, 0x000fe20000009400ULL,
0x000000014d4d6812ULL, 0x000fce00078efcffULL, 0x0000003e00397306ULL, 0x000e700000005400ULL,
0x0000004000497306ULL, 0x004fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000004100487306ULL, 0x000ff0000000d400ULL, 0x0000003f00387306ULL, 0x000fe20000009400ULL,
0x000000014b4b6812ULL, 0x000fce00078efcffULL, 0x0000003f00397306ULL, 0x000e700000005400ULL,
0x00000042007a7306ULL, 0x000fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000004300787306ULL, 0x000ff0000000d400ULL, 0x0000004000387306ULL, 0x000fe20000009400ULL,
0x000000014a4a6812ULL, 0x000fce00078efcffULL, 0x0000004000397306ULL, 0x000e700000005400ULL,
0x0000004400767306ULL, 0x010fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000004500757306ULL, 0x000ff0000000d400ULL, 0x0000004100387306ULL, 0x000fe20000009400ULL,
0x0000000149496812ULL, 0x000fce00078efcffULL, 0x0000004100397306ULL, 0x000e700000005400ULL,
0x0000004600727306ULL, 0x000fe2000000d400ULL, 0x000000393800720bULL, 0x002fce0003fdd000ULL,
0x0000004700707306ULL, 0x000ff0000000d400ULL, 0x0000004200387306ULL, 0x000fe20000009400ULL,
0x0000000148486812ULL, 0x000fce00078efcffULL, 0x0000004200397306ULL, 0x000e640000005400ULL,
0x000000393800720bULL, 0x002fcc0003fdd000ULL, 0x0000004300387306ULL, 0x000ff00000009400ULL,
0x0000004300397306ULL, 0x000e620000005400ULL, 0x000000017a7a6812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fca0003fdd000ULL, 0x0000004400387306ULL, 0x000ff00000009400ULL,
0x0000004400397306ULL, 0x000e620000005400ULL, 0x0000000178786812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fca0003fdd000ULL, 0x0000004500387306ULL, 0x000ff00000009400ULL,
0x0000004500397306ULL, 0x000e620000005400ULL, 0x0000000176766812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fca0003fdd000ULL, 0x0000004600387306ULL, 0x000ff00000009400ULL,
0x0000004600397306ULL, 0x000e620000005400ULL, 0x0000000175756812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fca0003fdd000ULL, 0x0000004700387306ULL, 0x000ff00000009400ULL,
0x0000004700397306ULL, 0x000e620000005400ULL, 0x0000000172726812ULL, 0x000fe400078efcffULL,
0x000000393800720bULL, 0x002fc40003fdd000ULL, 0x000000006338783bULL, 0x000e760000004200ULL,
0x0000000170706812ULL, 0x000fe200078efcffULL, 0x00000038004e7306ULL, 0x002ff00000009400ULL,
0x00000038004f7306ULL, 0x000e700000005400ULL, 0x00000038006e7306ULL, 0x000ea2000000d400ULL,
0x0000004f4e00720bULL, 0x002fce0003fdd000ULL, 0x00000039006d7306ULL, 0x000ff0000000d400ULL,
0x00000039004e7306ULL, 0x000fe20000009400ULL, 0x000000016e6e6812ULL, 0x004fce00078efcffULL,
0x00000039004f7306ULL, 0x000e700000005400ULL, 0x0000003a006c7306ULL, 0x000fe2000000d400ULL,
0x0000004f4e00720bULL, 0x002fce0003fdd000ULL, 0x0000003a004e7306ULL, 0x000ff00000009400ULL,
0x0000003a004f7306ULL, 0x000e620000005400ULL, 0x000000016d6d6812ULL, 0x000fe400078efcffULL,
0x0000004f4e00720bULL, 0x002fc40003fdd000ULL, 0x00000018ff4e7819ULL, 0x000fc8000001143cULL,
0x0000004e004f7306ULL, 0x000fee0000209400ULL, 0x000000016c6c6812ULL, 0x000fe200078efcffULL,
0x0000004e00507306ULL, 0x000e700000205400ULL, 0x0000004e00517306ULL, 0x000ea2000020d400ULL,
0x000000504f00720bULL, 0x002fc40003fdd000ULL, 0x00000018ff4f7819ULL, 0x000fca000001143dULL,
0x0000004f00527306ULL, 0x000fec0000209400ULL, 0x0000000151516812ULL, 0x004fe400078efcffULL,
0x0000004f00537306ULL, 0x000e700000205400ULL, 0x0000004f00507306ULL, 0x000ea2000020d400ULL,
0x000000535200720bULL, 0x002fc40003fdd000ULL, 0x00000018ff527819ULL, 0x000fca000001143eULL,
0x0000005200537306ULL, 0x000fec0000209400ULL, 0x0000000150506812ULL, 0x004fe400078efcffULL,
0x0000005200547306ULL, 0x000e700000205400ULL, 0x00000052004e7306ULL, 0x000ea2000020d400ULL,
0x000000545300720bULL, 0x002fc40003fdd000ULL, 0x00000018ff537819ULL, 0x000fca000001143fULL,
0x0000005300547306ULL, 0x000fec0000209400ULL, 0x000000014e4e6812ULL, 0x004fe400078efcffULL,
0x0000005300557306ULL, 0x000e700000205400ULL, 0x00000053004f7306ULL, 0x0004e2000020d400ULL,
0x000000555400720bULL, 0x002fc40003fdd000ULL, 0x00000018ff547819ULL, 0x000fe40000011440ULL,
0x00000018ff537819ULL, 0x004fc60000011442ULL, 0x0000005400557306ULL, 0x000fec0000209400ULL,
0x000000014f4f6812ULL, 0x008fe400078efcffULL, 0x0000005400527306ULL, 0x000e700000205400ULL,
0x00000054007f7306ULL, 0x000ea2000020d400ULL, 0x000000525500720bULL, 0x002fce0003fdd000ULL,
0x0000005300547306ULL, 0x000fe20000205400ULL, 0x00000018ff527819ULL, 0x000fce0000011441ULL,
0x0000005200557306ULL, 0x000fe20000209400ULL, 0x000000017f7f6812ULL, 0x004fce00078efcffULL,
0x0000005200567306ULL, 0x000e700000205400ULL, 0x00000052007e7306ULL, 0x000ea2000020d400ULL,
0x000000565500720bULL, 0x002fce0003fdd000ULL, 0x00000053007c7306ULL, 0x000ff0000020d400ULL,
0x0000005300557306ULL, 0x0002e20000209400ULL, 0x000000017e7e6812ULL, 0x004fe400078efcffULL,
0x00000018ff537819ULL, 0x002fca0000011445ULL, 0x0000005300797306ULL, 0x000fe2000020d400ULL,
0x000000545500720bULL, 0x008fe40003fdd000ULL, 0x00000018ff547819ULL, 0x000fca0000011443ULL,
0x0000005400557306ULL, 0x000fec0000209400ULL, 0x000000017c7c6812ULL, 0x000fe400078efcffULL,
0x0000005400527306ULL, 0x000e700000205400ULL, 0x00000054007d7306ULL, 0x000ea2000020d400ULL,
0x000000525500720bULL, 0x002fce0003fdd000ULL, 0x0000005300547306ULL, 0x000fe20000205400ULL,
0x00000018ff527819ULL, 0x000fce0000011444ULL, 0x0000005200557306ULL, 0x000fe20000209400ULL,
0x000000017d7d6812ULL, 0x004fce00078efcffULL, 0x0000005200567306ULL, 0x000e700000205400ULL,
0x00000052007b7306ULL, 0x000ea2000020d400ULL, 0x000000565500720bULL, 0x002fce0003fdd000ULL,
0x0000005300557306ULL, 0x0002e40000209400ULL, 0x00000018ff537819ULL, 0x002fc80000011438ULL,
0x000000017b7b6812ULL, 0x004fe400078efcffULL, 0x0000005300737306ULL, 0x000fe2000020d400ULL,
0x000000545500720bULL, 0x008fe40003fdd000ULL, 0x00000018ff547819ULL, 0x000fca0000011446ULL,
0x0000005400557306ULL, 0x000fec0000209400ULL, 0x0000000179796812ULL, 0x000fe400078efcffULL,
0x0000005400527306ULL, 0x000e700000205400ULL, 0x0000005400777306ULL, 0x000ea2000020d400ULL,
0x000000525500720bULL, 0x002fce0003fdd000ULL, 0x0000005300547306ULL, 0x000fe20000205400ULL,
0x00000018ff527819ULL, 0x000fce0000011447ULL, 0x0000005200557306ULL, 0x000fe20000209400ULL,
0x0000000177776812ULL, 0x004fce00078efcffULL, 0x0000005200567306ULL, 0x000e700000205400ULL,
0x0000005200747306ULL, 0x000ea2000020d400ULL, 0x000000565500720bULL, 0x002fce0003fdd000ULL,
0x0000005300557306ULL, 0x000e620000209400ULL, 0x00000018ff567819ULL, 0x000fce000001143aULL,
0x0000005600537306ULL, 0x000fe20000205400ULL, 0x0000000174746812ULL, 0x004fe400078efcffULL,
0x000000545500720bULL, 0x002fca0003fdd000ULL, 0x00000056006f7306ULL, 0x000fe2000020d400ULL,
0x00000018ff547819ULL, 0x000fce0000011439ULL, 0x0000005400557306ULL, 0x000fe20000209400ULL,
0x0000000173736812ULL, 0x000fce00078efcffULL, 0x0000005400527306ULL, 0x000e700000205400ULL,
0x0000005400717306ULL, 0x000ea2000020d400ULL, 0x000000525500720bULL, 0x002fce0003fdd000ULL,
0x0000005600527306ULL, 0x000e6c0000209400ULL, 0x0000000171716812ULL, 0x004fe400078efcffULL,
0x000000535200720bULL, 0x002fe20003fdd000ULL, 0x000001003c527824ULL, 0x040fe400078e00ffULL,
0x000100003c3c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff527819ULL, 0x000fc80000011452ULL,
0x0000005200547306ULL, 0x000fe60000209400ULL, 0x000000016f6f6812ULL, 0x000fca00078efcffULL,
0x0000005200557306ULL, 0x000e700000205400ULL, 0x0000005200537306ULL, 0x000ea2000020d400ULL,
0x000000555400720bULL, 0x002fe40003fdd000ULL, 0x00000018ff557819ULL, 0x000fca000001143cULL,
0x00000055003c7306ULL, 0x000fec0000209400ULL, 0x0000000153536812ULL, 0x004fe400078efcffULL,
0x0000005500577306ULL, 0x000e640000205400ULL, 0x0000004c534c723eULL, 0x000fcc00000010ffULL,
0x0000005500547306ULL, 0x000ea2000020d400ULL, 0x000000573c00720bULL, 0x002fe20003fdd000ULL,
0x000001003d3c7824ULL, 0x040fe400078e00ffULL, 0x000100003d3d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff527819ULL, 0x000fe4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005200567306ULL, 0x000fe60000209400ULL, 0x0000000154546812ULL, 0x004fc800078efcffULL,
0x000000545154723eULL, 0x000fe200000010ffULL, 0x0000005200577306ULL, 0x000e700000205400ULL,
0x00000052003c7306ULL, 0x000ea2000020d400ULL, 0x000000575600720bULL, 0x002fce0003fdd000ULL,
0x0000003d00557306ULL, 0x000ff0000020d400ULL, 0x0000003d00567306ULL, 0x000fe20000209400ULL,
0x000000013c3c6812ULL, 0x004fce00078efcffULL, 0x0000003d00577306ULL, 0x000e620000205400ULL,
0x0000004d3c4d723eULL, 0x000fe400000010ffULL, 0x00013800673c7811ULL, 0x000fe400078e20ffULL,
0x000000575600720bULL, 0x002fe20003fdd000ULL, 0x000001003e567824ULL, 0x040fe400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000005600577306ULL, 0x000fe60000209400ULL,
0x0000000155556812ULL, 0x000fc800078efcffULL, 0x000000555055723eULL, 0x000fe200000010ffULL,
0x00000056005a7306ULL, 0x000e700000205400ULL, 0x0000005600527306ULL, 0x000ea2000020d400ULL,
0x0000005a5700720bULL, 0x002fce0003fdd000ULL, 0x0000003e003d7306ULL, 0x000ff0000020d400ULL,
0x0000003e00577306ULL, 0x000fe20000209400ULL, 0x0000000152526812ULL, 0x004fce00078efcffULL,
0x0000003e005a7306ULL, 0x000e620000205400ULL, 0x0000004b5250723eULL, 0x000fe400000010ffULL,
0x0000005a5700720bULL, 0x002fe20003fdd000ULL, 0x000001003f577824ULL, 0x040fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000005700567306ULL, 0x000fe60000209400ULL,
0x000000013d3d6812ULL, 0x000fc800078efcffULL, 0x0000003d4e4e723eULL, 0x000fe200000010ffULL,
0x0000005700597306ULL, 0x000e700000205400ULL, 0x0000005700817306ULL, 0x000ea2000020d400ULL,
0x000000595600720bULL, 0x002fce0003fdd000ULL, 0x0000003f003e7306ULL, 0x000ff0000020d400ULL,
0x0000003f00567306ULL, 0x000fe20000209400ULL, 0x0000000181816812ULL, 0x004fce00078efcffULL,
0x0000003f00597306ULL, 0x000e620000205400ULL, 0x0000004a8151723eULL, 0x000fe400000010ffULL,
0x000000595600720bULL, 0x002fe20003fdd000ULL, 0x0000010040567824ULL, 0x040fe400078e00ffULL,
0x0001000040407824ULL, 0x000fc600078e00ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x00000018ff3f7819ULL, 0x000fe40000011440ULL, 0x0000005600577306ULL, 0x000fe60000209400ULL,
0x000000013e3e6812ULL, 0x000fc800078efcffULL, 0x0000003e4f4f723eULL, 0x000fe200000010ffULL,
0x00000056005a7306ULL, 0x000e700000205400ULL, 0x0000005600807306ULL, 0x000ea2000020d400ULL,
0x0000005a5700720bULL, 0x002fce0003fdd000ULL, 0x0000003f00407306ULL, 0x000ff0000020d400ULL,
0x0000003f00577306ULL, 0x000fe20000209400ULL, 0x0000000180806812ULL, 0x004fce00078efcffULL,
0x0000003f005a7306ULL, 0x000e620000205400ULL, 0x00000049804a723eULL, 0x000fe400000010ffULL,
0x0000005a5700720bULL, 0x002fe20003fdd000ULL, 0x0000010041577824ULL, 0x040fe400078e00ffULL,
0x0001000041417824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000018ff3f7819ULL, 0x000fe40000011441ULL, 0x0000005700567306ULL, 0x000fe60000209400ULL,
0x0000000140406812ULL, 0x000fc800078efcffULL, 0x000000407f40723eULL, 0x000fe200000010ffULL,
0x0000005700597306ULL, 0x000e700000205400ULL, 0x0000005700877306ULL, 0x000ea2000020d400ULL,
0x000000595600720bULL, 0x002fce0003fdd000ULL, 0x0000003f00417306ULL, 0x000ff0000020d400ULL,
0x0000003f00567306ULL, 0x000fe20000209400ULL, 0x0000000187876812ULL, 0x004fce00078efcffULL,
0x0000003f00597306ULL, 0x000e620000205400ULL, 0x00000048874b723eULL, 0x000fce00000010ffULL,
0x0000003b007f7306ULL, 0x000fe20000005400ULL, 0x000000595600720bULL, 0x002fe20003fdd000ULL,
0x0000010042567824ULL, 0x040fe400078e00ffULL, 0x0001000042427824ULL, 0x000fc600078e00ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x0000005600577306ULL, 0x000fe60000209400ULL, 0x0000000141416812ULL, 0x000fc800078efcffULL,
0x000000417e41723eULL, 0x000fe200000010ffULL, 0x00000056005a7306ULL, 0x000e700000205400ULL,
0x0000005600857306ULL, 0x000ea2000020d400ULL, 0x0000005a5700720bULL, 0x002fce0003fdd000ULL,
0x00000042003f7306ULL, 0x000ff00000209400ULL, 0x00000042005a7306ULL, 0x000e620000205400ULL,
0x0000000185856812ULL, 0x004fce00078efcffULL, 0x0000004200837306ULL, 0x000ea2000020d400ULL,
0x0000005a3f00720bULL, 0x002fe20003fdd000ULL, 0x00000100433f7824ULL, 0x040fe400078e00ffULL,
0x0001000043437824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000003f00567306ULL, 0x000fe60000209400ULL,
0x0000000183836812ULL, 0x004fc800078efcffULL, 0x000000837c7c723eULL, 0x000fe200000010ffULL,
0x0000003f00577306ULL, 0x000e700000205400ULL, 0x0000003f00897306ULL, 0x000ea2000020d400ULL,
0x000000575600720bULL, 0x002fce0003fdd000ULL, 0x0000004300427306ULL, 0x000ff00000209400ULL,
0x0000004300577306ULL, 0x000e620000205400ULL, 0x0000000189896812ULL, 0x004fce00078efcffULL,
0x0000004300887306ULL, 0x000ea2000020d400ULL, 0x000000574200720bULL, 0x002fe20003fdd000ULL,
0x0000010044427824ULL, 0x040fe400078e00ffULL, 0x0001000044447824ULL, 0x000fc600078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x00000042003f7306ULL, 0x000fe60000209400ULL, 0x0000000188886812ULL, 0x004fc800078efcffULL,
0x000000887d7d723eULL, 0x000fe200000010ffULL, 0x0000004200567306ULL, 0x000e700000205400ULL,
0x00000042008b7306ULL, 0x000ea2000020d400ULL, 0x000000563f00720bULL, 0x002fce0003fdd000ULL,
0x0000004400827306ULL, 0x000ff0000020d400ULL, 0x00000044003f7306ULL, 0x000fe20000209400ULL,
0x000000018b8b6812ULL, 0x004fce00078efcffULL, 0x0000004400567306ULL, 0x000e640000205400ULL,
0x000000563f00720bULL, 0x002fe20003fdd000ULL, 0x00000100453f7824ULL, 0x040fe400078e00ffULL,
0x0001000045457824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000003f00427306ULL, 0x000fe60000209400ULL,
0x0000000182826812ULL, 0x000fca00078efcffULL, 0x0000003f00437306ULL, 0x000e700000205400ULL,
0x0000003f008a7306ULL, 0x000ea2000020d400ULL, 0x000000434200720bULL, 0x002fce0003fdd000ULL,
0x0000004500847306ULL, 0x000ff0000020d400ULL, 0x0000004500427306ULL, 0x000fe20000209400ULL,
0x000000018a8a6812ULL, 0x004fce00078efcffULL, 0x0000004500437306ULL, 0x000e640000205400ULL,
0x000000434200720bULL, 0x002fe20003fdd000ULL, 0x0000010046427824ULL, 0x040fe400078e00ffULL,
0x0001000046467824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000042003f7306ULL, 0x000fe60000209400ULL,
0x0000000184846812ULL, 0x000fc800078efcffULL, 0x000000847979723eULL, 0x000fe200000010ffULL,
0x0000004200447306ULL, 0x000e700000205400ULL, 0x00000042008d7306ULL, 0x000ea2000020d400ULL,
0x000000443f00720bULL, 0x002fce0003fdd000ULL, 0x0000004600867306ULL, 0x000ff0000020d400ULL,
0x00000046003f7306ULL, 0x000fe20000209400ULL, 0x000000018d8d6812ULL, 0x004fce00078efcffULL,
0x0000004600447306ULL, 0x000e640000205400ULL, 0x000000443f00720bULL, 0x002fe20003fdd000ULL,
0x00000100473f7824ULL, 0x040fe400078e00ffULL, 0x0001000047477824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000003f00427306ULL, 0x000fe60000209400ULL, 0x0000000186866812ULL, 0x000fc800078efcffULL,
0x000000867786723eULL, 0x000fe200000010ffULL, 0x0000003f00437306ULL, 0x000e700000205400ULL,
0x0000003f008f7306ULL, 0x000ea2000020d400ULL, 0x000000434200720bULL, 0x002fce0003fdd000ULL,
0x0000004700917306ULL, 0x000ff0000020d400ULL, 0x0000004700427306ULL, 0x000fe20000209400ULL,
0x000000018f8f6812ULL, 0x004fce00078efcffULL, 0x0000004700437306ULL, 0x000e640000205400ULL,
0x000000434200720bULL, 0x002fe20003fdd000ULL, 0x0000010038427824ULL, 0x040fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000042003f7306ULL, 0x000fe60000209400ULL,
0x0000000191916812ULL, 0x000fc800078efcffULL, 0x000000917487723eULL, 0x000fe200000010ffULL,
0x0000004200447306ULL, 0x000e700000205400ULL, 0x0000004200937306ULL, 0x000ea2000020d400ULL,
0x000000443f00720bULL, 0x002fce0003fdd000ULL, 0x00000038008c7306ULL, 0x000ff0000020d400ULL,
0x00000038003f7306ULL, 0x000fe20000209400ULL, 0x0000000193936812ULL, 0x004fce00078efcffULL,
0x0000003800447306ULL, 0x000e640000205400ULL, 0x000000443f00720bULL, 0x002fe20003fdd000ULL,
0x00000100393f7824ULL, 0x040fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003f00427306ULL, 0x000fe60000209400ULL, 0x000000018c8c6812ULL, 0x000fca00078efcffULL,
0x0000003f00437306ULL, 0x000e700000205400ULL, 0x0000003f008e7306ULL, 0x000ea2000020d400ULL,
0x000000434200720bULL, 0x002fce0003fdd000ULL, 0x0000003900387306ULL, 0x000ff00000209400ULL,
0x0000003900437306ULL, 0x000e620000205400ULL, 0x000000018e8e6812ULL, 0x004fce00078efcffULL,
0x0000003900907306ULL, 0x000ea2000020d400ULL, 0x000000433800720bULL, 0x002fe20003fdd000ULL,
0x000001003a387824ULL, 0x040fe200078e00ffULL, 0x000000788943723eULL, 0x000fe200000010ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000000827b78723eULL, 0x000fe400000010ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000038003f7306ULL, 0x000fe60000209400ULL, 0x0000000190906812ULL, 0x004fc800078efcffULL,
0x000000907171723eULL, 0x000fe200000010ffULL, 0x0000003800427306ULL, 0x000e700000205400ULL,
0x0000003800957306ULL, 0x000ea2000020d400ULL, 0x000000423f00720bULL, 0x002fce0003fdd000ULL,
0x0000003a00397306ULL, 0x000ff00000209400ULL, 0x0000003a00427306ULL, 0x000e620000205400ULL,
0x0000000195956812ULL, 0x004fce00078efcffULL, 0x0000003a00927306ULL, 0x000ea2000020d400ULL,
0x0000006c956c723eULL, 0x000fe400000010ffULL, 0x000000423900720bULL, 0x002fe20003fdd000ULL,
0x000001003b397824ULL, 0x000fc800078e00ffULL, 0x0000003b003a7306ULL, 0x000fe20000009400ULL,
0x0000007a8542723eULL, 0x000fe400000010ffULL, 0x00000018ff397819ULL, 0x000fca0000011439ULL,
0x0000003900387306ULL, 0x000fe20000209400ULL, 0x0000000192926812ULL, 0x004fc800078efcffULL,
0x000000926f92723eULL, 0x000fc600000010ffULL, 0x00000039003f7306ULL, 0x000e700000205400ULL,
0x0000003900977306ULL, 0x0004e2000020d400ULL, 0x0000003f3800720bULL, 0x002fce0003fdd000ULL,
0x0000003b007a7306ULL, 0x000322000000d400ULL, 0x0001380068387811ULL, 0x000fe200078e20ffULL,
0x000000003c3c783bULL, 0x000f220000000200ULL, 0x000000758a39723eULL, 0x004fc600000010ffULL,
0x00000000385c783bULL, 0x0005220000000200ULL, 0x0000000197976812ULL, 0x008fe200078efcffULL,
0x000100003b387824ULL, 0x004fe200078e00ffULL, 0x000000ff5800720cULL, 0x000fe40003fc5270ULL,
0x00000018ff3b7819ULL, 0x002fe4000001143bULL, 0x00000018ff7e7819ULL, 0x000fe40000011438ULL,
0x000000768b38723eULL, 0x000fe400000010ffULL, 0x0000007e00807306ULL, 0x000ff00000209400ULL,
0x0000007e00757306ULL, 0x000e700000205400ULL, 0x0000003b00767306ULL, 0x000fe20000209400ULL,
0x000000093c3cb231ULL, 0x010fc400003400ffULL, 0x000000093e3eb231ULL, 0x080fe400003400ffULL,
0x000000095c5cb231ULL, 0x080fe400003400ffULL, 0x000000095e5eb231ULL, 0x000fe400003400ffULL,
0x000000085d5db231ULL, 0x080fe400003400ffULL, 0x000000085f5fb231ULL, 0x080fe400003400ffULL,
0x000000083d3db231ULL, 0x000fc400003400ffULL, 0x000000083f3fb231ULL, 0x000fe200003400ffULL,
0x0000007f3a00720bULL, 0x000fe40003f7d000ULL, 0x0000004c5c58723cULL, 0x040f6200000418ffULL,
0x0000007e003a7306ULL, 0x000eae000020d400ULL, 0x000000505c50723cULL, 0x000f6600000418ffULL,
0x000000017a7a3812ULL, 0x000fc400078efcffULL, 0x000000758000720bULL, 0x002fe40003f7d000ULL,
0x0000003b00757306ULL, 0x000e620000205400ULL, 0x000000405c44723cULL, 0x000ff000000418ffULL,
0x000000383c58723cULL, 0x020be40000041858ULL, 0x000000013a3a3812ULL, 0x004fca00078efcffULL,
0x000000728d38723eULL, 0x020fe200000010ffULL, 0x000000545c54723cULL, 0x000f6200000418ffULL,
0x000000708f39723eULL, 0x000fe400000010ffULL, 0x000000757600720bULL, 0x002fe40003f7d000ULL,
0x0000008c7370723eULL, 0x000fc600000010ffULL, 0x000000383c50723cULL, 0x000bee0000041850ULL,
0x0000006e9338723eULL, 0x020fe200000010ffULL, 0x0000004e5c4c723cULL, 0x000f6200000418ffULL,
0x0000003b00937306ULL, 0x000e62000020d400ULL, 0x0000006d8e39723eULL, 0x000fc400000010ffULL,
0x0000007a976d723eULL, 0x000fc800000010ffULL, 0x0000004a5c48723cULL, 0x040f7000000418ffULL,
0x000000425c40723cULL, 0x000f6200000418ffULL, 0x0000000193933812ULL, 0x002fc800078efcffULL,
0x0000003a9393723eULL, 0x000fc600000010ffULL, 0x0000007c5c5c723cULL, 0x000f7000000418ffULL,
0x000000783c54723cULL, 0x040b700000041854ULL, 0x000000863c4c723cULL, 0x060b70000004184cULL,
0x000000383c48723cULL, 0x040b700000041848ULL, 0x000000703c44723cULL, 0x040b700000041844ULL,
0x0000006c3c40723cULL, 0x040b700000041840ULL, 0x000000923c5c723cULL, 0x000b62000004185cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000005812127221ULL, 0x000fe40000010000ULL, 0x0000005913137221ULL, 0x000fc40000010000ULL,
0x0000005416167221ULL, 0x000fe40000010000ULL, 0x0000005517177221ULL, 0x000fe40000010000ULL,
0x000000501a1a7221ULL, 0x000fe40000010000ULL, 0x000000511b1b7221ULL, 0x000fe40000010000ULL,
0x0000004c1e1e7221ULL, 0x020fe40000010000ULL, 0x0000004d1f1f7221ULL, 0x000fc40000010000ULL,
0x0000004822227221ULL, 0x000fe40000010000ULL, 0x0000004923237221ULL, 0x000fe40000010000ULL,
0x0000004426267221ULL, 0x000fe40000010000ULL, 0x0000004527277221ULL, 0x000fe40000010000ULL,
0x000000402a2a7221ULL, 0x000fe40000010000ULL, 0x000000412b2b7221ULL, 0x000fc40000010000ULL,
0x0000005c2e2e7221ULL, 0x000fe40000010000ULL, 0x0000005d2f2f7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000005a14147221ULL, 0x000fe40000010000ULL,
0x0000005b15157221ULL, 0x000fe40000010000ULL, 0x0000005618187221ULL, 0x000fe40000010000ULL,
0x0000005719197221ULL, 0x000fe40000010000ULL, 0x000000521c1c7221ULL, 0x000fc40000010000ULL,
0x000000531d1d7221ULL, 0x000fe40000010000ULL, 0x0000004e20207221ULL, 0x020fe40000010000ULL,
0x0000004f21217221ULL, 0x000fe40000010000ULL, 0x0000004a24247221ULL, 0x000fe40000010000ULL,
0x0000004b25257221ULL, 0x000fe40000010000ULL, 0x0000004628287221ULL, 0x000fc40000010000ULL,
0x0000004729297221ULL, 0x000fe40000010000ULL, 0x000000422c2c7221ULL, 0x000fe40000010000ULL,
0x000000432d2d7221ULL, 0x000fe40000010000ULL, 0x0000005e30307221ULL, 0x000fe40000010000ULL,
0x0000005f31317221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff387f8cULL, 0x020e62000c80043fULL, 0x000000696a00720cULL, 0x000fe20003f06070ULL,
0x000000ffff3c7224ULL, 0x002fd800078e0039ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff8c8000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b7000ffff7f8cULL, 0x000fe4000c80043fULL, 0x000000010f0f7810ULL, 0x000fc80007ffe0ffULL,
0x000000360f00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffe2bd000007947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff3600720cULL, 0x000fda0003f05270ULL, 0x0000039000008947ULL, 0x000fea0003800000ULL,
0x0180000011007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0001f0b000047802ULL, 0x004fc40000000f00ULL,
0x0000aee000007944ULL, 0x002fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001100007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x00afc80000000011ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006f00ff037624ULL, 0x000fe400078e00ffULL,
0x00006e00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000a02037981ULL, 0x000f28000c1e9900ULL,
0x0000000000047919ULL, 0x004ea40000000000ULL, 0x00000002ff3f7819ULL, 0x004fe20000011604ULL,
0x0000000003047220ULL, 0x018fe20000410000ULL, 0x0000a9527f007947ULL, 0x000fea000b800000ULL,
0x00001f3f04007589ULL, 0x0004e400000e0000ULL, 0x0000000000027919ULL, 0x000f220000000000ULL,
0x0000001200127220ULL, 0x048fe40000410000ULL, 0x0000001300137220ULL, 0x000fc40000410000ULL,
0x0000001600167220ULL, 0x040fe40000410000ULL, 0x0000001700177220ULL, 0x040fe40000410000ULL,
0x0000001a001a7220ULL, 0x040fe40000410000ULL, 0x0000001b001b7220ULL, 0x040fe40000410000ULL,
0x0000001e001e7220ULL, 0x040fe40000410000ULL, 0x0000001f001f7220ULL, 0x000fc40000410000ULL,
0x0000002200227220ULL, 0x040fe40000410000ULL, 0x0000002300237220ULL, 0x040fe40000410000ULL,
0x0000002600267220ULL, 0x040fe40000410000ULL, 0x0000002700277220ULL, 0x000fe20000410000ULL,
0x00000008023f7811ULL, 0x016fe200078ff0ffULL, 0x0000002a002a7220ULL, 0x040fe40000410000ULL,
0x0000002b002b7220ULL, 0x000fc40000410000ULL, 0x0000002e002e7220ULL, 0x040fe40000410000ULL,
0x0000002f002f7220ULL, 0x000fe20000410000ULL, 0x0000a8827f007947ULL, 0x000fea000b800000ULL,
0x00001f3f04007589ULL, 0x0002a400000e0000ULL, 0x0000001400147220ULL, 0x044fe40000410000ULL,
0x0000001500157220ULL, 0x040fe40000410000ULL, 0x0000001800187220ULL, 0x040fe40000410000ULL,
0x0000001900197220ULL, 0x040fe40000410000ULL, 0x0000001c001c7220ULL, 0x000fc40000410000ULL,
0x0000001d001d7220ULL, 0x040fe40000410000ULL, 0x0000002000207220ULL, 0x040fe40000410000ULL,
0x0000002100217220ULL, 0x040fe40000410000ULL, 0x0000002400247220ULL, 0x040fe40000410000ULL,
0x0000002500257220ULL, 0x040fe40000410000ULL, 0x0000002800287220ULL, 0x000fc40000410000ULL,
0x0000002900297220ULL, 0x040fe40000410000ULL, 0x0000002c002c7220ULL, 0x040fe40000410000ULL,
0x0000002d002d7220ULL, 0x040fe40000410000ULL, 0x0000003000307220ULL, 0x040fe40000410000ULL,
0x0000003100317220ULL, 0x000fc40000410000ULL, 0x0000000000337919ULL, 0x000ee20000002600ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000121300723eULL, 0x000fc400000010ffULL,
0x000000161702723eULL, 0x002fe400000010ffULL, 0x0000001a1b03723eULL, 0x000fe400000010ffULL,
0x0000001e1f04723eULL, 0x004fe400000010ffULL, 0x000000222305723eULL, 0x000fe400000010ffULL,
0x000000262706723eULL, 0x000fe400000010ffULL, 0x0000002a2b07723eULL, 0x000fc400000010ffULL,
0x0000002e2f08723eULL, 0x000fe400000010ffULL, 0x000000141509723eULL, 0x000fe400000010ffULL,
0x00000018190a723eULL, 0x000fe400000010ffULL, 0x0000001c1d0b723eULL, 0x000fe400000010ffULL,
0x00000020210c723eULL, 0x000fe400000010ffULL, 0x00000024250d723eULL, 0x000fc400000010ffULL,
0x00000028290e723eULL, 0x000fe400000010ffULL, 0x0000002c2d0f723eULL, 0x000fe400000010ffULL,
0x000000303110723eULL, 0x000fc400000010ffULL, 0x0000000000147919ULL, 0x008e620000000000ULL,
0x0001200008087891ULL, 0x000fe2000f8e583fULL, 0x0000763200197816ULL, 0x000fe40000000002ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000814127811ULL, 0x002fc400078ff0ffULL,
0x0000000214117812ULL, 0x000fc600078ec0ffULL, 0x0000000812167824ULL, 0x000fe200078e00ffULL,
0x0000001211137211ULL, 0x040fe200078ff8ffULL, 0x0000000814127824ULL, 0x000fe200078e00ffULL,
0x00000002ff147819ULL, 0x000fe40000011614ULL, 0xfffffff816167812ULL, 0x000fe400078ee213ULL,
0x0000000812137812ULL, 0x000fe200078ec0ffULL, 0x0000000814127824ULL, 0x040fe200078e00ffULL,
0x0000001411117211ULL, 0x000fe200078ff8ffULL, 0x0000000814177824ULL, 0x000fe200078e00ffULL,
0x0000000816167c11ULL, 0x000fe2000f8e20ffULL, 0x0000000814187824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee211ULL, 0x00000008141a7824ULL, 0x000fe200078e00ffULL,
0x0000000211147810ULL, 0x000fe20007ffe0ffULL, 0x0000000113167824ULL, 0x000fe200078e0216ULL,
0x0000000411157810ULL, 0x000fc40007ffe0ffULL, 0x0000000611117810ULL, 0x000fe40007ffe0ffULL,
0x0000000812127c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff817147812ULL, 0x000fe400078ee214ULL,
0xfffffff818157812ULL, 0x000fe200078ee215ULL, 0x0000000112127824ULL, 0x000fe200078e0213ULL,
0xfffffff81a117812ULL, 0x000fe400078ee211ULL, 0x0000541000187816ULL, 0x000fc40000000002ULL,
0x0000000814147c11ULL, 0x000fe4000f8e20ffULL, 0x0000000815007c11ULL, 0x000fe2000f8e20ffULL,
0x0000001812007388ULL, 0x0003e20000000a00ULL, 0x0000000811027c11ULL, 0x000fe2000f8e20ffULL,
0x0000000113147824ULL, 0x040fe400078e0214ULL, 0x0000000113007824ULL, 0x040fe400078e0200ULL,
0x0000000113027824ULL, 0x000fe200078e0202ULL, 0x0000763203137816ULL, 0x000fc40000000004ULL,
0x0000541003127816ULL, 0x002fe40000000004ULL, 0x0000541005047816ULL, 0x140fe40000000006ULL,
0x0000763205057816ULL, 0x000fe20000000006ULL, 0x0000001214007388ULL, 0x0003e20000000a00ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x0000000400007388ULL, 0x0003e20000000a00ULL, 0x0000541009087816ULL, 0x000fc4000000000aULL,
0x0000763209097816ULL, 0x000fe2000000000aULL, 0x0000000602007388ULL, 0x0003e20000000a00ULL,
0x000054100b0a7816ULL, 0x140fe4000000000cULL, 0x000076320b0b7816ULL, 0x000fe2000000000cULL,
0x0000000816007388ULL, 0x0003e20000000a00ULL, 0x000054100d0c7816ULL, 0x140fe4000000000eULL,
0x000076320d0d7816ULL, 0x000fe2000000000eULL, 0x0004000a14007388ULL, 0x0003e20000000a00ULL,
0x000054100f0e7816ULL, 0x000fc40000000010ULL, 0x000076320f0f7816ULL, 0x000fe20000000010ULL,
0x0004000c00007388ULL, 0x0003e80000000a00ULL, 0x0004000e02007388ULL, 0x0003e20000000a00ULL,
0x0000003000007947ULL, 0x000fea0003800000ULL, 0xffffffffff2d7424ULL, 0x000fe200078e00ffULL,
0x0001f8c0002e7802ULL, 0x000fc40000000f00ULL, 0x0000a94000007944ULL, 0x002fea0003c00000ULL,
0x0000000000097919ULL, 0x002e620000000000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x00000005ff087e24ULL, 0x000fe2000f8e00ffULL,
0x000000040d0472a4ULL, 0x000fcc000f8e023fULL, 0x00000004ff037e24ULL, 0x000fe2000f8e00ffULL,
0x00000003ff007819ULL, 0x002fca0000011609ULL, 0x0000000100027824ULL, 0x040fe400078e0209ULL,
0x0000580000007a24ULL, 0x000fc600078e0233ULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000003007211ULL, 0x000fe400078010ffULL, 0x0ffffff802047812ULL, 0x000fe400078ef809ULL,
0x0000000709097812ULL, 0x000fe200078ec0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0000027a11ULL, 0x000fe400078048ffULL, 0x0000000804047984ULL, 0x000e62000800cc00ULL,
0x1ffffff809097812ULL, 0x000fc400078ef808ULL, 0x00005b0000037a11ULL, 0x000fca00000f4c03ULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d0aULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000608057899ULL, 0x000fe2000800063fULL,
0x0000002010047810ULL, 0x000fca0007ffe0ffULL, 0x0000000510037c10ULL, 0x000fe2000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000680000047ab9ULL, 0x000fe20000000800ULL,
0x0000000504057c10ULL, 0x000fe2000fffe0ffULL, 0x000000040c0472a4ULL, 0x000fe2000f8e0205ULL,
0x000000600300720cULL, 0x080fe20003f06070ULL, 0x0000000808067899ULL, 0x000fe2000800063fULL,
0x000000600500720cULL, 0x000fe20003f26070ULL, 0x00000004ff0d7424ULL, 0x000fe200078e00ffULL,
0x018ad000ff087f8cULL, 0x000e62000c80043fULL, 0x0000000410027c10ULL, 0x000fe2000fffe0ffULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000000404047c10ULL, 0x000fe2000fffe0ffULL,
0x00006e00ff067624ULL, 0x000fe200078e00ffULL, 0x00000006100b7c11ULL, 0x000fe2000f8e10ffULL,
0x0000660002027625ULL, 0x000fe200078e000dULL, 0x000000031000780cULL, 0x000fc60003f44070ULL,
0x0000660004047625ULL, 0x000fe200078e000dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18600000020b7faeULL, 0x0005e6000c12184aULL, 0x00006f00ff077624ULL, 0x000fe200078e00ffULL,
0x18680000040b7faeULL, 0x0005ea000c92184aULL, 0x000000a000002947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x004ea20000002700ULL, 0x0000000837007c0cULL, 0x000fe2000bf03070ULL,
0x0000000403027824ULL, 0x004fc400078e0210ULL, 0x00000008ff037e24ULL, 0x000fe4000f8e00ffULL,
0x0000000202027824ULL, 0x000fe400078e00ffULL, 0x0000000403057824ULL, 0x000fe400078e0210ULL,
0x0000640002027a24ULL, 0x000fc600078e0203ULL, 0x00018a8005057811ULL, 0x000fe200078e10ffULL,
0x0000600002027625ULL, 0x000fca00078e000dULL, 0x0000000002057faeULL, 0x0005e4000c12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001ff0000780cULL, 0x000fe20003f04070ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000a06027981ULL, 0x004528000c1e9900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x000000ffff037224ULL, 0x002fe200078e0009ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000119000000947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x004e620000000000ULL, 0x00018a8008077891ULL, 0x000fe2000f8e203fULL,
0x0000000560007c17ULL, 0x000fe2000f800000ULL, 0x00000100ff107424ULL, 0x000fe200078e00ffULL,
0x0000200008097891ULL, 0x000fe4000f8e703fULL, 0x8000000500007c10ULL, 0x000fe4000fffe0ffULL,
0x00000003ff0f7819ULL, 0x002fe2000001160eULL, 0x000000100e057824ULL, 0x000fc600078e00ffULL,
0x000000000f00720cULL, 0x000fe20003f06070ULL, 0x018600060f067984ULL, 0x000e620008004800ULL,
0x00000040350b7824ULL, 0x000fe200078e020fULL, 0x0000007005117812ULL, 0x000fe200078ec0ffULL,
0x000000010f077824ULL, 0x040fe200078e020eULL, 0x000000040f097810ULL, 0x000fc80007ffe0ffULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x00000001090c7824ULL, 0x000fc600078e020eULL,
0x0ffffff8070d7812ULL, 0x000fc800078ef80eULL, 0x000000090d0d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000706067984ULL, 0x002e640008004800ULL, 0x0000000406047c24ULL, 0x002fc8000f8e020bULL,
0x00005e0004047625ULL, 0x000fca00078e0010ULL, 0x0000000411067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x000000040b057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c4aULL,
0x000000000900720cULL, 0x040fe20003f06070ULL, 0x0000000809097824ULL, 0x000fe400078e00ffULL,
0x018610060f0a7984ULL, 0x000ea60008004800ULL, 0xfffffff8090c7812ULL, 0x000fc800078ee20cULL,
0x000000090c0d7c11ULL, 0x002fe4000f8e20ffULL, 0x000000080f077810ULL, 0x000fca0007ffe0ffULL,
0x00000001070c7824ULL, 0x000fe200078e020eULL, 0x000000070a0a7984ULL, 0x004e640008004800ULL,
0x000000040a057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0010ULL,
0x0000000411087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x000000080b057810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c4aULL, 0x000000000700720cULL, 0x040fe20003f06070ULL,
0x0000000807077824ULL, 0x000fe400078e00ffULL, 0x018620060f0a7984ULL, 0x000ea60008004800ULL,
0xfffffff8070c7812ULL, 0x000fc800078ee20cULL, 0x000000090c0d7c11ULL, 0x002fe4000f8e20ffULL,
0x0000000c0f097810ULL, 0x000fca0007ffe0ffULL, 0x00000001090c7824ULL, 0x000fe200078e020eULL,
0x000000070a0a7984ULL, 0x004e640008004800ULL, 0x000000040a057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e0010ULL, 0x0000000411067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x0000000c0b057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c4aULL,
0x000000000900720cULL, 0x040fe20003f06070ULL, 0x0000000809097824ULL, 0x000fe400078e00ffULL,
0x018630060f0a7984ULL, 0x000ea60008004800ULL, 0xfffffff8090c7812ULL, 0x000fc800078ee20cULL,
0x000000090c0d7c11ULL, 0x002fe4000f8e20ffULL, 0x000000100f077810ULL, 0x000fca0007ffe0ffULL,
0x00000001070c7824ULL, 0x000fe200078e020eULL, 0x000000070a0a7984ULL, 0x004e640008004800ULL,
0x000000040a057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0010ULL,
0x0000000411087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x000000100b057810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c4aULL, 0x000000000700720cULL, 0x040fe20003f06070ULL,
0x0000000807077824ULL, 0x000fe400078e00ffULL, 0x018640060f0a7984ULL, 0x000ea60008004800ULL,
0xfffffff8070c7812ULL, 0x000fc800078ee20cULL, 0x000000090c0d7c11ULL, 0x002fe4000f8e20ffULL,
0x000000140f097810ULL, 0x000fca0007ffe0ffULL, 0x00000001090c7824ULL, 0x000fe200078e020eULL,
0x000000070a0a7984ULL, 0x004e640008004800ULL, 0x000000040a057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e0010ULL, 0x0000000411067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x000000140b057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c4aULL,
0x000000000900720cULL, 0x040fe20003f06070ULL, 0x0000000809097824ULL, 0x000fe400078e00ffULL,
0x018650060f0a7984ULL, 0x000ea60008004800ULL, 0xfffffff8090c7812ULL, 0x000fc800078ee20cULL,
0x000000090c0d7c11ULL, 0x002fe4000f8e20ffULL, 0x000000180f077810ULL, 0x000fca0007ffe0ffULL,
0x00000001070c7824ULL, 0x000fe200078e020eULL, 0x000000070a0a7984ULL, 0x004e640008004800ULL,
0x000000040a057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0010ULL,
0x0000000411087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x000000180b057810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c4aULL, 0x000000000700720cULL, 0x040fe20003f06070ULL,
0x0000000807077824ULL, 0x000fe400078e00ffULL, 0x018660060f0a7984ULL, 0x000ea60008004800ULL,
0xfffffff8070c7812ULL, 0x000fc800078ee20cULL, 0x000000090c0d7c11ULL, 0x002fe4000f8e20ffULL,
0x0000001c0f097810ULL, 0x000fca0007ffe0ffULL, 0x00000001090c7824ULL, 0x000fe200078e020eULL,
0x000000070a0a7984ULL, 0x004e640008004800ULL, 0x000000040a057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e0010ULL, 0x0000000411067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x0000001c0b057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c4aULL,
0x000000000900720cULL, 0x040fe20003f06070ULL, 0x0000000809097824ULL, 0x000fe400078e00ffULL,
0x018670060f0a7984ULL, 0x000ea60008004800ULL, 0xfffffff8090c7812ULL, 0x000fc800078ee20cULL,
0x000000090c0d7c11ULL, 0x002fe4000f8e20ffULL, 0x000000200f077810ULL, 0x000fca0007ffe0ffULL,
0x00000001070c7824ULL, 0x000fe200078e020eULL, 0x000000070a0a7984ULL, 0x004e640008004800ULL,
0x000000040a057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0010ULL,
0x0000000411087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x000000200b057810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c4aULL, 0x000000000700720cULL, 0x040fe20003f06070ULL,
0x0000000807077824ULL, 0x000fe400078e00ffULL, 0x018680060f0a7984ULL, 0x000ea60008004800ULL,
0xfffffff8070c7812ULL, 0x000fc800078ee20cULL, 0x000000090c0d7c11ULL, 0x002fe4000f8e20ffULL,
0x000000240f097810ULL, 0x000fca0007ffe0ffULL, 0x00000001090c7824ULL, 0x000fe200078e020eULL,
0x000000070a0a7984ULL, 0x004e640008004800ULL, 0x000000040a057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e0010ULL, 0x0000000411067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x000000240b057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c4aULL,
0x000000000900720cULL, 0x040fe20003f06070ULL, 0x0000000809097824ULL, 0x000fe400078e00ffULL,
0x018690060f0a7984ULL, 0x000ea60008004800ULL, 0xfffffff8090c7812ULL, 0x000fc800078ee20cULL,
0x000000090c0d7c11ULL, 0x002fe4000f8e20ffULL, 0x000000280f077810ULL, 0x000fca0007ffe0ffULL,
0x00000001070c7824ULL, 0x000fe200078e020eULL, 0x000000070a0a7984ULL, 0x004e640008004800ULL,
0x000000040a057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0010ULL,
0x0000000411087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x000000280b057810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c4aULL, 0x000000000700720cULL, 0x040fe20003f06070ULL,
0x0000000807077824ULL, 0x000fe400078e00ffULL, 0x0186a0060f0a7984ULL, 0x000ea60008004800ULL,
0xfffffff8070c7812ULL, 0x000fc800078ee20cULL, 0x000000090c0d7c11ULL, 0x002fe4000f8e20ffULL,
0x0000002c0f097810ULL, 0x000fca0007ffe0ffULL, 0x00000001090c7824ULL, 0x000fe200078e020eULL,
0x000000070a0a7984ULL, 0x004e640008004800ULL, 0x000000040a057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e0010ULL, 0x0000000411067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x0000002c0b057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c4aULL,
0x000000000900720cULL, 0x040fe20003f06070ULL, 0x0000000809097824ULL, 0x000fe400078e00ffULL,
0x0186b0060f0a7984ULL, 0x000ea60008004800ULL, 0xfffffff8090c7812ULL, 0x000fc800078ee20cULL,
0x000000090c0d7c11ULL, 0x002fe4000f8e20ffULL, 0x000000300f077810ULL, 0x000fca0007ffe0ffULL,
0x00000001070c7824ULL, 0x000fe200078e020eULL, 0x000000070a0a7984ULL, 0x004e640008004800ULL,
0x000000040a057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0010ULL,
0x0000000411087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x000000300b057810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c4aULL, 0x000000000700720cULL, 0x040fe20003f06070ULL,
0x0000000807077824ULL, 0x000fe400078e00ffULL, 0x0186c0060f0a7984ULL, 0x000ea60008004800ULL,
0xfffffff8070c7812ULL, 0x000fc800078ee20cULL, 0x000000090c0d7c11ULL, 0x002fe4000f8e20ffULL,
0x000000340f097810ULL, 0x000fca0007ffe0ffULL, 0x00000001090c7824ULL, 0x000fe200078e020eULL,
0x000000070a0a7984ULL, 0x004e640008004800ULL, 0x000000040a057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e0010ULL, 0x0000000411067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x000000340b057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c4aULL,
0x000000000900720cULL, 0x040fe20003f06070ULL, 0x0000000809097824ULL, 0x000fe400078e00ffULL,
0x0186d0060f0a7984ULL, 0x000ea60008004800ULL, 0xfffffff8090c7812ULL, 0x000fc800078ee20cULL,
0x000000090c0d7c11ULL, 0x002fe4000f8e20ffULL, 0x000000380f077810ULL, 0x000fca0007ffe0ffULL,
0x00000001070c7824ULL, 0x000fe200078e020eULL, 0x000000070a0a7984ULL, 0x004e640008004800ULL,
0x000000040a057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0010ULL,
0x0000000411087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x000000380b057810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c4aULL, 0x000000000700720cULL, 0x040fe20003f06070ULL,
0x0000000807077824ULL, 0x000fe400078e00ffULL, 0x0186e0060f0a7984ULL, 0x000ea60008004800ULL,
0xfffffff8070c7812ULL, 0x000fc800078ee20cULL, 0x000000090c097c11ULL, 0x002fe2000f8e20ffULL,
0x000000070a0a7984ULL, 0x004e640008004800ULL, 0x000000040a057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e0010ULL, 0x0000000411067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x0000003c0b057810ULL, 0x000fe40007ffe0ffULL,
0x0000003c0f0b7810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e4000c101c4aULL, 0x000000000b00720cULL, 0x040fe20003f06070ULL,
0x000000010b007824ULL, 0x040fe200078e020eULL, 0x0186f0060f087984ULL, 0x000ea20008004800ULL,
0x000000080b0b7824ULL, 0x000fca00078e00ffULL, 0xfffffff80b007812ULL, 0x000fc800078ee200ULL,
0x0000000900077c11ULL, 0x002fe2000f8e20ffULL, 0x0000000708087984ULL, 0x004e640008004800ULL,
0x0000000408057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0010ULL,
0x0000000411047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e2000c101c4aULL,
0x0000106000007947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x004e620000000000ULL,
0x00018a8008077891ULL, 0x000fe2000f8e203fULL, 0x00000100ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000200008097891ULL, 0x000fe2000f8e703fULL, 0x00000003ff0b7819ULL, 0x002fe2000001160aULL,
0x000000100a067824ULL, 0x000fc600078e00ffULL, 0x000000040b097810ULL, 0x000fe20007ffe0ffULL,
0x018600060b007984ULL, 0x000e620008004800ULL, 0x00000040350d7824ULL, 0x000fe200078e020bULL,
0x0000007006117812ULL, 0x000fe200078ec0ffULL, 0x000000010b077824ULL, 0x100fe400078e020aULL,
0x00000001090c7824ULL, 0x040fe400078e020aULL, 0x0000000809097824ULL, 0x000fe200078e00ffULL,
0x0000000707077812ULL, 0x000fc800078ec0ffULL, 0xfffffff8090c7812ULL, 0x000fe200078ee20cULL,
0x0000000700007984ULL, 0x002e640008004800ULL, 0x0000000400047c24ULL, 0x002fe2000f8e020dULL,
0x0ffffff807007812ULL, 0x000fc600078ef80aULL, 0x00005e0004047625ULL, 0x000fe200078e000fULL,
0x0000000900137c11ULL, 0x000fc8000f8e20ffULL, 0x0000001104067210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x000000040d057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006137faeULL, 0x0003e8000b901c4aULL,
0x018610060b007984ULL, 0x000ea20008004800ULL, 0x000000090c137c11ULL, 0x002fe4000f8e20ffULL,
0x000000080b077810ULL, 0x000fca0007ffe0ffULL, 0x00000001070c7824ULL, 0x040fe400078e020aULL,
0x0000000807077824ULL, 0x000fca00078e00ffULL, 0xfffffff8070c7812ULL, 0x000fe200078ee20cULL,
0x0000000700007984ULL, 0x004e640008004800ULL, 0x0000000400047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000fULL, 0x0000001104087210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0605ULL, 0x000000080d057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e8000b901c4aULL,
0x018620060b007984ULL, 0x000ea20008004800ULL, 0x000000090c137c11ULL, 0x002fe4000f8e20ffULL,
0x0000000c0b097810ULL, 0x000fca0007ffe0ffULL, 0x00000001090c7824ULL, 0x040fe400078e020aULL,
0x0000000809097824ULL, 0x000fca00078e00ffULL, 0xfffffff8090c7812ULL, 0x000fe200078ee20cULL,
0x0000000700007984ULL, 0x004e640008004800ULL, 0x0000000400047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000fULL, 0x0000001104067210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x0000000c0d057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006137faeULL, 0x0003e8000b901c4aULL,
0x018630060b007984ULL, 0x000ea20008004800ULL, 0x000000090c137c11ULL, 0x002fe4000f8e20ffULL,
0x000000100b077810ULL, 0x000fca0007ffe0ffULL, 0x00000001070c7824ULL, 0x040fe400078e020aULL,
0x0000000807077824ULL, 0x000fca00078e00ffULL, 0xfffffff8070c7812ULL, 0x000fe200078ee20cULL,
0x0000000700007984ULL, 0x004e640008004800ULL, 0x0000000400047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000fULL, 0x0000001104087210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0605ULL, 0x000000100d057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e8000b901c4aULL,
0x018640060b007984ULL, 0x000ea20008004800ULL, 0x000000090c137c11ULL, 0x002fe4000f8e20ffULL,
0x000000140b097810ULL, 0x000fca0007ffe0ffULL, 0x00000001090c7824ULL, 0x040fe400078e020aULL,
0x0000000809097824ULL, 0x000fca00078e00ffULL, 0xfffffff8090c7812ULL, 0x000fe200078ee20cULL,
0x0000000700007984ULL, 0x004e640008004800ULL, 0x0000000400047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000fULL, 0x0000001104067210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x000000140d057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006137faeULL, 0x0003e8000b901c4aULL,
0x018650060b007984ULL, 0x000ea20008004800ULL, 0x000000090c137c11ULL, 0x002fe4000f8e20ffULL,
0x000000180b077810ULL, 0x000fca0007ffe0ffULL, 0x00000001070c7824ULL, 0x040fe400078e020aULL,
0x0000000807077824ULL, 0x000fca00078e00ffULL, 0xfffffff8070c7812ULL, 0x000fe200078ee20cULL,
0x0000000700007984ULL, 0x004e640008004800ULL, 0x0000000400047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000fULL, 0x0000001104087210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0605ULL, 0x000000180d057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e8000b901c4aULL,
0x018660060b007984ULL, 0x000ea20008004800ULL, 0x000000090c137c11ULL, 0x002fe4000f8e20ffULL,
0x0000001c0b097810ULL, 0x000fca0007ffe0ffULL, 0x00000001090c7824ULL, 0x040fe400078e020aULL,
0x0000000809097824ULL, 0x000fca00078e00ffULL, 0xfffffff8090c7812ULL, 0x000fe200078ee20cULL,
0x0000000700007984ULL, 0x004e640008004800ULL, 0x0000000400047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000fULL, 0x0000001104067210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x0000001c0d057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006137faeULL, 0x0003e8000b901c4aULL,
0x018670060b007984ULL, 0x000ea20008004800ULL, 0x000000090c137c11ULL, 0x002fe4000f8e20ffULL,
0x000000200b077810ULL, 0x000fca0007ffe0ffULL, 0x00000001070c7824ULL, 0x040fe400078e020aULL,
0x0000000807077824ULL, 0x000fca00078e00ffULL, 0xfffffff8070c7812ULL, 0x000fe200078ee20cULL,
0x0000000700007984ULL, 0x004e640008004800ULL, 0x0000000400047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000fULL, 0x0000001104087210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0605ULL, 0x000000200d057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e8000b901c4aULL,
0x018680060b007984ULL, 0x000ea20008004800ULL, 0x000000090c137c11ULL, 0x002fe4000f8e20ffULL,
0x000000240b097810ULL, 0x000fca0007ffe0ffULL, 0x00000001090c7824ULL, 0x040fe400078e020aULL,
0x0000000809097824ULL, 0x000fca00078e00ffULL, 0xfffffff8090c7812ULL, 0x000fe200078ee20cULL,
0x0000000700007984ULL, 0x004e640008004800ULL, 0x0000000400047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000fULL, 0x0000001104067210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x000000240d057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006137faeULL, 0x0003e8000b901c4aULL,
0x018690060b007984ULL, 0x000ea20008004800ULL, 0x000000090c137c11ULL, 0x002fe4000f8e20ffULL,
0x000000280b077810ULL, 0x000fca0007ffe0ffULL, 0x00000001070c7824ULL, 0x040fe400078e020aULL,
0x0000000807077824ULL, 0x000fca00078e00ffULL, 0xfffffff8070c7812ULL, 0x000fe200078ee20cULL,
0x0000000700007984ULL, 0x004e640008004800ULL, 0x0000000400047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000fULL, 0x0000001104087210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0605ULL, 0x000000280d057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e8000b901c4aULL,
0x0186a0060b007984ULL, 0x000ea20008004800ULL, 0x000000090c137c11ULL, 0x002fe4000f8e20ffULL,
0x0000002c0b097810ULL, 0x000fca0007ffe0ffULL, 0x00000001090c7824ULL, 0x040fe400078e020aULL,
0x0000000809097824ULL, 0x000fca00078e00ffULL, 0xfffffff8090c7812ULL, 0x000fe200078ee20cULL,
0x0000000700007984ULL, 0x004e640008004800ULL, 0x0000000400047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000fULL, 0x0000001104067210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x0000002c0d057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006137faeULL, 0x0003e8000b901c4aULL,
0x0186b0060b007984ULL, 0x000ea20008004800ULL, 0x000000090c137c11ULL, 0x002fe4000f8e20ffULL,
0x000000300b077810ULL, 0x000fca0007ffe0ffULL, 0x00000001070c7824ULL, 0x040fe400078e020aULL,
0x0000000807077824ULL, 0x000fca00078e00ffULL, 0xfffffff8070c7812ULL, 0x000fe200078ee20cULL,
0x0000000700007984ULL, 0x004e640008004800ULL, 0x0000000400047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000fULL, 0x0000001104087210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0605ULL, 0x000000300d057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e8000b901c4aULL,
0x0186c0060b007984ULL, 0x000ea20008004800ULL, 0x000000090c137c11ULL, 0x002fe4000f8e20ffULL,
0x000000340b097810ULL, 0x000fca0007ffe0ffULL, 0x00000001090c7824ULL, 0x040fe400078e020aULL,
0x0000000809097824ULL, 0x000fca00078e00ffULL, 0xfffffff8090c7812ULL, 0x000fe200078ee20cULL,
0x0000000700007984ULL, 0x004e640008004800ULL, 0x0000000400047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000fULL, 0x0000001104067210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x000000340d057810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006137faeULL, 0x0003e8000b901c4aULL,
0x0186d0060b007984ULL, 0x000ea20008004800ULL, 0x000000090c137c11ULL, 0x002fe4000f8e20ffULL,
0x000000380b077810ULL, 0x000fca0007ffe0ffULL, 0x00000001070c7824ULL, 0x040fe400078e020aULL,
0x0000000807077824ULL, 0x000fca00078e00ffULL, 0xfffffff8070c7812ULL, 0x000fe200078ee20cULL,
0x0000000700007984ULL, 0x004e640008004800ULL, 0x0000000400047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000fULL, 0x0000001104087210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0605ULL, 0x000000380d057810ULL, 0x040fe40007ffe0ffULL,
0x0000003c0d0d7810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e8000b901c4aULL, 0x0186e0060b007984ULL, 0x000ea20008004800ULL,
0x000000090c097c11ULL, 0x002fc6000f8e20ffULL, 0x0000000700007984ULL, 0x004e640008004800ULL,
0x0000000400047c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0004047625ULL, 0x000fca00078e000fULL,
0x0000001104067210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff077224ULL, 0x000fca00000e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e8000b901c4aULL,
0x0186f0060b007984ULL, 0x000ea80008004800ULL, 0x0000000700007984ULL, 0x004ea40008004800ULL,
0x0000000400047c24ULL, 0x004fe2000f8e020dULL, 0x0000003c0b0d7810ULL, 0x000fc60007ffe0ffULL,
0x00005e0004047625ULL, 0x000fc800078e000fULL, 0x000000010d0a7824ULL, 0x040fe200078e020aULL,
0x0000001104047210ULL, 0x000fe20007f1e0ffULL, 0x000000080d0d7824ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0xfffffff80d0a7812ULL, 0x000fc800078ee20aULL,
0x000000090a077c11ULL, 0x002fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e4000b901c4aULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000047805ULL, 0x002fc40000015200ULL,
0x018ad400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011407ULL,
0x0000000900007211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000200007819ULL, 0x000fc80000001207ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x018ad400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x00000008ff007e24ULL, 0x000fc8000f8e00ffULL,
0x0000002000037824ULL, 0x002fca00078e0203ULL, 0x00000003ff047819ULL, 0x000fe40000011603ULL,
0x0000000f03037812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL,
0x0000000103057810ULL, 0x040fe20007ffe0ffULL, 0x0000002003087824ULL, 0x040fe400078e00ffULL,
0x0000000103067824ULL, 0x040fe400078e0204ULL, 0x0000000104077824ULL, 0x040fe200078e0205ULL,
0x0000001004047810ULL, 0x000fe20007ffe0ffULL, 0x0000002003097824ULL, 0x000fe200078e00ffULL,
0x0000001f06067812ULL, 0x000fc400078ec0ffULL, 0x0000001f07077812ULL, 0x000fe200078ec0ffULL,
0x0000000103107824ULL, 0x000fe200078e0204ULL, 0x000001e009067812ULL, 0x000fe200078ee206ULL,
0x0000000105047824ULL, 0x000fe200078e0204ULL, 0x000001e008077812ULL, 0x000fe200078ee207ULL,
0x0000002003057824ULL, 0x040fe200078e00ffULL, 0x0000001f10107812ULL, 0x000fe200078ec0ffULL,
0x00000000060c7984ULL, 0x000e62000000cc00ULL, 0x0000002003037824ULL, 0x000fe200078e00ffULL,
0x0000001f04047812ULL, 0x000fe400078ec0ffULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000001e005107812ULL, 0x000fc400078ee210ULL, 0x000001e003047812ULL, 0x000fe200078ee204ULL,
0x000000ffff147224ULL, 0x002fe400078e000cULL, 0x000000ffff157224ULL, 0x000fe400078e000eULL,
0x000000ffff167224ULL, 0x004fe400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e000aULL,
0x000000ffff1a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1b7224ULL, 0x000fe200078e000bULL,
0x0000001406007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff187224ULL, 0x000fc400078e000dULL,
0x000000ffff197224ULL, 0x000fca00078e000fULL, 0x0000001807007388ULL, 0x000fe8000000cc00ULL,
0x0000000004087984ULL, 0x000e68000000cc00ULL, 0x00000000100c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000aULL, 0x000000ffff1e7224ULL, 0x000fc400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1c7224ULL, 0x004fe400078e000cULL,
0x000000ffff1d7224ULL, 0x000fe400078e000eULL, 0x000000ffff087224ULL, 0x000fe400078e000dULL,
0x000000ffff097224ULL, 0x000fe200078e000fULL, 0x0000001c10007388ULL, 0x0003e8000000cc00ULL,
0x0000000804007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018ad000ff047f8cULL, 0x002e62000c80043fULL, 0x000000ffff097224ULL, 0x000fc400078e00ffULL,
0x000000ffff087224ULL, 0x002fc400078e0005ULL, 0x0000000000047805ULL, 0x000fca0000015200ULL,
0x018ad400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804808ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604067210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011407ULL, 0x0000000603037211ULL, 0x000fca00078110ffULL,
0x000000ffff067224ULL, 0x000fca00000e0607ULL, 0x0000000203037819ULL, 0x000fc80000001206ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000109097810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x018ad400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804808ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff3600720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x00005800ff0a7624ULL, 0x000fe200078e00ffULL, 0x00018b5800047811ULL, 0x000fe200078e18ffULL,
0x3d80000002027820ULL, 0x010fe20000410000ULL, 0xffffffff36057810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x00018ad800067811ULL, 0x000fe200078e28ffULL,
0x000000ffff097224ULL, 0x000fe400078e00ffULL, 0x00000008ff087e24ULL, 0x000fe4000f8e00ffULL,
0x000000400a0a7824ULL, 0x000fc400078e00ffULL, 0x00000005070b7c11ULL, 0x000fe2000f8e40ffULL,
0x0000000000007946ULL, 0x000fe60003800000ULL, 0x0000000b6000720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x00cfea0003800000ULL, 0x00000004ff0d7424ULL, 0x000fe200078e00ffULL,
0x000000073400720cULL, 0x000fe20003f44070ULL, 0x000000ffff0c7224ULL, 0x000fc600078e00ffULL,
0x000000010d0d7807ULL, 0x000fc40005000000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e0009ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0e7224ULL, 0x000fe200078e000cULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fc4000001ff00ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x000000337f007947ULL, 0x020fea000b800000ULL,
0xffffffffff2d7424ULL, 0x000fe200078e00ffULL, 0x000229d0002e7802ULL, 0x000fc40000000f00ULL,
0x0000783000007944ULL, 0x002fea0003c00000ULL, 0x0000000110177810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000c172c7211ULL, 0x040fe200078ff8ffULL,
0x000020a000007945ULL, 0x000fe20003800000ULL, 0x00000001175e7812ULL, 0x000fe400078ec0ffULL,
0x000000032c2d7812ULL, 0x000fe400078ec0ffULL, 0x00000002ff2ca819ULL, 0x000fca000001162cULL,
0x000000012c157824ULL, 0x000fe200078e0207ULL, 0x000000ff2d2c7207ULL, 0x000fc80005000000ULL,
0x0000000115097810ULL, 0x000fc80007ffe0ffULL, 0x000000360900720cULL, 0x000fe40003f06070ULL,
0x000000010f097812ULL, 0x000fd600078e0cffULL, 0x000010a000008947ULL, 0x000fea0003800000ULL,
0x00000003ff2e7819ULL, 0x002fe20000011603ULL, 0x00018a8008047891ULL, 0x000fe2000f8e203fULL,
0x0000000515397c11ULL, 0x000fe2000f8e40ffULL, 0x00000002002d7824ULL, 0x000fe400078e0209ULL,
0x018600062e2f7984ULL, 0x000e620008004800ULL, 0x0000003960387217ULL, 0x000fe20007800000ULL,
0x00000040353b7824ULL, 0x000fe200078e022eULL, 0x000020002d2d7811ULL, 0x000fe200078e68ffULL,
0x000000012e3a7824ULL, 0x000fe400078e0203ULL, 0x0000000138397824ULL, 0x000fe200078e0a39ULL,
0x000000043b647810ULL, 0x000fe20007ffe0ffULL, 0x000000085e5c7824ULL, 0x000fe200078e00ffULL,
0x000000073a3a7812ULL, 0x000fe200078ec0ffULL, 0x00000100ff387424ULL, 0x000fe200078e00ffULL,
0x000000392e00720cULL, 0x000fc40003f06070ULL, 0x0ffffff83a3a7812ULL, 0x000fca00078ef803ULL,
0x000000103a677824ULL, 0x000fe200078e022dULL, 0x000000042f2f7984ULL, 0x002e640008004800ULL,
0x0000002f0a637224ULL, 0x002fe200078e023bULL, 0xfffffff85c2f7812ULL, 0x000fe400078ee203ULL,
0x000000042e5c7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0063627625ULL, 0x000fc800078e0038ULL,
0x000000015c667824ULL, 0x000fe400078e0203ULL, 0x000000102f627825ULL, 0x000fc800078e0062ULL,
0x000000085c697824ULL, 0x040fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062677faeULL, 0x0003e2000c101c4aULL, 0x000000395c00720cULL, 0x000fe40003f06070ULL,
0x000000082e5c7810ULL, 0x000fe20007ffe0ffULL, 0x018610062e3a7984ULL, 0x000ea20008004800ULL,
0xfffffff869667812ULL, 0x000fc600078ee266ULL, 0x000000085c697824ULL, 0x000fe400078e00ffULL,
0x0000001066677824ULL, 0x002fe200078e022dULL, 0x000000083b627810ULL, 0x000fe20007ffe0ffULL,
0x000000015c667824ULL, 0x000fca00078e0203ULL, 0xfffffff869667812ULL, 0x000fe200078ee266ULL,
0x000000043a657984ULL, 0x004e640008004800ULL, 0x000000650a657224ULL, 0x002fc800078e0264ULL,
0x00005e0065647625ULL, 0x000fcc00078e0038ULL, 0x000000102f647825ULL, 0x000fca00078e0064ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064677faeULL, 0x0003e2000c101c4aULL,
0x000000395c00720cULL, 0x000fe40003f06070ULL, 0x0000000c2e5c7810ULL, 0x000fe20007ffe0ffULL,
0x018620062e3a7984ULL, 0x000ea80008004800ULL, 0x000000085c697824ULL, 0x000fe400078e00ffULL,
0x0000001066677824ULL, 0x002fe200078e022dULL, 0x0000000c3b647810ULL, 0x000fe20007ffe0ffULL,
0x000000015c667824ULL, 0x000fca00078e0203ULL, 0xfffffff869667812ULL, 0x000fe200078ee266ULL,
0x000000043a637984ULL, 0x004e640008004800ULL, 0x000000630a637224ULL, 0x002fc800078e0262ULL,
0x00005e0063627625ULL, 0x000fcc00078e0038ULL, 0x000000102f627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062677faeULL, 0x0003e2000c101c4aULL,
0x000000395c00720cULL, 0x000fe40003f06070ULL, 0x000000102e5c7810ULL, 0x000fe20007ffe0ffULL,
0x018630062e3a7984ULL, 0x000ea80008004800ULL, 0x000000085c697824ULL, 0x000fe400078e00ffULL,
0x0000001066677824ULL, 0x002fe200078e022dULL, 0x000000103b627810ULL, 0x000fe20007ffe0ffULL,
0x000000015c667824ULL, 0x000fca00078e0203ULL, 0xfffffff869667812ULL, 0x000fe200078ee266ULL,
0x000000043a657984ULL, 0x004e640008004800ULL, 0x000000650a657224ULL, 0x002fc800078e0264ULL,
0x00005e0065647625ULL, 0x000fcc00078e0038ULL, 0x000000102f647825ULL, 0x000fca00078e0064ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064677faeULL, 0x0003e2000c101c4aULL,
0x000000395c00720cULL, 0x000fe40003f06070ULL, 0x000000142e5c7810ULL, 0x000fe20007ffe0ffULL,
0x018640062e3a7984ULL, 0x000ea80008004800ULL, 0x000000085c697824ULL, 0x000fe400078e00ffULL,
0x0000001066677824ULL, 0x002fe200078e022dULL, 0x000000143b647810ULL, 0x000fe20007ffe0ffULL,
0x000000015c667824ULL, 0x000fca00078e0203ULL, 0xfffffff869667812ULL, 0x000fe200078ee266ULL,
0x000000043a637984ULL, 0x004e640008004800ULL, 0x000000630a637224ULL, 0x002fc800078e0262ULL,
0x00005e0063627625ULL, 0x000fcc00078e0038ULL, 0x000000102f627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062677faeULL, 0x0003e2000c101c4aULL,
0x000000395c00720cULL, 0x000fe40003f06070ULL, 0x000000182e5c7810ULL, 0x000fe20007ffe0ffULL,
0x018650062e3a7984ULL, 0x000ea80008004800ULL, 0x000000085c697824ULL, 0x000fe400078e00ffULL,
0x0000001066677824ULL, 0x002fe200078e022dULL, 0x000000183b627810ULL, 0x000fe20007ffe0ffULL,
0x000000015c667824ULL, 0x000fca00078e0203ULL, 0xfffffff869667812ULL, 0x000fe200078ee266ULL,
0x000000043a657984ULL, 0x004e640008004800ULL, 0x000000650a657224ULL, 0x002fc800078e0264ULL,
0x00005e0065647625ULL, 0x000fcc00078e0038ULL, 0x000000102f647825ULL, 0x000fca00078e0064ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064677faeULL, 0x0003e2000c101c4aULL,
0x000000395c00720cULL, 0x000fe40003f06070ULL, 0x0000001c2e5c7810ULL, 0x000fe20007ffe0ffULL,
0x018660062e3a7984ULL, 0x000ea80008004800ULL, 0x000000085c697824ULL, 0x000fe400078e00ffULL,
0x0000001066677824ULL, 0x002fe200078e022dULL, 0x0000001c3b647810ULL, 0x000fe20007ffe0ffULL,
0x000000015c667824ULL, 0x000fca00078e0203ULL, 0xfffffff869667812ULL, 0x000fe200078ee266ULL,
0x000000043a637984ULL, 0x004e640008004800ULL, 0x000000630a637224ULL, 0x002fc800078e0262ULL,
0x00005e0063627625ULL, 0x000fcc00078e0038ULL, 0x000000102f627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062677faeULL, 0x0003e2000c101c4aULL,
0x000000395c00720cULL, 0x000fe40003f06070ULL, 0x000000202e5c7810ULL, 0x000fe20007ffe0ffULL,
0x018670062e3a7984ULL, 0x000ea80008004800ULL, 0x000000085c697824ULL, 0x000fe400078e00ffULL,
0x0000001066677824ULL, 0x002fe200078e022dULL, 0x000000203b627810ULL, 0x000fe20007ffe0ffULL,
0x000000015c667824ULL, 0x000fca00078e0203ULL, 0xfffffff869667812ULL, 0x000fe200078ee266ULL,
0x000000043a657984ULL, 0x004e640008004800ULL, 0x000000650a657224ULL, 0x002fc800078e0264ULL,
0x00005e0065647625ULL, 0x000fcc00078e0038ULL, 0x000000102f647825ULL, 0x000fca00078e0064ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064677faeULL, 0x0003e2000c101c4aULL,
0x000000395c00720cULL, 0x000fe40003f06070ULL, 0x000000242e5c7810ULL, 0x000fe20007ffe0ffULL,
0x018680062e3a7984ULL, 0x000ea80008004800ULL, 0x000000085c697824ULL, 0x000fe400078e00ffULL,
0x0000001066677824ULL, 0x002fe200078e022dULL, 0x000000243b647810ULL, 0x000fe20007ffe0ffULL,
0x000000015c667824ULL, 0x000fca00078e0203ULL, 0xfffffff869667812ULL, 0x000fe200078ee266ULL,
0x000000043a637984ULL, 0x004e640008004800ULL, 0x000000630a637224ULL, 0x002fc800078e0262ULL,
0x00005e0063627625ULL, 0x000fcc00078e0038ULL, 0x000000102f627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062677faeULL, 0x0003e2000c101c4aULL,
0x000000395c00720cULL, 0x000fe40003f06070ULL, 0x000000282e5c7810ULL, 0x000fe20007ffe0ffULL,
0x018690062e3a7984ULL, 0x000ea80008004800ULL, 0x000000085c697824ULL, 0x000fe400078e00ffULL,
0x0000001066677824ULL, 0x002fe200078e022dULL, 0x000000283b627810ULL, 0x000fe20007ffe0ffULL,
0x000000015c667824ULL, 0x000fca00078e0203ULL, 0xfffffff869667812ULL, 0x000fe200078ee266ULL,
0x000000043a657984ULL, 0x004e640008004800ULL, 0x000000650a657224ULL, 0x002fc800078e0264ULL,
0x00005e0065647625ULL, 0x000fcc00078e0038ULL, 0x000000102f647825ULL, 0x000fca00078e0064ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064677faeULL, 0x0003e2000c101c4aULL,
0x000000395c00720cULL, 0x000fe40003f06070ULL, 0x0000002c2e5c7810ULL, 0x000fe20007ffe0ffULL,
0x0186a0062e3a7984ULL, 0x000ea80008004800ULL, 0x000000085c697824ULL, 0x000fe400078e00ffULL,
0x0000001066677824ULL, 0x002fe200078e022dULL, 0x0000002c3b647810ULL, 0x000fe20007ffe0ffULL,
0x000000015c667824ULL, 0x000fca00078e0203ULL, 0xfffffff869667812ULL, 0x000fe200078ee266ULL,
0x000000043a637984ULL, 0x004e640008004800ULL, 0x000000630a637224ULL, 0x002fc800078e0262ULL,
0x00005e0063627625ULL, 0x000fcc00078e0038ULL, 0x000000102f627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062677faeULL, 0x0003e2000c101c4aULL,
0x000000395c00720cULL, 0x000fe40003f06070ULL, 0x000000302e5c7810ULL, 0x000fe20007ffe0ffULL,
0x0186b0062e3a7984ULL, 0x000ea80008004800ULL, 0x000000085c697824ULL, 0x000fe400078e00ffULL,
0x0000001066677824ULL, 0x002fe200078e022dULL, 0x000000303b627810ULL, 0x000fe20007ffe0ffULL,
0x000000015c667824ULL, 0x000fca00078e0203ULL, 0xfffffff869667812ULL, 0x000fe200078ee266ULL,
0x000000043a657984ULL, 0x004e640008004800ULL, 0x000000650a657224ULL, 0x002fc800078e0264ULL,
0x00005e0065647625ULL, 0x000fcc00078e0038ULL, 0x000000102f647825ULL, 0x000fca00078e0064ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064677faeULL, 0x0003e2000c101c4aULL,
0x000000395c00720cULL, 0x000fe40003f06070ULL, 0x000000342e5c7810ULL, 0x000fe20007ffe0ffULL,
0x0186c0062e3a7984ULL, 0x000ea80008004800ULL, 0x000000085c697824ULL, 0x000fe400078e00ffULL,
0x0000001066677824ULL, 0x002fe200078e022dULL, 0x000000343b647810ULL, 0x000fe20007ffe0ffULL,
0x000000015c667824ULL, 0x000fca00078e0203ULL, 0xfffffff869667812ULL, 0x000fe200078ee266ULL,
0x000000043a637984ULL, 0x004e640008004800ULL, 0x000000630a637224ULL, 0x002fc800078e0262ULL,
0x00005e0063627625ULL, 0x000fcc00078e0038ULL, 0x000000102f627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062677faeULL, 0x0003e2000c101c4aULL,
0x000000395c00720cULL, 0x000fe40003f06070ULL, 0x000000382e5c7810ULL, 0x000fe20007ffe0ffULL,
0x0186d0062e3a7984ULL, 0x000ea80008004800ULL, 0x000000085c697824ULL, 0x000fe400078e00ffULL,
0x0000001066677824ULL, 0x002fe200078e022dULL, 0x000000383b627810ULL, 0x040fe20007ffe0ffULL,
0x000000015c667824ULL, 0x000fe200078e0203ULL, 0x0000003c3b3b7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff869667812ULL, 0x000fe200078ee266ULL, 0x000000043a657984ULL, 0x004e640008004800ULL,
0x000000650a657224ULL, 0x002fc800078e0264ULL, 0x00005e0065647625ULL, 0x000fcc00078e0038ULL,
0x000000102f647825ULL, 0x000fca00078e0064ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000064677faeULL, 0x0003e2000c101c4aULL, 0x000000395c00720cULL, 0x000fe40003f06070ULL,
0x0000003c2e5c7810ULL, 0x000fe20007ffe0ffULL, 0x0186e0062e3a7984ULL, 0x000ea20008004800ULL,
0x0000001066657824ULL, 0x002fc600078e022dULL, 0x000000015c647824ULL, 0x000fe200078e0203ULL,
0x000000043a637984ULL, 0x004e640008004800ULL, 0x000000630a637224ULL, 0x002fc800078e0262ULL,
0x00005e0063627625ULL, 0x000fcc00078e0038ULL, 0x000000102f627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062657faeULL, 0x0003e2000c101c4aULL,
0x000000395c00720cULL, 0x000fc60003f06070ULL, 0x0186f0062e3a7984ULL, 0x000ea80008004800ULL,
0x000000043a677984ULL, 0x004ea40008004800ULL, 0x000000670a677224ULL, 0x004fe400078e023bULL,
0x000000085c3b7824ULL, 0x000fe400078e00ffULL, 0x00005e0067387625ULL, 0x000fc600078e0038ULL,
0xfffffff83b647812ULL, 0x000fc600078ee264ULL, 0x000000102f387825ULL, 0x000fc800078e0038ULL,
0x00000010642d7824ULL, 0x000fca00078e022dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000382d7faeULL, 0x0003e2000c101c4aULL, 0x00000f6000007947ULL, 0x000fea0003800000ULL,
0x00000003ff2e7819ULL, 0x002fe20000011603ULL, 0x00018a8008047891ULL, 0x000fe2000f8e203fULL,
0x0000000200387824ULL, 0x000fe400078e0209ULL, 0x000000085e647824ULL, 0x000fe200078e00ffULL,
0x018600062e5c7984ULL, 0x000e620008004800ULL, 0x0000004035397824ULL, 0x000fe200078e022eULL,
0x0000200038387811ULL, 0x000fe200078e68ffULL, 0x000000012e2f7824ULL, 0x000fe400078e0203ULL,
0x00000100ff2d7424ULL, 0x000fc600078e00ffULL, 0x000000072f627812ULL, 0x000fe400078ec0ffULL,
0xfffffff8642f7812ULL, 0x100fe400078ee203ULL, 0x0ffffff862637812ULL, 0x100fe400078ef803ULL,
0x000000042e647810ULL, 0x000fe40007ffe0ffULL, 0x0000000439627810ULL, 0x000fe20007ffe0ffULL,
0x0000001063657824ULL, 0x000fe400078e0238ULL, 0x0000000164667824ULL, 0x000fc400078e0203ULL,
0x0000000864677824ULL, 0x000fe200078e00ffULL, 0x000000082e647810ULL, 0x000fc80007ffe0ffULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067677824ULL, 0x000fe200078e0238ULL,
0x000000045c5c7984ULL, 0x002e640008004800ULL, 0x0000005c0a3a7224ULL, 0x002fc800078e0239ULL,
0x00005e003a3a7625ULL, 0x000fcc00078e002dULL, 0x000000102f3a7825ULL, 0x000fca00078e003aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a657faeULL, 0x0003e8000b901c4aULL,
0x018610062e5c7984ULL, 0x000ea20008004800ULL, 0x00000008393a7810ULL, 0x002fe20007ffe0ffULL,
0x0000000164657824ULL, 0x040fe400078e0203ULL, 0x0000000864647824ULL, 0x000fca00078e00ffULL,
0xfffffff864657812ULL, 0x000fe400078ee265ULL, 0x0000000c2e647810ULL, 0x000fc60007ffe0ffULL,
0x0000001065657824ULL, 0x000fe400078e0238ULL, 0x0000000164667824ULL, 0x000fe200078e0203ULL,
0x000000045c637984ULL, 0x004e640008004800ULL, 0x000000630a627224ULL, 0x002fc800078e0262ULL,
0x00005e0062627625ULL, 0x000fcc00078e002dULL, 0x000000102f627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062677faeULL, 0x0003e8000b901c4aULL,
0x018620062e5c7984ULL, 0x000ea20008004800ULL, 0x0000000c39627810ULL, 0x002fe20007ffe0ffULL,
0x0000000864677824ULL, 0x000fe200078e00ffULL, 0x000000102e647810ULL, 0x000fc80007ffe0ffULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067677824ULL, 0x000fe200078e0238ULL,
0x000000045c3b7984ULL, 0x004e640008004800ULL, 0x0000003b0a3a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fcc00078e002dULL, 0x000000102f3a7825ULL, 0x000fca00078e003aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a657faeULL, 0x0003e8000b901c4aULL,
0x018630062e5c7984ULL, 0x000ea20008004800ULL, 0x00000010393a7810ULL, 0x002fe20007ffe0ffULL,
0x0000000164657824ULL, 0x040fe400078e0203ULL, 0x0000000864647824ULL, 0x000fca00078e00ffULL,
0xfffffff864657812ULL, 0x000fe400078ee265ULL, 0x000000142e647810ULL, 0x000fc60007ffe0ffULL,
0x0000001065657824ULL, 0x000fe400078e0238ULL, 0x0000000164667824ULL, 0x000fe200078e0203ULL,
0x000000045c637984ULL, 0x004e640008004800ULL, 0x000000630a627224ULL, 0x002fc800078e0262ULL,
0x00005e0062627625ULL, 0x000fcc00078e002dULL, 0x000000102f627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062677faeULL, 0x0003e8000b901c4aULL,
0x018640062e5c7984ULL, 0x000ea20008004800ULL, 0x0000001439627810ULL, 0x002fe20007ffe0ffULL,
0x0000000864677824ULL, 0x000fe200078e00ffULL, 0x000000182e647810ULL, 0x000fc80007ffe0ffULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067677824ULL, 0x000fe200078e0238ULL,
0x000000045c3b7984ULL, 0x004e640008004800ULL, 0x0000003b0a3a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fcc00078e002dULL, 0x000000102f3a7825ULL, 0x000fca00078e003aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a657faeULL, 0x0003e8000b901c4aULL,
0x018650062e5c7984ULL, 0x000ea20008004800ULL, 0x00000018393a7810ULL, 0x002fe20007ffe0ffULL,
0x0000000164657824ULL, 0x040fe400078e0203ULL, 0x0000000864647824ULL, 0x000fca00078e00ffULL,
0xfffffff864657812ULL, 0x000fe400078ee265ULL, 0x0000001c2e647810ULL, 0x000fc60007ffe0ffULL,
0x0000001065657824ULL, 0x000fe400078e0238ULL, 0x0000000164667824ULL, 0x000fe200078e0203ULL,
0x000000045c637984ULL, 0x004e640008004800ULL, 0x000000630a627224ULL, 0x002fc800078e0262ULL,
0x00005e0062627625ULL, 0x000fcc00078e002dULL, 0x000000102f627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062677faeULL, 0x0003e8000b901c4aULL,
0x018660062e5c7984ULL, 0x000ea20008004800ULL, 0x0000001c39627810ULL, 0x002fe20007ffe0ffULL,
0x0000000864677824ULL, 0x000fe200078e00ffULL, 0x000000202e647810ULL, 0x000fc80007ffe0ffULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067677824ULL, 0x000fe200078e0238ULL,
0x000000045c3b7984ULL, 0x004e640008004800ULL, 0x0000003b0a3a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fcc00078e002dULL, 0x000000102f3a7825ULL, 0x000fca00078e003aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a657faeULL, 0x0003e8000b901c4aULL,
0x018670062e5c7984ULL, 0x000ea20008004800ULL, 0x00000020393a7810ULL, 0x002fe20007ffe0ffULL,
0x0000000164657824ULL, 0x040fe400078e0203ULL, 0x0000000864647824ULL, 0x000fca00078e00ffULL,
0xfffffff864657812ULL, 0x000fe400078ee265ULL, 0x000000242e647810ULL, 0x000fc60007ffe0ffULL,
0x0000001065657824ULL, 0x000fe400078e0238ULL, 0x0000000164667824ULL, 0x000fe200078e0203ULL,
0x000000045c637984ULL, 0x004e640008004800ULL, 0x000000630a627224ULL, 0x002fc800078e0262ULL,
0x00005e0062627625ULL, 0x000fcc00078e002dULL, 0x000000102f627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062677faeULL, 0x0003e8000b901c4aULL,
0x018680062e5c7984ULL, 0x000ea20008004800ULL, 0x0000002439627810ULL, 0x002fe20007ffe0ffULL,
0x0000000864677824ULL, 0x000fe200078e00ffULL, 0x000000282e647810ULL, 0x000fc80007ffe0ffULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067677824ULL, 0x000fe200078e0238ULL,
0x000000045c3b7984ULL, 0x004e640008004800ULL, 0x0000003b0a3a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fcc00078e002dULL, 0x000000102f3a7825ULL, 0x000fca00078e003aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a657faeULL, 0x0003e8000b901c4aULL,
0x018690062e5c7984ULL, 0x000ea20008004800ULL, 0x00000028393a7810ULL, 0x002fe20007ffe0ffULL,
0x0000000164657824ULL, 0x040fe400078e0203ULL, 0x0000000864647824ULL, 0x000fca00078e00ffULL,
0xfffffff864657812ULL, 0x000fe400078ee265ULL, 0x0000002c2e647810ULL, 0x000fc60007ffe0ffULL,
0x0000001065657824ULL, 0x000fe400078e0238ULL, 0x0000000164667824ULL, 0x000fe200078e0203ULL,
0x000000045c637984ULL, 0x004e640008004800ULL, 0x000000630a627224ULL, 0x002fc800078e0262ULL,
0x00005e0062627625ULL, 0x000fcc00078e002dULL, 0x000000102f627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062677faeULL, 0x0003e8000b901c4aULL,
0x0186a0062e5c7984ULL, 0x000ea20008004800ULL, 0x0000002c39627810ULL, 0x002fe20007ffe0ffULL,
0x0000000864677824ULL, 0x000fe200078e00ffULL, 0x000000302e647810ULL, 0x000fc80007ffe0ffULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067677824ULL, 0x000fe200078e0238ULL,
0x000000045c3b7984ULL, 0x004e640008004800ULL, 0x0000003b0a3a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fcc00078e002dULL, 0x000000102f3a7825ULL, 0x000fca00078e003aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a657faeULL, 0x0003e8000b901c4aULL,
0x0186b0062e5c7984ULL, 0x000ea20008004800ULL, 0x00000030393a7810ULL, 0x002fe20007ffe0ffULL,
0x0000000164657824ULL, 0x040fe400078e0203ULL, 0x0000000864647824ULL, 0x000fca00078e00ffULL,
0xfffffff864657812ULL, 0x000fe400078ee265ULL, 0x000000342e647810ULL, 0x000fc60007ffe0ffULL,
0x0000001065657824ULL, 0x000fe400078e0238ULL, 0x0000000164667824ULL, 0x000fe200078e0203ULL,
0x000000045c637984ULL, 0x004e640008004800ULL, 0x000000630a627224ULL, 0x002fc800078e0262ULL,
0x00005e0062627625ULL, 0x000fcc00078e002dULL, 0x000000102f627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062677faeULL, 0x0003e8000b901c4aULL,
0x0186c0062e5c7984ULL, 0x000ea20008004800ULL, 0x0000003439627810ULL, 0x002fe20007ffe0ffULL,
0x0000000864677824ULL, 0x000fe200078e00ffULL, 0x000000382e647810ULL, 0x000fc80007ffe0ffULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067677824ULL, 0x000fe200078e0238ULL,
0x000000045c3b7984ULL, 0x004e640008004800ULL, 0x0000003b0a3a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fcc00078e002dULL, 0x000000102f3a7825ULL, 0x000fca00078e003aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a657faeULL, 0x0003e8000b901c4aULL,
0x0186d0062e5c7984ULL, 0x000ea20008004800ULL, 0x00000038393a7810ULL, 0x002fe20007ffe0ffULL,
0x0000000164657824ULL, 0x040fe400078e0203ULL, 0x0000000864647824ULL, 0x000fca00078e00ffULL,
0xfffffff864657812ULL, 0x000fe400078ee265ULL, 0x0000003c2e647810ULL, 0x000fc60007ffe0ffULL,
0x0000001065657824ULL, 0x000fe200078e0238ULL, 0x000000045c637984ULL, 0x004e640008004800ULL,
0x000000630a627224ULL, 0x002fc800078e0262ULL, 0x00005e0062627625ULL, 0x000fcc00078e002dULL,
0x000000102f627825ULL, 0x000fca00078e0062ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062677faeULL, 0x0003e8000b901c4aULL, 0x0186e0062e5c7984ULL, 0x000ea20008004800ULL,
0x0000003c39627810ULL, 0x002fe20007ffe0ffULL, 0x0000000164397824ULL, 0x040fe400078e0203ULL,
0x0000000864647824ULL, 0x000fca00078e00ffULL, 0xfffffff864397812ULL, 0x000fca00078ee239ULL,
0x0000001039397824ULL, 0x000fe200078e0238ULL, 0x000000045c3b7984ULL, 0x004e640008004800ULL,
0x0000003b0a3a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fcc00078e002dULL,
0x000000102f3a7825ULL, 0x000fca00078e003aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a657faeULL, 0x0003e8000b901c4aULL, 0x0186f0062e5c7984ULL, 0x000ea80008004800ULL,
0x000000045c637984ULL, 0x004ea40008004800ULL, 0x000000630a627224ULL, 0x004fc800078e0262ULL,
0x00005e0062627625ULL, 0x000fcc00078e002dULL, 0x000000102f627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062397faeULL, 0x0003e4000b901c4aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0xffffffffff2d7424ULL, 0x002fe200078e00ffULL, 0x00024af0002e7802ULL, 0x000fc40000000f00ULL,
0x0000571000007944ULL, 0x000fea0003c00000ULL, 0x000000ff5e00720cULL, 0x000fe20003f05270ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000031000007945ULL, 0x000fec0003800000ULL,
0x000002f000008947ULL, 0x000fea0003800000ULL, 0x000000012c2d7810ULL, 0x002fe20007ffe0ffULL,
0x00000004ff397424ULL, 0x000fe200078e00ffULL, 0x000000153400720cULL, 0x000fe20003f04070ULL,
0x0000026000017945ULL, 0x000fe20003800000ULL, 0x00000002ff2e7819ULL, 0x000fc4000001162dULL,
0x000000032d2d7812ULL, 0x000fe400078ec0ffULL, 0x000000012e2e7807ULL, 0x000fe40004000000ULL,
0x000000ff2d2d7207ULL, 0x000fe40004000000ULL, 0x00000020033b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001152e7824ULL, 0x000fe200078e022eULL, 0x000000153400720cULL, 0x000fe40003f04070ULL,
0x000000032c00780cULL, 0x000fc40003f85270ULL, 0x000000052e2e7c11ULL, 0x000fe4000f8e40ffULL,
0x0000000c2d2d7c10ULL, 0x000fc6000fffe0ffULL, 0x000000013b2f7824ULL, 0x100fe400078e022eULL,
0x000000012e157824ULL, 0x100fe400078e0203ULL, 0x000068002d2e7a24ULL, 0x000fe200078e022eULL,
0x000000602f00720cULL, 0x080fe40003f66070ULL, 0x000000601500720cULL, 0x000fe20003f26070ULL,
0x000000012e2f7824ULL, 0x000fe400078e0203ULL, 0x000000013b387824ULL, 0x000fe200078e022eULL,
0x00000006033b7c11ULL, 0x000fe2000f8e10ffULL, 0x000066002f2e7625ULL, 0x000fc800078e0039ULL,
0x0000660038387625ULL, 0x000fe200078e0039ULL, 0x0000010000008947ULL, 0x000fea0002000000ULL,
0x000000030300780cULL, 0x000fe40003f04070ULL, 0x0000000408087810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000002c7919ULL, 0x000e620000002700ULL,
0x000000370800720cULL, 0x000fe20003f06070ULL, 0x00000004003a7824ULL, 0x100fe400078e0203ULL,
0x00000004ff2d7424ULL, 0x000fe400078e00ffULL, 0x000000042c157824ULL, 0x002fc800078e0203ULL,
0x0000000215157824ULL, 0x000fc800078e00ffULL, 0x00006400152c7a24ULL, 0x000fe200078e0208ULL,
0x00018a803a157811ULL, 0x000fc600078e10ffULL, 0x000060002c2c7625ULL, 0x000fca00078e002dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c157faeULL, 0x0003e4000c12184aULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x186000002e3b7faeULL, 0x0005e8000c92184aULL, 0x18680000383b7faeULL, 0x0005e4000d92184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff157224ULL, 0x002fc600078e00ffULL, 0xfffffff8032c7812ULL, 0x000fe200078ec0ffULL,
0x00000002006e7824ULL, 0x000fe200078e020fULL, 0x0000000115737810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000072c2c7812ULL, 0x000fe400078ef803ULL,
0x000020006e6e7811ULL, 0x000fc400078e68ffULL, 0x0000002003647810ULL, 0x000fe20007ffe0ffULL,
0x000000012c2d7824ULL, 0x040fe400078e0215ULL, 0x000000082c2e7824ULL, 0x004fe200078e00ffULL,
0xfffffff864647812ULL, 0x000fc800078ec0ffULL, 0xfffffff82e2d7812ULL, 0x000fe400078ee22dULL,
0x0000000764707812ULL, 0x000fc600078ef803ULL, 0x000000102d387824ULL, 0x020fe400078e026eULL,
0x000000082c2d7824ULL, 0x040fe400078e00ffULL, 0x000000012c2c7824ULL, 0x000fe400078e0273ULL,
0x000000003838783bULL, 0x000e620000000200ULL, 0x0000000170637824ULL, 0x040fe400078e0215ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee22cULL, 0x0000000870647824ULL, 0x000fc400078e00ffULL,
0x0000000170737824ULL, 0x000fe400078e0273ULL, 0x000000102d2d7824ULL, 0x000fe200078e026eULL,
0xfffffff864637812ULL, 0x000fe200078ee263ULL, 0x0000000870707824ULL, 0x000fc800078e00ffULL,
0x000000002d2c783bULL, 0x000ea20000000200ULL, 0x0000001063647824ULL, 0x000fe200078e026eULL,
0xfffffff870737812ULL, 0x000fe400078ee273ULL, 0x00000018ff657819ULL, 0x002fe20000011438ULL,
0x0000003800f77306ULL, 0x000fe20000009400ULL, 0x00000018ff687819ULL, 0x000fe40000011439ULL,
0x00000018ff697819ULL, 0x000fe4000001143aULL, 0x00000018ff6a7819ULL, 0x000fc6000001143bULL,
0x00000065008e7306ULL, 0x000fe20000209400ULL, 0x00000018ff6f7819ULL, 0x004fe2000001142dULL,
0x000100002d707824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fca000001142eULL,
0x0000006500f37306ULL, 0x000e620000205400ULL, 0x00000018ff6b7819ULL, 0x000fe4000001142cULL,
0x00000018ff727819ULL, 0x000fe4000001142fULL, 0x00000018ff707819ULL, 0x000fc60000011470ULL,
0x0000006500917306ULL, 0x0004f0000020d400ULL, 0x0000006800887306ULL, 0x000fe20000209400ULL,
0x000000006464783bULL, 0x004ea20000000200ULL, 0x000000f38e00720bULL, 0x002fcc0003f9d000ULL,
0x0000006800897306ULL, 0x000fee0000205400ULL, 0x0000000191914812ULL, 0x008fe200078efcffULL,
0x0000006800b27306ULL, 0x000ff0000020d400ULL, 0x0000006f00b87306ULL, 0x000ff00000209400ULL,
0x0000006f00b77306ULL, 0x000ff00000205400ULL, 0x0000006f00687306ULL, 0x0003f0000020d400ULL,
0x00000038009e7306ULL, 0x000ee20000005400ULL, 0x00010000386f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000003800907306ULL, 0x000330000000d400ULL,
0x0000006900847306ULL, 0x000fe20000209400ULL, 0x0000010038387824ULL, 0x002fe200078e00ffULL,
0x0000009ef700720bULL, 0x008fc80003f1d000ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000006900db7306ULL, 0x000e6e0000205400ULL, 0x0000000190900812ULL, 0x010fe200078efcffULL,
0x0000006900aa7306ULL, 0x000ee2000020d400ULL, 0x000000898800720bULL, 0x000fce0003f1d000ULL,
0x00000071009f7306ULL, 0x000fe20000209400ULL, 0x000000db8400720bULL, 0x002fe20003f9d000ULL,
0x0001000067db7824ULL, 0x004fc800078e00ffULL, 0x00000001b2b20812ULL, 0x000fe400078efcffULL,
0x00000071009c7306ULL, 0x000fec0000205400ULL, 0x00000001aaaa4812ULL, 0x008fe400078efcffULL,
0x0000007100697306ULL, 0x0003f0000020d400ULL, 0x0000003900f07306ULL, 0x000fe20000009400ULL,
0x0001000039717824ULL, 0x002fca00078e00ffULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x0000003900f57306ULL, 0x000e700000005400ULL, 0x0000003900b47306ULL, 0x0004f0000000d400ULL,
0x0000003800a17306ULL, 0x000fe20000209400ULL, 0x0000010039397824ULL, 0x004fe200078e00ffULL,
0x000000f5f000720bULL, 0x002fc80003fdd000ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003800f27306ULL, 0x000e6e0000205400ULL, 0x00000001b4b46812ULL, 0x008fe200078efcffULL,
0x0000003800c47306ULL, 0x0004f0000020d400ULL, 0x0000006f00f47306ULL, 0x000fe20000209400ULL,
0x000100003b387824ULL, 0x004fe200078e00ffULL, 0x000000f2a100720bULL, 0x002fc80003f7d000ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000006f00ad7306ULL, 0x000e6e0000205400ULL,
0x00000001c4c43812ULL, 0x008fe200078efcffULL, 0x0000006f00c77306ULL, 0x0004e6000020d400ULL,
0x000000c49191723eULL, 0x000fca00000010ffULL, 0x0000003a008f7306ULL, 0x000fe20000009400ULL,
0x000100003a6f7824ULL, 0x004fe200078e00ffULL, 0x000000adf400720bULL, 0x002fc80003f3d000ULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000003a00ee7306ULL, 0x000e6e0000005400ULL,
0x00000001c7c71812ULL, 0x008fe200078efcffULL, 0x0000003a00ae7306ULL, 0x0004e6000000d400ULL,
0x00000090c790723eULL, 0x000fca00000010ffULL, 0x0000003b00e47306ULL, 0x000fe20000009400ULL,
0x000001003a3a7824ULL, 0x004fe200078e00ffULL, 0x000000ee8f00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000003b00e97306ULL, 0x000e6e0000005400ULL,
0x00000001aeae5812ULL, 0x008fe200078efcffULL, 0x0000003b00a67306ULL, 0x0004f0000000d400ULL,
0x0000003900947306ULL, 0x000fe20000209400ULL, 0x000001003b3b7824ULL, 0x004fe200078e00ffULL,
0x000000e9e400720bULL, 0x002fc40003f3d000ULL, 0x00000018ffe47819ULL, 0x000fe400000114dbULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000003900e17306ULL, 0x000fee0000205400ULL,
0x00000001a6a61812ULL, 0x008fe200078efcffULL, 0x0000003900b97306ULL, 0x0003f0000020d400ULL,
0x0000003800a07306ULL, 0x000fe20000209400ULL, 0x00000018ff397819ULL, 0x002fce0000011464ULL,
0x0000003800dd7306ULL, 0x000ff00000205400ULL, 0x0000003800ab7306ULL, 0x0003f0000020d400ULL,
0x0000003a00e07306ULL, 0x000fe20000209400ULL, 0x00000018ff387819ULL, 0x002fce0000011466ULL,
0x0000003a00e57306ULL, 0x000e700000205400ULL, 0x0000003a00b17306ULL, 0x0004f0000020d400ULL,
0x0000003b00dc7306ULL, 0x000fe20000209400ULL, 0x00000018ff3a7819ULL, 0x004fc40000011465ULL,
0x000000e5e000720bULL, 0x002fe20003f1d000ULL, 0x0000000810e07824ULL, 0x000fe200078e0215ULL,
0x0000000215157810ULL, 0x000fc60007ffe0ffULL, 0x0000003b00df7306ULL, 0x000e620000205400ULL,
0x00000002e0e07824ULL, 0x000fce00078e00ffULL, 0x0000003b00a97306ULL, 0x000522000020d400ULL,
0x00000001b1b10812ULL, 0x008fce00078efcffULL, 0x0000003900d87306ULL, 0x000fe20000209400ULL,
0x00000018ff3b7819ULL, 0x004fe40000011467ULL, 0x000000dfdc00720bULL, 0x002fca0003fbd000ULL,
0x0000003900d77306ULL, 0x000e700000205400ULL, 0x0000003900937306ULL, 0x0004e2000020d400ULL,
0x00000001a9a95812ULL, 0x010fce00078efcffULL, 0x0000003800cb7306ULL, 0x000fe20000209400ULL,
0x000100002c397824ULL, 0x004fe200078e00ffULL, 0x000000d7d800720bULL, 0x002fcc0003f3d000ULL,
0x0000003800c87306ULL, 0x000fee0000205400ULL, 0x0000000193931812ULL, 0x008fe200078efcffULL,
0x0000003800867306ULL, 0x0003f0000020d400ULL, 0x0000006f00de7306ULL, 0x000fe20000209400ULL,
0x0000001073387824ULL, 0x002fce00078e026eULL, 0x0000006f00e37306ULL, 0x000e700000205400ULL,
0x0000006f00b37306ULL, 0x0004f0000020d400ULL, 0x0000003a00d57306ULL, 0x000fe20000209400ULL,
0x00000018ff6f7819ULL, 0x004fc40000011439ULL, 0x000000e3de00720bULL, 0x002fca0003fdd000ULL,
0x0000003a00d67306ULL, 0x000ff00000205400ULL, 0x0000003a008b7306ULL, 0x000fe2000020d400ULL,
0x00000001b3b36812ULL, 0x008fe400078efcffULL, 0x000000dda000720bULL, 0x000fc40003fdd000ULL,
0x0000000703a07812ULL, 0x000fc600078ec0ffULL, 0x0000003b00cc7306ULL, 0x000ff00000209400ULL,
0x0000003b00cf7306ULL, 0x000fe20000205400ULL, 0x00000001abab6812ULL, 0x000fce00078efcffULL,
0x0000003b007d7306ULL, 0x0003f0000020d400ULL, 0x0000002c00ba7306ULL, 0x000fe20000009400ULL,
0x000000003838783bULL, 0x002e6e0000000200ULL, 0x0000002c00bb7306ULL, 0x000ff00000005400ULL,
0x0000002c006d7306ULL, 0x0005f0000000d400ULL, 0x0000006a00a37306ULL, 0x000fe20000209400ULL,
0x000001002c2c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000006a008a7306ULL, 0x000ff00000205400ULL, 0x0000006a00a47306ULL, 0x000fe2000020d400ULL,
0x00000018ff7b7819ULL, 0x002fc40000011438ULL, 0x00000018ff7e7819ULL, 0x000fe40000011439ULL,
0x00000018ff817819ULL, 0x000fc6000001143aULL, 0x0000006b00c27306ULL, 0x000ff00000209400ULL,
0x0000006b00c37306ULL, 0x000ff00000205400ULL, 0x0000006b00637306ULL, 0x000ff0000020d400ULL,
0x00000072006a7306ULL, 0x000ff00000209400ULL, 0x00000072006b7306ULL, 0x000ff00000205400ULL,
0x00000072006c7306ULL, 0x0003f0000020d400ULL, 0x0000002d00bc7306ULL, 0x000fe20000009400ULL,
0x000100002e727824ULL, 0x002fce00078e00ffULL, 0x0000002d00bd7306ULL, 0x000ff00000005400ULL,
0x0000002d005c7306ULL, 0x0003f0000000d400ULL, 0x0000002c00d17306ULL, 0x000fe20000209400ULL,
0x000001002d2d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002c00ce7306ULL, 0x000ff00000205400ULL, 0x0000002c006e7306ULL, 0x0003f0000020d400ULL,
0x0000002e00be7306ULL, 0x000fe20000009400ULL, 0x00000018ff2c7819ULL, 0x002fce0000011472ULL,
0x0000002e00bf7306ULL, 0x000ff00000005400ULL, 0x0000002e005e7306ULL, 0x0003f0000000d400ULL,
0x0000002c00af7306ULL, 0x000fe20000209400ULL, 0x000001002e2e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000002c00b07306ULL, 0x000ff00000205400ULL,
0x0000002c00737306ULL, 0x0003f0000020d400ULL, 0x0000007100e27306ULL, 0x000fe20000209400ULL,
0x000100002f2c7824ULL, 0x002fce00078e00ffULL, 0x0000007100e77306ULL, 0x000e700000205400ULL,
0x0000007100c57306ULL, 0x000eb0000020d400ULL, 0x0000002d00b67306ULL, 0x000fe20000209400ULL,
0x000000e7e200720bULL, 0x002fce0003f7d000ULL, 0x0000002d00b57306ULL, 0x000fec0000205400ULL,
0x00000001c5c53812ULL, 0x004fe400078efcffULL, 0x0000002d00717306ULL, 0x0003e2000020d400ULL,
0x000000e19400720bULL, 0x000fce0003f7d000ULL, 0x0000006f00ca7306ULL, 0x000fe20000209400ULL,
0x00000018ff2d7819ULL, 0x002fe2000001142cULL, 0x00010000642c7824ULL, 0x000fc800078e00ffULL,
0x00000001b9b93812ULL, 0x000fe400078efcffULL, 0x0000006f00cd7306ULL, 0x000fe20000205400ULL,
0x00000018ff8d7819ULL, 0x000fe2000001142cULL, 0x00010000652c7824ULL, 0x000fe200078e00ffULL,
0x0000008aa300720bULL, 0x000fca0003f7d000ULL, 0x0000006f00807306ULL, 0x000ff0000020d400ULL,
0x0000007000c97306ULL, 0x000fe20000209400ULL, 0x00000001a4a43812ULL, 0x000fce00078efcffULL,
0x0000007000c67306ULL, 0x000ff00000205400ULL, 0x00000070006f7306ULL, 0x000ff0000020d400ULL,
0x0000002f00c07306ULL, 0x000ff00000009400ULL, 0x0000002f00c17306ULL, 0x000ff00000005400ULL,
0x0000002f00627306ULL, 0x0003f0000000d400ULL, 0x0000002e00a77306ULL, 0x000fe20000209400ULL,
0x000001002f2f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff957819ULL, 0x000fe4000001142fULL,
0x0000002e00a87306ULL, 0x000ff00000205400ULL, 0x0000002e00707306ULL, 0x0003f0000020d400ULL,
0x0000006400d37306ULL, 0x000fe20000009400ULL, 0x00000018ff2e7819ULL, 0x002fce000001143bULL,
0x0000006400d47306ULL, 0x000e700000005400ULL, 0x0000006400927306ULL, 0x0004f0000000d400ULL,
0x0000007b00967306ULL, 0x000fe20000209400ULL, 0x0000010064647824ULL, 0x004fe200078e00ffULL,
0x000000d4d300720bULL, 0x002fc80003f1d000ULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x0000007b00977306ULL, 0x000fee0000205400ULL, 0x0000000192920812ULL, 0x008fe200078efcffULL,
0x0000007b00727306ULL, 0x000fe2000020d400ULL, 0x000000d6d500720bULL, 0x000fce0003f1d000ULL,
0x0000002e007a7306ULL, 0x000fec0000209400ULL, 0x000000018b8b0812ULL, 0x000fe400078efcffULL,
0x0000002e007b7306ULL, 0x000ff00000205400ULL, 0x0000002e007c7306ULL, 0x000ff0000020d400ULL,
0x0000008d002e7306ULL, 0x000ff00000209400ULL, 0x0000008d002f7306ULL, 0x000e700000205400ULL,
0x0000008d00a57306ULL, 0x0004f0000020d400ULL, 0x0000006400e67306ULL, 0x000fe20000209400ULL,
0x00010000668d7824ULL, 0x004fe200078e00ffULL, 0x0000002f2e00720bULL, 0x002fcc0003f9d000ULL,
0x0000006400eb7306ULL, 0x000e6e0000205400ULL, 0x00000001a5a54812ULL, 0x008fe200078efcffULL,
0x0000006400a27306ULL, 0x0004e6000020d400ULL, 0x00000092a592723eULL, 0x000fca00000010ffULL,
0x0000006700d97306ULL, 0x000fe20000009400ULL, 0x00000018ff647819ULL, 0x004fe2000001148dULL,
0x00000100668d7824ULL, 0x000fe200078e00ffULL, 0x000000ebe600720bULL, 0x002fc80003fdd000ULL,
0x00000018fff67819ULL, 0x000fe2000001148dULL, 0x0000006700da7306ULL, 0x000e700000005400ULL,
0x00000067008d7306ULL, 0x000522000000d400ULL, 0x00000001a2a26812ULL, 0x008fc800078efcffULL,
0x000000a29393723eULL, 0x000fc600000010ffULL, 0x0000007e00747306ULL, 0x000fe20000209400ULL,
0x0000010067677824ULL, 0x004fe200078e00ffULL, 0x000000dad900720bULL, 0x002fc80003f1d000ULL,
0x00000018ffe37819ULL, 0x000fe20000011467ULL, 0x0001000038677824ULL, 0x000fe200078e00ffULL,
0x0000007e00757306ULL, 0x000fe80000205400ULL, 0x00000018ffdd7819ULL, 0x000fe40000011467ULL,
0x000000e003677211ULL, 0x000fe400078fe0ffULL, 0x0000007e00767306ULL, 0x000fe2000020d400ULL,
0x00000002e0e07810ULL, 0x000fc40007ffe0ffULL, 0x000000018d8d0812ULL, 0x010fe400078efcffULL,
0x000000e003e07211ULL, 0x000fe400078fe0ffULL, 0x000000ced100720bULL, 0x000fe20003f1d000ULL,
0x0000008100777306ULL, 0x000ff00000209400ULL, 0x0000008100787306ULL, 0x000fe80000205400ULL,
0x000000016e6e0812ULL, 0x000fc400078efcffULL, 0x000000c6c900720bULL, 0x000fe40003f1d000ULL,
0x0000008100797306ULL, 0x000ff0000020d400ULL, 0x00000095007e7306ULL, 0x000fe60000209400ULL,
0x000000016f6f0812ULL, 0x000fc400078efcffULL, 0x000000b0af00720bULL, 0x000fc60003f1d000ULL,
0x0000009500817306ULL, 0x000ff00000205400ULL, 0x0000009500837306ULL, 0x0003e4000020d400ULL,
0x0000000173730812ULL, 0x000fcc00078efcffULL, 0x0000002d00827306ULL, 0x000fe20000209400ULL,
0x00000018ff957819ULL, 0x002fce000001142cULL, 0x0000002d00857306ULL, 0x000ff00000205400ULL,
0x0000002d007f7306ULL, 0x000ff0000020d400ULL, 0x00000065009b7306ULL, 0x000ff00000009400ULL,
0x0000006500d27306ULL, 0x000e700000005400ULL, 0x00000065008c7306ULL, 0x0004f0000000d400ULL,
0x00000095002c7306ULL, 0x000fe20000209400ULL, 0x0000010065657824ULL, 0x004fe200078e00ffULL,
0x000000d29b00720bULL, 0x002fc80003fbd000ULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000095002d7306ULL, 0x000e6e0000205400ULL, 0x000000018c8c5812ULL, 0x008fe200078efcffULL,
0x000000e400db7306ULL, 0x000fe20000209400ULL, 0x000000c8cb00720bULL, 0x000fce0003fbd000ULL,
0x000000e400e27306ULL, 0x000fe20000205400ULL, 0x0000002d2c00720bULL, 0x002fe20003f9d000ULL,
0x00010000392d7824ULL, 0x000fc800078e00ffULL, 0x0000000186865812ULL, 0x000fe400078efcffULL,
0x000000e400947306ULL, 0x0003e2000020d400ULL, 0x00000018ffd27819ULL, 0x000fe4000001142dULL,
0x000000cdca00720bULL, 0x000fca0003fbd000ULL, 0x0000006500e87306ULL, 0x000fe20000209400ULL,
0x00000008a0e47812ULL, 0x002fca00078ef803ULL, 0x00000020e4dc7824ULL, 0x040fe400078e00ffULL,
0x00000001e4677824ULL, 0x040fe200078e0267ULL, 0x0000006500ed7306ULL, 0x000e620000205400ULL,
0x00000001e4e07824ULL, 0x000fe200078e02e0ULL, 0x0000000180805812ULL, 0x000fe200078efcffULL,
0x00000020e4d37824ULL, 0x000fe200078e00ffULL, 0xffffffe0dcdc7812ULL, 0x000fe400078ee267ULL,
0x000000c1c000720bULL, 0x000fe40003fbd000ULL, 0x00000095009d7306ULL, 0x000ea2000020d400ULL,
0x00000010dc2c7824ULL, 0x000fe200078e00ffULL, 0xffffffe0d3e07812ULL, 0x000fca00078ee2e0ULL,
0x000000002c2c783bULL, 0x000ee20000000200ULL, 0x0000006600d07306ULL, 0x000fe20000009400ULL,
0x000000ede800720bULL, 0x002fe40003fdd000ULL, 0x0000000162625812ULL, 0x000fe400078efcffULL,
0x000000757400720bULL, 0x000fc60003fbd000ULL, 0x0000006600877306ULL, 0x000e620000005400ULL,
0x000000019d9d4812ULL, 0x004fce00078efcffULL, 0x000000f600ec7306ULL, 0x000fe40000209400ULL,
0x0000000176765812ULL, 0x000fcc00078efcffULL, 0x000000f600f17306ULL, 0x000ea20000205400ULL,
0x00000087d000720bULL, 0x002fce0003f7d000ULL, 0x00000065009a7306ULL, 0x000e62000020d400ULL,
0x000000902c54723cULL, 0x008bee0000041854ULL, 0x0000006600987306ULL, 0x000ee2000000d400ULL,
0x000000f1ec00720bULL, 0x004fe40003f9d000ULL, 0x000000aeb390723eULL, 0x020fe200000010ffULL,
0x000001003aae7824ULL, 0x000fc800078e00ffULL, 0x000000f600957306ULL, 0x000ea2000020d400ULL,
0x000000019a9a6812ULL, 0x002fe200078efcffULL, 0x000001003bb37824ULL, 0x000fe200078e00ffULL,
0x000000e2db00720bULL, 0x000fe20003fdd000ULL, 0x000000922c44723cULL, 0x040be20000041844ULL,
0x000000b1aa91723eULL, 0x000fe200000010ffULL, 0x000100003bb17824ULL, 0x000fe200078e00ffULL,
0x00000018ffb37819ULL, 0x000fe200000114b3ULL, 0x0000006400ea7306ULL, 0x000fe20000209400ULL,
0x0000000198983812ULL, 0x008fe400078efcffULL, 0x000000bbba00720bULL, 0x000fe20003f7d000ULL,
0x000000902c4c723cULL, 0x000be2000004184cULL, 0x00000018ffae7819ULL, 0x000fc400000114aeULL,
0x00000018ffb17819ULL, 0x000fe200000114b1ULL, 0x0000006400ef7306ULL, 0x000e620000205400ULL,
0x0000000195954812ULL, 0x004fe400078efcffULL, 0x000000cfcc00720bULL, 0x000fe40003f9d000ULL,
0x0000000194946812ULL, 0x000fe400078efcffULL, 0x000000bdbc00720bULL, 0x000fe20003fdd000ULL,
0x0000006400997306ULL, 0x000ea2000020d400ULL, 0x000000016d6d3812ULL, 0x000fc400078efcffULL,
0x000000b7b800720bULL, 0x000fe40003f7d000ULL, 0x000000958693723eULL, 0x020fe400000010ffULL,
0x0000008c9d90723eULL, 0x000fe200000010ffULL, 0x0000003800ac7306ULL, 0x000fe20000009400ULL,
0x000000efea00720bULL, 0x002fe40003f3d000ULL, 0x000000017d7d4812ULL, 0x000fe400078efcffULL,
0x000000c3c200720bULL, 0x000fc40003f9d000ULL, 0x0000009a8b91723eULL, 0x000fe200000010ffULL,
0x0000003800ad7306ULL, 0x000e620000005400ULL, 0x0000000168683812ULL, 0x000fe400078efcffULL,
0x000000a8a700720bULL, 0x000fe40003f7d000ULL, 0x0000008d9494723eULL, 0x000fe200000010ffULL,
0x000000902c40723cULL, 0x000fe20000041840ULL, 0x0000000199991812ULL, 0x004fe200078efcffULL,
0x0000003800647306ULL, 0x0005e2000000d400ULL, 0x000000015c5c6812ULL, 0x000fc400078efcffULL,
0x0000000163634812ULL, 0x000fe400078efcffULL, 0x000000b5b600720bULL, 0x000fe40003f9d000ULL,
0x000000989992723eULL, 0x000fe200000010ffULL, 0x000000e300de7306ULL, 0x000fe20000209400ULL,
0x0000010038387824ULL, 0x004fe200078e00ffULL, 0x0000000170703812ULL, 0x000fe400078efcffULL,
0x000000979600720bULL, 0x000fe40003f7d000ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x000000922c3c723cULL, 0x000fe2000004183cULL, 0x000000e300e17306ULL, 0x000ea20000205400ULL,
0x0000009c9f00720bULL, 0x000fc40003fdd000ULL, 0x0000000171714812ULL, 0x000fe400078efcffULL,
0x000000adac00720bULL, 0x002fc60003f9d000ULL, 0x00000039009e7306ULL, 0x000fe20000009400ULL,
0x0000000172723812ULL, 0x000fe400078efcffULL, 0x000000858200720bULL, 0x000fc60003f7d000ULL,
0x0000000169696812ULL, 0x000fe400078efcffULL, 0x0000003900a17306ULL, 0x000fe20000005400ULL,
0x000000e1de00720bULL, 0x004fe40003f3d000ULL, 0x0000000164644812ULL, 0x000fe400078efcffULL,
0x000000706969723eULL, 0x000fc600000010ffULL, 0x0000003900657306ULL, 0x0003e2000000d400ULL,
0x000000017f7f3812ULL, 0x000fc800078efcffULL, 0x000000627f62723eULL, 0x000fc600000010ffULL,
0x00000038009b7306ULL, 0x000fe20000209400ULL, 0x0000010039397824ULL, 0x002fca00078e00ffULL,
0x00000018ffbc7819ULL, 0x000fe40000011439ULL, 0x0000003800d07306ULL, 0x000e620000205400ULL,
0x000000b9b239723eULL, 0x000fe200000010ffULL, 0x000100003ab27824ULL, 0x000fca00078e00ffULL,
0x00000018ffb27819ULL, 0x000fe200000114b2ULL, 0x0000003800877306ULL, 0x0005f0000020d400ULL,
0x000000e3008a7306ULL, 0x000ee2000020d400ULL, 0x000000b4c538723eULL, 0x004fc400000010ffULL,
0x000000d09b00720bULL, 0x002fca0003fdd000ULL, 0x000000382c50723cULL, 0x000b620000041850ULL,
0x0000003a008e7306ULL, 0x000fec0000009400ULL, 0x000000a6ab38723eULL, 0x020fe400000010ffULL,
0x000000a9a439723eULL, 0x000fe200000010ffULL, 0x0000003a008f7306ULL, 0x000fe20000005400ULL,
0x000000018a8a1812ULL, 0x008fc400078efcffULL, 0x000000bfbe00720bULL, 0x000fe40003f3d000ULL,
0x0000008a7d95723eULL, 0x000fe200000010ffULL, 0x000000382c48723cULL, 0x000f620000041848ULL,
0x0000000187876812ULL, 0x000fe200078efcffULL, 0x0000003a00667306ULL, 0x0003e6000000d400ULL,
0x000000877287723eULL, 0x000fc600000010ffULL, 0x000000942c30723cULL, 0x000b640000041830ULL,
0x0000003b00887306ULL, 0x000fe20000009400ULL, 0x00000010e03a7824ULL, 0x002fe200078e00ffULL,
0x000000015e5e1812ULL, 0x000fe400078efcffULL, 0x000000a19e00720bULL, 0x000fe40003f3d000ULL,
0x0000005c6f2c723eULL, 0x020fe400000010ffULL, 0x0000003b00897306ULL, 0x000e620000005400ULL,
0x00000071682d723eULL, 0x000fc400000010ffULL, 0x0000005e7368723eULL, 0x000fca00000010ffULL,
0x0000003b00847306ULL, 0x0004e2000000d400ULL, 0x0000000165651812ULL, 0x000fe400078efcffULL,
0x000000817e00720bULL, 0x000fca0003f3d000ULL, 0x000000dd00a07306ULL, 0x000fe20000209400ULL,
0x000000003a38783bULL, 0x004ea20000000200ULL, 0x000000898800720bULL, 0x002fe40003fdd000ULL,
0x0000006e6389723eULL, 0x000fe400000010ffULL, 0x0000006d8088723eULL, 0x000fe400000010ffULL,
0x000000dd00a37306ULL, 0x000e620000205400ULL, 0x0000000183831812ULL, 0x000fcc00078efcffULL,
0x0000000184846812ULL, 0x008fe200078efcffULL, 0x000000d200c87306ULL, 0x000ff00000209400ULL,
0x000000d200cb7306ULL, 0x000ee20000205400ULL, 0x000000a3a000720bULL, 0x002fce0003f1d000ULL,
0x000000dd00677306ULL, 0x000e70000020d400ULL, 0x000000d200ba7306ULL, 0x000f22000020d400ULL,
0x000000cbc800720bULL, 0x008fe20003f9d000ULL, 0x0000002c3850723cULL, 0x044b6c0000041850ULL,
0x000000bc00bb7306ULL, 0x000fe20000209400ULL, 0x0000000167670812ULL, 0x002fe200078efcffULL,
0x000000883854723cULL, 0x000b620000041854ULL, 0x0000008f8e00720bULL, 0x000fc40003f1d000ULL,
0x000000646786723eULL, 0x000fc600000010ffULL, 0x000000bc00b87306ULL, 0x000e620000205400ULL,
0x00000001baba4812ULL, 0x010fe200078efcffULL, 0x00000068384c723cULL, 0x000b62000004184cULL,
0x0000006b6a00720bULL, 0x000fe40003f9d000ULL, 0x00000065bab6723eULL, 0x000fc600000010ffULL,
0x000000b200aa7306ULL, 0x000fe20000209400ULL, 0x0000000166660812ULL, 0x000fe200078efcffULL,
0x000000863844723cULL, 0x000b6c0000041844ULL, 0x000000b200a97306ULL, 0x000ea20000205400ULL,
0x000000b8bb00720bULL, 0x002fe40003f7d000ULL, 0x000000016c6c4812ULL, 0x000fc400078efcffULL,
0x000000787700720bULL, 0x000fe40003f9d000ULL, 0x000000836c63723eULL, 0x000fe200000010ffULL,
0x000000b3002f7306ULL, 0x000fec0000209400ULL, 0x000000623848723cULL, 0x000b640000041848ULL,
0x000000b3002c7306ULL, 0x020e620000205400ULL, 0x000000a9aa00720bULL, 0x004fc40003f3d000ULL,
0x0000000179794812ULL, 0x000fca00078efcffULL, 0x000000bc00b77306ULL, 0x000eb0000020d400ULL,
0x000000b2009f7306ULL, 0x000ee2000020d400ULL, 0x0000002c2f00720bULL, 0x002fce0003f1d000ULL,
0x000000ae009c7306ULL, 0x000fe20000209400ULL, 0x00000001b7b73812ULL, 0x004fe400078efcffULL,
0x0000007b7a00720bULL, 0x000fe40003f7d000ULL, 0x000000b776b7723eULL, 0x000fc600000010ffULL,
0x000000ae008b7306ULL, 0x000e620000205400ULL, 0x000000019f9f1812ULL, 0x008fc600078efcffULL,
0x000000b63840723cULL, 0x000b620000041840ULL, 0x000000669f66723eULL, 0x000fc600000010ffULL,
0x000000b1007d7306ULL, 0x000fe20000209400ULL, 0x000000017c7c3812ULL, 0x000fce00078efcffULL,
0x000000b1002e7306ULL, 0x000ea20000205400ULL, 0x0000008b9c00720bULL, 0x002fce0003fbd000ULL,
0x000000b300857306ULL, 0x000e70000020d400ULL, 0x000000ae008c7306ULL, 0x000ee2000020d400ULL,
0x0000002e7d00720bULL, 0x004fce0003f3d000ULL, 0x000000b100b17306ULL, 0x000ea2000020d400ULL,
0x0000000185850812ULL, 0x002fe400078efcffULL, 0x000000081500780cULL, 0x000fe40003f05270ULL,
0x000000857c85723eULL, 0x000fe400000010ffULL, 0x000000018c8c5812ULL, 0x008fc800078efcffULL,
0x0000008c7967723eULL, 0x000fe400000010ffULL, 0x00000001b1b11812ULL, 0x004fca00078efcffULL,
0x00000066383c723cULL, 0x000b62000004183cULL, 0x00000084b184723eULL, 0x000fce00000010ffULL,
0x000000843830723cULL, 0x000b620000041830ULL, 0x0000001000008944ULL, 0x000fe20003c00000ULL,
0xffffe0e000007947ULL, 0x000fcc000383ffffULL, 0x000000021700780cULL, 0x000fe20003f06070ULL,
0x000000ffff107224ULL, 0x000fe400078e0017ULL, 0x000000ffff0f7224ULL, 0x000fd400078e0009ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffbbc000007947ULL, 0x000fea000383ffffULL,
0x00000002ff177819ULL, 0x000fc80000011603ULL, 0x0000000c1700720cULL, 0x040fe40003f06070ULL,
0x000000010c0c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000817157810ULL, 0x040fe40007ffe0ffULL,
0x0000000c1700720cULL, 0x000fe40004706470ULL, 0x0000000e1500720cULL, 0x000fe40003f26070ULL,
0x000000073400720cULL, 0x000fc40000703070ULL, 0x0000000c1500720cULL, 0x000fc80000f21070ULL,
0x000000073400720cULL, 0x000fc80000f24470ULL, 0x0000002933297208ULL, 0x020fe40000800000ULL,
0x0000002632267208ULL, 0x000fe20000800000ULL, 0x000000ffff198224ULL, 0x000fe200078e0031ULL,
0x0000002b3f2b7208ULL, 0x000fe20000800000ULL, 0x000000ffff168224ULL, 0x000fe200078e0030ULL,
0x000000593e597208ULL, 0x000fe20000800000ULL, 0x000000ffff1b8224ULL, 0x000fe200078e003dULL,
0x0000002843287208ULL, 0x000fe20000800000ULL, 0x000000ffff188224ULL, 0x000fe200078e003cULL,
0x0000005b425b7208ULL, 0x000fe20000800000ULL, 0x000000ffff1d8224ULL, 0x000fe200078e0041ULL,
0x0000002a472a7208ULL, 0x000fe20000800000ULL, 0x000000ffff1a8224ULL, 0x000fe200078e0040ULL,
0x0000005d465d7208ULL, 0x000fe20000800000ULL, 0x000000ffff1f8224ULL, 0x000fe200078e0045ULL,
0x000000584b587208ULL, 0x000fe20000800000ULL, 0x000000ffff1c8224ULL, 0x000fe200078e0044ULL,
0x0000005f4a5f7208ULL, 0x000fe20000800000ULL, 0x000000ffff218224ULL, 0x000fe200078e0049ULL,
0x0000005a4f5a7208ULL, 0x000fe20000800000ULL, 0x000000ffff1e8224ULL, 0x000fe200078e0048ULL,
0x000000614e617208ULL, 0x000fe20000800000ULL, 0x000000ffff238224ULL, 0x000fe200078e004dULL,
0x0000001153117208ULL, 0x000fe20000800000ULL, 0x000000ffff208224ULL, 0x000fe200078e004cULL,
0x0000001252127208ULL, 0x000fe20000800000ULL, 0x000000ffff258224ULL, 0x000fe200078e0051ULL,
0x0000001357137208ULL, 0x000fe20000800000ULL, 0x000000ffff228224ULL, 0x000fe200078e0050ULL,
0x0000001456147208ULL, 0x000fe20000800000ULL, 0x000000ffff278224ULL, 0x000fc400078e0055ULL,
0x000000ffff248224ULL, 0x000fe200078e0054ULL, 0x0000000d0c00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffb7d000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000040c7f8cULL, 0x000e62000c80043fULL,
0x00000002162c7220ULL, 0x080fe40000410000ULL, 0x00000002192d7220ULL, 0x080fe40000410000ULL,
0x0000000224247220ULL, 0x080fe40000410000ULL, 0x0000000227277220ULL, 0x080fe40000410000ULL,
0x0000000222227220ULL, 0x080fe40000410000ULL, 0x0000000225257220ULL, 0x000fc40000410000ULL,
0x0000000220207220ULL, 0x080fe40000410000ULL, 0x0000000223237220ULL, 0x080fe40000410000ULL,
0x000000021e1e7220ULL, 0x080fe40000410000ULL, 0x0000000221217220ULL, 0x080fe40000410000ULL,
0x000000021d0e7220ULL, 0x080fe40000410000ULL, 0x00000002180f7220ULL, 0x000fc40000410000ULL,
0x000000ffff3b7224ULL, 0x002fe400078e000dULL, 0x000000021c0c7220ULL, 0x080fe40000410000ULL,
0x000000021a0d7220ULL, 0x080fe40000410000ULL, 0x000000021b107220ULL, 0x080fe40000410000ULL,
0x0000000213137220ULL, 0x080fe40000410000ULL, 0x000000022b417220ULL, 0x000fc40000410000ULL,
0x000000ffff2b7224ULL, 0x000fe400078e002cULL, 0x00000002142e7220ULL, 0x080fe40000410000ULL,
0x0000000211307220ULL, 0x080fe40000410000ULL, 0x000000022a3c7220ULL, 0x080fe40000410000ULL,
0x00000002283e7220ULL, 0x080fe40000410000ULL, 0x0000000226427220ULL, 0x000fc40000410000ULL,
0x0000000229437220ULL, 0x080fe40000410000ULL, 0x000000ffff2c7224ULL, 0x000fe400078e002dULL,
0x000000021f1f7220ULL, 0x080fe40000410000ULL, 0x00000002122f7220ULL, 0x080fe40000410000ULL,
0x0000000261317220ULL, 0x080fe40000410000ULL, 0x000000025a327220ULL, 0x000fc40000410000ULL,
0x000000025f337220ULL, 0x080fe40000410000ULL, 0x0000000258387220ULL, 0x080fe40000410000ULL,
0x000000025d397220ULL, 0x080fe40000410000ULL, 0x000000025b3d7220ULL, 0x080fe40000410000ULL,
0x0000000259407220ULL, 0x000fe40000410000ULL, 0x000000ffff117224ULL, 0x000fc400078e0024ULL,
0x000000ffff147224ULL, 0x000fe400078e0027ULL, 0x000000ffff167224ULL, 0x000fe400078e0022ULL,
0x000000ffff187224ULL, 0x000fe400078e0025ULL, 0x000000ffff197224ULL, 0x000fe400078e0020ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0023ULL, 0x000000ffff1b7224ULL, 0x000fc400078e001eULL,
0x000000ffff1c7224ULL, 0x000fe400078e0021ULL, 0x000000ffff1d7224ULL, 0x000fe400078e000cULL,
0x000000ffff267224ULL, 0x000fe400078e000dULL, 0x000000ffff287224ULL, 0x000fe400078e000eULL,
0x000000ffff297224ULL, 0x000fe400078e000fULL, 0x000000ffff2a7224ULL, 0x000fc400078e0010ULL,
0x000000ffff2d7224ULL, 0x000fc400078e0013ULL, 0x00000000000c7805ULL, 0x000fca0000015200ULL,
0x00000400040e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe4000780483bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c137210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000130e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000110107810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400040e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fe4000780483bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000403447824ULL, 0x000fe200078e00ffULL, 0x000000050700720cULL, 0x000fc80003f05270ULL,
0xfffffff0440d7812ULL, 0x000fca00078ec0ffULL, 0x0000008000107824ULL, 0x000fca00078e020dULL,
0x01840000100c7984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000203127824ULL, 0x000fe400078e00ffULL, 0x00000001600b7824ULL, 0x000fc600078e0a0bULL,
0x0000000612127812ULL, 0x000fc800078ec0ffULL, 0x00000001121e7812ULL, 0x040fe400078efcffULL,
0x0000000812207812ULL, 0x000fe400078efcffULL, 0x0000000b1e00720cULL, 0x080fe40003f26070ULL,
0x00000010121e7812ULL, 0x000fe400078efcffULL, 0x0000000b2000720cULL, 0x080fe40003f06070ULL,
0x0000000b1e00720cULL, 0x000fc40003fc6070ULL, 0x0000001112207812ULL, 0x040fe400078efcffULL,
0x00000018121e7812ULL, 0x040fe400078efcffULL, 0x0000000b1200720cULL, 0x080fe40003f46070ULL,
0x0000000b2000720cULL, 0x080fe40003fa6070ULL, 0x0000000b1e00720cULL, 0x000fe40003f66070ULL,
0x0000000912227812ULL, 0x000fc400078efcffULL, 0x0000001912207812ULL, 0x040fe400078efcffULL,
0x00000020121e7812ULL, 0x000fe400078efcffULL, 0xff8000002e2e7808ULL, 0x000fe40005000000ULL,
0xff80000011117808ULL, 0x000fe40005000000ULL, 0xff8000002d2d7808ULL, 0x000fe40004800000ULL,
0xff80000014147808ULL, 0x000fc40004800000ULL, 0x0000000b2200720cULL, 0x080fe40003f86070ULL,
0x0000000b2000720cULL, 0x080fe40003f46070ULL, 0x0000000b1e00720cULL, 0x000fe40003f26070ULL,
0x0000002112207812ULL, 0x040fe400078efcffULL, 0x00000028121e7812ULL, 0x000fe400078efcffULL,
0xff8000002f2f7808ULL, 0x000fc40004000000ULL, 0xff80000016167808ULL, 0x000fe40004000000ULL,
0xff80000030307808ULL, 0x000fe40006000000ULL, 0xff80000018187808ULL, 0x000fe40006000000ULL,
0x0000000b2000720cULL, 0x080fe40003f06070ULL, 0x0000000b1e00720cULL, 0x000fe40003f86070ULL,
0x0000002912207812ULL, 0x000fc400078efcffULL, 0x00000030121e7812ULL, 0x000fe400078efcffULL,
0xff80000031317808ULL, 0x000fe40007000000ULL, 0xff80000019197808ULL, 0x000fe40007000000ULL,
0xff80000032327808ULL, 0x000fe40006800000ULL, 0xff8000001a1a7808ULL, 0x000fe40006800000ULL,
0x0000000b2000720cULL, 0x000fc40003fc6070ULL, 0x0000000b1e00720cULL, 0x000fe40003fa6070ULL,
0x0000003112207812ULL, 0x040fe400078efcffULL, 0x00000038121e7812ULL, 0x040fe400078efcffULL,
0x0000003912127812ULL, 0x000fe400078efcffULL, 0xff80000033337808ULL, 0x000fe40005800000ULL,
0xff8000001b1b7808ULL, 0x000fc40005800000ULL, 0xff80000038387808ULL, 0x000fe40005000000ULL,
0xff8000001c1c7808ULL, 0x000fe40005000000ULL, 0xff80000039397808ULL, 0x000fe40004800000ULL,
0xff8000001d1d7808ULL, 0x000fe40004800000ULL, 0x0000000b2000720cULL, 0x080fe40003f66070ULL,
0x0000000b1e00720cULL, 0x000fc40003f46070ULL, 0x0000000b1200720cULL, 0x000fe40003f26070ULL,
0xff8000003c3c7808ULL, 0x000fe40004000000ULL, 0xff8000001f1f7808ULL, 0x000fe40004000000ULL,
0xff8000003d3d7808ULL, 0x000fe40006000000ULL, 0xff80000026267808ULL, 0x000fe40006000000ULL,
0xff8000003e3e7808ULL, 0x000fc40007000000ULL, 0xff80000028287808ULL, 0x000fe40007000000ULL,
0xff80000040407808ULL, 0x000fe40006800000ULL, 0xff80000029297808ULL, 0x000fe40006800000ULL,
0xff80000041417808ULL, 0x000fe40005800000ULL, 0xff8000002a2a7808ULL, 0x000fe40005800000ULL,
0xff80000042427808ULL, 0x000fc40005000000ULL, 0xff8000002b2b7808ULL, 0x000fe40005000000ULL,
0xff80000043437808ULL, 0x000fe40004800000ULL, 0xff8000002c2c7808ULL, 0x000fc40004800000ULL,
0x000000110c00720bULL, 0x004fe40003f1e000ULL, 0x0000002e0d00720bULL, 0x000fe40003f3e000ULL,
0x0000000c110b7208ULL, 0x000fe40004000000ULL, 0x0000000d2e0c7208ULL, 0x000fc40004800000ULL,
0x000000140b00720bULL, 0x000fe40003f1e000ULL, 0x0000002d0c00720bULL, 0x000fe40003f3e000ULL,
0x0000000b140b7208ULL, 0x000fe40004000000ULL, 0x0000000c2d0c7208ULL, 0x000fe40004800000ULL,
0x000000160b00720bULL, 0x000fe40003f1e000ULL, 0x0000002f0c00720bULL, 0x000fc40003f3e000ULL,
0x0000000b160b7208ULL, 0x000fe40004000000ULL, 0x0000000c2f0d7208ULL, 0x000fe40004800000ULL,
0x000000180b00720bULL, 0x000fe40003f1e000ULL, 0x000000300d00720bULL, 0x000fe40003f3e000ULL,
0x0000000b180c7208ULL, 0x000fe40004000000ULL, 0x0000000d30127208ULL, 0x000fc40004800000ULL,
0x000000190c00720bULL, 0x000fe40003f1e000ULL, 0x000000311200720bULL, 0x000fe40003f3e000ULL,
0x0000000c190b7208ULL, 0x000fe40004000000ULL, 0x00000012310d7208ULL, 0x000fe40004800000ULL,
0x0000001a0b00720bULL, 0x000fe40003f1e000ULL, 0x000000320d00720bULL, 0x000fc40003f3e000ULL,
0x0000000b1a0c7208ULL, 0x000fe40004000000ULL, 0x0000000d32127208ULL, 0x000fe40004800000ULL,
0x0000001b0c00720bULL, 0x000fe40003f1e000ULL, 0x000000331200720bULL, 0x000fe40003f3e000ULL,
0x0000000c1b0b7208ULL, 0x000fe40004000000ULL, 0x00000012330d7208ULL, 0x000fc40004800000ULL,
0x0000001c0b00720bULL, 0x000fe40003f1e000ULL, 0x000000380d00720bULL, 0x000fe40003f3e000ULL,
0x0000000b1c0c7208ULL, 0x000fe40004000000ULL, 0x0000000d38127208ULL, 0x000fe40004800000ULL,
0x0000001d0c00720bULL, 0x000fe40003f1e000ULL, 0x000000391200720bULL, 0x000fc40003f3e000ULL,
0x0000000c1d0c7208ULL, 0x000fe40004000000ULL, 0x00000012390b7208ULL, 0x000fe40004800000ULL,
0x0000001f0c00720bULL, 0x000fe40003f1e000ULL, 0x0000003c0b00720bULL, 0x000fe40003f3e000ULL,
0x0000000c1f0d7208ULL, 0x000fe40004000000ULL, 0x0000000b3c0c7208ULL, 0x000fc40004800000ULL,
0x000000260d00720bULL, 0x000fe40003f1e000ULL, 0x0000003d0c00720bULL, 0x000fe40003f3e000ULL,
0x0000000d260d7208ULL, 0x000fe40004000000ULL, 0x0000000c3d0b7208ULL, 0x000fe40004800000ULL,
0x000000280d00720bULL, 0x000fe40003f1e000ULL, 0x0000003e0b00720bULL, 0x000fc40003f3e000ULL,
0x0000000d280c7208ULL, 0x000fe40004000000ULL, 0x0000000b3e0b7208ULL, 0x000fe40004800000ULL,
0x000000290c00720bULL, 0x000fe40003f1e000ULL, 0x000000400b00720bULL, 0x000fe40003f3e000ULL,
0x0000000c290d7208ULL, 0x000fe40004000000ULL, 0x0000000b400c7208ULL, 0x000fc40004800000ULL,
0x0000002a0d00720bULL, 0x000fe40003f1e000ULL, 0x000000410c00720bULL, 0x000fe40003f3e000ULL,
0x0000000d2a127208ULL, 0x000fe40004000000ULL, 0x0000000c410b7208ULL, 0x000fe40004800000ULL,
0x0000002b1200720bULL, 0x000fe40003f1e000ULL, 0x000000420b00720bULL, 0x000fc40003f3e000ULL,
0x000000122b0d7208ULL, 0x000fe40004000000ULL, 0x0000000b420c7208ULL, 0x000fe40004800000ULL,
0x0000002c0d00720bULL, 0x000fe40003f1e000ULL, 0x000000430c00720bULL, 0x000fe40003f3e000ULL,
0x0000000d2c1e7208ULL, 0x000fe40004000000ULL, 0x0000000c43207208ULL, 0x000fe20004800000ULL,
0x00001d027f007947ULL, 0x000fec000b800000ULL, 0x0c401f001e0b7f89ULL, 0x0004e400000e0000ULL,
0x0000000b1e00720bULL, 0x00cfc80003f1e000ULL, 0x0000001e0b227208ULL, 0x000fe20004000000ULL,
0x00001d227f007947ULL, 0x000fea000b800000ULL, 0x0c401f00200b7f89ULL, 0x000ea800000e0000ULL,
0x0c401f000e0d7f89ULL, 0x000ee800000e0000ULL, 0x0c401f000f0c7f89ULL, 0x000f2200000e0000ULL,
0x0000000b2000720bULL, 0x004fc40003f1e000ULL, 0x0000000d0e00720bULL, 0x008fe40003f3e000ULL,
0x000000200b0b7208ULL, 0x000fe40004000000ULL, 0x0000000e0d127208ULL, 0x000fe40004800000ULL,
0x0c201f00220d7f89ULL, 0x000ea200000e0000ULL, 0x0000000c0f00720bULL, 0x010fc60003f1e000ULL,
0x0c201f000b1e7f89ULL, 0x002e6200000e0000ULL, 0x0000000f0c457208ULL, 0x000fc60004000000ULL,
0x0c201f0012137f89ULL, 0x000ee800000e0000ULL, 0x0c201f0045467f89ULL, 0x0002e200000e0000ULL,
0x0000000d2200720bULL, 0x004fe40003f1e000ULL, 0x0000001e0b00720bULL, 0x002fe40003f3e000ULL,
0x000000220d0c7208ULL, 0x000fe40004000000ULL, 0x000000131200720bULL, 0x008fc40003f5e000ULL,
0x0000000b1e0d7208ULL, 0x000fe40004800000ULL, 0x00000012130e7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b0c0b7820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x3fb8aa3b0d0f7820ULL, 0x000fe20000410000ULL, 0xffffffff174e7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b11117823ULL, 0x100fe2000001080bULL, 0x0000000c44447812ULL, 0x000fe200078ec0ffULL,
0x3fb8aa3b14147823ULL, 0x000fe2000001080bULL, 0x0000000303ff7812ULL, 0x000fe2000780c0ffULL,
0x0000001100247308ULL, 0x0023e20000000800ULL, 0x3fb8aa3b2d137823ULL, 0x100fe2000001080fULL,
0x000000464500720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b2f127823ULL, 0x000fc4000001080fULL,
0x3fb8aa3b16167823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b18187823ULL, 0x000fe2000001080bULL,
0x0000001400277308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b30117823ULL, 0x002fe4000001080fULL,
0x00000004ff487e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe2000001080bULL, 0x0001200008047891ULL, 0x000fe2000f8e583fULL,
0x3fb8aa3b1c217823ULL, 0x000fe2000001080bULL, 0x0000001600227308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b2e147823ULL, 0x004fe2000001080fULL, 0x3f8000004848783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b1a237823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b1d1c7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001080bULL, 0x0000001800257308ULL, 0x0004e20000000800ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b261a7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b281d7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b2b167823ULL, 0x102fe2000001080bULL,
0x0000001400147308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b29187823ULL, 0x004fc4000001080bULL,
0x000000ffff497224ULL, 0x000fe400078e0048ULL, 0x3fb8aa3b38587823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001080fULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x00000022252e723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b32327823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b33337823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b395d7823ULL, 0x000fc4000001080fULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3d5b7823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b3e287823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b412b7823ULL, 0x100fe2000001080fULL,
0x0000000417417810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b42267823ULL, 0x100fe2000001080fULL,
0x0000001100117308ULL, 0x000ea20000000800ULL, 0x00000014132d723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b40407823ULL, 0x000fe2000001080fULL, 0x0000000517427810ULL, 0x040fe20007ffe0ffULL,
0x00000008174a7824ULL, 0x000fc400078e00ffULL, 0x00000008174c7824ULL, 0x040fe400078e00ffULL,
0x0000001b001e7308ULL, 0x0003e20000000800ULL, 0x00000008174d7824ULL, 0x000fe400078e00ffULL,
0xfffffff84c4b7812ULL, 0x000fe200078ee241ULL, 0x000000ffff527224ULL, 0x000fe400078e0048ULL,
0xfffffff84d4c7812ULL, 0x000fe200078ee242ULL, 0x000000ffff537224ULL, 0x000fe200078e0048ULL,
0x00000012112f723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b2a1b7823ULL, 0x102fe2000001080bULL,
0x0000001900207308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2c0b7823ULL, 0x000fe2000001080bULL,
0x00000024272c723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b3c2a7823ULL, 0x100fe2000001080fULL,
0x00000006174d7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b430f7823ULL, 0x000fe2000001080fULL,
0x000000044b4b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000817437824ULL, 0x040fe200078e00ffULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x000000482c38723cULL, 0x000f6200000418ffULL,
0x0000000817507824ULL, 0x000fc400078e00ffULL, 0x00000001444b7824ULL, 0x000fc600078e024bULL,
0xfffffff8504d7812ULL, 0x000fe200078ee24dULL, 0x0000002100217308ULL, 0x000ea60000000800ULL,
0x000000044d4d7c11ULL, 0x000fca000f8e20ffULL, 0x0000003100617308ULL, 0x000fe20000000800ULL,
0x000000202330723eULL, 0x002fe200000010ffULL, 0x00000001444d7824ULL, 0x000fcc00078e024dULL,
0x00000032005a7308ULL, 0x0004700000000800ULL, 0x00000033005f7308ULL, 0x000fe20000000800ULL,
0x0000001e2132723eULL, 0x004fce00000010ffULL, 0x0000005800587308ULL, 0x000ea20000000800ULL,
0x000000615a31723eULL, 0x002fce00000010ffULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x0000005f5833723eULL, 0x004fce00000010ffULL, 0x0000001f001f7308ULL, 0x000e620000000800ULL,
0x00000048303c723cULL, 0x020b6e0000041838ULL, 0x0000001a001a7308ULL, 0x000ff00000000800ULL,
0x0000001d001d7308ULL, 0x000ea20000000800ULL, 0x0000001c1f38723eULL, 0x022fce00000010ffULL,
0x0000005d005d7308ULL, 0x000ff00000000800ULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x0000001a1d3a723eULL, 0x004fce00000010ffULL, 0x0000005b005b7308ULL, 0x000ff00000000800ULL,
0x0000002800287308ULL, 0x000ea20000000800ULL, 0x0000005d2a39723eULL, 0x002fce00000010ffULL,
0x0000000b00197308ULL, 0x0003e20000000800ULL, 0x0000005b283b723eULL, 0x004fce00000010ffULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0x00000001170b7810ULL, 0x002fc80007ffe0ffULL,
0xfffffff84a477812ULL, 0x000fe200078ee20bULL, 0x00000048383c723cULL, 0x000b62000004183cULL,
0x00000002170b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001b001b7308ULL, 0x000fe20000000800ULL,
0x0000000447477c11ULL, 0x000fc8000f8e20ffULL, 0xfffffff84a497812ULL, 0x020fe200078ee20bULL,
0x0000000815487824ULL, 0x000fe400078e00ffULL, 0x0000001600167308ULL, 0x000e620000000800ULL,
0x0000000449497c11ULL, 0x000fe2000f8e20ffULL, 0x0000000144477824ULL, 0x000fe200078e0247ULL,
0xfffffff848157812ULL, 0x000fc600078ee215ULL, 0x0000000144497824ULL, 0x000fe400078e0249ULL,
0x0000004000597308ULL, 0x0005f00000000800ULL, 0x0000002b002b7308ULL, 0x000ee20000000800ULL,
0x0000000317407810ULL, 0x004fc40007ffe0ffULL, 0x000000161942723eULL, 0x002fe400000010ffULL,
0xfffffff8434a7812ULL, 0x000fe200078ee240ULL, 0x0000000817407824ULL, 0x040fe400078e00ffULL,
0x0000002600267308ULL, 0x000fe60000000800ULL, 0xfffffff8400b7812ULL, 0x000fe200078ee217ULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0x000000181b40723eULL, 0x000fc400000010ffULL,
0x000000040b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000f00297308ULL, 0x0002a20000000800ULL,
0x000000592b41723eULL, 0x008fe400000010ffULL, 0xfffffff8174e7812ULL, 0x000fe200078ee24eULL,
0x000000010b0b7824ULL, 0x000fe200078e0244ULL, 0x000000044c177c11ULL, 0x000fe4000f8e20ffULL,
0x000000044a0f7c11ULL, 0x002fc6000f8e20ffULL, 0x0000000144177824ULL, 0x000fe200078e0217ULL,
0x0000002c0b007388ULL, 0x0003e80000000800ULL, 0x0000002e47007388ULL, 0x0003e20000000800ULL,
0x000000262943723eULL, 0x004fc600000010ffULL, 0x0000003049007388ULL, 0x0003e80000000800ULL,
0x00000052403c723cULL, 0x000f5e000004183cULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x000000044e3d7c11ULL, 0x020fe4000f8e20ffULL, 0x00000004153f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000144157824ULL, 0x000fe200078e020fULL, 0x00000045460f7208ULL, 0x000fe20004800000ULL,
0x00000001443d7824ULL, 0x040fe400078e023dULL, 0x0000000144447824ULL, 0x000fe200078e023fULL,
0x0000003215007388ULL, 0x0003e20000000800ULL, 0x000000ffff4e7224ULL, 0x000fe400078e003cULL,
0x000000ffff4f7224ULL, 0x000fe200078e003eULL, 0x000000384b007388ULL, 0x0003e80000000800ULL,
0x0000003a17007388ULL, 0x0003e80000000800ULL, 0x000000404d007388ULL, 0x0003e80000000800ULL,
0x000000423d007388ULL, 0x0003e80000000800ULL, 0x0000002d44007388ULL, 0x0003e80000000800ULL,
0x0004002f47007388ULL, 0x0003e80000000800ULL, 0x0004003149007388ULL, 0x0003e80000000800ULL,
0x0004003315007388ULL, 0x0003e80000000800ULL, 0x000400394b007388ULL, 0x0003e80000000800ULL,
0x0004003b17007388ULL, 0x0003e80000000800ULL, 0x000400414d007388ULL, 0x0003e80000000800ULL,
0x000400433d007388ULL, 0x0003e80000000800ULL, 0x0180000c10008388ULL, 0x0003e80000000c00ULL,
0x0182004e10008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000006ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080006ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100006ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000107077810ULL, 0x000fe20007ffe0ffULL, 0x0000180006ff7f8cULL, 0x0003e6000c80043fULL,
0x000000360700720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff9be000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff387807ULL, 0x008fe20004000000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x00028c40003c7802ULL, 0x000fc40000000f00ULL, 0x0000155000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff047224ULL, 0x000fe200078e003dULL, 0xfffda81000007947ULL, 0x000fea000383ffffULL,
0x00000001ff387807ULL, 0x000fe20004800000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x00028ca0003c7802ULL, 0x000fc40000000f00ULL, 0x000014f000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff047224ULL, 0x000fe200078e003dULL, 0xfffda84000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x000fe200078e0000ULL, 0x00028d2000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3e7224ULL, 0x000fe400078e003bULL, 0x0000001fff407424ULL, 0x000fc400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000143000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e003eULL, 0xfffda8c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003bULL, 0x00028da000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x002fe400078e0000ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000013b000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e003eULL, 0xfffda9a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0000ULL, 0x00028e2000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0003ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000133000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e003eULL, 0xfffdab5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3f7224ULL, 0x002fe200078e0008ULL, 0x00028ea000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3e7224ULL, 0x000fe400078e0000ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000012b000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003eULL, 0xfffdab0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x00028f2000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0062ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000123000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e003eULL, 0xfffde16000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x00028fa000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x002fe400078e0061ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000011b000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003eULL, 0xfffde10000007947ULL, 0x000fea000383ffffULL,
0x00000001ff387807ULL, 0x004fe20004000000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x00029000003c7802ULL, 0x000fc40000000f00ULL, 0x0000119000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e003dULL, 0xfffe1bb000007947ULL, 0x000fea000383ffffULL,
0x00000001ff387807ULL, 0x000fe20004800000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x00029060003c7802ULL, 0x000fc40000000f00ULL, 0x0000113000007944ULL, 0x008fea0003c00000ULL,
0xfffe1bf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0044ULL,
0x000290d000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0062ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000108000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e003eULL,
0xfffe1c6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0044ULL,
0x0002915000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fe400078e0061ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000100000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e003eULL,
0xfffe1d3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x000291d000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0062ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00000f8000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003eULL,
0xfffe1ed000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x0002925000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fe400078e0061ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00000f0000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e003eULL,
0xfffe1e7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x000292d000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0062ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00000e8000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003eULL,
0xfffe52f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x0002935000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fe400078e0061ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00000e0000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e003eULL,
0xfffe529000007947ULL, 0x000fea000383ffffULL, 0x00000001ff387807ULL, 0x004fe20004000000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x000293b0003c7802ULL, 0x000fc40000000f00ULL,
0x00000de000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e003dULL,
0xfffe8c2000007947ULL, 0x000fea000383ffffULL, 0x00000001ff387807ULL, 0x000fe20004800000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x00029410003c7802ULL, 0x000fc40000000f00ULL,
0x00000d8000007944ULL, 0x008fea0003c00000ULL, 0xfffe8c6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0044ULL, 0x0002948000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0062ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00000cd000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e003eULL, 0xfffe8cd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0044ULL, 0x0002950000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x002fe400078e0061ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00000c5000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e003eULL, 0xfffe8da000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0002958000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0062ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00000bd000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e003eULL, 0xfffe8f4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0002960000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x002fe400078e0061ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00000b5000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003eULL, 0xfffe8ee000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0002968000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0062ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00000ad000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e003eULL, 0xfffec36000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0002970000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x002fe400078e0061ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00000a5000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003eULL, 0xfffec30000007947ULL, 0x000fea000383ffffULL,
0x00000001ff387807ULL, 0x004fe20004000000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x00029760003c7802ULL, 0x000fc40000000f00ULL, 0x00000a3000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e003dULL, 0xfffefc9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff387807ULL, 0x000fe20004800000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x000297c0003c7802ULL, 0x000fc40000000f00ULL, 0x000009d000007944ULL, 0x008fea0003c00000ULL,
0xfffefcd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0044ULL,
0x0002983000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0062ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000092000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e003eULL,
0xfffefd4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0044ULL,
0x000298b000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fe400078e0061ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000008a000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e003eULL,
0xfffefe1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x0002993000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0062ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000082000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003eULL,
0xfffeffb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x000299b000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fe400078e0061ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000007a000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e003eULL,
0xfffeff5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x00029a3000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0062ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000072000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003eULL,
0xffff33d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x00029ab000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fe400078e0061ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000006a000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e003eULL,
0xffff337000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0004ULL,
0x00029b2000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff407424ULL, 0x000fc400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000063000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e003eULL, 0xffff565000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0004ULL, 0x00029b9000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000005c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e003eULL,
0xffff572000007947ULL, 0x000fea000383ffffULL, 0x00000002ff217424ULL, 0x000fe200078e00ffULL,
0x00029c0000127802ULL, 0x000fe20000000f00ULL, 0x0000001fff0b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff247424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x002fea0003c00000ULL,
0xffffe2b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1e7224ULL, 0x002fe200078e0020ULL,
0x00029c7000127802ULL, 0x000fe20000000f00ULL, 0x00000002ff217424ULL, 0x000fc400078e00ffULL,
0x0000001fff0b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff247424ULL, 0x000fc400078e00ffULL,
0x000004a000007944ULL, 0x000fea0003c00000ULL, 0x0000000b2000720bULL, 0x004fe20003f1e000ULL,
0x000000ffff1e7224ULL, 0x002fe200078e000eULL, 0x00029cf000127802ULL, 0x000fe20000000f00ULL,
0x00000002ff217424ULL, 0x000fe200078e00ffULL, 0x000000200b207208ULL, 0x000fe20004000000ULL,
0x0000001fff0b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff247424ULL, 0x000fc400078e00ffULL,
0x0000042000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff1e7224ULL, 0x002fe200078e000fULL, 0x00029d7000127802ULL, 0x000fe20000000f00ULL,
0x00000002ff217424ULL, 0x000fe200078e00ffULL, 0x0000000e0b0e7208ULL, 0x000fe20004000000ULL,
0x0000001fff0b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff247424ULL, 0x000fc400078e00ffULL,
0x000003a000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff1e7224ULL, 0x002fe200078e0022ULL, 0x00029df000127802ULL, 0x000fe20000000f00ULL,
0x00000001ff217424ULL, 0x000fe200078e00ffULL, 0x0000000f0b457208ULL, 0x000fe20004000000ULL,
0x0000001fff0b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff247424ULL, 0x000fc400078e00ffULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x0000000b2200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff1e7224ULL, 0x002fe200078e0020ULL, 0x00029e7000127802ULL, 0x000fe20000000f00ULL,
0x00000001ff217424ULL, 0x000fe200078e00ffULL, 0x000000220b0c7208ULL, 0x000fe20004000000ULL,
0x0000001fff0b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff247424ULL, 0x000fc400078e00ffULL,
0x000002a000007944ULL, 0x000fea0003c00000ULL, 0x0000000b2000720bULL, 0x004fe20003f1e000ULL,
0x000000ffff1e7224ULL, 0x002fe200078e000eULL, 0x00029ef000127802ULL, 0x000fe20000000f00ULL,
0x00000001ff217424ULL, 0x000fe200078e00ffULL, 0x000000200b0d7208ULL, 0x000fe20004000000ULL,
0x0000001fff0b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff247424ULL, 0x000fc400078e00ffULL,
0x0000022000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff1e7224ULL, 0x002fe200078e0045ULL, 0x00029f7000127802ULL, 0x000fe20000000f00ULL,
0x00000001ff217424ULL, 0x000fe200078e00ffULL, 0x0000000e0b0e7208ULL, 0x000fe20004000000ULL,
0x0000001fff0b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff247424ULL, 0x000fc400078e00ffULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff467224ULL, 0x004fe200078e000bULL,
0xffffe09000007947ULL, 0x000fea000383ffffULL, 0x0180000011007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000001100008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff11ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000011027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000001100007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffd5ef002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff137424ULL, 0x000fe200078e00ffULL,
0x0000002400007348ULL, 0x000fe80003800000ULL, 0x0c0000211e0b7389ULL, 0x0002a200000e000bULL,
0xfffd5eb012007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff397424ULL, 0x000fe200078e00ffULL,
0x0000004100007348ULL, 0x000fe80003800000ULL, 0x0000003f3e3e7389ULL, 0x0002a200000e0040ULL,
0xfffd5e7038007950ULL, 0x000fea0003c3ffffULL, 0x000000013800780cULL, 0x000fe20003f25070ULL,
0x0000003d00007348ULL, 0x000fe80003800000ULL, 0x00000000ff397424ULL, 0x000fd000078e00ffULL,
0x0000000000387806ULL, 0x000fc800048e0100ULL, 0x0000003d383d7212ULL, 0x000fe200078ec0ffULL,
0x000000ffff387224ULL, 0x000fc800078e003cULL, 0xfffd5e0038007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2f7424ULL, 0x000fe200078e00ffULL, 0x0000002d00007348ULL, 0x000fe80003800000ULL,
0xfffd5dd02e007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x000000000000060bULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000768ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a08ULL, 0x0000000000000458ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e60ULL, 0x00000000000000e4ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f44ULL, 0x0000000000000c40ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001b88ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001b98ULL, 0x00000000000000b0ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001c48ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001c4cULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001e80ULL, 0x000000000002a300ULL, 0xfa00001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000002c180ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000002c1d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000002c550ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001c48ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000002a538ULL, 0x000000000002a538ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000002c180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000002c550ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_4_kvt_int8_pagedKV_64_nqpkv_1_m_1_sm_80_cubin_len = 181808;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
