/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_4_kvt_int8_pagedKV_128_nqpkv_1_m_1_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000202c8ULL, 0x000000000001ff48ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x625f766e5f5f3431ULL,
0x32363174616f6c66ULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454532336a4cULL,
0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545316a4c4534ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45346a4c4974614dULL,
0x326a4c4545326a4cULL, 0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x746132454536316aULL, 0x5245454531624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45326a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x4545386a4c45346aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x5f24000000000000ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65742e6c65722e00ULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL, 0x6265642e00667542ULL,
0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL, 0x2e616c65722e0065ULL,
0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x0000000061686d5fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b0001000000b1ULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000b0001000000efULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b00010000016fULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000b0001000001b9ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0001000001ffULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000246ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000b00010000028cULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000b0001000002daULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000328ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000376ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000b0001000003bdULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000b00010000040bULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000450ULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a0022000004abULL, 0x000000000001e550ULL, 0x0000000000000230ULL,
0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL,
0x0000000000000000ULL, 0x000000000001e780ULL, 0x000d000300000551ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001e55000000000ULL, 0x0000700400000000ULL,
0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL,
0x0001e55000000000ULL, 0x0000023000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000001600082f04ULL, 0x000823040000007eULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001600082304ULL,
0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL, 0x0004370400000000ULL,
0x000c17040000007bULL, 0x0060000700000000ULL, 0x000c17040021f000ULL, 0x0058000600000000ULL,
0x000c17040021f000ULL, 0x0050000500000000ULL, 0x000c17040011f000ULL, 0x0038000400000000ULL,
0x000c17040061f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00801b030011f000ULL, 0xffffffff00c82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00c82804ffffffffULL, 0x00000100000000b0ULL,
0x0000330000000780ULL, 0x0000343000003370ULL, 0x0000382000003570ULL, 0x00005d2000003830ULL,
0x0000853000005d30ULL, 0x00008650000085a0ULL, 0x0000895000008780ULL, 0x0000aca000008960ULL,
0x0000d3d00000acb0ULL, 0x0000d4f00000d440ULL, 0x0000d7f00000d620ULL, 0x0000fb400000d800ULL,
0x000122700000fb50ULL, 0x00012390000122e0ULL, 0x00012690000124c0ULL, 0x000149e0000126a0ULL,
0x00015cc0000149f0ULL, 0x0001641000015cd0ULL, 0x00018b9000016780ULL, 0x0001b820000195c0ULL,
0x0001d7000001d6c0ULL, 0x0001da900001d9e0ULL, 0x0001dd100001dca0ULL, 0x0001dfc00001dd80ULL,
0x0000021007d03904ULL, 0x00018ad0000000ffULL, 0x000002f000040100ULL, 0x00018ad800000008ULL,
0x00000400003f0100ULL, 0x00018b5800000008ULL, 0x00000520003f0100ULL, 0x00018b7800000003ULL,
0x00000610003f0100ULL, 0x00018b88000000ffULL, 0x000008f000040100ULL, 0x00018ad0000000ffULL,
0x00000b7000070107ULL, 0x00018b580000005dULL, 0x00000bb000070101ULL, 0x00018b88000000ffULL,
0x00000be000070101ULL, 0x00018b88000000ffULL, 0x00000d5000070109ULL, 0x00018b88000000ffULL,
0x000017d000070109ULL, 0x00018b88000000ffULL, 0x0000180000070101ULL, 0x00018b88000000ffULL,
0x0000197000070109ULL, 0x00018b88000000ffULL, 0x00001ad000070109ULL, 0x00018b78000000ffULL,
0x00001b1000070107ULL, 0x00018b78000000ffULL, 0x00001b9000070101ULL, 0x00018b88000000ffULL,
0x00001d9000070101ULL, 0x00018b78000000ffULL, 0x00001f0000070109ULL, 0x00018b78000000ffULL,
0x00001f3000070109ULL, 0x00018b88000000ffULL, 0x000020a000070109ULL, 0x00018b88000000ffULL,
0x00002b2000070109ULL, 0x00018b88000000ffULL, 0x00002b5000070101ULL, 0x00018b88000000ffULL,
0x00002cc000070109ULL, 0x00018b88000000ffULL, 0x0000305000070109ULL, 0x00018b80000000ffULL,
0x0000309000070107ULL, 0x00018b80000000ffULL, 0x000030b000070101ULL, 0x00018ad80000005dULL,
0x000030e000070101ULL, 0x00018ad80000005dULL, 0x0000325000070109ULL, 0x00018ad80000005dULL,
0x00004ac000070109ULL, 0x00018b88000000ffULL, 0x00004b7000070101ULL, 0x00018b80000000ffULL,
0x00004ce000070109ULL, 0x00018b80000000ffULL, 0x00004d1000070109ULL, 0x00018b88000000ffULL,
0x00004e8000070109ULL, 0x00018b88000000ffULL, 0x000058f000070109ULL, 0x00018b88000000ffULL,
0x0000592000070101ULL, 0x00018b88000000ffULL, 0x00005a9000070109ULL, 0x00018b88000000ffULL,
0x00005c8000070109ULL, 0x00000000000000ffULL, 0x00005ce000080107ULL, 0x00018b78000000ffULL,
0x00006ec000070101ULL, 0x00018b88000000ffULL, 0x00006f2000070101ULL, 0x00018b58000000ffULL,
0x00006fe000070101ULL, 0x00018b78000000ffULL, 0x0000715000070109ULL, 0x00018b78000000ffULL,
0x0000718000070109ULL, 0x00018b88000000ffULL, 0x000072f000070109ULL, 0x00018b88000000ffULL,
0x00007d7000070109ULL, 0x00018b88000000ffULL, 0x00007da000070101ULL, 0x00018b88000000ffULL,
0x00007f1000070109ULL, 0x00018b88000000ffULL, 0x0000827000070109ULL, 0x00000000000000ffULL,
0x000082a0000d0107ULL, 0x00018b80000000ffULL, 0x000082e000070101ULL, 0x00018af80000005dULL,
0x0000831000070101ULL, 0x00018af80000005dULL, 0x0000848000070109ULL, 0x00018af80000005dULL,
0x00009a8000070109ULL, 0x00018b88000000ffULL, 0x00009b5000070101ULL, 0x00018b80000000ffULL,
0x00009cc000070109ULL, 0x00018b80000000ffULL, 0x00009cf000070109ULL, 0x00018b88000000ffULL,
0x00009e6000070109ULL, 0x00018b88000000ffULL, 0x0000a8d000070109ULL, 0x00018b88000000ffULL,
0x0000a90000070101ULL, 0x00018b88000000ffULL, 0x0000aa7000070109ULL, 0x00018b88000000ffULL,
0x0000ac3000070109ULL, 0x00000000000000ffULL, 0x0000ac6000080107ULL, 0x00018b78000000ffULL,
0x0000bd7000070101ULL, 0x00018b88000000ffULL, 0x0000bdc000070101ULL, 0x00018b60000000ffULL,
0x0000be8000070101ULL, 0x00018b78000000ffULL, 0x0000bff000070109ULL, 0x00018b78000000ffULL,
0x0000c02000070109ULL, 0x00018b88000000ffULL, 0x0000c19000070109ULL, 0x00018b88000000ffULL,
0x0000cc1000070109ULL, 0x00018b88000000ffULL, 0x0000cc4000070101ULL, 0x00018b88000000ffULL,
0x0000cdb000070109ULL, 0x00018b88000000ffULL, 0x0000d11000070109ULL, 0x00000000000000ffULL,
0x0000d140000d0107ULL, 0x00018b80000000ffULL, 0x0000d18000070101ULL, 0x00018b180000005dULL,
0x0000d1b000070101ULL, 0x00018b180000005dULL, 0x0000d32000070109ULL, 0x00018b180000005dULL,
0x0000e92000070109ULL, 0x00018b88000000ffULL, 0x0000e9f000070101ULL, 0x00018b80000000ffULL,
0x0000eb6000070109ULL, 0x00018b80000000ffULL, 0x0000eb9000070109ULL, 0x00018b88000000ffULL,
0x0000ed0000070109ULL, 0x00018b88000000ffULL, 0x0000f77000070109ULL, 0x00018b88000000ffULL,
0x0000f7a000070101ULL, 0x00018b88000000ffULL, 0x0000f91000070109ULL, 0x00018b88000000ffULL,
0x0000fad000070109ULL, 0x00000000000000ffULL, 0x0000fb0000080107ULL, 0x00018b78000000ffULL,
0x00010c1000070101ULL, 0x00018b88000000ffULL, 0x00010c6000070101ULL, 0x00018b68000000ffULL,
0x00010d2000070101ULL, 0x00018b78000000ffULL, 0x00010e9000070109ULL, 0x00018b78000000ffULL,
0x00010ec000070109ULL, 0x00018b88000000ffULL, 0x0001103000070109ULL, 0x00018b88000000ffULL,
0x00011ab000070109ULL, 0x00018b88000000ffULL, 0x00011ae000070101ULL, 0x00018b88000000ffULL,
0x00011c5000070109ULL, 0x00018b88000000ffULL, 0x00011fb000070109ULL, 0x00000000000000ffULL,
0x00011fe0000d0107ULL, 0x00018b80000000ffULL, 0x0001202000070101ULL, 0x00018b380000005dULL,
0x0001205000070101ULL, 0x00018b380000005dULL, 0x000121c000070109ULL, 0x00018b380000005dULL,
0x000137c000070109ULL, 0x00018b88000000ffULL, 0x0001389000070101ULL, 0x00018b80000000ffULL,
0x00013a0000070109ULL, 0x00018b80000000ffULL, 0x00013a3000070109ULL, 0x00018b88000000ffULL,
0x00013ba000070109ULL, 0x00018b88000000ffULL, 0x0001461000070109ULL, 0x00018b88000000ffULL,
0x0001464000070101ULL, 0x00018b88000000ffULL, 0x000147b000070109ULL, 0x00018b88000000ffULL,
0x0001497000070109ULL, 0x00000000000000ffULL, 0x000149a000080107ULL, 0x00018b78000000ffULL,
0x00015ab000070101ULL, 0x00018b88000000ffULL, 0x00015af000070101ULL, 0x00018b70000000ffULL,
0x0001669000070101ULL, 0x00018ad0000000ffULL, 0x00018bc000070101ULL, 0x00018ad0000000ffULL,
0x00018d3000070109ULL, 0x00018ad0000000ffULL, 0x0001909000070109ULL, 0x00018ad0000000ffULL,
0x000190c000070101ULL, 0x00018ad0000000ffULL, 0x0001923000070109ULL, 0x00018ad0000000ffULL,
0x0001cea000070109ULL, 0x00018b5800000003ULL, 0x0001d080003f0101ULL, 0x00018b5800000003ULL,
0x0001d1f0003f0109ULL, 0x00018b5800000003ULL, 0x0001e4f0003f0109ULL, 0x00018ad800000004ULL,
0x0001e500003f0101ULL, 0x00018ae000000004ULL, 0x0001e510003f0101ULL, 0x00018ae800000004ULL,
0x0001e520003f0101ULL, 0x00018af000000004ULL, 0x00053803003f0101ULL, 0x000164c000101c04ULL,
0x0001933000019260ULL, 0x000c05040001e540ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0068190300000000ULL, 0x0000001700080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL,
0x0000001600000002ULL, 0x000000000001e550ULL, 0x0000000000000044ULL, 0x0000001600000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001600000002ULL, 0x0000000000000000ULL,
0x0000000000018c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x00000000000e7919ULL, 0x000ea20000002300ULL,
0x0000010000047ab9ULL, 0x000fcc0000000800ULL, 0x00008800ff067b82ULL, 0x000ee20000000a00ULL,
0x0000021000007945ULL, 0x000fe20003800000ULL, 0x0000000000037919ULL, 0x000ea20000002200ULL,
0x0000000000617919ULL, 0x000f220000002100ULL, 0x0000000000027919ULL, 0x000ee20000000000ULL,
0x0000000000137919ULL, 0x000ee20000002700ULL, 0x000000040e007c24ULL, 0x004fe2000f8e0203ULL,
0x0000000000047ab9ULL, 0x000fe20000000800ULL, 0x00001fff0e0e7589ULL, 0x000fe400000e0000ULL,
0x0000000400037c24ULL, 0x110fe2000f8e0261ULL, 0x00000005ff617819ULL, 0x000fe20000011661ULL,
0x0000000000007919ULL, 0x000ee60000002600ULL, 0x0000007f0300780cULL, 0x000fc40003f64070ULL,
0x00001fff61617589ULL, 0x000ea200000e0000ULL, 0x000000ff0300720cULL, 0x040fe40003f45270ULL,
0x0000000f0300780cULL, 0x040fe40003f04070ULL, 0x000000030300780cULL, 0x040fe40003fa4070ULL,
0x000000010300780cULL, 0x000fc80003f84070ULL, 0x000000000005b919ULL, 0x000f220000008800ULL,
0x000004000004b802ULL, 0x000fe20000000f00ULL, 0xff317217ff09b424ULL, 0x000fc600078e00ffULL,
0x000006540504b816ULL, 0x012fe20000000004ULL, 0x000000040e057824ULL, 0x004fc800078e0261ULL,
0x000000040304b824ULL, 0x000fe200078e0204ULL, 0x0000000000242947ULL, 0x008fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x018ad006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000380947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000403087c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000080612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x018ad804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000385947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000403087c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000080612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x018b5804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018400090400b388ULL, 0x0003e20000000800ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ff8000000057882ULL, 0x000fc60000000000ULL,
0x0000000403037c11ULL, 0x000fe2000f8e18ffULL, 0x001ffe0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000030612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x018b7804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x0000000000242947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x004fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000eb40000000000ULL, 0x018b8806043f75b2ULL, 0x0004a40008000100ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000840000067ab9ULL, 0x000fe20000000800ULL,
0x0000000205057824ULL, 0x000fe200078e00ffULL, 0x0000000206047899ULL, 0x000fe2000800063fULL,
0x0000001002107824ULL, 0x000fe200078e00ffULL, 0x00008200000a7ab9ULL, 0x000fe20000000a00ULL,
0x00000001050c7836ULL, 0x000fe20000000000ULL, 0x0000000405047848ULL, 0x002fe20007fe0000ULL,
0x0000000105087824ULL, 0x000fe200078e0202ULL, 0x000001f0100f7812ULL, 0x000fe200078ec0ffULL,
0x0000000413037c24ULL, 0x000fe2000f8e0200ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x00000020050d7824ULL, 0x000fc400078e00ffULL, 0x0000000104097824ULL, 0x000fe400078e0a05ULL,
0x0000000605057c24ULL, 0x100fe4000f8e0203ULL, 0x000000060c0b7c24ULL, 0x040fe2000f8e0203ULL,
0xffffffe00d037812ULL, 0x000fe200078ee208ULL, 0x0000020005047825ULL, 0x100fe200078e0006ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002000b067825ULL, 0x000fe200078e0006ULL,
0x000000ff0900720cULL, 0x040fe20003f03070ULL, 0x0000065405077896ULL, 0x004fe20008000004ULL,
0x000000010900780cULL, 0x000fe20003f23070ULL, 0x000000010c0d7824ULL, 0x040fe200078e0202ULL,
0x0000000f04087210ULL, 0x000fe20007f5e0ffULL, 0x000000200c0c7824ULL, 0x000fe200078e00ffULL,
0x0000000f06067210ULL, 0x000fe20007f7e0ffULL, 0x00018ad007047890ULL, 0x000fc4000fffe03fULL,
0x0000000703037c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff097224ULL, 0x000fe200010e0605ULL,
0xffffffe00c0d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff077224ULL, 0x000fe200018e0607ULL,
0x00008e00ff0a7b82ULL, 0x000e620000000a00ULL, 0x00000004135c7824ULL, 0x000fe200078e00ffULL,
0x000000070d0f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008037faeULL, 0x000fe8000c101c4aULL, 0x00000000060f7faeULL, 0x0005e2000c901c4aULL,
0x00009600ff0c7b82ULL, 0x000ee20000000a00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x000000045c047825ULL, 0x002fe200078e000aULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x0000000a04047981ULL, 0x000f22000c1e1900ULL, 0x000000045c067825ULL, 0x00cfcc00078e000cULL,
0x0000000a06067981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0e00720cULL, 0x000fe40003f05270ULL,
0x00000000040972caULL, 0x010fe400000e0000ULL, 0x00000008ff5f7819ULL, 0x004fd60000011606ULL,
0x0000007f09047890ULL, 0x000fe4000fffe03fULL, 0x000000ff09087890ULL, 0x000fe4000fffe03fULL,
0x000000073f057899ULL, 0x000fe40008011604ULL, 0x000000083f0c7899ULL, 0x000fe20008011608ULL,
0x0000015800b88947ULL, 0x000ff60003800000ULL, 0x0000002061067824ULL, 0x040fe400078e0202ULL,
0x00000008615d7824ULL, 0x000fc600078e00ffULL, 0x000000030600780cULL, 0x040fe40003f44070ULL,
0x0000001f0600780cULL, 0x000fd60003f04070ULL, 0x00009000ff08ab82ULL, 0x000e620000000800ULL,
0x000000041307a824ULL, 0x000fe200078e0206ULL, 0x0000000906008c0cULL, 0x000fe4000bf26070ULL,
0x00000005ff00ac0cULL, 0x000fe2000bf65270ULL, 0x000000020707a824ULL, 0x000fc600078e00ffULL,
0x00009400ff0b8b82ULL, 0x000eb00000000800ULL, 0x00008c00ff04ab82ULL, 0x000ef00000000a00ULL,
0x00009200ff028b82ULL, 0x000f220000000a00ULL, 0x000000080709a224ULL, 0x002fc400078e0208ULL,
0x00000004ff087424ULL, 0x000fe400078e00ffULL, 0x0000000b5c078224ULL, 0x004fe200078e0206ULL,
0x00000007060bac11ULL, 0x040fe2000f8e10ffULL, 0x000000040904a825ULL, 0x008fe200078e0004ULL,
0x0000000706098c11ULL, 0x000fc6000f8e10ffULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x0000000407028825ULL, 0x010fca00078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a0000002098faeULL, 0x0003e2000c92184aULL, 0x018b58085dff79a7ULL, 0x0005e60008500007ULL,
0x18ac0000040bafaeULL, 0x0007e8000992184aULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x018b8806ff0679a7ULL, 0x000ea40008500007ULL,
0x000000ffff087224ULL, 0x004fe200078e0007ULL, 0x0000000000027805ULL, 0x002fc60000015200ULL,
0x018b8808ff0075a7ULL, 0x000e640008000147ULL, 0x00000000005c0947ULL, 0x00afea0003800000ULL,
0x000000ffff067224ULL, 0x000fce00078e00ffULL, 0x000000100600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000704047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000106067836ULL, 0x000fce0000000000ULL, 0x018b8808ff0075a7ULL, 0x000e640008000147ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000001ff0800788cULL, 0x000fe2000bf04070ULL,
0x00000080005b7824ULL, 0x000fe200078e00ffULL, 0x0000840000047ab9ULL, 0x000fe40000000800ULL,
0x0000000704047899ULL, 0x000fe4000800063fULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000400540947ULL, 0x000fea0003800000ULL, 0x0000000000117919ULL, 0x000e620000000000ULL,
0x00008a00ff067b82ULL, 0x000ea20000000a00ULL, 0x0001400007067890ULL, 0x000fe2000fffe03fULL,
0x00000004ff087819ULL, 0x002fe20000011611ULL, 0x00000010110f7824ULL, 0x000fc800078e00ffULL,
0x000000015d047824ULL, 0x000fe200078e0208ULL, 0x000000f00f0f7812ULL, 0x000fc600078ec0ffULL,
0x000000015b037824ULL, 0x000fe200078e0204ULL, 0x0000000704097c11ULL, 0x040fe2000f8e10ffULL,
0x0000000104057824ULL, 0x000fc800078e0211ULL, 0x018a000009007984ULL, 0x000e640000000800ULL,
0x00000007000a7c11ULL, 0x002fe4000f8e10ffULL, 0x000000095d007c48ULL, 0x000fc6000ffe0000ULL,
0x018ac0000a027984ULL, 0x0002e40000000800ULL, 0x0000000100007824ULL, 0x000fca00078e0a5dULL,
0x000000000800720cULL, 0x000fe40003f06070ULL, 0x00000004040a7819ULL, 0x002fe200000006ffULL,
0x0000000402037c24ULL, 0x008fc8000f8e0203ULL, 0x0000010003027825ULL, 0x004fc600078e0006ULL,
0x0000000f02047210ULL, 0x000fe40007f3e0ffULL, 0xfffffff00a027812ULL, 0x000fc600078ee205ULL,
0x000000ffff057224ULL, 0x000fe200008e0603ULL, 0x00000006020b7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e8000c101c4aULL,
0x018a080009027984ULL, 0x000ea40000000800ULL, 0x00000007020d7c11ULL, 0x004fe2000f8e10ffULL,
0x0000000208027836ULL, 0x000fc80000000000ULL, 0x018ac0000d037984ULL, 0x000ea20000000800ULL,
0x000000015d0a7824ULL, 0x000fe200078e0202ULL, 0x000000000200720cULL, 0x000fc60003f06070ULL,
0x000000015b0c7824ULL, 0x000fe400078e020aULL, 0x000000100a057824ULL, 0x042fe400078e00ffULL,
0x0000000403037c24ULL, 0x004fe4000f8e020cULL, 0x000000010a0c7824ULL, 0x000fe400078e0211ULL,
0x0000010003027825ULL, 0x000fc600078e0006ULL, 0xfffffff0050c7812ULL, 0x000fe400078ee20cULL,
0x0000000f02047210ULL, 0x000fe40007f3e0ffULL, 0x000000060c0b7c11ULL, 0x000fc6000f8e20ffULL,
0x000000ffff057224ULL, 0x000fca00008e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e8000c101c4aULL, 0x018a100009027984ULL, 0x000ea40000000800ULL,
0x00000007020d7c11ULL, 0x004fe2000f8e10ffULL, 0x0000000408027836ULL, 0x000fe40000000000ULL,
0x0000000608087836ULL, 0x000fe40000000000ULL, 0x018ac0000d037984ULL, 0x000ea20000000800ULL,
0x000000015d0a7824ULL, 0x000fe200078e0202ULL, 0x000000000200720cULL, 0x000fc60003f06070ULL,
0x000000015b0c7824ULL, 0x000fe400078e020aULL, 0x000000100a057824ULL, 0x042fe400078e00ffULL,
0x0000000403037c24ULL, 0x004fe4000f8e020cULL, 0x000000010a0c7824ULL, 0x000fe400078e0211ULL,
0x0000010003027825ULL, 0x000fc600078e0006ULL, 0xfffffff0050c7812ULL, 0x000fe200078ee20cULL,
0x000000015d0a7824ULL, 0x000fe200078e0208ULL, 0x0000000f02047210ULL, 0x000fe40007f3e0ffULL,
0x000000060c0b7c11ULL, 0x000fc6000f8e20ffULL, 0x000000ffff057224ULL, 0x000fe400008e0603ULL,
0x000000015b037824ULL, 0x000fc600078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e2000c101c4aULL, 0x000000000800720cULL, 0x000fe20003f06070ULL,
0x000000010a007824ULL, 0x040fe400078e0211ULL, 0x018a180009097984ULL, 0x000ea20000000800ULL,
0x000000100a057824ULL, 0x002fca00078e00ffULL, 0xfffffff005007812ULL, 0x000fc800078ee200ULL,
0x0000000600057c11ULL, 0x000fe4000f8e20ffULL, 0x00000007090c7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402037c24ULL, 0x002fc8000f8e0203ULL,
0x0000010003027825ULL, 0x000fc600078e0006ULL, 0x0000000f02027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c101c4aULL, 0x0000000400287947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x000e620000000000ULL, 0x00008a00ff087b82ULL, 0x000ea20000000a00ULL,
0x0001400007067890ULL, 0x000fe2000fffe03fULL, 0x0000005d0d007211ULL, 0x042fe200078fe0ffULL,
0x000000100d047824ULL, 0x000fc600078e00ffULL, 0x00000007000a7c11ULL, 0x000fe2000f8e10ffULL,
0x000000015b037824ULL, 0x000fe200078e0200ULL, 0x000000f0040f7812ULL, 0x000fe200078ec0ffULL,
0x0000000100057824ULL, 0x040fe400078e020dULL, 0x018a00000a027984ULL, 0x000e620000000800ULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x0000000702067c11ULL, 0x002fca000f8e10ffULL,
0x018ac00006027984ULL, 0x0002e40000000800ULL, 0x0000000200067836ULL, 0x002fc80000000000ULL,
0x0000000106077824ULL, 0x040fe400078e020dULL, 0x00000010060e7824ULL, 0x000fe400078e00ffULL,
0x0000000402037c24ULL, 0x008fc8000f8e0203ULL, 0x0000010003027825ULL, 0x004fc600078e0008ULL,
0x0000000f02047210ULL, 0x000fe40007f1e0ffULL, 0xfffffff00c027812ULL, 0x000fc600078ee205ULL,
0x000000ffff057224ULL, 0x000fe200000e0603ULL, 0x00000006020b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000015b037824ULL, 0x000fc800078e0206ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e8000b901c4aULL, 0x018a08000a027984ULL, 0x000ea20000000800ULL,
0x0000000400047836ULL, 0x002fe40000000000ULL, 0x0000000600007836ULL, 0x000fc60000000000ULL,
0x0000000d04057210ULL, 0x000fe40007ffe0ffULL, 0x00000007020c7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402037c24ULL, 0x002fc8000f8e0203ULL,
0x0000010003027825ULL, 0x000fc600078e0008ULL, 0x0000000f02067210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00e027812ULL, 0x000fe200078ee207ULL, 0x00000010040e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe200000e0603ULL, 0x00000006020b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000015b037824ULL, 0x000fc800078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060b7faeULL, 0x0003e8000b901c4aULL, 0x018a10000a027984ULL, 0x000ea20000000800ULL,
0x0000000100067824ULL, 0x002fe200078e020dULL, 0x00000007020c7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402037c24ULL, 0x002fc8000f8e0203ULL,
0x0000010003027825ULL, 0x000fc600078e0008ULL, 0x0000000f02047210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00e027812ULL, 0x000fc600078ee205ULL, 0x000000ffff057224ULL, 0x000fe200000e0603ULL,
0x0000000602077c11ULL, 0x000fe2000f8e20ffULL, 0x000000015b037824ULL, 0x000fc800078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000b901c4aULL,
0x018a18000a0a7984ULL, 0x000ea40000000800ULL, 0x000000070a0b7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0000b027984ULL, 0x000ea40000000800ULL, 0x0000000402037c24ULL, 0x004fc8000f8e0203ULL,
0x0000010003027825ULL, 0x000fc800078e0008ULL, 0x0000001000097824ULL, 0x000fe200078e00ffULL,
0x0000000f02027210ULL, 0x000fc80007f1e0ffULL, 0xfffffff009067812ULL, 0x000fe200078ee206ULL,
0x000000ffff037224ULL, 0x000fc600000e0603ULL, 0x0000000606057c11ULL, 0x002fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e4000b901c4aULL,
0x00000001ff027424ULL, 0x002fcc00078e00ffULL, 0x018b8802ff0279a7ULL, 0x000e640008500007ULL,
0x000000ffff067224ULL, 0x002fe200078e0003ULL, 0x0000000000027805ULL, 0x000fc60000015200ULL,
0x018b8806ff0075a7ULL, 0x000e640008000147ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x000000100800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000108087836ULL, 0x000fce0000000000ULL, 0x018b8806ff0075a7ULL, 0x000e640008000147ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000127919ULL, 0x000e620000000000ULL,
0x00018b7807087890ULL, 0x000fe2000fffe03fULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x00000001ff047424ULL, 0x000fe400078e00ffULL, 0x0000002061077824ULL, 0x002fca00078e0212ULL,
0x0000001f0700780cULL, 0x000fda0003f04070ULL, 0x0000000000300947ULL, 0x000fea0003800000ULL,
0x00009200ff027b82ULL, 0x000e620000000a00ULL, 0x0000002007007836ULL, 0x000fe20000000000ULL,
0x0000940000047ab9ULL, 0x000fe40000000800ULL, 0x000000045c057c24ULL, 0x000fe2000f8e0207ULL,
0x0000000707077c11ULL, 0x000fe4000f8e10ffULL, 0x0000000900007c0cULL, 0x000fe2000bf06070ULL,
0x0000002005057836ULL, 0x000fc80000000000ULL, 0x0000000405027825ULL, 0x002fd000078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000002077faeULL, 0x0003e4000c12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a48ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000cff007c0cULL, 0x000fe2000bf05270ULL, 0x018b7804ff0279a7ULL, 0x0026a20008500007ULL,
0x000000ffff5a7224ULL, 0x000fe200078e00ffULL, 0x0000000000587805ULL, 0x000fe4000001ff00ULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x0000000000527805ULL, 0x000fc4000001ff00ULL,
0x0000000000507805ULL, 0x000fe4000001ff00ULL, 0x00000000004e7805ULL, 0x000fe4000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x018b8804ff0479a7ULL, 0x008e620008500007ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fc4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000000e7805ULL, 0x000fe4000001ff00ULL,
0x00000000000c7805ULL, 0x000fc4000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000013c00b88947ULL, 0x002fec0003800000ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff717224ULL, 0x004fe200078e0003ULL, 0x0000000704067899ULL, 0x000fe2000800063fULL,
0x000000ffff187224ULL, 0x002fe400078e0005ULL, 0xff317217ff097424ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff5a7224ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x0000010008007824ULL, 0x000fca00078e00ffULL,
0x0000000900007c0cULL, 0x000fda000bf06070ULL, 0x0000013c00800947ULL, 0x002fea0003800000ULL,
0x000000ffff6c7224ULL, 0x000fce00078e00ffULL, 0x000000085f00720cULL, 0x000fe40003f04070ULL,
0x00000002ff057819ULL, 0x000fe4000001166cULL, 0x000000036c027812ULL, 0x040fe400078ec0ffULL,
0x000000056c057207ULL, 0x000fe40000000000ULL, 0x000000ff02027207ULL, 0x000fe40004000000ULL,
0x0000000305177812ULL, 0x000fc400078ec0ffULL, 0x0000000805007211ULL, 0x000fe400078ff0ffULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x018b7871ff0075a7ULL, 0x000e640008020147ULL,
0x00000000005c1947ULL, 0x002fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f26270ULL, 0x0000000000449947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fcc0000015200ULL, 0x0000001a14197210ULL, 0x000fca0007f3e1ffULL,
0x000000011b1a7824ULL, 0x000fe200008e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f26070ULL,
0x000000ff1a00720cULL, 0x000fda0003f26310ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f26070ULL, 0x000000ff1a00720cULL, 0x000fda0003f26310ULL,
0x00000000001c9947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc8000001141aULL,
0x0000001916167211ULL, 0x000fca00078310ffULL, 0x000000ffff197224ULL, 0x000fca00008e061aULL,
0x0000000216167819ULL, 0x000fc80000001219ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x018b7871ff0075a7ULL, 0x000e640008020147ULL, 0xfffffffc00a89947ULL, 0x002fea000383ffffULL,
0x0000000000147805ULL, 0x000fe20000015200ULL, 0x018b8818ff0075a7ULL, 0x000e640008020147ULL,
0x00000000005c1947ULL, 0x002fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f26270ULL, 0x0000000000449947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fcc0000015200ULL, 0x0000001a14197210ULL, 0x000fca0007f3e1ffULL,
0x000000011b1a7824ULL, 0x000fe200008e0e15ULL, 0x003d09001900780cULL, 0x000fc80003f26070ULL,
0x000000ff1a00720cULL, 0x000fda0003f26310ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f26070ULL, 0x000000ff1a00720cULL, 0x000fda0003f26310ULL,
0x00000000001c9947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc8000001141aULL,
0x0000001916167211ULL, 0x000fc800078310ffULL, 0x0000001aff197210ULL, 0x000fc80000ffe4ffULL,
0x0000000216167819ULL, 0x000fc80000001219ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e640008020147ULL, 0xfffffffc00a89947ULL, 0x002fea000383ffffULL,
0x0000000100157836ULL, 0x000fe40000000000ULL, 0x0000000400147824ULL, 0x000fc600078e0217ULL,
0x0000000c15007c0cULL, 0x000fe4000bf26070ULL, 0x00000020141a7811ULL, 0x000fc800078e30ffULL,
0x000000605b167812ULL, 0x000fce00078ef81aULL, 0x0000000400589947ULL, 0x000fea0003800000ULL,
0x00000004ff1f7819ULL, 0x000fe20000011612ULL, 0x00000010121c7824ULL, 0x000fe200078e00ffULL,
0x000000091a187c48ULL, 0x000fe2000ffe0000ULL, 0x00016000070d7890ULL, 0x000fe4000fffe03fULL,
0x000000015d1d7824ULL, 0x000fe200078e021fULL, 0x000000f01c217812ULL, 0x000fe200078ec0ffULL,
0x0000000118187824ULL, 0x000fe400078e0a1aULL, 0x000000011d1a7824ULL, 0x040fe200078e0216ULL,
0x000000071d207c11ULL, 0x040fe2000f8e10ffULL, 0x000000011d1e7824ULL, 0x040fe200078e0212ULL,
0x000000185d187248ULL, 0x000fe20007fe0000ULL, 0x000000101d1d7824ULL, 0x000fc400078e00ffULL,
0x018a000020147984ULL, 0x000e620000000800ULL, 0x000000021f227836ULL, 0x000fe40000000000ULL,
0x00000001181c7824ULL, 0x000fe200078e0a5dULL, 0xfffffff01d1d7812ULL, 0x000fe200078ee21eULL,
0x000000015d237824ULL, 0x000fc600078e0222ULL, 0x0000001c1f00720cULL, 0x000fe20003f26070ULL,
0x0000000123247824ULL, 0x000fe200078e0212ULL, 0x0000000d1d1d7c11ULL, 0x000fe4000f8e20ffULL,
0x00000007141b7c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac0001b197984ULL, 0x000ea40000000800ULL, 0x0000000619197c24ULL, 0x004fc8000f8e021aULL,
0x0000010019187825ULL, 0x002fc600078e0014ULL, 0x00000021181a7210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe400010e0619ULL, 0x0000000123197824ULL, 0x000fc600078e0216ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a1d7faeULL, 0x0003e2000c901c4aULL,
0x0000001c2200720cULL, 0x000fe20003f26070ULL, 0x000000041f227836ULL, 0x000fe40000000000ULL,
0x018a080020187984ULL, 0x000ea20000000800ULL, 0x000000061f1f7836ULL, 0x000fe40000000000ULL,
0x00000010231d7824ULL, 0x002fe400078e00ffULL, 0x000000015d237824ULL, 0x000fc600078e0222ULL,
0xfffffff01d1d7812ULL, 0x000fe200078ee224ULL, 0x0000000123247824ULL, 0x000fc600078e0212ULL,
0x0000000d1d1d7c11ULL, 0x000fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x00000021181a7210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe400010e0619ULL, 0x0000000123197824ULL, 0x000fc600078e0216ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a1d7faeULL, 0x0003e2000c901c4aULL,
0x0000001c2200720cULL, 0x000fc60003f26070ULL, 0x018a100020187984ULL, 0x000ea20000000800ULL,
0x00000010231b7824ULL, 0x002fe400078e00ffULL, 0x000000015d237824ULL, 0x000fc600078e021fULL,
0xfffffff01b1b7812ULL, 0x000fe200078ee224ULL, 0x00000001231d7824ULL, 0x040fe400078e0216ULL,
0x0000000123167824ULL, 0x000fe200078e0212ULL, 0x0000000d1b1b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001023237824ULL, 0x000fca00078e00ffULL, 0xfffffff023167812ULL, 0x000fe400078ee216ULL,
0x00000007181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002118187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fca00010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181b7faeULL, 0x0003e2000c901c4aULL,
0x0000001c1f00720cULL, 0x000fc60003f26070ULL, 0x018a1800201a7984ULL, 0x000ea20000000800ULL,
0x0000000d16197c11ULL, 0x002fe4000f8e20ffULL, 0x000000071a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x018ac0001a1a7984ULL, 0x000e640000000800ULL, 0x000000061a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc600078e0014ULL, 0x0000002114147210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e2000c901c4aULL, 0x0000000400247947ULL, 0x000fea0003800000ULL,
0x0000005d12217211ULL, 0x040fe200078fe0ffULL, 0x00000010121a7824ULL, 0x000fe200078e00ffULL,
0x00016000070d7890ULL, 0x000fe4000fffe03fULL, 0x0000000721207c11ULL, 0x040fe2000f8e10ffULL,
0x0000000121197824ULL, 0x040fe200078e0216ULL, 0x000000f01a237812ULL, 0x000fe200078ec0ffULL,
0x00000010211e7824ULL, 0x000fe200078e00ffULL, 0x00000012211b7210ULL, 0x000fe20007ffe0ffULL,
0x018a000020147984ULL, 0x000e620000000800ULL, 0x00000002211d7836ULL, 0x000fc40000000000ULL,
0xfffffff01e1f7812ULL, 0x000fe400078ee21bULL, 0x000000011d227824ULL, 0x000fe400078e0212ULL,
0x0000000d1f1f7c11ULL, 0x000fe4000f8e20ffULL, 0x00000007141c7c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac0001c187984ULL, 0x000ea40000000800ULL,
0x0000000618197c24ULL, 0x004fc8000f8e0219ULL, 0x0000010019187825ULL, 0x002fc600078e0014ULL,
0x00000023181a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff1b7224ULL, 0x000fe400008e0619ULL,
0x000000011d197824ULL, 0x040fe400078e0216ULL, 0x000000101d1d7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a1f7faeULL, 0x0003e8000b901c4aULL,
0x018a080020187984ULL, 0x000ea20000000800ULL, 0xfffffff01d1b7812ULL, 0x002fe200078ee222ULL,
0x00000004211f7836ULL, 0x000fc40000000000ULL, 0x0000000621217836ULL, 0x000fe20000000000ULL,
0x0000000d1b1b7c11ULL, 0x000fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x0002a40000000800ULL, 0x000000011f1e7824ULL, 0x002fe400078e0212ULL,
0x0000000618197c24ULL, 0x004fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x00000023181c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff1d7224ULL, 0x000fe400008e0619ULL,
0x000000011f197824ULL, 0x140fe400078e0216ULL, 0x000000101f1f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c1b7faeULL, 0x0003e8000b901c4aULL,
0x018a100020187984ULL, 0x000ea20000000800ULL, 0xfffffff01f1b7812ULL, 0x002fe200078ee21eULL,
0x00000001211d7824ULL, 0x000fc400078e0216ULL, 0x0000000121167824ULL, 0x000fe200078e0212ULL,
0x0000000d1b1b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001021217824ULL, 0x000fca00078e00ffULL,
0xfffffff021167812ULL, 0x000fe400078ee216ULL, 0x00000007181a7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001a187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002318187210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff197224ULL, 0x000fca00008e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181b7faeULL, 0x0003e8000b901c4aULL, 0x018a1800201a7984ULL, 0x000ea20000000800ULL,
0x0000000d16197c11ULL, 0x002fe4000f8e20ffULL, 0x000000071a1a7c11ULL, 0x004fcc000f8e10ffULL,
0x018ac0001a1a7984ULL, 0x000e640000000800ULL, 0x000000061a1d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc600078e0014ULL, 0x0000002314147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e6000b901c4aULL, 0x00000001ff147424ULL, 0x002fcc00078e00ffULL,
0x018b8814ff1479a7ULL, 0x000e640008500007ULL, 0x000000ffff1a7224ULL, 0x002fe200078e0015ULL,
0x0000000000147805ULL, 0x000fc60000015200ULL, 0x018b881aff0075a7ULL, 0x000e640008020147ULL,
0x00000000005c1947ULL, 0x002fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f26270ULL, 0x0000000000449947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x00000018141b7210ULL, 0x000fca0007f3e1ffULL,
0x0000000119197824ULL, 0x000fe200008e0e15ULL, 0x003d09001b00780cULL, 0x000fc80003f26070ULL,
0x000000ff1900720cULL, 0x000fda0003f26310ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401b00780cULL, 0x000fc80003f26070ULL, 0x000000ff1900720cULL, 0x000fda0003f26310ULL,
0x00000000001c9947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011419ULL,
0x0000001b16167211ULL, 0x000fca00078310ffULL, 0x000000ffff197224ULL, 0x000fca00008e0619ULL,
0x0000000216167819ULL, 0x000fc80000001219ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x018b881aff0075a7ULL, 0x000e640008020147ULL, 0xfffffffc00a89947ULL, 0x002fea000383ffffULL,
0x000000005f00720cULL, 0x0c0fe20003f64070ULL, 0x0000000102147836ULL, 0x000fe20000000000ULL,
0x000000005f00720cULL, 0x000fe20003f24070ULL, 0x00000020616d7824ULL, 0x000fe200078e0212ULL,
0x0000000105057812ULL, 0x000fe200078ec0ffULL, 0x00018b80070d7890ULL, 0x000fe2000fffe03fULL,
0x0000000314157812ULL, 0x000fe200078ec0ffULL, 0x00000001ff707424ULL, 0x000fe200078e00ffULL,
0x000000030200780cULL, 0x000fc80004f25270ULL, 0x000000010500780cULL, 0x000fe40000f45470ULL,
0x00000002ff14b819ULL, 0x000fe40000011614ULL, 0x0000001f6d00780cULL, 0x000fc60003f24070ULL,
0x0000000117177824ULL, 0x000fc800078e0214ULL, 0x0000004017027824ULL, 0x040fe200078e00ffULL,
0x0000000017007211ULL, 0x000fe400078ff0ffULL, 0x000000ff15177207ULL, 0x000fe40005800000ULL,
0x000000c002057812ULL, 0x000fca00078ec0ffULL, 0x0000010000027824ULL, 0x000fe200078e0205ULL,
0x0000000000502947ULL, 0x000fec0003800000ULL, 0x0000002061167824ULL, 0x000fe200078e0212ULL,
0x0000000104047890ULL, 0x000fe2000fffe03fULL, 0x0000011000007945ULL, 0x000fe60003800000ULL,
0x000000031600780cULL, 0x000fda0003f44070ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff187b82ULL, 0x000e620000000800ULL, 0x000000050400728cULL, 0x000fe2000bf06070ULL,
0x0000000413007824ULL, 0x000fe200078e0216ULL, 0x0000000716197c11ULL, 0x000fc8000f8e10ffULL,
0x0000000100057819ULL, 0x000fe200000006ffULL, 0x00008c00ff147b82ULL, 0x000ea20000000a00ULL,
0x000000000000781cULL, 0x000fe20003f4f008ULL, 0x0000000418007c36ULL, 0x002fc80008000000ULL,
0x0000001805057224ULL, 0x000fc800078e0200ULL, 0x0000000405147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe80003800000ULL,
0x0000000000341947ULL, 0x000fea0003800000ULL, 0x00009400ff057b82ULL, 0x000ea20000000800ULL,
0x000000016d167824ULL, 0x140fe400078e0202ULL, 0x000000015c007824ULL, 0x000fe200078e0217ULL,
0x000000076d177c11ULL, 0x000fe4000f8e10ffULL, 0x0000000916007c0cULL, 0x000fe4000bf46070ULL,
0x00009200ff147b82ULL, 0x002e620000000a00ULL, 0x0000000500007224ULL, 0x004fc800078e0202ULL,
0x000000016d057824ULL, 0x000fc800078e0200ULL, 0x0000000405147825ULL, 0x002fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014177faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4dULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ff6c00720cULL, 0x000fe20003f45270ULL, 0x018b8070ff6679a7ULL, 0x0004d80008500007ULL,
0x0000000400942947ULL, 0x004fea0003800000ULL, 0x018ad8705d1479a7ULL, 0x002e640008500007ULL,
0x000000ffff027224ULL, 0x002fce00078e0015ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x018ad8025d0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff077224ULL, 0x000fce00078e00ffULL, 0x000000100700780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614057210ULL, 0x000fca0007f5e1ffULL, 0x0000000117167824ULL, 0x000fe200010e0e15ULL,
0x003d09000500780cULL, 0x000fc80003f46070ULL, 0x000000ff1600720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400500780cULL, 0x000fc80003f46070ULL,
0x000000ff1600720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011416ULL, 0x0000000500007211ULL, 0x000fca00078510ffULL,
0x000000ffff057224ULL, 0x000fca00010e0616ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000107077836ULL, 0x000fce0000000000ULL, 0x018ad8025d0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001012007824ULL, 0x000fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fe20000011612ULL, 0x00000001ff077424ULL, 0x000fc600078e00ffULL,
0x0000007000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c02057812ULL, 0x000fc800078ec0ffULL,
0x0000000705007c10ULL, 0x000fca000fffe000ULL, 0x0180000000027984ULL, 0x000e680000000800ULL,
0x0182000000157984ULL, 0x0004a20000000800ULL, 0x000000090200720bULL, 0x002fda0003f5d000ULL,
0x0000000000057806ULL, 0x000fc800010e0100ULL, 0x0000ffff05167812ULL, 0x000fe2000784c0ffULL,
0x000000ffff057224ULL, 0x000fd800078e0009ULL, 0x0000000000e8a947ULL, 0x00cfea0003800000ULL,
0x000000090200720bULL, 0x000fe40003f54000ULL, 0x000000ff6100720cULL, 0x000fe40003f65270ULL,
0x0000000209057209ULL, 0x000fd20007810000ULL, 0x0000000000177806ULL, 0x000fe400010e0100ULL,
0x018400050000b388ULL, 0x0003e40000000800ULL, 0x0000991017147816ULL, 0x000fc800000000ffULL,
0x000000ff1400720cULL, 0x000fda0003f45270ULL, 0x0000000000b0a947ULL, 0x002fea0003800000ULL,
0x8000000509007221ULL, 0x000fe20000010000ULL, 0x000000ff17ff7812ULL, 0x040fe4000784c0ffULL,
0x0000ff0017ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b00007820ULL, 0x000fc80000410000ULL,
0x0000000000097308ULL, 0x0002ac0000000800ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000002ff007819ULL, 0x002fcc0000011612ULL, 0x00001f0009007589ULL, 0x004e6400000e0000ULL,
0x000000000b0b7220ULL, 0x082fe20000410000ULL, 0x000000000c0c7220ULL, 0x080fe20000410000ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x0000000010107220ULL, 0x080fe20000410000ULL,
0x0000000041417220ULL, 0x080fe20000410000ULL, 0x0000000042427220ULL, 0x080fe20000410000ULL,
0x0000000045457220ULL, 0x080fe20000410000ULL, 0x0000000046467220ULL, 0x080fe20000410000ULL,
0x0000000049497220ULL, 0x080fe20000410000ULL, 0x000000004a4a7220ULL, 0x080fe20000410000ULL,
0x000000004d4d7220ULL, 0x080fe20000410000ULL, 0x000000004e4e7220ULL, 0x080fe20000410000ULL,
0x0000000051517220ULL, 0x080fe20000410000ULL, 0x0000000052527220ULL, 0x080fe20000410000ULL,
0x0000000057577220ULL, 0x080fe20000410000ULL, 0x0000000058587220ULL, 0x000fce0000410000ULL,
0x000000090a0a7220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x0000000812007811ULL, 0x002fcc00078ff0ffULL, 0x00001f0009007589ULL, 0x000e6400000e0000ULL,
0x000000000d0d7220ULL, 0x082fe20000410000ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x0000000011117220ULL, 0x080fe20000410000ULL, 0x0000000040407220ULL, 0x080fe20000410000ULL,
0x0000000043437220ULL, 0x080fe20000410000ULL, 0x0000000044447220ULL, 0x080fe20000410000ULL,
0x0000000047477220ULL, 0x080fe20000410000ULL, 0x0000000048487220ULL, 0x080fe20000410000ULL,
0x000000004b4b7220ULL, 0x080fe20000410000ULL, 0x000000004c4c7220ULL, 0x080fe20000410000ULL,
0x000000004f4f7220ULL, 0x080fe20000410000ULL, 0x0000000050507220ULL, 0x080fe20000410000ULL,
0x0000000053537220ULL, 0x080fe20000410000ULL, 0x0000000056567220ULL, 0x080fe20000410000ULL,
0x0000000059597220ULL, 0x080fe20000410000ULL, 0x000000005a5a7220ULL, 0x000fce0000410000ULL,
0x0000ffff16ff7812ULL, 0x000fda0007846017ULL, 0x8000000502022221ULL, 0x000fe20000010000ULL,
0x00007610ff072816ULL, 0x000fc60000000007ULL, 0x3fb8aa3b02022820ULL, 0x000fc80000410000ULL,
0x0000000200062308ULL, 0x000ea40000000800ULL, 0x0000000615152220ULL, 0x004fce0000410000ULL,
0x0000000a150a7221ULL, 0x000fe20000010000ULL, 0x000000ffff097224ULL, 0x000fce00078e0005ULL,
0x00000007126b7812ULL, 0x040fe400078ec0ffULL, 0x000000ff07ff7812ULL, 0x000fe4000786c0ffULL,
0x00000004ff667819ULL, 0x008fe40000011612ULL, 0x000000086b6b7812ULL, 0x000fe400078ef812ULL,
0x0000000812057812ULL, 0x000fe200078ec0ffULL, 0x00000004616f7824ULL, 0x000fe400078e0266ULL,
0x0000000166687824ULL, 0x000fe200078e026bULL, 0x00000007056e7812ULL, 0x000fe200078ef812ULL,
0x000000086b157824ULL, 0x002fc800078e00ffULL, 0x000000016e027824ULL, 0x040fe200078e026fULL,
0xfffffff815057812ULL, 0x000fe200078ee268ULL, 0x000000106e177824ULL, 0x000fc600078e00ffULL,
0x0000000705057c11ULL, 0x000fe2000f8e20ffULL, 0x0000000000183947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011612ULL, 0x00000006ff00723eULL, 0x000fc600000010ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000007816ULL, 0x000fca0000000000ULL,
0x00001f0300037589ULL, 0x0002a800000e0000ULL, 0x00001f1500047589ULL, 0x0002e400000e0000ULL,
0x01200000052c783bULL, 0x0002e20000000200ULL, 0x0000000000103947ULL, 0x000fea0003800000ULL,
0x000000032c2c7232ULL, 0x08cfe40000200000ULL, 0x000000032e2e7232ULL, 0x000fe40000200000ULL,
0x000000042d2d7232ULL, 0x080fe40000200000ULL, 0x000000042f2f7232ULL, 0x000fce0000200000ULL,
0x00014000070e7890ULL, 0x000fe2000fffe03fULL, 0xfffffff017027812ULL, 0x000fe200078ee202ULL,
0x000000106e197824ULL, 0x040fe200078e00ffULL, 0x0000000261397811ULL, 0x000fe400078e10ffULL,
0x000000106e387812ULL, 0x000fe400078efcffULL, 0x0000000e02027c11ULL, 0x000fe2000f8e20ffULL,
0x0000000166657824ULL, 0x000fe400078e0239ULL, 0x000000016f6a7824ULL, 0x000fc400078e0238ULL,
0x000000000214783bULL, 0x002e620000004200ULL, 0x000000016e007824ULL, 0x000fca00078e0265ULL,
0xfffffff019007812ULL, 0x000fc800078ee200ULL, 0x0000000e00007c11ULL, 0x000fca000f8e20ffULL,
0x00000000001c783bULL, 0x000f220000004200ULL, 0x00000018ff197819ULL, 0x002fe20000011414ULL,
0x00000100141a7824ULL, 0x040fe200078e00ffULL, 0x00008880143c7816ULL, 0x040fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00008880153d7816ULL, 0x040fe200000000ffULL,
0x00000100151b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1a7819ULL, 0x000fe2000001141aULL,
0x0000010017237824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000001900197306ULL, 0x000fe20000202400ULL, 0x00000018ff367819ULL, 0x000fe2000001141bULL,
0x00000100161b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fc40000011417ULL,
0x0000888017327816ULL, 0x040fe200000000ffULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011423ULL, 0x0000001400147306ULL, 0x000e620000202400ULL,
0x00000018ff217819ULL, 0x000fe40000011416ULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x00000018ff187819ULL, 0x000fe20000011415ULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x000088801c237816ULL, 0x010fe200000000ffULL, 0x0000001a00357306ULL, 0x0009e20000202400ULL,
0x00000018ff257819ULL, 0x000fc4000001141dULL, 0x000088801d347816ULL, 0x000fe400000000ffULL,
0x00000018ff247819ULL, 0x000fe4000001141cULL, 0x0000541014147816ULL, 0x002fe20000000019ULL,
0x0000003d003d7306ULL, 0x000fe20000202400ULL, 0x00008880161a7816ULL, 0x050fe200000000ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe2000001141eULL,
0x000001001f197824ULL, 0x000fe200078e00ffULL, 0x000088801e287816ULL, 0x000fc400000000ffULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000003600367306ULL, 0x000e620000202400ULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000018ff1b7819ULL, 0x000fe4000001141bULL,
0x00000018ff317819ULL, 0x000fc6000001141fULL, 0x0000003200327306ULL, 0x000fe20000202400ULL,
0x000054103d3d7816ULL, 0x002fce0000000036ULL, 0x0000003700377306ULL, 0x000e620000202400ULL,
0x00000018ff367819ULL, 0x000fce0000011419ULL, 0x0000003c003c7306ULL, 0x000f220000202400ULL,
0x0000541032197816ULL, 0x002fce0000000037ULL, 0x00000017002b7306ULL, 0x0003e20000202400ULL,
0x000100001f327824ULL, 0x000fe400078e00ffULL, 0x0000001038377824ULL, 0x000fc600078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000001600227306ULL, 0x000be20000202400ULL,
0x000001001d177824ULL, 0x042fe200078e00ffULL, 0x000054103c3c7816ULL, 0x010fe20000000035ULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff0376a7812ULL, 0x000fe400078ee26aULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x0000002000207306ULL, 0x000fe20000202400ULL,
0x000001001c167824ULL, 0x068fe200078e00ffULL, 0x000000101c1c7819ULL, 0x000fe200000006ffULL,
0x0000003c2c3c723cULL, 0x000fe200000418ffULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x00000017003b7306ULL, 0x0003e20000202400ULL,
0x00000018ff1c7819ULL, 0x000fce000001141cULL, 0x00000016002a7306ULL, 0x0007e20000202400ULL,
0x000088801f177816ULL, 0x002fca00000000ffULL, 0x000000ffff357224ULL, 0x000fe400078e0017ULL,
0x0000002300237306ULL, 0x000fe20000202400ULL, 0x000001001e167824ULL, 0x048fe400078e00ffULL,
0x000100001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0000001800187306ULL, 0x000ff00000202400ULL,
0x0000002100217306ULL, 0x000ff00000202400ULL, 0x0000001500157306ULL, 0x000e700000202400ULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x0000541015157816ULL, 0x002fce0000000018ULL,
0x0000001600297306ULL, 0x0002f00000202400ULL, 0x0000002400247306ULL, 0x000fe20000202400ULL,
0x000000142c14723cULL, 0x002fe200000418ffULL, 0x0000541028287816ULL, 0x008fcc0000000029ULL,
0x0000002500257306ULL, 0x000ff00000202400ULL, 0x0000001a001a7306ULL, 0x000ff00000202400ULL,
0x0000001b001b7306ULL, 0x000e700000202400ULL, 0x0000001c00277306ULL, 0x0007220000202400ULL,
0x000054101a187816ULL, 0x002fce000000001bULL, 0x0000003400347306ULL, 0x000e620000202400ULL,
0x00005410221c7816ULL, 0x008fe20000000021ULL, 0x000000182c18723cULL, 0x000fe200000418ffULL,
0x0000541027247816ULL, 0x010fca0000000024ULL, 0x0000001d00267306ULL, 0x0007220000202400ULL,
0x0000541034217816ULL, 0x002fce000000003bULL, 0x0000003500357306ULL, 0x000fe20000202400ULL,
0x000054102b1d7816ULL, 0x008fe20000000020ULL, 0x000000086b2b7824ULL, 0x000fe200078e00ffULL,
0x0000541023207816ULL, 0x000fe2000000002aULL, 0x00000002682a7836ULL, 0x000fe20000000000ULL,
0x0000541026257816ULL, 0x010fc60000000025ULL, 0x0000003600367306ULL, 0x000e620000202400ULL,
0xfffffff82b5e7812ULL, 0x000fe200078ee22aULL, 0x000000202c20723cULL, 0x000fe600000418ffULL,
0x000000075e5e7c11ULL, 0x000fc6000f8e20ffULL, 0x0000003000307306ULL, 0x000fe20000202400ULL,
0x000000242c24723cULL, 0x000fe200000418ffULL, 0x0000541035297816ULL, 0x002fcc0000000036ULL,
0x0000003100317306ULL, 0x000fe20000202400ULL, 0x000000282c28723cULL, 0x000fee00000418ffULL,
0x0000001e00337306ULL, 0x0002f00000202400ULL, 0x0000003200327306ULL, 0x000f220000202400ULL,
0x0000001c2c1c723cULL, 0x002fe200000418ffULL, 0x0000541033307816ULL, 0x008fc40000000030ULL,
0x0000541032317816ULL, 0x010fce0000000031ULL, 0x000000302c2c723cULL, 0x000fe200000418ffULL,
0x012000005e30783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000103947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000431317232ULL, 0x080fe40000200000ULL,
0x0000000433337232ULL, 0x000fce0000200000ULL, 0x0000000e6a627c11ULL, 0x000fe2000f8e20ffULL,
0x000008a000007945ULL, 0x000fe20003800000ULL, 0x0000003938697210ULL, 0x040fe20007ffe066ULL,
0x0000001038387824ULL, 0x000fe200078e00ffULL, 0x000000085f00720cULL, 0x0c0fe20003fc3070ULL,
0x000000006234783bULL, 0x000f220000004200ULL, 0x000000085f00720cULL, 0x000fe40003f43070ULL,
0xfffffff038697812ULL, 0x000fc800078ee269ULL, 0x0000000e69607c11ULL, 0x000fca000f8e20ffULL,
0x000000006038783bULL, 0x000f620000004200ULL, 0x00000018ff737819ULL, 0x010fe20000011434ULL,
0x0000010034557824ULL, 0x040fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011435ULL,
0x0000010035637824ULL, 0x040fe200078e00ffULL, 0x0000888034547816ULL, 0x040fe200000000ffULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x0000888035747816ULL, 0x040fe200000000ffULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x00000018ff557819ULL, 0x000fc40000011455ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff757819ULL, 0x000fe20000011463ULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x00000018ff647819ULL, 0x000fe40000011437ULL,
0x00000018ff717819ULL, 0x000fe40000011436ULL, 0x0000888038787816ULL, 0x022fc400000000ffULL,
0x00000018ff637819ULL, 0x000fe20000011438ULL, 0x0000003400347306ULL, 0x000e700000202400ULL,
0x0000003500357306ULL, 0x000f220000202400ULL, 0x0000541034347816ULL, 0x002fce0000000073ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x0000888036737816ULL, 0x000fe400000000ffULL,
0x0000541035357816ULL, 0x010fca0000000072ULL, 0x0000005500557306ULL, 0x000e640000202400ULL,
0x000000343014723cULL, 0x008fec0000041814ULL, 0x0000007400747306ULL, 0x000fe20000202400ULL,
0x0000010037347824ULL, 0x000fe200078e00ffULL, 0x0000541054547816ULL, 0x002fcc0000000055ULL,
0x0000007500757306ULL, 0x000e620000202400ULL, 0x00000018ff767819ULL, 0x000fe20000011434ULL,
0x0001000036347824ULL, 0x000fcc00078e00ffULL, 0x0000007300727306ULL, 0x0007e20000202400ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000541074557816ULL, 0x002fe20000000075ULL,
0x0000010036747824ULL, 0x000fe200078e00ffULL, 0x0000888037757816ULL, 0x000fc600000000ffULL,
0x0000007600767306ULL, 0x000fe20000202400ULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x0000888039737816ULL, 0x008fe400000000ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x00000054303c723cULL, 0x000fe2000004183cULL, 0x00000018ff367819ULL, 0x000fe4000001143bULL,
0x0000007400357306ULL, 0x000e680000202400ULL, 0x00000018ff557819ULL, 0x000fc40000011439ULL,
0x00000018ff547819ULL, 0x000fe4000001143aULL, 0x0000007500757306ULL, 0x000ef00000202400ULL,
0x0000003400747306ULL, 0x0003f00000202400ULL, 0x0000007100717306ULL, 0x000fe20000202400ULL,
0x0000541072347816ULL, 0x002fc40000000035ULL, 0x00000018ff727819ULL, 0x000fe40000011437ULL,
0x0000541075357816ULL, 0x008fc60000000076ULL, 0x0000006400647306ULL, 0x000fe80000202400ULL,
0x000000343018723cULL, 0x000fe80000041818ULL, 0x0000007200757306ULL, 0x0002e60000202400ULL,
0x0000010038357824ULL, 0x000fc400078e00ffULL, 0x0000010039347824ULL, 0x040fe400078e00ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000007800787306ULL, 0x000fe20000202400ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x000088803a727816ULL, 0x002fca00000000ffULL, 0x0000003500377306ULL, 0x0006700000202400ULL,
0x0000003400767306ULL, 0x0009e20000202400ULL, 0x0000541075357816ULL, 0x008fe40000000064ULL,
0x00000002ff647819ULL, 0x000fc80000011612ULL, 0x0000006c6400720cULL, 0x000fe20003f86070ULL,
0x0000007300737306ULL, 0x000ee20000202400ULL, 0x0000541074347816ULL, 0x010fe40000000071ULL,
0x00000018ff747819ULL, 0x000fe40000011439ULL, 0x000088803b397816ULL, 0x000fc600000000ffULL,
0x00000034301c723cULL, 0x000fe2000004181cULL, 0x0000006300637306ULL, 0x000fec0000202400ULL,
0x000001003b357824ULL, 0x040fe400078e00ffULL, 0x000001003a347824ULL, 0x040fe200078e00ffULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe20000011435ULL, 0x000100003a357824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000003800387306ULL, 0x000f220000202400ULL, 0x00000018ff357819ULL, 0x000fce0000011435ULL,
0x0000007400747306ULL, 0x000f700000202400ULL, 0x0000003400717306ULL, 0x0003f00000202400ULL,
0x0000007200727306ULL, 0x000ee20000202400ULL, 0x0000541078347816ULL, 0x002fce0000000037ULL,
0x0000003500377306ULL, 0x0007f00000202400ULL, 0x0000003900397306ULL, 0x000fe20000202400ULL,
0x0000541073357816ULL, 0x008fce0000000076ULL, 0x00000075003a7306ULL, 0x000e620000202400ULL,
0x000000343020723cULL, 0x000fee0000041820ULL, 0x0000541038347816ULL, 0x010fe20000000063ULL,
0x0000005400547306ULL, 0x000ee20000202400ULL, 0x0000541074357816ULL, 0x024fe20000000055ULL,
0x000000016c387836ULL, 0x000fc40000000000ULL, 0x0000000864637836ULL, 0x000fc60000000000ULL,
0x000000386400720cULL, 0x000fe20006786470ULL, 0x0000003600367306ULL, 0x000fe20000202400ULL,
0x000000343024723cULL, 0x000fe20000041824ULL, 0x0000006c6300720cULL, 0x000fc80003fa6070ULL,
0x000000386300720cULL, 0x000fe40006fa6470ULL, 0x0000003b003b7306ULL, 0x000ea20000202400ULL,
0x0000541072347816ULL, 0x000fe40000000071ULL, 0x0000541039357816ULL, 0x002fce000000003aULL,
0x000000343028723cULL, 0x000fee0000041828ULL, 0x0000541037347816ULL, 0x008fe40000000054ULL,
0x000054103b357816ULL, 0x004fce0000000036ULL, 0x00000034302c723cULL, 0x000fe2000004182cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000404947ULL, 0x000fde0003000000ULL,
0x0000003c0b0b7221ULL, 0x000fe20000010000ULL, 0x0000003d0c0c7221ULL, 0x000fe20000010000ULL,
0x000000140f0f7221ULL, 0x000fe20000010000ULL, 0x0000001510107221ULL, 0x000fe20000010000ULL,
0x0000001841417221ULL, 0x000fe20000010000ULL, 0x0000001942427221ULL, 0x000fe20000010000ULL,
0x0000001c45457221ULL, 0x000fe20000010000ULL, 0x0000001d46467221ULL, 0x000fe20000010000ULL,
0x0000002049497221ULL, 0x000fe20000010000ULL, 0x000000214a4a7221ULL, 0x000fe20000010000ULL,
0x000000244d4d7221ULL, 0x000fe20000010000ULL, 0x000000254e4e7221ULL, 0x000fe20000010000ULL,
0x0000002851517221ULL, 0x000fe20000010000ULL, 0x0000002952527221ULL, 0x000fe20000010000ULL,
0x0000002c57577221ULL, 0x000fe20000010000ULL, 0x0000002d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe80003800000ULL,
0x0000000000405947ULL, 0x000fea0001000000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0e0e7221ULL, 0x000fe20000010000ULL, 0x0000001611117221ULL, 0x000fe20000010000ULL,
0x0000001740407221ULL, 0x000fe20000010000ULL, 0x0000001a43437221ULL, 0x000fe20000010000ULL,
0x0000001b44447221ULL, 0x000fe20000010000ULL, 0x0000001e47477221ULL, 0x000fe20000010000ULL,
0x0000001f48487221ULL, 0x000fe20000010000ULL, 0x000000224b4b7221ULL, 0x000fe20000010000ULL,
0x000000234c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002750507221ULL, 0x000fe20000010000ULL, 0x0000002a53537221ULL, 0x000fe20000010000ULL,
0x0000002b56567221ULL, 0x000fe20000010000ULL, 0x0000002e59597221ULL, 0x000fe20000010000ULL,
0x0000002f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018b8870ff7079a7ULL, 0x000e620008500007ULL, 0x00000002ff157819ULL, 0x000fe40000011638ULL,
0x000000085f00720cULL, 0x0c0fe40003f43070ULL, 0x00000003381a7812ULL, 0x040fe400078ec0ffULL,
0x0000001538157207ULL, 0x000fe40000000000ULL, 0x000000085f00720cULL, 0x000fe40003fc3070ULL,
0x00000004ff347803ULL, 0x000fc40000000000ULL, 0x000000ff1a1a7207ULL, 0x000fe40004000000ULL,
0x00000003151b7812ULL, 0x040fe400078ec0ffULL, 0x00000008151c7211ULL, 0x000fce00078ff0ffULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x018b8067ff0075a7ULL, 0x000ea40008040147ULL,
0x00000000005c2947ULL, 0x004fea0003800000ULL, 0x000000ffff187224ULL, 0x000fce00078e00ffULL,
0x000000101800780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000001416197210ULL, 0x000fc80007f5e1ffULL,
0x0000001517157210ULL, 0x000fe400017fe5ffULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000118187836ULL, 0x000fce0000000000ULL,
0x018b8067ff0075a7ULL, 0x000ea40008040147ULL, 0xfffffffc00a8a947ULL, 0x004fea000383ffffULL,
0x0000000000167805ULL, 0x000fe20000015200ULL, 0x018b8871ff0075a7ULL, 0x002ea40008040147ULL,
0x00000000005c2947ULL, 0x006fea0003800000ULL, 0x000000ffff187224ULL, 0x000fce00078e00ffULL,
0x000000101800780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416197210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078510ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000118187836ULL, 0x000fce0000000000ULL,
0x018b8871ff0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x000000041c147824ULL, 0x000fc800078e021bULL, 0x00000040141e7824ULL, 0x000fe400078e00ffULL,
0x000000011c147836ULL, 0x000fc60000000000ULL, 0x000000405b1d7812ULL, 0x000fe400078ef81eULL,
0x0000000c14007c0cULL, 0x000fda000bf46070ULL, 0x000000040054a947ULL, 0x000fea0003800000ULL,
0x000000015d207824ULL, 0x000fe200078e0266ULL, 0x000000091e187c48ULL, 0x000fe2000ffe0000ULL,
0x00000010121f7824ULL, 0x000fe200078e00ffULL, 0x00014000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000000120177824ULL, 0x040fe200078e021dULL, 0x0000000720227c11ULL, 0x000fe2000f8e10ffULL,
0x0000000118187824ULL, 0x000fe200078e0a1eULL, 0x000000f01f1f7812ULL, 0x000fc600078ec0ffULL,
0x018a000022147984ULL, 0x000e620000000800ULL, 0x000000185d187248ULL, 0x000fca0007fe0000ULL,
0x0000000118217824ULL, 0x000fe200078e0a5dULL, 0x0000000714197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019167984ULL, 0x0004e40000000800ULL,
0x0000000120197824ULL, 0x044fe400078e0212ULL, 0x0000001020207824ULL, 0x000fca00078e00ffULL,
0xfffffff020197812ULL, 0x000fe200078ee219ULL, 0x0000000266207836ULL, 0x000fc60000000000ULL,
0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL, 0x000000015d247824ULL, 0x000fc800078e0220ULL,
0x0000000124197824ULL, 0x000fe400078e021dULL, 0x0000000616177c24ULL, 0x008fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000001f16167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e0617ULL, 0x000000216600720cULL, 0x000fda0003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000d101c4aULL,
0x018a080022187984ULL, 0x000ea20000000800ULL, 0x0000000124167824ULL, 0x042fe400078e0212ULL,
0x0000001024177824ULL, 0x000fca00078e00ffULL, 0xfffffff017167812ULL, 0x000fc800078ee216ULL,
0x0000000e16237c11ULL, 0x000fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000001f18187210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e0619ULL, 0x000000212000720cULL, 0x000fe20003f46070ULL,
0x0000000466207836ULL, 0x000fe40000000000ULL, 0x0000000666667836ULL, 0x000fe40000000000ULL,
0x000000015d247824ULL, 0x000fc800078e0220ULL, 0x0000000124177824ULL, 0x000fc800078e021dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000d101c4aULL,
0x018a100022167984ULL, 0x000ea20000000800ULL, 0x0000000124187824ULL, 0x042fe400078e0212ULL,
0x0000001024197824ULL, 0x000fca00078e00ffULL, 0xfffffff019187812ULL, 0x000fc800078ee218ULL,
0x0000000e18197c11ULL, 0x000fe4000f8e20ffULL, 0x00000007161e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x0002a40000000800ULL, 0x000000015d1e7824ULL, 0x002fca00078e0266ULL,
0x0000001d1e1d7210ULL, 0x000fe20007ffe0ffULL, 0x0000000616177c24ULL, 0x004fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000001f16167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e0617ULL, 0x000000212000720cULL, 0x000fda0003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000d101c4aULL,
0x018a180022187984ULL, 0x000ea20000000800ULL, 0x000000011e167824ULL, 0x042fe400078e0212ULL,
0x000000101e177824ULL, 0x000fca00078e00ffULL, 0xfffffff017167812ULL, 0x000fc800078ee216ULL,
0x0000000e16177c11ULL, 0x000fe4000f8e20ffULL, 0x0000000718187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x00000006181d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc600078e0014ULL, 0x0000001f14147210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff157224ULL, 0x000fe200010e0615ULL, 0x000000216600720cULL, 0x000fda0003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d101c4aULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015d667824ULL, 0x000fe200078e0266ULL,
0x00014000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000001012197824ULL, 0x000fe400078e00ffULL,
0x0000000166177824ULL, 0x040fe200078e021dULL, 0x0000000766227c11ULL, 0x040fe2000f8e10ffULL,
0x00000010661e7824ULL, 0x040fe200078e00ffULL, 0x000000f019237812ULL, 0x000fe200078ec0ffULL,
0x0000000166197824ULL, 0x000fe400078e0212ULL, 0x018a000022147984ULL, 0x000e660000000800ULL,
0xfffffff01e197812ULL, 0x000fe200078ee219ULL, 0x00000002661e7836ULL, 0x000fc60000000000ULL,
0x0000000e19217c11ULL, 0x000fe2000f8e20ffULL, 0x000000011d197824ULL, 0x000fe400078e021eULL,
0x000000011e1f7824ULL, 0x040fe400078e0212ULL, 0x000000101e1e7824ULL, 0x000fca00078e00ffULL,
0xfffffff01e1f7812ULL, 0x000fe200078ee21fULL, 0x00000004661e7836ULL, 0x000fc60000000000ULL,
0x0000000e1f1f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000714187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ea40000000800ULL,
0x0000000616177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016217faeULL, 0x0003e8000b901c4aULL,
0x018a080022187984ULL, 0x000ea20000000800ULL, 0x000000011d177824ULL, 0x002fe200078e021eULL,
0x0000000718207c11ULL, 0x004fca000f8e10ffULL, 0x018ac00020187984ULL, 0x0002a40000000800ULL,
0x000000011e207824ULL, 0x002fe400078e0212ULL, 0x0000000618197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002318187210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff197224ULL, 0x000fca00010e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181f7faeULL, 0x0003e8000b901c4aULL, 0x018a100022167984ULL, 0x000ea20000000800ULL,
0x000000101e197824ULL, 0x002fca00078e00ffULL, 0xfffffff019207812ULL, 0x000fc800078ee220ULL,
0x0000000e20197c11ULL, 0x000fe4000f8e20ffULL, 0x0000000716217c11ULL, 0x004fca000f8e10ffULL,
0x018ac00021167984ULL, 0x000e640000000800ULL, 0x0000000616177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002316167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e8000b901c4aULL, 0x018a180022187984ULL, 0x000ea40000000800ULL,
0x00000007181e7c11ULL, 0x004fe2000f8e10ffULL, 0x0000000666187836ULL, 0x000fc80000000000ULL,
0x000000011d1d7824ULL, 0x000fe200078e0218ULL, 0x018ac0001e1e7984ULL, 0x000ea60000000800ULL,
0x000000061e1d7c24ULL, 0x004fc8000f8e021dULL, 0x000001001d147825ULL, 0x000fc800078e0014ULL,
0x00000001181d7824ULL, 0x040fe200078e0212ULL, 0x0000002314147210ULL, 0x000fe20007f5e0ffULL,
0x0000001018187824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200010e0615ULL,
0xfffffff0181d7812ULL, 0x000fc800078ee21dULL, 0x0000000e1d1d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e4000b901c4aULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000000468147836ULL, 0x000fe20000000000ULL,
0x000000036b677819ULL, 0x000fe200000006ffULL, 0x000001a000007945ULL, 0x000fe20003800000ULL,
0x000000016e6f7824ULL, 0x000fe400078e026fULL, 0xfffffff867677812ULL, 0x000fe200078ee214ULL,
0x0000000000581947ULL, 0x000fec0003800000ULL, 0x0000001c5f00720cULL, 0x000fe20003f44070ULL,
0x00009400ff197b82ULL, 0x000e660000000800ULL, 0x000000ff1a147207ULL, 0x040fe40001000000ULL,
0x000000ff1a177207ULL, 0x000fc60005000000ULL, 0x000000011b1b7824ULL, 0x000fe400078e0214ULL,
0x00009200ff147b82ULL, 0x000ea20000000a00ULL, 0x000000015c177824ULL, 0x000fe400078e0217ULL,
0x000000401b167824ULL, 0x040fe200078e00ffULL, 0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL,
0x000000c016167812ULL, 0x000fca00078ec0ffULL, 0x000001001b167824ULL, 0x000fc800078e0216ULL,
0x0000002016187836ULL, 0x000fc80000000000ULL, 0x0000001917167224ULL, 0x002fc800078e0218ULL,
0x000000016d177824ULL, 0x040fe400078e0216ULL, 0x000000016d167824ULL, 0x040fe200078e0218ULL,
0x000000076d6d7c11ULL, 0x000fe2000f8e10ffULL, 0x0000000417147825ULL, 0x004fc600078e0014ULL,
0x0000000916007c0cULL, 0x000fda000bf46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18a00000146d7faeULL, 0x0003e4000d12184aULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff707424ULL, 0x000fe200078e00ffULL,
0x0000000767677c11ULL, 0x000fe2000f8e20ffULL, 0x000000106e667824ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a48ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x018b7870ff7079a7ULL, 0x000e620008500007ULL, 0x0000000000103947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000010ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6414037589ULL, 0x0004e800000e0000ULL, 0x00001f6314047589ULL, 0x00046400000e0000ULL,
0x01200000672c783bULL, 0x0004e20000000200ULL, 0x0000000000103947ULL, 0x000fea0003800000ULL,
0x000000032c2c7232ULL, 0x088fe40000200000ULL, 0x000000032e2e7232ULL, 0x000fe40000200000ULL,
0x000000042d2d7232ULL, 0x082fe40000200000ULL, 0x000000042f2f7232ULL, 0x000fce0000200000ULL,
0x00016000070e7890ULL, 0x000fe2000fffe03fULL, 0xfffffff066667812ULL, 0x000fe200078ee26fULL,
0x000000016e657824ULL, 0x040fe400078e0265ULL, 0x000000106e6e7824ULL, 0x000fe400078e00ffULL,
0x0000000e66667c11ULL, 0x000fe2000f8e20ffULL, 0x0000000668687836ULL, 0x000fe40000000000ULL,
0xfffffff06e657812ULL, 0x000fe200078ee265ULL, 0x000000086b6b7824ULL, 0x000fe200078e00ffULL,
0x000000006614783bULL, 0x004ea40000004200ULL, 0x0000000e65657c11ULL, 0x000fc4000f8e20ffULL,
0xfffffff86b687812ULL, 0x000fc600078ee268ULL, 0x000000006518783bULL, 0x000f220000004200ULL,
0x0000000768687c11ULL, 0x000fe4000f8e20ffULL, 0x00000018ff1e7819ULL, 0x004fe20000011414ULL,
0x0000010014207824ULL, 0x040fe200078e00ffULL, 0x00008880143c7816ULL, 0x040fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe40000011415ULL,
0x00008880153d7816ULL, 0x040fe200000000ffULL, 0x0000001e001e7306ULL, 0x000fe20000202400ULL,
0x00000018ff377819ULL, 0x000fe20000011414ULL, 0x0000010015147824ULL, 0x040fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fc40000011416ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000002000297306ULL, 0x0005e20000202400ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x00008880162a7816ULL, 0x040fe400000000ffULL, 0x00000018ff1d7819ULL, 0x000fe40000011417ULL,
0x0000888017387816ULL, 0x000fe200000000ffULL, 0x0000001500367306ULL, 0x000be20000202400ULL,
0x0000010016207824ULL, 0x044fe200078e00ffULL, 0x00000018ff247819ULL, 0x010fe20000011418ULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fc40000011419ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000003d003d7306ULL, 0x000fe20000202400ULL,
0x0000010017157824ULL, 0x068fe200078e00ffULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x0000888019217816ULL, 0x000fe400000000ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000001400147306ULL, 0x000ea20000202400ULL,
0x00000018ff177819ULL, 0x000fc40000011417ULL, 0x00000018ff307819ULL, 0x000fe4000001141aULL,
0x000088801a287816ULL, 0x000fe400000000ffULL, 0x00000018ff317819ULL, 0x000fe2000001141bULL,
0x0000003700377306ULL, 0x000ee20000202400ULL, 0x000054103d3d7816ULL, 0x004fce0000000014ULL,
0x0000003c003c7306ULL, 0x000ea20000202400ULL, 0x0000541037147816ULL, 0x008fce000000001eULL,
0x0000002000397306ULL, 0x0007e20000202400ULL, 0x000100001b1e7824ULL, 0x000fe200078e00ffULL,
0x000054103c3c7816ULL, 0x004fcc0000000029ULL, 0x0000001600357306ULL, 0x0005e20000202400ULL,
0x0000888018207816ULL, 0x048fe200000000ffULL, 0x0000003c2c3c723cULL, 0x000fec00000418ffULL,
0x00000015003b7306ULL, 0x0007e20000202400ULL, 0x0000010018167824ULL, 0x044fe400078e00ffULL,
0x0001000018187824ULL, 0x000fc600078e00ffULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000002a002a7306ULL, 0x000fe20000202400ULL, 0x0000010019157824ULL, 0x048fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0001000019197824ULL, 0x000fc600078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000001f001f7306ULL, 0x000fe20000202400ULL,
0x00000018ff197819ULL, 0x000fce0000011419ULL, 0x0000001d001d7306ULL, 0x000ff00000202400ULL,
0x0000001700327306ULL, 0x000eb00000202400ULL, 0x0000001600237306ULL, 0x0007e20000202400ULL,
0x00005410321d7816ULL, 0x004fce000000001dULL, 0x0000001800277306ULL, 0x0005e20000202400ULL,
0x000001001a167824ULL, 0x048fe400078e00ffULL, 0x000100001a1a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000001500227306ULL, 0x0007e20000202400ULL,
0x000088801b187816ULL, 0x004fe400000000ffULL, 0x00000018ff1a7819ULL, 0x000fca000001141aULL,
0x0000001800297306ULL, 0x0005e20000202400ULL, 0x000001001b157824ULL, 0x008fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe40000011415ULL, 0x0000541036157816ULL, 0x000fe2000000001fULL,
0x0000001c001c7306ULL, 0x000ee20000202400ULL, 0x000054102a187816ULL, 0x004fe40000000039ULL,
0x00000018ff2a7819ULL, 0x000fca000001141eULL, 0x0000002400247306ULL, 0x000ea20000202400ULL,
0x00005410351c7816ULL, 0x008fce000000001cULL, 0x0000002500257306ULL, 0x000fe20000202400ULL,
0x0000001c2c1c723cULL, 0x000fe200000418ffULL, 0x0000541027247816ULL, 0x004fcc0000000024ULL,
0x0000003800387306ULL, 0x000ff00000202400ULL, 0x0000002000207306ULL, 0x000eb00000202400ULL,
0x0000002100217306ULL, 0x000ee20000202400ULL, 0x0000541020207816ULL, 0x004fce0000000023ULL,
0x0000001900267306ULL, 0x0005220000202400ULL, 0x0000541021217816ULL, 0x008fce0000000022ULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x0000541038197816ULL, 0x004fe2000000003bULL,
0x000000202c20723cULL, 0x000fe200000418ffULL, 0x0000541026257816ULL, 0x010fca0000000025ULL,
0x00000016002b7306ULL, 0x0004e40000202400ULL, 0x000000242c24723cULL, 0x000fec00000418ffULL,
0x0000003700367306ULL, 0x000f220000202400ULL, 0x000000142c14723cULL, 0x004fe200000418ffULL,
0x0000541028287816ULL, 0x008fcc000000002bULL, 0x0000003000307306ULL, 0x000fe20000202400ULL,
0x0000541029297816ULL, 0x010fce0000000036ULL, 0x0000003100317306ULL, 0x000ff00000202400ULL,
0x0000001a00337306ULL, 0x0004f00000202400ULL, 0x0000002a00327306ULL, 0x0009620000202400ULL,
0x000000182c18723cULL, 0x004fe200000418ffULL, 0x0000541033307816ULL, 0x008fca0000000030ULL,
0x000000282c28723cULL, 0x010fe200000418ffULL, 0x0000541032317816ULL, 0x022fce0000000031ULL,
0x000000302c2c723cULL, 0x000fe200000418ffULL, 0x012000006830783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000103947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000431317232ULL, 0x080fe40000200000ULL, 0x0000000433337232ULL, 0x000fce0000200000ULL,
0x0000000e6a6a7c11ULL, 0x000fe2000f8e20ffULL, 0x000007f000007945ULL, 0x000fe20003800000ULL,
0x000000ff3400720cULL, 0x000fe40003f45270ULL, 0x0000000e69697c11ULL, 0x000fe2000f8e20ffULL,
0x000000006a34783bULL, 0x000ee80000004200ULL, 0x000000006938783bULL, 0x000f220000004200ULL,
0x00000018ff737819ULL, 0x008fe20000011434ULL, 0x0000010034557824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fc40000011435ULL, 0x0000888034547816ULL, 0x040fe200000000ffULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x0000888035747816ULL, 0x040fe200000000ffULL,
0x0000007300737306ULL, 0x000fe20000202400ULL, 0x00000008356b7819ULL, 0x040fe200000006ffULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x00000018ff757819ULL, 0x000fc4000001146bULL,
0x00000018ff6f7819ULL, 0x000fe40000011436ULL, 0x00000018ff6e7819ULL, 0x000fe40000011437ULL,
0x00000018ff6d7819ULL, 0x010fe20000011438ULL, 0x0000003400347306ULL, 0x000ee20000202400ULL,
0x00000018ff6b7819ULL, 0x000fce0000011439ULL, 0x0000003500357306ULL, 0x000f220000202400ULL,
0x0000541034347816ULL, 0x008fce0000000073ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x0000888036737816ULL, 0x000fe400000000ffULL, 0x0000541035357816ULL, 0x010fca0000000072ULL,
0x0000005500557306ULL, 0x000ee40000202400ULL, 0x000000343014723cULL, 0x004fec0000041814ULL,
0x0000007400747306ULL, 0x000fe20000202400ULL, 0x0000010037347824ULL, 0x040fe200078e00ffULL,
0x0000888037357816ULL, 0x040fe200000000ffULL, 0x0001000037377824ULL, 0x000fca00078e00ffULL,
0x0000007500757306ULL, 0x000ea20000202400ULL, 0x0000541054547816ULL, 0x008fe40000000055ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff377819ULL, 0x000fc60000011437ULL,
0x0000007300727306ULL, 0x0007e20000202400ULL, 0x0000541074557816ULL, 0x004fe20000000075ULL,
0x0000010036747824ULL, 0x000fcc00078e00ffULL, 0x0000003500357306ULL, 0x000fe20000202400ULL,
0x0001000036367824ULL, 0x000fe400078e00ffULL, 0x0000010038737824ULL, 0x008fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x00000054303c723cULL, 0x000fe2000004183cULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000007400757306ULL, 0x000ea80000202400ULL,
0x00000018ff547819ULL, 0x000fc4000001143bULL, 0x00000018ff557819ULL, 0x000fe4000001143aULL,
0x0000003400767306ULL, 0x0004f00000202400ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x0000541072347816ULL, 0x004fc40000000075ULL, 0x00000018ff757819ULL, 0x000fe40000011473ULL,
0x0000888038727816ULL, 0x040fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x0000541035357816ULL, 0x008fe20000000076ULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x0000888039737816ULL, 0x000fe400000000ffULL, 0x00000018ff387819ULL, 0x000fc60000011438ULL,
0x000000343018723cULL, 0x000fe40000041818ULL, 0x0000003600367306ULL, 0x000fea0000202400ULL,
0x0000010039347824ULL, 0x040fe400078e00ffULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x0000003700377306ULL, 0x000ea40000202400ULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x00000018ff397819ULL, 0x000fc80000011439ULL, 0x0000003400787306ULL, 0x0007e20000202400ULL,
0x0000541037357816ULL, 0x004fce000000006eULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x0000541036347816ULL, 0x008fe2000000006fULL, 0x000001003a377824ULL, 0x040fe200078e00ffULL,
0x000088803a367816ULL, 0x000fc800000000ffULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x00000034301c723cULL, 0x000fe2000004181cULL, 0x0000007500757306ULL, 0x000fec0000202400ULL,
0x000001003b347824ULL, 0x040fe200078e00ffULL, 0x000088803b357816ULL, 0x040fe200000000ffULL,
0x0000007300737306ULL, 0x000ea20000202400ULL, 0x000100003b3b7824ULL, 0x000fc400078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe20000011434ULL, 0x000100003a347824ULL, 0x000fe400078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000006d006d7306ULL, 0x000fe20000202400ULL,
0x00000018ff347819ULL, 0x000fce0000011434ULL, 0x0000006b006b7306ULL, 0x000ff00000202400ULL,
0x0000003800747306ULL, 0x000ef00000202400ULL, 0x0000003900767306ULL, 0x000f300000202400ULL,
0x0000003500397306ULL, 0x0005f00000202400ULL, 0x0000003400387306ULL, 0x000be20000202400ULL,
0x0000541073357816ULL, 0x004fce0000000078ULL, 0x0000003600367306ULL, 0x000fe20000202400ULL,
0x0000541072347816ULL, 0x022fce0000000075ULL, 0x00000037006f7306ULL, 0x000e620000202400ULL,
0x000000343020723cULL, 0x000fee0000041820ULL, 0x0000006e003a7306ULL, 0x000ea20000202400ULL,
0x0000541074347816ULL, 0x008fe4000000006dULL, 0x0000541076357816ULL, 0x010fca000000006bULL,
0x0000005500557306ULL, 0x000ee40000202400ULL, 0x000000343024723cULL, 0x000fec0000041824ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x0000541036347816ULL, 0x002fe4000000006fULL,
0x0000541039357816ULL, 0x004fca000000003aULL, 0x0000003b00377306ULL, 0x000e640000202400ULL,
0x000000343028723cULL, 0x000fee0000041828ULL, 0x0000541038347816ULL, 0x008fe40000000055ULL,
0x0000541037357816ULL, 0x002fce0000000054ULL, 0x00000034302c723cULL, 0x000fe2000004182cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000404947ULL, 0x000fde0001000000ULL,
0x0000003c0b0b7221ULL, 0x000fe20000010000ULL, 0x0000003d0c0c7221ULL, 0x000fe20000010000ULL,
0x000000140f0f7221ULL, 0x000fe20000010000ULL, 0x0000001510107221ULL, 0x000fe20000010000ULL,
0x0000001841417221ULL, 0x000fe20000010000ULL, 0x0000001942427221ULL, 0x000fe20000010000ULL,
0x0000001c45457221ULL, 0x000fe20000010000ULL, 0x0000001d46467221ULL, 0x000fe20000010000ULL,
0x0000002049497221ULL, 0x000fe20000010000ULL, 0x000000214a4a7221ULL, 0x000fe20000010000ULL,
0x000000244d4d7221ULL, 0x000fe20000010000ULL, 0x000000254e4e7221ULL, 0x000fe20000010000ULL,
0x0000002851517221ULL, 0x000fe20000010000ULL, 0x0000002952527221ULL, 0x000fe20000010000ULL,
0x0000002c57577221ULL, 0x000fe20000010000ULL, 0x0000002d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe80003800000ULL,
0x0000000000405947ULL, 0x000fea0003000000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0e0e7221ULL, 0x000fe20000010000ULL, 0x0000001611117221ULL, 0x000fe20000010000ULL,
0x0000001740407221ULL, 0x000fe20000010000ULL, 0x0000001a43437221ULL, 0x000fe20000010000ULL,
0x0000001b44447221ULL, 0x000fe20000010000ULL, 0x0000001e47477221ULL, 0x000fe20000010000ULL,
0x0000001f48487221ULL, 0x000fe20000010000ULL, 0x000000224b4b7221ULL, 0x000fe20000010000ULL,
0x000000234c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002750507221ULL, 0x000fe20000010000ULL, 0x0000002a53537221ULL, 0x000fe20000010000ULL,
0x0000002b56567221ULL, 0x000fe20000010000ULL, 0x0000002e59597221ULL, 0x000fe20000010000ULL,
0x0000002f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff167424ULL, 0x000fe400078e00ffULL, 0x000000016c6c7836ULL, 0x000fe40000000000ULL,
0x018b8816ff1479a7ULL, 0x000e620008500007ULL, 0x00000004166b7807ULL, 0x000fc80000000000ULL,
0x0000006b6c00720cULL, 0x000fe20003f46070ULL, 0x000000ffff187224ULL, 0x002fd800078e0015ULL,
0xffffffac0080a947ULL, 0x000fea000383ffffULL, 0x0000004008147811ULL, 0x000fe200078e40ffULL,
0x018b5816ffff79a7ULL, 0x0003e60008500007ULL, 0x0000000914007c0cULL, 0x000fda000bf46070ULL,
0x000000e800ec2947ULL, 0x002fea0003800000ULL, 0x000000ffff6c7224ULL, 0x000fce00078e00ffULL,
0x00000002ff157819ULL, 0x000fe4000001166cULL, 0x000000036c1b7812ULL, 0x040fe400078ec0ffULL,
0x000000156c157207ULL, 0x000fe40000000000ULL, 0x000000ff1b1b7207ULL, 0x000fc60004000000ULL,
0x00000001151f7836ULL, 0x000fca0000000000ULL, 0x000000031f1d7812ULL, 0x040fe400078ec0ffULL,
0x000000081f1a7211ULL, 0x000fe400078ff0ffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b7871ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x018b7871ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x000000011a157836ULL, 0x000fe20000000000ULL,
0x00000004ff707819ULL, 0x000fe20000011612ULL, 0x000000041a147824ULL, 0x000fc600078e021dULL,
0x0000000c15007c0cULL, 0x000fe4000bf46070ULL, 0x0000002014187811ULL, 0x000fc800078e30ffULL,
0x000000605b1c7812ULL, 0x000fce00078ef818ULL, 0x000000040054a947ULL, 0x000fea0003800000ULL,
0x000000015d237824ULL, 0x000fe200078e0270ULL, 0x0000000918167c48ULL, 0x000fe2000ffe0000ULL,
0x00000010121e7824ULL, 0x000fe200078e00ffULL, 0x00016000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000000270227836ULL, 0x000fe20000000000ULL, 0x0000000723207c11ULL, 0x000fe2000f8e10ffULL,
0x0000000116167824ULL, 0x000fe200078e0a18ULL, 0x0000001c23187210ULL, 0x000fe20007ffe0ffULL,
0x000000015d277824ULL, 0x000fe200078e0222ULL, 0x000000f01e257812ULL, 0x000fe200078ec0ffULL,
0x018a000020147984ULL, 0x000e620000000800ULL, 0x000000165d167248ULL, 0x000fe20007fe0000ULL,
0x0000000127247824ULL, 0x000fc800078e0212ULL, 0x0000000116217824ULL, 0x000fca00078e0a5dULL,
0x000000217000720cULL, 0x000fe40003f46070ULL, 0x0000000714197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019177984ULL, 0x0004e40000000800ULL,
0x0000000127197824ULL, 0x044fe400078e021cULL, 0x0000001027277824ULL, 0x000fca00078e00ffULL,
0xfffffff027247812ULL, 0x000fe200078ee224ULL, 0x0000000617177c24ULL, 0x008fe4000f8e0218ULL,
0x0000000123187824ULL, 0x000fe400078e0212ULL, 0x0000010017167825ULL, 0x002fc800078e0014ULL,
0x0000001023237824ULL, 0x000fe200078e00ffULL, 0x0000002516167210ULL, 0x000fc80007f7e0ffULL,
0xfffffff023187812ULL, 0x000fe200078ee218ULL, 0x000000ffff177224ULL, 0x000fc600018e0617ULL,
0x0000000e18237c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x000000212200720cULL, 0x000fe20003f46070ULL,
0x0000000470227836ULL, 0x000fe40000000000ULL, 0x018a080020187984ULL, 0x000ea40000000800ULL,
0x000000015d277824ULL, 0x000fe200078e0222ULL, 0x0000000e24237c11ULL, 0x002fc6000f8e20ffULL,
0x0000000127247824ULL, 0x000fe200078e0212ULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002518167210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe400018e0619ULL, 0x0000000127197824ULL, 0x040fe400078e021cULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x000000212200720cULL, 0x000fc60003f46070ULL,
0x018a100020187984ULL, 0x000ea20000000800ULL, 0xfffffff027247812ULL, 0x000fc800078ee224ULL,
0x0000000e24237c11ULL, 0x002fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x0002a40000000800ULL, 0x00000006701e7836ULL, 0x002fc80000000000ULL,
0x000000015d277824ULL, 0x000fe400078e021eULL, 0x0000000618197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002518167210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe400018e0619ULL, 0x0000000127197824ULL, 0x040fe400078e021cULL,
0x00000001271c7824ULL, 0x040fe200078e0212ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x0000001027277824ULL, 0x000fe200078e00ffULL,
0x000000211e00720cULL, 0x000fe40003f46070ULL, 0x018a180020187984ULL, 0x000ea40000000800ULL,
0xfffffff0271c7812ULL, 0x000fc800078ee21cULL, 0x0000000e1c177c11ULL, 0x002fe4000f8e20ffULL,
0x0000000718187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc600078e0014ULL,
0x0000002514147210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff157224ULL, 0x000fca00018e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d101c4aULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015d237824ULL, 0x000fe200078e0270ULL,
0x00016000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000001012197824ULL, 0x000fe400078e00ffULL,
0x0000000123177824ULL, 0x040fe200078e021cULL, 0x0000000723207c11ULL, 0x040fe2000f8e10ffULL,
0x00000010231e7824ULL, 0x000fe200078e00ffULL, 0x000000f019257812ULL, 0x000fe200078ec0ffULL,
0x0000000123197824ULL, 0x000fe400078e0212ULL, 0x018a000020147984ULL, 0x000e620000000800ULL,
0x0000000223277836ULL, 0x000fc40000000000ULL, 0xfffffff01e197812ULL, 0x000fe400078ee219ULL,
0x0000000127227824ULL, 0x000fe400078e0212ULL, 0x0000000e19217c11ULL, 0x000fe4000f8e20ffULL,
0x0000001c27197210ULL, 0x000fe20007ffe0ffULL, 0x0000001027277824ULL, 0x000fe200078e00ffULL,
0x0000000714187c11ULL, 0x002fe4000f8e10ffULL, 0x00008a00ff147b82ULL, 0x000e660000000a00ULL,
0x018ac00018167984ULL, 0x000ea40000000800ULL, 0x0000000616177c24ULL, 0x004fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000002516167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016217faeULL, 0x0003e8000b901c4aULL, 0x018a080020187984ULL, 0x000ea20000000800ULL,
0xfffffff027217812ULL, 0x002fe200078ee222ULL, 0x0000000423277836ULL, 0x000fe40000000000ULL,
0x0000000623237836ULL, 0x000fe20000000000ULL, 0x0000000e21217c11ULL, 0x000fe2000f8e20ffULL,
0x0000000127177824ULL, 0x000fc400078e021cULL, 0x0000000127227824ULL, 0x040fe400078e0212ULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002518187210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff197224ULL, 0x000fca00010e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018217faeULL, 0x0003e8000b901c4aULL, 0x018a100020167984ULL, 0x000ea20000000800ULL,
0xfffffff027197812ULL, 0x002fe200078ee222ULL, 0x0000000123217824ULL, 0x040fe400078e021cULL,
0x00000001231c7824ULL, 0x000fe200078e0212ULL, 0x0000000e19197c11ULL, 0x000fe2000f8e20ffULL,
0x0000001023237824ULL, 0x000fe200078e00ffULL, 0x00000007161e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x000e640000000800ULL, 0x0000000616177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002516167210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff177224ULL, 0x000fca00010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e8000b901c4aULL, 0x018a180020187984ULL, 0x000ea20000000800ULL,
0xfffffff023177812ULL, 0x002fc800078ee21cULL, 0x0000000e17177c11ULL, 0x000fe4000f8e20ffULL,
0x0000000718187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x0000000618217c24ULL, 0x002fc8000f8e0221ULL, 0x0000010021147825ULL, 0x000fc600078e0014ULL,
0x0000002514147210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff157224ULL, 0x000fca00010e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e6000b901c4aULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001a5f00720cULL, 0x000fe20003f44070ULL,
0x00000001ff1c7424ULL, 0x000fe200078e00ffULL, 0x000000011f1f7812ULL, 0x000fe200078ec0ffULL,
0x00000020616e7824ULL, 0x000fe200078e0212ULL, 0x000000031b00780cULL, 0x000fc80005745270ULL,
0x000000011f00780cULL, 0x000fda0001745470ULL, 0x00000000004c2947ULL, 0x000fea0003800000ULL,
0x000000036e00780cULL, 0x000fe20003f44070ULL, 0x0000000104047890ULL, 0x000fe2000fffe03fULL,
0x0000010000007945ULL, 0x000ff60003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff177b82ULL, 0x000e620000000800ULL, 0x000000050400728cULL, 0x000fe2000bf06070ULL,
0x0000000413167824ULL, 0x000fe200078e026eULL, 0x000000076e197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000216167824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ea20000000a00ULL, 0x0000000417187c36ULL, 0x002fc80008000000ULL,
0x0000001716177224ULL, 0x000fc800078e0218ULL, 0x0000000417147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000019000007945ULL, 0x000fe80003800000ULL,
0x00000000005c1947ULL, 0x000fea0003800000ULL, 0x0000001a5f00720cULL, 0x000fe20003f44070ULL,
0x000000011b147836ULL, 0x002fe20000000000ULL, 0x00009400ff187b82ULL, 0x000e680000000800ULL,
0x0000000314167812ULL, 0x000fc800078ec0ffULL, 0x000000ff16197207ULL, 0x000fc60005000000ULL,
0x00000002ff14a819ULL, 0x000fe40000011614ULL, 0x000000015c167824ULL, 0x000fc600078e0219ULL,
0x000000011d1d7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000ea40000000a00ULL,
0x000000401d177824ULL, 0x040fe200078e00ffULL, 0x0000001a1d1a7211ULL, 0x000fc800078ff0ffULL,
0x000000c017177812ULL, 0x000fca00078ec0ffULL, 0x000001001a177824ULL, 0x000fc800078e0217ULL,
0x000000016e197824ULL, 0x100fe400078e0217ULL, 0x0000001816177224ULL, 0x002fc600078e0217ULL,
0x0000000919007c0cULL, 0x000fe4000bf46070ULL, 0x000000176e177210ULL, 0x000fe40007ffe0ffULL,
0x000000076e197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000417147825ULL, 0x004fcc00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4dULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b801cff1479a7ULL, 0x000e620008500007ULL, 0x000000ff6c00720cULL, 0x000fe20003f45270ULL,
0x000000ffff6d7224ULL, 0x002fd800078e0015ULL, 0x00000004008c2947ULL, 0x000fea0003800000ULL,
0x018af81c5d1479a7ULL, 0x000e640008500007ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000167805ULL, 0x000fc60000015200ULL, 0x018af8185d0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff197224ULL, 0x000fce00078e00ffULL,
0x000000101900780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416147210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011415ULL,
0x0000001407077211ULL, 0x000fca00078510ffULL, 0x000000ffff147224ULL, 0x000fca00010e0615ULL,
0x0000000207077819ULL, 0x000fc80000001214ULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000119197836ULL, 0x000fce0000000000ULL,
0x018af8185d0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001012077824ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011612ULL,
0x000000ffff167224ULL, 0x000fc600078e0009ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c14147812ULL, 0x000fc800078ec0ffULL, 0x00000007141b7c10ULL, 0x000fca000fffe007ULL,
0x018080001b147984ULL, 0x000e680000000800ULL, 0x018280001b157984ULL, 0x0004a20000000800ULL,
0x000000091400720bULL, 0x002fda0003f5d000ULL, 0x0000000000077806ULL, 0x000fc800010e0100ULL,
0x0000ffff07187812ULL, 0x000fe2000784c0ffULL, 0x00000001ff077424ULL, 0x000fd800078e00ffULL,
0x0000000000e0a947ULL, 0x004fea0003800000ULL, 0x000000091400720bULL, 0x000fe40003f54000ULL,
0x000000016100780cULL, 0x000fe40003f65270ULL, 0x0000001409167209ULL, 0x000fd20007810000ULL,
0x0000000000197806ULL, 0x000fe400010e0100ULL, 0x018480161b00b388ULL, 0x0003e40000000800ULL,
0x0000991019177816ULL, 0x000fc800000000ffULL, 0x000000ff1700720cULL, 0x000fda0003f45270ULL,
0x0000000000a8a947ULL, 0x002fea0003800000ULL, 0x8000001609097221ULL, 0x000fe20000010000ULL,
0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL, 0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x0000000900177308ULL, 0x0002ac0000000800ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x00001f6417097589ULL, 0x006e6400000e0000ULL,
0x000000090b0b7220ULL, 0x082fe20000410000ULL, 0x000000090c0c7220ULL, 0x080fe20000410000ULL,
0x000000090f0f7220ULL, 0x080fe20000410000ULL, 0x0000000910107220ULL, 0x080fe20000410000ULL,
0x0000000941417220ULL, 0x080fe20000410000ULL, 0x0000000942427220ULL, 0x080fe20000410000ULL,
0x0000000945457220ULL, 0x080fe20000410000ULL, 0x0000000946467220ULL, 0x080fe20000410000ULL,
0x0000000949497220ULL, 0x080fe20000410000ULL, 0x000000094a4a7220ULL, 0x080fe20000410000ULL,
0x000000094d4d7220ULL, 0x080fe20000410000ULL, 0x000000094e4e7220ULL, 0x080fe20000410000ULL,
0x0000000951517220ULL, 0x080fe20000410000ULL, 0x0000000952527220ULL, 0x080fe20000410000ULL,
0x0000000957577220ULL, 0x080fe20000410000ULL, 0x0000000958587220ULL, 0x000fce0000410000ULL,
0x000000170a0a7220ULL, 0x004fe20000410000ULL, 0x000000000044b947ULL, 0x000fec0003800000ULL,
0x00001f6317097589ULL, 0x002e6400000e0000ULL, 0x000000090d0d7220ULL, 0x082fe20000410000ULL,
0x000000090e0e7220ULL, 0x080fe20000410000ULL, 0x0000000911117220ULL, 0x080fe20000410000ULL,
0x0000000940407220ULL, 0x080fe20000410000ULL, 0x0000000943437220ULL, 0x080fe20000410000ULL,
0x0000000944447220ULL, 0x080fe20000410000ULL, 0x0000000947477220ULL, 0x080fe20000410000ULL,
0x0000000948487220ULL, 0x080fe20000410000ULL, 0x000000094b4b7220ULL, 0x080fe20000410000ULL,
0x000000094c4c7220ULL, 0x080fe20000410000ULL, 0x000000094f4f7220ULL, 0x080fe20000410000ULL,
0x0000000950507220ULL, 0x080fe20000410000ULL, 0x0000000953537220ULL, 0x080fe20000410000ULL,
0x0000000956567220ULL, 0x080fe20000410000ULL, 0x0000000959597220ULL, 0x080fe20000410000ULL,
0x000000095a5a7220ULL, 0x000fce0000410000ULL, 0x0000ffff18ff7812ULL, 0x000fda0007846019ULL,
0x8000001614142221ULL, 0x000fe20000010000ULL, 0x00007610ff072816ULL, 0x000fc60000000007ULL,
0x3fb8aa3b14142820ULL, 0x000fc80000410000ULL, 0x0000001400062308ULL, 0x000ea40000000800ULL,
0x0000000615152220ULL, 0x004fce0000410000ULL, 0x0000000a150a7221ULL, 0x000fe20000010000ULL,
0x000000ffff097224ULL, 0x002fce00078e0016ULL, 0x000000ff07ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x000fc800000010ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6414037589ULL, 0x0002a800000e0000ULL,
0x00001f6314047589ULL, 0x0002e400000e0000ULL, 0x01280000052c783bULL, 0x0002e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x000000032c2c7232ULL, 0x08cfe40000200000ULL,
0x000000032e2e7232ULL, 0x000fe40000200000ULL, 0x000000042d2d7232ULL, 0x080fe40000200000ULL,
0x000000042f2f7232ULL, 0x000fce0000200000ULL, 0x000000000218783bULL, 0x000f280000004200ULL,
0x000000000014783bULL, 0x002e620000004200ULL, 0x0000010018207824ULL, 0x010fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe20000011419ULL, 0x0000010019217824ULL, 0x040fe200078e00ffULL,
0x00008880193d7816ULL, 0x040fe200000000ffULL, 0x000100001a227824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x000100001b237824ULL, 0x000fe200078e00ffULL,
0x0000002000397306ULL, 0x0009e20000202400ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0001000017387824ULL, 0x002fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fc40000011418ULL,
0x00008880183c7816ULL, 0x040fe200000000ffULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011419ULL, 0x00000021002a7306ULL, 0x0003e20000202400ULL,
0x000001001a207824ULL, 0x050fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141aULL,
0x000088801a197816ULL, 0x000fe400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002200357306ULL, 0x0009e20000202400ULL, 0x000001001b217824ULL, 0x002fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fc40000011414ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000020001a7306ULL, 0x0003e20000202400ULL,
0x0000010014227824ULL, 0x010fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141bULL,
0x000088801b327816ULL, 0x000fe400000000ffULL, 0x00000018ff347819ULL, 0x000fc40000011423ULL,
0x00000021001b7306ULL, 0x0009e20000202400ULL, 0x0000888014207816ULL, 0x042fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fe20000011422ULL,
0x0000010015227824ULL, 0x040fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011415ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000001f001f7306ULL, 0x000fe20000202400ULL,
0x0000888015217816ULL, 0x050fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fc40000011416ULL, 0x0000888016287816ULL, 0x000fe400000000ffULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000001800187306ULL, 0x000fe20000202400ULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x0000888017297816ULL, 0x000fe400000000ffULL,
0x00000018ff317819ULL, 0x000fe40000011417ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000003d003d7306ULL, 0x000e700000202400ULL, 0x0000001900197306ULL, 0x000f220000202400ULL,
0x000054103d3d7816ULL, 0x002fce000000002aULL, 0x0000003200327306ULL, 0x000e700000202400ULL,
0x0000001400277306ULL, 0x000bf00000202400ULL, 0x0000001500267306ULL, 0x0003e20000202400ULL,
0x0000010016147824ULL, 0x028fc400078e00ffULL, 0x0001000016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000010017157824ULL, 0x006fe200078e00ffULL, 0x00000014002b7306ULL, 0x0003e80000202400ULL,
0x00000018ff367819ULL, 0x000fc80000011415ULL, 0x0000001e001e7306ULL, 0x000fe20000202400ULL,
0x0000541018147816ULL, 0x002fe4000000001fULL, 0x0000541019187816ULL, 0x010fe4000000001aULL,
0x0000541032197816ULL, 0x000fc6000000001bULL, 0x0000001c001c7306ULL, 0x000e680000202400ULL,
0x000000182c18723cULL, 0x000fe800000418ffULL, 0x0000001d001d7306ULL, 0x000fe20000202400ULL,
0x00005410351c7816ULL, 0x002fce000000001cULL, 0x0000002400247306ULL, 0x000e700000202400ULL,
0x0000002500257306ULL, 0x000ea20000202400ULL, 0x0000541027247816ULL, 0x002fce0000000024ULL,
0x0000003c003c7306ULL, 0x000e620000202400ULL, 0x0000541026257816ULL, 0x004fce0000000025ULL,
0x0000003700377306ULL, 0x000ea20000202400ULL, 0x000000242c24723cULL, 0x000fe200000418ffULL,
0x000054103c3c7816ULL, 0x002fcc0000000039ULL, 0x0000003400347306ULL, 0x000e620000202400ULL,
0x0000003c2c3c723cULL, 0x000fe200000418ffULL, 0x0000541037157816ULL, 0x004fcc000000001eULL,
0x0000002000207306ULL, 0x000fe20000202400ULL, 0x00005410341d7816ULL, 0x002fce000000001dULL,
0x0000002300237306ULL, 0x000e620000202400ULL, 0x0000001c2c1c723cULL, 0x000fee00000418ffULL,
0x0000002100217306ULL, 0x000fe20000202400ULL, 0x0000541020207816ULL, 0x002fce0000000023ULL,
0x0000002200227306ULL, 0x000e700000202400ULL, 0x0000002800287306ULL, 0x000ea20000202400ULL,
0x0000541021217816ULL, 0x002fce0000000022ULL, 0x0000002900297306ULL, 0x000fe20000202400ULL,
0x000000202c20723cULL, 0x000fe200000418ffULL, 0x0000541028287816ULL, 0x004fcc000000002bULL,
0x00000036002a7306ULL, 0x000e700000202400ULL, 0x0000003000307306ULL, 0x000fe20000202400ULL,
0x0000541029297816ULL, 0x002fce000000002aULL, 0x0000003100317306ULL, 0x000fe20000202400ULL,
0x000000282c28723cULL, 0x000fee00000418ffULL, 0x0000001600337306ULL, 0x0002b00000202400ULL,
0x0000003800327306ULL, 0x000ee20000202400ULL, 0x000000142c14723cULL, 0x002fe200000418ffULL,
0x0000541033307816ULL, 0x004fc40000000030ULL, 0x0000541032317816ULL, 0x008fce0000000031ULL,
0x000000302c2c723cULL, 0x000fe200000418ffULL, 0x012800005e30783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000431317232ULL, 0x080fe40000200000ULL, 0x0000000433337232ULL, 0x000fce0000200000ULL,
0x000000006234783bULL, 0x000ee20000004200ULL, 0x0000006c6400720cULL, 0x000fe20003f66070ULL,
0x0000084000007945ULL, 0x000fe20003800000ULL, 0x000000085f00720cULL, 0x000fe20003fc3070ULL,
0x000000006038783bULL, 0x000f220000004200ULL, 0x0000006c6300720cULL, 0x000fe40003f86070ULL,
0x000000085f00720cULL, 0x000fe40003fa3070ULL, 0x0000888034547816ULL, 0x048fe200000000ffULL,
0x0000010034557824ULL, 0x040fe200078e00ffULL, 0x00008880356f7816ULL, 0x040fe200000000ffULL,
0x0000010035717824ULL, 0x040fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe20000011434ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011435ULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x00000018ff747819ULL, 0x000fc40000011471ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff717819ULL, 0x000fe20000011436ULL, 0x0000005500557306ULL, 0x000ee20000202400ULL,
0x00008880387a7816ULL, 0x010fe400000000ffULL, 0x00000018ff777819ULL, 0x000fca000001143bULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x0000541054547816ULL, 0x008fce0000000055ULL,
0x0000007400747306ULL, 0x000ef00000202400ULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x000054106f557816ULL, 0x008fce0000000074ULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x0000000836747819ULL, 0x040fe400000006ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011437ULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x00000054303c723cULL, 0x004fe4000004183cULL,
0x0000003400347306ULL, 0x000eaa0000202400ULL, 0x0000888036547816ULL, 0x000fc400000000ffULL,
0x00000018ff557819ULL, 0x000fe20000011438ULL, 0x0000003500357306ULL, 0x000ee20000202400ULL,
0x0000541034347816ULL, 0x004fce0000000073ULL, 0x0000007400747306ULL, 0x000fe20000202400ULL,
0x0000541035357816ULL, 0x008fce0000000072ULL, 0x0000005400737306ULL, 0x0004e20000202400ULL,
0x0000888037727816ULL, 0x040fe200000000ffULL, 0x000000343014723cULL, 0x000fec0000041814ULL,
0x0000007100717306ULL, 0x000fe20000202400ULL, 0x00000018ff547819ULL, 0x004fe2000001143aULL,
0x0000010037357824ULL, 0x000fc400078e00ffULL, 0x000000ffff347224ULL, 0x000fc800078e0072ULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff727819ULL, 0x000fc80000011439ULL,
0x0000003400757306ULL, 0x0007f00000202400ULL, 0x0000003500767306ULL, 0x000ea20000202400ULL,
0x0000541073347816ULL, 0x008fe20000000074ULL, 0x0001000036737824ULL, 0x000fca00078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011473ULL, 0x0000007a007a7306ULL, 0x000fe20000202400ULL,
0x0000541075357816ULL, 0x004fce0000000076ULL, 0x0000007300747306ULL, 0x0004e20000202400ULL,
0x00000018ff767819ULL, 0x000fe20000011437ULL, 0x000000343018723cULL, 0x000fec0000041818ULL,
0x0000007600767306ULL, 0x000f220000202400ULL, 0x0000010039737824ULL, 0x044fe400078e00ffULL,
0x0000010038347824ULL, 0x040fe200078e00ffULL, 0x0000888039357816ULL, 0x040fe200000000ffULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011473ULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x00000018ff737819ULL, 0x000fc40000011439ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x000088803a397816ULL, 0x000fc600000000ffULL,
0x0000003400377306ULL, 0x0006b00000202400ULL, 0x0000007800787306ULL, 0x000fe20000202400ULL,
0x0000541074347816ULL, 0x008fce0000000071ULL, 0x0000003500717306ULL, 0x0008f00000202400ULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x0000541076357816ULL, 0x010fce000000006fULL,
0x00000034301c723cULL, 0x000fe2000004181cULL, 0x0000003800747306ULL, 0x00096c0000202400ULL,
0x000001003a347824ULL, 0x040fe400078e00ffULL, 0x000001003b357824ULL, 0x040fe200078e00ffULL,
0x0000007300737306ULL, 0x000ea20000202400ULL, 0x000088803b387816ULL, 0x050fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fc60000011435ULL,
0x0000003400767306ULL, 0x0005e20000202400ULL, 0x00000018ff3b7819ULL, 0x000fce000001143bULL,
0x00000035006f7306ULL, 0x0007e20000202400ULL, 0x000054107a347816ULL, 0x004fe40000000037ULL,
0x00000018ff377819ULL, 0x000fe2000001143aULL, 0x000000016c3a7836ULL, 0x000fc80000000000ULL,
0x0000003900397306ULL, 0x000ea20000202400ULL, 0x0000541071357816ULL, 0x008fe40000000078ULL,
0x0000003a6400720cULL, 0x080fe40005f66470ULL, 0x0000003a6300720cULL, 0x000fc60006786470ULL,
0x0000003800387306ULL, 0x000ee20000202400ULL, 0x000000343020723cULL, 0x000fee0000041820ULL,
0x0000541074347816ULL, 0x022fe20000000055ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x0000541073357816ULL, 0x000fce0000000072ULL, 0x0000007700367306ULL, 0x000fe20000202400ULL,
0x000000343024723cULL, 0x000fee0000041824ULL, 0x0000003700377306ULL, 0x000e620000202400ULL,
0x0000541039347816ULL, 0x004fe40000000076ULL, 0x0000541038357816ULL, 0x008fca000000006fULL,
0x0000003b003b7306ULL, 0x000ea40000202400ULL, 0x000000343028723cULL, 0x000fee0000041828ULL,
0x0000541037347816ULL, 0x002fe40000000054ULL, 0x000054103b357816ULL, 0x004fe20000000036ULL,
0x00000001ff367424ULL, 0x000fcc00078e00ffULL, 0x00000034302c723cULL, 0x000fe2000004182cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000403947ULL, 0x000fde0003000000ULL,
0x0000003c0b0b7221ULL, 0x000fe20000010000ULL, 0x0000003d0c0c7221ULL, 0x000fe20000010000ULL,
0x000000140f0f7221ULL, 0x000fe20000010000ULL, 0x0000001510107221ULL, 0x000fe20000010000ULL,
0x0000001841417221ULL, 0x000fe20000010000ULL, 0x0000001942427221ULL, 0x000fe20000010000ULL,
0x0000001c45457221ULL, 0x000fe20000010000ULL, 0x0000001d46467221ULL, 0x000fe20000010000ULL,
0x0000002049497221ULL, 0x000fe20000010000ULL, 0x000000214a4a7221ULL, 0x000fe20000010000ULL,
0x000000244d4d7221ULL, 0x000fe20000010000ULL, 0x000000254e4e7221ULL, 0x000fe20000010000ULL,
0x0000002851517221ULL, 0x000fe20000010000ULL, 0x0000002952527221ULL, 0x000fe20000010000ULL,
0x0000002c57577221ULL, 0x000fe20000010000ULL, 0x0000002d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe80003800000ULL,
0x0000000000404947ULL, 0x000fea0002800000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0e0e7221ULL, 0x000fe20000010000ULL, 0x0000001611117221ULL, 0x000fe20000010000ULL,
0x0000001740407221ULL, 0x000fe20000010000ULL, 0x0000001a43437221ULL, 0x000fe20000010000ULL,
0x0000001b44447221ULL, 0x000fe20000010000ULL, 0x0000001e47477221ULL, 0x000fe20000010000ULL,
0x0000001f48487221ULL, 0x000fe20000010000ULL, 0x000000224b4b7221ULL, 0x000fe20000010000ULL,
0x000000234c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002750507221ULL, 0x000fe20000010000ULL, 0x0000002a53537221ULL, 0x000fe20000010000ULL,
0x0000002b56567221ULL, 0x000fe20000010000ULL, 0x0000002e59597221ULL, 0x000fe20000010000ULL,
0x0000002f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018b8836ff1479a7ULL, 0x000e620008500007ULL, 0x00000002ff177819ULL, 0x000fe4000001163aULL,
0x000000085f00720cULL, 0x0c0fe40003fc3070ULL, 0x000000173a177207ULL, 0x040fe40000000000ULL,
0x000000033a1a7812ULL, 0x000fe400078ec0ffULL, 0x000000085f00720cULL, 0x000fe20003fa3070ULL,
0x0000000117177836ULL, 0x000fe20000000000ULL, 0x00000040ff347803ULL, 0x000fc40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fe40004000000ULL, 0x00000003171b7812ULL, 0x040fe400078ec0ffULL,
0x00000008171c7211ULL, 0x000fe200078ff0ffULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000167805ULL, 0x000fe20000015200ULL, 0x018b806dff0075a7ULL, 0x000e6400080c0147ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b806dff0075a7ULL, 0x000e6400080c0147ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fe20000015200ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x000000041c147824ULL, 0x000fc800078e021bULL, 0x00000040141e7824ULL, 0x000fe400078e00ffULL,
0x000000011c147836ULL, 0x000fc60000000000ULL, 0x000000405b1d7812ULL, 0x000fe400078ef81eULL,
0x0000000c14007c0cULL, 0x000fda000bfc6070ULL, 0x000000040054e947ULL, 0x000fea0003800000ULL,
0x000000015d207824ULL, 0x000fe200078e0270ULL, 0x000000091e187c48ULL, 0x000fe2000ffe0000ULL,
0x00000010121f7824ULL, 0x000fe200078e00ffULL, 0x00014000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000000120177824ULL, 0x040fe200078e021dULL, 0x0000000720227c11ULL, 0x000fe2000f8e10ffULL,
0x0000000118187824ULL, 0x000fe200078e0a1eULL, 0x000000f01f1f7812ULL, 0x000fc600078ec0ffULL,
0x018a000022147984ULL, 0x000e620000000800ULL, 0x000000185d187248ULL, 0x000fca0007fe0000ULL,
0x0000000118217824ULL, 0x000fe200078e0a5dULL, 0x0000000714197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019167984ULL, 0x0004e40000000800ULL,
0x0000000120197824ULL, 0x044fe400078e0212ULL, 0x0000001020207824ULL, 0x000fca00078e00ffULL,
0xfffffff020197812ULL, 0x000fe200078ee219ULL, 0x0000000270207836ULL, 0x000fc60000000000ULL,
0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL, 0x000000015d247824ULL, 0x000fc800078e0220ULL,
0x0000000124197824ULL, 0x000fe400078e021dULL, 0x0000000616177c24ULL, 0x008fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000001f16167210ULL, 0x000fc80007fde0ffULL,
0x00000017ff177210ULL, 0x000fe400037fe4ffULL, 0x000000217000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000f101c4aULL,
0x018a080022187984ULL, 0x000ea20000000800ULL, 0x0000000124167824ULL, 0x042fe400078e0212ULL,
0x0000001024177824ULL, 0x000fca00078e00ffULL, 0xfffffff017167812ULL, 0x000fc800078ee216ULL,
0x0000000e16237c11ULL, 0x000fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000001f18187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x000000212000720cULL, 0x000fe20003fc6070ULL,
0x0000000470207836ULL, 0x000fe40000000000ULL, 0x0000000670707836ULL, 0x000fe40000000000ULL,
0x000000015d247824ULL, 0x000fc800078e0220ULL, 0x0000000124177824ULL, 0x000fc800078e021dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000f101c4aULL,
0x018a100022167984ULL, 0x000ea20000000800ULL, 0x0000000124187824ULL, 0x042fe400078e0212ULL,
0x0000001024197824ULL, 0x000fca00078e00ffULL, 0xfffffff019187812ULL, 0x000fc800078ee218ULL,
0x0000000e18197c11ULL, 0x000fe4000f8e20ffULL, 0x00000007161e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x0002a40000000800ULL, 0x000000015d1e7824ULL, 0x002fc800078e0270ULL,
0x000000011e1d7824ULL, 0x000fe400078e021dULL, 0x0000000616177c24ULL, 0x004fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000001f16167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x000000212000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000f101c4aULL,
0x018a180022187984ULL, 0x000ea20000000800ULL, 0x000000011e167824ULL, 0x042fe400078e0212ULL,
0x000000101e177824ULL, 0x000fca00078e00ffULL, 0xfffffff017167812ULL, 0x000fc800078ee216ULL,
0x0000000e16177c11ULL, 0x000fe4000f8e20ffULL, 0x0000000718187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x00000006181d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc600078e0014ULL, 0x0000001f14147210ULL, 0x000fca0007fde0ffULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x000000217000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000f101c4aULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015d707824ULL, 0x000fe200078e0270ULL,
0x00014000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000001012197824ULL, 0x000fe400078e00ffULL,
0x0000000170177824ULL, 0x040fe200078e021dULL, 0x00000007701f7c11ULL, 0x040fe2000f8e10ffULL,
0x00000010701e7824ULL, 0x040fe200078e00ffULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x0000000170197824ULL, 0x000fe400078e0212ULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x0000000270207836ULL, 0x000fc40000000000ULL, 0xfffffff01e197812ULL, 0x000fe400078ee219ULL,
0x0000000120227824ULL, 0x040fe400078e0212ULL, 0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000120197824ULL, 0x000fe200078e021dULL, 0x0000000714187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ea40000000800ULL,
0x0000000616177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4aULL,
0x018a08001f187984ULL, 0x000ea20000000800ULL, 0x0000001020177824ULL, 0x002fe400078e00ffULL,
0x0000000470207836ULL, 0x000fe40000000000ULL, 0x0000000670707836ULL, 0x000fe20000000000ULL,
0xfffffff017227812ULL, 0x000fe200078ee222ULL, 0x0000000120177824ULL, 0x000fc400078e021dULL,
0x00000001701d7824ULL, 0x000fe200078e021dULL, 0x0000000e22237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000120227824ULL, 0x000fe200078e0212ULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fc80007fde0ffULL,
0x00000019ff197210ULL, 0x000fca00037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000b901c4aULL, 0x018a10001f167984ULL, 0x000ea20000000800ULL,
0x0000001020197824ULL, 0x002fca00078e00ffULL, 0xfffffff019227812ULL, 0x000fc800078ee222ULL,
0x0000000e22197c11ULL, 0x000fe4000f8e20ffULL, 0x00000007161e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x000e640000000800ULL, 0x0000000616177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e8000b901c4aULL, 0x018a18001f187984ULL, 0x000ea40000000800ULL,
0x0000000718187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ea40000000800ULL,
0x00000006181d7c24ULL, 0x004fc8000f8e021dULL, 0x000001001d147825ULL, 0x000fc800078e0014ULL,
0x00000001701d7824ULL, 0x040fe200078e0212ULL, 0x0000002114147210ULL, 0x000fe20007fde0ffULL,
0x0000001070707824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0xfffffff0701d7812ULL, 0x000fc800078ee21dULL, 0x0000000e1d1d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e4000b901c4aULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000001ff707424ULL, 0x000fc600078e00ffULL, 0x0000000000581947ULL, 0x000fea0003800000ULL,
0x0000001c5f00720cULL, 0x000fe20003fc4070ULL, 0x00009400ff187b82ULL, 0x000e620000000800ULL,
0x000000076e197c11ULL, 0x000fe4000f8e10ffULL, 0x000000ff1a147207ULL, 0x040fe40003000000ULL,
0x000000ff1a177207ULL, 0x000fc60007000000ULL, 0x000000011b1b7824ULL, 0x000fe400078e0214ULL,
0x00009200ff147b82ULL, 0x000ea20000000a00ULL, 0x000000015c177824ULL, 0x000fe400078e0217ULL,
0x000000401b167824ULL, 0x040fe200078e00ffULL, 0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL,
0x000000c016167812ULL, 0x000fca00078ec0ffULL, 0x000001001b167824ULL, 0x000fc800078e0216ULL,
0x0000002016167836ULL, 0x000fc80000000000ULL, 0x0000001817177224ULL, 0x102fe400078e0216ULL,
0x000000016e167824ULL, 0x040fe400078e0216ULL, 0x000000016e177824ULL, 0x000fc600078e0217ULL,
0x0000000916007c0cULL, 0x000fe2000bfc6070ULL, 0x0000000417147825ULL, 0x004fd800078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000f12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a48ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b7870ff7079a7ULL, 0x000e620008500007ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000010ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6414037589ULL, 0x0004e800000e0000ULL, 0x00001f6314047589ULL, 0x00046400000e0000ULL,
0x01280000672c783bULL, 0x0004e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000032c2c7232ULL, 0x088fe40000200000ULL, 0x000000032e2e7232ULL, 0x000fe40000200000ULL,
0x000000042d2d7232ULL, 0x082fe40000200000ULL, 0x000000042f2f7232ULL, 0x000fce0000200000ULL,
0x000000006618783bULL, 0x000f280000004200ULL, 0x000000006514783bULL, 0x004ea20000004200ULL,
0x0000010018207824ULL, 0x010fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe20000011419ULL,
0x0000010019217824ULL, 0x040fe200078e00ffULL, 0x00008880193d7816ULL, 0x040fe200000000ffULL,
0x000100001a227824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x000100001b237824ULL, 0x000fe200078e00ffULL, 0x0000002000397306ULL, 0x0009e20000202400ULL,
0x00000018ff227819ULL, 0x000fc40000011422ULL, 0x00008880183c7816ULL, 0x040fe400000000ffULL,
0x00000018ff1f7819ULL, 0x000fe20000011418ULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011419ULL, 0x00000021002a7306ULL, 0x000be20000202400ULL,
0x000000081a207819ULL, 0x010fe400000006ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141aULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x000088801a197816ULL, 0x000fe200000000ffULL,
0x0000002200357306ULL, 0x0009e20000202400ULL, 0x000001001b217824ULL, 0x028fe200078e00ffULL,
0x00000018ff247819ULL, 0x004fe40000011414ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000003c003c7306ULL, 0x000ea20000202400ULL,
0x0000010014227824ULL, 0x010fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fc4000001141bULL,
0x000088801b327816ULL, 0x000fe400000000ffULL, 0x00000018ff367819ULL, 0x000fe40000011423ULL,
0x00000020001a7306ULL, 0x0007e20000202400ULL, 0x00000018ff237819ULL, 0x000fe20000011422ULL,
0x0000010015227824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011415ULL,
0x00000018ff307819ULL, 0x000fe40000011416ULL, 0x0000888016287816ULL, 0x000fe200000000ffULL,
0x00000021001b7306ULL, 0x0009e20000202400ULL, 0x0000888014207816ULL, 0x048fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x000054103c3c7816ULL, 0x004fe20000000039ULL,
0x0001000017397824ULL, 0x000fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fc40000011422ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000001f001f7306ULL, 0x000fe20000202400ULL,
0x0000888015217816ULL, 0x050fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x0000888017297816ULL, 0x000fe400000000ffULL, 0x00000018ff317819ULL, 0x000fe40000011417ULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000001800187306ULL, 0x000fe20000202400ULL,
0x00000018ff397819ULL, 0x000fce0000011439ULL, 0x0000003d003d7306ULL, 0x000eb00000202400ULL,
0x0000001900197306ULL, 0x000ee20000202400ULL, 0x000054103d3d7816ULL, 0x004fce000000002aULL,
0x0000003200327306ULL, 0x000ea20000202400ULL, 0x0000003c2c3c723cULL, 0x000fee00000418ffULL,
0x0000001400277306ULL, 0x0009f00000202400ULL, 0x0000001500267306ULL, 0x000be20000202400ULL,
0x0000010016147824ULL, 0x010fc400078e00ffULL, 0x0001000016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000010017157824ULL, 0x022fe200078e00ffULL, 0x00000014002b7306ULL, 0x0003e80000202400ULL,
0x00000018ff387819ULL, 0x000fc80000011415ULL, 0x0000001e001e7306ULL, 0x000fe20000202400ULL,
0x0000541018147816ULL, 0x002fe4000000001fULL, 0x0000541019187816ULL, 0x008fe4000000001aULL,
0x0000541032197816ULL, 0x004fc6000000001bULL, 0x0000001c001c7306ULL, 0x000e680000202400ULL,
0x000000182c18723cULL, 0x000fe800000418ffULL, 0x0000001d001d7306ULL, 0x000fe20000202400ULL,
0x00005410351c7816ULL, 0x002fce000000001cULL, 0x0000002400247306ULL, 0x000e700000202400ULL,
0x0000002500257306ULL, 0x000ea20000202400ULL, 0x0000541027247816ULL, 0x002fce0000000024ULL,
0x0000003700377306ULL, 0x000e620000202400ULL, 0x0000541026257816ULL, 0x004fce0000000025ULL,
0x0000003600367306ULL, 0x000ea20000202400ULL, 0x000000242c24723cULL, 0x000fe200000418ffULL,
0x0000541037157816ULL, 0x002fcc000000001eULL, 0x0000002000207306ULL, 0x000fe20000202400ULL,
0x00005410361d7816ULL, 0x004fce000000001dULL, 0x0000002300237306ULL, 0x000e620000202400ULL,
0x0000001c2c1c723cULL, 0x000fee00000418ffULL, 0x0000002100217306ULL, 0x000fe20000202400ULL,
0x0000541020207816ULL, 0x002fce0000000023ULL, 0x0000002200227306ULL, 0x000e700000202400ULL,
0x0000002800287306ULL, 0x000ea20000202400ULL, 0x0000541021217816ULL, 0x002fce0000000022ULL,
0x0000002900297306ULL, 0x000fe20000202400ULL, 0x000000202c20723cULL, 0x000fe200000418ffULL,
0x0000541028287816ULL, 0x004fcc000000002bULL, 0x00000038002a7306ULL, 0x000e700000202400ULL,
0x0000003000307306ULL, 0x000fe20000202400ULL, 0x0000541029297816ULL, 0x002fce000000002aULL,
0x0000003100317306ULL, 0x000fe20000202400ULL, 0x000000282c28723cULL, 0x000fee00000418ffULL,
0x0000001600337306ULL, 0x0002b00000202400ULL, 0x0000003900327306ULL, 0x000ee20000202400ULL,
0x000000142c14723cULL, 0x002fe200000418ffULL, 0x0000541033307816ULL, 0x004fc40000000030ULL,
0x0000541032317816ULL, 0x008fce0000000031ULL, 0x000000302c2c723cULL, 0x000fe200000418ffULL,
0x012800006830783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000102947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000431317232ULL, 0x080fe40000200000ULL,
0x0000000433337232ULL, 0x000fce0000200000ULL, 0x000000ff3400720cULL, 0x000fe20003f45270ULL,
0x000000006938783bULL, 0x000ee20000004200ULL, 0x000007c000007945ULL, 0x000fe60003800000ULL,
0x000000006a34783bULL, 0x000f220000004200ULL, 0x0000888038777816ULL, 0x008fe400000000ffULL,
0x00000018ff737819ULL, 0x010fe20000011434ULL, 0x0000010034557824ULL, 0x040fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011435ULL, 0x00000100356d7824ULL, 0x040fe200078e00ffULL,
0x0000888034547816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000888035747816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x0000007300737306ULL, 0x000fe20000202400ULL, 0x00000018ff557819ULL, 0x000fc40000011455ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff757819ULL, 0x000fe2000001146dULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x00000018ff6e7819ULL, 0x000fe40000011437ULL, 0x00000018ff6f7819ULL, 0x000fe40000011436ULL,
0x00000018ff6d7819ULL, 0x000fc60000011438ULL, 0x0000003400347306ULL, 0x000ef00000202400ULL,
0x0000003500357306ULL, 0x000f220000202400ULL, 0x0000541034347816ULL, 0x008fce0000000073ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x0000888036737816ULL, 0x000fe400000000ffULL,
0x0000541035357816ULL, 0x010fca0000000072ULL, 0x0000005500557306ULL, 0x000ee40000202400ULL,
0x000000343014723cULL, 0x004fec0000041814ULL, 0x0000007400747306ULL, 0x000fe20000202400ULL,
0x0000010037347824ULL, 0x000fe200078e00ffULL, 0x0000541054547816ULL, 0x008fcc0000000055ULL,
0x0000007500757306ULL, 0x000ea20000202400ULL, 0x00000018ff767819ULL, 0x000fe20000011434ULL,
0x0001000036347824ULL, 0x000fcc00078e00ffULL, 0x0000007300727306ULL, 0x0007e20000202400ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000541074557816ULL, 0x004fe20000000075ULL,
0x0000010036747824ULL, 0x000fe200078e00ffULL, 0x0000888037757816ULL, 0x000fc600000000ffULL,
0x0000007600767306ULL, 0x000fe20000202400ULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x000088803a737816ULL, 0x008fe400000000ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x00000054303c723cULL, 0x000fe2000004183cULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000007400357306ULL, 0x0004e20000202400ULL, 0x00000018ff367819ULL, 0x000fc6000001143bULL,
0x00000018ff557819ULL, 0x000fe40000011439ULL, 0x00000018ff547819ULL, 0x000fe4000001143aULL,
0x0000007500757306ULL, 0x000f220000202400ULL, 0x0000888039747816ULL, 0x004fce00000000ffULL,
0x0000003400787306ULL, 0x0007f00000202400ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x0000541072347816ULL, 0x008fe40000000035ULL, 0x0000541075357816ULL, 0x010fca0000000076ULL,
0x0000006e006e7306ULL, 0x000fe40000202400ULL, 0x000000343018723cULL, 0x000fec0000041818ULL,
0x0000003700377306ULL, 0x000ea20000202400ULL, 0x0000010038357824ULL, 0x000fe400078e00ffULL,
0x0000010039347824ULL, 0x000fc400078e00ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000007700777306ULL, 0x000fe20000202400ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff397819ULL, 0x000fca0000011439ULL,
0x0000003500767306ULL, 0x0004f00000202400ULL, 0x0000003400757306ULL, 0x0009e20000202400ULL,
0x0000541037357816ULL, 0x004fce000000006eULL, 0x0000007400747306ULL, 0x000ea20000202400ULL,
0x0000541078347816ULL, 0x010fe4000000006fULL, 0x000088803b6f7816ULL, 0x000fca00000000ffULL,
0x00000034301c723cULL, 0x000fe2000004181cULL, 0x0000006d006d7306ULL, 0x000fec0000202400ULL,
0x000001003b357824ULL, 0x040fe400078e00ffULL, 0x000001003a347824ULL, 0x040fe200078e00ffULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011435ULL, 0x000100003a357824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff377819ULL, 0x000fe4000001143bULL,
0x0000003800387306ULL, 0x000f220000202400ULL, 0x00000018ff357819ULL, 0x000fce0000011435ULL,
0x00000039006e7306ULL, 0x000f700000202400ULL, 0x0000003400727306ULL, 0x0007f00000202400ULL,
0x0000003500397306ULL, 0x0005e20000202400ULL, 0x0000541077347816ULL, 0x008fce0000000076ULL,
0x0000007300737306ULL, 0x000ee20000202400ULL, 0x0000541074357816ULL, 0x004fce0000000075ULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x000000343020723cULL, 0x000fee0000041820ULL,
0x00000078003a7306ULL, 0x000ea20000202400ULL, 0x0000541038347816ULL, 0x010fe4000000006dULL,
0x000054106e357816ULL, 0x022fca0000000055ULL, 0x0000005400547306ULL, 0x000e640000202400ULL,
0x000000343024723cULL, 0x000fec0000041824ULL, 0x0000003600367306ULL, 0x000fe20000202400ULL,
0x0000541073347816ULL, 0x008fe40000000072ULL, 0x000054106f357816ULL, 0x004fca000000003aULL,
0x0000003700377306ULL, 0x000ea40000202400ULL, 0x000000343028723cULL, 0x000fee0000041828ULL,
0x0000541039347816ULL, 0x002fe40000000054ULL, 0x0000541037357816ULL, 0x004fce0000000036ULL,
0x00000034302c723cULL, 0x000fe2000004182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000403947ULL, 0x000fde0001000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0c0c7221ULL, 0x000fe20000010000ULL, 0x000000140f0f7221ULL, 0x000fe20000010000ULL,
0x0000001510107221ULL, 0x000fe20000010000ULL, 0x0000001841417221ULL, 0x000fe20000010000ULL,
0x0000001942427221ULL, 0x000fe20000010000ULL, 0x0000001c45457221ULL, 0x000fe20000010000ULL,
0x0000001d46467221ULL, 0x000fe20000010000ULL, 0x0000002049497221ULL, 0x000fe20000010000ULL,
0x000000214a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002851517221ULL, 0x000fe20000010000ULL,
0x0000002952527221ULL, 0x000fe20000010000ULL, 0x0000002c57577221ULL, 0x000fe20000010000ULL,
0x0000002d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0e0e7221ULL, 0x000fe20000010000ULL,
0x0000001611117221ULL, 0x000fe20000010000ULL, 0x0000001740407221ULL, 0x000fe20000010000ULL,
0x0000001a43437221ULL, 0x000fe20000010000ULL, 0x0000001b44447221ULL, 0x000fe20000010000ULL,
0x0000001e47477221ULL, 0x000fe20000010000ULL, 0x0000001f48487221ULL, 0x000fe20000010000ULL,
0x000000224b4b7221ULL, 0x000fe20000010000ULL, 0x000000234c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002a53537221ULL, 0x000fe20000010000ULL, 0x0000002b56567221ULL, 0x000fe20000010000ULL,
0x0000002e59597221ULL, 0x000fe20000010000ULL, 0x0000002f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000016c6c7836ULL, 0x000fe40000000000ULL, 0x018b8816ff1479a7ULL, 0x000e660008500007ULL,
0x0000006b6c00720cULL, 0x000fe20003f46070ULL, 0x000000ffff187224ULL, 0x002fd800078e0015ULL,
0xffffffb0006ca947ULL, 0x000fea000383ffffULL, 0x0000008008147811ULL, 0x000fe200078e40ffULL,
0x018b6016ffff79a7ULL, 0x0003e60008500007ULL, 0x0000000914007c0cULL, 0x000fda000bf46070ULL,
0x0000009c00442947ULL, 0x002fea0003800000ULL, 0x000000ff006c7202ULL, 0x000fce0000000f00ULL,
0x00000002ff157819ULL, 0x000fe4000001166cULL, 0x000000036c1b7812ULL, 0x040fe400078ec0ffULL,
0x000000156c157207ULL, 0x000fe40000000000ULL, 0x000000ff1b1b7207ULL, 0x000fc60004000000ULL,
0x00000002151f7836ULL, 0x000fca0000000000ULL, 0x000000031f1d7812ULL, 0x040fe400078ec0ffULL,
0x000000081f1a7211ULL, 0x000fe400078ff0ffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b7871ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x018b7871ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x000000011a157836ULL, 0x000fe20000000000ULL,
0x00000004ff707819ULL, 0x000fe20000011612ULL, 0x000000041a147824ULL, 0x000fc600078e021dULL,
0x0000000c15007c0cULL, 0x000fe4000bf46070ULL, 0x0000002014187811ULL, 0x000fc800078e30ffULL,
0x000000605b1c7812ULL, 0x000fce00078ef818ULL, 0x000000040054a947ULL, 0x000fea0003800000ULL,
0x000000015d237824ULL, 0x000fe200078e0270ULL, 0x0000000918167c48ULL, 0x000fe2000ffe0000ULL,
0x00000010121e7824ULL, 0x000fe200078e00ffULL, 0x00016000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000000270227836ULL, 0x000fe20000000000ULL, 0x0000000723207c11ULL, 0x040fe2000f8e10ffULL,
0x0000000116167824ULL, 0x000fe200078e0a18ULL, 0x000000f01e257812ULL, 0x000fe200078ec0ffULL,
0x0000000123187824ULL, 0x000fe400078e021cULL, 0x018a000020147984ULL, 0x000e620000000800ULL,
0x000000165d167248ULL, 0x000fe20007fe0000ULL, 0x000000015d277824ULL, 0x000fc800078e0222ULL,
0x0000000116217824ULL, 0x000fe400078e0a5dULL, 0x0000000127247824ULL, 0x000fc600078e0212ULL,
0x000000217000720cULL, 0x000fe40003f46070ULL, 0x0000000714197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019177984ULL, 0x0004e40000000800ULL,
0x0000000127197824ULL, 0x044fe400078e021cULL, 0x0000001027277824ULL, 0x000fca00078e00ffULL,
0xfffffff027247812ULL, 0x000fe200078ee224ULL, 0x0000000617177c24ULL, 0x008fe4000f8e0218ULL,
0x0000000123187824ULL, 0x000fe400078e0212ULL, 0x0000010017167825ULL, 0x002fc800078e0014ULL,
0x0000001023237824ULL, 0x000fe200078e00ffULL, 0x0000002516167210ULL, 0x000fc80007f7e0ffULL,
0xfffffff023187812ULL, 0x000fe200078ee218ULL, 0x000000ffff177224ULL, 0x000fc600018e0617ULL,
0x0000000e18237c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x000000212200720cULL, 0x000fe20003f46070ULL,
0x0000000470227836ULL, 0x000fe40000000000ULL, 0x018a080020187984ULL, 0x000ea40000000800ULL,
0x000000015d277824ULL, 0x000fe200078e0222ULL, 0x0000000e24237c11ULL, 0x002fc6000f8e20ffULL,
0x0000000127247824ULL, 0x000fe200078e0212ULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002518167210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe400018e0619ULL, 0x0000000127197824ULL, 0x040fe400078e021cULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x000000212200720cULL, 0x000fc60003f46070ULL,
0x018a100020187984ULL, 0x000ea20000000800ULL, 0xfffffff027247812ULL, 0x000fc800078ee224ULL,
0x0000000e24237c11ULL, 0x002fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x0002a40000000800ULL, 0x00000006701e7836ULL, 0x002fc80000000000ULL,
0x000000015d277824ULL, 0x000fe400078e021eULL, 0x0000000618197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002518167210ULL, 0x000fc80007f7e0ffULL,
0x00000019ff177210ULL, 0x000fe20001ffe4ffULL, 0x0000000127197824ULL, 0x040fe400078e021cULL,
0x00000001271c7824ULL, 0x040fe400078e0212ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x0000001027277824ULL, 0x000fe200078e00ffULL,
0x000000211e00720cULL, 0x000fe40003f46070ULL, 0x018a180020187984ULL, 0x000ea40000000800ULL,
0xfffffff0271c7812ULL, 0x000fc800078ee21cULL, 0x0000000e1c177c11ULL, 0x002fe4000f8e20ffULL,
0x0000000718187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc600078e0014ULL,
0x0000002514147210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff157224ULL, 0x000fca00018e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d101c4aULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015d217824ULL, 0x000fe200078e0270ULL,
0x00016000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000001012197824ULL, 0x000fe400078e00ffULL,
0x0000000121177824ULL, 0x040fe200078e021cULL, 0x0000000721207c11ULL, 0x040fe2000f8e10ffULL,
0x00000010211e7824ULL, 0x000fe200078e00ffULL, 0x000000f019237812ULL, 0x000fe200078ec0ffULL,
0x0000000121197824ULL, 0x000fe400078e0212ULL, 0x018a000020147984ULL, 0x000e620000000800ULL,
0x0000000221277836ULL, 0x000fc40000000000ULL, 0xfffffff01e197812ULL, 0x000fe400078ee219ULL,
0x0000000127227824ULL, 0x000fe400078e0212ULL, 0x0000000e19257c11ULL, 0x000fe2000f8e20ffULL,
0x0000000127197824ULL, 0x040fe400078e021cULL, 0x0000001027277824ULL, 0x000fca00078e00ffULL,
0xfffffff027227812ULL, 0x000fe200078ee222ULL, 0x0000000421277836ULL, 0x000fe40000000000ULL,
0x0000000621217836ULL, 0x000fe20000000000ULL, 0x0000000714187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ea40000000800ULL,
0x0000000616177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000b901c4aULL,
0x018a080020187984ULL, 0x000ea20000000800ULL, 0x0000000e22257c11ULL, 0x002fe2000f8e20ffULL,
0x0000000127177824ULL, 0x040fe400078e021cULL, 0x0000000127227824ULL, 0x040fe400078e0212ULL,
0x0000001027277824ULL, 0x000fca00078e00ffULL, 0xfffffff027227812ULL, 0x000fe400078ee222ULL,
0x00000007181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002318187210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff197224ULL, 0x000fca00010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000b901c4aULL,
0x018a100020167984ULL, 0x000ea20000000800ULL, 0x0000000e22257c11ULL, 0x002fe2000f8e20ffULL,
0x0000000121197824ULL, 0x040fe400078e021cULL, 0x00000010211c7824ULL, 0x000fe200078e00ffULL,
0x00000007161e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x000e640000000800ULL,
0x0000000616177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000b901c4aULL,
0x018a180020187984ULL, 0x000ea40000000800ULL, 0x0000000718187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x0000000618197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc800078e0014ULL, 0x0000000121197824ULL, 0x000fe200078e0212ULL,
0x0000002314147210ULL, 0x000fc80007f5e0ffULL, 0xfffffff01c197812ULL, 0x000fe200078ee219ULL,
0x000000ffff157224ULL, 0x000fc600010e0615ULL, 0x0000000e19197c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e4000b901c4aULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fc80007f5e1ffULL, 0x0000001517157210ULL, 0x000fe400017fe5ffULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001a5f00720cULL, 0x000fe20003f44070ULL,
0x00000001ff1c7424ULL, 0x000fe200078e00ffULL, 0x000000011f1f7812ULL, 0x000fe200078ec0ffULL,
0x00000020616e7824ULL, 0x000fe200078e0212ULL, 0x000000031b00780cULL, 0x000fc80005745270ULL,
0x000000011f00780cULL, 0x000fda0001745470ULL, 0x00000000004c2947ULL, 0x000fea0003800000ULL,
0x000000036e00780cULL, 0x000fe20003f44070ULL, 0x0000000104047890ULL, 0x000fe2000fffe03fULL,
0x0000010000007945ULL, 0x000ff60003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff177b82ULL, 0x000e620000000800ULL, 0x000000050400728cULL, 0x000fe2000bf06070ULL,
0x0000000413167824ULL, 0x000fe200078e026eULL, 0x000000076e197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000216167824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ea20000000a00ULL, 0x0000000417187c36ULL, 0x002fc80008000000ULL,
0x0000001716177224ULL, 0x000fc800078e0218ULL, 0x0000000417147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000019000007945ULL, 0x000fe80003800000ULL,
0x00000000005c1947ULL, 0x000fea0003800000ULL, 0x0000001a5f00720cULL, 0x000fe20003f44070ULL,
0x000000011b147836ULL, 0x002fe20000000000ULL, 0x00009400ff187b82ULL, 0x000e680000000800ULL,
0x0000000314167812ULL, 0x000fc800078ec0ffULL, 0x000000ff16197207ULL, 0x000fc60005000000ULL,
0x00000002ff14a819ULL, 0x000fe40000011614ULL, 0x000000015c167824ULL, 0x000fc600078e0219ULL,
0x000000011d1d7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000ea40000000a00ULL,
0x000000401d177824ULL, 0x040fe200078e00ffULL, 0x0000001a1d1a7211ULL, 0x000fc800078ff0ffULL,
0x000000c017177812ULL, 0x000fca00078ec0ffULL, 0x000001001a177824ULL, 0x000fc800078e0217ULL,
0x000000016e197824ULL, 0x100fe400078e0217ULL, 0x0000001816177224ULL, 0x002fc600078e0217ULL,
0x0000000919007c0cULL, 0x000fe2000bf46070ULL, 0x000000016e177824ULL, 0x040fe200078e0217ULL,
0x000000076e197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000417147825ULL, 0x004fd000078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4dULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b801cff1479a7ULL, 0x000e620008500007ULL, 0x000000ff6c00720cULL, 0x000fe20003f45270ULL,
0x000000ffff6d7224ULL, 0x002fd800078e0015ULL, 0x00000004008c2947ULL, 0x000fea0003800000ULL,
0x018b181c5d1479a7ULL, 0x000e640008500007ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000167805ULL, 0x000fc60000015200ULL, 0x018b18185d0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ffff197224ULL, 0x000fce00078e00ffULL,
0x000000101900780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416147210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011415ULL,
0x0000001407077211ULL, 0x000fca00078510ffULL, 0x000000ffff147224ULL, 0x000fca00010e0615ULL,
0x0000000207077819ULL, 0x000fc80000001214ULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000119197836ULL, 0x000fce0000000000ULL,
0x018b18185d0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001012077824ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011612ULL,
0x000000ffff167224ULL, 0x000fc600078e0009ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c14147812ULL, 0x000fc800078ec0ffULL, 0x00000007141b7c10ULL, 0x000fca000fffe007ULL,
0x018100001b147984ULL, 0x000e680000000800ULL, 0x018300001b157984ULL, 0x0004a20000000800ULL,
0x000000091400720bULL, 0x002fda0003f5d000ULL, 0x0000000000077806ULL, 0x000fc800010e0100ULL,
0x0000ffff07187812ULL, 0x000fe2000784c0ffULL, 0x00000001ff077424ULL, 0x000fd800078e00ffULL,
0x0000000000e0a947ULL, 0x004fea0003800000ULL, 0x000000091400720bULL, 0x000fe40003f54000ULL,
0x000000026100780cULL, 0x000fe40003f65270ULL, 0x0000001409167209ULL, 0x000fd20007810000ULL,
0x0000000000197806ULL, 0x000fe400010e0100ULL, 0x018500161b00b388ULL, 0x0003e40000000800ULL,
0x0000991019177816ULL, 0x000fc800000000ffULL, 0x000000ff1700720cULL, 0x000fda0003f45270ULL,
0x0000000000a8a947ULL, 0x002fea0003800000ULL, 0x8000001609097221ULL, 0x000fe20000010000ULL,
0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL, 0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x0000000900177308ULL, 0x0002ac0000000800ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x00001f6417097589ULL, 0x006e6400000e0000ULL,
0x000000090b0b7220ULL, 0x082fe20000410000ULL, 0x000000090c0c7220ULL, 0x080fe20000410000ULL,
0x000000090f0f7220ULL, 0x080fe20000410000ULL, 0x0000000910107220ULL, 0x080fe20000410000ULL,
0x0000000941417220ULL, 0x080fe20000410000ULL, 0x0000000942427220ULL, 0x080fe20000410000ULL,
0x0000000945457220ULL, 0x080fe20000410000ULL, 0x0000000946467220ULL, 0x080fe20000410000ULL,
0x0000000949497220ULL, 0x080fe20000410000ULL, 0x000000094a4a7220ULL, 0x080fe20000410000ULL,
0x000000094d4d7220ULL, 0x080fe20000410000ULL, 0x000000094e4e7220ULL, 0x080fe20000410000ULL,
0x0000000951517220ULL, 0x080fe20000410000ULL, 0x0000000952527220ULL, 0x080fe20000410000ULL,
0x0000000957577220ULL, 0x080fe20000410000ULL, 0x0000000958587220ULL, 0x000fce0000410000ULL,
0x000000170a0a7220ULL, 0x004fe20000410000ULL, 0x000000000044b947ULL, 0x000fec0003800000ULL,
0x00001f6317097589ULL, 0x002e6400000e0000ULL, 0x000000090d0d7220ULL, 0x082fe20000410000ULL,
0x000000090e0e7220ULL, 0x080fe20000410000ULL, 0x0000000911117220ULL, 0x080fe20000410000ULL,
0x0000000940407220ULL, 0x080fe20000410000ULL, 0x0000000943437220ULL, 0x080fe20000410000ULL,
0x0000000944447220ULL, 0x080fe20000410000ULL, 0x0000000947477220ULL, 0x080fe20000410000ULL,
0x0000000948487220ULL, 0x080fe20000410000ULL, 0x000000094b4b7220ULL, 0x080fe20000410000ULL,
0x000000094c4c7220ULL, 0x080fe20000410000ULL, 0x000000094f4f7220ULL, 0x080fe20000410000ULL,
0x0000000950507220ULL, 0x080fe20000410000ULL, 0x0000000953537220ULL, 0x080fe20000410000ULL,
0x0000000956567220ULL, 0x080fe20000410000ULL, 0x0000000959597220ULL, 0x080fe20000410000ULL,
0x000000095a5a7220ULL, 0x000fce0000410000ULL, 0x0000ffff18ff7812ULL, 0x000fda0007846019ULL,
0x8000001614142221ULL, 0x000fe20000010000ULL, 0x00007610ff072816ULL, 0x000fc60000000007ULL,
0x3fb8aa3b14142820ULL, 0x000fc80000410000ULL, 0x0000001400062308ULL, 0x000ea40000000800ULL,
0x0000000615152220ULL, 0x004fce0000410000ULL, 0x0000000a150a7221ULL, 0x000fe20000010000ULL,
0x000000ffff097224ULL, 0x002fce00078e0016ULL, 0x000000ff07ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x000fc800000010ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6414037589ULL, 0x0002a800000e0000ULL,
0x00001f6314047589ULL, 0x0002e400000e0000ULL, 0x01300000052c783bULL, 0x0002e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x000000032c2c7232ULL, 0x08cfe40000200000ULL,
0x000000032e2e7232ULL, 0x000fe40000200000ULL, 0x000000042d2d7232ULL, 0x080fe40000200000ULL,
0x000000042f2f7232ULL, 0x000fce0000200000ULL, 0x000000000218783bULL, 0x000f280000004200ULL,
0x000000000014783bULL, 0x002e620000004200ULL, 0x0000010018207824ULL, 0x010fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe20000011419ULL, 0x0000010019217824ULL, 0x040fe200078e00ffULL,
0x00008880193d7816ULL, 0x040fe200000000ffULL, 0x000100001a227824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x000100001b237824ULL, 0x000fe200078e00ffULL,
0x0000002000397306ULL, 0x0009e20000202400ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0001000017387824ULL, 0x002fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fc40000011418ULL,
0x00008880183c7816ULL, 0x040fe200000000ffULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011419ULL, 0x00000021002a7306ULL, 0x0003e20000202400ULL,
0x000001001a207824ULL, 0x050fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141aULL,
0x000088801a197816ULL, 0x000fe400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002200357306ULL, 0x0009e20000202400ULL, 0x000000081b217819ULL, 0x002fc400000006ffULL,
0x00000018ff247819ULL, 0x000fe40000011414ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x00000020001a7306ULL, 0x0003e20000202400ULL,
0x0000010014227824ULL, 0x010fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141bULL,
0x000088801b327816ULL, 0x000fe400000000ffULL, 0x00000018ff347819ULL, 0x000fc40000011423ULL,
0x00000021001b7306ULL, 0x0009e20000202400ULL, 0x0000888014207816ULL, 0x042fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fe20000011422ULL,
0x0000010015227824ULL, 0x040fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011415ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000001f001f7306ULL, 0x000fe20000202400ULL,
0x0000888015217816ULL, 0x050fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fc40000011416ULL, 0x0000888016287816ULL, 0x000fe400000000ffULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000001800187306ULL, 0x000fe20000202400ULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x0000888017297816ULL, 0x000fe400000000ffULL,
0x00000018ff317819ULL, 0x000fe40000011417ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000003d003d7306ULL, 0x000e700000202400ULL, 0x0000001900197306ULL, 0x000f220000202400ULL,
0x000054103d3d7816ULL, 0x002fce000000002aULL, 0x0000003200327306ULL, 0x000e700000202400ULL,
0x0000001400277306ULL, 0x000bf00000202400ULL, 0x0000001500267306ULL, 0x0003e20000202400ULL,
0x0000010016147824ULL, 0x028fc400078e00ffULL, 0x0001000016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000010017157824ULL, 0x006fe200078e00ffULL, 0x00000014002b7306ULL, 0x0003e80000202400ULL,
0x00000018ff367819ULL, 0x000fc80000011415ULL, 0x0000001e001e7306ULL, 0x000fe20000202400ULL,
0x0000541018147816ULL, 0x002fe4000000001fULL, 0x0000541019187816ULL, 0x010fe4000000001aULL,
0x0000541032197816ULL, 0x000fc6000000001bULL, 0x0000001c001c7306ULL, 0x000e680000202400ULL,
0x000000182c18723cULL, 0x000fe800000418ffULL, 0x0000001d001d7306ULL, 0x000fe20000202400ULL,
0x00005410351c7816ULL, 0x002fce000000001cULL, 0x0000002400247306ULL, 0x000e700000202400ULL,
0x0000002500257306ULL, 0x000ea20000202400ULL, 0x0000541027247816ULL, 0x002fce0000000024ULL,
0x0000003c003c7306ULL, 0x000e620000202400ULL, 0x0000541026257816ULL, 0x004fce0000000025ULL,
0x0000003700377306ULL, 0x000ea20000202400ULL, 0x000000242c24723cULL, 0x000fe200000418ffULL,
0x000054103c3c7816ULL, 0x002fcc0000000039ULL, 0x0000003400347306ULL, 0x000e620000202400ULL,
0x0000003c2c3c723cULL, 0x000fe200000418ffULL, 0x0000541037157816ULL, 0x004fcc000000001eULL,
0x0000002000207306ULL, 0x000fe20000202400ULL, 0x00005410341d7816ULL, 0x002fce000000001dULL,
0x0000002300237306ULL, 0x000e620000202400ULL, 0x0000001c2c1c723cULL, 0x000fee00000418ffULL,
0x0000002100217306ULL, 0x000fe20000202400ULL, 0x0000541020207816ULL, 0x002fce0000000023ULL,
0x0000002200227306ULL, 0x000e700000202400ULL, 0x0000002800287306ULL, 0x000ea20000202400ULL,
0x0000541021217816ULL, 0x002fce0000000022ULL, 0x0000002900297306ULL, 0x000fe20000202400ULL,
0x000000202c20723cULL, 0x000fe200000418ffULL, 0x0000541028287816ULL, 0x004fcc000000002bULL,
0x00000036002a7306ULL, 0x000e700000202400ULL, 0x0000003000307306ULL, 0x000fe20000202400ULL,
0x0000541029297816ULL, 0x002fce000000002aULL, 0x0000003100317306ULL, 0x000fe20000202400ULL,
0x000000282c28723cULL, 0x000fee00000418ffULL, 0x0000001600337306ULL, 0x0002b00000202400ULL,
0x0000003800327306ULL, 0x000ee20000202400ULL, 0x000000142c14723cULL, 0x002fe200000418ffULL,
0x0000541033307816ULL, 0x004fc40000000030ULL, 0x0000541032317816ULL, 0x008fce0000000031ULL,
0x000000302c2c723cULL, 0x000fe200000418ffULL, 0x013000005e30783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000431317232ULL, 0x080fe40000200000ULL, 0x0000000433337232ULL, 0x000fce0000200000ULL,
0x000000006234783bULL, 0x000ee20000004200ULL, 0x0000006c6400720cULL, 0x000fe20003f66070ULL,
0x0000084000007945ULL, 0x000fe20003800000ULL, 0x000000085f00720cULL, 0x000fe20003fc3070ULL,
0x000000006038783bULL, 0x000f220000004200ULL, 0x0000006c6300720cULL, 0x000fe40003f86070ULL,
0x000000085f00720cULL, 0x000fe40003fa3070ULL, 0x0000888034547816ULL, 0x048fe200000000ffULL,
0x0000010034557824ULL, 0x040fe200078e00ffULL, 0x00008880356f7816ULL, 0x040fe200000000ffULL,
0x0000010035717824ULL, 0x040fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe20000011434ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011435ULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x00000018ff747819ULL, 0x000fc40000011471ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff717819ULL, 0x000fe20000011436ULL, 0x0000005500557306ULL, 0x000ee20000202400ULL,
0x00008880387a7816ULL, 0x010fe400000000ffULL, 0x00000018ff777819ULL, 0x000fca000001143bULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x0000541054547816ULL, 0x008fce0000000055ULL,
0x0000007400747306ULL, 0x000ef00000202400ULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x000054106f557816ULL, 0x008fce0000000074ULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x0000010036747824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fc80000011437ULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x00000054303c723cULL, 0x004fe2000004183cULL,
0x0000003400347306ULL, 0x000eac0000202400ULL, 0x0000888036547816ULL, 0x000fe400000000ffULL,
0x0000003500357306ULL, 0x000ee20000202400ULL, 0x00000018ff557819ULL, 0x000fc40000011438ULL,
0x0000541034347816ULL, 0x004fca0000000073ULL, 0x0000007400747306ULL, 0x000fe20000202400ULL,
0x0000541035357816ULL, 0x008fce0000000072ULL, 0x0000005400737306ULL, 0x0004e20000202400ULL,
0x0000888037727816ULL, 0x040fe200000000ffULL, 0x000000343014723cULL, 0x000fec0000041814ULL,
0x0000007100717306ULL, 0x000fe20000202400ULL, 0x00000018ff547819ULL, 0x004fe2000001143aULL,
0x0000010037357824ULL, 0x000fc400078e00ffULL, 0x000000ffff347224ULL, 0x000fc800078e0072ULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff727819ULL, 0x000fc80000011439ULL,
0x0000003400757306ULL, 0x0007f00000202400ULL, 0x0000003500767306ULL, 0x000ea20000202400ULL,
0x0000541073347816ULL, 0x008fe20000000074ULL, 0x0001000036737824ULL, 0x000fca00078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011473ULL, 0x0000007a007a7306ULL, 0x000fe20000202400ULL,
0x0000541075357816ULL, 0x004fce0000000076ULL, 0x0000007300747306ULL, 0x0004e20000202400ULL,
0x00000018ff767819ULL, 0x000fe20000011437ULL, 0x000000343018723cULL, 0x000fec0000041818ULL,
0x0000007600767306ULL, 0x000f220000202400ULL, 0x0000010039737824ULL, 0x044fe400078e00ffULL,
0x0000010038347824ULL, 0x040fe200078e00ffULL, 0x0000888039357816ULL, 0x040fe200000000ffULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011473ULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x00000018ff737819ULL, 0x000fc40000011439ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x000088803a397816ULL, 0x000fc600000000ffULL,
0x0000003400377306ULL, 0x0006b00000202400ULL, 0x0000007800787306ULL, 0x000fe20000202400ULL,
0x0000541074347816ULL, 0x008fce0000000071ULL, 0x0000003500717306ULL, 0x0008f00000202400ULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x0000541076357816ULL, 0x010fce000000006fULL,
0x00000034301c723cULL, 0x000fe2000004181cULL, 0x0000003800747306ULL, 0x00096c0000202400ULL,
0x000001003a347824ULL, 0x040fe400078e00ffULL, 0x000001003b357824ULL, 0x040fe200078e00ffULL,
0x0000007300737306ULL, 0x000ea20000202400ULL, 0x000088803b387816ULL, 0x050fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fc60000011435ULL,
0x0000003400767306ULL, 0x0005e20000202400ULL, 0x00000018ff3b7819ULL, 0x000fce000001143bULL,
0x00000035006f7306ULL, 0x0007e20000202400ULL, 0x000054107a347816ULL, 0x004fe40000000037ULL,
0x00000018ff377819ULL, 0x000fe2000001143aULL, 0x000000016c3a7836ULL, 0x000fc80000000000ULL,
0x0000003900397306ULL, 0x000ea20000202400ULL, 0x0000541071357816ULL, 0x008fe40000000078ULL,
0x0000003a6400720cULL, 0x080fe40005f66470ULL, 0x0000003a6300720cULL, 0x000fc60006786470ULL,
0x0000003800387306ULL, 0x000ee20000202400ULL, 0x000000343020723cULL, 0x000fee0000041820ULL,
0x0000541074347816ULL, 0x022fe20000000055ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x0000541073357816ULL, 0x000fce0000000072ULL, 0x0000007700367306ULL, 0x000fe20000202400ULL,
0x000000343024723cULL, 0x000fee0000041824ULL, 0x0000003700377306ULL, 0x000e620000202400ULL,
0x0000541039347816ULL, 0x004fe40000000076ULL, 0x0000541038357816ULL, 0x008fca000000006fULL,
0x0000003b003b7306ULL, 0x000ea40000202400ULL, 0x000000343028723cULL, 0x000fee0000041828ULL,
0x0000541037347816ULL, 0x002fe40000000054ULL, 0x000054103b357816ULL, 0x004fe20000000036ULL,
0x00000001ff367424ULL, 0x000fcc00078e00ffULL, 0x00000034302c723cULL, 0x000fe2000004182cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000403947ULL, 0x000fde0003000000ULL,
0x0000003c0b0b7221ULL, 0x000fe20000010000ULL, 0x0000003d0c0c7221ULL, 0x000fe20000010000ULL,
0x000000140f0f7221ULL, 0x000fe20000010000ULL, 0x0000001510107221ULL, 0x000fe20000010000ULL,
0x0000001841417221ULL, 0x000fe20000010000ULL, 0x0000001942427221ULL, 0x000fe20000010000ULL,
0x0000001c45457221ULL, 0x000fe20000010000ULL, 0x0000001d46467221ULL, 0x000fe20000010000ULL,
0x0000002049497221ULL, 0x000fe20000010000ULL, 0x000000214a4a7221ULL, 0x000fe20000010000ULL,
0x000000244d4d7221ULL, 0x000fe20000010000ULL, 0x000000254e4e7221ULL, 0x000fe20000010000ULL,
0x0000002851517221ULL, 0x000fe20000010000ULL, 0x0000002952527221ULL, 0x000fe20000010000ULL,
0x0000002c57577221ULL, 0x000fe20000010000ULL, 0x0000002d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe80003800000ULL,
0x0000000000404947ULL, 0x000fea0002800000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0e0e7221ULL, 0x000fe20000010000ULL, 0x0000001611117221ULL, 0x000fe20000010000ULL,
0x0000001740407221ULL, 0x000fe20000010000ULL, 0x0000001a43437221ULL, 0x000fe20000010000ULL,
0x0000001b44447221ULL, 0x000fe20000010000ULL, 0x0000001e47477221ULL, 0x000fe20000010000ULL,
0x0000001f48487221ULL, 0x000fe20000010000ULL, 0x000000224b4b7221ULL, 0x000fe20000010000ULL,
0x000000234c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002750507221ULL, 0x000fe20000010000ULL, 0x0000002a53537221ULL, 0x000fe20000010000ULL,
0x0000002b56567221ULL, 0x000fe20000010000ULL, 0x0000002e59597221ULL, 0x000fe20000010000ULL,
0x0000002f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018b8836ff1479a7ULL, 0x000e620008500007ULL, 0x00000002ff177819ULL, 0x000fe4000001163aULL,
0x000000085f00720cULL, 0x0c0fe40003fc3070ULL, 0x000000173a177207ULL, 0x040fe40000000000ULL,
0x000000033a1a7812ULL, 0x000fe400078ec0ffULL, 0x000000085f00720cULL, 0x000fe20003fa3070ULL,
0x0000000217177836ULL, 0x000fe20000000000ULL, 0x00000040ff347803ULL, 0x000fc40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fe40004000000ULL, 0x00000003171b7812ULL, 0x040fe400078ec0ffULL,
0x00000008171c7211ULL, 0x000fe200078ff0ffULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000167805ULL, 0x000fe20000015200ULL, 0x018b806dff0075a7ULL, 0x000e6400080c0147ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ff001d7202ULL, 0x000fce0000000f00ULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b806dff0075a7ULL, 0x000e6400080c0147ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fe20000015200ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x000000041c147824ULL, 0x000fc800078e021bULL, 0x00000040141e7824ULL, 0x000fe400078e00ffULL,
0x000000011c147836ULL, 0x000fc60000000000ULL, 0x000000405b1d7812ULL, 0x000fe400078ef81eULL,
0x0000000c14007c0cULL, 0x000fda000bfc6070ULL, 0x000000040054e947ULL, 0x000fea0003800000ULL,
0x000000015d207824ULL, 0x000fe200078e0270ULL, 0x000000091e187c48ULL, 0x000fe2000ffe0000ULL,
0x00000010121f7824ULL, 0x000fe200078e00ffULL, 0x00014000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000000120177824ULL, 0x040fe200078e021dULL, 0x0000000720227c11ULL, 0x000fe2000f8e10ffULL,
0x0000000118187824ULL, 0x000fe200078e0a1eULL, 0x000000f01f1f7812ULL, 0x000fc600078ec0ffULL,
0x018a000022147984ULL, 0x000e620000000800ULL, 0x000000185d187248ULL, 0x000fca0007fe0000ULL,
0x0000000118217824ULL, 0x000fe200078e0a5dULL, 0x0000000714197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019167984ULL, 0x0004e40000000800ULL,
0x0000000120197824ULL, 0x044fe400078e0212ULL, 0x0000001020207824ULL, 0x000fca00078e00ffULL,
0xfffffff020197812ULL, 0x000fe200078ee219ULL, 0x0000000270207836ULL, 0x000fc60000000000ULL,
0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL, 0x000000015d247824ULL, 0x000fc800078e0220ULL,
0x0000000124197824ULL, 0x000fe400078e021dULL, 0x0000000616177c24ULL, 0x008fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000001f16167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x000000217000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000f101c4aULL,
0x018a080022187984ULL, 0x000ea20000000800ULL, 0x0000000124167824ULL, 0x042fe400078e0212ULL,
0x0000001024177824ULL, 0x000fca00078e00ffULL, 0xfffffff017167812ULL, 0x000fc800078ee216ULL,
0x0000000e16237c11ULL, 0x000fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000001f18187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x000000212000720cULL, 0x000fe20003fc6070ULL,
0x0000000470207836ULL, 0x000fe20000000000ULL, 0x0000000670707810ULL, 0x000fc60007ffe0ffULL,
0x000000015d247824ULL, 0x000fc800078e0220ULL, 0x0000000124177824ULL, 0x000fc800078e021dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000f101c4aULL,
0x018a100022167984ULL, 0x000ea20000000800ULL, 0x0000000124187824ULL, 0x042fe400078e0212ULL,
0x0000001024197824ULL, 0x000fca00078e00ffULL, 0xfffffff019187812ULL, 0x000fc800078ee218ULL,
0x0000000e18197c11ULL, 0x000fe4000f8e20ffULL, 0x00000007161e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x0002a40000000800ULL, 0x000000015d1e7824ULL, 0x002fc800078e0270ULL,
0x000000011e1d7824ULL, 0x000fe400078e021dULL, 0x0000000616177c24ULL, 0x004fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000001f16167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x000000212000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000f101c4aULL,
0x018a180022187984ULL, 0x000ea20000000800ULL, 0x000000011e167824ULL, 0x042fe400078e0212ULL,
0x000000101e177824ULL, 0x000fca00078e00ffULL, 0xfffffff017167812ULL, 0x000fc800078ee216ULL,
0x0000000e16177c11ULL, 0x000fe4000f8e20ffULL, 0x0000000718187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x00000006181d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc600078e0014ULL, 0x0000001f14147210ULL, 0x000fca0007fde0ffULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x000000217000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000f101c4aULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015d707824ULL, 0x000fe200078e0270ULL,
0x00014000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000001012197824ULL, 0x000fe400078e00ffULL,
0x0000000170177824ULL, 0x040fe200078e021dULL, 0x00000007701f7c11ULL, 0x040fe2000f8e10ffULL,
0x00000010701e7824ULL, 0x040fe200078e00ffULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x0000000170197824ULL, 0x000fe400078e0212ULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x0000000270207836ULL, 0x000fc40000000000ULL, 0xfffffff01e197812ULL, 0x000fe400078ee219ULL,
0x0000000120227824ULL, 0x040fe400078e0212ULL, 0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000120197824ULL, 0x000fe200078e021dULL, 0x0000000714187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ea40000000800ULL,
0x0000000616177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4aULL,
0x018a08001f187984ULL, 0x000ea20000000800ULL, 0x0000001020177824ULL, 0x002fe400078e00ffULL,
0x0000000470207836ULL, 0x000fe40000000000ULL, 0x0000000670707836ULL, 0x000fe20000000000ULL,
0xfffffff017227812ULL, 0x000fe200078ee222ULL, 0x0000000120177824ULL, 0x000fc400078e021dULL,
0x00000001701d7824ULL, 0x000fe200078e021dULL, 0x0000000e22237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000120227824ULL, 0x000fe200078e0212ULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fca00030e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000b901c4aULL, 0x018a10001f167984ULL, 0x000ea20000000800ULL,
0x0000001020197824ULL, 0x002fca00078e00ffULL, 0xfffffff019227812ULL, 0x000fc800078ee222ULL,
0x0000000e22197c11ULL, 0x000fe4000f8e20ffULL, 0x00000007161e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x000e640000000800ULL, 0x0000000616177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e8000b901c4aULL, 0x018a18001f187984ULL, 0x000ea40000000800ULL,
0x0000000718187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ea40000000800ULL,
0x00000006181d7c24ULL, 0x004fc8000f8e021dULL, 0x000001001d147825ULL, 0x000fc800078e0014ULL,
0x00000001701d7824ULL, 0x040fe200078e0212ULL, 0x0000002114147210ULL, 0x000fe20007fde0ffULL,
0x0000001070707824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0xfffffff0701d7812ULL, 0x000fc800078ee21dULL, 0x0000000e1d1d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e4000b901c4aULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fc800078d10ffULL,
0x00000015ff157210ULL, 0x000fc800037fe4ffULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000001ff707424ULL, 0x000fc600078e00ffULL, 0x0000000000581947ULL, 0x000fea0003800000ULL,
0x0000001c5f00720cULL, 0x000fe20003fc4070ULL, 0x00009400ff187b82ULL, 0x000e620000000800ULL,
0x000000076e197c11ULL, 0x000fe4000f8e10ffULL, 0x000000ff1a147207ULL, 0x040fe40003000000ULL,
0x000000ff1a177207ULL, 0x000fc60007000000ULL, 0x000000011b1b7824ULL, 0x000fe400078e0214ULL,
0x00009200ff147b82ULL, 0x000ea20000000a00ULL, 0x000000015c177824ULL, 0x000fe400078e0217ULL,
0x000000401b167824ULL, 0x040fe200078e00ffULL, 0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL,
0x000000c016167812ULL, 0x000fca00078ec0ffULL, 0x000001001b167824ULL, 0x000fc800078e0216ULL,
0x0000002016167836ULL, 0x000fc80000000000ULL, 0x0000001817177224ULL, 0x102fe400078e0216ULL,
0x000000016e167824ULL, 0x040fe400078e0216ULL, 0x000000016e177824ULL, 0x000fc600078e0217ULL,
0x0000000916007c0cULL, 0x000fe2000bfc6070ULL, 0x0000000417147825ULL, 0x004fd800078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000f12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a48ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b7870ff7079a7ULL, 0x000e620008500007ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000010ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6414037589ULL, 0x0004e800000e0000ULL, 0x00001f6314047589ULL, 0x00046400000e0000ULL,
0x01300000672c783bULL, 0x0004e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000032c2c7232ULL, 0x088fe40000200000ULL, 0x000000032e2e7232ULL, 0x000fe40000200000ULL,
0x000000042d2d7232ULL, 0x082fe40000200000ULL, 0x000000042f2f7232ULL, 0x000fce0000200000ULL,
0x000000006618783bULL, 0x000f280000004200ULL, 0x000000006514783bULL, 0x004ea20000004200ULL,
0x0000010018207824ULL, 0x010fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe20000011419ULL,
0x0000010019217824ULL, 0x040fe200078e00ffULL, 0x00008880193d7816ULL, 0x040fe200000000ffULL,
0x000100001a227824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x000100001b237824ULL, 0x000fe200078e00ffULL, 0x0000002000397306ULL, 0x0009e20000202400ULL,
0x00000018ff227819ULL, 0x000fc40000011422ULL, 0x00008880183c7816ULL, 0x040fe400000000ffULL,
0x00000018ff1f7819ULL, 0x000fe20000011418ULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011419ULL, 0x00000021002a7306ULL, 0x000be20000202400ULL,
0x000001001a207824ULL, 0x050fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141aULL,
0x000088801a197816ULL, 0x000fe400000000ffULL, 0x00000018ff207819ULL, 0x000fc40000011420ULL,
0x0000002200357306ULL, 0x0009e20000202400ULL, 0x000001001b217824ULL, 0x028fe200078e00ffULL,
0x00000018ff247819ULL, 0x004fe40000011414ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000003c003c7306ULL, 0x000ea20000202400ULL,
0x0000010014227824ULL, 0x010fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fc4000001141bULL,
0x000088801b327816ULL, 0x000fe400000000ffULL, 0x00000018ff367819ULL, 0x000fe40000011423ULL,
0x00000020001a7306ULL, 0x0007e20000202400ULL, 0x00000018ff237819ULL, 0x000fe20000011422ULL,
0x0000010015227824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011415ULL,
0x00000018ff307819ULL, 0x000fe40000011416ULL, 0x0000888016287816ULL, 0x000fe200000000ffULL,
0x00000021001b7306ULL, 0x0009e20000202400ULL, 0x0000888014207816ULL, 0x048fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x000054103c3c7816ULL, 0x004fe20000000039ULL,
0x0001000017397824ULL, 0x000fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fc40000011422ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000001f001f7306ULL, 0x000fe20000202400ULL,
0x0000888015217816ULL, 0x050fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x0000888017297816ULL, 0x000fe400000000ffULL, 0x00000018ff317819ULL, 0x000fe40000011417ULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000001800187306ULL, 0x000fe20000202400ULL,
0x00000018ff397819ULL, 0x000fce0000011439ULL, 0x0000003d003d7306ULL, 0x000eb00000202400ULL,
0x0000001900197306ULL, 0x000ee20000202400ULL, 0x000054103d3d7816ULL, 0x004fce000000002aULL,
0x0000003200327306ULL, 0x000ea20000202400ULL, 0x0000003c2c3c723cULL, 0x000fee00000418ffULL,
0x0000001400277306ULL, 0x0009f00000202400ULL, 0x0000001500267306ULL, 0x000be20000202400ULL,
0x0000010016147824ULL, 0x010fc400078e00ffULL, 0x0001000016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000010017157824ULL, 0x022fe200078e00ffULL, 0x00000014002b7306ULL, 0x0003e80000202400ULL,
0x00000018ff387819ULL, 0x000fc80000011415ULL, 0x0000001e001e7306ULL, 0x000fe20000202400ULL,
0x0000541018147816ULL, 0x002fe4000000001fULL, 0x0000541019187816ULL, 0x008fe4000000001aULL,
0x0000541032197816ULL, 0x004fc6000000001bULL, 0x0000001c001c7306ULL, 0x000e680000202400ULL,
0x000000182c18723cULL, 0x000fe800000418ffULL, 0x0000001d001d7306ULL, 0x000fe20000202400ULL,
0x00005410351c7816ULL, 0x002fce000000001cULL, 0x0000002400247306ULL, 0x000e700000202400ULL,
0x0000002500257306ULL, 0x000ea20000202400ULL, 0x0000541027247816ULL, 0x002fce0000000024ULL,
0x0000003700377306ULL, 0x000e620000202400ULL, 0x0000541026257816ULL, 0x004fce0000000025ULL,
0x0000003600367306ULL, 0x000ea20000202400ULL, 0x000000242c24723cULL, 0x000fe200000418ffULL,
0x0000541037157816ULL, 0x002fcc000000001eULL, 0x0000002000207306ULL, 0x000fe20000202400ULL,
0x00005410361d7816ULL, 0x004fce000000001dULL, 0x0000002300237306ULL, 0x000e620000202400ULL,
0x0000001c2c1c723cULL, 0x000fee00000418ffULL, 0x0000002100217306ULL, 0x000fe20000202400ULL,
0x0000541020207816ULL, 0x002fce0000000023ULL, 0x0000002200227306ULL, 0x000e700000202400ULL,
0x0000002800287306ULL, 0x000ea20000202400ULL, 0x0000541021217816ULL, 0x002fce0000000022ULL,
0x0000002900297306ULL, 0x000fe20000202400ULL, 0x000000202c20723cULL, 0x000fe200000418ffULL,
0x0000541028287816ULL, 0x004fcc000000002bULL, 0x00000038002a7306ULL, 0x000e700000202400ULL,
0x0000003000307306ULL, 0x000fe20000202400ULL, 0x0000541029297816ULL, 0x002fce000000002aULL,
0x0000003100317306ULL, 0x000fe20000202400ULL, 0x000000282c28723cULL, 0x000fee00000418ffULL,
0x0000001600337306ULL, 0x0002b00000202400ULL, 0x0000003900327306ULL, 0x000ee20000202400ULL,
0x000000142c14723cULL, 0x002fe200000418ffULL, 0x0000541033307816ULL, 0x004fc40000000030ULL,
0x0000541032317816ULL, 0x008fce0000000031ULL, 0x000000302c2c723cULL, 0x000fe200000418ffULL,
0x013000006830783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000102947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000431317232ULL, 0x080fe40000200000ULL,
0x0000000433337232ULL, 0x000fce0000200000ULL, 0x000000ff3400720cULL, 0x000fe20003f45270ULL,
0x000000006938783bULL, 0x000ee20000004200ULL, 0x000007c000007945ULL, 0x000fe60003800000ULL,
0x000000006a34783bULL, 0x000f220000004200ULL, 0x0000888038777816ULL, 0x008fe400000000ffULL,
0x00000018ff737819ULL, 0x010fe20000011434ULL, 0x0000010034557824ULL, 0x040fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011435ULL, 0x00000100356d7824ULL, 0x040fe200078e00ffULL,
0x0000888034547816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000888035747816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x0000007300737306ULL, 0x000fe20000202400ULL, 0x00000018ff557819ULL, 0x000fc40000011455ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff757819ULL, 0x000fe2000001146dULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x00000018ff6e7819ULL, 0x000fe40000011437ULL, 0x00000018ff6f7819ULL, 0x000fe40000011436ULL,
0x00000018ff6d7819ULL, 0x000fc60000011438ULL, 0x0000003400347306ULL, 0x000ef00000202400ULL,
0x0000003500357306ULL, 0x000f220000202400ULL, 0x0000541034347816ULL, 0x008fce0000000073ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x0000888036737816ULL, 0x000fe400000000ffULL,
0x0000541035357816ULL, 0x010fca0000000072ULL, 0x0000005500557306ULL, 0x000ee40000202400ULL,
0x000000343014723cULL, 0x004fec0000041814ULL, 0x0000007400747306ULL, 0x000fe20000202400ULL,
0x0000000837347819ULL, 0x000fe400000006ffULL, 0x0000541054547816ULL, 0x008fca0000000055ULL,
0x0000007500757306ULL, 0x000ea20000202400ULL, 0x00000018ff767819ULL, 0x000fe20000011434ULL,
0x0001000036347824ULL, 0x000fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000007300727306ULL, 0x0007e20000202400ULL, 0x0000541074557816ULL, 0x004fe20000000075ULL,
0x0000010036747824ULL, 0x000fe200078e00ffULL, 0x0000888037757816ULL, 0x000fca00000000ffULL,
0x0000007600767306ULL, 0x000fe20000202400ULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x000088803a737816ULL, 0x008fe400000000ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x00000054303c723cULL, 0x000fe2000004183cULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000007400357306ULL, 0x0004e20000202400ULL, 0x00000018ff367819ULL, 0x000fc6000001143bULL,
0x00000018ff557819ULL, 0x000fe40000011439ULL, 0x00000018ff547819ULL, 0x000fe4000001143aULL,
0x0000007500757306ULL, 0x000f220000202400ULL, 0x0000888039747816ULL, 0x004fce00000000ffULL,
0x0000003400787306ULL, 0x0007f00000202400ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x0000541072347816ULL, 0x008fe40000000035ULL, 0x0000541075357816ULL, 0x010fca0000000076ULL,
0x0000006e006e7306ULL, 0x000fe40000202400ULL, 0x000000343018723cULL, 0x000fec0000041818ULL,
0x0000003700377306ULL, 0x000ea20000202400ULL, 0x0000010038357824ULL, 0x000fe400078e00ffULL,
0x0000010039347824ULL, 0x000fc400078e00ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000007700777306ULL, 0x000fe20000202400ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff397819ULL, 0x000fca0000011439ULL,
0x0000003500767306ULL, 0x0004f00000202400ULL, 0x0000003400757306ULL, 0x0009e20000202400ULL,
0x0000541037357816ULL, 0x004fce000000006eULL, 0x0000007400747306ULL, 0x000ea20000202400ULL,
0x0000541078347816ULL, 0x010fe4000000006fULL, 0x000088803b6f7816ULL, 0x000fca00000000ffULL,
0x00000034301c723cULL, 0x000fe2000004181cULL, 0x0000006d006d7306ULL, 0x000fec0000202400ULL,
0x000001003b357824ULL, 0x040fe400078e00ffULL, 0x000001003a347824ULL, 0x040fe200078e00ffULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011435ULL, 0x000100003a357824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff377819ULL, 0x000fe4000001143bULL,
0x0000003800387306ULL, 0x000f220000202400ULL, 0x00000018ff357819ULL, 0x000fce0000011435ULL,
0x00000039006e7306ULL, 0x000f700000202400ULL, 0x0000003400727306ULL, 0x0007f00000202400ULL,
0x0000003500397306ULL, 0x0005e20000202400ULL, 0x0000541077347816ULL, 0x008fce0000000076ULL,
0x0000007300737306ULL, 0x000ee20000202400ULL, 0x0000541074357816ULL, 0x004fce0000000075ULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x000000343020723cULL, 0x000fee0000041820ULL,
0x00000078003a7306ULL, 0x000ea20000202400ULL, 0x0000541038347816ULL, 0x010fe4000000006dULL,
0x000054106e357816ULL, 0x022fca0000000055ULL, 0x0000005400547306ULL, 0x000e640000202400ULL,
0x000000343024723cULL, 0x000fec0000041824ULL, 0x0000003600367306ULL, 0x000fe20000202400ULL,
0x0000541073347816ULL, 0x008fe40000000072ULL, 0x000054106f357816ULL, 0x004fca000000003aULL,
0x0000003700377306ULL, 0x000ea40000202400ULL, 0x000000343028723cULL, 0x000fee0000041828ULL,
0x0000541039347816ULL, 0x002fe40000000054ULL, 0x0000541037357816ULL, 0x004fce0000000036ULL,
0x00000034302c723cULL, 0x000fe2000004182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000403947ULL, 0x000fde0001000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0c0c7221ULL, 0x000fe20000010000ULL, 0x000000140f0f7221ULL, 0x000fe20000010000ULL,
0x0000001510107221ULL, 0x000fe20000010000ULL, 0x0000001841417221ULL, 0x000fe20000010000ULL,
0x0000001942427221ULL, 0x000fe20000010000ULL, 0x0000001c45457221ULL, 0x000fe20000010000ULL,
0x0000001d46467221ULL, 0x000fe20000010000ULL, 0x0000002049497221ULL, 0x000fe20000010000ULL,
0x000000214a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002851517221ULL, 0x000fe20000010000ULL,
0x0000002952527221ULL, 0x000fe20000010000ULL, 0x0000002c57577221ULL, 0x000fe20000010000ULL,
0x0000002d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0e0e7221ULL, 0x000fe20000010000ULL,
0x0000001611117221ULL, 0x000fe20000010000ULL, 0x0000001740407221ULL, 0x000fe20000010000ULL,
0x0000001a43437221ULL, 0x000fe20000010000ULL, 0x0000001b44447221ULL, 0x000fe20000010000ULL,
0x0000001e47477221ULL, 0x000fe20000010000ULL, 0x0000001f48487221ULL, 0x000fe20000010000ULL,
0x000000224b4b7221ULL, 0x000fe20000010000ULL, 0x000000234c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002a53537221ULL, 0x000fe20000010000ULL, 0x0000002b56567221ULL, 0x000fe20000010000ULL,
0x0000002e59597221ULL, 0x000fe20000010000ULL, 0x0000002f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000016c6c7836ULL, 0x000fe40000000000ULL, 0x018b8816ff1479a7ULL, 0x000e660008500007ULL,
0x0000006b6c00720cULL, 0x000fe20003f46070ULL, 0x000000ffff187224ULL, 0x002fd800078e0015ULL,
0xffffffb0006ca947ULL, 0x000fea000383ffffULL, 0x000000c008147811ULL, 0x000fe200078e40ffULL,
0x018b6816ffff79a7ULL, 0x0003e60008500007ULL, 0x0000000914007c0cULL, 0x000fda000bf46070ULL,
0x0000004c009c2947ULL, 0x002fea0003800000ULL, 0x000000ffff6c7224ULL, 0x000fce00078e00ffULL,
0x00000002ff157819ULL, 0x000fe4000001166cULL, 0x000000036c1b7812ULL, 0x040fe400078ec0ffULL,
0x000000156c157207ULL, 0x000fe40000000000ULL, 0x000000ff1b1b7207ULL, 0x000fc60004000000ULL,
0x00000003151f7836ULL, 0x000fca0000000000ULL, 0x000000031f1d7812ULL, 0x040fe400078ec0ffULL,
0x000000081f1a7211ULL, 0x000fe400078ff0ffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b7871ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x018b7871ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000000000167805ULL, 0x000fe20000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x000000011a157836ULL, 0x000fe20000000000ULL,
0x00000004ff707819ULL, 0x000fe20000011612ULL, 0x000000041a147824ULL, 0x000fc600078e021dULL,
0x0000000c15007c0cULL, 0x000fe4000bf46070ULL, 0x0000002014187811ULL, 0x000fc800078e30ffULL,
0x000000605b1c7812ULL, 0x000fce00078ef818ULL, 0x000000040054a947ULL, 0x000fea0003800000ULL,
0x000000015d237824ULL, 0x000fe200078e0270ULL, 0x0000000918167c48ULL, 0x000fe2000ffe0000ULL,
0x00000010121e7824ULL, 0x000fe200078e00ffULL, 0x00016000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000000270227836ULL, 0x000fe20000000000ULL, 0x0000000723207c11ULL, 0x040fe2000f8e10ffULL,
0x0000000116167824ULL, 0x000fe200078e0a18ULL, 0x000000f01e257812ULL, 0x000fe200078ec0ffULL,
0x0000000123187824ULL, 0x000fe400078e021cULL, 0x018a000020147984ULL, 0x000e620000000800ULL,
0x000000165d167248ULL, 0x000fe20007fe0000ULL, 0x000000015d277824ULL, 0x000fc800078e0222ULL,
0x0000000116217824ULL, 0x000fe400078e0a5dULL, 0x0000000127247824ULL, 0x000fc600078e0212ULL,
0x000000217000720cULL, 0x000fe40003f46070ULL, 0x0000000714197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019177984ULL, 0x0004e40000000800ULL,
0x0000000127197824ULL, 0x044fe400078e021cULL, 0x0000001027277824ULL, 0x000fca00078e00ffULL,
0xfffffff027247812ULL, 0x000fe200078ee224ULL, 0x0000000617177c24ULL, 0x008fe2000f8e0218ULL,
0x0000001223187210ULL, 0x000fe20007ffe0ffULL, 0x0000001023237824ULL, 0x000fe400078e00ffULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0xfffffff023187812ULL, 0x000fe400078ee218ULL,
0x0000002516167210ULL, 0x000fe40007f7e0ffULL, 0x0000000e18237c11ULL, 0x000fc6000f8e20ffULL,
0x000000ffff177224ULL, 0x000fca00018e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x000000212200720cULL, 0x000fe20003f46070ULL,
0x0000000470227836ULL, 0x000fe40000000000ULL, 0x018a080020187984ULL, 0x000ea40000000800ULL,
0x000000015d277824ULL, 0x000fe200078e0222ULL, 0x0000000e24237c11ULL, 0x002fc6000f8e20ffULL,
0x0000000127247824ULL, 0x000fe200078e0212ULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002518167210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe400018e0619ULL, 0x0000000127197824ULL, 0x040fe400078e021cULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x000000212200720cULL, 0x000fc60003f46070ULL,
0x018a100020187984ULL, 0x000ea20000000800ULL, 0xfffffff027247812ULL, 0x000fc800078ee224ULL,
0x0000000e24237c11ULL, 0x002fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x0002a40000000800ULL, 0x00000006701e7836ULL, 0x002fc80000000000ULL,
0x000000015d277824ULL, 0x000fe400078e021eULL, 0x0000000618197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002518167210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe400018e0619ULL, 0x0000000127197824ULL, 0x040fe400078e021cULL,
0x00000001271c7824ULL, 0x040fe200078e0212ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000d101c4aULL, 0x0000001027277824ULL, 0x000fe200078e00ffULL,
0x000000211e00720cULL, 0x000fe40003f46070ULL, 0x018a180020187984ULL, 0x000ea40000000800ULL,
0xfffffff0271c7812ULL, 0x000fc800078ee21cULL, 0x0000000e1c177c11ULL, 0x002fe4000f8e20ffULL,
0x0000000718187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019147825ULL, 0x000fc600078e0014ULL,
0x0000002514147210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff157224ULL, 0x000fca00018e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d101c4aULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015d217824ULL, 0x000fe200078e0270ULL,
0x00016000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000001012197824ULL, 0x000fe400078e00ffULL,
0x0000000121177824ULL, 0x040fe200078e021cULL, 0x0000000721207c11ULL, 0x040fe2000f8e10ffULL,
0x00000010211e7824ULL, 0x000fe200078e00ffULL, 0x000000f019237812ULL, 0x000fe200078ec0ffULL,
0x0000000121197824ULL, 0x000fe400078e0212ULL, 0x018a000020147984ULL, 0x000e620000000800ULL,
0x0000000221277836ULL, 0x000fc40000000000ULL, 0xfffffff01e197812ULL, 0x000fe400078ee219ULL,
0x0000000127227824ULL, 0x000fe400078e0212ULL, 0x0000000e19257c11ULL, 0x000fe2000f8e20ffULL,
0x0000000127197824ULL, 0x040fe400078e021cULL, 0x0000001027277824ULL, 0x000fca00078e00ffULL,
0xfffffff027227812ULL, 0x000fe200078ee222ULL, 0x0000000421277836ULL, 0x000fe40000000000ULL,
0x0000000621217836ULL, 0x000fe20000000000ULL, 0x0000000714187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ea40000000800ULL,
0x0000000616177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000b901c4aULL,
0x018a080020187984ULL, 0x000ea20000000800ULL, 0x0000000e22257c11ULL, 0x002fe2000f8e20ffULL,
0x0000000127177824ULL, 0x040fe400078e021cULL, 0x0000000127227824ULL, 0x040fe400078e0212ULL,
0x0000001027277824ULL, 0x000fca00078e00ffULL, 0xfffffff027227812ULL, 0x000fe400078ee222ULL,
0x00000007181e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e187984ULL, 0x000e640000000800ULL,
0x0000000618197c24ULL, 0x002fc8000f8e0219ULL, 0x0000010019187825ULL, 0x000fc600078e0014ULL,
0x0000002318187210ULL, 0x000fc80007f5e0ffULL, 0x00000019ff197210ULL, 0x000fca00017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0003e8000b901c4aULL,
0x018a100020167984ULL, 0x000ea20000000800ULL, 0x0000000e22257c11ULL, 0x002fe2000f8e20ffULL,
0x0000000121197824ULL, 0x040fe400078e021cULL, 0x00000010211c7824ULL, 0x000fe200078e00ffULL,
0x00000007161e7c11ULL, 0x004fca000f8e10ffULL, 0x018ac0001e167984ULL, 0x000e640000000800ULL,
0x0000000616177c24ULL, 0x002fc8000f8e0217ULL, 0x0000010017167825ULL, 0x000fc600078e0014ULL,
0x0000002316167210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff177224ULL, 0x000fca00010e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016257faeULL, 0x0003e8000b901c4aULL,
0x018a180020187984ULL, 0x000ea40000000800ULL, 0x0000000718187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000ea40000000800ULL, 0x0000000618197c24ULL, 0x004fc8000f8e0219ULL,
0x0000010019147825ULL, 0x000fc800078e0014ULL, 0x0000000121197824ULL, 0x000fe200078e0212ULL,
0x0000002314147210ULL, 0x000fc80007f5e0ffULL, 0xfffffff01c197812ULL, 0x000fe200078ee219ULL,
0x000000ffff157224ULL, 0x000fc600010e0615ULL, 0x0000000e19197c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e4000b901c4aULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e640008040147ULL, 0x00000000005c2947ULL, 0x002fea0003800000ULL,
0x000000ffff1c7224ULL, 0x000fce00078e00ffULL, 0x000000101c00780cULL, 0x000fda0003f46270ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007f5e1ffULL, 0x0000000115157824ULL, 0x000fe200010e0e17ULL,
0x003d09001900780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x00000000001ca947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078510ffULL,
0x000000ffff157224ULL, 0x000fca00010e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011c1c7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e640008040147ULL,
0xfffffffc00a8a947ULL, 0x002fea000383ffffULL, 0x0000001a5f00720cULL, 0x000fe20003f44070ULL,
0x00000001ff1c7424ULL, 0x000fe200078e00ffULL, 0x000000011f1f7812ULL, 0x000fe200078ec0ffULL,
0x00000020616e7824ULL, 0x000fe200078e0212ULL, 0x000000031b00780cULL, 0x000fc80005745270ULL,
0x000000011f00780cULL, 0x000fda0001745470ULL, 0x00000000004c2947ULL, 0x000fea0003800000ULL,
0x000000036e00780cULL, 0x000fe20003f44070ULL, 0x0000000104047890ULL, 0x000fe2000fffe03fULL,
0x0000010000007945ULL, 0x000ff60003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00009000ff177b82ULL, 0x000e620000000800ULL, 0x000000050400728cULL, 0x000fe2000bf06070ULL,
0x0000000413167824ULL, 0x000fe200078e026eULL, 0x000000076e197c11ULL, 0x000fc6000f8e10ffULL,
0x0000000216167824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x00008c00ff147b82ULL, 0x000ea20000000a00ULL, 0x0000000417187c36ULL, 0x002fc80008000000ULL,
0x0000001716177224ULL, 0x000fc800078e0218ULL, 0x0000000417147825ULL, 0x004fca00078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18ac000014197faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000019000007945ULL, 0x000fe80003800000ULL,
0x00000000005c1947ULL, 0x000fea0003800000ULL, 0x0000001a5f00720cULL, 0x000fe20003f44070ULL,
0x000000011b147836ULL, 0x002fe20000000000ULL, 0x00009400ff187b82ULL, 0x000e680000000800ULL,
0x0000000314167812ULL, 0x000fc800078ec0ffULL, 0x000000ff16197207ULL, 0x000fc60005000000ULL,
0x00000002ff14a819ULL, 0x000fe40000011614ULL, 0x000000015c167824ULL, 0x000fc600078e0219ULL,
0x000000011d1d7824ULL, 0x000fe400078e0214ULL, 0x00009200ff147b82ULL, 0x000ea40000000a00ULL,
0x000000401d177824ULL, 0x040fe200078e00ffULL, 0x0000001a1d1a7211ULL, 0x000fc800078ff0ffULL,
0x000000c017177812ULL, 0x000fca00078ec0ffULL, 0x000001001a177824ULL, 0x000fc800078e0217ULL,
0x000000016e197824ULL, 0x100fe400078e0217ULL, 0x0000001816177224ULL, 0x002fc600078e0217ULL,
0x0000000919007c0cULL, 0x000fe2000bf46070ULL, 0x000000016e177824ULL, 0x040fe200078e0217ULL,
0x000000076e197c11ULL, 0x000fc6000f8e10ffULL, 0x0000000417147825ULL, 0x004fd000078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000d12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4dULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b801cff1479a7ULL, 0x000e620008500007ULL, 0x000000ff6c00720cULL, 0x000fe20003f45270ULL,
0x000000ffff6d7224ULL, 0x002fd800078e0015ULL, 0x00000004008c2947ULL, 0x000fea0003800000ULL,
0x018b381c5d1479a7ULL, 0x000e640008500007ULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000167805ULL, 0x000fc60000015200ULL, 0x018b38185d0075a7ULL, 0x000e640008040147ULL,
0x00000000005c2947ULL, 0x002fea0003800000ULL, 0x000000ff00197202ULL, 0x000fce0000000f00ULL,
0x000000101900780cULL, 0x000fda0003f46270ULL, 0x000000000044a947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416147210ULL, 0x000fca0007f5e1ffULL,
0x0000000115157824ULL, 0x000fe200010e0e17ULL, 0x003d09001400780cULL, 0x000fc80003f46070ULL,
0x000000ff1500720cULL, 0x000fda0003f46320ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f46070ULL, 0x000000ff1500720cULL, 0x000fda0003f46320ULL,
0x00000000001ca947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011415ULL,
0x0000001407077211ULL, 0x000fca00078510ffULL, 0x000000ffff147224ULL, 0x000fca00010e0615ULL,
0x0000000207077819ULL, 0x000fc80000001214ULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000119197836ULL, 0x000fce0000000000ULL,
0x018b38185d0075a7ULL, 0x000e640008040147ULL, 0xfffffffc00a8a947ULL, 0x002fea000383ffffULL,
0x0000001012077824ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011612ULL,
0x000000ffff167224ULL, 0x000fc600078e0009ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c14147812ULL, 0x000fc800078ec0ffULL, 0x00000007141b7c10ULL, 0x000fca000fffe007ULL,
0x018180001b147984ULL, 0x000e680000000800ULL, 0x018380001b157984ULL, 0x0004a20000000800ULL,
0x000000091400720bULL, 0x002fda0003f5d000ULL, 0x0000000000077806ULL, 0x000fc800010e0100ULL,
0x0000ffff07187812ULL, 0x000fe2000784c0ffULL, 0x00000001ff077424ULL, 0x000fd800078e00ffULL,
0x0000000000e0a947ULL, 0x004fea0003800000ULL, 0x000000091400720bULL, 0x000fe40003f54000ULL,
0x000000036100780cULL, 0x000fe40003f65270ULL, 0x0000001409167209ULL, 0x000fd20007810000ULL,
0x0000000000197806ULL, 0x000fe400010e0100ULL, 0x018580161b00b388ULL, 0x0003e40000000800ULL,
0x0000991019177816ULL, 0x000fc800000000ffULL, 0x000000ff1700720cULL, 0x000fda0003f45270ULL,
0x0000000000a8a947ULL, 0x002fea0003800000ULL, 0x8000001609097221ULL, 0x000fe20000010000ULL,
0x000000ff19ff7812ULL, 0x040fe4000784c0ffULL, 0x0000ff0019ff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x0000000900177308ULL, 0x0002ac0000000800ULL,
0x000000000044a947ULL, 0x000fea0003800000ULL, 0x00001f6417097589ULL, 0x006e6400000e0000ULL,
0x000000090b0b7220ULL, 0x082fe20000410000ULL, 0x000000090c0c7220ULL, 0x080fe20000410000ULL,
0x000000090f0f7220ULL, 0x080fe20000410000ULL, 0x0000000910107220ULL, 0x080fe20000410000ULL,
0x0000000941417220ULL, 0x080fe20000410000ULL, 0x0000000942427220ULL, 0x080fe20000410000ULL,
0x0000000945457220ULL, 0x080fe20000410000ULL, 0x0000000946467220ULL, 0x080fe20000410000ULL,
0x0000000949497220ULL, 0x080fe20000410000ULL, 0x000000094a4a7220ULL, 0x080fe20000410000ULL,
0x000000094d4d7220ULL, 0x080fe20000410000ULL, 0x000000094e4e7220ULL, 0x080fe20000410000ULL,
0x0000000951517220ULL, 0x080fe20000410000ULL, 0x0000000952527220ULL, 0x080fe20000410000ULL,
0x0000000957577220ULL, 0x080fe20000410000ULL, 0x0000000958587220ULL, 0x000fce0000410000ULL,
0x000000170a0a7220ULL, 0x004fe20000410000ULL, 0x000000000044b947ULL, 0x000fec0003800000ULL,
0x00001f6317097589ULL, 0x002e6400000e0000ULL, 0x000000090d0d7220ULL, 0x082fe20000410000ULL,
0x000000090e0e7220ULL, 0x080fe20000410000ULL, 0x0000000911117220ULL, 0x080fe20000410000ULL,
0x0000000940407220ULL, 0x080fe20000410000ULL, 0x0000000943437220ULL, 0x080fe20000410000ULL,
0x0000000944447220ULL, 0x080fe20000410000ULL, 0x0000000947477220ULL, 0x080fe20000410000ULL,
0x0000000948487220ULL, 0x080fe20000410000ULL, 0x000000094b4b7220ULL, 0x080fe20000410000ULL,
0x000000094c4c7220ULL, 0x080fe20000410000ULL, 0x000000094f4f7220ULL, 0x080fe20000410000ULL,
0x0000000950507220ULL, 0x080fe20000410000ULL, 0x0000000953537220ULL, 0x080fe20000410000ULL,
0x0000000956567220ULL, 0x080fe20000410000ULL, 0x0000000959597220ULL, 0x080fe20000410000ULL,
0x000000095a5a7220ULL, 0x000fce0000410000ULL, 0x0000ffff18ff7812ULL, 0x000fda0007846019ULL,
0x8000001614142221ULL, 0x000fe20000010000ULL, 0x00007610ff072816ULL, 0x000fc60000000007ULL,
0x3fb8aa3b14142820ULL, 0x000fc80000410000ULL, 0x0000001400062308ULL, 0x000ea40000000800ULL,
0x0000000615152220ULL, 0x004fce0000410000ULL, 0x0000000a150a7221ULL, 0x000fe20000010000ULL,
0x000000ffff097224ULL, 0x002fce00078e0016ULL, 0x000000ff07ff7812ULL, 0x000fda000784c0ffULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x00000006ff03723eULL, 0x000fc800000010ffULL,
0x0000541003147816ULL, 0x000fca0000000003ULL, 0x00001f6414037589ULL, 0x0002a800000e0000ULL,
0x00001f6314047589ULL, 0x0002e400000e0000ULL, 0x01380000052c783bULL, 0x0002e20000000200ULL,
0x0000000000102947ULL, 0x000fea0003800000ULL, 0x000000032c2c7232ULL, 0x08cfe40000200000ULL,
0x000000032e2e7232ULL, 0x000fe40000200000ULL, 0x000000042d2d7232ULL, 0x080fe40000200000ULL,
0x000000042f2f7232ULL, 0x000fce0000200000ULL, 0x000000000218783bULL, 0x000f280000004200ULL,
0x000000000014783bULL, 0x002e620000004200ULL, 0x0000010018207824ULL, 0x010fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe20000011419ULL, 0x0000010019217824ULL, 0x040fe200078e00ffULL,
0x00008880193d7816ULL, 0x040fe200000000ffULL, 0x000100001a227824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x000100001b237824ULL, 0x000fe200078e00ffULL,
0x0000002000397306ULL, 0x0009e20000202400ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0001000017387824ULL, 0x002fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fc40000011418ULL,
0x00008880183c7816ULL, 0x040fe200000000ffULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011419ULL, 0x00000021002a7306ULL, 0x0003e20000202400ULL,
0x000001001a207824ULL, 0x050fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141aULL,
0x000088801a197816ULL, 0x000fe400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002200357306ULL, 0x0009e20000202400ULL, 0x000001001b217824ULL, 0x002fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fc40000011414ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000020001a7306ULL, 0x0003e20000202400ULL,
0x0000010014227824ULL, 0x010fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141bULL,
0x000088801b327816ULL, 0x000fe400000000ffULL, 0x00000018ff347819ULL, 0x000fc40000011423ULL,
0x00000021001b7306ULL, 0x0009e20000202400ULL, 0x0000888014207816ULL, 0x042fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fe20000011422ULL,
0x0000010015227824ULL, 0x040fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011415ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000001f001f7306ULL, 0x000fe20000202400ULL,
0x0000888015217816ULL, 0x050fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fc40000011416ULL, 0x0000888016287816ULL, 0x000fe400000000ffULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000001800187306ULL, 0x000fe20000202400ULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x0000888017297816ULL, 0x000fe400000000ffULL,
0x00000018ff317819ULL, 0x000fe40000011417ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000003d003d7306ULL, 0x000e700000202400ULL, 0x0000001900197306ULL, 0x000f220000202400ULL,
0x000054103d3d7816ULL, 0x002fce000000002aULL, 0x0000003200327306ULL, 0x000e700000202400ULL,
0x0000001400277306ULL, 0x000bf00000202400ULL, 0x0000001500267306ULL, 0x0003e20000202400ULL,
0x0000010016147824ULL, 0x028fc400078e00ffULL, 0x0001000016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000010017157824ULL, 0x006fe200078e00ffULL, 0x00000014002b7306ULL, 0x0003e80000202400ULL,
0x00000018ff367819ULL, 0x000fc80000011415ULL, 0x0000001e001e7306ULL, 0x000fe20000202400ULL,
0x0000541018147816ULL, 0x002fe4000000001fULL, 0x0000541019187816ULL, 0x010fe4000000001aULL,
0x0000541032197816ULL, 0x000fc6000000001bULL, 0x0000001c001c7306ULL, 0x000e680000202400ULL,
0x000000182c18723cULL, 0x000fe800000418ffULL, 0x0000001d001d7306ULL, 0x000fe20000202400ULL,
0x00005410351c7816ULL, 0x002fce000000001cULL, 0x0000002400247306ULL, 0x000e700000202400ULL,
0x0000002500257306ULL, 0x000ea20000202400ULL, 0x0000541027247816ULL, 0x002fce0000000024ULL,
0x0000003c003c7306ULL, 0x000e620000202400ULL, 0x0000541026257816ULL, 0x004fce0000000025ULL,
0x0000003700377306ULL, 0x000ea20000202400ULL, 0x000000242c24723cULL, 0x000fe200000418ffULL,
0x000054103c3c7816ULL, 0x002fcc0000000039ULL, 0x0000003400347306ULL, 0x000e620000202400ULL,
0x0000003c2c3c723cULL, 0x000fe200000418ffULL, 0x0000541037157816ULL, 0x004fcc000000001eULL,
0x0000002000207306ULL, 0x000fe20000202400ULL, 0x00005410341d7816ULL, 0x002fce000000001dULL,
0x0000002300237306ULL, 0x000e620000202400ULL, 0x0000001c2c1c723cULL, 0x000fee00000418ffULL,
0x0000002100217306ULL, 0x000fe20000202400ULL, 0x0000541020207816ULL, 0x002fce0000000023ULL,
0x0000002200227306ULL, 0x000e700000202400ULL, 0x0000002800287306ULL, 0x000ea20000202400ULL,
0x0000541021217816ULL, 0x002fce0000000022ULL, 0x0000002900297306ULL, 0x000fe20000202400ULL,
0x000000202c20723cULL, 0x000fe200000418ffULL, 0x0000541028287816ULL, 0x004fcc000000002bULL,
0x00000036002a7306ULL, 0x000e700000202400ULL, 0x0000003000307306ULL, 0x000fe20000202400ULL,
0x0000541029297816ULL, 0x002fce000000002aULL, 0x0000003100317306ULL, 0x000fe20000202400ULL,
0x000000282c28723cULL, 0x000fee00000418ffULL, 0x0000001600337306ULL, 0x0002b00000202400ULL,
0x0000003800327306ULL, 0x000ee20000202400ULL, 0x000000142c14723cULL, 0x002fe200000418ffULL,
0x0000541033307816ULL, 0x004fc40000000030ULL, 0x0000541032317816ULL, 0x008fce0000000031ULL,
0x000000302c2c723cULL, 0x000fe200000418ffULL, 0x013800005e30783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000102947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000200000ULL, 0x0000000332327232ULL, 0x000fe40000200000ULL,
0x0000000431317232ULL, 0x080fe40000200000ULL, 0x0000000433337232ULL, 0x000fce0000200000ULL,
0x000000006234783bULL, 0x000ee20000004200ULL, 0x0000006c6400720cULL, 0x000fe20003f66070ULL,
0x0000084000007945ULL, 0x000fe20003800000ULL, 0x000000085f00720cULL, 0x000fe20003fc3070ULL,
0x000000006038783bULL, 0x000f220000004200ULL, 0x0000006c6300720cULL, 0x000fe40003f86070ULL,
0x000000085f00720cULL, 0x000fe40003fa3070ULL, 0x0000888034547816ULL, 0x048fe200000000ffULL,
0x0000010034557824ULL, 0x040fe200078e00ffULL, 0x00008880356f7816ULL, 0x040fe200000000ffULL,
0x0000010035717824ULL, 0x040fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe20000011434ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011435ULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff747819ULL, 0x000fe40000011471ULL,
0x00000018ff717819ULL, 0x000fe20000011436ULL, 0x0000005500557306ULL, 0x000ee20000202400ULL,
0x00008880387a7816ULL, 0x010fe400000000ffULL, 0x00000018ff777819ULL, 0x000fca000001143bULL,
0x0000007300737306ULL, 0x000fe20000202400ULL, 0x0000541054547816ULL, 0x008fce0000000055ULL,
0x0000007200727306ULL, 0x000ff00000202400ULL, 0x0000003400347306ULL, 0x000ef00000202400ULL,
0x0000003500357306ULL, 0x000f220000202400ULL, 0x0000541034347816ULL, 0x008fce0000000073ULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x0000541035357816ULL, 0x010fce0000000072ULL,
0x0000007400747306ULL, 0x000ee20000202400ULL, 0x0000888037727816ULL, 0x040fe200000000ffULL,
0x000000343014723cULL, 0x004fec0000041814ULL, 0x0000007100717306ULL, 0x000fe20000202400ULL,
0x0000010037357824ULL, 0x000fe200078e00ffULL, 0x000054106f557816ULL, 0x008fe20000000074ULL,
0x0000010036747824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe20000011437ULL,
0x000000ffff347224ULL, 0x000fe200078e0072ULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x00000054303c723cULL, 0x000fe2000004183cULL, 0x0000003400757306ULL, 0x000fe20000202400ULL,
0x00000018ff727819ULL, 0x000fca0000011439ULL, 0x0000888036547816ULL, 0x000fe400000000ffULL,
0x0000007400747306ULL, 0x000fe20000202400ULL, 0x00000018ff557819ULL, 0x000fce0000011438ULL,
0x0000005400737306ULL, 0x0004f00000202400ULL, 0x0000003500767306ULL, 0x000f220000202400ULL,
0x00000018ff547819ULL, 0x004fe4000001143aULL, 0x0000541073347816ULL, 0x008fca0000000074ULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x0000001036737819ULL, 0x000fc800000006ffULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000541075357816ULL, 0x010fe20000000076ULL,
0x0000007a007a7306ULL, 0x000fe20000202400ULL, 0x00000018ff767819ULL, 0x000fca0000011437ULL,
0x000000343018723cULL, 0x000fe40000041818ULL, 0x0000007300747306ULL, 0x0004ea0000202400ULL,
0x0000010038347824ULL, 0x040fe200078e00ffULL, 0x0000888039357816ULL, 0x040fe200000000ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x0000007600767306ULL, 0x000f220000202400ULL,
0x0000010039737824ULL, 0x044fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fc40000011438ULL,
0x00000018ff787819ULL, 0x000fe40000011473ULL, 0x0000003400377306ULL, 0x0006a20000202400ULL,
0x00000018ff737819ULL, 0x000fe40000011439ULL, 0x000088803a397816ULL, 0x000fca00000000ffULL,
0x0000007800787306ULL, 0x000fe20000202400ULL, 0x0000541074347816ULL, 0x008fce0000000071ULL,
0x0000003500717306ULL, 0x0008f00000202400ULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x0000541076357816ULL, 0x010fce000000006fULL, 0x00000034301c723cULL, 0x000fe2000004181cULL,
0x0000007200727306ULL, 0x000fec0000202400ULL, 0x000001003a347824ULL, 0x040fe400078e00ffULL,
0x000001003b357824ULL, 0x000fe200078e00ffULL, 0x0000003800747306ULL, 0x0009620000202400ULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x00000018ff357819ULL, 0x000fc80000011435ULL, 0x0000007300737306ULL, 0x000ea20000202400ULL,
0x000088803b387816ULL, 0x050fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000003400767306ULL, 0x0005f00000202400ULL,
0x00000035006f7306ULL, 0x0007e20000202400ULL, 0x000054107a347816ULL, 0x004fc40000000037ULL,
0x00000018ff377819ULL, 0x000fe2000001143aULL, 0x000000016c3a7836ULL, 0x000fc80000000000ULL,
0x0000003900397306ULL, 0x000ea20000202400ULL, 0x0000541071357816ULL, 0x008fe40000000078ULL,
0x0000003a6400720cULL, 0x080fe40005f66470ULL, 0x0000003a6300720cULL, 0x000fc60006786470ULL,
0x0000003800387306ULL, 0x000ee20000202400ULL, 0x000000343020723cULL, 0x000fee0000041820ULL,
0x0000541074347816ULL, 0x022fe20000000055ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x0000541073357816ULL, 0x000fce0000000072ULL, 0x0000007700367306ULL, 0x000fe20000202400ULL,
0x000000343024723cULL, 0x000fee0000041824ULL, 0x0000003700377306ULL, 0x000e620000202400ULL,
0x0000541039347816ULL, 0x004fe40000000076ULL, 0x0000541038357816ULL, 0x008fca000000006fULL,
0x0000003b003b7306ULL, 0x000ea40000202400ULL, 0x000000343028723cULL, 0x000fee0000041828ULL,
0x0000541037347816ULL, 0x002fe40000000054ULL, 0x000054103b357816ULL, 0x004fe20000000036ULL,
0x00000001ff367424ULL, 0x000fcc00078e00ffULL, 0x00000034302c723cULL, 0x000fe2000004182cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000403947ULL, 0x000fde0003000000ULL,
0x0000003c0b0b7221ULL, 0x000fe20000010000ULL, 0x0000003d0c0c7221ULL, 0x000fe20000010000ULL,
0x000000140f0f7221ULL, 0x000fe20000010000ULL, 0x0000001510107221ULL, 0x000fe20000010000ULL,
0x0000001841417221ULL, 0x000fe20000010000ULL, 0x0000001942427221ULL, 0x000fe20000010000ULL,
0x0000001c45457221ULL, 0x000fe20000010000ULL, 0x0000001d46467221ULL, 0x000fe20000010000ULL,
0x0000002049497221ULL, 0x000fe20000010000ULL, 0x000000214a4a7221ULL, 0x000fe20000010000ULL,
0x000000244d4d7221ULL, 0x000fe20000010000ULL, 0x000000254e4e7221ULL, 0x000fe20000010000ULL,
0x0000002851517221ULL, 0x000fe20000010000ULL, 0x0000002952527221ULL, 0x000fe20000010000ULL,
0x0000002c57577221ULL, 0x000fe20000010000ULL, 0x0000002d58587221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe80003800000ULL,
0x0000000000404947ULL, 0x000fea0002800000ULL, 0x0000003e0d0d7221ULL, 0x000fe20000010000ULL,
0x0000003f0e0e7221ULL, 0x000fe20000010000ULL, 0x0000001611117221ULL, 0x000fe20000010000ULL,
0x0000001740407221ULL, 0x000fe20000010000ULL, 0x0000001a43437221ULL, 0x000fe20000010000ULL,
0x0000001b44447221ULL, 0x000fe20000010000ULL, 0x0000001e47477221ULL, 0x000fe20000010000ULL,
0x0000001f48487221ULL, 0x000fe20000010000ULL, 0x000000224b4b7221ULL, 0x000fe20000010000ULL,
0x000000234c4c7221ULL, 0x000fe20000010000ULL, 0x000000264f4f7221ULL, 0x000fe20000010000ULL,
0x0000002750507221ULL, 0x000fe20000010000ULL, 0x0000002a53537221ULL, 0x000fe20000010000ULL,
0x0000002b56567221ULL, 0x000fe20000010000ULL, 0x0000002e59597221ULL, 0x000fe20000010000ULL,
0x0000002f5a5a7221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x018b8836ff1479a7ULL, 0x000e620008500007ULL, 0x00000002ff177819ULL, 0x000fe4000001163aULL,
0x000000085f00720cULL, 0x0c0fe40003fc3070ULL, 0x000000173a177207ULL, 0x040fe40000000000ULL,
0x000000033a1a7812ULL, 0x000fe400078ec0ffULL, 0x000000085f00720cULL, 0x000fe20003fa3070ULL,
0x0000000317177836ULL, 0x000fe20000000000ULL, 0x00000040ff347803ULL, 0x000fc40000000000ULL,
0x000000ff1a1a7207ULL, 0x000fe40004000000ULL, 0x00000003171b7812ULL, 0x040fe400078ec0ffULL,
0x00000008171c7211ULL, 0x000fe200078ff0ffULL, 0x000000ffff187224ULL, 0x002fe200078e0015ULL,
0x0000000000167805ULL, 0x000fe20000015200ULL, 0x018b806dff0075a7ULL, 0x000e6400080c0147ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b806dff0075a7ULL, 0x000e6400080c0147ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x0000000000167805ULL, 0x000fe20000015200ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0x00000000005c6947ULL, 0x002fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fce00078e00ffULL,
0x000000101d00780cULL, 0x000fda0003fc6270ULL, 0x000000000044e947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001416197210ULL, 0x000fca0007fde1ffULL,
0x0000000115157824ULL, 0x000fe200030e0e17ULL, 0x003d09001900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x000000000008e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x00000000001ce947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001914147211ULL, 0x000fca00078d10ffULL, 0x000000ffff157224ULL, 0x000fca00030e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011d1d7836ULL, 0x000fce0000000000ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0xfffffffc00a8e947ULL, 0x002fea000383ffffULL,
0x000000041c147824ULL, 0x000fc800078e021bULL, 0x00000040141e7824ULL, 0x000fe400078e00ffULL,
0x000000011c147836ULL, 0x000fc60000000000ULL, 0x000000405b1d7812ULL, 0x000fe400078ef81eULL,
0x0000000c14007c0cULL, 0x000fda000bfc6070ULL, 0x000000040054e947ULL, 0x000fea0003800000ULL,
0x000000015d207824ULL, 0x000fe200078e0270ULL, 0x000000091e187c48ULL, 0x000fe2000ffe0000ULL,
0x00000010121f7824ULL, 0x000fe200078e00ffULL, 0x00014000070e7890ULL, 0x000fe2000fffe03fULL,
0x0000000120177824ULL, 0x040fe200078e021dULL, 0x0000000720227c11ULL, 0x000fe2000f8e10ffULL,
0x0000000118187824ULL, 0x000fe200078e0a1eULL, 0x000000f01f1f7812ULL, 0x000fc600078ec0ffULL,
0x018a000022147984ULL, 0x000e620000000800ULL, 0x000000185d187248ULL, 0x000fca0007fe0000ULL,
0x0000000118217824ULL, 0x000fe200078e0a5dULL, 0x0000000714197c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00019167984ULL, 0x0004e40000000800ULL,
0x0000000120197824ULL, 0x044fe200078e0212ULL, 0x0000000420207819ULL, 0x000fc800000006ffULL,
0xfffffff020197812ULL, 0x000fe200078ee219ULL, 0x0000000270207836ULL, 0x000fc60000000000ULL,
0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL, 0x000000015d247824ULL, 0x000fc800078e0220ULL,
0x0000000124197824ULL, 0x000fe400078e021dULL, 0x0000000616177c24ULL, 0x008fc8000f8e0217ULL,
0x0000010017167825ULL, 0x002fc600078e0014ULL, 0x0000001f16167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x000000217000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000f101c4aULL,
0x018a080022187984ULL, 0x000ea20000000800ULL, 0x0000000124167824ULL, 0x042fe400078e0212ULL,
0x0000001024177824ULL, 0x000fca00078e00ffULL, 0xfffffff017167812ULL, 0x000fc800078ee216ULL,
0x0000000e16237c11ULL, 0x000fe4000f8e20ffULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000001f18187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x000000212000720cULL, 0x000fe20003fc6070ULL,
0x0000000470207836ULL, 0x000fe40000000000ULL, 0x0000000670707836ULL, 0x000fe40000000000ULL,
0x000000015d247824ULL, 0x000fc800078e0220ULL, 0x0000000124177824ULL, 0x000fc800078e021dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e8000f101c4aULL,
0x018a100022167984ULL, 0x000ea20000000800ULL, 0x0000000124187824ULL, 0x042fe400078e0212ULL,
0x0000001024197824ULL, 0x000fca00078e00ffULL, 0xfffffff019187812ULL, 0x000fc800078ee218ULL,
0x0000000e18197c11ULL, 0x000fe4000f8e20ffULL, 0x00000007161e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x0002a40000000800ULL, 0x000000015d1e7824ULL, 0x002fc800078e0270ULL,
0x000000011e1d7824ULL, 0x000fe400078e021dULL, 0x0000000616177c24ULL, 0x004fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000001f16167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x000000212000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016197faeULL, 0x0003e8000f101c4aULL,
0x018a180022187984ULL, 0x000ea20000000800ULL, 0x000000011e167824ULL, 0x042fe400078e0212ULL,
0x000000101e177824ULL, 0x000fca00078e00ffULL, 0xfffffff017167812ULL, 0x000fc800078ee216ULL,
0x0000000e16177c11ULL, 0x000fe4000f8e20ffULL, 0x0000000718187c11ULL, 0x004fcc000f8e10ffULL,
0x018ac00018187984ULL, 0x000e640000000800ULL, 0x00000006181d7c24ULL, 0x002fc8000f8e021dULL,
0x000001001d147825ULL, 0x000fc600078e0014ULL, 0x0000001f14147210ULL, 0x000fca0007fde0ffULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x000000217000720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000f101c4aULL,
0x0000000400247947ULL, 0x000fea0003800000ULL, 0x000000015d707824ULL, 0x000fe200078e0270ULL,
0x00014000070e7890ULL, 0x000fe2000fffe03fULL, 0x0000001012197824ULL, 0x000fe400078e00ffULL,
0x0000000170177824ULL, 0x040fe200078e021dULL, 0x00000007701f7c11ULL, 0x040fe2000f8e10ffULL,
0x00000010701e7824ULL, 0x040fe200078e00ffULL, 0x000000f019217812ULL, 0x000fe200078ec0ffULL,
0x0000000170197824ULL, 0x000fe400078e0212ULL, 0x018a00001f147984ULL, 0x000e620000000800ULL,
0x0000000270207836ULL, 0x000fc40000000000ULL, 0xfffffff01e197812ULL, 0x000fe400078ee219ULL,
0x0000000120227824ULL, 0x040fe400078e0212ULL, 0x0000000e19237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000120197824ULL, 0x000fe200078e021dULL, 0x0000000714187c11ULL, 0x002fe4000f8e10ffULL,
0x00008a00ff147b82ULL, 0x000e660000000a00ULL, 0x018ac00018167984ULL, 0x000ea40000000800ULL,
0x0000000616177c24ULL, 0x004fc8000f8e0217ULL, 0x0000010017167825ULL, 0x002fc600078e0014ULL,
0x0000002116167210ULL, 0x000fca0007fde0ffULL, 0x000000ffff177224ULL, 0x000fca00030e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e8000b901c4aULL,
0x018a08001f187984ULL, 0x000ea20000000800ULL, 0x0000001020177824ULL, 0x002fe200078e00ffULL,
0x0000000470207810ULL, 0x000fe20007ffe0ffULL, 0x0000000670707836ULL, 0x000fc60000000000ULL,
0xfffffff017227812ULL, 0x000fe200078ee222ULL, 0x0000000120177824ULL, 0x100fe400078e021dULL,
0x00000001701d7824ULL, 0x000fe200078e021dULL, 0x0000000e22237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000120227824ULL, 0x000fe200078e0212ULL, 0x00000007181e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e187984ULL, 0x000e640000000800ULL, 0x0000000618197c24ULL, 0x002fc8000f8e0219ULL,
0x0000010019187825ULL, 0x000fc600078e0014ULL, 0x0000002118187210ULL, 0x000fca0007fde0ffULL,
0x000000ffff197224ULL, 0x000fca00030e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e8000b901c4aULL, 0x018a10001f167984ULL, 0x000ea20000000800ULL,
0x0000001020197824ULL, 0x002fca00078e00ffULL, 0xfffffff019227812ULL, 0x000fc800078ee222ULL,
0x0000000e22197c11ULL, 0x000fe4000f8e20ffULL, 0x00000007161e7c11ULL, 0x004fca000f8e10ffULL,
0x018ac0001e167984ULL, 0x000e640000000800ULL, 0x0000000616177c24ULL, 0x002fc8000f8e0217ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x0000002116167210ULL, 0x000fca0007fde0ffULL,
0x000000ffff177224ULL, 0x000fca00030e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e8000b901c4aULL, 0x018a18001f187984ULL, 0x000ea40000000800ULL,
0x0000000718187c11ULL, 0x004fcc000f8e10ffULL, 0x018ac00018187984ULL, 0x000ea40000000800ULL,
0x00000006181d7c24ULL, 0x004fc8000f8e021dULL, 0x000001001d147825ULL, 0x000fc800078e0014ULL,
0x00000001701d7824ULL, 0x040fe200078e0212ULL, 0x0000002114147210ULL, 0x000fe20007fde0ffULL,
0x0000001070707824ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0xfffffff0701d7812ULL, 0x000fc800078ee21dULL, 0x0000000e1d1d7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e4000b901c4aULL,
0x00000001ff147424ULL, 0x002fcc00078e00ffULL, 0x018b8814ff1479a7ULL, 0x000e640008500007ULL,
0x000000ffff187224ULL, 0x002fe200078e0015ULL, 0x0000000000167805ULL, 0x000fc60000015200ULL,
0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL, 0x00000000005c6947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fce00078e00ffULL, 0x000000101d00780cULL, 0x000fda0003fc6270ULL,
0x000000000044e947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001416197210ULL, 0x000fca0007fde1ffULL, 0x0000000115157824ULL, 0x000fe200030e0e17ULL,
0x003d09001900780cULL, 0x000fc80003fc6070ULL, 0x000000ff1500720cULL, 0x000fda0003fc6360ULL,
0x000000000008e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003fc6070ULL,
0x000000ff1500720cULL, 0x000fda0003fc6360ULL, 0x00000000001ce947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078d10ffULL,
0x000000ffff157224ULL, 0x000fca00030e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011d1d7836ULL, 0x000fce0000000000ULL, 0x018b8818ff0075a7ULL, 0x000e6400080c0147ULL,
0xfffffffc00a8e947ULL, 0x002fea000383ffffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000001ff707424ULL, 0x000fc600078e00ffULL, 0x0000000000581947ULL, 0x000fea0003800000ULL,
0x0000001c5f00720cULL, 0x000fe20003fc4070ULL, 0x00009400ff187b82ULL, 0x000e620000000800ULL,
0x000000076e197c11ULL, 0x000fe4000f8e10ffULL, 0x000000ff1a147207ULL, 0x040fe40003000000ULL,
0x000000ff1a177207ULL, 0x000fc60007000000ULL, 0x000000011b1b7824ULL, 0x000fe400078e0214ULL,
0x00009200ff147b82ULL, 0x000ea20000000a00ULL, 0x000000015c177824ULL, 0x000fe400078e0217ULL,
0x000000401b167824ULL, 0x040fe200078e00ffULL, 0x0000001c1b1b7211ULL, 0x000fc800078ff0ffULL,
0x000000c016167812ULL, 0x000fca00078ec0ffULL, 0x000001001b167824ULL, 0x000fc800078e0216ULL,
0x0000002016167836ULL, 0x000fc80000000000ULL, 0x0000001817177224ULL, 0x102fe400078e0216ULL,
0x000000016e167824ULL, 0x040fe400078e0216ULL, 0x000000016e177824ULL, 0x000fc600078e0217ULL,
0x0000000916007c0cULL, 0x000fe2000bfc6070ULL, 0x0000000417147825ULL, 0x004fd800078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a0000014197faeULL, 0x0003e4000f12184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a48ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x018b7870ff7079a7ULL, 0x000e620008500007ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x00000006ff03723eULL, 0x000fc800000010ffULL, 0x0000541003147816ULL, 0x000fca0000000003ULL,
0x00001f6414037589ULL, 0x0004e800000e0000ULL, 0x00001f6314047589ULL, 0x00046400000e0000ULL,
0x01380000672c783bULL, 0x0004e20000000200ULL, 0x0000000000102947ULL, 0x000fea0003800000ULL,
0x000000032c2c7232ULL, 0x088fe40000200000ULL, 0x000000032e2e7232ULL, 0x000fe40000200000ULL,
0x000000042d2d7232ULL, 0x082fe40000200000ULL, 0x000000042f2f7232ULL, 0x000fce0000200000ULL,
0x000000006618783bULL, 0x000f280000004200ULL, 0x000000006514783bULL, 0x004ea20000004200ULL,
0x0000010018207824ULL, 0x010fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe20000011419ULL,
0x0000010019217824ULL, 0x040fe200078e00ffULL, 0x00008880193d7816ULL, 0x040fe200000000ffULL,
0x000100001a227824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000001e001e7306ULL, 0x000fe20000202400ULL, 0x00000018ff227819ULL, 0x000fc40000011422ULL,
0x00008880183c7816ULL, 0x040fe400000000ffULL, 0x00000018ff1f7819ULL, 0x000fe20000011418ULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff377819ULL, 0x000fe20000011419ULL,
0x0000002000397306ULL, 0x0009e20000202400ULL, 0x000000101b237819ULL, 0x000fe400000006ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141aULL, 0x000088801a197816ULL, 0x000fc400000000ffULL,
0x00000018ff247819ULL, 0x004fe20000011414ULL, 0x00000021002a7306ULL, 0x0005e20000202400ULL,
0x000001001a207824ULL, 0x010fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141bULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002200357306ULL, 0x0009e20000202400ULL, 0x000001001b217824ULL, 0x044fe200078e00ffULL,
0x000088801b327816ULL, 0x000fc400000000ffULL, 0x00000018ff367819ULL, 0x000fe40000011423ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000003c003c7306ULL, 0x000ea20000202400ULL,
0x0000010014227824ULL, 0x010fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011415ULL,
0x00000018ff307819ULL, 0x000fe40000011416ULL, 0x00000018ff237819ULL, 0x000fe20000011422ULL,
0x0000010015227824ULL, 0x000fe200078e00ffULL, 0x00000020001a7306ULL, 0x0009e20000202400ULL,
0x0000888016287816ULL, 0x000fc400000000ffULL, 0x0000888017297816ULL, 0x040fe400000000ffULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x000054103c3c7816ULL, 0x004fe20000000039ULL,
0x00000021001b7306ULL, 0x0005e20000202400ULL, 0x0000888014207816ULL, 0x050fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011417ULL,
0x0001000017397824ULL, 0x000fc600078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000001f001f7306ULL, 0x000fe20000202400ULL, 0x0000888015217816ULL, 0x044fe200000000ffULL,
0x0001000015157824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fc80000011439ULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000001800187306ULL, 0x000ff00000202400ULL,
0x0000003d003d7306ULL, 0x000eb00000202400ULL, 0x0000001900197306ULL, 0x000f220000202400ULL,
0x000054103d3d7816ULL, 0x004fce000000002aULL, 0x0000003200327306ULL, 0x000ea20000202400ULL,
0x0000003c2c3c723cULL, 0x008fee00000418ffULL, 0x0000001400277306ULL, 0x0007f00000202400ULL,
0x0000001500267306ULL, 0x000be20000202400ULL, 0x0000010016147824ULL, 0x008fc400078e00ffULL,
0x0001000016167824ULL, 0x000fc600078e00ffULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000010017157824ULL, 0x022fe200078e00ffULL,
0x00000014002b7306ULL, 0x0003e80000202400ULL, 0x00000018ff387819ULL, 0x000fc80000011415ULL,
0x0000001c001c7306ULL, 0x000ee20000202400ULL, 0x0000541018147816ULL, 0x002fe4000000001fULL,
0x0000541019187816ULL, 0x010fe4000000001aULL, 0x0000541032197816ULL, 0x004fc6000000001bULL,
0x0000001d001d7306ULL, 0x000fe80000202400ULL, 0x000000182c18723cULL, 0x000fe200000418ffULL,
0x00005410351c7816ULL, 0x008fc6000000001cULL, 0x0000002400247306ULL, 0x000e700000202400ULL,
0x0000002500257306ULL, 0x000ea20000202400ULL, 0x0000541027247816ULL, 0x002fce0000000024ULL,
0x0000003700377306ULL, 0x000e620000202400ULL, 0x0000541026257816ULL, 0x004fce0000000025ULL,
0x0000003600367306ULL, 0x000ea20000202400ULL, 0x000000242c24723cULL, 0x000fe200000418ffULL,
0x0000541037157816ULL, 0x002fcc000000001eULL, 0x0000002000207306ULL, 0x000fe20000202400ULL,
0x00005410361d7816ULL, 0x004fce000000001dULL, 0x0000002300237306ULL, 0x000e620000202400ULL,
0x0000001c2c1c723cULL, 0x000fee00000418ffULL, 0x0000002100217306ULL, 0x000fe20000202400ULL,
0x0000541020207816ULL, 0x002fce0000000023ULL, 0x0000002200227306ULL, 0x000e700000202400ULL,
0x0000002800287306ULL, 0x000ea20000202400ULL, 0x0000541021217816ULL, 0x002fce0000000022ULL,
0x0000002900297306ULL, 0x000fe20000202400ULL, 0x000000202c20723cULL, 0x000fe200000418ffULL,
0x0000541028287816ULL, 0x004fcc000000002bULL, 0x00000038002a7306ULL, 0x000e700000202400ULL,
0x0000003000307306ULL, 0x000fe20000202400ULL, 0x0000541029297816ULL, 0x002fce000000002aULL,
0x0000003100317306ULL, 0x000fe20000202400ULL, 0x000000282c28723cULL, 0x000fee00000418ffULL,
0x0000001600337306ULL, 0x0002b00000202400ULL, 0x0000003900327306ULL, 0x000ee20000202400ULL,
0x000000142c14723cULL, 0x002fe200000418ffULL, 0x0000541033307816ULL, 0x004fc40000000030ULL,
0x0000541032317816ULL, 0x008fce0000000031ULL, 0x000000302c2c723cULL, 0x000fe200000418ffULL,
0x013800006830783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000102947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000200000ULL,
0x0000000332327232ULL, 0x000fe40000200000ULL, 0x0000000431317232ULL, 0x080fe40000200000ULL,
0x0000000433337232ULL, 0x000fce0000200000ULL, 0x000000ff3400720cULL, 0x000fe20003f45270ULL,
0x000000006938783bULL, 0x000ee20000004200ULL, 0x000007c000007945ULL, 0x000fe60003800000ULL,
0x000000006a34783bULL, 0x000f220000004200ULL, 0x0000888038777816ULL, 0x008fe400000000ffULL,
0x00000018ff737819ULL, 0x010fe20000011434ULL, 0x0000010034557824ULL, 0x040fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011435ULL, 0x00000100356d7824ULL, 0x040fe200078e00ffULL,
0x0000888034547816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000888035747816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x0000007300737306ULL, 0x000fe20000202400ULL, 0x00000018ff557819ULL, 0x000fc40000011455ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff757819ULL, 0x000fe2000001146dULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x00000018ff6e7819ULL, 0x000fe40000011437ULL, 0x00000018ff6f7819ULL, 0x000fe40000011436ULL,
0x00000018ff6d7819ULL, 0x000fc60000011438ULL, 0x0000003400347306ULL, 0x000ef00000202400ULL,
0x0000003500357306ULL, 0x000f220000202400ULL, 0x0000541034347816ULL, 0x008fce0000000073ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x0000888036737816ULL, 0x000fe400000000ffULL,
0x0000541035357816ULL, 0x010fca0000000072ULL, 0x0000005500557306ULL, 0x000ee40000202400ULL,
0x000000343014723cULL, 0x004fec0000041814ULL, 0x0000007400747306ULL, 0x000fe20000202400ULL,
0x0000010037347824ULL, 0x000fe200078e00ffULL, 0x0000541054547816ULL, 0x008fcc0000000055ULL,
0x0000007500757306ULL, 0x000ea20000202400ULL, 0x00000018ff767819ULL, 0x000fe20000011434ULL,
0x0001000036347824ULL, 0x000fcc00078e00ffULL, 0x0000007300727306ULL, 0x0007e20000202400ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000541074557816ULL, 0x004fe20000000075ULL,
0x0000010036747824ULL, 0x000fe200078e00ffULL, 0x0000888037757816ULL, 0x000fc600000000ffULL,
0x0000007600767306ULL, 0x000fe20000202400ULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x000088803a737816ULL, 0x008fe400000000ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x00000054303c723cULL, 0x000fe2000004183cULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000007400357306ULL, 0x0004e20000202400ULL, 0x00000018ff367819ULL, 0x000fc6000001143bULL,
0x00000018ff557819ULL, 0x000fe40000011439ULL, 0x00000018ff547819ULL, 0x000fe4000001143aULL,
0x0000007500757306ULL, 0x000f220000202400ULL, 0x0000888039747816ULL, 0x004fce00000000ffULL,
0x0000003400787306ULL, 0x0007f00000202400ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x0000541072347816ULL, 0x008fe40000000035ULL, 0x0000541075357816ULL, 0x010fca0000000076ULL,
0x0000006e006e7306ULL, 0x000fe40000202400ULL, 0x000000343018723cULL, 0x000fec0000041818ULL,
0x0000003700377306ULL, 0x000ea20000202400ULL, 0x0000010038357824ULL, 0x000fe400078e00ffULL,
0x0000010039347824ULL, 0x000fc400078e00ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000007700777306ULL, 0x000fe20000202400ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff397819ULL, 0x000fca0000011439ULL,
0x0000003500767306ULL, 0x0004f00000202400ULL, 0x0000003400757306ULL, 0x0009e20000202400ULL,
0x0000541037357816ULL, 0x004fce000000006eULL, 0x0000007400747306ULL, 0x000ea20000202400ULL,
0x0000541078347816ULL, 0x010fe4000000006fULL, 0x000088803b6f7816ULL, 0x000fca00000000ffULL,
0x00000034301c723cULL, 0x000fe2000004181cULL, 0x0000006d006d7306ULL, 0x000fec0000202400ULL,
0x000001003b357824ULL, 0x040fe400078e00ffULL, 0x000001003a347824ULL, 0x040fe200078e00ffULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011435ULL, 0x000100003a357824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff377819ULL, 0x000fe4000001143bULL,
0x0000003800387306ULL, 0x000f220000202400ULL, 0x00000018ff357819ULL, 0x000fce0000011435ULL,
0x00000039006e7306ULL, 0x000f700000202400ULL, 0x0000003400727306ULL, 0x0007f00000202400ULL,
0x0000003500397306ULL, 0x0005e20000202400ULL, 0x0000541077347816ULL, 0x008fce0000000076ULL,
0x0000007300737306ULL, 0x000ee20000202400ULL, 0x0000541074357816ULL, 0x004fce0000000075ULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x000000343020723cULL, 0x000fee0000041820ULL,
0x00000078003a7306ULL, 0x000ea20000202400ULL, 0x0000541038347816ULL, 0x010fe4000000006dULL,
0x000054106e357816ULL, 0x022fca0000000055ULL, 0x0000005400547306ULL, 0x000e640000202400ULL,
0x000000343024723cULL, 0x000fec0000041824ULL, 0x0000003600367306ULL, 0x000fe20000202400ULL,
0x0000541073347816ULL, 0x008fe40000000072ULL, 0x000054106f357816ULL, 0x004fca000000003aULL,
0x0000003700377306ULL, 0x000ea40000202400ULL, 0x000000343028723cULL, 0x000fee0000041828ULL,
0x0000541039347816ULL, 0x002fe40000000054ULL, 0x0000541037357816ULL, 0x004fce0000000036ULL,
0x00000034302c723cULL, 0x000fe2000004182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000403947ULL, 0x000fde0001000000ULL, 0x0000003c0b0b7221ULL, 0x000fe20000010000ULL,
0x0000003d0c0c7221ULL, 0x000fe20000010000ULL, 0x000000140f0f7221ULL, 0x000fe20000010000ULL,
0x0000001510107221ULL, 0x000fe20000010000ULL, 0x0000001841417221ULL, 0x000fe20000010000ULL,
0x0000001942427221ULL, 0x000fe20000010000ULL, 0x0000001c45457221ULL, 0x000fe20000010000ULL,
0x0000001d46467221ULL, 0x000fe20000010000ULL, 0x0000002049497221ULL, 0x000fe20000010000ULL,
0x000000214a4a7221ULL, 0x000fe20000010000ULL, 0x000000244d4d7221ULL, 0x000fe20000010000ULL,
0x000000254e4e7221ULL, 0x000fe20000010000ULL, 0x0000002851517221ULL, 0x000fe20000010000ULL,
0x0000002952527221ULL, 0x000fe20000010000ULL, 0x0000002c57577221ULL, 0x000fe20000010000ULL,
0x0000002d58587221ULL, 0x000fce0000010000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe80003800000ULL, 0x0000000000404947ULL, 0x000fea0002800000ULL,
0x0000003e0d0d7221ULL, 0x000fe20000010000ULL, 0x0000003f0e0e7221ULL, 0x000fe20000010000ULL,
0x0000001611117221ULL, 0x000fe20000010000ULL, 0x0000001740407221ULL, 0x000fe20000010000ULL,
0x0000001a43437221ULL, 0x000fe20000010000ULL, 0x0000001b44447221ULL, 0x000fe20000010000ULL,
0x0000001e47477221ULL, 0x000fe20000010000ULL, 0x0000001f48487221ULL, 0x000fe20000010000ULL,
0x000000224b4b7221ULL, 0x000fe20000010000ULL, 0x000000234c4c7221ULL, 0x000fe20000010000ULL,
0x000000264f4f7221ULL, 0x000fe20000010000ULL, 0x0000002750507221ULL, 0x000fe20000010000ULL,
0x0000002a53537221ULL, 0x000fe20000010000ULL, 0x0000002b56567221ULL, 0x000fe20000010000ULL,
0x0000002e59597221ULL, 0x000fe20000010000ULL, 0x0000002f5a5a7221ULL, 0x000fce0000010000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000016c6c7836ULL, 0x000fe40000000000ULL, 0x018b8816ff1479a7ULL, 0x000e660008500007ULL,
0x0000006b6c00720cULL, 0x000fe20003f46070ULL, 0x000000ffff187224ULL, 0x002fd800078e0015ULL,
0xffffffb0006ca947ULL, 0x000fea000383ffffULL, 0x018b7016ffff79a7ULL, 0x0003e40008500007ULL,
0x0000000108087836ULL, 0x000fca0000000000ULL, 0x0000000c08007c0cULL, 0x000fda000bf06070ULL,
0xfffffec000688947ULL, 0x000fea000383ffffULL, 0x0000000cff007c0cULL, 0x000fe2000bf05270ULL,
0x000000ffff127224ULL, 0x000fe400078e0011ULL, 0x000000ffff117224ULL, 0x000fe200078e0010ULL,
0x0000000e00107202ULL, 0x000fe20000000f00ULL, 0x000000ffff097224ULL, 0x000fd000078e000cULL,
0x0000000000d48947ULL, 0x000fea0003800000ULL, 0x018000000a007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x00015c0000047802ULL, 0x002fce0000000f00ULL, 0x0000008800547944ULL, 0x004fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000000a00037308ULL, 0x004ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc8000000000aULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009a00ff027b82ULL, 0x000f240000000a00ULL, 0x0000000a02037981ULL, 0x010f22000c1e9900ULL,
0x0000000000057919ULL, 0x002e640000000000ULL, 0x00000002ff077819ULL, 0x002fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x01cfca0000410000ULL,
0x00001f0700047589ULL, 0x000e6800000e0000ULL, 0x00001f0500057589ULL, 0x000ea200000e0000ULL,
0x0000000b040b7220ULL, 0x042fe20000410000ULL, 0x0000000904097220ULL, 0x040fe20000410000ULL,
0x0000000f040f7220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x040fe20000410000ULL,
0x0000004104417220ULL, 0x040fe20000410000ULL, 0x0000004204427220ULL, 0x040fe20000410000ULL,
0x0000004504457220ULL, 0x040fe20000410000ULL, 0x0000004604467220ULL, 0x040fe20000410000ULL,
0x0000004904497220ULL, 0x040fe20000410000ULL, 0x0000004a044a7220ULL, 0x040fe20000410000ULL,
0x0000004d044d7220ULL, 0x040fe20000410000ULL, 0x0000004e044e7220ULL, 0x040fe20000410000ULL,
0x0000005104517220ULL, 0x040fe20000410000ULL, 0x0000005204527220ULL, 0x040fe20000410000ULL,
0x0000005704577220ULL, 0x040fe20000410000ULL, 0x0000005804587220ULL, 0x000fe20000410000ULL,
0x0000000d050d7220ULL, 0x044fe20000410000ULL, 0x0000001005107220ULL, 0x040fe20000410000ULL,
0x0000001205127220ULL, 0x040fe20000410000ULL, 0x0000004005407220ULL, 0x040fe20000410000ULL,
0x0000004305437220ULL, 0x040fe20000410000ULL, 0x0000004405447220ULL, 0x040fe20000410000ULL,
0x0000004705477220ULL, 0x040fe20000410000ULL, 0x0000004805487220ULL, 0x040fe20000410000ULL,
0x0000004b054b7220ULL, 0x040fe20000410000ULL, 0x0000004c054c7220ULL, 0x040fe20000410000ULL,
0x0000004f054f7220ULL, 0x040fe20000410000ULL, 0x0000005005507220ULL, 0x040fe20000410000ULL,
0x0000005305537220ULL, 0x040fe20000410000ULL, 0x0000005605567220ULL, 0x040fe20000410000ULL,
0x0000005905597220ULL, 0x040fe20000410000ULL, 0x0000005a055a7220ULL, 0x000fce0000410000ULL,
0x0000000000147919ULL, 0x000ee20000000000ULL, 0x0000000761617c11ULL, 0x000fe2000f8e58ffULL,
0x00000000000479c3ULL, 0x000f220000002600ULL, 0x0000004d4e4d723eULL, 0x000fce00000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000515251723eULL, 0x000fe400000010ffULL,
0x000000575857723eULL, 0x000fe400000010ffULL, 0x000000434443723eULL, 0x000fc400000010ffULL,
0x000000474847723eULL, 0x000fe400000010ffULL, 0x0000004b4c4b723eULL, 0x000fe400000010ffULL,
0x0000004f504f723eULL, 0x000fe400000010ffULL, 0x000000535653723eULL, 0x000fe400000010ffULL,
0x000000595a59723eULL, 0x000fe400000010ffULL, 0x000054104b4e7816ULL, 0x000fc4000000004fULL,
0x000076324b4f7816ULL, 0x000fe4000000004fULL, 0x0000541053587816ULL, 0x100fe40000000059ULL,
0x00000002ff077819ULL, 0x008fe40000011614ULL, 0x0000000214007812ULL, 0x040fe400078ec0ffULL,
0x0000000814057811ULL, 0x002fe200078ff0ffULL, 0x0000000807157824ULL, 0x040fe200078e00ffULL,
0x0000000700027211ULL, 0x044fe200078ff8ffULL, 0x0000000807087824ULL, 0x000fe200078e00ffULL,
0x0000000500037211ULL, 0x000fe200078ff8ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000763253597816ULL, 0x000fe20000000059ULL, 0x0000000807057824ULL, 0x000fc400078e00ffULL,
0x0000000202007836ULL, 0x000fe20000000000ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee203ULL,
0x0000000402037836ULL, 0x000fe40000000000ULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0xfffffff805067812ULL, 0x000fe400078ee200ULL, 0x00000003ff057819ULL, 0x100fe40000011614ULL,
0xfffffff815007812ULL, 0x000fe200078ee202ULL, 0x0000000602027836ULL, 0x000fe20000000000ULL,
0xfffffff808087812ULL, 0x000fe200078ee203ULL, 0x0000000105047824ULL, 0x000fc400078e0214ULL,
0x0001200061037836ULL, 0x000fe20000000000ULL, 0xfffffff8070a7812ULL, 0x000fe200078ee202ULL,
0x0000000814027824ULL, 0x000fe200078e00ffULL, 0x0000000704077812ULL, 0x000fe200078ec0ffULL,
0x0000001000047824ULL, 0x100fe400078e0203ULL, 0x000000100c0c7824ULL, 0x100fe200078e0203ULL,
0x0ffffff807007812ULL, 0x000fe200078ef814ULL, 0x0000001006067824ULL, 0x100fe200078e0203ULL,
0x0000000714147812ULL, 0x000fe200078ec0ffULL, 0x0000001008087824ULL, 0x000fc400078e0203ULL,
0x000000100a0a7824ULL, 0x000fe200078e0203ULL, 0x0000000802037812ULL, 0x000fe200078ec0ffULL,
0x0000001000617824ULL, 0x000fe200078e0261ULL, 0x0000000b0900723eULL, 0x000fe400000010ffULL,
0x0000000f1102723eULL, 0x000fe200000010ffULL, 0x0000000104047824ULL, 0x000fe200078e0203ULL,
0x1ffffff8145d7812ULL, 0x000fe200078ef85dULL, 0x0000000103067824ULL, 0x040fe200078e0206ULL,
0x00005410000e7816ULL, 0x040fe20000000002ULL, 0x00000001030c7824ULL, 0x040fe200078e020cULL,
0x00007632000f7816ULL, 0x000fe20000000002ULL, 0x0000000103087824ULL, 0x040fe200078e0208ULL,
0x000000414200723eULL, 0x000fe200000010ffULL, 0x00000001030a7824ULL, 0x000fe200078e020aULL,
0x000000454602723eULL, 0x000fe200000010ffULL, 0x0000000e04007388ULL, 0x0003e20000000a00ULL,
0x000000494a03723eULL, 0x000fc400000010ffULL, 0x0000541043467816ULL, 0x140fe40000000047ULL,
0x0000763243477816ULL, 0x000fe40000000047ULL, 0x00005410000e7816ULL, 0x142fe40000000002ULL,
0x00007632000f7816ULL, 0x000fe40000000002ULL, 0x0000000d1000723eULL, 0x000fe400000010ffULL,
0x000000124002723eULL, 0x000fe200000010ffULL, 0x0000000e06007388ULL, 0x0003e40000000a00ULL,
0x00005410030e7816ULL, 0x002fc4000000004dULL, 0x00007632030f7816ULL, 0x000fca000000004dULL,
0x0000000e08007388ULL, 0x0003e40000000a00ULL, 0x00005410510e7816ULL, 0x142fe40000000057ULL,
0x00007632510f7816ULL, 0x000fca0000000057ULL, 0x0000000e0a007388ULL, 0x0003e40000000a00ULL,
0x00005410000e7816ULL, 0x142fe40000000002ULL, 0x00007632000f7816ULL, 0x000fe40000000002ULL,
0x00008400ff007b82ULL, 0x000e660000000800ULL, 0x0000000e0c007388ULL, 0x000fe80000000a00ULL,
0x0004004606007388ULL, 0x000fe80000000a00ULL, 0x0004004e08007388ULL, 0x000fe80000000a00ULL,
0x000400580a007388ULL, 0x000fe20000000a00ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x01200000610c7984ULL, 0x000ea20000000c00ULL, 0x0000000013137224ULL, 0x082fe400078e02ffULL,
0x0000000405007e24ULL, 0x010fe2000f8e0200ULL, 0x0000860000047ab9ULL, 0x000fc80000000a00ULL,
0x0000000013007211ULL, 0x000fca00078010ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x0000000400027c11ULL, 0x000fc8000f8048ffULL, 0x0000000500037c11ULL, 0x000fc600080f4c03ULL,
0x000000105d027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x004fe2000c101d0aULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000030200780cULL, 0x040fe20003f44070ULL,
0x00009400ff037b82ULL, 0x000e620000000800ULL, 0x0000004061477824ULL, 0x040fe200078e00ffULL,
0x00000001ff437819ULL, 0x000fe20000011661ULL, 0x0000002002047836ULL, 0x000fe20000000000ULL,
0x0000000761457c11ULL, 0x000fe2000f8e40ffULL, 0x0000000147067824ULL, 0x040fe400078e0202ULL,
0x0000000147057824ULL, 0x000fe200078e0204ULL, 0x00009200ff087b82ULL, 0x000ea20000000a00ULL,
0x00000004020f7824ULL, 0x000fe200078e0245ULL, 0x0000000906007c0cULL, 0x000fc4000bf06070ULL,
0x0000000905007c0cULL, 0x000fe2000bf26070ULL, 0x000000041305a824ULL, 0x000fe200078e0202ULL,
0x000000054300ac0cULL, 0x000fe4000bf66070ULL, 0x00009000ff0eab82ULL, 0x000ef00000000800ULL,
0x00008c00ff0aab82ULL, 0x000f220000000a00ULL, 0x000000035c037224ULL, 0x002fca00078e0247ULL,
0x0000000203077210ULL, 0x000fe20007ffe0ffULL, 0x0000000103037824ULL, 0x000fe200078e0204ULL,
0x00009a00ff0c7b82ULL, 0x000e620000000a00ULL, 0x000000020504a824ULL, 0x000fe200078e00ffULL,
0x000000076105ac11ULL, 0x000fe2000f8e20ffULL, 0x0000000407067825ULL, 0x004fc800078e0008ULL,
0x0000000403087825ULL, 0x000fc800078e0008ULL, 0x0000000e0403a224ULL, 0x008fe400078e0243ULL,
0x00000001ff047424ULL, 0x000fe400078e00ffULL, 0x000000040211a824ULL, 0x000fe400078e0205ULL,
0x00000004030aa825ULL, 0x010fe400078e000aULL, 0x018ad004ff0479a7ULL, 0x000ea20008500007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18600000060f7faeULL, 0x0007e8000c12184aULL,
0x18680000080f7faeULL, 0x0007e8000c92184aULL, 0x18a800000a11afaeULL, 0x0007e8000d92184aULL,
0x00000000000079afULL, 0x000e280000000000ULL, 0x0000000a0c037981ULL, 0x002722000c1e9900ULL,
0x000001ff0800788cULL, 0x000fe2000bf04070ULL, 0x0000008000007824ULL, 0x000fe200078e00ffULL,
0x0000000706067899ULL, 0x000fc8000800063fULL, 0x000000000000781cULL, 0x000fe40003f0f008ULL,
0x0000004000047812ULL, 0x004fe200078ef847ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000001000a40947ULL, 0x008fea0003800000ULL,
0x00000003ff097819ULL, 0x100fe40000011602ULL, 0x0000000761087c11ULL, 0x000fe4000f8e20ffULL,
0x00000009470e7c48ULL, 0x000fe2000ffe0000ULL, 0x00000004090a7824ULL, 0x040fe400078e0245ULL,
0x00000001040c7824ULL, 0x000fe400078e0209ULL, 0x00000001090f7824ULL, 0x000fe200078e0202ULL,
0x018600000a077984ULL, 0x000e620000000800ULL, 0x000000010e0e7824ULL, 0x000fc600078e0a47ULL,
0x000000070f0f7812ULL, 0x000fe400078ec0ffULL, 0x0000000e0900720cULL, 0x000fe20003f06070ULL,
0x00000004070d7824ULL, 0x002fe400078e0208ULL, 0x00008a00ff067b82ULL, 0x000e660000000a00ULL,
0x018a80000d0b7984ULL, 0x0004e40000000800ULL, 0x0ffffff80f0d7812ULL, 0x004fe200078ef802ULL,
0x000000060b117c24ULL, 0x008fe2000f8e020cULL, 0x00000070100b7812ULL, 0x000fc400078ec0ffULL,
0x00000007610c7c11ULL, 0x000fe2000f8e70ffULL, 0x0000010011107825ULL, 0x002fc800078e0006ULL,
0x000020000c0c7836ULL, 0x000fe20000000000ULL, 0x000000100b147210ULL, 0x000fc60007f3e0ffULL,
0x000000100d0d7824ULL, 0x000fe400078e020cULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018610000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000004090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018620000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000008090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018630000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x0000000c090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x000000010f127824ULL, 0x040fe200078e0202ULL, 0x0000000f04117210ULL, 0x000fe40007ffe0ffULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018640000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000010090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018650000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000014090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018660000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000018090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018670000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x0000001c090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fc80007f3e0ffULL, 0x00000011ff157210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018680000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000020090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x018690000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000024090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x0186a0000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000028090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x0186b0000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x0000002c090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x0186c0000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe200078e0208ULL,
0x00000030090f7810ULL, 0x000fc80007ffe0ffULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x0186d0000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000034090f7836ULL, 0x000fc60000000000ULL, 0x018a800016107984ULL, 0x000ea20000000800ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x0000000e0f00720cULL, 0x040fe20003f06070ULL,
0x000000010f127824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b147210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff157224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e8000c101c4aULL,
0x0186e0000a0f7984ULL, 0x000ea40000000800ULL, 0x000000040f167824ULL, 0x004fe400078e0208ULL,
0x00000038090f7836ULL, 0x000fe40000000000ULL, 0x0000003c09097836ULL, 0x000fe20000000000ULL,
0x018a800016107984ULL, 0x000ea20000000800ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000010f127824ULL, 0x000fc400078e0202ULL,
0x000000080f0f7824ULL, 0x000fe400078e00ffULL, 0x0000000109027824ULL, 0x000fc600078e0202ULL,
0xfffffff80f0d7812ULL, 0x002fca00078ee212ULL, 0x000000100d0d7824ULL, 0x000fe400078e020cULL,
0x0000000610117c24ULL, 0x004fc8000f8e0211ULL, 0x0000010011107825ULL, 0x000fc600078e0006ULL,
0x000000100b107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fca00008e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100d7faeULL, 0x0003e2000c101c4aULL,
0x0000000e0900720cULL, 0x000fc60003f06070ULL, 0x0186f0000a0f7984ULL, 0x000ea40000000800ULL,
0x000000040f087824ULL, 0x004fe400078e0208ULL, 0x00000001040f7824ULL, 0x000fe400078e0209ULL,
0x0000000809097824ULL, 0x000fe400078e00ffULL, 0x018a800008087984ULL, 0x000ea60000000800ULL,
0xfffffff809097812ULL, 0x000fca00078ee202ULL, 0x0000001009097824ULL, 0x000fe400078e020cULL,
0x00000006080f7c24ULL, 0x004fc8000f8e020fULL, 0x000001000f067825ULL, 0x000fc600078e0006ULL,
0x000000060b067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e2000c101c4aULL,
0x0000001000587947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fe40000011602ULL,
0x00000007610a7c11ULL, 0x040fe4000f8e20ffULL, 0x0000000761127c11ULL, 0x000fe2000f8e70ffULL,
0x00000004090c7824ULL, 0x000fe200078e0245ULL, 0x00000070100b7812ULL, 0x000fe200078ec0ffULL,
0x00000001040f7824ULL, 0x000fe400078e0209ULL, 0x0000000409157836ULL, 0x000fe20000000000ULL,
0x018600000c077984ULL, 0x000e660000000800ULL, 0x0000000815167824ULL, 0x000fc400078e00ffULL,
0x00000004070d7824ULL, 0x002fe400078e020aULL, 0x00008a00ff067b82ULL, 0x000e660000000a00ULL,
0x018a80000d087984ULL, 0x000ea40000000800ULL, 0x00000006080f7c24ULL, 0x004fe4000f8e020fULL,
0x0000000109087824ULL, 0x000fe400078e0202ULL, 0x000001000f0e7825ULL, 0x002fc600078e0006ULL,
0x0000000708117812ULL, 0x000fe400078ec0ffULL, 0x0000200012087810ULL, 0x000fe40007ffe0ffULL,
0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fe200078e0215ULL,
0x0ffffff8110d7812ULL, 0x000fc600078ef802ULL, 0x000000ffff117224ULL, 0x000fe400000e060fULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e8000b901c4aULL, 0x018610000c0d7984ULL, 0x000ea20000000800ULL,
0x0000000809117836ULL, 0x002fe40000000000ULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001150d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0211ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff157224ULL, 0x000fe400000e060fULL,
0x0000000811167824ULL, 0x000fe400078e00ffULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e8000b901c4aULL,
0x018620000c0d7984ULL, 0x000ea20000000800ULL, 0x0000000c09157836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001110d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0215ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff117224ULL, 0x000fe400000e060fULL, 0x0000000815167824ULL, 0x000fe400078e00ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e8000b901c4aULL, 0x018630000c0d7984ULL, 0x000ea20000000800ULL,
0x0000001009117836ULL, 0x002fe40000000000ULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001150d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0211ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff157224ULL, 0x000fe400000e060fULL,
0x0000000811167824ULL, 0x000fe400078e00ffULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e8000b901c4aULL,
0x018640000c0d7984ULL, 0x000ea20000000800ULL, 0x0000001409157836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001110d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0215ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff117224ULL, 0x000fe400000e060fULL, 0x0000000815167824ULL, 0x000fe400078e00ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e8000b901c4aULL, 0x018650000c0d7984ULL, 0x000ea20000000800ULL,
0x0000001809117836ULL, 0x002fe20000000000ULL, 0x0000000a0d127211ULL, 0x004fca00078e10ffULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001150d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0211ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff157224ULL, 0x000fe400000e060fULL,
0x0000000811167824ULL, 0x000fe400078e00ffULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e8000b901c4aULL,
0x018660000c0d7984ULL, 0x000ea20000000800ULL, 0x0000001c09157836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001110d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0215ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff117224ULL, 0x000fe400000e060fULL, 0x0000000815167824ULL, 0x000fe400078e00ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e8000b901c4aULL, 0x018670000c0d7984ULL, 0x000ea20000000800ULL,
0x0000002009117836ULL, 0x002fe40000000000ULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001150d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0211ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff157224ULL, 0x000fe400000e060fULL,
0x0000000811167824ULL, 0x000fe400078e00ffULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e8000b901c4aULL,
0x018680000c0d7984ULL, 0x000ea20000000800ULL, 0x0000002409157836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001110d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0215ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff117224ULL, 0x000fe400000e060fULL, 0x0000000815167824ULL, 0x000fe400078e00ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e8000b901c4aULL, 0x018690000c0d7984ULL, 0x000ea20000000800ULL,
0x0000002809117836ULL, 0x002fe40000000000ULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fe200078e0006ULL, 0x00000002150d7210ULL, 0x000fe40007ffe0ffULL,
0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fe200078e0211ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x0000000811167824ULL, 0x000fe400078e00ffULL,
0x000000ffff157224ULL, 0x000fe400000e060fULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e8000b901c4aULL,
0x0186a0000c0d7984ULL, 0x000ea20000000800ULL, 0x0000002c09157836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001110d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0215ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff117224ULL, 0x000fe400000e060fULL, 0x0000000815167824ULL, 0x000fe400078e00ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e8000b901c4aULL, 0x0186b0000c0d7984ULL, 0x000ea20000000800ULL,
0x0000003009117836ULL, 0x002fe40000000000ULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x000e640000000800ULL, 0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001150d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL, 0x00000001040e7824ULL, 0x000fc600078e0211ULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff157224ULL, 0x000fe400000e060fULL,
0x0000000811167824ULL, 0x000fe400078e00ffULL, 0x000000100d177824ULL, 0x000fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e8000b901c4aULL,
0x0186c0000c0d7984ULL, 0x000ea20000000800ULL, 0x0000003409157836ULL, 0x002fe40000000000ULL,
0x000000040d127824ULL, 0x004fca00078e020aULL, 0x018a8000120d7984ULL, 0x000e640000000800ULL,
0x000000060d0d7c24ULL, 0x002fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001110d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0215ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff117224ULL, 0x000fe400000e060fULL, 0x0000000815167824ULL, 0x000fe400078e00ffULL,
0x000000100d177824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0003e8000b901c4aULL, 0x0186d0000c0d7984ULL, 0x000ea20000000800ULL,
0x0000003809177836ULL, 0x002fe40000000000ULL, 0x000000040d127824ULL, 0x004fca00078e020aULL,
0x018a8000120d7984ULL, 0x0002a40000000800ULL, 0x0000000817127824ULL, 0x002fe400078e00ffULL,
0x000000060d0d7c24ULL, 0x004fc8000f8e020eULL, 0x000001000d0e7825ULL, 0x000fc800078e0006ULL,
0x00000001150d7824ULL, 0x000fe200078e0202ULL, 0x0000000b0e147210ULL, 0x000fe20007f1e0ffULL,
0x00000001040e7824ULL, 0x000fc600078e0217ULL, 0xfffffff8160d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff157224ULL, 0x000fc600000e060fULL, 0x000000080d117211ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014117faeULL, 0x0003e8000b901c4aULL,
0x0186e0000c0d7984ULL, 0x000ea40000000800ULL, 0x000000040d107824ULL, 0x004fca00078e020aULL,
0x018a8000100d7984ULL, 0x000ea40000000800ULL, 0x000000060d0d7c24ULL, 0x004fc8000f8e020eULL,
0x000001000d0e7825ULL, 0x000fc800078e0006ULL, 0x00000001170d7824ULL, 0x000fe200078e0202ULL,
0x0000000b0e0e7210ULL, 0x000fc80007f1e0ffULL, 0xfffffff8120d7812ULL, 0x000fe200078ee20dULL,
0x000000ffff0f7224ULL, 0x000fc800000e060fULL, 0x000000100d117824ULL, 0x002fca00078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e117faeULL, 0x0003e8000b901c4aULL,
0x0186f0000c0d7984ULL, 0x000ea40000000800ULL, 0x000000040d0a7824ULL, 0x004fe400078e020aULL,
0x0000003c090d7836ULL, 0x000fc80000000000ULL, 0x018a80000a0a7984ULL, 0x000ea20000000800ULL,
0x0000000104097824ULL, 0x000fe400078e020dULL, 0x000000010d027824ULL, 0x000fe400078e0202ULL,
0x000000060a097c24ULL, 0x004fc8000f8e0209ULL, 0x0000010009067825ULL, 0x000fc800078e0006ULL,
0x000000080d097824ULL, 0x000fe200078e00ffULL, 0x0000000b06067210ULL, 0x000fc80007f1e0ffULL,
0xfffffff809097812ULL, 0x000fe200078ee202ULL, 0x000000ffff077224ULL, 0x000fc800000e0607ULL,
0x0000001009097824ULL, 0x000fca00078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e4000b901c4aULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x002fce0000015200ULL,
0x018ad005ff0075a7ULL, 0x000e640008000147ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff047224ULL, 0x000fce00078e00ffULL, 0x000000100400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fce0000015200ULL,
0x00000008060b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011409ULL, 0x0000000b02027211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000202027819ULL, 0x000fc80000001209ULL,
0x000000020000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000104047836ULL, 0x000fce0000000000ULL, 0x018ad005ff0075a7ULL, 0x000e640008000147ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x0000002061027824ULL, 0x002fca00078e0202ULL, 0x00000003ff047819ULL, 0x000fe40000011602ULL,
0x0000000f02027812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe04057812ULL, 0x000fc600078ec0ffULL,
0x0000000102047836ULL, 0x000fe40000000000ULL, 0x0000000102067824ULL, 0x040fe400078e0205ULL,
0x0000000105077824ULL, 0x000fe400078e0204ULL, 0x0000002002087824ULL, 0x000fe200078e00ffULL,
0x0000001f06067812ULL, 0x000fe200078ec0ffULL, 0x0000002002097824ULL, 0x000fe200078e00ffULL,
0x0000001f07077812ULL, 0x000fe200078ec0ffULL, 0x0000001005057836ULL, 0x000fc40000000000ULL,
0x0000002002117824ULL, 0x040fe200078e00ffULL, 0x000001e008077812ULL, 0x000fe200078ee207ULL,
0x0000000102107824ULL, 0x100fe200078e0205ULL, 0x000001e009067812ULL, 0x000fe200078ee206ULL,
0x0000000104047824ULL, 0x000fe200078e0205ULL, 0x0000000707077c11ULL, 0x000fe2000f8e20ffULL,
0x0000002002057824ULL, 0x000fe200078e00ffULL, 0x0000000706067c11ULL, 0x000fe4000f8e20ffULL,
0x0000001f10107812ULL, 0x000fe200078ec0ffULL, 0x0000000007087984ULL, 0x000e620000000c00ULL,
0x0000001f04047812ULL, 0x000fc400078ec0ffULL, 0x000001e005107812ULL, 0x000fe200078ee210ULL,
0x00000000060c7984ULL, 0x000ea20000000c00ULL, 0x000001e011047812ULL, 0x000fe400078ee204ULL,
0x0000000710107c11ULL, 0x000fe4000f8e20ffULL, 0x0000000704027c11ULL, 0x000fe2000f8e20ffULL,
0x00000001ff047424ULL, 0x000fe400078e00ffULL, 0x000000ffff167224ULL, 0x002fe200078e0008ULL,
0x0000000a00177202ULL, 0x000fe20000000f00ULL, 0x000000ffff1a7224ULL, 0x000fc400078e0009ULL,
0x000000ffff147224ULL, 0x004fe400078e000cULL, 0x000000ffff157224ULL, 0x000fe400078e000eULL,
0x000000ffff1b7224ULL, 0x000fe400078e000bULL, 0x000000ffff187224ULL, 0x000fe200078e000dULL,
0x0000001406007388ULL, 0x000fe20000000c00ULL, 0x000000ffff197224ULL, 0x000fca00078e000fULL,
0x0000001807007388ULL, 0x000fe80000000c00ULL, 0x0000000002087984ULL, 0x000e680000000c00ULL,
0x00000000100c7984ULL, 0x000ea20000000c00ULL, 0x000000ffff1e7224ULL, 0x002fe400078e0008ULL,
0x000000ffff1f7224ULL, 0x000fc400078e000aULL, 0x000000ffff1c7224ULL, 0x004fe400078e000cULL,
0x000000ffff1d7224ULL, 0x000fe400078e000eULL, 0x000000ffff227224ULL, 0x000fe400078e0009ULL,
0x000000ffff237224ULL, 0x000fe200078e000bULL, 0x0000001c10007388ULL, 0x0003e20000000c00ULL,
0x000000ffff207224ULL, 0x000fe400078e000dULL, 0x000000ffff217224ULL, 0x000fca00078e000fULL,
0x0000002002007388ULL, 0x0003e20000000c00ULL, 0x018ad004ff0479a7ULL, 0x000ea40008500007ULL,
0x000000ffff087224ULL, 0x006fce00078e0005ULL, 0x0000000000047805ULL, 0x000fce0000015200ULL,
0x018ad008ff0075a7ULL, 0x000e640008000147ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0a7224ULL, 0x000fce00078e00ffULL, 0x000000100a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x0000000604097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011407ULL, 0x0000000902027211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000202027819ULL, 0x000fc80000001207ULL,
0x000000020000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010a0a7836ULL, 0x000fce0000000000ULL, 0x018ad008ff0075a7ULL, 0x000e640008000147ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000cff007c0cULL, 0x000fda000bf05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x3d80000003037820ULL, 0x010fe20000410000ULL, 0x0000000761047c11ULL, 0x000fe2000f8e28ffULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00000000030e72caULL, 0x000fe200000e0000ULL,
0xffffffff0c0d7890ULL, 0x000fe2000fffe03fULL, 0x0000000761037c11ULL, 0x000fe2000f8e18ffULL,
0x0000000704087899ULL, 0x000fd8000800063fULL, 0x00000100445a7824ULL, 0x000fca00078e0247ULL,
0x000000095a007c0cULL, 0x000fda000bf01070ULL, 0x000000000000894dULL, 0x00afea0003800000ULL,
0x00000001ff637424ULL, 0x000fe200078e00ffULL, 0x000000445f00720cULL, 0x000fe20003f44070ULL,
0x0000003f00047c82ULL, 0x000fc60008000000ULL, 0x0000000463637807ULL, 0x000fd20001000000ULL,
0x000000ffff367224ULL, 0x000fe200078e0006ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff667224ULL, 0x000fe200078e00ffULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fc4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000400067c82ULL, 0x000fcc0008000000ULL, 0x0000000166307836ULL, 0x000fe20000000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x0000000430317c11ULL, 0x040fe4000f8ff8ffULL,
0x0000006600627202ULL, 0x000fe20000000f00ULL, 0x000000ffff667224ULL, 0x000fe200078e0030ULL,
0x0000000331397812ULL, 0x000fe400078ec0ffULL, 0x00000002ff31a819ULL, 0x000fe40000011631ULL,
0x000000023000780cULL, 0x040fe40003f06070ULL, 0x0000000130377812ULL, 0x000fe200078ec0ffULL,
0x0000000131387824ULL, 0x000fe200078e0244ULL, 0x000000ff39397207ULL, 0x000fc60005000000ULL,
0x0000000138067836ULL, 0x000fe40000000000ULL, 0x0000010038347824ULL, 0x000fc600078e0247ULL,
0x0000000c06007c0cULL, 0x000fe4000bf26070ULL, 0x0000004034657812ULL, 0x000fe400078ec0ffULL,
0x0000000136067812ULL, 0x000fc600078e0cffULL, 0x0000000100657824ULL, 0x000fe200078e0265ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000010006c9947ULL, 0x000fea0003800000ULL,
0x00000003ff3a7819ULL, 0x002fe20000011602ULL, 0x00000008373f7824ULL, 0x000fe200078e00ffULL,
0x00000007613b7c11ULL, 0x040fe4000f8e20ffULL, 0x00000009345d7c48ULL, 0x000fe2000ffe0000ULL,
0x000000043a3e7824ULL, 0x040fe200078e0245ULL, 0x00000007613d7c11ULL, 0x000fe2000f8e70ffULL,
0x000000013a337824ULL, 0x040fe200078e0265ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee202ULL,
0x000000015d5d7824ULL, 0x000fe200078e0a34ULL, 0x018600003e307984ULL, 0x000e620000000800ULL,
0x000000013a347824ULL, 0x000fc400078e0202ULL, 0x00002000063c7824ULL, 0x000fe200078e023dULL,
0x0000005d3a00720cULL, 0x000fe20003f26070ULL, 0x000000043a607836ULL, 0x000fe20000000000ULL,
0x0000000734357812ULL, 0x000fe200078ec0ffULL, 0x000020003c3c7836ULL, 0x000fe40000000000ULL,
0x0000000160647824ULL, 0x040fe200078e0202ULL, 0x0ffffff835357812ULL, 0x000fe200078ef802ULL,
0x0000000860697824ULL, 0x000fc800078e00ffULL, 0x0000001035677824ULL, 0x000fe400078e023cULL,
0x0000000160357824ULL, 0x000fe400078e0265ULL, 0x0000000430327824ULL, 0x002fe400078e023bULL,
0x00008a00ff307b82ULL, 0x000e680000000a00ULL, 0x018a800032327984ULL, 0x000ea40000000800ULL,
0x0000000832337c24ULL, 0x004fc8000f8e0233ULL, 0x0000010033327825ULL, 0x002fc800078e0030ULL,
0x000000103f327825ULL, 0x000fca00078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032677faeULL, 0x0003e2000c901c4aULL, 0x0000005d6000720cULL, 0x000fe20003f26070ULL,
0x000000083a607836ULL, 0x000fe40000000000ULL, 0x018610003e347984ULL, 0x000ea20000000800ULL,
0xfffffff869677812ULL, 0x002fe200078ee264ULL, 0x0000000160337824ULL, 0x040fe400078e0265ULL,
0x0000000160647824ULL, 0x000fe400078e0202ULL, 0x0000001067677824ULL, 0x000fc400078e023cULL,
0x0000000860697824ULL, 0x000fe400078e00ffULL, 0x00000004345e7824ULL, 0x004fca00078e023bULL,
0x018a80005e347984ULL, 0x000e640000000800ULL, 0x0000000834357c24ULL, 0x002fc8000f8e0235ULL,
0x0000010035347825ULL, 0x000fc800078e0030ULL, 0x000000103f347825ULL, 0x000fca00078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034677faeULL, 0x0003e2000c901c4aULL,
0x0000005d6000720cULL, 0x000fe20003f26070ULL, 0x0000000c3a607836ULL, 0x000fe40000000000ULL,
0x018620003e327984ULL, 0x000ea20000000800ULL, 0xfffffff869677812ULL, 0x002fe200078ee264ULL,
0x0000000160357824ULL, 0x040fe400078e0265ULL, 0x0000000160647824ULL, 0x000fe400078e0202ULL,
0x0000001067677824ULL, 0x000fc400078e023cULL, 0x0000000860697824ULL, 0x000fe400078e00ffULL,
0x00000004325e7824ULL, 0x004fca00078e023bULL, 0x018a80005e327984ULL, 0x000e640000000800ULL,
0x0000000832337c24ULL, 0x002fc8000f8e0233ULL, 0x0000010033327825ULL, 0x000fc800078e0030ULL,
0x000000103f327825ULL, 0x000fca00078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032677faeULL, 0x0003e2000c901c4aULL, 0x0000005d6000720cULL, 0x000fe40003f26070ULL,
0x000000103a607810ULL, 0x000fe20007ffe0ffULL, 0x018630003e347984ULL, 0x000ea20000000800ULL,
0xfffffff869677812ULL, 0x002fc600078ee264ULL, 0x0000000160337824ULL, 0x040fe400078e0265ULL,
0x0000000160647824ULL, 0x040fe400078e0202ULL, 0x0000001067677824ULL, 0x000fe400078e023cULL,
0x0000000860697824ULL, 0x000fe400078e00ffULL, 0x00000004345e7824ULL, 0x004fca00078e023bULL,
0x018a80005e347984ULL, 0x000e640000000800ULL, 0x0000000834357c24ULL, 0x002fc8000f8e0235ULL,
0x0000010035347825ULL, 0x000fc800078e0030ULL, 0x000000103f347825ULL, 0x000fca00078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034677faeULL, 0x0003e2000c901c4aULL,
0x0000005d6000720cULL, 0x000fe20003f26070ULL, 0x000000143a607836ULL, 0x000fe40000000000ULL,
0x018640003e327984ULL, 0x000ea20000000800ULL, 0xfffffff869677812ULL, 0x002fe200078ee264ULL,
0x0000000160357824ULL, 0x040fe400078e0265ULL, 0x0000000160647824ULL, 0x000fe400078e0202ULL,
0x0000001067677824ULL, 0x000fc400078e023cULL, 0x0000000860697824ULL, 0x000fe400078e00ffULL,
0x00000004325e7824ULL, 0x004fca00078e023bULL, 0x018a80005e327984ULL, 0x000e640000000800ULL,
0x0000000832337c24ULL, 0x002fc8000f8e0233ULL, 0x0000010033327825ULL, 0x000fc800078e0030ULL,
0x000000103f327825ULL, 0x000fca00078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032677faeULL, 0x0003e2000c901c4aULL, 0x0000005d6000720cULL, 0x000fe20003f26070ULL,
0x000000183a607836ULL, 0x000fe40000000000ULL, 0x018650003e347984ULL, 0x000ea20000000800ULL,
0xfffffff869677812ULL, 0x002fe200078ee264ULL, 0x0000000160337824ULL, 0x040fe400078e0265ULL,
0x0000000160647824ULL, 0x000fe400078e0202ULL, 0x0000001067677824ULL, 0x000fc400078e023cULL,
0x0000000860697824ULL, 0x000fe400078e00ffULL, 0x00000004345e7824ULL, 0x004fca00078e023bULL,
0x018a80005e347984ULL, 0x000e640000000800ULL, 0x0000000834357c24ULL, 0x002fc8000f8e0235ULL,
0x0000010035347825ULL, 0x000fc800078e0030ULL, 0x000000103f347825ULL, 0x000fca00078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034677faeULL, 0x0003e2000c901c4aULL,
0x0000005d6000720cULL, 0x000fe20003f26070ULL, 0x0000001c3a607836ULL, 0x000fe40000000000ULL,
0x018660003e327984ULL, 0x000ea20000000800ULL, 0xfffffff869677812ULL, 0x002fe200078ee264ULL,
0x0000000160357824ULL, 0x040fe400078e0265ULL, 0x0000000160647824ULL, 0x000fe400078e0202ULL,
0x0000001067677824ULL, 0x000fc400078e023cULL, 0x0000000860697824ULL, 0x000fe400078e00ffULL,
0x00000004325e7824ULL, 0x004fca00078e023bULL, 0x018a80005e327984ULL, 0x000e640000000800ULL,
0x0000000832337c24ULL, 0x002fc8000f8e0233ULL, 0x0000010033327825ULL, 0x000fc800078e0030ULL,
0x000000103f327825ULL, 0x000fca00078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032677faeULL, 0x0003e2000c901c4aULL, 0x0000005d6000720cULL, 0x000fe20003f26070ULL,
0x000000203a607836ULL, 0x000fe40000000000ULL, 0x018670003e347984ULL, 0x000ea20000000800ULL,
0xfffffff869677812ULL, 0x002fe200078ee264ULL, 0x0000000160337824ULL, 0x040fe400078e0265ULL,
0x0000000160647824ULL, 0x000fe400078e0202ULL, 0x0000001067677824ULL, 0x000fc400078e023cULL,
0x0000000860697824ULL, 0x000fe400078e00ffULL, 0x00000004345e7824ULL, 0x004fca00078e023bULL,
0x018a80005e347984ULL, 0x000e640000000800ULL, 0x0000000834357c24ULL, 0x002fc8000f8e0235ULL,
0x0000010035347825ULL, 0x000fc800078e0030ULL, 0x000000103f347825ULL, 0x000fca00078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034677faeULL, 0x0003e2000c901c4aULL,
0x0000005d6000720cULL, 0x000fe20003f26070ULL, 0x000000243a607836ULL, 0x000fe40000000000ULL,
0x018680003e327984ULL, 0x000ea20000000800ULL, 0xfffffff869677812ULL, 0x002fe200078ee264ULL,
0x0000000160647824ULL, 0x040fe200078e0202ULL, 0x0000006560357210ULL, 0x000fe20007ffe0ffULL,
0x0000000860697824ULL, 0x000fe400078e00ffULL, 0x0000001067677824ULL, 0x000fc400078e023cULL,
0x00000004325e7824ULL, 0x004fca00078e023bULL, 0x018a80005e327984ULL, 0x000e640000000800ULL,
0x0000000832337c24ULL, 0x002fc8000f8e0233ULL, 0x0000010033327825ULL, 0x000fc800078e0030ULL,
0x000000103f327825ULL, 0x000fca00078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032677faeULL, 0x0003e2000c901c4aULL, 0x0000005d6000720cULL, 0x000fe20003f26070ULL,
0x000000283a607836ULL, 0x000fe40000000000ULL, 0x018690003e347984ULL, 0x000ea20000000800ULL,
0xfffffff869677812ULL, 0x002fe200078ee264ULL, 0x0000000160337824ULL, 0x040fe400078e0265ULL,
0x0000000160647824ULL, 0x000fe400078e0202ULL, 0x0000001067677824ULL, 0x000fc400078e023cULL,
0x0000000860697824ULL, 0x000fe400078e00ffULL, 0x00000004345e7824ULL, 0x004fca00078e023bULL,
0x018a80005e347984ULL, 0x000e640000000800ULL, 0x0000000834357c24ULL, 0x002fc8000f8e0235ULL,
0x0000010035347825ULL, 0x000fc800078e0030ULL, 0x000000103f347825ULL, 0x000fca00078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034677faeULL, 0x0003e2000c901c4aULL,
0x0000005d6000720cULL, 0x000fe20003f26070ULL, 0x0000002c3a607836ULL, 0x000fe40000000000ULL,
0x0186a0003e327984ULL, 0x000ea20000000800ULL, 0xfffffff869677812ULL, 0x002fe200078ee264ULL,
0x0000000160357824ULL, 0x040fe400078e0265ULL, 0x0000000160647824ULL, 0x000fe400078e0202ULL,
0x0000001067677824ULL, 0x000fc400078e023cULL, 0x0000000860697824ULL, 0x000fe400078e00ffULL,
0x00000004325e7824ULL, 0x004fca00078e023bULL, 0x018a80005e327984ULL, 0x000e640000000800ULL,
0x0000000832337c24ULL, 0x002fc8000f8e0233ULL, 0x0000010033327825ULL, 0x000fc800078e0030ULL,
0x000000103f327825ULL, 0x000fca00078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032677faeULL, 0x0003e2000c901c4aULL, 0x0000005d6000720cULL, 0x000fe20003f26070ULL,
0x000000303a607836ULL, 0x000fe40000000000ULL, 0x0186b0003e347984ULL, 0x000ea20000000800ULL,
0xfffffff869677812ULL, 0x002fe200078ee264ULL, 0x0000000160337824ULL, 0x040fe400078e0265ULL,
0x0000000160647824ULL, 0x000fe400078e0202ULL, 0x0000001067677824ULL, 0x000fc400078e023cULL,
0x0000000860697824ULL, 0x000fe400078e00ffULL, 0x00000004345e7824ULL, 0x004fca00078e023bULL,
0x018a80005e347984ULL, 0x000e640000000800ULL, 0x0000000834357c24ULL, 0x002fc8000f8e0235ULL,
0x0000010035347825ULL, 0x000fc800078e0030ULL, 0x000000103f347825ULL, 0x000fca00078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034677faeULL, 0x0003e2000c901c4aULL,
0x0000005d6000720cULL, 0x000fe20003f26070ULL, 0x000000343a607836ULL, 0x000fe40000000000ULL,
0x0186c0003e327984ULL, 0x000ea20000000800ULL, 0xfffffff869677812ULL, 0x002fe200078ee264ULL,
0x0000000160357824ULL, 0x040fe400078e0265ULL, 0x0000000160647824ULL, 0x000fe400078e0202ULL,
0x0000001067677824ULL, 0x000fc400078e023cULL, 0x0000000860697824ULL, 0x000fe400078e00ffULL,
0x00000004325e7824ULL, 0x004fca00078e023bULL, 0x018a80005e327984ULL, 0x000e640000000800ULL,
0x0000000832337c24ULL, 0x002fc8000f8e0233ULL, 0x0000010033327825ULL, 0x000fc800078e0030ULL,
0x000000103f327825ULL, 0x000fca00078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032677faeULL, 0x0003e2000c901c4aULL, 0x0000005d6000720cULL, 0x000fe20003f26070ULL,
0x000000383a607836ULL, 0x000fe40000000000ULL, 0x0186d0003e347984ULL, 0x000ea20000000800ULL,
0x0000003c3a3a7836ULL, 0x000fe20000000000ULL, 0xfffffff869677812ULL, 0x002fe200078ee264ULL,
0x0000000160337824ULL, 0x040fe200078e0265ULL, 0x0000000260647210ULL, 0x000fe20007ffe0ffULL,
0x0000000860697824ULL, 0x000fe400078e00ffULL, 0x0000001067677824ULL, 0x000fc400078e023cULL,
0x000000013a657824ULL, 0x000fe400078e0265ULL, 0x00000004345e7824ULL, 0x004fca00078e023bULL,
0x018a80005e347984ULL, 0x000e640000000800ULL, 0x0000000834357c24ULL, 0x002fc8000f8e0235ULL,
0x0000010035347825ULL, 0x000fc800078e0030ULL, 0x000000103f347825ULL, 0x000fca00078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034677faeULL, 0x0003e2000c901c4aULL,
0x0000005d6000720cULL, 0x000fc60003f26070ULL, 0x0186e0003e327984ULL, 0x000ea20000000800ULL,
0xfffffff869357812ULL, 0x002fe200078ee264ULL, 0x000000083a677824ULL, 0x000fc800078e00ffULL,
0x0000001035357824ULL, 0x000fe400078e023cULL, 0x00000004325e7824ULL, 0x004fca00078e023bULL,
0x018a80005e327984ULL, 0x0002a40000000800ULL, 0x000000013a5e7824ULL, 0x002fe400078e0202ULL,
0x0000000832337c24ULL, 0x004fc8000f8e0233ULL, 0x0000010033327825ULL, 0x000fc800078e0030ULL,
0x000000103f327825ULL, 0x000fca00078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032357faeULL, 0x0003e2000c901c4aULL, 0x0000005d3a00720cULL, 0x000fc60003f26070ULL,
0x0186f0003e3e7984ULL, 0x000ea20000000800ULL, 0xfffffff867337812ULL, 0x002fca00078ee25eULL,
0x0000001033337824ULL, 0x000fe400078e023cULL, 0x000000043e347824ULL, 0x004fcc00078e023bULL,
0x018a800034347984ULL, 0x000e640000000800ULL, 0x0000000834657c24ULL, 0x002fc8000f8e0265ULL,
0x0000010065307825ULL, 0x000fc800078e0030ULL, 0x000000103f307825ULL, 0x000fca00078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030337faeULL, 0x0003e2000c901c4aULL,
0x0000001000207947ULL, 0x000fea0003800000ULL, 0x00000003ff3a7819ULL, 0x102fe20000011602ULL,
0x00000008373f7824ULL, 0x000fe200078e00ffULL, 0x00000007613b7c11ULL, 0x040fe4000f8e20ffULL,
0x00000007613d7c11ULL, 0x000fe2000f8e70ffULL, 0x000000043a3e7824ULL, 0x040fe200078e0245ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee202ULL, 0x000000013a337824ULL, 0x040fe400078e0265ULL,
0x000000013a347824ULL, 0x000fe200078e0202ULL, 0x018600003e307984ULL, 0x000e620000000800ULL,
0x00002000063c7824ULL, 0x000fc400078e023dULL, 0x000000043a5e7836ULL, 0x000fe20000000000ULL,
0x0000000734357812ULL, 0x000fe200078ec0ffULL, 0x000020003c3c7836ULL, 0x000fe40000000000ULL,
0x000000015e607824ULL, 0x040fe200078e0202ULL, 0x0ffffff835357812ULL, 0x000fe200078ef802ULL,
0x000000085e697824ULL, 0x000fc800078e00ffULL, 0x0000001035677824ULL, 0x100fe200078e023cULL,
0xfffffff869697812ULL, 0x000fe200078ee260ULL, 0x000000015e357824ULL, 0x000fe400078e0265ULL,
0x000000083a5e7836ULL, 0x000fe40000000000ULL, 0x0000001069697824ULL, 0x000fe400078e023cULL,
0x000000015e607824ULL, 0x000fe400078e0202ULL, 0x0000000430327824ULL, 0x002fc400078e023bULL,
0x00008a00ff307b82ULL, 0x000e680000000a00ULL, 0x018a800032327984ULL, 0x000ea40000000800ULL,
0x0000000832337c24ULL, 0x004fc8000f8e0233ULL, 0x0000010033327825ULL, 0x002fc800078e0030ULL,
0x000000103f327825ULL, 0x000fca00078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032677faeULL, 0x0003e8000b901c4aULL, 0x018610003e347984ULL, 0x000ea20000000800ULL,
0x000000015e337824ULL, 0x042fe400078e0265ULL, 0x000000085e677824ULL, 0x000fe400078e00ffULL,
0x0000000c3a5e7836ULL, 0x000fc60000000000ULL, 0xfffffff867677812ULL, 0x000fe200078ee260ULL,
0x000000015e607824ULL, 0x000fc800078e0202ULL, 0x0000001067677824ULL, 0x000fe400078e023cULL,
0x00000004345d7824ULL, 0x004fca00078e023bULL, 0x018a80005d347984ULL, 0x000e640000000800ULL,
0x0000000834357c24ULL, 0x002fc8000f8e0235ULL, 0x0000010035347825ULL, 0x000fc800078e0030ULL,
0x000000103f347825ULL, 0x000fca00078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034697faeULL, 0x0003e8000b901c4aULL, 0x018620003e327984ULL, 0x000ea20000000800ULL,
0x000000655e357210ULL, 0x002fe20007ffe0ffULL, 0x000000085e697824ULL, 0x000fe400078e00ffULL,
0x000000103a5e7836ULL, 0x000fc60000000000ULL, 0xfffffff869697812ULL, 0x000fe200078ee260ULL,
0x000000015e607824ULL, 0x000fc800078e0202ULL, 0x0000001069697824ULL, 0x000fe400078e023cULL,
0x00000004325d7824ULL, 0x004fca00078e023bULL, 0x018a80005d327984ULL, 0x000e640000000800ULL,
0x0000000832337c24ULL, 0x002fc8000f8e0233ULL, 0x0000010033327825ULL, 0x000fc800078e0030ULL,
0x000000103f327825ULL, 0x000fca00078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032677faeULL, 0x0003e8000b901c4aULL, 0x018630003e347984ULL, 0x000ea20000000800ULL,
0x000000015e337824ULL, 0x042fe400078e0265ULL, 0x000000085e677824ULL, 0x000fe400078e00ffULL,
0x000000143a5e7836ULL, 0x000fc60000000000ULL, 0xfffffff867677812ULL, 0x000fe200078ee260ULL,
0x000000015e607824ULL, 0x000fc800078e0202ULL, 0x0000001067677824ULL, 0x000fe400078e023cULL,
0x00000004345d7824ULL, 0x004fca00078e023bULL, 0x018a80005d347984ULL, 0x000e640000000800ULL,
0x0000000834357c24ULL, 0x002fc8000f8e0235ULL, 0x0000010035347825ULL, 0x000fc800078e0030ULL,
0x000000103f347825ULL, 0x000fca00078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034697faeULL, 0x0003e8000b901c4aULL, 0x018640003e327984ULL, 0x000ea20000000800ULL,
0x000000015e357824ULL, 0x042fe400078e0265ULL, 0x000000085e697824ULL, 0x000fe400078e00ffULL,
0x000000183a5e7836ULL, 0x000fc60000000000ULL, 0xfffffff869697812ULL, 0x000fe200078ee260ULL,
0x000000015e607824ULL, 0x000fc800078e0202ULL, 0x0000001069697824ULL, 0x000fe400078e023cULL,
0x00000004325d7824ULL, 0x004fca00078e023bULL, 0x018a80005d327984ULL, 0x000e640000000800ULL,
0x0000000832337c24ULL, 0x002fc8000f8e0233ULL, 0x0000010033327825ULL, 0x000fc800078e0030ULL,
0x000000103f327825ULL, 0x000fca00078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032677faeULL, 0x0003e8000b901c4aULL, 0x018650003e347984ULL, 0x000ea20000000800ULL,
0x000000015e337824ULL, 0x042fe400078e0265ULL, 0x000000085e677824ULL, 0x000fe400078e00ffULL,
0x0000001c3a5e7836ULL, 0x000fc60000000000ULL, 0xfffffff867677812ULL, 0x000fe200078ee260ULL,
0x000000015e607824ULL, 0x000fc800078e0202ULL, 0x0000001067677824ULL, 0x000fe400078e023cULL,
0x00000004345d7824ULL, 0x004fca00078e023bULL, 0x018a80005d347984ULL, 0x000e640000000800ULL,
0x0000000834357c24ULL, 0x002fc8000f8e0235ULL, 0x0000010035347825ULL, 0x000fc800078e0030ULL,
0x000000103f347825ULL, 0x000fca00078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034697faeULL, 0x0003e8000b901c4aULL, 0x018660003e327984ULL, 0x000ea20000000800ULL,
0x000000015e357824ULL, 0x042fe400078e0265ULL, 0x000000085e697824ULL, 0x000fe400078e00ffULL,
0x000000203a5e7836ULL, 0x000fc60000000000ULL, 0xfffffff869697812ULL, 0x000fe400078ee260ULL,
0x000000025e607210ULL, 0x000fc60007ffe0ffULL, 0x0000001069697824ULL, 0x000fe400078e023cULL,
0x00000004325d7824ULL, 0x004fca00078e023bULL, 0x018a80005d327984ULL, 0x000e640000000800ULL,
0x0000000832337c24ULL, 0x002fc8000f8e0233ULL, 0x0000010033327825ULL, 0x000fc800078e0030ULL,
0x000000103f327825ULL, 0x000fca00078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032677faeULL, 0x0003e8000b901c4aULL, 0x018670003e347984ULL, 0x000ea20000000800ULL,
0x000000015e337824ULL, 0x042fe400078e0265ULL, 0x000000085e677824ULL, 0x000fe400078e00ffULL,
0x000000243a5e7836ULL, 0x000fc60000000000ULL, 0xfffffff867677812ULL, 0x000fe200078ee260ULL,
0x000000015e607824ULL, 0x000fc800078e0202ULL, 0x0000001067677824ULL, 0x000fe400078e023cULL,
0x00000004345d7824ULL, 0x004fca00078e023bULL, 0x018a80005d347984ULL, 0x000e640000000800ULL,
0x0000000834357c24ULL, 0x002fc8000f8e0235ULL, 0x0000010035347825ULL, 0x000fc800078e0030ULL,
0x000000103f347825ULL, 0x000fca00078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034697faeULL, 0x0003e8000b901c4aULL, 0x018680003e327984ULL, 0x000ea20000000800ULL,
0x000000015e357824ULL, 0x042fe400078e0265ULL, 0x000000085e697824ULL, 0x000fe400078e00ffULL,
0x000000283a5e7836ULL, 0x000fc60000000000ULL, 0xfffffff869697812ULL, 0x000fe200078ee260ULL,
0x000000015e607824ULL, 0x000fc800078e0202ULL, 0x0000001069697824ULL, 0x000fe400078e023cULL,
0x00000004325d7824ULL, 0x004fca00078e023bULL, 0x018a80005d327984ULL, 0x000e640000000800ULL,
0x0000000832337c24ULL, 0x002fc8000f8e0233ULL, 0x0000010033327825ULL, 0x000fc800078e0030ULL,
0x000000103f327825ULL, 0x000fca00078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032677faeULL, 0x0003e8000b901c4aULL, 0x018690003e347984ULL, 0x000ea20000000800ULL,
0x000000015e337824ULL, 0x042fe400078e0265ULL, 0x000000085e677824ULL, 0x000fe400078e00ffULL,
0x0000002c3a5e7836ULL, 0x000fc60000000000ULL, 0xfffffff867677812ULL, 0x000fe200078ee260ULL,
0x000000015e607824ULL, 0x000fc800078e0202ULL, 0x0000001067677824ULL, 0x000fe400078e023cULL,
0x00000004345d7824ULL, 0x004fca00078e023bULL, 0x018a80005d347984ULL, 0x000e640000000800ULL,
0x0000000834357c24ULL, 0x002fc8000f8e0235ULL, 0x0000010035347825ULL, 0x000fc800078e0030ULL,
0x000000103f347825ULL, 0x000fca00078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034697faeULL, 0x0003e8000b901c4aULL, 0x0186a0003e327984ULL, 0x000ea20000000800ULL,
0x000000015e357824ULL, 0x042fe400078e0265ULL, 0x000000085e697824ULL, 0x000fe400078e00ffULL,
0x000000303a5e7836ULL, 0x000fc60000000000ULL, 0xfffffff869697812ULL, 0x000fe200078ee260ULL,
0x000000015e607824ULL, 0x000fc800078e0202ULL, 0x0000001069697824ULL, 0x000fe400078e023cULL,
0x00000004325d7824ULL, 0x004fca00078e023bULL, 0x018a80005d327984ULL, 0x000e640000000800ULL,
0x0000000832337c24ULL, 0x002fc8000f8e0233ULL, 0x0000010033327825ULL, 0x000fc800078e0030ULL,
0x000000103f327825ULL, 0x000fca00078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032677faeULL, 0x0003e8000b901c4aULL, 0x0186b0003e347984ULL, 0x000ea20000000800ULL,
0x000000015e337824ULL, 0x042fe400078e0265ULL, 0x000000085e677824ULL, 0x000fe400078e00ffULL,
0x000000343a5e7836ULL, 0x000fc60000000000ULL, 0xfffffff867677812ULL, 0x000fe200078ee260ULL,
0x000000015e607824ULL, 0x000fc800078e0202ULL, 0x0000001067677824ULL, 0x000fe400078e023cULL,
0x00000004345d7824ULL, 0x004fca00078e023bULL, 0x018a80005d347984ULL, 0x000e640000000800ULL,
0x0000000834357c24ULL, 0x002fc8000f8e0235ULL, 0x0000010035347825ULL, 0x000fc800078e0030ULL,
0x000000103f347825ULL, 0x000fca00078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034697faeULL, 0x0003e8000b901c4aULL, 0x0186c0003e327984ULL, 0x000ea20000000800ULL,
0x000000015e357824ULL, 0x042fe200078e0265ULL, 0x000000035e697819ULL, 0x000fe200000006ffULL,
0x000000383a5e7836ULL, 0x000fe40000000000ULL, 0x0000003c3a3a7836ULL, 0x000fe20000000000ULL,
0xfffffff869697812ULL, 0x000fe200078ee260ULL, 0x000000015e607824ULL, 0x000fc800078e0202ULL,
0x0000001069697824ULL, 0x000fe400078e023cULL, 0x00000004325d7824ULL, 0x004fca00078e023bULL,
0x018a80005d327984ULL, 0x000e640000000800ULL, 0x0000000832337c24ULL, 0x002fc8000f8e0233ULL,
0x0000010033327825ULL, 0x000fc800078e0030ULL, 0x000000103f327825ULL, 0x000fca00078e0032ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000032677faeULL, 0x0003e8000b901c4aULL,
0x0186d0003e347984ULL, 0x000ea20000000800ULL, 0x000000015e337824ULL, 0x042fe400078e0265ULL,
0x000000085e677824ULL, 0x000fca00078e00ffULL, 0xfffffff867677812ULL, 0x000fca00078ee260ULL,
0x0000001067677824ULL, 0x000fe400078e023cULL, 0x00000004345d7824ULL, 0x004fca00078e023bULL,
0x018a80005d347984ULL, 0x000e640000000800ULL, 0x0000000834357c24ULL, 0x002fc8000f8e0235ULL,
0x0000010035347825ULL, 0x000fc800078e0030ULL, 0x000000103f347825ULL, 0x000fca00078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034697faeULL, 0x0003e8000b901c4aULL,
0x0186e0003e327984ULL, 0x000ea20000000800ULL, 0x000000013a357824ULL, 0x002fe400078e0265ULL,
0x00000004325d7824ULL, 0x004fca00078e023bULL, 0x018a80005d327984ULL, 0x0002a40000000800ULL,
0x000000013a5d7824ULL, 0x042fe400078e0202ULL, 0x000000083a3a7824ULL, 0x000fca00078e00ffULL,
0xfffffff83a5d7812ULL, 0x000fca00078ee25dULL, 0x000000105d5d7824ULL, 0x000fe400078e023cULL,
0x0000000832337c24ULL, 0x004fc8000f8e0233ULL, 0x0000010033327825ULL, 0x000fc800078e0030ULL,
0x000000103f327825ULL, 0x000fca00078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032677faeULL, 0x0003e8000b901c4aULL, 0x0186f0003e3e7984ULL, 0x000ea40000000800ULL,
0x000000043e347824ULL, 0x004fcc00078e023bULL, 0x018a800034347984ULL, 0x000ea40000000800ULL,
0x0000000834357c24ULL, 0x004fc8000f8e0235ULL, 0x0000010035307825ULL, 0x000fc800078e0030ULL,
0x000000103f307825ULL, 0x000fca00078e0030ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000305d7faeULL, 0x0003e4000b901c4aULL, 0x000000ff3700720cULL, 0x000fe20003f25270ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000000000bc9947ULL, 0x000fea0003800000ULL,
0x00009200ff307b82ULL, 0x002e620000000a00ULL, 0x0000000139327836ULL, 0x000fe20000000000ULL,
0x000000033900780cULL, 0x000fe20003f85270ULL, 0x00000020023a7836ULL, 0x000fe20000000000ULL,
0x000000385f00720cULL, 0x0c0fe40003f64070ULL, 0x000000385f00720cULL, 0x000fe40003f24070ULL,
0x00000002ff337819ULL, 0x000fe40000011632ULL, 0x0000000332327812ULL, 0x000fc400078ec0ffULL,
0x0000000133337807ULL, 0x000fe40004800000ULL, 0x000000ff32357207ULL, 0x000fc60004800000ULL,
0x0000000138387824ULL, 0x000fe400078e0233ULL, 0x000000015c347824ULL, 0x000fe400078e0235ULL,
0x0000010038357824ULL, 0x000fe200078e0247ULL, 0x000000000044b947ULL, 0x000fec0002000000ULL,
0x000000030200780cULL, 0x000fe20003f24070ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000000243437836ULL, 0x000fd60000000000ULL, 0x0000000000301947ULL, 0x000fea0003800000ULL,
0x00008c00ff327b82ULL, 0x000ea20000000a00ULL, 0x0000000413377824ULL, 0x000fe200078e0202ULL,
0x0000000543007c0cULL, 0x000fe2000bf26070ULL, 0x00009000000f7ab9ULL, 0x000fe20000000800ULL,
0x00000004023b7824ULL, 0x000fe400078e023bULL, 0x0000000237387824ULL, 0x000fc800078e00ffULL,
0x0000000f38377c24ULL, 0x000fc8000f8e0243ULL, 0x0000000437327825ULL, 0x004fca00078e0032ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18a80000323b7faeULL, 0x0005e4000c92184aULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000135327824ULL, 0x104fe200078e0202ULL,
0x00009400000f7ab9ULL, 0x000fe20000000800ULL, 0x000000013a337824ULL, 0x100fe400078e0235ULL,
0x0000000f34357c24ULL, 0x000fe2000f8e0235ULL, 0x0000000932007c0cULL, 0x000fe2000bf26070ULL,
0x0000000402377824ULL, 0x000fe200078e0245ULL, 0x0000000933007c0cULL, 0x000fe2000bf66070ULL,
0x0000000135337824ULL, 0x000fe400078e0202ULL, 0x000000013a357824ULL, 0x000fc400078e0235ULL,
0x0000000433327825ULL, 0x002fc800078e0030ULL, 0x0000000435307825ULL, 0x000fe400078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1860000032377faeULL, 0x0003e8000c92184aULL,
0x1868000030377faeULL, 0x0003e4000d92184aULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002002317836ULL, 0x002fe20000000000ULL, 0xfffffff802657812ULL, 0x000fe200078ec0ffULL,
0x0000200036607824ULL, 0x000fe200078e023dULL, 0x00000007025d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff677224ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe400078ec0ffULL,
0x0000200060607810ULL, 0x000fe40007ffe0ffULL, 0x0000000765657812ULL, 0x000fc400078ef802ULL,
0x000000085d5e7812ULL, 0x000fe400078ef802ULL, 0x0000000731647812ULL, 0x000fce00078ef802ULL,
0x0000000165307824ULL, 0x140fe400078e0267ULL, 0x0000000865317824ULL, 0x000fe400078e00ffULL,
0x0000000862697824ULL, 0x100fe400078e0267ULL, 0x0000000864337824ULL, 0x040fe200078e00ffULL,
0xfffffff831317812ULL, 0x000fe200078ee230ULL, 0x0000000164307824ULL, 0x000fe400078e0267ULL,
0x0000000269697824ULL, 0x000fc400078e00ffULL, 0x0000001031317824ULL, 0x000fe200078e0260ULL,
0xfffffff833337812ULL, 0x000fe200078ee230ULL, 0x000000205e327824ULL, 0x000fc600078e00ffULL,
0x000000003134783bULL, 0x000e620000000200ULL, 0x0000001033337824ULL, 0x000fca00078e0260ULL,
0x00000000333c783bULL, 0x000ea20000000200ULL, 0x0001000035317824ULL, 0x002fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011434ULL, 0x0001000034307824ULL, 0x040fe200078e00ffULL,
0x00008880346e7816ULL, 0x040fe200000000ffULL, 0x0000010034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe40000011431ULL, 0x0000006902317211ULL, 0x000fe200078fe0ffULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000000269697836ULL, 0x000fe20000000000ULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x000000015e317824ULL, 0x000fe200078e0231ULL, 0x00000018ff727819ULL, 0x000fc40000011435ULL,
0x00008880356d7816ULL, 0x040fe200000000ffULL, 0x00000030006f7306ULL, 0x0003e20000202400ULL,
0xffffffe032317812ULL, 0x000fe200078ee231ULL, 0x0000010035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011436ULL, 0x0000000731317c11ULL, 0x000fe4000f8e20ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000006e006e7306ULL, 0x000ee20000202400ULL,
0x0001000036307824ULL, 0x042fe200078e00ffULL, 0x00008880363a7816ULL, 0x040fe200000000ffULL,
0x0000010036367824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fc40000011437ULL,
0x00000018ff3b7819ULL, 0x000fe40000011430ULL, 0x000000003130783bULL, 0x000e620000000200ULL,
0x0000003400777306ULL, 0x0009620000202400ULL, 0x0000888037737816ULL, 0x040fe400000000ffULL,
0x00000018ff397819ULL, 0x000fe40000011436ULL, 0x00000018ff6b7819ULL, 0x004fe4000001143cULL,
0x00000018ff6a7819ULL, 0x000fe2000001143dULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x0001000037347824ULL, 0x050fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001143eULL,
0x0000010037377824ULL, 0x000fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fc4000001143fULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000006d006d7306ULL, 0x000fe20000202400ULL,
0x00000018ff367819ULL, 0x000fe20000011437ULL, 0x000100003c377824ULL, 0x000fe200078e00ffULL,
0x0000006902697211ULL, 0x000fc800078fe0ffULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000007600767306ULL, 0x000ea20000202400ULL, 0x000000015e697824ULL, 0x000fce00078e0269ULL,
0x0000003500757306ULL, 0x0008700000202400ULL, 0x0000003400747306ULL, 0x0007e20000202400ULL,
0x000088803c357816ULL, 0x050fe200000000ffULL, 0x000001003c3c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000003a003a7306ULL, 0x000fe20000202400ULL,
0x000054106e347816ULL, 0x008fce000000006fULL, 0x00000035006e7306ULL, 0x000bf00000202400ULL,
0x0000003b003b7306ULL, 0x000ee20000202400ULL, 0x0000541077357816ULL, 0x020fe40000000070ULL,
0x000088803d777816ULL, 0x000fca00000000ffULL, 0x000000343020723cULL, 0x002fe20000041820ULL,
0x00000037006f7306ULL, 0x0003ec0000202400ULL, 0x000054106d347816ULL, 0x004fe20000000076ULL,
0x000100003d767824ULL, 0x000fe200078e00ffULL, 0x0000541075357816ULL, 0x000fe20000000072ULL,
0x0000000167377836ULL, 0x002fe20000000000ULL, 0x0000003800387306ULL, 0x000fe20000202400ULL,
0x000001003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011476ULL,
0x0000000267677836ULL, 0x000fe20000000000ULL, 0x000088803e727816ULL, 0x000fe200000000ffULL,
0x00000034301c723cULL, 0x000fe2000004181cULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x0000003900397306ULL, 0x000e620000202400ULL, 0x000000086700780cULL, 0x000fc60003f25270ULL,
0x0000000865357824ULL, 0x040fe400078e00ffULL, 0x0000000165347824ULL, 0x100fe400078e0237ULL,
0x0000007300737306ULL, 0x000ea20000202400ULL, 0x0000000164377824ULL, 0x000fe400078e0237ULL,
0xfffffff835357812ULL, 0x000fe400078ee234ULL, 0x000054103a347816ULL, 0x008fc6000000003bULL,
0x00000010353a7824ULL, 0x000fe200078e0260ULL, 0x0000541039357816ULL, 0x002fe20000000038ULL,
0x0000003c00707306ULL, 0x0003e80000202400ULL, 0x000000003a38783bULL, 0x000ee40000000200ULL,
0x000000343024723cULL, 0x000fe40000041824ULL, 0x0000006b006b7306ULL, 0x000f220000202400ULL,
0x00000008643c7824ULL, 0x002fc800078e00ffULL, 0x000100003e357824ULL, 0x040fe200078e00ffULL,
0xfffffff83c377812ULL, 0x000fe200078ee237ULL, 0x000100003f3c7824ULL, 0x000fe200078e00ffULL,
0x0000006a006a7306ULL, 0x000fe20000202400ULL, 0x000001003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe40000011435ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000077006d7306ULL, 0x000fe20000202400ULL,
0x0000541073347816ULL, 0x004fc40000000074ULL, 0x0000006037377211ULL, 0x000fca00078e20ffULL,
0x0000007600767306ULL, 0x000ff00000202400ULL, 0x0000003d00797306ULL, 0x0009f00000202400ULL,
0x0000007100717306ULL, 0x000fe20000202400ULL, 0x00005410703d7816ULL, 0x010fc4000000006bULL,
0x00000018ff707819ULL, 0x008fca0000011438ULL, 0x0000003600367306ULL, 0x000e700000202400ULL,
0x0000003c00747306ULL, 0x0005e20000202400ULL, 0x0000541036357816ULL, 0x002fce0000000071ULL,
0x0000006c006c7306ULL, 0x000fe20000202400ULL, 0x000054106e3c7816ULL, 0x004fe4000000006fULL,
0x000088803f717816ULL, 0x040fe200000000ffULL, 0x000001003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe20000011439ULL, 0x000000343028723cULL, 0x000fe20000041828ULL,
0x00000018ff6e7819ULL, 0x000fe2000001143aULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000000003734783bULL, 0x000e640000000200ULL,
0x0000003c3018723cULL, 0x000fe80000041818ULL, 0x0000007500757306ULL, 0x000ea60000202400ULL,
0x000054106d3c7816ULL, 0x000fc40000000076ULL, 0x00005410793d7816ULL, 0x000fe4000000006aULL,
0x00000018ff6d7819ULL, 0x000fe2000001143bULL, 0x0000003e00737306ULL, 0x000ee80000202400ULL,
0x0000003c3014723cULL, 0x000fe80000041814ULL, 0x0000006800687306ULL, 0x000fe60000202400ULL,
0x00005410723c7816ULL, 0x004fc40000000075ULL, 0x00005410733d7816ULL, 0x008fc6000000006cULL,
0x0000007100717306ULL, 0x000fe20000202400ULL, 0x00008880386c7816ULL, 0x000fe400000000ffULL,
0x000088803a737816ULL, 0x000fe200000000ffULL, 0x0000003c300c723cULL, 0x000fe8000004180cULL,
0x0000003f00777306ULL, 0x000ea20000202400ULL, 0x00000018ff6b7819ULL, 0x002fe40000011434ULL,
0x00000018ff6a7819ULL, 0x000fe20000011435ULL, 0x00010000383d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe20000011437ULL, 0x0000010038387824ULL, 0x000fc400078e00ffULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x000000ffff3c7224ULL, 0x000fe200078e006cULL,
0x00000018ff7b7819ULL, 0x000fe2000001143dULL, 0x00010000396c7824ULL, 0x040fe200078e00ffULL,
0x00008880393d7816ULL, 0x040fe200000000ffULL, 0x0000010039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x00000018ff767819ULL, 0x000fc40000011439ULL,
0x0000541077397816ULL, 0x004fe40000000068ULL, 0x0000888035687816ULL, 0x000fe200000000ffULL,
0x0000003800797306ULL, 0x0002a20000202400ULL, 0x00000018ff3f7819ULL, 0x000fce0000011436ULL,
0x0000007b007b7306ULL, 0x000ee20000202400ULL, 0x0000541071387816ULL, 0x002fe40000000074ULL,
0x000088803b717816ULL, 0x000fca00000000ffULL, 0x00000038302c723cULL, 0x000fe2000004182cULL,
0x0000003d003d7306ULL, 0x000fec0000202400ULL, 0x000100003a307824ULL, 0x000fe200078e00ffULL,
0x0000541079397816ULL, 0x004fe20000000070ULL, 0x000000205e327824ULL, 0x000fe200078e00ffULL,
0x0000006c006c7306ULL, 0x000e620000202400ULL, 0x000100003b317824ULL, 0x040fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0001000034387824ULL, 0x000fe200078e00ffULL,
0xffffffe032697812ULL, 0x000fe200078ee269ULL, 0x000001003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fe20000011431ULL, 0x000001003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000003000787306ULL, 0x0005e20000202400ULL, 0x00000018ff387819ULL, 0x000fc40000011438ULL,
0x00000018ff727819ULL, 0x000fe4000001143bULL, 0x00000018ff3a7819ULL, 0x000fc6000001143aULL,
0x00000038003b7306ULL, 0x0007e20000202400ULL, 0x0000000769307c11ULL, 0x004fcc000f8e20ffULL,
0x000000003030783bULL, 0x000ea20000000200ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x000054103c387816ULL, 0x008fce000000007bULL, 0x0000007600767306ULL, 0x000ef00000202400ULL,
0x0000003a00757306ULL, 0x0009f00000202400ULL, 0x0000006e006e7306ULL, 0x000f620000202400ULL,
0x00008880343a7816ULL, 0x050fe200000000ffULL, 0x0000010034347824ULL, 0x000fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000007300737306ULL, 0x000f220000202400ULL,
0x000000383020723cULL, 0x004fee0000041820ULL, 0x00000034003c7306ULL, 0x0003e20000202400ULL,
0x0001000035397824ULL, 0x040fe200078e00ffULL, 0x0000888036387816ULL, 0x040fe200000000ffULL,
0x0000010035357824ULL, 0x000fe200078e00ffULL, 0x000054103d347816ULL, 0x002fe2000000006cULL,
0x00010000366c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000010036367824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000006d006d7306ULL, 0x000ff00000202400ULL, 0x00000035003d7306ULL, 0x0007f00000202400ULL,
0x0000007100717306ULL, 0x000fe20000202400ULL, 0x0000541076357816ULL, 0x008fc4000000006fULL,
0x00000018ff6f7819ULL, 0x000fe4000001146cULL, 0x00000018ff6c7819ULL, 0x000fe40000011436ULL,
0x0000888037367816ULL, 0x040fe200000000ffULL, 0x00000034301c723cULL, 0x000fe2000004181cULL,
0x0000007400747306ULL, 0x000e6c0000202400ULL, 0x0001000037347824ULL, 0x000fc400078e00ffULL,
0x0000007200727306ULL, 0x000ea20000202400ULL, 0x0000010037357824ULL, 0x000fe400078e00ffULL,
0x00000018ff347819ULL, 0x000fca0000011434ULL, 0x0000003900697306ULL, 0x000ff00000202400ULL,
0x0000006f00397306ULL, 0x0007f00000202400ULL, 0x0000003400377306ULL, 0x0009e20000202400ULL,
0x00000018ff6f7819ULL, 0x008fc40000011435ULL, 0x0000541075357816ULL, 0x020fca000000006eULL,
0x0000006b006b7306ULL, 0x000fe20000202400ULL, 0x0000541073347816ULL, 0x010fce0000000078ULL,
0x0000003a003a7306ULL, 0x000ee20000202400ULL, 0x000000343024723cULL, 0x000fee0000041824ULL,
0x0000541071347816ULL, 0x002fe20000000074ULL, 0x0000006a006a7306ULL, 0x000fe20000202400ULL,
0x0000541072357816ULL, 0x004fce000000006dULL, 0x0000006800687306ULL, 0x000e620000202400ULL,
0x000000343028723cULL, 0x000fee0000041828ULL, 0x000054103a347816ULL, 0x008fe2000000003bULL,
0x0000003f003f7306ULL, 0x000fe20000202400ULL, 0x000054103c357816ULL, 0x000fce000000006bULL,
0x0000003800387306ULL, 0x000ea20000202400ULL, 0x000000343018723cULL, 0x000fee0000041818ULL,
0x0000006c006c7306ULL, 0x000ee20000202400ULL, 0x0000541068347816ULL, 0x002fe40000000069ULL,
0x000054103d357816ULL, 0x000fca000000006aULL, 0x0000003e003e7306ULL, 0x000fe40000202400ULL,
0x000000343014723cULL, 0x000fec0000041814ULL, 0x0000003600367306ULL, 0x000e620000202400ULL,
0x0000541038347816ULL, 0x004fe40000000039ULL, 0x000054106c357816ULL, 0x008fca000000003fULL,
0x0000006f006f7306ULL, 0x000ea40000202400ULL, 0x00000034300c723cULL, 0x000fee000004180cULL,
0x0000541036347816ULL, 0x002fe40000000037ULL, 0x000054106f357816ULL, 0x004fce000000003eULL,
0x00000034302c723cULL, 0x000fe2000004182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xfffffff0001c1947ULL, 0x000fde000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0006ULL,
0xffffffc800488947ULL, 0x000fec000383ffffULL, 0x00000002ff307819ULL, 0x000fc80000011602ULL,
0x0000000430007c0cULL, 0x000fe2000bf06070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x0000000430007c0cULL, 0x000fe2000c706470ULL, 0x0000000830307836ULL, 0x000fc60000000000ULL,
0x000000445f00720cULL, 0x000fe40000703070ULL, 0x0000000630007c0cULL, 0x000fc8000bf26070ULL,
0x0000000430007c0cULL, 0x000fc80008f21070ULL, 0x000000445f00720cULL, 0x000fc60000f24470ULL,
0x000000ffff578224ULL, 0x000fe200078e002dULL, 0x0000001400508202ULL, 0x000fe20000000f00ULL,
0x000000ffff548224ULL, 0x000fe200078e002cULL, 0x000000582f587208ULL, 0x000fe20000800000ULL,
0x000000ffff558224ULL, 0x000fe200078e000dULL, 0x0000005b2e5b7208ULL, 0x000fe20000800000ULL,
0x000000ffff528224ULL, 0x000fe200078e000cULL, 0x000000560f567208ULL, 0x000fe20000800000ULL,
0x000000ffff538224ULL, 0x000fe200078e0015ULL, 0x000000590e597208ULL, 0x000fe20000800000ULL,
0x000000ffff518224ULL, 0x000fe200078e0019ULL, 0x0000000817087208ULL, 0x000fe20000800000ULL,
0x000000ffff4e8224ULL, 0x000fe200078e0018ULL, 0x0000000716077208ULL, 0x000fe20000800000ULL,
0x000000ffff4f8224ULL, 0x000fe200078e0029ULL, 0x0000000a1b0a7208ULL, 0x000fe20000800000ULL,
0x000000ffff4c8224ULL, 0x000fe200078e0028ULL, 0x000000091a097208ULL, 0x000fe20000800000ULL,
0x000000ffff4d8224ULL, 0x000fe200078e0025ULL, 0x000000102b107208ULL, 0x000fe20000800000ULL,
0x000000ffff4a8224ULL, 0x000fe200078e0024ULL, 0x0000000b2a0b7208ULL, 0x000fe20000800000ULL,
0x000000ffff4b8224ULL, 0x000fe200078e001dULL, 0x0000001227127208ULL, 0x000fe20000800000ULL,
0x000000ffff488224ULL, 0x000fe200078e001cULL, 0x0000001126117208ULL, 0x000fe20000800000ULL,
0x000000ffff498224ULL, 0x000fe200078e0021ULL, 0x000000401f407208ULL, 0x000fe20000800000ULL,
0x000000ffff468224ULL, 0x000fe200078e0020ULL, 0x0000000463007c0cULL, 0x000fc4000bf03070ULL,
0x000000411e417208ULL, 0x000fe40000800000ULL, 0x0000004223427208ULL, 0x000fe40000800000ULL,
0x0000000522057208ULL, 0x000fce0000800000ULL, 0xffffffc400508947ULL, 0x000fea000383ffffULL,
0x00000001ff0e7424ULL, 0x000fe400078e00ffULL, 0x0000000e460d7c20ULL, 0x000fe20008410000ULL,
0x0000000e49497c20ULL, 0x000fe20008410000ULL, 0x0000000e48487c20ULL, 0x000fe20008410000ULL,
0x0000000e4b4b7c20ULL, 0x000fe20008410000ULL, 0x0000000e4a4a7c20ULL, 0x000fe20008410000ULL,
0x018b580e030e79a7ULL, 0x000e62000850003fULL, 0x0000000e4d4d7c20ULL, 0x000fe20008410000ULL,
0x0000000e4c4c7c20ULL, 0x000fe20008410000ULL, 0x0000000e4f4f7c20ULL, 0x000fe20008410000ULL,
0x0000000e4e4e7c20ULL, 0x000fe20008410000ULL, 0x0000000e51517c20ULL, 0x000fe20008410000ULL,
0x0000000e50507c20ULL, 0x000fe20008410000ULL, 0x0000000e53537c20ULL, 0x000fe20008410000ULL,
0x0000000e52527c20ULL, 0x000fe20008410000ULL, 0x0000000e55557c20ULL, 0x000fe20008410000ULL,
0x0000000e54547c20ULL, 0x000fe20008410000ULL, 0x0000000e57577c20ULL, 0x000fe20008410000ULL,
0x0000000e050c7c20ULL, 0x000fe20008410000ULL, 0x0000000e42427c20ULL, 0x000fe20008410000ULL,
0x0000000e41417c20ULL, 0x000fe20008410000ULL, 0x0000000e40407c20ULL, 0x000fe20008410000ULL,
0x0000000e11117c20ULL, 0x000fe20008410000ULL, 0x0000000e12127c20ULL, 0x000fe20008410000ULL,
0x0000000e0b0b7c20ULL, 0x000fe20008410000ULL, 0x0000000e10107c20ULL, 0x000fe20008410000ULL,
0x0000000e09097c20ULL, 0x000fe20008410000ULL, 0x0000000e0a0a7c20ULL, 0x000fe20008410000ULL,
0x0000000e07077c20ULL, 0x000fe20008410000ULL, 0x0000000e08087c20ULL, 0x000fe20008410000ULL,
0x000000ffff167224ULL, 0x002fc400078e000fULL, 0x0000000e59597c20ULL, 0x000fe20008410000ULL,
0x0000000e56567c20ULL, 0x000fe20008410000ULL, 0x0000000e5b5b7c20ULL, 0x000fe20008410000ULL,
0x0000000e58587c20ULL, 0x000fe20008410000ULL, 0x00000000000e7805ULL, 0x000fe20000015200ULL,
0x018b5816030075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff177224ULL, 0x000fce00078e00ffULL, 0x000000101700780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x000000140e147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e0fULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc80000011415ULL, 0x0000001405057211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x0000000205057819ULL, 0x000fc80000001214ULL,
0x000000050000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000117177836ULL, 0x000fce0000000000ULL, 0x018b5816030075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000402057824ULL, 0x000fe200078e00ffULL,
0x0000000761307c11ULL, 0x000fe4000f8e38ffULL, 0x0000000d44007c0cULL, 0x000fe4000bf05270ULL,
0xfffffff005057812ULL, 0x000fca00078ec0ffULL, 0x0000000130307824ULL, 0x000fca00078e0205ULL,
0x01840000301c7984ULL, 0x0002a20000000c00ULL, 0x0000000400080947ULL, 0x000fea0003800000ULL,
0x0000000202057824ULL, 0x000fe200078e00ffULL, 0x000000095a5a7c10ULL, 0x000fc8000fffe1ffULL,
0x0000000605057812ULL, 0x000fc800078ec0ffULL, 0x00000001050f7812ULL, 0x040fe400078efcffULL,
0x0000000805157812ULL, 0x000fe400078efcffULL, 0x0000005a0f00720cULL, 0x080fe40003f26070ULL,
0x00000010050f7812ULL, 0x000fe400078efcffULL, 0x0000005a1500720cULL, 0x080fe40003f06070ULL,
0x0000005a0f00720cULL, 0x000fc40003fc6070ULL, 0x0000001105157812ULL, 0x040fe400078efcffULL,
0x00000018050f7812ULL, 0x040fe400078efcffULL, 0x0000005a0500720cULL, 0x080fe40003f46070ULL,
0x0000005a1500720cULL, 0x080fe40003fa6070ULL, 0x0000005a0f00720cULL, 0x000fe40003f66070ULL,
0x0000000905177812ULL, 0x000fc400078efcffULL, 0x0000001905157812ULL, 0x040fe400078efcffULL,
0x00000020050f7812ULL, 0x000fe400078efcffULL, 0xff8000000c0c7808ULL, 0x000fe40005000000ULL,
0xff8000000d0d7808ULL, 0x000fe40005000000ULL, 0xff80000042427808ULL, 0x000fe40004800000ULL,
0xff80000049497808ULL, 0x000fc40004800000ULL, 0x0000005a1700720cULL, 0x080fe40003f86070ULL,
0x0000005a1500720cULL, 0x080fe40003f46070ULL, 0x0000005a0f00720cULL, 0x000fe40003f26070ULL,
0x0000002105157812ULL, 0x040fe400078efcffULL, 0x00000028050f7812ULL, 0x000fe400078efcffULL,
0xff80000041417808ULL, 0x000fc40004000000ULL, 0xff80000048487808ULL, 0x000fe40004000000ULL,
0xff80000040407808ULL, 0x000fe40006000000ULL, 0xff8000004b4b7808ULL, 0x000fe40006000000ULL,
0x0000005a1500720cULL, 0x080fe40003f06070ULL, 0x0000005a0f00720cULL, 0x000fe40003f86070ULL,
0x0000002905157812ULL, 0x000fc400078efcffULL, 0x00000030050f7812ULL, 0x000fe400078efcffULL,
0xff80000011117808ULL, 0x000fe40007000000ULL, 0xff8000004a4a7808ULL, 0x000fe40007000000ULL,
0xff80000012127808ULL, 0x000fe40006800000ULL, 0xff8000004d4d7808ULL, 0x000fe40006800000ULL,
0x0000005a1500720cULL, 0x000fc40003fc6070ULL, 0x0000005a0f00720cULL, 0x000fe40003fa6070ULL,
0x0000003105157812ULL, 0x040fe400078efcffULL, 0x00000038050f7812ULL, 0x040fe400078efcffULL,
0x0000003905057812ULL, 0x000fe400078efcffULL, 0xff8000000b0b7808ULL, 0x000fe40005800000ULL,
0xff8000004c4c7808ULL, 0x000fc40005800000ULL, 0xff80000010107808ULL, 0x000fe40005000000ULL,
0xff8000004f4f7808ULL, 0x000fe40005000000ULL, 0xff80000009097808ULL, 0x000fe40004800000ULL,
0xff8000004e4e7808ULL, 0x000fe40004800000ULL, 0x0000005a1500720cULL, 0x080fe40003f66070ULL,
0x0000005a0f00720cULL, 0x000fc40003f46070ULL, 0x0000005a0500720cULL, 0x000fe40003f26070ULL,
0xff8000000a0a7808ULL, 0x000fe40004000000ULL, 0xff80000051517808ULL, 0x000fe40004000000ULL,
0xff80000007077808ULL, 0x000fe40006000000ULL, 0xff80000050507808ULL, 0x000fe40006000000ULL,
0xff80000008087808ULL, 0x000fc40007000000ULL, 0xff80000053537808ULL, 0x000fe40007000000ULL,
0xff80000059597808ULL, 0x000fe40006800000ULL, 0xff80000052527808ULL, 0x000fe40006800000ULL,
0xff80000056567808ULL, 0x000fe40005800000ULL, 0xff80000055557808ULL, 0x000fe40005800000ULL,
0xff8000005b5b7808ULL, 0x000fc40005000000ULL, 0xff80000054547808ULL, 0x000fe40005000000ULL,
0xff80000058587808ULL, 0x000fe40004800000ULL, 0xff80000057577808ULL, 0x000fce0004800000ULL,
0x0000000d1c00720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0c401f001e257f89ULL, 0x000fe200000e0000ULL, 0x00000007612a7c11ULL, 0x000fe2000f8e58ffULL,
0x0000000144447836ULL, 0x000fe20000000000ULL, 0x0000001c0d1c7208ULL, 0x000fe20004000000ULL,
0x0c401f001f247f89ULL, 0x000fe400000e0000ULL, 0x000120002a357836ULL, 0x000fe20000000000ULL,
0x000000491c00720bULL, 0x000fc80003f1e000ULL, 0x0000001c49057208ULL, 0x000fe20004000000ULL,
0x00000004ff1c7e24ULL, 0x000fc6000f8e00ffULL, 0x000000480500720bULL, 0x000fe40003f1e000ULL,
0x3f8000001c1c783eULL, 0x000fe400000010ffULL, 0x00000005480e7208ULL, 0x000fc80004000000ULL,
0x0000004b0e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e4b057208ULL, 0x000fc80004000000ULL,
0x0000004a0500720bULL, 0x000fc80003f1e000ULL, 0x000000054a0e7208ULL, 0x000fc80004000000ULL,
0x0000004d0e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e4d057208ULL, 0x000fc80004000000ULL,
0x0000004c0500720bULL, 0x000fc80003f1e000ULL, 0x000000054c0e7208ULL, 0x000fc80004000000ULL,
0x0000004f0e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e4f057208ULL, 0x000fc80004000000ULL,
0x0000004e0500720bULL, 0x000fc80003f1e000ULL, 0x000000054e0e7208ULL, 0x000fc80004000000ULL,
0x000000510e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e51057208ULL, 0x000fc80004000000ULL,
0x000000500500720bULL, 0x000fc80003f1e000ULL, 0x00000005500e7208ULL, 0x000fe40004000000ULL,
0x0000000c1d00720bULL, 0x000fe40003f1e000ULL, 0x000000530e00720bULL, 0x000fe40003f3e000ULL,
0x0000001d0c1d7208ULL, 0x000fe40004000000ULL, 0x0000000e53057208ULL, 0x000fe40004800000ULL,
0x000000421d00720bULL, 0x000fc40003f1e000ULL, 0x000000520500720bULL, 0x000fe40003f3e000ULL,
0x0000001d420e7208ULL, 0x000fe20004000000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e001cULL,
0x0000000552147208ULL, 0x000fe40004800000ULL, 0x000000410e00720bULL, 0x000fe40003f1e000ULL,
0x000000551400720bULL, 0x000fe40003f3e000ULL, 0x0000000e41057208ULL, 0x000fc40004000000ULL,
0x00000014550f7208ULL, 0x000fe40004800000ULL, 0x000000400500720bULL, 0x000fe40003f1e000ULL,
0x000000540f00720bULL, 0x000fe40003f3e000ULL, 0x00000005400e7208ULL, 0x000fe40004000000ULL,
0x0000000f54147208ULL, 0x000fe40004800000ULL, 0x000000110e00720bULL, 0x000fc40003f1e000ULL,
0x000000571400720bULL, 0x000fe40003f3e000ULL, 0x0000000e11057208ULL, 0x000fe40004000000ULL,
0x0000001457147208ULL, 0x000fe40004800000ULL, 0x000000120500720bULL, 0x000fc60003f1e000ULL,
0x0c401f00140f7f89ULL, 0x000ea200000e0000ULL, 0x00000005120e7208ULL, 0x000fc80004000000ULL,
0x0000000b0e00720bULL, 0x000fc80003f1e000ULL, 0x0000000e0b057208ULL, 0x000fc80004000000ULL,
0x000000100500720bULL, 0x000fc80003f1e000ULL, 0x00000005100e7208ULL, 0x000fc80004000000ULL,
0x000000090e00720bULL, 0x000fe40003f1e000ULL, 0x0000000f1400720bULL, 0x004fe40003f3e000ULL,
0x0000000e09057208ULL, 0x000fe40004000000ULL, 0x000000140f0f7208ULL, 0x000fe40004800000ULL,
0x0000000a0500720bULL, 0x000fc60003f1e000ULL, 0x0c201f000f2c7f89ULL, 0x000ea200000e0000ULL,
0x000000050a0e7208ULL, 0x000fc80004000000ULL, 0x000000070e00720bULL, 0x000fc80003f1e000ULL,
0x0000000e07057208ULL, 0x000fc80004000000ULL, 0x000000080500720bULL, 0x000fc80003f1e000ULL,
0x00000005080e7208ULL, 0x000fc80004000000ULL, 0x000000590e00720bULL, 0x000fe40003f1e000ULL,
0x0000002c0f00720bULL, 0x004fe40003f3e000ULL, 0x0000000e59057208ULL, 0x000fe40004000000ULL,
0x0000000f2c2c7208ULL, 0x000fe40004800000ULL, 0x000000560500720bULL, 0x000fe40003f1e000ULL,
0x000000241f00720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b2c147820ULL, 0x000fe20000410000ULL,
0x00000005560e7208ULL, 0x000fc40004000000ULL, 0x0000001f242f7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010814ULL, 0x0000005b0e00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b48487823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010814ULL, 0x0000000e5b057208ULL, 0x000fe20004000000ULL,
0x0000004900497308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010814ULL, 0x000000580500720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010814ULL, 0x0000000558057208ULL, 0x000fe20004000000ULL,
0x0000000d00467308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b51517823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010814ULL,
0x0c401f00050e7f89ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b52527823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b55557823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b54547823ULL, 0x100fe20000010814ULL,
0x0000004800487308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b57577823ULL, 0x000fe20000010814ULL,
0x00000003ff1f7819ULL, 0x000fe20000011602ULL, 0x0c201f002f327f89ULL, 0x000eea00000e0000ULL,
0x0000004b004b7308ULL, 0x000ff00000000800ULL, 0x0000004a004a7308ULL, 0x000fe20000000800ULL,
0x0000000e0500720bULL, 0x004fc80003f1e000ULL, 0x000000050e057208ULL, 0x000fc60004000000ULL,
0x0000004d004d7308ULL, 0x000ea20000000800ULL, 0x000000322f00720bULL, 0x008fe20003f3e000ULL,
0x0c201f00050e7f89ULL, 0x000ee600000e0000ULL, 0x0000002f322f7208ULL, 0x000fc60004800000ULL,
0x0000004c004c7308ULL, 0x000fe20000000800ULL, 0x0000004a4d14723eULL, 0x004fce00000010ffULL,
0x0000004f004f7308ULL, 0x000eb00000000800ULL, 0x0000004e004e7308ULL, 0x000fe20000000800ULL,
0x0000000e0500720bULL, 0x008fe40003f1e000ULL, 0x0000004c4f16723eULL, 0x004fca00000010ffULL,
0x0000005100517308ULL, 0x000ea20000000800ULL, 0x000000050e2d7208ULL, 0x000fe40004000000ULL,
0x000000484b0e723eULL, 0x000fe400000010ffULL, 0x000000251e00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b2d277820ULL, 0x000fe40000410000ULL, 0x0000005000507308ULL, 0x000fe20000000800ULL,
0x0000001e252e7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b0c057823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b41417823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010827ULL, 0x00000046490c723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010827ULL, 0x0000000500057308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b09097823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b07077823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b08087823ULL, 0x100fe20000010827ULL, 0x0000004200427308ULL, 0x000ee20000000800ULL,
0x0000004e5118723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b59597823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b56567823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b5b5b7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b58587823ULL, 0x000fe20000010827ULL, 0xfffffff8ff1e7812ULL, 0x000fe200078ee25dULL,
0x0c201f002e317f89ULL, 0x000ea200000e0000ULL, 0x0000004100417308ULL, 0x000fe20000000800ULL,
0x000000ffff257224ULL, 0x000fc400078e001cULL, 0x000000081e247836ULL, 0x000fe40000000000ULL,
0x000000081e277824ULL, 0x000fe200078e00ffULL, 0x00000005420d723eULL, 0x008fe400000010ffULL,
0x0000004000407308ULL, 0x000ee20000000800ULL, 0x0000000824347824ULL, 0x040fe400078e00ffULL,
0x0000000824337824ULL, 0x000fe400078e00ffULL, 0x000000081e2b7824ULL, 0x000fc600078e00ffULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x00000041400f723eULL, 0x008fce00000010ffULL,
0x0000001200127308ULL, 0x000ee20000000800ULL, 0x000000312e00720bULL, 0x004fc80003f1e000ULL,
0x0000002e312e7208ULL, 0x000fe20004000000ULL, 0x0000001c0c20723cULL, 0x000fe200000418ffULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x000000111215723eULL, 0x008fce00000010ffULL, 0x0000001000107308ULL, 0x000eb00000000800ULL,
0x0000005300537308ULL, 0x000ee20000000800ULL, 0x0000000b1017723eULL, 0x004fce00000010ffULL,
0x0000000900097308ULL, 0x000fe20000000800ULL, 0x0000001c1420723cULL, 0x000fe20000041820ULL,
0x00000050531a723eULL, 0x008fcc00000010ffULL, 0x0000000a000a7308ULL, 0x000eb00000000800ULL,
0x0000000700077308ULL, 0x000fe20000000800ULL, 0x000000090a19723eULL, 0x004fce00000010ffULL,
0x0000000800087308ULL, 0x000eb00000000800ULL, 0x0000005200527308ULL, 0x000fe20000000800ULL,
0x00000007081b723eULL, 0x004fce00000010ffULL, 0x0000005500557308ULL, 0x000ea20000000800ULL,
0x0000001c1820723cULL, 0x000fee0000041820ULL, 0x0000005400547308ULL, 0x000fe20000000800ULL,
0x000000031f1d7812ULL, 0x000fce00078ec0ffULL, 0x0000005700577308ULL, 0x000ee20000000800ULL,
0x000000011d297824ULL, 0x040fe400078e0224ULL, 0x000000011d267824ULL, 0x000fe400078e021eULL,
0x000000ffff247224ULL, 0x000fe200078e001cULL, 0x00000052551c723eULL, 0x004fe400000010ffULL,
0x0000005900597308ULL, 0x000fe20000000800ULL, 0xfffffff827277812ULL, 0x000fe400078ee226ULL,
0x0000000426287810ULL, 0x000fe20007ffe0ffULL, 0x0000000c26267836ULL, 0x000fe20000000000ULL,
0xfffffff834297812ULL, 0x000fe200078ee229ULL, 0x000000ffff2a7224ULL, 0x000fe200078e001cULL,
0x00000054571e723eULL, 0x008fe200000010ffULL, 0x0000005600567308ULL, 0x000ea20000000800ULL,
0xfffffff82b287812ULL, 0x000fc400078ee228ULL, 0xfffffff833347812ULL, 0x000fe200078ee226ULL,
0x000000ffff267224ULL, 0x000fe400078e0014ULL, 0x0000001029337824ULL, 0x100fe400078e0235ULL,
0x0000005b005b7308ULL, 0x000fe20000000800ULL, 0x000000ffff297224ULL, 0x000fe400078e001aULL,
0x000000ffff2b7224ULL, 0x000fe400078e001eULL, 0x0000001034347824ULL, 0x000fe200078e0235ULL,
0x00000059561d723eULL, 0x004fc400000010ffULL, 0x0000005800587308ULL, 0x000ea20000000800ULL,
0x000000ffff147224ULL, 0x000fe400078e0019ULL, 0x00000001ff197424ULL, 0x000fe200078e00ffULL,
0x0000005b581f723eULL, 0x004fce00000010ffULL, 0x000000241c20723cULL, 0x000fee0000041820ULL,
0x000000ffff247224ULL, 0x000fe400078e000cULL, 0x000000ffff257224ULL, 0x000fe400078e000eULL,
0x000000ffff0c7224ULL, 0x000fc400078e000dULL, 0x000000ffff0d7224ULL, 0x000fe400078e000fULL,
0x000000ffff0e7224ULL, 0x000fe400078e0015ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0017ULL,
0x000000ffff157224ULL, 0x000fe400078e001bULL, 0x0000001027217824ULL, 0x000fe400078e0235ULL,
0x000000ffff277224ULL, 0x000fc400078e0016ULL, 0x0000001028237824ULL, 0x000fe400078e0235ULL,
0x000000ffff287224ULL, 0x000fe200078e0018ULL, 0x0000002421007844ULL, 0x0005e20000000200ULL,
0x000000ffff167224ULL, 0x000fe400078e001dULL, 0x000000ffff177224ULL, 0x000fe200078e001fULL,
0x0000002823007844ULL, 0x0007e80000000200ULL, 0x0000000c33007844ULL, 0x0007e80000000200ULL,
0x0000001434007844ULL, 0x0007e20000000200ULL, 0x000000ffff217224ULL, 0x004fc600078e0022ULL,
0x0180002c30008388ULL, 0x0007e80000000c00ULL, 0x0182002030008388ULL, 0x0007e20000000a00ULL,
0x0000000c44007c0cULL, 0x000fe2000bf06070ULL, 0x018ad81904ff79a7ULL, 0x0007e2000850003fULL,
0x018ae01904ff79a7ULL, 0x0007e2000850003fULL, 0x018ae81904ff79a7ULL, 0x0007e2000850003fULL,
0x018af01904ff79a7ULL, 0x0007f2000850003fULL, 0xffffffac00748947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x018000000a007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000a00008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff0aff7812ULL, 0x040fe4000780c0ffULL,
0x800000000a027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000a00007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffe18024c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x000000000000056aULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000006e8ULL, 0x0000000000000240ULL, 0x0000001600000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000928ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a08ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a5cULL, 0x0000000000000a38ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001498ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001498ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x00000000000014e0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000001500ULL, 0x000000000001e780ULL, 0x0000001600000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000008dULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x000000000001fc80ULL, 0x0000000000000044ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x000000000001fcd0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x000000000001fcd0ULL, 0x0000000000000278ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x00000000000202c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x00000000000202c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x00000000000014e0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001500ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001e780ULL, 0x000000000001e780ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001fc80ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x000000000001fcd0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000278ULL, 0x0000000000000278ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_4_kvt_int8_pagedKV_128_nqpkv_1_m_1_sm_90_cubin_len = 132120;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
