/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_4_kvt_int8_pagedKV_128_nqpkv_1_m_1_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000002c6d0ULL, 0x000000000002c350ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45346a4c4545346aULL,
0x7461324545386a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL,
0x30326d735f616475ULL, 0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL,
0x65746e695f5f2400ULL, 0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x6c66625f636e7973ULL, 0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL,
0x635f5f245f335f6cULL, 0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL,
0x65746e695f5f2400ULL, 0x245f345f6c616e72ULL, 0x735f616475635f5fULL, 0x707261775f30376dULL,
0x65722e00636e7973ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL, 0x2e6c65722e006168ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x5f6c656e72656b24ULL, 0x6d656d732461686dULL,
0x0066754265747942ULL, 0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL,
0x006d617261705f00ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x2e6c65722e766e2eULL,
0x00006e6f69746361ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b9ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000407ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044cULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000492ULL, 0x000000000002a120ULL,
0x0000000000000180ULL, 0x000b0022000004c5ULL, 0x000000000002a2a0ULL, 0x0000000000000040ULL,
0x000b0022000004f0ULL, 0x000000000002a2e0ULL, 0x0000000000000040ULL, 0x000b00220000051aULL,
0x000000000002a320ULL, 0x0000000000000070ULL, 0x000b002200000545ULL, 0x000000000002a390ULL,
0x00000000000000f0ULL, 0x000a0003000005acULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000005ccULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005fcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x000000000002a480ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0002a12000000000ULL, 0x0000040400000000ULL,
0x810c000001700400ULL, 0x00a6cc0400288080ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8308288080820828ULL, 0x2880808508288080ULL, 0x8089082880808808ULL,
0x0828808090082880ULL, 0x8080960828808094ULL, 0xb008288080ad0828ULL, 0x288080b808288080ULL,
0x80be08288080bc08ULL, 0x08288080bf082880ULL, 0x8082801628808084ULL, 0x0000000000031028ULL,
0x2880808492000000ULL, 0x0000000000002200ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x0002a12000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808084ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8308288080820828ULL, 0x2880808408288080ULL, 0x8088082880808508ULL, 0x0828808089082880ULL,
0x8080960828808094ULL, 0xb008288080ad0828ULL, 0x288080b808288080ULL, 0x80bf08288080bc08ULL,
0x1628808090082880ULL, 0x0000031028808280ULL, 0x9092000000000000ULL, 0x0000002200288080ULL,
0x0000001cffffffffULL, 0x0000014800000000ULL, 0x0002a2a000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8308288080820828ULL,
0x2880808408288080ULL, 0x8088082880808508ULL, 0x0828808089082880ULL, 0x8080940828808090ULL,
0xad08288080960828ULL, 0x288080b008288080ULL, 0x80be08288080bc08ULL, 0x08288080bf082880ULL,
0x80828016288080b8ULL, 0x0000000000031028ULL, 0x288080b892000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x0000020000000000ULL, 0x0002a2e000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8308288080820828ULL,
0x2880808408288080ULL, 0x8088082880808508ULL, 0x0828808089082880ULL, 0x8080940828808090ULL,
0xad08288080960828ULL, 0x288080b008288080ULL, 0x80be08288080b808ULL, 0x08288080bf082880ULL,
0x80828016288080bcULL, 0x0000000000031028ULL, 0x288080bc92000000ULL, 0x0000000000002200ULL,
0x0000002cffffffffULL, 0x000002c000000000ULL, 0x0002a32000000000ULL, 0x0000007000000000ULL,
0x0000180400000000ULL, 0x80b8288080bc0900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8308288080820828ULL, 0x2880808408288080ULL, 0x8088082880808508ULL,
0x0828808089082880ULL, 0x8080940828808090ULL, 0xad08288080960828ULL, 0x288080b808288080ULL,
0x80be08288080bc08ULL, 0x08288080bf082880ULL, 0x80828016288080b0ULL, 0x0000000000031028ULL,
0x288080b092000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000039000000000ULL,
0x0002a39000000000ULL, 0x000000f000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL,
0x00082304000000fbULL, 0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL,
0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL,
0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL,
0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001b00082304ULL,
0x0008120400000000ULL, 0x000000000000001bULL, 0x0000001b00081104ULL, 0x0004370400000000ULL,
0x000035010000007bULL, 0x0000001800080a04ULL, 0x0068190300680160ULL, 0x00000000000c1704ULL,
0x0021f00000600007ULL, 0x00000000000c1704ULL, 0x0021f00000580006ULL, 0x00000000000c1704ULL,
0x0011f00000500005ULL, 0x00000000000c1704ULL, 0x0061f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL,
0x01bc290400000030ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x01bc2804ffffffffULL, 0x0000012000000100ULL, 0x000034e000000440ULL, 0x0000367000003570ULL,
0x00003a00000037d0ULL, 0x00003aa000003a30ULL, 0x0000712000003b10ULL, 0x000071b000007140ULL,
0x0000ac6000007220ULL, 0x0000ade00000acf0ULL, 0x0000b1500000af30ULL, 0x0000b1e00000b170ULL,
0x0000e6800000b250ULL, 0x0000e7100000e6a0ULL, 0x000120a00000e780ULL, 0x0001222000012130ULL,
0x0001259000012370ULL, 0x00012620000125b0ULL, 0x00015ac000012690ULL, 0x00015b5000015ae0ULL,
0x000194e000015bc0ULL, 0x0001966000019570ULL, 0x000199d0000197b0ULL, 0x00019a60000199f0ULL,
0x0001cf0000019ad0ULL, 0x0001cf900001cf20ULL, 0x0001f2700001d000ULL, 0x0001f9a00001f3b0ULL,
0x0001fe500001f9c0ULL, 0x00022ad000022060ULL, 0x00024c1000022af0ULL, 0x0002802000024c30ULL,
0x0002807000028060ULL, 0x000280d000028080ULL, 0x00028110000280f0ULL, 0x00028dc000028120ULL,
0x00028ea000028e20ULL, 0x00028fa000028f20ULL, 0x000290a000029020ULL, 0x0002918000029120ULL,
0x00029250000291e0ULL, 0x00029350000292d0ULL, 0x00029450000293d0ULL, 0x00029530000294d0ULL,
0x0002960000029590ULL, 0x0002970000029680ULL, 0x0002980000029780ULL, 0x000298e000029880ULL,
0x000299b000029940ULL, 0x00029ab000029a30ULL, 0x00029bb000029b30ULL, 0x00029ca000029c30ULL,
0x00029d8000029d10ULL, 0x00029e8000029e00ULL, 0x00029f8000029f00ULL, 0x0002a0800002a000ULL,
0x07e039040002a100ULL, 0x000000ff00000210ULL, 0x003f010000018ad0ULL, 0x0000000b00000240ULL,
0x003f012000018ad8ULL, 0x0000000b00000270ULL, 0x003f012000018b58ULL, 0x0000000b000002a0ULL,
0x003f012000018b78ULL, 0x000000ff00000390ULL, 0x003f010000018b88ULL, 0x000000ff00000550ULL,
0x003f010700018ad0ULL, 0x000000ff00000830ULL, 0x0005010200018b5cULL, 0x000000ff00000890ULL,
0x0005010100018b58ULL, 0x000000ff00000a10ULL, 0x003f010100018b88ULL, 0x000000ff00000a50ULL,
0x003f010500018b8cULL, 0x000000ff00000c10ULL, 0x003f010500018b8cULL, 0x000000ff00001640ULL,
0x003f010100018b88ULL, 0x000000ff00001670ULL, 0x003f010500018b8cULL, 0x000000ff00001840ULL,
0x003f010500018b8cULL, 0x000000ff000019b0ULL, 0x003f010700018b78ULL, 0x000000ff00001a30ULL,
0x003f010100018b78ULL, 0x000000ff00001aa0ULL, 0x003f010100018b88ULL, 0x000000ff00001d30ULL,
0x003f010500018b7cULL, 0x000000ff00001ef0ULL, 0x003f010500018b7cULL, 0x000000ff00001f50ULL,
0x003f010500018b8cULL, 0x000000ff00002120ULL, 0x003f010500018b8cULL, 0x000000ff00002b70ULL,
0x003f010100018b88ULL, 0x000000ff00002ba0ULL, 0x003f010500018b8cULL, 0x000000ff00002d70ULL,
0x003f010500018b8cULL, 0x000000ff000030f0ULL, 0x003f010700018b80ULL, 0x000000ff00003180ULL,
0x003f010100018b80ULL, 0x000000ff00003200ULL, 0x0005010100018ad8ULL, 0x000000ff00003230ULL,
0x0005010500018adcULL, 0x000000ff00003400ULL, 0x0005010500018adcULL, 0x000000ff00005d60ULL,
0x003f010100018b88ULL, 0x000000ff00005e30ULL, 0x003f010500018b84ULL, 0x000000ff00005ff0ULL,
0x003f010500018b84ULL, 0x000000ff00006050ULL, 0x003f010500018b8cULL, 0x000000ff00006220ULL,
0x003f010500018b8cULL, 0x000000ff00006c60ULL, 0x003f010100018b88ULL, 0x000000ff00006c90ULL,
0x003f010500018b8cULL, 0x000000ff00006e60ULL, 0x003f010500018b8cULL, 0x000000ff00007030ULL,
0x003f010700018b78ULL, 0x000000ff000070b0ULL, 0x003f010100018b78ULL, 0x000000ff00009330ULL,
0x003f010100018b88ULL, 0x000000ff00009400ULL, 0x003f010100018b58ULL, 0x000000ff000094e0ULL,
0x003f010500018b7cULL, 0x000000ff000096a0ULL, 0x003f010500018b7cULL, 0x000000ff00009700ULL,
0x003f010500018b8cULL, 0x000000ff000098d0ULL, 0x003f010500018b8cULL, 0x000000ff0000a310ULL,
0x003f010100018b88ULL, 0x000000ff0000a340ULL, 0x003f010500018b8cULL, 0x000000ff0000a510ULL,
0x003f010500018b8cULL, 0x000000ff0000a860ULL, 0x003f010700018b80ULL, 0x000000ff0000a8e0ULL,
0x003f010100018b80ULL, 0x000000ff0000a980ULL, 0x0005010100018af8ULL, 0x000000ff0000a9b0ULL,
0x0005010500018afcULL, 0x000000ff0000ab80ULL, 0x0005010500018afcULL, 0x000000ff0000d2b0ULL,
0x003f010100018b88ULL, 0x000000ff0000d390ULL, 0x003f010500018b84ULL, 0x000000ff0000d550ULL,
0x003f010500018b84ULL, 0x000000ff0000d5b0ULL, 0x003f010500018b8cULL, 0x000000ff0000d780ULL,
0x003f010500018b8cULL, 0x000000ff0000e1c0ULL, 0x003f010100018b88ULL, 0x000000ff0000e1f0ULL,
0x003f010500018b8cULL, 0x000000ff0000e3c0ULL, 0x003f010500018b8cULL, 0x000000ff0000e590ULL,
0x003f010700018b78ULL, 0x000000ff0000e610ULL, 0x003f010100018b78ULL, 0x000000ff00010790ULL,
0x003f010100018b88ULL, 0x000000ff00010840ULL, 0x003f010100018b60ULL, 0x000000ff00010920ULL,
0x003f010500018b7cULL, 0x000000ff00010ae0ULL, 0x003f010500018b7cULL, 0x000000ff00010b40ULL,
0x003f010500018b8cULL, 0x000000ff00010d10ULL, 0x003f010500018b8cULL, 0x000000ff00011750ULL,
0x003f010100018b88ULL, 0x000000ff00011780ULL, 0x003f010500018b8cULL, 0x000000ff00011950ULL,
0x003f010500018b8cULL, 0x000000ff00011ca0ULL, 0x003f010700018b80ULL, 0x000000ff00011d20ULL,
0x003f010100018b80ULL, 0x000000ff00011dc0ULL, 0x0005010100018b18ULL, 0x000000ff00011df0ULL,
0x0005010500018b1cULL, 0x000000ff00011fc0ULL, 0x0005010500018b1cULL, 0x000000ff000146f0ULL,
0x003f010100018b88ULL, 0x000000ff000147d0ULL, 0x003f010500018b84ULL, 0x000000ff00014990ULL,
0x003f010500018b84ULL, 0x000000ff000149f0ULL, 0x003f010500018b8cULL, 0x000000ff00014bc0ULL,
0x003f010500018b8cULL, 0x000000ff00015600ULL, 0x003f010100018b88ULL, 0x000000ff00015630ULL,
0x003f010500018b8cULL, 0x000000ff00015800ULL, 0x003f010500018b8cULL, 0x000000ff000159d0ULL,
0x003f010700018b78ULL, 0x000000ff00015a50ULL, 0x003f010100018b78ULL, 0x000000ff00017bd0ULL,
0x003f010100018b88ULL, 0x000000ff00017c80ULL, 0x003f010100018b68ULL, 0x000000ff00017d60ULL,
0x003f010500018b7cULL, 0x000000ff00017f20ULL, 0x003f010500018b7cULL, 0x000000ff00017f80ULL,
0x003f010500018b8cULL, 0x000000ff00018150ULL, 0x003f010500018b8cULL, 0x000000ff00018b90ULL,
0x003f010100018b88ULL, 0x000000ff00018bc0ULL, 0x003f010500018b8cULL, 0x000000ff00018d90ULL,
0x003f010500018b8cULL, 0x000000ff000190e0ULL, 0x003f010700018b80ULL, 0x000000ff00019160ULL,
0x003f010100018b80ULL, 0x000000ff00019200ULL, 0x0005010100018b38ULL, 0x000000ff00019230ULL,
0x0005010500018b3cULL, 0x000000ff00019400ULL, 0x0005010500018b3cULL, 0x000000ff0001bb30ULL,
0x003f010100018b88ULL, 0x000000ff0001bc10ULL, 0x003f010500018b84ULL, 0x000000ff0001bdd0ULL,
0x003f010500018b84ULL, 0x000000ff0001be30ULL, 0x003f010500018b8cULL, 0x000000ff0001c000ULL,
0x003f010500018b8cULL, 0x000000ff0001ca40ULL, 0x003f010100018b88ULL, 0x000000ff0001ca70ULL,
0x003f010500018b8cULL, 0x000000ff0001cc40ULL, 0x003f010500018b8cULL, 0x000000ff0001ce10ULL,
0x003f010700018b78ULL, 0x000000ff0001ce90ULL, 0x003f010100018b78ULL, 0x000000ff0001f010ULL,
0x003f010100018b88ULL, 0x000000ff0001f0b0ULL, 0x003f010100018b70ULL, 0x000000ff0001fbf0ULL,
0x003f010100018ad0ULL, 0x000000ff00022090ULL, 0x003f010500018ad4ULL, 0x000000ff00022260ULL,
0x003f010500018ad4ULL, 0x000000ff000225e0ULL, 0x003f010100018ad0ULL, 0x000000ff00022620ULL,
0x003f010500018ad4ULL, 0x000000ff000227e0ULL, 0x003f010500018ad4ULL, 0x00000005000271f0ULL,
0x003f010100000000ULL, 0x0000000500027570ULL, 0x003f010500000004ULL, 0x0000000500027740ULL,
0x003f010500000004ULL, 0x0000000700028c10ULL, 0x003f010100000000ULL, 0x0000000700028c70ULL,
0x003f010100000008ULL, 0x0000000700028cd0ULL, 0x003f010100000010ULL, 0x0000000700028d40ULL,
0x003f010100000018ULL, 0x00101c0400053803ULL, 0x000228400001faf0ULL, 0x00028d8000022910ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000043cULL, 0x0000001b00000002ULL,
0x000000000000036cULL, 0x0000001b00000002ULL, 0x00000000000002acULL, 0x0000001b00000002ULL,
0x00000000000001ecULL, 0x0000001b00000002ULL, 0x000000000000011cULL, 0x0000001b00000002ULL,
0x0000000000000044ULL, 0x0000001b00000002ULL, 0x0000000000000413ULL, 0x0000001b00000002ULL,
0x0000000000000343ULL, 0x0000001b00000002ULL, 0x0000000000000283ULL, 0x0000001b00000002ULL,
0x00000000000001c6ULL, 0x0000001b00000002ULL, 0x00000000000000f3ULL, 0x0000001b00000002ULL,
0x0000000000018c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x00000000001379c3ULL, 0x000ea20000002700ULL, 0x00000000000d7806ULL, 0x000fe200038e0000ULL,
0x00005800000e7ab9ULL, 0x000fe20000000800ULL, 0x0000000000037919ULL, 0x000ee20000002300ULL,
0x00000200000f7882ULL, 0x000fe20000000000ULL, 0x0000000d00067300ULL, 0x000fe200000e0000ULL,
0x00005c0000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000f220000002200ULL,
0x00000000000d79c3ULL, 0x000ea20000002600ULL, 0x0000460000107ab9ULL, 0x000fc40000000a00ULL,
0x00000000000c7919ULL, 0x000ea40000000000ULL, 0x0000000d000d7309ULL, 0x000ee40000000000ULL,
0x0000000000077919ULL, 0x000ea20000000000ULL, 0x00000005ff007819ULL, 0x002fc6000001160bULL,
0x00001fff03047589ULL, 0x008e6200000e0000ULL, 0x000000ffff0d7224ULL, 0x000fc600078e0a0dULL,
0x00001fff00007589ULL, 0x000ee200000e0000ULL, 0x0000010003027a24ULL, 0x010fc800078e0202ULL,
0x00000000020b7a24ULL, 0x000fe200078e020bULL, 0x000000070600720cULL, 0x004fc80003f02070ULL,
0x000000ff0b00720cULL, 0x040fe40003fa5270ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x000000030b00780cULL, 0x040fe40003f44070ULL, 0x0000007f0b00780cULL, 0x040fe40003f64070ULL,
0x000000010b00780cULL, 0x000fe20003f84070ULL, 0x00000000041273c2ULL, 0x0022a800000e0000ULL,
0x3fffff80ff02d424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03d424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x00000000000873c2ULL, 0x008ea200000e0000ULL,
0x3fffffc0ff049424ULL, 0x002fe200078e00ffULL, 0x018ad002ff00d388ULL, 0x0003e20000000a00ULL,
0x3fffff60ff06a424ULL, 0x000fe400078e00ffULL, 0x7fffff60ff07a424ULL, 0x000fe200078e00ffULL,
0x018ad8040b009388ULL, 0x0007e20000008a00ULL, 0xff317217ff0ab424ULL, 0x000fc400078e00ffULL,
0x3fffff00ff08c424ULL, 0x000fe200078e00ffULL, 0x018b58060b00a388ULL, 0x0009e20000008a00ULL,
0x7fffff00ff09c424ULL, 0x000fc600078e00ffULL, 0x0184000a0b00b388ULL, 0x000fe80000004800ULL,
0x018b78080b00c388ULL, 0x000fe20000008a00ULL, 0x0000000812047291ULL, 0x004fc8000f8e103fULL,
0x00000001040a7899ULL, 0x000fe4000800063fULL, 0x000000020e047899ULL, 0x000fe4000800063fULL,
0x000000010a0c7890ULL, 0x000fe4000fffe03fULL, 0x0000000aff027e24ULL, 0x002fe2000f8e00ffULL,
0x0000000a0c007c10ULL, 0x000fe2000fffe0ffULL, 0x00000013040972a4ULL, 0x000fe4000f8e020dULL,
0x0000002002057824ULL, 0x008fe200078e00ffULL, 0x000000040a00788cULL, 0x000fe2000bf01070ULL,
0x3fffff80ff02d424ULL, 0x000fe200078e00ffULL, 0x0000000e0a0472a4ULL, 0x000fc4000f8e0209ULL,
0xffffffe005047812ULL, 0x000fe200078ee200ULL, 0x0000000cff007e24ULL, 0x000fe2000f8e00ffULL,
0x000000040a0b7887ULL, 0x000fe2000c000000ULL, 0x018b8802ff00d388ULL, 0x000fe20000000a00ULL,
0x0000000f040472a5ULL, 0x000fe2000f8e0006ULL, 0x0000002000067824ULL, 0x010fe200078e00ffULL,
0x0000000b0a0b7290ULL, 0x000fe2000fffe13fULL, 0x000000100c007824ULL, 0x040fe200078e00ffULL,
0x0000000e0c0972a4ULL, 0x000fe2000f8e0209ULL, 0x0000000c0c057c10ULL, 0x000fe2000fffe0ffULL,
0x000000010b00788cULL, 0x000fe2000bf03070ULL, 0x0000001004077824ULL, 0x000fe200078e00ffULL,
0x000001f000007812ULL, 0x000fe200078ec0ffULL, 0x0000000f090672a5ULL, 0x000fe2000f8e0006ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000400027c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000400097882ULL, 0x000fe20000000000ULL, 0x0000000bff007c0cULL, 0x000fe2000bf26070ULL,
0x00000002130a7899ULL, 0x000fe2000800063fULL, 0xffffffe006067812ULL, 0x000fe200078ee205ULL,
0x00000005ff037e24ULL, 0x000fe200090e06ffULL, 0x000000000000781cULL, 0x000fc40003f4f008ULL,
0x0000000600047c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001006097824ULL, 0x000fe400078e00ffULL,
0x000000ffff007224ULL, 0x000fe400078e000dULL, 0x00000007ff057e24ULL, 0x000fe400098e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000c901c50ULL,
0x0000000004097faeULL, 0x0003e8000d101c50ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x018ad400ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018ad000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000620000047ab9ULL, 0x000fe40000000a00ULL,
0x000000090a0472a5ULL, 0x000fc4000f8e0004ULL, 0x00006a0000067ab9ULL, 0x000fe40000000a00ULL,
0x000000090a0672a5ULL, 0x000fe4000f8e0006ULL, 0x00000004ff607e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff617e24ULL, 0x000fe4000f8e00ffULL, 0x00000006ff027e24ULL, 0x002fe4000f8e00ffULL,
0x00000007ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000001060607981ULL, 0x000ea8000c1e1900ULL,
0x0000001002027981ULL, 0x000ee2000c1e1900ULL, 0x00000012ff007c0cULL, 0x000fc4000bf05270ULL,
0x0000007f60377810ULL, 0x044fe40007ffe0ffULL, 0x000000ff600a7810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff347819ULL, 0x008fe40000011602ULL, 0x00000007ff377819ULL, 0x000fe40000011637ULL,
0x00000008ff367819ULL, 0x000fc6000001160aULL, 0x0001f42000008947ULL, 0x000fea0003800000ULL,
0x00000008ff357e24ULL, 0x000fe2000f8e00ffULL, 0x0000000308057899ULL, 0x000fe2000800063fULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x00000003ff007424ULL, 0x000fe400078e00ffULL,
0x0000002035057824ULL, 0x000fca00078e020cULL, 0x0000001f0500780cULL, 0x040fe40003f04070ULL,
0x000000030500780cULL, 0x000fd60003f24070ULL, 0x0000007000000947ULL, 0x000fea0003800000ULL,
0x0000000aff027e24ULL, 0x000fe2000f8e00ffULL, 0x000000600500720cULL, 0x040fe20003f06070ULL,
0x00000004ff037424ULL, 0x000fe200078e00ffULL, 0x00018a0005077811ULL, 0x000fe200078e10ffULL,
0x0000680002027a24ULL, 0x000fc800078e0205ULL, 0x0000660002027625ULL, 0x000fcc00078e0003ULL,
0x0000000002077faeULL, 0x0003e4000c121850ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b5c00ffff798cULL, 0x0005e20008000005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b5800ffff7f8cULL, 0x000fe2000c800405ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x004ea20000002700ULL, 0x00006400ff037624ULL, 0x002fe200078e00ffULL,
0x000000ff3700720cULL, 0x000fe20003f05270ULL, 0x00000004ff077424ULL, 0x000fe400078e00ffULL,
0x0000000400007824ULL, 0x004fe200078e0205ULL, 0x00018ac005057811ULL, 0x000fc600078e10ffULL,
0x0000000200007824ULL, 0x000fc800078e00ffULL, 0x0000640000007624ULL, 0x000fc800078e0203ULL,
0x0000600000027625ULL, 0x000fca00078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e40008121850ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff027f8cULL, 0x002e62000c80043fULL,
0x000000ffff067224ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x002fc400078e0003ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x018b8c00ff007984ULL, 0x004e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000700007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x018b8c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000337919ULL, 0x000e620000002600ULL, 0x000001ff0a00780cULL, 0x000fe20003f04070ULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x0000000704047899ULL, 0x000fe2000800063fULL,
0x0000008033337824ULL, 0x002fd200078e00ffULL, 0x000004f000000947ULL, 0x000fea0003800000ULL,
0x0000000000117919ULL, 0x000e620000000000ULL, 0x0000000560007c17ULL, 0x000fe2000f800000ULL,
0x00000100ff0f7424ULL, 0x000fc600078e00ffULL, 0x8000000500007c10ULL, 0x000fe4000fffe0ffULL,
0x00000004ff077819ULL, 0x002fe20000011611ULL, 0x00000010110d7824ULL, 0x000fc600078e00ffULL,
0x0000000507067c10ULL, 0x000fe4000fffe0ffULL, 0x000000f00d0d7812ULL, 0x000fe400078ec0ffULL,
0x000000000700720cULL, 0x000fe20003f06070ULL, 0x018a000006047984ULL, 0x000e620000004800ULL,
0x0000000133037824ULL, 0x000fe400078e0206ULL, 0x0000000106057824ULL, 0x040fe400078e0211ULL,
0x0000001006087824ULL, 0x000fe200078e00ffULL, 0x018ac00004047984ULL, 0x002e640000004800ULL,
0x0000000404037c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0003027625ULL, 0x000fca00078e000fULL,
0x0000000d02047210ULL, 0x000fe40007f3e0ffULL, 0xfffffff008027812ULL, 0x000fc600078ee205ULL,
0x000000ffff057224ULL, 0x000fe200008e0603ULL, 0x0001400002097811ULL, 0x000fe400078e20ffULL,
0x0000000207037810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e2000c101c50ULL, 0x0000000503087c10ULL, 0x040fe4000fffe0ffULL,
0x000000000300720cULL, 0x000fe20003f06070ULL, 0x018a0800060a7984ULL, 0x000ea40000004800ULL,
0x00000001330b7824ULL, 0x000fe400078e0208ULL, 0x018ac0000a0a7984ULL, 0x004ea40000004800ULL,
0x000000040a027c24ULL, 0x004fc4000f8e020bULL, 0x00000001080b7824ULL, 0x000fe400078e0211ULL,
0x00005e0002027625ULL, 0x000fc800078e000fULL, 0x0000001008087824ULL, 0x000fe200078e00ffULL,
0x0000000d02047210ULL, 0x002fc80007f3e0ffULL, 0xfffffff0080b7812ULL, 0x000fe200078ee20bULL,
0x000000ffff057224ULL, 0x000fe200008e0603ULL, 0x0000000407037810ULL, 0x000fe40007ffe0ffULL,
0x000140000b0b7811ULL, 0x000fe400078e20ffULL, 0x0000000503087c10ULL, 0x000fe4000fffe0ffULL,
0x0000000607077810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e2000c101c50ULL, 0x000000000300720cULL, 0x000fe20003f06070ULL,
0x0000000133027824ULL, 0x000fc400078e0208ULL, 0x018a100006097984ULL, 0x000ea20000004800ULL,
0x00000001080a7824ULL, 0x040fe400078e0211ULL, 0x0000001008137824ULL, 0x000fe200078e00ffULL,
0x0000000507087c10ULL, 0x000fc8000fffe0ffULL, 0xfffffff0130a7812ULL, 0x000fe200078ee20aULL,
0x018ac00009097984ULL, 0x004ea40000004800ULL, 0x0000000409027c24ULL, 0x004fe2000f8e0202ULL,
0x000140000a097811ULL, 0x000fc600078e20ffULL, 0x00005e0002027625ULL, 0x000fca00078e000fULL,
0x0000000d02047210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fe400008e0603ULL,
0x0000000133037824ULL, 0x000fc600078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e2000c101c50ULL, 0x000000000700720cULL, 0x000fe20003f06070ULL,
0x0000000108007824ULL, 0x040fe400078e0211ULL, 0x018a180006067984ULL, 0x000ea20000004800ULL,
0x0000001008077824ULL, 0x000fca00078e00ffULL, 0xfffffff007007812ULL, 0x000fc800078ee200ULL,
0x0001400000057811ULL, 0x002fe200078e20ffULL, 0x018ac00006027984ULL, 0x004e640000004800ULL,
0x0000000402027c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0002027625ULL, 0x000fca00078e000fULL,
0x0000000d02027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e2000c101c50ULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x00000000000b7919ULL, 0x000e620000000000ULL,
0x00000100ff0a7424ULL, 0x000fe200078e00ffULL, 0x000000050b007c11ULL, 0x042fe2000f8fe0ffULL,
0x000000100b027824ULL, 0x000fc800078e00ffULL, 0x018a000000067984ULL, 0x000e620000004800ULL,
0x0000000133037824ULL, 0x000fe200078e0200ULL, 0x000000f0020d7812ULL, 0x000fe200078ec0ffULL,
0x0000000100057824ULL, 0x040fe400078e020bULL, 0x0000001000087824ULL, 0x000fe200078e00ffULL,
0x018ac00006067984ULL, 0x002e640000004800ULL, 0x0000000406037c24ULL, 0x002fe2000f8e0203ULL,
0x0000000200067810ULL, 0x000fc60007ffe0ffULL, 0x00005e0003027625ULL, 0x000fc800078e000aULL,
0x0000000106077824ULL, 0x000fe200078e020bULL, 0x0000000d02047210ULL, 0x000fe20007f1e0ffULL,
0x00000010060c7824ULL, 0x000fe200078e00ffULL, 0xfffffff008027812ULL, 0x000fc600078ee205ULL,
0x000000ffff057224ULL, 0x000fe200000e0603ULL, 0x0001400002097811ULL, 0x000fe200078e20ffULL,
0x0000000133037824ULL, 0x000fc800078e0206ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e8000b901c50ULL, 0x018a080000087984ULL, 0x000ea20000004800ULL,
0x0000000400047810ULL, 0x002fca0007ffe0ffULL, 0x0000000104057824ULL, 0x000fe200078e020bULL,
0x018ac00008087984ULL, 0x004e640000004800ULL, 0x0000000408037c24ULL, 0x002fc8000f8e0203ULL,
0x00005e0003027625ULL, 0x000fca00078e000aULL, 0x0000000d02067210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00c027812ULL, 0x000fe200078ee207ULL, 0x00000010040c7824ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe200000e0603ULL, 0x0001400002097811ULL, 0x000fe200078e20ffULL,
0x0000000133037824ULL, 0x000fc800078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e8000b901c50ULL, 0x018a100000087984ULL, 0x000ea20000004800ULL,
0x0000000600067810ULL, 0x002fca0007ffe0ffULL, 0x0000000106097824ULL, 0x000fe200078e020bULL,
0x018ac00008087984ULL, 0x004e640000004800ULL, 0x0000000408037c24ULL, 0x002fc8000f8e0203ULL,
0x00005e0003027625ULL, 0x000fca00078e000aULL, 0x0000000d02047210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00c027812ULL, 0x000fc600078ee205ULL, 0x000000ffff057224ULL, 0x000fe200000e0603ULL,
0x0001400002077811ULL, 0x000fe200078e20ffULL, 0x0000000133037824ULL, 0x000fe400078e0206ULL,
0x0000001006067824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e6000b901c50ULL, 0xfffffff006097812ULL, 0x000fe200078ee209ULL,
0x018a180000087984ULL, 0x000ea60000004800ULL, 0x0001400009097811ULL, 0x000fe200078e20ffULL,
0x018ac00008087984ULL, 0x004ea40000004800ULL, 0x0000000408037c24ULL, 0x004fc8000f8e0203ULL,
0x00005e0003027625ULL, 0x000fca00078e000aULL, 0x0000000d02027210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff037224ULL, 0x000fca00000e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e6000b901c50ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff027f8cULL, 0x002e64000c80043fULL, 0x000000ffff097224ULL, 0x002fc400078e0003ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x018b8c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x018b8c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000327919ULL, 0x000e620000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000002035007824ULL, 0x002fca00078e0232ULL,
0x0000001f0000780cULL, 0x000fda0003f04070ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000000aff057e24ULL, 0x000fe2000f8e00ffULL, 0x0000002000037810ULL, 0x000fc60007ffe0ffULL,
0x0000680005027a24ULL, 0x000fe200078e0200ULL, 0x000000600300720cULL, 0x000fe20003f06070ULL,
0x00000004ff037424ULL, 0x000fe200078e00ffULL, 0x00018a0000057811ULL, 0x000fe400078e10ffULL,
0x0000002002027810ULL, 0x000fca0007ffe0ffULL, 0x0000660002027625ULL, 0x000fca00078e0003ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e4000c121850ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b7800ff027f8cULL, 0x002e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff3600720cULL, 0x000fe20003f05270ULL,
0x018b8800ff047f8cULL, 0x000ea2000c80043fULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x0001d54000008947ULL, 0x000fea0003800000ULL, 0x00005800ff0d7624ULL, 0x000fe200078e00ffULL,
0x0001d52000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6b7224ULL, 0x002fe200078e0003ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3c7224ULL, 0x004fc400078e0005ULL,
0xff317217ff107424ULL, 0x000fe400078e00ffULL, 0x000000ffff317224ULL, 0x000fe400078e00ffULL,
0x000000800d0d7824ULL, 0x000fc400078e00ffULL, 0x000001000f037824ULL, 0x000fca00078e00ffULL,
0x000000600300720cULL, 0x000fda0003f06070ULL, 0x0001d44000000947ULL, 0x000fea0003800000ULL,
0x000000ffff6a7224ULL, 0x000fc600078e00ffULL, 0x0000000f3400720cULL, 0x000fe20003fa4070ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000002ff037819ULL, 0x000fe2000001166aULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x000000036a007812ULL, 0x040fe400078ec0ffULL,
0x000000036a0c7207ULL, 0x000fe40002800000ULL, 0x000000ff00387207ULL, 0x000fe40006800000ULL,
0x000000030c3b7812ULL, 0x000fc400078ec0ffULL, 0x0000000f0c3d7211ULL, 0x000fc400078ff0ffULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x018b7c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000700007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b7c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x018b8c00ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000013d037810ULL, 0x040fe20007ffe0ffULL,
0x000000043d007824ULL, 0x000fe200078e023bULL, 0x0000098000017945ULL, 0x000fe40003800000ULL,
0x000000360300720cULL, 0x000fe40003f06070ULL, 0x0000002000037811ULL, 0x000fc800078e30ffULL,
0x00000060333a7812ULL, 0x000fce00078ef803ULL, 0x0000050000008947ULL, 0x000fea0003800000ULL,
0x00000004ff397819ULL, 0x000fe20000011632ULL, 0x0000001032047824ULL, 0x000fe200078e00ffULL,
0x0000000360007217ULL, 0x000fe20007800000ULL, 0x00000100ff417424ULL, 0x000fe200078e00ffULL,
0x00000005393f7c10ULL, 0x040fe4000fffe0ffULL, 0x000000f004437812ULL, 0x000fe200078ec0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a03ULL, 0x0000000239457810ULL, 0x000fe20007ffe0ffULL,
0x018a00003f027984ULL, 0x000e620000004800ULL, 0x000000013f037824ULL, 0x000fc400078e023aULL,
0x0000000500007c17ULL, 0x000fe2000f800000ULL, 0x000000013f057824ULL, 0x000fe200078e0232ULL,
0x0000000545477c10ULL, 0x000fe2000fffe0ffULL, 0x000000103f067824ULL, 0x000fe200078e00ffULL,
0x8000000500007c10ULL, 0x000fc6000fffe0ffULL, 0x00000001473c7824ULL, 0x000fe200078e0232ULL,
0x000000003900720cULL, 0x000fe40003f06070ULL, 0xfffffff006077812ULL, 0x000fc800078ee205ULL,
0x0001600007077811ULL, 0x000fe200078e20ffULL, 0x018ac00002027984ULL, 0x002e640000004800ULL,
0x000000020d037224ULL, 0x002fc800078e0203ULL, 0x00005e0003027625ULL, 0x000fca00078e0041ULL,
0x0000004302047210ULL, 0x000fe20007f3e0ffULL, 0x0000000147027824ULL, 0x040fe400078e023aULL,
0x0000001047477824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fca00008e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e2000c101c50ULL,
0x000000004500720cULL, 0x000fe40003f06070ULL, 0x0000000439457810ULL, 0x040fe20007ffe0ffULL,
0x018a08003f067984ULL, 0x000ea20000004800ULL, 0x0000000639397810ULL, 0x000fe40007ffe0ffULL,
0xfffffff047077812ULL, 0x002fe400078ee23cULL, 0x0000000545477c10ULL, 0x000fe4000fffe0ffULL,
0x0001600007077811ULL, 0x000fc600078e20ffULL, 0x00000001473c7824ULL, 0x000fe200078e0232ULL,
0x018ac00006067984ULL, 0x004e640000004800ULL, 0x000000060d027224ULL, 0x002fc800078e0202ULL,
0x00005e0002027625ULL, 0x000fca00078e0041ULL, 0x0000004302047210ULL, 0x000fe20007f3e0ffULL,
0x0000000147027824ULL, 0x040fe400078e023aULL, 0x0000001047477824ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fca00008e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000c101c50ULL, 0x000000004500720cULL, 0x000fe40003f06070ULL,
0x0000000539457c10ULL, 0x000fe2000fffe0ffULL, 0x018a10003f067984ULL, 0x000ea20000004800ULL,
0xfffffff047077812ULL, 0x002fc800078ee23cULL, 0x0001600007077811ULL, 0x000fe200078e20ffULL,
0x018ac00006067984ULL, 0x004e640000004800ULL, 0x000000060d027224ULL, 0x002fc800078e0202ULL,
0x00005e0002027625ULL, 0x000fca00078e0041ULL, 0x0000004302047210ULL, 0x000fe20007f3e0ffULL,
0x0000000145027824ULL, 0x040fe400078e023aULL, 0x00000001453a7824ULL, 0x040fe400078e0232ULL,
0x000000ffff057224ULL, 0x000fe400008e0603ULL, 0x0000001045457824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e2000c101c50ULL,
0x000000003900720cULL, 0x000fc60003f06070ULL, 0x018a18003f067984ULL, 0x000ea20000004800ULL,
0xfffffff045057812ULL, 0x002fc800078ee23aULL, 0x0001600005057811ULL, 0x000fe200078e20ffULL,
0x018ac00006067984ULL, 0x004e640000004800ULL, 0x000000060d027224ULL, 0x002fc800078e0202ULL,
0x00005e0002027625ULL, 0x000fca00078e0041ULL, 0x0000004302027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x00000005323f7c11ULL, 0x040fe2000f8fe0ffULL, 0x0000001032037824ULL, 0x000fe400078e00ffULL,
0x00000100ff417424ULL, 0x000fe200078e00ffULL, 0x000000023f077810ULL, 0x040fe20007ffe0ffULL,
0x018a00003f007984ULL, 0x000e620000004800ULL, 0x000000013f027824ULL, 0x000fe200078e023aULL,
0x000000f003437812ULL, 0x000fe200078ec0ffULL, 0x000000013f057824ULL, 0x040fe400078e0232ULL,
0x000000103f067824ULL, 0x000fc400078e00ffULL, 0x00000001073c7824ULL, 0x000fc600078e0232ULL,
0xfffffff006397812ULL, 0x000fc800078ee205ULL, 0x0001600039397811ULL, 0x000fe200078e20ffULL,
0x018ac00000007984ULL, 0x002e640000004800ULL, 0x000000000d027224ULL, 0x002fc800078e0202ULL,
0x00005e0002027625ULL, 0x000fca00078e0041ULL, 0x0000004302047210ULL, 0x000fe20007f1e0ffULL,
0x0000000107027824ULL, 0x040fe400078e023aULL, 0x0000001007077824ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fc600000e0603ULL, 0xfffffff0073c7812ULL, 0x000fe400078ee23cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004397faeULL, 0x0003e8000b901c50ULL,
0x018a08003f007984ULL, 0x000ea20000004800ULL, 0x000160003c397811ULL, 0x002fe400078e20ffULL,
0x000000043f057810ULL, 0x000fca0007ffe0ffULL, 0x00000001053c7824ULL, 0x000fe200078e0232ULL,
0x018ac00000007984ULL, 0x004e640000004800ULL, 0x000000000d027224ULL, 0x002fc800078e0202ULL,
0x00005e0002027625ULL, 0x000fca00078e0041ULL, 0x0000004302067210ULL, 0x000fe20007f1e0ffULL,
0x0000000105027824ULL, 0x040fe400078e023aULL, 0x0000001005057824ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fc600000e0603ULL, 0xfffffff0053c7812ULL, 0x000fe400078ee23cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006397faeULL, 0x0003e8000b901c50ULL,
0x018a10003f007984ULL, 0x000ea20000004800ULL, 0x000160003c077811ULL, 0x002fe400078e20ffULL,
0x000000063f397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139067824ULL, 0x000fe200078e0232ULL,
0x018ac00000007984ULL, 0x004e640000004800ULL, 0x000000000d027224ULL, 0x002fc800078e0202ULL,
0x00005e0002027625ULL, 0x000fca00078e0041ULL, 0x0000004302047210ULL, 0x000fe20007f1e0ffULL,
0x0000000139027824ULL, 0x040fe400078e023aULL, 0x0000001039397824ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fc600000e0603ULL, 0xfffffff039067812ULL, 0x000fe400078ee206ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000b901c50ULL,
0x018a18003f007984ULL, 0x000ea20000004800ULL, 0x0001600006057811ULL, 0x002fc600078e20ffULL,
0x018ac00000007984ULL, 0x004e640000004800ULL, 0x000000000d027224ULL, 0x002fc800078e0202ULL,
0x00005e0002027625ULL, 0x000fca00078e0041ULL, 0x0000004302027210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff037224ULL, 0x000fca00000e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e6000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff027f8cULL, 0x002e64000c80043fULL,
0x000000ffff397224ULL, 0x002fc400078e0003ULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x018b8c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804839ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011405ULL,
0x0000000700007211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000200007819ULL, 0x000fc80000001205ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000003d3400720cULL, 0x080fe20003f24070ULL, 0x0000022000017945ULL, 0x000fe20003800000ULL,
0x0000000138027810ULL, 0x000fe40007ffe0ffULL, 0x0000003d3400720cULL, 0x000fe40003f04070ULL,
0x0000000302037812ULL, 0x000fc400078ec0ffULL, 0x000000010c007812ULL, 0x000fe200078ec0ffULL,
0x00000020350c7824ULL, 0x000fe200078e0232ULL, 0x000000033800780cULL, 0x000fc60004705270ULL,
0x00000002ff029819ULL, 0x000fe40000011602ULL, 0x000000010000780cULL, 0x000fe40000705470ULL,
0x0000001f0c00780cULL, 0x000fe20003f84070ULL, 0x000000013b027824ULL, 0x000fc800078e0202ULL,
0x0000004002047824ULL, 0x040fe200078e00ffULL, 0x0000003d02027211ULL, 0x000fc800078ff0ffULL,
0x000000c004057812ULL, 0x000fe400078ec0ffULL, 0x000000ff03047207ULL, 0x000fc60004800000ULL,
0x0000010002077824ULL, 0x000fe200078e0205ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x0000002035027824ULL, 0x000fe200078e0232ULL, 0x000000010e0e7810ULL, 0x000fc80007ffe0ffULL,
0x000000030200780cULL, 0x000fda0003f04070ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000002700ULL, 0x000064000e007a10ULL, 0x040fe20007ffe0ffULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0x000000370e00720cULL, 0x000fe40003f06070ULL,
0x00018ac002397811ULL, 0x000fe200078e10ffULL, 0x0000000403037824ULL, 0x002fc800078e0202ULL,
0x0000000203037824ULL, 0x000fc800078e00ffULL, 0x0000640003007a24ULL, 0x000fc800078e0200ULL,
0x0000600000027625ULL, 0x000fca00078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002397faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000e000017945ULL, 0x000fe20003800000ULL, 0x000000c000004947ULL, 0x000fea0003800000ULL,
0x0000000a04007c10ULL, 0x000fe2000fffe0ffULL, 0x000000010c057824ULL, 0x100fe400078e0207ULL,
0x00000004ff027424ULL, 0x002fe400078e00ffULL, 0x0000680000037a24ULL, 0x000fe200078e0207ULL,
0x000000600500720cULL, 0x000fe40003f06070ULL, 0x00018a000c057811ULL, 0x040fe200078e10ffULL,
0x000000010c037824ULL, 0x000fc800078e0203ULL, 0x0000660003027625ULL, 0x000fcc00078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x018b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff6a00720cULL, 0x000fe20003f05270ULL,
0x018b8000ff647f8cULL, 0x000ea2000c80043fULL, 0x000007f000017945ULL, 0x000ff60003800000ULL,
0x000007d000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018ad800ff027f8cULL, 0x002e64000c800405ULL, 0x000000ffff0b7224ULL, 0x002fc400078e0003ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x018adc05ff007984ULL, 0x000e640008000800ULL,
0x8000000000ff7812ULL, 0x002fc4000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x018adc05ff007984ULL, 0x000e640008000800ULL, 0x8000000000ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001032007824ULL, 0x000fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011632ULL, 0x0000007000007812ULL, 0x000fe400078ec0ffULL,
0x0000000c02037812ULL, 0x000fca00078ec0ffULL, 0x0000000100007824ULL, 0x000fca00078e0203ULL,
0x0180000000037984ULL, 0x000e680000000800ULL, 0x0182000000027984ULL, 0x0006a20000000800ULL,
0x000000100300720bULL, 0x002fe20003f1d000ULL, 0x000258b27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000047806ULL, 0x008fc800000e0100ULL, 0x0000ffff04077812ULL, 0x000fe2000780c0ffULL,
0x0000045000027945ULL, 0x000fe20003800000ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fd200078e0010ULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x00000008ff007c0cULL, 0x000fe4000bf05270ULL, 0x000000100300720bULL, 0x000fe20003f34000ULL,
0x000258827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000047806ULL, 0x000fc400008e0100ULL,
0x0000000310057209ULL, 0x000fe20007810000ULL, 0x0000035000037945ULL, 0x000fe20003800000ULL,
0x0000991004067816ULL, 0x000fc600000000ffULL, 0x0184000500008388ULL, 0x0003e20000000800ULL,
0x000000ff0600720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000000510007221ULL, 0x002fe20000010000ULL, 0x000000ff04ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b00007820ULL, 0x000fc80000410000ULL,
0x00000000003b7308ULL, 0x000e640000000800ULL, 0x0000003b11117220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff007819ULL, 0x000fe20000011632ULL,
0x000257e27f007947ULL, 0x000fea000b800000ULL, 0x00001f003b007589ULL, 0x0002e400000e0000ULL,
0x0000000012127220ULL, 0x088fe40000410000ULL, 0x0000000013137220ULL, 0x080fe40000410000ULL,
0x0000000016167220ULL, 0x080fe40000410000ULL, 0x0000000017177220ULL, 0x080fe40000410000ULL,
0x000000001a1a7220ULL, 0x080fe40000410000ULL, 0x000000001b1b7220ULL, 0x000fc40000410000ULL,
0x000000001e1e7220ULL, 0x080fe40000410000ULL, 0x000000001f1f7220ULL, 0x080fe40000410000ULL,
0x0000000022227220ULL, 0x080fe40000410000ULL, 0x0000000023237220ULL, 0x080fe40000410000ULL,
0x0000000026267220ULL, 0x080fe40000410000ULL, 0x0000000027277220ULL, 0x000fc40000410000ULL,
0x000000002a2a7220ULL, 0x080fe40000410000ULL, 0x000000002b2b7220ULL, 0x080fe40000410000ULL,
0x000000002e2e7220ULL, 0x080fe40000410000ULL, 0x000000002f2f7220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0004ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000832007811ULL, 0x000fe200078ff0ffULL,
0x000257027f007947ULL, 0x000fea000b800000ULL, 0x00001f003b007589ULL, 0x00066400000e0000ULL,
0x0000000014147220ULL, 0x082fe40000410000ULL, 0x0000000015157220ULL, 0x080fe40000410000ULL,
0x0000000018187220ULL, 0x080fe40000410000ULL, 0x0000000019197220ULL, 0x080fe40000410000ULL,
0x000000001c1c7220ULL, 0x080fe40000410000ULL, 0x000000001d1d7220ULL, 0x000fc40000410000ULL,
0x0000000020207220ULL, 0x080fe40000410000ULL, 0x0000000021217220ULL, 0x080fe40000410000ULL,
0x0000000024247220ULL, 0x080fe40000410000ULL, 0x0000000025257220ULL, 0x080fe40000410000ULL,
0x0000000028287220ULL, 0x080fe40000410000ULL, 0x0000000029297220ULL, 0x000fc40000410000ULL,
0x000000002c2c7220ULL, 0x080fe40000410000ULL, 0x000000002d2d7220ULL, 0x080fe40000410000ULL,
0x0000000030307220ULL, 0x080fe40000410000ULL, 0x0000000031317220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff07ff7812ULL, 0x000fda0007806004ULL,
0x8000000503030221ULL, 0x000fe20000010000ULL, 0x00007610ff0b0816ULL, 0x000fc6000000000bULL,
0x3fb8aa3b03030820ULL, 0x000fc80000410000ULL, 0x00000003000a0308ULL, 0x000e640000000800ULL,
0x0000000a02020220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001102117221ULL, 0x004fe40000010000ULL, 0x000000ffff107224ULL, 0x000fc400078e0005ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff0bff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000017945ULL, 0x000fd80003800000ULL, 0x0000016000001947ULL, 0x000fea0003800000ULL,
0x0000000aff00723eULL, 0x000fe400000010ffULL, 0x00000002ff037819ULL, 0x002fe40000011632ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x000255527f007947ULL, 0x000fea000b800000ULL,
0x00001f0300097589ULL, 0x0002e400000e0000ULL, 0x0000000803087810ULL, 0x000fe20007ffe0ffULL,
0x000255a27f007947ULL, 0x000fea000b800000ULL, 0x00001f0800087589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010033f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0000ULL, 0x00003ab000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0002683000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000018033f7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3e7224ULL, 0x004fe200078e0000ULL,
0x00003b2000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff407424ULL, 0x000fc400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000267c000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000832037812ULL, 0x002fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff077819ULL, 0x100fe20000011632ULL,
0x0000000208047891ULL, 0x000fe2000f8e103fULL, 0x00000007035c7812ULL, 0x000fe200078ef832ULL,
0x0000205000017945ULL, 0x000fe40003800000ULL, 0x00000004355f7824ULL, 0x000fe200078e0207ULL,
0x000000105c387812ULL, 0x040fe200078efcffULL, 0x000000105c037824ULL, 0x040fe200078e00ffULL,
0x00000004075d7c10ULL, 0x000fe2000fffe0ffULL, 0x000000015c007824ULL, 0x000fe200078e025fULL,
0x0000000438637c10ULL, 0x000fe2000fffe007ULL, 0x000000015f647824ULL, 0x004fc600078e0238ULL,
0xfffffff003007812ULL, 0x000fc800078ee200ULL, 0x0001400000067811ULL, 0x000fe200078e20ffULL,
0x000000015c007824ULL, 0x000fc800078e025dULL, 0x00000000063c783bULL, 0x000e620000004200ULL,
0xfffffff003007812ULL, 0x000fe200078ee200ULL, 0x0000001038037824ULL, 0x040fe400078e00ffULL,
0x0000001038387824ULL, 0x000fe200078e00ffULL, 0x0001400000057811ULL, 0x000fe400078e20ffULL,
0xfffffff003647812ULL, 0x000fe400078ee264ULL, 0xfffffff038637812ULL, 0x000fe200078ee263ULL,
0x000000000540783bULL, 0x000ea20000004200ULL, 0x0001400064047811ULL, 0x000fc400078e20ffULL,
0x0001400063037811ULL, 0x000fc600078e20ffULL, 0x000000000444783bULL, 0x000f280000004200ULL,
0x000000000338783bULL, 0x008ee20000004200ULL, 0x00000018ff027819ULL, 0x002fe2000001143cULL,
0x0000003c00837306ULL, 0x000fe20000009400ULL, 0x00000018ff4a7819ULL, 0x000fe2000001143fULL,
0x000001003d4b7824ULL, 0x040fe200078e00ffULL, 0x00000018ff007819ULL, 0x000fe2000001143dULL,
0x000100003d4c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000000200ac7306ULL, 0x000fe20000209400ULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000010040817824ULL, 0x004fca00078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011481ULL,
0x0000000200b77306ULL, 0x000e620000205400ULL, 0x00000018ff537819ULL, 0x010fe40000011444ULL,
0x00000018ff827819ULL, 0x008fe40000011439ULL, 0x00000018ff617819ULL, 0x000fe40000011446ULL,
0x00000018ff757819ULL, 0x000fe20000011438ULL, 0x0000004a00a87306ULL, 0x000fe20000209400ULL,
0x00000018ff857819ULL, 0x000fc4000001143bULL, 0x00000018ff5e7819ULL, 0x000fe40000011445ULL,
0x00000018ff737819ULL, 0x000fe40000011447ULL, 0x00000018ff847819ULL, 0x000fe2000001143aULL,
0x0000004a00b37306ULL, 0x000fe20000205400ULL, 0x000000b7ac00720bULL, 0x002fe20003f5d000ULL,
0x0000010047ac7824ULL, 0x000fca00078e00ffULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x0000004a005a7306ULL, 0x0003f0000020d400ULL, 0x0000003c00b47306ULL, 0x000ea20000005400ULL,
0x000001003c4a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000003c00a47306ULL, 0x0002f0000000d400ULL, 0x0000004a00b87306ULL, 0x000fe20000209400ULL,
0x000100003c3c7824ULL, 0x002fe200078e00ffULL, 0x000000b48300720bULL, 0x004fc80003f7d000ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000004a00bf7306ULL, 0x000e6e0000205400ULL,
0x00000001a4a43812ULL, 0x008fe200078efcffULL, 0x00000002009c7306ULL, 0x0004f0000020d400ULL,
0x0000000000bb7306ULL, 0x000fe20000209400ULL, 0x00000018ff027819ULL, 0x004fc4000001143eULL,
0x000000bfb800720bULL, 0x002fca0003fdd000ULL, 0x0000000000b27306ULL, 0x000e620000205400ULL,
0x000000019c9c2812ULL, 0x008fce00078efcffULL, 0x0000003c00ba7306ULL, 0x000ff00000209400ULL,
0x0000003c00c17306ULL, 0x000ea20000205400ULL, 0x000000b2bb00720bULL, 0x002fce0003f5d000ULL,
0x0000004a00a57306ULL, 0x0002f0000020d400ULL, 0x0000004b00c37306ULL, 0x000fe20000209400ULL,
0x000001003e4a7824ULL, 0x002fe200078e00ffULL, 0x000000c1ba00720bULL, 0x004fc80003f1d000ULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000004b00bc7306ULL, 0x000e620000205400ULL,
0x00000001a5a56812ULL, 0x008fce00078efcffULL, 0x0000000000987306ULL, 0x000eb0000020d400ULL,
0x0000000200b07306ULL, 0x000fe20000209400ULL, 0x000000bcc300720bULL, 0x002fce0003fdd000ULL,
0x0000000200b97306ULL, 0x000e620000205400ULL, 0x0000000198982812ULL, 0x004fce00078efcffULL,
0x0000003d00b57306ULL, 0x000ff00000009400ULL, 0x0000003d008a7306ULL, 0x000ea20000005400ULL,
0x000000b9b000720bULL, 0x002fce0003f5d000ULL, 0x0000003c009d7306ULL, 0x0002f0000020d400ULL,
0x0000004c00c77306ULL, 0x000fe20000209400ULL, 0x000001003f3c7824ULL, 0x002fe200078e00ffULL,
0x0000008ab500720bULL, 0x004fc80003f7d000ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004c00c07306ULL, 0x000e620000205400ULL, 0x000000019d9d0812ULL, 0x008fce00078efcffULL,
0x0000003d009e7306ULL, 0x000eb0000000d400ULL, 0x0000004b003d7306ULL, 0x000722000020d400ULL,
0x000000c0c700720bULL, 0x002fce0003f1d000ULL, 0x0000003e00947306ULL, 0x000fe20000009400ULL,
0x000000019e9e3812ULL, 0x004fe400078efcffULL, 0x00000018ff4b7819ULL, 0x008fca0000011442ULL,
0x0000003e00af7306ULL, 0x000e620000005400ULL, 0x000000013d3d6812ULL, 0x010fc800078efcffULL,
0x0000009e3d3d723eULL, 0x000fc600000010ffULL, 0x0000003e00587306ULL, 0x0004f0000000d400ULL,
0x0000004a00c97306ULL, 0x000fe20000209400ULL, 0x000100003e3e7824ULL, 0x004fe200078e00ffULL,
0x000000af9400720bULL, 0x002fc80003f7d000ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000004a00c27306ULL, 0x000e6e0000205400ULL, 0x0000000158583812ULL, 0x008fe200078efcffULL,
0x00000002005b7306ULL, 0x000eb0000020d400ULL, 0x0000004c009b7306ULL, 0x000ee2000020d400ULL,
0x000000c2c900720bULL, 0x002fce0003fdd000ULL, 0x0000003e00c47306ULL, 0x000fe20000209400ULL,
0x000000015b5b2812ULL, 0x004fe400078efcffULL, 0x000000b3a800720bULL, 0x000fca0003f5d000ULL,
0x0000003e00cb7306ULL, 0x000e620000205400ULL, 0x000000019b9b0812ULL, 0x008fce00078efcffULL,
0x0000004a00997306ULL, 0x0004e2000020d400ULL, 0x000000015a5a2812ULL, 0x000fce00078efcffULL,
0x0000003f00937306ULL, 0x000fe20000009400ULL, 0x00000018ff4a7819ULL, 0x004fe40000011440ULL,
0x000000cbc400720bULL, 0x002fca0003f1d000ULL, 0x0000003f00567306ULL, 0x000e620000005400ULL,
0x0000000199996812ULL, 0x008fc800078efcffULL, 0x000000589958723eULL, 0x000fc600000010ffULL,
0x0000003f00597306ULL, 0x0004f0000000d400ULL, 0x0000003c00cd7306ULL, 0x000fe20000209400ULL,
0x000100003f3f7824ULL, 0x004fe200078e00ffULL, 0x000000569300720bULL, 0x002fc80003f7d000ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000003c00c67306ULL, 0x000e6e0000205400ULL,
0x0000000159593812ULL, 0x008fe200078efcffULL, 0x0000004a00ca7306ULL, 0x000ff00000209400ULL,
0x0000004a00d17306ULL, 0x000ea20000205400ULL, 0x000000c6cd00720bULL, 0x002fce0003fdd000ULL,
0x0000003e00967306ULL, 0x0002f0000020d400ULL, 0x0000003f00d37306ULL, 0x000fe20000209400ULL,
0x00000018ff3e7819ULL, 0x002fe40000011441ULL, 0x000000d1ca00720bULL, 0x004fca0003f5d000ULL,
0x0000003f00cc7306ULL, 0x000e620000205400ULL, 0x0000000196960812ULL, 0x008fce00078efcffULL,
0x0000003c009a7306ULL, 0x000eb0000020d400ULL, 0x00000040006c7306ULL, 0x000fe20000009400ULL,
0x000000ccd300720bULL, 0x002fce0003f1d000ULL, 0x0000004000b17306ULL, 0x000e620000005400ULL,
0x000000019a9a6812ULL, 0x004fc800078efcffULL, 0x000000599a59723eULL, 0x000fc600000010ffULL,
0x0000004000487306ULL, 0x0004f0000000d400ULL, 0x0000008100d57306ULL, 0x000fe20000209400ULL,
0x0001000040407824ULL, 0x004fe200078e00ffULL, 0x000000b16c00720bULL, 0x002fe20003f7d000ULL,
0x00000100386c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000008100ce7306ULL, 0x000e6e0000205400ULL, 0x0000000148483812ULL, 0x008fe200078efcffULL,
0x0000004a004c7306ULL, 0x000eb0000020d400ULL, 0x0000003e00c87306ULL, 0x000fe20000209400ULL,
0x000000ced500720bULL, 0x002fce0003fdd000ULL, 0x0000003e00cf7306ULL, 0x000e620000205400ULL,
0x000000014c4c2812ULL, 0x004fce00078efcffULL, 0x00000082007e7306ULL, 0x000ff00000209400ULL,
0x00000082007f7306ULL, 0x000fe20000205400ULL, 0x000000cfc800720bULL, 0x002fce0003f5d000ULL,
0x0000008200697306ULL, 0x0003f0000020d400ULL, 0x0000003f00977306ULL, 0x0004e2000020d400ULL,
0x0000010041827824ULL, 0x002fca00078e00ffULL, 0x00000018ff827819ULL, 0x000fe40000011482ULL,
0x0000004000d97306ULL, 0x000fe20000209400ULL, 0x00000018ff3f7819ULL, 0x004fce0000011443ULL,
0x0000004000d07306ULL, 0x000e620000205400ULL, 0x0000000197970812ULL, 0x008fce00078efcffULL,
0x0000008100957306ULL, 0x0004f0000020d400ULL, 0x0000004100677306ULL, 0x000fe20000009400ULL,
0x000000d0d900720bULL, 0x002fe20003f1d000ULL, 0x0000010042817824ULL, 0x004fca00078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000004100547306ULL, 0x000e620000005400ULL,
0x0000000195956812ULL, 0x008fc800078efcffULL, 0x000000489548723eULL, 0x000fc600000010ffULL,
0x0000004100497306ULL, 0x0004f0000000d400ULL, 0x0000008200db7306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x004fe200078e00ffULL, 0x000000546700720bULL, 0x002fc40003f7d000ULL,
0x0000000732677812ULL, 0x000fe400078ec0ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000008200d47306ULL, 0x000e6e0000205400ULL, 0x0000000149493812ULL, 0x008fe200078efcffULL,
0x0000003e004d7306ULL, 0x000eb0000020d400ULL, 0x0000004b00be7306ULL, 0x000fe20000209400ULL,
0x000000d4db00720bULL, 0x002fce0003fdd000ULL, 0x0000004b00c57306ULL, 0x000e620000205400ULL,
0x000000014d4d2812ULL, 0x004fce00078efcffULL, 0x00000040008f7306ULL, 0x0004f0000020d400ULL,
0x0000004300007306ULL, 0x000fe20000009400ULL, 0x0000010043407824ULL, 0x004fe200078e00ffULL,
0x000000c5be00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000004300557306ULL, 0x000fe20000005400ULL, 0x000000018f8f0812ULL, 0x008fc800078efcffULL,
0x0000008f4c4c723eULL, 0x000fc600000010ffULL, 0x0000004300517306ULL, 0x0003f0000000d400ULL,
0x0000004100e37306ULL, 0x000fe20000209400ULL, 0x0001000043437824ULL, 0x002fca00078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000004100da7306ULL, 0x000e700000205400ULL,
0x0000008200927306ULL, 0x000eb0000020d400ULL, 0x0000004200577306ULL, 0x000fe20000009400ULL,
0x000000dae300720bULL, 0x002fce0003f1d000ULL, 0x0000004200027306ULL, 0x000e620000005400ULL,
0x0000000192926812ULL, 0x004fc800078efcffULL, 0x000000499249723eULL, 0x000fc600000010ffULL,
0x0000004200887306ULL, 0x0004f0000000d400ULL, 0x0000004b00527306ULL, 0x000f22000020d400ULL,
0x0001000042427824ULL, 0x004fe200078e00ffULL, 0x000000025700720bULL, 0x002fc80003fdd000ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x0000004300d77306ULL, 0x000fee0000209400ULL,
0x0000000188886812ULL, 0x008fe200078efcffULL, 0x0000004300d27306ULL, 0x000e620000205400ULL,
0x0000000152522812ULL, 0x010fc400078efcffULL, 0x000000550000720bULL, 0x000fe20003fdd000ULL,
0x0000010039007824ULL, 0x000fc800078e00ffULL, 0x00000041008e7306ULL, 0x0004f0000020d400ULL,
0x0000004400a27306ULL, 0x000fe20000009400ULL, 0x0000010044417824ULL, 0x004fe200078e00ffULL,
0x000000d2d700720bULL, 0x002fc40003f5d000ULL, 0x0000000151516812ULL, 0x000fe400078efcffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000044009f7306ULL, 0x000e620000005400ULL,
0x000000018e8e0812ULL, 0x008fc800078efcffULL, 0x0000008e4d4d723eULL, 0x000fc600000010ffULL,
0x00000044007b7306ULL, 0x0004f0000000d400ULL, 0x0000008100dc7306ULL, 0x000fe20000209400ULL,
0x0001000044447824ULL, 0x004fe200078e00ffULL, 0x0000009fa200720bULL, 0x002fcc0003fdd000ULL,
0x0000008100e17306ULL, 0x000e6e0000205400ULL, 0x000000017b7b6812ULL, 0x008fe200078efcffULL,
0x0000004200e57306ULL, 0x000ff00000209400ULL, 0x0000004200de7306ULL, 0x000ea20000205400ULL,
0x000000e1dc00720bULL, 0x002fce0003f7d000ULL, 0x0000004000df7306ULL, 0x000ff00000209400ULL,
0x0000004000d87306ULL, 0x000fe20000205400ULL, 0x000000dee500720bULL, 0x004fce0003f1d000ULL,
0x00000040008c7306ULL, 0x0003f0000020d400ULL, 0x0000003f00b67306ULL, 0x000fe20000209400ULL,
0x00000018ff407819ULL, 0x002fce0000011444ULL, 0x0000003f00bd7306ULL, 0x000ff00000205400ULL,
0x0000003f00807306ULL, 0x000ff0000020d400ULL, 0x0000005300aa7306ULL, 0x000ff00000209400ULL,
0x0000005300a97306ULL, 0x000ff00000205400ULL, 0x00000053007d7306ULL, 0x000ff0000020d400ULL,
0x00000061003e7306ULL, 0x000ff00000209400ULL, 0x00000061003f7306ULL, 0x000ff00000205400ULL,
0x0000006100797306ULL, 0x000ff0000020d400ULL, 0x0000007500537306ULL, 0x000ff00000209400ULL,
0x0000007500867306ULL, 0x000ff00000205400ULL, 0x00000075006d7306ULL, 0x000ff0000020d400ULL,
0x0000008500747306ULL, 0x000ff00000209400ULL, 0x0000008500757306ULL, 0x000ff00000205400ULL,
0x0000008500617306ULL, 0x000ff0000020d400ULL, 0x0000004300857306ULL, 0x000e70000020d400ULL,
0x0000004000ad7306ULL, 0x000ff00000209400ULL, 0x0000004000447306ULL, 0x000ea20000205400ULL,
0x0000000185852812ULL, 0x002fce00078efcffULL, 0x00000081008d7306ULL, 0x000e70000020d400ULL,
0x00000042008b7306ULL, 0x000722000020d400ULL, 0x00000044ad00720bULL, 0x004fe20003f5d000ULL,
0x000100003bad7824ULL, 0x000fca00078e00ffULL, 0x00000018ffad7819ULL, 0x000fe200000114adULL,
0x0000004500a07306ULL, 0x000fe20000009400ULL, 0x0000010045427824ULL, 0x008fe200078e00ffULL,
0x000000018d8d3812ULL, 0x002fe400078efcffULL, 0x000000d8df00720bULL, 0x000fe40003f7d000ULL,
0x00000018ff437819ULL, 0x000fe40000011442ULL, 0x0000004500a37306ULL, 0x000e620000005400ULL,
0x000000018b8b0812ULL, 0x010fc400078efcffULL, 0x000000bdb600720bULL, 0x000fe40003f1d000ULL,
0x00000018ffb67819ULL, 0x000fc60000011400ULL, 0x00000045007c7306ULL, 0x0005e2000000d400ULL,
0x000000018c8c3812ULL, 0x000fc800078efcffULL, 0x000000518c51723eULL, 0x000fc600000010ffULL,
0x0000004000827306ULL, 0x000ee2000020d400ULL, 0x0001000045457824ULL, 0x004fe200078e00ffULL,
0x0000000180800812ULL, 0x000fe400078efcffULL, 0x000000a9aa00720bULL, 0x000fe20003f1d000ULL,
0x000001003aa97824ULL, 0x040fe200078e00ffULL, 0x00000018ffe07819ULL, 0x000fe20000011445ULL,
0x000100003aaa7824ULL, 0x000fe200078e00ffULL, 0x0000005e003c7306ULL, 0x000fe20000209400ULL,
0x000000a3a000720bULL, 0x002fe40003fdd000ULL, 0x00000018ffa97819ULL, 0x000fc400000114a9ULL,
0x00000018ffaa7819ULL, 0x000fc600000114aaULL, 0x000000e000457306ULL, 0x000fe20000209400ULL,
0x0000000182822812ULL, 0x008fe400078efcffULL, 0x000000017d7d0812ULL, 0x000fc600078efcffULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x000000e000427306ULL, 0x000e620000205400ULL,
0x0000003f3e00720bULL, 0x000fce0003fdd000ULL, 0x0000005e00a77306ULL, 0x000fec0000205400ULL,
0x0000000179796812ULL, 0x000fe400078efcffULL, 0x0000005e007a7306ULL, 0x000fe2000020d400ULL,
0x000000424500720bULL, 0x002fe40003f5d000ULL, 0x000000975a45723eULL, 0x000fca00000010ffULL,
0x00000073004a7306ULL, 0x000ff00000209400ULL, 0x00000073004b7306ULL, 0x000e700000205400ULL,
0x0000007300717306ULL, 0x000eb0000020d400ULL, 0x0000008400727306ULL, 0x000fe20000209400ULL,
0x0000004b4a00720bULL, 0x002fce0003fdd000ULL, 0x0000008400737306ULL, 0x000fec0000205400ULL,
0x0000000171716812ULL, 0x004fe400078efcffULL, 0x00000084005e7306ULL, 0x000fe2000020d400ULL,
0x000000865300720bULL, 0x000fce0003fdd000ULL, 0x0000004100d67306ULL, 0x000fec0000209400ULL,
0x000000016d6d6812ULL, 0x000fe400078efcffULL, 0x0000004100dd7306ULL, 0x000e700000205400ULL,
0x0000004100847306ULL, 0x0004f0000020d400ULL, 0x000000e000817306ULL, 0x000f22000020d400ULL,
0x0000010046417824ULL, 0x004fe200078e00ffULL, 0x000000ddd600720bULL, 0x002fc80003f7d000ULL,
0x00000018ffe27819ULL, 0x000fe40000011441ULL, 0x000000ac00af7306ULL, 0x000fee0000209400ULL,
0x0000000184843812ULL, 0x008fe200078efcffULL, 0x000000e200407306ULL, 0x000fe20000209400ULL,
0x0000000181812812ULL, 0x010fc400078efcffULL, 0x0000007b8484723eULL, 0x000fca00000010ffULL,
0x000000e200417306ULL, 0x000e700000205400ULL, 0x000000ac00b07306ULL, 0x000ff00000205400ULL,
0x000000ac00937306ULL, 0x0005e2000020d400ULL, 0x000000414000720bULL, 0x002fce0003f5d000ULL,
0x0000004300ab7306ULL, 0x000fe20000209400ULL, 0x00000018ffac7819ULL, 0x004fe4000001146cULL,
0x00000008676c7812ULL, 0x000fca00078ef832ULL, 0x0000004300ae7306ULL, 0x000e620000205400ULL,
0x0000000107677824ULL, 0x000fe400078e026cULL, 0x000000086c027824ULL, 0x040fe400078e00ffULL,
0x000000086cb77824ULL, 0x000fe200078e00ffULL, 0x0000000267007810ULL, 0x000fe40007ffe0ffULL,
0x0000004600a67306ULL, 0x000fe20000009400ULL, 0xfffffff802027812ULL, 0x000fe400078ee267ULL,
0xfffffff8b7007812ULL, 0x000fc400078ee200ULL, 0x0001200002547811ULL, 0x000fe400078e20ffULL,
0x0001200000407811ULL, 0x000fe200078e20ffULL, 0x0000004600a17306ULL, 0x000ea20000005400ULL,
0x000000aeab00720bULL, 0x002fe20003f7d000ULL, 0x000001003bab7824ULL, 0x000fca00078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x0000004700917306ULL, 0x000ff00000009400ULL,
0x0000004700907306ULL, 0x000fe20000005400ULL, 0x000000a1a600720bULL, 0x004fce0003f1d000ULL,
0x00000047006e7306ULL, 0x0003f0000000d400ULL, 0x000000e200837306ULL, 0x000ea2000020d400ULL,
0x0001000047477824ULL, 0x002fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe40000011447ULL,
0x0000004600767306ULL, 0x0002f0000000d400ULL, 0x0000004300877306ULL, 0x000f22000020d400ULL,
0x0001000046467824ULL, 0x002fe200078e00ffULL, 0x0000000183832812ULL, 0x004fc400078efcffULL,
0x000000b0af00720bULL, 0x000fe40003f5d000ULL, 0x00000018ffb47819ULL, 0x000fe40000011446ULL,
0x0000005600477306ULL, 0x000fe20000209400ULL, 0x0000000176760812ULL, 0x008fe400078efcffULL,
0x000000909100720bULL, 0x000fe40003f1d000ULL, 0x000000768376723eULL, 0x000fc600000010ffULL,
0x0000005600b27306ULL, 0x000fe20000205400ULL, 0x0000000187873812ULL, 0x010fe400078efcffULL,
0x000000a73c00720bULL, 0x000fe40003f7d000ULL, 0x0000000193932812ULL, 0x000fe400078efcffULL,
0x000000a4a53c723eULL, 0x000fe200000010ffULL, 0x0000005600947306ULL, 0x0003e2000020d400ULL,
0x000000016e6e0812ULL, 0x000fce00078efcffULL, 0x000000b400437306ULL, 0x000fe20000209400ULL,
0x000000005454783bULL, 0x002e620000000200ULL, 0x000000017a7a3812ULL, 0x000fc800078efcffULL,
0x000000817a81723eULL, 0x000fe400000010ffULL, 0x000000b400467306ULL, 0x000eb00000205400ULL,
0x000000b4008a7306ULL, 0x000ef0000020d400ULL, 0x000000ac00b17306ULL, 0x000fe20000209400ULL,
0x000000464300720bULL, 0x004fc40003f7d000ULL, 0x000000004040783bULL, 0x000eaa0000000200ULL,
0x000000ac00b47306ULL, 0x000f2c0000205400ULL, 0x000000018a8a3812ULL, 0x008fc400078efcffULL,
0x00000038004f7306ULL, 0x000fe20000009400ULL, 0x000000b24700720bULL, 0x000fe20003f7d000ULL,
0x0000000954549231ULL, 0x082fe400003400ffULL, 0x0000000956569231ULL, 0x000fe400003400ffULL,
0x0000000855559231ULL, 0x080fe400003400ffULL, 0x0000003800507306ULL, 0x000e620000005400ULL,
0x000000b4b100720bULL, 0x010fe20003f5d000ULL, 0x0000000857579231ULL, 0x000fc800003400ffULL,
0x0000000194943812ULL, 0x000fe400078efcffULL, 0x00000038006b7306ULL, 0x000722000000d400ULL,
0x0000003c543c723cULL, 0x000f6200000418ffULL, 0x000000947171723eULL, 0x000fcc00000010ffULL,
0x000000ac00a87306ULL, 0x000f22000020d400ULL, 0x0001000038387824ULL, 0x008fe200078e00ffULL,
0x000000504f00720bULL, 0x002fe20003f1d000ULL, 0x0000000940409231ULL, 0x084fe200003400ffULL,
0x000000888d50723eULL, 0x000fe200000010ffULL, 0x0000000942429231ULL, 0x000fe200003400ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000000841419231ULL, 0x080fe200003400ffULL,
0x0000003900897306ULL, 0x000fe20000009400ULL, 0x0000008b5288723eULL, 0x000fe200000010ffULL,
0x0000000843439231ULL, 0x000fe200003400ffULL, 0x000000485448723cULL, 0x000f6800000418ffULL,
0x000000016b6b0812ULL, 0x010fe200078efcffULL, 0x00000039004e7306ULL, 0x000e620000005400ULL,
0x00000001a8a82812ULL, 0x000fc400078efcffULL, 0x000000505450723cULL, 0x000fe400000418ffULL,
0x0000006ba89e723eULL, 0x000fc600000010ffULL, 0x0000003900687306ULL, 0x0004f0000000d400ULL,
0x0000003800b37306ULL, 0x000fe20000209400ULL, 0x0001000039397824ULL, 0x004fe200078e00ffULL,
0x0000004e8900720bULL, 0x002fc40003f7d000ULL, 0x000000858089723eULL, 0x000fe200000010ffULL,
0x0000004c544c723cULL, 0x000f6200000418ffULL, 0x00000018ff447819ULL, 0x000fe40000011439ULL,
0x0000003800b87306ULL, 0x000e620000205400ULL, 0x0000009b9839723eULL, 0x000fe400000010ffULL,
0x0000007c8785723eULL, 0x000fe400000010ffULL, 0x000000827d80723eULL, 0x000fe400000010ffULL,
0x0000000168683812ULL, 0x008fe200078efcffULL, 0x000000b600b57306ULL, 0x000fe40000209400ULL,
0x00000084403c723cULL, 0x020fec000004183cULL, 0x000000b600a27306ULL, 0x000ea20000205400ULL,
0x000000b8b300720bULL, 0x002fce0003f5d000ULL, 0x0000004400a07306ULL, 0x000ff00000209400ULL,
0x0000004400a17306ULL, 0x000e620000205400ULL, 0x000000a2b500720bULL, 0x004fce0003f1d000ULL,
0x0000003800ac7306ULL, 0x0004f0000020d400ULL, 0x000000b6009f7306ULL, 0x000f22000020d400ULL,
0x0000009d9c38723eULL, 0x004fe400000010ffULL, 0x000000a1a000720bULL, 0x002fca0003fdd000ULL,
0x000000a900987306ULL, 0x000fe20000209400ULL, 0x00000001acac2812ULL, 0x008fe400078efcffULL,
0x0000007f7e00720bULL, 0x000fca0003f5d000ULL, 0x000000a900977306ULL, 0x000e620000205400ULL,
0x000000019f9f0812ULL, 0x010fc800078efcffULL, 0x000000689f9f723eULL, 0x000fe400000010ffULL,
0x000000ac6d68723eULL, 0x000fe200000010ffULL, 0x00000044009c7306ULL, 0x0004e2000020d400ULL,
0x0000000169692812ULL, 0x000fc600078efcffULL, 0x0000009e4048723cULL, 0x000fe80000041848ULL,
0x000000ab008f7306ULL, 0x000fe20000209400ULL, 0x000000965b44723eULL, 0x004fe400000010ffULL,
0x000000979800720bULL, 0x002fe20003f1d000ULL, 0x000000585458723cULL, 0x000fe800000418ffULL,
0x000000ab008e7306ULL, 0x000e620000205400ULL, 0x000000019c9c6812ULL, 0x008fc600078efcffULL,
0x000000445444723cULL, 0x000f6200000418ffULL, 0x0000009c6969723eULL, 0x000fc600000010ffULL,
0x0000003b006f7306ULL, 0x000fe80000009400ULL, 0x00000068404c723cULL, 0x000fe8000004184cULL,
0x0000003b00707306ULL, 0x000ea20000005400ULL, 0x0000008e8f00720bULL, 0x002fce0003fdd000ULL,
0x000000a900917306ULL, 0x000e70000020d400ULL, 0x0000003a00777306ULL, 0x000fe20000009400ULL,
0x000000706f00720bULL, 0x004fe40003f5d000ULL, 0x0000008a7970723eULL, 0x000fca00000010ffULL,
0x0000003a00787306ULL, 0x000ea20000005400ULL, 0x0000000191910812ULL, 0x002fe200078efcffULL,
0x000000704044723cULL, 0x020be20000041844ULL, 0x000000737200720bULL, 0x000fca0003f1d000ULL,
0x000000ab008b7306ULL, 0x000e70000020d400ULL, 0x000000aa007b7306ULL, 0x000fe20000209400ULL,
0x000000787700720bULL, 0x004fe40003f7d000ULL, 0x0000006e9377723eULL, 0x000fc400000010ffULL,
0x000000015e5e0812ULL, 0x000fe400078efcffULL, 0x0000000f3400720cULL, 0x000fe20003f03070ULL,
0x000000aa007c7306ULL, 0x000ea20000205400ULL, 0x000000018b8b6812ULL, 0x002fe200078efcffULL,
0x000000764058723cULL, 0x000fec0000041858ULL, 0x0000003b00667306ULL, 0x000e70000000d400ULL,
0x000000ad007a7306ULL, 0x000fe20000209400ULL, 0x0000007c7b00720bULL, 0x004fce0003fdd000ULL,
0x000000ad007d7306ULL, 0x000ea20000205400ULL, 0x0000000166662812ULL, 0x002fc800078efcffULL,
0x000000668b6f723eULL, 0x000fc600000010ffULL, 0x0000003a00627306ULL, 0x0002f0000000d400ULL,
0x000000aa00737306ULL, 0x000f22000020d400ULL, 0x0000007d7a00720bULL, 0x004fe20003f5d000ULL,
0x000000385438723cULL, 0x042f6c00000418ffULL, 0x000000ad00707306ULL, 0x020e62000020d400ULL,
0x0000000162623812ULL, 0x008fe200078efcffULL, 0x000000885454723cULL, 0x000f6200000418ffULL,
0x000000757400720bULL, 0x000fc40003f7d000ULL, 0x00000062916e723eULL, 0x000fe400000010ffULL,
0x00000002ff627819ULL, 0x000fe40000011632ULL, 0x0000000173736812ULL, 0x010fe400078efcffULL,
0x0000000f3400720cULL, 0x000fe20003fc3070ULL, 0x0000006e4050723cULL, 0x000b620000041850ULL,
0x000000735e68723eULL, 0x000fe400000010ffULL, 0x000000016a5e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000170702812ULL, 0x002fe400078efcffULL, 0x0000006a6200720cULL, 0x040fe20003f46070ULL,
0x000000804038723cULL, 0x000b620000041838ULL, 0x0000000161613812ULL, 0x000fe400078efcffULL,
0x0000005e6200720cULL, 0x040fe40005746470ULL, 0x000000706169723eULL, 0x000fe400000010ffULL,
0x0000000862617810ULL, 0x000fc80007ffe0ffULL, 0x0000006a6100720cULL, 0x040fe20003f66070ULL,
0x000000684054723cULL, 0x020b660000041854ULL, 0x0000005e6100720cULL, 0x000fe20005f66470ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000003c12127221ULL, 0x020fe40000010000ULL,
0x0000003d13137221ULL, 0x000fe40000010000ULL, 0x0000003816167221ULL, 0x000fe40000010000ULL,
0x0000003917177221ULL, 0x000fc40000010000ULL, 0x000000581a1a7221ULL, 0x000fe40000010000ULL,
0x000000591b1b7221ULL, 0x000fe40000010000ULL, 0x000000441e1e7221ULL, 0x000fe40000010000ULL,
0x000000451f1f7221ULL, 0x000fe40000010000ULL, 0x0000004822227221ULL, 0x000fe40000010000ULL,
0x0000004923237221ULL, 0x000fc40000010000ULL, 0x0000004c26267221ULL, 0x000fe40000010000ULL,
0x0000004d27277221ULL, 0x000fe40000010000ULL, 0x000000502a2a7221ULL, 0x000fe40000010000ULL,
0x000000512b2b7221ULL, 0x000fe40000010000ULL, 0x000000542e2e7221ULL, 0x000fe40000010000ULL,
0x000000552f2f7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x020fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0000000000ULL,
0x0000003e14147221ULL, 0x000fe40000010000ULL, 0x0000003f15157221ULL, 0x000fc40000010000ULL,
0x0000003a18187221ULL, 0x000fe40000010000ULL, 0x0000003b19197221ULL, 0x000fe40000010000ULL,
0x0000005a1c1c7221ULL, 0x000fe40000010000ULL, 0x0000005b1d1d7221ULL, 0x000fe40000010000ULL,
0x0000004620207221ULL, 0x000fe40000010000ULL, 0x0000004721217221ULL, 0x000fc40000010000ULL,
0x0000004a24247221ULL, 0x000fe40000010000ULL, 0x0000004b25257221ULL, 0x000fe40000010000ULL,
0x0000004e28287221ULL, 0x000fe40000010000ULL, 0x0000004f29297221ULL, 0x000fe40000010000ULL,
0x000000522c2c7221ULL, 0x000fe40000010000ULL, 0x000000532d2d7221ULL, 0x000fc40000010000ULL,
0x0000005630307221ULL, 0x000fe40000010000ULL, 0x0000005731317221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff387f8cULL, 0x000e62000c80043fULL, 0x00000002ff3b7819ULL, 0x000fe2000001165eULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000f3400720cULL, 0x0c0fe40003f03070ULL,
0x0000000f3400720cULL, 0x000fe40003fc3070ULL, 0x00000001ff8c7803ULL, 0x000fe40000000000ULL,
0x000000035e387812ULL, 0x042fe200078ec0ffULL, 0x000000ffff3f7224ULL, 0x000fe200078e0039ULL,
0x0000003b5e5e7207ULL, 0x000fc40002800000ULL, 0x000000ff38407207ULL, 0x000fe40006800000ULL,
0x000000035e437812ULL, 0x040fe400078ec0ffULL, 0x0000000f5e457211ULL, 0x000fc400078ff0ffULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b8400ff3a7984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe20007804865ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8400ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804865ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x018b8c00ff3a7984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x800000003aff7812ULL, 0x002fe2000780483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000145397810ULL, 0x040fe20007ffe0ffULL,
0x0000000445387824ULL, 0x000fe200078e0243ULL, 0x0000097000017945ULL, 0x000fe40003800000ULL,
0x000000363900720cULL, 0x000fe20003f06070ULL, 0x00000040383d7824ULL, 0x000fca00078e00ffULL,
0x0000004033427812ULL, 0x000fce00078ef83dULL, 0x000004f000008947ULL, 0x000fea0003800000ULL,
0x0000000507417c10ULL, 0x040fe2000fffe0ffULL, 0x00000100ff477424ULL, 0x000fe200078e00ffULL,
0x00000002074d7810ULL, 0x000fe20007ffe0ffULL, 0x00000010323a7824ULL, 0x000fe400078e00ffULL,
0x018a0000413c7984ULL, 0x000e620000004800ULL, 0x0000000141387824ULL, 0x000fe200078e0242ULL,
0x000000054d4f7c10ULL, 0x000fe4000fffe0ffULL, 0x000000f03a497812ULL, 0x000fe200078ec0ffULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc400078e0238ULL,
0x00000010413c7824ULL, 0x000fe400078e00ffULL, 0x00005e0038387625ULL, 0x000fca00078e0047ULL,
0x00000049383a7210ULL, 0x000fe40007f1e0ffULL, 0x0000003d60387217ULL, 0x000fc60007800000ULL,
0x000000ffff3b7224ULL, 0x000fe400000e0639ULL, 0x0000000138387824ULL, 0x000fe400078e0a3dULL,
0x0000000141397824ULL, 0x000fc600078e0232ULL, 0x0000000538387c17ULL, 0x000fe4000f800000ULL,
0xfffffff03c397812ULL, 0x000fe400078ee239ULL, 0x80000005383e7c10ULL, 0x000fe4000fffe0ffULL,
0x00014000394b7811ULL, 0x000fe200078e20ffULL, 0x000000014f397824ULL, 0x000fe200078e0242ULL,
0x0000003e0700720cULL, 0x000fda0003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a4b7faeULL, 0x0003e8000c101c50ULL, 0x018a0800413f7984ULL, 0x000ea80000004800ULL,
0x018ac0003f387984ULL, 0x004ea40000004800ULL, 0x000000380d387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383c7210ULL, 0x000fe20007f1e0ffULL,
0x000000014f387824ULL, 0x040fe400078e0232ULL, 0x000000104f4f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e0639ULL, 0x0000003e4d00720cULL, 0x000fe40003f06070ULL,
0xfffffff04f387812ULL, 0x000fe400078ee238ULL, 0x00000004074d7810ULL, 0x000fc40007ffe0ffULL,
0x00014000384b7811ULL, 0x002fe400078e20ffULL, 0x000000054d4f7c10ULL, 0x000fca000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c4b7faeULL, 0x0003e2000c101c50ULL,
0x000000014f397824ULL, 0x000fc600078e0242ULL, 0x018a1000413f7984ULL, 0x000ea80000004800ULL,
0x018ac0003f387984ULL, 0x0044e40000004800ULL, 0x00000006073f7810ULL, 0x004fc80007ffe0ffULL,
0x000000053f4b7c10ULL, 0x002fe2000fffe0ffULL, 0x000000380d387224ULL, 0x008fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe20007f1e0ffULL,
0x000000014f387824ULL, 0x040fe400078e0232ULL, 0x000000104f4f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fe200000e0639ULL, 0x0000003e4d00720cULL, 0x000fe40003f06070ULL,
0xfffffff04f387812ULL, 0x000fc800078ee238ULL, 0x00014000383d7811ULL, 0x000fe200078e20ffULL,
0x000000014b387824ULL, 0x040fe400078e0242ULL, 0x000000014b427824ULL, 0x040fe400078e0232ULL,
0x000000104b4b7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e6000c101c50ULL, 0xfffffff04b427812ULL, 0x000fe200078ee242ULL,
0x018a1800413c7984ULL, 0x000ea60000004800ULL, 0x00014000423b7811ULL, 0x002fe200078e20ffULL,
0x018ac0003c3c7984ULL, 0x004e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x0000004938387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fe200000e0639ULL, 0x0000003e3f00720cULL, 0x000fda0003f06070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e2000c101c50ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x0000000507477c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff497424ULL, 0x000fe400078e00ffULL, 0x00000010323a7824ULL, 0x000fe200078e00ffULL,
0x00000002473f7810ULL, 0x040fe20007ffe0ffULL, 0x018a0000473c7984ULL, 0x000e620000004800ULL,
0x0000000147387824ULL, 0x000fe400078e0242ULL, 0x000000f03a4b7812ULL, 0x000fe200078ec0ffULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0049ULL, 0x0000004b383a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000147387824ULL, 0x000fc800078e0232ULL, 0x000000ffff3b7224ULL, 0x000fe400000e0639ULL,
0x0000001047397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0001400038417811ULL, 0x000fe200078e20ffULL, 0x0000000142387824ULL, 0x000fc800078e023fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e8000b901c50ULL,
0x018a0800473e7984ULL, 0x000ea20000004800ULL, 0x0000000447417810ULL, 0x002fc60007ffe0ffULL,
0x018ac0003e3e7984ULL, 0x004e640000004800ULL, 0x0000003e0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0049ULL, 0x0000004b383c7210ULL, 0x000fe20007f1e0ffULL,
0x000000013f387824ULL, 0x040fe400078e0232ULL, 0x000000103f3f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e0639ULL, 0xfffffff03f387812ULL, 0x000fc800078ee238ULL,
0x00014000383f7811ULL, 0x000fe200078e20ffULL, 0x0000000142387824ULL, 0x000fc800078e0241ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c3f7faeULL, 0x0003e8000b901c50ULL,
0x018a1000473e7984ULL, 0x000ea20000004800ULL, 0x00000006473f7810ULL, 0x002fc60007ffe0ffULL,
0x018ac0003e3e7984ULL, 0x004e640000004800ULL, 0x0000003e0d387224ULL, 0x002fe400078e0238ULL,
0x000000013f3e7824ULL, 0x000fe400078e0232ULL, 0x00005e0038387625ULL, 0x000fca00078e0049ULL,
0x0000004b383a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000141387824ULL, 0x040fe400078e0232ULL,
0x0000001041417824ULL, 0x000fe400078e00ffULL, 0x000000ffff3b7224ULL, 0x000fc600000e0639ULL,
0xfffffff041387812ULL, 0x000fc800078ee238ULL, 0x00014000383d7811ULL, 0x000fe200078e20ffULL,
0x0000000142387824ULL, 0x000fe400078e023fULL, 0x000000103f3f7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e6000b901c50ULL,
0xfffffff03f3e7812ULL, 0x000fe200078ee23eULL, 0x018a1800473c7984ULL, 0x000ea60000004800ULL,
0x000140003e3b7811ULL, 0x002fe200078e20ffULL, 0x018ac0003c3c7984ULL, 0x004e640000004800ULL,
0x0000003c0d387224ULL, 0x002fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0049ULL,
0x0000004b38387210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e6000b901c50ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff387f8cULL, 0x002e64000c80043fULL, 0x000000ffff3f7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b8c00ff3a7984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x800000003aff7812ULL, 0x002fe2000780483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000453400720cULL, 0x000fe20003f04070ULL,
0x00000004ff3a7424ULL, 0x000fe200078e00ffULL, 0x00018a000c3d7811ULL, 0x000fe400078e10ffULL,
0x000000ff40387207ULL, 0x000fc40000000000ULL, 0x000000ff40407207ULL, 0x000fc60004000000ULL,
0x0000000143387824ULL, 0x000fc800078e0238ULL, 0x0000004038397824ULL, 0x040fe200078e00ffULL,
0x0000004538387211ULL, 0x000fc800078ff0ffULL, 0x000000c039397812ULL, 0x000fca00078ec0ffULL,
0x0000010038387824ULL, 0x000fe200078e0239ULL, 0x0000000a40397c10ULL, 0x000fc8000fffe0ffULL,
0x0000002038387810ULL, 0x000fca0007ffe0ffULL, 0x000000010c3b7824ULL, 0x100fe400078e0238ULL,
0x0000680039397a24ULL, 0x000fc600078e0238ULL, 0x000000603b00720cULL, 0x000fe20003f06070ULL,
0x000000010c397824ULL, 0x000fc800078e0239ULL, 0x0000660039387625ULL, 0x000fd000078e003aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383d7faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b7800ff387f8cULL, 0x000e62000c80043fULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x000000ffff6b7224ULL, 0x002fe200078e0039ULL,
0x0000014000001947ULL, 0x000fea0003800000ULL, 0x0000000aff08723eULL, 0x000fc800000010ffULL,
0x00005410083a7816ULL, 0x000fe20000000008ULL, 0x00021f327f007947ULL, 0x000fea000b800000ULL,
0x00001f623a097589ULL, 0x0002a400000e0000ULL, 0x00021f927f007947ULL, 0x000fea000b800000ULL,
0x00001f613a087589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010623f7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x000071c000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0002312000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3e7224ULL, 0x004fe200078e003aULL,
0x00000018623f7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff407424ULL, 0x000fe200078e00ffULL,
0x0000723000387802ULL, 0x000fe20000000f00ULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000230b000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0001600064647811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0001600063637811ULL, 0x000fe200078e20ffULL, 0x000000015c5f7824ULL, 0x040fe200078e025fULL,
0x0000000467687810ULL, 0x040fe20007ffe0ffULL, 0x00000000643c783bULL, 0x006e620000004200ULL,
0x000000015c5d7824ULL, 0x000fe200078e025dULL, 0x0000000667677810ULL, 0x000fe20007ffe0ffULL,
0x00001ed000017945ULL, 0x000fe20003800000ULL, 0x0000003c00387306ULL, 0x002ff00000009400ULL,
0x0000003c00397306ULL, 0x000e700000005400ULL, 0x0000003c007d7306ULL, 0x000ea2000000d400ULL,
0x000000393800720bULL, 0x002fce0003f1d000ULL, 0x0000003d007b7306ULL, 0x000ff0000000d400ULL,
0x0000003d00387306ULL, 0x000fe20000009400ULL, 0x000000017d7d0812ULL, 0x004fce00078efcffULL,
0x0000003d00397306ULL, 0x000e700000005400ULL, 0x0000003e00757306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003f1d000ULL, 0x0000003f00737306ULL, 0x000ff0000000d400ULL,
0x0000003e00387306ULL, 0x000fe20000009400ULL, 0x000000017b7b0812ULL, 0x000fce00078efcffULL,
0x0000003e00397306ULL, 0x000e640000005400ULL, 0x000000393800720bULL, 0x002fcc0003f1d000ULL,
0x0000003f00387306ULL, 0x000ff00000009400ULL, 0x0000003f00397306ULL, 0x000e620000005400ULL,
0x0000000175750812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fc40003f1d000ULL,
0x000000006338783bULL, 0x008e760000004200ULL, 0x0000000173730812ULL, 0x000fe200078efcffULL,
0x0000003800407306ULL, 0x002fe20000009400ULL, 0x00000018ff467819ULL, 0x000fce000001143aULL,
0x0000003800417306ULL, 0x000e700000005400ULL, 0x0000003800727306ULL, 0x000ea2000000d400ULL,
0x000000414000720bULL, 0x002fce0003f1d000ULL, 0x00000039006f7306ULL, 0x000ff0000000d400ULL,
0x0000003900407306ULL, 0x000fe20000009400ULL, 0x0000000172720812ULL, 0x004fce00078efcffULL,
0x0000003900417306ULL, 0x000e700000005400ULL, 0x0000003a006e7306ULL, 0x000fe2000000d400ULL,
0x000000414000720bULL, 0x002fce0003f1d000ULL, 0x0000004600697306ULL, 0x000ff0000020d400ULL,
0x0000003a00407306ULL, 0x000fe20000009400ULL, 0x000000016f6f0812ULL, 0x000fce00078efcffULL,
0x0000003a00417306ULL, 0x000e640000005400ULL, 0x000000414000720bULL, 0x002fe40003f1d000ULL,
0x00000018ff407819ULL, 0x000fc8000001143cULL, 0x0000004000417306ULL, 0x000fee0000209400ULL,
0x000000016e6e0812ULL, 0x000fe200078efcffULL, 0x0000004000427306ULL, 0x000e700000205400ULL,
0x0000004000777306ULL, 0x000ea2000020d400ULL, 0x000000424100720bULL, 0x002fc40003f1d000ULL,
0x00000018ff417819ULL, 0x000fca000001143dULL, 0x0000004100427306ULL, 0x000fec0000209400ULL,
0x0000000177770812ULL, 0x004fe400078efcffULL, 0x0000004100437306ULL, 0x000e700000205400ULL,
0x0000004100767306ULL, 0x0004e2000020d400ULL, 0x000000434200720bULL, 0x002fc40003f1d000ULL,
0x00000018ff427819ULL, 0x000fe4000001143eULL, 0x00000018ff417819ULL, 0x004fc60000011438ULL,
0x0000004200437306ULL, 0x000fec0000209400ULL, 0x0000000176760812ULL, 0x008fe400078efcffULL,
0x0000004200407306ULL, 0x000e700000205400ULL, 0x0000004200747306ULL, 0x000ea2000020d400ULL,
0x000000404300720bULL, 0x002fce0003f1d000ULL, 0x0000004100427306ULL, 0x000fe20000205400ULL,
0x00000018ff407819ULL, 0x000fce000001143fULL, 0x0000004000437306ULL, 0x000fe20000209400ULL,
0x0000000174740812ULL, 0x004fce00078efcffULL, 0x0000004000447306ULL, 0x000e700000205400ULL,
0x0000004000717306ULL, 0x000ea2000020d400ULL, 0x000000444300720bULL, 0x002fce0003f1d000ULL,
0x0000004100707306ULL, 0x000ff0000020d400ULL, 0x0000004100437306ULL, 0x000e620000209400ULL,
0x0000000171710812ULL, 0x004fce00078efcffULL, 0x0000004600417306ULL, 0x000fe20000205400ULL,
0x000000424300720bULL, 0x002fe40003f1d000ULL, 0x00000018ff427819ULL, 0x000fca0000011439ULL,
0x0000004200437306ULL, 0x000fec0000209400ULL, 0x0000000170700812ULL, 0x000fe400078efcffULL,
0x0000004200407306ULL, 0x000e700000205400ULL, 0x00000042006d7306ULL, 0x000ea2000020d400ULL,
0x000000404300720bULL, 0x002fce0003f1d000ULL, 0x0000004600407306ULL, 0x000e6c0000209400ULL,
0x000000016d6d0812ULL, 0x004fe400078efcffULL, 0x000000414000720bULL, 0x002fe20003f1d000ULL,
0x000000105c407824ULL, 0x040fe400078e00ffULL, 0x000000105c5c7824ULL, 0x000fc600078e00ffULL,
0xfffffff0405f7812ULL, 0x000fe400078ee25fULL, 0xfffffff05c5d7812ULL, 0x000fe400078ee25dULL,
0x000160005f667811ULL, 0x000fe400078e20ffULL, 0x000160005d657811ULL, 0x000fe400078e20ffULL,
0x0000000169690812ULL, 0x000fe200078efcffULL, 0x000000006640783bULL, 0x000e640000004200ULL,
0x0000004000447306ULL, 0x002ff00000009400ULL, 0x0000004000457306ULL, 0x000e700000005400ULL,
0x0000004000587306ULL, 0x000ea2000000d400ULL, 0x000000454400720bULL, 0x002fce0003f1d000ULL,
0x0000004100597306ULL, 0x000ff0000000d400ULL, 0x0000004100447306ULL, 0x000fe20000009400ULL,
0x0000000158580812ULL, 0x004fce00078efcffULL, 0x0000004100457306ULL, 0x000e700000005400ULL,
0x0000004200507306ULL, 0x000fe2000000d400ULL, 0x000000454400720bULL, 0x002fce0003f1d000ULL,
0x0000004300517306ULL, 0x000ff0000000d400ULL, 0x0000004200447306ULL, 0x000fe20000009400ULL,
0x0000000159590812ULL, 0x000fce00078efcffULL, 0x0000004200457306ULL, 0x000e640000005400ULL,
0x000000454400720bULL, 0x002fcc0003f1d000ULL, 0x0000004300447306ULL, 0x000ff00000009400ULL,
0x0000004300457306ULL, 0x000e620000005400ULL, 0x0000000150500812ULL, 0x000fe400078efcffULL,
0x000000454400720bULL, 0x002fc40003f1d000ULL, 0x000000006544783bULL, 0x000e760000004200ULL,
0x0000000151510812ULL, 0x000fe200078efcffULL, 0x0000004400487306ULL, 0x002ff00000009400ULL,
0x00000044004b7306ULL, 0x000e700000005400ULL, 0x0000004400497306ULL, 0x000ea2000000d400ULL,
0x0000004b4800720bULL, 0x002fce0003f1d000ULL, 0x00000045004a7306ULL, 0x000ff00000009400ULL,
0x00000045004b7306ULL, 0x000e620000005400ULL, 0x0000000149490812ULL, 0x004fce00078efcffULL,
0x0000004500487306ULL, 0x000ea2000000d400ULL, 0x0000004b4a00720bULL, 0x002fce0003f1d000ULL,
0x0000004600877306ULL, 0x000ff0000000d400ULL, 0x00000046004a7306ULL, 0x000fe20000009400ULL,
0x0000000148480812ULL, 0x004fce00078efcffULL, 0x00000046004b7306ULL, 0x000e700000005400ULL,
0x0000004700857306ULL, 0x000fe2000000d400ULL, 0x0000004b4a00720bULL, 0x002fce0003f1d000ULL,
0x00000047004a7306ULL, 0x000ff00000009400ULL, 0x00000047004b7306ULL, 0x000e620000005400ULL,
0x0000000187870812ULL, 0x000fe400078efcffULL, 0x0000004b4a00720bULL, 0x002fe20003f1d000ULL,
0x000001003c4a7824ULL, 0x000fc400078e00ffULL, 0x000100003c3c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004a004b7306ULL, 0x000fe60000209400ULL, 0x0000000185850812ULL, 0x000fca00078efcffULL,
0x0000004a004c7306ULL, 0x000e700000205400ULL, 0x0000004a00847306ULL, 0x000ea2000020d400ULL,
0x0000004c4b00720bULL, 0x002fce0003f1d000ULL, 0x0000003c00827306ULL, 0x000ff0000020d400ULL,
0x0000003c004b7306ULL, 0x000fe20000209400ULL, 0x0000000184840812ULL, 0x004fce00078efcffULL,
0x0000003c004c7306ULL, 0x000e620000205400ULL, 0x0000007d8484723eULL, 0x000fe400000010ffULL,
0x0000004c4b00720bULL, 0x002fe20003f1d000ULL, 0x000001003d4b7824ULL, 0x040fe400078e00ffULL,
0x000100003d3d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe4000001144bULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000004b004a7306ULL, 0x000fe60000209400ULL,
0x0000000182820812ULL, 0x000fc800078efcffULL, 0x000000827782723eULL, 0x000fe200000010ffULL,
0x0000004b004d7306ULL, 0x000e700000205400ULL, 0x0000004b00867306ULL, 0x000ea2000020d400ULL,
0x0000004d4a00720bULL, 0x002fce0003f1d000ULL, 0x0000003d003c7306ULL, 0x000ff00000209400ULL,
0x0000003d004d7306ULL, 0x000e620000205400ULL, 0x0000000186860812ULL, 0x004fce00078efcffULL,
0x0000003d00837306ULL, 0x000ea2000020d400ULL, 0x0000004d3c00720bULL, 0x002fe20003f1d000ULL,
0x000001003e3c7824ULL, 0x040fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000003c004a7306ULL, 0x000fe60000209400ULL, 0x0000000183830812ULL, 0x004fc800078efcffULL,
0x000000837683723eULL, 0x000fe200000010ffULL, 0x0000003c004b7306ULL, 0x000e700000205400ULL,
0x0000003c00807306ULL, 0x000ea2000020d400ULL, 0x0000004b4a00720bULL, 0x002fce0003f1d000ULL,
0x0000003e003d7306ULL, 0x000ff00000209400ULL, 0x0000003e004a7306ULL, 0x000e620000205400ULL,
0x0000000180800812ULL, 0x004fce00078efcffULL, 0x0000003e00817306ULL, 0x000ea2000020d400ULL,
0x000000758076723eULL, 0x000fe400000010ffULL, 0x0000004a3d00720bULL, 0x002fe20003f1d000ULL,
0x000001003f3d7824ULL, 0x040fe400078e00ffULL, 0x000100003f3f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000003d003c7306ULL, 0x000fe60000209400ULL, 0x0000000181810812ULL, 0x004fc800078efcffULL,
0x000000817474723eULL, 0x000fe200000010ffULL, 0x0000003d004b7306ULL, 0x000e700000205400ULL,
0x0000003d007e7306ULL, 0x000ea2000020d400ULL, 0x0000004b3c00720bULL, 0x002fce0003f1d000ULL,
0x0000003f007c7306ULL, 0x000ff0000020d400ULL, 0x0000003f003c7306ULL, 0x000fe20000209400ULL,
0x000000017e7e0812ULL, 0x004fce00078efcffULL, 0x0000003f004b7306ULL, 0x000e620000205400ULL,
0x000000737e77723eULL, 0x000fe400000010ffULL, 0x0000004b3c00720bULL, 0x002fe20003f1d000ULL,
0x00000100383c7824ULL, 0x040fe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003c003d7306ULL, 0x000fe60000209400ULL, 0x000000017c7c0812ULL, 0x000fc800078efcffULL,
0x0000007c7175723eULL, 0x000fe200000010ffULL, 0x0000003c003e7306ULL, 0x000e700000205400ULL,
0x0000003c007f7306ULL, 0x000ea2000020d400ULL, 0x0000003e3d00720bULL, 0x002fce0003f1d000ULL,
0x0000003800797306ULL, 0x000ff0000020d400ULL, 0x00000038003d7306ULL, 0x000fe20000209400ULL,
0x000000017f7f0812ULL, 0x004fce00078efcffULL, 0x00000038003e7306ULL, 0x000e620000205400ULL,
0x000000727f72723eULL, 0x000fe400000010ffULL, 0x0000003e3d00720bULL, 0x002fe20003f1d000ULL,
0x00000100393d7824ULL, 0x040fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff387819ULL, 0x000fe40000011439ULL,
0x0000003d003c7306ULL, 0x000fe60000209400ULL, 0x0000000179790812ULL, 0x000fca00078efcffULL,
0x0000003d003f7306ULL, 0x000e700000205400ULL, 0x0000003d007a7306ULL, 0x000ea2000020d400ULL,
0x0000003f3c00720bULL, 0x002fce0003f1d000ULL, 0x0000003800397306ULL, 0x000ff00000209400ULL,
0x00000038003c7306ULL, 0x000e620000205400ULL, 0x000000017a7a0812ULL, 0x004fce00078efcffULL,
0x0000003800787306ULL, 0x000ea2000020d400ULL, 0x0000006f7a73723eULL, 0x000fe400000010ffULL,
0x0000003c3900720bULL, 0x002fe20003f1d000ULL, 0x000001003a397824ULL, 0x040fe400078e00ffULL,
0x000100003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc80000011439ULL,
0x0000003c003d7306ULL, 0x000fe60000209400ULL, 0x0000000178780812ULL, 0x004fc800078efcffULL,
0x000000786d6d723eULL, 0x000fe200000010ffULL, 0x0000003c003e7306ULL, 0x000e700000205400ULL,
0x0000003c00397306ULL, 0x000ea2000020d400ULL, 0x0000003e3d00720bULL, 0x002fc40003f1d000ULL,
0x00000018ff3d7819ULL, 0x000fca000001143aULL, 0x0000003d00387306ULL, 0x000fec0000209400ULL,
0x0000000139390812ULL, 0x004fe400078efcffULL, 0x0000003d003f7306ULL, 0x000e640000205400ULL,
0x0000006e396e723eULL, 0x000fcc00000010ffULL, 0x0000003d003a7306ULL, 0x000ea2000020d400ULL,
0x0000003f3800720bULL, 0x002fe20003f1d000ULL, 0x000001003b387824ULL, 0x000fca00078e00ffULL,
0x00000018ff3f7819ULL, 0x000fc80000011438ULL, 0x0000003f003c7306ULL, 0x000fe60000209400ULL,
0x000000013a3a0812ULL, 0x004fc800078efcffULL, 0x0000003a693a723eULL, 0x000fe200000010ffULL,
0x0000003f004b7306ULL, 0x000e700000205400ULL, 0x0000003f00387306ULL, 0x000ea2000020d400ULL,
0x0000004b3c00720bULL, 0x002fc40003f1d000ULL, 0x00000018ff3c7819ULL, 0x000fca0000011440ULL,
0x0000003c003d7306ULL, 0x000fec0000209400ULL, 0x0000000138380812ULL, 0x004fe400078efcffULL,
0x0000003c003e7306ULL, 0x000e700000205400ULL, 0x0000003c004b7306ULL, 0x000ea2000020d400ULL,
0x0000003e3d00720bULL, 0x002fc40003f1d000ULL, 0x00000018ff3d7819ULL, 0x000fca0000011441ULL,
0x0000003d003e7306ULL, 0x000fec0000209400ULL, 0x000000014b4b0812ULL, 0x004fe400078efcffULL,
0x0000003d003f7306ULL, 0x000e700000205400ULL, 0x0000003d004a7306ULL, 0x0004e2000020d400ULL,
0x0000003f3e00720bULL, 0x002fc40003f1d000ULL, 0x00000018ff3e7819ULL, 0x000fe40000011442ULL,
0x00000018ff3d7819ULL, 0x004fc60000011444ULL, 0x0000003e003f7306ULL, 0x000fec0000209400ULL,
0x000000014a4a0812ULL, 0x008fe400078efcffULL, 0x0000003e003c7306ULL, 0x000e700000205400ULL,
0x0000003e004f7306ULL, 0x000ea2000020d400ULL, 0x0000003c3f00720bULL, 0x002fce0003f1d000ULL,
0x0000003d003e7306ULL, 0x000fe20000205400ULL, 0x00000018ff3c7819ULL, 0x000fce0000011443ULL,
0x0000003c003f7306ULL, 0x000fe20000209400ULL, 0x000000014f4f0812ULL, 0x004fce00078efcffULL,
0x0000003c004c7306ULL, 0x000e700000205400ULL, 0x0000003c008d7306ULL, 0x000ea2000020d400ULL,
0x0000004c3f00720bULL, 0x002fce0003f1d000ULL, 0x0000003d008b7306ULL, 0x000fe2000020d400ULL,
0x00000018ff4c7819ULL, 0x000fce0000011447ULL, 0x0000003d003f7306ULL, 0x000e620000209400ULL,
0x000000018d8d0812ULL, 0x004fce00078efcffULL, 0x0000004c00897306ULL, 0x000fe2000020d400ULL,
0x0000003e3f00720bULL, 0x002fe40003f1d000ULL, 0x00000018ff3e7819ULL, 0x000fca0000011445ULL,
0x0000003e003f7306ULL, 0x000fec0000209400ULL, 0x000000018b8b0812ULL, 0x000fe400078efcffULL,
0x0000003e003c7306ULL, 0x000e700000205400ULL, 0x0000003e008a7306ULL, 0x000ea2000020d400ULL,
0x0000003c3f00720bULL, 0x002fc40003f1d000ULL, 0x00000018ff3f7819ULL, 0x000fca0000011446ULL,
0x0000003f003c7306ULL, 0x000fec0000209400ULL, 0x000000018a8a0812ULL, 0x004fe400078efcffULL,
0x0000003f003d7306ULL, 0x000e700000205400ULL, 0x0000003f00887306ULL, 0x000ea2000020d400ULL,
0x0000003d3c00720bULL, 0x002fce0003f1d000ULL, 0x0000004c003c7306ULL, 0x000ff00000209400ULL,
0x0000004c003d7306ULL, 0x000e620000205400ULL, 0x0000000188880812ULL, 0x004fe400078efcffULL,
0x0000003d3c00720bULL, 0x002fe20003f1d000ULL, 0x00000100403c7824ULL, 0x000fc400078e00ffULL,
0x0001000040407824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000003c003d7306ULL, 0x000fe60000209400ULL,
0x0000000189890812ULL, 0x000fca00078efcffULL, 0x0000003c003e7306ULL, 0x000e700000205400ULL,
0x0000003c003f7306ULL, 0x000ea2000020d400ULL, 0x0000003e3d00720bULL, 0x002fce0003f1d000ULL,
0x0000004000547306ULL, 0x000ff0000020d400ULL, 0x00000040003d7306ULL, 0x000fe20000209400ULL,
0x000000013f3f0812ULL, 0x004fce00078efcffULL, 0x00000040003e7306ULL, 0x000e620000205400ULL,
0x000000583f58723eULL, 0x000fe400000010ffULL, 0x0000003e3d00720bULL, 0x002fe20003f1d000ULL,
0x00000100413d7824ULL, 0x040fe400078e00ffULL, 0x0001000041417824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000003d003c7306ULL, 0x000fe60000209400ULL, 0x0000000154540812ULL, 0x000fc800078efcffULL,
0x000000544b54723eULL, 0x000fe200000010ffULL, 0x0000003d004d7306ULL, 0x000e700000205400ULL,
0x0000003d003e7306ULL, 0x000ea2000020d400ULL, 0x0000004d3c00720bULL, 0x002fce0003f1d000ULL,
0x0000004100557306ULL, 0x000ff0000020d400ULL, 0x00000041003c7306ULL, 0x000fe20000209400ULL,
0x000000013e3e0812ULL, 0x004fce00078efcffULL, 0x00000041004d7306ULL, 0x000e620000205400ULL,
0x000000593e59723eULL, 0x000fe400000010ffULL, 0x0000004d3c00720bULL, 0x002fe20003f1d000ULL,
0x00000100423c7824ULL, 0x040fe400078e00ffULL, 0x0001000042427824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x0000003c003d7306ULL, 0x000fe60000209400ULL, 0x0000000155550812ULL, 0x000fc800078efcffULL,
0x000000554a55723eULL, 0x000fe200000010ffULL, 0x0000003c00407306ULL, 0x000e700000205400ULL,
0x0000003c004d7306ULL, 0x000ea2000020d400ULL, 0x000000403d00720bULL, 0x002fce0003f1d000ULL,
0x00000042004c7306ULL, 0x000ff0000020d400ULL, 0x00000042003d7306ULL, 0x000fe20000209400ULL,
0x000000014d4d0812ULL, 0x004fce00078efcffULL, 0x0000004200407306ULL, 0x000e620000205400ULL,
0x000000504d50723eULL, 0x000fe400000010ffULL, 0x000000403d00720bULL, 0x002fe20003f1d000ULL,
0x00000100433d7824ULL, 0x040fe400078e00ffULL, 0x0001000043437824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000003d003c7306ULL, 0x000fe60000209400ULL, 0x000000014c4c0812ULL, 0x000fc800078efcffULL,
0x0000004c4f4c723eULL, 0x000fe200000010ffULL, 0x0000003d00417306ULL, 0x000e700000205400ULL,
0x0000003d00407306ULL, 0x000ea2000020d400ULL, 0x000000413c00720bULL, 0x002fce0003f1d000ULL,
0x0000004300427306ULL, 0x000ff0000020d400ULL, 0x00000043003c7306ULL, 0x000fe20000209400ULL,
0x0000000140400812ULL, 0x004fce00078efcffULL, 0x0000004300417306ULL, 0x000e620000205400ULL,
0x000000514051723eULL, 0x000fe400000010ffULL, 0x000000413c00720bULL, 0x002fe20003f1d000ULL,
0x00000100443c7824ULL, 0x040fe400078e00ffULL, 0x0001000044447824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000003c003d7306ULL, 0x000fe60000209400ULL, 0x0000000142420812ULL, 0x000fc800078efcffULL,
0x000000428d4d723eULL, 0x000fe200000010ffULL, 0x0000003c004e7306ULL, 0x000e700000205400ULL,
0x0000003c008e7306ULL, 0x000ea2000020d400ULL, 0x0000004e3d00720bULL, 0x002fce0003f1d000ULL,
0x0000004400907306ULL, 0x000ff0000020d400ULL, 0x00000044003d7306ULL, 0x000fe20000209400ULL,
0x000000018e8e0812ULL, 0x004fce00078efcffULL, 0x00000044004e7306ULL, 0x000e620000205400ULL,
0x000000498e4a723eULL, 0x000fe400000010ffULL, 0x0000004e3d00720bULL, 0x002fe20003f1d000ULL,
0x00000100453d7824ULL, 0x040fe400078e00ffULL, 0x0001000045457824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000003d003c7306ULL, 0x000fe60000209400ULL, 0x0000000190900812ULL, 0x000fca00078efcffULL,
0x0000003d00417306ULL, 0x000e700000205400ULL, 0x0000003d00437306ULL, 0x000ea2000020d400ULL,
0x000000413c00720bULL, 0x002fce0003f1d000ULL, 0x00000045008f7306ULL, 0x000ff0000020d400ULL,
0x00000045003c7306ULL, 0x000fe20000209400ULL, 0x0000000143430812ULL, 0x004fce00078efcffULL,
0x0000004500417306ULL, 0x000e620000205400ULL, 0x00000048434b723eULL, 0x000fe400000010ffULL,
0x000000413c00720bULL, 0x002fe20003f1d000ULL, 0x00000100463c7824ULL, 0x040fe400078e00ffULL,
0x0001000046467824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000003c003d7306ULL, 0x000fe60000209400ULL,
0x000000018f8f0812ULL, 0x000fc800078efcffULL, 0x0000008f8a45723eULL, 0x000fe200000010ffULL,
0x0000003c00447306ULL, 0x000e700000205400ULL, 0x0000003c00927306ULL, 0x000ea2000020d400ULL,
0x000000443d00720bULL, 0x002fce0003f1d000ULL, 0x0000004600917306ULL, 0x000ff0000020d400ULL,
0x00000046003d7306ULL, 0x000fe20000209400ULL, 0x0000000192920812ULL, 0x004fce00078efcffULL,
0x0000004600447306ULL, 0x000e620000205400ULL, 0x000000879240723eULL, 0x000fce00000010ffULL,
0x0000003b00877306ULL, 0x000fe2000000d400ULL, 0x000000443d00720bULL, 0x002fe20003f1d000ULL,
0x00000100473d7824ULL, 0x000fe200078e00ffULL, 0x000000908b44723eULL, 0x000fe200000010ffULL,
0x0001000047477824ULL, 0x000fc800078e00ffULL, 0x0000003b008b7306ULL, 0x000fe20000005400ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff477819ULL, 0x000fca0000011447ULL,
0x0000003d003c7306ULL, 0x000fe20000209400ULL, 0x0000000191910812ULL, 0x000fc800078efcffULL,
0x000000918888723eULL, 0x000fc600000010ffULL, 0x0000003d00417306ULL, 0x000e700000205400ULL,
0x0000003d00947306ULL, 0x0004e2000020d400ULL, 0x000000413c00720bULL, 0x002fe20003f1d000ULL,
0x000000086c3d7824ULL, 0x004fcc00078e00ffULL, 0x00000047003c7306ULL, 0x000fe20000209400ULL,
0x000000086c6c7824ULL, 0x000fe200078e00ffULL, 0xfffffff83d687812ULL, 0x000fc800078ee268ULL,
0xfffffff86c677812ULL, 0x000fe400078ee267ULL, 0x0000004700417306ULL, 0x000e620000205400ULL,
0x0000000194940812ULL, 0x008fce00078efcffULL, 0x0000004700967306ULL, 0x000ea2000020d400ULL,
0x000000413c00720bULL, 0x002fce0003f1d000ULL, 0x0000003b006c7306ULL, 0x000e620000009400ULL,
0x00012000683c7811ULL, 0x000fe400078e20ffULL, 0x000000859441723eULL, 0x000fe200000010ffULL,
0x000100003b857824ULL, 0x000fe400078e00ffULL, 0x000000003c5c783bULL, 0x0007260000000200ULL,
0x00000018ff8a7819ULL, 0x000fe40000011485ULL, 0x0000007b8685723eULL, 0x000fc400000010ffULL,
0x0000008a008d7306ULL, 0x000fe20000209400ULL, 0x00012000673c7811ULL, 0x008fe400078e20ffULL,
0x0000000196960812ULL, 0x004fe400078efcffULL, 0x0000008b6c00720bULL, 0x002fe40003f1d000ULL,
0x000000003c3c783bULL, 0x000e620000000200ULL, 0x0000008a00867306ULL, 0x000ea20000205400ULL,
0x00000018ff7b7819ULL, 0x000fe4000001143bULL, 0x000000968989723eULL, 0x000fca00000010ffULL,
0x0000008a003b7306ULL, 0x000ee4000020d400ULL, 0x0000000187870812ULL, 0x000fc800078efcffULL,
0x00000087386f723eULL, 0x000fe400000010ffULL, 0x0000007b006c7306ULL, 0x000fe20000209400ULL,
0x000000868d00720bULL, 0x004fce0003f1d000ULL, 0x0000007b007d7306ULL, 0x000ea20000205400ULL,
0x000000095c5c9231ULL, 0x090fe400003400ffULL, 0x000000095e5e9231ULL, 0x000fe400003400ffULL,
0x000000085d5d9231ULL, 0x080fe200003400ffULL, 0x000000013b3b0812ULL, 0x008fe200078efcffULL,
0x000000085f5f9231ULL, 0x000fce00003400ffULL, 0x0000004c5c4c723cULL, 0x040f6200000418ffULL,
0x000000093c3c9231ULL, 0x082fe200003400ffULL, 0x0000007d6c00720bULL, 0x004fe20003f1d000ULL,
0x000000093e3e9231ULL, 0x000fe200003400ffULL, 0x00000079706c723eULL, 0x000fe200000010ffULL,
0x000000083d3d9231ULL, 0x080fe400003400ffULL, 0x000000083f3f9231ULL, 0x000fe200003400ffULL,
0x000000585c58723cULL, 0x000f6200000418ffULL, 0x000000ff8c00720cULL, 0x000fce0003f25270ULL,
0x000000545c54723cULL, 0x000f7000000418ffULL, 0x000000743c4c723cULL, 0x020be4000004184cULL,
0x0000007b00747306ULL, 0x020e6c000020d400ULL, 0x000000505c50723cULL, 0x040f7000000418ffULL,
0x0000004a5c48723cULL, 0x000f6200000418ffULL, 0x0000000174740812ULL, 0x002fc800078efcffULL,
0x0000003b743b723eULL, 0x000fc600000010ffULL, 0x000000445c44723cULL, 0x040f7000000418ffULL,
0x000000405c40723cULL, 0x040f7000000418ffULL, 0x000000885c5c723cULL, 0x000f7000000418ffULL,
0x000000843c58723cULL, 0x040b700000041858ULL, 0x000000823c54723cULL, 0x040b700000041854ULL,
0x000000763c50723cULL, 0x060b700000041850ULL, 0x000000723c48723cULL, 0x040b700000041848ULL,
0x0000006c3c44723cULL, 0x040b700000041844ULL, 0x0000006e3c40723cULL, 0x040b700000041840ULL,
0x0000003a3c5c723cULL, 0x000b62000004185cULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0000800000ULL, 0x0000005812127221ULL, 0x000fe40000010000ULL,
0x0000005913137221ULL, 0x000fc40000010000ULL, 0x0000005416167221ULL, 0x000fe40000010000ULL,
0x0000005517177221ULL, 0x000fe40000010000ULL, 0x000000501a1a7221ULL, 0x020fe40000010000ULL,
0x000000511b1b7221ULL, 0x000fe40000010000ULL, 0x0000004c1e1e7221ULL, 0x000fe40000010000ULL,
0x0000004d1f1f7221ULL, 0x000fc40000010000ULL, 0x0000004822227221ULL, 0x000fe40000010000ULL,
0x0000004923237221ULL, 0x000fe40000010000ULL, 0x0000004426267221ULL, 0x000fe40000010000ULL,
0x0000004527277221ULL, 0x000fe40000010000ULL, 0x000000402a2a7221ULL, 0x000fe40000010000ULL,
0x000000412b2b7221ULL, 0x000fc40000010000ULL, 0x0000005c2e2e7221ULL, 0x000fe40000010000ULL,
0x0000005d2f2f7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0003000000ULL,
0x0000005a14147221ULL, 0x000fe40000010000ULL, 0x0000005b15157221ULL, 0x000fe40000010000ULL,
0x0000005618187221ULL, 0x000fe40000010000ULL, 0x0000005719197221ULL, 0x000fe40000010000ULL,
0x000000521c1c7221ULL, 0x020fc40000010000ULL, 0x000000531d1d7221ULL, 0x000fe40000010000ULL,
0x0000004e20207221ULL, 0x000fe40000010000ULL, 0x0000004f21217221ULL, 0x000fe40000010000ULL,
0x0000004a24247221ULL, 0x000fe40000010000ULL, 0x0000004b25257221ULL, 0x000fe40000010000ULL,
0x0000004628287221ULL, 0x000fc40000010000ULL, 0x0000004729297221ULL, 0x000fe40000010000ULL,
0x000000422c2c7221ULL, 0x000fe40000010000ULL, 0x000000432d2d7221ULL, 0x000fe40000010000ULL,
0x0000005e30307221ULL, 0x000fe40000010000ULL, 0x0000005f31317221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000016a6a7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x000e62000c80043fULL,
0x00000004ff697424ULL, 0x000fca00078e00ffULL, 0x0000000169697807ULL, 0x000fc80006800000ULL,
0x000000696a00720cULL, 0x000fe20003f06070ULL, 0x000000ffff3c7224ULL, 0x022fd800078e0039ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff88f000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000400f397811ULL, 0x000fe200078e40ffULL,
0x018b5800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000603900720cULL, 0x000fda0003f06070ULL,
0x00015c9000000947ULL, 0x000fea0003800000ULL, 0x000000ffff6a7224ULL, 0x000fca00078e00ffULL,
0x00000002ff397819ULL, 0x000fe2000001166aULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000036a387812ULL, 0x040fe200078ec0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x000000396a397207ULL, 0x000fe40002800000ULL, 0x000000ff38417207ULL, 0x000fe40006800000ULL,
0x0000000139407810ULL, 0x000fc80007ffe0ffULL, 0x0000000340437812ULL, 0x040fe400078ec0ffULL,
0x0000000f40457211ULL, 0x000fc400078ff0ffULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x018b7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x018b8c00ff3b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000145397810ULL, 0x040fe20007ffe0ffULL, 0x0000000445387824ULL, 0x000fe200078e0243ULL,
0x0000097000017945ULL, 0x000fe40003800000ULL, 0x000000363900720cULL, 0x000fe40003f06070ULL,
0x00000020383b7811ULL, 0x000fc800078e30ffULL, 0x0000006033427812ULL, 0x000fce00078ef83bULL,
0x000004f000008947ULL, 0x000fea0003800000ULL, 0x00000005073f7c10ULL, 0x040fe2000fffe0ffULL,
0x00000010323c7824ULL, 0x000fe200078e00ffULL, 0x0000003b60387217ULL, 0x000fe20007800000ULL,
0x00000100ff477424ULL, 0x000fe200078e00ffULL, 0x00000002074d7810ULL, 0x000fe20007ffe0ffULL,
0x018a00003f397984ULL, 0x000e620000004800ULL, 0x000000f03c497812ULL, 0x000fe200078ec0ffULL,
0x0000000138387824ULL, 0x000fe200078e0a3bULL, 0x000000054d4f7c10ULL, 0x000fe2000fffe0ffULL,
0x000000013f3b7824ULL, 0x040fe400078e0242ULL, 0x000000103f3e7824ULL, 0x000fe200078e00ffULL,
0x0000000538387c17ULL, 0x000fc8000f800000ULL, 0x80000005383c7c10ULL, 0x000fc8000fffe0ffULL,
0x0000003c0700720cULL, 0x000fe20003f06070ULL, 0x018ac000393a7984ULL, 0x002e640000004800ULL,
0x0000003a0d3a7224ULL, 0x002fe400078e023bULL, 0x000000013f3b7824ULL, 0x000fe400078e0232ULL,
0x00005e003a387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe40007f3e0ffULL,
0xfffffff03e387812ULL, 0x000fe200078ee23bULL, 0x000000014f3e7824ULL, 0x040fe400078e0232ULL,
0x000000ffff3b7224ULL, 0x000fe200008e0639ULL, 0x00016000384b7811ULL, 0x000fe200078e20ffULL,
0x000000014f397824ULL, 0x040fe400078e0242ULL, 0x000000104f4f7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a4b7faeULL, 0x0003e2000c101c50ULL,
0x0000003c4d00720cULL, 0x000fc40003f06070ULL, 0xfffffff04f3e7812ULL, 0x000fe200078ee23eULL,
0x018a08003f3d7984ULL, 0x000ea20000004800ULL, 0x00000004074d7810ULL, 0x000fc80007ffe0ffULL,
0x000000054d4f7c10ULL, 0x000fe4000fffe0ffULL, 0x000160003e4b7811ULL, 0x002fc600078e20ffULL,
0x000000014f3e7824ULL, 0x000fe200078e0232ULL, 0x018ac0003d387984ULL, 0x004e640000004800ULL,
0x000000380d387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0047ULL,
0x00000049383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x000000014f397824ULL, 0x040fe400078e0242ULL, 0x000000104f4f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a4b7faeULL, 0x0003e2000c101c50ULL,
0x0000003c4d00720cULL, 0x000fe40003f06070ULL, 0x00000006074d7810ULL, 0x000fe20007ffe0ffULL,
0x018a10003f3d7984ULL, 0x000ea20000004800ULL, 0xfffffff04f3e7812ULL, 0x000fc400078ee23eULL,
0x000000054d4f7c10ULL, 0x000fe4000fffe0ffULL, 0x000160003e4b7811ULL, 0x002fc600078e20ffULL,
0x000000014f3e7824ULL, 0x000fe200078e0232ULL, 0x018ac0003d387984ULL, 0x004e640000004800ULL,
0x000000380d387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0047ULL,
0x00000049383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x000000014f397824ULL, 0x040fe400078e0242ULL, 0x000000104f4f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a4b7faeULL, 0x0003e2000c101c50ULL,
0x0000003c4d00720cULL, 0x000fc60003f06070ULL, 0x018a18003f3d7984ULL, 0x000ea20000004800ULL,
0xfffffff04f3e7812ULL, 0x000fc800078ee23eULL, 0x000160003e3b7811ULL, 0x002fe200078e20ffULL,
0x018ac0003d387984ULL, 0x004e640000004800ULL, 0x000000380d387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x0000004938387210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff397224ULL, 0x000fca00008e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000c101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x0000000507477c10ULL, 0x000fe2000fffe0ffULL, 0x0000001032397824ULL, 0x000fe400078e00ffULL,
0x00000100ff497424ULL, 0x000fe200078e00ffULL, 0x00000002473d7810ULL, 0x040fe20007ffe0ffULL,
0x018a0000473c7984ULL, 0x000e620000004800ULL, 0x0000000147387824ULL, 0x000fe200078e0242ULL,
0x000000f0394b7812ULL, 0x000fe200078ec0ffULL, 0x00000001473b7824ULL, 0x040fe400078e0232ULL,
0x00000010473e7824ULL, 0x000fc400078e00ffULL, 0x000000013d447824ULL, 0x000fe200078e0232ULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0049ULL, 0x0000004b383a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff03e387812ULL, 0x000fc600078ee23bULL, 0x000000ffff3b7224ULL, 0x000fe200000e0639ULL,
0x00016000383f7811ULL, 0x000fe200078e20ffULL, 0x000000013d387824ULL, 0x040fe400078e0242ULL,
0x000000103d3d7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3f7faeULL, 0x0003e6000b901c50ULL, 0xfffffff03d447812ULL, 0x000fe200078ee244ULL,
0x018a0800473e7984ULL, 0x000ea60000004800ULL, 0x00016000443f7811ULL, 0x002fc400078e20ffULL,
0x00000004473b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b447824ULL, 0x000fe200078e0232ULL,
0x018ac0003e3e7984ULL, 0x004e640000004800ULL, 0x0000003e0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0049ULL, 0x0000004b383c7210ULL, 0x000fe20007f1e0ffULL,
0x000000013b387824ULL, 0x040fe400078e0242ULL, 0x000000103b3b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e0639ULL, 0xfffffff03b447812ULL, 0x000fe400078ee244ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c3f7faeULL, 0x0003e8000b901c50ULL,
0x018a1000473e7984ULL, 0x000ea20000004800ULL, 0x00016000443d7811ULL, 0x002fe400078e20ffULL,
0x00000006473f7810ULL, 0x000fe20007ffe0ffULL, 0x018ac0003e3e7984ULL, 0x004e640000004800ULL,
0x0000003e0d387224ULL, 0x002fc400078e0238ULL, 0x000000013f3e7824ULL, 0x000fe400078e0232ULL,
0x00005e0038387625ULL, 0x000fca00078e0049ULL, 0x0000004b383a7210ULL, 0x000fe20007f1e0ffULL,
0x000000013f387824ULL, 0x040fe400078e0242ULL, 0x000000103f3f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600000e0639ULL, 0xfffffff03f3e7812ULL, 0x000fe400078ee23eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c50ULL,
0x018a1800473c7984ULL, 0x000ea20000004800ULL, 0x000160003e3b7811ULL, 0x002fc600078e20ffULL,
0x018ac0003c3c7984ULL, 0x004e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0049ULL, 0x0000004b38387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000453400720cULL, 0x000fe20003f04070ULL, 0x0000015000017945ULL, 0x000fe20003800000ULL,
0x0000000140387812ULL, 0x000fe400078ec0ffULL, 0x000000034100780cULL, 0x000fc80004705270ULL,
0x000000013800780cULL, 0x000fda0000705470ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x000000030c00780cULL, 0x000fe40003f04070ULL, 0x000000010e0e7810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000397919ULL, 0x000e620000002700ULL,
0x000000370e00720cULL, 0x000fe20003f06070ULL, 0x00000004ff3b7424ULL, 0x000fe200078e00ffULL,
0x00018ac00c3d7811ULL, 0x000fe200078e10ffULL, 0x0000000439387824ULL, 0x002fe200078e020cULL,
0x000064000e397a10ULL, 0x000fc60007ffe0ffULL, 0x0000000238387824ULL, 0x000fc800078e00ffULL,
0x0000640038387a24ULL, 0x000fc800078e0239ULL, 0x0000600038387625ULL, 0x000fca00078e003bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383d7faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000453400720cULL, 0x000fe40003f04070ULL,
0x0000000141387810ULL, 0x002fc80007ffe0ffULL, 0x0000000338397812ULL, 0x000fc800078ec0ffULL,
0x000000ff39397207ULL, 0x000fc60004000000ULL, 0x00000002ff388819ULL, 0x000fca0000011638ULL,
0x0000000143387824ULL, 0x000fc800078e0238ULL, 0x00000040383a7824ULL, 0x040fe200078e00ffULL,
0x0000004538387211ULL, 0x000fc800078ff0ffULL, 0x000000c03a3b7812ULL, 0x000fca00078ec0ffULL,
0x00000100383d7824ULL, 0x000fe200078e023bULL, 0x0000000a39387c10ULL, 0x000fc6000fffe0ffULL,
0x000000010c3b7824ULL, 0x100fe400078e023dULL, 0x0000680038397a24ULL, 0x000fe400078e023dULL,
0x00000004ff387424ULL, 0x000fe200078e00ffULL, 0x000000603b00720cULL, 0x000fe20003f06070ULL,
0x000000010c397824ULL, 0x040fe200078e0239ULL, 0x00018a000c3b7811ULL, 0x000fc600078e10ffULL,
0x0000660039387625ULL, 0x000fd000078e0038ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8000ff387f8cULL, 0x000e62000c80043fULL, 0x000000ff6a00720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff6b7224ULL, 0x002fd600078e0039ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018af800ff387f8cULL, 0x000e64000c800405ULL, 0x000000ffff3c7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018afc05ff0b7984ULL, 0x000e640008000800ULL,
0x800000000bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc8000001143bULL, 0x0000003a0b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff3a7224ULL, 0x000fca00000e063bULL, 0x000000020b0b7819ULL, 0x000fc8000000123aULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x018afc05ff0b7984ULL, 0x000e640008000800ULL, 0x800000000bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00000010320b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff387819ULL, 0x000fc80000011632ULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c38387812ULL, 0x000fca00078ec0ffULL, 0x000000010b3f7824ULL, 0x000fca00078e0238ULL,
0x018080003f3b7984ULL, 0x000e680000000800ULL, 0x018280003f3a7984ULL, 0x0004e20000000800ULL,
0x000000103b00720bULL, 0x002fe20003f1d000ULL, 0x0001e4f27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0b427812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fd200078e0010ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000013500780cULL, 0x000fe40003f05270ULL, 0x000000103b00720bULL, 0x000fe20003f34000ULL,
0x0001e4c27f007947ULL, 0x000fd8000b800000ULL, 0x00000000003d7806ULL, 0x000fc400008e0100ULL,
0x0000003b103c7209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x000099103d387816ULL, 0x000fc600000000ffULL, 0x0184803c3f008388ULL, 0x0003e20000000800ULL,
0x000000ff3800720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000003c10107221ULL, 0x002fe20000010000ULL, 0x000000ff3dff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000447308ULL, 0x000e640000000800ULL, 0x0000004411117220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0001e4227f007947ULL, 0x000fea000b800000ULL,
0x00001f6244107589ULL, 0x0002a400000e0000ULL, 0x0000001012127220ULL, 0x084fe40000410000ULL,
0x0000001013137220ULL, 0x080fe40000410000ULL, 0x0000001016167220ULL, 0x080fe40000410000ULL,
0x0000001017177220ULL, 0x080fe40000410000ULL, 0x000000101a1a7220ULL, 0x080fe40000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x000000101e1e7220ULL, 0x080fe40000410000ULL,
0x000000101f1f7220ULL, 0x080fe40000410000ULL, 0x0000001022227220ULL, 0x080fe40000410000ULL,
0x0000001023237220ULL, 0x080fe40000410000ULL, 0x0000001026267220ULL, 0x080fe40000410000ULL,
0x0000001027277220ULL, 0x000fc40000410000ULL, 0x000000102a2a7220ULL, 0x080fe40000410000ULL,
0x000000102b2b7220ULL, 0x080fe40000410000ULL, 0x000000102e2e7220ULL, 0x080fe40000410000ULL,
0x000000102f2f7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff003dff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0001e3527f007947ULL, 0x000fea000b800000ULL, 0x00001f6144107589ULL, 0x00046400000e0000ULL,
0x0000001014147220ULL, 0x082fe40000410000ULL, 0x0000001015157220ULL, 0x080fe40000410000ULL,
0x0000001018187220ULL, 0x080fe40000410000ULL, 0x0000001019197220ULL, 0x080fe40000410000ULL,
0x000000101c1c7220ULL, 0x080fe40000410000ULL, 0x000000101d1d7220ULL, 0x000fc40000410000ULL,
0x0000001020207220ULL, 0x080fe40000410000ULL, 0x0000001021217220ULL, 0x080fe40000410000ULL,
0x0000001024247220ULL, 0x080fe40000410000ULL, 0x0000001025257220ULL, 0x080fe40000410000ULL,
0x0000001028287220ULL, 0x080fe40000410000ULL, 0x0000001029297220ULL, 0x000fc40000410000ULL,
0x000000102c2c7220ULL, 0x080fe40000410000ULL, 0x000000102d2d7220ULL, 0x080fe40000410000ULL,
0x0000001030307220ULL, 0x080fe40000410000ULL, 0x0000001031317220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff42ff7812ULL, 0x000fda000780603dULL,
0x8000003c3b3b0221ULL, 0x000fe20000010000ULL, 0x00007610ff0b0816ULL, 0x000fc6000000000bULL,
0x3fb8aa3b3b3b0820ULL, 0x000fc80000410000ULL, 0x0000003b000a0308ULL, 0x000e640000000800ULL,
0x0000000a3a3a0220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x000000113a117221ULL, 0x008fe40000010000ULL, 0x000000ffff107224ULL, 0x000fc400078e003cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff0bff7812ULL, 0x000fe2000786c0ffULL,
0x0000016000017945ULL, 0x000fd80003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x0000000aff08723eULL, 0x000fc800000010ffULL, 0x00005410083a7816ULL, 0x000fe20000000008ULL,
0x0001e1b27f007947ULL, 0x000fea000b800000ULL, 0x00001f623a097589ULL, 0x0002e400000e0000ULL,
0x0001e2127f007947ULL, 0x000fea000b800000ULL, 0x00001f613a087589ULL, 0x0002a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010623f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0000b1f000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0001f0f000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018623f7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff407424ULL, 0x000fe200078e00ffULL, 0x0000b26000387802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0001f08000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000000640783bULL, 0x002e620000004200ULL, 0x00001e9000017945ULL, 0x000fe60003800000ULL,
0x000000000444783bULL, 0x004fe80000004200ULL, 0x00000000053c783bULL, 0x000ea80000004200ULL,
0x000000000338783bULL, 0x000f220000004200ULL, 0x00000018ff4d7819ULL, 0x002fe20000011443ULL,
0x0000010040797824ULL, 0x000fe200078e00ffULL, 0x0000004000cf7306ULL, 0x000fe20000009400ULL,
0x00000018ff4a7819ULL, 0x000fc40000011440ULL, 0x00000018ff4b7819ULL, 0x000fe40000011441ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000018ff7a7819ULL, 0x004fe2000001143dULL,
0x0000004d00c07306ULL, 0x000fe20000209400ULL, 0x00000018ff7f7819ULL, 0x000fe4000001143eULL,
0x00000018ff587819ULL, 0x010fe4000001143aULL, 0x00000018ff5c7819ULL, 0x000fc4000001143bULL,
0x00000018ff4c7819ULL, 0x000fe20000011442ULL, 0x0000004d00c37306ULL, 0x000fe20000205400ULL,
0x00000018ff807819ULL, 0x000fce000001143fULL, 0x0000004d005a7306ULL, 0x0003f0000020d400ULL,
0x0000007a00a37306ULL, 0x000fe20000209400ULL, 0x00000018ff4d7819ULL, 0x002fce0000011447ULL,
0x0000004d00b07306ULL, 0x000ff00000209400ULL, 0x0000004d00b17306ULL, 0x000ff00000205400ULL,
0x0000004d00747306ULL, 0x000ff0000020d400ULL, 0x0000007a00a27306ULL, 0x000ff00000205400ULL,
0x0000007a004d7306ULL, 0x000ff0000020d400ULL, 0x00000079007a7306ULL, 0x000ff00000209400ULL,
0x0000007900d17306ULL, 0x000e700000205400ULL, 0x0000005800757306ULL, 0x000ff00000209400ULL,
0x0000005800767306ULL, 0x000fe20000205400ULL, 0x000000d17a00720bULL, 0x002fce0003f5d000ULL,
0x00000058006c7306ULL, 0x000ff0000020d400ULL, 0x0000005c00777306ULL, 0x000ff00000209400ULL,
0x0000005c00787306ULL, 0x000ff00000205400ULL, 0x0000005c006d7306ULL, 0x000ff0000020d400ULL,
0x0000007f009f7306ULL, 0x000ff00000209400ULL, 0x0000007f00587306ULL, 0x000ff00000205400ULL,
0x0000007f005c7306ULL, 0x0003f0000020d400ULL, 0x0000004000ca7306ULL, 0x000ea20000005400ULL,
0x00000100417f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000007900b37306ULL, 0x000330000020d400ULL, 0x0000007f00ce7306ULL, 0x000fe20000209400ULL,
0x0000010042797824ULL, 0x002fe200078e00ffULL, 0x000000cacf00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000007f00d57306ULL, 0x000e620000205400ULL,
0x00000001b3b32812ULL, 0x010fce00078efcffULL, 0x0000004000a87306ULL, 0x000530000000d400ULL,
0x0000004a00cd7306ULL, 0x000fe20000209400ULL, 0x0001000040407824ULL, 0x004fe200078e00ffULL,
0x000000d5ce00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000004a00c87306ULL, 0x000e620000205400ULL, 0x00000001a8a86812ULL, 0x010fce00078efcffULL,
0x0000004a00a07306ULL, 0x000530000020d400ULL, 0x0000004100c47306ULL, 0x000fe20000009400ULL,
0x00000018ff4a7819ULL, 0x004fe40000011444ULL, 0x000000c8cd00720bULL, 0x002fca0003f3d000ULL,
0x0000004100c97306ULL, 0x000e700000005400ULL, 0x0000004b00c77306ULL, 0x000fe20000209400ULL,
0x00000001a0a01812ULL, 0x010fce00078efcffULL, 0x0000004b00c27306ULL, 0x000ea20000205400ULL,
0x000000c9c400720bULL, 0x002fce0003fdd000ULL, 0x0000004b009e7306ULL, 0x000330000020d400ULL,
0x0000004a00b87306ULL, 0x000fe20000209400ULL, 0x00000018ff4b7819ULL, 0x002fe40000011445ULL,
0x000000c2c700720bULL, 0x004fca0003f3d000ULL, 0x0000004a00bd7306ULL, 0x000ff00000205400ULL,
0x0000004a00887306ULL, 0x0003e2000020d400ULL, 0x000000019e9e1812ULL, 0x010fce00078efcffULL,
0x0000004200be7306ULL, 0x000fe20000009400ULL, 0x00000018ff4a7819ULL, 0x002fce0000011438ULL,
0x0000004200c57306ULL, 0x000ff00000005400ULL, 0x00000042009c7306ULL, 0x0003f0000000d400ULL,
0x0000007f00af7306ULL, 0x000522000020d400ULL, 0x0001000042427824ULL, 0x002fce00078e00ffULL,
0x0000007900d97306ULL, 0x000fe20000209400ULL, 0x00000018ff7f7819ULL, 0x004fe20000011442ULL,
0x0000010043427824ULL, 0x000fcc00078e00ffULL, 0x0000007900d27306ULL, 0x000e620000205400ULL,
0x00000001afaf2812ULL, 0x010fce00078efcffULL, 0x0000004c00cb7306ULL, 0x000ff00000209400ULL,
0x0000004c00c67306ULL, 0x000ea20000205400ULL, 0x000000d2d900720bULL, 0x002fce0003f5d000ULL,
0x0000004c005b7306ULL, 0x000330000020d400ULL, 0x0000004b00ba7306ULL, 0x000fe20000209400ULL,
0x00000018ff4c7819ULL, 0x002fe40000011446ULL, 0x000000c6cb00720bULL, 0x004fca0003f3d000ULL,
0x0000004b00c17306ULL, 0x000e700000205400ULL, 0x0000004b00847306ULL, 0x0004e2000020d400ULL,
0x000000015b5b1812ULL, 0x010fe400078efcffULL, 0x000000c3c000720bULL, 0x000fca0003f3d000ULL,
0x0000004a00527306ULL, 0x000fe20000209400ULL, 0x00000018ff4b7819ULL, 0x004fce0000011439ULL,
0x0000004a00537306ULL, 0x000fe20000205400ULL, 0x000000015a5a1812ULL, 0x000fe400078efcffULL,
0x000000bdb800720bULL, 0x000fca0003f3d000ULL, 0x0000004a00727306ULL, 0x0005f0000020d400ULL,
0x0000004000cc7306ULL, 0x000fe20000209400ULL, 0x00000018ff4a7819ULL, 0x004fe4000001143cULL,
0x0000000188881812ULL, 0x000fc400078efcffULL, 0x000000c1ba00720bULL, 0x002fe20003f3d000ULL,
0x000001003eba7824ULL, 0x000fe400078e00ffULL, 0x0000004000d37306ULL, 0x000e660000205400ULL,
0x00000018ffba7819ULL, 0x000fca00000114baULL, 0x0000004100a47306ULL, 0x000524000000d400ULL,
0x0000000184841812ULL, 0x008fcc00078efcffULL, 0x0000004c00b77306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x004fe200078e00ffULL, 0x000000d3cc00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004c00b47306ULL, 0x000e620000205400ULL,
0x00000001a4a46812ULL, 0x010fe400078efcffULL, 0x000000c5be00720bULL, 0x000fe20003fdd000ULL,
0x000001003dbe7824ULL, 0x000fc800078e00ffULL, 0x0000004c007e7306ULL, 0x000ea2000020d400ULL,
0x00000018ffbe7819ULL, 0x000fce00000114beULL, 0x0000004b00897306ULL, 0x000fe20000209400ULL,
0x000000019c9c6812ULL, 0x000fe400078efcffULL, 0x000000b4b700720bULL, 0x002fca0003f3d000ULL,
0x0000004b008a7306ULL, 0x000ff00000205400ULL, 0x0000004b006e7306ULL, 0x000fe2000020d400ULL,
0x000000017e7e1812ULL, 0x004fe400078efcffULL, 0x000000b1b000720bULL, 0x000fe20003f3d000ULL,
0x000001003bb17824ULL, 0x000fc400078e00ffULL, 0x000100003ab07824ULL, 0x000fe400078e00ffULL,
0x0000004a00b57306ULL, 0x000fe20000209400ULL, 0x00000018ffb17819ULL, 0x000fe400000114b1ULL,
0x00000018ffb07819ULL, 0x000fca00000114b0ULL, 0x0000004a00ac7306ULL, 0x000e620000205400ULL,
0x0000000174741812ULL, 0x000fce00078efcffULL, 0x0000004a004c7306ULL, 0x000eb0000020d400ULL,
0x00000080004b7306ULL, 0x000fe20000209400ULL, 0x000000acb500720bULL, 0x002fe20003f3d000ULL,
0x000100003bac7824ULL, 0x000fca00078e00ffULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x00000080004a7306ULL, 0x000fec0000205400ULL, 0x000000014c4c1812ULL, 0x004fe400078efcffULL,
0x00000080005d7306ULL, 0x0003f0000020d400ULL, 0x0000007900a17306ULL, 0x0004e2000020d400ULL,
0x00000018ff807819ULL, 0x002fce0000011442ULL, 0x0000008000e07306ULL, 0x000fe20000209400ULL,
0x0000010044797824ULL, 0x004fca00078e00ffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000008000e77306ULL, 0x000e620000205400ULL, 0x00000001a1a12812ULL, 0x008fce00078efcffULL,
0x0000004000a77306ULL, 0x000eb0000020d400ULL, 0x0000004100d07306ULL, 0x000fe20000209400ULL,
0x000000e7e000720bULL, 0x002fce0003f5d000ULL, 0x0000004100d77306ULL, 0x000e620000205400ULL,
0x00000001a7a70812ULL, 0x004fce00078efcffULL, 0x0000004300b67306ULL, 0x000ff00000009400ULL,
0x0000004300bf7306ULL, 0x000ea20000005400ULL, 0x000000d7d000720bULL, 0x002fce0003f1d000ULL,
0x0000008000427306ULL, 0x000e70000020d400ULL, 0x0000007900eb7306ULL, 0x000fe20000209400ULL,
0x000000bfb600720bULL, 0x004fce0003fdd000ULL, 0x0000007900e47306ULL, 0x000ea20000205400ULL,
0x0000000142422812ULL, 0x002fce00078efcffULL, 0x0000004100a57306ULL, 0x000e70000020d400ULL,
0x0000007f00de7306ULL, 0x000fe20000209400ULL, 0x000000e4eb00720bULL, 0x004fce0003f5d000ULL,
0x0000007f00e57306ULL, 0x000ea20000205400ULL, 0x00000001a5a50812ULL, 0x002fce00078efcffULL,
0x0000007f00407306ULL, 0x0003f0000020d400ULL, 0x0000004300597306ULL, 0x000722000000d400ULL,
0x00000100457f7824ULL, 0x002fe200078e00ffULL, 0x000000e5de00720bULL, 0x004fc80003f1d000ULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000004400bc7306ULL, 0x000fe20000009400ULL,
0x0001000043437824ULL, 0x008fca00078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004400bb7306ULL, 0x000e620000005400ULL, 0x0000000159596812ULL, 0x010fe400078efcffULL,
0x0000000140400812ULL, 0x000fe400078efcffULL, 0x000000594259723eULL, 0x000fe400000010ffULL,
0x0001280000427811ULL, 0x000fe200078e20ffULL, 0x0000007900937306ULL, 0x000eb0000020d400ULL,
0x0000007f00db7306ULL, 0x000fe20000209400ULL, 0x000000bbbc00720bULL, 0x002fce0003fdd000ULL,
0x0000007f00d47306ULL, 0x000e620000205400ULL, 0x0000000193932812ULL, 0x004fce00078efcffULL,
0x0000004300e27306ULL, 0x000ff00000209400ULL, 0x0000004300e97306ULL, 0x000ea20000205400ULL,
0x000000d4db00720bULL, 0x002fce0003f5d000ULL, 0x0000004300417306ULL, 0x0003f0000020d400ULL,
0x00000044005e7306ULL, 0x000722000000d400ULL, 0x0000010046437824ULL, 0x002fe200078e00ffULL,
0x000000e9e200720bULL, 0x004fc80003f1d000ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004500b27306ULL, 0x000fe20000009400ULL, 0x0001000044447824ULL, 0x008fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000004500b97306ULL, 0x000e620000005400ULL,
0x000000015e5e6812ULL, 0x010fe400078efcffULL, 0x0000000141410812ULL, 0x000fe400078efcffULL,
0x0000005e935e723eULL, 0x000fc600000010ffULL, 0x0000007f00947306ULL, 0x000eb0000020d400ULL,
0x0000004300da7306ULL, 0x000fe20000209400ULL, 0x000000b9b200720bULL, 0x002fce0003fdd000ULL,
0x0000004300e17306ULL, 0x000e620000205400ULL, 0x0000000194942812ULL, 0x004fce00078efcffULL,
0x0000004400e67306ULL, 0x000ff00000209400ULL, 0x0000004400ed7306ULL, 0x000ea20000205400ULL,
0x000000e1da00720bULL, 0x002fce0003f5d000ULL, 0x00000044008d7306ULL, 0x0003f0000020d400ULL,
0x00000045005f7306ULL, 0x000722000000d400ULL, 0x0000010047447824ULL, 0x002fe200078e00ffULL,
0x000000ede600720bULL, 0x004fc80003f1d000ULL, 0x00000018ff797819ULL, 0x000fe40000011444ULL,
0x0000004600577306ULL, 0x000fe20000009400ULL, 0x0001000045457824ULL, 0x008fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004600567306ULL, 0x000e620000005400ULL,
0x000000015f5f6812ULL, 0x010fe400078efcffULL, 0x000000018d8d0812ULL, 0x000fe400078efcffULL,
0x0000005f945f723eULL, 0x000fe400000010ffULL, 0x0000008d8888723eULL, 0x000fe200000010ffULL,
0x00000043008e7306ULL, 0x000eb0000020d400ULL, 0x0000007900d87306ULL, 0x000fe20000209400ULL,
0x000000565700720bULL, 0x002fc40003fdd000ULL, 0x0001280002567811ULL, 0x000fca00078e20ffULL,
0x0000007900dd7306ULL, 0x000e620000205400ULL, 0x000000018e8e2812ULL, 0x004fce00078efcffULL,
0x0000004600817306ULL, 0x0004f0000000d400ULL, 0x0000004500dc7306ULL, 0x000fe20000209400ULL,
0x0001000046467824ULL, 0x004fe200078e00ffULL, 0x000000ddd800720bULL, 0x002fc80003f5d000ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000004500e37306ULL, 0x000e620000205400ULL,
0x0000000181816812ULL, 0x008fc800078efcffULL, 0x000000818e8e723eULL, 0x000fc600000010ffULL,
0x00000045008b7306ULL, 0x0004f0000020d400ULL, 0x0000004700547306ULL, 0x000fe20000009400ULL,
0x0000010038457824ULL, 0x004fe200078e00ffULL, 0x000000e3dc00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff8f7819ULL, 0x000fe40000011445ULL, 0x0000004700557306ULL, 0x000e6e0000005400ULL,
0x000000018b8b0812ULL, 0x008fe200078efcffULL, 0x00000038004f7306ULL, 0x000ff00000009400ULL,
0x0000003800507306ULL, 0x000fe20000005400ULL, 0x000000555400720bULL, 0x002fc40003fdd000ULL,
0x000000005654783bULL, 0x000e6a0000000200ULL, 0x0000003800737306ULL, 0x0005f0000000d400ULL,
0x0000004600df7306ULL, 0x000fe20000209400ULL, 0x0001000038387824ULL, 0x004fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004600d67306ULL, 0x000eb00000205400ULL,
0x0000004600877306ULL, 0x000ef0000020d400ULL, 0x00000079008c7306ULL, 0x0008e2000020d400ULL,
0x000000d6df00720bULL, 0x004fe20003f1d000ULL, 0x000000095454b231ULL, 0x002fc400003400ffULL,
0x000000095656b231ULL, 0x000fe400003400ffULL, 0x000000085555b231ULL, 0x080fe400003400ffULL,
0x0000008f00457306ULL, 0x000fe20000209400ULL, 0x0000010039797824ULL, 0x010fe200078e00ffULL,
0x000000085757b231ULL, 0x000fc800003400ffULL, 0x0000000187870812ULL, 0x008fe400078efcffULL,
0x0000008f00467306ULL, 0x000e620000205400ULL, 0x000000018c8c2812ULL, 0x000fce00078efcffULL,
0x0000003800987306ULL, 0x000ff00000209400ULL, 0x00000038009b7306ULL, 0x000fe20000205400ULL,
0x000000464500720bULL, 0x002fe40003f5d000ULL, 0x000000415a45723eULL, 0x000fca00000010ffULL,
0x00000038007f7306ULL, 0x0003f0000020d400ULL, 0x0000003c00ad7306ULL, 0x000fe20000009400ULL,
0x000001003c387824ULL, 0x002fca00078e00ffULL, 0x00000018ffca7819ULL, 0x000fe40000011438ULL,
0x0000003c00ae7306ULL, 0x000ff00000005400ULL, 0x0000003c00487306ULL, 0x0003f0000000d400ULL,
0x00000047007b7306ULL, 0x0004e2000000d400ULL, 0x000100003c3c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000008f00867306ULL, 0x000322000020d400ULL,
0x0001000047477824ULL, 0x004fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000003c00c27306ULL, 0x000fe20000209400ULL, 0x000000017b7b6812ULL, 0x008fe200078efcffULL,
0x000001003a8f7824ULL, 0x002fe200078e00ffULL, 0x000000aead00720bULL, 0x000fc80003fdd000ULL,
0x00000018ffe87819ULL, 0x000fe2000001148fULL, 0x0000003c00c77306ULL, 0x000e620000205400ULL,
0x0000000186862812ULL, 0x010fce00078efcffULL, 0x0000004700447306ULL, 0x000fe20000209400ULL,
0x0000000148486812ULL, 0x000fce00078efcffULL, 0x0000004700437306ULL, 0x000ea20000205400ULL,
0x000000c7c200720bULL, 0x002fce0003f5d000ULL, 0x0000003900997306ULL, 0x000ff00000009400ULL,
0x00000039004e7306ULL, 0x000fe20000005400ULL, 0x000000434400720bULL, 0x004fce0003f1d000ULL,
0x0000003900717306ULL, 0x0003f0000000d400ULL, 0x0000003d00ab7306ULL, 0x000fe20000009400ULL,
0x0001000039397824ULL, 0x002fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003d00a67306ULL, 0x000e700000005400ULL, 0x0000003c00c57306ULL, 0x000eb0000020d400ULL,
0x000000be00bf7306ULL, 0x000fe20000209400ULL, 0x000000a6ab00720bULL, 0x002fce0003fdd000ULL,
0x000000be003c7306ULL, 0x000e620000205400ULL, 0x00000001c5c52812ULL, 0x004fc800078efcffULL,
0x000000c54c4c723eULL, 0x000fc600000010ffULL, 0x0000004700857306ULL, 0x0004f0000020d400ULL,
0x0000003900917306ULL, 0x000fe20000209400ULL, 0x00000018ff477819ULL, 0x004fe40000011479ULL,
0x0000003cbf00720bULL, 0x002fc40003f5d000ULL, 0x000000a8b33c723eULL, 0x000fc600000010ffULL,
0x0000003900927306ULL, 0x000fe20000205400ULL, 0x0000000185850812ULL, 0x008fc800078efcffULL,
0x000000857485723eULL, 0x000fc600000010ffULL, 0x0000003900797306ULL, 0x000ff0000020d400ULL,
0x000000ca00387306ULL, 0x000ff00000209400ULL, 0x000000ca00397306ULL, 0x000e700000205400ULL,
0x0000003d00497306ULL, 0x0004f0000000d400ULL, 0x0000003e00a97306ULL, 0x000fe20000009400ULL,
0x000100003d3d7824ULL, 0x004fe200078e00ffULL, 0x000000393800720bULL, 0x002fe20003f1d000ULL,
0x000001003f387824ULL, 0x000fe200078e00ffULL, 0x000000a59e39723eULL, 0x000fc400000010ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003e00aa7306ULL, 0x000fe20000005400ULL,
0x0000000149496812ULL, 0x008fe400078efcffULL, 0x000000a2a300720bULL, 0x000fe40003fdd000ULL,
0x00000018ffae7819ULL, 0x000fe40000011438ULL, 0x000000a7a038723eULL, 0x000fe200000010ffULL,
0x0000003e00977306ULL, 0x0003f0000000d400ULL, 0x000000be00b67306ULL, 0x000ea2000020d400ULL,
0x000100003e3e7824ULL, 0x002fe200078e00ffULL, 0x000000014d4d6812ULL, 0x000fc800078efcffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003d00b87306ULL, 0x000ff00000209400ULL,
0x0000003d00b97306ULL, 0x000e620000205400ULL, 0x00000001b6b62812ULL, 0x004fc400078efcffULL,
0x000000589f00720bULL, 0x000fe40003f5d000ULL, 0x0000009ca158723eULL, 0x000fe400000010ffULL,
0x00000049b649723eULL, 0x000fe200000010ffULL, 0x0000003f009d7306ULL, 0x000ff00000009400ULL,
0x0000003f009a7306ULL, 0x000fe20000005400ULL, 0x000000b9b800720bULL, 0x002fc40003f3d000ULL,
0x000000015c5c2812ULL, 0x000fca00078efcffULL, 0x0000003f00517306ULL, 0x0003f0000000d400ULL,
0x0000004700957306ULL, 0x000fe20000209400ULL, 0x000100003f3f7824ULL, 0x002fce00078e00ffULL,
0x0000004700967306ULL, 0x000ff00000205400ULL, 0x0000004700807306ULL, 0x000ff0000020d400ULL,
0x0000003e00437306ULL, 0x000ff00000209400ULL, 0x0000003e00447306ULL, 0x000e700000205400ULL,
0x000000ca00477306ULL, 0x000eb0000020d400ULL, 0x0000003d00b27306ULL, 0x000722000020d400ULL,
0x000000444300720bULL, 0x002fc40003fdd000ULL, 0x000000405b44723eULL, 0x000fe400000010ffULL,
0x000000004240783bULL, 0x000e620000000200ULL, 0x000000585458723cULL, 0x000fe400000418ffULL,
0x000000ba00bb7306ULL, 0x000fe20000209400ULL, 0x000000a4af3d723eULL, 0x008fe400000010ffULL,
0x00000018ffa47819ULL, 0x000fe4000001143fULL, 0x0000000147470812ULL, 0x004fc400078efcffULL,
0x000000aaa900720bULL, 0x000fe20003f1d000ULL, 0x000000ba00b47306ULL, 0x000ea20000205400ULL,
0x00000001b2b21812ULL, 0x010fe400078efcffULL, 0x000000484748723eULL, 0x000fe400000010ffULL,
0x000000b24d4d723eULL, 0x000fc600000010ffULL, 0x000000a4009e7306ULL, 0x000fe80000209400ULL,
0x0000000197970812ULL, 0x000fe400078efcffULL, 0x0000009a9d00720bULL, 0x000fe40003f1d000ULL,
0x000000a4009f7306ULL, 0x000ee20000205400ULL, 0x000000b4bb00720bULL, 0x004fce0003f3d000ULL,
0x0000003e00ad7306ULL, 0x000526000020d400ULL, 0x0000000151510812ULL, 0x000fe400078efcffULL,
0x000000504f00720bULL, 0x000fe20003f1d000ULL, 0x000000094040b231ULL, 0x082fe400003400ffULL,
0x000000ba00bc7306ULL, 0x000e62000020d400ULL, 0x0000009f9e00720bULL, 0x008fe20003f5d000ULL,
0x0000003c543c723cULL, 0x004f6200000418ffULL, 0x000000094242b231ULL, 0x000fc400003400ffULL,
0x000000084141b231ULL, 0x080fe400003400ffULL, 0x000000084343b231ULL, 0x000fe200003400ffULL,
0x000000a400a47306ULL, 0x000ea2000020d400ULL, 0x00000001adad6812ULL, 0x010fe400078efcffULL,
0x0000004a4b00720bULL, 0x000fe40003fdd000ULL, 0x000000ad5c5c723eULL, 0x000fe200000010ffULL,
0x000000485448723cULL, 0x000fe200000418ffULL, 0x0000000173730812ULL, 0x000fe200078efcffULL,
0x000000ae00467306ULL, 0x000fe20000209400ULL, 0x00000001bcbc1812ULL, 0x002fc400078efcffULL,
0x000000969500720bULL, 0x000fe40003f1d000ULL, 0x00000097bc50723eULL, 0x000fe400000010ffULL,
0x000000738686723eULL, 0x000fe200000010ffULL, 0x000000ae00a97306ULL, 0x000e620000205400ULL,
0x00000001a4a42812ULL, 0x004fe200078efcffULL, 0x0000005e403c723cULL, 0x020fe2000004183cULL,
0x000000535200720bULL, 0x000fe40003f5d000ULL, 0x000000015d5d6812ULL, 0x000fc400078efcffULL,
0x0000009b9800720bULL, 0x000fe20003fdd000ULL, 0x000000ae00ae7306ULL, 0x000ea2000020d400ULL,
0x000000a45d5d723eULL, 0x000fe400000010ffULL, 0x0000000180800812ULL, 0x000fe400078efcffULL,
0x000000a94600720bULL, 0x002fc60003f3d000ULL, 0x000000b1009a7306ULL, 0x000fe20000209400ULL,
0x0000000172722812ULL, 0x000fe200078efcffULL, 0x000000445444723cULL, 0x000f6200000418ffULL,
0x000000929100720bULL, 0x000fe40003f5d000ULL, 0x000000017f7f6812ULL, 0x000fe400078efcffULL,
0x0000008a8900720bULL, 0x000fe20003fdd000ULL, 0x000000b100977306ULL, 0x000e620000205400ULL,
0x0000008b8489723eULL, 0x000fe400000010ffULL, 0x000000877e84723eULL, 0x000fc400000010ffULL,
0x00000001aeae1812ULL, 0x004fe400078efcffULL, 0x0000004e9900720bULL, 0x000fe20003f3d000ULL,
0x0000003b007c7306ULL, 0x000fe20000009400ULL, 0x00000051ae51723eULL, 0x000fe200000010ffULL,
0x0000004c544c723cULL, 0x040f6200000418ffULL, 0x0000000179792812ULL, 0x000fe400078efcffULL,
0x000000016e6e6812ULL, 0x000fe400078efcffULL, 0x0000007f7272723eULL, 0x000fe200000010ffULL,
0x0000003b007d7306ULL, 0x000ea20000005400ULL, 0x000000979a00720bULL, 0x002fe20003f5d000ULL,
0x000000505450723cULL, 0x000fe200000418ffULL, 0x000000796e73723eULL, 0x000fc400000010ffULL,
0x0000000171711812ULL, 0x000fc600078efcffULL, 0x0000003a00827306ULL, 0x000fe20000009400ULL,
0x000000718087723eULL, 0x000fe200000010ffULL, 0x000000844044723cULL, 0x060fec0000041844ULL,
0x0000003a00837306ULL, 0x000e620000005400ULL, 0x0000007d7c00720bULL, 0x004fe20003fdd000ULL,
0x000000864048723cULL, 0x040fec0000041848ULL, 0x000000e8008f7306ULL, 0x000fe40000209400ULL,
0x00000072404c723cULL, 0x000fec000004184cULL, 0x000000e800907306ULL, 0x000ea20000205400ULL,
0x000000838200720bULL, 0x002fce0003f3d000ULL, 0x0000003a006f7306ULL, 0x000e70000000d400ULL,
0x0000003b00707306ULL, 0x000722000000d400ULL, 0x000000908f00720bULL, 0x004fe40003f1d000ULL,
0x0000007b8c8f723eULL, 0x000fca00000010ffULL, 0x000000b100997306ULL, 0x000ea2000020d400ULL,
0x000000385438723cULL, 0x008f6200000418ffULL, 0x000000016f6f1812ULL, 0x002fe400078efcffULL,
0x000000787700720bULL, 0x000fc80003f3d000ULL, 0x000000b000937306ULL, 0x000fe20000209400ULL,
0x0000005c5454723cULL, 0x000b6200000418ffULL, 0x0000000170706812ULL, 0x010fcc00078efcffULL,
0x000000b0005c7306ULL, 0x020e620000205400ULL, 0x0000000199992812ULL, 0x004fe200078efcffULL,
0x0000008e4058723cULL, 0x040b620000041858ULL, 0x000000016d6d1812ULL, 0x000fe400078efcffULL,
0x00000070997b723eULL, 0x000fe400000010ffULL, 0x0000006a6100720cULL, 0x000fe20003f26070ULL,
0x000000ac005e7306ULL, 0x000fe40000209400ULL, 0x000000884038723cULL, 0x000b6c0000041838ULL,
0x000000ac005f7306ULL, 0x000ea20000205400ULL, 0x0000005c9300720bULL, 0x002fc40003f5d000ULL,
0x000000016a5c7810ULL, 0x000fc80007ffe0ffULL, 0x0000005c6100720cULL, 0x000fe20004f26470ULL,
0x000000e8007a7306ULL, 0x000e70000020d400ULL, 0x000000b0005d7306ULL, 0x000ee2000020d400ULL,
0x0000005f5e00720bULL, 0x004fce0003fdd000ULL, 0x000000ac00ac7306ULL, 0x000ea2000020d400ULL,
0x000000017a7a0812ULL, 0x002fe400078efcffULL, 0x000000767500720bULL, 0x000fe40003f1d000ULL,
0x0000006f7a7a723eULL, 0x000fe400000010ffULL, 0x000000015d5d2812ULL, 0x008fe400078efcffULL,
0x0000006a6200720cULL, 0x000fc60003f46070ULL, 0x0000007a4050723cULL, 0x000b620000041850ULL,
0x0000005c6200720cULL, 0x000fe40005746470ULL, 0x00000001acac6812ULL, 0x004fe400078efcffULL,
0x0000000f3400720cULL, 0x000fe40003fc3070ULL, 0x000000016c6c0812ULL, 0x000fe400078efcffULL,
0x000000ac6d6d723eULL, 0x000fe400000010ffULL, 0x0000005d6c6c723eULL, 0x000fc400000010ffULL,
0x0000000f3400720cULL, 0x000fca0003f03070ULL, 0x0000006c4054723cULL, 0x000b620000041854ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000003c12127221ULL, 0x000fe40000010000ULL, 0x0000003d13137221ULL, 0x000fe40000010000ULL,
0x0000003816167221ULL, 0x020fe40000010000ULL, 0x0000003917177221ULL, 0x000fe40000010000ULL,
0x000000581a1a7221ULL, 0x000fe40000010000ULL, 0x000000591b1b7221ULL, 0x000fc40000010000ULL,
0x000000441e1e7221ULL, 0x000fe40000010000ULL, 0x000000451f1f7221ULL, 0x000fe40000010000ULL,
0x0000004822227221ULL, 0x000fe40000010000ULL, 0x0000004923237221ULL, 0x000fe40000010000ULL,
0x0000004c26267221ULL, 0x000fe40000010000ULL, 0x0000004d27277221ULL, 0x000fc40000010000ULL,
0x000000502a2a7221ULL, 0x000fe40000010000ULL, 0x000000512b2b7221ULL, 0x000fe40000010000ULL,
0x000000542e2e7221ULL, 0x000fe40000010000ULL, 0x000000552f2f7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000003e14147221ULL, 0x000fe40000010000ULL,
0x0000003f15157221ULL, 0x000fe40000010000ULL, 0x0000003a18187221ULL, 0x020fc40000010000ULL,
0x0000003b19197221ULL, 0x000fe40000010000ULL, 0x0000005a1c1c7221ULL, 0x000fe40000010000ULL,
0x0000005b1d1d7221ULL, 0x000fe40000010000ULL, 0x0000004620207221ULL, 0x000fe40000010000ULL,
0x0000004721217221ULL, 0x000fe40000010000ULL, 0x0000004a24247221ULL, 0x000fc40000010000ULL,
0x0000004b25257221ULL, 0x000fe40000010000ULL, 0x0000004e28287221ULL, 0x000fe40000010000ULL,
0x0000004f29297221ULL, 0x000fe40000010000ULL, 0x000000522c2c7221ULL, 0x000fe40000010000ULL,
0x000000532d2d7221ULL, 0x000fe40000010000ULL, 0x0000005630307221ULL, 0x000fc40000010000ULL,
0x0000005731317221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x020e62000c80043fULL,
0x00000002ff3b7819ULL, 0x000fe2000001165cULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000f3400720cULL, 0x000fe40003fc3070ULL, 0x0000003b5c3b7207ULL, 0x040fe40002800000ULL,
0x000000035c5c7812ULL, 0x000fe400078ec0ffULL, 0x0000000f3400720cULL, 0x000fe40003f03070ULL,
0x00000040ff567803ULL, 0x000fc40000000000ULL, 0x000000ff5c5c7207ULL, 0x000fe40006800000ULL,
0x000000013b387810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3f7224ULL, 0x000fc600078e0039ULL,
0x0000000338417812ULL, 0x040fe400078ec0ffULL, 0x0000000f38437211ULL, 0x000fc400078ff0ffULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b8400ff3a7984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe200078c486bULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8400ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe400078c486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x018b8c00ff3a7984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000143397810ULL, 0x040fe20007ffe0ffULL,
0x0000000443387824ULL, 0x000fe200078e0241ULL, 0x0000097000017945ULL, 0x000fe40003800000ULL,
0x000000363900720cULL, 0x000fe20003fc6070ULL, 0x00000040383d7824ULL, 0x000fca00078e00ffULL,
0x0000004033407812ULL, 0x000fce00078ef83dULL, 0x000004f00000e947ULL, 0x000fea0003800000ULL,
0x0000000507457c10ULL, 0x040fe2000fffe0ffULL, 0x00000100ff477424ULL, 0x000fe200078e00ffULL,
0x00000002074d7810ULL, 0x000fe20007ffe0ffULL, 0x00000010323a7824ULL, 0x000fe400078e00ffULL,
0x018a0000453c7984ULL, 0x000e620000004800ULL, 0x0000000145387824ULL, 0x000fe200078e0240ULL,
0x000000054d4f7c10ULL, 0x000fe4000fffe0ffULL, 0x000000f03a497812ULL, 0x000fe200078ec0ffULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc400078e0238ULL,
0x00000010453c7824ULL, 0x000fe400078e00ffULL, 0x00005e0038387625ULL, 0x000fca00078e0047ULL,
0x00000049383a7210ULL, 0x000fe40007fde0ffULL, 0x0000003d60387217ULL, 0x000fc60007800000ULL,
0x000000ffff3b7224ULL, 0x000fe400030e0639ULL, 0x0000000138387824ULL, 0x000fe400078e0a3dULL,
0x0000000145397824ULL, 0x000fc600078e0232ULL, 0x0000000538387c17ULL, 0x000fe4000f800000ULL,
0xfffffff03c397812ULL, 0x000fe400078ee239ULL, 0x80000005383e7c10ULL, 0x000fe4000fffe0ffULL,
0x00014000394b7811ULL, 0x000fe200078e20ffULL, 0x000000014f397824ULL, 0x000fe200078e0240ULL,
0x0000003e0700720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a4b7faeULL, 0x0003e8000f101c50ULL, 0x018a0800453f7984ULL, 0x000ea80000004800ULL,
0x018ac0003f387984ULL, 0x004ea40000004800ULL, 0x000000380d387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383c7210ULL, 0x000fe20007fde0ffULL,
0x000000014f387824ULL, 0x040fe400078e0232ULL, 0x000000104f4f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x0000003e4d00720cULL, 0x000fe40003fc6070ULL,
0xfffffff04f387812ULL, 0x000fe400078ee238ULL, 0x00000004074d7810ULL, 0x000fc40007ffe0ffULL,
0x00014000384b7811ULL, 0x002fe400078e20ffULL, 0x000000054d4f7c10ULL, 0x000fca000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c4b7faeULL, 0x0003e2000f101c50ULL,
0x000000014f397824ULL, 0x000fc600078e0240ULL, 0x018a1000453f7984ULL, 0x000ea80000004800ULL,
0x018ac0003f387984ULL, 0x0044e40000004800ULL, 0x00000006073f7810ULL, 0x004fc80007ffe0ffULL,
0x000000053f4b7c10ULL, 0x002fe2000fffe0ffULL, 0x000000380d387224ULL, 0x008fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe20007fde0ffULL,
0x000000014f387824ULL, 0x040fe400078e0232ULL, 0x000000104f4f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x0000003e4d00720cULL, 0x000fe40003fc6070ULL,
0xfffffff04f387812ULL, 0x000fc800078ee238ULL, 0x00014000383d7811ULL, 0x000fe200078e20ffULL,
0x000000014b387824ULL, 0x040fe400078e0240ULL, 0x000000014b407824ULL, 0x040fe400078e0232ULL,
0x000000104b4b7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e6000f101c50ULL, 0xfffffff04b407812ULL, 0x000fe200078ee240ULL,
0x018a1800453c7984ULL, 0x000ea60000004800ULL, 0x00014000403b7811ULL, 0x002fe200078e20ffULL,
0x018ac0003c3c7984ULL, 0x004e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x0000004938387210ULL, 0x000fca0007fde0ffULL,
0x000000ffff397224ULL, 0x000fe200030e0639ULL, 0x0000003e3f00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e2000f101c50ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x00000005073f7c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff457424ULL, 0x000fe400078e00ffULL, 0x00000010323a7824ULL, 0x000fe200078e00ffULL,
0x000000023f4b7810ULL, 0x040fe20007ffe0ffULL, 0x018a00003f3c7984ULL, 0x000e620000004800ULL,
0x000000013f387824ULL, 0x000fe400078e0240ULL, 0x000000f03a477812ULL, 0x000fe200078ec0ffULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fe20007fde0ffULL,
0x000000013f387824ULL, 0x000fc800078e0232ULL, 0x000000ffff3b7224ULL, 0x000fe400030e0639ULL,
0x000000103f397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0001400038497811ULL, 0x000fe200078e20ffULL, 0x000000014b387824ULL, 0x000fc800078e0240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a497faeULL, 0x0003e8000b901c50ULL,
0x018a08003f3e7984ULL, 0x000ea80000004800ULL, 0x018ac0003e3e7984ULL, 0x004ea40000004800ULL,
0x0000003e0d387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383c7210ULL, 0x000fe20007fde0ffULL, 0x000000014b387824ULL, 0x040fe400078e0232ULL,
0x000000104b4b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff3d7224ULL, 0x000fc600030e0639ULL,
0xfffffff04b387812ULL, 0x000fe400078ee238ULL, 0x000000043f4b7810ULL, 0x000fe40007ffe0ffULL,
0x0001400038497811ULL, 0x002fc600078e20ffULL, 0x000000014b387824ULL, 0x000fe400078e0240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c497faeULL, 0x0003e8000b901c50ULL,
0x018a10003f3e7984ULL, 0x000ea20000004800ULL, 0x000000063f497810ULL, 0x002fc60007ffe0ffULL,
0x018ac0003e3e7984ULL, 0x004e640000004800ULL, 0x0000003e0d387224ULL, 0x002fe400078e0238ULL,
0x00000001493e7824ULL, 0x000fe400078e0232ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383a7210ULL, 0x000fe20007fde0ffULL, 0x000000014b387824ULL, 0x040fe400078e0232ULL,
0x000000104b4b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff3b7224ULL, 0x000fc600030e0639ULL,
0xfffffff04b387812ULL, 0x000fc800078ee238ULL, 0x00014000383d7811ULL, 0x000fe200078e20ffULL,
0x0000000149387824ULL, 0x040fe400078e0240ULL, 0x0000001049497824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e6000b901c50ULL,
0xfffffff0493e7812ULL, 0x000fe200078ee23eULL, 0x018a18003f3c7984ULL, 0x000ea60000004800ULL,
0x000140003e3b7811ULL, 0x002fe200078e20ffULL, 0x018ac0003c3c7984ULL, 0x004e640000004800ULL,
0x0000003c0d387224ULL, 0x002fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x0000004738387210ULL, 0x000fca0007fde0ffULL, 0x000000ffff397224ULL, 0x000fca00030e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e6000b901c50ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff387f8cULL, 0x002e64000c80043fULL, 0x000000ffff3f7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b8c00ff3a7984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000433400720cULL, 0x000fe20003fc4070ULL,
0x00000004ff3a7424ULL, 0x000fe200078e00ffULL, 0x00018a000c3d7811ULL, 0x000fe400078e10ffULL,
0x000000ff5c387207ULL, 0x000fc40003000000ULL, 0x000000ff5c5c7207ULL, 0x000fc60007000000ULL,
0x0000000141387824ULL, 0x000fc800078e0238ULL, 0x0000004038397824ULL, 0x040fe200078e00ffULL,
0x0000004338387211ULL, 0x000fc800078ff0ffULL, 0x000000c039397812ULL, 0x000fca00078ec0ffULL,
0x0000010038387824ULL, 0x000fe200078e0239ULL, 0x0000000a5c397c10ULL, 0x000fc8000fffe0ffULL,
0x0000002038387810ULL, 0x000fca0007ffe0ffULL, 0x000000010c3b7824ULL, 0x100fe400078e0238ULL,
0x0000680039397a24ULL, 0x000fc600078e0238ULL, 0x000000603b00720cULL, 0x000fe20003fc6070ULL,
0x000000010c397824ULL, 0x000fc800078e0239ULL, 0x0000660039387625ULL, 0x000fd000078e003aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383d7faeULL, 0x0003e4000f121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b7800ff387f8cULL, 0x000e62000c80043fULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x000000ffff6b7224ULL, 0x002fe200078e0039ULL,
0x0000014000003947ULL, 0x000fea0003800000ULL, 0x0000000aff08723eULL, 0x000fc800000010ffULL,
0x00005410083a7816ULL, 0x000fe20000000008ULL, 0x0001ad827f007947ULL, 0x000fea000b800000ULL,
0x00001f623a097589ULL, 0x0002a400000e0000ULL, 0x0001ade27f007947ULL, 0x000fea000b800000ULL,
0x00001f613a087589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010623f7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x0000e72000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0001bbc000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3e7224ULL, 0x004fe200078e003aULL,
0x00000018623f7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff407424ULL, 0x000fe200078e00ffULL,
0x0000e79000387802ULL, 0x000fe20000000f00ULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0001bb5000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000663c783bULL, 0x006e620000004200ULL,
0x00001e3000017945ULL, 0x000fe60003800000ULL, 0x000000006540783bULL, 0x000ea80000004200ULL,
0x000000006444783bULL, 0x000f220000004200ULL, 0x0000003c00387306ULL, 0x002ff00000009400ULL,
0x0000003c00397306ULL, 0x000e700000005400ULL, 0x0000003c004c7306ULL, 0x000ee2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000003d004d7306ULL, 0x000ff0000000d400ULL,
0x0000003d00387306ULL, 0x000fe20000009400ULL, 0x000000014c4c6812ULL, 0x008fce00078efcffULL,
0x0000003d00397306ULL, 0x000e700000005400ULL, 0x0000003e004b7306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000003f004a7306ULL, 0x000ff0000000d400ULL,
0x0000003e00387306ULL, 0x000fe20000009400ULL, 0x000000014d4d6812ULL, 0x000fce00078efcffULL,
0x0000003e00397306ULL, 0x000e700000005400ULL, 0x0000004000497306ULL, 0x004fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004100487306ULL, 0x000ff0000000d400ULL,
0x0000003f00387306ULL, 0x000fe20000009400ULL, 0x000000014b4b6812ULL, 0x000fce00078efcffULL,
0x0000003f00397306ULL, 0x000e700000005400ULL, 0x00000042007a7306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004300787306ULL, 0x000ff0000000d400ULL,
0x0000004000387306ULL, 0x000fe20000009400ULL, 0x000000014a4a6812ULL, 0x000fce00078efcffULL,
0x0000004000397306ULL, 0x000e700000005400ULL, 0x0000004400767306ULL, 0x010fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004500757306ULL, 0x000ff0000000d400ULL,
0x0000004100387306ULL, 0x000fe20000009400ULL, 0x0000000149496812ULL, 0x000fce00078efcffULL,
0x0000004100397306ULL, 0x000e700000005400ULL, 0x0000004600727306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004700707306ULL, 0x000ff0000000d400ULL,
0x0000004200387306ULL, 0x000fe20000009400ULL, 0x0000000148486812ULL, 0x000fce00078efcffULL,
0x0000004200397306ULL, 0x000e640000005400ULL, 0x000000393800720bULL, 0x002fcc0003fdd000ULL,
0x0000004300387306ULL, 0x000ff00000009400ULL, 0x0000004300397306ULL, 0x000e620000005400ULL,
0x000000017a7a6812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004400387306ULL, 0x000ff00000009400ULL, 0x0000004400397306ULL, 0x000e620000005400ULL,
0x0000000178786812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004500387306ULL, 0x000ff00000009400ULL, 0x0000004500397306ULL, 0x000e620000005400ULL,
0x0000000176766812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004600387306ULL, 0x000ff00000009400ULL, 0x0000004600397306ULL, 0x000e620000005400ULL,
0x0000000175756812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004700387306ULL, 0x000ff00000009400ULL, 0x0000004700397306ULL, 0x000e620000005400ULL,
0x0000000172726812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fc40003fdd000ULL,
0x000000006338783bULL, 0x000e760000004200ULL, 0x0000000170706812ULL, 0x000fe200078efcffULL,
0x00000038004e7306ULL, 0x002fe20000009400ULL, 0x00000018ff577819ULL, 0x000fce000001143aULL,
0x00000038004f7306ULL, 0x000e700000005400ULL, 0x00000038006e7306ULL, 0x000ea2000000d400ULL,
0x0000004f4e00720bULL, 0x002fce0003fdd000ULL, 0x00000039006d7306ULL, 0x000ff0000000d400ULL,
0x00000039004e7306ULL, 0x000fe20000009400ULL, 0x000000016e6e6812ULL, 0x004fce00078efcffULL,
0x00000039004f7306ULL, 0x000e700000005400ULL, 0x0000003a006c7306ULL, 0x000fe2000000d400ULL,
0x0000004f4e00720bULL, 0x002fce0003fdd000ULL, 0x00000057006f7306ULL, 0x000ff0000020d400ULL,
0x0000003a004e7306ULL, 0x000fe20000009400ULL, 0x000000016d6d6812ULL, 0x000fce00078efcffULL,
0x0000003a004f7306ULL, 0x000e640000005400ULL, 0x0000004f4e00720bULL, 0x002fe40003fdd000ULL,
0x00000018ff4e7819ULL, 0x000fc8000001143cULL, 0x0000004e004f7306ULL, 0x000fee0000209400ULL,
0x000000016c6c6812ULL, 0x000fe200078efcffULL, 0x0000004e00507306ULL, 0x000e700000205400ULL,
0x0000004e00517306ULL, 0x000ea2000020d400ULL, 0x000000504f00720bULL, 0x002fc40003fdd000ULL,
0x00000018ff4f7819ULL, 0x000fca000001143dULL, 0x0000004f00527306ULL, 0x000fec0000209400ULL,
0x0000000151516812ULL, 0x004fe400078efcffULL, 0x0000004f00537306ULL, 0x000e700000205400ULL,
0x0000004f00507306ULL, 0x000ea2000020d400ULL, 0x000000535200720bULL, 0x002fc40003fdd000ULL,
0x00000018ff527819ULL, 0x000fca000001143eULL, 0x0000005200537306ULL, 0x000fec0000209400ULL,
0x0000000150506812ULL, 0x004fe400078efcffULL, 0x0000005200547306ULL, 0x000e700000205400ULL,
0x00000052004e7306ULL, 0x000ea2000020d400ULL, 0x000000545300720bULL, 0x002fc40003fdd000ULL,
0x00000018ff537819ULL, 0x000fca000001143fULL, 0x0000005300547306ULL, 0x000fec0000209400ULL,
0x000000014e4e6812ULL, 0x004fe400078efcffULL, 0x0000005300557306ULL, 0x000e700000205400ULL,
0x00000053004f7306ULL, 0x0004e2000020d400ULL, 0x000000555400720bULL, 0x002fc40003fdd000ULL,
0x00000018ff547819ULL, 0x000fe40000011440ULL, 0x00000018ff537819ULL, 0x004fc60000011442ULL,
0x0000005400557306ULL, 0x000fec0000209400ULL, 0x000000014f4f6812ULL, 0x008fe400078efcffULL,
0x0000005400527306ULL, 0x000e700000205400ULL, 0x00000054007f7306ULL, 0x000ea2000020d400ULL,
0x000000525500720bULL, 0x002fce0003fdd000ULL, 0x0000005300547306ULL, 0x000fe20000205400ULL,
0x00000018ff527819ULL, 0x000fce0000011441ULL, 0x0000005200557306ULL, 0x000fe20000209400ULL,
0x000000017f7f6812ULL, 0x004fce00078efcffULL, 0x0000005200587306ULL, 0x000e700000205400ULL,
0x00000052007e7306ULL, 0x000ea2000020d400ULL, 0x000000585500720bULL, 0x002fce0003fdd000ULL,
0x00000053007c7306ULL, 0x000ff0000020d400ULL, 0x0000005300557306ULL, 0x0002e20000209400ULL,
0x000000017e7e6812ULL, 0x004fe400078efcffULL, 0x00000018ff537819ULL, 0x002fca0000011445ULL,
0x0000005300797306ULL, 0x000fe2000020d400ULL, 0x000000545500720bULL, 0x008fe40003fdd000ULL,
0x00000018ff547819ULL, 0x000fca0000011443ULL, 0x0000005400557306ULL, 0x000fec0000209400ULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x0000005400527306ULL, 0x000e700000205400ULL,
0x00000054007d7306ULL, 0x000ea2000020d400ULL, 0x000000525500720bULL, 0x002fce0003fdd000ULL,
0x0000005300547306ULL, 0x000fe20000205400ULL, 0x00000018ff527819ULL, 0x000fce0000011444ULL,
0x0000005200557306ULL, 0x000fe20000209400ULL, 0x000000017d7d6812ULL, 0x004fce00078efcffULL,
0x0000005200587306ULL, 0x000e700000205400ULL, 0x00000052007b7306ULL, 0x000ea2000020d400ULL,
0x000000585500720bULL, 0x002fce0003fdd000ULL, 0x0000005300557306ULL, 0x0002e40000209400ULL,
0x00000018ff537819ULL, 0x002fc80000011438ULL, 0x000000017b7b6812ULL, 0x004fe400078efcffULL,
0x0000005300737306ULL, 0x000fe2000020d400ULL, 0x000000545500720bULL, 0x008fe40003fdd000ULL,
0x00000018ff547819ULL, 0x000fca0000011446ULL, 0x0000005400557306ULL, 0x000fec0000209400ULL,
0x0000000179796812ULL, 0x000fe400078efcffULL, 0x0000005400527306ULL, 0x000e700000205400ULL,
0x0000005400777306ULL, 0x000ea2000020d400ULL, 0x000000525500720bULL, 0x002fce0003fdd000ULL,
0x0000005300547306ULL, 0x000fe20000205400ULL, 0x00000018ff527819ULL, 0x000fce0000011447ULL,
0x0000005200557306ULL, 0x000fe20000209400ULL, 0x0000000177776812ULL, 0x004fce00078efcffULL,
0x0000005200587306ULL, 0x000e700000205400ULL, 0x0000005200747306ULL, 0x000ea2000020d400ULL,
0x000000585500720bULL, 0x002fce0003fdd000ULL, 0x0000005300557306ULL, 0x000e700000209400ULL,
0x0000005700537306ULL, 0x000fe20000205400ULL, 0x0000000174746812ULL, 0x004fe400078efcffULL,
0x000000545500720bULL, 0x002fc40003fdd000ULL, 0x00000018ff547819ULL, 0x000fc80000011439ULL,
0x0000005400557306ULL, 0x000fee0000209400ULL, 0x0000000173736812ULL, 0x000fe200078efcffULL,
0x0000005400527306ULL, 0x000e700000205400ULL, 0x0000005400717306ULL, 0x000ea2000020d400ULL,
0x000000525500720bULL, 0x002fce0003fdd000ULL, 0x0000005700527306ULL, 0x000e6c0000209400ULL,
0x0000000171716812ULL, 0x004fe400078efcffULL, 0x000000535200720bULL, 0x002fe20003fdd000ULL,
0x000001003c527824ULL, 0x040fe400078e00ffULL, 0x000100003c3c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff527819ULL, 0x000fc80000011452ULL, 0x0000005200547306ULL, 0x000fe60000209400ULL,
0x000000016f6f6812ULL, 0x000fca00078efcffULL, 0x0000005200557306ULL, 0x000e700000205400ULL,
0x0000005200537306ULL, 0x000ea2000020d400ULL, 0x000000555400720bULL, 0x002fe40003fdd000ULL,
0x00000018ff557819ULL, 0x000fca000001143cULL, 0x00000055003c7306ULL, 0x000fec0000209400ULL,
0x0000000153536812ULL, 0x004fe400078efcffULL, 0x0000005500577306ULL, 0x000e640000205400ULL,
0x0000004c534c723eULL, 0x000fcc00000010ffULL, 0x0000005500547306ULL, 0x000ea2000020d400ULL,
0x000000573c00720bULL, 0x002fe20003fdd000ULL, 0x000001003d3c7824ULL, 0x040fe400078e00ffULL,
0x000100003d3d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff527819ULL, 0x000fe4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005200577306ULL, 0x000fe60000209400ULL,
0x0000000154546812ULL, 0x004fc800078efcffULL, 0x000000545154723eULL, 0x000fe200000010ffULL,
0x0000005200587306ULL, 0x000e700000205400ULL, 0x00000052003c7306ULL, 0x000ea2000020d400ULL,
0x000000585700720bULL, 0x002fce0003fdd000ULL, 0x0000003d00557306ULL, 0x000ff0000020d400ULL,
0x0000003d00577306ULL, 0x000fe20000209400ULL, 0x000000013c3c6812ULL, 0x004fce00078efcffULL,
0x0000003d00587306ULL, 0x000e620000205400ULL, 0x0000004d3c4d723eULL, 0x000fe400000010ffULL,
0x00012800673c7811ULL, 0x000fe400078e20ffULL, 0x000000585700720bULL, 0x002fe20003fdd000ULL,
0x000001003e577824ULL, 0x040fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000005700587306ULL, 0x000fe60000209400ULL, 0x0000000155556812ULL, 0x000fc800078efcffULL,
0x000000555055723eULL, 0x000fe200000010ffULL, 0x0000005700597306ULL, 0x000e700000205400ULL,
0x0000005700527306ULL, 0x000ea2000020d400ULL, 0x000000595800720bULL, 0x002fce0003fdd000ULL,
0x0000003e003d7306ULL, 0x000ff0000020d400ULL, 0x0000003e00587306ULL, 0x000fe20000209400ULL,
0x0000000152526812ULL, 0x004fce00078efcffULL, 0x0000003e00597306ULL, 0x000e620000205400ULL,
0x0000004b5250723eULL, 0x000fe400000010ffULL, 0x000000595800720bULL, 0x002fe20003fdd000ULL,
0x000001003f587824ULL, 0x040fe400078e00ffULL, 0x000100003f3f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000005800577306ULL, 0x000fe60000209400ULL, 0x000000013d3d6812ULL, 0x000fc800078efcffULL,
0x0000003d4e4e723eULL, 0x000fe200000010ffULL, 0x00000058005a7306ULL, 0x000e700000205400ULL,
0x0000005800817306ULL, 0x000ea2000020d400ULL, 0x0000005a5700720bULL, 0x002fce0003fdd000ULL,
0x0000003f003e7306ULL, 0x000ff0000020d400ULL, 0x0000003f00577306ULL, 0x000fe20000209400ULL,
0x0000000181816812ULL, 0x004fce00078efcffULL, 0x0000003f005a7306ULL, 0x000e620000205400ULL,
0x0000004a8151723eULL, 0x000fe400000010ffULL, 0x0000005a5700720bULL, 0x002fe20003fdd000ULL,
0x0000010040577824ULL, 0x040fe400078e00ffULL, 0x0001000040407824ULL, 0x000fc600078e00ffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff3f7819ULL, 0x000fe40000011440ULL,
0x0000005700587306ULL, 0x000fe60000209400ULL, 0x000000013e3e6812ULL, 0x000fc800078efcffULL,
0x0000003e4f4f723eULL, 0x000fe200000010ffULL, 0x0000005700597306ULL, 0x000e700000205400ULL,
0x0000005700807306ULL, 0x000ea2000020d400ULL, 0x000000595800720bULL, 0x002fce0003fdd000ULL,
0x0000003f00407306ULL, 0x000ff0000020d400ULL, 0x0000003f00587306ULL, 0x000fe20000209400ULL,
0x0000000180806812ULL, 0x004fce00078efcffULL, 0x0000003f00597306ULL, 0x000e620000205400ULL,
0x00000049804a723eULL, 0x000fe400000010ffULL, 0x000000595800720bULL, 0x002fe20003fdd000ULL,
0x0000010041587824ULL, 0x040fe400078e00ffULL, 0x0001000041417824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000018ff3f7819ULL, 0x000fe40000011441ULL,
0x0000005800577306ULL, 0x000fe60000209400ULL, 0x0000000140406812ULL, 0x000fc800078efcffULL,
0x000000407f40723eULL, 0x000fe200000010ffULL, 0x00000058005a7306ULL, 0x000e700000205400ULL,
0x0000005800877306ULL, 0x000ea2000020d400ULL, 0x0000005a5700720bULL, 0x002fce0003fdd000ULL,
0x0000003f00417306ULL, 0x000ff0000020d400ULL, 0x0000003f00577306ULL, 0x000fe20000209400ULL,
0x0000000187876812ULL, 0x004fce00078efcffULL, 0x0000003f005a7306ULL, 0x000e620000205400ULL,
0x00000048874b723eULL, 0x000fce00000010ffULL, 0x0000003b007f7306ULL, 0x000fe20000005400ULL,
0x0000005a5700720bULL, 0x002fe20003fdd000ULL, 0x0000010042577824ULL, 0x040fe400078e00ffULL,
0x0001000042427824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x0000005700587306ULL, 0x000fe60000209400ULL,
0x0000000141416812ULL, 0x000fc800078efcffULL, 0x000000417e41723eULL, 0x000fe200000010ffULL,
0x0000005700597306ULL, 0x000e700000205400ULL, 0x0000005700857306ULL, 0x000ea2000020d400ULL,
0x000000595800720bULL, 0x002fce0003fdd000ULL, 0x00000042003f7306ULL, 0x000ff00000209400ULL,
0x0000004200587306ULL, 0x000e620000205400ULL, 0x0000000185856812ULL, 0x004fce00078efcffULL,
0x0000004200837306ULL, 0x000ea2000020d400ULL, 0x000000583f00720bULL, 0x002fe20003fdd000ULL,
0x00000100433f7824ULL, 0x040fe400078e00ffULL, 0x0001000043437824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000003f00577306ULL, 0x000fe60000209400ULL, 0x0000000183836812ULL, 0x004fc800078efcffULL,
0x000000837c7c723eULL, 0x000fe200000010ffULL, 0x0000003f00587306ULL, 0x000e700000205400ULL,
0x0000003f00897306ULL, 0x000ea2000020d400ULL, 0x000000585700720bULL, 0x002fce0003fdd000ULL,
0x0000004300427306ULL, 0x000ff00000209400ULL, 0x0000004300577306ULL, 0x000e620000205400ULL,
0x0000000189896812ULL, 0x004fce00078efcffULL, 0x0000004300887306ULL, 0x000ea2000020d400ULL,
0x000000574200720bULL, 0x002fe20003fdd000ULL, 0x0000010044427824ULL, 0x040fe400078e00ffULL,
0x0001000044447824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x00000042003f7306ULL, 0x000fe60000209400ULL,
0x0000000188886812ULL, 0x004fc800078efcffULL, 0x000000887d7d723eULL, 0x000fe200000010ffULL,
0x0000004200587306ULL, 0x000e700000205400ULL, 0x00000042008b7306ULL, 0x000ea2000020d400ULL,
0x000000583f00720bULL, 0x002fce0003fdd000ULL, 0x0000004400827306ULL, 0x000ff0000020d400ULL,
0x00000044003f7306ULL, 0x000fe20000209400ULL, 0x000000018b8b6812ULL, 0x004fce00078efcffULL,
0x0000004400587306ULL, 0x000e640000205400ULL, 0x000000583f00720bULL, 0x002fe20003fdd000ULL,
0x00000100453f7824ULL, 0x040fe400078e00ffULL, 0x0001000045457824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000003f00427306ULL, 0x000fe60000209400ULL, 0x0000000182826812ULL, 0x000fca00078efcffULL,
0x0000003f00437306ULL, 0x000e700000205400ULL, 0x0000003f008a7306ULL, 0x000ea2000020d400ULL,
0x000000434200720bULL, 0x002fce0003fdd000ULL, 0x0000004500847306ULL, 0x000ff0000020d400ULL,
0x0000004500427306ULL, 0x000fe20000209400ULL, 0x000000018a8a6812ULL, 0x004fce00078efcffULL,
0x0000004500437306ULL, 0x000e640000205400ULL, 0x000000434200720bULL, 0x002fe20003fdd000ULL,
0x0000010046427824ULL, 0x040fe400078e00ffULL, 0x0001000046467824ULL, 0x000fc600078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x00000042003f7306ULL, 0x000fe60000209400ULL, 0x0000000184846812ULL, 0x000fc800078efcffULL,
0x000000847979723eULL, 0x000fe200000010ffULL, 0x0000004200447306ULL, 0x000e700000205400ULL,
0x00000042008d7306ULL, 0x000ea2000020d400ULL, 0x000000443f00720bULL, 0x002fce0003fdd000ULL,
0x0000004600867306ULL, 0x000ff0000020d400ULL, 0x00000046003f7306ULL, 0x000fe20000209400ULL,
0x000000018d8d6812ULL, 0x004fce00078efcffULL, 0x0000004600447306ULL, 0x000e640000205400ULL,
0x000000443f00720bULL, 0x002fe20003fdd000ULL, 0x00000100473f7824ULL, 0x040fe400078e00ffULL,
0x0001000047477824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000003f00427306ULL, 0x000fe60000209400ULL,
0x0000000186866812ULL, 0x000fc800078efcffULL, 0x000000867786723eULL, 0x000fe200000010ffULL,
0x0000003f00437306ULL, 0x000e700000205400ULL, 0x0000003f008f7306ULL, 0x000ea2000020d400ULL,
0x000000434200720bULL, 0x002fce0003fdd000ULL, 0x0000004700917306ULL, 0x000ff0000020d400ULL,
0x0000004700427306ULL, 0x000fe20000209400ULL, 0x000000018f8f6812ULL, 0x004fce00078efcffULL,
0x0000004700437306ULL, 0x000e640000205400ULL, 0x000000434200720bULL, 0x002fe20003fdd000ULL,
0x0000010038427824ULL, 0x040fe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000042003f7306ULL, 0x000fe60000209400ULL, 0x0000000191916812ULL, 0x000fc800078efcffULL,
0x000000917487723eULL, 0x000fe200000010ffULL, 0x0000004200447306ULL, 0x000e700000205400ULL,
0x0000004200937306ULL, 0x000ea2000020d400ULL, 0x000000443f00720bULL, 0x002fce0003fdd000ULL,
0x00000038008c7306ULL, 0x000ff0000020d400ULL, 0x00000038003f7306ULL, 0x000fe20000209400ULL,
0x0000000193936812ULL, 0x004fce00078efcffULL, 0x0000003800447306ULL, 0x000e640000205400ULL,
0x000000443f00720bULL, 0x002fe20003fdd000ULL, 0x00000100393f7824ULL, 0x040fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003f00427306ULL, 0x000fe60000209400ULL,
0x000000018c8c6812ULL, 0x000fca00078efcffULL, 0x0000003f00437306ULL, 0x000e700000205400ULL,
0x0000003f008e7306ULL, 0x000ea2000020d400ULL, 0x000000434200720bULL, 0x002fce0003fdd000ULL,
0x0000003900387306ULL, 0x000ff00000209400ULL, 0x0000003900437306ULL, 0x000e620000205400ULL,
0x000000018e8e6812ULL, 0x004fce00078efcffULL, 0x0000003900907306ULL, 0x000ea2000020d400ULL,
0x000000433800720bULL, 0x002fe20003fdd000ULL, 0x000001003a387824ULL, 0x040fe200078e00ffULL,
0x000000788943723eULL, 0x000fe200000010ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x000000827b78723eULL, 0x000fe400000010ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x00000038003f7306ULL, 0x000fe60000209400ULL,
0x0000000190906812ULL, 0x004fc800078efcffULL, 0x000000907171723eULL, 0x000fe200000010ffULL,
0x0000003800427306ULL, 0x000e700000205400ULL, 0x0000003800957306ULL, 0x000ea2000020d400ULL,
0x000000423f00720bULL, 0x002fce0003fdd000ULL, 0x0000003a00397306ULL, 0x000ff00000209400ULL,
0x0000003a00427306ULL, 0x000e620000205400ULL, 0x0000000195956812ULL, 0x004fce00078efcffULL,
0x0000003a00927306ULL, 0x000ea2000020d400ULL, 0x0000006c956c723eULL, 0x000fe400000010ffULL,
0x000000423900720bULL, 0x002fe20003fdd000ULL, 0x000001003b397824ULL, 0x000fc800078e00ffULL,
0x0000003b003a7306ULL, 0x000fe20000009400ULL, 0x0000007a8542723eULL, 0x000fe400000010ffULL,
0x00000018ff397819ULL, 0x000fca0000011439ULL, 0x0000003900387306ULL, 0x000fe20000209400ULL,
0x0000000192926812ULL, 0x004fc800078efcffULL, 0x000000926f92723eULL, 0x000fc600000010ffULL,
0x00000039003f7306ULL, 0x000e700000205400ULL, 0x0000003900977306ULL, 0x0004e2000020d400ULL,
0x0000003f3800720bULL, 0x002fce0003fdd000ULL, 0x0000003b007a7306ULL, 0x000322000000d400ULL,
0x0001280068387811ULL, 0x000fe200078e20ffULL, 0x000000003c3c783bULL, 0x000f220000000200ULL,
0x000000758a39723eULL, 0x004fc600000010ffULL, 0x00000000385c783bULL, 0x0005220000000200ULL,
0x0000000197976812ULL, 0x008fe200078efcffULL, 0x000100003b387824ULL, 0x004fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x002fe4000001143bULL, 0x000000ff5600720cULL, 0x000fe40003fc5270ULL,
0x00000018ff7e7819ULL, 0x000fe40000011438ULL, 0x000000768b38723eULL, 0x000fe400000010ffULL,
0x0000007e00807306ULL, 0x000ff00000209400ULL, 0x0000007e00757306ULL, 0x000e700000205400ULL,
0x0000003b00767306ULL, 0x000fe20000209400ULL, 0x000000093c3cb231ULL, 0x010fc400003400ffULL,
0x000000093e3eb231ULL, 0x080fe400003400ffULL, 0x000000095c5cb231ULL, 0x080fe400003400ffULL,
0x000000095e5eb231ULL, 0x000fe400003400ffULL, 0x000000085d5db231ULL, 0x080fe400003400ffULL,
0x000000085f5fb231ULL, 0x080fe400003400ffULL, 0x000000083d3db231ULL, 0x000fc400003400ffULL,
0x000000083f3fb231ULL, 0x000fe200003400ffULL, 0x0000007f3a00720bULL, 0x000fe40003f7d000ULL,
0x0000004c5c58723cULL, 0x040f6200000418ffULL, 0x0000007e003a7306ULL, 0x000eae000020d400ULL,
0x000000505c50723cULL, 0x000f6600000418ffULL, 0x000000017a7a3812ULL, 0x000fc400078efcffULL,
0x000000758000720bULL, 0x002fe40003f7d000ULL, 0x0000003b00757306ULL, 0x000e620000205400ULL,
0x000000405c44723cULL, 0x000ff000000418ffULL, 0x000000383c58723cULL, 0x020be40000041858ULL,
0x000000013a3a3812ULL, 0x004fca00078efcffULL, 0x000000728d38723eULL, 0x020fe200000010ffULL,
0x000000545c54723cULL, 0x000f6200000418ffULL, 0x000000708f39723eULL, 0x000fe400000010ffULL,
0x000000757600720bULL, 0x002fe40003f7d000ULL, 0x0000008c7370723eULL, 0x000fc600000010ffULL,
0x000000383c50723cULL, 0x000bee0000041850ULL, 0x0000006e9338723eULL, 0x020fe200000010ffULL,
0x0000004e5c4c723cULL, 0x000f6200000418ffULL, 0x0000003b00937306ULL, 0x000e62000020d400ULL,
0x0000006d8e39723eULL, 0x000fc400000010ffULL, 0x0000007a976d723eULL, 0x000fc800000010ffULL,
0x0000004a5c48723cULL, 0x040f7000000418ffULL, 0x000000425c40723cULL, 0x000f6200000418ffULL,
0x0000000193933812ULL, 0x002fc800078efcffULL, 0x0000003a9393723eULL, 0x000fc600000010ffULL,
0x0000007c5c5c723cULL, 0x000f7000000418ffULL, 0x000000783c54723cULL, 0x040b700000041854ULL,
0x000000863c4c723cULL, 0x060b70000004184cULL, 0x000000383c48723cULL, 0x040b700000041848ULL,
0x000000703c44723cULL, 0x040b700000041844ULL, 0x0000006c3c40723cULL, 0x040b700000041840ULL,
0x000000923c5c723cULL, 0x000b62000004185cULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000005812127221ULL, 0x000fe40000010000ULL,
0x0000005913137221ULL, 0x000fc40000010000ULL, 0x0000005416167221ULL, 0x000fe40000010000ULL,
0x0000005517177221ULL, 0x000fe40000010000ULL, 0x000000501a1a7221ULL, 0x000fe40000010000ULL,
0x000000511b1b7221ULL, 0x000fe40000010000ULL, 0x0000004c1e1e7221ULL, 0x020fe40000010000ULL,
0x0000004d1f1f7221ULL, 0x000fc40000010000ULL, 0x0000004822227221ULL, 0x000fe40000010000ULL,
0x0000004923237221ULL, 0x000fe40000010000ULL, 0x0000004426267221ULL, 0x000fe40000010000ULL,
0x0000004527277221ULL, 0x000fe40000010000ULL, 0x000000402a2a7221ULL, 0x000fe40000010000ULL,
0x000000412b2b7221ULL, 0x000fc40000010000ULL, 0x0000005c2e2e7221ULL, 0x000fe40000010000ULL,
0x0000005d2f2f7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x0000005a14147221ULL, 0x000fe40000010000ULL, 0x0000005b15157221ULL, 0x000fe40000010000ULL,
0x0000005618187221ULL, 0x000fe40000010000ULL, 0x0000005719197221ULL, 0x000fe40000010000ULL,
0x000000521c1c7221ULL, 0x000fc40000010000ULL, 0x000000531d1d7221ULL, 0x000fe40000010000ULL,
0x0000004e20207221ULL, 0x020fe40000010000ULL, 0x0000004f21217221ULL, 0x000fe40000010000ULL,
0x0000004a24247221ULL, 0x000fe40000010000ULL, 0x0000004b25257221ULL, 0x000fe40000010000ULL,
0x0000004628287221ULL, 0x000fc40000010000ULL, 0x0000004729297221ULL, 0x000fe40000010000ULL,
0x000000422c2c7221ULL, 0x000fe40000010000ULL, 0x000000432d2d7221ULL, 0x000fe40000010000ULL,
0x0000005e30307221ULL, 0x000fe40000010000ULL, 0x0000005f31317221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000016a6a7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x020e62000c80043fULL,
0x000000696a00720cULL, 0x000fe20003f06070ULL, 0x000000ffff3c7224ULL, 0x002fd800078e0039ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff8c6000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000800f397811ULL, 0x000fe200078e40ffULL,
0x018b6000ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000603900720cULL, 0x000fda0003f06070ULL,
0x0000e85000000947ULL, 0x000fea0003800000ULL, 0x000000ffff6a7224ULL, 0x000fca00078e00ffULL,
0x00000002ff397819ULL, 0x000fe2000001166aULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000036a387812ULL, 0x040fe200078ec0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x000000396a397207ULL, 0x000fe40002800000ULL, 0x000000ff383f7207ULL, 0x000fe40006800000ULL,
0x0000000239407810ULL, 0x000fc80007ffe0ffULL, 0x0000000340417812ULL, 0x040fe400078ec0ffULL,
0x0000000f40437211ULL, 0x000fc400078ff0ffULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x018b7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x018b8c00ff3b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000143397810ULL, 0x040fe20007ffe0ffULL, 0x0000000443387824ULL, 0x000fe200078e0241ULL,
0x0000097000017945ULL, 0x000fe40003800000ULL, 0x000000363900720cULL, 0x000fe40003f06070ULL,
0x00000020383b7811ULL, 0x000fc800078e30ffULL, 0x0000006033427812ULL, 0x000fce00078ef83bULL,
0x000004f000008947ULL, 0x000fea0003800000ULL, 0x0000000507457c10ULL, 0x040fe2000fffe0ffULL,
0x00000010323c7824ULL, 0x000fe200078e00ffULL, 0x0000003b60387217ULL, 0x000fe20007800000ULL,
0x00000100ff477424ULL, 0x000fe200078e00ffULL, 0x00000002074d7810ULL, 0x000fe20007ffe0ffULL,
0x018a000045397984ULL, 0x000e620000004800ULL, 0x000000f03c497812ULL, 0x000fe200078ec0ffULL,
0x0000000138387824ULL, 0x000fe200078e0a3bULL, 0x000000054d4f7c10ULL, 0x000fe2000fffe0ffULL,
0x00000001453b7824ULL, 0x040fe400078e0242ULL, 0x00000010453e7824ULL, 0x000fe200078e00ffULL,
0x0000000538387c17ULL, 0x000fc8000f800000ULL, 0x80000005383c7c10ULL, 0x000fc8000fffe0ffULL,
0x0000003c0700720cULL, 0x000fe20003f06070ULL, 0x018ac000393a7984ULL, 0x002e640000004800ULL,
0x0000003a0d3a7224ULL, 0x002fe400078e023bULL, 0x00000001453b7824ULL, 0x000fe400078e0232ULL,
0x00005e003a387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe40007f3e0ffULL,
0xfffffff03e387812ULL, 0x000fe200078ee23bULL, 0x000000014f3e7824ULL, 0x040fe400078e0232ULL,
0x000000ffff3b7224ULL, 0x000fe200008e0639ULL, 0x00016000384b7811ULL, 0x000fe200078e20ffULL,
0x000000014f397824ULL, 0x040fe400078e0242ULL, 0x000000104f4f7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a4b7faeULL, 0x0003e2000c101c50ULL,
0x0000003c4d00720cULL, 0x000fc40003f06070ULL, 0xfffffff04f3e7812ULL, 0x000fe200078ee23eULL,
0x018a0800453d7984ULL, 0x000ea20000004800ULL, 0x00000004074d7810ULL, 0x000fc80007ffe0ffULL,
0x000000054d4f7c10ULL, 0x000fe4000fffe0ffULL, 0x000160003e4b7811ULL, 0x002fc600078e20ffULL,
0x000000014f3e7824ULL, 0x000fe200078e0232ULL, 0x018ac0003d387984ULL, 0x004e640000004800ULL,
0x000000380d387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0047ULL,
0x00000049383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x000000014f397824ULL, 0x040fe400078e0242ULL, 0x000000104f4f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a4b7faeULL, 0x0003e2000c101c50ULL,
0x0000003c4d00720cULL, 0x000fe40003f06070ULL, 0x00000006074d7810ULL, 0x000fe20007ffe0ffULL,
0x018a1000453d7984ULL, 0x000ea20000004800ULL, 0xfffffff04f3e7812ULL, 0x000fc400078ee23eULL,
0x000000054d4f7c10ULL, 0x000fe4000fffe0ffULL, 0x000160003e4b7811ULL, 0x002fc600078e20ffULL,
0x000000014f3e7824ULL, 0x000fe200078e0232ULL, 0x018ac0003d387984ULL, 0x004e640000004800ULL,
0x000000380d387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0047ULL,
0x00000049383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x000000014f397824ULL, 0x040fe400078e0242ULL, 0x000000104f4f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a4b7faeULL, 0x0003e2000c101c50ULL,
0x0000003c4d00720cULL, 0x000fc60003f06070ULL, 0x018a1800453d7984ULL, 0x000ea20000004800ULL,
0xfffffff04f3e7812ULL, 0x000fc800078ee23eULL, 0x000160003e3b7811ULL, 0x002fe200078e20ffULL,
0x018ac0003d387984ULL, 0x004e640000004800ULL, 0x000000380d387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x0000004938387210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff397224ULL, 0x000fca00008e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000c101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x0000000507457c10ULL, 0x000fe2000fffe0ffULL, 0x0000001032397824ULL, 0x000fe400078e00ffULL,
0x00000100ff477424ULL, 0x000fe200078e00ffULL, 0x00000002453d7810ULL, 0x040fe20007ffe0ffULL,
0x018a0000453c7984ULL, 0x000e620000004800ULL, 0x0000000145387824ULL, 0x000fe200078e0242ULL,
0x000000f039497812ULL, 0x000fe200078ec0ffULL, 0x00000001453b7824ULL, 0x040fe400078e0232ULL,
0x00000010453e7824ULL, 0x000fc400078e00ffULL, 0x000000013d447824ULL, 0x000fe200078e0232ULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff03e387812ULL, 0x000fc600078ee23bULL, 0x000000ffff3b7224ULL, 0x000fe200000e0639ULL,
0x00016000384b7811ULL, 0x000fe200078e20ffULL, 0x000000013d387824ULL, 0x040fe400078e0242ULL,
0x000000103d3d7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a4b7faeULL, 0x0003e6000b901c50ULL, 0xfffffff03d447812ULL, 0x000fe200078ee244ULL,
0x018a0800453e7984ULL, 0x000ea60000004800ULL, 0x00016000444b7811ULL, 0x002fc400078e20ffULL,
0x00000004453b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b447824ULL, 0x000fe200078e0232ULL,
0x018ac0003e3e7984ULL, 0x004e640000004800ULL, 0x0000003e0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383c7210ULL, 0x000fe20007f1e0ffULL,
0x000000013b387824ULL, 0x040fe400078e0242ULL, 0x000000103b3b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e0639ULL, 0xfffffff03b447812ULL, 0x000fe400078ee244ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c4b7faeULL, 0x0003e8000b901c50ULL,
0x018a1000453e7984ULL, 0x000ea20000004800ULL, 0x00016000443d7811ULL, 0x002fe400078e20ffULL,
0x00000006454b7810ULL, 0x000fe20007ffe0ffULL, 0x018ac0003e3e7984ULL, 0x004e640000004800ULL,
0x0000003e0d387224ULL, 0x002fc400078e0238ULL, 0x000000014b3e7824ULL, 0x000fe400078e0232ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe20007f1e0ffULL,
0x000000014b387824ULL, 0x040fe400078e0242ULL, 0x000000104b4b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600000e0639ULL, 0xfffffff04b3e7812ULL, 0x000fe400078ee23eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c50ULL,
0x018a1800453c7984ULL, 0x000ea20000004800ULL, 0x000160003e3b7811ULL, 0x002fc600078e20ffULL,
0x018ac0003c3c7984ULL, 0x004e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x0000004938387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff457224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000433400720cULL, 0x000fe20003f04070ULL, 0x0000015000017945ULL, 0x000fe20003800000ULL,
0x0000000140387812ULL, 0x000fe400078ec0ffULL, 0x000000033f00780cULL, 0x000fc80004705270ULL,
0x000000013800780cULL, 0x000fda0000705470ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x000000030c00780cULL, 0x000fe40003f04070ULL, 0x000000010e0e7810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000397919ULL, 0x000e620000002700ULL,
0x000000370e00720cULL, 0x000fe20003f06070ULL, 0x00000004ff3b7424ULL, 0x000fe200078e00ffULL,
0x00018ac00c3d7811ULL, 0x000fe200078e10ffULL, 0x0000000439387824ULL, 0x002fe200078e020cULL,
0x000064000e397a10ULL, 0x000fc60007ffe0ffULL, 0x0000000238387824ULL, 0x000fc800078e00ffULL,
0x0000640038387a24ULL, 0x000fc800078e0239ULL, 0x0000600038387625ULL, 0x000fca00078e003bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383d7faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000433400720cULL, 0x000fe40003f04070ULL,
0x000000013f387810ULL, 0x002fc80007ffe0ffULL, 0x0000000338397812ULL, 0x000fc800078ec0ffULL,
0x000000ff39397207ULL, 0x000fc60004000000ULL, 0x00000002ff388819ULL, 0x000fca0000011638ULL,
0x0000000141387824ULL, 0x000fc800078e0238ULL, 0x00000040383a7824ULL, 0x040fe200078e00ffULL,
0x0000004338387211ULL, 0x000fc800078ff0ffULL, 0x000000c03a3b7812ULL, 0x000fca00078ec0ffULL,
0x00000100383d7824ULL, 0x000fe200078e023bULL, 0x0000000a39387c10ULL, 0x000fc6000fffe0ffULL,
0x000000010c3b7824ULL, 0x100fe400078e023dULL, 0x0000680038397a24ULL, 0x000fe400078e023dULL,
0x00000004ff387424ULL, 0x000fe200078e00ffULL, 0x000000603b00720cULL, 0x000fe20003f06070ULL,
0x000000010c397824ULL, 0x040fe200078e0239ULL, 0x00018a000c3b7811ULL, 0x000fc600078e10ffULL,
0x0000660039387625ULL, 0x000fd000078e0038ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8000ff387f8cULL, 0x000e62000c80043fULL, 0x000000ff6a00720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff6b7224ULL, 0x002fd600078e0039ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b1800ff387f8cULL, 0x000e64000c800405ULL, 0x000000ffff3c7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b1c05ff0b7984ULL, 0x000e640008000800ULL,
0x800000000bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc8000001143bULL, 0x0000003a0b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff3a7224ULL, 0x000fca00000e063bULL, 0x000000020b0b7819ULL, 0x000fc8000000123aULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x018b1c05ff0b7984ULL, 0x000e640008000800ULL, 0x800000000bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00000010320b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff387819ULL, 0x000fc80000011632ULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c38387812ULL, 0x000fca00078ec0ffULL, 0x000000010b3f7824ULL, 0x000fca00078e0238ULL,
0x018100003f3b7984ULL, 0x000e680000000800ULL, 0x018300003f3a7984ULL, 0x0004e20000000800ULL,
0x000000103b00720bULL, 0x002fe20003f1d000ULL, 0x000174627f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0b427812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fd200078e0010ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000023500780cULL, 0x000fe40003f05270ULL, 0x000000103b00720bULL, 0x000fe20003f34000ULL,
0x000174327f007947ULL, 0x000fd8000b800000ULL, 0x00000000003d7806ULL, 0x000fc400008e0100ULL,
0x0000003b103c7209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x000099103d387816ULL, 0x000fc600000000ffULL, 0x0185003c3f008388ULL, 0x0003e20000000800ULL,
0x000000ff3800720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000003c10107221ULL, 0x002fe20000010000ULL, 0x000000ff3dff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000447308ULL, 0x000e640000000800ULL, 0x0000004411117220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000173927f007947ULL, 0x000fea000b800000ULL,
0x00001f6244107589ULL, 0x0002a400000e0000ULL, 0x0000001012127220ULL, 0x084fe40000410000ULL,
0x0000001013137220ULL, 0x080fe40000410000ULL, 0x0000001016167220ULL, 0x080fe40000410000ULL,
0x0000001017177220ULL, 0x080fe40000410000ULL, 0x000000101a1a7220ULL, 0x080fe40000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x000000101e1e7220ULL, 0x080fe40000410000ULL,
0x000000101f1f7220ULL, 0x080fe40000410000ULL, 0x0000001022227220ULL, 0x080fe40000410000ULL,
0x0000001023237220ULL, 0x080fe40000410000ULL, 0x0000001026267220ULL, 0x080fe40000410000ULL,
0x0000001027277220ULL, 0x000fc40000410000ULL, 0x000000102a2a7220ULL, 0x080fe40000410000ULL,
0x000000102b2b7220ULL, 0x080fe40000410000ULL, 0x000000102e2e7220ULL, 0x080fe40000410000ULL,
0x000000102f2f7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff003dff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000172c27f007947ULL, 0x000fea000b800000ULL, 0x00001f6144107589ULL, 0x00046400000e0000ULL,
0x0000001014147220ULL, 0x082fe40000410000ULL, 0x0000001015157220ULL, 0x080fe40000410000ULL,
0x0000001018187220ULL, 0x080fe40000410000ULL, 0x0000001019197220ULL, 0x080fe40000410000ULL,
0x000000101c1c7220ULL, 0x080fe40000410000ULL, 0x000000101d1d7220ULL, 0x000fc40000410000ULL,
0x0000001020207220ULL, 0x080fe40000410000ULL, 0x0000001021217220ULL, 0x080fe40000410000ULL,
0x0000001024247220ULL, 0x080fe40000410000ULL, 0x0000001025257220ULL, 0x080fe40000410000ULL,
0x0000001028287220ULL, 0x080fe40000410000ULL, 0x0000001029297220ULL, 0x000fc40000410000ULL,
0x000000102c2c7220ULL, 0x080fe40000410000ULL, 0x000000102d2d7220ULL, 0x080fe40000410000ULL,
0x0000001030307220ULL, 0x080fe40000410000ULL, 0x0000001031317220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff42ff7812ULL, 0x000fda000780603dULL,
0x8000003c3b3b0221ULL, 0x000fe20000010000ULL, 0x00007610ff0b0816ULL, 0x000fc6000000000bULL,
0x3fb8aa3b3b3b0820ULL, 0x000fc80000410000ULL, 0x0000003b000a0308ULL, 0x000e640000000800ULL,
0x0000000a3a3a0220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x000000113a117221ULL, 0x008fe40000010000ULL, 0x000000ffff107224ULL, 0x000fc400078e003cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff0bff7812ULL, 0x000fe2000786c0ffULL,
0x0000016000017945ULL, 0x000fd80003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x0000000aff08723eULL, 0x000fc800000010ffULL, 0x00005410083a7816ULL, 0x000fe20000000008ULL,
0x000171227f007947ULL, 0x000fea000b800000ULL, 0x00001f623a097589ULL, 0x0002e400000e0000ULL,
0x000171827f007947ULL, 0x000fea000b800000ULL, 0x00001f613a087589ULL, 0x0002a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010623f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0001263000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00017cb000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018623f7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff407424ULL, 0x000fe200078e00ffULL, 0x000126a000387802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00017c4000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000000640783bULL, 0x002e620000004200ULL, 0x00001e9000017945ULL, 0x000fe60003800000ULL,
0x000000000444783bULL, 0x004fe80000004200ULL, 0x00000000053c783bULL, 0x000ea80000004200ULL,
0x000000000338783bULL, 0x000f220000004200ULL, 0x00000018ff4d7819ULL, 0x002fe20000011443ULL,
0x0000010040797824ULL, 0x000fe200078e00ffULL, 0x0000004000cf7306ULL, 0x000fe20000009400ULL,
0x00000018ff4a7819ULL, 0x000fc40000011440ULL, 0x00000018ff4b7819ULL, 0x000fe40000011441ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000018ff7a7819ULL, 0x004fe2000001143dULL,
0x0000004d00c07306ULL, 0x000fe20000209400ULL, 0x00000018ff7f7819ULL, 0x000fe4000001143eULL,
0x00000018ff587819ULL, 0x010fe4000001143aULL, 0x00000018ff5c7819ULL, 0x000fc4000001143bULL,
0x00000018ff4c7819ULL, 0x000fe20000011442ULL, 0x0000004d00c37306ULL, 0x000fe20000205400ULL,
0x00000018ff807819ULL, 0x000fce000001143fULL, 0x0000004d005a7306ULL, 0x0003f0000020d400ULL,
0x0000007a00a37306ULL, 0x000fe20000209400ULL, 0x00000018ff4d7819ULL, 0x002fce0000011447ULL,
0x0000004d00b07306ULL, 0x000ff00000209400ULL, 0x0000004d00b17306ULL, 0x000ff00000205400ULL,
0x0000004d00747306ULL, 0x000ff0000020d400ULL, 0x0000007a00a27306ULL, 0x000ff00000205400ULL,
0x0000007a004d7306ULL, 0x000ff0000020d400ULL, 0x00000079007a7306ULL, 0x000ff00000209400ULL,
0x0000007900d17306ULL, 0x000e700000205400ULL, 0x0000005800757306ULL, 0x000ff00000209400ULL,
0x0000005800767306ULL, 0x000fe20000205400ULL, 0x000000d17a00720bULL, 0x002fce0003f5d000ULL,
0x00000058006c7306ULL, 0x000ff0000020d400ULL, 0x0000005c00777306ULL, 0x000ff00000209400ULL,
0x0000005c00787306ULL, 0x000ff00000205400ULL, 0x0000005c006d7306ULL, 0x000ff0000020d400ULL,
0x0000007f009f7306ULL, 0x000ff00000209400ULL, 0x0000007f00587306ULL, 0x000ff00000205400ULL,
0x0000007f005c7306ULL, 0x0003f0000020d400ULL, 0x0000004000ca7306ULL, 0x000ea20000005400ULL,
0x00000100417f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000007900b37306ULL, 0x000330000020d400ULL, 0x0000007f00ce7306ULL, 0x000fe20000209400ULL,
0x0000010042797824ULL, 0x002fe200078e00ffULL, 0x000000cacf00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000007f00d57306ULL, 0x000e620000205400ULL,
0x00000001b3b32812ULL, 0x010fce00078efcffULL, 0x0000004000a87306ULL, 0x000530000000d400ULL,
0x0000004a00cd7306ULL, 0x000fe20000209400ULL, 0x0001000040407824ULL, 0x004fe200078e00ffULL,
0x000000d5ce00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000004a00c87306ULL, 0x000e620000205400ULL, 0x00000001a8a86812ULL, 0x010fce00078efcffULL,
0x0000004a00a07306ULL, 0x000530000020d400ULL, 0x0000004100c47306ULL, 0x000fe20000009400ULL,
0x00000018ff4a7819ULL, 0x004fe40000011444ULL, 0x000000c8cd00720bULL, 0x002fca0003f3d000ULL,
0x0000004100c97306ULL, 0x000e700000005400ULL, 0x0000004b00c77306ULL, 0x000fe20000209400ULL,
0x00000001a0a01812ULL, 0x010fce00078efcffULL, 0x0000004b00c27306ULL, 0x000ea20000205400ULL,
0x000000c9c400720bULL, 0x002fce0003fdd000ULL, 0x0000004b009e7306ULL, 0x000330000020d400ULL,
0x0000004a00b87306ULL, 0x000fe20000209400ULL, 0x00000018ff4b7819ULL, 0x002fe40000011445ULL,
0x000000c2c700720bULL, 0x004fca0003f3d000ULL, 0x0000004a00bd7306ULL, 0x000ff00000205400ULL,
0x0000004a00887306ULL, 0x0003e2000020d400ULL, 0x000000019e9e1812ULL, 0x010fce00078efcffULL,
0x0000004200be7306ULL, 0x000fe20000009400ULL, 0x00000018ff4a7819ULL, 0x002fce0000011438ULL,
0x0000004200c57306ULL, 0x000ff00000005400ULL, 0x00000042009c7306ULL, 0x0003f0000000d400ULL,
0x0000007f00af7306ULL, 0x000522000020d400ULL, 0x0001000042427824ULL, 0x002fce00078e00ffULL,
0x0000007900d97306ULL, 0x000fe20000209400ULL, 0x00000018ff7f7819ULL, 0x004fe20000011442ULL,
0x0000010043427824ULL, 0x000fcc00078e00ffULL, 0x0000007900d27306ULL, 0x000e620000205400ULL,
0x00000001afaf2812ULL, 0x010fce00078efcffULL, 0x0000004c00cb7306ULL, 0x000ff00000209400ULL,
0x0000004c00c67306ULL, 0x000ea20000205400ULL, 0x000000d2d900720bULL, 0x002fce0003f5d000ULL,
0x0000004c005b7306ULL, 0x000330000020d400ULL, 0x0000004b00ba7306ULL, 0x000fe20000209400ULL,
0x00000018ff4c7819ULL, 0x002fe40000011446ULL, 0x000000c6cb00720bULL, 0x004fca0003f3d000ULL,
0x0000004b00c17306ULL, 0x000e700000205400ULL, 0x0000004b00847306ULL, 0x0004e2000020d400ULL,
0x000000015b5b1812ULL, 0x010fe400078efcffULL, 0x000000c3c000720bULL, 0x000fca0003f3d000ULL,
0x0000004a00527306ULL, 0x000fe20000209400ULL, 0x00000018ff4b7819ULL, 0x004fce0000011439ULL,
0x0000004a00537306ULL, 0x000fe20000205400ULL, 0x000000015a5a1812ULL, 0x000fe400078efcffULL,
0x000000bdb800720bULL, 0x000fca0003f3d000ULL, 0x0000004a00727306ULL, 0x0005f0000020d400ULL,
0x0000004000cc7306ULL, 0x000fe20000209400ULL, 0x00000018ff4a7819ULL, 0x004fe4000001143cULL,
0x0000000188881812ULL, 0x000fc400078efcffULL, 0x000000c1ba00720bULL, 0x002fe20003f3d000ULL,
0x000001003eba7824ULL, 0x000fe400078e00ffULL, 0x0000004000d37306ULL, 0x000e660000205400ULL,
0x00000018ffba7819ULL, 0x000fca00000114baULL, 0x0000004100a47306ULL, 0x000524000000d400ULL,
0x0000000184841812ULL, 0x008fcc00078efcffULL, 0x0000004c00b77306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x004fe200078e00ffULL, 0x000000d3cc00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004c00b47306ULL, 0x000e620000205400ULL,
0x00000001a4a46812ULL, 0x010fe400078efcffULL, 0x000000c5be00720bULL, 0x000fe20003fdd000ULL,
0x000001003dbe7824ULL, 0x000fc800078e00ffULL, 0x0000004c007e7306ULL, 0x000ea2000020d400ULL,
0x00000018ffbe7819ULL, 0x000fce00000114beULL, 0x0000004b00897306ULL, 0x000fe20000209400ULL,
0x000000019c9c6812ULL, 0x000fe400078efcffULL, 0x000000b4b700720bULL, 0x002fca0003f3d000ULL,
0x0000004b008a7306ULL, 0x000ff00000205400ULL, 0x0000004b006e7306ULL, 0x000fe2000020d400ULL,
0x000000017e7e1812ULL, 0x004fe400078efcffULL, 0x000000b1b000720bULL, 0x000fe20003f3d000ULL,
0x000001003bb17824ULL, 0x000fc400078e00ffULL, 0x000100003ab07824ULL, 0x000fe400078e00ffULL,
0x0000004a00b57306ULL, 0x000fe20000209400ULL, 0x00000018ffb17819ULL, 0x000fe400000114b1ULL,
0x00000018ffb07819ULL, 0x000fca00000114b0ULL, 0x0000004a00ac7306ULL, 0x000e620000205400ULL,
0x0000000174741812ULL, 0x000fce00078efcffULL, 0x0000004a004c7306ULL, 0x000eb0000020d400ULL,
0x00000080004b7306ULL, 0x000fe20000209400ULL, 0x000000acb500720bULL, 0x002fe20003f3d000ULL,
0x000100003bac7824ULL, 0x000fca00078e00ffULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x00000080004a7306ULL, 0x000fec0000205400ULL, 0x000000014c4c1812ULL, 0x004fe400078efcffULL,
0x00000080005d7306ULL, 0x0003f0000020d400ULL, 0x0000007900a17306ULL, 0x0004e2000020d400ULL,
0x00000018ff807819ULL, 0x002fce0000011442ULL, 0x0000008000e07306ULL, 0x000fe20000209400ULL,
0x0000010044797824ULL, 0x004fca00078e00ffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000008000e77306ULL, 0x000e620000205400ULL, 0x00000001a1a12812ULL, 0x008fce00078efcffULL,
0x0000004000a77306ULL, 0x000eb0000020d400ULL, 0x0000004100d07306ULL, 0x000fe20000209400ULL,
0x000000e7e000720bULL, 0x002fce0003f5d000ULL, 0x0000004100d77306ULL, 0x000e620000205400ULL,
0x00000001a7a70812ULL, 0x004fce00078efcffULL, 0x0000004300b67306ULL, 0x000ff00000009400ULL,
0x0000004300bf7306ULL, 0x000ea20000005400ULL, 0x000000d7d000720bULL, 0x002fce0003f1d000ULL,
0x0000008000427306ULL, 0x000e70000020d400ULL, 0x0000007900eb7306ULL, 0x000fe20000209400ULL,
0x000000bfb600720bULL, 0x004fce0003fdd000ULL, 0x0000007900e47306ULL, 0x000ea20000205400ULL,
0x0000000142422812ULL, 0x002fce00078efcffULL, 0x0000004100a57306ULL, 0x000e70000020d400ULL,
0x0000007f00de7306ULL, 0x000fe20000209400ULL, 0x000000e4eb00720bULL, 0x004fce0003f5d000ULL,
0x0000007f00e57306ULL, 0x000ea20000205400ULL, 0x00000001a5a50812ULL, 0x002fce00078efcffULL,
0x0000007f00407306ULL, 0x0003f0000020d400ULL, 0x0000004300597306ULL, 0x000722000000d400ULL,
0x00000100457f7824ULL, 0x002fe200078e00ffULL, 0x000000e5de00720bULL, 0x004fc80003f1d000ULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000004400bc7306ULL, 0x000fe20000009400ULL,
0x0001000043437824ULL, 0x008fca00078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004400bb7306ULL, 0x000e620000005400ULL, 0x0000000159596812ULL, 0x010fe400078efcffULL,
0x0000000140400812ULL, 0x000fe400078efcffULL, 0x000000594259723eULL, 0x000fe400000010ffULL,
0x0001300000427811ULL, 0x000fe200078e20ffULL, 0x0000007900937306ULL, 0x000eb0000020d400ULL,
0x0000007f00db7306ULL, 0x000fe20000209400ULL, 0x000000bbbc00720bULL, 0x002fce0003fdd000ULL,
0x0000007f00d47306ULL, 0x000e620000205400ULL, 0x0000000193932812ULL, 0x004fce00078efcffULL,
0x0000004300e27306ULL, 0x000ff00000209400ULL, 0x0000004300e97306ULL, 0x000ea20000205400ULL,
0x000000d4db00720bULL, 0x002fce0003f5d000ULL, 0x0000004300417306ULL, 0x0003f0000020d400ULL,
0x00000044005e7306ULL, 0x000722000000d400ULL, 0x0000010046437824ULL, 0x002fe200078e00ffULL,
0x000000e9e200720bULL, 0x004fc80003f1d000ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004500b27306ULL, 0x000fe20000009400ULL, 0x0001000044447824ULL, 0x008fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000004500b97306ULL, 0x000e620000005400ULL,
0x000000015e5e6812ULL, 0x010fe400078efcffULL, 0x0000000141410812ULL, 0x000fe400078efcffULL,
0x0000005e935e723eULL, 0x000fc600000010ffULL, 0x0000007f00947306ULL, 0x000eb0000020d400ULL,
0x0000004300da7306ULL, 0x000fe20000209400ULL, 0x000000b9b200720bULL, 0x002fce0003fdd000ULL,
0x0000004300e17306ULL, 0x000e620000205400ULL, 0x0000000194942812ULL, 0x004fce00078efcffULL,
0x0000004400e67306ULL, 0x000ff00000209400ULL, 0x0000004400ed7306ULL, 0x000ea20000205400ULL,
0x000000e1da00720bULL, 0x002fce0003f5d000ULL, 0x00000044008d7306ULL, 0x0003f0000020d400ULL,
0x00000045005f7306ULL, 0x000722000000d400ULL, 0x0000010047447824ULL, 0x002fe200078e00ffULL,
0x000000ede600720bULL, 0x004fc80003f1d000ULL, 0x00000018ff797819ULL, 0x000fe40000011444ULL,
0x0000004600577306ULL, 0x000fe20000009400ULL, 0x0001000045457824ULL, 0x008fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004600567306ULL, 0x000e620000005400ULL,
0x000000015f5f6812ULL, 0x010fe400078efcffULL, 0x000000018d8d0812ULL, 0x000fe400078efcffULL,
0x0000005f945f723eULL, 0x000fe400000010ffULL, 0x0000008d8888723eULL, 0x000fe200000010ffULL,
0x00000043008e7306ULL, 0x000eb0000020d400ULL, 0x0000007900d87306ULL, 0x000fe20000209400ULL,
0x000000565700720bULL, 0x002fc40003fdd000ULL, 0x0001300002567811ULL, 0x000fca00078e20ffULL,
0x0000007900dd7306ULL, 0x000e620000205400ULL, 0x000000018e8e2812ULL, 0x004fce00078efcffULL,
0x0000004600817306ULL, 0x0004f0000000d400ULL, 0x0000004500dc7306ULL, 0x000fe20000209400ULL,
0x0001000046467824ULL, 0x004fe200078e00ffULL, 0x000000ddd800720bULL, 0x002fc80003f5d000ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000004500e37306ULL, 0x000e620000205400ULL,
0x0000000181816812ULL, 0x008fc800078efcffULL, 0x000000818e8e723eULL, 0x000fc600000010ffULL,
0x00000045008b7306ULL, 0x0004f0000020d400ULL, 0x0000004700547306ULL, 0x000fe20000009400ULL,
0x0000010038457824ULL, 0x004fe200078e00ffULL, 0x000000e3dc00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff8f7819ULL, 0x000fe40000011445ULL, 0x0000004700557306ULL, 0x000e6e0000005400ULL,
0x000000018b8b0812ULL, 0x008fe200078efcffULL, 0x00000038004f7306ULL, 0x000ff00000009400ULL,
0x0000003800507306ULL, 0x000fe20000005400ULL, 0x000000555400720bULL, 0x002fc40003fdd000ULL,
0x000000005654783bULL, 0x000e6a0000000200ULL, 0x0000003800737306ULL, 0x0005f0000000d400ULL,
0x0000004600df7306ULL, 0x000fe20000209400ULL, 0x0001000038387824ULL, 0x004fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004600d67306ULL, 0x000eb00000205400ULL,
0x0000004600877306ULL, 0x000ef0000020d400ULL, 0x00000079008c7306ULL, 0x0008e2000020d400ULL,
0x000000d6df00720bULL, 0x004fe20003f1d000ULL, 0x000000095454b231ULL, 0x002fc400003400ffULL,
0x000000095656b231ULL, 0x000fe400003400ffULL, 0x000000085555b231ULL, 0x080fe400003400ffULL,
0x0000008f00457306ULL, 0x000fe20000209400ULL, 0x0000010039797824ULL, 0x010fe200078e00ffULL,
0x000000085757b231ULL, 0x000fc800003400ffULL, 0x0000000187870812ULL, 0x008fe400078efcffULL,
0x0000008f00467306ULL, 0x000e620000205400ULL, 0x000000018c8c2812ULL, 0x000fce00078efcffULL,
0x0000003800987306ULL, 0x000ff00000209400ULL, 0x00000038009b7306ULL, 0x000fe20000205400ULL,
0x000000464500720bULL, 0x002fe40003f5d000ULL, 0x000000415a45723eULL, 0x000fca00000010ffULL,
0x00000038007f7306ULL, 0x0003f0000020d400ULL, 0x0000003c00ad7306ULL, 0x000fe20000009400ULL,
0x000001003c387824ULL, 0x002fca00078e00ffULL, 0x00000018ffca7819ULL, 0x000fe40000011438ULL,
0x0000003c00ae7306ULL, 0x000ff00000005400ULL, 0x0000003c00487306ULL, 0x0003f0000000d400ULL,
0x00000047007b7306ULL, 0x0004e2000000d400ULL, 0x000100003c3c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000008f00867306ULL, 0x000322000020d400ULL,
0x0001000047477824ULL, 0x004fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000003c00c27306ULL, 0x000fe20000209400ULL, 0x000000017b7b6812ULL, 0x008fe200078efcffULL,
0x000001003a8f7824ULL, 0x002fe200078e00ffULL, 0x000000aead00720bULL, 0x000fc80003fdd000ULL,
0x00000018ffe87819ULL, 0x000fe2000001148fULL, 0x0000003c00c77306ULL, 0x000e620000205400ULL,
0x0000000186862812ULL, 0x010fce00078efcffULL, 0x0000004700447306ULL, 0x000fe20000209400ULL,
0x0000000148486812ULL, 0x000fce00078efcffULL, 0x0000004700437306ULL, 0x000ea20000205400ULL,
0x000000c7c200720bULL, 0x002fce0003f5d000ULL, 0x0000003900997306ULL, 0x000ff00000009400ULL,
0x00000039004e7306ULL, 0x000fe20000005400ULL, 0x000000434400720bULL, 0x004fce0003f1d000ULL,
0x0000003900717306ULL, 0x0003f0000000d400ULL, 0x0000003d00ab7306ULL, 0x000fe20000009400ULL,
0x0001000039397824ULL, 0x002fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003d00a67306ULL, 0x000e700000005400ULL, 0x0000003c00c57306ULL, 0x000eb0000020d400ULL,
0x000000be00bf7306ULL, 0x000fe20000209400ULL, 0x000000a6ab00720bULL, 0x002fce0003fdd000ULL,
0x000000be003c7306ULL, 0x000e620000205400ULL, 0x00000001c5c52812ULL, 0x004fc800078efcffULL,
0x000000c54c4c723eULL, 0x000fc600000010ffULL, 0x0000004700857306ULL, 0x0004f0000020d400ULL,
0x0000003900917306ULL, 0x000fe20000209400ULL, 0x00000018ff477819ULL, 0x004fe40000011479ULL,
0x0000003cbf00720bULL, 0x002fc40003f5d000ULL, 0x000000a8b33c723eULL, 0x000fc600000010ffULL,
0x0000003900927306ULL, 0x000fe20000205400ULL, 0x0000000185850812ULL, 0x008fc800078efcffULL,
0x000000857485723eULL, 0x000fc600000010ffULL, 0x0000003900797306ULL, 0x000ff0000020d400ULL,
0x000000ca00387306ULL, 0x000ff00000209400ULL, 0x000000ca00397306ULL, 0x000e700000205400ULL,
0x0000003d00497306ULL, 0x0004f0000000d400ULL, 0x0000003e00a97306ULL, 0x000fe20000009400ULL,
0x000100003d3d7824ULL, 0x004fe200078e00ffULL, 0x000000393800720bULL, 0x002fe20003f1d000ULL,
0x000001003f387824ULL, 0x000fe200078e00ffULL, 0x000000a59e39723eULL, 0x000fc400000010ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003e00aa7306ULL, 0x000fe20000005400ULL,
0x0000000149496812ULL, 0x008fe400078efcffULL, 0x000000a2a300720bULL, 0x000fe40003fdd000ULL,
0x00000018ffae7819ULL, 0x000fe40000011438ULL, 0x000000a7a038723eULL, 0x000fe200000010ffULL,
0x0000003e00977306ULL, 0x0003f0000000d400ULL, 0x000000be00b67306ULL, 0x000ea2000020d400ULL,
0x000100003e3e7824ULL, 0x002fe200078e00ffULL, 0x000000014d4d6812ULL, 0x000fc800078efcffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003d00b87306ULL, 0x000ff00000209400ULL,
0x0000003d00b97306ULL, 0x000e620000205400ULL, 0x00000001b6b62812ULL, 0x004fc400078efcffULL,
0x000000589f00720bULL, 0x000fe40003f5d000ULL, 0x0000009ca158723eULL, 0x000fe400000010ffULL,
0x00000049b649723eULL, 0x000fe200000010ffULL, 0x0000003f009d7306ULL, 0x000ff00000009400ULL,
0x0000003f009a7306ULL, 0x000fe20000005400ULL, 0x000000b9b800720bULL, 0x002fc40003f3d000ULL,
0x000000015c5c2812ULL, 0x000fca00078efcffULL, 0x0000003f00517306ULL, 0x0003f0000000d400ULL,
0x0000004700957306ULL, 0x000fe20000209400ULL, 0x000100003f3f7824ULL, 0x002fce00078e00ffULL,
0x0000004700967306ULL, 0x000ff00000205400ULL, 0x0000004700807306ULL, 0x000ff0000020d400ULL,
0x0000003e00437306ULL, 0x000ff00000209400ULL, 0x0000003e00447306ULL, 0x000e700000205400ULL,
0x000000ca00477306ULL, 0x000eb0000020d400ULL, 0x0000003d00b27306ULL, 0x000722000020d400ULL,
0x000000444300720bULL, 0x002fc40003fdd000ULL, 0x000000405b44723eULL, 0x000fe400000010ffULL,
0x000000004240783bULL, 0x000e620000000200ULL, 0x000000585458723cULL, 0x000fe400000418ffULL,
0x000000ba00bb7306ULL, 0x000fe20000209400ULL, 0x000000a4af3d723eULL, 0x008fe400000010ffULL,
0x00000018ffa47819ULL, 0x000fe4000001143fULL, 0x0000000147470812ULL, 0x004fc400078efcffULL,
0x000000aaa900720bULL, 0x000fe20003f1d000ULL, 0x000000ba00b47306ULL, 0x000ea20000205400ULL,
0x00000001b2b21812ULL, 0x010fe400078efcffULL, 0x000000484748723eULL, 0x000fe400000010ffULL,
0x000000b24d4d723eULL, 0x000fc600000010ffULL, 0x000000a4009e7306ULL, 0x000fe80000209400ULL,
0x0000000197970812ULL, 0x000fe400078efcffULL, 0x0000009a9d00720bULL, 0x000fe40003f1d000ULL,
0x000000a4009f7306ULL, 0x000ee20000205400ULL, 0x000000b4bb00720bULL, 0x004fce0003f3d000ULL,
0x0000003e00ad7306ULL, 0x000526000020d400ULL, 0x0000000151510812ULL, 0x000fe400078efcffULL,
0x000000504f00720bULL, 0x000fe20003f1d000ULL, 0x000000094040b231ULL, 0x082fe400003400ffULL,
0x000000ba00bc7306ULL, 0x000e62000020d400ULL, 0x0000009f9e00720bULL, 0x008fe20003f5d000ULL,
0x0000003c543c723cULL, 0x004f6200000418ffULL, 0x000000094242b231ULL, 0x000fc400003400ffULL,
0x000000084141b231ULL, 0x080fe400003400ffULL, 0x000000084343b231ULL, 0x000fe200003400ffULL,
0x000000a400a47306ULL, 0x000ea2000020d400ULL, 0x00000001adad6812ULL, 0x010fe400078efcffULL,
0x0000004a4b00720bULL, 0x000fe40003fdd000ULL, 0x000000ad5c5c723eULL, 0x000fe200000010ffULL,
0x000000485448723cULL, 0x000fe200000418ffULL, 0x0000000173730812ULL, 0x000fe200078efcffULL,
0x000000ae00467306ULL, 0x000fe20000209400ULL, 0x00000001bcbc1812ULL, 0x002fc400078efcffULL,
0x000000969500720bULL, 0x000fe40003f1d000ULL, 0x00000097bc50723eULL, 0x000fe400000010ffULL,
0x000000738686723eULL, 0x000fe200000010ffULL, 0x000000ae00a97306ULL, 0x000e620000205400ULL,
0x00000001a4a42812ULL, 0x004fe200078efcffULL, 0x0000005e403c723cULL, 0x020fe2000004183cULL,
0x000000535200720bULL, 0x000fe40003f5d000ULL, 0x000000015d5d6812ULL, 0x000fc400078efcffULL,
0x0000009b9800720bULL, 0x000fe20003fdd000ULL, 0x000000ae00ae7306ULL, 0x000ea2000020d400ULL,
0x000000a45d5d723eULL, 0x000fe400000010ffULL, 0x0000000180800812ULL, 0x000fe400078efcffULL,
0x000000a94600720bULL, 0x002fc60003f3d000ULL, 0x000000b1009a7306ULL, 0x000fe20000209400ULL,
0x0000000172722812ULL, 0x000fe200078efcffULL, 0x000000445444723cULL, 0x000f6200000418ffULL,
0x000000929100720bULL, 0x000fe40003f5d000ULL, 0x000000017f7f6812ULL, 0x000fe400078efcffULL,
0x0000008a8900720bULL, 0x000fe20003fdd000ULL, 0x000000b100977306ULL, 0x000e620000205400ULL,
0x0000008b8489723eULL, 0x000fe400000010ffULL, 0x000000877e84723eULL, 0x000fc400000010ffULL,
0x00000001aeae1812ULL, 0x004fe400078efcffULL, 0x0000004e9900720bULL, 0x000fe20003f3d000ULL,
0x0000003b007c7306ULL, 0x000fe20000009400ULL, 0x00000051ae51723eULL, 0x000fe200000010ffULL,
0x0000004c544c723cULL, 0x040f6200000418ffULL, 0x0000000179792812ULL, 0x000fe400078efcffULL,
0x000000016e6e6812ULL, 0x000fe400078efcffULL, 0x0000007f7272723eULL, 0x000fe200000010ffULL,
0x0000003b007d7306ULL, 0x000ea20000005400ULL, 0x000000979a00720bULL, 0x002fe20003f5d000ULL,
0x000000505450723cULL, 0x000fe200000418ffULL, 0x000000796e73723eULL, 0x000fc400000010ffULL,
0x0000000171711812ULL, 0x000fc600078efcffULL, 0x0000003a00827306ULL, 0x000fe20000009400ULL,
0x000000718087723eULL, 0x000fe200000010ffULL, 0x000000844044723cULL, 0x060fec0000041844ULL,
0x0000003a00837306ULL, 0x000e620000005400ULL, 0x0000007d7c00720bULL, 0x004fe20003fdd000ULL,
0x000000864048723cULL, 0x040fec0000041848ULL, 0x000000e8008f7306ULL, 0x000fe40000209400ULL,
0x00000072404c723cULL, 0x000fec000004184cULL, 0x000000e800907306ULL, 0x000ea20000205400ULL,
0x000000838200720bULL, 0x002fce0003f3d000ULL, 0x0000003a006f7306ULL, 0x000e70000000d400ULL,
0x0000003b00707306ULL, 0x000722000000d400ULL, 0x000000908f00720bULL, 0x004fe40003f1d000ULL,
0x0000007b8c8f723eULL, 0x000fca00000010ffULL, 0x000000b100997306ULL, 0x000ea2000020d400ULL,
0x000000385438723cULL, 0x008f6200000418ffULL, 0x000000016f6f1812ULL, 0x002fe400078efcffULL,
0x000000787700720bULL, 0x000fc80003f3d000ULL, 0x000000b000937306ULL, 0x000fe20000209400ULL,
0x0000005c5454723cULL, 0x000b6200000418ffULL, 0x0000000170706812ULL, 0x010fcc00078efcffULL,
0x000000b0005c7306ULL, 0x020e620000205400ULL, 0x0000000199992812ULL, 0x004fe200078efcffULL,
0x0000008e4058723cULL, 0x040b620000041858ULL, 0x000000016d6d1812ULL, 0x000fe400078efcffULL,
0x00000070997b723eULL, 0x000fe400000010ffULL, 0x0000006a6100720cULL, 0x000fe20003f26070ULL,
0x000000ac005e7306ULL, 0x000fe40000209400ULL, 0x000000884038723cULL, 0x000b6c0000041838ULL,
0x000000ac005f7306ULL, 0x000ea20000205400ULL, 0x0000005c9300720bULL, 0x002fc40003f5d000ULL,
0x000000016a5c7810ULL, 0x000fc80007ffe0ffULL, 0x0000005c6100720cULL, 0x000fe20004f26470ULL,
0x000000e8007a7306ULL, 0x000e70000020d400ULL, 0x000000b0005d7306ULL, 0x000ee2000020d400ULL,
0x0000005f5e00720bULL, 0x004fce0003fdd000ULL, 0x000000ac00ac7306ULL, 0x000ea2000020d400ULL,
0x000000017a7a0812ULL, 0x002fe400078efcffULL, 0x000000767500720bULL, 0x000fe40003f1d000ULL,
0x0000006f7a7a723eULL, 0x000fe400000010ffULL, 0x000000015d5d2812ULL, 0x008fe400078efcffULL,
0x0000006a6200720cULL, 0x000fc60003f46070ULL, 0x0000007a4050723cULL, 0x000b620000041850ULL,
0x0000005c6200720cULL, 0x000fe40005746470ULL, 0x00000001acac6812ULL, 0x004fe400078efcffULL,
0x0000000f3400720cULL, 0x000fe40003fc3070ULL, 0x000000016c6c0812ULL, 0x000fe400078efcffULL,
0x000000ac6d6d723eULL, 0x000fe400000010ffULL, 0x0000005d6c6c723eULL, 0x000fc400000010ffULL,
0x0000000f3400720cULL, 0x000fca0003f03070ULL, 0x0000006c4054723cULL, 0x000b620000041854ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000003c12127221ULL, 0x000fe40000010000ULL, 0x0000003d13137221ULL, 0x000fe40000010000ULL,
0x0000003816167221ULL, 0x020fe40000010000ULL, 0x0000003917177221ULL, 0x000fe40000010000ULL,
0x000000581a1a7221ULL, 0x000fe40000010000ULL, 0x000000591b1b7221ULL, 0x000fc40000010000ULL,
0x000000441e1e7221ULL, 0x000fe40000010000ULL, 0x000000451f1f7221ULL, 0x000fe40000010000ULL,
0x0000004822227221ULL, 0x000fe40000010000ULL, 0x0000004923237221ULL, 0x000fe40000010000ULL,
0x0000004c26267221ULL, 0x000fe40000010000ULL, 0x0000004d27277221ULL, 0x000fc40000010000ULL,
0x000000502a2a7221ULL, 0x000fe40000010000ULL, 0x000000512b2b7221ULL, 0x000fe40000010000ULL,
0x000000542e2e7221ULL, 0x000fe40000010000ULL, 0x000000552f2f7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000003e14147221ULL, 0x000fe40000010000ULL,
0x0000003f15157221ULL, 0x000fe40000010000ULL, 0x0000003a18187221ULL, 0x020fc40000010000ULL,
0x0000003b19197221ULL, 0x000fe40000010000ULL, 0x0000005a1c1c7221ULL, 0x000fe40000010000ULL,
0x0000005b1d1d7221ULL, 0x000fe40000010000ULL, 0x0000004620207221ULL, 0x000fe40000010000ULL,
0x0000004721217221ULL, 0x000fe40000010000ULL, 0x0000004a24247221ULL, 0x000fc40000010000ULL,
0x0000004b25257221ULL, 0x000fe40000010000ULL, 0x0000004e28287221ULL, 0x000fe40000010000ULL,
0x0000004f29297221ULL, 0x000fe40000010000ULL, 0x000000522c2c7221ULL, 0x000fe40000010000ULL,
0x000000532d2d7221ULL, 0x000fe40000010000ULL, 0x0000005630307221ULL, 0x000fc40000010000ULL,
0x0000005731317221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x020e62000c80043fULL,
0x00000002ff3b7819ULL, 0x000fe2000001165cULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000f3400720cULL, 0x000fe40003fc3070ULL, 0x0000003b5c3b7207ULL, 0x040fe40002800000ULL,
0x000000035c5c7812ULL, 0x000fe400078ec0ffULL, 0x0000000f3400720cULL, 0x000fe40003f03070ULL,
0x00000040ff567803ULL, 0x000fc40000000000ULL, 0x000000ff5c5c7207ULL, 0x000fe40006800000ULL,
0x000000023b387810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3f7224ULL, 0x000fc600078e0039ULL,
0x0000000338417812ULL, 0x040fe400078ec0ffULL, 0x0000000f38437211ULL, 0x000fc400078ff0ffULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b8400ff3a7984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe200078c486bULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8400ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe400078c486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x018b8c00ff3a7984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000143397810ULL, 0x040fe20007ffe0ffULL,
0x0000000443387824ULL, 0x000fe200078e0241ULL, 0x0000097000017945ULL, 0x000fe40003800000ULL,
0x000000363900720cULL, 0x000fe20003fc6070ULL, 0x00000040383d7824ULL, 0x000fca00078e00ffULL,
0x0000004033407812ULL, 0x000fce00078ef83dULL, 0x000004f00000e947ULL, 0x000fea0003800000ULL,
0x0000000507457c10ULL, 0x040fe2000fffe0ffULL, 0x00000100ff477424ULL, 0x000fe200078e00ffULL,
0x00000002074d7810ULL, 0x000fe20007ffe0ffULL, 0x00000010323a7824ULL, 0x000fe400078e00ffULL,
0x018a0000453c7984ULL, 0x000e620000004800ULL, 0x0000000145387824ULL, 0x000fe200078e0240ULL,
0x000000054d4f7c10ULL, 0x000fe4000fffe0ffULL, 0x000000f03a497812ULL, 0x000fe200078ec0ffULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc400078e0238ULL,
0x00000010453c7824ULL, 0x000fe400078e00ffULL, 0x00005e0038387625ULL, 0x000fca00078e0047ULL,
0x00000049383a7210ULL, 0x000fe40007fde0ffULL, 0x0000003d60387217ULL, 0x000fc60007800000ULL,
0x000000ffff3b7224ULL, 0x000fe400030e0639ULL, 0x0000000138387824ULL, 0x000fe400078e0a3dULL,
0x0000000145397824ULL, 0x000fc600078e0232ULL, 0x0000000538387c17ULL, 0x000fe4000f800000ULL,
0xfffffff03c397812ULL, 0x000fe400078ee239ULL, 0x80000005383e7c10ULL, 0x000fe4000fffe0ffULL,
0x00014000394b7811ULL, 0x000fe200078e20ffULL, 0x000000014f397824ULL, 0x000fe200078e0240ULL,
0x0000003e0700720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a4b7faeULL, 0x0003e8000f101c50ULL, 0x018a0800453f7984ULL, 0x000ea80000004800ULL,
0x018ac0003f387984ULL, 0x004ea40000004800ULL, 0x000000380d387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383c7210ULL, 0x000fe20007fde0ffULL,
0x000000014f387824ULL, 0x040fe400078e0232ULL, 0x000000104f4f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x0000003e4d00720cULL, 0x000fe40003fc6070ULL,
0xfffffff04f387812ULL, 0x000fe400078ee238ULL, 0x00000004074d7810ULL, 0x000fc40007ffe0ffULL,
0x00014000384b7811ULL, 0x002fe400078e20ffULL, 0x000000054d4f7c10ULL, 0x000fca000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c4b7faeULL, 0x0003e2000f101c50ULL,
0x000000014f397824ULL, 0x000fc600078e0240ULL, 0x018a1000453f7984ULL, 0x000ea80000004800ULL,
0x018ac0003f387984ULL, 0x0044e40000004800ULL, 0x00000006073f7810ULL, 0x004fc80007ffe0ffULL,
0x000000053f4b7c10ULL, 0x002fe2000fffe0ffULL, 0x000000380d387224ULL, 0x008fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe20007fde0ffULL,
0x000000014f387824ULL, 0x040fe400078e0232ULL, 0x000000104f4f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x0000003e4d00720cULL, 0x000fe40003fc6070ULL,
0xfffffff04f387812ULL, 0x000fc800078ee238ULL, 0x00014000383d7811ULL, 0x000fe200078e20ffULL,
0x000000014b387824ULL, 0x040fe400078e0240ULL, 0x000000014b407824ULL, 0x040fe400078e0232ULL,
0x000000104b4b7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e6000f101c50ULL, 0xfffffff04b407812ULL, 0x000fe200078ee240ULL,
0x018a1800453c7984ULL, 0x000ea60000004800ULL, 0x00014000403b7811ULL, 0x002fe200078e20ffULL,
0x018ac0003c3c7984ULL, 0x004e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x0000004938387210ULL, 0x000fca0007fde0ffULL,
0x000000ffff397224ULL, 0x000fe200030e0639ULL, 0x0000003e3f00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e2000f101c50ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x00000005073f7c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff457424ULL, 0x000fe400078e00ffULL, 0x00000010323a7824ULL, 0x000fe200078e00ffULL,
0x000000023f4b7810ULL, 0x040fe20007ffe0ffULL, 0x018a00003f3c7984ULL, 0x000e620000004800ULL,
0x000000013f387824ULL, 0x000fe400078e0240ULL, 0x000000f03a477812ULL, 0x000fe200078ec0ffULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fe20007fde0ffULL,
0x000000013f387824ULL, 0x000fc800078e0232ULL, 0x000000ffff3b7224ULL, 0x000fe400030e0639ULL,
0x000000103f397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0001400038497811ULL, 0x000fe200078e20ffULL, 0x000000014b387824ULL, 0x000fc800078e0240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a497faeULL, 0x0003e8000b901c50ULL,
0x018a08003f3e7984ULL, 0x000ea80000004800ULL, 0x018ac0003e3e7984ULL, 0x004ea40000004800ULL,
0x0000003e0d387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383c7210ULL, 0x000fe20007fde0ffULL, 0x000000014b387824ULL, 0x040fe400078e0232ULL,
0x000000104b4b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff3d7224ULL, 0x000fc600030e0639ULL,
0xfffffff04b387812ULL, 0x000fe400078ee238ULL, 0x000000043f4b7810ULL, 0x000fe40007ffe0ffULL,
0x0001400038497811ULL, 0x002fc600078e20ffULL, 0x000000014b387824ULL, 0x000fe400078e0240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c497faeULL, 0x0003e8000b901c50ULL,
0x018a10003f3e7984ULL, 0x000ea20000004800ULL, 0x000000063f497810ULL, 0x002fc60007ffe0ffULL,
0x018ac0003e3e7984ULL, 0x004e640000004800ULL, 0x0000003e0d387224ULL, 0x002fe400078e0238ULL,
0x00000001493e7824ULL, 0x000fe400078e0232ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383a7210ULL, 0x000fe20007fde0ffULL, 0x000000014b387824ULL, 0x040fe400078e0232ULL,
0x000000104b4b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff3b7224ULL, 0x000fc600030e0639ULL,
0xfffffff04b387812ULL, 0x000fc800078ee238ULL, 0x00014000383d7811ULL, 0x000fe200078e20ffULL,
0x0000000149387824ULL, 0x040fe400078e0240ULL, 0x0000001049497824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e6000b901c50ULL,
0xfffffff0493e7812ULL, 0x000fe200078ee23eULL, 0x018a18003f3c7984ULL, 0x000ea60000004800ULL,
0x000140003e3b7811ULL, 0x002fe200078e20ffULL, 0x018ac0003c3c7984ULL, 0x004e640000004800ULL,
0x0000003c0d387224ULL, 0x002fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x0000004738387210ULL, 0x000fca0007fde0ffULL, 0x000000ffff397224ULL, 0x000fca00030e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e6000b901c50ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff387f8cULL, 0x002e64000c80043fULL, 0x000000ffff3f7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b8c00ff3a7984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000433400720cULL, 0x000fe20003fc4070ULL,
0x00000004ff3a7424ULL, 0x000fe200078e00ffULL, 0x00018a000c3d7811ULL, 0x000fe400078e10ffULL,
0x000000ff5c387207ULL, 0x000fc40003000000ULL, 0x000000ff5c5c7207ULL, 0x000fc60007000000ULL,
0x0000000141387824ULL, 0x000fc800078e0238ULL, 0x0000004038397824ULL, 0x040fe200078e00ffULL,
0x0000004338387211ULL, 0x000fc800078ff0ffULL, 0x000000c039397812ULL, 0x000fca00078ec0ffULL,
0x0000010038387824ULL, 0x000fe200078e0239ULL, 0x0000000a5c397c10ULL, 0x000fc8000fffe0ffULL,
0x0000002038387810ULL, 0x000fca0007ffe0ffULL, 0x000000010c3b7824ULL, 0x100fe400078e0238ULL,
0x0000680039397a24ULL, 0x000fc600078e0238ULL, 0x000000603b00720cULL, 0x000fe20003fc6070ULL,
0x000000010c397824ULL, 0x000fc800078e0239ULL, 0x0000660039387625ULL, 0x000fd000078e003aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383d7faeULL, 0x0003e4000f121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b7800ff387f8cULL, 0x000e62000c80043fULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x000000ffff6b7224ULL, 0x002fe200078e0039ULL,
0x0000014000003947ULL, 0x000fea0003800000ULL, 0x0000000aff08723eULL, 0x000fc800000010ffULL,
0x00005410083a7816ULL, 0x000fe20000000008ULL, 0x00013cf27f007947ULL, 0x000fea000b800000ULL,
0x00001f623a097589ULL, 0x0002a400000e0000ULL, 0x00013d527f007947ULL, 0x000fea000b800000ULL,
0x00001f613a087589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010623f7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x00015b6000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0001478000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3e7224ULL, 0x004fe200078e003aULL,
0x00000018623f7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff407424ULL, 0x000fe200078e00ffULL,
0x00015bd000387802ULL, 0x000fe20000000f00ULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0001471000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000663c783bULL, 0x006e620000004200ULL,
0x00001e3000017945ULL, 0x000fe60003800000ULL, 0x000000006540783bULL, 0x000ea80000004200ULL,
0x000000006444783bULL, 0x000f220000004200ULL, 0x0000003c00387306ULL, 0x002ff00000009400ULL,
0x0000003c00397306ULL, 0x000e700000005400ULL, 0x0000003c004c7306ULL, 0x000ee2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000003d004d7306ULL, 0x000ff0000000d400ULL,
0x0000003d00387306ULL, 0x000fe20000009400ULL, 0x000000014c4c6812ULL, 0x008fce00078efcffULL,
0x0000003d00397306ULL, 0x000e700000005400ULL, 0x0000003e004b7306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000003f004a7306ULL, 0x000ff0000000d400ULL,
0x0000003e00387306ULL, 0x000fe20000009400ULL, 0x000000014d4d6812ULL, 0x000fce00078efcffULL,
0x0000003e00397306ULL, 0x000e700000005400ULL, 0x0000004000497306ULL, 0x004fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004100487306ULL, 0x000ff0000000d400ULL,
0x0000003f00387306ULL, 0x000fe20000009400ULL, 0x000000014b4b6812ULL, 0x000fce00078efcffULL,
0x0000003f00397306ULL, 0x000e700000005400ULL, 0x00000042007a7306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004300787306ULL, 0x000ff0000000d400ULL,
0x0000004000387306ULL, 0x000fe20000009400ULL, 0x000000014a4a6812ULL, 0x000fce00078efcffULL,
0x0000004000397306ULL, 0x000e700000005400ULL, 0x0000004400767306ULL, 0x010fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004500757306ULL, 0x000ff0000000d400ULL,
0x0000004100387306ULL, 0x000fe20000009400ULL, 0x0000000149496812ULL, 0x000fce00078efcffULL,
0x0000004100397306ULL, 0x000e700000005400ULL, 0x0000004600727306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004700707306ULL, 0x000ff0000000d400ULL,
0x0000004200387306ULL, 0x000fe20000009400ULL, 0x0000000148486812ULL, 0x000fce00078efcffULL,
0x0000004200397306ULL, 0x000e640000005400ULL, 0x000000393800720bULL, 0x002fcc0003fdd000ULL,
0x0000004300387306ULL, 0x000ff00000009400ULL, 0x0000004300397306ULL, 0x000e620000005400ULL,
0x000000017a7a6812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004400387306ULL, 0x000ff00000009400ULL, 0x0000004400397306ULL, 0x000e620000005400ULL,
0x0000000178786812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004500387306ULL, 0x000ff00000009400ULL, 0x0000004500397306ULL, 0x000e620000005400ULL,
0x0000000176766812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004600387306ULL, 0x000ff00000009400ULL, 0x0000004600397306ULL, 0x000e620000005400ULL,
0x0000000175756812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004700387306ULL, 0x000ff00000009400ULL, 0x0000004700397306ULL, 0x000e620000005400ULL,
0x0000000172726812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fc40003fdd000ULL,
0x000000006338783bULL, 0x000e760000004200ULL, 0x0000000170706812ULL, 0x000fe200078efcffULL,
0x00000038004e7306ULL, 0x002fe20000009400ULL, 0x00000018ff577819ULL, 0x000fce000001143aULL,
0x00000038004f7306ULL, 0x000e700000005400ULL, 0x00000038006e7306ULL, 0x000ea2000000d400ULL,
0x0000004f4e00720bULL, 0x002fce0003fdd000ULL, 0x00000039006d7306ULL, 0x000ff0000000d400ULL,
0x00000039004e7306ULL, 0x000fe20000009400ULL, 0x000000016e6e6812ULL, 0x004fce00078efcffULL,
0x00000039004f7306ULL, 0x000e700000005400ULL, 0x0000003a006c7306ULL, 0x000fe2000000d400ULL,
0x0000004f4e00720bULL, 0x002fce0003fdd000ULL, 0x00000057006f7306ULL, 0x000ff0000020d400ULL,
0x0000003a004e7306ULL, 0x000fe20000009400ULL, 0x000000016d6d6812ULL, 0x000fce00078efcffULL,
0x0000003a004f7306ULL, 0x000e640000005400ULL, 0x0000004f4e00720bULL, 0x002fe40003fdd000ULL,
0x00000018ff4e7819ULL, 0x000fc8000001143cULL, 0x0000004e004f7306ULL, 0x000fee0000209400ULL,
0x000000016c6c6812ULL, 0x000fe200078efcffULL, 0x0000004e00507306ULL, 0x000e700000205400ULL,
0x0000004e00517306ULL, 0x000ea2000020d400ULL, 0x000000504f00720bULL, 0x002fc40003fdd000ULL,
0x00000018ff4f7819ULL, 0x000fca000001143dULL, 0x0000004f00527306ULL, 0x000fec0000209400ULL,
0x0000000151516812ULL, 0x004fe400078efcffULL, 0x0000004f00537306ULL, 0x000e700000205400ULL,
0x0000004f00507306ULL, 0x000ea2000020d400ULL, 0x000000535200720bULL, 0x002fc40003fdd000ULL,
0x00000018ff527819ULL, 0x000fca000001143eULL, 0x0000005200537306ULL, 0x000fec0000209400ULL,
0x0000000150506812ULL, 0x004fe400078efcffULL, 0x0000005200547306ULL, 0x000e700000205400ULL,
0x00000052004e7306ULL, 0x000ea2000020d400ULL, 0x000000545300720bULL, 0x002fc40003fdd000ULL,
0x00000018ff537819ULL, 0x000fca000001143fULL, 0x0000005300547306ULL, 0x000fec0000209400ULL,
0x000000014e4e6812ULL, 0x004fe400078efcffULL, 0x0000005300557306ULL, 0x000e700000205400ULL,
0x00000053004f7306ULL, 0x0004e2000020d400ULL, 0x000000555400720bULL, 0x002fc40003fdd000ULL,
0x00000018ff547819ULL, 0x000fe40000011440ULL, 0x00000018ff537819ULL, 0x004fc60000011442ULL,
0x0000005400557306ULL, 0x000fec0000209400ULL, 0x000000014f4f6812ULL, 0x008fe400078efcffULL,
0x0000005400527306ULL, 0x000e700000205400ULL, 0x00000054007f7306ULL, 0x000ea2000020d400ULL,
0x000000525500720bULL, 0x002fce0003fdd000ULL, 0x0000005300547306ULL, 0x000fe20000205400ULL,
0x00000018ff527819ULL, 0x000fce0000011441ULL, 0x0000005200557306ULL, 0x000fe20000209400ULL,
0x000000017f7f6812ULL, 0x004fce00078efcffULL, 0x0000005200587306ULL, 0x000e700000205400ULL,
0x00000052007e7306ULL, 0x000ea2000020d400ULL, 0x000000585500720bULL, 0x002fce0003fdd000ULL,
0x00000053007c7306ULL, 0x000ff0000020d400ULL, 0x0000005300557306ULL, 0x0002e20000209400ULL,
0x000000017e7e6812ULL, 0x004fe400078efcffULL, 0x00000018ff537819ULL, 0x002fca0000011445ULL,
0x0000005300797306ULL, 0x000fe2000020d400ULL, 0x000000545500720bULL, 0x008fe40003fdd000ULL,
0x00000018ff547819ULL, 0x000fca0000011443ULL, 0x0000005400557306ULL, 0x000fec0000209400ULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x0000005400527306ULL, 0x000e700000205400ULL,
0x00000054007d7306ULL, 0x000ea2000020d400ULL, 0x000000525500720bULL, 0x002fce0003fdd000ULL,
0x0000005300547306ULL, 0x000fe20000205400ULL, 0x00000018ff527819ULL, 0x000fce0000011444ULL,
0x0000005200557306ULL, 0x000fe20000209400ULL, 0x000000017d7d6812ULL, 0x004fce00078efcffULL,
0x0000005200587306ULL, 0x000e700000205400ULL, 0x00000052007b7306ULL, 0x000ea2000020d400ULL,
0x000000585500720bULL, 0x002fce0003fdd000ULL, 0x0000005300557306ULL, 0x0002e40000209400ULL,
0x00000018ff537819ULL, 0x002fc80000011438ULL, 0x000000017b7b6812ULL, 0x004fe400078efcffULL,
0x0000005300737306ULL, 0x000fe2000020d400ULL, 0x000000545500720bULL, 0x008fe40003fdd000ULL,
0x00000018ff547819ULL, 0x000fca0000011446ULL, 0x0000005400557306ULL, 0x000fec0000209400ULL,
0x0000000179796812ULL, 0x000fe400078efcffULL, 0x0000005400527306ULL, 0x000e700000205400ULL,
0x0000005400777306ULL, 0x000ea2000020d400ULL, 0x000000525500720bULL, 0x002fce0003fdd000ULL,
0x0000005300547306ULL, 0x000fe20000205400ULL, 0x00000018ff527819ULL, 0x000fce0000011447ULL,
0x0000005200557306ULL, 0x000fe20000209400ULL, 0x0000000177776812ULL, 0x004fce00078efcffULL,
0x0000005200587306ULL, 0x000e700000205400ULL, 0x0000005200747306ULL, 0x000ea2000020d400ULL,
0x000000585500720bULL, 0x002fce0003fdd000ULL, 0x0000005300557306ULL, 0x000e700000209400ULL,
0x0000005700537306ULL, 0x000fe20000205400ULL, 0x0000000174746812ULL, 0x004fe400078efcffULL,
0x000000545500720bULL, 0x002fc40003fdd000ULL, 0x00000018ff547819ULL, 0x000fc80000011439ULL,
0x0000005400557306ULL, 0x000fee0000209400ULL, 0x0000000173736812ULL, 0x000fe200078efcffULL,
0x0000005400527306ULL, 0x000e700000205400ULL, 0x0000005400717306ULL, 0x000ea2000020d400ULL,
0x000000525500720bULL, 0x002fce0003fdd000ULL, 0x0000005700527306ULL, 0x000e6c0000209400ULL,
0x0000000171716812ULL, 0x004fe400078efcffULL, 0x000000535200720bULL, 0x002fe20003fdd000ULL,
0x000001003c527824ULL, 0x040fe400078e00ffULL, 0x000100003c3c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff527819ULL, 0x000fc80000011452ULL, 0x0000005200547306ULL, 0x000fe60000209400ULL,
0x000000016f6f6812ULL, 0x000fca00078efcffULL, 0x0000005200557306ULL, 0x000e700000205400ULL,
0x0000005200537306ULL, 0x000ea2000020d400ULL, 0x000000555400720bULL, 0x002fe40003fdd000ULL,
0x00000018ff557819ULL, 0x000fca000001143cULL, 0x00000055003c7306ULL, 0x000fec0000209400ULL,
0x0000000153536812ULL, 0x004fe400078efcffULL, 0x0000005500577306ULL, 0x000e640000205400ULL,
0x0000004c534c723eULL, 0x000fcc00000010ffULL, 0x0000005500547306ULL, 0x000ea2000020d400ULL,
0x000000573c00720bULL, 0x002fe20003fdd000ULL, 0x000001003d3c7824ULL, 0x040fe400078e00ffULL,
0x000100003d3d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff527819ULL, 0x000fe4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005200577306ULL, 0x000fe60000209400ULL,
0x0000000154546812ULL, 0x004fc800078efcffULL, 0x000000545154723eULL, 0x000fe200000010ffULL,
0x0000005200587306ULL, 0x000e700000205400ULL, 0x00000052003c7306ULL, 0x000ea2000020d400ULL,
0x000000585700720bULL, 0x002fce0003fdd000ULL, 0x0000003d00557306ULL, 0x000ff0000020d400ULL,
0x0000003d00577306ULL, 0x000fe20000209400ULL, 0x000000013c3c6812ULL, 0x004fce00078efcffULL,
0x0000003d00587306ULL, 0x000e620000205400ULL, 0x0000004d3c4d723eULL, 0x000fe400000010ffULL,
0x00013000673c7811ULL, 0x000fe400078e20ffULL, 0x000000585700720bULL, 0x002fe20003fdd000ULL,
0x000001003e577824ULL, 0x040fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000005700587306ULL, 0x000fe60000209400ULL, 0x0000000155556812ULL, 0x000fc800078efcffULL,
0x000000555055723eULL, 0x000fe200000010ffULL, 0x0000005700597306ULL, 0x000e700000205400ULL,
0x0000005700527306ULL, 0x000ea2000020d400ULL, 0x000000595800720bULL, 0x002fce0003fdd000ULL,
0x0000003e003d7306ULL, 0x000ff0000020d400ULL, 0x0000003e00587306ULL, 0x000fe20000209400ULL,
0x0000000152526812ULL, 0x004fce00078efcffULL, 0x0000003e00597306ULL, 0x000e620000205400ULL,
0x0000004b5250723eULL, 0x000fe400000010ffULL, 0x000000595800720bULL, 0x002fe20003fdd000ULL,
0x000001003f587824ULL, 0x040fe400078e00ffULL, 0x000100003f3f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000005800577306ULL, 0x000fe60000209400ULL, 0x000000013d3d6812ULL, 0x000fc800078efcffULL,
0x0000003d4e4e723eULL, 0x000fe200000010ffULL, 0x00000058005a7306ULL, 0x000e700000205400ULL,
0x0000005800817306ULL, 0x000ea2000020d400ULL, 0x0000005a5700720bULL, 0x002fce0003fdd000ULL,
0x0000003f003e7306ULL, 0x000ff0000020d400ULL, 0x0000003f00577306ULL, 0x000fe20000209400ULL,
0x0000000181816812ULL, 0x004fce00078efcffULL, 0x0000003f005a7306ULL, 0x000e620000205400ULL,
0x0000004a8151723eULL, 0x000fe400000010ffULL, 0x0000005a5700720bULL, 0x002fe20003fdd000ULL,
0x0000010040577824ULL, 0x040fe400078e00ffULL, 0x0001000040407824ULL, 0x000fc600078e00ffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff3f7819ULL, 0x000fe40000011440ULL,
0x0000005700587306ULL, 0x000fe60000209400ULL, 0x000000013e3e6812ULL, 0x000fc800078efcffULL,
0x0000003e4f4f723eULL, 0x000fe200000010ffULL, 0x0000005700597306ULL, 0x000e700000205400ULL,
0x0000005700807306ULL, 0x000ea2000020d400ULL, 0x000000595800720bULL, 0x002fce0003fdd000ULL,
0x0000003f00407306ULL, 0x000ff0000020d400ULL, 0x0000003f00587306ULL, 0x000fe20000209400ULL,
0x0000000180806812ULL, 0x004fce00078efcffULL, 0x0000003f00597306ULL, 0x000e620000205400ULL,
0x00000049804a723eULL, 0x000fe400000010ffULL, 0x000000595800720bULL, 0x002fe20003fdd000ULL,
0x0000010041587824ULL, 0x040fe400078e00ffULL, 0x0001000041417824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000018ff3f7819ULL, 0x000fe40000011441ULL,
0x0000005800577306ULL, 0x000fe60000209400ULL, 0x0000000140406812ULL, 0x000fc800078efcffULL,
0x000000407f40723eULL, 0x000fe200000010ffULL, 0x00000058005a7306ULL, 0x000e700000205400ULL,
0x0000005800877306ULL, 0x000ea2000020d400ULL, 0x0000005a5700720bULL, 0x002fce0003fdd000ULL,
0x0000003f00417306ULL, 0x000ff0000020d400ULL, 0x0000003f00577306ULL, 0x000fe20000209400ULL,
0x0000000187876812ULL, 0x004fce00078efcffULL, 0x0000003f005a7306ULL, 0x000e620000205400ULL,
0x00000048874b723eULL, 0x000fce00000010ffULL, 0x0000003b007f7306ULL, 0x000fe20000005400ULL,
0x0000005a5700720bULL, 0x002fe20003fdd000ULL, 0x0000010042577824ULL, 0x040fe400078e00ffULL,
0x0001000042427824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x0000005700587306ULL, 0x000fe60000209400ULL,
0x0000000141416812ULL, 0x000fc800078efcffULL, 0x000000417e41723eULL, 0x000fe200000010ffULL,
0x0000005700597306ULL, 0x000e700000205400ULL, 0x0000005700857306ULL, 0x000ea2000020d400ULL,
0x000000595800720bULL, 0x002fce0003fdd000ULL, 0x00000042003f7306ULL, 0x000ff00000209400ULL,
0x0000004200587306ULL, 0x000e620000205400ULL, 0x0000000185856812ULL, 0x004fce00078efcffULL,
0x0000004200837306ULL, 0x000ea2000020d400ULL, 0x000000583f00720bULL, 0x002fe20003fdd000ULL,
0x00000100433f7824ULL, 0x040fe400078e00ffULL, 0x0001000043437824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000003f00577306ULL, 0x000fe60000209400ULL, 0x0000000183836812ULL, 0x004fc800078efcffULL,
0x000000837c7c723eULL, 0x000fe200000010ffULL, 0x0000003f00587306ULL, 0x000e700000205400ULL,
0x0000003f00897306ULL, 0x000ea2000020d400ULL, 0x000000585700720bULL, 0x002fce0003fdd000ULL,
0x0000004300427306ULL, 0x000ff00000209400ULL, 0x0000004300577306ULL, 0x000e620000205400ULL,
0x0000000189896812ULL, 0x004fce00078efcffULL, 0x0000004300887306ULL, 0x000ea2000020d400ULL,
0x000000574200720bULL, 0x002fe20003fdd000ULL, 0x0000010044427824ULL, 0x040fe400078e00ffULL,
0x0001000044447824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x00000042003f7306ULL, 0x000fe60000209400ULL,
0x0000000188886812ULL, 0x004fc800078efcffULL, 0x000000887d7d723eULL, 0x000fe200000010ffULL,
0x0000004200587306ULL, 0x000e700000205400ULL, 0x00000042008b7306ULL, 0x000ea2000020d400ULL,
0x000000583f00720bULL, 0x002fce0003fdd000ULL, 0x0000004400827306ULL, 0x000ff0000020d400ULL,
0x00000044003f7306ULL, 0x000fe20000209400ULL, 0x000000018b8b6812ULL, 0x004fce00078efcffULL,
0x0000004400587306ULL, 0x000e640000205400ULL, 0x000000583f00720bULL, 0x002fe20003fdd000ULL,
0x00000100453f7824ULL, 0x040fe400078e00ffULL, 0x0001000045457824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000003f00427306ULL, 0x000fe60000209400ULL, 0x0000000182826812ULL, 0x000fca00078efcffULL,
0x0000003f00437306ULL, 0x000e700000205400ULL, 0x0000003f008a7306ULL, 0x000ea2000020d400ULL,
0x000000434200720bULL, 0x002fce0003fdd000ULL, 0x0000004500847306ULL, 0x000ff0000020d400ULL,
0x0000004500427306ULL, 0x000fe20000209400ULL, 0x000000018a8a6812ULL, 0x004fce00078efcffULL,
0x0000004500437306ULL, 0x000e640000205400ULL, 0x000000434200720bULL, 0x002fe20003fdd000ULL,
0x0000010046427824ULL, 0x040fe400078e00ffULL, 0x0001000046467824ULL, 0x000fc600078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x00000042003f7306ULL, 0x000fe60000209400ULL, 0x0000000184846812ULL, 0x000fc800078efcffULL,
0x000000847979723eULL, 0x000fe200000010ffULL, 0x0000004200447306ULL, 0x000e700000205400ULL,
0x00000042008d7306ULL, 0x000ea2000020d400ULL, 0x000000443f00720bULL, 0x002fce0003fdd000ULL,
0x0000004600867306ULL, 0x000ff0000020d400ULL, 0x00000046003f7306ULL, 0x000fe20000209400ULL,
0x000000018d8d6812ULL, 0x004fce00078efcffULL, 0x0000004600447306ULL, 0x000e640000205400ULL,
0x000000443f00720bULL, 0x002fe20003fdd000ULL, 0x00000100473f7824ULL, 0x040fe400078e00ffULL,
0x0001000047477824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000003f00427306ULL, 0x000fe60000209400ULL,
0x0000000186866812ULL, 0x000fc800078efcffULL, 0x000000867786723eULL, 0x000fe200000010ffULL,
0x0000003f00437306ULL, 0x000e700000205400ULL, 0x0000003f008f7306ULL, 0x000ea2000020d400ULL,
0x000000434200720bULL, 0x002fce0003fdd000ULL, 0x0000004700917306ULL, 0x000ff0000020d400ULL,
0x0000004700427306ULL, 0x000fe20000209400ULL, 0x000000018f8f6812ULL, 0x004fce00078efcffULL,
0x0000004700437306ULL, 0x000e640000205400ULL, 0x000000434200720bULL, 0x002fe20003fdd000ULL,
0x0000010038427824ULL, 0x040fe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000042003f7306ULL, 0x000fe60000209400ULL, 0x0000000191916812ULL, 0x000fc800078efcffULL,
0x000000917487723eULL, 0x000fe200000010ffULL, 0x0000004200447306ULL, 0x000e700000205400ULL,
0x0000004200937306ULL, 0x000ea2000020d400ULL, 0x000000443f00720bULL, 0x002fce0003fdd000ULL,
0x00000038008c7306ULL, 0x000ff0000020d400ULL, 0x00000038003f7306ULL, 0x000fe20000209400ULL,
0x0000000193936812ULL, 0x004fce00078efcffULL, 0x0000003800447306ULL, 0x000e640000205400ULL,
0x000000443f00720bULL, 0x002fe20003fdd000ULL, 0x00000100393f7824ULL, 0x040fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003f00427306ULL, 0x000fe60000209400ULL,
0x000000018c8c6812ULL, 0x000fca00078efcffULL, 0x0000003f00437306ULL, 0x000e700000205400ULL,
0x0000003f008e7306ULL, 0x000ea2000020d400ULL, 0x000000434200720bULL, 0x002fce0003fdd000ULL,
0x0000003900387306ULL, 0x000ff00000209400ULL, 0x0000003900437306ULL, 0x000e620000205400ULL,
0x000000018e8e6812ULL, 0x004fce00078efcffULL, 0x0000003900907306ULL, 0x000ea2000020d400ULL,
0x000000433800720bULL, 0x002fe20003fdd000ULL, 0x000001003a387824ULL, 0x040fe200078e00ffULL,
0x000000788943723eULL, 0x000fe200000010ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x000000827b78723eULL, 0x000fe400000010ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x00000038003f7306ULL, 0x000fe60000209400ULL,
0x0000000190906812ULL, 0x004fc800078efcffULL, 0x000000907171723eULL, 0x000fe200000010ffULL,
0x0000003800427306ULL, 0x000e700000205400ULL, 0x0000003800957306ULL, 0x000ea2000020d400ULL,
0x000000423f00720bULL, 0x002fce0003fdd000ULL, 0x0000003a00397306ULL, 0x000ff00000209400ULL,
0x0000003a00427306ULL, 0x000e620000205400ULL, 0x0000000195956812ULL, 0x004fce00078efcffULL,
0x0000003a00927306ULL, 0x000ea2000020d400ULL, 0x0000006c956c723eULL, 0x000fe400000010ffULL,
0x000000423900720bULL, 0x002fe20003fdd000ULL, 0x000001003b397824ULL, 0x000fc800078e00ffULL,
0x0000003b003a7306ULL, 0x000fe20000009400ULL, 0x0000007a8542723eULL, 0x000fe400000010ffULL,
0x00000018ff397819ULL, 0x000fca0000011439ULL, 0x0000003900387306ULL, 0x000fe20000209400ULL,
0x0000000192926812ULL, 0x004fc800078efcffULL, 0x000000926f92723eULL, 0x000fc600000010ffULL,
0x00000039003f7306ULL, 0x000e700000205400ULL, 0x0000003900977306ULL, 0x0004e2000020d400ULL,
0x0000003f3800720bULL, 0x002fce0003fdd000ULL, 0x0000003b007a7306ULL, 0x000322000000d400ULL,
0x0001300068387811ULL, 0x000fe200078e20ffULL, 0x000000003c3c783bULL, 0x000f220000000200ULL,
0x000000758a39723eULL, 0x004fc600000010ffULL, 0x00000000385c783bULL, 0x0005220000000200ULL,
0x0000000197976812ULL, 0x008fe200078efcffULL, 0x000100003b387824ULL, 0x004fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x002fe4000001143bULL, 0x000000ff5600720cULL, 0x000fe40003fc5270ULL,
0x00000018ff7e7819ULL, 0x000fe40000011438ULL, 0x000000768b38723eULL, 0x000fe400000010ffULL,
0x0000007e00807306ULL, 0x000ff00000209400ULL, 0x0000007e00757306ULL, 0x000e700000205400ULL,
0x0000003b00767306ULL, 0x000fe20000209400ULL, 0x000000093c3cb231ULL, 0x010fc400003400ffULL,
0x000000093e3eb231ULL, 0x080fe400003400ffULL, 0x000000095c5cb231ULL, 0x080fe400003400ffULL,
0x000000095e5eb231ULL, 0x000fe400003400ffULL, 0x000000085d5db231ULL, 0x080fe400003400ffULL,
0x000000085f5fb231ULL, 0x080fe400003400ffULL, 0x000000083d3db231ULL, 0x000fc400003400ffULL,
0x000000083f3fb231ULL, 0x000fe200003400ffULL, 0x0000007f3a00720bULL, 0x000fe40003f7d000ULL,
0x0000004c5c58723cULL, 0x040f6200000418ffULL, 0x0000007e003a7306ULL, 0x000eae000020d400ULL,
0x000000505c50723cULL, 0x000f6600000418ffULL, 0x000000017a7a3812ULL, 0x000fc400078efcffULL,
0x000000758000720bULL, 0x002fe40003f7d000ULL, 0x0000003b00757306ULL, 0x000e620000205400ULL,
0x000000405c44723cULL, 0x000ff000000418ffULL, 0x000000383c58723cULL, 0x020be40000041858ULL,
0x000000013a3a3812ULL, 0x004fca00078efcffULL, 0x000000728d38723eULL, 0x020fe200000010ffULL,
0x000000545c54723cULL, 0x000f6200000418ffULL, 0x000000708f39723eULL, 0x000fe400000010ffULL,
0x000000757600720bULL, 0x002fe40003f7d000ULL, 0x0000008c7370723eULL, 0x000fc600000010ffULL,
0x000000383c50723cULL, 0x000bee0000041850ULL, 0x0000006e9338723eULL, 0x020fe200000010ffULL,
0x0000004e5c4c723cULL, 0x000f6200000418ffULL, 0x0000003b00937306ULL, 0x000e62000020d400ULL,
0x0000006d8e39723eULL, 0x000fc400000010ffULL, 0x0000007a976d723eULL, 0x000fc800000010ffULL,
0x0000004a5c48723cULL, 0x040f7000000418ffULL, 0x000000425c40723cULL, 0x000f6200000418ffULL,
0x0000000193933812ULL, 0x002fc800078efcffULL, 0x0000003a9393723eULL, 0x000fc600000010ffULL,
0x0000007c5c5c723cULL, 0x000f7000000418ffULL, 0x000000783c54723cULL, 0x040b700000041854ULL,
0x000000863c4c723cULL, 0x060b70000004184cULL, 0x000000383c48723cULL, 0x040b700000041848ULL,
0x000000703c44723cULL, 0x040b700000041844ULL, 0x0000006c3c40723cULL, 0x040b700000041840ULL,
0x000000923c5c723cULL, 0x000b62000004185cULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000005812127221ULL, 0x000fe40000010000ULL,
0x0000005913137221ULL, 0x000fc40000010000ULL, 0x0000005416167221ULL, 0x000fe40000010000ULL,
0x0000005517177221ULL, 0x000fe40000010000ULL, 0x000000501a1a7221ULL, 0x000fe40000010000ULL,
0x000000511b1b7221ULL, 0x000fe40000010000ULL, 0x0000004c1e1e7221ULL, 0x020fe40000010000ULL,
0x0000004d1f1f7221ULL, 0x000fc40000010000ULL, 0x0000004822227221ULL, 0x000fe40000010000ULL,
0x0000004923237221ULL, 0x000fe40000010000ULL, 0x0000004426267221ULL, 0x000fe40000010000ULL,
0x0000004527277221ULL, 0x000fe40000010000ULL, 0x000000402a2a7221ULL, 0x000fe40000010000ULL,
0x000000412b2b7221ULL, 0x000fc40000010000ULL, 0x0000005c2e2e7221ULL, 0x000fe40000010000ULL,
0x0000005d2f2f7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x0000005a14147221ULL, 0x000fe40000010000ULL, 0x0000005b15157221ULL, 0x000fe40000010000ULL,
0x0000005618187221ULL, 0x000fe40000010000ULL, 0x0000005719197221ULL, 0x000fe40000010000ULL,
0x000000521c1c7221ULL, 0x000fc40000010000ULL, 0x000000531d1d7221ULL, 0x000fe40000010000ULL,
0x0000004e20207221ULL, 0x020fe40000010000ULL, 0x0000004f21217221ULL, 0x000fe40000010000ULL,
0x0000004a24247221ULL, 0x000fe40000010000ULL, 0x0000004b25257221ULL, 0x000fe40000010000ULL,
0x0000004628287221ULL, 0x000fc40000010000ULL, 0x0000004729297221ULL, 0x000fe40000010000ULL,
0x000000422c2c7221ULL, 0x000fe40000010000ULL, 0x000000432d2d7221ULL, 0x000fe40000010000ULL,
0x0000005e30307221ULL, 0x000fe40000010000ULL, 0x0000005f31317221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000016a6a7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x020e62000c80043fULL,
0x000000696a00720cULL, 0x000fe20003f06070ULL, 0x000000ffff3c7224ULL, 0x002fd800078e0039ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff8c6000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c00f397811ULL, 0x000fe200078e40ffULL,
0x018b6800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000603900720cULL, 0x000fda0003f06070ULL,
0x0000741000000947ULL, 0x000fea0003800000ULL, 0x000000ffff6a7224ULL, 0x000fca00078e00ffULL,
0x00000002ff397819ULL, 0x000fe2000001166aULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000036a387812ULL, 0x040fe200078ec0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x000000396a397207ULL, 0x000fe40002800000ULL, 0x000000ff383f7207ULL, 0x000fe40006800000ULL,
0x0000000339407810ULL, 0x000fc80007ffe0ffULL, 0x0000000340417812ULL, 0x040fe400078ec0ffULL,
0x0000000f40437211ULL, 0x000fc400078ff0ffULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x018b7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x018b8c00ff3b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000143397810ULL, 0x040fe20007ffe0ffULL, 0x0000000443387824ULL, 0x000fe200078e0241ULL,
0x0000097000017945ULL, 0x000fe40003800000ULL, 0x000000363900720cULL, 0x000fe40003f06070ULL,
0x00000020383b7811ULL, 0x000fc800078e30ffULL, 0x0000006033427812ULL, 0x000fce00078ef83bULL,
0x000004f000008947ULL, 0x000fea0003800000ULL, 0x0000000507457c10ULL, 0x040fe2000fffe0ffULL,
0x00000010323c7824ULL, 0x000fe200078e00ffULL, 0x0000003b60387217ULL, 0x000fe20007800000ULL,
0x00000100ff477424ULL, 0x000fe200078e00ffULL, 0x00000002074d7810ULL, 0x000fe20007ffe0ffULL,
0x018a000045397984ULL, 0x000e620000004800ULL, 0x000000f03c497812ULL, 0x000fe200078ec0ffULL,
0x0000000138387824ULL, 0x000fe200078e0a3bULL, 0x000000054d4f7c10ULL, 0x000fe2000fffe0ffULL,
0x00000001453b7824ULL, 0x040fe400078e0242ULL, 0x00000010453e7824ULL, 0x000fe200078e00ffULL,
0x0000000538387c17ULL, 0x000fc8000f800000ULL, 0x80000005383c7c10ULL, 0x000fc8000fffe0ffULL,
0x0000003c0700720cULL, 0x000fe20003f06070ULL, 0x018ac000393a7984ULL, 0x002e640000004800ULL,
0x0000003a0d3a7224ULL, 0x002fe400078e023bULL, 0x00000001453b7824ULL, 0x000fe400078e0232ULL,
0x00005e003a387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe40007f3e0ffULL,
0xfffffff03e387812ULL, 0x000fe200078ee23bULL, 0x000000014f3e7824ULL, 0x040fe400078e0232ULL,
0x000000ffff3b7224ULL, 0x000fe200008e0639ULL, 0x00016000384b7811ULL, 0x000fe200078e20ffULL,
0x000000014f397824ULL, 0x040fe400078e0242ULL, 0x000000104f4f7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a4b7faeULL, 0x0003e2000c101c50ULL,
0x0000003c4d00720cULL, 0x000fc40003f06070ULL, 0xfffffff04f3e7812ULL, 0x000fe200078ee23eULL,
0x018a0800453d7984ULL, 0x000ea20000004800ULL, 0x00000004074d7810ULL, 0x000fc80007ffe0ffULL,
0x000000054d4f7c10ULL, 0x000fe4000fffe0ffULL, 0x000160003e4b7811ULL, 0x002fc600078e20ffULL,
0x000000014f3e7824ULL, 0x000fe200078e0232ULL, 0x018ac0003d387984ULL, 0x004e640000004800ULL,
0x000000380d387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0047ULL,
0x00000049383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x000000014f397824ULL, 0x040fe400078e0242ULL, 0x000000104f4f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a4b7faeULL, 0x0003e2000c101c50ULL,
0x0000003c4d00720cULL, 0x000fe40003f06070ULL, 0x00000006074d7810ULL, 0x000fe20007ffe0ffULL,
0x018a1000453d7984ULL, 0x000ea20000004800ULL, 0xfffffff04f3e7812ULL, 0x000fc400078ee23eULL,
0x000000054d4f7c10ULL, 0x000fe4000fffe0ffULL, 0x000160003e4b7811ULL, 0x002fc600078e20ffULL,
0x000000014f3e7824ULL, 0x000fe200078e0232ULL, 0x018ac0003d387984ULL, 0x004e640000004800ULL,
0x000000380d387224ULL, 0x002fc800078e0239ULL, 0x00005e0038387625ULL, 0x000fca00078e0047ULL,
0x00000049383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe400008e0639ULL,
0x000000014f397824ULL, 0x040fe400078e0242ULL, 0x000000104f4f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a4b7faeULL, 0x0003e2000c101c50ULL,
0x0000003c4d00720cULL, 0x000fc60003f06070ULL, 0x018a1800453d7984ULL, 0x000ea20000004800ULL,
0xfffffff04f3e7812ULL, 0x000fc800078ee23eULL, 0x000160003e3b7811ULL, 0x002fe200078e20ffULL,
0x018ac0003d387984ULL, 0x004e640000004800ULL, 0x000000380d387224ULL, 0x002fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x0000004938387210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff397224ULL, 0x000fca00008e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000c101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x0000000507457c10ULL, 0x000fe2000fffe0ffULL, 0x0000001032397824ULL, 0x000fe400078e00ffULL,
0x00000100ff477424ULL, 0x000fe200078e00ffULL, 0x00000002453d7810ULL, 0x040fe20007ffe0ffULL,
0x018a0000453c7984ULL, 0x000e620000004800ULL, 0x0000000145387824ULL, 0x000fe200078e0242ULL,
0x000000f039497812ULL, 0x000fe200078ec0ffULL, 0x00000001453b7824ULL, 0x040fe400078e0232ULL,
0x00000010453e7824ULL, 0x000fc400078e00ffULL, 0x000000013d447824ULL, 0x000fe200078e0232ULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff03e387812ULL, 0x000fc600078ee23bULL, 0x000000ffff3b7224ULL, 0x000fe200000e0639ULL,
0x00016000384b7811ULL, 0x000fe200078e20ffULL, 0x000000013d387824ULL, 0x040fe400078e0242ULL,
0x000000103d3d7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a4b7faeULL, 0x0003e6000b901c50ULL, 0xfffffff03d447812ULL, 0x000fe200078ee244ULL,
0x018a0800453e7984ULL, 0x000ea60000004800ULL, 0x00016000444b7811ULL, 0x002fc400078e20ffULL,
0x00000004453b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b447824ULL, 0x000fe200078e0232ULL,
0x018ac0003e3e7984ULL, 0x004e640000004800ULL, 0x0000003e0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383c7210ULL, 0x000fe20007f1e0ffULL,
0x000000013b387824ULL, 0x040fe400078e0242ULL, 0x000000103b3b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e0639ULL, 0xfffffff03b447812ULL, 0x000fe400078ee244ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c4b7faeULL, 0x0003e8000b901c50ULL,
0x018a1000453e7984ULL, 0x000ea20000004800ULL, 0x00016000443d7811ULL, 0x002fe400078e20ffULL,
0x00000006454b7810ULL, 0x000fe20007ffe0ffULL, 0x018ac0003e3e7984ULL, 0x004e640000004800ULL,
0x0000003e0d387224ULL, 0x002fc400078e0238ULL, 0x000000014b3e7824ULL, 0x000fe400078e0232ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe20007f1e0ffULL,
0x000000014b387824ULL, 0x040fe400078e0242ULL, 0x000000104b4b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600000e0639ULL, 0xfffffff04b3e7812ULL, 0x000fe400078ee23eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c50ULL,
0x018a1800453c7984ULL, 0x000ea20000004800ULL, 0x000160003e3b7811ULL, 0x002fc600078e20ffULL,
0x018ac0003c3c7984ULL, 0x004e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x0000004938387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff457224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000433400720cULL, 0x000fe20003f04070ULL, 0x0000015000017945ULL, 0x000fe20003800000ULL,
0x0000000140387812ULL, 0x000fe400078ec0ffULL, 0x000000033f00780cULL, 0x000fc80004705270ULL,
0x000000013800780cULL, 0x000fda0000705470ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x000000030c00780cULL, 0x000fe40003f04070ULL, 0x000000010e0e7810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000397919ULL, 0x000e620000002700ULL,
0x000000370e00720cULL, 0x000fe20003f06070ULL, 0x00000004ff3b7424ULL, 0x000fe200078e00ffULL,
0x00018ac00c3d7811ULL, 0x000fe200078e10ffULL, 0x0000000439387824ULL, 0x002fe200078e020cULL,
0x000064000e397a10ULL, 0x000fc60007ffe0ffULL, 0x0000000238387824ULL, 0x000fc800078e00ffULL,
0x0000640038387a24ULL, 0x000fc800078e0239ULL, 0x0000600038387625ULL, 0x000fca00078e003bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383d7faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000433400720cULL, 0x000fe40003f04070ULL,
0x000000013f387810ULL, 0x002fc80007ffe0ffULL, 0x0000000338397812ULL, 0x000fc800078ec0ffULL,
0x000000ff39397207ULL, 0x000fc60004000000ULL, 0x00000002ff388819ULL, 0x000fca0000011638ULL,
0x0000000141387824ULL, 0x000fc800078e0238ULL, 0x00000040383a7824ULL, 0x040fe200078e00ffULL,
0x0000004338387211ULL, 0x000fc800078ff0ffULL, 0x000000c03a3b7812ULL, 0x000fca00078ec0ffULL,
0x00000100383d7824ULL, 0x000fe200078e023bULL, 0x0000000a39387c10ULL, 0x000fc6000fffe0ffULL,
0x000000010c3b7824ULL, 0x100fe400078e023dULL, 0x0000680038397a24ULL, 0x000fe400078e023dULL,
0x00000004ff387424ULL, 0x000fe200078e00ffULL, 0x000000603b00720cULL, 0x000fe20003f06070ULL,
0x000000010c397824ULL, 0x040fe200078e0239ULL, 0x00018a000c3b7811ULL, 0x000fc600078e10ffULL,
0x0000660039387625ULL, 0x000fd000078e0038ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8000ff387f8cULL, 0x000e62000c80043fULL, 0x000000ff6a00720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff6b7224ULL, 0x002fd600078e0039ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b3800ff387f8cULL, 0x000e64000c800405ULL, 0x000000ffff3c7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b3c05ff0b7984ULL, 0x000e640008000800ULL,
0x800000000bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc8000001143bULL, 0x0000003a0b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff3a7224ULL, 0x000fca00000e063bULL, 0x000000020b0b7819ULL, 0x000fc8000000123aULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x018b3c05ff0b7984ULL, 0x000e640008000800ULL, 0x800000000bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00000010320b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff387819ULL, 0x000fc80000011632ULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c38387812ULL, 0x000fca00078ec0ffULL, 0x000000010b3f7824ULL, 0x000fca00078e0238ULL,
0x018180003f3b7984ULL, 0x000e680000000800ULL, 0x018380003f3a7984ULL, 0x0004e20000000800ULL,
0x000000103b00720bULL, 0x002fe20003f1d000ULL, 0x000103d27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0b427812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fd200078e0010ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000033500780cULL, 0x000fe40003f05270ULL, 0x000000103b00720bULL, 0x000fe20003f34000ULL,
0x000103a27f007947ULL, 0x000fd8000b800000ULL, 0x00000000003d7806ULL, 0x000fc400008e0100ULL,
0x0000003b103c7209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x000099103d387816ULL, 0x000fc600000000ffULL, 0x0185803c3f008388ULL, 0x0003e20000000800ULL,
0x000000ff3800720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000003c10107221ULL, 0x002fe20000010000ULL, 0x000000ff3dff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000447308ULL, 0x000e640000000800ULL, 0x0000004411117220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000103027f007947ULL, 0x000fea000b800000ULL,
0x00001f6244107589ULL, 0x0002a400000e0000ULL, 0x0000001012127220ULL, 0x084fe40000410000ULL,
0x0000001013137220ULL, 0x080fe40000410000ULL, 0x0000001016167220ULL, 0x080fe40000410000ULL,
0x0000001017177220ULL, 0x080fe40000410000ULL, 0x000000101a1a7220ULL, 0x080fe40000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x000000101e1e7220ULL, 0x080fe40000410000ULL,
0x000000101f1f7220ULL, 0x080fe40000410000ULL, 0x0000001022227220ULL, 0x080fe40000410000ULL,
0x0000001023237220ULL, 0x080fe40000410000ULL, 0x0000001026267220ULL, 0x080fe40000410000ULL,
0x0000001027277220ULL, 0x000fc40000410000ULL, 0x000000102a2a7220ULL, 0x080fe40000410000ULL,
0x000000102b2b7220ULL, 0x080fe40000410000ULL, 0x000000102e2e7220ULL, 0x080fe40000410000ULL,
0x000000102f2f7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff003dff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000102327f007947ULL, 0x000fea000b800000ULL, 0x00001f6144107589ULL, 0x00046400000e0000ULL,
0x0000001014147220ULL, 0x082fe40000410000ULL, 0x0000001015157220ULL, 0x080fe40000410000ULL,
0x0000001018187220ULL, 0x080fe40000410000ULL, 0x0000001019197220ULL, 0x080fe40000410000ULL,
0x000000101c1c7220ULL, 0x080fe40000410000ULL, 0x000000101d1d7220ULL, 0x000fc40000410000ULL,
0x0000001020207220ULL, 0x080fe40000410000ULL, 0x0000001021217220ULL, 0x080fe40000410000ULL,
0x0000001024247220ULL, 0x080fe40000410000ULL, 0x0000001025257220ULL, 0x080fe40000410000ULL,
0x0000001028287220ULL, 0x080fe40000410000ULL, 0x0000001029297220ULL, 0x000fc40000410000ULL,
0x000000102c2c7220ULL, 0x080fe40000410000ULL, 0x000000102d2d7220ULL, 0x080fe40000410000ULL,
0x0000001030307220ULL, 0x080fe40000410000ULL, 0x0000001031317220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff42ff7812ULL, 0x000fda000780603dULL,
0x8000003c3b3b0221ULL, 0x000fe20000010000ULL, 0x00007610ff0b0816ULL, 0x000fc6000000000bULL,
0x3fb8aa3b3b3b0820ULL, 0x000fc80000410000ULL, 0x0000003b000a0308ULL, 0x000e640000000800ULL,
0x0000000a3a3a0220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x000000113a117221ULL, 0x008fe40000010000ULL, 0x000000ffff107224ULL, 0x000fc400078e003cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff0bff7812ULL, 0x000fe2000786c0ffULL,
0x0000016000017945ULL, 0x000fd80003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x0000000aff08723eULL, 0x000fc800000010ffULL, 0x00005410083a7816ULL, 0x000fe20000000008ULL,
0x000100927f007947ULL, 0x000fea000b800000ULL, 0x00001f623a097589ULL, 0x0002e400000e0000ULL,
0x000100f27f007947ULL, 0x000fea000b800000ULL, 0x00001f613a087589ULL, 0x0002a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010623f7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x00019a7000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0001087000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e003aULL, 0x00000018623f7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff407424ULL, 0x000fe200078e00ffULL, 0x00019ae000387802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0001080000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000000640783bULL, 0x002e620000004200ULL, 0x00001e9000017945ULL, 0x000fe60003800000ULL,
0x000000000444783bULL, 0x004fe80000004200ULL, 0x00000000053c783bULL, 0x000ea80000004200ULL,
0x000000000338783bULL, 0x000f220000004200ULL, 0x00000018ff4d7819ULL, 0x002fe20000011443ULL,
0x0000010040797824ULL, 0x000fe200078e00ffULL, 0x0000004000cf7306ULL, 0x000fe20000009400ULL,
0x00000018ff4a7819ULL, 0x000fc40000011440ULL, 0x00000018ff4b7819ULL, 0x000fe40000011441ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000018ff7a7819ULL, 0x004fe2000001143dULL,
0x0000004d00c07306ULL, 0x000fe20000209400ULL, 0x00000018ff7f7819ULL, 0x000fe4000001143eULL,
0x00000018ff587819ULL, 0x010fe4000001143aULL, 0x00000018ff5c7819ULL, 0x000fc4000001143bULL,
0x00000018ff4c7819ULL, 0x000fe20000011442ULL, 0x0000004d00c37306ULL, 0x000fe20000205400ULL,
0x00000018ff807819ULL, 0x000fce000001143fULL, 0x0000004d005a7306ULL, 0x0003f0000020d400ULL,
0x0000007a00a37306ULL, 0x000fe20000209400ULL, 0x00000018ff4d7819ULL, 0x002fce0000011447ULL,
0x0000004d00b07306ULL, 0x000ff00000209400ULL, 0x0000004d00b17306ULL, 0x000ff00000205400ULL,
0x0000004d00747306ULL, 0x000ff0000020d400ULL, 0x0000007a00a27306ULL, 0x000ff00000205400ULL,
0x0000007a004d7306ULL, 0x000ff0000020d400ULL, 0x00000079007a7306ULL, 0x000ff00000209400ULL,
0x0000007900d17306ULL, 0x000e700000205400ULL, 0x0000005800757306ULL, 0x000ff00000209400ULL,
0x0000005800767306ULL, 0x000fe20000205400ULL, 0x000000d17a00720bULL, 0x002fce0003f5d000ULL,
0x00000058006c7306ULL, 0x000ff0000020d400ULL, 0x0000005c00777306ULL, 0x000ff00000209400ULL,
0x0000005c00787306ULL, 0x000ff00000205400ULL, 0x0000005c006d7306ULL, 0x000ff0000020d400ULL,
0x0000007f009f7306ULL, 0x000ff00000209400ULL, 0x0000007f00587306ULL, 0x000ff00000205400ULL,
0x0000007f005c7306ULL, 0x0003f0000020d400ULL, 0x0000004000ca7306ULL, 0x000ea20000005400ULL,
0x00000100417f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000007900b37306ULL, 0x000330000020d400ULL, 0x0000007f00ce7306ULL, 0x000fe20000209400ULL,
0x0000010042797824ULL, 0x002fe200078e00ffULL, 0x000000cacf00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000007f00d57306ULL, 0x000e620000205400ULL,
0x00000001b3b32812ULL, 0x010fce00078efcffULL, 0x0000004000a87306ULL, 0x000530000000d400ULL,
0x0000004a00cd7306ULL, 0x000fe20000209400ULL, 0x0001000040407824ULL, 0x004fe200078e00ffULL,
0x000000d5ce00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000004a00c87306ULL, 0x000e620000205400ULL, 0x00000001a8a86812ULL, 0x010fce00078efcffULL,
0x0000004a00a07306ULL, 0x000530000020d400ULL, 0x0000004100c47306ULL, 0x000fe20000009400ULL,
0x00000018ff4a7819ULL, 0x004fe40000011444ULL, 0x000000c8cd00720bULL, 0x002fca0003f3d000ULL,
0x0000004100c97306ULL, 0x000e700000005400ULL, 0x0000004b00c77306ULL, 0x000fe20000209400ULL,
0x00000001a0a01812ULL, 0x010fce00078efcffULL, 0x0000004b00c27306ULL, 0x000ea20000205400ULL,
0x000000c9c400720bULL, 0x002fce0003fdd000ULL, 0x0000004b009e7306ULL, 0x000330000020d400ULL,
0x0000004a00b87306ULL, 0x000fe20000209400ULL, 0x00000018ff4b7819ULL, 0x002fe40000011445ULL,
0x000000c2c700720bULL, 0x004fca0003f3d000ULL, 0x0000004a00bd7306ULL, 0x000ff00000205400ULL,
0x0000004a00887306ULL, 0x0003e2000020d400ULL, 0x000000019e9e1812ULL, 0x010fce00078efcffULL,
0x0000004200be7306ULL, 0x000fe20000009400ULL, 0x00000018ff4a7819ULL, 0x002fce0000011438ULL,
0x0000004200c57306ULL, 0x000ff00000005400ULL, 0x00000042009c7306ULL, 0x0003f0000000d400ULL,
0x0000007f00af7306ULL, 0x000522000020d400ULL, 0x0001000042427824ULL, 0x002fce00078e00ffULL,
0x0000007900d97306ULL, 0x000fe20000209400ULL, 0x00000018ff7f7819ULL, 0x004fe20000011442ULL,
0x0000010043427824ULL, 0x000fcc00078e00ffULL, 0x0000007900d27306ULL, 0x000e620000205400ULL,
0x00000001afaf2812ULL, 0x010fce00078efcffULL, 0x0000004c00cb7306ULL, 0x000ff00000209400ULL,
0x0000004c00c67306ULL, 0x000ea20000205400ULL, 0x000000d2d900720bULL, 0x002fce0003f5d000ULL,
0x0000004c005b7306ULL, 0x000330000020d400ULL, 0x0000004b00ba7306ULL, 0x000fe20000209400ULL,
0x00000018ff4c7819ULL, 0x002fe40000011446ULL, 0x000000c6cb00720bULL, 0x004fca0003f3d000ULL,
0x0000004b00c17306ULL, 0x000e700000205400ULL, 0x0000004b00847306ULL, 0x0004e2000020d400ULL,
0x000000015b5b1812ULL, 0x010fe400078efcffULL, 0x000000c3c000720bULL, 0x000fca0003f3d000ULL,
0x0000004a00527306ULL, 0x000fe20000209400ULL, 0x00000018ff4b7819ULL, 0x004fce0000011439ULL,
0x0000004a00537306ULL, 0x000fe20000205400ULL, 0x000000015a5a1812ULL, 0x000fe400078efcffULL,
0x000000bdb800720bULL, 0x000fca0003f3d000ULL, 0x0000004a00727306ULL, 0x0005f0000020d400ULL,
0x0000004000cc7306ULL, 0x000fe20000209400ULL, 0x00000018ff4a7819ULL, 0x004fe4000001143cULL,
0x0000000188881812ULL, 0x000fc400078efcffULL, 0x000000c1ba00720bULL, 0x002fe20003f3d000ULL,
0x000001003eba7824ULL, 0x000fe400078e00ffULL, 0x0000004000d37306ULL, 0x000e660000205400ULL,
0x00000018ffba7819ULL, 0x000fca00000114baULL, 0x0000004100a47306ULL, 0x000524000000d400ULL,
0x0000000184841812ULL, 0x008fcc00078efcffULL, 0x0000004c00b77306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x004fe200078e00ffULL, 0x000000d3cc00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004c00b47306ULL, 0x000e620000205400ULL,
0x00000001a4a46812ULL, 0x010fe400078efcffULL, 0x000000c5be00720bULL, 0x000fe20003fdd000ULL,
0x000001003dbe7824ULL, 0x000fc800078e00ffULL, 0x0000004c007e7306ULL, 0x000ea2000020d400ULL,
0x00000018ffbe7819ULL, 0x000fce00000114beULL, 0x0000004b00897306ULL, 0x000fe20000209400ULL,
0x000000019c9c6812ULL, 0x000fe400078efcffULL, 0x000000b4b700720bULL, 0x002fca0003f3d000ULL,
0x0000004b008a7306ULL, 0x000ff00000205400ULL, 0x0000004b006e7306ULL, 0x000fe2000020d400ULL,
0x000000017e7e1812ULL, 0x004fe400078efcffULL, 0x000000b1b000720bULL, 0x000fe20003f3d000ULL,
0x000001003bb17824ULL, 0x000fc400078e00ffULL, 0x000100003ab07824ULL, 0x000fe400078e00ffULL,
0x0000004a00b57306ULL, 0x000fe20000209400ULL, 0x00000018ffb17819ULL, 0x000fe400000114b1ULL,
0x00000018ffb07819ULL, 0x000fca00000114b0ULL, 0x0000004a00ac7306ULL, 0x000e620000205400ULL,
0x0000000174741812ULL, 0x000fce00078efcffULL, 0x0000004a004c7306ULL, 0x000eb0000020d400ULL,
0x00000080004b7306ULL, 0x000fe20000209400ULL, 0x000000acb500720bULL, 0x002fe20003f3d000ULL,
0x000100003bac7824ULL, 0x000fca00078e00ffULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x00000080004a7306ULL, 0x000fec0000205400ULL, 0x000000014c4c1812ULL, 0x004fe400078efcffULL,
0x00000080005d7306ULL, 0x0003f0000020d400ULL, 0x0000007900a17306ULL, 0x0004e2000020d400ULL,
0x00000018ff807819ULL, 0x002fce0000011442ULL, 0x0000008000e07306ULL, 0x000fe20000209400ULL,
0x0000010044797824ULL, 0x004fca00078e00ffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000008000e77306ULL, 0x000e620000205400ULL, 0x00000001a1a12812ULL, 0x008fce00078efcffULL,
0x0000004000a77306ULL, 0x000eb0000020d400ULL, 0x0000004100d07306ULL, 0x000fe20000209400ULL,
0x000000e7e000720bULL, 0x002fce0003f5d000ULL, 0x0000004100d77306ULL, 0x000e620000205400ULL,
0x00000001a7a70812ULL, 0x004fce00078efcffULL, 0x0000004300b67306ULL, 0x000ff00000009400ULL,
0x0000004300bf7306ULL, 0x000ea20000005400ULL, 0x000000d7d000720bULL, 0x002fce0003f1d000ULL,
0x0000008000427306ULL, 0x000e70000020d400ULL, 0x0000007900eb7306ULL, 0x000fe20000209400ULL,
0x000000bfb600720bULL, 0x004fce0003fdd000ULL, 0x0000007900e47306ULL, 0x000ea20000205400ULL,
0x0000000142422812ULL, 0x002fce00078efcffULL, 0x0000004100a57306ULL, 0x000e70000020d400ULL,
0x0000007f00de7306ULL, 0x000fe20000209400ULL, 0x000000e4eb00720bULL, 0x004fce0003f5d000ULL,
0x0000007f00e57306ULL, 0x000ea20000205400ULL, 0x00000001a5a50812ULL, 0x002fce00078efcffULL,
0x0000007f00407306ULL, 0x0003f0000020d400ULL, 0x0000004300597306ULL, 0x000722000000d400ULL,
0x00000100457f7824ULL, 0x002fe200078e00ffULL, 0x000000e5de00720bULL, 0x004fc80003f1d000ULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000004400bc7306ULL, 0x000fe20000009400ULL,
0x0001000043437824ULL, 0x008fca00078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004400bb7306ULL, 0x000e620000005400ULL, 0x0000000159596812ULL, 0x010fe400078efcffULL,
0x0000000140400812ULL, 0x000fe400078efcffULL, 0x000000594259723eULL, 0x000fe400000010ffULL,
0x0001380000427811ULL, 0x000fe200078e20ffULL, 0x0000007900937306ULL, 0x000eb0000020d400ULL,
0x0000007f00db7306ULL, 0x000fe20000209400ULL, 0x000000bbbc00720bULL, 0x002fce0003fdd000ULL,
0x0000007f00d47306ULL, 0x000e620000205400ULL, 0x0000000193932812ULL, 0x004fce00078efcffULL,
0x0000004300e27306ULL, 0x000ff00000209400ULL, 0x0000004300e97306ULL, 0x000ea20000205400ULL,
0x000000d4db00720bULL, 0x002fce0003f5d000ULL, 0x0000004300417306ULL, 0x0003f0000020d400ULL,
0x00000044005e7306ULL, 0x000722000000d400ULL, 0x0000010046437824ULL, 0x002fe200078e00ffULL,
0x000000e9e200720bULL, 0x004fc80003f1d000ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000004500b27306ULL, 0x000fe20000009400ULL, 0x0001000044447824ULL, 0x008fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000004500b97306ULL, 0x000e620000005400ULL,
0x000000015e5e6812ULL, 0x010fe400078efcffULL, 0x0000000141410812ULL, 0x000fe400078efcffULL,
0x0000005e935e723eULL, 0x000fc600000010ffULL, 0x0000007f00947306ULL, 0x000eb0000020d400ULL,
0x0000004300da7306ULL, 0x000fe20000209400ULL, 0x000000b9b200720bULL, 0x002fce0003fdd000ULL,
0x0000004300e17306ULL, 0x000e620000205400ULL, 0x0000000194942812ULL, 0x004fce00078efcffULL,
0x0000004400e67306ULL, 0x000ff00000209400ULL, 0x0000004400ed7306ULL, 0x000ea20000205400ULL,
0x000000e1da00720bULL, 0x002fce0003f5d000ULL, 0x00000044008d7306ULL, 0x0003f0000020d400ULL,
0x00000045005f7306ULL, 0x000722000000d400ULL, 0x0000010047447824ULL, 0x002fe200078e00ffULL,
0x000000ede600720bULL, 0x004fc80003f1d000ULL, 0x00000018ff797819ULL, 0x000fe40000011444ULL,
0x0000004600577306ULL, 0x000fe20000009400ULL, 0x0001000045457824ULL, 0x008fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004600567306ULL, 0x000e620000005400ULL,
0x000000015f5f6812ULL, 0x010fe400078efcffULL, 0x000000018d8d0812ULL, 0x000fe400078efcffULL,
0x0000005f945f723eULL, 0x000fe400000010ffULL, 0x0000008d8888723eULL, 0x000fe200000010ffULL,
0x00000043008e7306ULL, 0x000eb0000020d400ULL, 0x0000007900d87306ULL, 0x000fe20000209400ULL,
0x000000565700720bULL, 0x002fc40003fdd000ULL, 0x0001380002567811ULL, 0x000fca00078e20ffULL,
0x0000007900dd7306ULL, 0x000e620000205400ULL, 0x000000018e8e2812ULL, 0x004fce00078efcffULL,
0x0000004600817306ULL, 0x0004f0000000d400ULL, 0x0000004500dc7306ULL, 0x000fe20000209400ULL,
0x0001000046467824ULL, 0x004fe200078e00ffULL, 0x000000ddd800720bULL, 0x002fc80003f5d000ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000004500e37306ULL, 0x000e620000205400ULL,
0x0000000181816812ULL, 0x008fc800078efcffULL, 0x000000818e8e723eULL, 0x000fc600000010ffULL,
0x00000045008b7306ULL, 0x0004f0000020d400ULL, 0x0000004700547306ULL, 0x000fe20000009400ULL,
0x0000010038457824ULL, 0x004fe200078e00ffULL, 0x000000e3dc00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff8f7819ULL, 0x000fe40000011445ULL, 0x0000004700557306ULL, 0x000e6e0000005400ULL,
0x000000018b8b0812ULL, 0x008fe200078efcffULL, 0x00000038004f7306ULL, 0x000ff00000009400ULL,
0x0000003800507306ULL, 0x000fe20000005400ULL, 0x000000555400720bULL, 0x002fc40003fdd000ULL,
0x000000005654783bULL, 0x000e6a0000000200ULL, 0x0000003800737306ULL, 0x0005f0000000d400ULL,
0x0000004600df7306ULL, 0x000fe20000209400ULL, 0x0001000038387824ULL, 0x004fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004600d67306ULL, 0x000eb00000205400ULL,
0x0000004600877306ULL, 0x000ef0000020d400ULL, 0x00000079008c7306ULL, 0x0008e2000020d400ULL,
0x000000d6df00720bULL, 0x004fe20003f1d000ULL, 0x000000095454b231ULL, 0x002fc400003400ffULL,
0x000000095656b231ULL, 0x000fe400003400ffULL, 0x000000085555b231ULL, 0x080fe400003400ffULL,
0x0000008f00457306ULL, 0x000fe20000209400ULL, 0x0000010039797824ULL, 0x010fe200078e00ffULL,
0x000000085757b231ULL, 0x000fc800003400ffULL, 0x0000000187870812ULL, 0x008fe400078efcffULL,
0x0000008f00467306ULL, 0x000e620000205400ULL, 0x000000018c8c2812ULL, 0x000fce00078efcffULL,
0x0000003800987306ULL, 0x000ff00000209400ULL, 0x00000038009b7306ULL, 0x000fe20000205400ULL,
0x000000464500720bULL, 0x002fe40003f5d000ULL, 0x000000415a45723eULL, 0x000fca00000010ffULL,
0x00000038007f7306ULL, 0x0003f0000020d400ULL, 0x0000003c00ad7306ULL, 0x000fe20000009400ULL,
0x000001003c387824ULL, 0x002fca00078e00ffULL, 0x00000018ffca7819ULL, 0x000fe40000011438ULL,
0x0000003c00ae7306ULL, 0x000ff00000005400ULL, 0x0000003c00487306ULL, 0x0003f0000000d400ULL,
0x00000047007b7306ULL, 0x0004e2000000d400ULL, 0x000100003c3c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000008f00867306ULL, 0x000322000020d400ULL,
0x0001000047477824ULL, 0x004fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000003c00c27306ULL, 0x000fe20000209400ULL, 0x000000017b7b6812ULL, 0x008fe200078efcffULL,
0x000001003a8f7824ULL, 0x002fe200078e00ffULL, 0x000000aead00720bULL, 0x000fc80003fdd000ULL,
0x00000018ffe87819ULL, 0x000fe2000001148fULL, 0x0000003c00c77306ULL, 0x000e620000205400ULL,
0x0000000186862812ULL, 0x010fce00078efcffULL, 0x0000004700447306ULL, 0x000fe20000209400ULL,
0x0000000148486812ULL, 0x000fce00078efcffULL, 0x0000004700437306ULL, 0x000ea20000205400ULL,
0x000000c7c200720bULL, 0x002fce0003f5d000ULL, 0x0000003900997306ULL, 0x000ff00000009400ULL,
0x00000039004e7306ULL, 0x000fe20000005400ULL, 0x000000434400720bULL, 0x004fce0003f1d000ULL,
0x0000003900717306ULL, 0x0003f0000000d400ULL, 0x0000003d00ab7306ULL, 0x000fe20000009400ULL,
0x0001000039397824ULL, 0x002fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003d00a67306ULL, 0x000e700000005400ULL, 0x0000003c00c57306ULL, 0x000eb0000020d400ULL,
0x000000be00bf7306ULL, 0x000fe20000209400ULL, 0x000000a6ab00720bULL, 0x002fce0003fdd000ULL,
0x000000be003c7306ULL, 0x000e620000205400ULL, 0x00000001c5c52812ULL, 0x004fc800078efcffULL,
0x000000c54c4c723eULL, 0x000fc600000010ffULL, 0x0000004700857306ULL, 0x0004f0000020d400ULL,
0x0000003900917306ULL, 0x000fe20000209400ULL, 0x00000018ff477819ULL, 0x004fe40000011479ULL,
0x0000003cbf00720bULL, 0x002fc40003f5d000ULL, 0x000000a8b33c723eULL, 0x000fc600000010ffULL,
0x0000003900927306ULL, 0x000fe20000205400ULL, 0x0000000185850812ULL, 0x008fc800078efcffULL,
0x000000857485723eULL, 0x000fc600000010ffULL, 0x0000003900797306ULL, 0x000ff0000020d400ULL,
0x000000ca00387306ULL, 0x000ff00000209400ULL, 0x000000ca00397306ULL, 0x000e700000205400ULL,
0x0000003d00497306ULL, 0x0004f0000000d400ULL, 0x0000003e00a97306ULL, 0x000fe20000009400ULL,
0x000100003d3d7824ULL, 0x004fe200078e00ffULL, 0x000000393800720bULL, 0x002fe20003f1d000ULL,
0x000001003f387824ULL, 0x000fe200078e00ffULL, 0x000000a59e39723eULL, 0x000fc400000010ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003e00aa7306ULL, 0x000fe20000005400ULL,
0x0000000149496812ULL, 0x008fe400078efcffULL, 0x000000a2a300720bULL, 0x000fe40003fdd000ULL,
0x00000018ffae7819ULL, 0x000fe40000011438ULL, 0x000000a7a038723eULL, 0x000fe200000010ffULL,
0x0000003e00977306ULL, 0x0003f0000000d400ULL, 0x000000be00b67306ULL, 0x000ea2000020d400ULL,
0x000100003e3e7824ULL, 0x002fe200078e00ffULL, 0x000000014d4d6812ULL, 0x000fc800078efcffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003d00b87306ULL, 0x000ff00000209400ULL,
0x0000003d00b97306ULL, 0x000e620000205400ULL, 0x00000001b6b62812ULL, 0x004fc400078efcffULL,
0x000000589f00720bULL, 0x000fe40003f5d000ULL, 0x0000009ca158723eULL, 0x000fe400000010ffULL,
0x00000049b649723eULL, 0x000fe200000010ffULL, 0x0000003f009d7306ULL, 0x000ff00000009400ULL,
0x0000003f009a7306ULL, 0x000fe20000005400ULL, 0x000000b9b800720bULL, 0x002fc40003f3d000ULL,
0x000000015c5c2812ULL, 0x000fca00078efcffULL, 0x0000003f00517306ULL, 0x0003f0000000d400ULL,
0x0000004700957306ULL, 0x000fe20000209400ULL, 0x000100003f3f7824ULL, 0x002fce00078e00ffULL,
0x0000004700967306ULL, 0x000ff00000205400ULL, 0x0000004700807306ULL, 0x000ff0000020d400ULL,
0x0000003e00437306ULL, 0x000ff00000209400ULL, 0x0000003e00447306ULL, 0x000e700000205400ULL,
0x000000ca00477306ULL, 0x000eb0000020d400ULL, 0x0000003d00b27306ULL, 0x000722000020d400ULL,
0x000000444300720bULL, 0x002fc40003fdd000ULL, 0x000000405b44723eULL, 0x000fe400000010ffULL,
0x000000004240783bULL, 0x000e620000000200ULL, 0x000000585458723cULL, 0x000fe400000418ffULL,
0x000000ba00bb7306ULL, 0x000fe20000209400ULL, 0x000000a4af3d723eULL, 0x008fe400000010ffULL,
0x00000018ffa47819ULL, 0x000fe4000001143fULL, 0x0000000147470812ULL, 0x004fc400078efcffULL,
0x000000aaa900720bULL, 0x000fe20003f1d000ULL, 0x000000ba00b47306ULL, 0x000ea20000205400ULL,
0x00000001b2b21812ULL, 0x010fe400078efcffULL, 0x000000484748723eULL, 0x000fe400000010ffULL,
0x000000b24d4d723eULL, 0x000fc600000010ffULL, 0x000000a4009e7306ULL, 0x000fe80000209400ULL,
0x0000000197970812ULL, 0x000fe400078efcffULL, 0x0000009a9d00720bULL, 0x000fe40003f1d000ULL,
0x000000a4009f7306ULL, 0x000ee20000205400ULL, 0x000000b4bb00720bULL, 0x004fce0003f3d000ULL,
0x0000003e00ad7306ULL, 0x000526000020d400ULL, 0x0000000151510812ULL, 0x000fe400078efcffULL,
0x000000504f00720bULL, 0x000fe20003f1d000ULL, 0x000000094040b231ULL, 0x082fe400003400ffULL,
0x000000ba00bc7306ULL, 0x000e62000020d400ULL, 0x0000009f9e00720bULL, 0x008fe20003f5d000ULL,
0x0000003c543c723cULL, 0x004f6200000418ffULL, 0x000000094242b231ULL, 0x000fc400003400ffULL,
0x000000084141b231ULL, 0x080fe400003400ffULL, 0x000000084343b231ULL, 0x000fe200003400ffULL,
0x000000a400a47306ULL, 0x000ea2000020d400ULL, 0x00000001adad6812ULL, 0x010fe400078efcffULL,
0x0000004a4b00720bULL, 0x000fe40003fdd000ULL, 0x000000ad5c5c723eULL, 0x000fe200000010ffULL,
0x000000485448723cULL, 0x000fe200000418ffULL, 0x0000000173730812ULL, 0x000fe200078efcffULL,
0x000000ae00467306ULL, 0x000fe20000209400ULL, 0x00000001bcbc1812ULL, 0x002fc400078efcffULL,
0x000000969500720bULL, 0x000fe40003f1d000ULL, 0x00000097bc50723eULL, 0x000fe400000010ffULL,
0x000000738686723eULL, 0x000fe200000010ffULL, 0x000000ae00a97306ULL, 0x000e620000205400ULL,
0x00000001a4a42812ULL, 0x004fe200078efcffULL, 0x0000005e403c723cULL, 0x020fe2000004183cULL,
0x000000535200720bULL, 0x000fe40003f5d000ULL, 0x000000015d5d6812ULL, 0x000fc400078efcffULL,
0x0000009b9800720bULL, 0x000fe20003fdd000ULL, 0x000000ae00ae7306ULL, 0x000ea2000020d400ULL,
0x000000a45d5d723eULL, 0x000fe400000010ffULL, 0x0000000180800812ULL, 0x000fe400078efcffULL,
0x000000a94600720bULL, 0x002fc60003f3d000ULL, 0x000000b1009a7306ULL, 0x000fe20000209400ULL,
0x0000000172722812ULL, 0x000fe200078efcffULL, 0x000000445444723cULL, 0x000f6200000418ffULL,
0x000000929100720bULL, 0x000fe40003f5d000ULL, 0x000000017f7f6812ULL, 0x000fe400078efcffULL,
0x0000008a8900720bULL, 0x000fe20003fdd000ULL, 0x000000b100977306ULL, 0x000e620000205400ULL,
0x0000008b8489723eULL, 0x000fe400000010ffULL, 0x000000877e84723eULL, 0x000fc400000010ffULL,
0x00000001aeae1812ULL, 0x004fe400078efcffULL, 0x0000004e9900720bULL, 0x000fe20003f3d000ULL,
0x0000003b007c7306ULL, 0x000fe20000009400ULL, 0x00000051ae51723eULL, 0x000fe200000010ffULL,
0x0000004c544c723cULL, 0x040f6200000418ffULL, 0x0000000179792812ULL, 0x000fe400078efcffULL,
0x000000016e6e6812ULL, 0x000fe400078efcffULL, 0x0000007f7272723eULL, 0x000fe200000010ffULL,
0x0000003b007d7306ULL, 0x000ea20000005400ULL, 0x000000979a00720bULL, 0x002fe20003f5d000ULL,
0x000000505450723cULL, 0x000fe200000418ffULL, 0x000000796e73723eULL, 0x000fc400000010ffULL,
0x0000000171711812ULL, 0x000fc600078efcffULL, 0x0000003a00827306ULL, 0x000fe20000009400ULL,
0x000000718087723eULL, 0x000fe200000010ffULL, 0x000000844044723cULL, 0x060fec0000041844ULL,
0x0000003a00837306ULL, 0x000e620000005400ULL, 0x0000007d7c00720bULL, 0x004fe20003fdd000ULL,
0x000000864048723cULL, 0x040fec0000041848ULL, 0x000000e8008f7306ULL, 0x000fe40000209400ULL,
0x00000072404c723cULL, 0x000fec000004184cULL, 0x000000e800907306ULL, 0x000ea20000205400ULL,
0x000000838200720bULL, 0x002fce0003f3d000ULL, 0x0000003a006f7306ULL, 0x000e70000000d400ULL,
0x0000003b00707306ULL, 0x000722000000d400ULL, 0x000000908f00720bULL, 0x004fe40003f1d000ULL,
0x0000007b8c8f723eULL, 0x000fca00000010ffULL, 0x000000b100997306ULL, 0x000ea2000020d400ULL,
0x000000385438723cULL, 0x008f6200000418ffULL, 0x000000016f6f1812ULL, 0x002fe400078efcffULL,
0x000000787700720bULL, 0x000fc80003f3d000ULL, 0x000000b000937306ULL, 0x000fe20000209400ULL,
0x0000005c5454723cULL, 0x000b6200000418ffULL, 0x0000000170706812ULL, 0x010fcc00078efcffULL,
0x000000b0005c7306ULL, 0x020e620000205400ULL, 0x0000000199992812ULL, 0x004fe200078efcffULL,
0x0000008e4058723cULL, 0x040b620000041858ULL, 0x000000016d6d1812ULL, 0x000fe400078efcffULL,
0x00000070997b723eULL, 0x000fe400000010ffULL, 0x0000006a6100720cULL, 0x000fe20003f26070ULL,
0x000000ac005e7306ULL, 0x000fe40000209400ULL, 0x000000884038723cULL, 0x000b6c0000041838ULL,
0x000000ac005f7306ULL, 0x000ea20000205400ULL, 0x0000005c9300720bULL, 0x002fc40003f5d000ULL,
0x000000016a5c7810ULL, 0x000fc80007ffe0ffULL, 0x0000005c6100720cULL, 0x000fe20004f26470ULL,
0x000000e8007a7306ULL, 0x000e70000020d400ULL, 0x000000b0005d7306ULL, 0x000ee2000020d400ULL,
0x0000005f5e00720bULL, 0x004fce0003fdd000ULL, 0x000000ac00ac7306ULL, 0x000ea2000020d400ULL,
0x000000017a7a0812ULL, 0x002fe400078efcffULL, 0x000000767500720bULL, 0x000fe40003f1d000ULL,
0x0000006f7a7a723eULL, 0x000fe400000010ffULL, 0x000000015d5d2812ULL, 0x008fe400078efcffULL,
0x0000006a6200720cULL, 0x000fc60003f46070ULL, 0x0000007a4050723cULL, 0x000b620000041850ULL,
0x0000005c6200720cULL, 0x000fe40005746470ULL, 0x00000001acac6812ULL, 0x004fe400078efcffULL,
0x0000000f3400720cULL, 0x000fe40003fc3070ULL, 0x000000016c6c0812ULL, 0x000fe400078efcffULL,
0x000000ac6d6d723eULL, 0x000fe400000010ffULL, 0x0000005d6c6c723eULL, 0x000fc400000010ffULL,
0x0000000f3400720cULL, 0x000fca0003f03070ULL, 0x0000006c4054723cULL, 0x000b620000041854ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000003c12127221ULL, 0x000fe40000010000ULL, 0x0000003d13137221ULL, 0x000fe40000010000ULL,
0x0000003816167221ULL, 0x020fe40000010000ULL, 0x0000003917177221ULL, 0x000fe40000010000ULL,
0x000000581a1a7221ULL, 0x000fe40000010000ULL, 0x000000591b1b7221ULL, 0x000fc40000010000ULL,
0x000000441e1e7221ULL, 0x000fe40000010000ULL, 0x000000451f1f7221ULL, 0x000fe40000010000ULL,
0x0000004822227221ULL, 0x000fe40000010000ULL, 0x0000004923237221ULL, 0x000fe40000010000ULL,
0x0000004c26267221ULL, 0x000fe40000010000ULL, 0x0000004d27277221ULL, 0x000fc40000010000ULL,
0x000000502a2a7221ULL, 0x000fe40000010000ULL, 0x000000512b2b7221ULL, 0x000fe40000010000ULL,
0x000000542e2e7221ULL, 0x000fe40000010000ULL, 0x000000552f2f7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000003e14147221ULL, 0x000fe40000010000ULL,
0x0000003f15157221ULL, 0x000fe40000010000ULL, 0x0000003a18187221ULL, 0x020fc40000010000ULL,
0x0000003b19197221ULL, 0x000fe40000010000ULL, 0x0000005a1c1c7221ULL, 0x000fe40000010000ULL,
0x0000005b1d1d7221ULL, 0x000fe40000010000ULL, 0x0000004620207221ULL, 0x000fe40000010000ULL,
0x0000004721217221ULL, 0x000fe40000010000ULL, 0x0000004a24247221ULL, 0x000fc40000010000ULL,
0x0000004b25257221ULL, 0x000fe40000010000ULL, 0x0000004e28287221ULL, 0x000fe40000010000ULL,
0x0000004f29297221ULL, 0x000fe40000010000ULL, 0x000000522c2c7221ULL, 0x000fe40000010000ULL,
0x000000532d2d7221ULL, 0x000fe40000010000ULL, 0x0000005630307221ULL, 0x000fc40000010000ULL,
0x0000005731317221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x020e62000c80043fULL,
0x00000002ff3b7819ULL, 0x000fe2000001165cULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000000f3400720cULL, 0x000fe40003fc3070ULL, 0x0000003b5c3b7207ULL, 0x040fe40002800000ULL,
0x000000035c5c7812ULL, 0x000fe400078ec0ffULL, 0x0000000f3400720cULL, 0x000fe40003f03070ULL,
0x00000040ff567803ULL, 0x000fc40000000000ULL, 0x000000ff5c5c7207ULL, 0x000fe40006800000ULL,
0x000000033b387810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3f7224ULL, 0x000fc600078e0039ULL,
0x0000000338417812ULL, 0x040fe400078ec0ffULL, 0x0000000f38437211ULL, 0x000fc400078ff0ffULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b8400ff3a7984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x800000003aff7812ULL, 0x002fe200078c486bULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL, 0x000000ffff3b7224ULL, 0x000fca00030e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8400ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe400078c486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x018b8c00ff3a7984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000143397810ULL, 0x040fe20007ffe0ffULL,
0x0000000443387824ULL, 0x000fe200078e0241ULL, 0x0000097000017945ULL, 0x000fe40003800000ULL,
0x000000363900720cULL, 0x000fe20003fc6070ULL, 0x00000040383d7824ULL, 0x000fca00078e00ffULL,
0x0000004033407812ULL, 0x000fce00078ef83dULL, 0x000004f00000e947ULL, 0x000fea0003800000ULL,
0x0000000507457c10ULL, 0x040fe2000fffe0ffULL, 0x00000100ff477424ULL, 0x000fe200078e00ffULL,
0x00000002074d7810ULL, 0x000fe20007ffe0ffULL, 0x00000010323a7824ULL, 0x000fe400078e00ffULL,
0x018a0000453c7984ULL, 0x000e620000004800ULL, 0x0000000145387824ULL, 0x000fe200078e0240ULL,
0x000000054d4f7c10ULL, 0x000fe4000fffe0ffULL, 0x000000f03a497812ULL, 0x000fe200078ec0ffULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc400078e0238ULL,
0x00000010453c7824ULL, 0x000fe400078e00ffULL, 0x00005e0038387625ULL, 0x000fca00078e0047ULL,
0x00000049383a7210ULL, 0x000fe40007fde0ffULL, 0x0000003d60387217ULL, 0x000fc60007800000ULL,
0x000000ffff3b7224ULL, 0x000fe400030e0639ULL, 0x0000000138387824ULL, 0x000fe400078e0a3dULL,
0x0000000145397824ULL, 0x000fc600078e0232ULL, 0x0000000538387c17ULL, 0x000fe4000f800000ULL,
0xfffffff03c397812ULL, 0x000fe400078ee239ULL, 0x80000005383e7c10ULL, 0x000fe4000fffe0ffULL,
0x00014000394b7811ULL, 0x000fe200078e20ffULL, 0x000000014f397824ULL, 0x000fe200078e0240ULL,
0x0000003e0700720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a4b7faeULL, 0x0003e8000f101c50ULL, 0x018a0800453f7984ULL, 0x000ea80000004800ULL,
0x018ac0003f387984ULL, 0x004ea40000004800ULL, 0x000000380d387224ULL, 0x004fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383c7210ULL, 0x000fe20007fde0ffULL,
0x000000014f387824ULL, 0x040fe400078e0232ULL, 0x000000104f4f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x0000003e4d00720cULL, 0x000fe40003fc6070ULL,
0xfffffff04f387812ULL, 0x000fe400078ee238ULL, 0x00000004074d7810ULL, 0x000fc40007ffe0ffULL,
0x00014000384b7811ULL, 0x002fe400078e20ffULL, 0x000000054d4f7c10ULL, 0x000fca000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c4b7faeULL, 0x0003e2000f101c50ULL,
0x000000014f397824ULL, 0x000fc600078e0240ULL, 0x018a1000453f7984ULL, 0x000ea80000004800ULL,
0x018ac0003f387984ULL, 0x0044e40000004800ULL, 0x00000006073f7810ULL, 0x004fc80007ffe0ffULL,
0x000000053f4b7c10ULL, 0x002fe2000fffe0ffULL, 0x000000380d387224ULL, 0x008fc800078e0239ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x00000049383a7210ULL, 0x000fe20007fde0ffULL,
0x000000014f387824ULL, 0x040fe400078e0232ULL, 0x000000104f4f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x0000003e4d00720cULL, 0x000fe40003fc6070ULL,
0xfffffff04f387812ULL, 0x000fc800078ee238ULL, 0x00014000383d7811ULL, 0x000fe200078e20ffULL,
0x000000014b387824ULL, 0x040fe400078e0240ULL, 0x000000014b407824ULL, 0x040fe400078e0232ULL,
0x000000104b4b7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e6000f101c50ULL, 0xfffffff04b407812ULL, 0x000fe200078ee240ULL,
0x018a1800453c7984ULL, 0x000ea60000004800ULL, 0x00014000403b7811ULL, 0x002fe200078e20ffULL,
0x018ac0003c3c7984ULL, 0x004e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0047ULL, 0x0000004938387210ULL, 0x000fca0007fde0ffULL,
0x000000ffff397224ULL, 0x000fe200030e0639ULL, 0x0000003e3f00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e2000f101c50ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x00000005073f7c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff457424ULL, 0x000fe400078e00ffULL, 0x00000010323a7824ULL, 0x000fe200078e00ffULL,
0x000000023f4b7810ULL, 0x040fe20007ffe0ffULL, 0x018a00003f3c7984ULL, 0x000e620000004800ULL,
0x000000013f387824ULL, 0x000fe400078e0240ULL, 0x000000f03a477812ULL, 0x000fe200078ec0ffULL,
0x018ac0003c3c7984ULL, 0x002e640000004800ULL, 0x0000003c0d387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0045ULL, 0x00000047383a7210ULL, 0x000fe20007fde0ffULL,
0x000000013f387824ULL, 0x000fc800078e0232ULL, 0x000000ffff3b7224ULL, 0x000fe400030e0639ULL,
0x000000103f397824ULL, 0x000fca00078e00ffULL, 0xfffffff039387812ULL, 0x000fc800078ee238ULL,
0x0001400038497811ULL, 0x000fe200078e20ffULL, 0x000000014b387824ULL, 0x000fc800078e0240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a497faeULL, 0x0003e8000b901c50ULL,
0x018a08003f3e7984ULL, 0x000ea80000004800ULL, 0x018ac0003e3e7984ULL, 0x004ea40000004800ULL,
0x0000003e0d387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383c7210ULL, 0x000fe20007fde0ffULL, 0x000000014b387824ULL, 0x040fe400078e0232ULL,
0x000000104b4b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff3d7224ULL, 0x000fc600030e0639ULL,
0xfffffff04b387812ULL, 0x000fe400078ee238ULL, 0x000000043f4b7810ULL, 0x000fe40007ffe0ffULL,
0x0001400038497811ULL, 0x002fc600078e20ffULL, 0x000000014b387824ULL, 0x000fe400078e0240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c497faeULL, 0x0003e8000b901c50ULL,
0x018a10003f3e7984ULL, 0x000ea20000004800ULL, 0x000000063f497810ULL, 0x002fc60007ffe0ffULL,
0x018ac0003e3e7984ULL, 0x004e640000004800ULL, 0x0000003e0d387224ULL, 0x002fe400078e0238ULL,
0x00000001493e7824ULL, 0x000fe400078e0232ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x00000047383a7210ULL, 0x000fe20007fde0ffULL, 0x000000014b387824ULL, 0x040fe400078e0232ULL,
0x000000104b4b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff3b7224ULL, 0x000fc600030e0639ULL,
0xfffffff04b387812ULL, 0x000fc800078ee238ULL, 0x00014000383d7811ULL, 0x000fe200078e20ffULL,
0x0000000149387824ULL, 0x040fe400078e0240ULL, 0x0000001049497824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e6000b901c50ULL,
0xfffffff0493e7812ULL, 0x000fe200078ee23eULL, 0x018a18003f3c7984ULL, 0x000ea60000004800ULL,
0x000140003e3b7811ULL, 0x002fe200078e20ffULL, 0x018ac0003c3c7984ULL, 0x004e640000004800ULL,
0x0000003c0d387224ULL, 0x002fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0045ULL,
0x0000004738387210ULL, 0x000fca0007fde0ffULL, 0x000000ffff397224ULL, 0x000fca00030e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e6000b901c50ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff387f8cULL, 0x002e64000c80043fULL, 0x000000ffff3f7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x018b8c00ff3a7984ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c483fULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078d10ffULL,
0x000000ffff3b7224ULL, 0x000fca00030e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000433400720cULL, 0x000fe20003fc4070ULL,
0x00000004ff3a7424ULL, 0x000fe200078e00ffULL, 0x00018a000c3d7811ULL, 0x000fe400078e10ffULL,
0x000000ff5c387207ULL, 0x000fc40003000000ULL, 0x000000ff5c5c7207ULL, 0x000fc60007000000ULL,
0x0000000141387824ULL, 0x000fc800078e0238ULL, 0x0000004038397824ULL, 0x040fe200078e00ffULL,
0x0000004338387211ULL, 0x000fc800078ff0ffULL, 0x000000c039397812ULL, 0x000fca00078ec0ffULL,
0x0000010038387824ULL, 0x000fe200078e0239ULL, 0x0000000a5c397c10ULL, 0x000fc8000fffe0ffULL,
0x0000002038387810ULL, 0x000fca0007ffe0ffULL, 0x000000010c3b7824ULL, 0x100fe400078e0238ULL,
0x0000680039397a24ULL, 0x000fc600078e0238ULL, 0x000000603b00720cULL, 0x000fe20003fc6070ULL,
0x000000010c397824ULL, 0x000fc800078e0239ULL, 0x0000660039387625ULL, 0x000fd000078e003aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383d7faeULL, 0x0003e4000f121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b7800ff387f8cULL, 0x000e62000c80043fULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x000000ffff6b7224ULL, 0x002fe200078e0039ULL,
0x0000014000003947ULL, 0x000fea0003800000ULL, 0x0000000aff08723eULL, 0x000fc800000010ffULL,
0x00005410083a7816ULL, 0x000fe20000000008ULL, 0x0000cc627f007947ULL, 0x000fea000b800000ULL,
0x00001f623a097589ULL, 0x0002a400000e0000ULL, 0x0000ccc27f007947ULL, 0x000fea000b800000ULL,
0x00001f613a087589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010623f7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x0001cfa000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000d34000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3e7224ULL, 0x004fe200078e003aULL,
0x00000018623f7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff407424ULL, 0x000fe200078e00ffULL,
0x0001d01000387802ULL, 0x000fe20000000f00ULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000d2d000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000663c783bULL, 0x006e620000004200ULL,
0x00001e3000017945ULL, 0x000fe60003800000ULL, 0x000000006540783bULL, 0x000ea80000004200ULL,
0x000000006444783bULL, 0x000f220000004200ULL, 0x0000003c00387306ULL, 0x002ff00000009400ULL,
0x0000003c00397306ULL, 0x000e700000005400ULL, 0x0000003c004c7306ULL, 0x000ee2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000003d004d7306ULL, 0x000ff0000000d400ULL,
0x0000003d00387306ULL, 0x000fe20000009400ULL, 0x000000014c4c6812ULL, 0x008fce00078efcffULL,
0x0000003d00397306ULL, 0x000e700000005400ULL, 0x0000003e004b7306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000003f004a7306ULL, 0x000ff0000000d400ULL,
0x0000003e00387306ULL, 0x000fe20000009400ULL, 0x000000014d4d6812ULL, 0x000fce00078efcffULL,
0x0000003e00397306ULL, 0x000e700000005400ULL, 0x0000004000497306ULL, 0x004fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004100487306ULL, 0x000ff0000000d400ULL,
0x0000003f00387306ULL, 0x000fe20000009400ULL, 0x000000014b4b6812ULL, 0x000fce00078efcffULL,
0x0000003f00397306ULL, 0x000e700000005400ULL, 0x00000042007a7306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004300787306ULL, 0x000ff0000000d400ULL,
0x0000004000387306ULL, 0x000fe20000009400ULL, 0x000000014a4a6812ULL, 0x000fce00078efcffULL,
0x0000004000397306ULL, 0x000e700000005400ULL, 0x0000004400767306ULL, 0x010fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004500757306ULL, 0x000ff0000000d400ULL,
0x0000004100387306ULL, 0x000fe20000009400ULL, 0x0000000149496812ULL, 0x000fce00078efcffULL,
0x0000004100397306ULL, 0x000e700000005400ULL, 0x0000004600727306ULL, 0x000fe2000000d400ULL,
0x000000393800720bULL, 0x002fce0003fdd000ULL, 0x0000004700707306ULL, 0x000ff0000000d400ULL,
0x0000004200387306ULL, 0x000fe20000009400ULL, 0x0000000148486812ULL, 0x000fce00078efcffULL,
0x0000004200397306ULL, 0x000e640000005400ULL, 0x000000393800720bULL, 0x002fcc0003fdd000ULL,
0x0000004300387306ULL, 0x000ff00000009400ULL, 0x0000004300397306ULL, 0x000e620000005400ULL,
0x000000017a7a6812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004400387306ULL, 0x000ff00000009400ULL, 0x0000004400397306ULL, 0x000e620000005400ULL,
0x0000000178786812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004500387306ULL, 0x000ff00000009400ULL, 0x0000004500397306ULL, 0x000e620000005400ULL,
0x0000000176766812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004600387306ULL, 0x000ff00000009400ULL, 0x0000004600397306ULL, 0x000e620000005400ULL,
0x0000000175756812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fca0003fdd000ULL,
0x0000004700387306ULL, 0x000ff00000009400ULL, 0x0000004700397306ULL, 0x000e620000005400ULL,
0x0000000172726812ULL, 0x000fe400078efcffULL, 0x000000393800720bULL, 0x002fc40003fdd000ULL,
0x000000006338783bULL, 0x000e760000004200ULL, 0x0000000170706812ULL, 0x000fe200078efcffULL,
0x00000038004e7306ULL, 0x002fe20000009400ULL, 0x00000018ff577819ULL, 0x000fce000001143aULL,
0x00000038004f7306ULL, 0x000e700000005400ULL, 0x00000038006e7306ULL, 0x000ea2000000d400ULL,
0x0000004f4e00720bULL, 0x002fce0003fdd000ULL, 0x00000039006d7306ULL, 0x000ff0000000d400ULL,
0x00000039004e7306ULL, 0x000fe20000009400ULL, 0x000000016e6e6812ULL, 0x004fce00078efcffULL,
0x00000039004f7306ULL, 0x000e700000005400ULL, 0x0000003a006c7306ULL, 0x000fe2000000d400ULL,
0x0000004f4e00720bULL, 0x002fce0003fdd000ULL, 0x00000057006f7306ULL, 0x000ff0000020d400ULL,
0x0000003a004e7306ULL, 0x000fe20000009400ULL, 0x000000016d6d6812ULL, 0x000fce00078efcffULL,
0x0000003a004f7306ULL, 0x000e640000005400ULL, 0x0000004f4e00720bULL, 0x002fe40003fdd000ULL,
0x00000018ff4e7819ULL, 0x000fc8000001143cULL, 0x0000004e004f7306ULL, 0x000fee0000209400ULL,
0x000000016c6c6812ULL, 0x000fe200078efcffULL, 0x0000004e00507306ULL, 0x000e700000205400ULL,
0x0000004e00517306ULL, 0x000ea2000020d400ULL, 0x000000504f00720bULL, 0x002fc40003fdd000ULL,
0x00000018ff4f7819ULL, 0x000fca000001143dULL, 0x0000004f00527306ULL, 0x000fec0000209400ULL,
0x0000000151516812ULL, 0x004fe400078efcffULL, 0x0000004f00537306ULL, 0x000e700000205400ULL,
0x0000004f00507306ULL, 0x000ea2000020d400ULL, 0x000000535200720bULL, 0x002fc40003fdd000ULL,
0x00000018ff527819ULL, 0x000fca000001143eULL, 0x0000005200537306ULL, 0x000fec0000209400ULL,
0x0000000150506812ULL, 0x004fe400078efcffULL, 0x0000005200547306ULL, 0x000e700000205400ULL,
0x00000052004e7306ULL, 0x000ea2000020d400ULL, 0x000000545300720bULL, 0x002fc40003fdd000ULL,
0x00000018ff537819ULL, 0x000fca000001143fULL, 0x0000005300547306ULL, 0x000fec0000209400ULL,
0x000000014e4e6812ULL, 0x004fe400078efcffULL, 0x0000005300557306ULL, 0x000e700000205400ULL,
0x00000053004f7306ULL, 0x0004e2000020d400ULL, 0x000000555400720bULL, 0x002fc40003fdd000ULL,
0x00000018ff547819ULL, 0x000fe40000011440ULL, 0x00000018ff537819ULL, 0x004fc60000011442ULL,
0x0000005400557306ULL, 0x000fec0000209400ULL, 0x000000014f4f6812ULL, 0x008fe400078efcffULL,
0x0000005400527306ULL, 0x000e700000205400ULL, 0x00000054007f7306ULL, 0x000ea2000020d400ULL,
0x000000525500720bULL, 0x002fce0003fdd000ULL, 0x0000005300547306ULL, 0x000fe20000205400ULL,
0x00000018ff527819ULL, 0x000fce0000011441ULL, 0x0000005200557306ULL, 0x000fe20000209400ULL,
0x000000017f7f6812ULL, 0x004fce00078efcffULL, 0x0000005200587306ULL, 0x000e700000205400ULL,
0x00000052007e7306ULL, 0x000ea2000020d400ULL, 0x000000585500720bULL, 0x002fce0003fdd000ULL,
0x00000053007c7306ULL, 0x000ff0000020d400ULL, 0x0000005300557306ULL, 0x0002e20000209400ULL,
0x000000017e7e6812ULL, 0x004fe400078efcffULL, 0x00000018ff537819ULL, 0x002fca0000011445ULL,
0x0000005300797306ULL, 0x000fe2000020d400ULL, 0x000000545500720bULL, 0x008fe40003fdd000ULL,
0x00000018ff547819ULL, 0x000fca0000011443ULL, 0x0000005400557306ULL, 0x000fec0000209400ULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x0000005400527306ULL, 0x000e700000205400ULL,
0x00000054007d7306ULL, 0x000ea2000020d400ULL, 0x000000525500720bULL, 0x002fce0003fdd000ULL,
0x0000005300547306ULL, 0x000fe20000205400ULL, 0x00000018ff527819ULL, 0x000fce0000011444ULL,
0x0000005200557306ULL, 0x000fe20000209400ULL, 0x000000017d7d6812ULL, 0x004fce00078efcffULL,
0x0000005200587306ULL, 0x000e700000205400ULL, 0x00000052007b7306ULL, 0x000ea2000020d400ULL,
0x000000585500720bULL, 0x002fce0003fdd000ULL, 0x0000005300557306ULL, 0x0002e40000209400ULL,
0x00000018ff537819ULL, 0x002fc80000011438ULL, 0x000000017b7b6812ULL, 0x004fe400078efcffULL,
0x0000005300737306ULL, 0x000fe2000020d400ULL, 0x000000545500720bULL, 0x008fe40003fdd000ULL,
0x00000018ff547819ULL, 0x000fca0000011446ULL, 0x0000005400557306ULL, 0x000fec0000209400ULL,
0x0000000179796812ULL, 0x000fe400078efcffULL, 0x0000005400527306ULL, 0x000e700000205400ULL,
0x0000005400777306ULL, 0x000ea2000020d400ULL, 0x000000525500720bULL, 0x002fce0003fdd000ULL,
0x0000005300547306ULL, 0x000fe20000205400ULL, 0x00000018ff527819ULL, 0x000fce0000011447ULL,
0x0000005200557306ULL, 0x000fe20000209400ULL, 0x0000000177776812ULL, 0x004fce00078efcffULL,
0x0000005200587306ULL, 0x000e700000205400ULL, 0x0000005200747306ULL, 0x000ea2000020d400ULL,
0x000000585500720bULL, 0x002fce0003fdd000ULL, 0x0000005300557306ULL, 0x000e700000209400ULL,
0x0000005700537306ULL, 0x000fe20000205400ULL, 0x0000000174746812ULL, 0x004fe400078efcffULL,
0x000000545500720bULL, 0x002fc40003fdd000ULL, 0x00000018ff547819ULL, 0x000fc80000011439ULL,
0x0000005400557306ULL, 0x000fee0000209400ULL, 0x0000000173736812ULL, 0x000fe200078efcffULL,
0x0000005400527306ULL, 0x000e700000205400ULL, 0x0000005400717306ULL, 0x000ea2000020d400ULL,
0x000000525500720bULL, 0x002fce0003fdd000ULL, 0x0000005700527306ULL, 0x000e6c0000209400ULL,
0x0000000171716812ULL, 0x004fe400078efcffULL, 0x000000535200720bULL, 0x002fe20003fdd000ULL,
0x000001003c527824ULL, 0x040fe400078e00ffULL, 0x000100003c3c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff527819ULL, 0x000fc80000011452ULL, 0x0000005200547306ULL, 0x000fe60000209400ULL,
0x000000016f6f6812ULL, 0x000fca00078efcffULL, 0x0000005200557306ULL, 0x000e700000205400ULL,
0x0000005200537306ULL, 0x000ea2000020d400ULL, 0x000000555400720bULL, 0x002fe40003fdd000ULL,
0x00000018ff557819ULL, 0x000fca000001143cULL, 0x00000055003c7306ULL, 0x000fec0000209400ULL,
0x0000000153536812ULL, 0x004fe400078efcffULL, 0x0000005500577306ULL, 0x000e640000205400ULL,
0x0000004c534c723eULL, 0x000fcc00000010ffULL, 0x0000005500547306ULL, 0x000ea2000020d400ULL,
0x000000573c00720bULL, 0x002fe20003fdd000ULL, 0x000001003d3c7824ULL, 0x040fe400078e00ffULL,
0x000100003d3d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff527819ULL, 0x000fe4000001143cULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005200577306ULL, 0x000fe60000209400ULL,
0x0000000154546812ULL, 0x004fc800078efcffULL, 0x000000545154723eULL, 0x000fe200000010ffULL,
0x0000005200587306ULL, 0x000e700000205400ULL, 0x00000052003c7306ULL, 0x000ea2000020d400ULL,
0x000000585700720bULL, 0x002fce0003fdd000ULL, 0x0000003d00557306ULL, 0x000ff0000020d400ULL,
0x0000003d00577306ULL, 0x000fe20000209400ULL, 0x000000013c3c6812ULL, 0x004fce00078efcffULL,
0x0000003d00587306ULL, 0x000e620000205400ULL, 0x0000004d3c4d723eULL, 0x000fe400000010ffULL,
0x00013800673c7811ULL, 0x000fe400078e20ffULL, 0x000000585700720bULL, 0x002fe20003fdd000ULL,
0x000001003e577824ULL, 0x040fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000005700587306ULL, 0x000fe60000209400ULL, 0x0000000155556812ULL, 0x000fc800078efcffULL,
0x000000555055723eULL, 0x000fe200000010ffULL, 0x0000005700597306ULL, 0x000e700000205400ULL,
0x0000005700527306ULL, 0x000ea2000020d400ULL, 0x000000595800720bULL, 0x002fce0003fdd000ULL,
0x0000003e003d7306ULL, 0x000ff0000020d400ULL, 0x0000003e00587306ULL, 0x000fe20000209400ULL,
0x0000000152526812ULL, 0x004fce00078efcffULL, 0x0000003e00597306ULL, 0x000e620000205400ULL,
0x0000004b5250723eULL, 0x000fe400000010ffULL, 0x000000595800720bULL, 0x002fe20003fdd000ULL,
0x000001003f587824ULL, 0x040fe400078e00ffULL, 0x000100003f3f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000005800577306ULL, 0x000fe60000209400ULL, 0x000000013d3d6812ULL, 0x000fc800078efcffULL,
0x0000003d4e4e723eULL, 0x000fe200000010ffULL, 0x00000058005a7306ULL, 0x000e700000205400ULL,
0x0000005800817306ULL, 0x000ea2000020d400ULL, 0x0000005a5700720bULL, 0x002fce0003fdd000ULL,
0x0000003f003e7306ULL, 0x000ff0000020d400ULL, 0x0000003f00577306ULL, 0x000fe20000209400ULL,
0x0000000181816812ULL, 0x004fce00078efcffULL, 0x0000003f005a7306ULL, 0x000e620000205400ULL,
0x0000004a8151723eULL, 0x000fe400000010ffULL, 0x0000005a5700720bULL, 0x002fe20003fdd000ULL,
0x0000010040577824ULL, 0x040fe400078e00ffULL, 0x0001000040407824ULL, 0x000fc600078e00ffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff3f7819ULL, 0x000fe40000011440ULL,
0x0000005700587306ULL, 0x000fe60000209400ULL, 0x000000013e3e6812ULL, 0x000fc800078efcffULL,
0x0000003e4f4f723eULL, 0x000fe200000010ffULL, 0x0000005700597306ULL, 0x000e700000205400ULL,
0x0000005700807306ULL, 0x000ea2000020d400ULL, 0x000000595800720bULL, 0x002fce0003fdd000ULL,
0x0000003f00407306ULL, 0x000ff0000020d400ULL, 0x0000003f00587306ULL, 0x000fe20000209400ULL,
0x0000000180806812ULL, 0x004fce00078efcffULL, 0x0000003f00597306ULL, 0x000e620000205400ULL,
0x00000049804a723eULL, 0x000fe400000010ffULL, 0x000000595800720bULL, 0x002fe20003fdd000ULL,
0x0000010041587824ULL, 0x040fe400078e00ffULL, 0x0001000041417824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000018ff3f7819ULL, 0x000fe40000011441ULL,
0x0000005800577306ULL, 0x000fe60000209400ULL, 0x0000000140406812ULL, 0x000fc800078efcffULL,
0x000000407f40723eULL, 0x000fe200000010ffULL, 0x00000058005a7306ULL, 0x000e700000205400ULL,
0x0000005800877306ULL, 0x000ea2000020d400ULL, 0x0000005a5700720bULL, 0x002fce0003fdd000ULL,
0x0000003f00417306ULL, 0x000ff0000020d400ULL, 0x0000003f00577306ULL, 0x000fe20000209400ULL,
0x0000000187876812ULL, 0x004fce00078efcffULL, 0x0000003f005a7306ULL, 0x000e620000205400ULL,
0x00000048874b723eULL, 0x000fce00000010ffULL, 0x0000003b007f7306ULL, 0x000fe20000005400ULL,
0x0000005a5700720bULL, 0x002fe20003fdd000ULL, 0x0000010042577824ULL, 0x040fe400078e00ffULL,
0x0001000042427824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x0000005700587306ULL, 0x000fe60000209400ULL,
0x0000000141416812ULL, 0x000fc800078efcffULL, 0x000000417e41723eULL, 0x000fe200000010ffULL,
0x0000005700597306ULL, 0x000e700000205400ULL, 0x0000005700857306ULL, 0x000ea2000020d400ULL,
0x000000595800720bULL, 0x002fce0003fdd000ULL, 0x00000042003f7306ULL, 0x000ff00000209400ULL,
0x0000004200587306ULL, 0x000e620000205400ULL, 0x0000000185856812ULL, 0x004fce00078efcffULL,
0x0000004200837306ULL, 0x000ea2000020d400ULL, 0x000000583f00720bULL, 0x002fe20003fdd000ULL,
0x00000100433f7824ULL, 0x040fe400078e00ffULL, 0x0001000043437824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000003f00577306ULL, 0x000fe60000209400ULL, 0x0000000183836812ULL, 0x004fc800078efcffULL,
0x000000837c7c723eULL, 0x000fe200000010ffULL, 0x0000003f00587306ULL, 0x000e700000205400ULL,
0x0000003f00897306ULL, 0x000ea2000020d400ULL, 0x000000585700720bULL, 0x002fce0003fdd000ULL,
0x0000004300427306ULL, 0x000ff00000209400ULL, 0x0000004300577306ULL, 0x000e620000205400ULL,
0x0000000189896812ULL, 0x004fce00078efcffULL, 0x0000004300887306ULL, 0x000ea2000020d400ULL,
0x000000574200720bULL, 0x002fe20003fdd000ULL, 0x0000010044427824ULL, 0x040fe400078e00ffULL,
0x0001000044447824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x00000042003f7306ULL, 0x000fe60000209400ULL,
0x0000000188886812ULL, 0x004fc800078efcffULL, 0x000000887d7d723eULL, 0x000fe200000010ffULL,
0x0000004200587306ULL, 0x000e700000205400ULL, 0x00000042008b7306ULL, 0x000ea2000020d400ULL,
0x000000583f00720bULL, 0x002fce0003fdd000ULL, 0x0000004400827306ULL, 0x000ff0000020d400ULL,
0x00000044003f7306ULL, 0x000fe20000209400ULL, 0x000000018b8b6812ULL, 0x004fce00078efcffULL,
0x0000004400587306ULL, 0x000e640000205400ULL, 0x000000583f00720bULL, 0x002fe20003fdd000ULL,
0x00000100453f7824ULL, 0x040fe400078e00ffULL, 0x0001000045457824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000003f00427306ULL, 0x000fe60000209400ULL, 0x0000000182826812ULL, 0x000fca00078efcffULL,
0x0000003f00437306ULL, 0x000e700000205400ULL, 0x0000003f008a7306ULL, 0x000ea2000020d400ULL,
0x000000434200720bULL, 0x002fce0003fdd000ULL, 0x0000004500847306ULL, 0x000ff0000020d400ULL,
0x0000004500427306ULL, 0x000fe20000209400ULL, 0x000000018a8a6812ULL, 0x004fce00078efcffULL,
0x0000004500437306ULL, 0x000e640000205400ULL, 0x000000434200720bULL, 0x002fe20003fdd000ULL,
0x0000010046427824ULL, 0x040fe400078e00ffULL, 0x0001000046467824ULL, 0x000fc600078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x00000042003f7306ULL, 0x000fe60000209400ULL, 0x0000000184846812ULL, 0x000fc800078efcffULL,
0x000000847979723eULL, 0x000fe200000010ffULL, 0x0000004200447306ULL, 0x000e700000205400ULL,
0x00000042008d7306ULL, 0x000ea2000020d400ULL, 0x000000443f00720bULL, 0x002fce0003fdd000ULL,
0x0000004600867306ULL, 0x000ff0000020d400ULL, 0x00000046003f7306ULL, 0x000fe20000209400ULL,
0x000000018d8d6812ULL, 0x004fce00078efcffULL, 0x0000004600447306ULL, 0x000e640000205400ULL,
0x000000443f00720bULL, 0x002fe20003fdd000ULL, 0x00000100473f7824ULL, 0x040fe400078e00ffULL,
0x0001000047477824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000003f00427306ULL, 0x000fe60000209400ULL,
0x0000000186866812ULL, 0x000fc800078efcffULL, 0x000000867786723eULL, 0x000fe200000010ffULL,
0x0000003f00437306ULL, 0x000e700000205400ULL, 0x0000003f008f7306ULL, 0x000ea2000020d400ULL,
0x000000434200720bULL, 0x002fce0003fdd000ULL, 0x0000004700917306ULL, 0x000ff0000020d400ULL,
0x0000004700427306ULL, 0x000fe20000209400ULL, 0x000000018f8f6812ULL, 0x004fce00078efcffULL,
0x0000004700437306ULL, 0x000e640000205400ULL, 0x000000434200720bULL, 0x002fe20003fdd000ULL,
0x0000010038427824ULL, 0x040fe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000042003f7306ULL, 0x000fe60000209400ULL, 0x0000000191916812ULL, 0x000fc800078efcffULL,
0x000000917487723eULL, 0x000fe200000010ffULL, 0x0000004200447306ULL, 0x000e700000205400ULL,
0x0000004200937306ULL, 0x000ea2000020d400ULL, 0x000000443f00720bULL, 0x002fce0003fdd000ULL,
0x00000038008c7306ULL, 0x000ff0000020d400ULL, 0x00000038003f7306ULL, 0x000fe20000209400ULL,
0x0000000193936812ULL, 0x004fce00078efcffULL, 0x0000003800447306ULL, 0x000e640000205400ULL,
0x000000443f00720bULL, 0x002fe20003fdd000ULL, 0x00000100393f7824ULL, 0x040fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003f00427306ULL, 0x000fe60000209400ULL,
0x000000018c8c6812ULL, 0x000fca00078efcffULL, 0x0000003f00437306ULL, 0x000e700000205400ULL,
0x0000003f008e7306ULL, 0x000ea2000020d400ULL, 0x000000434200720bULL, 0x002fce0003fdd000ULL,
0x0000003900387306ULL, 0x000ff00000209400ULL, 0x0000003900437306ULL, 0x000e620000205400ULL,
0x000000018e8e6812ULL, 0x004fce00078efcffULL, 0x0000003900907306ULL, 0x000ea2000020d400ULL,
0x000000433800720bULL, 0x002fe20003fdd000ULL, 0x000001003a387824ULL, 0x040fe200078e00ffULL,
0x000000788943723eULL, 0x000fe200000010ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x000000827b78723eULL, 0x000fe400000010ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x00000038003f7306ULL, 0x000fe60000209400ULL,
0x0000000190906812ULL, 0x004fc800078efcffULL, 0x000000907171723eULL, 0x000fe200000010ffULL,
0x0000003800427306ULL, 0x000e700000205400ULL, 0x0000003800957306ULL, 0x000ea2000020d400ULL,
0x000000423f00720bULL, 0x002fce0003fdd000ULL, 0x0000003a00397306ULL, 0x000ff00000209400ULL,
0x0000003a00427306ULL, 0x000e620000205400ULL, 0x0000000195956812ULL, 0x004fce00078efcffULL,
0x0000003a00927306ULL, 0x000ea2000020d400ULL, 0x0000006c956c723eULL, 0x000fe400000010ffULL,
0x000000423900720bULL, 0x002fe20003fdd000ULL, 0x000001003b397824ULL, 0x000fc800078e00ffULL,
0x0000003b003a7306ULL, 0x000fe20000009400ULL, 0x0000007a8542723eULL, 0x000fe400000010ffULL,
0x00000018ff397819ULL, 0x000fca0000011439ULL, 0x0000003900387306ULL, 0x000fe20000209400ULL,
0x0000000192926812ULL, 0x004fc800078efcffULL, 0x000000926f92723eULL, 0x000fc600000010ffULL,
0x00000039003f7306ULL, 0x000e700000205400ULL, 0x0000003900977306ULL, 0x0004e2000020d400ULL,
0x0000003f3800720bULL, 0x002fce0003fdd000ULL, 0x0000003b007a7306ULL, 0x000322000000d400ULL,
0x0001380068387811ULL, 0x000fe200078e20ffULL, 0x000000003c3c783bULL, 0x000f220000000200ULL,
0x000000758a39723eULL, 0x004fc600000010ffULL, 0x00000000385c783bULL, 0x0005220000000200ULL,
0x0000000197976812ULL, 0x008fe200078efcffULL, 0x000100003b387824ULL, 0x004fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x002fe4000001143bULL, 0x000000ff5600720cULL, 0x000fe40003fc5270ULL,
0x00000018ff7e7819ULL, 0x000fe40000011438ULL, 0x000000768b38723eULL, 0x000fe400000010ffULL,
0x0000007e00807306ULL, 0x000ff00000209400ULL, 0x0000007e00757306ULL, 0x000e700000205400ULL,
0x0000003b00767306ULL, 0x000fe20000209400ULL, 0x000000093c3cb231ULL, 0x010fc400003400ffULL,
0x000000093e3eb231ULL, 0x080fe400003400ffULL, 0x000000095c5cb231ULL, 0x080fe400003400ffULL,
0x000000095e5eb231ULL, 0x000fe400003400ffULL, 0x000000085d5db231ULL, 0x080fe400003400ffULL,
0x000000085f5fb231ULL, 0x080fe400003400ffULL, 0x000000083d3db231ULL, 0x000fc400003400ffULL,
0x000000083f3fb231ULL, 0x000fe200003400ffULL, 0x0000007f3a00720bULL, 0x000fe40003f7d000ULL,
0x0000004c5c58723cULL, 0x040f6200000418ffULL, 0x0000007e003a7306ULL, 0x000eae000020d400ULL,
0x000000505c50723cULL, 0x000f6600000418ffULL, 0x000000017a7a3812ULL, 0x000fc400078efcffULL,
0x000000758000720bULL, 0x002fe40003f7d000ULL, 0x0000003b00757306ULL, 0x000e620000205400ULL,
0x000000405c44723cULL, 0x000ff000000418ffULL, 0x000000383c58723cULL, 0x020be40000041858ULL,
0x000000013a3a3812ULL, 0x004fca00078efcffULL, 0x000000728d38723eULL, 0x020fe200000010ffULL,
0x000000545c54723cULL, 0x000f6200000418ffULL, 0x000000708f39723eULL, 0x000fe400000010ffULL,
0x000000757600720bULL, 0x002fe40003f7d000ULL, 0x0000008c7370723eULL, 0x000fc600000010ffULL,
0x000000383c50723cULL, 0x000bee0000041850ULL, 0x0000006e9338723eULL, 0x020fe200000010ffULL,
0x0000004e5c4c723cULL, 0x000f6200000418ffULL, 0x0000003b00937306ULL, 0x000e62000020d400ULL,
0x0000006d8e39723eULL, 0x000fc400000010ffULL, 0x0000007a976d723eULL, 0x000fc800000010ffULL,
0x0000004a5c48723cULL, 0x040f7000000418ffULL, 0x000000425c40723cULL, 0x000f6200000418ffULL,
0x0000000193933812ULL, 0x002fc800078efcffULL, 0x0000003a9393723eULL, 0x000fc600000010ffULL,
0x0000007c5c5c723cULL, 0x000f7000000418ffULL, 0x000000783c54723cULL, 0x040b700000041854ULL,
0x000000863c4c723cULL, 0x060b70000004184cULL, 0x000000383c48723cULL, 0x040b700000041848ULL,
0x000000703c44723cULL, 0x040b700000041844ULL, 0x0000006c3c40723cULL, 0x040b700000041840ULL,
0x000000923c5c723cULL, 0x000b62000004185cULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000005812127221ULL, 0x000fe40000010000ULL,
0x0000005913137221ULL, 0x000fc40000010000ULL, 0x0000005416167221ULL, 0x000fe40000010000ULL,
0x0000005517177221ULL, 0x000fe40000010000ULL, 0x000000501a1a7221ULL, 0x000fe40000010000ULL,
0x000000511b1b7221ULL, 0x000fe40000010000ULL, 0x0000004c1e1e7221ULL, 0x020fe40000010000ULL,
0x0000004d1f1f7221ULL, 0x000fc40000010000ULL, 0x0000004822227221ULL, 0x000fe40000010000ULL,
0x0000004923237221ULL, 0x000fe40000010000ULL, 0x0000004426267221ULL, 0x000fe40000010000ULL,
0x0000004527277221ULL, 0x000fe40000010000ULL, 0x000000402a2a7221ULL, 0x000fe40000010000ULL,
0x000000412b2b7221ULL, 0x000fc40000010000ULL, 0x0000005c2e2e7221ULL, 0x000fe40000010000ULL,
0x0000005d2f2f7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x0000005a14147221ULL, 0x000fe40000010000ULL, 0x0000005b15157221ULL, 0x000fe40000010000ULL,
0x0000005618187221ULL, 0x000fe40000010000ULL, 0x0000005719197221ULL, 0x000fe40000010000ULL,
0x000000521c1c7221ULL, 0x000fc40000010000ULL, 0x000000531d1d7221ULL, 0x000fe40000010000ULL,
0x0000004e20207221ULL, 0x020fe40000010000ULL, 0x0000004f21217221ULL, 0x000fe40000010000ULL,
0x0000004a24247221ULL, 0x000fe40000010000ULL, 0x0000004b25257221ULL, 0x000fe40000010000ULL,
0x0000004628287221ULL, 0x000fc40000010000ULL, 0x0000004729297221ULL, 0x000fe40000010000ULL,
0x000000422c2c7221ULL, 0x000fe40000010000ULL, 0x000000432d2d7221ULL, 0x000fe40000010000ULL,
0x0000005e30307221ULL, 0x000fe40000010000ULL, 0x0000005f31317221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000016a6a7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff387f8cULL, 0x020e62000c80043fULL,
0x000000696a00720cULL, 0x000fe20003f06070ULL, 0x000000ffff3c7224ULL, 0x002fd800078e0039ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff8c6000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b7000ffff7f8cULL, 0x000fe4000c80043fULL,
0x000000010f0f7810ULL, 0x000fc80007ffe0ffULL, 0x000000360f00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffe2b5000007947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff3600720cULL, 0x000fda0003f05270ULL,
0x0000039000008947ULL, 0x000fea0003800000ULL, 0x0180000011007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0001f1a000047802ULL, 0x004fc40000000f00ULL, 0x0000af8000007944ULL, 0x002fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001100007308ULL, 0x000ee40000001000ULL,
0xbf80000000027423ULL, 0x00afc80000000011ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006f00ff037624ULL, 0x000fe400078e00ffULL, 0x00006e00ff027624ULL, 0x000fca00078e00ffULL,
0x0000001002037981ULL, 0x000f28000c1e9900ULL, 0x0000000000047919ULL, 0x004ea40000000000ULL,
0x00000002ff3f7819ULL, 0x004fe20000011604ULL, 0x0000000003047220ULL, 0x018fe20000410000ULL,
0x0000a9f27f007947ULL, 0x000fea000b800000ULL, 0x00001f3f04007589ULL, 0x0004e400000e0000ULL,
0x0000000000027919ULL, 0x000f220000000000ULL, 0x0000001200127220ULL, 0x048fe40000410000ULL,
0x0000001300137220ULL, 0x000fc40000410000ULL, 0x0000001600167220ULL, 0x040fe40000410000ULL,
0x0000001700177220ULL, 0x040fe40000410000ULL, 0x0000001a001a7220ULL, 0x040fe40000410000ULL,
0x0000001b001b7220ULL, 0x040fe40000410000ULL, 0x0000001e001e7220ULL, 0x040fe40000410000ULL,
0x0000001f001f7220ULL, 0x000fc40000410000ULL, 0x0000002200227220ULL, 0x040fe40000410000ULL,
0x0000002300237220ULL, 0x040fe40000410000ULL, 0x0000002600267220ULL, 0x040fe40000410000ULL,
0x0000002700277220ULL, 0x000fe20000410000ULL, 0x00000008023f7811ULL, 0x016fe200078ff0ffULL,
0x0000002a002a7220ULL, 0x040fe40000410000ULL, 0x0000002b002b7220ULL, 0x000fc40000410000ULL,
0x0000002e002e7220ULL, 0x040fe40000410000ULL, 0x0000002f002f7220ULL, 0x000fe20000410000ULL,
0x0000a9227f007947ULL, 0x000fea000b800000ULL, 0x00001f3f04007589ULL, 0x0002a400000e0000ULL,
0x0000001400147220ULL, 0x044fe40000410000ULL, 0x0000001500157220ULL, 0x040fe40000410000ULL,
0x0000001800187220ULL, 0x040fe40000410000ULL, 0x0000001900197220ULL, 0x040fe40000410000ULL,
0x0000001c001c7220ULL, 0x000fc40000410000ULL, 0x0000001d001d7220ULL, 0x040fe40000410000ULL,
0x0000002000207220ULL, 0x040fe40000410000ULL, 0x0000002100217220ULL, 0x040fe40000410000ULL,
0x0000002400247220ULL, 0x040fe40000410000ULL, 0x0000002500257220ULL, 0x040fe40000410000ULL,
0x0000002800287220ULL, 0x000fc40000410000ULL, 0x0000002900297220ULL, 0x040fe40000410000ULL,
0x0000002c002c7220ULL, 0x040fe40000410000ULL, 0x0000002d002d7220ULL, 0x040fe40000410000ULL,
0x0000003000307220ULL, 0x040fe40000410000ULL, 0x0000003100317220ULL, 0x000fc40000410000ULL,
0x0000000000337919ULL, 0x000ee20000002600ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000121300723eULL, 0x000fc400000010ffULL, 0x000000161702723eULL, 0x002fe400000010ffULL,
0x0000001a1b03723eULL, 0x000fe400000010ffULL, 0x0000001e1f04723eULL, 0x004fe400000010ffULL,
0x000000222305723eULL, 0x000fe400000010ffULL, 0x000000262706723eULL, 0x000fe400000010ffULL,
0x0000002a2b07723eULL, 0x000fc400000010ffULL, 0x0000002e2f08723eULL, 0x000fe400000010ffULL,
0x000000141509723eULL, 0x000fe400000010ffULL, 0x00000018190a723eULL, 0x000fe400000010ffULL,
0x0000001c1d0b723eULL, 0x000fe400000010ffULL, 0x00000020210c723eULL, 0x000fe400000010ffULL,
0x00000024250d723eULL, 0x000fc400000010ffULL, 0x00000028290e723eULL, 0x000fe400000010ffULL,
0x0000002c2d0f723eULL, 0x000fe400000010ffULL, 0x000000303110723eULL, 0x000fc400000010ffULL,
0x0000000000147919ULL, 0x008e620000000000ULL, 0x0001200008087891ULL, 0x000fe2000f8e583fULL,
0x0000763200197816ULL, 0x000fe40000000002ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000814127811ULL, 0x002fc400078ff0ffULL, 0x0000000214117812ULL, 0x000fc600078ec0ffULL,
0x0000000812167824ULL, 0x000fe200078e00ffULL, 0x0000001211137211ULL, 0x040fe200078ff8ffULL,
0x0000000814127824ULL, 0x000fe200078e00ffULL, 0x00000002ff147819ULL, 0x000fe40000011614ULL,
0xfffffff816167812ULL, 0x000fe400078ee213ULL, 0x0000000812137812ULL, 0x000fe200078ec0ffULL,
0x0000000814127824ULL, 0x040fe200078e00ffULL, 0x0000001411117211ULL, 0x000fe200078ff8ffULL,
0x0000000814177824ULL, 0x000fe200078e00ffULL, 0x0000000816167c11ULL, 0x000fe2000f8e20ffULL,
0x0000000814187824ULL, 0x000fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee211ULL,
0x00000008141a7824ULL, 0x000fe200078e00ffULL, 0x0000000211147810ULL, 0x000fe20007ffe0ffULL,
0x0000000113167824ULL, 0x000fe200078e0216ULL, 0x0000000411157810ULL, 0x000fc40007ffe0ffULL,
0x0000000611117810ULL, 0x000fe40007ffe0ffULL, 0x0000000812127c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff817147812ULL, 0x000fe400078ee214ULL, 0xfffffff818157812ULL, 0x000fe200078ee215ULL,
0x0000000112127824ULL, 0x000fe200078e0213ULL, 0xfffffff81a117812ULL, 0x000fe400078ee211ULL,
0x0000541000187816ULL, 0x000fc40000000002ULL, 0x0000000814147c11ULL, 0x000fe4000f8e20ffULL,
0x0000000815007c11ULL, 0x000fe2000f8e20ffULL, 0x0000001812007388ULL, 0x0003e20000000a00ULL,
0x0000000811027c11ULL, 0x000fe2000f8e20ffULL, 0x0000000113147824ULL, 0x040fe400078e0214ULL,
0x0000000113007824ULL, 0x040fe400078e0200ULL, 0x0000000113027824ULL, 0x000fe200078e0202ULL,
0x0000763203137816ULL, 0x000fc40000000004ULL, 0x0000541003127816ULL, 0x002fe40000000004ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x0000001214007388ULL, 0x0003e20000000a00ULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x0000000400007388ULL, 0x0003e20000000a00ULL,
0x0000541009087816ULL, 0x000fc4000000000aULL, 0x0000763209097816ULL, 0x000fe2000000000aULL,
0x0000000602007388ULL, 0x0003e20000000a00ULL, 0x000054100b0a7816ULL, 0x140fe4000000000cULL,
0x000076320b0b7816ULL, 0x000fe2000000000cULL, 0x0000000816007388ULL, 0x0003e20000000a00ULL,
0x000054100d0c7816ULL, 0x140fe4000000000eULL, 0x000076320d0d7816ULL, 0x000fe2000000000eULL,
0x0004000a14007388ULL, 0x0003e20000000a00ULL, 0x000054100f0e7816ULL, 0x000fc40000000010ULL,
0x000076320f0f7816ULL, 0x000fe20000000010ULL, 0x0004000c00007388ULL, 0x0003e80000000a00ULL,
0x0004000e02007388ULL, 0x0003e20000000a00ULL, 0x0000003000007947ULL, 0x000fea0003800000ULL,
0xffffffffff317424ULL, 0x000fe200078e00ffULL, 0x0001f9b000307802ULL, 0x000fc40000000f00ULL,
0x0000a9e000007944ULL, 0x002fea0003c00000ULL, 0x0000000000097919ULL, 0x002e620000000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x00000005ff087e24ULL, 0x000fe2000f8e00ffULL, 0x00000004130472a4ULL, 0x000fcc000f8e023fULL,
0x00000004ff037e24ULL, 0x000fe2000f8e00ffULL, 0x00000003ff007819ULL, 0x002fca0000011609ULL,
0x0000000100027824ULL, 0x040fe400078e0209ULL, 0x0000580000007a24ULL, 0x000fc600078e0233ULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x0000000003007211ULL, 0x000fe400078010ffULL,
0x0ffffff802047812ULL, 0x000fe400078ef809ULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0000027a11ULL, 0x000fe400078048ffULL,
0x0000000804047984ULL, 0x000e62000800cc00ULL, 0x1ffffff809097812ULL, 0x000fc400078ef808ULL,
0x00005b0000037a11ULL, 0x000fca00000f4c03ULL, 0x0000001009027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d10ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000608057899ULL, 0x000fe2000800063fULL, 0x000000200c007810ULL, 0x000fca0007ffe0ffULL,
0x000000050c037c10ULL, 0x000fe2000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000680000047ab9ULL, 0x000fe20000000800ULL, 0x0000000500057c10ULL, 0x000fe2000fffe0ffULL,
0x000000040a0472a4ULL, 0x000fe2000f8e0205ULL, 0x000000600300720cULL, 0x080fe20003f06070ULL,
0x0000000808067899ULL, 0x000fe2000800063fULL, 0x000000600500720cULL, 0x000fe20003f26070ULL,
0x00000004ff0d7424ULL, 0x000fe200078e00ffULL, 0x018ad000ff087f8cULL, 0x000e62000c80043fULL,
0x000000040c027c10ULL, 0x000fe2000fffe0ffULL, 0x000001a000007945ULL, 0x000fe20003800000ULL,
0x0000000400047c10ULL, 0x000fe2000fffe0ffULL, 0x000000013f047899ULL, 0x000fe20008011608ULL,
0x000000060c0b7c11ULL, 0x000fe2000f8e10ffULL, 0x0000660002027625ULL, 0x000fe200078e000dULL,
0x000000030c00780cULL, 0x000fc60003f44070ULL, 0x0000660004047625ULL, 0x000fe200078e000dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18600000020b7faeULL, 0x0005e6000c121850ULL,
0x00000004ff007e24ULL, 0x000fe2000f8e00ffULL, 0x18680000040b7faeULL, 0x0005e2000c921850ULL,
0x00006e00ff067624ULL, 0x000fe400078e00ffULL, 0x00006f00ff077624ULL, 0x000fe400078e00ffULL,
0x000000a000002947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x004ea20000002700ULL,
0x00000008ff057e24ULL, 0x000fe2000f8e00ffULL, 0x000000370000720cULL, 0x000fc60003f06070ULL,
0x0000000405057824ULL, 0x000fca00078e020cULL, 0x00018a8005057811ULL, 0x000fe200078e10ffULL,
0x0000000403037824ULL, 0x004fc800078e020cULL, 0x0000000203037824ULL, 0x000fc800078e00ffULL,
0x0000640003037a24ULL, 0x000fc800078e0200ULL, 0x0000600003027625ULL, 0x000fca00078e000dULL,
0x0000000002057faeULL, 0x0005e4000c121850ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x000000070d0d7899ULL, 0x000fe2000800063fULL,
0x0000001006047981ULL, 0x004528000c1e9900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x000000400d077892ULL, 0x000fe4000f8ef805ULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x000000ffff037224ULL, 0x002fe200078e0009ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000119000000947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x004e620000000000ULL,
0x00018a8008097891ULL, 0x000fe2000f8e203fULL, 0x0000000560027c17ULL, 0x000fe2000f800000ULL,
0x00000100ff107424ULL, 0x000fe200078e00ffULL, 0x00002000080b7891ULL, 0x000fe4000f8e703fULL,
0x8000000502027c10ULL, 0x000fe4000fffe0ffULL, 0x00000003ff0f7819ULL, 0x002fe2000001160eULL,
0x000000100e077824ULL, 0x000fc600078e00ffULL, 0x000000070f067c10ULL, 0x040fe2000fffe0ffULL,
0x018600060f057984ULL, 0x000e620008004800ULL, 0x000000010f087824ULL, 0x000fe200078e020eULL,
0x0000007007117812ULL, 0x000fe400078ec0ffULL, 0x000000020f00720cULL, 0x040fe40003f06070ULL,
0x000000040f0b7810ULL, 0x000fca0007ffe0ffULL, 0x000000010b0d7824ULL, 0x040fe400078e020eULL,
0x000000080b127824ULL, 0x000fca00078e00ffULL, 0xfffffff8120d7812ULL, 0x000fc800078ee20dULL,
0x0000000b0d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000905057984ULL, 0x002e640008004800ULL,
0x0000000405067c24ULL, 0x002fe2000f8e0206ULL, 0x0000000708057812ULL, 0x000fc600078ec0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0010ULL, 0x0ffffff805057812ULL, 0x000fc800078ef80eULL,
0x0000000611087210ULL, 0x000fe40007f3e0ffULL, 0x0000000b05057c11ULL, 0x000fc6000f8e20ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000070b077c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e2000c101c50ULL,
0x000000020b00720cULL, 0x000fc60003f06070ULL, 0x018610060f0c7984ULL, 0x000ea20008004800ULL,
0x000000080f057810ULL, 0x002fca0007ffe0ffULL, 0x0000000105097824ULL, 0x040fe400078e020eULL,
0x0000000805127824ULL, 0x000fe200078e00ffULL, 0x000000090c0c7984ULL, 0x004e640008004800ULL,
0x000000040c077c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0010ULL,
0x00000006110a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e0607ULL,
0x0000000705077c10ULL, 0x000fc8000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c50ULL, 0x000000020500720cULL, 0x000fe40003f06070ULL,
0xfffffff812057812ULL, 0x000fe200078ee209ULL, 0x018620060f0c7984ULL, 0x000ea60008004800ULL,
0x0000000b05057c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c0f0b7810ULL, 0x002fca0007ffe0ffULL,
0x000000010b0d7824ULL, 0x040fe400078e020eULL, 0x000000080b127824ULL, 0x000fca00078e00ffULL,
0xfffffff8120d7812ULL, 0x000fc800078ee20dULL, 0x0000000b0d0d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000090c0c7984ULL, 0x004e640008004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000611087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000070b077c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e2000c101c50ULL,
0x000000020b00720cULL, 0x000fc60003f06070ULL, 0x018630060f0c7984ULL, 0x000ea20008004800ULL,
0x000000100f057810ULL, 0x002fca0007ffe0ffULL, 0x0000000105097824ULL, 0x040fe400078e020eULL,
0x0000000805127824ULL, 0x000fe200078e00ffULL, 0x000000090c0c7984ULL, 0x004e640008004800ULL,
0x000000040c077c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0010ULL,
0x00000006110a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e0607ULL,
0x0000000705077c10ULL, 0x000fc8000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c50ULL, 0x000000020500720cULL, 0x000fe40003f06070ULL,
0xfffffff812057812ULL, 0x000fe200078ee209ULL, 0x018640060f0c7984ULL, 0x000ea60008004800ULL,
0x0000000b05057c11ULL, 0x000fe4000f8e20ffULL, 0x000000140f0b7810ULL, 0x002fca0007ffe0ffULL,
0x000000010b0d7824ULL, 0x040fe400078e020eULL, 0x000000080b127824ULL, 0x000fca00078e00ffULL,
0xfffffff8120d7812ULL, 0x000fc800078ee20dULL, 0x0000000b0d0d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000090c0c7984ULL, 0x004e640008004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000611087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000070b077c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e2000c101c50ULL,
0x000000020b00720cULL, 0x000fc60003f06070ULL, 0x018650060f0c7984ULL, 0x000ea20008004800ULL,
0x000000180f057810ULL, 0x002fca0007ffe0ffULL, 0x0000000105097824ULL, 0x040fe400078e020eULL,
0x0000000805127824ULL, 0x000fe200078e00ffULL, 0x000000090c0c7984ULL, 0x004e640008004800ULL,
0x000000040c077c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0010ULL,
0x00000006110a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e0607ULL,
0x0000000705077c10ULL, 0x000fc8000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c50ULL, 0x000000020500720cULL, 0x000fe40003f06070ULL,
0xfffffff812057812ULL, 0x000fe200078ee209ULL, 0x018660060f0c7984ULL, 0x000ea60008004800ULL,
0x0000000b05057c11ULL, 0x000fe4000f8e20ffULL, 0x0000001c0f0b7810ULL, 0x002fca0007ffe0ffULL,
0x000000010b0d7824ULL, 0x040fe400078e020eULL, 0x000000080b127824ULL, 0x000fca00078e00ffULL,
0xfffffff8120d7812ULL, 0x000fc800078ee20dULL, 0x0000000b0d0d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000090c0c7984ULL, 0x004e640008004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000611087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000070b077c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e2000c101c50ULL,
0x000000020b00720cULL, 0x000fc60003f06070ULL, 0x018670060f0c7984ULL, 0x000ea20008004800ULL,
0x000000200f057810ULL, 0x002fca0007ffe0ffULL, 0x0000000105097824ULL, 0x040fe400078e020eULL,
0x0000000805127824ULL, 0x000fe200078e00ffULL, 0x000000090c0c7984ULL, 0x004e640008004800ULL,
0x000000040c077c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0010ULL,
0x00000006110a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e0607ULL,
0x0000000705077c10ULL, 0x000fc8000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c50ULL, 0x000000020500720cULL, 0x000fe40003f06070ULL,
0xfffffff812057812ULL, 0x000fe200078ee209ULL, 0x018680060f0c7984ULL, 0x000ea60008004800ULL,
0x0000000b05057c11ULL, 0x000fe4000f8e20ffULL, 0x000000240f0b7810ULL, 0x002fca0007ffe0ffULL,
0x000000010b0d7824ULL, 0x040fe400078e020eULL, 0x000000080b127824ULL, 0x000fca00078e00ffULL,
0xfffffff8120d7812ULL, 0x000fc800078ee20dULL, 0x0000000b0d0d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000090c0c7984ULL, 0x004e640008004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000611087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000070b077c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e2000c101c50ULL,
0x000000020b00720cULL, 0x000fc60003f06070ULL, 0x018690060f0c7984ULL, 0x000ea20008004800ULL,
0x000000280f057810ULL, 0x002fca0007ffe0ffULL, 0x0000000105097824ULL, 0x040fe400078e020eULL,
0x0000000805127824ULL, 0x000fe200078e00ffULL, 0x000000090c0c7984ULL, 0x004e640008004800ULL,
0x000000040c077c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0010ULL,
0x00000006110a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e0607ULL,
0x0000000705077c10ULL, 0x000fc8000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c50ULL, 0x000000020500720cULL, 0x000fe40003f06070ULL,
0xfffffff812057812ULL, 0x000fe200078ee209ULL, 0x0186a0060f0c7984ULL, 0x000ea60008004800ULL,
0x0000000b05057c11ULL, 0x000fe4000f8e20ffULL, 0x0000002c0f0b7810ULL, 0x002fca0007ffe0ffULL,
0x000000010b0d7824ULL, 0x040fe400078e020eULL, 0x000000080b127824ULL, 0x000fca00078e00ffULL,
0xfffffff8120d7812ULL, 0x000fc800078ee20dULL, 0x0000000b0d0d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000090c0c7984ULL, 0x004e640008004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000611087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000070b077c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e2000c101c50ULL,
0x000000020b00720cULL, 0x000fc60003f06070ULL, 0x0186b0060f0c7984ULL, 0x000ea20008004800ULL,
0x000000300f057810ULL, 0x002fca0007ffe0ffULL, 0x0000000105097824ULL, 0x040fe400078e020eULL,
0x0000000805127824ULL, 0x000fe200078e00ffULL, 0x000000090c0c7984ULL, 0x004e640008004800ULL,
0x000000040c077c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0010ULL,
0x00000006110a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e0607ULL,
0x0000000705077c10ULL, 0x000fc8000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c50ULL, 0x000000020500720cULL, 0x000fe40003f06070ULL,
0xfffffff812057812ULL, 0x000fe200078ee209ULL, 0x0186c0060f0c7984ULL, 0x000ea60008004800ULL,
0x0000000b05057c11ULL, 0x000fe4000f8e20ffULL, 0x000000340f0b7810ULL, 0x002fca0007ffe0ffULL,
0x000000010b0d7824ULL, 0x040fe400078e020eULL, 0x000000080b127824ULL, 0x000fca00078e00ffULL,
0xfffffff8120d7812ULL, 0x000fc800078ee20dULL, 0x0000000b0d0d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000090c0c7984ULL, 0x004e640008004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000611087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000070b077c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e2000c101c50ULL,
0x000000020b00720cULL, 0x000fc60003f06070ULL, 0x0186d0060f0c7984ULL, 0x000ea20008004800ULL,
0x000000380f057810ULL, 0x002fca0007ffe0ffULL, 0x0000000105097824ULL, 0x040fe400078e020eULL,
0x0000000805127824ULL, 0x000fe200078e00ffULL, 0x000000090c0c7984ULL, 0x004e640008004800ULL,
0x000000040c077c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0010ULL,
0x00000006110a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e0607ULL,
0x0000000705077c10ULL, 0x000fc8000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c50ULL, 0x000000020500720cULL, 0x000fe40003f06070ULL,
0xfffffff812057812ULL, 0x000fe200078ee209ULL, 0x0186e0060f0c7984ULL, 0x000ea60008004800ULL,
0x0000000b05057c11ULL, 0x000fe4000f8e20ffULL, 0x0000003c0f0b7810ULL, 0x002fe20007ffe0ffULL,
0x000000090c0c7984ULL, 0x004e640008004800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000611087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000070b077c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e2000c101c50ULL,
0x000000020b00720cULL, 0x040fe20003f06070ULL, 0x000000010b027824ULL, 0x040fe400078e020eULL,
0x0186f0060f0a7984ULL, 0x000ea20008004800ULL, 0x000000080b0b7824ULL, 0x000fca00078e00ffULL,
0xfffffff80b027812ULL, 0x000fc800078ee202ULL, 0x0000000b02057c11ULL, 0x002fe2000f8e20ffULL,
0x000000090a0a7984ULL, 0x004e640008004800ULL, 0x000000040a077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0010ULL, 0x0000000611067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e2000c101c50ULL, 0x0000106000007947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x004e620000000000ULL, 0x00018a8008097891ULL, 0x000fe2000f8e203fULL,
0x00000100ff0d7424ULL, 0x000fe200078e00ffULL, 0x00002000080b7891ULL, 0x000fe2000f8e703fULL,
0x00000003ff0c7819ULL, 0x002fe20000011605ULL, 0x0000001005087824ULL, 0x000fc600078e00ffULL,
0x000000070c077c10ULL, 0x040fe2000fffe0ffULL, 0x018600060c027984ULL, 0x000e620008004800ULL,
0x000000010c097824ULL, 0x000fe200078e0205ULL, 0x00000070080f7812ULL, 0x000fc800078ec0ffULL,
0x00000007090a7812ULL, 0x000fc800078ec0ffULL, 0x0ffffff80a0a7812ULL, 0x000fc800078ef805ULL,
0x0000000b0a117c11ULL, 0x000fe4000f8e20ffULL, 0x000000040c0a7810ULL, 0x000fca0007ffe0ffULL,
0x000000010a0b7824ULL, 0x040fe400078e0205ULL, 0x000000080a0e7824ULL, 0x000fe200078e00ffULL,
0x0000000902027984ULL, 0x002e640008004800ULL, 0x0000000402067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000dULL, 0x0000000f06087210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x000000070a077c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e8000b901c50ULL,
0x018610060c027984ULL, 0x000ea20008004800ULL, 0x000000080c087810ULL, 0x002fca0007ffe0ffULL,
0x0000000108097824ULL, 0x000fe200078e0205ULL, 0x0000000902027984ULL, 0x004e640008004800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000dULL,
0x0000000f060a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80e067812ULL, 0x000fe200078ee20bULL,
0x00000008080e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0607ULL,
0x0000000b06117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000708077c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a117faeULL, 0x0003e8000b901c50ULL,
0x018620060c027984ULL, 0x000ea20008004800ULL, 0x0000000c0c0a7810ULL, 0x002fca0007ffe0ffULL,
0x000000010a0b7824ULL, 0x000fe200078e0205ULL, 0x0000000902027984ULL, 0x004e640008004800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000dULL,
0x0000000f06087210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80e067812ULL, 0x000fe200078ee209ULL,
0x000000080a0e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000000b06117c11ULL, 0x000fe4000f8e20ffULL, 0x000000070a077c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e8000b901c50ULL,
0x018630060c027984ULL, 0x000ea20008004800ULL, 0x000000100c087810ULL, 0x002fca0007ffe0ffULL,
0x0000000108097824ULL, 0x000fe200078e0205ULL, 0x0000000902027984ULL, 0x004e640008004800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000dULL,
0x0000000f060a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80e067812ULL, 0x000fe200078ee20bULL,
0x00000008080e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0607ULL,
0x0000000b06117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000708077c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a117faeULL, 0x0003e8000b901c50ULL,
0x018640060c027984ULL, 0x000ea20008004800ULL, 0x000000140c0a7810ULL, 0x002fca0007ffe0ffULL,
0x000000010a0b7824ULL, 0x000fe200078e0205ULL, 0x0000000902027984ULL, 0x004e640008004800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000dULL,
0x0000000f06087210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80e067812ULL, 0x000fe200078ee209ULL,
0x000000080a0e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000000b06117c11ULL, 0x000fe4000f8e20ffULL, 0x000000070a077c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e8000b901c50ULL,
0x018650060c027984ULL, 0x000ea20008004800ULL, 0x000000180c087810ULL, 0x002fca0007ffe0ffULL,
0x0000000108097824ULL, 0x000fe200078e0205ULL, 0x0000000902027984ULL, 0x004e640008004800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000dULL,
0x0000000f060a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80e067812ULL, 0x000fe200078ee20bULL,
0x00000008080e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0607ULL,
0x0000000b06117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000708077c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a117faeULL, 0x0003e8000b901c50ULL,
0x018660060c027984ULL, 0x000ea20008004800ULL, 0x0000001c0c0a7810ULL, 0x002fca0007ffe0ffULL,
0x000000010a0b7824ULL, 0x000fe200078e0205ULL, 0x0000000902027984ULL, 0x004e640008004800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000dULL,
0x0000000f06087210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80e067812ULL, 0x000fe200078ee209ULL,
0x000000080a0e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000000b06117c11ULL, 0x000fe4000f8e20ffULL, 0x000000070a077c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e8000b901c50ULL,
0x018670060c027984ULL, 0x000ea20008004800ULL, 0x000000200c087810ULL, 0x002fca0007ffe0ffULL,
0x0000000108097824ULL, 0x000fe200078e0205ULL, 0x0000000902027984ULL, 0x004e640008004800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000dULL,
0x0000000f060a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80e067812ULL, 0x000fe200078ee20bULL,
0x00000008080e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0607ULL,
0x0000000b06117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000708077c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a117faeULL, 0x0003e8000b901c50ULL,
0x018680060c027984ULL, 0x000ea20008004800ULL, 0x000000240c0a7810ULL, 0x002fca0007ffe0ffULL,
0x000000010a0b7824ULL, 0x000fe200078e0205ULL, 0x0000000902027984ULL, 0x004e640008004800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000dULL,
0x0000000f06087210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80e067812ULL, 0x000fe200078ee209ULL,
0x000000080a0e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000000b06117c11ULL, 0x000fe4000f8e20ffULL, 0x000000070a077c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e8000b901c50ULL,
0x018690060c027984ULL, 0x000ea20008004800ULL, 0x000000280c087810ULL, 0x002fca0007ffe0ffULL,
0x0000000108097824ULL, 0x000fe200078e0205ULL, 0x0000000902027984ULL, 0x004e640008004800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000dULL,
0x0000000f060a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80e067812ULL, 0x000fe200078ee20bULL,
0x00000008080e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0607ULL,
0x0000000b06117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000708077c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a117faeULL, 0x0003e8000b901c50ULL,
0x0186a0060c027984ULL, 0x000ea20008004800ULL, 0x0000002c0c0a7810ULL, 0x002fca0007ffe0ffULL,
0x000000010a0b7824ULL, 0x000fe200078e0205ULL, 0x0000000902027984ULL, 0x004e640008004800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000dULL,
0x0000000f06087210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80e067812ULL, 0x000fe200078ee209ULL,
0x000000080a0e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000000b06117c11ULL, 0x000fe4000f8e20ffULL, 0x000000070a077c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e8000b901c50ULL,
0x0186b0060c027984ULL, 0x000ea20008004800ULL, 0x000000300c087810ULL, 0x002fca0007ffe0ffULL,
0x0000000108097824ULL, 0x000fe200078e0205ULL, 0x0000000902027984ULL, 0x004e640008004800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000dULL,
0x0000000f060a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80e067812ULL, 0x000fe200078ee20bULL,
0x00000008080e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0607ULL,
0x0000000b06117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000708077c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a117faeULL, 0x0003e8000b901c50ULL,
0x0186c0060c027984ULL, 0x000ea20008004800ULL, 0x000000340c0a7810ULL, 0x002fca0007ffe0ffULL,
0x000000010a0b7824ULL, 0x000fe200078e0205ULL, 0x0000000902027984ULL, 0x004e640008004800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000dULL,
0x0000000f06087210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80e067812ULL, 0x000fe200078ee209ULL,
0x000000080a0e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000000b06117c11ULL, 0x000fe4000f8e20ffULL, 0x000000070a077c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e8000b901c50ULL,
0x0186d0060c027984ULL, 0x000ea20008004800ULL, 0x000000380c087810ULL, 0x002fca0007ffe0ffULL,
0x0000000108097824ULL, 0x000fe200078e0205ULL, 0x0000000902027984ULL, 0x004e640008004800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000dULL,
0x0000000f060a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80e067812ULL, 0x000fe200078ee20bULL,
0x00000008080e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0607ULL,
0x0000000b06117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000708077c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a117faeULL, 0x0003e8000b901c50ULL,
0x0186e0060c027984ULL, 0x000ea20008004800ULL, 0x0000003c0c0a7810ULL, 0x002fca0007ffe0ffULL,
0x000000010a057824ULL, 0x000fe200078e0205ULL, 0x0000000902027984ULL, 0x004e640008004800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000dULL,
0x0000000f06087210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80e067812ULL, 0x000fc600078ee209ULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x0000000b060b7c11ULL, 0x000fe4000f8e20ffULL,
0x000000070a077c10ULL, 0x040fe2000fffe0ffULL, 0x000000080a0a7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e6000b901c50ULL,
0xfffffff80a057812ULL, 0x000fe200078ee205ULL, 0x0186f0060c027984ULL, 0x000ea60008004800ULL,
0x0000000b05057c11ULL, 0x000fe2000f8e20ffULL, 0x0000000902027984ULL, 0x004ea40008004800ULL,
0x0000000402067c24ULL, 0x004fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000dULL,
0x0000000f06067210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e6000b901c50ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x002fc40000015200ULL, 0x018ad400ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000806057210ULL, 0x000fca0007f1e1ffULL, 0x0000000109087824ULL, 0x000fe200000e0e07ULL,
0x003d09000500780cULL, 0x000fc80003f06070ULL, 0x000000ff0800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400500780cULL, 0x000fc80003f06070ULL,
0x000000ff0800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011408ULL, 0x0000000502027211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0608ULL, 0x0000000202027819ULL, 0x000fc80000001205ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x018ad400ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x00000008ff027e24ULL, 0x000fc8000f8e00ffULL, 0x0000002002037824ULL, 0x002fca00078e0203ULL,
0x00000003ff057819ULL, 0x000fe40000011603ULL, 0x0000000f03037812ULL, 0x000fe400078ec0ffULL,
0x1ffffffe05067812ULL, 0x000fe400078ec0ffULL, 0x0000000103057810ULL, 0x040fe20007ffe0ffULL,
0x0000002003097824ULL, 0x040fe400078e00ffULL, 0x0000000103077824ULL, 0x040fe400078e0206ULL,
0x0000000106087824ULL, 0x040fe200078e0205ULL, 0x0000001006067810ULL, 0x000fe20007ffe0ffULL,
0x00000020030a7824ULL, 0x000fe200078e00ffULL, 0x0000001f07077812ULL, 0x000fc400078ec0ffULL,
0x0000001f08087812ULL, 0x000fe200078ec0ffULL, 0x0000000105057824ULL, 0x000fe200078e0206ULL,
0x000001e00a077812ULL, 0x040fe400078ee207ULL, 0x000001e009087812ULL, 0x000fe200078ee208ULL,
0x0000000103097824ULL, 0x000fe200078e0206ULL, 0x0000001f05057812ULL, 0x000fe200078ec0ffULL,
0x0000000007107984ULL, 0x000e62000000cc00ULL, 0x0000002003067824ULL, 0x000fe400078e00ffULL,
0x0000001f09097812ULL, 0x000fe200078ec0ffULL, 0x00000000080c7984ULL, 0x000ea2000000cc00ULL,
0x000001e00a057812ULL, 0x000fc400078ee205ULL, 0x000001e006097812ULL, 0x000fe200078ee209ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff1a7224ULL, 0x000fe400078e000dULL, 0x000000ffff1b7224ULL, 0x000fe200078e000fULL,
0x0000001407007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff187224ULL, 0x000fc400078e0011ULL,
0x000000ffff197224ULL, 0x000fca00078e0013ULL, 0x0000001808007388ULL, 0x000fe8000000cc00ULL,
0x00000000050c7984ULL, 0x000e68000000cc00ULL, 0x0000000009107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000eULL, 0x000000ffff1e7224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1c7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000001c09007388ULL, 0x0003e8000000cc00ULL,
0x0000000c05007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018ad000ff067f8cULL, 0x000ea2000c80043fULL, 0x000000ffff057224ULL, 0x002fc400078e00ffULL,
0x000000ffff0a7224ULL, 0x004fc400078e0007ULL, 0x0000000000067805ULL, 0x000fca0000015200ULL,
0x018ad400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000806087210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011409ULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e0609ULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000105057810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x018ad400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff3600720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x00005800ff087624ULL, 0x000fe200078e00ffULL, 0x00018b5802057811ULL, 0x000fe200078e18ffULL,
0x3d80000004047820ULL, 0x010fe20000410000ULL, 0xffffffff36067810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x00018ad802077811ULL, 0x000fe200078e28ffULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x0000008008087824ULL, 0x000fc400078e00ffULL,
0x00000005090d7c11ULL, 0x000fe2000f8e40ffULL, 0x0000000000007946ULL, 0x000fe60003800000ULL,
0x0000000d6000720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x00000004ff0f7424ULL, 0x000fe200078e00ffULL, 0x000000093400720cULL, 0x000fe20003f44070ULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x000000010f0f7807ULL, 0x000fc40005000000ULL,
0x000000ffff117224ULL, 0x000fe200078e000bULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0c7224ULL, 0x000fe200078e000aULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fc4000001ff00ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x000000337f007947ULL, 0x020fea000b800000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x00022ae000307802ULL, 0x000fc40000000f00ULL, 0x000078b000007944ULL, 0x002fea0003c00000ULL,
0x000000010e197810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000a19127211ULL, 0x040fe200078ff8ffULL, 0x000020c000007945ULL, 0x000fe20003800000ULL,
0x00000001195c7812ULL, 0x000fe400078ec0ffULL, 0x0000000312307812ULL, 0x000fe400078ec0ffULL,
0x00000002ff12a819ULL, 0x000fca0000011612ULL, 0x0000000112177824ULL, 0x000fe200078e0209ULL,
0x000000ff30127207ULL, 0x000fc80005000000ULL, 0x00000001170b7810ULL, 0x040fe40007ffe0ffULL,
0x00000005173d7c11ULL, 0x000fe4000f8e40ffULL, 0x000000360b00720cULL, 0x000fe40003f06070ULL,
0x000000403d317812ULL, 0x000fe400078ec0ffULL, 0x00000001110b7812ULL, 0x000fe400078e0cffULL,
0x0000000d31307c10ULL, 0x000fce000fffe0ffULL, 0x0000109000008947ULL, 0x000fea0003800000ULL,
0x00000003ff317819ULL, 0x002fe20000011603ULL, 0x00018a8008047891ULL, 0x000fe2000f8e203fULL,
0x0000003d60327217ULL, 0x000fe20007800000ULL, 0x00000002023f7824ULL, 0x000fe200078e020bULL,
0x0000000431677810ULL, 0x040fe20007ffe0ffULL, 0x0186000631337984ULL, 0x000e620008004800ULL,
0x00000001313c7824ULL, 0x040fe400078e0230ULL, 0x00000001315e7824ULL, 0x000fe400078e0203ULL,
0x0000000132327824ULL, 0x000fc400078e0a3dULL, 0x000000085c627824ULL, 0x000fe200078e00ffULL,
0x000000075e5e7812ULL, 0x000fe200078ec0ffULL, 0x00000100ff3d7424ULL, 0x000fe200078e00ffULL,
0x000000323100720cULL, 0x000fe20003f06070ULL, 0x0000000167647824ULL, 0x140fe200078e0203ULL,
0x0ffffff85e657812ULL, 0x000fe200078ef803ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x0000000433337984ULL, 0x002e640008004800ULL, 0x00000033083e7224ULL, 0x002fe200078e023cULL,
0x000020003f3c7811ULL, 0x000fc400078e68ffULL, 0xfffffff862337812ULL, 0x000fe200078ee203ULL,
0x00005e003e3e7625ULL, 0x000fc800078e003dULL, 0x0000001065657824ULL, 0x000fe400078e023cULL,
0x00000010333e7825ULL, 0x000fc800078e003eULL, 0x0000000167627824ULL, 0x040fe200078e0230ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e657faeULL, 0x0003e2000c101c50ULL,
0x000000326700720cULL, 0x000fe40003f06070ULL, 0xfffffff869677812ULL, 0x000fe200078ee264ULL,
0x01861006315e7984ULL, 0x000ea80008004800ULL, 0x0000001067657824ULL, 0x002fe200078e023cULL,
0x0000000831677810ULL, 0x000fca0007ffe0ffULL, 0x00000001673e7824ULL, 0x040fe400078e0230ULL,
0x0000000167647824ULL, 0x040fe400078e0203ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x000000045e637984ULL, 0x004e640008004800ULL, 0x0000006308627224ULL, 0x002fc800078e0262ULL,
0x00005e0062627625ULL, 0x000fcc00078e003dULL, 0x0000001033627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062657faeULL, 0x0003e2000c101c50ULL,
0x000000326700720cULL, 0x000fe40003f06070ULL, 0xfffffff869677812ULL, 0x000fe200078ee264ULL,
0x01862006315e7984ULL, 0x000ea80008004800ULL, 0x0000001067657824ULL, 0x002fe200078e023cULL,
0x0000000c31677810ULL, 0x000fca0007ffe0ffULL, 0x0000000167627824ULL, 0x040fe400078e0230ULL,
0x0000000167647824ULL, 0x040fe400078e0203ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x000000045e3f7984ULL, 0x004e640008004800ULL, 0x0000003f083e7224ULL, 0x002fc800078e023eULL,
0x00005e003e3e7625ULL, 0x000fcc00078e003dULL, 0x00000010333e7825ULL, 0x000fca00078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e657faeULL, 0x0003e2000c101c50ULL,
0x000000326700720cULL, 0x000fe40003f06070ULL, 0xfffffff869677812ULL, 0x000fe200078ee264ULL,
0x01863006315e7984ULL, 0x000ea80008004800ULL, 0x0000001067657824ULL, 0x002fe200078e023cULL,
0x0000001031677810ULL, 0x000fca0007ffe0ffULL, 0x00000001673e7824ULL, 0x040fe400078e0230ULL,
0x0000000167647824ULL, 0x040fe400078e0203ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x000000045e637984ULL, 0x004e640008004800ULL, 0x0000006308627224ULL, 0x002fc800078e0262ULL,
0x00005e0062627625ULL, 0x000fcc00078e003dULL, 0x0000001033627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062657faeULL, 0x0003e2000c101c50ULL,
0x000000326700720cULL, 0x000fe40003f06070ULL, 0xfffffff869677812ULL, 0x000fe200078ee264ULL,
0x01864006315e7984ULL, 0x000ea80008004800ULL, 0x0000001067657824ULL, 0x002fe200078e023cULL,
0x0000001431677810ULL, 0x000fca0007ffe0ffULL, 0x0000000167627824ULL, 0x040fe400078e0230ULL,
0x0000000167647824ULL, 0x040fe400078e0203ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x000000045e3f7984ULL, 0x004e640008004800ULL, 0x0000003f083e7224ULL, 0x002fc800078e023eULL,
0x00005e003e3e7625ULL, 0x000fcc00078e003dULL, 0x00000010333e7825ULL, 0x000fca00078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e657faeULL, 0x0003e2000c101c50ULL,
0x000000326700720cULL, 0x000fe40003f06070ULL, 0xfffffff869677812ULL, 0x000fe200078ee264ULL,
0x01865006315e7984ULL, 0x000ea80008004800ULL, 0x0000001067657824ULL, 0x002fe200078e023cULL,
0x0000001831677810ULL, 0x000fca0007ffe0ffULL, 0x00000001673e7824ULL, 0x040fe400078e0230ULL,
0x0000000167647824ULL, 0x040fe400078e0203ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x000000045e637984ULL, 0x004e640008004800ULL, 0x0000006308627224ULL, 0x002fc800078e0262ULL,
0x00005e0062627625ULL, 0x000fcc00078e003dULL, 0x0000001033627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062657faeULL, 0x0003e2000c101c50ULL,
0x000000326700720cULL, 0x000fe40003f06070ULL, 0xfffffff869677812ULL, 0x000fe200078ee264ULL,
0x01866006315e7984ULL, 0x000ea80008004800ULL, 0x0000001067657824ULL, 0x002fe200078e023cULL,
0x0000001c31677810ULL, 0x000fca0007ffe0ffULL, 0x0000000167627824ULL, 0x040fe400078e0230ULL,
0x0000000167647824ULL, 0x040fe400078e0203ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x000000045e3f7984ULL, 0x004e640008004800ULL, 0x0000003f083e7224ULL, 0x002fc800078e023eULL,
0x00005e003e3e7625ULL, 0x000fcc00078e003dULL, 0x00000010333e7825ULL, 0x000fca00078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e657faeULL, 0x0003e2000c101c50ULL,
0x000000326700720cULL, 0x000fe40003f06070ULL, 0xfffffff869677812ULL, 0x000fe200078ee264ULL,
0x01867006315e7984ULL, 0x000ea80008004800ULL, 0x0000001067657824ULL, 0x002fe200078e023cULL,
0x0000002031677810ULL, 0x000fca0007ffe0ffULL, 0x00000001673e7824ULL, 0x040fe400078e0230ULL,
0x0000000167647824ULL, 0x040fe400078e0203ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x000000045e637984ULL, 0x004e640008004800ULL, 0x0000006308627224ULL, 0x002fc800078e0262ULL,
0x00005e0062627625ULL, 0x000fcc00078e003dULL, 0x0000001033627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062657faeULL, 0x0003e2000c101c50ULL,
0x000000326700720cULL, 0x000fe40003f06070ULL, 0xfffffff869677812ULL, 0x000fe200078ee264ULL,
0x01868006315e7984ULL, 0x000ea80008004800ULL, 0x0000001067657824ULL, 0x002fe200078e023cULL,
0x0000002431677810ULL, 0x000fca0007ffe0ffULL, 0x0000000167627824ULL, 0x040fe400078e0230ULL,
0x0000000167647824ULL, 0x040fe400078e0203ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x000000045e3f7984ULL, 0x004e640008004800ULL, 0x0000003f083e7224ULL, 0x002fc800078e023eULL,
0x00005e003e3e7625ULL, 0x000fcc00078e003dULL, 0x00000010333e7825ULL, 0x000fca00078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e657faeULL, 0x0003e2000c101c50ULL,
0x000000326700720cULL, 0x000fe40003f06070ULL, 0xfffffff869677812ULL, 0x000fe200078ee264ULL,
0x01869006315e7984ULL, 0x000ea80008004800ULL, 0x0000001067657824ULL, 0x002fe200078e023cULL,
0x0000002831677810ULL, 0x000fca0007ffe0ffULL, 0x00000001673e7824ULL, 0x040fe400078e0230ULL,
0x0000000167647824ULL, 0x040fe400078e0203ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x000000045e637984ULL, 0x004e640008004800ULL, 0x0000006308627224ULL, 0x002fc800078e0262ULL,
0x00005e0062627625ULL, 0x000fcc00078e003dULL, 0x0000001033627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062657faeULL, 0x0003e2000c101c50ULL,
0x000000326700720cULL, 0x000fe40003f06070ULL, 0xfffffff869677812ULL, 0x000fe200078ee264ULL,
0x0186a006315e7984ULL, 0x000ea80008004800ULL, 0x0000001067657824ULL, 0x002fe200078e023cULL,
0x0000002c31677810ULL, 0x000fca0007ffe0ffULL, 0x0000000167627824ULL, 0x040fe400078e0230ULL,
0x0000000167647824ULL, 0x040fe400078e0203ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x000000045e3f7984ULL, 0x004e640008004800ULL, 0x0000003f083e7224ULL, 0x002fc800078e023eULL,
0x00005e003e3e7625ULL, 0x000fcc00078e003dULL, 0x00000010333e7825ULL, 0x000fca00078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e657faeULL, 0x0003e2000c101c50ULL,
0x000000326700720cULL, 0x000fe40003f06070ULL, 0xfffffff869677812ULL, 0x000fe200078ee264ULL,
0x0186b006315e7984ULL, 0x000ea80008004800ULL, 0x0000001067657824ULL, 0x002fe200078e023cULL,
0x0000003031677810ULL, 0x000fca0007ffe0ffULL, 0x00000001673e7824ULL, 0x040fe400078e0230ULL,
0x0000000167647824ULL, 0x040fe400078e0203ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x000000045e637984ULL, 0x004e640008004800ULL, 0x0000006308627224ULL, 0x002fc800078e0262ULL,
0x00005e0062627625ULL, 0x000fcc00078e003dULL, 0x0000001033627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062657faeULL, 0x0003e2000c101c50ULL,
0x000000326700720cULL, 0x000fe40003f06070ULL, 0xfffffff869677812ULL, 0x000fe200078ee264ULL,
0x0186c006315e7984ULL, 0x000ea80008004800ULL, 0x0000001067657824ULL, 0x002fe200078e023cULL,
0x0000003431677810ULL, 0x000fca0007ffe0ffULL, 0x0000000167627824ULL, 0x040fe400078e0230ULL,
0x0000000167647824ULL, 0x040fe400078e0203ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x000000045e3f7984ULL, 0x004e640008004800ULL, 0x0000003f083e7224ULL, 0x002fc800078e023eULL,
0x00005e003e3e7625ULL, 0x000fcc00078e003dULL, 0x00000010333e7825ULL, 0x000fca00078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e657faeULL, 0x0003e2000c101c50ULL,
0x000000326700720cULL, 0x000fe40003f06070ULL, 0xfffffff869677812ULL, 0x000fe200078ee264ULL,
0x0186d006315e7984ULL, 0x000ea80008004800ULL, 0x0000001067657824ULL, 0x002fe200078e023cULL,
0x0000003831677810ULL, 0x000fca0007ffe0ffULL, 0x00000001673e7824ULL, 0x040fe400078e0230ULL,
0x0000000167647824ULL, 0x040fe400078e0203ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x000000045e637984ULL, 0x004e640008004800ULL, 0x0000006308627224ULL, 0x002fc800078e0262ULL,
0x00005e0062627625ULL, 0x000fcc00078e003dULL, 0x0000001033627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062657faeULL, 0x0003e2000c101c50ULL,
0x000000326700720cULL, 0x000fe40003f06070ULL, 0xfffffff869677812ULL, 0x000fe200078ee264ULL,
0x0186e006315e7984ULL, 0x000ea80008004800ULL, 0x0000001067657824ULL, 0x002fe200078e023cULL,
0x0000003c31677810ULL, 0x000fca0007ffe0ffULL, 0x0000000167307824ULL, 0x040fe400078e0230ULL,
0x0000000167647824ULL, 0x040fe400078e0203ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x000000045e3f7984ULL, 0x004e640008004800ULL, 0x0000003f083e7224ULL, 0x002fc800078e023eULL,
0x00005e003e3e7625ULL, 0x000fcc00078e003dULL, 0x00000010333e7825ULL, 0x000fca00078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e657faeULL, 0x0003e2000c101c50ULL,
0x000000326700720cULL, 0x000fc60003f06070ULL, 0x0186f006315e7984ULL, 0x000ea80008004800ULL,
0x000000045e637984ULL, 0x004ea40008004800ULL, 0x0000006308307224ULL, 0x004fc800078e0230ULL,
0x00005e0030627625ULL, 0x000fe200078e003dULL, 0xfffffff8693d7812ULL, 0x000fca00078ee264ULL,
0x000000103d3d7824ULL, 0x000fe400078e023cULL, 0x0000001033627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000623d7faeULL, 0x0003e2000c101c50ULL,
0x00000f6000007947ULL, 0x000fea0003800000ULL, 0x00000003ff317819ULL, 0x002fe20000011603ULL,
0x00018a8008047891ULL, 0x000fe2000f8e203fULL, 0x000000085c3e7824ULL, 0x000fe400078e00ffULL,
0x00000002023c7824ULL, 0x000fe200078e020bULL, 0x01860006313d7984ULL, 0x000e620008004800ULL,
0x00000001313f7824ULL, 0x040fe400078e0230ULL, 0x0000000131337824ULL, 0x000fe200078e0203ULL,
0x000020003c3c7811ULL, 0x000fe200078e68ffULL, 0x00000100ff327424ULL, 0x000fc600078e00ffULL,
0x00000007335e7812ULL, 0x000fe400078ec0ffULL, 0xfffffff83e337812ULL, 0x000fe200078ee203ULL,
0x000000043d3d7984ULL, 0x002e640008004800ULL, 0x0000003d083f7224ULL, 0x002fe200078e023fULL,
0x0ffffff85e3d7812ULL, 0x000fe400078ef803ULL, 0x00000004315e7810ULL, 0x000fe20007ffe0ffULL,
0x00005e003f3e7625ULL, 0x000fc800078e0032ULL, 0x000000103d657824ULL, 0x000fe400078e023cULL,
0x00000010333e7825ULL, 0x000fc800078e003eULL, 0x000000015e637824ULL, 0x040fe200078e0230ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e657faeULL, 0x0003e2000b901c50ULL,
0x000000015e647824ULL, 0x040fe400078e0203ULL, 0x000000085e677824ULL, 0x000fe200078e00ffULL,
0x01861006313d7984ULL, 0x000ea80008004800ULL, 0xfffffff867677812ULL, 0x000fe400078ee264ULL,
0x00000008313e7810ULL, 0x002fc60007ffe0ffULL, 0x0000001067677824ULL, 0x000fe400078e023cULL,
0x000000013e3f7824ULL, 0x040fe400078e0230ULL, 0x000000013e5e7824ULL, 0x040fe400078e0203ULL,
0x000000083e657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fe400078ee25eULL,
0x0000000c315e7810ULL, 0x000fc60007ffe0ffULL, 0x0000001065657824ULL, 0x000fe400078e023cULL,
0x000000015e647824ULL, 0x000fe200078e0203ULL, 0x000000043d3d7984ULL, 0x004e640008004800ULL,
0x0000003d08637224ULL, 0x002fc800078e0263ULL, 0x00005e0063627625ULL, 0x000fcc00078e0032ULL,
0x0000001033627825ULL, 0x000fca00078e0062ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062677faeULL, 0x0003e8000b901c50ULL, 0x01862006313d7984ULL, 0x000ea20008004800ULL,
0x000000015e637824ULL, 0x042fe400078e0230ULL, 0x000000085e677824ULL, 0x000fca00078e00ffULL,
0xfffffff867677812ULL, 0x000fca00078ee264ULL, 0x0000001067677824ULL, 0x000fe200078e023cULL,
0x000000043d3d7984ULL, 0x004e640008004800ULL, 0x0000003d083f7224ULL, 0x002fc800078e023fULL,
0x00005e003f3e7625ULL, 0x000fcc00078e0032ULL, 0x00000010333e7825ULL, 0x000fca00078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e657faeULL, 0x0003e8000b901c50ULL,
0x01863006313d7984ULL, 0x000ea20008004800ULL, 0x00000010313e7810ULL, 0x002fca0007ffe0ffULL,
0x000000013e3f7824ULL, 0x040fe400078e0230ULL, 0x000000013e5e7824ULL, 0x040fe400078e0203ULL,
0x000000083e657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fe400078ee25eULL,
0x00000014315e7810ULL, 0x000fc60007ffe0ffULL, 0x0000001065657824ULL, 0x000fe400078e023cULL,
0x000000015e647824ULL, 0x000fe200078e0203ULL, 0x000000043d3d7984ULL, 0x004e640008004800ULL,
0x0000003d08637224ULL, 0x002fc800078e0263ULL, 0x00005e0063627625ULL, 0x000fcc00078e0032ULL,
0x0000001033627825ULL, 0x000fca00078e0062ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062677faeULL, 0x0003e8000b901c50ULL, 0x01864006313d7984ULL, 0x000ea20008004800ULL,
0x000000015e637824ULL, 0x042fe400078e0230ULL, 0x000000085e677824ULL, 0x000fca00078e00ffULL,
0xfffffff867677812ULL, 0x000fca00078ee264ULL, 0x0000001067677824ULL, 0x000fe200078e023cULL,
0x000000043d3d7984ULL, 0x004e640008004800ULL, 0x0000003d083f7224ULL, 0x002fc800078e023fULL,
0x00005e003f3e7625ULL, 0x000fcc00078e0032ULL, 0x00000010333e7825ULL, 0x000fca00078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e657faeULL, 0x0003e8000b901c50ULL,
0x01865006313d7984ULL, 0x000ea20008004800ULL, 0x00000018313e7810ULL, 0x002fca0007ffe0ffULL,
0x000000013e3f7824ULL, 0x040fe400078e0230ULL, 0x000000013e5e7824ULL, 0x040fe400078e0203ULL,
0x000000083e657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fe400078ee25eULL,
0x0000001c315e7810ULL, 0x000fc60007ffe0ffULL, 0x0000001065657824ULL, 0x000fe400078e023cULL,
0x000000015e647824ULL, 0x000fe200078e0203ULL, 0x000000043d3d7984ULL, 0x004e640008004800ULL,
0x0000003d08637224ULL, 0x002fc800078e0263ULL, 0x00005e0063627625ULL, 0x000fcc00078e0032ULL,
0x0000001033627825ULL, 0x000fca00078e0062ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062677faeULL, 0x0003e8000b901c50ULL, 0x01866006313d7984ULL, 0x000ea20008004800ULL,
0x000000015e637824ULL, 0x042fe400078e0230ULL, 0x000000085e677824ULL, 0x000fca00078e00ffULL,
0xfffffff867677812ULL, 0x000fca00078ee264ULL, 0x0000001067677824ULL, 0x000fe200078e023cULL,
0x000000043d3d7984ULL, 0x004e640008004800ULL, 0x0000003d083f7224ULL, 0x002fc800078e023fULL,
0x00005e003f3e7625ULL, 0x000fcc00078e0032ULL, 0x00000010333e7825ULL, 0x000fca00078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e657faeULL, 0x0003e8000b901c50ULL,
0x01867006313d7984ULL, 0x000ea20008004800ULL, 0x00000020313e7810ULL, 0x002fca0007ffe0ffULL,
0x000000013e3f7824ULL, 0x040fe400078e0230ULL, 0x000000013e5e7824ULL, 0x040fe400078e0203ULL,
0x000000083e657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fe400078ee25eULL,
0x00000024315e7810ULL, 0x000fc60007ffe0ffULL, 0x0000001065657824ULL, 0x000fe400078e023cULL,
0x000000015e647824ULL, 0x000fe200078e0203ULL, 0x000000043d3d7984ULL, 0x004e640008004800ULL,
0x0000003d08637224ULL, 0x002fc800078e0263ULL, 0x00005e0063627625ULL, 0x000fcc00078e0032ULL,
0x0000001033627825ULL, 0x000fca00078e0062ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062677faeULL, 0x0003e8000b901c50ULL, 0x01868006313d7984ULL, 0x000ea20008004800ULL,
0x000000015e637824ULL, 0x042fe400078e0230ULL, 0x000000085e677824ULL, 0x000fca00078e00ffULL,
0xfffffff867677812ULL, 0x000fca00078ee264ULL, 0x0000001067677824ULL, 0x000fe200078e023cULL,
0x000000043d3d7984ULL, 0x004e640008004800ULL, 0x0000003d083f7224ULL, 0x002fc800078e023fULL,
0x00005e003f3e7625ULL, 0x000fcc00078e0032ULL, 0x00000010333e7825ULL, 0x000fca00078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e657faeULL, 0x0003e8000b901c50ULL,
0x01869006313d7984ULL, 0x000ea20008004800ULL, 0x00000028313e7810ULL, 0x002fca0007ffe0ffULL,
0x000000013e3f7824ULL, 0x040fe400078e0230ULL, 0x000000013e5e7824ULL, 0x040fe400078e0203ULL,
0x000000083e657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fe400078ee25eULL,
0x0000002c315e7810ULL, 0x000fc60007ffe0ffULL, 0x0000001065657824ULL, 0x000fe400078e023cULL,
0x000000015e647824ULL, 0x000fe200078e0203ULL, 0x000000043d3d7984ULL, 0x004e640008004800ULL,
0x0000003d08637224ULL, 0x002fc800078e0263ULL, 0x00005e0063627625ULL, 0x000fcc00078e0032ULL,
0x0000001033627825ULL, 0x000fca00078e0062ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062677faeULL, 0x0003e8000b901c50ULL, 0x0186a006313d7984ULL, 0x000ea20008004800ULL,
0x000000015e637824ULL, 0x042fe400078e0230ULL, 0x000000085e677824ULL, 0x000fca00078e00ffULL,
0xfffffff867677812ULL, 0x000fca00078ee264ULL, 0x0000001067677824ULL, 0x000fe200078e023cULL,
0x000000043d3d7984ULL, 0x004e640008004800ULL, 0x0000003d083f7224ULL, 0x002fc800078e023fULL,
0x00005e003f3e7625ULL, 0x000fcc00078e0032ULL, 0x00000010333e7825ULL, 0x000fca00078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e657faeULL, 0x0003e8000b901c50ULL,
0x0186b006313d7984ULL, 0x000ea20008004800ULL, 0x00000030313e7810ULL, 0x002fca0007ffe0ffULL,
0x000000013e3f7824ULL, 0x040fe400078e0230ULL, 0x000000013e5e7824ULL, 0x040fe400078e0203ULL,
0x000000083e657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fe400078ee25eULL,
0x00000034315e7810ULL, 0x000fc60007ffe0ffULL, 0x0000001065657824ULL, 0x000fe400078e023cULL,
0x000000015e647824ULL, 0x000fe200078e0203ULL, 0x000000043d3d7984ULL, 0x004e640008004800ULL,
0x0000003d08637224ULL, 0x002fc800078e0263ULL, 0x00005e0063627625ULL, 0x000fcc00078e0032ULL,
0x0000001033627825ULL, 0x000fca00078e0062ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062677faeULL, 0x0003e8000b901c50ULL, 0x0186c006313d7984ULL, 0x000ea20008004800ULL,
0x000000015e637824ULL, 0x042fe400078e0230ULL, 0x000000085e677824ULL, 0x000fca00078e00ffULL,
0xfffffff867677812ULL, 0x000fca00078ee264ULL, 0x0000001067677824ULL, 0x000fe200078e023cULL,
0x000000043d3d7984ULL, 0x004e640008004800ULL, 0x0000003d083f7224ULL, 0x002fc800078e023fULL,
0x00005e003f3e7625ULL, 0x000fcc00078e0032ULL, 0x00000010333e7825ULL, 0x000fca00078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e657faeULL, 0x0003e8000b901c50ULL,
0x0186d006313d7984ULL, 0x000ea20008004800ULL, 0x00000038313e7810ULL, 0x002fca0007ffe0ffULL,
0x000000013e3f7824ULL, 0x040fe400078e0230ULL, 0x000000013e5e7824ULL, 0x040fe400078e0203ULL,
0x000000083e657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fe400078ee25eULL,
0x0000003c315e7810ULL, 0x000fc60007ffe0ffULL, 0x0000001065657824ULL, 0x000fe200078e023cULL,
0x000000043d3d7984ULL, 0x004e640008004800ULL, 0x0000003d08637224ULL, 0x002fc800078e0263ULL,
0x00005e0063627625ULL, 0x000fcc00078e0032ULL, 0x0000001033627825ULL, 0x000fca00078e0062ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062677faeULL, 0x0003e8000b901c50ULL,
0x0186e006313d7984ULL, 0x000ea20008004800ULL, 0x000000015e637824ULL, 0x042fe400078e0230ULL,
0x000000015e307824ULL, 0x040fe400078e0203ULL, 0x000000085e677824ULL, 0x000fca00078e00ffULL,
0xfffffff867677812ULL, 0x000fca00078ee230ULL, 0x0000001067677824ULL, 0x000fe200078e023cULL,
0x000000043d3d7984ULL, 0x004e640008004800ULL, 0x0000003d083f7224ULL, 0x002fc800078e023fULL,
0x00005e003f3e7625ULL, 0x000fcc00078e0032ULL, 0x00000010333e7825ULL, 0x000fca00078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e657faeULL, 0x0003e8000b901c50ULL,
0x0186f006313d7984ULL, 0x000ea80008004800ULL, 0x000000043d3d7984ULL, 0x004ea40008004800ULL,
0x0000003d08637224ULL, 0x004fc800078e0263ULL, 0x00005e0063627625ULL, 0x000fcc00078e0032ULL,
0x0000001033627825ULL, 0x000fca00078e0062ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062677faeULL, 0x0003e4000b901c50ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x00024c2000307802ULL, 0x000fc40000000f00ULL, 0x0000577000007944ULL, 0x002fea0003c00000ULL,
0x000000ff5c00720cULL, 0x000fe20003f05270ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000031000007945ULL, 0x000fec0003800000ULL, 0x000002f000008947ULL, 0x000fea0003800000ULL,
0x0000000112307810ULL, 0x000fe20007ffe0ffULL, 0x0000028000017945ULL, 0x000fe20003800000ULL,
0x000000173400720cULL, 0x000fe40003f04070ULL, 0x00000002ff317819ULL, 0x000fc40000011630ULL,
0x0000000330307812ULL, 0x000fe400078ec0ffULL, 0x0000000131327807ULL, 0x000fe40004000000ULL,
0x000000ff30307207ULL, 0x000fe40004000000ULL, 0x00000020033d7810ULL, 0x002fe20007ffe0ffULL,
0x0000000117327824ULL, 0x000fe200078e0232ULL, 0x000000173400720cULL, 0x000fe40003f04070ULL,
0x000000031200780cULL, 0x000fc40003f85270ULL, 0x0000000532327c11ULL, 0x000fe4000f8e40ffULL,
0x0000000a30317c10ULL, 0x000fe4000fffe0ffULL, 0x0000000603637c11ULL, 0x000fe2000f8e10ffULL,
0x000000013d337824ULL, 0x100fe400078e0232ULL, 0x0000000132177824ULL, 0x100fe400078e0203ULL,
0x0000680031327a24ULL, 0x000fe200078e0232ULL, 0x000000603300720cULL, 0x080fe20003f66070ULL,
0x00000004ff337424ULL, 0x000fe200078e00ffULL, 0x000000601700720cULL, 0x000fe20003f26070ULL,
0x0000000132307824ULL, 0x000fc400078e0203ULL, 0x000000013d327824ULL, 0x000fe400078e0232ULL,
0x0000660030307625ULL, 0x000fc800078e0033ULL, 0x0000660032327625ULL, 0x000fe200078e0033ULL,
0x0000010000008947ULL, 0x000fea0002000000ULL, 0x000000030300780cULL, 0x000fe40003f04070ULL,
0x0000000200007810ULL, 0x000fd60007ffe0ffULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x0000000000127919ULL, 0x000e620000002700ULL, 0x000000370000720cULL, 0x000fe20003f06070ULL,
0x00000004ff3c7424ULL, 0x000fe400078e00ffULL, 0x0000000412127824ULL, 0x002fc800078e0203ULL,
0x0000000212177824ULL, 0x000fe400078e00ffULL, 0x0000000402127824ULL, 0x000fe400078e0203ULL,
0x0000640017177a24ULL, 0x000fc600078e0200ULL, 0x00018a80123f7811ULL, 0x000fe200078e10ffULL,
0x00006000173c7625ULL, 0x000fca00078e003cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c3f7faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1860000030637faeULL, 0x0005e8000c921850ULL,
0x1868000032637faeULL, 0x0005e4000d921850ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff177224ULL, 0x000fc600078e00ffULL,
0xfffffff803127812ULL, 0x000fe200078ec0ffULL, 0x00000002026d7824ULL, 0x020fe200078e0211ULL,
0x0000000117717810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000712127812ULL, 0x000fe400078ef803ULL, 0x000020006d6d7811ULL, 0x000fc400078e68ffULL,
0x0000002003627810ULL, 0x002fe20007ffe0ffULL, 0x0000000112307824ULL, 0x044fe400078e0217ULL,
0x0000000812317824ULL, 0x000fe200078e00ffULL, 0xfffffff862627812ULL, 0x000fe200078ec0ffULL,
0x0000000112127824ULL, 0x000fc600078e0271ULL, 0xfffffff831307812ULL, 0x040fe400078ee230ULL,
0xfffffff831127812ULL, 0x000fe400078ee212ULL, 0x00000007626e7812ULL, 0x000fe200078ef803ULL,
0x00000010303c7824ULL, 0x100fe400078e026dULL, 0x0000001012127824ULL, 0x000fe400078e026dULL,
0x000000016e627824ULL, 0x040fe400078e0217ULL, 0x000000003c3c783bULL, 0x000e620000000200ULL,
0x000000086e657824ULL, 0x000fc400078e00ffULL, 0x000000016e717824ULL, 0x000fe200078e0271ULL,
0x000000001230783bULL, 0x000ea40000000200ULL, 0xfffffff865627812ULL, 0x000fca00078ee262ULL,
0x0000001062647824ULL, 0x000fcc00078e026dULL, 0x000000006464783bULL, 0x000ee20000000200ULL,
0x00000018ff687819ULL, 0x002fe2000001143dULL, 0x0000003d00f47306ULL, 0x000fe20000009400ULL,
0x00000018ff637819ULL, 0x000fe4000001143cULL, 0x00000018ff707819ULL, 0x004fe40000011432ULL,
0x00000018ff6f7819ULL, 0x000fe40000011431ULL, 0x00000018ff6b7819ULL, 0x000fe20000011430ULL,
0x0000006800867306ULL, 0x000fe20000209400ULL, 0x00000018ff697819ULL, 0x000fc4000001143eULL,
0x00000018ff6a7819ULL, 0x000fe4000001143fULL, 0x00000018ff727819ULL, 0x000fc60000011433ULL,
0x0000006800e17306ULL, 0x000ff00000205400ULL, 0x0000006800b07306ULL, 0x000ff0000020d400ULL,
0x00000070009f7306ULL, 0x000ff00000209400ULL, 0x00000070009a7306ULL, 0x000ff00000205400ULL,
0x0000007000687306ULL, 0x0003f0000020d400ULL, 0x0000003d00a17306ULL, 0x000ea20000005400ULL,
0x000100003d707824ULL, 0x002fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000003d00b27306ULL, 0x000330000000d400ULL, 0x00000063008e7306ULL, 0x000fe20000209400ULL,
0x000001003d3d7824ULL, 0x002fe200078e00ffULL, 0x000000a1f400720bULL, 0x004fc80003fdd000ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000006300f17306ULL, 0x000e6e0000205400ULL,
0x00000001b2b26812ULL, 0x010fe200078efcffULL, 0x0000006300917306ULL, 0x000eb0000020d400ULL,
0x0000006f00b47306ULL, 0x000fe20000209400ULL, 0x000000f18e00720bULL, 0x002fce0003f9d000ULL,
0x0000006f00b57306ULL, 0x000fec0000205400ULL, 0x0000000191914812ULL, 0x004fe400078efcffULL,
0x0000006f00637306ULL, 0x0003f0000020d400ULL, 0x0000003c00f77306ULL, 0x000fe20000009400ULL,
0x000100003c6f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x0000003c00f67306ULL, 0x000e700000005400ULL, 0x0000003c00907306ULL, 0x000530000000d400ULL,
0x0000003d00e27306ULL, 0x000fe20000209400ULL, 0x000001003c3c7824ULL, 0x004fe200078e00ffULL,
0x000000f6f700720bULL, 0x002fc80003f3d000ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000003d00e37306ULL, 0x000fee0000205400ULL, 0x0000000190901812ULL, 0x010fe200078efcffULL,
0x0000003d00b97306ULL, 0x0007f0000020d400ULL, 0x0000003000c57306ULL, 0x000fe20000009400ULL,
0x00000018ff3d7819ULL, 0x008fce0000011464ULL, 0x0000003d00d77306ULL, 0x000ff00000209400ULL,
0x0000003d00d47306ULL, 0x000ff00000205400ULL, 0x0000003d00937306ULL, 0x0003f0000020d400ULL,
0x0000003000ba7306ULL, 0x000fe20000005400ULL, 0x00010000303d7824ULL, 0x002fce00078e00ffULL,
0x00000030006c7306ULL, 0x0003f0000000d400ULL, 0x0000006f00ad7306ULL, 0x000fe20000209400ULL,
0x0000010030307824ULL, 0x002fce00078e00ffULL, 0x0000006f00aa7306ULL, 0x000e700000205400ULL,
0x0000006f00c77306ULL, 0x0004f0000020d400ULL, 0x0000003c00f57306ULL, 0x000fe20000209400ULL,
0x000100003e6f7824ULL, 0x004fe200078e00ffULL, 0x000000aaad00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000003c009c7306ULL, 0x000e6e0000205400ULL,
0x00000001c7c75812ULL, 0x008fe200078efcffULL, 0x0000003c00b87306ULL, 0x0004e6000020d400ULL,
0x00000090c790723eULL, 0x000fca00000010ffULL, 0x0000003e00e87306ULL, 0x000fe20000009400ULL,
0x000100003f3c7824ULL, 0x004fe200078e00ffULL, 0x0000009cf500720bULL, 0x002fc80003f1d000ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003e008f7306ULL, 0x000e6e0000005400ULL,
0x00000001b8b80812ULL, 0x008fe200078efcffULL, 0x0000003e00ac7306ULL, 0x0004e2000000d400ULL,
0x000000e18600720bULL, 0x000fc40003f1d000ULL, 0x000000b89191723eULL, 0x000fca00000010ffULL,
0x0000003f00e77306ULL, 0x000fe20000009400ULL, 0x000001003e3e7824ULL, 0x004fe200078e00ffULL,
0x0000008fe800720bULL, 0x002fc80003fbd000ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000003f00e67306ULL, 0x000e620000005400ULL, 0x00000001b0b00812ULL, 0x000fcc00078efcffULL,
0x00000001acac5812ULL, 0x008fe200078efcffULL, 0x0000003f00a47306ULL, 0x0004f0000000d400ULL,
0x0000007000f27306ULL, 0x000fe20000209400ULL, 0x000001003f3f7824ULL, 0x004fe200078e00ffULL,
0x000000e6e700720bULL, 0x002fc80003f3d000ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000007000f37306ULL, 0x000e6e0000205400ULL, 0x00000001a4a41812ULL, 0x008fe200078efcffULL,
0x0000007000bb7306ULL, 0x0004e2000020d400ULL, 0x000000d4d700720bULL, 0x000fce0003f3d000ULL,
0x0000003e00e47306ULL, 0x000fe20000209400ULL, 0x00000018ff707819ULL, 0x004fe20000011430ULL,
0x000000086e307824ULL, 0x000fe200078e00ffULL, 0x000000f3f200720bULL, 0x002fe20003f7d000ULL,
0x00010000316e7824ULL, 0x000fe400078e00ffULL, 0x0000000193931812ULL, 0x000fe400078efcffULL,
0xfffffff830307812ULL, 0x000fe200078ee271ULL, 0x0000003e00e57306ULL, 0x000e620000205400ULL,
0x0001000032717824ULL, 0x000fc600078e00ffULL, 0x0000001030307824ULL, 0x000fc600078e026dULL,
0x00000001bbbb3812ULL, 0x008fe200078efcffULL, 0x0000003e00b17306ULL, 0x0004e2000020d400ULL,
0x000000e3e200720bULL, 0x000fce0003f7d000ULL, 0x0000003c00de7306ULL, 0x000fe20000209400ULL,
0x00000018ff3e7819ULL, 0x004fe40000011465ULL, 0x000000e5e400720bULL, 0x002fe40003f1d000ULL,
0x0000000703e47812ULL, 0x000fe400078ec0ffULL, 0x00000001b9b93812ULL, 0x000fe200078efcffULL,
0x0000003c00a37306ULL, 0x000fe20000205400ULL, 0x00000008e4e47812ULL, 0x000fce00078ef803ULL,
0x0000003c00ab7306ULL, 0x0003e2000020d400ULL, 0x00000001b1b10812ULL, 0x008fce00078efcffULL,
0x0000003f00da7306ULL, 0x000fe20000209400ULL, 0x00000018ff3c7819ULL, 0x002fce0000011466ULL,
0x0000003f00df7306ULL, 0x000e700000205400ULL, 0x0000003f00a97306ULL, 0x0004f0000020d400ULL,
0x0000006f00dc7306ULL, 0x000fe20000209400ULL, 0x00000018ff3f7819ULL, 0x004fc40000011467ULL,
0x000000dfda00720bULL, 0x002fca0003fbd000ULL, 0x0000006f00dd7306ULL, 0x000e700000205400ULL,
0x0000006f00b37306ULL, 0x000522000020d400ULL, 0x00000001a9a95812ULL, 0x008fce00078efcffULL,
0x0000003e00d27306ULL, 0x000fe20000209400ULL, 0x00000018ff6f7819ULL, 0x004fe4000001143dULL,
0x000000dddc00720bULL, 0x002fe20003fdd000ULL, 0x000000080edc7824ULL, 0x000fe200078e0217ULL,
0x0000000217177810ULL, 0x000fc60007ffe0ffULL, 0x0000003e00d57306ULL, 0x000fe20000205400ULL,
0x00000002dcdc7824ULL, 0x000fca00078e00ffULL, 0x000000dc03e17211ULL, 0x000fe400078fe0ffULL,
0x0000003e00887306ULL, 0x000fe2000020d400ULL, 0x00000001b3b36812ULL, 0x010fe400078efcffULL,
0x000000a3de00720bULL, 0x000fe20003fdd000ULL, 0x00000001e4e17824ULL, 0x000fe200078e02e1ULL,
0x00000002dcdc7810ULL, 0x000fe20007ffe0ffULL, 0x00000020e4de7824ULL, 0x000fe400078e00ffULL,
0x0000003c00cb7306ULL, 0x000fe20000209400ULL, 0x000000dc03dc7211ULL, 0x000fc400078fe0ffULL,
0xffffffe0dee17812ULL, 0x000fc600078ee2e1ULL, 0x00000001e4dc7824ULL, 0x000fe400078e02dcULL,
0x0000003c00c67306ULL, 0x000fe20000205400ULL, 0x00000001abab6812ULL, 0x000fce00078efcffULL,
0x0000003c00847306ULL, 0x000ff0000020d400ULL, 0x0000003f00ca7306ULL, 0x000ff00000209400ULL,
0x0000003f00cf7306ULL, 0x000ff00000205400ULL, 0x0000003f007c7306ULL, 0x0003f0000020d400ULL,
0x0000003100c27306ULL, 0x000fe20000009400ULL, 0x00000000303c783bULL, 0x0022ae0000000200ULL,
0x0000003100bd7306ULL, 0x000fe20000005400ULL, 0x00000018ff307819ULL, 0x002fce0000011471ULL,
0x00000031005c7306ULL, 0x0003f0000000d400ULL, 0x0000003200c07306ULL, 0x000fe20000009400ULL,
0x0000010031317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003200c37306ULL, 0x000ff00000005400ULL, 0x0000003200127306ULL, 0x0003e2000000d400ULL,
0x00000018ff7a7819ULL, 0x004fc4000001143cULL, 0x00000018ff7e7819ULL, 0x000fe4000001143eULL,
0x00000018ff7d7819ULL, 0x000fc6000001143dULL, 0x0000003000ae7306ULL, 0x000fe20000209400ULL,
0x0000010032327824ULL, 0x002fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000003000af7306ULL, 0x000ff00000205400ULL, 0x0000003000717306ULL, 0x0003f0000020d400ULL,
0x0000006900e07306ULL, 0x000fe20000209400ULL, 0x0001000033307824ULL, 0x002fce00078e00ffULL,
0x0000006900897306ULL, 0x000e700000205400ULL, 0x0000006900a87306ULL, 0x000eb0000020d400ULL,
0x0000006a008b7306ULL, 0x000fe20000209400ULL, 0x00000089e000720bULL, 0x002fe20003f9d000ULL,
0x0000010067e07824ULL, 0x000fca00078e00ffULL, 0x00000018ffe27819ULL, 0x000fe200000114e0ULL,
0x0000006a009e7306ULL, 0x000e6c0000205400ULL, 0x00000001a8a84812ULL, 0x004fe400078efcffULL,
0x0000006a00a27306ULL, 0x000eb0000020d400ULL, 0x0000006b00c17306ULL, 0x000fe20000209400ULL,
0x0000009e8b00720bULL, 0x002fe20003f7d000ULL, 0x000100003c9e7824ULL, 0x000fca00078e00ffULL,
0x00000018ffe37819ULL, 0x000fe2000001149eULL, 0x0000006b00bc7306ULL, 0x000fec0000205400ULL,
0x00000001a2a23812ULL, 0x004fe400078efcffULL, 0x0000006b00627306ULL, 0x000ff0000020d400ULL,
0x0000007200697306ULL, 0x000ff00000209400ULL, 0x00000072006a7306ULL, 0x000ff00000205400ULL,
0x00000072006b7306ULL, 0x0003f0000020d400ULL, 0x0000003100b67306ULL, 0x000fe20000209400ULL,
0x00000018ff727819ULL, 0x002fce000001146eULL, 0x0000003100b77306ULL, 0x000ff00000205400ULL,
0x00000031006e7306ULL, 0x0003f0000020d400ULL, 0x0000003300be7306ULL, 0x000fe20000009400ULL,
0x00000018ff317819ULL, 0x002fe20000011430ULL, 0x0001000064307824ULL, 0x000fca00078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe20000011430ULL, 0x0000003300bf7306ULL, 0x000fe20000005400ULL,
0x0001000065307824ULL, 0x000fce00078e00ffULL, 0x00000033005e7306ULL, 0x0003f0000000d400ULL,
0x0000003200a67306ULL, 0x000fe20000209400ULL, 0x0000010033337824ULL, 0x002fca00078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe40000011433ULL, 0x0000003200a77306ULL, 0x000ff00000205400ULL,
0x0000003200737306ULL, 0x0003f0000020d400ULL, 0x0000007000d17306ULL, 0x000fe20000209400ULL,
0x00000018ff327819ULL, 0x002fce000001143fULL, 0x0000007000cc7306ULL, 0x000ff00000205400ULL,
0x00000070006d7306ULL, 0x000ff0000020d400ULL, 0x0000007a00947306ULL, 0x000ff00000209400ULL,
0x0000007a00977306ULL, 0x000ff00000205400ULL, 0x0000007a00707306ULL, 0x000ff0000020d400ULL,
0x0000003200797306ULL, 0x000ff00000209400ULL, 0x00000032007a7306ULL, 0x000ff00000205400ULL,
0x00000032007b7306ULL, 0x000ff0000020d400ULL, 0x0000008c00327306ULL, 0x000ff00000209400ULL,
0x0000008c00337306ULL, 0x000e700000205400ULL, 0x0000006400857306ULL, 0x000ff00000009400ULL,
0x0000006400d07306ULL, 0x000ea20000005400ULL, 0x000000333200720bULL, 0x002fce0003f9d000ULL,
0x0000006400927306ULL, 0x0002f0000000d400ULL, 0x0000007e00767306ULL, 0x000fe20000209400ULL,
0x0000010064647824ULL, 0x002fe200078e00ffULL, 0x000000d08500720bULL, 0x004fc80003f1d000ULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x0000007e00777306ULL, 0x000fee0000205400ULL,
0x0000000192920812ULL, 0x008fe200078efcffULL, 0x0000007e00787306ULL, 0x000fe2000020d400ULL,
0x000000d5d200720bULL, 0x000fe20003f1d000ULL, 0x00000020e4d57824ULL, 0x000fca00078e00ffULL,
0xffffffe0d5dc7812ULL, 0x000fe200078ee2dcULL, 0x0000008d007e7306ULL, 0x000fec0000209400ULL,
0x0000000188880812ULL, 0x000fe400078efcffULL, 0x0000008d007f7306ULL, 0x000ff00000205400ULL,
0x0000008d00807306ULL, 0x0003f0000020d400ULL, 0x0000006f00c87306ULL, 0x000fe20000209400ULL,
0x00000018ff8d7819ULL, 0x002fce0000011430ULL, 0x0000006f00cd7306ULL, 0x000ff00000205400ULL,
0x0000006f00817306ULL, 0x000ff0000020d400ULL, 0x0000007200c97306ULL, 0x000ff00000209400ULL,
0x0000007200c47306ULL, 0x000ff00000205400ULL, 0x00000072006f7306ULL, 0x000ff0000020d400ULL,
0x0000007d00727306ULL, 0x000ff00000209400ULL, 0x0000007d00757306ULL, 0x000ff00000205400ULL,
0x0000007d00747306ULL, 0x000ff0000020d400ULL, 0x0000008c00a57306ULL, 0x0002b0000020d400ULL,
0x0000003100827306ULL, 0x000fe20000209400ULL, 0x00010000668c7824ULL, 0x002fce00078e00ffULL,
0x0000003100837306ULL, 0x000fe20000205400ULL, 0x00000001a5a54812ULL, 0x004fc800078efcffULL,
0x00000092a592723eULL, 0x000fc600000010ffULL, 0x00000031007d7306ULL, 0x000ff0000020d400ULL,
0x0000008d00307306ULL, 0x000ff00000209400ULL, 0x0000008d00317306ULL, 0x000e700000205400ULL,
0x0000006400e97306ULL, 0x000ff00000209400ULL, 0x0000006400ea7306ULL, 0x000ea20000205400ULL,
0x000000313000720bULL, 0x002fe20003f9d000ULL, 0x00000010e1307824ULL, 0x000fc400078e00ffULL,
0x000100003d317824ULL, 0x000fc800078e00ffULL, 0x0000006400a07306ULL, 0x0003f0000020d400ULL,
0x0000008d009d7306ULL, 0x000ee2000020d400ULL, 0x00000018ff647819ULL, 0x002fe2000001148cULL,
0x00000100668c7824ULL, 0x000fe200078e00ffULL, 0x000000eae900720bULL, 0x004fc80003fdd000ULL,
0x00000018fff87819ULL, 0x000fe2000001148cULL, 0x0000006600ce7306ULL, 0x000ff00000009400ULL,
0x0000006600877306ULL, 0x000e620000005400ULL, 0x000000019d9d4812ULL, 0x008fc400078efcffULL,
0x00000001a0a06812ULL, 0x000fc800078efcffULL, 0x000000a09393723eULL, 0x000fe200000010ffULL,
0x000000f800ef7306ULL, 0x000ff00000209400ULL, 0x000000f800f07306ULL, 0x000ea20000205400ULL,
0x00000087ce00720bULL, 0x002fc40003f7d000ULL, 0x00000018ffce7819ULL, 0x000fe40000011431ULL,
0x000000003030783bULL, 0x000e660000000200ULL, 0x0000006700d87306ULL, 0x000ff00000009400ULL,
0x0000006700db7306ULL, 0x000ee20000005400ULL, 0x000000f0ef00720bULL, 0x004fce0003f9d000ULL,
0x0000006600967306ULL, 0x000eb0000000d400ULL, 0x000000f800957306ULL, 0x000f22000020d400ULL,
0x000000dbd800720bULL, 0x008fce0003f1d000ULL, 0x0000006400ed7306ULL, 0x000fe20000209400ULL,
0x0000000196963812ULL, 0x004fe400078efcffULL, 0x000000bac500720bULL, 0x000fe20003f7d000ULL,
0x000000903058723cULL, 0x002b680000041858ULL, 0x0000006400ee7306ULL, 0x000e620000205400ULL,
0x0000000195954812ULL, 0x010fe400078efcffULL, 0x000000cfca00720bULL, 0x000fc40003f9d000ULL,
0x000000acb390723eULL, 0x020fe200000010ffULL, 0x000000923048723cULL, 0x040fe20000041848ULL,
0x000000b1a891723eULL, 0x000fe200000010ffULL, 0x0000006500987306ULL, 0x000fe20000009400ULL,
0x000000016c6c3812ULL, 0x000fe200078efcffULL, 0x000001003eac7824ULL, 0x000fe200078e00ffULL,
0x000000b5b400720bULL, 0x000fe20003f7d000ULL, 0x000100003fb17824ULL, 0x000fe400078e00ffULL,
0x000000903050723cULL, 0x000be20000041850ULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x0000006500d37306ULL, 0x000ea20000005400ULL, 0x000000eeed00720bULL, 0x002fc40003f3d000ULL,
0x000000017c7c4812ULL, 0x000fe400078efcffULL, 0x000000bcc100720bULL, 0x000fe40003f9d000ULL,
0x00000018ffb17819ULL, 0x000fe200000114b1ULL, 0x00000065008a7306ULL, 0x0002e2000000d400ULL,
0x0000000163633812ULL, 0x000fe400078efcffULL, 0x000000a7a600720bULL, 0x000fca0003f7d000ULL,
0x00000067008d7306ULL, 0x000f22000000d400ULL, 0x0000010065657824ULL, 0x002fe200078e00ffULL,
0x000000d39800720bULL, 0x004fe40003fbd000ULL, 0x0000000162624812ULL, 0x000fe400078efcffULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x00000064009b7306ULL, 0x000e62000020d400ULL,
0x000000b7b600720bULL, 0x000fe40003f9d000ULL, 0x0000000173733812ULL, 0x000fc400078efcffULL,
0x000000979400720bULL, 0x000fe40003f7d000ULL, 0x000000018a8a5812ULL, 0x008fe200078efcffULL,
0x0000006500eb7306ULL, 0x000fe20000209400ULL, 0x000000018d8d0812ULL, 0x010fe400078efcffULL,
0x000000ccd100720bULL, 0x000fe40003f1d000ULL, 0x000000c6cb00720bULL, 0x000fe40003fbd000ULL,
0x000000016e6e4812ULL, 0x000fe200078efcffULL, 0x0000006500ec7306ULL, 0x000ea20000205400ULL,
0x000000019b9b1812ULL, 0x002fc400078efcffULL, 0x0000000170703812ULL, 0x000fe400078efcffULL,
0x000000838200720bULL, 0x000fe40003f7d000ULL, 0x0000008a9d90723eULL, 0x020fe200000010ffULL,
0x000000e200e07306ULL, 0x000fe20000209400ULL, 0x000000016d6d0812ULL, 0x000fe400078efcffULL,
0x000000c4c900720bULL, 0x000fe40003f1d000ULL, 0x0000000184845812ULL, 0x000fc400078efcffULL,
0x000000cdc800720bULL, 0x000fe20003fbd000ULL, 0x000000e200dd7306ULL, 0x000e620000205400ULL,
0x000000eceb00720bULL, 0x004fe40003fdd000ULL, 0x000000969b92723eULL, 0x000fe400000010ffULL,
0x000000958493723eULL, 0x000fe400000010ffULL, 0x000000017d7d3812ULL, 0x000fe200078efcffULL,
0x0000006500997306ULL, 0x0004e2000020d400ULL, 0x000000016f6f0812ULL, 0x000fc400078efcffULL,
0x000000afae00720bULL, 0x000fe20003f1d000ULL, 0x000000923040723cULL, 0x000fe20000041840ULL,
0x0000000181815812ULL, 0x000fe400078efcffULL, 0x000000bfbe00720bULL, 0x000fe20003fbd000ULL,
0x000000e2008b7306ULL, 0x000f22000020d400ULL, 0x0001000067657824ULL, 0x004fe200078e00ffULL,
0x000000dde000720bULL, 0x002fe40003f3d000ULL, 0x0000006d626d723eULL, 0x000fe400000010ffULL,
0x00000018ff657819ULL, 0x000fc40000011465ULL, 0x0000003c00aa7306ULL, 0x000fe20000009400ULL,
0x0000000199996812ULL, 0x008fe400078efcffULL, 0x0000000171710812ULL, 0x000fe400078efcffULL,
0x000000998891723eULL, 0x000fe400000010ffULL, 0x000000015e5e5812ULL, 0x000fe200078efcffULL,
0x0000006500d67306ULL, 0x000fe20000209400ULL, 0x000000018b8b1812ULL, 0x010fe400078efcffULL,
0x000000c3c000720bULL, 0x000fe20003f3d000ULL, 0x000000903044723cULL, 0x000fe20000041844ULL,
0x0000008b7c8b723eULL, 0x000fc400000010ffULL, 0x000000757200720bULL, 0x000fe20003fbd000ULL,
0x0000006500d97306ULL, 0x000e620000205400ULL, 0x0000006c816c723eULL, 0x000fe400000010ffULL,
0x0000006e6363723eULL, 0x000fca00000010ffULL, 0x00000065008c7306ULL, 0x000ea2000020d400ULL,
0x0000000112121812ULL, 0x000fc600078efcffULL, 0x0000000174745812ULL, 0x000fe400078efcffULL,
0x000000127172723eULL, 0x000fe400000010ffULL, 0x0000003c00ad7306ULL, 0x000ee20000005400ULL,
0x000000d9d600720bULL, 0x002fce0003fdd000ULL, 0x0000003d009c7306ULL, 0x000fec0000009400ULL,
0x000000018c8c6812ULL, 0x004fe400078efcffULL, 0x0000003d00a17306ULL, 0x000e620000005400ULL,
0x000000bdc200720bULL, 0x000fe40003fdd000ULL, 0x000000adaa00720bULL, 0x008fc40003f9d000ULL,
0x0000008d8c8a723eULL, 0x000fc600000010ffULL, 0x0000003c00647306ULL, 0x0004e8000000d400ULL,
0x0000008a3038723cULL, 0x000fe40000041838ULL, 0x000000015c5c6812ULL, 0x000fe400078efcffULL,
0x0000003d00657306ULL, 0x0008e2000000d400ULL, 0x000001003c3c7824ULL, 0x004fe200078e00ffULL,
0x000000a19c00720bULL, 0x002fc40003f3d000ULL, 0x0000009a9f00720bULL, 0x000fe40003fdd000ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x000000e3009e7306ULL, 0x000fe20000209400ULL,
0x000001003d3d7824ULL, 0x010fe200078e00ffULL, 0x0000000164644812ULL, 0x008fe400078efcffULL,
0x0000005c6f62723eULL, 0x000fe400000010ffULL, 0x00000018ffc27819ULL, 0x000fc4000001143dULL,
0x000000e300a37306ULL, 0x000e620000205400ULL, 0x000000b9b03d723eULL, 0x000fe200000010ffULL,
0x000100003eb07824ULL, 0x000fe200078e00ffULL, 0x0000000165651812ULL, 0x000fe400078efcffULL,
0x0000007f7e00720bULL, 0x000fe40003f3d000ULL, 0x00000018ffb07819ULL, 0x000fe200000114b0ULL,
0x000000ce00c67306ULL, 0x000fe20000209400ULL, 0x0000000168686812ULL, 0x000fc800078efcffULL,
0x000000736873723eULL, 0x000fc600000010ffULL, 0x000000ce00cb7306ULL, 0x000ea20000205400ULL,
0x000000a39e00720bULL, 0x002fe40003f1d000ULL, 0x0000000180801812ULL, 0x000fca00078efcffULL,
0x0000003c00987306ULL, 0x000ff00000209400ULL, 0x0000003c00d37306ULL, 0x000e620000205400ULL,
0x000000cbc600720bULL, 0x004fce0003f9d000ULL, 0x0000003c00877306ULL, 0x0005f0000020d400ULL,
0x000000e300857306ULL, 0x000ee2000020d400ULL, 0x000000b2bb3c723eULL, 0x004fe200000010ffULL,
0x000001003fb27824ULL, 0x000fe200078e00ffULL, 0x000000d39800720bULL, 0x002fc80003fdd000ULL,
0x00000018ffb27819ULL, 0x000fe200000114b2ULL, 0x0000003e008e7306ULL, 0x000fe20000009400ULL,
0x0000003c3054723cULL, 0x000b6e0000041854ULL, 0x0000003e008f7306ULL, 0x000e620000005400ULL,
0x000000a9a23d723eULL, 0x020fc400000010ffULL, 0x000000a4ab3c723eULL, 0x000fe400000010ffULL,
0x0000000185850812ULL, 0x008fe400078efcffULL, 0x0000000187876812ULL, 0x000fe200078efcffULL,
0x000000ce00ba7306ULL, 0x000ea4000020d400ULL, 0x0000003c304c723cULL, 0x000b62000004184cULL,
0x000000877087723eULL, 0x000fca00000010ffULL, 0x000000c200bd7306ULL, 0x000fe20000209400ULL,
0x0000008f8e00720bULL, 0x002fce0003f1d000ULL, 0x000000c200b47306ULL, 0x000e620000205400ULL,
0x00000001baba4812ULL, 0x004fe400078efcffULL, 0x0000006a6900720bULL, 0x000fe40003f9d000ULL,
0x0000005e7d6a723eULL, 0x000fc600000010ffULL, 0x000000b000a87306ULL, 0x000ff00000209400ULL,
0x000000b000a97306ULL, 0x000ea20000205400ULL, 0x000000b4bd00720bULL, 0x002fe40003f7d000ULL,
0x000000016b6b4812ULL, 0x000fc400078efcffULL, 0x000000777600720bULL, 0x000fe40003f9d000ULL,
0x000000806b6b723eULL, 0x000fe200000010ffULL, 0x0000003e00667306ULL, 0x0002e2000000d400ULL,
0x00000065bab4723eULL, 0x000fce00000010ffULL, 0x000000b200307306ULL, 0x020fe20000209400ULL,
0x00000010dc3e7824ULL, 0x002fe200078e00ffULL, 0x000000a9a800720bULL, 0x004fe40003f3d000ULL,
0x0000000178784812ULL, 0x000fc800078efcffULL, 0x000000b200337306ULL, 0x000e620000205400ULL,
0x0000000166660812ULL, 0x008fce00078efcffULL, 0x0000003f00867306ULL, 0x000ff00000009400ULL,
0x0000003f00897306ULL, 0x000ea20000005400ULL, 0x000000333000720bULL, 0x002fce0003f1d000ULL,
0x0000003f00677306ULL, 0x0002f0000000d400ULL, 0x000000c200b57306ULL, 0x000f22000020d400ULL,
0x000000003e3c783bULL, 0x002e620000000200ULL, 0x000000898600720bULL, 0x004fc40003fdd000ULL,
0x000000648586723eULL, 0x000fc800000010ffULL, 0x000000b0009f7306ULL, 0x000eae000020d400ULL,
0x0000000167676812ULL, 0x008fe200078efcffULL, 0x000000ac009a7306ULL, 0x000fe20000209400ULL,
0x00000001b5b53812ULL, 0x010fe400078efcffULL, 0x0000007a7900720bULL, 0x000fc40003f7d000ULL,
0x000000b574b5723eULL, 0x000fc600000010ffULL, 0x000000ac00977306ULL, 0x000ee20000205400ULL,
0x000000019f9f1812ULL, 0x004fc800078efcffULL, 0x000000669f30723eULL, 0x000fc600000010ffULL,
0x000000b1007c7306ULL, 0x000fe20000209400ULL, 0x000000017b7b3812ULL, 0x000fce00078efcffULL,
0x000000b100317306ULL, 0x000ea20000205400ULL, 0x000000979a00720bULL, 0x008fe20003fbd000ULL,
0x0000006c3c58723cULL, 0x042b6c0000041858ULL, 0x000000b200b27306ULL, 0x000e64000020d400ULL,
0x000000623c54723cULL, 0x040b6c0000041854ULL, 0x000000ac008f7306ULL, 0x000ee2000020d400ULL,
0x000000317c00720bULL, 0x004fe20003f3d000ULL, 0x000000723c50723cULL, 0x040b6c0000041850ULL,
0x000000b100127306ULL, 0x000ea2000020d400ULL, 0x00000001b2b20812ULL, 0x002fe200078efcffULL,
0x0000006a3c4c723cULL, 0x000b62000004184cULL, 0x000000081700780cULL, 0x000fc40003f05270ULL,
0x000000b27b7b723eULL, 0x000fe400000010ffULL, 0x000000018f8f5812ULL, 0x008fc600078efcffULL,
0x000000863c48723cULL, 0x000b620000041848ULL, 0x0000008f7831723eULL, 0x000fe400000010ffULL,
0x0000000112121812ULL, 0x004fca00078efcffULL, 0x000000b43c44723cULL, 0x000b620000041844ULL,
0x00000067127a723eULL, 0x000fce00000010ffULL, 0x000000303c40723cULL, 0x040b700000041840ULL,
0x0000007a3c38723cULL, 0x000b620000041838ULL, 0x0000001000008944ULL, 0x000fe20003c00000ULL,
0xffffe0f000007947ULL, 0x000fcc000383ffffULL, 0x000000021900780cULL, 0x000fe20003f06070ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0019ULL, 0x000000ffff117224ULL, 0x000fd400078e000bULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffbbb000007947ULL, 0x000fea000383ffffULL,
0x00000002ff197819ULL, 0x000fc80000011603ULL, 0x0000000a1900720cULL, 0x040fe40003f06070ULL,
0x000000010a0a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000819177810ULL, 0x040fe40007ffe0ffULL,
0x0000000a1900720cULL, 0x000fe40004706470ULL, 0x0000000c1700720cULL, 0x000fe40003f26070ULL,
0x000000093400720cULL, 0x000fc40000703070ULL, 0x0000000a1700720cULL, 0x000fc80000f21070ULL,
0x000000093400720cULL, 0x000fc80000f24470ULL, 0x0000002b3b2b7208ULL, 0x020fe40000800000ULL,
0x000000263a267208ULL, 0x000fe20000800000ULL, 0x000000ffff1b8224ULL, 0x000fe200078e0039ULL,
0x0000002d432d7208ULL, 0x000fe20000800000ULL, 0x000000ffff168224ULL, 0x000fe200078e0038ULL,
0x0000002f422f7208ULL, 0x000fe20000800000ULL, 0x000000ffff1d8224ULL, 0x000fe200078e0041ULL,
0x0000002847287208ULL, 0x000fe20000800000ULL, 0x000000ffff188224ULL, 0x000fe200078e0040ULL,
0x0000003546357208ULL, 0x000fe20000800000ULL, 0x000000ffff1f8224ULL, 0x000fe200078e0045ULL,
0x0000002a4b2a7208ULL, 0x000fe20000800000ULL, 0x000000ffff1a8224ULL, 0x000fe200078e0044ULL,
0x0000005d4a5d7208ULL, 0x000fe20000800000ULL, 0x000000ffff218224ULL, 0x000fe200078e0049ULL,
0x0000002c4f2c7208ULL, 0x000fe20000800000ULL, 0x000000ffff1c8224ULL, 0x000fe200078e0048ULL,
0x0000005f4e5f7208ULL, 0x000fe20000800000ULL, 0x000000ffff238224ULL, 0x000fe200078e004dULL,
0x0000002e532e7208ULL, 0x000fe20000800000ULL, 0x000000ffff1e8224ULL, 0x000fe200078e004cULL,
0x0000006152617208ULL, 0x000fe20000800000ULL, 0x000000ffff258224ULL, 0x000fe200078e0051ULL,
0x0000001357137208ULL, 0x000fe20000800000ULL, 0x000000ffff208224ULL, 0x000fe200078e0050ULL,
0x0000001056107208ULL, 0x000fe20000800000ULL, 0x000000ffff278224ULL, 0x000fe200078e0055ULL,
0x000000155b157208ULL, 0x000fe20000800000ULL, 0x000000ffff228224ULL, 0x000fe200078e0054ULL,
0x000000145a147208ULL, 0x000fe20000800000ULL, 0x000000ffff298224ULL, 0x000fc400078e0059ULL,
0x000000ffff248224ULL, 0x000fe200078e0058ULL, 0x0000000f0a00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffb7c000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000050e7f8cULL, 0x000e62000c80043fULL,
0x000000041b307220ULL, 0x080fe40000410000ULL, 0x0000000414317220ULL, 0x080fe40000410000ULL,
0x0000000415327220ULL, 0x080fe40000410000ULL, 0x0000000424247220ULL, 0x080fe40000410000ULL,
0x0000000429297220ULL, 0x080fe40000410000ULL, 0x0000000422227220ULL, 0x000fc40000410000ULL,
0x0000000427277220ULL, 0x080fe40000410000ULL, 0x0000000420207220ULL, 0x080fe40000410000ULL,
0x0000000425257220ULL, 0x080fe40000410000ULL, 0x000000041e1e7220ULL, 0x080fe40000410000ULL,
0x0000000423237220ULL, 0x080fe40000410000ULL, 0x000000041c0a7220ULL, 0x000fc40000410000ULL,
0x000000ffff3d7224ULL, 0x002fe400078e000fULL, 0x000000041a0c7220ULL, 0x080fe40000410000ULL,
0x000000041f0e7220ULL, 0x080fe40000410000ULL, 0x00000004180f7220ULL, 0x080fe40000410000ULL,
0x000000041d117220ULL, 0x080fe40000410000ULL, 0x0000000416127220ULL, 0x000fc40000410000ULL,
0x0000000410107220ULL, 0x080fe40000410000ULL, 0x0000000413137220ULL, 0x080fe40000410000ULL,
0x0000000461617220ULL, 0x080fe40000410000ULL, 0x000000045f5f7220ULL, 0x080fe40000410000ULL,
0x000000042e337220ULL, 0x080fe40000410000ULL, 0x000000042f447220ULL, 0x000fc40000410000ULL,
0x000000042d457220ULL, 0x080fe40000410000ULL, 0x000000042c387220ULL, 0x080fe40000410000ULL,
0x000000042a3a7220ULL, 0x080fe40000410000ULL, 0x00000004353b7220ULL, 0x080fe40000410000ULL,
0x0000000428407220ULL, 0x080fe40000410000ULL, 0x0000000426467220ULL, 0x000fc40000410000ULL,
0x000000042b477220ULL, 0x080fe40000410000ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0030ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0031ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0032ULL,
0x0000000421217220ULL, 0x080fe40000410000ULL, 0x000000045d397220ULL, 0x000fc40000410000ULL,
0x000000ffff157224ULL, 0x000fe400078e0024ULL, 0x000000ffff147224ULL, 0x000fe400078e0029ULL,
0x000000ffff167224ULL, 0x000fe400078e0022ULL, 0x000000ffff187224ULL, 0x000fe400078e0027ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0020ULL, 0x000000ffff1b7224ULL, 0x000fc400078e0025ULL,
0x000000ffff1c7224ULL, 0x000fe400078e001eULL, 0x000000ffff1d7224ULL, 0x000fe400078e0023ULL,
0x000000ffff1f7224ULL, 0x000fe400078e000aULL, 0x000000ffff267224ULL, 0x000fe400078e000cULL,
0x000000ffff287224ULL, 0x000fe400078e000eULL, 0x000000ffff2a7224ULL, 0x000fc400078e000fULL,
0x000000ffff2b7224ULL, 0x000fe400078e0011ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0012ULL,
0x000000ffff307224ULL, 0x000fe400078e0010ULL, 0x000000ffff317224ULL, 0x000fe400078e0013ULL,
0x000000ffff327224ULL, 0x000fe400078e0061ULL, 0x000000ffff357224ULL, 0x000fc400078e005fULL,
0x00000000000e7805ULL, 0x000fca0000015200ULL, 0x00000400050a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fc4000780483dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x000000100e137210ULL, 0x000fca0007f1e1ffULL, 0x0000000111117824ULL, 0x000fe200000e0e0fULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc80000011411ULL, 0x000000130a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0611ULL, 0x000000020a0a7819ULL, 0x000fc80000001211ULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400050a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fe4000780483dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004030f7824ULL, 0x000fe200078e00ffULL,
0x000000060900720cULL, 0x000fc80003f05270ULL, 0xfffffff00f117812ULL, 0x000fca00078ec0ffULL,
0x00000080020a7824ULL, 0x000fca00078e0211ULL, 0x018400000a107984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002030c7824ULL, 0x000fe400078e00ffULL,
0x00000001600d7824ULL, 0x000fc600078e0a0dULL, 0x000000060c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000010c0e7812ULL, 0x040fe400078efcffULL, 0x000000080c1e7812ULL, 0x000fe400078efcffULL,
0x0000000d0e00720cULL, 0x080fe40003f26070ULL, 0x000000100c0e7812ULL, 0x000fe400078efcffULL,
0x0000000d1e00720cULL, 0x080fe40003f06070ULL, 0x0000000d0e00720cULL, 0x000fc40003fc6070ULL,
0x000000110c1e7812ULL, 0x040fe400078efcffULL, 0x000000180c0e7812ULL, 0x040fe400078efcffULL,
0x0000000d0c00720cULL, 0x080fe40003f46070ULL, 0x0000000d1e00720cULL, 0x080fe40003fa6070ULL,
0x0000000d0e00720cULL, 0x000fe40003f66070ULL, 0x000000090c207812ULL, 0x000fc400078efcffULL,
0x000000190c1e7812ULL, 0x040fe400078efcffULL, 0x000000200c0e7812ULL, 0x000fe400078efcffULL,
0xff8000002e2e7808ULL, 0x000fe40005000000ULL, 0xff80000015157808ULL, 0x000fe40005000000ULL,
0xff8000002f2f7808ULL, 0x000fe40004800000ULL, 0xff80000014147808ULL, 0x000fc40004800000ULL,
0x0000000d2000720cULL, 0x080fe40003f86070ULL, 0x0000000d1e00720cULL, 0x080fe40003f46070ULL,
0x0000000d0e00720cULL, 0x000fe40003f26070ULL, 0x000000210c1e7812ULL, 0x040fe400078efcffULL,
0x000000280c0e7812ULL, 0x000fe400078efcffULL, 0xff80000030307808ULL, 0x000fc40004000000ULL,
0xff80000016167808ULL, 0x000fe40004000000ULL, 0xff80000031317808ULL, 0x000fe40006000000ULL,
0xff80000018187808ULL, 0x000fe40006000000ULL, 0x0000000d1e00720cULL, 0x080fe40003f06070ULL,
0x0000000d0e00720cULL, 0x000fe40003f86070ULL, 0x000000290c1e7812ULL, 0x000fc400078efcffULL,
0x000000300c0e7812ULL, 0x000fe400078efcffULL, 0xff80000032327808ULL, 0x000fe40007000000ULL,
0xff8000001a1a7808ULL, 0x000fe40007000000ULL, 0xff80000033337808ULL, 0x000fe40006800000ULL,
0xff8000001b1b7808ULL, 0x000fe40006800000ULL, 0x0000000d1e00720cULL, 0x000fc40003fc6070ULL,
0x0000000d0e00720cULL, 0x000fe40003fa6070ULL, 0x000000310c1e7812ULL, 0x040fe400078efcffULL,
0x000000380c0e7812ULL, 0x040fe400078efcffULL, 0x000000390c0c7812ULL, 0x000fe400078efcffULL,
0xff80000035357808ULL, 0x000fe40005800000ULL, 0xff8000001c1c7808ULL, 0x000fc40005800000ULL,
0xff80000038387808ULL, 0x000fe40005000000ULL, 0xff8000001d1d7808ULL, 0x000fe40005000000ULL,
0xff80000039397808ULL, 0x000fe40004800000ULL, 0xff8000001f1f7808ULL, 0x000fe40004800000ULL,
0x0000000d1e00720cULL, 0x080fe40003f66070ULL, 0x0000000d0e00720cULL, 0x000fc40003f46070ULL,
0x0000000d0c00720cULL, 0x000fe40003f26070ULL, 0xff8000003a3a7808ULL, 0x000fe40004000000ULL,
0xff80000021217808ULL, 0x000fe40004000000ULL, 0xff8000003b3b7808ULL, 0x000fe40006000000ULL,
0xff80000026267808ULL, 0x000fe40006000000ULL, 0xff80000040407808ULL, 0x000fc40007000000ULL,
0xff80000028287808ULL, 0x000fe40007000000ULL, 0xff80000044447808ULL, 0x000fe40006800000ULL,
0xff8000002a2a7808ULL, 0x000fe40006800000ULL, 0xff80000045457808ULL, 0x000fe40005800000ULL,
0xff8000002b2b7808ULL, 0x000fe40005800000ULL, 0xff80000046467808ULL, 0x000fc40005000000ULL,
0xff8000002c2c7808ULL, 0x000fe40005000000ULL, 0xff80000047477808ULL, 0x000fe40004800000ULL,
0xff8000002d2d7808ULL, 0x000fc40004800000ULL, 0x000000151000720bULL, 0x004fe40003f1e000ULL,
0x0000002e1100720bULL, 0x000fe40003f3e000ULL, 0x00000010150d7208ULL, 0x000fe40004000000ULL,
0x000000112e0c7208ULL, 0x000fc40004800000ULL, 0x000000140d00720bULL, 0x000fe40003f1e000ULL,
0x0000002f0c00720bULL, 0x000fe40003f3e000ULL, 0x0000000d140d7208ULL, 0x000fe40004000000ULL,
0x0000000c2f117208ULL, 0x000fe40004800000ULL, 0x000000160d00720bULL, 0x000fe40003f1e000ULL,
0x000000301100720bULL, 0x000fc40003f3e000ULL, 0x0000000d160d7208ULL, 0x000fe40004000000ULL,
0x00000011300c7208ULL, 0x000fe40004800000ULL, 0x000000180d00720bULL, 0x000fe40003f1e000ULL,
0x000000310c00720bULL, 0x000fe40003f3e000ULL, 0x0000000d180d7208ULL, 0x000fe40004000000ULL,
0x0000000c31117208ULL, 0x000fc40004800000ULL, 0x0000001a0d00720bULL, 0x000fe40003f1e000ULL,
0x000000321100720bULL, 0x000fe40003f3e000ULL, 0x0000000d1a0c7208ULL, 0x000fe40004000000ULL,
0x00000011320e7208ULL, 0x000fe40004800000ULL, 0x0000001b0c00720bULL, 0x000fe40003f1e000ULL,
0x000000330e00720bULL, 0x000fc40003f3e000ULL, 0x0000000c1b0d7208ULL, 0x000fe40004000000ULL,
0x0000000e330e7208ULL, 0x000fe40004800000ULL, 0x0000001c0d00720bULL, 0x000fe40003f1e000ULL,
0x000000350e00720bULL, 0x000fe40003f3e000ULL, 0x0000000d1c0c7208ULL, 0x000fe40004000000ULL,
0x0000000e350d7208ULL, 0x000fc40004800000ULL, 0x0000001d0c00720bULL, 0x000fe40003f1e000ULL,
0x000000380d00720bULL, 0x000fe40003f3e000ULL, 0x0000000c1d0c7208ULL, 0x000fe40004000000ULL,
0x0000000d380e7208ULL, 0x000fe40004800000ULL, 0x0000001f0c00720bULL, 0x000fe40003f1e000ULL,
0x000000390e00720bULL, 0x000fc40003f3e000ULL, 0x0000000c1f0c7208ULL, 0x000fe40004000000ULL,
0x0000000e390d7208ULL, 0x000fe40004800000ULL, 0x000000210c00720bULL, 0x000fe40003f1e000ULL,
0x0000003a0d00720bULL, 0x000fe40003f3e000ULL, 0x0000000c21117208ULL, 0x000fe40004000000ULL,
0x0000000d3a0c7208ULL, 0x000fc40004800000ULL, 0x000000261100720bULL, 0x000fe40003f1e000ULL,
0x0000003b0c00720bULL, 0x000fe40003f3e000ULL, 0x0000001126117208ULL, 0x000fe40004000000ULL,
0x0000000c3b0d7208ULL, 0x000fe40004800000ULL, 0x000000281100720bULL, 0x000fe40003f1e000ULL,
0x000000400d00720bULL, 0x000fc40003f3e000ULL, 0x0000001128117208ULL, 0x000fe40004000000ULL,
0x0000000d400d7208ULL, 0x000fe40004800000ULL, 0x0000002a1100720bULL, 0x000fe40003f1e000ULL,
0x000000440d00720bULL, 0x000fe40003f3e000ULL, 0x000000112a0c7208ULL, 0x000fe40004000000ULL,
0x0000000d440e7208ULL, 0x000fc40004800000ULL, 0x0000002b0c00720bULL, 0x000fe40003f1e000ULL,
0x000000450e00720bULL, 0x000fe40003f3e000ULL, 0x0000000c2b0d7208ULL, 0x000fe40004000000ULL,
0x0000000e45117208ULL, 0x000fe40004800000ULL, 0x0000002c0d00720bULL, 0x000fe40003f1e000ULL,
0x000000461100720bULL, 0x000fc40003f3e000ULL, 0x0000000d2c0c7208ULL, 0x000fe40004000000ULL,
0x00000011460e7208ULL, 0x000fe40004800000ULL, 0x0000002d0c00720bULL, 0x000fe40003f1e000ULL,
0x000000470e00720bULL, 0x000fe40003f3e000ULL, 0x0000000c2d1e7208ULL, 0x000fe40004000000ULL,
0x0000000e47207208ULL, 0x000fe20004800000ULL, 0x00001d227f007947ULL, 0x000fec000b800000ULL,
0x0c401f001e0c7f89ULL, 0x0004e400000e0000ULL, 0x0000000c1e00720bULL, 0x008fc80003f1e000ULL,
0x0000001e0c227208ULL, 0x000fe20004000000ULL, 0x00001d527f007947ULL, 0x000fea000b800000ULL,
0x0c401f00200c7f89ULL, 0x000ee800000e0000ULL, 0x0c401f00120d7f89ULL, 0x000f2800000e0000ULL,
0x0c401f00130e7f89ULL, 0x000e6200000e0000ULL, 0x0000000c2000720bULL, 0x008fc40003f1e000ULL,
0x0000000d1200720bULL, 0x010fe40003f3e000ULL, 0x000000200c107208ULL, 0x000fe40004000000ULL,
0x000000120d117208ULL, 0x000fe20004800000ULL, 0x0c201f00220c7f89ULL, 0x000ee200000e0000ULL,
0x0000000e1300720bULL, 0x002fc60003f1e000ULL, 0x0c201f00100d7f89ULL, 0x000e6200000e0000ULL,
0x000000130e487208ULL, 0x000fc60004000000ULL, 0x0c201f00111e7f89ULL, 0x004ea800000e0000ULL,
0x0c201f0048497f89ULL, 0x0002a200000e0000ULL, 0x0000000c2200720bULL, 0x008fe40003f1e000ULL,
0x0000000d1000720bULL, 0x002fe40003f3e000ULL, 0x000000220c0c7208ULL, 0x000fe40004000000ULL,
0x0000001e1100720bULL, 0x004fc40003f5e000ULL, 0x000000100d0d7208ULL, 0x000fe40004800000ULL,
0x000000111e0e7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b0c117820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x3fb8aa3b0d127820ULL, 0x000fe20000410000ULL,
0xffffffff19517810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010811ULL,
0x0000000619507810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b14147823ULL, 0x000fe20000010811ULL,
0x0000000303ff7812ULL, 0x000fe2000780c0ffULL, 0x0000001500247308ULL, 0x0023e20000000800ULL,
0x3fb8aa3b30107823ULL, 0x100fe20000010812ULL, 0x000000494800720bULL, 0x004fe20003f3e000ULL,
0x3fb8aa3b31137823ULL, 0x000fc40000010812ULL, 0x3fb8aa3b16167823ULL, 0x100fe40000010811ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010811ULL, 0x0000001400297308ULL, 0x0004e20000000800ULL,
0x3fb8aa3b2f157823ULL, 0x102fe40000010812ULL, 0x00000004ff4a7e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010812ULL,
0x0001200008047891ULL, 0x000fe2000f8e583fULL, 0x3fb8aa3b1c1e7823ULL, 0x000fe20000010811ULL,
0x0000001600227308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b2e147823ULL, 0x104fe20000010812ULL,
0x3f8000004a4a783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b332e7823ULL, 0x000fc40000010812ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe40000010811ULL, 0x000000ffff4b7224ULL, 0x000fe200078e004aULL,
0x0000001800277308ULL, 0x0005e20000000800ULL, 0x000000242930723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b2c167823ULL, 0x102fe40000010811ULL, 0x3fb8aa3b382c7823ULL, 0x000fe40000010812ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe40000010811ULL, 0x0000001400147308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1d1d7823ULL, 0x000fc40000010811ULL, 0x3fb8aa3b35357823ULL, 0x100fe40000010812ULL,
0x3fb8aa3b39397823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b2a187823ULL, 0x104fe20000010811ULL,
0x0000001500157308ULL, 0x000e620000000800ULL, 0x3fb8aa3b3a2a7823ULL, 0x000fe40000010812ULL,
0x3fb8aa3b1f1c7823ULL, 0x100fe40000010811ULL, 0x3fb8aa3b281f7823ULL, 0x000fc40000010811ULL,
0x3fb8aa3b21217823ULL, 0x000fe20000010811ULL, 0x0000001000107308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b40287823ULL, 0x100fe40000010812ULL, 0x3fb8aa3b442f7823ULL, 0x000fe40000010812ULL,
0x000000ffff4c7224ULL, 0x100fe400078e004aULL, 0x000000ffff4d7224ULL, 0x000fe200078e004aULL,
0x0000001300137308ULL, 0x000ea20000000800ULL, 0x000000141531723eULL, 0x002fe200000010ffULL,
0x0000000819447824ULL, 0x000fc400078e00ffULL, 0x00000008194e7824ULL, 0x040fe400078e00ffULL,
0x00000008194f7824ULL, 0x040fe400078e00ffULL, 0x0000003200617308ULL, 0x0003e20000000800ULL,
0x000000ffff547224ULL, 0x100fe400078e004aULL, 0x000000ffff557224ULL, 0x000fe400078e004aULL,
0x0000000819537824ULL, 0x000fe200078e00ffULL, 0x000000101333723eULL, 0x004fc400000010ffULL,
0x0000001a00207308ULL, 0x0005e20000000800ULL, 0x000000222732723eULL, 0x002fe400000010ffULL,
0xfffffff853507812ULL, 0x000fca00078ee250ULL, 0x0000004a303c723cULL, 0x000f6200000418ffULL,
0x0000001b00257308ULL, 0x000e620000000800ULL, 0x3fb8aa3b261a7823ULL, 0x004fe40000010811ULL,
0x3fb8aa3b46267823ULL, 0x000fca0000010812ULL, 0x0000001e001e7308ULL, 0x000ff00000000800ULL,
0x0000001d00237308ULL, 0x0004e20000000800ULL, 0x000000202538723eULL, 0x002fce00000010ffULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b1d7823ULL, 0x104fe40000010811ULL,
0x3fb8aa3b2d117823ULL, 0x000fe40000010811ULL, 0x3fb8aa3b452d7823ULL, 0x000fc60000010812ULL,
0x00000035005f7308ULL, 0x0003e20000000800ULL, 0x0000001e233a723eULL, 0x008fce00000010ffULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b3b357823ULL, 0x102fe40000010812ULL,
0x3fb8aa3b47127823ULL, 0x000fca0000010812ULL, 0x00000039005d7308ULL, 0x0003e20000000800ULL,
0x0000005f2c3b723eULL, 0x004fce00000010ffULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x000000612e39723eULL, 0x002fce00000010ffULL, 0x0000004a3840723cULL, 0x020b62000004183cULL,
0x0000002100217308ULL, 0x000e6c0000000800ULL, 0x00000008174a7824ULL, 0x020fe400078e00ffULL,
0x0000001a001a7308ULL, 0x000fe60000000800ULL, 0xfffffff84a177812ULL, 0x000fca00078ee217ULL,
0x0000001f001f7308ULL, 0x000ea20000000800ULL, 0x0000001c213c723eULL, 0x002fce00000010ffULL,
0x0000002a002a7308ULL, 0x000e700000000800ULL, 0x0000003500357308ULL, 0x000fe20000000800ULL,
0x0000001a1f3e723eULL, 0x004fce00000010ffULL, 0x0000002800287308ULL, 0x000ea20000000800ULL,
0x0000005d2a3d723eULL, 0x002fce00000010ffULL, 0x00000011001b7308ULL, 0x0003e20000000800ULL,
0x00000035283f723eULL, 0x004fce00000010ffULL, 0x0000001800187308ULL, 0x000fe20000000800ULL,
0x0000000119117810ULL, 0x002fc80007ffe0ffULL, 0xfffffff8444b7812ULL, 0x000fe400078ee211ULL,
0x0000004c3c44723cULL, 0x000b620000041840ULL, 0x0000001d001d7308ULL, 0x000e620000000800ULL,
0x0000000219117810ULL, 0x000fe40007ffe0ffULL, 0x000000044b4b7c11ULL, 0x000fc6000f8e20ffULL,
0x00000008194d7824ULL, 0x060fe200078e00ffULL, 0x0000000319407810ULL, 0x040fe20007ffe0ffULL,
0x0000001600167308ULL, 0x000ea20000000800ULL, 0x00000008194c7824ULL, 0x040fe200078e00ffULL,
0x0000000419417810ULL, 0x000fe40007ffe0ffULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee240ULL,
0x0000000819407824ULL, 0x040fe200078e00ffULL, 0x0000000519427810ULL, 0x000fe40007ffe0ffULL,
0x0000002f002f7308ULL, 0x000fe20000000800ULL, 0xfffffff84c4c7812ULL, 0x000fc400078ee211ULL,
0xfffffff84e4e7812ULL, 0x000fe400078ee241ULL, 0xfffffff84f4f7812ULL, 0x000fe400078ee242ULL,
0xfffffff840117812ULL, 0x000fe200078ee219ULL, 0x0000002d002d7308ULL, 0x000ee20000000800ULL,
0x000000181d40723eULL, 0x002fe400000010ffULL, 0x000000161b42723eULL, 0x004fe400000010ffULL,
0x0000000411117c11ULL, 0x000fc4000f8e20ffULL, 0x000000044d4d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x000000044f4f7c11ULL, 0x000fce000f8e20ffULL,
0x00000012002b7308ULL, 0x0002a20000000800ULL, 0x0000002f2d41723eULL, 0x008fe200000010ffULL,
0x0000000819127824ULL, 0x002fe200078e00ffULL, 0x000000044e197c11ULL, 0x000fc8000f8e20ffULL,
0xfffffff812517812ULL, 0x000fe400078ee251ULL, 0x000000262b43723eULL, 0x004fe400000010ffULL,
0x0000000c0f127812ULL, 0x000fe400078ec0ffULL, 0x000000044c0f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000451517c11ULL, 0x000fe2000f8e20ffULL, 0x000000544044723cULL, 0x000f620000041844ULL,
0x0000000111117824ULL, 0x000fc400078e0212ULL, 0x00000001124b7824ULL, 0x040fe400078e024bULL,
0x00000001124d7824ULL, 0x040fe200078e024dULL, 0x0000003011007388ULL, 0x0003e20000000800ULL,
0x0000000112197824ULL, 0x040fe400078e0219ULL, 0x00000001124f7824ULL, 0x040fe200078e024fULL,
0x000000324b007388ULL, 0x0003e20000000800ULL, 0x0000000112517824ULL, 0x000fd200078e0251ULL,
0x0000000450457c11ULL, 0x020fe4000f8e20ffULL, 0x0000000417477c11ULL, 0x000fe2000f8e20ffULL,
0x0000000112177824ULL, 0x040fe200078e020fULL, 0x00000048490f7208ULL, 0x000fe20004800000ULL,
0x0000000112457824ULL, 0x040fe400078e0245ULL, 0x0000000112127824ULL, 0x000fe200078e0247ULL,
0x0000003817007388ULL, 0x0003e20000000800ULL, 0x000000ffff487224ULL, 0x000fe400078e0044ULL,
0x000000ffff497224ULL, 0x000fe200078e0046ULL, 0x0000003a4d007388ULL, 0x0003e80000000800ULL,
0x0000003c19007388ULL, 0x0003e80000000800ULL, 0x0000003e4f007388ULL, 0x0003e80000000800ULL,
0x0000004045007388ULL, 0x0003e80000000800ULL, 0x0000004251007388ULL, 0x0003e80000000800ULL,
0x0000003112007388ULL, 0x0003e80000000800ULL, 0x000400334b007388ULL, 0x0003e80000000800ULL,
0x0004003917007388ULL, 0x0003e80000000800ULL, 0x0004003b4d007388ULL, 0x0003e80000000800ULL,
0x0004003d19007388ULL, 0x0003e80000000800ULL, 0x0004003f4f007388ULL, 0x0003e80000000800ULL,
0x0004004145007388ULL, 0x0003e80000000800ULL, 0x0004004351007388ULL, 0x0003e80000000800ULL,
0x0180000c0a008388ULL, 0x0003e80000000c00ULL, 0x018200480a008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000007ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080007ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100007ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000109097810ULL, 0x000fe20007ffe0ffULL,
0x0000180007ff7f8cULL, 0x0003e6000c80043fULL, 0x000000360900720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff9b6000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff387807ULL, 0x008fe20004000000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x00028dd0003c7802ULL, 0x000fc40000000f00ULL,
0x0000155000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff047224ULL, 0x000fe200078e003dULL,
0xfffda70000007947ULL, 0x000fea000383ffffULL, 0x00000001ff387807ULL, 0x000fe20004800000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x00028e30003c7802ULL, 0x000fc40000000f00ULL,
0x000014f000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff047224ULL, 0x000fe200078e003dULL,
0xfffda73000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3f7224ULL, 0x000fe200078e0000ULL,
0x00028eb000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3e7224ULL, 0x000fe400078e003bULL,
0x0000001fff407424ULL, 0x000fc400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000143000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e003eULL,
0xfffda7b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003bULL,
0x00028f3000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fe400078e0000ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000013b000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e003eULL,
0xfffda89000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0000ULL,
0x00028fb000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0003ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000133000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003eULL,
0xfffdaa4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3f7224ULL, 0x002fe200078e0008ULL,
0x0002903000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3e7224ULL, 0x000fe400078e0000ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000012b000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e003eULL,
0xfffda9f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x000290b000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0062ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000123000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003eULL,
0xfffde06000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x0002913000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fe400078e0061ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000011b000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e003eULL,
0xfffde00000007947ULL, 0x000fea000383ffffULL, 0x00000001ff387807ULL, 0x004fe20004000000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x00029190003c7802ULL, 0x000fc40000000f00ULL,
0x0000119000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e003dULL,
0xfffe1ac000007947ULL, 0x000fea000383ffffULL, 0x00000001ff387807ULL, 0x000fe20004800000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x000291f0003c7802ULL, 0x000fc40000000f00ULL,
0x0000113000007944ULL, 0x008fea0003c00000ULL, 0xfffe1b0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0044ULL, 0x0002926000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0062ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000108000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e003eULL, 0xfffe1b7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0044ULL, 0x000292e000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x002fe400078e0061ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000100000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e003eULL, 0xfffe1c4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0002936000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0062ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00000f8000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e003eULL, 0xfffe1de000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x000293e000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x002fe400078e0061ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00000f0000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003eULL, 0xfffe1d8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x0002946000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0062ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00000e8000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e003eULL, 0xfffe521000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x000294e000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x002fe400078e0061ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00000e0000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003eULL, 0xfffe51b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff387807ULL, 0x004fe20004000000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x00029540003c7802ULL, 0x000fc40000000f00ULL, 0x00000de000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e003dULL, 0xfffe8b5000007947ULL, 0x000fea000383ffffULL,
0x00000001ff387807ULL, 0x000fe20004800000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x000295a0003c7802ULL, 0x000fc40000000f00ULL, 0x00000d8000007944ULL, 0x008fea0003c00000ULL,
0xfffe8b9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0044ULL,
0x0002961000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0062ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00000cd000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e003eULL,
0xfffe8c0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0044ULL,
0x0002969000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fe400078e0061ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00000c5000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e003eULL,
0xfffe8cd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x0002971000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0062ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00000bd000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003eULL,
0xfffe8e7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x0002979000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fe400078e0061ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00000b5000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e003eULL,
0xfffe8e1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x0002981000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x000fc400078e0062ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00000ad000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003eULL,
0xfffec2a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e003aULL,
0x0002989000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3f7224ULL, 0x002fe400078e0061ULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00000a5000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e003eULL,
0xfffec24000007947ULL, 0x000fea000383ffffULL, 0x00000001ff387807ULL, 0x004fe20004000000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x000298f0003c7802ULL, 0x000fc40000000f00ULL,
0x00000a3000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e003dULL,
0xfffefbe000007947ULL, 0x000fea000383ffffULL, 0x00000001ff387807ULL, 0x000fe20004800000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x00029950003c7802ULL, 0x000fc40000000f00ULL,
0x000009d000007944ULL, 0x008fea0003c00000ULL, 0xfffefc2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0044ULL, 0x000299c000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0062ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000092000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e003eULL, 0xfffefc9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0044ULL, 0x00029a4000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x002fe400078e0061ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000008a000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e003eULL, 0xfffefd6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x00029ac000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0062ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000082000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e003eULL, 0xfffeff0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x00029b4000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x002fe400078e0061ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000007a000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003eULL, 0xfffefea000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x00029bc000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fc400078e0062ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000072000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e003eULL, 0xffff333000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e003aULL, 0x00029c4000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x002fe400078e0061ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000006a000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003eULL, 0xffff32d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x000fe200078e0004ULL, 0x00029cb000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff407424ULL, 0x000fc400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000063000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e003eULL,
0xffff55b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3e7224ULL, 0x000fe200078e0004ULL,
0x00029d2000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff407424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000005c000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e003eULL, 0xffff568000007947ULL, 0x000fea000383ffffULL,
0x00000002ff237424ULL, 0x000fe200078e00ffULL, 0x00029d9000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff497424ULL, 0x000fe400078e00ffULL, 0xffffffffff247424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0049ULL,
0xffffe28000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1e7224ULL, 0x006fe200078e0020ULL,
0x00029e1000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff237424ULL, 0x000fc400078e00ffULL,
0x0000001fff497424ULL, 0x000fe400078e00ffULL, 0xffffffffff247424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x000000492000720bULL, 0x004fe20003f1e000ULL,
0x000000ffff1e7224ULL, 0x002fe200078e0012ULL, 0x00029e9000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff237424ULL, 0x000fe200078e00ffULL, 0x00000020490e7208ULL, 0x000fe20004000000ULL,
0x0000001fff497424ULL, 0x000fe400078e00ffULL, 0xffffffffff247424ULL, 0x000fc400078e00ffULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x000000491200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff1e7224ULL, 0x002fe200078e0013ULL, 0x00029f1000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff237424ULL, 0x000fe200078e00ffULL, 0x0000001249127208ULL, 0x000fe20004000000ULL,
0x0000001fff497424ULL, 0x000fc400078e00ffULL, 0xffffffffff247424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x000000491300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff1e7224ULL, 0x002fe200078e0022ULL, 0x00029f9000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff237424ULL, 0x000fe200078e00ffULL, 0x0000001349487208ULL, 0x000fe20004000000ULL,
0x0000001fff497424ULL, 0x000fe400078e00ffULL, 0xffffffffff247424ULL, 0x000fc400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000492200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff1e7224ULL, 0x002fe200078e000eULL, 0x0002a01000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff237424ULL, 0x000fe200078e00ffULL, 0x00000022490c7208ULL, 0x000fe20004000000ULL,
0x0000001fff497424ULL, 0x000fc400078e00ffULL, 0xffffffffff247424ULL, 0x000fc400078e00ffULL,
0x0000029000007944ULL, 0x000fea0003c00000ULL, 0x000000490e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff1e7224ULL, 0x002fe200078e0012ULL, 0x0002a09000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff237424ULL, 0x000fe200078e00ffULL, 0x0000000e490d7208ULL, 0x000fe20004000000ULL,
0x0000001fff497424ULL, 0x000fe400078e00ffULL, 0xffffffffff247424ULL, 0x000fc400078e00ffULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000491200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff1e7224ULL, 0x002fe200078e0048ULL, 0x0002a11000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff237424ULL, 0x000fe200078e00ffULL, 0x00000012490e7208ULL, 0x000fe20004000000ULL,
0x0000001fff497424ULL, 0x000fc400078e00ffULL, 0xffffffffff247424ULL, 0x000fc400078e00ffULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffe07000007947ULL, 0x000fea000383ffffULL,
0x0180000011007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000001100008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff11ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000011027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000001100007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffd5d6002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff117424ULL, 0x000fe200078e00ffULL, 0x0000002400007348ULL, 0x000fe80003800000ULL,
0x0c0000231e497389ULL, 0x0002a200000e0049ULL, 0xfffd5d2010007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff397424ULL, 0x000fe200078e00ffULL, 0x0000004100007348ULL, 0x000fe80003800000ULL,
0x0000003f3e3e7389ULL, 0x0002a200000e0040ULL, 0xfffd5ce038007950ULL, 0x000fea0003c3ffffULL,
0x000000013800780cULL, 0x000fe20003f25070ULL, 0x0000003d00007348ULL, 0x000fe80003800000ULL,
0x00000000ff397424ULL, 0x000fd000078e00ffULL, 0x0000000000387806ULL, 0x000fc800048e0100ULL,
0x0000003d383d7212ULL, 0x000fe200078ec0ffULL, 0x000000ffff387224ULL, 0x000fc800078e003cULL,
0xfffd5c7038007950ULL, 0x000fea0003c3ffffULL, 0x0000003100007348ULL, 0x000fe80003800000ULL,
0x00000000ff317424ULL, 0x000fc800078e00ffULL, 0xfffd5c4030007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x000000000000060bULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000768ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a08ULL, 0x0000000000000450ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e58ULL, 0x00000000000000e4ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f3cULL, 0x0000000000000c40ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001b80ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001b90ULL, 0x00000000000000b0ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001c40ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001c44ULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001e80ULL, 0x000000000002a480ULL, 0xfb00001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000002c300ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000002c350ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000002c6d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001c40ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000002a6c0ULL, 0x000000000002a6c0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000002c300ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000002c6d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_4_kvt_int8_pagedKV_128_nqpkv_1_m_1_sm_80_cubin_len = 182192;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
