/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_4_kvt_e4m3_pagedKV_64_nqpkv_1_m_1_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000025d50ULL, 0x00000000000259d0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL,
0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45346a4c4545346aULL,
0x7461324545386a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4536316a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL,
0x30326d735f616475ULL, 0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL,
0x65746e695f5f2400ULL, 0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x6c66625f636e7973ULL, 0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL,
0x635f5f245f335f6cULL, 0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL,
0x65746e695f5f2400ULL, 0x245f345f6c616e72ULL, 0x735f616475635f5fULL, 0x707261775f30376dULL,
0x65722e00636e7973ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL, 0x2e6c65722e006168ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x5f6c656e72656b24ULL, 0x6d656d732461686dULL,
0x0066754265747942ULL, 0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL,
0x006d617261705f00ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x2e6c65722e766e2eULL,
0x00006e6f69746361ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL,
0x000c0001000001b5ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001fbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000242ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000288ULL, 0x0000000000000030ULL, 0x0000000000000004ULL,
0x000c0001000002d6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000324ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000372ULL, 0x000000000000000cULL,
0x0000000000000004ULL, 0x000c0001000003b9ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000407ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000044cULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b002200000492ULL, 0x0000000000023820ULL,
0x0000000000000180ULL, 0x000b0022000004c5ULL, 0x00000000000239a0ULL, 0x0000000000000040ULL,
0x000b0022000004f0ULL, 0x00000000000239e0ULL, 0x0000000000000040ULL, 0x000b00220000051aULL,
0x0000000000023a20ULL, 0x0000000000000060ULL, 0x000b002200000545ULL, 0x0000000000023a80ULL,
0x0000000000000100ULL, 0x000a0003000005acULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000005ccULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005fcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000023b80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0002382000000000ULL, 0x0000040400000000ULL,
0x810c000001600400ULL, 0x008c9c0400288080ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080830828808081ULL, 0x9108288080840828ULL, 0x2880809208288080ULL, 0x8099082880809808ULL,
0x082880809a082880ULL, 0x8080a608288080a0ULL, 0xf408288080a70828ULL, 0x2880808608288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808086ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x0002382000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL,
0x8083288080840900ULL, 0x0900000010042880ULL, 0x2880808428808086ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080830828808081ULL, 0x8a08288080840828ULL, 0x2880809108288080ULL, 0x8098082880809208ULL,
0x0828808099082880ULL, 0x8080a0082880809aULL, 0xf408288080a70828ULL, 0x2880808c08288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x000022002880808cULL, 0x0000001cffffffffULL,
0x0000013000000000ULL, 0x000239a000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080830828808081ULL, 0x8a08288080840828ULL, 0x2880809108288080ULL,
0x8098082880809208ULL, 0x0828808099082880ULL, 0x8080a6082880809aULL, 0xf408288080a70828ULL,
0x288080a008288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080a0ULL,
0x0000001cffffffffULL, 0x000001d800000000ULL, 0x000239e000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080830828808081ULL, 0x8a08288080840828ULL,
0x2880809108288080ULL, 0x8098082880809208ULL, 0x0828808099082880ULL, 0x8080a6082880809aULL,
0xf408288080a70828ULL, 0x288080a008288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x00002200288080a0ULL, 0x0000001cffffffffULL, 0x0000028000000000ULL, 0x00023a2000000000ULL,
0x0000006000000000ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080830828808081ULL,
0x8608288080840828ULL, 0x2880809108288080ULL, 0x8095082880809208ULL, 0x0828808099082880ULL,
0x8080a0082880809aULL, 0xa708288080a60828ULL, 0x288080f408288080ULL, 0x8280162880809808ULL,
0x0000000003102880ULL, 0x8080989200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL,
0x0000032800000000ULL, 0x00023a8000000000ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000001b00082f04ULL, 0x00082304000000a4ULL, 0x0000000000000017ULL, 0x0000001700081204ULL,
0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001b00082304ULL, 0x0008120400000000ULL, 0x000000000000001bULL, 0x0000001b00081104ULL,
0x0004370400000000ULL, 0x00080a040000007bULL, 0x0068016000000018ULL, 0x000c170400681903ULL,
0x0060000700000000ULL, 0x000c17040021f000ULL, 0x0058000600000000ULL, 0x000c17040021f000ULL,
0x0050000500000000ULL, 0x000c17040011f000ULL, 0x0038000400000000ULL, 0x000c17040061f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x0000002000043104ULL, 0xffffffff01bc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000000f001bc2804ULL, 0x0000046000000100ULL, 0x00003460000033d0ULL,
0x000036c000003560ULL, 0x00003920000038f0ULL, 0x000039c000003970ULL, 0x00006900000068e0ULL,
0x000069a000006950ULL, 0x00009d4000009cb0ULL, 0x00009f8000009e30ULL, 0x0000a1c00000a1a0ULL,
0x0000a2600000a210ULL, 0x0000cfa00000cf80ULL, 0x0000d0400000cff0ULL, 0x000102c000010230ULL,
0x00010500000103b0ULL, 0x0001074000010720ULL, 0x000107e000010790ULL, 0x0001352000013500ULL,
0x000135c000013570ULL, 0x00016840000167b0ULL, 0x00016a8000016930ULL, 0x00016cc000016ca0ULL,
0x00016d6000016d10ULL, 0x00019aa000019a80ULL, 0x00019b4000019af0ULL, 0x0001b8200001b6e0ULL,
0x0001be200001be00ULL, 0x0001d3e00001c210ULL, 0x0001de700001de50ULL, 0x0001f0400001f020ULL,
0x00021c6000021c20ULL, 0x00021c8000021c70ULL, 0x00021cf000021c90ULL, 0x00021d3000021d10ULL,
0x000229c000022970ULL, 0x00022a8000022a20ULL, 0x00022b4000022ae0ULL, 0x00022c0000022ba0ULL,
0x00022ca000022c50ULL, 0x00022d5000022cf0ULL, 0x00022e1000022db0ULL, 0x00022ed000022e70ULL,
0x00022f7000022f20ULL, 0x0002302000022fc0ULL, 0x000230e000023080ULL, 0x000231a000023140ULL,
0x00023240000231f0ULL, 0x000232f000023290ULL, 0x000233b000023350ULL, 0x0002347000023410ULL,
0x00023510000234c0ULL, 0x000235c000023560ULL, 0x0002368000023620ULL, 0x00023740000236e0ULL,
0x00023800000237a0ULL, 0x0000021007e03904ULL, 0x00010ad0000000ffULL, 0x00000280003f0100ULL,
0x00010ad800000011ULL, 0x000002d0003f0120ULL, 0x00010b5800000011ULL, 0x00000400003f0120ULL,
0x00010b7800000011ULL, 0x00000430003f0120ULL, 0x00010b88000000ffULL, 0x00000500003f0100ULL,
0x00010ad0000000ffULL, 0x00000750003f0107ULL, 0x00010b5c0000005cULL, 0x000007b0003f0102ULL,
0x00010b580000005cULL, 0x00000910003f0101ULL, 0x00010b88000000ffULL, 0x00000950003f0101ULL,
0x00010b8c000000ffULL, 0x00000b10003f0105ULL, 0x00010b8c000000ffULL, 0x00001520003f0105ULL,
0x00010b88000000ffULL, 0x00001550003f0101ULL, 0x00010b8c000000ffULL, 0x00001720003f0105ULL,
0x00010b8c000000ffULL, 0x00001880003f0105ULL, 0x00010b78000000ffULL, 0x00001900003f0107ULL,
0x00010b78000000ffULL, 0x00001960003f0101ULL, 0x00010b88000000ffULL, 0x00001c30003f0101ULL,
0x00010b7c000000ffULL, 0x00001df0003f0105ULL, 0x00010b7c000000ffULL, 0x00001e50003f0105ULL,
0x00010b8c000000ffULL, 0x00002020003f0105ULL, 0x00010b8c000000ffULL, 0x00002a80003f0105ULL,
0x00010b88000000ffULL, 0x00002ab0003f0101ULL, 0x00010b8c000000ffULL, 0x00002c80003f0105ULL,
0x00010b8c000000ffULL, 0x00002fd0003f0105ULL, 0x00010b80000000ffULL, 0x00003060003f0107ULL,
0x00010b80000000ffULL, 0x000030f0003f0101ULL, 0x00010ad80000005cULL, 0x00003120003f0101ULL,
0x00010adc0000005cULL, 0x000032f0003f0105ULL, 0x00010adc0000005cULL, 0x00005530003f0105ULL,
0x00010b88000000ffULL, 0x00005600003f0101ULL, 0x00010b84000000ffULL, 0x000057c0003f0105ULL,
0x00010b84000000ffULL, 0x00005820003f0105ULL, 0x00010b8c000000ffULL, 0x000059f0003f0105ULL,
0x00010b8c000000ffULL, 0x00006420003f0105ULL, 0x00010b88000000ffULL, 0x00006450003f0101ULL,
0x00010b8c000000ffULL, 0x00006620003f0105ULL, 0x00010b8c000000ffULL, 0x000067f0003f0105ULL,
0x00010b78000000ffULL, 0x00006870003f0107ULL, 0x00010b78000000ffULL, 0x000083c0003f0101ULL,
0x00010b88000000ffULL, 0x00008470003f0101ULL, 0x00010b58000000ffULL, 0x00008550003f0101ULL,
0x00010b7c000000ffULL, 0x00008710003f0105ULL, 0x00010b7c000000ffULL, 0x00008770003f0105ULL,
0x00010b8c000000ffULL, 0x00008940003f0105ULL, 0x00010b8c000000ffULL, 0x00009390003f0105ULL,
0x00010b88000000ffULL, 0x000093c0003f0101ULL, 0x00010b8c000000ffULL, 0x00009590003f0105ULL,
0x00010b8c000000ffULL, 0x000098b0003f0105ULL, 0x00010b80000000ffULL, 0x00009930003f0107ULL,
0x00010b80000000ffULL, 0x000099d0003f0101ULL, 0x00010af80000005cULL, 0x00009a00003f0101ULL,
0x00010afc0000005cULL, 0x00009bd0003f0105ULL, 0x00010afc0000005cULL, 0x0000bbc0003f0105ULL,
0x00010b88000000ffULL, 0x0000bca0003f0101ULL, 0x00010b84000000ffULL, 0x0000be60003f0105ULL,
0x00010b84000000ffULL, 0x0000bec0003f0105ULL, 0x00010b8c000000ffULL, 0x0000c090003f0105ULL,
0x00010b8c000000ffULL, 0x0000cac0003f0105ULL, 0x00010b88000000ffULL, 0x0000caf0003f0101ULL,
0x00010b8c000000ffULL, 0x0000ccc0003f0105ULL, 0x00010b8c000000ffULL, 0x0000ce90003f0105ULL,
0x00010b78000000ffULL, 0x0000cf10003f0107ULL, 0x00010b78000000ffULL, 0x0000e960003f0101ULL,
0x00010b88000000ffULL, 0x0000e9f0003f0101ULL, 0x00010b60000000ffULL, 0x0000ead0003f0101ULL,
0x00010b7c000000ffULL, 0x0000ec90003f0105ULL, 0x00010b7c000000ffULL, 0x0000ecf0003f0105ULL,
0x00010b8c000000ffULL, 0x0000eec0003f0105ULL, 0x00010b8c000000ffULL, 0x0000f910003f0105ULL,
0x00010b88000000ffULL, 0x0000f940003f0101ULL, 0x00010b8c000000ffULL, 0x0000fb10003f0105ULL,
0x00010b8c000000ffULL, 0x0000fe30003f0105ULL, 0x00010b80000000ffULL, 0x0000feb0003f0107ULL,
0x00010b80000000ffULL, 0x0000ff50003f0101ULL, 0x00010b180000005cULL, 0x0000ff80003f0101ULL,
0x00010b1c0000005cULL, 0x00010150003f0105ULL, 0x00010b1c0000005cULL, 0x00012140003f0105ULL,
0x00010b88000000ffULL, 0x00012220003f0101ULL, 0x00010b84000000ffULL, 0x000123e0003f0105ULL,
0x00010b84000000ffULL, 0x00012440003f0105ULL, 0x00010b8c000000ffULL, 0x00012610003f0105ULL,
0x00010b8c000000ffULL, 0x00013040003f0105ULL, 0x00010b88000000ffULL, 0x00013070003f0101ULL,
0x00010b8c000000ffULL, 0x00013240003f0105ULL, 0x00010b8c000000ffULL, 0x00013410003f0105ULL,
0x00010b78000000ffULL, 0x00013490003f0107ULL, 0x00010b78000000ffULL, 0x00014ee0003f0101ULL,
0x00010b88000000ffULL, 0x00014f70003f0101ULL, 0x00010b68000000ffULL, 0x00015050003f0101ULL,
0x00010b7c000000ffULL, 0x00015210003f0105ULL, 0x00010b7c000000ffULL, 0x00015270003f0105ULL,
0x00010b8c000000ffULL, 0x00015440003f0105ULL, 0x00010b8c000000ffULL, 0x00015e90003f0105ULL,
0x00010b88000000ffULL, 0x00015ec0003f0101ULL, 0x00010b8c000000ffULL, 0x00016090003f0105ULL,
0x00010b8c000000ffULL, 0x000163b0003f0105ULL, 0x00010b80000000ffULL, 0x00016430003f0107ULL,
0x00010b80000000ffULL, 0x000164d0003f0101ULL, 0x00010b380000005cULL, 0x00016500003f0101ULL,
0x00010b3c0000005cULL, 0x000166d0003f0105ULL, 0x00010b3c0000005cULL, 0x000186c0003f0105ULL,
0x00010b88000000ffULL, 0x000187a0003f0101ULL, 0x00010b84000000ffULL, 0x00018960003f0105ULL,
0x00010b84000000ffULL, 0x000189c0003f0105ULL, 0x00010b8c000000ffULL, 0x00018b90003f0105ULL,
0x00010b8c000000ffULL, 0x000195c0003f0105ULL, 0x00010b88000000ffULL, 0x000195f0003f0101ULL,
0x00010b8c000000ffULL, 0x000197c0003f0105ULL, 0x00010b8c000000ffULL, 0x00019990003f0105ULL,
0x00010b78000000ffULL, 0x00019a10003f0107ULL, 0x00010b78000000ffULL, 0x0001b460003f0101ULL,
0x00010b88000000ffULL, 0x0001b4e0003f0101ULL, 0x00010b70000000ffULL, 0x0001c070003f0101ULL,
0x00010ad0000000ffULL, 0x0001d410003f0101ULL, 0x00010ad4000000ffULL, 0x0001d5e0003f0105ULL,
0x00010ad4000000ffULL, 0x0001d960003f0105ULL, 0x00010ad0000000ffULL, 0x0001d9a0003f0101ULL,
0x00010ad4000000ffULL, 0x0001db60003f0105ULL, 0x00010ad4000000ffULL, 0x00020f20003f0105ULL,
0x0000000000000064ULL, 0x00021150003f0101ULL, 0x0000000400000064ULL, 0x00021320003f0105ULL,
0x0000000400000064ULL, 0x000227d0003f0105ULL, 0x0000000000000062ULL, 0x00022830003f0101ULL,
0x0000000800000062ULL, 0x00022890003f0101ULL, 0x0000001000000062ULL, 0x00022900003f0101ULL,
0x0000001800000062ULL, 0x00053803003f0101ULL, 0x0001bf3000101c04ULL, 0x0001dca00001dbc0ULL,
0x0000040100022940ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000003c4ULL, 0x0000001b00000002ULL,
0x0000000000000314ULL, 0x0000001b00000002ULL, 0x000000000000026cULL, 0x0000001b00000002ULL,
0x00000000000001c4ULL, 0x0000001b00000002ULL, 0x0000000000000104ULL, 0x0000001b00000002ULL,
0x0000000000000044ULL, 0x0000001b00000002ULL, 0x000000000000039cULL, 0x0000001b00000002ULL,
0x00000000000002efULL, 0x0000001b00000002ULL, 0x0000000000000247ULL, 0x0000001b00000002ULL,
0x000000000000019fULL, 0x0000001b00000002ULL, 0x00000000000000dfULL, 0x0000001b00000002ULL,
0x0000000000010c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000117919ULL, 0x000e620000002100ULL,
0x0000000000157806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x00000200ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000000047919ULL, 0x000ea20000002300ULL,
0x0000001500057300ULL, 0x000ee200000e0000ULL, 0x0000000204047899ULL, 0x000fe2000800063fULL,
0x00000004ff177424ULL, 0x000fe200078e00ffULL, 0x0000000000037919ULL, 0x000f220000002200ULL,
0x0000460000067ab9ULL, 0x000fc60000000a00ULL, 0x0000000000147919ULL, 0x000ee20000000000ULL,
0x0000001500157309ULL, 0x000ee60000000000ULL, 0x0000000000067919ULL, 0x000ee20000000000ULL,
0x00000005ff617819ULL, 0x002fc60000011611ULL, 0x00001fff04027589ULL, 0x004fe800000e0000ULL,
0x00001fff61617589ULL, 0x000e6200000e0000ULL, 0x0000010004007a24ULL, 0x010fc600078e0203ULL,
0x0000000000037919ULL, 0x000ea20000002600ULL, 0x0000000000117a24ULL, 0x000fc600078e0211ULL,
0x0000000000007919ULL, 0x000ea20000002700ULL, 0x000000060500720cULL, 0x008fe40003f02070ULL,
0x000000ff1100720cULL, 0x040fe40003f25270ULL, 0x0000000f1100780cULL, 0x040fe40003f44070ULL,
0x000000031100780cULL, 0x040fe40003f64070ULL, 0x0000007f1100780cULL, 0x000fe20003f84070ULL,
0x0000000402047824ULL, 0x002fcc00078e0261ULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x00000002040b7824ULL, 0x000fe400078e00ffULL, 0x3fffff80ff049424ULL, 0x000fe400078e00ffULL,
0x000000010b0a7824ULL, 0x040fe200078e0214ULL, 0x000000040b0c7817ULL, 0x040fe20007800000ULL,
0x000000200b0d7824ULL, 0x000fe200078e00ffULL, 0x010ad004ff009388ULL, 0x0003e20000000a00ULL,
0x3fffffc0ff06a424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL,
0xffffffe00d107812ULL, 0x000fe200078ee20aULL, 0x00000004000a7c24ULL, 0x004fe2000f8e0203ULL,
0x000000010b0d7810ULL, 0x000fe20007ffe0ffULL, 0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL,
0x010ad8061100a388ULL, 0x0005e20000008a00ULL, 0x000000011100780cULL, 0x000fe20003f44070ULL,
0x7fffff60ff09b424ULL, 0x000fe400078e00ffULL, 0x000000010d057824ULL, 0x042fe400078e0214ULL,
0x000000200d127824ULL, 0x000fe200078e00ffULL, 0x010b58081100b388ULL, 0x0003e20000008a00ULL,
0x000058000b047a24ULL, 0x000fc400078e020aULL, 0xff317217ff0ec424ULL, 0x000fe200078e00ffULL,
0xffffffe012127812ULL, 0x000fe200078ee205ULL, 0x0000001014067824ULL, 0x004fe400078e00ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0a0bULL, 0x0104000e1100c388ULL, 0x0005e20000004800ULL,
0x000058000d077a24ULL, 0x000fe200078e020aULL, 0x000001f0060b7812ULL, 0x000fe200078ec0ffULL,
0x00005c0004047625ULL, 0x080fe200078e000fULL, 0x000000ff0c00720cULL, 0x040fe40003f63070ULL,
0x000000010c00780cULL, 0x000fe20003f83070ULL, 0x00005c0007067625ULL, 0x000fe200078e000fULL,
0x0000000b04087210ULL, 0x002fc60007fbe0ffULL, 0x3fffff00ff0ca424ULL, 0x000fe200078e00ffULL,
0x0000000b060a7210ULL, 0x000fe20007fde0ffULL, 0x7fffff00ff0da424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff0e9424ULL, 0x004fe400078e00ffULL, 0x7fffff80ff0f9424ULL, 0x000fe200078e00ffULL,
0x010b780c1100a388ULL, 0x000fe20000008a00ULL, 0x000000ffff047224ULL, 0x000fe400078e0a15ULL,
0x000000ffff097224ULL, 0x000fe200028e0605ULL, 0x010b880eff009388ULL, 0x000fe20000000a00ULL,
0x0000001010137824ULL, 0x000fc400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e0607ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000001012157824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e2000d901c46ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0004ULL, 0x0000000400607824ULL, 0x000fe200078e00ffULL,
0x000000000a157faeULL, 0x0003e6000e101c46ULL, 0x0000620060047625ULL, 0x0c0fe200078e0017ULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x00006a0060067625ULL, 0x000fe200078e0017ULL,
0x010ad40cffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010ad000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000006045f7981ULL, 0x000ea8000c1e1900ULL,
0x0000000606067981ULL, 0x000ee2000c1e1900ULL, 0x000000ff0200720cULL, 0x000fe20003f05270ULL,
0xffffffffff027424ULL, 0x000fe200078e00ffULL, 0x0000003f5f5e7810ULL, 0x004fc40007ffe0ffULL,
0x000000ff5f0c7810ULL, 0x002fe40007ffe0ffULL, 0x00000008ff5b7819ULL, 0x008fe40000011606ULL,
0x00000006ff5e7819ULL, 0x000fe4000001165eULL, 0x00000008ff5d7819ULL, 0x000fc6000001160cULL,
0x0001b91000008947ULL, 0x000fea0003800000ULL, 0x0000002061077824ULL, 0x040fe200078e0214ULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x00000008615c7824ULL, 0x000fe400078e00ffULL,
0x00000003ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000001f0700780cULL, 0x040fe40003f04070ULL,
0x000000030700780cULL, 0x000fd60003f24070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x0000005f0700720cULL, 0x040fe20003f06070ULL, 0x0000680060047a24ULL, 0x000fe200078e0207ULL,
0x00010a0007097811ULL, 0x000fc600078e10ffULL, 0x0000660004047625ULL, 0x000fd000078e0017ULL,
0x0000000004097faeULL, 0x0003e4000c121846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b5c0b5cff738cULL, 0x0005e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b58005cff7f8cULL, 0x0007e2000c80043fULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000b000001947ULL, 0x000fea0003800000ULL,
0x0000000400047824ULL, 0x002fe200078e0207ULL, 0x000000ff5e00720cULL, 0x000fe20003f05270ULL,
0x00006400ff057624ULL, 0x000fe200078e00ffULL, 0x00010ac007077811ULL, 0x000fe200078e10ffULL,
0x0000000204047824ULL, 0x000fc800078e00ffULL, 0x0000640004047624ULL, 0x000fc800078e0205ULL,
0x0000600004047625ULL, 0x000fca00078e0017ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e40008121846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff047f8cULL, 0x002e62000c80043fULL,
0x000000ffff087224ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x006fc400078e0005ULL,
0x0000000000047805ULL, 0x000fca0000015200ULL, 0x010b8c00ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000906067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x010b8c00ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001ff0c00780cULL, 0x000fe20003f04070ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000604047899ULL, 0x000fd4000800063fULL, 0x000004f000000947ULL, 0x000fea0003800000ULL,
0x0000000000157919ULL, 0x000e620000000000ULL, 0x0000005c5f057217ULL, 0x000fe20007800000ULL,
0x00000100ff137424ULL, 0x000fc800078e00ffULL, 0x0000000105087824ULL, 0x000fe200078e0a5cULL,
0x00000004ff097819ULL, 0x002fe20000011615ULL, 0x0000001015117824ULL, 0x000fc600078e00ffULL,
0x000000080900720cULL, 0x000fe20003f06070ULL, 0x000000015c0a7824ULL, 0x000fe200078e0209ULL,
0x000000f011117812ULL, 0x000fc600078ec0ffULL, 0x00000040030b7824ULL, 0x000fe200078e020aULL,
0x010a00000a067984ULL, 0x000e620000004800ULL, 0x000000010a077824ULL, 0x040fe400078e0215ULL,
0x000000100a0c7824ULL, 0x000fe200078e00ffULL, 0x000000020b0f7810ULL, 0x000fe20007ffe0ffULL,
0x010ac00006067984ULL, 0x002e640000004800ULL, 0x0000000406047c24ULL, 0x002fc8000f8e020bULL,
0x00005e0004047625ULL, 0x000fca00078e0013ULL, 0x0000001104067210ULL, 0x000fe40007f3e0ffULL,
0xfffffff00c047812ULL, 0x000fc600078ee207ULL, 0x000000ffff077224ULL, 0x000fe200008e0605ULL,
0x0000c000040d7811ULL, 0x000fe400078e20ffULL, 0x0000000209057810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c46ULL,
0x000000080500720cULL, 0x000fe20003f06070ULL, 0x000000015c0c7824ULL, 0x000fe400078e0205ULL,
0x010a08000a0e7984ULL, 0x000ea80000004800ULL, 0x010ac0000e0e7984ULL, 0x004ea40000004800ULL,
0x000000040e047c24ULL, 0x004fc4000f8e020fULL, 0x000000010c0f7824ULL, 0x000fe400078e0215ULL,
0x00005e0004047625ULL, 0x000fc800078e0013ULL, 0x000000100c0c7824ULL, 0x000fe200078e00ffULL,
0x0000001104067210ULL, 0x002fe40007f3e0ffULL, 0x000000040b047810ULL, 0x000fe40007ffe0ffULL,
0xfffffff00c0f7812ULL, 0x000fe200078ee20fULL, 0x000000ffff077224ULL, 0x000fe200008e0605ULL,
0x0000000409057810ULL, 0x000fe40007ffe0ffULL, 0x0000c0000f0f7811ULL, 0x000fe400078e20ffULL,
0x000000060b0b7810ULL, 0x000fe20007ffe0ffULL, 0x000000015c0c7824ULL, 0x000fe200078e0205ULL,
0x0000000609097810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060f7faeULL, 0x0003e2000c101c46ULL, 0x000000080500720cULL, 0x000fe20003f06070ULL,
0x000000010c0e7824ULL, 0x000fc400078e0215ULL, 0x010a10000a0d7984ULL, 0x000ea20000004800ULL,
0x000000100c177824ULL, 0x000fca00078e00ffULL, 0xfffffff0170e7812ULL, 0x000fe200078ee20eULL,
0x010ac0000d0d7984ULL, 0x004ea40000004800ULL, 0x000000040d047c24ULL, 0x004fe2000f8e0204ULL,
0x0000c0000e0d7811ULL, 0x000fc600078e20ffULL, 0x00005e0004047625ULL, 0x000fca00078e0013ULL,
0x0000001104067210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c46ULL,
0x000000080900720cULL, 0x000fc60003f06070ULL, 0x010a18000a0a7984ULL, 0x000ea80000004800ULL,
0x010ac0000a047984ULL, 0x004ea40000004800ULL, 0x0000000404047c24ULL, 0x004fe4000f8e020bULL,
0x000000015c0b7824ULL, 0x000fe400078e0209ULL, 0x00005e0004047625ULL, 0x000fc800078e0013ULL,
0x000000010b087824ULL, 0x040fe200078e0215ULL, 0x0000001104047210ULL, 0x000fe20007f3e0ffULL,
0x000000100b0b7824ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fe200008e0605ULL,
0xfffffff00b087812ULL, 0x000fc800078ee208ULL, 0x0000c00008077811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e2000c101c46ULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x000e620000000000ULL,
0x00000100ff0e7424ULL, 0x000fe200078e00ffULL, 0x0000005c0f0a7211ULL, 0x042fe200078fe0ffULL,
0x000000100f057824ULL, 0x000fc800078e00ffULL, 0x010a00000a087984ULL, 0x000e620000004800ULL,
0x00000040030b7824ULL, 0x000fe200078e020aULL, 0x000000f005117812ULL, 0x000fe200078ec0ffULL,
0x000000010a077824ULL, 0x040fe400078e020fULL, 0x000000100a0c7824ULL, 0x000fe200078e00ffULL,
0x010ac00008087984ULL, 0x002e640000004800ULL, 0x0000000408047c24ULL, 0x002fe2000f8e020bULL,
0x000000020a087810ULL, 0x000fc60007ffe0ffULL, 0x00005e0004047625ULL, 0x000fc800078e000eULL,
0x0000000108097824ULL, 0x000fe200078e020fULL, 0x0000001104067210ULL, 0x000fe20007f1e0ffULL,
0x0000001008107824ULL, 0x000fe200078e00ffULL, 0xfffffff00c047812ULL, 0x000fc600078ee207ULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x0000c000040d7811ULL, 0x000fe400078e20ffULL,
0x000000020b057810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e8000b901c46ULL, 0x010a08000a0c7984ULL, 0x000ea20000004800ULL,
0x000000040a067810ULL, 0x002fca0007ffe0ffULL, 0x0000000106077824ULL, 0x000fe200078e020fULL,
0x010ac0000c0c7984ULL, 0x004e640000004800ULL, 0x000000040c057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e000eULL, 0x0000001104087210ULL, 0x000fe40007f1e0ffULL,
0xfffffff010047812ULL, 0x000fe200078ee209ULL, 0x0000001006107824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200000e0605ULL, 0x0000c000040d7811ULL, 0x000fe400078e20ffULL,
0x000000040b057810ULL, 0x040fe40007ffe0ffULL, 0x000000060b0b7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080d7faeULL, 0x0003e8000b901c46ULL,
0x010a10000a0c7984ULL, 0x000ea20000004800ULL, 0x000000060a087810ULL, 0x002fc60007ffe0ffULL,
0x010ac0000c0c7984ULL, 0x004e640000004800ULL, 0x000000040c057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e000eULL, 0x0000001104067210ULL, 0x000fe40007f1e0ffULL,
0xfffffff010047812ULL, 0x000fc600078ee207ULL, 0x000000ffff077224ULL, 0x000fe200000e0605ULL,
0x0000c00004097811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e8000b901c46ULL, 0x010a18000a0c7984ULL, 0x000ea80000004800ULL,
0x010ac0000c0c7984ULL, 0x004ea40000004800ULL, 0x000000040c047c24ULL, 0x004fc4000f8e020bULL,
0x00000001080b7824ULL, 0x000fe400078e020fULL, 0x00005e0004047625ULL, 0x000fc800078e000eULL,
0x0000001008087824ULL, 0x000fe200078e00ffULL, 0x0000001104047210ULL, 0x000fc80007f1e0ffULL,
0xfffffff0080b7812ULL, 0x000fe200078ee20bULL, 0x000000ffff057224ULL, 0x000fc600000e0605ULL,
0x0000c0000b0b7811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e4000b901c46ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff047f8cULL, 0x002e64000c80043fULL, 0x000000ffff0b7224ULL, 0x002fc400078e0005ULL,
0x0000000000047805ULL, 0x000fca0000015200ULL, 0x010b8c00ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000906067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x010b8c00ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000002061057824ULL, 0x002fca00078e0204ULL,
0x0000001f0500780cULL, 0x000fda0003f04070ULL, 0x000000b000000947ULL, 0x000fea0003800000ULL,
0x0000002005067810ULL, 0x040fe20007ffe0ffULL, 0x0000680060077a24ULL, 0x000fe200078e0205ULL,
0x00010a0005057811ULL, 0x000fe200078e10ffULL, 0x00000004ff097424ULL, 0x000fe200078e00ffULL,
0x0000005f0600720cULL, 0x000fe40003f06070ULL, 0x0000002007067810ULL, 0x000fca0007ffe0ffULL,
0x0000660006067625ULL, 0x000fcc00078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e4000c121846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7800ff067f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff087f8cULL, 0x000ea2000c80043fULL, 0x000000ff5d00720cULL, 0x000fe20003f05270ULL,
0x000000ffff717224ULL, 0x002fe200078e0007ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x000000ffff5a7224ULL, 0x000fe200078e00ffULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0e7224ULL, 0x000fc400078e00ffULL,
0x0000001fff0f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff107424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x004fe400078e0009ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00019a5000008947ULL, 0x000fea0003800000ULL, 0x00005800ff147624ULL, 0x000fe200078e00ffULL,
0x00019a3000007945ULL, 0x000fe20003800000ULL, 0xff317217ff117424ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff5a7224ULL, 0x000fc400078e00ffULL,
0x0000004014147824ULL, 0x000fc600078e00ffULL, 0x0000010012167824ULL, 0x000fca00078e00ffULL,
0x0000005f1600720cULL, 0x000fda0003f06070ULL, 0x0001997000000947ULL, 0x02afea0003800000ULL,
0x000000ffff727224ULL, 0x000fc600078e00ffULL, 0x000000125b00720cULL, 0x000fe20003fa4070ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000002ff157819ULL, 0x000fe20000011672ULL,
0x000000ffff207224ULL, 0x000fe200078e00ffULL, 0x0000000372167812ULL, 0x040fe400078ec0ffULL,
0x00000015721d7207ULL, 0x000fe40002800000ULL, 0x000000ff16157207ULL, 0x000fe40006800000ULL,
0x000000031d1b7812ULL, 0x000fc400078ec0ffULL, 0x000000121d167211ULL, 0x022fc400078ff0ffULL,
0x00000000001c7805ULL, 0x000fca0000015200ULL, 0x010b7c00ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000211e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000120207810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b7c00ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fc40000015200ULL, 0x010b8c00ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff207224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000211e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000120207810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff1e7984ULL, 0x000e640000000800ULL, 0x800000001eff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000001161c7810ULL, 0x000fe20007ffe0ffULL,
0x000009a000017945ULL, 0x000fe60003800000ULL, 0x0000005d1c00720cULL, 0x000fda0003f06070ULL,
0x0000053000008947ULL, 0x000fea0003800000ULL, 0x00000004ff257819ULL, 0x000fe20000011604ULL,
0x00000004161c7824ULL, 0x000fe200078e021bULL, 0x0000002003217811ULL, 0x000fe200078e30ffULL,
0x0000001004207824ULL, 0x000fe200078e00ffULL, 0x00000002252b7810ULL, 0x000fe20007ffe0ffULL,
0x000000015c247824ULL, 0x000fe200078e0225ULL, 0x000000201c1c7811ULL, 0x000fe200078e30ffULL,
0x00000100ff277424ULL, 0x000fe200078e00ffULL, 0x000000f020297812ULL, 0x000fe200078ec0ffULL,
0x0000001024227824ULL, 0x000fe200078e00ffULL, 0x010a0000241e7984ULL, 0x000e620000004800ULL,
0x0000001c5f1d7217ULL, 0x000fe20007800000ULL, 0x000000015c267824ULL, 0x000fc800078e022bULL,
0x000000011d1d7824ULL, 0x000fe400078e0a1cULL, 0x00000001241c7824ULL, 0x000fe400078e0221ULL,
0x0000000126287824ULL, 0x000fe200078e0204ULL, 0x0000001d5c1d7217ULL, 0x000fca0007800000ULL,
0x000000011d207824ULL, 0x000fca00078e0a5cULL, 0x000000202500720cULL, 0x000fe20003f06070ULL,
0x010ac0001e1f7984ULL, 0x002e640000004800ULL, 0x0000001f141c7224ULL, 0x002fe400078e021cULL,
0x00000001241f7824ULL, 0x000fe400078e0204ULL, 0x00005e001c1c7625ULL, 0x000fc600078e0027ULL,
0xfffffff022237812ULL, 0x000fe400078ee21fULL, 0x000000291c1e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001261c7824ULL, 0x000fe200078e0221ULL, 0x0000e00023237811ULL, 0x000fc600078e20ffULL,
0x000000ffff1f7224ULL, 0x000fca00008e061dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e237faeULL, 0x0003e2000c101c46ULL, 0x000000202b00720cULL, 0x000fe20003f06070ULL,
0x00000010262b7824ULL, 0x000fe400078e00ffULL, 0x010a080024227984ULL, 0x000ea60000004800ULL,
0xfffffff02b237812ULL, 0x002fe400078ee228ULL, 0x00000004252b7810ULL, 0x000fe40007ffe0ffULL,
0x0000e00023237811ULL, 0x000fc400078e20ffULL, 0x0000000625257810ULL, 0x000fe20007ffe0ffULL,
0x000000015c267824ULL, 0x000fc800078e022bULL, 0x0000000126287824ULL, 0x000fe200078e0204ULL,
0x010ac000221d7984ULL, 0x004e640000004800ULL, 0x0000001d141c7224ULL, 0x002fc800078e021cULL,
0x00005e001c1c7625ULL, 0x000fca00078e0027ULL, 0x000000291c1e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001261c7824ULL, 0x000fc800078e0221ULL, 0x000000ffff1f7224ULL, 0x000fca00008e061dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e237faeULL, 0x0003e2000c101c46ULL,
0x000000202b00720cULL, 0x000fe20003f06070ULL, 0x00000010262b7824ULL, 0x000fe400078e00ffULL,
0x010a100024227984ULL, 0x000ea20000004800ULL, 0x000000015c267824ULL, 0x000fc800078e0225ULL,
0x0000000126217824ULL, 0x000fe200078e0221ULL, 0xfffffff02b237812ULL, 0x002fc800078ee228ULL,
0x0000e00023237811ULL, 0x000fe200078e20ffULL, 0x010ac000221d7984ULL, 0x004e640000004800ULL,
0x0000001d141c7224ULL, 0x002fc800078e021cULL, 0x00005e001c1c7625ULL, 0x000fca00078e0027ULL,
0x000000291c1e7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff1f7224ULL, 0x000fca00008e061dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e237faeULL, 0x0003e2000c101c46ULL,
0x000000202500720cULL, 0x000fc60003f06070ULL, 0x010a180024227984ULL, 0x000ea80000004800ULL,
0x010ac000221d7984ULL, 0x004ea40000004800ULL, 0x0000001d141d7224ULL, 0x004fe400078e0221ULL,
0x0000000126217824ULL, 0x000fe400078e0204ULL, 0x00005e001d1c7625ULL, 0x000fc800078e0027ULL,
0x0000001026267824ULL, 0x000fe200078e00ffULL, 0x000000291c1c7210ULL, 0x000fc80007f3e0ffULL,
0xfffffff0261f7812ULL, 0x002fe200078ee221ULL, 0x000000ffff1d7224ULL, 0x000fc600008e061dULL,
0x0000e0001f1f7811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c1f7faeULL, 0x0003e2000c101c46ULL, 0x0000044000007947ULL, 0x000fea0003800000ULL,
0x0000005c04257211ULL, 0x040fe200078fe0ffULL, 0x00000010041e7824ULL, 0x000fe200078e00ffULL,
0x0000002003247811ULL, 0x000fe200078e30ffULL, 0x00000100ff277424ULL, 0x000fe200078e00ffULL,
0x0000000225217810ULL, 0x040fe20007ffe0ffULL, 0x010a000025207984ULL, 0x000e620000004800ULL,
0x000000f01e297812ULL, 0x000fe200078ec0ffULL, 0x00000001251c7824ULL, 0x040fe400078e0224ULL,
0x00000001251f7824ULL, 0x000fc400078e0204ULL, 0x0000001025227824ULL, 0x000fe400078e00ffULL,
0x0000000121267824ULL, 0x000fc600078e0204ULL, 0xfffffff022237812ULL, 0x000fc800078ee21fULL,
0x0000e00023237811ULL, 0x000fe200078e20ffULL, 0x010ac000201d7984ULL, 0x002e640000004800ULL,
0x0000001d141c7224ULL, 0x002fc800078e021cULL, 0x00005e001c1c7625ULL, 0x000fca00078e0027ULL,
0x000000291c1e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001211c7824ULL, 0x040fe400078e0224ULL,
0x0000001021217824ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fc600000e061dULL,
0xfffffff021267812ULL, 0x000fe400078ee226ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e237faeULL, 0x0003e8000b901c46ULL, 0x010a080025227984ULL, 0x000ea20000004800ULL,
0x0000e00026237811ULL, 0x002fe400078e20ffULL, 0x00000004251f7810ULL, 0x000fca0007ffe0ffULL,
0x000000011f267824ULL, 0x000fe200078e0204ULL, 0x010ac000221d7984ULL, 0x004e640000004800ULL,
0x0000001d141c7224ULL, 0x002fc800078e021cULL, 0x00005e001c1c7625ULL, 0x000fca00078e0027ULL,
0x000000291c207210ULL, 0x000fe20007f1e0ffULL, 0x000000011f1c7824ULL, 0x040fe400078e0224ULL,
0x000000101f1f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff217224ULL, 0x000fc600000e061dULL,
0xfffffff01f267812ULL, 0x000fe400078ee226ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e8000b901c46ULL, 0x010a100025227984ULL, 0x000ea20000004800ULL,
0x0000e00026217811ULL, 0x002fe400078e20ffULL, 0x0000000625237810ULL, 0x000fe20007ffe0ffULL,
0x010ac000221d7984ULL, 0x0042a80000004800ULL, 0x0000000123227824ULL, 0x002fc400078e0204ULL,
0x0000001d141c7224ULL, 0x004fc800078e021cULL, 0x00005e001c1c7625ULL, 0x000fca00078e0027ULL,
0x000000291c1e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001231c7824ULL, 0x040fe400078e0224ULL,
0x0000001023237824ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fc600000e061dULL,
0xfffffff023227812ULL, 0x000fe400078ee222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e217faeULL, 0x0003e8000b901c46ULL, 0x010a180025207984ULL, 0x000ea20000004800ULL,
0x0000e000221f7811ULL, 0x002fc600078e20ffULL, 0x010ac000201d7984ULL, 0x004e640000004800ULL,
0x0000001d141c7224ULL, 0x002fc800078e021cULL, 0x00005e001c1c7625ULL, 0x000fca00078e0027ULL,
0x000000291c1c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff1d7224ULL, 0x000fca00000e061dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c1f7faeULL, 0x0003e6000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff1c7f8cULL, 0x002e64000c80043fULL, 0x000000ffff237224ULL, 0x002fc400078e001dULL,
0x00000000001c7805ULL, 0x000fca0000015200ULL, 0x010b8c00ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff207224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000211e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000120207810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff1e7984ULL, 0x000e640000000800ULL, 0x800000001eff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000165b00720cULL, 0x000fe20003f04070ULL,
0x000001f000017945ULL, 0x000fe20003800000ULL, 0x00000001151c7810ULL, 0x040fe40007ffe0ffULL,
0x000000031500780cULL, 0x000fe20003f45270ULL, 0x0000002061157824ULL, 0x000fe200078e0204ULL,
0x000000031c1d7812ULL, 0x000fc400078ec0ffULL, 0x000000165b00720cULL, 0x000fe40003f24070ULL,
0x0000001f1500780cULL, 0x000fc60003f84070ULL, 0x00000002ff1c8819ULL, 0x000fca000001161cULL,
0x000000011b1b7824ULL, 0x000fc800078e021cULL, 0x000000401b1c7824ULL, 0x040fe200078e00ffULL,
0x000000161b167211ULL, 0x000fc800078ff0ffULL, 0x000000c01c1b7812ULL, 0x000fca00078ec0ffULL,
0x00000100161e7824ULL, 0x000fe200078e021bULL, 0x000000ff1d1b7207ULL, 0x000fe20004000000ULL,
0x0000010000009947ULL, 0x000fea0001000000ULL, 0x00000020611d7824ULL, 0x000fe200078e0204ULL,
0x0000000113137810ULL, 0x000fc80007ffe0ffULL, 0x000000031d00780cULL, 0x000fda0003f04070ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x00000004001c7824ULL, 0x000fe200078e021dULL,
0x0000640013167a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff217424ULL, 0x000fe200078e00ffULL,
0x0000005e1300720cULL, 0x000fe20003f06070ULL, 0x000000021c1f7824ULL, 0x000fc800078e00ffULL,
0x000064001f167a24ULL, 0x000fe200078e0216ULL, 0x00010ac01d1f7811ULL, 0x000fc600078e10ffULL,
0x00006000161c7625ULL, 0x000fca00078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c1f7faeULL, 0x0003e4000c121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000e000017945ULL, 0x000fe20003800000ULL, 0x000000c000004947ULL, 0x000fea0003800000ULL,
0x00000001151c7824ULL, 0x142fe400078e021eULL, 0x0000000160167824ULL, 0x000fe200078e021bULL,
0x00010a00151b7811ULL, 0x000fe200078e10ffULL, 0x00000004ff1d7424ULL, 0x000fe200078e00ffULL,
0x0000005f1c00720cULL, 0x000fe20003f06070ULL, 0x0000680016167a24ULL, 0x000fc800078e021eULL,
0x0000000115167824ULL, 0x000fc800078e0216ULL, 0x00006600161c7625ULL, 0x000fca00078e001dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c1b7faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff7200720cULL, 0x000fe20003f05270ULL,
0x010b8000ff707f8cULL, 0x000ea2000c80043fULL, 0x0000080000017945ULL, 0x000fe20003800000ULL,
0xffffffffff167424ULL, 0x000fd400078e00ffULL, 0x000007d000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010ad8005c1c7f8cULL, 0x002e64000c80043fULL,
0x000000ffff207224ULL, 0x002fc400078e001dULL, 0x00000000001c7805ULL, 0x000fca0000015200ULL,
0x010adc005c177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007804820ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c1e7210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09001e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff177819ULL, 0x000fc8000001141fULL,
0x0000001e17177211ULL, 0x000fca00078110ffULL, 0x000000ffff1e7224ULL, 0x000fca00000e061fULL,
0x0000000217177819ULL, 0x000fc8000000121eULL, 0x000000170000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011b1b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x010adc005c177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804820ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001004177824ULL, 0x000fe200078e00ffULL, 0x00000001ff1b7819ULL, 0x000fc80000011604ULL,
0x0000007017177812ULL, 0x000fe400078ec0ffULL, 0x0000000c1b1c7812ULL, 0x000fca00078ec0ffULL,
0x00000001171c7824ULL, 0x000fca00078e021cULL, 0x010000001c1e7984ULL, 0x000e680000000800ULL,
0x010200001c1b7984ULL, 0x0006a20000000800ULL, 0x000000111e00720bULL, 0x002fe20003f1d000ULL,
0x0001f5827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000177806ULL, 0x008fc800000e0100ULL,
0x0000ffff17227812ULL, 0x000fe2000780c0ffULL, 0x0000045000027945ULL, 0x000fe20003800000ULL,
0x00000001ff177424ULL, 0x000fe400078e00ffULL, 0x000000ffff1d7224ULL, 0x000fd200078e0011ULL,
0x0000041000008947ULL, 0x000fea0003800000ULL, 0x000000ff6100720cULL, 0x000fe40003f05270ULL,
0x000000111e00720bULL, 0x000fe20003f34000ULL, 0x0001f5427f007947ULL, 0x000fd8000b800000ULL,
0x00000000001f7806ULL, 0x000fc400008e0100ULL, 0x0000001e111d7209ULL, 0x000fe20007810000ULL,
0x0000035000037945ULL, 0x000fe20003800000ULL, 0x000099101f207816ULL, 0x000fc600000000ffULL,
0x0104001d1c008388ULL, 0x0003e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x8000001d11117221ULL, 0x002fe20000010000ULL,
0x000000ff1fff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL, 0x00000011001c7308ULL, 0x000e640000000800ULL,
0x0000001c0e0e7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff117819ULL, 0x000fe20000011604ULL, 0x0001f4927f007947ULL, 0x000fea000b800000ULL,
0x00001f111c117589ULL, 0x0002e400000e0000ULL, 0x000000110d0d7220ULL, 0x088fe20000410000ULL,
0x000000110c0c7220ULL, 0x080fe20000410000ULL, 0x0000001109097220ULL, 0x080fe20000410000ULL,
0x0000001108087220ULL, 0x080fe20000410000ULL, 0x0000001105057220ULL, 0x080fe20000410000ULL,
0x0000001144447220ULL, 0x080fe20000410000ULL, 0x0000001147477220ULL, 0x080fe20000410000ULL,
0x0000001148487220ULL, 0x080fe20000410000ULL, 0x000000114b4b7220ULL, 0x080fe20000410000ULL,
0x000000114c4c7220ULL, 0x080fe20000410000ULL, 0x000000114f4f7220ULL, 0x080fe20000410000ULL,
0x0000001150507220ULL, 0x080fe20000410000ULL, 0x0000001153537220ULL, 0x080fe20000410000ULL,
0x0000001154547220ULL, 0x080fe20000410000ULL, 0x0000001157577220ULL, 0x080fe20000410000ULL,
0x0000001158587220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff001fff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000804117811ULL, 0x000fe200078ff0ffULL, 0x0001f3927f007947ULL, 0x000fea000b800000ULL,
0x00001f111c117589ULL, 0x00066400000e0000ULL, 0x000000110b0b7220ULL, 0x082fe20000410000ULL,
0x000000110a0a7220ULL, 0x080fe20000410000ULL, 0x0000001107077220ULL, 0x080fe20000410000ULL,
0x0000001106067220ULL, 0x080fe20000410000ULL, 0x0000001145457220ULL, 0x080fe20000410000ULL,
0x0000001146467220ULL, 0x080fe20000410000ULL, 0x0000001149497220ULL, 0x080fe20000410000ULL,
0x000000114a4a7220ULL, 0x080fe20000410000ULL, 0x000000114d4d7220ULL, 0x080fe20000410000ULL,
0x000000114e4e7220ULL, 0x080fe20000410000ULL, 0x0000001151517220ULL, 0x080fe20000410000ULL,
0x0000001152527220ULL, 0x080fe20000410000ULL, 0x0000001155557220ULL, 0x080fe20000410000ULL,
0x0000001156567220ULL, 0x080fe20000410000ULL, 0x0000001159597220ULL, 0x080fe20000410000ULL,
0x000000115a5a7220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff22ff7812ULL, 0x000fda000780601fULL, 0x8000001d1e1e0221ULL, 0x000fe20000010000ULL,
0x00007610ff170816ULL, 0x000fc60000000017ULL, 0x3fb8aa3b1e1e0820ULL, 0x000fc80000410000ULL,
0x0000001e00180308ULL, 0x000e640000000800ULL, 0x000000181b1b0220ULL, 0x006fcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000e1b0e7221ULL, 0x004fe20000010000ULL,
0x000000ffff117224ULL, 0x000fc400078e001dULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff17ff7812ULL, 0x000fe2000782c0ffULL, 0x0000014000017945ULL, 0x000fd80003800000ULL,
0x0000012000001947ULL, 0x000fea0003800000ULL, 0x00000018ff19723eULL, 0x000fe400000010ffULL,
0x00000002ff1c7819ULL, 0x00afe40000011604ULL, 0x00005410191b7816ULL, 0x000fe20000000019ULL,
0x0001f1c27f007947ULL, 0x000fea000b800000ULL, 0x00001f1c1b197589ULL, 0x0002e400000e0000ULL,
0x000000081c1a7810ULL, 0x000fe20007ffe0ffULL, 0x0001f1f27f007947ULL, 0x000fea000b800000ULL,
0x00001f1a1b1a7589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000101c277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e001bULL,
0x0000398000207802ULL, 0x000fc40000000f00ULL, 0x0002006000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000181c277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x004fe200078e001bULL, 0x000039d000207802ULL, 0x000fc40000000f00ULL,
0x0002001000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000008041d7812ULL, 0x002fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004ff1b7819ULL, 0x100fe20000011604ULL, 0x0000199000017945ULL, 0x000fe20003800000ULL,
0x000000071d707812ULL, 0x004fc400078ef804ULL, 0x00000007041f7812ULL, 0x000fe200078ec0ffULL,
0x0000000461737824ULL, 0x000fe200078e021bULL, 0x0000001070267812ULL, 0x040fe200078efcffULL,
0x00000010701d7824ULL, 0x040fe200078e00ffULL, 0x000000081f6c7812ULL, 0x000fe200078ef804ULL,
0x00000001701c7824ULL, 0x008fe200078e0273ULL, 0x0000000261247811ULL, 0x000fe200078e10ffULL,
0x00000001736b7824ULL, 0x000fe200078e0226ULL, 0x000000125b00720cULL, 0x000fe20003fc3070ULL,
0x00000010261e7824ULL, 0x040fe200078e00ffULL, 0xfffffff01d1c7812ULL, 0x000fe200078ee21cULL,
0x000000011b6d7824ULL, 0x040fe200078e026cULL, 0x00000024266a7210ULL, 0x000fe20007ffe01bULL,
0x000000011b6f7824ULL, 0x000fe200078e0224ULL, 0x0000c0001c1c7811ULL, 0x000fe200078e20ffULL,
0x0000001070287824ULL, 0x000fe200078e00ffULL, 0xfffffff01e6b7812ULL, 0x000fe200078ee26bULL,
0x000000086c1e7824ULL, 0x000fe200078e00ffULL, 0x000000026d277810ULL, 0x000fe20007ffe0ffULL,
0x000000001c2c783bULL, 0x000e620000004200ULL, 0x0000c0006b1d7811ULL, 0x000fe200078e20ffULL,
0x0000000170677824ULL, 0x000fe200078e026fULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee26dULL,
0x0000001026257824ULL, 0x000fe200078e00ffULL, 0x000000125b00720cULL, 0x000fe20003f03070ULL,
0x000000001d20783bULL, 0x000fe20000004200ULL, 0x0000a0001e3c7811ULL, 0x000fc400078e20ffULL,
0xfffffff028677812ULL, 0x000fe200078ee267ULL, 0x000000086c287824ULL, 0x000fe200078e00ffULL,
0xfffffff0256a7812ULL, 0x000fe400078ee26aULL, 0x000000003c3c783bULL, 0x000ea20000000200ULL,
0x0000c00067677811ULL, 0x000fe400078e20ffULL, 0x0000c0006a667811ULL, 0x000fe400078e20ffULL,
0x000000ff2c1f7812ULL, 0x002fe400078ec0ffULL, 0x00000010ff247819ULL, 0x000fc4000001162cULL,
0x0000001fff25723eULL, 0x000fe400020006ffULL, 0xfffffff8281f7812ULL, 0x000fe400078ee227ULL,
0x00000010ff267819ULL, 0x000fe2000001162dULL, 0x20000025ff257230ULL, 0x000fe20000004100ULL,
0x0000a0001f347811ULL, 0x000fe400078e20ffULL, 0x000000ff2d277812ULL, 0x000fe200078ec0ffULL,
0x000000193c3c9231ULL, 0x084fe200003400ffULL, 0x000000ff24247812ULL, 0x000fe200078ec0ffULL,
0x000000193e3e9231ULL, 0x000fe200003400ffULL, 0x000000ff26267812ULL, 0x000fe200078ec0ffULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0x00000027ff27723eULL, 0x000fe200020006ffULL,
0x0000001a3d3d9231ULL, 0x080fe200003400ffULL, 0x00000024ff24723eULL, 0x000fe200020006ffULL,
0x0000001a3f3f9231ULL, 0x000fe200003400ffULL, 0x00000026ff26723eULL, 0x000fe200020006ffULL,
0x20000027ff277230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fe20000011625ULL,
0x20000024ff247230ULL, 0x000fe20000004100ULL, 0x000000ff20287812ULL, 0x000fe200078ec0ffULL,
0x20000026ff267230ULL, 0x000fe20000004100ULL, 0x00000010ff277819ULL, 0x000fc40000011627ULL,
0x00000010ff247819ULL, 0x000fe40000011624ULL, 0x00000010ff267819ULL, 0x000fe40000011626ULL,
0x0000105424307816ULL, 0x000fe40000000025ULL, 0x0000105426317816ULL, 0x000fe40000000027ULL,
0x00000028ff29723eULL, 0x000fe400020006ffULL, 0x00000010ff287819ULL, 0x000fc40000011620ULL,
0x00000010ff2a7819ULL, 0x000fe20000011621ULL, 0x000000303c30723cULL, 0x000f6200000418ffULL,
0x000000ff212b7812ULL, 0x000fe200078ec0ffULL, 0x20000029ff297230ULL, 0x000fe20000004100ULL,
0x000000ff28287812ULL, 0x000fe400078ec0ffULL, 0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL,
0x0000002bff2b723eULL, 0x000fe400020006ffULL, 0x00000028ff28723eULL, 0x000fc400020006ffULL,
0x0000002aff2a723eULL, 0x000fe200020006ffULL, 0x2000002bff2b7230ULL, 0x000fe20000004100ULL,
0x00000018ff247819ULL, 0x000fe2000001162cULL, 0x20000028ff287230ULL, 0x000fe20000004100ULL,
0x00000018ff257819ULL, 0x000fe2000001162dULL, 0x2000002aff397230ULL, 0x000fe20000004100ULL,
0x00000024ff26723eULL, 0x000fe200020006ffULL, 0x0000001934349231ULL, 0x082fe200003400ffULL,
0x00000025ff27723eULL, 0x000fe200020006ffULL, 0x0000001936369231ULL, 0x000fe200003400ffULL,
0x000000ff2e247812ULL, 0x000fe200078ec0ffULL, 0x0000001a35359231ULL, 0x080fe200003400ffULL,
0x000000ff2f257812ULL, 0x000fe200078ec0ffULL, 0x0000001a37379231ULL, 0x000fe200003400ffULL,
0x00000010ff297819ULL, 0x000fe20000011629ULL, 0x20000027ff277230ULL, 0x000fe20000004100ULL,
0x00000010ff387819ULL, 0x000fe2000001162bULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x00000010ff2a7819ULL, 0x000fc40000011628ULL, 0x00000010ff397819ULL, 0x000fe40000011639ULL,
0x00000024ff28723eULL, 0x000fe400020006ffULL, 0x00000025ff2b723eULL, 0x000fe400020006ffULL,
0x000010542a247816ULL, 0x000fe40000000029ULL, 0x0000105439257816ULL, 0x000fe20000000038ULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x00000018ff297819ULL, 0x000fc40000011620ULL,
0x00000018ff2a7819ULL, 0x000fe40000011621ULL, 0x00000029ff38723eULL, 0x000fe200020006ffULL,
0x000000243430723cULL, 0x020be20000041830ULL, 0x20000028ff297230ULL, 0x000fe20000004100ULL,
0x00000010ff287819ULL, 0x000fe4000001162eULL, 0x0000002aff39723eULL, 0x000fe200020006ffULL,
0x20000038ff627230ULL, 0x000fe20000004100ULL, 0x0000ffff20207812ULL, 0x000fe400078ec0ffULL,
0x0000ffff2c247812ULL, 0x020fe200078ec0ffULL, 0x20000039ff637230ULL, 0x000fe20000004100ULL,
0x0000ffff2d257812ULL, 0x000fc400078ec0ffULL, 0x00000008ff247819ULL, 0x000fe40000011624ULL,
0x00000010ff2a7819ULL, 0x000fe4000001162fULL, 0x00000008ff257819ULL, 0x000fe40000011625ULL,
0x000000ff28287812ULL, 0x000fe400078ec0ffULL, 0x00000008ff207819ULL, 0x000fe40000011620ULL,
0x00000024ff24723eULL, 0x000fc400020006ffULL, 0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL,
0x00000025ff25723eULL, 0x000fe200020006ffULL, 0x20000024ff247230ULL, 0x000fe20000004100ULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x0000ffff21217812ULL, 0x000fe200078ec0ffULL,
0x20000025ff257230ULL, 0x000fe20000004100ULL, 0x000000ff223a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff233b7812ULL, 0x000fc400078ec0ffULL, 0x00000020ff20723eULL, 0x000fe400020006ffULL,
0x0000002aff2c723eULL, 0x000fe200020006ffULL, 0x20000028ff2a7230ULL, 0x000fe20000004100ULL,
0x00000008ff217819ULL, 0x000fe20000011621ULL, 0x20000020ff2d7230ULL, 0x000fe20000004100ULL,
0x0000003aff3a723eULL, 0x000fe200020006ffULL, 0x2000002cff2c7230ULL, 0x000fe20000004100ULL,
0x0000003bff3b723eULL, 0x000fe400020006ffULL, 0x00000021ff40723eULL, 0x000fe200020006ffULL,
0x2000003aff647230ULL, 0x000fe20000004100ULL, 0x00000010ff207819ULL, 0x000fe20000011627ULL,
0x2000003bff687230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fe20000011624ULL,
0x000000006638783bULL, 0x000e620000004200ULL, 0x00000010ff257819ULL, 0x000fc40000011625ULL,
0x00000010ff277819ULL, 0x000fe2000001162aULL, 0x20000040ff2a7230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x000fe40000011626ULL, 0x00000010ff287819ULL, 0x000fe40000011629ULL,
0x0000105421407816ULL, 0x000fe40000000024ULL, 0x0000105420417816ULL, 0x000fe40000000025ULL,
0x0000105427287816ULL, 0x000fc40000000028ULL, 0x000000006724783bULL, 0x000ea20000004200ULL,
0x00000010ff297819ULL, 0x000fe4000001162bULL, 0x00000010ff2c7819ULL, 0x000fe2000001162cULL,
0x000000403c40723cULL, 0x000f6200000418ffULL, 0x00000010ff207819ULL, 0x000fe40000011622ULL,
0x000010542c297816ULL, 0x000fe40000000029ULL, 0x00000010ff217819ULL, 0x000fe40000011623ULL,
0x00000010ff2c7819ULL, 0x000fc4000001162dULL, 0x000000ff20207812ULL, 0x000fe400078ec0ffULL,
0x000000ff21217812ULL, 0x000fe400078ec0ffULL, 0x00000010ff2d7819ULL, 0x000fe4000001162aULL,
0x000000283c28723cULL, 0x000f6200000418ffULL, 0x00000020ff65723eULL, 0x000fe400020006ffULL,
0x00000021ff69723eULL, 0x000fe400020006ffULL, 0x00000010ff207819ULL, 0x000fe20000011663ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff217819ULL, 0x000fe20000011662ULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00001054202d7816ULL, 0x000fc4000000002dULL,
0x00001054212c7816ULL, 0x000fe4000000002cULL, 0x00000018ff207819ULL, 0x000fe4000001162eULL,
0x0000ffff2e6e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff217819ULL, 0x000fe40000011668ULL, 0x00000010ff657819ULL, 0x000fc40000011665ULL,
0x00000010ff2e7819ULL, 0x000fe40000011669ULL, 0x00000020ff62723eULL, 0x000fe400020006ffULL,
0x0000105465207816ULL, 0x000fe40000000064ULL, 0x000010542e217816ULL, 0x000fe20000000021ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000018ff637819ULL, 0x000fe4000001162fULL,
0x0000ffff2f687812ULL, 0x000fc400078ec0ffULL, 0x0000002c342c723cULL, 0x060be20000041840ULL,
0x0000ffff22647812ULL, 0x000fe400078ec0ffULL, 0x0000ffff23767812ULL, 0x000fe400078ec0ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x000000ff39427812ULL, 0x022fe200078ec0ffULL,
0x000000203428723cULL, 0x000be20000041828ULL, 0x000000ff38417812ULL, 0x000fe200078ec0ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000042ff75723eULL, 0x000fc400020006ffULL,
0x00000018ff427819ULL, 0x000fe40000011622ULL, 0x000000ff24207812ULL, 0x024fe200078ec0ffULL,
0x20000075ff7b7230ULL, 0x000fe20000004100ULL, 0x000000ff25227812ULL, 0x000fe400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011623ULL, 0x00000020ff21723eULL, 0x000fe400020006ffULL,
0x00000041ff74723eULL, 0x000fc400020006ffULL, 0x00000022ff41723eULL, 0x000fe200020006ffULL,
0x20000021ff237230ULL, 0x000fe20000004100ULL, 0x00000040ff69723eULL, 0x000fe200020006ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000010ff407819ULL, 0x000fe20000011625ULL,
0x20000041ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff227819ULL, 0x000fe40000011624ULL,
0x00000008ff217819ULL, 0x000fe40000011668ULL, 0x000000ff40417812ULL, 0x000fc400078ec0ffULL,
0x000000ff22227812ULL, 0x000fe400078ec0ffULL, 0x00000021ff21723eULL, 0x000fe400020006ffULL,
0x00000008ff207819ULL, 0x000fe2000001166eULL, 0x20000069ff6e7230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000022ff40723eULL, 0x000fe200020006ffULL,
0x20000021ff227230ULL, 0x000fe20000004100ULL, 0x00000020ff20723eULL, 0x000fc400020006ffULL,
0x00000008ff217819ULL, 0x000fe20000011664ULL, 0x20000041ff647230ULL, 0x000fe20000004100ULL,
0x00000042ff65723eULL, 0x000fe200020006ffULL, 0x20000040ff427230ULL, 0x000fe20000004100ULL,
0x00000010ff417819ULL, 0x000fe20000011638ULL, 0x20000020ff207230ULL, 0x000fe20000004100ULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x20000065ff687230ULL, 0x000fe20000004100ULL,
0x00000008ff407819ULL, 0x000fe40000011676ULL, 0x000000ff41417812ULL, 0x000fe200078ec0ffULL,
0x20000021ff657230ULL, 0x000fe20000004100ULL, 0x00000040ff40723eULL, 0x000fc400020006ffULL,
0x00000010ff217819ULL, 0x000fe40000011662ULL, 0x00000010ff207819ULL, 0x000fe20000011620ULL,
0x20000040ff697230ULL, 0x000fe20000004100ULL, 0x00000041ff75723eULL, 0x000fe400020006ffULL,
0x00000010ff417819ULL, 0x000fe40000011663ULL, 0x00000010ff227819ULL, 0x000fe40000011622ULL,
0x00000010ff627819ULL, 0x000fc40000011639ULL, 0x0000105421407816ULL, 0x000fe40000000020ULL,
0x00000010ff207819ULL, 0x000fe40000011623ULL, 0x00000010ff217819ULL, 0x000fe40000011642ULL,
0x0000105441417816ULL, 0x000fe40000000022ULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff647819ULL, 0x000fc40000011664ULL, 0x000000ff62627812ULL, 0x000fe400078ec0ffULL,
0x0000105421207816ULL, 0x000fe40000000020ULL, 0x0000105464217816ULL, 0x000fe40000000043ULL,
0x00000062ff22723eULL, 0x000fe200020006ffULL, 0x000000403c40723cULL, 0x000fe200000418ffULL,
0x00000010ff237819ULL, 0x000fe40000011668ULL, 0x00000010ff627819ULL, 0x000fe20000011665ULL,
0x20000022ff7c7230ULL, 0x000fe20000004100ULL, 0x00000010ff6e7819ULL, 0x000fe2000001166eULL,
0x20000075ff657230ULL, 0x000fe20000004100ULL, 0x0000105423627816ULL, 0x000fc40000000062ULL,
0x000000203c20723cULL, 0x000f6200000418ffULL, 0x00000010ff637819ULL, 0x000fe40000011669ULL,
0x00000010ff647819ULL, 0x000fe40000011674ULL, 0x000010546e637816ULL, 0x000fe40000000063ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff7c7819ULL, 0x000fc4000001167cULL, 0x00000010ff687819ULL, 0x100fe40000011627ULL,
0x0000ffff24807812ULL, 0x000fe400078ec0ffULL, 0x0000105465647816ULL, 0x000fe40000000064ULL,
0x0000ffff25817812ULL, 0x000fe400078ec0ffULL, 0x00000018ff797819ULL, 0x000fe40000011627ULL,
0x000010547c657816ULL, 0x000fc4000000007bULL, 0x00000018ff697819ULL, 0x000fe40000011624ULL,
0x00000018ff757819ULL, 0x000fe40000011625ULL, 0x00000010ff767819ULL, 0x100fe20000011626ULL,
0x000000643420723cULL, 0x020fe20000041820ULL, 0x000000ff26787812ULL, 0x040fe400078ec0ffULL,
0x00000018ff777819ULL, 0x000fe40000011626ULL, 0x0000ffff266e7812ULL, 0x000fc400078ec0ffULL,
0x000000ff277a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff27747812ULL, 0x000fe400078ec0ffULL,
0x000000ff68687812ULL, 0x000fe200078ec0ffULL, 0x000000623424723cULL, 0x000be20000041840ULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x00000008ff6e7819ULL, 0x000fe4000001166eULL,
0x00000068ff68723eULL, 0x000fc400020006ffULL, 0x00000008ff437819ULL, 0x020fe40000011680ULL,
0x00000008ff627819ULL, 0x000fe40000011681ULL, 0x00000069ff41723eULL, 0x000fe400020006ffULL,
0x0000ffff38827812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7d7819ULL, 0x000fe2000001163aULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x00000043ff63723eULL, 0x000fc400020006ffULL,
0x00000075ff42723eULL, 0x000fe400020006ffULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000062ff65723eULL, 0x000fe200020006ffULL,
0x20000079ff627230ULL, 0x000fe20000004100ULL, 0x000000ff76767812ULL, 0x000fe200078ec0ffULL,
0x20000068ff797230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000018ff7b7819ULL, 0x000fe20000011638ULL,
0x20000078ff387230ULL, 0x000fe20000004100ULL, 0x000000ff3a7e7812ULL, 0x000fe200078ec0ffULL,
0x2000006eff787230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fc400020006ffULL,
0x00000008ff687819ULL, 0x000fe40000011682ULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x00000018ff7c7819ULL, 0x000fe40000011639ULL, 0x0000ffff39837812ULL, 0x000fe400078ec0ffULL,
0x00000010ff407819ULL, 0x000fe4000001163bULL, 0x00000076ff75723eULL, 0x000fe200020006ffULL,
0x20000065ff767230ULL, 0x000fe20000004100ULL, 0x00000010ff397819ULL, 0x000fc4000001163aULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x0000007bff65723eULL, 0x000fe400020006ffULL,
0x0000007eff6e723eULL, 0x000fe200020006ffULL, 0x2000007aff437230ULL, 0x000fe20000004100ULL,
0x00000068ff7b723eULL, 0x000fe200020006ffULL, 0x2000007dff687230ULL, 0x000fe20000004100ULL,
0x00000018ff697819ULL, 0x000fe2000001163bULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x000000ff3b7f7812ULL, 0x040fe200078ec0ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x0000ffff3b647812ULL, 0x000fe200078ec0ffULL, 0x20000077ff3b7230ULL, 0x000fe20000004100ULL,
0x000000ff407e7812ULL, 0x000fe200078ec0ffULL, 0x20000075ff777230ULL, 0x000fe20000004100ULL,
0x000000ff397d7812ULL, 0x000fe200078ec0ffULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000010ff417819ULL, 0x000fc40000011641ULL, 0x00000010ff407819ULL, 0x000fe40000011663ULL,
0x00000010ff397819ULL, 0x000fe40000011642ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000008ff747819ULL, 0x000fe40000011674ULL, 0x0000105441407816ULL, 0x000fe40000000040ULL,
0x0000105439417816ULL, 0x000fc40000000076ULL, 0x00000010ff387819ULL, 0x000fe40000011638ULL,
0x00000010ff397819ULL, 0x000fe40000011643ULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x00000010ff427819ULL, 0x000fe40000011679ULL, 0x0000ffff3a3a7812ULL, 0x000fe400078ec0ffULL,
0x00000074ff74723eULL, 0x000fc400020006ffULL, 0x0000105477387816ULL, 0x000fe40000000038ULL,
0x0000105442397816ULL, 0x000fe20000000039ULL, 0x20000074ff7a7230ULL, 0x000fe20000004100ULL,
0x00000008ff3a7819ULL, 0x000fe2000001163aULL, 0x000000403c40723cULL, 0x000fe200000418ffULL,
0x00000010ff3b7819ULL, 0x000fe4000001163bULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff767819ULL, 0x000fc40000011662ULL, 0x0000003aff77723eULL, 0x000fe400020006ffULL,
0x000010543b627816ULL, 0x000fe40000000078ULL, 0x000000383c38723cULL, 0x000f6200000418ffULL,
0x00000008ff747819ULL, 0x000fe20000011683ULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fe4000001167aULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x0000007dff7d723eULL, 0x000fc400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x0000007cff75723eULL, 0x000fe200020006ffULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x00000074ff7c723eULL, 0x000fe200020006ffULL, 0x2000007fff747230ULL, 0x000fe20000004100ULL,
0x0000105476637816ULL, 0x000fe20000000063ULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000008ff767819ULL, 0x000fe20000011664ULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x00000010ff7d7819ULL, 0x000fe2000001167dULL, 0x000000623c3c723cULL, 0x000b6200000418ffULL,
0x00000010ff7e7819ULL, 0x000fe2000001167eULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fc40000011665ULL, 0x00000010ff647819ULL, 0x000fe4000001167bULL,
0x00000010ff627819ULL, 0x020fe4000001166eULL, 0x00000010ff637819ULL, 0x000fe40000011674ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x000010547d627816ULL, 0x000fc40000000062ULL, 0x000010547e637816ULL, 0x000fe40000000063ULL,
0x0000105465647816ULL, 0x000fe40000000064ULL, 0x0000105475657816ULL, 0x000fe4000000007cULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x000000623438723cULL, 0x000b620000041838ULL,
0x00000010ff757819ULL, 0x000fe40000011669ULL, 0x00000002ff697819ULL, 0x000fe20000011604ULL,
0x20000076ff767230ULL, 0x000fc60000004100ULL, 0x0000000172627810ULL, 0x020fe20007ffe0ffULL,
0x000000643440723cULL, 0x000b620000041840ULL, 0x000000726900720cULL, 0x040fe40003f46070ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x000000626900720cULL, 0x000fe40005746470ULL,
0x00000010ff657819ULL, 0x020fe40000011668ULL, 0x00000010ff647819ULL, 0x000fc40000011677ULL,
0x0000000869687810ULL, 0x000fe40007ffe0ffULL, 0x0000105465647816ULL, 0x000fe40000000064ULL,
0x0000105475657816ULL, 0x000fe40000000076ULL, 0x000000726800720cULL, 0x000fc80003f66070ULL,
0x000000626800720cULL, 0x000fe20005f66470ULL, 0x00000064343c723cULL, 0x000b62000004183cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000300d0d7221ULL, 0x000fe20000010000ULL, 0x000000310c0c7221ULL, 0x000fe20000010000ULL,
0x0000002c09097221ULL, 0x000fe20000010000ULL, 0x0000002d08087221ULL, 0x000fe20000010000ULL,
0x0000002805057221ULL, 0x000fe20000010000ULL, 0x0000002944447221ULL, 0x000fe20000010000ULL,
0x0000002447477221ULL, 0x000fe20000010000ULL, 0x0000002548487221ULL, 0x000fe20000010000ULL,
0x000000204b4b7221ULL, 0x000fe20000010000ULL, 0x000000214c4c7221ULL, 0x000fe20000010000ULL,
0x000000404f4f7221ULL, 0x000fe20000010000ULL, 0x0000004150507221ULL, 0x000fe20000010000ULL,
0x0000003853537221ULL, 0x000fe20000010000ULL, 0x0000003954547221ULL, 0x000fe20000010000ULL,
0x0000003c57577221ULL, 0x020fe20000010000ULL, 0x0000003d58587221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0000000000ULL, 0x000000320b0b7221ULL, 0x000fe20000010000ULL,
0x000000330a0a7221ULL, 0x000fe20000010000ULL, 0x0000002e07077221ULL, 0x000fe20000010000ULL,
0x0000002f06067221ULL, 0x000fe20000010000ULL, 0x0000002a45457221ULL, 0x000fe20000010000ULL,
0x0000002b46467221ULL, 0x000fe20000010000ULL, 0x0000002649497221ULL, 0x000fe20000010000ULL,
0x000000274a4a7221ULL, 0x000fe20000010000ULL, 0x000000224d4d7221ULL, 0x000fe20000010000ULL,
0x000000234e4e7221ULL, 0x000fe20000010000ULL, 0x0000004251517221ULL, 0x000fe20000010000ULL,
0x0000004352527221ULL, 0x000fe20000010000ULL, 0x0000003a55557221ULL, 0x000fe20000010000ULL,
0x0000003b56567221ULL, 0x000fe20000010000ULL, 0x0000003e59597221ULL, 0x020fe20000010000ULL,
0x0000003f5a5a7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff207f8cULL, 0x000e62000c80043fULL,
0x00000002ff237819ULL, 0x000fe20000011662ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x000000125b00720cULL, 0x000fc40003f03070ULL, 0x0000000362227812ULL, 0x040fe400078ec0ffULL,
0x0000002362257207ULL, 0x000fe40002800000ULL, 0x000000125b00720cULL, 0x000fe40003fc3070ULL,
0x00000001ff2b7803ULL, 0x000fe40000000000ULL, 0x000000ff22227207ULL, 0x000fe40006800000ULL,
0x0000000325237812ULL, 0x000fc400078ec0ffULL, 0x0000001225247211ULL, 0x000fe200078ff0ffULL,
0x000000ffff287224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010b8400ff267984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000026ff7812ULL, 0x002fe20007804871ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002620267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e21ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011427ULL, 0x0000002625257211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x0000000225257819ULL, 0x000fc80000001226ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8400ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804871ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fc40000015200ULL,
0x010b8c00ff257984ULL, 0x000e620000000800ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000025ff7812ULL, 0x002fe20007804828ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002620267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e21ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011427ULL,
0x0000002625257211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000225257819ULL, 0x000fc80000001226ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000124207810ULL, 0x000fe20007ffe0ffULL, 0x0000097000017945ULL, 0x000fe60003800000ULL,
0x0000005d2000720cULL, 0x000fda0003f06070ULL, 0x0000051000008947ULL, 0x000fea0003800000ULL,
0x000000015c297824ULL, 0x000fe200078e021bULL, 0x000000021b337810ULL, 0x000fe20007ffe0ffULL,
0x0000001004267824ULL, 0x000fe400078e00ffULL, 0x00000040032a7824ULL, 0x000fe200078e0229ULL,
0x010a000029257984ULL, 0x000e620000004800ULL, 0x00000100ff2d7424ULL, 0x000fe200078e00ffULL,
0x000000f0262f7812ULL, 0x000fe200078ec0ffULL, 0x0000000424267824ULL, 0x000fe400078e0223ULL,
0x0000001029277824ULL, 0x000fc400078e00ffULL, 0x0000004026267824ULL, 0x000fe400078e00ffULL,
0x000000015c357824ULL, 0x020fc800078e0233ULL, 0x00000001352c7824ULL, 0x040fe400078e0204ULL,
0x0000001035357824ULL, 0x000fca00078e00ffULL, 0xfffffff0352c7812ULL, 0x000fe200078ee22cULL,
0x010ac00025257984ULL, 0x002e640000004800ULL, 0x0000002514207224ULL, 0x002fe200078e022aULL,
0x000000265f257217ULL, 0x000fc60007800000ULL, 0x00005e0020207625ULL, 0x000fc800078e002dULL,
0x0000000125257824ULL, 0x000fe200078e0a26ULL, 0x0000002f20207210ULL, 0x000fe20007f1e0ffULL,
0x0000000129267824ULL, 0x000fc600078e0204ULL, 0x000000255c257217ULL, 0x000fe20007800000ULL,
0x000000ffff217224ULL, 0x000fe200000e0621ULL, 0xfffffff027267812ULL, 0x000fc600078ee226ULL,
0x0000000125287824ULL, 0x000fe200078e0a5cULL, 0x0000c00026317811ULL, 0x000fe400078e20ffULL,
0x000000022a267810ULL, 0x000fe40007ffe0ffULL, 0x000000281b00720cULL, 0x000fda0003f06070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020317faeULL, 0x0003e8000c101c46ULL,
0x010a080029257984ULL, 0x000ea20000004800ULL, 0x0000c0002c317811ULL, 0x002fe400078e20ffULL,
0x000000042a207810ULL, 0x000fe20007ffe0ffULL, 0x010ac00025257984ULL, 0x004e640000004800ULL,
0x0000002514267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x000000283300720cULL, 0x000fe40003f06070ULL, 0x000000041b337810ULL, 0x000fca0007ffe0ffULL,
0x000000015c357824ULL, 0x000fc800078e0233ULL, 0x00000001352c7824ULL, 0x040fe400078e0204ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026317faeULL, 0x0003e2000c101c46ULL,
0x0000001035357824ULL, 0x000fc600078e00ffULL, 0x010a100029257984ULL, 0x000ea40000004800ULL,
0xfffffff0352c7812ULL, 0x000fc800078ee22cULL, 0x0000c0002c317811ULL, 0x002fe400078e20ffULL,
0x000000062a267810ULL, 0x000fe20007ffe0ffULL, 0x010ac00025257984ULL, 0x004e640000004800ULL,
0x0000002514207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e002dULL,
0x0000002f20207210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff217224ULL, 0x000fe200000e0621ULL,
0x000000283300720cULL, 0x000fda0003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020317faeULL, 0x0003e8000c101c46ULL, 0x010a180029257984ULL, 0x000ea80000004800ULL,
0x010ac00025257984ULL, 0x004ea40000004800ULL, 0x0000002514267224ULL, 0x004fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fe200078e002dULL, 0x000000061b2d7810ULL, 0x000fc80007ffe0ffULL,
0x0000002f26267210ULL, 0x000fe20007f1e0ffULL, 0x000000015c2f7824ULL, 0x000fc800078e022dULL,
0x000000012f2a7824ULL, 0x000fe400078e0204ULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x000000282d00720cULL, 0x000fe20003f06070ULL, 0x000000102f2f7824ULL, 0x000fca00078e00ffULL,
0xfffffff02f2a7812ULL, 0x000fc800078ee22aULL, 0x0000c0002a217811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026217faeULL, 0x0003e2000c101c46ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x000000015c2c7824ULL, 0x000fe400078e021bULL,
0x00000100ff2e7424ULL, 0x000fe400078e00ffULL, 0x00000040032d7824ULL, 0x000fe200078e022cULL,
0x010a00002c257984ULL, 0x000e620000004800ULL, 0x0000001004267824ULL, 0x000fca00078e00ffULL,
0x000000f0262f7812ULL, 0x000fe200078ec0ffULL, 0x010ac00025257984ULL, 0x002e640000004800ULL,
0x0000002514207224ULL, 0x002fe200078e022dULL, 0x000000022c257810ULL, 0x000fc60007ffe0ffULL,
0x00005e0020207625ULL, 0x000fc800078e002eULL, 0x0000000125297824ULL, 0x140fe200078e0204ULL,
0x0000002f20267210ULL, 0x000fe20007f1e0ffULL, 0x000000012c207824ULL, 0x040fe400078e0204ULL,
0x00000010252a7824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fe400000e0621ULL,
0x000000102c217824ULL, 0x000fe200078e00ffULL, 0xfffffff02a297812ULL, 0x000fc800078ee229ULL,
0xfffffff021207812ULL, 0x000fe400078ee220ULL, 0x0000c00029297811ULL, 0x000fe400078e20ffULL,
0x0000c00020317811ULL, 0x000fe400078e20ffULL, 0x000000022d207810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026317faeULL, 0x0003e8000b901c46ULL,
0x010a08002c287984ULL, 0x000ea20000004800ULL, 0x000000042d267810ULL, 0x042fe40007ffe0ffULL,
0x000000062d2d7810ULL, 0x000fe20007ffe0ffULL, 0x010ac00028217984ULL, 0x004e640000004800ULL,
0x0000002114217224ULL, 0x002fc800078e0220ULL, 0x00005e0021207625ULL, 0x000fca00078e002eULL,
0x0000002f20207210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020297faeULL, 0x0003e8000b901c46ULL,
0x010a10002c287984ULL, 0x000ea20000004800ULL, 0x000000062c297810ULL, 0x002fc60007ffe0ffULL,
0x010ac00028257984ULL, 0x004e640000004800ULL, 0x0000002514257224ULL, 0x002fc800078e0226ULL,
0x00005e0025267625ULL, 0x000fe200078e002eULL, 0x000000042c257810ULL, 0x000fc80007ffe0ffULL,
0x0000002f26267210ULL, 0x000fe20007f1e0ffULL, 0x00000001252a7824ULL, 0x040fe400078e0204ULL,
0x0000001025257824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fc600000e0627ULL,
0xfffffff0252a7812ULL, 0x000fc800078ee22aULL, 0x0000c0002a257811ULL, 0x000fe200078e20ffULL,
0x00000001292a7824ULL, 0x040fe400078e0204ULL, 0x0000001029297824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026257faeULL, 0x0003e6000b901c46ULL,
0xfffffff0292a7812ULL, 0x000fe200078ee22aULL, 0x010a18002c287984ULL, 0x000ea60000004800ULL,
0x0000c0002a257811ULL, 0x002fe200078e20ffULL, 0x010ac00028217984ULL, 0x004e640000004800ULL,
0x0000002114217224ULL, 0x002fc800078e022dULL, 0x00005e0021207625ULL, 0x000fca00078e002eULL,
0x0000002f20207210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e6000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x002e64000c80043fULL, 0x000000ffff287224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b8c00ff257984ULL, 0x000e620000000800ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000025ff7812ULL, 0x002fe20007804828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002620267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e21ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011427ULL, 0x0000002625257211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x0000000225257819ULL, 0x000fc80000001226ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000245b00720cULL, 0x000fc80003f04070ULL,
0x000000ff22207207ULL, 0x040fe40000000000ULL, 0x000000ff22217207ULL, 0x000fc60004000000ULL,
0x0000000123237824ULL, 0x000fe400078e0220ULL, 0x0000000160217824ULL, 0x000fe400078e0221ULL,
0x0000004023207824ULL, 0x040fe200078e00ffULL, 0x0000002423237211ULL, 0x000fc800078ff0ffULL,
0x000000c020207812ULL, 0x000fca00078ec0ffULL, 0x0000010023207824ULL, 0x000fe200078e0220ULL,
0x00010a0015237811ULL, 0x000fc800078e10ffULL, 0x0000002020227810ULL, 0x000fca0007ffe0ffULL,
0x0000680021207a24ULL, 0x100fe400078e0222ULL, 0x0000000115227824ULL, 0x040fe400078e0222ULL,
0x00000004ff217424ULL, 0x000fe400078e00ffULL, 0x0000000115207824ULL, 0x000fe200078e0220ULL,
0x0000005f2200720cULL, 0x000fc60003f06070ULL, 0x0000660020207625ULL, 0x000fd400078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b7800ff207f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x002fe200078e0021ULL,
0x0000010000001947ULL, 0x000fea0003800000ULL, 0x00000018ff19723eULL, 0x000fc800000010ffULL,
0x0000541019227816ULL, 0x000fe20000000019ULL, 0x0001c2927f007947ULL, 0x000fea000b800000ULL,
0x00001f6922197589ULL, 0x0002a400000e0000ULL, 0x0001c2d27f007947ULL, 0x000fea000b800000ULL,
0x00001f68221a7589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001069277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0000696000207802ULL, 0x000fc40000000f00ULL, 0x0001d08000007944ULL, 0x02cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001869277810ULL, 0x002fe40007ffe0ffULL, 0x000069b000207802ULL, 0x000fc40000000f00ULL,
0x0001d03000007944ULL, 0x028fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000170737824ULL, 0x000fe200078e0273ULL, 0x0000e0006a6a7811ULL, 0x000fe200078e20ffULL,
0x00000010706e7824ULL, 0x040fe200078e00ffULL, 0x000000ff2b00720cULL, 0x000fe20003f05270ULL,
0x00000001706f7824ULL, 0x040fe200078e026fULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000001070707824ULL, 0x000fe200078e00ffULL, 0x000000006a28783bULL, 0x000f220000004200ULL,
0x0000e0006b6b7811ULL, 0x000fe200078e20ffULL, 0x000000086c2e7824ULL, 0x000fe200078e00ffULL,
0xfffffff06e6e7812ULL, 0x000fe200078ee273ULL, 0x000000086c2f7824ULL, 0x000fe200078e00ffULL,
0xfffffff0702d7812ULL, 0x000fe200078ee26fULL, 0x000000006b24783bULL, 0x006e620000004200ULL,
0x000000046d6f7810ULL, 0x040fe20007ffe0ffULL, 0x0000176000017945ULL, 0x000fe20003800000ULL,
0x000000066d2c7810ULL, 0x000fc40007ffe0ffULL, 0x0000e0002d6d7811ULL, 0x000fe400078e20ffULL,
0x0000e0006e6e7811ULL, 0x000fe400078e20ffULL, 0xfffffff82e6f7812ULL, 0x000fe400078ee26fULL,
0xfffffff82f6c7812ULL, 0x000fe200078ee22cULL, 0x000000006e20783bULL, 0x008fe80000004200ULL,
0x000000006d2c783bULL, 0x000ea20000004200ULL, 0x00000018ff407819ULL, 0x010fc40000011628ULL,
0x000000ff29427812ULL, 0x000fe400078ec0ffULL, 0x00000040ff8b723eULL, 0x000fe400020006ffULL,
0x00000018ff417819ULL, 0x000fe40000011629ULL, 0x0000a0006f407811ULL, 0x000fe200078e20ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00000010ff327819ULL, 0x002fe40000011626ULL,
0x000000ff26887812ULL, 0x000fc400078ec0ffULL, 0x00000018ff8a7819ULL, 0x000fe40000011626ULL,
0x0000ffff26737812ULL, 0x000fe400078ec0ffULL, 0x00000010ff267819ULL, 0x000fe40000011628ULL,
0x00000010ff757819ULL, 0x100fe4000001162bULL, 0x000000ff2b787812ULL, 0x000fe400078ec0ffULL,
0x00000018ff777819ULL, 0x000fc4000001162bULL, 0x0000ffff2b707812ULL, 0x000fe400078ec0ffULL,
0x00000010ff867819ULL, 0x104fe4000001162fULL, 0x000000ff2f7b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2f877812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7a7819ULL, 0x000fe4000001162fULL,
0x00000042ff2b723eULL, 0x000fc400020006ffULL, 0x00000041ff2f723eULL, 0x000fe400020006ffULL,
0x000000004040783bULL, 0x000e620000000200ULL, 0x00000010ff637819ULL, 0x100fe20000011623ULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x000000ff23817812ULL, 0x040fe400078ec0ffULL,
0x00000018ff827819ULL, 0x000fe40000011623ULL, 0x0000ffff233f7812ULL, 0x020fe400078ec0ffULL,
0x000000ff26267812ULL, 0x000fc400078ec0ffULL, 0x000000ff28237812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8c7819ULL, 0x000fe40000011629ULL, 0x00000010ff307819ULL, 0x100fe40000011620ULL,
0x000000ff207c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff747819ULL, 0x000fe40000011620ULL,
0x0000ffff20347812ULL, 0x000fc400078ec0ffULL, 0x00000010ff397819ULL, 0x100fe40000011622ULL,
0x000000ff22627812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7f7819ULL, 0x000fe40000011622ULL,
0x0000ffff22807812ULL, 0x000fe400078ec0ffULL, 0x0000ffff288e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff797819ULL, 0x000fc4000001162aULL, 0x000000ff2a227812ULL, 0x040fe400078ec0ffULL,
0x00000018ff207819ULL, 0x000fe4000001162aULL, 0x0000ffff2a767812ULL, 0x000fe200078ec0ffULL,
0x0000001940409231ULL, 0x082fe200003400ffULL, 0x00000026ff26723eULL, 0x000fe200020006ffULL,
0x0000001942429231ULL, 0x000fe200003400ffULL, 0x00000010ff387819ULL, 0x100fe20000011625ULL,
0x0000001a41419231ULL, 0x080fe200003400ffULL, 0x000000ff253e7812ULL, 0x000fe200078ec0ffULL,
0x0000001a43439231ULL, 0x000fe200003400ffULL, 0x00000018ff3c7819ULL, 0x000fc40000011625ULL,
0x0000ffff25367812ULL, 0x000fe400078ec0ffULL, 0x00000023ff2a723eULL, 0x000fe400020006ffULL,
0x000000ff8c8f7812ULL, 0x000fe200078ec0ffULL, 0x2000002fff8c7230ULL, 0x000fe20000004100ULL,
0x00000010ff287819ULL, 0x000fe2000001162cULL, 0x2000002aff2a7230ULL, 0x000fe20000004100ULL,
0x000000ff2c237812ULL, 0x040fe400078ec0ffULL, 0x0000ffff2c257812ULL, 0x000fc400078ec0ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001162cULL, 0x00000010ff847819ULL, 0x100fe4000001162eULL,
0x000000ff2e7d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff2e857812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001162eULL, 0x00000008ff2e7819ULL, 0x000fe2000001168eULL,
0x20000026ff8e7230ULL, 0x000fe20000004100ULL, 0x0000008fff8f723eULL, 0x000fc400020006ffULL,
0x00000010ff317819ULL, 0x100fe40000011621ULL, 0x000000ff21837812ULL, 0x040fe400078ec0ffULL,
0x00000018ff357819ULL, 0x000fe40000011621ULL, 0x0000ffff213a7812ULL, 0x000fe400078ec0ffULL,
0x00000023ff26723eULL, 0x000fe200020006ffULL, 0x2000008fff237230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fc40000011627ULL, 0x000000ff27897812ULL, 0x040fe200078ec0ffULL,
0x20000026ff8f7230ULL, 0x000fe20000004100ULL, 0x00000018ff217819ULL, 0x000fe40000011627ULL,
0x0000ffff27657812ULL, 0x000fe400078ec0ffULL, 0x0000002cff2c723eULL, 0x000fe400020006ffULL,
0x00000010ff277819ULL, 0x000fe4000001162dULL, 0x00000010ff377819ULL, 0x000fe20000011624ULL,
0x2000002cff267230ULL, 0x000fe20000004100ULL, 0x000000ff243d7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff3b7819ULL, 0x000fe40000011624ULL, 0x0000ffff24337812ULL, 0x000fe400078ec0ffULL,
0x000000ff2d8d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff2d247812ULL, 0x000fe400078ec0ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001162dULL, 0x000000ff28287812ULL, 0x000fc400078ec0ffULL,
0x0000002eff2f723eULL, 0x000fe400020006ffULL, 0x000000ff27277812ULL, 0x000fe400078ec0ffULL,
0x0000008dff2e723eULL, 0x000fe200020006ffULL, 0x2000002fff8d7230ULL, 0x000fe20000004100ULL,
0x0000a0006c2c7811ULL, 0x000fe400078e20ffULL, 0x00000008ff257819ULL, 0x000fe20000011625ULL,
0x2000002eff907230ULL, 0x000fe20000004100ULL, 0x0000002dff92723eULL, 0x000fc400020006ffULL,
0x00000028ff28723eULL, 0x000fe200020006ffULL, 0x000000002c2c783bULL, 0x000e620000000200ULL,
0x00000027ff91723eULL, 0x000fe200020006ffULL, 0x20000092ff937230ULL, 0x000fe20000004100ULL,
0x00000008ff247819ULL, 0x000fe20000011624ULL, 0x20000028ff287230ULL, 0x000fe20000004100ULL,
0x00000025ff25723eULL, 0x000fe200020006ffULL, 0x20000091ff917230ULL, 0x000fe20000004100ULL,
0x0000ffff29297812ULL, 0x000fe400078ec0ffULL, 0x00000024ff92723eULL, 0x000fe200020006ffULL,
0x20000025ff277230ULL, 0x000fe20000004100ULL, 0x00000008ff297819ULL, 0x000fc40000011629ULL,
0x00000010ff247819ULL, 0x000fe2000001168fULL, 0x20000092ff927230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe40000011628ULL, 0x00000010ff907819ULL, 0x000fe40000011690ULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x00000029ff28723eULL, 0x000fe400020006ffULL,
0x0000105425247816ULL, 0x000fc40000000024ULL, 0x0000105491257816ULL, 0x000fe20000000090ULL,
0x20000028ff917230ULL, 0x000fe20000004100ULL, 0x00000010ff267819ULL, 0x000fe40000011626ULL,
0x00000010ff277819ULL, 0x000fe40000011627ULL, 0x00000010ff907819ULL, 0x000fe40000011693ULL,
0x00000010ff297819ULL, 0x000fe40000011692ULL, 0x0000105426287816ULL, 0x000fc40000000027ULL,
0x0000105490297816ULL, 0x000fe20000000029ULL, 0x000000244024723cULL, 0x040fe200000418ffULL,
0x00000010ff927819ULL, 0x000fe2000001162aULL, 0x000000192c2c9231ULL, 0x082fe200003400ffULL,
0x00000010ff947819ULL, 0x000fe2000001162bULL, 0x000000192e2e9231ULL, 0x000fe200003400ffULL,
0x00000010ff937819ULL, 0x000fe2000001168eULL, 0x0000001a2d2d9231ULL, 0x080fe200003400ffULL,
0x00000021ff90723eULL, 0x000fe200020006ffULL, 0x000000284028723cULL, 0x000f6200000418ffULL,
0x00000010ff8e7819ULL, 0x000fe2000001168bULL, 0x0000001a2f2f9231ULL, 0x000fe200003400ffULL,
0x00000010ff8d7819ULL, 0x000fc4000001168dULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff217819ULL, 0x000fe40000011691ULL, 0x00000020ff91723eULL, 0x000fe400020006ffULL,
0x00000010ff237819ULL, 0x000fe40000011623ULL, 0x000010548e207816ULL, 0x000fe4000000008dULL,
0x000010548c217816ULL, 0x000fc40000000021ULL, 0x00000022ff8f723eULL, 0x000fe400020006ffULL,
0x0000105493227816ULL, 0x000fe40000000092ULL, 0x0000105423237816ULL, 0x000fe40000000094ULL,
0x00000035ff35723eULL, 0x000fe200020006ffULL, 0x000000202c28723cULL, 0x020be20000041828ULL,
0x0000007bff8c723eULL, 0x000fe200020006ffULL, 0x20000090ff7b7230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fc400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x00000008ff207819ULL, 0x020fe20000011673ULL, 0x000000222c24723cULL, 0x000be20000041824ULL,
0x0000007cff21723eULL, 0x000fe200020006ffULL, 0x20000091ff737230ULL, 0x000fe20000004100ULL,
0x00000008ff347819ULL, 0x000fe40000011634ULL, 0x0000007dff8e723eULL, 0x000fe200020006ffULL,
0x20000088ff7d7230ULL, 0x000fe20000004100ULL, 0x00000020ff22723eULL, 0x020fe200020006ffULL,
0x20000082ff887230ULL, 0x000fe20000004100ULL, 0x00000077ff23723eULL, 0x000fe200020006ffULL,
0x20000021ff217230ULL, 0x000fe20000004100ULL, 0x00000083ff20723eULL, 0x000fe200020006ffULL,
0x20000022ff7c7230ULL, 0x000fe20000004100ULL, 0x0000007fff22723eULL, 0x000fe200020006ffULL,
0x2000008fff777230ULL, 0x000fe20000004100ULL, 0x000000ff317f7812ULL, 0x000fe200078ec0ffULL,
0x2000008cff317230ULL, 0x000fe20000004100ULL, 0x00000074ff83723eULL, 0x000fe200020006ffULL,
0x20000023ff747230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x20000020ff207230ULL, 0x000fe20000004100ULL, 0x00000062ff23723eULL, 0x000fe200020006ffULL,
0x20000035ff627230ULL, 0x000fe20000004100ULL, 0x000000ff30357812ULL, 0x000fe200078ec0ffULL,
0x2000007fff8c7230ULL, 0x000fe20000004100ULL, 0x000000ff39397812ULL, 0x000fe200078ec0ffULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x000000ff637f7812ULL, 0x000fe200078ec0ffULL,
0x20000023ff237230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x0000007eff8d723eULL, 0x000fc400020006ffULL,
0x00000035ff82723eULL, 0x000fe200020006ffULL, 0x20000089ff7e7230ULL, 0x000fe20000004100ULL,
0x00000034ff34723eULL, 0x000fe200020006ffULL, 0x2000008dff307230ULL, 0x000fe20000004100ULL,
0x00000008ff3f7819ULL, 0x000fe2000001163fULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000039ff39723eULL, 0x000fe200020006ffULL, 0x20000034ff637230ULL, 0x000fe20000004100ULL,
0x00000008ff807819ULL, 0x000fe20000011680ULL, 0x2000008eff897230ULL, 0x000fe20000004100ULL,
0x0000007fff7f723eULL, 0x000fe200020006ffULL, 0x20000039ff8d7230ULL, 0x000fe20000004100ULL,
0x00000008ff3a7819ULL, 0x000fc4000001163aULL, 0x000000ff84847812ULL, 0x000fe200078ec0ffULL,
0x2000007fff8e7230ULL, 0x000fe20000004100ULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000008ff857819ULL, 0x000fe20000011685ULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x00000081ff81723eULL, 0x000fc400020006ffULL, 0x00000080ff34723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x00000084ff39723eULL, 0x000fe200020006ffULL,
0x20000034ff347230ULL, 0x000fe20000004100ULL, 0x0000007aff8b723eULL, 0x000fe200020006ffULL,
0x2000008aff7a7230ULL, 0x000fe20000004100ULL, 0x0000003dff7f723eULL, 0x000fe200020006ffULL,
0x20000081ff8a7230ULL, 0x000fe20000004100ULL, 0x00000008ff877819ULL, 0x000fe20000011687ULL,
0x2000003aff817230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x20000039ff397230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x2000008bff357230ULL, 0x000fe20000004100ULL, 0x00000010ff3d7819ULL, 0x000fe20000011620ULL,
0x20000085ff8b7230ULL, 0x000fe20000004100ULL, 0x00000010ff217819ULL, 0x000fe20000011621ULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000010ff207819ULL, 0x000fc40000011682ULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000087ff3a723eULL, 0x000fe200020006ffULL,
0x20000086ff877230ULL, 0x000fe20000004100ULL, 0x0000105420207816ULL, 0x000fe40000000021ULL,
0x00000010ff887819ULL, 0x000fe20000011688ULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x00000010ff3f7819ULL, 0x000fe4000001163fULL, 0x000010548c217816ULL, 0x000fc4000000003dULL,
0x000000ff37857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3d7819ULL, 0x000fe4000001168aULL,
0x00000010ff377819ULL, 0x000fe40000011622ULL, 0x00000010ff347819ULL, 0x000fe40000011634ULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x00000010ff8a7819ULL, 0x000fc40000011639ULL,
0x0000105488397816ULL, 0x000fe4000000003fULL, 0x000000ff38867812ULL, 0x000fe400078ec0ffULL,
0x00000010ff317819ULL, 0x000fe40000011631ULL, 0x00000010ff887819ULL, 0x000fe40000011687ULL,
0x0000105437387816ULL, 0x000fe40000000034ULL, 0x000010548a347816ULL, 0x000fc40000000089ULL,
0x00000010ff8a7819ULL, 0x000fe40000011635ULL, 0x0000105488357816ULL, 0x000fe40000000031ULL,
0x0000003cff84723eULL, 0x000fe400020006ffULL, 0x00000010ff377819ULL, 0x000fe40000011630ULL,
0x00000010ff887819ULL, 0x000fe20000011662ULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x00000010ff237819ULL, 0x000fc40000011623ULL, 0x00000010ff3c7819ULL, 0x000fe4000001168dULL,
0x00000010ff8e7819ULL, 0x000fe4000001168eULL, 0x00000010ff307819ULL, 0x000fe4000001168bULL,
0x00000010ff877819ULL, 0x000fe4000001163aULL, 0x00000010ff627819ULL, 0x000fe40000011663ULL,
0x00000010ff837819ULL, 0x000fc40000011683ULL, 0x00000010ff637819ULL, 0x000fe40000011681ULL,
0x000010543c3c7816ULL, 0x000fe40000000023ULL, 0x000010548e3d7816ULL, 0x000fe2000000003dULL,
0x000000204020723cULL, 0x000f6200000418ffULL, 0x0000105437307816ULL, 0x000fe40000000030ULL,
0x000010548a317816ULL, 0x000fe40000000087ULL, 0x0000105483627816ULL, 0x000fc40000000062ULL,
0x0000105488637816ULL, 0x000fe40000000063ULL, 0x00000008ff337819ULL, 0x000fe40000011633ULL,
0x0000003eff80723eULL, 0x000fe400020006ffULL, 0x0000003bff82723eULL, 0x000fe200020006ffULL,
0x0000003c403c723cULL, 0x000fe200000418ffULL, 0x00000008ff877819ULL, 0x000fe20000011636ULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000033ff81723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x000000ff32837812ULL, 0x000fc400078ec0ffULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x000000384038723cULL, 0x040fe200000418ffULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x000000ff64647812ULL, 0x000fe200078ec0ffULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x000000ff79887812ULL, 0x000fe200078ec0ffULL, 0x000000344034723cULL, 0x000fe200000418ffULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fc40000011665ULL, 0x00000088ff89723eULL, 0x000fe200020006ffULL,
0x20000064ff887230ULL, 0x000fe20000004100ULL, 0x00000065ff79723eULL, 0x000fe200020006ffULL,
0x000000304030723cULL, 0x040fe200000418ffULL, 0x00000010ff647819ULL, 0x000fe4000001167fULL,
0x00000010ff657819ULL, 0x000fe20000011680ULL, 0x20000079ff7f7230ULL, 0x000fe20000004100ULL,
0x00000010ff857819ULL, 0x000fe20000011685ULL, 0x20000089ff797230ULL, 0x000fe20000004100ULL,
0x00000010ff867819ULL, 0x000fe20000011686ULL, 0x000000624040723cULL, 0x000b6200000418ffULL,
0x00000010ff847819ULL, 0x000fc40000011684ULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x0000105485647816ULL, 0x000fe40000000064ULL, 0x00000010ff637819ULL, 0x020fe40000011682ULL,
0x00000010ff627819ULL, 0x000fe40000011681ULL, 0x0000105486657816ULL, 0x000fe40000000065ULL,
0x00000083ff83723eULL, 0x000fc400020006ffULL, 0x0000105463627816ULL, 0x000fe40000000062ULL,
0x0000105484637816ULL, 0x000fe20000000087ULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x000000642c20723cULL, 0x040b620000041820ULL, 0x00000008ff767819ULL, 0x000fe40000011676ULL,
0x000000ff75757812ULL, 0x000fe400078ec0ffULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff647819ULL, 0x020fe2000001167dULL, 0x000000622c40723cULL, 0x000b620000041840ULL,
0x00000008ff7d7819ULL, 0x000fc40000011670ULL, 0x00000010ff657819ULL, 0x000fe4000001167eULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff637819ULL, 0x020fe4000001167aULL,
0x00000010ff627819ULL, 0x000fe4000001167cULL, 0x00000010ff707819ULL, 0x000fe4000001167bULL,
0x00000010ff7f7819ULL, 0x000fc4000001167fULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x0000105463627816ULL, 0x000fe20000000062ULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x0000105483647816ULL, 0x000fe20000000064ULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x0000105488657816ULL, 0x000fc40000000065ULL,
0x0000105470637816ULL, 0x000fe4000000007fULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x00000010ff707819ULL, 0x000fe20000011675ULL, 0x000000642c3c723cULL, 0x000b62000004183cULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff747819ULL, 0x000fc80000011674ULL,
0x00000010ff647819ULL, 0x020fe20000011677ULL, 0x000000622c38723cULL, 0x000b620000041838ULL,
0x00000010ff657819ULL, 0x000fe40000011678ULL, 0x0000105479647816ULL, 0x000fe40000000064ULL,
0x0000105470657816ULL, 0x000fe40000000065ULL, 0x00000010ff627819ULL, 0x020fe40000011676ULL,
0x00000010ff637819ULL, 0x000fc4000001167dULL, 0x0000105473627816ULL, 0x000fe20000000062ULL,
0x000000642c34723cULL, 0x000b620000041834ULL, 0x0000105474637816ULL, 0x000fce0000000063ULL,
0x000000622c30723cULL, 0x000b620000041830ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0000000000ULL, 0x000000200d0d7221ULL, 0x000fe20000010000ULL,
0x000000210c0c7221ULL, 0x000fe20000010000ULL, 0x0000004009097221ULL, 0x000fe20000010000ULL,
0x0000004108087221ULL, 0x000fe20000010000ULL, 0x0000003c05057221ULL, 0x000fe20000010000ULL,
0x0000003d44447221ULL, 0x000fe20000010000ULL, 0x0000003847477221ULL, 0x000fe20000010000ULL,
0x0000003948487221ULL, 0x000fe20000010000ULL, 0x000000244b4b7221ULL, 0x000fe20000010000ULL,
0x000000254c4c7221ULL, 0x000fe20000010000ULL, 0x000000284f4f7221ULL, 0x000fe20000010000ULL,
0x0000002950507221ULL, 0x000fe20000010000ULL, 0x0000003453537221ULL, 0x020fe20000010000ULL,
0x0000003554547221ULL, 0x000fe20000010000ULL, 0x0000003057577221ULL, 0x000fe20000010000ULL,
0x0000003158587221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0003000000ULL,
0x000000220b0b7221ULL, 0x000fe20000010000ULL, 0x000000230a0a7221ULL, 0x000fe20000010000ULL,
0x0000004207077221ULL, 0x000fe20000010000ULL, 0x0000004306067221ULL, 0x000fe20000010000ULL,
0x0000003e45457221ULL, 0x000fe20000010000ULL, 0x0000003f46467221ULL, 0x000fe20000010000ULL,
0x0000003a49497221ULL, 0x000fe20000010000ULL, 0x0000003b4a4a7221ULL, 0x000fe20000010000ULL,
0x000000264d4d7221ULL, 0x000fe20000010000ULL, 0x000000274e4e7221ULL, 0x000fe20000010000ULL,
0x0000002a51517221ULL, 0x000fe20000010000ULL, 0x0000002b52527221ULL, 0x000fe20000010000ULL,
0x0000003655557221ULL, 0x020fe20000010000ULL, 0x0000003756567221ULL, 0x000fe20000010000ULL,
0x0000003259597221ULL, 0x000fe20000010000ULL, 0x000000335a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000004ff707424ULL, 0x000fe200078e00ffULL,
0x010b8800ff227f8cULL, 0x000e68000c80043fULL, 0x0000000170707807ULL, 0x000fc80006800000ULL,
0x000000707200720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff978000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004012207811ULL, 0x000fe200078e40ffULL, 0x010b5800ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000005f2000720cULL, 0x000fda0003f06070ULL, 0x0001305000000947ULL, 0x000fea0003800000ULL,
0x000000ffff727224ULL, 0x000fca00078e00ffULL, 0x00000002ff217819ULL, 0x000fe20000011672ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000372227812ULL, 0x042fe200078ec0ffULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000002172217207ULL, 0x000fe40002800000ULL,
0x000000ff22227207ULL, 0x000fe40006800000ULL, 0x0000000121257810ULL, 0x000fc80007ffe0ffULL,
0x0000000325217812ULL, 0x040fe400078ec0ffULL, 0x0000001225207211ULL, 0x020fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x010b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000120247810ULL, 0x000fe20007ffe0ffULL,
0x0000099000017945ULL, 0x000fe60003800000ULL, 0x0000005d2400720cULL, 0x000fda0003f06070ULL,
0x0000052000008947ULL, 0x000fea0003800000ULL, 0x000000015c297824ULL, 0x000fe200078e021bULL,
0x00000020032a7811ULL, 0x000fe200078e30ffULL, 0x0000000420247824ULL, 0x000fe200078e0221ULL,
0x000000021b317810ULL, 0x020fe20007ffe0ffULL, 0x0000001004267824ULL, 0x000fe200078e00ffULL,
0x010a000029257984ULL, 0x000e620000004800ULL, 0x00000100ff2b7424ULL, 0x000fe200078e00ffULL,
0x0000002024247811ULL, 0x000fe200078e30ffULL, 0x000000015c337824ULL, 0x000fe200078e0231ULL,
0x000000f0262d7812ULL, 0x000fe200078ec0ffULL, 0x0000001029267824ULL, 0x000fe200078e00ffULL,
0x000000245f237217ULL, 0x000fe20007800000ULL, 0x00000001332c7824ULL, 0x000fc800078e0204ULL,
0x0000000123237824ULL, 0x000fe400078e0a24ULL, 0x0000000129247824ULL, 0x000fc600078e022aULL,
0x000000235c237217ULL, 0x000fca0007800000ULL, 0x0000000123287824ULL, 0x000fe400078e0a5cULL,
0x0000000129237824ULL, 0x000fc600078e0204ULL, 0x000000281b00720cULL, 0x000fe40003f06070ULL,
0xfffffff026237812ULL, 0x000fe200078ee223ULL, 0x0000000133267824ULL, 0x040fe400078e022aULL,
0x0000001033337824ULL, 0x000fe200078e00ffULL, 0x0000e000232f7811ULL, 0x000fc800078e20ffULL,
0xfffffff0332c7812ULL, 0x000fe200078ee22cULL, 0x010ac00025257984ULL, 0x002e640000004800ULL,
0x0000002514247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002bULL,
0x0000002d24247210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e2000c101c46ULL,
0x000000283100720cULL, 0x000fe40003f06070ULL, 0x000000041b317810ULL, 0x000fe20007ffe0ffULL,
0x010a080029237984ULL, 0x000ea80000004800ULL, 0x000000015c337824ULL, 0x000fe200078e0231ULL,
0x0000e0002c2f7811ULL, 0x002fc600078e20ffULL, 0x00000001332c7824ULL, 0x000fe200078e0204ULL,
0x010ac00023237984ULL, 0x004e640000004800ULL, 0x0000002314267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002bULL, 0x0000002d26247210ULL, 0x000fe20007f3e0ffULL,
0x0000000133267824ULL, 0x040fe400078e022aULL, 0x0000001033337824ULL, 0x000fe400078e00ffULL,
0x000000ffff257224ULL, 0x000fc600008e0627ULL, 0xfffffff0332c7812ULL, 0x000fe400078ee22cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e2000c101c46ULL,
0x000000283100720cULL, 0x000fe40003f06070ULL, 0x000000061b317810ULL, 0x000fe20007ffe0ffULL,
0x010a100029237984ULL, 0x000ea80000004800ULL, 0x000000015c337824ULL, 0x000fe200078e0231ULL,
0x0000e0002c2f7811ULL, 0x002fe200078e20ffULL, 0x010ac00023237984ULL, 0x004e640000004800ULL,
0x0000002314267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002bULL,
0x0000002d26247210ULL, 0x000fe20007f3e0ffULL, 0x0000000133267824ULL, 0x040fe400078e022aULL,
0x00000001332a7824ULL, 0x040fe400078e0204ULL, 0x000000ffff257224ULL, 0x000fe400008e0627ULL,
0x0000001033337824ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e2000c101c46ULL, 0x000000283100720cULL, 0x000fe40003f06070ULL,
0xfffffff0332a7812ULL, 0x000fe200078ee22aULL, 0x010a180029237984ULL, 0x000ea80000004800ULL,
0x010ac00023237984ULL, 0x004ea40000004800ULL, 0x0000002314267224ULL, 0x004fe200078e0226ULL,
0x0000e0002a237811ULL, 0x000fc600078e20ffULL, 0x00005e0026267625ULL, 0x000fca00078e002bULL,
0x0000002d26247210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e2000c101c46ULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x000000015c2b7824ULL, 0x000fe200078e021bULL,
0x0000002003287811ULL, 0x000fe200078e30ffULL, 0x0000001004257824ULL, 0x000fe400078e00ffULL,
0x00000100ff2d7424ULL, 0x020fe200078e00ffULL, 0x010a00002b237984ULL, 0x000e620000004800ULL,
0x000000012b247824ULL, 0x000fe200078e0228ULL, 0x000000f0252f7812ULL, 0x000fe200078ec0ffULL,
0x000000012b267824ULL, 0x040fe200078e0204ULL, 0x000000022b317810ULL, 0x040fe20007ffe0ffULL,
0x000000102b277824ULL, 0x000fc800078e00ffULL, 0x00000001312a7824ULL, 0x000fe200078e0204ULL,
0xfffffff027267812ULL, 0x000fc800078ee226ULL, 0x0000e00026297811ULL, 0x000fe200078e20ffULL,
0x0000000128267824ULL, 0x000fe400078e0231ULL, 0x0000001031317824ULL, 0x000fca00078e00ffULL,
0xfffffff0312a7812ULL, 0x000fe400078ee22aULL, 0x000000042b317810ULL, 0x000fe20007ffe0ffULL,
0x010ac00023237984ULL, 0x002e640000004800ULL, 0x0000002314247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024297faeULL, 0x0003e8000b901c46ULL, 0x010a08002b237984ULL, 0x000ea20000004800ULL,
0x0000e0002a297811ULL, 0x002fe200078e20ffULL, 0x0000000128247824ULL, 0x000fe400078e0231ULL,
0x00000001312a7824ULL, 0x040fe400078e0204ULL, 0x0000001031317824ULL, 0x000fca00078e00ffULL,
0xfffffff0312a7812ULL, 0x000fe400078ee22aULL, 0x000000062b317810ULL, 0x000fe20007ffe0ffULL,
0x010ac00023237984ULL, 0x004e640000004800ULL, 0x0000002314267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026297faeULL, 0x0003e8000b901c46ULL, 0x010a10002b237984ULL, 0x000ea20000004800ULL,
0x0000e0002a297811ULL, 0x002fe200078e20ffULL, 0x0000000128267824ULL, 0x000fe400078e0231ULL,
0x0000000131287824ULL, 0x040fe400078e0204ULL, 0x0000001031317824ULL, 0x000fca00078e00ffULL,
0xfffffff031287812ULL, 0x000fe200078ee228ULL, 0x010ac00023237984ULL, 0x004e640000004800ULL,
0x0000002314247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002dULL,
0x0000002f24247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024297faeULL, 0x0003e8000b901c46ULL,
0x010a18002b237984ULL, 0x000ea20000004800ULL, 0x0000e00028257811ULL, 0x002fc600078e20ffULL,
0x010ac00023237984ULL, 0x004e640000004800ULL, 0x0000002314267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff287224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804828ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000205b00720cULL, 0x000fe20003f04070ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x000000032200780cULL, 0x000fda0003f25270ULL, 0x000000f000008947ULL, 0x000fea0000800000ULL,
0x000000031500780cULL, 0x000fe40003f04070ULL, 0x0000000113137810ULL, 0x000fd60007ffe0ffULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000000400237824ULL, 0x000fe200078e0215ULL,
0x0000640013247a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff257424ULL, 0x000fe200078e00ffULL,
0x0000005e1300720cULL, 0x000fe20003f06070ULL, 0x0000000223237824ULL, 0x000fc800078e00ffULL,
0x0000640023247a24ULL, 0x000fe200078e0224ULL, 0x00010ac015237811ULL, 0x000fc600078e10ffULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024237faeULL, 0x0003e4000c121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000205b00720cULL, 0x000fe40003f04070ULL, 0x0000000122227810ULL, 0x000fc80007ffe0ffULL,
0x0000000322237812ULL, 0x002fc800078ec0ffULL, 0x000000ff23237207ULL, 0x000fc60004000000ULL,
0x00000002ff228819ULL, 0x000fca0000011622ULL, 0x0000000121217824ULL, 0x000fc800078e0222ULL,
0x0000004021227824ULL, 0x040fe200078e00ffULL, 0x0000002021207211ULL, 0x000fc800078ff0ffULL,
0x000000c022217812ULL, 0x000fca00078ec0ffULL, 0x0000010020217824ULL, 0x000fe400078e0221ULL,
0x0000000160207824ULL, 0x000fe200078e0223ULL, 0x00010a0015237811ULL, 0x040fe200078e10ffULL,
0x0000000115227824ULL, 0x140fe400078e0221ULL, 0x0000680020207a24ULL, 0x000fe400078e0221ULL,
0x00000004ff217424ULL, 0x000fe200078e00ffULL, 0x0000005f2200720cULL, 0x000fe20003f06070ULL,
0x0000000115207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fd000078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8000ff207f8cULL, 0x000e62000c80043fULL,
0x000000ff7200720cULL, 0x000fe20003f05270ULL, 0x000007e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff717224ULL, 0x002fd600078e0021ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010af8005c207f8cULL, 0x000e64000c80043fULL,
0x000000ffff247224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010afc005c177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007804824ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002220227210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e21ULL, 0x003d09002200780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402200780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff177819ULL, 0x000fc80000011423ULL,
0x0000002217177211ULL, 0x000fca00078110ffULL, 0x000000ffff227224ULL, 0x000fca00000e0623ULL,
0x0000000217177819ULL, 0x000fc80000001222ULL, 0x000000170000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x010afc005c177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804824ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001004177824ULL, 0x000fe200078e00ffULL, 0x00000001ff207819ULL, 0x000fc80000011604ULL,
0x0000007017177812ULL, 0x000fe400078ec0ffULL, 0x0000000c20207812ULL, 0x000fca00078ec0ffULL,
0x0000000117277824ULL, 0x000fca00078e0220ULL, 0x0100800027227984ULL, 0x000e680000000800ULL,
0x0102800027237984ULL, 0x0004e20000000800ULL, 0x000000112200720bULL, 0x002fe20003f1d000ULL,
0x00018f827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000177806ULL, 0x004fc800000e0100ULL,
0x0000ffff17287812ULL, 0x000fe2000780c0ffULL, 0x0000043000027945ULL, 0x000fe20003800000ULL,
0x00000001ff177424ULL, 0x000fe400078e00ffULL, 0x000000ffff247224ULL, 0x000fd200078e0011ULL,
0x000003f000008947ULL, 0x000fea0003800000ULL, 0x000000016100780cULL, 0x000fe40003f05270ULL,
0x000000112200720bULL, 0x000fe20003f34000ULL, 0x00018f427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000257806ULL, 0x000fc400008e0100ULL, 0x0000002211247209ULL, 0x000fe20007810000ULL,
0x0000033000037945ULL, 0x000fe20003800000ULL, 0x0000991025207816ULL, 0x000fc600000000ffULL,
0x0104802427008388ULL, 0x0003e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x8000002411117221ULL, 0x002fe20000010000ULL,
0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL, 0x0000001100297308ULL, 0x000e640000000800ULL,
0x000000290e0e7220ULL, 0x002fc80000410000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00018e927f007947ULL, 0x000fea000b800000ULL, 0x00001f6929117589ULL, 0x0002a400000e0000ULL,
0x000000110d0d7220ULL, 0x084fe20000410000ULL, 0x000000110c0c7220ULL, 0x080fe20000410000ULL,
0x0000001109097220ULL, 0x080fe20000410000ULL, 0x0000001108087220ULL, 0x080fe20000410000ULL,
0x0000001105057220ULL, 0x080fe20000410000ULL, 0x0000001144447220ULL, 0x080fe20000410000ULL,
0x0000001147477220ULL, 0x080fe20000410000ULL, 0x0000001148487220ULL, 0x080fe20000410000ULL,
0x000000114b4b7220ULL, 0x080fe20000410000ULL, 0x000000114c4c7220ULL, 0x080fe20000410000ULL,
0x000000114f4f7220ULL, 0x080fe20000410000ULL, 0x0000001150507220ULL, 0x080fe20000410000ULL,
0x0000001153537220ULL, 0x080fe20000410000ULL, 0x0000001154547220ULL, 0x080fe20000410000ULL,
0x0000001157577220ULL, 0x080fe20000410000ULL, 0x0000001158587220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00018da27f007947ULL, 0x000fea000b800000ULL,
0x00001f6829117589ULL, 0x00046400000e0000ULL, 0x000000110b0b7220ULL, 0x082fe20000410000ULL,
0x000000110a0a7220ULL, 0x080fe20000410000ULL, 0x0000001107077220ULL, 0x080fe20000410000ULL,
0x0000001106067220ULL, 0x080fe20000410000ULL, 0x0000001145457220ULL, 0x080fe20000410000ULL,
0x0000001146467220ULL, 0x080fe20000410000ULL, 0x0000001149497220ULL, 0x080fe20000410000ULL,
0x000000114a4a7220ULL, 0x080fe20000410000ULL, 0x000000114d4d7220ULL, 0x080fe20000410000ULL,
0x000000114e4e7220ULL, 0x080fe20000410000ULL, 0x0000001151517220ULL, 0x080fe20000410000ULL,
0x0000001152527220ULL, 0x080fe20000410000ULL, 0x0000001155557220ULL, 0x080fe20000410000ULL,
0x0000001156567220ULL, 0x080fe20000410000ULL, 0x0000001159597220ULL, 0x080fe20000410000ULL,
0x000000115a5a7220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff28ff7812ULL, 0x000fda0007806025ULL, 0x8000002422220221ULL, 0x000fe20000010000ULL,
0x00007610ff170816ULL, 0x000fc60000000017ULL, 0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL,
0x0000002200180308ULL, 0x000e640000000800ULL, 0x0000001823230220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000e230e7221ULL, 0x008fe20000010000ULL,
0x000000ffff117224ULL, 0x000fc400078e0024ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff17ff7812ULL, 0x000fe2000786c0ffULL, 0x0000012000017945ULL, 0x000fd80003800000ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000018ff19723eULL, 0x000fc800000010ffULL,
0x0000541019227816ULL, 0x000fe20000000019ULL, 0x00018be27f007947ULL, 0x000fea000b800000ULL,
0x00001f6922197589ULL, 0x0002e400000e0000ULL, 0x00018c227f007947ULL, 0x000fea000b800000ULL,
0x00001f68221a7589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001069277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0000a22000207802ULL, 0x000fc40000000f00ULL, 0x000197c000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001869277810ULL, 0x002fe40007ffe0ffULL, 0x0000a27000207802ULL, 0x000fc40000000f00ULL,
0x0001977000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001c20783bULL, 0x002e620000004200ULL,
0x000000726900720cULL, 0x000fe20003f46070ULL, 0x0000178000017945ULL, 0x000fe20003800000ULL,
0x000000125b00720cULL, 0x000fe20003fc3070ULL, 0x00000000662c783bULL, 0x000f220000004200ULL,
0x000000726800720cULL, 0x000fc40003f26070ULL, 0x000000125b00720cULL, 0x000fe20003f03070ULL,
0x000000006724783bULL, 0x004ea80000004200ULL, 0x000000001d28783bULL, 0x000ee20000004200ULL,
0x00000010ff367819ULL, 0x102fe40000011620ULL, 0x000000ff20907812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3f7819ULL, 0x000fc40000011620ULL, 0x0000ffff20397812ULL, 0x000fe400078ec0ffULL,
0x00000010ff377819ULL, 0x100fe40000011621ULL, 0x000000ff218f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe40000011621ULL, 0x0000ffff21417812ULL, 0x000fe400078ec0ffULL,
0x00000010ff357819ULL, 0x000fc40000011622ULL, 0x000000ff228c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7d7819ULL, 0x000fe40000011622ULL, 0x0000ffff22347812ULL, 0x000fe400078ec0ffULL,
0x00000010ff407819ULL, 0x100fe40000011623ULL, 0x000000ff238d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff917819ULL, 0x000fc40000011623ULL, 0x0000ffff23387812ULL, 0x000fe400078ec0ffULL,
0x000000ff2c237812ULL, 0x010fe400078ec0ffULL, 0x0000a8001e207811ULL, 0x000fe400078e20ffULL,
0x000000ff24217812ULL, 0x004fe400078ec0ffULL, 0x000000ff25227812ULL, 0x000fe400078ec0ffULL,
0x00000010ff337819ULL, 0x008fc40000011629ULL, 0x000000ff29837812ULL, 0x040fe400078ec0ffULL,
0x00000018ff857819ULL, 0x000fe40000011629ULL, 0x0000ffff29317812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3b7819ULL, 0x100fe4000001162bULL, 0x000000ff2b807812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fc4000001162bULL, 0x0000ffff2b647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff937819ULL, 0x100fe4000001162cULL, 0x00000018ff7b7819ULL, 0x000fe4000001162cULL,
0x0000ffff2c657812ULL, 0x000fe400078ec0ffULL, 0x00000023ff2c723eULL, 0x000fe400020006ffULL,
0x00000021ff29723eULL, 0x000fc400020006ffULL, 0x00000022ff2b723eULL, 0x000fe400020006ffULL,
0x000000002020783bULL, 0x000e620000000200ULL, 0x00000010ff327819ULL, 0x100fe20000011628ULL,
0x20000029ff297230ULL, 0x000fe20000004100ULL, 0x000000ff28827812ULL, 0x040fe200078ec0ffULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x00000018ff847819ULL, 0x000fe40000011628ULL,
0x0000ffff28307812ULL, 0x000fe400078ec0ffULL, 0x000000ff2d287812ULL, 0x000fc400078ec0ffULL,
0x00000010ff947819ULL, 0x100fe4000001162dULL, 0x00000018ff7c7819ULL, 0x000fe4000001162dULL,
0x0000ffff2d7f7812ULL, 0x000fe400078ec0ffULL, 0x00000028ff2d723eULL, 0x000fe400020006ffULL,
0x00000010ff287819ULL, 0x000fe40000011624ULL, 0x0000ffff24437812ULL, 0x000fc400078ec0ffULL,
0x00000018ff427819ULL, 0x000fe20000011624ULL, 0x2000002cff247230ULL, 0x000fe20000004100ULL,
0x00000010ff3a7819ULL, 0x100fe4000001162aULL, 0x000000ff2a817812ULL, 0x040fe400078ec0ffULL,
0x00000018ff927819ULL, 0x000fe4000001162aULL, 0x0000ffff2a3e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2a7819ULL, 0x000fc40000011625ULL, 0x0000a8001f2c7811ULL, 0x000fe400078e20ffULL,
0x0000ffff25867812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3c7819ULL, 0x000fe20000011625ULL,
0x2000002dff257230ULL, 0x000fe20000004100ULL, 0x000000ff28287812ULL, 0x000fe200078ec0ffULL,
0x000000192020b231ULL, 0x082fe200003400ffULL, 0x000000ff2a2a7812ULL, 0x000fe200078ec0ffULL,
0x000000192222b231ULL, 0x000fe200003400ffULL, 0x00000010ff797819ULL, 0x100fe2000001162eULL,
0x0000001a2121b231ULL, 0x080fe200003400ffULL, 0x000000ff2e777812ULL, 0x000fe200078ec0ffULL,
0x0000001a2323b231ULL, 0x000fe200003400ffULL, 0x00000018ff747819ULL, 0x000fc4000001162eULL,
0x0000ffff2e737812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7a7819ULL, 0x100fe4000001162fULL,
0x000000ff2f787812ULL, 0x040fe400078ec0ffULL, 0x00000018ff767819ULL, 0x000fe4000001162fULL,
0x0000ffff2f757812ULL, 0x000fe400078ec0ffULL, 0x000000002c2c783bULL, 0x000e620000000200ULL,
0x00000028ff28723eULL, 0x000fc400020006ffULL, 0x0000002aff2a723eULL, 0x000fe400020006ffULL,
0x00000010ff877819ULL, 0x100fe40000011626ULL, 0x000000ff263d7812ULL, 0x040fe200078ec0ffULL,
0x2000002aff2a7230ULL, 0x000fe20000004100ULL, 0x0000ffff26897812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8e7819ULL, 0x000fe20000011626ULL, 0x20000028ff267230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fc40000011627ULL, 0x000000ff27887812ULL, 0x040fe400078ec0ffULL,
0x0000ffff278a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff637819ULL, 0x000fe40000011627ULL,
0x00000010ff287819ULL, 0x000fe40000011629ULL, 0x00000010ff297819ULL, 0x000fe4000001162bULL,
0x00000010ff277819ULL, 0x000fc40000011626ULL, 0x00000010ff2a7819ULL, 0x000fe4000001162aULL,
0x0000105427287816ULL, 0x000fe40000000028ULL, 0x000010542a297816ULL, 0x000fe40000000029ULL,
0x000000ff93937812ULL, 0x000fe400078ec0ffULL, 0x000000ff94947812ULL, 0x000fe400078ec0ffULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x000000282028723cULL, 0x000f6200000418ffULL,
0x00000094ff94723eULL, 0x000fe200020006ffULL, 0x000000192c2cb231ULL, 0x082fe200003400ffULL,
0x00000010ff247819ULL, 0x000fe20000011624ULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe20000011625ULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x000000192e2eb231ULL, 0x000fe200003400ffULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x0000001a2d2db231ULL, 0x080fe200003400ffULL, 0x00000010ff937819ULL, 0x000fe20000011693ULL,
0x0000001a2f2fb231ULL, 0x000fe200003400ffULL, 0x00000010ff947819ULL, 0x000fc40000011694ULL,
0x0000105493247816ULL, 0x000fe40000000024ULL, 0x0000105494257816ULL, 0x000fe40000000025ULL,
0x000000ff35357812ULL, 0x000fe400078ec0ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x000000ff40407812ULL, 0x000fe400078ec0ffULL, 0x000000242c28723cULL, 0x020be20000041828ULL,
0x00000035ff35723eULL, 0x000fc400020006ffULL, 0x00000008ff347819ULL, 0x000fe40000011634ULL,
0x00000008ff387819ULL, 0x000fe40000011638ULL, 0x2000008fff257230ULL, 0x020fe20000004100ULL,
0x000000ff368f7812ULL, 0x000fe200078ec0ffULL, 0x20000090ff247230ULL, 0x000fe20000004100ULL,
0x0000007dff26723eULL, 0x000fe400020006ffULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x00000092ff7d723eULL, 0x000fe200020006ffULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x0000008eff8e723eULL, 0x000fc400020006ffULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x00000040ff92723eULL, 0x000fe200020006ffULL,
0x20000035ff407230ULL, 0x000fe20000004100ULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x2000008eff367230ULL, 0x000fe20000004100ULL, 0x00000034ff34723eULL, 0x000fe200020006ffULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x0000008dff8d723eULL, 0x000fc400020006ffULL, 0x000000ff37907812ULL, 0x000fe200078ec0ffULL,
0x20000088ff377230ULL, 0x000fe20000004100ULL, 0x00000043ff35723eULL, 0x000fe200020006ffULL,
0x20000034ff437230ULL, 0x000fe20000004100ULL, 0x00000008ff867819ULL, 0x000fe20000011686ULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000035ff347230ULL, 0x000fe20000004100ULL, 0x000000ff87877812ULL, 0x000fe400078ec0ffULL,
0x00000091ff27723eULL, 0x000fe200020006ffULL, 0x20000038ff917230ULL, 0x000fe20000004100ULL,
0x00000008ff8e7819ULL, 0x000fe20000011641ULL, 0x2000008fff417230ULL, 0x000fe20000004100ULL,
0x00000090ff90723eULL, 0x000fe200020006ffULL, 0x20000027ff277230ULL, 0x000fe20000004100ULL,
0x00000008ff887819ULL, 0x000fe20000011639ULL, 0x20000063ff397230ULL, 0x000fe20000004100ULL,
0x0000003cff3c723eULL, 0x000fe200020006ffULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000086ff38723eULL, 0x000fc400020006ffULL, 0x0000003dff3d723eULL, 0x000fe200020006ffULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x000000ff8b8b7812ULL, 0x000fe200078ec0ffULL,
0x20000038ff387230ULL, 0x000fe20000004100ULL, 0x00000087ff35723eULL, 0x000fe200020006ffULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000008ff897819ULL, 0x000fe20000011689ULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000088ff63723eULL, 0x000fe200020006ffULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff8a7819ULL, 0x000fc4000001168aULL, 0x0000008eff88723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fe40000011624ULL,
0x00000010ff417819ULL, 0x000fe20000011641ULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x0000008bff8e723eULL, 0x000fe400020006ffULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00000010ff927819ULL, 0x000fe20000011692ULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fc400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x20000089ff8b7230ULL, 0x000fe20000004100ULL,
0x0000003fff3f723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x0000105441247816ULL, 0x000fe20000000024ULL, 0x2000008aff8f7230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe20000011625ULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000010ff907819ULL, 0x000fc40000011690ULL, 0x0000105492417816ULL, 0x000fe4000000008dULL,
0x00000010ff8d7819ULL, 0x000fe4000001163cULL, 0x00000010ff387819ULL, 0x000fe40000011638ULL,
0x000000ff33877812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3d7819ULL, 0x000fe4000001163dULL,
0x00000010ff3c7819ULL, 0x000fc40000011635ULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff337819ULL, 0x000fe40000011640ULL, 0x0000105490257816ULL, 0x000fe40000000025ULL,
0x000010548d357816ULL, 0x000fe40000000038ULL, 0x00000010ff907819ULL, 0x000fe40000011639ULL,
0x00000008ff897819ULL, 0x000fc40000011630ULL, 0x00000008ff8a7819ULL, 0x000fe40000011631ULL,
0x000010543c387816ULL, 0x000fe4000000003dULL, 0x00000010ff397819ULL, 0x000fe4000001168eULL,
0x000000ff32867812ULL, 0x000fe400078ec0ffULL, 0x0000105433407816ULL, 0x000fe4000000008cULL,
0x00000010ff317819ULL, 0x000fc40000011626ULL, 0x00000010ff307819ULL, 0x000fe40000011643ULL,
0x00000010ff3d7819ULL, 0x000fe40000011636ULL, 0x00000010ff3c7819ULL, 0x000fe4000001168bULL,
0x00000010ff8e7819ULL, 0x000fe40000011662ULL, 0x00000010ff327819ULL, 0x000fe40000011627ULL,
0x00000010ff917819ULL, 0x000fe20000011691ULL, 0x000000242024723cULL, 0x000f6200000418ffULL,
0x00000010ff337819ULL, 0x000fc40000011642ULL, 0x00000010ff347819ULL, 0x000fe40000011634ULL,
0x00000010ff8c7819ULL, 0x000fe40000011637ULL, 0x00000010ff8f7819ULL, 0x000fe2000001168fULL,
0x000000402040723cULL, 0x000fe200000418ffULL, 0x00000010ff627819ULL, 0x000fe40000011663ULL,
0x00000010ff3f7819ULL, 0x000fe4000001163fULL, 0x00000010ff637819ULL, 0x000fc40000011688ULL,
0x0000105431307816ULL, 0x000fe40000000030ULL, 0x000010543d3c7816ULL, 0x000fe4000000003cULL,
0x0000105432317816ULL, 0x000fe40000000091ULL, 0x0000105433347816ULL, 0x000fe40000000034ULL,
0x0000105439397816ULL, 0x000fe4000000008cULL, 0x00001054903d7816ULL, 0x000fe2000000008fULL,
0x000000302030723cULL, 0x000fe200000418ffULL, 0x000010543f627816ULL, 0x000fc40000000062ULL,
0x000010548e637816ULL, 0x000fe40000000063ULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x000000342034723cULL, 0x040fe200000418ffULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x000000ff3a8b7812ULL, 0x000fe200078ec0ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x000000ff3b8c7812ULL, 0x000fe200078ec0ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff887819ULL, 0x000fe2000001163eULL, 0x000000382038723cULL, 0x000fe200000418ffULL,
0x00000084ff84723eULL, 0x000fc400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000008ff647819ULL, 0x000fe20000011664ULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fe20000011665ULL, 0x0000003c203c723cULL, 0x040fe200000418ffULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000088ff8d723eULL, 0x000fe200020006ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000064ff8e723eULL, 0x000fe200020006ffULL,
0x000000622020723cULL, 0x000b6200000418ffULL, 0x00000065ff88723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe20000011682ULL,
0x2000008dff827230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe20000011683ULL,
0x2000008eff837230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x020fe20000011686ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fc40000011687ULL,
0x0000105463647816ULL, 0x000fe40000000064ULL, 0x0000105462657816ULL, 0x000fe40000000065ULL,
0x00000010ff637819ULL, 0x000fe40000011684ULL, 0x00000010ff627819ULL, 0x000fe40000011689ULL,
0x00000010ff857819ULL, 0x000fe20000011685ULL, 0x000000642c24723cULL, 0x000f620000041824ULL,
0x00000010ff8a7819ULL, 0x000fc4000001168aULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x0000105463627816ULL, 0x000fe40000000062ULL, 0x0000105485637816ULL, 0x000fe2000000008aULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x000000ff79797812ULL, 0x000fe200078ec0ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x000000ff7a7a7812ULL, 0x000fe200078ec0ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x000000622c20723cULL, 0x000b620000041820ULL,
0x00000010ff7d7819ULL, 0x000fc4000001167dULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x020fe40000011682ULL,
0x00000010ff637819ULL, 0x000fe20000011683ULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000008ff7f7819ULL, 0x000fc4000001167fULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00000010ff647819ULL, 0x000fe20000011681ULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe20000011680ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff8c7819ULL, 0x000fc4000001168cULL, 0x000010547d627816ULL, 0x000fe40000000062ULL,
0x000010547e637816ULL, 0x000fe40000000063ULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x000010548b647816ULL, 0x000fe20000000064ULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x000010548c657816ULL, 0x000fe20000000065ULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x000000622c30723cULL, 0x000b620000041830ULL,
0x00000010ff797819ULL, 0x000fc40000011679ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000008ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff627819ULL, 0x020fe20000011677ULL,
0x000000642c40723cULL, 0x000b620000041840ULL, 0x00000010ff637819ULL, 0x000fe40000011678ULL,
0x00000008ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff7b7819ULL, 0x000fc4000001167bULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff647819ULL, 0x020fe40000011688ULL,
0x00000010ff657819ULL, 0x000fe4000001167fULL, 0x0000105479627816ULL, 0x000fe40000000062ULL,
0x000010547a637816ULL, 0x000fe40000000063ULL, 0x00000074ff74723eULL, 0x000fc400020006ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x000010547b647816ULL, 0x000fe20000000064ULL,
0x000000622c38723cULL, 0x000b620000041838ULL, 0x000010547c657816ULL, 0x000fe20000000065ULL,
0x20000076ff767230ULL, 0x000fe40000004100ULL, 0x20000075ff757230ULL, 0x000fc60000004100ULL,
0x0000000172627810ULL, 0x020fe20007ffe0ffULL, 0x000000642c34723cULL, 0x000b620000041834ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x000000626900720cULL, 0x000fe40005746470ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff657819ULL, 0x020fe40000011674ULL,
0x00000010ff647819ULL, 0x000fc40000011673ULL, 0x000000626800720cULL, 0x000fe40004f26470ULL,
0x0000105465647816ULL, 0x000fe40000000064ULL, 0x0000105476657816ULL, 0x000fce0000000075ULL,
0x000000642c3c723cULL, 0x000b62000004183cULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000240d0d7221ULL, 0x000fe20000010000ULL,
0x000000250c0c7221ULL, 0x000fe20000010000ULL, 0x0000002009097221ULL, 0x000fe20000010000ULL,
0x0000002108087221ULL, 0x000fe20000010000ULL, 0x0000004005057221ULL, 0x000fe20000010000ULL,
0x0000004144447221ULL, 0x000fe20000010000ULL, 0x0000003047477221ULL, 0x000fe20000010000ULL,
0x0000003148487221ULL, 0x000fe20000010000ULL, 0x000000284b4b7221ULL, 0x000fe20000010000ULL,
0x000000294c4c7221ULL, 0x000fe20000010000ULL, 0x000000344f4f7221ULL, 0x000fe20000010000ULL,
0x0000003550507221ULL, 0x000fe20000010000ULL, 0x0000003853537221ULL, 0x000fe20000010000ULL,
0x0000003954547221ULL, 0x000fe20000010000ULL, 0x0000003c57577221ULL, 0x020fe20000010000ULL,
0x0000003d58587221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000260b0b7221ULL, 0x000fe20000010000ULL, 0x000000270a0a7221ULL, 0x000fe20000010000ULL,
0x0000002207077221ULL, 0x000fe20000010000ULL, 0x0000002306067221ULL, 0x000fe20000010000ULL,
0x0000004245457221ULL, 0x000fe20000010000ULL, 0x0000004346467221ULL, 0x000fe20000010000ULL,
0x0000003249497221ULL, 0x000fe20000010000ULL, 0x000000334a4a7221ULL, 0x000fe20000010000ULL,
0x0000002a4d4d7221ULL, 0x000fe20000010000ULL, 0x0000002b4e4e7221ULL, 0x000fe20000010000ULL,
0x0000003651517221ULL, 0x000fe20000010000ULL, 0x0000003752527221ULL, 0x000fe20000010000ULL,
0x0000003a55557221ULL, 0x000fe20000010000ULL, 0x0000003b56567221ULL, 0x000fe20000010000ULL,
0x0000003e59597221ULL, 0x020fe20000010000ULL, 0x0000003f5a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x000e62000c80043fULL, 0x00000002ff237819ULL, 0x000fe20000011662ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000000125b00720cULL, 0x000fc40003fc3070ULL,
0x0000002362237207ULL, 0x040fe40002800000ULL, 0x0000000362627812ULL, 0x000fe400078ec0ffULL,
0x0000000123277810ULL, 0x000fe40007ffe0ffULL, 0x000000125b00720cULL, 0x000fe40003f03070ULL,
0x00000040ff297803ULL, 0x000fe40000000000ULL, 0x000000ff62237207ULL, 0x000fc40006800000ULL,
0x0000000327257812ULL, 0x040fe400078ec0ffULL, 0x0000001227227211ULL, 0x000fe200078ff0ffULL,
0x000000ffff2d7224ULL, 0x022fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010b8400ff247984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000024ff7812ULL, 0x002fe200078c4871ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026202b7210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e21ULL,
0x003d09002b00780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011427ULL, 0x0000002b24247211ULL, 0x000fca00078d10ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x0000000224247819ULL, 0x000fc80000001227ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8400ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe400078c4871ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fc40000015200ULL,
0x010b8c00ff247984ULL, 0x000e620000000800ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000024ff7812ULL, 0x002fe200078c482dULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026202b7210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e21ULL, 0x003d09002b00780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011427ULL,
0x0000002b24247211ULL, 0x000fca00078d10ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x0000000224247819ULL, 0x000fc80000001227ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe400078c482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000122207810ULL, 0x000fe20007ffe0ffULL, 0x0000097000017945ULL, 0x000fe60003800000ULL,
0x0000005d2000720cULL, 0x000fda0003fc6070ULL, 0x000005100000e947ULL, 0x000fea0003800000ULL,
0x000000015c2a7824ULL, 0x000fe200078e021bULL, 0x000000021b317810ULL, 0x000fe20007ffe0ffULL,
0x0000001004247824ULL, 0x000fe400078e00ffULL, 0x00000040032b7824ULL, 0x000fe200078e022aULL,
0x010a00002a267984ULL, 0x000e620000004800ULL, 0x00000100ff2c7424ULL, 0x000fe200078e00ffULL,
0x000000f0242d7812ULL, 0x000fe200078ec0ffULL, 0x0000000422247824ULL, 0x000fe400078e0225ULL,
0x000000102a2f7824ULL, 0x000fc400078e00ffULL, 0x0000004024247824ULL, 0x000fe400078e00ffULL,
0x000000015c337824ULL, 0x000fc600078e0231ULL, 0x000000245f277217ULL, 0x000fe20007800000ULL,
0x00000001332e7824ULL, 0x040fe400078e0204ULL, 0x0000001033337824ULL, 0x000fe400078e00ffULL,
0x0000000127277824ULL, 0x000fe400078e0a24ULL, 0x000000012a247824ULL, 0x000fe200078e0204ULL,
0xfffffff0332e7812ULL, 0x000fe400078ee22eULL, 0x000000275c277217ULL, 0x000fe20007800000ULL,
0x010ac00026217984ULL, 0x0022a40000004800ULL, 0xfffffff02f267812ULL, 0x002fc400078ee224ULL,
0x0000000127247824ULL, 0x000fe400078e0a5cULL, 0x0000c000262f7811ULL, 0x000fe400078e20ffULL,
0x000000022b267810ULL, 0x000fe20007ffe0ffULL, 0x0000002114217224ULL, 0x004fc800078e022bULL,
0x00005e0021207625ULL, 0x000fca00078e002cULL, 0x0000002d20207210ULL, 0x000fca0007fde0ffULL,
0x000000ffff217224ULL, 0x000fe200030e0621ULL, 0x000000241b00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000202f7faeULL, 0x0003e8000f101c46ULL,
0x010a08002a287984ULL, 0x000ea20000004800ULL, 0x0000c0002e2f7811ULL, 0x002fe400078e20ffULL,
0x000000042b207810ULL, 0x040fe40007ffe0ffULL, 0x000000062b2b7810ULL, 0x000fe20007ffe0ffULL,
0x010ac00028277984ULL, 0x004e640000004800ULL, 0x0000002714277224ULL, 0x002fc800078e0226ULL,
0x00005e0027267625ULL, 0x000fca00078e002cULL, 0x0000002d26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000243100720cULL, 0x000fe40003fc6070ULL,
0x000000041b317810ULL, 0x000fca0007ffe0ffULL, 0x000000015c337824ULL, 0x000fc800078e0231ULL,
0x00000001332e7824ULL, 0x040fe400078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000f101c46ULL, 0x0000001033337824ULL, 0x000fc600078e00ffULL,
0x010a10002a287984ULL, 0x000ea40000004800ULL, 0xfffffff0332e7812ULL, 0x000fc800078ee22eULL,
0x0000c0002e2f7811ULL, 0x002fe200078e20ffULL, 0x010ac00028217984ULL, 0x004e640000004800ULL,
0x0000002114217224ULL, 0x002fc800078e0220ULL, 0x00005e0021207625ULL, 0x000fca00078e002cULL,
0x0000002d20207210ULL, 0x000fca0007fde0ffULL, 0x000000ffff217224ULL, 0x000fe200030e0621ULL,
0x000000243100720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000202f7faeULL, 0x0003e8000f101c46ULL, 0x010a18002a287984ULL, 0x000ea80000004800ULL,
0x010ac00028277984ULL, 0x004ea40000004800ULL, 0x0000002714277224ULL, 0x004fe200078e022bULL,
0x000000061b2b7810ULL, 0x000fc60007ffe0ffULL, 0x00005e0027267625ULL, 0x000fca00078e002cULL,
0x0000002d26267210ULL, 0x000fe20007fde0ffULL, 0x000000015c2d7824ULL, 0x000fc800078e022bULL,
0x000000012d2c7824ULL, 0x000fe400078e0204ULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x000000242b00720cULL, 0x000fe20003fc6070ULL, 0x000000102d2d7824ULL, 0x000fca00078e00ffULL,
0xfffffff02d2c7812ULL, 0x000fc800078ee22cULL, 0x0000c0002c217811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026217faeULL, 0x0003e2000f101c46ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x000000015c287824ULL, 0x000fe400078e021bULL,
0x0000001004267824ULL, 0x000fe400078e00ffULL, 0x00000040032a7824ULL, 0x000fe200078e0228ULL,
0x010a000028247984ULL, 0x000e620000004800ULL, 0x00000100ff2c7424ULL, 0x000fe200078e00ffULL,
0x000000f0262b7812ULL, 0x000fe200078ec0ffULL, 0x0000000128267824ULL, 0x040fe200078e0204ULL,
0x00000002282f7810ULL, 0x040fe20007ffe0ffULL, 0x0000001028277824ULL, 0x000fc800078e00ffULL,
0x000000012f2e7824ULL, 0x000fe200078e0204ULL, 0xfffffff027267812ULL, 0x000fe200078ee226ULL,
0x000000102f2f7824ULL, 0x000fc600078e00ffULL, 0x0000c000262d7811ULL, 0x000fe400078e20ffULL,
0x000000022a267810ULL, 0x000fe40007ffe0ffULL, 0xfffffff02f2e7812ULL, 0x000fe400078ee22eULL,
0x00000004282f7810ULL, 0x000fe20007ffe0ffULL, 0x010ac00024217984ULL, 0x002e640000004800ULL,
0x0000002114217224ULL, 0x002fc800078e022aULL, 0x00005e0021207625ULL, 0x000fca00078e002cULL,
0x0000002b20207210ULL, 0x000fca0007fde0ffULL, 0x000000ffff217224ULL, 0x000fca00030e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000202d7faeULL, 0x0003e8000b901c46ULL,
0x010a080028247984ULL, 0x000ea20000004800ULL, 0x0000c0002e2d7811ULL, 0x002fe200078e20ffULL,
0x000000012f2e7824ULL, 0x040fe200078e0204ULL, 0x000000042a207810ULL, 0x040fe20007ffe0ffULL,
0x000000102f2f7824ULL, 0x000fe200078e00ffULL, 0x000000062a2a7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff02f2e7812ULL, 0x000fe200078ee22eULL, 0x010ac00024277984ULL, 0x004e640000004800ULL,
0x0000002714277224ULL, 0x002fc800078e0226ULL, 0x00005e0027267625ULL, 0x000fca00078e002cULL,
0x0000002b26267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0003e8000b901c46ULL,
0x010a100028247984ULL, 0x000ea20000004800ULL, 0x0000c0002e2d7811ULL, 0x002fc600078e20ffULL,
0x010ac00024217984ULL, 0x004e640000004800ULL, 0x0000002114217224ULL, 0x002fc800078e0220ULL,
0x00005e0021207625ULL, 0x000fca00078e002cULL, 0x0000002b20207210ULL, 0x000fca0007fde0ffULL,
0x000000ffff217224ULL, 0x000fca00030e0621ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000202d7faeULL, 0x0003e8000b901c46ULL, 0x010a180028247984ULL, 0x000ea80000004800ULL,
0x010ac00024277984ULL, 0x004ea40000004800ULL, 0x0000002714277224ULL, 0x004fc800078e022aULL,
0x00005e0027267625ULL, 0x000fca00078e002cULL, 0x0000002b26267210ULL, 0x000fe40007fde0ffULL,
0x00000006282b7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff277224ULL, 0x000fe400030e0627ULL,
0x000000012b2a7824ULL, 0x040fe400078e0204ULL, 0x000000102b2b7824ULL, 0x000fca00078e00ffULL,
0xfffffff02b2a7812ULL, 0x000fc800078ee22aULL, 0x0000c0002a217811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026217faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x002e64000c80043fULL, 0x000000ffff2d7224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b8c00ff247984ULL, 0x000e620000000800ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000024ff7812ULL, 0x002fe200078c482dULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026202b7210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e21ULL,
0x003d09002b00780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011427ULL, 0x0000002b24247211ULL, 0x000fca00078d10ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x0000000224247819ULL, 0x000fc80000001227ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe400078c482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000225b00720cULL, 0x000fc80003fc4070ULL,
0x000000ff23207207ULL, 0x040fe40003000000ULL, 0x000000ff23237207ULL, 0x000fc60007000000ULL,
0x0000000125257824ULL, 0x000fc800078e0220ULL, 0x0000004025207824ULL, 0x040fe200078e00ffULL,
0x0000002225227211ULL, 0x000fe400078ff0ffULL, 0x00010a0015257811ULL, 0x000fe400078e10ffULL,
0x000000c020217812ULL, 0x000fe200078ec0ffULL, 0x0000000160207824ULL, 0x000fe400078e0223ULL,
0x00000004ff237424ULL, 0x000fe400078e00ffULL, 0x0000010022217824ULL, 0x000fca00078e0221ULL,
0x0000002021217810ULL, 0x000fca0007ffe0ffULL, 0x0000000115227824ULL, 0x100fe400078e0221ULL,
0x0000680020207a24ULL, 0x000fc600078e0221ULL, 0x0000005f2200720cULL, 0x000fe20003fc6070ULL,
0x0000000115207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fd000078e0023ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e4000f121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b7800ff207f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x002fe200078e0021ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000018ff19723eULL, 0x000fc800000010ffULL,
0x0000541019227816ULL, 0x000fe20000000019ULL, 0x00015ec27f007947ULL, 0x000fea000b800000ULL,
0x00001f6922197589ULL, 0x0002a400000e0000ULL, 0x00015f027f007947ULL, 0x000fea000b800000ULL,
0x00001f68221a7589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001069277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0000d00000207802ULL, 0x000fc40000000f00ULL, 0x000169e000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001869277810ULL, 0x002fe40007ffe0ffULL, 0x0000d05000207802ULL, 0x000fc40000000f00ULL,
0x0001699000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff2900720cULL, 0x000fe20003fc5270ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006a28783bULL, 0x000f220000004200ULL, 0x0000172000017945ULL, 0x000fe60003800000ULL,
0x000000006b24783bULL, 0x006e680000004200ULL, 0x000000006e20783bULL, 0x008ea80000004200ULL,
0x000000006d2c783bULL, 0x000ee20000004200ULL, 0x00000018ff407819ULL, 0x010fc40000011629ULL,
0x00000010ff417819ULL, 0x000fe40000011628ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x000000ff29427812ULL, 0x000fe400078ec0ffULL, 0x00000010ff357819ULL, 0x002fe20000011624ULL,
0x20000040ff8f7230ULL, 0x000fe20000004100ULL, 0x0000a8006f407811ULL, 0x000fe400078e20ffULL,
0x000000ff243c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff387819ULL, 0x000fe40000011624ULL,
0x0000ffff24337812ULL, 0x000fe400078ec0ffULL, 0x00000010ff317819ULL, 0x104fe40000011620ULL,
0x000000ff20877812ULL, 0x040fe400078ec0ffULL, 0x00000018ff867819ULL, 0x000fe40000011620ULL,
0x0000ffff20347812ULL, 0x000fc400078ec0ffULL, 0x000000ff28247812ULL, 0x000fe400078ec0ffULL,
0x00000010ff307819ULL, 0x100fe40000011621ULL, 0x000000ff21857812ULL, 0x040fe400078ec0ffULL,
0x00000018ff847819ULL, 0x000fe40000011621ULL, 0x0000ffff213a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7a7819ULL, 0x000fc4000001162aULL, 0x000000ff2a8d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff207819ULL, 0x000fe4000001162aULL, 0x0000ffff2a777812ULL, 0x000fe400078ec0ffULL,
0x00000010ff767819ULL, 0x100fe4000001162bULL, 0x000000ff2b837812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7c7819ULL, 0x000fc4000001162bULL, 0x0000ffff2b737812ULL, 0x000fe400078ec0ffULL,
0x00000010ff397819ULL, 0x100fe40000011622ULL, 0x000000ff22747812ULL, 0x040fe400078ec0ffULL,
0x00000018ff787819ULL, 0x000fe40000011622ULL, 0x0000ffff223e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3b7819ULL, 0x000fc40000011623ULL, 0x000000ff23757812ULL, 0x040fe400078ec0ffULL,
0x00000018ff797819ULL, 0x000fe40000011623ULL, 0x0000ffff23627812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe40000011627ULL, 0x000000ff277e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff217819ULL, 0x000fc40000011627ULL, 0x0000ffff27657812ULL, 0x000fe400078ec0ffULL,
0x00000042ff2a723eULL, 0x000fe400020006ffULL, 0x000000ff412b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff377819ULL, 0x100fe20000011625ULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x000000ff253f7812ULL, 0x000fe200078ec0ffULL, 0x2000002aff2a7230ULL, 0x000fe20000004100ULL,
0x00000018ff3d7819ULL, 0x000fc40000011625ULL, 0x0000ffff25367812ULL, 0x000fe400078ec0ffULL,
0x00000010ff327819ULL, 0x100fe40000011626ULL, 0x000000ff267d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7b7819ULL, 0x000fe40000011626ULL, 0x0000ffff26637812ULL, 0x000fe400078ec0ffULL,
0x00000018ff237819ULL, 0x000fc40000011628ULL, 0x0000ffff28907812ULL, 0x000fe400078ec0ffULL,
0x00000010ff227819ULL, 0x000fe40000011629ULL, 0x0000ffff29277812ULL, 0x000fe400078ec0ffULL,
0x00000024ff26723eULL, 0x000fe400020006ffULL, 0x00000010ff297819ULL, 0x008fe4000001162dULL,
0x000000ff2d257812ULL, 0x000fc400078ec0ffULL, 0x0000ffff2d287812ULL, 0x000fe400078ec0ffULL,
0x00000010ff917819ULL, 0x100fe4000001162cULL, 0x000000ff2c247812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2c8c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001162dULL,
0x00000018ff2c7819ULL, 0x000fe2000001162cULL, 0x000000194040b231ULL, 0x082fe200003400ffULL,
0x00000023ff8e723eULL, 0x000fe200020006ffULL, 0x20000026ff237230ULL, 0x000fe20000004100ULL,
0x0000002dff2d723eULL, 0x000fe200020006ffULL, 0x000000194242b231ULL, 0x000fe200003400ffULL,
0x0000002cff26723eULL, 0x000fe200020006ffULL, 0x0000001a4141b231ULL, 0x080fe200003400ffULL,
0x00000008ff2c7819ULL, 0x000fe20000011627ULL, 0x2000002dff277230ULL, 0x000fe20000004100ULL,
0x000000ff29297812ULL, 0x000fe200078ec0ffULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x0000002cff2d723eULL, 0x000fe200020006ffULL, 0x0000001a4343b231ULL, 0x000fe200003400ffULL,
0x000000ff912c7812ULL, 0x000fe200078ec0ffULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000025ff25723eULL, 0x000fe200020006ffULL, 0x2000002dff917230ULL, 0x000fe20000004100ULL,
0x0000002cff2c723eULL, 0x000fc400020006ffULL, 0x00000008ff287819ULL, 0x000fe20000011628ULL,
0x20000025ff257230ULL, 0x000fe20000004100ULL, 0x0000a8006c2d7811ULL, 0x000fe400078e20ffULL,
0x00000024ff24723eULL, 0x000fe400020006ffULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x00000008ff8c7819ULL, 0x000fe2000001168cULL, 0x20000024ff247230ULL, 0x000fe20000004100ULL,
0x00000028ff93723eULL, 0x000fe200020006ffULL, 0x2000002cff287230ULL, 0x000fe20000004100ULL,
0x00000010ff7f7819ULL, 0x000fe2000001162eULL, 0x20000029ff927230ULL, 0x000fe20000004100ULL,
0x000000ff2e887812ULL, 0x040fe200078ec0ffULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x0000ffff2e807812ULL, 0x000fc400078ec0ffULL, 0x00000018ff897819ULL, 0x000fe4000001162eULL,
0x00000010ff817819ULL, 0x100fe4000001162fULL, 0x000000ff2f8a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2f827812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fe4000001162fULL,
0x000000002d2c783bULL, 0x000e620000000200ULL, 0x0000008cff8c723eULL, 0x000fc400020006ffULL,
0x00000010ff297819ULL, 0x000fe40000011625ULL, 0x00000010ff247819ULL, 0x000fe20000011624ULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fe40000011628ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x0000105425247816ULL, 0x000fe40000000024ULL,
0x0000105492257816ULL, 0x000fc40000000029ULL, 0x00000010ff297819ULL, 0x000fe40000011626ULL,
0x00000010ff287819ULL, 0x000fe4000001168cULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x00000010ff8c7819ULL, 0x000fe40000011627ULL, 0x00000010ff937819ULL, 0x000fe20000011693ULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x0000105429287816ULL, 0x000fe20000000028ULL,
0x000000244024723cULL, 0x000fe200000418ffULL, 0x000010548c297816ULL, 0x000fc40000000093ULL,
0x000000ff22227812ULL, 0x000fe400078ec0ffULL, 0x00000008ff907819ULL, 0x000fe40000011690ULL,
0x00000010ff937819ULL, 0x000fe4000001162aULL, 0x00000010ff927819ULL, 0x000fe4000001162bULL,
0x000000284028723cULL, 0x000f6200000418ffULL, 0x00000022ff22723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe200020006ffULL, 0x000000192c2cb231ULL, 0x082fe200003400ffULL,
0x00000010ff237819ULL, 0x000fe20000011623ULL, 0x20000022ff227230ULL, 0x000fe20000004100ULL,
0x00000021ff8c723eULL, 0x000fe200020006ffULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x000fe2000001168eULL, 0x000000192e2eb231ULL, 0x000fe200003400ffULL,
0x00000010ff947819ULL, 0x000fe20000011622ULL, 0x0000001a2d2db231ULL, 0x080fe200003400ffULL,
0x0000105492227816ULL, 0x000fe20000000023ULL, 0x0000001a2f2fb231ULL, 0x000fe200003400ffULL,
0x00000010ff907819ULL, 0x000fc40000011690ULL, 0x00000010ff927819ULL, 0x000fe4000001168fULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x00000020ff8e723eULL, 0x000fe400020006ffULL,
0x0000105421207816ULL, 0x000fe40000000090ULL, 0x0000105492217816ULL, 0x000fe40000000091ULL,
0x00000085ff85723eULL, 0x000fc400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000008ff347819ULL, 0x000fe20000011634ULL, 0x000000202c28723cULL, 0x020be20000041828ULL,
0x00000083ff92723eULL, 0x000fe200020006ffULL, 0x20000086ff837230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x000000ff30867812ULL, 0x000fe400078ec0ffULL,
0x20000085ff217230ULL, 0x020fe20000004100ULL, 0x000000ff31857812ULL, 0x000fe200078ec0ffULL,
0x2000008aff307230ULL, 0x000fe20000004100ULL, 0x0000105494237816ULL, 0x000fc40000000093ULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x000000ff39397812ULL, 0x000fe200078ec0ffULL, 0x000000222c24723cULL, 0x000be20000041824ULL,
0x00000008ff3e7819ULL, 0x000fe4000001163eULL, 0x000000ff3b3b7812ULL, 0x000fe400078ec0ffULL,
0x00000074ff74723eULL, 0x000fc400020006ffULL, 0x00000086ff8a723eULL, 0x000fe200020006ffULL,
0x20000085ff867230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000034ff857230ULL, 0x000fe20000004100ULL, 0x00000008ff3a7819ULL, 0x000fe2000001163aULL,
0x20000074ff237230ULL, 0x020fe20000004100ULL, 0x00000039ff39723eULL, 0x000fe200020006ffULL,
0x20000078ff227230ULL, 0x000fe20000004100ULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x2000008eff747230ULL, 0x000fe20000004100ULL, 0x0000003eff3e723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x2000008dff787230ULL, 0x000fe20000004100ULL, 0x00000008ff347819ULL, 0x000fc40000011662ULL,
0x0000003bff3b723eULL, 0x000fe400020006ffULL, 0x00000008ff637819ULL, 0x000fe40000011663ULL,
0x0000007cff93723eULL, 0x000fe200020006ffULL, 0x2000008cff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL, 0x20000039ff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff807819ULL, 0x000fe20000011680ULL, 0x2000003eff397230ULL, 0x000fe20000004100ULL,
0x0000003aff3a723eULL, 0x000fe200020006ffULL, 0x2000003bff8d7230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fc400020006ffULL, 0x00000089ff91723eULL, 0x000fe200020006ffULL,
0x20000075ff897230ULL, 0x000fe20000004100ULL, 0x00000034ff34723eULL, 0x000fe200020006ffULL,
0x2000003aff627230ULL, 0x000fe20000004100ULL, 0x00000063ff8e723eULL, 0x000fe200020006ffULL,
0x20000091ff317230ULL, 0x000fe20000004100ULL, 0x00000008ff827819ULL, 0x000fe20000011682ULL,
0x20000034ff347230ULL, 0x000fe20000004100ULL, 0x00000088ff90723eULL, 0x000fe200020006ffULL,
0x20000079ff887230ULL, 0x000fe20000004100ULL, 0x0000007fff3e723eULL, 0x000fe200020006ffULL,
0x2000008eff7f7230ULL, 0x000fe20000004100ULL, 0x00000080ff63723eULL, 0x000fe200020006ffULL,
0x20000092ff797230ULL, 0x000fe20000004100ULL, 0x000000ff81817812ULL, 0x000fe200078ec0ffULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x0000003cff80723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x20000093ff757230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe20000011621ULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000082ff3a723eULL, 0x000fe200020006ffULL,
0x20000087ff207230ULL, 0x000fe20000004100ULL, 0x00000010ff217819ULL, 0x000fc40000011686ULL,
0x0000008bff8f723eULL, 0x000fe200020006ffULL, 0x20000090ff8b7230ULL, 0x000fe20000004100ULL,
0x00000038ff82723eULL, 0x000fe200020006ffULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x0000003dff86723eULL, 0x000fe200020006ffULL, 0x2000008fff877230ULL, 0x000fe20000004100ULL,
0x00000081ff3b723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x000000ff35357812ULL, 0x000fe200078ec0ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000010ff3d7819ULL, 0x000fe20000011689ULL, 0x2000003bff3b7230ULL, 0x000fe20000004100ULL,
0x00000010ff387819ULL, 0x000fc4000001168dULL, 0x0000003fff81723eULL, 0x000fe400020006ffULL,
0x00000010ff3f7819ULL, 0x000fe4000001168aULL, 0x000000ff378a7812ULL, 0x000fe200078ec0ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000035ff89723eULL, 0x000fe400020006ffULL,
0x00001054383d7816ULL, 0x000fe4000000003dULL, 0x00000010ff377819ULL, 0x000fe20000011688ULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fc40000011634ULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000010ff357819ULL, 0x000fe40000011622ULL,
0x00000010ff387819ULL, 0x000fe20000011639ULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff887819ULL, 0x000fe4000001163eULL,
0x00000010ff207819ULL, 0x000fc40000011620ULL, 0x0000105437397816ULL, 0x000fe40000000034ULL,
0x0000105435387816ULL, 0x000fe40000000038ULL, 0x0000105488347816ULL, 0x000fe4000000008bULL,
0x00000010ff357819ULL, 0x000fe40000011630ULL, 0x00000010ff887819ULL, 0x000fe4000001163bULL,
0x0000105421207816ULL, 0x000fc40000000020ULL, 0x000010543f217816ULL, 0x000fe4000000003cULL,
0x00000010ff3c7819ULL, 0x000fe4000001168cULL, 0x00000010ff317819ULL, 0x000fe40000011631ULL,
0x00000010ff307819ULL, 0x000fe40000011663ULL, 0x00000010ff237819ULL, 0x000fe40000011623ULL,
0x00000010ff8c7819ULL, 0x000fc40000011687ULL, 0x00000010ff377819ULL, 0x000fe4000001163aULL,
0x0000105488357816ULL, 0x000fe20000000035ULL, 0x000000384038723cULL, 0x000fe200000418ffULL,
0x00000010ff887819ULL, 0x000fe40000011683ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff637819ULL, 0x000fc40000011662ULL,
0x0000105431307816ULL, 0x000fe40000000030ULL, 0x000010543c3c7816ULL, 0x000fe40000000023ULL,
0x000010548c317816ULL, 0x000fe20000000037ULL, 0x000000204020723cULL, 0x000f6200000418ffULL,
0x0000105488627816ULL, 0x000fe40000000085ULL, 0x0000105484637816ULL, 0x000fe40000000063ULL,
0x00000008ff337819ULL, 0x000fc40000011633ULL, 0x00000008ff877819ULL, 0x000fe20000011636ULL,
0x0000003c403c723cULL, 0x040fe200000418ffULL, 0x00000033ff83723eULL, 0x000fe400020006ffULL,
0x000000ff32847812ULL, 0x000fe400078ec0ffULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x000000ff64647812ULL, 0x000fe200078ec0ffULL,
0x000000344034723cULL, 0x000fe200000418ffULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x000000ff7a857812ULL, 0x000fc400078ec0ffULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fe20000011665ULL, 0x000000304030723cULL, 0x040fe200000418ffULL,
0x00000085ff88723eULL, 0x000fe200020006ffULL, 0x20000064ff857230ULL, 0x000fe20000004100ULL,
0x00000065ff7a723eULL, 0x000fe400020006ffULL, 0x00000010ff647819ULL, 0x000fe40000011680ULL,
0x00000010ff657819ULL, 0x000fe20000011681ULL, 0x000000624040723cULL, 0x000b6200000418ffULL,
0x00000010ff897819ULL, 0x000fe20000011689ULL, 0x2000007aff807230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fe2000001168aULL, 0x20000088ff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff867819ULL, 0x000fc40000011686ULL, 0x00000010ff637819ULL, 0x020fe40000011682ULL,
0x00000010ff627819ULL, 0x000fe40000011683ULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x0000105489647816ULL, 0x000fe20000000064ULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x000010548a657816ULL, 0x000fe20000000065ULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x0000105463627816ULL, 0x000fc40000000062ULL, 0x0000105486637816ULL, 0x000fe40000000087ULL,
0x00000008ff777819ULL, 0x000fe20000011677ULL, 0x000000642c20723cULL, 0x040b620000041820ULL,
0x000000ff76767812ULL, 0x000fe400078ec0ffULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff647819ULL, 0x020fe2000001167dULL,
0x000000622c40723cULL, 0x000b620000041840ULL, 0x00000010ff657819ULL, 0x000fc40000011684ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff627819ULL, 0x020fe4000001167fULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff637819ULL, 0x000fe40000011680ULL, 0x00000077ff77723eULL, 0x000fc400020006ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x0000105465647816ULL, 0x000fe20000000064ULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x0000105485657816ULL, 0x000fe4000000007eULL,
0x000010547b627816ULL, 0x000fe20000000062ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x000010547c637816ULL, 0x000fc40000000063ULL, 0x00000010ff797819ULL, 0x000fe20000011679ULL,
0x000000642c3c723cULL, 0x000b62000004183cULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff737819ULL, 0x000fc80000011673ULL, 0x00000010ff647819ULL, 0x020fe20000011678ULL,
0x000000622c38723cULL, 0x000b620000041838ULL, 0x00000010ff657819ULL, 0x000fc8000001167aULL,
0x0000105465647816ULL, 0x000fe40000000064ULL, 0x00000010ff637819ULL, 0x020fe40000011674ULL,
0x00000010ff627819ULL, 0x000fe40000011677ULL, 0x00000010ff747819ULL, 0x000fe40000011675ULL,
0x0000105463627816ULL, 0x000fe40000000062ULL, 0x0000105476657816ULL, 0x000fc40000000079ULL,
0x0000105474637816ULL, 0x000fca0000000073ULL, 0x000000642c34723cULL, 0x040b700000041834ULL,
0x000000622c30723cULL, 0x000b620000041830ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000200d0d7221ULL, 0x000fe20000010000ULL,
0x000000210c0c7221ULL, 0x000fe20000010000ULL, 0x0000004009097221ULL, 0x000fe20000010000ULL,
0x0000004108087221ULL, 0x000fe20000010000ULL, 0x0000003c05057221ULL, 0x000fe20000010000ULL,
0x0000003d44447221ULL, 0x000fe20000010000ULL, 0x0000003847477221ULL, 0x000fe20000010000ULL,
0x0000003948487221ULL, 0x000fe20000010000ULL, 0x000000244b4b7221ULL, 0x000fe20000010000ULL,
0x000000254c4c7221ULL, 0x000fe20000010000ULL, 0x000000284f4f7221ULL, 0x000fe20000010000ULL,
0x0000002950507221ULL, 0x000fe20000010000ULL, 0x0000003453537221ULL, 0x020fe20000010000ULL,
0x0000003554547221ULL, 0x000fe20000010000ULL, 0x0000003057577221ULL, 0x000fe20000010000ULL,
0x0000003158587221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000220b0b7221ULL, 0x000fe20000010000ULL, 0x000000230a0a7221ULL, 0x000fe20000010000ULL,
0x0000004207077221ULL, 0x000fe20000010000ULL, 0x0000004306067221ULL, 0x000fe20000010000ULL,
0x0000003e45457221ULL, 0x000fe20000010000ULL, 0x0000003f46467221ULL, 0x000fe20000010000ULL,
0x0000003a49497221ULL, 0x000fe20000010000ULL, 0x0000003b4a4a7221ULL, 0x000fe20000010000ULL,
0x000000264d4d7221ULL, 0x000fe20000010000ULL, 0x000000274e4e7221ULL, 0x000fe20000010000ULL,
0x0000002a51517221ULL, 0x000fe20000010000ULL, 0x0000002b52527221ULL, 0x000fe20000010000ULL,
0x0000003655557221ULL, 0x020fe20000010000ULL, 0x0000003756567221ULL, 0x000fe20000010000ULL,
0x0000003259597221ULL, 0x000fe20000010000ULL, 0x000000335a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000707200720cULL, 0x000fe20003f06070ULL,
0x010b8800ff227f8cULL, 0x000e58000c80043fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff9b2000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008012207811ULL, 0x000fe200078e40ffULL, 0x010b6000ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000005f2000720cULL, 0x000fda0003f06070ULL, 0x0000cad000000947ULL, 0x000fea0003800000ULL,
0x000000ffff727224ULL, 0x000fca00078e00ffULL, 0x00000002ff217819ULL, 0x000fe20000011672ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000372227812ULL, 0x042fe200078ec0ffULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000002172217207ULL, 0x000fe40002800000ULL,
0x000000ff22227207ULL, 0x000fe40006800000ULL, 0x0000000221257810ULL, 0x000fc80007ffe0ffULL,
0x0000000325217812ULL, 0x040fe400078ec0ffULL, 0x0000001225207211ULL, 0x020fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x010b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000120247810ULL, 0x000fe20007ffe0ffULL,
0x0000099000017945ULL, 0x000fe60003800000ULL, 0x0000005d2400720cULL, 0x000fda0003f06070ULL,
0x0000052000008947ULL, 0x000fea0003800000ULL, 0x000000015c297824ULL, 0x000fe200078e021bULL,
0x00000020032a7811ULL, 0x000fe200078e30ffULL, 0x0000000420247824ULL, 0x000fe200078e0221ULL,
0x000000021b317810ULL, 0x020fe20007ffe0ffULL, 0x0000001004267824ULL, 0x000fe200078e00ffULL,
0x010a000029257984ULL, 0x000e620000004800ULL, 0x00000100ff2b7424ULL, 0x000fe200078e00ffULL,
0x0000002024247811ULL, 0x000fe200078e30ffULL, 0x000000015c337824ULL, 0x000fe200078e0231ULL,
0x000000f0262d7812ULL, 0x000fe200078ec0ffULL, 0x0000001029267824ULL, 0x000fe200078e00ffULL,
0x000000245f237217ULL, 0x000fe20007800000ULL, 0x00000001332c7824ULL, 0x000fc800078e0204ULL,
0x0000000123237824ULL, 0x000fe400078e0a24ULL, 0x0000000129247824ULL, 0x000fc600078e022aULL,
0x000000235c237217ULL, 0x000fca0007800000ULL, 0x0000000123287824ULL, 0x000fe400078e0a5cULL,
0x0000000129237824ULL, 0x000fc600078e0204ULL, 0x000000281b00720cULL, 0x000fe40003f06070ULL,
0xfffffff026237812ULL, 0x000fe200078ee223ULL, 0x0000000133267824ULL, 0x040fe400078e022aULL,
0x0000001033337824ULL, 0x000fe200078e00ffULL, 0x0000e000232f7811ULL, 0x000fc800078e20ffULL,
0xfffffff0332c7812ULL, 0x000fe200078ee22cULL, 0x010ac00025257984ULL, 0x002e640000004800ULL,
0x0000002514247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002bULL,
0x0000002d24247210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e2000c101c46ULL,
0x000000283100720cULL, 0x000fe40003f06070ULL, 0x000000041b317810ULL, 0x000fe20007ffe0ffULL,
0x010a080029237984ULL, 0x000ea80000004800ULL, 0x000000015c337824ULL, 0x000fe200078e0231ULL,
0x0000e0002c2f7811ULL, 0x002fc600078e20ffULL, 0x00000001332c7824ULL, 0x000fe200078e0204ULL,
0x010ac00023237984ULL, 0x004e640000004800ULL, 0x0000002314267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002bULL, 0x0000002d26247210ULL, 0x000fe20007f3e0ffULL,
0x0000000133267824ULL, 0x040fe400078e022aULL, 0x0000001033337824ULL, 0x000fe400078e00ffULL,
0x000000ffff257224ULL, 0x000fc600008e0627ULL, 0xfffffff0332c7812ULL, 0x000fe400078ee22cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e2000c101c46ULL,
0x000000283100720cULL, 0x000fe40003f06070ULL, 0x000000061b317810ULL, 0x000fe20007ffe0ffULL,
0x010a100029237984ULL, 0x000ea80000004800ULL, 0x000000015c337824ULL, 0x000fe200078e0231ULL,
0x0000e0002c2f7811ULL, 0x002fe200078e20ffULL, 0x010ac00023237984ULL, 0x004e640000004800ULL,
0x0000002314267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002bULL,
0x0000002d26247210ULL, 0x000fe20007f3e0ffULL, 0x0000000133267824ULL, 0x040fe400078e022aULL,
0x00000001332a7824ULL, 0x040fe400078e0204ULL, 0x000000ffff257224ULL, 0x000fe400008e0627ULL,
0x0000001033337824ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e2000c101c46ULL, 0x000000283100720cULL, 0x000fe40003f06070ULL,
0xfffffff0332a7812ULL, 0x000fe200078ee22aULL, 0x010a180029237984ULL, 0x000ea80000004800ULL,
0x010ac00023237984ULL, 0x004ea40000004800ULL, 0x0000002314267224ULL, 0x004fe200078e0226ULL,
0x0000e0002a237811ULL, 0x000fc600078e20ffULL, 0x00005e0026267625ULL, 0x000fca00078e002bULL,
0x0000002d26247210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e2000c101c46ULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x000000015c297824ULL, 0x000fe200078e021bULL,
0x0000002003287811ULL, 0x000fe200078e30ffULL, 0x0000001004257824ULL, 0x000fe400078e00ffULL,
0x00000100ff2b7424ULL, 0x000fe200078e00ffULL, 0x010a000029237984ULL, 0x000e620000004800ULL,
0x0000000129247824ULL, 0x000fe200078e0228ULL, 0x000000f0252d7812ULL, 0x020fe200078ec0ffULL,
0x0000000129267824ULL, 0x040fe200078e0204ULL, 0x0000000229317810ULL, 0x040fe20007ffe0ffULL,
0x0000001029277824ULL, 0x000fc800078e00ffULL, 0x00000001312a7824ULL, 0x000fe200078e0204ULL,
0xfffffff027267812ULL, 0x000fc800078ee226ULL, 0x0000e000262f7811ULL, 0x000fe200078e20ffULL,
0x0000000128267824ULL, 0x000fe400078e0231ULL, 0x0000001031317824ULL, 0x000fca00078e00ffULL,
0xfffffff0312a7812ULL, 0x000fe400078ee22aULL, 0x0000000429317810ULL, 0x000fe20007ffe0ffULL,
0x010ac00023237984ULL, 0x002e640000004800ULL, 0x0000002314247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e8000b901c46ULL, 0x010a080029237984ULL, 0x000ea20000004800ULL,
0x0000e0002a2f7811ULL, 0x002fe200078e20ffULL, 0x0000000128247824ULL, 0x000fe400078e0231ULL,
0x00000001312a7824ULL, 0x040fe400078e0204ULL, 0x0000001031317824ULL, 0x000fca00078e00ffULL,
0xfffffff0312a7812ULL, 0x000fe400078ee22aULL, 0x0000000629317810ULL, 0x000fe20007ffe0ffULL,
0x010ac00023237984ULL, 0x004e640000004800ULL, 0x0000002314267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002bULL, 0x0000002d26267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e8000b901c46ULL, 0x010a100029237984ULL, 0x000ea20000004800ULL,
0x0000e0002a2f7811ULL, 0x002fe200078e20ffULL, 0x0000000128267824ULL, 0x000fe400078e0231ULL,
0x0000000131287824ULL, 0x040fe400078e0204ULL, 0x0000001031317824ULL, 0x000fca00078e00ffULL,
0xfffffff031287812ULL, 0x000fe200078ee228ULL, 0x010ac00023237984ULL, 0x004e640000004800ULL,
0x0000002314247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002bULL,
0x0000002d24247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000b901c46ULL,
0x010a180029237984ULL, 0x000ea20000004800ULL, 0x0000e00028257811ULL, 0x002fc600078e20ffULL,
0x010ac00023237984ULL, 0x004e640000004800ULL, 0x0000002314267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002bULL, 0x0000002d26267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff287224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804828ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000205b00720cULL, 0x000fe20003f04070ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x000000032200780cULL, 0x000fda0003f25270ULL, 0x000000f000008947ULL, 0x000fea0000800000ULL,
0x000000031500780cULL, 0x000fe40003f04070ULL, 0x0000000113137810ULL, 0x000fd60007ffe0ffULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000000400237824ULL, 0x000fe200078e0215ULL,
0x0000640013247a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff257424ULL, 0x000fe200078e00ffULL,
0x0000005e1300720cULL, 0x000fe20003f06070ULL, 0x0000000223237824ULL, 0x000fc800078e00ffULL,
0x0000640023247a24ULL, 0x000fe200078e0224ULL, 0x00010ac015237811ULL, 0x000fc600078e10ffULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024237faeULL, 0x0003e4000c121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000205b00720cULL, 0x000fe40003f04070ULL, 0x0000000122227810ULL, 0x000fc80007ffe0ffULL,
0x0000000322237812ULL, 0x002fc800078ec0ffULL, 0x000000ff23237207ULL, 0x000fc60004000000ULL,
0x00000002ff228819ULL, 0x000fca0000011622ULL, 0x0000000121217824ULL, 0x000fc800078e0222ULL,
0x0000004021227824ULL, 0x040fe200078e00ffULL, 0x0000002021207211ULL, 0x000fc800078ff0ffULL,
0x000000c022217812ULL, 0x000fca00078ec0ffULL, 0x0000010020217824ULL, 0x000fe400078e0221ULL,
0x0000000160207824ULL, 0x000fe200078e0223ULL, 0x00010a0015237811ULL, 0x040fe200078e10ffULL,
0x0000000115227824ULL, 0x140fe400078e0221ULL, 0x0000680020207a24ULL, 0x000fe400078e0221ULL,
0x00000004ff217424ULL, 0x000fe200078e00ffULL, 0x0000005f2200720cULL, 0x000fe20003f06070ULL,
0x0000000115207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fd000078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8000ff207f8cULL, 0x000e62000c80043fULL,
0x000000ff7200720cULL, 0x000fe20003f05270ULL, 0x000007e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff717224ULL, 0x002fd600078e0021ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b18005c207f8cULL, 0x000e64000c80043fULL,
0x000000ffff247224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010b1c005c177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007804824ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002220227210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e21ULL, 0x003d09002200780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402200780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff177819ULL, 0x000fc80000011423ULL,
0x0000002217177211ULL, 0x000fca00078110ffULL, 0x000000ffff227224ULL, 0x000fca00000e0623ULL,
0x0000000217177819ULL, 0x000fc80000001222ULL, 0x000000170000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x010b1c005c177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804824ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001004177824ULL, 0x000fe200078e00ffULL, 0x00000001ff207819ULL, 0x000fc80000011604ULL,
0x0000007017177812ULL, 0x000fe400078ec0ffULL, 0x0000000c20207812ULL, 0x000fca00078ec0ffULL,
0x0000000117277824ULL, 0x000fca00078e0220ULL, 0x0101000027227984ULL, 0x000e680000000800ULL,
0x0103000027237984ULL, 0x0004e20000000800ULL, 0x000000112200720bULL, 0x002fe20003f1d000ULL,
0x00012cd27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000177806ULL, 0x004fc800000e0100ULL,
0x0000ffff17287812ULL, 0x000fe2000780c0ffULL, 0x0000043000027945ULL, 0x000fe20003800000ULL,
0x00000001ff177424ULL, 0x000fe400078e00ffULL, 0x000000ffff247224ULL, 0x000fd200078e0011ULL,
0x000003f000008947ULL, 0x000fea0003800000ULL, 0x000000026100780cULL, 0x000fe40003f05270ULL,
0x000000112200720bULL, 0x000fe20003f34000ULL, 0x00012c927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000257806ULL, 0x000fc400008e0100ULL, 0x0000002211247209ULL, 0x000fe20007810000ULL,
0x0000033000037945ULL, 0x000fe20003800000ULL, 0x0000991025207816ULL, 0x000fc600000000ffULL,
0x0105002427008388ULL, 0x0003e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x8000002411117221ULL, 0x002fe20000010000ULL,
0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL, 0x0000001100297308ULL, 0x000e640000000800ULL,
0x000000290e0e7220ULL, 0x002fc80000410000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00012be27f007947ULL, 0x000fea000b800000ULL, 0x00001f6929117589ULL, 0x0002a400000e0000ULL,
0x000000110d0d7220ULL, 0x084fe20000410000ULL, 0x000000110c0c7220ULL, 0x080fe20000410000ULL,
0x0000001109097220ULL, 0x080fe20000410000ULL, 0x0000001108087220ULL, 0x080fe20000410000ULL,
0x0000001105057220ULL, 0x080fe20000410000ULL, 0x0000001144447220ULL, 0x080fe20000410000ULL,
0x0000001147477220ULL, 0x080fe20000410000ULL, 0x0000001148487220ULL, 0x080fe20000410000ULL,
0x000000114b4b7220ULL, 0x080fe20000410000ULL, 0x000000114c4c7220ULL, 0x080fe20000410000ULL,
0x000000114f4f7220ULL, 0x080fe20000410000ULL, 0x0000001150507220ULL, 0x080fe20000410000ULL,
0x0000001153537220ULL, 0x080fe20000410000ULL, 0x0000001154547220ULL, 0x080fe20000410000ULL,
0x0000001157577220ULL, 0x080fe20000410000ULL, 0x0000001158587220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00012af27f007947ULL, 0x000fea000b800000ULL,
0x00001f6829117589ULL, 0x00046400000e0000ULL, 0x000000110b0b7220ULL, 0x082fe20000410000ULL,
0x000000110a0a7220ULL, 0x080fe20000410000ULL, 0x0000001107077220ULL, 0x080fe20000410000ULL,
0x0000001106067220ULL, 0x080fe20000410000ULL, 0x0000001145457220ULL, 0x080fe20000410000ULL,
0x0000001146467220ULL, 0x080fe20000410000ULL, 0x0000001149497220ULL, 0x080fe20000410000ULL,
0x000000114a4a7220ULL, 0x080fe20000410000ULL, 0x000000114d4d7220ULL, 0x080fe20000410000ULL,
0x000000114e4e7220ULL, 0x080fe20000410000ULL, 0x0000001151517220ULL, 0x080fe20000410000ULL,
0x0000001152527220ULL, 0x080fe20000410000ULL, 0x0000001155557220ULL, 0x080fe20000410000ULL,
0x0000001156567220ULL, 0x080fe20000410000ULL, 0x0000001159597220ULL, 0x080fe20000410000ULL,
0x000000115a5a7220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff28ff7812ULL, 0x000fda0007806025ULL, 0x8000002422220221ULL, 0x000fe20000010000ULL,
0x00007610ff170816ULL, 0x000fc60000000017ULL, 0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL,
0x0000002200180308ULL, 0x000e640000000800ULL, 0x0000001823230220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000e230e7221ULL, 0x008fe20000010000ULL,
0x000000ffff117224ULL, 0x000fc400078e0024ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff17ff7812ULL, 0x000fe2000786c0ffULL, 0x0000012000017945ULL, 0x000fd80003800000ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000018ff19723eULL, 0x000fc800000010ffULL,
0x0000541019227816ULL, 0x000fe20000000019ULL, 0x000129327f007947ULL, 0x000fea000b800000ULL,
0x00001f6922197589ULL, 0x0002e400000e0000ULL, 0x000129727f007947ULL, 0x000fea000b800000ULL,
0x00001f68221a7589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001069277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x000107a000207802ULL, 0x000fc40000000f00ULL, 0x0001324000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001869277810ULL, 0x002fe40007ffe0ffULL, 0x000107f000207802ULL, 0x000fc40000000f00ULL,
0x000131f000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001c20783bULL, 0x002e620000004200ULL,
0x000000726900720cULL, 0x000fe20003f46070ULL, 0x0000178000017945ULL, 0x000fe20003800000ULL,
0x000000125b00720cULL, 0x000fe20003fc3070ULL, 0x00000000662c783bULL, 0x000f220000004200ULL,
0x000000726800720cULL, 0x000fc40003f26070ULL, 0x000000125b00720cULL, 0x000fe20003f03070ULL,
0x000000006724783bULL, 0x004ea80000004200ULL, 0x000000001d28783bULL, 0x000ee20000004200ULL,
0x00000010ff367819ULL, 0x102fe40000011620ULL, 0x000000ff20907812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3f7819ULL, 0x000fc40000011620ULL, 0x0000ffff20397812ULL, 0x000fe400078ec0ffULL,
0x00000010ff377819ULL, 0x100fe40000011621ULL, 0x000000ff218f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe40000011621ULL, 0x0000ffff21417812ULL, 0x000fe400078ec0ffULL,
0x00000010ff357819ULL, 0x000fc40000011622ULL, 0x000000ff228c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7d7819ULL, 0x000fe40000011622ULL, 0x0000ffff22347812ULL, 0x000fe400078ec0ffULL,
0x00000010ff407819ULL, 0x100fe40000011623ULL, 0x000000ff238d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff917819ULL, 0x000fc40000011623ULL, 0x0000ffff23387812ULL, 0x000fe400078ec0ffULL,
0x000000ff2c237812ULL, 0x010fe400078ec0ffULL, 0x0000b0001e207811ULL, 0x000fe400078e20ffULL,
0x000000ff24217812ULL, 0x004fe400078ec0ffULL, 0x000000ff25227812ULL, 0x000fe400078ec0ffULL,
0x00000010ff337819ULL, 0x008fc40000011629ULL, 0x000000ff29837812ULL, 0x040fe400078ec0ffULL,
0x00000018ff857819ULL, 0x000fe40000011629ULL, 0x0000ffff29317812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3b7819ULL, 0x100fe4000001162bULL, 0x000000ff2b807812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fc4000001162bULL, 0x0000ffff2b647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff937819ULL, 0x100fe4000001162cULL, 0x00000018ff7b7819ULL, 0x000fe4000001162cULL,
0x0000ffff2c657812ULL, 0x000fe400078ec0ffULL, 0x00000023ff2c723eULL, 0x000fe400020006ffULL,
0x00000021ff29723eULL, 0x000fc400020006ffULL, 0x00000022ff2b723eULL, 0x000fe400020006ffULL,
0x000000002020783bULL, 0x000e620000000200ULL, 0x00000010ff327819ULL, 0x100fe20000011628ULL,
0x20000029ff297230ULL, 0x000fe20000004100ULL, 0x000000ff28827812ULL, 0x040fe200078ec0ffULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x00000018ff847819ULL, 0x000fe40000011628ULL,
0x0000ffff28307812ULL, 0x000fe400078ec0ffULL, 0x000000ff2d287812ULL, 0x000fc400078ec0ffULL,
0x00000010ff947819ULL, 0x100fe4000001162dULL, 0x00000018ff7c7819ULL, 0x000fe4000001162dULL,
0x0000ffff2d7f7812ULL, 0x000fe400078ec0ffULL, 0x00000028ff2d723eULL, 0x000fe400020006ffULL,
0x00000010ff287819ULL, 0x000fe40000011624ULL, 0x0000ffff24437812ULL, 0x000fc400078ec0ffULL,
0x00000018ff427819ULL, 0x000fe20000011624ULL, 0x2000002cff247230ULL, 0x000fe20000004100ULL,
0x00000010ff3a7819ULL, 0x100fe4000001162aULL, 0x000000ff2a817812ULL, 0x040fe400078ec0ffULL,
0x00000018ff927819ULL, 0x000fe4000001162aULL, 0x0000ffff2a3e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2a7819ULL, 0x000fc40000011625ULL, 0x0000b0001f2c7811ULL, 0x000fe400078e20ffULL,
0x0000ffff25867812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3c7819ULL, 0x000fe20000011625ULL,
0x2000002dff257230ULL, 0x000fe20000004100ULL, 0x000000ff28287812ULL, 0x000fe200078ec0ffULL,
0x000000192020b231ULL, 0x082fe200003400ffULL, 0x000000ff2a2a7812ULL, 0x000fe200078ec0ffULL,
0x000000192222b231ULL, 0x000fe200003400ffULL, 0x00000010ff797819ULL, 0x100fe2000001162eULL,
0x0000001a2121b231ULL, 0x080fe200003400ffULL, 0x000000ff2e777812ULL, 0x000fe200078ec0ffULL,
0x0000001a2323b231ULL, 0x000fe200003400ffULL, 0x00000018ff747819ULL, 0x000fc4000001162eULL,
0x0000ffff2e737812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7a7819ULL, 0x100fe4000001162fULL,
0x000000ff2f787812ULL, 0x040fe400078ec0ffULL, 0x00000018ff767819ULL, 0x000fe4000001162fULL,
0x0000ffff2f757812ULL, 0x000fe400078ec0ffULL, 0x000000002c2c783bULL, 0x000e620000000200ULL,
0x00000028ff28723eULL, 0x000fc400020006ffULL, 0x0000002aff2a723eULL, 0x000fe400020006ffULL,
0x00000010ff877819ULL, 0x100fe40000011626ULL, 0x000000ff263d7812ULL, 0x040fe200078ec0ffULL,
0x2000002aff2a7230ULL, 0x000fe20000004100ULL, 0x0000ffff26897812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8e7819ULL, 0x000fe20000011626ULL, 0x20000028ff267230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fc40000011627ULL, 0x000000ff27887812ULL, 0x040fe400078ec0ffULL,
0x0000ffff278a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff637819ULL, 0x000fe40000011627ULL,
0x00000010ff287819ULL, 0x000fe40000011629ULL, 0x00000010ff297819ULL, 0x000fe4000001162bULL,
0x00000010ff277819ULL, 0x000fc40000011626ULL, 0x00000010ff2a7819ULL, 0x000fe4000001162aULL,
0x0000105427287816ULL, 0x000fe40000000028ULL, 0x000010542a297816ULL, 0x000fe40000000029ULL,
0x000000ff93937812ULL, 0x000fe400078ec0ffULL, 0x000000ff94947812ULL, 0x000fe400078ec0ffULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x000000282028723cULL, 0x000f6200000418ffULL,
0x00000094ff94723eULL, 0x000fe200020006ffULL, 0x000000192c2cb231ULL, 0x082fe200003400ffULL,
0x00000010ff247819ULL, 0x000fe20000011624ULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe20000011625ULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x000000192e2eb231ULL, 0x000fe200003400ffULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x0000001a2d2db231ULL, 0x080fe200003400ffULL, 0x00000010ff937819ULL, 0x000fe20000011693ULL,
0x0000001a2f2fb231ULL, 0x000fe200003400ffULL, 0x00000010ff947819ULL, 0x000fc40000011694ULL,
0x0000105493247816ULL, 0x000fe40000000024ULL, 0x0000105494257816ULL, 0x000fe40000000025ULL,
0x000000ff35357812ULL, 0x000fe400078ec0ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x000000ff40407812ULL, 0x000fe400078ec0ffULL, 0x000000242c28723cULL, 0x020be20000041828ULL,
0x00000035ff35723eULL, 0x000fc400020006ffULL, 0x00000008ff347819ULL, 0x000fe40000011634ULL,
0x00000008ff387819ULL, 0x000fe40000011638ULL, 0x2000008fff257230ULL, 0x020fe20000004100ULL,
0x000000ff368f7812ULL, 0x000fe200078ec0ffULL, 0x20000090ff247230ULL, 0x000fe20000004100ULL,
0x0000007dff26723eULL, 0x000fe400020006ffULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x00000092ff7d723eULL, 0x000fe200020006ffULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x0000008eff8e723eULL, 0x000fc400020006ffULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x00000040ff92723eULL, 0x000fe200020006ffULL,
0x20000035ff407230ULL, 0x000fe20000004100ULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x2000008eff367230ULL, 0x000fe20000004100ULL, 0x00000034ff34723eULL, 0x000fe200020006ffULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x0000008dff8d723eULL, 0x000fc400020006ffULL, 0x000000ff37907812ULL, 0x000fe200078ec0ffULL,
0x20000088ff377230ULL, 0x000fe20000004100ULL, 0x00000043ff35723eULL, 0x000fe200020006ffULL,
0x20000034ff437230ULL, 0x000fe20000004100ULL, 0x00000008ff867819ULL, 0x000fe20000011686ULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000035ff347230ULL, 0x000fe20000004100ULL, 0x000000ff87877812ULL, 0x000fe400078ec0ffULL,
0x00000091ff27723eULL, 0x000fe200020006ffULL, 0x20000038ff917230ULL, 0x000fe20000004100ULL,
0x00000008ff8e7819ULL, 0x000fe20000011641ULL, 0x2000008fff417230ULL, 0x000fe20000004100ULL,
0x00000090ff90723eULL, 0x000fe200020006ffULL, 0x20000027ff277230ULL, 0x000fe20000004100ULL,
0x00000008ff887819ULL, 0x000fe20000011639ULL, 0x20000063ff397230ULL, 0x000fe20000004100ULL,
0x0000003cff3c723eULL, 0x000fe200020006ffULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000086ff38723eULL, 0x000fc400020006ffULL, 0x0000003dff3d723eULL, 0x000fe200020006ffULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x000000ff8b8b7812ULL, 0x000fe200078ec0ffULL,
0x20000038ff387230ULL, 0x000fe20000004100ULL, 0x00000087ff35723eULL, 0x000fe200020006ffULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000008ff897819ULL, 0x000fe20000011689ULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000088ff63723eULL, 0x000fe200020006ffULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff8a7819ULL, 0x000fc4000001168aULL, 0x0000008eff88723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fe40000011624ULL,
0x00000010ff417819ULL, 0x000fe20000011641ULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x0000008bff8e723eULL, 0x000fe400020006ffULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00000010ff927819ULL, 0x000fe20000011692ULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fc400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x20000089ff8b7230ULL, 0x000fe20000004100ULL,
0x0000003fff3f723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x0000105441247816ULL, 0x000fe20000000024ULL, 0x2000008aff8f7230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe20000011625ULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000010ff907819ULL, 0x000fc40000011690ULL, 0x0000105492417816ULL, 0x000fe4000000008dULL,
0x00000010ff8d7819ULL, 0x000fe4000001163cULL, 0x00000010ff387819ULL, 0x000fe40000011638ULL,
0x000000ff33877812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3d7819ULL, 0x000fe4000001163dULL,
0x00000010ff3c7819ULL, 0x000fc40000011635ULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff337819ULL, 0x000fe40000011640ULL, 0x0000105490257816ULL, 0x000fe40000000025ULL,
0x000010548d357816ULL, 0x000fe40000000038ULL, 0x00000010ff907819ULL, 0x000fe40000011639ULL,
0x00000008ff897819ULL, 0x000fc40000011630ULL, 0x00000008ff8a7819ULL, 0x000fe40000011631ULL,
0x000010543c387816ULL, 0x000fe4000000003dULL, 0x00000010ff397819ULL, 0x000fe4000001168eULL,
0x000000ff32867812ULL, 0x000fe400078ec0ffULL, 0x0000105433407816ULL, 0x000fe4000000008cULL,
0x00000010ff317819ULL, 0x000fc40000011626ULL, 0x00000010ff307819ULL, 0x000fe40000011643ULL,
0x00000010ff3d7819ULL, 0x000fe40000011636ULL, 0x00000010ff3c7819ULL, 0x000fe4000001168bULL,
0x00000010ff8e7819ULL, 0x000fe40000011662ULL, 0x00000010ff327819ULL, 0x000fe40000011627ULL,
0x00000010ff917819ULL, 0x000fe20000011691ULL, 0x000000242024723cULL, 0x000f6200000418ffULL,
0x00000010ff337819ULL, 0x000fc40000011642ULL, 0x00000010ff347819ULL, 0x000fe40000011634ULL,
0x00000010ff8c7819ULL, 0x000fe40000011637ULL, 0x00000010ff8f7819ULL, 0x000fe2000001168fULL,
0x000000402040723cULL, 0x000fe200000418ffULL, 0x00000010ff627819ULL, 0x000fe40000011663ULL,
0x00000010ff3f7819ULL, 0x000fe4000001163fULL, 0x00000010ff637819ULL, 0x000fc40000011688ULL,
0x0000105431307816ULL, 0x000fe40000000030ULL, 0x000010543d3c7816ULL, 0x000fe4000000003cULL,
0x0000105432317816ULL, 0x000fe40000000091ULL, 0x0000105433347816ULL, 0x000fe40000000034ULL,
0x0000105439397816ULL, 0x000fe4000000008cULL, 0x00001054903d7816ULL, 0x000fe2000000008fULL,
0x000000302030723cULL, 0x000fe200000418ffULL, 0x000010543f627816ULL, 0x000fc40000000062ULL,
0x000010548e637816ULL, 0x000fe40000000063ULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x000000342034723cULL, 0x040fe200000418ffULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x000000ff3a8b7812ULL, 0x000fe200078ec0ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x000000ff3b8c7812ULL, 0x000fe200078ec0ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff887819ULL, 0x000fe2000001163eULL, 0x000000382038723cULL, 0x000fe200000418ffULL,
0x00000084ff84723eULL, 0x000fc400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000008ff647819ULL, 0x000fe20000011664ULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fe20000011665ULL, 0x0000003c203c723cULL, 0x040fe200000418ffULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000088ff8d723eULL, 0x000fe200020006ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000064ff8e723eULL, 0x000fe200020006ffULL,
0x000000622020723cULL, 0x000b6200000418ffULL, 0x00000065ff88723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe20000011682ULL,
0x2000008dff827230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe20000011683ULL,
0x2000008eff837230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x020fe20000011686ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fc40000011687ULL,
0x0000105463647816ULL, 0x000fe40000000064ULL, 0x0000105462657816ULL, 0x000fe40000000065ULL,
0x00000010ff637819ULL, 0x000fe40000011684ULL, 0x00000010ff627819ULL, 0x000fe40000011689ULL,
0x00000010ff857819ULL, 0x000fe20000011685ULL, 0x000000642c24723cULL, 0x000f620000041824ULL,
0x00000010ff8a7819ULL, 0x000fc4000001168aULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x0000105463627816ULL, 0x000fe40000000062ULL, 0x0000105485637816ULL, 0x000fe2000000008aULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x000000ff79797812ULL, 0x000fe200078ec0ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x000000ff7a7a7812ULL, 0x000fe200078ec0ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x000000622c20723cULL, 0x000b620000041820ULL,
0x00000010ff7d7819ULL, 0x000fc4000001167dULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x020fe40000011682ULL,
0x00000010ff637819ULL, 0x000fe20000011683ULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000008ff7f7819ULL, 0x000fc4000001167fULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00000010ff647819ULL, 0x000fe20000011681ULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe20000011680ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff8c7819ULL, 0x000fc4000001168cULL, 0x000010547d627816ULL, 0x000fe40000000062ULL,
0x000010547e637816ULL, 0x000fe40000000063ULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x000010548b647816ULL, 0x000fe20000000064ULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x000010548c657816ULL, 0x000fe20000000065ULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x000000622c30723cULL, 0x000b620000041830ULL,
0x00000010ff797819ULL, 0x000fc40000011679ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000008ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff627819ULL, 0x020fe20000011677ULL,
0x000000642c40723cULL, 0x000b620000041840ULL, 0x00000010ff637819ULL, 0x000fe40000011678ULL,
0x00000008ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff7b7819ULL, 0x000fc4000001167bULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff647819ULL, 0x020fe40000011688ULL,
0x00000010ff657819ULL, 0x000fe4000001167fULL, 0x0000105479627816ULL, 0x000fe40000000062ULL,
0x000010547a637816ULL, 0x000fe40000000063ULL, 0x00000074ff74723eULL, 0x000fc400020006ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x000010547b647816ULL, 0x000fe20000000064ULL,
0x000000622c38723cULL, 0x000b620000041838ULL, 0x000010547c657816ULL, 0x000fe20000000065ULL,
0x20000076ff767230ULL, 0x000fe40000004100ULL, 0x20000075ff757230ULL, 0x000fc60000004100ULL,
0x0000000172627810ULL, 0x020fe20007ffe0ffULL, 0x000000642c34723cULL, 0x000b620000041834ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x000000626900720cULL, 0x000fe40005746470ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff657819ULL, 0x020fe40000011674ULL,
0x00000010ff647819ULL, 0x000fc40000011673ULL, 0x000000626800720cULL, 0x000fe40004f26470ULL,
0x0000105465647816ULL, 0x000fe40000000064ULL, 0x0000105476657816ULL, 0x000fce0000000075ULL,
0x000000642c3c723cULL, 0x000b62000004183cULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000240d0d7221ULL, 0x000fe20000010000ULL,
0x000000250c0c7221ULL, 0x000fe20000010000ULL, 0x0000002009097221ULL, 0x000fe20000010000ULL,
0x0000002108087221ULL, 0x000fe20000010000ULL, 0x0000004005057221ULL, 0x000fe20000010000ULL,
0x0000004144447221ULL, 0x000fe20000010000ULL, 0x0000003047477221ULL, 0x000fe20000010000ULL,
0x0000003148487221ULL, 0x000fe20000010000ULL, 0x000000284b4b7221ULL, 0x000fe20000010000ULL,
0x000000294c4c7221ULL, 0x000fe20000010000ULL, 0x000000344f4f7221ULL, 0x000fe20000010000ULL,
0x0000003550507221ULL, 0x000fe20000010000ULL, 0x0000003853537221ULL, 0x000fe20000010000ULL,
0x0000003954547221ULL, 0x000fe20000010000ULL, 0x0000003c57577221ULL, 0x020fe20000010000ULL,
0x0000003d58587221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000260b0b7221ULL, 0x000fe20000010000ULL, 0x000000270a0a7221ULL, 0x000fe20000010000ULL,
0x0000002207077221ULL, 0x000fe20000010000ULL, 0x0000002306067221ULL, 0x000fe20000010000ULL,
0x0000004245457221ULL, 0x000fe20000010000ULL, 0x0000004346467221ULL, 0x000fe20000010000ULL,
0x0000003249497221ULL, 0x000fe20000010000ULL, 0x000000334a4a7221ULL, 0x000fe20000010000ULL,
0x0000002a4d4d7221ULL, 0x000fe20000010000ULL, 0x0000002b4e4e7221ULL, 0x000fe20000010000ULL,
0x0000003651517221ULL, 0x000fe20000010000ULL, 0x0000003752527221ULL, 0x000fe20000010000ULL,
0x0000003a55557221ULL, 0x000fe20000010000ULL, 0x0000003b56567221ULL, 0x000fe20000010000ULL,
0x0000003e59597221ULL, 0x020fe20000010000ULL, 0x0000003f5a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x000e62000c80043fULL, 0x00000002ff237819ULL, 0x000fe20000011662ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000000125b00720cULL, 0x000fc40003fc3070ULL,
0x0000002362237207ULL, 0x040fe40002800000ULL, 0x0000000362627812ULL, 0x000fe400078ec0ffULL,
0x0000000223277810ULL, 0x000fe40007ffe0ffULL, 0x000000125b00720cULL, 0x000fe40003f03070ULL,
0x00000040ff297803ULL, 0x000fe40000000000ULL, 0x000000ff62237207ULL, 0x000fc40006800000ULL,
0x0000000327257812ULL, 0x040fe400078ec0ffULL, 0x0000001227227211ULL, 0x000fe200078ff0ffULL,
0x000000ffff2d7224ULL, 0x022fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010b8400ff247984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000024ff7812ULL, 0x002fe200078c4871ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026202b7210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e21ULL,
0x003d09002b00780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011427ULL, 0x0000002b24247211ULL, 0x000fca00078d10ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x0000000224247819ULL, 0x000fc80000001227ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8400ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe400078c4871ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fc40000015200ULL,
0x010b8c00ff247984ULL, 0x000e620000000800ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000024ff7812ULL, 0x002fe200078c482dULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026202b7210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e21ULL, 0x003d09002b00780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011427ULL,
0x0000002b24247211ULL, 0x000fca00078d10ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x0000000224247819ULL, 0x000fc80000001227ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe400078c482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000122207810ULL, 0x000fe20007ffe0ffULL, 0x0000097000017945ULL, 0x000fe60003800000ULL,
0x0000005d2000720cULL, 0x000fda0003fc6070ULL, 0x000005100000e947ULL, 0x000fea0003800000ULL,
0x000000015c2a7824ULL, 0x000fe200078e021bULL, 0x000000021b317810ULL, 0x000fe20007ffe0ffULL,
0x0000001004247824ULL, 0x000fe400078e00ffULL, 0x00000040032b7824ULL, 0x000fe200078e022aULL,
0x010a00002a267984ULL, 0x000e620000004800ULL, 0x00000100ff2c7424ULL, 0x000fe200078e00ffULL,
0x000000f0242d7812ULL, 0x000fe200078ec0ffULL, 0x0000000422247824ULL, 0x000fe400078e0225ULL,
0x000000102a2f7824ULL, 0x000fc400078e00ffULL, 0x0000004024247824ULL, 0x000fe400078e00ffULL,
0x000000015c337824ULL, 0x000fc600078e0231ULL, 0x000000245f277217ULL, 0x000fe20007800000ULL,
0x00000001332e7824ULL, 0x040fe400078e0204ULL, 0x0000001033337824ULL, 0x000fe400078e00ffULL,
0x0000000127277824ULL, 0x000fe400078e0a24ULL, 0x000000012a247824ULL, 0x000fe200078e0204ULL,
0xfffffff0332e7812ULL, 0x000fe400078ee22eULL, 0x000000275c277217ULL, 0x000fe20007800000ULL,
0x010ac00026217984ULL, 0x0022a40000004800ULL, 0xfffffff02f267812ULL, 0x002fc400078ee224ULL,
0x0000000127247824ULL, 0x000fe400078e0a5cULL, 0x0000c000262f7811ULL, 0x000fe400078e20ffULL,
0x000000022b267810ULL, 0x000fe20007ffe0ffULL, 0x0000002114217224ULL, 0x004fc800078e022bULL,
0x00005e0021207625ULL, 0x000fca00078e002cULL, 0x0000002d20207210ULL, 0x000fca0007fde0ffULL,
0x000000ffff217224ULL, 0x000fe200030e0621ULL, 0x000000241b00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000202f7faeULL, 0x0003e8000f101c46ULL,
0x010a08002a287984ULL, 0x000ea20000004800ULL, 0x0000c0002e2f7811ULL, 0x002fe400078e20ffULL,
0x000000042b207810ULL, 0x040fe40007ffe0ffULL, 0x000000062b2b7810ULL, 0x000fe20007ffe0ffULL,
0x010ac00028277984ULL, 0x004e640000004800ULL, 0x0000002714277224ULL, 0x002fc800078e0226ULL,
0x00005e0027267625ULL, 0x000fca00078e002cULL, 0x0000002d26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000243100720cULL, 0x000fe40003fc6070ULL,
0x000000041b317810ULL, 0x000fca0007ffe0ffULL, 0x000000015c337824ULL, 0x000fc800078e0231ULL,
0x00000001332e7824ULL, 0x040fe400078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000f101c46ULL, 0x0000001033337824ULL, 0x000fc600078e00ffULL,
0x010a10002a287984ULL, 0x000ea40000004800ULL, 0xfffffff0332e7812ULL, 0x000fc800078ee22eULL,
0x0000c0002e2f7811ULL, 0x002fe200078e20ffULL, 0x010ac00028217984ULL, 0x004e640000004800ULL,
0x0000002114217224ULL, 0x002fc800078e0220ULL, 0x00005e0021207625ULL, 0x000fca00078e002cULL,
0x0000002d20207210ULL, 0x000fca0007fde0ffULL, 0x000000ffff217224ULL, 0x000fe200030e0621ULL,
0x000000243100720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000202f7faeULL, 0x0003e8000f101c46ULL, 0x010a18002a287984ULL, 0x000ea80000004800ULL,
0x010ac00028277984ULL, 0x004ea40000004800ULL, 0x0000002714277224ULL, 0x004fe200078e022bULL,
0x000000061b2b7810ULL, 0x000fc60007ffe0ffULL, 0x00005e0027267625ULL, 0x000fca00078e002cULL,
0x0000002d26267210ULL, 0x000fe20007fde0ffULL, 0x000000015c2d7824ULL, 0x000fc800078e022bULL,
0x000000012d2c7824ULL, 0x000fe400078e0204ULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x000000242b00720cULL, 0x000fe20003fc6070ULL, 0x000000102d2d7824ULL, 0x000fca00078e00ffULL,
0xfffffff02d2c7812ULL, 0x000fc800078ee22cULL, 0x0000c0002c217811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026217faeULL, 0x0003e2000f101c46ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x000000015c287824ULL, 0x000fe400078e021bULL,
0x0000001004267824ULL, 0x000fe400078e00ffULL, 0x00000040032a7824ULL, 0x000fe200078e0228ULL,
0x010a000028247984ULL, 0x000e620000004800ULL, 0x00000100ff2c7424ULL, 0x000fe200078e00ffULL,
0x000000f0262b7812ULL, 0x000fe200078ec0ffULL, 0x0000000128267824ULL, 0x040fe200078e0204ULL,
0x00000002282f7810ULL, 0x040fe20007ffe0ffULL, 0x0000001028277824ULL, 0x000fc800078e00ffULL,
0x000000012f2e7824ULL, 0x000fe200078e0204ULL, 0xfffffff027267812ULL, 0x000fe200078ee226ULL,
0x000000102f2f7824ULL, 0x000fc600078e00ffULL, 0x0000c000262d7811ULL, 0x000fe400078e20ffULL,
0x000000022a267810ULL, 0x000fe40007ffe0ffULL, 0xfffffff02f2e7812ULL, 0x000fe400078ee22eULL,
0x00000004282f7810ULL, 0x000fe20007ffe0ffULL, 0x010ac00024217984ULL, 0x002e640000004800ULL,
0x0000002114217224ULL, 0x002fc800078e022aULL, 0x00005e0021207625ULL, 0x000fca00078e002cULL,
0x0000002b20207210ULL, 0x000fca0007fde0ffULL, 0x000000ffff217224ULL, 0x000fca00030e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000202d7faeULL, 0x0003e8000b901c46ULL,
0x010a080028247984ULL, 0x000ea20000004800ULL, 0x0000c0002e2d7811ULL, 0x002fe200078e20ffULL,
0x000000012f2e7824ULL, 0x040fe200078e0204ULL, 0x000000042a207810ULL, 0x040fe20007ffe0ffULL,
0x000000102f2f7824ULL, 0x000fe200078e00ffULL, 0x000000062a2a7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff02f2e7812ULL, 0x000fe200078ee22eULL, 0x010ac00024277984ULL, 0x004e640000004800ULL,
0x0000002714277224ULL, 0x002fc800078e0226ULL, 0x00005e0027267625ULL, 0x000fca00078e002cULL,
0x0000002b26267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0003e8000b901c46ULL,
0x010a100028247984ULL, 0x000ea20000004800ULL, 0x0000c0002e2d7811ULL, 0x002fc600078e20ffULL,
0x010ac00024217984ULL, 0x004e640000004800ULL, 0x0000002114217224ULL, 0x002fc800078e0220ULL,
0x00005e0021207625ULL, 0x000fca00078e002cULL, 0x0000002b20207210ULL, 0x000fca0007fde0ffULL,
0x000000ffff217224ULL, 0x000fca00030e0621ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000202d7faeULL, 0x0003e8000b901c46ULL, 0x010a180028247984ULL, 0x000ea80000004800ULL,
0x010ac00024277984ULL, 0x004ea40000004800ULL, 0x0000002714277224ULL, 0x004fc800078e022aULL,
0x00005e0027267625ULL, 0x000fca00078e002cULL, 0x0000002b26267210ULL, 0x000fe40007fde0ffULL,
0x00000006282b7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff277224ULL, 0x000fe400030e0627ULL,
0x000000012b2a7824ULL, 0x040fe400078e0204ULL, 0x000000102b2b7824ULL, 0x000fca00078e00ffULL,
0xfffffff02b2a7812ULL, 0x000fc800078ee22aULL, 0x0000c0002a217811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026217faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x002e64000c80043fULL, 0x000000ffff2d7224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b8c00ff247984ULL, 0x000e620000000800ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000024ff7812ULL, 0x002fe200078c482dULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026202b7210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e21ULL,
0x003d09002b00780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011427ULL, 0x0000002b24247211ULL, 0x000fca00078d10ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x0000000224247819ULL, 0x000fc80000001227ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe400078c482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000225b00720cULL, 0x000fc80003fc4070ULL,
0x000000ff23207207ULL, 0x040fe40003000000ULL, 0x000000ff23237207ULL, 0x000fc60007000000ULL,
0x0000000125257824ULL, 0x000fc800078e0220ULL, 0x0000004025207824ULL, 0x040fe200078e00ffULL,
0x0000002225227211ULL, 0x000fe400078ff0ffULL, 0x00010a0015257811ULL, 0x000fe400078e10ffULL,
0x000000c020217812ULL, 0x000fe200078ec0ffULL, 0x0000000160207824ULL, 0x000fe400078e0223ULL,
0x00000004ff237424ULL, 0x000fe400078e00ffULL, 0x0000010022217824ULL, 0x000fca00078e0221ULL,
0x0000002021217810ULL, 0x000fca0007ffe0ffULL, 0x0000000115227824ULL, 0x100fe400078e0221ULL,
0x0000680020207a24ULL, 0x000fc600078e0221ULL, 0x0000005f2200720cULL, 0x000fe20003fc6070ULL,
0x0000000115207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fd000078e0023ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e4000f121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b7800ff207f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x002fe200078e0021ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000018ff19723eULL, 0x000fc800000010ffULL,
0x0000541019227816ULL, 0x000fe20000000019ULL, 0x0000fc127f007947ULL, 0x000fea000b800000ULL,
0x00001f6922197589ULL, 0x0002a400000e0000ULL, 0x0000fc527f007947ULL, 0x000fea000b800000ULL,
0x00001f68221a7589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001069277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001358000207802ULL, 0x000fc40000000f00ULL, 0x0001046000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001869277810ULL, 0x002fe40007ffe0ffULL, 0x000135d000207802ULL, 0x000fc40000000f00ULL,
0x0001041000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff2900720cULL, 0x000fe20003fc5270ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006a28783bULL, 0x000f220000004200ULL, 0x0000172000017945ULL, 0x000fe60003800000ULL,
0x000000006b24783bULL, 0x006e680000004200ULL, 0x000000006e20783bULL, 0x008ea80000004200ULL,
0x000000006d2c783bULL, 0x000ee20000004200ULL, 0x00000018ff407819ULL, 0x010fc40000011629ULL,
0x00000010ff417819ULL, 0x000fe40000011628ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x000000ff29427812ULL, 0x000fe400078ec0ffULL, 0x00000010ff357819ULL, 0x002fe20000011624ULL,
0x20000040ff8f7230ULL, 0x000fe20000004100ULL, 0x0000b0006f407811ULL, 0x000fe400078e20ffULL,
0x000000ff243c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff387819ULL, 0x000fe40000011624ULL,
0x0000ffff24337812ULL, 0x000fe400078ec0ffULL, 0x00000010ff317819ULL, 0x104fe40000011620ULL,
0x000000ff20877812ULL, 0x040fe400078ec0ffULL, 0x00000018ff867819ULL, 0x000fe40000011620ULL,
0x0000ffff20347812ULL, 0x000fc400078ec0ffULL, 0x000000ff28247812ULL, 0x000fe400078ec0ffULL,
0x00000010ff307819ULL, 0x100fe40000011621ULL, 0x000000ff21857812ULL, 0x040fe400078ec0ffULL,
0x00000018ff847819ULL, 0x000fe40000011621ULL, 0x0000ffff213a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7a7819ULL, 0x000fc4000001162aULL, 0x000000ff2a8d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff207819ULL, 0x000fe4000001162aULL, 0x0000ffff2a777812ULL, 0x000fe400078ec0ffULL,
0x00000010ff767819ULL, 0x100fe4000001162bULL, 0x000000ff2b837812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7c7819ULL, 0x000fc4000001162bULL, 0x0000ffff2b737812ULL, 0x000fe400078ec0ffULL,
0x00000010ff397819ULL, 0x100fe40000011622ULL, 0x000000ff22747812ULL, 0x040fe400078ec0ffULL,
0x00000018ff787819ULL, 0x000fe40000011622ULL, 0x0000ffff223e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3b7819ULL, 0x000fc40000011623ULL, 0x000000ff23757812ULL, 0x040fe400078ec0ffULL,
0x00000018ff797819ULL, 0x000fe40000011623ULL, 0x0000ffff23627812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe40000011627ULL, 0x000000ff277e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff217819ULL, 0x000fc40000011627ULL, 0x0000ffff27657812ULL, 0x000fe400078ec0ffULL,
0x00000042ff2a723eULL, 0x000fe400020006ffULL, 0x000000ff412b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff377819ULL, 0x100fe20000011625ULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x000000ff253f7812ULL, 0x000fe200078ec0ffULL, 0x2000002aff2a7230ULL, 0x000fe20000004100ULL,
0x00000018ff3d7819ULL, 0x000fc40000011625ULL, 0x0000ffff25367812ULL, 0x000fe400078ec0ffULL,
0x00000010ff327819ULL, 0x100fe40000011626ULL, 0x000000ff267d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7b7819ULL, 0x000fe40000011626ULL, 0x0000ffff26637812ULL, 0x000fe400078ec0ffULL,
0x00000018ff237819ULL, 0x000fc40000011628ULL, 0x0000ffff28907812ULL, 0x000fe400078ec0ffULL,
0x00000010ff227819ULL, 0x000fe40000011629ULL, 0x0000ffff29277812ULL, 0x000fe400078ec0ffULL,
0x00000024ff26723eULL, 0x000fe400020006ffULL, 0x00000010ff297819ULL, 0x008fe4000001162dULL,
0x000000ff2d257812ULL, 0x000fc400078ec0ffULL, 0x0000ffff2d287812ULL, 0x000fe400078ec0ffULL,
0x00000010ff917819ULL, 0x100fe4000001162cULL, 0x000000ff2c247812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2c8c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001162dULL,
0x00000018ff2c7819ULL, 0x000fe2000001162cULL, 0x000000194040b231ULL, 0x082fe200003400ffULL,
0x00000023ff8e723eULL, 0x000fe200020006ffULL, 0x20000026ff237230ULL, 0x000fe20000004100ULL,
0x0000002dff2d723eULL, 0x000fe200020006ffULL, 0x000000194242b231ULL, 0x000fe200003400ffULL,
0x0000002cff26723eULL, 0x000fe200020006ffULL, 0x0000001a4141b231ULL, 0x080fe200003400ffULL,
0x00000008ff2c7819ULL, 0x000fe20000011627ULL, 0x2000002dff277230ULL, 0x000fe20000004100ULL,
0x000000ff29297812ULL, 0x000fe200078ec0ffULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x0000002cff2d723eULL, 0x000fe200020006ffULL, 0x0000001a4343b231ULL, 0x000fe200003400ffULL,
0x000000ff912c7812ULL, 0x000fe200078ec0ffULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000025ff25723eULL, 0x000fe200020006ffULL, 0x2000002dff917230ULL, 0x000fe20000004100ULL,
0x0000002cff2c723eULL, 0x000fc400020006ffULL, 0x00000008ff287819ULL, 0x000fe20000011628ULL,
0x20000025ff257230ULL, 0x000fe20000004100ULL, 0x0000b0006c2d7811ULL, 0x000fe400078e20ffULL,
0x00000024ff24723eULL, 0x000fe400020006ffULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x00000008ff8c7819ULL, 0x000fe2000001168cULL, 0x20000024ff247230ULL, 0x000fe20000004100ULL,
0x00000028ff93723eULL, 0x000fe200020006ffULL, 0x2000002cff287230ULL, 0x000fe20000004100ULL,
0x00000010ff7f7819ULL, 0x000fe2000001162eULL, 0x20000029ff927230ULL, 0x000fe20000004100ULL,
0x000000ff2e887812ULL, 0x040fe200078ec0ffULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x0000ffff2e807812ULL, 0x000fc400078ec0ffULL, 0x00000018ff897819ULL, 0x000fe4000001162eULL,
0x00000010ff817819ULL, 0x100fe4000001162fULL, 0x000000ff2f8a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2f827812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fe4000001162fULL,
0x000000002d2c783bULL, 0x000e620000000200ULL, 0x0000008cff8c723eULL, 0x000fc400020006ffULL,
0x00000010ff297819ULL, 0x000fe40000011625ULL, 0x00000010ff247819ULL, 0x000fe20000011624ULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fe40000011628ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x0000105425247816ULL, 0x000fe40000000024ULL,
0x0000105492257816ULL, 0x000fc40000000029ULL, 0x00000010ff297819ULL, 0x000fe40000011626ULL,
0x00000010ff287819ULL, 0x000fe4000001168cULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x00000010ff8c7819ULL, 0x000fe40000011627ULL, 0x00000010ff937819ULL, 0x000fe20000011693ULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x0000105429287816ULL, 0x000fe20000000028ULL,
0x000000244024723cULL, 0x000fe200000418ffULL, 0x000010548c297816ULL, 0x000fc40000000093ULL,
0x000000ff22227812ULL, 0x000fe400078ec0ffULL, 0x00000008ff907819ULL, 0x000fe40000011690ULL,
0x00000010ff937819ULL, 0x000fe4000001162aULL, 0x00000010ff927819ULL, 0x000fe4000001162bULL,
0x000000284028723cULL, 0x000f6200000418ffULL, 0x00000022ff22723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe200020006ffULL, 0x000000192c2cb231ULL, 0x082fe200003400ffULL,
0x00000010ff237819ULL, 0x000fe20000011623ULL, 0x20000022ff227230ULL, 0x000fe20000004100ULL,
0x00000021ff8c723eULL, 0x000fe200020006ffULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x000fe2000001168eULL, 0x000000192e2eb231ULL, 0x000fe200003400ffULL,
0x00000010ff947819ULL, 0x000fe20000011622ULL, 0x0000001a2d2db231ULL, 0x080fe200003400ffULL,
0x0000105492227816ULL, 0x000fe20000000023ULL, 0x0000001a2f2fb231ULL, 0x000fe200003400ffULL,
0x00000010ff907819ULL, 0x000fc40000011690ULL, 0x00000010ff927819ULL, 0x000fe4000001168fULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x00000020ff8e723eULL, 0x000fe400020006ffULL,
0x0000105421207816ULL, 0x000fe40000000090ULL, 0x0000105492217816ULL, 0x000fe40000000091ULL,
0x00000085ff85723eULL, 0x000fc400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000008ff347819ULL, 0x000fe20000011634ULL, 0x000000202c28723cULL, 0x020be20000041828ULL,
0x00000083ff92723eULL, 0x000fe200020006ffULL, 0x20000086ff837230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x000000ff30867812ULL, 0x000fe400078ec0ffULL,
0x20000085ff217230ULL, 0x020fe20000004100ULL, 0x000000ff31857812ULL, 0x000fe200078ec0ffULL,
0x2000008aff307230ULL, 0x000fe20000004100ULL, 0x0000105494237816ULL, 0x000fc40000000093ULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x000000ff39397812ULL, 0x000fe200078ec0ffULL, 0x000000222c24723cULL, 0x000be20000041824ULL,
0x00000008ff3e7819ULL, 0x000fe4000001163eULL, 0x000000ff3b3b7812ULL, 0x000fe400078ec0ffULL,
0x00000074ff74723eULL, 0x000fc400020006ffULL, 0x00000086ff8a723eULL, 0x000fe200020006ffULL,
0x20000085ff867230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000034ff857230ULL, 0x000fe20000004100ULL, 0x00000008ff3a7819ULL, 0x000fe2000001163aULL,
0x20000074ff237230ULL, 0x020fe20000004100ULL, 0x00000039ff39723eULL, 0x000fe200020006ffULL,
0x20000078ff227230ULL, 0x000fe20000004100ULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x2000008eff747230ULL, 0x000fe20000004100ULL, 0x0000003eff3e723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x2000008dff787230ULL, 0x000fe20000004100ULL, 0x00000008ff347819ULL, 0x000fc40000011662ULL,
0x0000003bff3b723eULL, 0x000fe400020006ffULL, 0x00000008ff637819ULL, 0x000fe40000011663ULL,
0x0000007cff93723eULL, 0x000fe200020006ffULL, 0x2000008cff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL, 0x20000039ff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff807819ULL, 0x000fe20000011680ULL, 0x2000003eff397230ULL, 0x000fe20000004100ULL,
0x0000003aff3a723eULL, 0x000fe200020006ffULL, 0x2000003bff8d7230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fc400020006ffULL, 0x00000089ff91723eULL, 0x000fe200020006ffULL,
0x20000075ff897230ULL, 0x000fe20000004100ULL, 0x00000034ff34723eULL, 0x000fe200020006ffULL,
0x2000003aff627230ULL, 0x000fe20000004100ULL, 0x00000063ff8e723eULL, 0x000fe200020006ffULL,
0x20000091ff317230ULL, 0x000fe20000004100ULL, 0x00000008ff827819ULL, 0x000fe20000011682ULL,
0x20000034ff347230ULL, 0x000fe20000004100ULL, 0x00000088ff90723eULL, 0x000fe200020006ffULL,
0x20000079ff887230ULL, 0x000fe20000004100ULL, 0x0000007fff3e723eULL, 0x000fe200020006ffULL,
0x2000008eff7f7230ULL, 0x000fe20000004100ULL, 0x00000080ff63723eULL, 0x000fe200020006ffULL,
0x20000092ff797230ULL, 0x000fe20000004100ULL, 0x000000ff81817812ULL, 0x000fe200078ec0ffULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x0000003cff80723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x20000093ff757230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe20000011621ULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000082ff3a723eULL, 0x000fe200020006ffULL,
0x20000087ff207230ULL, 0x000fe20000004100ULL, 0x00000010ff217819ULL, 0x000fc40000011686ULL,
0x0000008bff8f723eULL, 0x000fe200020006ffULL, 0x20000090ff8b7230ULL, 0x000fe20000004100ULL,
0x00000038ff82723eULL, 0x000fe200020006ffULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x0000003dff86723eULL, 0x000fe200020006ffULL, 0x2000008fff877230ULL, 0x000fe20000004100ULL,
0x00000081ff3b723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x000000ff35357812ULL, 0x000fe200078ec0ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000010ff3d7819ULL, 0x000fe20000011689ULL, 0x2000003bff3b7230ULL, 0x000fe20000004100ULL,
0x00000010ff387819ULL, 0x000fc4000001168dULL, 0x0000003fff81723eULL, 0x000fe400020006ffULL,
0x00000010ff3f7819ULL, 0x000fe4000001168aULL, 0x000000ff378a7812ULL, 0x000fe200078ec0ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000035ff89723eULL, 0x000fe400020006ffULL,
0x00001054383d7816ULL, 0x000fe4000000003dULL, 0x00000010ff377819ULL, 0x000fe20000011688ULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fc40000011634ULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000010ff357819ULL, 0x000fe40000011622ULL,
0x00000010ff387819ULL, 0x000fe20000011639ULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff887819ULL, 0x000fe4000001163eULL,
0x00000010ff207819ULL, 0x000fc40000011620ULL, 0x0000105437397816ULL, 0x000fe40000000034ULL,
0x0000105435387816ULL, 0x000fe40000000038ULL, 0x0000105488347816ULL, 0x000fe4000000008bULL,
0x00000010ff357819ULL, 0x000fe40000011630ULL, 0x00000010ff887819ULL, 0x000fe4000001163bULL,
0x0000105421207816ULL, 0x000fc40000000020ULL, 0x000010543f217816ULL, 0x000fe4000000003cULL,
0x00000010ff3c7819ULL, 0x000fe4000001168cULL, 0x00000010ff317819ULL, 0x000fe40000011631ULL,
0x00000010ff307819ULL, 0x000fe40000011663ULL, 0x00000010ff237819ULL, 0x000fe40000011623ULL,
0x00000010ff8c7819ULL, 0x000fc40000011687ULL, 0x00000010ff377819ULL, 0x000fe4000001163aULL,
0x0000105488357816ULL, 0x000fe20000000035ULL, 0x000000384038723cULL, 0x000fe200000418ffULL,
0x00000010ff887819ULL, 0x000fe40000011683ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff637819ULL, 0x000fc40000011662ULL,
0x0000105431307816ULL, 0x000fe40000000030ULL, 0x000010543c3c7816ULL, 0x000fe40000000023ULL,
0x000010548c317816ULL, 0x000fe20000000037ULL, 0x000000204020723cULL, 0x000f6200000418ffULL,
0x0000105488627816ULL, 0x000fe40000000085ULL, 0x0000105484637816ULL, 0x000fe40000000063ULL,
0x00000008ff337819ULL, 0x000fc40000011633ULL, 0x00000008ff877819ULL, 0x000fe20000011636ULL,
0x0000003c403c723cULL, 0x040fe200000418ffULL, 0x00000033ff83723eULL, 0x000fe400020006ffULL,
0x000000ff32847812ULL, 0x000fe400078ec0ffULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x000000ff64647812ULL, 0x000fe200078ec0ffULL,
0x000000344034723cULL, 0x000fe200000418ffULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x000000ff7a857812ULL, 0x000fc400078ec0ffULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fe20000011665ULL, 0x000000304030723cULL, 0x040fe200000418ffULL,
0x00000085ff88723eULL, 0x000fe200020006ffULL, 0x20000064ff857230ULL, 0x000fe20000004100ULL,
0x00000065ff7a723eULL, 0x000fe400020006ffULL, 0x00000010ff647819ULL, 0x000fe40000011680ULL,
0x00000010ff657819ULL, 0x000fe20000011681ULL, 0x000000624040723cULL, 0x000b6200000418ffULL,
0x00000010ff897819ULL, 0x000fe20000011689ULL, 0x2000007aff807230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fe2000001168aULL, 0x20000088ff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff867819ULL, 0x000fc40000011686ULL, 0x00000010ff637819ULL, 0x020fe40000011682ULL,
0x00000010ff627819ULL, 0x000fe40000011683ULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x0000105489647816ULL, 0x000fe20000000064ULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x000010548a657816ULL, 0x000fe20000000065ULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x0000105463627816ULL, 0x000fc40000000062ULL, 0x0000105486637816ULL, 0x000fe40000000087ULL,
0x00000008ff777819ULL, 0x000fe20000011677ULL, 0x000000642c20723cULL, 0x040b620000041820ULL,
0x000000ff76767812ULL, 0x000fe400078ec0ffULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff647819ULL, 0x020fe2000001167dULL,
0x000000622c40723cULL, 0x000b620000041840ULL, 0x00000010ff657819ULL, 0x000fc40000011684ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff627819ULL, 0x020fe4000001167fULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff637819ULL, 0x000fe40000011680ULL, 0x00000077ff77723eULL, 0x000fc400020006ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x0000105465647816ULL, 0x000fe20000000064ULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x0000105485657816ULL, 0x000fe4000000007eULL,
0x000010547b627816ULL, 0x000fe20000000062ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x000010547c637816ULL, 0x000fc40000000063ULL, 0x00000010ff797819ULL, 0x000fe20000011679ULL,
0x000000642c3c723cULL, 0x000b62000004183cULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff737819ULL, 0x000fc80000011673ULL, 0x00000010ff647819ULL, 0x020fe20000011678ULL,
0x000000622c38723cULL, 0x000b620000041838ULL, 0x00000010ff657819ULL, 0x000fc8000001167aULL,
0x0000105465647816ULL, 0x000fe40000000064ULL, 0x00000010ff637819ULL, 0x020fe40000011674ULL,
0x00000010ff627819ULL, 0x000fe40000011677ULL, 0x00000010ff747819ULL, 0x000fe40000011675ULL,
0x0000105463627816ULL, 0x000fe40000000062ULL, 0x0000105476657816ULL, 0x000fc40000000079ULL,
0x0000105474637816ULL, 0x000fca0000000073ULL, 0x000000642c34723cULL, 0x040b700000041834ULL,
0x000000622c30723cULL, 0x000b620000041830ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000200d0d7221ULL, 0x000fe20000010000ULL,
0x000000210c0c7221ULL, 0x000fe20000010000ULL, 0x0000004009097221ULL, 0x000fe20000010000ULL,
0x0000004108087221ULL, 0x000fe20000010000ULL, 0x0000003c05057221ULL, 0x000fe20000010000ULL,
0x0000003d44447221ULL, 0x000fe20000010000ULL, 0x0000003847477221ULL, 0x000fe20000010000ULL,
0x0000003948487221ULL, 0x000fe20000010000ULL, 0x000000244b4b7221ULL, 0x000fe20000010000ULL,
0x000000254c4c7221ULL, 0x000fe20000010000ULL, 0x000000284f4f7221ULL, 0x000fe20000010000ULL,
0x0000002950507221ULL, 0x000fe20000010000ULL, 0x0000003453537221ULL, 0x020fe20000010000ULL,
0x0000003554547221ULL, 0x000fe20000010000ULL, 0x0000003057577221ULL, 0x000fe20000010000ULL,
0x0000003158587221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000220b0b7221ULL, 0x000fe20000010000ULL, 0x000000230a0a7221ULL, 0x000fe20000010000ULL,
0x0000004207077221ULL, 0x000fe20000010000ULL, 0x0000004306067221ULL, 0x000fe20000010000ULL,
0x0000003e45457221ULL, 0x000fe20000010000ULL, 0x0000003f46467221ULL, 0x000fe20000010000ULL,
0x0000003a49497221ULL, 0x000fe20000010000ULL, 0x0000003b4a4a7221ULL, 0x000fe20000010000ULL,
0x000000264d4d7221ULL, 0x000fe20000010000ULL, 0x000000274e4e7221ULL, 0x000fe20000010000ULL,
0x0000002a51517221ULL, 0x000fe20000010000ULL, 0x0000002b52527221ULL, 0x000fe20000010000ULL,
0x0000003655557221ULL, 0x020fe20000010000ULL, 0x0000003756567221ULL, 0x000fe20000010000ULL,
0x0000003259597221ULL, 0x000fe20000010000ULL, 0x000000335a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000707200720cULL, 0x000fe20003f06070ULL,
0x010b8800ff227f8cULL, 0x000e58000c80043fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff9b2000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c012207811ULL, 0x000fe200078e40ffULL, 0x010b6800ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000005f2000720cULL, 0x000fda0003f06070ULL, 0x0000655000000947ULL, 0x000fea0003800000ULL,
0x000000ffff727224ULL, 0x000fca00078e00ffULL, 0x00000002ff217819ULL, 0x000fe20000011672ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000372227812ULL, 0x042fe200078ec0ffULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000002172217207ULL, 0x000fe40002800000ULL,
0x000000ff22227207ULL, 0x000fe40006800000ULL, 0x0000000321257810ULL, 0x000fc80007ffe0ffULL,
0x0000000325217812ULL, 0x040fe400078ec0ffULL, 0x0000001225207211ULL, 0x020fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x010b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000120247810ULL, 0x000fe20007ffe0ffULL,
0x0000099000017945ULL, 0x000fe60003800000ULL, 0x0000005d2400720cULL, 0x000fda0003f06070ULL,
0x0000052000008947ULL, 0x000fea0003800000ULL, 0x000000015c297824ULL, 0x000fe200078e021bULL,
0x00000020032a7811ULL, 0x000fe200078e30ffULL, 0x0000000420247824ULL, 0x000fe200078e0221ULL,
0x000000021b317810ULL, 0x020fe20007ffe0ffULL, 0x0000001004267824ULL, 0x000fe200078e00ffULL,
0x010a000029257984ULL, 0x000e620000004800ULL, 0x00000100ff2b7424ULL, 0x000fe200078e00ffULL,
0x0000002024247811ULL, 0x000fe200078e30ffULL, 0x000000015c337824ULL, 0x000fe200078e0231ULL,
0x000000f0262d7812ULL, 0x000fe200078ec0ffULL, 0x0000001029267824ULL, 0x000fe200078e00ffULL,
0x000000245f237217ULL, 0x000fe20007800000ULL, 0x00000001332c7824ULL, 0x000fc800078e0204ULL,
0x0000000123237824ULL, 0x000fe400078e0a24ULL, 0x0000000129247824ULL, 0x000fc600078e022aULL,
0x000000235c237217ULL, 0x000fca0007800000ULL, 0x0000000123287824ULL, 0x000fe400078e0a5cULL,
0x0000000129237824ULL, 0x000fc600078e0204ULL, 0x000000281b00720cULL, 0x000fe40003f06070ULL,
0xfffffff026237812ULL, 0x000fe200078ee223ULL, 0x0000000133267824ULL, 0x040fe400078e022aULL,
0x0000001033337824ULL, 0x000fe200078e00ffULL, 0x0000e000232f7811ULL, 0x000fc800078e20ffULL,
0xfffffff0332c7812ULL, 0x000fe200078ee22cULL, 0x010ac00025257984ULL, 0x002e640000004800ULL,
0x0000002514247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002bULL,
0x0000002d24247210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e2000c101c46ULL,
0x000000283100720cULL, 0x000fe40003f06070ULL, 0x000000041b317810ULL, 0x000fe20007ffe0ffULL,
0x010a080029237984ULL, 0x000ea80000004800ULL, 0x000000015c337824ULL, 0x000fe200078e0231ULL,
0x0000e0002c2f7811ULL, 0x002fc600078e20ffULL, 0x00000001332c7824ULL, 0x000fe200078e0204ULL,
0x010ac00023237984ULL, 0x004e640000004800ULL, 0x0000002314267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002bULL, 0x0000002d26247210ULL, 0x000fe20007f3e0ffULL,
0x0000000133267824ULL, 0x040fe400078e022aULL, 0x0000001033337824ULL, 0x000fe400078e00ffULL,
0x000000ffff257224ULL, 0x000fc600008e0627ULL, 0xfffffff0332c7812ULL, 0x000fe400078ee22cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e2000c101c46ULL,
0x000000283100720cULL, 0x000fe40003f06070ULL, 0x000000061b317810ULL, 0x000fe20007ffe0ffULL,
0x010a100029237984ULL, 0x000ea80000004800ULL, 0x000000015c337824ULL, 0x000fe200078e0231ULL,
0x0000e0002c2f7811ULL, 0x002fe200078e20ffULL, 0x010ac00023237984ULL, 0x004e640000004800ULL,
0x0000002314267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002bULL,
0x0000002d26247210ULL, 0x000fe20007f3e0ffULL, 0x0000000133267824ULL, 0x040fe400078e022aULL,
0x00000001332a7824ULL, 0x040fe400078e0204ULL, 0x000000ffff257224ULL, 0x000fe400008e0627ULL,
0x0000001033337824ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e2000c101c46ULL, 0x000000283100720cULL, 0x000fe40003f06070ULL,
0xfffffff0332a7812ULL, 0x000fe200078ee22aULL, 0x010a180029237984ULL, 0x000ea80000004800ULL,
0x010ac00023237984ULL, 0x004ea40000004800ULL, 0x0000002314267224ULL, 0x004fe200078e0226ULL,
0x0000e0002a237811ULL, 0x000fc600078e20ffULL, 0x00005e0026267625ULL, 0x000fca00078e002bULL,
0x0000002d26247210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e2000c101c46ULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x000000015c297824ULL, 0x000fe200078e021bULL,
0x0000002003287811ULL, 0x000fe200078e30ffULL, 0x0000001004257824ULL, 0x000fe400078e00ffULL,
0x00000100ff2b7424ULL, 0x000fe200078e00ffULL, 0x010a000029237984ULL, 0x000e620000004800ULL,
0x0000000129247824ULL, 0x000fe200078e0228ULL, 0x000000f0252d7812ULL, 0x020fe200078ec0ffULL,
0x0000000129267824ULL, 0x040fe200078e0204ULL, 0x0000000229317810ULL, 0x040fe20007ffe0ffULL,
0x0000001029277824ULL, 0x000fc800078e00ffULL, 0x00000001312a7824ULL, 0x000fe200078e0204ULL,
0xfffffff027267812ULL, 0x000fc800078ee226ULL, 0x0000e000262f7811ULL, 0x000fe200078e20ffULL,
0x0000000128267824ULL, 0x000fe400078e0231ULL, 0x0000001031317824ULL, 0x000fca00078e00ffULL,
0xfffffff0312a7812ULL, 0x000fe400078ee22aULL, 0x0000000429317810ULL, 0x000fe20007ffe0ffULL,
0x010ac00023237984ULL, 0x002e640000004800ULL, 0x0000002314247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e8000b901c46ULL, 0x010a080029237984ULL, 0x000ea20000004800ULL,
0x0000e0002a2f7811ULL, 0x002fe200078e20ffULL, 0x0000000128247824ULL, 0x000fe400078e0231ULL,
0x00000001312a7824ULL, 0x040fe400078e0204ULL, 0x0000001031317824ULL, 0x000fca00078e00ffULL,
0xfffffff0312a7812ULL, 0x000fe400078ee22aULL, 0x0000000629317810ULL, 0x000fe20007ffe0ffULL,
0x010ac00023237984ULL, 0x004e640000004800ULL, 0x0000002314267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002bULL, 0x0000002d26267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e8000b901c46ULL, 0x010a100029237984ULL, 0x000ea20000004800ULL,
0x0000e0002a2f7811ULL, 0x002fe200078e20ffULL, 0x0000000128267824ULL, 0x000fe400078e0231ULL,
0x0000000131287824ULL, 0x040fe400078e0204ULL, 0x0000001031317824ULL, 0x000fca00078e00ffULL,
0xfffffff031287812ULL, 0x000fe200078ee228ULL, 0x010ac00023237984ULL, 0x004e640000004800ULL,
0x0000002314247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002bULL,
0x0000002d24247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000b901c46ULL,
0x010a180029237984ULL, 0x000ea20000004800ULL, 0x0000e00028257811ULL, 0x002fc600078e20ffULL,
0x010ac00023237984ULL, 0x004e640000004800ULL, 0x0000002314267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002bULL, 0x0000002d26267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff287224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804828ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000205b00720cULL, 0x000fe20003f04070ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x000000032200780cULL, 0x000fda0003f25270ULL, 0x000000f000008947ULL, 0x000fea0000800000ULL,
0x000000031500780cULL, 0x000fe40003f04070ULL, 0x0000000113137810ULL, 0x000fd60007ffe0ffULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000000400237824ULL, 0x000fe200078e0215ULL,
0x0000640013247a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff257424ULL, 0x000fe200078e00ffULL,
0x0000005e1300720cULL, 0x000fe20003f06070ULL, 0x0000000223237824ULL, 0x000fc800078e00ffULL,
0x0000640023247a24ULL, 0x000fe200078e0224ULL, 0x00010ac015237811ULL, 0x000fc600078e10ffULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024237faeULL, 0x0003e4000c121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000205b00720cULL, 0x000fe40003f04070ULL, 0x0000000122227810ULL, 0x000fc80007ffe0ffULL,
0x0000000322237812ULL, 0x002fc800078ec0ffULL, 0x000000ff23237207ULL, 0x000fc60004000000ULL,
0x00000002ff228819ULL, 0x000fca0000011622ULL, 0x0000000121217824ULL, 0x000fc800078e0222ULL,
0x0000004021227824ULL, 0x040fe200078e00ffULL, 0x0000002021207211ULL, 0x000fc800078ff0ffULL,
0x000000c022217812ULL, 0x000fca00078ec0ffULL, 0x0000010020217824ULL, 0x000fe400078e0221ULL,
0x0000000160207824ULL, 0x000fe200078e0223ULL, 0x00010a0015237811ULL, 0x040fe200078e10ffULL,
0x0000000115227824ULL, 0x140fe400078e0221ULL, 0x0000680020207a24ULL, 0x000fe400078e0221ULL,
0x00000004ff217424ULL, 0x000fe200078e00ffULL, 0x0000005f2200720cULL, 0x000fe20003f06070ULL,
0x0000000115207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fd000078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8000ff207f8cULL, 0x000e62000c80043fULL,
0x000000ff7200720cULL, 0x000fe20003f05270ULL, 0x000007e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff717224ULL, 0x002fd600078e0021ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b38005c207f8cULL, 0x000e64000c80043fULL,
0x000000ffff247224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010b3c005c177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007804824ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002220227210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e21ULL, 0x003d09002200780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402200780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff177819ULL, 0x000fc80000011423ULL,
0x0000002217177211ULL, 0x000fca00078110ffULL, 0x000000ffff227224ULL, 0x000fca00000e0623ULL,
0x0000000217177819ULL, 0x000fc80000001222ULL, 0x000000170000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x010b3c005c177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804824ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001004177824ULL, 0x000fe200078e00ffULL, 0x00000001ff207819ULL, 0x000fc80000011604ULL,
0x0000007017177812ULL, 0x000fe400078ec0ffULL, 0x0000000c20207812ULL, 0x000fca00078ec0ffULL,
0x0000000117277824ULL, 0x000fca00078e0220ULL, 0x0101800027227984ULL, 0x000e680000000800ULL,
0x0103800027237984ULL, 0x0004e20000000800ULL, 0x000000112200720bULL, 0x002fe20003f1d000ULL,
0x0000ca227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000177806ULL, 0x004fc800000e0100ULL,
0x0000ffff17287812ULL, 0x000fe2000780c0ffULL, 0x0000043000027945ULL, 0x000fe20003800000ULL,
0x00000001ff177424ULL, 0x000fe400078e00ffULL, 0x000000ffff247224ULL, 0x000fd200078e0011ULL,
0x000003f000008947ULL, 0x000fea0003800000ULL, 0x000000036100780cULL, 0x000fe40003f05270ULL,
0x000000112200720bULL, 0x000fe20003f34000ULL, 0x0000c9e27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000257806ULL, 0x000fc400008e0100ULL, 0x0000002211247209ULL, 0x000fe20007810000ULL,
0x0000033000037945ULL, 0x000fe20003800000ULL, 0x0000991025207816ULL, 0x000fc600000000ffULL,
0x0105802427008388ULL, 0x0003e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x8000002411117221ULL, 0x002fe20000010000ULL,
0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL, 0x0000001100297308ULL, 0x000e640000000800ULL,
0x000000290e0e7220ULL, 0x002fc80000410000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000c9327f007947ULL, 0x000fea000b800000ULL, 0x00001f6929117589ULL, 0x0002a400000e0000ULL,
0x000000110d0d7220ULL, 0x084fe20000410000ULL, 0x000000110c0c7220ULL, 0x080fe20000410000ULL,
0x0000001109097220ULL, 0x080fe20000410000ULL, 0x0000001108087220ULL, 0x080fe20000410000ULL,
0x0000001105057220ULL, 0x080fe20000410000ULL, 0x0000001144447220ULL, 0x080fe20000410000ULL,
0x0000001147477220ULL, 0x080fe20000410000ULL, 0x0000001148487220ULL, 0x080fe20000410000ULL,
0x000000114b4b7220ULL, 0x080fe20000410000ULL, 0x000000114c4c7220ULL, 0x080fe20000410000ULL,
0x000000114f4f7220ULL, 0x080fe20000410000ULL, 0x0000001150507220ULL, 0x080fe20000410000ULL,
0x0000001153537220ULL, 0x080fe20000410000ULL, 0x0000001154547220ULL, 0x080fe20000410000ULL,
0x0000001157577220ULL, 0x080fe20000410000ULL, 0x0000001158587220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000c8427f007947ULL, 0x000fea000b800000ULL,
0x00001f6829117589ULL, 0x00046400000e0000ULL, 0x000000110b0b7220ULL, 0x082fe20000410000ULL,
0x000000110a0a7220ULL, 0x080fe20000410000ULL, 0x0000001107077220ULL, 0x080fe20000410000ULL,
0x0000001106067220ULL, 0x080fe20000410000ULL, 0x0000001145457220ULL, 0x080fe20000410000ULL,
0x0000001146467220ULL, 0x080fe20000410000ULL, 0x0000001149497220ULL, 0x080fe20000410000ULL,
0x000000114a4a7220ULL, 0x080fe20000410000ULL, 0x000000114d4d7220ULL, 0x080fe20000410000ULL,
0x000000114e4e7220ULL, 0x080fe20000410000ULL, 0x0000001151517220ULL, 0x080fe20000410000ULL,
0x0000001152527220ULL, 0x080fe20000410000ULL, 0x0000001155557220ULL, 0x080fe20000410000ULL,
0x0000001156567220ULL, 0x080fe20000410000ULL, 0x0000001159597220ULL, 0x080fe20000410000ULL,
0x000000115a5a7220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff28ff7812ULL, 0x000fda0007806025ULL, 0x8000002422220221ULL, 0x000fe20000010000ULL,
0x00007610ff170816ULL, 0x000fc60000000017ULL, 0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL,
0x0000002200180308ULL, 0x000e640000000800ULL, 0x0000001823230220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000e230e7221ULL, 0x008fe20000010000ULL,
0x000000ffff117224ULL, 0x000fc400078e0024ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff17ff7812ULL, 0x000fe2000786c0ffULL, 0x0000012000017945ULL, 0x000fd80003800000ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000018ff19723eULL, 0x000fc800000010ffULL,
0x0000541019227816ULL, 0x000fe20000000019ULL, 0x0000c6827f007947ULL, 0x000fea000b800000ULL,
0x00001f6922197589ULL, 0x0002e400000e0000ULL, 0x0000c6c27f007947ULL, 0x000fea000b800000ULL,
0x00001f68221a7589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001069277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x00016d2000207802ULL, 0x000fc40000000f00ULL, 0x0000ccc000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001869277810ULL, 0x002fe40007ffe0ffULL, 0x00016d7000207802ULL, 0x000fc40000000f00ULL,
0x0000cc7000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001c20783bULL, 0x002e620000004200ULL,
0x000000726900720cULL, 0x000fe20003f46070ULL, 0x0000178000017945ULL, 0x000fe20003800000ULL,
0x000000125b00720cULL, 0x000fe20003fc3070ULL, 0x00000000662c783bULL, 0x000f220000004200ULL,
0x000000726800720cULL, 0x000fc40003f26070ULL, 0x000000125b00720cULL, 0x000fe20003f03070ULL,
0x000000006724783bULL, 0x004ea80000004200ULL, 0x000000001d28783bULL, 0x000ee20000004200ULL,
0x00000010ff367819ULL, 0x102fe40000011620ULL, 0x000000ff20907812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3f7819ULL, 0x000fc40000011620ULL, 0x0000ffff20397812ULL, 0x000fe400078ec0ffULL,
0x00000010ff377819ULL, 0x100fe40000011621ULL, 0x000000ff218f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe40000011621ULL, 0x0000ffff21417812ULL, 0x000fe400078ec0ffULL,
0x00000010ff357819ULL, 0x000fc40000011622ULL, 0x000000ff228c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7d7819ULL, 0x000fe40000011622ULL, 0x0000ffff22347812ULL, 0x000fe400078ec0ffULL,
0x00000010ff407819ULL, 0x100fe40000011623ULL, 0x000000ff238d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff917819ULL, 0x000fc40000011623ULL, 0x0000ffff23387812ULL, 0x000fe400078ec0ffULL,
0x000000ff2c237812ULL, 0x010fe400078ec0ffULL, 0x0000b8001e207811ULL, 0x000fe400078e20ffULL,
0x000000ff24217812ULL, 0x004fe400078ec0ffULL, 0x000000ff25227812ULL, 0x000fe400078ec0ffULL,
0x00000010ff337819ULL, 0x008fc40000011629ULL, 0x000000ff29837812ULL, 0x040fe400078ec0ffULL,
0x00000018ff857819ULL, 0x000fe40000011629ULL, 0x0000ffff29317812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3b7819ULL, 0x100fe4000001162bULL, 0x000000ff2b807812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fc4000001162bULL, 0x0000ffff2b647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff937819ULL, 0x100fe4000001162cULL, 0x00000018ff7b7819ULL, 0x000fe4000001162cULL,
0x0000ffff2c657812ULL, 0x000fe400078ec0ffULL, 0x00000023ff2c723eULL, 0x000fe400020006ffULL,
0x00000021ff29723eULL, 0x000fc400020006ffULL, 0x00000022ff2b723eULL, 0x000fe400020006ffULL,
0x000000002020783bULL, 0x000e620000000200ULL, 0x00000010ff327819ULL, 0x100fe20000011628ULL,
0x20000029ff297230ULL, 0x000fe20000004100ULL, 0x000000ff28827812ULL, 0x040fe200078ec0ffULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x00000018ff847819ULL, 0x000fe40000011628ULL,
0x0000ffff28307812ULL, 0x000fe400078ec0ffULL, 0x000000ff2d287812ULL, 0x000fc400078ec0ffULL,
0x00000010ff947819ULL, 0x100fe4000001162dULL, 0x00000018ff7c7819ULL, 0x000fe4000001162dULL,
0x0000ffff2d7f7812ULL, 0x000fe400078ec0ffULL, 0x00000028ff2d723eULL, 0x000fe400020006ffULL,
0x00000010ff287819ULL, 0x000fe40000011624ULL, 0x0000ffff24437812ULL, 0x000fc400078ec0ffULL,
0x00000018ff427819ULL, 0x000fe20000011624ULL, 0x2000002cff247230ULL, 0x000fe20000004100ULL,
0x00000010ff3a7819ULL, 0x100fe4000001162aULL, 0x000000ff2a817812ULL, 0x040fe400078ec0ffULL,
0x00000018ff927819ULL, 0x000fe4000001162aULL, 0x0000ffff2a3e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2a7819ULL, 0x000fc40000011625ULL, 0x0000b8001f2c7811ULL, 0x000fe400078e20ffULL,
0x0000ffff25867812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3c7819ULL, 0x000fe20000011625ULL,
0x2000002dff257230ULL, 0x000fe20000004100ULL, 0x000000ff28287812ULL, 0x000fe200078ec0ffULL,
0x000000192020b231ULL, 0x082fe200003400ffULL, 0x000000ff2a2a7812ULL, 0x000fe200078ec0ffULL,
0x000000192222b231ULL, 0x000fe200003400ffULL, 0x00000010ff797819ULL, 0x100fe2000001162eULL,
0x0000001a2121b231ULL, 0x080fe200003400ffULL, 0x000000ff2e777812ULL, 0x000fe200078ec0ffULL,
0x0000001a2323b231ULL, 0x000fe200003400ffULL, 0x00000018ff747819ULL, 0x000fc4000001162eULL,
0x0000ffff2e737812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7a7819ULL, 0x100fe4000001162fULL,
0x000000ff2f787812ULL, 0x040fe400078ec0ffULL, 0x00000018ff767819ULL, 0x000fe4000001162fULL,
0x0000ffff2f757812ULL, 0x000fe400078ec0ffULL, 0x000000002c2c783bULL, 0x000e620000000200ULL,
0x00000028ff28723eULL, 0x000fc400020006ffULL, 0x0000002aff2a723eULL, 0x000fe400020006ffULL,
0x00000010ff877819ULL, 0x100fe40000011626ULL, 0x000000ff263d7812ULL, 0x040fe200078ec0ffULL,
0x2000002aff2a7230ULL, 0x000fe20000004100ULL, 0x0000ffff26897812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8e7819ULL, 0x000fe20000011626ULL, 0x20000028ff267230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fc40000011627ULL, 0x000000ff27887812ULL, 0x040fe400078ec0ffULL,
0x0000ffff278a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff637819ULL, 0x000fe40000011627ULL,
0x00000010ff287819ULL, 0x000fe40000011629ULL, 0x00000010ff297819ULL, 0x000fe4000001162bULL,
0x00000010ff277819ULL, 0x000fc40000011626ULL, 0x00000010ff2a7819ULL, 0x000fe4000001162aULL,
0x0000105427287816ULL, 0x000fe40000000028ULL, 0x000010542a297816ULL, 0x000fe40000000029ULL,
0x000000ff93937812ULL, 0x000fe400078ec0ffULL, 0x000000ff94947812ULL, 0x000fe400078ec0ffULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x000000282028723cULL, 0x000f6200000418ffULL,
0x00000094ff94723eULL, 0x000fe200020006ffULL, 0x000000192c2cb231ULL, 0x082fe200003400ffULL,
0x00000010ff247819ULL, 0x000fe20000011624ULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe20000011625ULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x000000192e2eb231ULL, 0x000fe200003400ffULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x0000001a2d2db231ULL, 0x080fe200003400ffULL, 0x00000010ff937819ULL, 0x000fe20000011693ULL,
0x0000001a2f2fb231ULL, 0x000fe200003400ffULL, 0x00000010ff947819ULL, 0x000fc40000011694ULL,
0x0000105493247816ULL, 0x000fe40000000024ULL, 0x0000105494257816ULL, 0x000fe40000000025ULL,
0x000000ff35357812ULL, 0x000fe400078ec0ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x000000ff40407812ULL, 0x000fe400078ec0ffULL, 0x000000242c28723cULL, 0x020be20000041828ULL,
0x00000035ff35723eULL, 0x000fc400020006ffULL, 0x00000008ff347819ULL, 0x000fe40000011634ULL,
0x00000008ff387819ULL, 0x000fe40000011638ULL, 0x2000008fff257230ULL, 0x020fe20000004100ULL,
0x000000ff368f7812ULL, 0x000fe200078ec0ffULL, 0x20000090ff247230ULL, 0x000fe20000004100ULL,
0x0000007dff26723eULL, 0x000fe400020006ffULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x00000092ff7d723eULL, 0x000fe200020006ffULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x0000008eff8e723eULL, 0x000fc400020006ffULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x00000040ff92723eULL, 0x000fe200020006ffULL,
0x20000035ff407230ULL, 0x000fe20000004100ULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x2000008eff367230ULL, 0x000fe20000004100ULL, 0x00000034ff34723eULL, 0x000fe200020006ffULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x0000008dff8d723eULL, 0x000fc400020006ffULL, 0x000000ff37907812ULL, 0x000fe200078ec0ffULL,
0x20000088ff377230ULL, 0x000fe20000004100ULL, 0x00000043ff35723eULL, 0x000fe200020006ffULL,
0x20000034ff437230ULL, 0x000fe20000004100ULL, 0x00000008ff867819ULL, 0x000fe20000011686ULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000035ff347230ULL, 0x000fe20000004100ULL, 0x000000ff87877812ULL, 0x000fe400078ec0ffULL,
0x00000091ff27723eULL, 0x000fe200020006ffULL, 0x20000038ff917230ULL, 0x000fe20000004100ULL,
0x00000008ff8e7819ULL, 0x000fe20000011641ULL, 0x2000008fff417230ULL, 0x000fe20000004100ULL,
0x00000090ff90723eULL, 0x000fe200020006ffULL, 0x20000027ff277230ULL, 0x000fe20000004100ULL,
0x00000008ff887819ULL, 0x000fe20000011639ULL, 0x20000063ff397230ULL, 0x000fe20000004100ULL,
0x0000003cff3c723eULL, 0x000fe200020006ffULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000086ff38723eULL, 0x000fc400020006ffULL, 0x0000003dff3d723eULL, 0x000fe200020006ffULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x000000ff8b8b7812ULL, 0x000fe200078ec0ffULL,
0x20000038ff387230ULL, 0x000fe20000004100ULL, 0x00000087ff35723eULL, 0x000fe200020006ffULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000008ff897819ULL, 0x000fe20000011689ULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000088ff63723eULL, 0x000fe200020006ffULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff8a7819ULL, 0x000fc4000001168aULL, 0x0000008eff88723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fe40000011624ULL,
0x00000010ff417819ULL, 0x000fe20000011641ULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x0000008bff8e723eULL, 0x000fe400020006ffULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00000010ff927819ULL, 0x000fe20000011692ULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fc400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x20000089ff8b7230ULL, 0x000fe20000004100ULL,
0x0000003fff3f723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x0000105441247816ULL, 0x000fe20000000024ULL, 0x2000008aff8f7230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe20000011625ULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000010ff907819ULL, 0x000fc40000011690ULL, 0x0000105492417816ULL, 0x000fe4000000008dULL,
0x00000010ff8d7819ULL, 0x000fe4000001163cULL, 0x00000010ff387819ULL, 0x000fe40000011638ULL,
0x000000ff33877812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3d7819ULL, 0x000fe4000001163dULL,
0x00000010ff3c7819ULL, 0x000fc40000011635ULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff337819ULL, 0x000fe40000011640ULL, 0x0000105490257816ULL, 0x000fe40000000025ULL,
0x000010548d357816ULL, 0x000fe40000000038ULL, 0x00000010ff907819ULL, 0x000fe40000011639ULL,
0x00000008ff897819ULL, 0x000fc40000011630ULL, 0x00000008ff8a7819ULL, 0x000fe40000011631ULL,
0x000010543c387816ULL, 0x000fe4000000003dULL, 0x00000010ff397819ULL, 0x000fe4000001168eULL,
0x000000ff32867812ULL, 0x000fe400078ec0ffULL, 0x0000105433407816ULL, 0x000fe4000000008cULL,
0x00000010ff317819ULL, 0x000fc40000011626ULL, 0x00000010ff307819ULL, 0x000fe40000011643ULL,
0x00000010ff3d7819ULL, 0x000fe40000011636ULL, 0x00000010ff3c7819ULL, 0x000fe4000001168bULL,
0x00000010ff8e7819ULL, 0x000fe40000011662ULL, 0x00000010ff327819ULL, 0x000fe40000011627ULL,
0x00000010ff917819ULL, 0x000fe20000011691ULL, 0x000000242024723cULL, 0x000f6200000418ffULL,
0x00000010ff337819ULL, 0x000fc40000011642ULL, 0x00000010ff347819ULL, 0x000fe40000011634ULL,
0x00000010ff8c7819ULL, 0x000fe40000011637ULL, 0x00000010ff8f7819ULL, 0x000fe2000001168fULL,
0x000000402040723cULL, 0x000fe200000418ffULL, 0x00000010ff627819ULL, 0x000fe40000011663ULL,
0x00000010ff3f7819ULL, 0x000fe4000001163fULL, 0x00000010ff637819ULL, 0x000fc40000011688ULL,
0x0000105431307816ULL, 0x000fe40000000030ULL, 0x000010543d3c7816ULL, 0x000fe4000000003cULL,
0x0000105432317816ULL, 0x000fe40000000091ULL, 0x0000105433347816ULL, 0x000fe40000000034ULL,
0x0000105439397816ULL, 0x000fe4000000008cULL, 0x00001054903d7816ULL, 0x000fe2000000008fULL,
0x000000302030723cULL, 0x000fe200000418ffULL, 0x000010543f627816ULL, 0x000fc40000000062ULL,
0x000010548e637816ULL, 0x000fe40000000063ULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x000000342034723cULL, 0x040fe200000418ffULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x000000ff3a8b7812ULL, 0x000fe200078ec0ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x000000ff3b8c7812ULL, 0x000fe200078ec0ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff887819ULL, 0x000fe2000001163eULL, 0x000000382038723cULL, 0x000fe200000418ffULL,
0x00000084ff84723eULL, 0x000fc400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000008ff647819ULL, 0x000fe20000011664ULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fe20000011665ULL, 0x0000003c203c723cULL, 0x040fe200000418ffULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000088ff8d723eULL, 0x000fe200020006ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000064ff8e723eULL, 0x000fe200020006ffULL,
0x000000622020723cULL, 0x000b6200000418ffULL, 0x00000065ff88723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe20000011682ULL,
0x2000008dff827230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe20000011683ULL,
0x2000008eff837230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x020fe20000011686ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fc40000011687ULL,
0x0000105463647816ULL, 0x000fe40000000064ULL, 0x0000105462657816ULL, 0x000fe40000000065ULL,
0x00000010ff637819ULL, 0x000fe40000011684ULL, 0x00000010ff627819ULL, 0x000fe40000011689ULL,
0x00000010ff857819ULL, 0x000fe20000011685ULL, 0x000000642c24723cULL, 0x000f620000041824ULL,
0x00000010ff8a7819ULL, 0x000fc4000001168aULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x0000105463627816ULL, 0x000fe40000000062ULL, 0x0000105485637816ULL, 0x000fe2000000008aULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x000000ff79797812ULL, 0x000fe200078ec0ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x000000ff7a7a7812ULL, 0x000fe200078ec0ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x000000622c20723cULL, 0x000b620000041820ULL,
0x00000010ff7d7819ULL, 0x000fc4000001167dULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x020fe40000011682ULL,
0x00000010ff637819ULL, 0x000fe20000011683ULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000008ff7f7819ULL, 0x000fc4000001167fULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00000010ff647819ULL, 0x000fe20000011681ULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe20000011680ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff8c7819ULL, 0x000fc4000001168cULL, 0x000010547d627816ULL, 0x000fe40000000062ULL,
0x000010547e637816ULL, 0x000fe40000000063ULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x000010548b647816ULL, 0x000fe20000000064ULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x000010548c657816ULL, 0x000fe20000000065ULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x000000622c30723cULL, 0x000b620000041830ULL,
0x00000010ff797819ULL, 0x000fc40000011679ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000008ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff627819ULL, 0x020fe20000011677ULL,
0x000000642c40723cULL, 0x000b620000041840ULL, 0x00000010ff637819ULL, 0x000fe40000011678ULL,
0x00000008ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff7b7819ULL, 0x000fc4000001167bULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff647819ULL, 0x020fe40000011688ULL,
0x00000010ff657819ULL, 0x000fe4000001167fULL, 0x0000105479627816ULL, 0x000fe40000000062ULL,
0x000010547a637816ULL, 0x000fe40000000063ULL, 0x00000074ff74723eULL, 0x000fc400020006ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x000010547b647816ULL, 0x000fe20000000064ULL,
0x000000622c38723cULL, 0x000b620000041838ULL, 0x000010547c657816ULL, 0x000fe20000000065ULL,
0x20000076ff767230ULL, 0x000fe40000004100ULL, 0x20000075ff757230ULL, 0x000fc60000004100ULL,
0x0000000172627810ULL, 0x020fe20007ffe0ffULL, 0x000000642c34723cULL, 0x000b620000041834ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x000000626900720cULL, 0x000fe40005746470ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff657819ULL, 0x020fe40000011674ULL,
0x00000010ff647819ULL, 0x000fc40000011673ULL, 0x000000626800720cULL, 0x000fe40004f26470ULL,
0x0000105465647816ULL, 0x000fe40000000064ULL, 0x0000105476657816ULL, 0x000fce0000000075ULL,
0x000000642c3c723cULL, 0x000b62000004183cULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000240d0d7221ULL, 0x000fe20000010000ULL,
0x000000250c0c7221ULL, 0x000fe20000010000ULL, 0x0000002009097221ULL, 0x000fe20000010000ULL,
0x0000002108087221ULL, 0x000fe20000010000ULL, 0x0000004005057221ULL, 0x000fe20000010000ULL,
0x0000004144447221ULL, 0x000fe20000010000ULL, 0x0000003047477221ULL, 0x000fe20000010000ULL,
0x0000003148487221ULL, 0x000fe20000010000ULL, 0x000000284b4b7221ULL, 0x000fe20000010000ULL,
0x000000294c4c7221ULL, 0x000fe20000010000ULL, 0x000000344f4f7221ULL, 0x000fe20000010000ULL,
0x0000003550507221ULL, 0x000fe20000010000ULL, 0x0000003853537221ULL, 0x000fe20000010000ULL,
0x0000003954547221ULL, 0x000fe20000010000ULL, 0x0000003c57577221ULL, 0x020fe20000010000ULL,
0x0000003d58587221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000260b0b7221ULL, 0x000fe20000010000ULL, 0x000000270a0a7221ULL, 0x000fe20000010000ULL,
0x0000002207077221ULL, 0x000fe20000010000ULL, 0x0000002306067221ULL, 0x000fe20000010000ULL,
0x0000004245457221ULL, 0x000fe20000010000ULL, 0x0000004346467221ULL, 0x000fe20000010000ULL,
0x0000003249497221ULL, 0x000fe20000010000ULL, 0x000000334a4a7221ULL, 0x000fe20000010000ULL,
0x0000002a4d4d7221ULL, 0x000fe20000010000ULL, 0x0000002b4e4e7221ULL, 0x000fe20000010000ULL,
0x0000003651517221ULL, 0x000fe20000010000ULL, 0x0000003752527221ULL, 0x000fe20000010000ULL,
0x0000003a55557221ULL, 0x000fe20000010000ULL, 0x0000003b56567221ULL, 0x000fe20000010000ULL,
0x0000003e59597221ULL, 0x020fe20000010000ULL, 0x0000003f5a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x000e62000c80043fULL, 0x00000002ff237819ULL, 0x000fe20000011662ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000000125b00720cULL, 0x000fc40003fc3070ULL,
0x0000002362237207ULL, 0x040fe40002800000ULL, 0x0000000362627812ULL, 0x000fe400078ec0ffULL,
0x0000000323277810ULL, 0x000fe40007ffe0ffULL, 0x000000125b00720cULL, 0x000fe40003f03070ULL,
0x00000040ff297803ULL, 0x000fe40000000000ULL, 0x000000ff62237207ULL, 0x000fc40006800000ULL,
0x0000000327257812ULL, 0x040fe400078ec0ffULL, 0x0000001227227211ULL, 0x000fe200078ff0ffULL,
0x000000ffff2d7224ULL, 0x022fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010b8400ff247984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000024ff7812ULL, 0x002fe200078c4871ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026202b7210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e21ULL,
0x003d09002b00780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011427ULL, 0x0000002b24247211ULL, 0x000fca00078d10ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x0000000224247819ULL, 0x000fc80000001227ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8400ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe400078c4871ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fc40000015200ULL,
0x010b8c00ff247984ULL, 0x000e620000000800ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000024ff7812ULL, 0x002fe200078c482dULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026202b7210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e21ULL, 0x003d09002b00780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011427ULL,
0x0000002b24247211ULL, 0x000fca00078d10ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x0000000224247819ULL, 0x000fc80000001227ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe400078c482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000122207810ULL, 0x000fe20007ffe0ffULL, 0x0000097000017945ULL, 0x000fe60003800000ULL,
0x0000005d2000720cULL, 0x000fda0003fc6070ULL, 0x000005100000e947ULL, 0x000fea0003800000ULL,
0x000000015c2a7824ULL, 0x000fe200078e021bULL, 0x000000021b317810ULL, 0x000fe20007ffe0ffULL,
0x0000001004247824ULL, 0x000fe400078e00ffULL, 0x00000040032b7824ULL, 0x000fe200078e022aULL,
0x010a00002a267984ULL, 0x000e620000004800ULL, 0x00000100ff2c7424ULL, 0x000fe200078e00ffULL,
0x000000f0242d7812ULL, 0x000fe200078ec0ffULL, 0x0000000422247824ULL, 0x000fe400078e0225ULL,
0x000000102a2f7824ULL, 0x000fc400078e00ffULL, 0x0000004024247824ULL, 0x000fe400078e00ffULL,
0x000000015c337824ULL, 0x000fc600078e0231ULL, 0x000000245f277217ULL, 0x000fe20007800000ULL,
0x00000001332e7824ULL, 0x040fe400078e0204ULL, 0x0000001033337824ULL, 0x000fe400078e00ffULL,
0x0000000127277824ULL, 0x000fe400078e0a24ULL, 0x000000012a247824ULL, 0x000fe200078e0204ULL,
0xfffffff0332e7812ULL, 0x000fe400078ee22eULL, 0x000000275c277217ULL, 0x000fe20007800000ULL,
0x010ac00026217984ULL, 0x0022a40000004800ULL, 0xfffffff02f267812ULL, 0x002fc400078ee224ULL,
0x0000000127247824ULL, 0x000fe400078e0a5cULL, 0x0000c000262f7811ULL, 0x000fe400078e20ffULL,
0x000000022b267810ULL, 0x000fe20007ffe0ffULL, 0x0000002114217224ULL, 0x004fc800078e022bULL,
0x00005e0021207625ULL, 0x000fca00078e002cULL, 0x0000002d20207210ULL, 0x000fca0007fde0ffULL,
0x000000ffff217224ULL, 0x000fe200030e0621ULL, 0x000000241b00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000202f7faeULL, 0x0003e8000f101c46ULL,
0x010a08002a287984ULL, 0x000ea20000004800ULL, 0x0000c0002e2f7811ULL, 0x002fe400078e20ffULL,
0x000000042b207810ULL, 0x040fe40007ffe0ffULL, 0x000000062b2b7810ULL, 0x000fe20007ffe0ffULL,
0x010ac00028277984ULL, 0x004e640000004800ULL, 0x0000002714277224ULL, 0x002fc800078e0226ULL,
0x00005e0027267625ULL, 0x000fca00078e002cULL, 0x0000002d26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000243100720cULL, 0x000fe40003fc6070ULL,
0x000000041b317810ULL, 0x000fca0007ffe0ffULL, 0x000000015c337824ULL, 0x000fc800078e0231ULL,
0x00000001332e7824ULL, 0x040fe400078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000f101c46ULL, 0x0000001033337824ULL, 0x000fc600078e00ffULL,
0x010a10002a287984ULL, 0x000ea40000004800ULL, 0xfffffff0332e7812ULL, 0x000fc800078ee22eULL,
0x0000c0002e2f7811ULL, 0x002fe200078e20ffULL, 0x010ac00028217984ULL, 0x004e640000004800ULL,
0x0000002114217224ULL, 0x002fc800078e0220ULL, 0x00005e0021207625ULL, 0x000fca00078e002cULL,
0x0000002d20207210ULL, 0x000fca0007fde0ffULL, 0x000000ffff217224ULL, 0x000fe200030e0621ULL,
0x000000243100720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000202f7faeULL, 0x0003e8000f101c46ULL, 0x010a18002a287984ULL, 0x000ea80000004800ULL,
0x010ac00028277984ULL, 0x004ea40000004800ULL, 0x0000002714277224ULL, 0x004fe200078e022bULL,
0x000000061b2b7810ULL, 0x000fc60007ffe0ffULL, 0x00005e0027267625ULL, 0x000fca00078e002cULL,
0x0000002d26267210ULL, 0x000fe20007fde0ffULL, 0x000000015c2d7824ULL, 0x000fc800078e022bULL,
0x000000012d2c7824ULL, 0x000fe400078e0204ULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x000000242b00720cULL, 0x000fe20003fc6070ULL, 0x000000102d2d7824ULL, 0x000fca00078e00ffULL,
0xfffffff02d2c7812ULL, 0x000fc800078ee22cULL, 0x0000c0002c217811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026217faeULL, 0x0003e2000f101c46ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x000000015c287824ULL, 0x000fe400078e021bULL,
0x0000001004267824ULL, 0x000fe400078e00ffULL, 0x00000040032a7824ULL, 0x000fe200078e0228ULL,
0x010a000028247984ULL, 0x000e620000004800ULL, 0x00000100ff2c7424ULL, 0x000fe200078e00ffULL,
0x000000f0262b7812ULL, 0x000fe200078ec0ffULL, 0x0000000128267824ULL, 0x040fe200078e0204ULL,
0x00000002282f7810ULL, 0x040fe20007ffe0ffULL, 0x0000001028277824ULL, 0x000fc800078e00ffULL,
0x000000012f2e7824ULL, 0x000fe200078e0204ULL, 0xfffffff027267812ULL, 0x000fe200078ee226ULL,
0x000000102f2f7824ULL, 0x000fc600078e00ffULL, 0x0000c000262d7811ULL, 0x000fe400078e20ffULL,
0x000000022a267810ULL, 0x000fe40007ffe0ffULL, 0xfffffff02f2e7812ULL, 0x000fe400078ee22eULL,
0x00000004282f7810ULL, 0x000fe20007ffe0ffULL, 0x010ac00024217984ULL, 0x002e640000004800ULL,
0x0000002114217224ULL, 0x002fc800078e022aULL, 0x00005e0021207625ULL, 0x000fca00078e002cULL,
0x0000002b20207210ULL, 0x000fca0007fde0ffULL, 0x000000ffff217224ULL, 0x000fca00030e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000202d7faeULL, 0x0003e8000b901c46ULL,
0x010a080028247984ULL, 0x000ea20000004800ULL, 0x0000c0002e2d7811ULL, 0x002fe200078e20ffULL,
0x000000012f2e7824ULL, 0x040fe200078e0204ULL, 0x000000042a207810ULL, 0x040fe20007ffe0ffULL,
0x000000102f2f7824ULL, 0x000fe200078e00ffULL, 0x000000062a2a7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff02f2e7812ULL, 0x000fe200078ee22eULL, 0x010ac00024277984ULL, 0x004e640000004800ULL,
0x0000002714277224ULL, 0x002fc800078e0226ULL, 0x00005e0027267625ULL, 0x000fca00078e002cULL,
0x0000002b26267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0003e8000b901c46ULL,
0x010a100028247984ULL, 0x000ea20000004800ULL, 0x0000c0002e2d7811ULL, 0x002fc600078e20ffULL,
0x010ac00024217984ULL, 0x004e640000004800ULL, 0x0000002114217224ULL, 0x002fc800078e0220ULL,
0x00005e0021207625ULL, 0x000fca00078e002cULL, 0x0000002b20207210ULL, 0x000fca0007fde0ffULL,
0x000000ffff217224ULL, 0x000fca00030e0621ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000202d7faeULL, 0x0003e8000b901c46ULL, 0x010a180028247984ULL, 0x000ea80000004800ULL,
0x010ac00024277984ULL, 0x004ea40000004800ULL, 0x0000002714277224ULL, 0x004fc800078e022aULL,
0x00005e0027267625ULL, 0x000fca00078e002cULL, 0x0000002b26267210ULL, 0x000fe40007fde0ffULL,
0x00000006282b7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff277224ULL, 0x000fe400030e0627ULL,
0x000000012b2a7824ULL, 0x040fe400078e0204ULL, 0x000000102b2b7824ULL, 0x000fca00078e00ffULL,
0xfffffff02b2a7812ULL, 0x000fc800078ee22aULL, 0x0000c0002a217811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026217faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x002e64000c80043fULL, 0x000000ffff2d7224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b8c00ff247984ULL, 0x000e620000000800ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000024ff7812ULL, 0x002fe200078c482dULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026202b7210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e21ULL,
0x003d09002b00780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011427ULL, 0x0000002b24247211ULL, 0x000fca00078d10ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x0000000224247819ULL, 0x000fc80000001227ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe400078c482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000225b00720cULL, 0x000fc80003fc4070ULL,
0x000000ff23207207ULL, 0x040fe40003000000ULL, 0x000000ff23237207ULL, 0x000fc60007000000ULL,
0x0000000125257824ULL, 0x000fc800078e0220ULL, 0x0000004025207824ULL, 0x040fe200078e00ffULL,
0x0000002225227211ULL, 0x000fe400078ff0ffULL, 0x00010a0015257811ULL, 0x000fe400078e10ffULL,
0x000000c020217812ULL, 0x000fe200078ec0ffULL, 0x0000000160207824ULL, 0x000fe400078e0223ULL,
0x00000004ff237424ULL, 0x000fe400078e00ffULL, 0x0000010022217824ULL, 0x000fca00078e0221ULL,
0x0000002021217810ULL, 0x000fca0007ffe0ffULL, 0x0000000115227824ULL, 0x100fe400078e0221ULL,
0x0000680020207a24ULL, 0x000fc600078e0221ULL, 0x0000005f2200720cULL, 0x000fe20003fc6070ULL,
0x0000000115207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fd000078e0023ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e4000f121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b7800ff207f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x002fe200078e0021ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000018ff19723eULL, 0x000fc800000010ffULL,
0x0000541019227816ULL, 0x000fe20000000019ULL, 0x000099627f007947ULL, 0x000fea000b800000ULL,
0x00001f6922197589ULL, 0x0002a400000e0000ULL, 0x000099a27f007947ULL, 0x000fea000b800000ULL,
0x00001f68221a7589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001069277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x00019b0000207802ULL, 0x000fc40000000f00ULL, 0x00009ee000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001869277810ULL, 0x002fe40007ffe0ffULL, 0x00019b5000207802ULL, 0x000fc40000000f00ULL,
0x00009e9000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff2900720cULL, 0x000fe20003fc5270ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006a28783bULL, 0x000f220000004200ULL, 0x0000172000017945ULL, 0x000fe60003800000ULL,
0x000000006b24783bULL, 0x006e680000004200ULL, 0x000000006e20783bULL, 0x008ea80000004200ULL,
0x000000006d2c783bULL, 0x000ee20000004200ULL, 0x00000018ff407819ULL, 0x010fc40000011629ULL,
0x00000010ff417819ULL, 0x000fe40000011628ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x000000ff29427812ULL, 0x000fe400078ec0ffULL, 0x00000010ff357819ULL, 0x002fe20000011624ULL,
0x20000040ff8f7230ULL, 0x000fe20000004100ULL, 0x0000b8006f407811ULL, 0x000fe400078e20ffULL,
0x000000ff243c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff387819ULL, 0x000fe40000011624ULL,
0x0000ffff24337812ULL, 0x000fe400078ec0ffULL, 0x00000010ff317819ULL, 0x104fe40000011620ULL,
0x000000ff20877812ULL, 0x040fe400078ec0ffULL, 0x00000018ff867819ULL, 0x000fe40000011620ULL,
0x0000ffff20347812ULL, 0x000fc400078ec0ffULL, 0x000000ff28247812ULL, 0x000fe400078ec0ffULL,
0x00000010ff307819ULL, 0x100fe40000011621ULL, 0x000000ff21857812ULL, 0x040fe400078ec0ffULL,
0x00000018ff847819ULL, 0x000fe40000011621ULL, 0x0000ffff213a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7a7819ULL, 0x000fc4000001162aULL, 0x000000ff2a8d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff207819ULL, 0x000fe4000001162aULL, 0x0000ffff2a777812ULL, 0x000fe400078ec0ffULL,
0x00000010ff767819ULL, 0x100fe4000001162bULL, 0x000000ff2b837812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7c7819ULL, 0x000fc4000001162bULL, 0x0000ffff2b737812ULL, 0x000fe400078ec0ffULL,
0x00000010ff397819ULL, 0x100fe40000011622ULL, 0x000000ff22747812ULL, 0x040fe400078ec0ffULL,
0x00000018ff787819ULL, 0x000fe40000011622ULL, 0x0000ffff223e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3b7819ULL, 0x000fc40000011623ULL, 0x000000ff23757812ULL, 0x040fe400078ec0ffULL,
0x00000018ff797819ULL, 0x000fe40000011623ULL, 0x0000ffff23627812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe40000011627ULL, 0x000000ff277e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff217819ULL, 0x000fc40000011627ULL, 0x0000ffff27657812ULL, 0x000fe400078ec0ffULL,
0x00000042ff2a723eULL, 0x000fe400020006ffULL, 0x000000ff412b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff377819ULL, 0x100fe20000011625ULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x000000ff253f7812ULL, 0x000fe200078ec0ffULL, 0x2000002aff2a7230ULL, 0x000fe20000004100ULL,
0x00000018ff3d7819ULL, 0x000fc40000011625ULL, 0x0000ffff25367812ULL, 0x000fe400078ec0ffULL,
0x00000010ff327819ULL, 0x100fe40000011626ULL, 0x000000ff267d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7b7819ULL, 0x000fe40000011626ULL, 0x0000ffff26637812ULL, 0x000fe400078ec0ffULL,
0x00000018ff237819ULL, 0x000fc40000011628ULL, 0x0000ffff28907812ULL, 0x000fe400078ec0ffULL,
0x00000010ff227819ULL, 0x000fe40000011629ULL, 0x0000ffff29277812ULL, 0x000fe400078ec0ffULL,
0x00000024ff26723eULL, 0x000fe400020006ffULL, 0x00000010ff297819ULL, 0x008fe4000001162dULL,
0x000000ff2d257812ULL, 0x000fc400078ec0ffULL, 0x0000ffff2d287812ULL, 0x000fe400078ec0ffULL,
0x00000010ff917819ULL, 0x100fe4000001162cULL, 0x000000ff2c247812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2c8c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001162dULL,
0x00000018ff2c7819ULL, 0x000fe2000001162cULL, 0x000000194040b231ULL, 0x082fe200003400ffULL,
0x00000023ff8e723eULL, 0x000fe200020006ffULL, 0x20000026ff237230ULL, 0x000fe20000004100ULL,
0x0000002dff2d723eULL, 0x000fe200020006ffULL, 0x000000194242b231ULL, 0x000fe200003400ffULL,
0x0000002cff26723eULL, 0x000fe200020006ffULL, 0x0000001a4141b231ULL, 0x080fe200003400ffULL,
0x00000008ff2c7819ULL, 0x000fe20000011627ULL, 0x2000002dff277230ULL, 0x000fe20000004100ULL,
0x000000ff29297812ULL, 0x000fe200078ec0ffULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x0000002cff2d723eULL, 0x000fe200020006ffULL, 0x0000001a4343b231ULL, 0x000fe200003400ffULL,
0x000000ff912c7812ULL, 0x000fe200078ec0ffULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000025ff25723eULL, 0x000fe200020006ffULL, 0x2000002dff917230ULL, 0x000fe20000004100ULL,
0x0000002cff2c723eULL, 0x000fc400020006ffULL, 0x00000008ff287819ULL, 0x000fe20000011628ULL,
0x20000025ff257230ULL, 0x000fe20000004100ULL, 0x0000b8006c2d7811ULL, 0x000fe400078e20ffULL,
0x00000024ff24723eULL, 0x000fe400020006ffULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x00000008ff8c7819ULL, 0x000fe2000001168cULL, 0x20000024ff247230ULL, 0x000fe20000004100ULL,
0x00000028ff93723eULL, 0x000fe200020006ffULL, 0x2000002cff287230ULL, 0x000fe20000004100ULL,
0x00000010ff7f7819ULL, 0x000fe2000001162eULL, 0x20000029ff927230ULL, 0x000fe20000004100ULL,
0x000000ff2e887812ULL, 0x040fe200078ec0ffULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x0000ffff2e807812ULL, 0x000fc400078ec0ffULL, 0x00000018ff897819ULL, 0x000fe4000001162eULL,
0x00000010ff817819ULL, 0x100fe4000001162fULL, 0x000000ff2f8a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2f827812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fe4000001162fULL,
0x000000002d2c783bULL, 0x000e620000000200ULL, 0x0000008cff8c723eULL, 0x000fc400020006ffULL,
0x00000010ff297819ULL, 0x000fe40000011625ULL, 0x00000010ff247819ULL, 0x000fe20000011624ULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fe40000011628ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x0000105425247816ULL, 0x000fe40000000024ULL,
0x0000105492257816ULL, 0x000fc40000000029ULL, 0x00000010ff297819ULL, 0x000fe40000011626ULL,
0x00000010ff287819ULL, 0x000fe4000001168cULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x00000010ff8c7819ULL, 0x000fe40000011627ULL, 0x00000010ff937819ULL, 0x000fe20000011693ULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x0000105429287816ULL, 0x000fe20000000028ULL,
0x000000244024723cULL, 0x000fe200000418ffULL, 0x000010548c297816ULL, 0x000fc40000000093ULL,
0x000000ff22227812ULL, 0x000fe400078ec0ffULL, 0x00000008ff907819ULL, 0x000fe40000011690ULL,
0x00000010ff937819ULL, 0x000fe4000001162aULL, 0x00000010ff927819ULL, 0x000fe4000001162bULL,
0x000000284028723cULL, 0x000f6200000418ffULL, 0x00000022ff22723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe200020006ffULL, 0x000000192c2cb231ULL, 0x082fe200003400ffULL,
0x00000010ff237819ULL, 0x000fe20000011623ULL, 0x20000022ff227230ULL, 0x000fe20000004100ULL,
0x00000021ff8c723eULL, 0x000fe200020006ffULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x000fe2000001168eULL, 0x000000192e2eb231ULL, 0x000fe200003400ffULL,
0x00000010ff947819ULL, 0x000fe20000011622ULL, 0x0000001a2d2db231ULL, 0x080fe200003400ffULL,
0x0000105492227816ULL, 0x000fe20000000023ULL, 0x0000001a2f2fb231ULL, 0x000fe200003400ffULL,
0x00000010ff907819ULL, 0x000fc40000011690ULL, 0x00000010ff927819ULL, 0x000fe4000001168fULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x00000020ff8e723eULL, 0x000fe400020006ffULL,
0x0000105421207816ULL, 0x000fe40000000090ULL, 0x0000105492217816ULL, 0x000fe40000000091ULL,
0x00000085ff85723eULL, 0x000fc400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000008ff347819ULL, 0x000fe20000011634ULL, 0x000000202c28723cULL, 0x020be20000041828ULL,
0x00000083ff92723eULL, 0x000fe200020006ffULL, 0x20000086ff837230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x000000ff30867812ULL, 0x000fe400078ec0ffULL,
0x20000085ff217230ULL, 0x020fe20000004100ULL, 0x000000ff31857812ULL, 0x000fe200078ec0ffULL,
0x2000008aff307230ULL, 0x000fe20000004100ULL, 0x0000105494237816ULL, 0x000fc40000000093ULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x000000ff39397812ULL, 0x000fe200078ec0ffULL, 0x000000222c24723cULL, 0x000be20000041824ULL,
0x00000008ff3e7819ULL, 0x000fe4000001163eULL, 0x000000ff3b3b7812ULL, 0x000fe400078ec0ffULL,
0x00000074ff74723eULL, 0x000fc400020006ffULL, 0x00000086ff8a723eULL, 0x000fe200020006ffULL,
0x20000085ff867230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000034ff857230ULL, 0x000fe20000004100ULL, 0x00000008ff3a7819ULL, 0x000fe2000001163aULL,
0x20000074ff237230ULL, 0x020fe20000004100ULL, 0x00000039ff39723eULL, 0x000fe200020006ffULL,
0x20000078ff227230ULL, 0x000fe20000004100ULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x2000008eff747230ULL, 0x000fe20000004100ULL, 0x0000003eff3e723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x2000008dff787230ULL, 0x000fe20000004100ULL, 0x00000008ff347819ULL, 0x000fc40000011662ULL,
0x0000003bff3b723eULL, 0x000fe400020006ffULL, 0x00000008ff637819ULL, 0x000fe40000011663ULL,
0x0000007cff93723eULL, 0x000fe200020006ffULL, 0x2000008cff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL, 0x20000039ff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff807819ULL, 0x000fe20000011680ULL, 0x2000003eff397230ULL, 0x000fe20000004100ULL,
0x0000003aff3a723eULL, 0x000fe200020006ffULL, 0x2000003bff8d7230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fc400020006ffULL, 0x00000089ff91723eULL, 0x000fe200020006ffULL,
0x20000075ff897230ULL, 0x000fe20000004100ULL, 0x00000034ff34723eULL, 0x000fe200020006ffULL,
0x2000003aff627230ULL, 0x000fe20000004100ULL, 0x00000063ff8e723eULL, 0x000fe200020006ffULL,
0x20000091ff317230ULL, 0x000fe20000004100ULL, 0x00000008ff827819ULL, 0x000fe20000011682ULL,
0x20000034ff347230ULL, 0x000fe20000004100ULL, 0x00000088ff90723eULL, 0x000fe200020006ffULL,
0x20000079ff887230ULL, 0x000fe20000004100ULL, 0x0000007fff3e723eULL, 0x000fe200020006ffULL,
0x2000008eff7f7230ULL, 0x000fe20000004100ULL, 0x00000080ff63723eULL, 0x000fe200020006ffULL,
0x20000092ff797230ULL, 0x000fe20000004100ULL, 0x000000ff81817812ULL, 0x000fe200078ec0ffULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x0000003cff80723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x20000093ff757230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe20000011621ULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000082ff3a723eULL, 0x000fe200020006ffULL,
0x20000087ff207230ULL, 0x000fe20000004100ULL, 0x00000010ff217819ULL, 0x000fc40000011686ULL,
0x0000008bff8f723eULL, 0x000fe200020006ffULL, 0x20000090ff8b7230ULL, 0x000fe20000004100ULL,
0x00000038ff82723eULL, 0x000fe200020006ffULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x0000003dff86723eULL, 0x000fe200020006ffULL, 0x2000008fff877230ULL, 0x000fe20000004100ULL,
0x00000081ff3b723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x000000ff35357812ULL, 0x000fe200078ec0ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000010ff3d7819ULL, 0x000fe20000011689ULL, 0x2000003bff3b7230ULL, 0x000fe20000004100ULL,
0x00000010ff387819ULL, 0x000fc4000001168dULL, 0x0000003fff81723eULL, 0x000fe400020006ffULL,
0x00000010ff3f7819ULL, 0x000fe4000001168aULL, 0x000000ff378a7812ULL, 0x000fe200078ec0ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000035ff89723eULL, 0x000fe400020006ffULL,
0x00001054383d7816ULL, 0x000fe4000000003dULL, 0x00000010ff377819ULL, 0x000fe20000011688ULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fc40000011634ULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000010ff357819ULL, 0x000fe40000011622ULL,
0x00000010ff387819ULL, 0x000fe20000011639ULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff887819ULL, 0x000fe4000001163eULL,
0x00000010ff207819ULL, 0x000fc40000011620ULL, 0x0000105437397816ULL, 0x000fe40000000034ULL,
0x0000105435387816ULL, 0x000fe40000000038ULL, 0x0000105488347816ULL, 0x000fe4000000008bULL,
0x00000010ff357819ULL, 0x000fe40000011630ULL, 0x00000010ff887819ULL, 0x000fe4000001163bULL,
0x0000105421207816ULL, 0x000fc40000000020ULL, 0x000010543f217816ULL, 0x000fe4000000003cULL,
0x00000010ff3c7819ULL, 0x000fe4000001168cULL, 0x00000010ff317819ULL, 0x000fe40000011631ULL,
0x00000010ff307819ULL, 0x000fe40000011663ULL, 0x00000010ff237819ULL, 0x000fe40000011623ULL,
0x00000010ff8c7819ULL, 0x000fc40000011687ULL, 0x00000010ff377819ULL, 0x000fe4000001163aULL,
0x0000105488357816ULL, 0x000fe20000000035ULL, 0x000000384038723cULL, 0x000fe200000418ffULL,
0x00000010ff887819ULL, 0x000fe40000011683ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff637819ULL, 0x000fc40000011662ULL,
0x0000105431307816ULL, 0x000fe40000000030ULL, 0x000010543c3c7816ULL, 0x000fe40000000023ULL,
0x000010548c317816ULL, 0x000fe20000000037ULL, 0x000000204020723cULL, 0x000f6200000418ffULL,
0x0000105488627816ULL, 0x000fe40000000085ULL, 0x0000105484637816ULL, 0x000fe40000000063ULL,
0x00000008ff337819ULL, 0x000fc40000011633ULL, 0x00000008ff877819ULL, 0x000fe20000011636ULL,
0x0000003c403c723cULL, 0x040fe200000418ffULL, 0x00000033ff83723eULL, 0x000fe400020006ffULL,
0x000000ff32847812ULL, 0x000fe400078ec0ffULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x000000ff64647812ULL, 0x000fe200078ec0ffULL,
0x000000344034723cULL, 0x000fe200000418ffULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x000000ff7a857812ULL, 0x000fc400078ec0ffULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fe20000011665ULL, 0x000000304030723cULL, 0x040fe200000418ffULL,
0x00000085ff88723eULL, 0x000fe200020006ffULL, 0x20000064ff857230ULL, 0x000fe20000004100ULL,
0x00000065ff7a723eULL, 0x000fe400020006ffULL, 0x00000010ff647819ULL, 0x000fe40000011680ULL,
0x00000010ff657819ULL, 0x000fe20000011681ULL, 0x000000624040723cULL, 0x000b6200000418ffULL,
0x00000010ff897819ULL, 0x000fe20000011689ULL, 0x2000007aff807230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fe2000001168aULL, 0x20000088ff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff867819ULL, 0x000fc40000011686ULL, 0x00000010ff637819ULL, 0x020fe40000011682ULL,
0x00000010ff627819ULL, 0x000fe40000011683ULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x0000105489647816ULL, 0x000fe20000000064ULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x000010548a657816ULL, 0x000fe20000000065ULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x0000105463627816ULL, 0x000fc40000000062ULL, 0x0000105486637816ULL, 0x000fe40000000087ULL,
0x00000008ff777819ULL, 0x000fe20000011677ULL, 0x000000642c20723cULL, 0x040b620000041820ULL,
0x000000ff76767812ULL, 0x000fe400078ec0ffULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff647819ULL, 0x020fe2000001167dULL,
0x000000622c40723cULL, 0x000b620000041840ULL, 0x00000010ff657819ULL, 0x000fc40000011684ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff627819ULL, 0x020fe4000001167fULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff637819ULL, 0x000fe40000011680ULL, 0x00000077ff77723eULL, 0x000fc400020006ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x0000105465647816ULL, 0x000fe20000000064ULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x0000105485657816ULL, 0x000fe4000000007eULL,
0x000010547b627816ULL, 0x000fe20000000062ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x000010547c637816ULL, 0x000fc40000000063ULL, 0x00000010ff797819ULL, 0x000fe20000011679ULL,
0x000000642c3c723cULL, 0x000b62000004183cULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff737819ULL, 0x000fc80000011673ULL, 0x00000010ff647819ULL, 0x020fe20000011678ULL,
0x000000622c38723cULL, 0x000b620000041838ULL, 0x00000010ff657819ULL, 0x000fc8000001167aULL,
0x0000105465647816ULL, 0x000fe40000000064ULL, 0x00000010ff637819ULL, 0x020fe40000011674ULL,
0x00000010ff627819ULL, 0x000fe40000011677ULL, 0x00000010ff747819ULL, 0x000fe40000011675ULL,
0x0000105463627816ULL, 0x000fe40000000062ULL, 0x0000105476657816ULL, 0x000fc40000000079ULL,
0x0000105474637816ULL, 0x000fca0000000073ULL, 0x000000642c34723cULL, 0x040b700000041834ULL,
0x000000622c30723cULL, 0x000b620000041830ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000200d0d7221ULL, 0x000fe20000010000ULL,
0x000000210c0c7221ULL, 0x000fe20000010000ULL, 0x0000004009097221ULL, 0x000fe20000010000ULL,
0x0000004108087221ULL, 0x000fe20000010000ULL, 0x0000003c05057221ULL, 0x000fe20000010000ULL,
0x0000003d44447221ULL, 0x000fe20000010000ULL, 0x0000003847477221ULL, 0x000fe20000010000ULL,
0x0000003948487221ULL, 0x000fe20000010000ULL, 0x000000244b4b7221ULL, 0x000fe20000010000ULL,
0x000000254c4c7221ULL, 0x000fe20000010000ULL, 0x000000284f4f7221ULL, 0x000fe20000010000ULL,
0x0000002950507221ULL, 0x000fe20000010000ULL, 0x0000003453537221ULL, 0x020fe20000010000ULL,
0x0000003554547221ULL, 0x000fe20000010000ULL, 0x0000003057577221ULL, 0x000fe20000010000ULL,
0x0000003158587221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000220b0b7221ULL, 0x000fe20000010000ULL, 0x000000230a0a7221ULL, 0x000fe20000010000ULL,
0x0000004207077221ULL, 0x000fe20000010000ULL, 0x0000004306067221ULL, 0x000fe20000010000ULL,
0x0000003e45457221ULL, 0x000fe20000010000ULL, 0x0000003f46467221ULL, 0x000fe20000010000ULL,
0x0000003a49497221ULL, 0x000fe20000010000ULL, 0x0000003b4a4a7221ULL, 0x000fe20000010000ULL,
0x000000264d4d7221ULL, 0x000fe20000010000ULL, 0x000000274e4e7221ULL, 0x000fe20000010000ULL,
0x0000002a51517221ULL, 0x000fe20000010000ULL, 0x0000002b52527221ULL, 0x000fe20000010000ULL,
0x0000003655557221ULL, 0x020fe20000010000ULL, 0x0000003756567221ULL, 0x000fe20000010000ULL,
0x0000003259597221ULL, 0x000fe20000010000ULL, 0x000000335a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000707200720cULL, 0x000fe20003f06070ULL,
0x010b8800ff227f8cULL, 0x000e58000c80043fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff9b2000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7000ffff7f8cULL, 0x000fe4000c80043fULL, 0x0000000112127810ULL, 0x000fc80007ffe0ffULL,
0x0000005d1200720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffe662000007947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff5d00720cULL, 0x000fe20003f05270ULL, 0x000000ffff167224ULL, 0x000fe400078e0005ULL,
0x000000ffff117224ULL, 0x000fe400078e0006ULL, 0x000000ffff147224ULL, 0x000fe400078e0007ULL,
0x000000ffff127224ULL, 0x000fcc00078e000aULL, 0x0000039000008947ULL, 0x000fea0003800000ULL,
0x018000000e037810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000003037812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0001b61000067802ULL, 0x000fc40000000f00ULL,
0x0000821000007944ULL, 0x02afea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000e00037308ULL, 0x000ea40000001000ULL, 0xbf80000003047423ULL, 0x004fc8000000000eULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x0000000403037223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006e00ff047624ULL, 0x000fe400078e00ffULL,
0x00006f00ff057624ULL, 0x000fca00078e00ffULL, 0x0000000604047981ULL, 0x000f28000c1e9900ULL,
0x0000000000067919ULL, 0x000ee40000000000ULL, 0x00000002ff277819ULL, 0x008fe20000011606ULL,
0x0000000304067220ULL, 0x014fe20000410000ULL, 0x00007dc27f007947ULL, 0x000fea000b800000ULL,
0x00001f2706037589ULL, 0x0004e400000e0000ULL, 0x0000000000047919ULL, 0x000f220000000000ULL,
0x0000000d030d7220ULL, 0x048fe20000410000ULL, 0x0000000c030c7220ULL, 0x040fe20000410000ULL,
0x0000000903097220ULL, 0x040fe20000410000ULL, 0x0000000803087220ULL, 0x040fe20000410000ULL,
0x0000001603167220ULL, 0x040fe20000410000ULL, 0x0000004403447220ULL, 0x040fe20000410000ULL,
0x0000004703477220ULL, 0x040fe20000410000ULL, 0x0000004803487220ULL, 0x040fe20000410000ULL,
0x0000004b034b7220ULL, 0x040fe20000410000ULL, 0x0000004c034c7220ULL, 0x040fe20000410000ULL,
0x0000004f034f7220ULL, 0x040fe20000410000ULL, 0x0000005003507220ULL, 0x040fe20000410000ULL,
0x0000005303537220ULL, 0x040fe20000410000ULL, 0x0000005403547220ULL, 0x040fe20000410000ULL,
0x0000005703577220ULL, 0x040fe20000410000ULL, 0x0000005803587220ULL, 0x000fe20000410000ULL,
0x0000000804277811ULL, 0x016fe200078ff0ffULL, 0x00007cd27f007947ULL, 0x000fea000b800000ULL,
0x00001f2706037589ULL, 0x0002a400000e0000ULL, 0x0000000b030b7220ULL, 0x044fe20000410000ULL,
0x0000001203127220ULL, 0x040fe20000410000ULL, 0x0000001403147220ULL, 0x040fe20000410000ULL,
0x0000001103117220ULL, 0x040fe20000410000ULL, 0x0000004503457220ULL, 0x040fe20000410000ULL,
0x0000004603467220ULL, 0x040fe20000410000ULL, 0x0000004903497220ULL, 0x040fe20000410000ULL,
0x0000004a034a7220ULL, 0x040fe20000410000ULL, 0x0000004d034d7220ULL, 0x040fe20000410000ULL,
0x0000004e034e7220ULL, 0x040fe20000410000ULL, 0x0000005103517220ULL, 0x040fe20000410000ULL,
0x0000005203527220ULL, 0x040fe20000410000ULL, 0x0000005503557220ULL, 0x040fe20000410000ULL,
0x0000005603567220ULL, 0x040fe20000410000ULL, 0x0000005903597220ULL, 0x040fe20000410000ULL,
0x0000005a035a7220ULL, 0x000fc20000410000ULL, 0x00000000001b7919ULL, 0x000ea20000002600ULL,
0x0000000d0c03723eULL, 0x000fe200000010ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000090804723eULL, 0x000fc400000010ffULL, 0x0000000b120b723eULL, 0x000fe400000010ffULL,
0x00000014110c723eULL, 0x000fe400000010ffULL, 0x000000164405723eULL, 0x000fe400000010ffULL,
0x000000474806723eULL, 0x002fe400000010ffULL, 0x0000004b4c07723eULL, 0x000fe400000010ffULL,
0x0000004f5008723eULL, 0x000fc400000010ffULL, 0x000000535409723eULL, 0x000fe400000010ffULL,
0x00000057580a723eULL, 0x000fe400000010ffULL, 0x00000045460d723eULL, 0x000fe400000010ffULL,
0x000000494a0e723eULL, 0x000fe400000010ffULL, 0x0000004d4e0f723eULL, 0x000fe400000010ffULL,
0x000000515210723eULL, 0x000fc400000010ffULL, 0x000000555611723eULL, 0x000fe400000010ffULL,
0x000000595a12723eULL, 0x000fc400000010ffULL, 0x0000000000167919ULL, 0x004e620000000000ULL,
0x0000a00061617811ULL, 0x000fe400078e58ffULL, 0x00005410031e7816ULL, 0x140fe20000000004ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00007632031f7816ULL, 0x000fc40000000004ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe40000000006ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe40000000008ULL,
0x0000541009087816ULL, 0x140fe4000000000aULL, 0x0000763209097816ULL, 0x000fc4000000000aULL,
0x0000000816147811ULL, 0x042fe400078ff0ffULL, 0x0000000216137812ULL, 0x000fe400078ec0ffULL,
0x000054100b0a7816ULL, 0x000fe2000000000cULL, 0x00000008141c7824ULL, 0x000fe200078e00ffULL,
0x0000001413157211ULL, 0x000fe200078ff8ffULL, 0x0000000816147824ULL, 0x000fe200078e00ffULL,
0x00000002ff167819ULL, 0x000fe40000011616ULL, 0xfffffff81c1c7812ULL, 0x000fc400078ee215ULL,
0x0000000814157812ULL, 0x000fe200078ec0ffULL, 0x0000000816147824ULL, 0x040fe200078e00ffULL,
0x0000001613137211ULL, 0x000fe200078ff8ffULL, 0x0000000816197824ULL, 0x040fe200078e00ffULL,
0x000076320b0b7816ULL, 0x000fe2000000000cULL, 0x0000000816187824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee213ULL, 0x00000008161a7824ULL, 0x000fe200078e00ffULL,
0x0000000213167810ULL, 0x040fe20007ffe0ffULL, 0x000000101c1c7824ULL, 0x100fe200078e0261ULL,
0x0000000413177810ULL, 0x040fe20007ffe0ffULL, 0x0000001014147824ULL, 0x000fe200078e0261ULL,
0x0000000613137810ULL, 0x000fe20007ffe0ffULL, 0x00000001151c7824ULL, 0x000fe200078e021cULL,
0xfffffff819167812ULL, 0x000fe200078ee216ULL, 0x0000000114147824ULL, 0x000fe200078e0215ULL,
0xfffffff818187812ULL, 0x000fc400078ee217ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee213ULL,
0x0000001016167824ULL, 0x100fe200078e0261ULL, 0x000054100d0c7816ULL, 0x140fe2000000000eULL,
0x0000001018187824ULL, 0x100fe200078e0261ULL, 0x000076320d0d7816ULL, 0x000fe2000000000eULL,
0x000000101a1a7824ULL, 0x000fe200078e0261ULL, 0x000054100f0e7816ULL, 0x000fe20000000010ULL,
0x0000000115167824ULL, 0x040fe200078e0216ULL, 0x0000001e14007388ULL, 0x0003e20000000a00ULL,
0x0000000115187824ULL, 0x000fe200078e0218ULL, 0x000076320f0f7816ULL, 0x000fe20000000010ULL,
0x00000001151a7824ULL, 0x000fe200078e021aULL, 0x0000000416007388ULL, 0x0003e20000000a00ULL,
0x0000541011107816ULL, 0x000fc40000000012ULL, 0x0000763211117816ULL, 0x000fe20000000012ULL,
0x0000000618007388ULL, 0x0003e80000000a00ULL, 0x000000081a007388ULL, 0x0003e80000000a00ULL,
0x0000000a1c007388ULL, 0x0003e80000000a00ULL, 0x0004000c16007388ULL, 0x0003e80000000a00ULL,
0x0004000e18007388ULL, 0x0003e80000000a00ULL, 0x000400101a007388ULL, 0x0003e20000000a00ULL,
0x0000002000007947ULL, 0x000fea0003800000ULL, 0x0001be1000187802ULL, 0x002fc40000000f00ULL,
0x00007c7000007944ULL, 0x028fea0003c00000ULL, 0x0000000000087919ULL, 0x002e620000000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000580000007a24ULL, 0x000fe200078e02ffULL,
0x00000003ff027819ULL, 0x002fe40000011608ULL, 0x0000000708097812ULL, 0x000fc600078ec0ffULL,
0x0000000102037824ULL, 0x000fe200078e0208ULL, 0x1ffffff809097812ULL, 0x000fc800078ef85cULL,
0x0000000703037812ULL, 0x000fc800078ec0ffULL, 0x0ffffff803047812ULL, 0x000fe200078ef808ULL,
0x0000580002037a24ULL, 0x000fc800078e021bULL, 0x0000001004047824ULL, 0x000fe200078e0261ULL,
0x0000000300007211ULL, 0x000fca00078010ffULL, 0x0000000004047984ULL, 0x000e620000000c00ULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0000027a11ULL, 0x000fc800078048ffULL,
0x00005b0000037a11ULL, 0x000fca00000f4c03ULL, 0x0000001009027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000004061677824ULL, 0x040fe200078e00ffULL, 0x0000002014077810ULL, 0x040fe20007ffe0ffULL,
0x0000010061667824ULL, 0x000fe200078e00ffULL, 0x000000031400780cULL, 0x000fe20003f44070ULL,
0x0000680060047a24ULL, 0x000fe400078e0267ULL, 0x0000000167067824ULL, 0x140fe400078e0214ULL,
0x0000000167087824ULL, 0x100fe400078e0207ULL, 0x0000000104057824ULL, 0x000fe200078e0214ULL,
0x0000005f0600720cULL, 0x080fe20003f06070ULL, 0x0000000104077824ULL, 0x000fe200078e0207ULL,
0x0000005f0800720cULL, 0x000fe20003f26070ULL, 0x00000004140d7824ULL, 0x000fc400078e0266ULL,
0x0000660005047625ULL, 0x000fc800078e0017ULL, 0x0000660007067625ULL, 0x000fe200078e0017ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010ad000ff0a7f8cULL, 0x000e62000c80043fULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x00006e00ff087624ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x10600000040d7faeULL, 0x0005e2000c121846ULL,
0x00006f00ff097624ULL, 0x000fc600078e00ffULL, 0x10680000060d7faeULL, 0x0005e2000c921846ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x0000000400047824ULL, 0x104fe200078e0214ULL,
0x0000005e6100720cULL, 0x040fe20003f06070ULL, 0x0000000461077824ULL, 0x000fe400078e0214ULL,
0x0000000204047824ULL, 0x000fc600078e00ffULL, 0x00010a8007077811ULL, 0x000fe200078e10ffULL,
0x0000640004047a24ULL, 0x000fc800078e0261ULL, 0x0000600004047625ULL, 0x000fca00078e0017ULL,
0x0000000004077faeULL, 0x0005e4000c121846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001ff0c00780cULL, 0x000fe20003f04070ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000608047981ULL, 0x004528000c1e9900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x000000ffff057224ULL, 0x002fe200078e000bULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000093000000947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x004e620000000000ULL,
0x00010a80610f7811ULL, 0x040fe200078e20ffULL, 0x00000100ff147424ULL, 0x000fe200078e00ffULL,
0x0000200061117811ULL, 0x000fe400078e68ffULL, 0x00000002ff177819ULL, 0x002fe2000001160aULL,
0x000000100a157824ULL, 0x040fe200078e00ffULL, 0x0000000a0a087211ULL, 0x000fe400078fe8ffULL,
0x00000008170b7810ULL, 0x040fe20007ffe0ffULL, 0x00000004170e7824ULL, 0x000fe200078e0266ULL,
0x0000003015157812ULL, 0x000fe200078ec0ffULL, 0x0000004003107824ULL, 0x000fe200078e0217ULL,
0x00000003080d7812ULL, 0x000fe200078ec0ffULL, 0x000000040b167824ULL, 0x000fe200078e00ffULL,
0x010600000e067984ULL, 0x000e640000000800ULL, 0x0000000406097824ULL, 0x002fe200078e020fULL,
0x000000675f067217ULL, 0x000fca0007800000ULL, 0x0000000009097984ULL, 0x000e620000000800ULL,
0x00000001060c7824ULL, 0x000fca00078e0a67ULL, 0x0000000c1700720cULL, 0x000fe20003f06070ULL,
0x0000000409077c24ULL, 0x002fc8000f8e0210ULL, 0x00005e0007067625ULL, 0x000fca00078e0014ULL,
0x0000001506087210ULL, 0x000fe40007f3e0ffULL, 0x0ffffffc0d067812ULL, 0x000fc600078ef80aULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x0000000810077810ULL, 0x000fe20007ffe0ffULL,
0x0000001006137824ULL, 0x000fca00078e0211ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e2000c101c46ULL, 0x0000000c0b00720cULL, 0x000fc60003f06070ULL,
0x010620000e067984ULL, 0x000ea20000000800ULL, 0x0000001017097810ULL, 0x002fe20007ffe0ffULL,
0x0000000406127824ULL, 0x004fcc00078e020fULL, 0x0000000012127984ULL, 0x000e640000000800ULL,
0x0000000412077c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0014ULL,
0x00000015060a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc16067812ULL, 0x000fe200078ee20dULL,
0x0000000409167824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e0607ULL,
0x0000001010077810ULL, 0x000fe20007ffe0ffULL, 0x0000001006137824ULL, 0x000fca00078e0211ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a137faeULL, 0x0003e2000c101c46ULL,
0x0000000c0900720cULL, 0x000fc60003f06070ULL, 0x010640000e067984ULL, 0x000ea20000000800ULL,
0x00000018170b7810ULL, 0x002fe20007ffe0ffULL, 0x0000000406127824ULL, 0x004fcc00078e020fULL,
0x0000000012127984ULL, 0x000e640000000800ULL, 0x0000000412077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0014ULL, 0x0000001506087210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc16067812ULL, 0x000fe200078ee20dULL, 0x000000040b167824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x0000001810077810ULL, 0x000fe20007ffe0ffULL,
0x0000001006137824ULL, 0x000fca00078e0211ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e2000c101c46ULL, 0x0000000c0b00720cULL, 0x000fc60003f06070ULL,
0x010660000e067984ULL, 0x000ea20000000800ULL, 0x0000002017097810ULL, 0x002fe20007ffe0ffULL,
0x0000000406127824ULL, 0x004fcc00078e020fULL, 0x0000000012127984ULL, 0x000e640000000800ULL,
0x0000000412077c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0014ULL,
0x00000015060a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc16067812ULL, 0x000fe200078ee20dULL,
0x0000000409167824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e0607ULL,
0x0000002010077810ULL, 0x000fe20007ffe0ffULL, 0x0000001006137824ULL, 0x000fca00078e0211ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a137faeULL, 0x0003e2000c101c46ULL,
0x0000000c0900720cULL, 0x000fc60003f06070ULL, 0x010680000e067984ULL, 0x000ea20000000800ULL,
0x00000028170b7810ULL, 0x002fe20007ffe0ffULL, 0x0000000406127824ULL, 0x004fcc00078e020fULL,
0x0000000012127984ULL, 0x000e640000000800ULL, 0x0000000412077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0014ULL, 0x0000001506087210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc16067812ULL, 0x000fe200078ee20dULL, 0x000000040b167824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x0000002810077810ULL, 0x000fe20007ffe0ffULL,
0x0000001006137824ULL, 0x000fca00078e0211ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e2000c101c46ULL, 0x0000000c0b00720cULL, 0x000fc60003f06070ULL,
0x0106a0000e067984ULL, 0x000ea20000000800ULL, 0x0000003017097810ULL, 0x002fe20007ffe0ffULL,
0x0000000406127824ULL, 0x004fcc00078e020fULL, 0x0000000012127984ULL, 0x000e640000000800ULL,
0x0000000412077c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0014ULL,
0x00000015060a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc16067812ULL, 0x000fe200078ee20dULL,
0x0000000409167824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e0607ULL,
0x0000003010077810ULL, 0x000fe20007ffe0ffULL, 0x0000001006137824ULL, 0x000fca00078e0211ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a137faeULL, 0x0003e2000c101c46ULL,
0x0000000c0900720cULL, 0x000fc60003f06070ULL, 0x0106c0000e067984ULL, 0x000ea40000000800ULL,
0x0000000406127824ULL, 0x004fcc00078e020fULL, 0x0000000012127984ULL, 0x000ea40000000800ULL,
0x0000000412077c24ULL, 0x004fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0014ULL,
0x0000001506087210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc16067812ULL, 0x000fc600078ee20dULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x0000003810077810ULL, 0x000fe20007ffe0ffULL,
0x00000010060b7824ULL, 0x002fca00078e0211ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e8000c101c46ULL, 0x0106e0000e0e7984ULL, 0x000ea40000000800ULL,
0x000000040e0a7824ULL, 0x004fe200078e020fULL, 0x00000038170f7810ULL, 0x000fc80007ffe0ffULL,
0x0000000c0f00720cULL, 0x040fe20003f06070ULL, 0x000000000a0a7984ULL, 0x000ea20000000800ULL,
0x000000040f0c7824ULL, 0x000fca00078e00ffULL, 0xfffffffc0c087812ULL, 0x002fca00078ee20dULL,
0x0000001008117824ULL, 0x000fe400078e0211ULL, 0x000000040a077c24ULL, 0x004fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0014ULL, 0x0000001506067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006117faeULL, 0x0003e2000c101c46ULL, 0x0000088000007947ULL, 0x000fea0003800000ULL,
0x0000000000097919ULL, 0x004e620000000000ULL, 0x00010a8061117811ULL, 0x040fe200078e20ffULL,
0x00000100ff157424ULL, 0x000fe200078e00ffULL, 0x0000200061197811ULL, 0x000fe400078e68ffULL,
0x00000002ff0d7819ULL, 0x002fe20000011609ULL, 0x00000010090b7824ULL, 0x040fe200078e00ffULL,
0x0000000909087211ULL, 0x000fc600078fe8ffULL, 0x000000040d0f7824ULL, 0x000fe200078e0266ULL,
0x000000300b177812ULL, 0x000fe200078ec0ffULL, 0x0000004003137824ULL, 0x000fe200078e020dULL,
0x00000003080e7812ULL, 0x000fe400078ec0ffULL, 0x010600000f067984ULL, 0x000e640000000800ULL,
0x00000004060a7824ULL, 0x002fcc00078e0211ULL, 0x000000000a0a7984ULL, 0x000e640000000800ULL,
0x000000040a067c24ULL, 0x002fe2000f8e0213ULL, 0x000000080d0a7810ULL, 0x000fc60007ffe0ffULL,
0x00005e0006067625ULL, 0x000fc800078e0015ULL, 0x000000040a0b7824ULL, 0x000fe200078e00ffULL,
0x0000001706087210ULL, 0x000fe40007f1e0ffULL, 0x0ffffffc0e067812ULL, 0x000fc600078ef809ULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x0000000813077810ULL, 0x000fe20007ffe0ffULL,
0x00000010061b7824ULL, 0x000fca00078e0219ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000081b7faeULL, 0x0003e8000b901c46ULL, 0x010620000f067984ULL, 0x000ea20000000800ULL,
0x000000100d087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe400078e00ffULL,
0x00000004060c7824ULL, 0x004fcc00078e0211ULL, 0x000000000c0c7984ULL, 0x000e640000000800ULL,
0x000000040c067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x00000017060a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc0b067812ULL, 0x000fc600078ee20eULL,
0x000000ffff0b7224ULL, 0x000fe200000e0607ULL, 0x0000001013077810ULL, 0x000fe20007ffe0ffULL,
0x00000010061b7824ULL, 0x000fca00078e0219ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a1b7faeULL, 0x0003e8000b901c46ULL, 0x010640000f067984ULL, 0x000ea20000000800ULL,
0x000000180d0a7810ULL, 0x002fca0007ffe0ffULL, 0x000000040a0b7824ULL, 0x000fe400078e00ffULL,
0x00000004060c7824ULL, 0x004fcc00078e0211ULL, 0x000000000c0c7984ULL, 0x000e640000000800ULL,
0x000000040c067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x0000001706087210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc09067812ULL, 0x000fc600078ee20eULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x0000001813077810ULL, 0x000fe20007ffe0ffULL,
0x00000010061b7824ULL, 0x000fca00078e0219ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000081b7faeULL, 0x0003e8000b901c46ULL, 0x010660000f067984ULL, 0x000ea20000000800ULL,
0x000000200d087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe400078e00ffULL,
0x00000004060c7824ULL, 0x004fcc00078e0211ULL, 0x000000000c0c7984ULL, 0x000e640000000800ULL,
0x000000040c067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x00000017060a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc0b067812ULL, 0x000fc600078ee20eULL,
0x000000ffff0b7224ULL, 0x000fe200000e0607ULL, 0x0000002013077810ULL, 0x000fe20007ffe0ffULL,
0x00000010061b7824ULL, 0x000fca00078e0219ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a1b7faeULL, 0x0003e8000b901c46ULL, 0x010680000f067984ULL, 0x000ea20000000800ULL,
0x000000280d0a7810ULL, 0x002fca0007ffe0ffULL, 0x000000040a0b7824ULL, 0x000fe400078e00ffULL,
0x00000004060c7824ULL, 0x004fcc00078e0211ULL, 0x000000000c0c7984ULL, 0x000e640000000800ULL,
0x000000040c067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x0000001706087210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc09067812ULL, 0x000fc600078ee20eULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x0000002813077810ULL, 0x000fe20007ffe0ffULL,
0x00000010061b7824ULL, 0x000fca00078e0219ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000081b7faeULL, 0x0003e8000b901c46ULL, 0x0106a0000f067984ULL, 0x000ea20000000800ULL,
0x000000300d087810ULL, 0x042fe40007ffe0ffULL, 0x000000380d0d7810ULL, 0x000fc60007ffe0ffULL,
0x0000000408097824ULL, 0x000fe400078e00ffULL, 0x000000040d0d7824ULL, 0x000fe400078e00ffULL,
0x00000004060c7824ULL, 0x004fcc00078e0211ULL, 0x000000000c0c7984ULL, 0x000e640000000800ULL,
0x000000040c067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x00000017060a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc0b067812ULL, 0x000fc600078ee20eULL,
0x000000ffff0b7224ULL, 0x000fe200000e0607ULL, 0x0000003013077810ULL, 0x040fe20007ffe0ffULL,
0x00000010061b7824ULL, 0x000fe200078e0219ULL, 0x0000003813137810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a1b7faeULL, 0x0003e8000b901c46ULL,
0x0106c0000f067984ULL, 0x000ea40000000800ULL, 0x00000004060c7824ULL, 0x004fcc00078e0211ULL,
0x000000000c0c7984ULL, 0x000ea40000000800ULL, 0x000000040c067c24ULL, 0x004fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0015ULL, 0x0000001706087210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc09067812ULL, 0x100fe400078ee20eULL, 0xfffffffc0d0e7812ULL, 0x000fe200078ee20eULL,
0x000000ffff097224ULL, 0x000fe400000e0607ULL, 0x00000010060b7824ULL, 0x102fe400078e0219ULL,
0x000000100e197824ULL, 0x000fc600078e0219ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e8000b901c46ULL, 0x0106e0000f067984ULL, 0x000ea40000000800ULL,
0x00000004060a7824ULL, 0x004fcc00078e0211ULL, 0x000000000a0a7984ULL, 0x000ea40000000800ULL,
0x000000040a067c24ULL, 0x004fc8000f8e0213ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x0000001706067210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006197faeULL, 0x0003e6000b901c46ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x002fc40000015200ULL, 0x010ad400ff087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008060b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000000b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x010ad400ff087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000e640000000000ULL,
0x0000002061057824ULL, 0x002fca00078e0206ULL, 0x00000003ff067819ULL, 0x000fe40000011605ULL,
0x0000000f05057812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe06067812ULL, 0x000fe400078ec0ffULL,
0x0000000105077810ULL, 0x040fe20007ffe0ffULL, 0x00000020050a7824ULL, 0x040fe400078e00ffULL,
0x0000000105087824ULL, 0x040fe400078e0206ULL, 0x0000000106097824ULL, 0x040fe200078e0207ULL,
0x0000001006067810ULL, 0x000fe20007ffe0ffULL, 0x00000020050b7824ULL, 0x000fe200078e00ffULL,
0x0000001f08087812ULL, 0x000fc400078ec0ffULL, 0x0000001f09097812ULL, 0x000fe400078ec0ffULL,
0x000001e00b087812ULL, 0x000fe400078ee208ULL, 0x000001e00a097812ULL, 0x000fe200078ee209ULL,
0x00000001050a7824ULL, 0x100fe400078e0206ULL, 0x0000000008107984ULL, 0x000e62000000cc00ULL,
0x0000000107067824ULL, 0x000fe400078e0206ULL, 0x0000002005077824ULL, 0x040fe200078e00ffULL,
0x00000000090c7984ULL, 0x000ea2000000cc00ULL, 0x0000002005057824ULL, 0x000fe200078e00ffULL,
0x0000001f06067812ULL, 0x000fc400078ec0ffULL, 0x0000001f0a0a7812ULL, 0x000fe400078ec0ffULL,
0x000001e005067812ULL, 0x000fe400078ee206ULL, 0x000001e0070a7812ULL, 0x000fe200078ee20aULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fc400078e000eULL,
0x000000ffff1a7224ULL, 0x000fe400078e000dULL, 0x000000ffff1b7224ULL, 0x000fe200078e000fULL,
0x0000001408007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff187224ULL, 0x000fe400078e0011ULL,
0x000000ffff197224ULL, 0x000fca00078e0013ULL, 0x0000001809007388ULL, 0x000fe8000000cc00ULL,
0x00000000060c7984ULL, 0x000e68000000cc00ULL, 0x000000000a107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000eULL, 0x000000ffff1e7224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1c7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000001c0a007388ULL, 0x0003e8000000cc00ULL,
0x0000000c06007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010ad000ff067f8cULL, 0x002e62000c80043fULL, 0x000000ffff0b7224ULL, 0x000fc400078e00ffULL,
0x000000ffff0a7224ULL, 0x002fc400078e0007ULL, 0x0000000000067805ULL, 0x000fca0000015200ULL,
0x010ad400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000806087210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc80000011409ULL, 0x0000000805057211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e0609ULL, 0x0000000205057819ULL, 0x000fc80000001208ULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x010ad400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5d00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0x00005800ff087624ULL, 0x000fe200078e00ffULL, 0x3d80000004047820ULL, 0x010fe20000410000ULL,
0x00010b5861647811ULL, 0x000fe200078e18ffULL, 0x000000ffff5c7224ULL, 0x000fe200078e00ffULL,
0xffffffff5d657810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00010ad861627811ULL, 0x000fe200078e28ffULL, 0x000000ffff077224ULL, 0x000fe400078e0061ULL,
0x0000004008087824ULL, 0x000fc400078e00ffULL, 0x000001005c6e7824ULL, 0x000fe200078e0267ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000006e5f00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x00cfea0003800000ULL, 0x00000004ff727424ULL, 0x000fe200078e00ffULL,
0x0000005c5b00720cULL, 0x000fe20003f44070ULL, 0x000000ffff6d7224ULL, 0x000fc600078e00ffULL,
0x0000000172727807ULL, 0x000fc40005000000ULL, 0x000000ffff747224ULL, 0x000fe200078e0006ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000000ffff6f7224ULL, 0x000fe200078e006dULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x000000ffff737224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x000000237f007947ULL, 0x020fea000b800000ULL,
0x0001de6000187802ULL, 0x000fc40000000f00ULL, 0x00005c2000007944ULL, 0x002fea0003c00000ULL,
0x0000000173787810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000006d78197211ULL, 0x040fe200078ff0ffULL, 0x0000116000007945ULL, 0x000fe20003800000ULL,
0x0000000378467812ULL, 0x000fe400078ec0ffULL, 0x00000003191d7812ULL, 0x000fe400078ec0ffULL,
0x00000002ff19a819ULL, 0x000fe40000011619ULL, 0x000000ff1d1d7207ULL, 0x000fc60005000000ULL,
0x00000001191c7824ULL, 0x000fca00078e025cULL, 0x000000011c067810ULL, 0x000fc80007ffe0ffULL,
0x0000005d0600720cULL, 0x000fe40003f06070ULL, 0x0000000174067812ULL, 0x000fd600078e0cffULL,
0x000008c000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x102fe20000011605ULL,
0x00000004461a7824ULL, 0x000fe200078e00ffULL, 0x00010a80611f7811ULL, 0x040fe200078e20ffULL,
0x0000000261437824ULL, 0x000fe200078e0206ULL, 0x0000000505427211ULL, 0x000fe200078fe8ffULL,
0x000000041e407824ULL, 0x000fe200078e0266ULL, 0xfffffffc1a417812ULL, 0x000fe200078ee205ULL,
0x0000004003477824ULL, 0x000fe200078e021eULL, 0x0000000342427812ULL, 0x000fe200078ec0ffULL,
0x00000100ff447424ULL, 0x000fe200078e00ffULL, 0x0106000040187984ULL, 0x000e620000000800ULL,
0x0000200043437811ULL, 0x000fc400078e60ffULL, 0x0ffffffc421a7812ULL, 0x000fe400078ef805ULL,
0x00000008474a7810ULL, 0x000fc60007ffe0ffULL, 0x000000101a497824ULL, 0x000fe400078e0243ULL,
0x0000000418197824ULL, 0x002fe400078e021fULL, 0x000001001c187824ULL, 0x000fc800078e0267ULL,
0x0000000019197984ULL, 0x000e620000000800ULL, 0x000000185f457217ULL, 0x000fca0007800000ULL,
0x0000000145457824ULL, 0x000fca00078e0a18ULL, 0x000000451e00720cULL, 0x000fe20003f06070ULL,
0x00000019081b7224ULL, 0x002fc800078e0247ULL, 0x00005e001b187625ULL, 0x000fcc00078e0044ULL,
0x0000001041187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018497faeULL, 0x0003e8000c101c46ULL, 0x01062000401a7984ULL, 0x000ea40000000800ULL,
0x000000041a487824ULL, 0x004fe200078e021fULL, 0x000000081e1a7810ULL, 0x000fc80007ffe0ffULL,
0x00000000481b7984ULL, 0x000ea20000000800ULL, 0x000000041a4b7824ULL, 0x040fe200078e00ffULL,
0x000000451a00720cULL, 0x000fe20003f06070ULL, 0x0000001b081b7224ULL, 0x004fc600078e024aULL,
0xfffffffc4b4a7812ULL, 0x000fe200078ee242ULL, 0x00005e001b1a7625ULL, 0x000fc800078e0044ULL,
0x000000104a497824ULL, 0x002fe200078e0243ULL, 0x00000010474a7810ULL, 0x000fe20007ffe0ffULL,
0x00000010411a7825ULL, 0x000fca00078e001aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a497faeULL, 0x0003e8000c101c46ULL, 0x0106400040187984ULL, 0x000ea40000000800ULL,
0x0000000418487824ULL, 0x004fe200078e021fULL, 0x000000101e187810ULL, 0x000fc80007ffe0ffULL,
0x0000000048197984ULL, 0x000ea20000000800ULL, 0x00000004184b7824ULL, 0x040fe200078e00ffULL,
0x000000451800720cULL, 0x000fe20003f06070ULL, 0x0000001908197224ULL, 0x004fc600078e024aULL,
0xfffffffc4b4a7812ULL, 0x000fe200078ee242ULL, 0x00005e0019187625ULL, 0x000fc800078e0044ULL,
0x000000104a497824ULL, 0x002fe200078e0243ULL, 0x00000018474a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001041187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018497faeULL, 0x0003e8000c101c46ULL, 0x01066000401a7984ULL, 0x000ea40000000800ULL,
0x000000041a487824ULL, 0x004fe200078e021fULL, 0x000000181e1a7810ULL, 0x000fc80007ffe0ffULL,
0x00000000481b7984ULL, 0x000ea20000000800ULL, 0x000000041a4b7824ULL, 0x040fe200078e00ffULL,
0x000000451a00720cULL, 0x000fe20003f06070ULL, 0x0000001b081b7224ULL, 0x004fc600078e024aULL,
0xfffffffc4b4a7812ULL, 0x000fe200078ee242ULL, 0x00005e001b1a7625ULL, 0x000fc800078e0044ULL,
0x000000104a497824ULL, 0x002fe200078e0243ULL, 0x00000020474a7810ULL, 0x000fe20007ffe0ffULL,
0x00000010411a7825ULL, 0x000fca00078e001aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a497faeULL, 0x0003e8000c101c46ULL, 0x0106800040187984ULL, 0x000ea40000000800ULL,
0x0000000418487824ULL, 0x004fe200078e021fULL, 0x000000201e187810ULL, 0x000fc80007ffe0ffULL,
0x0000000048197984ULL, 0x000ea20000000800ULL, 0x00000004184b7824ULL, 0x040fe200078e00ffULL,
0x000000451800720cULL, 0x000fe20003f06070ULL, 0x0000001908197224ULL, 0x004fc600078e024aULL,
0xfffffffc4b4a7812ULL, 0x000fe200078ee242ULL, 0x00005e0019187625ULL, 0x000fc800078e0044ULL,
0x000000104a497824ULL, 0x002fe200078e0243ULL, 0x00000028474a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001041187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018497faeULL, 0x0003e8000c101c46ULL, 0x0106a000401a7984ULL, 0x000ea40000000800ULL,
0x000000041a487824ULL, 0x004fe200078e021fULL, 0x000000281e1a7810ULL, 0x000fc80007ffe0ffULL,
0x00000000481b7984ULL, 0x000ea20000000800ULL, 0x000000041a4b7824ULL, 0x040fe200078e00ffULL,
0x000000451a00720cULL, 0x000fe20003f06070ULL, 0x0000001b081b7224ULL, 0x004fc600078e024aULL,
0xfffffffc4b4a7812ULL, 0x000fe200078ee242ULL, 0x00005e001b1a7625ULL, 0x000fc800078e0044ULL,
0x000000104a497824ULL, 0x002fe200078e0243ULL, 0x00000030474a7810ULL, 0x000fe20007ffe0ffULL,
0x00000010411a7825ULL, 0x000fe200078e001aULL, 0x0000003847477810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a497faeULL, 0x0003e8000c101c46ULL,
0x0106c00040187984ULL, 0x000ea40000000800ULL, 0x0000000418487824ULL, 0x004fe200078e021fULL,
0x000000301e187810ULL, 0x040fe40007ffe0ffULL, 0x000000381e1e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000048197984ULL, 0x000ea20000000800ULL, 0x00000004184b7824ULL, 0x040fe200078e00ffULL,
0x000000451800720cULL, 0x000fe20003f06070ULL, 0x000000041e497824ULL, 0x002fc400078e00ffULL,
0x0000001908197224ULL, 0x004fe200078e024aULL, 0xfffffffc4b4a7812ULL, 0x100fe400078ee242ULL,
0xfffffffc49427812ULL, 0x000fe200078ee242ULL, 0x00005e0019187625ULL, 0x000fc800078e0044ULL,
0x000000104a1b7824ULL, 0x000fe400078e0243ULL, 0x0000001041187825ULL, 0x000fc800078e0018ULL,
0x0000001042437824ULL, 0x000fe200078e0243ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181b7faeULL, 0x0003e2000c101c46ULL, 0x000000451e00720cULL, 0x000fc60003f06070ULL,
0x0106e00040407984ULL, 0x000ea40000000800ULL, 0x00000004401f7824ULL, 0x004fcc00078e021fULL,
0x000000001f1f7984ULL, 0x000ea40000000800ULL, 0x0000001f08477224ULL, 0x004fc800078e0247ULL,
0x00005e0047447625ULL, 0x000fcc00078e0044ULL, 0x0000001041447825ULL, 0x000fca00078e0044ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000044437faeULL, 0x0003e2000c101c46ULL,
0x0000080000007947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x102fe20000011605ULL,
0x0000000446487824ULL, 0x000fe200078e00ffULL, 0x00010a8061447811ULL, 0x040fe200078e20ffULL,
0x0000000261427824ULL, 0x000fe200078e0206ULL, 0x0000000505407211ULL, 0x000fe200078fe8ffULL,
0x000000041e457824ULL, 0x000fe200078e0266ULL, 0xfffffffc481f7812ULL, 0x000fe200078ee205ULL,
0x0000004003437824ULL, 0x000fe200078e021eULL, 0x0000000340407812ULL, 0x000fe200078ec0ffULL,
0x00000100ff417424ULL, 0x000fe200078e00ffULL, 0x0106000045197984ULL, 0x000e620000000800ULL,
0x0000200042427811ULL, 0x000fc400078e60ffULL, 0x0ffffffc401b7812ULL, 0x000fca00078ef805ULL,
0x000000101b497824ULL, 0x000fe400078e0242ULL, 0x00000004191a7824ULL, 0x002fcc00078e0244ULL,
0x000000001a1a7984ULL, 0x000e640000000800ULL, 0x0000001a08187224ULL, 0x002fe200078e0243ULL,
0x00000008431a7810ULL, 0x000fc60007ffe0ffULL, 0x00005e0018187625ULL, 0x000fcc00078e0041ULL,
0x000000101f187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018497faeULL, 0x0003e8000b901c46ULL, 0x01062000451b7984ULL, 0x000ea20000000800ULL,
0x0000001043187810ULL, 0x002fe20007ffe0ffULL, 0x000000041b477824ULL, 0x004fe200078e0244ULL,
0x000000081e1b7810ULL, 0x000fca0007ffe0ffULL, 0x0000000047477984ULL, 0x000e620000000800ULL,
0x000000041b4b7824ULL, 0x000fca00078e00ffULL, 0xfffffffc4b4b7812ULL, 0x000fca00078ee240ULL,
0x000000104b4b7824ULL, 0x000fe400078e0242ULL, 0x00000047081a7224ULL, 0x002fc800078e021aULL,
0x00005e001a1a7625ULL, 0x000fcc00078e0041ULL, 0x000000101f1a7825ULL, 0x000fca00078e001aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a4b7faeULL, 0x0003e8000b901c46ULL,
0x0106400045197984ULL, 0x000ea20000000800ULL, 0x00000018431a7810ULL, 0x002fe20007ffe0ffULL,
0x0000000419477824ULL, 0x004fe200078e0244ULL, 0x000000101e197810ULL, 0x000fca0007ffe0ffULL,
0x0000000047477984ULL, 0x000e620000000800ULL, 0x0000000419497824ULL, 0x000fca00078e00ffULL,
0xfffffffc49497812ULL, 0x000fca00078ee240ULL, 0x0000001049497824ULL, 0x000fe400078e0242ULL,
0x0000004708187224ULL, 0x002fc800078e0218ULL, 0x00005e0018187625ULL, 0x000fcc00078e0041ULL,
0x000000101f187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018497faeULL, 0x0003e8000b901c46ULL, 0x01066000451b7984ULL, 0x000ea20000000800ULL,
0x0000002043187810ULL, 0x002fe20007ffe0ffULL, 0x000000041b477824ULL, 0x004fe200078e0244ULL,
0x000000181e1b7810ULL, 0x000fca0007ffe0ffULL, 0x0000000047477984ULL, 0x000e620000000800ULL,
0x000000041b4b7824ULL, 0x000fca00078e00ffULL, 0xfffffffc4b4b7812ULL, 0x000fca00078ee240ULL,
0x000000104b4b7824ULL, 0x000fe400078e0242ULL, 0x00000047081a7224ULL, 0x002fc800078e021aULL,
0x00005e001a1a7625ULL, 0x000fcc00078e0041ULL, 0x000000101f1a7825ULL, 0x000fca00078e001aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a4b7faeULL, 0x0003e8000b901c46ULL,
0x0106800045197984ULL, 0x000ea20000000800ULL, 0x00000028431a7810ULL, 0x002fe20007ffe0ffULL,
0x0000000419477824ULL, 0x004fe200078e0244ULL, 0x000000201e197810ULL, 0x000fca0007ffe0ffULL,
0x0000000047477984ULL, 0x000e620000000800ULL, 0x0000000419497824ULL, 0x000fca00078e00ffULL,
0xfffffffc49497812ULL, 0x000fca00078ee240ULL, 0x0000001049497824ULL, 0x000fe400078e0242ULL,
0x0000004708187224ULL, 0x002fc800078e0218ULL, 0x00005e0018187625ULL, 0x000fcc00078e0041ULL,
0x000000101f187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018497faeULL, 0x0003e8000b901c46ULL, 0x0106a000451b7984ULL, 0x000ea20000000800ULL,
0x0000003043187810ULL, 0x002fe20007ffe0ffULL, 0x000000041b477824ULL, 0x004fe200078e0244ULL,
0x000000281e1b7810ULL, 0x000fca0007ffe0ffULL, 0x0000000047477984ULL, 0x000e620000000800ULL,
0x000000041b4b7824ULL, 0x000fca00078e00ffULL, 0xfffffffc4b4b7812ULL, 0x000fca00078ee240ULL,
0x000000104b4b7824ULL, 0x000fe400078e0242ULL, 0x00000047081a7224ULL, 0x002fc800078e021aULL,
0x00005e001a1a7625ULL, 0x000fcc00078e0041ULL, 0x000000101f1a7825ULL, 0x000fca00078e001aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a4b7faeULL, 0x0003e8000b901c46ULL,
0x0106c00045197984ULL, 0x000ea20000000800ULL, 0x00000038431a7810ULL, 0x002fe20007ffe0ffULL,
0x0000000419477824ULL, 0x004fe200078e0244ULL, 0x000000301e197810ULL, 0x040fe40007ffe0ffULL,
0x000000381e1e7810ULL, 0x000fc60007ffe0ffULL, 0x0000000047477984ULL, 0x000e620000000800ULL,
0x0000000419497824ULL, 0x000fe400078e00ffULL, 0x000000041e437824ULL, 0x000fc600078e00ffULL,
0xfffffffc49497812ULL, 0x000fca00078ee240ULL, 0x0000001049497824ULL, 0x000fe400078e0242ULL,
0x0000004708187224ULL, 0x002fc800078e0218ULL, 0x00005e0018187625ULL, 0x000fcc00078e0041ULL,
0x000000101f187825ULL, 0x000fca00078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018497faeULL, 0x0003e8000b901c46ULL, 0x0106e00045457984ULL, 0x000ea40000000800ULL,
0x0000000445447824ULL, 0x004fca00078e0244ULL, 0x00000000441b7984ULL, 0x000ea40000000800ULL,
0x0000001b081a7224ULL, 0x004fc800078e021aULL, 0x00005e001a1a7625ULL, 0x000fe200078e0041ULL,
0xfffffffc43417812ULL, 0x000fca00078ee240ULL, 0x0000001041417824ULL, 0x000fe400078e0242ULL,
0x000000101f1a7825ULL, 0x000fca00078e001aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a417faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000237f007947ULL, 0x000fea000b800000ULL, 0x0001f03000187802ULL, 0x002fc40000000f00ULL,
0x00004a5000007944ULL, 0x000fea0003c00000ULL, 0x000000034600780cULL, 0x000fe20003f05270ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000030000007945ULL, 0x000fec0003800000ULL,
0x000002e000000947ULL, 0x000fea0003800000ULL, 0x000000011d187810ULL, 0x002fe20007ffe0ffULL,
0x00000004ff1b7424ULL, 0x000fe200078e00ffULL, 0x0000001c5b00720cULL, 0x000fe20003f04070ULL,
0x0000025000017945ULL, 0x000fe20003800000ULL, 0x00000002ff197819ULL, 0x000fe20000011618ULL,
0x0000000405417824ULL, 0x000fe200078e0266ULL, 0x0000000318187812ULL, 0x000fc400078ec0ffULL,
0x0000000119197807ULL, 0x000fe40004000000ULL, 0x00000020051f7810ULL, 0x000fe40007ffe0ffULL,
0x000000031d00780cULL, 0x000fe20003f85270ULL, 0x000000011c1a7824ULL, 0x000fe200078e0219ULL,
0x000000ff18197207ULL, 0x000fe40004000000ULL, 0x0000001c5b00720cULL, 0x000fe20003f04070ULL,
0x000001001a1a7824ULL, 0x000fe400078e0267ULL, 0x0000000160197824ULL, 0x000fc400078e0219ULL,
0x000000011a187824ULL, 0x100fe400078e0205ULL, 0x000000011f1c7824ULL, 0x100fe400078e021aULL,
0x00006800191a7a24ULL, 0x000fe200078e021aULL, 0x0000005f1800720cULL, 0x080fe40003f26070ULL,
0x0000005f1c00720cULL, 0x000fe20003f66070ULL, 0x000000011a187824ULL, 0x000fe400078e0205ULL,
0x000000011f1a7824ULL, 0x000fc400078e021aULL, 0x0000660018187625ULL, 0x000fc800078e001bULL,
0x000066001a1a7625ULL, 0x000fe200078e001bULL, 0x000000f000008947ULL, 0x000fea0002000000ULL,
0x000000030500780cULL, 0x000fe40003f04070ULL, 0x0000000407077810ULL, 0x000fd60007ffe0ffULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x00000004001c7824ULL, 0x100fe200078e0205ULL,
0x0000005e0700720cULL, 0x000fe20003f06070ULL, 0x00000004611e7824ULL, 0x000fe400078e0205ULL,
0x000000021c1c7824ULL, 0x000fe400078e00ffULL, 0x00000004ff1d7424ULL, 0x000fe200078e00ffULL,
0x00010a801e1f7811ULL, 0x000fe200078e10ffULL, 0x000064001c1c7a24ULL, 0x000fc800078e0207ULL,
0x000060001c1c7625ULL, 0x000fca00078e001dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c1f7faeULL, 0x0003e4000c121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1060000018417faeULL, 0x0005e8000c921846ULL,
0x106800001a417faeULL, 0x0005e4000d921846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff767224ULL, 0x000fc600078e00ffULL,
0xfffffff805187812ULL, 0x026fe200078ec0ffULL, 0x00000002614e7824ULL, 0x000fe200078e0274ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000001764a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000718187812ULL, 0x000fc400078ef805ULL, 0x000020004e4e7811ULL, 0x000fe400078e60ffULL,
0x00000001ff197819ULL, 0x000fe20000011618ULL, 0x00000004181b7824ULL, 0x040fe200078e00ffULL,
0x00000007051c7812ULL, 0x000fe200078ec0ffULL, 0x00000004181e7824ULL, 0x000fe400078e00ffULL,
0x00000001191a7824ULL, 0x040fe200078e0276ULL, 0x000000081c4d7812ULL, 0x000fe200078ef805ULL,
0x0000000119197824ULL, 0x000fc600078e024aULL, 0xfffffffc1b1b7812ULL, 0x000fe200078ee21aULL,
0x00000004731a7824ULL, 0x000fe200078e0276ULL, 0xfffffffc1e1d7812ULL, 0x000fe200078ee219ULL,
0x000000204d1c7824ULL, 0x000fe400078e00ffULL, 0x000000101b1b7824ULL, 0x100fe400078e024eULL,
0x000000021a187824ULL, 0x000fe200078e00ffULL, 0x00000020051a7810ULL, 0x000fe20007ffe0ffULL,
0x000000101d447824ULL, 0x000fe200078e024eULL, 0x000000001b40783bULL, 0x0002a40000000200ULL,
0x0000001805197211ULL, 0x000fc400078fe0ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ec0ffULL,
0x000000004444783bULL, 0x000ee20000000200ULL, 0x0000000218487810ULL, 0x000fe20007ffe0ffULL,
0x000000014d197824ULL, 0x000fe200078e0219ULL, 0x000000071a4f7812ULL, 0x000fc800078ef805ULL,
0xffffffe01c197812ULL, 0x000fe200078ee219ULL, 0x000000044f497824ULL, 0x040fe200078e00ffULL,
0x00000001ff1b7819ULL, 0x002fe2000001164fULL, 0x000000044f4f7824ULL, 0x000fe400078e00ffULL,
0x0000001019197824ULL, 0x000fe400078e00ffULL, 0x000000011b1a7824ULL, 0x040fe200078e0276ULL,
0x0000000276767810ULL, 0x000fe20007ffe0ffULL, 0x000000011b707824ULL, 0x000fe200078e024aULL,
0x00000000191c783bULL, 0x0003240000000200ULL, 0xfffffffc49497812ULL, 0x000fc400078ee21aULL,
0x00000048051a7211ULL, 0x000fe400078fe0ffULL, 0x000000047600780cULL, 0x000fe20003f05270ULL,
0x0000001049497824ULL, 0x000fe400078e024eULL, 0x000000014d4b7824ULL, 0x000fe200078e021aULL,
0x00000018ff187819ULL, 0x004fe40000011643ULL, 0x0000ffff434c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff48723eULL, 0x000fc400020006ffULL, 0x00000010ff187819ULL, 0x000fe40000011643ULL,
0x000000ff43437812ULL, 0x000fe200078ec0ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x000000ff181a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff187819ULL, 0x000fe2000001164cULL,
0x000000204d4c7824ULL, 0x000fe200078e00ffULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x00000018ff18723eULL, 0x000fc400020006ffULL, 0x0000001aff1a723eULL, 0x000fe200020006ffULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0xffffffe04c4b7812ULL, 0x000fe200078ee24bULL,
0x20000018ff187230ULL, 0x000fe20000004100ULL, 0x0000ffff47777812ULL, 0x008fe200078ec0ffULL,
0x2000001aff1a7230ULL, 0x000fe20000004100ULL, 0x00000010ff437819ULL, 0x000fe20000011643ULL,
0x000000104b197824ULL, 0x002fe200078e00ffULL, 0x00000010ff187819ULL, 0x000fe40000011618ULL,
0x00000010ff4d7819ULL, 0x000fc40000011648ULL, 0x00001054184c7816ULL, 0x000fe20000000043ULL,
0x000000004948783bULL, 0x000fe20000000200ULL, 0x00000010ff437819ULL, 0x100fe40000011647ULL,
0x00000010ff1a7819ULL, 0x000fe4000001161aULL, 0x000000ff43757812ULL, 0x000fe400078ec0ffULL,
0x00000018ff717819ULL, 0x000fe40000011647ULL, 0x00000008ff437819ULL, 0x000fc40000011677ULL,
0x000010544d4d7816ULL, 0x000fe4000000001aULL, 0x000000ff47477812ULL, 0x000fe200078ec0ffULL,
0x000000001918783bULL, 0x000e620000000200ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe200020006ffULL, 0x0000004c1c14723cULL, 0x010b620000041814ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000047ff47723eULL, 0x000fc400020006ffULL, 0x00000018ff797819ULL, 0x000fe20000011641ULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x000000ff41837812ULL, 0x000fe200078ec0ffULL,
0x20000043ff4c7230ULL, 0x020fe20000004100ULL, 0xfffffffc4f437812ULL, 0x000fe200078ee270ULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x00000010ff707819ULL, 0x000fe40000011671ULL,
0x00000010ff717819ULL, 0x000fe20000011675ULL, 0x00000010434e7824ULL, 0x000fe200078e024eULL,
0x00000010ff4c7819ULL, 0x000fc4000001164cULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x0000105470717816ULL, 0x000fe40000000071ULL, 0x000010544c707816ULL, 0x000fe40000000047ULL,
0x000000004e4c783bULL, 0x000ea20000000200ULL, 0x00000018ff477819ULL, 0x000fe40000011640ULL,
0x0000ffff417e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7d7819ULL, 0x000fc40000011641ULL,
0x00000010ff7f7819ULL, 0x100fe40000011642ULL, 0x00000018ff827819ULL, 0x000fe40000011642ULL,
0x000000ff427b7812ULL, 0x000fe200078ec0ffULL, 0x000000701814723cULL, 0x002be20000041814ULL,
0x00000018ff937819ULL, 0x000fe40000011644ULL, 0x00000010ff8a7819ULL, 0x100fe40000011648ULL,
0x00000018ff8f7819ULL, 0x000fc40000011648ULL, 0x000000ff45707812ULL, 0x020fe400078ec0ffULL,
0x000000ff488b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff48917812ULL, 0x000fe400078ec0ffULL,
0x00000010ff417819ULL, 0x100fe4000001164aULL, 0x00000018ffa17819ULL, 0x000fe4000001164aULL,
0x000000ff4a7c7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff4a437812ULL, 0x000fe400078ec0ffULL,
0x00000018ff987819ULL, 0x100fe40000011645ULL, 0x00000018ff957819ULL, 0x000fe40000011646ULL,
0x00000047ff9a723eULL, 0x000fe400020006ffULL, 0x00000079ff85723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x2000009aff9a7230ULL, 0x000fe20000004100ULL,
0x00000008ff7e7819ULL, 0x000fe2000001167eULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00000010ff4a7819ULL, 0x000fe20000011645ULL, 0x20000083ff977230ULL, 0x000fe20000004100ULL,
0x00000010ff867819ULL, 0x004fc4000001164dULL, 0x00000018ff477819ULL, 0x000fe4000001164dULL,
0x000000ff4d487812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4d797812ULL, 0x000fe400078ec0ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x000000ff7d7d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff7f7f7812ULL, 0x000fc400078ec0ffULL, 0x000000ff44947812ULL, 0x040fe400078ec0ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x00000093ff4d723eULL, 0x000fe200020006ffULL,
0x20000082ff937230ULL, 0x000fe20000004100ULL, 0x0000ffff449f7812ULL, 0x000fe400078ec0ffULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x2000004dff827230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fc40000011640ULL, 0x00000010ff897819ULL, 0x000fe40000011644ULL,
0x0000ffff45717812ULL, 0x000fe400078ec0ffULL, 0x00000010ff757819ULL, 0x000fe40000011646ULL,
0x00000098ff98723eULL, 0x000fe400020006ffULL, 0x00000095ff95723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fc400020006ffULL, 0x0000ffff40887812ULL, 0x000fe400078ec0ffULL,
0x0000ffff46927812ULL, 0x000fe200078ec0ffULL, 0x2000007eff997230ULL, 0x000fe20000004100ULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff817819ULL, 0x000fc4000001164bULL,
0x00000018ff9e7819ULL, 0x000fe4000001164cULL, 0x00000094ff83723eULL, 0x000fe200020006ffULL,
0x2000007bff947230ULL, 0x000fe20000004100ULL, 0x000000ff49907812ULL, 0x000fe200078ec0ffULL,
0x20000070ff7b7230ULL, 0x000fe20000004100ULL, 0x000000ff4b847812ULL, 0x000fe200078ec0ffULL,
0x20000095ff707230ULL, 0x000fe20000004100ULL, 0x00000008ff9f7819ULL, 0x000fe2000001169fULL,
0x2000007fff957230ULL, 0x000fe20000004100ULL, 0x000000ff7a4d7812ULL, 0x000fe200078ec0ffULL,
0x20000098ff7a7230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x2000007dff987230ULL, 0x000fe20000004100ULL, 0x000000ff89897812ULL, 0x000fe200078ec0ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000008ff717819ULL, 0x000fc40000011671ULL,
0x000000ff75757812ULL, 0x000fe400078ec0ffULL, 0x000000ff40777812ULL, 0x000fe400078ec0ffULL,
0x00000008ff887819ULL, 0x000fe40000011688ULL, 0x00000008ff927819ULL, 0x000fe40000011692ULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x0000ffff42807812ULL, 0x000fc400078ec0ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000081ff7e723eULL, 0x000fe400020006ffULL,
0x0000009eff9e723eULL, 0x000fe400020006ffULL, 0x00000010ff427819ULL, 0x000fe2000001164bULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x0000ffff4b8e7812ULL, 0x000fe400078ec0ffULL,
0x00000090ff7d723eULL, 0x000fe200020006ffULL, 0x2000008bff907230ULL, 0x000fe20000004100ULL,
0x00000084ff7f723eULL, 0x000fc400020006ffULL, 0x0000009fff81723eULL, 0x000fe200020006ffULL,
0x2000007dff8b7230ULL, 0x000fe20000004100ULL, 0x000000ff4e4b7812ULL, 0x000fe200078ec0ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000089ff84723eULL, 0x000fe200020006ffULL,
0x2000007cff897230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x2000004aff7c7230ULL, 0x000fe20000004100ULL, 0x00000075ff9f723eULL, 0x000fe200020006ffULL,
0x2000009eff4a7230ULL, 0x000fe20000004100ULL, 0x000000ff8a8a7812ULL, 0x000fe200078ec0ffULL,
0x20000071ff7d7230ULL, 0x000fe20000004100ULL, 0x00000077ff9b723eULL, 0x000fe200020006ffULL,
0x2000009fff717230ULL, 0x000fe20000004100ULL, 0x0000004dff9c723eULL, 0x000fe200020006ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x2000009bff9b7230ULL, 0x000fe20000004100ULL, 0x00000092ff75723eULL, 0x000fe200020006ffULL,
0x2000009cff9c7230ULL, 0x000fe20000004100ULL, 0x00000010ff8c7819ULL, 0x100fe20000011649ULL,
0x20000088ff9d7230ULL, 0x000fe20000004100ULL, 0x00000018ffa07819ULL, 0x000fe20000011649ULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x0000ffff49407812ULL, 0x000fe200078ec0ffULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x00000047ff92723eULL, 0x000fc400020006ffULL,
0x00000018ff497819ULL, 0x000fe4000001164eULL, 0x00000048ff47723eULL, 0x000fe200020006ffULL,
0x20000092ff487230ULL, 0x000fe20000004100ULL, 0x0000004bff9e723eULL, 0x000fe400020006ffULL,
0x00000008ff917819ULL, 0x000fe40000011691ULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x00000049ff9f723eULL, 0x000fe200020006ffULL, 0x20000047ff497230ULL, 0x000fe20000004100ULL,
0x00000091ff92723eULL, 0x000fe200020006ffULL, 0x2000009eff477230ULL, 0x000fe20000004100ULL,
0x000000ff419e7812ULL, 0x000fe200078ec0ffULL, 0x2000008aff917230ULL, 0x000fe20000004100ULL,
0x00000008ff8a7819ULL, 0x000fe20000011640ULL, 0x20000092ff927230ULL, 0x000fe20000004100ULL,
0x00000010ff9a7819ULL, 0x000fc4000001169aULL, 0x00000010ff407819ULL, 0x000fe4000001169bULL,
0x00000010ff417819ULL, 0x000fe4000001169cULL, 0x00000010ff9d7819ULL, 0x000fe4000001169dULL,
0x000000ff46967812ULL, 0x000fe400078ec0ffULL, 0x00000008ff807819ULL, 0x000fe40000011680ULL,
0x000010549a417816ULL, 0x000fc40000000041ULL, 0x000010549d407816ULL, 0x000fe40000000040ULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000008ff437819ULL, 0x000fe20000011643ULL, 0x20000096ff4d7230ULL, 0x000fe20000004100ULL,
0x000000ff42427812ULL, 0x000fe200078ec0ffULL, 0x000000401c24723cULL, 0x000b620000041824ULL,
0x00000043ff9b723eULL, 0x000fe200020006ffULL, 0x20000080ff967230ULL, 0x000fe20000004100ULL,
0x00000042ff9c723eULL, 0x000fc400020006ffULL, 0x00000010ff437819ULL, 0x000fe40000011698ULL,
0x00000010ff407819ULL, 0x020fe20000011685ULL, 0x2000009cff857230ULL, 0x000fe20000004100ULL,
0x00000010ff427819ULL, 0x000fe20000011697ULL, 0x2000009bff977230ULL, 0x000fe20000004100ULL,
0x00000010ff997819ULL, 0x000fe40000011699ULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x000000ff8c8c7812ULL, 0x000fc400078ec0ffULL, 0x0000105440437816ULL, 0x000fe20000000043ULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000010ff987819ULL, 0x000fe40000011693ULL,
0x0000105499427816ULL, 0x000fe40000000042ULL, 0x00000010ff417819ULL, 0x000fe40000011695ULL,
0x00000010ff407819ULL, 0x000fe40000011694ULL, 0x00000010ff937819ULL, 0x000fe20000011696ULL,
0x000000421c28723cULL, 0x000b620000041828ULL, 0x00000010ff8d7819ULL, 0x000fc4000001164cULL,
0x000000a0ff80723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x0000105498417816ULL, 0x000fe20000000041ULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x0000105493407816ULL, 0x000fe20000000040ULL, 0x2000008aff9a7230ULL, 0x000fe20000004100ULL,
0x000000ff8d937812ULL, 0x000fc400078ec0ffULL, 0x00000010ff947819ULL, 0x000fe4000001168fULL,
0x00000010ff427819ULL, 0x020fe20000011690ULL, 0x000000401c2c723cULL, 0x000b62000004182cULL,
0x00000010ff437819ULL, 0x000fe40000011691ULL, 0x00000010ff8d7819ULL, 0x000fe40000011692ULL,
0x000000a1ff88723eULL, 0x000fe400020006ffULL, 0x0000009eff9e723eULL, 0x000fc400020006ffULL,
0x0000105494437816ULL, 0x000fe20000000043ULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x000010548d427816ULL, 0x000fe20000000042ULL, 0x2000009eff8a7230ULL, 0x000fe20000004100ULL,
0x00000010ff407819ULL, 0x020fe4000001168bULL, 0x00000010ff907819ULL, 0x000fe40000011680ULL,
0x00000010ff417819ULL, 0x000fe2000001168cULL, 0x000000421c30723cULL, 0x000b620000041830ULL,
0x00000010ff8b7819ULL, 0x000fc4000001169aULL, 0x0000105490417816ULL, 0x000fe40000000041ULL,
0x000010548b407816ULL, 0x000fe40000000040ULL, 0x00000008ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff427819ULL, 0x020fe20000011689ULL,
0x000000401c34723cULL, 0x000b620000041834ULL, 0x00000010ff437819ULL, 0x000fc4000001168aULL,
0x00000010ff977819ULL, 0x000fe40000011697ULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x0000105488437816ULL, 0x000fe40000000043ULL, 0x0000105497427816ULL, 0x000fe20000000042ULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x00000010ff407819ULL, 0x020fe40000011683ULL,
0x00000010ff837819ULL, 0x000fc40000011681ULL, 0x00000010ff777819ULL, 0x000fe2000001164eULL,
0x000000421c38723cULL, 0x000b620000041838ULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x0000105483407816ULL, 0x000fe40000000040ULL, 0x00000086ff89723eULL, 0x000fe400020006ffULL,
0x000000ff77837812ULL, 0x000fe400078ec0ffULL, 0x00000010ff867819ULL, 0x000fe20000011682ULL,
0x20000089ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x000fc40000011684ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff427819ULL, 0x020fe4000001167fULL,
0x00000010ff437819ULL, 0x000fe40000011685ULL, 0x00000010ff777819ULL, 0x000fe4000001168eULL,
0x0000105486417816ULL, 0x000fe40000000041ULL, 0x000010547e437816ULL, 0x000fc40000000043ULL,
0x0000105477427816ULL, 0x000fe40000000042ULL, 0x0000ffff4c877812ULL, 0x040fe200078ec0ffULL,
0x000000401824723cULL, 0x000be20000041824ULL, 0x000000ff4c467812ULL, 0x000fe400078ec0ffULL,
0x00000008ff877819ULL, 0x000fe40000011687ULL, 0x00000008ff797819ULL, 0x000fe40000011679ULL,
0x00000010ff7a7819ULL, 0x000fe2000001167aULL, 0x000000421c20723cULL, 0x000b640000041820ULL,
0x00000010ff407819ULL, 0x020fc4000001167bULL, 0x00000010ff417819ULL, 0x000fe4000001167cULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff1c7819ULL, 0x000fe4000001164dULL, 0x00000010ff1d7819ULL, 0x000fe40000011671ULL,
0x00000010ff757819ULL, 0x000fc40000011675ULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x20000046ff4b7230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x20000093ff807230ULL, 0x000fe20000004100ULL, 0x000010547a417816ULL, 0x000fe20000000041ULL,
0x20000087ff827230ULL, 0x000fe20000004100ULL, 0x000010547d407816ULL, 0x000fe20000000040ULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00001054701d7816ULL, 0x000fe2000000001dULL,
0x2000009fff467230ULL, 0x000fe20000004100ULL, 0x00001054751c7816ULL, 0x000fc4000000001cULL,
0x00000010ff4c7819ULL, 0x100fe2000001164fULL, 0x000000401828723cULL, 0x040b620000041828ULL,
0x00000018ff447819ULL, 0x000fe4000001164fULL, 0x000000ff4f457812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e4e7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4f4f7812ULL, 0x000fe200078ec0ffULL,
0x0000001c182c723cULL, 0x000b62000004182cULL, 0x00000008ff4e7819ULL, 0x000fc4000001164eULL,
0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x00000010ff1e7819ULL, 0x000fe4000001164bULL,
0x00000010ff1f7819ULL, 0x000fe40000011680ULL, 0x00000010ff417819ULL, 0x020fc40000011682ULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff1d7819ULL, 0x000fe40000011681ULL,
0x00000010ff1c7819ULL, 0x000fe40000011649ULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x00000045ff45723eULL, 0x000fc400020006ffULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x20000083ff777230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x000010544a1f7816ULL, 0x000fe2000000001fULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x00001054411e7816ULL, 0x000fe2000000001eULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00001054481d7816ULL, 0x000fc4000000001dULL, 0x00001054791c7816ULL, 0x000fe4000000001cULL,
0x00000010ff467819ULL, 0x000fe20000011646ULL, 0x0000001e1830723cULL, 0x040b620000041830ULL,
0x00000010ff417819ULL, 0x000fe4000001164eULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x00000010ff1f7819ULL, 0x020fe20000011677ULL,
0x0000001c1834723cULL, 0x000b620000041834ULL, 0x00000010ff1e7819ULL, 0x000fc40000011647ULL,
0x00001054461f7816ULL, 0x000fe4000000001fULL, 0x00001054411e7816ULL, 0x000fe4000000001eULL,
0x00000010ff1d7819ULL, 0x020fe4000001164cULL, 0x00000010ff1c7819ULL, 0x000fe40000011645ULL,
0x00001054441d7816ULL, 0x000fe2000000001dULL, 0x0000001e1838723cULL, 0x000b620000041838ULL,
0x000010544f1c7816ULL, 0x000fce000000001cULL, 0x0000001c1820723cULL, 0x000b620000041820ULL,
0x0000001000008944ULL, 0x000fe20003c00000ULL, 0xffffe7c000007947ULL, 0x000fcc000383ffffULL,
0x000000047800780cULL, 0x000fe20003f06070ULL, 0x000000ffff737224ULL, 0x000fe400078e0078ULL,
0x000000ffff747224ULL, 0x000fd400078e0006ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd21000007947ULL, 0x000fea000383ffffULL, 0x00000002ff187819ULL, 0x020fc80000011605ULL,
0x0000006d1800720cULL, 0x040fe40003f06070ULL, 0x000000016d6d7810ULL, 0x000fe40007ffe0ffULL,
0x00000008181a7810ULL, 0x040fe40007ffe0ffULL, 0x0000006d1800720cULL, 0x000fe40004706470ULL,
0x0000006f1a00720cULL, 0x000fe40003f26070ULL, 0x0000005c5b00720cULL, 0x000fc40000703070ULL,
0x0000006d1a00720cULL, 0x000fc80000f21070ULL, 0x0000005c5b00720cULL, 0x000fc80000f24470ULL,
0x0000006c236c7208ULL, 0x000fe40000800000ULL, 0x0000006b226b7208ULL, 0x000fe20000800000ULL,
0x000000ffff098224ULL, 0x000fe200078e0021ULL, 0x0000006a3b6a7208ULL, 0x000fe20000800000ULL,
0x000000ffff0a8224ULL, 0x000fe200078e0020ULL, 0x000000693a697208ULL, 0x000fe20000800000ULL,
0x000000ffff0b8224ULL, 0x000fe200078e0039ULL, 0x0000006837687208ULL, 0x000fe20000800000ULL,
0x000000ffff0c8224ULL, 0x000fe200078e0038ULL, 0x0000005136517208ULL, 0x000fe20000800000ULL,
0x000000ffff0d8224ULL, 0x000fe200078e0035ULL, 0x0000005233527208ULL, 0x000fe20000800000ULL,
0x000000ffff0e8224ULL, 0x000fe200078e0034ULL, 0x0000005332537208ULL, 0x000fe20000800000ULL,
0x000000ffff0f8224ULL, 0x000fe200078e0031ULL, 0x0000005417547208ULL, 0x000fe20000800000ULL,
0x000000ffff108224ULL, 0x000fe200078e0030ULL, 0x0000005516557208ULL, 0x000fe20000800000ULL,
0x000000ffff118224ULL, 0x000fe200078e0015ULL, 0x000000562f567208ULL, 0x000fe20000800000ULL,
0x000000ffff128224ULL, 0x000fe200078e0014ULL, 0x000000572e577208ULL, 0x000fe20000800000ULL,
0x000000ffff138224ULL, 0x000fe200078e002dULL, 0x000000582b587208ULL, 0x000fe20000800000ULL,
0x000000ffff3c8224ULL, 0x000fe200078e002cULL, 0x000000592a597208ULL, 0x000fe20000800000ULL,
0x000000ffff3d8224ULL, 0x000fe200078e0029ULL, 0x0000005a275a7208ULL, 0x000fe20000800000ULL,
0x000000ffff3e8224ULL, 0x000fe200078e0028ULL, 0x0000006326637208ULL, 0x000fe20000800000ULL,
0x000000ffff3f8224ULL, 0x000fc400078e0025ULL, 0x000000ffff508224ULL, 0x000fe200078e0024ULL,
0x000000726d00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffce2000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000064147f8cULL, 0x000e62000c80043fULL, 0x0000000450357220ULL, 0x080fe20000410000ULL,
0x000000043f347220ULL, 0x080fe20000410000ULL, 0x000000043e337220ULL, 0x080fe20000410000ULL,
0x000000043d327220ULL, 0x080fe20000410000ULL, 0x000000043c317220ULL, 0x080fe20000410000ULL,
0x0000000413137220ULL, 0x080fe20000410000ULL, 0x0000000412127220ULL, 0x080fe20000410000ULL,
0x0000000411117220ULL, 0x080fe20000410000ULL, 0x0000000410107220ULL, 0x080fe20000410000ULL,
0x000000040f2f7220ULL, 0x080fe20000410000ULL, 0x000000040e2e7220ULL, 0x080fe20000410000ULL,
0x000000040d2b7220ULL, 0x080fe20000410000ULL, 0x000000040c297220ULL, 0x080fe20000410000ULL,
0x000000040b0b7220ULL, 0x080fe20000410000ULL, 0x000000040a0a7220ULL, 0x080fe20000410000ULL,
0x0000000409097220ULL, 0x080fe20000410000ULL, 0x00000004632a7220ULL, 0x080fe20000410000ULL,
0x000000045a287220ULL, 0x080fe20000410000ULL, 0x0000000459277220ULL, 0x080fe20000410000ULL,
0x0000000458267220ULL, 0x080fe20000410000ULL, 0x0000000457257220ULL, 0x080fe20000410000ULL,
0x0000000456247220ULL, 0x080fe20000410000ULL, 0x0000000455237220ULL, 0x080fe20000410000ULL,
0x000000ffff177224ULL, 0x002fe200078e0015ULL, 0x0000000454227220ULL, 0x080fe20000410000ULL,
0x0000000453217220ULL, 0x080fe20000410000ULL, 0x0000000452207220ULL, 0x080fe20000410000ULL,
0x00000004511f7220ULL, 0x080fe20000410000ULL, 0x00000004681e7220ULL, 0x080fe20000410000ULL,
0x00000004691b7220ULL, 0x080fe20000410000ULL, 0x000000046a1c7220ULL, 0x080fe20000410000ULL,
0x000000046b1d7220ULL, 0x080fe20000410000ULL, 0x000000046c197220ULL, 0x000fc20000410000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x00000400640e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fc40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c157210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000150e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400640e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000405177824ULL, 0x000fe200078e00ffULL,
0x000000655c00720cULL, 0x000fc80003f05270ULL, 0xfffffff0172c7812ULL, 0x000fca00078ec0ffULL,
0x00000080612c7824ULL, 0x000fca00078e022cULL, 0x010400002c0c7984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000205147824ULL, 0x000fe400078e00ffULL,
0x000000015f6e7824ULL, 0x000fc600078e0a6eULL, 0x0000000614157812ULL, 0x000fc800078ec0ffULL,
0x00000001152d7812ULL, 0x040fe400078efcffULL, 0x0000000815377812ULL, 0x000fe400078efcffULL,
0x0000006e2d00720cULL, 0x080fe40003f26070ULL, 0x00000010152d7812ULL, 0x000fe400078efcffULL,
0x0000006e3700720cULL, 0x080fe40003f06070ULL, 0x0000006e2d00720cULL, 0x000fc40003fc6070ULL,
0x0000001115377812ULL, 0x040fe400078efcffULL, 0x00000018152d7812ULL, 0x040fe400078efcffULL,
0x0000006e1500720cULL, 0x080fe40003f46070ULL, 0x0000006e3700720cULL, 0x080fe40003fa6070ULL,
0x0000006e2d00720cULL, 0x000fe40003f66070ULL, 0x0000000915397812ULL, 0x000fc400078efcffULL,
0x0000001915377812ULL, 0x040fe400078efcffULL, 0x00000020152d7812ULL, 0x000fe400078efcffULL,
0xff8000002a2a7808ULL, 0x000fe40005000000ULL, 0xff80000035357808ULL, 0x000fe40005000000ULL,
0xff80000028287808ULL, 0x000fe40004800000ULL, 0xff80000034347808ULL, 0x000fc40004800000ULL,
0x0000006e3900720cULL, 0x080fe40003f86070ULL, 0x0000006e3700720cULL, 0x080fe40003f46070ULL,
0x0000006e2d00720cULL, 0x000fe40003f26070ULL, 0x0000002115377812ULL, 0x040fe400078efcffULL,
0x00000028152d7812ULL, 0x000fe400078efcffULL, 0xff80000027277808ULL, 0x000fc40004000000ULL,
0xff80000033337808ULL, 0x000fe40004000000ULL, 0xff80000026267808ULL, 0x000fe40006000000ULL,
0xff80000032327808ULL, 0x000fe40006000000ULL, 0x0000006e3700720cULL, 0x080fe40003f06070ULL,
0x0000006e2d00720cULL, 0x000fe40003f86070ULL, 0x0000002915377812ULL, 0x000fc400078efcffULL,
0x00000030152d7812ULL, 0x000fe400078efcffULL, 0xff80000025257808ULL, 0x000fe40007000000ULL,
0xff80000031317808ULL, 0x000fe40007000000ULL, 0xff80000024247808ULL, 0x000fe40006800000ULL,
0xff80000013137808ULL, 0x000fe40006800000ULL, 0x0000006e3700720cULL, 0x000fc40003fc6070ULL,
0x0000006e2d00720cULL, 0x000fe40003fa6070ULL, 0x0000003115377812ULL, 0x040fe400078efcffULL,
0x00000038152d7812ULL, 0x040fe400078efcffULL, 0x0000003915157812ULL, 0x000fe400078efcffULL,
0xff80000023237808ULL, 0x000fe40005800000ULL, 0xff80000012127808ULL, 0x000fc40005800000ULL,
0xff80000022227808ULL, 0x000fe40005000000ULL, 0xff80000011117808ULL, 0x000fe40005000000ULL,
0xff80000021217808ULL, 0x000fe40004800000ULL, 0xff80000010107808ULL, 0x000fe40004800000ULL,
0x0000006e3700720cULL, 0x080fe40003f66070ULL, 0x0000006e2d00720cULL, 0x000fc40003f46070ULL,
0x0000006e1500720cULL, 0x000fe40003f26070ULL, 0xff80000020207808ULL, 0x000fe40004000000ULL,
0xff8000002f2f7808ULL, 0x000fe40004000000ULL, 0xff8000001f1f7808ULL, 0x000fe40006000000ULL,
0xff8000002e2e7808ULL, 0x000fe40006000000ULL, 0xff8000001e1e7808ULL, 0x000fc40007000000ULL,
0xff8000002b2b7808ULL, 0x000fe40007000000ULL, 0xff8000001b1b7808ULL, 0x000fe40006800000ULL,
0xff80000029297808ULL, 0x000fe40006800000ULL, 0xff8000001c1c7808ULL, 0x000fe40005800000ULL,
0xff8000000b0b7808ULL, 0x000fe40005800000ULL, 0xff8000001d1d7808ULL, 0x000fc40005000000ULL,
0xff8000000a0a7808ULL, 0x000fe40005000000ULL, 0xff80000019197808ULL, 0x000fe40004800000ULL,
0xff80000009097808ULL, 0x000fc40004800000ULL, 0x000000350c00720bULL, 0x004fe20003f1e000ULL,
0x0000001fff3a7424ULL, 0x000fe200078e00ffULL, 0x0000002a0d00720bULL, 0x000fe20003f3e000ULL,
0xffffffffff3b7424ULL, 0x000fe200078e00ffULL, 0x0000000c35157208ULL, 0x000fe40004000000ULL,
0x0000000d2a0d7208ULL, 0x000fc40004800000ULL, 0x000000341500720bULL, 0x000fe40003f1e000ULL,
0x000000280d00720bULL, 0x000fe40003f3e000ULL, 0x00000015340c7208ULL, 0x000fe40004000000ULL,
0x0000000d28147208ULL, 0x000fe40004800000ULL, 0x000000330c00720bULL, 0x000fe40003f1e000ULL,
0x000000271400720bULL, 0x000fc40003f3e000ULL, 0x0000000c330d7208ULL, 0x000fe40004000000ULL,
0x0000001427157208ULL, 0x000fe40004800000ULL, 0x000000320d00720bULL, 0x000fe40003f1e000ULL,
0x000000261500720bULL, 0x000fe40003f3e000ULL, 0x0000000d320c7208ULL, 0x000fe40004000000ULL,
0x0000001526147208ULL, 0x000fc40004800000ULL, 0x000000310c00720bULL, 0x000fe40003f1e000ULL,
0x000000251400720bULL, 0x000fe40003f3e000ULL, 0x0000000c310c7208ULL, 0x000fe40004000000ULL,
0x00000014250d7208ULL, 0x000fe40004800000ULL, 0x000000130c00720bULL, 0x000fe40003f1e000ULL,
0x000000240d00720bULL, 0x000fc40003f3e000ULL, 0x0000000c13157208ULL, 0x000fe40004000000ULL,
0x0000000d240c7208ULL, 0x000fe40004800000ULL, 0x000000121500720bULL, 0x000fe40003f1e000ULL,
0x000000230c00720bULL, 0x000fe40003f3e000ULL, 0x0000001512147208ULL, 0x000fe40004000000ULL,
0x0000000c230d7208ULL, 0x000fc40004800000ULL, 0x000000111400720bULL, 0x000fe40003f1e000ULL,
0x000000220d00720bULL, 0x000fe40003f3e000ULL, 0x0000001411157208ULL, 0x000fe40004000000ULL,
0x0000000d220c7208ULL, 0x000fe40004800000ULL, 0x000000101500720bULL, 0x000fe40003f1e000ULL,
0x000000210c00720bULL, 0x000fc40003f3e000ULL, 0x0000001510147208ULL, 0x000fe40004000000ULL,
0x0000000c210d7208ULL, 0x000fe40004800000ULL, 0x0000002f1400720bULL, 0x000fe40003f1e000ULL,
0x000000200d00720bULL, 0x000fe40003f3e000ULL, 0x000000142f157208ULL, 0x000fe40004000000ULL,
0x0000000d200c7208ULL, 0x000fc40004800000ULL, 0x0000002e1500720bULL, 0x000fe40003f1e000ULL,
0x0000001f0c00720bULL, 0x000fe40003f3e000ULL, 0x000000152e147208ULL, 0x000fe40004000000ULL,
0x0000000c1f0d7208ULL, 0x000fe40004800000ULL, 0x0000002b1400720bULL, 0x000fe40003f1e000ULL,
0x0000001e0d00720bULL, 0x000fc40003f3e000ULL, 0x000000142b147208ULL, 0x000fe40004000000ULL,
0x0000000d1e0c7208ULL, 0x000fe40004800000ULL, 0x000000291400720bULL, 0x000fe40003f1e000ULL,
0x0000001b0c00720bULL, 0x000fe40003f3e000ULL, 0x0000001429147208ULL, 0x000fe40004000000ULL,
0x0000000c1b0d7208ULL, 0x000fc40004800000ULL, 0x0000000b1400720bULL, 0x000fe40003f1e000ULL,
0x0000001c0d00720bULL, 0x000fe40003f3e000ULL, 0x000000140b157208ULL, 0x000fe40004000000ULL,
0x0000000d1c0c7208ULL, 0x000fe40004800000ULL, 0x0000000a1500720bULL, 0x000fe40003f1e000ULL,
0x0000001d0c00720bULL, 0x000fc40003f3e000ULL, 0x000000150a147208ULL, 0x000fe40004000000ULL,
0x0000000c1d0c7208ULL, 0x000fe40004800000ULL, 0x000000091400720bULL, 0x000fe40003f1e000ULL,
0x000000190c00720bULL, 0x000fe40003f3e000ULL, 0x0000001409367208ULL, 0x000fe40004000000ULL,
0x0000000c192d7208ULL, 0x000fe20004800000ULL, 0x000019227f007947ULL, 0x000fec000b800000ULL,
0x0c401f00360c7f89ULL, 0x0004e400000e0000ULL, 0x0000000c3600720bULL, 0x008fc80003f1e000ULL,
0x000000360c387208ULL, 0x000fe20004000000ULL, 0x000019327f007947ULL, 0x000fea000b800000ULL,
0x0c401f002d0c7f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e0d7f89ULL, 0x000f2800000e0000ULL,
0x0c401f000f147f89ULL, 0x000e6800000e0000ULL, 0x0c201f0038157f89ULL, 0x000ea200000e0000ULL,
0x0000000c2d00720bULL, 0x008fc40003f1e000ULL, 0x0000000d0e00720bULL, 0x010fe40003f3e000ULL,
0x0000002d0c0c7208ULL, 0x000fe40004000000ULL, 0x0000000e0d0d7208ULL, 0x000fe40004800000ULL,
0x000000140f00720bULL, 0x002fe20003f1e000ULL, 0x0c201f000c377f89ULL, 0x000e6600000e0000ULL,
0x0000000f142d7208ULL, 0x000fe20004000000ULL, 0x0c201f000d167f89ULL, 0x000ee200000e0000ULL,
0x000000153800720bULL, 0x004fc60003f1e000ULL, 0x0c201f002d307f89ULL, 0x0004a200000e0000ULL,
0x0000003815147208ULL, 0x000fe40004000000ULL, 0x000000370c00720bULL, 0x002fe40003f3e000ULL,
0x000000160d00720bULL, 0x008fe40003f5e000ULL, 0x0000000c37157208ULL, 0x000fe40004800000ULL,
0x0000000d16167208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b14367820ULL, 0x006fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000818387824ULL, 0x000fe200078e00ffULL,
0x0000a00061437811ULL, 0x000fe200078e58ffULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010836ULL, 0x00000031003c7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b2e0e7823ULL, 0x100fe20000010836ULL,
0x00000004ff2e7e24ULL, 0x000fe2000f8e00ffULL, 0x3fb8aa3b2f0f7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010836ULL, 0x0000003500507308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b15317820ULL, 0x002fe20000410000ULL, 0x3f8000002e2e783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b2b0d7823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b290c7823ULL, 0x000fe20000010836ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010831ULL,
0x00000034003f7308ULL, 0x0002a20000000800ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b24567823ULL, 0x100fe20000010831ULL, 0x000000ffff2f7224ULL, 0x000fe200078e002eULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010831ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010831ULL,
0x00000033003e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b20527823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b10107823ULL, 0x000fe20000010836ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010831ULL, 0x0000000818347824ULL, 0x002fe200078e00ffULL,
0x3fb8aa3b1c6a7823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b1d6b7823ULL, 0x100fe20000010831ULL,
0x00000032003d7308ULL, 0x0002e20000000800ULL, 0x000000503f24723eULL, 0x004fe200000010ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e002eULL, 0x3fb8aa3b0b0b7823ULL, 0x000fe20000010836ULL,
0x000000ffff3b7224ULL, 0x000fe200078e002eULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b09097823ULL, 0x000fe20000010836ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010831ULL,
0x0000002a00637308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b19197823ULL, 0x000fe20000010831ULL,
0x0000000818327824ULL, 0x042fe200078e00ffULL, 0x0000000318317810ULL, 0x040fe20007ffe0ffULL,
0x0000000818357824ULL, 0x000fe200078e00ffULL, 0x0000000305ff7812ULL, 0x000fe2000780c0ffULL,
0x000000081a377824ULL, 0x000fe200078e00ffULL, 0x000000302d00720bULL, 0x000fe20003f3e000ULL,
0x00000028005a7308ULL, 0x000fe60000000800ULL, 0xfffffff837427812ULL, 0x000fca00078ee21aULL,
0x0000002700597308ULL, 0x000ff00000000800ULL, 0x0000002600587308ULL, 0x0006700000000800ULL,
0x0000002500577308ULL, 0x0005e20000000800ULL, 0x0000003e3d26723eULL, 0x008fc400000010ffULL,
0x000000595827723eULL, 0x002fca00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x000000635a25723eULL, 0x004fce00000010ffULL, 0x0000002e2428723cULL, 0x000f6200000418ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x0000003c1320723eULL, 0x002fce00000010ffULL,
0x0000001100117308ULL, 0x000e700000000800ULL, 0x0000005600567308ULL, 0x000ff00000000800ULL,
0x0000002300557308ULL, 0x000ff00000000800ULL, 0x0000002200547308ULL, 0x0002b00000000800ULL,
0x0000002100537308ULL, 0x0007e20000000800ULL, 0x000000121122723eULL, 0x002fc400000010ffULL,
0x000000555423723eULL, 0x004fca00000010ffULL, 0x0000001000107308ULL, 0x000fe20000000800ULL,
0x000000575621723eULL, 0x008fce00000010ffULL, 0x0000002e2028723cULL, 0x020b620000041828ULL,
0x0000000f000f7308ULL, 0x000e6c0000000800ULL, 0x00000001182f7810ULL, 0x020fe40007ffe0ffULL,
0x0000000e000e7308ULL, 0x000fe40000000800ULL, 0xfffffff8322f7812ULL, 0x000fc400078ee22fULL,
0x0000000418327810ULL, 0x000fc80007ffe0ffULL, 0x0000000d000d7308ULL, 0x000fe20000000800ULL,
0x000000100f1c723eULL, 0x002fe400000010ffULL, 0xfffffff835367812ULL, 0x000fe400078ee232ULL,
0xffffffff18327810ULL, 0x000fc60007ffe0ffULL, 0x0000005200527308ULL, 0x000e620000000800ULL,
0xfffffff835407812ULL, 0x000fe200078ee232ULL, 0x0000001036377824ULL, 0x000fe200078e0243ULL,
0x0000000c17327812ULL, 0x000fc600078ec0ffULL, 0x0000001040417824ULL, 0x000fe400078e0243ULL,
0x0000001f00517308ULL, 0x0005e20000000800ULL, 0x0000000132377824ULL, 0x040fe400078e0237ULL,
0x0000000132417824ULL, 0x000fca00078e0241ULL, 0x0000001e00687308ULL, 0x0007220000000800ULL,
0x00000002181f7810ULL, 0x004fe40007ffe0ffULL, 0x00000053521d723eULL, 0x002fe400000010ffULL,
0xfffffff834337812ULL, 0x040fe400078ee21fULL, 0xfffffff834347812ULL, 0x000fe200078ee231ULL,
0x0000001b00697308ULL, 0x0003e20000000800ULL, 0x0000000e0d1e723eULL, 0x008fe200000010ffULL,
0x0000001033337824ULL, 0x100fe200078e0243ULL, 0x0000000618317810ULL, 0x000fe20007ffe0ffULL,
0x0000001034357824ULL, 0x000fc400078e0243ULL, 0x0000000132337824ULL, 0x000fe200078e0233ULL,
0x00000051681f723eULL, 0x010fe200000010ffULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x00000005181b7810ULL, 0x002fe20007ffe0ffULL, 0x0000000132357824ULL, 0x000fc600078e0235ULL,
0xfffffff838387812ULL, 0x000fe200078ee21bULL, 0x0000003a1c28723cULL, 0x000b620000041828ULL,
0x00000008181b7824ULL, 0x000fe200078e00ffULL, 0x0000000b000b7308ULL, 0x000e640000000800ULL,
0x0000001038397824ULL, 0x000fe400078e0243ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee218ULL,
0x00000008183a7824ULL, 0x020fe400078e00ffULL, 0x0000000132397824ULL, 0x000fe200078e0239ULL,
0x0000000a000a7308ULL, 0x000fe20000000800ULL, 0x000000101b177824ULL, 0x000fe200078e0243ULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee231ULL, 0x000000102f317824ULL, 0x000fc400078e0243ULL,
0x000000ffff2f7224ULL, 0x000fe400078e002eULL, 0x0000000117177824ULL, 0x000fe200078e0232ULL,
0x0000000900097308ULL, 0x000ea20000000800ULL, 0x0000000c0b18723eULL, 0x002fe200000010ffULL,
0x0000000132317824ULL, 0x000fe400078e0231ULL, 0x000000103a3b7824ULL, 0x100fe200078e0243ULL,
0x0000002417007388ULL, 0x0003e20000000800ULL, 0x0000001042437824ULL, 0x000fe400078e0243ULL,
0x0000006a006a7308ULL, 0x000ee20000000800ULL, 0x00000001323b7824ULL, 0x040fe200078e023bULL,
0x0000002631007388ULL, 0x0007e20000000800ULL, 0x0000000132327824ULL, 0x000fc600078e0243ULL,
0x0000002033007388ULL, 0x0007e20000000800ULL, 0x0000002d30177208ULL, 0x002fe20004800000ULL,
0x0000006b006b7308ULL, 0x000fe20000000800ULL, 0x0000000a091a723eULL, 0x004fe200000010ffULL,
0x0000002235007388ULL, 0x0003e80000000800ULL, 0x0000001c37007388ULL, 0x0003e40000000800ULL,
0x00000019006c7308ULL, 0x0006a40000000800ULL, 0x0000001e39007388ULL, 0x0003e80000000800ULL,
0x000000183b007388ULL, 0x0003e20000000800ULL, 0x000000696a19723eULL, 0x008fc600000010ffULL,
0x0000001a41007388ULL, 0x0003e80000000800ULL, 0x0000002532007388ULL, 0x0003e20000000800ULL,
0x0000006b6c1b723eULL, 0x004fc600000010ffULL, 0x0004002731007388ULL, 0x0003e80000000800ULL,
0x0004002133007388ULL, 0x0003e20000000800ULL, 0x0000002e1828723cULL, 0x000f660000041828ULL,
0x0004002335007388ULL, 0x0003e80000000800ULL, 0x0004001d37007388ULL, 0x0003e80000000800ULL,
0x0004001f39007388ULL, 0x0003e80000000800ULL, 0x000400193b007388ULL, 0x0003e80000000800ULL,
0x0004001b41007388ULL, 0x0003e80000000800ULL, 0x010000142c008388ULL, 0x0003e20000000c00ULL,
0x000000ffff297224ULL, 0x020fca00078e002aULL, 0x010200282c008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000062ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080062ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100062ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000015c5c7810ULL, 0x000fe20007ffe0ffULL,
0x0000180062ff7f8cULL, 0x0003e6000c80043fULL, 0x0000005d5c00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb33000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff217807ULL, 0x008fe40004000000ULL,
0x0002298000207802ULL, 0x000fc40000000f00ULL, 0x000010a000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff177224ULL, 0x000fe200078e0025ULL, 0xfffe0a4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff217807ULL, 0x000fe40004800000ULL, 0x000229d000207802ULL, 0x000fc40000000f00ULL,
0x0000105000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0025ULL,
0xfffe0a8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff277224ULL, 0x000fe200078e0011ULL,
0x00022a3000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fc400078e001cULL,
0x00000fb000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0026ULL,
0xfffe0b2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001cULL,
0x00022a9000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e0011ULL,
0x00000f5000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0026ULL,
0xfffe0c2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001bULL,
0x00022af000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e001cULL,
0x00000ef000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff197224ULL, 0x004fe200078e0026ULL,
0xfffe0df000007947ULL, 0x000fea000383ffffULL, 0x000000ffff277224ULL, 0x002fe200078e001aULL,
0x00022b5000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fc400078e001bULL,
0x00000e9000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xfffe0dc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x00022bb000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0069ULL,
0x00000e3000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff197224ULL, 0x004fe200078e0026ULL,
0xfffe3d2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x00022c1000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e0068ULL,
0x00000dd000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xfffe3ce000007947ULL, 0x000fea000383ffffULL, 0x00000001ff217807ULL, 0x004fe40004000000ULL,
0x00022c6000207802ULL, 0x000fc40000000f00ULL, 0x00000dc000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff177224ULL, 0x000fe200078e0025ULL, 0xfffe704000007947ULL, 0x000fea000383ffffULL,
0x00000001ff217807ULL, 0x000fe40004800000ULL, 0x00022cb000207802ULL, 0x000fc40000000f00ULL,
0x00000d7000007944ULL, 0x008fea0003c00000ULL, 0xfffe709000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x00022d0000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0069ULL, 0x00000ce000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0026ULL, 0xfffe712000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x00022d6000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0068ULL, 0x00000c8000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0026ULL, 0xfffe721000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x00022dc000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0069ULL, 0x00000c2000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff197224ULL, 0x004fe200078e0026ULL, 0xfffe73d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x00022e2000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0068ULL, 0x00000bc000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xfffe739000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x00022e8000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0069ULL, 0x00000b6000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff197224ULL, 0x004fe200078e0026ULL, 0xfffea0f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x00022ee000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0068ULL, 0x00000b0000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xfffea0b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff217807ULL, 0x004fe40004000000ULL, 0x00022f3000207802ULL, 0x000fc40000000f00ULL,
0x00000af000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff177224ULL, 0x000fe200078e0025ULL,
0xfffed2f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff217807ULL, 0x000fe40004800000ULL,
0x00022f8000207802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x008fea0003c00000ULL,
0xfffed34000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x00022fd000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0069ULL,
0x00000a1000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0026ULL,
0xfffed3d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x0002303000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e0068ULL,
0x000009b000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0026ULL,
0xfffed4c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0002309000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0069ULL,
0x0000095000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff197224ULL, 0x004fe200078e0026ULL,
0xfffed68000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x000230f000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e0068ULL,
0x000008f000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xfffed64000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0002315000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0069ULL,
0x0000089000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff197224ULL, 0x004fe200078e0026ULL,
0xffff03a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x000231b000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e0068ULL,
0x0000083000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xffff036000007947ULL, 0x000fea000383ffffULL, 0x00000001ff217807ULL, 0x004fe40004000000ULL,
0x0002320000207802ULL, 0x000fc40000000f00ULL, 0x0000082000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff177224ULL, 0x000fe200078e0025ULL, 0xffff35a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff217807ULL, 0x000fe40004800000ULL, 0x0002325000207802ULL, 0x000fc40000000f00ULL,
0x000007d000007944ULL, 0x008fea0003c00000ULL, 0xffff35f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x000232a000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0069ULL, 0x0000074000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0026ULL, 0xffff368000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x0002330000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0068ULL, 0x000006e000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0026ULL, 0xffff377000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0002336000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0069ULL, 0x0000068000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff197224ULL, 0x004fe200078e0026ULL, 0xffff393000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x000233c000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0068ULL, 0x0000062000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xffff38f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0002342000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0069ULL, 0x000005c000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff197224ULL, 0x004fe200078e0026ULL, 0xffff665000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0002348000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0068ULL, 0x0000056000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xffff661000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0006ULL, 0x000234d000207802ULL, 0x000fc40000000f00ULL,
0x0000051000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e0026ULL,
0xffff820000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0006ULL,
0x0002352000207802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e0026ULL, 0xffff82f000007947ULL, 0x000fea000383ffffULL,
0x00000002ff377424ULL, 0x000fe200078e00ffULL, 0x00023570000c7802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0030ULL,
0xffffe6a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x006fe200078e002dULL,
0x000235d0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff377424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x000fea0003c00000ULL, 0x000000302d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e000eULL, 0x00023630000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff377424ULL, 0x000fe200078e00ffULL, 0x0000002d30157208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x000000300e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e000fULL, 0x00023690000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff377424ULL, 0x000fe200078e00ffULL, 0x0000000e30397208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000300f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e0038ULL, 0x000236f0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff377424ULL, 0x000fe200078e00ffULL, 0x0000000f302d7208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x000000303800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e0015ULL, 0x00023750000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff377424ULL, 0x000fe200078e00ffULL, 0x0000003830147208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x000000301500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e0039ULL, 0x000237b0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff377424ULL, 0x000fe200078e00ffULL, 0x0000001530157208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x000000303900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff367224ULL, 0x002fe200078e002dULL, 0x00023810000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff377424ULL, 0x000fe200078e00ffULL, 0x0000003930167208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffe57000007947ULL, 0x000fea000383ffffULL,
0x018000000e037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000000e00038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff047807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000304ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0eff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000304ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000e047812ULL, 0x000fd600078ec0ffULL,
0x0080000004030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0004ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000e00037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x000fe400078e0006ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffdc66004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000003b00007348ULL, 0x000fe80003800000ULL,
0x0c00003736307389ULL, 0x0002a200000e003aULL, 0xfffdc6200c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff217424ULL, 0x000fe200078e00ffULL, 0x0000001000007348ULL, 0x000fe80003800000ULL,
0x0000002726267389ULL, 0x0002a200000e000fULL, 0xfffdc5e020007950ULL, 0x000fea0003c3ffffULL,
0x000000012100780cULL, 0x000fe20003f25070ULL, 0x0000001600007348ULL, 0x000fd80003800000ULL,
0x0000000000217806ULL, 0x000fc800048e0100ULL, 0x0000001621257212ULL, 0x000fe200078ec0ffULL,
0x00000000ff217424ULL, 0x000fc800078e00ffULL, 0xfffdc58020007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff197424ULL, 0x000fe200078e00ffULL, 0x0000000200007348ULL, 0x000fe80003800000ULL,
0xfffdc55018007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x000000000000060bULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000768ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a08ULL, 0x00000000000003d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000de0ULL, 0x00000000000000e4ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ec4ULL, 0x0000000000000c3cULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001b00ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001b10ULL, 0x00000000000000b0ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001bc0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001bc4ULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001e00ULL, 0x0000000000023b80ULL, 0xa400001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000025980ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000259d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000025d50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001bc0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000023dc0ULL, 0x0000000000023dc0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000025980ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000025d50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_4_kvt_e4m3_pagedKV_64_nqpkv_1_m_1_sm_89_cubin_len = 155184;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
