/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_4_kvt_bf16_pagedKV_128_nqpkv_1_m_1_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000002b040ULL, 0x000000000002acc0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f34314944327961ULL, 0x6f6c66625f766e5fULL,
0x326a4c3236317461ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL,
0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL,
0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL,
0x4974613245453233ULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x45386a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x746e695f5f240067ULL, 0x5f305f6c616e7265ULL,
0x5f616475635f5f24ULL, 0x7063725f30326d73ULL, 0x5f7a74665f6e725fULL, 0x776f6c735f323366ULL,
0x5f5f240068746170ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f315fULL, 0x5f30376d735f6164ULL,
0x636e79736c666873ULL, 0x00705f796c66625fULL, 0x7265746e695f5f24ULL, 0x5f245f325f6c616eULL,
0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x5f7864695f636e79ULL, 0x746e695f5f240070ULL,
0x5f335f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x746f765f30376d73ULL, 0x61625f636e797365ULL,
0x5f5f2400746f6c6cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f345fULL, 0x5f30376d735f6164ULL,
0x636e797370726177ULL, 0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL,
0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL, 0x72656b240061686dULL, 0x2461686d5f6c656eULL,
0x657479426d656d73ULL, 0x2e766e2e00667542ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x61705f0061686d5fULL, 0x6265642e006d6172ULL, 0x656d6172665f6775ULL, 0x65642e6c65722e00ULL,
0x6d6172665f677562ULL, 0x2e616c65722e0065ULL, 0x72665f6775626564ULL, 0x2e766e2e00656d61ULL,
0x697463612e6c6572ULL, 0x0000000000006e6fULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0009000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c0001000000adULL, 0x000000000000002cULL, 0x0000000000000010ULL,
0x000c0001000000ebULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000124ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c00010000016bULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c0001000001b5ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000001fbULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000242ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c000100000288ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000002d6ULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c000100000324ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c00010000036bULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000003b0ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000b0022000003f6ULL, 0x0000000000028ae0ULL, 0x0000000000000190ULL,
0x000b002200000429ULL, 0x0000000000028c70ULL, 0x0000000000000040ULL, 0x000b002200000454ULL,
0x0000000000028cb0ULL, 0x0000000000000040ULL, 0x000b00220000047eULL, 0x0000000000028cf0ULL,
0x0000000000000070ULL, 0x000b0022000004a9ULL, 0x0000000000028d60ULL, 0x0000000000000120ULL,
0x000a000300000510ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000530ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000560ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000028e80ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00028ae000000000ULL, 0x0000040400000000ULL, 0x810c000001680400ULL,
0x00a1440400288080ULL, 0x0000000000000000ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x9208288080830828ULL, 0x2880809a08288080ULL, 0x809d082880809b08ULL, 0x08288080a0082880ULL,
0x8080a408288080a3ULL, 0xa708288080a60828ULL, 0x288080a908288080ULL, 0x80b408288080b308ULL,
0x08288080b7082880ULL, 0x8080bb08288080baULL, 0x8016288080870828ULL, 0x0000000310288082ULL,
0x8087920000000000ULL, 0x0000000022002880ULL, 0x00000044ffffffffULL, 0x0000007000000000ULL,
0x00028ae000000000ULL, 0x0000019000000000ULL, 0x0000480400000000ULL, 0x8082288080830900ULL,
0x0900000010042880ULL, 0x2880808628808082ULL, 0x8087090000000404ULL, 0x0000288080822880ULL,
0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x9208288080830828ULL, 0x2880809a08288080ULL,
0x809d082880809b08ULL, 0x08288080a0082880ULL, 0x8080a608288080a3ULL, 0xb308288080a70828ULL,
0x288080b408288080ULL, 0x80bb08288080b708ULL, 0x1628808086082880ULL, 0x0000031028808280ULL,
0x8692000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000016000000000ULL,
0x00028c7000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000084ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x9208288080830828ULL, 0x2880809a08288080ULL, 0x809d082880809b08ULL,
0x08288080a0082880ULL, 0x8080a608288080a3ULL, 0xb308288080a70828ULL, 0x288080b708288080ULL,
0x80bb08288080ba08ULL, 0x16288080b4082880ULL, 0x0000031028808280ULL, 0xb492000000000000ULL,
0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000021800000000ULL, 0x00028cb000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x9208288080830828ULL, 0x2880809a08288080ULL, 0x809d082880809b08ULL, 0x08288080a0082880ULL,
0x8080a608288080a3ULL, 0xb308288080a70828ULL, 0x288080b408288080ULL, 0x80bb08288080ba08ULL,
0x16288080b7082880ULL, 0x0000031028808280ULL, 0xb792000000000000ULL, 0x0000002200288080ULL,
0x0000002cffffffffULL, 0x000002d000000000ULL, 0x00028cf000000000ULL, 0x0000007000000000ULL,
0x0000180400000000ULL, 0x80b4288080b70900ULL, 0x0000000000002880ULL, 0x00000094ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8708288080830828ULL, 0x2880809208288080ULL, 0x809b082880809a08ULL,
0x082880809d082880ULL, 0x8080a308288080a0ULL, 0xa708288080a60828ULL, 0x288080a908288080ULL,
0x80b408288080b308ULL, 0x08288080b7082880ULL, 0x8080bb08288080baULL, 0x8016288080a40828ULL,
0x0000000310288082ULL, 0x80a4920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL,
0x0000039800000000ULL, 0x00028d6000000000ULL, 0x0000012000000000ULL, 0x0000000000000000ULL,
0x0000001900082f04ULL, 0x00082304000000efULL, 0x0000000000000015ULL, 0x0000001500081204ULL,
0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL,
0x0000000000000011ULL, 0x0000001100081204ULL, 0x0008110400000000ULL, 0x0000000000000011ULL,
0x0000001900082304ULL, 0x0008120400000000ULL, 0x0000000000000019ULL, 0x0000001900081104ULL,
0x0004370400000000ULL, 0x000035010000007bULL, 0x0000001600080a04ULL, 0x0068190300680160ULL,
0x00000000000c1704ULL, 0x0021f00000600007ULL, 0x00000000000c1704ULL, 0x0021f00000580006ULL,
0x00000000000c1704ULL, 0x0011f00000500005ULL, 0x00000000000c1704ULL, 0x0061f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400ff1b03ULL, 0x01ec290400000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01ec2804ffffffffULL,
0x0000013000000100ULL, 0x000045c0000004a0ULL, 0x0000475000004650ULL, 0x00004ae0000048b0ULL,
0x00004b8000004b10ULL, 0x0000712000004bf0ULL, 0x000071b000007140ULL, 0x00009b2000007220ULL,
0x00009ca000009bb0ULL, 0x0000a01000009df0ULL, 0x0000a0a00000a030ULL, 0x0000c3200000a110ULL,
0x0000c3b00000c340ULL, 0x0000eb600000c420ULL, 0x0000ece00000ebf0ULL, 0x0000f0500000ee30ULL,
0x0000f0e00000f070ULL, 0x000113600000f150ULL, 0x000113f000011380ULL, 0x00013ba000011460ULL,
0x00013d2000013c30ULL, 0x0001409000013e70ULL, 0x00014120000140b0ULL, 0x000163a000014190ULL,
0x00016430000163c0ULL, 0x00016ce0000164a0ULL, 0x000174a000016e20ULL, 0x00018df0000174c0ULL,
0x0001947000018e20ULL, 0x00019b50000194b0ULL, 0x0001c3c000019f90ULL, 0x0001c7700001c750ULL,
0x0001ea600001ea40ULL, 0x0001f3d00001f3c0ULL, 0x00021b50000215b0ULL, 0x00023ae000023300ULL,
0x000269f0000254a0ULL, 0x00026a4000026a30ULL, 0x00026a6000026a50ULL, 0x00026ae000026ac0ULL,
0x0002778000026b00ULL, 0x00027860000277e0ULL, 0x00027960000278e0ULL, 0x00027a60000279e0ULL,
0x00027b4000027ae0ULL, 0x00027c1000027ba0ULL, 0x00027d1000027c90ULL, 0x00027e1000027d90ULL,
0x00027ef000027e90ULL, 0x00027fc000027f50ULL, 0x000280c000028040ULL, 0x000281c000028140ULL,
0x000282a000028240ULL, 0x0002837000028300ULL, 0x00028470000283f0ULL, 0x00028570000284f0ULL,
0x00028660000285f0ULL, 0x00028740000286d0ULL, 0x00028840000287c0ULL, 0x00028940000288c0ULL,
0x00028a40000289c0ULL, 0x07b0390400028ac0ULL, 0x000000ff000001f0ULL, 0x003f01000001cad0ULL,
0x0000000f00000260ULL, 0x003f01200001cad8ULL, 0x0000000f00000350ULL, 0x003f01200001cb58ULL,
0x0000000f00000450ULL, 0x003f01200001cb78ULL, 0x000000ff00000480ULL, 0x003f01000001cb88ULL,
0x000000ff00000520ULL, 0x003f01070001cad0ULL, 0x0000006f000007a0ULL, 0x003f01020001cb5cULL,
0x0000006f00000800ULL, 0x003f01010001cb58ULL, 0x000000ff00000960ULL, 0x003f01010001cb88ULL,
0x000000ff000009a0ULL, 0x003f01050001cb8cULL, 0x000000ff00000b60ULL, 0x003f01050001cb8cULL,
0x000000ff00001e30ULL, 0x003f01010001cb88ULL, 0x000000ff00001e60ULL, 0x003f01050001cb8cULL,
0x000000ff00002030ULL, 0x003f01050001cb8cULL, 0x000000ff000021a0ULL, 0x003f01070001cb78ULL,
0x000000ff00002220ULL, 0x003f01010001cb78ULL, 0x000000ff00002280ULL, 0x003f01010001cb88ULL,
0x000000ff00002540ULL, 0x003f01050001cb7cULL, 0x000000ff00002700ULL, 0x003f01050001cb7cULL,
0x000000ff00002760ULL, 0x003f01050001cb8cULL, 0x000000ff00002930ULL, 0x003f01050001cb8cULL,
0x000000ff00003c00ULL, 0x003f01010001cb88ULL, 0x000000ff00003c30ULL, 0x003f01050001cb8cULL,
0x000000ff00003e00ULL, 0x003f01050001cb8cULL, 0x000000ff000041d0ULL, 0x003f01070001cb80ULL,
0x000000ff00004260ULL, 0x003f01010001cb80ULL, 0x0000006f000042e0ULL, 0x003f01010001cad8ULL,
0x0000006f00004310ULL, 0x003f01050001cadcULL, 0x0000006f000044e0ULL, 0x003f01050001cadcULL,
0x000000ff000054c0ULL, 0x003f01010001cb88ULL, 0x000000ff000055a0ULL, 0x003f01050001cb84ULL,
0x000000ff00005760ULL, 0x003f01050001cb84ULL, 0x000000ff000057c0ULL, 0x003f01050001cb8cULL,
0x000000ff00005990ULL, 0x003f01050001cb8cULL, 0x000000ff00006c60ULL, 0x003f01010001cb88ULL,
0x000000ff00006c90ULL, 0x003f01050001cb8cULL, 0x000000ff00006e60ULL, 0x003f01050001cb8cULL,
0x000000ff00007040ULL, 0x003f01070001cb78ULL, 0x000000ff000070c0ULL, 0x003f01010001cb78ULL,
0x000000ff00007910ULL, 0x003f01010001cb88ULL, 0x000000ff000079e0ULL, 0x003f01010001cb58ULL,
0x000000ff00007ad0ULL, 0x003f01050001cb7cULL, 0x000000ff00007c90ULL, 0x003f01050001cb7cULL,
0x000000ff00007cf0ULL, 0x003f01050001cb8cULL, 0x000000ff00007ec0ULL, 0x003f01050001cb8cULL,
0x000000ff00009190ULL, 0x003f01010001cb88ULL, 0x000000ff000091c0ULL, 0x003f01050001cb8cULL,
0x000000ff00009390ULL, 0x003f01050001cb8cULL, 0x000000ff00009730ULL, 0x003f01070001cb80ULL,
0x000000ff000097c0ULL, 0x003f01010001cb80ULL, 0x0000006f00009840ULL, 0x003f01010001caf8ULL,
0x0000006f00009870ULL, 0x003f01050001cafcULL, 0x0000006f00009a40ULL, 0x003f01050001cafcULL,
0x000000ff0000a6b0ULL, 0x003f01010001cb88ULL, 0x000000ff0000a7a0ULL, 0x003f01050001cb84ULL,
0x000000ff0000a960ULL, 0x003f01050001cb84ULL, 0x000000ff0000a9c0ULL, 0x003f01050001cb8cULL,
0x000000ff0000ab90ULL, 0x003f01050001cb8cULL, 0x000000ff0000be60ULL, 0x003f01010001cb88ULL,
0x000000ff0000be90ULL, 0x003f01050001cb8cULL, 0x000000ff0000c060ULL, 0x003f01050001cb8cULL,
0x000000ff0000c240ULL, 0x003f01070001cb78ULL, 0x000000ff0000c2c0ULL, 0x003f01010001cb78ULL,
0x000000ff0000c970ULL, 0x003f01010001cb88ULL, 0x000000ff0000ca20ULL, 0x003f01010001cb60ULL,
0x000000ff0000cb10ULL, 0x003f01050001cb7cULL, 0x000000ff0000ccd0ULL, 0x003f01050001cb7cULL,
0x000000ff0000cd30ULL, 0x003f01050001cb8cULL, 0x000000ff0000cf00ULL, 0x003f01050001cb8cULL,
0x000000ff0000e1d0ULL, 0x003f01010001cb88ULL, 0x000000ff0000e200ULL, 0x003f01050001cb8cULL,
0x000000ff0000e3d0ULL, 0x003f01050001cb8cULL, 0x000000ff0000e770ULL, 0x003f01070001cb80ULL,
0x000000ff0000e800ULL, 0x003f01010001cb80ULL, 0x0000006f0000e880ULL, 0x003f01010001cb18ULL,
0x0000006f0000e8b0ULL, 0x003f01050001cb1cULL, 0x0000006f0000ea80ULL, 0x003f01050001cb1cULL,
0x000000ff0000f6f0ULL, 0x003f01010001cb88ULL, 0x000000ff0000f7e0ULL, 0x003f01050001cb84ULL,
0x000000ff0000f9a0ULL, 0x003f01050001cb84ULL, 0x000000ff0000fa00ULL, 0x003f01050001cb8cULL,
0x000000ff0000fbd0ULL, 0x003f01050001cb8cULL, 0x000000ff00010ea0ULL, 0x003f01010001cb88ULL,
0x000000ff00010ed0ULL, 0x003f01050001cb8cULL, 0x000000ff000110a0ULL, 0x003f01050001cb8cULL,
0x000000ff00011280ULL, 0x003f01070001cb78ULL, 0x000000ff00011300ULL, 0x003f01010001cb78ULL,
0x000000ff000119b0ULL, 0x003f01010001cb88ULL, 0x000000ff00011a60ULL, 0x003f01010001cb68ULL,
0x000000ff00011b50ULL, 0x003f01050001cb7cULL, 0x000000ff00011d10ULL, 0x003f01050001cb7cULL,
0x000000ff00011d70ULL, 0x003f01050001cb8cULL, 0x000000ff00011f40ULL, 0x003f01050001cb8cULL,
0x000000ff00013210ULL, 0x003f01010001cb88ULL, 0x000000ff00013240ULL, 0x003f01050001cb8cULL,
0x000000ff00013410ULL, 0x003f01050001cb8cULL, 0x000000ff000137b0ULL, 0x003f01070001cb80ULL,
0x000000ff00013840ULL, 0x003f01010001cb80ULL, 0x0000006f000138c0ULL, 0x003f01010001cb38ULL,
0x0000006f000138f0ULL, 0x003f01050001cb3cULL, 0x0000006f00013ac0ULL, 0x003f01050001cb3cULL,
0x000000ff00014730ULL, 0x003f01010001cb88ULL, 0x000000ff00014820ULL, 0x003f01050001cb84ULL,
0x000000ff000149e0ULL, 0x003f01050001cb84ULL, 0x000000ff00014a40ULL, 0x003f01050001cb8cULL,
0x000000ff00014c10ULL, 0x003f01050001cb8cULL, 0x000000ff00015ee0ULL, 0x003f01010001cb88ULL,
0x000000ff00015f10ULL, 0x003f01050001cb8cULL, 0x000000ff000160e0ULL, 0x003f01050001cb8cULL,
0x000000ff000162c0ULL, 0x003f01070001cb78ULL, 0x000000ff00016340ULL, 0x003f01010001cb78ULL,
0x000000ff000169f0ULL, 0x003f01010001cb88ULL, 0x000000ff00016a90ULL, 0x003f01010001cb70ULL,
0x000000ff00019de0ULL, 0x003f01010001cad0ULL, 0x000000ff0001c3f0ULL, 0x003f01050001cad4ULL,
0x000000ff0001c5c0ULL, 0x003f01050001cad4ULL, 0x0000008500025be0ULL, 0x003f010100000000ULL,
0x0000008500025f50ULL, 0x003f010500000004ULL, 0x0000008500026120ULL, 0x003f010500000004ULL,
0x00000076000275d0ULL, 0x003f01010001cad8ULL, 0x0000007600027630ULL, 0x003f01010001cae0ULL,
0x0000007600027690ULL, 0x003f01010001cae8ULL, 0x0000007600027700ULL, 0x003f01010001caf0ULL,
0x00101c0400053803ULL, 0x0001c62000019c80ULL, 0x000277400001c6c0ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000044cULL, 0x0000001900000002ULL, 0x0000000000000374ULL,
0x0000001900000002ULL, 0x00000000000002bcULL, 0x0000001900000002ULL, 0x0000000000000204ULL,
0x0000001900000002ULL, 0x0000000000000124ULL, 0x0000001900000002ULL, 0x0000000000000044ULL,
0x0000001900000002ULL, 0x0000000000000425ULL, 0x0000001900000002ULL, 0x000000000000034eULL,
0x0000001900000002ULL, 0x0000000000000296ULL, 0x0000001900000002ULL, 0x00000000000001deULL,
0x0000001900000002ULL, 0x00000000000000fdULL, 0x0000001900000002ULL, 0x000000000001cc00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000f7919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x0000460000067ab9ULL, 0x000fe20000000a00ULL,
0x0000580000097a02ULL, 0x000fe20000000f00ULL, 0x00000000000e7919ULL, 0x000ea20000002300ULL,
0x0000001200057300ULL, 0x000ee200000e0000ULL, 0x00000000000479c3ULL, 0x000f220000002500ULL,
0x00000004ff157424ULL, 0x000fe200078e00ffULL, 0x0000000000037919ULL, 0x000ea20000002200ULL,
0x0000000409097824ULL, 0x000fc600078e00ffULL, 0x0000000000137919ULL, 0x000ee20000000000ULL,
0x0000001200127309ULL, 0x000ea60000000000ULL, 0x0000000000067919ULL, 0x000ee80000000000ULL,
0x00000000006c7919ULL, 0x000ee20000002600ULL, 0x00000005ff757819ULL, 0x002fcc000001160fULL,
0x00001fff75757589ULL, 0x000fe200000e0000ULL, 0x00000004ff777e24ULL, 0x010fe4000f8e00ffULL,
0x000001000e007a24ULL, 0x004fe400078e0203ULL, 0x00001fff0e0e7589ULL, 0x000e6400000e0000ULL,
0x00000000000f7a24ULL, 0x000fe400078e020fULL, 0x0000000000007919ULL, 0x000ea20000002700ULL,
0x000000060500720cULL, 0x008fc40003f02070ULL, 0x000000ff0f00720cULL, 0x040fe40003f25270ULL,
0x0000000f0f00780cULL, 0x040fe40003f44070ULL, 0x0000007f0f00780cULL, 0x040fe40003f84070ULL,
0x000000030f00780cULL, 0x000fce0003f64070ULL, 0x3fffff80ff029424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff039424ULL, 0x000fe400078e00ffULL, 0x000000040e047824ULL, 0x002fe400078e0275ULL,
0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL, 0x01cad002ff009388ULL, 0x0003e20000000a00ULL,
0x0000000204087824ULL, 0x000fe200078e00ffULL, 0x3fffff600006b802ULL, 0x000fe20000000f00ULL,
0x3fffffc0ff04a424ULL, 0x000fe200078e00ffULL, 0x0000000200737819ULL, 0x004fe200000006ffULL,
0x00000001080a7824ULL, 0x000fc400078e0213ULL, 0x00000020080b7824ULL, 0x040fe200078e00ffULL,
0x01cad8040f00a388ULL, 0x0005e20000008a00ULL, 0x0000000009097224ULL, 0x000fe200078e026cULL,
0x0000000408037817ULL, 0x042fe20007800000ULL, 0xff317217ff0cc424ULL, 0x000fe200078e00ffULL,
0xffffffe00b107812ULL, 0x000fe200078ee20aULL, 0x7fffff60ff07b424ULL, 0x000fe200078e00ffULL,
0x00000001080a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a08ULL,
0x000000010f00780cULL, 0x000fe20003f44070ULL, 0x0000580008027a24ULL, 0x100fe200078e0209ULL,
0x00000200000b7802ULL, 0x000fe20000000f00ULL, 0x01c4000c0f00c388ULL, 0x000fe20000004800ULL,
0x0000001013047824ULL, 0x004fe200078e00ffULL, 0x000000010300780cULL, 0x040fe20003f83070ULL,
0x000058000a057a24ULL, 0x040fe200078e0209ULL, 0x01cb58060f00b388ULL, 0x0003e20000008a00ULL,
0x000000010a087824ULL, 0x040fe200078e0213ULL, 0x000000ff0300720cULL, 0x000fe20003f63070ULL,
0x000000200a117824ULL, 0x000fe200078e00ffULL, 0x000001f004097812ULL, 0x000fe200078ec0ffULL,
0x00005c0002027625ULL, 0x000fe200078e000bULL, 0x3fffff00000aa802ULL, 0x000fc40000000f00ULL,
0xffffffe011117812ULL, 0x000fe200078ee208ULL, 0x00005c0005047625ULL, 0x000fe200078e000bULL,
0x0000000902067210ULL, 0x002fc60007fbe0ffULL, 0x7fffff00ff0ba424ULL, 0x000fe200078e00ffULL,
0x0000000904087210ULL, 0x000fe20007fde0ffULL, 0x3fffff80ff0c9424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0d9424ULL, 0x000fe200078e00ffULL, 0x00000005ff097210ULL, 0x000fe200037fe4ffULL,
0x000000ffff027224ULL, 0x000fe200078e0a12ULL, 0x01cb780a0f00a388ULL, 0x000fe20000008a00ULL,
0x000000ffff077224ULL, 0x000fe400028e0603ULL, 0x0000001010057824ULL, 0x000fe200078e00ffULL,
0x01cb880cff009388ULL, 0x000fe20000000a00ULL, 0x0000001011117824ULL, 0x000fc600078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e2000d901c46ULL,
0x0000620073027625ULL, 0x000fc600078e0015ULL, 0x0000000008117faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01cad40affff038cULL, 0x0005e20000000200ULL,
0x00006a0073047625ULL, 0x002fc600078e0015ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01cad000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x0000000602717981ULL, 0x000ee8000c1e1900ULL,
0x0000000604047981ULL, 0x000f22000c1e1900ULL, 0x000000ff0e00720cULL, 0x000fe40003f05270ULL,
0x0000007f71727810ULL, 0x048fe40007ffe0ffULL, 0x000000ff71707810ULL, 0x000fc40007ffe0ffULL,
0x00000008ff6e7819ULL, 0x010fe40000011604ULL, 0x00000007ff727819ULL, 0x000fe40000011672ULL,
0x00000008ff707819ULL, 0x000fc60000011670ULL, 0x0001965000008947ULL, 0x000fea0003800000ULL,
0x0000002075057824ULL, 0x040fe200078e0213ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x00000008756f7824ULL, 0x000fe200078e00ffULL, 0x0000000300087802ULL, 0x004fe20000000f00ULL,
0x00000002776d7824ULL, 0x000fe200078e00ffULL, 0x0000001f0500780cULL, 0x000fe20003f04070ULL,
0x0000010077047824ULL, 0x000fe200078e00ffULL, 0x000000030500780cULL, 0x000fd60003f24070ULL,
0x0000007000000947ULL, 0x000fea0003800000ULL, 0x0000000104067824ULL, 0x000fe200078e0205ULL,
0x0001ca0005077811ULL, 0x000fe200078e10ffULL, 0x0000680073027a24ULL, 0x000fc600078e0204ULL,
0x000000710600720cULL, 0x000fe20003f06070ULL, 0x0000000105027824ULL, 0x000fc800078e0202ULL,
0x0000660002027625ULL, 0x000fd000078e0015ULL, 0x0000000002077faeULL, 0x0003e4000c121846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb5c086fff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb58006fff7f8cULL, 0x0007e2000c80043fULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000500027211ULL, 0x002fe400078e10ffULL,
0x000064006d037a10ULL, 0x040fe40007ffe0ffULL, 0x000000726d00720cULL, 0x000fe20003f06070ULL,
0x0000000202027824ULL, 0x000fe200078e00ffULL, 0x0001cac005057811ULL, 0x000fc600078e10ffULL,
0x0000640002027a24ULL, 0x000fc800078e0203ULL, 0x0000600002027625ULL, 0x000fca00078e0015ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e4000c121846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb8800ff027f8cULL, 0x002e62000c80043fULL, 0x000000ffff097224ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x006fc400078e0003ULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x01cb8c00ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804808ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000602067210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e03ULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc80000011407ULL, 0x0000000605057211ULL, 0x000fc800078110ffULL,
0x00000007ff067210ULL, 0x000fc800007fe4ffULL, 0x0000000205057819ULL, 0x000fc80000001206ULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000109097810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01cb8c00ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804808ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000177037810ULL, 0x000fe20007ffe0ffULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x000000806c6c7824ULL, 0x000fe200078e00ffULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x000000700300720cULL, 0x000fda0003f06070ULL,
0x0000099000008947ULL, 0x000fea0003800000ULL, 0x000000046f087824ULL, 0x000fe200078e00ffULL,
0x00000000000e7919ULL, 0x000e620000000000ULL, 0x0000000471037217ULL, 0x000fe20007800000ULL,
0x000000016f067824ULL, 0x040fe200078e026cULL, 0x000000016f0b7810ULL, 0x040fe20007ffe0ffULL,
0x01ca000008027984ULL, 0x000ea20000000800ULL, 0x00000200ff0d7424ULL, 0x000fe400078e00ffULL,
0x000000206f0a7824ULL, 0x000fe400078e00ffULL, 0x0000000402077824ULL, 0x004fe200078e00ffULL,
0x0000000304027210ULL, 0x000fc80007ffe1ffULL, 0x01cac00007057984ULL, 0x0002a20000000800ULL,
0x000000026f027217ULL, 0x040fe40007800000ULL, 0x0000000e6f077210ULL, 0x002fe20007ffe0ffULL,
0x0000000405037c24ULL, 0x004fe4000f8e0206ULL, 0x000000100e067824ULL, 0x000fe400078e00ffULL,
0x0000000102057824ULL, 0x000fe400078e0a6fULL, 0x00005e0003027625ULL, 0x000fe200078e000dULL,
0x000001f0060f7812ULL, 0x000fc400078ec0ffULL, 0x000000ff0500720cULL, 0x000fe40003f03070ULL,
0x0000000f02067210ULL, 0x000fe40007f3e0ffULL, 0xffffffe00a027812ULL, 0x000fe200078ee207ULL,
0x000000010b0a7824ULL, 0x040fe400078e020eULL, 0x000000ffff077224ULL, 0x000fe200008e0603ULL,
0x0001400002097811ULL, 0x000fe200078e20ffULL, 0x000000016c037824ULL, 0x000fe200078e020bULL,
0x000000050b0b7819ULL, 0x000fc600000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c46ULL, 0x000000010500780cULL, 0x000fe40003f03070ULL,
0xffffffe00b0a7812ULL, 0x000fe200078ee20aULL, 0x01ca040008027984ULL, 0x000ea20000000800ULL,
0x000000026f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000140000a097811ULL, 0x002fc600078e20ffULL,
0x000000010b0a7824ULL, 0x000fe400078e020eULL, 0x00000004020c7824ULL, 0x004fca00078e00ffULL,
0x01cac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402027c24ULL, 0x002fc8000f8e0203ULL,
0x00005e0002027625ULL, 0x000fca00078e000dULL, 0x0000000f02067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe400008e0603ULL, 0x000000016c037824ULL, 0x000fe200078e020bULL,
0x000000050b0b7819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c46ULL, 0x000000020500780cULL, 0x000fe40003f03070ULL,
0xffffffe00b0a7812ULL, 0x000fe200078ee20aULL, 0x01ca080008027984ULL, 0x000ea20000000800ULL,
0x000000036f0b7810ULL, 0x000fc40007ffe0ffULL, 0x000140000a097811ULL, 0x002fc600078e20ffULL,
0x000000010b0a7824ULL, 0x000fe400078e020eULL, 0x00000004020c7824ULL, 0x004fca00078e00ffULL,
0x01cac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402027c24ULL, 0x002fc8000f8e0203ULL,
0x00005e0002027625ULL, 0x000fca00078e000dULL, 0x0000000f02067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe400008e0603ULL, 0x000000016c037824ULL, 0x000fe200078e020bULL,
0x000000050b0b7819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c46ULL, 0x000000030500780cULL, 0x000fe40003f03070ULL,
0xffffffe00b0a7812ULL, 0x000fe200078ee20aULL, 0x01ca0c0008027984ULL, 0x000ea20000000800ULL,
0x000000046f0b7810ULL, 0x000fc40007ffe0ffULL, 0x000140000a097811ULL, 0x002fc600078e20ffULL,
0x000000010b0a7824ULL, 0x000fe400078e020eULL, 0x00000004020c7824ULL, 0x004fca00078e00ffULL,
0x01cac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402027c24ULL, 0x002fc8000f8e0203ULL,
0x00005e0002027625ULL, 0x000fca00078e000dULL, 0x0000000f02067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe400008e0603ULL, 0x000000016c037824ULL, 0x000fe200078e020bULL,
0x000000050b0b7819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c46ULL, 0x000000040500780cULL, 0x000fe40003f03070ULL,
0xffffffe00b0a7812ULL, 0x000fe200078ee20aULL, 0x01ca100008027984ULL, 0x000ea20000000800ULL,
0x000000056f0b7810ULL, 0x000fc40007ffe0ffULL, 0x000140000a097811ULL, 0x002fc600078e20ffULL,
0x000000010b0a7824ULL, 0x000fe400078e020eULL, 0x00000004020c7824ULL, 0x004fca00078e00ffULL,
0x01cac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402027c24ULL, 0x002fc8000f8e0203ULL,
0x00005e0002027625ULL, 0x000fca00078e000dULL, 0x0000000f02067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe400008e0603ULL, 0x000000016c037824ULL, 0x000fe200078e020bULL,
0x000000050b0b7819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c46ULL, 0x000000050500780cULL, 0x000fe40003f03070ULL,
0xffffffe00b0a7812ULL, 0x000fe200078ee20aULL, 0x01ca140008027984ULL, 0x000ea20000000800ULL,
0x000000066f0b7810ULL, 0x000fc40007ffe0ffULL, 0x000140000a097811ULL, 0x002fc600078e20ffULL,
0x000000010b0a7824ULL, 0x000fe400078e020eULL, 0x00000004020c7824ULL, 0x004fca00078e00ffULL,
0x01cac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402027c24ULL, 0x002fc8000f8e0203ULL,
0x00005e0002027625ULL, 0x000fca00078e000dULL, 0x0000000f02067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe400008e0603ULL, 0x000000016c037824ULL, 0x000fe200078e020bULL,
0x000000050b0b7819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c46ULL, 0x000000060500780cULL, 0x000fe40003f03070ULL,
0xffffffe00b0a7812ULL, 0x000fe200078ee20aULL, 0x01ca180008027984ULL, 0x000ea20000000800ULL,
0x000000076f0b7810ULL, 0x000fc40007ffe0ffULL, 0x000140000a097811ULL, 0x002fc600078e20ffULL,
0x000000010b0a7824ULL, 0x000fe400078e020eULL, 0x00000004020c7824ULL, 0x004fca00078e00ffULL,
0x01cac0000c027984ULL, 0x000e640000000800ULL, 0x0000000402027c24ULL, 0x002fc8000f8e0203ULL,
0x00005e0002027625ULL, 0x000fca00078e000dULL, 0x0000000f02067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe400008e0603ULL, 0x000000016c037824ULL, 0x000fe200078e020bULL,
0x000000050b0b7819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c46ULL, 0x000000070500780cULL, 0x000fe40003f03070ULL,
0xffffffe00b0a7812ULL, 0x000fe200078ee20aULL, 0x01ca1c0008087984ULL, 0x000ea60000000800ULL,
0x000140000a057811ULL, 0x000fe200078e20ffULL, 0x00000004080c7824ULL, 0x004fca00078e00ffULL,
0x01cac0000c027984ULL, 0x000ea40000000800ULL, 0x0000000402027c24ULL, 0x004fc8000f8e0203ULL,
0x00005e0002027625ULL, 0x000fca00078e000dULL, 0x0000000f02027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c101c46ULL, 0x0000084000007947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000e620000000000ULL, 0x00000200ff107424ULL, 0x000fe200078e00ffULL,
0x0000006f0e057211ULL, 0x042fe200078fd8ffULL, 0x000000100e027824ULL, 0x000fc600078e00ffULL,
0x0000000e05077210ULL, 0x040fe20007ffe0ffULL, 0x01ca000005087984ULL, 0x000e620000004800ULL,
0x000000016c037824ULL, 0x000fe200078e0205ULL, 0x000001f0020d7812ULL, 0x000fe200078ec0ffULL,
0x00000020050a7824ULL, 0x040fe200078e00ffULL, 0x0000000105097810ULL, 0x000fca0007ffe0ffULL,
0x00000001090c7824ULL, 0x000fe200078e020eULL, 0x01cac00008087984ULL, 0x002e640000004800ULL,
0x0000000408037c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0003027625ULL, 0x000fca00078e0010ULL,
0x0000000d02067210ULL, 0x000fe40007f1e0ffULL, 0xffffffe00a027812ULL, 0x000fc600078ee207ULL,
0x000000ffff077224ULL, 0x000fe200000e0603ULL, 0x00014000020b7811ULL, 0x000fe200078e20ffULL,
0x000000016c037824ULL, 0x000fe200078e0209ULL, 0x0000000509097819ULL, 0x000fc600000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e2000b901c46ULL,
0xffffffe0090c7812ULL, 0x000fc600078ee20cULL, 0x01ca0400050a7984ULL, 0x000ea20000004800ULL,
0x000140000c0b7811ULL, 0x002fe400078e20ffULL, 0x0000000205077810ULL, 0x000fca0007ffe0ffULL,
0x00000001070c7824ULL, 0x000fe200078e020eULL, 0x01cac0000a0a7984ULL, 0x004e640000004800ULL,
0x000000040a037c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0003027625ULL, 0x000fca00078e0010ULL,
0x0000000d02087210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe400000e0603ULL,
0x000000016c037824ULL, 0x000fe400078e0207ULL, 0x0000002007077824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e8000b901c46ULL,
0x01ca0800050a7984ULL, 0x000ea20000004800ULL, 0xffffffe0070c7812ULL, 0x000fc800078ee20cULL,
0x000140000c0b7811ULL, 0x002fe400078e20ffULL, 0x0000000305097810ULL, 0x000fca0007ffe0ffULL,
0x00000001090c7824ULL, 0x000fe200078e020eULL, 0x01cac0000a0a7984ULL, 0x004e640000004800ULL,
0x000000040a037c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0003027625ULL, 0x000fca00078e0010ULL,
0x0000000d02067210ULL, 0x000fc80007f1e0ffULL, 0x00000003ff077210ULL, 0x000fe200007fe4ffULL,
0x000000016c037824ULL, 0x000fe400078e0209ULL, 0x0000002009097824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e6000b901c46ULL,
0xffffffe0090c7812ULL, 0x000fe200078ee20cULL, 0x01ca0c00050a7984ULL, 0x000ea60000004800ULL,
0x000140000c0b7811ULL, 0x002fc400078e20ffULL, 0x0000000405077810ULL, 0x000fca0007ffe0ffULL,
0x00000001070c7824ULL, 0x000fe200078e020eULL, 0x01cac0000a0a7984ULL, 0x004e640000004800ULL,
0x000000040a037c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0003027625ULL, 0x000fca00078e0010ULL,
0x0000000d02087210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0603ULL,
0x000000076c037210ULL, 0x000fe20007ffe0ffULL, 0x0000002007077824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e4000b901c46ULL,
0xffffffe0070c7812ULL, 0x000fe400078ee20cULL, 0x01ca1000050a7984ULL, 0x000ea40000004800ULL,
0x000140000c0b7811ULL, 0x002fe400078e20ffULL, 0x0000000505097810ULL, 0x000fc80007ffe0ffULL,
0x0000000e090c7210ULL, 0x000fe20007ffe0ffULL, 0x01cac0000a0a7984ULL, 0x004e640000004800ULL,
0x000000040a037c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0003027625ULL, 0x000fca00078e0010ULL,
0x0000000d02067210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe400000e0603ULL,
0x000000016c037824ULL, 0x000fe400078e0209ULL, 0x0000002009097824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e8000b901c46ULL,
0x01ca1400050a7984ULL, 0x000ea20000004800ULL, 0xffffffe0090c7812ULL, 0x000fc800078ee20cULL,
0x000140000c0b7811ULL, 0x002fe400078e20ffULL, 0x0000000605077810ULL, 0x000fca0007ffe0ffULL,
0x00000001070c7824ULL, 0x000fe200078e020eULL, 0x01cac0000a0a7984ULL, 0x004e640000004800ULL,
0x000000040a037c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0003027625ULL, 0x000fca00078e0010ULL,
0x0000000d02087210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe400000e0603ULL,
0x000000016c037824ULL, 0x000fe200078e0207ULL, 0x0000000507077819ULL, 0x000fe400000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e4000b901c46ULL,
0xffffffe0070c7812ULL, 0x000fe400078ee20cULL, 0x01ca1800050a7984ULL, 0x000ea40000004800ULL,
0x000140000c097811ULL, 0x002fc400078e20ffULL, 0x00000007050b7810ULL, 0x000fe20007ffe0ffULL,
0x01cac0000a0a7984ULL, 0x004e640000004800ULL, 0x000000040a037c24ULL, 0x002fe4000f8e0203ULL,
0x000000010b0a7824ULL, 0x000fe400078e020eULL, 0x00005e0003027625ULL, 0x000fca00078e0010ULL,
0x0000000d02067210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe400000e0603ULL,
0x000000016c037824ULL, 0x000fe400078e020bULL, 0x000000200b0b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e8000b901c46ULL,
0x01ca1c0005087984ULL, 0x0005220000004800ULL, 0xffffffe00b0a7812ULL, 0x000fc800078ee20aULL,
0x000140000a057811ULL, 0x004fe200078e20ffULL, 0x01cac00008087984ULL, 0x010ea40000004800ULL,
0x0000000408037c24ULL, 0x004fc8000f8e0203ULL, 0x00005e0003027625ULL, 0x000fca00078e0010ULL,
0x0000000d02027210ULL, 0x000fc80007f1e0ffULL, 0x00000003ff037210ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e8000b901c46ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff027f8cULL, 0x002e64000c80043fULL,
0x000000ffff087224ULL, 0x002fc400078e0003ULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x01cb8c00ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804808ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000602067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e03ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc80000011407ULL,
0x0000000605057211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000205057819ULL, 0x000fc80000001206ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000109097810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804808ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000000275037211ULL, 0x002fc800078e28ffULL, 0x0000001f0300780cULL, 0x000fda0003f04070ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000002004047810ULL, 0x000fe20007ffe0ffULL,
0x00000004ff057424ULL, 0x000fc800078e00ffULL, 0x0000000103067824ULL, 0x100fe400078e0204ULL,
0x0000680073047a24ULL, 0x000fc600078e0204ULL, 0x000000710600720cULL, 0x000fe20003f06070ULL,
0x0000000103047824ULL, 0x040fe200078e0204ULL, 0x0001ca0003037811ULL, 0x000fc600078e10ffULL,
0x0000660004047625ULL, 0x000fd000078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e4000c121846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01cb7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb7800ff047f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb8800ff067f8cULL, 0x000ea2000c80043fULL, 0x000000707700720cULL, 0x000fe20003f06070ULL,
0x000000ffff857224ULL, 0x002fe200078e0005ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0xff317217ff337424ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff037224ULL, 0x000fe200078e00ffULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000007003c7202ULL, 0x004fc40000000f00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x000146f000000947ULL, 0x000fea0003800000ULL,
0x0000580000227a02ULL, 0x000fe20000000f00ULL, 0x000146d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x000fe400078e00ffULL, 0xff317217ff337424ULL, 0x000fe400078e00ffULL,
0x0000008022227824ULL, 0x000fc400078e00ffULL, 0x0000010077287824ULL, 0x000fca00078e00ffULL,
0x000000712800720cULL, 0x000fda0003f06070ULL, 0x0001462000000947ULL, 0x008fea0003800000ULL,
0x000000ff00877202ULL, 0x000fc40000000f00ULL, 0x000000776e00720cULL, 0x000fe20003fa4070ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000002ff287819ULL, 0x000fe20000011687ULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x0000000387237812ULL, 0x040fe400078ec0ffULL,
0x0000002887287207ULL, 0x000fe40002800000ULL, 0x000000ff23237207ULL, 0x000fe40006800000ULL,
0x00000002ff2c7819ULL, 0x000fc40000011628ULL, 0x00000003282a7812ULL, 0x000fc600078ec0ffULL,
0x000003002c297a24ULL, 0x000fc400078e0277ULL, 0x00000000002c7805ULL, 0x000fca0000015200ULL,
0x01cb7c00ff2e7984ULL, 0x000e640000000800ULL, 0x800000002eff7812ULL, 0x002fe40007804885ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fcc0000015200ULL,
0x0000002e2c2e7210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09002e00780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402e00780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2b7819ULL, 0x000fc8000001142fULL, 0x0000002e2b2b7211ULL, 0x000fca00078110ffULL,
0x000000ffff2e7224ULL, 0x000fca00000e062fULL, 0x000000022b2b7819ULL, 0x000fc8000000122eULL,
0x0000002b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000130307810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb7c00ff2e7984ULL, 0x000e640000000800ULL, 0x800000002eff7812ULL, 0x002fe40007804885ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000002c7805ULL, 0x000fc40000015200ULL,
0x01cb8c00ff2b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c2e7210ULL, 0x000fc80007f1e1ffULL,
0x0000002f2d2f7210ULL, 0x000fe400007fe5ffULL, 0x003d09002e00780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402e00780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2b7819ULL, 0x000fc8000001142fULL,
0x0000002e2b2b7211ULL, 0x000fca00078110ffULL, 0x000000ffff2e7224ULL, 0x000fca00000e062fULL,
0x000000022b2b7819ULL, 0x000fc8000000122eULL, 0x0000002b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000130307810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff2b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000001292b7810ULL, 0x040fe20007ffe0ffULL, 0x00000004292c7824ULL, 0x000fe200078e022aULL,
0x0000120000017945ULL, 0x000fe40003800000ULL, 0x000000702b00720cULL, 0x000fe40003f06070ULL,
0x000000202c2e7811ULL, 0x000fc800078e30ffULL, 0x000000606c2c7812ULL, 0x000fce00078ef82eULL,
0x0000098000008947ULL, 0x000fea0003800000ULL, 0x000000046f367824ULL, 0x040fe200078e00ffULL,
0x0000002c6f2f7210ULL, 0x040fe20007ffe0ffULL, 0x00000200ff377424ULL, 0x000fe200078e00ffULL,
0x000000016f3b7810ULL, 0x040fe20007ffe0ffULL, 0x0000001002307824ULL, 0x000fe200078e00ffULL,
0x01ca0000362b7984ULL, 0x000e620000000800ULL, 0x000000016f357824ULL, 0x040fe400078e0202ULL,
0x000000206f387824ULL, 0x000fe200078e00ffULL, 0x000001f030397812ULL, 0x000fe200078ec0ffULL,
0x000000042b2d7824ULL, 0x002fe200078e00ffULL, 0x0000002e712b7217ULL, 0x000fca0007800000ULL,
0x01cac0002d2d7984ULL, 0x000e620000000800ULL, 0x000000012b2e7824ULL, 0x000fca00078e0a2eULL,
0x0000002e6f2e7217ULL, 0x000fc80007800000ULL, 0x0000002e6f2b7210ULL, 0x000fc80007ffe1ffULL,
0x000000ff2b00720cULL, 0x000fe20003f03070ULL, 0x0000002d222f7224ULL, 0x002fe200078e022fULL,
0xffffffe0382d7812ULL, 0x000fe400078ee235ULL, 0x000000023b387210ULL, 0x000fe20007ffe0ffULL,
0x00005e002f2e7625ULL, 0x000fe200078e0037ULL, 0x000180002d2d7811ULL, 0x000fc800078e20ffULL,
0x000000392e347210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff357224ULL, 0x000fca00008e062fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000342d7faeULL, 0x0003e2000c101c46ULL,
0x000000012b00780cULL, 0x000fc60003f03070ULL, 0x01ca0400362e7984ULL, 0x000ea40000000800ULL,
0x000000042e307824ULL, 0x004fe400078e00ffULL, 0x000000013b2e7824ULL, 0x040fe400078e022cULL,
0x000000203b3b7824ULL, 0x000fe200078e00ffULL, 0x01cac000302f7984ULL, 0x000ea80000000800ULL,
0xffffffe03b2d7812ULL, 0x002fc400078ee238ULL, 0x000000026f3b7810ULL, 0x000fe40007ffe0ffULL,
0x000180002d2d7811ULL, 0x000fe400078e20ffULL, 0x000000023b387210ULL, 0x000fe20007ffe0ffULL,
0x0000002f222e7224ULL, 0x004fc800078e022eULL, 0x00005e002e2e7625ULL, 0x000fca00078e0037ULL,
0x000000392e347210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff357224ULL, 0x000fca00008e062fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000342d7faeULL, 0x0003e2000c101c46ULL,
0x000000022b00780cULL, 0x000fc60003f03070ULL, 0x01ca0800362e7984ULL, 0x000ea40000000800ULL,
0x000000042e307824ULL, 0x004fe400078e00ffULL, 0x000000013b2e7824ULL, 0x040fe400078e022cULL,
0x000000203b3b7824ULL, 0x000fe200078e00ffULL, 0x01cac000302f7984ULL, 0x000ea80000000800ULL,
0xffffffe03b2d7812ULL, 0x002fc400078ee238ULL, 0x000000036f3b7810ULL, 0x000fe40007ffe0ffULL,
0x000180002d2d7811ULL, 0x000fe400078e20ffULL, 0x000000023b387210ULL, 0x000fe20007ffe0ffULL,
0x0000002f222e7224ULL, 0x004fc800078e022eULL, 0x00005e002e2e7625ULL, 0x000fca00078e0037ULL,
0x000000392e347210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff357224ULL, 0x000fca00008e062fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000342d7faeULL, 0x0003e2000c101c46ULL,
0x000000032b00780cULL, 0x000fc60003f03070ULL, 0x01ca0c00362e7984ULL, 0x000ea40000000800ULL,
0x000000042e307824ULL, 0x004fe400078e00ffULL, 0x000000013b2e7824ULL, 0x040fe400078e022cULL,
0x000000203b3b7824ULL, 0x000fe200078e00ffULL, 0x01cac000302f7984ULL, 0x000ea80000000800ULL,
0xffffffe03b2d7812ULL, 0x002fc400078ee238ULL, 0x000000046f3b7810ULL, 0x000fe40007ffe0ffULL,
0x000180002d2d7811ULL, 0x000fe400078e20ffULL, 0x000000023b387210ULL, 0x000fe20007ffe0ffULL,
0x0000002f222e7224ULL, 0x004fc800078e022eULL, 0x00005e002e2e7625ULL, 0x000fca00078e0037ULL,
0x000000392e347210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff357224ULL, 0x000fca00008e062fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000342d7faeULL, 0x0003e2000c101c46ULL,
0x000000042b00780cULL, 0x000fc60003f03070ULL, 0x01ca1000362e7984ULL, 0x000ea40000000800ULL,
0x000000042e307824ULL, 0x004fe400078e00ffULL, 0x000000013b2e7824ULL, 0x040fe400078e022cULL,
0x000000203b3b7824ULL, 0x000fe200078e00ffULL, 0x01cac000302f7984ULL, 0x000ea80000000800ULL,
0xffffffe03b2d7812ULL, 0x002fc400078ee238ULL, 0x000000056f3b7810ULL, 0x000fe40007ffe0ffULL,
0x000180002d2d7811ULL, 0x000fe400078e20ffULL, 0x000000023b387210ULL, 0x000fe20007ffe0ffULL,
0x0000002f222e7224ULL, 0x004fc800078e022eULL, 0x00005e002e2e7625ULL, 0x000fca00078e0037ULL,
0x000000392e347210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff357224ULL, 0x000fca00008e062fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000342d7faeULL, 0x0003e2000c101c46ULL,
0x000000052b00780cULL, 0x000fc60003f03070ULL, 0x01ca1400362e7984ULL, 0x000ea40000000800ULL,
0x000000042e307824ULL, 0x004fe400078e00ffULL, 0x000000013b2e7824ULL, 0x040fe400078e022cULL,
0x000000203b3b7824ULL, 0x000fe200078e00ffULL, 0x01cac000302f7984ULL, 0x000ea80000000800ULL,
0xffffffe03b2d7812ULL, 0x002fc400078ee238ULL, 0x000000066f3b7810ULL, 0x000fe40007ffe0ffULL,
0x000180002d2d7811ULL, 0x000fe400078e20ffULL, 0x000000023b387210ULL, 0x000fe20007ffe0ffULL,
0x0000002f222e7224ULL, 0x004fc800078e022eULL, 0x00005e002e2e7625ULL, 0x000fca00078e0037ULL,
0x000000392e347210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff357224ULL, 0x000fca00008e062fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000342d7faeULL, 0x0003e2000c101c46ULL,
0x000000062b00780cULL, 0x000fc60003f03070ULL, 0x01ca1800362e7984ULL, 0x000ea40000000800ULL,
0x000000042e307824ULL, 0x004fe400078e00ffULL, 0x000000013b2e7824ULL, 0x040fe400078e022cULL,
0x000000203b3b7824ULL, 0x000fe200078e00ffULL, 0x01cac000302f7984ULL, 0x000ea80000000800ULL,
0xffffffe03b357812ULL, 0x002fc400078ee238ULL, 0x000000076f3b7810ULL, 0x000fe40007ffe0ffULL,
0x0001800035357811ULL, 0x000fe400078e20ffULL, 0x000000023b347210ULL, 0x040fe20007ffe0ffULL,
0x000000013b2c7824ULL, 0x000fe400078e022cULL, 0x0000002f222e7224ULL, 0x004fc800078e022eULL,
0x00005e002e2e7625ULL, 0x000fca00078e0037ULL, 0x000000392e2e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff2f7224ULL, 0x000fca00008e062fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e357faeULL, 0x0003e2000c101c46ULL, 0x000000072b00780cULL, 0x000fe20003f03070ULL,
0x000000203b2b7824ULL, 0x000fe400078e00ffULL, 0x01ca1c00362d7984ULL, 0x000ea60000000800ULL,
0xffffffe02b2b7812ULL, 0x000fc800078ee234ULL, 0x000180002b2b7811ULL, 0x000fe200078e20ffULL,
0x000000042d307824ULL, 0x004fca00078e00ffULL, 0x01cac000302d7984ULL, 0x000ea40000000800ULL,
0x0000002d222c7224ULL, 0x004fc800078e022cULL, 0x00005e002c2c7625ULL, 0x000fca00078e0037ULL,
0x000000392c2c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff2d7224ULL, 0x000fca00008e062dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2b7faeULL, 0x0003e2000c101c46ULL,
0x0000083000007947ULL, 0x000fea0003800000ULL, 0x0000006f02397211ULL, 0x040fe200078fd8ffULL,
0x00000010022e7824ULL, 0x000fe200078e00ffULL, 0x00000200003b7802ULL, 0x000fe40000000f00ULL,
0x0000000139377810ULL, 0x040fe20007ffe0ffULL, 0x01ca0000392b7984ULL, 0x000e620000004800ULL,
0x00000001392d7824ULL, 0x040fe200078e022cULL, 0x000001f02e3d7812ULL, 0x000fe200078ec0ffULL,
0x0000002039307824ULL, 0x000fe200078e00ffULL, 0x01cac0002b2b7984ULL, 0x002e640000004800ULL,
0x0000002b222d7224ULL, 0x002fc800078e022dULL, 0x00005e002d2e7625ULL, 0x000fc800078e003bULL,
0x00000001392d7824ULL, 0x000fe200078e0202ULL, 0x0000003d2e347210ULL, 0x000fe20007f1e0ffULL,
0x00000001372e7824ULL, 0x000fc600078e022cULL, 0xffffffe0302d7812ULL, 0x000fe200078ee22dULL,
0x000000ffff357224ULL, 0x000fe200000e062fULL, 0x0000000237307210ULL, 0x040fe20007ffe0ffULL,
0x0000002037377824ULL, 0x000fe200078e00ffULL, 0x000180002d2b7811ULL, 0x000fc800078e20ffULL,
0xffffffe037307812ULL, 0x000fe200078ee230ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000342b7faeULL, 0x0003e8000b901c46ULL, 0x01ca0400392d7984ULL, 0x000ea20000004800ULL,
0x00018000302b7811ULL, 0x002fe400078e20ffULL, 0x0000000239357810ULL, 0x000fca0007ffe0ffULL,
0x0000000135307824ULL, 0x000fe200078e0202ULL, 0x01cac0002d2d7984ULL, 0x004e640000004800ULL,
0x0000002d222e7224ULL, 0x002fc800078e022eULL, 0x00005e002e2e7625ULL, 0x000fca00078e003bULL,
0x0000003d2e367210ULL, 0x000fe20007f1e0ffULL, 0x00000001352e7824ULL, 0x040fe200078e022cULL,
0x0000000535357819ULL, 0x000fc600000006ffULL, 0x000000ffff377224ULL, 0x000fe200000e062fULL,
0xffffffe035307812ULL, 0x000fc800078ee230ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000362b7faeULL, 0x0003e8000b901c46ULL, 0x01ca0800392d7984ULL, 0x000ea20000004800ULL,
0x00018000302b7811ULL, 0x002fe400078e20ffULL, 0x0000000339377810ULL, 0x000fca0007ffe0ffULL,
0x0000000137307824ULL, 0x000fe200078e0202ULL, 0x01cac0002d2d7984ULL, 0x004e640000004800ULL,
0x0000002d222e7224ULL, 0x002fc800078e022eULL, 0x00005e002e2e7625ULL, 0x000fca00078e003bULL,
0x0000003d2e347210ULL, 0x000fe20007f1e0ffULL, 0x00000001372e7824ULL, 0x040fe400078e022cULL,
0x0000002037377824ULL, 0x000fe400078e00ffULL, 0x000000ffff357224ULL, 0x000fc600000e062fULL,
0xffffffe037307812ULL, 0x000fe400078ee230ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000342b7faeULL, 0x0003e8000b901c46ULL, 0x01ca0c00392d7984ULL, 0x000ea20000004800ULL,
0x00018000302b7811ULL, 0x002fe400078e20ffULL, 0x0000000439357810ULL, 0x000fca0007ffe0ffULL,
0x0000000135307824ULL, 0x000fe200078e0202ULL, 0x01cac0002d2d7984ULL, 0x004e640000004800ULL,
0x0000002d222e7224ULL, 0x002fc800078e022eULL, 0x00005e002e2e7625ULL, 0x000fca00078e003bULL,
0x0000003d2e367210ULL, 0x000fe20007f1e0ffULL, 0x00000001352e7824ULL, 0x040fe400078e022cULL,
0x0000002035357824ULL, 0x000fe200078e00ffULL, 0x0000002fff377210ULL, 0x000fc800007fe4ffULL,
0xffffffe035307812ULL, 0x000fe200078ee230ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000362b7faeULL, 0x0003e8000b901c46ULL, 0x01ca1000392d7984ULL, 0x000ea20000004800ULL,
0x00018000302b7811ULL, 0x002fe400078e20ffULL, 0x0000000539377810ULL, 0x000fca0007ffe0ffULL,
0x0000000137307824ULL, 0x000fe200078e0202ULL, 0x01cac0002d2d7984ULL, 0x004e640000004800ULL,
0x0000002d222e7224ULL, 0x002fc800078e022eULL, 0x00005e002e2e7625ULL, 0x000fca00078e003bULL,
0x0000003d2e347210ULL, 0x000fe40007f1e0ffULL, 0x0000002c372e7210ULL, 0x040fe20007ffe0ffULL,
0x0000002037377824ULL, 0x000fe400078e00ffULL, 0x000000ffff357224ULL, 0x000fc600000e062fULL,
0xffffffe037307812ULL, 0x000fe400078ee230ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000342b7faeULL, 0x0003e8000b901c46ULL, 0x01ca1400392d7984ULL, 0x000ea20000004800ULL,
0x00018000302b7811ULL, 0x002fe400078e20ffULL, 0x0000000639357810ULL, 0x000fc80007ffe0ffULL,
0x0000000235307210ULL, 0x000fe20007ffe0ffULL, 0x01cac0002d2d7984ULL, 0x004e640000004800ULL,
0x0000002d222e7224ULL, 0x002fc800078e022eULL, 0x00005e002e2e7625ULL, 0x000fca00078e003bULL,
0x0000003d2e367210ULL, 0x000fe20007f1e0ffULL, 0x00000001352e7824ULL, 0x040fe400078e022cULL,
0x0000002035357824ULL, 0x000fe400078e00ffULL, 0x000000ffff377224ULL, 0x000fc600000e062fULL,
0xffffffe035307812ULL, 0x000fe400078ee230ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000362b7faeULL, 0x0003e2000b901c46ULL, 0x0000000739357810ULL, 0x000fc60007ffe0ffULL,
0x01ca1800392d7984ULL, 0x000ea40000004800ULL, 0x00000001352c7824ULL, 0x040fe400078e022cULL,
0x0000000135347824ULL, 0x040fe200078e0202ULL, 0x0000000535357819ULL, 0x000fe400000006ffULL,
0x00018000302b7811ULL, 0x002fe400078e20ffULL, 0xffffffe035347812ULL, 0x000fe200078ee234ULL,
0x01cac0002d2d7984ULL, 0x004e640000004800ULL, 0x0000002d222e7224ULL, 0x002fc800078e022eULL,
0x00005e002e2e7625ULL, 0x000fca00078e003bULL, 0x0000003d2e2e7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e2b7faeULL, 0x0003e8000b901c46ULL, 0x01ca1c0039307984ULL, 0x000ea20000004800ULL,
0x00018000342b7811ULL, 0x002fc600078e20ffULL, 0x01cac000302d7984ULL, 0x004e640000004800ULL,
0x0000002d222c7224ULL, 0x002fc800078e022cULL, 0x00005e002c2c7625ULL, 0x000fca00078e003bULL,
0x0000003d2c2c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff2d7224ULL, 0x000fca00000e062dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2b7faeULL, 0x0003e6000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb8800ff2c7f8cULL, 0x002e64000c80043fULL, 0x000000ffff307224ULL, 0x002fc400078e002dULL,
0x00000000002c7805ULL, 0x000fca0000015200ULL, 0x01cb8c00ff2b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe40007804830ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fcc0000015200ULL,
0x0000002e2c2e7210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09002e00780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402e00780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2b7819ULL, 0x000fc8000001142fULL, 0x0000002e2b2b7211ULL, 0x000fc800078110ffULL,
0x0000002fff2e7210ULL, 0x000fc800007fe4ffULL, 0x000000022b2b7819ULL, 0x000fc8000000122eULL,
0x0000002b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb8c00ff2b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe40007804830ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000296e00720cULL, 0x0c0fe20003f24070ULL,
0x0000027000017945ULL, 0x000fe20003800000ULL, 0x00000001232b7810ULL, 0x000fe40007ffe0ffULL,
0x000000296e00720cULL, 0x000fe40003f04070ULL, 0x000000032b2c7812ULL, 0x000fc400078ec0ffULL,
0x0000000128287812ULL, 0x000fe400078ec0ffULL, 0x000000032300780cULL, 0x000fe20004705270ULL,
0x0000002075237824ULL, 0x000fe200078e0202ULL, 0x000000ff2c2c7207ULL, 0x000fe40004800000ULL,
0x00000002ff2b9819ULL, 0x000fe4000001162bULL, 0x000000012800780cULL, 0x000fe40000705470ULL,
0x0000001f2300780cULL, 0x000fe20003f84070ULL, 0x000000012a2a7824ULL, 0x000fca00078e022bULL,
0x00000002ff2e7819ULL, 0x000fe2000001162aULL, 0x000000402a2a7824ULL, 0x000fc800078e00ffULL,
0x000003002e2e7a24ULL, 0x000fe200078e0229ULL, 0x000000c02a297812ULL, 0x000fca00078ec0ffULL,
0x000001002e2e7824ULL, 0x000fe200078e0229ULL, 0x0000015000000947ULL, 0x000fea0003800000ULL,
0x0000002075297824ULL, 0x000fe200078e0202ULL, 0x000000016d2a7812ULL, 0x000fe400078ec0ffULL,
0x0000030000287a02ULL, 0x000fe40000000f00ULL, 0x000000032900780cULL, 0x000fe40003f24070ULL,
0x000000012a00780cULL, 0x000fe40003f05070ULL, 0xffffffff28287811ULL, 0x000fc800078e08ffULL,
0x0000000128287807ULL, 0x000fca0004000000ULL, 0x000000016d6d7824ULL, 0x000fe200078e0228ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0000000400287824ULL, 0x000fe200078e0229ULL,
0x000064006d2b7a10ULL, 0x040fe40007ffe0ffULL, 0x000000726d00720cULL, 0x000fe20003f06070ULL,
0x0000000228287824ULL, 0x000fe200078e00ffULL, 0x00000004002d7802ULL, 0x000fc60000000f00ULL,
0x0000640028287a24ULL, 0x000fe200078e022bULL, 0x0001cac0292b7811ULL, 0x000fc600078e10ffULL,
0x0000600028287625ULL, 0x000fca00078e002dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282b7faeULL, 0x0003e4000c121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000e000017945ULL, 0x000fe20003800000ULL, 0x000000c000004947ULL, 0x000fea0003800000ULL,
0x00000001232a7824ULL, 0x040fe200078e022eULL, 0x0001ca00232b7811ULL, 0x002fe200078e10ffULL,
0x0000000173287824ULL, 0x000fe400078e022cULL, 0x00000004ff297424ULL, 0x000fe200078e00ffULL,
0x000000712a00720cULL, 0x000fe20003f06070ULL, 0x0000680028287a24ULL, 0x000fc800078e022eULL,
0x0000000123287824ULL, 0x000fc800078e0228ULL, 0x0000660028287625ULL, 0x000fca00078e0029ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282b7faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01cb8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff8700720cULL, 0x000fe20003f05270ULL,
0x01cb8000ff847f8cULL, 0x000e62000c80043fULL, 0x000007f000017945ULL, 0x000ff60003800000ULL,
0x000007d000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cad8006f287f8cULL, 0x000ea4000c80043fULL, 0x00000029002f7202ULL, 0x004fc40000000f00ULL,
0x0000000000287805ULL, 0x000fca0000015200ULL, 0x01cadc006f247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc4000780482fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282d7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc8000001142bULL, 0x0000002d24247211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x0000000224247819ULL, 0x000fc8000000122bULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x01cadc006f247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe4000780482fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001002247824ULL, 0x000fe200078e00ffULL,
0x00000001ff287819ULL, 0x000fc80000011602ULL, 0x0000007024247812ULL, 0x000fe400078ec0ffULL,
0x0000000c28297812ULL, 0x000fc800078ec0ffULL, 0x0000002924297210ULL, 0x000fca0007ffe0ffULL,
0x01c0000029287984ULL, 0x000ea80000000800ULL, 0x01c20000292a7984ULL, 0x0006620000000800ULL,
0x000000332800720bULL, 0x004fe20003f1d000ULL, 0x000231927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x008fc800000e0100ULL, 0x0000ffff242e7812ULL, 0x000fe2000780c0ffULL,
0x0000045000027945ULL, 0x000fe20003800000ULL, 0x00000001ff247424ULL, 0x000fe400078e00ffULL,
0x000000ffff2c7224ULL, 0x000fd200078e0033ULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x000000ff7500720cULL, 0x000fe40003f05270ULL, 0x000000332800720bULL, 0x000fe20003f34000ULL,
0x000231627f007947ULL, 0x000fd8000b800000ULL, 0x00000000002b7806ULL, 0x000fc400008e0100ULL,
0x00000028332c7209ULL, 0x000fe20007810000ULL, 0x0000035000037945ULL, 0x000fe20003800000ULL,
0x000099102b2d7816ULL, 0x000fc600000000ffULL, 0x01c4002c29008388ULL, 0x0005e20000000800ULL,
0x000000ff2d00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000002c33297221ULL, 0x004fe20000010000ULL, 0x000000ff2bff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b29297820ULL, 0x000fc80000410000ULL,
0x0000002900307308ULL, 0x000ea40000000800ULL, 0x0000003021217220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe20000011602ULL,
0x000230c27f007947ULL, 0x000fea000b800000ULL, 0x00001f2930297589ULL, 0x0004e400000e0000ULL,
0x0000002920207220ULL, 0x088fe40000410000ULL, 0x000000291f1f7220ULL, 0x080fe40000410000ULL,
0x000000291c1c7220ULL, 0x080fe40000410000ULL, 0x000000291b1b7220ULL, 0x080fe40000410000ULL,
0x0000002918187220ULL, 0x080fe40000410000ULL, 0x0000002917177220ULL, 0x000fc40000410000ULL,
0x0000002914147220ULL, 0x080fe40000410000ULL, 0x0000002913137220ULL, 0x080fe40000410000ULL,
0x0000002910107220ULL, 0x080fe40000410000ULL, 0x000000290f0f7220ULL, 0x080fe40000410000ULL,
0x000000290c0c7220ULL, 0x080fe40000410000ULL, 0x000000290b0b7220ULL, 0x000fc40000410000ULL,
0x0000002908087220ULL, 0x080fe40000410000ULL, 0x0000002907077220ULL, 0x080fe40000410000ULL,
0x0000002904047220ULL, 0x080fe40000410000ULL, 0x0000002903037220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff002bff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802297811ULL, 0x000fe200078ff0ffULL,
0x00022fe27f007947ULL, 0x000fea000b800000ULL, 0x00001f2930297589ULL, 0x0006a400000e0000ULL,
0x000000291e1e7220ULL, 0x084fe40000410000ULL, 0x000000291d1d7220ULL, 0x080fe40000410000ULL,
0x000000291a1a7220ULL, 0x080fe40000410000ULL, 0x0000002919197220ULL, 0x080fe40000410000ULL,
0x0000002916167220ULL, 0x080fe40000410000ULL, 0x0000002915157220ULL, 0x000fc40000410000ULL,
0x0000002912127220ULL, 0x080fe40000410000ULL, 0x0000002911117220ULL, 0x080fe40000410000ULL,
0x000000290e0e7220ULL, 0x080fe40000410000ULL, 0x000000290d0d7220ULL, 0x080fe40000410000ULL,
0x000000290a0a7220ULL, 0x080fe40000410000ULL, 0x0000002909097220ULL, 0x000fc40000410000ULL,
0x0000002906067220ULL, 0x080fe40000410000ULL, 0x0000002905057220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x080fe40000410000ULL, 0x0000002932327220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x004fea0003800000ULL, 0x0000ffff2eff7812ULL, 0x000fda000780602bULL,
0x8000002c28280221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b28280820ULL, 0x000fc80000410000ULL, 0x0000002800250308ULL, 0x000ea40000000800ULL,
0x000000252a2a0220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x000000212a217221ULL, 0x002fe40000010000ULL, 0x000000ffff337224ULL, 0x000fc400078e002cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff24ff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000017945ULL, 0x000fd80003800000ULL, 0x0000016000001947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fe400000010ffULL, 0x00000002ff297819ULL, 0x000fe40000011602ULL,
0x0000541026287816ULL, 0x000fe20000000026ULL, 0x00022e327f007947ULL, 0x000fea000b800000ULL,
0x00001f2928267589ULL, 0x0004e400000e0000ULL, 0x0000000829277810ULL, 0x000fe20007ffe0ffULL,
0x00022e827f007947ULL, 0x000fea000b800000ULL, 0x00001f2728277589ULL, 0x0004e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010293b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0028ULL, 0xffffffff003f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x00004b9000347802ULL, 0x000fc40000000f00ULL,
0x0002412000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000018293b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x004fe200078e0028ULL,
0x00004c0000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3f7424ULL, 0x000fc400078e00ffULL, 0x000240b000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000007027d7812ULL, 0x040fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000802297812ULL, 0x044fe200078ec0ffULL,
0x000006f000017945ULL, 0x000fe20003800000ULL, 0x000000087d7d7812ULL, 0x100fe400078ef802ULL,
0x000000046f837810ULL, 0x000fe40007ffe0ffULL, 0x0000000729807812ULL, 0x000fe200078ef802ULL,
0x000000087d2b7824ULL, 0x040fe200078e00ffULL, 0x0000007d027e7211ULL, 0x040fe200078fe0ffULL,
0x000000087d2f7824ULL, 0x000fe200078e00ffULL, 0x0000008302837211ULL, 0x000fe200078fe0ffULL,
0x00000020802a7824ULL, 0x000fe200078e00ffULL, 0x0000006f027f7211ULL, 0x000fe200078fe0ffULL,
0x00000020802d7824ULL, 0x000fe200078e00ffULL, 0x000000026f817810ULL, 0x000fc40007ffe0ffULL,
0x000000066f897810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82b287812ULL, 0x000fe200078ee27eULL,
0x00000001802b7824ULL, 0x040fe200078e0283ULL, 0x0000007f80297210ULL, 0x000fe40007ffe0ffULL,
0x0000008102817211ULL, 0x000fe400078fe0ffULL, 0x00000005802c7819ULL, 0x000fe400000006ffULL,
0x0000008902897211ULL, 0x000fc400078fe0ffULL, 0xffffffe02a297812ULL, 0x000fe200078ee229ULL,
0x00000001802a7824ULL, 0x000fe200078e0281ULL, 0xffffffe02c2b7812ULL, 0x000fe200078ee22bULL,
0x00000001802c7824ULL, 0x000fe200078e0289ULL, 0x0001200028347811ULL, 0x000fe400078e20ffULL,
0xffffffe02d2a7812ULL, 0x040fe400078ee22aULL, 0xffffffe02d2d7812ULL, 0x000fe400078ee22cULL,
0x000000003434783bULL, 0x000ea20000000200ULL, 0x0001400029297811ULL, 0x000fc400078e20ffULL,
0x000140002a2a7811ULL, 0x000fe400078e20ffULL, 0x000140002b2b7811ULL, 0x000fe200078e20ffULL,
0x000000002950783bULL, 0x000f220000004200ULL, 0x000140002d2d7811ULL, 0x000fe400078e20ffULL,
0x000000027e2e7810ULL, 0x000fe20007ffe0ffULL, 0x000000002a5c783bULL, 0x000ee40000004200ULL,
0x0000001080307812ULL, 0x008fe400078efcffULL, 0xfffffff82f2c7812ULL, 0x000fe200078ee22eULL,
0x000000002b64783bULL, 0x000fe20000004200ULL, 0x00000030817b7210ULL, 0x000fe20007ffe0ffULL,
0x000000017f7c7824ULL, 0x000fe200078e0230ULL, 0x000120002c387811ULL, 0x000fe200078e20ffULL,
0x000000002d3c783bULL, 0x002fe20000004200ULL, 0x0000002030397824ULL, 0x040fe200078e00ffULL,
0x0000000530447819ULL, 0x040fe200000006ffULL, 0x00000020302e7824ULL, 0x040fe200078e00ffULL,
0x00000002ff787819ULL, 0x000fe20000011602ULL, 0x00000001837a7824ULL, 0x000fe200078e0230ULL,
0xffffffe0397c7812ULL, 0x000fe200078ee27cULL, 0x00000020302f7824ULL, 0x000fe200078e00ffULL,
0xffffffe02e7b7812ULL, 0x000fe200078ee27bULL, 0x0000000189797824ULL, 0x000fe200078e0230ULL,
0x000000003838783bULL, 0x000e620000000200ULL, 0x000140007c2e7811ULL, 0x000fc400078e20ffULL,
0xffffffe02f7a7812ULL, 0x000fe400078ee27aULL, 0xffffffe044797812ULL, 0x000fe200078ee279ULL,
0x000000002e40783bULL, 0x000ee20000004200ULL, 0x000140007b2f7811ULL, 0x000fe400078e20ffULL,
0x000140007a307811ULL, 0x000fe400078e20ffULL, 0x0001400079747811ULL, 0x000fe200078e20ffULL,
0x000000002f44783bULL, 0x000ee20000004200ULL, 0x0000002634349231ULL, 0x084fe200003400ffULL,
0x000000877800720cULL, 0x000fe20003f46070ULL, 0x0000002636369231ULL, 0x000fe200003400ffULL,
0x00000000304c783bULL, 0x000ea20000004200ULL, 0x0000002735359231ULL, 0x080fe200003400ffULL,
0x000000776e00720cULL, 0x000fe20003fc3070ULL, 0x0000002737379231ULL, 0x000fe200003400ffULL,
0x000000007454783bULL, 0x000ea20000004200ULL, 0x0000000878767810ULL, 0x000fc40007ffe0ffULL,
0x000000776e00720cULL, 0x000fe40003f03070ULL, 0x000000877600720cULL, 0x000fe20003f66070ULL,
0x000000503448723cULL, 0x050f7000000418ffULL, 0x0000005c3458723cULL, 0x000fe200000418ffULL,
0x0000002638389231ULL, 0x002fce00003400ffULL, 0x000000643460723cULL, 0x000fe200000418ffULL,
0x000000263a3a9231ULL, 0x000fe400003400ffULL, 0x0000002739399231ULL, 0x080fe400003400ffULL,
0x000000273b3b9231ULL, 0x000fc600003400ffULL, 0x000000523450723cULL, 0x040f7000000418ffULL,
0x0000005e345c723cULL, 0x040f7000000418ffULL, 0x000000663464723cULL, 0x040f7000000418ffULL,
0x0000003c3468723cULL, 0x040b6e00000418ffULL, 0x00000001873d7810ULL, 0x020fe20007ffe0ffULL,
0x0000003e3434723cULL, 0x000f6600000418ffULL, 0x0000003d7800720cULL, 0x000fc40005746470ULL,
0x0000003d7600720cULL, 0x000fc60005f66470ULL, 0x000000403848723cULL, 0x048b700000041848ULL,
0x000000423850723cULL, 0x040b700000041850ULL, 0x000000443858723cULL, 0x040b700000041858ULL,
0x00000046385c723cULL, 0x040b70000004185cULL, 0x0000004c3860723cULL, 0x044b700000041860ULL,
0x0000004e3864723cULL, 0x040b700000041864ULL, 0x000000543868723cULL, 0x040b700000041868ULL,
0x000000563834723cULL, 0x020b620000041834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000004820207221ULL, 0x000fe40000010000ULL,
0x000000491f1f7221ULL, 0x000fc40000010000ULL, 0x000000501c1c7221ULL, 0x000fe40000010000ULL,
0x000000511b1b7221ULL, 0x000fe40000010000ULL, 0x0000005818187221ULL, 0x000fe40000010000ULL,
0x0000005917177221ULL, 0x000fe40000010000ULL, 0x0000005c14147221ULL, 0x000fe40000010000ULL,
0x0000005d13137221ULL, 0x000fc40000010000ULL, 0x0000006010107221ULL, 0x000fe40000010000ULL,
0x000000610f0f7221ULL, 0x000fe40000010000ULL, 0x000000640c0c7221ULL, 0x000fe40000010000ULL,
0x000000650b0b7221ULL, 0x000fe40000010000ULL, 0x0000006808087221ULL, 0x000fe40000010000ULL,
0x0000006907077221ULL, 0x000fc40000010000ULL, 0x0000003404047221ULL, 0x020fe40000010000ULL,
0x0000003503037221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0000000000ULL,
0x0000004a1e1e7221ULL, 0x000fe40000010000ULL, 0x0000004b1d1d7221ULL, 0x000fe40000010000ULL,
0x000000521a1a7221ULL, 0x000fe40000010000ULL, 0x0000005319197221ULL, 0x000fe40000010000ULL,
0x0000005a16167221ULL, 0x000fc40000010000ULL, 0x0000005b15157221ULL, 0x000fe40000010000ULL,
0x0000005e12127221ULL, 0x000fe40000010000ULL, 0x0000005f11117221ULL, 0x000fe40000010000ULL,
0x000000620e0e7221ULL, 0x000fe40000010000ULL, 0x000000630d0d7221ULL, 0x000fe40000010000ULL,
0x000000660a0a7221ULL, 0x000fc40000010000ULL, 0x0000006709097221ULL, 0x000fe40000010000ULL,
0x0000006a06067221ULL, 0x000fe40000010000ULL, 0x0000006b05057221ULL, 0x000fe40000010000ULL,
0x0000003631317221ULL, 0x020fe40000010000ULL, 0x0000003732327221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb8800ff347f8cULL, 0x020e62000c80043fULL, 0x000000776e00720cULL, 0x0c0fe40003f03070ULL,
0x000000776e00720cULL, 0x000fc40003fc3070ULL, 0x00000001ff407803ULL, 0x000fe40000000000ULL,
0x00000002ff347819ULL, 0x002fe2000001163dULL, 0x000000ffff3c7224ULL, 0x000fc600078e0035ULL,
0x000000343d367207ULL, 0x040fe40002800000ULL, 0x000000033d347812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x00000002ff387819ULL, 0x000fe40000011636ULL,
0x000000ff34347207ULL, 0x000fe40006800000ULL, 0x0000000336367812ULL, 0x000fe200078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e0277ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8400ff3a7984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x800000003aff7812ULL, 0x002fe20007804885ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc8000001143bULL, 0x0000003a37377211ULL, 0x000fca00078110ffULL,
0x000000ffff3a7224ULL, 0x000fca00000e063bULL, 0x0000000237377819ULL, 0x000fc8000000123aULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb8400ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804885ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x01cb8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ff003d7202ULL, 0x000fe20000000f00ULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000037ff7812ULL, 0x002fe2000780483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078110ffULL, 0x000000ffff3a7224ULL, 0x000fca00000e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000435377824ULL, 0x000fe200078e0236ULL, 0x0000121000017945ULL, 0x000fe60003800000ULL,
0x0000004037427824ULL, 0x000fe200078e00ffULL, 0x0000000135377810ULL, 0x000fc80007ffe0ffULL,
0x000000703700720cULL, 0x000fe40003f06070ULL, 0x000000406c387812ULL, 0x000fd600078ef842ULL,
0x0000098000008947ULL, 0x000fea0003800000ULL, 0x000000026f417819ULL, 0x040fe200000006ffULL,
0x000000016f397824ULL, 0x040fe200078e0238ULL, 0x000000016f497810ULL, 0x000fe20007ffe0ffULL,
0x00000200ff437424ULL, 0x000fe400078e00ffULL, 0x01ca000041377984ULL, 0x000e640000000800ULL,
0x00000004373e7824ULL, 0x002fca00078e00ffULL, 0x01cac0003e377984ULL, 0x0002a40000000800ULL,
0x000000206f3e7824ULL, 0x002fe400078e00ffULL, 0x0000003722377224ULL, 0x004fe400078e0239ULL,
0x0000001002397824ULL, 0x000fe400078e00ffULL, 0x00005e00373a7625ULL, 0x000fe200078e0043ULL,
0x0000004271377217ULL, 0x000fe40007800000ULL, 0x000001f039457812ULL, 0x000fc800078ec0ffULL,
0x000000453a3c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001373a7824ULL, 0x000fe400078e0a42ULL,
0x000000016f377824ULL, 0x040fe200078e0202ULL, 0x0000003bff3d7210ULL, 0x000fe400007fe4ffULL,
0x0000003a6f3a7217ULL, 0x000fe40007800000ULL, 0xffffffe03e397812ULL, 0x000fc600078ee237ULL,
0x000000013a377824ULL, 0x000fe200078e0a6fULL, 0x0001400039477811ULL, 0x000fe200078e20ffULL,
0x00000001493a7824ULL, 0x000fc600078e0238ULL, 0x000000ff3700720cULL, 0x000fda0003f03070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000c101c46ULL,
0x01ca040041397984ULL, 0x000ea40000000800ULL, 0x0000000239397819ULL, 0x004fcc00000006ffULL,
0x01cac00039397984ULL, 0x000ea40000000800ULL, 0x00000039223a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000000013700780cULL, 0x000fe40003f03070ULL,
0xffffffe0493a7812ULL, 0x000fe400078ee23aULL, 0x000000026f497810ULL, 0x000fc40007ffe0ffULL,
0x000140003a477811ULL, 0x002fc600078e20ffULL, 0x00000001493a7824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e8000c101c46ULL,
0x01ca080041397984ULL, 0x000ea40000000800ULL, 0x0000000239397819ULL, 0x004fcc00000006ffULL,
0x01cac00039397984ULL, 0x000ea40000000800ULL, 0x00000039223a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000000023700780cULL, 0x000fe40003f03070ULL,
0xffffffe0493a7812ULL, 0x000fe400078ee23aULL, 0x000000036f497810ULL, 0x000fc40007ffe0ffULL,
0x000140003a477811ULL, 0x002fc600078e20ffULL, 0x00000001493a7824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000c101c46ULL,
0x01ca0c0041397984ULL, 0x000ea40000000800ULL, 0x0000000239397819ULL, 0x004fcc00000006ffULL,
0x01cac00039397984ULL, 0x000ea40000000800ULL, 0x00000039223a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000000033700780cULL, 0x000fe40003f03070ULL,
0xffffffe0493a7812ULL, 0x000fe400078ee23aULL, 0x000000046f497810ULL, 0x000fc40007ffe0ffULL,
0x000140003a477811ULL, 0x002fc600078e20ffULL, 0x00000001493a7824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e8000c101c46ULL,
0x01ca100041397984ULL, 0x000ea40000000800ULL, 0x0000000239397819ULL, 0x004fcc00000006ffULL,
0x01cac00039397984ULL, 0x000ea40000000800ULL, 0x00000039223a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0x000000043700780cULL, 0x000fe40003f03070ULL,
0xffffffe0493a7812ULL, 0x000fe400078ee23aULL, 0x000000056f497810ULL, 0x000fc40007ffe0ffULL,
0x000140003a477811ULL, 0x002fc600078e20ffULL, 0x00000001493a7824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000c101c46ULL,
0x01ca140041397984ULL, 0x000ea20000000800ULL, 0x000000066f477810ULL, 0x002fca0007ffe0ffULL,
0x00000001473c7824ULL, 0x000fe200078e0202ULL, 0x0000000239397819ULL, 0x004fcc00000006ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0x000000053700780cULL, 0x000fe40003f03070ULL,
0xffffffe0493a7812ULL, 0x000fc800078ee23aULL, 0x000140003a3d7811ULL, 0x000fe200078e20ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fc800078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e2000c101c46ULL,
0xffffffe0473c7812ULL, 0x000fc600078ee23cULL, 0x01ca180041397984ULL, 0x000ea20000000800ULL,
0x000140003c3d7811ULL, 0x002fe400078e20ffULL, 0x000000076f3f7810ULL, 0x000fca0007ffe0ffULL,
0x000000013f387824ULL, 0x040fe400078e0238ULL, 0x000000013f3e7824ULL, 0x040fe400078e0202ULL,
0x000000203f3f7824ULL, 0x000fca00078e00ffULL, 0xffffffe03f3e7812ULL, 0x000fe400078ee23eULL,
0x0000000239397819ULL, 0x004fcc00000006ffULL, 0x01cac00039397984ULL, 0x000e640000000800ULL,
0x00000039223a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e063bULL,
0x000000063700780cULL, 0x000fda0003f03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000c101c46ULL, 0x01ca1c0041397984ULL, 0x000ea20000000800ULL,
0x000140003e3b7811ULL, 0x002fe400078e20ffULL, 0x00000002393c7819ULL, 0x004fca00000006ffULL,
0x01cac0003c397984ULL, 0x000e640000000800ULL, 0x0000003922387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x0000004538387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fe200000e0639ULL, 0x000000073700780cULL, 0x000fda0003f03070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e2000c101c46ULL,
0x0000083000007947ULL, 0x000fea0003800000ULL, 0x0000006f02417211ULL, 0x040fe200078fd8ffULL,
0x00000200ff427424ULL, 0x000fe400078e00ffULL, 0x00000010023c7824ULL, 0x000fe200078e00ffULL,
0x0000003841397210ULL, 0x040fe20007ffe0ffULL, 0x01ca000041377984ULL, 0x000e620000004800ULL,
0x0000000141477810ULL, 0x000fe40007ffe0ffULL, 0x000001f03c437812ULL, 0x000fe200078ec0ffULL,
0x01cac00037377984ULL, 0x002e640000004800ULL, 0x0000003722397224ULL, 0x002fc800078e0239ULL,
0x00005e00393a7625ULL, 0x000fc800078e0042ULL, 0x0000000141397824ULL, 0x040fe200078e0202ULL,
0x000000433a3c7210ULL, 0x000fe40007f1e0ffULL, 0x00000005413a7819ULL, 0x000fc600000006ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x000fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca040041377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722397224ULL, 0x004fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fc800078e0042ULL,
0x0000000147397824ULL, 0x040fe200078e0202ULL, 0x000000433a3e7210ULL, 0x000fe20007f1e0ffULL,
0x00000020473a7824ULL, 0x000fe200078e00ffULL, 0x0000000241477810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x002fe400078e20ffULL, 0x0000003847397210ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e457faeULL, 0x0003e8000b901c46ULL,
0x01ca080041377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722397224ULL, 0x004fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fc800078e0042ULL,
0x0000000147397824ULL, 0x040fe200078e0202ULL, 0x000000433a3c7210ULL, 0x000fe20007f1e0ffULL,
0x00000020473a7824ULL, 0x000fe200078e00ffULL, 0x0000000341477810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x002fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca0c0041377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722397224ULL, 0x004fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fc800078e0042ULL,
0x0000000147397824ULL, 0x040fe200078e0202ULL, 0x000000433a3e7210ULL, 0x000fe20007f1e0ffULL,
0x00000020473a7824ULL, 0x000fe200078e00ffULL, 0x0000000441477810ULL, 0x000fe40007ffe0ffULL,
0x0000003bff3f7210ULL, 0x000fe400007fe4ffULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x002fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e457faeULL, 0x0003e8000b901c46ULL,
0x01ca100041377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722397224ULL, 0x004fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fe200078e0042ULL,
0x0000000247397210ULL, 0x000fc80007ffe0ffULL, 0x000000433a3c7210ULL, 0x000fe20007f1e0ffULL,
0x00000020473a7824ULL, 0x000fe200078e00ffULL, 0x0000000541477810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x002fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca140041377984ULL, 0x000ea20000004800ULL, 0x0000000641457810ULL, 0x002fca0007ffe0ffULL,
0x00000020453c7824ULL, 0x000fe200078e00ffULL, 0x01cac00037377984ULL, 0x004e640000004800ULL,
0x0000003722397224ULL, 0x002fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fc800078e0042ULL,
0x0000000147397824ULL, 0x040fe200078e0202ULL, 0x000000433a3e7210ULL, 0x000fe40007f1e0ffULL,
0x00000005473a7819ULL, 0x000fc600000006ffULL, 0x000000ffff3f7224ULL, 0x000fe200000e063bULL,
0xffffffe03a397812ULL, 0x000fc800078ee239ULL, 0x00014000393d7811ULL, 0x000fe200078e20ffULL,
0x0000000145397824ULL, 0x000fc800078e0238ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e3d7faeULL, 0x0003e8000b901c46ULL, 0x01ca180041377984ULL, 0x000ea20000004800ULL,
0x00000007413f7810ULL, 0x002fc80007ffe0ffULL, 0x000000383f387210ULL, 0x000fe20007ffe0ffULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722397224ULL, 0x002fc800078e0239ULL,
0x00005e00393a7625ULL, 0x000fc800078e0042ULL, 0x0000000145397824ULL, 0x000fe200078e0202ULL,
0x000000433a3a7210ULL, 0x000fc80007f1e0ffULL, 0xffffffe03c397812ULL, 0x000fe200078ee239ULL,
0x000000ffff3b7224ULL, 0x000fe400000e063bULL, 0x000000013f3c7824ULL, 0x000fe200078e0202ULL,
0x00014000393d7811ULL, 0x000fe200078e20ffULL, 0x000000203f3f7824ULL, 0x000fc800078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e2000b901c46ULL,
0xffffffe03f3c7812ULL, 0x000fc600078ee23cULL, 0x01ca1c0041377984ULL, 0x000ea20000004800ULL,
0x000140003c3b7811ULL, 0x002fc600078e20ffULL, 0x01cac00037377984ULL, 0x004e640000004800ULL,
0x0000003722387224ULL, 0x002fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0042ULL,
0x0000004338387210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e6000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb8800ff387f8cULL, 0x002e64000c80043fULL, 0x000000ffff3c7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x01cb8c00ff377984ULL, 0x000e620000000800ULL,
0x000000ff003d7202ULL, 0x000fe20000000f00ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000037ff7812ULL, 0x002fe2000780483cULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc8000001143bULL, 0x0000003a37377211ULL, 0x000fca00078110ffULL,
0x000000ffff3a7224ULL, 0x000fca00000e063bULL, 0x0000000237377819ULL, 0x000fc8000000123aULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb8c00ff377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000356e00720cULL, 0x000fc80003f04070ULL,
0x000000ff34377207ULL, 0x040fe40000000000ULL, 0x000000ff34387207ULL, 0x000fc60004000000ULL,
0x0000000136377824ULL, 0x000fca00078e0237ULL, 0x00000002ff347819ULL, 0x000fe20000011637ULL,
0x0000004037377824ULL, 0x000fc800078e00ffULL, 0x0000030034347a24ULL, 0x000fe200078e0235ULL,
0x000000c037377812ULL, 0x000fe200078ec0ffULL, 0x0000000173357824ULL, 0x000fc600078e0238ULL,
0x0000003734347211ULL, 0x000fe400078e40ffULL, 0x0001ca0023377811ULL, 0x000fe400078e10ffULL,
0x0000002034367810ULL, 0x000fca0007ffe0ffULL, 0x0000680035347a24ULL, 0x100fe400078e0236ULL,
0x0000000123367824ULL, 0x040fe400078e0236ULL, 0x00000004ff357424ULL, 0x000fe400078e00ffULL,
0x0000000123347824ULL, 0x000fe200078e0234ULL, 0x000000713600720cULL, 0x000fc60003f06070ULL,
0x0000660034347625ULL, 0x000fd400078e0035ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034377faeULL, 0x0003e4000c121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01cb7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb7800ff847f8cULL, 0x000e62000c80043fULL, 0x0000016000017945ULL, 0x000fe20003800000ULL,
0x0000014000001947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000010ffULL,
0x0000541026377816ULL, 0x000fe20000000026ULL, 0x000208f27f007947ULL, 0x000fea000b800000ULL,
0x00001f7837267589ULL, 0x0004e400000e0000ULL, 0x000209527f007947ULL, 0x000fea000b800000ULL,
0x00001f7637277589ULL, 0x0004e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010783b7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff3c7424ULL, 0x000fe200078e00ffULL,
0x00000037003a7202ULL, 0x000fe20000000f00ULL, 0xffffffffff3f7424ULL, 0x000fe200078e00ffULL,
0x000071c000347802ULL, 0x000fc40000000f00ULL, 0x00021af000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0037ULL,
0x00000018783b7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff3c7424ULL, 0x000fe200078e00ffULL,
0xffffffff003f7802ULL, 0x000fe40000000f00ULL, 0x0000723000347802ULL, 0x000fc40000000f00ULL,
0x00021a8000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000087d357824ULL, 0x000fe200078e00ffULL, 0x000000047e827810ULL, 0x000fe20007ffe0ffULL,
0x0000000180897824ULL, 0x040fe200078e0289ULL, 0x0000007f807f7210ULL, 0x040fe20007ffe0ffULL,
0x0000000180837824ULL, 0x040fe200078e0283ULL, 0xfffffff835827812ULL, 0x000fe200078ee282ULL,
0x0000000180817824ULL, 0x040fe200078e0281ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000020803a7824ULL, 0x004fe200078e00ffULL, 0x0001200082347811ULL, 0x000fe200078e20ffULL,
0x0000002080387824ULL, 0x040fe200078e00ffULL, 0x000000037d7d7819ULL, 0x000fe200000006ffULL,
0x00000020803c7824ULL, 0x002fe200078e00ffULL, 0xffffffe03a897812ULL, 0x000fe200078ee289ULL,
0x0000002080807824ULL, 0x000fe200078e00ffULL, 0xffffffe038387812ULL, 0x000fe200078ee27fULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0xffffffe03c7f7812ULL, 0x000fe200078ee283ULL,
0x0000041000017945ULL, 0x000fe20003800000ULL, 0xffffffe080807812ULL, 0x000fc400078ee281ULL,
0x0001800038817811ULL, 0x000fe400078e20ffULL, 0x000000067e387810ULL, 0x000fe40007ffe0ffULL,
0x0001800080807811ULL, 0x000fe200078e20ffULL, 0x000000008154783bULL, 0x000ea20000004200ULL,
0x000180007f7f7811ULL, 0x000fe400078e20ffULL, 0x00018000897e7811ULL, 0x000fe200078e20ffULL,
0x00000000805c783bULL, 0x000f220000004200ULL, 0xfffffff87d7d7812ULL, 0x000fc400078ee238ULL,
0x000180007c7c7811ULL, 0x000fe200078e20ffULL, 0x000000007f64783bULL, 0x000fe20000004200ULL,
0x000120007d387811ULL, 0x000fe400078e20ffULL, 0x000180007b7b7811ULL, 0x000fe200078e20ffULL,
0x000000007e3c783bULL, 0x000fe20000004200ULL, 0x000180007a7a7811ULL, 0x000fe400078e20ffULL,
0x0001800079797811ULL, 0x000fe200078e20ffULL, 0x000000003838783bULL, 0x000ee20000000200ULL,
0x000000ff4000720cULL, 0x000fc60003f05270ULL, 0x000000007c40783bULL, 0x000ee80000004200ULL,
0x000000007b44783bULL, 0x000ee80000004200ULL, 0x000000007a48783bULL, 0x000ee40000004200ULL,
0x0000002634349231ULL, 0x00afc400003400ffULL, 0x00000000794c783bULL, 0x000e620000004200ULL,
0x0000002636369231ULL, 0x000fe400003400ffULL, 0x0000002735359231ULL, 0x080fe400003400ffULL,
0x0000002737379231ULL, 0x000fce00003400ffULL, 0x000000543450723cULL, 0x044f7000000418ffULL,
0x0000005c3458723cULL, 0x010fe200000418ffULL, 0x0000002638389231ULL, 0x080fe400003400ffULL,
0x000000263a3a9231ULL, 0x000fca00003400ffULL, 0x000000643460723cULL, 0x000fe200000418ffULL,
0x0000002739399231ULL, 0x080fe400003400ffULL, 0x000000273b3b9231ULL, 0x000fca00003400ffULL,
0x000000563454723cULL, 0x040f7000000418ffULL, 0x0000005e345c723cULL, 0x040f7000000418ffULL,
0x000000663464723cULL, 0x040f7000000418ffULL, 0x0000003c3468723cULL, 0x040f7000000418ffULL,
0x0000003e3434723cULL, 0x000f7000000418ffULL, 0x000000403850723cULL, 0x060b700000041850ULL,
0x000000423854723cULL, 0x040b700000041854ULL, 0x000000443858723cULL, 0x040b700000041858ULL,
0x00000046385c723cULL, 0x040b70000004185cULL, 0x000000483860723cULL, 0x040b700000041860ULL,
0x0000004a3864723cULL, 0x040b700000041864ULL, 0x0000004c3868723cULL, 0x042b700000041868ULL,
0x0000004e3834723cULL, 0x000b620000041834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0000000000ULL, 0x0000005020207221ULL, 0x020fe40000010000ULL,
0x000000511f1f7221ULL, 0x000fc40000010000ULL, 0x000000541c1c7221ULL, 0x000fe40000010000ULL,
0x000000551b1b7221ULL, 0x000fe40000010000ULL, 0x0000005818187221ULL, 0x000fe40000010000ULL,
0x0000005917177221ULL, 0x000fe40000010000ULL, 0x0000005c14147221ULL, 0x000fe40000010000ULL,
0x0000005d13137221ULL, 0x000fc40000010000ULL, 0x0000006010107221ULL, 0x000fe40000010000ULL,
0x000000610f0f7221ULL, 0x000fe40000010000ULL, 0x000000640c0c7221ULL, 0x000fe40000010000ULL,
0x000000650b0b7221ULL, 0x000fe40000010000ULL, 0x0000006808087221ULL, 0x000fe40000010000ULL,
0x0000006907077221ULL, 0x000fc40000010000ULL, 0x0000003404047221ULL, 0x000fe40000010000ULL,
0x0000003503037221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0003000000ULL,
0x000000521e1e7221ULL, 0x020fe40000010000ULL, 0x000000531d1d7221ULL, 0x000fe40000010000ULL,
0x000000561a1a7221ULL, 0x000fe40000010000ULL, 0x0000005719197221ULL, 0x000fe40000010000ULL,
0x0000005a16167221ULL, 0x000fc40000010000ULL, 0x0000005b15157221ULL, 0x000fe40000010000ULL,
0x0000005e12127221ULL, 0x000fe40000010000ULL, 0x0000005f11117221ULL, 0x000fe40000010000ULL,
0x000000620e0e7221ULL, 0x000fe40000010000ULL, 0x000000630d0d7221ULL, 0x000fe40000010000ULL,
0x000000660a0a7221ULL, 0x000fc40000010000ULL, 0x0000006709097221ULL, 0x000fe40000010000ULL,
0x0000006a06067221ULL, 0x000fe40000010000ULL, 0x0000006b05057221ULL, 0x000fe40000010000ULL,
0x0000003631317221ULL, 0x000fe40000010000ULL, 0x0000003732327221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000187877810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff347f8cULL, 0x020e62000c80043fULL,
0x00000004ff837424ULL, 0x000fca00078e00ffULL, 0x0000000183837807ULL, 0x000fc80006800000ULL,
0x000000838700720cULL, 0x000fe20003f06070ULL, 0x000000ffff3c7224ULL, 0x002fd800078e0035ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffab1000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004077347811ULL, 0x000fe200078e40ffULL,
0x01cb5800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000713400720cULL, 0x000fda0003f06070ULL,
0x0000f09000000947ULL, 0x000fea0003800000ULL, 0x000000ffff877224ULL, 0x000fca00078e00ffULL,
0x00000002ff347819ULL, 0x000fe20000011687ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000387367812ULL, 0x040fe200078ec0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x0000003487347207ULL, 0x000fe40002800000ULL, 0x000000ff36367207ULL, 0x000fe40006800000ULL,
0x0000000134377810ULL, 0x000fc80007ffe0ffULL, 0x00000002ff387819ULL, 0x000fe40000011637ULL,
0x0000000337347812ULL, 0x000fc600078ec0ffULL, 0x0000030038357a24ULL, 0x000fc400078e0277ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x01cb7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804885ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fc80007f1e1ffULL,
0x0000003b393b7210ULL, 0x000fe400007fe5ffULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804885ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x01cb8c00ff3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb8c00ff3b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000135397810ULL, 0x040fe20007ffe0ffULL,
0x0000121000017945ULL, 0x000fe20003800000ULL, 0x0000003435387211ULL, 0x000fe400078e10ffULL,
0x000000703900720cULL, 0x000fe40003f06070ULL, 0x00000020383a7811ULL, 0x000fc800078e30ffULL,
0x000000606c387812ULL, 0x000fce00078ef83aULL, 0x0000098000008947ULL, 0x000fea0003800000ULL,
0x000000046f3f7824ULL, 0x040fe200078e00ffULL, 0x0000020000417802ULL, 0x000fe20000000f00ULL,
0x000000016f3c7824ULL, 0x040fe200078e0238ULL, 0x000000016f477810ULL, 0x040fe20007ffe0ffULL,
0x000000016f407824ULL, 0x040fe200078e0202ULL, 0x01ca00003f397984ULL, 0x000e620000000800ULL,
0x000000206f457824ULL, 0x000fca00078e00ffULL, 0xffffffe045407812ULL, 0x000fc800078ee240ULL,
0x0001800040457811ULL, 0x000fe200078e20ffULL, 0x0000000147407824ULL, 0x000fe400078e0202ULL,
0x00000004393d7824ULL, 0x002fe200078e00ffULL, 0x0000003a71397217ULL, 0x000fc80007800000ULL,
0x01cac0003d3b7984ULL, 0x000e620000000800ULL, 0x00000001393a7824ULL, 0x000fe400078e0a3aULL,
0x0000001002397824ULL, 0x000fc600078e00ffULL, 0x0000003a6f3a7217ULL, 0x000fe40007800000ULL,
0x000001f039437812ULL, 0x000fc600078ec0ffULL, 0x000000013a3e7824ULL, 0x000fca00078e0a6fULL,
0x000000ff3e00720cULL, 0x000fe20003f03070ULL, 0x0000003b223b7224ULL, 0x002fc800078e023cULL,
0x00005e003b3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe200078e00ffULL,
0x0000003bff3d7210ULL, 0x000fc80000ffe4ffULL, 0xffffffe047407812ULL, 0x000fe200078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000013e00780cULL, 0x000fe40003f03070ULL, 0x000000026f477810ULL, 0x000fe20007ffe0ffULL,
0x01ca04003f397984ULL, 0x000ea20000000800ULL, 0x0001800040457811ULL, 0x002fc600078e20ffULL,
0x0000000147407824ULL, 0x000fe400078e0202ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe200078e00ffULL,
0x0000003bff3d7210ULL, 0x000fc80000ffe4ffULL, 0xffffffe047407812ULL, 0x000fe200078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000023e00780cULL, 0x000fe40003f03070ULL, 0x000000036f477810ULL, 0x000fe20007ffe0ffULL,
0x01ca08003f397984ULL, 0x000ea20000000800ULL, 0x0001800040457811ULL, 0x002fc600078e20ffULL,
0x0000000147407824ULL, 0x000fe400078e0202ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe200078e00ffULL,
0x0000003bff3d7210ULL, 0x000fc80000ffe4ffULL, 0xffffffe047407812ULL, 0x000fe200078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000033e00780cULL, 0x000fe40003f03070ULL, 0x000000046f477810ULL, 0x000fe20007ffe0ffULL,
0x01ca0c003f397984ULL, 0x000ea20000000800ULL, 0x0001800040457811ULL, 0x002fc600078e20ffULL,
0x0000000147407824ULL, 0x000fe400078e0202ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe200078e00ffULL,
0x0000003bff3d7210ULL, 0x000fc80000ffe4ffULL, 0xffffffe047407812ULL, 0x000fe200078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000043e00780cULL, 0x000fe40003f03070ULL, 0x000000056f477810ULL, 0x000fe20007ffe0ffULL,
0x01ca10003f397984ULL, 0x000ea20000000800ULL, 0x0001800040457811ULL, 0x002fc600078e20ffULL,
0x0000000147407824ULL, 0x000fe400078e0202ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe200078e00ffULL,
0x0000003bff3d7210ULL, 0x000fc80000ffe4ffULL, 0xffffffe047407812ULL, 0x000fe200078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000053e00780cULL, 0x000fe40003f03070ULL, 0x000000066f477810ULL, 0x000fe20007ffe0ffULL,
0x01ca14003f397984ULL, 0x000ea20000000800ULL, 0x0001800040457811ULL, 0x002fc600078e20ffULL,
0x0000000147407824ULL, 0x000fe400078e0202ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe200078e00ffULL,
0x0000003bff3d7210ULL, 0x000fc80000ffe4ffULL, 0xffffffe047407812ULL, 0x000fe200078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000063e00780cULL, 0x000fc60003f03070ULL, 0x01ca18003f397984ULL, 0x000ea20000000800ULL,
0x00018000403d7811ULL, 0x002fe400078e20ffULL, 0x000000076f457810ULL, 0x000fca0007ffe0ffULL,
0x0000000145387824ULL, 0x040fe400078e0238ULL, 0x0000000145407824ULL, 0x040fe400078e0202ULL,
0x0000002045457824ULL, 0x000fca00078e00ffULL, 0xffffffe045407812ULL, 0x000fe200078ee240ULL,
0x0000000439397824ULL, 0x004fcc00078e00ffULL, 0x01cac00039397984ULL, 0x000e640000000800ULL,
0x00000039223a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0041ULL,
0x000000433a3a7210ULL, 0x000fc80007f3e0ffULL, 0x0000003bff3b7210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e2000c101c46ULL,
0x000000073e00780cULL, 0x000fc60003f03070ULL, 0x01ca1c003f397984ULL, 0x000ea20000000800ULL,
0x00018000403b7811ULL, 0x002fe200078e20ffULL, 0x00000004393c7824ULL, 0x004fca00078e00ffULL,
0x01cac0003c397984ULL, 0x000e640000000800ULL, 0x0000003922387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fc80007f3e0ffULL,
0x00000039ff397210ULL, 0x000fca0000ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000c101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000006f02417211ULL, 0x040fe200078fd8ffULL, 0x00000010023b7824ULL, 0x000fe400078e00ffULL,
0x00000200ff437424ULL, 0x000fe200078e00ffULL, 0x00000005413e7819ULL, 0x040fe200000006ffULL,
0x01ca000041397984ULL, 0x000e620000004800ULL, 0x00000001413a7824ULL, 0x000fe200078e0238ULL,
0x000001f03b457812ULL, 0x000fe200078ec0ffULL, 0x00000001413d7824ULL, 0x040fe200078e0202ULL,
0x00000001413f7810ULL, 0x000fca0007ffe0ffULL, 0x000000013f407824ULL, 0x000fe200078e0202ULL,
0x01cac00039397984ULL, 0x002e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe03e3a7812ULL, 0x000fc600078ee23dULL, 0x000000ffff3d7224ULL, 0x000fe200000e063bULL,
0x000180003a477811ULL, 0x000fe200078e20ffULL, 0x000000013f3a7824ULL, 0x040fe400078e0238ULL,
0x000000203f3f7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e6000b901c46ULL, 0xffffffe03f407812ULL, 0x000fe200078ee240ULL,
0x01ca040041397984ULL, 0x000ea60000004800ULL, 0x0001800040477811ULL, 0x002fc400078e20ffULL,
0x00000002413d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d407824ULL, 0x000fe200078e0202ULL,
0x01cac00039397984ULL, 0x004e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL,
0x000000013d3a7824ULL, 0x040fe400078e0238ULL, 0x000000203d3d7824ULL, 0x000fe200078e00ffULL,
0x0000003bff3f7210ULL, 0x000fc800007fe4ffULL, 0xffffffe03d407812ULL, 0x000fe200078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e8000b901c46ULL,
0x01ca080041397984ULL, 0x000ea20000004800ULL, 0x0001800040477811ULL, 0x002fe400078e20ffULL,
0x00000003413f7810ULL, 0x000fca0007ffe0ffULL, 0x000000013f407824ULL, 0x000fe200078e0202ULL,
0x01cac00039397984ULL, 0x004e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe40007f1e0ffULL,
0x000000383f3a7210ULL, 0x040fe20007ffe0ffULL, 0x000000203f3f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e063bULL, 0xffffffe03f407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000b901c46ULL,
0x01ca0c0041397984ULL, 0x000ea20000004800ULL, 0x0001800040477811ULL, 0x002fe400078e20ffULL,
0x00000004413d7810ULL, 0x000fc80007ffe0ffULL, 0x000000023d407210ULL, 0x000fe20007ffe0ffULL,
0x01cac00039397984ULL, 0x004e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL,
0x000000013d3a7824ULL, 0x040fe400078e0238ULL, 0x000000203d3d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fc600000e063bULL, 0xffffffe03d407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e8000b901c46ULL,
0x01ca100041397984ULL, 0x000ea20000004800ULL, 0x0001800040477811ULL, 0x002fe400078e20ffULL,
0x00000005413f7810ULL, 0x000fca0007ffe0ffULL, 0x000000013f407824ULL, 0x000fe200078e0202ULL,
0x01cac00039397984ULL, 0x004e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe20007f1e0ffULL,
0x000000013f3a7824ULL, 0x040fe200078e0238ULL, 0x000000053f3f7819ULL, 0x000fc600000006ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e063bULL, 0xffffffe03f407812ULL, 0x000fc800078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000b901c46ULL,
0x01ca140041397984ULL, 0x000ea20000004800ULL, 0x00018000403d7811ULL, 0x002fe400078e20ffULL,
0x0000000641477810ULL, 0x000fca0007ffe0ffULL, 0x00000001473c7824ULL, 0x000fe200078e0202ULL,
0x01cac00039397984ULL, 0x004e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fc600000e063bULL, 0xffffffe0473c7812ULL, 0x000fe400078ee23cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x01ca180041397984ULL, 0x000ea20000004800ULL, 0x000180003c3d7811ULL, 0x002fe400078e20ffULL,
0x00000007413f7810ULL, 0x000fca0007ffe0ffULL, 0x000000013f387824ULL, 0x040fe400078e0238ULL,
0x000000013f3e7824ULL, 0x040fe400078e0202ULL, 0x000000203f3f7824ULL, 0x000fca00078e00ffULL,
0xffffffe03f3e7812ULL, 0x000fe200078ee23eULL, 0x01cac00039397984ULL, 0x004e640000004800ULL,
0x00000039223a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3a7210ULL, 0x000fc80007f1e0ffULL, 0x0000003bff3b7210ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x01ca1c00413c7984ULL, 0x000ea20000004800ULL, 0x000180003e3b7811ULL, 0x002fc600078e20ffULL,
0x01cac0003c397984ULL, 0x004e640000004800ULL, 0x0000003922387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x0000004538387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff387f8cULL, 0x002e64000c80043fULL,
0x00000039003f7202ULL, 0x002fc40000000f00ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000356e00720cULL, 0x000fe20003f04070ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000000137377812ULL, 0x000fe400078ec0ffULL, 0x000000033600780cULL, 0x000fc80004705270ULL,
0x000000013700780cULL, 0x000fda0000705470ULL, 0x0000014000000947ULL, 0x000fea0003800000ULL,
0x000000032300780cULL, 0x000fe20003f24070ULL, 0x00000300ff377624ULL, 0x000fe200078e00ffULL,
0x000000016d387812ULL, 0x000fc800078ec0ffULL, 0x000000013800780cULL, 0x000fe40003f05070ULL,
0xffffffff37377811ULL, 0x000fc800078e08ffULL, 0x0000000137387807ULL, 0x000fc80004000000ULL,
0x000000386d6d7210ULL, 0x000fe20007ffe0ffULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0000000400377824ULL, 0x000fe200078e0223ULL, 0x000064006d387a10ULL, 0x040fe20007ffe0ffULL,
0x00000004ff397424ULL, 0x000fe200078e00ffULL, 0x000000726d00720cULL, 0x000fe20003f06070ULL,
0x0000000237377824ULL, 0x000fc800078e00ffULL, 0x0000640037387a24ULL, 0x000fe200078e0238ULL,
0x0001cac023377811ULL, 0x000fc600078e10ffULL, 0x0000600038387625ULL, 0x000fca00078e0039ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000017000004947ULL, 0x000fea0003800000ULL, 0x000000356e00720cULL, 0x000fe40003f04070ULL,
0x0000000136377810ULL, 0x002fc80007ffe0ffULL, 0x0000000337367812ULL, 0x000fce00078ec0ffULL,
0x00000002ff378819ULL, 0x000fca0000011637ULL, 0x0000000134347824ULL, 0x000fe200078e0237ULL,
0x0001ca0023377811ULL, 0x000fc800078e10ffULL, 0x00000002ff387819ULL, 0x000fe40000011634ULL,
0x0000000634347819ULL, 0x000fc600000006ffULL, 0x0000030038387a24ULL, 0x000fe200078e0235ULL,
0x000000c034357812ULL, 0x000fe400078ec0ffULL, 0x000000ff36347207ULL, 0x000fc60004000000ULL,
0x0000010038357824ULL, 0x000fe400078e0235ULL, 0x0000000173347824ULL, 0x000fe400078e0234ULL,
0x0000000123367824ULL, 0x140fe400078e0235ULL, 0x0000680034347a24ULL, 0x000fe400078e0235ULL,
0x00000004ff357424ULL, 0x000fe200078e00ffULL, 0x000000713600720cULL, 0x000fe40003f06070ULL,
0x0000003423347210ULL, 0x000fca0007ffe0ffULL, 0x0000660034347625ULL, 0x000fcc00078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01cb8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff8700720cULL, 0x000fe20003f05270ULL,
0x01cb8000ff847f8cULL, 0x000e62000c80043fULL, 0x000007d000017945ULL, 0x000ff60003800000ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01caf8006f347f8cULL, 0x000ea4000c80043fULL, 0x000000ffff3b7224ULL, 0x004fc400078e0035ULL,
0x0000000000347805ULL, 0x000fca0000015200ULL, 0x01cafc006f247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc4000780483bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634397210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011437ULL, 0x0000003924247211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000224247819ULL, 0x000fc80000001237ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x01cafc006f247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe4000780483bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000402247819ULL, 0x000fe400000006ffULL,
0x00000001ff347819ULL, 0x000fe40000011602ULL, 0x0000007024247812ULL, 0x000fe400078ec0ffULL,
0x0000000c34357812ULL, 0x000fca00078ec0ffULL, 0x00000001243a7824ULL, 0x000fca00078e0235ULL,
0x01c080003a367984ULL, 0x000ea80000000800ULL, 0x01c280003a387984ULL, 0x0006620000000800ULL,
0x000000333600720bULL, 0x004fe20003f1d000ULL, 0x0001dff27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x008fc800000e0100ULL, 0x0000ffff243e7812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff247424ULL, 0x000fe200078e00ffULL,
0x0000003300377202ULL, 0x000fd40000000f00ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000017500780cULL, 0x000fe40003f05270ULL, 0x000000333600720bULL, 0x000fe20003f34000ULL,
0x0001dfc27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000397806ULL, 0x000fc400008e0100ULL,
0x0000003633377209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991039347816ULL, 0x000fc600000000ffULL, 0x01c480373a008388ULL, 0x0005e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000003733337221ULL, 0x004fe20000010000ULL, 0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b33337820ULL, 0x000fc80000410000ULL,
0x00000033003d7308ULL, 0x000ea40000000800ULL, 0x0000003d21217220ULL, 0x004fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0001df227f007947ULL, 0x000fea000b800000ULL,
0x00001f783d337589ULL, 0x0004e400000e0000ULL, 0x0000003320207220ULL, 0x088fe40000410000ULL,
0x000000331f1f7220ULL, 0x080fe40000410000ULL, 0x000000331c1c7220ULL, 0x080fe40000410000ULL,
0x000000331b1b7220ULL, 0x080fe40000410000ULL, 0x0000003318187220ULL, 0x080fe40000410000ULL,
0x0000003317177220ULL, 0x000fc40000410000ULL, 0x0000003314147220ULL, 0x080fe40000410000ULL,
0x0000003313137220ULL, 0x080fe40000410000ULL, 0x0000003310107220ULL, 0x080fe40000410000ULL,
0x000000330f0f7220ULL, 0x080fe40000410000ULL, 0x000000330c0c7220ULL, 0x080fe40000410000ULL,
0x000000330b0b7220ULL, 0x000fc40000410000ULL, 0x0000003308087220ULL, 0x080fe40000410000ULL,
0x0000003307077220ULL, 0x080fe40000410000ULL, 0x0000003304047220ULL, 0x080fe40000410000ULL,
0x0000003303037220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0001de527f007947ULL, 0x000fea000b800000ULL, 0x00001f763d337589ULL, 0x0006a400000e0000ULL,
0x000000331e1e7220ULL, 0x084fe40000410000ULL, 0x000000331d1d7220ULL, 0x080fe40000410000ULL,
0x000000331a1a7220ULL, 0x080fe40000410000ULL, 0x0000003319197220ULL, 0x080fe40000410000ULL,
0x0000003316167220ULL, 0x080fe40000410000ULL, 0x0000003315157220ULL, 0x000fc40000410000ULL,
0x0000003312127220ULL, 0x080fe40000410000ULL, 0x0000003311117220ULL, 0x080fe40000410000ULL,
0x000000330e0e7220ULL, 0x080fe40000410000ULL, 0x000000330d0d7220ULL, 0x080fe40000410000ULL,
0x000000330a0a7220ULL, 0x080fe40000410000ULL, 0x0000003309097220ULL, 0x000fc40000410000ULL,
0x0000003306067220ULL, 0x080fe40000410000ULL, 0x0000003305057220ULL, 0x080fe40000410000ULL,
0x0000003331317220ULL, 0x080fe40000410000ULL, 0x0000003332327220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x004fea0003800000ULL, 0x0000ffff3eff7812ULL, 0x000fda0007806039ULL,
0x8000003736360221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL, 0x0000003600250308ULL, 0x000ea40000000800ULL,
0x0000002538380220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000002138217221ULL, 0x002fe40000010000ULL, 0x000000ffff337224ULL, 0x000fc400078e0037ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff24ff7812ULL, 0x000fe2000786c0ffULL,
0x0000016000017945ULL, 0x000fd80003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000010ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x0001dcb27f007947ULL, 0x000fea000b800000ULL, 0x00001f7837267589ULL, 0x0004e400000e0000ULL,
0x0001dd127f007947ULL, 0x000fea000b800000ULL, 0x00001f7637277589ULL, 0x0004e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010783b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0xffffffff003f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x0000a0b000347802ULL, 0x000fc40000000f00ULL,
0x0001ec0000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0037ULL, 0x00000018783b7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x0000a12000347802ULL, 0x000fe20000000f00ULL,
0xffffffffff3f7424ULL, 0x000fc400078e00ffULL, 0x0001eb9000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0001280028347811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002954783bULL, 0x000fe20000004200ULL,
0x000128002c387811ULL, 0x000fe200078e20ffULL, 0x000003b000017945ULL, 0x000fe20003800000ULL,
0x000000877800720cULL, 0x000fe20003f46070ULL, 0x000000003434783bULL, 0x004ea20000000200ULL,
0x000000776e00720cULL, 0x000fc40003fc3070ULL, 0x000000877600720cULL, 0x000fe20003f26070ULL,
0x000000002a5c783bULL, 0x000fe20000004200ULL, 0x000000776e00720cULL, 0x000fc60003f03070ULL,
0x000000002b64783bULL, 0x000fe80000004200ULL, 0x000000002d3c783bULL, 0x00afe80000004200ULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000002e40783bULL, 0x000ee80000004200ULL,
0x000000002f44783bULL, 0x000f280000004200ULL, 0x000000003048783bULL, 0x000ee80000004200ULL,
0x00000000744c783bULL, 0x000ee20000004200ULL, 0x000000263434b231ULL, 0x004fc400003400ffULL,
0x000000263636b231ULL, 0x000fe400003400ffULL, 0x000000273535b231ULL, 0x080fe400003400ffULL,
0x000000273737b231ULL, 0x000fce00003400ffULL, 0x000000543450723cULL, 0x000f6200000418ffULL,
0x000000263838b231ULL, 0x082fe400003400ffULL, 0x000000263a3ab231ULL, 0x000fe400003400ffULL,
0x000000273939b231ULL, 0x000fc600003400ffULL, 0x0000005c3458723cULL, 0x000fe200000418ffULL,
0x000000273b3bb231ULL, 0x000fce00003400ffULL, 0x000000643460723cULL, 0x040ff000000418ffULL,
0x000000563454723cULL, 0x040f7000000418ffULL, 0x0000005e345c723cULL, 0x040f7000000418ffULL,
0x000000663464723cULL, 0x040f7000000418ffULL, 0x0000003c3468723cULL, 0x040b6e00000418ffULL,
0x00000001873d7810ULL, 0x020fe20007ffe0ffULL, 0x0000003e3434723cULL, 0x000f6600000418ffULL,
0x0000003d7800720cULL, 0x000fc40005746470ULL, 0x0000003d7600720cULL, 0x000fc60004f26470ULL,
0x000000403850723cULL, 0x048b700000041850ULL, 0x000000423854723cULL, 0x040b700000041854ULL,
0x000000443858723cULL, 0x050b700000041858ULL, 0x00000046385c723cULL, 0x040b70000004185cULL,
0x000000483860723cULL, 0x040b700000041860ULL, 0x0000004a3864723cULL, 0x040b700000041864ULL,
0x0000004c3868723cULL, 0x040b700000041868ULL, 0x0000004e3834723cULL, 0x020b620000041834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000005020207221ULL, 0x000fe40000010000ULL, 0x000000511f1f7221ULL, 0x000fc40000010000ULL,
0x000000541c1c7221ULL, 0x000fe40000010000ULL, 0x000000551b1b7221ULL, 0x000fe40000010000ULL,
0x0000005818187221ULL, 0x000fe40000010000ULL, 0x0000005917177221ULL, 0x000fe40000010000ULL,
0x0000005c14147221ULL, 0x000fe40000010000ULL, 0x0000005d13137221ULL, 0x000fc40000010000ULL,
0x0000006010107221ULL, 0x000fe40000010000ULL, 0x000000610f0f7221ULL, 0x000fe40000010000ULL,
0x000000640c0c7221ULL, 0x000fe40000010000ULL, 0x000000650b0b7221ULL, 0x000fe40000010000ULL,
0x0000006808087221ULL, 0x000fe40000010000ULL, 0x0000006907077221ULL, 0x000fc40000010000ULL,
0x0000003404047221ULL, 0x020fe40000010000ULL, 0x0000003503037221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000521e1e7221ULL, 0x000fe40000010000ULL,
0x000000531d1d7221ULL, 0x000fe40000010000ULL, 0x000000561a1a7221ULL, 0x000fe40000010000ULL,
0x0000005719197221ULL, 0x000fe40000010000ULL, 0x0000005a16167221ULL, 0x000fc40000010000ULL,
0x0000005b15157221ULL, 0x000fe40000010000ULL, 0x0000005e12127221ULL, 0x000fe40000010000ULL,
0x0000005f11117221ULL, 0x000fe40000010000ULL, 0x000000620e0e7221ULL, 0x000fe40000010000ULL,
0x000000630d0d7221ULL, 0x000fe40000010000ULL, 0x000000660a0a7221ULL, 0x000fc40000010000ULL,
0x0000006709097221ULL, 0x000fe40000010000ULL, 0x0000006a06067221ULL, 0x000fe40000010000ULL,
0x0000006b05057221ULL, 0x000fe40000010000ULL, 0x0000003631317221ULL, 0x020fe40000010000ULL,
0x0000003732327221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff347f8cULL, 0x020e62000c80043fULL,
0x000000776e00720cULL, 0x0c0fe40003fc3070ULL, 0x000000776e00720cULL, 0x000fc40003f03070ULL,
0x00000040ff407803ULL, 0x000fe40000000000ULL, 0x00000002ff347819ULL, 0x002fe2000001163dULL,
0x000000ffff3c7224ULL, 0x000fc600078e0035ULL, 0x000000343d347207ULL, 0x000fc80002800000ULL,
0x0000000134367810ULL, 0x000fe40007ffe0ffULL, 0x000000033d347812ULL, 0x000fe400078ec0ffULL,
0x00000002ff387819ULL, 0x000fe40000011636ULL, 0x000000ff003d7202ULL, 0x000fe40000000f00ULL,
0x000000ff34347207ULL, 0x000fe20006800000ULL, 0x0000030038357a24ULL, 0x000fe200078e0277ULL,
0x0000000336367812ULL, 0x000fc400078ec0ffULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8400ff3a7984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c4885ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc8000001143bULL, 0x0000003a37377211ULL, 0x000fca00078d10ffULL,
0x000000ffff3a7224ULL, 0x000fca00030e063bULL, 0x0000000237377819ULL, 0x000fc8000000123aULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb8400ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c4885ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x01cb8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000037ff7812ULL, 0x002fe200078c483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fc800078d10ffULL, 0x0000003bff3a7210ULL, 0x000fc800037fe4ffULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe400078c483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000435377824ULL, 0x000fe200078e0236ULL, 0x0000121000017945ULL, 0x000fe60003800000ULL,
0x0000004037427824ULL, 0x000fe200078e00ffULL, 0x0000000135377810ULL, 0x000fc80007ffe0ffULL,
0x000000703700720cULL, 0x000fe40003fc6070ULL, 0x000000406c387812ULL, 0x000fd600078ef842ULL,
0x000009800000e947ULL, 0x000fea0003800000ULL, 0x000000046f417824ULL, 0x040fe200078e00ffULL,
0x000000386f397210ULL, 0x040fe20007ffe0ffULL, 0x00000200ff437424ULL, 0x000fe200078e00ffULL,
0x000000016f497810ULL, 0x000fe40007ffe0ffULL, 0x01ca000041377984ULL, 0x000e640000000800ULL,
0x00000004373e7824ULL, 0x002fca00078e00ffULL, 0x01cac0003e377984ULL, 0x0002a40000000800ULL,
0x000000206f3e7824ULL, 0x002fe400078e00ffULL, 0x0000003722377224ULL, 0x004fe400078e0239ULL,
0x0000001002397824ULL, 0x000fe400078e00ffULL, 0x00005e00373a7625ULL, 0x000fe200078e0043ULL,
0x0000004271377217ULL, 0x000fe40007800000ULL, 0x000001f039457812ULL, 0x000fc800078ec0ffULL,
0x000000453a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000001373a7824ULL, 0x000fe200078e0a42ULL,
0x000000026f377210ULL, 0x000fc60007ffe0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e063bULL,
0x0000003a6f3a7217ULL, 0x000fe40007800000ULL, 0xffffffe03e397812ULL, 0x000fc600078ee237ULL,
0x000000013a377824ULL, 0x000fe200078e0a6fULL, 0x0001400039477811ULL, 0x000fe200078e20ffULL,
0x00000001493a7824ULL, 0x000fc600078e0238ULL, 0x000000ff3700720cULL, 0x000fda0003fc3070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000f101c46ULL,
0x01ca040041397984ULL, 0x000ea40000000800ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000ea40000000800ULL, 0x00000039223a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe200078e00ffULL,
0x0000003bff3f7210ULL, 0x000fe400037fe4ffULL, 0x000000013700780cULL, 0x000fe40003fc3070ULL,
0xffffffe0493a7812ULL, 0x000fe400078ee23aULL, 0x000000026f497810ULL, 0x000fc40007ffe0ffULL,
0x000140003a477811ULL, 0x002fc600078e20ffULL, 0x00000001493a7824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e8000f101c46ULL,
0x01ca080041397984ULL, 0x000ea40000000800ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000ea40000000800ULL, 0x00000039223a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe20007fde0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe200078e00ffULL,
0x0000003bff3d7210ULL, 0x000fe400037fe4ffULL, 0x000000023700780cULL, 0x000fe40003fc3070ULL,
0xffffffe0493a7812ULL, 0x000fe400078ee23aULL, 0x000000036f497810ULL, 0x000fc40007ffe0ffULL,
0x000140003a477811ULL, 0x002fc600078e20ffULL, 0x00000001493a7824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000f101c46ULL,
0x01ca0c0041397984ULL, 0x000ea40000000800ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000ea40000000800ULL, 0x00000039223a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe200078e00ffULL,
0x0000003bff3f7210ULL, 0x000fe400037fe4ffULL, 0x000000033700780cULL, 0x000fe40003fc3070ULL,
0xffffffe0493a7812ULL, 0x000fe400078ee23aULL, 0x000000046f497810ULL, 0x000fc40007ffe0ffULL,
0x000140003a477811ULL, 0x002fc600078e20ffULL, 0x00000001493a7824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e8000f101c46ULL,
0x01ca100041397984ULL, 0x000ea40000000800ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000ea40000000800ULL, 0x00000039223a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe20007fde0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe200078e00ffULL,
0x0000003bff3d7210ULL, 0x000fe400037fe4ffULL, 0x000000043700780cULL, 0x000fe40003fc3070ULL,
0xffffffe0493a7812ULL, 0x000fe400078ee23aULL, 0x000000056f497810ULL, 0x000fc40007ffe0ffULL,
0x000140003a477811ULL, 0x002fc600078e20ffULL, 0x00000001493a7824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000f101c46ULL,
0x01ca140041397984ULL, 0x000ea20000000800ULL, 0x000000066f477810ULL, 0x002fca0007ffe0ffULL,
0x00000001473c7824ULL, 0x000fe400078e0202ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe200078e00ffULL,
0x0000003bff3f7210ULL, 0x000fe400037fe4ffULL, 0x000000053700780cULL, 0x000fe40003fc3070ULL,
0xffffffe0493a7812ULL, 0x000fc800078ee23aULL, 0x000140003a3d7811ULL, 0x000fe200078e20ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fc800078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e2000f101c46ULL,
0xffffffe0473c7812ULL, 0x000fc600078ee23cULL, 0x01ca180041397984ULL, 0x000ea20000000800ULL,
0x000140003c3d7811ULL, 0x002fe400078e20ffULL, 0x000000076f3f7810ULL, 0x000fca0007ffe0ffULL,
0x000000013f387824ULL, 0x040fe400078e0238ULL, 0x000000013f3e7824ULL, 0x040fe400078e0202ULL,
0x000000203f3f7824ULL, 0x000fca00078e00ffULL, 0xffffffe03f3e7812ULL, 0x000fe200078ee23eULL,
0x0000000439397824ULL, 0x004fcc00078e00ffULL, 0x01cac00039397984ULL, 0x000e640000000800ULL,
0x00000039223a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3a7210ULL, 0x000fc80007fde0ffULL, 0x0000003bff3b7210ULL, 0x000fe400037fe4ffULL,
0x000000063700780cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000f101c46ULL, 0x01ca1c0041397984ULL, 0x000ea20000000800ULL,
0x000140003e3b7811ULL, 0x002fe200078e20ffULL, 0x00000004393c7824ULL, 0x004fca00078e00ffULL,
0x01cac0003c397984ULL, 0x000e640000000800ULL, 0x0000003922387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x0000004538387210ULL, 0x000fc80007fde0ffULL,
0x00000039ff397210ULL, 0x000fe400037fe4ffULL, 0x000000073700780cULL, 0x000fda0003fc3070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e2000f101c46ULL,
0x0000083000007947ULL, 0x000fea0003800000ULL, 0x0000006f02417211ULL, 0x040fe200078fd8ffULL,
0x00000200ff427424ULL, 0x000fe200078e00ffULL, 0x00000004023c7819ULL, 0x000fe400000006ffULL,
0x0000000141477810ULL, 0x040fe20007ffe0ffULL, 0x01ca000041377984ULL, 0x000e620000004800ULL,
0x0000000141397824ULL, 0x000fe200078e0238ULL, 0x000001f03c437812ULL, 0x000fe400078ec0ffULL,
0x01cac00037377984ULL, 0x002e640000004800ULL, 0x0000003722397224ULL, 0x002fc800078e0239ULL,
0x00005e00393a7625ULL, 0x000fc800078e0042ULL, 0x0000000141397824ULL, 0x040fe200078e0202ULL,
0x000000433a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000020413a7824ULL, 0x000fc800078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x000fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca040041377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722397224ULL, 0x004fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fc800078e0042ULL,
0x0000000147397824ULL, 0x040fe200078e0202ULL, 0x000000433a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000020473a7824ULL, 0x000fe200078e00ffULL, 0x0000000241477810ULL, 0x000fe40007ffe0ffULL,
0x0000003bff3f7210ULL, 0x000fe400037fe4ffULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x002fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e457faeULL, 0x0003e8000b901c46ULL,
0x01ca080041377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722397224ULL, 0x004fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fe200078e0042ULL,
0x0000000247397210ULL, 0x000fc80007ffe0ffULL, 0x000000433a3c7210ULL, 0x000fe20007fde0ffULL,
0x00000020473a7824ULL, 0x000fe200078e00ffULL, 0x0000000341477810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x002fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca0c0041377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722397224ULL, 0x004fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fc800078e0042ULL,
0x0000000147397824ULL, 0x040fe200078e0202ULL, 0x000000433a3e7210ULL, 0x000fe40007fde0ffULL,
0x00000005473a7819ULL, 0x000fe400000006ffULL, 0x0000000441477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x002fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e457faeULL, 0x0003e8000b901c46ULL,
0x01ca100041377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722397224ULL, 0x004fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fc800078e0042ULL,
0x0000000147397824ULL, 0x040fe200078e0202ULL, 0x000000433a3c7210ULL, 0x000fe20007fde0ffULL,
0x00000020473a7824ULL, 0x000fe200078e00ffULL, 0x0000000541477810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x002fe400078e20ffULL, 0x0000003847397210ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca140041377984ULL, 0x000ea20000004800ULL, 0x0000000641457810ULL, 0x002fca0007ffe0ffULL,
0x00000020453c7824ULL, 0x000fe200078e00ffULL, 0x01cac00037377984ULL, 0x004e640000004800ULL,
0x0000003722397224ULL, 0x002fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fc800078e0042ULL,
0x0000000147397824ULL, 0x040fe200078e0202ULL, 0x000000433a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000020473a7824ULL, 0x000fc800078e00ffULL, 0x000000ffff3f7224ULL, 0x000fe200030e063bULL,
0xffffffe03a397812ULL, 0x000fc800078ee239ULL, 0x00014000393d7811ULL, 0x000fe200078e20ffULL,
0x0000000145397824ULL, 0x000fc800078e0238ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e3d7faeULL, 0x0003e8000b901c46ULL, 0x01ca180041377984ULL, 0x000ea20000004800ULL,
0x00000007413f7810ULL, 0x002fca0007ffe0ffULL, 0x000000013f387824ULL, 0x000fe200078e0238ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722397224ULL, 0x002fc800078e0239ULL,
0x00005e00393a7625ULL, 0x000fc800078e0042ULL, 0x0000000145397824ULL, 0x000fe200078e0202ULL,
0x000000433a3a7210ULL, 0x000fc80007fde0ffULL, 0xffffffe03c397812ULL, 0x000fe400078ee239ULL,
0x0000003bff3b7210ULL, 0x000fe400037fe4ffULL, 0x00014000393d7811ULL, 0x000fe400078e20ffULL,
0x000000023f3c7210ULL, 0x040fe20007ffe0ffULL, 0x000000203f3f7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e6000b901c46ULL,
0xffffffe03f3c7812ULL, 0x000fe200078ee23cULL, 0x01ca1c0041377984ULL, 0x000ea60000004800ULL,
0x000140003c3b7811ULL, 0x002fe200078e20ffULL, 0x01cac00037377984ULL, 0x004e640000004800ULL,
0x0000003722387224ULL, 0x002fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0042ULL,
0x0000004338387210ULL, 0x000fca0007fde0ffULL, 0x000000ffff397224ULL, 0x000fca00030e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e6000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb8800ff387f8cULL, 0x002e64000c80043fULL, 0x000000ffff3c7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x01cb8c00ff377984ULL, 0x000e620000000800ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000037ff7812ULL, 0x002fe200078c483cULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc8000001143bULL, 0x0000003a37377211ULL, 0x000fc800078d10ffULL,
0x0000003bff3a7210ULL, 0x000fc800037fe4ffULL, 0x0000000237377819ULL, 0x000fc8000000123aULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb8c00ff377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe400078c483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000356e00720cULL, 0x000fc80003fc4070ULL,
0x000000ff34377207ULL, 0x040fe40003000000ULL, 0x000000ff34387207ULL, 0x000fc60007000000ULL,
0x0000000136377824ULL, 0x000fca00078e0237ULL, 0x00000002ff347819ULL, 0x000fe20000011637ULL,
0x0000004037377824ULL, 0x000fc800078e00ffULL, 0x0000030034347a24ULL, 0x000fe200078e0235ULL,
0x000000c037377812ULL, 0x000fe200078ec0ffULL, 0x0000000173357824ULL, 0x000fc800078e0238ULL,
0x0000010034347824ULL, 0x000fe200078e0237ULL, 0x0001ca0023377811ULL, 0x000fc800078e10ffULL,
0x0000002034367810ULL, 0x000fca0007ffe0ffULL, 0x0000680035347a24ULL, 0x100fe200078e0236ULL,
0x0000000400357802ULL, 0x000fe20000000f00ULL, 0x0000000123367824ULL, 0x040fe400078e0236ULL,
0x0000000123347824ULL, 0x000fc600078e0234ULL, 0x000000713600720cULL, 0x000fe20003fc6070ULL,
0x0000660034347625ULL, 0x000fd800078e0035ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034377faeULL, 0x0003e4000f121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01cb7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb7800ff847f8cULL, 0x000e62000c80043fULL, 0x0000016000017945ULL, 0x000fe20003800000ULL,
0x0000014000003947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000010ffULL,
0x0000541026377816ULL, 0x000fe20000000026ULL, 0x0001baa27f007947ULL, 0x000fea000b800000ULL,
0x00001f7837267589ULL, 0x0004e400000e0000ULL, 0x0001bb027f007947ULL, 0x000fea000b800000ULL,
0x00001f7637277589ULL, 0x0004e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010783b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0037ULL,
0xffffffff003f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fe200078e00ffULL,
0x0000c3c000347802ULL, 0x000fc40000000f00ULL, 0x0001c8f000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0037ULL,
0x00000018783b7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff3c7424ULL, 0x000fe200078e00ffULL,
0x0000c43000347802ULL, 0x000fe20000000f00ULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x0001c88000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0001280082347811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000008154783bULL, 0x000fe20000004200ULL, 0x000128007d387811ULL, 0x000fe200078e20ffULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x000000ff4000720cULL, 0x000fe20003fc5270ULL,
0x000000003434783bULL, 0x004ea80000000200ULL, 0x00000000805c783bULL, 0x000fe80000004200ULL,
0x000000007f64783bULL, 0x000fe80000004200ULL, 0x000000007e3c783bULL, 0x002fe80000004200ULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000007c40783bULL, 0x000f280000004200ULL,
0x000000007b44783bULL, 0x000ee80000004200ULL, 0x000000007a48783bULL, 0x000ee80000004200ULL,
0x00000000794c783bULL, 0x000ee40000004200ULL, 0x000000263434b231ULL, 0x00cfc400003400ffULL,
0x000000263636b231ULL, 0x000fe400003400ffULL, 0x000000273535b231ULL, 0x080fe400003400ffULL,
0x000000273737b231ULL, 0x000fce00003400ffULL, 0x000000543450723cULL, 0x000f6200000418ffULL,
0x000000263838b231ULL, 0x082fe400003400ffULL, 0x000000263a3ab231ULL, 0x000fe400003400ffULL,
0x000000273939b231ULL, 0x000fc600003400ffULL, 0x0000005c3458723cULL, 0x000fe200000418ffULL,
0x000000273b3bb231ULL, 0x000fce00003400ffULL, 0x000000643460723cULL, 0x040ff000000418ffULL,
0x000000563454723cULL, 0x040f7000000418ffULL, 0x0000005e345c723cULL, 0x040f7000000418ffULL,
0x000000663464723cULL, 0x040f7000000418ffULL, 0x0000003c3468723cULL, 0x040f7000000418ffULL,
0x0000003e3434723cULL, 0x000f7000000418ffULL, 0x000000403850723cULL, 0x070b700000041850ULL,
0x000000423854723cULL, 0x040b700000041854ULL, 0x000000443858723cULL, 0x040b700000041858ULL,
0x00000046385c723cULL, 0x040b70000004185cULL, 0x000000483860723cULL, 0x040b700000041860ULL,
0x0000004a3864723cULL, 0x040b700000041864ULL, 0x0000004c3868723cULL, 0x040b700000041868ULL,
0x0000004e3834723cULL, 0x000b620000041834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000005020207221ULL, 0x020fe40000010000ULL,
0x000000511f1f7221ULL, 0x000fc40000010000ULL, 0x000000541c1c7221ULL, 0x000fe40000010000ULL,
0x000000551b1b7221ULL, 0x000fe40000010000ULL, 0x0000005818187221ULL, 0x000fe40000010000ULL,
0x0000005917177221ULL, 0x000fe40000010000ULL, 0x0000005c14147221ULL, 0x000fe40000010000ULL,
0x0000005d13137221ULL, 0x000fc40000010000ULL, 0x0000006010107221ULL, 0x000fe40000010000ULL,
0x000000610f0f7221ULL, 0x000fe40000010000ULL, 0x000000640c0c7221ULL, 0x000fe40000010000ULL,
0x000000650b0b7221ULL, 0x000fe40000010000ULL, 0x0000006808087221ULL, 0x000fe40000010000ULL,
0x0000006907077221ULL, 0x000fc40000010000ULL, 0x0000003404047221ULL, 0x000fe40000010000ULL,
0x0000003503037221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000521e1e7221ULL, 0x020fe40000010000ULL, 0x000000531d1d7221ULL, 0x000fe40000010000ULL,
0x000000561a1a7221ULL, 0x000fe40000010000ULL, 0x0000005719197221ULL, 0x000fe40000010000ULL,
0x0000005a16167221ULL, 0x000fc40000010000ULL, 0x0000005b15157221ULL, 0x000fe40000010000ULL,
0x0000005e12127221ULL, 0x000fe40000010000ULL, 0x0000005f11117221ULL, 0x000fe40000010000ULL,
0x000000620e0e7221ULL, 0x000fe40000010000ULL, 0x000000630d0d7221ULL, 0x000fe40000010000ULL,
0x000000660a0a7221ULL, 0x000fc40000010000ULL, 0x0000006709097221ULL, 0x000fe40000010000ULL,
0x0000006a06067221ULL, 0x000fe40000010000ULL, 0x0000006b05057221ULL, 0x000fe40000010000ULL,
0x0000003631317221ULL, 0x000fe40000010000ULL, 0x0000003732327221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000187877810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff347f8cULL, 0x020e62000c80043fULL,
0x000000838700720cULL, 0x000fe20003f06070ULL, 0x000000ffff3c7224ULL, 0x002fd800078e0035ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffb06000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008077347811ULL, 0x000fe200078e40ffULL,
0x01cb6000ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000713400720cULL, 0x000fda0003f06070ULL,
0x0000a05000000947ULL, 0x000fea0003800000ULL, 0x000000ff00877202ULL, 0x000fc80000000f00ULL,
0x00000002ff347819ULL, 0x000fe20000011687ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000387367812ULL, 0x040fe200078ec0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x0000003487347207ULL, 0x000fe40002800000ULL, 0x000000ff36367207ULL, 0x000fe40006800000ULL,
0x0000000234377810ULL, 0x000fc80007ffe0ffULL, 0x00000002ff387819ULL, 0x000fe40000011637ULL,
0x0000000337347812ULL, 0x000fc600078ec0ffULL, 0x0000030038357a24ULL, 0x000fc400078e0277ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x01cb7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804885ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804885ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x01cb8c00ff3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fc80007f1e1ffULL, 0x0000003b393b7210ULL, 0x000fe400007fe5ffULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb8c00ff3b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000135397810ULL, 0x040fe20007ffe0ffULL,
0x0000000435387824ULL, 0x000fe200078e0234ULL, 0x0000120000017945ULL, 0x000fe40003800000ULL,
0x000000703900720cULL, 0x000fe40003f06070ULL, 0x00000020383a7811ULL, 0x000fc800078e30ffULL,
0x000000606c387812ULL, 0x000fce00078ef83aULL, 0x0000098000008947ULL, 0x000fea0003800000ULL,
0x000000046f3f7824ULL, 0x040fe200078e00ffULL, 0x000000386f3c7210ULL, 0x040fe20007ffe0ffULL,
0x00000200ff417424ULL, 0x000fe200078e00ffULL, 0x000000016f477810ULL, 0x040fe20007ffe0ffULL,
0x000000016f407824ULL, 0x040fe200078e0202ULL, 0x01ca00003f397984ULL, 0x000e620000000800ULL,
0x000000206f457824ULL, 0x000fca00078e00ffULL, 0xffffffe045407812ULL, 0x000fc800078ee240ULL,
0x0001800040457811ULL, 0x000fe400078e20ffULL, 0x0000000247407210ULL, 0x000fe20007ffe0ffULL,
0x00000004393d7824ULL, 0x002fe200078e00ffULL, 0x0000003a71397217ULL, 0x000fc80007800000ULL,
0x01cac0003d3b7984ULL, 0x000e620000000800ULL, 0x00000001393a7824ULL, 0x000fe400078e0a3aULL,
0x0000001002397824ULL, 0x000fc600078e00ffULL, 0x0000003a6f3a7217ULL, 0x000fe40007800000ULL,
0x000001f039437812ULL, 0x000fe400078ec0ffULL, 0x0000003a6f3e7210ULL, 0x000fc80007ffe1ffULL,
0x000000ff3e00720cULL, 0x000fe20003f03070ULL, 0x0000003b223b7224ULL, 0x002fc800078e023cULL,
0x00005e003b3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600008e063bULL, 0xffffffe047407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000013e00780cULL, 0x000fe40003f03070ULL, 0x000000026f477810ULL, 0x000fe20007ffe0ffULL,
0x01ca04003f397984ULL, 0x000ea20000000800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x0000000247407210ULL, 0x000fe20007ffe0ffULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600008e063bULL, 0xffffffe047407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000023e00780cULL, 0x000fe40003f03070ULL, 0x000000036f477810ULL, 0x000fe20007ffe0ffULL,
0x01ca08003f397984ULL, 0x000ea20000000800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x0000000247407210ULL, 0x000fe20007ffe0ffULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600008e063bULL, 0xffffffe047407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000033e00780cULL, 0x000fe40003f03070ULL, 0x000000046f477810ULL, 0x000fe20007ffe0ffULL,
0x01ca0c003f397984ULL, 0x000ea20000000800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x0000000247407210ULL, 0x000fe20007ffe0ffULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600008e063bULL, 0xffffffe047407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000043e00780cULL, 0x000fe40003f03070ULL, 0x000000056f477810ULL, 0x000fe20007ffe0ffULL,
0x01ca10003f397984ULL, 0x000ea20000000800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x0000000247407210ULL, 0x000fe20007ffe0ffULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600008e063bULL, 0xffffffe047407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000053e00780cULL, 0x000fe40003f03070ULL, 0x000000066f477810ULL, 0x000fe20007ffe0ffULL,
0x01ca14003f397984ULL, 0x000ea20000000800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x0000000247407210ULL, 0x000fe20007ffe0ffULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600008e063bULL, 0xffffffe047407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000063e00780cULL, 0x000fc60003f03070ULL, 0x01ca18003f397984ULL, 0x000ea20000000800ULL,
0x00018000403d7811ULL, 0x002fe400078e20ffULL, 0x000000076f457810ULL, 0x000fc80007ffe0ffULL,
0x0000000245407210ULL, 0x040fe20007ffe0ffULL, 0x0000000145387824ULL, 0x040fe400078e0238ULL,
0x0000002045457824ULL, 0x000fca00078e00ffULL, 0xffffffe045407812ULL, 0x000fe200078ee240ULL,
0x0000000439397824ULL, 0x004fcc00078e00ffULL, 0x01cac00039397984ULL, 0x000e640000000800ULL,
0x00000039223a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0041ULL,
0x000000433a3a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e2000c101c46ULL,
0x000000073e00780cULL, 0x000fc60003f03070ULL, 0x01ca1c003f397984ULL, 0x000ea20000000800ULL,
0x00018000403b7811ULL, 0x002fe200078e20ffULL, 0x00000004393c7824ULL, 0x004fca00078e00ffULL,
0x01cac0003c397984ULL, 0x000e640000000800ULL, 0x0000003922387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff397224ULL, 0x000fca00008e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000c101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000006f02417211ULL, 0x040fe200078fd8ffULL, 0x00000010023b7824ULL, 0x000fe200078e00ffULL,
0x0000020000437802ULL, 0x000fe40000000f00ULL, 0x00000001413f7810ULL, 0x040fe20007ffe0ffULL,
0x01ca000041397984ULL, 0x000e620000004800ULL, 0x00000001413a7824ULL, 0x000fe200078e0238ULL,
0x000001f03b457812ULL, 0x000fe200078ec0ffULL, 0x00000001413d7824ULL, 0x000fe200078e0202ULL,
0x000000023f407210ULL, 0x000fe20007ffe0ffULL, 0x00000020413e7824ULL, 0x000fe200078e00ffULL,
0x01cac00039397984ULL, 0x002e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe03e3a7812ULL, 0x000fc600078ee23dULL, 0x000000ffff3d7224ULL, 0x000fe200000e063bULL,
0x000180003a477811ULL, 0x000fe200078e20ffULL, 0x000000013f3a7824ULL, 0x040fe400078e0238ULL,
0x000000203f3f7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e6000b901c46ULL, 0xffffffe03f407812ULL, 0x000fe200078ee240ULL,
0x01ca040041397984ULL, 0x000ea60000004800ULL, 0x0001800040477811ULL, 0x002fc400078e20ffULL,
0x00000002413d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d407824ULL, 0x000fe200078e0202ULL,
0x01cac00039397984ULL, 0x004e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL,
0x000000013d3a7824ULL, 0x040fe200078e0238ULL, 0x000000053d3d7819ULL, 0x000fc600000006ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063bULL, 0xffffffe03d407812ULL, 0x000fc800078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e8000b901c46ULL,
0x01ca080041397984ULL, 0x000ea20000004800ULL, 0x0001800040477811ULL, 0x002fe400078e20ffULL,
0x00000003413f7810ULL, 0x000fca0007ffe0ffULL, 0x000000013f407824ULL, 0x000fe200078e0202ULL,
0x01cac00039397984ULL, 0x004e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe20007f1e0ffULL,
0x000000013f3a7824ULL, 0x040fe400078e0238ULL, 0x000000203f3f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e063bULL, 0xffffffe03f407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000b901c46ULL,
0x01ca0c0041397984ULL, 0x000ea20000004800ULL, 0x0001800040477811ULL, 0x002fe400078e20ffULL,
0x00000004413d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d407824ULL, 0x000fe200078e0202ULL,
0x01cac00039397984ULL, 0x004e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL,
0x000000013d3a7824ULL, 0x040fe400078e0238ULL, 0x000000203d3d7824ULL, 0x000fe200078e00ffULL,
0x0000003bff3f7210ULL, 0x000fc800007fe4ffULL, 0xffffffe03d407812ULL, 0x000fe200078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e8000b901c46ULL,
0x01ca100041397984ULL, 0x000ea20000004800ULL, 0x0001800040477811ULL, 0x002fe400078e20ffULL,
0x00000005413f7810ULL, 0x000fca0007ffe0ffULL, 0x000000013f407824ULL, 0x000fe200078e0202ULL,
0x01cac00039397984ULL, 0x004e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe40007f1e0ffULL,
0x000000383f3a7210ULL, 0x040fe20007ffe0ffULL, 0x000000203f3f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e063bULL, 0xffffffe03f407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000b901c46ULL,
0x01ca140041397984ULL, 0x000ea20000004800ULL, 0x00018000403d7811ULL, 0x002fe400078e20ffULL,
0x0000000641477810ULL, 0x000fc80007ffe0ffULL, 0x00000002473c7210ULL, 0x000fe20007ffe0ffULL,
0x01cac00039397984ULL, 0x004e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fc600000e063bULL, 0xffffffe0473c7812ULL, 0x000fe400078ee23cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x01ca180041397984ULL, 0x000ea20000004800ULL, 0x000180003c3d7811ULL, 0x002fe400078e20ffULL,
0x00000007413f7810ULL, 0x000fca0007ffe0ffULL, 0x000000013f387824ULL, 0x040fe400078e0238ULL,
0x000000013f3e7824ULL, 0x040fe200078e0202ULL, 0x000000053f3f7819ULL, 0x000fc800000006ffULL,
0xffffffe03f3e7812ULL, 0x000fe200078ee23eULL, 0x01cac00039397984ULL, 0x004e640000004800ULL,
0x00000039223a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x01ca1c00413c7984ULL, 0x000ea20000004800ULL, 0x000180003e3b7811ULL, 0x002fc600078e20ffULL,
0x01cac0003c397984ULL, 0x004e640000004800ULL, 0x0000003922387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x0000004538387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3f7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fc800078110ffULL, 0x0000003bff3b7210ULL, 0x000fc800007fe4ffULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000356e00720cULL, 0x000fe20003f04070ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000000137377812ULL, 0x000fe400078ec0ffULL, 0x000000033600780cULL, 0x000fc80004705270ULL,
0x000000013700780cULL, 0x000fda0000705470ULL, 0x0000014000000947ULL, 0x000fea0003800000ULL,
0x000000032300780cULL, 0x000fe20003f24070ULL, 0x00000300ff377624ULL, 0x000fe200078e00ffULL,
0x000000016d387812ULL, 0x000fc800078ec0ffULL, 0x000000013800780cULL, 0x000fe40003f05070ULL,
0xffffffff37377811ULL, 0x000fc800078e08ffULL, 0x0000000137387807ULL, 0x000fca0004000000ULL,
0x000000016d6d7824ULL, 0x000fe200078e0238ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0000000400377824ULL, 0x000fe200078e0223ULL, 0x000064006d387a10ULL, 0x040fe40007ffe0ffULL,
0x000000726d00720cULL, 0x000fe20003f06070ULL, 0x0000000237377824ULL, 0x000fe200078e00ffULL,
0x0000000400397802ULL, 0x000fc60000000f00ULL, 0x0000640037387a24ULL, 0x000fe200078e0238ULL,
0x0001cac023377811ULL, 0x000fc600078e10ffULL, 0x0000600038387625ULL, 0x000fca00078e0039ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000017000004947ULL, 0x000fea0003800000ULL, 0x000000356e00720cULL, 0x000fe40003f04070ULL,
0x0000000136377810ULL, 0x002fc80007ffe0ffULL, 0x0000000337367812ULL, 0x000fce00078ec0ffULL,
0x00000002ff378819ULL, 0x000fca0000011637ULL, 0x0000000134347824ULL, 0x000fe200078e0237ULL,
0x0001ca0023377811ULL, 0x000fc800078e10ffULL, 0x00000002ff387819ULL, 0x000fe20000011634ULL,
0x0000004034347824ULL, 0x000fc800078e00ffULL, 0x0000030038387a24ULL, 0x000fe200078e0235ULL,
0x000000c034357812ULL, 0x000fe400078ec0ffULL, 0x000000ff36347207ULL, 0x000fc60004000000ULL,
0x0000010038357824ULL, 0x000fe400078e0235ULL, 0x0000000173347824ULL, 0x000fc600078e0234ULL,
0x0000003523367210ULL, 0x040fe20007ffe0ffULL, 0x0000680034347a24ULL, 0x000fe400078e0235ULL,
0x00000004ff357424ULL, 0x000fe200078e00ffULL, 0x000000713600720cULL, 0x000fe20003f06070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01cb8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff8700720cULL, 0x000fe20003f05270ULL,
0x01cb8000ff847f8cULL, 0x000e62000c80043fULL, 0x000007d000017945ULL, 0x000ff60003800000ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb18006f347f8cULL, 0x000ea4000c80043fULL, 0x000000ffff3b7224ULL, 0x004fc400078e0035ULL,
0x0000000000347805ULL, 0x000fca0000015200ULL, 0x01cb1c006f247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc4000780483bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634397210ULL, 0x000fc80007f1e1ffULL, 0x0000003735377210ULL, 0x000fe400007fe5ffULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011437ULL, 0x0000003924247211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000224247819ULL, 0x000fc80000001237ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x01cb1c006f247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe4000780483bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001002247824ULL, 0x000fe200078e00ffULL,
0x00000001ff347819ULL, 0x000fc80000011602ULL, 0x0000007024247812ULL, 0x000fe400078ec0ffULL,
0x0000000c34357812ULL, 0x000fca00078ec0ffULL, 0x00000001243a7824ULL, 0x000fca00078e0235ULL,
0x01c100003a367984ULL, 0x000ea80000000800ULL, 0x01c300003a387984ULL, 0x0006620000000800ULL,
0x000000333600720bULL, 0x004fe20003f1d000ULL, 0x000193627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x008fc800000e0100ULL, 0x0000ffff243e7812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff247424ULL, 0x000fe400078e00ffULL,
0x000000ffff377224ULL, 0x000fd200078e0033ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000027500780cULL, 0x000fe40003f05270ULL, 0x000000333600720bULL, 0x000fe20003f34000ULL,
0x000193327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000397806ULL, 0x000fc400008e0100ULL,
0x0000003633377209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991039347816ULL, 0x000fc600000000ffULL, 0x01c500373a008388ULL, 0x0005e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000003733337221ULL, 0x004fe20000010000ULL, 0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b33337820ULL, 0x000fc80000410000ULL,
0x00000033003d7308ULL, 0x000ea40000000800ULL, 0x0000003d21217220ULL, 0x004fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000192927f007947ULL, 0x000fea000b800000ULL,
0x00001f783d337589ULL, 0x0004e400000e0000ULL, 0x0000003320207220ULL, 0x088fe40000410000ULL,
0x000000331f1f7220ULL, 0x080fe40000410000ULL, 0x000000331c1c7220ULL, 0x080fe40000410000ULL,
0x000000331b1b7220ULL, 0x080fe40000410000ULL, 0x0000003318187220ULL, 0x080fe40000410000ULL,
0x0000003317177220ULL, 0x000fc40000410000ULL, 0x0000003314147220ULL, 0x080fe40000410000ULL,
0x0000003313137220ULL, 0x080fe40000410000ULL, 0x0000003310107220ULL, 0x080fe40000410000ULL,
0x000000330f0f7220ULL, 0x080fe40000410000ULL, 0x000000330c0c7220ULL, 0x080fe40000410000ULL,
0x000000330b0b7220ULL, 0x000fc40000410000ULL, 0x0000003308087220ULL, 0x080fe40000410000ULL,
0x0000003307077220ULL, 0x080fe40000410000ULL, 0x0000003304047220ULL, 0x080fe40000410000ULL,
0x0000003303037220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000191c27f007947ULL, 0x000fea000b800000ULL, 0x00001f763d337589ULL, 0x0006a400000e0000ULL,
0x000000331e1e7220ULL, 0x084fe40000410000ULL, 0x000000331d1d7220ULL, 0x080fe40000410000ULL,
0x000000331a1a7220ULL, 0x080fe40000410000ULL, 0x0000003319197220ULL, 0x080fe40000410000ULL,
0x0000003316167220ULL, 0x080fe40000410000ULL, 0x0000003315157220ULL, 0x000fc40000410000ULL,
0x0000003312127220ULL, 0x080fe40000410000ULL, 0x0000003311117220ULL, 0x080fe40000410000ULL,
0x000000330e0e7220ULL, 0x080fe40000410000ULL, 0x000000330d0d7220ULL, 0x080fe40000410000ULL,
0x000000330a0a7220ULL, 0x080fe40000410000ULL, 0x0000003309097220ULL, 0x000fc40000410000ULL,
0x0000003306067220ULL, 0x080fe40000410000ULL, 0x0000003305057220ULL, 0x080fe40000410000ULL,
0x0000003331317220ULL, 0x080fe40000410000ULL, 0x0000003332327220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x004fea0003800000ULL, 0x0000ffff3eff7812ULL, 0x000fda0007806039ULL,
0x8000003736360221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL, 0x0000003600250308ULL, 0x000ea40000000800ULL,
0x0000002538380220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000002138217221ULL, 0x002fe40000010000ULL, 0x000000ffff337224ULL, 0x000fc400078e0037ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff24ff7812ULL, 0x000fe2000786c0ffULL,
0x0000016000017945ULL, 0x000fd80003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000010ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x000190227f007947ULL, 0x000fea000b800000ULL, 0x00001f7837267589ULL, 0x0004e400000e0000ULL,
0x000190827f007947ULL, 0x000fea000b800000ULL, 0x00001f7637277589ULL, 0x0004e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010783b7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x00000037003a7202ULL, 0x000fe20000000f00ULL,
0xffffffffff3f7424ULL, 0x000fe200078e00ffULL, 0x0000f0f000347802ULL, 0x000fc40000000f00ULL,
0x00019bc000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0037ULL, 0x00000018783b7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0xffffffff003f7802ULL, 0x000fe40000000f00ULL,
0x0000f16000347802ULL, 0x000fc40000000f00ULL, 0x00019b5000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0001300028347811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002954783bULL, 0x000fe20000004200ULL,
0x000130002c387811ULL, 0x000fe200078e20ffULL, 0x000003b000017945ULL, 0x000fe20003800000ULL,
0x000000877800720cULL, 0x000fe20003f46070ULL, 0x000000003434783bULL, 0x004ea20000000200ULL,
0x000000776e00720cULL, 0x000fc40003fc3070ULL, 0x000000877600720cULL, 0x000fe20003f26070ULL,
0x000000002a5c783bULL, 0x000fe20000004200ULL, 0x000000776e00720cULL, 0x000fc60003f03070ULL,
0x000000002b64783bULL, 0x000fe80000004200ULL, 0x000000002d3c783bULL, 0x00afe80000004200ULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000002e40783bULL, 0x000ee80000004200ULL,
0x000000002f44783bULL, 0x000f280000004200ULL, 0x000000003048783bULL, 0x000ee80000004200ULL,
0x00000000744c783bULL, 0x000ee20000004200ULL, 0x000000263434b231ULL, 0x004fc400003400ffULL,
0x000000263636b231ULL, 0x000fe400003400ffULL, 0x000000273535b231ULL, 0x080fe400003400ffULL,
0x000000273737b231ULL, 0x000fce00003400ffULL, 0x000000543450723cULL, 0x000f6200000418ffULL,
0x000000263838b231ULL, 0x082fe400003400ffULL, 0x000000263a3ab231ULL, 0x000fe400003400ffULL,
0x000000273939b231ULL, 0x000fc600003400ffULL, 0x0000005c3458723cULL, 0x000fe200000418ffULL,
0x000000273b3bb231ULL, 0x000fce00003400ffULL, 0x000000643460723cULL, 0x040ff000000418ffULL,
0x000000563454723cULL, 0x040f7000000418ffULL, 0x0000005e345c723cULL, 0x040f7000000418ffULL,
0x000000663464723cULL, 0x040f7000000418ffULL, 0x0000003c3468723cULL, 0x040b6e00000418ffULL,
0x00000001873d7810ULL, 0x020fe20007ffe0ffULL, 0x0000003e3434723cULL, 0x000f6600000418ffULL,
0x0000003d7800720cULL, 0x000fc40005746470ULL, 0x0000003d7600720cULL, 0x000fc60004f26470ULL,
0x000000403850723cULL, 0x048b700000041850ULL, 0x000000423854723cULL, 0x040b700000041854ULL,
0x000000443858723cULL, 0x050b700000041858ULL, 0x00000046385c723cULL, 0x040b70000004185cULL,
0x000000483860723cULL, 0x040b700000041860ULL, 0x0000004a3864723cULL, 0x040b700000041864ULL,
0x0000004c3868723cULL, 0x040b700000041868ULL, 0x0000004e3834723cULL, 0x020b620000041834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000005020207221ULL, 0x000fe40000010000ULL, 0x000000511f1f7221ULL, 0x000fc40000010000ULL,
0x000000541c1c7221ULL, 0x000fe40000010000ULL, 0x000000551b1b7221ULL, 0x000fe40000010000ULL,
0x0000005818187221ULL, 0x000fe40000010000ULL, 0x0000005917177221ULL, 0x000fe40000010000ULL,
0x0000005c14147221ULL, 0x000fe40000010000ULL, 0x0000005d13137221ULL, 0x000fc40000010000ULL,
0x0000006010107221ULL, 0x000fe40000010000ULL, 0x000000610f0f7221ULL, 0x000fe40000010000ULL,
0x000000640c0c7221ULL, 0x000fe40000010000ULL, 0x000000650b0b7221ULL, 0x000fe40000010000ULL,
0x0000006808087221ULL, 0x000fe40000010000ULL, 0x0000006907077221ULL, 0x000fc40000010000ULL,
0x0000003404047221ULL, 0x020fe40000010000ULL, 0x0000003503037221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000521e1e7221ULL, 0x000fe40000010000ULL,
0x000000531d1d7221ULL, 0x000fe40000010000ULL, 0x000000561a1a7221ULL, 0x000fe40000010000ULL,
0x0000005719197221ULL, 0x000fe40000010000ULL, 0x0000005a16167221ULL, 0x000fc40000010000ULL,
0x0000005b15157221ULL, 0x000fe40000010000ULL, 0x0000005e12127221ULL, 0x000fe40000010000ULL,
0x0000005f11117221ULL, 0x000fe40000010000ULL, 0x000000620e0e7221ULL, 0x000fe40000010000ULL,
0x000000630d0d7221ULL, 0x000fe40000010000ULL, 0x000000660a0a7221ULL, 0x000fc40000010000ULL,
0x0000006709097221ULL, 0x000fe40000010000ULL, 0x0000006a06067221ULL, 0x000fe40000010000ULL,
0x0000006b05057221ULL, 0x000fe40000010000ULL, 0x0000003631317221ULL, 0x020fe40000010000ULL,
0x0000003732327221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff347f8cULL, 0x020e62000c80043fULL,
0x000000776e00720cULL, 0x0c0fe40003fc3070ULL, 0x000000776e00720cULL, 0x000fc40003f03070ULL,
0x00000040ff407803ULL, 0x000fe40000000000ULL, 0x00000002ff347819ULL, 0x002fe2000001163dULL,
0x000000ffff3c7224ULL, 0x000fc600078e0035ULL, 0x000000343d347207ULL, 0x000fc80002800000ULL,
0x0000000234367810ULL, 0x000fe40007ffe0ffULL, 0x000000033d347812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x00000002ff387819ULL, 0x000fe40000011636ULL,
0x000000ff34347207ULL, 0x000fe40006800000ULL, 0x0000000336367812ULL, 0x000fe200078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e0277ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8400ff3a7984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c4885ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc8000001143bULL, 0x0000003a37377211ULL, 0x000fca00078d10ffULL,
0x000000ffff3a7224ULL, 0x000fca00030e063bULL, 0x0000000237377819ULL, 0x000fc8000000123aULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb8400ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c4885ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x01cb8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ff003d7202ULL, 0x000fe20000000f00ULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000037ff7812ULL, 0x002fe200078c483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078d10ffULL, 0x000000ffff3a7224ULL, 0x000fca00030e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe400078c483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000435377824ULL, 0x000fe200078e0236ULL, 0x0000121000017945ULL, 0x000fe60003800000ULL,
0x0000004037427824ULL, 0x000fe200078e00ffULL, 0x0000000135377810ULL, 0x000fc80007ffe0ffULL,
0x000000703700720cULL, 0x000fe40003fc6070ULL, 0x000000406c387812ULL, 0x000fd600078ef842ULL,
0x000009800000e947ULL, 0x000fea0003800000ULL, 0x000000026f417819ULL, 0x040fe200000006ffULL,
0x000000016f397824ULL, 0x040fe200078e0238ULL, 0x000000016f497810ULL, 0x000fe20007ffe0ffULL,
0x00000200ff437424ULL, 0x000fe400078e00ffULL, 0x01ca000041377984ULL, 0x000e640000000800ULL,
0x00000004373e7824ULL, 0x002fca00078e00ffULL, 0x01cac0003e377984ULL, 0x0002a40000000800ULL,
0x000000206f3e7824ULL, 0x002fe400078e00ffULL, 0x0000003722377224ULL, 0x004fe400078e0239ULL,
0x0000001002397824ULL, 0x000fe400078e00ffULL, 0x00005e00373a7625ULL, 0x000fe200078e0043ULL,
0x0000004271377217ULL, 0x000fe40007800000ULL, 0x000001f039457812ULL, 0x000fc800078ec0ffULL,
0x000000453a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000001373a7824ULL, 0x000fe400078e0a42ULL,
0x000000016f377824ULL, 0x040fe200078e0202ULL, 0x0000003bff3d7210ULL, 0x000fe400037fe4ffULL,
0x0000003a6f3a7217ULL, 0x000fe40007800000ULL, 0xffffffe03e397812ULL, 0x000fc600078ee237ULL,
0x000000013a377824ULL, 0x000fe200078e0a6fULL, 0x0001400039477811ULL, 0x000fe200078e20ffULL,
0x00000001493a7824ULL, 0x000fc600078e0238ULL, 0x000000ff3700720cULL, 0x000fda0003fc3070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000f101c46ULL,
0x01ca040041397984ULL, 0x000ea40000000800ULL, 0x0000000239397819ULL, 0x004fcc00000006ffULL,
0x01cac00039397984ULL, 0x000ea40000000800ULL, 0x00000039223a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x000000013700780cULL, 0x000fe40003fc3070ULL,
0xffffffe0493a7812ULL, 0x000fe400078ee23aULL, 0x000000026f497810ULL, 0x000fc40007ffe0ffULL,
0x000140003a477811ULL, 0x002fc600078e20ffULL, 0x00000001493a7824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e8000f101c46ULL,
0x01ca080041397984ULL, 0x000ea40000000800ULL, 0x0000000239397819ULL, 0x004fcc00000006ffULL,
0x01cac00039397984ULL, 0x000ea40000000800ULL, 0x00000039223a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe20007fde0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0x000000023700780cULL, 0x000fe40003fc3070ULL,
0xffffffe0493a7812ULL, 0x000fe400078ee23aULL, 0x000000036f497810ULL, 0x000fc40007ffe0ffULL,
0x000140003a477811ULL, 0x002fc600078e20ffULL, 0x00000001493a7824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000f101c46ULL,
0x01ca0c0041397984ULL, 0x000ea40000000800ULL, 0x0000000239397819ULL, 0x004fcc00000006ffULL,
0x01cac00039397984ULL, 0x000ea40000000800ULL, 0x00000039223a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x000000033700780cULL, 0x000fe40003fc3070ULL,
0xffffffe0493a7812ULL, 0x000fe400078ee23aULL, 0x000000046f497810ULL, 0x000fc40007ffe0ffULL,
0x000140003a477811ULL, 0x002fc600078e20ffULL, 0x00000001493a7824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e8000f101c46ULL,
0x01ca100041397984ULL, 0x000ea40000000800ULL, 0x0000000239397819ULL, 0x004fcc00000006ffULL,
0x01cac00039397984ULL, 0x000ea40000000800ULL, 0x00000039223a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe20007fde0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0x000000043700780cULL, 0x000fe40003fc3070ULL,
0xffffffe0493a7812ULL, 0x000fe400078ee23aULL, 0x000000056f497810ULL, 0x000fc40007ffe0ffULL,
0x000140003a477811ULL, 0x002fc600078e20ffULL, 0x00000001493a7824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000f101c46ULL,
0x01ca140041397984ULL, 0x000ea20000000800ULL, 0x000000066f477810ULL, 0x002fca0007ffe0ffULL,
0x00000001473c7824ULL, 0x000fe200078e0202ULL, 0x0000000239397819ULL, 0x004fcc00000006ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x000000053700780cULL, 0x000fe40003fc3070ULL,
0xffffffe0493a7812ULL, 0x000fc800078ee23aULL, 0x000140003a3d7811ULL, 0x000fe200078e20ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fc800078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e2000f101c46ULL,
0xffffffe0473c7812ULL, 0x000fc600078ee23cULL, 0x01ca180041397984ULL, 0x000ea20000000800ULL,
0x000140003c3d7811ULL, 0x002fe400078e20ffULL, 0x000000076f3f7810ULL, 0x000fca0007ffe0ffULL,
0x000000013f387824ULL, 0x040fe400078e0238ULL, 0x000000013f3e7824ULL, 0x040fe400078e0202ULL,
0x000000203f3f7824ULL, 0x000fca00078e00ffULL, 0xffffffe03f3e7812ULL, 0x000fe400078ee23eULL,
0x0000000239397819ULL, 0x004fcc00000006ffULL, 0x01cac00039397984ULL, 0x000e640000000800ULL,
0x00000039223a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e063bULL,
0x000000063700780cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000f101c46ULL, 0x01ca1c0041397984ULL, 0x000ea20000000800ULL,
0x000140003e3b7811ULL, 0x002fe400078e20ffULL, 0x00000002393c7819ULL, 0x004fca00000006ffULL,
0x01cac0003c397984ULL, 0x000e640000000800ULL, 0x0000003922387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x0000004538387210ULL, 0x000fca0007fde0ffULL,
0x000000ffff397224ULL, 0x000fe200030e0639ULL, 0x000000073700780cULL, 0x000fda0003fc3070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e2000f101c46ULL,
0x0000083000007947ULL, 0x000fea0003800000ULL, 0x0000006f02417211ULL, 0x040fe200078fd8ffULL,
0x00000200ff427424ULL, 0x000fe400078e00ffULL, 0x00000010023c7824ULL, 0x000fe200078e00ffULL,
0x0000003841397210ULL, 0x040fe20007ffe0ffULL, 0x01ca000041377984ULL, 0x000e620000004800ULL,
0x0000000141477810ULL, 0x000fe40007ffe0ffULL, 0x000001f03c437812ULL, 0x000fe200078ec0ffULL,
0x01cac00037377984ULL, 0x002e640000004800ULL, 0x0000003722397224ULL, 0x002fc800078e0239ULL,
0x00005e00393a7625ULL, 0x000fc800078e0042ULL, 0x0000000141397824ULL, 0x040fe200078e0202ULL,
0x000000433a3c7210ULL, 0x000fe40007fde0ffULL, 0x00000005413a7819ULL, 0x000fc600000006ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x000fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca040041377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722397224ULL, 0x004fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fc800078e0042ULL,
0x0000000147397824ULL, 0x040fe200078e0202ULL, 0x000000433a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000020473a7824ULL, 0x000fe200078e00ffULL, 0x0000000241477810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x002fe400078e20ffULL, 0x0000003847397210ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e457faeULL, 0x0003e8000b901c46ULL,
0x01ca080041377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722397224ULL, 0x004fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fc800078e0042ULL,
0x0000000147397824ULL, 0x040fe200078e0202ULL, 0x000000433a3c7210ULL, 0x000fe20007fde0ffULL,
0x00000020473a7824ULL, 0x000fe200078e00ffULL, 0x0000000341477810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x002fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca0c0041377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722397224ULL, 0x004fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fc800078e0042ULL,
0x0000000147397824ULL, 0x040fe200078e0202ULL, 0x000000433a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000020473a7824ULL, 0x000fe200078e00ffULL, 0x0000000441477810ULL, 0x000fe40007ffe0ffULL,
0x0000003bff3f7210ULL, 0x000fe400037fe4ffULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x002fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e457faeULL, 0x0003e8000b901c46ULL,
0x01ca100041377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722397224ULL, 0x004fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fe200078e0042ULL,
0x0000000247397210ULL, 0x000fc80007ffe0ffULL, 0x000000433a3c7210ULL, 0x000fe20007fde0ffULL,
0x00000020473a7824ULL, 0x000fe200078e00ffULL, 0x0000000541477810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x002fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca140041377984ULL, 0x000ea20000004800ULL, 0x0000000641457810ULL, 0x002fca0007ffe0ffULL,
0x00000020453c7824ULL, 0x000fe200078e00ffULL, 0x01cac00037377984ULL, 0x004e640000004800ULL,
0x0000003722397224ULL, 0x002fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fc800078e0042ULL,
0x0000000147397824ULL, 0x040fe200078e0202ULL, 0x000000433a3e7210ULL, 0x000fe40007fde0ffULL,
0x00000005473a7819ULL, 0x000fc600000006ffULL, 0x000000ffff3f7224ULL, 0x000fe200030e063bULL,
0xffffffe03a397812ULL, 0x000fc800078ee239ULL, 0x00014000393d7811ULL, 0x000fe200078e20ffULL,
0x0000000145397824ULL, 0x000fc800078e0238ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e3d7faeULL, 0x0003e8000b901c46ULL, 0x01ca180041377984ULL, 0x000ea20000004800ULL,
0x00000007413f7810ULL, 0x002fc80007ffe0ffULL, 0x000000383f387210ULL, 0x000fe20007ffe0ffULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722397224ULL, 0x002fc800078e0239ULL,
0x00005e00393a7625ULL, 0x000fc800078e0042ULL, 0x0000000145397824ULL, 0x000fe200078e0202ULL,
0x000000433a3a7210ULL, 0x000fc80007fde0ffULL, 0xffffffe03c397812ULL, 0x000fe200078ee239ULL,
0x000000ffff3b7224ULL, 0x000fe400030e063bULL, 0x000000013f3c7824ULL, 0x000fe200078e0202ULL,
0x00014000393d7811ULL, 0x000fe200078e20ffULL, 0x000000203f3f7824ULL, 0x000fc800078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e2000b901c46ULL,
0xffffffe03f3c7812ULL, 0x000fc600078ee23cULL, 0x01ca1c0041377984ULL, 0x000ea20000004800ULL,
0x000140003c3b7811ULL, 0x002fc600078e20ffULL, 0x01cac00037377984ULL, 0x004e640000004800ULL,
0x0000003722387224ULL, 0x002fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0042ULL,
0x0000004338387210ULL, 0x000fca0007fde0ffULL, 0x000000ffff397224ULL, 0x000fca00030e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e6000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb8800ff387f8cULL, 0x002e64000c80043fULL, 0x000000ffff3c7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x01cb8c00ff377984ULL, 0x000e620000000800ULL,
0x000000ff003d7202ULL, 0x000fe20000000f00ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000037ff7812ULL, 0x002fe200078c483cULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc8000001143bULL, 0x0000003a37377211ULL, 0x000fca00078d10ffULL,
0x000000ffff3a7224ULL, 0x000fca00030e063bULL, 0x0000000237377819ULL, 0x000fc8000000123aULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb8c00ff377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe400078c483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000356e00720cULL, 0x000fc80003fc4070ULL,
0x000000ff34377207ULL, 0x040fe40003000000ULL, 0x000000ff34387207ULL, 0x000fc60007000000ULL,
0x0000000136377824ULL, 0x000fca00078e0237ULL, 0x00000002ff347819ULL, 0x000fe20000011637ULL,
0x0000004037377824ULL, 0x000fc800078e00ffULL, 0x0000030034347a24ULL, 0x000fe200078e0235ULL,
0x000000c037377812ULL, 0x000fe200078ec0ffULL, 0x0000000173357824ULL, 0x000fc600078e0238ULL,
0x0000003734347211ULL, 0x000fe400078e40ffULL, 0x0001ca0023377811ULL, 0x000fe400078e10ffULL,
0x0000002034367810ULL, 0x000fca0007ffe0ffULL, 0x0000680035347a24ULL, 0x100fe400078e0236ULL,
0x0000000123367824ULL, 0x040fe400078e0236ULL, 0x00000004ff357424ULL, 0x000fe400078e00ffULL,
0x0000000123347824ULL, 0x000fe200078e0234ULL, 0x000000713600720cULL, 0x000fc60003fc6070ULL,
0x0000660034347625ULL, 0x000fd400078e0035ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034377faeULL, 0x0003e4000f121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01cb7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb7800ff847f8cULL, 0x000e62000c80043fULL, 0x0000016000017945ULL, 0x000fe20003800000ULL,
0x0000014000003947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000010ffULL,
0x0000541026377816ULL, 0x000fe20000000026ULL, 0x00016e127f007947ULL, 0x000fea000b800000ULL,
0x00001f7837267589ULL, 0x0004e400000e0000ULL, 0x00016e727f007947ULL, 0x000fea000b800000ULL,
0x00001f7637277589ULL, 0x0004e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010783b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0037ULL,
0xffffffff003f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fe200078e00ffULL,
0x0001140000347802ULL, 0x000fc40000000f00ULL, 0x000178b000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0037ULL,
0x00000018783b7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff3c7424ULL, 0x000fe200078e00ffULL,
0x0001147000347802ULL, 0x000fe20000000f00ULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x0001784000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0001300082347811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000008154783bULL, 0x000fe20000004200ULL, 0x000130007d387811ULL, 0x000fe200078e20ffULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x000000ff4000720cULL, 0x000fe20003fc5270ULL,
0x000000003434783bULL, 0x004ea80000000200ULL, 0x00000000805c783bULL, 0x000fe80000004200ULL,
0x000000007f64783bULL, 0x000fe80000004200ULL, 0x000000007e3c783bULL, 0x002fe80000004200ULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000007c40783bULL, 0x000f280000004200ULL,
0x000000007b44783bULL, 0x000ee80000004200ULL, 0x000000007a48783bULL, 0x000ee80000004200ULL,
0x00000000794c783bULL, 0x000ee40000004200ULL, 0x000000263434b231ULL, 0x00cfc400003400ffULL,
0x000000263636b231ULL, 0x000fe400003400ffULL, 0x000000273535b231ULL, 0x080fe400003400ffULL,
0x000000273737b231ULL, 0x000fce00003400ffULL, 0x000000543450723cULL, 0x000f6200000418ffULL,
0x000000263838b231ULL, 0x082fe400003400ffULL, 0x000000263a3ab231ULL, 0x000fe400003400ffULL,
0x000000273939b231ULL, 0x000fc600003400ffULL, 0x0000005c3458723cULL, 0x000fe200000418ffULL,
0x000000273b3bb231ULL, 0x000fce00003400ffULL, 0x000000643460723cULL, 0x040ff000000418ffULL,
0x000000563454723cULL, 0x040f7000000418ffULL, 0x0000005e345c723cULL, 0x040f7000000418ffULL,
0x000000663464723cULL, 0x040f7000000418ffULL, 0x0000003c3468723cULL, 0x040f7000000418ffULL,
0x0000003e3434723cULL, 0x000f7000000418ffULL, 0x000000403850723cULL, 0x070b700000041850ULL,
0x000000423854723cULL, 0x040b700000041854ULL, 0x000000443858723cULL, 0x040b700000041858ULL,
0x00000046385c723cULL, 0x040b70000004185cULL, 0x000000483860723cULL, 0x040b700000041860ULL,
0x0000004a3864723cULL, 0x040b700000041864ULL, 0x0000004c3868723cULL, 0x040b700000041868ULL,
0x0000004e3834723cULL, 0x000b620000041834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000005020207221ULL, 0x020fe40000010000ULL,
0x000000511f1f7221ULL, 0x000fc40000010000ULL, 0x000000541c1c7221ULL, 0x000fe40000010000ULL,
0x000000551b1b7221ULL, 0x000fe40000010000ULL, 0x0000005818187221ULL, 0x000fe40000010000ULL,
0x0000005917177221ULL, 0x000fe40000010000ULL, 0x0000005c14147221ULL, 0x000fe40000010000ULL,
0x0000005d13137221ULL, 0x000fc40000010000ULL, 0x0000006010107221ULL, 0x000fe40000010000ULL,
0x000000610f0f7221ULL, 0x000fe40000010000ULL, 0x000000640c0c7221ULL, 0x000fe40000010000ULL,
0x000000650b0b7221ULL, 0x000fe40000010000ULL, 0x0000006808087221ULL, 0x000fe40000010000ULL,
0x0000006907077221ULL, 0x000fc40000010000ULL, 0x0000003404047221ULL, 0x000fe40000010000ULL,
0x0000003503037221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000521e1e7221ULL, 0x020fe40000010000ULL, 0x000000531d1d7221ULL, 0x000fe40000010000ULL,
0x000000561a1a7221ULL, 0x000fe40000010000ULL, 0x0000005719197221ULL, 0x000fe40000010000ULL,
0x0000005a16167221ULL, 0x000fc40000010000ULL, 0x0000005b15157221ULL, 0x000fe40000010000ULL,
0x0000005e12127221ULL, 0x000fe40000010000ULL, 0x0000005f11117221ULL, 0x000fe40000010000ULL,
0x000000620e0e7221ULL, 0x000fe40000010000ULL, 0x000000630d0d7221ULL, 0x000fe40000010000ULL,
0x000000660a0a7221ULL, 0x000fc40000010000ULL, 0x0000006709097221ULL, 0x000fe40000010000ULL,
0x0000006a06067221ULL, 0x000fe40000010000ULL, 0x0000006b05057221ULL, 0x000fe40000010000ULL,
0x0000003631317221ULL, 0x000fe40000010000ULL, 0x0000003732327221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000187877810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff347f8cULL, 0x020e62000c80043fULL,
0x000000838700720cULL, 0x000fc40003f06070ULL, 0x00000035003c7202ULL, 0x002fd60000000f00ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffb06000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c077347811ULL, 0x000fe200078e40ffULL,
0x01cb6800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000713400720cULL, 0x000fda0003f06070ULL,
0x0000501000000947ULL, 0x000fea0003800000ULL, 0x000000ffff877224ULL, 0x000fca00078e00ffULL,
0x00000002ff347819ULL, 0x000fe20000011687ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000387367812ULL, 0x040fe200078ec0ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x0000003487347207ULL, 0x000fe40002800000ULL, 0x000000ff36367207ULL, 0x000fe40006800000ULL,
0x0000000334377810ULL, 0x000fc80007ffe0ffULL, 0x00000002ff387819ULL, 0x000fe40000011637ULL,
0x0000000337347812ULL, 0x000fc600078ec0ffULL, 0x0000030038357a24ULL, 0x000fc400078e0277ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x01cb7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804885ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fc800078110ffULL, 0x0000003bff3b7210ULL, 0x000fc800007fe4ffULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb7c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804885ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x01cb8c00ff3b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb8c00ff3b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000135397810ULL, 0x040fe20007ffe0ffULL,
0x0000121000017945ULL, 0x000fe20003800000ULL, 0x0000003435387211ULL, 0x000fe400078e10ffULL,
0x000000703900720cULL, 0x000fe40003f06070ULL, 0x00000020383a7811ULL, 0x000fc800078e30ffULL,
0x000000606c387812ULL, 0x000fce00078ef83aULL, 0x0000098000008947ULL, 0x000fea0003800000ULL,
0x000000046f3f7824ULL, 0x040fe200078e00ffULL, 0x000000016f477810ULL, 0x040fe20007ffe0ffULL,
0x000000016f3c7824ULL, 0x040fe400078e0238ULL, 0x00000200ff417424ULL, 0x000fe200078e00ffULL,
0x01ca00003f397984ULL, 0x000e620000000800ULL, 0x000000016f407824ULL, 0x040fe400078e0202ULL,
0x000000206f457824ULL, 0x000fca00078e00ffULL, 0xffffffe045407812ULL, 0x000fc800078ee240ULL,
0x0001800040457811ULL, 0x000fe200078e20ffULL, 0x0000000147407824ULL, 0x000fe400078e0202ULL,
0x00000004393d7824ULL, 0x002fe200078e00ffULL, 0x0000003a71397217ULL, 0x000fc80007800000ULL,
0x01cac0003d3b7984ULL, 0x000e620000000800ULL, 0x000000393a3a7210ULL, 0x000fe20007ffe1ffULL,
0x0000001002397824ULL, 0x000fc600078e00ffULL, 0x0000003a6f3a7217ULL, 0x000fe40007800000ULL,
0x000001f039437812ULL, 0x000fe400078ec0ffULL, 0x0000003a6f3e7210ULL, 0x000fc80007ffe1ffULL,
0x000000ff3e00720cULL, 0x000fe20003f03070ULL, 0x0000003b223b7224ULL, 0x002fc800078e023cULL,
0x00005e003b3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f3e0ffULL,
0x00000038473a7210ULL, 0x040fe20007ffe0ffULL, 0x0000002047477824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600008e063bULL, 0xffffffe047407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000013e00780cULL, 0x000fe40003f03070ULL, 0x000000026f477810ULL, 0x000fe20007ffe0ffULL,
0x01ca04003f397984ULL, 0x000ea20000000800ULL, 0x0001800040457811ULL, 0x002fc600078e20ffULL,
0x0000000147407824ULL, 0x000fe400078e0202ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600008e063bULL, 0xffffffe047407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000023e00780cULL, 0x000fe40003f03070ULL, 0x000000036f477810ULL, 0x000fe20007ffe0ffULL,
0x01ca08003f397984ULL, 0x000ea20000000800ULL, 0x0001800040457811ULL, 0x002fc600078e20ffULL,
0x0000000147407824ULL, 0x000fe200078e0202ULL, 0x0000000239397819ULL, 0x004fcc00000006ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001473a7824ULL, 0x040fe200078e0238ULL, 0x0000000547477819ULL, 0x000fe400000006ffULL,
0x0000003bff3d7210ULL, 0x000fe40000ffe4ffULL, 0xffffffe047407812ULL, 0x000fe400078ee240ULL,
0x000000046f477810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e2000c101c46ULL, 0x000000033e00780cULL, 0x000fc60003f03070ULL,
0x01ca0c003f397984ULL, 0x000ea20000000800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x0000000247407210ULL, 0x000fe20007ffe0ffULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600008e063bULL, 0xffffffe047407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000043e00780cULL, 0x000fe40003f03070ULL, 0x000000056f477810ULL, 0x000fe20007ffe0ffULL,
0x01ca10003f397984ULL, 0x000ea20000000800ULL, 0x0001800040457811ULL, 0x002fc600078e20ffULL,
0x0000000147407824ULL, 0x000fe400078e0202ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe40007f3e0ffULL,
0x00000038473a7210ULL, 0x040fe20007ffe0ffULL, 0x0000002047477824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600008e063bULL, 0xffffffe047407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000053e00780cULL, 0x000fe40003f03070ULL, 0x000000066f477810ULL, 0x000fe20007ffe0ffULL,
0x01ca14003f397984ULL, 0x000ea20000000800ULL, 0x0001800040457811ULL, 0x002fc600078e20ffULL,
0x0000000147407824ULL, 0x000fe400078e0202ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0041ULL, 0x000000433a3c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600008e063bULL, 0xffffffe047407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000c101c46ULL,
0x000000063e00780cULL, 0x000fc60003f03070ULL, 0x01ca18003f397984ULL, 0x000ea20000000800ULL,
0x00018000403d7811ULL, 0x002fe400078e20ffULL, 0x000000076f457810ULL, 0x000fca0007ffe0ffULL,
0x0000000145387824ULL, 0x040fe400078e0238ULL, 0x0000000145407824ULL, 0x040fe200078e0202ULL,
0x0000000545457819ULL, 0x000fc800000006ffULL, 0xffffffe045407812ULL, 0x000fe400078ee240ULL,
0x0000000239397819ULL, 0x004fcc00000006ffULL, 0x01cac00039397984ULL, 0x000e640000000800ULL,
0x00000039223a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0041ULL,
0x000000433a3a7210ULL, 0x000fc80007f3e0ffULL, 0x0000003bff3b7210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e2000c101c46ULL,
0x000000073e00780cULL, 0x000fc60003f03070ULL, 0x01ca1c003f397984ULL, 0x000ea20000000800ULL,
0x00018000403b7811ULL, 0x002fe200078e20ffULL, 0x00000004393c7824ULL, 0x004fca00078e00ffULL,
0x01cac0003c397984ULL, 0x000e640000000800ULL, 0x0000003922387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff397224ULL, 0x000fca00008e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000c101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000006f02417211ULL, 0x040fe200078fd8ffULL, 0x00000010023b7824ULL, 0x000fe200078e00ffULL,
0x0000020000437802ULL, 0x000fe40000000f00ULL, 0x00000001413f7810ULL, 0x040fe20007ffe0ffULL,
0x01ca000041397984ULL, 0x000e620000004800ULL, 0x00000001413a7824ULL, 0x000fe200078e0238ULL,
0x000001f03b457812ULL, 0x000fe200078ec0ffULL, 0x00000001413d7824ULL, 0x040fe400078e0202ULL,
0x00000020413e7824ULL, 0x000fc400078e00ffULL, 0x000000013f407824ULL, 0x000fe200078e0202ULL,
0x01cac00039397984ULL, 0x002e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe03e3a7812ULL, 0x000fc600078ee23dULL, 0x000000ffff3d7224ULL, 0x000fe200000e063bULL,
0x000180003a477811ULL, 0x000fe400078e20ffULL, 0x000000383f3a7210ULL, 0x040fe20007ffe0ffULL,
0x000000203f3f7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c477faeULL, 0x0003e6000b901c46ULL, 0xffffffe03f407812ULL, 0x000fe200078ee240ULL,
0x01ca040041397984ULL, 0x000ea60000004800ULL, 0x0001800040477811ULL, 0x002fc400078e20ffULL,
0x00000002413d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d407824ULL, 0x000fe200078e0202ULL,
0x01cac00039397984ULL, 0x004e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe40007f1e0ffULL,
0x000000383d3a7210ULL, 0x040fe20007ffe0ffULL, 0x000000203d3d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fc600000e063bULL, 0xffffffe03d407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e8000b901c46ULL,
0x01ca080041397984ULL, 0x000ea20000004800ULL, 0x0001800040477811ULL, 0x002fe400078e20ffULL,
0x00000003413f7810ULL, 0x000fca0007ffe0ffULL, 0x000000013f407824ULL, 0x000fe200078e0202ULL,
0x01cac00039397984ULL, 0x004e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe40007f1e0ffULL,
0x000000383f3a7210ULL, 0x040fe20007ffe0ffULL, 0x000000203f3f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e063bULL, 0xffffffe03f407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000b901c46ULL,
0x01ca0c0041397984ULL, 0x000ea20000004800ULL, 0x0001800040477811ULL, 0x002fe400078e20ffULL,
0x00000004413d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d407824ULL, 0x000fe200078e0202ULL,
0x01cac00039397984ULL, 0x004e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe40007f1e0ffULL,
0x000000383d3a7210ULL, 0x040fe20007ffe0ffULL, 0x000000203d3d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fc600000e063bULL, 0xffffffe03d407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e8000b901c46ULL,
0x01ca100041397984ULL, 0x000ea20000004800ULL, 0x0001800040477811ULL, 0x002fe400078e20ffULL,
0x00000005413f7810ULL, 0x000fca0007ffe0ffULL, 0x000000013f407824ULL, 0x000fe200078e0202ULL,
0x01cac00039397984ULL, 0x004e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe40007f1e0ffULL,
0x000000383f3a7210ULL, 0x040fe20007ffe0ffULL, 0x000000203f3f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e063bULL, 0xffffffe03f407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000b901c46ULL,
0x01ca140041397984ULL, 0x000ea20000004800ULL, 0x00018000403d7811ULL, 0x002fe400078e20ffULL,
0x0000000641477810ULL, 0x000fca0007ffe0ffULL, 0x00000001473c7824ULL, 0x000fe200078e0202ULL,
0x01cac00039397984ULL, 0x004e640000004800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe40007f1e0ffULL,
0x00000038473a7210ULL, 0x040fe20007ffe0ffULL, 0x0000002047477824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fc600000e063bULL, 0xffffffe0473c7812ULL, 0x000fe400078ee23cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e8000b901c46ULL,
0x01ca180041397984ULL, 0x000ea20000004800ULL, 0x000180003c3d7811ULL, 0x002fe400078e20ffULL,
0x00000007413f7810ULL, 0x000fc80007ffe0ffULL, 0x000000383f387210ULL, 0x040fe20007ffe0ffULL,
0x000000013f3e7824ULL, 0x040fe400078e0202ULL, 0x000000203f3f7824ULL, 0x000fca00078e00ffULL,
0xffffffe03f3e7812ULL, 0x000fe200078ee23eULL, 0x01cac00039397984ULL, 0x004e640000004800ULL,
0x00000039223a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x01ca1c00413c7984ULL, 0x000ea20000004800ULL, 0x000180003e3b7811ULL, 0x002fc600078e20ffULL,
0x01cac0003c397984ULL, 0x004e640000004800ULL, 0x0000003922387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x0000004538387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff387f8cULL, 0x002e64000c80043fULL,
0x00000039003f7202ULL, 0x002fc40000000f00ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe4000780483fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe4000780483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000356e00720cULL, 0x000fe20003f04070ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000000137377812ULL, 0x000fe400078ec0ffULL, 0x000000033600780cULL, 0x000fc80004705270ULL,
0x000000013700780cULL, 0x000fda0000705470ULL, 0x0000014000000947ULL, 0x000fea0003800000ULL,
0x000000032300780cULL, 0x000fe40003f24070ULL, 0x000000016d387812ULL, 0x000fe400078ec0ffULL,
0x0000030000377a02ULL, 0x000fe40000000f00ULL, 0x000000013800780cULL, 0x000fe40003f05070ULL,
0xffffffff37377811ULL, 0x000fc800078e08ffULL, 0x0000000137387807ULL, 0x000fca0004000000ULL,
0x000000016d6d7824ULL, 0x000fe200078e0238ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0000000400377824ULL, 0x000fe200078e0223ULL, 0x000064006d387a10ULL, 0x040fe40007ffe0ffULL,
0x000000726d00720cULL, 0x000fe20003f06070ULL, 0x0000000237377824ULL, 0x000fe200078e00ffULL,
0x0000000400397802ULL, 0x000fc60000000f00ULL, 0x0000640037387a24ULL, 0x000fe200078e0238ULL,
0x0001cac023377811ULL, 0x000fc600078e10ffULL, 0x0000600038387625ULL, 0x000fca00078e0039ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000017000004947ULL, 0x000fea0003800000ULL, 0x000000356e00720cULL, 0x000fe40003f04070ULL,
0x0000000136377810ULL, 0x002fc80007ffe0ffULL, 0x0000000337367812ULL, 0x000fce00078ec0ffULL,
0x00000002ff378819ULL, 0x000fca0000011637ULL, 0x0000000134347824ULL, 0x000fe200078e0237ULL,
0x0001ca0023377811ULL, 0x000fc800078e10ffULL, 0x00000002ff387819ULL, 0x000fe20000011634ULL,
0x0000004034347824ULL, 0x000fc800078e00ffULL, 0x0000030038387a24ULL, 0x000fe200078e0235ULL,
0x000000c034357812ULL, 0x000fe400078ec0ffULL, 0x000000ff36347207ULL, 0x000fc60004000000ULL,
0x0000010038357824ULL, 0x000fe200078e0235ULL, 0x0000003473347210ULL, 0x000fc60007ffe0ffULL,
0x0000000123367824ULL, 0x140fe400078e0235ULL, 0x0000680034347a24ULL, 0x000fe400078e0235ULL,
0x00000004ff357424ULL, 0x000fe200078e00ffULL, 0x000000713600720cULL, 0x000fe20003f06070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01cb8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff8700720cULL, 0x000fe20003f05270ULL,
0x01cb8000ff847f8cULL, 0x000e62000c80043fULL, 0x000007d000017945ULL, 0x000ff60003800000ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb38006f347f8cULL, 0x000ea4000c80043fULL, 0x00000035003b7202ULL, 0x004fc40000000f00ULL,
0x0000000000347805ULL, 0x000fca0000015200ULL, 0x01cb3c006f247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc4000780483bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634397210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011437ULL, 0x0000003924247211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000224247819ULL, 0x000fc80000001237ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x01cb3c006f247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe4000780483bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000402247819ULL, 0x000fe400000006ffULL,
0x00000001ff347819ULL, 0x000fe40000011602ULL, 0x0000007024247812ULL, 0x000fe400078ec0ffULL,
0x0000000c34357812ULL, 0x000fca00078ec0ffULL, 0x00000001243a7824ULL, 0x000fca00078e0235ULL,
0x01c180003a367984ULL, 0x000ea80000000800ULL, 0x01c380003a387984ULL, 0x0006620000000800ULL,
0x000000333600720bULL, 0x004fe20003f1d000ULL, 0x000146d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x008fc800000e0100ULL, 0x0000ffff243e7812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x0000000100247802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fd400078e0033ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000037500780cULL, 0x000fe40003f05270ULL, 0x000000333600720bULL, 0x000fe20003f34000ULL,
0x000146a27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000397806ULL, 0x000fc400008e0100ULL,
0x0000003633377209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991039347816ULL, 0x000fc600000000ffULL, 0x01c580373a008388ULL, 0x0005e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000003733337221ULL, 0x004fe20000010000ULL, 0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b33337820ULL, 0x000fc80000410000ULL,
0x00000033003d7308ULL, 0x000ea40000000800ULL, 0x0000003d21217220ULL, 0x004fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000146027f007947ULL, 0x000fea000b800000ULL,
0x00001f783d337589ULL, 0x0004e400000e0000ULL, 0x0000003320207220ULL, 0x088fe40000410000ULL,
0x000000331f1f7220ULL, 0x080fe40000410000ULL, 0x000000331c1c7220ULL, 0x080fe40000410000ULL,
0x000000331b1b7220ULL, 0x080fe40000410000ULL, 0x0000003318187220ULL, 0x080fe40000410000ULL,
0x0000003317177220ULL, 0x000fc40000410000ULL, 0x0000003314147220ULL, 0x080fe40000410000ULL,
0x0000003313137220ULL, 0x080fe40000410000ULL, 0x0000003310107220ULL, 0x080fe40000410000ULL,
0x000000330f0f7220ULL, 0x080fe40000410000ULL, 0x000000330c0c7220ULL, 0x080fe40000410000ULL,
0x000000330b0b7220ULL, 0x000fc40000410000ULL, 0x0000003308087220ULL, 0x080fe40000410000ULL,
0x0000003307077220ULL, 0x080fe40000410000ULL, 0x0000003304047220ULL, 0x080fe40000410000ULL,
0x0000003303037220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000145327f007947ULL, 0x000fea000b800000ULL, 0x00001f763d337589ULL, 0x0006a400000e0000ULL,
0x000000331e1e7220ULL, 0x084fe40000410000ULL, 0x000000331d1d7220ULL, 0x080fe40000410000ULL,
0x000000331a1a7220ULL, 0x080fe40000410000ULL, 0x0000003319197220ULL, 0x080fe40000410000ULL,
0x0000003316167220ULL, 0x080fe40000410000ULL, 0x0000003315157220ULL, 0x000fc40000410000ULL,
0x0000003312127220ULL, 0x080fe40000410000ULL, 0x0000003311117220ULL, 0x080fe40000410000ULL,
0x000000330e0e7220ULL, 0x080fe40000410000ULL, 0x000000330d0d7220ULL, 0x080fe40000410000ULL,
0x000000330a0a7220ULL, 0x080fe40000410000ULL, 0x0000003309097220ULL, 0x000fc40000410000ULL,
0x0000003306067220ULL, 0x080fe40000410000ULL, 0x0000003305057220ULL, 0x080fe40000410000ULL,
0x0000003331317220ULL, 0x080fe40000410000ULL, 0x0000003332327220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x004fea0003800000ULL, 0x0000ffff3eff7812ULL, 0x000fda0007806039ULL,
0x8000003736360221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL, 0x0000003600250308ULL, 0x000ea40000000800ULL,
0x0000002538380220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000002138217221ULL, 0x002fe40000010000ULL, 0x000000ffff337224ULL, 0x000fc400078e0037ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff24ff7812ULL, 0x000fe2000786c0ffULL,
0x0000016000017945ULL, 0x000fd80003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000010ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x000143927f007947ULL, 0x000fea000b800000ULL, 0x00001f7837267589ULL, 0x0004e400000e0000ULL,
0x000143f27f007947ULL, 0x000fea000b800000ULL, 0x00001f7637277589ULL, 0x0004e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010783b7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x00000037003a7202ULL, 0x000fe20000000f00ULL,
0xffffffffff3f7424ULL, 0x000fe200078e00ffULL, 0x0001413000347802ULL, 0x000fc40000000f00ULL,
0x00014b8000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0037ULL, 0x00000018783b7810ULL, 0x002fe20007ffe0ffULL,
0xffffffffff3f7424ULL, 0x000fe200078e00ffULL, 0x0000001f003c7802ULL, 0x000fe40000000f00ULL,
0x000141a000347802ULL, 0x000fc40000000f00ULL, 0x00014b1000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0001380028347811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002954783bULL, 0x000fe20000004200ULL,
0x000138002c387811ULL, 0x000fe200078e20ffULL, 0x000003b000017945ULL, 0x000fe20003800000ULL,
0x000000877800720cULL, 0x000fe20003f46070ULL, 0x000000003434783bULL, 0x004ea20000000200ULL,
0x000000776e00720cULL, 0x000fc40003fc3070ULL, 0x000000877600720cULL, 0x000fe20003f26070ULL,
0x000000002a5c783bULL, 0x000fe20000004200ULL, 0x000000776e00720cULL, 0x000fc60003f03070ULL,
0x000000002b64783bULL, 0x000fe80000004200ULL, 0x000000002d3c783bULL, 0x00afe80000004200ULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000002e40783bULL, 0x000ee80000004200ULL,
0x000000002f44783bULL, 0x000f280000004200ULL, 0x000000003048783bULL, 0x000ee80000004200ULL,
0x00000000744c783bULL, 0x000ee20000004200ULL, 0x000000263434b231ULL, 0x004fc400003400ffULL,
0x000000263636b231ULL, 0x000fe400003400ffULL, 0x000000273535b231ULL, 0x080fe400003400ffULL,
0x000000273737b231ULL, 0x000fce00003400ffULL, 0x000000543450723cULL, 0x000f6200000418ffULL,
0x000000263838b231ULL, 0x082fe400003400ffULL, 0x000000263a3ab231ULL, 0x000fe400003400ffULL,
0x000000273939b231ULL, 0x000fc600003400ffULL, 0x0000005c3458723cULL, 0x000fe200000418ffULL,
0x000000273b3bb231ULL, 0x000fce00003400ffULL, 0x000000643460723cULL, 0x040ff000000418ffULL,
0x000000563454723cULL, 0x040f7000000418ffULL, 0x0000005e345c723cULL, 0x040f7000000418ffULL,
0x000000663464723cULL, 0x040f7000000418ffULL, 0x0000003c3468723cULL, 0x040b6e00000418ffULL,
0x00000001873d7810ULL, 0x020fe20007ffe0ffULL, 0x0000003e3434723cULL, 0x000f6600000418ffULL,
0x0000003d7800720cULL, 0x000fc40005746470ULL, 0x0000003d7600720cULL, 0x000fc60004f26470ULL,
0x000000403850723cULL, 0x048b700000041850ULL, 0x000000423854723cULL, 0x040b700000041854ULL,
0x000000443858723cULL, 0x050b700000041858ULL, 0x00000046385c723cULL, 0x040b70000004185cULL,
0x000000483860723cULL, 0x040b700000041860ULL, 0x0000004a3864723cULL, 0x040b700000041864ULL,
0x0000004c3868723cULL, 0x040b700000041868ULL, 0x0000004e3834723cULL, 0x020b620000041834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000005020207221ULL, 0x000fe40000010000ULL, 0x000000511f1f7221ULL, 0x000fc40000010000ULL,
0x000000541c1c7221ULL, 0x000fe40000010000ULL, 0x000000551b1b7221ULL, 0x000fe40000010000ULL,
0x0000005818187221ULL, 0x000fe40000010000ULL, 0x0000005917177221ULL, 0x000fe40000010000ULL,
0x0000005c14147221ULL, 0x000fe40000010000ULL, 0x0000005d13137221ULL, 0x000fc40000010000ULL,
0x0000006010107221ULL, 0x000fe40000010000ULL, 0x000000610f0f7221ULL, 0x000fe40000010000ULL,
0x000000640c0c7221ULL, 0x000fe40000010000ULL, 0x000000650b0b7221ULL, 0x000fe40000010000ULL,
0x0000006808087221ULL, 0x000fe40000010000ULL, 0x0000006907077221ULL, 0x000fc40000010000ULL,
0x0000003404047221ULL, 0x020fe40000010000ULL, 0x0000003503037221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000521e1e7221ULL, 0x000fe40000010000ULL,
0x000000531d1d7221ULL, 0x000fe40000010000ULL, 0x000000561a1a7221ULL, 0x000fe40000010000ULL,
0x0000005719197221ULL, 0x000fe40000010000ULL, 0x0000005a16167221ULL, 0x000fc40000010000ULL,
0x0000005b15157221ULL, 0x000fe40000010000ULL, 0x0000005e12127221ULL, 0x000fe40000010000ULL,
0x0000005f11117221ULL, 0x000fe40000010000ULL, 0x000000620e0e7221ULL, 0x000fe40000010000ULL,
0x000000630d0d7221ULL, 0x000fe40000010000ULL, 0x000000660a0a7221ULL, 0x000fc40000010000ULL,
0x0000006709097221ULL, 0x000fe40000010000ULL, 0x0000006a06067221ULL, 0x000fe40000010000ULL,
0x0000006b05057221ULL, 0x000fe40000010000ULL, 0x0000003631317221ULL, 0x020fe40000010000ULL,
0x0000003732327221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff347f8cULL, 0x020e62000c80043fULL,
0x000000776e00720cULL, 0x0c0fe40003fc3070ULL, 0x000000776e00720cULL, 0x000fc40003f03070ULL,
0x00000040ff407803ULL, 0x000fe40000000000ULL, 0x00000002ff347819ULL, 0x002fe2000001163dULL,
0x000000ffff3c7224ULL, 0x000fc600078e0035ULL, 0x000000343d347207ULL, 0x000fc80002800000ULL,
0x0000000334367810ULL, 0x000fe40007ffe0ffULL, 0x000000033d347812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x00000002ff387819ULL, 0x000fe40000011636ULL,
0x000000ff34347207ULL, 0x000fe40006800000ULL, 0x0000000336367812ULL, 0x000fe200078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e0277ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8400ff3a7984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c4885ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fc80007fde1ffULL, 0x0000003b393b7210ULL, 0x000fe400037fe5ffULL,
0x003d09003a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc8000001143bULL, 0x0000003a37377211ULL, 0x000fca00078d10ffULL,
0x000000ffff3a7224ULL, 0x000fca00030e063bULL, 0x0000000237377819ULL, 0x000fc8000000123aULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb8400ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c4885ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x01cb8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000037ff7812ULL, 0x002fe200078c483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fc800078d10ffULL, 0x0000003bff3a7210ULL, 0x000fc800037fe4ffULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe400078c483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000435377824ULL, 0x000fe200078e0236ULL, 0x0000121000017945ULL, 0x000fe60003800000ULL,
0x0000004037427824ULL, 0x000fe200078e00ffULL, 0x0000000135377810ULL, 0x000fc80007ffe0ffULL,
0x000000703700720cULL, 0x000fe40003fc6070ULL, 0x000000406c387812ULL, 0x000fd600078ef842ULL,
0x000009800000e947ULL, 0x000fea0003800000ULL, 0x000000046f417824ULL, 0x040fe200078e00ffULL,
0x000000016f497810ULL, 0x040fe20007ffe0ffULL, 0x000000016f397824ULL, 0x000fe400078e0238ULL,
0x00000200ff437424ULL, 0x000fe200078e00ffULL, 0x01ca000041377984ULL, 0x000e640000000800ULL,
0x00000002373e7819ULL, 0x002fca00000006ffULL, 0x01cac0003e377984ULL, 0x0002a40000000800ULL,
0x000000206f3e7824ULL, 0x002fe400078e00ffULL, 0x0000003722377224ULL, 0x004fe400078e0239ULL,
0x0000001002397824ULL, 0x000fe400078e00ffULL, 0x00005e00373a7625ULL, 0x000fe200078e0043ULL,
0x0000004271377217ULL, 0x000fe40007800000ULL, 0x000001f039457812ULL, 0x000fc800078ec0ffULL,
0x000000453a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000001373a7824ULL, 0x000fe400078e0a42ULL,
0x000000016f377824ULL, 0x040fe200078e0202ULL, 0x0000003bff3d7210ULL, 0x000fe400037fe4ffULL,
0x0000003a6f3a7217ULL, 0x040fe40007800000ULL, 0xffffffe03e397812ULL, 0x000fe400078ee237ULL,
0x0000003a6f377210ULL, 0x000fe20007ffe1ffULL, 0x00000001493a7824ULL, 0x000fe200078e0238ULL,
0x0001400039477811ULL, 0x000fc400078e20ffULL, 0x000000ff3700720cULL, 0x000fda0003fc3070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000f101c46ULL,
0x01ca040041397984ULL, 0x000ea40000000800ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000ea40000000800ULL, 0x00000039223a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe40007fde0ffULL,
0x00000002493a7210ULL, 0x040fe20007ffe0ffULL, 0x0000002049497824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x000000013700780cULL, 0x000fe40003fc3070ULL,
0xffffffe0493a7812ULL, 0x000fe400078ee23aULL, 0x000000026f497810ULL, 0x000fc40007ffe0ffULL,
0x000140003a477811ULL, 0x002fc600078e20ffULL, 0x00000001493a7824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e8000f101c46ULL,
0x01ca080041397984ULL, 0x000ea40000000800ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000ea40000000800ULL, 0x00000039223a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe20007fde0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe200078e00ffULL,
0x0000003bff3d7210ULL, 0x000fe400037fe4ffULL, 0x000000023700780cULL, 0x000fe40003fc3070ULL,
0xffffffe0493a7812ULL, 0x000fe400078ee23aULL, 0x000000036f497810ULL, 0x000fc40007ffe0ffULL,
0x000140003a477811ULL, 0x002fe400078e20ffULL, 0x00000038493a7210ULL, 0x000fca0007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000f101c46ULL,
0x01ca0c0041397984ULL, 0x000ea40000000800ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000ea40000000800ULL, 0x00000039223a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000001493a7824ULL, 0x040fe400078e0202ULL, 0x0000002049497824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x000000033700780cULL, 0x000fe40003fc3070ULL,
0xffffffe0493a7812ULL, 0x000fe400078ee23aULL, 0x000000046f497810ULL, 0x000fc40007ffe0ffULL,
0x000140003a477811ULL, 0x002fc600078e20ffULL, 0x00000001493a7824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e477faeULL, 0x0003e8000f101c46ULL,
0x01ca100041397984ULL, 0x000ea40000000800ULL, 0x0000000239397819ULL, 0x004fcc00000006ffULL,
0x01cac00039397984ULL, 0x000ea40000000800ULL, 0x00000039223a7224ULL, 0x004fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3c7210ULL, 0x000fe20007fde0ffULL,
0x00000001493a7824ULL, 0x040fe200078e0202ULL, 0x0000000549497819ULL, 0x000fc600000006ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0x000000043700780cULL, 0x000fe40003fc3070ULL,
0xffffffe0493a7812ULL, 0x000fe400078ee23aULL, 0x000000056f497810ULL, 0x000fe40007ffe0ffULL,
0x000140003a477811ULL, 0x002fc600078e20ffULL, 0x00000001493a7824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c477faeULL, 0x0003e8000f101c46ULL,
0x01ca140041397984ULL, 0x000ea20000000800ULL, 0x000000066f477810ULL, 0x002fca0007ffe0ffULL,
0x00000001473c7824ULL, 0x000fe400078e0202ULL, 0x0000000439397824ULL, 0x004fcc00078e00ffULL,
0x01cac00039397984ULL, 0x000e640000000800ULL, 0x00000039223a7224ULL, 0x002fc800078e023aULL,
0x00005e003a3a7625ULL, 0x000fca00078e0043ULL, 0x000000453a3e7210ULL, 0x000fe40007fde0ffULL,
0x00000002493a7210ULL, 0x040fe20007ffe0ffULL, 0x0000002049497824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x000000053700780cULL, 0x000fe40003fc3070ULL,
0xffffffe0493a7812ULL, 0x000fc800078ee23aULL, 0x000140003a3d7811ULL, 0x000fe200078e20ffULL,
0x00000001473a7824ULL, 0x040fe400078e0238ULL, 0x0000002047477824ULL, 0x000fc800078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e3d7faeULL, 0x0003e2000f101c46ULL,
0xffffffe0473c7812ULL, 0x000fc600078ee23cULL, 0x01ca180041397984ULL, 0x000ea20000000800ULL,
0x000140003c3d7811ULL, 0x002fe400078e20ffULL, 0x000000076f3f7810ULL, 0x000fc80007ffe0ffULL,
0x000000383f387210ULL, 0x040fe20007ffe0ffULL, 0x000000013f3e7824ULL, 0x040fe400078e0202ULL,
0x000000203f3f7824ULL, 0x000fca00078e00ffULL, 0xffffffe03f3e7812ULL, 0x000fe200078ee23eULL,
0x0000000439397824ULL, 0x004fcc00078e00ffULL, 0x01cac00039397984ULL, 0x000e640000000800ULL,
0x00000039223a7224ULL, 0x002fc800078e023aULL, 0x00005e003a3a7625ULL, 0x000fca00078e0043ULL,
0x000000453a3a7210ULL, 0x000fc80007fde0ffULL, 0x0000003bff3b7210ULL, 0x000fe400037fe4ffULL,
0x000000063700780cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a3d7faeULL, 0x0003e8000f101c46ULL, 0x01ca1c0041397984ULL, 0x000ea20000000800ULL,
0x000140003e3b7811ULL, 0x002fe200078e20ffULL, 0x00000004393c7824ULL, 0x004fca00078e00ffULL,
0x01cac0003c397984ULL, 0x000e640000000800ULL, 0x0000003922387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0043ULL, 0x0000004538387210ULL, 0x000fca0007fde0ffULL,
0x000000ffff397224ULL, 0x000fe200030e0639ULL, 0x000000073700780cULL, 0x000fda0003fc3070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e2000f101c46ULL,
0x0000083000007947ULL, 0x000fea0003800000ULL, 0x0000006f02417211ULL, 0x040fe200078fd8ffULL,
0x00000200ff427424ULL, 0x000fe400078e00ffULL, 0x00000010023c7824ULL, 0x000fe200078e00ffULL,
0x0000003841397210ULL, 0x040fe20007ffe0ffULL, 0x01ca000041377984ULL, 0x000e620000004800ULL,
0x0000000141477810ULL, 0x000fe40007ffe0ffULL, 0x000001f03c437812ULL, 0x000fe200078ec0ffULL,
0x01cac00037377984ULL, 0x002e640000004800ULL, 0x0000003722397224ULL, 0x002fc800078e0239ULL,
0x00005e00393a7625ULL, 0x000fe200078e0042ULL, 0x0000000241397210ULL, 0x000fc80007ffe0ffULL,
0x000000433a3c7210ULL, 0x000fe20007fde0ffULL, 0x00000020413a7824ULL, 0x000fc800078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x000fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca040041377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722397224ULL, 0x004fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fe200078e0042ULL,
0x0000000247397210ULL, 0x000fc80007ffe0ffULL, 0x000000433a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000020473a7824ULL, 0x000fe200078e00ffULL, 0x0000000241477810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x002fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e457faeULL, 0x0003e8000b901c46ULL,
0x01ca080041377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722397224ULL, 0x004fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fe200078e0042ULL,
0x0000000247397210ULL, 0x000fc80007ffe0ffULL, 0x000000433a3c7210ULL, 0x000fe20007fde0ffULL,
0x00000020473a7824ULL, 0x000fe200078e00ffULL, 0x0000000341477810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x002fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca0c0041377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722397224ULL, 0x004fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fe200078e0042ULL,
0x0000000247397210ULL, 0x000fc80007ffe0ffULL, 0x000000433a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000020473a7824ULL, 0x000fe200078e00ffULL, 0x0000000441477810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x002fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e457faeULL, 0x0003e8000b901c46ULL,
0x01ca100041377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722397224ULL, 0x004fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fe200078e0042ULL,
0x0000000247397210ULL, 0x000fc80007ffe0ffULL, 0x000000433a3c7210ULL, 0x000fe20007fde0ffULL,
0x00000020473a7824ULL, 0x000fe200078e00ffULL, 0x0000000541477810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e063bULL, 0xffffffe03a397812ULL, 0x000fc800078ee239ULL,
0x0001400039457811ULL, 0x002fe200078e20ffULL, 0x0000000147397824ULL, 0x000fc800078e0238ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca140041377984ULL, 0x000ea20000004800ULL, 0x0000000641457810ULL, 0x002fca0007ffe0ffULL,
0x00000020453c7824ULL, 0x000fe200078e00ffULL, 0x01cac00037377984ULL, 0x004e640000004800ULL,
0x0000003722397224ULL, 0x002fc800078e0239ULL, 0x00005e00393a7625ULL, 0x000fe200078e0042ULL,
0x0000000247397210ULL, 0x000fc80007ffe0ffULL, 0x000000433a3e7210ULL, 0x000fe20007fde0ffULL,
0x00000020473a7824ULL, 0x000fc800078e00ffULL, 0x000000ffff3f7224ULL, 0x000fe200030e063bULL,
0xffffffe03a397812ULL, 0x000fc800078ee239ULL, 0x00014000393d7811ULL, 0x000fe200078e20ffULL,
0x0000000145397824ULL, 0x000fc800078e0238ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e3d7faeULL, 0x0003e8000b901c46ULL, 0x01ca180041377984ULL, 0x000ea20000004800ULL,
0x00000007413f7810ULL, 0x002fca0007ffe0ffULL, 0x000000013f387824ULL, 0x000fe200078e0238ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722397224ULL, 0x002fc800078e0239ULL,
0x00005e00393a7625ULL, 0x000fe200078e0042ULL, 0x0000000245397210ULL, 0x000fc80007ffe0ffULL,
0x000000433a3a7210ULL, 0x000fe40007fde0ffULL, 0xffffffe03c397812ULL, 0x000fe400078ee239ULL,
0x000000023f3c7210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e063bULL,
0x00014000393d7811ULL, 0x000fe200078e20ffULL, 0x000000203f3f7824ULL, 0x000fc800078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e2000b901c46ULL,
0xffffffe03f3c7812ULL, 0x000fc600078ee23cULL, 0x01ca1c0041377984ULL, 0x000ea20000004800ULL,
0x000140003c3b7811ULL, 0x002fc600078e20ffULL, 0x01cac00037377984ULL, 0x004e640000004800ULL,
0x0000003722387224ULL, 0x002fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0042ULL,
0x0000004338387210ULL, 0x000fca0007fde0ffULL, 0x000000ffff397224ULL, 0x000fca00030e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e6000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb8800ff387f8cULL, 0x002e64000c80043fULL, 0x000000ffff3c7224ULL, 0x002fc400078e0039ULL,
0x0000000000387805ULL, 0x000fca0000015200ULL, 0x01cb8c00ff377984ULL, 0x000e620000000800ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000037ff7812ULL, 0x002fe200078c483cULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fc80007fde1ffULL, 0x0000003b393b7210ULL, 0x000fe400037fe5ffULL,
0x003d09003a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc8000001143bULL, 0x0000003a37377211ULL, 0x000fca00078d10ffULL,
0x000000ffff3a7224ULL, 0x000fca00030e063bULL, 0x0000000237377819ULL, 0x000fc8000000123aULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb8c00ff377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe400078c483cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000356e00720cULL, 0x000fc80003fc4070ULL,
0x000000ff34377207ULL, 0x040fe40003000000ULL, 0x000000ff34387207ULL, 0x000fc60007000000ULL,
0x0000000136377824ULL, 0x000fca00078e0237ULL, 0x00000002ff347819ULL, 0x000fe20000011637ULL,
0x0000004037377824ULL, 0x000fc800078e00ffULL, 0x0000030034347a24ULL, 0x000fe200078e0235ULL,
0x000000c037377812ULL, 0x000fe200078ec0ffULL, 0x0000000173357824ULL, 0x000fc600078e0238ULL,
0x0000003734347211ULL, 0x000fe400078e40ffULL, 0x0001ca0023377811ULL, 0x000fe400078e10ffULL,
0x0000002034367810ULL, 0x000fca0007ffe0ffULL, 0x0000680035347a24ULL, 0x000fe200078e0236ULL,
0x0000003623367210ULL, 0x040fe20007ffe0ffULL, 0x00000004ff357424ULL, 0x000fe400078e00ffULL,
0x0000000123347824ULL, 0x000fe200078e0234ULL, 0x000000713600720cULL, 0x000fc60003fc6070ULL,
0x0000660034347625ULL, 0x000fd400078e0035ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034377faeULL, 0x0003e4000f121846ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01cb7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb7800ff847f8cULL, 0x000e62000c80043fULL, 0x0000016000017945ULL, 0x000fe20003800000ULL,
0x0000014000003947ULL, 0x000fea0003800000ULL, 0x00000025ff26723eULL, 0x000fc800000010ffULL,
0x0000541026377816ULL, 0x000fe20000000026ULL, 0x000121827f007947ULL, 0x000fea000b800000ULL,
0x00001f7837267589ULL, 0x0004e400000e0000ULL, 0x000121e27f007947ULL, 0x000fea000b800000ULL,
0x00001f7637277589ULL, 0x0004e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010783b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0037ULL,
0x0000001f003c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff3f7424ULL, 0x000fe200078e00ffULL,
0x0001644000347802ULL, 0x000fc40000000f00ULL, 0x0001287000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0037ULL,
0x00000018783b7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff3c7424ULL, 0x000fe200078e00ffULL,
0xffffffff003f7802ULL, 0x000fe40000000f00ULL, 0x000164b000347802ULL, 0x000fc40000000f00ULL,
0x0001280000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0001380082347811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000008154783bULL, 0x000fe20000004200ULL, 0x000138007d387811ULL, 0x000fe200078e20ffULL,
0x0000035000017945ULL, 0x000fe20003800000ULL, 0x000000ff4000720cULL, 0x000fe20003fc5270ULL,
0x000000003434783bULL, 0x004ea80000000200ULL, 0x00000000805c783bULL, 0x000fe80000004200ULL,
0x000000007f64783bULL, 0x000fe80000004200ULL, 0x000000007e3c783bULL, 0x002fe80000004200ULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000007c40783bULL, 0x000f280000004200ULL,
0x000000007b44783bULL, 0x000ee80000004200ULL, 0x000000007a48783bULL, 0x000ee80000004200ULL,
0x00000000794c783bULL, 0x000ee40000004200ULL, 0x000000263434b231ULL, 0x00cfc400003400ffULL,
0x000000263636b231ULL, 0x000fe400003400ffULL, 0x000000273535b231ULL, 0x080fe400003400ffULL,
0x000000273737b231ULL, 0x000fce00003400ffULL, 0x000000543450723cULL, 0x000f6200000418ffULL,
0x000000263838b231ULL, 0x082fe400003400ffULL, 0x000000263a3ab231ULL, 0x000fe400003400ffULL,
0x000000273939b231ULL, 0x000fc600003400ffULL, 0x0000005c3458723cULL, 0x000fe200000418ffULL,
0x000000273b3bb231ULL, 0x000fce00003400ffULL, 0x000000643460723cULL, 0x040ff000000418ffULL,
0x000000563454723cULL, 0x040f7000000418ffULL, 0x0000005e345c723cULL, 0x040f7000000418ffULL,
0x000000663464723cULL, 0x040f7000000418ffULL, 0x0000003c3468723cULL, 0x040f7000000418ffULL,
0x0000003e3434723cULL, 0x000f7000000418ffULL, 0x000000403850723cULL, 0x070b700000041850ULL,
0x000000423854723cULL, 0x040b700000041854ULL, 0x000000443858723cULL, 0x040b700000041858ULL,
0x00000046385c723cULL, 0x040b70000004185cULL, 0x000000483860723cULL, 0x040b700000041860ULL,
0x0000004a3864723cULL, 0x040b700000041864ULL, 0x0000004c3868723cULL, 0x040b700000041868ULL,
0x0000004e3834723cULL, 0x000b620000041834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000005020207221ULL, 0x020fe40000010000ULL,
0x000000511f1f7221ULL, 0x000fc40000010000ULL, 0x000000541c1c7221ULL, 0x000fe40000010000ULL,
0x000000551b1b7221ULL, 0x000fe40000010000ULL, 0x0000005818187221ULL, 0x000fe40000010000ULL,
0x0000005917177221ULL, 0x000fe40000010000ULL, 0x0000005c14147221ULL, 0x000fe40000010000ULL,
0x0000005d13137221ULL, 0x000fc40000010000ULL, 0x0000006010107221ULL, 0x000fe40000010000ULL,
0x000000610f0f7221ULL, 0x000fe40000010000ULL, 0x000000640c0c7221ULL, 0x000fe40000010000ULL,
0x000000650b0b7221ULL, 0x000fe40000010000ULL, 0x0000006808087221ULL, 0x000fe40000010000ULL,
0x0000006907077221ULL, 0x000fc40000010000ULL, 0x0000003404047221ULL, 0x000fe40000010000ULL,
0x0000003503037221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000521e1e7221ULL, 0x020fe40000010000ULL, 0x000000531d1d7221ULL, 0x000fe40000010000ULL,
0x000000561a1a7221ULL, 0x000fe40000010000ULL, 0x0000005719197221ULL, 0x000fe40000010000ULL,
0x0000005a16167221ULL, 0x000fc40000010000ULL, 0x0000005b15157221ULL, 0x000fe40000010000ULL,
0x0000005e12127221ULL, 0x000fe40000010000ULL, 0x0000005f11117221ULL, 0x000fe40000010000ULL,
0x000000620e0e7221ULL, 0x000fe40000010000ULL, 0x000000630d0d7221ULL, 0x000fe40000010000ULL,
0x000000660a0a7221ULL, 0x000fc40000010000ULL, 0x0000006709097221ULL, 0x000fe40000010000ULL,
0x0000006a06067221ULL, 0x000fe40000010000ULL, 0x0000006b05057221ULL, 0x000fe40000010000ULL,
0x0000003631317221ULL, 0x000fe40000010000ULL, 0x0000003732327221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000187877810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff347f8cULL, 0x020e62000c80043fULL,
0x000000838700720cULL, 0x000fe20003f06070ULL, 0x000000ffff3c7224ULL, 0x002fd800078e0035ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffb06000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb7000ffff7f8cULL, 0x000fe4000c80043fULL,
0x0000030077777a10ULL, 0x000fc80007ffe0ffULL, 0x000000707700720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffeb97000007947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000002a7919ULL, 0x000e620000002500ULL,
0x000000ffff287224ULL, 0x000fe200078e0004ULL, 0x0000000500267202ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fe200078e0003ULL, 0x0000000900227202ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fe400078e0006ULL, 0x000000ffff257224ULL, 0x000fe400078e0007ULL,
0x000000ffff247224ULL, 0x000fe400078e0008ULL, 0x000000ffff237224ULL, 0x000fc400078e000aULL,
0x000000ffff047224ULL, 0x000fe400078e000dULL, 0x000000ffff057224ULL, 0x000fe200078e000eULL,
0x000000702a00720cULL, 0x002fda0003f06070ULL, 0x0000037000000947ULL, 0x000fea0003800000ULL,
0x0180000021027810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x0000002100307202ULL, 0x000fe40000000f00ULL,
0x00016c4000077802ULL, 0x000fc40000000f00ULL, 0x00011ea000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff027224ULL, 0x000fe200078e0006ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002100027308ULL, 0x000e640000001000ULL, 0xbf80000002037423ULL, 0x002fc80000000021ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000302027223ULL, 0x000fc40000000002ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea40000000000ULL,
0x00000002ff3b7819ULL, 0x004fe20000011603ULL, 0x000119427f007947ULL, 0x000fea000b800000ULL,
0x00001f3b02037589ULL, 0x00046400000e0000ULL, 0x0000000000067919ULL, 0x000f220000000000ULL,
0x0000002003207220ULL, 0x042fe40000410000ULL, 0x0000001f031f7220ULL, 0x040fe40000410000ULL,
0x0000001c031c7220ULL, 0x040fe40000410000ULL, 0x0000001b031b7220ULL, 0x000fc40000410000ULL,
0x0000001803187220ULL, 0x040fe40000410000ULL, 0x0000001703177220ULL, 0x040fe40000410000ULL,
0x0000001403147220ULL, 0x040fe40000410000ULL, 0x0000001303137220ULL, 0x040fe40000410000ULL,
0x0000001003107220ULL, 0x040fe40000410000ULL, 0x0000000f030f7220ULL, 0x000fc40000410000ULL,
0x0000000c030c7220ULL, 0x040fe40000410000ULL, 0x0000000b030b7220ULL, 0x040fe20000410000ULL,
0x00000008063b7811ULL, 0x014fe200078ff0ffULL, 0x0000002403247220ULL, 0x040fe40000410000ULL,
0x0000002503257220ULL, 0x040fe40000410000ULL, 0x0000002803287220ULL, 0x040fe40000410000ULL,
0x0000002903297220ULL, 0x000fe20000410000ULL, 0x000118727f007947ULL, 0x000fea000b800000ULL,
0x00001f3b02027589ULL, 0x0002a400000e0000ULL, 0x0000001e021e7220ULL, 0x044fe40000410000ULL,
0x0000001d021d7220ULL, 0x000fc40000410000ULL, 0x0000001a021a7220ULL, 0x040fe40000410000ULL,
0x0000001902197220ULL, 0x040fe40000410000ULL, 0x0000001602167220ULL, 0x040fe40000410000ULL,
0x0000001502157220ULL, 0x040fe40000410000ULL, 0x0000001202127220ULL, 0x040fe40000410000ULL,
0x0000001102117220ULL, 0x000fc40000410000ULL, 0x0000000502057220ULL, 0x040fe40000410000ULL,
0x0000000402047220ULL, 0x040fe40000410000ULL, 0x0000002302237220ULL, 0x040fe40000410000ULL,
0x0000002202227220ULL, 0x040fe40000410000ULL, 0x0000002702277220ULL, 0x040fe40000410000ULL,
0x0000002602267220ULL, 0x000fc40000410000ULL, 0x0000003102317220ULL, 0x040fe40000410000ULL,
0x0000003202327220ULL, 0x000fc40000410000ULL, 0x000000100f08723eULL, 0x000fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000141307723eULL, 0x000fe400000010ffULL,
0x0000000c0b09723eULL, 0x000fe400000010ffULL, 0x00000012110f723eULL, 0x000fe400000010ffULL,
0x000000201f02723eULL, 0x000fc400000010ffULL, 0x0000001c1b03723eULL, 0x000fe400000010ffULL,
0x000000181706723eULL, 0x000fe400000010ffULL, 0x00000024250a723eULL, 0x000fe400000010ffULL,
0x00000028290b723eULL, 0x000fe400000010ffULL, 0x0000001e1d0c723eULL, 0x000fe400000010ffULL,
0x0000001a190d723eULL, 0x000fc400000010ffULL, 0x00000016150e723eULL, 0x000fe400000010ffULL,
0x000000050410723eULL, 0x000fe400000010ffULL, 0x000000232211723eULL, 0x000fe400000010ffULL,
0x000000272612723eULL, 0x000fe400000010ffULL, 0x000000313213723eULL, 0x000fc400000010ffULL,
0x0000000000197919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff1b7819ULL, 0x004fc40000011619ULL, 0x0000000819247811ULL, 0x000fe400078ff0ffULL,
0x000000011b047810ULL, 0x040fe20007ffe0ffULL, 0x000000081b157824ULL, 0x040fe200078e00ffULL,
0x000000021b057810ULL, 0x040fe20007ffe0ffULL, 0x000000081b187824ULL, 0x040fe200078e00ffULL,
0x000000031b177819ULL, 0x040fe200000006ffULL, 0x000000081b1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff815167812ULL, 0x000fe200078ee204ULL, 0x000000081b1c7824ULL, 0x040fe200078e00ffULL,
0x000000031b047810ULL, 0x040fe20007ffe0ffULL, 0x000000081b207824ULL, 0x040fe200078e00ffULL,
0x000000051b147810ULL, 0x040fe20007ffe0ffULL, 0x000000081b227824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fc400078ee205ULL, 0xfffffff8171a7812ULL, 0x000fe200078ee204ULL,
0x0000080075047824ULL, 0x000fe200078e00ffULL, 0x000000041b057810ULL, 0x040fe40007ffe0ffULL,
0x000000061b157810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81d1e7812ULL, 0x000fe400078ee214ULL,
0x000000031b147819ULL, 0x000fe400000006ffULL, 0xfffffff81c1c7812ULL, 0x000fc400078ee205ULL,
0xfffffff820207812ULL, 0x000fe400078ee215ULL, 0xfffffff814147812ULL, 0x000fe400078ee21bULL,
0x0000000219157819ULL, 0x000fe400000006ffULL, 0x0001200004057810ULL, 0x000fe40007ffe0ffULL,
0xffffffff1b177810ULL, 0x000fe20007ffe0ffULL, 0x00000008241b7824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x0000001014147824ULL, 0x000fe200078e0205ULL,
0xfffffff822227812ULL, 0x000fe200078ee217ULL, 0x0000001016167824ULL, 0x100fe200078e0205ULL,
0x000000051a1a7211ULL, 0x080fe200078e20ffULL, 0x0000001018187824ULL, 0x100fe200078e0205ULL,
0xfffffff81b247812ULL, 0x000fe200078ee224ULL, 0x000000101c1c7824ULL, 0x000fe200078e0205ULL,
0x0000000522227211ULL, 0x000fe200078e20ffULL, 0x0000000114177824ULL, 0x000fe200078e0215ULL,
0x0000001815197210ULL, 0x000fe20007ffe0ffULL, 0x000000101e1e7824ULL, 0x000fc400078e0205ULL,
0x0000001020207824ULL, 0x100fe200078e0205ULL, 0x0000000217007388ULL, 0x0005e20000000800ULL,
0x0000000115167824ULL, 0x040fe400078e0216ULL, 0x00000001151a7824ULL, 0x040fe200078e021aULL,
0x00000020151d7210ULL, 0x040fe20007ffe0ffULL, 0x0000001024247824ULL, 0x000fe200078e0205ULL,
0x0000000316007388ULL, 0x0005e20000000800ULL, 0x00000001151b7824ULL, 0x040fe400078e021cULL,
0x00000001151e7824ULL, 0x040fe200078e021eULL, 0x0000000619007388ULL, 0x0005e20000000800ULL,
0x0000000115227824ULL, 0x000fc400078e0222ULL, 0x0000000115157824ULL, 0x000fe200078e0224ULL,
0x000000071a007388ULL, 0x0005e80000000800ULL, 0x000000081b007388ULL, 0x0005e80000000800ULL,
0x000000091e007388ULL, 0x0005e80000000800ULL, 0x0000000a1d007388ULL, 0x0005e80000000800ULL,
0x0000000b22007388ULL, 0x0005e80000000800ULL, 0x0000000c15007388ULL, 0x0005e80000000800ULL,
0x0004000d16007388ULL, 0x0005e80000000800ULL, 0x0004000e19007388ULL, 0x0005e80000000800ULL,
0x0004000f1a007388ULL, 0x0005e80000000800ULL, 0x000400101b007388ULL, 0x0005e80000000800ULL,
0x000400111e007388ULL, 0x0005e80000000800ULL, 0x000400121d007388ULL, 0x0005e80000000800ULL,
0x0004001322007388ULL, 0x0005e20000000800ULL, 0x0000003000007947ULL, 0x000fea0003800000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x000174b000247802ULL, 0x000fc40000000f00ULL,
0x000118b000007944ULL, 0x00efea0003c00000ULL, 0x0000030000157a02ULL, 0x004fe20000000f00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000011500780cULL, 0x000fda0003f05270ULL,
0x0000267000008947ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000ea20000000000ULL,
0x00005800ff027624ULL, 0x000fc600078e00ffULL, 0x00000000000b7919ULL, 0x000f220000002600ULL,
0x00006c0002027a24ULL, 0x000fc800078e02ffULL, 0x0000030002077a24ULL, 0x040fe200078e02ffULL,
0x0000000f02037811ULL, 0x000fc800078e10ffULL, 0xfffffff0030c7812ULL, 0x000fca00078ec0ffULL,
0x00000080070e7824ULL, 0x000fe400078e020cULL, 0x0000001006097824ULL, 0x004fc600078e0204ULL,
0x0000000e07027211ULL, 0x000fe200078e38ffULL, 0x0000580000077a24ULL, 0x010fe200078e020bULL,
0x0120000009107984ULL, 0x0004640000000c00ULL, 0x0000007f02027810ULL, 0x000fe20007ffe0ffULL,
0x00000300070f7a24ULL, 0x000fc600078e02ffULL, 0xffffff80020d7812ULL, 0x000fe200078ec0ffULL,
0x000000010f087824ULL, 0x000fc600078e022aULL, 0x000070000d037a10ULL, 0x000fc80007f1e0ffULL,
0x0000000308027211ULL, 0x000fe200078258ffULL, 0x00007100ff037624ULL, 0x000fe200000e06ffULL,
0x000070000c147a10ULL, 0x000fc80007f1e0ffULL, 0x0000000308037211ULL, 0x000fe200008f5cffULL,
0x00007100ff167624ULL, 0x000fe200000e06ffULL, 0x000000ff7500720cULL, 0x000fc60003f25270ULL,
0x0000020075027825ULL, 0x000fcc00078e0002ULL, 0x0000001006027825ULL, 0x000fc800078e0002ULL,
0x0000011000001947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x004ea20000000000ULL,
0x0000008008097824ULL, 0x000fe200078e00ffULL, 0x000000040a0b7819ULL, 0x004fe400000006ffULL,
0x00000001ff187819ULL, 0x000fe4000001160aULL, 0x000000700b177812ULL, 0x000fe400078ec0ffULL,
0x00000019ff0b7819ULL, 0x000fe40000011608ULL, 0x00007000090a7a10ULL, 0x000fc40007b5e00eULL,
0x0000000c18187812ULL, 0x000fe400078ec0ffULL, 0x0000001417097210ULL, 0x000fe4000791e009ULL,
0x000071000b197a10ULL, 0x000fe400017e64ffULL, 0x0000000918087210ULL, 0x040fe40007f5e0ffULL,
0x00000016ff097210ULL, 0x000fe400007e240bULL, 0x0000000a180a7210ULL, 0x000fc60007c7e017ULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x00000019ff0b7210ULL, 0x000fc80001fe84ffULL,
0x0000003308007986ULL, 0x0005e8000c101906ULL, 0x000000210a007986ULL, 0x0005e4000c101906ULL,
0x000000ff0600720cULL, 0x004fe20003f05270ULL, 0x0000001002007986ULL, 0x002fe2000c101d06ULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff7500720cULL, 0x000fda0000705670ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff027424ULL, 0x000fe200078e00ffULL, 0xffffffff15097810ULL, 0x000fc60007ffe0ffULL,
0x0000700007027625ULL, 0x000fe200078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000009020279a8ULL, 0x000ea400099ee1c6ULL, 0x000000090200720cULL, 0x004fc80003f05270ULL,
0x00000001ff077807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000007ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff027984ULL, 0x000ea40000000000ULL,
0x000000ff0200720cULL, 0x004fda0003f05270ULL, 0x0000220000008947ULL, 0x000fea0003800000ULL,
0x000000ff7500720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000000406037819ULL, 0x000fe400000006ffULL, 0x00000001ff087819ULL, 0x000fe40000011606ULL,
0x000000140f027211ULL, 0x000fe400078038ffULL, 0x0000007003077812ULL, 0x002fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fe400078ec0ffULL, 0x000000160f037211ULL, 0x000fc400000f3cffULL,
0x0000000208027210ULL, 0x000fc8000791e007ULL, 0x00000003ff037210ULL, 0x000fca00007e24ffULL,
0x0000000602077981ULL, 0x000328000c1e1900ULL, 0x0000800602087981ULL, 0x000322000c1e1900ULL,
0x000000021500780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010006020a7981ULL, 0x002322000c1e1900ULL, 0x000000041500780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x0001800602107981ULL, 0x002322000c1e1900ULL,
0x000000041500780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x0002000602127981ULL, 0x002322000c1e1900ULL, 0x000000061500780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800602147981ULL, 0x002322000c1e1900ULL,
0x000000061500780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081500780cULL, 0x002fe20003f06070ULL, 0x0003000602167981ULL, 0x000318000c1e1900ULL,
0x0003800602180981ULL, 0x000324000c1e1900ULL, 0x0000000715027810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff097819ULL, 0x000fc80000011602ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x0000000c0f0b7211ULL, 0x000fe200078038ffULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1a7224ULL, 0x010fe200078e0007ULL, 0x000070000b0b7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff0f117211ULL, 0x000fe400000f3cffULL, 0x000007800b0b7810ULL, 0x000fc80007f5e0ffULL,
0x00007100ff117a10ULL, 0x000fc400017e2411ULL, 0x0000030013007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000409007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x0000000813027810ULL, 0x040fe40007ffe0ffULL,
0x0000000113037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001a07077209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020b027210ULL, 0x000fc80007f3e0ffULL,
0x00000011ff037210ULL, 0x000fca0000ffe4ffULL, 0xfffc8006021a7981ULL, 0x000328000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x0000000913027810ULL, 0x042fe40007ffe0ffULL,
0x0000000213037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000000807077209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020b027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0611ULL, 0xfffd000602087981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a13027810ULL, 0x042fe40007ffe0ffULL,
0x0000000313037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000000a07077209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020b027210ULL, 0x000fc80007f3e0ffULL,
0x00000011ff037210ULL, 0x000fca0000ffe4ffULL, 0xfffd8006020a7981ULL, 0x000328000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b13027810ULL, 0x042fe40007ffe0ffULL,
0x0000000413037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001007077209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020b027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0611ULL, 0xfffe000602107981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c13027810ULL, 0x042fe40007ffe0ffULL,
0x0000000513037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001207077209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020b027210ULL, 0x000fc80007f3e0ffULL,
0x00000011ff037210ULL, 0x000fca0000ffe4ffULL, 0xfffe800602127981ULL, 0x000328000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d13027810ULL, 0x042fe40007ffe0ffULL,
0x0000000613037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001407077209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020b027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0611ULL, 0xffff000602147981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e13027810ULL, 0x042fe40007ffe0ffULL,
0x0000000713037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001607077209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020b027210ULL, 0x000fc80007f3e0ffULL,
0x00000011ff037210ULL, 0x000fca0000ffe4ffULL, 0xffff800602167981ULL, 0x000328000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f13027810ULL, 0x002fe40007ffe0ffULL,
0x0000001807077209ULL, 0x000fe40007810000ULL, 0x0000030002007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020b027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0611ULL, 0x0000000602187981ULL, 0x000326000c1e1900ULL,
0x000004000b0b7810ULL, 0x000fe40007f3e0ffULL, 0x0000000813137810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000067919ULL, 0x000ea40000000000ULL, 0x0000000406027819ULL, 0x006fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011606ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fca00078ec0ffULL, 0x0000000102027824ULL, 0x000fca00078e0203ULL,
0x0000000702007388ULL, 0x0103e40000000800ULL, 0x000070000d027a10ULL, 0x002fe20007f1e0ffULL,
0x0000001006077824ULL, 0x040fe200078e00ffULL, 0x00000009753f7819ULL, 0x040fe200000006ffULL,
0x0000100075117824ULL, 0x000fe200078e00ffULL, 0x00000017ff417819ULL, 0x000fe20000011675ULL,
0x00007100ff037624ULL, 0x000fe200000e06ffULL, 0x000000070600780cULL, 0x000fe20003f04070ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000008000f087825ULL, 0x000fe200078e0002ULL,
0x00000001ff0a7819ULL, 0x100fe20000011606ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000007007077812ULL, 0x000fe200078ec0ffULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x0000003f08087210ULL, 0x000fe20007f3e0ffULL, 0x0000001075158824ULL, 0x140fe200078e0206ULL,
0x0000000c0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000001075178824ULL, 0x000fe200078e0206ULL,
0x000070000c427a10ULL, 0x000fe20007f5e0ffULL, 0x0000000109097824ULL, 0x000fe200008e0641ULL,
0x000070000e3e7a10ULL, 0x000fe20007f3e0ffULL, 0x0000000107077824ULL, 0x000fe200078e020aULL,
0x0000001106137211ULL, 0x040fe200078e20ffULL, 0x00007100ff447624ULL, 0x000fe200010e06ffULL,
0x00007100ff407a10ULL, 0x000fe20000ffe4ffULL, 0x0000001006087825ULL, 0x040fe200078e0008ULL,
0x0000003e0f0a8211ULL, 0x040fe200078238ffULL, 0x0000000007077984ULL, 0x000e620000000800ULL,
0x000000420f0c8211ULL, 0x040fe200078438ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x000000400f0b8211ULL, 0x040fe200008f3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008137faeULL, 0x0005e2000b901c46ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x000000440f0d8211ULL, 0x000fe200010f3cffULL,
0x00000010060a8825ULL, 0x040fe200078e000aULL, 0x0000458015158811ULL, 0x000fe200078e20ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000418017178811ULL, 0x000fe200078e20ffULL,
0x00000010060c8825ULL, 0x000fe200078e000cULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000000a158faeULL, 0x0009e2000b901c46ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x004fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000000c178faeULL, 0x0005e2000b901c46ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x010fe2000001ff00ULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x004fe2000001ff00ULL, 0x00000bb000009947ULL, 0x000fea0003800000ULL,
0x000000010f0f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001ff477424ULL, 0x000fe200078e00ffULL,
0x000000ff000e7202ULL, 0x000fc80000000f00ULL, 0x0000030047007a0cULL, 0x000fda0003f06070ULL,
0x000001c000000947ULL, 0x000fea0003800000ULL, 0x000000070600780cULL, 0x000fe20003f44070ULL,
0x000008000f087825ULL, 0x000fe200078e0002ULL, 0x00000001470c7812ULL, 0x000fc600078ec0ffULL,
0x00000800470a7824ULL, 0x000fe200078e00ffULL, 0x0000003f08087210ULL, 0x000fc80007f1e0ffULL,
0x000008000a327812ULL, 0x000fe400078ec0ffULL, 0x0000004109097210ULL, 0x000fe200007fe4ffULL,
0x00000002750ba824ULL, 0x100fe200078e020cULL, 0x0000003e0f0aa211ULL, 0x000fe200078038ffULL,
0x00000002750da824ULL, 0x000fe200078e020cULL, 0x000000420f0ca211ULL, 0x000fe200078238ffULL,
0x000000080b33a824ULL, 0x000fe200078e0206ULL, 0x000000400f0ba211ULL, 0x000fe200000f3cffULL,
0x0000000111317824ULL, 0x000fe200078e0232ULL, 0x000000060d35a211ULL, 0x000fe200078e18ffULL,
0x0000001006087825ULL, 0x000fe200078e0008ULL, 0x000000440f0da211ULL, 0x000fc400008f3cffULL,
0x000045803333a811ULL, 0x000fe200078e20ffULL, 0x0000001006317824ULL, 0x040fe200078e0231ULL,
0x000041803535a811ULL, 0x000fe200078e20ffULL, 0x00000010060aa825ULL, 0x000fc600078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008317faeULL, 0x0005e2000b901c46ULL,
0x00000010060ca825ULL, 0x000fc600078e000cULL, 0x000000000a33afaeULL, 0x0005e8000b901c46ULL,
0x000000000c35afaeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff47087810ULL, 0x004fe20007ffe0ffULL, 0x00000010060b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x100fe40000011606ULL, 0x00000002ff387819ULL, 0x000fe20000011606ULL,
0x0000008008097824ULL, 0x040fe200078e00ffULL, 0x000000700b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000080008087824ULL, 0x000fe200078e00ffULL, 0x0000000c0c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000838347824ULL, 0x000fe200078e00ffULL, 0x00000080090a7812ULL, 0x000fe200078ec0ffULL,
0x0000000406097824ULL, 0x000fe200078e00ffULL, 0x00000008383c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000838367824ULL, 0x040fe200078e00ffULL, 0x0000000a750a7211ULL, 0x000fe200078e40ffULL,
0x0000000838377824ULL, 0x040fe200078e00ffULL, 0x0000000c09467812ULL, 0x000fe200078ec0ffULL,
0x00000008383b7824ULL, 0x000fe200078e00ffULL, 0x0000000a0c0a7210ULL, 0x000fe20007ffe00bULL,
0x0000000838437824ULL, 0x040fe200078e00ffULL, 0x00000001380b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000338097819ULL, 0x000fe200000006ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180000a0c7984ULL, 0x000ea20000000800ULL, 0x0000080008087812ULL, 0x000fe400078ec0ffULL,
0xfffffff834317812ULL, 0x000fe200078ee20bULL, 0x004580000a327984ULL, 0x0008e20000000800ULL,
0xfffffff809097812ULL, 0x000fe200078ee238ULL, 0x000000083c0b7824ULL, 0x000fe200078e00ffULL,
0x0000018011087810ULL, 0x000fe40007ffe008ULL, 0x0000000238337810ULL, 0x040fe40007ffe0ffULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee23cULL, 0x0000001009097824ULL, 0x000fe200078e0208ULL,
0x0000000338347810ULL, 0x040fe20007ffe0ffULL, 0x00000008380a7824ULL, 0x010fe200078e00ffULL,
0x000000080b0b7211ULL, 0x000fe200078e20ffULL, 0x0000000146097824ULL, 0x000fe200078e0209ULL,
0xfffffff837377812ULL, 0x000fc400078ee234ULL, 0xfffffff80a337812ULL, 0x000fe400078ee233ULL,
0x0000000009357984ULL, 0x0008620000000800ULL, 0x00000008310a7211ULL, 0x000fe400078e20ffULL,
0x0000000538347810ULL, 0x040fe40007ffe0ffULL, 0x0000000338457819ULL, 0x000fe200000006ffULL,
0x00000001460a7824ULL, 0x000fe200078e020aULL, 0x0000030047007a0cULL, 0x000fe20003f06070ULL,
0x0000001037097824ULL, 0x010fe200078e0208ULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x000400000a3a7984ULL, 0x000fe20000000800ULL, 0x0000000146097824ULL, 0x000fe200078e0209ULL,
0x0000000147477810ULL, 0x000fe20007ffe0ffULL, 0x0000000c070c7221ULL, 0x006fc80000010100ULL,
0x3fb8aa3b0c0d7820ULL, 0x000fe40000410000ULL, 0x00000001460c7824ULL, 0x000fe200078e020bULL,
0x00000004380b7810ULL, 0x000fc60007ffe0ffULL, 0x0000000d000d7308ULL, 0x000ee20000000800ULL,
0x000000000c397984ULL, 0x0003e20000000800ULL, 0xfffffff8363d7812ULL, 0x000fe400078ee20bULL,
0x00000008330b7211ULL, 0x000fe200078e20ffULL, 0x000000000a367984ULL, 0x0005e80000000800ULL,
0x00000001460b7824ULL, 0x000fe200078e020bULL, 0xffffffff380c7810ULL, 0x002fe20007ffe0ffULL,
0x000000103d0a7824ULL, 0x004fc600078e0208ULL, 0x000000000b377984ULL, 0x000fe20000000800ULL,
0xfffffff845457812ULL, 0x000fe200078ee20cULL, 0x000000320d317220ULL, 0x008fe20000410000ULL,
0xfffffff83b0d7812ULL, 0x000fe200078ee234ULL, 0x00000001460a7824ULL, 0x000fe200078e020aULL,
0x000400000b3b7984ULL, 0x000fe20000000800ULL, 0x0000000638327810ULL, 0x000fe20007ffe0ffULL,
0x0000003031307221ULL, 0x000fe40000010000ULL, 0x00001f3831337589ULL, 0x000e6200000e0000ULL,
0x000000100d0c7824ULL, 0x000fe200078e0208ULL, 0xfffffff843437812ULL, 0x000fc400078ee232ULL,
0x00001f3c31347589ULL, 0x000ea200000e0000ULL, 0x00000001460c7824ULL, 0x040fe200078e020cULL,
0x00000008430d7211ULL, 0x000fe200078e20ffULL, 0x0000001045087824ULL, 0x000fe200078e0208ULL,
0x0000000009387984ULL, 0x000ee20000000800ULL, 0x00005410ff327816ULL, 0x000fe40000000035ULL,
0x0000000d460d7210ULL, 0x040fe20007ffe0ffULL, 0x00040000093c7984ULL, 0x0008e20000000800ULL,
0x0000000146087824ULL, 0x000fc600078e0208ULL, 0x000000000a0b7984ULL, 0x000ee20000000800ULL,
0x00007610ff097816ULL, 0x010fc60000000035ULL, 0x000400000a3d7984ULL, 0x0008e20000000800ULL,
0x00000033322f7223ULL, 0x002fc6000001002fULL, 0x000400000c357984ULL, 0x000e620000000800ULL,
0x00000033092e7223ULL, 0x080fe2000001002eULL, 0x00007610ff097816ULL, 0x100fe40000000039ULL,
0x00005410ff0a7816ULL, 0x010fe20000000039ULL, 0x000000000c317984ULL, 0x000fe40000000800ULL,
0x00000034092c7223ULL, 0x084fe2000001002cULL, 0x00007610ff097816ULL, 0x100fe20000000036ULL,
0x000000340a2d7223ULL, 0x000fe2000001002dULL, 0x00005410ff0a7816ULL, 0x000fe20000000036ULL,
0x00000000080c7984ULL, 0x000fe40000000800ULL, 0x00000033092a7223ULL, 0x080fe2000001002aULL,
0x00007610ff097816ULL, 0x100fe2000000003aULL, 0x000400000d367984ULL, 0x000ea20000000800ULL,
0x000000330a2b7223ULL, 0x000fe2000001002bULL, 0x00005410ff0a7816ULL, 0x000fc4000000003aULL,
0x0000003409287223ULL, 0x080fe20000010028ULL, 0x00007610ff097816ULL, 0x000fe20000000037ULL,
0x000000000d327984ULL, 0x000f220000000800ULL, 0x000000340a297223ULL, 0x000fe20000010029ULL,
0x00005410ff0a7816ULL, 0x000fe40000000037ULL, 0x0000003309267223ULL, 0x080fe20000010026ULL,
0x00007610ff097816ULL, 0x000fe4000000003bULL, 0x000000330a277223ULL, 0x000fe20000010027ULL,
0x00005410ff0a7816ULL, 0x000fc4000000003bULL, 0x0000003409247223ULL, 0x080fe20000010024ULL,
0x00007610ff097816ULL, 0x008fe40000000038ULL, 0x000000340a257223ULL, 0x000fe40000010025ULL,
0x00040000080a7984ULL, 0x0007220000000800ULL, 0x0000003309227223ULL, 0x000fe20000010022ULL,
0x00007610ff097816ULL, 0x000fca000000003cULL, 0x0000003409207223ULL, 0x000fe20000010020ULL,
0x00005410ff087816ULL, 0x008fe40000000038ULL, 0x00007610ff097816ULL, 0x000fc6000000000bULL,
0x0000003308237223ULL, 0x080fe20000010023ULL, 0x00005410ff087816ULL, 0x000fe2000000003cULL,
0x00000033091e7223ULL, 0x000fe2000001001eULL, 0x00007610ff097816ULL, 0x000fc6000000003dULL,
0x0000003408217223ULL, 0x080fe20000010021ULL, 0x00005410ff087816ULL, 0x000fe2000000000bULL,
0x00000034091c7223ULL, 0x000fe2000001001cULL, 0x00005410ff097816ULL, 0x002fc60000000035ULL,
0x00000033081f7223ULL, 0x000fe2000001001fULL, 0x00005410ff087816ULL, 0x000fe2000000003dULL,
0x00000034091a7223ULL, 0x000fe2000001001aULL, 0x00005410ff097816ULL, 0x004fc60000000036ULL,
0x00000034081d7223ULL, 0x080fe2000001001dULL, 0x00005410ff087816ULL, 0x000fe20000000031ULL,
0x0000003409187223ULL, 0x000fe20000010018ULL, 0x00007610ff097816ULL, 0x000fc60000000036ULL,
0x0000003308177223ULL, 0x000fe20000010017ULL, 0x00007610ff087816ULL, 0x000fe20000000031ULL,
0x0000003409167223ULL, 0x000fe20000010016ULL, 0x00005410ff097816ULL, 0x000fc6000000000cULL,
0x00000033081b7223ULL, 0x080fe2000001001bULL, 0x00007610ff087816ULL, 0x000fe20000000035ULL,
0x0000003309147223ULL, 0x000fe20000010014ULL, 0x00007610ff097816ULL, 0x000fc6000000000cULL,
0x0000003408157223ULL, 0x000fe20000010015ULL, 0x00005410ff087816ULL, 0x010fe20000000032ULL,
0x0000003309127223ULL, 0x000fe20000010012ULL, 0x00005410ff097816ULL, 0x000fc6000000000aULL,
0x0000003308137223ULL, 0x000fe20000010013ULL, 0x00007610ff087816ULL, 0x000fe20000000032ULL,
0x0000003409107223ULL, 0x000fe20000010010ULL, 0x00007610ff097816ULL, 0x000fc6000000000aULL,
0x0000003308197223ULL, 0x000fe40000010019ULL, 0x00000034090e7223ULL, 0x000fe2000001000eULL,
0xfffff48000008947ULL, 0x000fea000383ffffULL, 0x0180000030027810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x7f80000002027812ULL, 0x000fe200078ec0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000193b000077802ULL, 0x002fc40000000f00ULL,
0x0000f73000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff027224ULL, 0x000fe200078e0006ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003000037308ULL, 0x000ea40000001000ULL,
0xbf80000003027423ULL, 0x004fc80000000030ULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000203027223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000a7919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff0b7819ULL, 0x004fc4000001160aULL, 0x000000080a0d7811ULL, 0x040fe400078ff0ffULL,
0x000000030b0f7810ULL, 0x040fe20007ffe0ffULL, 0x00001f0b02067589ULL, 0x000ea200000e0000ULL,
0x000000040b117810ULL, 0x040fe20007ffe0ffULL, 0x000000080b327824ULL, 0x040fe200078e00ffULL,
0x000000030b307819ULL, 0x002fe200000006ffULL, 0x00001f0d02077589ULL, 0x00032200000e0000ULL,
0x000000080d367824ULL, 0x000fe200078e00ffULL, 0x000000020a0a7819ULL, 0x000fe200000006ffULL,
0x000000080b347824ULL, 0x000fc600078e00ffULL, 0xfffffff836367812ULL, 0x000fca00078ee20dULL,
0x0000001036367824ULL, 0x000fe400078e0205ULL, 0x0000001906087220ULL, 0x044fe40000410000ULL,
0x0000002f062f7220ULL, 0x040fe40000410000ULL, 0x0000002e062e7220ULL, 0x040fe40000410000ULL,
0x0000002b062b7220ULL, 0x040fe40000410000ULL, 0x0000002a062a7220ULL, 0x000fe20000410000ULL,
0x0000002f2e2e723eULL, 0x000fe200000010ffULL, 0x0000002706277220ULL, 0x000fc40000410000ULL,
0x0000002606267220ULL, 0x000fe20000410000ULL, 0x0000002b2a2a723eULL, 0x000fe200000010ffULL,
0x0000002306237220ULL, 0x040fe40000410000ULL, 0x0000002206227220ULL, 0x000fe20000410000ULL,
0x000000272626723eULL, 0x000fe200000010ffULL, 0x0000001f061f7220ULL, 0x040fe40000410000ULL,
0x0000001e061e7220ULL, 0x000fe20000410000ULL, 0x000000232222723eULL, 0x000fe200000010ffULL,
0x0000001706177220ULL, 0x000fc40000410000ULL, 0x0000001b06027220ULL, 0x042fe20000410000ULL,
0x000000030b1b7819ULL, 0x040fe200000006ffULL, 0x0000001306137220ULL, 0x000fe20000410000ULL,
0x0000001f1e1e723eULL, 0x000fe200000010ffULL, 0x0000001406147220ULL, 0x000fe20000410000ULL,
0x000000170202723eULL, 0x000fe200000010ffULL, 0x0000001206037220ULL, 0x000fe20000410000ULL,
0x000000010b067810ULL, 0x040fe20007ffe0ffULL, 0x000000080b197824ULL, 0x000fe200078e00ffULL,
0x000000130808723eULL, 0x000fe200000010ffULL, 0x0000001607097220ULL, 0x010fe20000410000ULL,
0x000000140303723eULL, 0x000fe200000010ffULL, 0x000000080b127824ULL, 0x000fe200078e00ffULL,
0xfffffff8190c7812ULL, 0x000fe200078ee206ULL, 0x000000080b167824ULL, 0x040fe200078e00ffULL,
0xffffffff0b197810ULL, 0x000fe20007ffe0ffULL, 0x0000002d072d7220ULL, 0x040fe20000410000ULL,
0xfffffff812127812ULL, 0x000fe200078ee20fULL, 0x0000002c072c7220ULL, 0x040fe20000410000ULL,
0xfffffff816167812ULL, 0x000fe200078ee211ULL, 0x0000002907297220ULL, 0x000fe20000410000ULL,
0x000000050b0f7810ULL, 0x000fe20007ffe0ffULL, 0x0000002807287220ULL, 0x000fe20000410000ULL,
0x000000060b117810ULL, 0x000fe20007ffe0ffULL, 0x0000002507257220ULL, 0x040fe20000410000ULL,
0xfffffff830307812ULL, 0x000fe200078ee20fULL, 0x0000002407247220ULL, 0x040fe20000410000ULL,
0xfffffff832327812ULL, 0x000fe200078ee211ULL, 0x0000002107217220ULL, 0x040fe20000410000ULL,
0xfffffff834347812ULL, 0x000fe200078ee219ULL, 0x0000002007207220ULL, 0x040fe20000410000ULL,
0x0000000512127211ULL, 0x000fe200078e20ffULL, 0x0000001d071d7220ULL, 0x040fe20000410000ULL,
0x0000000534347211ULL, 0x000fe200078e20ffULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x0000002d2c2c723eULL, 0x000fe200000010ffULL, 0x0000001a071a7220ULL, 0x040fe20000410000ULL,
0x000000292828723eULL, 0x000fe200000010ffULL, 0x0000001507157220ULL, 0x040fe20000410000ULL,
0x000000252424723eULL, 0x000fe200000010ffULL, 0x0000001807187220ULL, 0x040fe20000410000ULL,
0x000000212020723eULL, 0x000fe200000010ffULL, 0x0000001007107220ULL, 0x000fe20000410000ULL,
0x0000001d1c1c723eULL, 0x000fe200000010ffULL, 0x000000080b067824ULL, 0x000fe200078e00ffULL,
0x0000001a1515723eULL, 0x000fe200000010ffULL, 0x0000000e07077220ULL, 0x000fe20000410000ULL,
0x000000020b0e7810ULL, 0x000fe20007ffe0ffULL, 0x000000100c0c7824ULL, 0x000fe200078e0205ULL,
0xfffffff806067812ULL, 0x000fe200078ee20bULL, 0x0000001016167824ULL, 0x100fe200078e0205ULL,
0xfffffff81b0e7812ULL, 0x000fe200078ee20eULL, 0x0000001030307824ULL, 0x100fe200078e0205ULL,
0x0000000c0a0b7812ULL, 0x000fe200078ec0ffULL, 0x0000001006067824ULL, 0x100fe200078e0205ULL,
0x000000180909723eULL, 0x000fe200000010ffULL, 0x000000100e0e7824ULL, 0x100fe200078e0205ULL,
0x000000100707723eULL, 0x000fe200000010ffULL, 0x0000001032327824ULL, 0x000fc400078e0205ULL,
0x0000000106057824ULL, 0x000fe200078e020bULL, 0x0000000e0b0f7210ULL, 0x040fe20007ffe0ffULL,
0x000000010b0d7824ULL, 0x040fe200078e020cULL, 0x000000320b327210ULL, 0x040fe20007ffe0ffULL,
0x000000010b117824ULL, 0x040fe200078e0212ULL, 0x0000002e05007388ULL, 0x0003e20000000800ULL,
0x000000010b137824ULL, 0x040fe400078e0216ULL, 0x000000010b307824ULL, 0x040fe200078e0230ULL,
0x0000002a0d007388ULL, 0x0003e20000000800ULL, 0x000000010b347824ULL, 0x000fc400078e0234ULL,
0x000000010b0b7824ULL, 0x000fe200078e0236ULL, 0x000000260f007388ULL, 0x0003e80000000800ULL,
0x0000002211007388ULL, 0x0003e80000000800ULL, 0x0000001e13007388ULL, 0x0003e80000000800ULL,
0x0000000230007388ULL, 0x0003e80000000800ULL, 0x0000000832007388ULL, 0x0003e80000000800ULL,
0x0000000334007388ULL, 0x0003e80000000800ULL, 0x0000002c0b007388ULL, 0x0003e80000000800ULL,
0x000400280d007388ULL, 0x0003e80000000800ULL, 0x000400240f007388ULL, 0x0003e80000000800ULL,
0x0004002011007388ULL, 0x0003e80000000800ULL, 0x0004001c13007388ULL, 0x0003e80000000800ULL,
0x0004001530007388ULL, 0x0003e80000000800ULL, 0x0004000932007388ULL, 0x0003e80000000800ULL,
0x0004000734007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000087919ULL, 0x002e620000000000ULL, 0x0000580000007a24ULL, 0x000fc600078e02ffULL,
0x0000000000097919ULL, 0x000ea20000002600ULL, 0x00000003ff027819ULL, 0x002fca0000011608ULL,
0x0000000102037824ULL, 0x000fca00078e0208ULL, 0x0000000703037812ULL, 0x000fc800078ec0ffULL,
0x0ffffff803037812ULL, 0x000fe400078ef808ULL, 0x0000000708087812ULL, 0x000fe400078ec0ffULL,
0x0000000403047211ULL, 0x000fe200078e20ffULL, 0x0000580002037a24ULL, 0x004fe200078e0209ULL,
0x1ffffff8086f7812ULL, 0x008fc800078ef86fULL, 0x0120000004047984ULL, 0x000e620000000c00ULL,
0x0000000300007211ULL, 0x000fca00078010ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0000027a11ULL, 0x000fc800078048ffULL, 0x00005b0000037a11ULL, 0x000fca00000f4c03ULL,
0x000000106f027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000004075887824ULL, 0x000fe200078e00ffULL,
0x0000002013037810ULL, 0x000fe20007ffe0ffULL, 0x0000010075867824ULL, 0x000fe200078e00ffULL,
0x000000031300780cULL, 0x000fe20003f44070ULL, 0x00000100770e7824ULL, 0x000fe200078e0288ULL,
0x00000001ff087819ULL, 0x004fe20000011675ULL, 0x0000000413097824ULL, 0x000fe400078e0286ULL,
0x0000680073027a24ULL, 0x000fe200078e020eULL, 0x000000130e047210ULL, 0x040fe20007ffe0ffULL,
0x000000010e067824ULL, 0x000fc600078e0203ULL, 0x000000710400720cULL, 0x000fe20003f06070ULL,
0x0000000102047824ULL, 0x040fe200078e0203ULL, 0x0000001302027210ULL, 0x000fe40007ffe0ffULL,
0x000000710600720cULL, 0x000fe20003f26070ULL, 0x0000660004047625ULL, 0x000fc800078e0015ULL,
0x0000660002027625ULL, 0x000fe200078e0015ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cad000ff067f8cULL, 0x000e62000c80043fULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000000277877824ULL, 0x000fe400078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x1c60000002097faeULL, 0x0005e8000c121846ULL, 0x1c68000004097faeULL, 0x0005e2000c921846ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x0000000400027824ULL, 0x104fe200078e0213ULL,
0x000000728700720cULL, 0x000fe20003f06070ULL, 0x0000000475057824ULL, 0x000fc600078e0213ULL,
0x0000000102027819ULL, 0x000fe400000006ffULL, 0x0001ca8005057811ULL, 0x000fc600078e10ffULL,
0x0000640002027a24ULL, 0x000fc800078e0287ULL, 0x0000600002027625ULL, 0x000fca00078e0015ULL,
0x0000000002057faeULL, 0x0005e4000c121846ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000177037810ULL, 0x004fe20007ffe0ffULL,
0x000000806c027824ULL, 0x000fe200078e00ffULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x000000700300720cULL, 0x000fe20003f06070ULL, 0x0000000704047899ULL, 0x000fe2000800063fULL,
0x000000ffff037224ULL, 0x002fe200078e0007ULL, 0x0000004002047812ULL, 0x000fe200078ef80eULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000012a000008947ULL, 0x000fea0003800000ULL, 0x0000000000117919ULL, 0x000e620000000000ULL,
0x0001ca80750c7811ULL, 0x040fe200078e20ffULL, 0x00000200ff137424ULL, 0x000fe200078e00ffULL,
0x00002000750b7811ULL, 0x000fe400078e70ffULL, 0x00000003ff127819ULL, 0x102fe40000011611ULL,
0x0000000411067819ULL, 0x000fe400000006ffULL, 0x00000086120a7211ULL, 0x000fe200078e10ffULL,
0x0000000104077824ULL, 0x000fe200078e0212ULL, 0x0000007006157812ULL, 0x000fe200078ec0ffULL,
0x0000000112097824ULL, 0x000fc400078e0211ULL, 0x01c600000a057984ULL, 0x000e640000000800ULL,
0x0000000405087824ULL, 0x002fe200078e020cULL, 0x0000000e71057217ULL, 0x000fca0007800000ULL,
0x0000000008087984ULL, 0x000e620000000800ULL, 0x0000000105057824ULL, 0x000fe200078e0a0eULL,
0x00000007090e7812ULL, 0x000fc800078ec0ffULL, 0x000000051200720cULL, 0x000fe40003f06070ULL,
0x0ffffff80e0e7812ULL, 0x000fc800078ef811ULL, 0x0000000b0e0d7211ULL, 0x000fe400078e20ffULL,
0x00000004120e7810ULL, 0x000fc80007ffe0ffULL, 0x000000030e177819ULL, 0x040fe200000006ffULL,
0x000000010e107824ULL, 0x000fca00078e0211ULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x0000000408077c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0013ULL,
0x0000000615087210ULL, 0x000fe20007f3e0ffULL, 0x0000000104067824ULL, 0x000fc800078e020eULL,
0x000000ffff097224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000050e00720cULL, 0x000fe40003f06070ULL,
0x00000008120e7810ULL, 0x000fe20007ffe0ffULL, 0x01c610000a077984ULL, 0x000ea80000000800ULL,
0x000000080e177824ULL, 0x000fe400078e00ffULL, 0x00000010100d7824ULL, 0x002fc400078e020bULL,
0x000000010e107824ULL, 0x000fca00078e0211ULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x00000004070f7824ULL, 0x004fcc00078e020cULL, 0x000000000f0f7984ULL, 0x000e640000000800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000000615087210ULL, 0x000fe40007f3e0ffULL, 0x0000000e04067210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff097224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000050e00720cULL, 0x000fe40003f06070ULL,
0x0000000c120e7810ULL, 0x000fe20007ffe0ffULL, 0x01c620000a077984ULL, 0x000ea60000000800ULL,
0x000000030e177819ULL, 0x000fe400000006ffULL, 0x0000000b100d7211ULL, 0x002fe200078e20ffULL,
0x000000010e107824ULL, 0x000fca00078e0211ULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x00000004070f7824ULL, 0x004fcc00078e020cULL, 0x000000000f0f7984ULL, 0x000e640000000800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000000615087210ULL, 0x000fe20007f3e0ffULL, 0x0000000104067824ULL, 0x000fc800078e020eULL,
0x000000ffff097224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000050e00720cULL, 0x000fe40003f06070ULL,
0x00000010120e7810ULL, 0x000fe20007ffe0ffULL, 0x01c630000a077984ULL, 0x000ea80000000800ULL,
0x000000080e177824ULL, 0x000fe400078e00ffULL, 0x00000010100d7824ULL, 0x002fc400078e020bULL,
0x000000010e107824ULL, 0x000fca00078e0211ULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x00000004070f7824ULL, 0x004fcc00078e020cULL, 0x000000000f0f7984ULL, 0x000e640000000800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000000615087210ULL, 0x000fe40007f3e0ffULL, 0x0000000e04067210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff097224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000050e00720cULL, 0x000fe40003f06070ULL,
0x00000014120e7810ULL, 0x000fe20007ffe0ffULL, 0x01c640000a077984ULL, 0x000ea60000000800ULL,
0x000000030e177819ULL, 0x000fe400000006ffULL, 0x0000000b100d7211ULL, 0x002fe200078e20ffULL,
0x000000010e107824ULL, 0x000fca00078e0211ULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x00000004070f7824ULL, 0x004fcc00078e020cULL, 0x000000000f0f7984ULL, 0x000e640000000800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000000615087210ULL, 0x000fe20007f3e0ffULL, 0x0000000104067824ULL, 0x000fc800078e020eULL,
0x000000ffff097224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000050e00720cULL, 0x000fe40003f06070ULL,
0x00000018120e7810ULL, 0x000fe20007ffe0ffULL, 0x01c650000a077984ULL, 0x000ea80000000800ULL,
0x000000080e177824ULL, 0x000fe400078e00ffULL, 0x00000010100d7824ULL, 0x002fc400078e020bULL,
0x000000010e107824ULL, 0x000fca00078e0211ULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x00000004070f7824ULL, 0x004fcc00078e020cULL, 0x000000000f0f7984ULL, 0x000e640000000800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000000615087210ULL, 0x000fe40007f3e0ffULL, 0x0000000e04067210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff097224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000050e00720cULL, 0x000fe40003f06070ULL,
0x0000001c120e7810ULL, 0x000fe20007ffe0ffULL, 0x01c660000a077984ULL, 0x000ea60000000800ULL,
0x000000030e177819ULL, 0x000fe400000006ffULL, 0x0000000b100d7211ULL, 0x002fe200078e20ffULL,
0x000000010e107824ULL, 0x000fca00078e0211ULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x00000004070f7824ULL, 0x004fcc00078e020cULL, 0x000000000f0f7984ULL, 0x000e640000000800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000000615087210ULL, 0x000fe20007f3e0ffULL, 0x0000000104067824ULL, 0x000fc800078e020eULL,
0x000000ffff097224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000050e00720cULL, 0x000fe40003f06070ULL,
0x00000020120e7810ULL, 0x000fe20007ffe0ffULL, 0x01c670000a077984ULL, 0x000ea80000000800ULL,
0x000000080e177824ULL, 0x000fe400078e00ffULL, 0x00000010100d7824ULL, 0x002fc400078e020bULL,
0x000000010e107824ULL, 0x000fca00078e0211ULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x00000004070f7824ULL, 0x004fcc00078e020cULL, 0x000000000f0f7984ULL, 0x000e640000000800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000000615087210ULL, 0x000fe40007f3e0ffULL, 0x0000000e04067210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff097224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000050e00720cULL, 0x000fe40003f06070ULL,
0x00000024120e7810ULL, 0x000fe20007ffe0ffULL, 0x01c680000a077984ULL, 0x000ea60000000800ULL,
0x000000030e177819ULL, 0x000fe400000006ffULL, 0x0000000b100d7211ULL, 0x002fe200078e20ffULL,
0x000000010e107824ULL, 0x000fca00078e0211ULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x00000004070f7824ULL, 0x004fcc00078e020cULL, 0x000000000f0f7984ULL, 0x000e640000000800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000000615087210ULL, 0x000fe20007f3e0ffULL, 0x0000000104067824ULL, 0x000fc800078e020eULL,
0x000000ffff097224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000050e00720cULL, 0x000fe40003f06070ULL,
0x00000028120e7810ULL, 0x000fe20007ffe0ffULL, 0x01c690000a077984ULL, 0x000ea80000000800ULL,
0x000000080e177824ULL, 0x000fe400078e00ffULL, 0x00000010100d7824ULL, 0x002fc400078e020bULL,
0x000000010e107824ULL, 0x000fca00078e0211ULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x00000004070f7824ULL, 0x004fcc00078e020cULL, 0x000000000f0f7984ULL, 0x000e640000000800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000000615087210ULL, 0x000fe40007f3e0ffULL, 0x0000000e04067210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff097224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000050e00720cULL, 0x000fe40003f06070ULL,
0x0000002c120e7810ULL, 0x000fe20007ffe0ffULL, 0x01c6a0000a077984ULL, 0x000ea60000000800ULL,
0x000000030e177819ULL, 0x000fe400000006ffULL, 0x0000000b100d7211ULL, 0x002fe200078e20ffULL,
0x000000010e107824ULL, 0x000fca00078e0211ULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x00000004070f7824ULL, 0x004fcc00078e020cULL, 0x000000000f0f7984ULL, 0x000e640000000800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000000615087210ULL, 0x000fe20007f3e0ffULL, 0x0000000104067824ULL, 0x000fc800078e020eULL,
0x000000ffff097224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000050e00720cULL, 0x000fe40003f06070ULL,
0x00000030120e7810ULL, 0x000fe20007ffe0ffULL, 0x01c6b0000a077984ULL, 0x000ea80000000800ULL,
0x000000080e177824ULL, 0x000fe400078e00ffULL, 0x00000010100d7824ULL, 0x002fc400078e020bULL,
0x000000010e107824ULL, 0x000fca00078e0211ULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x00000004070f7824ULL, 0x004fcc00078e020cULL, 0x000000000f0f7984ULL, 0x000e640000000800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000000615087210ULL, 0x000fe40007f3e0ffULL, 0x0000000e04067210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff097224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000050e00720cULL, 0x000fe40003f06070ULL,
0x00000034120e7810ULL, 0x000fe20007ffe0ffULL, 0x01c6c0000a077984ULL, 0x000ea60000000800ULL,
0x000000030e177819ULL, 0x000fe400000006ffULL, 0x0000000b100d7211ULL, 0x002fe200078e20ffULL,
0x000000010e107824ULL, 0x000fca00078e0211ULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x00000004070f7824ULL, 0x004fcc00078e020cULL, 0x000000000f0f7984ULL, 0x000e640000000800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000000615087210ULL, 0x000fe20007f3e0ffULL, 0x0000000104067824ULL, 0x000fc800078e020eULL,
0x000000ffff097224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000050e00720cULL, 0x000fe40003f06070ULL,
0x00000038120e7810ULL, 0x000fe20007ffe0ffULL, 0x01c6d0000a077984ULL, 0x000ea80000000800ULL,
0x000000080e177824ULL, 0x000fe400078e00ffULL, 0x00000010100d7824ULL, 0x002fc400078e020bULL,
0x000000010e107824ULL, 0x000fca00078e0211ULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x00000004070f7824ULL, 0x004fcc00078e020cULL, 0x000000000f0f7984ULL, 0x000e640000000800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000000615087210ULL, 0x000fe40007f3e0ffULL, 0x0000000e04067210ULL, 0x000fc60007ffe0ffULL,
0x000000ffff097224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000050e00720cULL, 0x000fc60003f06070ULL,
0x01c6e0000a077984ULL, 0x000ea20000000800ULL, 0x0000000b10097211ULL, 0x002fe400078e20ffULL,
0x0000003c12087810ULL, 0x000fca0007ffe0ffULL, 0x0000000104047824ULL, 0x000fe400078e0208ULL,
0x00000004070f7824ULL, 0x004fcc00078e020cULL, 0x000000000f0f7984ULL, 0x000e640000000800ULL,
0x000000040f067c24ULL, 0x002fe2000f8e0206ULL, 0x00000003080f7819ULL, 0x000fc600000006ffULL,
0x00005e0006067625ULL, 0x000fca00078e0013ULL, 0x0000000615067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c46ULL, 0x000000050800720cULL, 0x000fc60003f06070ULL,
0x01c6f0000a0d7984ULL, 0x000ea40000000800ULL, 0x000000040d0d7824ULL, 0x004fe400078e020cULL,
0x00000001080c7824ULL, 0x000fc800078e0211ULL, 0x000000000d0d7984ULL, 0x000ea20000000800ULL,
0xfffffff80f0c7812ULL, 0x000fca00078ee20cULL, 0x000000100c0b7824ULL, 0x000fe400078e020bULL,
0x000000040d047c24ULL, 0x004fc8000f8e0204ULL, 0x00005e0004047625ULL, 0x000fca00078e0013ULL,
0x0000000415047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e2000c101c46ULL,
0x0000117000007947ULL, 0x000fea0003800000ULL, 0x00000000000c7919ULL, 0x000e620000000000ULL,
0x0001ca8075107811ULL, 0x040fe200078e20ffULL, 0x00000200ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000200075127811ULL, 0x000fe400078e70ffULL, 0x00000003ff0d7819ULL, 0x002fe2000001160cULL,
0x000000100c087824ULL, 0x000fc600078e00ffULL, 0x0000000c0d097210ULL, 0x040fe20007ffe0ffULL,
0x000000040d0e7824ULL, 0x000fe200078e0286ULL, 0x0000007008117812ULL, 0x000fe200078ec0ffULL,
0x0000000104067824ULL, 0x000fe200078e020dULL, 0x0000000709097812ULL, 0x000fe400078ec0ffULL,
0x01c600000e057984ULL, 0x000e620000000800ULL, 0x000000040d0b7810ULL, 0x000fca0007ffe0ffULL,
0x000000010b147824ULL, 0x000fe200078e020cULL, 0x0000001005057211ULL, 0x002fcc00078e10ffULL,
0x0000000005057984ULL, 0x000e640000000800ULL, 0x0000000405067c24ULL, 0x002fe2000f8e0206ULL,
0x0ffffff809057812ULL, 0x000fc600078ef80cULL, 0x00005e0006067625ULL, 0x000fc800078e000fULL,
0x0000001005137824ULL, 0x000fe200078e0212ULL, 0x0000001106087210ULL, 0x000fe40007f1e0ffULL,
0x0000000b04067210ULL, 0x000fe20007ffe0ffULL, 0x000000080b0b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fca00000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e8000b901c46ULL, 0x01c610000e057984ULL, 0x000ea20000000800ULL,
0xfffffff80b097812ULL, 0x002fc800078ee214ULL, 0x0000001209137211ULL, 0x000fe400078e20ffULL,
0x000000080d097810ULL, 0x000fca0007ffe0ffULL, 0x0000000109147824ULL, 0x000fe400078e020cULL,
0x0000000405057824ULL, 0x004fcc00078e0210ULL, 0x0000000005057984ULL, 0x000e640000000800ULL,
0x0000000405067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e000fULL,
0x00000011060a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000104067824ULL, 0x000fe200078e0209ULL,
0x0000000309097819ULL, 0x000fc600000006ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a137faeULL, 0x0003e8000b901c46ULL,
0x01c620000e057984ULL, 0x000ea20000000800ULL, 0xfffffff8090b7812ULL, 0x002fca00078ee214ULL,
0x000000100b137824ULL, 0x000fe200078e0212ULL, 0x0000000c0d0b7810ULL, 0x000fca0007ffe0ffULL,
0x000000010b147824ULL, 0x000fe400078e020cULL, 0x0000000405057824ULL, 0x004fcc00078e0210ULL,
0x0000000005057984ULL, 0x000e640000000800ULL, 0x0000000405067c24ULL, 0x002fc8000f8e0206ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fe40007f1e0ffULL,
0x0000000b04067210ULL, 0x000fe20007ffe0ffULL, 0x000000080b0b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fca00000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e8000b901c46ULL, 0x01c630000e057984ULL, 0x000ea20000000800ULL,
0xfffffff80b097812ULL, 0x002fc800078ee214ULL, 0x0000001209137211ULL, 0x000fe400078e20ffULL,
0x000000100d097810ULL, 0x000fca0007ffe0ffULL, 0x0000000109147824ULL, 0x000fe400078e020cULL,
0x0000000405057824ULL, 0x004fcc00078e0210ULL, 0x0000000005057984ULL, 0x000e640000000800ULL,
0x0000000405067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e000fULL,
0x00000011060a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000104067824ULL, 0x000fe200078e0209ULL,
0x0000000309097819ULL, 0x000fc600000006ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a137faeULL, 0x0003e8000b901c46ULL,
0x01c640000e057984ULL, 0x000ea20000000800ULL, 0xfffffff8090b7812ULL, 0x002fca00078ee214ULL,
0x000000100b137824ULL, 0x000fe200078e0212ULL, 0x000000140d0b7810ULL, 0x000fca0007ffe0ffULL,
0x000000010b147824ULL, 0x000fe400078e020cULL, 0x0000000405057824ULL, 0x004fcc00078e0210ULL,
0x0000000005057984ULL, 0x000e640000000800ULL, 0x0000000405067c24ULL, 0x002fc8000f8e0206ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fe40007f1e0ffULL,
0x0000000b04067210ULL, 0x000fe20007ffe0ffULL, 0x000000080b0b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fca00000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e8000b901c46ULL, 0x01c650000e057984ULL, 0x000ea20000000800ULL,
0xfffffff80b097812ULL, 0x002fc800078ee214ULL, 0x0000001209137211ULL, 0x000fe400078e20ffULL,
0x000000180d097810ULL, 0x000fca0007ffe0ffULL, 0x0000000109147824ULL, 0x000fe400078e020cULL,
0x0000000405057824ULL, 0x004fcc00078e0210ULL, 0x0000000005057984ULL, 0x000e640000000800ULL,
0x0000000405067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e000fULL,
0x00000011060a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000104067824ULL, 0x000fe200078e0209ULL,
0x0000000309097819ULL, 0x000fc600000006ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a137faeULL, 0x0003e8000b901c46ULL,
0x01c660000e057984ULL, 0x000ea20000000800ULL, 0xfffffff8090b7812ULL, 0x002fca00078ee214ULL,
0x000000100b137824ULL, 0x000fe200078e0212ULL, 0x0000001c0d0b7810ULL, 0x000fca0007ffe0ffULL,
0x000000010b147824ULL, 0x000fe400078e020cULL, 0x0000000405057824ULL, 0x004fcc00078e0210ULL,
0x0000000005057984ULL, 0x000e640000000800ULL, 0x0000000405067c24ULL, 0x002fc8000f8e0206ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fe40007f1e0ffULL,
0x0000000b04067210ULL, 0x000fe20007ffe0ffULL, 0x000000080b0b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fca00000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e8000b901c46ULL, 0x01c670000e057984ULL, 0x000ea20000000800ULL,
0xfffffff80b097812ULL, 0x002fc800078ee214ULL, 0x0000001209137211ULL, 0x000fe400078e20ffULL,
0x000000200d097810ULL, 0x000fca0007ffe0ffULL, 0x0000000109147824ULL, 0x000fe400078e020cULL,
0x0000000405057824ULL, 0x004fcc00078e0210ULL, 0x0000000005057984ULL, 0x000e640000000800ULL,
0x0000000405067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e000fULL,
0x00000011060a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000104067824ULL, 0x000fe200078e0209ULL,
0x0000000309097819ULL, 0x000fc600000006ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a137faeULL, 0x0003e8000b901c46ULL,
0x01c680000e057984ULL, 0x000ea20000000800ULL, 0xfffffff8090b7812ULL, 0x002fca00078ee214ULL,
0x000000100b137824ULL, 0x000fe200078e0212ULL, 0x000000240d0b7810ULL, 0x000fca0007ffe0ffULL,
0x000000010b147824ULL, 0x000fe400078e020cULL, 0x0000000405057824ULL, 0x004fcc00078e0210ULL,
0x0000000005057984ULL, 0x000e640000000800ULL, 0x0000000405067c24ULL, 0x002fc8000f8e0206ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fe40007f1e0ffULL,
0x0000000b04067210ULL, 0x000fe20007ffe0ffULL, 0x000000080b0b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fca00000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e8000b901c46ULL, 0x01c690000e057984ULL, 0x000ea20000000800ULL,
0xfffffff80b097812ULL, 0x002fc800078ee214ULL, 0x0000001209137211ULL, 0x000fe400078e20ffULL,
0x000000280d097810ULL, 0x000fca0007ffe0ffULL, 0x0000000109147824ULL, 0x000fe400078e020cULL,
0x0000000405057824ULL, 0x004fcc00078e0210ULL, 0x0000000005057984ULL, 0x000e640000000800ULL,
0x0000000405067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e000fULL,
0x00000011060a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000104067824ULL, 0x000fe200078e0209ULL,
0x0000000309097819ULL, 0x000fc600000006ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a137faeULL, 0x0003e8000b901c46ULL,
0x01c6a0000e057984ULL, 0x000ea20000000800ULL, 0xfffffff8090b7812ULL, 0x002fca00078ee214ULL,
0x000000100b137824ULL, 0x000fe200078e0212ULL, 0x0000002c0d0b7810ULL, 0x000fca0007ffe0ffULL,
0x000000010b147824ULL, 0x000fe400078e020cULL, 0x0000000405057824ULL, 0x004fcc00078e0210ULL,
0x0000000005057984ULL, 0x000e640000000800ULL, 0x0000000405067c24ULL, 0x002fc8000f8e0206ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fe40007f1e0ffULL,
0x0000000b04067210ULL, 0x000fe20007ffe0ffULL, 0x000000080b0b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fca00000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e8000b901c46ULL, 0x01c6b0000e057984ULL, 0x000ea20000000800ULL,
0xfffffff80b097812ULL, 0x002fc800078ee214ULL, 0x0000001209137211ULL, 0x000fe400078e20ffULL,
0x000000300d097810ULL, 0x000fca0007ffe0ffULL, 0x0000000109147824ULL, 0x000fe400078e020cULL,
0x0000000405057824ULL, 0x004fcc00078e0210ULL, 0x0000000005057984ULL, 0x000e640000000800ULL,
0x0000000405067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e000fULL,
0x00000011060a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000104067824ULL, 0x000fe200078e0209ULL,
0x0000000309097819ULL, 0x000fc600000006ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a137faeULL, 0x0003e8000b901c46ULL,
0x01c6c0000e057984ULL, 0x000ea20000000800ULL, 0xfffffff8090b7812ULL, 0x002fca00078ee214ULL,
0x000000100b137824ULL, 0x000fe200078e0212ULL, 0x000000340d0b7810ULL, 0x000fca0007ffe0ffULL,
0x000000010b147824ULL, 0x000fe400078e020cULL, 0x0000000405057824ULL, 0x004fcc00078e0210ULL,
0x0000000005057984ULL, 0x000e640000000800ULL, 0x0000000405067c24ULL, 0x002fc8000f8e0206ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fe40007f1e0ffULL,
0x0000000b04067210ULL, 0x000fe20007ffe0ffULL, 0x000000080b0b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fca00000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e8000b901c46ULL, 0x01c6d0000e057984ULL, 0x000ea20000000800ULL,
0xfffffff80b097812ULL, 0x002fe400078ee214ULL, 0x000000380d137810ULL, 0x000fe40007ffe0ffULL,
0x0000001209097211ULL, 0x000fe400078e20ffULL, 0x0000003c0d0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000113087824ULL, 0x000fc800078e020cULL, 0x000000010d0c7824ULL, 0x000fe400078e020cULL,
0x0000000405057824ULL, 0x004fcc00078e0210ULL, 0x0000000005057984ULL, 0x000e640000000800ULL,
0x0000000405067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e000fULL,
0x00000011060a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000104067824ULL, 0x000fe200078e0213ULL,
0x0000000313137819ULL, 0x000fc600000006ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a097faeULL, 0x0003e8000b901c46ULL,
0x01c6e0000e057984ULL, 0x000ea20000000800ULL, 0xfffffff813097812ULL, 0x002fca00078ee208ULL,
0x0000001009097824ULL, 0x000fe400078e0212ULL, 0x0000000405057824ULL, 0x004fcc00078e0210ULL,
0x0000000005057984ULL, 0x000e640000000800ULL, 0x0000000405067c24ULL, 0x002fc8000f8e0206ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106067210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e8000b901c46ULL, 0x01c6f0000e057984ULL, 0x000ea40000000800ULL,
0x0000000405087824ULL, 0x004fe200078e0210ULL, 0x0000000d04057210ULL, 0x000fe20007ffe0ffULL,
0x000000080d0d7824ULL, 0x000fc800078e00ffULL, 0x0000000008087984ULL, 0x000ea20000000800ULL,
0xfffffff80d077812ULL, 0x002fc800078ee20cULL, 0x0000001207077211ULL, 0x000fe200078e20ffULL,
0x0000000408047c24ULL, 0x004fc8000f8e0205ULL, 0x00005e0004047625ULL, 0x000fca00078e000fULL,
0x0000001104047210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e6000b901c46ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000047805ULL, 0x002fc40000015200ULL, 0x01cad400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000906067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01cad400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000707700720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x0000580000047a02ULL, 0x000fe20000000f00ULL, 0x0000002075767824ULL, 0x040fe200078e00ffULL,
0x0001cb5875857811ULL, 0x000fe400078e18ffULL, 0xffffffff70847810ULL, 0x000fe20007ffe0ffULL,
0x0000008004047824ULL, 0x000fc400078e00ffULL, 0x0000010077067824ULL, 0x004fe200078e0288ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000067100720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x008fea0003800000ULL, 0x000000776e00720cULL, 0x000fe20003f44070ULL,
0x000000ffff6f7224ULL, 0x000fe200078e00ffULL, 0x0000000400057802ULL, 0x000fc80000000f00ULL,
0x0000000105057807ULL, 0x000fc40005000000ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x0001c76000247802ULL, 0x000fc40000000f00ULL, 0x0000c60000007944ULL, 0x002fea0003c00000ULL,
0x00000002ff247819ULL, 0x000fe2000001166fULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000246f247207ULL, 0x000fe20001000000ULL, 0x0000227000007945ULL, 0x000fe80003800000ULL,
0x0000030024bd7a24ULL, 0x000fc800078e0277ULL, 0x00000100bdc67824ULL, 0x040fe200078e0288ULL,
0x00000001bd257810ULL, 0x000fc80007ffe0ffULL, 0x000000702500720cULL, 0x000fe40003f06070ULL,
0x00000040c6c57812ULL, 0x000fc800078ec0ffULL, 0x000000c502c57210ULL, 0x000fce0007ffe0ffULL,
0x0000119000008947ULL, 0x000fea0003800000ULL, 0x00000003ff247819ULL, 0x002fe40000011603ULL,
0x0001ca8075277811ULL, 0x000fe400078e20ffULL, 0x000000c671297217ULL, 0x000fe20007800000ULL,
0x00000004242a7824ULL, 0x040fe200078e0286ULL, 0x00000003242c7210ULL, 0x040fe20007ffe0ffULL,
0x0000000124287824ULL, 0x000fe200078e02c5ULL, 0x00000007032b7812ULL, 0x000fe200078ec0ffULL,
0x0000000129297824ULL, 0x000fe200078e0ac6ULL, 0x01c600002a267984ULL, 0x000e620000000800ULL,
0x000000072c2e7812ULL, 0x000fc400078ec0ffULL, 0x0000000424327810ULL, 0x040fe40007ffe0ffULL,
0x000000292400720cULL, 0x000fe40003f26070ULL, 0x0ffffff82e2e7812ULL, 0x100fe200078ef803ULL,
0x0000000132317824ULL, 0x040fe400078e0203ULL, 0x0000000832347824ULL, 0x000fe400078e00ffULL,
0x0000000426267824ULL, 0x002fca00078e0227ULL, 0x0000000026257984ULL, 0x0002a40000000800ULL,
0x000000082b267812ULL, 0x002fe200078efcffULL, 0x00000025042d7224ULL, 0x004fe200078e0228ULL,
0x0000400075257811ULL, 0x000fe200078e70ffULL, 0x00000200ff287424ULL, 0x000fc800078e00ffULL,
0x00005e002d2c7625ULL, 0x000fc800078e0028ULL, 0x000000102e2b7824ULL, 0x000fe400078e0225ULL,
0x00000010262c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c2b7faeULL, 0x0003e2000c901c46ULL, 0x000000293200720cULL, 0x000fc60003f26070ULL,
0x01c610002a2e7984ULL, 0x000ea20000000800ULL, 0xfffffff8342c7812ULL, 0x002fc800078ee231ULL,
0x000000252c2b7211ULL, 0x000fe400078e20ffULL, 0x000000272e307211ULL, 0x004fe200078e10ffULL,
0x00000001322e7824ULL, 0x000fe200078e02c5ULL, 0x0000000824327810ULL, 0x000fc60007ffe0ffULL,
0x00000000302f7984ULL, 0x000e620000000800ULL, 0x0000000332347819ULL, 0x040fe200000006ffULL,
0x0000000132317824ULL, 0x000fe400078e0203ULL, 0x0000002f042f7224ULL, 0x002fc800078e022eULL,
0x00005e002f2e7625ULL, 0x000fcc00078e0028ULL, 0x00000010262e7825ULL, 0x000fca00078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e2b7faeULL, 0x0003e2000c901c46ULL,
0x000000293200720cULL, 0x000fc60003f26070ULL, 0x01c620002a2c7984ULL, 0x000ea20000000800ULL,
0xfffffff8342e7812ULL, 0x002fca00078ee231ULL, 0x000000102e2b7824ULL, 0x000fe400078e0225ULL,
0x000000042c307824ULL, 0x004fe400078e0227ULL, 0x00000001322c7824ULL, 0x000fe200078e02c5ULL,
0x0000000c24327810ULL, 0x000fe40007ffe0ffULL, 0x00000000302d7984ULL, 0x000e640000000800ULL,
0x0000000332317210ULL, 0x040fe20007ffe0ffULL, 0x0000000832347824ULL, 0x000fc400078e00ffULL,
0x0000002d042d7224ULL, 0x002fc800078e022cULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0028ULL,
0x00000010262c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c2b7faeULL, 0x0003e2000c901c46ULL, 0x000000293200720cULL, 0x000fc60003f26070ULL,
0x01c630002a2e7984ULL, 0x000ea20000000800ULL, 0xfffffff8342c7812ULL, 0x002fca00078ee231ULL,
0x000000102c2b7824ULL, 0x000fe400078e0225ULL, 0x000000042e307824ULL, 0x004fe400078e0227ULL,
0x00000001322e7824ULL, 0x000fe200078e02c5ULL, 0x0000001024327810ULL, 0x000fe40007ffe0ffULL,
0x00000000302f7984ULL, 0x000e660000000800ULL, 0x0000000132317824ULL, 0x000fc400078e0203ULL,
0x0000000832347824ULL, 0x000fe400078e00ffULL, 0x0000002f042f7224ULL, 0x002fc800078e022eULL,
0x00005e002f2e7625ULL, 0x000fcc00078e0028ULL, 0x00000010262e7825ULL, 0x000fca00078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e2b7faeULL, 0x0003e2000c901c46ULL,
0x000000293200720cULL, 0x000fc60003f26070ULL, 0x01c640002a2c7984ULL, 0x000ea20000000800ULL,
0xfffffff8342e7812ULL, 0x002fca00078ee231ULL, 0x000000102e2b7824ULL, 0x000fe400078e0225ULL,
0x000000042c307824ULL, 0x004fe200078e0227ULL, 0x000000c5322c7210ULL, 0x000fe40007ffe0ffULL,
0x0000001424327810ULL, 0x000fe40007ffe0ffULL, 0x00000000302d7984ULL, 0x000e660000000800ULL,
0x0000000132317824ULL, 0x000fc400078e0203ULL, 0x0000000832347824ULL, 0x000fe400078e00ffULL,
0x0000002d042d7224ULL, 0x002fc800078e022cULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0028ULL,
0x00000010262c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c2b7faeULL, 0x0003e2000c901c46ULL, 0x000000293200720cULL, 0x000fc60003f26070ULL,
0x01c650002a2e7984ULL, 0x000ea20000000800ULL, 0xfffffff8342c7812ULL, 0x002fc800078ee231ULL,
0x000000252c2b7211ULL, 0x000fe400078e20ffULL, 0x000000272e307211ULL, 0x004fe200078e10ffULL,
0x00000001322e7824ULL, 0x000fe200078e02c5ULL, 0x0000001824327810ULL, 0x000fc60007ffe0ffULL,
0x00000000302f7984ULL, 0x000e620000000800ULL, 0x0000000332347819ULL, 0x040fe200000006ffULL,
0x0000000132317824ULL, 0x000fe400078e0203ULL, 0x0000002f042f7224ULL, 0x002fc800078e022eULL,
0x00005e002f2e7625ULL, 0x000fcc00078e0028ULL, 0x00000010262e7825ULL, 0x000fca00078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e2b7faeULL, 0x0003e2000c901c46ULL,
0x000000293200720cULL, 0x000fc60003f26070ULL, 0x01c660002a2c7984ULL, 0x000ea20000000800ULL,
0xfffffff8342e7812ULL, 0x002fca00078ee231ULL, 0x000000102e2b7824ULL, 0x000fe400078e0225ULL,
0x000000042c307824ULL, 0x004fe400078e0227ULL, 0x00000001322c7824ULL, 0x000fe200078e02c5ULL,
0x0000001c24327810ULL, 0x000fe40007ffe0ffULL, 0x00000000302d7984ULL, 0x000e640000000800ULL,
0x0000000332317210ULL, 0x040fe20007ffe0ffULL, 0x0000000832347824ULL, 0x000fc400078e00ffULL,
0x0000002d042d7224ULL, 0x002fc800078e022cULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0028ULL,
0x00000010262c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c2b7faeULL, 0x0003e2000c901c46ULL, 0x000000293200720cULL, 0x000fc60003f26070ULL,
0x01c670002a2e7984ULL, 0x000ea20000000800ULL, 0xfffffff8342c7812ULL, 0x002fca00078ee231ULL,
0x000000102c2b7824ULL, 0x000fe400078e0225ULL, 0x000000042e307824ULL, 0x004fe400078e0227ULL,
0x00000001322e7824ULL, 0x000fe200078e02c5ULL, 0x0000002024327810ULL, 0x000fe40007ffe0ffULL,
0x00000000302f7984ULL, 0x000e660000000800ULL, 0x0000000132317824ULL, 0x000fc400078e0203ULL,
0x0000000832347824ULL, 0x000fe400078e00ffULL, 0x0000002f042f7224ULL, 0x002fc800078e022eULL,
0x00005e002f2e7625ULL, 0x000fcc00078e0028ULL, 0x00000010262e7825ULL, 0x000fca00078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e2b7faeULL, 0x0003e2000c901c46ULL,
0x000000293200720cULL, 0x000fc60003f26070ULL, 0x01c680002a2c7984ULL, 0x000ea20000000800ULL,
0xfffffff8342e7812ULL, 0x002fca00078ee231ULL, 0x000000102e2b7824ULL, 0x000fe400078e0225ULL,
0x000000042c307824ULL, 0x004fe200078e0227ULL, 0x000000c5322c7210ULL, 0x000fe40007ffe0ffULL,
0x0000002424327810ULL, 0x000fe40007ffe0ffULL, 0x00000000302d7984ULL, 0x000e660000000800ULL,
0x0000000132317824ULL, 0x000fc400078e0203ULL, 0x0000000832347824ULL, 0x000fe400078e00ffULL,
0x0000002d042d7224ULL, 0x002fc800078e022cULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0028ULL,
0x00000010262c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c2b7faeULL, 0x0003e2000c901c46ULL, 0x000000293200720cULL, 0x000fc60003f26070ULL,
0x01c690002a2e7984ULL, 0x000ea20000000800ULL, 0xfffffff8342c7812ULL, 0x002fc800078ee231ULL,
0x000000252c2b7211ULL, 0x000fe400078e20ffULL, 0x000000272e307211ULL, 0x004fe200078e10ffULL,
0x00000001322e7824ULL, 0x000fe200078e02c5ULL, 0x0000002824327810ULL, 0x000fc60007ffe0ffULL,
0x00000000302f7984ULL, 0x000e620000000800ULL, 0x0000000332347819ULL, 0x040fe200000006ffULL,
0x0000000132317824ULL, 0x000fe400078e0203ULL, 0x0000002f042f7224ULL, 0x002fc800078e022eULL,
0x00005e002f2e7625ULL, 0x000fcc00078e0028ULL, 0x00000010262e7825ULL, 0x000fca00078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e2b7faeULL, 0x0003e2000c901c46ULL,
0x000000293200720cULL, 0x000fc60003f26070ULL, 0x01c6a0002a2c7984ULL, 0x000ea20000000800ULL,
0xfffffff8342e7812ULL, 0x002fca00078ee231ULL, 0x000000102e2b7824ULL, 0x000fe400078e0225ULL,
0x000000042c307824ULL, 0x004fe400078e0227ULL, 0x00000001322c7824ULL, 0x000fe200078e02c5ULL,
0x0000002c24327810ULL, 0x000fe40007ffe0ffULL, 0x00000000302d7984ULL, 0x000e640000000800ULL,
0x0000000332317210ULL, 0x040fe20007ffe0ffULL, 0x0000000832347824ULL, 0x000fc400078e00ffULL,
0x0000002d042d7224ULL, 0x002fc800078e022cULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0028ULL,
0x00000010262c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c2b7faeULL, 0x0003e2000c901c46ULL, 0x000000293200720cULL, 0x000fc60003f26070ULL,
0x01c6b0002a2e7984ULL, 0x000ea20000000800ULL, 0xfffffff8342c7812ULL, 0x002fca00078ee231ULL,
0x000000102c2b7824ULL, 0x000fe400078e0225ULL, 0x000000042e307824ULL, 0x004fe400078e0227ULL,
0x00000001322e7824ULL, 0x000fe200078e02c5ULL, 0x0000003024327810ULL, 0x000fe40007ffe0ffULL,
0x00000000302f7984ULL, 0x000e660000000800ULL, 0x0000000132317824ULL, 0x000fc400078e0203ULL,
0x0000000832347824ULL, 0x000fe400078e00ffULL, 0x0000002f042f7224ULL, 0x002fc800078e022eULL,
0x00005e002f2e7625ULL, 0x000fcc00078e0028ULL, 0x00000010262e7825ULL, 0x000fca00078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e2b7faeULL, 0x0003e2000c901c46ULL,
0x000000293200720cULL, 0x000fc60003f26070ULL, 0x01c6c0002a2c7984ULL, 0x000ea20000000800ULL,
0xfffffff8342e7812ULL, 0x002fca00078ee231ULL, 0x000000102e2b7824ULL, 0x000fe400078e0225ULL,
0x000000042c307824ULL, 0x004fe200078e0227ULL, 0x000000c5322c7210ULL, 0x000fe40007ffe0ffULL,
0x0000003424327810ULL, 0x000fe40007ffe0ffULL, 0x00000000302d7984ULL, 0x000e660000000800ULL,
0x0000000132317824ULL, 0x000fc400078e0203ULL, 0x0000000832347824ULL, 0x000fe400078e00ffULL,
0x0000002d042d7224ULL, 0x002fc800078e022cULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0028ULL,
0x00000010262c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c2b7faeULL, 0x0003e2000c901c46ULL, 0x000000293200720cULL, 0x000fc60003f26070ULL,
0x01c6d0002a2e7984ULL, 0x000ea20000000800ULL, 0xfffffff8342c7812ULL, 0x002fc800078ee231ULL,
0x000000252c2b7211ULL, 0x000fe400078e20ffULL, 0x000000272e307211ULL, 0x004fe200078e10ffULL,
0x00000001322e7824ULL, 0x000fe200078e02c5ULL, 0x0000003824327810ULL, 0x000fc60007ffe0ffULL,
0x00000000302f7984ULL, 0x000e620000000800ULL, 0x0000000332347819ULL, 0x040fe200000006ffULL,
0x0000000132317824ULL, 0x000fe400078e0203ULL, 0x0000002f042f7224ULL, 0x002fc800078e022eULL,
0x00005e002f2e7625ULL, 0x000fcc00078e0028ULL, 0x00000010262e7825ULL, 0x000fca00078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e2b7faeULL, 0x0003e2000c901c46ULL,
0x000000293200720cULL, 0x000fc60003f26070ULL, 0x01c6e0002a2c7984ULL, 0x000ea20000000800ULL,
0xfffffff8342e7812ULL, 0x002fca00078ee231ULL, 0x000000102e2b7824ULL, 0x000fe200078e0225ULL,
0x0000003c242e7810ULL, 0x000fca0007ffe0ffULL, 0x000000012e247824ULL, 0x040fe400078e02c5ULL,
0x000000082e317824ULL, 0x000fe400078e00ffULL, 0x000000042c307824ULL, 0x004fe400078e0227ULL,
0x00000001322c7824ULL, 0x000fc600078e02c5ULL, 0x00000000302d7984ULL, 0x0002a40000000800ULL,
0x000000032e307210ULL, 0x002fc80007ffe0ffULL, 0xfffffff831307812ULL, 0x000fca00078ee230ULL,
0x0000001030257824ULL, 0x000fe400078e0225ULL, 0x0000002d042d7224ULL, 0x004fc800078e022cULL,
0x00005e002d2c7625ULL, 0x000fcc00078e0028ULL, 0x00000010262c7825ULL, 0x000fca00078e002cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2b7faeULL, 0x0003e2000c901c46ULL,
0x000000292e00720cULL, 0x000fc60003f26070ULL, 0x01c6f0002a2a7984ULL, 0x000ea40000000800ULL,
0x000000042a277824ULL, 0x004fcc00078e0227ULL, 0x0000000027277984ULL, 0x000ea40000000800ULL,
0x00000027042f7224ULL, 0x004fc800078e0224ULL, 0x00005e002f287625ULL, 0x000fcc00078e0028ULL,
0x0000001026287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028257faeULL, 0x0003e2000c901c46ULL, 0x0000106000007947ULL, 0x000fea0003800000ULL,
0x00000003ff247819ULL, 0x002fe20000011603ULL, 0x00000200ff257424ULL, 0x000fe200078e00ffULL,
0x0001ca8075277811ULL, 0x000fe400078e20ffULL, 0x0000000703287812ULL, 0x000fe200078ec0ffULL,
0x0000000424297824ULL, 0x040fe200078e0286ULL, 0x0000000424307810ULL, 0x040fe20007ffe0ffULL,
0x00000001242a7824ULL, 0x000fe200078e02c5ULL, 0x0000000828287812ULL, 0x000fe400078efcffULL,
0x01c6000029267984ULL, 0x000e620000000800ULL, 0x0000000130317824ULL, 0x100fe200078e0203ULL,
0x00000027262c7211ULL, 0x002fe200078e10ffULL, 0x0000000124267824ULL, 0x000fc800078e0203ULL,
0x000000002c2b7984ULL, 0x000e620000000800ULL, 0x00000007262e7812ULL, 0x000fe400078ec0ffULL,
0x0000400075267811ULL, 0x000fe400078e70ffULL, 0x0ffffff82e2d7812ULL, 0x000fc800078ef803ULL,
0x000000262d2f7211ULL, 0x000fe200078e20ffULL, 0x0000002b042a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0025ULL, 0x00000010282a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2f7faeULL, 0x0003e8000b901c46ULL,
0x01c61000292c7984ULL, 0x000ea40000000800ULL, 0x000000042c2e7824ULL, 0x004fe400078e0227ULL,
0x00000001302c7824ULL, 0x040fe200078e02c5ULL, 0x0000000330307819ULL, 0x000fe400000006ffULL,
0x000000002e2d7984ULL, 0x000ea40000000800ULL, 0xfffffff830317812ULL, 0x000fc400078ee231ULL,
0x0000000824307810ULL, 0x000fc60007ffe0ffULL, 0x0000001031317824ULL, 0x000fe200078e0226ULL,
0x00000003302f7210ULL, 0x002fe20007ffe0ffULL, 0x0000002d042c7224ULL, 0x004fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fcc00078e0025ULL, 0x00000010282c7825ULL, 0x000fca00078e002cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c317faeULL, 0x0003e8000b901c46ULL,
0x01c62000292a7984ULL, 0x000ea40000000800ULL, 0x000000042a2e7824ULL, 0x004fe400078e0227ULL,
0x00000001302a7824ULL, 0x040fe400078e02c5ULL, 0x0000000830307824ULL, 0x000fe200078e00ffULL,
0x000000002e2b7984ULL, 0x000ea80000000800ULL, 0xfffffff8302f7812ULL, 0x000fc400078ee22fULL,
0x0000000c24307810ULL, 0x000fc60007ffe0ffULL, 0x000000102f2f7824ULL, 0x000fe400078e0226ULL,
0x0000000130317824ULL, 0x002fe400078e0203ULL, 0x0000002b042a7224ULL, 0x004fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0025ULL, 0x00000010282a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2f7faeULL, 0x0003e8000b901c46ULL,
0x01c63000292c7984ULL, 0x000ea40000000800ULL, 0x000000042c2e7824ULL, 0x004fe200078e0227ULL,
0x000000c5302c7210ULL, 0x040fe20007ffe0ffULL, 0x0000000830307824ULL, 0x000fc600078e00ffULL,
0x000000002e2d7984ULL, 0x000ea40000000800ULL, 0xfffffff830317812ULL, 0x000fe400078ee231ULL,
0x0000001024307810ULL, 0x000fc60007ffe0ffULL, 0x0000001031317824ULL, 0x000fe400078e0226ULL,
0x00000001302f7824ULL, 0x002fe400078e0203ULL, 0x0000002d042c7224ULL, 0x004fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fcc00078e0025ULL, 0x00000010282c7825ULL, 0x000fca00078e002cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c317faeULL, 0x0003e8000b901c46ULL,
0x01c64000292a7984ULL, 0x000ea40000000800ULL, 0x000000272a2e7211ULL, 0x004fe200078e10ffULL,
0x00000001302a7824ULL, 0x040fe400078e02c5ULL, 0x0000000830307824ULL, 0x000fe400078e00ffULL,
0x000000002e2b7984ULL, 0x000ea60000000800ULL, 0xfffffff8302f7812ULL, 0x000fc400078ee22fULL,
0x0000001424307810ULL, 0x000fe40007ffe0ffULL, 0x000000262f2f7211ULL, 0x000fc600078e20ffULL,
0x0000000130317824ULL, 0x002fe400078e0203ULL, 0x0000002b042a7224ULL, 0x004fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0025ULL, 0x00000010282a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2f7faeULL, 0x0003e8000b901c46ULL,
0x01c65000292c7984ULL, 0x000ea40000000800ULL, 0x000000042c2e7824ULL, 0x004fe400078e0227ULL,
0x00000001302c7824ULL, 0x040fe200078e02c5ULL, 0x0000000330307819ULL, 0x000fe400000006ffULL,
0x000000002e2d7984ULL, 0x000ea40000000800ULL, 0xfffffff830317812ULL, 0x000fc400078ee231ULL,
0x0000001824307810ULL, 0x000fc60007ffe0ffULL, 0x0000001031317824ULL, 0x000fe200078e0226ULL,
0x00000003302f7210ULL, 0x002fe20007ffe0ffULL, 0x0000002d042c7224ULL, 0x004fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fcc00078e0025ULL, 0x00000010282c7825ULL, 0x000fca00078e002cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c317faeULL, 0x0003e8000b901c46ULL,
0x01c66000292a7984ULL, 0x000ea40000000800ULL, 0x000000042a2e7824ULL, 0x004fe400078e0227ULL,
0x00000001302a7824ULL, 0x040fe400078e02c5ULL, 0x0000000830307824ULL, 0x000fe200078e00ffULL,
0x000000002e2b7984ULL, 0x000ea80000000800ULL, 0xfffffff8302f7812ULL, 0x000fc400078ee22fULL,
0x0000001c24307810ULL, 0x000fc60007ffe0ffULL, 0x000000102f2f7824ULL, 0x000fe400078e0226ULL,
0x0000000130317824ULL, 0x002fe400078e0203ULL, 0x0000002b042a7224ULL, 0x004fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0025ULL, 0x00000010282a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2f7faeULL, 0x0003e8000b901c46ULL,
0x01c67000292c7984ULL, 0x000ea40000000800ULL, 0x000000042c2e7824ULL, 0x004fe200078e0227ULL,
0x000000c5302c7210ULL, 0x040fe20007ffe0ffULL, 0x0000000830307824ULL, 0x000fc600078e00ffULL,
0x000000002e2d7984ULL, 0x000ea40000000800ULL, 0xfffffff830317812ULL, 0x000fe400078ee231ULL,
0x0000002024307810ULL, 0x000fc60007ffe0ffULL, 0x0000001031317824ULL, 0x000fe400078e0226ULL,
0x00000001302f7824ULL, 0x002fe400078e0203ULL, 0x0000002d042c7224ULL, 0x004fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fcc00078e0025ULL, 0x00000010282c7825ULL, 0x000fca00078e002cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c317faeULL, 0x0003e8000b901c46ULL,
0x01c68000292a7984ULL, 0x000ea40000000800ULL, 0x000000272a2e7211ULL, 0x004fe200078e10ffULL,
0x00000001302a7824ULL, 0x040fe400078e02c5ULL, 0x0000000830307824ULL, 0x000fe400078e00ffULL,
0x000000002e2b7984ULL, 0x000ea60000000800ULL, 0xfffffff8302f7812ULL, 0x000fc400078ee22fULL,
0x0000002424307810ULL, 0x000fe40007ffe0ffULL, 0x000000262f2f7211ULL, 0x000fc600078e20ffULL,
0x0000000130317824ULL, 0x002fe400078e0203ULL, 0x0000002b042a7224ULL, 0x004fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0025ULL, 0x00000010282a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2f7faeULL, 0x0003e8000b901c46ULL,
0x01c69000292c7984ULL, 0x000ea40000000800ULL, 0x000000042c2e7824ULL, 0x004fe400078e0227ULL,
0x00000001302c7824ULL, 0x040fe200078e02c5ULL, 0x0000000330307819ULL, 0x000fe400000006ffULL,
0x000000002e2d7984ULL, 0x000ea40000000800ULL, 0xfffffff830317812ULL, 0x000fc400078ee231ULL,
0x0000002824307810ULL, 0x000fc60007ffe0ffULL, 0x0000001031317824ULL, 0x000fe200078e0226ULL,
0x00000003302f7210ULL, 0x002fe20007ffe0ffULL, 0x0000002d042c7224ULL, 0x004fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fcc00078e0025ULL, 0x00000010282c7825ULL, 0x000fca00078e002cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c317faeULL, 0x0003e8000b901c46ULL,
0x01c6a000292a7984ULL, 0x000ea40000000800ULL, 0x000000042a2e7824ULL, 0x004fe400078e0227ULL,
0x00000001302a7824ULL, 0x040fe400078e02c5ULL, 0x0000000830307824ULL, 0x000fe200078e00ffULL,
0x000000002e2b7984ULL, 0x000ea80000000800ULL, 0xfffffff8302f7812ULL, 0x000fc400078ee22fULL,
0x0000002c24307810ULL, 0x000fc60007ffe0ffULL, 0x000000102f2f7824ULL, 0x000fe400078e0226ULL,
0x0000000130317824ULL, 0x002fe400078e0203ULL, 0x0000002b042a7224ULL, 0x004fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0025ULL, 0x00000010282a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2f7faeULL, 0x0003e8000b901c46ULL,
0x01c6b000292c7984ULL, 0x000ea40000000800ULL, 0x000000042c2e7824ULL, 0x004fe200078e0227ULL,
0x000000c5302c7210ULL, 0x040fe20007ffe0ffULL, 0x0000000830307824ULL, 0x000fc600078e00ffULL,
0x000000002e2d7984ULL, 0x000ea40000000800ULL, 0xfffffff830317812ULL, 0x000fe400078ee231ULL,
0x0000003024307810ULL, 0x000fc60007ffe0ffULL, 0x0000001031317824ULL, 0x000fe400078e0226ULL,
0x00000001302f7824ULL, 0x002fe400078e0203ULL, 0x0000002d042c7224ULL, 0x004fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fcc00078e0025ULL, 0x00000010282c7825ULL, 0x000fca00078e002cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c317faeULL, 0x0003e8000b901c46ULL,
0x01c6c000292a7984ULL, 0x000ea40000000800ULL, 0x000000272a2e7211ULL, 0x004fe200078e10ffULL,
0x00000001302a7824ULL, 0x040fe400078e02c5ULL, 0x0000000830307824ULL, 0x000fe400078e00ffULL,
0x000000002e2b7984ULL, 0x000ea60000000800ULL, 0xfffffff8302f7812ULL, 0x000fc400078ee22fULL,
0x0000003424307810ULL, 0x000fe40007ffe0ffULL, 0x000000262f2f7211ULL, 0x000fc600078e20ffULL,
0x0000000130317824ULL, 0x002fe400078e0203ULL, 0x0000002b042a7224ULL, 0x004fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0025ULL, 0x00000010282a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2f7faeULL, 0x0003e8000b901c46ULL,
0x01c6d000292c7984ULL, 0x000ea40000000800ULL, 0x000000042c2e7824ULL, 0x004fe400078e0227ULL,
0x00000001302c7824ULL, 0x040fe200078e02c5ULL, 0x0000000330307819ULL, 0x000fe400000006ffULL,
0x000000002e2d7984ULL, 0x000ea40000000800ULL, 0xfffffff830317812ULL, 0x000fc400078ee231ULL,
0x0000003824307810ULL, 0x000fc60007ffe0ffULL, 0x0000001031317824ULL, 0x000fe200078e0226ULL,
0x00000003302f7210ULL, 0x002fe20007ffe0ffULL, 0x0000002d042c7224ULL, 0x004fc800078e022cULL,
0x00005e002c2c7625ULL, 0x000fcc00078e0025ULL, 0x00000010282c7825ULL, 0x000fca00078e002cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c317faeULL, 0x0003e8000b901c46ULL,
0x01c6e000292a7984ULL, 0x000ea40000000800ULL, 0x000000042a2e7824ULL, 0x004fe400078e0227ULL,
0x00000001302a7824ULL, 0x040fe400078e02c5ULL, 0x0000000830307824ULL, 0x000fe200078e00ffULL,
0x000000002e2b7984ULL, 0x0004e80000000800ULL, 0xfffffff8302f7812ULL, 0x000fc400078ee22fULL,
0x0000003c242e7810ULL, 0x004fc60007ffe0ffULL, 0x000000102f2f7824ULL, 0x000fe200078e0226ULL,
0x000000c52e247210ULL, 0x040fe20007ffe0ffULL, 0x000000012e2d7824ULL, 0x042fe400078e0203ULL,
0x000000082e2e7824ULL, 0x000fca00078e00ffULL, 0xfffffff82e2d7812ULL, 0x000fca00078ee22dULL,
0x000000102d2d7824ULL, 0x000fe400078e0226ULL, 0x0000002b042a7224ULL, 0x008fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fcc00078e0025ULL, 0x00000010282a7825ULL, 0x000fca00078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2f7faeULL, 0x0003e8000b901c46ULL,
0x01c6f000292c7984ULL, 0x000ea40000000800ULL, 0x000000042c2c7824ULL, 0x004fca00078e0227ULL,
0x000000002c277984ULL, 0x000ea40000000800ULL, 0x0000002704247224ULL, 0x004fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fcc00078e0025ULL, 0x0000001028247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0xffffffff00257802ULL, 0x002fe40000000f00ULL, 0x0001ea5000247802ULL, 0x000fc40000000f00ULL,
0x0000a31000007944ULL, 0x000fea0003c00000ULL, 0x0000000703c47812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000004ff257819ULL, 0x102fe20000011603ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000008c4787812ULL, 0x000fe200078ef803ULL,
0xffffffff00007948ULL, 0x000fe80003800000ULL, 0x0000000178797824ULL, 0x040fe400078e0225ULL,
0x0000002078247824ULL, 0x000fca00078e00ffULL, 0xffffffe024247812ULL, 0x000fca00078ee279ULL,
0x0000001024247824ULL, 0x000fc400078e00ffULL, 0x0000000325457819ULL, 0x000fe200000006ffULL,
0x0000400075e77824ULL, 0x000fe200078e00ffULL, 0x00000003ff7a7819ULL, 0x000fe20000011603ULL,
0x00000020782a7824ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fe400078ee2c4ULL,
0x000000017a287812ULL, 0x000fe400078ec0ffULL, 0x00002000e7a17810ULL, 0x000fe20007ffe0ffULL,
0x0000000845257824ULL, 0x040fe200078e00ffULL, 0x00000030456b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000128447824ULL, 0x040fe200078e0245ULL, 0x0000001045477810ULL, 0x040fe20007ffe0ffULL,
0x00000008452b7824ULL, 0x000fe200078e00ffULL, 0x0000000279297810ULL, 0x000fe20007ffe0ffULL,
0x0000000128e87824ULL, 0x000fe200078e026bULL, 0xfffffff825ec7812ULL, 0x000fe200078ee244ULL,
0x000000086b2d7824ULL, 0x000fe200078e00ffULL, 0x000000002424783bULL, 0x000fe20000000200ULL,
0x0000000244e67810ULL, 0x000fe20007ffe0ffULL, 0x0000000128947824ULL, 0x000fe200078e0247ULL,
0x000000a1ecc27211ULL, 0x000fe200078e20ffULL, 0x0000000847397824ULL, 0x000fe200078e00ffULL,
0xfffffff82be67812ULL, 0x000fc400078ee2e6ULL, 0x00000003472b7819ULL, 0x000fe200000006ffULL,
0x00000000c240783bULL, 0x000e620000000200ULL, 0x0000002045697810ULL, 0x000fe20007ffe0ffULL,
0x00000010e6be7824ULL, 0x000fe200078e02a1ULL, 0xffffffe02a297812ULL, 0x000fe400078ee229ULL,
0xfffffff82de87812ULL, 0x000fe400078ee2e8ULL, 0xfffffff82b947812ULL, 0x000fe200078ee294ULL,
0x00000008692b7824ULL, 0x000fe200078e00ffULL, 0x0000006928ea7210ULL, 0x000fe20007ffe0ffULL,
0x0000001029297824ULL, 0x000fe200078e00ffULL, 0x00000000be4c783bULL, 0x000fe20000000200ULL,
0x00000010e8bf7824ULL, 0x100fe200078e02a1ULL, 0xfffffff82bea7812ULL, 0x000fe200078ee2eaULL,
0x0000001094c17824ULL, 0x000fe200078e02a1ULL, 0x000000002954783bULL, 0x000fe20000000200ULL,
0x00000012448e7810ULL, 0x000fc40007ffe0ffULL, 0x000000a1eac07211ULL, 0x000fe200078e20ffULL,
0x00000000bf28783bULL, 0x000ea20000000200ULL, 0xfffffff8398e7812ULL, 0x000fe400078ee28eULL,
0x00000022447c7810ULL, 0x000fe20007ffe0ffULL, 0x00000000c134783bULL, 0x000ee20000000200ULL,
0x0000000369397819ULL, 0x000fe200000006ffULL, 0x000000108ebb7824ULL, 0x000fe200078e02a1ULL,
0x00000032447e7810ULL, 0x000fe20007ffe0ffULL, 0x00000000c030783bULL, 0x000f220000000200ULL,
0xfffffff8397c7812ULL, 0x000fc400078ee27cULL, 0x0000000444e47810ULL, 0x040fe20007ffe0ffULL,
0x00000000bb48783bULL, 0x000f220000000200ULL, 0x0000001444957810ULL, 0x000fe20007ffe0ffULL,
0x000000107c8c7824ULL, 0x000fe200078e02a1ULL, 0x0000002444937810ULL, 0x040fe40007ffe0ffULL,
0x0000003444907810ULL, 0x040fe40007ffe0ffULL, 0x000000008c38783bULL, 0x000f220000000200ULL,
0x00000016448b7810ULL, 0x040fe20007ffe0ffULL, 0x00000040242c723cULL, 0x002f6200000418ffULL,
0x0000002644897810ULL, 0x000fc40007ffe0ffULL, 0x00000006448a7810ULL, 0x040fe40007ffe0ffULL,
0x0000003644827810ULL, 0x000fc60007ffe0ffULL, 0x000000422440723cULL, 0x040f7000000418ffULL,
0x00000028245c723cULL, 0x044bee00000418ffULL, 0x000000086b297824ULL, 0x020fe200078e00ffULL,
0x00000034243c723cULL, 0x008f6800000418ffULL, 0xfffffff8297e7812ULL, 0x000fc800078ee27eULL,
0x000000362434723cULL, 0x000f6200000418ffULL, 0x000000107e977824ULL, 0x000fce00078e02a1ULL,
0x0000004c542c723cULL, 0x040ff0000004182cULL, 0x0000004e544c723cULL, 0x000ff00000041840ULL,
0x000000302440723cULL, 0x050f7000000418ffULL, 0x000000322430723cULL, 0x040f7000000418ffULL,
0x0000002a2424723cULL, 0x000b6400000418ffULL, 0x000000009728783bULL, 0x020e6c0000000200ULL,
0x00000048543c723cULL, 0x040f70000004183cULL, 0x0000004a5448723cULL, 0x040bee0000041834ULL,
0x0000000479347810ULL, 0x020fe20007ffe0ffULL, 0x000000385440723cULL, 0x040b620000041840ULL,
0x0000000578357819ULL, 0x000fe200000006ffULL, 0x0000000847367824ULL, 0x000fe200078e00ffULL,
0x000000036b377819ULL, 0x040fe200000006ffULL, 0x000000086b6b7824ULL, 0x000fe200078e00ffULL,
0xffffffe035347812ULL, 0x000fe200078ee234ULL, 0x0000000845357824ULL, 0x000fe200078e00ffULL,
0xfffffff836957812ULL, 0x000fe200078ee295ULL, 0x0000000869387824ULL, 0x020fe200078e00ffULL,
0xfffffff837907812ULL, 0x000fe200078ee290ULL, 0x0000001034347824ULL, 0x000fe200078e00ffULL,
0xfffffff835e47812ULL, 0x000fe200078ee2e4ULL, 0x0000001095967824ULL, 0x000fe200078e02a1ULL,
0xfffffff838937812ULL, 0x000fe200078ee293ULL, 0x0000001090817824ULL, 0x100fe200078e02a1ULL,
0x0000003a5438723cULL, 0x000b620000041830ULL, 0x00000010e4bc7824ULL, 0x100fe200078e02a1ULL,
0x000000003434783bULL, 0x000fe20000000200ULL, 0x0000001093927824ULL, 0x000fe200078e02a1ULL,
0x0000000345457819ULL, 0x000fc400000006ffULL, 0x00000000bc64783bULL, 0x000ea20000000200ULL,
0x0000002078317824ULL, 0x020fe200078e00ffULL, 0x0000000679307810ULL, 0x000fe20007ffe0ffULL,
0x00000028545c723cULL, 0x042b62000004185cULL, 0x000000009660783bULL, 0x000e620000000200ULL,
0x0000000869327824ULL, 0x000fe200078e00ffULL, 0xffffffe031307812ULL, 0x000fe400078ee230ULL,
0x000000009258783bULL, 0x000ee20000000200ULL, 0xfffffff8458a7812ULL, 0x000fe400078ee28aULL,
0x0000000347287819ULL, 0x020fe200000006ffULL, 0x000000008150783bULL, 0x000f220000000200ULL,
0xfffffff832897812ULL, 0x000fe200078ee289ULL, 0x0000002a5454723cULL, 0x000b620000041824ULL,
0xfffffff8288b7812ULL, 0x000fe200078ee28bULL, 0x0000001030287824ULL, 0x000fe200078e00ffULL,
0xfffffff86b827812ULL, 0x000fe200078ee282ULL, 0x00000010897d7824ULL, 0x100fe200078e02a1ULL,
0x000000a18a7f7211ULL, 0x000fe200078e20ffULL, 0x000000108b807824ULL, 0x000fc400078e02a1ULL,
0x00000010827b7824ULL, 0x000fe200078e02a1ULL, 0x000000002828783bULL, 0x020fe80000000200ULL,
0x000000007f68783bULL, 0x000f280000000200ULL, 0x000000008044783bULL, 0x000f280000000200ULL,
0x000000007d30783bULL, 0x000f280000000200ULL, 0x000000007b24783bULL, 0x000f220000000200ULL,
0x00000064342c723cULL, 0x004f62000004182cULL, 0x000080000000791aULL, 0x000fce0000000000ULL,
0x00000060343c723cULL, 0x042f70000004183cULL, 0x000000583440723cULL, 0x048f700000041840ULL,
0x00000066344c723cULL, 0x040f70000004184cULL, 0x000000623448723cULL, 0x040f700000041848ULL,
0x0000005a3438723cULL, 0x040f700000041838ULL, 0x00000050345c723cULL, 0x050f70000004185cULL,
0x000000523434723cULL, 0x000f700000041854ULL, 0x00000068282c723cULL, 0x060b70000004182cULL,
0x00000044283c723cULL, 0x040b70000004183cULL, 0x000000302840723cULL, 0x040b700000041840ULL,
0x0000006a2868723cULL, 0x040b70000004184cULL, 0x000000462844723cULL, 0x040b700000041848ULL,
0x000000322830723cULL, 0x040b700000041838ULL, 0x00000024285c723cULL, 0x040b70000004185cULL,
0x000000262828723cULL, 0x000b620000041834ULL, 0x0000003000007947ULL, 0x000fdc0003800000ULL,
0xffffffff00257802ULL, 0x020fe40000000f00ULL, 0x0001f3d000247802ULL, 0x000fce0000000f00ULL,
0x0000999000007944ULL, 0x000fea0003c00000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000021b000007945ULL, 0x000fe20003800000ULL, 0x0000116000008947ULL, 0x000fea0003800000ULL,
0x000000047a9d7824ULL, 0x040fe200078e0286ULL, 0x0001ca80759b7811ULL, 0x000fe200078e20ffULL,
0x000000017ae57824ULL, 0x040fe200078e02c5ULL, 0x000000c671377217ULL, 0x020fe20007800000ULL,
0x00000200ff997424ULL, 0x000fe200078e00ffULL, 0x01c600009d247984ULL, 0x000e620000000800ULL,
0x000000037a257210ULL, 0x000fe40007ffe0ffULL, 0x0000000137377824ULL, 0x000fe200078e0ac6ULL,
0x00000010c4357812ULL, 0x000fc400078efcffULL, 0x0000000725e27812ULL, 0x000fe400078ec0ffULL,
0x000000377a00720cULL, 0x000fe40003f26070ULL, 0x0ffffff8e2e27812ULL, 0x000fe400078ef803ULL,
0x000000047ab47810ULL, 0x040fe40007ffe0ffULL, 0x000000087ab27810ULL, 0x000fe20007ffe0ffULL,
0x00000010e2ba7824ULL, 0x000fe200078e02a1ULL, 0x0000000c7ab07810ULL, 0x000fe20007ffe0ffULL,
0x00000001b4e37824ULL, 0x000fe200078e02c5ULL, 0x000000107aae7810ULL, 0x000fe20007ffe0ffULL,
0x00000001b4e07824ULL, 0x000fe200078e0203ULL, 0x00000003b0dc7210ULL, 0x000fe20007ffe0ffULL,
0x00000008b4397824ULL, 0x000fe200078e00ffULL, 0x000000c5aedd7210ULL, 0x000fe20007ffe0ffULL,
0x00000001b2e17824ULL, 0x000fe200078e02c5ULL, 0x000000147aac7810ULL, 0x000fe20007ffe0ffULL,
0x00000001b2de7824ULL, 0x000fe200078e0203ULL, 0xfffffff839e07812ULL, 0x000fe200078ee2e0ULL,
0x00000001b0df7824ULL, 0x000fe200078e02c5ULL, 0x00000003b2397819ULL, 0x000fe200000006ffULL,
0x00000001aeda7824ULL, 0x000fe200078e0203ULL, 0x000000a1e0b97211ULL, 0x000fe200078e20ffULL,
0x00000001acdb7824ULL, 0x000fe200078e02c5ULL, 0xfffffff839de7812ULL, 0x000fe200078ee2deULL,
0x00000008b0397824ULL, 0x000fe200078e00ffULL, 0x000000187aaa7810ULL, 0x000fe20007ffe0ffULL,
0x00000001acd87824ULL, 0x000fe200078e0203ULL, 0x0000001c7aa87810ULL, 0x000fe20007ffe0ffULL,
0x00000010deb87824ULL, 0x000fe200078e02a1ULL, 0xfffffff839dc7812ULL, 0x000fe200078ee2dcULL,
0x00000008ae397824ULL, 0x000fe200078e00ffULL, 0x00000003a8d47210ULL, 0x000fe20007ffe0ffULL,
0x0000000424267824ULL, 0x002fe200078e029bULL, 0x000000207aa67810ULL, 0x000fe20007ffe0ffULL,
0x00000010dcb77824ULL, 0x000fe200078e02a1ULL, 0xfffffff839da7812ULL, 0x000fe200078ee2daULL,
0x00000008ac397824ULL, 0x000fe200078e00ffULL, 0x000000c5a6d57210ULL, 0x000fe20007ffe0ffULL,
0x0000000026267984ULL, 0x000e620000000800ULL, 0x00000001aad97824ULL, 0x000fe200078e02c5ULL,
0x000000247aa47810ULL, 0x000fe20007ffe0ffULL, 0x00000010dab67824ULL, 0x000fe200078e02a1ULL,
0xfffffff839d87812ULL, 0x000fe200078ee2d8ULL, 0x00000001aad67824ULL, 0x040fe200078e0203ULL,
0x00000003aa397819ULL, 0x000fe200000006ffULL, 0x00000001a8d77824ULL, 0x000fe200078e02c5ULL,
0x000000a1d8b57211ULL, 0x000fe200078e20ffULL, 0x00000001a6d27824ULL, 0x000fe200078e0203ULL,
0xfffffff839d67812ULL, 0x000fe200078ee2d6ULL, 0x00000008a8397824ULL, 0x000fe200078e00ffULL,
0x000000287aa27810ULL, 0x000fe20007ffe0ffULL, 0x00000001a4d37824ULL, 0x000fe200078e02c5ULL,
0x0000002c7aa07810ULL, 0x000fe20007ffe0ffULL, 0x00000010d6b37824ULL, 0x000fe200078e02a1ULL,
0xfffffff839d47812ULL, 0x000fe200078ee2d4ULL, 0x00000008a6397824ULL, 0x000fe200078e00ffULL,
0x00000003a0cc7210ULL, 0x000fe20007ffe0ffULL, 0x00000001a4d07824ULL, 0x000fe200078e0203ULL,
0x000000307a9e7810ULL, 0x000fe20007ffe0ffULL, 0x00000010d4b17824ULL, 0x000fe200078e02a1ULL,
0xfffffff839d27812ULL, 0x000fe200078ee2d2ULL, 0x00000008a4397824ULL, 0x000fe200078e00ffULL,
0x000000c59ecd7210ULL, 0x000fe20007ffe0ffULL, 0x00000001a2d17824ULL, 0x000fe200078e02c5ULL,
0x000000347a9c7810ULL, 0x000fe20007ffe0ffULL, 0x00000010d2af7824ULL, 0x000fe200078e02a1ULL,
0xfffffff839d07812ULL, 0x000fe200078ee2d0ULL, 0x00000001a2ce7824ULL, 0x040fe200078e0203ULL,
0x00000003a2397819ULL, 0x000fe200000006ffULL, 0x00000001a0cf7824ULL, 0x000fe200078e02c5ULL,
0x000000a1d0ad7211ULL, 0x000fe200078e20ffULL, 0x000000019eca7824ULL, 0x000fe200078e0203ULL,
0xfffffff839ce7812ULL, 0x000fe200078ee2ceULL, 0x00000008a0397824ULL, 0x000fe200078e00ffULL,
0x000000387a9a7810ULL, 0x000fe20007ffe0ffULL, 0x000000019ccb7824ULL, 0x000fe200078e02c5ULL,
0x0000003c7a987810ULL, 0x000fe20007ffe0ffULL, 0x00000010ceab7824ULL, 0x000fe200078e02a1ULL,
0xfffffff839cc7812ULL, 0x000fe200078ee2ccULL, 0x0000002604247224ULL, 0x002fe200078e02e5ULL,
0x000000039a367819ULL, 0x000fe200000006ffULL, 0x000000089e397824ULL, 0x000fe200078e00ffULL,
0x0000000398c37210ULL, 0x000fe20007ffe0ffULL, 0x00005e0024247625ULL, 0x000fc600078e0099ULL,
0xfffffff839ca7812ULL, 0x000fe200078ee2caULL, 0x00000010cca97824ULL, 0x000fe400078e02a1ULL,
0x0000001035247825ULL, 0x000fc800078e0024ULL, 0x00000010caa77824ULL, 0x000fe200078e02a1ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024ba7faeULL, 0x0003e2000c901c46ULL,
0x00000037b400720cULL, 0x000fe20003f26070ULL, 0x000000019cc87824ULL, 0x040fe400078e0203ULL,
0x01c610009d267984ULL, 0x000ea20000000800ULL, 0x000000089c397824ULL, 0x000fe400078e00ffULL,
0x000000019ac97824ULL, 0x040fe400078e02c5ULL, 0x000000019ac77824ULL, 0x000fe200078e0203ULL,
0xfffffff839c87812ULL, 0x000fe200078ee2c8ULL, 0x0000000198c57824ULL, 0x000fc600078e02c5ULL,
0x000000a1c8a57211ULL, 0x000fe400078e20ffULL, 0xfffffff836c77812ULL, 0x000fe200078ee2c7ULL,
0x0000000898367824ULL, 0x000fc800078e00ffULL, 0x00000010c7a37824ULL, 0x000fe200078e02a1ULL,
0xfffffff836c37812ULL, 0x000fca00078ee2c3ULL, 0x00000010c3a17824ULL, 0x000fe200078e02a1ULL,
0x0000009b26347211ULL, 0x004fcc00078e10ffULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404267224ULL, 0x004fc800078e02e3ULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001035267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026b97faeULL, 0x0005e2000c901c46ULL, 0x00000037b200720cULL, 0x000fc60003f26070ULL,
0x01c620009d247984ULL, 0x002e640000000800ULL, 0x0000000424347824ULL, 0x002fcc00078e029bULL,
0x0000000034347984ULL, 0x000e640000000800ULL, 0x0000003404247224ULL, 0x002fc800078e02e1ULL,
0x00005e0024247625ULL, 0x000fcc00078e0099ULL, 0x0000001035267825ULL, 0x004fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026b87faeULL, 0x0003e2000c901c46ULL,
0x00000037b000720cULL, 0x000fc60003f26070ULL, 0x01c630009d247984ULL, 0x000ea40000000800ULL,
0x0000000424347824ULL, 0x004fcc00078e029bULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404247224ULL, 0x004fc800078e02dfULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001035247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024b77faeULL, 0x0005e2000c901c46ULL, 0x00000037ae00720cULL, 0x000fc60003f26070ULL,
0x01c640009d267984ULL, 0x002e640000000800ULL, 0x0000000426347824ULL, 0x002fcc00078e029bULL,
0x0000000034347984ULL, 0x000e640000000800ULL, 0x0000003404267224ULL, 0x002fc800078e02ddULL,
0x00005e0026267625ULL, 0x000fcc00078e0099ULL, 0x0000001035267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026b67faeULL, 0x0003e2000c901c46ULL,
0x00000037ac00720cULL, 0x000fc60003f26070ULL, 0x01c650009d247984ULL, 0x004ea40000000800ULL,
0x0000009b24347211ULL, 0x004fcc00078e10ffULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404247224ULL, 0x004fc800078e02dbULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001035247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024b57faeULL, 0x0005e2000c901c46ULL, 0x00000037aa00720cULL, 0x000fc60003f26070ULL,
0x01c660009d267984ULL, 0x002e640000000800ULL, 0x0000000426347824ULL, 0x002fcc00078e029bULL,
0x0000000034347984ULL, 0x000e640000000800ULL, 0x0000003404267224ULL, 0x002fc800078e02d9ULL,
0x00005e0026267625ULL, 0x000fcc00078e0099ULL, 0x0000001035267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026b37faeULL, 0x0003e2000c901c46ULL,
0x00000037a800720cULL, 0x000fc60003f26070ULL, 0x01c670009d247984ULL, 0x004ea40000000800ULL,
0x0000000424347824ULL, 0x004fcc00078e029bULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404247224ULL, 0x004fc800078e02d7ULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001035247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024b17faeULL, 0x0005e2000c901c46ULL, 0x00000037a600720cULL, 0x000fc60003f26070ULL,
0x01c680009d267984ULL, 0x002e640000000800ULL, 0x0000000426347824ULL, 0x002fcc00078e029bULL,
0x0000000034347984ULL, 0x000e640000000800ULL, 0x0000003404267224ULL, 0x002fc800078e02d5ULL,
0x00005e0026267625ULL, 0x000fcc00078e0099ULL, 0x0000001035267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026af7faeULL, 0x0003e2000c901c46ULL,
0x00000037a400720cULL, 0x000fc60003f26070ULL, 0x01c690009d247984ULL, 0x004ea40000000800ULL,
0x0000009b24347211ULL, 0x004fcc00078e10ffULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404247224ULL, 0x004fc800078e02d3ULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001035247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024ad7faeULL, 0x0005e2000c901c46ULL, 0x00000037a200720cULL, 0x000fc60003f26070ULL,
0x01c6a0009d267984ULL, 0x002e640000000800ULL, 0x0000000426347824ULL, 0x002fcc00078e029bULL,
0x0000000034347984ULL, 0x000e640000000800ULL, 0x0000003404267224ULL, 0x002fc800078e02d1ULL,
0x00005e0026267625ULL, 0x000fcc00078e0099ULL, 0x0000001035267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026ab7faeULL, 0x0003e2000c901c46ULL,
0x00000037a000720cULL, 0x000fc60003f26070ULL, 0x01c6b0009d247984ULL, 0x004ea40000000800ULL,
0x0000000424347824ULL, 0x004fcc00078e029bULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404247224ULL, 0x004fc800078e02cfULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001035247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024a97faeULL, 0x0005e2000c901c46ULL, 0x000000379e00720cULL, 0x000fc60003f26070ULL,
0x01c6c0009d267984ULL, 0x002e640000000800ULL, 0x0000000426347824ULL, 0x002fcc00078e029bULL,
0x0000000034347984ULL, 0x000e640000000800ULL, 0x0000003404267224ULL, 0x002fc800078e02cdULL,
0x00005e0026267625ULL, 0x000fcc00078e0099ULL, 0x0000001035267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026a77faeULL, 0x0003e2000c901c46ULL,
0x000000379c00720cULL, 0x000fc60003f26070ULL, 0x01c6d0009d247984ULL, 0x004ea40000000800ULL,
0x0000009b24347211ULL, 0x004fcc00078e10ffULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404247224ULL, 0x004fc800078e02cbULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001035247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024a57faeULL, 0x0005e2000c901c46ULL, 0x000000379a00720cULL, 0x000fc60003f26070ULL,
0x01c6e0009d267984ULL, 0x002e640000000800ULL, 0x0000000426347824ULL, 0x002fcc00078e029bULL,
0x0000000034347984ULL, 0x000e640000000800ULL, 0x0000003404267224ULL, 0x002fc800078e02c9ULL,
0x00005e0026267625ULL, 0x000fcc00078e0099ULL, 0x0000001035267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026a37faeULL, 0x0003e2000c901c46ULL,
0x000000379800720cULL, 0x000fc60003f26070ULL, 0x01c6f0009d247984ULL, 0x004ea40000000800ULL,
0x0000000424347824ULL, 0x004fcc00078e029bULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404247224ULL, 0x004fc800078e02c5ULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001035247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024a17faeULL, 0x0003e2000c901c46ULL, 0x0000103000007947ULL, 0x000fea0003800000ULL,
0x000000047a9d7824ULL, 0x040fe200078e0286ULL, 0x0001ca80759b7811ULL, 0x000fe200078e20ffULL,
0x000000017ae57824ULL, 0x000fe200078e02c5ULL, 0x00000010c4357812ULL, 0x020fe200078efcffULL,
0x000000017a257824ULL, 0x040fe200078e0203ULL, 0x01c600009d247984ULL, 0x000e620000000800ULL,
0x00000200ff997424ULL, 0x000fe200078e00ffULL, 0x000000047ab47810ULL, 0x000fe40007ffe0ffULL,
0x0000000725e27812ULL, 0x000fc400078ec0ffULL, 0x00000003b4377819ULL, 0x040fe200000006ffULL,
0x00000001b4e37824ULL, 0x000fe200078e02c5ULL, 0x0ffffff8e2e27812ULL, 0x100fe200078ef803ULL,
0x00000001b4e07824ULL, 0x000fe200078e0203ULL, 0x000000087ab27810ULL, 0x000fe40007ffe0ffULL,
0x000000a1e2ba7211ULL, 0x000fe400078e20ffULL, 0xfffffff837e07812ULL, 0x000fe200078ee2e0ULL,
0x00000001b2e17824ULL, 0x040fe200078e02c5ULL, 0x00000003b2de7210ULL, 0x040fe20007ffe0ffULL,
0x00000008b2377824ULL, 0x000fe200078e00ffULL, 0x0000000c7ab07810ULL, 0x000fe20007ffe0ffULL,
0x00000010e0b97824ULL, 0x000fe200078e02a1ULL, 0x000000107aae7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff837de7812ULL, 0x000fe200078ee2deULL, 0x00000001b0dc7824ULL, 0x040fe200078e0203ULL,
0x000000c5b0df7210ULL, 0x040fe20007ffe0ffULL, 0x00000008b0377824ULL, 0x000fe200078e00ffULL,
0x000000147aac7810ULL, 0x000fe20007ffe0ffULL, 0x00000010deb87824ULL, 0x000fe200078e02a1ULL,
0x000000187aaa7810ULL, 0x000fe20007ffe0ffULL, 0x00000001aedd7824ULL, 0x040fe200078e02c5ULL,
0xfffffff837dc7812ULL, 0x000fe200078ee2dcULL, 0x00000001aeda7824ULL, 0x000fe200078e0203ULL,
0x00000003aad67210ULL, 0x000fe20007ffe0ffULL, 0x00000008ae377824ULL, 0x000fe200078e00ffULL,
0x0000001c7aa87810ULL, 0x000fe20007ffe0ffULL, 0x00000010dcb77824ULL, 0x000fe200078e02a1ULL,
0x000000207aa67810ULL, 0x000fe20007ffe0ffULL, 0x00000001acdb7824ULL, 0x040fe200078e02c5ULL,
0xfffffff837da7812ULL, 0x000fe200078ee2daULL, 0x00000001acd87824ULL, 0x000fe200078e0203ULL,
0x0000009b24267211ULL, 0x002fe200078e10ffULL, 0x00000001aad97824ULL, 0x000fe200078e02c5ULL,
0x000000a1dab67211ULL, 0x000fe200078e20ffULL, 0x00000001a8d47824ULL, 0x000fe200078e0203ULL,
0x00000003ac377819ULL, 0x000fe200000006ffULL, 0x00000001a6d57824ULL, 0x000fe200078e02c5ULL,
0x0000000026267984ULL, 0x000e620000000800ULL, 0x000000c5a8d77210ULL, 0x000fe20007ffe0ffULL,
0x00000001a6d27824ULL, 0x000fe200078e0203ULL, 0xfffffff837d87812ULL, 0x000fe200078ee2d8ULL,
0x00000008aa377824ULL, 0x000fe200078e00ffULL, 0x000000247aa47810ULL, 0x000fc40007ffe0ffULL,
0x000000287aa27810ULL, 0x000fe20007ffe0ffULL, 0x00000010d8b57824ULL, 0x000fe200078e02a1ULL,
0xfffffff837d67812ULL, 0x000fe200078ee2d6ULL, 0x00000008a8377824ULL, 0x000fe200078e00ffULL,
0x00000003a2ce7210ULL, 0x000fe20007ffe0ffULL, 0x00000001a4d37824ULL, 0x000fe200078e02c5ULL,
0x0000002c7aa07810ULL, 0x000fe20007ffe0ffULL, 0x00000010d6b37824ULL, 0x000fe200078e02a1ULL,
0xfffffff837d47812ULL, 0x000fe200078ee2d4ULL, 0x00000008a6377824ULL, 0x000fe200078e00ffULL,
0x000000c5a0cf7210ULL, 0x000fe20007ffe0ffULL, 0x00000001a4d07824ULL, 0x000fe200078e0203ULL,
0x000000307a9e7810ULL, 0x000fe20007ffe0ffULL, 0x00000010d4b17824ULL, 0x000fe200078e02a1ULL,
0xfffffff837d27812ULL, 0x000fe200078ee2d2ULL, 0x00000001a2d17824ULL, 0x000fe200078e02c5ULL,
0x00000003a4377819ULL, 0x000fe200000006ffULL, 0x00000001a0cc7824ULL, 0x000fe200078e0203ULL,
0x000000a1d2af7211ULL, 0x000fe200078e20ffULL, 0x000000019ecd7824ULL, 0x000fe200078e02c5ULL,
0xfffffff837d07812ULL, 0x000fe200078ee2d0ULL, 0x00000008a2377824ULL, 0x000fe200078e00ffULL,
0x000000347a9c7810ULL, 0x000fe20007ffe0ffULL, 0x000000019eca7824ULL, 0x000fe200078e0203ULL,
0x000000387a9a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010d0ad7824ULL, 0x000fe200078e02a1ULL,
0xfffffff837ce7812ULL, 0x000fe200078ee2ceULL, 0x00000008a0377824ULL, 0x000fe200078e00ffULL,
0x000000039ac77210ULL, 0x000fe20007ffe0ffULL, 0x000000019ccb7824ULL, 0x000fe200078e02c5ULL,
0x0000003c7a987810ULL, 0x000fe20007ffe0ffULL, 0x00000010ceab7824ULL, 0x000fe200078e02a1ULL,
0xfffffff837cc7812ULL, 0x000fe200078ee2ccULL, 0x0000002604247224ULL, 0x002fc400078e02e5ULL,
0x000000089e377824ULL, 0x000fe400078e00ffULL, 0x00005e0024247625ULL, 0x000fc600078e0099ULL,
0xfffffff837ca7812ULL, 0x000fe200078ee2caULL, 0x00000010cca97824ULL, 0x000fe200078e02a1ULL,
0x000000039c377819ULL, 0x000fe200000006ffULL, 0x0000001035247825ULL, 0x000fe200078e0024ULL,
0x000000a1caa77211ULL, 0x000fc600078e20ffULL, 0x000000019cc87824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024ba7faeULL, 0x0003e2000b901c46ULL,
0x000000019ac97824ULL, 0x000fe200078e02c5ULL, 0x000000c598c57210ULL, 0x000fe20007ffe0ffULL,
0x000000089a367824ULL, 0x000fe200078e00ffULL, 0x01c610009d267984ULL, 0x000ea20000000800ULL,
0xfffffff837c87812ULL, 0x000fe200078ee2c8ULL, 0x0000000198c37824ULL, 0x000fe400078e0203ULL,
0xfffffff836c77812ULL, 0x000fe200078ee2c7ULL, 0x0000000898367824ULL, 0x000fc400078e00ffULL,
0x00000010c8a57824ULL, 0x100fe400078e02a1ULL, 0x00000010c7a37824ULL, 0x000fe200078e02a1ULL,
0xfffffff836c37812ULL, 0x000fca00078ee2c3ULL, 0x00000010c3a17824ULL, 0x000fe400078e02a1ULL,
0x0000000426347824ULL, 0x004fcc00078e029bULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404267224ULL, 0x004fc800078e02e3ULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001035267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026b97faeULL, 0x0005e8000b901c46ULL, 0x01c620009d247984ULL, 0x002e640000000800ULL,
0x0000000424347824ULL, 0x002fcc00078e029bULL, 0x0000000034347984ULL, 0x000e640000000800ULL,
0x0000003404247224ULL, 0x002fc800078e02e1ULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001035267825ULL, 0x004fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026b87faeULL, 0x0003e8000b901c46ULL, 0x01c630009d247984ULL, 0x000ea40000000800ULL,
0x0000000424347824ULL, 0x004fcc00078e029bULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404247224ULL, 0x004fc800078e02dfULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001035247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024b77faeULL, 0x0005e8000b901c46ULL, 0x01c640009d267984ULL, 0x002e640000000800ULL,
0x0000009b26347211ULL, 0x002fcc00078e10ffULL, 0x0000000034347984ULL, 0x000e640000000800ULL,
0x0000003404267224ULL, 0x002fc800078e02ddULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001035267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026b67faeULL, 0x0003e8000b901c46ULL, 0x01c650009d247984ULL, 0x004ea40000000800ULL,
0x0000000424347824ULL, 0x004fcc00078e029bULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404247224ULL, 0x004fc800078e02dbULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001035247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024b57faeULL, 0x0005e8000b901c46ULL, 0x01c660009d267984ULL, 0x002e640000000800ULL,
0x0000000426347824ULL, 0x002fcc00078e029bULL, 0x0000000034347984ULL, 0x000e640000000800ULL,
0x0000003404267224ULL, 0x002fc800078e02d9ULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001035267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026b37faeULL, 0x0003e8000b901c46ULL, 0x01c670009d247984ULL, 0x004ea40000000800ULL,
0x0000000424347824ULL, 0x004fcc00078e029bULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404247224ULL, 0x004fc800078e02d7ULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001035247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024b17faeULL, 0x0005e8000b901c46ULL, 0x01c680009d267984ULL, 0x002e640000000800ULL,
0x0000009b26347211ULL, 0x002fcc00078e10ffULL, 0x0000000034347984ULL, 0x000e640000000800ULL,
0x0000003404267224ULL, 0x002fc800078e02d5ULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001035267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026af7faeULL, 0x0003e8000b901c46ULL, 0x01c690009d247984ULL, 0x004ea40000000800ULL,
0x0000000424347824ULL, 0x004fcc00078e029bULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404247224ULL, 0x004fc800078e02d3ULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001035247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024ad7faeULL, 0x0005e8000b901c46ULL, 0x01c6a0009d267984ULL, 0x002e640000000800ULL,
0x0000000426347824ULL, 0x002fcc00078e029bULL, 0x0000000034347984ULL, 0x000e640000000800ULL,
0x0000003404267224ULL, 0x002fc800078e02d1ULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001035267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026ab7faeULL, 0x0003e8000b901c46ULL, 0x01c6b0009d247984ULL, 0x004ea40000000800ULL,
0x0000000424347824ULL, 0x004fcc00078e029bULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404247224ULL, 0x004fc800078e02cfULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001035247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024a97faeULL, 0x0005e8000b901c46ULL, 0x01c6c0009d267984ULL, 0x002e640000000800ULL,
0x0000009b26347211ULL, 0x002fcc00078e10ffULL, 0x0000000034347984ULL, 0x000e640000000800ULL,
0x0000003404267224ULL, 0x002fc800078e02cdULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001035267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026a77faeULL, 0x0003e8000b901c46ULL, 0x01c6d0009d247984ULL, 0x004ea40000000800ULL,
0x0000000424347824ULL, 0x004fcc00078e029bULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404247224ULL, 0x004fc800078e02cbULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001035247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024a57faeULL, 0x0005e8000b901c46ULL, 0x01c6e0009d267984ULL, 0x002e640000000800ULL,
0x0000000426347824ULL, 0x002fcc00078e029bULL, 0x0000000034347984ULL, 0x000e640000000800ULL,
0x0000003404267224ULL, 0x002fc800078e02c9ULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001035267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026a37faeULL, 0x0003e8000b901c46ULL, 0x01c6f0009d247984ULL, 0x004ea40000000800ULL,
0x0000000424347824ULL, 0x004fcc00078e029bULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404247224ULL, 0x004fc800078e02c5ULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001035247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024a17faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000879247810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000578257819ULL, 0x040fe200000006ffULL, 0x0000002078517824ULL, 0x000fe200078e00ffULL,
0x00004000e7e77810ULL, 0x000fe20007ffe0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffe025247812ULL, 0x000fe200078ee224ULL, 0x00001cb000007945ULL, 0x000fe20003800000ULL,
0x000000e7ea917211ULL, 0x080fe200078e20ffULL, 0x00000010ec9f7824ULL, 0x100fe200078e02e7ULL,
0x0000000a79507810ULL, 0x000fe20007ffe0ffULL, 0x0000001024347824ULL, 0x000fe200078e00ffULL,
0x000000e793937211ULL, 0x000fe200078e20ffULL, 0x0000001094947824ULL, 0x100fe200078e02e7ULL,
0x000000009f4c783bULL, 0x000fe20000000200ULL, 0x00000010e88d7824ULL, 0x100fe200078e02e7ULL,
0xffffffe051507812ULL, 0x000fe200078ee250ULL, 0x000000108e8e7824ULL, 0x100fe200078e02e7ULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0x000000107c837824ULL, 0x100fe200078e02e7ULL,
0x0000000450507819ULL, 0x000fe200000006ffULL, 0x00000010e68f7824ULL, 0x100fe200078e02e7ULL,
0x000000009438783bULL, 0x000ea20000000200ULL, 0x000000107e7e7824ULL, 0x000fc400078e02e7ULL,
0x00000010e47c7824ULL, 0x100fe200078e02e7ULL, 0x000000009124783bULL, 0x000ee20000000200ULL,
0x0000001095957824ULL, 0x100fe400078e02e7ULL, 0x0000001090907824ULL, 0x100fe200078e02e7ULL,
0x000000008d48783bULL, 0x000f220000000200ULL, 0x000000108a8a7824ULL, 0x100fe400078e02e7ULL,
0x000000108b8b7824ULL, 0x100fe200078e02e7ULL, 0x000000005050783bULL, 0x000fe20000000200ULL,
0x0000001089897824ULL, 0x000fc400078e02e7ULL, 0x0000001082827824ULL, 0x000fe200078e02e7ULL,
0x000000008f54783bULL, 0x000fe80000000200ULL, 0x000000009564783bULL, 0x000fe80000000200ULL,
0x000000009358783bULL, 0x000fe20000000200ULL, 0x0000004c342c723cULL, 0x042ff0000004182cULL,
0x0000004e3468723cULL, 0x040be40000041868ULL, 0x000000008e4c783bULL, 0x020e6c0000000200ULL,
0x00000038343c723cULL, 0x044f70000004183cULL, 0x0000003a3444723cULL, 0x040b640000041844ULL,
0x000000008338783bULL, 0x020eac0000000200ULL, 0x000000243440723cULL, 0x048f700000041840ULL,
0x000000263430723cULL, 0x040b640000041830ULL, 0x000000007e24783bULL, 0x020eec0000000200ULL,
0x00000048345c723cULL, 0x050b6e000004185cULL, 0x0000000c79487810ULL, 0x020fe20007ffe0ffULL,
0x0000004a3428723cULL, 0x000b620000041828ULL, 0x0000000578497819ULL, 0x000fc800000006ffULL,
0xffffffe049487812ULL, 0x000fc600078ee248ULL, 0x0000004c503c723cULL, 0x042fe4000004183cULL,
0x0000001048347824ULL, 0x020fe400078e00ffULL, 0x000000007c48783bULL, 0x000fe80000000200ULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0x0000004e5044723cULL, 0x040be60000041844ULL,
0x00000000904c783bULL, 0x020f2a0000000200ULL, 0x000000385040723cULL, 0x044ff00000041840ULL,
0x0000003a5038723cULL, 0x040bee0000041830ULL, 0x0000002078317824ULL, 0x020fe200078e00ffULL,
0x0000000e79307810ULL, 0x000fe20007ffe0ffULL, 0x00000054502c723cULL, 0x000f66000004182cULL,
0xffffffe031307812ULL, 0x000fc800078ee230ULL, 0x0000000430607819ULL, 0x000fe200000006ffULL,
0x000000565068723cULL, 0x040b620000041868ULL, 0x000000008b30783bULL, 0x000fe80000000200ULL,
0x000000006060783bULL, 0x000fe60000000200ULL, 0x00000024505c723cULL, 0x048f64000004185cULL,
0x000000008954783bULL, 0x020fec0000000200ULL, 0x000000265050723cULL, 0x000b640000041828ULL,
0x000000008a28783bULL, 0x020ea80000000200ULL, 0x000000008224783bULL, 0x000ee20000000200ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x00000048342c723cULL, 0x042f70000004182cULL,
0x00000064343c723cULL, 0x040f70000004183cULL, 0x000000583440723cULL, 0x040f700000041840ULL,
0x0000004a3448723cULL, 0x040f700000041868ULL, 0x000000663444723cULL, 0x040f700000041844ULL,
0x0000005a3438723cULL, 0x040f700000041838ULL, 0x0000004c345c723cULL, 0x050f70000004185cULL,
0x0000004e3434723cULL, 0x000f700000041850ULL, 0x00000028602c723cULL, 0x064f70000004182cULL,
0x00000030603c723cULL, 0x040f70000004183cULL, 0x000000546040723cULL, 0x040f700000041840ULL,
0x0000002a6028723cULL, 0x040f700000041848ULL, 0x000000326030723cULL, 0x040f700000041844ULL,
0x000000566054723cULL, 0x040f700000041838ULL, 0x00000024605c723cULL, 0x048f70000004185cULL,
0x000000266060723cULL, 0x000b6e0000041834ULL, 0x000000036f347812ULL, 0x020fc800078ec0ffULL,
0x000000ff34347207ULL, 0x000fe20005000000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000c4000008947ULL, 0x000fea0003800000ULL, 0x01c600009d247984ULL, 0x000e620000000800ULL,
0x000000c671357217ULL, 0x000fe20007800000ULL, 0x00000010e2397824ULL, 0x100fe200078e02e7ULL,
0x00000018c4377812ULL, 0x000fe200078efcffULL, 0x00000010c7c77824ULL, 0x000fe200078e02e7ULL,
0x000000e7e03b7211ULL, 0x080fe200078e20ffULL, 0x0000000135357824ULL, 0x000fe200078e0ac6ULL,
0x000000e7c3c37211ULL, 0x000fc800078e20ffULL, 0x000000357a00720cULL, 0x000fe40003f06070ULL,
0x0000009b24267211ULL, 0x002fcc00078e10ffULL, 0x0000000026267984ULL, 0x000e640000000800ULL,
0x0000002604247224ULL, 0x002fc800078e02e5ULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001037247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024397faeULL, 0x0003e2000c101c46ULL, 0x00000035b400720cULL, 0x000fc60003f06070ULL,
0x01c610009d367984ULL, 0x000ea20000000800ULL, 0x00000010de397824ULL, 0x002fe400078e02e7ULL,
0x0000000436367824ULL, 0x004fcc00078e029bULL, 0x0000000036367984ULL, 0x000e640000000800ULL,
0x0000003604267224ULL, 0x002fc800078e02e3ULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001037267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000263b7faeULL, 0x0003e2000c101c46ULL, 0x00000035b200720cULL, 0x000fc60003f06070ULL,
0x01c620009d387984ULL, 0x000ea20000000800ULL, 0x000000e7dc3b7211ULL, 0x002fe200078e20ffULL,
0x0000000438387824ULL, 0x004fcc00078e029bULL, 0x0000000038387984ULL, 0x000e640000000800ULL,
0x0000003804247224ULL, 0x002fc800078e02e1ULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001037247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024397faeULL, 0x0003e2000c101c46ULL, 0x00000035b000720cULL, 0x000fc60003f06070ULL,
0x01c630009d367984ULL, 0x000ea20000000800ULL, 0x00000010da397824ULL, 0x002fe400078e02e7ULL,
0x0000000436367824ULL, 0x004fcc00078e029bULL, 0x0000000036367984ULL, 0x000e640000000800ULL,
0x0000003604267224ULL, 0x002fc800078e02dfULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001037267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000263b7faeULL, 0x0003e2000c101c46ULL, 0x00000035ae00720cULL, 0x000fc60003f06070ULL,
0x01c640009d387984ULL, 0x000ea20000000800ULL, 0x000000e7d83b7211ULL, 0x002fe200078e20ffULL,
0x0000000438387824ULL, 0x004fcc00078e029bULL, 0x0000000038387984ULL, 0x000e640000000800ULL,
0x0000003804247224ULL, 0x002fc800078e02ddULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001037247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024397faeULL, 0x0003e2000c101c46ULL, 0x00000035ac00720cULL, 0x000fc60003f06070ULL,
0x01c650009d367984ULL, 0x000ea20000000800ULL, 0x00000010d6397824ULL, 0x002fe400078e02e7ULL,
0x0000000436367824ULL, 0x004fcc00078e029bULL, 0x0000000036367984ULL, 0x000e640000000800ULL,
0x0000003604267224ULL, 0x002fc800078e02dbULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001037267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000263b7faeULL, 0x0003e2000c101c46ULL, 0x00000035aa00720cULL, 0x000fc60003f06070ULL,
0x01c660009d387984ULL, 0x000ea20000000800ULL, 0x000000e7d43b7211ULL, 0x002fe200078e20ffULL,
0x0000000438387824ULL, 0x004fcc00078e029bULL, 0x0000000038387984ULL, 0x000e640000000800ULL,
0x0000003804247224ULL, 0x002fc800078e02d9ULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001037247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024397faeULL, 0x0003e2000c101c46ULL, 0x00000035a800720cULL, 0x000fc60003f06070ULL,
0x01c670009d367984ULL, 0x000ea20000000800ULL, 0x00000010d2397824ULL, 0x002fe400078e02e7ULL,
0x0000000436367824ULL, 0x004fcc00078e029bULL, 0x0000000036367984ULL, 0x000e640000000800ULL,
0x0000003604267224ULL, 0x002fc800078e02d7ULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001037267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000263b7faeULL, 0x0003e2000c101c46ULL, 0x00000035a600720cULL, 0x000fc60003f06070ULL,
0x01c680009d387984ULL, 0x000ea20000000800ULL, 0x000000e7d03b7211ULL, 0x002fe200078e20ffULL,
0x0000000438387824ULL, 0x004fcc00078e029bULL, 0x0000000038387984ULL, 0x000e640000000800ULL,
0x0000003804247224ULL, 0x002fc800078e02d5ULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001037247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024397faeULL, 0x0003e2000c101c46ULL, 0x00000035a400720cULL, 0x000fc60003f06070ULL,
0x01c690009d367984ULL, 0x000ea20000000800ULL, 0x00000010ce397824ULL, 0x002fe400078e02e7ULL,
0x0000000436367824ULL, 0x004fcc00078e029bULL, 0x0000000036367984ULL, 0x000e640000000800ULL,
0x0000003604267224ULL, 0x002fc800078e02d3ULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001037267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000263b7faeULL, 0x0003e2000c101c46ULL, 0x00000035a200720cULL, 0x000fc60003f06070ULL,
0x01c6a0009d387984ULL, 0x000ea20000000800ULL, 0x000000e7cc3b7211ULL, 0x002fe200078e20ffULL,
0x0000000438387824ULL, 0x004fcc00078e029bULL, 0x0000000038387984ULL, 0x000e640000000800ULL,
0x0000003804247224ULL, 0x002fc800078e02d1ULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001037247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024397faeULL, 0x0003e2000c101c46ULL, 0x00000035a000720cULL, 0x000fc60003f06070ULL,
0x01c6b0009d367984ULL, 0x000ea20000000800ULL, 0x00000010ca397824ULL, 0x002fe400078e02e7ULL,
0x0000000436367824ULL, 0x004fcc00078e029bULL, 0x0000000036367984ULL, 0x000e640000000800ULL,
0x0000003604267224ULL, 0x002fc800078e02cfULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001037267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000263b7faeULL, 0x0003e2000c101c46ULL, 0x000000359e00720cULL, 0x000fc60003f06070ULL,
0x01c6c0009d387984ULL, 0x000ea20000000800ULL, 0x000000e7c83b7211ULL, 0x002fe200078e20ffULL,
0x0000000438387824ULL, 0x004fcc00078e029bULL, 0x0000000038387984ULL, 0x000e640000000800ULL,
0x0000003804247224ULL, 0x002fc800078e02cdULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001037247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024397faeULL, 0x0003e2000c101c46ULL, 0x000000359c00720cULL, 0x000fc60003f06070ULL,
0x01c6d0009d367984ULL, 0x000ea40000000800ULL, 0x0000000436367824ULL, 0x004fcc00078e029bULL,
0x0000000036367984ULL, 0x000ea40000000800ULL, 0x0000003604267224ULL, 0x004fc800078e02cbULL,
0x00005e0026267625ULL, 0x000fcc00078e0099ULL, 0x0000001037267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000263b7faeULL, 0x0005e2000c101c46ULL,
0x000000359a00720cULL, 0x000fc60003f06070ULL, 0x01c6e0009d387984ULL, 0x000ee40000000800ULL,
0x0000000438387824ULL, 0x008fcc00078e029bULL, 0x0000000038387984ULL, 0x000e640000000800ULL,
0x0000003804247224ULL, 0x002fc800078e02c9ULL, 0x00005e0024247625ULL, 0x000fcc00078e0099ULL,
0x0000001037247825ULL, 0x000fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024c77faeULL, 0x0003e2000c101c46ULL, 0x000000359800720cULL, 0x000fc60003f06070ULL,
0x01c6f0009d367984ULL, 0x000ee40000000800ULL, 0x0000000436367824ULL, 0x008fcc00078e029bULL,
0x0000000036367984ULL, 0x000ea40000000800ULL, 0x0000003604267224ULL, 0x004fc800078e02c5ULL,
0x00005e0026267625ULL, 0x000fcc00078e0099ULL, 0x0000001037267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026c37faeULL, 0x0003e2000c101c46ULL,
0x00000b1000007947ULL, 0x000fea0003800000ULL, 0x01c600009d247984ULL, 0x000e620000000800ULL,
0x00000018c4357812ULL, 0x000fe200078efcffULL, 0x00000010e2377824ULL, 0x100fe200078e02e7ULL,
0x000000e7e0397211ULL, 0x080fe200078e20ffULL, 0x00000010c7c77824ULL, 0x000fe200078e02e7ULL,
0x000000e7c3c37211ULL, 0x000fe200078e20ffULL, 0x0000000424267824ULL, 0x002fcc00078e029bULL,
0x0000000026267984ULL, 0x000e640000000800ULL, 0x0000002604247224ULL, 0x002fc800078e02e5ULL,
0x00005e0024247625ULL, 0x000fcc00078e0099ULL, 0x0000001035247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024377faeULL, 0x0003e8000b901c46ULL,
0x01c610009d367984ULL, 0x000ea20000000800ULL, 0x00000010de377824ULL, 0x002fe400078e02e7ULL,
0x0000000436367824ULL, 0x004fcc00078e029bULL, 0x0000000036367984ULL, 0x000e640000000800ULL,
0x0000003604387224ULL, 0x002fc800078e02e3ULL, 0x00005e0038267625ULL, 0x000fcc00078e0099ULL,
0x0000001035267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026397faeULL, 0x0003e8000b901c46ULL, 0x01c620009d387984ULL, 0x000ea20000000800ULL,
0x000000e7dc397211ULL, 0x002fe200078e20ffULL, 0x0000000438387824ULL, 0x004fcc00078e029bULL,
0x0000000038387984ULL, 0x000e640000000800ULL, 0x0000003804247224ULL, 0x002fc800078e02e1ULL,
0x00005e0024247625ULL, 0x000fcc00078e0099ULL, 0x0000001035247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024377faeULL, 0x0003e8000b901c46ULL,
0x01c630009d367984ULL, 0x000ea20000000800ULL, 0x00000010da377824ULL, 0x002fe400078e02e7ULL,
0x0000000436367824ULL, 0x004fcc00078e029bULL, 0x0000000036367984ULL, 0x000e640000000800ULL,
0x0000003604267224ULL, 0x002fc800078e02dfULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001035267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026397faeULL, 0x0003e8000b901c46ULL, 0x01c640009d387984ULL, 0x000ea20000000800ULL,
0x000000e7d8397211ULL, 0x002fe200078e20ffULL, 0x0000000438387824ULL, 0x004fcc00078e029bULL,
0x0000000038387984ULL, 0x000e640000000800ULL, 0x0000003804247224ULL, 0x002fc800078e02ddULL,
0x00005e0024247625ULL, 0x000fcc00078e0099ULL, 0x0000001035247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024377faeULL, 0x0003e8000b901c46ULL,
0x01c650009d367984ULL, 0x000ea20000000800ULL, 0x00000010d6377824ULL, 0x002fe400078e02e7ULL,
0x0000000436367824ULL, 0x004fcc00078e029bULL, 0x0000000036367984ULL, 0x000e640000000800ULL,
0x0000003604267224ULL, 0x002fc800078e02dbULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001035267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026397faeULL, 0x0003e8000b901c46ULL, 0x01c660009d387984ULL, 0x000ea20000000800ULL,
0x000000e7d4397211ULL, 0x002fe200078e20ffULL, 0x0000000438387824ULL, 0x004fcc00078e029bULL,
0x0000000038387984ULL, 0x000e640000000800ULL, 0x0000003804247224ULL, 0x002fc800078e02d9ULL,
0x00005e0024247625ULL, 0x000fcc00078e0099ULL, 0x0000001035247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024377faeULL, 0x0003e8000b901c46ULL,
0x01c670009d367984ULL, 0x000ea20000000800ULL, 0x00000010d2377824ULL, 0x002fe400078e02e7ULL,
0x0000000436367824ULL, 0x004fcc00078e029bULL, 0x0000000036367984ULL, 0x000e640000000800ULL,
0x0000003604267224ULL, 0x002fc800078e02d7ULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001035267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026397faeULL, 0x0003e8000b901c46ULL, 0x01c680009d387984ULL, 0x000ea20000000800ULL,
0x000000e7d0397211ULL, 0x002fe200078e20ffULL, 0x0000000438387824ULL, 0x004fcc00078e029bULL,
0x0000000038387984ULL, 0x000e640000000800ULL, 0x0000003804247224ULL, 0x002fc800078e02d5ULL,
0x00005e0024247625ULL, 0x000fcc00078e0099ULL, 0x0000001035247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024377faeULL, 0x0003e8000b901c46ULL,
0x01c690009d367984ULL, 0x000ea20000000800ULL, 0x00000010ce377824ULL, 0x002fe400078e02e7ULL,
0x0000000436367824ULL, 0x004fcc00078e029bULL, 0x0000000036367984ULL, 0x000e640000000800ULL,
0x0000003604267224ULL, 0x002fc800078e02d3ULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001035267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026397faeULL, 0x0003e8000b901c46ULL, 0x01c6a0009d387984ULL, 0x000ea20000000800ULL,
0x000000e7cc397211ULL, 0x002fe200078e20ffULL, 0x0000000438387824ULL, 0x004fcc00078e029bULL,
0x0000000038387984ULL, 0x000e640000000800ULL, 0x0000003804247224ULL, 0x002fc800078e02d1ULL,
0x00005e0024247625ULL, 0x000fcc00078e0099ULL, 0x0000001035247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024377faeULL, 0x0003e8000b901c46ULL,
0x01c6b0009d367984ULL, 0x000ea20000000800ULL, 0x00000010ca377824ULL, 0x002fe400078e02e7ULL,
0x0000000436367824ULL, 0x004fcc00078e029bULL, 0x0000000036367984ULL, 0x000e640000000800ULL,
0x0000003604267224ULL, 0x002fc800078e02cfULL, 0x00005e0026267625ULL, 0x000fcc00078e0099ULL,
0x0000001035267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026397faeULL, 0x0003e8000b901c46ULL, 0x01c6c0009d387984ULL, 0x000ea20000000800ULL,
0x000000e7c8397211ULL, 0x002fe200078e20ffULL, 0x0000000438387824ULL, 0x004fcc00078e029bULL,
0x0000000038387984ULL, 0x000e640000000800ULL, 0x0000003804247224ULL, 0x002fc800078e02cdULL,
0x00005e0024247625ULL, 0x000fcc00078e0099ULL, 0x0000001035247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024377faeULL, 0x0003e8000b901c46ULL,
0x01c6d0009d367984ULL, 0x000ea40000000800ULL, 0x0000000436367824ULL, 0x004fcc00078e029bULL,
0x0000000036367984ULL, 0x000ea40000000800ULL, 0x0000003604267224ULL, 0x004fc800078e02cbULL,
0x00005e0026267625ULL, 0x000fcc00078e0099ULL, 0x0000001035267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026397faeULL, 0x0005e8000b901c46ULL,
0x01c6e0009d387984ULL, 0x000ee40000000800ULL, 0x0000000438387824ULL, 0x008fcc00078e029bULL,
0x0000000038387984ULL, 0x000e640000000800ULL, 0x0000003804247224ULL, 0x002fc800078e02c9ULL,
0x00005e0024247625ULL, 0x000fcc00078e0099ULL, 0x0000001035247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024c77faeULL, 0x0003e8000b901c46ULL,
0x01c6f0009d367984ULL, 0x000ee40000000800ULL, 0x0000000436367824ULL, 0x008fcc00078e029bULL,
0x0000000036367984ULL, 0x000ea40000000800ULL, 0x0000003604267224ULL, 0x004fc800078e02c5ULL,
0x00005e0026267625ULL, 0x000fcc00078e0099ULL, 0x0000001035267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026c37faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000134247810ULL, 0x002fe20007ffe0ffULL,
0x0000002078367824ULL, 0x000fe200078e00ffULL, 0x000000bd6e00720cULL, 0x000fe20003f04070ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000002ff257819ULL, 0x000fe20000011624ULL,
0x000002a000007945ULL, 0x000fe20003800000ULL, 0x0000000324247812ULL, 0x000fe400078ec0ffULL,
0x0000000125267807ULL, 0x000fe40004000000ULL, 0x000000ff24247207ULL, 0x000fe40004000000ULL,
0x000000bd6e00720cULL, 0x000fe20003f24070ULL, 0x0000030026257a24ULL, 0x000fe200078e02bdULL,
0x000000033400780cULL, 0x000fe20003f85270ULL, 0x0000000403bd7824ULL, 0x000fe200078e00ffULL,
0x0000001079277810ULL, 0x000fe20007ffe0ffULL, 0x0000010025267824ULL, 0x000fe200078e0288ULL,
0x0000002003357810ULL, 0x000fe20007ffe0ffULL, 0x0000000173257824ULL, 0x000fe200078e0224ULL,
0xffffffe036277812ULL, 0x000fe200078ee227ULL, 0x0000000186517824ULL, 0x000fe200078e02bdULL,
0x0000000326347210ULL, 0x000fe20007ffe0ffULL, 0x0000680025247a24ULL, 0x000fc400078e0226ULL,
0x00000004ff257424ULL, 0x000fe200078e00ffULL, 0x000000713400720cULL, 0x000fe20003f06070ULL,
0x0000000135347824ULL, 0x040fe200078e0226ULL, 0x0000000324487210ULL, 0x000fe20007ffe0ffULL,
0x0000000135267824ULL, 0x000fe400078e0224ULL, 0x0000001027387824ULL, 0x000fe200078e00ffULL,
0x000000713400720cULL, 0x000fe20003f66070ULL, 0x0000660048487625ULL, 0x000fc800078e0025ULL,
0x0000660026267625ULL, 0x000fe200078e0025ULL, 0x0000010000009947ULL, 0x000fea0002000000ULL,
0x000000030300780cULL, 0x000fe40003f24070ULL, 0x0000030000247a02ULL, 0x000fca0000000f00ULL,
0x0000000224877824ULL, 0x000fcc00078e0287ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0000000400247824ULL, 0x100fe200078e0203ULL, 0x000000728700720cULL, 0x000fe20003f26070ULL,
0x0000000475347824ULL, 0x000fe200078e0203ULL, 0x0000000400257802ULL, 0x000fe20000000f00ULL,
0x0000000224247824ULL, 0x000fc600078e00ffULL, 0x0001ca8034357811ULL, 0x000fe200078e10ffULL,
0x0000640024247a24ULL, 0x000fc800078e0287ULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024357faeULL, 0x0003e4000c921846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x1c60000048517faeULL, 0x0005e2000c121846ULL, 0x0000002078257824ULL, 0x002fe200078e00ffULL,
0x0000001279247810ULL, 0x000fe20007ffe0ffULL, 0x00001e4000007945ULL, 0x000fe20003800000ULL,
0x1c68000026517faeULL, 0x0003e4000d921846ULL, 0xffffffe025247812ULL, 0x000fe400078ee224ULL,
0x00000000c258783bULL, 0x000fe60000000200ULL, 0x0000001024507824ULL, 0x000fe200078e00ffULL,
0x000000003838783bULL, 0x000ee80000000200ULL, 0x00000000c034783bULL, 0x000f280000000200ULL,
0x00000000c14c783bULL, 0x000f280000000200ULL, 0x00000000be48783bULL, 0x004fe80000000200ULL,
0x000000005050783bULL, 0x002e680000000200ULL, 0x00000000bf44783bULL, 0x000ea80000000200ULL,
0x00000000bb24783bULL, 0x000e680000000200ULL, 0x000000009768783bULL, 0x000fe80000000200ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000058382c723cULL, 0x048f70000004182cULL,
0x0000005a3828723cULL, 0x040b640000041828ULL, 0x00000000bc58783bULL, 0x020fec0000000200ULL,
0x000000343840723cULL, 0x050ff00000041840ULL, 0x000000363854723cULL, 0x040be40000041854ULL,
0x000000008c34783bULL, 0x02072c0000000200ULL, 0x0000004c383c723cULL, 0x000f62000004183cULL,
0x000000016f8c7810ULL, 0x008fce0007ffe0ffULL, 0x0000004e3830723cULL, 0x000b640000041830ULL,
0x00000000814c783bULL, 0x020fec0000000200ULL, 0x00000048502c723cULL, 0x042ff0000004182cULL,
0x0000004a5048723cULL, 0x000bee0000041828ULL, 0x0000001479287810ULL, 0x020fe20007ffe0ffULL,
0x00000044385c723cULL, 0x004f62000004185cULL, 0x0000000578297819ULL, 0x000fc800000006ffULL,
0xffffffe029287812ULL, 0x000fc600078ee228ULL, 0x000000463860723cULL, 0x000b640000041860ULL,
0x0000001028287824ULL, 0x000fe200078e00ffULL, 0x000000009644783bULL, 0x020fe80000000200ULL,
0x000000007f38783bULL, 0x000fe20000000200ULL, 0x00000024503c723cULL, 0x040f66000004183cULL,
0x000000002828783bULL, 0x000e6a0000000200ULL, 0x000000265024723cULL, 0x040b640000041830ULL,
0x000000009230783bULL, 0x020eac0000000200ULL, 0x000000345040723cULL, 0x050b6e0000041840ULL,
0x0000002078357824ULL, 0x020fe200078e00ffULL, 0x0000001679347810ULL, 0x000fe20007ffe0ffULL,
0x000000365054723cULL, 0x000b660000041854ULL, 0xffffffe035347812ULL, 0x000fca00078ee234ULL,
0x0000001034647824ULL, 0x000fe200078e00ffULL, 0x00000068505c723cULL, 0x040f64000004185cULL,
0x000000008034783bULL, 0x020fe80000000200ULL, 0x000000006464783bULL, 0x000fe40000000200ULL,
0x0000006a5050723cULL, 0x000be40000041860ULL, 0x000000007d68783bULL, 0x020eec0000000200ULL,
0x00000044283c723cULL, 0x042ff0000004183cULL, 0x000000462844723cULL, 0x000be40000041824ULL,
0x000000007b24783bULL, 0x020e620000000200ULL, 0x000080000000791aULL, 0x000fca0000000000ULL,
0x000000302840723cULL, 0x044f700000041840ULL, 0x000000322830723cULL, 0x040f700000041854ULL,
0x0000004c285c723cULL, 0x000f70000004185cULL, 0x000000686440723cULL, 0x068ff00000041840ULL,
0x0000006a6468723cULL, 0x000bee0000041830ULL, 0x00000002ff317819ULL, 0x020fe2000001168cULL,
0x00000058282c723cULL, 0x000f66000004182cULL, 0x000000318c307207ULL, 0x000fca0001000000ULL,
0x0000005a2848723cULL, 0x040f700000041848ULL, 0x0000004e2828723cULL, 0x000f700000041850ULL,
0x00000024645c723cULL, 0x042b6e000004185cULL, 0x0000030030257a24ULL, 0x020fe200078e0277ULL,
0x00000038642c723cULL, 0x000f68000004182cULL, 0x0000008825307211ULL, 0x000fc400078e40ffULL,
0x0000000125257810ULL, 0x000fe40007ffe0ffULL, 0x00000034643c723cULL, 0x000f64000004183cULL,
0x000000702500720cULL, 0x000fcc0003f06070ULL, 0x0000003a6438723cULL, 0x040f700000041848ULL,
0x000000366434723cULL, 0x040f700000041844ULL, 0x000000266464723cULL, 0x000b6e0000041828ULL,
0x0000004030277812ULL, 0x020fca00078ec0ffULL, 0x0000000102277824ULL, 0x000fe200078e0227ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000d5000008947ULL, 0x000fea0003800000ULL,
0x01c600009d247984ULL, 0x000e620000000800ULL, 0x0000003071297217ULL, 0x000fe40007800000ULL,
0x00000004032b7819ULL, 0x000fe400000006ffULL, 0x00000027b4287210ULL, 0x000fe20007ffe0ffULL,
0x0000000129297824ULL, 0x000fe200078e0a30ULL, 0x000000702b2b7812ULL, 0x000fc800078ec0ffULL,
0x000000297a00720cULL, 0x000fe20003f06070ULL, 0x0000000424267824ULL, 0x002fe400078e029bULL,
0x000000017a247824ULL, 0x000fc600078e0227ULL, 0x0000000026257984ULL, 0x000e640000000800ULL,
0x0000002504247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e0099ULL,
0x000000242b247210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024ba7faeULL, 0x0003e2000c101c46ULL,
0x00000029b400720cULL, 0x000fc60003f06070ULL, 0x01c610009d267984ULL, 0x000ea40000000800ULL,
0x0000000426267824ULL, 0x004fca00078e029bULL, 0x0000000026317984ULL, 0x000ea40000000800ULL,
0x0000003104287224ULL, 0x004fc800078e0228ULL, 0x00005e0028307625ULL, 0x000fca00078e0099ULL,
0x000000302b307210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff317224ULL, 0x000fca00008e0631ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030b97faeULL, 0x0005e2000c101c46ULL,
0x00000029b200720cULL, 0x000fc60003f06070ULL, 0x01c620009d247984ULL, 0x002e640000000800ULL,
0x0000000424287824ULL, 0x002fe400078e029bULL, 0x00000001b2247824ULL, 0x000fc600078e0227ULL,
0x0000000028257984ULL, 0x000e640000000800ULL, 0x0000002504247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e0099ULL, 0x000000242b327210ULL, 0x000fc80007f3e0ffULL,
0x00000025ff337210ULL, 0x000fca0000ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032b87faeULL, 0x0003e2000c101c46ULL, 0x00000029b000720cULL, 0x000fc60003f06070ULL,
0x01c630009d247984ULL, 0x000ee40000000800ULL, 0x0000000424267824ULL, 0x008fe400078e029bULL,
0x00000001b0247824ULL, 0x000fc600078e0227ULL, 0x0000000026257984ULL, 0x000ee40000000800ULL,
0x0000002504247224ULL, 0x008fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e0099ULL,
0x000000242b307210ULL, 0x004fca0007f3e0ffULL, 0x000000ffff317224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030b77faeULL, 0x0005e2000c101c46ULL,
0x00000029ae00720cULL, 0x000fc60003f06070ULL, 0x01c640009d247984ULL, 0x000ee40000000800ULL,
0x0000009b24287211ULL, 0x008fe200078e10ffULL, 0x00000001ae247824ULL, 0x000fc800078e0227ULL,
0x0000000028257984ULL, 0x000ee40000000800ULL, 0x0000002504247224ULL, 0x008fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e0099ULL, 0x000000242b327210ULL, 0x002fca0007f3e0ffULL,
0x000000ffff337224ULL, 0x000fca00008e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032b67faeULL, 0x0003e2000c101c46ULL, 0x00000029ac00720cULL, 0x000fc60003f06070ULL,
0x01c650009d247984ULL, 0x000ee40000000800ULL, 0x0000000424267824ULL, 0x008fe200078e029bULL,
0x00000027ac247210ULL, 0x000fc80007ffe0ffULL, 0x0000000026257984ULL, 0x000ee40000000800ULL,
0x0000002504247224ULL, 0x008fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e0099ULL,
0x000000242b307210ULL, 0x004fca0007f3e0ffULL, 0x000000ffff317224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030b57faeULL, 0x0005e2000c101c46ULL,
0x00000029aa00720cULL, 0x000fc60003f06070ULL, 0x01c660009d247984ULL, 0x000ee40000000800ULL,
0x0000000424287824ULL, 0x008fe400078e029bULL, 0x00000001aa247824ULL, 0x000fc600078e0227ULL,
0x0000000028257984ULL, 0x000ee40000000800ULL, 0x0000002504247224ULL, 0x008fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e0099ULL, 0x000000242b327210ULL, 0x002fc80007f3e0ffULL,
0x00000025ff337210ULL, 0x000fca0000ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032b37faeULL, 0x0003e2000c101c46ULL, 0x00000029a800720cULL, 0x000fc60003f06070ULL,
0x01c670009d247984ULL, 0x000ee40000000800ULL, 0x0000000424267824ULL, 0x008fe400078e029bULL,
0x00000001a8247824ULL, 0x000fc600078e0227ULL, 0x0000000026257984ULL, 0x000ee40000000800ULL,
0x0000002504247224ULL, 0x008fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e0099ULL,
0x000000242b307210ULL, 0x004fca0007f3e0ffULL, 0x000000ffff317224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030b17faeULL, 0x0005e2000c101c46ULL,
0x00000029a600720cULL, 0x000fc60003f06070ULL, 0x01c680009d247984ULL, 0x000ee40000000800ULL,
0x0000009b24287211ULL, 0x008fe200078e10ffULL, 0x00000001a6247824ULL, 0x000fc800078e0227ULL,
0x0000000028257984ULL, 0x000ee40000000800ULL, 0x0000002504247224ULL, 0x008fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e0099ULL, 0x000000242b327210ULL, 0x002fca0007f3e0ffULL,
0x000000ffff337224ULL, 0x000fca00008e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032af7faeULL, 0x0003e2000c101c46ULL, 0x00000029a400720cULL, 0x000fc60003f06070ULL,
0x01c690009d247984ULL, 0x000ee40000000800ULL, 0x0000000424267824ULL, 0x008fe200078e029bULL,
0x00000027a4247210ULL, 0x000fc80007ffe0ffULL, 0x0000000026257984ULL, 0x000ee40000000800ULL,
0x0000002504247224ULL, 0x008fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e0099ULL,
0x000000242b307210ULL, 0x004fca0007f3e0ffULL, 0x000000ffff317224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030ad7faeULL, 0x0005e2000c101c46ULL,
0x00000029a200720cULL, 0x000fc60003f06070ULL, 0x01c6a0009d247984ULL, 0x000ee40000000800ULL,
0x0000000424287824ULL, 0x008fe400078e029bULL, 0x00000001a2247824ULL, 0x000fc600078e0227ULL,
0x0000000028257984ULL, 0x000ee40000000800ULL, 0x0000002504247224ULL, 0x008fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e0099ULL, 0x000000242b327210ULL, 0x002fc80007f3e0ffULL,
0x00000025ff337210ULL, 0x000fca0000ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032ab7faeULL, 0x0003e2000c101c46ULL, 0x00000029a000720cULL, 0x000fc60003f06070ULL,
0x01c6b0009d247984ULL, 0x000ee40000000800ULL, 0x0000000424267824ULL, 0x008fe400078e029bULL,
0x00000001a0247824ULL, 0x000fc600078e0227ULL, 0x0000000026257984ULL, 0x000ee40000000800ULL,
0x0000002504247224ULL, 0x008fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e0099ULL,
0x000000242b307210ULL, 0x004fca0007f3e0ffULL, 0x000000ffff317224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030a97faeULL, 0x0005e2000c101c46ULL,
0x000000299e00720cULL, 0x000fc60003f06070ULL, 0x01c6c0009d247984ULL, 0x000ee40000000800ULL,
0x0000009b24287211ULL, 0x008fe200078e10ffULL, 0x000000019e247824ULL, 0x000fc800078e0227ULL,
0x0000000028257984ULL, 0x000ee40000000800ULL, 0x0000002504247224ULL, 0x008fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e0099ULL, 0x000000242b327210ULL, 0x002fca0007f3e0ffULL,
0x000000ffff337224ULL, 0x000fca00008e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032a77faeULL, 0x0003e2000c101c46ULL, 0x000000299c00720cULL, 0x000fc60003f06070ULL,
0x01c6d0009d247984ULL, 0x000ee40000000800ULL, 0x0000000424267824ULL, 0x008fe200078e029bULL,
0x000000279c247210ULL, 0x000fc80007ffe0ffULL, 0x0000000026257984ULL, 0x000ee40000000800ULL,
0x0000002504247224ULL, 0x008fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e0099ULL,
0x000000242b307210ULL, 0x004fca0007f3e0ffULL, 0x000000ffff317224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030a57faeULL, 0x0005e2000c101c46ULL,
0x000000299a00720cULL, 0x000fc60003f06070ULL, 0x01c6e0009d247984ULL, 0x000ee40000000800ULL,
0x0000000424287824ULL, 0x008fe400078e029bULL, 0x000000019a247824ULL, 0x100fe400078e0227ULL,
0x0000000198277824ULL, 0x000fe200078e0227ULL, 0x0000000028257984ULL, 0x000ee40000000800ULL,
0x0000002504247224ULL, 0x008fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e0099ULL,
0x000000242b327210ULL, 0x002fc80007f3e0ffULL, 0x00000025ff337210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000032a37faeULL, 0x0005e2000c101c46ULL,
0x000000299800720cULL, 0x000fc60003f06070ULL, 0x01c6f0009d247984ULL, 0x000e640000000800ULL,
0x00000004249b7824ULL, 0x002fcc00078e029bULL, 0x000000009b9b7984ULL, 0x000e640000000800ULL,
0x0000009b04247224ULL, 0x002fc800078e0227ULL, 0x00005e0024247625ULL, 0x000fca00078e0099ULL,
0x000000242b247210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024a17faeULL, 0x0005e2000c101c46ULL,
0x00000c2000007947ULL, 0x000fea0003800000ULL, 0x01c600009d247984ULL, 0x000e620000000800ULL,
0x000000017a287824ULL, 0x000fe200078e0227ULL, 0x0000009b24257211ULL, 0x002fe200078e10ffULL,
0x0000001003247824ULL, 0x000fca00078e00ffULL, 0x0000000025257984ULL, 0x000e620000000800ULL,
0x0000007024247812ULL, 0x000fe200078ec0ffULL, 0x0000002504287224ULL, 0x002fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fca00078e0099ULL, 0x00000028242a7210ULL, 0x000fe20007f1e0ffULL,
0x00000001b4287824ULL, 0x000fc800078e0227ULL, 0x000000ffff2b7224ULL, 0x000fca00000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aba7faeULL, 0x0003e8000b901c46ULL,
0x01c610009d267984ULL, 0x000ea40000000800ULL, 0x0000009b26267211ULL, 0x004fca00078e10ffULL,
0x0000000026257984ULL, 0x000ea40000000800ULL, 0x0000002504287224ULL, 0x004fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fca00078e0099ULL, 0x0000002824307210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff317224ULL, 0x000fca00000e0629ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030b97faeULL, 0x0005e8000b901c46ULL, 0x01c620009d287984ULL, 0x000ee40000000800ULL,
0x0000000428257824ULL, 0x008fe200078e029bULL, 0x00000027b2287210ULL, 0x000fca0007ffe0ffULL,
0x0000000025257984ULL, 0x000ee40000000800ULL, 0x0000002504287224ULL, 0x008fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fca00078e0099ULL, 0x00000028242a7210ULL, 0x002fe20007f1e0ffULL,
0x00000001b0287824ULL, 0x000fc800078e0227ULL, 0x000000ffff2b7224ULL, 0x000fca00000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab87faeULL, 0x0003e8000b901c46ULL,
0x01c630009d267984ULL, 0x000ee40000000800ULL, 0x0000000426267824ULL, 0x008fca00078e029bULL,
0x0000000026297984ULL, 0x000ee40000000800ULL, 0x0000002904287224ULL, 0x008fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fca00078e0099ULL, 0x0000002824307210ULL, 0x004fc80007f1e0ffULL,
0x00000029ff317210ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030b77faeULL, 0x0005e8000b901c46ULL, 0x01c640009d287984ULL, 0x000ee40000000800ULL,
0x0000000428257824ULL, 0x008fe400078e029bULL, 0x00000001ae287824ULL, 0x000fc800078e0227ULL,
0x0000000025257984ULL, 0x000ee40000000800ULL, 0x0000002504287224ULL, 0x008fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fca00078e0099ULL, 0x00000028242a7210ULL, 0x002fe20007f1e0ffULL,
0x00000001ac287824ULL, 0x000fc800078e0227ULL, 0x000000ffff2b7224ULL, 0x000fca00000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab67faeULL, 0x0003e8000b901c46ULL,
0x01c650009d267984ULL, 0x000ee40000000800ULL, 0x0000009b26267211ULL, 0x008fca00078e10ffULL,
0x0000000026297984ULL, 0x000ee40000000800ULL, 0x0000002904287224ULL, 0x008fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fca00078e0099ULL, 0x0000002824307210ULL, 0x004fca0007f1e0ffULL,
0x000000ffff317224ULL, 0x000fca00000e0629ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030b57faeULL, 0x0005e8000b901c46ULL, 0x01c660009d287984ULL, 0x000ee40000000800ULL,
0x0000000428257824ULL, 0x008fe200078e029bULL, 0x00000027aa287210ULL, 0x000fca0007ffe0ffULL,
0x0000000025257984ULL, 0x000ee40000000800ULL, 0x0000002504287224ULL, 0x008fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fca00078e0099ULL, 0x00000028242a7210ULL, 0x002fe20007f1e0ffULL,
0x00000001a8287824ULL, 0x000fc800078e0227ULL, 0x000000ffff2b7224ULL, 0x000fca00000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab37faeULL, 0x0003e8000b901c46ULL,
0x01c670009d267984ULL, 0x000ee40000000800ULL, 0x0000000426267824ULL, 0x008fca00078e029bULL,
0x0000000026297984ULL, 0x000ee40000000800ULL, 0x0000002904287224ULL, 0x008fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fca00078e0099ULL, 0x0000002824307210ULL, 0x004fc80007f1e0ffULL,
0x00000029ff317210ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030b17faeULL, 0x0005e8000b901c46ULL, 0x01c680009d287984ULL, 0x000ee40000000800ULL,
0x0000000428257824ULL, 0x008fe400078e029bULL, 0x00000001a6287824ULL, 0x000fc800078e0227ULL,
0x0000000025257984ULL, 0x000ee40000000800ULL, 0x0000002504287224ULL, 0x008fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fca00078e0099ULL, 0x00000028242a7210ULL, 0x002fe20007f1e0ffULL,
0x00000001a4287824ULL, 0x000fc800078e0227ULL, 0x000000ffff2b7224ULL, 0x000fca00000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aaf7faeULL, 0x0003e8000b901c46ULL,
0x01c690009d267984ULL, 0x000ee40000000800ULL, 0x0000009b26267211ULL, 0x008fca00078e10ffULL,
0x0000000026297984ULL, 0x000ee40000000800ULL, 0x0000002904287224ULL, 0x008fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fca00078e0099ULL, 0x0000002824307210ULL, 0x004fca0007f1e0ffULL,
0x000000ffff317224ULL, 0x000fca00000e0629ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030ad7faeULL, 0x0005e8000b901c46ULL, 0x01c6a0009d287984ULL, 0x000ee40000000800ULL,
0x0000000428257824ULL, 0x008fe200078e029bULL, 0x00000027a2287210ULL, 0x000fca0007ffe0ffULL,
0x0000000025257984ULL, 0x000ee40000000800ULL, 0x0000002504287224ULL, 0x008fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fca00078e0099ULL, 0x00000028242a7210ULL, 0x002fe20007f1e0ffULL,
0x00000001a0287824ULL, 0x000fc800078e0227ULL, 0x000000ffff2b7224ULL, 0x000fca00000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aab7faeULL, 0x0003e8000b901c46ULL,
0x01c6b0009d267984ULL, 0x000ee40000000800ULL, 0x0000000426267824ULL, 0x008fca00078e029bULL,
0x0000000026297984ULL, 0x000ee40000000800ULL, 0x0000002904287224ULL, 0x008fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fca00078e0099ULL, 0x0000002824307210ULL, 0x004fc80007f1e0ffULL,
0x00000029ff317210ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030a97faeULL, 0x0005e8000b901c46ULL, 0x01c6c0009d287984ULL, 0x000ee40000000800ULL,
0x0000000428257824ULL, 0x008fe400078e029bULL, 0x000000019e287824ULL, 0x000fc800078e0227ULL,
0x0000000025257984ULL, 0x000ee40000000800ULL, 0x0000002504287224ULL, 0x008fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fca00078e0099ULL, 0x00000028242a7210ULL, 0x002fe20007f1e0ffULL,
0x000000019c287824ULL, 0x000fc800078e0227ULL, 0x000000ffff2b7224ULL, 0x000fca00000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aa77faeULL, 0x0003e8000b901c46ULL,
0x01c6d0009d267984ULL, 0x000ee40000000800ULL, 0x0000009b26267211ULL, 0x008fca00078e10ffULL,
0x0000000026297984ULL, 0x000ee40000000800ULL, 0x0000002904287224ULL, 0x008fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fca00078e0099ULL, 0x0000002824307210ULL, 0x004fca0007f1e0ffULL,
0x000000ffff317224ULL, 0x000fca00000e0629ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030a57faeULL, 0x0003e8000b901c46ULL, 0x01c6e0009d287984ULL, 0x000ea40000000800ULL,
0x0000000428257824ULL, 0x004fe200078e029bULL, 0x000000279a287210ULL, 0x000fca0007ffe0ffULL,
0x0000000025257984ULL, 0x000ea40000000800ULL, 0x0000002504287224ULL, 0x004fc800078e0228ULL,
0x00005e0028287625ULL, 0x000fca00078e0099ULL, 0x0000002824287210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028a37faeULL, 0x0003e8000b901c46ULL, 0x01c6f0009d267984ULL, 0x000ea40000000800ULL,
0x00000004269b7824ULL, 0x004fe400078e029bULL, 0x0000000198267824ULL, 0x000fc800078e0227ULL,
0x000000009b9b7984ULL, 0x000ea40000000800ULL, 0x0000009b04267224ULL, 0x004fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e0099ULL, 0x0000002624247210ULL, 0x000fc80007f1e0ffULL,
0x00000027ff257210ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024a17faeULL, 0x0003e8000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002078257824ULL, 0x006fe200078e00ffULL, 0x0000001879247810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe025247812ULL, 0x000fe200078ee224ULL,
0x000000009f54783bULL, 0x000fe80000000200ULL, 0x0000001024447824ULL, 0x000fe200078e00ffULL,
0x0000001a79247810ULL, 0x000fe20007ffe0ffULL, 0x00000000914c783bULL, 0x000fe60000000200ULL,
0xffffffe025247812ULL, 0x000fe200078ee224ULL, 0x000000004444783bULL, 0x000e680000000200ULL,
0x0000001024287824ULL, 0x000fe200078e00ffULL, 0x000000008d48783bULL, 0x000ea80000000200ULL,
0x000000008f24783bULL, 0x000fe80000000200ULL, 0x000000002828783bULL, 0x000ee80000000200ULL,
0x000000009450783bULL, 0x000f280000000200ULL, 0x000000008358783bULL, 0x000ee80000000200ULL,
0x000000007e60783bULL, 0x000f280000000200ULL, 0x000000008e30783bULL, 0x000f280000000200ULL,
0x000000008280783bULL, 0x000fe80000000200ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000564438723cULL, 0x042f700000041838ULL, 0x0000004c4440723cULL, 0x040f700000041840ULL,
0x00000048445c723cULL, 0x004f70000004185cULL, 0x000000262838723cULL, 0x028bee0000041838ULL,
0x0000001c79267810ULL, 0x060fe20007ffe0ffULL, 0x00000054442c723cULL, 0x000be2000004182cULL,
0x0000000578277819ULL, 0x040fe200000006ffULL, 0x000000009054783bULL, 0x020fe20000000200ULL,
0x0000002078787824ULL, 0x000fe200078e00ffULL, 0x0000001e79797810ULL, 0x000fc40007ffe0ffULL,
0xffffffe027267812ULL, 0x000fe400078ee226ULL, 0x00000050443c723cULL, 0x010f62000004183cULL,
0xffffffe078797812ULL, 0x000fe400078ee279ULL, 0x0000001026267824ULL, 0x000fe200078e00ffULL,
0x00000002ff277819ULL, 0x000fc80000011603ULL, 0x000000524434723cULL, 0x000be20000041834ULL,
0x0000006f2700720cULL, 0x040fe20003f06070ULL, 0x000000009350783bULL, 0x020fe60000000200ULL,
0x0000008c2700720cULL, 0x000fc60004706470ULL, 0x0000004e4468723cULL, 0x040b620000041868ULL,
0x000000776e00720cULL, 0x000fe20000703070ULL, 0x00000000954c783bULL, 0x020fec0000000200ULL,
0x0000004a4464723cULL, 0x000b640000041864ULL, 0x000000007c44783bULL, 0x020fe80000000200ULL,
0x000000002648783bULL, 0x000e640000000200ULL, 0x000000582840723cULL, 0x040fe40000041840ULL,
0x00000000897c783bULL, 0x000fec0000000200ULL, 0x00000060285c723cULL, 0x040ff0000004185cULL,
0x00000030283c723cULL, 0x040f70000004183cULL, 0x0000005a2858723cULL, 0x040b6e0000041868ULL,
0x0000001079687824ULL, 0x020fe200078e00ffULL, 0x000000622860723cULL, 0x040b620000041864ULL,
0x000000008b78783bULL, 0x000fe80000000200ULL, 0x000000008a64783bULL, 0x020fe60000000200ULL,
0x000000322834723cULL, 0x040f620000041834ULL, 0x000000006868783bULL, 0x000eae0000000200ULL,
0x00000024282c723cULL, 0x000f70000004182cULL, 0x000000464838723cULL, 0x042f700000041838ULL,
0x0000004c483c723cULL, 0x040f70000004183cULL, 0x000000504840723cULL, 0x040f700000041840ULL,
0x000000524858723cULL, 0x040f700000041858ULL, 0x00000054485c723cULL, 0x040ff0000004185cULL,
0x000000564860723cULL, 0x040ff00000041860ULL, 0x0000004e4834723cULL, 0x060ff00000041834ULL,
0x00000044482c723cULL, 0x000bee000004182cULL, 0x0000000827447810ULL, 0x020fe20007ffe0ffULL,
0x000000666838723cULL, 0x004f660000041838ULL, 0x0000006f4400720cULL, 0x000fc40003f26070ULL,
0x0000008c006f7202ULL, 0x080fe40000000f00ULL, 0x0000008c4400720cULL, 0x000fe20000f21070ULL,
0x00000078683c723cULL, 0x000f66000004183cULL, 0x000000776e00720cULL, 0x000fca0000f24470ULL,
0x0000007c6840723cULL, 0x040f700000041840ULL, 0x0000007e6858723cULL, 0x000f640000041858ULL,
0x0000003900168202ULL, 0x020fe20000000f00ULL, 0x000000ffff178224ULL, 0x000fe200078e0038ULL,
0x000000093b097208ULL, 0x000fc40000800000ULL, 0x000000083a087208ULL, 0x000fe40000800000ULL,
0x00000080685c723cULL, 0x000f62000004185cULL, 0x000000ffff148224ULL, 0x000fe200078e003dULL,
0x0000006c3f6c7208ULL, 0x000fe20000800000ULL, 0x000000ffff158224ULL, 0x000fe200078e003cULL,
0x0000006d3e6d7208ULL, 0x000fc80000800000ULL, 0x000000826860723cULL, 0x000f620000041860ULL,
0x000000ffff108224ULL, 0x000fe200078e0041ULL, 0x0000002043207208ULL, 0x000fe20000800000ULL,
0x000000ffff118224ULL, 0x000fe200078e0040ULL, 0x0000002142217208ULL, 0x000fc80000800000ULL,
0x0000007a6834723cULL, 0x000f620000041834ULL, 0x00000059000e8202ULL, 0x000fe20000000f00ULL,
0x000000ffff0f8224ULL, 0x000fe200078e0058ULL, 0x0000001e5b1e7208ULL, 0x000fe40000800000ULL,
0x0000001f5a1f7208ULL, 0x000fc60000800000ULL, 0x00000064682c723cULL, 0x000f64000004182cULL,
0x000000ffff0c8224ULL, 0x020fe200078e005dULL, 0x0000001c5f1c7208ULL, 0x000fe20000800000ULL,
0x000000ffff0d8224ULL, 0x000fe200078e005cULL, 0x0000001d5e1d7208ULL, 0x000fc60000800000ULL,
0x0000006100748202ULL, 0x000fe20000000f00ULL, 0x000000ffff0b8224ULL, 0x000fe200078e0060ULL,
0x0000001a631a7208ULL, 0x000fe40000800000ULL, 0x0000001b621b7208ULL, 0x000fc80000800000ULL,
0x0000003500128202ULL, 0x000fe20000000f00ULL, 0x000000ffff138224ULL, 0x000fe200078e0034ULL,
0x0000002237227208ULL, 0x000fe40000800000ULL, 0x0000002336237208ULL, 0x000fc80000800000ULL,
0x000000ffff188224ULL, 0x000fe200078e002dULL, 0x000000072f077208ULL, 0x000fe20000800000ULL,
0x000000ffff198224ULL, 0x000fe200078e002cULL, 0x000000058c00720cULL, 0x000fe40003f06070ULL,
0x0000000a2e0a7208ULL, 0x000fd60000800000ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff6b8000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000085247f8cULL, 0x000e62000c80043fULL, 0x3d80000017177820ULL, 0x000fe40000410000ULL,
0x3d80000013137820ULL, 0x000fe40000410000ULL, 0x3d8000000f267820ULL, 0x000fe40000410000ULL,
0x3d8000000e287820ULL, 0x000fe20000410000ULL, 0x00000017000e7202ULL, 0x000fe20000000f00ULL,
0x3d8000000d297820ULL, 0x000fe40000410000ULL, 0x3d8000000c2a7820ULL, 0x000fc40000410000ULL,
0x3d8000000b0b7820ULL, 0x000fe40000410000ULL, 0x3d80000008087820ULL, 0x000fe40000410000ULL,
0x3d80000019197820ULL, 0x000fe40000410000ULL, 0x3d80000018187820ULL, 0x000fe40000410000ULL,
0x3d80000016167820ULL, 0x000fe40000410000ULL, 0x3d80000015157820ULL, 0x000fc40000410000ULL,
0x000000ffff307224ULL, 0x002fe400078e0025ULL, 0x3d80000014147820ULL, 0x000fe40000410000ULL,
0x3d80000012057820ULL, 0x000fe20000410000ULL, 0x0000001300127202ULL, 0x000fe20000000f00ULL,
0x3d80000011247820ULL, 0x000fe40000410000ULL, 0x3d80000010257820ULL, 0x000fe40000410000ULL,
0x3d80000074747820ULL, 0x000fc40000410000ULL, 0x3d8000000a0a7820ULL, 0x000fe40000410000ULL,
0x3d80000007077820ULL, 0x000fe40000410000ULL, 0x3d80000009097820ULL, 0x000fe40000410000ULL,
0x3d80000020347820ULL, 0x000fe40000410000ULL, 0x3d8000001f357820ULL, 0x000fe40000410000ULL,
0x3d8000001e367820ULL, 0x000fc40000410000ULL, 0x3d800000232d7820ULL, 0x000fe40000410000ULL,
0x3d800000222e7820ULL, 0x000fe40000410000ULL, 0x3d800000212f7820ULL, 0x000fe20000410000ULL,
0x0000000b00217202ULL, 0x000fe20000000f00ULL, 0x3d8000001d377820ULL, 0x000fe20000410000ULL,
0x00000026001d7202ULL, 0x000fe20000000f00ULL, 0x3d8000001c387820ULL, 0x000fe40000410000ULL,
0x3d8000001b397820ULL, 0x000fc40000410000ULL, 0x3d8000001a3a7820ULL, 0x000fe40000410000ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0028ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0029ULL,
0x0000000800297202ULL, 0x000fe20000000f00ULL, 0x000000ffff207224ULL, 0x000fe400078e002aULL,
0x3d8000006d2b7820ULL, 0x000fe40000410000ULL, 0x3d8000006c2c7820ULL, 0x000fc40000410000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0019ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0018ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0016ULL, 0x000000ffff107224ULL, 0x000fe400078e0015ULL,
0x000000ffff117224ULL, 0x000fe400078e0014ULL, 0x000000ffff1a7224ULL, 0x000fc400078e0005ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0024ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0025ULL,
0x000000ffff227224ULL, 0x000fe400078e0074ULL, 0x000000ffff287224ULL, 0x000fe400078e000aULL,
0x000000ffff237224ULL, 0x000fe400078e0007ULL, 0x000000ffff2a7224ULL, 0x000fc400078e0009ULL,
0x0000000000087805ULL, 0x000fca0000015200ULL, 0x0000040085057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804830ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140bULL, 0x0000000a05057211ULL, 0x000fc800078110ffULL,
0x0000000bff0a7210ULL, 0x000fc800007fe4ffULL, 0x0000000205057819ULL, 0x000fc8000000120aULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000107077810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040085057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804830ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff0bd087812ULL, 0x000fe400078ec0ffULL,
0x000000847700720cULL, 0x000fc60003f05270ULL, 0x0000008075057824ULL, 0x000fca00078e0208ULL,
0x01c4000005087984ULL, 0x0002aa0000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000203077824ULL, 0x000fe400078e00ffULL, 0x0000000171067824ULL, 0x000fc600078e0a06ULL,
0x0000000607077812ULL, 0x000fc800078ec0ffULL, 0x0000000107137812ULL, 0x040fe400078efcffULL,
0x0000000807157812ULL, 0x000fe400078efcffULL, 0x000000061300720cULL, 0x080fe40003f26070ULL,
0x0000001007137812ULL, 0x000fe400078efcffULL, 0x000000061500720cULL, 0x080fe40003f06070ULL,
0x000000061300720cULL, 0x000fc40003fc6070ULL, 0x0000001107157812ULL, 0x040fe400078efcffULL,
0x0000001807137812ULL, 0x040fe400078efcffULL, 0x000000060700720cULL, 0x080fe40003f46070ULL,
0x000000061500720cULL, 0x080fe40003fa6070ULL, 0x000000061300720cULL, 0x000fe40003f66070ULL,
0x0000000907177812ULL, 0x000fc400078efcffULL, 0x0000001907157812ULL, 0x040fe400078efcffULL,
0x0000002007137812ULL, 0x000fe400078efcffULL, 0xff80000028287808ULL, 0x000fe40005000000ULL,
0xff8000000d0d7808ULL, 0x000fe40005000000ULL, 0xff80000023237808ULL, 0x000fe40004800000ULL,
0xff8000000c0c7808ULL, 0x000fc40004800000ULL, 0x000000061700720cULL, 0x080fe40003f86070ULL,
0x000000061500720cULL, 0x080fe40003f46070ULL, 0x000000061300720cULL, 0x000fe40003f26070ULL,
0x0000002107157812ULL, 0x040fe400078efcffULL, 0x0000002807137812ULL, 0x000fe400078efcffULL,
0xff80000029297808ULL, 0x000fc40004000000ULL, 0xff8000000e0e7808ULL, 0x000fe40004000000ULL,
0xff8000002a2a7808ULL, 0x000fe40006000000ULL, 0xff8000000f0f7808ULL, 0x000fe40006000000ULL,
0x000000061500720cULL, 0x080fe40003f06070ULL, 0x000000061300720cULL, 0x000fe40003f86070ULL,
0x0000002907157812ULL, 0x000fc400078efcffULL, 0x0000003007137812ULL, 0x000fe400078efcffULL,
0xff8000002b2b7808ULL, 0x000fe40007000000ULL, 0xff80000010107808ULL, 0x000fe40007000000ULL,
0xff8000002c2c7808ULL, 0x000fe40006800000ULL, 0xff80000011117808ULL, 0x000fe40006800000ULL,
0x000000061500720cULL, 0x000fc40003fc6070ULL, 0x000000061300720cULL, 0x000fe40003fa6070ULL,
0x0000003107157812ULL, 0x040fe400078efcffULL, 0x0000003807137812ULL, 0x040fe400078efcffULL,
0x0000003907077812ULL, 0x000fe400078efcffULL, 0xff8000002d2d7808ULL, 0x000fe40005800000ULL,
0xff80000012127808ULL, 0x000fc40005800000ULL, 0xff8000002e2e7808ULL, 0x000fe40005000000ULL,
0xff8000001a1a7808ULL, 0x000fe40005000000ULL, 0xff8000002f2f7808ULL, 0x000fe40004800000ULL,
0xff8000001b1b7808ULL, 0x000fe40004800000ULL, 0x000000061500720cULL, 0x080fe40003f66070ULL,
0x000000061300720cULL, 0x000fc40003f46070ULL, 0x000000060700720cULL, 0x000fe40003f26070ULL,
0xff80000034347808ULL, 0x000fe40004000000ULL, 0xff8000001c1c7808ULL, 0x000fe40004000000ULL,
0xff80000035357808ULL, 0x000fe40006000000ULL, 0xff8000001d1d7808ULL, 0x000fe40006000000ULL,
0xff80000036367808ULL, 0x000fc40007000000ULL, 0xff8000001e1e7808ULL, 0x000fe40007000000ULL,
0xff80000037377808ULL, 0x000fe40006800000ULL, 0xff8000001f1f7808ULL, 0x000fe40006800000ULL,
0xff80000038387808ULL, 0x000fe40005800000ULL, 0xff80000020207808ULL, 0x000fe40005800000ULL,
0xff80000039397808ULL, 0x000fc40005000000ULL, 0xff80000021217808ULL, 0x000fe40005000000ULL,
0xff8000003a3a7808ULL, 0x000fe40004800000ULL, 0xff80000022227808ULL, 0x000fc40004800000ULL,
0x0000000d0800720bULL, 0x004fe40003f1e000ULL, 0x000000280900720bULL, 0x000fe40003f3e000ULL,
0x000000080d077208ULL, 0x000fe40004000000ULL, 0x0000000928067208ULL, 0x000fc40004800000ULL,
0x0000000c0700720bULL, 0x000fe40003f1e000ULL, 0x000000230600720bULL, 0x000fe40003f3e000ULL,
0x000000070c077208ULL, 0x000fe40004000000ULL, 0x0000000623067208ULL, 0x000fe40004800000ULL,
0x0000000e0700720bULL, 0x000fe40003f1e000ULL, 0x000000290600720bULL, 0x000fc40003f3e000ULL,
0x000000070e087208ULL, 0x000fe40004000000ULL, 0x0000000629077208ULL, 0x000fe40004800000ULL,
0x0000000f0800720bULL, 0x000fe40003f1e000ULL, 0x0000002a0700720bULL, 0x000fe40003f3e000ULL,
0x000000080f097208ULL, 0x000fe40004000000ULL, 0x000000072a067208ULL, 0x000fc40004800000ULL,
0x000000100900720bULL, 0x000fe40003f1e000ULL, 0x0000002b0600720bULL, 0x000fe40003f3e000ULL,
0x0000000910087208ULL, 0x000fe40004000000ULL, 0x000000062b077208ULL, 0x000fe40004800000ULL,
0x000000110800720bULL, 0x000fe40003f1e000ULL, 0x0000002c0700720bULL, 0x000fc40003f3e000ULL,
0x0000000811097208ULL, 0x000fe40004000000ULL, 0x000000072c067208ULL, 0x000fe40004800000ULL,
0x000000120900720bULL, 0x000fe40003f1e000ULL, 0x0000002d0600720bULL, 0x000fe40003f3e000ULL,
0x0000000912097208ULL, 0x000fe40004000000ULL, 0x000000062d077208ULL, 0x000fc40004800000ULL,
0x0000001a0900720bULL, 0x000fe40003f1e000ULL, 0x0000002e0700720bULL, 0x000fe40003f3e000ULL,
0x000000091a067208ULL, 0x000fe40004000000ULL, 0x000000072e087208ULL, 0x000fe40004800000ULL,
0x0000001b0600720bULL, 0x000fe40003f1e000ULL, 0x0000002f0800720bULL, 0x000fc40003f3e000ULL,
0x000000061b077208ULL, 0x000fe40004000000ULL, 0x000000082f097208ULL, 0x000fe40004800000ULL,
0x0000001c0700720bULL, 0x000fe40003f1e000ULL, 0x000000340900720bULL, 0x000fe40003f3e000ULL,
0x000000071c067208ULL, 0x000fe40004000000ULL, 0x0000000934087208ULL, 0x000fc40004800000ULL,
0x0000001d0600720bULL, 0x000fe40003f1e000ULL, 0x000000350800720bULL, 0x000fe40003f3e000ULL,
0x000000061d077208ULL, 0x000fe40004000000ULL, 0x0000000835097208ULL, 0x000fe40004800000ULL,
0x0000001e0700720bULL, 0x000fe40003f1e000ULL, 0x000000360900720bULL, 0x000fc40003f3e000ULL,
0x000000071e067208ULL, 0x000fe40004000000ULL, 0x0000000936087208ULL, 0x000fe40004800000ULL,
0x0000001f0600720bULL, 0x000fe40003f1e000ULL, 0x000000370800720bULL, 0x000fe40003f3e000ULL,
0x000000061f077208ULL, 0x000fe40004000000ULL, 0x0000000837097208ULL, 0x000fc40004800000ULL,
0x000000200700720bULL, 0x000fe40003f1e000ULL, 0x000000380900720bULL, 0x000fe40003f3e000ULL,
0x0000000720067208ULL, 0x000fe40004000000ULL, 0x0000000938087208ULL, 0x000fe40004800000ULL,
0x000000210600720bULL, 0x000fe40003f1e000ULL, 0x000000390800720bULL, 0x000fc40003f3e000ULL,
0x0000000621077208ULL, 0x000fe40004000000ULL, 0x0000000839097208ULL, 0x000fe40004800000ULL,
0x000000220700720bULL, 0x000fe40003f1e000ULL, 0x0000003a0900720bULL, 0x000fe40003f3e000ULL,
0x0000000722087208ULL, 0x000fe40004000000ULL, 0x000000093a137208ULL, 0x000fe20004800000ULL,
0x00001d127f007947ULL, 0x000fec000b800000ULL, 0x0c401f0008067f89ULL, 0x0004e400000e0000ULL,
0x000000060800720bULL, 0x008fc80003f1e000ULL, 0x0000000806147208ULL, 0x000fe20004000000ULL,
0x00001d427f007947ULL, 0x000fea000b800000ULL, 0x0c401f0013067f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a077f89ULL, 0x000f2800000e0000ULL, 0x0c401f000b087f89ULL, 0x006e6800000e0000ULL,
0x0c201f0014247f89ULL, 0x000ea200000e0000ULL, 0x000000061300720bULL, 0x008fc40003f1e000ULL,
0x000000070a00720bULL, 0x010fe40003f3e000ULL, 0x0000001306067208ULL, 0x000fe40004000000ULL,
0x0000000a07077208ULL, 0x000fe40004800000ULL, 0x000000080b00720bULL, 0x002fe20003f1e000ULL,
0x0c201f0006257f89ULL, 0x000e6600000e0000ULL, 0x0000000b083c7208ULL, 0x000fe20004000000ULL,
0x0c201f0007267f89ULL, 0x000ee200000e0000ULL, 0x000000241400720bULL, 0x004fc60003f1e000ULL,
0x0c201f003c3d7f89ULL, 0x0004a200000e0000ULL, 0x0000001424247208ULL, 0x000fe40004000000ULL,
0x000000250600720bULL, 0x002fe40003f3e000ULL, 0x000000260700720bULL, 0x008fe40003f5e000ULL,
0x0000000625257208ULL, 0x000fe40004800000ULL, 0x0000000726267208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b24077820ULL, 0x004fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x3fb8aa3b25067820ULL, 0x000fe20000410000ULL, 0x00000004003e7c02ULL, 0x000fe20008000f00ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3f8000003e3e783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL, 0x0000000d00197308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x00000003273b7819ULL, 0x040fe200000006ffULL,
0x3fb8aa3b10157823ULL, 0x100fe20000010807ULL, 0x0000000327487819ULL, 0x000fe200000006ffULL,
0x3fb8aa3b11147823ULL, 0x100fe20000010807ULL, 0x0000003e00507202ULL, 0x000fe20000000f00ULL,
0x3fb8aa3b12137823ULL, 0x100fe20000010807ULL, 0x0000000c00187308ULL, 0x0022e20000000800ULL,
0x3fb8aa3b1a127823ULL, 0x100fe20000010807ULL, 0x00000001271a7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b1b117823ULL, 0x100fe20000010807ULL, 0x0000000cbdbd7812ULL, 0x000fe200078ec0ffULL,
0x3fb8aa3b1c107823ULL, 0x100fe20000010807ULL, 0x0000000303ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b1f0d7823ULL, 0x104fe20000010807ULL, 0x0000000e00177308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b200c7823ULL, 0x102fe20000010807ULL, 0x0000003d3c00720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b210b7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b22227823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b280a7823ULL, 0x100fe20000010806ULL, 0x0000000f00167308ULL, 0x0003220000000800ULL,
0x3fb8aa3b1e0e7823ULL, 0x104fe20000010807ULL, 0x000000191828723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b29087823ULL, 0x100fe40000010806ULL, 0x3fb8aa3b2a097823ULL, 0x100fe40000010806ULL,
0x3fb8aa3b2b2b7823ULL, 0x000fe20000010806ULL, 0x0000000a000a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1d0f7823ULL, 0x002fc40000010807ULL, 0x3fb8aa3b23077823ULL, 0x000fe40000010806ULL,
0x000000ffff3f7224ULL, 0x000fe400078e003eULL, 0x3fb8aa3b2d237823ULL, 0x100fe20000010806ULL,
0x0000000800087308ULL, 0x000fe20000000800ULL, 0x00000017162a723eULL, 0x010fe200000010ffULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe40000010806ULL, 0x3fb8aa3b2f217823ULL, 0x100fe40000010806ULL,
0x3fb8aa3b34207823ULL, 0x100fe20000010806ULL, 0x0000000227347810ULL, 0x000fe20007ffe0ffULL,
0x0000000700077308ULL, 0x000e620000000800ULL, 0x3fb8aa3b351f7823ULL, 0x000fc40000010806ULL,
0x3fb8aa3b361e7823ULL, 0x100fe40000010806ULL, 0x3fb8aa3b371d7823ULL, 0x100fe40000010806ULL,
0x0000000827357824ULL, 0x040fe200078e00ffULL, 0x0000000900097308ULL, 0x000ea20000000800ULL,
0x0000000827377824ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b381c7823ULL, 0x000fe20000010806ULL,
0xfffffff835407812ULL, 0x000fe200078ee21aULL, 0x3fb8aa3b391b7823ULL, 0x000fe20000010806ULL,
0x00000003271a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x100fe200078e003eULL,
0x0000002b006d7308ULL, 0x0005e20000000800ULL, 0x0000000a0729723eULL, 0x002fe200000010ffULL,
0x000000ffff4b7224ULL, 0x000fe200078e003eULL, 0x0000000427387810ULL, 0x040fe20007ffe0ffULL,
0x00000008274c7824ULL, 0x000fe200078e00ffULL, 0xfffffff83b427812ULL, 0x000fe200078ee21aULL,
0x000000ffff517224ULL, 0x000fe200078e003eULL, 0x0000000527397810ULL, 0x000fe20007ffe0ffULL,
0x0000002200747308ULL, 0x0003e20000000800ULL, 0x00000008092b723eULL, 0x004fc400000010ffULL,
0xfffffff848487812ULL, 0x000fe400078ee239ULL, 0x0000000627397810ULL, 0x040fe40007ffe0ffULL,
0xffffffff273b7810ULL, 0x000fe20007ffe0ffULL, 0x0000003e2830723cULL, 0x000f6200000418ffULL,
0x3fb8aa3b2e227823ULL, 0x102fe20000010806ULL, 0x0000001500157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b3a067823ULL, 0x000fe20000010806ULL, 0xfffffff8373a7812ULL, 0x000fe400078ee234ULL,
0xfffffff84c4c7812ULL, 0x000fc800078ee23bULL, 0x0000001400147308ULL, 0x000e700000000800ULL,
0x0000001300137308ULL, 0x000ff00000000800ULL, 0x0000001200127308ULL, 0x000eb00000000800ULL,
0x0000002c006c7308ULL, 0x0002f00000000800ULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x00000015142c723eULL, 0x002fc400000010ffULL, 0x00000013122e723eULL, 0x004fca00000010ffULL,
0x0000002200227308ULL, 0x000e620000000800ULL, 0x0000006d6c2d723eULL, 0x008fce00000010ffULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x00000023222f723eULL, 0x002fce00000010ffULL,
0x0000001000107308ULL, 0x000e620000000800ULL, 0x0000003e2c30723cULL, 0x020b6e0000041830ULL,
0x0000000f000f7308ULL, 0x000fe20000000800ULL, 0x00000008273f7824ULL, 0x020fce00078e00ffULL,
0x0000000e000e7308ULL, 0x000ea20000000800ULL, 0x000000111034723eULL, 0x002fe400000010ffULL,
0xfffffff83f467812ULL, 0x000fe200078ee238ULL, 0x0000000827387824ULL, 0x000fe200078e00ffULL,
0x00000003443f7819ULL, 0x000fc600000006ffULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0xfffffff838387812ULL, 0x000fe400078ee227ULL, 0xfffffff83f4e7812ULL, 0x000fca00078ee244ULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x0000000f0e36723eULL, 0x004fce00000010ffULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x0000001e001e7308ULL, 0x000ea20000000800ULL,
0x000000212035723eULL, 0x002fce00000010ffULL, 0x0000000d000d7308ULL, 0x000fe20000000800ULL,
0x0000001f1e37723eULL, 0x004fce00000010ffULL, 0x0000000c000c7308ULL, 0x000e620000000800ULL,
0x0000004a3430723cULL, 0x000b6e0000041830ULL, 0x0000000b000b7308ULL, 0x000ea20000000800ULL,
0x00000008274a7824ULL, 0x020fe200078e00ffULL, 0x0001200075277811ULL, 0x000fcc00078e58ffULL,
0x0000001d001d7308ULL, 0x000fe20000000800ULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee239ULL,
0x00000010383f7824ULL, 0x100fe200078e0227ULL, 0x0000000d0c38723eULL, 0x002fe200000010ffULL,
0x000000103a417824ULL, 0x100fe400078e0227ULL, 0x0000001040407824ULL, 0x100fe400078e0227ULL,
0x0000001c001c7308ULL, 0x000e620000000800ULL, 0x0000000b743a723eULL, 0x004fe200000010ffULL,
0x00000010463e7824ULL, 0x000fe200078e0227ULL, 0x0000003fbd3f7210ULL, 0x040fe20007ffe0ffULL,
0x00000001bd407824ULL, 0x000fc400078e0240ULL, 0x000000104a437824ULL, 0x100fe200078e0227ULL,
0x0000003ebd3e7210ULL, 0x040fe20007ffe0ffULL, 0x0000001b001b7308ULL, 0x000fe20000000800ULL,
0x000000104c447824ULL, 0x000fe200078e0227ULL, 0x000000283f007388ULL, 0x0005e20000000800ULL,
0x00000001bd417824ULL, 0x040fe400078e0241ULL, 0x00000001bd437824ULL, 0x040fe200078e0243ULL,
0x0000002a40007388ULL, 0x0005e20000000800ULL, 0x00000001bd447824ULL, 0x000fe200078e0244ULL,
0x00000006001a7308ULL, 0x0007220000000800ULL, 0x0000001d1c39723eULL, 0x002fe200000010ffULL,
0x0000002c41007388ULL, 0x0005e20000000800ULL, 0x0000001042067824ULL, 0x108fe200078e0227ULL,
0x0000002748427211ULL, 0x000fe200078e20ffULL, 0x000000104e277824ULL, 0x000fc400078e0227ULL,
0x00000001bd067824ULL, 0x040fe400078e0206ULL, 0x00000001bd427824ULL, 0x040fe200078e0242ULL,
0x0000001b1a3b723eULL, 0x010fe400000010ffULL, 0x00000027bd467210ULL, 0x000fe20007ffe0ffULL,
0x0000002e06007388ULL, 0x0005e20000000800ULL, 0x0000003c3d277208ULL, 0x000fc60004800000ULL,
0x000000503830723cULL, 0x000f620000041830ULL, 0x000000343e007388ULL, 0x0005e80000000800ULL,
0x0000003642007388ULL, 0x0005e80000000800ULL, 0x0000003843007388ULL, 0x0005e80000000800ULL,
0x0000003a44007388ULL, 0x0005e80000000800ULL, 0x0000002946007388ULL, 0x0005e80000000800ULL,
0x0004002b40007388ULL, 0x0005e60000000800ULL, 0x000000ffff317224ULL, 0x020fe200078e0032ULL,
0x0004002d41007388ULL, 0x0005e80000000800ULL, 0x0004002f06007388ULL, 0x0005e80000000800ULL,
0x000400353e007388ULL, 0x0005e80000000800ULL, 0x0004003742007388ULL, 0x0005e80000000800ULL,
0x0004003943007388ULL, 0x0005e80000000800ULL, 0x0004003b44007388ULL, 0x0005e80000000800ULL,
0x01c0002405008388ULL, 0x0005e80000000c00ULL, 0x01c2003005008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cad80076ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cae00076ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cae80076ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030077777a10ULL, 0x000fe20007ffe0ffULL,
0x01caf00076ff7f8cULL, 0x0003e6000c80043fULL, 0x000000707700720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff4f5000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff347807ULL, 0x008fe20004000000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x0002779000377802ULL, 0x000fc40000000f00ULL,
0x0000156000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0039ULL,
0xfffdce2000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe40004800000ULL,
0xffffffff00397802ULL, 0x000fe40000000f00ULL, 0x000277f000377802ULL, 0x000fc40000000f00ULL,
0x0000150000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0039ULL,
0xfffdce5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3b7224ULL, 0x000fe200078e0029ULL,
0xffffffff003f7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3a7224ULL, 0x000fe200078e0030ULL,
0x0002787000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fc400078e00ffULL,
0x0000144000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e003aULL,
0xfffdced000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0030ULL,
0xffffffff003f7802ULL, 0x002fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0029ULL,
0x000278f000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fc400078e00ffULL,
0x000013c000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e003aULL,
0xfffdcfb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0028ULL,
0x0000001f003c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0029ULL,
0x0002797000347802ULL, 0x000fe20000000f00ULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x0000134000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffdd16000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3b7224ULL, 0x002fe200078e0027ULL,
0x0000001f003c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3a7224ULL, 0x000fe200078e0028ULL,
0x000279f000347802ULL, 0x000fe20000000f00ULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x000012c000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffdd11000007947ULL, 0x000fea000383ffffULL, 0x00000037003a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0078ULL, 0x00027a7000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x0000124000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffdf6a000007947ULL, 0x000fea000383ffffULL, 0x00000037003a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fe200078e0076ULL, 0x00027af000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x000011c000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffdf64000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x008fe20004000000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x00027b5000377802ULL, 0x000fc40000000f00ULL,
0x000011a000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0039ULL,
0xfffe1fc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe20004800000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x00027bb000377802ULL, 0x000fc40000000f00ULL,
0x0000114000007944ULL, 0x002fea0003c00000ULL, 0xfffe200000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e003dULL, 0xffffffff003f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0078ULL, 0x00027c2000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fc400078e00ffULL, 0x0000109000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff337224ULL, 0x004fe200078e003aULL, 0xfffe207000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e003dULL, 0xffffffff003f7802ULL, 0x002fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0076ULL, 0x00027ca000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fc400078e00ffULL, 0x0000101000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff337224ULL, 0x004fe200078e003aULL, 0xfffe214000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0000001f003c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0078ULL, 0x00027d2000347802ULL, 0x000fe20000000f00ULL,
0xffffffffff3f7424ULL, 0x000fc400078e00ffULL, 0x00000f9000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e003aULL, 0xfffe22e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0000001f003c7802ULL, 0x002fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0076ULL, 0x00027da000347802ULL, 0x000fe20000000f00ULL,
0xffffffffff3f7424ULL, 0x000fc400078e00ffULL, 0x00000f1000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffe228000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0000001f003c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0078ULL, 0x00027e2000347802ULL, 0x000fe20000000f00ULL,
0xffffffffff3f7424ULL, 0x000fc400078e00ffULL, 0x00000e9000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e003aULL, 0xfffe44f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0000001f003c7802ULL, 0x002fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0076ULL, 0x00027ea000347802ULL, 0x000fe20000000f00ULL,
0xffffffffff3f7424ULL, 0x000fc400078e00ffULL, 0x00000e1000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffe449000007947ULL, 0x000fea000383ffffULL,
0x00000001ff347807ULL, 0x008fe20004000000ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x00027f0000377802ULL, 0x000fc40000000f00ULL, 0x00000df000007944ULL, 0x002fea0003c00000ULL,
0x0000003900247202ULL, 0x000fe20000000f00ULL, 0xfffe6c5000007947ULL, 0x000fea000383ffffULL,
0x00000001ff347807ULL, 0x000fe20004800000ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x00027f6000377802ULL, 0x000fc40000000f00ULL, 0x00000d9000007944ULL, 0x002fea0003c00000ULL,
0xfffe6c9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e003dULL,
0x00000078003b7202ULL, 0x000fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fe200078e00ffULL,
0x00027fd000347802ULL, 0x000fe20000000f00ULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x00000ce000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff337224ULL, 0x004fe200078e003aULL,
0xfffe6d0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e003dULL,
0x00000076003b7202ULL, 0x002fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fe200078e00ffULL,
0x0002805000347802ULL, 0x000fe20000000f00ULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x00000c6000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff337224ULL, 0x004fe200078e003aULL,
0xfffe6dd000007947ULL, 0x000fea000383ffffULL, 0x00000037003a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0078ULL, 0x000280d000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x00000be000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffe6f7000007947ULL, 0x000fea000383ffffULL, 0x00000037003a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fe200078e0076ULL, 0x0002815000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x00000b6000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffe6f1000007947ULL, 0x000fea000383ffffULL, 0x00000037003a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0078ULL, 0x000281d000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fc400078e00ffULL,
0x00000ae000007944ULL, 0x002fea0003c00000ULL, 0x0000003a00267202ULL, 0x004fe20000000f00ULL,
0xfffe918000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0037ULL,
0xffffffff003f7802ULL, 0x002fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0076ULL,
0x0002825000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fc400078e00ffULL,
0x00000a6000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffe912000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x008fe20004000000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x000282b000377802ULL, 0x000fc40000000f00ULL,
0x00000a4000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0039ULL,
0xfffeb8e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe20004800000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x0002831000377802ULL, 0x000fc40000000f00ULL,
0x000009e000007944ULL, 0x002fea0003c00000ULL, 0xfffeb92000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e003dULL, 0x00000078003b7202ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x0002838000347802ULL, 0x000fe20000000f00ULL,
0xffffffffff3f7424ULL, 0x000fc400078e00ffULL, 0x0000093000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff337224ULL, 0x004fe200078e003aULL, 0xfffeb99000007947ULL, 0x000fea000383ffffULL,
0x0000003d003a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x002fe200078e0076ULL,
0x0002840000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3f7424ULL, 0x000fc400078e00ffULL, 0x000008b000007944ULL, 0x004fea0003c00000ULL,
0x0000003a00337202ULL, 0x004fe20000000f00ULL, 0xfffeba6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0000001f003c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0078ULL, 0x0002848000347802ULL, 0x000fe20000000f00ULL,
0xffffffffff3f7424ULL, 0x000fc400078e00ffULL, 0x0000083000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e003aULL, 0xfffebc0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x00000076003b7202ULL, 0x002fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x0002850000347802ULL, 0x000fe20000000f00ULL,
0xffffffffff3f7424ULL, 0x000fc400078e00ffULL, 0x000007b000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffebba000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0xffffffff003f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0078ULL, 0x0002858000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fc400078e00ffULL, 0x0000073000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e003aULL, 0xfffede1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0000001f003c7802ULL, 0x002fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0076ULL, 0x0002860000347802ULL, 0x000fe20000000f00ULL,
0xffffffffff3f7424ULL, 0x000fc400078e00ffULL, 0x000006b000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffeddb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0002ULL, 0xffffffff003f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x0002867000347802ULL, 0x000fc40000000f00ULL,
0x0000064000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e003aULL,
0xfffee66000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0002ULL,
0xffffffff003f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fe200078e00ffULL,
0x000286e000347802ULL, 0x000fc40000000f00ULL, 0x000005d000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e003aULL, 0xfffee73000007947ULL, 0x000fea000383ffffULL,
0x0000000200097802ULL, 0x000fe20000000f00ULL, 0x0000001fff3d7424ULL, 0x000fe200078e00ffULL,
0x0002875000067802ULL, 0x000fe20000000f00ULL, 0xffffffffff187424ULL, 0x000fc400078e00ffULL,
0x0000052000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e003dULL,
0xffffe29000007947ULL, 0x000fea000383ffffULL, 0x0000001300087202ULL, 0x006fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fe200078e00ffULL, 0x000287d000067802ULL, 0x000fe20000000f00ULL,
0x0000001fff3d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff187424ULL, 0x000fc400078e00ffULL,
0x000004a000007944ULL, 0x000fea0003c00000ULL, 0x0000003d1300720bULL, 0x004fe20003f1e000ULL,
0x00000002ff097424ULL, 0x002fe200078e00ffULL, 0x0000000a00087202ULL, 0x000fe20000000f00ULL,
0xffffffffff187424ULL, 0x000fe200078e00ffULL, 0x000000133d167208ULL, 0x000fe20004000000ULL,
0x0000001fff3d7424ULL, 0x000fe200078e00ffULL, 0x0002885000067802ULL, 0x000fc40000000f00ULL,
0x0000042000007944ULL, 0x000fea0003c00000ULL, 0x0000003d0a00720bULL, 0x004fe20003f1e000ULL,
0x00000002ff097424ULL, 0x002fe200078e00ffULL, 0x0000000b00087202ULL, 0x000fe20000000f00ULL,
0xffffffffff187424ULL, 0x000fe200078e00ffULL, 0x0000000a3d0a7208ULL, 0x000fe20004000000ULL,
0x0000001fff3d7424ULL, 0x000fe200078e00ffULL, 0x000288d000067802ULL, 0x000fc40000000f00ULL,
0x000003a000007944ULL, 0x000fea0003c00000ULL, 0x0000003d0b00720bULL, 0x004fe20003f1e000ULL,
0x00000001ff097424ULL, 0x002fe200078e00ffULL, 0x0000001400087202ULL, 0x000fe20000000f00ULL,
0xffffffffff187424ULL, 0x000fe200078e00ffULL, 0x0000000b3d3c7208ULL, 0x000fe20004000000ULL,
0x0000001fff3d7424ULL, 0x000fe200078e00ffULL, 0x0002895000067802ULL, 0x000fc40000000f00ULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x0000003d1400720bULL, 0x004fe20003f1e000ULL,
0x00000001ff097424ULL, 0x002fe200078e00ffULL, 0x0000001600087202ULL, 0x000fe20000000f00ULL,
0xffffffffff187424ULL, 0x000fe200078e00ffULL, 0x000000143d247208ULL, 0x000fe20004000000ULL,
0x0000001fff3d7424ULL, 0x000fe200078e00ffULL, 0x000289d000067802ULL, 0x000fc40000000f00ULL,
0x000002a000007944ULL, 0x000fea0003c00000ULL, 0x0000003d1600720bULL, 0x004fe20003f1e000ULL,
0x00000001ff097424ULL, 0x002fe200078e00ffULL, 0x0000000a00087202ULL, 0x000fe20000000f00ULL,
0xffffffffff187424ULL, 0x000fe200078e00ffULL, 0x000000163d257208ULL, 0x000fe20004000000ULL,
0x0000001fff3d7424ULL, 0x000fe200078e00ffULL, 0x00028a5000067802ULL, 0x000fc40000000f00ULL,
0x0000022000007944ULL, 0x000fea0003c00000ULL, 0x0000003d0a00720bULL, 0x004fe20003f1e000ULL,
0x00000001ff097424ULL, 0x002fe200078e00ffULL, 0x0000003c00087202ULL, 0x000fe20000000f00ULL,
0xffffffffff187424ULL, 0x000fe200078e00ffULL, 0x0000000a3d267208ULL, 0x000fe20004000000ULL,
0x0000001fff3d7424ULL, 0x000fe200078e00ffULL, 0x00028ad000067802ULL, 0x000fc40000000f00ULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0xffffe08000007947ULL, 0x000fea000383ffffULL,
0x0180000030027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000003000028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff30ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000030037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003000027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x00cfe200078e0002ULL,
0x0000000700027202ULL, 0x000fe20000000f00ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffd739002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff077424ULL, 0x000fe200078e00ffULL,
0x0000001800007348ULL, 0x000fe80003800000ULL, 0x0c000009083d7389ULL, 0x0002a200000e003dULL,
0xfffd735006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff357424ULL, 0x000fe200078e00ffULL,
0x0000003f00007348ULL, 0x000fe80003800000ULL, 0x0000003b3a3a7389ULL, 0x0002a200000e003cULL,
0xfffd731034007950ULL, 0x000fea0003c3ffffULL, 0x000000013400780cULL, 0x000fe20003f25070ULL,
0x0000003900007348ULL, 0x000fe80003800000ULL, 0x00000000ff357424ULL, 0x000fd000078e00ffULL,
0x0000000000347806ULL, 0x000fc800048e0100ULL, 0x0000003934397212ULL, 0x000fe400078ec0ffULL,
0x0000003700347202ULL, 0x000fc80000000f00ULL, 0xfffd72a034007950ULL, 0x000fea0003c3ffffULL,
0x0000002500007348ULL, 0x000fe80003800000ULL, 0x00000000ff257424ULL, 0x000fc800078e00ffULL,
0xfffd727024007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000056fULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006d0ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000940ULL,
0x0000000000000460ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000da0ULL,
0x00000000000000e4ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000e84ULL,
0x0000000000000c70ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001af8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001b08ULL,
0x00000000000000b0ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001bb8ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001bbcULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001e00ULL,
0x0000000000028e80ULL, 0xef00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000002ac80ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000002acc0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000002b040ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001bb8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000290c8ULL,
0x00000000000290c8ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000002ac80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000002b040ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_4_kvt_bf16_pagedKV_128_nqpkv_1_m_1_sm_80_cubin_len = 176416;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
