/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000015a78ULL, 0x00000000000155f8ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x0000000000013fa0ULL, 0x0000000000000260ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000014200ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00013fa000000000ULL, 0x0000780400000000ULL, 0x0400288080810c00ULL, 0x0000000000004f64ULL,
0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080920828808081ULL, 0x80162880808b0828ULL, 0x0000000310288082ULL,
0x808b920000000000ULL, 0x0000000022002880ULL, 0x0000002cffffffffULL, 0x0000006800000000ULL,
0x00013fa000000000ULL, 0x0000026000000000ULL, 0x00005c0400000000ULL, 0x80842880808b0900ULL,
0x0000000000002880ULL, 0x0000000e00082f04ULL, 0x0008120400000080ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL, 0x0000000e00081104ULL,
0x0008120400000000ULL, 0x000000000000000eULL, 0x0000007c00043704ULL, 0x00000000000c1704ULL,
0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL,
0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x00801b0380005003ULL,
0x00012ce000103104ULL, 0x00012d0000012cf0ULL, 0x010c290400012d10ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0500001e0500001fULL, 0x0500001f0500001eULL, 0x0500001f0500001fULL, 0x0500001f0500001fULL,
0x0500001f0500001fULL, 0x0500001f0500001fULL, 0x0500001f0500001fULL, 0x0500001f0500001fULL,
0x010c28040500001fULL, 0x00000100000000b0ULL, 0x000019c000001930ULL, 0x00001a7000001a40ULL,
0x00001f3000001e20ULL, 0x0000321000003140ULL, 0x000044c000004450ULL, 0x0000456000004540ULL,
0x0000487000004860ULL, 0x00005a4000005a30ULL, 0x00006d2000006cb0ULL, 0x00006dc000006da0ULL,
0x000070c0000070b0ULL, 0x000082b0000082a0ULL, 0x0000958000009510ULL, 0x0000962000009600ULL,
0x0000993000009920ULL, 0x0000ab200000ab10ULL, 0x0000bb200000bb10ULL, 0x0000dd900000c290ULL,
0x0000e2e00000ddd0ULL, 0x0000e7700000e300ULL, 0x000125f0000125e0ULL, 0x0001261000012600ULL,
0x0001266000012640ULL, 0x0001269000012680ULL, 0x00012cf000012cd0ULL, 0x00012d4000012d00ULL,
0x00012d6000012d50ULL, 0x00013b6000013ad0ULL, 0x00013c2000013bc0ULL, 0x00013cf000013c90ULL,
0x00013db000013d50ULL, 0x00013ed000013e40ULL, 0x06f0390400013f60ULL, 0x000000ff00000230ULL,
0x0004010000010600ULL, 0x0000000c00000310ULL, 0x003f010000010608ULL, 0x0000000c00000420ULL,
0x003f010000010688ULL, 0x0000000300000540ULL, 0x003f0100000106a8ULL, 0x000000ff00000630ULL,
0x00040100000106b8ULL, 0x000000ff000008f0ULL, 0x000b010700010600ULL, 0x0000000f00000a60ULL,
0x000b010100010688ULL, 0x000000ff00001010ULL, 0x000b0107000106a8ULL, 0x000000ff00001050ULL,
0x000b0101000106a8ULL, 0x000000ff000010d0ULL, 0x000b0101000106b8ULL, 0x000000ff000011c0ULL,
0x0008010500000000ULL, 0x000000ff000012b0ULL, 0x000b0109000106b8ULL, 0x000000ff000017a0ULL,
0x000b0107000106b0ULL, 0x000000ff000017f0ULL, 0x000b0101000106b0ULL, 0x000000ff00001830ULL,
0x0005010500000000ULL, 0x0000000f00001850ULL, 0x000b010100010608ULL, 0x0000000f00001860ULL,
0x000b010900010608ULL, 0x000000ff00001cc0ULL, 0x000b0109000106a8ULL, 0x000000ff00002a50ULL,
0x000b0101000106b8ULL, 0x000000ff00002b30ULL, 0x0008010500000000ULL, 0x000000ff00002ea0ULL,
0x000b0109000106b8ULL, 0x000000ff00003070ULL, 0x0005010700000000ULL, 0x000000ff000030a0ULL,
0x000b0101000106a8ULL, 0x000000ff000030c0ULL, 0x000a010500000000ULL, 0x000000ff000030e0ULL,
0x000b0109000106b0ULL, 0x000000ff00003fe0ULL, 0x000b0101000106b8ULL, 0x000000ff00003ff0ULL,
0x000b010100010688ULL, 0x000000ff00004030ULL, 0x0008010500000000ULL, 0x000000ff00004230ULL,
0x000b0109000106b8ULL, 0x000000ff00004380ULL, 0x000a010700000000ULL, 0x000000ff000043c0ULL,
0x000b0101000106b0ULL, 0x000000ff000043d0ULL, 0x0005010500000000ULL, 0x0000000f000043e0ULL,
0x000b010100010628ULL, 0x0000000f000043f0ULL, 0x000b010900010628ULL, 0x000000ff000047d0ULL,
0x000b0109000106a8ULL, 0x000000ff00005490ULL, 0x000b0101000106b8ULL, 0x000000ff00005560ULL,
0x0008010500000000ULL, 0x000000ff000058c0ULL, 0x000b0109000106b8ULL, 0x000000ff00005970ULL,
0x0005010700000000ULL, 0x000000ff000059a0ULL, 0x000b0101000106a8ULL, 0x000000ff000059b0ULL,
0x000a010500000000ULL, 0x000000ff000059d0ULL, 0x000b0109000106b0ULL, 0x000000ff00006800ULL,
0x000b0101000106b8ULL, 0x000000ff00006830ULL, 0x000b010100010690ULL, 0x000000ff00006890ULL,
0x0008010500000000ULL, 0x000000ff00006a90ULL, 0x000b0109000106b8ULL, 0x000000ff00006be0ULL,
0x000a010700000000ULL, 0x000000ff00006c20ULL, 0x000b0101000106b0ULL, 0x000000ff00006c30ULL,
0x0005010500000000ULL, 0x0000000f00006c40ULL, 0x000b010100010648ULL, 0x0000000f00006c50ULL,
0x000b010900010648ULL, 0x000000ff00007020ULL, 0x000b0109000106a8ULL, 0x000000ff00007cf0ULL,
0x000b0101000106b8ULL, 0x000000ff00007dc0ULL, 0x0008010500000000ULL, 0x000000ff00008130ULL,
0x000b0109000106b8ULL, 0x000000ff000081e0ULL, 0x0005010700000000ULL, 0x000000ff00008210ULL,
0x000b0101000106a8ULL, 0x000000ff00008220ULL, 0x000a010500000000ULL, 0x000000ff00008240ULL,
0x000b0109000106b0ULL, 0x000000ff000090a0ULL, 0x000b0101000106b8ULL, 0x000000ff000090b0ULL,
0x000b010100010698ULL, 0x000000ff000090f0ULL, 0x0008010500000000ULL, 0x000000ff000092e0ULL,
0x000b0109000106b8ULL, 0x000000ff00009440ULL, 0x000a010700000000ULL, 0x000000ff00009480ULL,
0x000b0101000106b0ULL, 0x000000ff00009490ULL, 0x0005010500000000ULL, 0x0000000f000094a0ULL,
0x000b010100010668ULL, 0x0000000f000094b0ULL, 0x000b010900010668ULL, 0x000000ff00009880ULL,
0x000b0109000106a8ULL, 0x000000ff0000a500ULL, 0x000b0101000106b8ULL, 0x000000ff0000a630ULL,
0x0008010500000000ULL, 0x000000ff0000a9a0ULL, 0x000b0109000106b8ULL, 0x000000ff0000aa40ULL,
0x0005010700000000ULL, 0x000000ff0000aa70ULL, 0x000b0101000106a8ULL, 0x000000ff0000aa80ULL,
0x000a010500000000ULL, 0x000000ff0000aaa0ULL, 0x000b0109000106b0ULL, 0x000000ff0000b890ULL,
0x000b0101000106b8ULL, 0x000000ff0000b8c0ULL, 0x000b0101000106a0ULL, 0x000000ff0000ea20ULL,
0x000b010100010600ULL, 0x000000ff0000f8e0ULL, 0x000b010900010600ULL, 0x000000ff0000fbc0ULL,
0x000b010100010600ULL, 0x000000ff0000fbd0ULL, 0x000b010900010600ULL, 0x0000000000011d30ULL,
0x003f010100010688ULL, 0x0000000000011eb0ULL, 0x003f010900010688ULL, 0x0000000600013050ULL,
0x003f010100010608ULL, 0x0000000600013060ULL, 0x003f010100010610ULL, 0x0000000600013070ULL,
0x003f010100010618ULL, 0x0000000600013080ULL, 0x003f010100010620ULL, 0x00000039000130c0ULL,
0x003f0109000106b8ULL, 0x0000000c00013120ULL, 0x003f010900010608ULL, 0x0000002500013190ULL,
0x003f0109000106a8ULL, 0x0000001100013200ULL, 0x003f0109000106b8ULL, 0x0000001100013270ULL,
0x003f0109000106b0ULL, 0x00000029000132e0ULL, 0x003f0109000106b8ULL, 0x0000000c00013340ULL,
0x003f010900010628ULL, 0x00000027000133b0ULL, 0x003f0109000106a8ULL, 0x0000001100013420ULL,
0x003f0109000106b8ULL, 0x0000001100013490ULL, 0x003f0109000106b0ULL, 0x0000002900013500ULL,
0x003f0109000106b8ULL, 0x0000000c00013560ULL, 0x003f010900010648ULL, 0x00000025000135d0ULL,
0x003f0109000106a8ULL, 0x0000001900013640ULL, 0x003f0109000106b8ULL, 0x00000019000136b0ULL,
0x003f0109000106b0ULL, 0x0000003f00013720ULL, 0x003f0109000106b8ULL, 0x0000000c00013780ULL,
0x003f010900010668ULL, 0x00000025000137f0ULL, 0x003f0109000106a8ULL, 0x0000001f00013860ULL,
0x003f0109000106b8ULL, 0x0000001d000138d0ULL, 0x003f0109000106b0ULL, 0x0000001500013940ULL,
0x003f010900010600ULL, 0x0000000f000139b0ULL, 0x003f010900010600ULL, 0x0000000000013a10ULL,
0x003f010900010688ULL, 0x00101c0400053803ULL, 0x0000fbf00000e9d0ULL, 0x000130a00000fca0ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x00080a0400581903ULL,
0x005802100000000fULL, 0x0000000800043604ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000000ULL,
0x00000000000000ccULL, 0x0000000e00000002ULL, 0x0000000000013fa0ULL, 0x0000000000000044ULL,
0x0000000e00000002ULL, 0x0000000000000000ULL, 0x00000000000000a5ULL, 0x0000000e00000002ULL,
0x0000000000000000ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x00000000000a7919ULL, 0x000eae0000002300ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x0000024000007945ULL, 0x000fe20003800000ULL,
0x0000000000037919ULL, 0x000ea20000002200ULL, 0x0000000000497919ULL, 0x000f2a0000002100ULL,
0x00008800ff087b82ULL, 0x000f620000000a00ULL, 0x00000000000b7919ULL, 0x000f620000002700ULL,
0x0000000000027919ULL, 0x000f620000000000ULL, 0x00000004ff0e7e24ULL, 0x008fc4000f8e00ffULL,
0x000000010a007824ULL, 0x004fe400078e0203ULL, 0x00001fff0a0a7589ULL, 0x000fe400000e0000ULL,
0x0000008000037824ULL, 0x110fe200078e0249ULL, 0x00000005ff497819ULL, 0x000fe20000011649ULL,
0x0000000000007919ULL, 0x000ea60000002600ULL, 0x0000007f0300780cULL, 0x040fe40003f64070ULL,
0x00001fff49497589ULL, 0x000ee200000e0000ULL, 0x000000ff0300720cULL, 0x000fc40003f45270ULL,
0x0000000f0300780cULL, 0x040fe40003f04070ULL, 0x000000030300780cULL, 0x040fe40003fa4070ULL,
0x000000010300780cULL, 0x000fc80003f84070ULL, 0x000000000006b919ULL, 0x000f220000008800ULL,
0x000004000005b802ULL, 0x000fe20000000f00ULL, 0x000000040a047824ULL, 0x008fc800078e0249ULL,
0x0000000204077824ULL, 0x000fe200078e00ffULL, 0x00000654060cb816ULL, 0x010fe20000000005ULL,
0x0000000800067824ULL, 0x004fe400078e00ffULL, 0xff317217ff05b424ULL, 0x000fe400078e00ffULL,
0x000000040304b824ULL, 0x000fe200078e020cULL, 0x0000000000242947ULL, 0x022fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01060006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000380947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x00000004030c7c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x000000000c0612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x01060804063f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000385947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x002e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x00000004030c7c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x004fca0000000000ULL, 0x000000000c0612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x01068804063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010400050400b388ULL, 0x0007e20000000800ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x002e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ff8000000057882ULL, 0x000fc60000000000ULL,
0x0000000403037c11ULL, 0x000fe2000f8e18ffULL, 0x001ffe0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x00cfca0000000000ULL, 0x00000000030612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x0106a804063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x0000000000242947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x0106b806043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000840000087ab9ULL, 0x000fe20000000800ULL, 0x00000000000579c3ULL, 0x002f220000008800ULL,
0x0000000308047899ULL, 0x000fe2000800063fULL, 0x0000000807047848ULL, 0x048fe20007fe0000ULL,
0x00000001070d7836ULL, 0x040fe20000000000ULL, 0x0000000707037812ULL, 0x000fe200078ec0ffULL,
0x00008200000c7ab9ULL, 0x000fe40000000a00ULL, 0x000000040b067c24ULL, 0x000fe2000f8e0206ULL,
0x0000001f03127812ULL, 0x000fe200078e7802ULL, 0x0000000104047824ULL, 0x100fe200078e0a07ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x0000000106057824ULL, 0x040fe200078e0207ULL,
0x00008e00ff107b82ULL, 0x000ee20000000a00ULL, 0x00000001060f7824ULL, 0x000fce00078e020dULL,
0x0000000000007b1dULL, 0x004fe20000010000ULL, 0x000000ff0400720cULL, 0x000fe20003f03070ULL,
0x0000001002067824ULL, 0x000fe200078e00ffULL, 0x000000010400780cULL, 0x000fe20003f23070ULL,
0x0000020005047825ULL, 0x000fc600078e0008ULL, 0x000001f006137812ULL, 0x000fe200078ec0ffULL,
0x000002000f087825ULL, 0x000fe200078e0008ULL, 0x000000070d0f7812ULL, 0x000fe200078ec0ffULL,
0x00000654050b7896ULL, 0x010fe20008000004ULL, 0x00000013040c7210ULL, 0x000fe20007f5e0ffULL,
0x0000002007127824ULL, 0x000fe200078e0212ULL, 0x0000001f0f147812ULL, 0x000fe200078e7802ULL,
0x000106000b047890ULL, 0x000fe2000fffe03fULL, 0x0000001308087210ULL, 0x000fe40007f7e0ffULL,
0x0000000b12037c11ULL, 0x000fe2000f8e20ffULL, 0x000000200d147824ULL, 0x000fc400078e0214ULL,
0x000000ffff0d7224ULL, 0x000fe400010e0605ULL, 0x000000ffff097224ULL, 0x000fe200018e0609ULL,
0x0000000b14077c11ULL, 0x000fe2000f8e20ffULL, 0x000000040b047825ULL, 0x008fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c037faeULL, 0x0003e8000c101c4cULL,
0x0000000008077faeULL, 0x0003e2000c901c4cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe40008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000c04047981ULL, 0x000ea2000c1e1900ULL,
0x00000300ff037b82ULL, 0x002e620000000800ULL, 0x000000ff0a00720cULL, 0x000fe40003f05270ULL,
0x00000000040e72caULL, 0x004fda00000e0000ULL, 0x0000003f0e047890ULL, 0x000fe4000fffe03fULL,
0x000000ff0e057890ULL, 0x000fe4000fffe03fULL, 0x000000063f067899ULL, 0x000fe40008011604ULL,
0x000000083f077899ULL, 0x000fe20008011605ULL, 0x000000e000088947ULL, 0x002ff60003800000ULL,
0x000000040e047824ULL, 0x000fe400078e00ffULL, 0x00000008490f7824ULL, 0x000fc600078e00ffULL,
0x0000000604007c0cULL, 0x000fda000bf06070ULL, 0x00009000ff078b82ULL, 0x000e620000000800ULL,
0x000000020b058824ULL, 0x000fce00078e00ffULL, 0x00008c00ff088b82ULL, 0x000ea20000000a00ULL,
0x00000001040a8824ULL, 0x002fc800078e0207ULL, 0x0000000705058224ULL, 0x000fe400078e020aULL,
0x00000004ff0a7424ULL, 0x000fe400078e00ffULL, 0x0000000405088825ULL, 0x004fe400078e0008ULL,
0x0106880a0fff79a7ULL, 0x0003e4000850000bULL, 0xffffffffff057424ULL, 0x000fcc00078e00ffULL,
0x0000000c08058981ULL, 0x0004e2000c1e1900ULL, 0x00000004ff0c7819ULL, 0x000fe20000011602ULL,
0x000000010e077836ULL, 0x040fe20000000000ULL, 0x0000c0000b047890ULL, 0x000fe2000fffe03fULL,
0x000001000e0a7824ULL, 0x002fe200078e00ffULL, 0x000106a80b057890ULL, 0x000fe2000fffe03fULL,
0x000000020c0d7836ULL, 0x040fe20000000000ULL, 0x0000000707007c0cULL, 0x000fe2000bf06070ULL,
0x000000040c127836ULL, 0x000fe20000000000ULL, 0x0000000e0a077c48ULL, 0x000fe2000ffe0000ULL,
0x000000010f107824ULL, 0x040fe200078e020dULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x000000010f137824ULL, 0x000fe200078e0212ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000107077824ULL, 0x000fe200078e0a0aULL, 0x0000000710117812ULL, 0x000fe200078ec0ffULL,
0x000000010f097824ULL, 0x004fe200078e020cULL, 0x0000000713157812ULL, 0x000fe200078ec0ffULL,
0x000000060c167836ULL, 0x000fe20000000000ULL, 0x0000002007087807ULL, 0x000fe20000000000ULL,
0x00000001ff247424ULL, 0x000fe200078e00ffULL, 0x0000000f11117812ULL, 0x000fc400078e7802ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000f150a7812ULL, 0x000fe400078e7802ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x000000080f087248ULL, 0x000fe20007fe0000ULL,
0x0000001010117824ULL, 0x000fe200078e0211ULL, 0x0000000709077812ULL, 0x000fe200078ec0ffULL,
0x000000010f107824ULL, 0x000fe200078e0216ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000001013147824ULL, 0x000fe200078e020aULL, 0x0000000f070a7812ULL, 0x000fe200078e7802ULL,
0x0000000108087824ULL, 0x000fe200078e0a0fULL, 0x0000000710157812ULL, 0x000fc400078ec0ffULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x000000080c00720cULL, 0x080fe20003f26070ULL,
0x00000010090c7824ULL, 0x000fe200078e020aULL, 0x0000000f15157812ULL, 0x000fe200078e7802ULL,
0x00000040000a7824ULL, 0x000fe200078e0209ULL, 0x000000081200720cULL, 0x080fe40003f06070ULL,
0x000000080d00720cULL, 0x000fe20003f46070ULL, 0x0000001010187824ULL, 0x000fe400078e0215ULL,
0x000000020a107836ULL, 0x000fc40000000000ULL, 0x000000040a127836ULL, 0x000fe40000000000ULL,
0x0000000805077c24ULL, 0x008fe2000f8e02ffULL, 0x00008a0000087ab9ULL, 0x000fc60000000a00ULL,
0x0000004007077824ULL, 0x000fca00078e00ffULL, 0x0000000a07197210ULL, 0x000fe20007f7e0ffULL,
0x000000060a0a7836ULL, 0x000fe20000000000ULL, 0x0000001007107210ULL, 0x000fc60007f9e0ffULL,
0x000000ffff1a7224ULL, 0x000fe200018e06ffULL, 0x0000000819177c11ULL, 0x040fe2000f8640ffULL,
0x000000ffff157224ULL, 0x000fe200020e06ffULL, 0x0000000810137c11ULL, 0x040fe4000f8840ffULL,
0x0000000919197c11ULL, 0x000fe400098f441aULL, 0x0000001207127210ULL, 0x000fe40007f7e0ffULL,
0x0000000a070a7210ULL, 0x000fe40007fbe0ffULL, 0x0000000910157c11ULL, 0x000fe2000a0f4415ULL,
0x000000ffff097224ULL, 0x000fe200018e06ffULL, 0x00000008120d7c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff077224ULL, 0x000fe200028e06ffULL, 0x000000f0061a7812ULL, 0x000fc400078ec0ffULL,
0x000000080a107c11ULL, 0x000fe4000f8a40ffULL, 0x0000000912127c11ULL, 0x000fe4000a0f4409ULL,
0x000000081600720cULL, 0x000fe40003f66070ULL, 0x000000171a067210ULL, 0x000fe40007f9e0ffULL,
0x000000090a0a7c11ULL, 0x000fe4000a8f4407ULL, 0x0000001a13087210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff077224ULL, 0x000fe200020e0619ULL, 0x000000040c137c11ULL, 0x000fc4000f8e20ffULL,
0x0000001a0d0c7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff097224ULL, 0x000fe200028e0615ULL,
0x0000001a10107210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006137faeULL, 0x0003e2000c901c4cULL, 0x0000000411157c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e0612ULL, 0x0000000414177c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff117224ULL, 0x000fe200028e060aULL, 0x0000000418197c11ULL, 0x000fe2000f8e20ffULL,
0x0000000008157faeULL, 0x000fe2000d101c4cULL, 0x00000000001a7805ULL, 0x000fc6000001ff00ULL,
0x000000000c177faeULL, 0x000fe2000c101c4cULL, 0x000000070e007c0cULL, 0x000fe2000bf06070ULL,
0xff317217ff067424ULL, 0x002fe400078e00ffULL, 0x0000000010197faeULL, 0x0003e2000d901c4cULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000187805ULL, 0x002fe2000001ff00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0106a824ff6c79a7ULL, 0x0006a2000850000bULL,
0x0000000000167805ULL, 0x000fc4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0106b824ff2479a7ULL, 0x000e62000850000bULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000b0f0c7c36ULL, 0x000fe20008000000ULL,
0x000000a8000c0947ULL, 0x008fec0003800000ULL, 0x00009000ff067b82ULL, 0x000ee20000000800ULL,
0x000000020b0b7824ULL, 0x000fe200078e00ffULL, 0x000106b80b087890ULL, 0x000fe2000fffe03fULL,
0x0000000449097824ULL, 0x000fe400078e00ffULL, 0x000000ffff377224ULL, 0x000fe400078e00ffULL,
0x00000002090d7836ULL, 0x000fe40000000000ULL, 0x000000060b0b7224ULL, 0x008fe400078e0206ULL,
0xff317217ff067424ULL, 0x000fce00078e00ffULL, 0x000001000e087824ULL, 0x000fca00078e00ffULL,
0x0000000e08007c0cULL, 0x000fda000bf06070ULL, 0x000000a400d40947ULL, 0x000fea0003800000ULL,
0x00000025ff0075a7ULL, 0x002e620008020048ULL, 0x000000010e267836ULL, 0x000fe20000000000ULL,
0x0000000304277812ULL, 0x000fe200078ec0ffULL, 0x00008400000f7ab9ULL, 0x000fe20000000800ULL,
0x00000004ff527819ULL, 0x000fe40000011602ULL, 0x000000200e087811ULL, 0x000fe400078e40ffULL,
0x0000000726007c0cULL, 0x000fe2000bf06070ULL, 0x000000010f267824ULL, 0x000fe200078e0252ULL,
0x000000032700780cULL, 0x000fc40003f45270ULL, 0x0000000e08277c48ULL, 0x000fe4000ffe0000ULL,
0xfffffffd035d7811ULL, 0x000fe400078e10ffULL, 0x00000007262b7812ULL, 0x000fe200078ec0ffULL,
0x0000000127277824ULL, 0x000fe200078e0a08ULL, 0x000000015d297807ULL, 0x000fe20005000000ULL,
0x0000000000081947ULL, 0x002fec0003800000ULL, 0x0106b825ff0075a7ULL, 0x000e64000802014bULL,
0x0000011c00789947ULL, 0x002fea0003800000ULL, 0x00000020005f7811ULL, 0x000fe200078e30ffULL,
0x0000000f05057c24ULL, 0x000fe2000f8e02ffULL, 0x0000000f2b2b7812ULL, 0x000fe200078e7802ULL,
0x00000004524e7836ULL, 0x000fe20000000000ULL, 0x00008a0000107ab9ULL, 0x000fe20000000a00ULL,
0x00000040052a7824ULL, 0x000fe200078e00ffULL, 0x0000e0000b097890ULL, 0x000fe2000fffe03fULL,
0x0000000126657824ULL, 0x000fe200078e025fULL, 0x000106b00b0a7890ULL, 0x000fe2000fffe03fULL,
0x0000000252507836ULL, 0x040fe40000000000ULL, 0x00000006524c7836ULL, 0x000fe20000000000ULL,
0x000000652a397210ULL, 0x000fe20007f3e0ffULL, 0x0000001026697824ULL, 0x000fc400078e022bULL,
0x000000010f267824ULL, 0x040fe400078e024eULL, 0x000000010f247824ULL, 0x000fe200078e0250ULL,
0x0000000969647c11ULL, 0x000fe2000f8e20ffULL, 0x000000010f287824ULL, 0x000fe200078e024cULL,
0x0000000726257812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00000010392b7c11ULL, 0x040fe2000f8240ffULL, 0x0000000104047824ULL, 0x000fe200078e0229ULL,
0x0000000724057812ULL, 0x040fe200078ec0ffULL, 0x0000000124637824ULL, 0x100fe200078e025fULL,
0x0000000728297812ULL, 0x000fe200078ec0ffULL, 0x0000000126617824ULL, 0x100fe200078e025fULL,
0x0000001139397c11ULL, 0x000fe200088f4408ULL, 0x00000001285f7824ULL, 0x000fe200078e025fULL,
0x0000000f25257812ULL, 0x000fe200078e7802ULL, 0x00000010025c7824ULL, 0x000fe200078e00ffULL,
0x0000000f05057812ULL, 0x000fc400078e7802ULL, 0x0000000f29297812ULL, 0x000fe200078e7802ULL,
0x00000010264f7824ULL, 0x000fe200078e0225ULL, 0x0000000604007c0cULL, 0x000fe2000bf26070ULL,
0x0000001024517824ULL, 0x000fe200078e0205ULL, 0x000000632a387210ULL, 0x000fe20007f5e0ffULL,
0x00000010284d7824ULL, 0x000fe200078e0229ULL, 0x000000612a3a7210ULL, 0x000fe40007f7e0ffULL,
0x0000002027087807ULL, 0x000fe20000000000ULL, 0x000000ffff257224ULL, 0x000fe200010e06ffULL,
0x0000001038297c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0x000000103a3b7c11ULL, 0x000fc4000f8640ffULL, 0x000000080f087248ULL, 0x000fe40007fe0000ULL,
0x0000001138387c11ULL, 0x000fe400090f4425ULL, 0x000000113a3a7c11ULL, 0x000fe200098f4405ULL,
0x0000000108057824ULL, 0x000fe200078e0a0fULL, 0x000000f05c4a7812ULL, 0x000fe200078ec0ffULL,
0x00008c00ff249b82ULL, 0x000e620000000a00ULL, 0x0000005f2a2a7210ULL, 0x000fe40007f5e0ffULL,
0x0000004a2b267210ULL, 0x000fc40007f9e0ffULL, 0x000000055000720cULL, 0x080fe20003f66070ULL,
0x000000ffff2b7224ULL, 0x000fe200010e06ffULL, 0x000000055200720cULL, 0x080fe20003f46070ULL,
0x000000ffff277224ULL, 0x000fe200020e0639ULL, 0x0000004a29287210ULL, 0x000fe40007fbe0ffULL,
0x000000102a397c11ULL, 0x000fe4000f8840ffULL, 0x0000000951627c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff297224ULL, 0x000fe200028e0638ULL, 0x000000054e00720cULL, 0x000fc40003fc6070ULL,
0x000000054c00720cULL, 0x000fe20003fa6070ULL, 0x0000000104059824ULL, 0x000fe200078e020bULL,
0x000000112a087c11ULL, 0x000fe2000a0f442bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026647faeULL, 0x0007e2000d101c4cULL, 0x0000004a3b2a7210ULL, 0x000fe40007f5e0ffULL,
0x000000094f607c11ULL, 0x000fe2000f8e20ffULL, 0x0000000028627faeULL, 0x0009e2000d901c4cULL,
0x0000004a39387210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200010e063aULL,
0x000000094d5e7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000405249825ULL, 0x002fc600078e0024ULL,
0x000000002a607faeULL, 0x0009e2000f101c4cULL, 0x000000ffff397224ULL, 0x000fe400018e0608ULL,
0xffffffffff057424ULL, 0x000fc600078e00ffULL, 0x00000000385e7faeULL, 0x0009e2000e901c4cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000c24059981ULL, 0x000962000c1e1900ULL,
0x00000001ff087424ULL, 0x000fc600078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a4aULL,
0x0000000000007918ULL, 0x008fc60000000000ULL, 0x0106b008ff7279a7ULL, 0x000262000850000bULL,
0x00000001ff267819ULL, 0x000fe40000011602ULL, 0x000000705c5c7812ULL, 0x000fe400078ec0ffULL,
0x0000000c26277812ULL, 0x000fe200078ec0ffULL, 0x0000006dff0075a7ULL, 0x0042660008020045ULL,
0x0000000b275c7c10ULL, 0x000fe2000fffe05cULL, 0x010608080f2479a7ULL, 0x010ea4000850000bULL,
0x010608250f0075a7ULL, 0x004ea4000804014bULL, 0x000001180028a947ULL, 0x006fea0003800000ULL,
0x010000005c257984ULL, 0x000e620000000800ULL, 0x0000000802277812ULL, 0x040fe200078ec0ffULL,
0x00000001ff297424ULL, 0x000fe200078e00ffULL, 0x00000009026f7211ULL, 0x000fe200078fe0ffULL,
0x010200005c6a7984ULL, 0x0004a20000000800ULL, 0x00000007272a7812ULL, 0x000fe400078ec802ULL,
0x0000000727287812ULL, 0x000fe400078ef802ULL, 0x0000006f2a6f7212ULL, 0x000fca00078e3cffULL,
0x0000001028537824ULL, 0x000fca00078e026fULL, 0x00000004535b7c11ULL, 0x000fe4000f8e20ffULL,
0x000000062500720bULL, 0x002fda0003f5d000ULL, 0x0000000000247806ULL, 0x000fc800010e0100ULL,
0x0000ffff242b7812ULL, 0x000fda000784c0ffULL, 0x0000000000d4a947ULL, 0x004fea0003800000ULL,
0x000000062500720bULL, 0x000fe40003f54000ULL, 0x0000002506397209ULL, 0x000fe40007810000ULL,
0x00000002ff267819ULL, 0x000fc60000011602ULL, 0x8000003906247221ULL, 0x100fe40000010000ULL,
0x0000000826277836ULL, 0x000fe40000000000ULL, 0x3fb8aa3b24247820ULL, 0x000fe40000410000ULL,
0x0000000000067806ULL, 0x000fe400010e0100ULL, 0x000000ff4900720cULL, 0x000fe40003f45270ULL,
0x0000ffff06067812ULL, 0x000fe200078e3cffULL, 0x0000002400247308ULL, 0x000e660000000800ULL,
0x000000062bff7212ULL, 0x000fe2000786c0ffULL, 0x000000ffff067224ULL, 0x000fc600078e0039ULL,
0x00000001ff297807ULL, 0x000fc60001800000ULL, 0x010400395c00a388ULL, 0x000fe80000000800ULL,
0x00001f2724277589ULL, 0x002e6400000e0000ULL, 0x8000003925253221ULL, 0x000fe20000010000ULL,
0x0000002407077220ULL, 0x000fe20000410000ULL, 0x00001f2624267589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b25253820ULL, 0x000fc80000410000ULL, 0x00000025000a3308ULL, 0x000ee20000000800ULL,
0x0000002737377220ULL, 0x082fe20000410000ULL, 0x0000002736367220ULL, 0x080fe20000410000ULL,
0x0000002723237220ULL, 0x080fe20000410000ULL, 0x0000002722227220ULL, 0x080fe20000410000ULL,
0x000000271f1f7220ULL, 0x080fe20000410000ULL, 0x000000271e1e7220ULL, 0x080fe20000410000ULL,
0x000000271b1b7220ULL, 0x080fe20000410000ULL, 0x000000271a1a7220ULL, 0x080fe20000410000ULL,
0x0000002717177220ULL, 0x080fe20000410000ULL, 0x0000002716167220ULL, 0x080fe20000410000ULL,
0x0000002733337220ULL, 0x080fe20000410000ULL, 0x0000002732327220ULL, 0x080fe20000410000ULL,
0x000000272f2f7220ULL, 0x080fe20000410000ULL, 0x000000272e2e7220ULL, 0x080fe20000410000ULL,
0x0000002713137220ULL, 0x080fe20000410000ULL, 0x0000002712127220ULL, 0x000fe20000410000ULL,
0x0000002635357220ULL, 0x084fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002621217220ULL, 0x080fe20000410000ULL, 0x0000002620207220ULL, 0x080fe20000410000ULL,
0x000000261d1d7220ULL, 0x080fe20000410000ULL, 0x000000261c1c7220ULL, 0x080fe20000410000ULL,
0x0000002619197220ULL, 0x080fe20000410000ULL, 0x0000002618187220ULL, 0x080fe20000410000ULL,
0x0000002615157220ULL, 0x080fe20000410000ULL, 0x0000002614147220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x000000262c2c7220ULL, 0x080fe20000410000ULL,
0x0000002611117220ULL, 0x080fe20000410000ULL, 0x0000002610107220ULL, 0x000fe20000410000ULL,
0x0000000a6a6a3220ULL, 0x008fce0000410000ULL, 0x0000000000081947ULL, 0x000fea0003800000ULL,
0x0106a86dff0075a7ULL, 0x000e64000802014bULL, 0x0000011400289947ULL, 0x002fea0003800000ULL,
0x000000005b44783bULL, 0x000e620000004200ULL, 0x0000000702677812ULL, 0x040fe400078ec0ffULL,
0x0000000d023d7211ULL, 0x000fe400078fe0ffULL, 0x0000000867677812ULL, 0x000fe400078ef802ULL,
0x0000003d2a3d7212ULL, 0x000fe400078e3cffULL, 0x0000000752247812ULL, 0x000fe400078e7867ULL,
0x00000002ff487819ULL, 0x000fe20000011602ULL, 0x00000010284b7824ULL, 0x040fe200078e023dULL,
0x0000010028667811ULL, 0x000fe200078e20ffULL, 0x0000000867247824ULL, 0x000fe200078e0224ULL,
0x0000000aff71723eULL, 0x000fc400000010ffULL, 0x0000991029297816ULL, 0x000fe200000000ffULL,
0x000000016f6f7824ULL, 0x100fe200078e0266ULL, 0x0000000b24577c11ULL, 0x000fe2000f8e20ffULL,
0x000000013d667824ULL, 0x000fe200078e0266ULL, 0x0000541071717816ULL, 0x000fe40000000071ULL,
0x000000044b5a7c11ULL, 0x000fe2000f8e20ffULL, 0x00a000005724783bULL, 0x000fe20000000200ULL,
0x0000000466587c11ULL, 0x000fe4000f8e20ffULL, 0x000000046f597c11ULL, 0x000fe2000f8e20ffULL,
0x00001f48716b7589ULL, 0x000ea800000e0000ULL, 0x000000005a40783bULL, 0x000ee20000004200ULL,
0x00000018ff387819ULL, 0x002fe20000011444ULL, 0x00000100442a7824ULL, 0x040fe200078e00ffULL,
0x00008880443c7816ULL, 0x040fe200000000ffULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x00008880453e7816ULL, 0x040fe200000000ffULL, 0x0000010045287824ULL, 0x040fe200078e00ffULL,
0x0000003800387306ULL, 0x000fe20000202400ULL, 0x00000018ff397819ULL, 0x000fe20000011445ULL,
0x0001000045457824ULL, 0x000fe200078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe20000011444ULL,
0x0000000848447836ULL, 0x000fe20000000000ULL, 0x00000018ff557819ULL, 0x000fe20000011428ULL,
0x000000ffff287224ULL, 0x000fe200078e0029ULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000003e003e7306ULL, 0x000fe20000202400ULL, 0x00001f4471567589ULL, 0x000e6200000e0000ULL,
0x00000018ff3a7819ULL, 0x000fe20000011445ULL, 0x0000010046687824ULL, 0x000fe200078e00ffULL,
0x000000ff2800720cULL, 0x000fc40003f25270ULL, 0x0000888046457816ULL, 0x000fe400000000ffULL,
0x0000003b003b7306ULL, 0x000f220000202400ULL, 0x00000018ff687819ULL, 0x000fe40000011468ULL,
0x00000018ff767819ULL, 0x000fe40000011446ULL, 0x00000018ff757819ULL, 0x000fc60000011447ULL,
0x0000005500557306ULL, 0x000e620000202400ULL, 0x0000006b24249232ULL, 0x084fe20000200000ULL,
0x00000018ff707819ULL, 0x008fe20000011441ULL, 0x0000006b26269232ULL, 0x000fe20000200000ULL,
0x00000018ff747819ULL, 0x000fe40000011440ULL, 0x00000018ff6d7819ULL, 0x000fe40000011442ULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x000054103b387816ULL, 0x010fe20000000038ULL,
0x00000100473b7824ULL, 0x000fc400078e00ffULL, 0x0000005625259232ULL, 0x082fe20000200000ULL,
0x00000018ff547819ULL, 0x000fe20000011443ULL, 0x0000005627279232ULL, 0x000fe20000200000ULL,
0x0000888042777816ULL, 0x000fe200000000ffULL, 0x0000002a003f7306ULL, 0x0002a20000202400ULL,
0x000054103e3d7816ULL, 0x000fe40000000055ULL, 0x0000888047557816ULL, 0x040fe200000000ffULL,
0x0001000047477824ULL, 0x000fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fc6000001143bULL,
0x0000003900397306ULL, 0x000fe20000202400ULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x000000005928783bULL, 0x002e620000004200ULL, 0x000054103c3c7816ULL, 0x004fca000000003fULL,
0x0000003a003a7306ULL, 0x000ea40000202400ULL, 0x0000003c243c723cULL, 0x000fe20000041810ULL,
0x000000005810783bULL, 0x000eea0000004200ULL, 0x0000004500457306ULL, 0x000fe20000202400ULL,
0x000054103a397816ULL, 0x004fce0000000039ULL, 0x0000006800687306ULL, 0x000ea20000202400ULL,
0x000000382438723cULL, 0x000fee000004182cULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x00008880402e7816ULL, 0x000fe400000000ffULL, 0x00005410452c7816ULL, 0x004fca0000000068ULL,
0x0000007800787306ULL, 0x000ea20000202400ULL, 0x0000888041457816ULL, 0x000fe400000000ffULL,
0x00000018ff6e7819ULL, 0x002fe40000011428ULL, 0x00000018ff6c7819ULL, 0x000fe40000011429ULL,
0x00000018ff687819ULL, 0x000fe2000001142aULL, 0x0000007600767306ULL, 0x000fe20000202400ULL,
0x00005410552d7816ULL, 0x004fce0000000078ULL, 0x0000007500757306ULL, 0x000fe20000202400ULL,
0x00000018ff2f7819ULL, 0x008fe40000011410ULL, 0x00000018ff557819ULL, 0x000fe4000001142bULL,
0x0000888010797816ULL, 0x000fe200000000ffULL, 0x0000002c2430723cULL, 0x000fe40000041830ULL,
0x0000004700787306ULL, 0x0003ea0000202400ULL, 0x00010000462c7824ULL, 0x000fc600078e00ffULL,
0x0000002f00467306ULL, 0x000fe20000202400ULL, 0x00000018ff477819ULL, 0x002fe40000011411ULL,
0x00000018ff2c7819ULL, 0x000fca000001142cULL, 0x0000002c002d7306ULL, 0x000e700000202400ULL,
0x0000002e002e7306ULL, 0x000fe20000202400ULL, 0x000054102d2c7816ULL, 0x002fe20000000076ULL,
0x00000100402d7824ULL, 0x000fcc00078e00ffULL, 0x0000007400747306ULL, 0x000fe20000202400ULL,
0x00000018ff2f7819ULL, 0x000fe4000001142dULL, 0x00005410782d7816ULL, 0x000fca0000000075ULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x00000018ff787819ULL, 0x000fe20000011413ULL,
0x0000002c2414723cULL, 0x000fec0000041814ULL, 0x0000002f002f7306ULL, 0x000e620000202400ULL,
0x00000100412d7824ULL, 0x040fe400078e00ffULL, 0x000000ffff2c7224ULL, 0x000fe200078e0045ULL,
0x00000018ff457819ULL, 0x000fe20000011412ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff2d7819ULL, 0x000fc4000001142dULL, 0x0000002c00757306ULL, 0x0003f00000202400ULL,
0x0000002d00767306ULL, 0x000ea20000202400ULL, 0x000054102e2c7816ULL, 0x002fe2000000002fULL,
0x00010000402e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000007800407306ULL, 0x000fe20000202400ULL, 0x00005410752d7816ULL, 0x004fce0000000076ULL,
0x0000002e002f7306ULL, 0x0003e20000202400ULL, 0x0000888043757816ULL, 0x040fe200000000ffULL,
0x0000002c2418723cULL, 0x000fec0000041818ULL, 0x0000007700777306ULL, 0x000fe20000202400ULL,
0x00000100432e7824ULL, 0x042fe400078e00ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe20000011441ULL, 0x00000100422c7824ULL, 0x040fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe2000001142eULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x0000007500757306ULL, 0x000fe40000202400ULL, 0x00000018ff2c7819ULL, 0x000fc4000001142cULL,
0x00000018ff2e7819ULL, 0x000fe40000011442ULL, 0x0000888028427816ULL, 0x000fe400000000ffULL,
0x0000002d002d7306ULL, 0x000e700000202400ULL, 0x0000002c00787306ULL, 0x0004e20000202400ULL,
0x000054102d2d7816ULL, 0x002fce0000000070ULL, 0x0000007600767306ULL, 0x000fe20000202400ULL,
0x000054102f2c7816ULL, 0x004fe40000000074ULL, 0x00000018ff2f7819ULL, 0x000fe40000011443ULL,
0x0000888029747816ULL, 0x000fe400000000ffULL, 0x000088802a707816ULL, 0x000fe200000000ffULL,
0x0000006d006d7306ULL, 0x000fe20000202400ULL, 0x0000002c241c723cULL, 0x000fe2000004181cULL,
0x000088802b437816ULL, 0x000fcc00000000ffULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x00000100282c7824ULL, 0x040fe400078e00ffULL, 0x00000100292d7824ULL, 0x040fe400078e00ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x0000002e002e7306ULL, 0x000fe20000202400ULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x00000018ff287819ULL, 0x000fc40000011428ULL,
0x00000018ff297819ULL, 0x000fc60000011429ULL, 0x0000002f002f7306ULL, 0x000e700000202400ULL,
0x0000002c00417306ULL, 0x0007f00000202400ULL, 0x00000029007b7306ULL, 0x0003e20000202400ULL,
0x00005410772c7816ULL, 0x008fce0000000078ULL, 0x0000002d00777306ULL, 0x0005e20000202400ULL,
0x000054102f297816ULL, 0x002fce0000000054ULL, 0x0000004200427306ULL, 0x000e620000202400ULL,
0x00005410752d7816ULL, 0x004fce0000000076ULL, 0x0000002800757306ULL, 0x0005e20000202400ULL,
0x0000002c2420723cULL, 0x000fee0000041820ULL, 0x000001002a2c7824ULL, 0x000fe200078e00ffULL,
0x000054102e287816ULL, 0x004fe2000000006dULL, 0x000001002b2d7824ULL, 0x040fe200078e00ffULL,
0x0000007400747306ULL, 0x000ea20000202400ULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe2000001142dULL, 0x000000282424723cULL, 0x000fe20000041834ULL,
0x00000018ff2a7819ULL, 0x000fc4000001142aULL, 0x0000002c006d7306ULL, 0x0007e20000202400ULL,
0x00000018ff2b7819ULL, 0x000fc6000001142bULL, 0x0000000750287812ULL, 0x000fe400078e7867ULL,
0x0000888011297816ULL, 0x000fe400000000ffULL, 0x0000006c006c7306ULL, 0x000f220000202400ULL,
0x0000000867287824ULL, 0x000fe200078e0228ULL, 0x0000888012357816ULL, 0x000fc800000000ffULL,
0x0000000b28547c11ULL, 0x000fe2000f8e20ffULL, 0x0000010010287824ULL, 0x040fe200078e00ffULL,
0x0000004300437306ULL, 0x000fe20000202400ULL, 0x0001000010107824ULL, 0x000fe400078e00ffULL,
0x00a00000542c783bULL, 0x008ee20000000200ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000007a007a7306ULL, 0x000e700000202400ULL,
0x0000002a007d7306ULL, 0x0003f00000202400ULL, 0x0000002800767306ULL, 0x0005e20000202400ULL,
0x00000100112a7824ULL, 0x002fc400078e00ffULL, 0x0001000011117824ULL, 0x000fc600078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000006e006e7306ULL, 0x000e620000202400ULL,
0x0000541042287816ULL, 0x004fe40000000041ULL, 0x00000018ff117819ULL, 0x000fca0000011411ULL,
0x0000002900417306ULL, 0x0005e20000202400ULL, 0x0000006b2c2c9232ULL, 0x088fe40000200000ULL,
0x0000006b2e2e9232ULL, 0x000fe20000200000ULL, 0x000000400e6b7811ULL, 0x000fe200078e40ffULL,
0x000000562d2d9232ULL, 0x000fc60000200000ULL, 0x0000002b00787306ULL, 0x000fe20000202400ULL,
0x0000541074297816ULL, 0x004fe20000000077ULL, 0x000000562f2f9232ULL, 0x000fcc0000200000ULL,
0x0000002a00427306ULL, 0x0005f00000202400ULL, 0x0000001100367306ULL, 0x0009e20000202400ULL,
0x000000282c28723cULL, 0x004fee000004183cULL, 0x00000035003c7306ULL, 0x0005e20000202400ULL,
0x000054107b117816ULL, 0x010fe2000000006cULL, 0x00010000133f7824ULL, 0x040fe200078e00ffULL,
0x00008880133e7816ULL, 0x000fe200000000ffULL, 0x00000100123d7824ULL, 0x000fc800078e00ffULL,
0x0000001000377306ULL, 0x0003e20000202400ULL, 0x0000541043357816ULL, 0x004fe2000000007aULL,
0x0000010013437824ULL, 0x000fe200078e00ffULL, 0x0106b808ff7a79a7ULL, 0x000ea2000850000bULL,
0x00000018ff3d7819ULL, 0x000fc6000001143dULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x0000007000707306ULL, 0x000ee20000202400ULL, 0x0000541075107816ULL, 0x002fe2000000006eULL,
0x0000000f056e7c24ULL, 0x020fe2000f8e02ffULL, 0x00000018ff757819ULL, 0x000fc6000001143fULL,
0x000000406e6e7824ULL, 0x000fe400078e00ffULL, 0x0000005500557306ULL, 0x000e620000202400ULL,
0x000000102c38723cULL, 0x000fe20000041838ULL, 0x0000541070347816ULL, 0x008fcc000000006dULL,
0x0000006800687306ULL, 0x000ee20000202400ULL, 0x0000000e6b107c48ULL, 0x000fe2000ffe0000ULL,
0x0001000012117824ULL, 0x000fe200078e00ffULL, 0x0000007bff0075a7ULL, 0x004ea60008080048ULL,
0x0000000110107824ULL, 0x000fe200078e0a6bULL, 0x0000541078137816ULL, 0x002fe20000000055ULL,
0x0000007900797306ULL, 0x000e620000202400ULL, 0x000000342c30723cULL, 0x000fe20000041830ULL,
0x0000000f02557211ULL, 0x000fc400078fe0ffULL, 0x0000002010567807ULL, 0x000fe40000000000ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x000000560f567248ULL, 0x000fe20007fe0000ULL,
0x0000004700477306ULL, 0x000fe20000202400ULL, 0x0000000202347811ULL, 0x000fe400078fe0ffULL,
0x000054107d127816ULL, 0x008fe20000000068ULL, 0x0000000156357824ULL, 0x000fe400078e0a0fULL,
0x0000004000567824ULL, 0x000fe200078e0255ULL, 0x0000541079107816ULL, 0x002fe20000000076ULL,
0x000000010f557824ULL, 0x000fe200078e0234ULL, 0x0000003d003d7306ULL, 0x000fe20000202400ULL,
0x000000353400720cULL, 0x000fe20003f46070ULL, 0x000000122c14723cULL, 0x000fe20000041814ULL,
0x0000004000557824ULL, 0x000fe200078e0255ULL, 0x000000566e347210ULL, 0x000fc80007f7e0ffULL,
0x0000003e003e7306ULL, 0x000fe20000202400ULL, 0x000000ffff137224ULL, 0x000fce00018e06ffULL,
0x00000043006d7306ULL, 0x0002f00000202400ULL, 0x0000001100687306ULL, 0x0009e20000202400ULL,
0x0000001034437c11ULL, 0x002fc8000f8640ffULL, 0x0000001134347c11ULL, 0x000fe400098f4413ULL,
0x000054103e137816ULL, 0x008fe2000000006dULL, 0x0000004500457306ULL, 0x000e620000202400ULL,
0x0000541041117816ULL, 0x010fe40000000042ULL, 0x000000556e417210ULL, 0x000fe40007fbe0ffULL,
0x000000355200720cULL, 0x000fc60003f66070ULL, 0x0000007500757306ULL, 0x000ee20000202400ULL,
0x000000ffff127224ULL, 0x000fe200028e06ffULL, 0x000000102c18723cULL, 0x000fe20000041818ULL,
0x00000010413f7c11ULL, 0x000fc8000f8a40ffULL, 0x0000001141417c11ULL, 0x000fe4000a8f4412ULL,
0x0000541037107816ULL, 0x000fe40000000046ULL, 0x0000541036117816ULL, 0x000fe40000000047ULL,
0x000054103c127816ULL, 0x000fe4000000003dULL, 0x00000004023c7811ULL, 0x040fe400078fe0ffULL,
0x0000000602367811ULL, 0x000fe200078fe0ffULL, 0x000000102c1c723cULL, 0x000fe2000004181cULL,
0x0000000469467c11ULL, 0x000fe2000f8e20ffULL, 0x000000010f3d7824ULL, 0x000fc400078e023cULL,
0x000000010f377824ULL, 0x000fe400078e0236ULL, 0x000000122c20723cULL, 0x000fe20000041820ULL,
0x0000541068107816ULL, 0x002fe20000000045ULL, 0x0000004000687824ULL, 0x000fe200078e023dULL,
0x0000541075117816ULL, 0x008fc80000000040ULL, 0x0000004a43127210ULL, 0x000fc60007fbe0ffULL,
0x000000102c24723cULL, 0x000fe40000041824ULL, 0x000000ffff137224ULL, 0x000fe200028e0634ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000084947ULL, 0x004fde0003800000ULL,
0x0106b87bff0075a7ULL, 0x000e64000808014bULL, 0x0000010000ccc947ULL, 0x002fea0003800000ULL,
0x000000686e347210ULL, 0x000fe20007f9e0ffULL, 0x0000004000697824ULL, 0x000fe200078e0237ULL,
0x0000004a3f107210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012467faeULL, 0x0003e2000d901c4cULL, 0x000000353c00720cULL, 0x000fe20003f66070ULL,
0x000000ffff117224ULL, 0x000fe200020e06ffULL, 0x000000696e2d7210ULL, 0x000fe40007fde0ffULL,
0x0000001034377c11ULL, 0x040fe4000f8840ffULL, 0x0000000451517c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2e7224ULL, 0x000fe200030e06ffULL, 0x0000001134347c11ULL, 0x000fe2000a0f4411ULL,
0x000000ffff117224ULL, 0x000fe200028e0641ULL, 0x000000102d2f7c11ULL, 0x000fc4000f8840ffULL,
0x000000353600720cULL, 0x000fe40003fa6070ULL, 0x0000004a372c7210ULL, 0x000fe20007fde0ffULL,
0x0000000010517faeULL, 0x0005e2000d101c4cULL, 0x000000112d137c11ULL, 0x002fe4000a0f442eULL,
0x0000004a2f127210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200030e0634ULL,
0x000000044f4f7c11ULL, 0x000fe4000f8e20ffULL, 0x000000044d4d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff137224ULL, 0x000fc400020e0613ULL, 0x000000002c4f7faeULL, 0x0005e8000d901c4cULL,
0x00000000124d7faeULL, 0x0005e2000e901c4cULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0106a808ff6c79a7ULL, 0x000262000850000bULL, 0x0000000953537c11ULL, 0x000fe2000f8e20ffULL,
0x00000073ff0075a7ULL, 0x000ee4000804004aULL, 0x0000000000082947ULL, 0x00afea0003800000ULL,
0x0106b073ff0075a7ULL, 0x000e64000804014bULL, 0x000001000058a947ULL, 0x002fea0003800000ULL,
0x000000005340783bULL, 0x000e620000004200ULL, 0x000000074e107812ULL, 0x004fe200078e7867ULL,
0x000000076a077221ULL, 0x000fe20000010000ULL, 0x000000094b4b7c11ULL, 0x000fe2000f8e20ffULL,
0x00001f4871737589ULL, 0x000fe200000e0000ULL, 0x000000096f477c11ULL, 0x000fe2000f8e20ffULL,
0x0000000867107824ULL, 0x000fe200078e0210ULL, 0x0000000966667c11ULL, 0x000fe2000f8e20ffULL,
0x000000004b3c783bULL, 0x000fe60000004200ULL, 0x0000000b10457c11ULL, 0x000fca000f8e20ffULL,
0x00a000004534783bULL, 0x000ea20000000200ULL, 0x0000010040117824ULL, 0x042fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe20000011440ULL, 0x00000100412c7824ULL, 0x040fe200078e00ffULL,
0x0000888040107816ULL, 0x040fe200000000ffULL, 0x0001000040127824ULL, 0x000fe200078e00ffULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x00001f4471407589ULL, 0x0002e200000e0000ULL,
0x0000888041137816ULL, 0x000fe200000000ffULL, 0x0000007700777306ULL, 0x000fe20000202400ULL,
0x00000018ff2c7819ULL, 0x000fc4000001142cULL, 0x00000018ff727819ULL, 0x000fe20000011441ULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x00008880426f7816ULL, 0x000fe200000000ffULL, 0x0000001000107306ULL, 0x000fe20000202400ULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x0000007334349232ULL, 0x084fe20000200000ULL,
0x00000018ff767819ULL, 0x000fe20000011442ULL, 0x0000007336369232ULL, 0x000fe20000200000ULL,
0x00000018ff707819ULL, 0x000fc40000011443ULL, 0x00000018ff757819ULL, 0x000fe2000001143cULL,
0x0000001100117306ULL, 0x000ea20000202400ULL, 0x00000018ff747819ULL, 0x000fe4000001143dULL,
0x00000018ff717819ULL, 0x002fe2000001143fULL, 0x0000004035359232ULL, 0x008fc80000200000ULL,
0x0000001300137306ULL, 0x000fe20000202400ULL, 0x0000004037379232ULL, 0x000fe20000200000ULL,
0x0000541010107816ULL, 0x004fcc0000000011ULL, 0x0000002c002c7306ULL, 0x000e700000202400ULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x0000541013117816ULL, 0x002fce000000002cULL,
0x0000001200787306ULL, 0x0002a20000202400ULL, 0x00000000472c783bULL, 0x000eee0000004200ULL,
0x0000004100417306ULL, 0x000f220000202400ULL, 0x000000103410723cULL, 0x002fee0000041828ULL,
0x0000010042297824ULL, 0x000fe200078e00ffULL, 0x0000541078287816ULL, 0x004fe20000000077ULL,
0x000000ffff2a7224ULL, 0x000fe200078e006fULL, 0x0000007600767306ULL, 0x000fe20000202400ULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fc40000011429ULL,
0x0000541041297816ULL, 0x010fe40000000072ULL, 0x0000888043417816ULL, 0x040fe400000000ffULL,
0x0000002a002a7306ULL, 0x000fe20000202400ULL, 0x00000018ff727819ULL, 0x000fe4000001143eULL,
0x000000283438723cULL, 0x000fea0000041838ULL, 0x0000002b002b7306ULL, 0x000e640000202400ULL,
0x0000010043297824ULL, 0x000fc400078e00ffULL, 0x000000ffff287224ULL, 0x000fe400078e0041ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x00000028006f7306ULL, 0x0003e20000202400ULL, 0x00000018ff417819ULL, 0x008fce000001142cULL,
0x0000002900787306ULL, 0x000ea20000202400ULL, 0x000054102a287816ULL, 0x002fe2000000002bULL,
0x000001003d2b7824ULL, 0x040fe200078e00ffULL, 0x000088803d2a7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x000054106f297816ULL, 0x004fca0000000078ULL, 0x0000007500757306ULL, 0x000fe20000202400ULL,
0x00000018ff6f7819ULL, 0x000fe40000011442ULL, 0x000088803c427816ULL, 0x000fe400000000ffULL,
0x000088802e787816ULL, 0x000fe200000000ffULL, 0x000000283430723cULL, 0x000fe40000041830ULL,
0x0000006f006f7306ULL, 0x000fea0000202400ULL, 0x00000018ff297819ULL, 0x000fe20000011443ULL,
0x000001003c287824ULL, 0x000fc400078e00ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x0000007400747306ULL, 0x000fe40000202400ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000018ff3c7819ULL, 0x000fc8000001143cULL, 0x0000002900297306ULL, 0x000e700000202400ULL,
0x0000003c003c7306ULL, 0x000ea20000202400ULL, 0x0000541029297816ULL, 0x002fce0000000070ULL,
0x0000003d003d7306ULL, 0x000e620000202400ULL, 0x00000018ff707819ULL, 0x000fe4000001142dULL,
0x000054103c3c7816ULL, 0x004fca0000000075ULL, 0x0000004200427306ULL, 0x000fe20000202400ULL,
0x000054103d3d7816ULL, 0x002fce0000000074ULL, 0x0000002800437306ULL, 0x0002a20000202400ULL,
0x0000003c341c723cULL, 0x000fee000004181cULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x000054106f287816ULL, 0x002fe40000000076ULL, 0x00000018ff6f7819ULL, 0x000fe2000001142fULL,
0x000001003e3d7824ULL, 0x000fc800078e00ffULL, 0x000000283414723cULL, 0x000fe20000041814ULL,
0x0000007100717306ULL, 0x000fe20000202400ULL, 0x00000018ff777819ULL, 0x000fe4000001143dULL,
0x000088803f3d7816ULL, 0x000fc600000000ffULL, 0x0000541042287816ULL, 0x004fe40000000043ULL,
0x000088803e437816ULL, 0x040fe200000000ffULL, 0x0000007700777306ULL, 0x000fe20000202400ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe4000001142eULL,
0x000000ffff3c7224ULL, 0x000fe400078e0043ULL, 0x000001003f437824ULL, 0x040fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000003d003d7306ULL, 0x000fe20000202400ULL,
0x000100003f3f7824ULL, 0x000fc400078e00ffULL, 0x00000018ff767819ULL, 0x000fc60000011443ULL,
0x00000018ff747819ULL, 0x000fe4000001143fULL, 0x0000003c003c7306ULL, 0x000e700000202400ULL,
0x0000007600767306ULL, 0x000ea20000202400ULL, 0x000054103c3c7816ULL, 0x002fce0000000077ULL,
0x0000002a002a7306ULL, 0x000fe20000202400ULL, 0x000088802f777816ULL, 0x000fe400000000ffULL,
0x000054103d3d7816ULL, 0x004fca0000000076ULL, 0x0000002b002b7306ULL, 0x000e640000202400ULL,
0x0000003c3420723cULL, 0x000fec0000041820ULL, 0x0000003e00757306ULL, 0x000ea20000202400ULL,
0x000000074c3c7812ULL, 0x000fe400078e7867ULL, 0x000054102a297816ULL, 0x002fca000000002bULL,
0x0000007400747306ULL, 0x000e620000202400ULL, 0x0000000867677824ULL, 0x000fe200078e023cULL,
0x000000283418723cULL, 0x000fe20000041818ULL, 0x00005410753c7816ULL, 0x004fe20000000072ULL,
0x000000006628783bULL, 0x000ea40000004200ULL, 0x0000000b67677c11ULL, 0x000fe2000f8e20ffULL,
0x000001002d727824ULL, 0x000fe200078e00ffULL, 0x0000004100417306ULL, 0x000fe20000202400ULL,
0x00005410743d7816ULL, 0x002fe40000000071ULL, 0x000088802c717816ULL, 0x000fc400000000ffULL,
0x00000018ff747819ULL, 0x000fc60000011472ULL, 0x0000007000707306ULL, 0x000fe20000202400ULL,
0x0000003c3424723cULL, 0x000fe20000041824ULL, 0x00a000006734783bULL, 0x000e6c0000000200ULL,
0x0000007100717306ULL, 0x000fe20000202400ULL, 0x000001002c3d7824ULL, 0x040fe400078e00ffULL,
0x000100002c2c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff757819ULL, 0x000fe4000001143dULL,
0x000088802d3d7816ULL, 0x040fe200000000ffULL, 0x0000007400747306ULL, 0x000fe20000202400ULL,
0x000100002d2d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fc8000001142cULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000007500767306ULL, 0x000ee20000202400ULL,
0x00000018ff437819ULL, 0x004fe40000011428ULL, 0x00000018ff3f7819ULL, 0x000fe40000011429ULL,
0x00000018ff3c7819ULL, 0x000fc6000001142bULL, 0x0000003d003d7306ULL, 0x000ea20000202400ULL,
0x00000018ff3e7819ULL, 0x000fce000001142aULL, 0x0000002c00727306ULL, 0x0007e20000202400ULL,
0x0000007334349232ULL, 0x082fe40000200000ULL, 0x0000007336369232ULL, 0x000fe40000200000ULL,
0x0000004035359232ULL, 0x000fc60000200000ULL, 0x0000002d00737306ULL, 0x0004620000202400ULL,
0x00005410712c7816ULL, 0x008fe20000000076ULL, 0x0000004037379232ULL, 0x000fe40000200000ULL,
0x000001002e407824ULL, 0x040fe200078e00ffULL, 0x0000000e6b007c0cULL, 0x000fe2000bf21070ULL,
0x000100002e2e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000007800787306ULL, 0x000fe20000202400ULL, 0x000054103d2d7816ULL, 0x004fe40000000074ULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x00008880283d7816ULL, 0x000fc600000000ffULL,
0x0000002c3410723cULL, 0x000fe20000041810ULL, 0x0000004000757306ULL, 0x0004ec0000202400ULL,
0x000001002f2c7824ULL, 0x040fe400078e00ffULL, 0x00000100282d7824ULL, 0x040fe200078e00ffULL,
0x0000007700777306ULL, 0x000fe20000202400ULL, 0x000100002f2f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x004fc4000001142dULL, 0x00005410732d7816ULL, 0x002fe40000000070ULL,
0x0000002c007a7306ULL, 0x0002a20000202400ULL, 0x00000018ff747819ULL, 0x000fe4000001142fULL,
0x0000888029737816ULL, 0x000fe400000000ffULL, 0x00000018ff287819ULL, 0x000fc60000011428ULL,
0x0000002e00717306ULL, 0x0009e20000202400ULL, 0x00005410722c7816ULL, 0x002fce0000000041ULL,
0x0000002800727306ULL, 0x0007e20000202400ULL, 0x0000002c342c723cULL, 0x010fee0000041838ULL,
0x0000010029387824ULL, 0x040fe200078e00ffULL, 0x0000541078287816ULL, 0x008fe20000000075ULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x0000004200427306ULL, 0x000fe20000202400ULL,
0x000001002a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fc40000011438ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x000088802a397816ULL, 0x040fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x0000002900707306ULL, 0x0005e80000202400ULL,
0x00000018ff2a7819ULL, 0x000fc8000001142aULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x0000541077297816ULL, 0x004fce000000007aULL, 0x0000007400747306ULL, 0x000e620000202400ULL,
0x000000283430723cULL, 0x000fee0000041830ULL, 0x000001002b287824ULL, 0x000fe200078e00ffULL,
0x0000003d003d7306ULL, 0x000fe80000202400ULL, 0x00000018ff287819ULL, 0x000fc40000011428ULL,
0x0000541074297816ULL, 0x002fe4000000006fULL, 0x0000004000407306ULL, 0x000e700000202400ULL,
0x0000007300737306ULL, 0x000ff00000202400ULL, 0x0000003800767306ULL, 0x0004f00000202400ULL,
0x0000002800417306ULL, 0x0009e20000202400ULL, 0x00000018ff387819ULL, 0x004fc4000001143aULL,
0x000088802b3a7816ULL, 0x040fe200000000ffULL, 0x000100002b2b7824ULL, 0x000fc800078e00ffULL,
0x0000004300437306ULL, 0x000ea20000202400ULL, 0x0000541071287816ULL, 0x010fe40000000042ULL,
0x00000018ff2b7819ULL, 0x000fca000001142bULL, 0x0000003f003f7306ULL, 0x000f220000202400ULL,
0x000000283414723cULL, 0x000fee0000041814ULL, 0x000054103d287816ULL, 0x002fe20000000040ULL,
0x0000003900397306ULL, 0x000fe20000202400ULL, 0x0000541073297816ULL, 0x008fce0000000076ULL,
0x0000003800387306ULL, 0x000e620000202400ULL, 0x000000283418723cULL, 0x000fee0000041818ULL,
0x0000003a003a7306ULL, 0x000ee20000202400ULL, 0x0000541072287816ULL, 0x004fe40000000043ULL,
0x0000541070297816ULL, 0x010fca000000003fULL, 0x0000003e003e7306ULL, 0x000fe40000202400ULL,
0x00000028341c723cULL, 0x000fec000004181cULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x0000541039287816ULL, 0x002fe40000000038ULL, 0x000054103a297816ULL, 0x008fca0000000041ULL,
0x0000002a003b7306ULL, 0x000e640000202400ULL, 0x000000283420723cULL, 0x000fec0000041820ULL,
0x0000002b002b7306ULL, 0x000ea20000202400ULL, 0x000054103b287816ULL, 0x002fe4000000003eULL,
0x000054102b297816ULL, 0x004fce000000003cULL, 0x000000283434723cULL, 0x000fe20000041824ULL,
0x0106b808ff2479a7ULL, 0x0002a2000850000bULL, 0x01068808ffff79a7ULL, 0x0003e2000850000bULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000078003c9947ULL, 0x000fde0003800000ULL,
0x0000000304057812ULL, 0x000fe200078ec0ffULL, 0x00000025ff0075a7ULL, 0x004ea20008040048ULL,
0x000000656e277210ULL, 0x000fe40007f7e0ffULL, 0x000000030500780cULL, 0x000fe40003f25270ULL,
0x000000616e387210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x000000015d057807ULL, 0x000fe40004800000ULL, 0x0000001027397c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff3d7224ULL, 0x000fe200020e06ffULL, 0x00000010383f7c11ULL, 0x000fe2000f8840ffULL,
0x0000000104047824ULL, 0x000fe200078e0205ULL, 0x000000600e057811ULL, 0x000fc400078e40ffULL,
0x0000001127297c11ULL, 0x000fe400098f4428ULL, 0x0000000604007c0cULL, 0x000fe4000bf26070ULL,
0x0000000e05267c48ULL, 0x000fe4000ffe0000ULL, 0x000000636e2a7210ULL, 0x000fe40007f7e0ffULL,
0x0000005f6e6e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000126267824ULL, 0x000fe200078e0a05ULL,
0x00000011383d7c11ULL, 0x000fe2000a0f443dULL, 0x000000ffff2b7224ULL, 0x000fe200018e06ffULL,
0x000000102a3b7c11ULL, 0x000fe2000f8640ffULL, 0x000000ffff417224ULL, 0x000fe200028e06ffULL,
0x0000002026287807ULL, 0x000fc40000000000ULL, 0x00008c00ff269b82ULL, 0x000ee20000000a00ULL,
0x000000106e437c11ULL, 0x000fe4000f8a40ffULL, 0x000000280f287248ULL, 0x000fe40007fe0000ULL,
0x0000004a39387210ULL, 0x000fe40007f9e0ffULL, 0x000000112a2b7c11ULL, 0x000fe200098f442bULL,
0x0000000128057824ULL, 0x000fe200078e0a0fULL, 0x000000116e417c11ULL, 0x000fe2000a8f4441ULL,
0x000000ffff397224ULL, 0x000fc600020e0629ULL, 0x000000055200720cULL, 0x000fe20003f66070ULL,
0x0000000000082947ULL, 0x004fd80003800000ULL, 0x0106b825ff0075a7ULL, 0x000ea4000804014bULL,
0x000000f00020a947ULL, 0x004fea0003800000ULL, 0x0000004a3b2a7210ULL, 0x000fe20007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038647faeULL, 0x0005e2000d901c4cULL,
0x0000004a3f287210ULL, 0x000fe20007fbe0ffULL, 0x0000000104259824ULL, 0x000fe200078e020bULL,
0x000000055000720cULL, 0x080fe20003f66070ULL, 0x000000ffff2b7224ULL, 0x000fe200020e062bULL,
0x000000054e00720cULL, 0x080fe20003f46070ULL, 0x000000ffff297224ULL, 0x000fe200028e063dULL,
0x000000054c00720cULL, 0x000fe20003f86070ULL, 0x0000000425269825ULL, 0x008fe200078e0026ULL,
0x0000004a43247210ULL, 0x000fc60007fbe0ffULL, 0xffffffffff057424ULL, 0x000fe400078e00ffULL,
0x000000ffff257224ULL, 0x000fe400028e0641ULL, 0x000000002a627faeULL, 0x0007e8000d901c4cULL,
0x0000000028607faeULL, 0x0007e8000d101c4cULL, 0x00000000245e7faeULL, 0x0007e2000e101c4cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000c26059981ULL, 0x000768000c1e1900ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4aULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x0106b008ff7279a7ULL, 0x0004a2000850000bULL, 0x0000006dff0075a7ULL, 0x0004a20008020045ULL,
0x010628080f2479a7ULL, 0x008ee4000850000bULL, 0x010628250f0075a7ULL, 0x008ee4000804014bULL,
0x000000ec00cca947ULL, 0x00efea0003800000ULL, 0x010080005c277984ULL, 0x000e620000000800ULL,
0x00000001ff257424ULL, 0x000fc600078e00ffULL, 0x010280005c6a7984ULL, 0x0004a20000000800ULL,
0x000000062700720bULL, 0x002fda0003f5d000ULL, 0x0000000000247806ULL, 0x000fc800010e0100ULL,
0x0000ffff24267812ULL, 0x000fda000784c0ffULL, 0x0000000000d0a947ULL, 0x004fea0003800000ULL,
0x000000062700720bULL, 0x000fe40003f54000ULL, 0x0000002706257209ULL, 0x000fca0007810000ULL,
0x8000002506247221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b24247820ULL, 0x000fe40000410000ULL,
0x0000000000067806ULL, 0x000fe400010e0100ULL, 0x0000002400297308ULL, 0x0002a20000000800ULL,
0x000000014900780cULL, 0x000fe40003f45270ULL, 0x0000ffff062b7812ULL, 0x000fc800078e3cffULL,
0x0000002b26ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff247807ULL, 0x002fc60001800000ULL,
0x010480255c00a388ULL, 0x000fe20000000800ULL, 0x0000002907077220ULL, 0x004fc60000410000ULL,
0x00001f4829067589ULL, 0x000e6400000e0000ULL, 0x8000002527273221ULL, 0x000fe40000010000ULL,
0x00001f4429267589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b27273820ULL, 0x000fc80000410000ULL,
0x00000027000a3308ULL, 0x000ee20000000800ULL, 0x0000000610107220ULL, 0x082fe20000410000ULL,
0x0000000611117220ULL, 0x080fe20000410000ULL, 0x000000062c2c7220ULL, 0x080fe20000410000ULL,
0x000000062d2d7220ULL, 0x080fe20000410000ULL, 0x0000000630307220ULL, 0x080fe20000410000ULL,
0x0000000631317220ULL, 0x080fe20000410000ULL, 0x0000000614147220ULL, 0x080fe20000410000ULL,
0x0000000615157220ULL, 0x080fe20000410000ULL, 0x0000000618187220ULL, 0x080fe20000410000ULL,
0x0000000619197220ULL, 0x080fe20000410000ULL, 0x000000061c1c7220ULL, 0x080fe20000410000ULL,
0x000000061d1d7220ULL, 0x080fe20000410000ULL, 0x0000000620207220ULL, 0x080fe20000410000ULL,
0x0000000621217220ULL, 0x080fe20000410000ULL, 0x0000000634347220ULL, 0x080fe20000410000ULL,
0x0000000635357220ULL, 0x000fe20000410000ULL, 0x000000ffff067224ULL, 0x000fc400078e0025ULL,
0x0000002612127220ULL, 0x084fe20000410000ULL, 0x0000002613137220ULL, 0x080fe20000410000ULL,
0x000000262e2e7220ULL, 0x080fe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x0000002616167220ULL, 0x080fe20000410000ULL, 0x0000002617177220ULL, 0x080fe20000410000ULL,
0x000000261a1a7220ULL, 0x080fe20000410000ULL, 0x000000261b1b7220ULL, 0x080fe20000410000ULL,
0x000000261e1e7220ULL, 0x080fe20000410000ULL, 0x000000261f1f7220ULL, 0x080fe20000410000ULL,
0x0000002622227220ULL, 0x080fe20000410000ULL, 0x0000002623237220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x000fe20000410000ULL,
0x0000761024257816ULL, 0x000fe20000000025ULL, 0x0000006a0a6a3220ULL, 0x008fce0000410000ULL,
0x0000000000081947ULL, 0x000fea0003800000ULL, 0x0106a86dff0075a7ULL, 0x000e64000802014bULL,
0x000000e800ec9947ULL, 0x002fea0003800000ULL, 0x000000005b40783bULL, 0x000e620000004200ULL,
0x0000000aff6b723eULL, 0x000fe400000010ffULL, 0x0000991025297816ULL, 0x000fe200000000ffULL,
0x00a800005738783bULL, 0x000fe20000000200ULL, 0x000054106b6b7816ULL, 0x000fe4000000006bULL,
0x000000ff2900720cULL, 0x000fe20003f65270ULL, 0x000000005a3c783bULL, 0x000fe80000004200ULL,
0x00001f486b6d7589ULL, 0x000ea800000e0000ULL, 0x00001f446b6c7589ULL, 0x000ee200000e0000ULL,
0x0000888041287816ULL, 0x002fe200000000ffULL, 0x0000010040267824ULL, 0x040fe200078e00ffULL,
0x0000888040247816ULL, 0x000fc400000000ffULL, 0x00000018ff767819ULL, 0x000fe20000011440ULL,
0x000000ffff257224ULL, 0x000fe200078e0028ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000010041287824ULL, 0x000fe200078e00ffULL, 0x0000002400247306ULL, 0x000fe20000202400ULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011441ULL,
0x0000006d3838b232ULL, 0x084fe20000200000ULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000006d3a3ab232ULL, 0x000fe20000200000ULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000006c3939b232ULL, 0x088fe20000200000ULL, 0x0000002600277306ULL, 0x0002a20000202400ULL,
0x0000006c3b3bb232ULL, 0x000fe20000200000ULL, 0x00000018ff747819ULL, 0x000fc40000011443ULL,
0x00000018ff757819ULL, 0x000fe40000011442ULL, 0x00000018ff707819ULL, 0x000fe4000001143cULL,
0x0000002500257306ULL, 0x000fe20000202400ULL, 0x0001000041267824ULL, 0x002fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001143dULL, 0x00000018ff6e7819ULL, 0x000fe4000001143eULL,
0x00000018ff777819ULL, 0x000fc40000011426ULL, 0x0000002800287306ULL, 0x000e620000202400ULL,
0x0000541024247816ULL, 0x004fce0000000027ULL, 0x0000007600767306ULL, 0x000fe20000202400ULL,
0x0000541025257816ULL, 0x002fce0000000028ULL, 0x0000007100717306ULL, 0x000fe20000202400ULL,
0x000000005928783bULL, 0x000e620000004200ULL, 0x000000243824723cULL, 0x000fec0000041810ULL,
0x0000004000417306ULL, 0x0004e20000202400ULL, 0x0000010042117824ULL, 0x040fe200078e00ffULL,
0x0000888042127816ULL, 0x040fe200000000ffULL, 0x0001000042427824ULL, 0x000fca00078e00ffULL,
0x0000007700787306ULL, 0x000f220000202400ULL, 0x0000888043407816ULL, 0x004fe400000000ffULL,
0x00000018ff137819ULL, 0x000fe40000011411ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x0000541041107816ULL, 0x008fe20000000076ULL, 0x0000001200127306ULL, 0x000fe20000202400ULL,
0x0000541078117816ULL, 0x010fce0000000071ULL, 0x0000001300137306ULL, 0x000ea20000202400ULL,
0x00000018ff717819ULL, 0x000fe2000001143fULL, 0x00000010382c723cULL, 0x000fec000004182cULL,
0x0000007400747306ULL, 0x000fe20000202400ULL, 0x00000018ff417819ULL, 0x002fe20000011428ULL,
0x0000010043117824ULL, 0x000fc400078e00ffULL, 0x000000ffff107224ULL, 0x000fc800078e0040ULL,
0x0000007500757306ULL, 0x000fe20000202400ULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff407819ULL, 0x000fc80000011429ULL,
0x0000001000767306ULL, 0x0005f00000202400ULL, 0x0000001100117306ULL, 0x000e620000202400ULL,
0x0000541012107816ULL, 0x004fe40000000013ULL, 0x000088803c137816ULL, 0x000fc400000000ffULL,
0x000088803d127816ULL, 0x000fc600000000ffULL, 0x0000007000707306ULL, 0x000fe20000202400ULL,
0x0000541076117816ULL, 0x002fce0000000011ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x000000103830723cULL, 0x000fee0000041830ULL, 0x0000004200427306ULL, 0x000fe20000202400ULL,
0x00000018ff117819ULL, 0x000fe20000011443ULL, 0x000001003c107824ULL, 0x000fc400078e00ffULL,
0x000001003d437824ULL, 0x000fc800078e00ffULL, 0x0000001300137306ULL, 0x000fe20000202400ULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe40000011443ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000001100117306ULL, 0x000e620000202400ULL,
0x00000018ff3d7819ULL, 0x000fce000001143dULL, 0x0000003c00437306ULL, 0x000ea20000202400ULL,
0x0000541011117816ULL, 0x002fce0000000074ULL, 0x0000001000767306ULL, 0x0003e20000202400ULL,
0x00005410433c7816ULL, 0x004fce0000000070ULL, 0x0000003d00747306ULL, 0x000ea20000202400ULL,
0x0000541042107816ULL, 0x002fe40000000075ULL, 0x000088803f757816ULL, 0x000fe400000000ffULL,
0x000088803e437816ULL, 0x000fe400000000ffULL, 0x00000018ff427819ULL, 0x000fe2000001142aULL,
0x0000001200127306ULL, 0x000fe20000202400ULL, 0x000000103814723cULL, 0x000fe20000041814ULL,
0x00005410743d7816ULL, 0x004fcc000000006fULL, 0x0000007700777306ULL, 0x000e620000202400ULL,
0x000001003e6f7824ULL, 0x040fe200078e00ffULL, 0x0000541013107816ULL, 0x000fe20000000076ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe2000001142bULL,
0x0000003c381c723cULL, 0x000fe6000004181cULL, 0x0000007600707306ULL, 0x0005e80000202400ULL,
0x00000018ff3c7819ULL, 0x000fe2000001146fULL, 0x000001003f6f7824ULL, 0x000fe200078e00ffULL,
0x0000541012117816ULL, 0x002fc40000000077ULL, 0x0000004300747306ULL, 0x000fe40000202400ULL,
0x00000018ff767819ULL, 0x004fc6000001146fULL, 0x000000103818723cULL, 0x000fe20000041818ULL,
0x000000005810783bULL, 0x000e640000004200ULL, 0x0000003c003d7306ULL, 0x000eb00000202400ULL,
0x0000007500757306ULL, 0x000fe20000202400ULL, 0x00005410743c7816ULL, 0x004fce000000003dULL,
0x0000007600767306ULL, 0x000ea20000202400ULL, 0x00000018ff747819ULL, 0x000fce000001143eULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x00005410753d7816ULL, 0x004fce0000000076ULL,
0x0000007100717306ULL, 0x000fe20000202400ULL, 0x0000003c3820723cULL, 0x000fe20000041820ULL,
0x00000018ff6f7819ULL, 0x002fcc0000011410ULL, 0x0000007400757306ULL, 0x000e620000202400ULL,
0x00000018ff437819ULL, 0x000fe40000011411ULL, 0x00000018ff3e7819ULL, 0x000fe20000011413ULL,
0x000100003f3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fc60000011412ULL,
0x0000004100417306ULL, 0x000fe20000202400ULL, 0x00000018ff3c7819ULL, 0x000fce000001143cULL,
0x0000003c00767306ULL, 0x0002b00000202400ULL, 0x0000003d003f7306ULL, 0x0005e20000202400ULL,
0x00005410753c7816ULL, 0x002fe4000000006eULL, 0x00008880286e7816ULL, 0x000fc400000000ffULL,
0x000088802a757816ULL, 0x000fc600000000ffULL, 0x0000004000407306ULL, 0x000fe20000202400ULL,
0x00005410763d7816ULL, 0x004fe20000000071ULL, 0x0000010028717824ULL, 0x040fe400078e00ffULL,
0x0001000028287824ULL, 0x000fc600078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0000003c3838723cULL, 0x000fe20000041834ULL, 0x00a800005434783bULL, 0x000e620000000200ULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x00000018ff287819ULL, 0x000fc80000011428ULL,
0x00000100293d7824ULL, 0x040fe200078e00ffULL, 0x00008880293c7816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x0000007100717306ULL, 0x000ea40000202400ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff297819ULL, 0x000fc80000011429ULL,
0x0000003c003c7306ULL, 0x000ff00000202400ULL, 0x0000003d003d7306ULL, 0x000ef00000202400ULL,
0x0000002900777306ULL, 0x0009e20000202400ULL, 0x0000006c3535b232ULL, 0x002fce0000200000ULL,
0x0000002800747306ULL, 0x0004620000202400ULL, 0x000088802b297816ULL, 0x050fe200000000ffULL,
0x0000006c3737b232ULL, 0x000fe40000200000ULL, 0x0000006d3434b232ULL, 0x080fe40000200000ULL,
0x0000006d3636b232ULL, 0x000fe40000200000ULL, 0x000001002b6d7824ULL, 0x000fe200078e00ffULL,
0x00000029006c7306ULL, 0x0007e20000202400ULL, 0x000054106e287816ULL, 0x004fe20000000071ULL,
0x000001002a717824ULL, 0x000fc400078e00ffULL, 0x000100002a2a7824ULL, 0x000fe400078e00ffULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x00000075006e7306ULL, 0x0005e20000202400ULL, 0x000054103c297816ULL, 0x008fe4000000003dULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x00008880103c7816ULL, 0x040fe200000000ffULL, 0x000000283424723cULL, 0x000fe20000041824ULL,
0x00000018ff757819ULL, 0x004fe2000001146dULL, 0x0000007100717306ULL, 0x000fea0000202400ULL,
0x0000010010297824ULL, 0x000fe200078e00ffULL, 0x0000541074287816ULL, 0x002fe20000000041ULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x0000007500757306ULL, 0x000e620000202400ULL,
0x0000888011747816ULL, 0x000fc400000000ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x00000018ff107819ULL, 0x000fc60000011410ULL, 0x0000002900417306ULL, 0x0005f00000202400ULL,
0x0000004200427306ULL, 0x000fe20000202400ULL, 0x0000541077297816ULL, 0x004fe20000000040ULL,
0x0000000f05407c24ULL, 0x020fc8000f8e02ffULL, 0x0000004040407824ULL, 0x000fe400078e00ffULL,
0x00000028342c723cULL, 0x000fe2000004182cULL, 0x0000002a003d7306ULL, 0x0005ec0000202400ULL,
0x0000010011287824ULL, 0x040fe200078e00ffULL, 0x000054106c297816ULL, 0x002fe20000000075ULL,
0x0000002b006d7306ULL, 0x0003e20000202400ULL, 0x00000056402a7210ULL, 0x004fe20007f3e0ffULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fc40000011428ULL,
0x000054106e287816ULL, 0x000fe20000000071ULL, 0x000000ffff757224ULL, 0x000fe200008e06ffULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x000000102a2b7c11ULL, 0x002fc6000f8240ffULL, 0x000000283430723cULL, 0x000fe20000041830ULL,
0x000000112a2a7c11ULL, 0x000fc600088f4475ULL, 0x0000007400747306ULL, 0x000fe60000202400ULL,
0x0000005540287210ULL, 0x000fca0007f3e0ffULL, 0x0000007600717306ULL, 0x0002b00000202400ULL,
0x00000010006c7306ULL, 0x0007e20000202400ULL, 0x0106b808ff7679a7ULL, 0x002e62000850000bULL,
0x0000541074297816ULL, 0x004fcc0000000071ULL, 0x00000011006e7306ULL, 0x0005e20000202400ULL,
0x000054103d107816ULL, 0x008fe40000000042ULL, 0x0000888012427816ULL, 0x000fca00000000ffULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x000054106d117816ULL, 0x004fe20000000070ULL,
0x000000ffff6d7224ULL, 0x000fe200008e06ffULL, 0x00000010283d7c11ULL, 0x000fc8000f8240ffULL,
0x00000011286d7c11ULL, 0x000fe200088f446dULL, 0x0000004300437306ULL, 0x000ea20000202400ULL,
0x000000103414723cULL, 0x000fe20000041814ULL, 0x000054103c287816ULL, 0x000fe20000000041ULL,
0x00000077ff0075a7ULL, 0x002e620008080048ULL, 0x00008880133c7816ULL, 0x000fe400000000ffULL,
0x000000800e417811ULL, 0x000fe400078e40ffULL, 0x0000010012107824ULL, 0x040fe200078e00ffULL,
0x000000283418723cULL, 0x000fe20000041818ULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x0000004200427306ULL, 0x000fe40000202400ULL, 0x00000018ff107819ULL, 0x000fc40000011410ULL,
0x000054106e117816ULL, 0x004fe20000000043ULL, 0x0000010013287824ULL, 0x040fe200078e00ffULL,
0x0000006840297210ULL, 0x000fe20007f3e0ffULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x0000001000757306ULL, 0x0005e40000202400ULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x000000ffff6e7224ULL, 0x000fe200008e06ffULL, 0x0000001029797c11ULL, 0x000fc8000f8240ffULL,
0x0000001129297c11ULL, 0x000fe200088f446eULL, 0x0000002800717306ULL, 0x0007e20000202400ULL,
0x000054106c107816ULL, 0x004fe2000000006fULL, 0x000000ffff6c7224ULL, 0x000fe200078e003cULL,
0x0000000e413c7c48ULL, 0x000fe4000ffe0000ULL, 0x0000006940437210ULL, 0x000fe40007f3e0ffULL,
0x00000018ff6e7819ULL, 0x000fe20000011412ULL, 0x000000013c3c7824ULL, 0x000fe200078e0a41ULL,
0x0000006c006c7306ULL, 0x000ea20000202400ULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x00000010436f7c11ULL, 0x000fe2000f8240ffULL, 0x00000010341c723cULL, 0x000fe2000004181cULL,
0x000000203c3c7807ULL, 0x000fc40000000000ULL, 0x0000001143437c11ULL, 0x000fe400088f4412ULL,
0x0000003c0f3c7248ULL, 0x000fe20007fe0000ULL, 0x0000003e003e7306ULL, 0x000fe20000202400ULL,
0x00000018ff107819ULL, 0x000fe40000011413ULL, 0x0000004a2b127210ULL, 0x000fe20007f3e0ffULL,
0x000000013c117824ULL, 0x000fe200078e0a0fULL, 0x0000004a3d3c7210ULL, 0x000fe40007fde0ffULL,
0x0000004a79287210ULL, 0x008fe20007fbe0ffULL, 0x0000006e006e7306ULL, 0x000ee20000202400ULL,
0x000000ffff137224ULL, 0x000fe200008e062aULL, 0x000000115200720cULL, 0x080fe20003f46070ULL,
0x000000ffff3d7224ULL, 0x000fe200030e066dULL, 0x000000115000720cULL, 0x080fe20003f26070ULL,
0x000000ffff297224ULL, 0x000fe200028e0629ULL, 0x000000114e00720cULL, 0x000fc40003fa6070ULL,
0x00000010002b7306ULL, 0x0009620000202400ULL, 0x000000114c00720cULL, 0x000fe40003fc6070ULL,
0x000054106c117816ULL, 0x004fe40000000071ULL, 0x0000541042107816ULL, 0x010fce0000000075ULL,
0x000000103420723cULL, 0x000fee0000041820ULL, 0x000054106e107816ULL, 0x008fe4000000003fULL,
0x000054102b117816ULL, 0x020fce000000003eULL, 0x000000103438723cULL, 0x000fe20000041838ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000084947ULL, 0x002fde0003800000ULL,
0x0106b877ff0075a7ULL, 0x000e64000808014bULL, 0x000000d800ccc947ULL, 0x002fea0003800000ULL,
0x0000004a6f107210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012467faeULL, 0x0003e8000d101c4cULL, 0x000000ffff117224ULL, 0x000fe200020e0643ULL,
0x000000003c517faeULL, 0x0003e8000c901c4cULL, 0x00000000284f7faeULL, 0x0003e8000e901c4cULL,
0x00000000104d7faeULL, 0x0003e2000f101c4cULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0106a808ff6c79a7ULL, 0x0004a2000850000bULL, 0x00000073ff0075a7ULL, 0x000ee4000802004aULL,
0x0000000000081947ULL, 0x00cfea0003800000ULL, 0x0106b073ff0075a7ULL, 0x000ea4000802014bULL,
0x000000d800a49947ULL, 0x004fea0003800000ULL, 0x00000000533c783bULL, 0x002e620000004200ULL,
0x0000000e41007c0cULL, 0x000fe2000bf21070ULL, 0x000000076a077221ULL, 0x000fe40000010000ULL,
0x00a800004510783bULL, 0x000fe80000000200ULL, 0x00001f486b437589ULL, 0x000ea800000e0000ULL,
0x00001f446b427589ULL, 0x000ee800000e0000ULL, 0x000000004b28783bULL, 0x000f220000004200ULL,
0x00000018ff717819ULL, 0x002fe2000001143cULL, 0x000001003c357824ULL, 0x040fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe2000001143dULL, 0x000001003d377824ULL, 0x040fe200078e00ffULL,
0x000088803c347816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803d367816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x0000007100717306ULL, 0x000fe20000202400ULL, 0x000000431010b232ULL, 0x084fe20000200000ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x000000431212b232ULL, 0x000fe20000200000ULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x000000421111b232ULL, 0x008fc40000200000ULL,
0x000001003e6b7824ULL, 0x040fe400078e00ffULL, 0x000000421313b232ULL, 0x000fe20000200000ULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x000088803e747816ULL, 0x040fe400000000ffULL,
0x00000018ff757819ULL, 0x000fe4000001146bULL, 0x000088803f6b7816ULL, 0x000fe400000000ffULL,
0x00000018ff737819ULL, 0x000fe2000001143eULL, 0x0000003c003c7306ULL, 0x000e620000202400ULL,
0x00000018ff6f7819ULL, 0x000fe2000001143fULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x010fc40000011428ULL, 0x00000018ff727819ULL, 0x000fe40000011429ULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000003d003d7306ULL, 0x000ea20000202400ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x000054103c3c7816ULL, 0x002fc60000000071ULL, 0x0000007400747306ULL, 0x000fe20000202400ULL,
0x00000018ff717819ULL, 0x000fe4000001142bULL, 0x000054103d3d7816ULL, 0x004fca000000006eULL,
0x0000007500757306ULL, 0x000e640000202400ULL, 0x0000003c102c723cULL, 0x000fec000004182cULL,
0x0000007300737306ULL, 0x000fe20000202400ULL, 0x000001003f3d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fca00078e006bULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff6b7819ULL, 0x000fe4000001142aULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000003c00767306ULL, 0x0003f00000202400ULL, 0x0000003d003d7306ULL, 0x000ea20000202400ULL,
0x00005410743c7816ULL, 0x002fce0000000075ULL, 0x0000003e00747306ULL, 0x0003e20000202400ULL,
0x00005410763d7816ULL, 0x004fce000000003dULL, 0x0000007000707306ULL, 0x000fe20000202400ULL,
0x00000100293e7824ULL, 0x002fe200078e00ffULL, 0x0000003c1030723cULL, 0x000fe80000041830ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000003f00767306ULL, 0x000e620000202400ULL,
0x00000100283d7824ULL, 0x040fe200078e00ffULL, 0x00008880283c7816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fca00078e00ffULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x00000018ff757819ULL, 0x000fe4000001143dULL, 0x00008880293d7816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fc60000011428ULL,
0x0000003400347306ULL, 0x000fe20000202400ULL, 0x00000018ff777819ULL, 0x000fe40000011429ULL,
0x0000541076297816ULL, 0x002fca000000006fULL, 0x00000028003f7306ULL, 0x0002b00000202400ULL,
0x0000007700777306ULL, 0x000ee20000202400ULL, 0x0000541074287816ULL, 0x002fce0000000073ULL,
0x000000281014723cULL, 0x000fe20000041814ULL, 0x0000003500357306ULL, 0x000e6c0000202400ULL,
0x000088802a297816ULL, 0x000fe400000000ffULL, 0x0000003600367306ULL, 0x000fe20000202400ULL,
0x000054103f287816ULL, 0x004fc40000000070ULL, 0x000000ffff707224ULL, 0x000fe200078e0029ULL,
0x0000541077297816ULL, 0x008fe20000000072ULL, 0x000001002a727824ULL, 0x000fe200078e00ffULL,
0x0000541034347816ULL, 0x002fe40000000035ULL, 0x0000003700377306ULL, 0x000e620000202400ULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x00000028101c723cULL, 0x000fe6000004181cULL, 0x00000018ff2a7819ULL, 0x000fc4000001142aULL,
0x0000003c003c7306ULL, 0x000fe40000202400ULL, 0x000001002b287824ULL, 0x040fe200078e00ffULL,
0x000088802b297816ULL, 0x040fe200000000ffULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x0000541036357816ULL, 0x002fc60000000037ULL, 0x0000007500757306ULL, 0x000e620000202400ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x000000341034723cULL, 0x000fe20000041824ULL, 0x000000004724783bULL, 0x000ea60000004200ULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x000054103c3c7816ULL, 0x002fce0000000075ULL,
0x0000002900297306ULL, 0x000ff00000202400ULL, 0x0000007200757306ULL, 0x000e700000202400ULL,
0x0000002800787306ULL, 0x0002f00000202400ULL, 0x0000003d003d7306ULL, 0x000fe20000202400ULL,
0x0000541070287816ULL, 0x002fc40000000075ULL, 0x0000541029297816ULL, 0x008fca0000000078ULL,
0x0000003e003e7306ULL, 0x000e620000202400ULL, 0x00000018ff6e7819ULL, 0x004fe40000011424ULL,
0x00000018ff737819ULL, 0x000fe40000011425ULL, 0x0000888026787816ULL, 0x000fe200000000ffULL,
0x000000281020723cULL, 0x000fe20000041820ULL, 0x00000018ff6f7819ULL, 0x000fe20000011426ULL,
0x0000006b006b7306ULL, 0x000fe20000202400ULL, 0x00000018ff747819ULL, 0x000fe40000011427ULL,
0x000054103d3d7816ULL, 0x002fca000000003eULL, 0x0000007100717306ULL, 0x000fe40000202400ULL,
0x0000003c1018723cULL, 0x000fe20000041818ULL, 0x00000000663c783bULL, 0x000e6a0000004200ULL,
0x0000002a002a7306ULL, 0x000eb00000202400ULL, 0x0000002b00767306ULL, 0x000ee20000202400ULL,
0x000054102a287816ULL, 0x004fce000000006bULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x0000541076297816ULL, 0x008fce0000000071ULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x000000281038723cULL, 0x000fe20000041838ULL, 0x00a800006728783bULL, 0x000eac0000000200ULL,
0x0000007800787306ULL, 0x000fe20000202400ULL, 0x0000010024117824ULL, 0x040fe200078e00ffULL,
0x0000888024107816ULL, 0x040fe200000000ffULL, 0x0000010025127824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x002fe2000001143eULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fc40000011411ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x0000888025117816ULL, 0x000fe400000000ffULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000018ff707819ULL, 0x000fe2000001143cULL,
0x0000001000107306ULL, 0x000fe20000202400ULL, 0x00000018ff727819ULL, 0x000fe4000001143dULL,
0x00000018ff717819ULL, 0x000fca000001143fULL, 0x0000001300137306ULL, 0x000e700000202400ULL,
0x0000001100117306ULL, 0x000fe20000202400ULL, 0x000000432828b232ULL, 0x084fe40000200000ULL,
0x000000432a2ab232ULL, 0x000fe20000200000ULL, 0x0000541010107816ULL, 0x002fc80000000013ULL,
0x0000001200127306ULL, 0x000e620000202400ULL, 0x000000422929b232ULL, 0x080fe40000200000ULL,
0x0000010026137824ULL, 0x040fe400078e00ffULL, 0x000000422b2bb232ULL, 0x000fe40000200000ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011413ULL,
0x00000075006b7306ULL, 0x0005e60000202400ULL, 0x00000018ff267819ULL, 0x000fc40000011426ULL,
0x0000541011117816ULL, 0x002fc60000000012ULL, 0x0000007700777306ULL, 0x000fe20000202400ULL,
0x0001000025757824ULL, 0x004fca00078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011475ULL,
0x000000102810723cULL, 0x000fe20000041834ULL, 0x0000002400257306ULL, 0x0002ac0000202400ULL,
0x000088803c357816ULL, 0x000fe400000000ffULL, 0x00000075007a7306ULL, 0x000ee20000202400ULL,
0x0000888027247816ULL, 0x002fca00000000ffULL, 0x000000ffff347224ULL, 0x000fe400078e0024ULL,
0x0000010027247824ULL, 0x040fe200078e00ffULL, 0x0000002600767306ULL, 0x000fe20000202400ULL,
0x0001000027277824ULL, 0x000fc600078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000002400377306ULL, 0x0005f00000202400ULL,
0x0000003400347306ULL, 0x000e620000202400ULL, 0x0000541025247816ULL, 0x004fe2000000006eULL,
0x000001003c257824ULL, 0x040fe200078e00ffULL, 0x000088803d6e7816ULL, 0x000fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff427819ULL, 0x000fe20000011425ULL,
0x0000007400747306ULL, 0x000fe20000202400ULL, 0x000054107a257816ULL, 0x008fe40000000073ULL,
0x00000018ff3c7819ULL, 0x000fca000001143cULL, 0x00000024282c723cULL, 0x000fe2000004182cULL,
0x0000002700757306ULL, 0x0004ec0000202400ULL, 0x000001003d247824ULL, 0x040fe400078e00ffULL,
0x000001003e257824ULL, 0x000fe200078e00ffULL, 0x0000003500357306ULL, 0x000fe20000202400ULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fc40000011424ULL,
0x00000018ff267819ULL, 0x000fe40000011425ULL, 0x0000541034257816ULL, 0x002fe40000000037ULL,
0x0000002400737306ULL, 0x0003e20000202400ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x000088803e277816ULL, 0x044fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x000088803f377816ULL, 0x000fc600000000ffULL, 0x0000004200427306ULL, 0x000ea20000202400ULL,
0x0000541078247816ULL, 0x002fe40000000077ULL, 0x00000018ff347819ULL, 0x000fca000001143eULL,
0x000000242830723cULL, 0x000fe20000041830ULL, 0x0000006e006e7306ULL, 0x000e6c0000202400ULL,
0x000001003f247824ULL, 0x000fe200078e00ffULL, 0x0000541075257816ULL, 0x008fe20000000074ULL,
0x0000003c00437306ULL, 0x000fe20000202400ULL, 0x000100003f3f7824ULL, 0x000fc400078e00ffULL,
0x00000018ff247819ULL, 0x000fc60000011424ULL, 0x00000018ff367819ULL, 0x000fe4000001143fULL,
0x00000024003c7306ULL, 0x0007f00000202400ULL, 0x0000007000707306ULL, 0x000f220000202400ULL,
0x0000541076247816ULL, 0x008fce000000006fULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x000000242814723cULL, 0x000fee0000041814ULL, 0x0000003d003d7306ULL, 0x000ee20000202400ULL,
0x0000541035247816ULL, 0x004fe40000000042ULL, 0x000054106e257816ULL, 0x002fca0000000073ULL,
0x0000002700277306ULL, 0x000fe40000202400ULL, 0x000000242818723cULL, 0x000fec0000041818ULL,
0x0000002600267306ULL, 0x000e620000202400ULL, 0x0000541043247816ULL, 0x010fe40000000070ULL,
0x000054103d257816ULL, 0x008fca0000000072ULL, 0x0000003700377306ULL, 0x000ea40000202400ULL,
0x00000024281c723cULL, 0x000fec000004181cULL, 0x0000007100717306ULL, 0x000fe20000202400ULL,
0x0000541027247816ULL, 0x002fe40000000026ULL, 0x0000541037257816ULL, 0x004fca000000003cULL,
0x0000003400347306ULL, 0x000e640000202400ULL, 0x000000242820723cULL, 0x000fe20000041820ULL,
0x0106b808ff2479a7ULL, 0x0004aa000850000bULL, 0x0000003600367306ULL, 0x000ee20000202400ULL,
0x0000541034347816ULL, 0x002fe2000000006bULL, 0x01069008ffff79a7ULL, 0x0005e2000850000bULL,
0x0000541036357816ULL, 0x008fce0000000071ULL, 0x000000342834723cULL, 0x000fe20000041838ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000005000249947ULL, 0x004fde0003800000ULL,
0x0000000304057812ULL, 0x000fe200078ec0ffULL, 0x00000025ff0075a7ULL, 0x000e620008040048ULL,
0x0000006540277210ULL, 0x000fe40007f7e0ffULL, 0x000000030500780cULL, 0x000fe40003f25270ULL,
0x0000006140387210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x000000015d057807ULL, 0x000fe40004800000ULL, 0x0000001027397c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff3d7224ULL, 0x000fe200020e06ffULL, 0x00000010383f7c11ULL, 0x000fe2000f8840ffULL,
0x0000000104047824ULL, 0x000fe200078e0205ULL, 0x000000a00e057811ULL, 0x000fc400078e40ffULL,
0x0000001127297c11ULL, 0x000fe400098f4428ULL, 0x0000000604007c0cULL, 0x000fe4000bf26070ULL,
0x0000000e05267c48ULL, 0x000fe4000ffe0000ULL, 0x00000063402a7210ULL, 0x000fe40007f7e0ffULL,
0x0000005f40407210ULL, 0x000fe20007fbe0ffULL, 0x0000000126267824ULL, 0x000fe200078e0a05ULL,
0x00000011383d7c11ULL, 0x000fe2000a0f443dULL, 0x000000ffff2b7224ULL, 0x000fe200018e06ffULL,
0x000000102a3b7c11ULL, 0x000fe2000f8640ffULL, 0x000000ffff417224ULL, 0x000fe200028e06ffULL,
0x0000002026287807ULL, 0x000fc40000000000ULL, 0x00008c00ff269b82ULL, 0x000ea20000000a00ULL,
0x0000001040437c11ULL, 0x000fe4000f8a40ffULL, 0x000000280f287248ULL, 0x000fe40007fe0000ULL,
0x0000004a39387210ULL, 0x000fe40007f9e0ffULL, 0x000000112a2b7c11ULL, 0x000fe200098f442bULL,
0x0000000128057824ULL, 0x000fe200078e0a0fULL, 0x0000001140417c11ULL, 0x000fe2000a8f4441ULL,
0x000000ffff397224ULL, 0x000fc600020e0629ULL, 0x000000055200720cULL, 0x000fe20003f66070ULL,
0x0000000000082947ULL, 0x002fd80003800000ULL, 0x0106b825ff0075a7ULL, 0x000e64000804014bULL,
0x000000c80090a947ULL, 0x002fea0003800000ULL, 0x0000004a3b2a7210ULL, 0x000fe20007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038647faeULL, 0x0003e2000d901c4cULL,
0x0000004a3f287210ULL, 0x000fe20007fbe0ffULL, 0x0000000104259824ULL, 0x000fe200078e020bULL,
0x000000055000720cULL, 0x080fe20003f66070ULL, 0x000000ffff2b7224ULL, 0x000fe200020e062bULL,
0x000000054e00720cULL, 0x080fe20003f46070ULL, 0x000000ffff297224ULL, 0x000fe200028e063dULL,
0x000000054c00720cULL, 0x000fe20003f86070ULL, 0x0000000425269825ULL, 0x004fe200078e0026ULL,
0x0000004a43247210ULL, 0x000fc60007fbe0ffULL, 0xffffffffff057424ULL, 0x000fe400078e00ffULL,
0x000000ffff257224ULL, 0x000fe400028e0641ULL, 0x000000002a627faeULL, 0x0005e8000d901c4cULL,
0x0000000028607faeULL, 0x0005e8000d101c4cULL, 0x00000000245e7faeULL, 0x0005e2000e101c4cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000c26059981ULL, 0x000568000c1e1900ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4aULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0106b008ff7479a7ULL, 0x000262000850000bULL, 0x0000006dff0075a7ULL, 0x0002620008020045ULL,
0x010648080f2479a7ULL, 0x004ea4000850000bULL, 0x010648250f0075a7ULL, 0x004ea4000804014bULL,
0x000000c8003ca947ULL, 0x006fea0003800000ULL, 0x010100005c257984ULL, 0x000e620000000800ULL,
0x00000001ff397424ULL, 0x000fc600078e00ffULL, 0x010300005c407984ULL, 0x0004a20000000800ULL,
0x000000062500720bULL, 0x002fda0003f5d000ULL, 0x0000000000247806ULL, 0x000fc800010e0100ULL,
0x0000ffff24267812ULL, 0x000fda000784c0ffULL, 0x0000000000cca947ULL, 0x004fea0003800000ULL,
0x000000062500720bULL, 0x000fe40003f54000ULL, 0x0000002506277209ULL, 0x000fca0007810000ULL,
0x8000002706247221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b24247820ULL, 0x000fe40000410000ULL,
0x0000000000067806ULL, 0x000fe400010e0100ULL, 0x0000002400297308ULL, 0x000e620000000800ULL,
0x000000024900780cULL, 0x000fe40003f45270ULL, 0x0000ffff062b7812ULL, 0x000fc800078e3cffULL,
0x0000002b26ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff397807ULL, 0x000fc60001800000ULL,
0x010500275c00a388ULL, 0x000fe20000000800ULL, 0x0000002907077220ULL, 0x002fc60000410000ULL,
0x00001f4829067589ULL, 0x000e6400000e0000ULL, 0x8000002725263221ULL, 0x000fe40000010000ULL,
0x00001f4429257589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b26263820ULL, 0x000fc80000410000ULL,
0x00000026000a3308ULL, 0x000ee20000000800ULL, 0x0000000610107220ULL, 0x082fe20000410000ULL,
0x0000000611117220ULL, 0x080fe20000410000ULL, 0x000000062c2c7220ULL, 0x080fe20000410000ULL,
0x000000062d2d7220ULL, 0x080fe20000410000ULL, 0x0000000630307220ULL, 0x080fe20000410000ULL,
0x0000000631317220ULL, 0x080fe20000410000ULL, 0x0000000614147220ULL, 0x080fe20000410000ULL,
0x0000000615157220ULL, 0x080fe20000410000ULL, 0x0000000618187220ULL, 0x080fe20000410000ULL,
0x0000000619197220ULL, 0x080fe20000410000ULL, 0x000000061c1c7220ULL, 0x080fe20000410000ULL,
0x000000061d1d7220ULL, 0x080fe20000410000ULL, 0x0000000620207220ULL, 0x080fe20000410000ULL,
0x0000000621217220ULL, 0x080fe20000410000ULL, 0x0000000634347220ULL, 0x080fe20000410000ULL,
0x0000000635357220ULL, 0x000fe20000410000ULL, 0x0000002512127220ULL, 0x084fe20000410000ULL,
0x0000002513137220ULL, 0x080fe20000410000ULL, 0x000000252e2e7220ULL, 0x080fe20000410000ULL,
0x000000252f2f7220ULL, 0x080fe20000410000ULL, 0x0000002532327220ULL, 0x080fe20000410000ULL,
0x0000002533337220ULL, 0x080fe20000410000ULL, 0x0000002516167220ULL, 0x080fe20000410000ULL,
0x0000002517177220ULL, 0x080fe20000410000ULL, 0x000000251a1a7220ULL, 0x080fe20000410000ULL,
0x000000251b1b7220ULL, 0x080fe20000410000ULL, 0x000000251e1e7220ULL, 0x080fe20000410000ULL,
0x000000251f1f7220ULL, 0x080fe20000410000ULL, 0x0000002522227220ULL, 0x080fe20000410000ULL,
0x0000002523237220ULL, 0x080fe20000410000ULL, 0x0000002536367220ULL, 0x080fe20000410000ULL,
0x0000002537377220ULL, 0x000fe20000410000ULL, 0x000000ffff067224ULL, 0x000fc400078e0027ULL,
0x000000400a403220ULL, 0x008fce0000410000ULL, 0x0000000000081947ULL, 0x000fea0003800000ULL,
0x0106a86dff0075a7ULL, 0x000e64000802014bULL, 0x000000c400609947ULL, 0x002fea0003800000ULL,
0x000000005b3c783bULL, 0x000e620000004200ULL, 0x0000000aff43723eULL, 0x000fe400000010ffULL,
0x0000991039717816ULL, 0x000fe200000000ffULL, 0x00b000005728783bULL, 0x000fe20000000200ULL,
0x0000541043437816ULL, 0x000fe40000000043ULL, 0x000000ff7100720cULL, 0x000fe20003f65270ULL,
0x000000005a24783bULL, 0x000fe80000004200ULL, 0x00001f4843417589ULL, 0x000ea800000e0000ULL,
0x00001f4443427589ULL, 0x000ee200000e0000ULL, 0x000088803d6a7816ULL, 0x002fe200000000ffULL,
0x000001003c3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fc4000001143cULL,
0x00000018ff6c7819ULL, 0x000fe2000001143dULL, 0x000000ffff397224ULL, 0x000fe200078e006aULL,
0x000088803c387816ULL, 0x040fe200000000ffULL, 0x000001003d6a7824ULL, 0x040fe200078e00ffULL,
0x0000006d006d7306ULL, 0x000fe20000202400ULL, 0x000100003c3c7824ULL, 0x000fe400078e00ffULL,
0x000000412828b232ULL, 0x084fe40000200000ULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fe2000001146aULL, 0x000000412a2ab232ULL, 0x000fe20000200000ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x000000422929b232ULL, 0x088fe20000200000ULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000006c006c7306ULL, 0x000fe20000202400ULL,
0x000000422b2bb232ULL, 0x000fe20000200000ULL, 0x00000018ff707819ULL, 0x000fc4000001143eULL,
0x00000018ff6e7819ULL, 0x000fe4000001143fULL, 0x00000018ff6f7819ULL, 0x000fe40000011424ULL,
0x0000003c003c7306ULL, 0x000e620000202400ULL, 0x00000018ff6b7819ULL, 0x000fe40000011425ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x00000018ff6a7819ULL, 0x000fc60000011426ULL,
0x0000003d003d7306ULL, 0x000ea20000202400ULL, 0x000054103c3c7816ULL, 0x002fce000000006dULL,
0x0000003900397306ULL, 0x000fe20000202400ULL, 0x000001003e6d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001146dULL, 0x0000007100727306ULL, 0x0002e20000202400ULL,
0x000054103d3d7816ULL, 0x004fce000000006cULL, 0x0000003c282c723cULL, 0x000fe2000004182cULL,
0x000088803e717816ULL, 0x042fe200000000ffULL, 0x0000006d006c7306ULL, 0x000fe20000202400ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x0000541039397816ULL, 0x008fc60000000072ULL,
0x000001003f3d7824ULL, 0x040fe200078e00ffULL, 0x000088803f727816ULL, 0x000fe400000000ffULL,
0x0000007100717306ULL, 0x000e620000202400ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x000000ffff3c7224ULL, 0x000fe200078e0072ULL,
0x00000018ff727819ULL, 0x000fc60000011427ULL, 0x0000003c00737306ULL, 0x0003f00000202400ULL,
0x0000003d00767306ULL, 0x000ea20000202400ULL, 0x00005410713c7816ULL, 0x002fe2000000006cULL,
0x000100003f717824ULL, 0x000fcc00078e00ffULL, 0x0000007000707306ULL, 0x000fe20000202400ULL,
0x00005410733d7816ULL, 0x004fce0000000076ULL, 0x0000003e003f7306ULL, 0x0002a20000202400ULL,
0x0000010025737824ULL, 0x040fe200078e00ffULL, 0x0000003c2830723cULL, 0x000fe80000041830ULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x00008880253e7816ULL, 0x042fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe20000011471ULL, 0x00000100243c7824ULL, 0x040fe200078e00ffULL,
0x0000888024717816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff247819ULL, 0x000fca0000011424ULL,
0x0000003c00767306ULL, 0x0005f00000202400ULL, 0x0000002400247306ULL, 0x000e620000202400ULL,
0x000054103f3c7816ULL, 0x004fce0000000070ULL, 0x0000002500707306ULL, 0x000ea20000202400ULL,
0x0000541024247816ULL, 0x002fce000000006fULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x00008880266f7816ULL, 0x000fe400000000ffULL, 0x0000541070257816ULL, 0x004fca000000006bULL,
0x0000003d003d7306ULL, 0x000e620000202400ULL, 0x0000010026707824ULL, 0x040fe400078e00ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000024281c723cULL, 0x000fe8000004181cULL,
0x0000003800387306ULL, 0x000fe20000202400ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000018ff247819ULL, 0x000fe20000011470ULL, 0x0000010027707824ULL, 0x000fe200078e00ffULL,
0x000054103d3d7816ULL, 0x002fc6000000006eULL, 0x0000003a003b7306ULL, 0x000e620000202400ULL,
0x0000888027257816ULL, 0x040fe200000000ffULL, 0x0001000027277824ULL, 0x000fe400078e00ffULL,
0x0000003c2814723cULL, 0x000fe60000041814ULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000007100717306ULL, 0x000ea20000202400ULL, 0x0000541038387816ULL, 0x002fce000000003bULL,
0x0000006f006b7306ULL, 0x000fe20000202400ULL, 0x000000382810723cULL, 0x000fe20000041810ULL,
0x00005410713c7816ULL, 0x004fcc0000000076ULL, 0x0000002400247306ULL, 0x000e620000202400ULL,
0x00000018ff767819ULL, 0x000fe20000011470ULL, 0x000000005938783bULL, 0x000eac0000004200ULL,
0x0000002500257306ULL, 0x000fe20000202400ULL, 0x000054106b247816ULL, 0x002fce0000000024ULL,
0x0000007600767306ULL, 0x000e700000202400ULL, 0x0000003e003e7306ULL, 0x000fe20000202400ULL,
0x0000541025257816ULL, 0x002fce0000000076ULL, 0x0000007300737306ULL, 0x000e620000202400ULL,
0x000000242820723cULL, 0x000fee0000041820ULL, 0x0000006a006a7306ULL, 0x000fe20000202400ULL,
0x00000018ff777819ULL, 0x004fe40000011438ULL, 0x00000018ff6c7819ULL, 0x000fc40000011439ULL,
0x00000018ff6e7819ULL, 0x000fe4000001143aULL, 0x000054103e3d7816ULL, 0x002fe20000000073ULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x00000018ff717819ULL, 0x000fca000001143bULL,
0x0000003c283c723cULL, 0x000fe20000041818ULL, 0x000000005818783bULL, 0x000e620000004200ULL,
0x0000002600737306ULL, 0x0004f00000202400ULL, 0x0000002700257306ULL, 0x000f220000202400ULL,
0x0000010038267824ULL, 0x004fe200078e00ffULL, 0x0000541073247816ULL, 0x008fcc000000006aULL,
0x00000077006d7306ULL, 0x0005e20000202400ULL, 0x0000888038737816ULL, 0x000fe400000000ffULL,
0x0000541025257816ULL, 0x010fca0000000072ULL, 0x0000006c006c7306ULL, 0x000fe40000202400ULL,
0x000000242828723cULL, 0x000fec0000041834ULL, 0x0000007300727306ULL, 0x000fe20000202400ULL,
0x00000018ff377819ULL, 0x000fe20000011426ULL, 0x0000010039347824ULL, 0x040fe200078e00ffULL,
0x00b000005424783bULL, 0x000ee20000000200ULL, 0x0000888039357816ULL, 0x040fe200000000ffULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x002fc4000001141bULL,
0x0000003700377306ULL, 0x000fe20000202400ULL, 0x00000018ff777819ULL, 0x004fe20000011434ULL,
0x0001000038347824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a367816ULL, 0x000fe400000000ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000003500357306ULL, 0x000fe20000202400ULL, 0x00000018ff707819ULL, 0x000fe40000011418ULL,
0x00000018ff6f7819ULL, 0x000fc40000011419ULL, 0x00000018ff6b7819ULL, 0x000fc6000001141aULL,
0x0000007700387306ULL, 0x000e700000202400ULL, 0x00000076006a7306ULL, 0x000fe20000202400ULL,
0x0000541035357816ULL, 0x002fce0000000038ULL, 0x0000003400767306ULL, 0x0002a20000202400ULL,
0x0000888018387816ULL, 0x000fe200000000ffULL, 0x000000412424b232ULL, 0x088fe40000200000ULL,
0x000000412626b232ULL, 0x000fe40000200000ULL, 0x000000422525b232ULL, 0x080fe20000200000ULL,
0x0000541072347816ULL, 0x002fe20000000037ULL, 0x000000422727b232ULL, 0x000fe20000200000ULL,
0x0000003900737306ULL, 0x0002e20000202400ULL, 0x000001003a377824ULL, 0x040fe200078e00ffULL,
0x0000888019427816ULL, 0x000fe200000000ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x000000342410723cULL, 0x000fe20000041810ULL, 0x00000018ff777819ULL, 0x000fe20000011437ULL,
0x0000003600367306ULL, 0x000fe20000202400ULL, 0x000001003b397824ULL, 0x042fe200078e00ffULL,
0x000088803b377816ULL, 0x040fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe400078e00ffULL,
0x0000010018357824ULL, 0x040fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011439ULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe2000001143aULL,
0x0000007700417306ULL, 0x000e620000202400ULL, 0x00000018ff357819ULL, 0x000fc40000011435ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143bULL, 0x0000541076347816ULL, 0x004fe4000000006dULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x00000035003b7306ULL, 0x0007f00000202400ULL,
0x0000003700377306ULL, 0x000fe20000202400ULL, 0x0000541073357816ULL, 0x008fe2000000006cULL,
0x000000ffff6c7224ULL, 0x000fc400078e0042ULL, 0x0000000f05427c24ULL, 0x020fc8000f8e02ffULL,
0x0000007200727306ULL, 0x000ea20000202400ULL, 0x00000034242c723cULL, 0x000fe2000004182cULL,
0x0000004042427824ULL, 0x000fcc00078e00ffULL, 0x0000010019347824ULL, 0x040fe200078e00ffULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x0001000019197824ULL, 0x000fc600078e00ffULL,
0x00000018ff737819ULL, 0x000fe40000011434ULL, 0x0000541036347816ULL, 0x002fe40000000041ULL,
0x0000003900397306ULL, 0x000e620000202400ULL, 0x0000005642367210ULL, 0x000fe40007f3e0ffULL,
0x0000541037357816ULL, 0x004fe40000000072ULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x000000ffff777224ULL, 0x000fe200008e06ffULL, 0x0000001036377c11ULL, 0x040fe2000f8240ffULL,
0x0000007100717306ULL, 0x000fe40000202400ULL, 0x000000342430723cULL, 0x000fe20000041830ULL,
0x0000001136367c11ULL, 0x000fca00088f4477ULL, 0x0000003a003a7306ULL, 0x000fe20000202400ULL,
0x000088801a347816ULL, 0x000fce00000000ffULL, 0x0000003800387306ULL, 0x000ff00000202400ULL,
0x0000006c006c7306ULL, 0x000ff00000202400ULL, 0x0000007300417306ULL, 0x0004f00000202400ULL,
0x00000018006d7306ULL, 0x0003e20000202400ULL, 0x0106b808ff7279a7ULL, 0x004eae000850000bULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x0000541039187816ULL, 0x002fc4000000006eULL,
0x00000055426e7210ULL, 0x000fca0007f3e0ffULL, 0x0000001900767306ULL, 0x0003220000202400ULL,
0x000000ffff357224ULL, 0x000fe200008e06ffULL, 0x000000106e397c11ULL, 0x000fc8000f8240ffULL,
0x000000116e6e7c11ULL, 0x000fe400088f4435ULL, 0x000054106c357816ULL, 0x008fe20000000041ULL,
0x0000007000707306ULL, 0x000ee20000202400ULL, 0x000054103a197816ULL, 0x002fe20000000071ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0034ULL, 0x0000541038347816ULL, 0x000fe2000000003bULL,
0x00000073ff0075a7ULL, 0x004e620008080048ULL, 0x000088801b387816ULL, 0x000fe400000000ffULL,
0x000000c00e417811ULL, 0x000fe200078e40ffULL, 0x000000182414723cULL, 0x000fe20000041814ULL,
0x0000003a003a7306ULL, 0x000fea0000202400ULL, 0x00000034243c723cULL, 0x000fe2000004183cULL,
0x000001001a187824ULL, 0x000fe200078e00ffULL, 0x0000541076197816ULL, 0x010fe2000000006fULL,
0x000000ffff6f7224ULL, 0x000fe200078e0038ULL, 0x0000000e41387c48ULL, 0x000fe2000ffe0000ULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x000001001b347824ULL, 0x040fe200078e00ffULL, 0x0000006842357210ULL, 0x000fe20007f3e0ffULL,
0x0000000138387824ULL, 0x000fe200078e0a41ULL, 0x00000018003b7306ULL, 0x0007e20000202400ULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x000000ffff6c7224ULL, 0x000fe200008e06ffULL, 0x0000001035717c11ULL, 0x000fc4000f8240ffULL,
0x0000002038387807ULL, 0x000fe40000000000ULL, 0x0000001135357c11ULL, 0x000fe200088f446cULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x000054106d187816ULL, 0x008fe40000000070ULL,
0x00000069426c7210ULL, 0x000fe40007f3e0ffULL, 0x00000018ff767819ULL, 0x000fe4000001141aULL,
0x000000380f387248ULL, 0x000fe20007fe0000ULL, 0x0000003400707306ULL, 0x0004e20000202400ULL,
0x00000018241c723cULL, 0x000fee000004181cULL, 0x000000ffff197224ULL, 0x000fe200008e06ffULL,
0x000000106c6d7c11ULL, 0x000fe2000f8240ffULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x00000018ff187819ULL, 0x000fc4000001141bULL, 0x000000116c6c7c11ULL, 0x000fe200088f4419ULL,
0x0000000138197824ULL, 0x000fe200078e0a0fULL, 0x0000004a371a7210ULL, 0x000fe40007f3e0ffULL,
0x0000004a39387210ULL, 0x000fe20007fde0ffULL, 0x0000007600767306ULL, 0x000f220000202400ULL,
0x0000004a71347210ULL, 0x004fe20007fbe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200008e0636ULL,
0x000000195200720cULL, 0x080fe20003f46070ULL, 0x000000ffff397224ULL, 0x000fe200030e066eULL,
0x000000195000720cULL, 0x080fe20003f26070ULL, 0x000000ffff357224ULL, 0x000fe200028e0635ULL,
0x000000194e00720cULL, 0x080fe20003fa6070ULL, 0x0000001800377306ULL, 0x0005620000202400ULL,
0x000000194c00720cULL, 0x000fc40003fc6070ULL, 0x000054106f197816ULL, 0x008fe40000000070ULL,
0x000054103a187816ULL, 0x004fce000000003bULL, 0x000000182420723cULL, 0x000fee0000041820ULL,
0x0000541076187816ULL, 0x010fe4000000006bULL, 0x0000541037197816ULL, 0x020fce000000006aULL,
0x000000182428723cULL, 0x000fe20000041828ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000084947ULL, 0x002fde0003800000ULL, 0x0106b873ff0075a7ULL, 0x000e64000808014bULL,
0x000000b40038c947ULL, 0x002fea0003800000ULL, 0x0000004a6d187210ULL, 0x000fe20007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a467faeULL, 0x0003e8000d101c4cULL,
0x000000ffff197224ULL, 0x000fe200020e066cULL, 0x0000000038517faeULL, 0x0003e8000c901c4cULL,
0x00000000344f7faeULL, 0x0003e8000e901c4cULL, 0x00000000184d7faeULL, 0x0003e2000f101c4cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0106a808ff6c79a7ULL, 0x0004a2000850000bULL,
0x00000075ff0075a7ULL, 0x000ee4000802004aULL, 0x0000000000081947ULL, 0x00cfea0003800000ULL,
0x0106b075ff0075a7ULL, 0x000ea4000802014bULL, 0x000000b400109947ULL, 0x004fea0003800000ULL,
0x000000005338783bULL, 0x002e620000004200ULL, 0x0000000e41007c0cULL, 0x000fe2000bf21070ULL,
0x0000000740077221ULL, 0x000fe40000010000ULL, 0x00b000004524783bULL, 0x000fe80000000200ULL,
0x00001f48436b7589ULL, 0x000ea800000e0000ULL, 0x00001f44436a7589ULL, 0x000ee800000e0000ULL,
0x000000004b34783bULL, 0x000f220000004200ULL, 0x00000018ff737819ULL, 0x002fe20000011438ULL,
0x0000010038197824ULL, 0x040fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe20000011439ULL,
0x00000100391b7824ULL, 0x040fe200078e00ffULL, 0x0000888038187816ULL, 0x040fe200000000ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00008880391a7816ULL, 0x040fe200000000ffULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x0000006b2424b232ULL, 0x084fe20000200000ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000006b2626b232ULL, 0x000fe20000200000ULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000006a2525b232ULL, 0x008fc40000200000ULL, 0x000001003a747824ULL, 0x040fe400078e00ffULL,
0x0000006a2727b232ULL, 0x000fe20000200000ULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x000088803b757816ULL, 0x000fe400000000ffULL, 0x000088803a437816ULL, 0x040fe400000000ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x00000018ff727819ULL, 0x000fe2000001143aULL,
0x0000003800387306ULL, 0x000e620000202400ULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fc4000001143bULL, 0x00000018ff707819ULL, 0x010fe40000011434ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000003900397306ULL, 0x000ea20000202400ULL,
0x00000018ff717819ULL, 0x000fe40000011435ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000018ff1b7819ULL, 0x000fe4000001141bULL, 0x0000541038387816ULL, 0x002fe20000000073ULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x00000018ff777819ULL, 0x000fc40000011437ULL,
0x0000541039397816ULL, 0x004fca000000006eULL, 0x0000004300737306ULL, 0x0003e40000202400ULL,
0x00000038242c723cULL, 0x000fec000004182cULL, 0x00000074006e7306ULL, 0x000ea20000202400ULL,
0x00000018ff437819ULL, 0x002fe20000011436ULL, 0x000001003b397824ULL, 0x000fc400078e00ffULL,
0x000000ffff387224ULL, 0x000fc800078e0075ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fc80000011439ULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000003800757306ULL, 0x0005f00000202400ULL,
0x0000003900767306ULL, 0x000e620000202400ULL, 0x0000541073387816ULL, 0x004fce000000006eULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x0000541075397816ULL, 0x002fce0000000076ULL,
0x0000007100717306ULL, 0x000fe20000202400ULL, 0x000000382430723cULL, 0x000fee0000041830ULL,
0x0000003a00757306ULL, 0x0002a20000202400ULL, 0x0000888034387816ULL, 0x040fe200000000ffULL,
0x0000010034397824ULL, 0x000fcc00078e00ffULL, 0x0000003b00767306ULL, 0x000ee20000202400ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe20000011439ULL,
0x00000100353a7824ULL, 0x042fe200078e00ffULL, 0x0000888035397816ULL, 0x040fe200000000ffULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000001800187306ULL, 0x000fe20000202400ULL, 0x00000018ff3a7819ULL, 0x000fce000001143aULL,
0x00000034003b7306ULL, 0x0005f00000202400ULL, 0x0000001900197306ULL, 0x000e620000202400ULL,
0x0000541075347816ULL, 0x004fe40000000072ULL, 0x00000018ff757819ULL, 0x000fc40000011435ULL,
0x0000541076357816ULL, 0x008fc6000000006fULL, 0x0000007500767306ULL, 0x000ea80000202400ULL,
0x000000342414723cULL, 0x000fe20000041814ULL, 0x0000541018187816ULL, 0x002fc60000000019ULL,
0x0000001a001a7306ULL, 0x000fe60000202400ULL, 0x0000888036357816ULL, 0x000fe400000000ffULL,
0x000054103b347816ULL, 0x000fc60000000070ULL, 0x0000001b001b7306ULL, 0x000e620000202400ULL,
0x000000ffff707224ULL, 0x000fe200078e0035ULL, 0x0000541076357816ULL, 0x004fe20000000071ULL,
0x0000010036717824ULL, 0x040fe400078e00ffULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x00000034241c723cULL, 0x000fe2000004181cULL,
0x0000003800387306ULL, 0x000fe20000202400ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x000054101a197816ULL, 0x002fc6000000001bULL, 0x0000010037347824ULL, 0x040fe200078e00ffULL,
0x0000888037357816ULL, 0x040fe200000000ffULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x0000007300737306ULL, 0x000e640000202400ULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x000000182410723cULL, 0x000fe20000041810ULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x000000004718783bULL, 0x000ea60000004200ULL, 0x0000003900397306ULL, 0x000fe20000202400ULL,
0x0000541038387816ULL, 0x002fce0000000073ULL, 0x0000003a003a7306ULL, 0x000e700000202400ULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x0000541039397816ULL, 0x002fce000000003aULL,
0x0000007100717306ULL, 0x000e620000202400ULL, 0x00000038243c723cULL, 0x000fe2000004183cULL,
0x000000006638783bULL, 0x000eec0000004200ULL, 0x0000003500357306ULL, 0x000fe20000202400ULL,
0x00000018ff6e7819ULL, 0x004fe40000011418ULL, 0x00000018ff727819ULL, 0x000fca0000011419ULL,
0x0000003400767306ULL, 0x0002a20000202400ULL, 0x00000018ff737819ULL, 0x000fe4000001141bULL,
0x00000018ff6f7819ULL, 0x000fca000001141aULL, 0x0000004300437306ULL, 0x000fe20000202400ULL,
0x0000541070347816ULL, 0x002fe40000000071ULL, 0x0000541035357816ULL, 0x004fca0000000076ULL,
0x0000007700747306ULL, 0x000fe40000202400ULL, 0x000000342420723cULL, 0x000fec0000041820ULL,
0x0000003600367306ULL, 0x000e620000202400ULL, 0x00000018ff757819ULL, 0x008fce000001143aULL,
0x0000003700377306ULL, 0x000ea20000202400ULL, 0x00000018ff707819ULL, 0x000fe40000011438ULL,
0x00000018ff717819ULL, 0x000fe40000011439ULL, 0x0000541036347816ULL, 0x002fc60000000043ULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x0000541037357816ULL, 0x004fce0000000074ULL,
0x0000007500437306ULL, 0x000fe20000202400ULL, 0x000000342428723cULL, 0x000fe20000041828ULL,
0x00b000006734783bULL, 0x000e6c0000000200ULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x0000010018247824ULL, 0x040fe200078e00ffULL, 0x0000888018257816ULL, 0x000fe200000000ffULL,
0x0000010019277824ULL, 0x000fca00078e00ffULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe40000011424ULL,
0x0000888019247816ULL, 0x040fe200000000ffULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000002500257306ULL, 0x000fe20000202400ULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x00000018ff197819ULL, 0x000fc40000011419ULL,
0x00000018ff267819ULL, 0x000fc6000001143bULL, 0x0000007400747306ULL, 0x000eb00000202400ULL,
0x0000002400247306ULL, 0x000fe20000202400ULL, 0x0000006b3434b232ULL, 0x002fce0000200000ULL,
0x0000002700277306ULL, 0x000e620000202400ULL, 0x0000006b3636b232ULL, 0x000fe40000200000ULL,
0x000001001a6b7824ULL, 0x000fe400078e00ffULL, 0x0000006a3535b232ULL, 0x080fe40000200000ULL,
0x0000006a3737b232ULL, 0x000fe20000200000ULL, 0x00000018ff777819ULL, 0x000fe2000001146bULL,
0x0000001800757306ULL, 0x0005e20000202400ULL, 0x000088801b6b7816ULL, 0x000fce00000000ffULL,
0x0000006b006b7306ULL, 0x000fe20000202400ULL, 0x0000541025187816ULL, 0x004fe40000000074ULL,
0x000088801a747816ULL, 0x040fe200000000ffULL, 0x000100001a1a7824ULL, 0x000fc800078e00ffULL,
0x0000001900257306ULL, 0x0002b00000202400ULL, 0x00000074006a7306ULL, 0x0007e20000202400ULL,
0x0000541024197816ULL, 0x002fce0000000027ULL, 0x000000183410723cULL, 0x000fe20000041810ULL,
0x0000007700277306ULL, 0x000e620000202400ULL, 0x00000018ff747819ULL, 0x008fe4000001141aULL,
0x00008880381a7816ULL, 0x000fc600000000ffULL, 0x000001001b187824ULL, 0x040fe400078e00ffULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x0000007000707306ULL, 0x000fe20000202400ULL,
0x0000010038197824ULL, 0x040fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe4000001141bULL,
0x00000018ff1b7819ULL, 0x000fe40000011419ULL, 0x0000001800767306ULL, 0x0007220000202400ULL,
0x0000541025197816ULL, 0x004fc40000000072ULL, 0x0000888039727816ULL, 0x000fe400000000ffULL,
0x00000018ff257819ULL, 0x000fe40000011438ULL, 0x000088803a387816ULL, 0x000fe200000000ffULL,
0x0000002400247306ULL, 0x000ea20000202400ULL, 0x0000541075187816ULL, 0x008fce000000006eULL,
0x00000018342c723cULL, 0x000fe2000004182cULL, 0x0000002500257306ULL, 0x000eec0000202400ULL,
0x0000010039187824ULL, 0x040fe400078e00ffULL, 0x000001003a197824ULL, 0x040fe200078e00ffULL,
0x0000007100717306ULL, 0x000fe20000202400ULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000001800757306ULL, 0x0003e20000202400ULL,
0x00000018ff3a7819ULL, 0x000fce000001143aULL, 0x00000039006e7306ULL, 0x000aa20000202400ULL,
0x000054106a187816ULL, 0x002fe40000000027ULL, 0x00000018ff277819ULL, 0x000fe40000011419ULL,
0x000054106b197816ULL, 0x010fe40000000076ULL, 0x000088803b6a7816ULL, 0x040fe200000000ffULL,
0x0000006f006f7306ULL, 0x000fe80000202400ULL, 0x000000183430723cULL, 0x000fe80000041830ULL,
0x0000007400747306ULL, 0x000fe60000202400ULL, 0x000001003b187824ULL, 0x040fe200078e00ffULL,
0x0000541024197816ULL, 0x004fe20000000073ULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x0000541025247816ULL, 0x008fc40000000070ULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000003800387306ULL, 0x000fe20000202400ULL, 0x00000018ff397819ULL, 0x020fe4000001143bULL,
0x000054106e257816ULL, 0x000fca0000000071ULL, 0x0000002700277306ULL, 0x000e640000202400ULL,
0x00000024341c723cULL, 0x000fec000004181cULL, 0x0000006a006a7306ULL, 0x000fe20000202400ULL,
0x0000541038247816ULL, 0x002fce0000000027ULL, 0x00000018006b7306ULL, 0x0002b00000202400ULL,
0x0000001a001a7306ULL, 0x000fe20000202400ULL, 0x0000541074187816ULL, 0x002fe4000000006fULL,
0x000054106a257816ULL, 0x004fca000000006bULL, 0x0000001b001b7306ULL, 0x000e620000202400ULL,
0x000000183414723cULL, 0x000fec0000041814ULL, 0x000000243420723cULL, 0x000fe20000041820ULL,
0x0000007200727306ULL, 0x000ea20000202400ULL, 0x000054101a187816ULL, 0x002fce000000001bULL,
0x0000002600267306ULL, 0x000fe20000202400ULL, 0x0000541072197816ULL, 0x004fce0000000075ULL,
0x0000003a003a7306ULL, 0x000e620000202400ULL, 0x000000183418723cULL, 0x000fee000004183cULL,
0x0000003900397306ULL, 0x000ea20000202400ULL, 0x000054103a247816ULL, 0x002fe40000000043ULL,
0x0000541039257816ULL, 0x004fce0000000026ULL, 0x000000243434723cULL, 0x000fe20000041828ULL,
0x0106b808ff2479a7ULL, 0x0002a2000850000bULL, 0x01069808ffff79a7ULL, 0x0003e2000850000bULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000028000c9947ULL, 0x000fde0003800000ULL,
0x0000000304057812ULL, 0x000fe200078ec0ffULL, 0x00000025ff0075a7ULL, 0x004ea20008040048ULL,
0x0000006342637210ULL, 0x000fe40007fbe0ffULL, 0x000000030500780cULL, 0x000fe40003f25270ULL,
0x000000e00e057811ULL, 0x000fe200078e40ffULL, 0x000000ffff387224ULL, 0x000fe200028e06ffULL,
0x000000015d5d7807ULL, 0x000fe40004800000ULL, 0x0000000e05267c48ULL, 0x000fc4000ffe0000ULL,
0x0000006542657210ULL, 0x000fe20007f9e0ffULL, 0x0000000104047824ULL, 0x000fe200078e025dULL,
0x0000006142617210ULL, 0x000fe20007f7e0ffULL, 0x0000000126267824ULL, 0x000fe200078e0a05ULL,
0x0000005f42427210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200020e06ffULL,
0x0000000604007c0cULL, 0x000fe4000bf26070ULL, 0x0000002026287807ULL, 0x000fe20000000000ULL,
0x000000ffff3b7224ULL, 0x000fe200028e06ffULL, 0x0000001065397c11ULL, 0x000fc4000f8840ffULL,
0x000000280f287248ULL, 0x000fe40007fe0000ULL, 0x00000011652a7c11ULL, 0x000fe4000a0f442aULL,
0x0000001063297c11ULL, 0x000fe2000f8040ffULL, 0x0000000128057824ULL, 0x000fe200078e0a0fULL,
0x00000010612b7c11ULL, 0x000fe2000f8840ffULL, 0x00008c00ff269b82ULL, 0x000ee20000000a00ULL,
0x000000ffff287224ULL, 0x000fe200018e06ffULL, 0x00000010423d7c11ULL, 0x000fe4000f8a40ffULL,
0x0000001163637c11ULL, 0x000fc400080f4438ULL, 0x0000001161617c11ULL, 0x000fe4000a0f4428ULL,
0x00000011423b7c11ULL, 0x000fe4000a8f443bULL, 0x0000004a39387210ULL, 0x000fe40007f7e0ffULL,
0x000000055200720cULL, 0x000fe20003f06070ULL, 0x0000000000082947ULL, 0x004fd80003800000ULL,
0x0106b825ff0075a7ULL, 0x000ea4000804014bULL, 0x000000a40004a947ULL, 0x004fea0003800000ULL,
0x000000ffff397224ULL, 0x000fe200018e062aULL, 0x0000004a29247210ULL, 0x000fe40007fbe0ffULL,
0x000000055000720cULL, 0x080fe40003f86070ULL, 0x000000054e00720cULL, 0x080fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038647faeULL, 0x0005e2000c101c4cULL,
0x000000054c00720cULL, 0x000fe20003f46070ULL, 0x000000ffff257224ULL, 0x000fe200028e0663ULL,
0x0000004a2b2a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000104059824ULL, 0x000fe200078e020bULL,
0x0000004a3d287210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff2b7224ULL, 0x000fe400000e0661ULL,
0x0000000405269825ULL, 0x008fe200078e0026ULL, 0x0000000024627faeULL, 0x0007e6000e101c4cULL,
0x000000ffff297224ULL, 0x000fe200028e063bULL, 0x000000002a607faeULL, 0x0007e2000d901c4cULL,
0xffffffffff057424ULL, 0x000fc600078e00ffULL, 0x00000000285e7faeULL, 0x0007e2000d101c4cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000c26059981ULL, 0x000768000c1e1900ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4aULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x0106b008ff6e79a7ULL, 0x0004a2000850000bULL, 0x0000006dff0075a7ULL, 0x0004a20008000045ULL,
0x010668080f2479a7ULL, 0x008ee4000850000bULL, 0x010668250f0075a7ULL, 0x008ee4000802014bULL,
0x000000a000ac9947ULL, 0x00efea0003800000ULL, 0x010180005c257984ULL, 0x000e620000000800ULL,
0x00000001ff617424ULL, 0x000fc600078e00ffULL, 0x010380005c5d7984ULL, 0x0004a20000000800ULL,
0x000000062500720bULL, 0x002fda0003f3d000ULL, 0x0000000000247806ULL, 0x000fc800008e0100ULL,
0x0000ffff24267812ULL, 0x000fda000782c0ffULL, 0x0000000000cc9947ULL, 0x004fea0003800000ULL,
0x000000062500720bULL, 0x000fe40003f34000ULL, 0x00000025062b7209ULL, 0x000fca0007810000ULL,
0x8000002b06247221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b24247820ULL, 0x000fe40000410000ULL,
0x0000000000067806ULL, 0x000fe400008e0100ULL, 0x0000002400277308ULL, 0x000e620000000800ULL,
0x000000034900780cULL, 0x000fe40003f25270ULL, 0x0000ffff06297812ULL, 0x000fc800078e3cffULL,
0x0000002926ff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff617807ULL, 0x000fc60001000000ULL,
0x0105802b5c009388ULL, 0x000fe20000000800ULL, 0x0000002707077220ULL, 0x002fc60000410000ULL,
0x00001f4827067589ULL, 0x000e6400000e0000ULL, 0x8000002b25262221ULL, 0x000fe40000010000ULL,
0x00001f4427257589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b26262820ULL, 0x000fc80000410000ULL,
0x00000026000a2308ULL, 0x000ee20000000800ULL, 0x0000000610107220ULL, 0x082fe20000410000ULL,
0x0000000611117220ULL, 0x080fe20000410000ULL, 0x000000062c2c7220ULL, 0x080fe20000410000ULL,
0x000000062d2d7220ULL, 0x080fe20000410000ULL, 0x0000000630307220ULL, 0x080fe20000410000ULL,
0x0000000631317220ULL, 0x080fe20000410000ULL, 0x0000000614147220ULL, 0x080fe20000410000ULL,
0x0000000615157220ULL, 0x080fe20000410000ULL, 0x0000000618187220ULL, 0x080fe20000410000ULL,
0x0000000619197220ULL, 0x080fe20000410000ULL, 0x000000061c1c7220ULL, 0x080fe20000410000ULL,
0x000000061d1d7220ULL, 0x080fe20000410000ULL, 0x0000000620207220ULL, 0x080fe20000410000ULL,
0x0000000621217220ULL, 0x080fe20000410000ULL, 0x0000000634347220ULL, 0x080fe20000410000ULL,
0x0000000635357220ULL, 0x000fe20000410000ULL, 0x0000002512127220ULL, 0x084fe20000410000ULL,
0x0000002513137220ULL, 0x080fe20000410000ULL, 0x000000252e2e7220ULL, 0x080fe20000410000ULL,
0x000000252f2f7220ULL, 0x080fe20000410000ULL, 0x0000002532327220ULL, 0x080fe20000410000ULL,
0x0000002533337220ULL, 0x080fe20000410000ULL, 0x0000002516167220ULL, 0x080fe20000410000ULL,
0x0000002517177220ULL, 0x080fe20000410000ULL, 0x000000251a1a7220ULL, 0x080fe20000410000ULL,
0x000000251b1b7220ULL, 0x080fe20000410000ULL, 0x000000251e1e7220ULL, 0x080fe20000410000ULL,
0x000000251f1f7220ULL, 0x080fe20000410000ULL, 0x0000002522227220ULL, 0x080fe20000410000ULL,
0x0000002523237220ULL, 0x080fe20000410000ULL, 0x0000002536367220ULL, 0x080fe20000410000ULL,
0x0000002537377220ULL, 0x000fe20000410000ULL, 0x000000ffff067224ULL, 0x000fc400078e002bULL,
0x0000005d0a5d2220ULL, 0x008fce0000410000ULL, 0x0000000000080947ULL, 0x000fea0003800000ULL,
0x0106a86dff0075a7ULL, 0x000e64000800014bULL, 0x0000009c00d08947ULL, 0x002fea0003800000ULL,
0x000000005b40783bULL, 0x000e620000004200ULL, 0x0000991061767816ULL, 0x000fc600000000ffULL,
0x00b800005728783bULL, 0x0005e80000000200ULL, 0x000000005938783bULL, 0x0007e20000004200ULL,
0x0000000aff57723eULL, 0x004fc600000010ffULL, 0x000000005a3c783bULL, 0x000ea20000004200ULL,
0x0000541057577816ULL, 0x000fc60000000057ULL, 0x000000005824783bULL, 0x000fe80000004200ULL,
0x00001f4857617589ULL, 0x000f2800000e0000ULL, 0x00001f4457627589ULL, 0x000ea200000e0000ULL,
0x0000010041737824ULL, 0x042fe200078e00ffULL, 0x0000888040717816ULL, 0x040fe200000000ffULL,
0x0000010040597824ULL, 0x008fe200078e00ffULL, 0x00008880416d7816ULL, 0x000fc400000000ffULL,
0x00000018ff747819ULL, 0x000fe20000011473ULL, 0x000000ffff737224ULL, 0x000fe200078e0076ULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x0000007100717306ULL, 0x000fe20000202400ULL,
0x00000018ff707819ULL, 0x000fe20000011441ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x000000ff7300720cULL, 0x000fe20003f05270ULL, 0x0001000040737824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe40000011440ULL, 0x00000018ff777819ULL, 0x000fe20000011441ULL,
0x0000005900727306ULL, 0x000e620000202400ULL, 0x00000018ff737819ULL, 0x000fc40000011473ULL,
0x00000018ff6c7819ULL, 0x000fe40000011442ULL, 0x00000018ff6b7819ULL, 0x000fe40000011443ULL,
0x00000018ff6a7819ULL, 0x004fe2000001143cULL, 0x0000006d006d7306ULL, 0x000fe20000202400ULL,
0x0000006128288232ULL, 0x090fe20000200000ULL, 0x000088803c7b7816ULL, 0x000fe200000000ffULL,
0x000000612a2a8232ULL, 0x000fe20000200000ULL, 0x00000018ff657819ULL, 0x000fe2000001143dULL,
0x0000006229298232ULL, 0x080fe20000200000ULL, 0x00000018ff607819ULL, 0x000fe20000011438ULL,
0x000000622b2b8232ULL, 0x000fe20000200000ULL, 0x0000007400747306ULL, 0x000ea20000202400ULL,
0x0000541071407816ULL, 0x002fc40000000072ULL, 0x0000888042727816ULL, 0x000fe400000000ffULL,
0x0000888043717816ULL, 0x000fe400000000ffULL, 0x00000018ff5f7819ULL, 0x000fe20000011439ULL,
0x0000007500757306ULL, 0x000fe20000202400ULL, 0x00000018ff637819ULL, 0x000fe4000001143fULL,
0x000088803e797816ULL, 0x000fe400000000ffULL, 0x00000018ff647819ULL, 0x000fc4000001143eULL,
0x000054106d417816ULL, 0x004fe20000000074ULL, 0x0000007000707306ULL, 0x000fe20000202400ULL,
0x00000018ff5e7819ULL, 0x000fe4000001143aULL, 0x00000018ff5c7819ULL, 0x000fe4000001143bULL,
0x00000018ff5b7819ULL, 0x000fe20000011424ULL, 0x000000402810723cULL, 0x000fe20000041810ULL,
0x00000018ff5a7819ULL, 0x000fe20000011425ULL, 0x0000007300767306ULL, 0x000e620000202400ULL,
0x00000018ff597819ULL, 0x000fc40000011427ULL, 0x00000018ff587819ULL, 0x000fe40000011426ULL,
0x0000010042407824ULL, 0x040fe400078e00ffULL, 0x0000010043417824ULL, 0x040fe200078e00ffULL,
0x0000007700777306ULL, 0x000ea20000202400ULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000018ff6d7819ULL, 0x000fc40000011442ULL,
0x0000004000737306ULL, 0x0003e20000202400ULL, 0x00000018ff427819ULL, 0x000fe40000011443ULL,
0x000088803d437816ULL, 0x000fca00000000ffULL, 0x0000004100747306ULL, 0x0005e20000202400ULL,
0x0000541076407816ULL, 0x002fce0000000075ULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x0000541077417816ULL, 0x004fce0000000070ULL, 0x0000007100717306ULL, 0x000e620000202400ULL,
0x00000040282c723cULL, 0x000fee000004182cULL, 0x000001003c407824ULL, 0x040fe200078e00ffULL,
0x0000006c006c7306ULL, 0x000fe20000202400ULL, 0x000100003c3c7824ULL, 0x000fc400078e00ffULL,
0x000001003d417824ULL, 0x040fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004000787306ULL, 0x0005e20000202400ULL, 0x00000018ff707819ULL, 0x000fce0000011441ULL,
0x0000003c00417306ULL, 0x0007e20000202400ULL, 0x00000018ff407819ULL, 0x004fe4000001143dULL,
0x00005410713d7816ULL, 0x002fe40000000074ULL, 0x000088803f747816ULL, 0x000fc600000000ffULL,
0x0000006b006b7306ULL, 0x000fe20000202400ULL, 0x00005410723c7816ULL, 0x008fe40000000073ULL,
0x0000888038737816ULL, 0x000fca00000000ffULL, 0x0000006d006d7306ULL, 0x000fe20000202400ULL,
0x0000003c2830723cULL, 0x000fee0000041830ULL, 0x0000004200427306ULL, 0x000e620000202400ULL,
0x000001003e3d7824ULL, 0x000fe400078e00ffULL, 0x000001003f3c7824ULL, 0x000fc400078e00ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000007b007b7306ULL, 0x000fe20000202400ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff3e7819ULL, 0x000fca000001143eULL, 0x0000003d00767306ULL, 0x0003f00000202400ULL,
0x0000003c00777306ULL, 0x0005e20000202400ULL, 0x00005410423d7816ULL, 0x002fe4000000006bULL,
0x0000888039427816ULL, 0x000fca00000000ffULL, 0x0000004300437306ULL, 0x000fe20000202400ULL,
0x000054106d3c7816ULL, 0x004fce000000006cULL, 0x0000007000707306ULL, 0x000e620000202400ULL,
0x0000003c2814723cULL, 0x000fee0000041814ULL, 0x00000100383c7824ULL, 0x040fe200078e00ffULL,
0x0000006a006a7306ULL, 0x000ea20000202400ULL, 0x0001000038387824ULL, 0x000fc400078e00ffULL,
0x00000100393d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003c00727306ULL, 0x0007e20000202400ULL, 0x00000018ff3d7819ULL, 0x000fce000001143dULL,
0x0000003800717306ULL, 0x0009e20000202400ULL, 0x00000018ff3c7819ULL, 0x008fe40000011439ULL,
0x0000541043397816ULL, 0x002fe40000000070ULL, 0x000088803a707816ULL, 0x000fc600000000ffULL,
0x0000006500657306ULL, 0x000fe20000202400ULL, 0x000054107b387816ULL, 0x010fce0000000078ULL,
0x0000004000407306ULL, 0x000e620000202400ULL, 0x000000382818723cULL, 0x000fee0000041818ULL,
0x000001003a397824ULL, 0x040fe200078e00ffULL, 0x0000007900797306ULL, 0x000fe20000202400ULL,
0x0000541041387816ULL, 0x004fe2000000006aULL, 0x000100003a3a7824ULL, 0x000fc400078e00ffULL,
0x00000018ff397819ULL, 0x000fc60000011439ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000007400747306ULL, 0x000eb00000202400ULL, 0x00000039006b7306ULL, 0x0003f00000202400ULL,
0x0000003f006c7306ULL, 0x0007e20000202400ULL, 0x0000541040397816ULL, 0x002fce0000000065ULL,
0x00000038281c723cULL, 0x000fe2000004181cULL, 0x00000001033f7824ULL, 0x008fe200078e020eULL,
0x0000003e00757306ULL, 0x0003e60000202400ULL, 0x000000013f417836ULL, 0x040fe40000000000ULL,
0x000001003f3f7824ULL, 0x000fe200078e00ffULL, 0x0000541074397816ULL, 0x004fe20000000077ULL,
0x0000010024387824ULL, 0x000fe200078e00ffULL, 0x0000003d006d7306ULL, 0x0005e20000202400ULL,
0x000001003b3e7824ULL, 0x002fe200078e00ffULL, 0x0000000741007c0cULL, 0x000fc4000bf26070ULL,
0x0000000e3f6a7c48ULL, 0x000fe4000ffe0000ULL, 0x00000018ff417819ULL, 0x000fe40000011438ULL,
0x0000541079387816ULL, 0x000fe20000000076ULL, 0x000000016a6a7824ULL, 0x000fe200078e0a3fULL,
0x000088803b3d7816ULL, 0x044fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x0000003a003f7306ULL, 0x000fe20000202400ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x000000206a6a7807ULL, 0x000fc40000800000ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000006a0f6a7248ULL, 0x000fe20007fe0000ULL, 0x0000003d00407306ULL, 0x0003f00000202400ULL,
0x0000003b00657306ULL, 0x0005e20000202400ULL, 0x000000016a3d7824ULL, 0x002fc400078e0a0fULL,
0x0000000f056a7c24ULL, 0x020fc6000f8e02ffULL, 0x0000003d5200720cULL, 0x080fe20003f26070ULL,
0x0000010025527824ULL, 0x040fe200078e00ffULL, 0x0000006400647306ULL, 0x000fe20000202400ULL,
0x000000382838723cULL, 0x004fe20000041820ULL, 0x00b800005420783bULL, 0x0002a20000000200ULL,
0x0000003d5000720cULL, 0x080fe20003f46070ULL, 0x000000406a6a7824ULL, 0x000fe200078e00ffULL,
0x0000888025507816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe20000011452ULL, 0x0000006300637306ULL, 0x000ee20000202400ULL,
0x0000003d4e00720cULL, 0x000fc40003f66070ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x000000556a527210ULL, 0x000fe40007fbe0ffULL, 0x0000888026547816ULL, 0x002fe200000000ffULL,
0x0000003e00437306ULL, 0x0003e20000202400ULL, 0x000000566a567210ULL, 0x000fe40007f9e0ffULL,
0x000000686a687210ULL, 0x000fc60007fde0ffULL, 0x000000ffff797224ULL, 0x000fe200020e06ffULL,
0x00000010567b7c11ULL, 0x000fe2000f8840ffULL, 0x0000002500557306ULL, 0x0007e20000202400ULL,
0x00008880243e7816ULL, 0x042fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x0000001156797c11ULL, 0x000fe4000a0f4479ULL, 0x0000004a7b787210ULL, 0x000fe40007f9e0ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x000054106c257816ULL, 0x008fe20000000063ULL, 0x000000ffff797224ULL, 0x000fe200020e0679ULL,
0x000000696a697210ULL, 0x000fca0007f9e0ffULL, 0x00000024004e7306ULL, 0x0003e20000202400ULL,
0x0000006221218232ULL, 0x084fe40000200000ULL, 0x0000006223238232ULL, 0x000fe40000200000ULL,
0x0000006120208232ULL, 0x000fc60000200000ULL, 0x0000004200427306ULL, 0x000ea20000202400ULL,
0x0000541075247816ULL, 0x002fe20000000064ULL, 0x0000006122228232ULL, 0x000fe20000200000ULL,
0x0106b808ff7479a7ULL, 0x000e6a000850000bULL, 0x000000242828723cULL, 0x000fe20000041834ULL,
0x0000005f005f7306ULL, 0x000fec0000202400ULL, 0x000000ffff357224ULL, 0x000fe200028e06ffULL,
0x0000001052637c11ULL, 0x000fe2000f8a40ffULL, 0x0000010026247824ULL, 0x000fe200078e00ffULL,
0x0000003c003c7306ULL, 0x000ee20000202400ULL, 0x0000541042257816ULL, 0x004fe2000000006dULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x0000001152527c11ULL, 0x000fe2000a8f4435ULL,
0x000000ffff347224ULL, 0x000fe200078e0054ULL, 0x0000004a63627210ULL, 0x000fc40007fbe0ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000006000607306ULL, 0x000ea20000202400ULL,
0x0000888027367816ULL, 0x000fe200000000ffULL, 0x000000ffff637224ULL, 0x000fe200028e0652ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x000054103c617816ULL, 0x008fc6000000005fULL,
0x0000002400357306ULL, 0x0007e20000202400ULL, 0x00000075ff0075a7ULL, 0x002e6200080a0048ULL,
0x000000ffff5f7224ULL, 0x000fe200030e06ffULL, 0x0000541071607816ULL, 0x004fca0000000060ULL,
0x0000007000707306ULL, 0x000ea20000202400ULL, 0x0000541073247816ULL, 0x008fe20000000072ULL,
0x00000060202c723cULL, 0x000fec000004182cULL, 0x0000005e005e7306ULL, 0x000ee20000202400ULL,
0x000000242010723cULL, 0x000fe20000041810ULL, 0x0000001068617c11ULL, 0x000fcc000f8c40ffULL,
0x0000003e003e7306ULL, 0x000fe20000202400ULL, 0x0000001168687c11ULL, 0x000fe2000b0f445fULL,
0x0000010027257824ULL, 0x040fe200078e00ffULL, 0x0000541070247816ULL, 0x004fe2000000006bULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x000054103f5e7816ULL, 0x008fc6000000005eULL,
0x0000004100417306ULL, 0x000ea20000202400ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000018ff3c7819ULL, 0x000fca0000011427ULL, 0x0000005000507306ULL, 0x000fe20000202400ULL,
0x000054103e3e7816ULL, 0x004fce0000000041ULL, 0x0000007700777306ULL, 0x000eb00000202400ULL,
0x0000002500377306ULL, 0x0007e20000202400ULL, 0x00005410503f7816ULL, 0x004fce0000000077ULL,
0x0000003400347306ULL, 0x000ea20000202400ULL, 0x0000541040257816ULL, 0x008fe40000000043ULL,
0x0000004a61407210ULL, 0x000fe20007fde0ffULL, 0x0000003e2018723cULL, 0x000fe80000041818ULL,
0x0000005c005c7306ULL, 0x000ee20000202400ULL, 0x000000ffff417224ULL, 0x000fe200030e0668ULL,
0x0000003d4c00720cULL, 0x000fe20003fc6070ULL, 0x000000242030723cULL, 0x000fe20000041830ULL,
0x000000ffff3e7224ULL, 0x000fe200020e06ffULL, 0x00000010693d7c11ULL, 0x000fc6000f8840ffULL,
0x0000005b005b7306ULL, 0x000f220000202400ULL, 0x0000541034347816ULL, 0x004fe40000000035ULL,
0x00000011693e7c11ULL, 0x000fe4000a0f443eULL, 0x00005410655f7816ULL, 0x008fc6000000005cULL,
0x0000005a005a7306ULL, 0x000ea80000202400ULL, 0x0000005e2014723cULL, 0x000fe20000041814ULL,
0x000054104e247816ULL, 0x010fc6000000005bULL, 0x0000005800587306ULL, 0x000fe20000202400ULL,
0x0000541055257816ULL, 0x004fce000000005aULL, 0x0000005900597306ULL, 0x000ff00000202400ULL,
0x0000003600367306ULL, 0x000eb00000202400ULL, 0x0000002600437306ULL, 0x0007220000202400ULL,
0x0000541036357816ULL, 0x004fce0000000037ULL, 0x0000003c003c7306ULL, 0x000ea20000202400ULL,
0x000000242024723cULL, 0x008fe2000004181cULL, 0x0000541043587816ULL, 0x010fca0000000058ULL,
0x000000342038723cULL, 0x000fe20000041838ULL, 0x0000004a3d1c7210ULL, 0x000fe40007f9e0ffULL,
0x000054103c597816ULL, 0x004fce0000000059ULL, 0x000000582028723cULL, 0x000fe20000041828ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000085947ULL, 0x002fde0003800000ULL,
0x0106b875ff0075a7ULL, 0x000e6400080a014bULL, 0x0000008c00a4d947ULL, 0x002fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fe200020e063eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000078467faeULL, 0x0003e8000c901c4cULL, 0x0000000062517faeULL, 0x0003e8000d101c4cULL,
0x00000000404f7faeULL, 0x0003e8000d901c4cULL, 0x000000001c4d7faeULL, 0x0003e2000f101c4cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0106a808ff6c79a7ULL, 0x0004a2000850000bULL,
0x0000006fff0075a7ULL, 0x000ee4000802004aULL, 0x0000000000081947ULL, 0x00cfea0003800000ULL,
0x0106b06fff0075a7ULL, 0x000ea4000802014bULL, 0x0000008c00809947ULL, 0x004fea0003800000ULL,
0x000000005320783bULL, 0x000ea20000004200ULL, 0x000000075d077221ULL, 0x000fc60000010000ULL,
0x000000004b3c783bULL, 0x000fe80000004200ULL, 0x000000004734783bULL, 0x000fe80000004200ULL,
0x00000000661c783bULL, 0x002e680000004200ULL, 0x00001f48575b7589ULL, 0x0003e800000e0000ULL,
0x00001f44575e7589ULL, 0x0007e200000e0000ULL, 0x00000018ff547819ULL, 0x004fe20000011420ULL,
0x00000100204c7824ULL, 0x040fe200078e00ffULL, 0x00008880207d7816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011421ULL,
0x00000100214d7824ULL, 0x040fe200078e00ffULL, 0x0000888021767816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x00000018ff4c7819ULL, 0x000fc4000001144cULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x000001001d487824ULL, 0x002fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe40000011422ULL, 0x00000018ff6a7819ULL, 0x000fe20000011423ULL,
0x0000002000797306ULL, 0x0002a20000202400ULL, 0x0000888022777816ULL, 0x000fe400000000ffULL,
0x0000888023707816ULL, 0x000fe400000000ffULL, 0x00000018ff647819ULL, 0x000fc4000001143cULL,
0x00000018ff5c7819ULL, 0x000fe2000001143dULL, 0x0000002100747306ULL, 0x0009e20000202400ULL,
0x0000010023207824ULL, 0x042fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe20000011434ULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x000088803c6f7816ULL, 0x040fe400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000004c00787306ULL, 0x0003e20000202400ULL,
0x000001003c217824ULL, 0x050fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000088803d667816ULL, 0x000fc400000000ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000002000757306ULL, 0x0009e20000202400ULL,
0x00000100224c7824ULL, 0x002fe200078e00ffULL, 0x0000888034567816ULL, 0x000fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000002100687306ULL, 0x0003e20000202400ULL,
0x000001003d207824ULL, 0x050fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000002200737306ULL, 0x000fe20000202400ULL,
0x000001003e217824ULL, 0x002fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000541079547816ULL, 0x004fe40000000054ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000020006b7306ULL, 0x0003e20000202400ULL, 0x00000018ff597819ULL, 0x000fc4000001143eULL,
0x000088803e637816ULL, 0x040fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe40000011435ULL, 0x0000888035527816ULL, 0x000fe200000000ffULL,
0x0000002100627306ULL, 0x0005e20000202400ULL, 0x000001003f207824ULL, 0x002fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe40000011436ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x0000002300717306ULL, 0x000fe20000202400ULL,
0x0000010034217824ULL, 0x044fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe2000001143fULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x000088803f5a7816ULL, 0x040fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011421ULL,
0x0000002000617306ULL, 0x0003e20000202400ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff467819ULL, 0x000fc40000011437ULL, 0x00000018ff437819ULL, 0x000fe4000001141cULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000005500557306ULL, 0x000ea20000202400ULL,
0x0000010035207824ULL, 0x042fe200078e00ffULL, 0x00000018ff577819ULL, 0x008fe20000011448ULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe4000001141dULL,
0x00000018ff537819ULL, 0x000fe40000011420ULL, 0x00b800004520783bULL, 0x000e620000000200ULL,
0x0000007700777306ULL, 0x000fe20000202400ULL, 0x00000018ff357819ULL, 0x000fc40000011435ULL,
0x000088801d447816ULL, 0x000fe400000000ffULL, 0x00000018ff417819ULL, 0x000fe4000001141eULL,
0x0000541074557816ULL, 0x004fe20000000055ULL, 0x0000004c00727306ULL, 0x000ea20000202400ULL,
0x00000018ff407819ULL, 0x000fce000001141fULL, 0x0000007000707306ULL, 0x000ef00000202400ULL,
0x0000007d007d7306ULL, 0x000ff00000202400ULL, 0x0000007600767306ULL, 0x000fe20000202400ULL,
0x0000005b20208232ULL, 0x002fce0000200000ULL, 0x0000004d007b7306ULL, 0x0003e20000202400ULL,
0x0000005b22228232ULL, 0x000fe40000200000ULL, 0x0000005e21218232ULL, 0x080fe40000200000ULL,
0x0000005e23238232ULL, 0x000fc60000200000ULL, 0x0000006e006e7306ULL, 0x000f220000202400ULL,
0x00008880374d7816ULL, 0x002fc600000000ffULL, 0x00000054202c723cULL, 0x000fe8000004182cULL,
0x0000006a006a7306ULL, 0x000e660000202400ULL, 0x0000541077547816ULL, 0x004fe40000000072ULL,
0x0000541070557816ULL, 0x008fc60000000075ULL, 0x0000003c00697306ULL, 0x0005e80000202400ULL,
0x000000542030723cULL, 0x000fe80000041830ULL, 0x0000003d00657306ULL, 0x0007e20000202400ULL,
0x00000100363c7824ULL, 0x004fe400078e00ffULL, 0x0000541073547816ULL, 0x010fc4000000006eULL,
0x0000541071557816ULL, 0x002fe4000000006aULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x00000034004e7306ULL, 0x0003e20000202400ULL, 0x00008880363d7816ULL, 0x048fe200000000ffULL,
0x0001000036367824ULL, 0x000fe400078e00ffULL, 0x000000542014723cULL, 0x000fe60000041814ULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x0000010037347824ULL, 0x002fc400078e00ffULL, 0x0001000037377824ULL, 0x000fe400078e00ffULL,
0x000100001d547824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000006600667306ULL, 0x000e620000202400ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x00000018ff547819ULL, 0x000fca0000011454ULL, 0x0000003e00607306ULL, 0x000fe20000202400ULL,
0x00005410661d7816ULL, 0x002fce000000006bULL, 0x00000035004f7306ULL, 0x0003f00000202400ULL,
0x0000003400507306ULL, 0x0005e20000202400ULL, 0x0000541076357816ULL, 0x002fce000000007bULL,
0x0000003c003e7306ULL, 0x0003e20000202400ULL, 0x000054107d347816ULL, 0x004fce0000000078ULL,
0x00000036004c7306ULL, 0x0005e20000202400ULL, 0x000088801c3c7816ULL, 0x042fe200000000ffULL,
0x000000342010723cULL, 0x000fec0000041810ULL, 0x0000003f005f7306ULL, 0x000fe20000202400ULL,
0x000001001c367824ULL, 0x044fe400078e00ffULL, 0x000100001c1c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011436ULL, 0x00000037003f7306ULL, 0x0003e20000202400ULL,
0x00000018ff1c7819ULL, 0x000fce000001141cULL, 0x0000006400647306ULL, 0x000ea20000202400ULL,
0x00b800006734783bULL, 0x002e6e0000000200ULL, 0x0000005c005c7306ULL, 0x000ef00000202400ULL,
0x0000001c00487306ULL, 0x0009f00000202400ULL, 0x0000005900597306ULL, 0x000f620000202400ULL,
0x000054106f1c7816ULL, 0x010fce0000000068ULL, 0x0000001c2018723cULL, 0x000fe20000041818ULL,
0x0000005800587306ULL, 0x000f2c0000202400ULL, 0x000088801e1d7816ULL, 0x000fe400000000ffULL,
0x00005410691c7816ULL, 0x004fe20000000064ULL, 0x0000006300637306ULL, 0x000fe20000202400ULL,
0x0000005b34348232ULL, 0x002fc40000200000ULL, 0x000000ffff647224ULL, 0x000fe200078e001dULL,
0x00005410651d7816ULL, 0x008fe2000000005cULL, 0x0000005b36368232ULL, 0x000fe40000200000ULL,
0x0000005e35358232ULL, 0x080fe20000200000ULL, 0x0000005a005a7306ULL, 0x000e620000202400ULL,
0x0000005e37378232ULL, 0x000fe40000200000ULL, 0x0000001c2024723cULL, 0x000fea0000041824ULL,
0x0000005600567306ULL, 0x000fe40000202400ULL, 0x000001001e1d7824ULL, 0x000fe200078e00ffULL,
0x00005410601c7816ULL, 0x020fe20000000059ULL, 0x000100001e1e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe2000001141dULL, 0x0000005100517306ULL, 0x000ea20000202400ULL,
0x000054105f1d7816ULL, 0x010fe40000000058ULL, 0x000054105a557816ULL, 0x002fe40000000061ULL,
0x00000018ff1e7819ULL, 0x000fc6000001141eULL, 0x0000005200527306ULL, 0x000fe20000202400ULL,
0x0000001c2028723cULL, 0x000fee0000041828ULL, 0x0000005300537306ULL, 0x000e620000202400ULL,
0x00005410561c7816ULL, 0x004fce0000000051ULL, 0x0000005400677306ULL, 0x0005e20000202400ULL,
0x00005410521d7816ULL, 0x002fce0000000053ULL, 0x0000003d003d7306ULL, 0x000e620000202400ULL,
0x0000541063547816ULL, 0x004fe20000000062ULL, 0x0000001c3410723cULL, 0x000fec0000041810ULL,
0x0000004b004b7306ULL, 0x000ea20000202400ULL, 0x000000542038723cULL, 0x000fe20000041838ULL,
0x000054103d1c7816ULL, 0x002fcc000000003eULL, 0x0000004a004a7306ULL, 0x000e620000202400ULL,
0x000001001f217824ULL, 0x040fe200078e00ffULL, 0x000088801f547816ULL, 0x040fe200000000ffULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x000054104e4e7816ULL, 0x004fc8000000004bULL,
0x0000004d004d7306ULL, 0x000ea20000202400ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000018ff3d7819ULL, 0x000fe4000001141fULL, 0x000054104f4f7816ULL, 0x002fc6000000004aULL,
0x0000004300437306ULL, 0x000e680000202400ULL, 0x0000004e342c723cULL, 0x000fe2000004182cULL,
0x000054104d1d7816ULL, 0x004fc60000000050ULL, 0x0000004200427306ULL, 0x000ea80000202400ULL,
0x0000001c3430723cULL, 0x000fe80000041830ULL, 0x0000004700477306ULL, 0x000ee60000202400ULL,
0x00005410481c7816ULL, 0x002fc40000000043ULL, 0x00005410671d7816ULL, 0x004fc60000000042ULL,
0x0000004600467306ULL, 0x000e620000202400ULL, 0x000054104c3e7816ULL, 0x008fce0000000047ULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x000054103f3f7816ULL, 0x002fce0000000046ULL,
0x0000004500457306ULL, 0x000e620000202400ULL, 0x0000003e3414723cULL, 0x000fee0000041814ULL,
0x0000004400447306ULL, 0x000fe20000202400ULL, 0x000054103c3c7816ULL, 0x002fce0000000045ULL,
0x0000005700577306ULL, 0x000ff00000202400ULL, 0x00000064005c7306ULL, 0x000ff00000202400ULL,
0x0000005900557306ULL, 0x000e700000202400ULL, 0x0000005400207306ULL, 0x000fe20000202400ULL,
0x000054105c227816ULL, 0x002fce0000000055ULL, 0x0000002100217306ULL, 0x000e700000202400ULL,
0x0000004100417306ULL, 0x000fe20000202400ULL, 0x0000541020237816ULL, 0x002fce0000000021ULL,
0x0000004000407306ULL, 0x000fe20000202400ULL, 0x000000223420723cULL, 0x000fee0000041838ULL,
0x0000001e004a7306ULL, 0x0002b00000202400ULL, 0x0000003d004b7306ULL, 0x0007220000202400ULL,
0x0000001c341c723cULL, 0x002fe20000041824ULL, 0x0106b808ff2479a7ULL, 0x000262000850000bULL,
0x000054104a4a7816ULL, 0x004fc40000000041ULL, 0x00005410443d7816ULL, 0x008fe20000000057ULL,
0x0106a008ffff79a7ULL, 0x0005e2000850000bULL, 0x000054104b4b7816ULL, 0x010fca0000000040ULL,
0x0000003c3418723cULL, 0x000fec0000041818ULL, 0x0000004a3434723cULL, 0x004fde0000041828ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x00000001030e7824ULL, 0x000fca00078e020eULL,
0x000000070e007c0cULL, 0x000fda000bf06070ULL, 0xffffff5800148947ULL, 0x006fea000383ffffULL,
0x0000000000097919ULL, 0x000ee20000002500ULL, 0x000000ffff267224ULL, 0x000fe400078e0012ULL,
0x000000ffff087224ULL, 0x000fe400078e0019ULL, 0x000000ffff287224ULL, 0x000fe400078e002dULL,
0x000000ffff247224ULL, 0x002fe400078e0011ULL, 0x000000ffff127224ULL, 0x000fe200078e0010ULL,
0x0000000709007c0cULL, 0x008fda000bf06070ULL, 0x0000000000dc0947ULL, 0x000fea0003800000ULL,
0x0180000007007836ULL, 0x000fe20000000000ULL, 0x000000d000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e0007ULL,
0x0000ba40000b7802ULL, 0x000fce0000000f00ULL, 0x0000008400587944ULL, 0x004fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e000aULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000700007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc80000000007ULL,
0x800000ff02057221ULL, 0x000fc80000010100ULL, 0x0000000500007223ULL, 0x000fce0000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009400ff047b82ULL, 0x000ee40000000a00ULL,
0x0000000c04057981ULL, 0x008ee2000c1e9900ULL, 0x00000000000d7919ULL, 0x000f240000000000ULL,
0x00000002ff0b7819ULL, 0x010fe4000001160dULL, 0x000000080d0d7811ULL, 0x000fe200078ff0ffULL,
0x0000000005007220ULL, 0x008fca0000410000ULL, 0x00001f0b000b7589ULL, 0x000ee800000e0000ULL,
0x00001f0d00027589ULL, 0x000f2200000e0000ULL, 0x000000120b127220ULL, 0x048fe20000410000ULL,
0x000000240b247220ULL, 0x040fe20000410000ULL, 0x0000002c0b2c7220ULL, 0x040fe20000410000ULL,
0x000000280b287220ULL, 0x040fe20000410000ULL, 0x000000300b307220ULL, 0x040fe20000410000ULL,
0x000000310b317220ULL, 0x040fe20000410000ULL, 0x000000140b147220ULL, 0x040fe20000410000ULL,
0x000000150b157220ULL, 0x040fe20000410000ULL, 0x000000180b187220ULL, 0x040fe20000410000ULL,
0x000000080b087220ULL, 0x040fe20000410000ULL, 0x0000001c0b1c7220ULL, 0x040fe20000410000ULL,
0x0000001d0b1d7220ULL, 0x040fe20000410000ULL, 0x000000200b207220ULL, 0x040fe20000410000ULL,
0x000000210b217220ULL, 0x040fe20000410000ULL, 0x000000340b347220ULL, 0x040fe20000410000ULL,
0x000000350b357220ULL, 0x000fe20000410000ULL, 0x0000002602267220ULL, 0x050fe20000410000ULL,
0x0000001302137220ULL, 0x040fe20000410000ULL, 0x0000002e022e7220ULL, 0x040fe20000410000ULL,
0x0000002f022f7220ULL, 0x040fe20000410000ULL, 0x0000003202327220ULL, 0x040fe20000410000ULL,
0x0000003302337220ULL, 0x040fe20000410000ULL, 0x0000001602167220ULL, 0x040fe20000410000ULL,
0x0000001702177220ULL, 0x040fe20000410000ULL, 0x0000001a021a7220ULL, 0x040fe20000410000ULL,
0x0000001b021b7220ULL, 0x040fe20000410000ULL, 0x0000001e021e7220ULL, 0x040fe20000410000ULL,
0x0000001f021f7220ULL, 0x040fe20000410000ULL, 0x0000002202227220ULL, 0x040fe20000410000ULL,
0x0000002302237220ULL, 0x040fe20000410000ULL, 0x0000003602367220ULL, 0x040fe20000410000ULL,
0x0000003702377220ULL, 0x000fce0000410000ULL, 0x0000000000197919ULL, 0x000ee20000000000ULL,
0x000000141514723eULL, 0x000fe400000010ffULL, 0x000000180808723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000202120723eULL, 0x000fe400000010ffULL,
0x000000261313723eULL, 0x000fe400000010ffULL, 0x0000002e2f2e723eULL, 0x000fe400000010ffULL,
0x000000323332723eULL, 0x000fc400000010ffULL, 0x000000161716723eULL, 0x000fe400000010ffULL,
0x0000001a1b1a723eULL, 0x000fe400000010ffULL, 0x000000010300780cULL, 0x000fe40003f05270ULL,
0x000000222322723eULL, 0x000fe400000010ffULL, 0x0000000219007812ULL, 0x008fe400078ec0ffULL,
0x00000002ff257819ULL, 0x000fc40000011619ULL, 0x00000001ff027819ULL, 0x000fe40000011600ULL,
0x00000004000a7811ULL, 0x040fe400078ff8ffULL, 0x00000008192d7811ULL, 0x000fe400078ff0ffULL,
0x0000000200047811ULL, 0x040fe400078ff8ffULL, 0x00000006000e7811ULL, 0x000fe400078ff8ffULL,
0x0000000702007812ULL, 0x000fc400078e7825ULL, 0x000000070a0c7812ULL, 0x000fe400078e7825ULL,
0x000000070a0a7812ULL, 0x000fe200078e782dULL, 0x00000008250b7824ULL, 0x040fe200078e0200ULL,
0x0000000704057812ULL, 0x000fe200078e7825ULL, 0x0000000825117824ULL, 0x000fe200078e020cULL,
0x000000070e107812ULL, 0x000fe200078e7825ULL, 0x000000082d2b7824ULL, 0x000fe200078e020aULL,
0x0000000702027812ULL, 0x000fe200078e782dULL, 0x00000008190a7824ULL, 0x000fe200078e00ffULL,
0x0000000704047812ULL, 0x000fe200078e782dULL, 0x00000008250d7824ULL, 0x000fe200078e0205ULL,
0x0000000b49007c11ULL, 0x000fe2000f8e58ffULL, 0x000000082d277824ULL, 0x040fe200078e0202ULL,
0x000000070e0e7812ULL, 0x000fe200078e782dULL, 0x000000082d297824ULL, 0x000fe200078e0204ULL,
0x000000080a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000825257824ULL, 0x000fe200078e0210ULL,
0x000000122404723eULL, 0x000fe200000010ffULL, 0x000000082d2d7824ULL, 0x000fe200078e020eULL,
0x0000002c2805723eULL, 0x000fe200000010ffULL, 0x0000a00000027836ULL, 0x000fe20000000000ULL,
0x000000343510723eULL, 0x000fc400000010ffULL, 0x0000541013127816ULL, 0x000fe2000000002eULL,
0x000000100b0b7824ULL, 0x000fe200078e0202ULL, 0x0000763213137816ULL, 0x000fe2000000002eULL,
0x000000100d0d7824ULL, 0x100fe400078e0202ULL, 0x0000001011117824ULL, 0x100fe400078e0202ULL,
0x0000001027277824ULL, 0x100fe400078e0202ULL, 0x0000001029297824ULL, 0x100fe400078e0202ULL,
0x0000001025257824ULL, 0x000fc400078e0202ULL, 0x000000102b2b7824ULL, 0x100fe400078e0202ULL,
0x000000102d2d7824ULL, 0x000fe400078e0202ULL, 0x000000010b0b7824ULL, 0x000fe400078e020aULL,
0x000000010a0d7824ULL, 0x040fe400078e020dULL, 0x000000010a117824ULL, 0x040fe400078e0211ULL,
0x000000010a277824ULL, 0x000fc400078e0227ULL, 0x000000010a297824ULL, 0x040fe400078e0229ULL,
0x000000010a257824ULL, 0x040fe400078e0225ULL, 0x000000010a2b7824ULL, 0x040fe400078e022bULL,
0x000000010a2d7824ULL, 0x000fe200078e022dULL, 0x00000030310a723eULL, 0x000fe400000010ffULL,
0x0000541004307816ULL, 0x140fe40000000005ULL, 0x0000763204317816ULL, 0x000fc40000000005ULL,
0x0000001c1d04723eULL, 0x000fe400000010ffULL, 0x0000763220057816ULL, 0x000fe20000000010ULL,
0x000000300b007388ULL, 0x0007e40000000a00ULL, 0x000054100a307816ULL, 0x148fe40000000014ULL,
0x000076320a317816ULL, 0x000fe40000000014ULL, 0x00005410080a7816ULL, 0x140fe40000000004ULL,
0x00007632080b7816ULL, 0x000fe20000000004ULL, 0x000000300d007388ULL, 0x0007e20000000a00ULL,
0x0000541020047816ULL, 0x000fc60000000010ULL, 0x0000000a11007388ULL, 0x0009e80000000a00ULL,
0x0000000425007388ULL, 0x000be20000000a00ULL, 0x0000001e1f0d723eULL, 0x008fc600000010ffULL,
0x0000001227007388ULL, 0x0007e20000000a00ULL, 0x000000363711723eULL, 0x010fe400000010ffULL,
0x000054101a0c7816ULL, 0x100fe4000000000dULL, 0x0000541032047816ULL, 0x160fe40000000016ULL,
0x0000763232057816ULL, 0x000fe40000000016ULL, 0x000076321a0d7816ULL, 0x000fe4000000000dULL,
0x0000541022107816ULL, 0x140fe20000000011ULL, 0x0000000429007388ULL, 0x0007e20000000a00ULL,
0x0000763222117816ULL, 0x000fc60000000011ULL, 0x0000000c2b007388ULL, 0x0007e80000000a00ULL,
0x000000102d007388ULL, 0x0007e20000000a00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000002400348947ULL, 0x000fea0003800000ULL, 0x0000000000187919ULL, 0x000f220000002700ULL,
0x00008400ff047b82ULL, 0x008f220000000800ULL, 0x00000010190d7824ULL, 0x000fe200078e0200ULL,
0x000000ff4900720cULL, 0x000fe20003f05270ULL, 0x0000000000057919ULL, 0x000f220000002600ULL,
0x00000020191f7836ULL, 0x040fe20000000000ULL, 0x00000400000e7802ULL, 0x000fe20000000f00ULL,
0x00a000000d107984ULL, 0x0006e40000000c00ULL, 0x00009200ff0c7b82ULL, 0x000f620000000800ULL,
0x000000ff1900720cULL, 0x000fe20000725670ULL, 0x00a200000d147984ULL, 0x0006e20000000c00ULL,
0x00000000001b7919ULL, 0x000eea0000008800ULL, 0x00009800ff0a7b82ULL, 0x000ee20000000a00ULL,
0x0000000418187224ULL, 0x010fc400078e0205ULL, 0x0000000403057224ULL, 0x000fe400078e02ffULL,
0x0000000318047224ULL, 0x000fe400078e02ffULL, 0x0000000c050c7224ULL, 0x020fe400078e02ffULL,
0x0000000104207824ULL, 0x000fc600078e0209ULL, 0x00000fff0c057811ULL, 0x000fe400078e40ffULL,
0x000006541b0e7816ULL, 0x00afe4000000000eULL, 0x0000002005097211ULL, 0x000fca00078fa0ffULL,
0x0000100009087825ULL, 0x000fc800078e000aULL, 0x0000040049087825ULL, 0x000fc800078e0008ULL,
0x000000101f1e7825ULL, 0x000fc800078e0008ULL, 0x00000010191c7825ULL, 0x000fe200078e0008ULL,
0x01ffffff0c097812ULL, 0x000fe200078ec0ffULL, 0x0000000000380947ULL, 0x004fec0003800000ULL,
0x00009800ff1a7b82ULL, 0x000e620000000a00ULL, 0x0000000120217824ULL, 0x000fe200078e0209ULL,
0x00000001ff227819ULL, 0x000fe20000011619ULL, 0x0000001019087824ULL, 0x000fc600078e00ffULL,
0x0000000c22227812ULL, 0x000fe200078ec0ffULL, 0x00000080200c7825ULL, 0x002fc800078e001aULL,
0x00000080211a7825ULL, 0x000fe200078e001aULL, 0x0000007008217812ULL, 0x000fc800078ec0ffULL,
0x0000000c220c7210ULL, 0x140fe40007b5e021ULL, 0x0000001a221a7210ULL, 0x000fe40007d9e021ULL,
0x0000000dff0d7210ULL, 0x000fe400017e64ffULL, 0x0000001bff1b7210ULL, 0x000fc600027ea4ffULL,
0x000000060c007986ULL, 0x0003e8000c10190cULL, 0x000000071a007986ULL, 0x0003e4000c10190cULL,
0x000000101c007986ULL, 0x0005e8000c101d0cULL, 0x000000141e007986ULL, 0x0005e2000c101d0cULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000004c1947ULL, 0x000fea0003800000ULL,
0x00009600ff067b82ULL, 0x002e620000000a00ULL, 0xffffffff030d7836ULL, 0x000fe40000000000ULL,
0x0000000418067825ULL, 0x002fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0003ec0000008000ULL,
0x0000000000007992ULL, 0x002fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x0000000d060679a8ULL, 0x000ee800099ee1ccULL,
0x00000000ff00798fULL, 0x008fe20002000000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fc40000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000d0600720cULL, 0x000fc80003f25270ULL, 0x00000001ff087807ULL, 0x000fca0000800000ULL,
0x00000008ff007988ULL, 0x0003e80008000004ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000000e067984ULL, 0x002e640000000000ULL,
0x000000ff0600720cULL, 0x002fda0003f25270ULL, 0x0000002000209947ULL, 0x000fea0003800000ULL,
0x0000000c00300947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x000fda0003f05270ULL,
0x0000000000d88947ULL, 0x000fea0003800000ULL, 0x0000001019087824ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe20000011619ULL, 0x00000001040d7836ULL, 0x040fe40000000000ULL,
0x0000008004067825ULL, 0x100fe200078e000aULL, 0x00000070081d7812ULL, 0x004fe400078ec0ffULL,
0x0000000c0c087812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fc600078e000aULL,
0x0000000608107210ULL, 0x140fe4000791e01dULL, 0x0000000c080c7210ULL, 0x000fe40007b5e01dULL,
0x00000007ff117210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x0000000c10067981ULL, 0x000368000c1e1900ULL, 0x0000000c0c077981ULL, 0x000362000c1e1900ULL,
0x000000020300780cULL, 0x000fda0003f05270ULL, 0x00000000009c8947ULL, 0x002fea0003800000ULL,
0x00000002040d7836ULL, 0x000fc80000000000ULL, 0x000000800d0c7825ULL, 0x000fc600078e000aULL,
0x0000000c080c7210ULL, 0x000fc8000791e01dULL, 0x0000000dff0d7210ULL, 0x000fcc00007e24ffULL,
0x0000000c0c0d7981ULL, 0x000362000c1e1900ULL, 0x000000040300780cULL, 0x000fda0003f06070ULL,
0x0000000000808947ULL, 0x002fea0003800000ULL, 0x0000000304117836ULL, 0x000fc80000000000ULL,
0x0000008011107825ULL, 0x000fc600078e000aULL, 0x0000001008107210ULL, 0x000fc8000791e01dULL,
0x00000011ff117210ULL, 0x000fca00007e24ffULL, 0x0000000c10137981ULL, 0x000362000c1e1900ULL,
0x000000040300780cULL, 0x000fda0003f05270ULL, 0x0000000000648947ULL, 0x002fea0003800000ULL,
0x0000000404117836ULL, 0x000fc80000000000ULL, 0x0000008011107825ULL, 0x000fc600078e000aULL,
0x0000001008107210ULL, 0x000fc8000791e01dULL, 0x00000011ff117210ULL, 0x000fca00007e24ffULL,
0x0000000c10157981ULL, 0x000362000c1e1900ULL, 0x000000060300780cULL, 0x000fda0003f06070ULL,
0x0000000000488947ULL, 0x002fea0003800000ULL, 0x0000000504117836ULL, 0x000fc80000000000ULL,
0x0000008011107825ULL, 0x000fc600078e000aULL, 0x0000001008107210ULL, 0x000fc8000791e01dULL,
0x00000011ff117210ULL, 0x000fca00007e24ffULL, 0x0000000c10177981ULL, 0x000362000c1e1900ULL,
0x000000060300780cULL, 0x000fda0003f05270ULL, 0x00000000002c8947ULL, 0x002fea0003800000ULL,
0x000000080300780cULL, 0x000fe20003f06070ULL, 0x0000000604117836ULL, 0x000fc80000000000ULL,
0x0000008011107825ULL, 0x000fc600078e000aULL, 0x0000001008107210ULL, 0x000fca0007a3e01dULL,
0x00000007041b0836ULL, 0x000fe20000000000ULL, 0x00000011ff117210ULL, 0x000fc60000fe44ffULL,
0x000000801b0a0825ULL, 0x000fe400078e000aULL, 0x0000000c101b7981ULL, 0x000362000c1e1900ULL,
0x0000000a080a0210ULL, 0x000fc80007c7e01dULL, 0x0000000bff0b0210ULL, 0x000fca0001fe84ffULL,
0x0000000c0a1d0981ULL, 0x000368000c1e1900ULL, 0x0000000703087836ULL, 0x000fca0000000000ULL,
0x00000003ff087819ULL, 0x000fc80000011608ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x0000000800248947ULL, 0x000fea0003800000ULL, 0x00009800ff0a7b82ULL, 0x002e620000000a00ULL,
0x000000ffff127224ULL, 0x004fe200078e0004ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1f7224ULL, 0x020fe200078e0006ULL, 0x0000003f00057c82ULL, 0x000fcc0008000000ULL,
0x0000000403007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x0000000508007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400f41947ULL, 0x022fee0003800000ULL,
0x0000000804067890ULL, 0x000fe2000fffe03fULL, 0x0000001f06067209ULL, 0x000fe20007810000ULL,
0x0000000104077890ULL, 0x000fc8000fffe03fULL, 0x0000000603007c0cULL, 0x040fe4000bf23070ULL,
0x0000000703007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010190c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011619ULL,
0x0000000812117836ULL, 0x000fc60000000000ULL, 0x000000700c1f7812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x002fe200078e000aULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x0000001014107210ULL, 0x000fc80007b3e01fULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000c101f7981ULL, 0x000368000c1e1900ULL, 0x0000000400b42947ULL, 0x000fea0003800000ULL,
0x0000000904067890ULL, 0x000fe2000fffe03fULL, 0x0000000706067209ULL, 0x000fe20007810000ULL,
0x0000000204077890ULL, 0x000fc8000fffe03fULL, 0x0000000603007c0cULL, 0x040fe4000bf23070ULL,
0x0000000703007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001019077824ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011619ULL,
0x0000000912117836ULL, 0x002fc60000000000ULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e000aULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000100c107210ULL, 0x000fc80007b3e007ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000c10077981ULL, 0x000368000c1e1900ULL, 0x0000000400742947ULL, 0x000fea0003800000ULL,
0x0000000a04067890ULL, 0x000fe2000fffe03fULL, 0x0000000d06067209ULL, 0x000fe20007810000ULL,
0x0000000304077890ULL, 0x000fc8000fffe03fULL, 0x0000000603007c0cULL, 0x040fe4000bf23070ULL,
0x0000000703007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010190c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x002fe20000011619ULL,
0x0000000a120d7836ULL, 0x000fc60000000000ULL, 0x000000700c117812ULL, 0x000fe200078ec0ffULL,
0x000000800d0c7825ULL, 0x000fe200078e000aULL, 0x0000000c10107812ULL, 0x000fc800078ec0ffULL,
0x0000000c100c7210ULL, 0x000fc80007b3e011ULL, 0x0000000dff0d7210ULL, 0x000fcc0000fe64ffULL,
0x0000000c0c0d7981ULL, 0x000366000c1e1900ULL, 0x0000000400342947ULL, 0x000fea0003800000ULL,
0x0000000b04067890ULL, 0x000fe2000fffe03fULL, 0x0000001306067209ULL, 0x000fe20007810000ULL,
0x0000000404077890ULL, 0x000fc8000fffe03fULL, 0x0000000603007c0cULL, 0x040fe4000bf23070ULL,
0x0000000703007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010190c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011619ULL,
0x0000000b12117836ULL, 0x000fc60000000000ULL, 0x000000700c137812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e000aULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x0000001014107210ULL, 0x000fc80007b3e013ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000c10137981ULL, 0x000368000c1e1900ULL, 0x0000000000f42947ULL, 0x000fea0003800000ULL,
0x0000000c04067890ULL, 0x000fe2000fffe03fULL, 0x0000001506067209ULL, 0x000fe20007810000ULL,
0x0000000504077890ULL, 0x000fc8000fffe03fULL, 0x0000000603007c0cULL, 0x040fe4000bf23070ULL,
0x0000000703007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010190c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011619ULL,
0x0000000c12117836ULL, 0x000fc60000000000ULL, 0x000000700c157812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e000aULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x0000001014107210ULL, 0x000fc80007b3e015ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000c10157981ULL, 0x000368000c1e1900ULL, 0x0000000000b42947ULL, 0x000fea0003800000ULL,
0x0000000d04067890ULL, 0x000fe2000fffe03fULL, 0x0000001706067209ULL, 0x000fe20007810000ULL,
0x0000000604077890ULL, 0x000fc8000fffe03fULL, 0x0000000603007c0cULL, 0x040fe4000bf23070ULL,
0x0000000703007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010190c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011619ULL,
0x0000000d12117836ULL, 0x000fc60000000000ULL, 0x000000700c177812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e000aULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x0000001014107210ULL, 0x000fc80007b3e017ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000c10177981ULL, 0x000368000c1e1900ULL, 0x0000000000742947ULL, 0x000fea0003800000ULL,
0x0000000e04067890ULL, 0x000fe2000fffe03fULL, 0x0000001b06067209ULL, 0x000fe20007810000ULL,
0x0000000704077890ULL, 0x000fc8000fffe03fULL, 0x0000000603007c0cULL, 0x040fe4000bf23070ULL,
0x0000000703007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010190c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011619ULL,
0x0000000e12117836ULL, 0x000fc60000000000ULL, 0x000000700c1b7812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e000aULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x0000001014107210ULL, 0x000fc80007b3e01bULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000c101b7981ULL, 0x000368000c1e1900ULL, 0x0000000000342947ULL, 0x000fea0003800000ULL,
0x0000000f04067890ULL, 0x000fe2000fffe03fULL, 0x0000001d06067209ULL, 0x000fca0007810000ULL,
0x0000000603007c0cULL, 0x000fda000bf23070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010190c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011619ULL,
0x0000000f12117836ULL, 0x000fc60000000000ULL, 0x000000700c1d7812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e000aULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x0000001014107210ULL, 0x000fc80007a3e01dULL, 0x00000011ff117210ULL, 0x000fca0000fe44ffULL,
0x0000000c101d7981ULL, 0x000368000c1e1900ULL, 0x0000000804047890ULL, 0x000fe2000fffe03fULL,
0x0000000812127836ULL, 0x000fe20000000000ULL, 0xfffffff400f08947ULL, 0x000ff4000383ffffULL,
0x0000000000197919ULL, 0x000ee40000000000ULL, 0x0000001019077824ULL, 0x028fe200078e00ffULL,
0x00000001ff087819ULL, 0x000fc80000011619ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fc800078ec0ffULL, 0x0000000e08077210ULL, 0x000fca0007ffe007ULL,
0x0000000607007388ULL, 0x0007e40000000800ULL, 0x00009800ff0c7b82ULL, 0x002e620000000a00ULL,
0x0000000405057211ULL, 0x000fe200078fa0ffULL, 0x0000040049187824ULL, 0x000fe200078e00ffULL,
0x000000071900780cULL, 0x040fe20003f04070ULL, 0x00000010191b7824ULL, 0x040fe200078e00ffULL,
0x00000016ff1a7819ULL, 0x000fe20000011649ULL, 0x0000000104457824ULL, 0x000fe200078e0209ULL,
0x00000001ff1d7819ULL, 0x004fe20000011619ULL, 0x0000002019097836ULL, 0x000fe20000000000ULL,
0x000000701b1b7812ULL, 0x000fe200078ec0ffULL, 0x00001000491c7824ULL, 0x000fe200078e020eULL,
0x0000000c1d1d7812ULL, 0x000fc400078ec0ffULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000001019117824ULL, 0x000fe200078e021cULL,
0x0000000e1d1e7210ULL, 0x000fe20007ffe01bULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000010049108824ULL, 0x140fe200078e020eULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000010049128824ULL, 0x000fe200078e020eULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000001019138824ULL, 0x040fe200078e0210ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000001019158824ULL, 0x000fe200078e0212ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000100005067825ULL, 0x00afe200078e000cULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000080450a8825ULL, 0x100fe200078e000cULL, 0x0000001806067210ULL, 0x000fe40007f3e0ffULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x00000080040c8825ULL, 0x000fe200078e000cULL, 0x0000000000287805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000107077824ULL, 0x000fe200008e061aULL, 0x000000ff0300720cULL, 0x000fe20003f25270ULL,
0x00000010190a8825ULL, 0x000fe200078e000aULL, 0x000000001e1e7984ULL, 0x000e620000000800ULL,
0x00000000003c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000001009087825ULL, 0x000fc800078e0006ULL, 0x0000001019067825ULL, 0x000fc800078e0006ULL,
0x00000010190c8825ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000006117faeULL, 0x0005e6000b901c4cULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x0038000008117faeULL, 0x0005e8000b901c4cULL, 0x045800000a138faeULL, 0x0005e8000b901c4cULL,
0x041800000c158faeULL, 0x0005e8000b901c4cULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000008009c9947ULL, 0x000fea0003800000ULL, 0x00009800ff0c7b82ULL, 0x004ea20000000a00ULL,
0x00000003ff067819ULL, 0x100fe20000011619ULL, 0x0000000145457836ULL, 0x000fe20000000000ULL,
0xfffffff8ff077812ULL, 0x000fe200078ee219ULL, 0x0000000105477836ULL, 0x000fe20000000000ULL,
0x0000000306067812ULL, 0x000fe200078ec0ffULL, 0x00000001044b7836ULL, 0x000fe20000000000ULL,
0x00000002ff467819ULL, 0x000fe20000011619ULL, 0x0000000807097836ULL, 0x040fe20000000000ULL,
0x0000000406087812ULL, 0x000fe200078efcffULL, 0x0000000807417824ULL, 0x000fe200078e00ffULL,
0x0000000706407812ULL, 0x000fe200078e7807ULL, 0x0000000809437824ULL, 0x000fe200078e00ffULL,
0x0000000706427812ULL, 0x000fe200078e7809ULL, 0x00000001ff447424ULL, 0x000fe200078e00ffULL,
0x0000000708067812ULL, 0x000fe200078e7807ULL, 0x000000ffff3f7224ULL, 0x000fe200078e00ffULL,
0x0000000708087812ULL, 0x000fe200078e7809ULL, 0x00000100494a7824ULL, 0x000fe200078e020eULL,
0x0000004140407212ULL, 0x000fe200078efcffULL, 0x0000000846487836ULL, 0x000fe20000000000ULL,
0x0000004342427212ULL, 0x000fc400078efcffULL, 0x0000004106417212ULL, 0x000fe400078efcffULL,
0x0000004308437212ULL, 0x004fce00078efcffULL, 0x000000034400720cULL, 0x000fda0003f06070ULL,
0x0000000000700947ULL, 0x000fea0003800000ULL, 0x0000100047047825ULL, 0x000fe200078e000cULL,
0x000000071900780cULL, 0x040fe40003f24070ULL, 0x0000000144137812ULL, 0x040fe200078ec0ffULL,
0x0000002019157836ULL, 0x000fe20000000000ULL, 0x00000018040a7210ULL, 0x000fe20007f1e0ffULL,
0x0000080044047824ULL, 0x000fc800078e00ffULL, 0x00000001050b7824ULL, 0x000fe200000e061aULL,
0x0000080004097812ULL, 0x000fc600078ec0ffULL, 0x00000100494a9824ULL, 0x000fe400078e020eULL,
0x000000011c087824ULL, 0x000fe400078e0209ULL, 0x0000008045069825ULL, 0x000fc800078e000cULL,
0x000000804b049825ULL, 0x000fc800078e000cULL, 0x0000008013109824ULL, 0x000fe400078e024aULL,
0x0000001019117824ULL, 0x000fe400078e0208ULL, 0x0000008013129824ULL, 0x000fe400078e024aULL,
0x0000001015087825ULL, 0x000fc800078e000aULL, 0x00000010190a7825ULL, 0x000fc800078e000aULL,
0x0000001019069825ULL, 0x040fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a117faeULL, 0x0005e6000b901c4cULL, 0x0000001019139824ULL, 0x040fe200078e0210ULL,
0x0038000008117faeULL, 0x0005e2000b901c4cULL, 0x0000001019049825ULL, 0x000fc600078e0004ULL,
0x0458000006139faeULL, 0x0005e2000b901c4cULL, 0x0000001019159824ULL, 0x000fca00078e0212ULL,
0x0418000004159faeULL, 0x0005e4000b901c4cULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff44047836ULL, 0x044fe20000000000ULL, 0x000000034400720cULL, 0x040fe20003f06070ULL,
0x0000000144447836ULL, 0x000fe40000000000ULL, 0x0000008004057824ULL, 0x040fe400078e00ffULL,
0x0000080004047824ULL, 0x000fe400078e00ffULL, 0x0000000145457836ULL, 0x000fe20000000000ULL,
0x0000008005057812ULL, 0x000fe200078ec0ffULL, 0x0000000147477836ULL, 0x000fc40000000000ULL,
0x000000014b4b7836ULL, 0x000fe20000000000ULL, 0x0000004a1b067210ULL, 0x000fe40007ffe005ULL,
0x0000080004057812ULL, 0x000fc600078ec0ffULL, 0x000000011d4c7824ULL, 0x000fe200078e0206ULL,
0x000001801c147810ULL, 0x000fe20007ffe005ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180004c117984ULL, 0x000ea20000000800ULL, 0x0000001040047824ULL, 0x100fe400078e0214ULL,
0x0000001041087824ULL, 0x100fe200078e0214ULL, 0x004580004c4e7984ULL, 0x000fe20000000800ULL,
0x0000001042107824ULL, 0x100fe400078e0214ULL, 0x0000001043147824ULL, 0x000fe200078e0214ULL,
0x000000000404783bULL, 0x000ee80000000200ULL, 0x000000000808783bULL, 0x000f220000000200ULL,
0x000000111e157221ULL, 0x006fc60000010100ULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x3fb8aa3b15537820ULL, 0x000fc60000410000ULL, 0x000000001414783bULL, 0x000ea20000000200ULL,
0x00007632044c7816ULL, 0x008fe2000000004cULL, 0x0001000007527824ULL, 0x040fe200078e00ffULL,
0x0000005300537308ULL, 0x000ee20000000800ULL, 0x0000763207507816ULL, 0x000fe20000000050ULL,
0x0001000009547824ULL, 0x010fe200078e00ffULL, 0x0000763208077816ULL, 0x000fe20000000007ULL,
0x000100000a557824ULL, 0x000fe200078e00ffULL, 0x00007632054d7816ULL, 0x000fe2000000004dULL,
0x0001000004047824ULL, 0x000fe200078e00ffULL, 0x00007632064f7816ULL, 0x000fe2000000004fULL,
0x000100000b567824ULL, 0x000fc400078e00ffULL, 0x0001000006517824ULL, 0x000fe400078e00ffULL,
0x000100004f067824ULL, 0x000fe400078e00ffULL, 0x0001000050507824ULL, 0x000fe400078e00ffULL,
0x0000004e535f7220ULL, 0x008fe20000410000ULL, 0x0001000008537824ULL, 0x000fe200078e00ffULL,
0x0000763209087816ULL, 0x000fe20000000008ULL, 0x00010000054e7824ULL, 0x000fe400078e00ffULL,
0x0000003e5f3e7221ULL, 0x000fe20000010000ULL, 0x00001f465f607589ULL, 0x000ee200000e0000ULL,
0x000076320a097816ULL, 0x000fe20000000009ULL, 0x000100004c057824ULL, 0x000fe200078e00ffULL,
0x000076320b0a7816ULL, 0x000fe2000000000aULL, 0x00001f485f5f7589ULL, 0x000f2200000e0000ULL,
0x0001000008087824ULL, 0x000fe200078e00ffULL, 0x00007632100b7816ULL, 0x042fe2000000000bULL,
0x0001000010577824ULL, 0x000fe200078e00ffULL, 0x0000763211107816ULL, 0x040fe20000000010ULL,
0x0001000011587824ULL, 0x000fe200078e00ffULL, 0x0000763212117816ULL, 0x040fe20000000011ULL,
0x0001000012597824ULL, 0x000fe200078e00ffULL, 0x0000763213127816ULL, 0x040fe20000000012ULL,
0x00010000135a7824ULL, 0x000fe200078e00ffULL, 0x0000763214137816ULL, 0x044fe20000000013ULL,
0x00010000145b7824ULL, 0x000fe200078e00ffULL, 0x0000763215147816ULL, 0x040fe20000000014ULL,
0x00010000155c7824ULL, 0x000fc400078e00ffULL, 0x00000060041f7223ULL, 0x088fe2000001001fULL,
0x0000006005307223ULL, 0x080fe20000010030ULL, 0x000100004d047824ULL, 0x000fe200078e00ffULL,
0x0000763216157816ULL, 0x000fe20000000015ULL, 0x000100000a057824ULL, 0x000fe200078e00ffULL,
0x00007632175d7816ULL, 0x000fe2000000005dULL, 0x00000060042d7223ULL, 0x080fe2000001002dULL,
0x0001000007047824ULL, 0x000fe400078e00ffULL, 0x0000006005207223ULL, 0x000fe20000010020ULL,
0x0001000010057824ULL, 0x000fc400078e00ffULL, 0x000000604e3d7223ULL, 0x080fe2000001003dULL,
0x0000006004277223ULL, 0x080fe20000010027ULL, 0x0001000009047824ULL, 0x000fe400078e00ffULL,
0x0000005f052c7223ULL, 0x090fe2000001002cULL, 0x0001000012057824ULL, 0x000fe400078e00ffULL,
0x00000060513c7223ULL, 0x080fe2000001003cULL, 0x0000006004237223ULL, 0x000fe20000010023ULL,
0x0001000016167824ULL, 0x000fe400078e00ffULL, 0x0000005f05287223ULL, 0x000fe20000010028ULL,
0x00010000175e7824ULL, 0x000fc400078e00ffULL, 0x00000060062b7223ULL, 0x080fe2000001002bULL,
0x000100000b0b7824ULL, 0x000fe400078e00ffULL, 0x00000060523b7223ULL, 0x080fe2000001003bULL,
0x0001000011117824ULL, 0x000fe400078e00ffULL, 0x0000006050297223ULL, 0x080fe20000010029ULL,
0x0001000013137824ULL, 0x000fe400078e00ffULL, 0x00000060533a7223ULL, 0x000fe2000001003aULL,
0x0001000014057824ULL, 0x000fc400078e00ffULL, 0x0000006054397223ULL, 0x080fe20000010039ULL,
0x0001000015157824ULL, 0x000fe400078e00ffULL, 0x0000006008257223ULL, 0x080fe20000010025ULL,
0x000100005d047824ULL, 0x000fe400078e00ffULL, 0x0000006055387223ULL, 0x080fe20000010038ULL,
0x0000006056377223ULL, 0x000fe20000010037ULL, 0x0000005f57367223ULL, 0x080fe20000010036ULL,
0x0000005f0b2e7223ULL, 0x080fe2000001002eULL, 0x0000005f58357223ULL, 0x080fe20000010035ULL,
0x0000005f59347223ULL, 0x080fe20000010034ULL, 0x0000005f112a7223ULL, 0x080fe2000001002aULL,
0x0000005f5a337223ULL, 0x080fe20000010033ULL, 0x0000005f5b327223ULL, 0x080fe20000010032ULL,
0x0000005f13267223ULL, 0x080fe20000010026ULL, 0x0000005f5c317223ULL, 0x080fe20000010031ULL,
0x0000005f05247223ULL, 0x080fe20000010024ULL, 0x0000005f162f7223ULL, 0x080fe2000001002fULL,
0x0000005f15227223ULL, 0x080fe20000010022ULL, 0x0000005f5e217223ULL, 0x080fe20000010021ULL,
0x0000005f043f7223ULL, 0x000fe2000001003fULL, 0xfffffff400c48947ULL, 0x000fec000383ffffULL,
0x018000003e037836ULL, 0x000fe20000000000ULL, 0x0000000000007b1dULL, 0x000fe80000010000ULL,
0x7f80000003037812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000e230000b7802ULL, 0x004fce0000000f00ULL,
0x0000005c005c7944ULL, 0x002fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e000aULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000003e00037308ULL, 0x000ee40000001000ULL,
0xbf80000003047423ULL, 0x008fc8000000003eULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000403037223ULL, 0x000fce0000000003ULL, 0x0000000000197919ULL, 0x000ee40000000000ULL,
0x00000002ff047819ULL, 0x108fe40000011619ULL, 0x00000008190a7811ULL, 0x004fe400078ff0ffULL,
0x00000003ff0c7819ULL, 0x000fe20000011619ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0403047589ULL, 0x000ea200000e0000ULL, 0xfffffff8ff157812ULL, 0x000fc600078ee219ULL,
0x00001f0a030d7589ULL, 0x00072400000e0000ULL, 0x0000000815177836ULL, 0x000fe20000000000ULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x0000000817127824ULL, 0x000fe400078e00ffULL,
0x0000001f041f7220ULL, 0x044fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003d04057220ULL, 0x040fe20000410000ULL, 0x0000002d04067220ULL, 0x040fe20000410000ULL,
0x0000003c043c7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000003b04077220ULL, 0x040fe20000410000ULL, 0x0000002904087220ULL, 0x040fe20000410000ULL,
0x0000003a043a7220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000003904097220ULL, 0x040fe20000410000ULL, 0x00000025040a7220ULL, 0x048fe20000410000ULL,
0x0000003804387220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x00000037040b7220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x000fe20000410000ULL,
0x000000030c047812ULL, 0x000fe200078ec0ffULL, 0x000000360d367220ULL, 0x050fe20000410000ULL,
0x0000002e0d037220ULL, 0x040fe20000410000ULL, 0x000000350d357220ULL, 0x040fe20000410000ULL,
0x0000000404107812ULL, 0x000fe200078efcffULL, 0x0000002c0d2c7220ULL, 0x040fe20000410000ULL,
0x000000340d347220ULL, 0x040fe20000410000ULL, 0x0000002a0d117220ULL, 0x040fe20000410000ULL,
0x000000330d337220ULL, 0x040fe20000410000ULL, 0x000000280d287220ULL, 0x040fe20000410000ULL,
0x000000320d327220ULL, 0x040fe20000410000ULL, 0x000000260d137220ULL, 0x040fe20000410000ULL,
0x000000310d317220ULL, 0x040fe20000410000ULL, 0x000000240d247220ULL, 0x040fe20000410000ULL,
0x0000002f0d2f7220ULL, 0x040fe20000410000ULL, 0x000000220d227220ULL, 0x040fe20000410000ULL,
0x000000210d217220ULL, 0x040fe20000410000ULL, 0x0000003f0d0c7220ULL, 0x000fe20000410000ULL,
0x00000008150d7824ULL, 0x000fe200078e00ffULL, 0x00000007040e7812ULL, 0x000fc400078e7815ULL,
0x00000007041b7812ULL, 0x000fe400078e7817ULL, 0x0000000710047812ULL, 0x000fe400078e7815ULL,
0x00000007101d7812ULL, 0x000fe400078e7817ULL, 0x0000000d0e157212ULL, 0x080fe400078efcffULL,
0x0000000d04177212ULL, 0x000fe400078efcffULL, 0x000000121b1b7212ULL, 0x080fe200078efcffULL,
0x00000010150d7824ULL, 0x100fe200078e0202ULL, 0x000000121d1d7212ULL, 0x000fe200078efcffULL,
0x00000010170e7824ULL, 0x100fe200078e0202ULL, 0x000000050605723eULL, 0x000fe200000010ffULL,
0x000000101b107824ULL, 0x100fe200078e0202ULL, 0x0000001f3004723eULL, 0x000fe200000010ffULL,
0x000000101d027824ULL, 0x000fe200078e0202ULL, 0x0000003c2b06723eULL, 0x000fc400000010ffULL,
0x000000070807723eULL, 0x000fe400000010ffULL, 0x000000090a09723eULL, 0x000fe400000010ffULL,
0x0000003a2708723eULL, 0x000fe200000010ffULL, 0x000000040d007844ULL, 0x0005e20000000200ULL,
0x00000038230a723eULL, 0x000fe400000010ffULL, 0x0000000b200b723eULL, 0x000fe400000010ffULL,
0x000000360314723eULL, 0x000fc400000010ffULL, 0x000000352c15723eULL, 0x000fe200000010ffULL,
0x000000080e007844ULL, 0x0005e20000000200ULL, 0x000000341116723eULL, 0x000fe400000010ffULL,
0x000000332817723eULL, 0x000fe400000010ffULL, 0x000000321330723eULL, 0x000fe400000010ffULL,
0x000000312431723eULL, 0x000fe200000010ffULL, 0x0000001410007844ULL, 0x0005e20000000200ULL,
0x0000002f2232723eULL, 0x000fc400000010ffULL, 0x000000210c33723eULL, 0x000fca00000010ffULL,
0x0000003002007844ULL, 0x0005e20000000200ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000067919ULL, 0x004ea20000002600ULL, 0x00000020190d7836ULL, 0x048fe20000000000ULL,
0x00000003ff0c7819ULL, 0x000fe20000011619ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x00000007190e7812ULL, 0x000fe200078ec0ffULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000003ff047819ULL, 0x000fe4000001160dULL,
0x000000070c027812ULL, 0x000fe400078e4819ULL, 0x0000000704057812ULL, 0x000fc400078e480dULL,
0x0ffffff802037812ULL, 0x000fe400078ef819ULL, 0x0ffffff805057812ULL, 0x000fc600078ef80dULL,
0x0000001003037824ULL, 0x100fe400078e0200ULL, 0x0000001005057824ULL, 0x000fc600078e0200ULL,
0x00a0000003087984ULL, 0x000f280000000c00ULL, 0x00a0000005107984ULL, 0x000b220000000c00ULL,
0x00000005040472a4ULL, 0x008fe2000f8e023fULL, 0x0000000806077824ULL, 0x044fe400078e00ffULL,
0x0000000806157824ULL, 0x000fc600078e00ffULL, 0xfffffff807007812ULL, 0x000fe400078ee20cULL,
0xfffffff815047812ULL, 0x000fe400078ee204ULL, 0x0000000400077c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000404067c10ULL, 0x000fe2000ff3e0ffULL, 0x0000860000047ab9ULL, 0x000fe20000000a00ULL,
0x000000070d007812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x0000000407027c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff057224ULL, 0x020fe200008e06ffULL,
0x0000000406047c11ULL, 0x000fc4000f8248ffULL, 0x0000000507037c11ULL, 0x000fe400080f4c0cULL,
0x1ffffff80e077812ULL, 0x000fe400078ef80fULL, 0x0000000506057c11ULL, 0x000fe400088f4c05ULL,
0x1ffffff8000f7812ULL, 0x000fe200078ef80fULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x000000100f047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x010fe8000c101d0cULL,
0x0000001004007986ULL, 0x002fe2000c101d0cULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000040e047824ULL, 0x000fe200078e0249ULL, 0x00009400ff127b82ULL, 0x000e620000000a00ULL,
0x00000001ff087424ULL, 0x000fc600078e00ffULL, 0x0000000604007c0cULL, 0x000fe2000bf06070ULL,
0x01060008ff0c79a7ULL, 0x000498000850000bULL, 0x00009000ff078b82ULL, 0x000ee20000000800ULL,
0x000000020b058824ULL, 0x000fe200078e00ffULL, 0x0000000c120a7981ULL, 0x00256c000c1e9900ULL,
0x00008c00ff108b82ULL, 0x000e620000000a00ULL, 0x0000000705058224ULL, 0x008fc800078e0204ULL,
0x0000000405108825ULL, 0x002fc800078e0010ULL, 0xffffffffff057424ULL, 0x000fcc00078e00ffULL,
0x0000000c10058981ULL, 0x000ee2000c1e1900ULL, 0x000000010e077836ULL, 0x000fca0000000000ULL,
0x0000000707007c0cULL, 0x000fe2000bf06070ULL, 0x0000000608087899ULL, 0x000fe2000800063fULL,
0x0000004049077824ULL, 0x000fe400078e00ffULL, 0x0000004000097824ULL, 0x000fc600078e00ffULL,
0x0000000805287c24ULL, 0x008fcc000f8e02ffULL, 0x0000000400d08947ULL, 0x004fea0003800000ULL,
0x00000002ff227819ULL, 0x100fe20000011602ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000003ff197819ULL, 0x000fe40000011602ULL, 0x0000003006237812ULL, 0x000fe200078ec0ffULL,
0x0000004000107824ULL, 0x000fe200078e0222ULL, 0x0000000319197812ULL, 0x000fe200078e4802ULL,
0x000001000e007824ULL, 0x000fe400078e0207ULL, 0x0000000810117836ULL, 0x040fe20000000000ULL,
0x00000010281a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001010127836ULL, 0x000fe20000000000ULL,
0x0000000e000f7c48ULL, 0x000fe2000ffe0000ULL, 0x0000001810067836ULL, 0x000fe20000000000ULL,
0x0000001128207210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x000000041a167c11ULL, 0x000fe2000f8040ffULL, 0x000000010f0f7824ULL, 0x000fe200078e0a00ULL,
0x0000001228127210ULL, 0x000fe20007f5e0ffULL, 0x0000003810147836ULL, 0x000fe20000000000ULL,
0x000000051a1a7c11ULL, 0x000fe200080f4413ULL, 0x000000ffff137224ULL, 0x000fe200008e06ffULL,
0x00000004201f7c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x0000000412157c11ULL, 0x000fe2000f8240ffULL, 0x0000000822247836ULL, 0x000fe20000000000ULL,
0x0000000b49007c11ULL, 0x000fc4000f8e68ffULL, 0x0000000f2200720cULL, 0x000fe40003f66070ULL,
0x0000000520207c11ULL, 0x000fe200080f4413ULL, 0x00002000001b7836ULL, 0x000fe20000000000ULL,
0x0000000512187c11ULL, 0x000fe200088f4411ULL, 0x0000002010117836ULL, 0x040fe20000000000ULL,
0x0ffffffc19007812ULL, 0x000fe200078ef802ULL, 0x0000002810127836ULL, 0x040fe20000000000ULL,
0x0000000628067210ULL, 0x000fe20007f3e0ffULL, 0x0000003010137836ULL, 0x000fe20000000000ULL,
0x0000001623107210ULL, 0x000fe20007f1e0ffULL, 0x00000010001d7824ULL, 0x000fe200078e021bULL,
0x0000001128217210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x00000012281e7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff117224ULL, 0x000fe200000e061aULL,
0x0000000406167c11ULL, 0x000fe2000f8840ffULL, 0x0000001022007836ULL, 0x000fe20000000000ULL,
0x00000013281c7210ULL, 0x000fc40007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101d7faeULL, 0x0003e2000d901c4cULL, 0x000000231f127210ULL, 0x000fe40007f7e0ffULL,
0x00000014281a7210ULL, 0x000fe40007f3e0ffULL, 0x0000000506177c11ULL, 0x000fe2000a0f4417ULL,
0x000000ffff137224ULL, 0x000fe200018e0620ULL, 0x0000002315147210ULL, 0x000fe20007f9e0ffULL,
0x0000001822067836ULL, 0x000fe20000000000ULL, 0x0000000f2400720cULL, 0x0c0fe20003f66070ULL,
0x0000000424247824ULL, 0x000fe200078e00ffULL, 0x0000002316167210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff157224ULL, 0x000fe200020e0618ULL, 0x0000000f0000720cULL, 0x040fe20003f86070ULL,
0x0000000400107824ULL, 0x002fe200078e00ffULL, 0xfffffffc24007812ULL, 0x000fe200078ee219ULL,
0x0000000406267824ULL, 0x000fc400078e00ffULL, 0x000000ffff177224ULL, 0x000fe200028e0617ULL,
0x0000000f0600720cULL, 0x080fe20003fa6070ULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0xfffffffc10067812ULL, 0x000fe200078ee219ULL, 0x0000001000117824ULL, 0x100fe200078e021bULL,
0xfffffffc26107812ULL, 0x000fe200078ee219ULL, 0x0000002022007836ULL, 0x000fe20000000000ULL,
0x0000000421207c11ULL, 0x040fe2000f8440ffULL, 0x00000010061d7824ULL, 0x100fe200078e021bULL,
0x0000000012117faeULL, 0x0003e2000d901c4cULL, 0x00000010101f7824ULL, 0x100fe200078e021bULL,
0x0000000521217c11ULL, 0x000fe200090f4418ULL, 0x0000003022107836ULL, 0x000fe20000000000ULL,
0x0000000f0000720cULL, 0x0c0fe20003f46070ULL, 0x0000000400007824ULL, 0x000fe200078e00ffULL,
0x00000000141d7faeULL, 0x0005e2000e101c4cULL, 0x0000002822067836ULL, 0x000fe20000000000ULL,
0x0000000f1000720cULL, 0x080fe20003f86070ULL, 0x0000003822187836ULL, 0x000fe20000000000ULL,
0xfffffffc00007812ULL, 0x000fe200078ee219ULL, 0x0000000410107824ULL, 0x000fe200078e00ffULL,
0x00000000161f7faeULL, 0x0007e2000e901c4cULL, 0x0000000f0600720cULL, 0x0c0fe20003f66070ULL,
0x0000000406067824ULL, 0x000fe200078e00ffULL, 0x0000000f1800720cULL, 0x000fe20003fa6070ULL,
0x00000010000f7824ULL, 0x100fe200078e021bULL, 0xfffffffc10107812ULL, 0x000fe200078ee219ULL,
0x0000000418127824ULL, 0x002fe200078e00ffULL, 0xfffffffc06067812ULL, 0x000fe200078ee219ULL,
0x000000ffff157224ULL, 0x004fe200000e06ffULL, 0x000000041c147c11ULL, 0x000fe2000f8040ffULL,
0x00000010101d7824ULL, 0x100fe200078e021bULL, 0xfffffffc12127812ULL, 0x000fe200078ee219ULL,
0x000000ffff177224ULL, 0x008fe200030e06ffULL, 0x000000041e007c11ULL, 0x000fe2000f8c40ffULL,
0x0000001006197824ULL, 0x000fe200078e021bULL, 0x000000051c067c11ULL, 0x000fe200080f4415ULL,
0x00000010121b7824ULL, 0x000fe200078e021bULL, 0x000000051e177c11ULL, 0x000fe2000b0f4417ULL,
0x000000ffff137224ULL, 0x000fe200008e06ffULL, 0x0000002320107210ULL, 0x000fc40007fde0ffULL,
0x0000002300127210ULL, 0x000fe40007f3e0ffULL, 0x0000002314147210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff117224ULL, 0x000fe200030e0621ULL, 0x000000041a167c11ULL, 0x000fc6000f8c40ffULL,
0x000000ffff157224ULL, 0x000fe200000e0606ULL, 0x000000051a007c11ULL, 0x000fe2000b0f4413ULL,
0x000000ffff137224ULL, 0x000fe200008e0617ULL, 0x0000002316167210ULL, 0x000fe20007f3e0ffULL,
0x00000000100f7faeULL, 0x0003e8000d101c4cULL, 0x000000ffff177224ULL, 0x000fe200008e0600ULL,
0x0000000012197faeULL, 0x0003e8000d901c4cULL, 0x00000000141d7faeULL, 0x0003e8000e101c4cULL,
0x00000000161b7faeULL, 0x0003e2000e901c4cULL, 0x00000004009c7947ULL, 0x000fea0003800000ULL,
0x0000000902007211ULL, 0x040fe200078ff0ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000802207811ULL, 0x040fe400078ff0ffULL, 0x0000000028007210ULL, 0x000fe40007f1e0ffULL,
0x0000001002107811ULL, 0x040fe400078ff0ffULL, 0x0000002002147811ULL, 0x000fe200078ff0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e06ffULL, 0x0000000400247c11ULL, 0x000fc4000f8040ffULL,
0x0000002802167811ULL, 0x000fe200078ff0ffULL, 0x0000000109137824ULL, 0x040fe200078e0214ULL,
0x0000000500267c11ULL, 0x000fe200080f440fULL, 0x0000000120007824ULL, 0x000fe200078e0209ULL,
0x0000001802127811ULL, 0x040fe200078ff0ffULL, 0x00000001090f7824ULL, 0x040fe200078e0210ULL,
0x00000003ff217819ULL, 0x000fe20000011602ULL, 0x0000000109157824ULL, 0x040fe200078e0216ULL,
0x0000003002187811ULL, 0x000fe200078ff0ffULL, 0x0000000410107824ULL, 0x000fe200078e00ffULL,
0x00000038021a7811ULL, 0x000fe200078ff0ffULL, 0x0000000416167824ULL, 0x000fe200078e00ffULL,
0x0000000028227210ULL, 0x000fe20007fde0ffULL, 0x0000000109117824ULL, 0x000fe200078e0212ULL,
0x0000000b491e7c11ULL, 0x000fe2000f8e68ffULL, 0x0000000420007824ULL, 0x000fe200078e00ffULL,
0x0000000321217812ULL, 0x000fe200078e4802ULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0x0000000f281c7210ULL, 0x000fe20007fbe0ffULL, 0x0000000109177824ULL, 0x040fe200078e0218ULL,
0x00000013281d7210ULL, 0x000fe20007f3e0ffULL, 0x0000000109197824ULL, 0x000fe200078e021aULL,
0xfffffffc10107812ULL, 0x000fe200078ee221ULL, 0x0000000414147824ULL, 0x000fe200078e00ffULL,
0xfffffffc16137812ULL, 0x000fe200078ee221ULL, 0x0000000418187824ULL, 0x000fe200078e00ffULL,
0x00000011281f7210ULL, 0x000fe20007f1e0ffULL, 0x000000041a1a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc00007812ULL, 0x000fe200078ee221ULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x0000000422207c11ULL, 0x000fe2000f8c40ffULL, 0x000020001e2b7836ULL, 0x000fe20000000000ULL,
0x0ffffffc21167812ULL, 0x000fc400078ef802ULL, 0xfffffffc12117812ULL, 0x000fe200078ee221ULL,
0x0000001013277824ULL, 0x100fe200078e022bULL, 0x00000015281b7210ULL, 0x000fe20007f5e0ffULL,
0x00000010162f7824ULL, 0x100fe200078e022bULL, 0xfffffffc14127812ULL, 0x000fe200078ee221ULL,
0x0000001011237824ULL, 0x100fe200078e022bULL, 0xfffffffc18147812ULL, 0x000fe200078ee221ULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0xfffffffc1a157812ULL, 0x000fe200078ee221ULL,
0x0000001010217824ULL, 0x000fe200078e022bULL, 0x0000000522227c11ULL, 0x000fe2000b0f440fULL,
0x00000010000f7824ULL, 0x100fe200078e022bULL, 0x00000030062d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x000000041f167c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0x000000041d187c11ULL, 0x000fe2000f8240ffULL,
0x0000001014297824ULL, 0x100fe200078e022bULL, 0x0000001728177210ULL, 0x000fe20007f7e0ffULL,
0x0000001012257824ULL, 0x100fe200078e022bULL, 0x0000001928197210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x000000041c147c11ULL, 0x000fe2000f8a40ffULL,
0x00000010152b7824ULL, 0x000fe200078e022bULL, 0x000000051f1f7c11ULL, 0x000fe200080f4410ULL,
0x000000ffff067224ULL, 0x000fe200018e06ffULL, 0x000000051d1d7c11ULL, 0x000fe200088f4400ULL,
0x000000ffff007224ULL, 0x000fe200020e06ffULL, 0x000000242d107210ULL, 0x000fc40007f1e0ffULL,
0x000000041b1a7c11ULL, 0x000fe4000f8240ffULL, 0x000000051c157c11ULL, 0x000fe2000a8f4411ULL,
0x000000ffff117224ULL, 0x000fe200000e0626ULL, 0x00000004171c7c11ULL, 0x000fe4000f8440ffULL,
0x00000004191e7c11ULL, 0x000fe4000f8640ffULL, 0x000000051b1b7c11ULL, 0x000fe200088f4412ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102f7faeULL, 0x0003e2000b901c4cULL,
0x000000202d127210ULL, 0x000fc40007f1e0ffULL, 0x0000000517067c11ULL, 0x000fe400090f4406ULL,
0x000000142d147210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff137224ULL, 0x000fe200000e0622ULL,
0x0000000519007c11ULL, 0x000fe400098f4400ULL, 0x000000162d167210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff157224ULL, 0x000fe200008e0615ULL, 0x000000182d187210ULL, 0x000fe20007f7e0ffULL,
0x00000000120f7faeULL, 0x0003e2000b901c4cULL, 0x0000001a2d1a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e061fULL, 0x0000001c2d1c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff197224ULL, 0x000fe200018e061dULL, 0x0000001e2d1e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200020e061bULL, 0x0000000014217faeULL, 0x0003e2000b901c4cULL,
0x000000ffff1d7224ULL, 0x000fc400028e0606ULL, 0x000000ffff1f7224ULL, 0x000fe200000e0600ULL,
0x0000000016237faeULL, 0x0003e8000b901c4cULL, 0x0000000018257faeULL, 0x0003e8000b901c4cULL,
0x000000001a277faeULL, 0x0003e8000b901c4cULL, 0x000000001c297faeULL, 0x0003e8000b901c4cULL,
0x000000001e2b7faeULL, 0x0003e4000b901c4cULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0106000dff0075a7ULL, 0x000ea2000800014bULL, 0x0000002049007824ULL, 0x000fc800078e0202ULL,
0x0000002000107824ULL, 0x002fe200078e00ffULL, 0x00000003ff067819ULL, 0x000fc80000011600ULL,
0x1ffffffe060f7812ULL, 0x000fe400078ec0ffULL, 0x000001e010107812ULL, 0x000fe400078ec0ffULL,
0x000000070f117812ULL, 0x000fe400078e7800ULL, 0x000000010f137812ULL, 0x000fc600078efcffULL,
0x0000000110117824ULL, 0x000fe200078e0211ULL, 0x0000000713137812ULL, 0x000fc800078e7800ULL,
0x0000000b11117c11ULL, 0x000fe2000f8e20ffULL, 0x0000000110137824ULL, 0x000fe200078e0213ULL,
0x0000003c00e08947ULL, 0x004fec0003800000ULL, 0x0000000b13137c11ULL, 0x000fe2000f8e20ffULL,
0x0000000011187984ULL, 0x000e620000000c00ULL, 0x000000100f0d7836ULL, 0x040fe20000000000ULL,
0x000000070e007c0cULL, 0x000fe2000bf26070ULL, 0x000000110f0f7836ULL, 0x000fe20000000000ULL,
0x0000000013147984ULL, 0x000ea40000000c00ULL, 0x000000070d0d7812ULL, 0x000fe400078e7800ULL,
0x000000070f0f7812ULL, 0x000fc600078e7800ULL, 0x00000001100d7824ULL, 0x040fe400078e020dULL,
0x00000001100f7824ULL, 0x000fc600078e020fULL, 0x0000000b0d007c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b0f0f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff1c7224ULL, 0x002fe400078e0018ULL,
0x000000ffff1d7224ULL, 0x000fe400078e001aULL, 0x000000ffff1e7224ULL, 0x004fe400078e0014ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0016ULL, 0x000000ffff207224ULL, 0x000fc400078e0019ULL,
0x000000ffff217224ULL, 0x000fe200078e001bULL, 0x0000001c11007388ULL, 0x000fe20000000c00ULL,
0x000000ffff227224ULL, 0x000fe400078e0015ULL, 0x000000ffff237224ULL, 0x000fca00078e0017ULL,
0x0000002013007388ULL, 0x000fe80000000c00ULL, 0x000000000f147984ULL, 0x000e680000000c00ULL,
0x0000000000187984ULL, 0x000ea20000000c00ULL, 0x000000ffff277224ULL, 0x002fe400078e0016ULL,
0x000000ffff267224ULL, 0x000fc400078e0014ULL, 0x000000ffff167224ULL, 0x000fe400078e0015ULL,
0x000000ffff247224ULL, 0x004fe400078e0018ULL, 0x000000ffff257224ULL, 0x000fe400078e001aULL,
0x000000ffff147224ULL, 0x000fe400078e0019ULL, 0x000000ffff157224ULL, 0x000fe200078e001bULL,
0x0000002400007388ULL, 0x0003e80000000c00ULL, 0x000000140f007388ULL, 0x0003e20000000c00ULL,
0x01060008ff0c79a7ULL, 0x000ea4000850000bULL, 0x0106000dff0075a7ULL, 0x004ea4000800014bULL,
0x0000003c006c8947ULL, 0x006fea0003800000ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x3d8000000a0a7820ULL, 0x020fe20000410000ULL, 0x0000900000047ab9ULL, 0x000fe20000000800ULL,
0x0000000b49007c11ULL, 0x040fe2000f8e18ffULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x0000000b49067c11ULL, 0x000fe2000f8e28ffULL, 0x000000040b0b7c24ULL, 0x000fe2000f8e02ffULL,
0x000000000a1072caULL, 0x000fe200000e0000ULL, 0xffffffff070f7890ULL, 0x000fdc000fffe03fULL,
0x000001000e0a7824ULL, 0x000fca00078e0207ULL, 0x0000000e0a007c0cULL, 0x000fda000bf01070ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0008ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x00000000003a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000003f00047c82ULL, 0x000fcc0008000000ULL, 0x0000000104057890ULL, 0x000fe2000fffe03fULL,
0x00000008050f7c24ULL, 0x020fe2000f8e02ffULL, 0x00000004000a7c82ULL, 0x000fe40008000000ULL,
0x000000023f097899ULL, 0x000fe40008011605ULL, 0x000000040500788cULL, 0x000fe4000bf06070ULL,
0x0000000500047c82ULL, 0x000fe40008000000ULL, 0x0000000903107c24ULL, 0x000fe2000f8e020eULL,
0x0000000305097892ULL, 0x000fc6000f8ec03fULL, 0x0000000110087836ULL, 0x000fca0000000000ULL,
0x0000000708007c0cULL, 0x000fe4000bf06070ULL, 0x000000010c087812ULL, 0x000fd600078e0cffULL,
0x0000000400c08947ULL, 0x000fea0003800000ULL, 0x00000002ff157819ULL, 0x100fe20000011602ULL,
0x00000100100d7824ULL, 0x000fe200078e0207ULL, 0x00008a0000127ab9ULL, 0x000fe20000000a00ULL,
0x00000003ff3d7819ULL, 0x000fe40000011602ULL, 0x0000000815477836ULL, 0x000fe20000000000ULL,
0x0000000e0d127c48ULL, 0x000fe2000ffe0000ULL, 0x0000000115107824ULL, 0x100fe400078e0209ULL,
0x0000000147147824ULL, 0x000fe400078e0209ULL, 0x00000010154b7836ULL, 0x000fe20000000000ULL,
0x000000100f137210ULL, 0x000fe20007f1e0ffULL, 0x00000001123c7824ULL, 0x000fe200078e0a0dULL,
0x000000140f117210ULL, 0x000fe20007f3e0ffULL, 0x0000000109147824ULL, 0x000fe200078e024bULL,
0x0000000b490d7c11ULL, 0x000fe2000f8e68ffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x0000001213407c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff167224ULL, 0x000fe200008e06ffULL,
0x000000140f147210ULL, 0x000fe20007f5e0ffULL, 0x00000018154c7836ULL, 0x000fe20000000000ULL,
0x0000001313417c11ULL, 0x000fe200080f441cULL, 0x00000028154e7836ULL, 0x000fe20000000000ULL,
0x0000001214127c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x0000001211107c11ULL, 0x000fe2000f8240ffULL, 0x00000020154d7836ULL, 0x000fc40000000000ULL,
0x00000030154f7836ULL, 0x000fe20000000000ULL, 0x0000001314137c11ULL, 0x000fe200080f4413ULL,
0x0000100008147824ULL, 0x000fe200078e020dULL, 0x0000001311117c11ULL, 0x000fe200088f4416ULL,
0x00000009ff167e24ULL, 0x000fe2000f8e00ffULL, 0x0000003c1500720cULL, 0x000fe20003f06070ULL,
0x0000200014427836ULL, 0x000fe40000000000ULL, 0x0000000416517824ULL, 0x000fe200078e00ffULL,
0x000000023d167212ULL, 0x000fe200078e3cffULL, 0x0000000109147824ULL, 0x000fc400078e024cULL,
0x0000003815507836ULL, 0x000fe20000000000ULL, 0x0000000316457812ULL, 0x000fe200078ec0ffULL,
0x00000001091c7824ULL, 0x040fe200078e024eULL, 0x000000140f177210ULL, 0x000fe20007f5e0ffULL,
0x0000000109167824ULL, 0x040fe200078e024dULL, 0x0ffffffc45437812ULL, 0x000fe200078ef802ULL,
0x00000001091e7824ULL, 0x040fe200078e024fULL, 0x0000001c0f1f7210ULL, 0x000fe20007f3e0ffULL,
0x0000000109147824ULL, 0x000fe200078e0250ULL, 0x000000160f3f7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x0000001e0f1d7210ULL, 0x000fe20007f7e0ffULL,
0x0000001043437824ULL, 0x000fe200078e0242ULL, 0x000000140f157210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200028e06ffULL, 0xfffffffc510f7812ULL, 0x000fe200078ee202ULL,
0x000000ffff487224ULL, 0x000fe200008e06ffULL, 0x0000001217167c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff467224ULL, 0x000fe200018e06ffULL, 0x000000121f1e7c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff447224ULL, 0x000fe200010e06ffULL, 0x0000001317177c11ULL, 0x000fe2000a0f441cULL,
0x000000100f407825ULL, 0x000fe200078e0040ULL, 0x000000123f3e7c11ULL, 0x000fc4000f8840ffULL,
0x000000121d1c7c11ULL, 0x000fe2000f8640ffULL, 0x000000100f107825ULL, 0x000fe200078e0010ULL,
0x0000001215147c11ULL, 0x000fe2000f8440ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040437faeULL, 0x0003e2000c101c4cULL, 0x000000133f3f7c11ULL, 0x000fe2000a0f444aULL,
0x000000100f127825ULL, 0x000fe200078e0012ULL, 0x000000131f1f7c11ULL, 0x000fe400088f4448ULL,
0x000000131d1d7c11ULL, 0x000fe200098f4446ULL, 0x000000044f467824ULL, 0x000fe200078e00ffULL,
0x0000001315157c11ULL, 0x000fe200090f4444ULL, 0x000000044b447824ULL, 0x000fe200078e00ffULL,
0x0000003c4700720cULL, 0x080fe20003f06070ULL, 0x000000100f167825ULL, 0x000fe200078e0016ULL,
0x0000003c4b00720cULL, 0x000fc40003f26070ULL, 0x0000003c4c00720cULL, 0x0c0fe20003f46070ULL,
0x000000044c4c7824ULL, 0x000fe200078e00ffULL, 0x0000003c4d00720cULL, 0x0c0fe20003f66070ULL,
0x000000044d407824ULL, 0x002fe200078e00ffULL, 0x0000003c4e00720cULL, 0x0c0fe20003f86070ULL,
0x000000044e4e7824ULL, 0x000fe200078e00ffULL, 0x0000003c4f00720cULL, 0x080fe20003fa6070ULL,
0x000000100f3e7825ULL, 0x000fe200078e003eULL, 0x0000003c5000720cULL, 0x040fe40003fc6070ULL,
0xfffffffc44437812ULL, 0x000fe200078ee245ULL, 0x00000004473c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc4c477812ULL, 0x000fe200078ee245ULL, 0x0000000450507824ULL, 0x000fe200078e00ffULL,
0xfffffffc404b7812ULL, 0x000fe200078ee245ULL, 0x0000001043437824ULL, 0x000fe200078e0242ULL,
0xfffffffc3c417812ULL, 0x000fe200078ee245ULL, 0x000000100f1e7825ULL, 0x000fe200078e001eULL,
0xfffffffc4e4d7812ULL, 0x000fc400078ee245ULL, 0xfffffffc464f7812ULL, 0x000fe200078ee245ULL,
0x0000001041417824ULL, 0x100fe200078e0242ULL, 0xfffffffc50517812ULL, 0x000fe200078ee245ULL,
0x0000001047457824ULL, 0x100fe400078e0242ULL, 0x000000104b477824ULL, 0x100fe200078e0242ULL,
0x0000000010417faeULL, 0x0003e2000c101c4cULL, 0x000000104d4b7824ULL, 0x100fe400078e0242ULL,
0x000000104f4d7824ULL, 0x000fe200078e0242ULL, 0x0000000012437faeULL, 0x0003e2000c901c4cULL,
0x000000100f1c7825ULL, 0x000fc600078e001cULL, 0x0000000016457faeULL, 0x0003e2000d101c4cULL,
0x00000010514f7824ULL, 0x000fe400078e0242ULL, 0x000000100f147825ULL, 0x000fe200078e0014ULL,
0x000000003e477faeULL, 0x0003e8000d901c4cULL, 0x000000001e4b7faeULL, 0x0003e8000e101c4cULL,
0x000000001c4d7faeULL, 0x0003e8000e901c4cULL, 0x00000000144f7faeULL, 0x0003e2000f101c4cULL,
0x00000004008c7947ULL, 0x000fea0003800000ULL, 0x0000000802467811ULL, 0x040fe200078ff0ffULL,
0x00008a0000127ab9ULL, 0x000fe20000000a00ULL, 0x0000000902107211ULL, 0x040fe400078ff0ffULL,
0x0000001002487811ULL, 0x000fe200078ff0ffULL, 0x0000000146127824ULL, 0x040fe200078e0209ULL,
0x0000000f10117210ULL, 0x000fe20007f1e0ffULL, 0x0000000446467824ULL, 0x000fe200078e00ffULL,
0x00000018024a7811ULL, 0x000fe400078ff0ffULL, 0x0000000f120d7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x00000012111c7c11ULL, 0x000fc4000f8040ffULL,
0x00000020024c7811ULL, 0x040fe200078ff0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x000000120d127c11ULL, 0x000fe4000f8240ffULL, 0x00000013111d7c11ULL, 0x000fe200080f4414ULL,
0x0000000109147824ULL, 0x000fe200078e024aULL, 0x000000130d137c11ULL, 0x000fe200088f4410ULL,
0x0000000109107824ULL, 0x040fe200078e0248ULL, 0x00000028024e7811ULL, 0x040fe200078ff0ffULL,
0x0000000109167824ULL, 0x040fe200078e024cULL, 0x0000003002507811ULL, 0x000fe200078ff0ffULL,
0x0000000448487824ULL, 0x000fe200078e00ffULL, 0x0000003802527811ULL, 0x000fe200078ff0ffULL,
0x00000001091e7824ULL, 0x040fe200078e024eULL, 0x0000000f10157210ULL, 0x000fe20007f5e0ffULL,
0x00000001093c7824ULL, 0x040fe200078e0250ULL, 0x0000000f14117210ULL, 0x000fe20007f7e0ffULL,
0x00000001093e7824ULL, 0x000fe200078e0252ULL, 0x0000000f161f7210ULL, 0x000fe20007f3e0ffULL,
0x000000044a4a7824ULL, 0x000fe200078e00ffULL, 0x0000000f1e177210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1e7224ULL, 0x000fe200010e06ffULL, 0x0000001215147c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff167224ULL, 0x000fe200018e06ffULL, 0x0000000f3c0d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff447224ULL, 0x000fe200008e06ffULL, 0x0000001211107c11ULL, 0x000fe2000f8a40ffULL,
0x000000ffff427224ULL, 0x000fe200000e06ffULL, 0x0000000f3e3c7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff407224ULL, 0x000fe200018e06ffULL, 0x0000001315157c11ULL, 0x000fe2000a0f441eULL,
0x00000009ff0f7e24ULL, 0x000fe2000f8e00ffULL, 0x000000121f3e7c11ULL, 0x000fe2000f8240ffULL,
0x000000044c4c7824ULL, 0x000fe200078e00ffULL, 0x0000001311117c11ULL, 0x000fe2000a8f4416ULL,
0x000000040f517824ULL, 0x000fe200078e00ffULL, 0x00000012171e7c11ULL, 0x000fe2000f8040ffULL,
0x000000044e4e7824ULL, 0x000fe200078e00ffULL, 0x000000120d167c11ULL, 0x000fe2000f8640ffULL,
0x0000000450507824ULL, 0x000fe200078e00ffULL, 0x00000003ff3d7819ULL, 0x000fe20000011602ULL,
0x0000000452527824ULL, 0x000fe200078e00ffULL, 0x000000131f3f7c11ULL, 0x000fe200088f4444ULL,
0x000000ffff417224ULL, 0x000fe200010e06ffULL, 0x00000013171f7c11ULL, 0x000fc400080f4442ULL,
0x000000130d177c11ULL, 0x000fe400098f4440ULL, 0x000000023d0f7212ULL, 0x000fe400078e3cffULL,
0x0000000b490d7c11ULL, 0x000fe4000f8e68ffULL, 0x000000030f0f7812ULL, 0x000fe400078ec0ffULL,
0xfffffffc51517812ULL, 0x000fe200078ee202ULL, 0x0000100008407824ULL, 0x000fe200078e020dULL,
0xfffffffc46437812ULL, 0x000fc400078ee20fULL, 0xfffffffc48457812ULL, 0x000fe200078ee20fULL,
0x0000200040427836ULL, 0x000fe20000000000ULL, 0xfffffffc4a477812ULL, 0x000fe200078ee20fULL,
0x00000010511c7825ULL, 0x040fe200078e001cULL, 0xfffffffc4c4b7812ULL, 0x000fe400078ee20fULL,
0xfffffffc4e4d7812ULL, 0x000fe200078ee20fULL, 0x0000001051127825ULL, 0x040fe200078e0012ULL,
0xfffffffc504f7812ULL, 0x000fe400078ee20fULL, 0xfffffffc52557812ULL, 0x000fe200078ee20fULL,
0x0000001051147825ULL, 0x000fe200078e0014ULL, 0x0ffffffc0f0f7812ULL, 0x000fc400078ef802ULL,
0x000000123c407c11ULL, 0x000fe2000f8040ffULL, 0x0000001051107825ULL, 0x000fc600078e0010ULL,
0x000000133c417c11ULL, 0x000fe200080f4441ULL, 0x000000100f537824ULL, 0x100fe400078e0242ULL,
0x00000010430f7824ULL, 0x100fe400078e0242ULL, 0x0000001045437824ULL, 0x100fe200078e0242ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c537faeULL, 0x0003e2000b901c4cULL,
0x0000001047457824ULL, 0x100fe400078e0242ULL, 0x000000104b477824ULL, 0x000fe200078e0242ULL,
0x00000000120f7faeULL, 0x0003e2000b901c4cULL, 0x00000010513e7825ULL, 0x000fc600078e003eULL,
0x0000000014437faeULL, 0x0003e2000b901c4cULL, 0x000000104d4b7824ULL, 0x000fe400078e0242ULL,
0x00000010511e7825ULL, 0x000fe200078e001eULL, 0x0000000010457faeULL, 0x0003e6000b901c4cULL,
0x000000104f4d7824ULL, 0x000fe200078e0242ULL, 0x000000003e477faeULL, 0x0003e2000b901c4cULL,
0x0000001051167825ULL, 0x000fc600078e0016ULL, 0x000000001e4b7faeULL, 0x0003e2000b901c4cULL,
0x00000010554f7824ULL, 0x000fe400078e0242ULL, 0x0000001051407825ULL, 0x000fe200078e0040ULL,
0x00000000164d7faeULL, 0x0003e8000b901c4cULL, 0x00000000404f7faeULL, 0x0003e4000b901c4cULL,
0x000000030900788cULL, 0x000fcc000bf25270ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000403047824ULL, 0x000fe400078e0204ULL,
0xffffffffff057424ULL, 0x000fc600078e00ffULL, 0x0000000604007c0cULL, 0x000fda000bf06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00008c00ff107b82ULL, 0x002e620000000a00ULL,
0x000000020b057824ULL, 0x000fc800078e0204ULL, 0x0000000405107825ULL, 0x002fca00078e0010ULL,
0x0000000c10057981ULL, 0x000364000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000020023f7836ULL, 0x042fe20000000000ULL, 0xfffffff8020f7812ULL, 0x000fe200078ec0ffULL,
0x000010000c3c7824ULL, 0x000fe200078e020dULL, 0x0000000702417812ULL, 0x000fe200078ec0ffULL,
0x0000003f00057c82ULL, 0x000fe20008000000ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ec0ffULL,
0x000020003c3c7836ULL, 0x000fe20000000000ULL, 0x000000070f3e7812ULL, 0x000fe400078ef802ULL,
0x000000073f3f7812ULL, 0x000fc400078ef802ULL, 0x00000001ff0d7819ULL, 0x000fe4000001163eULL,
0x00000001ff0c7819ULL, 0x000fe4000001163fULL, 0x00000008410f7812ULL, 0x000fe400078ef802ULL,
0x000000030d0d7812ULL, 0x000fe400078ec0ffULL, 0x000000030c0c7812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fcc0000000000ULL, 0x000000050d117c12ULL, 0x000fe2000f8e3cffULL,
0x0000000105097890ULL, 0x000fe4000fffe03fULL, 0x000000050c147c12ULL, 0x000fe4000f8e3cffULL,
0x000000043e117824ULL, 0x000fc600078e0211ULL, 0x000000043f157824ULL, 0x000fe400078e0214ULL,
0x0000001011117824ULL, 0x100fe400078e023cULL, 0x0000001015157824ULL, 0x000fc800078e023cULL,
0x000000001110783bULL, 0x000e680000000200ULL, 0x000000001514783bULL, 0x000ea20000000200ULL,
0x00000018ff5e7819ULL, 0x002fe20000011411ULL, 0x00010000111d7824ULL, 0x040fe200078e00ffULL,
0x0000888011707816ULL, 0x040fe200000000ffULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011413ULL, 0x00010000101c7824ULL, 0x000fe200078e00ffULL,
0x00008880136c7816ULL, 0x000fe200000000ffULL, 0x0000005e005e7306ULL, 0x000fe20000202400ULL,
0x00000018ff117819ULL, 0x000fc40000011411ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff5c7819ULL, 0x000fe20000011410ULL,
0x0000001100757306ULL, 0x0003e20000202400ULL, 0x00008880105d7816ULL, 0x040fe200000000ffULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x004fe40000011414ULL,
0x0000888014687816ULL, 0x000fc400000000ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000001c00727306ULL, 0x000fe20000202400ULL, 0x0001000013117824ULL, 0x042fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe20000011412ULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x0000888012547816ULL, 0x000fe400000000ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0000001d00777306ULL, 0x000fe20000202400ULL,
0x00000018ff607819ULL, 0x000fc40000011415ULL, 0x0000888015647816ULL, 0x000fe400000000ffULL,
0x00000018ff4c7819ULL, 0x000fe40000011416ULL, 0x0000888016627816ULL, 0x000fe200000000ffULL,
0x0000001100717306ULL, 0x0003e20000202400ULL, 0x00000018ff407819ULL, 0x000fe40000011417ULL,
0x00008880175a7816ULL, 0x000fca00000000ffULL, 0x00000013006a7306ULL, 0x0005e20000202400ULL,
0x000000090d117c12ULL, 0x002fce000f8e3cffULL, 0x0000001000797306ULL, 0x0003e20000202400ULL,
0x000000043e137824ULL, 0x004fe400078e0211ULL, 0x0001000015117824ULL, 0x000fe400078e00ffULL,
0x0000001013137824ULL, 0x000fe400078e023cULL, 0x0000010015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0001000012107824ULL, 0x042fe200078e00ffULL,
0x00000000131c783bULL, 0x000e620000000200ULL, 0x0000010012127824ULL, 0x000fe200078e00ffULL,
0x00000011006b7306ULL, 0x000fe20000202400ULL, 0x00000018ff157819ULL, 0x000fc40000011415ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff127819ULL, 0x000fc60000011412ULL,
0x0000001000737306ULL, 0x0005f00000202400ULL, 0x00000012006e7306ULL, 0x000fe20000202400ULL,
0x0001000014107824ULL, 0x044fe400078e00ffULL, 0x0000010014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000001500697306ULL, 0x0003f00000202400ULL, 0x00000014006d7306ULL, 0x0005e20000202400ULL,
0x000100001d157824ULL, 0x002fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fcc000001141cULL,
0x00000010006f7306ULL, 0x0003e20000202400ULL, 0x0001000017147824ULL, 0x044fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000010017177824ULL, 0x000fe200078e00ffULL,
0x000088801c447816ULL, 0x000fe400000000ffULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff177819ULL, 0x000fe20000011417ULL, 0x0000001500527306ULL, 0x000fe20000202400ULL,
0x000000090c107c12ULL, 0x002fe2000f8e3cffULL, 0x000000050a097291ULL, 0x000fe2000f8e103fULL,
0x00000018ff4b7819ULL, 0x000fe2000001141dULL, 0x0000000205057890ULL, 0x000fe2000fffe03fULL,
0x000088801d4d7816ULL, 0x000fe200000000ffULL, 0x000000043f437824ULL, 0x000fe200078e0210ULL,
0x0000000109097899ULL, 0x000fe2000800063fULL, 0x0000001400617306ULL, 0x0003e20000202400ULL,
0x0001000016107824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001141eULL,
0x0000001043127824ULL, 0x000fe200078e023cULL, 0x000088801e507816ULL, 0x000fe200000000ffULL,
0x0000010016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011410ULL,
0x000001001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000017005f7306ULL, 0x000fe20000202400ULL,
0x000100001c147824ULL, 0x042fe200078e00ffULL, 0x000000001210783bULL, 0x000e620000000200ULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x000000040500788cULL, 0x000fe2000bf25270ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000001600637306ULL, 0x0005e20000202400ULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x00000018ff487819ULL, 0x000fe4000001141fULL,
0x000088801f567816ULL, 0x000fe400000000ffULL, 0x000000000000781cULL, 0x000fe20003f0f018ULL,
0x00000014004f7306ULL, 0x0007e20000202400ULL, 0x000100001e167824ULL, 0x044fe400078e00ffULL,
0x000001001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011416ULL,
0x0000005d005d7306ULL, 0x000ea20000202400ULL, 0x0000000902147c11ULL, 0x008fe2000f8fe0ffULL,
0x0000000209097890ULL, 0x000fe2000fffe03fULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x0000000714147812ULL, 0x000fc600078e780fULL, 0x0000005c005c7306ULL, 0x000fe40000202400ULL,
0x000000200f147824ULL, 0x000fca00078e0214ULL, 0x0000000b14147c11ULL, 0x000fe2000f8e20ffULL,
0x0000001c00517306ULL, 0x0007e20000202400ULL, 0x00000018ff477819ULL, 0x002fe40000011410ULL,
0x0000888010587816ULL, 0x000fe400000000ffULL, 0x000000001414783bULL, 0x000e620000000200ULL,
0x00000018ff467819ULL, 0x000fe40000011411ULL, 0x0000001d004e7306ULL, 0x0009e20000202400ULL,
0x000100001f1c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011412ULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fc40000011413ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000007000707306ULL, 0x000fe20000202400ULL,
0x00010000101d7824ULL, 0x010fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fc8000001141fULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c005b7306ULL, 0x0005f00000202400ULL,
0x0000005500557306ULL, 0x000ee20000202400ULL, 0x000054105d1c7816ULL, 0x004fce0000000072ULL,
0x0000005400547306ULL, 0x000ea20000202400ULL, 0x000054106e557816ULL, 0x008fce0000000055ULL,
0x0000001d005d7306ULL, 0x0007e20000202400ULL, 0x0000541054547816ULL, 0x004fce0000000073ULL,
0x0000001e00537306ULL, 0x0005e20000202400ULL, 0x00005410791d7816ULL, 0x008fe2000000005cULL,
0x000000541430723cULL, 0x002fec0000041830ULL, 0x0000006700677306ULL, 0x000e620000202400ULL,
0x00000100101e7824ULL, 0x004fe200078e00ffULL, 0x0000000902107c11ULL, 0x000fe2000f8fe0ffULL,
0x0000001c1438723cULL, 0x000fe20000041838ULL, 0x0000010011547824ULL, 0x000fc400078e00ffULL,
0x0000000710107812ULL, 0x000fe400078e780fULL, 0x0000006c006c7306ULL, 0x000ea20000202400ULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x00005410701c7816ULL, 0x000fe20000000077ULL,
0x000000200f107824ULL, 0x000fe200078e0210ULL, 0x00005410751d7816ULL, 0x000fc6000000005eULL,
0x0000001f00597306ULL, 0x0007e20000202400ULL, 0x0000000b10107c11ULL, 0x000fc6000f8e20ffULL,
0x0000001c1434723cULL, 0x000fe80000041834ULL, 0x0000006600667306ULL, 0x000fe20000202400ULL,
0x00008880111f7816ULL, 0x048fe400000000ffULL, 0x00010000111c7824ULL, 0x000fe200078e00ffULL,
0x000054106a117816ULL, 0x002fe40000000067ULL, 0x000000ffff5e7224ULL, 0x000fe200078e001fULL,
0x00000018ff677819ULL, 0x000fe20000011454ULL, 0x0000006800687306ULL, 0x000e620000202400ULL,
0x00000018ff6e7819ULL, 0x000fc4000001141cULL, 0x0000888012547816ULL, 0x000fca00000000ffULL,
0x0000001e005c7306ULL, 0x0007f00000202400ULL, 0x0000006000607306ULL, 0x000fe20000202400ULL,
0x00000000101c783bULL, 0x0084ee0000000200ULL, 0x0000006400647306ULL, 0x000f220000202400ULL,
0x000054106c107816ULL, 0x004fce0000000071ULL, 0x00000010142c723cULL, 0x000fe2000004182cULL,
0x0000004c004c7306ULL, 0x000fec0000202400ULL, 0x0000541068107816ULL, 0x002fe4000000006fULL,
0x000054106d117816ULL, 0x000fe20000000066ULL, 0x0000006200627306ULL, 0x000fe20000202400ULL,
0x0001000012667824ULL, 0x000fc400078e00ffULL, 0x0000010012127824ULL, 0x000fc600078e00ffULL,
0x000000101428723cULL, 0x000fe20000041828ULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000006500657306ULL, 0x000e620000202400ULL, 0x00000018ff127819ULL, 0x000fc80000011412ULL,
0x0000541064107816ULL, 0x010fe4000000006bULL, 0x0000541069117816ULL, 0x000fe20000000060ULL,
0x0000004000407306ULL, 0x000fec0000202400ULL, 0x000000101424723cULL, 0x000fe40000041824ULL,
0x0000005a005a7306ULL, 0x000eaa0000202400ULL, 0x0000541062107816ULL, 0x002fc40000000065ULL,
0x0000541063117816ULL, 0x000fe2000000004cULL, 0x0000004200427306ULL, 0x000fe20000202400ULL,
0x00008880134c7816ULL, 0x000fca00000000ffULL, 0x000000101420723cULL, 0x000fe40000041820ULL,
0x0000004400447306ULL, 0x000e6a0000202400ULL, 0x000054105a107816ULL, 0x004fe40000000061ULL,
0x000054105f117816ULL, 0x000fe20000000040ULL, 0x0000004b004b7306ULL, 0x000fe20000202400ULL,
0x000000ffff407224ULL, 0x000fca00078e004cULL, 0x000000101418723cULL, 0x000fe40000041818ULL,
0x0000004d004d7306ULL, 0x000eaa0000202400ULL, 0x0001000013117824ULL, 0x040fe200078e00ffULL,
0x0000541044107816ULL, 0x002fe2000000004fULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x0000005000507306ULL, 0x000fe40000202400ULL, 0x00000018ff157819ULL, 0x000fc40000011411ULL,
0x0000541051117816ULL, 0x000fe40000000042ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000005700577306ULL, 0x000e660000202400ULL, 0x000000101c38723cULL, 0x008fea0000041838ULL,
0x0000004800487306ULL, 0x000ee40000202400ULL, 0x000054104d107816ULL, 0x004fc40000000052ULL,
0x000054104e117816ULL, 0x000fe4000000004bULL, 0x0000541050507816ULL, 0x002fe40000000057ULL,
0x0000004000147306ULL, 0x000fe60000202400ULL, 0x000000101c34723cULL, 0x000fe20000041834ULL,
0x0000541059577816ULL, 0x008fc80000000048ULL, 0x0000001500157306ULL, 0x000e700000202400ULL,
0x0000004a004a7306ULL, 0x000ea20000202400ULL, 0x0000541014147816ULL, 0x002fce0000000015ULL,
0x0000004700477306ULL, 0x000e620000202400ULL, 0x0000541053517816ULL, 0x004fce000000004aULL,
0x0000004600467306ULL, 0x000fe20000202400ULL, 0x000000501c30723cULL, 0x000fe20000041830ULL,
0x000054105c597816ULL, 0x002fcc0000000047ULL, 0x0000004500457306ULL, 0x000ff00000202400ULL,
0x0000004300437306ULL, 0x000ff00000202400ULL, 0x0000005600567306ULL, 0x000e700000202400ULL,
0x0000005800587306ULL, 0x000ea20000202400ULL, 0x0000541056567816ULL, 0x002fce000000005bULL,
0x0000005e005e7306ULL, 0x000fe20000202400ULL, 0x000000561c2c723cULL, 0x000fe2000004182cULL,
0x0000541058587816ULL, 0x004fcc000000005dULL, 0x0000006e00557306ULL, 0x000e620000202400ULL,
0x000000581c28723cULL, 0x000fee0000041828ULL, 0x0000006700677306ULL, 0x000ea20000202400ULL,
0x000054105e5e7816ULL, 0x002fce0000000055ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x00005410675f7816ULL, 0x004fce0000000046ULL, 0x0000006600697306ULL, 0x000e620000202400ULL,
0x0000005e1c24723cULL, 0x000fee0000041824ULL, 0x0000001200127306ULL, 0x000ea20000202400ULL,
0x0000541054447816ULL, 0x002fce0000000069ULL, 0x0000001300107306ULL, 0x000e620000202400ULL,
0x0000541012457816ULL, 0x004fce0000000045ULL, 0x000000441c20723cULL, 0x000fe20000041820ULL,
0x0000541010157816ULL, 0x002fce0000000043ULL, 0x000000141c18723cULL, 0x000fe20000041818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff0002c0947ULL, 0x000fde000383ffffULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000000ffff0c7224ULL, 0x000fd800078e0008ULL,
0xffffffe000388947ULL, 0x000fea000383ffffULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000b491c7c11ULL, 0x000fe2000f8e38ffULL, 0x0000000402107824ULL, 0x000fe400078e00ffULL,
0x0000001038157c20ULL, 0x000fe20008410000ULL, 0x0106880f000c79a7ULL, 0x000e62000850003fULL,
0x0000001039397c20ULL, 0x000fe20008410000ULL, 0x000000103a3a7c20ULL, 0x000fe20008410000ULL,
0xfffffff010117812ULL, 0x000fe200078ec0ffULL, 0x000000103b3b7c20ULL, 0x000fe20008410000ULL,
0x0000001034347c20ULL, 0x000fe20008410000ULL, 0x0000001035357c20ULL, 0x000fe20008410000ULL,
0x0000001036367c20ULL, 0x000fe20008410000ULL, 0x0000001037377c20ULL, 0x000fe20008410000ULL,
0x0000001030307c20ULL, 0x000fe20008410000ULL, 0x0000001031317c20ULL, 0x000fe20008410000ULL,
0x0000001032327c20ULL, 0x000fe20008410000ULL, 0x0000001033337c20ULL, 0x000fe20008410000ULL,
0x000000102c2c7c20ULL, 0x000fe20008410000ULL, 0x000000102d2d7c20ULL, 0x000fe20008410000ULL,
0x000000102e2e7c20ULL, 0x000fe20008410000ULL, 0x000000102f2f7c20ULL, 0x000fe20008410000ULL,
0x0000001028287c20ULL, 0x000fe20008410000ULL, 0x0000001029297c20ULL, 0x000fe20008410000ULL,
0x000000102a2a7c20ULL, 0x000fe20008410000ULL, 0x000000102b2b7c20ULL, 0x000fe20008410000ULL,
0x0000001024247c20ULL, 0x000fe20008410000ULL, 0x0000001025257c20ULL, 0x000fe20008410000ULL,
0x0000001026267c20ULL, 0x000fe20008410000ULL, 0x0106880d000075a7ULL, 0x002e62000800017fULL,
0x0000001027277c20ULL, 0x000fe20008410000ULL, 0x0000001020207c20ULL, 0x000fe20008410000ULL,
0x0000001021217c20ULL, 0x000fe20008410000ULL, 0x0000001022227c20ULL, 0x000fe20008410000ULL,
0x0000001023237c20ULL, 0x000fe20008410000ULL, 0x000000011c1c7824ULL, 0x000fc400078e0211ULL,
0x0000001018187c20ULL, 0x000fe20008410000ULL, 0x0000001019197c20ULL, 0x000fe20008410000ULL,
0x000000101a1e7c20ULL, 0x000fe20008410000ULL, 0x000000101b1d7c20ULL, 0x000fe20008410000ULL,
0x0000001800a88947ULL, 0x002fec0003800000ULL, 0x010400001c107984ULL, 0x0002a20000000c00ULL,
0x0000000f0e007c0cULL, 0x000fda000bf05270ULL, 0x0000000400080947ULL, 0x002fea0003800000ULL,
0x00000002020c7824ULL, 0x000fe200078e00ffULL, 0x0000000e0a0a7c10ULL, 0x000fc8000fffe1ffULL,
0x000000060c0d7812ULL, 0x000fc800078ec0ffULL, 0x000000010d177812ULL, 0x040fe400078efcffULL,
0x000000080d1b7812ULL, 0x000fe400078efcffULL, 0x0000000a1700720cULL, 0x080fe40003f26070ULL,
0x000000100d177812ULL, 0x000fe400078efcffULL, 0x0000000a1b00720cULL, 0x080fe40003f06070ULL,
0x0000000a1700720cULL, 0x000fc40003fc6070ULL, 0x000000110d1b7812ULL, 0x040fe400078efcffULL,
0x000000180d177812ULL, 0x040fe400078efcffULL, 0x0000000a0d00720cULL, 0x080fe40003f46070ULL,
0x0000000a1b00720cULL, 0x080fe40003fa6070ULL, 0x0000000a1700720cULL, 0x000fe40003f66070ULL,
0x000000090d1f7812ULL, 0x000fc400078efcffULL, 0x000000190d1b7812ULL, 0x040fe400078efcffULL,
0x000000200d177812ULL, 0x000fe400078efcffULL, 0xff7fffff3a3a7808ULL, 0x000fe40005000000ULL,
0xff7fffff15157808ULL, 0x000fe40005000000ULL, 0xff7fffff3b3b7808ULL, 0x000fe40004800000ULL,
0xff7fffff39397808ULL, 0x000fc40004800000ULL, 0x0000000a1f00720cULL, 0x080fe40003f86070ULL,
0x0000000a1b00720cULL, 0x080fe40003f46070ULL, 0x0000000a1700720cULL, 0x000fe40003f26070ULL,
0x000000210d1b7812ULL, 0x040fe400078efcffULL, 0x000000280d177812ULL, 0x000fe400078efcffULL,
0xff7fffff36367808ULL, 0x000fc40004000000ULL, 0xff7fffff34347808ULL, 0x000fe40004000000ULL,
0xff7fffff37377808ULL, 0x000fe40006000000ULL, 0xff7fffff35357808ULL, 0x000fe40006000000ULL,
0x0000000a1b00720cULL, 0x080fe40003f06070ULL, 0x0000000a1700720cULL, 0x000fe40003f86070ULL,
0x000000290d1b7812ULL, 0x000fc400078efcffULL, 0x000000300d177812ULL, 0x000fe400078efcffULL,
0xff7fffff32327808ULL, 0x000fe40007000000ULL, 0xff7fffff30307808ULL, 0x000fe40007000000ULL,
0xff7fffff33337808ULL, 0x000fe40006800000ULL, 0xff7fffff31317808ULL, 0x000fe40006800000ULL,
0x0000000a1b00720cULL, 0x000fc40003fc6070ULL, 0x0000000a1700720cULL, 0x000fe40003fa6070ULL,
0x000000310d1b7812ULL, 0x040fe400078efcffULL, 0x000000380d177812ULL, 0x040fe400078efcffULL,
0x000000390d0d7812ULL, 0x000fe400078efcffULL, 0xff7fffff2e2e7808ULL, 0x000fe40005800000ULL,
0xff7fffff2c2c7808ULL, 0x000fc40005800000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40005000000ULL,
0xff7fffff2d2d7808ULL, 0x000fe40005000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL,
0xff7fffff28287808ULL, 0x000fe40004800000ULL, 0x0000000a1b00720cULL, 0x080fe40003f66070ULL,
0x0000000a1700720cULL, 0x000fc40003f46070ULL, 0x0000000a0d00720cULL, 0x000fe40003f26070ULL,
0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL, 0xff7fffff29297808ULL, 0x000fe40004000000ULL,
0xff7fffff26267808ULL, 0x000fe40006000000ULL, 0xff7fffff24247808ULL, 0x000fe40006000000ULL,
0xff7fffff27277808ULL, 0x000fc40007000000ULL, 0xff7fffff25257808ULL, 0x000fe40007000000ULL,
0xff7fffff22227808ULL, 0x000fe40006800000ULL, 0xff7fffff20207808ULL, 0x000fe40006800000ULL,
0xff7fffff23237808ULL, 0x000fe40005800000ULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff1e1e7808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fce0004800000ULL,
0x0000001510107209ULL, 0x004fe20007810000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000003a110a7209ULL, 0x000fe40007810000ULL, 0x00000039100d7209ULL, 0x000fe40007810000ULL,
0x0000003b0a117209ULL, 0x000fe40007810000ULL, 0x000000340d0a7209ULL, 0x000fe40007810000ULL,
0x00000036110c7209ULL, 0x000fc40007810000ULL, 0x000000350a0d7209ULL, 0x000fe40007810000ULL,
0x000000370c117209ULL, 0x000fe40007810000ULL, 0x000000300d0a7209ULL, 0x000fe40007810000ULL,
0x00000032110c7209ULL, 0x000fe40007810000ULL, 0x000000310a0d7209ULL, 0x000fe40007810000ULL,
0x000000330c117209ULL, 0x000fc40007810000ULL, 0x0000002c0d0a7209ULL, 0x000fe40007810000ULL,
0x0000002e110c7209ULL, 0x000fe40007810000ULL, 0x0000002d0a0d7209ULL, 0x000fe40007810000ULL,
0x0000002f0c117209ULL, 0x000fe40007810000ULL, 0x000000280d0a7209ULL, 0x000fe40007810000ULL,
0x0000002a110c7209ULL, 0x000fc40007810000ULL, 0x000000290a0d7209ULL, 0x000fe40007810000ULL,
0x0000002b0c117209ULL, 0x000fe40007810000ULL, 0x000000240d0a7209ULL, 0x000fe40007810000ULL,
0x00000026110c7209ULL, 0x000fe40007810000ULL, 0x000000250a0d7209ULL, 0x000fe40007810000ULL,
0x000000270c117209ULL, 0x000fc40007810000ULL, 0x000000200d0a7209ULL, 0x000fe40007810000ULL,
0x00000022110c7209ULL, 0x000fe40007810000ULL, 0x000000210a0d7209ULL, 0x000fe40007810000ULL,
0x000000230c117209ULL, 0x000fe40007810000ULL, 0x000000180d0a7209ULL, 0x000fe40007810000ULL,
0x0000001e110c7209ULL, 0x000fc40007810000ULL, 0x000000190a0d7209ULL, 0x000fe40007810000ULL,
0x0000001d0c0c7209ULL, 0x000fe20007810000ULL, 0x0000001604247947ULL, 0x000fec000b800000ULL,
0x0c401f000d0a7f89ULL, 0x000e6800000e0000ULL, 0x0c401f000c117f89ULL, 0x000ea800000e0000ULL,
0x0c401f0012177f89ULL, 0x000ee800000e0000ULL, 0x0c401f0013107f89ULL, 0x000f2200000e0000ULL,
0x0000000a0d147209ULL, 0x002fc40007810000ULL, 0x000000110c167209ULL, 0x004fc60007810000ULL,
0x0c201f0014117f89ULL, 0x000e6200000e0000ULL, 0x0000001712177209ULL, 0x008fc60007810000ULL,
0x0c201f00161b7f89ULL, 0x000ea200000e0000ULL, 0x00000010130a7209ULL, 0x010fc60007810000ULL,
0x0c201f00171a7f89ULL, 0x000ee800000e0000ULL, 0x0c201f000a0d7f89ULL, 0x00092200000e0000ULL,
0x0000001114107209ULL, 0x002fe40007810000ULL, 0x0000001b16117209ULL, 0x004fe40007810000ULL,
0x0000001a17127209ULL, 0x008fce0007810000ULL, 0x3fb8aa3b100c7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b113e7820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe40000000000ULL,
0x3fb8aa3b15157823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b39397823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b35357823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b34347823ULL, 0x000fe2000001080cULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe2000001083eULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe2000001083eULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001083eULL, 0x3fb8aa3b37377823ULL, 0x000fe2000001083eULL,
0x0000001500147308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001080cULL,
0x0000002000387308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b190c7823ULL, 0x000fe2000001080cULL,
0x3fb8aa3b2e1b7823ULL, 0x100fe2000001083eULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001083eULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001083eULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001083eULL,
0x00000018003c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001083eULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001083eULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001083eULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001083eULL, 0x3fb8aa3b1d1d7823ULL, 0x000fc6000001083eULL,
0x0000003900397308ULL, 0x000e700000000800ULL, 0x0000003400167308ULL, 0x000fe20000000800ULL,
0x000000143914723eULL, 0x002fce00000010ffULL, 0x0000003500357308ULL, 0x000e700000000800ULL,
0x0000003a00157308ULL, 0x000fe20000000800ULL, 0x000000163516723eULL, 0x002fce00000010ffULL,
0x0000003b00207308ULL, 0x000e700000000800ULL, 0x0000003600177308ULL, 0x000fe20000000800ULL,
0x000000152015723eULL, 0x002fce00000010ffULL, 0x0000003700187308ULL, 0x000e620000000800ULL,
0x3fb8aa3b2f207823ULL, 0x000fce000001083eULL, 0x00000024001f7308ULL, 0x0005e20000000800ULL,
0x000000171817723eULL, 0x002fce00000010ffULL, 0x0000002500347308ULL, 0x0003e20000000800ULL,
0x00000004ff247e24ULL, 0x004fca000f8e00ffULL, 0x3f8000002424783eULL, 0x000fe400000010ffULL,
0x0000002c001a7308ULL, 0x000fe60000000800ULL, 0x000000ffff257224ULL, 0x002fca00078e0024ULL,
0x0000002d00137308ULL, 0x0002b00000000800ULL, 0x0000000c00437308ULL, 0x000fe20000000800ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00000024142c723cULL, 0x002fe200000418ffULL,
0x0000001a131a723eULL, 0x004fe200000010ffULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b23137823ULL, 0x000fce000001083eULL, 0x0000003100317308ULL, 0x000e700000000800ULL,
0x0000003200197308ULL, 0x000fe20000000800ULL, 0x000000303118723eULL, 0x002fce00000010ffULL,
0x00000033000c7308ULL, 0x000e700000000800ULL, 0x0000001b001b7308ULL, 0x000fe20000000800ULL,
0x000000190c19723eULL, 0x002fce00000010ffULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x3fb8aa3b220c7823ULL, 0x000fe2000001083eULL, 0x0000001f3422723eULL, 0x000fe200000010ffULL,
0x0000000fff1f7424ULL, 0x000fca00078e00ffULL, 0x00000021003f7308ULL, 0x000fe20000000800ULL,
0x0000001b201b723eULL, 0x002fce00000010ffULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x00000024182c723cULL, 0x000fee000004182cULL, 0x0000002900297308ULL, 0x000e700000000800ULL,
0x0000002a00217308ULL, 0x0005e20000000800ULL, 0x000000282920723eULL, 0x002fce00000010ffULL,
0x0000002b00327308ULL, 0x000e620000000800ULL, 0x000000383f28723eULL, 0x000fe400000010ffULL,
0x0000003c432a723eULL, 0x004fca00000010ffULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x000000213221723eULL, 0x002fce00000010ffULL, 0x0000002700277308ULL, 0x000e700000000800ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x000000262723723eULL, 0x002fce00000010ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x00000024202c723cULL, 0x000fee000004182cULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x0000000c1329723eULL, 0x002fce00000010ffULL,
0x0000001d001d7308ULL, 0x000e620000000800ULL, 0xfffffffc020c7812ULL, 0x000fe400078ec0ffULL,
0x0000000d0a137209ULL, 0x010fe40007810000ULL, 0x0000000c1f1f7219ULL, 0x000fe400000006ffULL,
0x0000001e1d2b723eULL, 0x002fce00000010ffULL, 0x00000024282c723cULL, 0x000fde000004182cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x001c1fff2c247589ULL, 0x00026200000e0000ULL,
0x00000000001e7806ULL, 0x000fe200038e0100ULL, 0x000000001f0c73a1ULL, 0x000eb000000e8000ULL,
0x000000001f0473c4ULL, 0x000ee20000004000ULL, 0x0000000000057886ULL, 0x000fc400038e0100ULL,
0x000000051fff7c12ULL, 0x004fda000f80400cULL, 0x0000001204308947ULL, 0x00afea000b800000ULL,
0x001c1fff2e257589ULL, 0x0002a800000e0000ULL, 0x001c1fff26267589ULL, 0x000ee800000e0000ULL,
0x001c1fff00277589ULL, 0x00032400000e0000ULL, 0xfffffff8ff417812ULL, 0x000fe200078ee241ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0014ULL, 0x000000033d1d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2d7224ULL, 0x000fe200078e0016ULL, 0x0000000b491e7c11ULL, 0x000fe2000f8e58ffULL,
0x00000008410c7836ULL, 0x000fe20000000000ULL, 0x000000041d1f7812ULL, 0x002fe200078efcffULL,
0x00000008410a7824ULL, 0x000fe200078e00ffULL, 0x000000071d0d7812ULL, 0x000fe200078e7841ULL,
0x0000a0001e1e7836ULL, 0x000fe20000000000ULL, 0x000000071f417812ULL, 0x000fe200078e7841ULL,
0x000000ffff2e7224ULL, 0x000fe200078e0018ULL, 0x000000071d1d7812ULL, 0x000fe200078e780cULL,
0x000000ffff2f7224ULL, 0x000fe200078e001aULL, 0x000000071f1f7812ULL, 0x000fe200078e780cULL,
0x000000080c0c7824ULL, 0x000fe200078e00ffULL, 0x0000000a0d0d7212ULL, 0x080fe200078efcffULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0x0000000a41417212ULL, 0x000fe200078efcffULL,
0x000000ffff307224ULL, 0x000fe200078e0020ULL, 0x0000000302ff7812ULL, 0x000fe2000780c0ffULL,
0x000000100d0d7824ULL, 0x100fe200078e021eULL, 0x0000000c1d1d7212ULL, 0x080fe200078efcffULL,
0x0000001041417824ULL, 0x000fe200078e021eULL, 0x0000000c1f1f7212ULL, 0x000fe200078efcffULL,
0x000000ffff317224ULL, 0x000fe200078e0022ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000002c0d007844ULL, 0x0003e20000000200ULL, 0x000000ffff327224ULL, 0x000fc400078e0028ULL,
0x000000ffff337224ULL, 0x000fe400078e002aULL, 0x000000ffff157224ULL, 0x000fe400078e0017ULL,
0x000000101d1d7824ULL, 0x100fe200078e021eULL, 0x0000003041007844ULL, 0x0003e20000000200ULL,
0x000000ffff167224ULL, 0x000fe400078e0019ULL, 0x000000ffff177224ULL, 0x000fe400078e001bULL,
0x000000101f1f7824ULL, 0x000fc400078e021eULL, 0x000000ffff187224ULL, 0x000fe200078e0021ULL,
0x000000141d007844ULL, 0x0003e20000000200ULL, 0x000000ffff197224ULL, 0x000fe400078e0023ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0029ULL, 0x000000ffff1b7224ULL, 0x000fe400078e002bULL,
0x00000001030e7824ULL, 0x000fc600078e020eULL, 0x000000181f007844ULL, 0x0003e80000000200ULL,
0x010000101c008388ULL, 0x0003e80000000c00ULL, 0x010200241c008388ULL, 0x01c3e20000000c00ULL,
0x000000070e007c0cULL, 0x000fe2000bf06070ULL, 0x0106080f06ff79a7ULL, 0x0003e2000850003fULL,
0x0106100f06ff79a7ULL, 0x0003e2000850003fULL, 0x0106180f06ff79a7ULL, 0x0003e2000850003fULL,
0x0106200f06ff79a7ULL, 0x0003f2000850003fULL, 0xffffffc800f88947ULL, 0x022fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000bff397e24ULL, 0x000fc8000f8e00ffULL,
0x0106b825390075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x0106b825390095a7ULL, 0x000e64000802007fULL,
0xfffffffc00e89947ULL, 0x002fea000383ffffULL, 0xfffffee0006c7947ULL, 0x004fea000383ffffULL,
0x010608250c0075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x010608250c00a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xfffffee400c07947ULL, 0x020fea000383ffffULL,
0x0000000bff257e24ULL, 0x000fc8000f8e00ffULL, 0x0106a86d250075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106a86d250095a7ULL, 0x000e64000802007fULL, 0xfffffffc00e89947ULL, 0x002fea000383ffffULL,
0xfffffee800bc7947ULL, 0x020fea000383ffffULL, 0x0000000bff117e24ULL, 0x000fc8000f8e00ffULL,
0x0106b87b110075a7ULL, 0x000262000808017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000c95dULL, 0x000fea0003900000ULL, 0x0106b87b1100c5a7ULL, 0x000e64000808007fULL,
0xfffffffc00e8c947ULL, 0x002fea000383ffffULL, 0xfffffefc00187947ULL, 0x000fea000383ffffULL,
0x0000000bff117e24ULL, 0x004fc8000f8e00ffULL, 0x0106b073110075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x0106b0731100a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00e8a947ULL, 0x002fea000383ffffULL,
0xfffffefc008c7947ULL, 0x000fea000383ffffULL, 0x0000000bff297e24ULL, 0x000fc8000f8e00ffULL,
0x0106b825290075a7ULL, 0x0004a2000804017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x0106b8252900a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00e8a947ULL, 0x002fea000383ffffULL, 0xffffff0c00c47947ULL, 0x00afea000383ffffULL,
0x010628250c0075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x010628250c00a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xffffff10001c7947ULL, 0x020fea000383ffffULL,
0x0000000bff277e24ULL, 0x000fc8000f8e00ffULL, 0x0106a86d270075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106a86d270095a7ULL, 0x000e64000802007fULL, 0xfffffffc00e89947ULL, 0x002fea000383ffffULL,
0xffffff1000f87947ULL, 0x020fea000383ffffULL, 0x0000000bff117e24ULL, 0x000fc8000f8e00ffULL,
0x0106b877110075a7ULL, 0x000262000808017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000c95dULL, 0x000fea0003900000ULL, 0x0106b8771100c5a7ULL, 0x000e64000808007fULL,
0xfffffffc00e8c947ULL, 0x002fea000383ffffULL, 0xffffff2400187947ULL, 0x000fea000383ffffULL,
0x0000000bff117e24ULL, 0x002fc8000f8e00ffULL, 0x0106b073110075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106b073110095a7ULL, 0x000e64000802007fULL, 0xfffffffc00e89947ULL, 0x002fea000383ffffULL,
0xffffff2400407947ULL, 0x000fea000383ffffULL, 0x0000000bff297e24ULL, 0x000fc8000f8e00ffULL,
0x0106b825290075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x0106b8252900a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00e8a947ULL, 0x002fea000383ffffULL, 0xffffff3400547947ULL, 0x004fea000383ffffULL,
0x010648250c0075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x010648250c00a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xffffff3400ac7947ULL, 0x020fea000383ffffULL,
0x0000000bff257e24ULL, 0x000fc8000f8e00ffULL, 0x0106a86d250075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106a86d250095a7ULL, 0x000e64000802007fULL, 0xfffffffc00e89947ULL, 0x002fea000383ffffULL,
0xffffff3800847947ULL, 0x020fea000383ffffULL, 0x0000000bff197e24ULL, 0x000fc8000f8e00ffULL,
0x0106b873190075a7ULL, 0x000262000808017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000c95dULL, 0x000fea0003900000ULL, 0x0106b8731900c5a7ULL, 0x000e64000808007fULL,
0xfffffffc00e8c947ULL, 0x002fea000383ffffULL, 0xffffff4800ac7947ULL, 0x000fea000383ffffULL,
0x0000000bff197e24ULL, 0x002fc8000f8e00ffULL, 0x0106b075190075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106b075190095a7ULL, 0x000e64000802007fULL, 0xfffffffc00e89947ULL, 0x002fea000383ffffULL,
0xffffff4800d47947ULL, 0x000fea000383ffffULL, 0x0000000bff3f7e24ULL, 0x000fc8000f8e00ffULL,
0x0106b8253f0075a7ULL, 0x0004a2000804017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x0106b8253f00a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00e8a947ULL, 0x002fea000383ffffULL, 0xffffff5800e07947ULL, 0x00afea000383ffffULL,
0x010668250c0075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x010668250c0095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff5c003c7947ULL, 0x020fea000383ffffULL,
0x0000000bff257e24ULL, 0x000fc8000f8e00ffULL, 0x0106a86d250075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x0106a86d250085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffff6000147947ULL, 0x020fea000383ffffULL, 0x0000000bff1f7e24ULL, 0x000fc8000f8e00ffULL,
0x0106b8751f0075a7ULL, 0x00026200080a017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000d95dULL, 0x000fea0003900000ULL, 0x0106b8751f00d5a7ULL, 0x000e6400080a007fULL,
0xfffffffc00e8d947ULL, 0x002fea000383ffffULL, 0xffffff7000407947ULL, 0x000fea000383ffffULL,
0x0000000bff1d7e24ULL, 0x002fc8000f8e00ffULL, 0x0106b06f1d0075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106b06f1d0095a7ULL, 0x000e64000802007fULL, 0xfffffffc00e89947ULL, 0x002fea000383ffffULL,
0xffffff7000647947ULL, 0x000fea000383ffffULL, 0x0000000bff157e24ULL, 0x000fc8000f8e00ffULL,
0x0106000d150075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x0106000d150085a7ULL, 0x000e64000800007fULL,
0xfffffffc00e88947ULL, 0x002fea000383ffffULL, 0xffffffc000047947ULL, 0x020fea000383ffffULL,
0x0000000bff0f7e24ULL, 0x000fc8000f8e00ffULL, 0x0106000d0f0075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x0106000d0f0085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffffc000787947ULL, 0x020fea000383ffffULL, 0x0106880d000075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x0106880d000085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffe400407947ULL, 0x020fea000383ffffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe400078e000dULL, 0x00000002ff3e7424ULL, 0x000fe400078e00ffULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fce00078e00ffULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0c00003e3c387389ULL, 0x0006e4000000003fULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff3c7224ULL, 0x002fe400078e000cULL, 0x00000002ff3e7424ULL, 0x000fe400078e00ffULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0a7224ULL, 0x004fce00078e0038ULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x0c00003e3c387389ULL, 0x000264000000003fULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000000a0d147209ULL, 0x000fe20007810000ULL, 0x000000ffff3c7224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fce00078e0038ULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x0c00003e3c387389ULL, 0x000264000000003fULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x000000110c167209ULL, 0x000fe20007810000ULL, 0x000000ffff3c7224ULL, 0x000fe400078e0013ULL,
0x000000ffff177224ULL, 0x000fce00078e0038ULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x0c00003e3c387389ULL, 0x000264000000003fULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001712177209ULL, 0x000fe20007810000ULL, 0x000000ffff3c7224ULL, 0x000fe400078e0014ULL,
0x00000001ff3e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff107224ULL, 0x000fce00078e0038ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0c00003e3c387389ULL, 0x000264000000003fULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x00000010130a7209ULL, 0x000fe20007810000ULL,
0x000000ffff3c7224ULL, 0x000fe400078e0016ULL, 0x000000ffff117224ULL, 0x000fce00078e0038ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0c00003e3c387389ULL, 0x000264000000003fULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001114107209ULL, 0x000fe20007810000ULL,
0x000000ffff3c7224ULL, 0x000fe400078e0017ULL, 0x000000ffff1b7224ULL, 0x000fce00078e0038ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0c00003e3c387389ULL, 0x000264000000003fULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001b16117209ULL, 0x000fe20007810000ULL,
0x000000ffff3c7224ULL, 0x000fe400078e000aULL, 0x000000ffff1a7224ULL, 0x000fce00078e0038ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0c00003e3c387389ULL, 0x000264000000003fULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001a17127209ULL, 0x000fe20007810000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0038ULL, 0xffffffe800347947ULL, 0x020fec000383ffffULL,
0x0000006000007945ULL, 0x000fe20003800000ULL, 0x000000ffff277224ULL, 0x000fe400078e00ffULL,
0x00001c1fff0a7424ULL, 0x000fce00078e00ffULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x000000272e277389ULL, 0x0006e4000000000aULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x004fe400078e0027ULL, 0x000000ffff2e7224ULL, 0x002fe400078e0026ULL,
0x000000ffff277224ULL, 0x000fe400078e00ffULL, 0x00001c1fff0a7424ULL, 0x000fce00078e00ffULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x000000272e277389ULL, 0x0006e4000000000aULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0x000000ffff267224ULL, 0x004fe400078e0027ULL,
0x000000ffff2e7224ULL, 0x002fe400078e0000ULL, 0x000000ffff277224ULL, 0x000fe400078e00ffULL,
0x00001c1fff0a7424ULL, 0x000fce00078e00ffULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x000000272e277389ULL, 0x0006e4000000000aULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffec00747947ULL, 0x026fea000383ffffULL,
0x018000003e047836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000004057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000003e00048308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff047807ULL, 0x004fc80004000000ULL,
0x0000000405ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff3eff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff047807ULL, 0x000fc80000000000ULL,
0x0000000405ff7212ULL, 0x000fe4000780c0ffULL, 0x800000003e057812ULL, 0x000fd600078ec0ffULL,
0x0080000005040812ULL, 0x000fe200078efcffULL, 0x000000ffff048224ULL, 0x000fe200078e0005ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000003e00047308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x00cfe400078e0004ULL,
0x000000ffff047224ULL, 0x000fe400078e000bULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffffebc04b47950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL,
0x0000000e00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000f0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000628ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000670ULL, 0x0000000000000a00ULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001070ULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000001090ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000001090ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x00000000000010c0ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001108ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001110ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000014200ULL,
0x0000000e00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015380ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000015390ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015390ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000015390ULL, 0x0000000000000268ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000015a78ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000015a78ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001108ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000014200ULL, 0x0000000000014200ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000015380ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000414ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000015390ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_90_cubin_len = 89032;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
